/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import { RaggedGather } from '@tensorflow/tfjs-core';
import { raggedGatherImplCPU } from '../kernel_utils/shared';
export function raggedGather(args) {
    const { inputs, backend, attrs } = args;
    const { paramsNestedSplits, paramsDenseValues, indices } = inputs;
    const { outputRaggedRank } = attrs;
    const $paramsNestedSplits = paramsNestedSplits.map(t => backend.readSync(t.dataId));
    const $paramsNestedSplitsShapes = paramsNestedSplits.map(t => t.shape);
    const $paramsDenseValues = backend.readSync(paramsDenseValues.dataId);
    const $indices = backend.readSync(indices.dataId);
    const [outputNestedSplits, outputDenseValues, outputDenseValuesShape] = raggedGatherImplCPU($paramsNestedSplits, $paramsNestedSplitsShapes, $paramsDenseValues, paramsDenseValues.shape, paramsDenseValues.dtype, $indices, indices.shape, outputRaggedRank);
    const outputNestedSplitsTensors = outputNestedSplits.map((splits) => backend.makeTensorInfo([splits.length], 'int32', splits));
    const outputDenseValuesTensor = backend.makeTensorInfo(outputDenseValuesShape, paramsDenseValues.dtype, outputDenseValues);
    return outputNestedSplitsTensors.concat([outputDenseValuesTensor]);
}
export const raggedGatherConfig = {
    kernelName: RaggedGather,
    backendName: 'webgl',
    kernelFunc: raggedGather,
};
//# sourceMappingURL=data:application/json;base64,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