/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@tensorflow/tfjs-core")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).tf=t.tf||{},t.tf)}(this,(function(t,e){"use strict";function n(t){if(t&&t.__esModule)return t;var e=Object.create(null);return t&&Object.keys(t).forEach((function(n){if("default"!==n){var s=Object.getOwnPropertyDescriptor(t,n);Object.defineProperty(e,n,s.get?s:{enumerable:!0,get:function(){return t[n]}})}})),e.default=t,e}function s(t,e){return e.forEach((function(e){Object.keys(e).forEach((function(n){if("default"!==n&&!(n in t)){var s=Object.getOwnPropertyDescriptor(e,n);Object.defineProperty(t,n,s.get?s:{enumerable:!0,get:function(){return e[n]}})}}))})),t}var r=n(e);class i extends Error{constructor(t){super(t),Object.setPrototypeOf(this,i.prototype)}}class a extends Error{constructor(t){super(t),Object.setPrototypeOf(this,a.prototype)}}class o extends Error{constructor(t){super(t),Object.setPrototypeOf(this,o.prototype)}}class l extends Error{constructor(t){super(t),Object.setPrototypeOf(this,l.prototype)}}class u extends Error{constructor(t){super(t),Object.setPrototypeOf(this,u.prototype)}}class h{constructor(t){this.maxEntries=t||100,this.cache=new Map}get(t){let e;return this.cache.has(t)&&(e=this.cache.get(t),this.cache.delete(t),this.cache.set(t,e)),e}put(t,e){if(this.cache.has(t))this.cache.delete(t);else if(this.cache.size>=this.maxEntries){const t=this.cache.keys().next().value;this.cache.delete(t)}this.cache.set(t,e)}getMaxEntries(){return this.maxEntries}setMaxEntries(t){if(t<0)throw new Error(`The maxEntries of LRU caches must be at least 0, but got ${t}.`);if(this.maxEntries>t)for(let e=0;e<this.maxEntries-t;e++){const t=this.cache.keys().next().value;this.cache.delete(t)}this.maxEntries=t}}function c(t,e){if(Array.isArray(t)){let n=[];for(let s=0;s<e;s++)n=n.concat(t);return n}{const n=new Array(e);return n.fill(t),n}}function p(t,e){if(!t)throw new u(e)}function d(t,e){let n=0;for(const s of t)s===e&&n++;return n}function f(t){return 1===t.length?t[0]:t}function g(t){return Array.isArray(t)?t:[t]}function m(t){const e=t.replace(/(.)([A-Z][a-z0-9]+)/g,"$1_$2").replace(/([a-z])([A-Z])/g,"$1_$2").toLowerCase();return"_"!==e[0]?e:"private"+e}function b(t){return t.length<=1||-1===t.indexOf("_")?t:t.replace(/[_]+(\w|$)/g,((t,e)=>e.toUpperCase()))}let y={};function w(t){if(null==t)return null;const e={};return e.className=t.getClassName(),e.config=t.getConfig(),e}function k(t){if(null!=t&&"object"==typeof t)if(Array.isArray(t))t.forEach((t=>k(t)));else{const e=Object.keys(t);for(const n of e){const e=t[n];null!=e&&"object"==typeof e&&(Array.isArray(e)||"ndarray"!==e.type||"number"!=typeof e.value?k(e):t[n]=e.value)}}}function v(t,e={},n={},s="object",r=!1){if("string"==typeof t){const r=t;let i;if(r in n)i=n[r];else if(r in y)i=y[r];else if(i=e[r],null==i)throw new o(`Unknown ${s}: ${t}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);return i}{const i=t;if(null==i.className||null==i.config)throw new o(`${s}: Improper config format: ${JSON.stringify(i)}.\n'className' and 'config' must set.`);const a=i.className;let l,u;if(a in n?[l,u]=n[a]:a in y?[l,u]=y.className:a in e&&([l,u]=e[a]),null==l)throw new o(`Unknown ${s}: ${a}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);if(null!=u){const t={};for(const e of Object.keys(y))t[e]=y[e];for(const e of Object.keys(n))t[e]=n[e];i.config.customObjects=t;const e=Object.assign({},y);for(const t of Object.keys(n))y[t]=n[t];k(i.config);const s=u(l,i.config,n,r);return y=Object.assign({},e),s}{const t=Object.assign({},y);for(const t of Object.keys(n))y[t]=n[t];const e=new l(i.config);return y=Object.assign({},t),e}}}function x(t,e){return-1*function(t,e){return t<e?-1:t>e?1:0}(t,e)}function S(t){if(null==t)return t;const e=[];for(const n of t)-1===e.indexOf(n)&&e.push(n);return e}function N(t){if(null==t)throw new o(`Invalid value in obj: ${JSON.stringify(t)}`);for(const e in t)if(t.hasOwnProperty(e))return!1;return!0}function E(t,e,n){if(null!=n&&t.indexOf(n)<0)throw new o(`${n} is not a valid ${e}.  Valid values are ${t} or null/undefined.`)}function I(t,e,n=0,s=1/0){return p(n>=0),p(s>=n),Array.isArray(t)&&t.length>=n&&t.length<=s&&t.every((t=>typeof t===e))}function A(t,n){Array.isArray(t)?(e.util.assert(t.length>0,(()=>`${n} is unexpectedly an empty array.`)),t.forEach(((t,e)=>A(t,`element ${e+1} of ${n}`)))):e.util.assert(Number.isInteger(t)&&t>0,(()=>`Expected ${n} to be a positive integer, but got ${T(t)}.`))}function T(t){return null===t?"null":Array.isArray(t)?"["+t.map((t=>T(t))).join(",")+"]":"string"==typeof t?`"${t}"`:`${t}`}function z(t){return"relu"===t?"relu":"linear"===t?"linear":"elu"===t?"elu":null}let $=0;function C(){return $++}const _={};function D(t=""){return t in _||(_[t]=0),_[t]+=1,t+_[t].toString()}const F=["channelsFirst","channelsLast"],R=["nearest","bilinear"],M=["valid","same","causal"],L=["max","avg"],O=["sum","mul","concat","ave"],B=new Map;function P(t){E(F,"DataFormat",t)}function W(t){E(M,"PaddingMode",t)}function U(t){E(L,"PoolMode",t)}const V=[];function K(t,e){V.push(t);try{const t=e();return V.pop(),t}catch(t){throw V.pop(),t}}function j(t){if(!H(t))throw new Error("Not a valid tensor name: '"+t+"'");return(0===V.length?"":V.join("/")+"/")+t}function q(t){if(!H(t))throw new Error("Not a valid tensor name: '"+t+"'");B.has(t)||B.set(t,0);const e=B.get(t);if(B.set(t,B.get(t)+1),e>0){const n=`${t}_${e}`;return B.set(n,1),n}return t}const G=new RegExp(/^[A-Za-z0-9][-A-Za-z0-9\._\/]*$/);function H(t){return!!t.match(G)}function J(t,e,n){null==e&&(e=0),null==n&&(n=t.length);let s=1;for(let r=e;r<n;++r)s*=t[r];return s}function Z(t){if(0===t.length)return Number.NaN;let e=Number.POSITIVE_INFINITY;for(let n=0;n<t.length;n++){const s=t[n];s<e&&(e=s)}return e}function Y(t){if(0===t.length)return Number.NaN;let e=Number.NEGATIVE_INFINITY;for(let n=0;n<t.length;n++){const s=t[n];s>e&&(e=s)}return e}function X(t,e){if(e<t)throw new o(`end (${e}) < begin (${t}) is forbidden.`);const n=[];for(let s=t;s<e;++s)n.push(s);return n}let Q;function tt(){return null==Q&&(Q=e.backend().epsilon()),Q}function et(t,e){return r.cast(t,e)}function nt(t,e=-1){const n=t.shape.slice();return e<0&&(e=n.length+e+1),n.splice(e,0,1),r.reshape(t,n)}function st(t,n,s){return e.tidy((()=>{switch(t.rank){case 1:return r.slice1d(t,n,s);case 2:return r.slice2d(t,[n,0],[s,t.shape[1]]);case 3:return r.slice3d(t,[n,0,0],[s,t.shape[1],t.shape[2]]);case 4:return r.slice4d(t,[n,0,0,0],[s,t.shape[1],t.shape[2],t.shape[3]]);case 5:return r.slice(t,[n,0,0,0,0],[s,t.shape[1],t.shape[2],t.shape[3],t.shape[4]]);case 6:return r.slice(t,[n,0,0,0,0,0],[s,t.shape[1],t.shape[2],t.shape[3],t.shape[4],t.shape[5]]);default:throw new o(`sliceAlongFirstAxis() received an unsupported tensor rank: ${t.rank}`)}}))}function rt(t,n,s){return e.tidy((()=>{switch(t.rank){case 1:return r.slice1d(t,n,s);case 2:return r.slice2d(t,[0,n],[t.shape[0],s]);case 3:return r.slice3d(t,[0,0,n],[t.shape[0],t.shape[1],s]);case 4:return r.slice4d(t,[0,0,0,n],[t.shape[0],t.shape[1],t.shape[2],s]);default:throw new o(`sliceAlongLastAxis() received an unsupported tensor rank: ${t.rank}`)}}))}function it(t,n,s,i){return e.tidy((()=>{switch(t.rank){case 1:return r.slice1d(t,n,s);case 2:switch(i){case 1:return st(t,n,s);case 2:return rt(t,n,s);default:throw new o(`The axis is not within the rank of the tensor ${i}`)}case 3:switch(i){case 1:return st(t,n,s);case 2:return r.slice3d(t,[0,n,0],[t.shape[0],s,t.shape[2]]);case 3:return rt(t,n,s);default:throw new o(`The axis is not within the rank of the tensor ${i}`)}case 4:switch(i){case 1:return st(t,n,s);case 2:return r.slice4d(t,[0,n,0,0],[t.shape[0],s,t.shape[2],t.shape[3]]);case 3:return r.slice4d(t,[0,0,n,0],[t.shape[0],t.shape[1],s,t.shape[3]]);case 4:return rt(t,n,s);default:throw new o(`The axis is not within the rank of the tensor ${i}`)}default:throw new o(`sliceAlongLastAxis() received an unsupported tensor rank: ${t.rank}`)}}))}function at(t,e=-1){let n;return e<0&&(n=t[0].rank,e=0!==n?n:0),e===t[0].rank&&(e=-1),r.concat(t,e)}function ot(t,e){switch(t.rank){case 1:return r.concat1d([t,e]);case 2:return r.concat2d([t,e],0);case 3:return r.concat3d([t,e],0);case 4:return r.concat4d([t,e],0);default:throw new o(`concatAlongFirstAxis() received an unsupported tensor rank: ${t.rank}`)}}function lt(t,e){if(Array.isArray(e)||(e=[e]),t.rank!==e.length)throw new o(`The length of input n (${e.length}) does not match the number of dimensions in input x (${t.rank})`);return r.tile(t,e)}function ut(t,e=0,n=1,s,i){return r.randomNormal(t,e,n,s,i)}function ht(t,e,n,s){if(t.rank<2||e.rank<2)throw new l(`dot requires both inputs to be rank >= 2 but got x shape = ${t.shape} and y shape = ${e.shape}`);if(e.rank>=3){if(t.shape.slice(-1)[0]!==e.shape.slice(-2)[0])throw new l(`If rank y >= 3, then the second last dim of y must equal the last dim of x but got x shape = ${t.shape} and  y shape = ${e.shape}`)}if(2===t.rank&&2===e.rank){const i=!1,a=!1;return r.fused.matMul({a:t,b:e,transposeA:i,transposeB:a,bias:s?dt(t.rank,s,"channelsLast"):null,activation:n})}{const i=t.shape.slice(),a=i.pop();t=r.reshape(t,[-1,a]);const o=e.shape.slice(),l=o.pop(),u=o.pop(),h=[...o,l],c=Array.from({length:e.rank},((t,n)=>0===n?e.rank-2:n<=e.rank-2?n-1:n));e=r.reshape(r.transpose(e,c),[u,-1]);const p=[...i,...h],d=!1,f=!1;return r.reshape(r.fused.matMul({a:t,b:e,transposeA:d,transposeB:f,bias:s?dt(t.rank,s,"channelsLast"):null,activation:n}),p)}}function ct(t,n,s){return e.tidy((()=>(n=Array.isArray(n)?e.tensor1d(n,"int32"):r.cast(n,"int32"),r.gather(t,n,s))))}function pt(t){return r.mul(t,t)}function dt(t,e,n){const s=e.shape;if(1!==e.rank&&e.rank!==t)throw new o(`Unexpected bias dimensions: ${e.rank}; expected it to be 1 or ${t}`);if(5===t){if("channelsFirst"===n)return 1===s.length?r.reshape(e,[1,s[0],1,1,1]):r.reshape(e,[1,s[3],s[0],s[1],s[2]]);if("channelsLast"===n)return 1===s.length?r.reshape(e,[1,1,1,1,s[0]]):r.reshape(e,[1].concat(s))}else if(4===t){if("channelsFirst"===n)return 1===s.length?r.reshape(e,[1,s[0],1,1]):r.reshape(e,[1,s[2],s[0],s[1]]);if("channelsLast"===n)return 1===s.length?r.reshape(e,[1,1,1,s[0]]):r.reshape(e,[1].concat(s))}else if(3===t){if("channelsFirst"===n)return 1===s.length?r.reshape(e,[1,s[0],1]):r.reshape(e,[1,s[1],s[0]]);if("channelsLast"===n)return 1===s.length?r.reshape(e,[1,1,s[0]]):r.reshape(e,[1].concat(s))}else if(t<3)return e;throw new o(`Unsupported input rank by biasAdd: ${e.rank}`)}function ft(t,n,s){return e.tidy((()=>(null==s&&(s="channelsLast"),P(s),r.add(t,dt(t.rank,n,s)))))}function gt(t,n,s,i){return e.tidy((()=>r.dropout(t,n,s,i)))}function mt(t,e,n=!1){return n?t():e()}const bt=["fanIn","fanOut","fanAvg"],yt=["normal","uniform","truncatedNormal"];class wt extends e.serialization.Serializable{fromConfigUsesCustomObjects(){return!1}getConfig(){return{}}}class kt extends wt{apply(t,n){return e.zeros(t,n)}}kt.className="Zeros",e.serialization.registerClass(kt);class vt extends wt{apply(t,n){return e.ones(t,n)}}vt.className="Ones",e.serialization.registerClass(vt);class xt extends wt{constructor(t){if(super(),"object"!=typeof t)throw new o(`Expected argument of type ConstantConfig but got ${t}`);if(void 0===t.value)throw new o(`config must have value set but got ${t}`);this.value=t.value}apply(t,n){return e.tidy((()=>e.mul(e.scalar(this.value),e.ones(t,n))))}getConfig(){return{value:this.value}}}xt.className="Constant",e.serialization.registerClass(xt);class St extends wt{constructor(t){super(),this.DEFAULT_MINVAL=-.05,this.DEFAULT_MAXVAL=.05,this.minval=t.minval||this.DEFAULT_MINVAL,this.maxval=t.maxval||this.DEFAULT_MAXVAL,this.seed=t.seed}apply(t,n){return e.randomUniform(t,this.minval,this.maxval,n)}getConfig(){return{minval:this.minval,maxval:this.maxval,seed:this.seed}}}St.className="RandomUniform",e.serialization.registerClass(St);class Nt extends wt{constructor(t){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=t.mean||this.DEFAULT_MEAN,this.stddev=t.stddev||this.DEFAULT_STDDEV,this.seed=t.seed}apply(t,e){if("float32"!==(e=e||"float32")&&"int32"!==e)throw new l(`randomNormal does not support dType ${e}.`);return ut(t,this.mean,this.stddev,e,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}Nt.className="RandomNormal",e.serialization.registerClass(Nt);class Et extends wt{constructor(t){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=t.mean||this.DEFAULT_MEAN,this.stddev=t.stddev||this.DEFAULT_STDDEV,this.seed=t.seed}apply(t,n){if("float32"!==(n=n||"float32")&&"int32"!==n)throw new l(`truncatedNormal does not support dType ${n}.`);return e.truncatedNormal(t,this.mean,this.stddev,n,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}Et.className="TruncatedNormal",e.serialization.registerClass(Et);class It extends wt{constructor(t){super(),this.gain=null!=t.gain?t.gain:1}apply(t,n){return e.tidy((()=>{if(2!==t.length||t[0]!==t[1])throw new o("Identity matrix initializer can only be used for 2D square matrices.");return e.mul(this.gain,e.eye(t[0]))}))}getConfig(){return{gain:this.gain}}}It.className="Identity",e.serialization.registerClass(It);class At extends wt{constructor(t){if(super(),t.scale<0)throw new o(`scale must be a positive float. Got: ${t.scale}`);var e;this.scale=null==t.scale?1:t.scale,this.mode=null==t.mode?"fanIn":t.mode,e=this.mode,E(bt,"FanMode",e),this.distribution=null==t.distribution?"normal":t.distribution,function(t){E(yt,"Distribution",t)}(this.distribution),this.seed=t.seed}apply(t,n){const s=function(t,e="channelsLast"){let n,s;if(P(e),2===t.length)n=t[0],s=t[1];else if(-1!==[3,4,5].indexOf(t.length)){if("channelsFirst"===e){const e=J(t,2);n=t[1]*e,s=t[0]*e}else if("channelsLast"===e){const e=J(t,0,t.length-2);n=t[t.length-2]*e,s=t[t.length-1]*e}}else{const e=J(t);n=Math.sqrt(e),s=Math.sqrt(e)}return[n,s]}(t),r=s[0],i=s[1];let a=this.scale;if("fanIn"===this.mode?a/=Math.max(1,r):"fanOut"===this.mode?a/=Math.max(1,i):a/=Math.max(1,(r+i)/2),"normal"===this.distribution){const s=Math.sqrt(a);if("float32"!==(n=n||"float32")&&"int32"!==n)throw new l(`${this.getClassName()} does not support dType ${n}.`);return e.truncatedNormal(t,0,s,n,this.seed)}{const s=Math.sqrt(3*a);return e.randomUniform(t,-s,s,n)}}getConfig(){return{scale:this.scale,mode:this.mode,distribution:this.distribution,seed:this.seed}}}At.className="VarianceScaling",e.serialization.registerClass(At);class Tt extends At{constructor(t){super({scale:1,mode:"fanAvg",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return At.className}}Tt.className="GlorotUniform",e.serialization.registerClass(Tt);class zt extends At{constructor(t){super({scale:1,mode:"fanAvg",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return At.className}}zt.className="GlorotNormal",e.serialization.registerClass(zt);class $t extends At{constructor(t){super({scale:2,mode:"fanIn",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return At.className}}$t.className="HeNormal",e.serialization.registerClass($t);class Ct extends At{constructor(t){super({scale:2,mode:"fanIn",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return At.className}}Ct.className="HeUniform",e.serialization.registerClass(Ct);class _t extends At{constructor(t){super({scale:1,mode:"fanIn",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return At.className}}_t.className="LeCunNormal",e.serialization.registerClass(_t);class Dt extends At{constructor(t){super({scale:1,mode:"fanIn",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return At.className}}Dt.className="LeCunNormal",e.serialization.registerClass(Dt);class Ft extends wt{constructor(t){if(super(),this.DEFAULT_GAIN=1,this.gain=null==t.gain?this.DEFAULT_GAIN:t.gain,this.seed=t.seed,null!=this.seed)throw new l("Random seed is not implemented for Orthogonal Initializer yet.")}apply(t,n){return e.tidy((()=>{if(t.length<2)throw new l("Shape must be at least 2D.");t[0]*t[1]>2e3&&console.warn(`Orthogonal initializer is being called on a matrix with more than 2000 (${t[0]*t[1]}) elements: Slowness may result.`);const n=ut(t[0]>t[1]?[t[1],t[0]]:t,0,1,"float32");let s=e.linalg.gramSchmidt(n);return t[0]>t[1]&&(s=e.transpose(s)),e.mul(this.gain,s)}))}getConfig(){return{gain:this.gain,seed:this.seed}}}Ft.className="Orthogonal",e.serialization.registerClass(Ft);const Rt={constant:"Constant",glorotNormal:"GlorotNormal",glorotUniform:"GlorotUniform",heNormal:"HeNormal",heUniform:"HeUniform",identity:"Identity",leCunNormal:"LeCunNormal",leCunUniform:"LeCunUniform",ones:"Ones",orthogonal:"Orthogonal",randomNormal:"RandomNormal",randomUniform:"RandomUniform",truncatedNormal:"TruncatedNormal",varianceScaling:"VarianceScaling",zeros:"Zeros"};function Mt(t,n={}){return v(t,e.serialization.SerializationMap.getMap().classNameMap,n,"initializer")}function Lt(t){return w(t)}function Ot(t){if("string"==typeof t){const e=t in Rt?Rt[t]:t;if("GlorotNormal"===e)return new zt;if("GlorotUniform"===e)return new Tt;if("HeNormal"===e)return new $t;if("HeUniform"===e)return new Ct;if("LeCunNormal"===e)return new _t;if("LeCunUniform"===e)return new Dt;{const t={};return t.className=e,t.config={},Mt(t)}}return t instanceof wt?t:Mt(t)}function Bt(t){return Array.isArray(t)&&Array.isArray(t[0])}function Pt(t){return 0===t.length?[]:Array.isArray(t[0])?t:[t]}function Wt(t){let e;if(Array.isArray(t)){if(1!==t.length)throw new o(`Expected Tensor length to be 1; got ${t.length}`);e=t[0]}else e=t;return e}function Ut(t){if(Array.isArray(t)&&Array.isArray(t[0])){if(1===t.length)return t[0];throw new o(`Expected exactly 1 Shape; got ${t.length}`)}return t}function Vt(t){let e=0;for(const n of t)0===n.shape.length?e+=1:e+=n.shape.reduce(((t,e)=>t*e));return e}const Kt="Variable";class jt{constructor(t,e="float32",n="Variable",s=!0,i=null){this.dtype=null==e?"float32":e,this.shape=t.shape,this.id=C(),n=null==n?Kt:n,this.originalName=j(n),this.name=q(this.originalName),this.trainable_=s,this.constraint=i,this.val=r.variable(t,this.trainable_,this.name,this.dtype)}read(){return this.assertNotDisposed(),this.val}write(t){return this.assertNotDisposed(),function(t,e){if(t.shape.toString()!==e.shape.toString())throw new Error("Shape mismatch: "+JSON.stringify(t.shape)+" vs. "+JSON.stringify(e.shape))}(this.val,t),this.val.id!==t.id&&(this.val.assign(t),null!=this.constraint&&this.val.assign(this.constraint.apply(this.val))),this}dispose(){this.assertNotDisposed(),this.val.dispose()}assertNotDisposed(){if(this.val.isDisposed)throw new Error(`LayersVariable ${this.name} is already disposed.`)}get trainable(){return this.trainable_}set trainable(t){this.trainable_=t,this.val.trainable=t}}function qt(t){return t.map((t=>t.read()))}function Gt(t){t.forEach((t=>{t[0].write(t[1])}))}class Ht{constructor(t){this.dtype=t.dtype,this.shape=t.shape,null!=t.shape?this.ndim=t.shape.length:this.ndim=t.ndim,this.maxNDim=t.maxNDim,this.minNDim=t.minNDim,this.axes=t.axes||{}}}class Jt{constructor(t,e,n,s,r,i,a){this.dtype=t,this.shape=e,this.sourceLayer=n,this.inputs=s,this.callArgs=r,this.outputTensorIndex=a,this.id=C(),null!=i&&(this.originalName=j(i),this.name=q(this.originalName)),this.rank=e.length}}let Zt=0;class Yt{constructor(t,e){this.callArgs=e,this.id=Zt++,this.outboundLayer=t.outboundLayer,this.inboundLayers=t.inboundLayers,this.nodeIndices=t.nodeIndices,this.tensorIndices=t.tensorIndices,this.inputTensors=t.inputTensors,this.outputTensors=t.outputTensors,this.inputMasks=t.inputMasks,this.outputMasks=t.outputMasks,this.inputShapes=t.inputShapes,this.outputShapes=t.outputShapes;for(const e of t.inboundLayers)null!=e&&e.outboundNodes.push(this);t.outboundLayer.inboundNodes.push(this)}getConfig(){const t=[];for(const e of this.inboundLayers)null!=e?t.push(e.name):t.push(null);return{outboundLayer:this.outboundLayer?this.outboundLayer.name:null,inboundLayers:t,nodeIndices:this.nodeIndices,tensorIndices:this.tensorIndices}}}let Xt=0;class Qt extends e.serialization.Serializable{constructor(t={}){super(),this._callHook=null,this._addedWeightNames=[],this._stateful=!1,this.id=Xt++,this.activityRegularizer=null,this.inputSpec=null,this.supportsMasking=!1,this._trainableWeights=[],this._nonTrainableWeights=[],this._losses=[],this._updates=[],this._built=!1,this.inboundNodes=[],this.outboundNodes=[];let e=t.name;if(!e){const t=this.getClassName();e=m(t)+"_"+D(t)}if(this.name=e,this.trainable_=null==t.trainable||t.trainable,null!=t.inputShape||null!=t.batchInputShape){let e;if(null!=t.batchInputShape)e=t.batchInputShape;else if(null!=t.inputShape){let n=null;null!=t.batchSize&&(n=t.batchSize),e=[n].concat(t.inputShape)}this.batchInputShape=e;let n=t.dtype;null==n&&(n=t.inputDType),null==n&&(n="float32"),this.dtype=n}null!=t.weights?this.initialWeights=t.weights:this.initialWeights=null,this._refCount=null,this.fastWeightInitDuringBuild=!1}static nodeKey(t,e){return t.name+"_ib-"+e.toString()}getNodeAtIndex(t,e){if(0===this.inboundNodes.length)throw new a(`The layer has never been called and thus has no defined ${e}.`);if(this.inboundNodes.length<=t)throw new o(`Asked to get ${e} at node ${t}, but the layer has only ${this.inboundNodes.length} inbound nodes.`);return this.inboundNodes[t]}getInputAt(t){return f(this.getNodeAtIndex(t,"input").inputTensors)}getOutputAt(t){return f(this.getNodeAtIndex(t,"output").outputTensors)}get input(){if(this.inboundNodes.length>1)throw new i(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer input" is ill-defined. Use \`getInputAt(nodeIndex)\` instead.`);if(0===this.inboundNodes.length)throw new i(`Layer ${this.name} is not connected, no input to return.`);return f(this.getNodeAtIndex(0,"input").inputTensors)}get output(){if(0===this.inboundNodes.length)throw new i(`Layer ${this.name} has no inbound nodes.`);if(this.inboundNodes.length>1)throw new i(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer output" is ill-defined. Use \`getOutputAt(nodeIndex)\` instead.`);return f(this.getNodeAtIndex(0,"output").outputTensors)}get losses(){return this._losses}calculateLosses(){return this.losses.map((t=>t()))}get updates(){return this._updates}get built(){return this._built}set built(t){this._built=t}get trainable(){return this.trainable_}set trainable(t){this._trainableWeights.forEach((e=>e.trainable=t)),this.trainable_=t}get trainableWeights(){return this.trainable_?this._trainableWeights.filter((t=>t.trainable)):[]}set trainableWeights(t){this._trainableWeights=t}get nonTrainableWeights(){return this.trainable?this._trainableWeights.filter((t=>!t.trainable)).concat(this._nonTrainableWeights):this._trainableWeights.concat(this._nonTrainableWeights)}set nonTrainableWeights(t){this._nonTrainableWeights=t}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}get stateful(){return this._stateful}resetStates(){if(!this.stateful)throw new Error("Cannot call the resetStates() method of a non-stateful Layer object.")}assertInputCompatibility(t){if(t=g(t),null==this.inputSpec||0===this.inputSpec.length)return;const e=g(this.inputSpec);if(t.length!==e.length)throw new o(`Layer ${this.name} expects ${e.length} inputs, but it received ${t.length} input tensors. Input received: ${t}`);for(let n=0;n<t.length;n++){const s=t[n],r=e[n];if(null==r)continue;const i=s.rank;if(null!=r.ndim&&i!==r.ndim)throw new o(`Input ${n} is incompatible with layer ${this.name}: expected ndim=${r.ndim}, found ndim=${i}`);if(null!=r.maxNDim&&i>r.maxNDim)throw new o(`Input ${n} is incompatible with layer ${this.name}: expected max_ndim=${r.maxNDim}, found ndim=${i}`);if(null!=r.minNDim&&i<r.minNDim)throw new o(`Input ${n} is incompatible with layer ${this.name}: expected min_ndim=${r.minNDim}, found ndim=${i}.`);if(null!=r.dtype&&s.dtype!==r.dtype)throw new o(`Input ${n} is incompatible with layer ${this.name} : expected dtype=${r.dtype}, found dtype=${s.dtype}.`);if(r.axes){const t=s.shape;for(const e in r.axes){const s=Number(e),i=r.axes[e],a=s>=0?t[s]:t[t.length+s];if(null!=i&&-1===[i,null].indexOf(a))throw new o(`Input ${n} is incompatible with layer ${this.name}: expected axis ${s} of input shape to have value ${i} but got shape ${t}.`)}}if(null!=r.shape)for(let t=0;t<r.shape.length;++t){const e=r.shape[t],i=s.shape[t];if(null!=e&&null!=i&&e!==i)throw new o(`Input ${n} is incompatible with layer ${this.name}: expected shape=${r.shape}, found shape=${s.shape}.`)}}}call(t,e){return t}invokeCallHook(t,e){null!=this._callHook&&this._callHook(t,e)}setCallHook(t){this._callHook=t}clearCallHook(){this._callHook=null}apply(t,e){e=e||{},this.assertNotDisposed();const n=g(t);let s=!0;for(const t of n)if(!(t instanceof Jt)){s=!1;break}let r=!0;for(const t of n)if(t instanceof Jt){r=!1;break}if(s===r)throw new o("Arguments to apply() must be all SymbolicTensors or all Tensors");return K(this.name,(()=>{if(!this.built){this.assertInputCompatibility(t);const e=[];for(const n of g(t))e.push(n.shape);this.build(f(e)),this.built=!0,this.initialWeights&&this.setWeights(this.initialWeights),null===this._refCount&&r&&(this._refCount=1)}if(this.assertInputCompatibility(t),r){let s=this.call(t,e);const r=g(s),i=[];for(let t of r)-1!==n.indexOf(t)&&(t=t.clone()),i.push(t);if(s=f(i),null!=this.activityRegularizer)throw new l("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return s}{const n=function(t){t=g(t);const e=[];for(const n of t)e.push(n.shape);return f(e)}(t),s=this.computeOutputShape(n);let r;const i="float32";if(this.warnOnIncompatibleInputShape(Array.isArray(t)?n[0]:n),r=null!=s&&s.length>0&&Array.isArray(s[0])?s.map(((n,s)=>new Jt(i,n,this,g(t),e,this.name,s))):new Jt(i,s,this,g(t),e,this.name),this.addInboundNode(t,r,null,null,n,s,e),this._refCount++,null!=this.activityRegularizer)throw new l("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return r}}))}warnOnIncompatibleInputShape(t){if(null!=this.batchInputShape)if(t.length!==this.batchInputShape.length)console.warn(`The rank of the input tensor provided (shape: ${JSON.stringify(t)}) does not match that of the batchInputShape (${JSON.stringify(this.batchInputShape)}) of the layer ${this.name}`);else{let e=!1;this.batchInputShape.forEach(((n,s)=>{null!=n&&null!=t[s]&&t[s]!==n&&(e=!0)})),e&&console.warn(`The shape of the input tensor (${JSON.stringify(t)}) does not match the expectation of layer ${this.name}: ${JSON.stringify(this.batchInputShape)}`)}}get outputShape(){if(null==this.inboundNodes||0===this.inboundNodes.length)throw new i(`The layer ${this.name} has never been called and thus has no defined output shape.`);const t=[];for(const e of this.inboundNodes){const n=JSON.stringify(e.outputShapes);-1===t.indexOf(n)&&t.push(n)}if(1===t.length){const t=this.inboundNodes[0].outputShapes;return Array.isArray(t)&&Array.isArray(t[0])&&1===t.length?t[0]:t}throw new i(`The layer ${this.name} has multiple inbound nodes with different output shapes. Hence the notion of "output shape" is ill-defined for the layer.`)}countParams(){if(!this.built)throw new a(`You tried to call countParams() on ${this.name}, but the layer is not built yet. Build it first by calling build(batchInputShape).`);return Vt(this.weights)}build(t){this.built=!0}getWeights(t=!1){return qt(t?this.trainableWeights:this.weights)}setWeights(t){e.tidy((()=>{const n=this.weights;if(n.length!==t.length)throw new o(`You called setWeights(weights) on layer "${this.name}" with a weight list of length ${t.length}, but the layer was expecting ${n.length} weights. Provided weights: ${t}...`);if(0===n.length)return;const s=[],r=qt(n);for(let i=0;i<r.length;++i){const a=r[i],l=n[i],u=t[i];if(!e.util.arraysEqual(a.shape,u.shape))throw new o(`Layer weight shape ${a.shape} not compatible with provided weight shape ${u.shape}`);s.push([l,u])}Gt(s)}))}addWeight(t,e,n,s,r,i,a,l){if(-1!==this._addedWeightNames.indexOf(t))throw new o(`Duplicate weight name ${t} for layer ${this.name}`);this._addedWeightNames.push(t),null==n&&(n="float32"),this.fastWeightInitDuringBuild&&(s=null!=l?l():Ot("zeros"));const u=s.apply(e,n),h=new jt(u,n,t,i,a);return u.dispose(),null!=r&&this.addLoss((()=>r.apply(h.read()))),null==i&&(i=!0),i?this._trainableWeights.push(h):this._nonTrainableWeights.push(h),h}setFastWeightInitDuringBuild(t){this.fastWeightInitDuringBuild=t}addLoss(t){null==t||Array.isArray(t)&&0===t.length||(t=g(t),void 0!==this._losses&&null!==this._losses&&this.losses.push(...t))}computeOutputShape(t){return t}computeMask(t,e){if(!this.supportsMasking){if(null!=e){if(!Array.isArray(e))throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);e.forEach((t=>{if(null!=t)throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`)}))}return null}return e}addInboundNode(t,e,n,s,r,i,a=null){const o=g(t);e=g(e),n=g(n),s=g(s),r=Pt(r),i=Pt(i);const l=[],u=[],h=[];for(const t of o)l.push(t.sourceLayer),u.push(t.nodeIndex),h.push(t.tensorIndex);new Yt({outboundLayer:this,inboundLayers:l,nodeIndices:u,tensorIndices:h,inputTensors:o,outputTensors:e,inputMasks:n,outputMasks:s,inputShapes:r,outputShapes:i},a);for(let t=0;t<e.length;t++)e[t].sourceLayer=this,e[t].nodeIndex=this.inboundNodes.length-1,e[t].tensorIndex=t}getConfig(){const t={name:this.name,trainable:this.trainable};return null!=this.batchInputShape&&(t.batchInputShape=this.batchInputShape),null!=this.dtype&&(t.dtype=this.dtype),t}disposeWeights(){return this.weights.forEach((t=>t.dispose())),this.weights.length}assertNotDisposed(){if(0===this._refCount)throw new Error(`Layer '${this.name}' is already disposed.`)}dispose(){if(!this.built)throw new Error(`Cannot dispose Layer ${this.name} because it has not been built yet.`);if(null===this._refCount)throw new Error(`Cannot dispose Layer ${this.name} because it has not been used yet.`);this.assertNotDisposed();let t=0;return 0==--this._refCount&&(t=this.disposeWeights()),{refCountAfterDispose:this._refCount,numDisposedVariables:t}}}function te(t,e,n){if((null==e||null!=n&&n>0)&&(e=t.sourceLayer,n=t.nodeIndex),0===e.inboundNodes.length)return[t];{const t=e.inboundNodes[n];if(0===t.inboundLayers.length)return t.inputTensors;{const e=[];for(let n=0;n<t.inboundLayers.length;n++){const s=te(t.inputTensors[n],t.inboundLayers[n],t.nodeIndices[n]);for(const t of s)-1===e.indexOf(t)&&e.push(t)}return e}}}class ee extends Qt{constructor(t){if(super({dtype:t.dtype,name:null!=t.name?t.name:D("input").toString()}),null==t.batchSize&&(t.batchSize=null),null==t.sparse&&(t.sparse=!1),this.trainable=!1,this.built=!0,this.sparse=t.sparse,null!=t.inputShape&&null!=t.batchInputShape)throw new o("Only provide the inputShape OR batchInputShape argument to inputLayer, not both at the same time.");let e=t.batchInputShape;if(null==e){if(null==t.inputShape)throw new o("An InputLayer should be passed either a `batchInputShape` or an `inputShape`.");e=[t.batchSize].concat(t.inputShape)}else if(null!=t.batchSize)throw new o("Cannot specify batchSize if batchInputShape is specified when creating an InputLayer.");const n=t.dtype||"float32";this.batchInputShape=e,this.dtype=n,this.inputSpec=[{shape:e}];const s=new Jt(this.dtype,this.batchInputShape,this,[],{},this.name);s.nodeIndex=0,s.tensorIndex=0,new Yt({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:[s],outputTensors:[s],inputMasks:[null],outputMasks:[null],inputShapes:[e],outputShapes:[e]})}apply(t,e){throw new o(`Cannot pass any input to an InputLayer's apply() method. InputLayer name: ${this.name}`)}dispose(){return{refCountAfterDispose:this._refCount,numDisposedVariables:0}}getConfig(){return{batchInputShape:this.batchInputShape,dtype:this.dtype,sparse:this.sparse,name:this.name}}}function ne(t){if(null==t.batchShape&&null==t.shape)throw new Error("Please provide to Input either a `shape` or a `batchShape` argument. Note that `shape` does not include the batch dimension.");if(null!=t.batchShape&&null!=t.shape)throw new o("Please provide either a `shape` or `batchShape` argument to Input, but not both.");let e=t.batchShape;null!=t.shape&&null==e&&(e=[null].concat(t.shape));let n=t.dtype;null==n&&(n="float32");return new ee({batchInputShape:e,name:t.name,dtype:n,sparse:t.sparse}).inboundNodes[0].outputTensors[0]}ee.className="InputLayer",e.serialization.registerClass(ee);class se{constructor(t){if(this.id2Value={},this.id2Mask={},this.name2Id={},t instanceof se)for(const e in t.id2Value)this.id2Value[e]=t.id2Value[e],e in t.id2Mask&&(this.id2Mask[e]=t.id2Mask[e]);else{if(null==t)return;for(const e of t)this.add(e.key,e.value)}}add(t,n,s){if(null!=this.id2Value[t.id])throw new o(`Duplicate key: name=${t.name}, id=${t.id}`);return this.id2Value[t.id]=function(t,n){if(null==t.dtype||t.dtype===n.dtype)return n;try{return e.cast(n,t.dtype)}catch(e){throw new o(`The dtype of the feed (${n.dtype}) can not be cast to the dtype of the key '${t.name}' (${t.dtype}).`)}}(t,n),this.name2Id[t.name]=t.id,null!=s&&(this.id2Mask[t.id]=s),this}addFeed(t){this.add(t.key,t.value)}hasKey(t){return null!=this.id2Value[t.id]}names(){return Object.keys(this.name2Id)}getValue(t){if(t instanceof Jt){if(null==this.id2Value[t.id])throw new o(`Nonexistent key: ${t.name}`);return this.id2Value[t.id]}{const e=this.name2Id[t];if(null==e)throw new o(`Feed dict has no SymbolicTensor name: ${t}`);return this.id2Value[e]}}getMask(t){if(t instanceof Jt){if(null==this.id2Value[t.id])throw new o(`Nonexistent key: ${t.name}`);return this.id2Mask[t.id]}{const e=this.name2Id[t];if(null==e)throw new o(`Feed dict has no SymbolicTensor name: ${t}`);return this.id2Mask[e]}}disposeMasks(){null!=this.id2Mask&&e.dispose(this.id2Mask)}}const re=new h,ie=new h;function ae(t,n,s,r){const i=null!=s&&s.training,a=Array.isArray(t),o=a?t:[t],l=o.map((t=>t.name)),u=[],h=n.names();for(const t of l)-1!==h.indexOf(t)?u.push(n.getValue(t)):u.push(null);null!=r&&(r.maxNumTensors=-1/0,r.minNumTensors=1/0);const c=l.join(",")+"|"+n.names().sort().join(",");let p,d=re.get(c);if(null==d){const t=function(t,n){e.util.assert(null!=t&&t.length>0,(()=>"Expected at least one fetch, got none"));let s=[],r={};if(1===t.length){const e=le(t[0],n);s=e.sorted,r=e.recipientMap}else{const e=new Set;for(const i of t){const{sorted:t,recipientMap:a}=le(i,n);for(const n of t)e.has(n.name)||(s.push(n),e.add(n.name));for(const t in a)null==r[t]&&(r[t]=new Set),a[t].forEach((e=>r[t].add(e)))}}return{sorted:s,recipientCounts:oe(r)}}(o,n);d=t.sorted,p=t.recipientCounts,re.put(c,d),ie.put(c,p)}p={},i||Object.assign(p,ie.get(c));const f=new se(n);for(let t=0;t<d.length;++t){if(null!=r){const t=e.memory().numTensors;t>r.maxNumTensors&&(r.maxNumTensors=t),t<r.minNumTensors&&(r.minNumTensors=t)}const a=d[t],o=a.sourceLayer;if(o instanceof ee)continue;const h=[],c=[],m=[];let b=!1;for(const t of a.inputs){const e=f.getValue(t),s=f.getMask(t);h.push(e),c.push(s),null!=s&&(b=!0),i||(p[t.name]--,0!==p[t.name]||n.hasKey(t)||-1!==l.indexOf(t.name)||e.isDisposed||!0===t.sourceLayer.stateful||m.push(e))}b&&((s=s||{}).mask=c[0]);const y=g(o.apply(h,s));let w=null;o.supportsMasking&&(w=o.computeMask(h,c));const k=ue(a),v=Array.isArray(k)?k:[k];for(let t=0;t<v.length;++t){f.hasKey(v[t])||f.add(v[t],y[t],Array.isArray(w)?w[0]:w);const e=l.indexOf(v[t].name);-1!==e&&(u[e]=y[t])}i||e.dispose(m)}return f.disposeMasks(),a?u:u[0]}function oe(t){const e={};for(const n in t)e[n]=t[n].size;return e}function le(t,e){const n=new Set,s=[],r={};for(const t of e.names())n.add(t);const i=[],a=[];for(i.push(t);i.length>0;){const t=i[i.length-1];if(n.has(t.name)){i.pop();continue}const e=a[a.length-1]===i.length-1;if(0===t.inputs.length||e)i.pop(),s.push(t),n.add(t.name),e&&a.pop();else{a.push(i.length-1);for(const e of t.inputs)null==r[e.name]&&(r[e.name]=new Set),r[e.name].add(t.name),n.has(e.name)||i.push(e)}}return{sorted:s,recipientMap:r}}function ue(t){let e;if(1===t.sourceLayer.inboundNodes.length)e=t.sourceLayer.output;else{let n=null;for(let e=0;e<t.sourceLayer.inboundNodes.length;++e)for(const s of t.sourceLayer.inboundNodes[e].outputTensors)if(s.id===t.id){n=e;break}e=t.sourceLayer.getOutputAt(n)}return e}e.env().registerFlag("TOPOLOGICAL_SORT_CACHE_MAX_ENTRIES",(()=>100),(function(t){null!=re&&re.setMaxEntries(t),null!=ie&&ie.setMaxEntries(t)}));const he="Acos",ce="Acosh",pe="Add",de="AddN",fe="ArgMax",ge="ArgMin",me="Asin",be="Asinh",ye="Atan",we="Atanh",ke="Atan2",ve="AvgPool",xe="AvgPool3D",Se="BatchMatMul",Ne="BatchToSpaceND",Ee="Cast",Ie="Ceil",Ae="ClipByValue",Te="ComplexAbs",ze="Concat",$e="Conv2D",Ce="Conv2DBackpropInput",_e="Conv3D",De="Cosh",Fe="Cumsum",Re="DepthwiseConv2dNative",Me="Dilation2D",Le="RealDiv",Oe="ExpandDims",Be="Expm1",Pe="Floor",We="FloorDiv",Ue="FusedBatchNorm",Ve="GatherV2",Ke="GreaterEqual",je="Identity",qe="IsFinite",Ge="IsInf",He="IsNan",Je="LeakyRelu",Ze="Log1p",Ye="Maximum",Xe="MaxPool",Qe="MaxPool3D",tn="Mean",en="Minimum",nn="MirrorPad",sn="Multiply",rn="OnesLike",an="OneHot",on="Pack",ln="PadV2",un="Prelu",hn="Prod",cn="Reciprocal",pn="Relu",dn="Reshape",fn="ResizeNearestNeighbor",gn="ResizeBilinear",mn="Relu6",bn="Reverse",yn="Round",wn="Rsqrt",kn="Select",vn="Selu",xn="Slice",Sn="Sinh",Nn="Sign",En="Sigmoid",In="Softplus",An="Sqrt",Tn="SpaceToBatchND",zn="SplitV",$n="Softmax",Cn="SquaredDifference",_n="Tanh",Dn="Tile",Fn="Transpose",Rn="Unpack",Mn="UnsortedSegmentSum",Ln="ZerosLike",On="Step",Bn="FromPixels",Pn="_FusedMatMul",Wn="FusedConv2D",Un="FusedDepthwiseConv2D";function Vn(t){throw new Error(`'${t}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function Kn(t,e){if(!t)throw new Error("string"==typeof e?e:e())}function jn(t,e,n=""){Kn(Jn(t,e),(()=>n+` Shapes ${t} and ${e} must match`))}function qn(t){Kn(null!=t,(()=>"The input to the tensor constructor must be a non-null value."))}function Gn(t,e=[],n=!1){if(null==e&&(e=[]),Array.isArray(t)||Qn(t)&&!n)for(let s=0;s<t.length;++s)Gn(t[s],e,n);else e.push(t);return e}function Hn(t){if(0===t.length)return 1;let e=t[0];for(let n=1;n<t.length;n++)e*=t[n];return e}function Jn(t,e){if(t===e)return!0;if(null==t||null==e)return!1;if(t.length!==e.length)return!1;for(let n=0;n<t.length;n++)if(t[n]!==e[n])return!1;return!0}function Zn(t){return t%1==0}function Yn(t,e){return e<=t.length?t:t+" ".repeat(e-t.length)}function Xn(t,e){const n=e.length;return Kn((t=null==t?e.map(((t,e)=>e)):[].concat(t)).every((t=>t>=-n&&t<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${t}`)),Kn(t.every((t=>Zn(t))),(()=>`All values in axis param must be integers but got axis ${t}`)),t.map((t=>t<0?n+t:t))}function Qn(t){return t instanceof Float32Array||t instanceof Int32Array||t instanceof Uint8Array||t instanceof Uint8ClampedArray}function ts(t){if("float32"===t||"int32"===t)return 4;if("complex64"===t)return 8;if("bool"===t)return 1;throw new Error(`Unknown dtype ${t}`)}function es(t){return"string"==typeof t||t instanceof String}function ns(t){return Array.isArray(t)?ns(t[0]):t instanceof Float32Array?"float32":t instanceof Int32Array||t instanceof Uint8Array||t instanceof Uint8ClampedArray?"int32":"number"==typeof t?"float32":es(t)?"string":function(t){return"boolean"==typeof t}(t)?"bool":"float32"}function ss(t){return!!(t&&t.constructor&&t.call&&t.apply)}function rs(t){const e=t.length;if(e<2)return[];const n=new Array(e-1);n[e-2]=t[e-1];for(let s=e-3;s>=0;--s)n[s]=n[s+1]*t[s+1];return n}function is(t,e,n,s=!1){const r=new Array;if(1===e.length){const i=e[0]*(s?2:1);for(let e=0;e<i;e++)r[e]=n[t+e]}else{const i=e[0],a=e.slice(1),o=a.reduce(((t,e)=>t*e))*(s?2:1);for(let e=0;e<i;e++)r[e]=is(t+e*o,a,n,s)}return r}function as(t,e,n=!1){if(0===t.length)return e[0];const s=t.reduce(((t,e)=>t*e))*(n?2:1);if(0===s)return[];if(s!==e.length)throw new Error(`[${t}] does not match the input size ${e.length}${n?" for a complex tensor":""}.`);return is(0,t,e,n)}function os(t,e){const n=ls(t,e);for(let t=0;t<n.length;t++)n[t]=1;return n}function ls(t,e){if(null==e||"float32"===e||"complex64"===e)return new Float32Array(t);if("int32"===e)return new Int32Array(t);if("bool"===e)return new Uint8Array(t);throw new Error(`Unknown data type ${e}`)}function us(t){t.forEach((e=>{Kn(Number.isInteger(e)&&e>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${t}].`))}))}function hs(t){return t&&t.then&&"function"==typeof t.then}const cs="tfjsflags";class ps{constructor(t){this.global=t,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=ds,this.populateURLFlags()}setPlatform(t,e){null!=this.platform&&(fs().getBool("IS_TEST")||fs().getBool("PROD")||console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${t}.`)),this.platformName=t,this.platform=e}registerFlag(t,e,n){if(this.flagRegistry[t]={evaluationFn:e,setHook:n},null!=this.urlFlags[t]){const e=this.urlFlags[t];fs().getBool("IS_TEST")||fs().getBool("PROD")||console.warn(`Setting feature override from URL ${t}: ${e}.`),this.set(t,e)}}async getAsync(t){return t in this.flags||(this.flags[t]=await this.evaluateFlag(t)),this.flags[t]}get(t){if(t in this.flags)return this.flags[t];const e=this.evaluateFlag(t);if(hs(e))throw new Error(`Flag ${t} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[t]=e,this.flags[t]}getNumber(t){return this.get(t)}getBool(t){return this.get(t)}getFlags(){return this.flags}get features(){return this.flags}set(t,e){if(null==this.flagRegistry[t])throw new Error(`Cannot set flag ${t} as it has not been registered.`);this.flags[t]=e,null!=this.flagRegistry[t].setHook&&this.flagRegistry[t].setHook(e)}evaluateFlag(t){if(null==this.flagRegistry[t])throw new Error(`Cannot evaluate flag '${t}': no evaluation function found.`);return this.flagRegistry[t].evaluationFn()}setFlags(t){this.flags=Object.assign({},t)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if("undefined"==typeof this.global||"undefined"==typeof this.global.location||"undefined"==typeof this.global.location.search)return;const t=this.getQueryParams(this.global.location.search);if(cs in t){t.tfjsflags.split(",").forEach((t=>{const[e,n]=t.split(":");this.urlFlags[e]=function(t,e){if("true"===(e=e.toLowerCase())||"false"===e)return"true"===e;if(""+ +e===e)return+e;throw new Error(`Could not parse value flag value ${e} for flag ${t}.`)}(e,n)}))}}}function ds(t){const e={};return t.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((t,...n)=>(function(t,e,n){t[decodeURIComponent(e)]=decodeURIComponent(n||"")}(e,n[0],n[1]),n.join("=")))),e}function fs(){return ms}let gs,ms=null;function bs(){if(null==gs){let t;if("undefined"!=typeof window)t=window;else if("undefined"!=typeof global)t=global;else if("undefined"!=typeof process)t=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");t=self}gs=t}return gs}function ys(t,e){const n=function(){const t=bs();return null==t._tfGlobals&&(t._tfGlobals=new Map),t._tfGlobals}();if(n.has(t))return n.get(t);{const s=e();return n.set(t,s),n.get(t)}}function ws(...t){fs().getBool("IS_TEST")||fs().getBool("PROD")||console.warn(...t)}const ks=ys("kernelRegistry",(()=>new Map)),vs=ys("gradRegistry",(()=>new Map));function xs(t,e){const n=function(t,e){return`${e}_${t}`}(t,e);return ks.get(n)}function Ss(t){return vs.get(t)}function Ns(t){const e=ks.entries(),n=[];for(;;){const{done:s,value:r}=e.next();if(s)break;const[i,a]=r,[o]=i.split("_");o===t&&n.push(a)}return n}function Es(t){const{kernelName:e}=t;vs.has(e)&&fs().getBool("DEBUG")&&ws(`Overriding the gradient for '${e}'`),vs.set(e,t)}var Is=Ts,As=null;try{As=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(t){}function Ts(t,e,n){this.low=0|t,this.high=0|e,this.unsigned=!!n}function zs(t){return!0===(t&&t.__isLong__)}Ts.prototype.__isLong__,Object.defineProperty(Ts.prototype,"__isLong__",{value:!0}),Ts.isLong=zs;var $s={},Cs={};function _s(t,e){var n,s,r;return e?(r=0<=(t>>>=0)&&t<256)&&(s=Cs[t])?s:(n=Fs(t,(0|t)<0?-1:0,!0),r&&(Cs[t]=n),n):(r=-128<=(t|=0)&&t<128)&&(s=$s[t])?s:(n=Fs(t,t<0?-1:0,!1),r&&($s[t]=n),n)}function Ds(t,e){if(isNaN(t))return e?Vs:Us;if(e){if(t<0)return Vs;if(t>=Bs)return Hs}else{if(t<=-Ps)return Js;if(t+1>=Ps)return Gs}return t<0?Ds(-t,e).neg():Fs(t%Os|0,t/Os|0,e)}function Fs(t,e,n){return new Ts(t,e,n)}Ts.fromInt=_s,Ts.fromNumber=Ds,Ts.fromBits=Fs;var Rs=Math.pow;function Ms(t,e,n){if(0===t.length)throw Error("empty string");if("NaN"===t||"Infinity"===t||"+Infinity"===t||"-Infinity"===t)return Us;if("number"==typeof e?(n=e,e=!1):e=!!e,(n=n||10)<2||36<n)throw RangeError("radix");var s;if((s=t.indexOf("-"))>0)throw Error("interior hyphen");if(0===s)return Ms(t.substring(1),e,n).neg();for(var r=Ds(Rs(n,8)),i=Us,a=0;a<t.length;a+=8){var o=Math.min(8,t.length-a),l=parseInt(t.substring(a,a+o),n);if(o<8){var u=Ds(Rs(n,o));i=i.mul(u).add(Ds(l))}else i=(i=i.mul(r)).add(Ds(l))}return i.unsigned=e,i}function Ls(t,e){return"number"==typeof t?Ds(t,e):"string"==typeof t?Ms(t,e):Fs(t.low,t.high,"boolean"==typeof e?e:t.unsigned)}Ts.fromString=Ms,Ts.fromValue=Ls;var Os=4294967296,Bs=Os*Os,Ps=Bs/2,Ws=_s(1<<24),Us=_s(0);Ts.ZERO=Us;var Vs=_s(0,!0);Ts.UZERO=Vs;var Ks=_s(1);Ts.ONE=Ks;var js=_s(1,!0);Ts.UONE=js;var qs=_s(-1);Ts.NEG_ONE=qs;var Gs=Fs(-1,2147483647,!1);Ts.MAX_VALUE=Gs;var Hs=Fs(-1,-1,!0);Ts.MAX_UNSIGNED_VALUE=Hs;var Js=Fs(0,-2147483648,!1);Ts.MIN_VALUE=Js;var Zs=Ts.prototype;Zs.toInt=function(){return this.unsigned?this.low>>>0:this.low},Zs.toNumber=function(){return this.unsigned?(this.high>>>0)*Os+(this.low>>>0):this.high*Os+(this.low>>>0)},Zs.toString=function(t){if((t=t||10)<2||36<t)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(Js)){var e=Ds(t),n=this.div(e),s=n.mul(e).sub(this);return n.toString(t)+s.toInt().toString(t)}return"-"+this.neg().toString(t)}for(var r=Ds(Rs(t,6),this.unsigned),i=this,a="";;){var o=i.div(r),l=(i.sub(o.mul(r)).toInt()>>>0).toString(t);if((i=o).isZero())return l+a;for(;l.length<6;)l="0"+l;a=""+l+a}},Zs.getHighBits=function(){return this.high},Zs.getHighBitsUnsigned=function(){return this.high>>>0},Zs.getLowBits=function(){return this.low},Zs.getLowBitsUnsigned=function(){return this.low>>>0},Zs.getNumBitsAbs=function(){if(this.isNegative())return this.eq(Js)?64:this.neg().getNumBitsAbs();for(var t=0!=this.high?this.high:this.low,e=31;e>0&&0==(t&1<<e);e--);return 0!=this.high?e+33:e+1},Zs.isZero=function(){return 0===this.high&&0===this.low},Zs.eqz=Zs.isZero,Zs.isNegative=function(){return!this.unsigned&&this.high<0},Zs.isPositive=function(){return this.unsigned||this.high>=0},Zs.isOdd=function(){return 1==(1&this.low)},Zs.isEven=function(){return 0==(1&this.low)},Zs.equals=function(t){return zs(t)||(t=Ls(t)),(this.unsigned===t.unsigned||this.high>>>31!=1||t.high>>>31!=1)&&(this.high===t.high&&this.low===t.low)},Zs.eq=Zs.equals,Zs.notEquals=function(t){return!this.eq(t)},Zs.neq=Zs.notEquals,Zs.ne=Zs.notEquals,Zs.lessThan=function(t){return this.comp(t)<0},Zs.lt=Zs.lessThan,Zs.lessThanOrEqual=function(t){return this.comp(t)<=0},Zs.lte=Zs.lessThanOrEqual,Zs.le=Zs.lessThanOrEqual,Zs.greaterThan=function(t){return this.comp(t)>0},Zs.gt=Zs.greaterThan,Zs.greaterThanOrEqual=function(t){return this.comp(t)>=0},Zs.gte=Zs.greaterThanOrEqual,Zs.ge=Zs.greaterThanOrEqual,Zs.compare=function(t){if(zs(t)||(t=Ls(t)),this.eq(t))return 0;var e=this.isNegative(),n=t.isNegative();return e&&!n?-1:!e&&n?1:this.unsigned?t.high>>>0>this.high>>>0||t.high===this.high&&t.low>>>0>this.low>>>0?-1:1:this.sub(t).isNegative()?-1:1},Zs.comp=Zs.compare,Zs.negate=function(){return!this.unsigned&&this.eq(Js)?Js:this.not().add(Ks)},Zs.neg=Zs.negate,Zs.add=function(t){zs(t)||(t=Ls(t));var e=this.high>>>16,n=65535&this.high,s=this.low>>>16,r=65535&this.low,i=t.high>>>16,a=65535&t.high,o=t.low>>>16,l=0,u=0,h=0,c=0;return h+=(c+=r+(65535&t.low))>>>16,u+=(h+=s+o)>>>16,l+=(u+=n+a)>>>16,l+=e+i,Fs((h&=65535)<<16|(c&=65535),(l&=65535)<<16|(u&=65535),this.unsigned)},Zs.subtract=function(t){return zs(t)||(t=Ls(t)),this.add(t.neg())},Zs.sub=Zs.subtract,Zs.multiply=function(t){if(this.isZero())return Us;if(zs(t)||(t=Ls(t)),As)return Fs(As.mul(this.low,this.high,t.low,t.high),As.get_high(),this.unsigned);if(t.isZero())return Us;if(this.eq(Js))return t.isOdd()?Js:Us;if(t.eq(Js))return this.isOdd()?Js:Us;if(this.isNegative())return t.isNegative()?this.neg().mul(t.neg()):this.neg().mul(t).neg();if(t.isNegative())return this.mul(t.neg()).neg();if(this.lt(Ws)&&t.lt(Ws))return Ds(this.toNumber()*t.toNumber(),this.unsigned);var e=this.high>>>16,n=65535&this.high,s=this.low>>>16,r=65535&this.low,i=t.high>>>16,a=65535&t.high,o=t.low>>>16,l=65535&t.low,u=0,h=0,c=0,p=0;return c+=(p+=r*l)>>>16,h+=(c+=s*l)>>>16,c&=65535,h+=(c+=r*o)>>>16,u+=(h+=n*l)>>>16,h&=65535,u+=(h+=s*o)>>>16,h&=65535,u+=(h+=r*a)>>>16,u+=e*l+n*o+s*a+r*i,Fs((c&=65535)<<16|(p&=65535),(u&=65535)<<16|(h&=65535),this.unsigned)},Zs.mul=Zs.multiply,Zs.divide=function(t){if(zs(t)||(t=Ls(t)),t.isZero())throw Error("division by zero");var e,n,s;if(As)return this.unsigned||-2147483648!==this.high||-1!==t.low||-1!==t.high?Fs((this.unsigned?As.div_u:As.div_s)(this.low,this.high,t.low,t.high),As.get_high(),this.unsigned):this;if(this.isZero())return this.unsigned?Vs:Us;if(this.unsigned){if(t.unsigned||(t=t.toUnsigned()),t.gt(this))return Vs;if(t.gt(this.shru(1)))return js;s=Vs}else{if(this.eq(Js))return t.eq(Ks)||t.eq(qs)?Js:t.eq(Js)?Ks:(e=this.shr(1).div(t).shl(1)).eq(Us)?t.isNegative()?Ks:qs:(n=this.sub(t.mul(e)),s=e.add(n.div(t)));if(t.eq(Js))return this.unsigned?Vs:Us;if(this.isNegative())return t.isNegative()?this.neg().div(t.neg()):this.neg().div(t).neg();if(t.isNegative())return this.div(t.neg()).neg();s=Us}for(n=this;n.gte(t);){e=Math.max(1,Math.floor(n.toNumber()/t.toNumber()));for(var r=Math.ceil(Math.log(e)/Math.LN2),i=r<=48?1:Rs(2,r-48),a=Ds(e),o=a.mul(t);o.isNegative()||o.gt(n);)o=(a=Ds(e-=i,this.unsigned)).mul(t);a.isZero()&&(a=Ks),s=s.add(a),n=n.sub(o)}return s},Zs.div=Zs.divide,Zs.modulo=function(t){return zs(t)||(t=Ls(t)),As?Fs((this.unsigned?As.rem_u:As.rem_s)(this.low,this.high,t.low,t.high),As.get_high(),this.unsigned):this.sub(this.div(t).mul(t))},Zs.mod=Zs.modulo,Zs.rem=Zs.modulo,Zs.not=function(){return Fs(~this.low,~this.high,this.unsigned)},Zs.and=function(t){return zs(t)||(t=Ls(t)),Fs(this.low&t.low,this.high&t.high,this.unsigned)},Zs.or=function(t){return zs(t)||(t=Ls(t)),Fs(this.low|t.low,this.high|t.high,this.unsigned)},Zs.xor=function(t){return zs(t)||(t=Ls(t)),Fs(this.low^t.low,this.high^t.high,this.unsigned)},Zs.shiftLeft=function(t){return zs(t)&&(t=t.toInt()),0==(t&=63)?this:t<32?Fs(this.low<<t,this.high<<t|this.low>>>32-t,this.unsigned):Fs(0,this.low<<t-32,this.unsigned)},Zs.shl=Zs.shiftLeft,Zs.shiftRight=function(t){return zs(t)&&(t=t.toInt()),0==(t&=63)?this:t<32?Fs(this.low>>>t|this.high<<32-t,this.high>>t,this.unsigned):Fs(this.high>>t-32,this.high>=0?0:-1,this.unsigned)},Zs.shr=Zs.shiftRight,Zs.shiftRightUnsigned=function(t){if(zs(t)&&(t=t.toInt()),0===(t&=63))return this;var e=this.high;return t<32?Fs(this.low>>>t|e<<32-t,e>>>t,this.unsigned):Fs(32===t?e:e>>>t-32,0,this.unsigned)},Zs.shru=Zs.shiftRightUnsigned,Zs.shr_u=Zs.shiftRightUnsigned,Zs.toSigned=function(){return this.unsigned?Fs(this.low,this.high,!1):this},Zs.toUnsigned=function(){return this.unsigned?this:Fs(this.low,this.high,!0)},Zs.toBytes=function(t){return t?this.toBytesLE():this.toBytesBE()},Zs.toBytesLE=function(){var t=this.high,e=this.low;return[255&e,e>>>8&255,e>>>16&255,e>>>24,255&t,t>>>8&255,t>>>16&255,t>>>24]},Zs.toBytesBE=function(){var t=this.high,e=this.low;return[t>>>24,t>>>16&255,t>>>8&255,255&t,e>>>24,e>>>16&255,e>>>8&255,255&e]},Ts.fromBytes=function(t,e,n){return n?Ts.fromBytesLE(t,e):Ts.fromBytesBE(t,e)},Ts.fromBytesLE=function(t,e){return new Ts(t[0]|t[1]<<8|t[2]<<16|t[3]<<24,t[4]|t[5]<<8|t[6]<<16|t[7]<<24,e)},Ts.fromBytesBE=function(t,e){return new Ts(t[4]<<24|t[5]<<16|t[6]<<8|t[7],t[0]<<24|t[1]<<16|t[2]<<8|t[3],e)};const Ys=Is||s({__proto__:null,default:Is},[Is]);function Xs(t){return Ys.fromString(t,!0,16)}function Qs(t,e){if("string"===e)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(t)&&(t=Gn(t)),fs().getBool("DEBUG")&&function(t,e){for(let n=0;n<t.length;n++){const s=t[n];if(isNaN(s)||!isFinite(s))throw Error(`A tensor of type ${e} being uploaded contains ${s}.`)}}(t,e),function(t,e){return t instanceof Float32Array&&"float32"===e||t instanceof Int32Array&&"int32"===e||t instanceof Uint8Array&&"bool"===e}(t,e))return t;if(null==e||"float32"===e||"complex64"===e)return new Float32Array(t);if("int32"===e)return new Int32Array(t);if("bool"===e){const e=new Uint8Array(t.length);for(let n=0;n<e.length;++n)0!==Math.round(t[n])&&(e[n]=1);return e}throw new Error(`Unknown data type ${e}`)}function tr(){return fs().platform.now()}function er(t,e="utf-8"){return e=e||"utf-8",fs().platform.decode(t,e)}Xs("c3a5c85c97cb3127"),Xs("b492b66fbe98f273"),Xs("9ae16a3b2f90404f");class nr{constructor(t,e){this.backendTimer=t,this.logger=e,null==e&&(this.logger=new rr)}profileKernel(t,e,n){let s;const r=()=>{s=n()};let i;const a=tr();if(this.backendTimer.timerAvailable())i=this.backendTimer.time(r);else{r();for(const t of s)t.dataSync();i=Promise.resolve({kernelMs:tr()-a})}if(fs().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let e=0;e<s.length;e++){const n=s[e];n.data().then((e=>{sr(e,n.dtype,t)}))}return{kernelName:t,outputs:s,inputs:e,timeMs:i.then((t=>t.kernelMs)),extraInfo:i.then((t=>null!=t.getExtraProfileInfo?t.getExtraProfileInfo():""))}}logKernelProfile(t){const{kernelName:e,outputs:n,timeMs:s,inputs:r,extraInfo:i}=t;n.forEach((t=>{Promise.all([t.data(),s,i]).then((n=>{this.logger.logKernelProfile(e,t,n[0],n[1],r,n[2])}))}))}}function sr(t,e,n){if("float32"!==e)return!1;for(let e=0;e<t.length;e++){const s=t[e];if(isNaN(s)||!isFinite(s))return console.warn(`Found ${s} in the result of '${n}'`),!0}return!1}class rr{logKernelProfile(t,e,n,s,r,i){const a="number"==typeof s?Yn(`${s}ms`,9):s.error,o=Yn(t,25),l=e.rank,u=e.size,h=Yn(e.shape.toString(),14);let c="";for(const t in r){const n=r[t];if(null!=n){const s=n.shape||e.shape,r=s.length;c+=`${t}: ${r}D ${r>0?s:""} `}}console.log(`%c${o}\t%c${a}\t%c${l}D ${h}\t%c${u}\t%c${c}\t%c${i}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function ir(t,e,n,s){const r=rs(e),i=function(t,e,n,s){const r=Hn(e),i=s[s.length-1],a=new Array(i).fill(0),o=e.length,l="complex64"===n?ur(t):t;if(o>1)for(let t=0;t<r/i;t++){const e=t*i;for(let t=0;t<i;t++)a[t]=Math.max(a[t],ar(l[e+t],0,n).length)}return a}(t,e,n,r),a=e.length,o=lr(t,e,n,r,i),l=["Tensor"];return s&&(l.push(`  dtype: ${n}`),l.push(`  rank: ${a}`),l.push(`  shape: [${e}]`),l.push("  values:")),l.push(o.map((t=>"    "+t)).join("\n")),l.join("\n")}function ar(t,e,n){let s;return s=Array.isArray(t)?`${parseFloat(t[0].toFixed(7))} + ${parseFloat(t[1].toFixed(7))}j`:es(t)?`'${t}'`:"bool"===n?or(t):parseFloat(t.toFixed(7)).toString(),Yn(s,e)}function or(t){return 0===t?"false":"true"}function lr(t,e,n,s,r,i=!0){const a="complex64"===n?2:1,o=e[0],l=e.length;if(0===l){if("complex64"===n){return[ar(ur(t)[0],0,n)]}return"bool"===n?[or(t[0])]:[t[0].toString()]}if(1===l){if(o>20){const e=3*a;let s=Array.from(t.slice(0,e)),i=Array.from(t.slice((o-3)*a,o*a));return"complex64"===n&&(s=ur(s),i=ur(i)),["["+s.map(((t,e)=>ar(t,r[e],n))).join(", ")+", ..., "+i.map(((t,e)=>ar(t,r[o-3+e],n))).join(", ")+"]"]}return["["+("complex64"===n?ur(t):Array.from(t)).map(((t,e)=>ar(t,r[e],n))).join(", ")+"]"]}const u=e.slice(1),h=s.slice(1),c=s[0]*a,p=[];if(o>20){for(let e=0;e<3;e++){const s=e*c,i=s+c;p.push(...lr(t.slice(s,i),u,n,h,r,!1))}p.push("...");for(let e=o-3;e<o;e++){const s=e*c,i=s+c;p.push(...lr(t.slice(s,i),u,n,h,r,e===o-1))}}else for(let e=0;e<o;e++){const s=e*c,i=s+c;p.push(...lr(t.slice(s,i),u,n,h,r,e===o-1))}const d=2===l?",":"";p[0]="["+p[0]+d;for(let t=1;t<p.length-1;t++)p[t]=" "+p[t]+d;let f=",\n";for(let t=2;t<l;t++)f+="\n";return p[p.length-1]=" "+p[p.length-1]+"]"+(i?"":f),p}function ur(t){const e=[];for(let n=0;n<t.length;n+=2)e.push([t[n],t[n+1]]);return e}class hr{constructor(t,e,n){if(this.dtype=e,this.shape=t.slice(),this.size=Hn(t),null!=n){const t=n.length;Kn(t===this.size,(()=>`Length of values '${t}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===e)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||function(t,e){let n=null;if(null==t||"float32"===t)n=new Float32Array(e);else if("int32"===t)n=new Int32Array(e);else if("bool"===t)n=new Uint8Array(e);else{if("string"!==t)throw new Error(`Unknown data type ${t}`);n=new Array(e)}return n}(e,this.size),this.strides=rs(t)}set(t,...e){0===e.length&&(e=[0]),Kn(e.length===this.rank,(()=>`The number of provided coordinates (${e.length}) must match the rank (${this.rank})`));const n=this.locToIndex(e);this.values[n]=t}get(...t){0===t.length&&(t=[0]);let e=0;for(const n of t){if(n<0||n>=this.shape[e]){const e=`Requested out of range element at ${t}.   Buffer shape=${this.shape}`;throw new Error(e)}e++}let n=t[t.length-1];for(let e=0;e<t.length-1;++e)n+=this.strides[e]*t[e];return this.values[n]}locToIndex(t){if(0===this.rank)return 0;if(1===this.rank)return t[0];let e=t[t.length-1];for(let n=0;n<t.length-1;++n)e+=this.strides[n]*t[n];return e}indexToLoc(t){if(0===this.rank)return[];if(1===this.rank)return[t];const e=new Array(this.shape.length);for(let n=0;n<e.length-1;++n)e[n]=Math.floor(t/this.strides[n]),t-=e[n]*this.strides[n];return e[e.length-1]=t,e}get rank(){return this.shape.length}toTensor(){return cr().makeTensor(this.values,this.shape,this.dtype)}}let cr=null,pr=null;class dr{constructor(t,e,n,s){this.kept=!1,this.isDisposedInternal=!1,this.shape=t.slice(),this.dtype=e||"float32",this.size=Hn(t),this.strides=rs(t),this.dataId=n,this.id=s,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const t=await this.data();return pr.buffer(this.shape,this.dtype,t)}bufferSync(){return pr.buffer(this.shape,this.dtype,this.dataSync())}async array(){const t=await this.data();return as(this.shape,t,"complex64"===this.dtype)}arraySync(){return as(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const t=cr().read(this.dataId);if("string"===this.dtype){const e=await t;try{return e.map((t=>er(t)))}catch(t){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return t}dataToGPU(t){return this.throwIfDisposed(),cr().readToGPU(this.dataId,t)}dataSync(){this.throwIfDisposed();const t=cr().readSync(this.dataId);if("string"===this.dtype)try{return t.map((t=>er(t)))}catch(t){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return t}async bytes(){this.throwIfDisposed();const t=await cr().read(this.dataId);return"string"===this.dtype?t:new Uint8Array(t.buffer)}dispose(){this.isDisposed||(cr().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(t=!1){return pr.print(this,t)}clone(){return this.throwIfDisposed(),pr.clone(this)}toString(t=!1){return ir(this.dataSync(),this.shape,this.dtype,t)}cast(t){return this.throwIfDisposed(),pr.cast(this,t)}variable(t=!0,e,n){return this.throwIfDisposed(),cr().makeVariable(this,t,e,n)}}Object.defineProperty(dr,Symbol.hasInstance,{value:t=>!!t&&null!=t.data&&null!=t.dataSync&&null!=t.throwIfDisposed}),ys("Tensor",(()=>dr));class fr extends dr{constructor(t,e,n,s){super(t.shape,t.dtype,t.dataId,s),this.trainable=e,this.name=n}assign(t){if(t.dtype!==this.dtype)throw new Error(`dtype of the new value (${t.dtype}) and previous value (${this.dtype}) must match`);if(!Jn(t.shape,this.shape))throw new Error(`shape of the new value (${t.shape}) and previous value (${this.shape}) must match`);cr().disposeTensor(this),this.dataId=t.dataId,cr().incRef(this,null)}dispose(){cr().disposeVariable(this),this.isDisposedInternal=!0}}var gr,mr,br,yr,wr;Object.defineProperty(fr,Symbol.hasInstance,{value:t=>t instanceof dr&&null!=t.assign&&t.assign instanceof Function}),function(t){t.R0="R0",t.R1="R1",t.R2="R2",t.R3="R3",t.R4="R4",t.R5="R5",t.R6="R6"}(gr||(gr={})),function(t){t.float32="float32",t.int32="int32",t.bool="int32",t.complex64="complex64"}(mr||(mr={})),function(t){t.float32="float32",t.int32="int32",t.bool="bool",t.complex64="complex64"}(br||(br={})),function(t){t.float32="float32",t.int32="float32",t.bool="float32",t.complex64="complex64"}(yr||(yr={})),function(t){t.float32="complex64",t.int32="complex64",t.bool="complex64",t.complex64="complex64"}(wr||(wr={}));const kr={float32:yr,int32:mr,bool:br,complex64:wr};function vr(t,e){if(t.dtype===e.dtype)return[t,e];const n=function(t,e){if("string"===t||"string"===e){if("string"===t&&"string"===e)return"string";throw new Error(`Can not upcast ${t} with ${e}`)}return kr[t][e]}(t.dtype,e.dtype);return[t.cast(n),e.cast(n)]}function xr(t){const e=[];return Sr(t,e,new Set),e}function Sr(t,e,n){if(null==t)return;if(t instanceof dr)return void e.push(t);if(s=t,!Array.isArray(s)&&"object"!=typeof s)return;var s;const r=t;for(const t in r){const s=r[t];n.has(s)||(n.add(s),Sr(s,e,n))}}function Nr(t){return null!=t.kernelName}class Er{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((t=>t.name))))}}}dispose(){for(const t in this.registeredVariables)this.registeredVariables[t].dispose()}}class Ir{constructor(t){this.ENV=t,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new Er}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const t=this.getSortedBackends();for(let e=0;e<t.length;e++){const n=t[e];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:t,asyncInit:e}=this.initializeBackendsAndReturnBest();if(e)throw new Error(`The highest priority backend '${t}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(t)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(t){if(!(t in this.registry)){if(!(t in this.registryFactory))return null;{const{asyncInit:e}=this.initializeBackend(t);if(e)return null}}return this.registry[t]}findBackendFactory(t){return t in this.registryFactory?this.registryFactory[t].factory:null}registerBackend(t,e,n=1){return t in this.registryFactory?(ws(`${t} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[t]={factory:e,priority:n},!0)}async setBackend(t){if(null==this.registryFactory[t])throw new Error(`Backend name '${t}' not found in registry`);if(this.backendName=t,null==this.registry[t]){this.backendInstance=null;const{success:e,asyncInit:n}=this.initializeBackend(t);if(!(n?await e:e))return!1}return this.backendInstance=this.registry[t],this.setupRegisteredKernels(),this.profiler=new nr(this.backendInstance),!0}setupRegisteredKernels(){Ns(this.backendName).forEach((t=>{null!=t.setupFunc&&t.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(t){Ns(t).forEach((e=>{null!=e.disposeFunc&&e.disposeFunc(this.registry[t])}))}initializeBackend(t){const e=this.registryFactory[t];if(null==e)throw new Error(`Cannot initialize backend ${t}, no registration found.`);try{const n=e.factory();if(!n||n instanceof class{refCount(t){return Vn("refCount")}incRef(t){return Vn("incRef")}timerAvailable(){return!0}time(t){return Vn("time")}read(t){return Vn("read")}readSync(t){return Vn("readSync")}readToGPU(t,e){return Vn("readToGPU")}numDataIds(){return Vn("numDataIds")}disposeData(t,e){return Vn("disposeData")}write(t,e,n){return Vn("write")}move(t,e,n,s,r){return Vn("move")}createTensorFromTexture(t,e,n){return Vn("createTensorFromTexture")}memory(){return Vn("memory")}floatPrecision(){return Vn("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return Vn("dispose")}}||"function"!=typeof n.then)return this.registry[t]=n,{success:!0,asyncInit:!1};{const e=++this.pendingBackendInitId,s=n.then((n=>!(e<this.pendingBackendInitId)&&(this.registry[t]=n,this.pendingBackendInit=null,!0))).catch((n=>(e<this.pendingBackendInitId||(this.pendingBackendInit=null,ws(`Initialization of backend ${t} failed`),ws(n.stack||n.message)),!1)));return this.pendingBackendInit=s,{success:s,asyncInit:!0}}}catch(e){return ws(`Initialization of backend ${t} failed`),ws(e.stack||e.message),{success:!1,asyncInit:!1}}}removeBackend(t){if(!(t in this.registryFactory))throw new Error(`${t} backend not found in registry`);this.backendName===t&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,t in this.registry&&(this.disposeRegisteredKernels(t),this.registry[t].dispose(),delete this.registry[t]),delete this.registryFactory[t],this.backendName===t&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((t,e)=>this.registryFactory[e].priority-this.registryFactory[t].priority))}initializeBackendsAndReturnBest(){const t=this.getSortedBackends();for(let e=0;e<t.length;e++){const n=t[e],{success:s,asyncInit:r}=this.initializeBackend(n);if(r||s)return{name:n,asyncInit:r}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(t,e){const n=this.state.tensorInfo.get(e),s=n.backend,r=this.readSync(e),i=s.refCount(e);s.disposeData(e,!0),n.backend=t,t.move(e,r,n.shape,n.dtype,i),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(t,e){let n,s=null;if(null==e){if("function"!=typeof t)throw new Error("Please provide a function to tidy()");e=t}else{if("string"!=typeof t&&!(t instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof e)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");s=t}return this.scopedRun((()=>this.startScope(s)),(()=>this.endScope(n)),(()=>(n=e(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(t,e,n){t();try{const t=n();return e(),t}catch(t){throw e(),t}}nextTensorId(){return Ir.nextTensorId++}nextVariableId(){return Ir.nextVariableId++}clone(t){const e=Ar.runKernel(je,{x:t}),n={x:t};return this.addTapeNode(this.state.activeScope.name,n,[e],(t=>({x:()=>{const e={x:t},n={dtype:"float32"};return Ar.runKernel(Ee,e,n)}})),[],{}),e}runKernel(t,e,n){null==this.backendName&&this.backend;if(!(null!=xs(t,this.backendName)))throw new Error(`Kernel '${t}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:t,inputs:e,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(t,e,n){const s=this.backend.numDataIds();let r=0;n.forEach((t=>{r+="complex64"===t.dtype?3:1}));const i=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],a=s-e-r-i;if(a>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${a} data ids) after running '${t}'`)}runKernelFunc(t){let e,n=[];const s=this.isTapeOn(),r=this.state.numBytes,i=this.state.numTensors;let a,o;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const l=Nr(t)?t.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(Nr(t)){const{kernelName:e,inputs:r,attrs:i}=t;null==this.backendName&&this.backend;const l=xs(e,this.backendName);Kn(null!=l,(()=>`Cannot find registered kernel '${e}' for backend '${this.backendName}'`)),a=()=>{const t=this.backend.numDataIds();o=l.kernelFunc({inputs:r,attrs:i,backend:this.backend});const a=Array.isArray(o)?o:[o];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(e,t,a);const u=a.map((t=>null!=t.rank?t:this.makeTensorFromTensorInfo(t)));if(s){const t=this.getTensorsForGradient(e,r,u);n=this.saveTensorsForBackwardMode(t)}return u}}else{const{forwardFunc:e}=t,r=t=>{s&&(n=t.map((t=>this.keep(this.clone(t)))))};a=()=>{const t=this.backend.numDataIds();o=this.tidy((()=>e(this.backend,r)));const n=Array.isArray(o)?o:[o];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(l,t,n),n}}const{inputs:u,attrs:h}=t,c=Nr(t)?null:t.backwardsFunc;let p;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(p=this.profiler.profileKernel(l,u,(()=>a())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(p),e=p.outputs):e=a()})),s&&this.addTapeNode(l,u,e,c,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:l,bytesAdded:this.state.numBytes-r,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-i,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(u).map((t=>null!=u[t]?u[t].shape:null)),outputShapes:e.map((t=>t.shape)),kernelTimeMs:p.timeMs,extraInfo:p.extraInfo}),Array.isArray(o)?e:e[0]}saveTensorsForBackwardMode(t){const e=t.map((t=>this.keep(this.clone(t))));return e}getTensorsForGradient(t,e,n){const s=Ss(t);if(null!=s){const t=s.inputsToSave||[],r=s.outputsToSave||[];let i;s.saveAllInputs?(Kn(Array.isArray(e),(()=>"saveAllInputs is true, expected inputs to be an array.")),i=Object.keys(e).map((t=>e[t]))):i=t.map((t=>e[t]));const a=n.filter(((t,e)=>r[e]));return i.concat(a)}return[]}makeTensor(t,e,n,s){if(null==t)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",s=s||this.backend;let r=t;"string"===n&&es(t[0])&&(r=t.map((t=>function(t,e="utf-8"){return e=e||"utf-8",fs().platform.encode(t,e)}(t))));const i=s.write(r,e,n),a=new dr(e,n,i,this.nextTensorId());if(this.trackTensor(a,s),"string"===n){const t=this.state.tensorInfo.get(i),e=function(t){if(null==t)return 0;let e=0;return t.forEach((t=>e+=t.length)),e}(r);this.state.numBytes+=e-t.bytes,t.bytes=e}return a}makeTensorFromDataId(t,e,n,s){const r={dataId:t,shape:e,dtype:n=n||"float32"};return this.makeTensorFromTensorInfo(r,s)}makeTensorFromTensorInfo(t,e){const{dataId:n,shape:s,dtype:r}=t,i=new dr(s,r,n,this.nextTensorId());return this.trackTensor(i,e),i}makeVariable(t,e=!0,n,s){n=n||this.nextVariableId().toString(),null!=s&&s!==t.dtype&&(t=t.cast(s));const r=new fr(t,e,n,this.nextTensorId());if(null!=this.state.registeredVariables[r.name])throw new Error(`Variable with name ${r.name} was already registered`);return this.state.registeredVariables[r.name]=r,this.incRef(r,this.backend),r}trackTensor(t,e){this.state.numTensors++,"string"===t.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==t.dtype&&"string"!==t.dtype&&(n=t.size*ts(t.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(t.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(t.dataId,{backend:e||this.backend,dtype:t.dtype,shape:t.shape,bytes:n})),t instanceof fr||this.track(t)}incRef(t,e){this.trackTensor(t,e),this.backend.incRef(t.dataId)}removeDataId(t,e){this.state.tensorInfo.has(t)&&this.state.tensorInfo.get(t).backend===e&&(this.state.tensorInfo.delete(t),this.state.numDataBuffers--)}disposeTensor(t){if(!this.state.tensorInfo.has(t.dataId))return;const e=this.state.tensorInfo.get(t.dataId);if(this.state.numTensors--,"string"===t.dtype&&(this.state.numStringTensors--,this.state.numBytes-=e.bytes),"complex64"!==t.dtype&&"string"!==t.dtype){const e=t.size*ts(t.dtype);this.state.numBytes-=e}e.backend.disposeData(t.dataId)&&this.removeDataId(t.dataId,e.backend)}disposeVariables(){for(const t in this.state.registeredVariables){const e=this.state.registeredVariables[t];this.disposeVariable(e)}}disposeVariable(t){this.disposeTensor(t),null!=this.state.registeredVariables[t.name]&&delete this.state.registeredVariables[t.name]}memory(){const t=this.backend.memory();return t.numTensors=this.state.numTensors,t.numDataBuffers=this.state.numDataBuffers,t.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(t.unreliable=!0,null==t.reasons&&(t.reasons=[]),t.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),t}async profile(t){this.state.profiling=!0;const e=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await t(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((t=>t.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-e,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const t of this.state.activeProfile.kernels)t.kernelTimeMs=await t.kernelTimeMs,t.extraInfo=await t.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(t,e,n,s,r,i){const a={id:this.state.nextTapeNodeId++,kernelName:t,inputs:e,outputs:n,saved:r},o=Ss(t);null!=o&&(s=o.gradFunc),null!=s&&(a.gradient=t=>(t=t.map(((t,e)=>{if(null==t){const t=n[e],s=ls(t.size,t.dtype);return this.makeTensor(s,t.shape,t.dtype)}return t})),s(t.length>1?t:t[0],r,i))),this.state.activeTape.push(a)}keep(t){return t.kept=!0,t}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(t){const e={track:[],name:"unnamed scope",id:this.state.nextScopeId++};t&&(e.name=t),this.state.scopeStack.push(e),this.state.activeScope=e}endScope(t){const e=xr(t),n=new Set(e.map((t=>t.id)));for(let t=0;t<this.state.activeScope.track.length;t++){const e=this.state.activeScope.track[t];e.kept||n.has(e.id)||e.dispose()}const s=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],e.forEach((t=>{t.kept||t.scopeId!==s.id||this.track(t)}))}gradients(t,e,n,s=!1){if(Kn(e.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const r=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",t)));Kn(r instanceof dr,(()=>"The result y returned by f() must be a tensor."));const i=function(t,e,n){const s={},r={};for(let t=0;t<e.length;t++)s[e[t].id]=!0;for(let n=0;n<t.length;n++){const i=t[n],a=i.inputs;for(const t in a){const n=a[t];let o=!1;for(let t=0;t<e.length;t++)if(s[n.id]){i.outputs.forEach((t=>s[t.id]=!0)),o=!0,r[i.id]=!0;break}if(o)break}}const i={};i[n.id]=!0;const a={};for(let e=t.length-1;e>=0;e--){const n=t[e],s=n.inputs;for(let t=0;t<n.outputs.length;t++)if(i[n.outputs[t].id]){for(const t in s)i[s[t].id]=!0,a[n.id]=!0;break}}const o=[];for(let e=0;e<t.length;e++){const n=t[e];if(r[n.id]&&a[n.id]){const t={};for(const e in n.inputs){const r=n.inputs[e];s[r.id]&&(t[e]=r)}const e=Object.assign({},n);e.inputs=t,e.outputs=n.outputs,o.push(e)}}return o}(this.state.activeTape,e,r);if(!s&&0===i.length&&e.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const t={};t[r.id]=null==n?function(t){const e=os(Hn(t),"float32");return Ar.makeTensor(e,t,"float32")}(r.shape):n,function(t,e,n,s){for(let r=e.length-1;r>=0;r--){const i=e[r],a=[];if(i.outputs.forEach((e=>{const n=t[e.id];null!=n?a.push(n):a.push(null)})),null==i.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${i.kernelName}.`);const o=i.gradient(a);for(const e in i.inputs){if(!(e in o))throw new Error(`Cannot backprop through input ${e}. Available gradients found: ${Object.keys(o)}.`);const r=n((()=>o[e]()));if("float32"!==r.dtype)throw new Error(`Error in gradient for op ${i.kernelName}. The gradient of input ${e} must have 'float32' dtype, but has '${r.dtype}'`);const a=i.inputs[e];if(!Jn(r.shape,a.shape))throw new Error(`Error in gradient for op ${i.kernelName}. The gradient of input '${e}' has shape '${r.shape}', which does not match the shape of the input '${a.shape}'`);if(null==t[a.id])t[a.id]=r;else{const e=t[a.id];t[a.id]=s(e,r),e.dispose()}}}}(t,i,(t=>this.tidy(t)),Tr);const s=e.map((e=>t[e.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((t=>{for(const e of t.saved)e.dispose()})),this.state.activeTape=null),{value:r,grads:s}}))}customGrad(t){return Kn(ss(t),(()=>"The f passed in customGrad(f) must be a function.")),(...e)=>{let n;Kn(e.every((t=>t instanceof dr)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const s={};e.forEach(((t,e)=>{s[e]=t}));return this.runKernelFunc({forwardFunc:(s,r)=>(n=t(...e,r),Kn(n.value instanceof dr,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),Kn(ss(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(t,s)=>{const r=n.gradFunc(t,s),i=Array.isArray(r)?r:[r];Kn(i.length===e.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),Kn(i.every((t=>t instanceof dr)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const a={};return i.forEach(((t,e)=>{a[e]=()=>t})),a},inputs:s})}}readSync(t){return this.state.tensorInfo.get(t).backend.readSync(t)}read(t){return this.state.tensorInfo.get(t).backend.read(t)}readToGPU(t,e){return this.state.tensorInfo.get(t).backend.readToGPU(t,e)}async time(t){const e=tr(),n=await this.backend.time(t);return n.wallMs=tr()-e,n}track(t){return null!=this.state.activeScope&&(t.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(t)),t}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new Er;for(const t in this.registry)this.disposeRegisteredKernels(t),this.registry[t].dispose(),delete this.registry[t];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}Ir.nextTensorId=0,Ir.nextVariableId=0;const Ar=function(){const t=bs();if(null==t._tfengine){const e=new ps(t);t._tfengine=new Ir(e)}var e;return e=t._tfengine.ENV,ms=e,cr=()=>t._tfengine,t._tfengine}();function Tr(t,e){const n={a:t,b:e};return Ar.runKernel(pe,n)}function zr(t,e){let n=t;if(Qn(t))return"string"===e?[]:[t.length];if("object"==typeof t&&"texture"in t){const e=t.channels||"RGBA";return[t.height,t.width*e.length]}if(!Array.isArray(t))return[];const s=[];for(;Array.isArray(n)||Qn(n)&&"string"!==e;)s.push(n.length),n=n[0];return Array.isArray(t)&&fs().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&$r(t,s,[]),s}function $r(t,e,n){if(n=n||[],!Array.isArray(t)&&!Qn(t))return void Kn(0===e.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${e[0]} elements`));Kn(e.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${t.length} elements`)),Kn(t.length===e[0],(()=>`Element arr[${n.join("][")}] should have ${e[0]} elements, but has ${t.length} elements`));const s=e.slice(1);for(let e=0;e<t.length;++e)$r(t[e],s,n.concat(e))}function Cr(t,e,n,s){if("string_or_numeric"!==t){if(null==t)throw new Error("Expected dtype cannot be null.");if("numeric"!==t&&t!==e||"numeric"===t&&"string"===e)throw new Error(`Argument '${n}' passed to '${s}' must be ${t} tensor, but got ${e} tensor`)}}function _r(t,e,n,s="numeric"){if(t instanceof dr)return Cr(s,t.dtype,e,n),t;let r=ns(t);if("string"!==r&&["bool","int32","float32"].indexOf(s)>=0&&(r=s),Cr(s,r,e,n),null==t||!Qn(t)&&!Array.isArray(t)&&"number"!=typeof t&&"boolean"!=typeof t&&"string"!=typeof t){const s=null==t?"null":t.constructor.name;throw new Error(`Argument '${e}' passed to '${n}' must be a Tensor or TensorLike, but got '${s}'`)}const i=zr(t,r);Qn(t)||Array.isArray(t)||(t=[t]);const a="string"!==r?Qs(t,r):Gn(t,[],!0);return Ar.makeTensor(a,i,r)}function Dr(t,e,n,s="numeric"){if(!Array.isArray(t))throw new Error(`Argument ${e} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return t.map(((t,r)=>_r(t,`${e}[${r}]`,n,s)))}function Fr(t){const e=Object.keys(t);if(1!==e.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${e.length} keys.`);let n=e[0];const s=t[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+="__op";const r=(...t)=>{Ar.startScope(n);try{const e=s(...t);return hs(e)&&console.error("Cannot return a Promise inside of tidy."),Ar.endScope(e),e}catch(t){throw Ar.endScope(null),t}};return Object.defineProperty(r,"name",{value:n,configurable:!0}),r}const Rr=Fr({cast_:function(t,e){const n=_r(t,"x","cast");if(!function(t){return"bool"===t||"complex64"===t||"float32"===t||"int32"===t||"string"===t}(e))throw new Error(`Failed to cast to unknown dtype ${e}`);if("string"===e&&"string"!==n.dtype||"string"!==e&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const s={x:n},r={dtype:e};return Ar.runKernel(Ee,s,r)}});const Mr=Fr({mul_:function(t,e){let n=_r(t,"a","mul"),s=_r(e,"b","mul");[n,s]=vr(n,s);const r={a:n,b:s};return Ar.runKernel(sn,r)}});const Lr=Fr({step_:function(t,e=0){const n={x:_r(t,"x","step")},s={alpha:e};return Ar.runKernel(On,n,s)}}),Or={kernelName:"Abs",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,Lr(Rr(n,"float32"),-1))}}};const Br=Fr({floorDiv_:function(t,e){let n=_r(t,"a","floorDiv"),s=_r(e,"b","floorDiv");[n,s]=vr(n,s);const r={a:n,b:s};return Ar.runKernel(We,r)}});const Pr=Fr({div_:function(t,e){let n=_r(t,"a","div"),s=_r(e,"b","div");if([n,s]=vr(n,s),"int32"===n.dtype&&"int32"===s.dtype)return Br(n,s);const r={a:n,b:s};return Ar.runKernel(Le,r,{})}});const Wr=Fr({neg_:function(t){const e={x:_r(t,"x","neg")};return Ar.runKernel("Neg",e)}});function Ur(t,e,n,s){if(null==s&&(s=ns(t)),"complex64"===s)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if("object"==typeof t&&"texture"in t){if("float32"!==s&&"int32"!==s)throw new Error(`Creating tensor from texture only supports 'float32'|'int32' dtype, while the dtype is ${s}.`);return t.channels=t.channels||"RGBA",Ar.backend.createTensorFromTexture(t,e||n,s)}if(!Qn(t)&&!Array.isArray(t)&&"number"!=typeof t&&"boolean"!=typeof t&&"string"!=typeof t)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=e){us(e);const t=Hn(e),s=Hn(n);Kn(t===s,(()=>`Based on the provided shape, [${e}], the tensor should have ${t} values but has ${s}`));for(let t=0;t<n.length;++t){const s=n[t],r=t!==n.length-1||s!==Hn(e.slice(t));Kn(n[t]===e[t]||!r,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${e}). `))}}return Qn(t)||Array.isArray(t)||(t=[t]),e=e||n,t="string"!==s?Qs(t,s):Gn(t,[],!0),Ar.makeTensor(t,e,s)}function Vr(t,e){if((Qn(t)&&"string"!==e||Array.isArray(t))&&"complex64"!==e)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===e&&Qn(t)&&!(t instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return Ur(t,[],[],e)}const Kr=Fr({sqrt_:function(t){const e={x:_r(t,"x","sqrt","float32")};return Ar.runKernel(An,e)}});const jr=Fr({square_:function(t){const e=_r(t,"x","square");return Ar.runKernel("Square",{x:e},{})}});const qr=Fr({sub_:function(t,e){let n=_r(t,"a","sub"),s=_r(e,"b","sub");[n,s]=vr(n,s);const r={a:n,b:s};return Ar.runKernel("Sub",r)}}),Gr={kernelName:he,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=jr(Rr(n,"float32")),s=Kr(qr(Vr(1),e));return Wr(Pr(t,s))}}}},Hr={kernelName:ce,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Kr(qr(jr(Rr(n,"float32")),1));return Pr(t,e)}}}};function Jr(t,e){const n=[];for(let s=0;s<e.length;s++){const r=t[t.length-s-1],i=e.length-s-1,a=e[i];(null==r||1===r&&a>1)&&n.unshift(i)}return n}function Zr(t,e){const n=[],s=Math.max(t.length,e.length);for(let r=0;r<s;r++){let s=t[t.length-r-1];null==s&&(s=1);let i=e[e.length-r-1];if(null==i&&(i=1),1===s)n.unshift(i);else if(1===i)n.unshift(s);else{if(s!==i){throw Error(`Operands could not be broadcast together with shapes ${t} and ${e}.`)}n.unshift(s)}}return n}const Yr=Fr({reshape_:function(t,e){const n={x:_r(t,"x","reshape","string_or_numeric")},s={shape:e};return Ar.runKernel(dn,n,s)}});const Xr=Fr({sum_:function(t,e=null,n=!1){let s=_r(t,"x","sum");"bool"===s.dtype&&(s=Rr(s,"int32"));const r={x:s},i={axis:e,keepDims:n};return Ar.runKernel("Sum",r,i)}}),Qr={kernelName:pe,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Zr(n.shape,s.shape);return{a:()=>{let e=t;const s=Jr(n.shape,r);return s.length>0&&(e=Xr(e,s)),Yr(e,n.shape)},b:()=>{let e=t;const n=Jr(s.shape,r);return n.length>0&&(e=Xr(e,n)),Yr(e,s.shape)}}}},ti={kernelName:de,saveAllInputs:!0,gradFunc:(t,e)=>{const n={};return e.forEach(((e,s)=>{n[s]=()=>t.clone()})),n}};const ei=Fr({zerosLike_:function(t){const e={x:_r(t,"x","zerosLike")};return Ar.runKernel(Ln,e)}}),ni={kernelName:fe,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>ei(n)}}},si={kernelName:ge,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>ei(n)}}},ri={kernelName:me,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Pr(t,Kr(qr(Vr(1),jr(Rr(n,"float32")))))}}};const ii=Fr({add_:function(t,e){let n=_r(t,"a","add"),s=_r(e,"b","add");[n,s]=vr(n,s);const r={a:n,b:s};return Ar.runKernel(pe,r)}}),ai={kernelName:be,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Kr(ii(Vr(1),jr(Rr(n,"float32"))));return Pr(t,e)}}}},oi={kernelName:ke,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Zr(n.shape,s.shape);return{a:()=>{const e=ii(jr(n),jr(s));let i=Mr(t,Pr(s,e));const a=Jr(n.shape,r);return a.length>0&&(i=Xr(i,a)),Yr(i,n.shape)},b:()=>{const e=ii(jr(n),jr(s));let i=Wr(Mr(t,Pr(n,e)));const a=Jr(s.shape,r);return a.length>0&&(i=Xr(i,a)),Yr(i,s.shape)}}}},li={kernelName:ye,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Pr(t,ii(jr(Rr(n,"float32")),1))}}},ui={kernelName:we,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Pr(t,qr(Vr(1),jr(Rr(n,"float32"))))}}};function hi(t,e,n,s,r,i,a=!1,o="channelsLast"){let[l,u,h,c]=[-1,-1,-1,-1];if("channelsLast"===o)[l,u,h,c]=t;else{if("channelsFirst"!==o)throw new Error(`Unknown dataFormat ${o}`);[l,c,u,h]=t}const[p,d,,f]=e,[g,m]=ci(n),[b,y]=ci(s),w=pi(p,b),k=pi(d,y),{padInfo:v,outHeight:x,outWidth:S}=function(t,e,n,s,r,i,a,o,l){let u,h,c;if("number"==typeof t){u={top:t,bottom:t,left:t,right:t,type:0===t?"VALID":"NUMBER"};const r=function(t,e,n,s,r){null==s&&(s=function(t,e,n,s=1){const r=pi(e,s);return Math.floor((t[0]*(n-1)-n+r)/2)}(t,e,n));const i=t[0],a=t[1],o=di((i-e+2*s)/n+1,r),l=di((a-e+2*s)/n+1,r);return[o,l]}([e,n],i,s,t,o);h=r[0],c=r[1]}else if("same"===t){h=Math.ceil(e/s),c=Math.ceil(n/r);const t=Math.max(0,(h-1)*s+i-e),o=Math.max(0,(c-1)*r+a-n),l=Math.floor(t/2),p=t-l,d=Math.floor(o/2);u={top:l,bottom:p,left:d,right:o-d,type:"SAME"}}else if("valid"===t)u={top:0,bottom:0,left:0,right:0,type:"VALID"},h=Math.ceil((e-i+1)/s),c=Math.ceil((n-a+1)/r);else{if("object"!=typeof t)throw Error(`Unknown padding parameter: ${t}`);{const p="channelsLast"===l?t[1][0]:t[2][0],d="channelsLast"===l?t[1][1]:t[2][1],f="channelsLast"===l?t[2][0]:t[3][0],g="channelsLast"===l?t[2][1]:t[3][1];u={top:p,bottom:d,left:f,right:g,type:0===p&&0===d&&0===f&&0===g?"VALID":"EXPLICIT"},h=di((e-i+p+d)/s+1,o),c=di((n-a+f+g)/r+1,o)}}return{padInfo:u,outHeight:h,outWidth:c}}(r,u,h,g,m,w,k,i,o),N=a?f*c:f;let E;return"channelsFirst"===o?E=[l,N,x,S]:"channelsLast"===o&&(E=[l,x,S,N]),{batchSize:l,dataFormat:o,inHeight:u,inWidth:h,inChannels:c,outHeight:x,outWidth:S,outChannels:N,padInfo:v,strideHeight:g,strideWidth:m,filterHeight:p,filterWidth:d,effectiveFilterHeight:w,effectiveFilterWidth:k,dilationHeight:b,dilationWidth:y,inShape:t,outShape:E,filterShape:e}}function ci(t){return"number"==typeof t?[t,t,t]:2===t.length?[t[0],t[1],1]:t}function pi(t,e){return e<=1?t:t+(t-1)*(e-1)}function di(t,e){if(!e)return Math.trunc(t);switch(e){case"round":return Math.round(t);case"ceil":return Math.ceil(t);case"floor":return Math.floor(t);default:throw new Error(`Unknown roundingMode ${e}`)}}function fi(t){const[e,n,s]=ci(t);return 1===e&&1===n&&1===s}function gi(t,e){return fi(t)||fi(e)}function mi(t,e,n){if(null!=n){if("string"==typeof e)throw Error(`Error in ${t}: pad must be an integer when using dimRoundingMode ${n} but got pad ${e}.`);if("number"==typeof e)Kn(Zn(e),(()=>`Error in ${t}: pad must be an integer when using dimRoundingMode ${n} but got pad ${e}.`));else{if("object"!=typeof e)throw Error(`Error in ${t}: Unknown padding parameter: ${e}`);e.forEach((e=>{e.forEach((e=>{Kn(Zn(e),(()=>`Error in ${t}: pad must be an integer when using dimRoundingMode ${n} but got pad ${e}.`))}))}))}}}const bi=Fr({avgPool3dGrad_:function(t,e,n,s,r,i){const a=_r(t,"dy","avgPool3dGrad"),o=_r(e,"input","avgPool3dGrad");let l=a,u=o,h=!1;4===o.rank&&(h=!0,l=Yr(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]]),u=Yr(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),Kn(5===l.rank,(()=>`Error in avgPool3dGrad: dy must be rank 5 but got rank ${l.rank}.`)),Kn(5===u.rank,(()=>`Error in avgPool3dGrad: input must be rank 5 but got rank ${u.rank}.`)),mi("avgPool3dGrad",r,i);const c={dy:l,input:u},p={filterSize:n,strides:s,pad:r,dimRoundingMode:i},d=Ar.runKernel("AvgPool3DGrad",c,p);return h?Yr(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}}),yi={kernelName:xe,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{filterSize:r,strides:i,pad:a,dimRoundingMode:o}=n;return{x:()=>bi(t,s,r,i,a,o)}}};const wi=Fr({avgPoolGrad_:function(t,e,n,s,r){const i=_r(t,"dy","avgPoolGrad"),a=_r(e,"input","avgPoolGrad");Kn(a.rank===i.rank,(()=>`Rank of input (${a.rank}) does not match rank of dy (${i.rank})`));let o=a,l=i,u=!1;3===a.rank&&(u=!0,o=Yr(a,[1,a.shape[0],a.shape[1],a.shape[2]]),l=Yr(i,[1,i.shape[0],i.shape[1],i.shape[2]])),Kn(4===l.rank,(()=>`Error in avgPoolGrad: dy must be rank 4 but got rank ${l.rank}.`)),Kn(4===o.rank,(()=>`Error in avgPoolGrad: input must be rank 4 but got rank ${o.rank}.`));const h={dy:l,input:o},c={filterSize:n,strides:s,pad:r},p=Ar.runKernel("AvgPoolGrad",h,c);return u?Yr(p,[p.shape[1],p.shape[2],p.shape[3]]):p}}),ki={kernelName:ve,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{filterSize:r,strides:i,pad:a}=n;return{x:()=>wi(t,s,r,i,a)}}};const vi=Fr({matMul_:function(t,e,n=!1,s=!1){let r=_r(t,"a","matMul"),i=_r(e,"b","matMul");[r,i]=vr(r,i);const a={a:r,b:i},o={transposeA:n,transposeB:s};return Ar.runKernel(Se,a,o)}}),xi={kernelName:Se,inputsToSave:["a","b"],gradFunc:(t,e,n)=>{const[s,r]=e,{transposeA:i,transposeB:a}=n;return i||a?!i&&a?{a:()=>vi(t,r,!1,!1),b:()=>vi(t,s,!0,!1)}:i&&!a?{a:()=>vi(r,t,!1,!0),b:()=>vi(s,t,!1,!1)}:{a:()=>vi(r,t,!0,!0),b:()=>vi(t,s,!0,!0)}:{a:()=>vi(t,r,!1,!0),b:()=>vi(s,t,!0,!1)}}};const Si=Fr({spaceToBatchND_:function(t,e,n){const s=_r(t,"x","spaceToBatchND");Kn(s.rank>=1+e.length,(()=>`input rank ${s.rank} should be > than [blockShape] ${e.length}`)),Kn(n.length===e.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${e.length}`)),Kn(s.shape.reduce(((t,s,r)=>r>0&&r<=e.length?t&&(s+n[r-1][0]+n[r-1][1])%e[r-1]==0:t),!0),(()=>`input spatial dimensions ${s.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${e.toString()}`));const r={x:s},i={blockShape:e,paddings:n};return Ar.runKernel(Tn,r,i)}}),Ni={kernelName:Ne,gradFunc:(t,e,n)=>{const{blockShape:s,crops:r}=n;return{x:()=>Si(t,s,r)}}},Ei={kernelName:"BroadcastTo",gradFunc:(t,e,n)=>{const s=n,r=s.inputShape,i=s.shape,a=Array.from(i);for(let t=r.length-1;t>=0;t--)if(r[t]===i[t])a[t]=1;else if(1!==r[t])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${i}].`);const o=[];for(let t=0;t<a.length;t++)a[t]>1&&o.push(t);return{x:()=>Xr(t,o,!0)}}},Ii={kernelName:Ee,gradFunc:t=>({x:()=>t.clone()})},Ai={kernelName:Ie,gradFunc:t=>({x:()=>ei(t)})};const Ti=Fr({greaterEqual_:function(t,e){let n=_r(t,"a","greaterEqual","string_or_numeric"),s=_r(e,"b","greaterEqual","string_or_numeric");[n,s]=vr(n,s),Zr(n.shape,s.shape);const r={a:n,b:s};return Ar.runKernel(Ke,r)}});const zi=Fr({lessEqual_:function(t,e){let n=_r(t,"a","lessEqual","string_or_numeric"),s=_r(e,"b","lessEqual","string_or_numeric");[n,s]=vr(n,s),Zr(n.shape,s.shape);const r={a:n,b:s};return Ar.runKernel("LessEqual",r)}});const $i=Fr({logicalAnd_:function(t,e){const n=_r(t,"a","logicalAnd","bool"),s=_r(e,"b","logicalAnd","bool");Zr(n.shape,s.shape);const r={a:n,b:s};return Ar.runKernel("LogicalAnd",r)}});const Ci=Fr({clone_:function(t){const e={x:_r(t,"x","clone","string_or_numeric")};return Ar.runKernel(je,e)}});const _i=Fr({broadcastTo_:function(t,e){let n=_r(t,"broadcastTo","x");const s=n.shape;if(e.some((t=>!(t>0)||t%1!=0)))throw new Error(`broadcastTo(): Invalid broadcast shape [${e}].`);if(e.length<n.rank)throw new Error(`broadcastTo(): shape.length=${e.length} < input.rank=${n.rank}.`);if(e.length>n.rank){const t=n.shape.slice();for(;t.length<e.length;)t.unshift(1);n=Yr(n,t)}const r=n.shape,i=Array.from(e);for(let t=e.length-1;t>=0;t--)if(r[t]===e[t])i[t]=1;else if(1!==n.shape[t])throw new Error(`broadcastTo(): [${s}] cannot be broadcast to [${e}].`);if(0===i.map(((t,e)=>t>1?e:-1)).filter((t=>t>=0)).length)return Ci(n);const a={x:n},o={reps:i};return Ar.runKernel(Dn,a,o)}});const Di=Fr({where_:function(t,e,n){const s=_r(e,"a","where"),r=_r(n,"b","where"),i=_r(t,"condition","where","bool"),a=Zr(Zr(i.shape,s.shape),r.shape),o={condition:_i(i,a),t:_i(s,a),e:_i(r,a)};return Ar.runKernel(kn,o)}}),Fi={kernelName:Ae,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{clipValueMin:r,clipValueMax:i}=n;return{x:()=>Di($i(Ti(s,r),zi(s,i)),t,ei(t))}}},Ri={kernelName:Te,inputsToSave:["x"],gradFunc:Or.gradFunc};const Mi=Fr({split_:function(t,e,n=0){const s={x:_r(t,"x","split")},r={numOrSizeSplits:e,axis:n};return Ar.runKernel(zn,s,r)}}),Li={kernelName:ze,saveAllInputs:!0,gradFunc:(t,e,n)=>{const s=e.map((t=>t.shape)),{axis:r}=n,i=Xn(r,e[0].shape)[0],a=s.map((t=>t[i]));return Mi(t,a,i).map((t=>()=>t))}};const Oi=Fr({conv2DBackpropFilter_:function(t,e,n,s,r,i="NHWC",a){let o=t;3===t.rank&&(o=Yr(t,[1,t.shape[0],t.shape[1],t.shape[2]]));let l=e;3===l.rank&&(l=Yr(e,[1,e.shape[0],e.shape[1],e.shape[2]])),Kn(4===o.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${o.shape}.`)),Kn(4===l.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${l.shape}.`)),Kn(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const u="NHWC"===i?o.shape[3]:o.shape[1],h="NHWC"===i?l.shape[3]:l.shape[1];Kn(u===n[2],(()=>`Error in conv2dDerFilter: depth of input ${u}) must match input depth in filter (${n[2]}.`)),Kn(h===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`)),mi("conv2dDerFilter",r,a);const c={x:o,dy:l},p={strides:s,pad:r,dataFormat:i,dimRoundingMode:a,filterShape:n};return Ar.runKernel("Conv2DBackpropFilter",c,p)}});const Bi=Fr({conv2DBackpropInput_:function(t,e,n,s,r,i="NHWC",a){Kn(t.length===e.rank,(()=>`Length of inShape (${t.length}) and rank of dy (${e.rank}) must match`));let o=t,l=e,u=!1;3===e.rank&&(u=!0,l=Yr(e,[1,e.shape[0],e.shape[1],e.shape[2]]),o=[1,t[0],t[1],t[2]]),Kn(4===o.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${o.length}.`)),Kn(4===l.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${l.rank}`)),Kn(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const h="NHWC"===i?o[3]:o[1],c="NHWC"===i?l.shape[3]:l.shape[1];Kn(h===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`)),Kn(c===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[3]}.`)),mi("conv2dDerInput",r,a);const p={dy:l,filter:n},d={strides:s,pad:r,dataFormat:i,dimRoundingMode:a,inputShape:o},f=Ar.runKernel(Ce,p,d);return u?Yr(f,[f.shape[1],f.shape[2],f.shape[3]]):f}}),Pi={kernelName:$e,inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,{dilations:i,strides:a,pad:o,dataFormat:l}=n;return Kn(fi(i),(()=>`Error in gradient of conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${i}'`)),{x:()=>Bi(s.shape,t,r,a,o,l),filter:()=>Oi(s,t,r.shape,a,o,l)}}};const Wi=Fr({conv2d_:function(t,e,n,s,r="NHWC",i=[1,1],a){const o=_r(t,"x","conv2d","float32"),l=_r(e,"filter","conv2d","float32");let u=o,h=!1;3===o.rank&&(h=!0,u=Yr(o,[1,o.shape[0],o.shape[1],o.shape[2]])),Kn(4===u.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${u.rank}.`)),Kn(4===l.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${l.rank}.`)),mi("conv2d",s,a);const c="NHWC"===r?u.shape[3]:u.shape[1];Kn(c===l.shape[2],(()=>`Error in conv2d: depth of input (${c}) must match input depth for filter ${l.shape[2]}.`)),Kn(gi(n,i),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`));const p={x:u,filter:l},d={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a},f=Ar.runKernel($e,p,d);return h?Yr(f,[f.shape[1],f.shape[2],f.shape[3]]):f}}),Ui={kernelName:Ce,inputsToSave:["dy","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,{strides:i,pad:a,dataFormat:o,dimRoundingMode:l}=n;return{dy:()=>Wi(t,r,i,a,o,1,l),filter:()=>Oi(t,s,r.shape,i,a,o,l)}}};const Vi=Fr({conv3DBackpropFilter_:function(t,e,n,s,r){let i=t;4===t.rank&&(i=Yr(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]));let a=e;4===a.rank&&(a=Yr(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]])),Kn(5===i.rank,(()=>`Error in conv3dDerFilter: input must be rank 5, but got shape ${i.shape}.`)),Kn(5===a.rank,(()=>`Error in conv3dDerFilter: dy must be rank 5, but got shape ${a.shape}.`)),Kn(5===n.length,(()=>`Error in conv3dDerFilter: filterShape must be length 5, but got ${n}.`)),Kn(i.shape[4]===n[3],(()=>`Error in conv3dDerFilter: depth of input ${i.shape[4]}) must match input depth in filter (${n[3]}.`)),Kn(a.shape[4]===n[4],(()=>`Error in conv3dDerFilter: depth of dy (${a.shape[4]}) must match output depth for filter (${n[4]}).`));const o={x:i,dy:a},l={strides:s,pad:r,filterShape:n};return Ar.runKernel("Conv3DBackpropFilterV2",o,l)}});const Ki=Fr({conv3DBackpropInput_:function(t,e,n,s,r){Kn(t.length===e.rank,(()=>`Length of inShape (${t.length}) and rank of dy (${e.rank}) must match`));let i=t,a=e,o=!1;4===e.rank&&(o=!0,a=Yr(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]]),i=[1,t[0],t[1],t[2],t[3]]);const l=i[4],u=a.shape[4];Kn(5===i.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${i.length}.`)),Kn(5===a.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${a.rank}`)),Kn(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),Kn(l===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${l}) must match input depth for filter ${n.shape[3]}.`)),Kn(u===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${u}) must match output depth for filter ${n.shape[4]}.`));const h={dy:a,filter:n},c={pad:r,strides:s,inputShape:i},p=Ar.runKernel("Conv3DBackpropInputV2",h,c);return o?Yr(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}}),ji={kernelName:_e,inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const{dilations:s,strides:r,pad:i}=n;Kn(fi(s),(()=>`Error in gradient of conv3D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${s}'`));const[a,o]=e;return{x:()=>Ki(a.shape,t,o,r,i),filter:()=>Vi(a,t,o.shape,r,i)}}};const qi=Fr({sin_:function(t){const e={x:_r(t,"x","sin","float32")};return Ar.runKernel("Sin",e)}}),Gi={kernelName:"Cos",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(Wr(qi(Rr(n,"float32"))),t)}}};const Hi=Fr({sinh_:function(t){const e={x:_r(t,"x","sinh")};return Ar.runKernel(Sn,e)}}),Ji={kernelName:De,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(Hi(Rr(n,"float32")),t)}}};function Zi(t,e){return function(t,e,n){const s=t.length+e.length,r=[];let i=0,a=0;for(let o=0;o<s;o++)-1===n.indexOf(o)?r.push(t[i++]):r.push(e[a++]);return r}(t,e.map((t=>1)),e)}function Yi(t,e){if(function(t,e){for(let n=0;n<t.length;++n)if(t[t.length-n-1]!==e-1-n)return!1;return!0}(t,e))return null;const n=[];for(let s=0;s<e;++s)-1===t.indexOf(s)&&n.push(s);return t.forEach((t=>n.push(t))),n}function Xi(t){return t.map(((t,e)=>[e,t])).sort(((t,e)=>t[1]-e[1])).map((t=>t[0]))}const Qi=Fr({cumsum_:function(t,e=0,n=!1,s=!1){const r={x:_r(t,"x","cumsum")},i={axis:e,exclusive:n,reverse:s};return Ar.runKernel(Fe,r,i)}});function ta(t,e){return Ar.tidy(t,e)}function ea(t){xr(t).forEach((t=>t.dispose()))}const na=Fr({complex_:function(t,e){const n=_r(t,"real","complex"),s=_r(e,"imag","complex");jn(n.shape,s.shape,`real and imag shapes, ${n.shape} and ${s.shape}, must match in call to tf.complex().`);const r={real:n,imag:s};return Ar.runKernel("Complex",r)}});const sa=Fr({imag_:function(t){const e={input:_r(t,"input","imag")};return Ar.runKernel("Imag",e)}});const ra=Fr({real_:function(t){const e={input:_r(t,"input","real")};return Ar.runKernel("Real",e)}});const ia=Fr({transpose_:function(t,e,n){const s=_r(t,"x","transpose");if(null==e&&(e=s.shape.map(((t,e)=>e)).reverse()),Kn(s.rank===e.length,(()=>`Error in transpose: rank of input ${s.rank} must match length of perm ${e}.`)),e.forEach((t=>{Kn(t>=0&&t<s.rank,(()=>"All entries in 'perm' must be between 0 and "+(s.rank-1)+` but got ${e}`))})),s.rank<=1)return s.clone();const r={x:s},i={perm:e};return"complex64"===s.dtype?ta((()=>{let t=ra(s),e=sa(s);return t=Ar.runKernel(Fn,{x:t},i),e=Ar.runKernel(Fn,{x:e},i),n&&(e=Wr(e)),na(t,e)})):Ar.runKernel(Fn,r,i)}}),aa={kernelName:Fe,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r,exclusive:i,reverse:a}=n;return{x:()=>{const e=Yi([r],s.rank);let n=Qi(t,r,i,!a);return null!=e&&(n=ia(n,e)),n}}}};const oa=Fr({depthwiseConv2dNativeBackpropFilter_:function(t,e,n,s,r,i=[1,1],a){let o=t;3===t.rank&&(o=Yr(t,[1,t.shape[0],t.shape[1],t.shape[2]]));let l=e;3===l.rank&&(l=Yr(e,[1,e.shape[0],e.shape[1],e.shape[2]]));const u={x:o,dy:l},h={strides:s,pad:r,dimRoundingMode:a,dilations:i,filterShape:n};return Ar.runKernel("DepthwiseConv2dNativeBackpropFilter",u,h)}});const la=Fr({depthwiseConv2dNativeBackpropInput_:function(t,e,n,s,r,i=[1,1],a){let o=e,l=!1;3===e.rank&&(l=!0,o=Yr(e,[1,e.shape[0],e.shape[1],e.shape[2]]));const u={dy:o,filter:n},h={strides:s,pad:r,dimRoundingMode:a,dilations:i,inputShape:t},c=Ar.runKernel("DepthwiseConv2dNativeBackpropInput",u,h);return l?Yr(c,[c.shape[1],c.shape[2],c.shape[3]]):c}}),ua={kernelName:Re,inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const{dilations:s,strides:r,pad:i,dimRoundingMode:a}=n,o=null==s?[1,1]:s;Kn(fi(o),(()=>`Error in gradient of depthwiseConv2dNative: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`));const[l,u]=e;return Kn(4===l.rank,(()=>`Error in gradient of depthwiseConv2dNative: input must be rank 4, but got rank ${l.rank}.`)),Kn(4===u.rank,(()=>`Error in gradient of depthwiseConv2dNative: filter must be rank 4, but got rank ${u.rank}.`)),Kn(l.shape[3]===u.shape[2],(()=>`Error in gradient of depthwiseConv2d: number of input channels (${l.shape[3]}) must match the inChannels dimension in filter ${u.shape[2]}.`)),Kn(gi(r,o),(()=>`Error in gradient of depthwiseConv2d: Either strides or dilations must be  1. Got strides ${r} and dilations '${o}'.`)),mi("depthwiseConv2d",i,a),{x:()=>la(l.shape,t,u,r,i,o,a),filter:()=>oa(l,t,u.shape,r,i,o,a)}}},ha={kernelName:Me,inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,i={x:s,filter:r,dy:t},a={x:s,filter:r,dy:t};return{x:()=>Ar.runKernel("Dilation2DBackpropInput",i,n),filter:()=>Ar.runKernel("Dilation2DBackpropFilter",a,n)}}},ca={kernelName:"Elu",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e,s={dy:t,y:n};return{x:()=>Ar.runKernel("EluGrad",s)}}};const pa=Fr({exp_:function(t){const e={x:_r(t,"x","exp")};return Ar.runKernel("Exp",e)}}),da={kernelName:"Erf",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e,s=Mr(pa(Wr(jr(n))),2/Math.sqrt(Math.PI));return{x:()=>Mr(t,s)}}},fa={kernelName:"Exp",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,n)}}},ga={kernelName:Oe,inputsToSave:["input"],gradFunc:(t,e)=>{const[n]=e;return{input:()=>Yr(t,n.shape)}}},ma={kernelName:Be,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,pa(n))}}},ba={kernelName:Pe,gradFunc:t=>({x:()=>ei(t)})},ya={kernelName:We,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Zr(n.shape,s.shape);return{a:()=>{const e=Pr(t,Rr(s,"float32")),i=Jr(n.shape,r);return i.length>0?Yr(Xr(e,i),n.shape):e},b:()=>{let e=Mr(t,Rr(n,"float32"));const i=Jr(s.shape,r);i.length>0&&(e=Yr(Xr(e,i),s.shape));const a=jr(s);return Wr(Pr(e,Rr(a,"float32")))}}}};const wa=Fr({rsqrt_:function(t){const e={x:_r(t,"x","rsqrt","float32")};return Ar.runKernel(wn,e)}});const ka=Fr({tile_:function(t,e){const n=_r(t,"x","tile","string_or_numeric");Kn(n.rank===e.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${e}.`));const s={x:n},r={reps:e};return Ar.runKernel(Dn,s,r)}}),va={kernelName:Ue,inputsToSave:["x","mean","variance","scale"],gradFunc:(t,e,n)=>{const{varianceEpsilon:s}=n,[r,i,a,o]=e,l=null==o?Vr(1):o,u=Jr(i.shape,r.shape),h=[];if(1===i.rank){for(let t=0;t<r.shape.length-1;++t)h.push(r.shape[t]);h.push(1)}const c=qr(r,i),p=Mr(t,l),d=wa(ii(a,Vr(s))),f=Mr(Mr(Mr(d,d),d),Vr(-.5));return{x:()=>1===i.rank?Yr(Mr(Mr(t,ka(Yr(d,[1,1,1,i.shape[0]]),h)),l),r.shape):Yr(Mr(Mr(t,d),l),r.shape),mean:()=>{let t=Mr(Mr(d,Vr(-1)),p);return 1===i.rank&&(t=Xr(t,u)),Yr(t,i.shape)},variance:()=>{let t=Mr(Mr(f,c),p);return 1===i.rank&&(t=Xr(t,u)),Yr(t,i.shape)},scale:()=>{const e=Mr(c,d);let n=Mr(t,e);return 1===i.rank&&(n=Xr(n,u)),Yr(n,i.shape)},offset:()=>{let e=t;return 1===i.rank&&(e=Xr(e,u)),Yr(e,i.shape)}}}};const xa=Fr({unsortedSegmentSum_:function(t,e,n){const s=_r(t,"x","unsortedSegmentSum"),r=_r(e,"segmentIds","unsortedSegmentSum","int32");Kn(Zn(n),(()=>"numSegments must be of dtype int"));const i={x:s,segmentIds:r},a={numSegments:n};return Ar.runKernel(Mn,i,a)}}),Sa={kernelName:Ve,inputsToSave:["x","indices"],gradFunc:(t,e,n)=>{const[s,r]=e,{axis:i}=n,a=Xn(i,s.shape)[0];return{x:()=>{const e=s.shape,n=r.size,o=e.slice(0,a),l=o.length,u=e.slice(i,e.length).slice(1),h=u.length,c=Na(0,l),p=Na(l+1,l+1+h),d=Ea([o,[n],u]),f=Yr(t,d),g=Yr(r,[n]),m=Ea([[l],c,p]),b=ia(f,m);let y=xa(b,g,s.shape[a]);const w=Xi(m);return y=ia(y,w),y},indices:()=>r}}};function Na(t,e){const n=[];for(let s=t;s<e;++s)n.push(s);return n}function Ea(t){const e=[];for(let n=0;n<t.length;++n)for(let s=0;s<t[n].length;++s)e.push(t[n][s]);return e}const Ia={kernelName:Ke,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>ei(n),b:()=>ei(s)}}},Aa={kernelName:je,gradFunc:t=>({x:()=>Rr(t,"float32")})},Ta={kernelName:qe,gradFunc:t=>({x:()=>ei(t)})},za={kernelName:Ge,gradFunc:t=>({x:()=>ei(t)})},$a={kernelName:He,gradFunc:t=>({x:()=>ei(t)})};const Ca=Fr({greater_:function(t,e){let n=_r(t,"a","greater","string_or_numeric"),s=_r(e,"b","greater","string_or_numeric");[n,s]=vr(n,s),Zr(n.shape,s.shape);const r={a:n,b:s};return Ar.runKernel("Greater",r)}}),_a={kernelName:Je,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{alpha:r}=n,i=Ca(s,0);return{x:()=>Di(i,t,Mr(t,r))}}},Da={kernelName:Ze,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Pr(t,ii(n,1))}}},Fa={kernelName:"Log",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Pr(t,Rr(n,"float32"))}}},Ra={kernelName:"LogSoftmax",inputsToSave:[],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n;return{logits:()=>{const e=pa(s);return qr(t,Mr(Xr(t,r,!0),e))}}}};const Ma=Fr({localResponseNormalizationBackprop_:function(t,e,n,s=5,r=1,i=1,a=.5){const o={x:t,y:e,dy:n},l={depthRadius:s,bias:r,alpha:i,beta:a};return Ar.runKernel("LRNGrad",o,l)}}),La={kernelName:"LRN",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{depthRadius:i,bias:a,alpha:o,beta:l}=n;return{x:()=>Ma(s,r,t,i,a,o,l)}}};const Oa=Fr({equal_:function(t,e){let n=_r(t,"a","equal","string_or_numeric"),s=_r(e,"b","equal","string_or_numeric");[n,s]=vr(n,s),Zr(n.shape,s.shape);const r={a:n,b:s};return Ar.runKernel("Equal",r)}});function Ba(t,e,n,s){return e.rank<n.rank&&(e=Yr(e,Zi(e.shape,s))),t.rank<n.rank&&(t=Yr(t,Zi(t.shape,s))),{x:()=>Mr(t,Rr(Oa(n,e),t.dtype))}}const Pa={kernelName:"Max",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const s=n,{reductionIndices:r}=s,i=e[0],a=Ba(t,e[1],i,Xn(r,i.shape));return{x:()=>a.x()}}};const Wa=Fr({less_:function(t,e){let n=_r(t,"a","less","string_or_numeric"),s=_r(e,"b","less","string_or_numeric");[n,s]=vr(n,s),Zr(n.shape,s.shape);const r={a:n,b:s};return Ar.runKernel("Less",r)}}),Ua={kernelName:Ye,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>Mr(t,Rr(Ti(n,s),"float32")),b:()=>Mr(t,Rr(Wa(n,s),"float32"))}}};const Va=Fr({maxPool3dGrad_:function(t,e,n,s,r,i,a){const o=_r(t,"dy","maxPool3dGrad"),l=_r(e,"input","maxPool3dGrad"),u=_r(n,"output","maxPool3dGrad");let h=o,c=l,p=u,d=!1;4===l.rank&&(d=!0,h=Yr(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]]),c=Yr(l,[1,l.shape[0],l.shape[1],l.shape[2],l.shape[3]]),p=Yr(u,[1,u.shape[0],u.shape[1],u.shape[2],u.shape[3]])),Kn(5===h.rank,(()=>`Error in maxPool3dGrad: dy must be rank 5 but got rank ${h.rank}.`)),Kn(5===c.rank,(()=>`Error in maxPool3dGrad: input must be rank 5 but got rank ${c.rank}.`)),Kn(5===p.rank,(()=>`Error in maxPool3dGrad: output must be rank 5 but got rank ${p.rank}.`)),mi("maxPool3dGrad",i,a);const f={dy:h,input:c,output:p},g={filterSize:s,strides:r,pad:i,dimRoundingMode:a},m=Ar.runKernel("MaxPool3DGrad",f,g);return d?Yr(m,[m.shape[1],m.shape[2],m.shape[3],m.shape[4]]):m}}),Ka={kernelName:Qe,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{filterSize:i,strides:a,pad:o,dimRoundingMode:l}=n;return{x:()=>Va(t,s,r,i,a,o,l)}}};const ja=Fr({maxPoolGrad_:function(t,e,n,s,r,i,a){const o=_r(t,"dy","maxPoolGrad"),l=_r(e,"input","maxPoolGrad"),u=_r(n,"output","maxPoolGrad");Kn(l.rank===o.rank,(()=>`Rank of input (${l.rank}) does not match rank of dy (${o.rank})`)),Kn(4===o.rank,(()=>`Error in maxPoolGrad: dy must be rank 4 but got rank ${o.rank}.`)),Kn(4===l.rank,(()=>`Error in maxPoolGrad: input must be rank 4 but got rank ${l.rank}.`)),mi("maxPoolGrad",i,a);const h={dy:o,input:l,output:u},c={filterSize:s,strides:r,pad:i,dimRoundingMode:a};return Ar.runKernel("MaxPoolGrad",h,c)}}),qa={kernelName:Xe,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{filterSize:i,strides:a,pad:o}=n;return{x:()=>ja(t,s,r,i,a,o)}}};function Ga(t,e="float32"){if("complex64"===e){const e=Ga(t,"float32"),n=Ga(t,"float32");return na(e,n)}const n=ls(Hn(t),e);return Ar.makeTensor(n,t,e)}function Ha(t,e="float32"){if("complex64"===e){const e=Ha(t,"float32"),n=Ga(t,"float32");return na(e,n)}const n=os(Hn(t),e);return Ar.makeTensor(n,t,e)}const Ja={kernelName:tn,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n,i=Xn(r,s.shape),a=function(t,e){const n=[],s=t.length;for(let r=0;r<s;r++)-1===e.indexOf(r)&&n.push(t[r]);return[n,e.map((e=>t[e]))]}(s.shape,i),o=Hn(a[1]);return{x:()=>{const e=s.shape.slice();i.forEach((t=>{e[t]=1}));const n=Yr(t,e);return Pr(Mr(n,Ha(s.shape,"float32")),o)}}}},Za={kernelName:"Min",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const s=n,{axis:r}=s,[i,a]=e,o=Ba(t,a,i,Xn(r,i.shape));return{x:()=>o.x()}}},Ya={kernelName:en,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>Mr(t,Rr(zi(n,s),"float32")),b:()=>Mr(t,Rr(Ca(n,s),"float32"))}}};const Xa=Fr({slice_:function(t,e,n){const s=_r(t,"x","slice","string_or_numeric");if(0===s.rank)throw new Error("Slicing scalar is not possible");const r={x:s},i={begin:e,size:n};return Ar.runKernel(xn,r,i)}}),Qa={kernelName:nn,inputsToSave:["x"],gradFunc:(t,e,n)=>{const s=e[0],{paddings:r}=n,i=r.map((t=>t[0]));return{x:()=>Xa(t,i,s.shape)}}};const to=Fr({floor_:function(t){const e={x:_r(t,"x","floor","float32")};return Ar.runKernel(Pe,e)}}),eo={kernelName:"Mod",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Zr(n.shape,s.shape);return{a:()=>{const e=Jr(n.shape,r);return e.length>0?Yr(Xr(t,e),n.shape):t},b:()=>{const e=Mr(t,Wr(to(Pr(n,s)))),i=Jr(s.shape,r);return i.length>0?Yr(Xr(e,i),s.shape):e}}}},no={kernelName:sn,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Zr(n.shape,s.shape);return{a:()=>{const e=Mr(t,Rr(s,"float32")),i=Jr(n.shape,r);return i.length>0?Yr(Xr(e,i),n.shape):e},b:()=>{const e=Mr(t,Rr(n,"float32")),i=Jr(s.shape,r);return i.length>0?Yr(Xr(e,i),s.shape):e}}}},so={kernelName:"Neg",gradFunc:t=>({x:()=>Wr(t)})},ro={kernelName:an,inputsToSave:["indices"],gradFunc:(t,e)=>{const n=e[0];return{indices:()=>Ga(n.shape,"float32")}}},io={kernelName:rn,gradFunc:t=>({x:()=>ei(t)})};const ao=Fr({unstack_:function(t,e=0){const n=_r(t,"x","unstack","string_or_numeric");Kn(e>=-n.shape.length&&e<n.shape.length,(()=>`Axis = ${e} is not in [-${n.shape.length}, ${n.shape.length})`));const s={value:n},r={axis:e};return Ar.runKernel(Rn,s,r)}}),oo={kernelName:on,saveAllInputs:!0,gradFunc:(t,e,n)=>{const{axis:s}=n;return ao(t,s).map((t=>()=>t))}},lo={kernelName:ln,inputsToSave:["x"],gradFunc:(t,e,n)=>{const s=e[0],{paddings:r}=n,i=r.map((t=>t[0]));return{x:()=>Xa(t,i,s.shape)}}};const uo=Fr({log_:function(t){const e={x:_r(t,"x","log","float32")};return Ar.runKernel("Log",e)}});const ho=Fr({pow_:function(t,e){let n=_r(t,"base","pow"),s=_r(e,"exp","pow");[n,s]=vr(n,s);const r={a:n,b:s};return Ar.runKernel("Pow",r)}}),co={kernelName:"Pow",inputsToSave:["a","b"],outputsToSave:[!0],gradFunc:(t,e)=>{const[n,s,r]=e,i=n,a=s,o=Zr(i.shape,a.shape);return{a:()=>{const e=Rr(a,"float32");let n=Mr(t,Mr(e,ho(i,qr(e,Vr(1)))));const s=Jr(i.shape,o);return s.length>0&&(n=Xr(n,s)),Yr(n,i.shape)},b:()=>{const e=Ca(i,0),n=Di(e,uo(i),ei(i));let s=Mr(t,Mr(r,n));const l=Jr(a.shape,o);return l.length>0&&(s=Xr(s,l)),Yr(s,a.shape)}}}},po={kernelName:un,inputsToSave:["x","alpha"],gradFunc:(t,e)=>{const[n,s]=e,r=Ca(n,0);return{x:()=>Di(r,t,Mr(t,s)),alpha:()=>{let e=Di(r,ei(t),Mr(t,n));const i=Jr(s.shape,t.shape);return i.length>0&&(e=Xr(e,i)),Yr(e,s.shape)}}}};const fo=fs();fo.registerFlag("DEBUG",(()=>!1),(t=>{t&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")})),fo.registerFlag("IS_BROWSER",(()=>"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope)),fo.registerFlag("IS_NODE",(()=>"undefined"!=typeof process&&"undefined"!=typeof process.versions&&"undefined"!=typeof process.versions.node)),fo.registerFlag("IS_CHROME",(()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor))),fo.registerFlag("PROD",(()=>!1)),fo.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",(()=>fo.getBool("DEBUG"))),fo.registerFlag("DEPRECATION_WARNINGS_ENABLED",(()=>!0)),fo.registerFlag("IS_TEST",(()=>!1)),fo.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",(()=>!0)),fo.registerFlag("WRAP_TO_IMAGEBITMAP",(()=>!1)),fo.registerFlag("ENGINE_COMPILE_ONLY",(()=>!1)),fo.registerFlag("CANVAS2D_WILL_READ_FREQUENTLY_FOR_GPU",(()=>!1)),fo.registerFlag("USE_SETTIMEOUTCUSTOM",(()=>!1));const go="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function mo(t){return go?Buffer.byteLength(t):new Blob([t]).size}function bo(t){if(1===t.length)return t[0];let e=0;t.forEach((t=>{e+=t.byteLength}));const n=new Uint8Array(e);let s=0;return t.forEach((t=>{n.set(new Uint8Array(t),s),s+=t.byteLength})),n.buffer}function yo(t,e){const n={modelTopology:t.modelTopology,format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy,weightsManifest:e};return null!=t.signature&&(n.signature=t.signature),null!=t.userDefinedMetadata&&(n.userDefinedMetadata=t.userDefinedMetadata),null!=t.modelInitializer&&(n.modelInitializer=t.modelInitializer),null!=t.initializerSignature&&(n.initializerSignature=t.initializerSignature),null!=t.trainingConfig&&(n.trainingConfig=t.trainingConfig),n}async function wo(t,e){let n,s;return null!=t.weightsManifest&&([n,s]=await e(t.weightsManifest)),function(t,e,n){const s={modelTopology:t.modelTopology,format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy};if(null!=t.trainingConfig&&(s.trainingConfig=t.trainingConfig),null!=t.weightsManifest){if(!e)throw new Error("modelJSON has weightsManifest but weightSpecs is null");if(!n)throw new Error("modelJSON has weightsManifest but weightData is null");s.weightSpecs=e,s.weightData=n}return null!=t.signature&&(s.signature=t.signature),null!=t.userDefinedMetadata&&(s.userDefinedMetadata=t.userDefinedMetadata),null!=t.modelInitializer&&(s.modelInitializer=t.modelInitializer),null!=t.initializerSignature&&(s.initializerSignature=t.initializerSignature),s}(t,n,s)}function ko(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==t.modelTopology?0:mo(JSON.stringify(t.modelTopology)),weightSpecsBytes:null==t.weightSpecs?0:mo(JSON.stringify(t.weightSpecs)),weightDataBytes:null==t.weightData?0:t.weightData.byteLength}}class vo{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==vo.instance&&(vo.instance=new vo),vo.instance}static registerSaveRouter(t){vo.getInstance().saveRouters.push(t)}static registerLoadRouter(t){vo.getInstance().loadRouters.push(t)}static getSaveHandlers(t){return vo.getHandlers(t,"save")}static getLoadHandlers(t,e){return vo.getHandlers(t,"load",e)}static getHandlers(t,e,n){const s=[];return("load"===e?vo.getInstance().loadRouters:vo.getInstance().saveRouters).forEach((e=>{const r=e(t,n);null!==r&&s.push(r)})),s}}const xo="models_store",So="model_info_store";class No{constructor(t){if(this.indexedDB=function(){if(!fs().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const t="undefined"==typeof window?self:window,e=t.indexedDB||t.mozIndexedDB||t.webkitIndexedDB||t.msIndexedDB||t.shimIndexedDB;if(null==e)throw new Error("The current browser does not appear to support IndexedDB.");return e}(),null==t||!t)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=t}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,t)}async load(){return this.databaseAction(this.modelPath)}databaseAction(t,e){return new Promise(((t,n)=>{const s=this.indexedDB.open("tensorflowjs",1);s.onupgradeneeded=()=>function(t){const e=t.result;e.createObjectStore(xo,{keyPath:"modelPath"}),e.createObjectStore(So,{keyPath:"modelPath"})}(s),s.onsuccess=()=>{const r=s.result;if(null==e){const e=r.transaction(xo,"readonly"),s=e.objectStore(xo).get(this.modelPath);s.onsuccess=()=>{if(null==s.result)return r.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));t(s.result.modelArtifacts)},s.onerror=t=>(r.close(),n(s.error)),e.oncomplete=()=>r.close()}else{const s=ko(e),i=r.transaction(So,"readwrite");let a=i.objectStore(So);const o=a.put({modelPath:this.modelPath,modelArtifactsInfo:s});let l;o.onsuccess=()=>{l=r.transaction(xo,"readwrite");const o=l.objectStore(xo).put({modelPath:this.modelPath,modelArtifacts:e,modelArtifactsInfo:s});o.onsuccess=()=>t({modelArtifactsInfo:s}),o.onerror=t=>{a=i.objectStore(So);const e=a.delete(this.modelPath);e.onsuccess=()=>(r.close(),n(o.error)),e.onerror=t=>(r.close(),n(o.error))}},o.onerror=t=>(r.close(),n(o.error)),i.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}}},s.onerror=t=>n(s.error)}))}}No.URL_SCHEME="indexeddb://";const Eo=t=>{return fs().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(No.URL_SCHEME)?(e=t.slice(No.URL_SCHEME.length),new No(e)):null;var e};vo.registerSaveRouter(Eo),vo.registerLoadRouter(Eo);const Io="/",Ao="tensorflowjs_models",To="info",zo="model_topology",$o="weight_specs",Co="weight_data",_o="model_metadata";class Do{constructor(t){if(!fs().getBool("IS_BROWSER")||"undefined"==typeof window||"undefined"==typeof window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==t||!t)throw new Error("For local storage, modelPath must not be null, undefined or empty.");var e;this.modelPath=t,this.keys=(e=this.modelPath,{info:[Ao,e,To].join(Io),topology:[Ao,e,zo].join(Io),weightSpecs:[Ao,e,$o].join(Io),weightData:[Ao,e,Co].join(Io),modelMetadata:[Ao,e,_o].join(Io)})}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const e=JSON.stringify(t.modelTopology),n=JSON.stringify(t.weightSpecs),s=ko(t);try{this.LS.setItem(this.keys.info,JSON.stringify(s)),this.LS.setItem(this.keys.topology,e),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(t){if(go)return Buffer.from(t).toString("base64");const e=new Uint8Array(t);let n="";for(let t=0,s=e.length;t<s;t++)n+=String.fromCharCode(e[t]);return btoa(n)}(t.weightData));const r={format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy,signature:null!=t.signature?t.signature:void 0,userDefinedMetadata:null!=t.userDefinedMetadata?t.userDefinedMetadata:void 0,modelInitializer:null!=t.modelInitializer?t.modelInitializer:void 0,initializerSignature:null!=t.initializerSignature?t.initializerSignature:void 0,trainingConfig:null!=t.trainingConfig?t.trainingConfig:void 0};return this.LS.setItem(this.keys.modelMetadata,JSON.stringify(r)),{modelArtifactsInfo:s}}catch(t){throw function(t){for(const e of Object.values(t))window.localStorage.removeItem(e)}(this.keys),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${s.modelTopologyBytes}, weightSpecsBytes=${s.weightSpecsBytes}, weightDataBytes=${s.weightDataBytes}.`)}}}async load(){const t=JSON.parse(this.LS.getItem(this.keys.info));if(null==t)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==t.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const e={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);e.modelTopology=n;const s=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==s)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);e.weightSpecs=s;const r=this.LS.getItem(this.keys.modelMetadata);if(null!=r){const t=JSON.parse(r);e.format=t.format,e.generatedBy=t.generatedBy,e.convertedBy=t.convertedBy,null!=t.signature&&(e.signature=t.signature),null!=t.userDefinedMetadata&&(e.userDefinedMetadata=t.userDefinedMetadata),null!=t.modelInitializer&&(e.modelInitializer=t.modelInitializer),null!=t.initializerSignature&&(e.initializerSignature=t.initializerSignature),null!=t.trainingConfig&&(e.trainingConfig=t.trainingConfig)}const i=this.LS.getItem(this.keys.weightData);if(null==i)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return e.weightData=function(t){if(go){const e=Buffer.from(t,"base64");return e.buffer.slice(e.byteOffset,e.byteOffset+e.byteLength)}const e=atob(t),n=new Uint8Array(e.length);for(let t=0;t<e.length;++t)n.set([e.charCodeAt(t)],t);return n.buffer}(i),e}}Do.URL_SCHEME="localstorage://";const Fo=t=>{return fs().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(Do.URL_SCHEME)?(e=t.slice(Do.URL_SCHEME.length),new Do(e)):null;var e};vo.registerSaveRouter(Fo),vo.registerLoadRouter(Fo);function Ro(t){return new Promise((t=>setTimeout(t))).then(t)}class Mo{constructor(t){if(!fs().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");t.startsWith(Mo.URL_SCHEME)&&(t=t.slice(Mo.URL_SCHEME.length)),null!=t&&0!==t.length||(t="model"),this.modelJsonFileName=t+".json",this.weightDataFileName=t+".weights.bin"}async save(t){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const e=window.URL.createObjectURL(new Blob([t.weightData],{type:"application/octet-stream"}));if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=yo(t,[{paths:["./"+this.weightDataFileName],weights:t.weightSpecs}]),s=window.URL.createObjectURL(new Blob([JSON.stringify(n)],{type:"application/json"})),r=null==this.modelJsonAnchor?document.createElement("a"):this.modelJsonAnchor;if(r.download=this.modelJsonFileName,r.href=s,await Ro((()=>r.dispatchEvent(new MouseEvent("click")))),null!=t.weightData){const t=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;t.download=this.weightDataFileName,t.href=e,await Ro((()=>t.dispatchEvent(new MouseEvent("click"))))}return{modelArtifactsInfo:ko(t)}}}}Mo.URL_SCHEME="downloads://";function Lo(t,e,n,s){!function(t){Kn(null!=t&&Array.isArray(t)&&t.length>0,(()=>"promises must be a none empty array"))}(t),function(t,e){Kn(t>=0&&t<=1,(()=>`Progress fraction must be in range [0, 1], but got startFraction ${t}`)),Kn(e>=0&&e<=1,(()=>`Progress fraction must be in range [0, 1], but got endFraction ${e}`)),Kn(e>=t,(()=>`startFraction must be no more than endFraction, but got startFraction ${t} and endFraction ${e}`))}(n=null==n?0:n,s=null==s?1:s);let r=0;return Promise.all(t.map((i=>(i.then((i=>{const a=n+ ++r/t.length*(s-n);return e(a),i})),i))))}vo.registerSaveRouter((t=>fs().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(Mo.URL_SCHEME)?function(t="model"){return new Mo(t)}(t.slice(Mo.URL_SCHEME.length)):null));class Oo{constructor(t,e){if(this.DEFAULT_METHOD="POST",null==e&&(e={}),this.weightPathPrefix=e.weightPathPrefix,this.onProgress=e.onProgress,this.weightUrlConverter=e.weightUrlConverter,null!=e.fetchFunc?(Kn("function"==typeof e.fetchFunc,(()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)")),this.fetch=e.fetchFunc):this.fetch=fs().platform.fetch,Kn(null!=t&&t.length>0,(()=>"URL path for http must not be null, undefined or empty.")),Array.isArray(t)&&Kn(2===t.length,(()=>`URL paths for http must have a length of 2, (actual length is ${t.length}).`)),this.path=t,null!=e.requestInit&&null!=e.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=e.requestInit||{}}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const e=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);e.body=new FormData;const n=yo(t,[{paths:["./model.weights.bin"],weights:t.weightSpecs}]);e.body.append("model.json",new Blob([JSON.stringify(n)],{type:"application/json"}),"model.json"),null!=t.weightData&&e.body.append("model.weights.bin",new Blob([t.weightData],{type:"application/octet-stream"}),"model.weights.bin");const s=await this.fetch(this.path,e);if(s.ok)return{modelArtifactsInfo:ko(t),responses:[s]};throw new Error(`BrowserHTTPRequest.save() failed due to HTTP response status ${s.status}.`)}async load(){const t=await this.fetch(this.path,this.requestInit);if(!t.ok)throw new Error(`Request to ${this.path} failed with status code ${t.status}. Please verify this URL points to the model JSON of the model to load.`);let e;try{e=await t.json()}catch(t){let e=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?e+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":e+=" Please make sure the server is serving valid JSON for this request.",new Error(e)}const n=e.modelTopology,s=e.weightsManifest;if(null==n&&null==s)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);return wo(e,(t=>this.loadWeights(t)))}async loadWeights(t){const e=Array.isArray(this.path)?this.path[1]:this.path,[n,s]=function(t){const e=t.lastIndexOf("/"),n=t.lastIndexOf("?"),s=t.substring(0,e),r=n>e?t.substring(n):"";return[s+"/",r]}(e),r=this.weightPathPrefix||n,i=function(t){const e=[];for(const n of t)e.push(...n.weights);return e}(t),a=[],o=[];for(const e of t)for(const t of e.paths)null!=this.weightUrlConverter?o.push(this.weightUrlConverter(t)):a.push(r+t+s);this.weightUrlConverter&&a.push(...await Promise.all(o));const l=await async function(t,e){null==e&&(e={});const n=null==e.fetchFunc?fs().platform.fetch:e.fetchFunc,s=t.map((t=>n(t,e.requestInit,{isBinary:!0}))),r=(null==e.onProgress?await Promise.all(s):await Lo(s,e.onProgress,0,.5)).map((t=>t.arrayBuffer()));return null==e.onProgress?await Promise.all(r):await Lo(r,e.onProgress,.5,1)}(a,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress});return[i,bo(l)]}}function Bo(t){return null!=t.match(Oo.URL_SCHEME_REGEX)}Oo.URL_SCHEME_REGEX=/^https?:\/\//;const Po=(t,e)=>{if("undefined"==typeof fetch&&(null==e||null==e.fetchFunc))return null;{let n=!0;if(n=Array.isArray(t)?t.every((t=>Bo(t))):Bo(t),n)return function(t,e){return new Oo(t,e)}(t,e)}return null};vo.registerSaveRouter(Po),vo.registerLoadRouter(Po);const Wo=Fr({oneHot_:function(t,e,n=1,s=0,r="int32"){if(e<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${e}`);const i={indices:_r(t,"indices","oneHot","int32")},a={dtype:r,depth:e,onValue:n,offValue:s};return Ar.runKernel(an,i,a)}});let Uo;function Vo(t,e,n){if(e.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${e.rank}.`);if(t.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${t.rank}.`);if("int32"!==e.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${e.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===e.size)throw new Error(`Indices specified for empty output. indices shape: ${e.shape}`);if(0===t.size)throw new Error(`Updates specified for empty output. updates shape: ${t.shape}`)}!function(t,e,n){const s=e.rank>1?e.shape[e.rank-1]:1,r=e.rank>1?e.rank-1:1,i=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${e.shape}, shape: ${t}, sliceDim: ${s}, and batchDim: ${r}.`;if(n.rank<r)throw new Error(i+` update.rank < ${r}. `);if(t.length<s+(n.rank-r))throw new Error(i+` Output shape length < ${s+(n.rank-r)}`);if(n.rank!==r+t.length-s)throw new Error(i+" update.rank != "+(r+t.length-s));for(let t=0;t<r;++t)if(n.shape[t]!==e.shape[t])throw new Error(i+` updates.shape[${t}] (${n.shape[t]}) != indices.shape[${t}] (${e.shape[t]}).`);for(let e=0;e<n.rank-r;++e)if(n.shape[e+r]!==t[e+s])throw new Error(i+` updates.shape[${e+r}] (${n.shape[e+r]}) != shape[${e+r}] (${t[e+r]})`)}(n,e,t)}Fr({confusionMatrix_:function(t,e,n){const s=_r(t,"labels","confusionMatrix"),r=_r(e,"predictions","confusionMatrix");Kn(null==n||n>0&&Number.isInteger(n),(()=>`If provided, numClasses must be a positive integer, but got ${n}`)),Kn(1===s.rank,(()=>`Expected the rank of labels to be 1, but got ${s.rank}`)),Kn(1===r.rank,(()=>`Expected the rank of predictions to be 1, but got ${r.rank}`)),Kn(s.shape[0]===r.shape[0],(()=>`Mismatch in the number of examples: ${s.shape[0]} vs. ${r.shape[0]}. Labels and predictions should have the same number of elements.`)),Kn(n>0&&Number.isInteger(n),(()=>`numClasses is required to be a positive integer, but got ${n}`));const i=Wo(Rr(s,"int32"),n),a=Wo(Rr(r,"int32"),n),o=ia(i),l=vi(o,a);return Rr(l,"int32")}}),Fr({fromPixels_:function(t,e=3){if(e>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==t)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,s=!1,r=!1,i=!1,a=!1,o=!1;if(t.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&t instanceof ImageData)s=!0;else if("undefined"!=typeof HTMLVideoElement&&t instanceof HTMLVideoElement)r=!0;else if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement)i=!0;else if(null!=t.getContext)a=!0;else{if(!("undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap))throw new Error(`pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was ${t.constructor.name}`);o=!0}if(null!=xs(Bn,Ar.backendName)){const n={pixels:t},s={numChannels:e};return Ar.runKernel(Bn,n,s)}const[l,u]=r?[t.videoWidth,t.videoHeight]:[t.width,t.height];let h,c;if(a)h=t.getContext("2d").getImageData(0,0,l,u).data;else if(s||n)h=t.data;else if(i||r||o){if(null==Uo)if("undefined"==typeof document){if("undefined"==typeof OffscreenCanvas||"undefined"==typeof OffscreenCanvasRenderingContext2D)throw new Error("Cannot parse input in current context. Reason: OffscreenCanvas Context2D rendering is not supported.");Uo=new OffscreenCanvas(1,1).getContext("2d")}else Uo=document.createElement("canvas").getContext("2d",{willReadFrequently:!0});Uo.canvas.width=l,Uo.canvas.height=u,Uo.drawImage(t,0,0,l,u),h=Uo.getImageData(0,0,l,u).data}if(4===e)c=new Int32Array(h);else{const t=l*u;c=new Int32Array(t*e);for(let n=0;n<t;n++)for(let t=0;t<e;++t)c[n*e+t]=h[4*n+t]}return function(t,e,n){if(qn(t),null!=e&&3!==e.length)throw new Error("tensor3d() requires shape to have three numbers");const s=zr(t,n);if(3!==s.length&&1!==s.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return Ur(t,e,s,n)}(c,[u,l,e],"int32")}});class Ko{constructor(){this.classNameMap={}}static getMap(){return null==Ko.instance&&(Ko.instance=new Ko),Ko.instance}static register(t){Ko.getMap().classNameMap[t.className]=[t,t.fromConfig]}}function jo(t){Kn(null!=t.className,(()=>"Class being registered does not have the static className property defined.")),Kn("string"==typeof t.className,(()=>"className is required to be a string, but got type "+typeof t.className)),Kn(t.className.length>0,(()=>"Class being registered has an empty-string as its className, which is disallowed.")),Ko.register(t)}const qo=Fr({abs_:function(t){const e=_r(t,"x","abs");if("complex64"===e.dtype){const t={x:e};return Ar.runKernel(Te,t)}{const t={x:e};return Ar.runKernel("Abs",t)}}});Fr({acos_:function(t){const e={x:_r(t,"x","acos")};return Ar.runKernel(he,e)}}),Fr({acosh_:function(t){const e={x:_r(t,"x","acosh")};return Ar.runKernel(ce,e)}}),Fr({addN_:function(t){Kn(Array.isArray(t),(()=>"The argument passed to tf.addN() must be a list of tensors")),Kn(t.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${t.length}`));const e=t.map(((t,e)=>_r(t,`tensors${e}`,"addN"))),n=e[0];e.forEach((t=>{if(t.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),e.forEach((t=>{if(!Jn(t.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const s=e;return Ar.runKernel(de,s)}}),Fr({all_:function(t,e=null,n=!1){const s={x:_r(t,"x","all","bool")},r={axis:e,keepDims:n};return Ar.runKernel("All",s,r)}}),Fr({any_:function(t,e=null,n=!1){const s={x:_r(t,"x","any","bool")},r={axis:e,keepDims:n};return Ar.runKernel("Any",s,r)}}),Fr({argMax_:function(t,e=0){const n={x:_r(t,"x","argMax")},s={axis:e};return Ar.runKernel(fe,n,s)}}),Fr({argMin_:function(t,e=0){const n={x:_r(t,"x","argMin")},s={axis:e};return Ar.runKernel(ge,n,s)}}),Fr({asin_:function(t){const e={x:_r(t,"x","asin")};return Ar.runKernel(me,e)}}),Fr({asinh_:function(t){const e={x:_r(t,"x","asinh")};return Ar.runKernel(be,e)}}),Fr({atan_:function(t){const e={x:_r(t,"x","atan")};return Ar.runKernel(ye,e)}}),Fr({atan2_:function(t,e){let n=_r(t,"a","atan2"),s=_r(e,"b","atan2");[n,s]=vr(n,s);const r={a:n,b:s};return Ar.runKernel(ke,r)}}),Fr({atanh_:function(t){const e={x:_r(t,"x","atanh")};return Ar.runKernel(we,e)}});const Go=Fr({avgPool_:function(t,e,n,s,r){const i=_r(t,"x","avgPool","float32");Kn(gi(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let a=i,o=!1;3===i.rank&&(o=!0,a=Yr(i,[1,i.shape[0],i.shape[1],i.shape[2]])),Kn(4===a.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${a.rank}.`)),mi("avgPool",s,r);const l={x:a},u={filterSize:e,strides:n,pad:s,dimRoundingMode:r};let h=Ar.runKernel(ve,l,u);return h=Rr(h,i.dtype),o?Yr(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});Fr({avgPool3d_:function(t,e,n,s,r,i="NDHWC"){const a=_r(t,"x","avgPool3d","float32");let o=a,l=!1;4===a.rank&&(l=!0,o=Yr(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),Kn(5===o.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${o.rank}.`)),Kn("NDHWC"===i,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${i}`)),mi("avgPool3d",s,r);const u={x:o},h={filterSize:e,strides:n,pad:s,dimRoundingMode:r,dataFormat:i};let c=Ar.runKernel(xe,u,h);return c=Rr(c,o.dtype),l?Yr(c,[c.shape[1],c.shape[2],c.shape[3],c.shape[4]]):c}});const Ho=Fr({concat_:function(t,e=0){Kn(t.length>=1,(()=>"Pass at least one tensor to concat"));const n=Dr(t,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((t=>{if("complex64"!==t.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${t.dtype}. `)})),1===n.length)return Ci(n[0]);const s=n,r={axis:e};return Ar.runKernel(ze,s,r)}});const Jo=Fr({sigmoid_:function(t){const e={x:_r(t,"x","sigmoid","float32")};return Ar.runKernel(En,e)}});const Zo=Fr({tanh_:function(t){const e={x:_r(t,"x","tanh","float32")};return Ar.runKernel(_n,e)}});Fr({basicLSTMCell_:function(t,e,n,s,r,i){const a=_r(t,"forgetBias","basicLSTMCell"),o=_r(e,"lstmKernel","basicLSTMCell"),l=_r(n,"lstmBias","basicLSTMCell"),u=_r(s,"data","basicLSTMCell"),h=_r(r,"c","basicLSTMCell"),c=_r(i,"h","basicLSTMCell"),p=Ho([u,c],1),d=vi(p,o),f=ii(d,l),g=f.shape[0],m=f.shape[1]/4,b=[g,m],y=Xa(f,[0,0],b),w=Xa(f,[0,m],b),k=Xa(f,[0,2*m],b),v=Xa(f,[0,3*m],b),x=ii(Mr(Jo(y),Zo(w)),Mr(h,Jo(ii(a,k))));return[x,Mr(Zo(x),Jo(v))]}});const Yo=Fr({batchToSpaceND_:function(t,e,n){const s=_r(t,"x","batchToSpaceND"),r=e.reduce(((t,e)=>t*e));Kn(s.rank>=1+e.length,(()=>`input rank is ${s.rank} but should be > than blockShape.length ${e.length}`)),Kn(n.length===e.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${e.length}`)),Kn(s.shape[0]%r==0,(()=>`input tensor batch is ${s.shape[0]} but is not divisible by the product of the elements of blockShape ${e.join(" * ")} === ${r}`));const i={x:s},a={blockShape:e,crops:n};return Ar.runKernel(Ne,i,a)}});const Xo=Fr({batchNorm_:function(t,e,n,s,r,i){null==i&&(i=.001);const a=_r(t,"x","batchNorm"),o=_r(e,"mean","batchNorm"),l=_r(n,"variance","batchNorm");let u,h;null!=r&&(u=_r(r,"scale","batchNorm")),null!=s&&(h=_r(s,"offset","batchNorm")),Kn(o.rank===l.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),Kn(null==h||o.rank===h.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),Kn(null==u||o.rank===u.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const c=function(t){let e;return e=0===t.rank||1===t.rank?Yr(t,[1,1,1,t.size]):2===t.rank?Yr(t,[1,1,t.shape[0],t.shape[1]]):3===t.rank?Yr(t,[1,t.shape[0],t.shape[1],t.shape[2]]):t,e}(a),p={x:c,scale:u,offset:h,mean:o,variance:l},d={varianceEpsilon:i},f=Ar.runKernel(Ue,p,d);return Yr(f,a.shape)}});Fr({batchNorm2d_:function(t,e,n,s,r,i){const a=_r(t,"x","batchNorm"),o=_r(e,"mean","batchNorm"),l=_r(n,"variance","batchNorm");let u,h;return null!=r&&(u=_r(r,"scale","batchNorm")),null!=s&&(h=_r(s,"offset","batchNorm")),Kn(2===a.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${a.rank}.`)),Kn(2===o.rank||1===o.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${o.rank}.`)),Kn(2===l.rank||1===l.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${l.rank}.`)),null!=u&&Kn(2===u.rank||1===u.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${u.rank}.`)),null!=h&&Kn(2===h.rank||1===h.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`)),Xo(a,o,l,h,u,i)}}),Fr({batchNorm3d_:function(t,e,n,s,r,i){const a=_r(t,"x","batchNorm"),o=_r(e,"mean","batchNorm"),l=_r(n,"variance","batchNorm");let u,h;return null!=r&&(u=_r(r,"scale","batchNorm")),null!=s&&(h=_r(s,"offset","batchNorm")),Kn(3===a.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${a.rank}.`)),Kn(3===o.rank||1===o.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${o.rank}.`)),Kn(3===l.rank||1===l.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${l.rank}.`)),null!=u&&Kn(3===u.rank||1===u.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${u.rank}.`)),null!=h&&Kn(3===h.rank||1===h.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`)),Xo(a,o,l,h,u,i)}}),Fr({batchNorm4d_:function(t,e,n,s,r,i){const a=_r(t,"x","batchNorm"),o=_r(e,"mean","batchNorm"),l=_r(n,"variance","batchNorm");let u,h;return null!=r&&(u=_r(r,"scale","batchNorm")),null!=s&&(h=_r(s,"offset","batchNorm")),Kn(4===a.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${a.rank}.`)),Kn(4===o.rank||1===o.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${o.rank}.`)),Kn(4===l.rank||1===l.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${l.rank}.`)),null!=u&&Kn(4===u.rank||1===u.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${u.rank}.`)),null!=h&&Kn(4===h.rank||1===h.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`)),Xo(a,o,l,h,u,i)}});const Qo=Fr({bincount_:function(t,e,n){const s=_r(t,"x","bincount"),r=_r(e,"weights","bincount");Kn("int32"===s.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${s.dtype}`)),Kn(n>=0,(()=>`size must be non-negative, but got ${n}.`)),Kn(r.size===s.size||0===r.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${s.shape}, weights shape: ${r.shape}.`));const i={x:s,weights:r},a={size:n};return Ar.runKernel("Bincount",i,a)}});function tl(t,e="float32",n){return e=e||"float32",us(t),new hr(t,e,n)}function el(t,e,n){const s={shape:t,value:e,dtype:n};return Ar.runKernel("Fill",{},s)}Fr({broadcastArgs_:function(t,e){const n=_r(t,"s0","broadcastArgs","int32"),s=_r(e,"s1","broadcastArgs","int32");if(1!==n.rank)throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);if(1!==s.rank)throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${s.rank}`);const r={s0:n,s1:s};return Ar.runKernel("BroadcastArgs",r)}}),Fr({ceil_:function(t){const e={x:_r(t,"x","ceil","float32")};return Ar.runKernel(Ie,e)}}),Fr({clipByValue_:function(t,e,n){const s=_r(t,"x","clipByValue");if(Kn(e<=n,(()=>`Error in clip: min (${e}) must be less than or equal to max (${n}).`)),e===n)return el(s.shape,e,s.dtype);const r={x:s},i={clipValueMin:e,clipValueMax:n};return Ar.runKernel(Ae,r,i)}}),Fr({concat1d_:function(t){return Ho(t,0)}}),Fr({concat2d_:function(t,e){return Ho(t,e)}}),Fr({concat3d_:function(t,e){return Ho(t,e)}}),Fr({concat4d_:function(t,e){return Ho(t,e)}}),Fr({conv1d_:function(t,e,n,s,r="NWC",i=1,a){const o=_r(t,"x","conv1d"),l=_r(e,"filter","conv1d");let u=o,h=!1;2===o.rank&&(h=!0,u=Yr(o,[1,o.shape[0],o.shape[1]])),Kn(3===u.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${u.rank}.`)),Kn(3===l.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${l.rank}.`)),mi("conv1d",s,a),Kn(u.shape[2]===l.shape[1],(()=>`Error in conv1d: depth of input (${u.shape[2]}) must match input depth for filter ${l.shape[1]}.`)),Kn(gi(n,i),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${i}'`)),Kn("NWC"===r,(()=>`Error in conv1d: got dataFormat of ${r} but only NWC is currently supported.`));const c=Yr(l,[1,l.shape[0],l.shape[1],l.shape[2]]),p=Yr(u,[u.shape[0],1,u.shape[1],u.shape[2]]),d=Wi(p,c,[1,n],s,"NHWC",[1,i],a);return Yr(d,h?[d.shape[2],d.shape[3]]:[d.shape[0],d.shape[2],d.shape[3]])}}),Fr({conv2dTranspose_:function(t,e,n,s,r,i){const a=_r(t,"x","conv2dTranspose"),o=_r(e,"filter","conv2dTranspose");return Bi(n,a,o,s,r,"NHWC",i)}}),Fr({conv3d_:function(t,e,n,s,r="NDHWC",i=[1,1,1]){const a=_r(t,"x","conv3d"),o=_r(e,"filter","conv3d");let l=a,u=!1;4===a.rank&&(u=!0,l=Yr(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),Kn(5===l.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${l.rank}.`)),Kn(5===o.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${o.rank}.`)),Kn(l.shape[4]===o.shape[3],(()=>`Error in conv3d: depth of input (${l.shape[4]}) must match input depth for filter ${o.shape[3]}.`)),Kn(gi(n,i),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`)),Kn("NDHWC"===r,(()=>`Error in conv3d: got dataFormat of ${r} but only NDHWC is currently supported.`));const h={x:l,filter:o},c={strides:n,pad:s,dataFormat:r,dilations:i},p=Ar.runKernel(_e,h,c);return u?Yr(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}}),Fr({conv3dTranspose_:function(t,e,n,s,r){const i=_r(t,"x","conv3dTranspose"),a=_r(e,"filter","conv3dTranspose");return Ki(n,i,a,s,r)}});const nl=Fr({cos_:function(t){const e={x:_r(t,"x","cos","float32")};return Ar.runKernel("Cos",e)}});const sl=Fr({cosh_:function(t){const e={x:_r(t,"x","cosh","float32")};return Ar.runKernel(De,e)}});const rl=Fr({cumprod_:function(t,e=0,n=!1,s=!1){const r={x:_r(t,"x","cumprod")},i={axis:e,exclusive:n,reverse:s};return Ar.runKernel("Cumprod",r,i)}});Fr({denseBincount_:function(t,e,n,s=!1){const r=_r(t,"x","denseBincount"),i=_r(e,"weights","denseBincount");Kn("int32"===r.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${r.dtype}`)),Kn(r.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${r.rank}.`)),Kn(n>=0,(()=>`size must be non-negative, but got ${n}.`)),Kn(i.size===r.size||0===i.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${r.shape}, weights shape: ${i.shape}.`));const a={x:r,weights:i},o={size:n,binaryOutput:s};return Ar.runKernel("DenseBincount",a,o)}}),Fr({depthToSpace_:function(t,e,n="NHWC"){const s=_r(t,"x","depthToSpace","float32"),r="NHWC"===n?s.shape[1]:s.shape[2],i="NHWC"===n?s.shape[2]:s.shape[3],a="NHWC"===n?s.shape[3]:s.shape[1];Kn(e>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${e}`)),Kn(r*e>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${r} and ${e}  for depthToSpace with input shape\n    ${s.shape}`)),Kn(i*e>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${i} and ${e} for depthToSpace with input shape\n        ${s.shape}`)),Kn(a%(e*e)==0,(()=>`Dimension size must be evenly divisible by ${e*e} but is ${a} for depthToSpace with input shape ${s.shape}`));const o={x:s},l={blockSize:e,dataFormat:n};return Ar.runKernel("DepthToSpace",o,l)}});const il=Fr({depthwiseConv2d_:function(t,e,n,s,r="NHWC",i=[1,1],a){const o=_r(t,"x","depthwiseConv2d","float32"),l=_r(e,"filter","depthwiseConv2d","float32");let u=o,h=!1;3===o.rank&&(h=!0,u=Yr(o,[1,o.shape[0],o.shape[1],o.shape[2]])),Kn(4===u.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${u.rank}.`)),Kn(4===l.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${l.rank}.`));const c="NHWC"===r?u.shape[3]:u.shape[1];Kn(c===l.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${c}) must match the inChannels dimension in filter ${l.shape[2]}.`)),mi("depthwiseConv2d",s,a);const p={x:u,filter:l},d={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a},f=Ar.runKernel(Re,p,d);return h?Yr(f,[f.shape[1],f.shape[2],f.shape[3]]):f}});Fr({diag_:function(t){const e={x:_r(t,"x","diag")};return Ar.runKernel("Diag",e)}}),Fr({dilation2d_:function(t,e,n,s,r=[1,1],i="NHWC"){const a=_r(t,"x","dilation2d"),o=_r(e,"filter","dilation2d");Kn(3===a.rank||4===a.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${a.rank}.`)),Kn(3===o.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${o.rank}.`)),Kn("NHWC"===i,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${i}`));let l=a,u=!1;3===a.rank&&(l=Yr(a,[1,a.shape[0],a.shape[1],a.shape[2]]),u=!0);const h={x:l,filter:o},c={strides:n,pad:s,dilations:r},p=Ar.runKernel(Me,h,c);return u?Yr(p,[p.shape[1],p.shape[2],p.shape[3]]):p}}),Fr({divNoNan_:function(t,e){let n=_r(t,"a","div"),s=_r(e,"b","div");[n,s]=vr(n,s);const r=Pr(n,s),i=ei(r),a=Oa(s,i);return Di(a,i,r)}}),Fr({dot_:function(t,e){const n=_r(t,"t1","dot"),s=_r(e,"t2","dot");Kn(!(1!==n.rank&&2!==n.rank||1!==s.rank&&2!==s.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${s.rank}.`));const r=1===n.rank?n.size:n.shape[1],i=1===s.rank?s.size:s.shape[0];if(Kn(r===i,(()=>`Error in dot: inner dimensions of inputs must match, but got ${r} and ${i}.`)),1===n.rank&&1===s.rank){const t=Yr(n,[1,-1]),e=Yr(s,[-1,1]),r=vi(t,e);return Yr(r,[])}if(1===n.rank&&2===s.rank){const t=Yr(n,[1,-1]),e=Yr(s,[s.shape[0],s.shape[1]]),r=vi(t,e);return Yr(r,[r.size])}if(2===n.rank&&1===s.rank){const t=Yr(s,[-1,1]),e=vi(n,t);return Yr(e,[e.size])}{const t=Yr(s,[s.shape[0],s.shape[1]]);return vi(n,t)}}}),Fr({einsum_:function(t,...e){const n=e.map(((t,e)=>_r(t,`tensors${e}`,"einsum"))),s={equation:t};return Ar.runKernel("Einsum",n,s)}});const al=Fr({elu_:function(t){const e={x:_r(t,"x","elu","float32")};return Ar.runKernel("Elu",e)}});Fr({erf_:function(t){let e=_r(t,"x","erf");Kn("int32"===e.dtype||"float32"===e.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===e.dtype&&(e=Rr(e,"float32"));const n={x:e};return Ar.runKernel("Erf",n)}});const ol=Fr({max_:function(t,e=null,n=!1){const s={x:_r(t,"x","max")},r={reductionIndices:e,keepDims:n};return Ar.runKernel("Max",s,r)}});const ll=Fr({min_:function(t,e=null,n=!1){const s={x:_r(t,"x","min")},r={axis:e,keepDims:n};return Ar.runKernel("Min",s,r)}});function ul(t,e,n=null){if(0===t.rank)return qo(t);if(1!==t.rank&&null===n)return ul(Yr(t,[-1]),e,n);if(1===t.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===e)return Xr(qo(t),n);if(e===1/0)return ol(qo(t),n);if(e===-1/0)return ll(qo(t),n);if("euclidean"===e||2===e)return Kr(Xr(ho(qo(t),Vr(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${e}`)}if(Array.isArray(n)&&2===n.length){if(1===e)return ol(Xr(qo(t),n[0]),n[1]-1);if(e===1/0)return ol(Xr(qo(t),n[1]),n[0]);if(e===-1/0)return ll(Xr(qo(t),n[1]),n[0]);if("fro"===e||"euclidean"===e)return Kr(Xr(jr(t),n));throw new Error(`Error in norm: invalid ord value: ${e}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const hl=Fr({norm_:function(t,e="euclidean",n=null,s=!1){const r=ul(t=_r(t,"x","norm"),e,n);let i=r.shape;if(s){const e=Xn(n,t.shape);i=Zi(r.shape,e)}return Yr(r,i)}});Fr({euclideanNorm_:function(t,e=null,n=!1){return hl(t,"euclidean",e,n)}});const cl=Fr({expandDims_:function(t,e=0){const n=_r(t,"x","expandDims","string_or_numeric");Kn(e<=n.rank,(()=>"Axis must be <= rank of the tensor"));const s={input:n},r={dim:e};return Ar.runKernel(Oe,s,r)}});Fr({expm1_:function(t){const e={x:_r(t,"x","expm1")};return Ar.runKernel(Be,e)}});const pl=Fr({eye_:function(t,e,n,s="float32"){null==e&&(e=t);const r=tl([t,e],s),i=t<=e?t:e;for(let t=0;t<i;++t)r.set(1,t,t);const a=Yr(r.toTensor(),[t,e]);if(null==n)return a;if(1===n.length)return ka(cl(a,0),[n[0],1,1]);if(2===n.length)return ka(cl(cl(a,0),0),[n[0],n[1],1,1]);if(3===n.length)return ka(cl(cl(cl(a,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});const dl=Fr({gather_:function(t,e,n=0,s=0){const r={x:_r(t,"x","gather"),indices:_r(e,"indices","gather","int32")},i={axis:n,batchDims:s};return Ar.runKernel(Ve,r,i)}});Fr({isFinite_:function(t){const e={x:_r(t,"x","isFinite")};return Ar.runKernel(qe,e)}}),Fr({isInf_:function(t){const e={x:_r(t,"x","isInf")};return Ar.runKernel(Ge,e)}}),Fr({isNaN_:function(t){const e={x:_r(t,"x","isNaN")};return Ar.runKernel(He,e)}});const fl=Fr({leakyRelu_:function(t,e=.2){const n={x:_r(t,"x","leakyRelu")},s={alpha:e};return Ar.runKernel(Je,n,s)}});Fr({localResponseNormalization_:function(t,e=5,n=1,s=1,r=.5){const i=_r(t,"x","localResponseNormalization");Kn(4===i.rank||3===i.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${i.rank}.`)),Kn(Zn(e),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${e}.`));let a=i,o=!1;3===i.rank&&(o=!0,a=Yr(i,[1,i.shape[0],i.shape[1],i.shape[2]]));const l={x:a},u={depthRadius:e,bias:n,alpha:s,beta:r},h=Ar.runKernel("LRN",l,u);return o?Yr(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const gl=Fr({log1p_:function(t){const e={x:_r(t,"x","log1p")};return Ar.runKernel(Ze,e)}});function ml(t){return Ar.customGrad(t)}const bl=Fr({softplus_:function(t){const e={x:_r(t,"x","softplus")};return Ar.runKernel(In,e)}});Fr({logSigmoid_:function(t){const e=_r(t,"x","logSigmoid"),n=ml((t=>({value:Wr(bl(Wr(t))),gradFunc:e=>Mr(e,Jo(Wr(t)))})));return n(e)}}),Fr({logSoftmax_:function(t,e=-1){const n=_r(t,"logits","logSoftmax");if(-1===e&&(e=n.rank-1),e!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${e}`);const s=ml(((t,n)=>{const s=ol(t,e,!0),r=qr(t,s),i=qr(Rr(r,"float32"),uo(Xr(pa(r),e,!0)));n([i]);return{value:i,gradFunc:(t,n)=>{const[s]=n,r=pa(s);return qr(t,Mr(Xr(t,e,!0),r))}}}));return s(n)}});const yl=Fr({logSumExp_:function(t,e=null,n=!1){const s=_r(t,"x","logSumExp"),r=Xn(e,s.shape),i=ol(s,r,!0),a=qr(s,i),o=pa(a),l=Xr(o,r),u=uo(l),h=ii(Yr(i,u.shape),u);if(n){const t=Zi(h.shape,r);return Yr(h,t)}return h}});const wl=Fr({logicalNot_:function(t){const e={x:_r(t,"x","logicalNot","bool")};return Ar.runKernel("LogicalNot",e)}});const kl=Fr({logicalOr_:function(t,e){const n=_r(t,"a","logicalOr","bool"),s=_r(e,"b","logicalOr","bool");Zr(n.shape,s.shape);const r={a:n,b:s};return Ar.runKernel("LogicalOr",r)}});Fr({logicalXor_:function(t,e){const n=_r(t,"a","logicalXor","bool"),s=_r(e,"b","logicalXor","bool");return Zr(n.shape,s.shape),$i(kl(t,e),wl($i(t,e)))}});const vl=2147483648;Fr({searchSorted_:function(t,e,n="left"){const s=_r(t,"sortedSequence","searchSorted"),r=_r(e,"values","searchSorted"),i=s.shape[s.shape.length-1],a=r.shape[r.shape.length-1],o=Yr(s,[-1,i]),l=Yr(r,[-1,a]);if(o.rank<2)throw new Error("Sorted input argument must be at least 2-dimensional");if(o.shape[0]!==l.shape[0])throw new Error("Leading dimension of 'sortedSequence' and 'values' must match.");if(Hn(l.shape)>=vl)throw new Error("values tensor size must less than 2147483648");if(o.shape[1]>=vl)throw new Error(`trailing dim_size must less than 2147483648 for int32 output type, was ${o.shape[1]}`);const u={sortedSequence:o,values:l},h={side:n};return Ar.runKernel("SearchSorted",u,h)}});const xl=Fr({maxPool_:function(t,e,n,s,r){const i=_r(t,"x","maxPool");let a=i,o=!1;3===i.rank&&(o=!0,a=Yr(i,[1,i.shape[0],i.shape[1],i.shape[2]])),Kn(4===a.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${a.rank}.`)),Kn(gi(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),mi("maxPool",s,r);const l={x:a},u={filterSize:e,strides:n,pad:s,dimRoundingMode:r},h=Ar.runKernel(Xe,l,u);return o?Yr(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});Fr({maxPool3d_:function(t,e=[1,1,1],n,s,r,i="NDHWC"){const a=_r(t,"x","maxPool3d");let o=a,l=!1;4===a.rank&&(l=!0,o=Yr(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),Kn(5===o.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${o.rank}.`)),Kn("NDHWC"===i,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${i}`)),mi("maxPool3d",s,r);const u={x:o},h={filterSize:e,strides:n,pad:s,dimRoundingMode:r,dataFormat:i},c=Ar.runKernel(Qe,u,h);return l?Yr(c,[c.shape[1],c.shape[2],c.shape[3],c.shape[4]]):c}}),Fr({maxPoolWithArgmax_:function(t,e,n,s,r=!1){const i={x:_r(t,"x","maxPoolWithArgmax")},a={filterSize:e,strides:n,pad:s,includeBatchInIndex:r},o=Ar.runKernel("MaxPoolWithArgmax",i,a);return{result:o[0],indexes:o[1]}}});const Sl=Fr({maximum_:function(t,e){let n=_r(t,"a","maximum"),s=_r(e,"b","maximum");[n,s]=vr(n,s),"bool"===n.dtype&&(n=Rr(n,"int32"),s=Rr(s,"int32")),Zr(n.shape,s.shape);const r={a:n,b:s};return Ar.runKernel(Ye,r)}});const Nl=Fr({mean_:function(t,e=null,n=!1){const s={x:_r(t,"x","mean")},r={axis:e,keepDims:n};return Ar.runKernel(tn,s,r)}});const El=Fr({minimum_:function(t,e){let n=_r(t,"a","minimum"),s=_r(e,"b","minimum");[n,s]=vr(n,s),"bool"===n.dtype&&(n=Rr(n,"int32"),s=Rr(s,"int32")),Zr(n.shape,s.shape);const r={a:n,b:s};return Ar.runKernel(en,r)}});Fr({mirrorPad_:function(t,e,n){Kn("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const s=_r(t,"x","mirrorPad");if(0===s.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");Kn(e.length===s.rank,(()=>`Padding doesn't match input. Must be ${s.rank}. Got ${e.length}.`));const r="reflect"===n?1:0;for(let t=0;t<s.rank;t++)Kn(2===e[t].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Kn(e[t][0]>=0&&e[t][0]<=s.shape[t]-r&&e[t][1]>=0&&e[t][1]<=s.shape[t]-r,(()=>`Padding in dimension ${t} cannot be greater than or equal to ${s.shape[t]-r} or less than 0 for input of shape ${s.shape}`));const i={paddings:e,mode:n},a={x:s};return Ar.runKernel(nn,a,i)}}),Fr({mod_:function(t,e){let n=_r(t,"a","mod"),s=_r(e,"b","mod");[n,s]=vr(n,s);const r={a:n,b:s};return Ar.runKernel("Mod",r)}}),Fr({moments_:function(t,e=null,n=!1){const s=Xn(e,(t=_r(t,"x","moments")).shape),r=Nl(t,s,n);let i=r.shape;n||(i=Zi(r.shape,s));const a=jr(qr(Rr(t,"float32"),Yr(r,i)));return{mean:r,variance:Nl(a,s,n)}}}),Fr({multiRNNCell_:function(t,e,n,s){const r=_r(e,"data","multiRNNCell"),i=Dr(n,"c","multiRNNCell"),a=Dr(s,"h","multiRNNCell");let o=r;const l=[];for(let e=0;e<t.length;e++){const n=t[e](o,i[e],a[e]);l.push(n[0]),l.push(n[1]),o=n[1]}const u=[],h=[];for(let t=0;t<l.length;t+=2)u.push(l[t]),h.push(l[t+1]);return[u,h]}}),Fr({multinomial_:function(t,e,n,s=!1){const r=_r(t,"logits","multinomial"),i=r.size,a=r.rank;if(i<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${i}.`);if(a>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${a}`);n=n||Math.random();const o={logits:1===a?Yr(r,[1,-1]):r},l={numSamples:e,seed:n,normalized:s},u=Ar.runKernel("Multinomial",o,l);return 1===a?Yr(u,[u.size]):u}});const Il=Fr({notEqual_:function(t,e){let n=_r(t,"a","notEqual","string_or_numeric"),s=_r(e,"b","notEqual","string_or_numeric");[n,s]=vr(n,s),Zr(n.shape,s.shape);const r={a:n,b:s};return Ar.runKernel("NotEqual",r)}});Fr({onesLike_:function(t){const e={x:_r(t,"x","onesLike")};return Ar.runKernel(rn,e)}}),Fr({outerProduct_:function(t,e){const n=_r(t,"v1","outerProduct"),s=_r(e,"v2","outerProduct");Kn(1===n.rank&&1===s.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${s.rank}.`));const r=Yr(n,[-1,1]),i=Yr(s,[1,-1]);return vi(r,i)}});const Al=Fr({pad_:function(t,e,n=0){const s=_r(t,"x","pad");if(0===s.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const r={paddings:e,constantValue:n},i={x:s};return Ar.runKernel(ln,i,r)}});Fr({pad1d_:function(t,e,n=0){return Kn(2===e.length,(()=>"Invalid number of paddings. Must be length of 2.")),Al(t,[e],n)}}),Fr({pad2d_:function(t,e,n=0){return Kn(2===e.length&&2===e[0].length&&2===e[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Al(t,e,n)}}),Fr({pad3d_:function(t,e,n=0){return Kn(3===e.length&&2===e[0].length&&2===e[1].length&&2===e[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Al(t,e,n)}}),Fr({pad4d_:function(t,e,n=0){return Kn(4===e.length&&2===e[0].length&&2===e[1].length&&2===e[2].length&&2===e[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Al(t,e,n)}}),Fr({pool_:function(t,e,n,s,r,i,a){null==r&&(r=[1,1]),null==i&&(i=1),0===s&&(s="valid");const o=_r(t,"x","maxPool");let l=o,u=!1;3===o.rank&&(u=!0,l=Yr(o,[1,o.shape[0],o.shape[1],o.shape[2]])),Kn(gi(i,r),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${i} and dilations '${r}'`));const h=function(t,e,n,s,r,i,a="channelsLast"){const[o,l]=ci(e);let u;if("channelsLast"===a)u=[o,l,t[3],t[3]];else{if("channelsFirst"!==a)throw new Error(`Unknown dataFormat ${a}`);u=[o,l,t[1],t[1]]}return hi(t,u,n,s,r,i,!1,a)}(l.shape,e,i,r,s),c=[h.dilationHeight,h.dilationWidth];let p;p="same"===s?function(t,e){const n=t.map(((t,n)=>t+(t-1)*(e[n]-1))).map((t=>t-1)),s=n.map((t=>Math.floor(t/2))),r=n.map(((t,e)=>t-s[e]));return n.map(((t,e)=>[s[e],r[e]]))}([h.filterHeight,h.filterWidth],c):[[0,0],[0,0]];const d=1===c[0]&&1===c[1],[f,g]=function(t,e,n){const s=n.map((t=>t[0])),r=n.map((t=>t[1])),i=t.concat(s,r),a=e.map(((t,e)=>(t-i[e]%t)%t)),o=r.map(((t,e)=>t+a[e])),l=e.map(((t,e)=>[s[e],o[e]])),u=e.map(((t,e)=>[0,a[e]]));return[l,u]}([h.inHeight,h.inWidth],c,p),m=d?s:"valid",b=d?l:Si(l,c,f),y=("avg"===n?()=>Go(b,e,i,m,a):()=>xl(b,e,i,m,a))(),w=d?y:Yo(y,c,g);return u?Yr(w,[w.shape[1],w.shape[2],w.shape[3]]):w}});const Tl=Fr({prelu_:function(t,e){const n={x:_r(t,"x","prelu"),alpha:_r(e,"alpha","prelu")};return Ar.runKernel(un,n)}});Fr({prod_:function(t,e=null,n=!1){let s=_r(t,"x","prod");"bool"===s.dtype&&(s=Rr(s,"int32"));const r={x:s},i={axis:e,keepDims:n};return Ar.runKernel(hn,r,i)}}),Fr({raggedGather_:function(t,e,n,s){const r={paramsNestedSplits:t.map(((t,e)=>_r(t,`tensors${e}`,"raggedGather","int32"))),paramsDenseValues:_r(e,"paramsDenseValues","raggedGather"),indices:_r(n,"indices","raggedGather","int32")},i={outputRaggedRank:s},a=Ar.runKernel("RaggedGather",r,i);return{outputNestedSplits:a.slice(0,a.length-1),outputDenseValues:a[a.length-1]}}}),Fr({raggedRange_:function(t,e,n){const s=_r(t,"starts","raggedRange"),r={starts:s,limits:_r(e,"limits","raggedRange",s.dtype),deltas:_r(n,"deltas","raggedRange",s.dtype)},i=Ar.runKernel("RaggedRange",r);return{rtNestedSplits:i[0],rtDenseValues:i[1]}}}),Fr({raggedTensorToTensor_:function(t,e,n,s,r){const i=_r(t,"shape","raggedTensorToTensor","int32"),a=_r(e,"values","raggedTensorToTensor"),o={shape:i,values:a,defaultValue:_r(n,"defaultValue","raggedTensorToTensor",a.dtype),rowPartitionTensors:s.map(((t,e)=>_r(t,`tensors${e}`,"raggedTensorToTensor","int32")))},l={rowPartitionTypes:r};return Ar.runKernel("RaggedTensorToTensor",o,l)}}),Fr({rand_:function(t,e,n){const s=Hn(t);let r=null;if(null==n||"float32"===n)r=new Float32Array(s);else if("int32"===n)r=new Int32Array(s);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);r=new Uint8Array(s)}for(let t=0;t<s;t++)r[t]=e();return Ar.makeTensor(r,t,n)}});var zl="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function $l(t){if(t.__esModule)return t;var e=Object.defineProperty({},"__esModule",{value:!0});return Object.keys(t).forEach((function(n){var s=Object.getOwnPropertyDescriptor(t,n);Object.defineProperty(e,n,s.get?s:{enumerable:!0,get:function(){return t[n]}})})),e}function Cl(t){var e={exports:{}};return t(e,e.exports),e.exports}var _l=Cl((function(t){!function(t,e,n){function s(t){var e,n=this,s=(e=4022871197,function(t){t=String(t);for(var n=0;n<t.length;n++){var s=.02519603282416938*(e+=t.charCodeAt(n));s-=e=s>>>0,e=(s*=e)>>>0,e+=4294967296*(s-=e)}return 2.3283064365386963e-10*(e>>>0)});n.next=function(){var t=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=t-(n.c=0|t)},n.c=1,n.s0=s(" "),n.s1=s(" "),n.s2=s(" "),n.s0-=s(t),n.s0<0&&(n.s0+=1),n.s1-=s(t),n.s1<0&&(n.s1+=1),n.s2-=s(t),n.s2<0&&(n.s2+=1),s=null}function r(t,e){return e.c=t.c,e.s0=t.s0,e.s1=t.s1,e.s2=t.s2,e}function i(t,e){var n=new s(t),i=e&&e.state,a=n.next;return a.int32=function(){return 4294967296*n.next()|0},a.double=function(){return a()+11102230246251565e-32*(2097152*a()|0)},a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.alea=i}(0,t,!1)})),Dl=Cl((function(t){!function(t,e,n){function s(t){var e=this,n="";e.x=0,e.y=0,e.z=0,e.w=0,e.next=function(){var t=e.x^e.x<<11;return e.x=e.y,e.y=e.z,e.z=e.w,e.w^=e.w>>>19^t^t>>>8},t===(0|t)?e.x=t:n+=t;for(var s=0;s<n.length+64;s++)e.x^=0|n.charCodeAt(s),e.next()}function r(t,e){return e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e}function i(t,e){var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xor128=i}(0,t,!1)})),Fl=Cl((function(t){!function(t,e,n){function s(t){var e=this,n="";e.next=function(){var t=e.x^e.x>>>2;return e.x=e.y,e.y=e.z,e.z=e.w,e.w=e.v,(e.d=e.d+362437|0)+(e.v=e.v^e.v<<4^t^t<<1)|0},e.x=0,e.y=0,e.z=0,e.w=0,e.v=0,t===(0|t)?e.x=t:n+=t;for(var s=0;s<n.length+64;s++)e.x^=0|n.charCodeAt(s),s==n.length&&(e.d=e.x<<10^e.x>>>4),e.next()}function r(t,e){return e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e.v=t.v,e.d=t.d,e}function i(t,e){var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xorwow=i}(0,t,!1)})),Rl=Cl((function(t){!function(t,e,n){function s(t){var e=this;e.next=function(){var t,n,s=e.x,r=e.i;return t=s[r],n=(t^=t>>>7)^t<<24,n^=(t=s[r+1&7])^t>>>10,n^=(t=s[r+3&7])^t>>>3,n^=(t=s[r+4&7])^t<<7,t=s[r+7&7],n^=(t^=t<<13)^t<<9,s[r]=n,e.i=r+1&7,n},function(t,e){var n,s=[];if(e===(0|e))s[0]=e;else for(e=""+e,n=0;n<e.length;++n)s[7&n]=s[7&n]<<15^e.charCodeAt(n)+s[n+1&7]<<13;for(;s.length<8;)s.push(0);for(n=0;n<8&&0===s[n];++n);for(8==n&&(s[7]=-1),t.x=s,t.i=0,n=256;n>0;--n)t.next()}(e,t)}function r(t,e){return e.x=t.x.slice(),e.i=t.i,e}function i(t,e){null==t&&(t=+new Date);var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&(i.x&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xorshift7=i}(0,t,!1)})),Ml=Cl((function(t){!function(t,e,n){function s(t){var e=this;e.next=function(){var t,n,s=e.w,r=e.X,i=e.i;return e.w=s=s+1640531527|0,n=r[i+34&127],t=r[i=i+1&127],n^=n<<13,t^=t<<17,n^=n>>>15,t^=t>>>12,n=r[i]=n^t,e.i=i,n+(s^s>>>16)|0},function(t,e){var n,s,r,i,a,o=[],l=128;for(e===(0|e)?(s=e,e=null):(e+="\0",s=0,l=Math.max(l,e.length)),r=0,i=-32;i<l;++i)e&&(s^=e.charCodeAt((i+32)%e.length)),0===i&&(a=s),s^=s<<10,s^=s>>>15,s^=s<<4,s^=s>>>13,i>=0&&(a=a+1640531527|0,r=0==(n=o[127&i]^=s+a)?r+1:0);for(r>=128&&(o[127&(e&&e.length||0)]=-1),r=127,i=512;i>0;--i)s=o[r+34&127],n=o[r=r+1&127],s^=s<<13,n^=n<<17,s^=s>>>15,n^=n>>>12,o[r]=s^n;t.w=a,t.X=o,t.i=r}(e,t)}function r(t,e){return e.i=t.i,e.w=t.w,e.X=t.X.slice(),e}function i(t,e){null==t&&(t=+new Date);var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&(i.X&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xor4096=i}(0,t,!1)})),Ll=Cl((function(t){!function(t,e,n){function s(t){var e=this,n="";e.next=function(){var t=e.b,n=e.c,s=e.d,r=e.a;return t=t<<25^t>>>7^n,n=n-s|0,s=s<<24^s>>>8^r,r=r-t|0,e.b=t=t<<20^t>>>12^n,e.c=n=n-s|0,e.d=s<<16^n>>>16^r,e.a=r-t|0},e.a=0,e.b=0,e.c=-1640531527,e.d=1367130551,t===Math.floor(t)?(e.a=t/4294967296|0,e.b=0|t):n+=t;for(var s=0;s<n.length+20;s++)e.b^=0|n.charCodeAt(s),e.next()}function r(t,e){return e.a=t.a,e.b=t.b,e.c=t.c,e.d=t.d,e}function i(t,e){var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.tychei=i}(0,t,!1)})),Ol=$l({__proto__:null,default:{}}),Bl=Cl((function(t){!function(e,n,s){var r,i=256,a=s.pow(i,6),o=s.pow(2,52),l=2*o,u=255;function h(t,u,h){var m=[],b=f(d((u=1==u?{entropy:!0}:u||{}).entropy?[t,g(n)]:null==t?function(){try{var t;return r&&(t=r.randomBytes)?t=t(i):(t=new Uint8Array(i),(e.crypto||e.msCrypto).getRandomValues(t)),g(t)}catch(t){var s=e.navigator,a=s&&s.plugins;return[+new Date,e,a,e.screen,g(n)]}}():t,3),m),y=new c(m),w=function(){for(var t=y.g(6),e=a,n=0;t<o;)t=(t+n)*i,e*=i,n=y.g(1);for(;t>=l;)t/=2,e/=2,n>>>=1;return(t+n)/e};return w.int32=function(){return 0|y.g(4)},w.quick=function(){return y.g(4)/4294967296},w.double=w,f(g(y.S),n),(u.pass||h||function(t,e,n,r){return r&&(r.S&&p(r,y),t.state=function(){return p(y,{})}),n?(s.random=t,e):t})(w,b,"global"in u?u.global:this==s,u.state)}function c(t){var e,n=t.length,s=this,r=0,a=s.i=s.j=0,o=s.S=[];for(n||(t=[n++]);r<i;)o[r]=r++;for(r=0;r<i;r++)o[r]=o[a=u&a+t[r%n]+(e=o[r])],o[a]=e;(s.g=function(t){for(var e,n=0,r=s.i,a=s.j,o=s.S;t--;)e=o[r=u&r+1],n=n*i+o[u&(o[r]=o[a=u&a+e])+(o[a]=e)];return s.i=r,s.j=a,n})(i)}function p(t,e){return e.i=t.i,e.j=t.j,e.S=t.S.slice(),e}function d(t,e){var n,s=[],r=typeof t;if(e&&"object"==r)for(n in t)try{s.push(d(t[n],e-1))}catch(t){}return s.length?s:"string"==r?t:t+"\0"}function f(t,e){for(var n,s=t+"",r=0;r<s.length;)e[u&r]=u&(n^=19*e[u&r])+s.charCodeAt(r++);return g(e)}function g(t){return String.fromCharCode.apply(0,t)}if(f(s.random(),n),t.exports){t.exports=h;try{r=Ol}catch(t){}}else s.seedrandom=h}("undefined"!=typeof self?self:zl,[],Math)}));Bl.alea=_l,Bl.xor128=Dl,Bl.xorwow=Fl,Bl.xorshift7=Rl,Bl.xor4096=Ml,Bl.tychei=Ll;var Pl=Bl;class Wl{constructor(t,e,n,s,r){this.mean=t,this.stdDev=e,this.dtype=n,this.nextVal=NaN,this.truncated=s,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const i=r||Math.random();this.random=Pl.alea(i.toString())}nextValue(){if(!isNaN(this.nextVal)){const t=this.nextVal;return this.nextVal=NaN,t}let t,e,n=!1;for(;!n;){let s,r,i;do{s=2*this.random()-1,r=2*this.random()-1,i=s*s+r*r}while(i>=1||0===i);const a=Math.sqrt(-2*Math.log(i)/i);t=this.mean+this.stdDev*s*a,e=this.mean+this.stdDev*r*a,this.truncated&&!this.isValidTruncated(t)||(n=!0)}return this.truncated&&!this.isValidTruncated(e)||(this.nextVal=this.convertValue(e)),this.convertValue(t)}convertValue(t){return null==this.dtype||"float32"===this.dtype?t:Math.round(t)}isValidTruncated(t){return t<=this.upper&&t>=this.lower}}class Ul{constructor(t,e,n,s){this.alpha=t,this.beta=1/e,this.dtype=n;const r=s||Math.random();this.randu=Pl.alea(r.toString()),this.randn=new Wl(0,1,n,!1,this.randu()),this.d=t<1?t+2/3:t-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let t,e,n,s,r,i;for(;;){do{s=this.randn.nextValue(),i=1+this.c*s}while(i<=0);if(i*=i*i,t=s*s,e=1-.331*t*t,n=.5*t+this.d*(1-i+Math.log(i)),r=this.randu(),r<e||Math.log(r)<n)break}return i=1/this.beta*this.d*i,this.alpha<1&&(i*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(i)}convertValue(t){return"float32"===this.dtype?t:Math.round(t)}}class Vl{constructor(t=0,e=1,n,s){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=t,this.range=e-t,this.dtype=n,null==s&&(s=Math.random()),"number"==typeof s&&(s=s.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${t} - ${e} <= 1 and dtype is not float`);this.random=Pl.alea(s)}convertValue(t){return this.canReturnFloat()?t:Math.round(t)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}Fr({randomGamma_:function(t,e,n=1,s="float32",r){if(null==n&&(n=1),null==s&&(s="float32"),"float32"!==s&&"int32"!==s)throw new Error(`Unsupported data type ${s}`);const i=new Ul(e,n,s,r),a=tl(t,s);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}});const Kl=Fr({randomNormal_:function(t,e=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error(`Unsupported data type ${s}`);const i=new Wl(e,n,s,!1,r),a=tl(t,s);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}});Fr({randomStandardNormal_:function(t,e,n){if(null!=e&&"bool"===e)throw new Error(`Unsupported data type ${e}`);return Kl(t,0,1,e,n)}});const jl=Fr({randomUniform_:function(t,e=0,n=1,s="float32",r){const i=tl(t,s),a=new Vl(e,n,null,r);for(let t=0;t<i.values.length;t++)i.values[t]=a.nextValue();return i.toTensor()}});function ql(t,e,n=1,s="float32"){if(0===n)throw new Error("Cannot have a step of zero");const r={start:t,stop:e,step:n,dtype:s};return Ar.runKernel("Range",{},r)}Fr({reciprocal_:function(t){const e={x:_r(t,"x","reciprocal")};return Ar.runKernel(cn,e)}});const Gl=Fr({relu_:function(t){const e={x:_r(t,"x","relu")};return Ar.runKernel(pn,e)}});const Hl=Fr({relu6_:function(t){const e={x:_r(t,"x","relu6")};return Ar.runKernel(mn,e)}});const Jl=Fr({reverse_:function(t,e){const n={x:_r(t,"x","reverse")},s={dims:e};return Ar.runKernel(bn,n,s)}});Fr({reverse1d_:function(t){const e=_r(t,"x","reverse");return Kn(1===e.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${e.rank}.`)),Jl(e,0)}}),Fr({reverse2d_:function(t,e){const n=_r(t,"x","reverse");return Kn(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),Jl(n,e)}}),Fr({reverse3d_:function(t,e){const n=_r(t,"x","reverse");return Kn(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),Jl(n,e)}}),Fr({reverse4d_:function(t,e){const n=_r(t,"x","reverse");return Kn(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),Jl(n,e)}});const Zl=Fr({round_:function(t){const e={x:_r(t,"x","round")};return Ar.runKernel(yn,e)}});Fr({selu_:function(t){const e={x:_r(t,"x","selu")};return Ar.runKernel(vn,e)}}),Fr({separableConv2d_:function(t,e,n,s,r,i=[1,1],a="NHWC"){const o=_r(t,"x","separableConv2d"),l=_r(e,"depthwiseFilter","separableConv2d"),u=_r(n,"pointwiseFilter","separableConv2d");let h=o,c=!1;if(3===o.rank&&(c=!0,h=Yr(o,[1,o.shape[0],o.shape[1],o.shape[2]])),"NCHW"===a)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");Kn(4===h.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`)),Kn(4===l.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${l.rank}.`)),Kn(4===u.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${l.rank}.`)),Kn(1===u.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${u.shape[0]}.`)),Kn(1===u.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${u.shape[1]}.`));const p=l.shape[2],d=l.shape[3];Kn(u.shape[2]===p*d,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${p*d}, but got ${u.shape[2]}.`));const f=il(h,l,s,r,a,i),g=Wi(f,u,1,"valid",a);return c?Yr(g,[g.shape[1],g.shape[2],g.shape[3]]):g}}),Fr({sign_:function(t){const e={x:_r(t,"x","sign")};return Ar.runKernel(Nn,e)}}),Fr({slice1d_:function(t,e,n){const s=_r(t,"x","slice1d");return Kn(1===s.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${s.rank} tensor`)),Xa(s,[e],[n])}}),Fr({slice2d_:function(t,e,n){const s=_r(t,"x","slice2d");return Kn(2===s.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${s.rank} tensor`)),Xa(s,e,n)}}),Fr({slice3d_:function(t,e,n){const s=_r(t,"x","slice3d");return Kn(3===s.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${s.rank} tensor`)),Xa(s,e,n)}}),Fr({slice4d_:function(t,e,n){const s=_r(t,"x","slice4d");return Kn(4===s.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${s.rank} tensor`)),Xa(s,e,n)}}),Fr({softmax_:function(t,e=-1){const n=_r(t,"logits","softmax","float32");if(-1===e&&(e=n.rank-1),e!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${e}`);const s={logits:n},r={dim:e};return Ar.runKernel($n,s,r)}});const Yl=Fr({fft_:function(t){Kn("complex64"===t.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${t.dtype}.`));const e={input:t};return Ar.runKernel("FFT",e)}});const Xl=Fr({ifft_:function(t){Kn("complex64"===t.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${t.dtype}.`));const e={input:t};return Ar.runKernel("IFFT",e)}});Fr({irfft_:function(t){const e=t.shape[t.shape.length-1],n=t.size/e;let s;if(e<=2){const r=Yr(t,[n,e]);s=Xl(r)}else{const r=[n,2*(e-1)],i=Yr(ra(t),[n,e]),a=Yr(sa(t),[n,e]),o=Jl(Xa(i,[0,1],[n,e-2]),1),l=Mr(Jl(Xa(a,[0,1],[n,e-2]),1),Vr(-1)),u=Ho([i,o],1),h=Ho([a,l],1),c=Yr(na(u,h),[r[0],r[1]]);s=Xl(c)}if(s=ra(s),3===t.rank&&0!==t.shape[0]){const e=s,n=t.shape[0];s=Yr(s,[n,s.shape[0]/n,s.shape[1]]),e.dispose()}return s}});const Ql=Fr({rfft_:function(t,e){Kn("float32"===t.dtype,(()=>`The dtype for rfft() must be real value but got ${t.dtype}`));let n=t.shape[t.shape.length-1];const s=t.size/n;let r;if(null!=e&&e<n){const s=t.shape.map((t=>0)),i=t.shape.map((t=>t));i[t.shape.length-1]=e,r=Xa(t,s,i),n=e}else if(null!=e&&e>n){const s=t.shape.map((t=>t));s[t.shape.length-1]=e-n,r=Ho([t,Ga(s)],t.shape.length-1),n=e}else r=t;const i=ei(r),a=Yr(na(r,i),[s,n]),o=Yl(a),l=Math.floor(n/2)+1,u=ra(o),h=sa(o),c=Mi(u,[l,n-l],u.shape.length-1),p=Mi(h,[l,n-l],h.shape.length-1),d=r.shape.slice();return d[r.shape.length-1]=l,Yr(na(c[0],p[0]),d)}});const tu=Fr({squaredDifference_:function(t,e){let n=_r(t,"a","squaredDifference"),s=_r(e,"b","squaredDifference");[n,s]=vr(n,s),Zr(n.shape,s.shape);const r={a:n,b:s};return Ar.runKernel(Cn,r,{})}});const eu=Fr({squeeze_:function(t,e){const n=_r(t,"x","squeeze","string_or_numeric");return Yr(n,function(t,e){const n=[],s=[],r=null!=e&&Array.isArray(e)&&0===e.length,i=null==e||r?null:Xn(e,t).sort();let a=0;for(let e=0;e<t.length;++e){if(null!=i){if(i[a]===e&&1!==t[e])throw new Error(`Can't squeeze axis ${e} since its dim '${t[e]}' is not 1`);(null==i[a]||i[a]>e)&&1===t[e]&&(n.push(t[e]),s.push(e)),i[a]<=e&&a++}1!==t[e]&&(n.push(t[e]),s.push(e))}return{newShape:n,keptDims:s}}(n.shape,e).newShape)}});const nu=Fr({stack_:function(t,e=0){const n=Dr(t,"tensors","stack","string_or_numeric");Kn(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&Kn(e<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const s=n,r={axis:e};return Ar.runKernel(on,s,r)}});function su(t,e){qn(t);const n=zr(t,e);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return Ur(t,null,n,e)}function ru(t,e,n){if(qn(t),null!=e&&2!==e.length)throw new Error("tensor2d() requires shape to have two numbers");const s=zr(t,n);if(2!==s.length&&1!==s.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return Ur(t,e,s,n)}function iu(t,e,n){const s=1-t%2,r=new Float32Array(t);for(let i=0;i<t;++i){const a=2*Math.PI*i/(t+s-1);r[i]=e-n*Math.cos(a)}return su(r,"float32")}function au(t,e,n){if(null==n||"linear"===n)return t;if("relu"===n)return Mr(t,Lr(e));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function ou(t,e){let n=e;const s=Jr(t.shape,e.shape);return s.length>0&&(n=Xr(n,s)),Yr(n,t.shape)}function lu(t,e,n,s){if("linear"===e)return t;if("relu"===e)return Gl(t);if("elu"===e)return al(t);if("relu6"===e)return Hl(t);if("prelu"===e)return Tl(t,n);if("leakyrelu"===e)return fl(t,s);if("sigmoid"===e)return Jo(t);throw new Error(`Unknown fused activation ${e}.`)}Fr({stridedSlice_:function(t,e,n,s,r=0,i=0,a=0,o=0,l=0){const u={x:_r(t,"x","stridedSlice","string_or_numeric")},h={begin:e,end:n,strides:s,beginMask:r,endMask:i,ellipsisMask:a,newAxisMask:o,shrinkAxisMask:l};return Ar.runKernel("StridedSlice",u,h)}}),Fr({tan_:function(t){const e={x:_r(t,"x","tan","float32")};return Ar.runKernel("Tan",e)}}),Fr({topk_:function(t,e=1,n=!0){const s=_r(t,"x","topk");if(0===s.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const r=s.shape[s.shape.length-1];if(e<0)throw new Error(`'k' passed to topk() must be >= 0 but got ${e}`);if(e>r)throw new Error(`'k' passed to topk() must be <= the last dimension (${r}) but got ${e}`);const i={x:s},a={k:e,sorted:n},[o,l]=Ar.runKernel("TopK",i,a);return{values:o,indices:l}}}),Fr({truncatedNormal_:function(t,e=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error("Unsupported data type $ { dtype }");const i=new Wl(e,n,s,!0,r),a=tl(t,s);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}}),Fr({unique_:function(t,e=0){const n=_r(t,"x","unique","string_or_numeric");Kn(n.rank>0,(()=>"The input tensor must be at least 1D"));const s={x:n},r={axis:e},[i,a]=Ar.runKernel("Unique",s,r);return{values:i,indices:a}}}),Fr({movingAverage_:function(t,e,n,s,r=!0){const i=_r(t,"v","movingAverage"),a=_r(e,"x","movingAverage"),o=_r(n,"decay","movingAverage");var l,u;u=a,Kn((l=i).dtype===u.dtype,(()=>`The dtypes of the first(${l.dtype}) and second(${u.dtype}) input must match`)),Kn(Jn(i.shape,a.shape),(()=>"Shape mismatch in v and x"));const h=Vr(1),c=qr(h,o);let p=Mr(qr(a,i),c);if(r){Kn(null!=s,(()=>"When using zeroDebias: true, step is required."));const t=_r(s,"step","movingAverage");p=Pr(p,qr(h,ho(o,t)))}return ii(i,p)}}),Fr({scatterND_:function(t,e,n){const s=_r(t,"indices","scatterND","int32"),r=_r(e,"updates","scatterND");Vo(r,s,n);const i={indices:s,updates:r},a={shape:n};return Ar.runKernel("ScatterNd",i,a)}}),Fr({sparseToDense_:function(t,e,n,s=0){const r=_r(t,"sparseIndices","sparseToDense","int32"),i=_r(e,"sparseValues","sparseToDense","string_or_numeric"),a=_r(s,"defaultValue","sparseToDense",i.dtype);!function(t,e,n,s){if("int32"!==t.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${t.shape}.`);const r=t.rank>0?t.shape[0]:1,i=t.rank>1?t.shape[1]:1;if(n.length!==i)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${i}.`);const a=e.size;if(0!==e.rank&&(1!==e.rank||a!==r))throw new Error(`sparseValues has incorrect shape ${e.shape}, should be [] or [${r}]`);if(e.dtype!==s.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(r,i,n,a);const o={sparseIndices:r,sparseValues:i,defaultValue:a},l={outputShape:n};return Ar.runKernel("SparseToDense",o,l)}}),Fr({gatherND_:function(t,e){const n=_r(e,"indices","gatherND","int32"),s={params:_r(t,"x","gatherND","string_or_numeric"),indices:n};return Ar.runKernel("GatherNd",s)}}),Fr({dropout_:function(t,e,n,s){const r=_r(t,"x","dropout");if(Kn("float32"===r.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${r.dtype} tensor instead.`)),Kn(e>=0&&e<1,(()=>`rate must be a float in the range [0, 1), but got ${e}.`)),0===e)return t instanceof dr?r.clone():r;const i=function(t,e){if(null==e)return t.shape.slice();if(Jn(t.shape,e))return e;if(t.shape.length===e.length){const n=[];for(let s=0;s<t.shape.length;s++)null==e[s]&&null!=t.shape[s]?n.push(t.shape[s]):n.push(e[s]);return n}return e}(r,n),a=1-e,o=Pr(to(ii(jl(i,0,1,"float32",s),a)),a);return Mr(r,o)}});const uu=(t,e)=>!(t>0)||"linear"===e;Fr({fusedConv2d_:function({x:t,filter:e,strides:n,pad:s,dataFormat:r="NHWC",dilations:i=[1,1],dimRoundingMode:a,bias:o,activation:l="linear",preluActivationWeights:u,leakyreluAlpha:h}){if(l=l||"linear",!1===uu(Ar.state.gradientDepth,l)){Kn("NHWC"===r,(()=>`Error in fused conv2d: got dataFormat of ${r} but only NHWC is currently supported for the case of gradient depth is 0 and the activation is not linear.`));let c=Wi(t,e,n,s,r,i,a);return null!=o&&(c=ii(c,o)),lu(c,l,u,h)}const c=_r(t,"x","conv2d","float32"),p=_r(e,"filter","conv2d","float32");let d=c,f=!1;3===c.rank&&(f=!0,d=Yr(c,[1,c.shape[0],c.shape[1],c.shape[2]])),Kn(4===d.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${d.rank}.`)),Kn(4===p.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${p.rank}.`)),mi("fused conv2d",s,a);const g="NHWC"===r?d.shape[3]:d.shape[1];Kn(p.shape[2]===g,(()=>`Error in conv2d: depth of input (${g}) must match input depth for filter ${p.shape[2]}.`)),Kn(gi(n,i),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`));const m=hi(d.shape,p.shape,n,i,s,a);let b,y;if(null!=o&&(b=_r(o,"bias","fused conv2d"),[b]=vr(b,c),"NHWC"===r?Zr(m.outShape,b.shape):(Kn(b.shape.length<=1,(()=>`Error in fused conv2d: only supports scalar or 1-D Tensor bias for NCHW format but got the bias of rank-${b.shape.length}.`)),Kn(0===b.shape.length||b.shape[0]===m.outChannels||1===b.shape[0],(()=>`Error in fused conv2d: bias shape (${b.shape}) is not compatible with the number of output channels (${m.outChannels})`)))),null!=u){const t=u.shape;if(Kn(t.length<=1||3===t.length,(()=>`Error in fused conv2d: only supports scalar, 1-D Tensor or 3-D Tensor PReLU activation weights but got a tensor of rank-${t.length}.`)),1===t.length)Kn(1===t[0]||t[0]===m.outChannels,(()=>`Error in fused conv2d: PReLU activation weights (${t}) is not compatible with the number of output channels (${m.outChannels}).`));else if(3===t.length)try{Zr(t,m.outShape)}catch(e){const n=`Error in fused conv2d: PReLU activation weights (${t}) is not compatible with the output shape of the conv2d (${m.outShape}).`;throw Error(n)}y=_r(u,"prelu weights","fused conv2d")}const w=(t,e)=>{Kn("NHWC"===r,(()=>`Error in gradient of fused conv2D: got dataFormat of ${r} but only NHWC is currently supported.`));const[a,o,u,h]=e,c=au(t,u,l);Kn(fi(i),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${i}'`));const p=[Bi(o.shape,c,a,n,s),Oi(o,c,a.shape,n,s)];if(null!=h){const t=ou(h,c);p.push(t)}return p},k={x:d,filter:p,bias:b,preluActivationWeights:y},v={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a,activation:l,leakyreluAlpha:h};if(null==o){const t=ml(((t,e,n)=>{let s=Ar.runKernel(Wn,k,v);return n([e,t,s]),f&&(s=Yr(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}));return t(d,p)}{const t=ml(((t,e,n,s)=>{let r=Ar.runKernel(Wn,k,v);return s([e,t,r,n]),f&&(r=Yr(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}));return t(d,p,b)}}}),Fr({fusedDepthwiseConv2d_:function({x:t,filter:e,strides:n,pad:s,dataFormat:r="NHWC",dilations:i=[1,1],dimRoundingMode:a,bias:o,activation:l="linear",preluActivationWeights:u,leakyreluAlpha:h}){if(!1===uu(Ar.state.gradientDepth,l)){let c=il(t,e,n,s,r,i,a);return null!=o&&(c=ii(c,o)),lu(c,l,u,h)}const c=_r(t,"x","depthwiseConv2d","float32"),p=_r(e,"filter","depthwiseConv2d","float32");let d=c,f=!1;3===c.rank&&(f=!0,d=Yr(c,[1,c.shape[0],c.shape[1],c.shape[2]])),Kn(4===d.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${d.rank}.`)),Kn(4===p.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${p.rank}.`)),Kn(d.shape[3]===p.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${d.shape[3]}) must match the inChannels dimension in filter ${p.shape[2]}.`)),null==i&&(i=[1,1]),Kn(gi(n,i),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`)),mi("fused depthwiseConv2d",s,a);const g=hi(d.shape,p.shape,n,i,s,a,!0);let m,b;null!=o&&(m=_r(o,"bias","fused conv2d"),[m]=vr(m,c),Zr(g.outShape,m.shape)),null!=u&&(b=_r(u,"prelu weights","fused depthwiseConv2d"));const y=(t,e)=>{Kn(fi(i),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${i}'`));const[r,o,u,h]=e,c=au(t,u,l),p=la(o.shape,c,r,n,s,i,a),d=oa(o,c,r.shape,n,s,i,a);if(null!=h){return[p,d,ou(m,c)]}return[p,d]},w={x:d,filter:p,bias:m,preluActivationWeights:b},k={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a,activation:l,leakyreluAlpha:h};if(null==o){const t=ml(((t,e,n)=>{let s=Ar.runKernel(Un,w,k);return n([e,t,s]),f&&(s=Yr(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:y}}));return t(d,p)}{const t=ml(((t,e,n,s)=>{let r=Ar.runKernel(Un,w,k);return s([e,t,r,n]),f&&(r=Yr(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:y}}));return t(d,p,m)}}}),Fr({fusedMatMul_:function({a:t,b:e,transposeA:n=!1,transposeB:s=!1,bias:r,activation:i="linear",preluActivationWeights:a,leakyreluAlpha:o=.2}){if(!1===uu(Ar.state.gradientDepth,i)){let l=vi(t,e,n,s);return null!=r&&(l=ii(l,r)),lu(l,i,a,o)}let l=_r(t,"a","fused matMul"),u=_r(e,"b","fused matMul");[l,u]=vr(l,u);const h=n?l.shape[l.rank-2]:l.shape[l.rank-1],c=s?u.shape[u.rank-1]:u.shape[u.rank-2],p=n?l.shape[l.rank-1]:l.shape[l.rank-2],d=s?u.shape[u.rank-2]:u.shape[u.rank-1],f=l.shape.slice(0,-2),g=u.shape.slice(0,-2),m=Hn(f),b=Hn(g);Kn(h===c,(()=>`Error in fused matMul: inner shapes (${h}) and (${c}) of Tensors with shapes ${l.shape} and ${u.shape} and transposeA=${n} and transposeB=${s} must match.`));const y=Zr(l.shape.slice(0,-2),u.shape.slice(0,-2)).concat([p,d]),w=Yr(l,n?[m,h,p]:[m,p,h]),k=Yr(u,s?[b,d,c]:[b,c,d]);let v,x;null!=r&&(v=_r(r,"bias","fused matMul"),[v]=vr(v,l),Zr(y,v.shape)),null!=a&&(x=_r(a,"prelu weights","fused matMul"));const S=(t,e)=>{const[a,o,l,u]=e,h=au(Yr(t,l.shape),l,i);let c,p;if(n||s?!n&&s?(c=vi(h,o,!1,!1),p=vi(h,a,!0,!1)):n&&!s?(c=vi(o,h,!1,!0),p=vi(a,h,!1,!1)):(c=vi(o,h,!0,!0),p=vi(h,a,!0,!0)):(c=vi(h,o,!1,!0),p=vi(a,h,!0,!1)),null!=r){return[c,p,ou(u,h)]}return[c,p]},N={a:w,b:k,bias:v,preluActivationWeights:x},E={transposeA:n,transposeB:s,activation:i,leakyreluAlpha:o};if(null==r){const t=ml(((t,e,n)=>{const s=Ar.runKernel(Pn,N,E);return n([t,e,s]),{value:Yr(s,y),gradFunc:S}}));return t(w,k)}{const t=ml(((t,e,n,s)=>{const r=Ar.runKernel(Pn,N,E);return s([t,e,r,n]),{value:Yr(r,y),gradFunc:S}}));return t(w,k,v)}}}),Fr({hammingWindow_:function(t){return iu(t,.54,.46)}});const hu=Fr({hannWindow_:function(t){return iu(t,.5,.5)}});const cu=Fr({frame_:function(t,e,n,s=!1,r=0){let i=0;const a=[];for(;i+e<=t.size;)a.push(Xa(t,i,e)),i+=n;if(s)for(;i<t.size;){const s=i+e-t.size,o=Ho([Xa(t,i,e-s),el([s],r)]);a.push(o),i+=n}return 0===a.length?ru([],[0,e]):Yr(Ho(a),[a.length,e])}});function pu(t,e,n,s,r,i){null==s&&(s=.5),null==r&&(r=Number.NEGATIVE_INFINITY),null==i&&(i=0);const a=t.shape[0];return n=Math.min(n,a),Kn(0<=s&&s<=1,(()=>`iouThreshold must be in [0, 1], but was '${s}'`)),Kn(2===t.rank,(()=>`boxes must be a 2D tensor, but was of rank '${t.rank}'`)),Kn(4===t.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${t.shape[1]}`)),Kn(1===e.rank,(()=>"scores must be a 1D tensor")),Kn(e.shape[0]===a,(()=>`scores has incompatible shape with boxes. Expected ${a}, but was ${e.shape[0]}`)),Kn(0<=i&&i<=1,(()=>`softNmsSigma must be in [0, 1], but was '${i}'`)),{maxOutputSize:n,iouThreshold:s,scoreThreshold:r,softNmsSigma:i}}function du(t,e=!1){return Ar.tidy((()=>{Kn(2===t.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${t.shape.length}D Tensor.`));const n=t.shape[0],s=t.shape[1];let r=pl(n),i=Ci(t);const a=ru([[1]],[1,1]);let o=Ci(a);const l=n>=s?s:n;for(let t=0;t<l;++t){const e=i,l=o,u=r;[o,i,r]=Ar.tidy((()=>{const e=Xa(i,[t,t],[n-t,1]),l=hl(e),u=Xa(i,[t,t],[1,1]),h=Di(Ca(u,0),ru([[-1]]),ru([[1]])),c=qr(u,Mr(h,l)),p=Pr(e,c);o=1===p.shape[0]?Ci(a):Ho([a,Xa(p,[1,0],[p.shape[0]-1,p.shape[1]])],0);const d=Wr(Pr(vi(h,c),l)),f=Xa(i,[t,0],[n-t,s]),g=Mr(d,o),m=ia(o);if(0===t)i=qr(f,vi(g,vi(m,f)));else{const e=qr(f,vi(g,vi(m,f)));i=Ho([Xa(i,[0,0],[t,s]),e],0)}const b=ia(g),y=Xa(r,[0,t],[n,r.shape[1]-t]);if(0===t)r=qr(y,vi(vi(y,o),b));else{const e=qr(y,vi(vi(y,o),b));r=Ho([Xa(r,[0,0],[n,t]),e],1)}return[o,i,r]})),ea([e,l,u])}return!e&&n>s&&(r=Xa(r,[0,0],[n,s]),i=Xa(i,[0,0],[s,s])),[r,i]}))}var fu;Fr({stft_:function(t,e,n,s,r=hu){var i;null==s&&(i=e,s=Math.floor(Math.pow(2,Math.ceil(Math.log(i)/Math.log(2)))));const a=cu(t,e,n),o=Mr(a,r(e));return Ql(o,s)}}),Fr({cropAndResize_:function(t,e,n,s,r="bilinear",i=0){const a=_r(t,"image","cropAndResize"),o=_r(e,"boxes","cropAndResize","float32"),l=_r(n,"boxInd","cropAndResize","int32"),u=o.shape[0];Kn(4===a.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${a.rank}.`)),Kn(2===o.rank&&4===o.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${u},4] but had shape ${o.shape}.`)),Kn(1===l.rank&&l.shape[0]===u,(()=>`Error in cropAndResize: boxInd must be have size [${u}] but had shape ${o.shape}.`)),Kn(2===s.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${s.length}.`)),Kn(s[0]>=1&&s[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${s}`)),Kn("bilinear"===r||"nearest"===r,(()=>`method must be bilinear or nearest, but was ${r}`));const h={image:a,boxes:o,boxInd:l},c={method:r,extrapolationValue:i,cropSize:s};return Ar.runKernel("CropAndResize",h,c)}}),Fr({flipLeftRight_:function(t){const e=_r(t,"image","flipLeftRight","float32");Kn(4===e.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${e.rank}.`));const n={image:e};return Ar.runKernel("FlipLeftRight",n,{})}}),Fr({grayscaleToRGB_:function(t){const e=_r(t,"image","grayscaleToRGB"),n=e.rank-1,s=e.shape[n];Kn(e.rank>=2,(()=>`Error in grayscaleToRGB: images must be at least rank 2, but got rank ${e.rank}.`)),Kn(1===s,(()=>`Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${s}.`));const r=new Array(e.rank);return r.fill(1,0,n),r[n]=3,ka(e,r)}}),Fr({rotateWithOffset_:function(t,e,n=0,s=.5){const r=_r(t,"image","rotateWithOffset","float32");Kn(4===r.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${r.rank}.`));const i={image:r},a={radians:e,fillValue:n,center:s};return Ar.runKernel("RotateWithOffset",i,a)}}),Fr({nonMaxSuppression_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY){const i=_r(t,"boxes","nonMaxSuppression","float32"),a=_r(e,"scores","nonMaxSuppression","float32"),o=pu(i,a,n,s,r),l={maxOutputSize:n=o.maxOutputSize,iouThreshold:s=o.iouThreshold,scoreThreshold:r=o.scoreThreshold};return Ar.runKernel("NonMaxSuppressionV3",{boxes:i,scores:a},l)}}),Fr({nonMaxSuppressionWithScore_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY,i=0){const a=_r(t,"boxes","nonMaxSuppression"),o=_r(e,"scores","nonMaxSuppression"),l=pu(a,o,n,s,r,i),u={boxes:a,scores:o},h={maxOutputSize:n=l.maxOutputSize,iouThreshold:s=l.iouThreshold,scoreThreshold:r=l.scoreThreshold,softNmsSigma:i=l.softNmsSigma},c=Ar.runKernel("NonMaxSuppressionV5",u,h);return{selectedIndices:c[0],selectedScores:c[1]}}}),Fr({nonMaxSuppressionPadded_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY,i=!1){const a=_r(t,"boxes","nonMaxSuppression"),o=_r(e,"scores","nonMaxSuppression"),l=pu(a,o,n,s,r,null),u={boxes:a,scores:o},h={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:i},c=Ar.runKernel("NonMaxSuppressionV4",u,h);return{selectedIndices:c[0],validOutputs:c[1]}}}),Fr({resizeBilinear_:function(t,e,n=!1,s=!1){const r=_r(t,"images","resizeBilinear");Kn(3===r.rank||4===r.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${r.rank}.`)),Kn(2===e.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${e}.`)),Kn(!1===s||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let i=r,a=!1;3===r.rank&&(a=!0,i=Yr(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const o={images:i},l={alignCorners:n,halfPixelCenters:s,size:e},u=Ar.runKernel(gn,o,l);return a?Yr(u,[u.shape[1],u.shape[2],u.shape[3]]):u}}),Fr({resizeNearestNeighbor_:function(t,e,n=!1,s=!1){const r=_r(t,"images","resizeNearestNeighbor");Kn(3===r.rank||4===r.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${r.rank}.`)),Kn(2===e.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${e}.`)),Kn("float32"===r.dtype||"int32"===r.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),Kn(!1===s||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let i=r,a=!1;3===r.rank&&(a=!0,i=Yr(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const o={images:i},l={alignCorners:n,halfPixelCenters:s,size:e},u=Ar.runKernel(fn,o,l);return a?Yr(u,[u.shape[1],u.shape[2],u.shape[3]]):u}}),Fr({threshold_:function(t,e="binary",n=!1,s=.5){const r=_r(t,"image","threshold"),i=r.shape[0]*r.shape[1];let a,o,l,u,h=Mr(su([s]),255);if(Kn(3===r.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${r.rank}.`)),Kn(3===r.shape[2]||1===r.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${r.shape[2]}.`)),Kn("int32"===r.dtype||"float32"===r.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${r.dtype}.`)),Kn("otsu"===e||"binary"===e,(()=>`Method must be binary or otsu, but was ${e}`)),3===r.shape[2]){[a,o,l]=Mi(r,[1,1,1],-1);const t=Mr(a,.2989),e=Mr(o,.587),n=Mr(l,.114);u=ii(ii(t,e),n)}else u=t;if("otsu"===e){h=function(t,e){let n,s,r,i,a,o,l=su([-1]),u=su([0]),h=su([0]);for(let c=0;c<t.size-1;c++){n=Xa(t,0,c+1),s=Xa(t,c+1),a=Pr(Xr(n),e),o=Pr(Xr(s),e);const p=Xr(Mr(n,ql(0,n.size)));r=Pr(p,Xr(n));const d=el(s.shape,n.size),f=ii(ql(0,s.size),d),g=Mr(s,f);i=Pr(Xr(g),Xr(s));const m=qr(r,i),b=qr(r,i),y=Mr(a,o);h=Mr(Mr(y,m),b);const w=Ca(h,u);u=Di(w,h,u),l=Di(w,su([c]),l)}return l}(Qo(Rr(Zl(u),"int32"),Ur(c=[],p,zr(c,d),d),256),i)}var c,p,d;const f=n?zi(u,h):Ca(u,h);return Rr(Mr(f,255),"int32")}}),Fr({transform_:function(t,e,n="nearest",s="constant",r=0,i){const a=_r(t,"image","transform","float32"),o=_r(e,"transforms","transform","float32");Kn(4===a.rank,(()=>`Error in transform: image must be rank 4,but got rank ${a.rank}.`)),Kn(2===o.rank&&(o.shape[0]===a.shape[0]||1===o.shape[0])&&8===o.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),Kn(null==i||2===i.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${i}.`));const l={image:a,transforms:o},u={interpolation:n,fillMode:s,fillValue:r,outputShape:i};return Ar.runKernel("Transform",l,u)}}),Fr({bandPart_:function(t,e,n){Kn(e%1==0,(()=>`bandPart(): numLower must be an integer, got ${e}.`)),Kn(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`));const s=_r(t,"a","bandPart");Kn(s.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${s.rank}.`));const r=s.shape,[i,a]=s.shape.slice(-2);if(!(e<=i))throw new Error(`bandPart(): numLower (${e}) must not be greater than the number of rows (${i}).`);if(!(n<=a))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${a}).`);e<0&&(e=i),n<0&&(n=a);const o=Yr(ql(0,i,1,"int32"),[-1,1]),l=ql(0,a,1,"int32"),u=qr(o,l),h=$i(zi(u,Vr(+e,"int32")),Ti(u,Vr(-n,"int32"))),c=Ga([i,a],s.dtype);return Yr(nu(ao(Yr(s,[-1,i,a])).map((t=>Di(h,t,c)))),r)}}),Fr({gramSchmidt_:function(t){let e;if(Array.isArray(t)){e=!1,Kn(null!=t&&t.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=t[0].shape[0];for(let e=1;e<t.length;++e)Kn(t[e].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${t[e].shape[0]} vs. ${n})`))}else e=!0,t=Mi(t,t.shape[0],0).map((t=>eu(t,[0])));Kn(t.length<=t[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${t.length}) exceeds number of dimensions (${t[0].shape[0]}).`));const n=[],s=t;for(let e=0;e<t.length;++e)n.push(Ar.tidy((()=>{let t=s[e];if(e>0)for(let s=0;s<e;++s){const e=Mr(Xr(Mr(n[s],t)),n[s]);t=qr(t,e)}return Pr(t,hl(t,"euclidean"))})));return e?nu(n,0):n}}),Fr({qr_:function(t,e=!1){if(Kn(t.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${t.rank}`)),2===t.rank)return du(t,e);{const n=t.shape.slice(0,t.shape.length-2).reduce(((t,e)=>t*e)),s=ao(Yr(t,[n,t.shape[t.shape.length-2],t.shape[t.shape.length-1]]),0),r=[],i=[];s.forEach((t=>{const[n,s]=du(t,e);r.push(n),i.push(s)}));return[Yr(nu(r,0),t.shape),Yr(nu(i,0),t.shape)]}}}),function(t){t[t.NONE=0]="NONE",t[t.MEAN=1]="MEAN",t[t.SUM=2]="SUM",t[t.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS"}(fu||(fu={}));const gu=Fr({computeWeightedLoss_:function(t,e,n=fu.SUM_BY_NONZERO_WEIGHTS){const s=_r(t,"losses","computeWeightedLoss");let r=null;null!=e&&(r=_r(e,"weights","computeWeightedLoss"));const i=null==r?s:Mr(s,r);if(n===fu.NONE)return i;if(n===fu.SUM)return Xr(i);if(n===fu.MEAN){if(null==r)return Nl(i);{const t=s.size/r.size,e=Pr(Xr(i),Xr(r));return t>1?Pr(e,Vr(t)):e}}if(n===fu.SUM_BY_NONZERO_WEIGHTS){if(null==r)return Pr(Xr(i),Vr(s.size));{const t=Mr(r,Ha(s.shape)),e=Rr(Xr(Il(t,Vr(0))),"float32");return Pr(Xr(i),e)}}throw Error(`Unknown reduction: ${n}`)}});Fr({absoluteDifference_:function(t,e,n,s=fu.SUM_BY_NONZERO_WEIGHTS){const r=_r(t,"labels","absoluteDifference"),i=_r(e,"predictions","absoluteDifference");let a=null;null!=n&&(a=_r(n,"weights","absoluteDifference")),jn(r.shape,i.shape,"Error in absoluteDifference: ");const o=qo(qr(r,i));return gu(o,a,s)}}),Fr({cosineDistance_:function(t,e,n,s,r=fu.SUM_BY_NONZERO_WEIGHTS){const i=_r(t,"labels","cosineDistance"),a=_r(e,"predictions","cosineDistance");let o=null;null!=s&&(o=_r(s,"weights","cosineDistance")),jn(i.shape,a.shape,"Error in cosineDistance: ");const l=Vr(1),u=qr(l,Xr(Mr(i,a),n,!0));return gu(u,o,r)}}),Fr({hingeLoss_:function(t,e,n,s=fu.SUM_BY_NONZERO_WEIGHTS){let r=_r(t,"labels","hingeLoss");const i=_r(e,"predictions","hingeLoss");let a=null;null!=n&&(a=_r(n,"weights","hingeLoss")),jn(r.shape,i.shape,"Error in hingeLoss: ");const o=Vr(1);r=qr(Mr(Vr(2),r),o);const l=Gl(qr(o,Mr(r,i)));return gu(l,a,s)}}),Fr({huberLoss_:function(t,e,n,s=1,r=fu.SUM_BY_NONZERO_WEIGHTS){const i=_r(t,"labels","huberLoss"),a=_r(e,"predictions","huberLoss");let o=null;null!=n&&(o=_r(n,"weights","huberLoss")),jn(i.shape,a.shape,"Error in huberLoss: ");const l=Vr(s),u=qo(qr(a,i)),h=El(u,l),c=qr(u,h),p=ii(Mr(Vr(.5),jr(h)),Mr(l,c));return gu(p,o,r)}}),Fr({logLoss_:function(t,e,n,s=1e-7,r=fu.SUM_BY_NONZERO_WEIGHTS){const i=_r(t,"labels","logLoss"),a=_r(e,"predictions","logLoss");let o=null;null!=n&&(o=_r(n,"weights","logLoss")),jn(i.shape,a.shape,"Error in logLoss: ");const l=Vr(1),u=Vr(s),h=Wr(Mr(i,uo(ii(a,u)))),c=Mr(qr(l,i),uo(ii(qr(l,a),u))),p=qr(h,c);return gu(p,o,r)}}),Fr({meanSquaredError_:function(t,e,n,s=fu.SUM_BY_NONZERO_WEIGHTS){const r=_r(t,"labels","meanSquaredError"),i=_r(e,"predictions","meanSquaredError");let a=null;null!=n&&(a=_r(n,"weights","meanSquaredError")),jn(r.shape,i.shape,"Error in meanSquaredError: ");const o=tu(r,i);return gu(o,a,s)}}),Fr({sigmoidCrossEntropy_:function(t,e,n,s=0,r=fu.SUM_BY_NONZERO_WEIGHTS){let i=_r(t,"multiClassLabels","sigmoidCrossEntropy");const a=_r(e,"logits","sigmoidCrossEntropy");let o=null;if(null!=n&&(o=_r(n,"weights","sigmoidCrossEntropy")),jn(i.shape,a.shape,"Error in sigmoidCrossEntropy: "),s>0){const t=Vr(s),e=Vr(1),n=Vr(.5);i=ii(Mr(i,qr(e,t)),Mr(n,t))}const l=function(t,e){const n=_r(t,"labels","sigmoidCrossEntropyWithLogits"),s=_r(e,"logits","sigmoidCrossEntropyWithLogits");jn(n.shape,s.shape,"Error in sigmoidCrossEntropyWithLogits: ");const r=Gl(s),i=Mr(s,n),a=gl(pa(Wr(qo(s))));return ii(qr(r,i),a)}(i,a);return gu(l,o,r)}}),Fr({softmaxCrossEntropy_:function(t,e,n,s=0,r=fu.SUM_BY_NONZERO_WEIGHTS){let i=_r(t,"onehotLabels","softmaxCrossEntropy");const a=_r(e,"logits","softmaxCrossEntropy");let o=null;if(null!=n&&(o=_r(n,"weights","softmaxCrossEntropy")),jn(i.shape,a.shape,"Error in softmaxCrossEntropy: "),s>0){const t=Vr(s),e=Vr(1),n=Vr(i.shape[1]);i=ii(Mr(i,qr(e,t)),Pr(t,n))}const l=function(t,e,n=-1){if(-1===n&&(n=e.rank-1),n!==e.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${e.rank} and dim was ${n}`);const s=ml(((t,e,s)=>{const r=yl(e,[n],!0),i=qr(Rr(e,"float32"),r);s([t,i]);const a=Wr(Mr(i,t));return{value:Xr(a,[n]),gradFunc:(t,e)=>{const[s,r]=e,i=Zi(t.shape,[n]);return[Mr(Yr(t,i),qr(Rr(s,"float32"),pa(r))),Mr(Yr(t,i),qr(pa(r),Rr(s,"float32")))]}}}));return s(t,e)}(i,a);return gu(l,o,r)}}),Fr({sparseFillEmptyRows_:function(t,e,n,s){const r=_r(t,"indices","sparseFillEmptyRows","int32"),i=_r(e,"values","sparseFillEmptyRows"),a=_r(n,"denseShape","sparseFillEmptyRows","int32"),o=_r(s,"defaultValue","sparseFillEmptyRows",i.dtype);if(2!==r.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==i.rank)throw new Error(`Values should be Tensor1D but received shape ${i.shape}`);if(1!==a.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${a.shape}`);if(0!==o.rank)throw new Error(`Default value should be a scalar but received shape ${o.shape}`);const l={indices:r,values:i,denseShape:a,defaultValue:o},u=Ar.runKernel("SparseFillEmptyRows",l);return{outputIndices:u[0],outputValues:u[1],emptyRowIndicator:u[2],reverseIndexMap:u[3]}}}),Fr({sparseReshape_:function(t,e,n){const s=_r(t,"inputIndices","sparseReshape","int32"),r=_r(e,"inputShape","sparseReshape","int32"),i=_r(n,"newShape","sparseReshape","int32");if(2!==s.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==r.rank)throw new Error(`Input shape should be Tensor1D but received shape ${r.shape}`);if(1!==i.rank)throw new Error(`New shape should be Tensor1D but received shape ${i.shape}`);const a={inputIndices:s,inputShape:r,newShape:i},o=Ar.runKernel("SparseReshape",a);return{outputIndices:o[0],outputShape:o[1]}}}),Fr({sparseSegmentMean_:function(t,e,n){const s=_r(t,"data","sparseSegmentMean"),r=_r(e,"indices","sparseSegmentMean","int32"),i=_r(n,"segmentIds","sparseSegmentMean","int32");if(s.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.rank)throw new Error(`Indices should be Tensor1D but received shape\n          ${r.shape}`);if(1!==i.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n          ${i.shape}`);const a={data:s,indices:r,segmentIds:i};return Ar.runKernel("SparseSegmentMean",a)}}),Fr({sparseSegmentSum_:function(t,e,n){const s=_r(t,"data","sparseSegmentSum"),r=_r(e,"indices","sparseSegmentSum","int32"),i=_r(n,"segmentIds","sparseSegmentSum","int32");if(s.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.rank)throw new Error(`Indices should be Tensor1D but received shape\n         ${r.shape}`);if(1!==i.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n         ${i.shape}`);const a={data:s,indices:r,segmentIds:i};return Ar.runKernel("SparseSegmentSum",a)}}),Fr({stringNGrams_:function(t,e,n,s,r,i,a,o){const l=_r(t,"data","stringNGrams","string");if("string"!==l.dtype)throw new Error("Data must be of datatype string");if(1!==l.shape.length)throw new Error(`Data must be a vector, saw: ${l.shape}`);const u=_r(e,"dataSplits","stringNGrams");if("int32"!==u.dtype)throw new Error("Data splits must be of datatype int32");const h={separator:n,nGramWidths:s,leftPad:r,rightPad:i,padWidth:a,preserveShortSequences:o},c={data:l,dataSplits:u},p=Ar.runKernel("StringNGrams",c,h);return{nGrams:p[0],nGramsSplits:p[1]}}}),Fr({stringSplit_:function(t,e,n=!0){const s=_r(t,"input","stringSplit","string"),r=_r(e,"delimiter","stringSplit","string");if(1!==s.rank)throw new Error(`Input should be Tensor1D but received shape ${s.shape}`);if(0!==r.rank)throw new Error(`Delimiter should be a scalar but received shape ${r.shape}`);const i={skipEmpty:n},a={input:s,delimiter:r},o=Ar.runKernel("StringSplit",a,i);return{indices:o[0],values:o[1],shape:o[2]}}}),Fr({stringToHashBucketFast_:function(t,e){const n=_r(t,"input","stringToHashBucketFast","string"),s={numBuckets:e};if(e<=0)throw new Error("Number of buckets must be at least 1");const r={input:n};return Ar.runKernel("StringToHashBucketFast",r,s)}});class mu extends class{getClassName(){return this.constructor.className}static fromConfig(t,e){return new t(e)}}{minimize(t,e=!1,n){const{value:s,grads:r}=this.computeGradients(t,n);if(null!=n){const t=n.map((t=>({name:t.name,tensor:r[t.name]})));this.applyGradients(t)}else this.applyGradients(r);return ea(r),e?s:(s.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(t,e){return function(t,e){Kn(ss(t),(()=>"The f passed in variableGrads(f) must be a function")),Kn(null==e||Array.isArray(e)&&e.every((t=>t instanceof fr)),(()=>"The varList passed in variableGrads(f, varList) must be an array of variables"));const n=null!=e;if(!n){e=[];for(const t in Ar.registeredVariables)e.push(Ar.registeredVariables[t])}const s=n?e.filter((t=>!t.trainable)):null,r=e.length;Kn((e=e.filter((t=>t.trainable))).length>0,(()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${r} variables is trainable.`));const{value:i,grads:a}=Ar.gradients(t,e,null,!0);Kn(a.some((t=>null!=t)),(()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize().")),Kn(0===i.rank,(()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${i.rank} tensor`));const o={};return e.forEach(((t,e)=>{null!=a[e]&&(o[t.name]=a[e])})),null!=s&&s.forEach((t=>o[t.name]=null)),{value:i,grads:o}}(t,e)}dispose(){null!=this.iterations_&&ea(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:Vr(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(t){throw new Error(`setWeights() is not implemented for this optimizer class ${this.getClassName()}`)}async extractIterations(t){return this.iterations_=(await t[0].tensor.data())[0],t.slice(1)}}Object.defineProperty(mu,Symbol.hasInstance,{value:t=>null!=t.minimize&&null!=t.computeGradients&&null!=t.applyGradients});class bu extends mu{constructor(t,e,n=null){super(),this.learningRate=t,this.rho=e,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=Ar.backend.epsilon())}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ar.registeredVariables[e];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:`${e}/accum_grad`,variable:ta((()=>ei(s).variable(false)))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:`${e}/accum_var`,variable:ta((()=>ei(s).variable(false)))});const r=Array.isArray(t)?t[n].tensor:t[e];if(null==r)return;const i=this.accumulatedGrads[n].variable,a=this.accumulatedUpdates[n].variable;ta((()=>{const t=ii(Mr(i,this.rho),Mr(jr(r),1-this.rho)),e=Mr(Pr(Kr(ii(a,this.epsilon)),Kr(ii(i,this.epsilon))),r),n=ii(Mr(a,this.rho),Mr(jr(e),1-this.rho));i.assign(t),a.assign(n);const o=ii(Mr(e,-this.learningRate),s);s.assign(o)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(ea(this.accumulatedGrads.map((t=>t.variable))),ea(this.accumulatedUpdates.map((t=>t.variable))))}async getWeights(){const t=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(t.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){const e=(t=await this.extractIterations(t)).length/2;this.accumulatedGrads=t.slice(0,e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)}))),this.accumulatedUpdates=t.slice(e,2*e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(t,e){return new t(e.learningRate,e.rho,e.epsilon)}}bu.className="Adadelta",jo(bu);class yu extends mu{constructor(t,e=.1){super(),this.learningRate=t,this.initialAccumulatorValue=e,this.accumulatedGrads=[]}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ar.registeredVariables[e];if(null==this.accumulatedGrads[n]){const t=!1;this.accumulatedGrads[n]={originalName:`${e}/accumulator`,variable:ta((()=>el(s.shape,this.initialAccumulatorValue).variable(t)))}}const r=Array.isArray(t)?t[n].tensor:t[e];if(null==r)return;const i=this.accumulatedGrads[n].variable;ta((()=>{const t=ii(i,jr(r));i.assign(t);const e=ii(Mr(Pr(r,Kr(ii(t,Ar.backend.epsilon()))),-this.learningRate),s);s.assign(e)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&ea(this.accumulatedGrads.map((t=>t.variable)))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t);this.accumulatedGrads=t.map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(t,e){return new t(e.learningRate,e.initialAccumulatorValue)}}yu.className="Adagrad",jo(yu);class wu extends mu{constructor(t,e,n,s=null){super(),this.learningRate=t,this.beta1=e,this.beta2=n,this.epsilon=s,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],ta((()=>{this.accBeta1=Vr(e).variable(),this.accBeta2=Vr(n).variable()})),null==s&&(this.epsilon=Ar.backend.epsilon())}applyGradients(t){const e=Array.isArray(t)?t.map((t=>t.name)):Object.keys(t);ta((()=>{const n=qr(1,this.accBeta1),s=qr(1,this.accBeta2);e.forEach(((e,r)=>{const i=Ar.registeredVariables[e];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${e}/m`,variable:ta((()=>ei(i).variable(false)))}),null==this.accumulatedSecondMoment[r]&&(this.accumulatedSecondMoment[r]={originalName:`${e}/v`,variable:ta((()=>ei(i).variable(false)))});const a=Array.isArray(t)?t[r].tensor:t[e];if(null==a)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedSecondMoment[r].variable,u=ii(Mr(o,this.beta1),Mr(a,1-this.beta1)),h=ii(Mr(l,this.beta2),Mr(jr(a),1-this.beta2)),c=Pr(u,n),p=Pr(h,s);o.assign(u),l.assign(h);const d=ii(Mr(Pr(c,ii(Kr(p),this.epsilon)),-this.learningRate),i);i.assign(d)})),this.accBeta1.assign(Mr(this.accBeta1,this.beta1)),this.accBeta2.assign(Mr(this.accBeta2,this.beta2))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&ea(this.accumulatedFirstMoment.map((t=>t.variable))),null!=this.accumulatedSecondMoment&&ea(this.accumulatedSecondMoment.map((t=>t.variable)))}async getWeights(){const t=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(t.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t),ta((()=>{this.accBeta1.assign(ho(this.beta1,this.iterations_+1)),this.accBeta2.assign(ho(this.beta2,this.iterations_+1))}));const e=t.length/2;this.accumulatedFirstMoment=t.slice(0,e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)}))),this.accumulatedSecondMoment=t.slice(e,2*e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(t,e){return new t(e.learningRate,e.beta1,e.beta2,e.epsilon)}}wu.className="Adam",jo(wu);class ku extends mu{constructor(t,e,n,s=null,r=0){super(),this.learningRate=t,this.beta1=e,this.beta2=n,this.epsilon=s,this.decay=r,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],ta((()=>{this.iteration=Vr(0).variable(),this.accBeta1=Vr(e).variable()})),null==s&&(this.epsilon=Ar.backend.epsilon())}applyGradients(t){const e=Array.isArray(t)?t.map((t=>t.name)):Object.keys(t);ta((()=>{const n=qr(1,this.accBeta1),s=Pr(-this.learningRate,ii(Mr(this.iteration,this.decay),1));e.forEach(((e,r)=>{const i=Ar.registeredVariables[e];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${e}/m`,variable:ei(i).variable(false)}),null==this.accumulatedWeightedInfNorm[r]&&(this.accumulatedWeightedInfNorm[r]={originalName:`${e}/v`,variable:ei(i).variable(false)});const a=Array.isArray(t)?t[r].tensor:t[e];if(null==a)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedWeightedInfNorm[r].variable,u=ii(Mr(o,this.beta1),Mr(a,1-this.beta1)),h=Mr(l,this.beta2),c=qo(a),p=Sl(h,c);o.assign(u),l.assign(p);const d=ii(Mr(Pr(s,n),Pr(u,ii(p,this.epsilon))),i);i.assign(d)})),this.iteration.assign(ii(this.iteration,1)),this.accBeta1.assign(Mr(this.accBeta1,this.beta1))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&ea(this.accumulatedFirstMoment.map((t=>t.variable))),null!=this.accumulatedWeightedInfNorm&&ea(this.accumulatedWeightedInfNorm.map((t=>t.variable)))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(t){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(t,e){return new t(e.learningRate,e.beta1,e.beta2,e.epsilon,e.decay)}}ku.className="Adamax",jo(ku);class vu extends mu{constructor(t){super(),this.learningRate=t,this.setLearningRate(t)}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Array.isArray(t)?t[n].tensor:t[e];if(null==s)return;const r=Ar.registeredVariables[e];ta((()=>{const t=ii(Mr(this.c,s),r);r.assign(t)}))})),this.incrementIterations()}setLearningRate(t){var e;this.learningRate=t,null!=this.c&&this.c.dispose(),this.c=(e=Vr(-t),Ar.keep(e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(t){if(0!==(t=await this.extractIterations(t)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(t,e){return new t(e.learningRate)}}vu.className="SGD",jo(vu);class xu extends vu{constructor(t,e,n=!1){super(t),this.learningRate=t,this.momentum=e,this.useNesterov=n,this.accumulations=[],this.m=Vr(this.momentum)}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ar.registeredVariables[e];if(null==this.accumulations[n]){const t=!1;this.accumulations[n]={originalName:`${e}/momentum`,variable:ta((()=>ei(s).variable(t)))}}const r=this.accumulations[n].variable,i=Array.isArray(t)?t[n].tensor:t[e];null!=i&&ta((()=>{let t;const e=ii(Mr(this.m,r),i);t=this.useNesterov?ii(Mr(this.c,ii(i,Mr(e,this.m))),s):ii(Mr(this.c,e),s),r.assign(e),s.assign(t)}))})),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&ea(this.accumulations.map((t=>t.variable)))}setMomentum(t){this.momentum=t}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t);this.accumulations=t.map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(t,e){return new t(e.learningRate,e.momentum,e.useNesterov)}}xu.className="Momentum",jo(xu);class Su extends mu{constructor(t,e=.9,n=0,s=null,r=!1){if(super(),this.learningRate=t,this.decay=e,this.momentum=n,this.epsilon=s,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=r,null==s&&(this.epsilon=Ar.backend.epsilon()),null==t)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ar.registeredVariables[e],r=!1;null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:`${e}/rms`,variable:ta((()=>ei(s).variable(r)))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:`${e}/momentum`,variable:ta((()=>ei(s).variable(r)))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:`${e}/mg`,variable:ta((()=>ei(s).variable(r)))});const i=Array.isArray(t)?t[n].tensor:t[e];if(null==i)return;const a=this.accumulatedMeanSquares[n].variable,o=this.accumulatedMoments[n].variable;ta((()=>{const t=ii(Mr(a,this.decay),Mr(jr(i),1-this.decay));if(this.centered){const e=this.accumulatedMeanGrads[n].variable,r=ii(Mr(e,this.decay),Mr(i,1-this.decay)),l=Pr(Mr(i,this.learningRate),Kr(qr(t,ii(jr(r),this.epsilon)))),u=ii(Mr(o,this.momentum),l);a.assign(t),e.assign(r),o.assign(u);const h=qr(s,u);s.assign(h)}else{const t=ii(Mr(a,this.decay),Mr(jr(i),1-this.decay)),e=ii(Mr(o,this.momentum),Pr(Mr(i,this.learningRate),Kr(ii(t,this.epsilon))));a.assign(t),o.assign(e);const n=qr(s,e);s.assign(n)}}))})),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&ea(this.accumulatedMeanSquares.map((t=>t.variable))),null!=this.accumulatedMeanGrads&&this.centered&&ea(this.accumulatedMeanGrads.map((t=>t.variable))),null!=this.accumulatedMoments&&ea(this.accumulatedMoments.map((t=>t.variable)))}async getWeights(){const t=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&t.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(t.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t);const e=this.centered?t.length/3:t.length/2,n=!1;this.accumulatedMeanSquares=t.slice(0,e).map((t=>({originalName:t.name,variable:t.tensor.variable(n)}))),this.accumulatedMoments=t.slice(e,2*e).map((t=>({originalName:t.name,variable:t.tensor.variable(n)}))),this.centered&&(this.accumulatedMeanGrads=t.slice(2*e,3*e).map((t=>({originalName:t.name,variable:t.tensor.variable(n)}))))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(t,e){return new t(e.learningRate,e.decay,e.momentum,e.epsilon,e.centered)}}var Nu;Su.className="RMSProp",jo(Su),"undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate&&setImmediate,function(t){t[t.FIRST_DIM_SIZE=0]="FIRST_DIM_SIZE",t[t.VALUE_ROWIDS=1]="VALUE_ROWIDS",t[t.ROW_LENGTHS=2]="ROW_LENGTHS",t[t.ROW_SPLITS=3]="ROW_SPLITS",t[t.ROW_LIMITS=4]="ROW_LIMITS",t[t.ROW_STARTS=5]="ROW_STARTS"}(Nu||(Nu={}));function Eu(t,e,n){const s=t.shape.length,r=s-n.length,i=Yi(n,s);let a=t;null!=i&&(a=ia(t,i));const o=a.shape.slice(),l=o.splice(s-n.length,n.length).reduce(((t,e)=>t*e),1);o.push(l);let u=function(t,e,n){const s=t.shape.slice();s[n]=1;const r=Yr(e,s),i=rl(t,n,!0,!1),a=rl(t,n,!0,!0),o=Mr(i,a);return Mr(r,o)}(a.reshape(o),e,r);if(u=u.reshape(a.shape),null!=i){const t=Xi(i);u=ia(u,t)}return u}const Iu={kernelName:Tn,gradFunc:(t,e,n)=>{const{blockShape:s,paddings:r}=n;return{x:()=>Yo(t,s,r)}}},Au={kernelName:zn,gradFunc:(t,e,n)=>{const{axis:s}=n;return{x:()=>Ho(t,s)}}};const Tu=[Or,Gr,Hr,Qr,ti,ni,si,ri,ai,oi,li,ui,yi,ki,xi,Ni,Ei,Ii,Ai,Fi,Ri,Li,Ui,Pi,ji,Gi,Ji,aa,ua,ha,{kernelName:Le,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Zr(n.shape,s.shape);return{a:()=>{const e=Pr(t,Rr(s,"float32")),i=Jr(n.shape,r);return i.length>0?Yr(Xr(e,i),n.shape):e},b:()=>{let e=Mr(t,Rr(n,"float32"));const i=Jr(s.shape,r);i.length>0&&(e=Yr(Xr(e,i),s.shape));const a=jr(s);return Wr(Pr(e,Rr(a,"float32")))}}}},ca,da,fa,ga,ma,ya,ba,va,Sa,Ia,Aa,Ta,za,$a,_a,Da,Fa,Ra,La,Pa,Pa,Ua,Ka,qa,Ja,Za,Ya,Qa,eo,no,so,ro,io,oo,lo,lo,co,po,{kernelName:hn,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n;let i=[];return i=null==r?s.shape.map(((t,e)=>e)):"number"==typeof r?[r]:r,{x:()=>Eu(s,t,i)}}},{kernelName:cn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Pr(t,Wr(jr(n)))}}},{kernelName:mn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e,s=Mr(zi(n,6),Lr(n));return{x:()=>Mr(t,Rr(s,"float32"))}}},{kernelName:pn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,Rr(Lr(n),"float32"))}}},{kernelName:dn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Yr(t,n.shape)}}},{kernelName:gn,inputsToSave:["images"],gradFunc:(t,e,n)=>{const[s]=e,r={dy:t,images:s};return{images:()=>Ar.runKernel("ResizeBilinearGrad",r,n)}}},{kernelName:fn,inputsToSave:["images"],gradFunc:(t,e,n)=>{const[s]=e,r={dy:t,images:s};return{images:()=>Ar.runKernel("ResizeNearestNeighborGrad",r,n)}}},{kernelName:bn,gradFunc:(t,e,n)=>{const{dims:s}=n,r=Xn(s,t.shape);return{x:()=>Jl(t,r)}}},{kernelName:yn,gradFunc:t=>({x:()=>ei(t)})},{kernelName:wn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Wr(Pr(t,Mr(ho(n,1.5),2)))}}},{kernelName:kn,inputsToSave:["condition"],gradFunc:(t,e)=>{const[n]=e;return{condition:()=>Rr(ei(n),"float32"),t:()=>Mr(t,Rr(n,t.dtype)),e:()=>Mr(t,Rr(wl(n),t.dtype))}}},{kernelName:vn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Ca(n,Vr(0)),s=Vr(1.7580993408473768),r=Vr(1.0507009873554805),i=Mr(t,r),a=Mr(Mr(t,s),pa(Rr(n,"float32")));return Di(e,i,a)}}}},{kernelName:En,outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,Mr(n,qr(Vr(1),n)))}}},{kernelName:Nn,gradFunc:t=>({x:()=>ei(t)})},{kernelName:"Sin",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(nl(Rr(n,"float32")),t)}}},{kernelName:Sn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(sl(Rr(n,"float32")),t)}}},{kernelName:xn,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{begin:r,size:i}=n,a=s.shape,[o,l]=function(t,e,n){let s;const r=t.shape.length;let i;return s="number"==typeof e?[e,...new Array(r-1).fill(0)]:e.length<r?e.concat(new Array(r-e.length).fill(0)):e.slice(),s.forEach((t=>{Kn(-1!==t,(()=>"slice() does not support negative begin indexing."))})),i=null==n?new Array(r).fill(-1):"number"==typeof n?[n,...new Array(r-1).fill(-1)]:n.length<r?n.concat(new Array(r-n.length).fill(-1)):n,i=i.map(((e,n)=>e>=0?e:(Kn(-1===e,(()=>`Negative size values should be exactly -1 but got ${e} for the slice() size at index ${n}.`)),t.shape[n]-s[n]))),[s,i]}(s,r,i),u=[];for(let e=0;e<t.rank;e++)u.push([o[e],a[e]-o[e]-l[e]]);return{x:()=>Al(t,u)}}},{kernelName:$n,outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s]=e,{dim:r}=n,i=Mr(t,s);return{logits:()=>qr(i,Mr(Xr(i,[r],true),s))}}},{kernelName:In,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,Jo(n))}}},Iu,Iu,Au,Au,{kernelName:An,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Pr(t,Mr(Kr(Rr(n,"float32")),2))}}},{kernelName:Cn,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Vr(2);return{a:()=>Mr(t,Mr(r,qr(n,s))),b:()=>Mr(t,Mr(r,qr(s,n)))}}},{kernelName:"Square",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,Mr(Rr(n,"float32"),2))}}},{kernelName:On,gradFunc:t=>({x:()=>ei(t)})},{kernelName:"Sub",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Zr(n.shape,s.shape);return{a:()=>{let e=t;const s=Jr(n.shape,r);return s.length>0&&(e=Xr(e,s)),Yr(e,n.shape)},b:()=>{let e=t;const n=Jr(s.shape,r);return n.length>0&&(e=Xr(e,n)),Yr(Wr(e),s.shape)}}}},{kernelName:"Sum",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,r=s.shape.slice(),{axis:i}=n;Xn(i,s.shape).forEach((t=>{r[t]=1}));const a=Yr(t,r),o=Mr(a,Ha(s.shape,"float32"));return{x:()=>o}}},{kernelName:"Tan",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Pr(t,jr(nl(n)))}}},{kernelName:_n,outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(qr(Vr(1),jr(n)),t)}}},{kernelName:Dn,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{reps:r}=n;return{x:()=>{let e=ei(s);if(1===s.rank)for(let n=0;n<r[0];++n)e=ii(e,Xa(t,[n*s.shape[0]],[s.shape[0]]));else if(2===s.rank)for(let n=0;n<r[0];++n)for(let i=0;i<r[1];++i)e=ii(e,Xa(t,[n*s.shape[0],i*s.shape[1]],[s.shape[0],s.shape[1]]));else if(3===s.rank)for(let n=0;n<r[0];++n)for(let i=0;i<r[1];++i)for(let a=0;a<r[2];++a)e=ii(e,Xa(t,[n*s.shape[0],i*s.shape[1],a*s.shape[2]],[s.shape[0],s.shape[1],s.shape[2]]));else{if(4!==s.rank)throw new Error(`Gradient for tile operation is not implemented for rank-${s.rank} tensors yet.`);for(let n=0;n<r[0];++n)for(let i=0;i<r[1];++i)for(let a=0;a<r[2];++a)for(let o=0;o<r[3];++o)e=ii(e,Xa(t,[n*s.shape[0],i*s.shape[1],a*s.shape[2],o*s.shape[3]],[s.shape[0],s.shape[1],s.shape[2],s.shape[3]]))}return e}}}},{kernelName:Fn,gradFunc:(t,e,n)=>{const s=n,{perm:r}=s,i=Xi(r);return{x:()=>ia(t,i)}}},{kernelName:Rn,gradFunc:(t,e,n)=>{const s=n,{axis:r}=s;return{value:()=>nu(t,r)}}},{kernelName:Mn,inputsToSave:["segmentIds"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>function(t,e){const n=Sl(e,ei(e)),s=dl(t,n);let r=Ti(e,Vr(0,"int32"));const i=s.rank-r.rank;for(let t=0;t<i;++t)r=cl(r,t+1);r=$i(r,Ha(s.shape,"bool"));const a=ei(s);return Di(r,s,a)}(t,n)}}},{kernelName:Ln,gradFunc:t=>({x:()=>ei(t)})}];for(const t of Tu)Es(t);function zu(t,n){return e.tidy((()=>r.sqrt(r.sum(r.mul(t,t),n,!0))))}class $u extends e.serialization.Serializable{getConfig(){return{}}}class Cu extends $u{constructor(t){super(),this.defaultMaxValue=2,this.defaultAxis=0,this.maxValue=null!=t.maxValue?t.maxValue:this.defaultMaxValue,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(t){return e.tidy((()=>{const e=zu(t,this.axis),n=r.clipByValue(e,0,this.maxValue);return r.mul(t,r.div(n,r.add(tt(),e)))}))}getConfig(){return{maxValue:this.maxValue,axis:this.axis}}}Cu.className="MaxNorm",e.serialization.registerClass(Cu);class _u extends $u{constructor(t){super(),this.defaultAxis=0,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(t){return e.tidy((()=>r.div(t,r.add(tt(),zu(t,this.axis)))))}getConfig(){return{axis:this.axis}}}_u.className="UnitNorm",e.serialization.registerClass(_u);class Du extends $u{apply(t){return r.relu(t)}}Du.className="NonNeg",e.serialization.registerClass(Du);class Fu extends $u{constructor(t){super(),this.defaultMinValue=0,this.defaultMaxValue=1,this.defaultRate=1,this.defaultAxis=0,this.minValue=null!=t.minValue?t.minValue:this.defaultMinValue,this.maxValue=null!=t.maxValue?t.maxValue:this.defaultMaxValue,this.rate=null!=t.rate?t.rate:this.defaultRate,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(t){return e.tidy((()=>{const e=zu(t,this.axis),n=r.add(r.mul(this.rate,r.clipByValue(e,this.minValue,this.maxValue)),r.mul(1-this.rate,e));return r.mul(t,r.div(n,r.add(tt(),e)))}))}getConfig(){return{minValue:this.minValue,maxValue:this.maxValue,rate:this.rate,axis:this.axis}}}Fu.className="MinMaxNorm",e.serialization.registerClass(Fu);const Ru={maxNorm:"MaxNorm",minMaxNorm:"MinMaxNorm",nonNeg:"NonNeg",unitNorm:"UnitNorm"};function Mu(t){return w(t)}function Lu(t,n={}){return v(t,e.serialization.SerializationMap.getMap().classNameMap,n,"constraint")}function Ou(t){if(null==t)return null;if("string"==typeof t){return Lu({className:t in Ru?Ru[t]:t,config:{}})}return t instanceof $u?t:Lu(t)}var Bu={__proto__:null,maxNorm:function(t){return new Cu(t)},unitNorm:function(t){return new _u(t)},nonNeg:function(){return new Du},minMaxNorm:function(t){return new Fu(t)}};var Pu,Wu={__proto__:null,zeros:function(){return new kt},ones:function(){return new vt},constant:function(t){return new xt(t)},randomUniform:function(t){return new St(t)},randomNormal:function(t){return new Nt(t)},truncatedNormal:function(t){return new Et(t)},identity:function(t){return new It(t)},varianceScaling:function(t){return new At(t)},glorotUniform:function(t){return new Tt(t)},glorotNormal:function(t){return new zt(t)},heNormal:function(t){return new $t(t)},heUniform:function(t){return new Ct(t)},leCunNormal:function(t){return new _t(t)},leCunUniform:function(t){return new Dt(t)},orthogonal:function(t){return new Ft(t)}};async function Uu(t){if(null==t)return;const n=[],s=[],r=[];for(const e in t){const i=t[e];if("number"!=typeof i){const t=i;n.push(t.data()),s.push(e),r.push(t)}}if(n.length>0){const i=await Promise.all(n);for(let e=0;e<i.length;++e)t[s[e]]=i[e][0];e.dispose(r)}}function Vu(t){if(null!=t)for(const e in t){const n=t[e];"number"!=typeof n&&n.dispose()}}!function(t){t[t.SILENT=0]="SILENT",t[t.VERBOSE=1]="VERBOSE"}(Pu||(Pu={}));class Ku{constructor(){this.validationData=null}setParams(t){this.params=t}async onEpochBegin(t,e){}async onEpochEnd(t,e){}async onBatchBegin(t,e){}async onBatchEnd(t,e){}async onTrainBegin(t){}async onTrainEnd(t){}setModel(t){}}class ju{constructor(t,e=10){null==t&&(t=[]),this.callbacks=t,this.queueLength=e}append(t){this.callbacks.push(t)}setParams(t){for(const e of this.callbacks)e.setParams(t)}setModel(t){for(const e of this.callbacks)e.setModel(t)}async onEpochBegin(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onEpochBegin(t,e)}async onEpochEnd(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onEpochEnd(t,e)}async onBatchBegin(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onBatchBegin(t,e)}async onBatchEnd(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onBatchEnd(t,e)}async onTrainBegin(t){null==t&&(t={});for(const e of this.callbacks)await e.onTrainBegin(t)}async onTrainEnd(t){null==t&&(t={});for(const e of this.callbacks)await e.onTrainEnd(t)}}class qu extends Ku{constructor(){super()}async onEpochBegin(t){this.seen=0,this.totals={}}async onBatchEnd(t,n){null==n&&(n={});const s=null==n.size?0:n.size;this.seen+=s;for(const t in n){const r=n[t];if("number"==typeof r)this.totals.hasOwnProperty(t)||(this.totals[t]=0),this.totals[t]=this.totals[t]+r*s;else{let n;t in this.totals?n=this.totals[t]:this.totals[t]=0;const i=e.tidy((()=>e.add(this.totals[t],e.mul(r,s))));this.totals[t]=i,null!=n&&n.dispose()}}}async onEpochEnd(t,n){if(null!=n)for(const t of this.params.metrics)null!=this.totals[t]&&("number"==typeof this.totals[t]?n[t]=this.totals[t]/this.seen:e.tidy((()=>{const s=e.mul(e.div(1,this.seen),this.totals[t]);n[t]=s,this.totals[t].dispose(),e.keep(n[t])})))}}class Gu extends Ku{async onTrainBegin(t){this.epoch=[],this.history={}}async onEpochEnd(t,e){null==e&&(e={}),this.epoch.push(t);for(const t in e)null==this.history[t]&&(this.history[t]=[]),this.history[t].push(e[t])}async syncData(){const t=[],e=[],n=[];for(const s in this.history){const r=this.history[s];for(let i=0;i<r.length;++i)if("number"!=typeof r[i]){const a=r[i];t.push(a.data()),e.push(s),n.push(i)}}const s=await Promise.all(t);for(let t=0;t<s.length;++t){this.history[e[t]][n[t]].dispose(),this.history[e[t]][n[t]]=s[t][0]}}}class Hu extends Ku{constructor(t,n){if(super(),this.currentEpoch=0,this.nowFunc=t.nowFunc,this.nextFrameFunc=t.nextFrameFunc||e.nextFrame,this.yieldEvery=n||"auto","auto"===this.yieldEvery&&(this.yieldEvery=125),"never"===this.yieldEvery&&null!=t.onYield)throw new Error("yieldEvery is `never` but you provided an `onYield` callback. Either change `yieldEvery` or remove the callback");e.util.isNumber(this.yieldEvery)&&(this.maybeWait=function(t,n,s){let r,i=null!=s?s():e.util.now();return(...a)=>{const o=null!=s?s():e.util.now();return o-i<n||(i=o,r=t(...a)),r}}(this.maybeWait.bind(this),this.yieldEvery,this.nowFunc)),this.trainBegin=t.onTrainBegin,this.trainEnd=t.onTrainEnd,this.epochBegin=t.onEpochBegin,this.epochEnd=t.onEpochEnd,this.batchBegin=t.onBatchBegin,this.batchEnd=t.onBatchEnd,this.yield=t.onYield}async maybeWait(t,e,n){const s=[];null!=this.yield&&(await Uu(n),s.push(this.yield(t,e,n))),s.push(this.nextFrameFunc()),await Promise.all(s)}async onEpochBegin(t,e){this.currentEpoch=t,null!=this.epochBegin&&(await Uu(e),await this.epochBegin(t,e))}async onEpochEnd(t,e){const n=[];null!=this.epochEnd&&(await Uu(e),n.push(this.epochEnd(t,e))),"epoch"===this.yieldEvery&&n.push(this.nextFrameFunc()),await Promise.all(n)}async onBatchBegin(t,e){null!=this.batchBegin&&(await Uu(e),await this.batchBegin(t,e))}async onBatchEnd(t,n){const s=[];null!=this.batchEnd&&(await Uu(n),s.push(this.batchEnd(t,n))),"batch"===this.yieldEvery?s.push(this.nextFrameFunc()):e.util.isNumber(this.yieldEvery)&&s.push(this.maybeWait(this.currentEpoch,t,n)),await Promise.all(s)}async onTrainBegin(t){null!=this.trainBegin&&(await Uu(t),await this.trainBegin(t))}async onTrainEnd(t){null!=this.trainEnd&&(await Uu(t),await this.trainEnd(t))}}function Ju(t,e){if(null==t&&(t={}),t instanceof Ku)return[t];if(Array.isArray(t)&&t[0]instanceof Ku)return t;return g(t).map((t=>new Hu(t,e)))}class Zu{constructor(){}static registerCallbackConstructor(t,n){e.util.assert(t>=0&&Number.isInteger(t),(()=>`Verbosity level is expected to be an integer >= 0, but got ${t}`)),Zu.checkForDuplicate(n),null==Zu.constructors[t]&&(Zu.constructors[t]=[]),Zu.constructors[t].push(n)}static checkForDuplicate(t){for(const e in Zu.constructors){Zu.constructors[+e].forEach((e=>{if(e===t)throw new o("Duplicate callback constructor.")}))}}static clear(){Zu.constructors={}}static createCallbacks(t){const e=[];for(const n in Zu.constructors){const s=+n;t>=s&&e.push(...Zu.constructors[s])}return e.map((t=>new t))}}function Yu(t,e,n,s,r,i,a,o,l){const u=new Gu,h=[new qu,...Zu.createCallbacks(e)];null!=t&&h.push(...t),h.push(u);const c=new ju(h);return c.setParams({epochs:n,initialEpoch:s,samples:r,steps:i,batchSize:a,verbose:e,doValidation:o,metrics:l}),{callbackList:c,history:u}}function Xu(t,n={},s=!1){return v(t,e.serialization.SerializationMap.getMap().classNameMap,n,"layer",s)}function Qu(t,n){return e.tidy((()=>{"float32"!==t.dtype&&(t=r.cast(t,"float32"));const e=r.sum(pt(t),n,!0),s=r.fill(e.shape,tt()),i=r.sqrt(r.maximum(e,s));return r.div(t,i)}))}function th(t,n){return e.tidy((()=>r.mean(pt(r.sub(n,t)),-1)))}function eh(t,n){return e.tidy((()=>r.mean(r.abs(r.sub(n,t)),-1)))}function nh(t,n){return e.tidy((()=>{const e=r.sub(t,n),s=r.clipByValue(r.abs(t),tt(),Number.MAX_VALUE),i=r.abs(r.div(e,s));return r.mul(100,r.mean(i,-1))}))}function sh(t,n,s=!1){return e.tidy((()=>{if(s)n=r.softmax(n);else{const t=r.sum(n,n.shape.length-1,!0);n=r.div(n,t)}return n=r.clipByValue(n,tt(),1-tt()),r.neg(r.sum(r.mul(r.cast(t,"float32"),r.log(n)),n.shape.length-1))}))}function rh(t,n,s=!1){return e.tidy((()=>{const e=r.cast(r.floor(function(t){const e=[J(t.shape)];return r.reshape(t,e)}(t)),"int32"),i=(n=r.clipByValue(n,tt(),1-tt())).shape;return sh(r.reshape(r.oneHot(e,i[i.length-1]),i),n,s)}))}function ih(t,n){return e.tidy((()=>{let s;return s=r.clipByValue(n,tt(),1-tt()),s=r.log(r.div(s,r.sub(1,s))),r.mean(function(t,n){if(!e.util.arraysEqual(t.shape,n.shape))throw new o(`logits and labels must have the same shape, but got shapes ${JSON.stringify(t.shape)} and ${JSON.stringify(n.shape)}`);return e.tidy((()=>{const e=r.relu(n),s=r.neg(r.abs(n));return r.add(r.sub(e,r.mul(n,t)),r.log1p(r.exp(s)))}))}(t,s),-1)}))}function ah(t,n){return e.tidy((()=>{const e=Qu(t,-1),s=Qu(n,-1),i=r.mul(e,s);return r.neg(r.sum(i,-1))}))}Zu.constructors={};const oh={meanSquaredError:th,meanAbsoluteError:eh,meanAbsolutePercentageError:nh,meanSquaredLogarithmicError:function(t,n){return e.tidy((()=>{const e=r.clipByValue(n,tt(),Number.MAX_VALUE),s=r.log(r.add(1,e)),i=r.clipByValue(t,tt(),Number.MAX_VALUE),a=r.log(r.add(1,i));return r.mean(pt(r.sub(s,a)),-1)}))},squaredHinge:function(t,n){return e.tidy((()=>{const e=r.maximum(0,r.sub(1,r.mul(t,n)));return r.mean(pt(e),-1)}))},hinge:function(t,n){return e.tidy((()=>{const e=r.maximum(0,r.sub(1,r.mul(t,n)));return r.mean(e,-1)}))},categoricalHinge:function(t,n){return e.tidy((()=>{const e=r.sum(r.mul(t,n),-1),s=r.max(r.mul(r.sub(1,t),n),-1);return r.maximum(0,r.add(1,r.sub(s,e)))}))},logcosh:function(t,n){return e.tidy((()=>{const e=Math.log(2),s=r.sub(n,t),i=r.sub(r.add(s,r.softplus(r.mul(-2,s))),e);return r.mean(i,-1)}))},categoricalCrossentropy:sh,sparseCategoricalCrossentropy:rh,binaryCrossentropy:ih,kullbackLeiblerDivergence:function(t,n){return e.tidy((()=>{const e=r.clipByValue(t,tt(),1),s=r.clipByValue(n,tt(),1);return r.sum(r.mul(t,r.log(r.div(e,s))),-1)}))},poisson:function(t,n){return e.tidy((()=>{const e=r.log(r.add(tt(),n));return r.mean(r.sub(n,r.mul(t,e)),-1)}))},cosineProximity:ah};function lh(t){if("string"==typeof t){if(t in oh)return oh[t];let e=`Unknown loss ${t}`;throw t.toLowerCase().includes("softmaxcrossentropy")&&(e=`Unknown loss ${t}. Use "categoricalCrossentropy" as the string name for tf.losses.softmaxCrossEntropy`),new o(e)}return t}function uh(t,n){return e.tidy((()=>{const e=r.mul(.5,r.onesLike(n)),s=et(r.greater(n,e),t.dtype);return r.mean(r.equal(t,s),-1)}))}function hh(t,n){return e.tidy((()=>et(r.equal(r.argMax(t,-1),r.argMax(n,-1)),"float32")))}function ch(t,n){return e.tidy((()=>r.cast(r.sum(r.logicalAnd(r.equal(t,1),r.equal(n,1))),"float32")))}function ph(t,n){return e.tidy((()=>{const s=ch(t,n),i=function(t,n){return e.tidy((()=>r.cast(r.sum(r.logicalAnd(r.equal(t,0),r.equal(n,1))),"float32")))}(t,n),a=r.add(s,i);return r.cast(r.where(r.greater(a,0),r.div(s,a),0),"float32")}))}function dh(t,n){return e.tidy((()=>{const s=ch(t,n),i=function(t,n){return e.tidy((()=>r.cast(r.sum(r.logicalAnd(r.equal(t,1),r.equal(n,0))),"float32")))}(t,n),a=r.add(s,i);return r.cast(r.where(r.greater(a,0),r.div(s,a),0),"float32")}))}function fh(t,e){return ih(t,e)}function gh(t,e){return t.rank===e.rank&&(t=r.squeeze(t,[t.rank-1])),(e=r.argMax(e,-1)).dtype!==t.dtype&&(e=r.cast(e,t.dtype)),r.cast(r.equal(t,e),"float32")}const mh=sh,bh=rh,yh={binaryAccuracy:uh,categoricalAccuracy:hh,precision:ph,categoricalCrossentropy:mh,sparseCategoricalCrossentropy:bh,mse:th,MSE:th,mae:eh,MAE:eh,mape:nh,MAPE:nh,cosine:ah};function wh(t){if("string"==typeof t&&t in yh)return yh[t];if("string"!=typeof t&&null!=t)return t;throw new o(`Unknown metric ${t}`)}function kh(t){if(p(null!==t,`Unknown LossOrMetricFn ${t}`),"string"==typeof t)return t;{let e;for(const n of Object.keys(oh))if(oh[n]===t){e=n;break}if(void 0!==e)return e;for(const n of Object.keys(yh))if(yh[n]===t){e=n;break}return void 0!==e?e:t.name}}const vh=1048576;function xh(t,e,n=!1){if(null==t||"object"!=typeof t||Object.getPrototypeOf(t)!==Object.prototype||!Sh(t))throw new Error("User-defined metadata is expected to be a JSON object, but is not.");if(n){const n=JSON.stringify(t);n.length>vh&&console.warn(`User-defined metadata of model "${e}" is too large in size (length=${n.length} when serialized). It is not recommended to store such large objects in user-defined metadata. Please make sure its serialized length is <= 1048576.`)}}function Sh(t){if(null===t)return!0;if("object"==typeof t){if(Object.getPrototypeOf(t)===Object.prototype){const e=Object.keys(t);for(const n of e){if("string"!=typeof n)return!1;if(!Sh(t[n]))return!1}return!0}if(Array.isArray(t)){for(const e of t)if(!Sh(e))return!1;return!0}return!1}{const e=typeof t;return"string"===e||"number"===e||"boolean"===e}}function Nh(t,e,n,s=console.log){const r=function(t){let e=!0;const n=[],s=[];for(const e in t.nodesByDepth)n.push(t.nodesByDepth[e]);for(const t of n){if(t.length>1||1===t.length&&t[0].inboundLayers.length>1){e=!1;break}s.push(...t)}if(e)for(const n of t.layers){let t=!1;for(const r of n.inboundNodes)if(-1!==s.indexOf(r)){if(t){e=!1;break}t=!0}if(!e)break}return e}(t),i=["Layer (type)","Input Shape","Output shape","Param #"];let a;if(r?(e=e||90,n=n||[.32,.61,.89,1]):(e=e||115,n=n||[.24,.48,.7,.8,1]),n[n.length-1]<=1&&(n=n.map((t=>Math.floor(e*t)))),!r){i.push("Receives inputs"),a=[];for(const e in t.nodesByDepth)a.push(...t.nodesByDepth[e])}s("_".repeat(e)),Eh(i,n,s),s("=".repeat(e));const o=t.layers;for(let t=0;t<o.length;++t)r?Ih(o[t],n,s):Ah(o[t],n,a,s),s((t===o.length-1?"=":"_").repeat(e));t.checkTrainableWeightsConsistency();const l=function(t){let e;e=null!=t.collectedTrainableWeights?Vt(t.collectedTrainableWeights):Vt(t.trainableWeights);return e}(t),u=Vt(t.nonTrainableWeights);s(`Total params: ${l+u}`),s(`Trainable params: ${l}`),s(`Non-trainable params: ${u}`),s("_".repeat(e))}function Eh(t,e,n=console.log){let s="";for(let n=0;n<t.length;++n)n>0&&(s=s.slice(0,s.length-1)+" "),s+=t[n],s=s.slice(0,e[n]),s+=" ".repeat(e[n]-s.length);n(s)}function Ih(t,e,n){let s,r;try{r=t.inboundNodes.map((t=>JSON.stringify(t.inputShapes))).join(",")}catch(t){r="multiple"}try{s=JSON.stringify(t.outputShape)}catch(t){s="multiple"}Eh([`${t.name} (${t.getClassName()})`,r,s,t.countParams().toString()],e,n)}function Ah(t,e,n,s){let r,i;try{i=t.inboundNodes.map((t=>JSON.stringify(t.inputShapes))).join(",")}catch(t){i="multiple"}try{r=JSON.stringify(t.outputShape)}catch(t){r="multiple"}const a=[];for(const e of t.inboundNodes)if(!(null!=n&&n.length>0&&-1===n.indexOf(e)))for(let t=0;t<e.inboundLayers.length;++t){const n=e.inboundLayers[t].name,s=e.nodeIndices[t],r=e.tensorIndices[t];a.push(`${n}[${s}][${r}]`)}const o=t.name,l=t.getClassName(),u=0===a.length?"":a[0];Eh([`${o} (${l})`,i,r,t.countParams().toString(),u],e,s);for(let t=1;t<a.length;++t)Eh(["","","","",a[t]],e,s)}function Th(t,e,n){return("inboundNodes"===t||"outputLayers"===t||"inputLayers"===t)&&0===e&&"string"==typeof n}function zh(t,e){if(null===t)return null;if("string"==typeof t)return b(t);if("number"==typeof t||"boolean"==typeof t)return t;if(t instanceof Array){const n=[],s=t.length;for(let r=0;r<s;++r){const s=t[r];Th(e,r,s)?n.push(s):n.push(zh(s,e))}return n}{const e={};for(const n of Object.keys(t)){const s=t[n];if("name"===n&&"string"==typeof s)e[n]=s;else{const t=b(n);e[t]=zh(s,t)}}return e}}function $h(t,e){if(null==t)return null;if("string"==typeof t)return m(t);if("number"==typeof t||"boolean"==typeof t)return t;if(t instanceof Array){const n=[],s=t.length;for(let r=0;r<s;++r){const s=t[r];Th(e,r,s)?n.push(s):n.push($h(s,e))}return n}{const e={};for(const n of Object.keys(t)){const s=t[n],r=m(n);e[r]="name"!==n&&"className"!==n||"string"!=typeof s?$h(s,n):s}return e}}const Ch="4.0.0";class _h extends Qt{constructor(t){if(super({}),this.containerNodes=new Set,this.name=t.name,null==this.name){const t=this.getClassName().toLowerCase();this.name=D(t)}if(this.supportsMasking=!1,this.trainable_=!0,Array.isArray(t.inputs)?this.inputs=t.inputs.slice():this.inputs=[t.inputs],Array.isArray(t.outputs)?this.outputs=t.outputs.slice():this.outputs=[t.outputs],S(this.inputs).length!==this.inputs.length)throw new o(`The list of inputs passed to the model is redundant. All inputs should only appear once. Found: ${this.inputs.map((t=>t.name))}`);S(this.outputs).length!==this.outputs.length&&console.warn(`The list of outputs passed to the model is redundant. All outputs should only appear once. Found: ${this.outputs.map((t=>t.name))}`),this.inputLayers=[],this.inputLayersNodeIndices=[],this.inputLayersTensorIndices=[],this.outputLayers=[],this.outputLayersNodeIndices=[],this.outputLayersTensorIndices=[],this.layers=[],this.internalContainerRefs=[];for(const t of this.outputs){const e=t.sourceLayer,n=t.nodeIndex,s=t.tensorIndex;this.outputLayers.push(e),this.outputLayersNodeIndices.push(n),this.outputLayersTensorIndices.push(s)}for(const t of this.inputs){const e=t.sourceLayer,n=t.nodeIndex,s=t.tensorIndex;p(0===n,"input layer has >1 nodes"),p(0===s,"input layer has >1 tensors"),this.inputLayers.push(e),this.inputLayersNodeIndices.push(n),this.inputLayersTensorIndices.push(s)}this.inputNames=[],this.outputNames=[],this.feedInputShapes=[],this.feedInputNames=[],this.feedOutputNames=[];for(let e=0;e<this.inputLayers.length;e++){const n=this.inputLayers[e];if(!(n instanceof ee))throw new TypeError(`Input layers to a LayersModel must be InputLayer objects. Received inputs: ${t.inputs}. Input ${e} (0-based) originates from layer type ${n.getClassName()}.`);this.inputNames.push(n.name),this.feedInputShapes.push(n.batchInputShape),this.feedInputNames.push(n.name)}for(const t of this.outputLayers)this.outputNames.push(t.name);this.internalInputShapes=this.inputs.map((t=>t.shape)),this.internalOutputShapes=this.outputs.map((t=>t.shape));const e={},n={},s={},r={},i={},l=[],u=(t,e,n,s,r,o)=>{null!=s&&null!=r&&null!=o||(s=t.sourceLayer,r=t.nodeIndex,o=t.tensorIndex);const h=s.inboundNodes[r];if(-1!==n.indexOf(h))throw new a(`The tensor ${t.name} at layer "${s.name}" is part of a cycle.`);if(-1!==e.indexOf(h))return;this.containerNodes.add(_h.nodeKey(s,r)),s.id in i||(i[s.id]=Object.keys(i).length),-1===n.indexOf(h)&&n.push(h);const c=h.inboundLayers.length;for(let t=0;t<c;t++){const s=h.inputTensors[t],r=h.inboundLayers[t],i=h.nodeIndices[t],a=h.tensorIndices[t];u(s,e,n,r,i,a)}for(e.push(h);n.indexOf(h)>=0;)n.splice(n.indexOf(h),1);l.push(h)},h=[],c=[];for(const t of this.outputs)u(t,h,c);const d=l.slice().reverse();for(const t of d){n[t.id]=t,t.id in e||(e[t.id]=0);let i=e[t.id];const a=null==s[t.outboundLayer.id]?0:s[t.outboundLayer.id];i=Math.max(i,a),s[t.outboundLayer.id]=i,r[t.outboundLayer.id]=t.outboundLayer,e[t.id]=i;for(let s=0;s<t.inboundLayers.length;s++){const r=t.inboundLayers[s],a=t.nodeIndices[s],o=r.inboundNodes[a],l=null==e[o.id]?0:e[o.id];e[o.id]=Math.max(i+1,l),n[o.id]=o}}const f={};for(const t in e){const s=e[t];s in f||(f[s]=[]),f[s].push(n[t])}const g={};for(const t in s){const e=s[t];e in g||(g[e]=[]),g[e].push(r[t])}let m=Object.keys(g).map((t=>parseInt(t,10))).sort(x);this.layers=[];for(const t of m){const e=g[t];e.sort(((t,e)=>{const n=i[t.id],s=i[e.id];return n<s?-1:n>s?1:0}));for(const t of e)t instanceof _h&&this.internalContainerRefs.push(t),this.layers.push(t)}this.layersByDepth=g,m=Object.keys(f).map((t=>parseInt(t,10))).sort(x);const b=this.inputs.slice(),y=[];for(const t of m)for(const e of f[t]){const t=e.outboundLayer;if(null!=t){for(const n of e.inputTensors)if(-1===b.indexOf(n))throw new a(`Graph disconnected: cannot obtain value for tensor ${n} at layer "${t.name}". The following previous layers were accessed without issue: ${y}`);for(const t of e.outputTensors)b.push(t);y.push(t.name)}}this.nodesByDepth=f;const w=this.layers.map((t=>t.name));for(const t of w){const e=w.filter((e=>e===t)).length;if(1!==e)throw new a(`The name "${t}" is used ${e} times in the model. All layer names should be unique. Layer names: `+JSON.stringify(w))}this.outboundNodes=[],this.inboundNodes=[],new Yt({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:this.inputs.map((t=>null)),outputMasks:this.outputs.map((t=>null)),inputShapes:this.inputs.map((t=>t.shape)),outputShapes:this.outputs.map((t=>t.shape))}),this.built=!0,this._refCount=1}assertNotDisposed(){if(0===this._refCount)throw new Error(`Container '${this.name}' is already disposed.`)}dispose(){this.assertNotDisposed();const t={refCountAfterDispose:null,numDisposedVariables:0};if(0==--this._refCount){for(const e of this.layers)t.numDisposedVariables+=e.dispose().numDisposedVariables;for(const e of this.internalContainerRefs)t.numDisposedVariables+=e.dispose().numDisposedVariables}return t.refCountAfterDispose=this._refCount,t}get trainable(){return this.trainable_}set trainable(t){this.layers.forEach((e=>{e._trainableWeights.forEach((e=>e.trainable=t))})),this.trainable_=t}get trainableWeights(){if(this._trainableWeights.length>0)throw new o("Container instance unexpectedly contains _trainableWeights.The trainable weights of a Container are a union of the trainable weights of its consituent Layers. Its own _trainableWeights must remain an empty Array.");if(!this.trainable)return[];let t=[];for(const e of this.layers)t=t.concat(e.trainableWeights);return t}get nonTrainableWeights(){const t=[];for(const e of this.layers)t.push(...e.nonTrainableWeights);if(!this.trainable){const e=[];for(const t of this.layers)e.push(...t.trainableWeights);return e.concat(t)}return t}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}loadWeights(t,e=!0){const n={};let s=0;for(const t of this.layers)for(const e of t.weights){if(null!=n[e.originalName])throw new o(`Duplicate weight name: ${e.originalName}`);n[e.originalName]=e,s++}const r=[];for(const s in t){let i=s;if(null==n[s]){const t=s.split("/");i=t.slice(0,-2).concat([t[t.length-1]]).join("/")}if(null!=n[i])r.push([n[i],t[s]]);else if(e)throw new o(`Provided weight data has no target variable: ${s}`);delete n[i]}if(e){const t=[];for(const e in n)t.push(e);if(t.length>0)throw new o(`${t.length} of ${s} weights are not set: ${t}`)}Gt(r)}updatedConfig(){const t=this.getConfig(),e={};return e.className=this.getClassName(),e.config=t,e.kerasVersion="tfjs-layers 4.0.0",e.backend="TensorFlow.js",e}toJSON(t,e=!0){const n=$h(this.updatedConfig());return e?JSON.stringify(n):n}call(t,n){return e.tidy((()=>{t=g(t);const e=new se;for(let n=0;n<this.inputs.length;++n)e.add(this.inputs[n],t[n]);return ae(this.outputs,e,n)}))}computeMask(t,n){return e.tidy((()=>{let e;return t=g(t),e=null==n?c(null,t.length):g(n),this.runInternalGraph(t,e)[1]}))}computeOutputShape(t){const e=Pt(t);if(e.length!==this.inputLayers.length)throw new o(`Invalid inputShape argument ${t}: model has ${this.inputLayers.length} tensor inputs.`);const n={};for(let t=0;t<e.length;t++){const s=this.inputLayers[t],r=e[t];n[s.name+"_0_0"]=r}const s=Object.keys(this.nodesByDepth).map((t=>parseInt(t,10))).sort(x);if(s.length>1)for(const t of s){const e=this.nodesByDepth[t];for(const t of e){const e=t.outboundLayer;if(-1!==this.inputLayers.map((t=>t.id)).indexOf(e.id))continue;const s=[];for(let e=0;e<t.inboundLayers.length;e++){const r=t.inboundLayers[e],i=t.nodeIndices[e],a=t.tensorIndices[e],o=n[`${r.name}_${i}_${a}`];s.push(o)}const r=Pt(e.computeOutputShape(f(s))),i=e.inboundNodes.indexOf(t);for(let t=0;t<r.length;t++){n[`${e.name}_${i}_${t}`]=r[t]}}}const r=[],i=[];for(let t=0;t<this.outputLayers.length;t++){const e=this.outputLayers[t],n=this.outputLayersNodeIndices[t],s=this.outputLayersTensorIndices[t],r=`${e.name}_${n}_${s}`;i.push(r)}for(let t=0;t<i.length;t++){const e=i[t];p(e in n),r.push(n[e])}return f(r)}runInternalGraph(t,e){null==e&&(e=c(null,t.length));const n={};for(let s=0;s<this.inputs.length;++s){const r=this.inputs[s],i=t[s],a=e[s];n[r.id]=[i,a]}const s=Object.keys(this.nodesByDepth).map((t=>parseInt(t,10))).sort(x);for(const t of s){const e=this.nodesByDepth[t];for(const t of e){const e=t.outboundLayer,s=t.inputTensors,r=t.outputTensors,i=new Array;for(const t of s)t.id in n&&i.push(n[t.id]);if(i.length===s.length){let s,a,o,u,h={};if(null!=t.callArgs&&(h=t.callArgs),1===i.length){const[t,n]=i[0];null==h.mask&&(h.mask=n),o=g(e.call(t,h)),u=g(e.computeMask(t,n)),s=[t],a=[n]}else s=i.map((t=>t[0])),a=i.map((t=>t[1])),null==h.mask&&(h.mask=a),o=g(e.call(s,h)),u=g(e.computeMask(s,a));if(e.activityRegularizer)throw new l("LayersModel invocation with concrete Tensor value(s) in the presence of activity regularizer(s) is not supported yet.");for(let t=0;t<r.length;++t){const e=r[t],s=o[t],i=u[t];n[e.id]=[s,i]}}}}const r=[],i=[],a=[];for(const t of this.outputs){p(t.id in n,`Could not compute output ${t.name} : ${t.id}`);const[e,s]=n[t.id];a.push(e.shape),r.push(e),i.push(s)}return[r,i,a]}buildNodeConversionMap(t){const e={};let n;for(const t of this.layers){n=t instanceof _h?1:0;for(let s=0;s<t.inboundNodes.length;s++){const r=_h.nodeKey(t,s);this.containerNodes.has(r)&&(e[r]=n,n+=1)}}return e}getLayer(t,e){if(null!=e){if(this.layers.length<=e)throw new o(`Was asked to retrieve layer at index ${e}, but model only has ${this.layers.length} layer(s).`);return this.layers[e]}if(null==t)throw new o("Provide either a layer name or layer index");for(const e of this.layers)if(e.name===t)return e;throw new o(`No such layer: ${t}`)}calculateLosses(){return e.tidy((()=>{const t=[];for(const e of this.layers)for(let n=0;n<e.inboundNodes.length;++n){const s=_h.nodeKey(e,n);this.containerNodes.has(s)&&t.push(...e.calculateLosses())}return t}))}getConfig(){const t={name:this.name},e=this.buildNodeConversionMap(this.layers),n=[];for(const t of this.layers){const s=t.getClassName(),r=t.getConfig(),i=[];for(let n=0;n<t.inboundNodes.length;n++){const s=t.inboundNodes[n],r=_h.nodeKey(t,n);let a={};if(this.containerNodes.has(r)){if(s.callArgs)try{JSON.stringify(s.callArgs),a=s.callArgs}catch(e){console.warn(`Layer ${t.name} was passed non-serializable keyword arguments: ${s.callArgs}. They will not be included in the serialized model (and thus will be missing at deserialization time).`),a={}}if(s.inboundLayers.length>0){const t=[];for(let n=0;n<s.inboundLayers.length;n++){const r=s.inboundLayers[n],i=s.nodeIndices[n],o=s.tensorIndices[n];let l=e[_h.nodeKey(r,i)];null==l&&(l=0),t.push([r.name,l,o,a])}i.push(t)}}}const a={};a.name=t.name,a.className=s,a.config=r,a.inboundNodes=i,n.push(a)}t.layers=n;const s=[];for(let t=0;t<this.inputLayers.length;t++){const n=this.inputLayers[t],r=this.inputLayersNodeIndices[t],i=_h.nodeKey(n,r);if(!this.containerNodes.has(i))continue;let a=e[i];null==a&&(a=0);const o=this.inputLayersTensorIndices[t];s.push([n.name,a,o])}t.inputLayers=s;const r=[];for(let t=0;t<this.outputLayers.length;t++){const n=this.outputLayers[t],s=this.outputLayersNodeIndices[t],i=_h.nodeKey(n,s);if(!this.containerNodes.has(i))continue;let a=e[i];null==a&&(a=0);const o=this.outputLayersTensorIndices[t];r.push([n.name,a,o])}return t.outputLayers=r,t}static fromConfig(t,e,n={},s=!1){const r={},i={};function a(t,e){t.name in i?i[t.name].push(e):i[t.name]=[e]}function l(t,e){const n=[];let s;for(const i of e){const o=i[0],l=i[1],u=i[2];if(s=null==i[3]?{}:i[3],!(o in r))return void a(t,e);const h=r[o];if(h.inboundNodes.length<=l)return void a(t,e);const c=h.inboundNodes[l];n.push(c.outputTensors[u])}n.length>0&&t.apply(f(n),s)}function u(t){const n=t.name,i=Xu(t,null!=e.customObjects?e.customObjects:{});i.setFastWeightInitDuringBuild(s),r[n]=i;t.inboundNodes.forEach((t=>{if(!(t instanceof Array))throw new o(`Corrupted configuration, expected array for nodeData: ${t}`);a(i,t)}))}const h=e.name,c=e.layers;for(const t of c)u(t);for(;!N(i);)for(const t of c){const e=r[t.name];if(e.name in i){const t=i[e.name];delete i[e.name];for(const n of t)l(e,n)}}const d=[],g=[],m=e.inputLayers;for(const t of m){const e=t[0],n=t[1],s=t[2];p(e in r);const i=r[e].inboundNodes[n].outputTensors;d.push(i[s])}const b=e.outputLayers;for(const t of b){const e=t[0],n=t[1],s=t[2];p(e in r);const i=r[e].inboundNodes[n].outputTensors;g.push(i[s])}return new t({inputs:d,outputs:g,name:h})}get stateful(){if(this._stateful)throw new o("Container instance unexpectedly has _stateful = true. The statefulness of a Container is determined by the Layers it contains. Its _stateful property must remain the default false.");for(const t of this.layers)if(t.stateful)return!0;return!1}resetStates(){e.tidy((()=>{this.layers.forEach((t=>{t.stateful&&t.resetStates()}))}))}}function Dh(t,e){return function(t,e,n){const s=e.length;if(null==t||Array.isArray(t)&&0===t.length)return e.map((t=>null));if(1===s)return Array.isArray(t)&&1===t.length?t:"object"==typeof t&&e[0]in t?[t[e[0]]]:[t];if(Array.isArray(t)){if(t.length!==s)throw new Error(`Provided ${n} is an array of ${t.length} element(s), but the model has ${s} outputs. Make sure a set of weights is provided for each model output.`);return t}if("object"==typeof t&&Object.keys(t).length>0&&"object"==typeof t[Object.keys(t)[0]]){const n=[];return e.forEach((e=>{e in t?n.push(t[e]):n.push(null)})),n}throw new Error(`The model has multiple (${s}) outputs, so ${n} must be either an array with ${s} elements or an object with ${e} keys. Provided ${n} not understood: ${JSON.stringify(t)}`)}(t,e,"classWeight")}async function Fh(t,n,s,r){if(null!=n||null!=r)throw new Error("Support sampleWeight is not implemented yet");if(null!=s){const n=e.tidy((()=>{if(1===t.shape.length)return e.clone(t);if(2===t.shape.length){if(t.shape[1]>1){const n=1;return e.argMax(t,n)}if(1===t.shape[1])return e.reshape(t,[t.shape[0]]);throw new Error(`Encountered unexpected last-dimension size (${t.shape[1]}) during handling of class weights. The size is expected to be >= 1.`)}throw new Error(`Unexpected rank of target (y) tensor (${t.rank}) during handling of class weights. The rank is expected to be 1 or 2.`)})),r=Array.from(await n.data());e.dispose(n);const i=[];return r.forEach((t=>{if(null==s[t])throw new Error(`classWeight must contain all classes in the training data. The class ${t} exists in the data but not in classWeight`);i.push(s[t])})),e.tensor1d(i,"float32")}return null}function Rh(t,n){return e.mul(t,n)}function Mh(t,e){let n,s;const i=e;n=i.xs,s=i.ys,r.util.assert(null!=n&&null!=s,(()=>`A Dataset iterator for fitDataset() is expected to generate objects of the form \`{xs: xVal, ys: yVal}\`, where the two values may be \`tf.Tensor\`, an array of Tensors, or a map of string to Tensor.  The provided Dataset instead generates ${e}`));const a=Lh("input",t.inputNames,n),o=Lh("output",t.outputNames,s),l=a[0].shape[0];r.util.assert(a.length===t.inputs.length,(()=>`LayersModel has ${t.inputs.length} inputs, but the dataset provides ${a.length} inputs.  (Expected input keys: ${JSON.stringify(t.inputNames)})`)),r.util.assert(o.length===t.outputs.length,(()=>`LayersModel has ${t.outputs.length} outputs, but the dataset provides ${o.length} outputs.  (Expected output keys: ${JSON.stringify(t.outputNames)})`));for(let e=0;e<a.length;e++)r.util.assert(a[e].shape[0]===l,(()=>`Batch size mismatch: input ${t.inputNames[e]} has ${a[e].shape[0]}; expected  ${l} based on input ${t.inputNames[0]}.`));for(let e=0;e<o.length;e++)r.util.assert(o[e].shape[0]===l,(()=>`Batch size mismatch: output ${t.outputNames[e]} has ${o[e].shape[0]}; expected  ${l} based on input ${t.inputNames[0]}.`));return{xs:a,ys:o}}function Lh(t,e,n){if(n instanceof r.Tensor)return[n];if(Array.isArray(n))return r.util.assert(n.length===e.length,(()=>`Received an array of ${n.length} Tensors, but expected ${e.length} to match the ${t} keys ${e}.`)),n;{const s=[];for(const r of e){if(null==n[r])throw new o(`The feature data generated by the dataset lacks the required ${t} key '${r}'.`);s.push(n[r])}return s}}async function Oh(t,e,n){const s=null!=n.batchesPerEpoch;if(r.util.assert(null!=t.optimizer,(()=>"You must compile a model before training/testing. Use LayersModel.compile(modelCompileConfig).")),r.util.assert(null!=n,(()=>"For fitDataset(), the 2nd argument (config) is required, but it is not provided in this call.")),r.util.assert(null!=n.epochs&&n.epochs>0&&Number.isInteger(n.epochs),(()=>`For fitDataset(), config.epochs is expected to be a positive integer, but got ${n.epochs}`)),r.util.assert(!s||n.batchesPerEpoch>0&&Number.isInteger(n.batchesPerEpoch),(()=>`For fitDataset(), config.batchesPerEpoch is expected to be a positive integer if specified, but got ${n.batchesPerEpoch}`)),r.util.assert(null==n.validationSplit,(()=>"`validationSplit` is not supported by `fitDataset()`. Use validationData instead.")),t.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");t.isTraining=!0;try{const i=null!=n.validationData;let a,o;if(i)if(Bh(n.validationData))r.util.assert(null==n.validationBatches||n.validationBatches>0&&Number.isInteger(n.validationBatches),(()=>`For fitDataset() with dataset-based validation, config.validationBatches is expected not to be provided, or to be a positive integer, but got ${n.validationBatches}`));else{const t=function(t){if(3===t.length)throw new l("Validation with sample weights is not implemented yet.");return{xs:t[0],ys:t[1]}}(n.validationData);a=t.xs,o=t.ys}const u=t.makeTrainFunction(),h=t.getDedupedMetricsNames();let c;c=i?h.slice().concat(h.map((t=>"val_"+t))):h.slice();const p=Ju(n.callbacks,n.yieldEvery),d=null==n.verbose?1:n.verbose,{callbackList:f,history:m}=Yu(p,d,n.epochs,null,null,function(t,e){let n=null;null!=e.batchesPerEpoch?n=e.batchesPerEpoch:Number.isFinite(t.size)&&(n=t.size);return n}(e,n),null,i,c);f.setModel(t),t.history=m,await f.onTrainBegin(),t.stopTraining_=!1;let b=null==n.initialEpoch?0:n.initialEpoch,y=await e.iterator();for(;b<n.epochs;){const l={};await f.onEpochBegin(b);let c=0,p=0;for(s||(y=await e.iterator());!s||c<n.batchesPerEpoch;){const e=await y.next();if(s&&e.done){console.warn(`You provided \`batchesPerEpoch\` as ${n.batchesPerEpoch}, but your dataset iterator ran out of data after ${c} batches; interrupting training. Make sure that your dataset can generate at least \`batchesPerEpoch * epochs\` batches (in this case, `+n.batchesPerEpoch*n.epochs+" batches). You may need to use the repeat() function when building your dataset.");break}if(null!=e.value){const{xs:s,ys:i}=Mh(t,e.value),a={};a.batch=p,a.size=s[0].shape[0],await f.onBatchBegin(p,a);const o=[];if(null!=n.classWeight){const e=Dh(n.classWeight,t.outputNames);for(let t=0;t<e.length;++t)o.push(await Fh(i[t],null,e[t]))}const l=s.concat(i).concat(o),d=u(l);r.dispose(l);for(let t=0;t<h.length;++t){const e=h[t],n=d[t];a[e]=n,r.keep(n)}await f.onBatchEnd(p,a),Vu(a),p++,c++}if(s?c>=n.batchesPerEpoch:e.done){if(i){let e;e=Bh(n.validationData)?g(await t.evaluateDataset(n.validationData,{batches:n.validationBatches})):g(t.evaluate(a,o,{batchSize:null==n.validationBatchSize?32:n.validationBatchSize,verbose:0}));for(let n=0;n<t.metricsNames.length;++n)l[`val_${t.metricsNames[n]}`]=e[n]}break}if(t.stopTraining_)break}if(await f.onEpochEnd(b,l),b++,t.stopTraining_)break}return await f.onTrainEnd(),await t.history.syncData(),t.history}finally{t.isTraining=!1}}function Bh(t){return"function"==typeof t.iterator}function Ph(t){r.util.assert(t>0&&Number.isInteger(t),(()=>`batchSize is required to be a positive integer, but got ${t}`))}function Wh(t,e,n){return null==t?[null]:Array.isArray(t)?t.map((t=>st(t,e,n-e))):st(t,e,n-e)}function Uh(t,e){return r.tidy((()=>null==t?null:Array.isArray(t)?t.map((t=>Uh(t,e))):ct(t,"int32"===e.dtype?e:r.cast(e,"int32"))))}function Vh(t,e){const n=[];let s=0,r=null;for(;s<t;)r=s+e,r>=t&&(r=t),n.push([s,r]),s=r;return n}async function Kh(t,n,s,i={}){if(t.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");let a,u,h,c,p,d,f,g,m;t.isTraining=!0;try{const b=null==i.batchSize?32:i.batchSize;Ph(b);const y=!1,w=await t.standardizeUserData(n,s,i.sampleWeight,i.classWeight,y,b);a=w[0],u=w[1],m=w[2];let k,v=!1;if(null!=i.validationData&&i.validationData.length>0){if(v=!0,2!==i.validationData.length)throw 3===i.validationData.length?new l("validationData including sample weights is not supported yet."):new o(`When passing validation data, it must contain 2 (valX, valY) or 3 (valX, valY, valSampleWeight) items; ${i.validationData} is invalid.`);p=i.validationData[0],d=i.validationData[1];const e=!0,n=await t.standardizeUserData(p,d,null,null,e,b);f=n[0],g=n[1],k=f.concat(g)}else if(null!=i.validationSplit&&i.validationSplit>0&&i.validationSplit<1){v=!0;const t=Math.floor(a[0].shape[0]*(1-i.validationSplit)),e=a[0].shape[0];f=Wh(a,t,e),h=a,a=Wh(a,0,t),g=Wh(u,t,e),c=u,u=Wh(u,0,t),k=f.concat(g)}else null!=i.validationSteps&&(v=!0);const x=a.concat(u).concat(m);t.checkTrainableWeightsConsistency();const S=t.makeTrainFunction(),N=t.getDedupedMetricsNames();let E,I;v?(t.makeTestFunction(),E=t.testFunction,I=N.slice().concat(N.map((t=>"val_"+t)))):(E=null,k=[],I=N.slice());const A=Ju(i.callbacks,i.yieldEvery),T=await async function(t,n,s,i,a,u,h,c,p,d,f,g,m,b,y){null==a&&(a=32),null==u&&(u=1),null==f&&(f=!0),null==m&&(m=0);let w=!1;if(null!=p&&null!=d&&(w=!0),null!=y&&(w=!0,null==b))throw new o("Can only use `validationSteps` when doing step-wise training, i.e., `stepsPerEpoch` must be set.");const k=t.checkNumSamples(s,a,b,"steps_per_epoch");let v;null!=k&&(v=X(0,k)),null==h&&(h=1);const{callbackList:x,history:S}=Yu(c,h,u,m,k,b,a,w,g);x.setModel(t),t.history=S,await x.onTrainBegin(),t.stopTraining_=!1;for(let o=m;o<u;++o){await x.onEpochBegin(o);const u={};if(null!=b)throw new l("stepsPerEpoch mode is not implemented yet.");{if("batch"===f)throw new l("batch shuffling is not implemneted yet");f&&e.util.shuffle(v);const o=e.tensor1d(v),h=Vh(k,a);for(let e=0;e<h.length;++e){const l={};if(await x.onBatchBegin(e,l),r.tidy((()=>{const c=h[e][0],f=h[e][1],g=st(o,c,f-c);l.batch=e,l.size=f-c;const m=Uh(s,g),b=n(m);for(let t=0;t<i.length;++t){const e=i[t],n=b[t];l[e]=n,r.keep(n)}if(e===h.length-1&&w){const e=t.testLoop(p,d,a);for(let t=0;t<i.length;++t){const n=i[t],s=e[t];r.keep(s),u["val_"+n]=s}}})),await x.onBatchEnd(e,l),Vu(l),t.stopTraining_)break}o.dispose()}if(await x.onEpochEnd(o,u),t.stopTraining_)break}return await x.onTrainEnd(),await t.history.syncData(),t.history}(t,S,x,N,b,i.epochs,i.verbose,A,E,k,i.shuffle,I,i.initialEpoch,null,null);return T}finally{t.isTraining=!1,qh(a,n),qh(u,s),qh(h,n),qh(c,s),qh(f,p),qh(g,d),null!=m&&r.dispose(m)}}function jh(t){const n=[];t instanceof e.Tensor&&(t=[t]);for(let e=0;e<t.length;++e){const s=t[e];if(1===s.rank)n.push(nt(s,1));else{if(0===s.rank)throw new Error("Expected tensor to be at least 1D, but received a 0D tensor (scalar).");n.push(s)}}return n}function qh(t,n){if(null==t)return;const s=[];if(n instanceof e.Tensor)s.push(n.id);else if(Array.isArray(n))n.forEach((t=>s.push(t.id)));else if(null!=n)for(const t in n){const e=n[t];s.push(e.id)}const r=[];if(t instanceof e.Tensor)-1===s.indexOf(t.id)&&r.push(t);else if(Array.isArray(t))t.forEach((t=>{-1===s.indexOf(t.id)&&r.push(t)}));else if(null!=t)for(const e in t){const n=t[e];-1===s.indexOf(n.id)&&r.push(n)}r.forEach((t=>{t.isDisposed||t.dispose()}))}function Gh(t){return Array.isArray(t)}function Hh(t){return!function(t){return t instanceof e.Tensor}(t)&&!Gh(t)}function Jh(t,e,n,s=!0,r=""){if(null==e||0===e.length){if(null!=t){let e=!1;if(Gh(t)&&t.length>0)e=!0;else if(Hh(t)){for(const n in t)if(t.hasOwnProperty(n)){e=!0;break}}else e=!0;if(e)throw new o(`Error when checking model ${r} expected no data, but got ${t}`)}return[]}if(null==t)return e.map((t=>null));let i;if(Hh(t)){i=[];for(const n of e){if(null==t[n])throw new o(`No data provided for "${n}". Need data for each key in: ${e}`);i.push(t[n])}}else if(Gh(t)){if(t.length!==e.length)throw new o(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the model expected. Expected to see ${e.length} Tensor(s), but instead got the following list of Tensor(s): ${t}`);i=t}else{if(e.length>1)throw new o(`The model ${r} expects ${e.length} Tensor(s), but only received one Tensor. Found: Tensor with shape ${t.shape}`);i=[t]}if(i=jh(i),null!=n)for(let t=0;t<e.length;++t){if(null==n[t])continue;const a=i[t];if(a.shape.length!==n[t].length)throw new o(`Error when checking ${r}: expected ${e[t]} to have ${n[t].length} dimension(s). but got array with shape ${a.shape}`);for(let e=0;e<n[t].length;++e){if(0===e&&!s)continue;const i=a.shape[e],l=n[t][e];if(null!=l&&l>=0&&i!==l)throw new o(`${r} expected a batch of elements where each example has shape [${n[t].slice(1,n[t].length)}] (i.e.,tensor shape [*,${n[t].slice(1,n[t].length)}]) but the ${r} received an input with ${a.shape[0]} examples, each with shape [${a.shape.slice(1,a.shape.length)}] (tensor shape [${a.shape}])`)}}return i}function Zh(t,e,n,s=!0,r=""){let i;if(Array.isArray(t)){if(t.length!==e.length)throw new o(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the the model expected. Expected to see ${e.length} Tensor(s), but instead got ${t.length} Tensors(s).`);i=t}else{if(e.length>1)throw new o(`The model expects ${e.length} ${r} Tensors, but only received one Tensor. Found: array with shape ${JSON.stringify(t.shape)}.`);i=[t]}if(null!=n)for(let t=0;t<e.length;++t){if(null==n[t])continue;const a=i[t];if(a.shape.length!==n[t].length)throw new o(`Error when checking ${r}: expected ${e[t]} to have ${n[t].length} dimension(s), but got array with shape ${JSON.stringify(a.shape)}`);for(let i=0;i<n[t].length;++i){if(0===i&&!s)continue;const l=a.shape[i],u=n[t][i];if(null!=u&&u!==l)throw new o(`Error when checking ${r}: expected ${e[t]} to have shape ${JSON.stringify(n[t])} but got array with shape ${JSON.stringify(a.shape)}.`)}}}class Yh extends _h{constructor(t){super(t),this.isTraining=!1}summary(t,e,n=console.log){if(!this.built)throw new o("This model has never been called, thus its weights have not been created yet. So no summary can be displayed. Build the model first (e.g., by calling it on some test data).");Nh(this,t,e,n)}compile(t){if(null==t.loss&&(t.loss=[]),this.loss=t.loss,"string"==typeof t.optimizer)this.optimizer_=function(t){const n={Adagrad:()=>e.train.adagrad(.01),Adadelta:()=>e.train.adadelta(1,.95,tt()),Adam:()=>e.train.adam(.001,.9,.999,tt()),Adamax:()=>e.train.adamax(.002,.9,.999,tt(),0),RMSProp:()=>e.train.rmsprop(.001,.9,0,tt()),SGD:()=>e.train.sgd(.01)};if(n.adagrad=n.Adagrad,n.adadelta=n.Adadelta,n.adam=n.Adam,n.adamax=n.Adamax,n.rmsprop=n.RMSProp,n.sgd=n.SGD,t in n)return n[t]();throw new o(`Unknown Optimizer ${t}`)}(t.optimizer),this.isOptimizerOwned=!0;else{if(!(t.optimizer instanceof e.Optimizer))throw new o("User-defined optimizer must be an instance of tf.Optimizer.");this.optimizer_=t.optimizer,this.isOptimizerOwned=!1}let n=[];if(Array.isArray(t.loss)||"string"==typeof t.loss||"function"==typeof t.loss)if(Array.isArray(t.loss)){if(t.loss.length!==this.outputs.length)throw new o(`When passing an Array as loss, it should have one entry per model output. The model has ${this.outputs.length} output(s), but you passed loss=${t.loss}.`);const e=t.loss;n=e.map((t=>lh(t)))}else{const e=lh(t.loss);this.outputs.forEach((t=>{n.push(e)}))}else{t.loss=t.loss;for(const e in t.loss)if(-1===this.outputNames.indexOf(e))throw new o(`Unknown entry in loss dictionary: "${e}". Only expected the following keys: ${this.outputNames}`);for(const e of this.outputNames)null==t.loss[e]&&console.warn(`Output "${e}" is missing from loss dictionary. We assume this was done on purpose, and we will not be expecting data to be passed to ${e} during training`),n.push(lh(t.loss[e]))}this.lossFunctions=n,this.feedOutputNames=[],this.feedOutputShapes=[],this.feedLossFns=[];for(let t=0;t<this.outputs.length;++t){const e=this.internalOutputShapes[t],n=this.outputNames[t];this.feedOutputNames.push(n),this.feedOutputShapes.push(e),this.feedLossFns.push(this.lossFunctions[t])}const s=[];this.metrics=t.metrics,this.metricsNames=["loss"],this.metricsTensors=[],K("loss",(()=>{for(let t=0;t<this.outputs.length;++t){if(-1!==s.indexOf(t))continue;const e=this.lossFunctions[t];this.outputs.length>1&&(this.metricsTensors.push([e,t]),this.metricsNames.push(this.outputNames[t]+"_loss"))}}));const r=function(t,e){if(null==t||Array.isArray(t)&&0===t.length)return e.map((t=>[]));let n;if("string"==typeof t||"function"==typeof t)n=[t];else{if(!Array.isArray(t)&&"object"!=typeof t)throw new TypeError(`Type of metrics argument not understood. Expected an string,function, Array, or Object, found: ${t}`);n=t}if(Array.isArray(n))return e.map((t=>n));{const t=[];for(const s of e){let e=n.hasOwnProperty(s)?n[s]:[];Array.isArray(e)||(e=[e]),t.push(e)}return t}}(t.metrics,this.outputNames),i=(t,e,n)=>{this.outputNames.length>1&&(e=this.outputNames[t]+"_"+e),this.metricsNames.push(e),this.metricsTensors.push([n,t])};K("metric",(()=>{for(let t=0;t<this.outputs.length;++t){if(-1!==s.indexOf(t))continue;(e=>{let n,s,r;for(const a of e){if("string"==typeof a&&-1!==["accuracy","acc","crossentropy","ce"].indexOf(a)){const e=this.internalOutputShapes[t];let i;1===e[e.length-1]||this.lossFunctions[t]===ih?-1!==["accuracy","acc"].indexOf(a)?s=uh:-1!==["crossentropy","ce"].indexOf(a)&&(s=fh):this.lossFunctions[t]===rh?-1!==["accuracy","acc"].indexOf(a)?s=gh:-1!==["crossentropy","ce"].indexOf(a)&&(s=bh):-1!==["accuracy","acc"].indexOf(a)?s=hh:-1!==["crossentropy","ce"].indexOf(a)&&(s=mh),-1!==["accuracy","acc"].indexOf(a)?i="acc":-1!==["crossentropy","ce"].indexOf(a)&&(i="ce"),r=s,n=""+i}else{const t=wh(a);r=t,n=""+kh(a)}let e;K(n,(()=>{e=r})),i(t,n,e)}})(r[t])}})),this.collectedTrainableWeights=this.trainableWeights}checkTrainableWeightsConsistency(){null!=this.collectedTrainableWeights&&this.trainableWeights.length!==this.collectedTrainableWeights.length&&console.warn("Discrepancy between trainableweights and collected trainable weights. Did you set `model.trainable` without calling `model.compile()` afterwards?")}evaluate(t,e,n={}){const s=null==n.batchSize?32:n.batchSize;Ph(s);const r=this.standardizeUserDataXY(t,e,!0,s);try{const i=r[0].concat(r[1]);this.makeTestFunction();const a=this.testFunction;return f(this.testLoop(a,i,s,n.verbose,n.steps))}finally{qh(r[0],t),qh(r[1],e)}}async evaluateDataset(t,n){return this.makeTestFunction(),async function(t,n,s){const i=null!=(s=s||{}).batches,a=t.testFunction;let o=[];if(s.verbose>0)throw new l("Verbose mode is not implemented yet.");r.util.assert(!i||s.batches>0&&Number.isInteger(s.batches),(()=>`Test loop expects \`batches\` to be a positive integer, but received ${JSON.stringify(s.batches)}`));const u="function"==typeof n.next?n:await n.iterator();let h=0,c=0;for(;!i||c<s.batches;){const n=await u.next();if(o=r.tidy((()=>{if(n.value){const{xs:s,ys:i}=Mh(t,n.value),l=s.concat(i),u=r.tidy((()=>a(l)));if(r.dispose(l),0===c)for(let t=0;t<u.length;++t)o.push(e.scalar(0));const p=l[0].shape[0];for(let t=0;t<u.length;++t){const e=u[t],n=o[t];o[t]=r.tidy((()=>r.add(o[t],r.mul(p,e)))),c>0&&r.dispose(n)}r.dispose(u),h+=p,++c}return o})),n.done){i&&console.warn(`Your dataset iterator ran out of data during evaluateDataset(). Interrupting evalution. Make sure that your dataset can generate at least \`batches\` batches (in this case, ${s.batches} batches). You may need to use the repeat() function when building your dataset.`);break}}for(let t=0;t<o.length;++t){const e=o[t];o[t]=r.div(o[t],h),r.dispose(e)}return f(o)}(this,t,n)}checkNumSamples(t,e,n,s="steps"){let r;if(null!=n){if(r=null,null!=e)throw new o(`If ${s} is set, batchSize must be null or undefined.Got batchSize = ${e}`)}else{if(null==t)throw new o(`Either the input data should have a defined shape, or ${s} shoud be specified.`);r=Array.isArray(t)?t[0].shape[0]:t.shape[0]}return r}execute(t,n){if(Array.isArray(n)&&0===n.length)throw new o("`outputs` is an empty Array, which is not allowed.");const s=Array.isArray(n),r=s?n:[n],i=this.retrieveSymbolicTensors(r),a=new se;if(t instanceof e.Tensor&&(t=[t]),Array.isArray(t)){if(t.length!==this.inputs.length)throw new o(`The number of inputs provided (${t.length}) does not match the number of inputs of this model (${this.inputs.length}).`);for(let e=0;e<this.inputs.length;++e)a.add(this.inputs[e],t[e])}else for(const e of this.inputs){const n=t[e.name];if(null==n)throw new o(`No value is provided for the model's input ${e.name}`);a.add(e,n)}const l=ae(i,a);return s?l:l[0]}retrieveSymbolicTensors(t){const e=c(null,t.length);let n=t.length;for(const s of this.layers){const r=Array.isArray(s.output)?s.output:[s.output],i=r.map((t=>t.name));for(let s=0;s<t.length;++s){const a=i.indexOf(t[s]);if(-1!==a&&(e[s]=r[a],n--),0===n)break}if(0===n)break}if(n>0){const n=[];throw e.forEach(((e,s)=>{null==e&&n.push(t[s])})),new o(`Cannot find SymbolicTensors for output name(s): ${JSON.stringify(n)}`)}return e}predictLoop(t,e=32,n=!1){return r.tidy((()=>{const s=this.checkNumSamples(t);if(n)throw new l("Verbose predictLoop() is not implemented yet.");const i=Vh(s,e),a=this.outputs.map((t=>[]));for(let e=0;e<i.length;++e){r.tidy((()=>{const n=i[e][0],s=i[e][1],r=Wh(t,n,s),a=[];if(Array.isArray(r))for(let t=0;t<r.length;++t)a.push({key:this.inputs[t],value:r[t]});else a.push({key:this.inputs[0],value:r});const o=new se(a);return ae(this.outputs,o)})).forEach(((t,e)=>a[e].push(t)))}return f(a.map((t=>r.concat(t,0))))}))}predict(t,e={}){const n=jh(t);Zh(n,this.inputNames,this.feedInputShapes,!1);try{const s=null==e.batchSize?32:e.batchSize;return Ph(s),this.predictLoop(n,s)}finally{qh(n,t)}}predictOnBatch(t){Zh(t,this.inputNames,this.feedInputShapes,!0);const e=(Array.isArray(t)?t[0]:t).shape[0];return this.predictLoop(t,e)}standardizeUserDataXY(t,n,s=!0,r){if(null==this.optimizer_)throw new a("You must compile a model before training/testing. Use LayersModel.compile(modelCompileArgs).");const i=[];for(let t=0;t<this.feedOutputShapes.length;++t){const e=this.feedOutputShapes[t];this.feedLossFns[t]===rh?i.push(e.slice(0,e.length-1).concat([1])):i.push(e)}if(function(t,n,s){const r=S(t.map((t=>t.shape[0])));r.sort();const i=S(n.map((t=>t.shape[0])));if(i.sort(),r.length>1)throw new o(`All input Tensors (x) should have the same number of samples. Got array shapes: ${JSON.stringify(t.map((t=>t.shape)))}`);if(i.length>1)throw new o(`All target Tensors (y) should have the same number of samples. Got array shapes: ${JSON.stringify(n.map((t=>t.shape)))}`);if(r.length>0&&i.length>0&&!e.util.arraysEqual(r,i))throw new o(`Input Tensors should have the same number of samples as target Tensors. Found ${r[0]} input sample(s) and ${i[0]} target sample(s).`)}(t=Jh(t,this.feedInputNames,this.feedInputShapes,!1,"input"),n=Jh(n,this.feedOutputNames,i,!1,"target")),function(t,e,n){const s=[th,ih,sh];for(let r=0;r<t.length;++r){const i=t[r],a=e[r],l=n[r];if(null!=a){if(a===sh&&1===i.shape[i.shape.length-1])throw new o(`You are passing a target array of shape ${i.shape} while using a loss 'categorical_crossentropy'. 'categorical_crossentropy'expects targets to be binary matrices (1s and 0s) of shape [samples, classes].`);if(-1!==s.indexOf(a)){const t=i.shape.slice(1),e=l.slice(1);for(let n=0;n<t.length;++n){const s=t[n],r=e[n];if(null!=r&&s!==r)throw new o(`A target Tensor with shape ${i.shape} was passed for an output of shape ${l}, while using a loss function that expects targets to have the same shape as the output.`)}}}}}(n,this.feedLossFns,this.feedOutputShapes),this.stateful&&null!=r&&r>0&&t[0].shape[0]%r!=0)throw new o(`In a stateful network, you should only pass inputs with a number of samples that is divisible by the batch size ${r}. Found: ${t[0].shape[0]} sample(s).`);return[t,n]}async standardizeUserData(t,e,n,s,r=!0,i){const[a,o]=this.standardizeUserDataXY(t,e,r,i);if(null!=n)throw new Error("sample weight is not supported yet.");let l=null;if(null!=s){const t=Dh(s,this.outputNames);l=[];for(let e=0;e<t.length;++e)l.push(await Fh(o[e],null,t[e]))}return[a,o,l]}testLoop(t,n,s,i=0,a){return r.tidy((()=>{const o=this.checkNumSamples(n,s,a,"steps"),u=[];if(i>0)throw new l("Verbose mode is not implemented yet.");if(null!=a)throw new l("steps mode in testLoop() is not implemented yet");{const i=Vh(o,s),a=e.tensor1d(X(0,o));for(let s=0;s<i.length;++s){const o=i[s][0],l=i[s][1],h=st(a,o,l-o),c=Uh(n,h),p=t(c);if(0===s)for(let t=0;t<p.length;++t)u.push(e.scalar(0));for(let t=0;t<p.length;++t){const e=p[t];u[t]=r.add(u[t],r.mul(l-o,e))}}for(let t=0;t<u.length;++t)u[t]=r.div(u[t],o)}return u}))}getDedupedMetricsNames(){const t=this.metricsNames,e=[];for(let n=0;n<t.length;++n){const s=t[n];let r=s;if(d(t,s)>1){r+=`_${d(t.slice(0,n),s)}`}e.push(r)}return e}makeTrainFunction(){return t=>{const e=[],n=t.slice(0,this.inputs.length),s=t.slice(this.inputs.length,this.inputs.length+this.outputs.length),i=t.slice(this.inputs.length+this.outputs.length,this.inputs.length+2*this.outputs.length),a=[],o=this.collectedTrainableWeights.map((t=>t.read()));return[this.optimizer_.minimize((()=>{const t=[];for(let e=0;e<this.inputs.length;++e)t.push({key:this.inputs[e],value:n[e]});const o=new se(t),l=ae(this.outputs,o,{training:!0});let u;for(let t=0;t<this.lossFunctions.length;++t){let n=(0,this.lossFunctions[t])(s[t],l[t]);null!=i[t]&&(n=Rh(n,i[t]));const a=r.mean(n);e.push(a),u=0===t?n:r.add(u,n)}for(let t=0;t<this.metricsTensors.length;++t){let n;if(this.outputs.length>1&&t<this.outputs.length)n=e[t];else{const e=this.metricsTensors[t][0],i=this.metricsTensors[t][1];n=r.mean(e(s[i],l[i]))}r.keep(n),a.push(n)}return u=r.mean(u),this.calculateLosses().forEach((t=>{u=r.add(u,t)})),u}),!0,o)].concat(a)}}makeTestFunction(){this.testFunction=t=>r.tidy((()=>{const e=[];let n;const s=t.slice(0,this.inputs.length),i=t.slice(this.inputs.length,this.inputs.length+this.outputs.length),a=[];for(let t=0;t<this.inputs.length;++t)a.push({key:this.inputs[t],value:s[t]});const o=new se(a),l=ae(this.outputs,o);for(let t=0;t<this.lossFunctions.length;++t){const s=this.lossFunctions[t],a=r.mean(s(i[t],l[t]));n=0===t?a:r.add(n,a),e.push(n)}for(let t=0;t<this.metricsTensors.length;++t){const n=this.metricsTensors[t][0],s=this.metricsTensors[t][1],a=r.mean(n(i[s],l[s]));e.push(a)}return e}))}async fit(t,e,n={}){return Kh(this,t,e,n)}async fitDataset(t,e){return Oh(this,t,e)}async trainOnBatch(t,e){const n=await this.standardizeUserData(t,e),s=n[0],i=n[1],a=this.makeTrainFunction()(s.concat(i)),o=[];for(const t of a){const e=await t.data();o.push(e[0])}return r.dispose(a),qh(n[0],t),qh(n[1],e),f(o)}getNamedWeights(t){const e=[],n=null!=t&&t.trainableOnly,s=n?this.trainableWeights:this.weights,r=this.getWeights(n);for(let t=0;t<s.length;++t)n&&!s[t].trainable||e.push({name:s[t].originalName,tensor:r[t]});return e}set stopTraining(t){this.stopTraining_=t}get stopTraining(){return this.stopTraining_}get optimizer(){return this.optimizer_}set optimizer(t){this.optimizer_!==t&&(this.optimizer_=t,this.isOptimizerOwned=!1)}dispose(){const t=super.dispose();if(0===t.refCountAfterDispose&&null!=this.optimizer&&this.isOptimizerOwned){const e=r.memory().numTensors;this.optimizer_.dispose(),t.numDisposedVariables+=e-r.memory().numTensors}return t}getLossIdentifiers(){let t;if("string"==typeof this.loss)t=m(this.loss);else if(Array.isArray(this.loss)){for(const t of this.loss)if("string"!=typeof t)throw new Error("Serialization of non-string loss is not supported.");t=this.loss.map((t=>m(t)))}else{const e=Object.keys(this.loss);t={};const n=this.loss;for(const s of e){if("string"!=typeof n[s])throw new Error("Serialization of non-string loss is not supported.");t[s]=m(n[s])}}return t}getMetricIdentifiers(){if("string"==typeof this.metrics||"function"==typeof this.metrics)return[m(kh(this.metrics))];if(Array.isArray(this.metrics))return this.metrics.map((t=>m(kh(t))));{const t={};for(const e in this.metrics)t[e]=m(kh(this.metrics[e]));return t}}getTrainingConfig(){return{loss:this.getLossIdentifiers(),metrics:this.getMetricIdentifiers(),optimizer_config:{class_name:this.optimizer.getClassName(),config:this.optimizer.getConfig()}}}loadTrainingConfig(t){if(null!=t.weighted_metrics)throw new Error("Loading weight_metrics is not supported yet.");if(null!=t.loss_weights)throw new Error("Loading loss_weights is not supported yet.");if(null!=t.sample_weight_mode)throw new Error("Loading sample_weight_mode is not supported yet.");const e=Xu(zh(t.optimizer_config));let n,s;if("string"==typeof t.loss)n=b(t.loss);else if(Array.isArray(t.loss))n=t.loss.map((t=>b(t)));else if(null!=t.loss){n={};for(const e in t.loss)n[e]=b(t.loss[e])}if(Array.isArray(t.metrics))s=t.metrics.map((t=>b(t)));else if(null!=t.metrics){s={};for(const e in t.metrics)s[e]=b(t.metrics[e])}this.compile({loss:n,metrics:s,optimizer:e})}async save(t,n){if("string"==typeof t){const n=e.io.getSaveHandlers(t);if(0===n.length)throw new o(`Cannot find any save handlers for URL '${t}'`);if(n.length>1)throw new o(`Found more than one (${n.length}) save handlers for URL '${t}'`);t=n[0]}if(null==t.save)throw new o("LayersModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");const s=await e.io.encodeWeights(this.getNamedWeights(n)),r={modelTopology:this.toJSON(null,!1),format:"layers-model",generatedBy:"TensorFlow.js tfjs-layers v4.0.0",convertedBy:null};if(null!=n&&n.includeOptimizer&&null!=this.optimizer){r.trainingConfig=this.getTrainingConfig();const t="optimizer",{data:n,specs:i}=await e.io.encodeWeights(await this.optimizer.getWeights(),t);s.specs.push(...i),s.data=e.io.concatenateArrayBuffers([s.data,n])}if(null!=this.userDefinedMetadata){const t=!0;xh(this.userDefinedMetadata,this.name,t),r.userDefinedMetadata=this.userDefinedMetadata}return r.weightData=s.data,r.weightSpecs=s.specs,t.save(r)}setUserDefinedMetadata(t){xh(t,this.name),this.userDefinedMetadata=t}getUserDefinedMetadata(){return this.userDefinedMetadata}}Yh.className="Model",e.serialization.registerClass(Yh);class Xh extends Yh{}Xh.className="Functional",e.serialization.registerClass(Xh);class Qh extends Yh{constructor(t){if(super({inputs:[],outputs:[]}),t=t||{},this.trainable=!0,this.built=!1,this.name=null!=t.name?t.name:D("sequential_"),null!=t.layers)for(const e of t.layers)this.add(e)}checkShape(t){if(t.inboundNodes[0].outputTensors[0].shape.some((t=>t<0)))throw new o(`Negative dimension size caused by adding layer ${t.name} with input shape [${t.inboundNodes[0].inputTensors[0].shape}]`)}add(t){const e=t instanceof Qh||t instanceof Yh;let n;if(e){if(n=t,1!==n.outputs.length)throw new o("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");if(1!==n.inputs.length)throw new o("All layers in a Sequential model should have a single input tensor. For multi-input layers, use the functional API.")}if(0===this.outputs.length){if(0===t.inboundNodes.length){if(null==t.batchInputShape)throw new o("The first layer in a Sequential model must get an `inputShape` or `batchInputShape` argument.");const e=ne({batchShape:t.batchInputShape,dtype:t.dtype,name:t.name+"_input"});t.apply(e)}if(e)this.outputs=n.outputs,this.inputs=n.inputs;else{if(1!==t.inboundNodes.length)throw new o(`A layer added to a Sequential model must not already be connected somewhere else. LayersModel received layer ${t.name} which has ${t.inboundNodes.length} pre-existing inbound connections.`);if(1!==t.inboundNodes[0].outputTensors.length)throw new o("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(t),this.outputs=[t.inboundNodes[0].outputTensors[0]],this.inputs=te(this.outputs[0])}this.inboundNodes=[],new Yt({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:c(null,this.inputs.length),outputMasks:[null],inputShapes:this.inputs.map((t=>t.shape)),outputShapes:this.outputs[0].shape})}else{const e=t.apply(this.outputs[0]);if(Array.isArray(e))throw new TypeError("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(t),this.outputs=[e],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}this.layers.push(t),this.built=!1}pop(){if(0===this.layers.length)throw new TypeError("There are no layers in the model.");if(this.layers.pop(),0===this.layers.length)this.outputs=[],this.inboundNodes=[],this.outboundNodes=[];else{const t=this.layers.length-1;this.layers[t].outboundNodes=[],this.outputs=[this.layers[t].output],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}}call(t,e){return null==this.model&&this.build(),this.model.call(t,e)}build(t){if(Ut(t),0===this.inputs.length||0===this.outputs.length)throw new TypeError("Sequential model cannot be built: model is empty. Add some layers first.");this.model=new Yh({inputs:this.inputs,outputs:this.outputs[0],name:this.name+"_model"}),this.model.trainable=this.trainable,this.supportsMasking=this.model.supportsMasking,this.inputLayers=this.model.inputLayers,this.inputLayersNodeIndices=this.model.inputLayersNodeIndices,this.inputLayersTensorIndices=this.model.inputLayersTensorIndices,this.outputLayers=this.model.outputLayers,this.outputLayersNodeIndices=this.model.outputLayersNodeIndices,this.outputLayersTensorIndices=this.model.outputLayersTensorIndices,this.nodesByDepth=this.model.nodesByDepth,this.containerNodes=this.model.containerNodes,this.outputNames=this.model.outputNames,this.inputNames=this.model.inputNames,this.built=!0}countParams(){return this.built||this.build(),super.countParams()}summary(t,e,n=console.log){this.built||this.build(),super.summary(t,e,n)}setWeights(t){null==this.model&&this.build(),this.model.setWeights(t)}evaluate(t,e,n={}){if(!this.built)throw new a("The model needs to be compiled before being used.");return this.model.evaluate(t,e,n)}async evaluateDataset(t,e){if(!this.built)throw new a("The model needs to be compiled before being used.");return this.model.evaluateDataset(t,e)}predict(t,e={}){return null==this.model&&this.build(),this.model.predict(t,e)}predictOnBatch(t){return null==this.model&&this.build(),this.model.predictOnBatch(t)}compile(t){this.build(),this.model.compile(t),this.optimizer_=this.model.optimizer,this.isOptimizerOwned=this.model.isOptimizerOwned,this.loss=this.model.loss,this.metrics=this.model.metrics,this.metricsTensors=this.model.metricsTensors,this.metricsNames=this.model.metricsNames}get optimizer(){return null==this.model?void 0:this.model.optimizer}set optimizer(t){this.model.optimizer=t}async fit(t,e,n={}){if(!this.built)throw new a("The model needs to be compiled before being used.");return this.model.fit(t,e,n)}async fitDataset(t,e){if(!this.built)throw new a("The model needs to be compiled before being used.");return this.model.fitDataset(t,e)}async trainOnBatch(t,e){return this.model.trainOnBatch(t,e)}static fromConfig(t,n,s={},r=!1){let i,a={};if(n instanceof Array){if(null==n[0].className||"Merge"===n[0].className)throw new o("Legacy serialization format not supported yet.");i=n}else e.util.assert(null!=n.layers,(()=>"When the config data for a Sequential model is not an Array, it must be an Object that contains the 'layers' field.")),i=n.layers,delete n.layers,a=n;const u=new t(a);if(!(u instanceof Qh))throw new l(`Sequential.fromConfig called on non-Sequential input: ${u}`);for(const t of i){const e=Xu(t,void 0,r);r&&e.setFastWeightInitDuringBuild(!0),u.add(e)}return u}set stopTraining(t){if(null==this.model)throw new o("Cannot set the stopTraining property of a sequential model before it is compiled.");this.model.stopTraining=t}get stopTraining(){if(null==this.model)throw new o("Cannot get the stopTraining property of a sequential model before it is compiled.");return this.model.stopTraining}getConfig(){const t=[];for(const e of this.layers){const n={};n.className=e.getClassName(),n.config=e.getConfig(),t.push(n)}return{name:this.name,layers:t}}}function tc(t){return ne(t)}Qh.className="Sequential",e.serialization.registerClass(Qh);class ec extends e.serialization.Serializable{getConfig(){return{}}}class nc extends ec{apply(t,e=1){return function(t,e=1){if(1!==e)throw new l(`Support for alpha values other than 1 (${e}) is not implemented yet.`);return r.elu(t)}(t,e)}}nc.className="elu",e.serialization.registerClass(nc);class sc extends ec{apply(t){return r.selu(t)}}sc.className="selu",e.serialization.registerClass(sc);class rc extends ec{apply(t){return r.relu(t)}}rc.className="relu",e.serialization.registerClass(rc);class ic extends ec{apply(t){return e.tidy((()=>r.minimum(6,r.relu(t))))}}ic.className="relu6",e.serialization.registerClass(ic);class ac extends ec{apply(t){return t}}ac.className="linear",e.serialization.registerClass(ac);class oc extends ec{apply(t){return r.sigmoid(t)}}oc.className="sigmoid",e.serialization.registerClass(oc);class lc extends ec{apply(t){return function(t){return e.tidy((()=>{const e=r.add(.5,r.mul(.2,t));return r.clipByValue(e,0,1)}))}(t)}}lc.className="hardSigmoid",e.serialization.registerClass(lc);class uc extends ec{apply(t){return r.softplus(t)}}uc.className="softplus",e.serialization.registerClass(uc);class hc extends ec{apply(t){return function(t){return e.tidy((()=>r.div(t,r.add(r.abs(t),1))))}(t)}}hc.className="softsign",e.serialization.registerClass(hc);class cc extends ec{apply(t){return r.tanh(t)}}cc.className="tanh",e.serialization.registerClass(cc);class pc extends ec{apply(t,e=-1){return r.softmax(t,e)}}pc.className="softmax",e.serialization.registerClass(pc);class dc extends ec{apply(t,e=-1){return r.logSoftmax(t,e)}}dc.className="logSoftmax",e.serialization.registerClass(dc);class fc extends ec{apply(t,n=1){return e.tidy((()=>r.mul(r.sigmoid(r.mul(t,n)),t)))}}fc.className="swish",e.serialization.registerClass(fc);class gc extends ec{apply(t){return e.tidy((()=>r.mul(t,r.tanh(r.softplus(t)))))}}function mc(t){return t.getClassName()}function bc(t,n={}){return v(t,e.serialization.SerializationMap.getMap().classNameMap,n,"activation")}function yc(t){if(null==t){const t={className:"linear",config:{}};return bc(t)}if("string"==typeof t){const e={};return e.className=t,e.config={},bc(e)}return t instanceof ec?t:bc(t)}function wc(t){if(null!=t&&"object"!=typeof t)throw new Error(`Argument to L1L2 regularizer's constructor is expected to be an object, but received: ${t}`)}gc.className="mish",e.serialization.registerClass(gc);class kc extends e.serialization.Serializable{}class vc extends kc{constructor(t){super(),wc(t),this.l1=null==t||null==t.l1?.01:t.l1,this.l2=null==t||null==t.l2?.01:t.l2,this.hasL1=0!==this.l1,this.hasL2=0!==this.l2}apply(t){return e.tidy((()=>{let n=e.zeros([1]);return this.hasL1&&(n=e.add(n,e.sum(r.mul(this.l1,e.abs(t))))),this.hasL2&&(n=e.add(n,e.sum(r.mul(this.l2,pt(t))))),r.reshape(n,[])}))}getConfig(){return{l1:this.l1,l2:this.l2}}static fromConfig(t,e){return new t({l1:e.l1,l2:e.l2})}}vc.className="L1L2",e.serialization.registerClass(vc);const xc={l1l2:"L1L2"};function Sc(t){return w(t)}function Nc(t,n={}){return v(t,e.serialization.SerializationMap.getMap().classNameMap,n,"regularizer")}function Ec(t){if(null==t)return null;if("string"==typeof t){return Nc({className:t in xc?xc[t]:t,config:{}})}return t instanceof kc?t:Nc(t)}class Ic extends Qt{constructor(t){super(null==t?{}:t),this.supportsMasking=!0,null!=t&&(this.maxValue=t.maxValue)}call(t,n){t=Wt(t);let s=e.relu(t);return null!=this.maxValue&&(s=e.clipByValue(s,0,this.maxValue)),s}computeOutputShape(t){return t}getConfig(){const t={maxValue:this.maxValue},e=super.getConfig();return Object.assign(t,e),t}}Ic.className="ReLU",e.serialization.registerClass(Ic);class Ac extends Qt{constructor(t){super(null==t?{}:t),this.DEFAULT_ALPHA=.3,null==t&&(t={}),this.alpha=null==t.alpha?this.DEFAULT_ALPHA:t.alpha}call(t,n){const s=Wt(t);return e.leakyRelu(s,this.alpha)}computeOutputShape(t){return t}getConfig(){const t={alpha:this.alpha},e=super.getConfig();return Object.assign(t,e),t}}Ac.className="LeakyReLU",e.serialization.registerClass(Ac);class Tc extends Qt{constructor(t){if(super(null==t?{}:t),this.DEFAULT_ALPHA_INITIALIZER="zeros",null==t&&(t={}),this.supportsMasking=!0,this.alphaInitializer=Ot(t.alphaInitializer||this.DEFAULT_ALPHA_INITIALIZER),this.alphaRegularizer=Ec(t.alphaRegularizer),this.alphaConstraint=Ou(t.alphaConstraint),null==t.sharedAxes)this.sharedAxes=null;else if(Array.isArray(t.sharedAxes))this.sharedAxes=t.sharedAxes;else{if("number"!=typeof t.sharedAxes)throw new o(`Expected sharedAxes to be a number or an array of numbers, but got ${t.sharedAxes}`);this.sharedAxes=[t.sharedAxes]}}build(t){const e=(t=Ut(t)).slice(1);if(null!=this.sharedAxes)for(const t of this.sharedAxes)e[t-1]=1;this.alpha=this.addWeight("alpha",e,"float32",this.alphaInitializer,this.alphaRegularizer,!0,this.alphaConstraint);const n={};if(null!=this.sharedAxes)for(let e=1;e<t.length;++e)n[e]=t[e];this.inputSpec=[new Ht({ndim:t.length,axes:n})],this.built=!0}call(t,n){return t=Wt(t),e.prelu(t,this.alpha.read())}getConfig(){const t={alphaInitializer:Lt(this.alphaInitializer),alphaRegularizer:Sc(this.alphaRegularizer),alphaConstraint:Mu(this.alphaConstraint),sharedAxes:this.sharedAxes},e=super.getConfig();return Object.assign(t,e),t}}Tc.className="PReLU",e.serialization.registerClass(Tc);class zc extends Qt{constructor(t){if(super(null==t?{}:t),this.DEFAULT_ALPHA=1,null==t&&(t={}),null!=t.alpha&&t.alpha!==this.DEFAULT_ALPHA)throw new l(`Non-default alpha value (${t.alpha}) is not supported by the ELU layer yet.`);this.alpha=null==t.alpha?this.DEFAULT_ALPHA:t.alpha}call(t,n){const s=Wt(t);return e.elu(s)}computeOutputShape(t){return t}getConfig(){const t={alpha:this.alpha},e=super.getConfig();return Object.assign(t,e),t}}zc.className="ELU",e.serialization.registerClass(zc);class $c extends Qt{constructor(t){super(null==t?{}:t),this.DEFAULT_THETA=1,null==t&&(t={}),this.theta=null==t.theta?this.DEFAULT_THETA:t.theta}call(t,n){const s=Wt(t);return e.mul(s,e.cast(e.greater(s,this.theta),"float32"))}computeOutputShape(t){return t}getConfig(){const t={theta:this.theta},e=super.getConfig();return Object.assign(t,e),t}}$c.className="ThresholdedReLU",e.serialization.registerClass($c);class Cc extends Qt{constructor(t){super(null==t?{}:t),this.DEFAULT_AXIS=1,null==t&&(t={}),this.softmax=(new pc).apply,this.axis=null==t.axis?this.DEFAULT_AXIS:t.axis}call(t,e){const n=Wt(t);return this.softmax(n,this.axis)}computeOutputShape(t){return t}getConfig(){const t={axis:this.axis},e=super.getConfig();return Object.assign(t,e),t}}function _c(t,e,n){if("number"==typeof t)return c(t,e);if(t.length!==e)throw new o(`The ${n} argument must be an integer or tuple of ${e} integers. Received: ${t.length} elements.`);for(let r=0;r<e;++r){const i=t[r];if((s=i)!==parseInt(s.toString(),10))throw new o(`The ${n} argument must be an integer or tuple of ${e} integers. Received: ${JSON.stringify(t)} including a non-integer number ${i}`)}return t;var s}function Dc(t,e,n,s,r=1){if(null==t)return t;let i;return i="same"===n?t:t-(e+(e-1)*(r-1))+1,Math.floor((i+s-1)/s)}function Fc(t,e,n,s){if(null==t)return null;if("valid"===s)t=t*e+Y([n-e,0]);else{if("same"!==s)throw new o(`Unsupport padding mode: ${s}.`);t*=e}return t}function Rc(t,n){return e.tidy((()=>(P(n),"channelsFirst"===n?r.transpose(t,[0,2,3,1]):t)))}function Mc(t,n){return e.tidy((()=>(P(n),"channelsFirst"===n?r.transpose(t,[0,2,3,4,1]):t)))}function Lc(t,n,s,i=[1,1],a="valid",u,h,c=null){return e.tidy((()=>{if(null==u&&(u="channelsLast"),P(u),3!==t.rank&&4!==t.rank)throw new o(`conv2dWithBiasActivation expects input to be of rank 3 or 4, but received ${t.rank}.`);if(3!==n.rank&&4!==n.rank)throw new o(`conv2dWithBiasActivation expects kernel to be of rank 3 or 4, but received ${t.rank}.`);let e=Rc(t,u);if("causal"===a)throw new l("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");return e=r.fused.conv2d({x:e,filter:n,strides:i,pad:"same"===a?"same":"valid",dilations:h,dataFormat:"NHWC",bias:s,activation:c}),"channelsFirst"===u&&(e=r.transpose(e,[0,3,1,2])),e}))}Cc.className="Softmax",e.serialization.registerClass(Cc);class Oc extends Qt{constructor(t,e){if(super(e),this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",Oc.verifyArgs(e),this.rank=t,A(this.rank,"rank"),1!==this.rank&&2!==this.rank&&3!==this.rank)throw new l(`Convolution layer for rank other than 1, 2, or 3 (${this.rank}) is not implemented yet.`);if(this.kernelSize=_c(e.kernelSize,t,"kernelSize"),this.strides=_c(null==e.strides?1:e.strides,t,"strides"),this.padding=null==e.padding?"valid":e.padding,W(this.padding),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,P(this.dataFormat),this.activation=yc(e.activation),this.useBias=null==e.useBias||e.useBias,this.biasInitializer=Ot(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.biasConstraint=Ou(e.biasConstraint),this.biasRegularizer=Ec(e.biasRegularizer),this.activityRegularizer=Ec(e.activityRegularizer),this.dilationRate=_c(null==e.dilationRate?1:e.dilationRate,t,"dilationRate"),1===this.rank&&Array.isArray(this.dilationRate)&&1!==this.dilationRate.length)throw new o(`dilationRate must be a number or an array of a single number for 1D convolution, but received ${JSON.stringify(this.dilationRate)}`);if(2===this.rank){if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate];else if(2!==this.dilationRate.length)throw new o(`dilationRate must be a number or array of two numbers for 2D convolution, but received ${JSON.stringify(this.dilationRate)}`)}else if(3===this.rank)if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate,this.dilationRate];else if(3!==this.dilationRate.length)throw new o(`dilationRate must be a number or array of three numbers for 3D convolution, but received ${JSON.stringify(this.dilationRate)}`)}static verifyArgs(t){if(p("kernelSize"in t,"required key 'kernelSize' not in config"),"number"!=typeof t.kernelSize&&!I(t.kernelSize,"number",1,3))throw new o(`BaseConv expects config.kernelSize to be number or number[] with length 1, 2, or 3, but received ${JSON.stringify(t.kernelSize)}.`)}getConfig(){const t={kernelSize:this.kernelSize,strides:this.strides,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,activation:mc(this.activation),useBias:this.useBias,biasInitializer:Lt(this.biasInitializer),biasRegularizer:Sc(this.biasRegularizer),activityRegularizer:Sc(this.activityRegularizer),biasConstraint:Mu(this.biasConstraint)},e=super.getConfig();return Object.assign(t,e),t}}class Bc extends Oc{constructor(t,e){super(t,e),this.kernel=null,Bc.verifyArgs(e),this.filters=e.filters,A(this.filters,"filters"),this.kernelInitializer=Ot(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.kernelConstraint=Ou(e.kernelConstraint),this.kernelRegularizer=Ec(e.kernelRegularizer)}build(t){t=Ut(t);const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new o(`The channel dimension of the input should be defined. Found ${t[e]}`);const n=t[e],s=this.kernelSize.concat([n,this.filters]);this.kernel=this.addWeight("kernel",s,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[{ndim:this.rank+2,axes:{[e]:n}}],this.built=!0}call(t,n){return e.tidy((()=>{let n;t=Wt(t);const s=null==this.bias?null:this.bias.read(),i=z(this.activation.getClassName());if(null!=i&&2===this.rank)n=Lc(t,this.kernel.read(),s,this.strides,this.padding,this.dataFormat,this.dilationRate,i);else{if(1===this.rank)n=function(t,n,s,i=1,a="valid",u,h=1){return e.tidy((()=>{if(null==u&&(u="channelsLast"),P(u),3!==t.shape.length)throw new o(`The input of a conv1dWithBias operation should be 3, but is ${t.shape.length} instead.`);if(3!==n.shape.length)throw new o(`The kernel for a conv1dWithBias operation should be 3, but is ${n.shape.length} instead`);if(null!=s&&1!==s.shape.length)throw new o(`The bias for a conv1dWithBias operation should be 1, but is ${n.shape.length} instead`);if("channelsFirst"===u&&(t=r.transpose(t,[0,2,1])),"causal"===a)throw new l("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");let e=r.conv1d(t,n,i,"same"===a?"same":"valid","NWC",h);return null!=s&&(e=ft(e,s)),e}))}(t,this.kernel.read(),s,this.strides[0],this.padding,this.dataFormat,this.dilationRate[0]);else if(2===this.rank)n=Lc(t,this.kernel.read(),s,this.strides,this.padding,this.dataFormat,this.dilationRate);else{if(3!==this.rank)throw new l("convolutions greater than 3D are not implemented yet.");n=function(t,n,s,i=[1,1,1],a="valid",u,h){return e.tidy((()=>{if(null==u&&(u="channelsLast"),P(u),4!==t.rank&&5!==t.rank)throw new o(`conv3dWithBias expects input to be of rank 4 or 5, but received ${t.rank}.`);if(4!==n.rank&&5!==n.rank)throw new o(`conv3dWithBias expects kernel to be of rank 4 or 5, but received ${t.rank}.`);let e=Mc(t,u);if("causal"===a)throw new l("The support for CAUSAL padding mode in conv3dWithBias is not implemented yet.");return e=r.conv3d(e,n,i,"same"===a?"same":"valid","NDHWC",h),null!=s&&(e=ft(e,s)),"channelsFirst"===u&&(e=r.transpose(e,[0,4,1,2,3])),e}))}(t,this.kernel.read(),s,this.strides,this.padding,this.dataFormat,this.dilationRate)}null!=this.activation&&(n=this.activation.apply(n))}return n}))}computeOutputShape(t){t=Ut(t);const e=[],n="channelsLast"===this.dataFormat?t.slice(1,t.length-1):t.slice(2);for(let t=0;t<n.length;++t){const s=Dc(n[t],this.kernelSize[t],this.padding,this.strides[t],"number"==typeof this.dilationRate?this.dilationRate:this.dilationRate[t]);e.push(s)}let s=[t[0]];return"channelsLast"===this.dataFormat?(s=s.concat(e),s.push(this.filters)):(s.push(this.filters),s=s.concat(e)),s}getConfig(){const t={filters:this.filters,kernelInitializer:Lt(this.kernelInitializer),kernelRegularizer:Sc(this.kernelRegularizer),kernelConstraint:Mu(this.kernelConstraint)},e=super.getConfig();return Object.assign(t,e),t}static verifyArgs(t){if(!("filters"in t)||"number"!=typeof t.filters||t.filters<1)throw new o(`Convolution layer expected config.filters to be a 'number' > 0 but got ${JSON.stringify(t.filters)}`)}}class Pc extends Bc{constructor(t){super(2,t),Pc.verifyArgs(t)}getConfig(){const t=super.getConfig();return delete t.rank,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&!I(t.kernelSize,"number",1,2))throw new o(`Conv2D expects config.kernelSize to be number or number[] with length 1 or 2, but received ${JSON.stringify(t.kernelSize)}.`)}}Pc.className="Conv2D",e.serialization.registerClass(Pc);class Wc extends Bc{constructor(t){super(3,t),Wc.verifyArgs(t)}getConfig(){const t=super.getConfig();return delete t.rank,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&(!Array.isArray(t.kernelSize)||1!==t.kernelSize.length&&3!==t.kernelSize.length))throw new o(`Conv3D expects config.kernelSize to be number or [number, number, number], but received ${JSON.stringify(t.kernelSize)}.`)}}Wc.className="Conv3D",e.serialization.registerClass(Wc);class Uc extends Pc{constructor(t){if(super(t),this.inputSpec=[new Ht({ndim:4})],"same"!==this.padding&&"valid"!==this.padding)throw new o(`Conv2DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(t){if(4!==(t=Ut(t)).length)throw new o("Input should have rank 4; Received input shape: "+JSON.stringify(t));const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new o("The channel dimension of the inputs should be defined. Found `None`.");const n=t[e],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new Ht({ndim:4,axes:{[e]:n}})],this.built=!0}call(t,e){return r.tidy((()=>{let e=Wt(t);if(4!==e.shape.length)throw new o(`Conv2DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${e.shape.length}`);const n=e.shape,s=n[0];let i,a;"channelsFirst"===this.dataFormat?(i=2,a=3):(i=1,a=2);const l=n[i],u=n[a],h=this.kernelSize[0],c=this.kernelSize[1],p=this.strides[0],d=this.strides[1],f=[s,Fc(l,p,h,this.padding),Fc(u,d,c,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(e=r.transpose(e,[0,2,3,1]));let g=r.conv2dTranspose(e,this.kernel.read(),f,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(g=r.transpose(g,[0,3,1,2])),null!=this.bias&&(g=ft(g,this.bias.read(),this.dataFormat)),null!=this.activation&&(g=this.activation.apply(g)),g}))}computeOutputShape(t){const e=(t=Ut(t)).slice();let n,s,r;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3):(n=3,s=1,r=2);const i=this.kernelSize[0],a=this.kernelSize[1],o=this.strides[0],l=this.strides[1];return e[n]=this.filters,e[s]=Fc(e[s],o,i,this.padding),e[r]=Fc(e[r],l,a,this.padding),e}getConfig(){const t=super.getConfig();return delete t.dilationRate,t}}Uc.className="Conv2DTranspose",e.serialization.registerClass(Uc);class Vc extends Wc{constructor(t){if(super(t),this.inputSpec=[new Ht({ndim:5})],"same"!==this.padding&&"valid"!==this.padding)throw new o(`Conv3DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(t){if(5!==(t=Ut(t)).length)throw new o("Input should have rank 5; Received input shape: "+JSON.stringify(t));const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new o("The channel dimension of the inputs should be defined. Found `None`.");const n=t[e],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new Ht({ndim:5,axes:{[e]:n}})],this.built=!0}call(t,e){return r.tidy((()=>{let e=Wt(t);if(5!==e.shape.length)throw new o(`Conv3DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${e.shape.length}`);const n=e.shape,s=n[0];let i,a,l;"channelsFirst"===this.dataFormat?(l=2,i=3,a=4):(l=1,i=2,a=3);const u=n[l],h=n[i],c=n[a],p=this.kernelSize[0],d=this.kernelSize[1],f=this.kernelSize[2],g=this.strides[0],m=this.strides[1],b=this.strides[2],y=[s,Fc(u,g,p,this.padding),Fc(h,m,d,this.padding),Fc(c,b,f,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(e=r.transpose(e,[0,2,3,4,1]));let w=r.conv3dTranspose(e,this.kernel.read(),y,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(w=r.transpose(w,[0,4,1,2,3])),null!==this.bias&&(w=ft(w,this.bias.read(),this.dataFormat)),null!==this.activation&&(w=this.activation.apply(w)),w}))}computeOutputShape(t){const e=(t=Ut(t)).slice();let n,s,r,i;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3,i=4):(n=4,s=1,r=2,i=3);const a=this.kernelSize[0],o=this.kernelSize[1],l=this.kernelSize[2],u=this.strides[0],h=this.strides[1],c=this.strides[2];return e[n]=this.filters,e[s]=Fc(e[s],u,a,this.padding),e[r]=Fc(e[r],h,o,this.padding),e[i]=Fc(e[i],c,l,this.padding),e}getConfig(){const t=super.getConfig();return delete t.dilationRate,t}}Vc.className="Conv3DTranspose",e.serialization.registerClass(Vc);class Kc extends Bc{constructor(t,e){if(super(t,e),this.DEFAULT_DEPTHWISE_INITIALIZER="glorotUniform",this.DEFAULT_POINTWISE_INITIALIZER="glorotUniform",this.depthwiseKernel=null,this.pointwiseKernel=null,null==e.filters)throw new o("The `filters` configuration field is required by SeparableConv, but is unspecified.");if(null!=e.kernelInitializer||null!=e.kernelRegularizer||null!=e.kernelConstraint)throw new o("Fields kernelInitializer, kernelRegularizer and kernelConstraint are invalid for SeparableConv2D. Use depthwiseInitializer, depthwiseRegularizer, depthwiseConstraint, pointwiseInitializer, pointwiseRegularizer and pointwiseConstraint instead.");if(null!=e.padding&&"same"!==e.padding&&"valid"!==e.padding)throw new o(`SeparableConv${this.rank}D supports only padding modes: 'same' and 'valid', but received ${JSON.stringify(e.padding)}`);this.depthMultiplier=null==e.depthMultiplier?1:e.depthMultiplier,this.depthwiseInitializer=Ot(e.depthwiseInitializer||this.DEFAULT_DEPTHWISE_INITIALIZER),this.depthwiseRegularizer=Ec(e.depthwiseRegularizer),this.depthwiseConstraint=Ou(e.depthwiseConstraint),this.pointwiseInitializer=Ot(e.depthwiseInitializer||this.DEFAULT_POINTWISE_INITIALIZER),this.pointwiseRegularizer=Ec(e.pointwiseRegularizer),this.pointwiseConstraint=Ou(e.pointwiseConstraint)}build(t){if((t=Ut(t)).length<this.rank+2)throw new o(`Inputs to SeparableConv${this.rank}D should have rank ${this.rank+2}, but received input shape: ${JSON.stringify(t)}`);const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e]||t[e]<0)throw new o(`The channel dimension of the inputs should be defined, but found ${JSON.stringify(t[e])}`);const n=t[e],s=this.kernelSize.concat([n,this.depthMultiplier]),r=[];for(let t=0;t<this.rank;++t)r.push(1);r.push(n*this.depthMultiplier,this.filters);const i=!0;this.depthwiseKernel=this.addWeight("depthwise_kernel",s,"float32",this.depthwiseInitializer,this.depthwiseRegularizer,i,this.depthwiseConstraint),this.pointwiseKernel=this.addWeight("pointwise_kernel",r,"float32",this.pointwiseInitializer,this.pointwiseRegularizer,i,this.pointwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,i,this.biasConstraint):this.bias=null,this.inputSpec=[new Ht({ndim:this.rank+2,axes:{[e]:n}})],this.built=!0}call(t,n){return e.tidy((()=>{let e;if(t=Wt(t),1===this.rank)throw new l("1D separable convolution is not implemented yet.");return 2===this.rank&&("channelsFirst"===this.dataFormat&&(t=r.transpose(t,[0,2,3,1])),e=r.separableConv2d(t,this.depthwiseKernel.read(),this.pointwiseKernel.read(),this.strides,this.padding,this.dilationRate,"NHWC")),this.useBias&&(e=ft(e,this.bias.read(),this.dataFormat)),null!=this.activation&&(e=this.activation.apply(e)),"channelsFirst"===this.dataFormat&&(e=r.transpose(e,[0,3,1,2])),e}))}getConfig(){const t=super.getConfig();return delete t.rank,delete t.kernelInitializer,delete t.kernelRegularizer,delete t.kernelConstraint,t.depthwiseInitializer=Lt(this.depthwiseInitializer),t.pointwiseInitializer=Lt(this.pointwiseInitializer),t.depthwiseRegularizer=Sc(this.depthwiseRegularizer),t.pointwiseRegularizer=Sc(this.pointwiseRegularizer),t.depthwiseConstraint=Mu(this.depthwiseConstraint),t.pointwiseConstraint=Mu(this.pointwiseConstraint),t}}Kc.className="SeparableConv";class jc extends Kc{constructor(t){super(2,t)}}jc.className="SeparableConv2D",e.serialization.registerClass(jc);class qc extends Bc{constructor(t){super(1,t),qc.verifyArgs(t),this.inputSpec=[{ndim:3}]}getConfig(){const t=super.getConfig();return delete t.rank,delete t.dataFormat,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&!I(t.kernelSize,"number",1,1))throw new o(`Conv1D expects config.kernelSize to be number or number[] with length 1, but received ${JSON.stringify(t.kernelSize)}.`)}}qc.className="Conv1D",e.serialization.registerClass(qc);class Gc extends Qt{constructor(t){super(t),"number"==typeof t.cropping?this.cropping=[[t.cropping,t.cropping],[t.cropping,t.cropping]]:"number"==typeof t.cropping[0]?this.cropping=[[t.cropping[0],t.cropping[0]],[t.cropping[1],t.cropping[1]]]:this.cropping=t.cropping,this.dataFormat=void 0===t.dataFormat?"channelsLast":t.dataFormat,this.inputSpec=[{ndim:4}]}computeOutputShape(t){return"channelsFirst"===this.dataFormat?[t[0],t[1],t[2]-this.cropping[0][0]-this.cropping[0][1],t[3]-this.cropping[1][0]-this.cropping[1][1]]:[t[0],t[1]-this.cropping[0][0]-this.cropping[0][1],t[2]-this.cropping[1][0]-this.cropping[1][1],t[3]]}call(t,n){return e.tidy((()=>{if(t=Wt(t),"channelsLast"===this.dataFormat){const e=it(t,this.cropping[0][0],t.shape[1]-this.cropping[0][0]-this.cropping[0][1],2);return it(e,this.cropping[1][0],t.shape[2]-this.cropping[1][1]-this.cropping[1][0],3)}{const e=it(t,this.cropping[0][0],t.shape[2]-this.cropping[0][0]-this.cropping[0][1],3);return it(e,this.cropping[1][0],t.shape[3]-this.cropping[1][1]-this.cropping[1][0],4)}}))}getConfig(){const t={cropping:this.cropping,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}Gc.className="Cropping2D",e.serialization.registerClass(Gc);class Hc extends Qt{constructor(t){var e;super(t),this.DEFAULT_SIZE=[2,2],this.inputSpec=[{ndim:4}],this.size=null==t.size?this.DEFAULT_SIZE:t.size,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,P(this.dataFormat),this.interpolation=null==t.interpolation?"nearest":t.interpolation,e=this.interpolation,E(R,"InterpolationFormat",e)}computeOutputShape(t){if("channelsFirst"===this.dataFormat){const e=null==t[2]?null:this.size[0]*t[2],n=null==t[3]?null:this.size[1]*t[3];return[t[0],t[1],e,n]}{const e=null==t[1]?null:this.size[0]*t[1],n=null==t[2]?null:this.size[1]*t[2];return[t[0],e,n,t[3]]}}call(t,e){return r.tidy((()=>{let e=Wt(t);const n=e.shape;if("channelsFirst"===this.dataFormat){e=r.transpose(e,[0,2,3,1]);const t=this.size[0]*n[2],s=this.size[1]*n[3],i="nearest"===this.interpolation?r.image.resizeNearestNeighbor(e,[t,s]):r.image.resizeBilinear(e,[t,s]);return r.transpose(i,[0,3,1,2])}{const t=this.size[0]*n[1],s=this.size[1]*n[2];return"nearest"===this.interpolation?r.image.resizeNearestNeighbor(e,[t,s]):r.image.resizeBilinear(e,[t,s])}}))}getConfig(){const t={size:this.size,dataFormat:this.dataFormat,interpolation:this.interpolation},e=super.getConfig();return Object.assign(t,e),t}}Hc.className="UpSampling2D",e.serialization.registerClass(Hc);class Jc extends Oc{constructor(t){super(2,t),this.depthwiseKernel=null,this.depthMultiplier=null==t.depthMultiplier?1:t.depthMultiplier,this.depthwiseInitializer=Ot(t.depthwiseInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.depthwiseConstraint=Ou(t.depthwiseConstraint),this.depthwiseRegularizer=Ec(t.depthwiseRegularizer)}build(t){if((t=Ut(t)).length<4)throw new o(`Inputs to DepthwiseConv2D should have rank 4. Received input shape: ${JSON.stringify(t)}.`);const e="channelsFirst"===this.dataFormat?1:3;if(null==t[e]||t[e]<0)throw new o(`The channel dimension of the inputs to DepthwiseConv2D should be defined, but is not (${t[e]}).`);const n=t[e],s=[this.kernelSize[0],this.kernelSize[1],n,this.depthMultiplier];this.depthwiseKernel=this.addWeight("depthwise_kernel",s,null,this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[n*this.depthMultiplier],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(t,n){return e.tidy((()=>{let n=function(t,n,s=[1,1],i="valid",a,l){return e.tidy((()=>{null==a&&(a="channelsLast"),P(a);let e=Rc(t,a);if(4!==t.rank)throw new o(`Input for depthwiseConv2d is required to be 4-D, but is instead ${t.rank}-D`);if(4!==n.rank)throw new o(`depthwiseKernel is required to be 4-D, but is instead ${n.rank}-D`);return e=r.depthwiseConv2d(e,n,s,"same"===i?"same":"valid","NHWC",l),"channelsFirst"===a&&(e=r.transpose(e,[0,3,1,2])),e}))}(t=Wt(t),this.depthwiseKernel.read(),this.strides,this.padding,this.dataFormat,null);return this.useBias&&(n=ft(n,this.bias.read(),this.dataFormat)),null!=this.activation&&(n=this.activation.apply(n)),n}))}computeOutputShape(t){t=Ut(t);const e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2],s="channelsFirst"===this.dataFormat?t[1]*this.depthMultiplier:t[3]*this.depthMultiplier,r=Dc(e,this.kernelSize[0],this.padding,this.strides[0]),i=Dc(n,this.kernelSize[1],this.padding,this.strides[1]);return"channelsFirst"===this.dataFormat?[t[0],s,r,i]:[t[0],r,i,s]}getConfig(){const t=super.getConfig();return t.depthMultiplier=this.depthMultiplier,t.depthwiseInitializer=Lt(this.depthwiseInitializer),t.depthwiseRegularizer=Sc(this.depthwiseRegularizer),t.depthwiseConstraint=Mu(this.depthwiseRegularizer),t}}function Zc(t,e,n,s){if(Array.isArray(t)){if(null!=e||null!=n)throw new o("When inputs is an array, neither initialState or constants should be provided");null!=s&&(n=t.slice(t.length-s,t.length),t=t.slice(0,t.length-s)),t.length>1&&(e=t.slice(1,t.length)),t=t[0]}function r(t){return null==t||Array.isArray(t)?t:[t]}return{inputs:t,initialState:e=r(e),constants:n=r(n)}}function Yc(t,e,n,s=!1,i,a,u=!1,h=!1){return r.tidy((()=>{const c=e.shape.length;if(c<3)throw new o(`Input should be at least 3D, but is ${c}D.`);const p=[1,0].concat(X(2,c));if(e=r.transpose(e,p),null!=a)throw new l("The rnn() functoin of the deeplearn.js backend does not support constants yet.");u&&console.warn("Backend rnn(): the unroll = true option is not applicable to the imperative deeplearn.js backend."),null!=i&&((i=r.cast(r.cast(i,"bool"),"float32")).rank===c-1&&(i=r.expandDims(i,-1)),i=r.transpose(i,p)),s&&(e=r.reverse(e,0),null!=i&&(i=r.reverse(i,0)));const d=[];let f,g=n;const m=e.shape[0],b=r.unstack(e);let y,w;null!=i&&(y=r.unstack(i));for(let e=0;e<m;++e){const n=b[e],s=r.tidy((()=>t(n,g)));if(null==i)f=s[0],g=s[1];else{const t=r.tidy((()=>{const t=y[e],n=r.sub(r.onesLike(t),t);return{output:r.add(r.mul(s[0],t),r.mul(g[0],n)),newStates:g.map(((e,i)=>r.add(r.mul(s[1][i],t),r.mul(e,n))))}}));f=t.output,g=t.newStates}h&&d.push(f)}if(h){const t=1;w=r.stack(d,t)}return[f,w,g]}))}Jc.className="DepthwiseConv2D",e.serialization.registerClass(Jc);class Xc extends Qt{constructor(t){let e;if(super(t),null==t.cell)throw new o("cell property is missing for the constructor of RNN.");if(e=Array.isArray(t.cell)?new ap({cells:t.cell}):t.cell,null==e.stateSize)throw new o("The RNN cell should have an attribute `stateSize` (tuple of integers, one integer per RNN state).");this.cell=e,this.returnSequences=null!=t.returnSequences&&t.returnSequences,this.returnState=null!=t.returnState&&t.returnState,this.goBackwards=null!=t.goBackwards&&t.goBackwards,this._stateful=null!=t.stateful&&t.stateful,this.unroll=null!=t.unroll&&t.unroll,this.supportsMasking=!0,this.inputSpec=[new Ht({ndim:3})],this.stateSpec=null,this.states_=null,this.numConstants=null,this.keptStates=[]}getStates(){if(null==this.states_){return X(0,Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1).map((t=>null))}return this.states_}setStates(t){this.states_=t}computeOutputShape(t){Bt(t)&&(t=t[0]);let e=this.cell.stateSize;Array.isArray(e)||(e=[e]);const n=e[0];let s;if(s=this.returnSequences?[t[0],t[1],n]:[t[0],n],this.returnState){const n=[];for(const s of e)n.push([t[0],s]);return[s].concat(n)}return s}computeMask(t,e){return r.tidy((()=>{Array.isArray(e)&&(e=e[0]);const t=this.returnSequences?e:null;if(this.returnState){const e=this.states.map((t=>null));return[t].concat(e)}return t}))}get states(){if(null==this.states_){const t=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1,e=[];for(let n=0;n<t;++n)e.push(null);return e}return this.states_}set states(t){this.states_=t}build(t){if(null!=this.numConstants)throw new l("Constants support is not implemented in RNN yet.");Bt(t)&&(t=t[0]);const n=this.stateful?t[0]:null,s=t.slice(2);this.inputSpec[0]=new Ht({shape:[n,null,...s]});const r=[t[0]].concat(t.slice(2));let i;if(this.cell.build(r),i=Array.isArray(this.cell.stateSize)?this.cell.stateSize:[this.cell.stateSize],null!=this.stateSpec){if(!e.util.arraysEqual(this.stateSpec.map((t=>t.shape[t.shape.length-1])),i))throw new o(`An initialState was passed that is not compatible with cell.stateSize. Received stateSpec=${this.stateSpec}; However cell.stateSize is ${this.cell.stateSize}`)}else this.stateSpec=i.map((t=>new Ht({shape:[null,t]})));this.stateful&&this.resetStates()}resetStates(t,n=!1){e.tidy((()=>{if(!this.stateful)throw new i("Cannot call resetStates() on an RNN Layer that is not stateful.");const s=this.inputSpec[0].shape[0];if(null==s)throw new o("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.states_)Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((t=>r.zeros([s,t]))):this.states_=[r.zeros([s,this.cell.stateSize])];else if(null==t)r.dispose(this.states_),null!=this.keptStates&&(r.dispose(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((t=>r.zeros([s,t]))):this.states_[0]=r.zeros([s,this.cell.stateSize]);else{if(Array.isArray(t)||(t=[t]),t.length!==this.states_.length)throw new o(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${t.length} state value(s). Input received: ${t}`);!0===n?this.keptStates.push(this.states_.slice()):r.dispose(this.states_);for(let n=0;n<this.states_.length;++n){const r=t[n],i=Array.isArray(this.cell.stateSize)?this.cell.stateSize[n]:this.cell.stateSize,a=[s,i];if(!e.util.arraysEqual(r.shape,a))throw new o(`State ${n} is incompatible with layer ${this.name}: expected shape=${a}, received shape=${r.shape}`);this.states_[n]=r}}this.states_=this.states_.map((t=>r.keep(t.clone())))}))}apply(t,e){let n=null==e?null:e.initialState,s=null==e?null:e.constants;null==e&&(e={});const r=Zc(t,n,s,this.numConstants);t=r.inputs,n=r.initialState,s=r.constants;let i=[],a=[];if(null!=n){e.initialState=n,i=i.concat(n),this.stateSpec=[];for(const t of n)this.stateSpec.push(new Ht({shape:t.shape}));a=a.concat(this.stateSpec)}null!=s&&(e.constants=s,i=i.concat(s),this.numConstants=s.length);if(i[0]instanceof Jt){const n=[t].concat(i),s=this.inputSpec.concat(a),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,e);return this.inputSpec=r,o}return super.apply(t,e)}call(t,n){return e.tidy((()=>{const e=null==n?null:n.mask,s=null==n?null:n.training;let r=null==n?null:n.initialState;t=Wt(t),null==r&&(r=this.stateful?this.states_:this.getInitialState(t));const i=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1;if(r.length!==i)throw new o(`RNN Layer has ${i} state(s) but was passed ${r.length} initial state(s).`);this.unroll&&console.warn("Ignoring unroll = true for RNN layer, due to imperative backend.");const a={training:s},l=Yc(((t,e)=>{const n=this.cell.call([t].concat(e),a);return[n[0],n.slice(1)]}),t,r,this.goBackwards,e,null,this.unroll,this.returnSequences),u=l[0],h=l[1],c=l[2];this.stateful&&this.resetStates(c,s);const p=this.returnSequences?h:u;return this.returnState?[p].concat(c):p}))}getInitialState(t){return e.tidy((()=>{let e=r.zeros(t.shape);return e=r.sum(e,[1,2]),e=nt(e),Array.isArray(this.cell.stateSize)?this.cell.stateSize.map((t=>t>1?lt(e,[1,t]):e)):this.cell.stateSize>1?[lt(e,[1,this.cell.stateSize])]:[e]}))}get trainableWeights(){return this.trainable?this.cell.trainableWeights:[]}get nonTrainableWeights(){return this.trainable?this.cell.nonTrainableWeights:this.cell.weights}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.cell&&this.cell.setFastWeightInitDuringBuild(t)}getConfig(){const t=super.getConfig(),e={returnSequences:this.returnSequences,returnState:this.returnState,goBackwards:this.goBackwards,stateful:this.stateful,unroll:this.unroll};null!=this.numConstants&&(e.numConstants=this.numConstants);const n=this.cell.getConfig();return this.getClassName()===Xc.className&&(e.cell={className:this.cell.getClassName(),config:n}),Object.assign(Object.assign(Object.assign({},n),t),e)}static fromConfig(t,e,n={}){const s=Xu(e.cell,n);return new t(Object.assign(e,{cell:s}))}}Xc.className="RNN",e.serialization.registerClass(Xc);class Qc extends Qt{}class tp extends Qc{constructor(t){super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=t.units,A(this.units,"units"),this.activation=yc(null==t.activation?this.DEFAULT_ACTIVATION:t.activation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=Ot(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Ot(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Ot(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Ec(t.kernelRegularizer),this.recurrentRegularizer=Ec(t.recurrentRegularizer),this.biasRegularizer=Ec(t.biasRegularizer),this.kernelConstraint=Ou(t.kernelConstraint),this.recurrentConstraint=Ou(t.recurrentConstraint),this.biasConstraint=Ou(t.biasConstraint),this.dropout=Z([1,Y([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=Z([1,Y([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.dropoutFunc=t.dropoutFunc,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){t=Ut(t),this.kernel=this.addWeight("kernel",[t[t.length-1],this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(t,n){return e.tidy((()=>{if(2!==t.length)throw new o(`SimpleRNNCell expects 2 input Tensors, got ${t.length}.`);let e=t[1];t=t[0];const s=null!=n.training&&n.training;let i;0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=op({ones:()=>r.onesLike(t),rate:this.dropout,training:s,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=op({ones:()=>r.onesLike(e),rate:this.recurrentDropout,training:s,dropoutFunc:this.dropoutFunc}));const a=this.dropoutMask,l=this.recurrentDropoutMask;i=ht(null!=a?r.mul(t,a):t,this.kernel.read()),null!=this.bias&&(i=ft(i,this.bias.read())),null!=l&&(e=r.mul(e,l));let u=r.add(i,ht(e,this.recurrentKernel.read()));return null!=this.activation&&(u=this.activation.apply(u)),[u,u]}))}getConfig(){const t=super.getConfig(),e={units:this.units,activation:mc(this.activation),useBias:this.useBias,kernelInitializer:Lt(this.kernelInitializer),recurrentInitializer:Lt(this.recurrentInitializer),biasInitializer:Lt(this.biasInitializer),kernelRegularizer:Sc(this.kernelRegularizer),recurrentRegularizer:Sc(this.recurrentRegularizer),biasRegularizer:Sc(this.biasRegularizer),activityRegularizer:Sc(this.activityRegularizer),kernelConstraint:Mu(this.kernelConstraint),recurrentConstraint:Mu(this.recurrentConstraint),biasConstraint:Mu(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout};return Object.assign(Object.assign({},t),e)}}tp.className="SimpleRNNCell",e.serialization.registerClass(tp);class ep extends Xc{constructor(t){t.cell=new tp(t),super(t)}call(t,n){return e.tidy((()=>{null!=this.cell.dropoutMask&&(r.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(r.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const e=null==n?null:n.mask,s=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(t,{mask:e,training:s,initialState:i})}))}static fromConfig(t,e){return new t(e)}}ep.className="SimpleRNN",e.serialization.registerClass(ep);class np extends Qc{constructor(t){if(super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",t.resetAfter)throw new o("GRUCell does not support reset_after parameter set to true.");this.units=t.units,A(this.units,"units"),this.activation=yc(void 0===t.activation?this.DEFAULT_ACTIVATION:t.activation),this.recurrentActivation=yc(void 0===t.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:t.recurrentActivation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=Ot(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Ot(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Ot(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Ec(t.kernelRegularizer),this.recurrentRegularizer=Ec(t.recurrentRegularizer),this.biasRegularizer=Ec(t.biasRegularizer),this.kernelConstraint=Ou(t.kernelConstraint),this.recurrentConstraint=Ou(t.recurrentConstraint),this.biasConstraint=Ou(t.biasConstraint),this.dropout=Z([1,Y([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=Z([1,Y([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.dropoutFunc=t.dropoutFunc,this.implementation=t.implementation,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){const e=(t=Ut(t))[t.length-1];this.kernel=this.addWeight("kernel",[e,3*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,3*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[3*this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(t,n){return e.tidy((()=>{if(2!==t.length)throw new o(`GRUCell expects 2 input Tensors (inputs, h, c), got ${t.length}.`);const e=null!=n.training&&n.training;let s=t[1];t=t[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=op({ones:()=>r.onesLike(t),rate:this.dropout,training:e,count:3,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=op({ones:()=>r.onesLike(s),rate:this.recurrentDropout,training:e,count:3,dropoutFunc:this.dropoutFunc}));const i=this.dropoutMask,a=this.recurrentDropoutMask;let l,u,h;0<this.dropout&&this.dropout<1&&(t=r.mul(t,i[0]));let c=ht(t,this.kernel.read());this.useBias&&(c=ft(c,this.bias.read())),0<this.recurrentDropout&&this.recurrentDropout<1&&(s=r.mul(s,a[0]));const p=this.recurrentKernel.read(),[d,f]=r.split(p,[2*this.units,this.units],p.rank-1),g=ht(s,d),[m,b,y]=r.split(c,3,c.rank-1),[w,k]=r.split(g,2,g.rank-1);l=this.recurrentActivation.apply(r.add(m,w)),u=this.recurrentActivation.apply(r.add(b,k));const v=ht(r.mul(u,s),f);h=this.activation.apply(r.add(y,v));const x=r.add(r.mul(l,s),r.mul(r.add(1,r.neg(l)),h));return[x,x]}))}getConfig(){const t=super.getConfig(),e={units:this.units,activation:mc(this.activation),recurrentActivation:mc(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Lt(this.kernelInitializer),recurrentInitializer:Lt(this.recurrentInitializer),biasInitializer:Lt(this.biasInitializer),kernelRegularizer:Sc(this.kernelRegularizer),recurrentRegularizer:Sc(this.recurrentRegularizer),biasRegularizer:Sc(this.biasRegularizer),activityRegularizer:Sc(this.activityRegularizer),kernelConstraint:Mu(this.kernelConstraint),recurrentConstraint:Mu(this.recurrentConstraint),biasConstraint:Mu(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation,resetAfter:!1};return Object.assign(Object.assign({},t),e)}}np.className="GRUCell",e.serialization.registerClass(np);class sp extends Xc{constructor(t){0===t.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),t.cell=new np(t),super(t)}call(t,n){return e.tidy((()=>{null!=this.cell.dropoutMask&&(r.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(r.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const e=null==n?null:n.mask,s=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(t,{mask:e,training:s,initialState:i})}))}static fromConfig(t,e){return 0===e.implmentation&&(e.implementation=1),new t(e)}}sp.className="GRU",e.serialization.registerClass(sp);class rp extends Qc{constructor(t){super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=t.units,A(this.units,"units"),this.activation=yc(void 0===t.activation?this.DEFAULT_ACTIVATION:t.activation),this.recurrentActivation=yc(void 0===t.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:t.recurrentActivation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=Ot(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Ot(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Ot(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.unitForgetBias=t.unitForgetBias,this.kernelRegularizer=Ec(t.kernelRegularizer),this.recurrentRegularizer=Ec(t.recurrentRegularizer),this.biasRegularizer=Ec(t.biasRegularizer),this.kernelConstraint=Ou(t.kernelConstraint),this.recurrentConstraint=Ou(t.recurrentConstraint),this.biasConstraint=Ou(t.biasConstraint),this.dropout=Z([1,Y([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=Z([1,Y([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.dropoutFunc=t.dropoutFunc,this.implementation=t.implementation,this.stateSize=[this.units,this.units],this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){var e;const n=(t=Ut(t))[t.length-1];let s;if(this.kernel=this.addWeight("kernel",[n,4*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,4*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){if(this.unitForgetBias){const t=this.biasInitializer,n=this.units;s=new((e=class extends wt{apply(e,s){const r=t.apply([n]),i=(new vt).apply([n]),a=t.apply([2*n]);return ot(ot(r,i),a)}}).className="CustomInit",e)}else s=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.units],null,s,this.biasRegularizer,!0,this.biasConstraint)}else this.bias=null;this.built=!0}call(t,n){return e.tidy((()=>{const e=null!=n.training&&n.training;if(3!==t.length)throw new o(`LSTMCell expects 3 input Tensors (inputs, h, c), got ${t.length}.`);let s=t[1];const i=t[2];t=t[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=op({ones:()=>r.onesLike(t),rate:this.dropout,training:e,count:4,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=op({ones:()=>r.onesLike(s),rate:this.recurrentDropout,training:e,count:4,dropoutFunc:this.dropoutFunc}));const a=this.dropoutMask,l=this.recurrentDropoutMask;let u,h,c,p;0<this.dropout&&this.dropout<1&&(t=r.mul(t,a[0]));let d=ht(t,this.kernel.read());0<this.recurrentDropout&&this.recurrentDropout<1&&(s=r.mul(s,l[0])),d=r.add(d,ht(s,this.recurrentKernel.read())),this.useBias&&(d=ft(d,this.bias.read()));const[f,g,m,b]=r.split(d,4,d.rank-1);u=this.recurrentActivation.apply(f),h=this.recurrentActivation.apply(g),c=r.add(r.mul(h,i),r.mul(u,this.activation.apply(m))),p=this.recurrentActivation.apply(b);const y=r.mul(p,this.activation.apply(c));return[y,y,c]}))}getConfig(){const t=super.getConfig(),e={units:this.units,activation:mc(this.activation),recurrentActivation:mc(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Lt(this.kernelInitializer),recurrentInitializer:Lt(this.recurrentInitializer),biasInitializer:Lt(this.biasInitializer),unitForgetBias:this.unitForgetBias,kernelRegularizer:Sc(this.kernelRegularizer),recurrentRegularizer:Sc(this.recurrentRegularizer),biasRegularizer:Sc(this.biasRegularizer),activityRegularizer:Sc(this.activityRegularizer),kernelConstraint:Mu(this.kernelConstraint),recurrentConstraint:Mu(this.recurrentConstraint),biasConstraint:Mu(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation};return Object.assign(Object.assign({},t),e)}}rp.className="LSTMCell",e.serialization.registerClass(rp);class ip extends Xc{constructor(t){0===t.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),t.cell=new rp(t),super(t)}call(t,n){return e.tidy((()=>{null!=this.cell.dropoutMask&&(r.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(r.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const e=null==n?null:n.mask,s=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(t,{mask:e,training:s,initialState:i})}))}static fromConfig(t,e){return 0===e.implmentation&&(e.implementation=1),new t(e)}}ip.className="LSTM",e.serialization.registerClass(ip);class ap extends Qc{constructor(t){super(t),this.cells=t.cells}get stateSize(){const t=[];for(const e of this.cells.slice().reverse())Array.isArray(e.stateSize)?t.push(...e.stateSize):t.push(e.stateSize);return t}call(t,n){return e.tidy((()=>{let e=t.slice(1);const s=[];for(const t of this.cells.slice().reverse())Array.isArray(t.stateSize)?s.push(e.splice(0,t.stateSize.length)):s.push(e.splice(0,1));s.reverse();const r=[];let i;for(let a=0;a<this.cells.length;++a){const o=this.cells[a];e=s[a],i=0===a?[t[0]].concat(e):[i[0]].concat(e),i=o.call(i,n),r.push(i.slice(1))}e=[];for(const t of r.slice().reverse())e.push(...t);return[i[0]].concat(e)}))}build(t){let e;Bt(t)&&(t=t[0]),this.cells.forEach(((n,s)=>{K(`RNNCell_${s}`,(()=>{n.build(t),e=Array.isArray(n.stateSize)?n.stateSize[0]:n.stateSize,t=[t[0],e]}))})),this.built=!0}getConfig(){const t=super.getConfig(),e={cells:this.cells.map((t=>({className:t.getClassName(),config:t.getConfig()})))};return Object.assign(Object.assign({},t),e)}static fromConfig(t,e,n={}){const s=[];for(const t of e.cells)s.push(Xu(t,n));return new t({cells:s})}get trainableWeights(){if(!this.trainable)return[];const t=[];for(const e of this.cells)t.push(...e.trainableWeights);return t}get nonTrainableWeights(){const t=[];for(const e of this.cells)t.push(...e.nonTrainableWeights);if(!this.trainable){const e=[];for(const t of this.cells)e.push(...t.trainableWeights);return e.concat(t)}return t}getWeights(){const t=[];for(const e of this.cells)t.push(...e.weights);return qt(t)}setWeights(t){const e=[];for(const n of this.cells){const s=n.weights.length,r=t.splice(s);for(let t=0;t<n.weights.length;++t)e.push([n.weights[t],r[t]])}Gt(e)}}function op(t){const{ones:e,rate:n,training:s=!1,count:i=1,dropoutFunc:a}=t,o=()=>null!=a?a(e(),n):gt(e(),n),l=()=>mt(o,e,s);if(!i||i<=1)return r.keep(l().clone());return Array(i).fill(void 0).map(l).map((t=>r.keep(t.clone())))}ap.className="StackedRNNCells",e.serialization.registerClass(ap);var lp=function(t,e){var n={};for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&e.indexOf(s)<0&&(n[s]=t[s]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var r=0;for(s=Object.getOwnPropertySymbols(t);r<s.length;r++)e.indexOf(s[r])<0&&Object.prototype.propertyIsEnumerable.call(t,s[r])&&(n[s[r]]=t[s[r]])}return n};class up extends Xc{constructor(t){if(t.unroll)throw new l("Unrolling is not possible with convolutional RNNs.");if(Array.isArray(t.cell))throw new l("It is not possible at the moment to stack convolutional cells.");super(t),this.inputSpec=[new Ht({ndim:5})]}call(t,e){return r.tidy((()=>{if(null!=this.cell.dropoutMask&&(r.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(r.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null),e&&e.constants)throw new o("ConvRNN2D cell does not support constants");const n=null==e?null:e.mask,s=null==e?null:e.training,i=null==e?null:e.initialState;return super.call(t,{mask:n,training:s,initialState:i})}))}computeOutputShape(t){let e=this.computeSingleOutputShape(t);return this.returnSequences||(e=[e[0],...e.slice(2)]),this.returnState&&(e=[e,...Array(2).fill([t[0],...e.slice(-3)])]),e}getInitialState(t){return r.tidy((()=>{const{stateSize:e}=this.cell,n=t.shape,s=this.computeSingleOutputShape(n),i=[s[0],...s.slice(2)],a=r.zeros(i);return Array.isArray(e)?Array(e.length).fill(a):[a]}))}resetStates(t,n=!1){r.tidy((()=>{if(!this.stateful)throw new i("Cannot call resetStates() on an RNN Layer that is not stateful.");const s=this.inputSpec[0].shape,a=this.computeSingleOutputShape(s),l=[a[0],...a.slice(2)];if(null==s[0])throw new o("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.getStates())Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>r.zeros(l))):this.states_=[r.zeros(l)];else if(null==t)r.dispose(this.states_),null!=this.keptStates&&(r.dispose(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>r.zeros(l))):this.states_[0]=r.zeros(l);else{if(Array.isArray(t)||(t=[t]),t.length!==this.states_.length)throw new o(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${t.length} state value(s). Input received: ${t}`);n?this.keptStates.push(this.states_.slice()):r.dispose(this.states_);for(let n=0;n<this.states_.length;++n){const s=t[n],r=l;if(!e.util.arraysEqual(s.shape,r))throw new o(`State ${n} is incompatible with layer ${this.name}: expected shape=${r}, received shape=${s.shape}`);this.states_[n]=s}}this.states_=this.states_.map((t=>r.keep(t.clone())))}))}computeSingleOutputShape(t){const{dataFormat:e,filters:n,kernelSize:s,padding:r,strides:i,dilationRate:a}=this.cell,o="channelsFirst"===e,l=t[o?3:2],u=t[o?4:3],h=Dc(l,s[0],r,i[0],a[0]),c=Dc(u,s[1],r,i[1],a[1]);return[...t.slice(0,2),...o?[n,h,c]:[h,c,n]]}}up.className="ConvRNN2D";class hp extends rp{constructor(t){const{filters:e,kernelSize:n,strides:s,padding:r,dataFormat:i,dilationRate:a}=t;super(Object.assign(Object.assign({},t),{units:e})),this.filters=e,A(this.filters,"filters"),this.kernelSize=_c(n,2,"kernelSize"),this.kernelSize.forEach((t=>A(t,"kernelSize"))),this.strides=_c(s||1,2,"strides"),this.strides.forEach((t=>A(t,"strides"))),this.padding=r||"valid",W(this.padding),this.dataFormat=i||"channelsLast",P(this.dataFormat),this.dilationRate=_c(a||1,2,"dilationRate"),this.dilationRate.forEach((t=>A(t,"dilationRate")))}build(t){var e;t=Ut(t);const n="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[n])throw new o(`The channel dimension of the input should be defined. Found ${t[n]}`);const s=t[n],i=this.kernelSize.concat([s,4*this.filters]);this.kernel=this.addWeight("kernel",i,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint);const a=this.kernelSize.concat([this.filters,4*this.filters]);if(this.recurrentKernel=this.addWeight("recurrent_kernel",a,null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){let t;if(this.unitForgetBias){const n=this.biasInitializer,s=this.filters;t=new((e=class extends wt{apply(t,e){return at([n.apply([s]),r.ones([s]),n.apply([2*s])])}}).className="CustomInit",e)}else t=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.filters],null,t,this.biasRegularizer,!0,this.biasConstraint)}this.built=!0}call(t,e){return r.tidy((()=>{if(3!==t.length)throw new o(`ConvLSTM2DCell expects 3 input Tensors (inputs, h, c), got ${t.length}.`);const n=e.training||!1,s=t[0],i=t[1],a=t[2];0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=op({ones:()=>r.onesLike(s),rate:this.dropout,training:n,count:4,dropoutFunc:this.dropoutFunc}));const l=this.dropoutMask,u=(t,e,n)=>e&&e[n]?r.mul(e[n],t):t;let h=u(s,l,0),c=u(s,l,1),p=u(s,l,2),d=u(s,l,3);0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=op({ones:()=>r.onesLike(i),rate:this.recurrentDropout,training:n,count:4,dropoutFunc:this.dropoutFunc}));const f=this.recurrentDropoutMask;let g=u(i,f,0),m=u(i,f,1),b=u(i,f,2),y=u(i,f,3);const[w,k,v,x]=r.split(this.kernel.read(),4,3),[S,N,E,I]=this.useBias?r.split(this.bias.read(),4):[null,null,null,null];h=this.inputConv(h,w,S,this.padding),c=this.inputConv(c,k,N,this.padding),p=this.inputConv(p,v,E,this.padding),d=this.inputConv(d,x,I,this.padding);const[A,T,z,$]=r.split(this.recurrentKernel.read(),4,3);g=this.recurrentConv(g,A),m=this.recurrentConv(m,T),b=this.recurrentConv(b,z),y=this.recurrentConv(y,$);const C=this.recurrentActivation.apply(r.add(h,g)),_=this.recurrentActivation.apply(r.add(c,m)),D=r.add(r.mul(_,a),r.mul(C,this.activation.apply(r.add(p,b)))),F=r.mul(this.recurrentActivation.apply(r.add(d,y)),this.activation.apply(D));return[F,F,D]}))}getConfig(){const t=super.getConfig(),e=lp(t,["units"]),n={filters:this.filters,kernelSize:this.kernelSize,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,strides:this.strides};return Object.assign(Object.assign({},e),n)}inputConv(t,e,n,s){const i=r.conv2d(t,e,this.strides,s||"valid","channelsFirst"===this.dataFormat?"NCHW":"NHWC",this.dilationRate);return n?ft(i,n,this.dataFormat):i}recurrentConv(t,e){return r.conv2d(t,e,1,"same","channelsFirst"===this.dataFormat?"NCHW":"NHWC")}}hp.className="ConvLSTM2DCell",r.serialization.registerClass(hp);class cp extends up{constructor(t){const e=new hp(t);super(Object.assign(Object.assign({},t),{cell:e}))}static fromConfig(t,e){return new t(e)}}cp.className="ConvLSTM2D",r.serialization.registerClass(cp);class pp extends Qt{constructor(t){super(t),this.rate=Math.max(Math.min(t.rate,1),0),this.noiseShape=t.noiseShape,this.seed=t.seed,this.supportsMasking=!0}getNoiseShape(t){if(null==this.noiseShape)return this.noiseShape;const e=t.shape,n=[];for(let t=0;t<this.noiseShape.length;++t)n.push(null==this.noiseShape[t]?e[t]:this.noiseShape[t]);return n}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const e=Wt(t);if(0<this.rate&&this.rate<1){const t=null!=n.training&&n.training,s=this.getNoiseShape(e);return mt((()=>gt(e,this.rate,s,this.seed)),(()=>e),t)}return t}))}getConfig(){const t={rate:this.rate,noiseShape:this.noiseShape,seed:this.seed},e=super.getConfig();return Object.assign(t,e),t}dispose(){return super.dispose()}}pp.className="Dropout",e.serialization.registerClass(pp);class dp extends pp{constructor(t){super(t),this.inputSpec=[{ndim:3}]}getNoiseShape(t){const e=t.shape;return[e[0],1,e[2]]}}dp.className="SpatialDropout1D",e.serialization.registerClass(dp);class fp extends Qt{constructor(t){if(super(t),this.activation=null,this.useBias=!0,this.kernel=null,this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",null==t.batchInputShape&&null==t.inputShape&&null!=t.inputDim){let e=null;null!=t.batchSize&&(e=t.batchSize),this.batchInputShape=[e,t.inputDim]}this.units=t.units,A(this.units,"units"),this.activation=yc(t.activation),null!=t.useBias&&(this.useBias=t.useBias),this.kernelInitializer=Ot(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.biasInitializer=Ot(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelConstraint=Ou(t.kernelConstraint),this.biasConstraint=Ou(t.biasConstraint),this.kernelRegularizer=Ec(t.kernelRegularizer),this.biasRegularizer=Ec(t.biasRegularizer),this.activityRegularizer=Ec(t.activityRegularizer),this.supportsMasking=!0,this.inputSpec=[{minNDim:2}]}build(t){const e=(t=Ut(t))[t.length-1];null==this.kernel&&(this.kernel=this.addWeight("kernel",[e,this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint))),this.inputSpec=[{minNDim:2,axes:{[-1]:e}}],this.built=!0}computeOutputShape(t){const e=(t=Ut(t)).slice();return e[e.length-1]=this.units,e}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const e=Wt(t),s=z(this.activation.getClassName());let r;return null!=s?r=ht(e,this.kernel.read(),s,this.bias?this.bias.read():null):(r=ht(e,this.kernel.read()),null!=this.bias&&(r=ft(r,this.bias.read())),null!=this.activation&&(r=this.activation.apply(r))),r}))}getConfig(){const t={units:this.units,activation:mc(this.activation),useBias:this.useBias,kernelInitializer:Lt(this.kernelInitializer),biasInitializer:Lt(this.biasInitializer),kernelRegularizer:Sc(this.kernelRegularizer),biasRegularizer:Sc(this.biasRegularizer),activityRegularizer:Sc(this.activityRegularizer),kernelConstraint:Mu(this.kernelConstraint),biasConstraint:Mu(this.biasConstraint)},e=super.getConfig();return Object.assign(t,e),t}}fp.className="Dense",e.serialization.registerClass(fp);class gp extends Qt{constructor(t){super(t=t||{}),this.inputSpec=[{minNDim:3}],this.dataFormat=t.dataFormat}computeOutputShape(t){t=Ut(t);for(const e of t.slice(1))if(null==e)throw new o(`The shape of the input to "Flatten" is not fully defined (got ${t.slice(1)}). Make sure to pass a complete "input_shape" or "batch_input_shape" argument to the first layer in your model.`);return[t[0],J(t,1)]}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);let s=Wt(t);if("channelsFirst"===this.dataFormat&&s.rank>1){const t=[0];for(let e=2;e<s.rank;++e)t.push(e);t.push(1),s=e.transpose(s,t)}return function(t){if(t.rank<=1)throw new o(`batchFlatten requires a minimum rank of 2. Got rank: ${t.rank}.`);const e=[t.shape[0],J(t.shape,1)];return r.reshape(t,e)}(s)}))}getConfig(){const t={};null!=this.dataFormat&&(t.dataFormat=this.dataFormat);const e=super.getConfig();return Object.assign(t,e),t}}gp.className="Flatten",e.serialization.registerClass(gp);class mp extends Qt{constructor(t){super(t),this.supportsMasking=!0,this.activation=yc(t.activation)}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const e=Wt(t);return this.activation.apply(e)}))}getConfig(){const t={activation:mc(this.activation)},e=super.getConfig();return Object.assign(t,e),t}}mp.className="Activation",e.serialization.registerClass(mp);class bp extends Qt{constructor(t){super(t),this.n=t.n,this.inputSpec=[{ndim:2}]}computeOutputShape(t){return[t[0],this.n,t[1]]}call(t,n){return e.tidy((()=>{return t=Wt(t),n=t,s=this.n,e.tidy((()=>{if(2!==n.shape.length)throw new o(`repeat() expects a rank-2 tensor, but received a rank-${n.shape.length} tensor.`);return lt(nt(n,1),[1,s,1])}));var n,s}))}getConfig(){const t={n:this.n},e=super.getConfig();return Object.assign(t,e),t}}bp.className="RepeatVector",e.serialization.registerClass(bp);class yp extends Qt{constructor(t){super(t),this.targetShape=t.targetShape;for(let t=0;t<this.targetShape.length;++t)this.isUnknown(this.targetShape[t])&&(this.targetShape[t]=null)}isUnknown(t){return t<0||null==t}fixUnknownDimension(t,e){const n="Total size of new array must be unchanged.",s=e.slice();let r=1,i=null;for(let t=0;t<s.length;++t){const e=s[t];if(this.isUnknown(e)){if(null!==i)throw new o("Can only specifiy one unknown dimension.");i=t}else r*=e}const a=J(t);if(null!==i){if(0===r||a%r!=0)throw new o(n);s[i]=a/r}else if(a!==r)throw new o(n);return s}computeOutputShape(t){let e=!1;for(let n=0;n<t.length;++n)if(this.isUnknown(t[n])){e=!0;break}return e?t.slice(0,1).concat(this.targetShape):t.slice(0,1).concat(this.fixUnknownDimension(t.slice(1),this.targetShape))}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const s=Wt(t),r=s.shape,i=r.slice(0,1).concat(this.fixUnknownDimension(r.slice(1),this.targetShape));return e.reshape(s,i)}))}getConfig(){const t={targetShape:this.targetShape},e=super.getConfig();return Object.assign(t,e),t}}yp.className="Reshape",e.serialization.registerClass(yp);class wp extends Qt{constructor(t){if(super(t),null==t.dims)throw new Error("Required configuration field `dims` is missing during Permute constructor call.");if(!Array.isArray(t.dims))throw new Error(`Permute constructor requires \`dims\` to be an Array, but received ${t.dims} instead.`);const n=X(1,t.dims.length+1);if(!e.util.arraysEqual(t.dims.slice().sort(),n))throw new Error("Invalid permutation `dims`: "+JSON.stringify(t.dims)+" `dims` must contain consecutive integers starting from 1.");this.dims=t.dims,this.dimsIncludingBatch=[0].concat(this.dims),this.inputSpec=[new Ht({ndim:this.dims.length+1})]}computeOutputShape(t){const e=(t=Ut(t)).slice();return this.dims.forEach(((n,s)=>{e[s+1]=t[n]})),e}call(t,n){return e.transpose(Wt(t),this.dimsIncludingBatch)}getConfig(){const t={dims:this.dims},e=super.getConfig();return Object.assign(t,e),t}}wp.className="Permute",e.serialization.registerClass(wp);class kp extends Qt{constructor(t){super(null==t?{}:t),this.supportsMasking=!0,this.maskValue=null!=t?null==t.maskValue?0:t.maskValue:0}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={maskValue:this.maskValue};return Object.assign(e,t),e}computeMask(t,n){const s=Wt(t);return e.any(e.notEqual(s,this.maskValue),-1)}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const s=Wt(t),r=e.any(e.notEqual(s,this.maskValue),-1,!0);return e.mul(s,e.cast(r,s.dtype))}))}}kp.className="Masking",e.serialization.registerClass(kp);class vp extends Qt{constructor(t){if(super(t),this.embeddings=null,this.DEFAULT_EMBEDDINGS_INITIALIZER="randomUniform",null==t.batchInputShape&&null==t.inputShape){let e=null;null!=t.batchSize&&(e=t.batchSize),null==t.inputLength?this.batchInputShape=[e,null]:this.batchInputShape=[e].concat(g(t.inputLength))}this.inputDim=t.inputDim,A(this.inputDim,"inputDim"),this.outputDim=t.outputDim,A(this.outputDim,"outputDim"),this.embeddingsInitializer=Ot(t.embeddingsInitializer||this.DEFAULT_EMBEDDINGS_INITIALIZER),this.embeddingsRegularizer=Ec(t.embeddingsRegularizer),this.activityRegularizer=Ec(t.activityRegularizer),this.embeddingsConstraint=Ou(t.embeddingsConstraint),this.maskZero=t.maskZero,this.supportsMasking=t.maskZero,this.inputLength=t.inputLength}build(t){this.embeddings=this.addWeight("embeddings",[this.inputDim,this.outputDim],this.dtype,this.embeddingsInitializer,this.embeddingsRegularizer,!0,this.embeddingsConstraint),this.built=!0}warnOnIncompatibleInputShape(t){}computeMask(t,n){return e.tidy((()=>this.maskZero?(t=Wt(t),e.notEqual(t,e.zerosLike(t))):null))}computeOutputShape(t){if(t=Ut(t),null==this.inputLength)return[...t,this.outputDim];const e=g(this.inputLength);if(e.length!==t.length-1)throw new o(`"inputLength" is ${this.inputLength}, but received input shape has shape ${t}`);{let n=0;for(let s=0;s<e.length;++s){const r=e[s],i=t[s+1];if(null!=r&&null!=i&&r!==i)throw new o(`"inputLength" is ${this.inputLength}, but received input shape has shape ${t}`);null==r&&(e[n]=i),n++}}return[t[0],...e,this.outputDim]}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);let s=Wt(t);"int32"!==s.dtype&&(s=et(s,"int32"));const r=ct(this.embeddings.read(),e.reshape(s,[s.size]));return e.reshape(r,Ut(this.computeOutputShape(s.shape)))}))}getConfig(){const t={inputDim:this.inputDim,outputDim:this.outputDim,embeddingsInitializer:Lt(this.embeddingsInitializer),embeddingsRegularizer:Sc(this.embeddingsRegularizer),activityRegularizer:Sc(this.activityRegularizer),embeddingsConstraint:Mu(this.embeddingsConstraint),maskZero:this.maskZero,inputLength:this.inputLength},e=super.getConfig();return Object.assign(t,e),t}}vp.className="Embedding",e.serialization.registerClass(vp);class xp extends Qt{constructor(t){super(t||{}),this.supportsMasking=!0}mergeFunction(t){throw new l}computeElementwiseOpOutputShape(t,e){if(null==t||null==e)return null;if(t.length<e.length)return this.computeElementwiseOpOutputShape(e,t);if(0===e.length)return t;const n=t.slice(0,t.length-e.length);for(let s=0;s<e.length;++s){const r=t[t.length-e.length+s],i=e[s];if(null==r||null==i||r<0||i<0)n.push(null);else if(1===r)n.push(i);else if(1===i)n.push(r);else{if(r!==i)throw new o("Operands could not be broadcast together with shapes "+JSON.stringify(t)+" "+JSON.stringify(e));n.push(r)}}return n}build(t){if(Array.isArray(t)&&!Array.isArray(t[0])&&(t=[Ut(t)]),t.length<2)throw new o(`A merge layer should be called on an Array of at least 2 inputs. Got ${t.length} input(s).`);let e=[];for(const n of t)null!=n&&null!==n[0]&&e.push(n[0]);if(e=S(e),e.length>1)throw new o(`Can not merge tensors with different batch sizes. Got tensors with shapes: ${JSON.stringify(t)}.`);let n=null==t[0]?null:t[0].slice(1);for(let e=1;e<t.length;++e){const s=null==t[e]?null:t[e].slice(1);n=this.computeElementwiseOpOutputShape(n,s)}const s=t.map((t=>t.length));-1===t.indexOf(null)&&1===S(s).length?this.reshapeRequired=!1:this.reshapeRequired=!0}call(t,n){return e.tidy((()=>{if(this.reshapeRequired){const e=[],n=t.map((t=>t.rank));if(-1===n.indexOf(null)){const s=Y(n);for(let n of t){const t=n.rank;for(let e=0;e<s-t;++e)n=nt(n,1);e.push(n)}return this.mergeFunction(e)}{let n=!1;for(const s of t){const t=s.rank;if(null==t){const t=s.shape,i=t[0],a=t.slice(1).concat([i]);let o=r.reshape(s,[i].concat(J(t.slice(1))));o=r.transpose(o,[1,0]),o=r.reshape(o,a),e.push(o),n=!0}else if(t>1){const i=X(1,t).concat([0]);e.push(r.transpose(s,i)),n=!0}else e.push(s)}let s=this.mergeFunction(e);const i=s.rank;if(n)if(null==i){const t=s.shape,e=t[t.length-1],n=[e].concat(t.slice(0,t.length-1));s=r.reshape(r.transpose(r.reshape(s,[-1,e]),[1,0]),n)}else if(i>1){const t=[i-1].concat(X(0,i-1));s=r.transpose(s,t)}return s}}return this.mergeFunction(t)}))}computeOutputShape(t){let e;e=null==t[0]?null:t[0].slice(1);for(let n=1;n<t.length;++n){const s=null==t[n]?null:t[n].slice(1);e=this.computeElementwiseOpOutputShape(e,s)}let n=[];for(const e of t)null!=e&&null!==e[0]&&n.push(e[0]);return n=S(n),e=1===n.length?n.concat(e):[null].concat(e),e}computeMask(t,e){return r.tidy((()=>{if(null==e)return null;if(!Array.isArray(e))throw new o("`mask` should be an Array");if(!Array.isArray(t))throw new o("`inputs` should be an Array");if(e.length!==t.length)throw new o(`The Array 'inputs' and 'mask' are expected to have the same length, but have different lengths (${t.length} vs ${e.length})`);if(e.every((t=>null==t)))return null;let n=(e=e.map((t=>null==t?t:r.expandDims(t,0))))[0];for(let t=1;t<e.length-1;++t)n=r.logicalAnd(n,e[t]);return n}))}}class Sp extends xp{constructor(t){super(t)}mergeFunction(t){return e.tidy((()=>{let e=t[0].clone();for(let n=1;n<t.length;++n)e=r.add(e,t[n]);return e}))}}Sp.className="Add",e.serialization.registerClass(Sp);class Np extends xp{constructor(t){super(t)}mergeFunction(t){return e.tidy((()=>{let e=t[0].clone();for(let n=1;n<t.length;++n)e=r.mul(e,t[n]);return e}))}}Np.className="Multiply",e.serialization.registerClass(Np);class Ep extends xp{constructor(t){super(t)}mergeFunction(t){return e.tidy((()=>{let e=t[0].clone();for(let n=1;n<t.length;++n)e=r.add(e,t[n]);return r.mul(1/t.length,e)}))}}Ep.className="Average",e.serialization.registerClass(Ep);class Ip extends xp{constructor(t){super(t)}mergeFunction(t){return e.tidy((()=>{let e=t[0];for(let n=1;n<t.length;++n)e=r.maximum(e,t[n]);return e}))}}Ip.className="Maximum",e.serialization.registerClass(Ip);class Ap extends xp{constructor(t){super(t)}mergeFunction(t){return e.tidy((()=>{let e=t[0];for(let n=1;n<t.length;++n)e=r.minimum(e,t[n]);return e}))}}Ap.className="Minimum",e.serialization.registerClass(Ap);class Tp extends xp{constructor(t){super(t),this.DEFAULT_AXIS=-1,null==t&&(t={}),this.axis=null==t.axis?this.DEFAULT_AXIS:t.axis,this.supportsMasking=!0,this.reshapeRequired=!1}build(t){if(!Array.isArray(t)||!Array.isArray(t[0])||1===t.length)throw new o("A `Concatenate` layer should be called on a list of at least 2 inputs");let n=!0;for(const e of t)if(null!=e){n=!1;break}if(n)return;const s=[];for(let n=0;n<t.length;++n){const r=t[n].slice();r.splice(this.axis,1);let i=!1;for(const t of s)if(e.util.arraysEqual(t,r)){i=!0;break}i||s.push(r)}if(s.length>1)throw new o("A `Concatenate` layer requires inputs with matching shapes except for the concat axis. Got input shapes: "+JSON.stringify(t))}mergeFunction(t){return e.tidy((()=>at(t,this.axis)))}computeOutputShape(t){if(!Array.isArray(t)||!Array.isArray(t[0]))throw new o("A `Concatenate` layer should be called on a list of inputs.");const e=t,n=e[0].slice(),s=this.axis<0?n.length+this.axis:this.axis;for(const t of e.slice(1)){if(null==n[s]||null==t[s]){n[s]=null;break}n[s]+=t[s]}return n}computeMask(t,e){if(null==e)return null;if(!Array.isArray(e))throw new o("`mask` should be an array for Concatenate");if(!Array.isArray(t))throw new o("`inputs` should be an array for Concatenate");if(e.length!==t.length)throw new o(`Mismatch in the length of mask (${e.length}) and the legnth of inputs (${t.length})`);return r.tidy((()=>{let n=!0;if(e.forEach((t=>{null==t||(n=!1)})),n)return null;const s=[];for(let n=0;n<t.length;++n)null==e[n]?s.push(r.cast(r.onesLike(t[n]),"bool")):e[n].rank<t[n].rank?s.push(r.expandDims(e[n],-1)):s.push(e[n]);const i=r.concat(s,this.axis);return r.all(i,-1,!1)}))}getConfig(){const t={axis:this.axis},e=super.getConfig();return Object.assign(t,e),t}}function zp(t,e){for(;t<0;)t+=e;return t}Tp.className="Concatenate",e.serialization.registerClass(Tp);class $p extends xp{constructor(t){super(t),this.axes=t.axes,this.normalize=null!=t.normalize&&t.normalize,this.supportsMasking=!0,this.reshapeRequired=!1}build(t){r.util.assert(Array.isArray(t)&&2===t.length&&Array.isArray(t[0])&&Array.isArray(t[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const e=t[0],n=t[1];if(e.length>3||n.length>3)throw new l("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(e,n);if(e[s[0]]!==n[s[1]])throw new o(`Dimension incompatibility: ${e[s[0]]} !== ${n[s[1]]}`)}mergeFunction(t){if(2!==t.length)throw new o(`A \`Dot\` layer must be called on exactly 2 inputs, but received ${t.length} input(s).`);let e,n=t[0],s=t[1];return e=Array.isArray(this.axes)?this.axes.map(((e,n)=>zp(e,t[n].shape.length))):[zp(this.axes,n.shape.length),zp(this.axes,s.shape.length)],this.normalize&&(n=Qu(n,e[0]),s=Qu(s,e[1])),function(t,e,n){if(t.shape.length>3||e.shape.length>3)throw new l("batchDot is not implemented for tensors of 4D or higher rank yet");if(r.util.assert(t.shape.length>=2,(()=>`batchDot requires the rank of x to be >= 2, but got ${t.shape.length}`)),r.util.assert(t.shape.length>=2,(()=>`batchDot requires the rank of y to be >= 2, but got ${e.shape.length}`)),"number"==typeof n&&(n=[n,n]),"complex64"===t.dtype||"complex64"===e.dtype)throw new l("batchDot is not implemented for complex64-type Tensors yet.");const s=t.shape.length,i=e.shape.length;null==n&&(n=[s-1,i-2]);const a=n;return r.tidy((()=>{let n,o;if(s>i){n=s-i;const t=[];for(let e=0;e<n;++e)t.push(1);e=r.reshape(e,e.shape.concat(t))}else if(i>s){n=i-s;const e=[];for(let t=0;t<n;++t)e.push(1);t=r.reshape(t,t.shape.concat(e))}else n=0;if(2===t.shape.length&&2===e.shape.length)o=a[0]===a[1]?r.sum(r.mul(t,e),a[0]):r.sum(r.mul(r.transpose(t,[1,0]),e),a[1]);else{const n=a[0]!==t.shape.length-1,s=a[1]===e.shape.length-1;o=r.matMul(t,e,n,s)}if(n>0){let t;t=s>i?s+i-3:s-1;const e=[];for(let s=t;s<t+n;++s)e.push(s);o=r.squeeze(o,e)}return 1===o.shape.length&&(o=r.expandDims(o,1)),o}))}(n,s,e)}interpretAxes(t,e){let n;return n=Array.isArray(this.axes)?this.axes:[zp(this.axes,t.length),zp(this.axes,e.length)],n}computeOutputShape(t){r.util.assert(Array.isArray(t)&&2===t.length&&Array.isArray(t[0])&&Array.isArray(t[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const e=t[0].slice(),n=t[1].slice();if(e.length>3||n.length>3)throw new l("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(e,n);e.splice(s[0],1),n.splice(s[1],1),n.splice(0,1);const i=e.concat(n);return 1===i.length&&i.push(1),i}computeMask(t,e){return null}getConfig(){const t={axes:this.axes,normalize:this.normalize},e=super.getConfig();return Object.assign(t,e),t}}$p.className="Dot",e.serialization.registerClass($p);class Cp extends Qt{constructor(t){super(t),this.supportsMasking=!0,this.stddev=t.stddev}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={stddev:this.stddev};return Object.assign(e,t),e}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const s=Wt(t);return mt((()=>e.add(ut(s.shape,0,this.stddev),s)),(()=>s),n.training||!1)}))}}Cp.className="GaussianNoise",e.serialization.registerClass(Cp);class _p extends Qt{constructor(t){super(t),this.supportsMasking=!0,this.rate=t.rate}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={rate:this.rate};return Object.assign(e,t),e}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const s=Wt(t);if(this.rate>0&&this.rate<1){return mt((()=>{const t=Math.sqrt(this.rate/(1-this.rate));return e.mul(s,ut(s.shape,1,t))}),(()=>s),n.training||!1)}return s}))}}_p.className="GaussianDropout",e.serialization.registerClass(_p);class Dp extends Qt{constructor(t){super(t),this.supportsMasking=!0,this.rate=t.rate,this.noiseShape=t.noiseShape}_getNoiseShape(t){return this.noiseShape||Wt(t).shape}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={rate:this.rate};return Object.assign(e,t),e}call(t,n){return e.tidy((()=>{if(this.rate<1&&this.rate>0){const s=this._getNoiseShape(t),r=()=>{const n=Wt(t),r=-1.7580993408473766;let i=e.greaterEqual(e.randomUniform(s),this.rate);i=et(i,"float32");const a=((1-this.rate)*(1+this.rate*r**2))**-.5,o=-a*r*this.rate,l=e.add(e.mul(n,i),e.mul(e.add(i,-1),r));return e.add(e.mul(l,a),o)};return mt(r,(()=>Wt(t)),n.training||!1)}return t}))}}function Fp(t,e,n,s,i,a=.001){let o;if(2===t.rank)o=r.batchNorm2d(t,e,n,s,i,a);else if(3===t.rank)o=r.batchNorm3d(t,e,n,s,i,a);else{if(4!==t.rank)throw new l(`batchNormalization is not implemented for array of rank ${t.rank} yet`);o=r.batchNorm4d(t,e,n,s,i,a)}return o}function Rp(t,n,s,i,a=.001){return e.util.arraysEqual(i.slice().sort(),X(0,t.rank-1))?function(t,n,s,i,a=.001){return e.tidy((()=>{const e=r.moments(t,i),o=e.mean,l=e.variance;return[Fp(t,o,l,s,n,a),o,l]}))}(t,n,s,i,a):function(t,n,s,i,a=.001){return e.tidy((()=>{const o=r.moments(t,i),l=o.mean,u=o.variance,h=[];for(const e of X(0,t.rank))-1!==i.indexOf(e)?h.push(1):h.push(t.shape[e]);const c=e.reshape(l,h),p=e.reshape(u,h),d=null==n?null:e.reshape(n,h),f=null==s?null:e.reshape(s,h);return[Fp(t,c,p,f,d,a),l,u]}))}(t,n,s,i,a)}Dp.className="AlphaDropout",e.serialization.registerClass(Dp);class Mp extends Qt{constructor(t){null==t&&(t={}),super(t),this.supportsMasking=!0,this.axis=null==t.axis?-1:t.axis,this.momentum=null==t.momentum?.99:t.momentum,this.epsilon=null==t.epsilon?.001:t.epsilon,this.center=null==t.center||t.center,this.scale=null==t.scale||t.scale,this.betaInitializer=Ot(t.betaInitializer||"zeros"),this.gammaInitializer=Ot(t.gammaInitializer||"ones"),this.movingMeanInitializer=Ot(t.movingMeanInitializer||"zeros"),this.movingVarianceInitializer=Ot(t.movingVarianceInitializer||"ones"),this.betaConstraint=Ou(t.betaConstraint),this.gammaConstraint=Ou(t.gammaConstraint),this.betaRegularizer=Ec(t.betaRegularizer),this.gammaRegularizer=Ec(t.gammaRegularizer)}build(t){t=Ut(t);const e=this.axis>=0?this.axis:this.axis+t.length,n=t[e];if(null==n)throw new o(`Axis ${e} of input tensor should have a defined dimension but the layer received an input with shape ${JSON.stringify(t)}.`);this.inputSpec=[new Ht({ndim:t.length,axes:{[e]:n}})];const s=[n];this.scale&&(this.gamma=this.addWeight("gamma",s,null,this.gammaInitializer,this.gammaRegularizer,!0,this.gammaConstraint)),this.center&&(this.beta=this.addWeight("beta",s,null,this.betaInitializer,this.betaRegularizer,!0,this.betaConstraint)),this.movingMean=this.addWeight("moving_mean",s,null,this.movingMeanInitializer,null,!1),this.movingVariance=this.addWeight("moving_variance",s,null,this.movingVarianceInitializer,null,!1),this.built=!0}call(t,n){return e.tidy((()=>{const s=null!=n.training&&n.training,i=Wt(t),a=i.shape,o=a.length,l=X(0,o),u=this.axis>=0?this.axis:this.axis+o;l.splice(u,1);const h=c(1,o);h[u]=a[u];const p=l.slice();p.sort();const d=!e.util.arraysEqual(p,X(0,o).slice(0,o-1));if(!s)return(()=>{if(d){const t=e.reshape(this.movingMean.read(),h),n=e.reshape(this.movingVariance.read(),h),s=this.center?e.reshape(this.beta.read(),h):null,r=this.scale?e.reshape(this.gamma.read(),h):null;return Fp(i,t,n,s,r,this.epsilon)}return Fp(i,this.movingMean.read(),this.movingVariance.read(),null==this.beta?null:this.beta.read(),null==this.gamma?null:this.gamma.read(),this.epsilon)})();const[f,g,m]=Rp(i,this.gamma.read(),this.beta.read(),l,this.epsilon),b=(t,e,n)=>{r.tidy((()=>{const s=1-n,i=t.read(),a=r.mul(r.sub(i,e),s);t.write(r.sub(i,a))}))};return(()=>{b(this.movingMean,g,this.momentum),b(this.movingVariance,m,this.momentum)})(),f}))}getConfig(){const t={axis:this.axis,momentum:this.momentum,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Lt(this.betaInitializer),gammaInitializer:Lt(this.gammaInitializer),movingMeanInitializer:Lt(this.movingMeanInitializer),movingVarianceInitializer:Lt(this.movingVarianceInitializer),betaRegularizer:Sc(this.betaRegularizer),gammaRegularizer:Sc(this.gammaRegularizer),betaConstraint:Mu(this.betaConstraint),gammaConstraint:Mu(this.gammaConstraint)},e=super.getConfig();return Object.assign(t,e),t}}Mp.className="BatchNormalization",e.serialization.registerClass(Mp);class Lp extends Qt{constructor(t){if(null==t&&(t={}),super(t),this.axis=null==t.axis?-1:t.axis,"number"==typeof this.axis){if(!Number.isInteger(this.axis))throw new Error(`Expected axis to be an integer, but received ${this.axis}`)}else{if(!Array.isArray(this.axis))throw new Error(`Expected axis to be an integer or an array of integers, but received ${JSON.stringify(this.axis)}`);for(const t of this.axis)if(!Number.isInteger(t))throw new Error(`Expected axis to be an array of integers, but received ${JSON.stringify(this.axis)}`)}this.epsilon=null==t.epsilon?.001:t.epsilon,this.center=null==t.center||t.center,this.scale=null==t.scale||t.scale,this.betaInitializer=Ot(t.betaInitializer||"zeros"),this.gammaInitializer=Ot(t.gammaInitializer||"ones"),this.betaRegularizer=Ec(t.betaRegularizer),this.gammaRegularizer=Ec(t.gammaRegularizer),this.supportsMasking=!0}build(t){const e=(t=Ut(t)).length;"number"==typeof this.axis&&(this.axis=[this.axis]);for(let t=0;t<this.axis.length;++t)this.axis[t]<0&&(this.axis[t]+=e);for(const t of this.axis)if(t<0||t>=e)throw new Error(`Invalid axis: ${t}`);if(this.axis.length!==S(this.axis).length)throw new Error(`Found duplicate axes in: ${this.axis}`);const n=this.axis.map((e=>t[e]));this.scale?this.gamma=this.addWeight("gamma",n,"float32",this.gammaInitializer,this.gammaRegularizer,true):this.gamma=null,this.center?this.beta=this.addWeight("beta",n,"float32",this.betaInitializer,this.betaRegularizer,true):this.beta=null,this.built=!0}call(t,n){const s=Wt(t),i=s.shape,a=i.length;return e.tidy((()=>{let{mean:t,variance:n}=e.moments(s,this.axis,!0);const o=c(1,a);for(const t of this.axis)o[t]=i[t];const l=t=>null!=t&&t.shape.length!==a?r.reshape(t,o):t;let u=this.scale?l(this.gamma.read()):null,h=this.center?l(this.beta.read()):null;const p=[],d=[];for(let t=0;t<a;++t)-1!==this.axis.indexOf(t)?(p.push(i[t]),d.push(1)):(p.push(1),d.push(i[t]));return t=r.tile(t,p),n=r.tile(n,p),null!=u&&(u=r.tile(u,d)),null!=h&&(h=r.tile(h,d)),Fp(s,t,n,h,u,this.epsilon)}))}getConfig(){const t={axis:this.axis,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Lt(this.betaInitializer),gammaInitializer:Lt(this.gammaInitializer),betaRegularizer:Sc(this.betaRegularizer),gammaRegularizer:Sc(this.gammaRegularizer)},e=super.getConfig();return Object.assign(t,e),t}}Lp.className="LayerNormalization",e.serialization.registerClass(Lp);class Op extends Qt{constructor(t){if(null==t&&(t={}),super(t),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,null==t.padding)this.padding=[[1,1],[1,1]];else if("number"==typeof t.padding)this.padding=[[t.padding,t.padding],[t.padding,t.padding]];else{if(t.padding=t.padding,2!==t.padding.length)throw new o(`ZeroPadding2D expects padding to be a length-2 array, but received a length-${t.padding.length} array.`);let e,n;if("number"==typeof t.padding[0])e=[t.padding[0],t.padding[0]],n=[t.padding[1],t.padding[1]];else{if(t.padding=t.padding,2!==t.padding[0].length)throw new o(`ZeroPadding2D expects height padding to be a length-2 array, but received a length-${t.padding[0].length} array.`);if(e=t.padding[0],2!==t.padding[1].length)throw new o(`ZeroPadding2D expects width padding to be a length-2 array, but received a length-${t.padding[1].length} array.`);n=t.padding[1]}this.padding=[e,n]}this.inputSpec=[new Ht({ndim:4})]}computeOutputShape(t){let e,n;return t=Ut(t),"channelsFirst"===this.dataFormat?(e=null!=t[2]&&t[2]>=0?t[2]+this.padding[0][0]+this.padding[0][1]:null,n=null!=t[3]&&t[3]>=0?t[3]+this.padding[1][0]+this.padding[1][1]:null,[t[0],t[1],e,n]):(e=null!=t[1]&&t[1]>=0?t[1]+this.padding[0][0]+this.padding[0][1]:null,n=null!=t[2]&&t[2]>=0?t[2]+this.padding[1][0]+this.padding[1][1]:null,[t[0],e,n,t[3]])}call(t,n){return e.tidy((()=>{return n=Wt(t),s=this.padding,i=this.dataFormat,e.tidy((()=>{if(4!==n.rank)throw new o(`temporalPadding expects input tensor to be 4-D, but received a ${n.rank}-D tensor.`);if(null==s&&(s=[[1,1],[1,1]]),2!==s.length||2!==s[0].length||2!==s[1].length)throw new o("spatial2dPadding expects `padding` to be an Array of two Arrays, each of which is an Array of two integers.");if(null==i&&(i="channelsLast"),"channelsLast"!==i&&"channelsFirst"!==i)throw new o(`Unknown data format: ${i}. Supported data formats are 'channelsLast' and 'channelsFirst.`);let t;return t="channelsFirst"===i?[[0,0],[0,0],s[0],s[1]]:[[0,0],s[0],s[1],[0,0]],r.pad(n,t)}));var n,s,i}))}getConfig(){const t={padding:this.padding,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}function Bp(t,n,s,i,a,o){return e.tidy((()=>{let e;P(a),U(o),W(i),null==s&&(s=[1,1]),null==i&&(i="valid"),null==a&&(a="channelsLast"),null==o&&(o="max"),t=Rc(t,a);const l="same"===i?"same":"valid";return e="max"===o?r.maxPool(t,n,s,l):r.avgPool(t,n,s,l),"channelsFirst"===a&&(e=r.transpose(e,[0,3,1,2])),e}))}function Pp(t,n,s,i,a,o){return e.tidy((()=>{let e;P(a),U(o),W(i),null==s&&(s=[1,1,1]),null==i&&(i="valid"),null==a&&(a="channelsLast"),null==o&&(o="max"),t=Mc(t,a);const l="same"===i?"same":"valid";return e="max"===o?r.maxPool3d(t,n,s,l):r.avgPool3d(t,n,s,l),"channelsFirst"===a&&(e=r.transpose(e,[0,4,1,2,3])),e}))}Op.className="ZeroPadding2D",e.serialization.registerClass(Op);class Wp extends Qt{constructor(t){if(null==t.poolSize&&(t.poolSize=2),super(t),"number"==typeof t.poolSize)this.poolSize=[t.poolSize];else{if(!Array.isArray(t.poolSize)||1!==t.poolSize.length||"number"!=typeof t.poolSize[0])throw new o(`poolSize for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(t.poolSize)}`);this.poolSize=t.poolSize}if(A(this.poolSize,"poolSize"),null==t.strides)this.strides=this.poolSize;else if("number"==typeof t.strides)this.strides=[t.strides];else{if(!Array.isArray(t.strides)||1!==t.strides.length||"number"!=typeof t.strides[0])throw new o(`strides for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(t.strides)}`);this.strides=t.strides}A(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,W(this.padding),this.inputSpec=[new Ht({ndim:3})]}computeOutputShape(t){const e=Dc((t=Ut(t))[1],this.poolSize[0],this.padding,this.strides[0]);return[t[0],e,t[2]]}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n),t=nt(Wt(t),2);const e=this.poolingFunction(Wt(t),[this.poolSize[0],1],[this.strides[0],1],this.padding,"channelsLast");return r.squeeze(e,[2])}))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides},e=super.getConfig();return Object.assign(t,e),t}}class Up extends Wp{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return P(r),W(s),Bp(t,e,n,s,r,"max")}}Up.className="MaxPooling1D",e.serialization.registerClass(Up);class Vp extends Wp{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return P(r),W(s),Bp(t,e,n,s,r,"avg")}}Vp.className="AveragePooling1D",e.serialization.registerClass(Vp);class Kp extends Qt{constructor(t){if(null==t.poolSize&&(t.poolSize=[2,2]),super(t),this.poolSize=Array.isArray(t.poolSize)?t.poolSize:[t.poolSize,t.poolSize],null==t.strides)this.strides=this.poolSize;else if(Array.isArray(t.strides)){if(2!==t.strides.length)throw new o(`If the strides property of a 2D pooling layer is an Array, it is expected to have a length of 2, but received length ${t.strides.length}.`);this.strides=t.strides}else this.strides=[t.strides,t.strides];A(this.poolSize,"poolSize"),A(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,P(this.dataFormat),W(this.padding),this.inputSpec=[new Ht({ndim:4})]}computeOutputShape(t){t=Ut(t);let e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2];return e=Dc(e,this.poolSize[0],this.padding,this.strides[0]),n=Dc(n,this.poolSize[1],this.padding,this.strides[1]),"channelsFirst"===this.dataFormat?[t[0],t[1],e,n]:[t[0],e,n,t[3]]}call(t,n){return e.tidy((()=>(this.invokeCallHook(t,n),this.poolingFunction(Wt(t),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class jp extends Kp{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return P(r),W(s),Bp(t,e,n,s,r,"max")}}jp.className="MaxPooling2D",e.serialization.registerClass(jp);class qp extends Kp{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return P(r),W(s),Bp(t,e,n,s,r,"avg")}}qp.className="AveragePooling2D",e.serialization.registerClass(qp);class Gp extends Qt{constructor(t){if(null==t.poolSize&&(t.poolSize=[2,2,2]),super(t),this.poolSize=Array.isArray(t.poolSize)?t.poolSize:[t.poolSize,t.poolSize,t.poolSize],null==t.strides)this.strides=this.poolSize;else if(Array.isArray(t.strides)){if(3!==t.strides.length)throw new o(`If the strides property of a 3D pooling layer is an Array, it is expected to have a length of 3, but received length ${t.strides.length}.`);this.strides=t.strides}else this.strides=[t.strides,t.strides,t.strides];A(this.poolSize,"poolSize"),A(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,P(this.dataFormat),W(this.padding),this.inputSpec=[new Ht({ndim:5})]}computeOutputShape(t){t=Ut(t);let e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2],s="channelsFirst"===this.dataFormat?t[4]:t[3];return e=Dc(e,this.poolSize[0],this.padding,this.strides[0]),n=Dc(n,this.poolSize[1],this.padding,this.strides[1]),s=Dc(s,this.poolSize[2],this.padding,this.strides[2]),"channelsFirst"===this.dataFormat?[t[0],t[1],e,n,s]:[t[0],e,n,s,t[4]]}call(t,n){return e.tidy((()=>(this.invokeCallHook(t,n),this.poolingFunction(Wt(t),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class Hp extends Gp{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return P(r),W(s),Pp(t,e,n,s,r,"max")}}Hp.className="MaxPooling3D",e.serialization.registerClass(Hp);class Jp extends Gp{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return P(r),W(s),Pp(t,e,n,s,r,"avg")}}Jp.className="AveragePooling3D",e.serialization.registerClass(Jp);class Zp extends Qt{constructor(t){super(t),this.inputSpec=[new Ht({ndim:3})]}computeOutputShape(t){return[t[0],t[2]]}call(t,e){throw new l}}class Yp extends Zp{constructor(t){super(t||{})}call(t,n){return e.tidy((()=>{const e=Wt(t);return r.mean(e,1)}))}}Yp.className="GlobalAveragePooling1D",e.serialization.registerClass(Yp);class Xp extends Zp{constructor(t){super(t||{})}call(t,n){return e.tidy((()=>{const e=Wt(t);return r.max(e,1)}))}}Xp.className="GlobalMaxPooling1D",e.serialization.registerClass(Xp);class Qp extends Qt{constructor(t){super(t),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,P(this.dataFormat),this.inputSpec=[new Ht({ndim:4})]}computeOutputShape(t){return"channelsLast"===this.dataFormat?[t[0],t[3]]:[t[0],t[1]]}call(t,e){throw new l}getConfig(){const t={dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class td extends Qp{call(t,n){return e.tidy((()=>{const e=Wt(t);return"channelsLast"===this.dataFormat?r.mean(e,[1,2]):r.mean(e,[2,3])}))}}td.className="GlobalAveragePooling2D",e.serialization.registerClass(td);class ed extends Qp{call(t,n){return e.tidy((()=>{const e=Wt(t);return"channelsLast"===this.dataFormat?r.max(e,[1,2]):r.max(e,[2,3])}))}}ed.className="GlobalMaxPooling2D",e.serialization.registerClass(ed);class nd extends Qt{constructor(t){super(t),this.layer=t.layer}build(t){this.built=!0}get trainable(){return null!=this.layer&&this.layer.trainable}set trainable(t){null!=this.layer&&(this.layer.trainable=t)}get trainableWeights(){return this.layer.trainableWeights}get nonTrainableWeights(){return this.layer.nonTrainableWeights}get updates(){return this.layer._updates}get losses(){return this.layer.losses}getWeights(){return this.layer.getWeights()}setWeights(t){this.layer.setWeights(t)}getConfig(){const t={layer:{className:this.layer.getClassName(),config:this.layer.getConfig()}},e=super.getConfig();return Object.assign(t,e),t}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.layer&&this.layer.setFastWeightInitDuringBuild(t)}static fromConfig(t,e,n={}){const s=Xu(e.layer,n);delete e.layer;const r={layer:s};return Object.assign(r,e),new t(r)}}class sd extends nd{constructor(t){super(t),this.supportsMasking=!0}build(t){if((t=Ut(t)).length<3)throw new o(`TimeDistributed layer expects an input shape >= 3D, but received input shape ${JSON.stringify(t)}`);this.inputSpec=[{shape:t}];const e=[t[0]].concat(t.slice(2));this.layer.built||(this.layer.build(e),this.layer.built=!0),super.build(t)}computeOutputShape(t){const e=[(t=Ut(t))[0]].concat(t.slice(2)),n=this.layer.computeOutputShape(e),s=t[1];return[n[0],s].concat(n.slice(1))}call(t,n){return e.tidy((()=>Yc(((t,e)=>[Wt(this.layer.call(t,n)),[]]),t=Wt(t),[],!1,null,null,!1,!0)[1]))}}sd.className="TimeDistributed",e.serialization.registerClass(sd);class rd extends nd{constructor(t){super(t);const e=t.layer.getConfig(),n={};n.className=t.layer.getClassName(),n.config=e,this.forwardLayer=Xu(n),e.goBackwards=!0!==e.goBackwards;const s={};var r;if(s.className=t.layer.getClassName(),s.config=e,this.backwardLayer=Xu(s),this.forwardLayer.name="forward_"+this.forwardLayer.name,this.backwardLayer.name="backward_"+this.backwardLayer.name,this.mergeMode=void 0===t.mergeMode?"concat":t.mergeMode,r=this.mergeMode,E(O,"BidirectionalMergeMode",r),t.weights)throw new l("weights support is not implemented for Bidirectional layer yet.");this._stateful=t.layer.stateful,this.returnSequences=t.layer.returnSequences,this.returnState=t.layer.returnState,this.supportsMasking=!0,this._trainable=!0,this.inputSpec=t.layer.inputSpec,this.numConstants=null}get trainable(){return this._trainable}set trainable(t){this._trainable=t,null!=this.forwardLayer&&(this.forwardLayer.trainable=t),null!=this.backwardLayer&&(this.backwardLayer.trainable=t)}getWeights(){return this.forwardLayer.getWeights().concat(this.backwardLayer.getWeights())}setWeights(t){const e=t.length,n=Math.floor(e/2);this.forwardLayer.setWeights(t.slice(0,n)),this.backwardLayer.setWeights(t.slice(n))}computeOutputShape(t){let e,n,s,r=this.forwardLayer.computeOutputShape(t);return Array.isArray(r)&&Array.isArray(r[0])||(r=[r]),this.returnState?(s=r.slice(1),e=r[0]):e=r[0],"concat"===this.mergeMode?(e[e.length-1]*=2,n=[e]):n=null==this.mergeMode?[e,e.slice()]:[e],this.returnState?null==this.mergeMode?n.concat(s).concat(s.slice()):[e].concat(s).concat(s.slice()):f(n)}apply(t,e){let n=null==e?null:e.initialState,s=null==e?null:e.constants;null==e&&(e={});const r=Zc(t,n,s,this.numConstants);if(t=r.inputs,n=r.initialState,s=r.constants,Array.isArray(t)&&(n=t.slice(1),t=t[0]),(null==n||0===n.length)&&null==s)return super.apply(t,e);const i=[],a=[];if(null!=n){const t=n.length;if(t%2>0)throw new o("When passing `initialState` to a Bidrectional RNN, the state should be an Array containing the states of the underlying RNNs.");e.initialState=n,i.push(...n);const s=n.map((t=>new Ht({shape:t.shape})));this.forwardLayer.stateSpec=s.slice(0,t/2),this.backwardLayer.stateSpec=s.slice(t/2),a.push(...s)}if(null!=s)throw new l("Support for constants in Bidirectional layers is not implemented yet.");const u=i[0]instanceof Jt;for(const t of i)if(t instanceof Jt!==u)throw new o("The initial state of a Bidirectional layer cannot be specified as a mix of symbolic and non-symbolic tensors");if(u){const n=[t].concat(i),s=this.inputSpec.concat(a),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,e);return this.inputSpec=r,o}return super.apply(t,e)}call(t,n){return e.tidy((()=>{const e=n.initialState;let s,i,a,o;if(null==e)s=this.forwardLayer.call(t,n),i=this.backwardLayer.call(t,n);else{const r=e.slice(0,e.length/2),a=e.slice(e.length/2);s=this.forwardLayer.call(t,Object.assign(n,{initialState:r})),i=this.backwardLayer.call(t,Object.assign(n,{initialState:a}))}return this.returnState&&(Array.isArray(s)&&(a=s.slice(1).concat(i.slice(1))),s=s[0],i=i[0]),this.returnSequences&&(i=r.reverse(i,1)),"concat"===this.mergeMode?o=at([s,i]):"sum"===this.mergeMode?o=r.add(s,i):"ave"===this.mergeMode?o=r.mul(.5,r.add(s,i)):"mul"===this.mergeMode?o=r.mul(s,i):null==this.mergeMode&&(o=[s,i]),this.returnState?null==this.mergeMode?o.concat(a):[o].concat(a):o}))}resetStates(t){this.forwardLayer.resetStates(),this.backwardLayer.resetStates()}build(t){K(this.forwardLayer.name,(()=>{this.forwardLayer.build(t)})),K(this.backwardLayer.name,(()=>{this.backwardLayer.build(t)})),this.built=!0}computeMask(t,e){let n;if(Array.isArray(e)&&(e=e[0]),n=this.returnSequences?null==this.mergeMode?[e,e]:e:null==this.mergeMode?[null,null]:null,this.returnState){const t=this.forwardLayer.states.map((t=>null));return Array.isArray(n)?n.concat(t).concat(t):[n].concat(t).concat(t)}return n}get trainableWeights(){return this.forwardLayer.trainableWeights.concat(this.backwardLayer.trainableWeights)}get nonTrainableWeights(){return this.forwardLayer.nonTrainableWeights.concat(this.backwardLayer.nonTrainableWeights)}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.forwardLayer&&this.forwardLayer.setFastWeightInitDuringBuild(t),null!=this.backwardLayer&&this.backwardLayer.setFastWeightInitDuringBuild(t)}getConfig(){const t={mergeMode:this.mergeMode},e=super.getConfig();return Object.assign(t,e),t}static fromConfig(t,e){const n=Xu(e.layer);if(delete e.layer,null!=e.numConstants)throw new l("Deserialization of a Bidirectional layer with numConstants present is not supported yet.");const s=e;return s.layer=n,new t(s)}}rd.className="Bidirectional",e.serialization.registerClass(rd);class id extends Qt{constructor(t){super(t),this.scale=t.scale,t.offset?this.offset=t.offset:this.offset=0}getConfig(){const t={scale:this.scale,offset:this.offset},e=super.getConfig();return Object.assign(t,e),t}call(t,n){return e.tidy((()=>("float32"!==(t=Wt(t)).dtype&&(t=et(t,"float32")),e.add(e.mul(t,this.scale),this.offset))))}}id.className="Rescaling",e.serialization.registerClass(id);const ad=new Set(["bilinear","nearest"]);class od extends Qt{constructor(t){if(super(t),this.height=t.height,this.width=t.width,t.interpolation){if(!ad.has(t.interpolation))throw new o(`Invalid interpolation parameter: ${t.interpolation} is not implemented`);this.interpolation=t.interpolation}else this.interpolation="bilinear";this.cropToAspectRatio=Boolean(t.cropToAspectRatio)}computeOutputShape(t){const e=(t=Ut(t))[2];return[this.height,this.width,e]}getConfig(){const t={height:this.height,width:this.width,interpolation:this.interpolation,cropToAspectRatio:this.cropToAspectRatio},e=super.getConfig();return Object.assign(t,e),t}call(t,n){return e.tidy((()=>{const n=[this.height,this.width];if("bilinear"===this.interpolation)return e.image.resizeBilinear(t,n,!this.cropToAspectRatio);if("nearest"===this.interpolation)return e.image.resizeNearestNeighbor(t,n,!this.cropToAspectRatio);throw new Error(`Interpolation is ${this.interpolation} but only ${[...ad]} are supported`)}))}}od.className="Resizing",e.serialization.registerClass(od);class ld extends Qt{constructor(t){super(t),this.numTokens=t.numTokens,t.outputMode?this.outputMode=t.outputMode:this.outputMode="multiHot"}getConfig(){const t={numTokens:this.numTokens,outputMode:this.outputMode},e=super.getConfig();return Object.assign(t,e),t}computeOutputShape(t){return null==(t=Ut(t))?[this.numTokens]:"oneHot"===this.outputMode&&1!==t[t.length-1]?(t.push(this.numTokens),t):(t[t.length-1]=this.numTokens,t)}call(t,n){return e.tidy((()=>{let s;if("int32"!==(t=Wt(t)).dtype&&(t=et(t,"int32")),"undefined"!=typeof n.countWeights){if("count"!==this.outputMode)throw new o(`countWeights is not used when outputMode !== count.\n              Received countWeights=${n.countWeights}`);s=Wt(n.countWeights)}const r=e.max(t),i=e.min(t),a=e.greater(this.numTokens,r).bufferSync().get(0),l=e.greaterEqual(i,0).bufferSync().get(0);if(!a||!l)throw new o(`Input values must be between 0 < values <= numTokens with numTokens=${this.numTokens}`);return function(t,n,s,r){let i=Wt(t);if("int32"!==i.dtype&&(i=et(i,"int32")),"int"===n)return i;const a=i.shape;if(0===i.rank&&(i=e.expandDims(i,-1)),"oneHot"===n&&1!==i.shape[i.shape.length-1]&&(i=e.expandDims(i,-1)),i.rank>2)throw new o(`When outputMode is not int, maximum output rank is 2 Received outputMode ${n} and input shape ${a} which would result in output rank ${i.rank}.`);const l=["multiHot","oneHot"].includes(n),u=i;let h;if(h="undefined"!=typeof r&&"count"===n?e.denseBincount(u,r,s,l):e.denseBincount(u,[],s,l),"tfIdf"!==n)return h;if(r)return e.mul(h,r);throw new o("When outputMode is 'tfIdf', weights must be provided.")}(t,this.outputMode,this.numTokens,s)}))}}function ud(t){return new Vp(t)}function hd(t){return new qp(t)}function cd(t){return new Jp(t)}function pd(t){return new Xp(t)}function dd(t){return new ed(t)}function fd(t){return new Up(t)}function gd(t){return new jp(t)}ld.className="CategoryEncoding",e.serialization.registerClass(ld);var md={__proto__:null,inputLayer:function(t){return new ee(t)},elu:function(t){return new zc(t)},reLU:function(t){return new Ic(t)},leakyReLU:function(t){return new Ac(t)},prelu:function(t){return new Tc(t)},softmax:function(t){return new Cc(t)},thresholdedReLU:function(t){return new $c(t)},conv1d:function(t){return new qc(t)},conv2d:function(t){return new Pc(t)},conv2dTranspose:function(t){return new Uc(t)},conv3d:function(t){return new Wc(t)},conv3dTranspose:function(t){return new Vc(t)},separableConv2d:function(t){return new jc(t)},cropping2D:function(t){return new Gc(t)},upSampling2d:function(t){return new Hc(t)},depthwiseConv2d:function(t){return new Jc(t)},activation:function(t){return new mp(t)},dense:function(t){return new fp(t)},dropout:function(t){return new pp(t)},spatialDropout1d:function(t){return new dp(t)},flatten:function(t){return new gp(t)},repeatVector:function(t){return new bp(t)},reshape:function(t){return new yp(t)},permute:function(t){return new wp(t)},embedding:function(t){return new vp(t)},add:function(t){return new Sp(t)},average:function(t){return new Ep(t)},concatenate:function(t){return new Tp(t)},maximum:function(t){return new Ip(t)},minimum:function(t){return new Ap(t)},multiply:function(t){return new Np(t)},dot:function(t){return new $p(t)},batchNormalization:function(t){return new Mp(t)},layerNormalization:function(t){return new Lp(t)},zeroPadding2d:function(t){return new Op(t)},averagePooling1d:ud,avgPool1d:function(t){return ud(t)},avgPooling1d:function(t){return ud(t)},averagePooling2d:hd,avgPool2d:function(t){return hd(t)},avgPooling2d:function(t){return hd(t)},averagePooling3d:cd,avgPool3d:function(t){return cd(t)},avgPooling3d:function(t){return cd(t)},globalAveragePooling1d:function(t){return new Yp(t)},globalAveragePooling2d:function(t){return new td(t)},globalMaxPooling1d:pd,globalMaxPooling2d:dd,maxPooling1d:fd,maxPooling2d:gd,maxPooling3d:function(t){return new Hp(t)},gru:function(t){return new sp(t)},gruCell:function(t){return new np(t)},lstm:function(t){return new ip(t)},lstmCell:function(t){return new rp(t)},simpleRNN:function(t){return new ep(t)},simpleRNNCell:function(t){return new tp(t)},convLstm2d:function(t){return new cp(t)},convLstm2dCell:function(t){return new hp(t)},rnn:function(t){return new Xc(t)},stackedRNNCells:function(t){return new ap(t)},bidirectional:function(t){return new rd(t)},timeDistributed:function(t){return new sd(t)},globalMaxPool1d:pd,globalMaxPool2d:dd,maxPool1d:fd,maxPool2d:gd,Layer:Qt,RNN:Xc,RNNCell:Qc,input:tc,gaussianNoise:function(t){return new Cp(t)},gaussianDropout:function(t){return new _p(t)},alphaDropout:function(t){return new Dp(t)},masking:function(t){return new kp(t)},rescaling:function(t){return new id(t)},resizing:function(t){return new od(t)},categoryEncoding:function(t){return new ld(t)}};var bd={__proto__:null,binaryAccuracy:function(t,e){return uh(t,e)},binaryCrossentropy:function(t,e){return fh(t,e)},sparseCategoricalAccuracy:function(t,e){return gh(t,e)},categoricalAccuracy:function(t,e){return hh(t,e)},categoricalCrossentropy:function(t,e){return mh(t,e)},precision:function(t,e){return ph(t,e)},recall:function(t,e){return dh(t,e)},cosineProximity:function(t,e){return ah(t,e)},meanAbsoluteError:function(t,e){return eh(t,e)},meanAbsolutePercentageError:function(t,e){return nh(t,e)},MAPE:function(t,e){return nh(t,e)},mape:function(t,e){return nh(t,e)},meanSquaredError:function(t,e){return th(t,e)},MSE:function(t,e){return th(t,e)},mse:function(t,e){return th(t,e)}},yd={__proto__:null,modelFromJSON:async function(t,n){"modelTopology"in t||(t={modelTopology:t});let s=t.modelTopology;null!=s.model_config&&(s=s.model_config);const r=Xu(zh(s),n);if(null!=t.weightsManifest){const n=await e.io.loadWeights(t.weightsManifest,t.pathPrefix,r.weights.map((t=>t.originalName))),s={};for(const t of r.weights)s[t.originalName]=n[t.originalName];r.loadWeights(s),e.dispose(n)}return r}};var wd={__proto__:null,l1l2:function(t){return new vc(t)},l1:function(t){return wc(e=t),new vc({l1:null!=e?e.l1:null,l2:0});var e},l2:function(t){return wc(e=t),new vc({l2:null!=e?e.l2:null,l1:0});var e}};class kd extends Ku{constructor(){super(...arguments),this.model=null}setModel(t){if(!(t instanceof Yh))throw new Error("model must be a LayersModel, not some other Container");this.model=t}}function vd(t,e){return t<e}function xd(t,e){return t>e}class Sd extends kd{constructor(t){if(super(),null==t&&(t={}),t.restoreBestWeights)throw new l("restoreBestWeights = True is not implemented in EarlyStopping yet.");this.monitor=t.monitor||"val_loss",this.minDelta=Math.abs(t.minDelta||0),this.patience=t.patience||0,this.verbose=t.verbose||0,this.mode=t.mode||"auto",this.baseline=t.baseline,-1===["auto","min","max"].indexOf(this.mode)&&(console.warn(`EarlyStopping mode '${this.mode}' is invalid. Falling back to mode 'auto'.`),this.mode="auto"),"min"===this.mode?this.monitorFunc=vd:"max"===this.mode||-1!==this.monitor.indexOf("acc")?this.monitorFunc=xd:this.monitorFunc=vd,this.monitorFunc===vd&&(this.minDelta*=-1)}async onTrainBegin(t){this.wait=0,this.stoppedEpoch=0,null!=this.baseline?this.best=this.baseline:this.best=this.monitorFunc===vd?1/0:-1/0}async onEpochEnd(t,e){await Uu(e);const n=this.getMonitorValue(e);null!=n&&(this.monitorFunc(n-this.minDelta,this.best)?(this.best=n,this.wait=0):(this.wait++,this.wait>=this.patience&&(this.stoppedEpoch=t,this.model.stopTraining=!0)))}async onTrainEnd(t){this.stoppedEpoch>0&&this.verbose&&console.log(`Epoch ${this.stoppedEpoch}: early stopping.`)}getMonitorValue(t){null==t&&(t={});const e=t[this.monitor];return null==e&&console.warn(`Metric for EarlyStopping ${this.monitor} is not available. Available metrics are: ${Object.keys(t)}`),e}}const Nd={earlyStopping:function(t){return new Sd(t)}};t.Callback=kd,t.CallbackList=ju,t.CustomCallback=Hu,t.EarlyStopping=Sd,t.History=Gu,t.InputSpec=Ht,t.LayerVariable=jt,t.LayersModel=Yh,t.RNN=Xc,t.Sequential=Qh,t.SymbolicTensor=Jt,t.callbacks=Nd,t.constraints=Bu,t.initializers=Wu,t.input=tc,t.layers=md,t.loadLayersModel=async function(t,n){if(null==n&&(n={}),"string"==typeof t){const s=e.io.getLoadHandlers(t,n);if(0===s.length)s.push(e.io.browserHTTPRequest(t,n));else if(s.length>1)throw new o(`Found more than one (${s.length}) load handlers for URL '${t}'`);t=s[0]}return async function(t,n,s){null==s&&(s={});if(null==t.load)throw new o("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const r=await t.load();let i=r.modelTopology;null!=i.model_config&&(i=i.model_config);const a=null==s.strict||s.strict,l=null!=r.weightData&&null!=r.weightSpecs&&a,u=Xu(zh(i),n,l),h=r.trainingConfig;null!=h&&u.loadTrainingConfig(h);null!=r.userDefinedMetadata&&u.setUserDefinedMetadata(r.userDefinedMetadata);if(null!=r.weightData){if(null==r.weightSpecs)throw new o("LayersModel artifacts contains weight data, but not weight specs. Therefore loading of weights cannot proceed.");const{modelWeights:t,optimizerWeights:n}=function(t,n){const s=e.io.decodeWeights(t,n),r={},i=[];return n.forEach((t=>{"optimizer"===t.group?i.push({name:t.name,tensor:s[t.name]}):r[t.name]=s[t.name]})),{modelWeights:r,optimizerWeights:i}}(r.weightData,r.weightSpecs);u.loadWeights(t,a),null!=u.optimizer&&n.length>0&&await u.optimizer.setWeights(n),e.dispose(t),e.dispose(n.map((t=>t.tensor)))}return u}(t,void 0,n)},t.metrics=bd,t.model=function(t){return new Yh(t)},t.models=yd,t.registerCallbackConstructor=function(t,e){Zu.registerCallbackConstructor(t,e)},t.regularizers=wd,t.sequential=function(t){return new Qh(t)},t.version_layers=Ch,Object.defineProperty(t,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-layers.es2017.min.js.map
