/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import*as t from"@tensorflow/tfjs-core";import{util as e,backend as n,tidy as s,tensor1d as r,serialization as i,zeros as a,ones as o,mul as l,scalar as u,randomUniform as h,truncatedNormal as c,eye as p,linalg as d,transpose as f,dispose as g,memory as m,cast as b,env as y,nextFrame as w,add as k,div as v,keep as x,train as S,clone as N,argMax as E,reshape as I,Tensor as A,Optimizer as T,io as $,sum as C,abs as z,relu as _,clipByValue as D,leakyRelu as F,prelu as R,elu as M,greater as L,any as O,notEqual as B,zerosLike as P,greaterEqual as W,moments as U,image as V,expandDims as K,denseBincount as j,max as q,min as G}from"@tensorflow/tfjs-core";function H(t,e){return e.forEach((function(e){Object.keys(e).forEach((function(n){if("default"!==n&&!(n in t)){var s=Object.getOwnPropertyDescriptor(e,n);Object.defineProperty(t,n,s.get?s:{enumerable:!0,get:function(){return e[n]}})}}))})),t}class J extends Error{constructor(t){super(t),Object.setPrototypeOf(this,J.prototype)}}class Z extends Error{constructor(t){super(t),Object.setPrototypeOf(this,Z.prototype)}}class Y extends Error{constructor(t){super(t),Object.setPrototypeOf(this,Y.prototype)}}class X extends Error{constructor(t){super(t),Object.setPrototypeOf(this,X.prototype)}}class Q extends Error{constructor(t){super(t),Object.setPrototypeOf(this,Q.prototype)}}class tt{constructor(t){this.maxEntries=t||100,this.cache=new Map}get(t){let e;return this.cache.has(t)&&(e=this.cache.get(t),this.cache.delete(t),this.cache.set(t,e)),e}put(t,e){if(this.cache.has(t))this.cache.delete(t);else if(this.cache.size>=this.maxEntries){const t=this.cache.keys().next().value;this.cache.delete(t)}this.cache.set(t,e)}getMaxEntries(){return this.maxEntries}setMaxEntries(t){if(t<0)throw new Error(`The maxEntries of LRU caches must be at least 0, but got ${t}.`);if(this.maxEntries>t)for(let e=0;e<this.maxEntries-t;e++){const t=this.cache.keys().next().value;this.cache.delete(t)}this.maxEntries=t}}function et(t,e){if(Array.isArray(t)){let n=[];for(let s=0;s<e;s++)n=n.concat(t);return n}{const n=new Array(e);return n.fill(t),n}}function nt(t,e){if(!t)throw new Q(e)}function st(t,e){let n=0;for(const s of t)s===e&&n++;return n}function rt(t){return 1===t.length?t[0]:t}function it(t){return Array.isArray(t)?t:[t]}function at(t){const e=t.replace(/(.)([A-Z][a-z0-9]+)/g,"$1_$2").replace(/([a-z])([A-Z])/g,"$1_$2").toLowerCase();return"_"!==e[0]?e:"private"+e}function ot(t){return t.length<=1||-1===t.indexOf("_")?t:t.replace(/[_]+(\w|$)/g,((t,e)=>e.toUpperCase()))}let lt={};function ut(t){if(null==t)return null;const e={};return e.className=t.getClassName(),e.config=t.getConfig(),e}function ht(t){if(null!=t&&"object"==typeof t)if(Array.isArray(t))t.forEach((t=>ht(t)));else{const e=Object.keys(t);for(const n of e){const e=t[n];null!=e&&"object"==typeof e&&(Array.isArray(e)||"ndarray"!==e.type||"number"!=typeof e.value?ht(e):t[n]=e.value)}}}function ct(t,e={},n={},s="object",r=!1){if("string"==typeof t){const r=t;let i;if(r in n)i=n[r];else if(r in lt)i=lt[r];else if(i=e[r],null==i)throw new Y(`Unknown ${s}: ${t}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);return i}{const i=t;if(null==i.className||null==i.config)throw new Y(`${s}: Improper config format: ${JSON.stringify(i)}.\n'className' and 'config' must set.`);const a=i.className;let o,l;if(a in n?[o,l]=n[a]:a in lt?[o,l]=lt.className:a in e&&([o,l]=e[a]),null==o)throw new Y(`Unknown ${s}: ${a}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);if(null!=l){const t={};for(const e of Object.keys(lt))t[e]=lt[e];for(const e of Object.keys(n))t[e]=n[e];i.config.customObjects=t;const e=Object.assign({},lt);for(const t of Object.keys(n))lt[t]=n[t];ht(i.config);const s=l(o,i.config,n,r);return lt=Object.assign({},e),s}{const t=Object.assign({},lt);for(const t of Object.keys(n))lt[t]=n[t];const e=new o(i.config);return lt=Object.assign({},t),e}}}function pt(t,e){return-1*function(t,e){return t<e?-1:t>e?1:0}(t,e)}function dt(t){if(null==t)return t;const e=[];for(const n of t)-1===e.indexOf(n)&&e.push(n);return e}function ft(t){if(null==t)throw new Y(`Invalid value in obj: ${JSON.stringify(t)}`);for(const e in t)if(t.hasOwnProperty(e))return!1;return!0}function gt(t,e,n){if(null!=n&&t.indexOf(n)<0)throw new Y(`${n} is not a valid ${e}.  Valid values are ${t} or null/undefined.`)}function mt(t,e,n=0,s=1/0){return nt(n>=0),nt(s>=n),Array.isArray(t)&&t.length>=n&&t.length<=s&&t.every((t=>typeof t===e))}function bt(t,n){Array.isArray(t)?(e.assert(t.length>0,(()=>`${n} is unexpectedly an empty array.`)),t.forEach(((t,e)=>bt(t,`element ${e+1} of ${n}`)))):e.assert(Number.isInteger(t)&&t>0,(()=>`Expected ${n} to be a positive integer, but got ${yt(t)}.`))}function yt(t){return null===t?"null":Array.isArray(t)?"["+t.map((t=>yt(t))).join(",")+"]":"string"==typeof t?`"${t}"`:`${t}`}function wt(t){return"relu"===t?"relu":"linear"===t?"linear":"elu"===t?"elu":null}let kt=0;function vt(){return kt++}const xt={};function St(t=""){return t in xt||(xt[t]=0),xt[t]+=1,t+xt[t].toString()}const Nt=["channelsFirst","channelsLast"],Et=["nearest","bilinear"],It=["valid","same","causal"],At=["max","avg"],Tt=["sum","mul","concat","ave"],$t=new Map;function Ct(t){gt(Nt,"DataFormat",t)}function zt(t){gt(It,"PaddingMode",t)}function _t(t){gt(At,"PoolMode",t)}const Dt=[];function Ft(t,e){Dt.push(t);try{const t=e();return Dt.pop(),t}catch(t){throw Dt.pop(),t}}function Rt(t){if(!Ot(t))throw new Error("Not a valid tensor name: '"+t+"'");return(0===Dt.length?"":Dt.join("/")+"/")+t}function Mt(t){if(!Ot(t))throw new Error("Not a valid tensor name: '"+t+"'");$t.has(t)||$t.set(t,0);const e=$t.get(t);if($t.set(t,$t.get(t)+1),e>0){const n=`${t}_${e}`;return $t.set(n,1),n}return t}const Lt=new RegExp(/^[A-Za-z0-9][-A-Za-z0-9\._\/]*$/);function Ot(t){return!!t.match(Lt)}function Bt(t,e,n){null==e&&(e=0),null==n&&(n=t.length);let s=1;for(let r=e;r<n;++r)s*=t[r];return s}function Pt(t){if(0===t.length)return Number.NaN;let e=Number.POSITIVE_INFINITY;for(let n=0;n<t.length;n++){const s=t[n];s<e&&(e=s)}return e}function Wt(t){if(0===t.length)return Number.NaN;let e=Number.NEGATIVE_INFINITY;for(let n=0;n<t.length;n++){const s=t[n];s>e&&(e=s)}return e}function Ut(t,e){if(e<t)throw new Y(`end (${e}) < begin (${t}) is forbidden.`);const n=[];for(let s=t;s<e;++s)n.push(s);return n}let Vt;function Kt(){return null==Vt&&(Vt=n().epsilon()),Vt}function jt(e,n){return t.cast(e,n)}function qt(e,n=-1){const s=e.shape.slice();return n<0&&(n=s.length+n+1),s.splice(n,0,1),t.reshape(e,s)}function Gt(e,n,r){return s((()=>{switch(e.rank){case 1:return t.slice1d(e,n,r);case 2:return t.slice2d(e,[n,0],[r,e.shape[1]]);case 3:return t.slice3d(e,[n,0,0],[r,e.shape[1],e.shape[2]]);case 4:return t.slice4d(e,[n,0,0,0],[r,e.shape[1],e.shape[2],e.shape[3]]);case 5:return t.slice(e,[n,0,0,0,0],[r,e.shape[1],e.shape[2],e.shape[3],e.shape[4]]);case 6:return t.slice(e,[n,0,0,0,0,0],[r,e.shape[1],e.shape[2],e.shape[3],e.shape[4],e.shape[5]]);default:throw new Y(`sliceAlongFirstAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function Ht(e,n,r){return s((()=>{switch(e.rank){case 1:return t.slice1d(e,n,r);case 2:return t.slice2d(e,[0,n],[e.shape[0],r]);case 3:return t.slice3d(e,[0,0,n],[e.shape[0],e.shape[1],r]);case 4:return t.slice4d(e,[0,0,0,n],[e.shape[0],e.shape[1],e.shape[2],r]);default:throw new Y(`sliceAlongLastAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function Jt(e,n,r,i){return s((()=>{switch(e.rank){case 1:return t.slice1d(e,n,r);case 2:switch(i){case 1:return Gt(e,n,r);case 2:return Ht(e,n,r);default:throw new Y(`The axis is not within the rank of the tensor ${i}`)}case 3:switch(i){case 1:return Gt(e,n,r);case 2:return t.slice3d(e,[0,n,0],[e.shape[0],r,e.shape[2]]);case 3:return Ht(e,n,r);default:throw new Y(`The axis is not within the rank of the tensor ${i}`)}case 4:switch(i){case 1:return Gt(e,n,r);case 2:return t.slice4d(e,[0,n,0,0],[e.shape[0],r,e.shape[2],e.shape[3]]);case 3:return t.slice4d(e,[0,0,n,0],[e.shape[0],e.shape[1],r,e.shape[3]]);case 4:return Ht(e,n,r);default:throw new Y(`The axis is not within the rank of the tensor ${i}`)}default:throw new Y(`sliceAlongLastAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function Zt(e,n=-1){let s;return n<0&&(s=e[0].rank,n=0!==s?s:0),n===e[0].rank&&(n=-1),t.concat(e,n)}function Yt(e,n){switch(e.rank){case 1:return t.concat1d([e,n]);case 2:return t.concat2d([e,n],0);case 3:return t.concat3d([e,n],0);case 4:return t.concat4d([e,n],0);default:throw new Y(`concatAlongFirstAxis() received an unsupported tensor rank: ${e.rank}`)}}function Xt(e,n){if(Array.isArray(n)||(n=[n]),e.rank!==n.length)throw new Y(`The length of input n (${n.length}) does not match the number of dimensions in input x (${e.rank})`);return t.tile(e,n)}function Qt(e,n=0,s=1,r,i){return t.randomNormal(e,n,s,r,i)}function te(e,n,s,r){if(e.rank<2||n.rank<2)throw new X(`dot requires both inputs to be rank >= 2 but got x shape = ${e.shape} and y shape = ${n.shape}`);if(n.rank>=3){if(e.shape.slice(-1)[0]!==n.shape.slice(-2)[0])throw new X(`If rank y >= 3, then the second last dim of y must equal the last dim of x but got x shape = ${e.shape} and  y shape = ${n.shape}`)}if(2===e.rank&&2===n.rank){const i=!1,a=!1;return t.fused.matMul({a:e,b:n,transposeA:i,transposeB:a,bias:r?se(e.rank,r,"channelsLast"):null,activation:s})}{const i=e.shape.slice(),a=i.pop();e=t.reshape(e,[-1,a]);const o=n.shape.slice(),l=o.pop(),u=o.pop(),h=[...o,l],c=Array.from({length:n.rank},((t,e)=>0===e?n.rank-2:e<=n.rank-2?e-1:e));n=t.reshape(t.transpose(n,c),[u,-1]);const p=[...i,...h],d=!1,f=!1;return t.reshape(t.fused.matMul({a:e,b:n,transposeA:d,transposeB:f,bias:r?se(e.rank,r,"channelsLast"):null,activation:s}),p)}}function ee(e,n,i){return s((()=>(n=Array.isArray(n)?r(n,"int32"):t.cast(n,"int32"),t.gather(e,n,i))))}function ne(e){return t.mul(e,e)}function se(e,n,s){const r=n.shape;if(1!==n.rank&&n.rank!==e)throw new Y(`Unexpected bias dimensions: ${n.rank}; expected it to be 1 or ${e}`);if(5===e){if("channelsFirst"===s)return 1===r.length?t.reshape(n,[1,r[0],1,1,1]):t.reshape(n,[1,r[3],r[0],r[1],r[2]]);if("channelsLast"===s)return 1===r.length?t.reshape(n,[1,1,1,1,r[0]]):t.reshape(n,[1].concat(r))}else if(4===e){if("channelsFirst"===s)return 1===r.length?t.reshape(n,[1,r[0],1,1]):t.reshape(n,[1,r[2],r[0],r[1]]);if("channelsLast"===s)return 1===r.length?t.reshape(n,[1,1,1,r[0]]):t.reshape(n,[1].concat(r))}else if(3===e){if("channelsFirst"===s)return 1===r.length?t.reshape(n,[1,r[0],1]):t.reshape(n,[1,r[1],r[0]]);if("channelsLast"===s)return 1===r.length?t.reshape(n,[1,1,r[0]]):t.reshape(n,[1].concat(r))}else if(e<3)return n;throw new Y(`Unsupported input rank by biasAdd: ${n.rank}`)}function re(e,n,r){return s((()=>(null==r&&(r="channelsLast"),Ct(r),t.add(e,se(e.rank,n,r)))))}function ie(e,n,r,i){return s((()=>t.dropout(e,n,r,i)))}function ae(t,e,n=!1){return n?t():e()}const oe=["fanIn","fanOut","fanAvg"],le=["normal","uniform","truncatedNormal"];class ue extends i.Serializable{fromConfigUsesCustomObjects(){return!1}getConfig(){return{}}}class he extends ue{apply(t,e){return a(t,e)}}he.className="Zeros",i.registerClass(he);class ce extends ue{apply(t,e){return o(t,e)}}ce.className="Ones",i.registerClass(ce);class pe extends ue{constructor(t){if(super(),"object"!=typeof t)throw new Y(`Expected argument of type ConstantConfig but got ${t}`);if(void 0===t.value)throw new Y(`config must have value set but got ${t}`);this.value=t.value}apply(t,e){return s((()=>l(u(this.value),o(t,e))))}getConfig(){return{value:this.value}}}pe.className="Constant",i.registerClass(pe);class de extends ue{constructor(t){super(),this.DEFAULT_MINVAL=-.05,this.DEFAULT_MAXVAL=.05,this.minval=t.minval||this.DEFAULT_MINVAL,this.maxval=t.maxval||this.DEFAULT_MAXVAL,this.seed=t.seed}apply(t,e){return h(t,this.minval,this.maxval,e)}getConfig(){return{minval:this.minval,maxval:this.maxval,seed:this.seed}}}de.className="RandomUniform",i.registerClass(de);class fe extends ue{constructor(t){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=t.mean||this.DEFAULT_MEAN,this.stddev=t.stddev||this.DEFAULT_STDDEV,this.seed=t.seed}apply(t,e){if("float32"!==(e=e||"float32")&&"int32"!==e)throw new X(`randomNormal does not support dType ${e}.`);return Qt(t,this.mean,this.stddev,e,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}fe.className="RandomNormal",i.registerClass(fe);class ge extends ue{constructor(t){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=t.mean||this.DEFAULT_MEAN,this.stddev=t.stddev||this.DEFAULT_STDDEV,this.seed=t.seed}apply(t,e){if("float32"!==(e=e||"float32")&&"int32"!==e)throw new X(`truncatedNormal does not support dType ${e}.`);return c(t,this.mean,this.stddev,e,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}ge.className="TruncatedNormal",i.registerClass(ge);class me extends ue{constructor(t){super(),this.gain=null!=t.gain?t.gain:1}apply(t,e){return s((()=>{if(2!==t.length||t[0]!==t[1])throw new Y("Identity matrix initializer can only be used for 2D square matrices.");return l(this.gain,p(t[0]))}))}getConfig(){return{gain:this.gain}}}me.className="Identity",i.registerClass(me);class be extends ue{constructor(t){if(super(),t.scale<0)throw new Y(`scale must be a positive float. Got: ${t.scale}`);var e;this.scale=null==t.scale?1:t.scale,this.mode=null==t.mode?"fanIn":t.mode,e=this.mode,gt(oe,"FanMode",e),this.distribution=null==t.distribution?"normal":t.distribution,function(t){gt(le,"Distribution",t)}(this.distribution),this.seed=t.seed}apply(t,e){const n=function(t,e="channelsLast"){let n,s;if(Ct(e),2===t.length)n=t[0],s=t[1];else if(-1!==[3,4,5].indexOf(t.length)){if("channelsFirst"===e){const e=Bt(t,2);n=t[1]*e,s=t[0]*e}else if("channelsLast"===e){const e=Bt(t,0,t.length-2);n=t[t.length-2]*e,s=t[t.length-1]*e}}else{const e=Bt(t);n=Math.sqrt(e),s=Math.sqrt(e)}return[n,s]}(t),s=n[0],r=n[1];let i=this.scale;if("fanIn"===this.mode?i/=Math.max(1,s):"fanOut"===this.mode?i/=Math.max(1,r):i/=Math.max(1,(s+r)/2),"normal"===this.distribution){const n=Math.sqrt(i);if("float32"!==(e=e||"float32")&&"int32"!==e)throw new X(`${this.getClassName()} does not support dType ${e}.`);return c(t,0,n,e,this.seed)}{const n=Math.sqrt(3*i);return h(t,-n,n,e)}}getConfig(){return{scale:this.scale,mode:this.mode,distribution:this.distribution,seed:this.seed}}}be.className="VarianceScaling",i.registerClass(be);class ye extends be{constructor(t){super({scale:1,mode:"fanAvg",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return be.className}}ye.className="GlorotUniform",i.registerClass(ye);class we extends be{constructor(t){super({scale:1,mode:"fanAvg",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return be.className}}we.className="GlorotNormal",i.registerClass(we);class ke extends be{constructor(t){super({scale:2,mode:"fanIn",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return be.className}}ke.className="HeNormal",i.registerClass(ke);class ve extends be{constructor(t){super({scale:2,mode:"fanIn",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return be.className}}ve.className="HeUniform",i.registerClass(ve);class xe extends be{constructor(t){super({scale:1,mode:"fanIn",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return be.className}}xe.className="LeCunNormal",i.registerClass(xe);class Se extends be{constructor(t){super({scale:1,mode:"fanIn",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return be.className}}Se.className="LeCunNormal",i.registerClass(Se);class Ne extends ue{constructor(t){if(super(),this.DEFAULT_GAIN=1,this.gain=null==t.gain?this.DEFAULT_GAIN:t.gain,this.seed=t.seed,null!=this.seed)throw new X("Random seed is not implemented for Orthogonal Initializer yet.")}apply(t,e){return s((()=>{if(t.length<2)throw new X("Shape must be at least 2D.");t[0]*t[1]>2e3&&console.warn(`Orthogonal initializer is being called on a matrix with more than 2000 (${t[0]*t[1]}) elements: Slowness may result.`);const e=Qt(t[0]>t[1]?[t[1],t[0]]:t,0,1,"float32");let n=d.gramSchmidt(e);return t[0]>t[1]&&(n=f(n)),l(this.gain,n)}))}getConfig(){return{gain:this.gain,seed:this.seed}}}Ne.className="Orthogonal",i.registerClass(Ne);const Ee={constant:"Constant",glorotNormal:"GlorotNormal",glorotUniform:"GlorotUniform",heNormal:"HeNormal",heUniform:"HeUniform",identity:"Identity",leCunNormal:"LeCunNormal",leCunUniform:"LeCunUniform",ones:"Ones",orthogonal:"Orthogonal",randomNormal:"RandomNormal",randomUniform:"RandomUniform",truncatedNormal:"TruncatedNormal",varianceScaling:"VarianceScaling",zeros:"Zeros"};function Ie(t,e={}){return ct(t,i.SerializationMap.getMap().classNameMap,e,"initializer")}function Ae(t){return ut(t)}function Te(t){if("string"==typeof t){const e=t in Ee?Ee[t]:t;if("GlorotNormal"===e)return new we;if("GlorotUniform"===e)return new ye;if("HeNormal"===e)return new ke;if("HeUniform"===e)return new ve;if("LeCunNormal"===e)return new xe;if("LeCunUniform"===e)return new Se;{const t={};return t.className=e,t.config={},Ie(t)}}return t instanceof ue?t:Ie(t)}function $e(t){return Array.isArray(t)&&Array.isArray(t[0])}function Ce(t){return 0===t.length?[]:Array.isArray(t[0])?t:[t]}function ze(t){let e;if(Array.isArray(t)){if(1!==t.length)throw new Y(`Expected Tensor length to be 1; got ${t.length}`);e=t[0]}else e=t;return e}function _e(t){if(Array.isArray(t)&&Array.isArray(t[0])){if(1===t.length)return t[0];throw new Y(`Expected exactly 1 Shape; got ${t.length}`)}return t}function De(t){let e=0;for(const n of t)0===n.shape.length?e+=1:e+=n.shape.reduce(((t,e)=>t*e));return e}class Fe{constructor(e,n="float32",s="Variable",r=!0,i=null){this.dtype=null==n?"float32":n,this.shape=e.shape,this.id=vt(),s=null==s?"Variable":s,this.originalName=Rt(s),this.name=Mt(this.originalName),this.trainable_=r,this.constraint=i,this.val=t.variable(e,this.trainable_,this.name,this.dtype)}read(){return this.assertNotDisposed(),this.val}write(t){return this.assertNotDisposed(),function(t,e){if(t.shape.toString()!==e.shape.toString())throw new Error("Shape mismatch: "+JSON.stringify(t.shape)+" vs. "+JSON.stringify(e.shape))}(this.val,t),this.val.id!==t.id&&(this.val.assign(t),null!=this.constraint&&this.val.assign(this.constraint.apply(this.val))),this}dispose(){this.assertNotDisposed(),this.val.dispose()}assertNotDisposed(){if(this.val.isDisposed)throw new Error(`LayersVariable ${this.name} is already disposed.`)}get trainable(){return this.trainable_}set trainable(t){this.trainable_=t,this.val.trainable=t}}function Re(t){return t.map((t=>t.read()))}function Me(t){t.forEach((t=>{t[0].write(t[1])}))}class Le{constructor(t){this.dtype=t.dtype,this.shape=t.shape,null!=t.shape?this.ndim=t.shape.length:this.ndim=t.ndim,this.maxNDim=t.maxNDim,this.minNDim=t.minNDim,this.axes=t.axes||{}}}class Oe{constructor(t,e,n,s,r,i,a){this.dtype=t,this.shape=e,this.sourceLayer=n,this.inputs=s,this.callArgs=r,this.outputTensorIndex=a,this.id=vt(),null!=i&&(this.originalName=Rt(i),this.name=Mt(this.originalName)),this.rank=e.length}}let Be=0;class Pe{constructor(t,e){this.callArgs=e,this.id=Be++,this.outboundLayer=t.outboundLayer,this.inboundLayers=t.inboundLayers,this.nodeIndices=t.nodeIndices,this.tensorIndices=t.tensorIndices,this.inputTensors=t.inputTensors,this.outputTensors=t.outputTensors,this.inputMasks=t.inputMasks,this.outputMasks=t.outputMasks,this.inputShapes=t.inputShapes,this.outputShapes=t.outputShapes;for(const e of t.inboundLayers)null!=e&&e.outboundNodes.push(this);t.outboundLayer.inboundNodes.push(this)}getConfig(){const t=[];for(const e of this.inboundLayers)null!=e?t.push(e.name):t.push(null);return{outboundLayer:this.outboundLayer?this.outboundLayer.name:null,inboundLayers:t,nodeIndices:this.nodeIndices,tensorIndices:this.tensorIndices}}}let We=0;class Ue extends i.Serializable{constructor(t={}){super(),this._callHook=null,this._addedWeightNames=[],this._stateful=!1,this.id=We++,this.activityRegularizer=null,this.inputSpec=null,this.supportsMasking=!1,this._trainableWeights=[],this._nonTrainableWeights=[],this._losses=[],this._updates=[],this._built=!1,this.inboundNodes=[],this.outboundNodes=[];let e=t.name;if(!e){const t=this.getClassName();e=at(t)+"_"+St(t)}if(this.name=e,this.trainable_=null==t.trainable||t.trainable,null!=t.inputShape||null!=t.batchInputShape){let e;if(null!=t.batchInputShape)e=t.batchInputShape;else if(null!=t.inputShape){let n=null;null!=t.batchSize&&(n=t.batchSize),e=[n].concat(t.inputShape)}this.batchInputShape=e;let n=t.dtype;null==n&&(n=t.inputDType),null==n&&(n="float32"),this.dtype=n}null!=t.weights?this.initialWeights=t.weights:this.initialWeights=null,this._refCount=null,this.fastWeightInitDuringBuild=!1}static nodeKey(t,e){return t.name+"_ib-"+e.toString()}getNodeAtIndex(t,e){if(0===this.inboundNodes.length)throw new Z(`The layer has never been called and thus has no defined ${e}.`);if(this.inboundNodes.length<=t)throw new Y(`Asked to get ${e} at node ${t}, but the layer has only ${this.inboundNodes.length} inbound nodes.`);return this.inboundNodes[t]}getInputAt(t){return rt(this.getNodeAtIndex(t,"input").inputTensors)}getOutputAt(t){return rt(this.getNodeAtIndex(t,"output").outputTensors)}get input(){if(this.inboundNodes.length>1)throw new J(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer input" is ill-defined. Use \`getInputAt(nodeIndex)\` instead.`);if(0===this.inboundNodes.length)throw new J(`Layer ${this.name} is not connected, no input to return.`);return rt(this.getNodeAtIndex(0,"input").inputTensors)}get output(){if(0===this.inboundNodes.length)throw new J(`Layer ${this.name} has no inbound nodes.`);if(this.inboundNodes.length>1)throw new J(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer output" is ill-defined. Use \`getOutputAt(nodeIndex)\` instead.`);return rt(this.getNodeAtIndex(0,"output").outputTensors)}get losses(){return this._losses}calculateLosses(){return this.losses.map((t=>t()))}get updates(){return this._updates}get built(){return this._built}set built(t){this._built=t}get trainable(){return this.trainable_}set trainable(t){this._trainableWeights.forEach((e=>e.trainable=t)),this.trainable_=t}get trainableWeights(){return this.trainable_?this._trainableWeights.filter((t=>t.trainable)):[]}set trainableWeights(t){this._trainableWeights=t}get nonTrainableWeights(){return this.trainable?this._trainableWeights.filter((t=>!t.trainable)).concat(this._nonTrainableWeights):this._trainableWeights.concat(this._nonTrainableWeights)}set nonTrainableWeights(t){this._nonTrainableWeights=t}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}get stateful(){return this._stateful}resetStates(){if(!this.stateful)throw new Error("Cannot call the resetStates() method of a non-stateful Layer object.")}assertInputCompatibility(t){if(t=it(t),null==this.inputSpec||0===this.inputSpec.length)return;const e=it(this.inputSpec);if(t.length!==e.length)throw new Y(`Layer ${this.name} expects ${e.length} inputs, but it received ${t.length} input tensors. Input received: ${t}`);for(let n=0;n<t.length;n++){const s=t[n],r=e[n];if(null==r)continue;const i=s.rank;if(null!=r.ndim&&i!==r.ndim)throw new Y(`Input ${n} is incompatible with layer ${this.name}: expected ndim=${r.ndim}, found ndim=${i}`);if(null!=r.maxNDim&&i>r.maxNDim)throw new Y(`Input ${n} is incompatible with layer ${this.name}: expected max_ndim=${r.maxNDim}, found ndim=${i}`);if(null!=r.minNDim&&i<r.minNDim)throw new Y(`Input ${n} is incompatible with layer ${this.name}: expected min_ndim=${r.minNDim}, found ndim=${i}.`);if(null!=r.dtype&&s.dtype!==r.dtype)throw new Y(`Input ${n} is incompatible with layer ${this.name} : expected dtype=${r.dtype}, found dtype=${s.dtype}.`);if(r.axes){const t=s.shape;for(const e in r.axes){const s=Number(e),i=r.axes[e],a=s>=0?t[s]:t[t.length+s];if(null!=i&&-1===[i,null].indexOf(a))throw new Y(`Input ${n} is incompatible with layer ${this.name}: expected axis ${s} of input shape to have value ${i} but got shape ${t}.`)}}if(null!=r.shape)for(let t=0;t<r.shape.length;++t){const e=r.shape[t],i=s.shape[t];if(null!=e&&null!=i&&e!==i)throw new Y(`Input ${n} is incompatible with layer ${this.name}: expected shape=${r.shape}, found shape=${s.shape}.`)}}}call(t,e){return t}invokeCallHook(t,e){null!=this._callHook&&this._callHook(t,e)}setCallHook(t){this._callHook=t}clearCallHook(){this._callHook=null}apply(t,e){e=e||{},this.assertNotDisposed();const n=it(t);let s=!0;for(const t of n)if(!(t instanceof Oe)){s=!1;break}let r=!0;for(const t of n)if(t instanceof Oe){r=!1;break}if(s===r)throw new Y("Arguments to apply() must be all SymbolicTensors or all Tensors");return Ft(this.name,(()=>{if(!this.built){this.assertInputCompatibility(t);const e=[];for(const n of it(t))e.push(n.shape);this.build(rt(e)),this.built=!0,this.initialWeights&&this.setWeights(this.initialWeights),null===this._refCount&&r&&(this._refCount=1)}if(this.assertInputCompatibility(t),r){let s=this.call(t,e);const r=it(s),i=[];for(let t of r)-1!==n.indexOf(t)&&(t=t.clone()),i.push(t);if(s=rt(i),null!=this.activityRegularizer)throw new X("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return s}{const n=function(t){t=it(t);const e=[];for(const n of t)e.push(n.shape);return rt(e)}(t),s=this.computeOutputShape(n);let r;const i="float32";if(this.warnOnIncompatibleInputShape(Array.isArray(t)?n[0]:n),r=null!=s&&s.length>0&&Array.isArray(s[0])?s.map(((n,s)=>new Oe(i,n,this,it(t),e,this.name,s))):new Oe(i,s,this,it(t),e,this.name),this.addInboundNode(t,r,null,null,n,s,e),this._refCount++,null!=this.activityRegularizer)throw new X("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return r}}))}warnOnIncompatibleInputShape(t){if(null!=this.batchInputShape)if(t.length!==this.batchInputShape.length)console.warn(`The rank of the input tensor provided (shape: ${JSON.stringify(t)}) does not match that of the batchInputShape (${JSON.stringify(this.batchInputShape)}) of the layer ${this.name}`);else{let e=!1;this.batchInputShape.forEach(((n,s)=>{null!=n&&null!=t[s]&&t[s]!==n&&(e=!0)})),e&&console.warn(`The shape of the input tensor (${JSON.stringify(t)}) does not match the expectation of layer ${this.name}: ${JSON.stringify(this.batchInputShape)}`)}}get outputShape(){if(null==this.inboundNodes||0===this.inboundNodes.length)throw new J(`The layer ${this.name} has never been called and thus has no defined output shape.`);const t=[];for(const e of this.inboundNodes){const n=JSON.stringify(e.outputShapes);-1===t.indexOf(n)&&t.push(n)}if(1===t.length){const t=this.inboundNodes[0].outputShapes;return Array.isArray(t)&&Array.isArray(t[0])&&1===t.length?t[0]:t}throw new J(`The layer ${this.name} has multiple inbound nodes with different output shapes. Hence the notion of "output shape" is ill-defined for the layer.`)}countParams(){if(!this.built)throw new Z(`You tried to call countParams() on ${this.name}, but the layer is not built yet. Build it first by calling build(batchInputShape).`);return De(this.weights)}build(t){this.built=!0}getWeights(t=!1){return Re(t?this.trainableWeights:this.weights)}setWeights(t){s((()=>{const n=this.weights;if(n.length!==t.length)throw new Y(`You called setWeights(weights) on layer "${this.name}" with a weight list of length ${t.length}, but the layer was expecting ${n.length} weights. Provided weights: ${t}...`);if(0===n.length)return;const s=[],r=Re(n);for(let i=0;i<r.length;++i){const a=r[i],o=n[i],l=t[i];if(!e.arraysEqual(a.shape,l.shape))throw new Y(`Layer weight shape ${a.shape} not compatible with provided weight shape ${l.shape}`);s.push([o,l])}Me(s)}))}addWeight(t,e,n,s,r,i,a,o){if(-1!==this._addedWeightNames.indexOf(t))throw new Y(`Duplicate weight name ${t} for layer ${this.name}`);this._addedWeightNames.push(t),null==n&&(n="float32"),this.fastWeightInitDuringBuild&&(s=null!=o?o():Te("zeros"));const l=s.apply(e,n),u=new Fe(l,n,t,i,a);return l.dispose(),null!=r&&this.addLoss((()=>r.apply(u.read()))),null==i&&(i=!0),i?this._trainableWeights.push(u):this._nonTrainableWeights.push(u),u}setFastWeightInitDuringBuild(t){this.fastWeightInitDuringBuild=t}addLoss(t){null==t||Array.isArray(t)&&0===t.length||(t=it(t),void 0!==this._losses&&null!==this._losses&&this.losses.push(...t))}computeOutputShape(t){return t}computeMask(t,e){if(!this.supportsMasking){if(null!=e){if(!Array.isArray(e))throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);e.forEach((t=>{if(null!=t)throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`)}))}return null}return e}addInboundNode(t,e,n,s,r,i,a=null){const o=it(t);e=it(e),n=it(n),s=it(s),r=Ce(r),i=Ce(i);const l=[],u=[],h=[];for(const t of o)l.push(t.sourceLayer),u.push(t.nodeIndex),h.push(t.tensorIndex);new Pe({outboundLayer:this,inboundLayers:l,nodeIndices:u,tensorIndices:h,inputTensors:o,outputTensors:e,inputMasks:n,outputMasks:s,inputShapes:r,outputShapes:i},a);for(let t=0;t<e.length;t++)e[t].sourceLayer=this,e[t].nodeIndex=this.inboundNodes.length-1,e[t].tensorIndex=t}getConfig(){const t={name:this.name,trainable:this.trainable};return null!=this.batchInputShape&&(t.batchInputShape=this.batchInputShape),null!=this.dtype&&(t.dtype=this.dtype),t}disposeWeights(){return this.weights.forEach((t=>t.dispose())),this.weights.length}assertNotDisposed(){if(0===this._refCount)throw new Error(`Layer '${this.name}' is already disposed.`)}dispose(){if(!this.built)throw new Error(`Cannot dispose Layer ${this.name} because it has not been built yet.`);if(null===this._refCount)throw new Error(`Cannot dispose Layer ${this.name} because it has not been used yet.`);this.assertNotDisposed();let t=0;return 0==--this._refCount&&(t=this.disposeWeights()),{refCountAfterDispose:this._refCount,numDisposedVariables:t}}}function Ve(t,e,n){if((null==e||null!=n&&n>0)&&(e=t.sourceLayer,n=t.nodeIndex),0===e.inboundNodes.length)return[t];{const t=e.inboundNodes[n];if(0===t.inboundLayers.length)return t.inputTensors;{const e=[];for(let n=0;n<t.inboundLayers.length;n++){const s=Ve(t.inputTensors[n],t.inboundLayers[n],t.nodeIndices[n]);for(const t of s)-1===e.indexOf(t)&&e.push(t)}return e}}}class Ke extends Ue{constructor(t){if(super({dtype:t.dtype,name:null!=t.name?t.name:St("input").toString()}),null==t.batchSize&&(t.batchSize=null),null==t.sparse&&(t.sparse=!1),this.trainable=!1,this.built=!0,this.sparse=t.sparse,null!=t.inputShape&&null!=t.batchInputShape)throw new Y("Only provide the inputShape OR batchInputShape argument to inputLayer, not both at the same time.");let e=t.batchInputShape;if(null==e){if(null==t.inputShape)throw new Y("An InputLayer should be passed either a `batchInputShape` or an `inputShape`.");e=[t.batchSize].concat(t.inputShape)}else if(null!=t.batchSize)throw new Y("Cannot specify batchSize if batchInputShape is specified when creating an InputLayer.");const n=t.dtype||"float32";this.batchInputShape=e,this.dtype=n,this.inputSpec=[{shape:e}];const s=new Oe(this.dtype,this.batchInputShape,this,[],{},this.name);s.nodeIndex=0,s.tensorIndex=0,new Pe({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:[s],outputTensors:[s],inputMasks:[null],outputMasks:[null],inputShapes:[e],outputShapes:[e]})}apply(t,e){throw new Y(`Cannot pass any input to an InputLayer's apply() method. InputLayer name: ${this.name}`)}dispose(){return{refCountAfterDispose:this._refCount,numDisposedVariables:0}}getConfig(){return{batchInputShape:this.batchInputShape,dtype:this.dtype,sparse:this.sparse,name:this.name}}}function je(t){if(null==t.batchShape&&null==t.shape)throw new Error("Please provide to Input either a `shape` or a `batchShape` argument. Note that `shape` does not include the batch dimension.");if(null!=t.batchShape&&null!=t.shape)throw new Y("Please provide either a `shape` or `batchShape` argument to Input, but not both.");let e=t.batchShape;null!=t.shape&&null==e&&(e=[null].concat(t.shape));let n=t.dtype;null==n&&(n="float32");return new Ke({batchInputShape:e,name:t.name,dtype:n,sparse:t.sparse}).inboundNodes[0].outputTensors[0]}Ke.className="InputLayer",i.registerClass(Ke);class qe{constructor(t){if(this.id2Value={},this.id2Mask={},this.name2Id={},t instanceof qe)for(const e in t.id2Value)this.id2Value[e]=t.id2Value[e],e in t.id2Mask&&(this.id2Mask[e]=t.id2Mask[e]);else{if(null==t)return;for(const e of t)this.add(e.key,e.value)}}add(t,e,n){if(null!=this.id2Value[t.id])throw new Y(`Duplicate key: name=${t.name}, id=${t.id}`);return this.id2Value[t.id]=function(t,e){if(null==t.dtype||t.dtype===e.dtype)return e;try{return b(e,t.dtype)}catch(n){throw new Y(`The dtype of the feed (${e.dtype}) can not be cast to the dtype of the key '${t.name}' (${t.dtype}).`)}}(t,e),this.name2Id[t.name]=t.id,null!=n&&(this.id2Mask[t.id]=n),this}addFeed(t){this.add(t.key,t.value)}hasKey(t){return null!=this.id2Value[t.id]}names(){return Object.keys(this.name2Id)}getValue(t){if(t instanceof Oe){if(null==this.id2Value[t.id])throw new Y(`Nonexistent key: ${t.name}`);return this.id2Value[t.id]}{const e=this.name2Id[t];if(null==e)throw new Y(`Feed dict has no SymbolicTensor name: ${t}`);return this.id2Value[e]}}getMask(t){if(t instanceof Oe){if(null==this.id2Value[t.id])throw new Y(`Nonexistent key: ${t.name}`);return this.id2Mask[t.id]}{const e=this.name2Id[t];if(null==e)throw new Y(`Feed dict has no SymbolicTensor name: ${t}`);return this.id2Mask[e]}}disposeMasks(){null!=this.id2Mask&&g(this.id2Mask)}}const Ge=new tt,He=new tt;function Je(t,n,s,r){const i=null!=s&&s.training,a=Array.isArray(t),o=a?t:[t],l=o.map((t=>t.name)),u=[],h=n.names();for(const t of l)-1!==h.indexOf(t)?u.push(n.getValue(t)):u.push(null);null!=r&&(r.maxNumTensors=-1/0,r.minNumTensors=1/0);const c=l.join(",")+"|"+n.names().sort().join(",");let p,d=Ge.get(c);if(null==d){const t=function(t,n){e.assert(null!=t&&t.length>0,(()=>"Expected at least one fetch, got none"));let s=[],r={};if(1===t.length){const e=Ye(t[0],n);s=e.sorted,r=e.recipientMap}else{const e=new Set;for(const i of t){const{sorted:t,recipientMap:a}=Ye(i,n);for(const n of t)e.has(n.name)||(s.push(n),e.add(n.name));for(const t in a)null==r[t]&&(r[t]=new Set),a[t].forEach((e=>r[t].add(e)))}}return{sorted:s,recipientCounts:Ze(r)}}(o,n);d=t.sorted,p=t.recipientCounts,Ge.put(c,d),He.put(c,p)}p={},i||Object.assign(p,He.get(c));const f=new qe(n);for(let t=0;t<d.length;++t){if(null!=r){const t=m().numTensors;t>r.maxNumTensors&&(r.maxNumTensors=t),t<r.minNumTensors&&(r.minNumTensors=t)}const e=d[t],a=e.sourceLayer;if(a instanceof Ke)continue;const o=[],h=[],c=[];let b=!1;for(const t of e.inputs){const e=f.getValue(t),s=f.getMask(t);o.push(e),h.push(s),null!=s&&(b=!0),i||(p[t.name]--,0!==p[t.name]||n.hasKey(t)||-1!==l.indexOf(t.name)||e.isDisposed||!0===t.sourceLayer.stateful||c.push(e))}b&&((s=s||{}).mask=h[0]);const y=it(a.apply(o,s));let w=null;a.supportsMasking&&(w=a.computeMask(o,h));const k=Xe(e),v=Array.isArray(k)?k:[k];for(let t=0;t<v.length;++t){f.hasKey(v[t])||f.add(v[t],y[t],Array.isArray(w)?w[0]:w);const e=l.indexOf(v[t].name);-1!==e&&(u[e]=y[t])}i||g(c)}return f.disposeMasks(),a?u:u[0]}function Ze(t){const e={};for(const n in t)e[n]=t[n].size;return e}function Ye(t,e){const n=new Set,s=[],r={};for(const t of e.names())n.add(t);const i=[],a=[];for(i.push(t);i.length>0;){const t=i[i.length-1];if(n.has(t.name)){i.pop();continue}const e=a[a.length-1]===i.length-1;if(0===t.inputs.length||e)i.pop(),s.push(t),n.add(t.name),e&&a.pop();else{a.push(i.length-1);for(const e of t.inputs)null==r[e.name]&&(r[e.name]=new Set),r[e.name].add(t.name),n.has(e.name)||i.push(e)}}return{sorted:s,recipientMap:r}}function Xe(t){let e;if(1===t.sourceLayer.inboundNodes.length)e=t.sourceLayer.output;else{let n=null;for(let e=0;e<t.sourceLayer.inboundNodes.length;++e)for(const s of t.sourceLayer.inboundNodes[e].outputTensors)if(s.id===t.id){n=e;break}e=t.sourceLayer.getOutputAt(n)}return e}y().registerFlag("TOPOLOGICAL_SORT_CACHE_MAX_ENTRIES",(()=>100),(function(t){null!=Ge&&Ge.setMaxEntries(t),null!=He&&He.setMaxEntries(t)}));function Qe(t){throw new Error(`'${t}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function tn(t,e){if(!t)throw new Error("string"==typeof e?e:e())}function en(t,e,n=""){tn(an(t,e),(()=>n+` Shapes ${t} and ${e} must match`))}function nn(t){tn(null!=t,(()=>"The input to the tensor constructor must be a non-null value."))}function sn(t,e=[],n=!1){if(null==e&&(e=[]),Array.isArray(t)||hn(t)&&!n)for(let s=0;s<t.length;++s)sn(t[s],e,n);else e.push(t);return e}function rn(t){if(0===t.length)return 1;let e=t[0];for(let n=1;n<t.length;n++)e*=t[n];return e}function an(t,e){if(t===e)return!0;if(null==t||null==e)return!1;if(t.length!==e.length)return!1;for(let n=0;n<t.length;n++)if(t[n]!==e[n])return!1;return!0}function on(t){return t%1==0}function ln(t,e){return e<=t.length?t:t+" ".repeat(e-t.length)}function un(t,e){const n=e.length;return tn((t=null==t?e.map(((t,e)=>e)):[].concat(t)).every((t=>t>=-n&&t<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${t}`)),tn(t.every((t=>on(t))),(()=>`All values in axis param must be integers but got axis ${t}`)),t.map((t=>t<0?n+t:t))}function hn(t){return t instanceof Float32Array||t instanceof Int32Array||t instanceof Uint8Array||t instanceof Uint8ClampedArray}function cn(t){if("float32"===t||"int32"===t)return 4;if("complex64"===t)return 8;if("bool"===t)return 1;throw new Error(`Unknown dtype ${t}`)}function pn(t){return"string"==typeof t||t instanceof String}function dn(t){return Array.isArray(t)?dn(t[0]):t instanceof Float32Array?"float32":t instanceof Int32Array||t instanceof Uint8Array||t instanceof Uint8ClampedArray?"int32":"number"==typeof t?"float32":pn(t)?"string":function(t){return"boolean"==typeof t}(t)?"bool":"float32"}function fn(t){return!!(t&&t.constructor&&t.call&&t.apply)}function gn(t){const e=t.length;if(e<2)return[];const n=new Array(e-1);n[e-2]=t[e-1];for(let s=e-3;s>=0;--s)n[s]=n[s+1]*t[s+1];return n}function mn(t,e,n,s=!1){const r=new Array;if(1===e.length){const i=e[0]*(s?2:1);for(let e=0;e<i;e++)r[e]=n[t+e]}else{const i=e[0],a=e.slice(1),o=a.reduce(((t,e)=>t*e))*(s?2:1);for(let e=0;e<i;e++)r[e]=mn(t+e*o,a,n,s)}return r}function bn(t,e,n=!1){if(0===t.length)return e[0];const s=t.reduce(((t,e)=>t*e))*(n?2:1);if(0===s)return[];if(s!==e.length)throw new Error(`[${t}] does not match the input size ${e.length}${n?" for a complex tensor":""}.`);return mn(0,t,e,n)}function yn(t,e){const n=wn(t,e);for(let t=0;t<n.length;t++)n[t]=1;return n}function wn(t,e){if(null==e||"float32"===e||"complex64"===e)return new Float32Array(t);if("int32"===e)return new Int32Array(t);if("bool"===e)return new Uint8Array(t);throw new Error(`Unknown data type ${e}`)}function kn(t){t.forEach((e=>{tn(Number.isInteger(e)&&e>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${t}].`))}))}function vn(t){return t&&t.then&&"function"==typeof t.then}class xn{constructor(t){this.global=t,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=Sn,this.populateURLFlags()}setPlatform(t,e){null!=this.platform&&(Nn().getBool("IS_TEST")||Nn().getBool("PROD")||console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${t}.`)),this.platformName=t,this.platform=e}registerFlag(t,e,n){if(this.flagRegistry[t]={evaluationFn:e,setHook:n},null!=this.urlFlags[t]){const e=this.urlFlags[t];Nn().getBool("IS_TEST")||Nn().getBool("PROD")||console.warn(`Setting feature override from URL ${t}: ${e}.`),this.set(t,e)}}async getAsync(t){return t in this.flags||(this.flags[t]=await this.evaluateFlag(t)),this.flags[t]}get(t){if(t in this.flags)return this.flags[t];const e=this.evaluateFlag(t);if(vn(e))throw new Error(`Flag ${t} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[t]=e,this.flags[t]}getNumber(t){return this.get(t)}getBool(t){return this.get(t)}getFlags(){return this.flags}get features(){return this.flags}set(t,e){if(null==this.flagRegistry[t])throw new Error(`Cannot set flag ${t} as it has not been registered.`);this.flags[t]=e,null!=this.flagRegistry[t].setHook&&this.flagRegistry[t].setHook(e)}evaluateFlag(t){if(null==this.flagRegistry[t])throw new Error(`Cannot evaluate flag '${t}': no evaluation function found.`);return this.flagRegistry[t].evaluationFn()}setFlags(t){this.flags=Object.assign({},t)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if("undefined"==typeof this.global||"undefined"==typeof this.global.location||"undefined"==typeof this.global.location.search)return;const t=this.getQueryParams(this.global.location.search);if("tfjsflags"in t){t.tfjsflags.split(",").forEach((t=>{const[e,n]=t.split(":");this.urlFlags[e]=function(t,e){if("true"===(e=e.toLowerCase())||"false"===e)return"true"===e;if(""+ +e===e)return+e;throw new Error(`Could not parse value flag value ${e} for flag ${t}.`)}(e,n)}))}}}function Sn(t){const e={};return t.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((t,...n)=>(function(t,e,n){t[decodeURIComponent(e)]=decodeURIComponent(n||"")}(e,n[0],n[1]),n.join("=")))),e}function Nn(){return In}let En,In=null;function An(){if(null==En){let t;if("undefined"!=typeof window)t=window;else if("undefined"!=typeof global)t=global;else if("undefined"!=typeof process)t=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");t=self}En=t}return En}function Tn(t,e){const n=function(){const t=An();return null==t._tfGlobals&&(t._tfGlobals=new Map),t._tfGlobals}();if(n.has(t))return n.get(t);{const s=e();return n.set(t,s),n.get(t)}}function $n(...t){Nn().getBool("IS_TEST")||Nn().getBool("PROD")||console.warn(...t)}const Cn=Tn("kernelRegistry",(()=>new Map)),zn=Tn("gradRegistry",(()=>new Map));function _n(t,e){const n=function(t,e){return`${e}_${t}`}(t,e);return Cn.get(n)}function Dn(t){return zn.get(t)}function Fn(t){const e=Cn.entries(),n=[];for(;;){const{done:s,value:r}=e.next();if(s)break;const[i,a]=r,[o]=i.split("_");o===t&&n.push(a)}return n}function Rn(t){const{kernelName:e}=t;zn.has(e)&&Nn().getBool("DEBUG")&&$n(`Overriding the gradient for '${e}'`),zn.set(e,t)}var Mn=On,Ln=null;try{Ln=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(t){}function On(t,e,n){this.low=0|t,this.high=0|e,this.unsigned=!!n}function Bn(t){return!0===(t&&t.__isLong__)}On.prototype.__isLong__,Object.defineProperty(On.prototype,"__isLong__",{value:!0}),On.isLong=Bn;var Pn={},Wn={};function Un(t,e){var n,s,r;return e?(r=0<=(t>>>=0)&&t<256)&&(s=Wn[t])?s:(n=Kn(t,(0|t)<0?-1:0,!0),r&&(Wn[t]=n),n):(r=-128<=(t|=0)&&t<128)&&(s=Pn[t])?s:(n=Kn(t,t<0?-1:0,!1),r&&(Pn[t]=n),n)}function Vn(t,e){if(isNaN(t))return e?Qn:Xn;if(e){if(t<0)return Qn;if(t>=Jn)return rs}else{if(t<=-Zn)return is;if(t+1>=Zn)return ss}return t<0?Vn(-t,e).neg():Kn(t%Hn|0,t/Hn|0,e)}function Kn(t,e,n){return new On(t,e,n)}On.fromInt=Un,On.fromNumber=Vn,On.fromBits=Kn;var jn=Math.pow;function qn(t,e,n){if(0===t.length)throw Error("empty string");if("NaN"===t||"Infinity"===t||"+Infinity"===t||"-Infinity"===t)return Xn;if("number"==typeof e?(n=e,e=!1):e=!!e,(n=n||10)<2||36<n)throw RangeError("radix");var s;if((s=t.indexOf("-"))>0)throw Error("interior hyphen");if(0===s)return qn(t.substring(1),e,n).neg();for(var r=Vn(jn(n,8)),i=Xn,a=0;a<t.length;a+=8){var o=Math.min(8,t.length-a),l=parseInt(t.substring(a,a+o),n);if(o<8){var u=Vn(jn(n,o));i=i.mul(u).add(Vn(l))}else i=(i=i.mul(r)).add(Vn(l))}return i.unsigned=e,i}function Gn(t,e){return"number"==typeof t?Vn(t,e):"string"==typeof t?qn(t,e):Kn(t.low,t.high,"boolean"==typeof e?e:t.unsigned)}On.fromString=qn,On.fromValue=Gn;var Hn=4294967296,Jn=Hn*Hn,Zn=Jn/2,Yn=Un(1<<24),Xn=Un(0);On.ZERO=Xn;var Qn=Un(0,!0);On.UZERO=Qn;var ts=Un(1);On.ONE=ts;var es=Un(1,!0);On.UONE=es;var ns=Un(-1);On.NEG_ONE=ns;var ss=Kn(-1,2147483647,!1);On.MAX_VALUE=ss;var rs=Kn(-1,-1,!0);On.MAX_UNSIGNED_VALUE=rs;var is=Kn(0,-2147483648,!1);On.MIN_VALUE=is;var as=On.prototype;as.toInt=function(){return this.unsigned?this.low>>>0:this.low},as.toNumber=function(){return this.unsigned?(this.high>>>0)*Hn+(this.low>>>0):this.high*Hn+(this.low>>>0)},as.toString=function(t){if((t=t||10)<2||36<t)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(is)){var e=Vn(t),n=this.div(e),s=n.mul(e).sub(this);return n.toString(t)+s.toInt().toString(t)}return"-"+this.neg().toString(t)}for(var r=Vn(jn(t,6),this.unsigned),i=this,a="";;){var o=i.div(r),l=(i.sub(o.mul(r)).toInt()>>>0).toString(t);if((i=o).isZero())return l+a;for(;l.length<6;)l="0"+l;a=""+l+a}},as.getHighBits=function(){return this.high},as.getHighBitsUnsigned=function(){return this.high>>>0},as.getLowBits=function(){return this.low},as.getLowBitsUnsigned=function(){return this.low>>>0},as.getNumBitsAbs=function(){if(this.isNegative())return this.eq(is)?64:this.neg().getNumBitsAbs();for(var t=0!=this.high?this.high:this.low,e=31;e>0&&0==(t&1<<e);e--);return 0!=this.high?e+33:e+1},as.isZero=function(){return 0===this.high&&0===this.low},as.eqz=as.isZero,as.isNegative=function(){return!this.unsigned&&this.high<0},as.isPositive=function(){return this.unsigned||this.high>=0},as.isOdd=function(){return 1==(1&this.low)},as.isEven=function(){return 0==(1&this.low)},as.equals=function(t){return Bn(t)||(t=Gn(t)),(this.unsigned===t.unsigned||this.high>>>31!=1||t.high>>>31!=1)&&(this.high===t.high&&this.low===t.low)},as.eq=as.equals,as.notEquals=function(t){return!this.eq(t)},as.neq=as.notEquals,as.ne=as.notEquals,as.lessThan=function(t){return this.comp(t)<0},as.lt=as.lessThan,as.lessThanOrEqual=function(t){return this.comp(t)<=0},as.lte=as.lessThanOrEqual,as.le=as.lessThanOrEqual,as.greaterThan=function(t){return this.comp(t)>0},as.gt=as.greaterThan,as.greaterThanOrEqual=function(t){return this.comp(t)>=0},as.gte=as.greaterThanOrEqual,as.ge=as.greaterThanOrEqual,as.compare=function(t){if(Bn(t)||(t=Gn(t)),this.eq(t))return 0;var e=this.isNegative(),n=t.isNegative();return e&&!n?-1:!e&&n?1:this.unsigned?t.high>>>0>this.high>>>0||t.high===this.high&&t.low>>>0>this.low>>>0?-1:1:this.sub(t).isNegative()?-1:1},as.comp=as.compare,as.negate=function(){return!this.unsigned&&this.eq(is)?is:this.not().add(ts)},as.neg=as.negate,as.add=function(t){Bn(t)||(t=Gn(t));var e=this.high>>>16,n=65535&this.high,s=this.low>>>16,r=65535&this.low,i=t.high>>>16,a=65535&t.high,o=t.low>>>16,l=0,u=0,h=0,c=0;return h+=(c+=r+(65535&t.low))>>>16,u+=(h+=s+o)>>>16,l+=(u+=n+a)>>>16,l+=e+i,Kn((h&=65535)<<16|(c&=65535),(l&=65535)<<16|(u&=65535),this.unsigned)},as.subtract=function(t){return Bn(t)||(t=Gn(t)),this.add(t.neg())},as.sub=as.subtract,as.multiply=function(t){if(this.isZero())return Xn;if(Bn(t)||(t=Gn(t)),Ln)return Kn(Ln.mul(this.low,this.high,t.low,t.high),Ln.get_high(),this.unsigned);if(t.isZero())return Xn;if(this.eq(is))return t.isOdd()?is:Xn;if(t.eq(is))return this.isOdd()?is:Xn;if(this.isNegative())return t.isNegative()?this.neg().mul(t.neg()):this.neg().mul(t).neg();if(t.isNegative())return this.mul(t.neg()).neg();if(this.lt(Yn)&&t.lt(Yn))return Vn(this.toNumber()*t.toNumber(),this.unsigned);var e=this.high>>>16,n=65535&this.high,s=this.low>>>16,r=65535&this.low,i=t.high>>>16,a=65535&t.high,o=t.low>>>16,l=65535&t.low,u=0,h=0,c=0,p=0;return c+=(p+=r*l)>>>16,h+=(c+=s*l)>>>16,c&=65535,h+=(c+=r*o)>>>16,u+=(h+=n*l)>>>16,h&=65535,u+=(h+=s*o)>>>16,h&=65535,u+=(h+=r*a)>>>16,u+=e*l+n*o+s*a+r*i,Kn((c&=65535)<<16|(p&=65535),(u&=65535)<<16|(h&=65535),this.unsigned)},as.mul=as.multiply,as.divide=function(t){if(Bn(t)||(t=Gn(t)),t.isZero())throw Error("division by zero");var e,n,s;if(Ln)return this.unsigned||-2147483648!==this.high||-1!==t.low||-1!==t.high?Kn((this.unsigned?Ln.div_u:Ln.div_s)(this.low,this.high,t.low,t.high),Ln.get_high(),this.unsigned):this;if(this.isZero())return this.unsigned?Qn:Xn;if(this.unsigned){if(t.unsigned||(t=t.toUnsigned()),t.gt(this))return Qn;if(t.gt(this.shru(1)))return es;s=Qn}else{if(this.eq(is))return t.eq(ts)||t.eq(ns)?is:t.eq(is)?ts:(e=this.shr(1).div(t).shl(1)).eq(Xn)?t.isNegative()?ts:ns:(n=this.sub(t.mul(e)),s=e.add(n.div(t)));if(t.eq(is))return this.unsigned?Qn:Xn;if(this.isNegative())return t.isNegative()?this.neg().div(t.neg()):this.neg().div(t).neg();if(t.isNegative())return this.div(t.neg()).neg();s=Xn}for(n=this;n.gte(t);){e=Math.max(1,Math.floor(n.toNumber()/t.toNumber()));for(var r=Math.ceil(Math.log(e)/Math.LN2),i=r<=48?1:jn(2,r-48),a=Vn(e),o=a.mul(t);o.isNegative()||o.gt(n);)o=(a=Vn(e-=i,this.unsigned)).mul(t);a.isZero()&&(a=ts),s=s.add(a),n=n.sub(o)}return s},as.div=as.divide,as.modulo=function(t){return Bn(t)||(t=Gn(t)),Ln?Kn((this.unsigned?Ln.rem_u:Ln.rem_s)(this.low,this.high,t.low,t.high),Ln.get_high(),this.unsigned):this.sub(this.div(t).mul(t))},as.mod=as.modulo,as.rem=as.modulo,as.not=function(){return Kn(~this.low,~this.high,this.unsigned)},as.and=function(t){return Bn(t)||(t=Gn(t)),Kn(this.low&t.low,this.high&t.high,this.unsigned)},as.or=function(t){return Bn(t)||(t=Gn(t)),Kn(this.low|t.low,this.high|t.high,this.unsigned)},as.xor=function(t){return Bn(t)||(t=Gn(t)),Kn(this.low^t.low,this.high^t.high,this.unsigned)},as.shiftLeft=function(t){return Bn(t)&&(t=t.toInt()),0==(t&=63)?this:t<32?Kn(this.low<<t,this.high<<t|this.low>>>32-t,this.unsigned):Kn(0,this.low<<t-32,this.unsigned)},as.shl=as.shiftLeft,as.shiftRight=function(t){return Bn(t)&&(t=t.toInt()),0==(t&=63)?this:t<32?Kn(this.low>>>t|this.high<<32-t,this.high>>t,this.unsigned):Kn(this.high>>t-32,this.high>=0?0:-1,this.unsigned)},as.shr=as.shiftRight,as.shiftRightUnsigned=function(t){if(Bn(t)&&(t=t.toInt()),0===(t&=63))return this;var e=this.high;return t<32?Kn(this.low>>>t|e<<32-t,e>>>t,this.unsigned):Kn(32===t?e:e>>>t-32,0,this.unsigned)},as.shru=as.shiftRightUnsigned,as.shr_u=as.shiftRightUnsigned,as.toSigned=function(){return this.unsigned?Kn(this.low,this.high,!1):this},as.toUnsigned=function(){return this.unsigned?this:Kn(this.low,this.high,!0)},as.toBytes=function(t){return t?this.toBytesLE():this.toBytesBE()},as.toBytesLE=function(){var t=this.high,e=this.low;return[255&e,e>>>8&255,e>>>16&255,e>>>24,255&t,t>>>8&255,t>>>16&255,t>>>24]},as.toBytesBE=function(){var t=this.high,e=this.low;return[t>>>24,t>>>16&255,t>>>8&255,255&t,e>>>24,e>>>16&255,e>>>8&255,255&e]},On.fromBytes=function(t,e,n){return n?On.fromBytesLE(t,e):On.fromBytesBE(t,e)},On.fromBytesLE=function(t,e){return new On(t[0]|t[1]<<8|t[2]<<16|t[3]<<24,t[4]|t[5]<<8|t[6]<<16|t[7]<<24,e)},On.fromBytesBE=function(t,e){return new On(t[4]<<24|t[5]<<16|t[6]<<8|t[7],t[0]<<24|t[1]<<16|t[2]<<8|t[3],e)};const os=Mn||H({__proto__:null,default:Mn},[Mn]);function ls(t){return os.fromString(t,!0,16)}function us(t,e){if("string"===e)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(t)&&(t=sn(t)),Nn().getBool("DEBUG")&&function(t,e){for(let n=0;n<t.length;n++){const s=t[n];if(isNaN(s)||!isFinite(s))throw Error(`A tensor of type ${e} being uploaded contains ${s}.`)}}(t,e),function(t,e){return t instanceof Float32Array&&"float32"===e||t instanceof Int32Array&&"int32"===e||t instanceof Uint8Array&&"bool"===e}(t,e))return t;if(null==e||"float32"===e||"complex64"===e)return new Float32Array(t);if("int32"===e)return new Int32Array(t);if("bool"===e){const e=new Uint8Array(t.length);for(let n=0;n<e.length;++n)0!==Math.round(t[n])&&(e[n]=1);return e}throw new Error(`Unknown data type ${e}`)}function hs(){return Nn().platform.now()}function cs(t,e="utf-8"){return e=e||"utf-8",Nn().platform.decode(t,e)}ls("c3a5c85c97cb3127"),ls("b492b66fbe98f273"),ls("9ae16a3b2f90404f");class ps{constructor(t,e){this.backendTimer=t,this.logger=e,null==e&&(this.logger=new fs)}profileKernel(t,e,n){let s;const r=()=>{s=n()};let i;const a=hs();if(this.backendTimer.timerAvailable())i=this.backendTimer.time(r);else{r();for(const t of s)t.dataSync();i=Promise.resolve({kernelMs:hs()-a})}if(Nn().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let e=0;e<s.length;e++){const n=s[e];n.data().then((e=>{ds(e,n.dtype,t)}))}return{kernelName:t,outputs:s,inputs:e,timeMs:i.then((t=>t.kernelMs)),extraInfo:i.then((t=>null!=t.getExtraProfileInfo?t.getExtraProfileInfo():""))}}logKernelProfile(t){const{kernelName:e,outputs:n,timeMs:s,inputs:r,extraInfo:i}=t;n.forEach((t=>{Promise.all([t.data(),s,i]).then((n=>{this.logger.logKernelProfile(e,t,n[0],n[1],r,n[2])}))}))}}function ds(t,e,n){if("float32"!==e)return!1;for(let e=0;e<t.length;e++){const s=t[e];if(isNaN(s)||!isFinite(s))return console.warn(`Found ${s} in the result of '${n}'`),!0}return!1}class fs{logKernelProfile(t,e,n,s,r,i){const a="number"==typeof s?ln(`${s}ms`,9):s.error,o=ln(t,25),l=e.rank,u=e.size,h=ln(e.shape.toString(),14);let c="";for(const t in r){const n=r[t];if(null!=n){const s=n.shape||e.shape,r=s.length;c+=`${t}: ${r}D ${r>0?s:""} `}}console.log(`%c${o}\t%c${a}\t%c${l}D ${h}\t%c${u}\t%c${c}\t%c${i}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function gs(t,e,n,s){const r=gn(e),i=function(t,e,n,s){const r=rn(e),i=s[s.length-1],a=new Array(i).fill(0),o=e.length,l="complex64"===n?ws(t):t;if(o>1)for(let t=0;t<r/i;t++){const e=t*i;for(let t=0;t<i;t++)a[t]=Math.max(a[t],ms(l[e+t],0,n).length)}return a}(t,e,n,r),a=e.length,o=ys(t,e,n,r,i),l=["Tensor"];return s&&(l.push(`  dtype: ${n}`),l.push(`  rank: ${a}`),l.push(`  shape: [${e}]`),l.push("  values:")),l.push(o.map((t=>"    "+t)).join("\n")),l.join("\n")}function ms(t,e,n){let s;return s=Array.isArray(t)?`${parseFloat(t[0].toFixed(7))} + ${parseFloat(t[1].toFixed(7))}j`:pn(t)?`'${t}'`:"bool"===n?bs(t):parseFloat(t.toFixed(7)).toString(),ln(s,e)}function bs(t){return 0===t?"false":"true"}function ys(t,e,n,s,r,i=!0){const a="complex64"===n?2:1,o=e[0],l=e.length;if(0===l){if("complex64"===n){return[ms(ws(t)[0],0,n)]}return"bool"===n?[bs(t[0])]:[t[0].toString()]}if(1===l){if(o>20){const e=3*a;let s=Array.from(t.slice(0,e)),i=Array.from(t.slice((o-3)*a,o*a));return"complex64"===n&&(s=ws(s),i=ws(i)),["["+s.map(((t,e)=>ms(t,r[e],n))).join(", ")+", ..., "+i.map(((t,e)=>ms(t,r[o-3+e],n))).join(", ")+"]"]}return["["+("complex64"===n?ws(t):Array.from(t)).map(((t,e)=>ms(t,r[e],n))).join(", ")+"]"]}const u=e.slice(1),h=s.slice(1),c=s[0]*a,p=[];if(o>20){for(let e=0;e<3;e++){const s=e*c,i=s+c;p.push(...ys(t.slice(s,i),u,n,h,r,!1))}p.push("...");for(let e=o-3;e<o;e++){const s=e*c,i=s+c;p.push(...ys(t.slice(s,i),u,n,h,r,e===o-1))}}else for(let e=0;e<o;e++){const s=e*c,i=s+c;p.push(...ys(t.slice(s,i),u,n,h,r,e===o-1))}const d=2===l?",":"";p[0]="["+p[0]+d;for(let t=1;t<p.length-1;t++)p[t]=" "+p[t]+d;let f=",\n";for(let t=2;t<l;t++)f+="\n";return p[p.length-1]=" "+p[p.length-1]+"]"+(i?"":f),p}function ws(t){const e=[];for(let n=0;n<t.length;n+=2)e.push([t[n],t[n+1]]);return e}class ks{constructor(t,e,n){if(this.dtype=e,this.shape=t.slice(),this.size=rn(t),null!=n){const t=n.length;tn(t===this.size,(()=>`Length of values '${t}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===e)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||function(t,e){let n=null;if(null==t||"float32"===t)n=new Float32Array(e);else if("int32"===t)n=new Int32Array(e);else if("bool"===t)n=new Uint8Array(e);else{if("string"!==t)throw new Error(`Unknown data type ${t}`);n=new Array(e)}return n}(e,this.size),this.strides=gn(t)}set(t,...e){0===e.length&&(e=[0]),tn(e.length===this.rank,(()=>`The number of provided coordinates (${e.length}) must match the rank (${this.rank})`));const n=this.locToIndex(e);this.values[n]=t}get(...t){0===t.length&&(t=[0]);let e=0;for(const n of t){if(n<0||n>=this.shape[e]){const e=`Requested out of range element at ${t}.   Buffer shape=${this.shape}`;throw new Error(e)}e++}let n=t[t.length-1];for(let e=0;e<t.length-1;++e)n+=this.strides[e]*t[e];return this.values[n]}locToIndex(t){if(0===this.rank)return 0;if(1===this.rank)return t[0];let e=t[t.length-1];for(let n=0;n<t.length-1;++n)e+=this.strides[n]*t[n];return e}indexToLoc(t){if(0===this.rank)return[];if(1===this.rank)return[t];const e=new Array(this.shape.length);for(let n=0;n<e.length-1;++n)e[n]=Math.floor(t/this.strides[n]),t-=e[n]*this.strides[n];return e[e.length-1]=t,e}get rank(){return this.shape.length}toTensor(){return vs().makeTensor(this.values,this.shape,this.dtype)}}let vs=null;class xs{constructor(t,e,n,s){this.kept=!1,this.isDisposedInternal=!1,this.shape=t.slice(),this.dtype=e||"float32",this.size=rn(t),this.strides=gn(t),this.dataId=n,this.id=s,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const t=await this.data();return null.buffer(this.shape,this.dtype,t)}bufferSync(){return null.buffer(this.shape,this.dtype,this.dataSync())}async array(){const t=await this.data();return bn(this.shape,t,"complex64"===this.dtype)}arraySync(){return bn(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const t=vs().read(this.dataId);if("string"===this.dtype){const e=await t;try{return e.map((t=>cs(t)))}catch(t){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return t}dataToGPU(t){return this.throwIfDisposed(),vs().readToGPU(this.dataId,t)}dataSync(){this.throwIfDisposed();const t=vs().readSync(this.dataId);if("string"===this.dtype)try{return t.map((t=>cs(t)))}catch(t){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return t}async bytes(){this.throwIfDisposed();const t=await vs().read(this.dataId);return"string"===this.dtype?t:new Uint8Array(t.buffer)}dispose(){this.isDisposed||(vs().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(t=!1){return null.print(this,t)}clone(){return this.throwIfDisposed(),null.clone(this)}toString(t=!1){return gs(this.dataSync(),this.shape,this.dtype,t)}cast(t){return this.throwIfDisposed(),null.cast(this,t)}variable(t=!0,e,n){return this.throwIfDisposed(),vs().makeVariable(this,t,e,n)}}Object.defineProperty(xs,Symbol.hasInstance,{value:t=>!!t&&null!=t.data&&null!=t.dataSync&&null!=t.throwIfDisposed}),Tn("Tensor",(()=>xs));class Ss extends xs{constructor(t,e,n,s){super(t.shape,t.dtype,t.dataId,s),this.trainable=e,this.name=n}assign(t){if(t.dtype!==this.dtype)throw new Error(`dtype of the new value (${t.dtype}) and previous value (${this.dtype}) must match`);if(!an(t.shape,this.shape))throw new Error(`shape of the new value (${t.shape}) and previous value (${this.shape}) must match`);vs().disposeTensor(this),this.dataId=t.dataId,vs().incRef(this,null)}dispose(){vs().disposeVariable(this),this.isDisposedInternal=!0}}var Ns,Es,Is,As,Ts;Object.defineProperty(Ss,Symbol.hasInstance,{value:t=>t instanceof xs&&null!=t.assign&&t.assign instanceof Function}),function(t){t.R0="R0",t.R1="R1",t.R2="R2",t.R3="R3",t.R4="R4",t.R5="R5",t.R6="R6"}(Ns||(Ns={})),function(t){t.float32="float32",t.int32="int32",t.bool="int32",t.complex64="complex64"}(Es||(Es={})),function(t){t.float32="float32",t.int32="int32",t.bool="bool",t.complex64="complex64"}(Is||(Is={})),function(t){t.float32="float32",t.int32="float32",t.bool="float32",t.complex64="complex64"}(As||(As={})),function(t){t.float32="complex64",t.int32="complex64",t.bool="complex64",t.complex64="complex64"}(Ts||(Ts={}));const $s={float32:As,int32:Es,bool:Is,complex64:Ts};function Cs(t,e){if(t.dtype===e.dtype)return[t,e];const n=function(t,e){if("string"===t||"string"===e){if("string"===t&&"string"===e)return"string";throw new Error(`Can not upcast ${t} with ${e}`)}return $s[t][e]}(t.dtype,e.dtype);return[t.cast(n),e.cast(n)]}function zs(t){const e=[];return _s(t,e,new Set),e}function _s(t,e,n){if(null==t)return;if(t instanceof xs)return void e.push(t);if(s=t,!Array.isArray(s)&&"object"!=typeof s)return;var s;const r=t;for(const t in r){const s=r[t];n.has(s)||(n.add(s),_s(s,e,n))}}function Ds(t){return null!=t.kernelName}class Fs{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((t=>t.name))))}}}dispose(){for(const t in this.registeredVariables)this.registeredVariables[t].dispose()}}class Rs{constructor(t){this.ENV=t,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new Fs}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const t=this.getSortedBackends();for(let e=0;e<t.length;e++){const n=t[e];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:t,asyncInit:e}=this.initializeBackendsAndReturnBest();if(e)throw new Error(`The highest priority backend '${t}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(t)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(t){if(!(t in this.registry)){if(!(t in this.registryFactory))return null;{const{asyncInit:e}=this.initializeBackend(t);if(e)return null}}return this.registry[t]}findBackendFactory(t){return t in this.registryFactory?this.registryFactory[t].factory:null}registerBackend(t,e,n=1){return t in this.registryFactory?($n(`${t} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[t]={factory:e,priority:n},!0)}async setBackend(t){if(null==this.registryFactory[t])throw new Error(`Backend name '${t}' not found in registry`);if(this.backendName=t,null==this.registry[t]){this.backendInstance=null;const{success:e,asyncInit:n}=this.initializeBackend(t);if(!(n?await e:e))return!1}return this.backendInstance=this.registry[t],this.setupRegisteredKernels(),this.profiler=new ps(this.backendInstance),!0}setupRegisteredKernels(){Fn(this.backendName).forEach((t=>{null!=t.setupFunc&&t.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(t){Fn(t).forEach((e=>{null!=e.disposeFunc&&e.disposeFunc(this.registry[t])}))}initializeBackend(t){const e=this.registryFactory[t];if(null==e)throw new Error(`Cannot initialize backend ${t}, no registration found.`);try{const n=e.factory();if(!n||n instanceof class{refCount(t){return Qe("refCount")}incRef(t){return Qe("incRef")}timerAvailable(){return!0}time(t){return Qe("time")}read(t){return Qe("read")}readSync(t){return Qe("readSync")}readToGPU(t,e){return Qe("readToGPU")}numDataIds(){return Qe("numDataIds")}disposeData(t,e){return Qe("disposeData")}write(t,e,n){return Qe("write")}move(t,e,n,s,r){return Qe("move")}createTensorFromTexture(t,e,n){return Qe("createTensorFromTexture")}memory(){return Qe("memory")}floatPrecision(){return Qe("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return Qe("dispose")}}||"function"!=typeof n.then)return this.registry[t]=n,{success:!0,asyncInit:!1};{const e=++this.pendingBackendInitId,s=n.then((n=>!(e<this.pendingBackendInitId)&&(this.registry[t]=n,this.pendingBackendInit=null,!0))).catch((n=>(e<this.pendingBackendInitId||(this.pendingBackendInit=null,$n(`Initialization of backend ${t} failed`),$n(n.stack||n.message)),!1)));return this.pendingBackendInit=s,{success:s,asyncInit:!0}}}catch(e){return $n(`Initialization of backend ${t} failed`),$n(e.stack||e.message),{success:!1,asyncInit:!1}}}removeBackend(t){if(!(t in this.registryFactory))throw new Error(`${t} backend not found in registry`);this.backendName===t&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,t in this.registry&&(this.disposeRegisteredKernels(t),this.registry[t].dispose(),delete this.registry[t]),delete this.registryFactory[t],this.backendName===t&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((t,e)=>this.registryFactory[e].priority-this.registryFactory[t].priority))}initializeBackendsAndReturnBest(){const t=this.getSortedBackends();for(let e=0;e<t.length;e++){const n=t[e],{success:s,asyncInit:r}=this.initializeBackend(n);if(r||s)return{name:n,asyncInit:r}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(t,e){const n=this.state.tensorInfo.get(e),s=n.backend,r=this.readSync(e),i=s.refCount(e);s.disposeData(e,!0),n.backend=t,t.move(e,r,n.shape,n.dtype,i),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(t,e){let n,s=null;if(null==e){if("function"!=typeof t)throw new Error("Please provide a function to tidy()");e=t}else{if("string"!=typeof t&&!(t instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof e)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");s=t}return this.scopedRun((()=>this.startScope(s)),(()=>this.endScope(n)),(()=>(n=e(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(t,e,n){t();try{const t=n();return e(),t}catch(t){throw e(),t}}nextTensorId(){return Rs.nextTensorId++}nextVariableId(){return Rs.nextVariableId++}clone(t){const e=Ms.runKernel("Identity",{x:t}),n={x:t};return this.addTapeNode(this.state.activeScope.name,n,[e],(t=>({x:()=>{const e={x:t},n={dtype:"float32"};return Ms.runKernel("Cast",e,n)}})),[],{}),e}runKernel(t,e,n){null==this.backendName&&this.backend;if(!(null!=_n(t,this.backendName)))throw new Error(`Kernel '${t}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:t,inputs:e,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(t,e,n){const s=this.backend.numDataIds();let r=0;n.forEach((t=>{r+="complex64"===t.dtype?3:1}));const i=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],a=s-e-r-i;if(a>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${a} data ids) after running '${t}'`)}runKernelFunc(t){let e,n=[];const s=this.isTapeOn(),r=this.state.numBytes,i=this.state.numTensors;let a,o;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const l=Ds(t)?t.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(Ds(t)){const{kernelName:e,inputs:r,attrs:i}=t;null==this.backendName&&this.backend;const l=_n(e,this.backendName);tn(null!=l,(()=>`Cannot find registered kernel '${e}' for backend '${this.backendName}'`)),a=()=>{const t=this.backend.numDataIds();o=l.kernelFunc({inputs:r,attrs:i,backend:this.backend});const a=Array.isArray(o)?o:[o];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(e,t,a);const u=a.map((t=>null!=t.rank?t:this.makeTensorFromTensorInfo(t)));if(s){const t=this.getTensorsForGradient(e,r,u);n=this.saveTensorsForBackwardMode(t)}return u}}else{const{forwardFunc:e}=t,r=t=>{s&&(n=t.map((t=>this.keep(this.clone(t)))))};a=()=>{const t=this.backend.numDataIds();o=this.tidy((()=>e(this.backend,r)));const n=Array.isArray(o)?o:[o];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(l,t,n),n}}const{inputs:u,attrs:h}=t,c=Ds(t)?null:t.backwardsFunc;let p;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(p=this.profiler.profileKernel(l,u,(()=>a())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(p),e=p.outputs):e=a()})),s&&this.addTapeNode(l,u,e,c,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:l,bytesAdded:this.state.numBytes-r,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-i,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(u).map((t=>null!=u[t]?u[t].shape:null)),outputShapes:e.map((t=>t.shape)),kernelTimeMs:p.timeMs,extraInfo:p.extraInfo}),Array.isArray(o)?e:e[0]}saveTensorsForBackwardMode(t){const e=t.map((t=>this.keep(this.clone(t))));return e}getTensorsForGradient(t,e,n){const s=Dn(t);if(null!=s){const t=s.inputsToSave||[],r=s.outputsToSave||[];let i;s.saveAllInputs?(tn(Array.isArray(e),(()=>"saveAllInputs is true, expected inputs to be an array.")),i=Object.keys(e).map((t=>e[t]))):i=t.map((t=>e[t]));const a=n.filter(((t,e)=>r[e]));return i.concat(a)}return[]}makeTensor(t,e,n,s){if(null==t)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",s=s||this.backend;let r=t;"string"===n&&pn(t[0])&&(r=t.map((t=>function(t,e="utf-8"){return e=e||"utf-8",Nn().platform.encode(t,e)}(t))));const i=s.write(r,e,n),a=new xs(e,n,i,this.nextTensorId());if(this.trackTensor(a,s),"string"===n){const t=this.state.tensorInfo.get(i),e=function(t){if(null==t)return 0;let e=0;return t.forEach((t=>e+=t.length)),e}(r);this.state.numBytes+=e-t.bytes,t.bytes=e}return a}makeTensorFromDataId(t,e,n,s){const r={dataId:t,shape:e,dtype:n=n||"float32"};return this.makeTensorFromTensorInfo(r,s)}makeTensorFromTensorInfo(t,e){const{dataId:n,shape:s,dtype:r}=t,i=new xs(s,r,n,this.nextTensorId());return this.trackTensor(i,e),i}makeVariable(t,e=!0,n,s){n=n||this.nextVariableId().toString(),null!=s&&s!==t.dtype&&(t=t.cast(s));const r=new Ss(t,e,n,this.nextTensorId());if(null!=this.state.registeredVariables[r.name])throw new Error(`Variable with name ${r.name} was already registered`);return this.state.registeredVariables[r.name]=r,this.incRef(r,this.backend),r}trackTensor(t,e){this.state.numTensors++,"string"===t.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==t.dtype&&"string"!==t.dtype&&(n=t.size*cn(t.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(t.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(t.dataId,{backend:e||this.backend,dtype:t.dtype,shape:t.shape,bytes:n})),t instanceof Ss||this.track(t)}incRef(t,e){this.trackTensor(t,e),this.backend.incRef(t.dataId)}removeDataId(t,e){this.state.tensorInfo.has(t)&&this.state.tensorInfo.get(t).backend===e&&(this.state.tensorInfo.delete(t),this.state.numDataBuffers--)}disposeTensor(t){if(!this.state.tensorInfo.has(t.dataId))return;const e=this.state.tensorInfo.get(t.dataId);if(this.state.numTensors--,"string"===t.dtype&&(this.state.numStringTensors--,this.state.numBytes-=e.bytes),"complex64"!==t.dtype&&"string"!==t.dtype){const e=t.size*cn(t.dtype);this.state.numBytes-=e}e.backend.disposeData(t.dataId)&&this.removeDataId(t.dataId,e.backend)}disposeVariables(){for(const t in this.state.registeredVariables){const e=this.state.registeredVariables[t];this.disposeVariable(e)}}disposeVariable(t){this.disposeTensor(t),null!=this.state.registeredVariables[t.name]&&delete this.state.registeredVariables[t.name]}memory(){const t=this.backend.memory();return t.numTensors=this.state.numTensors,t.numDataBuffers=this.state.numDataBuffers,t.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(t.unreliable=!0,null==t.reasons&&(t.reasons=[]),t.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),t}async profile(t){this.state.profiling=!0;const e=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await t(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((t=>t.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-e,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const t of this.state.activeProfile.kernels)t.kernelTimeMs=await t.kernelTimeMs,t.extraInfo=await t.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(t,e,n,s,r,i){const a={id:this.state.nextTapeNodeId++,kernelName:t,inputs:e,outputs:n,saved:r},o=Dn(t);null!=o&&(s=o.gradFunc),null!=s&&(a.gradient=t=>(t=t.map(((t,e)=>{if(null==t){const t=n[e],s=wn(t.size,t.dtype);return this.makeTensor(s,t.shape,t.dtype)}return t})),s(t.length>1?t:t[0],r,i))),this.state.activeTape.push(a)}keep(t){return t.kept=!0,t}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(t){const e={track:[],name:"unnamed scope",id:this.state.nextScopeId++};t&&(e.name=t),this.state.scopeStack.push(e),this.state.activeScope=e}endScope(t){const e=zs(t),n=new Set(e.map((t=>t.id)));for(let t=0;t<this.state.activeScope.track.length;t++){const e=this.state.activeScope.track[t];e.kept||n.has(e.id)||e.dispose()}const s=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],e.forEach((t=>{t.kept||t.scopeId!==s.id||this.track(t)}))}gradients(t,e,n,s=!1){if(tn(e.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const r=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",t)));tn(r instanceof xs,(()=>"The result y returned by f() must be a tensor."));const i=function(t,e,n){const s={},r={};for(let t=0;t<e.length;t++)s[e[t].id]=!0;for(let n=0;n<t.length;n++){const i=t[n],a=i.inputs;for(const t in a){const n=a[t];let o=!1;for(let t=0;t<e.length;t++)if(s[n.id]){i.outputs.forEach((t=>s[t.id]=!0)),o=!0,r[i.id]=!0;break}if(o)break}}const i={};i[n.id]=!0;const a={};for(let e=t.length-1;e>=0;e--){const n=t[e],s=n.inputs;for(let t=0;t<n.outputs.length;t++)if(i[n.outputs[t].id]){for(const t in s)i[s[t].id]=!0,a[n.id]=!0;break}}const o=[];for(let e=0;e<t.length;e++){const n=t[e];if(r[n.id]&&a[n.id]){const t={};for(const e in n.inputs){const r=n.inputs[e];s[r.id]&&(t[e]=r)}const e=Object.assign({},n);e.inputs=t,e.outputs=n.outputs,o.push(e)}}return o}(this.state.activeTape,e,r);if(!s&&0===i.length&&e.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const t={};t[r.id]=null==n?function(t){const e=yn(rn(t),"float32");return Ms.makeTensor(e,t,"float32")}(r.shape):n,function(t,e,n,s){for(let r=e.length-1;r>=0;r--){const i=e[r],a=[];if(i.outputs.forEach((e=>{const n=t[e.id];null!=n?a.push(n):a.push(null)})),null==i.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${i.kernelName}.`);const o=i.gradient(a);for(const e in i.inputs){if(!(e in o))throw new Error(`Cannot backprop through input ${e}. Available gradients found: ${Object.keys(o)}.`);const r=n((()=>o[e]()));if("float32"!==r.dtype)throw new Error(`Error in gradient for op ${i.kernelName}. The gradient of input ${e} must have 'float32' dtype, but has '${r.dtype}'`);const a=i.inputs[e];if(!an(r.shape,a.shape))throw new Error(`Error in gradient for op ${i.kernelName}. The gradient of input '${e}' has shape '${r.shape}', which does not match the shape of the input '${a.shape}'`);if(null==t[a.id])t[a.id]=r;else{const e=t[a.id];t[a.id]=s(e,r),e.dispose()}}}}(t,i,(t=>this.tidy(t)),Ls);const s=e.map((e=>t[e.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((t=>{for(const e of t.saved)e.dispose()})),this.state.activeTape=null),{value:r,grads:s}}))}customGrad(t){return tn(fn(t),(()=>"The f passed in customGrad(f) must be a function.")),(...e)=>{let n;tn(e.every((t=>t instanceof xs)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const s={};e.forEach(((t,e)=>{s[e]=t}));return this.runKernelFunc({forwardFunc:(s,r)=>(n=t(...e,r),tn(n.value instanceof xs,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),tn(fn(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(t,s)=>{const r=n.gradFunc(t,s),i=Array.isArray(r)?r:[r];tn(i.length===e.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),tn(i.every((t=>t instanceof xs)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const a={};return i.forEach(((t,e)=>{a[e]=()=>t})),a},inputs:s})}}readSync(t){return this.state.tensorInfo.get(t).backend.readSync(t)}read(t){return this.state.tensorInfo.get(t).backend.read(t)}readToGPU(t,e){return this.state.tensorInfo.get(t).backend.readToGPU(t,e)}async time(t){const e=hs(),n=await this.backend.time(t);return n.wallMs=hs()-e,n}track(t){return null!=this.state.activeScope&&(t.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(t)),t}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new Fs;for(const t in this.registry)this.disposeRegisteredKernels(t),this.registry[t].dispose(),delete this.registry[t];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}Rs.nextTensorId=0,Rs.nextVariableId=0;const Ms=function(){const t=An();if(null==t._tfengine){const e=new xn(t);t._tfengine=new Rs(e)}var e;return e=t._tfengine.ENV,In=e,vs=()=>t._tfengine,t._tfengine}();function Ls(t,e){const n={a:t,b:e};return Ms.runKernel("Add",n)}function Os(t,e){let n=t;if(hn(t))return"string"===e?[]:[t.length];if("object"==typeof t&&"texture"in t){const e=t.channels||"RGBA";return[t.height,t.width*e.length]}if(!Array.isArray(t))return[];const s=[];for(;Array.isArray(n)||hn(n)&&"string"!==e;)s.push(n.length),n=n[0];return Array.isArray(t)&&Nn().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&Bs(t,s,[]),s}function Bs(t,e,n){if(n=n||[],!Array.isArray(t)&&!hn(t))return void tn(0===e.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${e[0]} elements`));tn(e.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${t.length} elements`)),tn(t.length===e[0],(()=>`Element arr[${n.join("][")}] should have ${e[0]} elements, but has ${t.length} elements`));const s=e.slice(1);for(let e=0;e<t.length;++e)Bs(t[e],s,n.concat(e))}function Ps(t,e,n,s){if("string_or_numeric"!==t){if(null==t)throw new Error("Expected dtype cannot be null.");if("numeric"!==t&&t!==e||"numeric"===t&&"string"===e)throw new Error(`Argument '${n}' passed to '${s}' must be ${t} tensor, but got ${e} tensor`)}}function Ws(t,e,n,s="numeric"){if(t instanceof xs)return Ps(s,t.dtype,e,n),t;let r=dn(t);if("string"!==r&&["bool","int32","float32"].indexOf(s)>=0&&(r=s),Ps(s,r,e,n),null==t||!hn(t)&&!Array.isArray(t)&&"number"!=typeof t&&"boolean"!=typeof t&&"string"!=typeof t){const s=null==t?"null":t.constructor.name;throw new Error(`Argument '${e}' passed to '${n}' must be a Tensor or TensorLike, but got '${s}'`)}const i=Os(t,r);hn(t)||Array.isArray(t)||(t=[t]);const a="string"!==r?us(t,r):sn(t,[],!0);return Ms.makeTensor(a,i,r)}function Us(t,e,n,s="numeric"){if(!Array.isArray(t))throw new Error(`Argument ${e} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return t.map(((t,r)=>Ws(t,`${e}[${r}]`,n,s)))}function Vs(t){const e=Object.keys(t);if(1!==e.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${e.length} keys.`);let n=e[0];const s=t[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+="__op";const r=(...t)=>{Ms.startScope(n);try{const e=s(...t);return vn(e)&&console.error("Cannot return a Promise inside of tidy."),Ms.endScope(e),e}catch(t){throw Ms.endScope(null),t}};return Object.defineProperty(r,"name",{value:n,configurable:!0}),r}const Ks=Vs({cast_:function(t,e){const n=Ws(t,"x","cast");if(!function(t){return"bool"===t||"complex64"===t||"float32"===t||"int32"===t||"string"===t}(e))throw new Error(`Failed to cast to unknown dtype ${e}`);if("string"===e&&"string"!==n.dtype||"string"!==e&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const s={x:n},r={dtype:e};return Ms.runKernel("Cast",s,r)}});const js=Vs({mul_:function(t,e){let n=Ws(t,"a","mul"),s=Ws(e,"b","mul");[n,s]=Cs(n,s);const r={a:n,b:s};return Ms.runKernel("Multiply",r)}});const qs=Vs({step_:function(t,e=0){const n={x:Ws(t,"x","step")},s={alpha:e};return Ms.runKernel("Step",n,s)}}),Gs={kernelName:"Abs",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>js(t,qs(Ks(n,"float32"),-1))}}};const Hs=Vs({floorDiv_:function(t,e){let n=Ws(t,"a","floorDiv"),s=Ws(e,"b","floorDiv");[n,s]=Cs(n,s);const r={a:n,b:s};return Ms.runKernel("FloorDiv",r)}});const Js=Vs({div_:function(t,e){let n=Ws(t,"a","div"),s=Ws(e,"b","div");if([n,s]=Cs(n,s),"int32"===n.dtype&&"int32"===s.dtype)return Hs(n,s);const r={a:n,b:s};return Ms.runKernel("RealDiv",r,{})}});const Zs=Vs({neg_:function(t){const e={x:Ws(t,"x","neg")};return Ms.runKernel("Neg",e)}});function Ys(t,e,n,s){if(null==s&&(s=dn(t)),"complex64"===s)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if("object"==typeof t&&"texture"in t){if("float32"!==s&&"int32"!==s)throw new Error(`Creating tensor from texture only supports 'float32'|'int32' dtype, while the dtype is ${s}.`);return t.channels=t.channels||"RGBA",Ms.backend.createTensorFromTexture(t,e||n,s)}if(!hn(t)&&!Array.isArray(t)&&"number"!=typeof t&&"boolean"!=typeof t&&"string"!=typeof t)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=e){kn(e);const t=rn(e),s=rn(n);tn(t===s,(()=>`Based on the provided shape, [${e}], the tensor should have ${t} values but has ${s}`));for(let t=0;t<n.length;++t){const s=n[t],r=t!==n.length-1||s!==rn(e.slice(t));tn(n[t]===e[t]||!r,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${e}). `))}}return hn(t)||Array.isArray(t)||(t=[t]),e=e||n,t="string"!==s?us(t,s):sn(t,[],!0),Ms.makeTensor(t,e,s)}function Xs(t,e){if((hn(t)&&"string"!==e||Array.isArray(t))&&"complex64"!==e)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===e&&hn(t)&&!(t instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return Ys(t,[],[],e)}const Qs=Vs({sqrt_:function(t){const e={x:Ws(t,"x","sqrt","float32")};return Ms.runKernel("Sqrt",e)}});const tr=Vs({square_:function(t){const e=Ws(t,"x","square");return Ms.runKernel("Square",{x:e},{})}});const er=Vs({sub_:function(t,e){let n=Ws(t,"a","sub"),s=Ws(e,"b","sub");[n,s]=Cs(n,s);const r={a:n,b:s};return Ms.runKernel("Sub",r)}}),nr={kernelName:"Acos",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=tr(Ks(n,"float32")),s=Qs(er(Xs(1),e));return Zs(Js(t,s))}}}},sr={kernelName:"Acosh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Qs(er(tr(Ks(n,"float32")),1));return Js(t,e)}}}};function rr(t,e){const n=[];for(let s=0;s<e.length;s++){const r=t[t.length-s-1],i=e.length-s-1,a=e[i];(null==r||1===r&&a>1)&&n.unshift(i)}return n}function ir(t,e){const n=[],s=Math.max(t.length,e.length);for(let r=0;r<s;r++){let s=t[t.length-r-1];null==s&&(s=1);let i=e[e.length-r-1];if(null==i&&(i=1),1===s)n.unshift(i);else if(1===i)n.unshift(s);else{if(s!==i){throw Error(`Operands could not be broadcast together with shapes ${t} and ${e}.`)}n.unshift(s)}}return n}const ar=Vs({reshape_:function(t,e){const n={x:Ws(t,"x","reshape","string_or_numeric")},s={shape:e};return Ms.runKernel("Reshape",n,s)}});const or=Vs({sum_:function(t,e=null,n=!1){let s=Ws(t,"x","sum");"bool"===s.dtype&&(s=Ks(s,"int32"));const r={x:s},i={axis:e,keepDims:n};return Ms.runKernel("Sum",r,i)}}),lr={kernelName:"Add",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=ir(n.shape,s.shape);return{a:()=>{let e=t;const s=rr(n.shape,r);return s.length>0&&(e=or(e,s)),ar(e,n.shape)},b:()=>{let e=t;const n=rr(s.shape,r);return n.length>0&&(e=or(e,n)),ar(e,s.shape)}}}},ur={kernelName:"AddN",saveAllInputs:!0,gradFunc:(t,e)=>{const n={};return e.forEach(((e,s)=>{n[s]=()=>t.clone()})),n}};const hr=Vs({zerosLike_:function(t){const e={x:Ws(t,"x","zerosLike")};return Ms.runKernel("ZerosLike",e)}}),cr={kernelName:"ArgMax",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>hr(n)}}},pr={kernelName:"ArgMin",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>hr(n)}}},dr={kernelName:"Asin",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Js(t,Qs(er(Xs(1),tr(Ks(n,"float32")))))}}};const fr=Vs({add_:function(t,e){let n=Ws(t,"a","add"),s=Ws(e,"b","add");[n,s]=Cs(n,s);const r={a:n,b:s};return Ms.runKernel("Add",r)}}),gr={kernelName:"Asinh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Qs(fr(Xs(1),tr(Ks(n,"float32"))));return Js(t,e)}}}},mr={kernelName:"Atan2",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=ir(n.shape,s.shape);return{a:()=>{const e=fr(tr(n),tr(s));let i=js(t,Js(s,e));const a=rr(n.shape,r);return a.length>0&&(i=or(i,a)),ar(i,n.shape)},b:()=>{const e=fr(tr(n),tr(s));let i=Zs(js(t,Js(n,e)));const a=rr(s.shape,r);return a.length>0&&(i=or(i,a)),ar(i,s.shape)}}}},br={kernelName:"Atan",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Js(t,fr(tr(Ks(n,"float32")),1))}}},yr={kernelName:"Atanh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Js(t,er(Xs(1),tr(Ks(n,"float32"))))}}};function wr(t,e,n,s,r,i,a=!1,o="channelsLast"){let[l,u,h,c]=[-1,-1,-1,-1];if("channelsLast"===o)[l,u,h,c]=t;else{if("channelsFirst"!==o)throw new Error(`Unknown dataFormat ${o}`);[l,c,u,h]=t}const[p,d,,f]=e,[g,m]=kr(n),[b,y]=kr(s),w=vr(p,b),k=vr(d,y),{padInfo:v,outHeight:x,outWidth:S}=function(t,e,n,s,r,i,a,o,l){let u,h,c;if("number"==typeof t){u={top:t,bottom:t,left:t,right:t,type:0===t?"VALID":"NUMBER"};const r=function(t,e,n,s,r){null==s&&(s=function(t,e,n,s=1){const r=vr(e,s);return Math.floor((t[0]*(n-1)-n+r)/2)}(t,e,n));const i=t[0],a=t[1],o=xr((i-e+2*s)/n+1,r),l=xr((a-e+2*s)/n+1,r);return[o,l]}([e,n],i,s,t,o);h=r[0],c=r[1]}else if("same"===t){h=Math.ceil(e/s),c=Math.ceil(n/r);const t=Math.max(0,(h-1)*s+i-e),o=Math.max(0,(c-1)*r+a-n),l=Math.floor(t/2),p=t-l,d=Math.floor(o/2);u={top:l,bottom:p,left:d,right:o-d,type:"SAME"}}else if("valid"===t)u={top:0,bottom:0,left:0,right:0,type:"VALID"},h=Math.ceil((e-i+1)/s),c=Math.ceil((n-a+1)/r);else{if("object"!=typeof t)throw Error(`Unknown padding parameter: ${t}`);{const p="channelsLast"===l?t[1][0]:t[2][0],d="channelsLast"===l?t[1][1]:t[2][1],f="channelsLast"===l?t[2][0]:t[3][0],g="channelsLast"===l?t[2][1]:t[3][1];u={top:p,bottom:d,left:f,right:g,type:0===p&&0===d&&0===f&&0===g?"VALID":"EXPLICIT"},h=xr((e-i+p+d)/s+1,o),c=xr((n-a+f+g)/r+1,o)}}return{padInfo:u,outHeight:h,outWidth:c}}(r,u,h,g,m,w,k,i,o),N=a?f*c:f;let E;return"channelsFirst"===o?E=[l,N,x,S]:"channelsLast"===o&&(E=[l,x,S,N]),{batchSize:l,dataFormat:o,inHeight:u,inWidth:h,inChannels:c,outHeight:x,outWidth:S,outChannels:N,padInfo:v,strideHeight:g,strideWidth:m,filterHeight:p,filterWidth:d,effectiveFilterHeight:w,effectiveFilterWidth:k,dilationHeight:b,dilationWidth:y,inShape:t,outShape:E,filterShape:e}}function kr(t){return"number"==typeof t?[t,t,t]:2===t.length?[t[0],t[1],1]:t}function vr(t,e){return e<=1?t:t+(t-1)*(e-1)}function xr(t,e){if(!e)return Math.trunc(t);switch(e){case"round":return Math.round(t);case"ceil":return Math.ceil(t);case"floor":return Math.floor(t);default:throw new Error(`Unknown roundingMode ${e}`)}}function Sr(t){const[e,n,s]=kr(t);return 1===e&&1===n&&1===s}function Nr(t,e){return Sr(t)||Sr(e)}function Er(t,e,n){if(null!=n){if("string"==typeof e)throw Error(`Error in ${t}: pad must be an integer when using dimRoundingMode ${n} but got pad ${e}.`);if("number"==typeof e)tn(on(e),(()=>`Error in ${t}: pad must be an integer when using dimRoundingMode ${n} but got pad ${e}.`));else{if("object"!=typeof e)throw Error(`Error in ${t}: Unknown padding parameter: ${e}`);e.forEach((e=>{e.forEach((e=>{tn(on(e),(()=>`Error in ${t}: pad must be an integer when using dimRoundingMode ${n} but got pad ${e}.`))}))}))}}}const Ir=Vs({avgPool3dGrad_:function(t,e,n,s,r,i){const a=Ws(t,"dy","avgPool3dGrad"),o=Ws(e,"input","avgPool3dGrad");let l=a,u=o,h=!1;4===o.rank&&(h=!0,l=ar(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]]),u=ar(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),tn(5===l.rank,(()=>`Error in avgPool3dGrad: dy must be rank 5 but got rank ${l.rank}.`)),tn(5===u.rank,(()=>`Error in avgPool3dGrad: input must be rank 5 but got rank ${u.rank}.`)),Er("avgPool3dGrad",r,i);const c={dy:l,input:u},p={filterSize:n,strides:s,pad:r,dimRoundingMode:i},d=Ms.runKernel("AvgPool3DGrad",c,p);return h?ar(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}}),Ar={kernelName:"AvgPool3D",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{filterSize:r,strides:i,pad:a,dimRoundingMode:o}=n;return{x:()=>Ir(t,s,r,i,a,o)}}};const Tr=Vs({avgPoolGrad_:function(t,e,n,s,r){const i=Ws(t,"dy","avgPoolGrad"),a=Ws(e,"input","avgPoolGrad");tn(a.rank===i.rank,(()=>`Rank of input (${a.rank}) does not match rank of dy (${i.rank})`));let o=a,l=i,u=!1;3===a.rank&&(u=!0,o=ar(a,[1,a.shape[0],a.shape[1],a.shape[2]]),l=ar(i,[1,i.shape[0],i.shape[1],i.shape[2]])),tn(4===l.rank,(()=>`Error in avgPoolGrad: dy must be rank 4 but got rank ${l.rank}.`)),tn(4===o.rank,(()=>`Error in avgPoolGrad: input must be rank 4 but got rank ${o.rank}.`));const h={dy:l,input:o},c={filterSize:n,strides:s,pad:r},p=Ms.runKernel("AvgPoolGrad",h,c);return u?ar(p,[p.shape[1],p.shape[2],p.shape[3]]):p}}),$r={kernelName:"AvgPool",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{filterSize:r,strides:i,pad:a}=n;return{x:()=>Tr(t,s,r,i,a)}}};const Cr=Vs({matMul_:function(t,e,n=!1,s=!1){let r=Ws(t,"a","matMul"),i=Ws(e,"b","matMul");[r,i]=Cs(r,i);const a={a:r,b:i},o={transposeA:n,transposeB:s};return Ms.runKernel("BatchMatMul",a,o)}}),zr={kernelName:"BatchMatMul",inputsToSave:["a","b"],gradFunc:(t,e,n)=>{const[s,r]=e,{transposeA:i,transposeB:a}=n;return i||a?!i&&a?{a:()=>Cr(t,r,!1,!1),b:()=>Cr(t,s,!0,!1)}:i&&!a?{a:()=>Cr(r,t,!1,!0),b:()=>Cr(s,t,!1,!1)}:{a:()=>Cr(r,t,!0,!0),b:()=>Cr(t,s,!0,!0)}:{a:()=>Cr(t,r,!1,!0),b:()=>Cr(s,t,!0,!1)}}};const _r=Vs({spaceToBatchND_:function(t,e,n){const s=Ws(t,"x","spaceToBatchND");tn(s.rank>=1+e.length,(()=>`input rank ${s.rank} should be > than [blockShape] ${e.length}`)),tn(n.length===e.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${e.length}`)),tn(s.shape.reduce(((t,s,r)=>r>0&&r<=e.length?t&&(s+n[r-1][0]+n[r-1][1])%e[r-1]==0:t),!0),(()=>`input spatial dimensions ${s.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${e.toString()}`));const r={x:s},i={blockShape:e,paddings:n};return Ms.runKernel("SpaceToBatchND",r,i)}}),Dr={kernelName:"BatchToSpaceND",gradFunc:(t,e,n)=>{const{blockShape:s,crops:r}=n;return{x:()=>_r(t,s,r)}}},Fr={kernelName:"BroadcastTo",gradFunc:(t,e,n)=>{const s=n,r=s.inputShape,i=s.shape,a=Array.from(i);for(let t=r.length-1;t>=0;t--)if(r[t]===i[t])a[t]=1;else if(1!==r[t])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${i}].`);const o=[];for(let t=0;t<a.length;t++)a[t]>1&&o.push(t);return{x:()=>or(t,o,!0)}}},Rr={kernelName:"Cast",gradFunc:t=>({x:()=>t.clone()})},Mr={kernelName:"Ceil",gradFunc:t=>({x:()=>hr(t)})};const Lr=Vs({greaterEqual_:function(t,e){let n=Ws(t,"a","greaterEqual","string_or_numeric"),s=Ws(e,"b","greaterEqual","string_or_numeric");[n,s]=Cs(n,s),ir(n.shape,s.shape);const r={a:n,b:s};return Ms.runKernel("GreaterEqual",r)}});const Or=Vs({lessEqual_:function(t,e){let n=Ws(t,"a","lessEqual","string_or_numeric"),s=Ws(e,"b","lessEqual","string_or_numeric");[n,s]=Cs(n,s),ir(n.shape,s.shape);const r={a:n,b:s};return Ms.runKernel("LessEqual",r)}});const Br=Vs({logicalAnd_:function(t,e){const n=Ws(t,"a","logicalAnd","bool"),s=Ws(e,"b","logicalAnd","bool");ir(n.shape,s.shape);const r={a:n,b:s};return Ms.runKernel("LogicalAnd",r)}});const Pr=Vs({clone_:function(t){const e={x:Ws(t,"x","clone","string_or_numeric")};return Ms.runKernel("Identity",e)}});const Wr=Vs({broadcastTo_:function(t,e){let n=Ws(t,"broadcastTo","x");const s=n.shape;if(e.some((t=>!(t>0)||t%1!=0)))throw new Error(`broadcastTo(): Invalid broadcast shape [${e}].`);if(e.length<n.rank)throw new Error(`broadcastTo(): shape.length=${e.length} < input.rank=${n.rank}.`);if(e.length>n.rank){const t=n.shape.slice();for(;t.length<e.length;)t.unshift(1);n=ar(n,t)}const r=n.shape,i=Array.from(e);for(let t=e.length-1;t>=0;t--)if(r[t]===e[t])i[t]=1;else if(1!==n.shape[t])throw new Error(`broadcastTo(): [${s}] cannot be broadcast to [${e}].`);if(0===i.map(((t,e)=>t>1?e:-1)).filter((t=>t>=0)).length)return Pr(n);const a={x:n},o={reps:i};return Ms.runKernel("Tile",a,o)}});const Ur=Vs({where_:function(t,e,n){const s=Ws(e,"a","where"),r=Ws(n,"b","where"),i=Ws(t,"condition","where","bool"),a=ir(ir(i.shape,s.shape),r.shape),o={condition:Wr(i,a),t:Wr(s,a),e:Wr(r,a)};return Ms.runKernel("Select",o)}}),Vr={kernelName:"ClipByValue",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{clipValueMin:r,clipValueMax:i}=n;return{x:()=>Ur(Br(Lr(s,r),Or(s,i)),t,hr(t))}}},Kr={kernelName:"ComplexAbs",inputsToSave:["x"],gradFunc:Gs.gradFunc};const jr=Vs({split_:function(t,e,n=0){const s={x:Ws(t,"x","split")},r={numOrSizeSplits:e,axis:n};return Ms.runKernel("SplitV",s,r)}}),qr={kernelName:"Concat",saveAllInputs:!0,gradFunc:(t,e,n)=>{const s=e.map((t=>t.shape)),{axis:r}=n,i=un(r,e[0].shape)[0],a=s.map((t=>t[i]));return jr(t,a,i).map((t=>()=>t))}};const Gr=Vs({conv2DBackpropFilter_:function(t,e,n,s,r,i="NHWC",a){let o=t;3===t.rank&&(o=ar(t,[1,t.shape[0],t.shape[1],t.shape[2]]));let l=e;3===l.rank&&(l=ar(e,[1,e.shape[0],e.shape[1],e.shape[2]])),tn(4===o.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${o.shape}.`)),tn(4===l.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${l.shape}.`)),tn(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const u="NHWC"===i?o.shape[3]:o.shape[1],h="NHWC"===i?l.shape[3]:l.shape[1];tn(u===n[2],(()=>`Error in conv2dDerFilter: depth of input ${u}) must match input depth in filter (${n[2]}.`)),tn(h===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`)),Er("conv2dDerFilter",r,a);const c={x:o,dy:l},p={strides:s,pad:r,dataFormat:i,dimRoundingMode:a,filterShape:n};return Ms.runKernel("Conv2DBackpropFilter",c,p)}});const Hr=Vs({conv2DBackpropInput_:function(t,e,n,s,r,i="NHWC",a){tn(t.length===e.rank,(()=>`Length of inShape (${t.length}) and rank of dy (${e.rank}) must match`));let o=t,l=e,u=!1;3===e.rank&&(u=!0,l=ar(e,[1,e.shape[0],e.shape[1],e.shape[2]]),o=[1,t[0],t[1],t[2]]),tn(4===o.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${o.length}.`)),tn(4===l.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${l.rank}`)),tn(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const h="NHWC"===i?o[3]:o[1],c="NHWC"===i?l.shape[3]:l.shape[1];tn(h===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`)),tn(c===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[3]}.`)),Er("conv2dDerInput",r,a);const p={dy:l,filter:n},d={strides:s,pad:r,dataFormat:i,dimRoundingMode:a,inputShape:o},f=Ms.runKernel("Conv2DBackpropInput",p,d);return u?ar(f,[f.shape[1],f.shape[2],f.shape[3]]):f}}),Jr={kernelName:"Conv2D",inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,{dilations:i,strides:a,pad:o,dataFormat:l}=n;return tn(Sr(i),(()=>`Error in gradient of conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${i}'`)),{x:()=>Hr(s.shape,t,r,a,o,l),filter:()=>Gr(s,t,r.shape,a,o,l)}}};const Zr=Vs({conv2d_:function(t,e,n,s,r="NHWC",i=[1,1],a){const o=Ws(t,"x","conv2d","float32"),l=Ws(e,"filter","conv2d","float32");let u=o,h=!1;3===o.rank&&(h=!0,u=ar(o,[1,o.shape[0],o.shape[1],o.shape[2]])),tn(4===u.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${u.rank}.`)),tn(4===l.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${l.rank}.`)),Er("conv2d",s,a);const c="NHWC"===r?u.shape[3]:u.shape[1];tn(c===l.shape[2],(()=>`Error in conv2d: depth of input (${c}) must match input depth for filter ${l.shape[2]}.`)),tn(Nr(n,i),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`));const p={x:u,filter:l},d={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a},f=Ms.runKernel("Conv2D",p,d);return h?ar(f,[f.shape[1],f.shape[2],f.shape[3]]):f}}),Yr={kernelName:"Conv2DBackpropInput",inputsToSave:["dy","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,{strides:i,pad:a,dataFormat:o,dimRoundingMode:l}=n;return{dy:()=>Zr(t,r,i,a,o,1,l),filter:()=>Gr(t,s,r.shape,i,a,o,l)}}};const Xr=Vs({conv3DBackpropFilter_:function(t,e,n,s,r){let i=t;4===t.rank&&(i=ar(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]));let a=e;4===a.rank&&(a=ar(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]])),tn(5===i.rank,(()=>`Error in conv3dDerFilter: input must be rank 5, but got shape ${i.shape}.`)),tn(5===a.rank,(()=>`Error in conv3dDerFilter: dy must be rank 5, but got shape ${a.shape}.`)),tn(5===n.length,(()=>`Error in conv3dDerFilter: filterShape must be length 5, but got ${n}.`)),tn(i.shape[4]===n[3],(()=>`Error in conv3dDerFilter: depth of input ${i.shape[4]}) must match input depth in filter (${n[3]}.`)),tn(a.shape[4]===n[4],(()=>`Error in conv3dDerFilter: depth of dy (${a.shape[4]}) must match output depth for filter (${n[4]}).`));const o={x:i,dy:a},l={strides:s,pad:r,filterShape:n};return Ms.runKernel("Conv3DBackpropFilterV2",o,l)}});const Qr=Vs({conv3DBackpropInput_:function(t,e,n,s,r){tn(t.length===e.rank,(()=>`Length of inShape (${t.length}) and rank of dy (${e.rank}) must match`));let i=t,a=e,o=!1;4===e.rank&&(o=!0,a=ar(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]]),i=[1,t[0],t[1],t[2],t[3]]);const l=i[4],u=a.shape[4];tn(5===i.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${i.length}.`)),tn(5===a.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${a.rank}`)),tn(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),tn(l===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${l}) must match input depth for filter ${n.shape[3]}.`)),tn(u===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${u}) must match output depth for filter ${n.shape[4]}.`));const h={dy:a,filter:n},c={pad:r,strides:s,inputShape:i},p=Ms.runKernel("Conv3DBackpropInputV2",h,c);return o?ar(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}}),ti={kernelName:"Conv3D",inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const{dilations:s,strides:r,pad:i}=n;tn(Sr(s),(()=>`Error in gradient of conv3D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${s}'`));const[a,o]=e;return{x:()=>Qr(a.shape,t,o,r,i),filter:()=>Xr(a,t,o.shape,r,i)}}};const ei=Vs({sin_:function(t){const e={x:Ws(t,"x","sin","float32")};return Ms.runKernel("Sin",e)}}),ni={kernelName:"Cos",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>js(Zs(ei(Ks(n,"float32"))),t)}}};const si=Vs({sinh_:function(t){const e={x:Ws(t,"x","sinh")};return Ms.runKernel("Sinh",e)}}),ri={kernelName:"Cosh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>js(si(Ks(n,"float32")),t)}}};function ii(t,e){return function(t,e,n){const s=t.length+e.length,r=[];let i=0,a=0;for(let o=0;o<s;o++)-1===n.indexOf(o)?r.push(t[i++]):r.push(e[a++]);return r}(t,e.map((t=>1)),e)}function ai(t,e){if(function(t,e){for(let n=0;n<t.length;++n)if(t[t.length-n-1]!==e-1-n)return!1;return!0}(t,e))return null;const n=[];for(let s=0;s<e;++s)-1===t.indexOf(s)&&n.push(s);return t.forEach((t=>n.push(t))),n}function oi(t){return t.map(((t,e)=>[e,t])).sort(((t,e)=>t[1]-e[1])).map((t=>t[0]))}const li=Vs({cumsum_:function(t,e=0,n=!1,s=!1){const r={x:Ws(t,"x","cumsum")},i={axis:e,exclusive:n,reverse:s};return Ms.runKernel("Cumsum",r,i)}});function ui(t,e){return Ms.tidy(t,e)}function hi(t){zs(t).forEach((t=>t.dispose()))}const ci=Vs({complex_:function(t,e){const n=Ws(t,"real","complex"),s=Ws(e,"imag","complex");en(n.shape,s.shape,`real and imag shapes, ${n.shape} and ${s.shape}, must match in call to tf.complex().`);const r={real:n,imag:s};return Ms.runKernel("Complex",r)}});const pi=Vs({imag_:function(t){const e={input:Ws(t,"input","imag")};return Ms.runKernel("Imag",e)}});const di=Vs({real_:function(t){const e={input:Ws(t,"input","real")};return Ms.runKernel("Real",e)}});const fi=Vs({transpose_:function(t,e,n){const s=Ws(t,"x","transpose");if(null==e&&(e=s.shape.map(((t,e)=>e)).reverse()),tn(s.rank===e.length,(()=>`Error in transpose: rank of input ${s.rank} must match length of perm ${e}.`)),e.forEach((t=>{tn(t>=0&&t<s.rank,(()=>"All entries in 'perm' must be between 0 and "+(s.rank-1)+` but got ${e}`))})),s.rank<=1)return s.clone();const r={x:s},i={perm:e};return"complex64"===s.dtype?ui((()=>{let t=di(s),e=pi(s);return t=Ms.runKernel("Transpose",{x:t},i),e=Ms.runKernel("Transpose",{x:e},i),n&&(e=Zs(e)),ci(t,e)})):Ms.runKernel("Transpose",r,i)}}),gi={kernelName:"Cumsum",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r,exclusive:i,reverse:a}=n;return{x:()=>{const e=ai([r],s.rank);let n=li(t,r,i,!a);return null!=e&&(n=fi(n,e)),n}}}};const mi=Vs({depthwiseConv2dNativeBackpropFilter_:function(t,e,n,s,r,i=[1,1],a){let o=t;3===t.rank&&(o=ar(t,[1,t.shape[0],t.shape[1],t.shape[2]]));let l=e;3===l.rank&&(l=ar(e,[1,e.shape[0],e.shape[1],e.shape[2]]));const u={x:o,dy:l},h={strides:s,pad:r,dimRoundingMode:a,dilations:i,filterShape:n};return Ms.runKernel("DepthwiseConv2dNativeBackpropFilter",u,h)}});const bi=Vs({depthwiseConv2dNativeBackpropInput_:function(t,e,n,s,r,i=[1,1],a){let o=e,l=!1;3===e.rank&&(l=!0,o=ar(e,[1,e.shape[0],e.shape[1],e.shape[2]]));const u={dy:o,filter:n},h={strides:s,pad:r,dimRoundingMode:a,dilations:i,inputShape:t},c=Ms.runKernel("DepthwiseConv2dNativeBackpropInput",u,h);return l?ar(c,[c.shape[1],c.shape[2],c.shape[3]]):c}}),yi={kernelName:"DepthwiseConv2dNative",inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const{dilations:s,strides:r,pad:i,dimRoundingMode:a}=n,o=null==s?[1,1]:s;tn(Sr(o),(()=>`Error in gradient of depthwiseConv2dNative: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`));const[l,u]=e;return tn(4===l.rank,(()=>`Error in gradient of depthwiseConv2dNative: input must be rank 4, but got rank ${l.rank}.`)),tn(4===u.rank,(()=>`Error in gradient of depthwiseConv2dNative: filter must be rank 4, but got rank ${u.rank}.`)),tn(l.shape[3]===u.shape[2],(()=>`Error in gradient of depthwiseConv2d: number of input channels (${l.shape[3]}) must match the inChannels dimension in filter ${u.shape[2]}.`)),tn(Nr(r,o),(()=>`Error in gradient of depthwiseConv2d: Either strides or dilations must be  1. Got strides ${r} and dilations '${o}'.`)),Er("depthwiseConv2d",i,a),{x:()=>bi(l.shape,t,u,r,i,o,a),filter:()=>mi(l,t,u.shape,r,i,o,a)}}},wi={kernelName:"Dilation2D",inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,i={x:s,filter:r,dy:t},a={x:s,filter:r,dy:t};return{x:()=>Ms.runKernel("Dilation2DBackpropInput",i,n),filter:()=>Ms.runKernel("Dilation2DBackpropFilter",a,n)}}},ki={kernelName:"Elu",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e,s={dy:t,y:n};return{x:()=>Ms.runKernel("EluGrad",s)}}};const vi=Vs({exp_:function(t){const e={x:Ws(t,"x","exp")};return Ms.runKernel("Exp",e)}}),xi={kernelName:"Erf",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e,s=js(vi(Zs(tr(n))),2/Math.sqrt(Math.PI));return{x:()=>js(t,s)}}},Si={kernelName:"Exp",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>js(t,n)}}},Ni={kernelName:"ExpandDims",inputsToSave:["input"],gradFunc:(t,e)=>{const[n]=e;return{input:()=>ar(t,n.shape)}}},Ei={kernelName:"Expm1",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>js(t,vi(n))}}},Ii={kernelName:"Floor",gradFunc:t=>({x:()=>hr(t)})},Ai={kernelName:"FloorDiv",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=ir(n.shape,s.shape);return{a:()=>{const e=Js(t,Ks(s,"float32")),i=rr(n.shape,r);return i.length>0?ar(or(e,i),n.shape):e},b:()=>{let e=js(t,Ks(n,"float32"));const i=rr(s.shape,r);i.length>0&&(e=ar(or(e,i),s.shape));const a=tr(s);return Zs(Js(e,Ks(a,"float32")))}}}};const Ti=Vs({rsqrt_:function(t){const e={x:Ws(t,"x","rsqrt","float32")};return Ms.runKernel("Rsqrt",e)}});const $i=Vs({tile_:function(t,e){const n=Ws(t,"x","tile","string_or_numeric");tn(n.rank===e.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${e}.`));const s={x:n},r={reps:e};return Ms.runKernel("Tile",s,r)}}),Ci={kernelName:"FusedBatchNorm",inputsToSave:["x","mean","variance","scale"],gradFunc:(t,e,n)=>{const{varianceEpsilon:s}=n,[r,i,a,o]=e,l=null==o?Xs(1):o,u=rr(i.shape,r.shape),h=[];if(1===i.rank){for(let t=0;t<r.shape.length-1;++t)h.push(r.shape[t]);h.push(1)}const c=er(r,i),p=js(t,l),d=Ti(fr(a,Xs(s))),f=js(js(js(d,d),d),Xs(-.5));return{x:()=>1===i.rank?ar(js(js(t,$i(ar(d,[1,1,1,i.shape[0]]),h)),l),r.shape):ar(js(js(t,d),l),r.shape),mean:()=>{let t=js(js(d,Xs(-1)),p);return 1===i.rank&&(t=or(t,u)),ar(t,i.shape)},variance:()=>{let t=js(js(f,c),p);return 1===i.rank&&(t=or(t,u)),ar(t,i.shape)},scale:()=>{const e=js(c,d);let n=js(t,e);return 1===i.rank&&(n=or(n,u)),ar(n,i.shape)},offset:()=>{let e=t;return 1===i.rank&&(e=or(e,u)),ar(e,i.shape)}}}};const zi=Vs({unsortedSegmentSum_:function(t,e,n){const s=Ws(t,"x","unsortedSegmentSum"),r=Ws(e,"segmentIds","unsortedSegmentSum","int32");tn(on(n),(()=>"numSegments must be of dtype int"));const i={x:s,segmentIds:r},a={numSegments:n};return Ms.runKernel("UnsortedSegmentSum",i,a)}}),_i={kernelName:"GatherV2",inputsToSave:["x","indices"],gradFunc:(t,e,n)=>{const[s,r]=e,{axis:i}=n,a=un(i,s.shape)[0];return{x:()=>{const e=s.shape,n=r.size,o=e.slice(0,a),l=o.length,u=e.slice(i,e.length).slice(1),h=u.length,c=Di(0,l),p=Di(l+1,l+1+h),d=Fi([o,[n],u]),f=ar(t,d),g=ar(r,[n]),m=Fi([[l],c,p]),b=fi(f,m);let y=zi(b,g,s.shape[a]);const w=oi(m);return y=fi(y,w),y},indices:()=>r}}};function Di(t,e){const n=[];for(let s=t;s<e;++s)n.push(s);return n}function Fi(t){const e=[];for(let n=0;n<t.length;++n)for(let s=0;s<t[n].length;++s)e.push(t[n][s]);return e}const Ri={kernelName:"GreaterEqual",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>hr(n),b:()=>hr(s)}}},Mi={kernelName:"Identity",gradFunc:t=>({x:()=>Ks(t,"float32")})},Li={kernelName:"IsFinite",gradFunc:t=>({x:()=>hr(t)})},Oi={kernelName:"IsInf",gradFunc:t=>({x:()=>hr(t)})},Bi={kernelName:"IsNan",gradFunc:t=>({x:()=>hr(t)})};const Pi=Vs({greater_:function(t,e){let n=Ws(t,"a","greater","string_or_numeric"),s=Ws(e,"b","greater","string_or_numeric");[n,s]=Cs(n,s),ir(n.shape,s.shape);const r={a:n,b:s};return Ms.runKernel("Greater",r)}}),Wi={kernelName:"LeakyRelu",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{alpha:r}=n,i=Pi(s,0);return{x:()=>Ur(i,t,js(t,r))}}},Ui={kernelName:"Log1p",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Js(t,fr(n,1))}}},Vi={kernelName:"Log",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Js(t,Ks(n,"float32"))}}},Ki={kernelName:"LogSoftmax",inputsToSave:[],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n;return{logits:()=>{const e=vi(s);return er(t,js(or(t,r,!0),e))}}}};const ji=Vs({localResponseNormalizationBackprop_:function(t,e,n,s=5,r=1,i=1,a=.5){const o={x:t,y:e,dy:n},l={depthRadius:s,bias:r,alpha:i,beta:a};return Ms.runKernel("LRNGrad",o,l)}}),qi={kernelName:"LRN",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{depthRadius:i,bias:a,alpha:o,beta:l}=n;return{x:()=>ji(s,r,t,i,a,o,l)}}};const Gi=Vs({equal_:function(t,e){let n=Ws(t,"a","equal","string_or_numeric"),s=Ws(e,"b","equal","string_or_numeric");[n,s]=Cs(n,s),ir(n.shape,s.shape);const r={a:n,b:s};return Ms.runKernel("Equal",r)}});function Hi(t,e,n,s){return e.rank<n.rank&&(e=ar(e,ii(e.shape,s))),t.rank<n.rank&&(t=ar(t,ii(t.shape,s))),{x:()=>js(t,Ks(Gi(n,e),t.dtype))}}const Ji={kernelName:"Max",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const s=n,{reductionIndices:r}=s,i=e[0],a=Hi(t,e[1],i,un(r,i.shape));return{x:()=>a.x()}}};const Zi=Vs({less_:function(t,e){let n=Ws(t,"a","less","string_or_numeric"),s=Ws(e,"b","less","string_or_numeric");[n,s]=Cs(n,s),ir(n.shape,s.shape);const r={a:n,b:s};return Ms.runKernel("Less",r)}}),Yi={kernelName:"Maximum",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>js(t,Ks(Lr(n,s),"float32")),b:()=>js(t,Ks(Zi(n,s),"float32"))}}};const Xi=Vs({maxPool3dGrad_:function(t,e,n,s,r,i,a){const o=Ws(t,"dy","maxPool3dGrad"),l=Ws(e,"input","maxPool3dGrad"),u=Ws(n,"output","maxPool3dGrad");let h=o,c=l,p=u,d=!1;4===l.rank&&(d=!0,h=ar(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]]),c=ar(l,[1,l.shape[0],l.shape[1],l.shape[2],l.shape[3]]),p=ar(u,[1,u.shape[0],u.shape[1],u.shape[2],u.shape[3]])),tn(5===h.rank,(()=>`Error in maxPool3dGrad: dy must be rank 5 but got rank ${h.rank}.`)),tn(5===c.rank,(()=>`Error in maxPool3dGrad: input must be rank 5 but got rank ${c.rank}.`)),tn(5===p.rank,(()=>`Error in maxPool3dGrad: output must be rank 5 but got rank ${p.rank}.`)),Er("maxPool3dGrad",i,a);const f={dy:h,input:c,output:p},g={filterSize:s,strides:r,pad:i,dimRoundingMode:a},m=Ms.runKernel("MaxPool3DGrad",f,g);return d?ar(m,[m.shape[1],m.shape[2],m.shape[3],m.shape[4]]):m}}),Qi={kernelName:"MaxPool3D",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{filterSize:i,strides:a,pad:o,dimRoundingMode:l}=n;return{x:()=>Xi(t,s,r,i,a,o,l)}}};const ta=Vs({maxPoolGrad_:function(t,e,n,s,r,i,a){const o=Ws(t,"dy","maxPoolGrad"),l=Ws(e,"input","maxPoolGrad"),u=Ws(n,"output","maxPoolGrad");tn(l.rank===o.rank,(()=>`Rank of input (${l.rank}) does not match rank of dy (${o.rank})`)),tn(4===o.rank,(()=>`Error in maxPoolGrad: dy must be rank 4 but got rank ${o.rank}.`)),tn(4===l.rank,(()=>`Error in maxPoolGrad: input must be rank 4 but got rank ${l.rank}.`)),Er("maxPoolGrad",i,a);const h={dy:o,input:l,output:u},c={filterSize:s,strides:r,pad:i,dimRoundingMode:a};return Ms.runKernel("MaxPoolGrad",h,c)}}),ea={kernelName:"MaxPool",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{filterSize:i,strides:a,pad:o}=n;return{x:()=>ta(t,s,r,i,a,o)}}};function na(t,e="float32"){if("complex64"===e){const e=na(t,"float32"),n=na(t,"float32");return ci(e,n)}const n=wn(rn(t),e);return Ms.makeTensor(n,t,e)}function sa(t,e="float32"){if("complex64"===e){const e=sa(t,"float32"),n=na(t,"float32");return ci(e,n)}const n=yn(rn(t),e);return Ms.makeTensor(n,t,e)}const ra={kernelName:"Mean",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n,i=un(r,s.shape),a=function(t,e){const n=[],s=t.length;for(let r=0;r<s;r++)-1===e.indexOf(r)&&n.push(t[r]);return[n,e.map((e=>t[e]))]}(s.shape,i),o=rn(a[1]);return{x:()=>{const e=s.shape.slice();i.forEach((t=>{e[t]=1}));const n=ar(t,e);return Js(js(n,sa(s.shape,"float32")),o)}}}},ia={kernelName:"Min",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const s=n,{axis:r}=s,[i,a]=e,o=Hi(t,a,i,un(r,i.shape));return{x:()=>o.x()}}},aa={kernelName:"Minimum",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>js(t,Ks(Or(n,s),"float32")),b:()=>js(t,Ks(Pi(n,s),"float32"))}}};const oa=Vs({slice_:function(t,e,n){const s=Ws(t,"x","slice","string_or_numeric");if(0===s.rank)throw new Error("Slicing scalar is not possible");const r={x:s},i={begin:e,size:n};return Ms.runKernel("Slice",r,i)}}),la={kernelName:"MirrorPad",inputsToSave:["x"],gradFunc:(t,e,n)=>{const s=e[0],{paddings:r}=n,i=r.map((t=>t[0]));return{x:()=>oa(t,i,s.shape)}}};const ua=Vs({floor_:function(t){const e={x:Ws(t,"x","floor","float32")};return Ms.runKernel("Floor",e)}}),ha={kernelName:"Mod",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=ir(n.shape,s.shape);return{a:()=>{const e=rr(n.shape,r);return e.length>0?ar(or(t,e),n.shape):t},b:()=>{const e=js(t,Zs(ua(Js(n,s)))),i=rr(s.shape,r);return i.length>0?ar(or(e,i),s.shape):e}}}},ca={kernelName:"Multiply",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=ir(n.shape,s.shape);return{a:()=>{const e=js(t,Ks(s,"float32")),i=rr(n.shape,r);return i.length>0?ar(or(e,i),n.shape):e},b:()=>{const e=js(t,Ks(n,"float32")),i=rr(s.shape,r);return i.length>0?ar(or(e,i),s.shape):e}}}},pa={kernelName:"Neg",gradFunc:t=>({x:()=>Zs(t)})},da={kernelName:"OneHot",inputsToSave:["indices"],gradFunc:(t,e)=>{const n=e[0];return{indices:()=>na(n.shape,"float32")}}},fa={kernelName:"OnesLike",gradFunc:t=>({x:()=>hr(t)})};const ga=Vs({unstack_:function(t,e=0){const n=Ws(t,"x","unstack","string_or_numeric");tn(e>=-n.shape.length&&e<n.shape.length,(()=>`Axis = ${e} is not in [-${n.shape.length}, ${n.shape.length})`));const s={value:n},r={axis:e};return Ms.runKernel("Unpack",s,r)}}),ma={kernelName:"Pack",saveAllInputs:!0,gradFunc:(t,e,n)=>{const{axis:s}=n;return ga(t,s).map((t=>()=>t))}},ba={kernelName:"PadV2",inputsToSave:["x"],gradFunc:(t,e,n)=>{const s=e[0],{paddings:r}=n,i=r.map((t=>t[0]));return{x:()=>oa(t,i,s.shape)}}};const ya=Vs({log_:function(t){const e={x:Ws(t,"x","log","float32")};return Ms.runKernel("Log",e)}});const wa=Vs({pow_:function(t,e){let n=Ws(t,"base","pow"),s=Ws(e,"exp","pow");[n,s]=Cs(n,s);const r={a:n,b:s};return Ms.runKernel("Pow",r)}}),ka={kernelName:"Pow",inputsToSave:["a","b"],outputsToSave:[!0],gradFunc:(t,e)=>{const[n,s,r]=e,i=n,a=s,o=ir(i.shape,a.shape);return{a:()=>{const e=Ks(a,"float32");let n=js(t,js(e,wa(i,er(e,Xs(1)))));const s=rr(i.shape,o);return s.length>0&&(n=or(n,s)),ar(n,i.shape)},b:()=>{const e=Pi(i,0),n=Ur(e,ya(i),hr(i));let s=js(t,js(r,n));const l=rr(a.shape,o);return l.length>0&&(s=or(s,l)),ar(s,a.shape)}}}},va={kernelName:"Prelu",inputsToSave:["x","alpha"],gradFunc:(t,e)=>{const[n,s]=e,r=Pi(n,0);return{x:()=>Ur(r,t,js(t,s)),alpha:()=>{let e=Ur(r,hr(t),js(t,n));const i=rr(s.shape,t.shape);return i.length>0&&(e=or(e,i)),ar(e,s.shape)}}}};const xa=Nn();xa.registerFlag("DEBUG",(()=>!1),(t=>{t&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")})),xa.registerFlag("IS_BROWSER",(()=>"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope)),xa.registerFlag("IS_NODE",(()=>"undefined"!=typeof process&&"undefined"!=typeof process.versions&&"undefined"!=typeof process.versions.node)),xa.registerFlag("IS_CHROME",(()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor))),xa.registerFlag("PROD",(()=>!1)),xa.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",(()=>xa.getBool("DEBUG"))),xa.registerFlag("DEPRECATION_WARNINGS_ENABLED",(()=>!0)),xa.registerFlag("IS_TEST",(()=>!1)),xa.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",(()=>!0)),xa.registerFlag("WRAP_TO_IMAGEBITMAP",(()=>!1)),xa.registerFlag("ENGINE_COMPILE_ONLY",(()=>!1)),xa.registerFlag("CANVAS2D_WILL_READ_FREQUENTLY_FOR_GPU",(()=>!1)),xa.registerFlag("USE_SETTIMEOUTCUSTOM",(()=>!1));const Sa="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function Na(t){return Sa?Buffer.byteLength(t):new Blob([t]).size}function Ea(t){if(1===t.length)return t[0];let e=0;t.forEach((t=>{e+=t.byteLength}));const n=new Uint8Array(e);let s=0;return t.forEach((t=>{n.set(new Uint8Array(t),s),s+=t.byteLength})),n.buffer}function Ia(t,e){const n={modelTopology:t.modelTopology,format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy,weightsManifest:e};return null!=t.signature&&(n.signature=t.signature),null!=t.userDefinedMetadata&&(n.userDefinedMetadata=t.userDefinedMetadata),null!=t.modelInitializer&&(n.modelInitializer=t.modelInitializer),null!=t.initializerSignature&&(n.initializerSignature=t.initializerSignature),null!=t.trainingConfig&&(n.trainingConfig=t.trainingConfig),n}async function Aa(t,e){let n,s;return null!=t.weightsManifest&&([n,s]=await e(t.weightsManifest)),function(t,e,n){const s={modelTopology:t.modelTopology,format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy};if(null!=t.trainingConfig&&(s.trainingConfig=t.trainingConfig),null!=t.weightsManifest){if(!e)throw new Error("modelJSON has weightsManifest but weightSpecs is null");if(!n)throw new Error("modelJSON has weightsManifest but weightData is null");s.weightSpecs=e,s.weightData=n}return null!=t.signature&&(s.signature=t.signature),null!=t.userDefinedMetadata&&(s.userDefinedMetadata=t.userDefinedMetadata),null!=t.modelInitializer&&(s.modelInitializer=t.modelInitializer),null!=t.initializerSignature&&(s.initializerSignature=t.initializerSignature),s}(t,n,s)}function Ta(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==t.modelTopology?0:Na(JSON.stringify(t.modelTopology)),weightSpecsBytes:null==t.weightSpecs?0:Na(JSON.stringify(t.weightSpecs)),weightDataBytes:null==t.weightData?0:t.weightData.byteLength}}class $a{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==$a.instance&&($a.instance=new $a),$a.instance}static registerSaveRouter(t){$a.getInstance().saveRouters.push(t)}static registerLoadRouter(t){$a.getInstance().loadRouters.push(t)}static getSaveHandlers(t){return $a.getHandlers(t,"save")}static getLoadHandlers(t,e){return $a.getHandlers(t,"load",e)}static getHandlers(t,e,n){const s=[];return("load"===e?$a.getInstance().loadRouters:$a.getInstance().saveRouters).forEach((e=>{const r=e(t,n);null!==r&&s.push(r)})),s}}class Ca{constructor(t){if(this.indexedDB=function(){if(!Nn().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const t="undefined"==typeof window?self:window,e=t.indexedDB||t.mozIndexedDB||t.webkitIndexedDB||t.msIndexedDB||t.shimIndexedDB;if(null==e)throw new Error("The current browser does not appear to support IndexedDB.");return e}(),null==t||!t)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=t}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,t)}async load(){return this.databaseAction(this.modelPath)}databaseAction(t,e){return new Promise(((t,n)=>{const s=this.indexedDB.open("tensorflowjs",1);s.onupgradeneeded=()=>function(t){const e=t.result;e.createObjectStore("models_store",{keyPath:"modelPath"}),e.createObjectStore("model_info_store",{keyPath:"modelPath"})}(s),s.onsuccess=()=>{const r=s.result;if(null==e){const e=r.transaction("models_store","readonly"),s=e.objectStore("models_store").get(this.modelPath);s.onsuccess=()=>{if(null==s.result)return r.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));t(s.result.modelArtifacts)},s.onerror=t=>(r.close(),n(s.error)),e.oncomplete=()=>r.close()}else{const s=Ta(e),i=r.transaction("model_info_store","readwrite");let a=i.objectStore("model_info_store");const o=a.put({modelPath:this.modelPath,modelArtifactsInfo:s});let l;o.onsuccess=()=>{l=r.transaction("models_store","readwrite");const o=l.objectStore("models_store").put({modelPath:this.modelPath,modelArtifacts:e,modelArtifactsInfo:s});o.onsuccess=()=>t({modelArtifactsInfo:s}),o.onerror=t=>{a=i.objectStore("model_info_store");const e=a.delete(this.modelPath);e.onsuccess=()=>(r.close(),n(o.error)),e.onerror=t=>(r.close(),n(o.error))}},o.onerror=t=>(r.close(),n(o.error)),i.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}}},s.onerror=t=>n(s.error)}))}}Ca.URL_SCHEME="indexeddb://";const za=t=>{return Nn().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(Ca.URL_SCHEME)?(e=t.slice(Ca.URL_SCHEME.length),new Ca(e)):null;var e};$a.registerSaveRouter(za),$a.registerLoadRouter(za);const _a="tensorflowjs_models",Da="info",Fa="model_topology",Ra="weight_specs",Ma="weight_data",La="model_metadata";class Oa{constructor(t){if(!Nn().getBool("IS_BROWSER")||"undefined"==typeof window||"undefined"==typeof window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==t||!t)throw new Error("For local storage, modelPath must not be null, undefined or empty.");var e;this.modelPath=t,this.keys=(e=this.modelPath,{info:[_a,e,Da].join("/"),topology:[_a,e,Fa].join("/"),weightSpecs:[_a,e,Ra].join("/"),weightData:[_a,e,Ma].join("/"),modelMetadata:[_a,e,La].join("/")})}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const e=JSON.stringify(t.modelTopology),n=JSON.stringify(t.weightSpecs),s=Ta(t);try{this.LS.setItem(this.keys.info,JSON.stringify(s)),this.LS.setItem(this.keys.topology,e),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(t){if(Sa)return Buffer.from(t).toString("base64");const e=new Uint8Array(t);let n="";for(let t=0,s=e.length;t<s;t++)n+=String.fromCharCode(e[t]);return btoa(n)}(t.weightData));const r={format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy,signature:null!=t.signature?t.signature:void 0,userDefinedMetadata:null!=t.userDefinedMetadata?t.userDefinedMetadata:void 0,modelInitializer:null!=t.modelInitializer?t.modelInitializer:void 0,initializerSignature:null!=t.initializerSignature?t.initializerSignature:void 0,trainingConfig:null!=t.trainingConfig?t.trainingConfig:void 0};return this.LS.setItem(this.keys.modelMetadata,JSON.stringify(r)),{modelArtifactsInfo:s}}catch(t){throw function(t){for(const e of Object.values(t))window.localStorage.removeItem(e)}(this.keys),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${s.modelTopologyBytes}, weightSpecsBytes=${s.weightSpecsBytes}, weightDataBytes=${s.weightDataBytes}.`)}}}async load(){const t=JSON.parse(this.LS.getItem(this.keys.info));if(null==t)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==t.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const e={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);e.modelTopology=n;const s=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==s)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);e.weightSpecs=s;const r=this.LS.getItem(this.keys.modelMetadata);if(null!=r){const t=JSON.parse(r);e.format=t.format,e.generatedBy=t.generatedBy,e.convertedBy=t.convertedBy,null!=t.signature&&(e.signature=t.signature),null!=t.userDefinedMetadata&&(e.userDefinedMetadata=t.userDefinedMetadata),null!=t.modelInitializer&&(e.modelInitializer=t.modelInitializer),null!=t.initializerSignature&&(e.initializerSignature=t.initializerSignature),null!=t.trainingConfig&&(e.trainingConfig=t.trainingConfig)}const i=this.LS.getItem(this.keys.weightData);if(null==i)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return e.weightData=function(t){if(Sa){const e=Buffer.from(t,"base64");return e.buffer.slice(e.byteOffset,e.byteOffset+e.byteLength)}const e=atob(t),n=new Uint8Array(e.length);for(let t=0;t<e.length;++t)n.set([e.charCodeAt(t)],t);return n.buffer}(i),e}}Oa.URL_SCHEME="localstorage://";const Ba=t=>{return Nn().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(Oa.URL_SCHEME)?(e=t.slice(Oa.URL_SCHEME.length),new Oa(e)):null;var e};$a.registerSaveRouter(Ba),$a.registerLoadRouter(Ba);function Pa(t){return new Promise((t=>setTimeout(t))).then(t)}class Wa{constructor(t){if(!Nn().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");t.startsWith(Wa.URL_SCHEME)&&(t=t.slice(Wa.URL_SCHEME.length)),null!=t&&0!==t.length||(t="model"),this.modelJsonFileName=t+".json",this.weightDataFileName=t+".weights.bin"}async save(t){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const e=window.URL.createObjectURL(new Blob([t.weightData],{type:"application/octet-stream"}));if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=Ia(t,[{paths:["./"+this.weightDataFileName],weights:t.weightSpecs}]),s=window.URL.createObjectURL(new Blob([JSON.stringify(n)],{type:"application/json"})),r=null==this.modelJsonAnchor?document.createElement("a"):this.modelJsonAnchor;if(r.download=this.modelJsonFileName,r.href=s,await Pa((()=>r.dispatchEvent(new MouseEvent("click")))),null!=t.weightData){const t=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;t.download=this.weightDataFileName,t.href=e,await Pa((()=>t.dispatchEvent(new MouseEvent("click"))))}return{modelArtifactsInfo:Ta(t)}}}}Wa.URL_SCHEME="downloads://";function Ua(t,e,n,s){!function(t){tn(null!=t&&Array.isArray(t)&&t.length>0,(()=>"promises must be a none empty array"))}(t),function(t,e){tn(t>=0&&t<=1,(()=>`Progress fraction must be in range [0, 1], but got startFraction ${t}`)),tn(e>=0&&e<=1,(()=>`Progress fraction must be in range [0, 1], but got endFraction ${e}`)),tn(e>=t,(()=>`startFraction must be no more than endFraction, but got startFraction ${t} and endFraction ${e}`))}(n=null==n?0:n,s=null==s?1:s);let r=0;return Promise.all(t.map((i=>(i.then((i=>{const a=n+ ++r/t.length*(s-n);return e(a),i})),i))))}$a.registerSaveRouter((t=>Nn().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(Wa.URL_SCHEME)?function(t="model"){return new Wa(t)}(t.slice(Wa.URL_SCHEME.length)):null));class Va{constructor(t,e){if(this.DEFAULT_METHOD="POST",null==e&&(e={}),this.weightPathPrefix=e.weightPathPrefix,this.onProgress=e.onProgress,this.weightUrlConverter=e.weightUrlConverter,null!=e.fetchFunc?(tn("function"==typeof e.fetchFunc,(()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)")),this.fetch=e.fetchFunc):this.fetch=Nn().platform.fetch,tn(null!=t&&t.length>0,(()=>"URL path for http must not be null, undefined or empty.")),Array.isArray(t)&&tn(2===t.length,(()=>`URL paths for http must have a length of 2, (actual length is ${t.length}).`)),this.path=t,null!=e.requestInit&&null!=e.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=e.requestInit||{}}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const e=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);e.body=new FormData;const n=Ia(t,[{paths:["./model.weights.bin"],weights:t.weightSpecs}]);e.body.append("model.json",new Blob([JSON.stringify(n)],{type:"application/json"}),"model.json"),null!=t.weightData&&e.body.append("model.weights.bin",new Blob([t.weightData],{type:"application/octet-stream"}),"model.weights.bin");const s=await this.fetch(this.path,e);if(s.ok)return{modelArtifactsInfo:Ta(t),responses:[s]};throw new Error(`BrowserHTTPRequest.save() failed due to HTTP response status ${s.status}.`)}async load(){const t=await this.fetch(this.path,this.requestInit);if(!t.ok)throw new Error(`Request to ${this.path} failed with status code ${t.status}. Please verify this URL points to the model JSON of the model to load.`);let e;try{e=await t.json()}catch(t){let e=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?e+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":e+=" Please make sure the server is serving valid JSON for this request.",new Error(e)}const n=e.modelTopology,s=e.weightsManifest;if(null==n&&null==s)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);return Aa(e,(t=>this.loadWeights(t)))}async loadWeights(t){const e=Array.isArray(this.path)?this.path[1]:this.path,[n,s]=function(t){const e=t.lastIndexOf("/"),n=t.lastIndexOf("?"),s=t.substring(0,e),r=n>e?t.substring(n):"";return[s+"/",r]}(e),r=this.weightPathPrefix||n,i=function(t){const e=[];for(const n of t)e.push(...n.weights);return e}(t),a=[],o=[];for(const e of t)for(const t of e.paths)null!=this.weightUrlConverter?o.push(this.weightUrlConverter(t)):a.push(r+t+s);this.weightUrlConverter&&a.push(...await Promise.all(o));const l=await async function(t,e){null==e&&(e={});const n=null==e.fetchFunc?Nn().platform.fetch:e.fetchFunc,s=t.map((t=>n(t,e.requestInit,{isBinary:!0}))),r=(null==e.onProgress?await Promise.all(s):await Ua(s,e.onProgress,0,.5)).map((t=>t.arrayBuffer()));return null==e.onProgress?await Promise.all(r):await Ua(r,e.onProgress,.5,1)}(a,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress});return[i,Ea(l)]}}function Ka(t){return null!=t.match(Va.URL_SCHEME_REGEX)}Va.URL_SCHEME_REGEX=/^https?:\/\//;const ja=(t,e)=>{if("undefined"==typeof fetch&&(null==e||null==e.fetchFunc))return null;{let n=!0;if(n=Array.isArray(t)?t.every((t=>Ka(t))):Ka(t),n)return function(t,e){return new Va(t,e)}(t,e)}return null};$a.registerSaveRouter(ja),$a.registerLoadRouter(ja);const qa=Vs({oneHot_:function(t,e,n=1,s=0,r="int32"){if(e<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${e}`);const i={indices:Ws(t,"indices","oneHot","int32")},a={dtype:r,depth:e,onValue:n,offValue:s};return Ms.runKernel("OneHot",i,a)}});let Ga;function Ha(t,e,n){if(e.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${e.rank}.`);if(t.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${t.rank}.`);if("int32"!==e.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${e.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===e.size)throw new Error(`Indices specified for empty output. indices shape: ${e.shape}`);if(0===t.size)throw new Error(`Updates specified for empty output. updates shape: ${t.shape}`)}!function(t,e,n){const s=e.rank>1?e.shape[e.rank-1]:1,r=e.rank>1?e.rank-1:1,i=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${e.shape}, shape: ${t}, sliceDim: ${s}, and batchDim: ${r}.`;if(n.rank<r)throw new Error(i+` update.rank < ${r}. `);if(t.length<s+(n.rank-r))throw new Error(i+` Output shape length < ${s+(n.rank-r)}`);if(n.rank!==r+t.length-s)throw new Error(i+" update.rank != "+(r+t.length-s));for(let t=0;t<r;++t)if(n.shape[t]!==e.shape[t])throw new Error(i+` updates.shape[${t}] (${n.shape[t]}) != indices.shape[${t}] (${e.shape[t]}).`);for(let e=0;e<n.rank-r;++e)if(n.shape[e+r]!==t[e+s])throw new Error(i+` updates.shape[${e+r}] (${n.shape[e+r]}) != shape[${e+r}] (${t[e+r]})`)}(n,e,t)}Vs({confusionMatrix_:function(t,e,n){const s=Ws(t,"labels","confusionMatrix"),r=Ws(e,"predictions","confusionMatrix");tn(null==n||n>0&&Number.isInteger(n),(()=>`If provided, numClasses must be a positive integer, but got ${n}`)),tn(1===s.rank,(()=>`Expected the rank of labels to be 1, but got ${s.rank}`)),tn(1===r.rank,(()=>`Expected the rank of predictions to be 1, but got ${r.rank}`)),tn(s.shape[0]===r.shape[0],(()=>`Mismatch in the number of examples: ${s.shape[0]} vs. ${r.shape[0]}. Labels and predictions should have the same number of elements.`)),tn(n>0&&Number.isInteger(n),(()=>`numClasses is required to be a positive integer, but got ${n}`));const i=qa(Ks(s,"int32"),n),a=qa(Ks(r,"int32"),n),o=fi(i),l=Cr(o,a);return Ks(l,"int32")}}),Vs({fromPixels_:function(t,e=3){if(e>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==t)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,s=!1,r=!1,i=!1,a=!1,o=!1;if(t.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&t instanceof ImageData)s=!0;else if("undefined"!=typeof HTMLVideoElement&&t instanceof HTMLVideoElement)r=!0;else if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement)i=!0;else if(null!=t.getContext)a=!0;else{if(!("undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap))throw new Error(`pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was ${t.constructor.name}`);o=!0}if(null!=_n("FromPixels",Ms.backendName)){const n={pixels:t},s={numChannels:e};return Ms.runKernel("FromPixels",n,s)}const[l,u]=r?[t.videoWidth,t.videoHeight]:[t.width,t.height];let h,c;if(a)h=t.getContext("2d").getImageData(0,0,l,u).data;else if(s||n)h=t.data;else if(i||r||o){if(null==Ga)if("undefined"==typeof document){if("undefined"==typeof OffscreenCanvas||"undefined"==typeof OffscreenCanvasRenderingContext2D)throw new Error("Cannot parse input in current context. Reason: OffscreenCanvas Context2D rendering is not supported.");Ga=new OffscreenCanvas(1,1).getContext("2d")}else Ga=document.createElement("canvas").getContext("2d",{willReadFrequently:!0});Ga.canvas.width=l,Ga.canvas.height=u,Ga.drawImage(t,0,0,l,u),h=Ga.getImageData(0,0,l,u).data}if(4===e)c=new Int32Array(h);else{const t=l*u;c=new Int32Array(t*e);for(let n=0;n<t;n++)for(let t=0;t<e;++t)c[n*e+t]=h[4*n+t]}return function(t,e,n){if(nn(t),null!=e&&3!==e.length)throw new Error("tensor3d() requires shape to have three numbers");const s=Os(t,n);if(3!==s.length&&1!==s.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return Ys(t,e,s,n)}(c,[u,l,e],"int32")}});class Ja{constructor(){this.classNameMap={}}static getMap(){return null==Ja.instance&&(Ja.instance=new Ja),Ja.instance}static register(t){Ja.getMap().classNameMap[t.className]=[t,t.fromConfig]}}function Za(t){tn(null!=t.className,(()=>"Class being registered does not have the static className property defined.")),tn("string"==typeof t.className,(()=>"className is required to be a string, but got type "+typeof t.className)),tn(t.className.length>0,(()=>"Class being registered has an empty-string as its className, which is disallowed.")),Ja.register(t)}const Ya=Vs({abs_:function(t){const e=Ws(t,"x","abs");if("complex64"===e.dtype){const t={x:e};return Ms.runKernel("ComplexAbs",t)}{const t={x:e};return Ms.runKernel("Abs",t)}}});Vs({acos_:function(t){const e={x:Ws(t,"x","acos")};return Ms.runKernel("Acos",e)}}),Vs({acosh_:function(t){const e={x:Ws(t,"x","acosh")};return Ms.runKernel("Acosh",e)}}),Vs({addN_:function(t){tn(Array.isArray(t),(()=>"The argument passed to tf.addN() must be a list of tensors")),tn(t.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${t.length}`));const e=t.map(((t,e)=>Ws(t,`tensors${e}`,"addN"))),n=e[0];e.forEach((t=>{if(t.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),e.forEach((t=>{if(!an(t.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const s=e;return Ms.runKernel("AddN",s)}}),Vs({all_:function(t,e=null,n=!1){const s={x:Ws(t,"x","all","bool")},r={axis:e,keepDims:n};return Ms.runKernel("All",s,r)}}),Vs({any_:function(t,e=null,n=!1){const s={x:Ws(t,"x","any","bool")},r={axis:e,keepDims:n};return Ms.runKernel("Any",s,r)}}),Vs({argMax_:function(t,e=0){const n={x:Ws(t,"x","argMax")},s={axis:e};return Ms.runKernel("ArgMax",n,s)}}),Vs({argMin_:function(t,e=0){const n={x:Ws(t,"x","argMin")},s={axis:e};return Ms.runKernel("ArgMin",n,s)}}),Vs({asin_:function(t){const e={x:Ws(t,"x","asin")};return Ms.runKernel("Asin",e)}}),Vs({asinh_:function(t){const e={x:Ws(t,"x","asinh")};return Ms.runKernel("Asinh",e)}}),Vs({atan_:function(t){const e={x:Ws(t,"x","atan")};return Ms.runKernel("Atan",e)}}),Vs({atan2_:function(t,e){let n=Ws(t,"a","atan2"),s=Ws(e,"b","atan2");[n,s]=Cs(n,s);const r={a:n,b:s};return Ms.runKernel("Atan2",r)}}),Vs({atanh_:function(t){const e={x:Ws(t,"x","atanh")};return Ms.runKernel("Atanh",e)}});const Xa=Vs({avgPool_:function(t,e,n,s,r){const i=Ws(t,"x","avgPool","float32");tn(Nr(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let a=i,o=!1;3===i.rank&&(o=!0,a=ar(i,[1,i.shape[0],i.shape[1],i.shape[2]])),tn(4===a.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${a.rank}.`)),Er("avgPool",s,r);const l={x:a},u={filterSize:e,strides:n,pad:s,dimRoundingMode:r};let h=Ms.runKernel("AvgPool",l,u);return h=Ks(h,i.dtype),o?ar(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});Vs({avgPool3d_:function(t,e,n,s,r,i="NDHWC"){const a=Ws(t,"x","avgPool3d","float32");let o=a,l=!1;4===a.rank&&(l=!0,o=ar(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),tn(5===o.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${o.rank}.`)),tn("NDHWC"===i,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${i}`)),Er("avgPool3d",s,r);const u={x:o},h={filterSize:e,strides:n,pad:s,dimRoundingMode:r,dataFormat:i};let c=Ms.runKernel("AvgPool3D",u,h);return c=Ks(c,o.dtype),l?ar(c,[c.shape[1],c.shape[2],c.shape[3],c.shape[4]]):c}});const Qa=Vs({concat_:function(t,e=0){tn(t.length>=1,(()=>"Pass at least one tensor to concat"));const n=Us(t,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((t=>{if("complex64"!==t.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${t.dtype}. `)})),1===n.length)return Pr(n[0]);const s=n,r={axis:e};return Ms.runKernel("Concat",s,r)}});const to=Vs({sigmoid_:function(t){const e={x:Ws(t,"x","sigmoid","float32")};return Ms.runKernel("Sigmoid",e)}});const eo=Vs({tanh_:function(t){const e={x:Ws(t,"x","tanh","float32")};return Ms.runKernel("Tanh",e)}});Vs({basicLSTMCell_:function(t,e,n,s,r,i){const a=Ws(t,"forgetBias","basicLSTMCell"),o=Ws(e,"lstmKernel","basicLSTMCell"),l=Ws(n,"lstmBias","basicLSTMCell"),u=Ws(s,"data","basicLSTMCell"),h=Ws(r,"c","basicLSTMCell"),c=Ws(i,"h","basicLSTMCell"),p=Qa([u,c],1),d=Cr(p,o),f=fr(d,l),g=f.shape[0],m=f.shape[1]/4,b=[g,m],y=oa(f,[0,0],b),w=oa(f,[0,m],b),k=oa(f,[0,2*m],b),v=oa(f,[0,3*m],b),x=fr(js(to(y),eo(w)),js(h,to(fr(a,k))));return[x,js(eo(x),to(v))]}});const no=Vs({batchToSpaceND_:function(t,e,n){const s=Ws(t,"x","batchToSpaceND"),r=e.reduce(((t,e)=>t*e));tn(s.rank>=1+e.length,(()=>`input rank is ${s.rank} but should be > than blockShape.length ${e.length}`)),tn(n.length===e.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${e.length}`)),tn(s.shape[0]%r==0,(()=>`input tensor batch is ${s.shape[0]} but is not divisible by the product of the elements of blockShape ${e.join(" * ")} === ${r}`));const i={x:s},a={blockShape:e,crops:n};return Ms.runKernel("BatchToSpaceND",i,a)}});const so=Vs({batchNorm_:function(t,e,n,s,r,i){null==i&&(i=.001);const a=Ws(t,"x","batchNorm"),o=Ws(e,"mean","batchNorm"),l=Ws(n,"variance","batchNorm");let u,h;null!=r&&(u=Ws(r,"scale","batchNorm")),null!=s&&(h=Ws(s,"offset","batchNorm")),tn(o.rank===l.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),tn(null==h||o.rank===h.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),tn(null==u||o.rank===u.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const c=function(t){let e;return e=0===t.rank||1===t.rank?ar(t,[1,1,1,t.size]):2===t.rank?ar(t,[1,1,t.shape[0],t.shape[1]]):3===t.rank?ar(t,[1,t.shape[0],t.shape[1],t.shape[2]]):t,e}(a),p={x:c,scale:u,offset:h,mean:o,variance:l},d={varianceEpsilon:i},f=Ms.runKernel("FusedBatchNorm",p,d);return ar(f,a.shape)}});Vs({batchNorm2d_:function(t,e,n,s,r,i){const a=Ws(t,"x","batchNorm"),o=Ws(e,"mean","batchNorm"),l=Ws(n,"variance","batchNorm");let u,h;return null!=r&&(u=Ws(r,"scale","batchNorm")),null!=s&&(h=Ws(s,"offset","batchNorm")),tn(2===a.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${a.rank}.`)),tn(2===o.rank||1===o.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${o.rank}.`)),tn(2===l.rank||1===l.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${l.rank}.`)),null!=u&&tn(2===u.rank||1===u.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${u.rank}.`)),null!=h&&tn(2===h.rank||1===h.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`)),so(a,o,l,h,u,i)}}),Vs({batchNorm3d_:function(t,e,n,s,r,i){const a=Ws(t,"x","batchNorm"),o=Ws(e,"mean","batchNorm"),l=Ws(n,"variance","batchNorm");let u,h;return null!=r&&(u=Ws(r,"scale","batchNorm")),null!=s&&(h=Ws(s,"offset","batchNorm")),tn(3===a.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${a.rank}.`)),tn(3===o.rank||1===o.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${o.rank}.`)),tn(3===l.rank||1===l.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${l.rank}.`)),null!=u&&tn(3===u.rank||1===u.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${u.rank}.`)),null!=h&&tn(3===h.rank||1===h.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`)),so(a,o,l,h,u,i)}}),Vs({batchNorm4d_:function(t,e,n,s,r,i){const a=Ws(t,"x","batchNorm"),o=Ws(e,"mean","batchNorm"),l=Ws(n,"variance","batchNorm");let u,h;return null!=r&&(u=Ws(r,"scale","batchNorm")),null!=s&&(h=Ws(s,"offset","batchNorm")),tn(4===a.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${a.rank}.`)),tn(4===o.rank||1===o.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${o.rank}.`)),tn(4===l.rank||1===l.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${l.rank}.`)),null!=u&&tn(4===u.rank||1===u.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${u.rank}.`)),null!=h&&tn(4===h.rank||1===h.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`)),so(a,o,l,h,u,i)}});const ro=Vs({bincount_:function(t,e,n){const s=Ws(t,"x","bincount"),r=Ws(e,"weights","bincount");tn("int32"===s.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${s.dtype}`)),tn(n>=0,(()=>`size must be non-negative, but got ${n}.`)),tn(r.size===s.size||0===r.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${s.shape}, weights shape: ${r.shape}.`));const i={x:s,weights:r},a={size:n};return Ms.runKernel("Bincount",i,a)}});function io(t,e="float32",n){return e=e||"float32",kn(t),new ks(t,e,n)}function ao(t,e,n){const s={shape:t,value:e,dtype:n};return Ms.runKernel("Fill",{},s)}Vs({broadcastArgs_:function(t,e){const n=Ws(t,"s0","broadcastArgs","int32"),s=Ws(e,"s1","broadcastArgs","int32");if(1!==n.rank)throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);if(1!==s.rank)throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${s.rank}`);const r={s0:n,s1:s};return Ms.runKernel("BroadcastArgs",r)}}),Vs({ceil_:function(t){const e={x:Ws(t,"x","ceil","float32")};return Ms.runKernel("Ceil",e)}}),Vs({clipByValue_:function(t,e,n){const s=Ws(t,"x","clipByValue");if(tn(e<=n,(()=>`Error in clip: min (${e}) must be less than or equal to max (${n}).`)),e===n)return ao(s.shape,e,s.dtype);const r={x:s},i={clipValueMin:e,clipValueMax:n};return Ms.runKernel("ClipByValue",r,i)}}),Vs({concat1d_:function(t){return Qa(t,0)}}),Vs({concat2d_:function(t,e){return Qa(t,e)}}),Vs({concat3d_:function(t,e){return Qa(t,e)}}),Vs({concat4d_:function(t,e){return Qa(t,e)}}),Vs({conv1d_:function(t,e,n,s,r="NWC",i=1,a){const o=Ws(t,"x","conv1d"),l=Ws(e,"filter","conv1d");let u=o,h=!1;2===o.rank&&(h=!0,u=ar(o,[1,o.shape[0],o.shape[1]])),tn(3===u.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${u.rank}.`)),tn(3===l.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${l.rank}.`)),Er("conv1d",s,a),tn(u.shape[2]===l.shape[1],(()=>`Error in conv1d: depth of input (${u.shape[2]}) must match input depth for filter ${l.shape[1]}.`)),tn(Nr(n,i),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${i}'`)),tn("NWC"===r,(()=>`Error in conv1d: got dataFormat of ${r} but only NWC is currently supported.`));const c=ar(l,[1,l.shape[0],l.shape[1],l.shape[2]]),p=ar(u,[u.shape[0],1,u.shape[1],u.shape[2]]),d=Zr(p,c,[1,n],s,"NHWC",[1,i],a);return ar(d,h?[d.shape[2],d.shape[3]]:[d.shape[0],d.shape[2],d.shape[3]])}}),Vs({conv2dTranspose_:function(t,e,n,s,r,i){const a=Ws(t,"x","conv2dTranspose"),o=Ws(e,"filter","conv2dTranspose");return Hr(n,a,o,s,r,"NHWC",i)}}),Vs({conv3d_:function(t,e,n,s,r="NDHWC",i=[1,1,1]){const a=Ws(t,"x","conv3d"),o=Ws(e,"filter","conv3d");let l=a,u=!1;4===a.rank&&(u=!0,l=ar(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),tn(5===l.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${l.rank}.`)),tn(5===o.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${o.rank}.`)),tn(l.shape[4]===o.shape[3],(()=>`Error in conv3d: depth of input (${l.shape[4]}) must match input depth for filter ${o.shape[3]}.`)),tn(Nr(n,i),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`)),tn("NDHWC"===r,(()=>`Error in conv3d: got dataFormat of ${r} but only NDHWC is currently supported.`));const h={x:l,filter:o},c={strides:n,pad:s,dataFormat:r,dilations:i},p=Ms.runKernel("Conv3D",h,c);return u?ar(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}}),Vs({conv3dTranspose_:function(t,e,n,s,r){const i=Ws(t,"x","conv3dTranspose"),a=Ws(e,"filter","conv3dTranspose");return Qr(n,i,a,s,r)}});const oo=Vs({cos_:function(t){const e={x:Ws(t,"x","cos","float32")};return Ms.runKernel("Cos",e)}});const lo=Vs({cosh_:function(t){const e={x:Ws(t,"x","cosh","float32")};return Ms.runKernel("Cosh",e)}});const uo=Vs({cumprod_:function(t,e=0,n=!1,s=!1){const r={x:Ws(t,"x","cumprod")},i={axis:e,exclusive:n,reverse:s};return Ms.runKernel("Cumprod",r,i)}});Vs({denseBincount_:function(t,e,n,s=!1){const r=Ws(t,"x","denseBincount"),i=Ws(e,"weights","denseBincount");tn("int32"===r.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${r.dtype}`)),tn(r.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${r.rank}.`)),tn(n>=0,(()=>`size must be non-negative, but got ${n}.`)),tn(i.size===r.size||0===i.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${r.shape}, weights shape: ${i.shape}.`));const a={x:r,weights:i},o={size:n,binaryOutput:s};return Ms.runKernel("DenseBincount",a,o)}}),Vs({depthToSpace_:function(t,e,n="NHWC"){const s=Ws(t,"x","depthToSpace","float32"),r="NHWC"===n?s.shape[1]:s.shape[2],i="NHWC"===n?s.shape[2]:s.shape[3],a="NHWC"===n?s.shape[3]:s.shape[1];tn(e>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${e}`)),tn(r*e>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${r} and ${e}  for depthToSpace with input shape\n    ${s.shape}`)),tn(i*e>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${i} and ${e} for depthToSpace with input shape\n        ${s.shape}`)),tn(a%(e*e)==0,(()=>`Dimension size must be evenly divisible by ${e*e} but is ${a} for depthToSpace with input shape ${s.shape}`));const o={x:s},l={blockSize:e,dataFormat:n};return Ms.runKernel("DepthToSpace",o,l)}});const ho=Vs({depthwiseConv2d_:function(t,e,n,s,r="NHWC",i=[1,1],a){const o=Ws(t,"x","depthwiseConv2d","float32"),l=Ws(e,"filter","depthwiseConv2d","float32");let u=o,h=!1;3===o.rank&&(h=!0,u=ar(o,[1,o.shape[0],o.shape[1],o.shape[2]])),tn(4===u.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${u.rank}.`)),tn(4===l.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${l.rank}.`));const c="NHWC"===r?u.shape[3]:u.shape[1];tn(c===l.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${c}) must match the inChannels dimension in filter ${l.shape[2]}.`)),Er("depthwiseConv2d",s,a);const p={x:u,filter:l},d={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a},f=Ms.runKernel("DepthwiseConv2dNative",p,d);return h?ar(f,[f.shape[1],f.shape[2],f.shape[3]]):f}});Vs({diag_:function(t){const e={x:Ws(t,"x","diag")};return Ms.runKernel("Diag",e)}}),Vs({dilation2d_:function(t,e,n,s,r=[1,1],i="NHWC"){const a=Ws(t,"x","dilation2d"),o=Ws(e,"filter","dilation2d");tn(3===a.rank||4===a.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${a.rank}.`)),tn(3===o.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${o.rank}.`)),tn("NHWC"===i,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${i}`));let l=a,u=!1;3===a.rank&&(l=ar(a,[1,a.shape[0],a.shape[1],a.shape[2]]),u=!0);const h={x:l,filter:o},c={strides:n,pad:s,dilations:r},p=Ms.runKernel("Dilation2D",h,c);return u?ar(p,[p.shape[1],p.shape[2],p.shape[3]]):p}}),Vs({divNoNan_:function(t,e){let n=Ws(t,"a","div"),s=Ws(e,"b","div");[n,s]=Cs(n,s);const r=Js(n,s),i=hr(r),a=Gi(s,i);return Ur(a,i,r)}}),Vs({dot_:function(t,e){const n=Ws(t,"t1","dot"),s=Ws(e,"t2","dot");tn(!(1!==n.rank&&2!==n.rank||1!==s.rank&&2!==s.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${s.rank}.`));const r=1===n.rank?n.size:n.shape[1],i=1===s.rank?s.size:s.shape[0];if(tn(r===i,(()=>`Error in dot: inner dimensions of inputs must match, but got ${r} and ${i}.`)),1===n.rank&&1===s.rank){const t=ar(n,[1,-1]),e=ar(s,[-1,1]),r=Cr(t,e);return ar(r,[])}if(1===n.rank&&2===s.rank){const t=ar(n,[1,-1]),e=ar(s,[s.shape[0],s.shape[1]]),r=Cr(t,e);return ar(r,[r.size])}if(2===n.rank&&1===s.rank){const t=ar(s,[-1,1]),e=Cr(n,t);return ar(e,[e.size])}{const t=ar(s,[s.shape[0],s.shape[1]]);return Cr(n,t)}}}),Vs({einsum_:function(t,...e){const n=e.map(((t,e)=>Ws(t,`tensors${e}`,"einsum"))),s={equation:t};return Ms.runKernel("Einsum",n,s)}});const co=Vs({elu_:function(t){const e={x:Ws(t,"x","elu","float32")};return Ms.runKernel("Elu",e)}});Vs({erf_:function(t){let e=Ws(t,"x","erf");tn("int32"===e.dtype||"float32"===e.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===e.dtype&&(e=Ks(e,"float32"));const n={x:e};return Ms.runKernel("Erf",n)}});const po=Vs({max_:function(t,e=null,n=!1){const s={x:Ws(t,"x","max")},r={reductionIndices:e,keepDims:n};return Ms.runKernel("Max",s,r)}});const fo=Vs({min_:function(t,e=null,n=!1){const s={x:Ws(t,"x","min")},r={axis:e,keepDims:n};return Ms.runKernel("Min",s,r)}});function go(t,e,n=null){if(0===t.rank)return Ya(t);if(1!==t.rank&&null===n)return go(ar(t,[-1]),e,n);if(1===t.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===e)return or(Ya(t),n);if(e===1/0)return po(Ya(t),n);if(e===-1/0)return fo(Ya(t),n);if("euclidean"===e||2===e)return Qs(or(wa(Ya(t),Xs(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${e}`)}if(Array.isArray(n)&&2===n.length){if(1===e)return po(or(Ya(t),n[0]),n[1]-1);if(e===1/0)return po(or(Ya(t),n[1]),n[0]);if(e===-1/0)return fo(or(Ya(t),n[1]),n[0]);if("fro"===e||"euclidean"===e)return Qs(or(tr(t),n));throw new Error(`Error in norm: invalid ord value: ${e}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const mo=Vs({norm_:function(t,e="euclidean",n=null,s=!1){const r=go(t=Ws(t,"x","norm"),e,n);let i=r.shape;if(s){const e=un(n,t.shape);i=ii(r.shape,e)}return ar(r,i)}});Vs({euclideanNorm_:function(t,e=null,n=!1){return mo(t,"euclidean",e,n)}});const bo=Vs({expandDims_:function(t,e=0){const n=Ws(t,"x","expandDims","string_or_numeric");tn(e<=n.rank,(()=>"Axis must be <= rank of the tensor"));const s={input:n},r={dim:e};return Ms.runKernel("ExpandDims",s,r)}});Vs({expm1_:function(t){const e={x:Ws(t,"x","expm1")};return Ms.runKernel("Expm1",e)}});const yo=Vs({eye_:function(t,e,n,s="float32"){null==e&&(e=t);const r=io([t,e],s),i=t<=e?t:e;for(let t=0;t<i;++t)r.set(1,t,t);const a=ar(r.toTensor(),[t,e]);if(null==n)return a;if(1===n.length)return $i(bo(a,0),[n[0],1,1]);if(2===n.length)return $i(bo(bo(a,0),0),[n[0],n[1],1,1]);if(3===n.length)return $i(bo(bo(bo(a,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});const wo=Vs({gather_:function(t,e,n=0,s=0){const r={x:Ws(t,"x","gather"),indices:Ws(e,"indices","gather","int32")},i={axis:n,batchDims:s};return Ms.runKernel("GatherV2",r,i)}});Vs({isFinite_:function(t){const e={x:Ws(t,"x","isFinite")};return Ms.runKernel("IsFinite",e)}}),Vs({isInf_:function(t){const e={x:Ws(t,"x","isInf")};return Ms.runKernel("IsInf",e)}}),Vs({isNaN_:function(t){const e={x:Ws(t,"x","isNaN")};return Ms.runKernel("IsNan",e)}});const ko=Vs({leakyRelu_:function(t,e=.2){const n={x:Ws(t,"x","leakyRelu")},s={alpha:e};return Ms.runKernel("LeakyRelu",n,s)}});Vs({localResponseNormalization_:function(t,e=5,n=1,s=1,r=.5){const i=Ws(t,"x","localResponseNormalization");tn(4===i.rank||3===i.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${i.rank}.`)),tn(on(e),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${e}.`));let a=i,o=!1;3===i.rank&&(o=!0,a=ar(i,[1,i.shape[0],i.shape[1],i.shape[2]]));const l={x:a},u={depthRadius:e,bias:n,alpha:s,beta:r},h=Ms.runKernel("LRN",l,u);return o?ar(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const vo=Vs({log1p_:function(t){const e={x:Ws(t,"x","log1p")};return Ms.runKernel("Log1p",e)}});function xo(t){return Ms.customGrad(t)}const So=Vs({softplus_:function(t){const e={x:Ws(t,"x","softplus")};return Ms.runKernel("Softplus",e)}});Vs({logSigmoid_:function(t){const e=Ws(t,"x","logSigmoid"),n=xo((t=>({value:Zs(So(Zs(t))),gradFunc:e=>js(e,to(Zs(t)))})));return n(e)}}),Vs({logSoftmax_:function(t,e=-1){const n=Ws(t,"logits","logSoftmax");if(-1===e&&(e=n.rank-1),e!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${e}`);const s=xo(((t,n)=>{const s=po(t,e,!0),r=er(t,s),i=er(Ks(r,"float32"),ya(or(vi(r),e,!0)));n([i]);return{value:i,gradFunc:(t,n)=>{const[s]=n,r=vi(s);return er(t,js(or(t,e,!0),r))}}}));return s(n)}});const No=Vs({logSumExp_:function(t,e=null,n=!1){const s=Ws(t,"x","logSumExp"),r=un(e,s.shape),i=po(s,r,!0),a=er(s,i),o=vi(a),l=or(o,r),u=ya(l),h=fr(ar(i,u.shape),u);if(n){const t=ii(h.shape,r);return ar(h,t)}return h}});const Eo=Vs({logicalNot_:function(t){const e={x:Ws(t,"x","logicalNot","bool")};return Ms.runKernel("LogicalNot",e)}});const Io=Vs({logicalOr_:function(t,e){const n=Ws(t,"a","logicalOr","bool"),s=Ws(e,"b","logicalOr","bool");ir(n.shape,s.shape);const r={a:n,b:s};return Ms.runKernel("LogicalOr",r)}});Vs({logicalXor_:function(t,e){const n=Ws(t,"a","logicalXor","bool"),s=Ws(e,"b","logicalXor","bool");return ir(n.shape,s.shape),Br(Io(t,e),Eo(Br(t,e)))}});Vs({searchSorted_:function(t,e,n="left"){const s=Ws(t,"sortedSequence","searchSorted"),r=Ws(e,"values","searchSorted"),i=s.shape[s.shape.length-1],a=r.shape[r.shape.length-1],o=ar(s,[-1,i]),l=ar(r,[-1,a]);if(o.rank<2)throw new Error("Sorted input argument must be at least 2-dimensional");if(o.shape[0]!==l.shape[0])throw new Error("Leading dimension of 'sortedSequence' and 'values' must match.");if(rn(l.shape)>=2147483648)throw new Error("values tensor size must less than 2147483648");if(o.shape[1]>=2147483648)throw new Error(`trailing dim_size must less than 2147483648 for int32 output type, was ${o.shape[1]}`);const u={sortedSequence:o,values:l},h={side:n};return Ms.runKernel("SearchSorted",u,h)}});const Ao=Vs({maxPool_:function(t,e,n,s,r){const i=Ws(t,"x","maxPool");let a=i,o=!1;3===i.rank&&(o=!0,a=ar(i,[1,i.shape[0],i.shape[1],i.shape[2]])),tn(4===a.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${a.rank}.`)),tn(Nr(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),Er("maxPool",s,r);const l={x:a},u={filterSize:e,strides:n,pad:s,dimRoundingMode:r},h=Ms.runKernel("MaxPool",l,u);return o?ar(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});Vs({maxPool3d_:function(t,e=[1,1,1],n,s,r,i="NDHWC"){const a=Ws(t,"x","maxPool3d");let o=a,l=!1;4===a.rank&&(l=!0,o=ar(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),tn(5===o.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${o.rank}.`)),tn("NDHWC"===i,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${i}`)),Er("maxPool3d",s,r);const u={x:o},h={filterSize:e,strides:n,pad:s,dimRoundingMode:r,dataFormat:i},c=Ms.runKernel("MaxPool3D",u,h);return l?ar(c,[c.shape[1],c.shape[2],c.shape[3],c.shape[4]]):c}}),Vs({maxPoolWithArgmax_:function(t,e,n,s,r=!1){const i={x:Ws(t,"x","maxPoolWithArgmax")},a={filterSize:e,strides:n,pad:s,includeBatchInIndex:r},o=Ms.runKernel("MaxPoolWithArgmax",i,a);return{result:o[0],indexes:o[1]}}});const To=Vs({maximum_:function(t,e){let n=Ws(t,"a","maximum"),s=Ws(e,"b","maximum");[n,s]=Cs(n,s),"bool"===n.dtype&&(n=Ks(n,"int32"),s=Ks(s,"int32")),ir(n.shape,s.shape);const r={a:n,b:s};return Ms.runKernel("Maximum",r)}});const $o=Vs({mean_:function(t,e=null,n=!1){const s={x:Ws(t,"x","mean")},r={axis:e,keepDims:n};return Ms.runKernel("Mean",s,r)}});const Co=Vs({minimum_:function(t,e){let n=Ws(t,"a","minimum"),s=Ws(e,"b","minimum");[n,s]=Cs(n,s),"bool"===n.dtype&&(n=Ks(n,"int32"),s=Ks(s,"int32")),ir(n.shape,s.shape);const r={a:n,b:s};return Ms.runKernel("Minimum",r)}});Vs({mirrorPad_:function(t,e,n){tn("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const s=Ws(t,"x","mirrorPad");if(0===s.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");tn(e.length===s.rank,(()=>`Padding doesn't match input. Must be ${s.rank}. Got ${e.length}.`));const r="reflect"===n?1:0;for(let t=0;t<s.rank;t++)tn(2===e[t].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),tn(e[t][0]>=0&&e[t][0]<=s.shape[t]-r&&e[t][1]>=0&&e[t][1]<=s.shape[t]-r,(()=>`Padding in dimension ${t} cannot be greater than or equal to ${s.shape[t]-r} or less than 0 for input of shape ${s.shape}`));const i={paddings:e,mode:n},a={x:s};return Ms.runKernel("MirrorPad",a,i)}}),Vs({mod_:function(t,e){let n=Ws(t,"a","mod"),s=Ws(e,"b","mod");[n,s]=Cs(n,s);const r={a:n,b:s};return Ms.runKernel("Mod",r)}}),Vs({moments_:function(t,e=null,n=!1){const s=un(e,(t=Ws(t,"x","moments")).shape),r=$o(t,s,n);let i=r.shape;n||(i=ii(r.shape,s));const a=tr(er(Ks(t,"float32"),ar(r,i)));return{mean:r,variance:$o(a,s,n)}}}),Vs({multiRNNCell_:function(t,e,n,s){const r=Ws(e,"data","multiRNNCell"),i=Us(n,"c","multiRNNCell"),a=Us(s,"h","multiRNNCell");let o=r;const l=[];for(let e=0;e<t.length;e++){const n=t[e](o,i[e],a[e]);l.push(n[0]),l.push(n[1]),o=n[1]}const u=[],h=[];for(let t=0;t<l.length;t+=2)u.push(l[t]),h.push(l[t+1]);return[u,h]}}),Vs({multinomial_:function(t,e,n,s=!1){const r=Ws(t,"logits","multinomial"),i=r.size,a=r.rank;if(i<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${i}.`);if(a>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${a}`);n=n||Math.random();const o={logits:1===a?ar(r,[1,-1]):r},l={numSamples:e,seed:n,normalized:s},u=Ms.runKernel("Multinomial",o,l);return 1===a?ar(u,[u.size]):u}});const zo=Vs({notEqual_:function(t,e){let n=Ws(t,"a","notEqual","string_or_numeric"),s=Ws(e,"b","notEqual","string_or_numeric");[n,s]=Cs(n,s),ir(n.shape,s.shape);const r={a:n,b:s};return Ms.runKernel("NotEqual",r)}});Vs({onesLike_:function(t){const e={x:Ws(t,"x","onesLike")};return Ms.runKernel("OnesLike",e)}}),Vs({outerProduct_:function(t,e){const n=Ws(t,"v1","outerProduct"),s=Ws(e,"v2","outerProduct");tn(1===n.rank&&1===s.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${s.rank}.`));const r=ar(n,[-1,1]),i=ar(s,[1,-1]);return Cr(r,i)}});const _o=Vs({pad_:function(t,e,n=0){const s=Ws(t,"x","pad");if(0===s.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const r={paddings:e,constantValue:n},i={x:s};return Ms.runKernel("PadV2",i,r)}});Vs({pad1d_:function(t,e,n=0){return tn(2===e.length,(()=>"Invalid number of paddings. Must be length of 2.")),_o(t,[e],n)}}),Vs({pad2d_:function(t,e,n=0){return tn(2===e.length&&2===e[0].length&&2===e[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),_o(t,e,n)}}),Vs({pad3d_:function(t,e,n=0){return tn(3===e.length&&2===e[0].length&&2===e[1].length&&2===e[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),_o(t,e,n)}}),Vs({pad4d_:function(t,e,n=0){return tn(4===e.length&&2===e[0].length&&2===e[1].length&&2===e[2].length&&2===e[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),_o(t,e,n)}}),Vs({pool_:function(t,e,n,s,r,i,a){null==r&&(r=[1,1]),null==i&&(i=1),0===s&&(s="valid");const o=Ws(t,"x","maxPool");let l=o,u=!1;3===o.rank&&(u=!0,l=ar(o,[1,o.shape[0],o.shape[1],o.shape[2]])),tn(Nr(i,r),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${i} and dilations '${r}'`));const h=function(t,e,n,s,r,i,a="channelsLast"){const[o,l]=kr(e);let u;if("channelsLast"===a)u=[o,l,t[3],t[3]];else{if("channelsFirst"!==a)throw new Error(`Unknown dataFormat ${a}`);u=[o,l,t[1],t[1]]}return wr(t,u,n,s,r,i,!1,a)}(l.shape,e,i,r,s),c=[h.dilationHeight,h.dilationWidth];let p;p="same"===s?function(t,e){const n=t.map(((t,n)=>t+(t-1)*(e[n]-1))).map((t=>t-1)),s=n.map((t=>Math.floor(t/2))),r=n.map(((t,e)=>t-s[e]));return n.map(((t,e)=>[s[e],r[e]]))}([h.filterHeight,h.filterWidth],c):[[0,0],[0,0]];const d=1===c[0]&&1===c[1],[f,g]=function(t,e,n){const s=n.map((t=>t[0])),r=n.map((t=>t[1])),i=t.concat(s,r),a=e.map(((t,e)=>(t-i[e]%t)%t)),o=r.map(((t,e)=>t+a[e])),l=e.map(((t,e)=>[s[e],o[e]])),u=e.map(((t,e)=>[0,a[e]]));return[l,u]}([h.inHeight,h.inWidth],c,p),m=d?s:"valid",b=d?l:_r(l,c,f),y=("avg"===n?()=>Xa(b,e,i,m,a):()=>Ao(b,e,i,m,a))(),w=d?y:no(y,c,g);return u?ar(w,[w.shape[1],w.shape[2],w.shape[3]]):w}});const Do=Vs({prelu_:function(t,e){const n={x:Ws(t,"x","prelu"),alpha:Ws(e,"alpha","prelu")};return Ms.runKernel("Prelu",n)}});Vs({prod_:function(t,e=null,n=!1){let s=Ws(t,"x","prod");"bool"===s.dtype&&(s=Ks(s,"int32"));const r={x:s},i={axis:e,keepDims:n};return Ms.runKernel("Prod",r,i)}}),Vs({raggedGather_:function(t,e,n,s){const r={paramsNestedSplits:t.map(((t,e)=>Ws(t,`tensors${e}`,"raggedGather","int32"))),paramsDenseValues:Ws(e,"paramsDenseValues","raggedGather"),indices:Ws(n,"indices","raggedGather","int32")},i={outputRaggedRank:s},a=Ms.runKernel("RaggedGather",r,i);return{outputNestedSplits:a.slice(0,a.length-1),outputDenseValues:a[a.length-1]}}}),Vs({raggedRange_:function(t,e,n){const s=Ws(t,"starts","raggedRange"),r={starts:s,limits:Ws(e,"limits","raggedRange",s.dtype),deltas:Ws(n,"deltas","raggedRange",s.dtype)},i=Ms.runKernel("RaggedRange",r);return{rtNestedSplits:i[0],rtDenseValues:i[1]}}}),Vs({raggedTensorToTensor_:function(t,e,n,s,r){const i=Ws(t,"shape","raggedTensorToTensor","int32"),a=Ws(e,"values","raggedTensorToTensor"),o={shape:i,values:a,defaultValue:Ws(n,"defaultValue","raggedTensorToTensor",a.dtype),rowPartitionTensors:s.map(((t,e)=>Ws(t,`tensors${e}`,"raggedTensorToTensor","int32")))},l={rowPartitionTypes:r};return Ms.runKernel("RaggedTensorToTensor",o,l)}}),Vs({rand_:function(t,e,n){const s=rn(t);let r=null;if(null==n||"float32"===n)r=new Float32Array(s);else if("int32"===n)r=new Int32Array(s);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);r=new Uint8Array(s)}for(let t=0;t<s;t++)r[t]=e();return Ms.makeTensor(r,t,n)}});var Fo="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function Ro(t){if(t.__esModule)return t;var e=Object.defineProperty({},"__esModule",{value:!0});return Object.keys(t).forEach((function(n){var s=Object.getOwnPropertyDescriptor(t,n);Object.defineProperty(e,n,s.get?s:{enumerable:!0,get:function(){return t[n]}})})),e}function Mo(t){var e={exports:{}};return t(e,e.exports),e.exports}var Lo=Mo((function(t){!function(t,e,n){function s(t){var e,n=this,s=(e=4022871197,function(t){t=String(t);for(var n=0;n<t.length;n++){var s=.02519603282416938*(e+=t.charCodeAt(n));s-=e=s>>>0,e=(s*=e)>>>0,e+=4294967296*(s-=e)}return 2.3283064365386963e-10*(e>>>0)});n.next=function(){var t=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=t-(n.c=0|t)},n.c=1,n.s0=s(" "),n.s1=s(" "),n.s2=s(" "),n.s0-=s(t),n.s0<0&&(n.s0+=1),n.s1-=s(t),n.s1<0&&(n.s1+=1),n.s2-=s(t),n.s2<0&&(n.s2+=1),s=null}function r(t,e){return e.c=t.c,e.s0=t.s0,e.s1=t.s1,e.s2=t.s2,e}function i(t,e){var n=new s(t),i=e&&e.state,a=n.next;return a.int32=function(){return 4294967296*n.next()|0},a.double=function(){return a()+11102230246251565e-32*(2097152*a()|0)},a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.alea=i}(0,t,!1)})),Oo=Mo((function(t){!function(t,e,n){function s(t){var e=this,n="";e.x=0,e.y=0,e.z=0,e.w=0,e.next=function(){var t=e.x^e.x<<11;return e.x=e.y,e.y=e.z,e.z=e.w,e.w^=e.w>>>19^t^t>>>8},t===(0|t)?e.x=t:n+=t;for(var s=0;s<n.length+64;s++)e.x^=0|n.charCodeAt(s),e.next()}function r(t,e){return e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e}function i(t,e){var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xor128=i}(0,t,!1)})),Bo=Mo((function(t){!function(t,e,n){function s(t){var e=this,n="";e.next=function(){var t=e.x^e.x>>>2;return e.x=e.y,e.y=e.z,e.z=e.w,e.w=e.v,(e.d=e.d+362437|0)+(e.v=e.v^e.v<<4^t^t<<1)|0},e.x=0,e.y=0,e.z=0,e.w=0,e.v=0,t===(0|t)?e.x=t:n+=t;for(var s=0;s<n.length+64;s++)e.x^=0|n.charCodeAt(s),s==n.length&&(e.d=e.x<<10^e.x>>>4),e.next()}function r(t,e){return e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e.v=t.v,e.d=t.d,e}function i(t,e){var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xorwow=i}(0,t,!1)})),Po=Mo((function(t){!function(t,e,n){function s(t){var e=this;e.next=function(){var t,n,s=e.x,r=e.i;return t=s[r],n=(t^=t>>>7)^t<<24,n^=(t=s[r+1&7])^t>>>10,n^=(t=s[r+3&7])^t>>>3,n^=(t=s[r+4&7])^t<<7,t=s[r+7&7],n^=(t^=t<<13)^t<<9,s[r]=n,e.i=r+1&7,n},function(t,e){var n,s=[];if(e===(0|e))s[0]=e;else for(e=""+e,n=0;n<e.length;++n)s[7&n]=s[7&n]<<15^e.charCodeAt(n)+s[n+1&7]<<13;for(;s.length<8;)s.push(0);for(n=0;n<8&&0===s[n];++n);for(8==n&&(s[7]=-1),t.x=s,t.i=0,n=256;n>0;--n)t.next()}(e,t)}function r(t,e){return e.x=t.x.slice(),e.i=t.i,e}function i(t,e){null==t&&(t=+new Date);var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&(i.x&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xorshift7=i}(0,t,!1)})),Wo=Mo((function(t){!function(t,e,n){function s(t){var e=this;e.next=function(){var t,n,s=e.w,r=e.X,i=e.i;return e.w=s=s+1640531527|0,n=r[i+34&127],t=r[i=i+1&127],n^=n<<13,t^=t<<17,n^=n>>>15,t^=t>>>12,n=r[i]=n^t,e.i=i,n+(s^s>>>16)|0},function(t,e){var n,s,r,i,a,o=[],l=128;for(e===(0|e)?(s=e,e=null):(e+="\0",s=0,l=Math.max(l,e.length)),r=0,i=-32;i<l;++i)e&&(s^=e.charCodeAt((i+32)%e.length)),0===i&&(a=s),s^=s<<10,s^=s>>>15,s^=s<<4,s^=s>>>13,i>=0&&(a=a+1640531527|0,r=0==(n=o[127&i]^=s+a)?r+1:0);for(r>=128&&(o[127&(e&&e.length||0)]=-1),r=127,i=512;i>0;--i)s=o[r+34&127],n=o[r=r+1&127],s^=s<<13,n^=n<<17,s^=s>>>15,n^=n>>>12,o[r]=s^n;t.w=a,t.X=o,t.i=r}(e,t)}function r(t,e){return e.i=t.i,e.w=t.w,e.X=t.X.slice(),e}function i(t,e){null==t&&(t=+new Date);var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&(i.X&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xor4096=i}(0,t,!1)})),Uo=Mo((function(t){!function(t,e,n){function s(t){var e=this,n="";e.next=function(){var t=e.b,n=e.c,s=e.d,r=e.a;return t=t<<25^t>>>7^n,n=n-s|0,s=s<<24^s>>>8^r,r=r-t|0,e.b=t=t<<20^t>>>12^n,e.c=n=n-s|0,e.d=s<<16^n>>>16^r,e.a=r-t|0},e.a=0,e.b=0,e.c=-1640531527,e.d=1367130551,t===Math.floor(t)?(e.a=t/4294967296|0,e.b=0|t):n+=t;for(var s=0;s<n.length+20;s++)e.b^=0|n.charCodeAt(s),e.next()}function r(t,e){return e.a=t.a,e.b=t.b,e.c=t.c,e.d=t.d,e}function i(t,e){var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.tychei=i}(0,t,!1)})),Vo=Ro({__proto__:null,default:{}}),Ko=Mo((function(t){!function(e,n,s){var r,i=256,a=s.pow(i,6),o=s.pow(2,52),l=2*o,u=255;function h(t,u,h){var m=[],b=f(d((u=1==u?{entropy:!0}:u||{}).entropy?[t,g(n)]:null==t?function(){try{var t;return r&&(t=r.randomBytes)?t=t(i):(t=new Uint8Array(i),(e.crypto||e.msCrypto).getRandomValues(t)),g(t)}catch(t){var s=e.navigator,a=s&&s.plugins;return[+new Date,e,a,e.screen,g(n)]}}():t,3),m),y=new c(m),w=function(){for(var t=y.g(6),e=a,n=0;t<o;)t=(t+n)*i,e*=i,n=y.g(1);for(;t>=l;)t/=2,e/=2,n>>>=1;return(t+n)/e};return w.int32=function(){return 0|y.g(4)},w.quick=function(){return y.g(4)/4294967296},w.double=w,f(g(y.S),n),(u.pass||h||function(t,e,n,r){return r&&(r.S&&p(r,y),t.state=function(){return p(y,{})}),n?(s.random=t,e):t})(w,b,"global"in u?u.global:this==s,u.state)}function c(t){var e,n=t.length,s=this,r=0,a=s.i=s.j=0,o=s.S=[];for(n||(t=[n++]);r<i;)o[r]=r++;for(r=0;r<i;r++)o[r]=o[a=u&a+t[r%n]+(e=o[r])],o[a]=e;(s.g=function(t){for(var e,n=0,r=s.i,a=s.j,o=s.S;t--;)e=o[r=u&r+1],n=n*i+o[u&(o[r]=o[a=u&a+e])+(o[a]=e)];return s.i=r,s.j=a,n})(i)}function p(t,e){return e.i=t.i,e.j=t.j,e.S=t.S.slice(),e}function d(t,e){var n,s=[],r=typeof t;if(e&&"object"==r)for(n in t)try{s.push(d(t[n],e-1))}catch(t){}return s.length?s:"string"==r?t:t+"\0"}function f(t,e){for(var n,s=t+"",r=0;r<s.length;)e[u&r]=u&(n^=19*e[u&r])+s.charCodeAt(r++);return g(e)}function g(t){return String.fromCharCode.apply(0,t)}if(f(s.random(),n),t.exports){t.exports=h;try{r=Vo}catch(t){}}else s.seedrandom=h}("undefined"!=typeof self?self:Fo,[],Math)}));Ko.alea=Lo,Ko.xor128=Oo,Ko.xorwow=Bo,Ko.xorshift7=Po,Ko.xor4096=Wo,Ko.tychei=Uo;var jo=Ko;class qo{constructor(t,e,n,s,r){this.mean=t,this.stdDev=e,this.dtype=n,this.nextVal=NaN,this.truncated=s,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const i=r||Math.random();this.random=jo.alea(i.toString())}nextValue(){if(!isNaN(this.nextVal)){const t=this.nextVal;return this.nextVal=NaN,t}let t,e,n=!1;for(;!n;){let s,r,i;do{s=2*this.random()-1,r=2*this.random()-1,i=s*s+r*r}while(i>=1||0===i);const a=Math.sqrt(-2*Math.log(i)/i);t=this.mean+this.stdDev*s*a,e=this.mean+this.stdDev*r*a,this.truncated&&!this.isValidTruncated(t)||(n=!0)}return this.truncated&&!this.isValidTruncated(e)||(this.nextVal=this.convertValue(e)),this.convertValue(t)}convertValue(t){return null==this.dtype||"float32"===this.dtype?t:Math.round(t)}isValidTruncated(t){return t<=this.upper&&t>=this.lower}}class Go{constructor(t,e,n,s){this.alpha=t,this.beta=1/e,this.dtype=n;const r=s||Math.random();this.randu=jo.alea(r.toString()),this.randn=new qo(0,1,n,!1,this.randu()),this.d=t<1?t+2/3:t-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let t,e,n,s,r,i;for(;;){do{s=this.randn.nextValue(),i=1+this.c*s}while(i<=0);if(i*=i*i,t=s*s,e=1-.331*t*t,n=.5*t+this.d*(1-i+Math.log(i)),r=this.randu(),r<e||Math.log(r)<n)break}return i=1/this.beta*this.d*i,this.alpha<1&&(i*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(i)}convertValue(t){return"float32"===this.dtype?t:Math.round(t)}}class Ho{constructor(t=0,e=1,n,s){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=t,this.range=e-t,this.dtype=n,null==s&&(s=Math.random()),"number"==typeof s&&(s=s.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${t} - ${e} <= 1 and dtype is not float`);this.random=jo.alea(s)}convertValue(t){return this.canReturnFloat()?t:Math.round(t)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}Vs({randomGamma_:function(t,e,n=1,s="float32",r){if(null==n&&(n=1),null==s&&(s="float32"),"float32"!==s&&"int32"!==s)throw new Error(`Unsupported data type ${s}`);const i=new Go(e,n,s,r),a=io(t,s);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}});const Jo=Vs({randomNormal_:function(t,e=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error(`Unsupported data type ${s}`);const i=new qo(e,n,s,!1,r),a=io(t,s);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}});Vs({randomStandardNormal_:function(t,e,n){if(null!=e&&"bool"===e)throw new Error(`Unsupported data type ${e}`);return Jo(t,0,1,e,n)}});const Zo=Vs({randomUniform_:function(t,e=0,n=1,s="float32",r){const i=io(t,s),a=new Ho(e,n,null,r);for(let t=0;t<i.values.length;t++)i.values[t]=a.nextValue();return i.toTensor()}});function Yo(t,e,n=1,s="float32"){if(0===n)throw new Error("Cannot have a step of zero");const r={start:t,stop:e,step:n,dtype:s};return Ms.runKernel("Range",{},r)}Vs({reciprocal_:function(t){const e={x:Ws(t,"x","reciprocal")};return Ms.runKernel("Reciprocal",e)}});const Xo=Vs({relu_:function(t){const e={x:Ws(t,"x","relu")};return Ms.runKernel("Relu",e)}});const Qo=Vs({relu6_:function(t){const e={x:Ws(t,"x","relu6")};return Ms.runKernel("Relu6",e)}});const tl=Vs({reverse_:function(t,e){const n={x:Ws(t,"x","reverse")},s={dims:e};return Ms.runKernel("Reverse",n,s)}});Vs({reverse1d_:function(t){const e=Ws(t,"x","reverse");return tn(1===e.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${e.rank}.`)),tl(e,0)}}),Vs({reverse2d_:function(t,e){const n=Ws(t,"x","reverse");return tn(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),tl(n,e)}}),Vs({reverse3d_:function(t,e){const n=Ws(t,"x","reverse");return tn(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),tl(n,e)}}),Vs({reverse4d_:function(t,e){const n=Ws(t,"x","reverse");return tn(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),tl(n,e)}});const el=Vs({round_:function(t){const e={x:Ws(t,"x","round")};return Ms.runKernel("Round",e)}});Vs({selu_:function(t){const e={x:Ws(t,"x","selu")};return Ms.runKernel("Selu",e)}}),Vs({separableConv2d_:function(t,e,n,s,r,i=[1,1],a="NHWC"){const o=Ws(t,"x","separableConv2d"),l=Ws(e,"depthwiseFilter","separableConv2d"),u=Ws(n,"pointwiseFilter","separableConv2d");let h=o,c=!1;if(3===o.rank&&(c=!0,h=ar(o,[1,o.shape[0],o.shape[1],o.shape[2]])),"NCHW"===a)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");tn(4===h.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`)),tn(4===l.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${l.rank}.`)),tn(4===u.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${l.rank}.`)),tn(1===u.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${u.shape[0]}.`)),tn(1===u.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${u.shape[1]}.`));const p=l.shape[2],d=l.shape[3];tn(u.shape[2]===p*d,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${p*d}, but got ${u.shape[2]}.`));const f=ho(h,l,s,r,a,i),g=Zr(f,u,1,"valid",a);return c?ar(g,[g.shape[1],g.shape[2],g.shape[3]]):g}}),Vs({sign_:function(t){const e={x:Ws(t,"x","sign")};return Ms.runKernel("Sign",e)}}),Vs({slice1d_:function(t,e,n){const s=Ws(t,"x","slice1d");return tn(1===s.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${s.rank} tensor`)),oa(s,[e],[n])}}),Vs({slice2d_:function(t,e,n){const s=Ws(t,"x","slice2d");return tn(2===s.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${s.rank} tensor`)),oa(s,e,n)}}),Vs({slice3d_:function(t,e,n){const s=Ws(t,"x","slice3d");return tn(3===s.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${s.rank} tensor`)),oa(s,e,n)}}),Vs({slice4d_:function(t,e,n){const s=Ws(t,"x","slice4d");return tn(4===s.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${s.rank} tensor`)),oa(s,e,n)}}),Vs({softmax_:function(t,e=-1){const n=Ws(t,"logits","softmax","float32");if(-1===e&&(e=n.rank-1),e!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${e}`);const s={logits:n},r={dim:e};return Ms.runKernel("Softmax",s,r)}});const nl=Vs({fft_:function(t){tn("complex64"===t.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${t.dtype}.`));const e={input:t};return Ms.runKernel("FFT",e)}});const sl=Vs({ifft_:function(t){tn("complex64"===t.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${t.dtype}.`));const e={input:t};return Ms.runKernel("IFFT",e)}});Vs({irfft_:function(t){const e=t.shape[t.shape.length-1],n=t.size/e;let s;if(e<=2){const r=ar(t,[n,e]);s=sl(r)}else{const r=[n,2*(e-1)],i=ar(di(t),[n,e]),a=ar(pi(t),[n,e]),o=tl(oa(i,[0,1],[n,e-2]),1),l=js(tl(oa(a,[0,1],[n,e-2]),1),Xs(-1)),u=Qa([i,o],1),h=Qa([a,l],1),c=ar(ci(u,h),[r[0],r[1]]);s=sl(c)}if(s=di(s),3===t.rank&&0!==t.shape[0]){const e=s,n=t.shape[0];s=ar(s,[n,s.shape[0]/n,s.shape[1]]),e.dispose()}return s}});const rl=Vs({rfft_:function(t,e){tn("float32"===t.dtype,(()=>`The dtype for rfft() must be real value but got ${t.dtype}`));let n=t.shape[t.shape.length-1];const s=t.size/n;let r;if(null!=e&&e<n){const s=t.shape.map((t=>0)),i=t.shape.map((t=>t));i[t.shape.length-1]=e,r=oa(t,s,i),n=e}else if(null!=e&&e>n){const s=t.shape.map((t=>t));s[t.shape.length-1]=e-n,r=Qa([t,na(s)],t.shape.length-1),n=e}else r=t;const i=hr(r),a=ar(ci(r,i),[s,n]),o=nl(a),l=Math.floor(n/2)+1,u=di(o),h=pi(o),c=jr(u,[l,n-l],u.shape.length-1),p=jr(h,[l,n-l],h.shape.length-1),d=r.shape.slice();return d[r.shape.length-1]=l,ar(ci(c[0],p[0]),d)}});const il=Vs({squaredDifference_:function(t,e){let n=Ws(t,"a","squaredDifference"),s=Ws(e,"b","squaredDifference");[n,s]=Cs(n,s),ir(n.shape,s.shape);const r={a:n,b:s};return Ms.runKernel("SquaredDifference",r,{})}});const al=Vs({squeeze_:function(t,e){const n=Ws(t,"x","squeeze","string_or_numeric");return ar(n,function(t,e){const n=[],s=[],r=null!=e&&Array.isArray(e)&&0===e.length,i=null==e||r?null:un(e,t).sort();let a=0;for(let e=0;e<t.length;++e){if(null!=i){if(i[a]===e&&1!==t[e])throw new Error(`Can't squeeze axis ${e} since its dim '${t[e]}' is not 1`);(null==i[a]||i[a]>e)&&1===t[e]&&(n.push(t[e]),s.push(e)),i[a]<=e&&a++}1!==t[e]&&(n.push(t[e]),s.push(e))}return{newShape:n,keptDims:s}}(n.shape,e).newShape)}});const ol=Vs({stack_:function(t,e=0){const n=Us(t,"tensors","stack","string_or_numeric");tn(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&tn(e<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const s=n,r={axis:e};return Ms.runKernel("Pack",s,r)}});function ll(t,e){nn(t);const n=Os(t,e);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return Ys(t,null,n,e)}function ul(t,e,n){if(nn(t),null!=e&&2!==e.length)throw new Error("tensor2d() requires shape to have two numbers");const s=Os(t,n);if(2!==s.length&&1!==s.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return Ys(t,e,s,n)}function hl(t,e,n){const s=1-t%2,r=new Float32Array(t);for(let i=0;i<t;++i){const a=2*Math.PI*i/(t+s-1);r[i]=e-n*Math.cos(a)}return ll(r,"float32")}function cl(t,e,n){if(null==n||"linear"===n)return t;if("relu"===n)return js(t,qs(e));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function pl(t,e){let n=e;const s=rr(t.shape,e.shape);return s.length>0&&(n=or(n,s)),ar(n,t.shape)}function dl(t,e,n,s){if("linear"===e)return t;if("relu"===e)return Xo(t);if("elu"===e)return co(t);if("relu6"===e)return Qo(t);if("prelu"===e)return Do(t,n);if("leakyrelu"===e)return ko(t,s);if("sigmoid"===e)return to(t);throw new Error(`Unknown fused activation ${e}.`)}Vs({stridedSlice_:function(t,e,n,s,r=0,i=0,a=0,o=0,l=0){const u={x:Ws(t,"x","stridedSlice","string_or_numeric")},h={begin:e,end:n,strides:s,beginMask:r,endMask:i,ellipsisMask:a,newAxisMask:o,shrinkAxisMask:l};return Ms.runKernel("StridedSlice",u,h)}}),Vs({tan_:function(t){const e={x:Ws(t,"x","tan","float32")};return Ms.runKernel("Tan",e)}}),Vs({topk_:function(t,e=1,n=!0){const s=Ws(t,"x","topk");if(0===s.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const r=s.shape[s.shape.length-1];if(e<0)throw new Error(`'k' passed to topk() must be >= 0 but got ${e}`);if(e>r)throw new Error(`'k' passed to topk() must be <= the last dimension (${r}) but got ${e}`);const i={x:s},a={k:e,sorted:n},[o,l]=Ms.runKernel("TopK",i,a);return{values:o,indices:l}}}),Vs({truncatedNormal_:function(t,e=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error("Unsupported data type $ { dtype }");const i=new qo(e,n,s,!0,r),a=io(t,s);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}}),Vs({unique_:function(t,e=0){const n=Ws(t,"x","unique","string_or_numeric");tn(n.rank>0,(()=>"The input tensor must be at least 1D"));const s={x:n},r={axis:e},[i,a]=Ms.runKernel("Unique",s,r);return{values:i,indices:a}}}),Vs({movingAverage_:function(t,e,n,s,r=!0){const i=Ws(t,"v","movingAverage"),a=Ws(e,"x","movingAverage"),o=Ws(n,"decay","movingAverage");var l,u;u=a,tn((l=i).dtype===u.dtype,(()=>`The dtypes of the first(${l.dtype}) and second(${u.dtype}) input must match`)),tn(an(i.shape,a.shape),(()=>"Shape mismatch in v and x"));const h=Xs(1),c=er(h,o);let p=js(er(a,i),c);if(r){tn(null!=s,(()=>"When using zeroDebias: true, step is required."));const t=Ws(s,"step","movingAverage");p=Js(p,er(h,wa(o,t)))}return fr(i,p)}}),Vs({scatterND_:function(t,e,n){const s=Ws(t,"indices","scatterND","int32"),r=Ws(e,"updates","scatterND");Ha(r,s,n);const i={indices:s,updates:r},a={shape:n};return Ms.runKernel("ScatterNd",i,a)}}),Vs({sparseToDense_:function(t,e,n,s=0){const r=Ws(t,"sparseIndices","sparseToDense","int32"),i=Ws(e,"sparseValues","sparseToDense","string_or_numeric"),a=Ws(s,"defaultValue","sparseToDense",i.dtype);!function(t,e,n,s){if("int32"!==t.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${t.shape}.`);const r=t.rank>0?t.shape[0]:1,i=t.rank>1?t.shape[1]:1;if(n.length!==i)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${i}.`);const a=e.size;if(0!==e.rank&&(1!==e.rank||a!==r))throw new Error(`sparseValues has incorrect shape ${e.shape}, should be [] or [${r}]`);if(e.dtype!==s.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(r,i,n,a);const o={sparseIndices:r,sparseValues:i,defaultValue:a},l={outputShape:n};return Ms.runKernel("SparseToDense",o,l)}}),Vs({gatherND_:function(t,e){const n=Ws(e,"indices","gatherND","int32"),s={params:Ws(t,"x","gatherND","string_or_numeric"),indices:n};return Ms.runKernel("GatherNd",s)}}),Vs({dropout_:function(t,e,n,s){const r=Ws(t,"x","dropout");if(tn("float32"===r.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${r.dtype} tensor instead.`)),tn(e>=0&&e<1,(()=>`rate must be a float in the range [0, 1), but got ${e}.`)),0===e)return t instanceof xs?r.clone():r;const i=function(t,e){if(null==e)return t.shape.slice();if(an(t.shape,e))return e;if(t.shape.length===e.length){const n=[];for(let s=0;s<t.shape.length;s++)null==e[s]&&null!=t.shape[s]?n.push(t.shape[s]):n.push(e[s]);return n}return e}(r,n),a=1-e,o=Js(ua(fr(Zo(i,0,1,"float32",s),a)),a);return js(r,o)}});const fl=(t,e)=>!(t>0)||"linear"===e;Vs({fusedConv2d_:function({x:t,filter:e,strides:n,pad:s,dataFormat:r="NHWC",dilations:i=[1,1],dimRoundingMode:a,bias:o,activation:l="linear",preluActivationWeights:u,leakyreluAlpha:h}){if(l=l||"linear",!1===fl(Ms.state.gradientDepth,l)){tn("NHWC"===r,(()=>`Error in fused conv2d: got dataFormat of ${r} but only NHWC is currently supported for the case of gradient depth is 0 and the activation is not linear.`));let c=Zr(t,e,n,s,r,i,a);return null!=o&&(c=fr(c,o)),dl(c,l,u,h)}const c=Ws(t,"x","conv2d","float32"),p=Ws(e,"filter","conv2d","float32");let d=c,f=!1;3===c.rank&&(f=!0,d=ar(c,[1,c.shape[0],c.shape[1],c.shape[2]])),tn(4===d.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${d.rank}.`)),tn(4===p.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${p.rank}.`)),Er("fused conv2d",s,a);const g="NHWC"===r?d.shape[3]:d.shape[1];tn(p.shape[2]===g,(()=>`Error in conv2d: depth of input (${g}) must match input depth for filter ${p.shape[2]}.`)),tn(Nr(n,i),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`));const m=wr(d.shape,p.shape,n,i,s,a);let b,y;if(null!=o&&(b=Ws(o,"bias","fused conv2d"),[b]=Cs(b,c),"NHWC"===r?ir(m.outShape,b.shape):(tn(b.shape.length<=1,(()=>`Error in fused conv2d: only supports scalar or 1-D Tensor bias for NCHW format but got the bias of rank-${b.shape.length}.`)),tn(0===b.shape.length||b.shape[0]===m.outChannels||1===b.shape[0],(()=>`Error in fused conv2d: bias shape (${b.shape}) is not compatible with the number of output channels (${m.outChannels})`)))),null!=u){const t=u.shape;if(tn(t.length<=1||3===t.length,(()=>`Error in fused conv2d: only supports scalar, 1-D Tensor or 3-D Tensor PReLU activation weights but got a tensor of rank-${t.length}.`)),1===t.length)tn(1===t[0]||t[0]===m.outChannels,(()=>`Error in fused conv2d: PReLU activation weights (${t}) is not compatible with the number of output channels (${m.outChannels}).`));else if(3===t.length)try{ir(t,m.outShape)}catch(e){const n=`Error in fused conv2d: PReLU activation weights (${t}) is not compatible with the output shape of the conv2d (${m.outShape}).`;throw Error(n)}y=Ws(u,"prelu weights","fused conv2d")}const w=(t,e)=>{tn("NHWC"===r,(()=>`Error in gradient of fused conv2D: got dataFormat of ${r} but only NHWC is currently supported.`));const[a,o,u,h]=e,c=cl(t,u,l);tn(Sr(i),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${i}'`));const p=[Hr(o.shape,c,a,n,s),Gr(o,c,a.shape,n,s)];if(null!=h){const t=pl(h,c);p.push(t)}return p},k={x:d,filter:p,bias:b,preluActivationWeights:y},v={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a,activation:l,leakyreluAlpha:h};if(null==o){const t=xo(((t,e,n)=>{let s=Ms.runKernel("FusedConv2D",k,v);return n([e,t,s]),f&&(s=ar(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}));return t(d,p)}{const t=xo(((t,e,n,s)=>{let r=Ms.runKernel("FusedConv2D",k,v);return s([e,t,r,n]),f&&(r=ar(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}));return t(d,p,b)}}}),Vs({fusedDepthwiseConv2d_:function({x:t,filter:e,strides:n,pad:s,dataFormat:r="NHWC",dilations:i=[1,1],dimRoundingMode:a,bias:o,activation:l="linear",preluActivationWeights:u,leakyreluAlpha:h}){if(!1===fl(Ms.state.gradientDepth,l)){let c=ho(t,e,n,s,r,i,a);return null!=o&&(c=fr(c,o)),dl(c,l,u,h)}const c=Ws(t,"x","depthwiseConv2d","float32"),p=Ws(e,"filter","depthwiseConv2d","float32");let d=c,f=!1;3===c.rank&&(f=!0,d=ar(c,[1,c.shape[0],c.shape[1],c.shape[2]])),tn(4===d.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${d.rank}.`)),tn(4===p.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${p.rank}.`)),tn(d.shape[3]===p.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${d.shape[3]}) must match the inChannels dimension in filter ${p.shape[2]}.`)),null==i&&(i=[1,1]),tn(Nr(n,i),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`)),Er("fused depthwiseConv2d",s,a);const g=wr(d.shape,p.shape,n,i,s,a,!0);let m,b;null!=o&&(m=Ws(o,"bias","fused conv2d"),[m]=Cs(m,c),ir(g.outShape,m.shape)),null!=u&&(b=Ws(u,"prelu weights","fused depthwiseConv2d"));const y=(t,e)=>{tn(Sr(i),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${i}'`));const[r,o,u,h]=e,c=cl(t,u,l),p=bi(o.shape,c,r,n,s,i,a),d=mi(o,c,r.shape,n,s,i,a);if(null!=h){return[p,d,pl(m,c)]}return[p,d]},w={x:d,filter:p,bias:m,preluActivationWeights:b},k={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a,activation:l,leakyreluAlpha:h};if(null==o){const t=xo(((t,e,n)=>{let s=Ms.runKernel("FusedDepthwiseConv2D",w,k);return n([e,t,s]),f&&(s=ar(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:y}}));return t(d,p)}{const t=xo(((t,e,n,s)=>{let r=Ms.runKernel("FusedDepthwiseConv2D",w,k);return s([e,t,r,n]),f&&(r=ar(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:y}}));return t(d,p,m)}}}),Vs({fusedMatMul_:function({a:t,b:e,transposeA:n=!1,transposeB:s=!1,bias:r,activation:i="linear",preluActivationWeights:a,leakyreluAlpha:o=.2}){if(!1===fl(Ms.state.gradientDepth,i)){let l=Cr(t,e,n,s);return null!=r&&(l=fr(l,r)),dl(l,i,a,o)}let l=Ws(t,"a","fused matMul"),u=Ws(e,"b","fused matMul");[l,u]=Cs(l,u);const h=n?l.shape[l.rank-2]:l.shape[l.rank-1],c=s?u.shape[u.rank-1]:u.shape[u.rank-2],p=n?l.shape[l.rank-1]:l.shape[l.rank-2],d=s?u.shape[u.rank-2]:u.shape[u.rank-1],f=l.shape.slice(0,-2),g=u.shape.slice(0,-2),m=rn(f),b=rn(g);tn(h===c,(()=>`Error in fused matMul: inner shapes (${h}) and (${c}) of Tensors with shapes ${l.shape} and ${u.shape} and transposeA=${n} and transposeB=${s} must match.`));const y=ir(l.shape.slice(0,-2),u.shape.slice(0,-2)).concat([p,d]),w=ar(l,n?[m,h,p]:[m,p,h]),k=ar(u,s?[b,d,c]:[b,c,d]);let v,x;null!=r&&(v=Ws(r,"bias","fused matMul"),[v]=Cs(v,l),ir(y,v.shape)),null!=a&&(x=Ws(a,"prelu weights","fused matMul"));const S=(t,e)=>{const[a,o,l,u]=e,h=cl(ar(t,l.shape),l,i);let c,p;if(n||s?!n&&s?(c=Cr(h,o,!1,!1),p=Cr(h,a,!0,!1)):n&&!s?(c=Cr(o,h,!1,!0),p=Cr(a,h,!1,!1)):(c=Cr(o,h,!0,!0),p=Cr(h,a,!0,!0)):(c=Cr(h,o,!1,!0),p=Cr(a,h,!0,!1)),null!=r){return[c,p,pl(u,h)]}return[c,p]},N={a:w,b:k,bias:v,preluActivationWeights:x},E={transposeA:n,transposeB:s,activation:i,leakyreluAlpha:o};if(null==r){const t=xo(((t,e,n)=>{const s=Ms.runKernel("_FusedMatMul",N,E);return n([t,e,s]),{value:ar(s,y),gradFunc:S}}));return t(w,k)}{const t=xo(((t,e,n,s)=>{const r=Ms.runKernel("_FusedMatMul",N,E);return s([t,e,r,n]),{value:ar(r,y),gradFunc:S}}));return t(w,k,v)}}}),Vs({hammingWindow_:function(t){return hl(t,.54,.46)}});const gl=Vs({hannWindow_:function(t){return hl(t,.5,.5)}});const ml=Vs({frame_:function(t,e,n,s=!1,r=0){let i=0;const a=[];for(;i+e<=t.size;)a.push(oa(t,i,e)),i+=n;if(s)for(;i<t.size;){const s=i+e-t.size,o=Qa([oa(t,i,e-s),ao([s],r)]);a.push(o),i+=n}return 0===a.length?ul([],[0,e]):ar(Qa(a),[a.length,e])}});function bl(t,e,n,s,r,i){null==s&&(s=.5),null==r&&(r=Number.NEGATIVE_INFINITY),null==i&&(i=0);const a=t.shape[0];return n=Math.min(n,a),tn(0<=s&&s<=1,(()=>`iouThreshold must be in [0, 1], but was '${s}'`)),tn(2===t.rank,(()=>`boxes must be a 2D tensor, but was of rank '${t.rank}'`)),tn(4===t.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${t.shape[1]}`)),tn(1===e.rank,(()=>"scores must be a 1D tensor")),tn(e.shape[0]===a,(()=>`scores has incompatible shape with boxes. Expected ${a}, but was ${e.shape[0]}`)),tn(0<=i&&i<=1,(()=>`softNmsSigma must be in [0, 1], but was '${i}'`)),{maxOutputSize:n,iouThreshold:s,scoreThreshold:r,softNmsSigma:i}}function yl(t,e=!1){return Ms.tidy((()=>{tn(2===t.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${t.shape.length}D Tensor.`));const n=t.shape[0],s=t.shape[1];let r=yo(n),i=Pr(t);const a=ul([[1]],[1,1]);let o=Pr(a);const l=n>=s?s:n;for(let t=0;t<l;++t){const e=i,l=o,u=r;[o,i,r]=Ms.tidy((()=>{const e=oa(i,[t,t],[n-t,1]),l=mo(e),u=oa(i,[t,t],[1,1]),h=Ur(Pi(u,0),ul([[-1]]),ul([[1]])),c=er(u,js(h,l)),p=Js(e,c);o=1===p.shape[0]?Pr(a):Qa([a,oa(p,[1,0],[p.shape[0]-1,p.shape[1]])],0);const d=Zs(Js(Cr(h,c),l)),f=oa(i,[t,0],[n-t,s]),g=js(d,o),m=fi(o);if(0===t)i=er(f,Cr(g,Cr(m,f)));else{const e=er(f,Cr(g,Cr(m,f)));i=Qa([oa(i,[0,0],[t,s]),e],0)}const b=fi(g),y=oa(r,[0,t],[n,r.shape[1]-t]);if(0===t)r=er(y,Cr(Cr(y,o),b));else{const e=er(y,Cr(Cr(y,o),b));r=Qa([oa(r,[0,0],[n,t]),e],1)}return[o,i,r]})),hi([e,l,u])}return!e&&n>s&&(r=oa(r,[0,0],[n,s]),i=oa(i,[0,0],[s,s])),[r,i]}))}var wl;Vs({stft_:function(t,e,n,s,r=gl){var i;null==s&&(i=e,s=Math.floor(Math.pow(2,Math.ceil(Math.log(i)/Math.log(2)))));const a=ml(t,e,n),o=js(a,r(e));return rl(o,s)}}),Vs({cropAndResize_:function(t,e,n,s,r="bilinear",i=0){const a=Ws(t,"image","cropAndResize"),o=Ws(e,"boxes","cropAndResize","float32"),l=Ws(n,"boxInd","cropAndResize","int32"),u=o.shape[0];tn(4===a.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${a.rank}.`)),tn(2===o.rank&&4===o.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${u},4] but had shape ${o.shape}.`)),tn(1===l.rank&&l.shape[0]===u,(()=>`Error in cropAndResize: boxInd must be have size [${u}] but had shape ${o.shape}.`)),tn(2===s.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${s.length}.`)),tn(s[0]>=1&&s[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${s}`)),tn("bilinear"===r||"nearest"===r,(()=>`method must be bilinear or nearest, but was ${r}`));const h={image:a,boxes:o,boxInd:l},c={method:r,extrapolationValue:i,cropSize:s};return Ms.runKernel("CropAndResize",h,c)}}),Vs({flipLeftRight_:function(t){const e=Ws(t,"image","flipLeftRight","float32");tn(4===e.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${e.rank}.`));const n={image:e};return Ms.runKernel("FlipLeftRight",n,{})}}),Vs({grayscaleToRGB_:function(t){const e=Ws(t,"image","grayscaleToRGB"),n=e.rank-1,s=e.shape[n];tn(e.rank>=2,(()=>`Error in grayscaleToRGB: images must be at least rank 2, but got rank ${e.rank}.`)),tn(1===s,(()=>`Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${s}.`));const r=new Array(e.rank);return r.fill(1,0,n),r[n]=3,$i(e,r)}}),Vs({rotateWithOffset_:function(t,e,n=0,s=.5){const r=Ws(t,"image","rotateWithOffset","float32");tn(4===r.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${r.rank}.`));const i={image:r},a={radians:e,fillValue:n,center:s};return Ms.runKernel("RotateWithOffset",i,a)}}),Vs({nonMaxSuppression_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY){const i=Ws(t,"boxes","nonMaxSuppression","float32"),a=Ws(e,"scores","nonMaxSuppression","float32"),o=bl(i,a,n,s,r),l={maxOutputSize:n=o.maxOutputSize,iouThreshold:s=o.iouThreshold,scoreThreshold:r=o.scoreThreshold};return Ms.runKernel("NonMaxSuppressionV3",{boxes:i,scores:a},l)}}),Vs({nonMaxSuppressionWithScore_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY,i=0){const a=Ws(t,"boxes","nonMaxSuppression"),o=Ws(e,"scores","nonMaxSuppression"),l=bl(a,o,n,s,r,i),u={boxes:a,scores:o},h={maxOutputSize:n=l.maxOutputSize,iouThreshold:s=l.iouThreshold,scoreThreshold:r=l.scoreThreshold,softNmsSigma:i=l.softNmsSigma},c=Ms.runKernel("NonMaxSuppressionV5",u,h);return{selectedIndices:c[0],selectedScores:c[1]}}}),Vs({nonMaxSuppressionPadded_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY,i=!1){const a=Ws(t,"boxes","nonMaxSuppression"),o=Ws(e,"scores","nonMaxSuppression"),l=bl(a,o,n,s,r,null),u={boxes:a,scores:o},h={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:i},c=Ms.runKernel("NonMaxSuppressionV4",u,h);return{selectedIndices:c[0],validOutputs:c[1]}}}),Vs({resizeBilinear_:function(t,e,n=!1,s=!1){const r=Ws(t,"images","resizeBilinear");tn(3===r.rank||4===r.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${r.rank}.`)),tn(2===e.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${e}.`)),tn(!1===s||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let i=r,a=!1;3===r.rank&&(a=!0,i=ar(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const o={images:i},l={alignCorners:n,halfPixelCenters:s,size:e},u=Ms.runKernel("ResizeBilinear",o,l);return a?ar(u,[u.shape[1],u.shape[2],u.shape[3]]):u}}),Vs({resizeNearestNeighbor_:function(t,e,n=!1,s=!1){const r=Ws(t,"images","resizeNearestNeighbor");tn(3===r.rank||4===r.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${r.rank}.`)),tn(2===e.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${e}.`)),tn("float32"===r.dtype||"int32"===r.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),tn(!1===s||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let i=r,a=!1;3===r.rank&&(a=!0,i=ar(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const o={images:i},l={alignCorners:n,halfPixelCenters:s,size:e},u=Ms.runKernel("ResizeNearestNeighbor",o,l);return a?ar(u,[u.shape[1],u.shape[2],u.shape[3]]):u}}),Vs({threshold_:function(t,e="binary",n=!1,s=.5){const r=Ws(t,"image","threshold"),i=r.shape[0]*r.shape[1];let a,o,l,u,h=js(ll([s]),255);if(tn(3===r.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${r.rank}.`)),tn(3===r.shape[2]||1===r.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${r.shape[2]}.`)),tn("int32"===r.dtype||"float32"===r.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${r.dtype}.`)),tn("otsu"===e||"binary"===e,(()=>`Method must be binary or otsu, but was ${e}`)),3===r.shape[2]){[a,o,l]=jr(r,[1,1,1],-1);const t=js(a,.2989),e=js(o,.587),n=js(l,.114);u=fr(fr(t,e),n)}else u=t;if("otsu"===e){h=function(t,e){let n,s,r,i,a,o,l=ll([-1]),u=ll([0]),h=ll([0]);for(let c=0;c<t.size-1;c++){n=oa(t,0,c+1),s=oa(t,c+1),a=Js(or(n),e),o=Js(or(s),e);const p=or(js(n,Yo(0,n.size)));r=Js(p,or(n));const d=ao(s.shape,n.size),f=fr(Yo(0,s.size),d),g=js(s,f);i=Js(or(g),or(s));const m=er(r,i),b=er(r,i),y=js(a,o);h=js(js(y,m),b);const w=Pi(h,u);u=Ur(w,h,u),l=Ur(w,ll([c]),l)}return l}(ro(Ks(el(u),"int32"),Ys(c=[],p,Os(c,d),d),256),i)}var c,p,d;const f=n?Or(u,h):Pi(u,h);return Ks(js(f,255),"int32")}}),Vs({transform_:function(t,e,n="nearest",s="constant",r=0,i){const a=Ws(t,"image","transform","float32"),o=Ws(e,"transforms","transform","float32");tn(4===a.rank,(()=>`Error in transform: image must be rank 4,but got rank ${a.rank}.`)),tn(2===o.rank&&(o.shape[0]===a.shape[0]||1===o.shape[0])&&8===o.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),tn(null==i||2===i.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${i}.`));const l={image:a,transforms:o},u={interpolation:n,fillMode:s,fillValue:r,outputShape:i};return Ms.runKernel("Transform",l,u)}}),Vs({bandPart_:function(t,e,n){tn(e%1==0,(()=>`bandPart(): numLower must be an integer, got ${e}.`)),tn(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`));const s=Ws(t,"a","bandPart");tn(s.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${s.rank}.`));const r=s.shape,[i,a]=s.shape.slice(-2);if(!(e<=i))throw new Error(`bandPart(): numLower (${e}) must not be greater than the number of rows (${i}).`);if(!(n<=a))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${a}).`);e<0&&(e=i),n<0&&(n=a);const o=ar(Yo(0,i,1,"int32"),[-1,1]),l=Yo(0,a,1,"int32"),u=er(o,l),h=Br(Or(u,Xs(+e,"int32")),Lr(u,Xs(-n,"int32"))),c=na([i,a],s.dtype);return ar(ol(ga(ar(s,[-1,i,a])).map((t=>Ur(h,t,c)))),r)}}),Vs({gramSchmidt_:function(t){let e;if(Array.isArray(t)){e=!1,tn(null!=t&&t.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=t[0].shape[0];for(let e=1;e<t.length;++e)tn(t[e].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${t[e].shape[0]} vs. ${n})`))}else e=!0,t=jr(t,t.shape[0],0).map((t=>al(t,[0])));tn(t.length<=t[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${t.length}) exceeds number of dimensions (${t[0].shape[0]}).`));const n=[],s=t;for(let e=0;e<t.length;++e)n.push(Ms.tidy((()=>{let t=s[e];if(e>0)for(let s=0;s<e;++s){const e=js(or(js(n[s],t)),n[s]);t=er(t,e)}return Js(t,mo(t,"euclidean"))})));return e?ol(n,0):n}}),Vs({qr_:function(t,e=!1){if(tn(t.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${t.rank}`)),2===t.rank)return yl(t,e);{const n=t.shape.slice(0,t.shape.length-2).reduce(((t,e)=>t*e)),s=ga(ar(t,[n,t.shape[t.shape.length-2],t.shape[t.shape.length-1]]),0),r=[],i=[];s.forEach((t=>{const[n,s]=yl(t,e);r.push(n),i.push(s)}));return[ar(ol(r,0),t.shape),ar(ol(i,0),t.shape)]}}}),function(t){t[t.NONE=0]="NONE",t[t.MEAN=1]="MEAN",t[t.SUM=2]="SUM",t[t.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS"}(wl||(wl={}));const kl=Vs({computeWeightedLoss_:function(t,e,n=wl.SUM_BY_NONZERO_WEIGHTS){const s=Ws(t,"losses","computeWeightedLoss");let r=null;null!=e&&(r=Ws(e,"weights","computeWeightedLoss"));const i=null==r?s:js(s,r);if(n===wl.NONE)return i;if(n===wl.SUM)return or(i);if(n===wl.MEAN){if(null==r)return $o(i);{const t=s.size/r.size,e=Js(or(i),or(r));return t>1?Js(e,Xs(t)):e}}if(n===wl.SUM_BY_NONZERO_WEIGHTS){if(null==r)return Js(or(i),Xs(s.size));{const t=js(r,sa(s.shape)),e=Ks(or(zo(t,Xs(0))),"float32");return Js(or(i),e)}}throw Error(`Unknown reduction: ${n}`)}});Vs({absoluteDifference_:function(t,e,n,s=wl.SUM_BY_NONZERO_WEIGHTS){const r=Ws(t,"labels","absoluteDifference"),i=Ws(e,"predictions","absoluteDifference");let a=null;null!=n&&(a=Ws(n,"weights","absoluteDifference")),en(r.shape,i.shape,"Error in absoluteDifference: ");const o=Ya(er(r,i));return kl(o,a,s)}}),Vs({cosineDistance_:function(t,e,n,s,r=wl.SUM_BY_NONZERO_WEIGHTS){const i=Ws(t,"labels","cosineDistance"),a=Ws(e,"predictions","cosineDistance");let o=null;null!=s&&(o=Ws(s,"weights","cosineDistance")),en(i.shape,a.shape,"Error in cosineDistance: ");const l=Xs(1),u=er(l,or(js(i,a),n,!0));return kl(u,o,r)}}),Vs({hingeLoss_:function(t,e,n,s=wl.SUM_BY_NONZERO_WEIGHTS){let r=Ws(t,"labels","hingeLoss");const i=Ws(e,"predictions","hingeLoss");let a=null;null!=n&&(a=Ws(n,"weights","hingeLoss")),en(r.shape,i.shape,"Error in hingeLoss: ");const o=Xs(1);r=er(js(Xs(2),r),o);const l=Xo(er(o,js(r,i)));return kl(l,a,s)}}),Vs({huberLoss_:function(t,e,n,s=1,r=wl.SUM_BY_NONZERO_WEIGHTS){const i=Ws(t,"labels","huberLoss"),a=Ws(e,"predictions","huberLoss");let o=null;null!=n&&(o=Ws(n,"weights","huberLoss")),en(i.shape,a.shape,"Error in huberLoss: ");const l=Xs(s),u=Ya(er(a,i)),h=Co(u,l),c=er(u,h),p=fr(js(Xs(.5),tr(h)),js(l,c));return kl(p,o,r)}}),Vs({logLoss_:function(t,e,n,s=1e-7,r=wl.SUM_BY_NONZERO_WEIGHTS){const i=Ws(t,"labels","logLoss"),a=Ws(e,"predictions","logLoss");let o=null;null!=n&&(o=Ws(n,"weights","logLoss")),en(i.shape,a.shape,"Error in logLoss: ");const l=Xs(1),u=Xs(s),h=Zs(js(i,ya(fr(a,u)))),c=js(er(l,i),ya(fr(er(l,a),u))),p=er(h,c);return kl(p,o,r)}}),Vs({meanSquaredError_:function(t,e,n,s=wl.SUM_BY_NONZERO_WEIGHTS){const r=Ws(t,"labels","meanSquaredError"),i=Ws(e,"predictions","meanSquaredError");let a=null;null!=n&&(a=Ws(n,"weights","meanSquaredError")),en(r.shape,i.shape,"Error in meanSquaredError: ");const o=il(r,i);return kl(o,a,s)}}),Vs({sigmoidCrossEntropy_:function(t,e,n,s=0,r=wl.SUM_BY_NONZERO_WEIGHTS){let i=Ws(t,"multiClassLabels","sigmoidCrossEntropy");const a=Ws(e,"logits","sigmoidCrossEntropy");let o=null;if(null!=n&&(o=Ws(n,"weights","sigmoidCrossEntropy")),en(i.shape,a.shape,"Error in sigmoidCrossEntropy: "),s>0){const t=Xs(s),e=Xs(1),n=Xs(.5);i=fr(js(i,er(e,t)),js(n,t))}const l=function(t,e){const n=Ws(t,"labels","sigmoidCrossEntropyWithLogits"),s=Ws(e,"logits","sigmoidCrossEntropyWithLogits");en(n.shape,s.shape,"Error in sigmoidCrossEntropyWithLogits: ");const r=Xo(s),i=js(s,n),a=vo(vi(Zs(Ya(s))));return fr(er(r,i),a)}(i,a);return kl(l,o,r)}}),Vs({softmaxCrossEntropy_:function(t,e,n,s=0,r=wl.SUM_BY_NONZERO_WEIGHTS){let i=Ws(t,"onehotLabels","softmaxCrossEntropy");const a=Ws(e,"logits","softmaxCrossEntropy");let o=null;if(null!=n&&(o=Ws(n,"weights","softmaxCrossEntropy")),en(i.shape,a.shape,"Error in softmaxCrossEntropy: "),s>0){const t=Xs(s),e=Xs(1),n=Xs(i.shape[1]);i=fr(js(i,er(e,t)),Js(t,n))}const l=function(t,e,n=-1){if(-1===n&&(n=e.rank-1),n!==e.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${e.rank} and dim was ${n}`);const s=xo(((t,e,s)=>{const r=No(e,[n],!0),i=er(Ks(e,"float32"),r);s([t,i]);const a=Zs(js(i,t));return{value:or(a,[n]),gradFunc:(t,e)=>{const[s,r]=e,i=ii(t.shape,[n]);return[js(ar(t,i),er(Ks(s,"float32"),vi(r))),js(ar(t,i),er(vi(r),Ks(s,"float32")))]}}}));return s(t,e)}(i,a);return kl(l,o,r)}}),Vs({sparseFillEmptyRows_:function(t,e,n,s){const r=Ws(t,"indices","sparseFillEmptyRows","int32"),i=Ws(e,"values","sparseFillEmptyRows"),a=Ws(n,"denseShape","sparseFillEmptyRows","int32"),o=Ws(s,"defaultValue","sparseFillEmptyRows",i.dtype);if(2!==r.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==i.rank)throw new Error(`Values should be Tensor1D but received shape ${i.shape}`);if(1!==a.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${a.shape}`);if(0!==o.rank)throw new Error(`Default value should be a scalar but received shape ${o.shape}`);const l={indices:r,values:i,denseShape:a,defaultValue:o},u=Ms.runKernel("SparseFillEmptyRows",l);return{outputIndices:u[0],outputValues:u[1],emptyRowIndicator:u[2],reverseIndexMap:u[3]}}}),Vs({sparseReshape_:function(t,e,n){const s=Ws(t,"inputIndices","sparseReshape","int32"),r=Ws(e,"inputShape","sparseReshape","int32"),i=Ws(n,"newShape","sparseReshape","int32");if(2!==s.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==r.rank)throw new Error(`Input shape should be Tensor1D but received shape ${r.shape}`);if(1!==i.rank)throw new Error(`New shape should be Tensor1D but received shape ${i.shape}`);const a={inputIndices:s,inputShape:r,newShape:i},o=Ms.runKernel("SparseReshape",a);return{outputIndices:o[0],outputShape:o[1]}}}),Vs({sparseSegmentMean_:function(t,e,n){const s=Ws(t,"data","sparseSegmentMean"),r=Ws(e,"indices","sparseSegmentMean","int32"),i=Ws(n,"segmentIds","sparseSegmentMean","int32");if(s.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.rank)throw new Error(`Indices should be Tensor1D but received shape\n          ${r.shape}`);if(1!==i.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n          ${i.shape}`);const a={data:s,indices:r,segmentIds:i};return Ms.runKernel("SparseSegmentMean",a)}}),Vs({sparseSegmentSum_:function(t,e,n){const s=Ws(t,"data","sparseSegmentSum"),r=Ws(e,"indices","sparseSegmentSum","int32"),i=Ws(n,"segmentIds","sparseSegmentSum","int32");if(s.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.rank)throw new Error(`Indices should be Tensor1D but received shape\n         ${r.shape}`);if(1!==i.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n         ${i.shape}`);const a={data:s,indices:r,segmentIds:i};return Ms.runKernel("SparseSegmentSum",a)}}),Vs({stringNGrams_:function(t,e,n,s,r,i,a,o){const l=Ws(t,"data","stringNGrams","string");if("string"!==l.dtype)throw new Error("Data must be of datatype string");if(1!==l.shape.length)throw new Error(`Data must be a vector, saw: ${l.shape}`);const u=Ws(e,"dataSplits","stringNGrams");if("int32"!==u.dtype)throw new Error("Data splits must be of datatype int32");const h={separator:n,nGramWidths:s,leftPad:r,rightPad:i,padWidth:a,preserveShortSequences:o},c={data:l,dataSplits:u},p=Ms.runKernel("StringNGrams",c,h);return{nGrams:p[0],nGramsSplits:p[1]}}}),Vs({stringSplit_:function(t,e,n=!0){const s=Ws(t,"input","stringSplit","string"),r=Ws(e,"delimiter","stringSplit","string");if(1!==s.rank)throw new Error(`Input should be Tensor1D but received shape ${s.shape}`);if(0!==r.rank)throw new Error(`Delimiter should be a scalar but received shape ${r.shape}`);const i={skipEmpty:n},a={input:s,delimiter:r},o=Ms.runKernel("StringSplit",a,i);return{indices:o[0],values:o[1],shape:o[2]}}}),Vs({stringToHashBucketFast_:function(t,e){const n=Ws(t,"input","stringToHashBucketFast","string"),s={numBuckets:e};if(e<=0)throw new Error("Number of buckets must be at least 1");const r={input:n};return Ms.runKernel("StringToHashBucketFast",r,s)}});class vl extends class{getClassName(){return this.constructor.className}static fromConfig(t,e){return new t(e)}}{minimize(t,e=!1,n){const{value:s,grads:r}=this.computeGradients(t,n);if(null!=n){const t=n.map((t=>({name:t.name,tensor:r[t.name]})));this.applyGradients(t)}else this.applyGradients(r);return hi(r),e?s:(s.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(t,e){return function(t,e){tn(fn(t),(()=>"The f passed in variableGrads(f) must be a function")),tn(null==e||Array.isArray(e)&&e.every((t=>t instanceof Ss)),(()=>"The varList passed in variableGrads(f, varList) must be an array of variables"));const n=null!=e;if(!n){e=[];for(const t in Ms.registeredVariables)e.push(Ms.registeredVariables[t])}const s=n?e.filter((t=>!t.trainable)):null,r=e.length;tn((e=e.filter((t=>t.trainable))).length>0,(()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${r} variables is trainable.`));const{value:i,grads:a}=Ms.gradients(t,e,null,!0);tn(a.some((t=>null!=t)),(()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize().")),tn(0===i.rank,(()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${i.rank} tensor`));const o={};return e.forEach(((t,e)=>{null!=a[e]&&(o[t.name]=a[e])})),null!=s&&s.forEach((t=>o[t.name]=null)),{value:i,grads:o}}(t,e)}dispose(){null!=this.iterations_&&hi(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:Xs(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(t){throw new Error(`setWeights() is not implemented for this optimizer class ${this.getClassName()}`)}async extractIterations(t){return this.iterations_=(await t[0].tensor.data())[0],t.slice(1)}}Object.defineProperty(vl,Symbol.hasInstance,{value:t=>null!=t.minimize&&null!=t.computeGradients&&null!=t.applyGradients});class xl extends vl{constructor(t,e,n=null){super(),this.learningRate=t,this.rho=e,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=Ms.backend.epsilon())}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ms.registeredVariables[e];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:`${e}/accum_grad`,variable:ui((()=>hr(s).variable(false)))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:`${e}/accum_var`,variable:ui((()=>hr(s).variable(false)))});const r=Array.isArray(t)?t[n].tensor:t[e];if(null==r)return;const i=this.accumulatedGrads[n].variable,a=this.accumulatedUpdates[n].variable;ui((()=>{const t=fr(js(i,this.rho),js(tr(r),1-this.rho)),e=js(Js(Qs(fr(a,this.epsilon)),Qs(fr(i,this.epsilon))),r),n=fr(js(a,this.rho),js(tr(e),1-this.rho));i.assign(t),a.assign(n);const o=fr(js(e,-this.learningRate),s);s.assign(o)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(hi(this.accumulatedGrads.map((t=>t.variable))),hi(this.accumulatedUpdates.map((t=>t.variable))))}async getWeights(){const t=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(t.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){const e=(t=await this.extractIterations(t)).length/2;this.accumulatedGrads=t.slice(0,e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)}))),this.accumulatedUpdates=t.slice(e,2*e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(t,e){return new t(e.learningRate,e.rho,e.epsilon)}}xl.className="Adadelta",Za(xl);class Sl extends vl{constructor(t,e=.1){super(),this.learningRate=t,this.initialAccumulatorValue=e,this.accumulatedGrads=[]}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ms.registeredVariables[e];if(null==this.accumulatedGrads[n]){const t=!1;this.accumulatedGrads[n]={originalName:`${e}/accumulator`,variable:ui((()=>ao(s.shape,this.initialAccumulatorValue).variable(t)))}}const r=Array.isArray(t)?t[n].tensor:t[e];if(null==r)return;const i=this.accumulatedGrads[n].variable;ui((()=>{const t=fr(i,tr(r));i.assign(t);const e=fr(js(Js(r,Qs(fr(t,Ms.backend.epsilon()))),-this.learningRate),s);s.assign(e)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&hi(this.accumulatedGrads.map((t=>t.variable)))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t);this.accumulatedGrads=t.map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(t,e){return new t(e.learningRate,e.initialAccumulatorValue)}}Sl.className="Adagrad",Za(Sl);class Nl extends vl{constructor(t,e,n,s=null){super(),this.learningRate=t,this.beta1=e,this.beta2=n,this.epsilon=s,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],ui((()=>{this.accBeta1=Xs(e).variable(),this.accBeta2=Xs(n).variable()})),null==s&&(this.epsilon=Ms.backend.epsilon())}applyGradients(t){const e=Array.isArray(t)?t.map((t=>t.name)):Object.keys(t);ui((()=>{const n=er(1,this.accBeta1),s=er(1,this.accBeta2);e.forEach(((e,r)=>{const i=Ms.registeredVariables[e];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${e}/m`,variable:ui((()=>hr(i).variable(false)))}),null==this.accumulatedSecondMoment[r]&&(this.accumulatedSecondMoment[r]={originalName:`${e}/v`,variable:ui((()=>hr(i).variable(false)))});const a=Array.isArray(t)?t[r].tensor:t[e];if(null==a)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedSecondMoment[r].variable,u=fr(js(o,this.beta1),js(a,1-this.beta1)),h=fr(js(l,this.beta2),js(tr(a),1-this.beta2)),c=Js(u,n),p=Js(h,s);o.assign(u),l.assign(h);const d=fr(js(Js(c,fr(Qs(p),this.epsilon)),-this.learningRate),i);i.assign(d)})),this.accBeta1.assign(js(this.accBeta1,this.beta1)),this.accBeta2.assign(js(this.accBeta2,this.beta2))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&hi(this.accumulatedFirstMoment.map((t=>t.variable))),null!=this.accumulatedSecondMoment&&hi(this.accumulatedSecondMoment.map((t=>t.variable)))}async getWeights(){const t=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(t.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t),ui((()=>{this.accBeta1.assign(wa(this.beta1,this.iterations_+1)),this.accBeta2.assign(wa(this.beta2,this.iterations_+1))}));const e=t.length/2;this.accumulatedFirstMoment=t.slice(0,e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)}))),this.accumulatedSecondMoment=t.slice(e,2*e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(t,e){return new t(e.learningRate,e.beta1,e.beta2,e.epsilon)}}Nl.className="Adam",Za(Nl);class El extends vl{constructor(t,e,n,s=null,r=0){super(),this.learningRate=t,this.beta1=e,this.beta2=n,this.epsilon=s,this.decay=r,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],ui((()=>{this.iteration=Xs(0).variable(),this.accBeta1=Xs(e).variable()})),null==s&&(this.epsilon=Ms.backend.epsilon())}applyGradients(t){const e=Array.isArray(t)?t.map((t=>t.name)):Object.keys(t);ui((()=>{const n=er(1,this.accBeta1),s=Js(-this.learningRate,fr(js(this.iteration,this.decay),1));e.forEach(((e,r)=>{const i=Ms.registeredVariables[e];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${e}/m`,variable:hr(i).variable(false)}),null==this.accumulatedWeightedInfNorm[r]&&(this.accumulatedWeightedInfNorm[r]={originalName:`${e}/v`,variable:hr(i).variable(false)});const a=Array.isArray(t)?t[r].tensor:t[e];if(null==a)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedWeightedInfNorm[r].variable,u=fr(js(o,this.beta1),js(a,1-this.beta1)),h=js(l,this.beta2),c=Ya(a),p=To(h,c);o.assign(u),l.assign(p);const d=fr(js(Js(s,n),Js(u,fr(p,this.epsilon))),i);i.assign(d)})),this.iteration.assign(fr(this.iteration,1)),this.accBeta1.assign(js(this.accBeta1,this.beta1))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&hi(this.accumulatedFirstMoment.map((t=>t.variable))),null!=this.accumulatedWeightedInfNorm&&hi(this.accumulatedWeightedInfNorm.map((t=>t.variable)))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(t){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(t,e){return new t(e.learningRate,e.beta1,e.beta2,e.epsilon,e.decay)}}El.className="Adamax",Za(El);class Il extends vl{constructor(t){super(),this.learningRate=t,this.setLearningRate(t)}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Array.isArray(t)?t[n].tensor:t[e];if(null==s)return;const r=Ms.registeredVariables[e];ui((()=>{const t=fr(js(this.c,s),r);r.assign(t)}))})),this.incrementIterations()}setLearningRate(t){var e;this.learningRate=t,null!=this.c&&this.c.dispose(),this.c=(e=Xs(-t),Ms.keep(e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(t){if(0!==(t=await this.extractIterations(t)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(t,e){return new t(e.learningRate)}}Il.className="SGD",Za(Il);class Al extends Il{constructor(t,e,n=!1){super(t),this.learningRate=t,this.momentum=e,this.useNesterov=n,this.accumulations=[],this.m=Xs(this.momentum)}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ms.registeredVariables[e];if(null==this.accumulations[n]){const t=!1;this.accumulations[n]={originalName:`${e}/momentum`,variable:ui((()=>hr(s).variable(t)))}}const r=this.accumulations[n].variable,i=Array.isArray(t)?t[n].tensor:t[e];null!=i&&ui((()=>{let t;const e=fr(js(this.m,r),i);t=this.useNesterov?fr(js(this.c,fr(i,js(e,this.m))),s):fr(js(this.c,e),s),r.assign(e),s.assign(t)}))})),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&hi(this.accumulations.map((t=>t.variable)))}setMomentum(t){this.momentum=t}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t);this.accumulations=t.map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(t,e){return new t(e.learningRate,e.momentum,e.useNesterov)}}Al.className="Momentum",Za(Al);class Tl extends vl{constructor(t,e=.9,n=0,s=null,r=!1){if(super(),this.learningRate=t,this.decay=e,this.momentum=n,this.epsilon=s,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=r,null==s&&(this.epsilon=Ms.backend.epsilon()),null==t)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ms.registeredVariables[e],r=!1;null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:`${e}/rms`,variable:ui((()=>hr(s).variable(r)))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:`${e}/momentum`,variable:ui((()=>hr(s).variable(r)))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:`${e}/mg`,variable:ui((()=>hr(s).variable(r)))});const i=Array.isArray(t)?t[n].tensor:t[e];if(null==i)return;const a=this.accumulatedMeanSquares[n].variable,o=this.accumulatedMoments[n].variable;ui((()=>{const t=fr(js(a,this.decay),js(tr(i),1-this.decay));if(this.centered){const e=this.accumulatedMeanGrads[n].variable,r=fr(js(e,this.decay),js(i,1-this.decay)),l=Js(js(i,this.learningRate),Qs(er(t,fr(tr(r),this.epsilon)))),u=fr(js(o,this.momentum),l);a.assign(t),e.assign(r),o.assign(u);const h=er(s,u);s.assign(h)}else{const t=fr(js(a,this.decay),js(tr(i),1-this.decay)),e=fr(js(o,this.momentum),Js(js(i,this.learningRate),Qs(fr(t,this.epsilon))));a.assign(t),o.assign(e);const n=er(s,e);s.assign(n)}}))})),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&hi(this.accumulatedMeanSquares.map((t=>t.variable))),null!=this.accumulatedMeanGrads&&this.centered&&hi(this.accumulatedMeanGrads.map((t=>t.variable))),null!=this.accumulatedMoments&&hi(this.accumulatedMoments.map((t=>t.variable)))}async getWeights(){const t=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&t.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(t.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t);const e=this.centered?t.length/3:t.length/2,n=!1;this.accumulatedMeanSquares=t.slice(0,e).map((t=>({originalName:t.name,variable:t.tensor.variable(n)}))),this.accumulatedMoments=t.slice(e,2*e).map((t=>({originalName:t.name,variable:t.tensor.variable(n)}))),this.centered&&(this.accumulatedMeanGrads=t.slice(2*e,3*e).map((t=>({originalName:t.name,variable:t.tensor.variable(n)}))))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(t,e){return new t(e.learningRate,e.decay,e.momentum,e.epsilon,e.centered)}}var $l;Tl.className="RMSProp",Za(Tl),"undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate&&setImmediate,function(t){t[t.FIRST_DIM_SIZE=0]="FIRST_DIM_SIZE",t[t.VALUE_ROWIDS=1]="VALUE_ROWIDS",t[t.ROW_LENGTHS=2]="ROW_LENGTHS",t[t.ROW_SPLITS=3]="ROW_SPLITS",t[t.ROW_LIMITS=4]="ROW_LIMITS",t[t.ROW_STARTS=5]="ROW_STARTS"}($l||($l={}));function Cl(t,e,n){const s=t.shape.length,r=s-n.length,i=ai(n,s);let a=t;null!=i&&(a=fi(t,i));const o=a.shape.slice(),l=o.splice(s-n.length,n.length).reduce(((t,e)=>t*e),1);o.push(l);let u=function(t,e,n){const s=t.shape.slice();s[n]=1;const r=ar(e,s),i=uo(t,n,!0,!1),a=uo(t,n,!0,!0),o=js(i,a);return js(r,o)}(a.reshape(o),e,r);if(u=u.reshape(a.shape),null!=i){const t=oi(i);u=fi(u,t)}return u}const zl={kernelName:"SpaceToBatchND",gradFunc:(t,e,n)=>{const{blockShape:s,paddings:r}=n;return{x:()=>no(t,s,r)}}},_l={kernelName:"SplitV",gradFunc:(t,e,n)=>{const{axis:s}=n;return{x:()=>Qa(t,s)}}};const Dl=[Gs,nr,sr,lr,ur,cr,pr,dr,gr,mr,br,yr,Ar,$r,zr,Dr,Fr,Rr,Mr,Vr,Kr,qr,Yr,Jr,ti,ni,ri,gi,yi,wi,{kernelName:"RealDiv",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=ir(n.shape,s.shape);return{a:()=>{const e=Js(t,Ks(s,"float32")),i=rr(n.shape,r);return i.length>0?ar(or(e,i),n.shape):e},b:()=>{let e=js(t,Ks(n,"float32"));const i=rr(s.shape,r);i.length>0&&(e=ar(or(e,i),s.shape));const a=tr(s);return Zs(Js(e,Ks(a,"float32")))}}}},ki,xi,Si,Ni,Ei,Ai,Ii,Ci,_i,Ri,Mi,Li,Oi,Bi,Wi,Ui,Vi,Ki,qi,Ji,Ji,Yi,Qi,ea,ra,ia,aa,la,ha,ca,pa,da,fa,ma,ba,ba,ka,va,{kernelName:"Prod",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n;let i=[];return i=null==r?s.shape.map(((t,e)=>e)):"number"==typeof r?[r]:r,{x:()=>Cl(s,t,i)}}},{kernelName:"Reciprocal",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Js(t,Zs(tr(n)))}}},{kernelName:"Relu6",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e,s=js(Or(n,6),qs(n));return{x:()=>js(t,Ks(s,"float32"))}}},{kernelName:"Relu",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>js(t,Ks(qs(n),"float32"))}}},{kernelName:"Reshape",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>ar(t,n.shape)}}},{kernelName:"ResizeBilinear",inputsToSave:["images"],gradFunc:(t,e,n)=>{const[s]=e,r={dy:t,images:s};return{images:()=>Ms.runKernel("ResizeBilinearGrad",r,n)}}},{kernelName:"ResizeNearestNeighbor",inputsToSave:["images"],gradFunc:(t,e,n)=>{const[s]=e,r={dy:t,images:s};return{images:()=>Ms.runKernel("ResizeNearestNeighborGrad",r,n)}}},{kernelName:"Reverse",gradFunc:(t,e,n)=>{const{dims:s}=n,r=un(s,t.shape);return{x:()=>tl(t,r)}}},{kernelName:"Round",gradFunc:t=>({x:()=>hr(t)})},{kernelName:"Rsqrt",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Zs(Js(t,js(wa(n,1.5),2)))}}},{kernelName:"Select",inputsToSave:["condition"],gradFunc:(t,e)=>{const[n]=e;return{condition:()=>Ks(hr(n),"float32"),t:()=>js(t,Ks(n,t.dtype)),e:()=>js(t,Ks(Eo(n),t.dtype))}}},{kernelName:"Selu",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Pi(n,Xs(0)),s=Xs(1.7580993408473768),r=Xs(1.0507009873554805),i=js(t,r),a=js(js(t,s),vi(Ks(n,"float32")));return Ur(e,i,a)}}}},{kernelName:"Sigmoid",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>js(t,js(n,er(Xs(1),n)))}}},{kernelName:"Sign",gradFunc:t=>({x:()=>hr(t)})},{kernelName:"Sin",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>js(oo(Ks(n,"float32")),t)}}},{kernelName:"Sinh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>js(lo(Ks(n,"float32")),t)}}},{kernelName:"Slice",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{begin:r,size:i}=n,a=s.shape,[o,l]=function(t,e,n){let s;const r=t.shape.length;let i;return s="number"==typeof e?[e,...new Array(r-1).fill(0)]:e.length<r?e.concat(new Array(r-e.length).fill(0)):e.slice(),s.forEach((t=>{tn(-1!==t,(()=>"slice() does not support negative begin indexing."))})),i=null==n?new Array(r).fill(-1):"number"==typeof n?[n,...new Array(r-1).fill(-1)]:n.length<r?n.concat(new Array(r-n.length).fill(-1)):n,i=i.map(((e,n)=>e>=0?e:(tn(-1===e,(()=>`Negative size values should be exactly -1 but got ${e} for the slice() size at index ${n}.`)),t.shape[n]-s[n]))),[s,i]}(s,r,i),u=[];for(let e=0;e<t.rank;e++)u.push([o[e],a[e]-o[e]-l[e]]);return{x:()=>_o(t,u)}}},{kernelName:"Softmax",outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s]=e,{dim:r}=n,i=js(t,s);return{logits:()=>er(i,js(or(i,[r],true),s))}}},{kernelName:"Softplus",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>js(t,to(n))}}},zl,zl,_l,_l,{kernelName:"Sqrt",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Js(t,js(Qs(Ks(n,"float32")),2))}}},{kernelName:"SquaredDifference",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Xs(2);return{a:()=>js(t,js(r,er(n,s))),b:()=>js(t,js(r,er(s,n)))}}},{kernelName:"Square",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>js(t,js(Ks(n,"float32"),2))}}},{kernelName:"Step",gradFunc:t=>({x:()=>hr(t)})},{kernelName:"Sub",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=ir(n.shape,s.shape);return{a:()=>{let e=t;const s=rr(n.shape,r);return s.length>0&&(e=or(e,s)),ar(e,n.shape)},b:()=>{let e=t;const n=rr(s.shape,r);return n.length>0&&(e=or(e,n)),ar(Zs(e),s.shape)}}}},{kernelName:"Sum",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,r=s.shape.slice(),{axis:i}=n;un(i,s.shape).forEach((t=>{r[t]=1}));const a=ar(t,r),o=js(a,sa(s.shape,"float32"));return{x:()=>o}}},{kernelName:"Tan",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Js(t,tr(oo(n)))}}},{kernelName:"Tanh",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>js(er(Xs(1),tr(n)),t)}}},{kernelName:"Tile",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{reps:r}=n;return{x:()=>{let e=hr(s);if(1===s.rank)for(let n=0;n<r[0];++n)e=fr(e,oa(t,[n*s.shape[0]],[s.shape[0]]));else if(2===s.rank)for(let n=0;n<r[0];++n)for(let i=0;i<r[1];++i)e=fr(e,oa(t,[n*s.shape[0],i*s.shape[1]],[s.shape[0],s.shape[1]]));else if(3===s.rank)for(let n=0;n<r[0];++n)for(let i=0;i<r[1];++i)for(let a=0;a<r[2];++a)e=fr(e,oa(t,[n*s.shape[0],i*s.shape[1],a*s.shape[2]],[s.shape[0],s.shape[1],s.shape[2]]));else{if(4!==s.rank)throw new Error(`Gradient for tile operation is not implemented for rank-${s.rank} tensors yet.`);for(let n=0;n<r[0];++n)for(let i=0;i<r[1];++i)for(let a=0;a<r[2];++a)for(let o=0;o<r[3];++o)e=fr(e,oa(t,[n*s.shape[0],i*s.shape[1],a*s.shape[2],o*s.shape[3]],[s.shape[0],s.shape[1],s.shape[2],s.shape[3]]))}return e}}}},{kernelName:"Transpose",gradFunc:(t,e,n)=>{const s=n,{perm:r}=s,i=oi(r);return{x:()=>fi(t,i)}}},{kernelName:"Unpack",gradFunc:(t,e,n)=>{const s=n,{axis:r}=s;return{value:()=>ol(t,r)}}},{kernelName:"UnsortedSegmentSum",inputsToSave:["segmentIds"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>function(t,e){const n=To(e,hr(e)),s=wo(t,n);let r=Lr(e,Xs(0,"int32"));const i=s.rank-r.rank;for(let t=0;t<i;++t)r=bo(r,t+1);r=Br(r,sa(s.shape,"bool"));const a=hr(s);return Ur(r,s,a)}(t,n)}}},{kernelName:"ZerosLike",gradFunc:t=>({x:()=>hr(t)})}];for(const t of Dl)Rn(t);function Fl(e,n){return s((()=>t.sqrt(t.sum(t.mul(e,e),n,!0))))}class Rl extends i.Serializable{getConfig(){return{}}}class Ml extends Rl{constructor(t){super(),this.defaultMaxValue=2,this.defaultAxis=0,this.maxValue=null!=t.maxValue?t.maxValue:this.defaultMaxValue,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(e){return s((()=>{const n=Fl(e,this.axis),s=t.clipByValue(n,0,this.maxValue);return t.mul(e,t.div(s,t.add(Kt(),n)))}))}getConfig(){return{maxValue:this.maxValue,axis:this.axis}}}Ml.className="MaxNorm",i.registerClass(Ml);class Ll extends Rl{constructor(t){super(),this.defaultAxis=0,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(e){return s((()=>t.div(e,t.add(Kt(),Fl(e,this.axis)))))}getConfig(){return{axis:this.axis}}}Ll.className="UnitNorm",i.registerClass(Ll);class Ol extends Rl{apply(e){return t.relu(e)}}Ol.className="NonNeg",i.registerClass(Ol);class Bl extends Rl{constructor(t){super(),this.defaultMinValue=0,this.defaultMaxValue=1,this.defaultRate=1,this.defaultAxis=0,this.minValue=null!=t.minValue?t.minValue:this.defaultMinValue,this.maxValue=null!=t.maxValue?t.maxValue:this.defaultMaxValue,this.rate=null!=t.rate?t.rate:this.defaultRate,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(e){return s((()=>{const n=Fl(e,this.axis),s=t.add(t.mul(this.rate,t.clipByValue(n,this.minValue,this.maxValue)),t.mul(1-this.rate,n));return t.mul(e,t.div(s,t.add(Kt(),n)))}))}getConfig(){return{minValue:this.minValue,maxValue:this.maxValue,rate:this.rate,axis:this.axis}}}Bl.className="MinMaxNorm",i.registerClass(Bl);const Pl={maxNorm:"MaxNorm",minMaxNorm:"MinMaxNorm",nonNeg:"NonNeg",unitNorm:"UnitNorm"};function Wl(t){return ut(t)}function Ul(t,e={}){return ct(t,i.SerializationMap.getMap().classNameMap,e,"constraint")}function Vl(t){if(null==t)return null;if("string"==typeof t){return Ul({className:t in Pl?Pl[t]:t,config:{}})}return t instanceof Rl?t:Ul(t)}var Kl={__proto__:null,maxNorm:function(t){return new Ml(t)},unitNorm:function(t){return new Ll(t)},nonNeg:function(){return new Ol},minMaxNorm:function(t){return new Bl(t)}};var jl,ql={__proto__:null,zeros:function(){return new he},ones:function(){return new ce},constant:function(t){return new pe(t)},randomUniform:function(t){return new de(t)},randomNormal:function(t){return new fe(t)},truncatedNormal:function(t){return new ge(t)},identity:function(t){return new me(t)},varianceScaling:function(t){return new be(t)},glorotUniform:function(t){return new ye(t)},glorotNormal:function(t){return new we(t)},heNormal:function(t){return new ke(t)},heUniform:function(t){return new ve(t)},leCunNormal:function(t){return new xe(t)},leCunUniform:function(t){return new Se(t)},orthogonal:function(t){return new Ne(t)}};async function Gl(t){if(null==t)return;const e=[],n=[],s=[];for(const r in t){const i=t[r];if("number"!=typeof i){const t=i;e.push(t.data()),n.push(r),s.push(t)}}if(e.length>0){const r=await Promise.all(e);for(let e=0;e<r.length;++e)t[n[e]]=r[e][0];g(s)}}function Hl(t){if(null!=t)for(const e in t){const n=t[e];"number"!=typeof n&&n.dispose()}}!function(t){t[t.SILENT=0]="SILENT",t[t.VERBOSE=1]="VERBOSE"}(jl||(jl={}));class Jl{constructor(){this.validationData=null}setParams(t){this.params=t}async onEpochBegin(t,e){}async onEpochEnd(t,e){}async onBatchBegin(t,e){}async onBatchEnd(t,e){}async onTrainBegin(t){}async onTrainEnd(t){}setModel(t){}}class Zl{constructor(t,e=10){null==t&&(t=[]),this.callbacks=t,this.queueLength=e}append(t){this.callbacks.push(t)}setParams(t){for(const e of this.callbacks)e.setParams(t)}setModel(t){for(const e of this.callbacks)e.setModel(t)}async onEpochBegin(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onEpochBegin(t,e)}async onEpochEnd(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onEpochEnd(t,e)}async onBatchBegin(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onBatchBegin(t,e)}async onBatchEnd(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onBatchEnd(t,e)}async onTrainBegin(t){null==t&&(t={});for(const e of this.callbacks)await e.onTrainBegin(t)}async onTrainEnd(t){null==t&&(t={});for(const e of this.callbacks)await e.onTrainEnd(t)}}class Yl extends Jl{constructor(){super()}async onEpochBegin(t){this.seen=0,this.totals={}}async onBatchEnd(t,e){null==e&&(e={});const n=null==e.size?0:e.size;this.seen+=n;for(const t in e){const r=e[t];if("number"==typeof r)this.totals.hasOwnProperty(t)||(this.totals[t]=0),this.totals[t]=this.totals[t]+r*n;else{let e;t in this.totals?e=this.totals[t]:this.totals[t]=0;const i=s((()=>k(this.totals[t],l(r,n))));this.totals[t]=i,null!=e&&e.dispose()}}}async onEpochEnd(t,e){if(null!=e)for(const t of this.params.metrics)null!=this.totals[t]&&("number"==typeof this.totals[t]?e[t]=this.totals[t]/this.seen:s((()=>{const n=l(v(1,this.seen),this.totals[t]);e[t]=n,this.totals[t].dispose(),x(e[t])})))}}class Xl extends Jl{async onTrainBegin(t){this.epoch=[],this.history={}}async onEpochEnd(t,e){null==e&&(e={}),this.epoch.push(t);for(const t in e)null==this.history[t]&&(this.history[t]=[]),this.history[t].push(e[t])}async syncData(){const t=[],e=[],n=[];for(const s in this.history){const r=this.history[s];for(let i=0;i<r.length;++i)if("number"!=typeof r[i]){const a=r[i];t.push(a.data()),e.push(s),n.push(i)}}const s=await Promise.all(t);for(let t=0;t<s.length;++t){this.history[e[t]][n[t]].dispose(),this.history[e[t]][n[t]]=s[t][0]}}}class Ql extends Jl{constructor(t,n){if(super(),this.currentEpoch=0,this.nowFunc=t.nowFunc,this.nextFrameFunc=t.nextFrameFunc||w,this.yieldEvery=n||"auto","auto"===this.yieldEvery&&(this.yieldEvery=125),"never"===this.yieldEvery&&null!=t.onYield)throw new Error("yieldEvery is `never` but you provided an `onYield` callback. Either change `yieldEvery` or remove the callback");e.isNumber(this.yieldEvery)&&(this.maybeWait=function(t,n,s){let r,i=null!=s?s():e.now();return(...a)=>{const o=null!=s?s():e.now();return o-i<n||(i=o,r=t(...a)),r}}(this.maybeWait.bind(this),this.yieldEvery,this.nowFunc)),this.trainBegin=t.onTrainBegin,this.trainEnd=t.onTrainEnd,this.epochBegin=t.onEpochBegin,this.epochEnd=t.onEpochEnd,this.batchBegin=t.onBatchBegin,this.batchEnd=t.onBatchEnd,this.yield=t.onYield}async maybeWait(t,e,n){const s=[];null!=this.yield&&(await Gl(n),s.push(this.yield(t,e,n))),s.push(this.nextFrameFunc()),await Promise.all(s)}async onEpochBegin(t,e){this.currentEpoch=t,null!=this.epochBegin&&(await Gl(e),await this.epochBegin(t,e))}async onEpochEnd(t,e){const n=[];null!=this.epochEnd&&(await Gl(e),n.push(this.epochEnd(t,e))),"epoch"===this.yieldEvery&&n.push(this.nextFrameFunc()),await Promise.all(n)}async onBatchBegin(t,e){null!=this.batchBegin&&(await Gl(e),await this.batchBegin(t,e))}async onBatchEnd(t,n){const s=[];null!=this.batchEnd&&(await Gl(n),s.push(this.batchEnd(t,n))),"batch"===this.yieldEvery?s.push(this.nextFrameFunc()):e.isNumber(this.yieldEvery)&&s.push(this.maybeWait(this.currentEpoch,t,n)),await Promise.all(s)}async onTrainBegin(t){null!=this.trainBegin&&(await Gl(t),await this.trainBegin(t))}async onTrainEnd(t){null!=this.trainEnd&&(await Gl(t),await this.trainEnd(t))}}function tu(t,e){if(null==t&&(t={}),t instanceof Jl)return[t];if(Array.isArray(t)&&t[0]instanceof Jl)return t;return it(t).map((t=>new Ql(t,e)))}class eu{constructor(){}static registerCallbackConstructor(t,n){e.assert(t>=0&&Number.isInteger(t),(()=>`Verbosity level is expected to be an integer >= 0, but got ${t}`)),eu.checkForDuplicate(n),null==eu.constructors[t]&&(eu.constructors[t]=[]),eu.constructors[t].push(n)}static checkForDuplicate(t){for(const e in eu.constructors){eu.constructors[+e].forEach((e=>{if(e===t)throw new Y("Duplicate callback constructor.")}))}}static clear(){eu.constructors={}}static createCallbacks(t){const e=[];for(const n in eu.constructors){const s=+n;t>=s&&e.push(...eu.constructors[s])}return e.map((t=>new t))}}function nu(t,e,n,s,r,i,a,o,l){const u=new Xl,h=[new Yl,...eu.createCallbacks(e)];null!=t&&h.push(...t),h.push(u);const c=new Zl(h);return c.setParams({epochs:n,initialEpoch:s,samples:r,steps:i,batchSize:a,verbose:e,doValidation:o,metrics:l}),{callbackList:c,history:u}}function su(t,e={},n=!1){return ct(t,i.SerializationMap.getMap().classNameMap,e,"layer",n)}function ru(e,n){return s((()=>{"float32"!==e.dtype&&(e=t.cast(e,"float32"));const s=t.sum(ne(e),n,!0),r=t.fill(s.shape,Kt()),i=t.sqrt(t.maximum(s,r));return t.div(e,i)}))}function iu(e,n){return s((()=>t.mean(ne(t.sub(n,e)),-1)))}function au(e,n){return s((()=>t.mean(t.abs(t.sub(n,e)),-1)))}function ou(e,n){return s((()=>{const s=t.sub(e,n),r=t.clipByValue(t.abs(e),Kt(),Number.MAX_VALUE),i=t.abs(t.div(s,r));return t.mul(100,t.mean(i,-1))}))}function lu(e,n,r=!1){return s((()=>{if(r)n=t.softmax(n);else{const e=t.sum(n,n.shape.length-1,!0);n=t.div(n,e)}return n=t.clipByValue(n,Kt(),1-Kt()),t.neg(t.sum(t.mul(t.cast(e,"float32"),t.log(n)),n.shape.length-1))}))}function uu(e,n,r=!1){return s((()=>{const s=t.cast(t.floor(function(e){const n=[Bt(e.shape)];return t.reshape(e,n)}(e)),"int32"),i=(n=t.clipByValue(n,Kt(),1-Kt())).shape;return lu(t.reshape(t.oneHot(s,i[i.length-1]),i),n,r)}))}function hu(n,r){return s((()=>{let i;return i=t.clipByValue(r,Kt(),1-Kt()),i=t.log(t.div(i,t.sub(1,i))),t.mean(function(n,r){if(!e.arraysEqual(n.shape,r.shape))throw new Y(`logits and labels must have the same shape, but got shapes ${JSON.stringify(n.shape)} and ${JSON.stringify(r.shape)}`);return s((()=>{const e=t.relu(r),s=t.neg(t.abs(r));return t.add(t.sub(e,t.mul(r,n)),t.log1p(t.exp(s)))}))}(n,i),-1)}))}function cu(e,n){return s((()=>{const s=ru(e,-1),r=ru(n,-1),i=t.mul(s,r);return t.neg(t.sum(i,-1))}))}eu.constructors={};const pu={meanSquaredError:iu,meanAbsoluteError:au,meanAbsolutePercentageError:ou,meanSquaredLogarithmicError:function(e,n){return s((()=>{const s=t.clipByValue(n,Kt(),Number.MAX_VALUE),r=t.log(t.add(1,s)),i=t.clipByValue(e,Kt(),Number.MAX_VALUE),a=t.log(t.add(1,i));return t.mean(ne(t.sub(r,a)),-1)}))},squaredHinge:function(e,n){return s((()=>{const s=t.maximum(0,t.sub(1,t.mul(e,n)));return t.mean(ne(s),-1)}))},hinge:function(e,n){return s((()=>{const s=t.maximum(0,t.sub(1,t.mul(e,n)));return t.mean(s,-1)}))},categoricalHinge:function(e,n){return s((()=>{const s=t.sum(t.mul(e,n),-1),r=t.max(t.mul(t.sub(1,e),n),-1);return t.maximum(0,t.add(1,t.sub(r,s)))}))},logcosh:function(e,n){return s((()=>{const s=Math.log(2),r=t.sub(n,e),i=t.sub(t.add(r,t.softplus(t.mul(-2,r))),s);return t.mean(i,-1)}))},categoricalCrossentropy:lu,sparseCategoricalCrossentropy:uu,binaryCrossentropy:hu,kullbackLeiblerDivergence:function(e,n){return s((()=>{const s=t.clipByValue(e,Kt(),1),r=t.clipByValue(n,Kt(),1);return t.sum(t.mul(e,t.log(t.div(s,r))),-1)}))},poisson:function(e,n){return s((()=>{const s=t.log(t.add(Kt(),n));return t.mean(t.sub(n,t.mul(e,s)),-1)}))},cosineProximity:cu};function du(t){if("string"==typeof t){if(t in pu)return pu[t];let e=`Unknown loss ${t}`;throw t.toLowerCase().includes("softmaxcrossentropy")&&(e=`Unknown loss ${t}. Use "categoricalCrossentropy" as the string name for tf.losses.softmaxCrossEntropy`),new Y(e)}return t}function fu(e,n){return s((()=>{const s=t.mul(.5,t.onesLike(n)),r=jt(t.greater(n,s),e.dtype);return t.mean(t.equal(e,r),-1)}))}function gu(e,n){return s((()=>jt(t.equal(t.argMax(e,-1),t.argMax(n,-1)),"float32")))}function mu(e,n){return s((()=>t.cast(t.sum(t.logicalAnd(t.equal(e,1),t.equal(n,1))),"float32")))}function bu(e,n){return s((()=>{const r=mu(e,n),i=function(e,n){return s((()=>t.cast(t.sum(t.logicalAnd(t.equal(e,0),t.equal(n,1))),"float32")))}(e,n),a=t.add(r,i);return t.cast(t.where(t.greater(a,0),t.div(r,a),0),"float32")}))}function yu(e,n){return s((()=>{const r=mu(e,n),i=function(e,n){return s((()=>t.cast(t.sum(t.logicalAnd(t.equal(e,1),t.equal(n,0))),"float32")))}(e,n),a=t.add(r,i);return t.cast(t.where(t.greater(a,0),t.div(r,a),0),"float32")}))}function wu(t,e){return hu(t,e)}function ku(e,n){return e.rank===n.rank&&(e=t.squeeze(e,[e.rank-1])),(n=t.argMax(n,-1)).dtype!==e.dtype&&(n=t.cast(n,e.dtype)),t.cast(t.equal(e,n),"float32")}const vu=lu,xu=uu,Su={binaryAccuracy:fu,categoricalAccuracy:gu,precision:bu,categoricalCrossentropy:vu,sparseCategoricalCrossentropy:xu,mse:iu,MSE:iu,mae:au,MAE:au,mape:ou,MAPE:ou,cosine:cu};function Nu(t){if("string"==typeof t&&t in Su)return Su[t];if("string"!=typeof t&&null!=t)return t;throw new Y(`Unknown metric ${t}`)}function Eu(t){if(nt(null!==t,`Unknown LossOrMetricFn ${t}`),"string"==typeof t)return t;{let e;for(const n of Object.keys(pu))if(pu[n]===t){e=n;break}if(void 0!==e)return e;for(const n of Object.keys(Su))if(Su[n]===t){e=n;break}return void 0!==e?e:t.name}}function Iu(t,e,n=!1){if(null==t||"object"!=typeof t||Object.getPrototypeOf(t)!==Object.prototype||!Au(t))throw new Error("User-defined metadata is expected to be a JSON object, but is not.");if(n){const n=JSON.stringify(t);n.length>1048576&&console.warn(`User-defined metadata of model "${e}" is too large in size (length=${n.length} when serialized). It is not recommended to store such large objects in user-defined metadata. Please make sure its serialized length is <= 1048576.`)}}function Au(t){if(null===t)return!0;if("object"==typeof t){if(Object.getPrototypeOf(t)===Object.prototype){const e=Object.keys(t);for(const n of e){if("string"!=typeof n)return!1;if(!Au(t[n]))return!1}return!0}if(Array.isArray(t)){for(const e of t)if(!Au(e))return!1;return!0}return!1}{const e=typeof t;return"string"===e||"number"===e||"boolean"===e}}function Tu(t,e,n,s=console.log){const r=function(t){let e=!0;const n=[],s=[];for(const e in t.nodesByDepth)n.push(t.nodesByDepth[e]);for(const t of n){if(t.length>1||1===t.length&&t[0].inboundLayers.length>1){e=!1;break}s.push(...t)}if(e)for(const n of t.layers){let t=!1;for(const r of n.inboundNodes)if(-1!==s.indexOf(r)){if(t){e=!1;break}t=!0}if(!e)break}return e}(t),i=["Layer (type)","Input Shape","Output shape","Param #"];let a;if(r?(e=e||90,n=n||[.32,.61,.89,1]):(e=e||115,n=n||[.24,.48,.7,.8,1]),n[n.length-1]<=1&&(n=n.map((t=>Math.floor(e*t)))),!r){i.push("Receives inputs"),a=[];for(const e in t.nodesByDepth)a.push(...t.nodesByDepth[e])}s("_".repeat(e)),$u(i,n,s),s("=".repeat(e));const o=t.layers;for(let t=0;t<o.length;++t)r?Cu(o[t],n,s):zu(o[t],n,a,s),s((t===o.length-1?"=":"_").repeat(e));t.checkTrainableWeightsConsistency();const l=function(t){let e;e=null!=t.collectedTrainableWeights?De(t.collectedTrainableWeights):De(t.trainableWeights);return e}(t),u=De(t.nonTrainableWeights);s(`Total params: ${l+u}`),s(`Trainable params: ${l}`),s(`Non-trainable params: ${u}`),s("_".repeat(e))}function $u(t,e,n=console.log){let s="";for(let n=0;n<t.length;++n)n>0&&(s=s.slice(0,s.length-1)+" "),s+=t[n],s=s.slice(0,e[n]),s+=" ".repeat(e[n]-s.length);n(s)}function Cu(t,e,n){let s,r;try{r=t.inboundNodes.map((t=>JSON.stringify(t.inputShapes))).join(",")}catch(t){r="multiple"}try{s=JSON.stringify(t.outputShape)}catch(t){s="multiple"}$u([`${t.name} (${t.getClassName()})`,r,s,t.countParams().toString()],e,n)}function zu(t,e,n,s){let r,i;try{i=t.inboundNodes.map((t=>JSON.stringify(t.inputShapes))).join(",")}catch(t){i="multiple"}try{r=JSON.stringify(t.outputShape)}catch(t){r="multiple"}const a=[];for(const e of t.inboundNodes)if(!(null!=n&&n.length>0&&-1===n.indexOf(e)))for(let t=0;t<e.inboundLayers.length;++t){const n=e.inboundLayers[t].name,s=e.nodeIndices[t],r=e.tensorIndices[t];a.push(`${n}[${s}][${r}]`)}const o=t.name,l=t.getClassName(),u=0===a.length?"":a[0];$u([`${o} (${l})`,i,r,t.countParams().toString(),u],e,s);for(let t=1;t<a.length;++t)$u(["","","","",a[t]],e,s)}function _u(t,e,n){return("inboundNodes"===t||"outputLayers"===t||"inputLayers"===t)&&0===e&&"string"==typeof n}function Du(t,e){if(null===t)return null;if("string"==typeof t)return ot(t);if("number"==typeof t||"boolean"==typeof t)return t;if(t instanceof Array){const n=[],s=t.length;for(let r=0;r<s;++r){const s=t[r];_u(e,r,s)?n.push(s):n.push(Du(s,e))}return n}{const e={};for(const n of Object.keys(t)){const s=t[n];if("name"===n&&"string"==typeof s)e[n]=s;else{const t=ot(n);e[t]=Du(s,t)}}return e}}function Fu(t,e){if(null==t)return null;if("string"==typeof t)return at(t);if("number"==typeof t||"boolean"==typeof t)return t;if(t instanceof Array){const n=[],s=t.length;for(let r=0;r<s;++r){const s=t[r];_u(e,r,s)?n.push(s):n.push(Fu(s,e))}return n}{const e={};for(const n of Object.keys(t)){const s=t[n],r=at(n);e[r]="name"!==n&&"className"!==n||"string"!=typeof s?Fu(s,n):s}return e}}const Ru="4.0.0";class Mu extends Ue{constructor(t){if(super({}),this.containerNodes=new Set,this.name=t.name,null==this.name){const t=this.getClassName().toLowerCase();this.name=St(t)}if(this.supportsMasking=!1,this.trainable_=!0,Array.isArray(t.inputs)?this.inputs=t.inputs.slice():this.inputs=[t.inputs],Array.isArray(t.outputs)?this.outputs=t.outputs.slice():this.outputs=[t.outputs],dt(this.inputs).length!==this.inputs.length)throw new Y(`The list of inputs passed to the model is redundant. All inputs should only appear once. Found: ${this.inputs.map((t=>t.name))}`);dt(this.outputs).length!==this.outputs.length&&console.warn(`The list of outputs passed to the model is redundant. All outputs should only appear once. Found: ${this.outputs.map((t=>t.name))}`),this.inputLayers=[],this.inputLayersNodeIndices=[],this.inputLayersTensorIndices=[],this.outputLayers=[],this.outputLayersNodeIndices=[],this.outputLayersTensorIndices=[],this.layers=[],this.internalContainerRefs=[];for(const t of this.outputs){const e=t.sourceLayer,n=t.nodeIndex,s=t.tensorIndex;this.outputLayers.push(e),this.outputLayersNodeIndices.push(n),this.outputLayersTensorIndices.push(s)}for(const t of this.inputs){const e=t.sourceLayer,n=t.nodeIndex,s=t.tensorIndex;nt(0===n,"input layer has >1 nodes"),nt(0===s,"input layer has >1 tensors"),this.inputLayers.push(e),this.inputLayersNodeIndices.push(n),this.inputLayersTensorIndices.push(s)}this.inputNames=[],this.outputNames=[],this.feedInputShapes=[],this.feedInputNames=[],this.feedOutputNames=[];for(let e=0;e<this.inputLayers.length;e++){const n=this.inputLayers[e];if(!(n instanceof Ke))throw new TypeError(`Input layers to a LayersModel must be InputLayer objects. Received inputs: ${t.inputs}. Input ${e} (0-based) originates from layer type ${n.getClassName()}.`);this.inputNames.push(n.name),this.feedInputShapes.push(n.batchInputShape),this.feedInputNames.push(n.name)}for(const t of this.outputLayers)this.outputNames.push(t.name);this.internalInputShapes=this.inputs.map((t=>t.shape)),this.internalOutputShapes=this.outputs.map((t=>t.shape));const e={},n={},s={},r={},i={},a=[],o=(t,e,n,s,r,l)=>{null!=s&&null!=r&&null!=l||(s=t.sourceLayer,r=t.nodeIndex,l=t.tensorIndex);const u=s.inboundNodes[r];if(-1!==n.indexOf(u))throw new Z(`The tensor ${t.name} at layer "${s.name}" is part of a cycle.`);if(-1!==e.indexOf(u))return;this.containerNodes.add(Mu.nodeKey(s,r)),s.id in i||(i[s.id]=Object.keys(i).length),-1===n.indexOf(u)&&n.push(u);const h=u.inboundLayers.length;for(let t=0;t<h;t++){const s=u.inputTensors[t],r=u.inboundLayers[t],i=u.nodeIndices[t],a=u.tensorIndices[t];o(s,e,n,r,i,a)}for(e.push(u);n.indexOf(u)>=0;)n.splice(n.indexOf(u),1);a.push(u)},l=[],u=[];for(const t of this.outputs)o(t,l,u);const h=a.slice().reverse();for(const t of h){n[t.id]=t,t.id in e||(e[t.id]=0);let i=e[t.id];const a=null==s[t.outboundLayer.id]?0:s[t.outboundLayer.id];i=Math.max(i,a),s[t.outboundLayer.id]=i,r[t.outboundLayer.id]=t.outboundLayer,e[t.id]=i;for(let s=0;s<t.inboundLayers.length;s++){const r=t.inboundLayers[s],a=t.nodeIndices[s],o=r.inboundNodes[a],l=null==e[o.id]?0:e[o.id];e[o.id]=Math.max(i+1,l),n[o.id]=o}}const c={};for(const t in e){const s=e[t];s in c||(c[s]=[]),c[s].push(n[t])}const p={};for(const t in s){const e=s[t];e in p||(p[e]=[]),p[e].push(r[t])}let d=Object.keys(p).map((t=>parseInt(t,10))).sort(pt);this.layers=[];for(const t of d){const e=p[t];e.sort(((t,e)=>{const n=i[t.id],s=i[e.id];return n<s?-1:n>s?1:0}));for(const t of e)t instanceof Mu&&this.internalContainerRefs.push(t),this.layers.push(t)}this.layersByDepth=p,d=Object.keys(c).map((t=>parseInt(t,10))).sort(pt);const f=this.inputs.slice(),g=[];for(const t of d)for(const e of c[t]){const t=e.outboundLayer;if(null!=t){for(const n of e.inputTensors)if(-1===f.indexOf(n))throw new Z(`Graph disconnected: cannot obtain value for tensor ${n} at layer "${t.name}". The following previous layers were accessed without issue: ${g}`);for(const t of e.outputTensors)f.push(t);g.push(t.name)}}this.nodesByDepth=c;const m=this.layers.map((t=>t.name));for(const t of m){const e=m.filter((e=>e===t)).length;if(1!==e)throw new Z(`The name "${t}" is used ${e} times in the model. All layer names should be unique. Layer names: `+JSON.stringify(m))}this.outboundNodes=[],this.inboundNodes=[],new Pe({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:this.inputs.map((t=>null)),outputMasks:this.outputs.map((t=>null)),inputShapes:this.inputs.map((t=>t.shape)),outputShapes:this.outputs.map((t=>t.shape))}),this.built=!0,this._refCount=1}assertNotDisposed(){if(0===this._refCount)throw new Error(`Container '${this.name}' is already disposed.`)}dispose(){this.assertNotDisposed();const t={refCountAfterDispose:null,numDisposedVariables:0};if(0==--this._refCount){for(const e of this.layers)t.numDisposedVariables+=e.dispose().numDisposedVariables;for(const e of this.internalContainerRefs)t.numDisposedVariables+=e.dispose().numDisposedVariables}return t.refCountAfterDispose=this._refCount,t}get trainable(){return this.trainable_}set trainable(t){this.layers.forEach((e=>{e._trainableWeights.forEach((e=>e.trainable=t))})),this.trainable_=t}get trainableWeights(){if(this._trainableWeights.length>0)throw new Y("Container instance unexpectedly contains _trainableWeights.The trainable weights of a Container are a union of the trainable weights of its consituent Layers. Its own _trainableWeights must remain an empty Array.");if(!this.trainable)return[];let t=[];for(const e of this.layers)t=t.concat(e.trainableWeights);return t}get nonTrainableWeights(){const t=[];for(const e of this.layers)t.push(...e.nonTrainableWeights);if(!this.trainable){const e=[];for(const t of this.layers)e.push(...t.trainableWeights);return e.concat(t)}return t}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}loadWeights(t,e=!0){const n={};let s=0;for(const t of this.layers)for(const e of t.weights){if(null!=n[e.originalName])throw new Y(`Duplicate weight name: ${e.originalName}`);n[e.originalName]=e,s++}const r=[];for(const s in t){let i=s;if(null==n[s]){const t=s.split("/");i=t.slice(0,-2).concat([t[t.length-1]]).join("/")}if(null!=n[i])r.push([n[i],t[s]]);else if(e)throw new Y(`Provided weight data has no target variable: ${s}`);delete n[i]}if(e){const t=[];for(const e in n)t.push(e);if(t.length>0)throw new Y(`${t.length} of ${s} weights are not set: ${t}`)}Me(r)}updatedConfig(){const t=this.getConfig(),e={};return e.className=this.getClassName(),e.config=t,e.kerasVersion="tfjs-layers 4.0.0",e.backend="TensorFlow.js",e}toJSON(t,e=!0){const n=Fu(this.updatedConfig());return e?JSON.stringify(n):n}call(t,e){return s((()=>{t=it(t);const n=new qe;for(let e=0;e<this.inputs.length;++e)n.add(this.inputs[e],t[e]);return Je(this.outputs,n,e)}))}computeMask(t,e){return s((()=>{let n;return t=it(t),n=null==e?et(null,t.length):it(e),this.runInternalGraph(t,n)[1]}))}computeOutputShape(t){const e=Ce(t);if(e.length!==this.inputLayers.length)throw new Y(`Invalid inputShape argument ${t}: model has ${this.inputLayers.length} tensor inputs.`);const n={};for(let t=0;t<e.length;t++){const s=this.inputLayers[t],r=e[t];n[s.name+"_0_0"]=r}const s=Object.keys(this.nodesByDepth).map((t=>parseInt(t,10))).sort(pt);if(s.length>1)for(const t of s){const e=this.nodesByDepth[t];for(const t of e){const e=t.outboundLayer;if(-1!==this.inputLayers.map((t=>t.id)).indexOf(e.id))continue;const s=[];for(let e=0;e<t.inboundLayers.length;e++){const r=t.inboundLayers[e],i=t.nodeIndices[e],a=t.tensorIndices[e],o=n[`${r.name}_${i}_${a}`];s.push(o)}const r=Ce(e.computeOutputShape(rt(s))),i=e.inboundNodes.indexOf(t);for(let t=0;t<r.length;t++){n[`${e.name}_${i}_${t}`]=r[t]}}}const r=[],i=[];for(let t=0;t<this.outputLayers.length;t++){const e=this.outputLayers[t],n=this.outputLayersNodeIndices[t],s=this.outputLayersTensorIndices[t],r=`${e.name}_${n}_${s}`;i.push(r)}for(let t=0;t<i.length;t++){const e=i[t];nt(e in n),r.push(n[e])}return rt(r)}runInternalGraph(t,e){null==e&&(e=et(null,t.length));const n={};for(let s=0;s<this.inputs.length;++s){const r=this.inputs[s],i=t[s],a=e[s];n[r.id]=[i,a]}const s=Object.keys(this.nodesByDepth).map((t=>parseInt(t,10))).sort(pt);for(const t of s){const e=this.nodesByDepth[t];for(const t of e){const e=t.outboundLayer,s=t.inputTensors,r=t.outputTensors,i=new Array;for(const t of s)t.id in n&&i.push(n[t.id]);if(i.length===s.length){let s,a,o,l,u={};if(null!=t.callArgs&&(u=t.callArgs),1===i.length){const[t,n]=i[0];null==u.mask&&(u.mask=n),o=it(e.call(t,u)),l=it(e.computeMask(t,n)),s=[t],a=[n]}else s=i.map((t=>t[0])),a=i.map((t=>t[1])),null==u.mask&&(u.mask=a),o=it(e.call(s,u)),l=it(e.computeMask(s,a));if(e.activityRegularizer)throw new X("LayersModel invocation with concrete Tensor value(s) in the presence of activity regularizer(s) is not supported yet.");for(let t=0;t<r.length;++t){const e=r[t],s=o[t],i=l[t];n[e.id]=[s,i]}}}}const r=[],i=[],a=[];for(const t of this.outputs){nt(t.id in n,`Could not compute output ${t.name} : ${t.id}`);const[e,s]=n[t.id];a.push(e.shape),r.push(e),i.push(s)}return[r,i,a]}buildNodeConversionMap(t){const e={};let n;for(const t of this.layers){n=t instanceof Mu?1:0;for(let s=0;s<t.inboundNodes.length;s++){const r=Mu.nodeKey(t,s);this.containerNodes.has(r)&&(e[r]=n,n+=1)}}return e}getLayer(t,e){if(null!=e){if(this.layers.length<=e)throw new Y(`Was asked to retrieve layer at index ${e}, but model only has ${this.layers.length} layer(s).`);return this.layers[e]}if(null==t)throw new Y("Provide either a layer name or layer index");for(const e of this.layers)if(e.name===t)return e;throw new Y(`No such layer: ${t}`)}calculateLosses(){return s((()=>{const t=[];for(const e of this.layers)for(let n=0;n<e.inboundNodes.length;++n){const s=Mu.nodeKey(e,n);this.containerNodes.has(s)&&t.push(...e.calculateLosses())}return t}))}getConfig(){const t={name:this.name},e=this.buildNodeConversionMap(this.layers),n=[];for(const t of this.layers){const s=t.getClassName(),r=t.getConfig(),i=[];for(let n=0;n<t.inboundNodes.length;n++){const s=t.inboundNodes[n],r=Mu.nodeKey(t,n);let a={};if(this.containerNodes.has(r)){if(s.callArgs)try{JSON.stringify(s.callArgs),a=s.callArgs}catch(e){console.warn(`Layer ${t.name} was passed non-serializable keyword arguments: ${s.callArgs}. They will not be included in the serialized model (and thus will be missing at deserialization time).`),a={}}if(s.inboundLayers.length>0){const t=[];for(let n=0;n<s.inboundLayers.length;n++){const r=s.inboundLayers[n],i=s.nodeIndices[n],o=s.tensorIndices[n];let l=e[Mu.nodeKey(r,i)];null==l&&(l=0),t.push([r.name,l,o,a])}i.push(t)}}}const a={};a.name=t.name,a.className=s,a.config=r,a.inboundNodes=i,n.push(a)}t.layers=n;const s=[];for(let t=0;t<this.inputLayers.length;t++){const n=this.inputLayers[t],r=this.inputLayersNodeIndices[t],i=Mu.nodeKey(n,r);if(!this.containerNodes.has(i))continue;let a=e[i];null==a&&(a=0);const o=this.inputLayersTensorIndices[t];s.push([n.name,a,o])}t.inputLayers=s;const r=[];for(let t=0;t<this.outputLayers.length;t++){const n=this.outputLayers[t],s=this.outputLayersNodeIndices[t],i=Mu.nodeKey(n,s);if(!this.containerNodes.has(i))continue;let a=e[i];null==a&&(a=0);const o=this.outputLayersTensorIndices[t];r.push([n.name,a,o])}return t.outputLayers=r,t}static fromConfig(t,e,n={},s=!1){const r={},i={};function a(t,e){t.name in i?i[t.name].push(e):i[t.name]=[e]}function o(t,e){const n=[];let s;for(const i of e){const o=i[0],l=i[1],u=i[2];if(s=null==i[3]?{}:i[3],!(o in r))return void a(t,e);const h=r[o];if(h.inboundNodes.length<=l)return void a(t,e);const c=h.inboundNodes[l];n.push(c.outputTensors[u])}n.length>0&&t.apply(rt(n),s)}function l(t){const n=t.name,i=su(t,null!=e.customObjects?e.customObjects:{});i.setFastWeightInitDuringBuild(s),r[n]=i;t.inboundNodes.forEach((t=>{if(!(t instanceof Array))throw new Y(`Corrupted configuration, expected array for nodeData: ${t}`);a(i,t)}))}const u=e.name,h=e.layers;for(const t of h)l(t);for(;!ft(i);)for(const t of h){const e=r[t.name];if(e.name in i){const t=i[e.name];delete i[e.name];for(const n of t)o(e,n)}}const c=[],p=[],d=e.inputLayers;for(const t of d){const e=t[0],n=t[1],s=t[2];nt(e in r);const i=r[e].inboundNodes[n].outputTensors;c.push(i[s])}const f=e.outputLayers;for(const t of f){const e=t[0],n=t[1],s=t[2];nt(e in r);const i=r[e].inboundNodes[n].outputTensors;p.push(i[s])}return new t({inputs:c,outputs:p,name:u})}get stateful(){if(this._stateful)throw new Y("Container instance unexpectedly has _stateful = true. The statefulness of a Container is determined by the Layers it contains. Its _stateful property must remain the default false.");for(const t of this.layers)if(t.stateful)return!0;return!1}resetStates(){s((()=>{this.layers.forEach((t=>{t.stateful&&t.resetStates()}))}))}}function Lu(t,e){return function(t,e,n){const s=e.length;if(null==t||Array.isArray(t)&&0===t.length)return e.map((t=>null));if(1===s)return Array.isArray(t)&&1===t.length?t:"object"==typeof t&&e[0]in t?[t[e[0]]]:[t];if(Array.isArray(t)){if(t.length!==s)throw new Error(`Provided ${n} is an array of ${t.length} element(s), but the model has ${s} outputs. Make sure a set of weights is provided for each model output.`);return t}if("object"==typeof t&&Object.keys(t).length>0&&"object"==typeof t[Object.keys(t)[0]]){const n=[];return e.forEach((e=>{e in t?n.push(t[e]):n.push(null)})),n}throw new Error(`The model has multiple (${s}) outputs, so ${n} must be either an array with ${s} elements or an object with ${e} keys. Provided ${n} not understood: ${JSON.stringify(t)}`)}(t,e,"classWeight")}async function Ou(t,e,n,i){if(null!=e||null!=i)throw new Error("Support sampleWeight is not implemented yet");if(null!=n){const e=s((()=>{if(1===t.shape.length)return N(t);if(2===t.shape.length){if(t.shape[1]>1){return E(t,1)}if(1===t.shape[1])return I(t,[t.shape[0]]);throw new Error(`Encountered unexpected last-dimension size (${t.shape[1]}) during handling of class weights. The size is expected to be >= 1.`)}throw new Error(`Unexpected rank of target (y) tensor (${t.rank}) during handling of class weights. The rank is expected to be 1 or 2.`)})),i=Array.from(await e.data());g(e);const a=[];return i.forEach((t=>{if(null==n[t])throw new Error(`classWeight must contain all classes in the training data. The class ${t} exists in the data but not in classWeight`);a.push(n[t])})),r(a,"float32")}return null}function Bu(t,e){return l(t,e)}function Pu(e,n){let s,r;const i=n;s=i.xs,r=i.ys,t.util.assert(null!=s&&null!=r,(()=>`A Dataset iterator for fitDataset() is expected to generate objects of the form \`{xs: xVal, ys: yVal}\`, where the two values may be \`tf.Tensor\`, an array of Tensors, or a map of string to Tensor.  The provided Dataset instead generates ${n}`));const a=Wu("input",e.inputNames,s),o=Wu("output",e.outputNames,r),l=a[0].shape[0];t.util.assert(a.length===e.inputs.length,(()=>`LayersModel has ${e.inputs.length} inputs, but the dataset provides ${a.length} inputs.  (Expected input keys: ${JSON.stringify(e.inputNames)})`)),t.util.assert(o.length===e.outputs.length,(()=>`LayersModel has ${e.outputs.length} outputs, but the dataset provides ${o.length} outputs.  (Expected output keys: ${JSON.stringify(e.outputNames)})`));for(let n=0;n<a.length;n++)t.util.assert(a[n].shape[0]===l,(()=>`Batch size mismatch: input ${e.inputNames[n]} has ${a[n].shape[0]}; expected  ${l} based on input ${e.inputNames[0]}.`));for(let n=0;n<o.length;n++)t.util.assert(o[n].shape[0]===l,(()=>`Batch size mismatch: output ${e.outputNames[n]} has ${o[n].shape[0]}; expected  ${l} based on input ${e.inputNames[0]}.`));return{xs:a,ys:o}}function Wu(e,n,s){if(s instanceof t.Tensor)return[s];if(Array.isArray(s))return t.util.assert(s.length===n.length,(()=>`Received an array of ${s.length} Tensors, but expected ${n.length} to match the ${e} keys ${n}.`)),s;{const t=[];for(const r of n){if(null==s[r])throw new Y(`The feature data generated by the dataset lacks the required ${e} key '${r}'.`);t.push(s[r])}return t}}async function Uu(e,n,s){const r=null!=s.batchesPerEpoch;if(t.util.assert(null!=e.optimizer,(()=>"You must compile a model before training/testing. Use LayersModel.compile(modelCompileConfig).")),t.util.assert(null!=s,(()=>"For fitDataset(), the 2nd argument (config) is required, but it is not provided in this call.")),t.util.assert(null!=s.epochs&&s.epochs>0&&Number.isInteger(s.epochs),(()=>`For fitDataset(), config.epochs is expected to be a positive integer, but got ${s.epochs}`)),t.util.assert(!r||s.batchesPerEpoch>0&&Number.isInteger(s.batchesPerEpoch),(()=>`For fitDataset(), config.batchesPerEpoch is expected to be a positive integer if specified, but got ${s.batchesPerEpoch}`)),t.util.assert(null==s.validationSplit,(()=>"`validationSplit` is not supported by `fitDataset()`. Use validationData instead.")),e.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");e.isTraining=!0;try{const i=null!=s.validationData;let a,o;if(i)if(Vu(s.validationData))t.util.assert(null==s.validationBatches||s.validationBatches>0&&Number.isInteger(s.validationBatches),(()=>`For fitDataset() with dataset-based validation, config.validationBatches is expected not to be provided, or to be a positive integer, but got ${s.validationBatches}`));else{const t=function(t){if(3===t.length)throw new X("Validation with sample weights is not implemented yet.");return{xs:t[0],ys:t[1]}}(s.validationData);a=t.xs,o=t.ys}const l=e.makeTrainFunction(),u=e.getDedupedMetricsNames();let h;h=i?u.slice().concat(u.map((t=>"val_"+t))):u.slice();const c=tu(s.callbacks,s.yieldEvery),p=null==s.verbose?1:s.verbose,{callbackList:d,history:f}=nu(c,p,s.epochs,null,null,function(t,e){let n=null;null!=e.batchesPerEpoch?n=e.batchesPerEpoch:Number.isFinite(t.size)&&(n=t.size);return n}(n,s),null,i,h);d.setModel(e),e.history=f,await d.onTrainBegin(),e.stopTraining_=!1;let g=null==s.initialEpoch?0:s.initialEpoch,m=await n.iterator();for(;g<s.epochs;){const h={};await d.onEpochBegin(g);let c=0,p=0;for(r||(m=await n.iterator());!r||c<s.batchesPerEpoch;){const n=await m.next();if(r&&n.done){console.warn(`You provided \`batchesPerEpoch\` as ${s.batchesPerEpoch}, but your dataset iterator ran out of data after ${c} batches; interrupting training. Make sure that your dataset can generate at least \`batchesPerEpoch * epochs\` batches (in this case, `+s.batchesPerEpoch*s.epochs+" batches). You may need to use the repeat() function when building your dataset.");break}if(null!=n.value){const{xs:r,ys:i}=Pu(e,n.value),a={};a.batch=p,a.size=r[0].shape[0],await d.onBatchBegin(p,a);const o=[];if(null!=s.classWeight){const t=Lu(s.classWeight,e.outputNames);for(let e=0;e<t.length;++e)o.push(await Ou(i[e],null,t[e]))}const h=r.concat(i).concat(o),f=l(h);t.dispose(h);for(let e=0;e<u.length;++e){const n=u[e],s=f[e];a[n]=s,t.keep(s)}await d.onBatchEnd(p,a),Hl(a),p++,c++}if(r?c>=s.batchesPerEpoch:n.done){if(i){let t;t=Vu(s.validationData)?it(await e.evaluateDataset(s.validationData,{batches:s.validationBatches})):it(e.evaluate(a,o,{batchSize:null==s.validationBatchSize?32:s.validationBatchSize,verbose:0}));for(let n=0;n<e.metricsNames.length;++n)h[`val_${e.metricsNames[n]}`]=t[n]}break}if(e.stopTraining_)break}if(await d.onEpochEnd(g,h),g++,e.stopTraining_)break}return await d.onTrainEnd(),await e.history.syncData(),e.history}finally{e.isTraining=!1}}function Vu(t){return"function"==typeof t.iterator}function Ku(e){t.util.assert(e>0&&Number.isInteger(e),(()=>`batchSize is required to be a positive integer, but got ${e}`))}function ju(t,e,n){return null==t?[null]:Array.isArray(t)?t.map((t=>Gt(t,e,n-e))):Gt(t,e,n-e)}function qu(e,n){return t.tidy((()=>null==e?null:Array.isArray(e)?e.map((t=>qu(t,n))):ee(e,"int32"===n.dtype?n:t.cast(n,"int32"))))}function Gu(t,e){const n=[];let s=0,r=null;for(;s<t;)r=s+e,r>=t&&(r=t),n.push([s,r]),s=r;return n}async function Hu(n,s,i,a={}){if(n.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");let o,l,u,h,c,p,d,f,g;n.isTraining=!0;try{const m=null==a.batchSize?32:a.batchSize;Ku(m);const b=!1,y=await n.standardizeUserData(s,i,a.sampleWeight,a.classWeight,b,m);o=y[0],l=y[1],g=y[2];let w,k=!1;if(null!=a.validationData&&a.validationData.length>0){if(k=!0,2!==a.validationData.length)throw 3===a.validationData.length?new X("validationData including sample weights is not supported yet."):new Y(`When passing validation data, it must contain 2 (valX, valY) or 3 (valX, valY, valSampleWeight) items; ${a.validationData} is invalid.`);c=a.validationData[0],p=a.validationData[1];const t=!0,e=await n.standardizeUserData(c,p,null,null,t,m);d=e[0],f=e[1],w=d.concat(f)}else if(null!=a.validationSplit&&a.validationSplit>0&&a.validationSplit<1){k=!0;const t=Math.floor(o[0].shape[0]*(1-a.validationSplit)),e=o[0].shape[0];d=ju(o,t,e),u=o,o=ju(o,0,t),f=ju(l,t,e),h=l,l=ju(l,0,t),w=d.concat(f)}else null!=a.validationSteps&&(k=!0);const v=o.concat(l).concat(g);n.checkTrainableWeightsConsistency();const x=n.makeTrainFunction(),S=n.getDedupedMetricsNames();let N,E;k?(n.makeTestFunction(),N=n.testFunction,E=S.slice().concat(S.map((t=>"val_"+t)))):(N=null,w=[],E=S.slice());const I=tu(a.callbacks,a.yieldEvery),A=await async function(n,s,i,a,o,l,u,h,c,p,d,f,g,m,b){null==o&&(o=32),null==l&&(l=1),null==d&&(d=!0),null==g&&(g=0);let y=!1;if(null!=c&&null!=p&&(y=!0),null!=b&&(y=!0,null==m))throw new Y("Can only use `validationSteps` when doing step-wise training, i.e., `stepsPerEpoch` must be set.");const w=n.checkNumSamples(i,o,m,"steps_per_epoch");let k;null!=w&&(k=Ut(0,w)),null==u&&(u=1);const{callbackList:v,history:x}=nu(h,u,l,g,w,m,o,y,f);v.setModel(n),n.history=x,await v.onTrainBegin(),n.stopTraining_=!1;for(let u=g;u<l;++u){await v.onEpochBegin(u);const l={};if(null!=m)throw new X("stepsPerEpoch mode is not implemented yet.");{if("batch"===d)throw new X("batch shuffling is not implemneted yet");d&&e.shuffle(k);const u=r(k),h=Gu(w,o);for(let e=0;e<h.length;++e){const r={};if(await v.onBatchBegin(e,r),t.tidy((()=>{const d=h[e][0],f=h[e][1],g=Gt(u,d,f-d);r.batch=e,r.size=f-d;const m=qu(i,g),b=s(m);for(let e=0;e<a.length;++e){const n=a[e],s=b[e];r[n]=s,t.keep(s)}if(e===h.length-1&&y){const e=n.testLoop(c,p,o);for(let n=0;n<a.length;++n){const s=a[n],r=e[n];t.keep(r),l["val_"+s]=r}}})),await v.onBatchEnd(e,r),Hl(r),n.stopTraining_)break}u.dispose()}if(await v.onEpochEnd(u,l),n.stopTraining_)break}return await v.onTrainEnd(),await n.history.syncData(),n.history}(n,x,v,S,m,a.epochs,a.verbose,I,N,w,a.shuffle,E,a.initialEpoch,null,null);return A}finally{n.isTraining=!1,Zu(o,s),Zu(l,i),Zu(u,s),Zu(h,i),Zu(d,c),Zu(f,p),null!=g&&t.dispose(g)}}function Ju(t){const e=[];t instanceof A&&(t=[t]);for(let n=0;n<t.length;++n){const s=t[n];if(1===s.rank)e.push(qt(s,1));else{if(0===s.rank)throw new Error("Expected tensor to be at least 1D, but received a 0D tensor (scalar).");e.push(s)}}return e}function Zu(t,e){if(null==t)return;const n=[];if(e instanceof A)n.push(e.id);else if(Array.isArray(e))e.forEach((t=>n.push(t.id)));else if(null!=e)for(const t in e){const s=e[t];n.push(s.id)}const s=[];if(t instanceof A)-1===n.indexOf(t.id)&&s.push(t);else if(Array.isArray(t))t.forEach((t=>{-1===n.indexOf(t.id)&&s.push(t)}));else if(null!=t)for(const e in t){const r=t[e];-1===n.indexOf(r.id)&&s.push(r)}s.forEach((t=>{t.isDisposed||t.dispose()}))}function Yu(t){return Array.isArray(t)}function Xu(t){return!function(t){return t instanceof A}(t)&&!Yu(t)}function Qu(t,e,n,s=!0,r=""){if(null==e||0===e.length){if(null!=t){let e=!1;if(Yu(t)&&t.length>0)e=!0;else if(Xu(t)){for(const n in t)if(t.hasOwnProperty(n)){e=!0;break}}else e=!0;if(e)throw new Y(`Error when checking model ${r} expected no data, but got ${t}`)}return[]}if(null==t)return e.map((t=>null));let i;if(Xu(t)){i=[];for(const n of e){if(null==t[n])throw new Y(`No data provided for "${n}". Need data for each key in: ${e}`);i.push(t[n])}}else if(Yu(t)){if(t.length!==e.length)throw new Y(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the model expected. Expected to see ${e.length} Tensor(s), but instead got the following list of Tensor(s): ${t}`);i=t}else{if(e.length>1)throw new Y(`The model ${r} expects ${e.length} Tensor(s), but only received one Tensor. Found: Tensor with shape ${t.shape}`);i=[t]}if(i=Ju(i),null!=n)for(let t=0;t<e.length;++t){if(null==n[t])continue;const a=i[t];if(a.shape.length!==n[t].length)throw new Y(`Error when checking ${r}: expected ${e[t]} to have ${n[t].length} dimension(s). but got array with shape ${a.shape}`);for(let e=0;e<n[t].length;++e){if(0===e&&!s)continue;const i=a.shape[e],o=n[t][e];if(null!=o&&o>=0&&i!==o)throw new Y(`${r} expected a batch of elements where each example has shape [${n[t].slice(1,n[t].length)}] (i.e.,tensor shape [*,${n[t].slice(1,n[t].length)}]) but the ${r} received an input with ${a.shape[0]} examples, each with shape [${a.shape.slice(1,a.shape.length)}] (tensor shape [${a.shape}])`)}}return i}function th(t,e,n,s=!0,r=""){let i;if(Array.isArray(t)){if(t.length!==e.length)throw new Y(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the the model expected. Expected to see ${e.length} Tensor(s), but instead got ${t.length} Tensors(s).`);i=t}else{if(e.length>1)throw new Y(`The model expects ${e.length} ${r} Tensors, but only received one Tensor. Found: array with shape ${JSON.stringify(t.shape)}.`);i=[t]}if(null!=n)for(let t=0;t<e.length;++t){if(null==n[t])continue;const a=i[t];if(a.shape.length!==n[t].length)throw new Y(`Error when checking ${r}: expected ${e[t]} to have ${n[t].length} dimension(s), but got array with shape ${JSON.stringify(a.shape)}`);for(let i=0;i<n[t].length;++i){if(0===i&&!s)continue;const o=a.shape[i],l=n[t][i];if(null!=l&&l!==o)throw new Y(`Error when checking ${r}: expected ${e[t]} to have shape ${JSON.stringify(n[t])} but got array with shape ${JSON.stringify(a.shape)}.`)}}}class eh extends Mu{constructor(t){super(t),this.isTraining=!1}summary(t,e,n=console.log){if(!this.built)throw new Y("This model has never been called, thus its weights have not been created yet. So no summary can be displayed. Build the model first (e.g., by calling it on some test data).");Tu(this,t,e,n)}compile(t){if(null==t.loss&&(t.loss=[]),this.loss=t.loss,"string"==typeof t.optimizer)this.optimizer_=function(t){const e={Adagrad:()=>S.adagrad(.01),Adadelta:()=>S.adadelta(1,.95,Kt()),Adam:()=>S.adam(.001,.9,.999,Kt()),Adamax:()=>S.adamax(.002,.9,.999,Kt(),0),RMSProp:()=>S.rmsprop(.001,.9,0,Kt()),SGD:()=>S.sgd(.01)};if(e.adagrad=e.Adagrad,e.adadelta=e.Adadelta,e.adam=e.Adam,e.adamax=e.Adamax,e.rmsprop=e.RMSProp,e.sgd=e.SGD,t in e)return e[t]();throw new Y(`Unknown Optimizer ${t}`)}(t.optimizer),this.isOptimizerOwned=!0;else{if(!(t.optimizer instanceof T))throw new Y("User-defined optimizer must be an instance of tf.Optimizer.");this.optimizer_=t.optimizer,this.isOptimizerOwned=!1}let e=[];if(Array.isArray(t.loss)||"string"==typeof t.loss||"function"==typeof t.loss)if(Array.isArray(t.loss)){if(t.loss.length!==this.outputs.length)throw new Y(`When passing an Array as loss, it should have one entry per model output. The model has ${this.outputs.length} output(s), but you passed loss=${t.loss}.`);const n=t.loss;e=n.map((t=>du(t)))}else{const n=du(t.loss);this.outputs.forEach((t=>{e.push(n)}))}else{t.loss=t.loss;for(const e in t.loss)if(-1===this.outputNames.indexOf(e))throw new Y(`Unknown entry in loss dictionary: "${e}". Only expected the following keys: ${this.outputNames}`);for(const n of this.outputNames)null==t.loss[n]&&console.warn(`Output "${n}" is missing from loss dictionary. We assume this was done on purpose, and we will not be expecting data to be passed to ${n} during training`),e.push(du(t.loss[n]))}this.lossFunctions=e,this.feedOutputNames=[],this.feedOutputShapes=[],this.feedLossFns=[];for(let t=0;t<this.outputs.length;++t){const e=this.internalOutputShapes[t],n=this.outputNames[t];this.feedOutputNames.push(n),this.feedOutputShapes.push(e),this.feedLossFns.push(this.lossFunctions[t])}const n=[];this.metrics=t.metrics,this.metricsNames=["loss"],this.metricsTensors=[],Ft("loss",(()=>{for(let t=0;t<this.outputs.length;++t){if(-1!==n.indexOf(t))continue;const e=this.lossFunctions[t];this.outputs.length>1&&(this.metricsTensors.push([e,t]),this.metricsNames.push(this.outputNames[t]+"_loss"))}}));const s=function(t,e){if(null==t||Array.isArray(t)&&0===t.length)return e.map((t=>[]));let n;if("string"==typeof t||"function"==typeof t)n=[t];else{if(!Array.isArray(t)&&"object"!=typeof t)throw new TypeError(`Type of metrics argument not understood. Expected an string,function, Array, or Object, found: ${t}`);n=t}if(Array.isArray(n))return e.map((t=>n));{const t=[];for(const s of e){let e=n.hasOwnProperty(s)?n[s]:[];Array.isArray(e)||(e=[e]),t.push(e)}return t}}(t.metrics,this.outputNames),r=(t,e,n)=>{this.outputNames.length>1&&(e=this.outputNames[t]+"_"+e),this.metricsNames.push(e),this.metricsTensors.push([n,t])};Ft("metric",(()=>{for(let t=0;t<this.outputs.length;++t){if(-1!==n.indexOf(t))continue;(e=>{let n,s,i;for(const a of e){if("string"==typeof a&&-1!==["accuracy","acc","crossentropy","ce"].indexOf(a)){const e=this.internalOutputShapes[t];let r;1===e[e.length-1]||this.lossFunctions[t]===hu?-1!==["accuracy","acc"].indexOf(a)?s=fu:-1!==["crossentropy","ce"].indexOf(a)&&(s=wu):this.lossFunctions[t]===uu?-1!==["accuracy","acc"].indexOf(a)?s=ku:-1!==["crossentropy","ce"].indexOf(a)&&(s=xu):-1!==["accuracy","acc"].indexOf(a)?s=gu:-1!==["crossentropy","ce"].indexOf(a)&&(s=vu),-1!==["accuracy","acc"].indexOf(a)?r="acc":-1!==["crossentropy","ce"].indexOf(a)&&(r="ce"),i=s,n=""+r}else{const t=Nu(a);i=t,n=""+Eu(a)}let e;Ft(n,(()=>{e=i})),r(t,n,e)}})(s[t])}})),this.collectedTrainableWeights=this.trainableWeights}checkTrainableWeightsConsistency(){null!=this.collectedTrainableWeights&&this.trainableWeights.length!==this.collectedTrainableWeights.length&&console.warn("Discrepancy between trainableweights and collected trainable weights. Did you set `model.trainable` without calling `model.compile()` afterwards?")}evaluate(t,e,n={}){const s=null==n.batchSize?32:n.batchSize;Ku(s);const r=this.standardizeUserDataXY(t,e,!0,s);try{const i=r[0].concat(r[1]);this.makeTestFunction();const a=this.testFunction;return rt(this.testLoop(a,i,s,n.verbose,n.steps))}finally{Zu(r[0],t),Zu(r[1],e)}}async evaluateDataset(e,n){return this.makeTestFunction(),async function(e,n,s){const r=null!=(s=s||{}).batches,i=e.testFunction;let a=[];if(s.verbose>0)throw new X("Verbose mode is not implemented yet.");t.util.assert(!r||s.batches>0&&Number.isInteger(s.batches),(()=>`Test loop expects \`batches\` to be a positive integer, but received ${JSON.stringify(s.batches)}`));const o="function"==typeof n.next?n:await n.iterator();let l=0,h=0;for(;!r||h<s.batches;){const n=await o.next();if(a=t.tidy((()=>{if(n.value){const{xs:s,ys:r}=Pu(e,n.value),o=s.concat(r),c=t.tidy((()=>i(o)));if(t.dispose(o),0===h)for(let t=0;t<c.length;++t)a.push(u(0));const p=o[0].shape[0];for(let e=0;e<c.length;++e){const n=c[e],s=a[e];a[e]=t.tidy((()=>t.add(a[e],t.mul(p,n)))),h>0&&t.dispose(s)}t.dispose(c),l+=p,++h}return a})),n.done){r&&console.warn(`Your dataset iterator ran out of data during evaluateDataset(). Interrupting evalution. Make sure that your dataset can generate at least \`batches\` batches (in this case, ${s.batches} batches). You may need to use the repeat() function when building your dataset.`);break}}for(let e=0;e<a.length;++e){const n=a[e];a[e]=t.div(a[e],l),t.dispose(n)}return rt(a)}(this,e,n)}checkNumSamples(t,e,n,s="steps"){let r;if(null!=n){if(r=null,null!=e)throw new Y(`If ${s} is set, batchSize must be null or undefined.Got batchSize = ${e}`)}else{if(null==t)throw new Y(`Either the input data should have a defined shape, or ${s} shoud be specified.`);r=Array.isArray(t)?t[0].shape[0]:t.shape[0]}return r}execute(t,e){if(Array.isArray(e)&&0===e.length)throw new Y("`outputs` is an empty Array, which is not allowed.");const n=Array.isArray(e),s=n?e:[e],r=this.retrieveSymbolicTensors(s),i=new qe;if(t instanceof A&&(t=[t]),Array.isArray(t)){if(t.length!==this.inputs.length)throw new Y(`The number of inputs provided (${t.length}) does not match the number of inputs of this model (${this.inputs.length}).`);for(let e=0;e<this.inputs.length;++e)i.add(this.inputs[e],t[e])}else for(const e of this.inputs){const n=t[e.name];if(null==n)throw new Y(`No value is provided for the model's input ${e.name}`);i.add(e,n)}const a=Je(r,i);return n?a:a[0]}retrieveSymbolicTensors(t){const e=et(null,t.length);let n=t.length;for(const s of this.layers){const r=Array.isArray(s.output)?s.output:[s.output],i=r.map((t=>t.name));for(let s=0;s<t.length;++s){const a=i.indexOf(t[s]);if(-1!==a&&(e[s]=r[a],n--),0===n)break}if(0===n)break}if(n>0){const n=[];throw e.forEach(((e,s)=>{null==e&&n.push(t[s])})),new Y(`Cannot find SymbolicTensors for output name(s): ${JSON.stringify(n)}`)}return e}predictLoop(e,n=32,s=!1){return t.tidy((()=>{const r=this.checkNumSamples(e);if(s)throw new X("Verbose predictLoop() is not implemented yet.");const i=Gu(r,n),a=this.outputs.map((t=>[]));for(let n=0;n<i.length;++n){t.tidy((()=>{const t=i[n][0],s=i[n][1],r=ju(e,t,s),a=[];if(Array.isArray(r))for(let t=0;t<r.length;++t)a.push({key:this.inputs[t],value:r[t]});else a.push({key:this.inputs[0],value:r});const o=new qe(a);return Je(this.outputs,o)})).forEach(((t,e)=>a[e].push(t)))}return rt(a.map((e=>t.concat(e,0))))}))}predict(t,e={}){const n=Ju(t);th(n,this.inputNames,this.feedInputShapes,!1);try{const s=null==e.batchSize?32:e.batchSize;return Ku(s),this.predictLoop(n,s)}finally{Zu(n,t)}}predictOnBatch(t){th(t,this.inputNames,this.feedInputShapes,!0);const e=(Array.isArray(t)?t[0]:t).shape[0];return this.predictLoop(t,e)}standardizeUserDataXY(t,n,s=!0,r){if(null==this.optimizer_)throw new Z("You must compile a model before training/testing. Use LayersModel.compile(modelCompileArgs).");const i=[];for(let t=0;t<this.feedOutputShapes.length;++t){const e=this.feedOutputShapes[t];this.feedLossFns[t]===uu?i.push(e.slice(0,e.length-1).concat([1])):i.push(e)}if(function(t,n,s){const r=dt(t.map((t=>t.shape[0])));r.sort();const i=dt(n.map((t=>t.shape[0])));if(i.sort(),r.length>1)throw new Y(`All input Tensors (x) should have the same number of samples. Got array shapes: ${JSON.stringify(t.map((t=>t.shape)))}`);if(i.length>1)throw new Y(`All target Tensors (y) should have the same number of samples. Got array shapes: ${JSON.stringify(n.map((t=>t.shape)))}`);if(r.length>0&&i.length>0&&!e.arraysEqual(r,i))throw new Y(`Input Tensors should have the same number of samples as target Tensors. Found ${r[0]} input sample(s) and ${i[0]} target sample(s).`)}(t=Qu(t,this.feedInputNames,this.feedInputShapes,!1,"input"),n=Qu(n,this.feedOutputNames,i,!1,"target")),function(t,e,n){const s=[iu,hu,lu];for(let r=0;r<t.length;++r){const i=t[r],a=e[r],o=n[r];if(null!=a){if(a===lu&&1===i.shape[i.shape.length-1])throw new Y(`You are passing a target array of shape ${i.shape} while using a loss 'categorical_crossentropy'. 'categorical_crossentropy'expects targets to be binary matrices (1s and 0s) of shape [samples, classes].`);if(-1!==s.indexOf(a)){const t=i.shape.slice(1),e=o.slice(1);for(let n=0;n<t.length;++n){const s=t[n],r=e[n];if(null!=r&&s!==r)throw new Y(`A target Tensor with shape ${i.shape} was passed for an output of shape ${o}, while using a loss function that expects targets to have the same shape as the output.`)}}}}}(n,this.feedLossFns,this.feedOutputShapes),this.stateful&&null!=r&&r>0&&t[0].shape[0]%r!=0)throw new Y(`In a stateful network, you should only pass inputs with a number of samples that is divisible by the batch size ${r}. Found: ${t[0].shape[0]} sample(s).`);return[t,n]}async standardizeUserData(t,e,n,s,r=!0,i){const[a,o]=this.standardizeUserDataXY(t,e,r,i);if(null!=n)throw new Error("sample weight is not supported yet.");let l=null;if(null!=s){const t=Lu(s,this.outputNames);l=[];for(let e=0;e<t.length;++e)l.push(await Ou(o[e],null,t[e]))}return[a,o,l]}testLoop(e,n,s,i=0,a){return t.tidy((()=>{const o=this.checkNumSamples(n,s,a,"steps"),l=[];if(i>0)throw new X("Verbose mode is not implemented yet.");if(null!=a)throw new X("steps mode in testLoop() is not implemented yet");{const i=Gu(o,s),a=r(Ut(0,o));for(let s=0;s<i.length;++s){const r=i[s][0],o=i[s][1],h=Gt(a,r,o-r),c=qu(n,h),p=e(c);if(0===s)for(let t=0;t<p.length;++t)l.push(u(0));for(let e=0;e<p.length;++e){const n=p[e];l[e]=t.add(l[e],t.mul(o-r,n))}}for(let e=0;e<l.length;++e)l[e]=t.div(l[e],o)}return l}))}getDedupedMetricsNames(){const t=this.metricsNames,e=[];for(let n=0;n<t.length;++n){const s=t[n];let r=s;if(st(t,s)>1){r+=`_${st(t.slice(0,n),s)}`}e.push(r)}return e}makeTrainFunction(){return e=>{const n=[],s=e.slice(0,this.inputs.length),r=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),i=e.slice(this.inputs.length+this.outputs.length,this.inputs.length+2*this.outputs.length),a=[],o=this.collectedTrainableWeights.map((t=>t.read()));return[this.optimizer_.minimize((()=>{const e=[];for(let t=0;t<this.inputs.length;++t)e.push({key:this.inputs[t],value:s[t]});const o=new qe(e),l=Je(this.outputs,o,{training:!0});let u;for(let e=0;e<this.lossFunctions.length;++e){let s=(0,this.lossFunctions[e])(r[e],l[e]);null!=i[e]&&(s=Bu(s,i[e]));const a=t.mean(s);n.push(a),u=0===e?s:t.add(u,s)}for(let e=0;e<this.metricsTensors.length;++e){let s;if(this.outputs.length>1&&e<this.outputs.length)s=n[e];else{const n=this.metricsTensors[e][0],i=this.metricsTensors[e][1];s=t.mean(n(r[i],l[i]))}t.keep(s),a.push(s)}return u=t.mean(u),this.calculateLosses().forEach((e=>{u=t.add(u,e)})),u}),!0,o)].concat(a)}}makeTestFunction(){this.testFunction=e=>t.tidy((()=>{const n=[];let s;const r=e.slice(0,this.inputs.length),i=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),a=[];for(let t=0;t<this.inputs.length;++t)a.push({key:this.inputs[t],value:r[t]});const o=new qe(a),l=Je(this.outputs,o);for(let e=0;e<this.lossFunctions.length;++e){const r=this.lossFunctions[e],a=t.mean(r(i[e],l[e]));s=0===e?a:t.add(s,a),n.push(s)}for(let e=0;e<this.metricsTensors.length;++e){const s=this.metricsTensors[e][0],r=this.metricsTensors[e][1],a=t.mean(s(i[r],l[r]));n.push(a)}return n}))}async fit(t,e,n={}){return Hu(this,t,e,n)}async fitDataset(t,e){return Uu(this,t,e)}async trainOnBatch(e,n){const s=await this.standardizeUserData(e,n),r=s[0],i=s[1],a=this.makeTrainFunction()(r.concat(i)),o=[];for(const t of a){const e=await t.data();o.push(e[0])}return t.dispose(a),Zu(s[0],e),Zu(s[1],n),rt(o)}getNamedWeights(t){const e=[],n=null!=t&&t.trainableOnly,s=n?this.trainableWeights:this.weights,r=this.getWeights(n);for(let t=0;t<s.length;++t)n&&!s[t].trainable||e.push({name:s[t].originalName,tensor:r[t]});return e}set stopTraining(t){this.stopTraining_=t}get stopTraining(){return this.stopTraining_}get optimizer(){return this.optimizer_}set optimizer(t){this.optimizer_!==t&&(this.optimizer_=t,this.isOptimizerOwned=!1)}dispose(){const e=super.dispose();if(0===e.refCountAfterDispose&&null!=this.optimizer&&this.isOptimizerOwned){const n=t.memory().numTensors;this.optimizer_.dispose(),e.numDisposedVariables+=n-t.memory().numTensors}return e}getLossIdentifiers(){let t;if("string"==typeof this.loss)t=at(this.loss);else if(Array.isArray(this.loss)){for(const t of this.loss)if("string"!=typeof t)throw new Error("Serialization of non-string loss is not supported.");t=this.loss.map((t=>at(t)))}else{const e=Object.keys(this.loss);t={};const n=this.loss;for(const s of e){if("string"!=typeof n[s])throw new Error("Serialization of non-string loss is not supported.");t[s]=at(n[s])}}return t}getMetricIdentifiers(){if("string"==typeof this.metrics||"function"==typeof this.metrics)return[at(Eu(this.metrics))];if(Array.isArray(this.metrics))return this.metrics.map((t=>at(Eu(t))));{const t={};for(const e in this.metrics)t[e]=at(Eu(this.metrics[e]));return t}}getTrainingConfig(){return{loss:this.getLossIdentifiers(),metrics:this.getMetricIdentifiers(),optimizer_config:{class_name:this.optimizer.getClassName(),config:this.optimizer.getConfig()}}}loadTrainingConfig(t){if(null!=t.weighted_metrics)throw new Error("Loading weight_metrics is not supported yet.");if(null!=t.loss_weights)throw new Error("Loading loss_weights is not supported yet.");if(null!=t.sample_weight_mode)throw new Error("Loading sample_weight_mode is not supported yet.");const e=su(Du(t.optimizer_config));let n,s;if("string"==typeof t.loss)n=ot(t.loss);else if(Array.isArray(t.loss))n=t.loss.map((t=>ot(t)));else if(null!=t.loss){n={};for(const e in t.loss)n[e]=ot(t.loss[e])}if(Array.isArray(t.metrics))s=t.metrics.map((t=>ot(t)));else if(null!=t.metrics){s={};for(const e in t.metrics)s[e]=ot(t.metrics[e])}this.compile({loss:n,metrics:s,optimizer:e})}async save(t,e){if("string"==typeof t){const e=$.getSaveHandlers(t);if(0===e.length)throw new Y(`Cannot find any save handlers for URL '${t}'`);if(e.length>1)throw new Y(`Found more than one (${e.length}) save handlers for URL '${t}'`);t=e[0]}if(null==t.save)throw new Y("LayersModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");const n=await $.encodeWeights(this.getNamedWeights(e)),s={modelTopology:this.toJSON(null,!1),format:"layers-model",generatedBy:"TensorFlow.js tfjs-layers v4.0.0",convertedBy:null};if(null!=e&&e.includeOptimizer&&null!=this.optimizer){s.trainingConfig=this.getTrainingConfig();const t="optimizer",{data:e,specs:r}=await $.encodeWeights(await this.optimizer.getWeights(),t);n.specs.push(...r),n.data=$.concatenateArrayBuffers([n.data,e])}if(null!=this.userDefinedMetadata){const t=!0;Iu(this.userDefinedMetadata,this.name,t),s.userDefinedMetadata=this.userDefinedMetadata}return s.weightData=n.data,s.weightSpecs=n.specs,t.save(s)}setUserDefinedMetadata(t){Iu(t,this.name),this.userDefinedMetadata=t}getUserDefinedMetadata(){return this.userDefinedMetadata}}eh.className="Model",i.registerClass(eh);class nh extends eh{}async function sh(t,e){if(null==e&&(e={}),"string"==typeof t){const n=$.getLoadHandlers(t,e);if(0===n.length)n.push($.browserHTTPRequest(t,e));else if(n.length>1)throw new Y(`Found more than one (${n.length}) load handlers for URL '${t}'`);t=n[0]}return async function(t,e,n){null==n&&(n={});if(null==t.load)throw new Y("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const s=await t.load();let r=s.modelTopology;null!=r.model_config&&(r=r.model_config);const i=null==n.strict||n.strict,a=null!=s.weightData&&null!=s.weightSpecs&&i,o=su(Du(r),e,a),l=s.trainingConfig;null!=l&&o.loadTrainingConfig(l);null!=s.userDefinedMetadata&&o.setUserDefinedMetadata(s.userDefinedMetadata);if(null!=s.weightData){if(null==s.weightSpecs)throw new Y("LayersModel artifacts contains weight data, but not weight specs. Therefore loading of weights cannot proceed.");const{modelWeights:t,optimizerWeights:e}=function(t,e){const n=$.decodeWeights(t,e),s={},r=[];return e.forEach((t=>{"optimizer"===t.group?r.push({name:t.name,tensor:n[t.name]}):s[t.name]=n[t.name]})),{modelWeights:s,optimizerWeights:r}}(s.weightData,s.weightSpecs);o.loadWeights(t,i),null!=o.optimizer&&e.length>0&&await o.optimizer.setWeights(e),g(t),g(e.map((t=>t.tensor)))}return o}(t,void 0,e)}nh.className="Functional",i.registerClass(nh);class rh extends eh{constructor(t){if(super({inputs:[],outputs:[]}),t=t||{},this.trainable=!0,this.built=!1,this.name=null!=t.name?t.name:St("sequential_"),null!=t.layers)for(const e of t.layers)this.add(e)}checkShape(t){if(t.inboundNodes[0].outputTensors[0].shape.some((t=>t<0)))throw new Y(`Negative dimension size caused by adding layer ${t.name} with input shape [${t.inboundNodes[0].inputTensors[0].shape}]`)}add(t){const e=t instanceof rh||t instanceof eh;let n;if(e){if(n=t,1!==n.outputs.length)throw new Y("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");if(1!==n.inputs.length)throw new Y("All layers in a Sequential model should have a single input tensor. For multi-input layers, use the functional API.")}if(0===this.outputs.length){if(0===t.inboundNodes.length){if(null==t.batchInputShape)throw new Y("The first layer in a Sequential model must get an `inputShape` or `batchInputShape` argument.");const e=je({batchShape:t.batchInputShape,dtype:t.dtype,name:t.name+"_input"});t.apply(e)}if(e)this.outputs=n.outputs,this.inputs=n.inputs;else{if(1!==t.inboundNodes.length)throw new Y(`A layer added to a Sequential model must not already be connected somewhere else. LayersModel received layer ${t.name} which has ${t.inboundNodes.length} pre-existing inbound connections.`);if(1!==t.inboundNodes[0].outputTensors.length)throw new Y("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(t),this.outputs=[t.inboundNodes[0].outputTensors[0]],this.inputs=Ve(this.outputs[0])}this.inboundNodes=[],new Pe({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:et(null,this.inputs.length),outputMasks:[null],inputShapes:this.inputs.map((t=>t.shape)),outputShapes:this.outputs[0].shape})}else{const e=t.apply(this.outputs[0]);if(Array.isArray(e))throw new TypeError("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(t),this.outputs=[e],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}this.layers.push(t),this.built=!1}pop(){if(0===this.layers.length)throw new TypeError("There are no layers in the model.");if(this.layers.pop(),0===this.layers.length)this.outputs=[],this.inboundNodes=[],this.outboundNodes=[];else{const t=this.layers.length-1;this.layers[t].outboundNodes=[],this.outputs=[this.layers[t].output],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}}call(t,e){return null==this.model&&this.build(),this.model.call(t,e)}build(t){if(_e(t),0===this.inputs.length||0===this.outputs.length)throw new TypeError("Sequential model cannot be built: model is empty. Add some layers first.");this.model=new eh({inputs:this.inputs,outputs:this.outputs[0],name:this.name+"_model"}),this.model.trainable=this.trainable,this.supportsMasking=this.model.supportsMasking,this.inputLayers=this.model.inputLayers,this.inputLayersNodeIndices=this.model.inputLayersNodeIndices,this.inputLayersTensorIndices=this.model.inputLayersTensorIndices,this.outputLayers=this.model.outputLayers,this.outputLayersNodeIndices=this.model.outputLayersNodeIndices,this.outputLayersTensorIndices=this.model.outputLayersTensorIndices,this.nodesByDepth=this.model.nodesByDepth,this.containerNodes=this.model.containerNodes,this.outputNames=this.model.outputNames,this.inputNames=this.model.inputNames,this.built=!0}countParams(){return this.built||this.build(),super.countParams()}summary(t,e,n=console.log){this.built||this.build(),super.summary(t,e,n)}setWeights(t){null==this.model&&this.build(),this.model.setWeights(t)}evaluate(t,e,n={}){if(!this.built)throw new Z("The model needs to be compiled before being used.");return this.model.evaluate(t,e,n)}async evaluateDataset(t,e){if(!this.built)throw new Z("The model needs to be compiled before being used.");return this.model.evaluateDataset(t,e)}predict(t,e={}){return null==this.model&&this.build(),this.model.predict(t,e)}predictOnBatch(t){return null==this.model&&this.build(),this.model.predictOnBatch(t)}compile(t){this.build(),this.model.compile(t),this.optimizer_=this.model.optimizer,this.isOptimizerOwned=this.model.isOptimizerOwned,this.loss=this.model.loss,this.metrics=this.model.metrics,this.metricsTensors=this.model.metricsTensors,this.metricsNames=this.model.metricsNames}get optimizer(){return null==this.model?void 0:this.model.optimizer}set optimizer(t){this.model.optimizer=t}async fit(t,e,n={}){if(!this.built)throw new Z("The model needs to be compiled before being used.");return this.model.fit(t,e,n)}async fitDataset(t,e){if(!this.built)throw new Z("The model needs to be compiled before being used.");return this.model.fitDataset(t,e)}async trainOnBatch(t,e){return this.model.trainOnBatch(t,e)}static fromConfig(t,n,s={},r=!1){let i,a={};if(n instanceof Array){if(null==n[0].className||"Merge"===n[0].className)throw new Y("Legacy serialization format not supported yet.");i=n}else e.assert(null!=n.layers,(()=>"When the config data for a Sequential model is not an Array, it must be an Object that contains the 'layers' field.")),i=n.layers,delete n.layers,a=n;const o=new t(a);if(!(o instanceof rh))throw new X(`Sequential.fromConfig called on non-Sequential input: ${o}`);for(const t of i){const e=su(t,void 0,r);r&&e.setFastWeightInitDuringBuild(!0),o.add(e)}return o}set stopTraining(t){if(null==this.model)throw new Y("Cannot set the stopTraining property of a sequential model before it is compiled.");this.model.stopTraining=t}get stopTraining(){if(null==this.model)throw new Y("Cannot get the stopTraining property of a sequential model before it is compiled.");return this.model.stopTraining}getConfig(){const t=[];for(const e of this.layers){const n={};n.className=e.getClassName(),n.config=e.getConfig(),t.push(n)}return{name:this.name,layers:t}}}function ih(t){return new eh(t)}function ah(t){return new rh(t)}function oh(t){return je(t)}function lh(t,e){eu.registerCallbackConstructor(t,e)}rh.className="Sequential",i.registerClass(rh);class uh extends i.Serializable{getConfig(){return{}}}class hh extends uh{apply(e,n=1){return function(e,n=1){if(1!==n)throw new X(`Support for alpha values other than 1 (${n}) is not implemented yet.`);return t.elu(e)}(e,n)}}hh.className="elu",i.registerClass(hh);class ch extends uh{apply(e){return t.selu(e)}}ch.className="selu",i.registerClass(ch);class ph extends uh{apply(e){return t.relu(e)}}ph.className="relu",i.registerClass(ph);class dh extends uh{apply(e){return s((()=>t.minimum(6,t.relu(e))))}}dh.className="relu6",i.registerClass(dh);class fh extends uh{apply(t){return t}}fh.className="linear",i.registerClass(fh);class gh extends uh{apply(e){return t.sigmoid(e)}}gh.className="sigmoid",i.registerClass(gh);class mh extends uh{apply(e){return function(e){return s((()=>{const n=t.add(.5,t.mul(.2,e));return t.clipByValue(n,0,1)}))}(e)}}mh.className="hardSigmoid",i.registerClass(mh);class bh extends uh{apply(e){return t.softplus(e)}}bh.className="softplus",i.registerClass(bh);class yh extends uh{apply(e){return function(e){return s((()=>t.div(e,t.add(t.abs(e),1))))}(e)}}yh.className="softsign",i.registerClass(yh);class wh extends uh{apply(e){return t.tanh(e)}}wh.className="tanh",i.registerClass(wh);class kh extends uh{apply(e,n=-1){return t.softmax(e,n)}}kh.className="softmax",i.registerClass(kh);class vh extends uh{apply(e,n=-1){return t.logSoftmax(e,n)}}vh.className="logSoftmax",i.registerClass(vh);class xh extends uh{apply(e,n=1){return s((()=>t.mul(t.sigmoid(t.mul(e,n)),e)))}}xh.className="swish",i.registerClass(xh);class Sh extends uh{apply(e){return s((()=>t.mul(e,t.tanh(t.softplus(e)))))}}function Nh(t){return t.getClassName()}function Eh(t,e={}){return ct(t,i.SerializationMap.getMap().classNameMap,e,"activation")}function Ih(t){if(null==t){const t={className:"linear",config:{}};return Eh(t)}if("string"==typeof t){const e={};return e.className=t,e.config={},Eh(e)}return t instanceof uh?t:Eh(t)}function Ah(t){if(null!=t&&"object"!=typeof t)throw new Error(`Argument to L1L2 regularizer's constructor is expected to be an object, but received: ${t}`)}Sh.className="mish",i.registerClass(Sh);class Th extends i.Serializable{}class $h extends Th{constructor(t){super(),Ah(t),this.l1=null==t||null==t.l1?.01:t.l1,this.l2=null==t||null==t.l2?.01:t.l2,this.hasL1=0!==this.l1,this.hasL2=0!==this.l2}apply(e){return s((()=>{let n=a([1]);return this.hasL1&&(n=k(n,C(t.mul(this.l1,z(e))))),this.hasL2&&(n=k(n,C(t.mul(this.l2,ne(e))))),t.reshape(n,[])}))}getConfig(){return{l1:this.l1,l2:this.l2}}static fromConfig(t,e){return new t({l1:e.l1,l2:e.l2})}}$h.className="L1L2",i.registerClass($h);const Ch={l1l2:"L1L2"};function zh(t){return ut(t)}function _h(t,e={}){return ct(t,i.SerializationMap.getMap().classNameMap,e,"regularizer")}function Dh(t){if(null==t)return null;if("string"==typeof t){return _h({className:t in Ch?Ch[t]:t,config:{}})}return t instanceof Th?t:_h(t)}class Fh extends Ue{constructor(t){super(null==t?{}:t),this.supportsMasking=!0,null!=t&&(this.maxValue=t.maxValue)}call(t,e){t=ze(t);let n=_(t);return null!=this.maxValue&&(n=D(n,0,this.maxValue)),n}computeOutputShape(t){return t}getConfig(){const t={maxValue:this.maxValue},e=super.getConfig();return Object.assign(t,e),t}}Fh.className="ReLU",i.registerClass(Fh);class Rh extends Ue{constructor(t){super(null==t?{}:t),this.DEFAULT_ALPHA=.3,null==t&&(t={}),this.alpha=null==t.alpha?this.DEFAULT_ALPHA:t.alpha}call(t,e){const n=ze(t);return F(n,this.alpha)}computeOutputShape(t){return t}getConfig(){const t={alpha:this.alpha},e=super.getConfig();return Object.assign(t,e),t}}Rh.className="LeakyReLU",i.registerClass(Rh);class Mh extends Ue{constructor(t){if(super(null==t?{}:t),this.DEFAULT_ALPHA_INITIALIZER="zeros",null==t&&(t={}),this.supportsMasking=!0,this.alphaInitializer=Te(t.alphaInitializer||this.DEFAULT_ALPHA_INITIALIZER),this.alphaRegularizer=Dh(t.alphaRegularizer),this.alphaConstraint=Vl(t.alphaConstraint),null==t.sharedAxes)this.sharedAxes=null;else if(Array.isArray(t.sharedAxes))this.sharedAxes=t.sharedAxes;else{if("number"!=typeof t.sharedAxes)throw new Y(`Expected sharedAxes to be a number or an array of numbers, but got ${t.sharedAxes}`);this.sharedAxes=[t.sharedAxes]}}build(t){const e=(t=_e(t)).slice(1);if(null!=this.sharedAxes)for(const t of this.sharedAxes)e[t-1]=1;this.alpha=this.addWeight("alpha",e,"float32",this.alphaInitializer,this.alphaRegularizer,!0,this.alphaConstraint);const n={};if(null!=this.sharedAxes)for(let e=1;e<t.length;++e)n[e]=t[e];this.inputSpec=[new Le({ndim:t.length,axes:n})],this.built=!0}call(t,e){return t=ze(t),R(t,this.alpha.read())}getConfig(){const t={alphaInitializer:Ae(this.alphaInitializer),alphaRegularizer:zh(this.alphaRegularizer),alphaConstraint:Wl(this.alphaConstraint),sharedAxes:this.sharedAxes},e=super.getConfig();return Object.assign(t,e),t}}Mh.className="PReLU",i.registerClass(Mh);class Lh extends Ue{constructor(t){if(super(null==t?{}:t),this.DEFAULT_ALPHA=1,null==t&&(t={}),null!=t.alpha&&t.alpha!==this.DEFAULT_ALPHA)throw new X(`Non-default alpha value (${t.alpha}) is not supported by the ELU layer yet.`);this.alpha=null==t.alpha?this.DEFAULT_ALPHA:t.alpha}call(t,e){const n=ze(t);return M(n)}computeOutputShape(t){return t}getConfig(){const t={alpha:this.alpha},e=super.getConfig();return Object.assign(t,e),t}}Lh.className="ELU",i.registerClass(Lh);class Oh extends Ue{constructor(t){super(null==t?{}:t),this.DEFAULT_THETA=1,null==t&&(t={}),this.theta=null==t.theta?this.DEFAULT_THETA:t.theta}call(t,e){const n=ze(t);return l(n,b(L(n,this.theta),"float32"))}computeOutputShape(t){return t}getConfig(){const t={theta:this.theta},e=super.getConfig();return Object.assign(t,e),t}}Oh.className="ThresholdedReLU",i.registerClass(Oh);class Bh extends Ue{constructor(t){super(null==t?{}:t),this.DEFAULT_AXIS=1,null==t&&(t={}),this.softmax=(new kh).apply,this.axis=null==t.axis?this.DEFAULT_AXIS:t.axis}call(t,e){const n=ze(t);return this.softmax(n,this.axis)}computeOutputShape(t){return t}getConfig(){const t={axis:this.axis},e=super.getConfig();return Object.assign(t,e),t}}function Ph(t,e,n){if("number"==typeof t)return et(t,e);if(t.length!==e)throw new Y(`The ${n} argument must be an integer or tuple of ${e} integers. Received: ${t.length} elements.`);for(let r=0;r<e;++r){const i=t[r];if((s=i)!==parseInt(s.toString(),10))throw new Y(`The ${n} argument must be an integer or tuple of ${e} integers. Received: ${JSON.stringify(t)} including a non-integer number ${i}`)}return t;var s}function Wh(t,e,n,s,r=1){if(null==t)return t;let i;return i="same"===n?t:t-(e+(e-1)*(r-1))+1,Math.floor((i+s-1)/s)}function Uh(t,e,n,s){if(null==t)return null;if("valid"===s)t=t*e+Wt([n-e,0]);else{if("same"!==s)throw new Y(`Unsupport padding mode: ${s}.`);t*=e}return t}function Vh(e,n){return s((()=>(Ct(n),"channelsFirst"===n?t.transpose(e,[0,2,3,1]):e)))}function Kh(e,n){return s((()=>(Ct(n),"channelsFirst"===n?t.transpose(e,[0,2,3,4,1]):e)))}function jh(e,n,r,i=[1,1],a="valid",o,l,u=null){return s((()=>{if(null==o&&(o="channelsLast"),Ct(o),3!==e.rank&&4!==e.rank)throw new Y(`conv2dWithBiasActivation expects input to be of rank 3 or 4, but received ${e.rank}.`);if(3!==n.rank&&4!==n.rank)throw new Y(`conv2dWithBiasActivation expects kernel to be of rank 3 or 4, but received ${e.rank}.`);let s=Vh(e,o);if("causal"===a)throw new X("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");return s=t.fused.conv2d({x:s,filter:n,strides:i,pad:"same"===a?"same":"valid",dilations:l,dataFormat:"NHWC",bias:r,activation:u}),"channelsFirst"===o&&(s=t.transpose(s,[0,3,1,2])),s}))}Bh.className="Softmax",i.registerClass(Bh);class qh extends Ue{constructor(t,e){if(super(e),this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",qh.verifyArgs(e),this.rank=t,bt(this.rank,"rank"),1!==this.rank&&2!==this.rank&&3!==this.rank)throw new X(`Convolution layer for rank other than 1, 2, or 3 (${this.rank}) is not implemented yet.`);if(this.kernelSize=Ph(e.kernelSize,t,"kernelSize"),this.strides=Ph(null==e.strides?1:e.strides,t,"strides"),this.padding=null==e.padding?"valid":e.padding,zt(this.padding),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,Ct(this.dataFormat),this.activation=Ih(e.activation),this.useBias=null==e.useBias||e.useBias,this.biasInitializer=Te(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.biasConstraint=Vl(e.biasConstraint),this.biasRegularizer=Dh(e.biasRegularizer),this.activityRegularizer=Dh(e.activityRegularizer),this.dilationRate=Ph(null==e.dilationRate?1:e.dilationRate,t,"dilationRate"),1===this.rank&&Array.isArray(this.dilationRate)&&1!==this.dilationRate.length)throw new Y(`dilationRate must be a number or an array of a single number for 1D convolution, but received ${JSON.stringify(this.dilationRate)}`);if(2===this.rank){if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate];else if(2!==this.dilationRate.length)throw new Y(`dilationRate must be a number or array of two numbers for 2D convolution, but received ${JSON.stringify(this.dilationRate)}`)}else if(3===this.rank)if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate,this.dilationRate];else if(3!==this.dilationRate.length)throw new Y(`dilationRate must be a number or array of three numbers for 3D convolution, but received ${JSON.stringify(this.dilationRate)}`)}static verifyArgs(t){if(nt("kernelSize"in t,"required key 'kernelSize' not in config"),"number"!=typeof t.kernelSize&&!mt(t.kernelSize,"number",1,3))throw new Y(`BaseConv expects config.kernelSize to be number or number[] with length 1, 2, or 3, but received ${JSON.stringify(t.kernelSize)}.`)}getConfig(){const t={kernelSize:this.kernelSize,strides:this.strides,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,activation:Nh(this.activation),useBias:this.useBias,biasInitializer:Ae(this.biasInitializer),biasRegularizer:zh(this.biasRegularizer),activityRegularizer:zh(this.activityRegularizer),biasConstraint:Wl(this.biasConstraint)},e=super.getConfig();return Object.assign(t,e),t}}class Gh extends qh{constructor(t,e){super(t,e),this.kernel=null,Gh.verifyArgs(e),this.filters=e.filters,bt(this.filters,"filters"),this.kernelInitializer=Te(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.kernelConstraint=Vl(e.kernelConstraint),this.kernelRegularizer=Dh(e.kernelRegularizer)}build(t){t=_e(t);const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new Y(`The channel dimension of the input should be defined. Found ${t[e]}`);const n=t[e],s=this.kernelSize.concat([n,this.filters]);this.kernel=this.addWeight("kernel",s,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[{ndim:this.rank+2,axes:{[e]:n}}],this.built=!0}call(e,n){return s((()=>{let n;e=ze(e);const r=null==this.bias?null:this.bias.read(),i=wt(this.activation.getClassName());if(null!=i&&2===this.rank)n=jh(e,this.kernel.read(),r,this.strides,this.padding,this.dataFormat,this.dilationRate,i);else{if(1===this.rank)n=function(e,n,r,i=1,a="valid",o,l=1){return s((()=>{if(null==o&&(o="channelsLast"),Ct(o),3!==e.shape.length)throw new Y(`The input of a conv1dWithBias operation should be 3, but is ${e.shape.length} instead.`);if(3!==n.shape.length)throw new Y(`The kernel for a conv1dWithBias operation should be 3, but is ${n.shape.length} instead`);if(null!=r&&1!==r.shape.length)throw new Y(`The bias for a conv1dWithBias operation should be 1, but is ${n.shape.length} instead`);if("channelsFirst"===o&&(e=t.transpose(e,[0,2,1])),"causal"===a)throw new X("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");let s=t.conv1d(e,n,i,"same"===a?"same":"valid","NWC",l);return null!=r&&(s=re(s,r)),s}))}(e,this.kernel.read(),r,this.strides[0],this.padding,this.dataFormat,this.dilationRate[0]);else if(2===this.rank)n=jh(e,this.kernel.read(),r,this.strides,this.padding,this.dataFormat,this.dilationRate);else{if(3!==this.rank)throw new X("convolutions greater than 3D are not implemented yet.");n=function(e,n,r,i=[1,1,1],a="valid",o,l){return s((()=>{if(null==o&&(o="channelsLast"),Ct(o),4!==e.rank&&5!==e.rank)throw new Y(`conv3dWithBias expects input to be of rank 4 or 5, but received ${e.rank}.`);if(4!==n.rank&&5!==n.rank)throw new Y(`conv3dWithBias expects kernel to be of rank 4 or 5, but received ${e.rank}.`);let s=Kh(e,o);if("causal"===a)throw new X("The support for CAUSAL padding mode in conv3dWithBias is not implemented yet.");return s=t.conv3d(s,n,i,"same"===a?"same":"valid","NDHWC",l),null!=r&&(s=re(s,r)),"channelsFirst"===o&&(s=t.transpose(s,[0,4,1,2,3])),s}))}(e,this.kernel.read(),r,this.strides,this.padding,this.dataFormat,this.dilationRate)}null!=this.activation&&(n=this.activation.apply(n))}return n}))}computeOutputShape(t){t=_e(t);const e=[],n="channelsLast"===this.dataFormat?t.slice(1,t.length-1):t.slice(2);for(let t=0;t<n.length;++t){const s=Wh(n[t],this.kernelSize[t],this.padding,this.strides[t],"number"==typeof this.dilationRate?this.dilationRate:this.dilationRate[t]);e.push(s)}let s=[t[0]];return"channelsLast"===this.dataFormat?(s=s.concat(e),s.push(this.filters)):(s.push(this.filters),s=s.concat(e)),s}getConfig(){const t={filters:this.filters,kernelInitializer:Ae(this.kernelInitializer),kernelRegularizer:zh(this.kernelRegularizer),kernelConstraint:Wl(this.kernelConstraint)},e=super.getConfig();return Object.assign(t,e),t}static verifyArgs(t){if(!("filters"in t)||"number"!=typeof t.filters||t.filters<1)throw new Y(`Convolution layer expected config.filters to be a 'number' > 0 but got ${JSON.stringify(t.filters)}`)}}class Hh extends Gh{constructor(t){super(2,t),Hh.verifyArgs(t)}getConfig(){const t=super.getConfig();return delete t.rank,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&!mt(t.kernelSize,"number",1,2))throw new Y(`Conv2D expects config.kernelSize to be number or number[] with length 1 or 2, but received ${JSON.stringify(t.kernelSize)}.`)}}Hh.className="Conv2D",i.registerClass(Hh);class Jh extends Gh{constructor(t){super(3,t),Jh.verifyArgs(t)}getConfig(){const t=super.getConfig();return delete t.rank,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&(!Array.isArray(t.kernelSize)||1!==t.kernelSize.length&&3!==t.kernelSize.length))throw new Y(`Conv3D expects config.kernelSize to be number or [number, number, number], but received ${JSON.stringify(t.kernelSize)}.`)}}Jh.className="Conv3D",i.registerClass(Jh);class Zh extends Hh{constructor(t){if(super(t),this.inputSpec=[new Le({ndim:4})],"same"!==this.padding&&"valid"!==this.padding)throw new Y(`Conv2DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(t){if(4!==(t=_e(t)).length)throw new Y("Input should have rank 4; Received input shape: "+JSON.stringify(t));const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new Y("The channel dimension of the inputs should be defined. Found `None`.");const n=t[e],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new Le({ndim:4,axes:{[e]:n}})],this.built=!0}call(e,n){return t.tidy((()=>{let n=ze(e);if(4!==n.shape.length)throw new Y(`Conv2DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${n.shape.length}`);const s=n.shape,r=s[0];let i,a;"channelsFirst"===this.dataFormat?(i=2,a=3):(i=1,a=2);const o=s[i],l=s[a],u=this.kernelSize[0],h=this.kernelSize[1],c=this.strides[0],p=this.strides[1],d=[r,Uh(o,c,u,this.padding),Uh(l,p,h,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(n=t.transpose(n,[0,2,3,1]));let f=t.conv2dTranspose(n,this.kernel.read(),d,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(f=t.transpose(f,[0,3,1,2])),null!=this.bias&&(f=re(f,this.bias.read(),this.dataFormat)),null!=this.activation&&(f=this.activation.apply(f)),f}))}computeOutputShape(t){const e=(t=_e(t)).slice();let n,s,r;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3):(n=3,s=1,r=2);const i=this.kernelSize[0],a=this.kernelSize[1],o=this.strides[0],l=this.strides[1];return e[n]=this.filters,e[s]=Uh(e[s],o,i,this.padding),e[r]=Uh(e[r],l,a,this.padding),e}getConfig(){const t=super.getConfig();return delete t.dilationRate,t}}Zh.className="Conv2DTranspose",i.registerClass(Zh);class Yh extends Jh{constructor(t){if(super(t),this.inputSpec=[new Le({ndim:5})],"same"!==this.padding&&"valid"!==this.padding)throw new Y(`Conv3DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(t){if(5!==(t=_e(t)).length)throw new Y("Input should have rank 5; Received input shape: "+JSON.stringify(t));const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new Y("The channel dimension of the inputs should be defined. Found `None`.");const n=t[e],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new Le({ndim:5,axes:{[e]:n}})],this.built=!0}call(e,n){return t.tidy((()=>{let n=ze(e);if(5!==n.shape.length)throw new Y(`Conv3DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${n.shape.length}`);const s=n.shape,r=s[0];let i,a,o;"channelsFirst"===this.dataFormat?(o=2,i=3,a=4):(o=1,i=2,a=3);const l=s[o],u=s[i],h=s[a],c=this.kernelSize[0],p=this.kernelSize[1],d=this.kernelSize[2],f=this.strides[0],g=this.strides[1],m=this.strides[2],b=[r,Uh(l,f,c,this.padding),Uh(u,g,p,this.padding),Uh(h,m,d,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(n=t.transpose(n,[0,2,3,4,1]));let y=t.conv3dTranspose(n,this.kernel.read(),b,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(y=t.transpose(y,[0,4,1,2,3])),null!==this.bias&&(y=re(y,this.bias.read(),this.dataFormat)),null!==this.activation&&(y=this.activation.apply(y)),y}))}computeOutputShape(t){const e=(t=_e(t)).slice();let n,s,r,i;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3,i=4):(n=4,s=1,r=2,i=3);const a=this.kernelSize[0],o=this.kernelSize[1],l=this.kernelSize[2],u=this.strides[0],h=this.strides[1],c=this.strides[2];return e[n]=this.filters,e[s]=Uh(e[s],u,a,this.padding),e[r]=Uh(e[r],h,o,this.padding),e[i]=Uh(e[i],c,l,this.padding),e}getConfig(){const t=super.getConfig();return delete t.dilationRate,t}}Yh.className="Conv3DTranspose",i.registerClass(Yh);class Xh extends Gh{constructor(t,e){if(super(t,e),this.DEFAULT_DEPTHWISE_INITIALIZER="glorotUniform",this.DEFAULT_POINTWISE_INITIALIZER="glorotUniform",this.depthwiseKernel=null,this.pointwiseKernel=null,null==e.filters)throw new Y("The `filters` configuration field is required by SeparableConv, but is unspecified.");if(null!=e.kernelInitializer||null!=e.kernelRegularizer||null!=e.kernelConstraint)throw new Y("Fields kernelInitializer, kernelRegularizer and kernelConstraint are invalid for SeparableConv2D. Use depthwiseInitializer, depthwiseRegularizer, depthwiseConstraint, pointwiseInitializer, pointwiseRegularizer and pointwiseConstraint instead.");if(null!=e.padding&&"same"!==e.padding&&"valid"!==e.padding)throw new Y(`SeparableConv${this.rank}D supports only padding modes: 'same' and 'valid', but received ${JSON.stringify(e.padding)}`);this.depthMultiplier=null==e.depthMultiplier?1:e.depthMultiplier,this.depthwiseInitializer=Te(e.depthwiseInitializer||this.DEFAULT_DEPTHWISE_INITIALIZER),this.depthwiseRegularizer=Dh(e.depthwiseRegularizer),this.depthwiseConstraint=Vl(e.depthwiseConstraint),this.pointwiseInitializer=Te(e.depthwiseInitializer||this.DEFAULT_POINTWISE_INITIALIZER),this.pointwiseRegularizer=Dh(e.pointwiseRegularizer),this.pointwiseConstraint=Vl(e.pointwiseConstraint)}build(t){if((t=_e(t)).length<this.rank+2)throw new Y(`Inputs to SeparableConv${this.rank}D should have rank ${this.rank+2}, but received input shape: ${JSON.stringify(t)}`);const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e]||t[e]<0)throw new Y(`The channel dimension of the inputs should be defined, but found ${JSON.stringify(t[e])}`);const n=t[e],s=this.kernelSize.concat([n,this.depthMultiplier]),r=[];for(let t=0;t<this.rank;++t)r.push(1);r.push(n*this.depthMultiplier,this.filters);const i=!0;this.depthwiseKernel=this.addWeight("depthwise_kernel",s,"float32",this.depthwiseInitializer,this.depthwiseRegularizer,i,this.depthwiseConstraint),this.pointwiseKernel=this.addWeight("pointwise_kernel",r,"float32",this.pointwiseInitializer,this.pointwiseRegularizer,i,this.pointwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,i,this.biasConstraint):this.bias=null,this.inputSpec=[new Le({ndim:this.rank+2,axes:{[e]:n}})],this.built=!0}call(e,n){return s((()=>{let n;if(e=ze(e),1===this.rank)throw new X("1D separable convolution is not implemented yet.");return 2===this.rank&&("channelsFirst"===this.dataFormat&&(e=t.transpose(e,[0,2,3,1])),n=t.separableConv2d(e,this.depthwiseKernel.read(),this.pointwiseKernel.read(),this.strides,this.padding,this.dilationRate,"NHWC")),this.useBias&&(n=re(n,this.bias.read(),this.dataFormat)),null!=this.activation&&(n=this.activation.apply(n)),"channelsFirst"===this.dataFormat&&(n=t.transpose(n,[0,3,1,2])),n}))}getConfig(){const t=super.getConfig();return delete t.rank,delete t.kernelInitializer,delete t.kernelRegularizer,delete t.kernelConstraint,t.depthwiseInitializer=Ae(this.depthwiseInitializer),t.pointwiseInitializer=Ae(this.pointwiseInitializer),t.depthwiseRegularizer=zh(this.depthwiseRegularizer),t.pointwiseRegularizer=zh(this.pointwiseRegularizer),t.depthwiseConstraint=Wl(this.depthwiseConstraint),t.pointwiseConstraint=Wl(this.pointwiseConstraint),t}}Xh.className="SeparableConv";class Qh extends Xh{constructor(t){super(2,t)}}Qh.className="SeparableConv2D",i.registerClass(Qh);class tc extends Gh{constructor(t){super(1,t),tc.verifyArgs(t),this.inputSpec=[{ndim:3}]}getConfig(){const t=super.getConfig();return delete t.rank,delete t.dataFormat,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&!mt(t.kernelSize,"number",1,1))throw new Y(`Conv1D expects config.kernelSize to be number or number[] with length 1, but received ${JSON.stringify(t.kernelSize)}.`)}}tc.className="Conv1D",i.registerClass(tc);class ec extends Ue{constructor(t){super(t),"number"==typeof t.cropping?this.cropping=[[t.cropping,t.cropping],[t.cropping,t.cropping]]:"number"==typeof t.cropping[0]?this.cropping=[[t.cropping[0],t.cropping[0]],[t.cropping[1],t.cropping[1]]]:this.cropping=t.cropping,this.dataFormat=void 0===t.dataFormat?"channelsLast":t.dataFormat,this.inputSpec=[{ndim:4}]}computeOutputShape(t){return"channelsFirst"===this.dataFormat?[t[0],t[1],t[2]-this.cropping[0][0]-this.cropping[0][1],t[3]-this.cropping[1][0]-this.cropping[1][1]]:[t[0],t[1]-this.cropping[0][0]-this.cropping[0][1],t[2]-this.cropping[1][0]-this.cropping[1][1],t[3]]}call(t,e){return s((()=>{if(t=ze(t),"channelsLast"===this.dataFormat){const e=Jt(t,this.cropping[0][0],t.shape[1]-this.cropping[0][0]-this.cropping[0][1],2);return Jt(e,this.cropping[1][0],t.shape[2]-this.cropping[1][1]-this.cropping[1][0],3)}{const e=Jt(t,this.cropping[0][0],t.shape[2]-this.cropping[0][0]-this.cropping[0][1],3);return Jt(e,this.cropping[1][0],t.shape[3]-this.cropping[1][1]-this.cropping[1][0],4)}}))}getConfig(){const t={cropping:this.cropping,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}ec.className="Cropping2D",i.registerClass(ec);class nc extends Ue{constructor(t){var e;super(t),this.DEFAULT_SIZE=[2,2],this.inputSpec=[{ndim:4}],this.size=null==t.size?this.DEFAULT_SIZE:t.size,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,Ct(this.dataFormat),this.interpolation=null==t.interpolation?"nearest":t.interpolation,e=this.interpolation,gt(Et,"InterpolationFormat",e)}computeOutputShape(t){if("channelsFirst"===this.dataFormat){const e=null==t[2]?null:this.size[0]*t[2],n=null==t[3]?null:this.size[1]*t[3];return[t[0],t[1],e,n]}{const e=null==t[1]?null:this.size[0]*t[1],n=null==t[2]?null:this.size[1]*t[2];return[t[0],e,n,t[3]]}}call(e,n){return t.tidy((()=>{let n=ze(e);const s=n.shape;if("channelsFirst"===this.dataFormat){n=t.transpose(n,[0,2,3,1]);const e=this.size[0]*s[2],r=this.size[1]*s[3],i="nearest"===this.interpolation?t.image.resizeNearestNeighbor(n,[e,r]):t.image.resizeBilinear(n,[e,r]);return t.transpose(i,[0,3,1,2])}{const e=this.size[0]*s[1],r=this.size[1]*s[2];return"nearest"===this.interpolation?t.image.resizeNearestNeighbor(n,[e,r]):t.image.resizeBilinear(n,[e,r])}}))}getConfig(){const t={size:this.size,dataFormat:this.dataFormat,interpolation:this.interpolation},e=super.getConfig();return Object.assign(t,e),t}}nc.className="UpSampling2D",i.registerClass(nc);class sc extends qh{constructor(t){super(2,t),this.depthwiseKernel=null,this.depthMultiplier=null==t.depthMultiplier?1:t.depthMultiplier,this.depthwiseInitializer=Te(t.depthwiseInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.depthwiseConstraint=Vl(t.depthwiseConstraint),this.depthwiseRegularizer=Dh(t.depthwiseRegularizer)}build(t){if((t=_e(t)).length<4)throw new Y(`Inputs to DepthwiseConv2D should have rank 4. Received input shape: ${JSON.stringify(t)}.`);const e="channelsFirst"===this.dataFormat?1:3;if(null==t[e]||t[e]<0)throw new Y(`The channel dimension of the inputs to DepthwiseConv2D should be defined, but is not (${t[e]}).`);const n=t[e],s=[this.kernelSize[0],this.kernelSize[1],n,this.depthMultiplier];this.depthwiseKernel=this.addWeight("depthwise_kernel",s,null,this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[n*this.depthMultiplier],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,n){return s((()=>{let n=function(e,n,r=[1,1],i="valid",a,o){return s((()=>{null==a&&(a="channelsLast"),Ct(a);let s=Vh(e,a);if(4!==e.rank)throw new Y(`Input for depthwiseConv2d is required to be 4-D, but is instead ${e.rank}-D`);if(4!==n.rank)throw new Y(`depthwiseKernel is required to be 4-D, but is instead ${n.rank}-D`);return s=t.depthwiseConv2d(s,n,r,"same"===i?"same":"valid","NHWC",o),"channelsFirst"===a&&(s=t.transpose(s,[0,3,1,2])),s}))}(e=ze(e),this.depthwiseKernel.read(),this.strides,this.padding,this.dataFormat,null);return this.useBias&&(n=re(n,this.bias.read(),this.dataFormat)),null!=this.activation&&(n=this.activation.apply(n)),n}))}computeOutputShape(t){t=_e(t);const e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2],s="channelsFirst"===this.dataFormat?t[1]*this.depthMultiplier:t[3]*this.depthMultiplier,r=Wh(e,this.kernelSize[0],this.padding,this.strides[0]),i=Wh(n,this.kernelSize[1],this.padding,this.strides[1]);return"channelsFirst"===this.dataFormat?[t[0],s,r,i]:[t[0],r,i,s]}getConfig(){const t=super.getConfig();return t.depthMultiplier=this.depthMultiplier,t.depthwiseInitializer=Ae(this.depthwiseInitializer),t.depthwiseRegularizer=zh(this.depthwiseRegularizer),t.depthwiseConstraint=Wl(this.depthwiseRegularizer),t}}function rc(t,e,n,s){if(Array.isArray(t)){if(null!=e||null!=n)throw new Y("When inputs is an array, neither initialState or constants should be provided");null!=s&&(n=t.slice(t.length-s,t.length),t=t.slice(0,t.length-s)),t.length>1&&(e=t.slice(1,t.length)),t=t[0]}function r(t){return null==t||Array.isArray(t)?t:[t]}return{inputs:t,initialState:e=r(e),constants:n=r(n)}}function ic(e,n,s,r=!1,i,a,o=!1,l=!1){return t.tidy((()=>{const u=n.shape.length;if(u<3)throw new Y(`Input should be at least 3D, but is ${u}D.`);const h=[1,0].concat(Ut(2,u));if(n=t.transpose(n,h),null!=a)throw new X("The rnn() functoin of the deeplearn.js backend does not support constants yet.");o&&console.warn("Backend rnn(): the unroll = true option is not applicable to the imperative deeplearn.js backend."),null!=i&&((i=t.cast(t.cast(i,"bool"),"float32")).rank===u-1&&(i=t.expandDims(i,-1)),i=t.transpose(i,h)),r&&(n=t.reverse(n,0),null!=i&&(i=t.reverse(i,0)));const c=[];let p,d=s;const f=n.shape[0],g=t.unstack(n);let m,b;null!=i&&(m=t.unstack(i));for(let n=0;n<f;++n){const s=g[n],r=t.tidy((()=>e(s,d)));if(null==i)p=r[0],d=r[1];else{const e=t.tidy((()=>{const e=m[n],s=t.sub(t.onesLike(e),e);return{output:t.add(t.mul(r[0],e),t.mul(d[0],s)),newStates:d.map(((n,i)=>t.add(t.mul(r[1][i],e),t.mul(n,s))))}}));p=e.output,d=e.newStates}l&&c.push(p)}if(l){const e=1;b=t.stack(c,e)}return[p,b,d]}))}sc.className="DepthwiseConv2D",i.registerClass(sc);class ac extends Ue{constructor(t){let e;if(super(t),null==t.cell)throw new Y("cell property is missing for the constructor of RNN.");if(e=Array.isArray(t.cell)?new fc({cells:t.cell}):t.cell,null==e.stateSize)throw new Y("The RNN cell should have an attribute `stateSize` (tuple of integers, one integer per RNN state).");this.cell=e,this.returnSequences=null!=t.returnSequences&&t.returnSequences,this.returnState=null!=t.returnState&&t.returnState,this.goBackwards=null!=t.goBackwards&&t.goBackwards,this._stateful=null!=t.stateful&&t.stateful,this.unroll=null!=t.unroll&&t.unroll,this.supportsMasking=!0,this.inputSpec=[new Le({ndim:3})],this.stateSpec=null,this.states_=null,this.numConstants=null,this.keptStates=[]}getStates(){if(null==this.states_){return Ut(0,Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1).map((t=>null))}return this.states_}setStates(t){this.states_=t}computeOutputShape(t){$e(t)&&(t=t[0]);let e=this.cell.stateSize;Array.isArray(e)||(e=[e]);const n=e[0];let s;if(s=this.returnSequences?[t[0],t[1],n]:[t[0],n],this.returnState){const n=[];for(const s of e)n.push([t[0],s]);return[s].concat(n)}return s}computeMask(e,n){return t.tidy((()=>{Array.isArray(n)&&(n=n[0]);const t=this.returnSequences?n:null;if(this.returnState){const e=this.states.map((t=>null));return[t].concat(e)}return t}))}get states(){if(null==this.states_){const t=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1,e=[];for(let n=0;n<t;++n)e.push(null);return e}return this.states_}set states(t){this.states_=t}build(t){if(null!=this.numConstants)throw new X("Constants support is not implemented in RNN yet.");$e(t)&&(t=t[0]);const n=this.stateful?t[0]:null,s=t.slice(2);this.inputSpec[0]=new Le({shape:[n,null,...s]});const r=[t[0]].concat(t.slice(2));let i;if(this.cell.build(r),i=Array.isArray(this.cell.stateSize)?this.cell.stateSize:[this.cell.stateSize],null!=this.stateSpec){if(!e.arraysEqual(this.stateSpec.map((t=>t.shape[t.shape.length-1])),i))throw new Y(`An initialState was passed that is not compatible with cell.stateSize. Received stateSpec=${this.stateSpec}; However cell.stateSize is ${this.cell.stateSize}`)}else this.stateSpec=i.map((t=>new Le({shape:[null,t]})));this.stateful&&this.resetStates()}resetStates(n,r=!1){s((()=>{if(!this.stateful)throw new J("Cannot call resetStates() on an RNN Layer that is not stateful.");const s=this.inputSpec[0].shape[0];if(null==s)throw new Y("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.states_)Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((e=>t.zeros([s,e]))):this.states_=[t.zeros([s,this.cell.stateSize])];else if(null==n)t.dispose(this.states_),null!=this.keptStates&&(t.dispose(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((e=>t.zeros([s,e]))):this.states_[0]=t.zeros([s,this.cell.stateSize]);else{if(Array.isArray(n)||(n=[n]),n.length!==this.states_.length)throw new Y(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${n.length} state value(s). Input received: ${n}`);!0===r?this.keptStates.push(this.states_.slice()):t.dispose(this.states_);for(let t=0;t<this.states_.length;++t){const r=n[t],i=Array.isArray(this.cell.stateSize)?this.cell.stateSize[t]:this.cell.stateSize,a=[s,i];if(!e.arraysEqual(r.shape,a))throw new Y(`State ${t} is incompatible with layer ${this.name}: expected shape=${a}, received shape=${r.shape}`);this.states_[t]=r}}this.states_=this.states_.map((e=>t.keep(e.clone())))}))}apply(t,e){let n=null==e?null:e.initialState,s=null==e?null:e.constants;null==e&&(e={});const r=rc(t,n,s,this.numConstants);t=r.inputs,n=r.initialState,s=r.constants;let i=[],a=[];if(null!=n){e.initialState=n,i=i.concat(n),this.stateSpec=[];for(const t of n)this.stateSpec.push(new Le({shape:t.shape}));a=a.concat(this.stateSpec)}null!=s&&(e.constants=s,i=i.concat(s),this.numConstants=s.length);if(i[0]instanceof Oe){const n=[t].concat(i),s=this.inputSpec.concat(a),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,e);return this.inputSpec=r,o}return super.apply(t,e)}call(t,e){return s((()=>{const n=null==e?null:e.mask,s=null==e?null:e.training;let r=null==e?null:e.initialState;t=ze(t),null==r&&(r=this.stateful?this.states_:this.getInitialState(t));const i=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1;if(r.length!==i)throw new Y(`RNN Layer has ${i} state(s) but was passed ${r.length} initial state(s).`);this.unroll&&console.warn("Ignoring unroll = true for RNN layer, due to imperative backend.");const a={training:s},o=ic(((t,e)=>{const n=this.cell.call([t].concat(e),a);return[n[0],n.slice(1)]}),t,r,this.goBackwards,n,null,this.unroll,this.returnSequences),l=o[0],u=o[1],h=o[2];this.stateful&&this.resetStates(h,s);const c=this.returnSequences?u:l;return this.returnState?[c].concat(h):c}))}getInitialState(e){return s((()=>{let n=t.zeros(e.shape);return n=t.sum(n,[1,2]),n=qt(n),Array.isArray(this.cell.stateSize)?this.cell.stateSize.map((t=>t>1?Xt(n,[1,t]):n)):this.cell.stateSize>1?[Xt(n,[1,this.cell.stateSize])]:[n]}))}get trainableWeights(){return this.trainable?this.cell.trainableWeights:[]}get nonTrainableWeights(){return this.trainable?this.cell.nonTrainableWeights:this.cell.weights}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.cell&&this.cell.setFastWeightInitDuringBuild(t)}getConfig(){const t=super.getConfig(),e={returnSequences:this.returnSequences,returnState:this.returnState,goBackwards:this.goBackwards,stateful:this.stateful,unroll:this.unroll};null!=this.numConstants&&(e.numConstants=this.numConstants);const n=this.cell.getConfig();return this.getClassName()===ac.className&&(e.cell={className:this.cell.getClassName(),config:n}),Object.assign(Object.assign(Object.assign({},n),t),e)}static fromConfig(t,e,n={}){const s=su(e.cell,n);return new t(Object.assign(e,{cell:s}))}}ac.className="RNN",i.registerClass(ac);class oc extends Ue{}class lc extends oc{constructor(t){super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=t.units,bt(this.units,"units"),this.activation=Ih(null==t.activation?this.DEFAULT_ACTIVATION:t.activation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=Te(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Te(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Te(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Dh(t.kernelRegularizer),this.recurrentRegularizer=Dh(t.recurrentRegularizer),this.biasRegularizer=Dh(t.biasRegularizer),this.kernelConstraint=Vl(t.kernelConstraint),this.recurrentConstraint=Vl(t.recurrentConstraint),this.biasConstraint=Vl(t.biasConstraint),this.dropout=Pt([1,Wt([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=Pt([1,Wt([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.dropoutFunc=t.dropoutFunc,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){t=_e(t),this.kernel=this.addWeight("kernel",[t[t.length-1],this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,n){return s((()=>{if(2!==e.length)throw new Y(`SimpleRNNCell expects 2 input Tensors, got ${e.length}.`);let s=e[1];e=e[0];const r=null!=n.training&&n.training;let i;0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=gc({ones:()=>t.onesLike(e),rate:this.dropout,training:r,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=gc({ones:()=>t.onesLike(s),rate:this.recurrentDropout,training:r,dropoutFunc:this.dropoutFunc}));const a=this.dropoutMask,o=this.recurrentDropoutMask;i=te(null!=a?t.mul(e,a):e,this.kernel.read()),null!=this.bias&&(i=re(i,this.bias.read())),null!=o&&(s=t.mul(s,o));let l=t.add(i,te(s,this.recurrentKernel.read()));return null!=this.activation&&(l=this.activation.apply(l)),[l,l]}))}getConfig(){const t=super.getConfig(),e={units:this.units,activation:Nh(this.activation),useBias:this.useBias,kernelInitializer:Ae(this.kernelInitializer),recurrentInitializer:Ae(this.recurrentInitializer),biasInitializer:Ae(this.biasInitializer),kernelRegularizer:zh(this.kernelRegularizer),recurrentRegularizer:zh(this.recurrentRegularizer),biasRegularizer:zh(this.biasRegularizer),activityRegularizer:zh(this.activityRegularizer),kernelConstraint:Wl(this.kernelConstraint),recurrentConstraint:Wl(this.recurrentConstraint),biasConstraint:Wl(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout};return Object.assign(Object.assign({},t),e)}}lc.className="SimpleRNNCell",i.registerClass(lc);class uc extends ac{constructor(t){t.cell=new lc(t),super(t)}call(e,n){return s((()=>{null!=this.cell.dropoutMask&&(t.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(t.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const s=null==n?null:n.mask,r=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(e,{mask:s,training:r,initialState:i})}))}static fromConfig(t,e){return new t(e)}}uc.className="SimpleRNN",i.registerClass(uc);class hc extends oc{constructor(t){if(super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",t.resetAfter)throw new Y("GRUCell does not support reset_after parameter set to true.");this.units=t.units,bt(this.units,"units"),this.activation=Ih(void 0===t.activation?this.DEFAULT_ACTIVATION:t.activation),this.recurrentActivation=Ih(void 0===t.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:t.recurrentActivation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=Te(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Te(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Te(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Dh(t.kernelRegularizer),this.recurrentRegularizer=Dh(t.recurrentRegularizer),this.biasRegularizer=Dh(t.biasRegularizer),this.kernelConstraint=Vl(t.kernelConstraint),this.recurrentConstraint=Vl(t.recurrentConstraint),this.biasConstraint=Vl(t.biasConstraint),this.dropout=Pt([1,Wt([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=Pt([1,Wt([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.dropoutFunc=t.dropoutFunc,this.implementation=t.implementation,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){const e=(t=_e(t))[t.length-1];this.kernel=this.addWeight("kernel",[e,3*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,3*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[3*this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,n){return s((()=>{if(2!==e.length)throw new Y(`GRUCell expects 2 input Tensors (inputs, h, c), got ${e.length}.`);const s=null!=n.training&&n.training;let r=e[1];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=gc({ones:()=>t.onesLike(e),rate:this.dropout,training:s,count:3,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=gc({ones:()=>t.onesLike(r),rate:this.recurrentDropout,training:s,count:3,dropoutFunc:this.dropoutFunc}));const i=this.dropoutMask,a=this.recurrentDropoutMask;let o,l,u;0<this.dropout&&this.dropout<1&&(e=t.mul(e,i[0]));let h=te(e,this.kernel.read());this.useBias&&(h=re(h,this.bias.read())),0<this.recurrentDropout&&this.recurrentDropout<1&&(r=t.mul(r,a[0]));const c=this.recurrentKernel.read(),[p,d]=t.split(c,[2*this.units,this.units],c.rank-1),f=te(r,p),[g,m,b]=t.split(h,3,h.rank-1),[y,w]=t.split(f,2,f.rank-1);o=this.recurrentActivation.apply(t.add(g,y)),l=this.recurrentActivation.apply(t.add(m,w));const k=te(t.mul(l,r),d);u=this.activation.apply(t.add(b,k));const v=t.add(t.mul(o,r),t.mul(t.add(1,t.neg(o)),u));return[v,v]}))}getConfig(){const t=super.getConfig(),e={units:this.units,activation:Nh(this.activation),recurrentActivation:Nh(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Ae(this.kernelInitializer),recurrentInitializer:Ae(this.recurrentInitializer),biasInitializer:Ae(this.biasInitializer),kernelRegularizer:zh(this.kernelRegularizer),recurrentRegularizer:zh(this.recurrentRegularizer),biasRegularizer:zh(this.biasRegularizer),activityRegularizer:zh(this.activityRegularizer),kernelConstraint:Wl(this.kernelConstraint),recurrentConstraint:Wl(this.recurrentConstraint),biasConstraint:Wl(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation,resetAfter:!1};return Object.assign(Object.assign({},t),e)}}hc.className="GRUCell",i.registerClass(hc);class cc extends ac{constructor(t){0===t.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),t.cell=new hc(t),super(t)}call(e,n){return s((()=>{null!=this.cell.dropoutMask&&(t.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(t.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const s=null==n?null:n.mask,r=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(e,{mask:s,training:r,initialState:i})}))}static fromConfig(t,e){return 0===e.implmentation&&(e.implementation=1),new t(e)}}cc.className="GRU",i.registerClass(cc);class pc extends oc{constructor(t){super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=t.units,bt(this.units,"units"),this.activation=Ih(void 0===t.activation?this.DEFAULT_ACTIVATION:t.activation),this.recurrentActivation=Ih(void 0===t.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:t.recurrentActivation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=Te(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Te(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Te(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.unitForgetBias=t.unitForgetBias,this.kernelRegularizer=Dh(t.kernelRegularizer),this.recurrentRegularizer=Dh(t.recurrentRegularizer),this.biasRegularizer=Dh(t.biasRegularizer),this.kernelConstraint=Vl(t.kernelConstraint),this.recurrentConstraint=Vl(t.recurrentConstraint),this.biasConstraint=Vl(t.biasConstraint),this.dropout=Pt([1,Wt([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=Pt([1,Wt([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.dropoutFunc=t.dropoutFunc,this.implementation=t.implementation,this.stateSize=[this.units,this.units],this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){var e;const n=(t=_e(t))[t.length-1];let s;if(this.kernel=this.addWeight("kernel",[n,4*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,4*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){if(this.unitForgetBias){const t=this.biasInitializer,n=this.units;s=new((e=class extends ue{apply(e,s){const r=t.apply([n]),i=(new ce).apply([n]),a=t.apply([2*n]);return Yt(Yt(r,i),a)}}).className="CustomInit",e)}else s=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.units],null,s,this.biasRegularizer,!0,this.biasConstraint)}else this.bias=null;this.built=!0}call(e,n){return s((()=>{const s=null!=n.training&&n.training;if(3!==e.length)throw new Y(`LSTMCell expects 3 input Tensors (inputs, h, c), got ${e.length}.`);let r=e[1];const i=e[2];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=gc({ones:()=>t.onesLike(e),rate:this.dropout,training:s,count:4,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=gc({ones:()=>t.onesLike(r),rate:this.recurrentDropout,training:s,count:4,dropoutFunc:this.dropoutFunc}));const a=this.dropoutMask,o=this.recurrentDropoutMask;let l,u,h,c;0<this.dropout&&this.dropout<1&&(e=t.mul(e,a[0]));let p=te(e,this.kernel.read());0<this.recurrentDropout&&this.recurrentDropout<1&&(r=t.mul(r,o[0])),p=t.add(p,te(r,this.recurrentKernel.read())),this.useBias&&(p=re(p,this.bias.read()));const[d,f,g,m]=t.split(p,4,p.rank-1);l=this.recurrentActivation.apply(d),u=this.recurrentActivation.apply(f),h=t.add(t.mul(u,i),t.mul(l,this.activation.apply(g))),c=this.recurrentActivation.apply(m);const b=t.mul(c,this.activation.apply(h));return[b,b,h]}))}getConfig(){const t=super.getConfig(),e={units:this.units,activation:Nh(this.activation),recurrentActivation:Nh(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Ae(this.kernelInitializer),recurrentInitializer:Ae(this.recurrentInitializer),biasInitializer:Ae(this.biasInitializer),unitForgetBias:this.unitForgetBias,kernelRegularizer:zh(this.kernelRegularizer),recurrentRegularizer:zh(this.recurrentRegularizer),biasRegularizer:zh(this.biasRegularizer),activityRegularizer:zh(this.activityRegularizer),kernelConstraint:Wl(this.kernelConstraint),recurrentConstraint:Wl(this.recurrentConstraint),biasConstraint:Wl(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation};return Object.assign(Object.assign({},t),e)}}pc.className="LSTMCell",i.registerClass(pc);class dc extends ac{constructor(t){0===t.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),t.cell=new pc(t),super(t)}call(e,n){return s((()=>{null!=this.cell.dropoutMask&&(t.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(t.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const s=null==n?null:n.mask,r=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(e,{mask:s,training:r,initialState:i})}))}static fromConfig(t,e){return 0===e.implmentation&&(e.implementation=1),new t(e)}}dc.className="LSTM",i.registerClass(dc);class fc extends oc{constructor(t){super(t),this.cells=t.cells}get stateSize(){const t=[];for(const e of this.cells.slice().reverse())Array.isArray(e.stateSize)?t.push(...e.stateSize):t.push(e.stateSize);return t}call(t,e){return s((()=>{let n=t.slice(1);const s=[];for(const t of this.cells.slice().reverse())Array.isArray(t.stateSize)?s.push(n.splice(0,t.stateSize.length)):s.push(n.splice(0,1));s.reverse();const r=[];let i;for(let a=0;a<this.cells.length;++a){const o=this.cells[a];n=s[a],i=0===a?[t[0]].concat(n):[i[0]].concat(n),i=o.call(i,e),r.push(i.slice(1))}n=[];for(const t of r.slice().reverse())n.push(...t);return[i[0]].concat(n)}))}build(t){let e;$e(t)&&(t=t[0]),this.cells.forEach(((n,s)=>{Ft(`RNNCell_${s}`,(()=>{n.build(t),e=Array.isArray(n.stateSize)?n.stateSize[0]:n.stateSize,t=[t[0],e]}))})),this.built=!0}getConfig(){const t=super.getConfig(),e={cells:this.cells.map((t=>({className:t.getClassName(),config:t.getConfig()})))};return Object.assign(Object.assign({},t),e)}static fromConfig(t,e,n={}){const s=[];for(const t of e.cells)s.push(su(t,n));return new t({cells:s})}get trainableWeights(){if(!this.trainable)return[];const t=[];for(const e of this.cells)t.push(...e.trainableWeights);return t}get nonTrainableWeights(){const t=[];for(const e of this.cells)t.push(...e.nonTrainableWeights);if(!this.trainable){const e=[];for(const t of this.cells)e.push(...t.trainableWeights);return e.concat(t)}return t}getWeights(){const t=[];for(const e of this.cells)t.push(...e.weights);return Re(t)}setWeights(t){const e=[];for(const n of this.cells){const s=n.weights.length,r=t.splice(s);for(let t=0;t<n.weights.length;++t)e.push([n.weights[t],r[t]])}Me(e)}}function gc(e){const{ones:n,rate:s,training:r=!1,count:i=1,dropoutFunc:a}=e,o=()=>null!=a?a(n(),s):ie(n(),s),l=()=>ae(o,n,r);if(!i||i<=1)return t.keep(l().clone());return Array(i).fill(void 0).map(l).map((e=>t.keep(e.clone())))}fc.className="StackedRNNCells",i.registerClass(fc);var mc=function(t,e){var n={};for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&e.indexOf(s)<0&&(n[s]=t[s]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var r=0;for(s=Object.getOwnPropertySymbols(t);r<s.length;r++)e.indexOf(s[r])<0&&Object.prototype.propertyIsEnumerable.call(t,s[r])&&(n[s[r]]=t[s[r]])}return n};class bc extends ac{constructor(t){if(t.unroll)throw new X("Unrolling is not possible with convolutional RNNs.");if(Array.isArray(t.cell))throw new X("It is not possible at the moment to stack convolutional cells.");super(t),this.inputSpec=[new Le({ndim:5})]}call(e,n){return t.tidy((()=>{if(null!=this.cell.dropoutMask&&(t.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(t.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null),n&&n.constants)throw new Y("ConvRNN2D cell does not support constants");const s=null==n?null:n.mask,r=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(e,{mask:s,training:r,initialState:i})}))}computeOutputShape(t){let e=this.computeSingleOutputShape(t);return this.returnSequences||(e=[e[0],...e.slice(2)]),this.returnState&&(e=[e,...Array(2).fill([t[0],...e.slice(-3)])]),e}getInitialState(e){return t.tidy((()=>{const{stateSize:n}=this.cell,s=e.shape,r=this.computeSingleOutputShape(s),i=[r[0],...r.slice(2)],a=t.zeros(i);return Array.isArray(n)?Array(n.length).fill(a):[a]}))}resetStates(n,s=!1){t.tidy((()=>{if(!this.stateful)throw new J("Cannot call resetStates() on an RNN Layer that is not stateful.");const r=this.inputSpec[0].shape,i=this.computeSingleOutputShape(r),a=[i[0],...i.slice(2)];if(null==r[0])throw new Y("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.getStates())Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>t.zeros(a))):this.states_=[t.zeros(a)];else if(null==n)t.dispose(this.states_),null!=this.keptStates&&(t.dispose(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>t.zeros(a))):this.states_[0]=t.zeros(a);else{if(Array.isArray(n)||(n=[n]),n.length!==this.states_.length)throw new Y(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${n.length} state value(s). Input received: ${n}`);s?this.keptStates.push(this.states_.slice()):t.dispose(this.states_);for(let t=0;t<this.states_.length;++t){const s=n[t],r=a;if(!e.arraysEqual(s.shape,r))throw new Y(`State ${t} is incompatible with layer ${this.name}: expected shape=${r}, received shape=${s.shape}`);this.states_[t]=s}}this.states_=this.states_.map((e=>t.keep(e.clone())))}))}computeSingleOutputShape(t){const{dataFormat:e,filters:n,kernelSize:s,padding:r,strides:i,dilationRate:a}=this.cell,o="channelsFirst"===e,l=t[o?3:2],u=t[o?4:3],h=Wh(l,s[0],r,i[0],a[0]),c=Wh(u,s[1],r,i[1],a[1]);return[...t.slice(0,2),...o?[n,h,c]:[h,c,n]]}}bc.className="ConvRNN2D";class yc extends pc{constructor(t){const{filters:e,kernelSize:n,strides:s,padding:r,dataFormat:i,dilationRate:a}=t;super(Object.assign(Object.assign({},t),{units:e})),this.filters=e,bt(this.filters,"filters"),this.kernelSize=Ph(n,2,"kernelSize"),this.kernelSize.forEach((t=>bt(t,"kernelSize"))),this.strides=Ph(s||1,2,"strides"),this.strides.forEach((t=>bt(t,"strides"))),this.padding=r||"valid",zt(this.padding),this.dataFormat=i||"channelsLast",Ct(this.dataFormat),this.dilationRate=Ph(a||1,2,"dilationRate"),this.dilationRate.forEach((t=>bt(t,"dilationRate")))}build(e){var n;e=_e(e);const s="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[s])throw new Y(`The channel dimension of the input should be defined. Found ${e[s]}`);const r=e[s],i=this.kernelSize.concat([r,4*this.filters]);this.kernel=this.addWeight("kernel",i,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint);const a=this.kernelSize.concat([this.filters,4*this.filters]);if(this.recurrentKernel=this.addWeight("recurrent_kernel",a,null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){let e;if(this.unitForgetBias){const s=this.biasInitializer,r=this.filters;e=new((n=class extends ue{apply(e,n){return Zt([s.apply([r]),t.ones([r]),s.apply([2*r])])}}).className="CustomInit",n)}else e=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.filters],null,e,this.biasRegularizer,!0,this.biasConstraint)}this.built=!0}call(e,n){return t.tidy((()=>{if(3!==e.length)throw new Y(`ConvLSTM2DCell expects 3 input Tensors (inputs, h, c), got ${e.length}.`);const s=n.training||!1,r=e[0],i=e[1],a=e[2];0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=gc({ones:()=>t.onesLike(r),rate:this.dropout,training:s,count:4,dropoutFunc:this.dropoutFunc}));const o=this.dropoutMask,l=(e,n,s)=>n&&n[s]?t.mul(n[s],e):e;let u=l(r,o,0),h=l(r,o,1),c=l(r,o,2),p=l(r,o,3);0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=gc({ones:()=>t.onesLike(i),rate:this.recurrentDropout,training:s,count:4,dropoutFunc:this.dropoutFunc}));const d=this.recurrentDropoutMask;let f=l(i,d,0),g=l(i,d,1),m=l(i,d,2),b=l(i,d,3);const[y,w,k,v]=t.split(this.kernel.read(),4,3),[x,S,N,E]=this.useBias?t.split(this.bias.read(),4):[null,null,null,null];u=this.inputConv(u,y,x,this.padding),h=this.inputConv(h,w,S,this.padding),c=this.inputConv(c,k,N,this.padding),p=this.inputConv(p,v,E,this.padding);const[I,A,T,$]=t.split(this.recurrentKernel.read(),4,3);f=this.recurrentConv(f,I),g=this.recurrentConv(g,A),m=this.recurrentConv(m,T),b=this.recurrentConv(b,$);const C=this.recurrentActivation.apply(t.add(u,f)),z=this.recurrentActivation.apply(t.add(h,g)),_=t.add(t.mul(z,a),t.mul(C,this.activation.apply(t.add(c,m)))),D=t.mul(this.recurrentActivation.apply(t.add(p,b)),this.activation.apply(_));return[D,D,_]}))}getConfig(){const t=super.getConfig(),e=mc(t,["units"]),n={filters:this.filters,kernelSize:this.kernelSize,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,strides:this.strides};return Object.assign(Object.assign({},e),n)}inputConv(e,n,s,r){const i=t.conv2d(e,n,this.strides,r||"valid","channelsFirst"===this.dataFormat?"NCHW":"NHWC",this.dilationRate);return s?re(i,s,this.dataFormat):i}recurrentConv(e,n){return t.conv2d(e,n,1,"same","channelsFirst"===this.dataFormat?"NCHW":"NHWC")}}yc.className="ConvLSTM2DCell",t.serialization.registerClass(yc);class wc extends bc{constructor(t){const e=new yc(t);super(Object.assign(Object.assign({},t),{cell:e}))}static fromConfig(t,e){return new t(e)}}wc.className="ConvLSTM2D",t.serialization.registerClass(wc);class kc extends Ue{constructor(t){super(t),this.rate=Math.max(Math.min(t.rate,1),0),this.noiseShape=t.noiseShape,this.seed=t.seed,this.supportsMasking=!0}getNoiseShape(t){if(null==this.noiseShape)return this.noiseShape;const e=t.shape,n=[];for(let t=0;t<this.noiseShape.length;++t)n.push(null==this.noiseShape[t]?e[t]:this.noiseShape[t]);return n}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=ze(t);if(0<this.rate&&this.rate<1){const t=null!=e.training&&e.training,s=this.getNoiseShape(n);return ae((()=>ie(n,this.rate,s,this.seed)),(()=>n),t)}return t}))}getConfig(){const t={rate:this.rate,noiseShape:this.noiseShape,seed:this.seed},e=super.getConfig();return Object.assign(t,e),t}dispose(){return super.dispose()}}kc.className="Dropout",i.registerClass(kc);class vc extends kc{constructor(t){super(t),this.inputSpec=[{ndim:3}]}getNoiseShape(t){const e=t.shape;return[e[0],1,e[2]]}}vc.className="SpatialDropout1D",i.registerClass(vc);class xc extends Ue{constructor(t){if(super(t),this.activation=null,this.useBias=!0,this.kernel=null,this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",null==t.batchInputShape&&null==t.inputShape&&null!=t.inputDim){let e=null;null!=t.batchSize&&(e=t.batchSize),this.batchInputShape=[e,t.inputDim]}this.units=t.units,bt(this.units,"units"),this.activation=Ih(t.activation),null!=t.useBias&&(this.useBias=t.useBias),this.kernelInitializer=Te(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.biasInitializer=Te(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelConstraint=Vl(t.kernelConstraint),this.biasConstraint=Vl(t.biasConstraint),this.kernelRegularizer=Dh(t.kernelRegularizer),this.biasRegularizer=Dh(t.biasRegularizer),this.activityRegularizer=Dh(t.activityRegularizer),this.supportsMasking=!0,this.inputSpec=[{minNDim:2}]}build(t){const e=(t=_e(t))[t.length-1];null==this.kernel&&(this.kernel=this.addWeight("kernel",[e,this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint))),this.inputSpec=[{minNDim:2,axes:{[-1]:e}}],this.built=!0}computeOutputShape(t){const e=(t=_e(t)).slice();return e[e.length-1]=this.units,e}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=ze(t),s=wt(this.activation.getClassName());let r;return null!=s?r=te(n,this.kernel.read(),s,this.bias?this.bias.read():null):(r=te(n,this.kernel.read()),null!=this.bias&&(r=re(r,this.bias.read())),null!=this.activation&&(r=this.activation.apply(r))),r}))}getConfig(){const t={units:this.units,activation:Nh(this.activation),useBias:this.useBias,kernelInitializer:Ae(this.kernelInitializer),biasInitializer:Ae(this.biasInitializer),kernelRegularizer:zh(this.kernelRegularizer),biasRegularizer:zh(this.biasRegularizer),activityRegularizer:zh(this.activityRegularizer),kernelConstraint:Wl(this.kernelConstraint),biasConstraint:Wl(this.biasConstraint)},e=super.getConfig();return Object.assign(t,e),t}}xc.className="Dense",i.registerClass(xc);class Sc extends Ue{constructor(t){super(t=t||{}),this.inputSpec=[{minNDim:3}],this.dataFormat=t.dataFormat}computeOutputShape(t){t=_e(t);for(const e of t.slice(1))if(null==e)throw new Y(`The shape of the input to "Flatten" is not fully defined (got ${t.slice(1)}). Make sure to pass a complete "input_shape" or "batch_input_shape" argument to the first layer in your model.`);return[t[0],Bt(t,1)]}call(e,n){return s((()=>{this.invokeCallHook(e,n);let s=ze(e);if("channelsFirst"===this.dataFormat&&s.rank>1){const t=[0];for(let e=2;e<s.rank;++e)t.push(e);t.push(1),s=f(s,t)}return function(e){if(e.rank<=1)throw new Y(`batchFlatten requires a minimum rank of 2. Got rank: ${e.rank}.`);const n=[e.shape[0],Bt(e.shape,1)];return t.reshape(e,n)}(s)}))}getConfig(){const t={};null!=this.dataFormat&&(t.dataFormat=this.dataFormat);const e=super.getConfig();return Object.assign(t,e),t}}Sc.className="Flatten",i.registerClass(Sc);class Nc extends Ue{constructor(t){super(t),this.supportsMasking=!0,this.activation=Ih(t.activation)}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=ze(t);return this.activation.apply(n)}))}getConfig(){const t={activation:Nh(this.activation)},e=super.getConfig();return Object.assign(t,e),t}}Nc.className="Activation",i.registerClass(Nc);class Ec extends Ue{constructor(t){super(t),this.n=t.n,this.inputSpec=[{ndim:2}]}computeOutputShape(t){return[t[0],this.n,t[1]]}call(t,e){return s((()=>{return t=ze(t),e=t,n=this.n,s((()=>{if(2!==e.shape.length)throw new Y(`repeat() expects a rank-2 tensor, but received a rank-${e.shape.length} tensor.`);return Xt(qt(e,1),[1,n,1])}));var e,n}))}getConfig(){const t={n:this.n},e=super.getConfig();return Object.assign(t,e),t}}Ec.className="RepeatVector",i.registerClass(Ec);class Ic extends Ue{constructor(t){super(t),this.targetShape=t.targetShape;for(let t=0;t<this.targetShape.length;++t)this.isUnknown(this.targetShape[t])&&(this.targetShape[t]=null)}isUnknown(t){return t<0||null==t}fixUnknownDimension(t,e){const n="Total size of new array must be unchanged.",s=e.slice();let r=1,i=null;for(let t=0;t<s.length;++t){const e=s[t];if(this.isUnknown(e)){if(null!==i)throw new Y("Can only specifiy one unknown dimension.");i=t}else r*=e}const a=Bt(t);if(null!==i){if(0===r||a%r!=0)throw new Y(n);s[i]=a/r}else if(a!==r)throw new Y(n);return s}computeOutputShape(t){let e=!1;for(let n=0;n<t.length;++n)if(this.isUnknown(t[n])){e=!0;break}return e?t.slice(0,1).concat(this.targetShape):t.slice(0,1).concat(this.fixUnknownDimension(t.slice(1),this.targetShape))}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=ze(t),s=n.shape,r=s.slice(0,1).concat(this.fixUnknownDimension(s.slice(1),this.targetShape));return I(n,r)}))}getConfig(){const t={targetShape:this.targetShape},e=super.getConfig();return Object.assign(t,e),t}}Ic.className="Reshape",i.registerClass(Ic);class Ac extends Ue{constructor(t){if(super(t),null==t.dims)throw new Error("Required configuration field `dims` is missing during Permute constructor call.");if(!Array.isArray(t.dims))throw new Error(`Permute constructor requires \`dims\` to be an Array, but received ${t.dims} instead.`);const n=Ut(1,t.dims.length+1);if(!e.arraysEqual(t.dims.slice().sort(),n))throw new Error("Invalid permutation `dims`: "+JSON.stringify(t.dims)+" `dims` must contain consecutive integers starting from 1.");this.dims=t.dims,this.dimsIncludingBatch=[0].concat(this.dims),this.inputSpec=[new Le({ndim:this.dims.length+1})]}computeOutputShape(t){const e=(t=_e(t)).slice();return this.dims.forEach(((n,s)=>{e[s+1]=t[n]})),e}call(t,e){return f(ze(t),this.dimsIncludingBatch)}getConfig(){const t={dims:this.dims},e=super.getConfig();return Object.assign(t,e),t}}Ac.className="Permute",i.registerClass(Ac);class Tc extends Ue{constructor(t){super(null==t?{}:t),this.supportsMasking=!0,this.maskValue=null!=t?null==t.maskValue?0:t.maskValue:0}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={maskValue:this.maskValue};return Object.assign(e,t),e}computeMask(t,e){const n=ze(t);return O(B(n,this.maskValue),-1)}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=ze(t),s=O(B(n,this.maskValue),-1,!0);return l(n,b(s,n.dtype))}))}}Tc.className="Masking",i.registerClass(Tc);class $c extends Ue{constructor(t){if(super(t),this.embeddings=null,this.DEFAULT_EMBEDDINGS_INITIALIZER="randomUniform",null==t.batchInputShape&&null==t.inputShape){let e=null;null!=t.batchSize&&(e=t.batchSize),null==t.inputLength?this.batchInputShape=[e,null]:this.batchInputShape=[e].concat(it(t.inputLength))}this.inputDim=t.inputDim,bt(this.inputDim,"inputDim"),this.outputDim=t.outputDim,bt(this.outputDim,"outputDim"),this.embeddingsInitializer=Te(t.embeddingsInitializer||this.DEFAULT_EMBEDDINGS_INITIALIZER),this.embeddingsRegularizer=Dh(t.embeddingsRegularizer),this.activityRegularizer=Dh(t.activityRegularizer),this.embeddingsConstraint=Vl(t.embeddingsConstraint),this.maskZero=t.maskZero,this.supportsMasking=t.maskZero,this.inputLength=t.inputLength}build(t){this.embeddings=this.addWeight("embeddings",[this.inputDim,this.outputDim],this.dtype,this.embeddingsInitializer,this.embeddingsRegularizer,!0,this.embeddingsConstraint),this.built=!0}warnOnIncompatibleInputShape(t){}computeMask(t,e){return s((()=>this.maskZero?(t=ze(t),B(t,P(t))):null))}computeOutputShape(t){if(t=_e(t),null==this.inputLength)return[...t,this.outputDim];const e=it(this.inputLength);if(e.length!==t.length-1)throw new Y(`"inputLength" is ${this.inputLength}, but received input shape has shape ${t}`);{let n=0;for(let s=0;s<e.length;++s){const r=e[s],i=t[s+1];if(null!=r&&null!=i&&r!==i)throw new Y(`"inputLength" is ${this.inputLength}, but received input shape has shape ${t}`);null==r&&(e[n]=i),n++}}return[t[0],...e,this.outputDim]}call(t,e){return s((()=>{this.invokeCallHook(t,e);let n=ze(t);"int32"!==n.dtype&&(n=jt(n,"int32"));const s=ee(this.embeddings.read(),I(n,[n.size]));return I(s,_e(this.computeOutputShape(n.shape)))}))}getConfig(){const t={inputDim:this.inputDim,outputDim:this.outputDim,embeddingsInitializer:Ae(this.embeddingsInitializer),embeddingsRegularizer:zh(this.embeddingsRegularizer),activityRegularizer:zh(this.activityRegularizer),embeddingsConstraint:Wl(this.embeddingsConstraint),maskZero:this.maskZero,inputLength:this.inputLength},e=super.getConfig();return Object.assign(t,e),t}}$c.className="Embedding",i.registerClass($c);class Cc extends Ue{constructor(t){super(t||{}),this.supportsMasking=!0}mergeFunction(t){throw new X}computeElementwiseOpOutputShape(t,e){if(null==t||null==e)return null;if(t.length<e.length)return this.computeElementwiseOpOutputShape(e,t);if(0===e.length)return t;const n=t.slice(0,t.length-e.length);for(let s=0;s<e.length;++s){const r=t[t.length-e.length+s],i=e[s];if(null==r||null==i||r<0||i<0)n.push(null);else if(1===r)n.push(i);else if(1===i)n.push(r);else{if(r!==i)throw new Y("Operands could not be broadcast together with shapes "+JSON.stringify(t)+" "+JSON.stringify(e));n.push(r)}}return n}build(t){if(Array.isArray(t)&&!Array.isArray(t[0])&&(t=[_e(t)]),t.length<2)throw new Y(`A merge layer should be called on an Array of at least 2 inputs. Got ${t.length} input(s).`);let e=[];for(const n of t)null!=n&&null!==n[0]&&e.push(n[0]);if(e=dt(e),e.length>1)throw new Y(`Can not merge tensors with different batch sizes. Got tensors with shapes: ${JSON.stringify(t)}.`);let n=null==t[0]?null:t[0].slice(1);for(let e=1;e<t.length;++e){const s=null==t[e]?null:t[e].slice(1);n=this.computeElementwiseOpOutputShape(n,s)}const s=t.map((t=>t.length));-1===t.indexOf(null)&&1===dt(s).length?this.reshapeRequired=!1:this.reshapeRequired=!0}call(e,n){return s((()=>{if(this.reshapeRequired){const n=[],s=e.map((t=>t.rank));if(-1===s.indexOf(null)){const t=Wt(s);for(let s of e){const e=s.rank;for(let n=0;n<t-e;++n)s=qt(s,1);n.push(s)}return this.mergeFunction(n)}{let s=!1;for(const r of e){const e=r.rank;if(null==e){const e=r.shape,i=e[0],a=e.slice(1).concat([i]);let o=t.reshape(r,[i].concat(Bt(e.slice(1))));o=t.transpose(o,[1,0]),o=t.reshape(o,a),n.push(o),s=!0}else if(e>1){const i=Ut(1,e).concat([0]);n.push(t.transpose(r,i)),s=!0}else n.push(r)}let r=this.mergeFunction(n);const i=r.rank;if(s)if(null==i){const e=r.shape,n=e[e.length-1],s=[n].concat(e.slice(0,e.length-1));r=t.reshape(t.transpose(t.reshape(r,[-1,n]),[1,0]),s)}else if(i>1){const e=[i-1].concat(Ut(0,i-1));r=t.transpose(r,e)}return r}}return this.mergeFunction(e)}))}computeOutputShape(t){let e;e=null==t[0]?null:t[0].slice(1);for(let n=1;n<t.length;++n){const s=null==t[n]?null:t[n].slice(1);e=this.computeElementwiseOpOutputShape(e,s)}let n=[];for(const e of t)null!=e&&null!==e[0]&&n.push(e[0]);return n=dt(n),e=1===n.length?n.concat(e):[null].concat(e),e}computeMask(e,n){return t.tidy((()=>{if(null==n)return null;if(!Array.isArray(n))throw new Y("`mask` should be an Array");if(!Array.isArray(e))throw new Y("`inputs` should be an Array");if(n.length!==e.length)throw new Y(`The Array 'inputs' and 'mask' are expected to have the same length, but have different lengths (${e.length} vs ${n.length})`);if(n.every((t=>null==t)))return null;let s=(n=n.map((e=>null==e?e:t.expandDims(e,0))))[0];for(let e=1;e<n.length-1;++e)s=t.logicalAnd(s,n[e]);return s}))}}class zc extends Cc{constructor(t){super(t)}mergeFunction(e){return s((()=>{let n=e[0].clone();for(let s=1;s<e.length;++s)n=t.add(n,e[s]);return n}))}}zc.className="Add",i.registerClass(zc);class _c extends Cc{constructor(t){super(t)}mergeFunction(e){return s((()=>{let n=e[0].clone();for(let s=1;s<e.length;++s)n=t.mul(n,e[s]);return n}))}}_c.className="Multiply",i.registerClass(_c);class Dc extends Cc{constructor(t){super(t)}mergeFunction(e){return s((()=>{let n=e[0].clone();for(let s=1;s<e.length;++s)n=t.add(n,e[s]);return t.mul(1/e.length,n)}))}}Dc.className="Average",i.registerClass(Dc);class Fc extends Cc{constructor(t){super(t)}mergeFunction(e){return s((()=>{let n=e[0];for(let s=1;s<e.length;++s)n=t.maximum(n,e[s]);return n}))}}Fc.className="Maximum",i.registerClass(Fc);class Rc extends Cc{constructor(t){super(t)}mergeFunction(e){return s((()=>{let n=e[0];for(let s=1;s<e.length;++s)n=t.minimum(n,e[s]);return n}))}}Rc.className="Minimum",i.registerClass(Rc);class Mc extends Cc{constructor(t){super(t),this.DEFAULT_AXIS=-1,null==t&&(t={}),this.axis=null==t.axis?this.DEFAULT_AXIS:t.axis,this.supportsMasking=!0,this.reshapeRequired=!1}build(t){if(!Array.isArray(t)||!Array.isArray(t[0])||1===t.length)throw new Y("A `Concatenate` layer should be called on a list of at least 2 inputs");let n=!0;for(const e of t)if(null!=e){n=!1;break}if(n)return;const s=[];for(let n=0;n<t.length;++n){const r=t[n].slice();r.splice(this.axis,1);let i=!1;for(const t of s)if(e.arraysEqual(t,r)){i=!0;break}i||s.push(r)}if(s.length>1)throw new Y("A `Concatenate` layer requires inputs with matching shapes except for the concat axis. Got input shapes: "+JSON.stringify(t))}mergeFunction(t){return s((()=>Zt(t,this.axis)))}computeOutputShape(t){if(!Array.isArray(t)||!Array.isArray(t[0]))throw new Y("A `Concatenate` layer should be called on a list of inputs.");const e=t,n=e[0].slice(),s=this.axis<0?n.length+this.axis:this.axis;for(const t of e.slice(1)){if(null==n[s]||null==t[s]){n[s]=null;break}n[s]+=t[s]}return n}computeMask(e,n){if(null==n)return null;if(!Array.isArray(n))throw new Y("`mask` should be an array for Concatenate");if(!Array.isArray(e))throw new Y("`inputs` should be an array for Concatenate");if(n.length!==e.length)throw new Y(`Mismatch in the length of mask (${n.length}) and the legnth of inputs (${e.length})`);return t.tidy((()=>{let s=!0;if(n.forEach((t=>{null==t||(s=!1)})),s)return null;const r=[];for(let s=0;s<e.length;++s)null==n[s]?r.push(t.cast(t.onesLike(e[s]),"bool")):n[s].rank<e[s].rank?r.push(t.expandDims(n[s],-1)):r.push(n[s]);const i=t.concat(r,this.axis);return t.all(i,-1,!1)}))}getConfig(){const t={axis:this.axis},e=super.getConfig();return Object.assign(t,e),t}}function Lc(t,e){for(;t<0;)t+=e;return t}Mc.className="Concatenate",i.registerClass(Mc);class Oc extends Cc{constructor(t){super(t),this.axes=t.axes,this.normalize=null!=t.normalize&&t.normalize,this.supportsMasking=!0,this.reshapeRequired=!1}build(e){t.util.assert(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const n=e[0],s=e[1];if(n.length>3||s.length>3)throw new X("Dot layer does not support tensors of 4D or higher rank yet.");const r=this.interpretAxes(n,s);if(n[r[0]]!==s[r[1]])throw new Y(`Dimension incompatibility: ${n[r[0]]} !== ${s[r[1]]}`)}mergeFunction(e){if(2!==e.length)throw new Y(`A \`Dot\` layer must be called on exactly 2 inputs, but received ${e.length} input(s).`);let n,s=e[0],r=e[1];return n=Array.isArray(this.axes)?this.axes.map(((t,n)=>Lc(t,e[n].shape.length))):[Lc(this.axes,s.shape.length),Lc(this.axes,r.shape.length)],this.normalize&&(s=ru(s,n[0]),r=ru(r,n[1])),function(e,n,s){if(e.shape.length>3||n.shape.length>3)throw new X("batchDot is not implemented for tensors of 4D or higher rank yet");if(t.util.assert(e.shape.length>=2,(()=>`batchDot requires the rank of x to be >= 2, but got ${e.shape.length}`)),t.util.assert(e.shape.length>=2,(()=>`batchDot requires the rank of y to be >= 2, but got ${n.shape.length}`)),"number"==typeof s&&(s=[s,s]),"complex64"===e.dtype||"complex64"===n.dtype)throw new X("batchDot is not implemented for complex64-type Tensors yet.");const r=e.shape.length,i=n.shape.length;null==s&&(s=[r-1,i-2]);const a=s;return t.tidy((()=>{let s,o;if(r>i){s=r-i;const e=[];for(let t=0;t<s;++t)e.push(1);n=t.reshape(n,n.shape.concat(e))}else if(i>r){s=i-r;const n=[];for(let t=0;t<s;++t)n.push(1);e=t.reshape(e,e.shape.concat(n))}else s=0;if(2===e.shape.length&&2===n.shape.length)o=a[0]===a[1]?t.sum(t.mul(e,n),a[0]):t.sum(t.mul(t.transpose(e,[1,0]),n),a[1]);else{const s=a[0]!==e.shape.length-1,r=a[1]===n.shape.length-1;o=t.matMul(e,n,s,r)}if(s>0){let e;e=r>i?r+i-3:r-1;const n=[];for(let t=e;t<e+s;++t)n.push(t);o=t.squeeze(o,n)}return 1===o.shape.length&&(o=t.expandDims(o,1)),o}))}(s,r,n)}interpretAxes(t,e){let n;return n=Array.isArray(this.axes)?this.axes:[Lc(this.axes,t.length),Lc(this.axes,e.length)],n}computeOutputShape(e){t.util.assert(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const n=e[0].slice(),s=e[1].slice();if(n.length>3||s.length>3)throw new X("Dot layer does not support tensors of 4D or higher rank yet.");const r=this.interpretAxes(n,s);n.splice(r[0],1),s.splice(r[1],1),s.splice(0,1);const i=n.concat(s);return 1===i.length&&i.push(1),i}computeMask(t,e){return null}getConfig(){const t={axes:this.axes,normalize:this.normalize},e=super.getConfig();return Object.assign(t,e),t}}Oc.className="Dot",i.registerClass(Oc);class Bc extends Ue{constructor(t){super(t),this.supportsMasking=!0,this.stddev=t.stddev}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={stddev:this.stddev};return Object.assign(e,t),e}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=ze(t);return ae((()=>k(Qt(n.shape,0,this.stddev),n)),(()=>n),e.training||!1)}))}}Bc.className="GaussianNoise",i.registerClass(Bc);class Pc extends Ue{constructor(t){super(t),this.supportsMasking=!0,this.rate=t.rate}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={rate:this.rate};return Object.assign(e,t),e}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=ze(t);if(this.rate>0&&this.rate<1){return ae((()=>{const t=Math.sqrt(this.rate/(1-this.rate));return l(n,Qt(n.shape,1,t))}),(()=>n),e.training||!1)}return n}))}}Pc.className="GaussianDropout",i.registerClass(Pc);class Wc extends Ue{constructor(t){super(t),this.supportsMasking=!0,this.rate=t.rate,this.noiseShape=t.noiseShape}_getNoiseShape(t){return this.noiseShape||ze(t).shape}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={rate:this.rate};return Object.assign(e,t),e}call(t,e){return s((()=>{if(this.rate<1&&this.rate>0){const n=this._getNoiseShape(t),s=()=>{const e=ze(t),s=-1.7580993408473766;let r=W(h(n),this.rate);r=jt(r,"float32");const i=((1-this.rate)*(1+this.rate*s**2))**-.5,a=-i*s*this.rate,o=k(l(e,r),l(k(r,-1),s));return k(l(o,i),a)};return ae(s,(()=>ze(t)),e.training||!1)}return t}))}}function Uc(e,n,s,r,i,a=.001){let o;if(2===e.rank)o=t.batchNorm2d(e,n,s,r,i,a);else if(3===e.rank)o=t.batchNorm3d(e,n,s,r,i,a);else{if(4!==e.rank)throw new X(`batchNormalization is not implemented for array of rank ${e.rank} yet`);o=t.batchNorm4d(e,n,s,r,i,a)}return o}function Vc(n,r,i,a,o=.001){return e.arraysEqual(a.slice().sort(),Ut(0,n.rank-1))?function(e,n,r,i,a=.001){return s((()=>{const s=t.moments(e,i),o=s.mean,l=s.variance;return[Uc(e,o,l,r,n,a),o,l]}))}(n,r,i,a,o):function(e,n,r,i,a=.001){return s((()=>{const s=t.moments(e,i),o=s.mean,l=s.variance,u=[];for(const t of Ut(0,e.rank))-1!==i.indexOf(t)?u.push(1):u.push(e.shape[t]);const h=I(o,u),c=I(l,u),p=null==n?null:I(n,u),d=null==r?null:I(r,u);return[Uc(e,h,c,d,p,a),o,l]}))}(n,r,i,a,o)}Wc.className="AlphaDropout",i.registerClass(Wc);class Kc extends Ue{constructor(t){null==t&&(t={}),super(t),this.supportsMasking=!0,this.axis=null==t.axis?-1:t.axis,this.momentum=null==t.momentum?.99:t.momentum,this.epsilon=null==t.epsilon?.001:t.epsilon,this.center=null==t.center||t.center,this.scale=null==t.scale||t.scale,this.betaInitializer=Te(t.betaInitializer||"zeros"),this.gammaInitializer=Te(t.gammaInitializer||"ones"),this.movingMeanInitializer=Te(t.movingMeanInitializer||"zeros"),this.movingVarianceInitializer=Te(t.movingVarianceInitializer||"ones"),this.betaConstraint=Vl(t.betaConstraint),this.gammaConstraint=Vl(t.gammaConstraint),this.betaRegularizer=Dh(t.betaRegularizer),this.gammaRegularizer=Dh(t.gammaRegularizer)}build(t){t=_e(t);const e=this.axis>=0?this.axis:this.axis+t.length,n=t[e];if(null==n)throw new Y(`Axis ${e} of input tensor should have a defined dimension but the layer received an input with shape ${JSON.stringify(t)}.`);this.inputSpec=[new Le({ndim:t.length,axes:{[e]:n}})];const s=[n];this.scale&&(this.gamma=this.addWeight("gamma",s,null,this.gammaInitializer,this.gammaRegularizer,!0,this.gammaConstraint)),this.center&&(this.beta=this.addWeight("beta",s,null,this.betaInitializer,this.betaRegularizer,!0,this.betaConstraint)),this.movingMean=this.addWeight("moving_mean",s,null,this.movingMeanInitializer,null,!1),this.movingVariance=this.addWeight("moving_variance",s,null,this.movingVarianceInitializer,null,!1),this.built=!0}call(n,r){return s((()=>{const s=null!=r.training&&r.training,i=ze(n),a=i.shape,o=a.length,l=Ut(0,o),u=this.axis>=0?this.axis:this.axis+o;l.splice(u,1);const h=et(1,o);h[u]=a[u];const c=l.slice();c.sort();const p=!e.arraysEqual(c,Ut(0,o).slice(0,o-1));if(!s)return(()=>{if(p){const t=I(this.movingMean.read(),h),e=I(this.movingVariance.read(),h),n=this.center?I(this.beta.read(),h):null,s=this.scale?I(this.gamma.read(),h):null;return Uc(i,t,e,n,s,this.epsilon)}return Uc(i,this.movingMean.read(),this.movingVariance.read(),null==this.beta?null:this.beta.read(),null==this.gamma?null:this.gamma.read(),this.epsilon)})();const[d,f,g]=Vc(i,this.gamma.read(),this.beta.read(),l,this.epsilon),m=(e,n,s)=>{t.tidy((()=>{const r=1-s,i=e.read(),a=t.mul(t.sub(i,n),r);e.write(t.sub(i,a))}))};return(()=>{m(this.movingMean,f,this.momentum),m(this.movingVariance,g,this.momentum)})(),d}))}getConfig(){const t={axis:this.axis,momentum:this.momentum,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Ae(this.betaInitializer),gammaInitializer:Ae(this.gammaInitializer),movingMeanInitializer:Ae(this.movingMeanInitializer),movingVarianceInitializer:Ae(this.movingVarianceInitializer),betaRegularizer:zh(this.betaRegularizer),gammaRegularizer:zh(this.gammaRegularizer),betaConstraint:Wl(this.betaConstraint),gammaConstraint:Wl(this.gammaConstraint)},e=super.getConfig();return Object.assign(t,e),t}}Kc.className="BatchNormalization",i.registerClass(Kc);class jc extends Ue{constructor(t){if(null==t&&(t={}),super(t),this.axis=null==t.axis?-1:t.axis,"number"==typeof this.axis){if(!Number.isInteger(this.axis))throw new Error(`Expected axis to be an integer, but received ${this.axis}`)}else{if(!Array.isArray(this.axis))throw new Error(`Expected axis to be an integer or an array of integers, but received ${JSON.stringify(this.axis)}`);for(const t of this.axis)if(!Number.isInteger(t))throw new Error(`Expected axis to be an array of integers, but received ${JSON.stringify(this.axis)}`)}this.epsilon=null==t.epsilon?.001:t.epsilon,this.center=null==t.center||t.center,this.scale=null==t.scale||t.scale,this.betaInitializer=Te(t.betaInitializer||"zeros"),this.gammaInitializer=Te(t.gammaInitializer||"ones"),this.betaRegularizer=Dh(t.betaRegularizer),this.gammaRegularizer=Dh(t.gammaRegularizer),this.supportsMasking=!0}build(t){const e=(t=_e(t)).length;"number"==typeof this.axis&&(this.axis=[this.axis]);for(let t=0;t<this.axis.length;++t)this.axis[t]<0&&(this.axis[t]+=e);for(const t of this.axis)if(t<0||t>=e)throw new Error(`Invalid axis: ${t}`);if(this.axis.length!==dt(this.axis).length)throw new Error(`Found duplicate axes in: ${this.axis}`);const n=this.axis.map((e=>t[e]));this.scale?this.gamma=this.addWeight("gamma",n,"float32",this.gammaInitializer,this.gammaRegularizer,true):this.gamma=null,this.center?this.beta=this.addWeight("beta",n,"float32",this.betaInitializer,this.betaRegularizer,true):this.beta=null,this.built=!0}call(e,n){const r=ze(e),i=r.shape,a=i.length;return s((()=>{let{mean:e,variance:n}=U(r,this.axis,!0);const s=et(1,a);for(const t of this.axis)s[t]=i[t];const o=e=>null!=e&&e.shape.length!==a?t.reshape(e,s):e;let l=this.scale?o(this.gamma.read()):null,u=this.center?o(this.beta.read()):null;const h=[],c=[];for(let t=0;t<a;++t)-1!==this.axis.indexOf(t)?(h.push(i[t]),c.push(1)):(h.push(1),c.push(i[t]));return e=t.tile(e,h),n=t.tile(n,h),null!=l&&(l=t.tile(l,c)),null!=u&&(u=t.tile(u,c)),Uc(r,e,n,u,l,this.epsilon)}))}getConfig(){const t={axis:this.axis,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Ae(this.betaInitializer),gammaInitializer:Ae(this.gammaInitializer),betaRegularizer:zh(this.betaRegularizer),gammaRegularizer:zh(this.gammaRegularizer)},e=super.getConfig();return Object.assign(t,e),t}}jc.className="LayerNormalization",i.registerClass(jc);class qc extends Ue{constructor(t){if(null==t&&(t={}),super(t),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,null==t.padding)this.padding=[[1,1],[1,1]];else if("number"==typeof t.padding)this.padding=[[t.padding,t.padding],[t.padding,t.padding]];else{if(t.padding=t.padding,2!==t.padding.length)throw new Y(`ZeroPadding2D expects padding to be a length-2 array, but received a length-${t.padding.length} array.`);let e,n;if("number"==typeof t.padding[0])e=[t.padding[0],t.padding[0]],n=[t.padding[1],t.padding[1]];else{if(t.padding=t.padding,2!==t.padding[0].length)throw new Y(`ZeroPadding2D expects height padding to be a length-2 array, but received a length-${t.padding[0].length} array.`);if(e=t.padding[0],2!==t.padding[1].length)throw new Y(`ZeroPadding2D expects width padding to be a length-2 array, but received a length-${t.padding[1].length} array.`);n=t.padding[1]}this.padding=[e,n]}this.inputSpec=[new Le({ndim:4})]}computeOutputShape(t){let e,n;return t=_e(t),"channelsFirst"===this.dataFormat?(e=null!=t[2]&&t[2]>=0?t[2]+this.padding[0][0]+this.padding[0][1]:null,n=null!=t[3]&&t[3]>=0?t[3]+this.padding[1][0]+this.padding[1][1]:null,[t[0],t[1],e,n]):(e=null!=t[1]&&t[1]>=0?t[1]+this.padding[0][0]+this.padding[0][1]:null,n=null!=t[2]&&t[2]>=0?t[2]+this.padding[1][0]+this.padding[1][1]:null,[t[0],e,n,t[3]])}call(e,n){return s((()=>{return n=ze(e),r=this.padding,i=this.dataFormat,s((()=>{if(4!==n.rank)throw new Y(`temporalPadding expects input tensor to be 4-D, but received a ${n.rank}-D tensor.`);if(null==r&&(r=[[1,1],[1,1]]),2!==r.length||2!==r[0].length||2!==r[1].length)throw new Y("spatial2dPadding expects `padding` to be an Array of two Arrays, each of which is an Array of two integers.");if(null==i&&(i="channelsLast"),"channelsLast"!==i&&"channelsFirst"!==i)throw new Y(`Unknown data format: ${i}. Supported data formats are 'channelsLast' and 'channelsFirst.`);let e;return e="channelsFirst"===i?[[0,0],[0,0],r[0],r[1]]:[[0,0],r[0],r[1],[0,0]],t.pad(n,e)}));var n,r,i}))}getConfig(){const t={padding:this.padding,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}function Gc(e,n,r,i,a,o){return s((()=>{let s;Ct(a),_t(o),zt(i),null==r&&(r=[1,1]),null==i&&(i="valid"),null==a&&(a="channelsLast"),null==o&&(o="max"),e=Vh(e,a);const l="same"===i?"same":"valid";return s="max"===o?t.maxPool(e,n,r,l):t.avgPool(e,n,r,l),"channelsFirst"===a&&(s=t.transpose(s,[0,3,1,2])),s}))}function Hc(e,n,r,i,a,o){return s((()=>{let s;Ct(a),_t(o),zt(i),null==r&&(r=[1,1,1]),null==i&&(i="valid"),null==a&&(a="channelsLast"),null==o&&(o="max"),e=Kh(e,a);const l="same"===i?"same":"valid";return s="max"===o?t.maxPool3d(e,n,r,l):t.avgPool3d(e,n,r,l),"channelsFirst"===a&&(s=t.transpose(s,[0,4,1,2,3])),s}))}qc.className="ZeroPadding2D",i.registerClass(qc);class Jc extends Ue{constructor(t){if(null==t.poolSize&&(t.poolSize=2),super(t),"number"==typeof t.poolSize)this.poolSize=[t.poolSize];else{if(!Array.isArray(t.poolSize)||1!==t.poolSize.length||"number"!=typeof t.poolSize[0])throw new Y(`poolSize for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(t.poolSize)}`);this.poolSize=t.poolSize}if(bt(this.poolSize,"poolSize"),null==t.strides)this.strides=this.poolSize;else if("number"==typeof t.strides)this.strides=[t.strides];else{if(!Array.isArray(t.strides)||1!==t.strides.length||"number"!=typeof t.strides[0])throw new Y(`strides for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(t.strides)}`);this.strides=t.strides}bt(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,zt(this.padding),this.inputSpec=[new Le({ndim:3})]}computeOutputShape(t){const e=Wh((t=_e(t))[1],this.poolSize[0],this.padding,this.strides[0]);return[t[0],e,t[2]]}call(e,n){return s((()=>{this.invokeCallHook(e,n),e=qt(ze(e),2);const s=this.poolingFunction(ze(e),[this.poolSize[0],1],[this.strides[0],1],this.padding,"channelsLast");return t.squeeze(s,[2])}))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides},e=super.getConfig();return Object.assign(t,e),t}}class Zc extends Jc{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return Ct(r),zt(s),Gc(t,e,n,s,r,"max")}}Zc.className="MaxPooling1D",i.registerClass(Zc);class Yc extends Jc{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return Ct(r),zt(s),Gc(t,e,n,s,r,"avg")}}Yc.className="AveragePooling1D",i.registerClass(Yc);class Xc extends Ue{constructor(t){if(null==t.poolSize&&(t.poolSize=[2,2]),super(t),this.poolSize=Array.isArray(t.poolSize)?t.poolSize:[t.poolSize,t.poolSize],null==t.strides)this.strides=this.poolSize;else if(Array.isArray(t.strides)){if(2!==t.strides.length)throw new Y(`If the strides property of a 2D pooling layer is an Array, it is expected to have a length of 2, but received length ${t.strides.length}.`);this.strides=t.strides}else this.strides=[t.strides,t.strides];bt(this.poolSize,"poolSize"),bt(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,Ct(this.dataFormat),zt(this.padding),this.inputSpec=[new Le({ndim:4})]}computeOutputShape(t){t=_e(t);let e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2];return e=Wh(e,this.poolSize[0],this.padding,this.strides[0]),n=Wh(n,this.poolSize[1],this.padding,this.strides[1]),"channelsFirst"===this.dataFormat?[t[0],t[1],e,n]:[t[0],e,n,t[3]]}call(t,e){return s((()=>(this.invokeCallHook(t,e),this.poolingFunction(ze(t),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class Qc extends Xc{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return Ct(r),zt(s),Gc(t,e,n,s,r,"max")}}Qc.className="MaxPooling2D",i.registerClass(Qc);class tp extends Xc{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return Ct(r),zt(s),Gc(t,e,n,s,r,"avg")}}tp.className="AveragePooling2D",i.registerClass(tp);class ep extends Ue{constructor(t){if(null==t.poolSize&&(t.poolSize=[2,2,2]),super(t),this.poolSize=Array.isArray(t.poolSize)?t.poolSize:[t.poolSize,t.poolSize,t.poolSize],null==t.strides)this.strides=this.poolSize;else if(Array.isArray(t.strides)){if(3!==t.strides.length)throw new Y(`If the strides property of a 3D pooling layer is an Array, it is expected to have a length of 3, but received length ${t.strides.length}.`);this.strides=t.strides}else this.strides=[t.strides,t.strides,t.strides];bt(this.poolSize,"poolSize"),bt(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,Ct(this.dataFormat),zt(this.padding),this.inputSpec=[new Le({ndim:5})]}computeOutputShape(t){t=_e(t);let e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2],s="channelsFirst"===this.dataFormat?t[4]:t[3];return e=Wh(e,this.poolSize[0],this.padding,this.strides[0]),n=Wh(n,this.poolSize[1],this.padding,this.strides[1]),s=Wh(s,this.poolSize[2],this.padding,this.strides[2]),"channelsFirst"===this.dataFormat?[t[0],t[1],e,n,s]:[t[0],e,n,s,t[4]]}call(t,e){return s((()=>(this.invokeCallHook(t,e),this.poolingFunction(ze(t),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class np extends ep{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return Ct(r),zt(s),Hc(t,e,n,s,r,"max")}}np.className="MaxPooling3D",i.registerClass(np);class sp extends ep{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return Ct(r),zt(s),Hc(t,e,n,s,r,"avg")}}sp.className="AveragePooling3D",i.registerClass(sp);class rp extends Ue{constructor(t){super(t),this.inputSpec=[new Le({ndim:3})]}computeOutputShape(t){return[t[0],t[2]]}call(t,e){throw new X}}class ip extends rp{constructor(t){super(t||{})}call(e,n){return s((()=>{const n=ze(e);return t.mean(n,1)}))}}ip.className="GlobalAveragePooling1D",i.registerClass(ip);class ap extends rp{constructor(t){super(t||{})}call(e,n){return s((()=>{const n=ze(e);return t.max(n,1)}))}}ap.className="GlobalMaxPooling1D",i.registerClass(ap);class op extends Ue{constructor(t){super(t),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,Ct(this.dataFormat),this.inputSpec=[new Le({ndim:4})]}computeOutputShape(t){return"channelsLast"===this.dataFormat?[t[0],t[3]]:[t[0],t[1]]}call(t,e){throw new X}getConfig(){const t={dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class lp extends op{call(e,n){return s((()=>{const n=ze(e);return"channelsLast"===this.dataFormat?t.mean(n,[1,2]):t.mean(n,[2,3])}))}}lp.className="GlobalAveragePooling2D",i.registerClass(lp);class up extends op{call(e,n){return s((()=>{const n=ze(e);return"channelsLast"===this.dataFormat?t.max(n,[1,2]):t.max(n,[2,3])}))}}up.className="GlobalMaxPooling2D",i.registerClass(up);class hp extends Ue{constructor(t){super(t),this.layer=t.layer}build(t){this.built=!0}get trainable(){return null!=this.layer&&this.layer.trainable}set trainable(t){null!=this.layer&&(this.layer.trainable=t)}get trainableWeights(){return this.layer.trainableWeights}get nonTrainableWeights(){return this.layer.nonTrainableWeights}get updates(){return this.layer._updates}get losses(){return this.layer.losses}getWeights(){return this.layer.getWeights()}setWeights(t){this.layer.setWeights(t)}getConfig(){const t={layer:{className:this.layer.getClassName(),config:this.layer.getConfig()}},e=super.getConfig();return Object.assign(t,e),t}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.layer&&this.layer.setFastWeightInitDuringBuild(t)}static fromConfig(t,e,n={}){const s=su(e.layer,n);delete e.layer;const r={layer:s};return Object.assign(r,e),new t(r)}}class cp extends hp{constructor(t){super(t),this.supportsMasking=!0}build(t){if((t=_e(t)).length<3)throw new Y(`TimeDistributed layer expects an input shape >= 3D, but received input shape ${JSON.stringify(t)}`);this.inputSpec=[{shape:t}];const e=[t[0]].concat(t.slice(2));this.layer.built||(this.layer.build(e),this.layer.built=!0),super.build(t)}computeOutputShape(t){const e=[(t=_e(t))[0]].concat(t.slice(2)),n=this.layer.computeOutputShape(e),s=t[1];return[n[0],s].concat(n.slice(1))}call(t,e){return s((()=>ic(((t,n)=>[ze(this.layer.call(t,e)),[]]),t=ze(t),[],!1,null,null,!1,!0)[1]))}}cp.className="TimeDistributed",i.registerClass(cp);class pp extends hp{constructor(t){super(t);const e=t.layer.getConfig(),n={};n.className=t.layer.getClassName(),n.config=e,this.forwardLayer=su(n),e.goBackwards=!0!==e.goBackwards;const s={};var r;if(s.className=t.layer.getClassName(),s.config=e,this.backwardLayer=su(s),this.forwardLayer.name="forward_"+this.forwardLayer.name,this.backwardLayer.name="backward_"+this.backwardLayer.name,this.mergeMode=void 0===t.mergeMode?"concat":t.mergeMode,r=this.mergeMode,gt(Tt,"BidirectionalMergeMode",r),t.weights)throw new X("weights support is not implemented for Bidirectional layer yet.");this._stateful=t.layer.stateful,this.returnSequences=t.layer.returnSequences,this.returnState=t.layer.returnState,this.supportsMasking=!0,this._trainable=!0,this.inputSpec=t.layer.inputSpec,this.numConstants=null}get trainable(){return this._trainable}set trainable(t){this._trainable=t,null!=this.forwardLayer&&(this.forwardLayer.trainable=t),null!=this.backwardLayer&&(this.backwardLayer.trainable=t)}getWeights(){return this.forwardLayer.getWeights().concat(this.backwardLayer.getWeights())}setWeights(t){const e=t.length,n=Math.floor(e/2);this.forwardLayer.setWeights(t.slice(0,n)),this.backwardLayer.setWeights(t.slice(n))}computeOutputShape(t){let e,n,s,r=this.forwardLayer.computeOutputShape(t);return Array.isArray(r)&&Array.isArray(r[0])||(r=[r]),this.returnState?(s=r.slice(1),e=r[0]):e=r[0],"concat"===this.mergeMode?(e[e.length-1]*=2,n=[e]):n=null==this.mergeMode?[e,e.slice()]:[e],this.returnState?null==this.mergeMode?n.concat(s).concat(s.slice()):[e].concat(s).concat(s.slice()):rt(n)}apply(t,e){let n=null==e?null:e.initialState,s=null==e?null:e.constants;null==e&&(e={});const r=rc(t,n,s,this.numConstants);if(t=r.inputs,n=r.initialState,s=r.constants,Array.isArray(t)&&(n=t.slice(1),t=t[0]),(null==n||0===n.length)&&null==s)return super.apply(t,e);const i=[],a=[];if(null!=n){const t=n.length;if(t%2>0)throw new Y("When passing `initialState` to a Bidrectional RNN, the state should be an Array containing the states of the underlying RNNs.");e.initialState=n,i.push(...n);const s=n.map((t=>new Le({shape:t.shape})));this.forwardLayer.stateSpec=s.slice(0,t/2),this.backwardLayer.stateSpec=s.slice(t/2),a.push(...s)}if(null!=s)throw new X("Support for constants in Bidirectional layers is not implemented yet.");const o=i[0]instanceof Oe;for(const t of i)if(t instanceof Oe!==o)throw new Y("The initial state of a Bidirectional layer cannot be specified as a mix of symbolic and non-symbolic tensors");if(o){const n=[t].concat(i),s=this.inputSpec.concat(a),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,e);return this.inputSpec=r,o}return super.apply(t,e)}call(e,n){return s((()=>{const s=n.initialState;let r,i,a,o;if(null==s)r=this.forwardLayer.call(e,n),i=this.backwardLayer.call(e,n);else{const t=s.slice(0,s.length/2),a=s.slice(s.length/2);r=this.forwardLayer.call(e,Object.assign(n,{initialState:t})),i=this.backwardLayer.call(e,Object.assign(n,{initialState:a}))}return this.returnState&&(Array.isArray(r)&&(a=r.slice(1).concat(i.slice(1))),r=r[0],i=i[0]),this.returnSequences&&(i=t.reverse(i,1)),"concat"===this.mergeMode?o=Zt([r,i]):"sum"===this.mergeMode?o=t.add(r,i):"ave"===this.mergeMode?o=t.mul(.5,t.add(r,i)):"mul"===this.mergeMode?o=t.mul(r,i):null==this.mergeMode&&(o=[r,i]),this.returnState?null==this.mergeMode?o.concat(a):[o].concat(a):o}))}resetStates(t){this.forwardLayer.resetStates(),this.backwardLayer.resetStates()}build(t){Ft(this.forwardLayer.name,(()=>{this.forwardLayer.build(t)})),Ft(this.backwardLayer.name,(()=>{this.backwardLayer.build(t)})),this.built=!0}computeMask(t,e){let n;if(Array.isArray(e)&&(e=e[0]),n=this.returnSequences?null==this.mergeMode?[e,e]:e:null==this.mergeMode?[null,null]:null,this.returnState){const t=this.forwardLayer.states.map((t=>null));return Array.isArray(n)?n.concat(t).concat(t):[n].concat(t).concat(t)}return n}get trainableWeights(){return this.forwardLayer.trainableWeights.concat(this.backwardLayer.trainableWeights)}get nonTrainableWeights(){return this.forwardLayer.nonTrainableWeights.concat(this.backwardLayer.nonTrainableWeights)}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.forwardLayer&&this.forwardLayer.setFastWeightInitDuringBuild(t),null!=this.backwardLayer&&this.backwardLayer.setFastWeightInitDuringBuild(t)}getConfig(){const t={mergeMode:this.mergeMode},e=super.getConfig();return Object.assign(t,e),t}static fromConfig(t,e){const n=su(e.layer);if(delete e.layer,null!=e.numConstants)throw new X("Deserialization of a Bidirectional layer with numConstants present is not supported yet.");const s=e;return s.layer=n,new t(s)}}pp.className="Bidirectional",i.registerClass(pp);class dp extends Ue{constructor(t){super(t),this.scale=t.scale,t.offset?this.offset=t.offset:this.offset=0}getConfig(){const t={scale:this.scale,offset:this.offset},e=super.getConfig();return Object.assign(t,e),t}call(t,e){return s((()=>("float32"!==(t=ze(t)).dtype&&(t=jt(t,"float32")),k(l(t,this.scale),this.offset))))}}dp.className="Rescaling",i.registerClass(dp);const fp=new Set(["bilinear","nearest"]);class gp extends Ue{constructor(t){if(super(t),this.height=t.height,this.width=t.width,t.interpolation){if(!fp.has(t.interpolation))throw new Y(`Invalid interpolation parameter: ${t.interpolation} is not implemented`);this.interpolation=t.interpolation}else this.interpolation="bilinear";this.cropToAspectRatio=Boolean(t.cropToAspectRatio)}computeOutputShape(t){const e=(t=_e(t))[2];return[this.height,this.width,e]}getConfig(){const t={height:this.height,width:this.width,interpolation:this.interpolation,cropToAspectRatio:this.cropToAspectRatio},e=super.getConfig();return Object.assign(t,e),t}call(t,e){return s((()=>{const e=[this.height,this.width];if("bilinear"===this.interpolation)return V.resizeBilinear(t,e,!this.cropToAspectRatio);if("nearest"===this.interpolation)return V.resizeNearestNeighbor(t,e,!this.cropToAspectRatio);throw new Error(`Interpolation is ${this.interpolation} but only ${[...fp]} are supported`)}))}}gp.className="Resizing",i.registerClass(gp);class mp extends Ue{constructor(t){super(t),this.numTokens=t.numTokens,t.outputMode?this.outputMode=t.outputMode:this.outputMode="multiHot"}getConfig(){const t={numTokens:this.numTokens,outputMode:this.outputMode},e=super.getConfig();return Object.assign(t,e),t}computeOutputShape(t){return null==(t=_e(t))?[this.numTokens]:"oneHot"===this.outputMode&&1!==t[t.length-1]?(t.push(this.numTokens),t):(t[t.length-1]=this.numTokens,t)}call(t,e){return s((()=>{let n;if("int32"!==(t=ze(t)).dtype&&(t=jt(t,"int32")),"undefined"!=typeof e.countWeights){if("count"!==this.outputMode)throw new Y(`countWeights is not used when outputMode !== count.\n              Received countWeights=${e.countWeights}`);n=ze(e.countWeights)}const s=q(t),r=G(t),i=L(this.numTokens,s).bufferSync().get(0),a=W(r,0).bufferSync().get(0);if(!i||!a)throw new Y(`Input values must be between 0 < values <= numTokens with numTokens=${this.numTokens}`);return function(t,e,n,s){let r=ze(t);if("int32"!==r.dtype&&(r=jt(r,"int32")),"int"===e)return r;const i=r.shape;if(0===r.rank&&(r=K(r,-1)),"oneHot"===e&&1!==r.shape[r.shape.length-1]&&(r=K(r,-1)),r.rank>2)throw new Y(`When outputMode is not int, maximum output rank is 2 Received outputMode ${e} and input shape ${i} which would result in output rank ${r.rank}.`);const a=["multiHot","oneHot"].includes(e);let o;if(o=j(r,"undefined"!=typeof s&&"count"===e?s:[],n,a),"tfIdf"!==e)return o;if(s)return l(o,s);throw new Y("When outputMode is 'tfIdf', weights must be provided.")}(t,this.outputMode,this.numTokens,n)}))}}function bp(t){return new Yc(t)}function yp(t){return new tp(t)}function wp(t){return new sp(t)}function kp(t){return new ap(t)}function vp(t){return new up(t)}function xp(t){return new Zc(t)}function Sp(t){return new Qc(t)}mp.className="CategoryEncoding",i.registerClass(mp);var Np={__proto__:null,inputLayer:function(t){return new Ke(t)},elu:function(t){return new Lh(t)},reLU:function(t){return new Fh(t)},leakyReLU:function(t){return new Rh(t)},prelu:function(t){return new Mh(t)},softmax:function(t){return new Bh(t)},thresholdedReLU:function(t){return new Oh(t)},conv1d:function(t){return new tc(t)},conv2d:function(t){return new Hh(t)},conv2dTranspose:function(t){return new Zh(t)},conv3d:function(t){return new Jh(t)},conv3dTranspose:function(t){return new Yh(t)},separableConv2d:function(t){return new Qh(t)},cropping2D:function(t){return new ec(t)},upSampling2d:function(t){return new nc(t)},depthwiseConv2d:function(t){return new sc(t)},activation:function(t){return new Nc(t)},dense:function(t){return new xc(t)},dropout:function(t){return new kc(t)},spatialDropout1d:function(t){return new vc(t)},flatten:function(t){return new Sc(t)},repeatVector:function(t){return new Ec(t)},reshape:function(t){return new Ic(t)},permute:function(t){return new Ac(t)},embedding:function(t){return new $c(t)},add:function(t){return new zc(t)},average:function(t){return new Dc(t)},concatenate:function(t){return new Mc(t)},maximum:function(t){return new Fc(t)},minimum:function(t){return new Rc(t)},multiply:function(t){return new _c(t)},dot:function(t){return new Oc(t)},batchNormalization:function(t){return new Kc(t)},layerNormalization:function(t){return new jc(t)},zeroPadding2d:function(t){return new qc(t)},averagePooling1d:bp,avgPool1d:function(t){return bp(t)},avgPooling1d:function(t){return bp(t)},averagePooling2d:yp,avgPool2d:function(t){return yp(t)},avgPooling2d:function(t){return yp(t)},averagePooling3d:wp,avgPool3d:function(t){return wp(t)},avgPooling3d:function(t){return wp(t)},globalAveragePooling1d:function(t){return new ip(t)},globalAveragePooling2d:function(t){return new lp(t)},globalMaxPooling1d:kp,globalMaxPooling2d:vp,maxPooling1d:xp,maxPooling2d:Sp,maxPooling3d:function(t){return new np(t)},gru:function(t){return new cc(t)},gruCell:function(t){return new hc(t)},lstm:function(t){return new dc(t)},lstmCell:function(t){return new pc(t)},simpleRNN:function(t){return new uc(t)},simpleRNNCell:function(t){return new lc(t)},convLstm2d:function(t){return new wc(t)},convLstm2dCell:function(t){return new yc(t)},rnn:function(t){return new ac(t)},stackedRNNCells:function(t){return new fc(t)},bidirectional:function(t){return new pp(t)},timeDistributed:function(t){return new cp(t)},globalMaxPool1d:kp,globalMaxPool2d:vp,maxPool1d:xp,maxPool2d:Sp,Layer:Ue,RNN:ac,RNNCell:oc,input:oh,gaussianNoise:function(t){return new Bc(t)},gaussianDropout:function(t){return new Pc(t)},alphaDropout:function(t){return new Wc(t)},masking:function(t){return new Tc(t)},rescaling:function(t){return new dp(t)},resizing:function(t){return new gp(t)},categoryEncoding:function(t){return new mp(t)}};var Ep={__proto__:null,binaryAccuracy:function(t,e){return fu(t,e)},binaryCrossentropy:function(t,e){return wu(t,e)},sparseCategoricalAccuracy:function(t,e){return ku(t,e)},categoricalAccuracy:function(t,e){return gu(t,e)},categoricalCrossentropy:function(t,e){return vu(t,e)},precision:function(t,e){return bu(t,e)},recall:function(t,e){return yu(t,e)},cosineProximity:function(t,e){return cu(t,e)},meanAbsoluteError:function(t,e){return au(t,e)},meanAbsolutePercentageError:function(t,e){return ou(t,e)},MAPE:function(t,e){return ou(t,e)},mape:function(t,e){return ou(t,e)},meanSquaredError:function(t,e){return iu(t,e)},MSE:function(t,e){return iu(t,e)},mse:function(t,e){return iu(t,e)}},Ip={__proto__:null,modelFromJSON:async function(t,e){"modelTopology"in t||(t={modelTopology:t});let n=t.modelTopology;null!=n.model_config&&(n=n.model_config);const s=su(Du(n),e);if(null!=t.weightsManifest){const e=await $.loadWeights(t.weightsManifest,t.pathPrefix,s.weights.map((t=>t.originalName))),n={};for(const t of s.weights)n[t.originalName]=e[t.originalName];s.loadWeights(n),g(e)}return s}};var Ap={__proto__:null,l1l2:function(t){return new $h(t)},l1:function(t){return Ah(e=t),new $h({l1:null!=e?e.l1:null,l2:0});var e},l2:function(t){return Ah(e=t),new $h({l2:null!=e?e.l2:null,l1:0});var e}};class Tp extends Jl{constructor(){super(...arguments),this.model=null}setModel(t){if(!(t instanceof eh))throw new Error("model must be a LayersModel, not some other Container");this.model=t}}function $p(t,e){return t<e}function Cp(t,e){return t>e}class zp extends Tp{constructor(t){if(super(),null==t&&(t={}),t.restoreBestWeights)throw new X("restoreBestWeights = True is not implemented in EarlyStopping yet.");this.monitor=t.monitor||"val_loss",this.minDelta=Math.abs(t.minDelta||0),this.patience=t.patience||0,this.verbose=t.verbose||0,this.mode=t.mode||"auto",this.baseline=t.baseline,-1===["auto","min","max"].indexOf(this.mode)&&(console.warn(`EarlyStopping mode '${this.mode}' is invalid. Falling back to mode 'auto'.`),this.mode="auto"),"min"===this.mode?this.monitorFunc=$p:"max"===this.mode||-1!==this.monitor.indexOf("acc")?this.monitorFunc=Cp:this.monitorFunc=$p,this.monitorFunc===$p&&(this.minDelta*=-1)}async onTrainBegin(t){this.wait=0,this.stoppedEpoch=0,null!=this.baseline?this.best=this.baseline:this.best=this.monitorFunc===$p?1/0:-1/0}async onEpochEnd(t,e){await Gl(e);const n=this.getMonitorValue(e);null!=n&&(this.monitorFunc(n-this.minDelta,this.best)?(this.best=n,this.wait=0):(this.wait++,this.wait>=this.patience&&(this.stoppedEpoch=t,this.model.stopTraining=!0)))}async onTrainEnd(t){this.stoppedEpoch>0&&this.verbose&&console.log(`Epoch ${this.stoppedEpoch}: early stopping.`)}getMonitorValue(t){null==t&&(t={});const e=t[this.monitor];return null==e&&console.warn(`Metric for EarlyStopping ${this.monitor} is not available. Available metrics are: ${Object.keys(t)}`),e}}const _p={earlyStopping:function(t){return new zp(t)}};export{Tp as Callback,Zl as CallbackList,Ql as CustomCallback,zp as EarlyStopping,Xl as History,Le as InputSpec,Fe as LayerVariable,eh as LayersModel,ac as RNN,rh as Sequential,Oe as SymbolicTensor,_p as callbacks,Kl as constraints,ql as initializers,oh as input,Np as layers,sh as loadLayersModel,Ep as metrics,ih as model,Ip as models,lh as registerCallbackConstructor,Ap as regularizers,ah as sequential,Ru as version_layers};
//# sourceMappingURL=tf-layers.fesm.min.js.map
