/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t=t||self).tf=t.tf||{})}(this,(function(t){"use strict";class e{constructor(t,e){this.backend=t,this.dataMover=e,this.data=new WeakMap,this.dataIdsCount=0}get(t){return this.data.has(t)||this.dataMover.moveData(this.backend,t),this.data.get(t)}set(t,e){this.dataIdsCount++,this.data.set(t,e)}has(t){return this.data.has(t)}delete(t){return this.dataIdsCount--,this.data.delete(t)}numDataIds(){return this.dataIdsCount}}class n{time(t){return s("time")}read(t){return s("read")}readSync(t){return s("readSync")}numDataIds(){return s("numDataIds")}disposeData(t){return s("disposeData")}write(t,e,n){return s("write")}move(t,e,n,r){return s("move")}memory(){return s("memory")}floatPrecision(){return s("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}batchMatMul(t,e,n,r){return s("batchMatMul")}fusedBatchMatMul({a:t,b:e,transposeA:n,transposeB:r,bias:a,activation:i,preluActivationWeights:o}){return s("fusedBatchMatMul")}slice(t,e,n){return s("slice")}stridedSlice(t,e,n,r){return s("stridedSlice")}unstack(t,e){return s("unstack")}reverse(t,e){return s("reverse")}concat(t,e){return s("concat")}neg(t){return s("neg")}add(t,e){return s("add")}addN(t){return s("addN")}subtract(t,e){return s("subtract")}multiply(t,e){return s("multiply")}realDivide(t,e){return s("realDivide")}floorDiv(t,e){return s("floorDiv")}sum(t,e){return s("sum")}prod(t,e){return s("prod")}unsortedSegmentSum(t,e,n){return s("unsortedSegmentSum")}argMin(t,e){return s("argMin")}argMax(t,e){return s("argMax")}equal(t,e){return s("equal")}notEqual(t,e){return s("notEqual")}less(t,e){return s("less")}lessEqual(t,e){return s("lessEqual")}greater(t,e){return s("greater")}greaterEqual(t,e){return s("greaterEqual")}logicalNot(t){return s("logicalNot")}logicalAnd(t,e){return s("logicalAnd")}logicalOr(t,e){return s("logicalOr")}where(t){return s("where")}select(t,e,n){return s("select")}topk(t,e,n){return s("topk")}min(t,e){return s("min")}minimum(t,e){return s("minimum")}mod(t,e){return s("mod")}max(t,e){return s("max")}maximum(t,e){return s("maximum")}all(t,e){return s("all")}any(t,e){return s("any")}squaredDifference(t,e){return s("squaredDifference")}ceil(t){return s("ceil")}floor(t){return s("floor")}round(t){return s("round")}sign(t){return s("sign")}isNaN(t){return s("isNaN")}isInf(t){return s("isInf")}isFinite(t){return s("isFinite")}pow(t,e){return s("pow")}exp(t){return s("exp")}expm1(t){return s("expm1")}softmax(t,e){return s("softmax")}log(t){return s("log")}log1p(t){return s("log1p")}sqrt(t){return s("sqrt")}rsqrt(t){return s("rsqrt")}square(t){return s("square")}reciprocal(t){return s("reciprocal")}relu(t){return s("relu")}relu6(t){return s("relu6")}prelu(t,e){return s("prelu")}elu(t){return s("elu")}eluDer(t,e){return s("eluDer")}selu(t){return s("selu")}int(t){return s("int")}clip(t,e,n){return s("clip")}abs(t){return s("abs")}complexAbs(t){return s("complexAbs")}sigmoid(t){return s("sigmoid")}softplus(t){return s("softplus")}sin(t){return s("sin")}cos(t){return s("cos")}tan(t){return s("tan")}asin(t){return s("asin")}acos(t){return s("acos")}atan(t){return s("atan")}atan2(t,e){return s("atan2")}sinh(t){return s("sinh")}cosh(t){return s("cosh")}tanh(t){return s("tanh")}asinh(t){return s("asinh")}acosh(t){return s("acosh")}atanh(t){return s("atanh")}erf(t){return s("erf")}step(t,e){return s("step")}fusedConv2d({input:t,filter:e,convInfo:n,bias:r,activation:a,preluActivationWeights:i}){return s("fusedConv2d")}conv2d(t,e,n){return s("conv2d")}conv2dDerInput(t,e,n){return s("conv2dDerInput")}conv2dDerFilter(t,e,n){return s("conv2dDerFilter")}fusedDepthwiseConv2D({input:t,filter:e,convInfo:n,bias:r,activation:a,preluActivationWeights:i}){return s("fusedDepthwiseConv2D")}depthwiseConv2D(t,e,n){return s("depthwiseConv2D")}depthwiseConv2DDerInput(t,e,n){return s("depthwiseConv2DDerInput")}depthwiseConv2DDerFilter(t,e,n){return s("depthwiseConv2DDerFilter")}conv3d(t,e,n){return s("conv3d")}conv3dDerInput(t,e,n){return s("conv3dDerInput")}conv3dDerFilter(t,e,n){return s("conv3dDerFilter")}maxPool(t,e){return s("maxPool")}maxPoolBackprop(t,e,n,r){return s("maxPoolBackprop")}avgPool(t,e){return s("avgPool")}avgPoolBackprop(t,e,n){return s("avgPoolBackprop")}avgPool3d(t,e){return s("avgPool3d")}avgPool3dBackprop(t,e,n){return s("avgPool3dBackprop")}maxPool3d(t,e){return s("maxPool3d")}maxPool3dBackprop(t,e,n,r){return s("maxPool3dBackprop")}reshape(t,e){return s("reshape")}cast(t,e){return s("cast")}tile(t,e){return s("tile")}pad(t,e,n){return s("pad")}transpose(t,e){return s("transpose")}gather(t,e,n){return s("gather")}gatherND(t,e){return s("gatherND")}scatterND(t,e,n){return s("scatterND")}batchToSpaceND(t,e,n){return s("batchToSpaceND")}spaceToBatchND(t,e,n){return s("spaceToBatchND")}resizeBilinear(t,e,n,r){return s("resizeBilinear")}resizeBilinearBackprop(t,e,n){return s("resizeBilinearBackprop")}resizeNearestNeighbor(t,e,n,r){return s("resizeNearestNeighbor")}resizeNearestNeighborBackprop(t,e,n){return s("resizeNearestNeighborBackprop")}batchNorm(t,e,n,r,a,i){return s("batchNorm")}localResponseNormalization4D(t,e,n,r,a){return s("localResponseNormalization4D")}LRNGrad(t,e,n,r,a,i,o){return s("LRNGrad")}multinomial(t,e,n,r){return s("multinomial")}oneHot(t,e,n,r){return s("oneHot")}cumsum(t,e,n,r){return s("cumsum")}nonMaxSuppression(t,e,n,r,a){return s("nonMaxSuppression")}fft(t){return s("fft")}ifft(t){return s("ifft")}complex(t,e){return s("complex")}real(t){return s("real")}imag(t){return s("imag")}cropAndResize(t,e,n,r,a,i){return s("cropAndResize")}depthToSpace(t,e,n){return s("depthToSpace")}split(t,e,n){return s("split")}sparseToDense(t,e,n,r){return s("sparseToDense")}diag(t){return s("diag")}fill(t,e,n){return s("fill")}onesLike(t){return s("onesLike")}zerosLike(t){return s("zerosLike")}linspace(t,e,n){return s("linspace")}dispose(){return s("dispose")}}function s(t){throw new Error(`'${t}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function r(t){let e=t.length,n=0,s=0;for(;e>0;)s=Math.random()*e|0,e--,n=t[e],t[e]=t[s],t[s]=n}function a(t,e,n){return Math.max(t,Math.min(e,n))}function i(t){return t%2==0?t:t+1}function o(t){let e=0;for(let n=0;n<t.length;n++)e+=t[n];return e}function l(t,e){if(!t)throw new Error("string"==typeof e?e:e())}function u(t,e,n=""){l(d(t,e),()=>n+` Shapes ${t} and ${e} must match`)}function c(t){l(null!=t,()=>"The input to the tensor constructor must be a non-null value.")}function h(t,e=[],n=!1){if(null==e&&(e=[]),Array.isArray(t)||S(t)&&!n)for(let s=0;s<t.length;++s)h(t[s],e,n);else e.push(t);return e}function p(t){if(0===t.length)return 1;let e=t[0];for(let n=1;n<t.length;n++)e*=t[n];return e}function d(t,e){if(t===e)return!0;if(null==t||null==e)return!1;if(t.length!==e.length)return!1;for(let n=0;n<t.length;n++)if(t[n]!==e[n])return!1;return!0}function f(t){return t%1==0}function m(t){const e=Math.ceil(Math.sqrt(t));return[e,Math.ceil(t/e)]}function g(t,e){return e<=t.length?t:t+" ".repeat(e-t.length)}function y(t,e=(t=>0),n){return new Promise((s,r)=>{let a=0;const i=()=>{if(t())return void s();a++;const o=e(a);null!=n&&a>=n?r():setTimeout(i,o)};i()})}function b(t,e){let n=1,s=-1;for(let e=0;e<t.length;++e)if(t[e]>=0)n*=t[e];else if(-1===t[e]){if(-1!==s)throw Error(`Shapes can only have 1 implicit size. Found -1 at dim ${s} and dim ${e}`);s=e}else if(t[e]<0)throw Error(`Shapes can not be < 0. Found ${t[e]} at dim ${e}`);if(-1===s){if(e>0&&e!==n)throw Error(`Size(${e}) must match the product of shape ${t}`);return t}if(0===n)throw Error(`Cannot infer the missing size in [${t}] when there are 0 elements`);if(e%n!=0)throw Error(`The implicit shape can't be a fractional number. Got ${e} / ${n}`);const r=t.slice();return r[s]=e/n,r}function x(t,e){const n=e.length;return l((t=null==t?e.map((t,e)=>e):[].concat(t)).every(t=>t>=-n&&t<n),()=>`All values in axis param must be in range [-${n}, ${n}) but got axis `+t),l(t.every(t=>f(t)),()=>"All values in axis param must be integers but got axis "+t),t.map(t=>t<0?n+t:t)}function w(t,e){const n=[],s=[],r=null!=e&&Array.isArray(e)&&0===e.length,a=null==e||r?null:x(e,t).sort();let i=0;for(let e=0;e<t.length;++e){if(null!=a){if(a[i]===e&&1!==t[e])throw new Error(`Can't squeeze axis ${e} since its dim '${t[e]}' is not 1`);(null==a[i]||a[i]>e)&&1===t[e]&&(n.push(t[e]),s.push(e)),a[i]<=e&&i++}1!==t[e]&&(n.push(t[e]),s.push(e))}return{newShape:n,keptDims:s}}function v(t,e){let n=null;if(null==t||"float32"===t)n=new Float32Array(e);else if("int32"===t)n=new Int32Array(e);else{if("bool"!==t)throw new Error("Unknown data type "+t);n=new Uint8Array(e)}return n}function k(t,e){let n=null;if(null==t||"float32"===t)n=new Float32Array(e);else if("int32"===t)n=new Int32Array(e);else if("bool"===t)n=new Uint8Array(e);else{if("string"!==t)throw new Error("Unknown data type "+t);n=new Array(e)}return n}function N(t,e){for(let n=0;n<t.length;n++){const s=t[n];if(isNaN(s)||!isFinite(s))throw Error(`A tensor of type ${e} being uploaded contains ${s}.`)}}function I(t){return"bool"===t||"complex64"===t||"float32"===t||"int32"===t||"string"===t}function C(t,e){return"complex64"!==e&&(("float32"!==e||"complex64"===t)&&(("int32"!==e||"float32"===t||"complex64"===t)&&("bool"!==e||"bool"!==t)))}function S(t){return t instanceof Float32Array||t instanceof Int32Array||t instanceof Uint8Array}function T(t){if("float32"===t||"int32"===t)return 4;if("complex64"===t)return 8;if("bool"===t)return 1;throw new Error("Unknown dtype "+t)}function E(t){if(null==t)return 0;let e=0;return t.forEach(t=>e+=t.length),e}function $(t){return"string"==typeof t||t instanceof String}function A(t){return"boolean"==typeof t}function R(t){return"number"==typeof t}function D(t){return Array.isArray(t)?D(t[0]):t instanceof Float32Array?"float32":t instanceof Int32Array||t instanceof Uint8Array?"int32":R(t)?"float32":$(t)?"string":A(t)?"bool":"float32"}function _(t){return!!(t&&t.constructor&&t.call&&t.apply)}function F(t,e){for(let n=e;n<t;++n)if(t%n==0)return n;return t}function O(t){const e=t.length;if(e<2)return[];const n=new Array(e-1);n[e-2]=t[e-1];for(let s=e-3;s>=0;--s)n[s]=n[s+1]*t[s+1];return n}function M(t,e){if(0===t.length)return e[0];const n=t.reduce((t,e)=>t*e);if(0===n)return[];if(n!==e.length)throw new Error(`[${t}] does not match the input size ${e.length}.`);return function t(e,n,s){const r=new Array;if(1===n.length){const t=n[0];for(let n=0;n<t;n++)r[n]=s[e+n]}else{const a=n[0],i=n.slice(1),o=i.reduce((t,e)=>t*e);for(let n=0;n<a;n++)r[n]=t(e+n*o,i,s)}return r}(0,t,e)}function L(t,e){const n=z(t,e);for(let t=0;t<n.length;t++)n[t]=1;return n}function z(t,e){if(null==e||"float32"===e||"complex64"===e)return new Float32Array(t);if("int32"===e)return new Int32Array(t);if("bool"===e)return new Uint8Array(t);throw new Error("Unknown data type "+e)}function B(t,e){const n=t.reduce((t,e)=>t*e,1);if(null==e||"float32"===e)return M(t,new Float32Array(n));if("int32"===e)return M(t,new Int32Array(n));if("bool"===e)return M(t,new Uint8Array(n));throw new Error("Unknown data type "+e)}function P(t){t.forEach(e=>{l(Number.isInteger(e)&&e>=0,()=>`Tensor must have a shape comprised of positive integers but got shape [${t}].`)})}function W(t,e,n){if(0===e)return 0;if(1===e)return t[0];let s=t[t.length-1];for(let e=0;e<t.length-1;++e)s+=n[e]*t[e];return s}function V(t,e,n){if(0===e)return[];if(1===e)return[t];const s=new Array(e);for(let e=0;e<s.length-1;++e)s[e]=Math.floor(t/n[e]),t-=s[e]*n[e];return s[s.length-1]=t,s}function U(t){return t&&t.then&&"function"==typeof t.then}class G{constructor(t){this.global=t,this.flags={},this.flagRegistry={},this.urlFlags={},this.populateURLFlags()}setPlatform(t,e){null!=this.platform&&console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${e}.`),this.platformName=t,this.platform=e}registerFlag(t,e,n){if(this.flagRegistry[t]={evaluationFn:e,setHook:n},null!=this.urlFlags[t]){const e=this.urlFlags[t];console.warn(`Setting feature override from URL ${t}: ${e}.`),this.set(t,e)}}async getAsync(t){return t in this.flags||(this.flags[t]=await this.evaluateFlag(t)),this.flags[t]}get(t){if(t in this.flags)return this.flags[t];const e=this.evaluateFlag(t);if(U(e))throw new Error(`Flag ${t} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[t]=e,this.flags[t]}getNumber(t){return this.get(t)}getBool(t){return this.get(t)}getFlags(){return this.flags}get features(){return this.flags}set(t,e){if(null==this.flagRegistry[t])throw new Error(`Cannot set flag ${t} as it has not been registered.`);this.flags[t]=e,null!=this.flagRegistry[t].setHook&&this.flagRegistry[t].setHook(e)}evaluateFlag(t){if(null==this.flagRegistry[t])throw new Error(`Cannot evaluate flag '${t}': no evaluation function found.`);return this.flagRegistry[t].evaluationFn()}setFlags(t){this.flags=Object.assign({},t)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if(void 0===this.global||void 0===this.global.location||void 0===this.global.location.search)return;const t=function(t){const e={};return t.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,(t,...n)=>(function(t,e,n){t[decodeURIComponent(e)]=decodeURIComponent(n||"")}(e,n[0],n[1]),n.join("="))),e}(this.global.location.search);if("tfjsflags"in t){t.tfjsflags.split(",").forEach(t=>{const[e,n]=t.split(":");this.urlFlags[e]=function(t,e){if("true"===(e=e.toLowerCase())||"false"===e)return"true"===e;if(""+ +e===e)return+e;throw new Error(`Could not parse value flag value ${e} for flag ${t}.`)}(e,n)})}}}function H(){return t.ENV}let j;function q(){if(null==j){let t;if("undefined"!=typeof window)t=window;else if("undefined"!=typeof global)t=global;else if("undefined"!=typeof process)t=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");t=self}j=t}return j}function K(t,e){const n=function(){const t=q();return null==t._tfGlobals&&(t._tfGlobals=new Map),t._tfGlobals}();if(n.has(t))return n.get(t);{const s=e();return n.set(t,s),n.get(t)}}t.ENV=null;const X="Add",Y="Cos",J="Div",Z="Sin",Q="Sub",tt="Tan",et=K("kernelRegistry",()=>new Map),nt=K("gradRegistry",()=>new Map);function st(t,e){const n=lt(t,e);return et.get(n)}function rt(t){return nt.get(t)}function at(t){const e=et.entries(),n=[];for(;;){const{done:s,value:r}=e.next();if(s)break;const[a,i]=r,[o]=a.split("_");o===t&&n.push(i)}return n}function it(t){const{kernelName:e,backendName:n}=t,s=lt(e,n);et.has(s)&&console.warn(`The kernel '${e}' for backend '${n}' is already registered`),et.set(s,t)}function ot(t){const{kernelName:e}=t;nt.has(e)&&H().getBool("DEBUG")&&console.warn(`Overriding the gradient for '${e}'`),nt.set(e,t)}function lt(t,e){return`${e}_${t}`}function ut(t,e){return"string"===e?dt(t):ct([t],e)}function ct(t,e){if("string"===e)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(t)&&(t=h(t)),H().getBool("DEBUG")&&N(t,e),function(t,e){return t instanceof Float32Array&&"float32"===e||t instanceof Int32Array&&"int32"===e||t instanceof Uint8Array&&"bool"===e}(t,e))return t;if(null==e||"float32"===e||"complex64"===e)return new Float32Array(t);if("int32"===e)return new Int32Array(t);if("bool"===e){const e=new Uint8Array(t.length);for(let n=0;n<e.length;++n)0!==Math.round(t[n])&&(e[n]=1);return e}throw new Error("Unknown data type "+e)}function ht(){return H().platform.now()}function pt(t,e){return H().platform.fetch(t,e)}function dt(t,e="utf-8"){return e=e||"utf-8",H().platform.encode(t,e)}function ft(t,e="utf-8"){return e=e||"utf-8",H().platform.decode(t,e)}var mt=Object.freeze({__proto__:null,createScalarValue:ut,toTypedArray:ct,now:ht,fetch:pt,encodeString:dt,decodeString:ft,shuffle:r,clamp:a,nearestLargerEven:i,sum:o,randUniform:function(t,e){const n=Math.random();return e*n+(1-n)*t},distSquared:function(t,e){let n=0;for(let s=0;s<t.length;s++){const r=Number(t[s])-Number(e[s]);n+=r*r}return n},assert:l,assertShapesMatch:u,assertNonNull:c,flatten:h,sizeFromShape:p,isScalarShape:function(t){return 0===t.length},arraysEqual:d,isInt:f,tanh:function(t){if(null!=Math.tanh)return Math.tanh(t);if(t===1/0)return 1;if(t===-1/0)return-1;{const e=Math.exp(2*t);return(e-1)/(e+1)}},sizeToSquarishShape:m,createShuffledIndices:function(t){const e=new Uint32Array(t);for(let n=0;n<t;++n)e[n]=n;return r(e),e},rightPad:g,repeatedTry:y,inferFromImplicitShape:b,parseAxisParam:x,squeezeShape:w,getTypedArrayFromDType:v,getArrayFromDType:k,checkConversionForErrors:N,isValidDtype:I,hasEncodingLoss:C,isTypedArray:S,bytesPerElement:T,bytesFromStringArray:E,isString:$,isBoolean:A,isNumber:R,inferDtype:D,isFunction:_,nearestDivisor:F,computeStrides:O,toNestedArray:M,makeOnesTypedArray:L,makeZerosTypedArray:z,makeZerosNestedTypedArray:B,assertNonNegativeIntegerDimensions:P,locToIndex:W,indexToLoc:V,isPromise:U});class gt{constructor(t,e){this.backendTimer=t,this.logger=e,null==e&&(this.logger=new bt)}profileKernel(t,e,n){let s;const r=this.backendTimer.time(()=>{s=n()});for(let e=0;e<s.length;e++){const n=s[e];n.data().then(e=>{yt(e,n.dtype,t)})}return{kernelName:t,outputs:s,inputs:e,timeMs:r.then(t=>t.kernelMs),extraInfo:r.then(t=>null!=t.getExtraProfileInfo?t.getExtraProfileInfo():"")}}logKernelProfile(t){const{kernelName:e,outputs:n,timeMs:s,inputs:r,extraInfo:a}=t;n.forEach(t=>{Promise.all([t.data(),s,a]).then(n=>{this.logger.logKernelProfile(e,t,n[0],n[1],r,n[2])})})}}function yt(t,e,n){if("float32"!==e)return!1;for(let e=0;e<t.length;e++){const s=t[e];if(isNaN(s)||!isFinite(s))return console.warn(`Found ${s} in the result of '${n}'`),!0}return!1}class bt{logKernelProfile(t,e,n,s,r,a){const i="number"==typeof s?g(s+"ms",9):s.error,o=g(t,25),l=e.rank,u=e.size,c=g(e.shape.toString(),14);let h="";for(const t in r){const n=r[t];if(null!=n){const s=n.shape||e.shape,r=s.length;h+=`${t}: ${r}D ${r>0?s:""} `}}console.log(`%c${o}\t%c${i}\t%c${l}D ${c}\t%c${u}\t%c${h}\t%c${a}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function xt(t,e,n,s){const r=O(e),a=function(t,e,n,s){const r=p(e),a=s[s.length-1],i=new Array(a).fill(0),o=e.length,l="complex64"===n?kt(t):t;if(o>1)for(let t=0;t<r/a;t++){const e=t*a;for(let t=0;t<a;t++)i[t]=Math.max(i[t],wt(l[e+t],0,n).length)}return i}(t,e,n,r),i=e.length,o=function t(e,n,s,r,a,i=!0){const o="complex64"===s?2:1,l=n[0],u=n.length;if(0===u){if("complex64"===s){return[wt(kt(e)[0],0,s)]}return"bool"===s?[vt(e[0])]:[e[0].toString()]}if(1===u){if(l>20){const t=3*o;let n=Array.from(e.slice(0,t)),r=Array.from(e.slice((l-3)*o,l*o));return"complex64"===s&&(n=kt(n),r=kt(r)),["["+n.map((t,e)=>wt(t,a[e],s)).join(", ")+", ..., "+r.map((t,e)=>wt(t,a[l-3+e],s)).join(", ")+"]"]}return["["+("complex64"===s?kt(e):Array.from(e)).map((t,e)=>wt(t,a[e],s)).join(", ")+"]"]}const c=n.slice(1),h=r.slice(1),p=r[0]*o,d=[];if(l>20){for(let n=0;n<3;n++){const r=n*p,i=r+p;d.push(...t(e.slice(r,i),c,s,h,a,!1))}d.push("...");for(let n=l-3;n<l;n++){const r=n*p,i=r+p;d.push(...t(e.slice(r,i),c,s,h,a,n===l-1))}}else for(let n=0;n<l;n++){const r=n*p,i=r+p;d.push(...t(e.slice(r,i),c,s,h,a,n===l-1))}const f=2===u?",":"";d[0]="["+d[0]+f;for(let t=1;t<d.length-1;t++)d[t]=" "+d[t]+f;let m=",\n";for(let t=2;t<u;t++)m+="\n";return d[d.length-1]=" "+d[d.length-1]+"]"+(i?"":m),d}(t,e,n,r,a),l=["Tensor"];return s&&(l.push("  dtype: "+n),l.push("  rank: "+i),l.push(`  shape: [${e}]`),l.push("  values:")),l.push(o.map(t=>"    "+t).join("\n")),l.join("\n")}function wt(t,e,n){let s;return s=Array.isArray(t)?parseFloat(t[0].toFixed(7))+" + "+parseFloat(t[1].toFixed(7))+"j":$(t)?`'${t}'`:"bool"===n?vt(t):parseFloat(t.toFixed(7)).toString(),g(s,e)}function vt(t){return 0===t?"false":"true"}function kt(t){const e=[];for(let n=0;n<t.length;n+=2)e.push([t[n],t[n+1]]);return e}class Nt{constructor(t,e,n){if(this.dtype=e,this.shape=t.slice(),this.size=p(t),null!=n){const t=n.length;l(t===this.size,()=>`Length of values '${t}' does not match the size inferred by the shape '${this.size}'.`)}if("complex64"===e)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||k(e,this.size),this.strides=O(t)}set(t,...e){0===e.length&&(e=[0]),l(e.length===this.rank,()=>`The number of provided coordinates (${e.length}) must match the rank (${this.rank})`);const n=this.locToIndex(e);this.values[n]=t}get(...t){0===t.length&&(t=[0]);let e=0;for(const n of t){if(n<0||n>=this.shape[e]){const e=`Requested out of range element at ${t}.   Buffer shape=`+this.shape;throw new Error(e)}e++}let n=t[t.length-1];for(let e=0;e<t.length-1;++e)n+=this.strides[e]*t[e];return this.values[n]}locToIndex(t){if(0===this.rank)return 0;if(1===this.rank)return t[0];let e=t[t.length-1];for(let n=0;n<t.length-1;++n)e+=this.strides[n]*t[n];return e}indexToLoc(t){if(0===this.rank)return[];if(1===this.rank)return[t];const e=new Array(this.shape.length);for(let n=0;n<e.length-1;++n)e[n]=Math.floor(t/this.strides[n]),t-=e[n]*this.strides[n];return e[e.length-1]=t,e}get rank(){return this.shape.length}toTensor(){return It().makeTensor(this.values,this.shape,this.dtype)}}let It=null,Ct=null,St=null;class Tt{constructor(t,e,n,s){this.kept=!1,this.isDisposedInternal=!1,this.shape=t.slice(),this.dtype=e||"float32",this.size=p(t),this.strides=O(t),this.dataId=n,this.id=s,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const t=await this.data();return Ct.buffer(this.shape,this.dtype,t)}bufferSync(){return Ct.buffer(this.shape,this.dtype,this.dataSync())}async array(){const t=await this.data();return M(this.shape,t)}arraySync(){return M(this.shape,this.dataSync())}async data(){this.throwIfDisposed();const t=It().read(this.dataId);if("string"===this.dtype){const e=await t;try{return e.map(t=>ft(t))}catch(t){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return t}dataSync(){this.throwIfDisposed();const t=It().readSync(this.dataId);if("string"===this.dtype)try{return t.map(t=>ft(t))}catch(t){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return t}async bytes(){this.throwIfDisposed();const t=await It().read(this.dataId);return"string"===this.dtype?t:new Uint8Array(t.buffer)}dispose(){this.isDisposed||(It().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(t=!1){return Ct.print(this,t)}clone(){return this.throwIfDisposed(),Ct.clone(this)}toString(t=!1){return xt(this.dataSync(),this.shape,this.dtype,t)}cast(t){return this.throwIfDisposed(),Ct.cast(this,t)}variable(t=!0,e,n){return this.throwIfDisposed(),It().makeVariable(this,t,e,n)}}Object.defineProperty(Tt,Symbol.hasInstance,{value:t=>!!t&&null!=t.data&&null!=t.dataSync&&null!=t.throwIfDisposed});class Et extends Tt{constructor(t,e,n,s){super(t.shape,t.dtype,t.dataId,s),this.trainable=e,this.name=n}assign(t){if(t.dtype!==this.dtype)throw new Error(`dtype of the new value (${t.dtype}) and previous value (${this.dtype}) must match`);if(!d(t.shape,this.shape))throw new Error(`shape of the new value (${t.shape}) and previous value (${this.shape}) must match`);It().disposeTensor(this),this.dataId=t.dataId,It().incRef(this,null)}dispose(){It().disposeVariable(this),this.isDisposedInternal=!0}}var $t,At,Rt,Dt,_t;Object.defineProperty(Et,Symbol.hasInstance,{value:t=>t instanceof Tt&&null!=t.assign&&t.assign instanceof Function}),($t=t.Rank||(t.Rank={})).R0="R0",$t.R1="R1",$t.R2="R2",$t.R3="R3",$t.R4="R4",$t.R5="R5",$t.R6="R6",function(t){t.float32="float32",t.int32="int32",t.bool="int32",t.complex64="complex64"}(At||(At={})),function(t){t.float32="float32",t.int32="int32",t.bool="bool",t.complex64="complex64"}(Rt||(Rt={})),function(t){t.float32="float32",t.int32="float32",t.bool="float32",t.complex64="complex64"}(Dt||(Dt={})),function(t){t.float32="complex64",t.int32="complex64",t.bool="complex64",t.complex64="complex64"}(_t||(_t={}));const Ft={float32:Dt,int32:At,bool:Rt,complex64:_t};function Ot(t,e){if("string"===t||"string"===e){if("string"===t&&"string"===e)return"string";throw new Error(`Can not upcast ${t} with ${e}`)}return Ft[t][e]}function Mt(t){return Ot(t,"int32")}function Lt(t,e){if(t.dtype===e.dtype)return[t,e];const n=Ot(t.dtype,e.dtype);return[t.cast(n),e.cast(n)]}function zt(t,e){l(t.dtype===e.dtype,()=>`The dtypes of the first(${t.dtype}) and second(${e.dtype}) input must match`)}function Bt(t,e){return e.some(e=>e.id===t.id)}function Pt(t){const e=[];return function t(e,n,s){if(null==e)return;if(e instanceof Tt)return void n.push(e);if(r=e,!Array.isArray(r)&&"object"!=typeof r)return;var r;const a=e;for(const e in a){const r=a[e];s.has(r)||(s.add(r),t(r,n,s))}}(t,e,new Set),e}var Wt=Object.freeze({__proto__:null,makeTypesMatch:Lt,assertTypesMatch:zt,isTensorInList:Bt,getTensorsInContainer:Pt});class Vt{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null}}dispose(){for(const t in this.registeredVariables)this.registeredVariables[t].dispose()}}class Ut{constructor(t){this.ENV=t,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new Vt}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then(()=>{});if(null!=this.backendInstance)return;const t=this.getSortedBackends();for(let e=0;e<t.length;e++){const n=t[e];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:t,asyncInit:e}=this.initializeBackendsAndReturnBest();if(e)throw new Error(`The highest priority backend '${t}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(t)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(t){if(!(t in this.registry)){if(!(t in this.registryFactory))return null;{const{asyncInit:e}=this.initializeBackend(t);if(e)return null}}return this.registry[t]}findBackendFactory(t){return t in this.registryFactory?this.registryFactory[t].factory:null}registerBackend(t,e,n=1){return t in this.registryFactory?(console.warn(t+" backend was already registered. Reusing existing backend factory."),!1):(this.registryFactory[t]={factory:e,priority:n},!0)}async setBackend(t){if(null==this.registryFactory[t])throw new Error(`Backend name '${t}' not found in registry`);if(this.backendName=t,null==this.registry[t]){this.backendInstance=null;const{success:e,asyncInit:n}=this.initializeBackend(t);if(!(n?await e:e))return!1}return this.backendInstance=this.registry[t],this.setupRegisteredKernels(),this.profiler=new gt(this.backendInstance),!0}setupRegisteredKernels(){at(this.backendName).forEach(t=>{null!=t.setupFunc&&t.setupFunc(this.backendInstance)})}disposeRegisteredKernels(t){at(t).forEach(e=>{null!=e.disposeFunc&&e.disposeFunc(this.registry[t])})}initializeBackend(t){const e=this.registryFactory[t];if(null==e)throw new Error(`Cannot initialize backend ${t}, no registration found.`);try{const s=e.factory();if(!s||s instanceof n||"function"!=typeof s.then)return this.registry[t]=s,{success:!0,asyncInit:!1};{const e=++this.pendingBackendInitId,n=s.then(n=>!(e<this.pendingBackendInitId)&&(this.registry[t]=n,this.pendingBackendInit=null,!0)).catch(n=>(e<this.pendingBackendInitId||(this.pendingBackendInit=null,console.warn(`Initialization of backend ${t} failed`),console.warn(n.stack||n.message)),!1));return this.pendingBackendInit=n,{success:n,asyncInit:!0}}}catch(e){return console.warn(`Initialization of backend ${t} failed`),console.warn(e.stack||e.message),{success:!1,asyncInit:!1}}}removeBackend(t){if(!(t in this.registryFactory))throw new Error(t+" backend not found in registry");this.backendName===t&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,t in this.registry&&(this.disposeRegisteredKernels(t),this.registry[t].dispose(),delete this.registry[t]),delete this.registryFactory[t],this.backendName===t&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort((t,e)=>this.registryFactory[e].priority-this.registryFactory[t].priority)}initializeBackendsAndReturnBest(){const t=this.getSortedBackends();for(let e=0;e<t.length;e++){const n=t[e],{success:s,asyncInit:r}=this.initializeBackend(n);if(r||s)return{name:n,asyncInit:r}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(t,e){const n=this.state.tensorInfo.get(e),s=n.backend,r=this.readSync(e);s.disposeData(e),n.backend=t,t.move(e,r,n.shape,n.dtype),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(t,e){let n,s=null;if(null==e){if("function"!=typeof t)throw new Error("Please provide a function to tidy()");e=t}else{if("string"!=typeof t&&!(t instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof e)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");s=t}return this.scopedRun(()=>this.startScope(s),()=>this.endScope(n),()=>(n=e(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n))}scopedRun(t,e,n){t();try{const t=n();return e(),t}catch(t){throw e(),t}}nextTensorId(){return Ut.nextTensorId++}nextVariableId(){return Ut.nextVariableId++}clone(t){const e=this.makeTensorFromDataId(t.dataId,t.shape,t.dtype),n={x:t};return this.addTapeNode(this.state.activeScope.name,n,[e],t=>({x:()=>{const e={x:t},n={dtype:"float32"};return Ht.runKernelFunc(e=>e.cast(t,"float32"),e,null,"Cast",n)}}),[],{}),e}runKernel(t,e,n,s,r){return this.runKernelFunc(null,e,null,t,n,s,r)}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(t,e,n){const s=this.backend.numDataIds();let r=0;n.forEach(t=>{r+="complex64"===t.dtype?3:1});const a=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],i=s-e-r-a;if(i>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${i} data ids) after running '${t}'`)}runKernelFunc(t,e,n,s,r,a,i){let o,l=[];const u=this.isTapeOn();null==s&&(s=null!=this.state.activeScope?this.state.activeScope.name:"");const c=this.state.numBytes,h=this.state.numTensors;let p;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0);const d=st(s,this.backendName);let f,m;if(null!=d)p=()=>{const t=this.backend.numDataIds();f=d.kernelFunc({inputs:e,attrs:r,backend:this.backend});const n=Array.isArray(f)?f:[f];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(s,t,n);const o=n.map(({dataId:t,shape:e,dtype:n})=>this.makeTensorFromDataId(t,e,n));if(u){let t=this.getTensorsForGradient(s,e,o);if(null==t){null==i&&(i=[]);const e=o.filter((t,e)=>i[e]);t=(a||[]).slice().concat(e)}l=this.saveTensorsForBackwardMode(t)}return o};else{const e=t=>{u&&(l=t.map(t=>this.keep(this.clone(t))))};p=()=>{const n=this.backend.numDataIds();f=this.tidy(()=>t(this.backend,e));const r=Array.isArray(f)?f:[f];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(s,n,r),r}}return this.scopedRun(()=>this.state.kernelDepth++,()=>this.state.kernelDepth--,()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(m=this.profiler.profileKernel(s,e,()=>p()),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(m),o=m.outputs):o=p()}),u&&this.addTapeNode(s,e,o,n,l,r),this.state.profiling&&this.state.activeProfile.kernels.push({name:s,bytesAdded:this.state.numBytes-c,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-h,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(e).map(t=>null!=e[t]?e[t].shape:null),outputShapes:o.map(t=>t.shape),kernelTimeMs:m.timeMs,extraInfo:m.extraInfo}),Array.isArray(f)?o:o[0]}saveTensorsForBackwardMode(t){return t.map(t=>this.keep(this.clone(t)))}getTensorsForGradient(t,e,n){const s=rt(t);if(null!=s){const t=s.inputsToSave||[],r=s.outputsToSave||[];let a;s.saveAllInputs?(l(Array.isArray(e),()=>"saveAllInputs is true, expected inputs to be an array."),a=Object.keys(e).map(t=>e[t])):a=t.map(t=>e[t]);const i=n.filter((t,e)=>r[e]);return a.concat(i)}return null}makeTensor(t,e,n,s){if(null==t)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",s=s||this.backend;let r=t;"string"===n&&$(t[0])&&(r=t.map(t=>dt(t)));const a=s.write(r,e,n),i=new Tt(e,n,a,this.nextTensorId());if(this.incRef(i,s),"string"===n){const t=this.state.tensorInfo.get(a),e=E(r);this.state.numBytes+=e-t.bytes,t.bytes=e}return i}makeTensorFromDataId(t,e,n,s){const r=new Tt(e,n=n||"float32",t,this.nextTensorId());return this.incRef(r,s),r}makeVariable(t,e=!0,n,s){n=n||this.nextVariableId().toString(),null!=s&&s!==t.dtype&&(t=t.cast(s));const r=new Et(t,e,n,this.nextTensorId());if(null!=this.state.registeredVariables[r.name])throw new Error(`Variable with name ${r.name} was already registered`);return this.state.registeredVariables[r.name]=r,this.incRef(r,this.backend),r}incRef(t,e){const n=this.state.tensorInfo.has(t.dataId)?this.state.tensorInfo.get(t.dataId).refCount:0;if(this.state.numTensors++,"string"===t.dtype&&this.state.numStringTensors++,0===n){this.state.numDataBuffers++;let n=0;"complex64"!==t.dtype&&"string"!==t.dtype&&(n=t.size*T(t.dtype)),this.state.tensorInfo.set(t.dataId,{backend:e||this.backend,dtype:t.dtype,shape:t.shape,bytes:n,refCount:0}),this.state.numBytes+=n}this.state.tensorInfo.get(t.dataId).refCount++,t instanceof Et||this.track(t)}disposeTensor(t){if(!this.state.tensorInfo.has(t.dataId))return;this.state.numTensors--,"string"===t.dtype&&this.state.numStringTensors--;const e=this.state.tensorInfo.get(t.dataId);e.refCount<=1?("complex64"!==t.dtype&&(this.state.numBytes-=e.bytes),this.state.numDataBuffers--,e.backend.disposeData(t.dataId),this.state.tensorInfo.delete(t.dataId)):this.state.tensorInfo.get(t.dataId).refCount--}disposeVariables(){for(const t in this.state.registeredVariables){const e=this.state.registeredVariables[t];this.disposeVariable(e)}}disposeVariable(t){this.disposeTensor(t),null!=this.state.registeredVariables[t.name]&&delete this.state.registeredVariables[t.name]}memory(){const t=this.backend.memory();return t.numTensors=this.state.numTensors,t.numDataBuffers=this.state.numDataBuffers,t.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(t.unreliable=!0,null==t.reasons&&(t.reasons=[]),t.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),t}async profile(t){this.state.profiling=!0;const e=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await t(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map(t=>t.totalBytesSnapshot)),this.state.activeProfile.newBytes=this.state.numBytes-e,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const t of this.state.activeProfile.kernels)t.kernelTimeMs=await t.kernelTimeMs,t.extraInfo=await t.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(t,e,n,s,r,a){const i={id:this.state.nextTapeNodeId++,kernelName:t,inputs:e,outputs:n,saved:r},o=rt(t);null!=o&&(s=o.gradFunc),null!=s&&(i.gradient=t=>(t=t.map((t,e)=>{if(null==t){const t=n[e],s=z(t.size,t.dtype);return this.makeTensor(s,t.shape,t.dtype)}return t}),s(t.length>1?t:t[0],r,a))),this.state.activeTape.push(i)}keep(t){return t.kept=!0,t}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(t){const e={track:[],name:"unnamed scope",id:this.state.nextScopeId++};t&&(e.name=t),this.state.scopeStack.push(e),this.state.activeScope=e}endScope(t){const e=Pt(t),n=new Set(e.map(t=>t.id));for(let t=0;t<this.state.activeScope.track.length;t++){const e=this.state.activeScope.track[t];e.kept||n.has(e.id)||e.dispose()}const s=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],e.forEach(t=>{t.kept||t.scopeId!==s.id||this.track(t)})}gradients(t,e,n,s=!1){if(l(e.length>0,()=>"gradients() received an empty list of xs."),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const r=this.scopedRun(()=>this.startTape(),()=>this.endTape(),()=>this.tidy("forward",t));l(r instanceof Tt,()=>"The result y returned by f() must be a tensor.");const a=function(t,e,n){const s={},r={};for(let t=0;t<e.length;t++)s[e[t].id]=!0;for(let n=0;n<t.length;n++){const a=t[n],i=a.inputs;for(const t in i){const n=i[t];let o=!1;for(let t=0;t<e.length;t++)if(s[n.id]){a.outputs.forEach(t=>s[t.id]=!0),o=!0,r[a.id]=!0;break}if(o)break}}const a={};a[n.id]=!0;const i={};for(let e=t.length-1;e>=0;e--){const n=t[e],s=n.inputs;for(let t=0;t<n.outputs.length;t++)if(a[n.outputs[t].id]){for(const t in s)a[s[t].id]=!0,i[n.id]=!0;break}}const o=[];for(let e=0;e<t.length;e++){const n=t[e];if(r[n.id]&&i[n.id]){const t={};for(const e in n.inputs){const r=n.inputs[e];s[r.id]&&(t[e]=r)}const e=Object.assign({},n);e.inputs=t,e.outputs=n.outputs,o.push(e)}}return o}(this.state.activeTape,e,r);if(!s&&0===a.length&&e.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",()=>{const t={};t[r.id]=null==n?function(t){const e=L(p(t),"float32");return Ht.makeTensor(e,t,"float32")}(r.shape):n,function(t,e,n,s){for(let r=e.length-1;r>=0;r--){const a=e[r],i=[];if(a.outputs.forEach(e=>{const n=t[e.id];null!=n?i.push(n):i.push(null)}),null==a.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${a.kernelName}.`);const o=a.gradient(i);for(const e in a.inputs){if(!(e in o))throw new Error(`Cannot backprop through input ${e}. Available gradients found: ${Object.keys(o)}.`);const r=n(()=>o[e]());if("float32"!==r.dtype)throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input ${e} must have 'float32' dtype, but has '${r.dtype}'`);const i=a.inputs[e];if(!d(r.shape,i.shape))throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input '${e}' has shape '${r.shape}', which does not match the shape of the input '${i.shape}'`);if(null==t[i.id])t[i.id]=r;else{const e=t[i.id];t[i.id]=s(e,r),e.dispose()}}}}(t,a,t=>this.tidy(t),jt);const s=e.map(e=>t[e.id]);return 0===this.state.gradientDepth&&(this.state.activeTape.forEach(t=>{for(const e of t.saved)e.dispose()}),this.state.activeTape=null),{value:r,grads:s}})}customGrad(t){return l(_(t),()=>"The f passed in customGrad(f) must be a function."),(...e)=>{let n;l(e.every(t=>t instanceof Tt),()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors");const s={};return e.forEach((t,e)=>{s[e]=t}),this.runKernelFunc((s,r)=>(n=t(...e,r),l(n.value instanceof Tt,()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor"),l(_(n.gradFunc),()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function."),n.value),s,(t,s)=>{const r=n.gradFunc(t,s),a=Array.isArray(r)?r:[r];l(a.length===e.length,()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...)."),l(a.every(t=>t instanceof Tt),()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors.");const i={};return a.forEach((t,e)=>{i[e]=()=>t}),i})}}readSync(t){return this.state.tensorInfo.get(t).backend.readSync(t)}read(t){return this.state.tensorInfo.get(t).backend.read(t)}async time(t){const e=ht(),n=await this.backend.time(t);return n.wallMs=ht()-e,n}track(t){return null!=this.state.activeScope&&(t.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(t)),t}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new Vt;for(const t in this.registry)this.disposeRegisteredKernels(t),this.registry[t].dispose(),delete this.registry[t];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}function Gt(){const e=q();if(null==e._tfengine){const t=new G(e);e._tfengine=new Ut(t)}var n;return n=e._tfengine.ENV,t.ENV=n,It=()=>e._tfengine,e._tfengine}Ut.nextTensorId=0,Ut.nextVariableId=0;const Ht=Gt();function jt(t,e){const n={a:t,b:e};return Ht.runKernelFunc((n,s)=>{const r=n.add(t,e);return s([t,e]),r},n,null,X)}function qt(){if("undefined"!=typeof navigator&&null!=navigator){const t=navigator.userAgent||navigator.vendor||window.opera;return/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(t)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(t.substr(0,4))}return!1}function Kt(){return"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope}var Xt=Object.freeze({__proto__:null,isMobile:qt,isBrowser:Kt});const Yt=H();function Jt(t,e){let n=t;if(S(t))return"string"===e?[]:[t.length];if(!Array.isArray(t))return[];const s=[];for(;Array.isArray(n)||S(n)&&"string"!==e;)s.push(n.length),n=n[0];return Array.isArray(t)&&H().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&function t(e,n,s){if(s=s||[],!Array.isArray(e)&&!S(e))return void l(0===n.length,()=>`Element arr[${s.join("][")}] is a primitive, but should be an array/TypedArray of ${n[0]} elements`);l(n.length>0,()=>`Element arr[${s.join("][")}] should be a primitive, but is an array of ${e.length} elements`),l(e.length===n[0],()=>`Element arr[${s.join("][")}] should have ${n[0]} elements, but has ${e.length} elements`);const r=n.slice(1);for(let n=0;n<e.length;++n)t(e[n],r,s.concat(n))}(t,s,[]),s}function Zt(t,e,n,s){if(null!=t&&("numeric"!==t&&t!==e||"numeric"===t&&"string"===e))throw new Error(`Argument '${n}' passed to '${s}' must be ${t} tensor, but got ${e} tensor`)}function Qt(t,e,n,s="numeric"){if(t instanceof Tt)return Zt(s,t.dtype,e,n),t;let r=D(t);if("string"!==r&&["bool","int32","float32"].indexOf(s)>=0&&(r=s),Zt(s,r,e,n),null==t||!S(t)&&!Array.isArray(t)&&"number"!=typeof t&&"boolean"!=typeof t&&"string"!=typeof t){const s=null==t?"null":t.constructor.name;throw new Error(`Argument '${e}' passed to '${n}' must be a Tensor or TensorLike, but got '${s}'`)}const a=Jt(t,r);S(t)||Array.isArray(t)||(t=[t]);const i="string"!==r?ct(t,r):h(t,[],!0);return Ht.makeTensor(i,a,r)}function te(t,e,n,s="numeric"){if(!Array.isArray(t))throw new Error(`Argument ${e} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return t.map((t,s)=>Qt(t,`${e}[${s}]`,n),s)}Yt.registerFlag("DEBUG",()=>!1,t=>{t&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")}),Yt.registerFlag("IS_BROWSER",()=>Kt()),Yt.registerFlag("IS_NODE",()=>"undefined"!=typeof process&&void 0!==process.versions&&void 0!==process.versions.node),Yt.registerFlag("IS_CHROME",()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor)),Yt.registerFlag("PROD",()=>!1),Yt.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",()=>Yt.getBool("DEBUG")),Yt.registerFlag("DEPRECATION_WARNINGS_ENABLED",()=>!0),Yt.registerFlag("IS_TEST",()=>!1);function ee(t){const e=Object.keys(t);if(1!==e.length)throw new Error("Please provide an object with a single key (operation name) mapping to a function. Got an object with "+e.length+" keys.");let n=e[0];const s=t[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+="__op";const r=(...t)=>{Ht.startScope(n);try{const e=s(...t);return U(e)&&console.error("Cannot return a Promise inside of tidy."),Ht.endScope(e),e}catch(t){throw Ht.endScope(null),t}};return Object.defineProperty(r,"name",{value:n,configurable:!0}),r}const ne=ee({complex_:function(t,e){const n=Qt(t,"real","complex"),s=Qt(e,"imag","complex");u(n.shape,s.shape,`real and imag shapes, ${n.shape} and ${s.shape}, must match in call to tf.complex().`);const r={real:n,imag:s};return Ht.runKernelFunc(t=>t.complex(n,s),r,null,"Complex")}});function se(t,e,n,s){if(null==s&&(s=D(t)),"complex64"===s)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!S(t)&&!Array.isArray(t)&&"number"!=typeof t&&"boolean"!=typeof t&&"string"!=typeof t)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=e){P(e);const t=p(e),s=p(n);l(t===s,()=>`Based on the provided shape, [${e}], the tensor should have ${t} values but has ${s}`);for(let t=0;t<n.length;++t){const s=n[t],r=t!==n.length-1||s!==p(e.slice(t));l(n[t]===e[t]||!r,()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${e}). `)}}return S(t)||Array.isArray(t)||(t=[t]),e=e||n,t="string"!==s?ct(t,s):h(t,[],!0),Ht.makeTensor(t,e,s)}function re(t,e,n){return se(t,e,Jt(t,n),n)}const ae={float32:4,float16:2,int32:4,uint16:2,uint8:1,bool:1,complex64:8};async function ie(t,e){const n=[],s=[],r=Array.isArray(t)?t.map(t=>t.name):Object.keys(t);for(let a=0;a<r.length;++a){const i=r[a],o=Array.isArray(t)?t[a].tensor:t[i];if("float32"!==o.dtype&&"int32"!==o.dtype&&"bool"!==o.dtype&&"string"!==o.dtype&&"complex64"!==o.dtype)throw new Error(`Unsupported dtype in weight '${i}': ${o.dtype}`);const l={name:i,shape:o.shape,dtype:o.dtype};if("string"===o.dtype){const t=new Promise(async t=>{const e=await o.bytes(),n=e.reduce((t,e)=>t+e.length,0)+4*e.length,s=new Uint8Array(n);let r=0;for(let t=0;t<e.length;t++){const n=e[t],a=new Uint8Array(new Uint32Array([n.length]).buffer);s.set(a,r),r+=4,s.set(n,r),r+=n.length}t(s)});s.push(t)}else s.push(o.data());null!=e&&(l.group=e),n.push(l)}return{data:le(await Promise.all(s)),specs:n}}function oe(t,e){const n={};let s,r=0;for(const a of e){const e=a.name,i=a.dtype,o=a.shape,l=p(o);let u;if("quantization"in a){const n=a.quantization;if("uint8"===n.dtype||"uint16"===n.dtype){if(!("min"in n)||!("scale"in n))throw new Error(`Weight ${a.name} with quantization ${n.dtype} doesn't have corresponding metadata min and scale.`)}else{if("float16"!==n.dtype)throw new Error(`Weight ${a.name} has unknown quantization dtype ${n.dtype}. Supported quantization dtypes are: 'uint8', 'uint16', and 'float16'.`);if("float32"!==i)throw new Error(`Weight ${a.name} is quantized with ${n.dtype} which only supports weights of type float32 not ${i}.`)}const o=ae[n.dtype],c=t.slice(r,r+l*o),h="uint8"===n.dtype?new Uint8Array(c):new Uint16Array(c);if("float32"===i)if("uint8"===n.dtype||"uint16"===n.dtype){u=new Float32Array(h.length);for(let t=0;t<h.length;t++){const e=h[t];u[t]=e*n.scale+n.min}}else{if("float16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type float32.`);void 0===s&&(s=fe()),u=s(h)}else{if("int32"!==i)throw new Error(`Unsupported dtype in weight '${e}': ${i}`);if("uint8"!==n.dtype&&"uint16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type int32.`);u=new Int32Array(h.length);for(let t=0;t<h.length;t++){const e=h[t];u[t]=Math.round(e*n.scale+n.min)}}r+=l*o}else if("string"===i){const e=p(a.shape);u=[];for(let n=0;n<e;n++){const e=new Uint32Array(t.slice(r,r+4))[0];r+=4;const n=new Uint8Array(t.slice(r,r+e));u.push(n),r+=e}}else{const s=ae[i],a=t.slice(r,r+l*s);if("float32"===i)u=new Float32Array(a);else if("int32"===i)u=new Int32Array(a);else if("bool"===i)u=new Uint8Array(a);else{if("complex64"!==i)throw new Error(`Unsupported dtype in weight '${e}': ${i}`);{u=new Float32Array(a);const t=new Float32Array(u.length/2),s=new Float32Array(u.length/2);for(let e=0;e<t.length;e++)t[e]=u[2*e],s[e]=u[2*e+1];const r=re(t,o,"float32"),i=re(s,o,"float32");n[e]=ne(r,i),r.dispose(),i.dispose()}}r+=l*s}"complex64"!==i&&(n[e]=re(u,o,i))}return n}function le(t){if(null===t)throw new Error("Invalid input value: "+JSON.stringify(t));let e=0;const n=[];t.forEach(t=>{if(e+=t.byteLength,n.push(t.byteLength===t.buffer.byteLength?t:new t.constructor(t)),!(t instanceof Float32Array||t instanceof Int32Array||t instanceof Uint8Array))throw new Error("Unsupported TypedArray subtype: "+t.constructor.name)});const s=new Uint8Array(e);let r=0;return n.forEach(t=>{s.set(new Uint8Array(t.buffer),r),r+=t.byteLength}),s.buffer}const ue="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function ce(t){return ue?Buffer.byteLength(t):new Blob([t]).size}function he(t){if(1===t.length)return t[0];let e=0;t.forEach(t=>{e+=t.byteLength});const n=new Uint8Array(e);let s=0;return t.forEach(t=>{n.set(new Uint8Array(t),s),s+=t.byteLength}),n.buffer}function pe(t){for(t=t.trim();t.endsWith("/");)t=t.slice(0,t.length-1);const e=t.split("/");return e[e.length-1]}function de(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==t.modelTopology?0:ce(JSON.stringify(t.modelTopology)),weightSpecsBytes:null==t.weightSpecs?0:ce(JSON.stringify(t.weightSpecs)),weightDataBytes:null==t.weightData?0:t.weightData.byteLength}}function fe(){const t=function(){const t=t=>{let e=t<<13,n=0;for(;0==(8388608&e);)n-=8388608,e<<=1;return e&=-8388609,n+=947912704,e|n},e=new Uint32Array(2048);e[0]=0;for(let n=1;n<1024;n++)e[n]=t(n);for(let t=1024;t<2048;t++)e[t]=939524096+(t-1024<<13);return e}(),e=function(){const t=new Uint32Array(64);t[0]=0,t[31]=1199570944,t[32]=2147483648,t[63]=3347054592;for(let e=1;e<31;e++)t[e]=e<<23;for(let e=33;e<63;e++)t[e]=2147483648+(e-32<<23);return t}(),n=function(){const t=new Uint32Array(64);for(let e=0;e<64;e++)t[e]=1024;return t[0]=t[32]=0,t}();return s=>{const r=new ArrayBuffer(4*s.length),a=new Uint32Array(r);for(let r=0;r<s.length;r++){const i=s[r],o=t[n[i>>10]+(1023&i)]+e[i>>10];a[r]=o}return new Float32Array(r)}}class me{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==me.instance&&(me.instance=new me),me.instance}static registerSaveRouter(t){me.getInstance().saveRouters.push(t)}static registerLoadRouter(t){me.getInstance().loadRouters.push(t)}static getSaveHandlers(t){return me.getHandlers(t,"save")}static getLoadHandlers(t,e){return me.getHandlers(t,"load",e)}static getHandlers(t,e,n){const s=[];return("load"===e?me.getInstance().loadRouters:me.getInstance().saveRouters).forEach(e=>{const r=e(t,n);null!==r&&s.push(r)}),s}}const ge=t=>me.getSaveHandlers(t),ye=(t,e)=>me.getLoadHandlers(t,e);function be(){if(!H().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const t="undefined"==typeof window?self:window,e=t.indexedDB||t.mozIndexedDB||t.webkitIndexedDB||t.msIndexedDB||t.shimIndexedDB;if(null==e)throw new Error("The current browser does not appear to support IndexedDB.");return e}function xe(t){const e=t.result;e.createObjectStore("models_store",{keyPath:"modelPath"}),e.createObjectStore("model_info_store",{keyPath:"modelPath"})}class we{constructor(t){if(this.indexedDB=be(),null==t||!t)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=t}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,t)}async load(){return this.databaseAction(this.modelPath)}databaseAction(t,e){return new Promise((t,n)=>{const s=this.indexedDB.open("tensorflowjs",1);s.onupgradeneeded=()=>xe(s),s.onsuccess=()=>{const r=s.result;if(null==e){const e=r.transaction("models_store","readonly"),s=e.objectStore("models_store").get(this.modelPath);s.onsuccess=()=>{if(null==s.result)return r.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));t(s.result.modelArtifacts)},s.onerror=t=>(r.close(),n(s.error)),e.oncomplete=()=>r.close()}else{const s=de(e),a=r.transaction("model_info_store","readwrite");let i=a.objectStore("model_info_store");const o=i.put({modelPath:this.modelPath,modelArtifactsInfo:s});let l;o.onsuccess=()=>{l=r.transaction("models_store","readwrite");const o=l.objectStore("models_store").put({modelPath:this.modelPath,modelArtifacts:e,modelArtifactsInfo:s});o.onsuccess=()=>t({modelArtifactsInfo:s}),o.onerror=t=>{i=a.objectStore("model_info_store");const e=i.delete(this.modelPath);e.onsuccess=()=>(r.close(),n(o.error)),e.onerror=t=>(r.close(),n(o.error))}},o.onerror=t=>(r.close(),n(o.error)),a.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}}},s.onerror=t=>n(s.error)})}}we.URL_SCHEME="indexeddb://";const ve=t=>{return H().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(we.URL_SCHEME)?(e=t.slice(we.URL_SCHEME.length),new we(e)):null;var e};me.registerSaveRouter(ve),me.registerLoadRouter(ve);class ke{constructor(){this.indexedDB=be()}async listModels(){return new Promise((t,e)=>{const n=this.indexedDB.open("tensorflowjs",1);n.onupgradeneeded=()=>xe(n),n.onsuccess=()=>{const s=n.result,r=s.transaction("model_info_store","readonly"),a=r.objectStore("model_info_store").getAll();a.onsuccess=()=>{const e={};for(const t of a.result)e[t.modelPath]=t.modelArtifactsInfo;t(e)},a.onerror=t=>(s.close(),e(a.error)),r.oncomplete=()=>s.close()},n.onerror=t=>e(n.error)})}async removeModel(t){var e;return t=(e=t).startsWith(we.URL_SCHEME)?e.slice(we.URL_SCHEME.length):e,new Promise((e,n)=>{const s=this.indexedDB.open("tensorflowjs",1);s.onupgradeneeded=()=>xe(s),s.onsuccess=()=>{const r=s.result,a=r.transaction("model_info_store","readwrite"),i=a.objectStore("model_info_store"),o=i.get(t);let l;o.onsuccess=()=>{if(null==o.result)return r.close(),n(new Error(`Cannot find model with path '${t}' in IndexedDB.`));{const s=i.delete(t),a=()=>{l=r.transaction("models_store","readwrite");const s=l.objectStore("models_store").delete(t);s.onsuccess=()=>e(o.result.modelArtifactsInfo),s.onerror=t=>n(o.error)};s.onsuccess=a,s.onerror=t=>(a(),r.close(),n(o.error))}},o.onerror=t=>(r.close(),n(o.error)),a.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}},s.onerror=t=>n(s.error)})}}const Ne="tensorflowjs_models",Ie="info",Ce="model_topology",Se="weight_specs",Te="weight_data",Ee="model_metadata";function $e(t){return{info:[Ne,t,Ie].join("/"),topology:[Ne,t,Ce].join("/"),weightSpecs:[Ne,t,Se].join("/"),weightData:[Ne,t,Te].join("/"),modelMetadata:[Ne,t,Ee].join("/")}}function Ae(t){const e=t.split("/");if(e.length<3)throw new Error("Invalid key format: "+t);return e.slice(1,e.length-1).join("/")}class Re{constructor(t){if(!H().getBool("IS_BROWSER")||"undefined"==typeof window||void 0===window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==t||!t)throw new Error("For local storage, modelPath must not be null, undefined or empty.");this.modelPath=t,this.keys=$e(this.modelPath)}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const e=JSON.stringify(t.modelTopology),n=JSON.stringify(t.weightSpecs),s=de(t);try{return this.LS.setItem(this.keys.info,JSON.stringify(s)),this.LS.setItem(this.keys.topology,e),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(t){if(ue)return Buffer.from(t).toString("base64");const e=new Uint8Array(t);let n="";for(let t=0,s=e.length;t<s;t++)n+=String.fromCharCode(e[t]);return btoa(n)}(t.weightData)),this.LS.setItem(this.keys.modelMetadata,JSON.stringify({format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy,userDefinedMetadata:t.userDefinedMetadata})),{modelArtifactsInfo:s}}catch(t){throw this.LS.removeItem(this.keys.info),this.LS.removeItem(this.keys.topology),this.LS.removeItem(this.keys.weightSpecs),this.LS.removeItem(this.keys.weightData),this.LS.removeItem(this.keys.modelMetadata),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${s.modelTopologyBytes}, weightSpecsBytes=${s.weightSpecsBytes}, weightDataBytes=${s.weightDataBytes}.`)}}}async load(){const t=JSON.parse(this.LS.getItem(this.keys.info));if(null==t)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==t.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const e={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);e.modelTopology=n;const s=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==s)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);e.weightSpecs=s;const r=this.LS.getItem(this.keys.modelMetadata);if(null!=r){const t=JSON.parse(r);e.format=t.format,e.generatedBy=t.generatedBy,e.convertedBy=t.convertedBy,e.userDefinedMetadata=t.userDefinedMetadata}const a=this.LS.getItem(this.keys.weightData);if(null==a)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return e.weightData=function(t){if(ue){const e=Buffer.from(t,"base64");return e.buffer.slice(e.byteOffset,e.byteOffset+e.byteLength)}const e=atob(t),n=new Uint8Array(e.length);for(let t=0;t<e.length;++t)n.set([e.charCodeAt(t)],t);return n.buffer}(a),e}}Re.URL_SCHEME="localstorage://";const De=t=>{return H().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(Re.URL_SCHEME)?(e=t.slice(Re.URL_SCHEME.length),new Re(e)):null;var e};me.registerSaveRouter(De),me.registerLoadRouter(De);class _e{constructor(){l(H().getBool("IS_BROWSER"),()=>"Current environment is not a web browser"),l("undefined"==typeof window||void 0!==window.localStorage,()=>"Current browser does not appear to support localStorage"),this.LS=window.localStorage}async listModels(){const t={},e=Ne+"/",n="/"+Ie;for(let s=0;s<this.LS.length;++s){const r=this.LS.key(s);if(r.startsWith(e)&&r.endsWith(n)){t[Ae(r)]=JSON.parse(this.LS.getItem(r))}}return t}async removeModel(t){var e;const n=$e(t=(e=t).startsWith(Re.URL_SCHEME)?e.slice(Re.URL_SCHEME.length):e);if(null==this.LS.getItem(n.info))throw new Error(`Cannot find model at path '${t}'`);const s=JSON.parse(this.LS.getItem(n.info));return this.LS.removeItem(n.info),this.LS.removeItem(n.topology),this.LS.removeItem(n.weightSpecs),this.LS.removeItem(n.weightData),s}}class Fe{constructor(){this.managers={}}static getInstance(){return null==Fe.instance&&(Fe.instance=new Fe),Fe.instance}static registerManager(t,e){l(null!=t,()=>"scheme must not be undefined or null."),t.endsWith("://")&&(t=t.slice(0,t.indexOf("://"))),l(t.length>0,()=>"scheme must not be an empty string.");const n=Fe.getInstance();l(null==n.managers[t],()=>`A model store manager is already registered for scheme '${t}'.`),n.managers[t]=e}static getManager(t){const e=this.getInstance().managers[t];if(null==e)throw new Error(`Cannot find model manager for scheme '${t}'`);return e}static getSchemes(){return Object.keys(this.getInstance().managers)}}function Oe(t){if(-1===t.indexOf("://"))throw new Error("The url string provided does not contain a scheme. Supported schemes are: "+Fe.getSchemes().join(","));return{scheme:t.split("://")[0],path:t.split("://")[1]}}async function Me(t,e,n=!1){l(t!==e,()=>`Old path and new path are the same: '${t}'`);const s=me.getLoadHandlers(t);l(s.length>0,()=>`Copying failed because no load handler is found for source URL ${t}.`),l(s.length<2,()=>`Copying failed because more than one (${s.length}) load handlers for source URL ${t}.`);const r=s[0],a=me.getSaveHandlers(e);l(a.length>0,()=>`Copying failed because no save handler is found for destination URL ${e}.`),l(a.length<2,()=>`Copying failed because more than one (${s.length}) save handlers for destination URL ${e}.`);const i=a[0],o=Oe(t).scheme,u=Oe(t).path,c=o===Oe(t).scheme,h=await r.load();n&&c&&await Fe.getManager(o).removeModel(u);const p=await i.save(h);return n&&!c&&await Fe.getManager(o).removeModel(u),p.modelArtifactsInfo}class Le{fetch(t,e){return fetch(t,e)}now(){return performance.now()}encode(t,e){if("utf-8"!==e&&"utf8"!==e)throw new Error("Browser's encoder only supports utf-8, but got "+e);return null==this.textEncoder&&(this.textEncoder=new TextEncoder),this.textEncoder.encode(t)}decode(t,e){return new TextDecoder(e).decode(t)}}if(H().get("IS_BROWSER")){H().setPlatform("browser",new Le);try{Fe.registerManager(Re.URL_SCHEME,new _e)}catch(t){}try{Fe.registerManager(we.URL_SCHEME,new ke)}catch(t){}}const ze=()=>require("node-fetch");let Be;class Pe{constructor(){this.util=require("util"),this.textEncoder=new this.util.TextEncoder}fetch(t,e){return null!=H().global.fetch?H().global.fetch(t,e):(null==Be&&(Be=ze()),Be(t,e))}now(){const t=process.hrtime();return 1e3*t[0]+t[1]/1e6}encode(t,e){if("utf-8"!==e&&"utf8"!==e)throw new Error("Node built-in encoder only supports utf-8, but got "+e);return this.textEncoder.encode(t)}decode(t,e){return 0===t.length?"":new this.util.TextDecoder(e).decode(t)}}function We(t,e="float32",n){return e=e||"float32",P(t),new Nt(t,e,n)}H().get("IS_NODE")&&H().setPlatform("node",new Pe);const Ve=ee({cast_:function(t,e){const n=Qt(t,"x","cast");if(!I(e))throw new Error("Failed to cast to unknown dtype "+e);if("string"===e&&"string"!==n.dtype||"string"!==e&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const s={x:n},r={dtype:e};return Ht.runKernelFunc(t=>t.cast(n,e),s,null,"Cast",r)}});const Ue=ee({clone_:function(t){const e=Qt(t,"x","clone",null),n={x:e};return Ht.runKernelFunc(()=>Ht.makeTensorFromDataId(e.dataId,e.shape,e.dtype),n,null,"Identity")}});function Ge(t,e=!1){console.log(t.toString(e))}Gt(),Ct={buffer:We,cast:Ve,clone:Ue,print:Ge};function He(t){return new Promise(t=>setTimeout(t)).then(t)}class je{constructor(t){if(!H().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");t.startsWith(je.URL_SCHEME)&&(t=t.slice(je.URL_SCHEME.length)),null!=t&&0!==t.length||(t="model"),this.modelTopologyFileName=t+".json",this.weightDataFileName=t+".weights.bin"}async save(t){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const e=window.URL.createObjectURL(new Blob([t.weightData],{type:"application/octet-stream"}));if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=[{paths:["./"+this.weightDataFileName],weights:t.weightSpecs}],s={modelTopology:t.modelTopology,format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy,weightsManifest:n},r=window.URL.createObjectURL(new Blob([JSON.stringify(s)],{type:"application/json"})),a=null==this.jsonAnchor?document.createElement("a"):this.jsonAnchor;if(a.download=this.modelTopologyFileName,a.href=r,await He(()=>a.dispatchEvent(new MouseEvent("click"))),null!=t.weightData){const t=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;t.download=this.weightDataFileName,t.href=e,await He(()=>t.dispatchEvent(new MouseEvent("click")))}return{modelArtifactsInfo:de(t)}}}}je.URL_SCHEME="downloads://";class qe{constructor(t){if(null==t||t.length<1)throw new Error("When calling browserFiles, at least 1 file is required, but received "+t);this.files=t}async load(){const t=this.files[0],e=this.files.slice(1);return new Promise((n,s)=>{const r=new FileReader;r.onload=r=>{const a=JSON.parse(r.target.result),i=a.modelTopology;if(null==i)return void s(new Error("modelTopology field is missing from file "+t.name));0===e.length&&n({modelTopology:i});const o=a.weightsManifest;if(null==o)return void s(new Error("weightManifest field is missing from file "+t.name));let l;try{l=this.checkManifestAndWeightFiles(o,e)}catch(t){return void s(t)}const u=[],c=[],h=[];o.forEach(t=>{t.paths.forEach(t=>{c.push(t),h.push(null)}),u.push(...t.weights)}),o.forEach(t=>{t.paths.forEach(t=>{const e=new FileReader;e.onload=e=>{const s=e.target.result,r=c.indexOf(t);h[r]=s,-1===h.indexOf(null)&&n({modelTopology:i,weightSpecs:u,weightData:he(h),format:a.format,generatedBy:a.generatedBy,convertedBy:a.convertedBy,userDefinedMetadata:a.userDefinedMetadata})},e.onerror=e=>s(`Failed to weights data from file of path '${t}'.`),e.readAsArrayBuffer(l[t])})})},r.onerror=e=>s(`Failed to read model topology and weights manifest JSON from file '${t.name}'. BrowserFiles supports loading Keras-style tf.Model artifacts only.`),r.readAsText(t)})}checkManifestAndWeightFiles(t,e){const n=[],s=e.map(t=>pe(t.name)),r={};for(const a of t)a.paths.forEach(t=>{const a=pe(t);if(-1!==n.indexOf(a))throw new Error(`Duplicate file basename found in weights manifest: '${a}'`);if(n.push(a),-1===s.indexOf(a))throw new Error(`Weight file with basename '${a}' is not provided.`);r[t]=e[s.indexOf(a)]});if(n.length!==e.length)throw new Error(`Mismatch in the number of files in weights manifest (${n.length}) and the number of weight files provided (${e.length}).`);return r}}function Ke(t,e,n,s){!function(t){l(null!=t&&Array.isArray(t)&&t.length>0,()=>"promises must be a none empty array")}(t),function(t,e){l(t>=0&&t<=1,()=>"Progress fraction must be in range [0, 1], but got startFraction "+t),l(e>=0&&e<=1,()=>"Progress fraction must be in range [0, 1], but got endFraction "+e),l(e>=t,()=>`startFraction must be no more than endFraction, but got startFraction ${t} and endFraction `+e)}(n=null==n?0:n,s=null==s?1:s);let r=0;return Promise.all(t.map(a=>(a.then(a=>{const i=n+ ++r/t.length*(s-n);return e(i),a}),a)))}async function Xe(t,e){null==e&&(e={});const n=null==e.fetchFunc?H().platform.fetch:e.fetchFunc,s=t.map(t=>n(t,e.requestInit,{isBinary:!0})),r=(null==e.onProgress?await Promise.all(s):await Ke(s,e.onProgress,0,.5)).map(t=>t.arrayBuffer());return null==e.onProgress?await Promise.all(r):await Ke(r,e.onProgress,.5,1)}async function Ye(t,e="",n,s){return Je(t=>Xe(t,{requestInit:s}))(t,e,n)}function Je(t){return async(e,n="",s)=>{const r=e.map(()=>!1),a={},i=null!=s?s.map(()=>!1):[],o=[];if(e.forEach((t,e)=>{let n=0;t.weights.forEach(t=>{const l="quantization"in t?t.quantization.dtype:t.dtype,u=ae[l]*p(t.shape),c=()=>{r[e]=!0,null==a[e]&&(a[e]=[]),a[e].push({manifestEntry:t,groupOffset:n,sizeBytes:u})};null!=s?s.forEach((e,n)=>{e===t.name&&(c(),i[n]=!0)}):c(),o.push(t.name),n+=u})}),!i.every(t=>t)){const t=s.filter((t,e)=>!i[e]);throw new Error("Could not find weights in manifest with names: "+t.join(", ")+". \nManifest JSON has weights with names: "+o.join(", ")+".")}const l=r.reduce((t,e,n)=>(e&&t.push(n),t),[]),u=[];l.forEach(t=>{e[t].paths.forEach(t=>{const e=n+(n.endsWith("/")?"":"/")+t;u.push(e)})});const c=await t(u),h={};let d=0;return l.forEach(t=>{const n=e[t].paths.length;let s=0;for(let t=0;t<n;t++)s+=c[d+t].byteLength;const r=new ArrayBuffer(s),i=new Uint8Array(r);let o=0;for(let t=0;t<n;t++){const e=new Uint8Array(c[d+t]);i.set(e,o),o+=e.byteLength}a[t].forEach(t=>{const e=oe(r.slice(t.groupOffset,t.groupOffset+t.sizeBytes),[t.manifestEntry]);for(const t in e)h[t]=e[t]}),d+=n}),h}}me.registerSaveRouter(t=>H().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(je.URL_SCHEME)?function(t="model"){return new je(t)}(t.slice(je.URL_SCHEME.length)):null);class Ze{constructor(t,e){if(this.DEFAULT_METHOD="POST",null==e&&(e={}),this.weightPathPrefix=e.weightPathPrefix,this.onProgress=e.onProgress,this.weightUrlConverter=e.weightUrlConverter,null!=e.fetchFunc?(l("function"==typeof e.fetchFunc,()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)"),this.fetch=e.fetchFunc):this.fetch=H().platform.fetch,l(null!=t&&t.length>0,()=>"URL path for http must not be null, undefined or empty."),Array.isArray(t)&&l(2===t.length,()=>`URL paths for http must have a length of 2, (actual length is ${t.length}).`),this.path=t,null!=e.requestInit&&null!=e.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=e.requestInit||{}}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const e=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);e.body=new FormData;const n=[{paths:["./model.weights.bin"],weights:t.weightSpecs}],s={modelTopology:t.modelTopology,format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy,userDefinedMetadata:t.userDefinedMetadata,weightsManifest:n};e.body.append("model.json",new Blob([JSON.stringify(s)],{type:"application/json"}),"model.json"),null!=t.weightData&&e.body.append("model.weights.bin",new Blob([t.weightData],{type:"application/octet-stream"}),"model.weights.bin");const r=await this.fetch(this.path,e);if(r.ok)return{modelArtifactsInfo:de(t),responses:[r]};throw new Error("BrowserHTTPRequest.save() failed due to HTTP response status "+r.status+".")}async load(){const t=await this.fetch(this.path,this.requestInit);if(!t.ok)throw new Error(`Request to ${this.path} failed with status code `+t.status+". Please verify this URL points to the model JSON of the model to load.");let e;try{e=await t.json()}catch(t){let e=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?e+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":e+=" Please make sure the server is serving valid JSON for this request.",new Error(e)}const n=e.modelTopology,s=e.weightsManifest,r=e.generatedBy,a=e.convertedBy,i=e.format,o=e.userDefinedMetadata;if(null==n&&null==s)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);let l,u;if(null!=s){const t=await this.loadWeights(s);[l,u]=t}const c={modelTopology:n,weightSpecs:l,weightData:u,userDefinedMetadata:o,generatedBy:r,convertedBy:a,format:i},h=e.modelInitializer;return h&&(c.modelInitializer=h),c}async loadWeights(t){const e=Array.isArray(this.path)?this.path[1]:this.path,[n,s]=function(t){const e=t.lastIndexOf("/"),n=t.lastIndexOf("?"),s=t.substring(0,e),r=n>e?t.substring(n):"";return[s+"/",r]}(e),r=this.weightPathPrefix||n,a=[];for(const e of t)a.push(...e.weights);const i=[],o=[];for(const e of t)for(const t of e.paths)null!=this.weightUrlConverter?o.push(this.weightUrlConverter(t)):i.push(r+t+s);return this.weightUrlConverter&&i.push(...await Promise.all(o)),[a,he(await Xe(i,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress}))]}}function Qe(t){return null!=t.match(Ze.URL_SCHEME_REGEX)}Ze.URL_SCHEME_REGEX=/^https?:\/\//;const tn=(t,e)=>{if("undefined"==typeof fetch&&(null==e||null==e.fetchFunc))return null;{let n=!0;if(n=Array.isArray(t)?t.every(t=>Qe(t)):Qe(t),n)return en(t,e)}return null};function en(t,e){return new Ze(t,e)}function nn(t,e){return en(t,e)}me.registerSaveRouter(tn),me.registerLoadRouter(tn);class sn{constructor(t){this.modelArtifacts=t}async load(){return this.modelArtifacts}}class rn{constructor(t){this.saveHandler=t}async save(t){return this.saveHandler(t)}}var an=Object.freeze({__proto__:null,browserFiles:function(t){return new qe(t)},browserHTTPRequest:nn,concatenateArrayBuffers:he,decodeWeights:oe,encodeWeights:ie,fromMemory:function(t,e,n,s){if(1===arguments.length){return null!=t.modelTopology||null!=t.weightSpecs?new sn(t):(console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new sn({modelTopology:t}))}return console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new sn({modelTopology:t,weightSpecs:e,weightData:n,trainingConfig:s})},getLoadHandlers:ye,getModelArtifactsInfoForJSON:de,getSaveHandlers:ge,http:en,isHTTPScheme:Qe,loadWeights:Ye,registerLoadRouter:t=>me.registerLoadRouter(t),registerSaveRouter:t=>me.registerSaveRouter(t),weightsLoaderFactory:Je,withSaveHandler:function(t){return new rn(t)},copyModel:async function(t,e){return Me(t,e,!1)},listModels:async function(){const t=Fe.getSchemes(),e={};for(const n of t){const t=await Fe.getManager(n).listModels();for(const s in t){e[n+"://"+s]=t[s]}}return e},moveModel:async function(t,e){return Me(t,e,!0)},removeModel:async function(t){const e=Oe(t);return Fe.getManager(e.scheme).removeModel(e.path)}});const on=ee({reshape_:function(t,e){const n=Qt(t,"x","reshape",null),s={x:n},r={shape:e};return Ht.runKernelFunc((t,s)=>(e=b(e,n.size),l(n.size===p(e),()=>"new shape and old shape must have the same number of elements."),s([n]),t.reshape(n,e)),s,null,"Reshape",r)}});const ln=ee({matMul_:function(t,e,n=!1,s=!1){let r=Qt(t,"a","matMul"),a=Qt(e,"b","matMul");[r,a]=Lt(r,a);const i={a:r,b:a},o={transposeA:n,transposeB:s};return Ht.runKernelFunc((t,e)=>{e([r,a]);const i=n?r.shape[r.rank-2]:r.shape[r.rank-1],o=s?a.shape[a.rank-1]:a.shape[a.rank-2],u=n?r.shape[r.rank-1]:r.shape[r.rank-2],c=s?a.shape[a.rank-2]:a.shape[a.rank-1],h=r.shape.slice(0,-2),d=a.shape.slice(0,-2),f=p(h),m=p(d),g=f===m||1===f||1===m;l(r.rank>=2&&a.rank>=2&&g,()=>`Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of (${h}) and (${d}).`),l(i===o,()=>`Error in matMul: inner shapes (${i}) and (${o}) of Tensors with shapes ${r.shape} and ${a.shape} and transposeA=${n} and transposeB=${s} must match.`);const y=(f>m?h:d).concat([u,c]),b=on(r,n?[f,i,u]:[f,u,i]),x=on(a,s?[m,c,o]:[m,o,c]),w=t.batchMatMul(b,x,n,s);return on(w,y)},i,null,"BatchMatMul",o)}});const un=ee({oneHot_:function(t,e,n=1,s=0){if(e<2)throw new Error("Error in oneHot: depth must be >=2, but it is "+e);const r=Qt(t,"indices","oneHot","int32"),a=[...r.shape,e],i={indices:r},o={depth:e,onValue:n,offValue:s};return Ht.runKernelFunc((t,i)=>(i([r]),on(t.oneHot(on(r,[r.size]),e,n,s),a)),i,null,"OneHot",o)}});const cn=ee({transpose_:function(t,e){const n=Qt(t,"x","transpose");if(null==e&&(e=n.shape.map((t,e)=>e).reverse()),l(n.rank===e.length,()=>`Error in transpose: rank of input ${n.rank} must match length of perm ${e}.`),e.forEach(t=>{l(t>=0&&t<n.rank,()=>"All entries in 'perm' must be between 0 and "+(n.rank-1)+" but got "+e)}),n.rank<=1)return n.clone();const s={x:n},r={perm:e};return Ht.runKernelFunc(t=>t.transpose(n,e),s,null,"Transpose",r)}});const hn=ee({confusionMatrix_:function(t,e,n){const s=Qt(t,"labels","confusionMatrix"),r=Qt(e,"predictions","confusionMatrix");l(null==n||n>0&&Number.isInteger(n),()=>"If provided, numClasses must be a positive integer, but got "+n),l(1===s.rank,()=>"Expected the rank of labels to be 1, but got "+s.rank),l(1===r.rank,()=>"Expected the rank of predictions to be 1, but got "+r.rank),l(s.shape[0]===r.shape[0],()=>`Mismatch in the number of examples: ${s.shape[0]} vs. ${r.shape[0]}. Labels and predictions should have the same number of elements.`),l(n>0&&Number.isInteger(n),()=>"numClasses is required to be a positive integer, but got "+n);const a=un(Ve(s,"int32"),n),i=un(Ve(r,"int32"),n),o=cn(a),u=ln(o,i);return Ve(u,"int32")}});var pn=Object.freeze({__proto__:null,confusionMatrix:hn});function dn(t,e,n){if(c(t),null!=e&&3!==e.length)throw new Error("tensor3d() requires shape to have three numbers");const s=Jt(t,n);if(3!==s.length&&1!==s.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return se(t,e,s,n)}let fn;const mn=ee({fromPixels_:function(t,e=3){if(e>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==t)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,s=!1,r=!1,a=!1,i=!1;if(t.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&t instanceof ImageData)s=!0;else if("undefined"!=typeof HTMLVideoElement&&t instanceof HTMLVideoElement)r=!0;else if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement)a=!0;else{if(null==t.getContext)throw new Error("pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was "+t.constructor.name);i=!0}if(r){const e=2;if(r&&t.readyState<e)throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.")}if(null!=st("FromPixels",Ht.backendName)){const n={pixels:t},s={numChannels:e};return Ht.runKernel("FromPixels",n,s)}const[o,l]=r?[t.videoWidth,t.videoHeight]:[t.width,t.height];let u,c;if(i?u=t.getContext("2d").getImageData(0,0,o,l).data:s||n?u=t.data:(a||r)&&(null==fn&&(fn=document.createElement("canvas").getContext("2d")),fn.canvas.width=o,fn.canvas.height=l,fn.drawImage(t,0,0,o,l),u=fn.getImageData(0,0,o,l).data),4===e)c=new Int32Array(u);else{const t=o*l;c=new Int32Array(t*e);for(let n=0;n<t;n++)for(let t=0;t<e;++t)c[n*e+t]=u[4*n+t]}return dn(c,[l,o,e],"int32")}});var gn=Object.freeze({__proto__:null,toPixels:async function(t,e){let n=Qt(t,"img","toPixels");if(!(t instanceof Tt)){const t=n;n=Ve(t,"int32"),t.dispose()}if(2!==n.rank&&3!==n.rank)throw new Error(`toPixels only supports rank 2 or 3 tensors, got rank ${n.rank}.`);const[s,r]=n.shape.slice(0,2),a=2===n.rank?1:n.shape[2];if(a>4||2===a)throw new Error("toPixels only supports depth of size 1, 3 or 4 but got "+a);if("float32"!==n.dtype&&"int32"!==n.dtype)throw new Error(`Unsupported type for toPixels: ${n.dtype}. Please use float32 or int32 tensors.`);const i=await n.data(),o="float32"===n.dtype?255:1,l=new Uint8ClampedArray(r*s*4);for(let t=0;t<s*r;++t){const e=[0,0,0,255];for(let s=0;s<a;s++){const r=i[t*a+s];if("float32"===n.dtype){if(r<0||r>1)throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${r}.`)}else if("int32"===n.dtype&&(r<0||r>255))throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${r}.`);1===a?(e[0]=r*o,e[1]=r*o,e[2]=r*o):e[s]=r*o}const s=4*t;l[s+0]=Math.round(e[0]),l[s+1]=Math.round(e[1]),l[s+2]=Math.round(e[2]),l[s+3]=Math.round(e[3])}if(null!=e){e.width=r,e.height=s;const t=e.getContext("2d"),n=new ImageData(l,r,s);t.putImageData(n,0,0)}return n!==t&&n.dispose(),l},fromPixels:mn});function yn(t,e){if(t.rank<1)throw new Error(`tf.gatherND() expects the input to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.gatherND() expects the indices to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==e.dtype)throw new Error(`tf.gatherND() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.shape[e.rank-1]>t.rank)throw new Error(`index innermost dimension length must be <= tensor rank; saw: ${e.shape[e.rank-1]} vs. ${t.rank}`);if(0===t.size)throw new Error(`Requested more than 0 entries, but input is empty. Input shape: ${t.shape}.`);const n=e.shape,s=n[n.length-1];let r=1;for(let t=0;t<n.length-1;++t)r*=n[t];const a=t.shape,i=n.slice();i.pop();let o=1;for(let e=s;e<t.rank;++e)o*=a[e],i.push(a[e]);const l=[...O(t.shape).map(t=>t/o),1].slice(0,s);return[i,r,o,l]}var bn=Object.freeze({__proto__:null,prepareAndValidate:yn});function xn(t,e,n){const s=e.rank>1?e.shape[e.rank-1]:1,r=e.rank>1?e.rank-1:1,a="Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: "+n.shape+`, indices.shape: ${e.shape}, shape: ${t}`+`, sliceDim: ${s}, and batchDim: ${r}.`;if(n.rank<r)throw new Error(a+` update.rank < ${r}. `);if(t.length<s+(n.rank-r))throw new Error(a+" Output shape length < "+(s+(n.rank-r)));if(n.rank!==r+t.length-s)throw new Error(a+" update.rank != "+(r+t.length-s));for(let t=0;t<r;++t)if(n.shape[t]!==e.shape[t])throw new Error(a+` updates.shape[${t}] (${n.shape[t]}) != indices.shape[${t}] (${e.shape[t]}).`);for(let e=0;e<n.rank-r;++e)if(n.shape[e+r]!==t[e+s])throw new Error(a+` updates.shape[${e+r}] (${n.shape[e+r]}) != shape[${e+r}] (${t[e+r]})`)}function wn(t,e,n){if(e.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${e.rank}.`);if(t.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${t.rank}.`);if("int32"!==e.dtype)throw new Error("The dtype of 'indices' should be int32, but got dtype: "+e.dtype);if(n.length<1)throw new Error("Output rank must be greater or equal to 1, but got shape: "+n);if(0===n.length){if(0===e.size)throw new Error("Indices specified for empty output. indices shape: "+e.shape);if(0===t.size)throw new Error("Updates specified for empty output. updates shape: "+t.shape)}xn(n,e,t)}function vn(t,e,n){const s=e.shape.length,r=s>1?e.shape[s-1]:1,a=n.length;let i=1;for(let t=r;t<a;++t)i*=n[t];const o=r<1?1:r;return{sliceRank:r,numUpdates:p(e.shape)/o,sliceSize:i,strides:[...O(n.slice(0,r)),1],outputSize:p(n)}}var kn=Object.freeze({__proto__:null,validateUpdateShape:xn,validateInput:wn,calculateShapes:vn});function Nn(t,e,n){const s=t.shape.length;l(s===e.length,()=>`Error in slice${s}D: Length of begin ${e} must match the rank of the array (${s}).`),l(s===n.length,()=>`Error in slice${s}D: Length of size ${n} must match the rank of the array (${s}).`);for(let r=0;r<s;++r)l(e[r]+n[r]<=t.shape[r],()=>`Error in slice${s}D: begin[${r}] + size[${r}] (${e[r]+n[r]}) would overflow input.shape[${r}] (${t.shape[r]})`)}function In(t){const e=[];let n=0;for(;t>0;)1&t&&e.push(n),t/=2,n++;return e}function Cn(t,e,n){const s=[];for(let r=0;r<t.length;r++)s[r]=Math.ceil((e[r]-t[r])/n[r]);return s}function Sn(t,e,n,s){const r=[...t];for(let t=r.length;t<s.length;t++)r.push(1);for(let t=0;t<n;t++)0===t?r[e]=1:(r.splice(e,0,1),r.pop());return r}function Tn(t,e,n){return n<=t?n:n-(e-1)}function En(t,e){const n=[];for(let s=0;s<t;s++)n.push(e+s);return n}function $n(t,e,n,s,r,a,i,o,l){const u=t.length;let c=new Array(u),h=new Array(u),p=new Array(u);if(e.length&&n>0){const l=e[0],u=n+1;c=An(i,l,u,s,t),h=Rn(o,l,u,r,t),p=Sn(a,l,u,t)}else for(let e=0;e<u;e++)c[e]=_n(i,s,a,t,e,l),h[e]=Fn(o,r,a,t,e,l),p[e]=Dn(a,e,l);return{begin:c,end:h,strides:p}}function An(t,e,n,s,r){const a=[...r],i=En(n,e);for(let r=0;r<a.length;r++)if(i.indexOf(r)>-1)a[r]=0;else{const i=Tn(e,n,r);let o=s[i];t&1<<i&&(o=0),a[r]=o}return a}function Rn(t,e,n,s,r){const i=[...r],o=En(n,e);for(let r=0;r<i.length;r++)if(o.indexOf(r)>-1)i[r]=Number.MAX_SAFE_INTEGER;else{const a=Tn(e,n,r);let o=s[a];t&1<<a&&(o=Number.MAX_SAFE_INTEGER),i[r]=o}for(let t=0;t<i.length;t++){const e=r[t];i[t]<0&&(i[t]+=e),i[t]=a(0,i[t],r[t])}return i}function Dn(t,e,n){let s=t[e];return(n&1<<e||null==s)&&(s=1),s}function _n(t,e,n,s,r,i){let o=e[r];const l=n[r]||1;(t&1<<r||i&1<<r||null==o)&&(o=l>0?Number.MIN_SAFE_INTEGER:Number.MAX_SAFE_INTEGER);const u=s[r];return o<0&&(o+=u),o=a(0,o,u-1),o}function Fn(t,e,n,s,r,i){let o=e[r];const l=n[r]||1;(t&1<<r||i&1<<r||null==o)&&(o=l>0?Number.MAX_SAFE_INTEGER:Number.MIN_SAFE_INTEGER);const u=s[r];return o<0&&(o+=u),o=l>0?a(0,o,u):a(-1,o,u-1),o}function On(t,e,n){let s=n.length;for(let t=0;t<n.length;t++)if(n[t]>1){s=t;break}for(let r=s+1;r<n.length;r++)if(e[r]>0||n[r]!==t[r])return!1;return!0}function Mn(t,e){let n=t.length>0?t[t.length-1]:1;for(let s=0;s<t.length-1;s++)n+=t[s]*e[s];return n}function Ln(t,e,n){let s;const r=t.shape.length;let a;return s="number"==typeof e?[e,...new Array(r-1).fill(0)]:e.length<r?e.concat(new Array(r-e.length).fill(0)):e.slice(),s.forEach(t=>{l(-1!==t,()=>"slice() does not support negative begin indexing.")}),a=null==n?new Array(r).fill(-1):"number"==typeof n?[n,...new Array(r-1).fill(-1)]:n.length<r?n.concat(new Array(r-n.length).fill(-1)):n,a=a.map((e,n)=>e>=0?e:(l(-1===e,()=>`Negative size values should be exactly -1 but got ${e} for the slice() size at index ${n}.`),t.shape[n]-s[n])),[s,a]}var zn=Object.freeze({__proto__:null,assertParamsValid:Nn,maskToAxes:In,computeOutShape:Cn,stridesWithElidedDims:Sn,getNormalizedAxes:$n,startIndicesWithElidedDims:An,stopIndicesWithElidedDims:Rn,stridesForAxis:Dn,startForAxis:_n,stopForAxis:Fn,isSliceContinous:On,computeFlatOffset:Mn,parseSliceParams:Ln});class Bn{getClassName(){return this.constructor.className}static fromConfig(t,e){return new t(e)}}class Pn{constructor(){this.classNameMap={}}static getMap(){return null==Pn.instance&&(Pn.instance=new Pn),Pn.instance}static register(t){Pn.getMap().classNameMap[t.className]=[t,t.fromConfig]}}function Wn(t){l(null!=t.className,()=>"Class being registered does not have the static className property defined."),l("string"==typeof t.className,()=>"className is required to be a string, but got type "+typeof t.className),l(t.className.length>0,()=>"Class being registered has an empty-string as its className, which is disallowed."),Pn.register(t)}var Vn=Object.freeze({__proto__:null,Serializable:Bn,SerializationMap:Pn,registerClass:Wn});function Un(){return 32===Ht.backend.floatPrecision()?.001:.1}function Gn(t,e,n){let s=!0;if((S(t)||S(e))&&(s=!1),S(t)&&S(e)&&(s=!0),s){const n=t.constructor.name,s=e.constructor.name;if(n!==s)throw new Error(`Arrays are of different type. Actual: ${n}. Expected: `+s)}if(Array.isArray(t)&&Array.isArray(e)){const n=Jt(t),s=Jt(e);if(!d(n,s))throw new Error(`Arrays have different shapes. Actual: [${n}]. Expected: [${s}]`)}const r=S(t)?t:h(t),a=S(e)?e:h(e);if(r.length!==a.length)throw new Error(`Arrays have different lengths actual: ${r.length} vs expected: ${a.length}.\nActual:   ${r}.\nExpected: ${a}.`);for(let t=0;t<a.length;++t){const e=r[t],s=a[t];if(!n(e,s))throw new Error(`Arrays differ: actual[${t}] = ${e}, expected[${t}] = ${s}.\nActual:   ${r}.\nExpected: ${a}.`)}}function Hn(t,e,n){if(null==n&&(n=Un()),!jn(t,e,n))throw new Error(`Numbers differ: actual === ${t}, expected === ${e}`)}function jn(t,e,n){return!isFinite(t)&&!isFinite(e)||!(isNaN(t)||isNaN(e)||Math.abs(t-e)>n)}var qn=Object.freeze({__proto__:null,TEST_EPSILON_FLOAT16:.1,expectArraysClose:function(t,e,n){return null==n&&(n=Un()),Gn(t,e,(t,e)=>jn(t,e,n))},testEpsilon:Un,expectPromiseToFail:function(t,e){t().then(()=>e.fail(),()=>e())},expectArraysEqual:function(t,e){const n="string"==typeof e||"number"==typeof e||"boolean"==typeof e?[e]:e;return $(t)||$(t[0])||$(e)||$(e[0])?Gn(t,n,(t,e)=>t==e):Gn(t,e,(t,e)=>jn(t,e,0))},expectNumbersClose:Hn,expectValuesInRange:function(t,e,n){for(let s=0;s<t.length;s++)if(t[s]<e||t[s]>n)throw new Error(`Value out of range:${t[s]} low: ${e}, high: ${n}`)},expectArrayBuffersEqual:function(t,e){expect(new Float32Array(t)).toEqual(new Float32Array(e))}});function Kn(t){H().getBool("DEPRECATION_WARNINGS_ENABLED")&&console.warn(t+" You can disable deprecation warnings with tf.disableDeprecationWarnings().")}function Xn(){return Ht}function Yn(){return Ht.memory()}function Jn(t,e){return Ht.tidy(t,e)}function Zn(t){Pt(t).forEach(t=>t.dispose())}function Qn(t){return Ht.keep(t)}function ts(t){return Ht.setBackend(t)}function es(t,e,n=1){return Ht.registerBackend(t,e,n)}function ns(){return Ht.backend}St=Kn;const ss=ee({add_:function(t,e){let n=Qt(t,"a","add"),s=Qt(e,"b","add");[n,s]=Lt(n,s);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.add(n,s);return e([n,s]),r},r,null,X)}});const rs=ee({floorDiv_:function(t,e){let n=Qt(t,"a","floorDiv"),s=Qt(e,"b","floorDiv");[n,s]=Lt(n,s);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.floorDiv(n,s);return e([n,s]),r},r,null,"FloorDiv")}});const as=ee({div_:function(t,e){let n=Qt(t,"a","div"),s=Qt(e,"b","div");if([n,s]=Lt(n,s),"int32"===n.dtype&&"int32"===s.dtype)return rs(n,s);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.realDivide(n,s);return e([n,s]),r},r,null,J,{})}});const is=ee({mul_:function(t,e){let n=Qt(t,"a","mul"),s=Qt(e,"b","mul");[n,s]=Lt(n,s);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.multiply(n,s);return e([n,s]),r},r,null,"Multiply")}});const os=ee({abs_:function(t){const e=Qt(t,"x","abs"),n={x:e};return Ht.runKernelFunc((t,n)=>(n([e]),"complex64"===e.dtype?t.complexAbs(e):t.abs(e)),n,null,"Abs")}});const ls=ee({acos_:function(t){const e=Qt(t,"x","acos"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.acos(e);return n([e]),s},n,null,"Acos")}});const us=ee({acosh_:function(t){const e=Qt(t,"x","acosh"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.acosh(e);return n([e]),s},n,null,"Acosh")}});const cs=ee({addN_:function(t){l(Array.isArray(t),()=>"The argument passed to tf.addN() must be a list of tensors"),l(t.length>=1,()=>"Must pass at least one tensor to tf.addN(), but got "+t.length);const e=t.map((t,e)=>Qt(t,"tensors"+e,"addN")),n=e[0];e.forEach(t=>{if(t.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")}),e.forEach(t=>{if(!d(t.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")});const s=e;return Ht.runKernelFunc((t,n)=>{const s=t.addN(e);return n(e),s},s,null,"AddN")}});function hs(t,e){for(let n=0;n<t.length;++n)if(t[t.length-n-1]!==e-1-n)return!1;return!0}function ps(t,e,n){const s=t.length+e.length,r=[];let a=0,i=0;for(let o=0;o<s;o++)-1===n.indexOf(o)?r.push(t[a++]):r.push(e[i++]);return r}function ds(t,e){const n=[],s=t.length;for(let r=0;r<s;r++)-1===e.indexOf(r)&&n.push(t[r]);return[n,e.map(e=>t[e])]}function fs(t,e){return ps(t,e.map(t=>1),e)}function ms(t,e,n){l(hs(e,n),()=>t+" supports only inner-most axes for now. "+`Got axes ${e} and rank-${n} input.`)}function gs(t,e){if(hs(t,e))return null;const n=[];for(let s=0;s<e;++s)-1===t.indexOf(s)&&n.push(s);return t.forEach(t=>n.push(t)),n}function ys(t){return t.map((t,e)=>[e,t]).sort((t,e)=>t[1]-e[1]).map(t=>t[0])}function bs(t,e){const n=[];for(let s=e-t;s<e;++s)n.push(s);return n}const xs=ee({all_:function(t,e=null,n=!1){let s=Qt(t,"x","all","bool");const r={x:s},a={axis:e,keepDims:n};return Ht.runKernelFunc(t=>{const r=x(e,s.shape);let a=r;const i=gs(a,s.rank);null!=i&&(s=cn(s,i),a=bs(a.length,s.rank));const o=t.all(s,a);if(n){const t=fs(o.shape,r);return on(o,t)}return o},r,null,"All",a)}});const ws=ee({any_:function(t,e=null,n=!1){let s=Qt(t,"x","any","bool");const r={x:s},a={axis:e,keepDims:n};return Ht.runKernelFunc(t=>{const r=x(e,s.shape);let a=r;const i=gs(a,s.rank);null!=i&&(s=cn(s,i),a=bs(a.length,s.rank));const o=t.any(s,a);if(n){const t=fs(o.shape,r);return on(o,t)}return o},r,null,"Any",a)}});const vs=ee({argMax_:function(t,e=0){let n=Qt(t,"x","argMax");const s={x:n},r={axis:e};return Ht.runKernelFunc((t,s)=>{s([n]);let r=x(e,n.shape);const a=gs(r,n.rank);return null!=a&&(n=cn(n,a),r=bs(r.length,n.rank)),t.argMax(n,r[0])},s,null,"ArgMax",r)}});const ks=ee({argMin_:function(t,e=0){let n=Qt(t,"x","argMin");const s={x:n},r={axis:e};return Ht.runKernelFunc((t,s)=>{s([n]),null==e&&(e=0);let r=x(e,n.shape);const a=gs(r,n.rank);return null!=a&&(n=cn(n,a),r=bs(r.length,n.rank)),t.argMin(n,r[0])},s,null,"ArgMin",r)}});const Ns=ee({asin_:function(t){const e=Qt(t,"x","asin"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.asin(e);return n([e]),s},n,null,"Asin")}});const Is=ee({asinh_:function(t){const e=Qt(t,"x","asinh"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.asinh(e);return n([e]),s},n,null,"Asinh")}});const Cs=ee({atan_:function(t){const e=Qt(t,"x","atan"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.atan(e);return n([e]),s},n,null,"Atan")}});const Ss=ee({atan2_:function(t,e){let n=Qt(t,"a","atan2"),s=Qt(e,"b","atan2");[n,s]=Lt(n,s);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.atan2(n,s);return e([n,s]),r},r,null,"Atan2")}});const Ts=ee({atanh_:function(t){const e=Qt(t,"x","atanh"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.atanh(e);return n([e]),s},n,null,"Atanh")}});function Es(t,e,n,s,r="NHWC",a){return Rs(t,[...e,t[3]],n,a,s,null,null,Ps(r))}function $s(t,e,n,s,r,a,i="channelsLast"){const[o,l]=Fs(e);let u;if("channelsLast"===i)u=[o,l,t[3],t[3]];else{if("channelsFirst"!==i)throw new Error("Unknown dataFormat "+i);u=[o,l,t[1],t[1]]}return Rs(t,u,n,s,r,a,!1,i)}function As(t,e,n,s,r,a,i="NDHWC"){const[o,l,u]=Os(e);let c,h;if("NDHWC"===i)h="channelsLast",c=[o,l,u,t[4],t[4]];else{if("NCDHW"!==i)throw new Error("Unknown dataFormat "+i);h="channelsFirst",c=[o,l,u,t[1],t[1]]}return Ds(t,c,n,s,r,!1,h,a)}function Rs(t,e,n,s,r,a,i=!1,o="channelsLast"){let[u,c,h,p]=[-1,-1,-1,-1];if("channelsLast"===o)[u,c,h,p]=t;else{if("channelsFirst"!==o)throw new Error("Unknown dataFormat "+o);[u,p,c,h]=t}const[d,m,,g]=e,[y,b]=Fs(n),[x,w]=Fs(s),v=Ms(d,x),k=Ms(m,w),{padInfo:N,outHeight:I,outWidth:C}=function(t,e,n,s,r,a,i,o,u){let c,h,p;if("number"==typeof t){c={top:t,bottom:t,left:t,right:t,type:0===t?"VALID":"NUMBER"};const r=function(t,e,n,s,r){null==s&&(s=_s(t,e,n));const a=t[0],i=t[1],o=Ls((a-e+2*s)/n+1,r);l(f(o),()=>`The output # of rows (${o}) must be an integer. Change the stride and/or zero pad parameters`);const u=Ls((i-e+2*s)/n+1,r);return l(f(u),()=>`The output # of columns (${u}) must be an integer. Change the stride and/or zero pad parameters`),[o,u]}([e,n],a,s,t,o);h=r[0],p=r[1]}else if("same"===t){h=Math.ceil(e/s),p=Math.ceil(n/r);const t=Math.max(0,(h-1)*s+a-e),o=Math.max(0,(p-1)*r+i-n),l=Math.floor(t/2),u=t-l,d=Math.floor(o/2);c={top:l,bottom:u,left:d,right:o-d,type:"SAME"}}else if("valid"===t)c={top:0,bottom:0,left:0,right:0,type:"VALID"},h=Math.ceil((e-a+1)/s),p=Math.ceil((n-i+1)/r);else{if("object"!=typeof t)throw Error("Unknown padding parameter: "+t);{const l="channelsLast"===u?t[1][0]:t[2][0],d="channelsLast"===u?t[1][1]:t[2][1],f="channelsLast"===u?t[2][0]:t[3][0],m="channelsLast"===u?t[2][1]:t[3][1];c={top:l,bottom:d,left:f,right:m,type:0===l&&0===d&&0===f&&0===m?"VALID":"EXPLICIT"},h=Ls((e-a+l+d)/s+1,o),p=Ls((n-i+f+m)/r+1,o)}}return{padInfo:c,outHeight:h,outWidth:p}}(r,c,h,y,b,v,k,a,o),S=i?g*p:g;let T;return"channelsFirst"===o?T=[u,S,I,C]:"channelsLast"===o&&(T=[u,I,C,S]),{batchSize:u,dataFormat:o,inHeight:c,inWidth:h,inChannels:p,outHeight:I,outWidth:C,outChannels:S,padInfo:N,strideHeight:y,strideWidth:b,filterHeight:d,filterWidth:m,effectiveFilterHeight:v,effectiveFilterWidth:k,dilationHeight:x,dilationWidth:w,inShape:t,outShape:T,filterShape:e}}function Ds(t,e,n,s,r,a=!1,i="channelsLast",o){let[u,c,h,p,d]=[-1,-1,-1,-1,-1];if("channelsLast"===i)[u,c,h,p,d]=t;else{if("channelsFirst"!==i)throw new Error("Unknown dataFormat "+i);[u,d,c,h,p]=t}const[m,g,y,,b]=e,[x,w,v]=Os(n),[k,N,I]=Os(s),C=Ms(m,k),S=Ms(g,N),T=Ms(y,I),{padInfo:E,outDepth:$,outHeight:A,outWidth:R}=function(t,e,n,s,r,a,i,o,u,c,h){let p,d,m,g;if("number"==typeof t){p={top:t,bottom:t,left:t,right:t,front:t,back:t,type:0===t?"VALID":"NUMBER"};const a=function(t,e,n,s,r,a){null==r&&(r=_s(t,e,s));const i=t[0],o=t[1],u=t[2],c=Ls((i-e+2*r)/s+1,a);l(f(c),()=>`The output # of depths (${c}) must be an integer. Change the stride and/or zero pad parameters`);const h=Ls((o-e+2*r)/s+1,a);l(f(h),()=>`The output # of rows (${h}) must be an integer. Change the stride and/or zero pad parameters`);const p=Ls((u-e+2*r)/s+1,a);return l(f(p),()=>`The output # of columns (${p}) must be an integer. Change the stride and/or zero pad parameters`),[c,h,p,n]}([e,n,s,1],o,1,r,t,h);d=a[0],m=a[1],g=a[2]}else if("same"===t){d=Math.ceil(e/r),m=Math.ceil(n/a),g=Math.ceil(s/i);const t=(d-1)*r+o-e,l=(m-1)*a+u-n,h=(g-1)*i+c-s,f=Math.floor(t/2),y=t-f,b=Math.floor(l/2),x=l-b,w=Math.floor(h/2);p={top:b,bottom:x,left:w,right:h-w,front:f,back:y,type:"SAME"}}else{if("valid"!==t)throw Error("Unknown padding parameter: "+t);p={top:0,bottom:0,left:0,right:0,front:0,back:0,type:"VALID"},d=Math.ceil((e-o+1)/r),m=Math.ceil((n-u+1)/a),g=Math.ceil((s-c+1)/i)}return{padInfo:p,outDepth:d,outHeight:m,outWidth:g}}(r,c,h,p,x,w,v,C,S,T,o),D=a?b*d:b;let _;return"channelsFirst"===i?_=[u,D,$,A,R]:"channelsLast"===i&&(_=[u,$,A,R,D]),{batchSize:u,dataFormat:i,inDepth:c,inHeight:h,inWidth:p,inChannels:d,outDepth:$,outHeight:A,outWidth:R,outChannels:D,padInfo:E,strideDepth:x,strideHeight:w,strideWidth:v,filterDepth:m,filterHeight:g,filterWidth:y,effectiveFilterDepth:C,effectiveFilterHeight:S,effectiveFilterWidth:T,dilationDepth:k,dilationHeight:N,dilationWidth:I,inShape:t,outShape:_,filterShape:e}}function _s(t,e,n,s=1){const r=Ms(e,s);return Math.floor((t[0]*(n-1)-n+r)/2)}function Fs(t){return"number"==typeof t?[t,t,t]:2===t.length?[t[0],t[1],1]:t}function Os(t){return"number"==typeof t?[t,t,t]:t}function Ms(t,e){return e<=1?t:t+(t-1)*(e-1)}function Ls(t,e){if(!e)return t;switch(e){case"round":return Math.round(t);case"ceil":return Math.ceil(t);case"floor":return Math.floor(t);default:throw new Error("Unknown roundingMode "+e)}}function zs(t){const[e,n,s]=Fs(t);return 1===e&&1===n&&1===s}function Bs(t,e){return zs(t)||zs(e)}function Ps(t){if("NHWC"===t)return"channelsLast";if("NCHW"===t)return"channelsFirst";throw new Error("Unknown dataFormat "+t)}const Ws=ee({avgPool_:function(t,e,n,s,r){const a=Qt(t,"x","avgPool","float32");l(Bs(n,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`);let i=a,o=!1;3===a.rank&&(o=!0,i=on(a,[1,a.shape[0],a.shape[1],a.shape[2]])),l(4===i.rank,()=>`Error in avgPool: x must be rank 4 but got rank ${i.rank}.`),null!=r&&l(f(s),()=>`Error in avgPool: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`);const u={x:i},c={filterSize:e,strides:n,pad:s,dimRoundingMode:r};let h=Ht.runKernelFunc((t,a)=>{const o=$s(i.shape,e,n,1,s,r);return a([i]),1===o.filterWidth&&1===o.filterHeight&&d(o.inShape,o.outShape)?i.clone():t.avgPool(i,o)},u,null,"AvgPool",c);return h=Ve(h,a.dtype),o?on(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Vs=ee({avgPool3d_:function(t,e,n,s,r,a="NDHWC",i){null==i?i=[1,1,1]:Kn("dilations is deprecated, this field will be gone in v3.0.0.");const o=Qt(t,"x","avgPool3d","float32");let u=o,c=!1;4===o.rank&&(c=!0,u=on(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),l(5===u.rank,()=>`Error in avgPool3d: x must be rank 5 but got rank ${u.rank}.`),l("NDHWC"===a,()=>"Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of "+a),l(Bs(n,i),()=>`Error in avgPool3d: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`),null!=r&&l(f(s),()=>`Error in avgPool3d: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`);const h={x:u},p={filterSize:e,strides:n,pad:s,dimRoundingMode:r,dataFormat:a,dilations:i};let d=Ht.runKernelFunc((t,o)=>{null==i&&(i=[1,1,1]);const l=As(u.shape,e,n,i,s,r,a);return o([u]),t.avgPool3d(u,l)},h,null,"AvgPool3D",p);return d=Ve(d,u.dtype),c?on(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});function Us(t,e){const n=t[0].length;t.forEach((t,e)=>{l(t.length===n,()=>`Error in concat${n}D: rank of tensors[${e}] must be the same as the rank of the rest (${n})`)}),l(e>=0&&e<n,()=>`Error in concat${n}D: axis must be between 0 and ${n-1}.`);const s=t[0];t.forEach((t,r)=>{for(let a=0;a<n;a++)l(a===e||t[a]===s[a],()=>`Error in concat${n}D: Shape of tensors[${r}] (${t}) does not match the shape of the rest (${s}) along the non-concatenated axis ${r}.`)})}function Gs(t,e){const n=t[0].slice();for(let s=1;s<t.length;s++)n[e]+=t[s][e];return n}const Hs=ee({concat_:function(t,e=0){l(t.length>=1,()=>"Pass at least one tensor to concat");let n=te(t,"tensors","concat");"complex64"===n[0].dtype&&n.forEach(t=>{if("complex64"!==t.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${t.dtype}. `)});const s=n,r={axis:e};return Ht.runKernelFunc((t,s)=>{const r=x(e,n[0].shape)[0],a=Gs(n.map(t=>t.shape),r);if(0===p(a))return re([],a);if(n=n.filter(t=>t.size>0),1===n.length)return n[0];Us(n.map(t=>t.shape),r);const i=t.concat(n,r);return s(n),i},s,null,"Concat",r)}});const js=ee({sigmoid_:function(t){const e=Qt(t,"x","sigmoid"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.sigmoid(e);return n([s]),s},n,null,"Sigmoid")}});const qs=ee({slice_:function(t,e,n){const s=Qt(t,"x","slice");if(0===s.rank)throw new Error("Slicing scalar is not possible");const r={x:s},a={begin:e,size:n};return Ht.runKernelFunc((t,r)=>{const[a,i]=Ln(s,e,n);return Nn(s,a,i),r([s]),t.slice(s,a,i)},r,null,"Slice",a)}});const Ks=ee({tanh_:function(t){const e=Qt(t,"x","tanh"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.tanh(e);return n([s]),s},n,null,"Tanh")}});const Xs=ee({basicLSTMCell_:function(t,e,n,s,r,a){const i=Qt(t,"forgetBias","basicLSTMCell"),o=Qt(e,"lstmKernel","basicLSTMCell"),l=Qt(n,"lstmBias","basicLSTMCell"),u=Qt(s,"data","basicLSTMCell"),c=Qt(r,"c","basicLSTMCell"),h=Qt(a,"h","basicLSTMCell"),p=Hs([u,h],1),d=ln(p,o),f=ss(d,l),m=f.shape[0],g=f.shape[1]/4,y=[m,g],b=qs(f,[0,0],y),x=qs(f,[0,g],y),w=qs(f,[0,2*g],y),v=qs(f,[0,3*g],y),k=ss(is(js(b),Ks(x)),is(c,js(ss(i,w))));return[k,is(Ks(k),js(v))]}});const Ys=ee({batchToSpaceND_:function(t,e,n){const s=Qt(t,"x","batchToSpaceND"),r=e.reduce((t,e)=>t*e);l(s.rank>=1+e.length,()=>`input rank is ${s.rank} but should be > than blockShape.length ${e.length}`),l(n.length===e.length,()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${e.length}`),l(s.shape[0]%r==0,()=>`input tensor batch is ${s.shape[0]} but is not divisible by the product of the elements of blockShape ${e.join(" * ")} === ${r}`);const a={x:s},i={blockShape:e,crops:n};return Ht.runKernelFunc(t=>t.batchToSpaceND(s,e,n),a,null,"BatchToSpaceND",i)}});function Js(t){return null==t?null:0===t.rank?on(t,[t.size]):1===t.rank?t:2===t.rank?on(t,[1,1,t.shape[0],t.shape[1]]):3===t.rank?on(t,[1,t.shape[0],t.shape[1],t.shape[2]]):t}const Zs=ee({batchNorm_:function(t,e,n,s,r,a){null==a&&(a=.001);const i=Qt(t,"x","batchNorm"),o=Qt(e,"mean","batchNorm"),u=Qt(n,"variance","batchNorm");let c,h;null!=r&&(c=Qt(r,"scale","batchNorm")),null!=s&&(h=Qt(s,"offset","batchNorm")),l(o.rank===u.rank,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),l(null==h||o.rank===h.rank,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),l(null==c||o.rank===c.rank,()=>"Batch normalization gradient requires mean and scale to have equal ranks.");const p=function(t){let e;return e=0===t.rank||1===t.rank?on(t,[1,1,1,t.size]):2===t.rank?on(t,[1,1,t.shape[0],t.shape[1]]):3===t.rank?on(t,[1,t.shape[0],t.shape[1],t.shape[2]]):t,e}(i),d={x:p,scale:c,offset:h,mean:o,variance:u},f={varianceEpsilon:a},m=Ht.runKernelFunc((t,e)=>(e([p,o,u,c]),t.batchNorm(p,Js(o),Js(u),Js(h),Js(c),a)),d,null,"FusedBatchNorm",f);return on(m,i.shape)}});const Qs=ee({batchNorm2d_:function(t,e,n,s,r,a){const i=Qt(t,"x","batchNorm"),o=Qt(e,"mean","batchNorm"),u=Qt(n,"variance","batchNorm");let c,h;return null!=r&&(c=Qt(r,"scale","batchNorm")),null!=s&&(h=Qt(s,"offset","batchNorm")),l(2===i.rank,()=>"Error in batchNorm2D: x must be rank 2 but got rank "+i.rank+"."),l(2===o.rank||1===o.rank,()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${o.rank}.`),l(2===u.rank||1===u.rank,()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${u.rank}.`),null!=c&&l(2===c.rank||1===c.rank,()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${c.rank}.`),null!=h&&l(2===h.rank||1===h.rank,()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`),Zs(i,o,u,h,c,a)}});const tr=ee({batchNorm3d_:function(t,e,n,s,r,a){const i=Qt(t,"x","batchNorm"),o=Qt(e,"mean","batchNorm"),u=Qt(n,"variance","batchNorm");let c,h;return null!=r&&(c=Qt(r,"scale","batchNorm")),null!=s&&(h=Qt(s,"offset","batchNorm")),l(3===i.rank,()=>"Error in batchNorm3D: x must be rank 3 but got rank "+i.rank+"."),l(3===o.rank||1===o.rank,()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${o.rank}.`),l(3===u.rank||1===u.rank,()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${u.rank}.`),null!=c&&l(3===c.rank||1===c.rank,()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${c.rank}.`),null!=h&&l(3===h.rank||1===h.rank,()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`),Zs(i,o,u,h,c,a)}});const er=ee({batchNorm4d_:function(t,e,n,s,r,a){const i=Qt(t,"x","batchNorm"),o=Qt(e,"mean","batchNorm"),u=Qt(n,"variance","batchNorm");let c,h;return null!=r&&(c=Qt(r,"scale","batchNorm")),null!=s&&(h=Qt(s,"offset","batchNorm")),l(4===i.rank,()=>"Error in batchNorm4D: x must be rank 4 but got rank "+i.rank+"."),l(4===o.rank||1===o.rank,()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${o.rank}.`),l(4===u.rank||1===u.rank,()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${u.rank}.`),null!=c&&l(4===c.rank||1===c.rank,()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${c.rank}.`),null!=h&&l(4===h.rank||1===h.rank,()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`),Zs(i,o,u,h,c,a)}});const nr=ee({broadcastTo_:function(t,e){let n=Qt(t,"broadcastTo","x");const s=n.shape;if(e.some(t=>!(t>0)||t%1!=0))throw new Error(`broadcastTo(): Invalid broadcast shape [${e}].`);if(e.length<n.rank)throw new Error(`broadcastTo(): shape.length=${e.length} < input.rank=${n.rank}.`);if(e.length>n.rank){const t=n.shape.slice();for(;t.length<e.length;)t.unshift(1);n=on(n,t)}const r=n.shape,a=Array.from(e);for(let t=e.length-1;t>=0;t--)if(r[t]===e[t])a[t]=1;else if(1!==n.shape[t])throw new Error(`broadcastTo(): [${s}] cannot be broadcast to [${e}].`);if(0===a.map((t,e)=>t>1?e:-1).filter(t=>t>=0).length)return Ue(n);const i={x:n},o={shape:e,inputShape:r};return Ht.runKernelFunc(t=>t.tile(n,a),i,null,"BroadcastTo",o)}});const sr=ee({ceil_:function(t){const e=Qt(t,"x","ceil"),n={x:e};return Ht.runKernelFunc(t=>t.ceil(e),n,null,"Ceil")}});const rr=ee({clipByValue_:function(t,e,n){const s=Qt(t,"x","clipByValue");l(e<=n,()=>`Error in clip: min (${e}) must be less than or equal to max (${n}).`);const r={x:s},a={clipValueMin:e,clipValueMax:n};return Ht.runKernelFunc((t,r)=>{const a=t.clip(s,e,n);return r([s]),a},r,null,"ClipByValue",a)}});const ar=ee({concat1d_:function(t){return Hs(t,0)}});const ir=ee({concat2d_:function(t,e){return Hs(t,e)}});const or=ee({concat3d_:function(t,e){return Hs(t,e)}});const lr=ee({concat4d_:function(t,e){return Hs(t,e)}});const ur=ee({conv2d_:function(t,e,n,s,r="NHWC",a=[1,1],i){const o=Qt(t,"x","conv2d"),u=Qt(e,"filter","conv2d");let c=o,h=!1;3===o.rank&&(h=!0,c=on(o,[1,o.shape[0],o.shape[1],o.shape[2]])),l(4===c.rank,()=>`Error in conv2d: input must be rank 4, but got rank ${c.rank}.`),l(4===u.rank,()=>"Error in conv2d: filter must be rank 4, but got rank "+u.rank+"."),null!=i&&l(f(s),()=>`Error in conv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`);const p="NHWC"===r?c.shape[3]:c.shape[1];l(p===u.shape[2],()=>`Error in conv2d: depth of input (${p}) must match input depth for filter ${u.shape[2]}.`),l(Bs(n,a),()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`);const d={x:c,filter:u},m={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i},g=Ht.runKernelFunc((t,e)=>{const o=Ps(r),l=Rs(c.shape,u.shape,n,a,s,i,!1,o),h=t.conv2d(c,u,l);return e([c,u]),h},d,null,"Conv2D",m);return h?on(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const cr=ee({conv1d_:function(t,e,n,s,r="NWC",a=1,i){const o=Qt(t,"x","conv1d"),u=Qt(e,"filter","conv1d");let c=o,h=!1;2===o.rank&&(h=!0,c=on(o,[1,o.shape[0],o.shape[1]])),l(3===c.rank,()=>`Error in conv1d: input must be rank 3, but got rank ${c.rank}.`),l(3===u.rank,()=>"Error in conv1d: filter must be rank 3, but got rank "+u.rank+"."),null!=i&&l(f(s),()=>`Error in conv1d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`),l(c.shape[2]===u.shape[1],()=>`Error in conv1d: depth of input (${c.shape[2]}) must match input depth for filter ${u.shape[1]}.`),l(Bs(n,a),()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${a}'`),l("NWC"===r,()=>`Error in conv1d: got dataFormat of ${r} but only NWC is currently supported.`);const p=on(u,[1,u.shape[0],u.shape[1],u.shape[2]]),d=on(c,[c.shape[0],1,c.shape[1],c.shape[2]]),m=ur(d,p,[1,n],s,"NHWC",[1,a],i);return on(m,h?[m.shape[2],m.shape[3]]:[m.shape[0],m.shape[2],m.shape[3]])}});const hr=ee({conv2DBackpropInput_:function(t,e,n,s,r,a="NHWC",i){l(t.length===e.rank,()=>`Length of inShape (${t.length}) and rank of dy (${e.rank}) must match`);let o=t,u=e,c=!1;3===e.rank&&(c=!0,u=on(e,[1,e.shape[0],e.shape[1],e.shape[2]]),o=[1,t[0],t[1],t[2]]),l(4===o.length,()=>"Error in conv2dDerInput: inShape must be length 4, but got length "+o.length+"."),l(4===u.rank,()=>"Error in conv2dDerInput: dy must be rank 4, but got rank "+u.rank),l(4===n.rank,()=>"Error in conv2dDerInput: filter must be rank 4, but got rank "+n.rank);const h="NHWC"===a?o[3]:o[1],p="NHWC"===a?u.shape[3]:u.shape[1];l(h===n.shape[2],()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`),l(p===n.shape[3],()=>`Error in conv2dDerInput: depth of output (${p}) must match output depth for filter ${n.shape[3]}.`),null!=i&&l(f(r),()=>`Error in conv2dDerInput: pad must be an integer when using, dimRoundingMode ${i} but got pad ${r}.`);const d={dy:u,filter:n},m={strides:s,pad:r,dataFormat:a,dimRoundingMode:i,inputShape:o},g=Ht.runKernelFunc((t,e)=>{const l=Ps(a),c=Rs(o,n.shape,s,1,r,i,!1,l),h=t.conv2dDerInput(u,n,c);return e([u,n]),h},d,null,"Conv2DBackpropInput",m);return c?on(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const pr=ee({conv2dTranspose_:function(t,e,n,s,r,a){const i=Qt(t,"x","conv2dTranspose"),o=Qt(e,"filter","conv2dTranspose");return hr(n,i,o,s,r,"NHWC",a)}});const dr=ee({conv3d_:function(t,e,n,s,r="NDHWC",a=[1,1,1]){const i=Qt(t,"x","conv3d"),o=Qt(e,"filter","conv3d");let u=i,c=!1;4===i.rank&&(c=!0,u=on(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),l(5===u.rank,()=>`Error in conv3d: input must be rank 5, but got rank ${u.rank}.`),l(5===o.rank,()=>"Error in conv3d: filter must be rank 5, but got rank "+o.rank+"."),l(u.shape[4]===o.shape[3],()=>`Error in conv3d: depth of input (${u.shape[4]}) must match input depth for filter ${o.shape[3]}.`),l(Bs(n,a),()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`),l("NDHWC"===r,()=>`Error in conv3d: got dataFormat of ${r} but only NDHWC is currently supported.`);const h={x:u,filter:o},p={strides:n,pad:s,dataFormat:r,dilations:a},d=Ht.runKernelFunc((t,e)=>{const r=Ds(u.shape,o.shape,n,a,s),i=t.conv3d(u,o,r);return e([u,o]),i},h,null,"Conv3D",p);return c?on(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const fr=ee({conv3DBackpropInput_:function(t,e,n,s,r){l(t.length===e.rank,()=>`Length of inShape (${t.length}) and rank of dy (${e.rank}) must match`);let a=t,i=e,o=!1;4===e.rank&&(o=!0,i=on(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]]),a=[1,t[0],t[1],t[2],t[3]]);const u=a[4],c=i.shape[4];l(5===a.length,()=>"Error in conv3dDerInput: inShape must be length 5, but got length "+a.length+"."),l(5===i.rank,()=>"Error in conv3dDerInput: dy must be rank 5, but got rank "+i.rank),l(5===n.rank,()=>"Error in conv3dDerInput: filter must be rank 5, but got rank "+n.rank),l(u===n.shape[3],()=>`Error in conv3dDerInput: depth of input (${u}) must match input depth for filter ${n.shape[3]}.`),l(c===n.shape[4],()=>`Error in conv3dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[4]}.`);const h={dy:i,filter:n},p={pad:r,strides:s,inputShape:a},d=Ht.runKernelFunc(t=>{const e=Ds(a,n.shape,s,1,r);return t.conv3dDerInput(i,n,e)},h,null,"Conv3DBackpropInputV2",p);return o?on(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const mr=ee({conv3dTranspose_:function(t,e,n,s,r){const a=Qt(t,"x","conv3dTranspose"),i=Qt(e,"filter","conv3dTranspose");return fr(n,a,i,s,r)}});const gr=ee({cos_:function(t){const e=Qt(t,"x","cos"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.cos(e);return n([e]),s},n,null,Y)}});const yr=ee({cosh_:function(t){const e=Qt(t,"x","cosh"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.cosh(e);return n([e]),s},n,null,"Cosh")}});const br=ee({cumsum_:function(t,e=0,n=!1,s=!1){const r=Qt(t,"x","cumsum"),a={x:r},i={axis:e,exclusive:n,reverse:s};return Ht.runKernelFunc((t,a)=>{const i=gs([e],r.rank);let o=r;null!=i&&(o=cn(r,i));const l=bs(1,r.rank)[0];let u=t.cumsum(o,l,n,s);if(a([r]),null!=i){const t=ys(i);u=cn(u,t)}return u},a,null,"Cumsum",i)}});const xr=ee({depthToSpace_:function(t,e,n="NHWC"){const s=Qt(t,"x","depthToSpace"),r="NHWC"===n?s.shape[1]:s.shape[2],a="NHWC"===n?s.shape[2]:s.shape[3],i="NHWC"===n?s.shape[3]:s.shape[1];l(r*e>=0,()=>`Negative dimension size caused by overflow when multiplying\n    ${r} and ${e}  for depthToSpace with input shape\n    ${s.shape}`),l(a*e>=0,()=>`Negative dimension size caused by overflow when multiplying\n    ${a} and ${e} for depthToSpace with input shape\n        ${s.shape}`),l(i%(e*e)==0,()=>`Dimension size must be evenly divisible by ${e*e} but is ${i} for depthToSpace with input shape ${s.shape}`);const o={x:s},u={blockSize:e,dataFormat:n};return Ht.runKernelFunc(t=>t.depthToSpace(s,e,n),o,null,"DepthToSpace",u)}});const wr=ee({depthwiseConv2d_:function(t,e,n,s,r="NHWC",a=[1,1],i){const o=Qt(t,"x","depthwiseConv2d"),u=Qt(e,"filter","depthwiseConv2d");let c=o,h=!1;3===o.rank&&(h=!0,c=on(o,[1,o.shape[0],o.shape[1],o.shape[2]])),l(4===c.rank,()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${c.rank}.`),l(4===u.rank,()=>"Error in depthwiseConv2d: filter must be rank 4, but got rank "+u.rank+"."),l(c.shape[3]===u.shape[2],()=>`Error in depthwiseConv2d: number of input channels (${c.shape[3]}) must match the inChannels dimension in filter ${u.shape[2]}.`),null!=i&&l(f(s),()=>`Error in depthwiseConv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`);const p={x:c,filter:u},d={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i},m=Ht.runKernelFunc((t,e)=>{null==a&&(a=[1,1]),l(Bs(n,a),()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`);const r=Rs(c.shape,u.shape,n,a,s,i,!0),o=t.depthwiseConv2D(c,u,r);return e([c,u]),o},p,null,"DepthwiseConv2dNative",d);return h?on(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const vr=ee({diag_:function(t){const e=Qt(t,"x","diag"),n={x:e};return Ht.runKernelFunc(n=>{const s=on(e,[e.size]),r=n.diag(s),a=[...t.shape,...t.shape];return on(r,a)},n,null,"Diag")}});const kr=ee({dilation2d_:function(t,e,n,s,r=[1,1],a="NHWC"){const i=Qt(t,"x","dilation2d"),o=Qt(e,"filter","dilation2d");l(3===i.rank||4===i.rank,()=>"Error in dilation2d: input must be rank 3 or 4, but got rank "+i.rank+"."),l(3===o.rank,()=>"Error in dilation2d: filter must be rank 3, but got rank "+o.rank+"."),l("NHWC"===a,()=>"Error in dilation2d: Only NHWC is currently supported, but got dataFormat of "+a);let u=i,c=!1;3===i.rank&&(u=on(i,[1,i.shape[0],i.shape[1],i.shape[2]]),c=!0);const h={x:u,filter:o},p={strides:n,pad:s,dilations:r},d=Ht.runKernel("Dilation2D",h,p);return c?on(d,[d.shape[1],d.shape[2],d.shape[3]]):d}});function Nr(t,e){const n=t.length,s=[];for(let r=0;r<n;r++){const a=n-1-r,i=t[a]||1;(e[e.length-1-r]||1)>1&&1===i&&s.unshift(a)}return s}function Ir(t,e){const n=[];for(let s=0;s<e.length;s++){const r=t[t.length-s-1],a=e.length-s-1,i=e[a];(null==r||1===r&&i>1)&&n.unshift(a)}return n}function Cr(t,e){const n=[],s=Math.max(t.length,e.length);for(let r=0;r<s;r++){let s=t[t.length-r-1];null==s&&(s=1);let a=e[e.length-r-1];if(null==a&&(a=1),1===s)n.unshift(a);else if(1===a)n.unshift(s);else{if(s!==a){throw Error(`Operands could not be broadcast together with shapes ${t} and ${e}.`)}n.unshift(s)}}return n}const Sr=ee({equal_:function(t,e){let n=Qt(t,"a","equal"),s=Qt(e,"b","equal");[n,s]=Lt(n,s),Cr(n.shape,s.shape);const r={a:n,b:s};return Ht.runKernelFunc(t=>t.equal(n,s),r,null,"Equal")}});const Tr=ee({where_:function(t,e,n){const s=Qt(e,"a","where"),r=Qt(n,"b","where"),a=Qt(t,"condition","where","bool"),i=Cr(s.shape,r.shape),o=nr(s,i),c=nr(r,i);1===a.rank&&l(a.shape[0]===s.shape[0],()=>"The first dimension of `a` must match the size of `condition`."),1!==a.rank&&u(a.shape,c.shape,"Error in where: ");const h={condition:a,t:o,e:c};return Ht.runKernelFunc((t,e)=>{const n=t.select(a,o,c);return e([a]),n},h,null,"SelectV2")}});const Er=ee({zerosLike_:function(t){const e=Qt(t,"x","zerosLike"),n={x:e};return Ht.runKernelFunc(t=>t.zerosLike(e),n,null,"ZerosLike")}});const $r=ee({divNoNan_:function(t,e){let n=Qt(t,"a","div"),s=Qt(e,"b","div");[n,s]=Lt(n,s);const r=as(n,s),a=Er(r),i=Sr(s,a);return Tr(i,a,r)}});const Ar=ee({dot_:function(t,e){const n=Qt(t,"t1","dot"),s=Qt(e,"t2","dot");l(!(1!==n.rank&&2!==n.rank||1!==s.rank&&2!==s.rank),()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${s.rank}.`);const r=1===n.rank?n.size:n.shape[1],a=1===s.rank?s.size:s.shape[0];if(l(r===a,()=>`Error in dot: inner dimensions of inputs must match, but got ${r} and ${a}.`),1===n.rank&&1===s.rank){const t=on(n,[1,-1]),e=on(s,[-1,1]),r=ln(t,e);return on(r,[])}if(1===n.rank&&2===s.rank){const t=on(n,[1,-1]),e=on(s,[s.shape[0],s.shape[1]]),r=ln(t,e);return on(r,[r.size])}if(2===n.rank&&1===s.rank){const t=on(s,[-1,1]),e=ln(n,t);return on(e,[e.size])}{const t=on(s,[s.shape[0],s.shape[1]]);return ln(n,t)}}});const Rr=ee({elu_:function(t){const e=Qt(t,"x","elu"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.elu(e);return n([s]),s},n,null,"Elu")}});const Dr=ee({erf_:function(t){let e=Qt(t,"x","erf");l("int32"===e.dtype||"float32"===e.dtype,()=>"Input dtype must be `int32` or `float32`."),"int32"===e.dtype&&(e=Ve(e,"float32"));const n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.erf(e);return n([e]),s},n,null,"Erf")}});const _r=ee({exp_:function(t){const e=Qt(t,"x","exp"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.exp(e);return n([s]),s},n,null,"Exp")}});const Fr=ee({expandDims_:function(t,e=0){const n=Qt(t,"x","expandDims",null);l(e<=n.rank,()=>"Axis must be <= rank of the tensor");const s=n.shape.slice();return e<0&&(l(-(n.rank+1)<=e,()=>`Axis must be in the interval [${-(n.rank+1)}, ${n.rank}]`),e=n.rank+e+1),s.splice(e,0,1),on(n,s)}});const Or=ee({expm1_:function(t){const e=Qt(t,"x","expm1"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.expm1(e);return n([e]),s},n,null,"Expm1")}});const Mr=ee({tile_:function(t,e){const n=Qt(t,"x","tile",null);l(n.rank===e.length,()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${e}.`);const s=[n],r={x:n},a={reps:e};return Ht.runKernelFunc((t,s)=>{const r=t.tile(n,e);return s([n]),r},r,null,"Tile",a,s)}});const Lr=ee({eye_:function(t,e,n,s="float32"){null==e&&(e=t);const r=We([t,e],s),a=t<=e?t:e;for(let t=0;t<a;++t)r.set(1,t,t);const i=on(r.toTensor(),[t,e]);if(null==n)return i;if(1===n.length)return Mr(Fr(i,0),[n[0],1,1]);if(2===n.length)return Mr(Fr(Fr(i,0),0),[n[0],n[1],1,1]);if(3===n.length)return Mr(Fr(Fr(Fr(i,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function zr(t,e,n){const s={shape:t,value:e,dtype:n};return Ht.runKernelFunc(s=>s.fill(t,e,n),{},null,"Fill",s)}const Br=ee({floor_:function(t){const e=Qt(t,"x","floor"),n={x:e};return Ht.runKernelFunc(t=>t.floor(e),n,null,"Floor")}});function Pr(t){return t<=30?t:F(t,Math.floor(Math.sqrt(t)))}function Wr(t,e,n){const s=t.shape[n],r=[];let a=1,i=1;for(let e=0;e<n;e++)r.push(t.shape[e]),a*=t.shape[e];for(let t=0;t<e.rank;t++)r.push(e.shape[t]);for(let e=n+1;e<t.rank;e++)r.push(t.shape[e]),i*=t.shape[e];return{batchSize:a,sliceSize:i,dimSize:s,outputShape:r}}var Vr=Object.freeze({__proto__:null,segOpComputeOptimalWindowSize:function(t,e){let n,s=!1;for(t<=30?(n=t,s=!0):n=F(t,Math.floor(Math.sqrt(t)));!s;)n>e||n===t?s=!0:n=F(t,n+1);return n},computeOutShape:function(t,e,n){const s=[],r=t.length;for(let a=0;a<r;a++)a!==e?s.push(t[a]):s.push(n);return s},collectGatherOpShapeInfo:Wr});const Ur=ee({gather_:function(t,e,n=0){const s=Qt(t,"x","gather"),r=Qt(e,"indices","gather","int32"),a={x:s,indices:r},i={axis:n};return Ht.runKernelFunc((t,e)=>{const a=x(n,s.shape)[0],i=Wr(s,r,a),o=t.gather(s,on(r,[r.size]),a);return e([s,r]),on(o,i.outputShape)},a,null,"GatherV2",i)}});const Gr=ee({greater_:function(t,e){let n=Qt(t,"a","greater"),s=Qt(e,"b","greater");[n,s]=Lt(n,s),Cr(n.shape,s.shape);const r={a:n,b:s};return Ht.runKernelFunc(t=>t.greater(n,s),r,null,"Greater")}});const Hr=ee({greaterEqual_:function(t,e){let n=Qt(t,"a","greaterEqual"),s=Qt(e,"b","greaterEqual");[n,s]=Lt(n,s),Cr(n.shape,s.shape);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.greaterEqual(n,s);return e([n,s]),r},r,null,"GreaterEqual")}});const jr=ee({imag_:function(t){const e=Qt(t,"input","imag"),n={input:e};return Ht.runKernelFunc(t=>t.imag(e),n,null,"Imag")}});const qr=ee({isFinite_:function(t){const e=Qt(t,"x","isFinite"),n={x:e};return Ht.runKernelFunc(t=>t.isFinite(e),n,null,"IsFinite")}});const Kr=ee({isInf_:function(t){const e=Qt(t,"x","isInf"),n={x:e};return Ht.runKernelFunc(t=>t.isInf(e),n,null,"IsInf")}});const Xr=ee({isNaN_:function(t){const e=Qt(t,"x","isNaN"),n={x:e};return Ht.runKernelFunc(t=>t.isNaN(e),n,null,"IsNan")}});const Yr=ee({maximum_:function(t,e){let n=Qt(t,"a","maximum"),s=Qt(e,"b","maximum");[n,s]=Lt(n,s),"bool"===n.dtype&&(n=Ve(n,"int32"),s=Ve(s,"int32")),Cr(n.shape,s.shape);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.maximum(n,s);return e([n,s]),r},r,null,"Maximum")}});function Jr(t,e){if((S(t)&&"string"!==e||Array.isArray(t))&&"complex64"!==e)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===e&&S(t)&&!(t instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return se(t,[],[],e)}const Zr=ee({leakyRelu_:function(t,e=.2){const n=Qt(t,"x","leakyRelu");return Yr(is(Jr(e),n),n)}});const Qr=ee({less_:function(t,e){let n=Qt(t,"a","less"),s=Qt(e,"b","less");[n,s]=Lt(n,s),Cr(n.shape,s.shape);const r={a:n,b:s};return Ht.runKernelFunc(t=>t.less(n,s),r,null,"Less")}});const ta=ee({lessEqual_:function(t,e){let n=Qt(t,"a","lessEqual"),s=Qt(e,"b","lessEqual");[n,s]=Lt(n,s),Cr(n.shape,s.shape);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.lessEqual(n,s);return e([n,s]),r},r,null,"LessEqual")}});function ea(t,e,n){if(n<=0)throw new Error("The number of values should be positive.");const s={start:t,stop:e,num:n};return Ht.runKernelFunc(s=>s.linspace(t,e,n),{},null,"LinSpace",s)}const na=ee({localResponseNormalization_:function(t,e=5,n=1,s=1,r=.5){const a=Qt(t,"x","localResponseNormalization");l(4===a.rank||3===a.rank,()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${a.rank}.`),l(f(e),()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${e}.`);let i=a,o=!1;3===a.rank&&(o=!0,i=on(a,[1,a.shape[0],a.shape[1],a.shape[2]]));const u={x:i},c={depthRadius:e,bias:n,alpha:s,beta:r},h=Ht.runKernelFunc((t,a)=>{const o=t.localResponseNormalization4D(i,e,n,s,r);return a([i,o]),o},u,null,"LRN",c);return o?on(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const sa=ee({log_:function(t){const e=Qt(t,"x","log"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.log(e);return n([e]),s},n,null,"Log")}});const ra=ee({log1p_:function(t){const e=Qt(t,"x","log1p"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.log1p(e);return n([e]),s},n,null,"Log1p")}});function aa(t,e){l(_(t),()=>"The f passed in variableGrads(f) must be a function"),l(null==e||Array.isArray(e)&&e.every(t=>t instanceof Et),()=>"The varList passed in variableGrads(f, varList) must be an array of variables");const n=null!=e;if(!n){e=[];for(const t in Ht.registeredVariables)e.push(Ht.registeredVariables[t])}const s=n?e.filter(t=>!t.trainable):null,r=e.length;l((e=e.filter(t=>t.trainable)).length>0,()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${r} variables is trainable.`);const{value:a,grads:i}=Ht.gradients(t,e,null,!0);l(i.some(t=>null!=t),()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize()."),l(0===a.rank,()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${a.rank} tensor`);const o={};return e.forEach((t,e)=>{null!=i[e]&&(o[t.name]=i[e])}),null!=s&&s.forEach(t=>o[t.name]=null),{value:a,grads:o}}function ia(t){return Ht.customGrad(t)}function oa(t){if(t.filter(t=>null==t).length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that\n    the f you passed encloses all operations that lead from x to y.")}const la=ee({neg_:function(t){const e=Qt(t,"x","neg"),n={x:e};return Ht.runKernelFunc(t=>t.neg(e),n,null,"Negate")}});const ua=ee({softplus_:function(t){const e=Qt(t,"x","softplus"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.softplus(e);return n([e]),s},n,null,"Softplus")}});const ca=ee({logSigmoid_:function(t){const e=Qt(t,"x","logSigmoid");return ia(t=>({value:la(ua(la(t))),gradFunc:e=>is(e,js(la(t)))}))(e)}});const ha=ee({max_:function(t,e=null,n=!1){const s=Qt(t,"x","max"),r={x:s},a={reductionIndices:e,keepDims:n};return Ht.runKernelFunc((t,r)=>{let a=x(e,s.shape);const i=gs(a,s.rank);let o=s;null!=i&&(o=cn(s,i),a=bs(a.length,o.rank));const l=t.max(o,a);null!=i&&o.dispose();let u=l;if(n){const t=fs(u.shape,x(e,s.shape));u=on(u,t),l.dispose()}return r([s,u]),u},r,null,"Max",a)}});const pa=ee({sub_:function(t,e){let n=Qt(t,"a","sub"),s=Qt(e,"b","sub");[n,s]=Lt(n,s);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.subtract(n,s);return e([n,s]),r},r,null,Q)}});const da=ee({sum_:function(t,e=null,n=!1){let s=Qt(t,"x","sum");"bool"===s.dtype&&(s=Ve(s,"int32"));const r={x:s},a={axis:e,keepDims:n};return Ht.runKernelFunc((t,r)=>{r([s]);const a=x(e,s.shape),i=gs(a,s.rank);let o=a,l=s;null!=i&&(l=cn(s,i),o=bs(o.length,s.rank));let u=t.sum(l,o);if(n){const t=fs(u.shape,a);u=on(u,t)}return u},r,null,"Sum",a)}});const fa=ee({logSoftmax_:function(t,e=-1){const n=Qt(t,"logits","logSoftmax");if(-1===e&&(e=n.rank-1),e!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${e}`);const s={logits:n},r={axis:e};return Ht.runKernelFunc((n,s)=>{const r=ha(t,e,!0),a=pa(t,r),i=pa(Ve(a,"float32"),sa(da(_r(a),e,!0)));return s([i]),i},s,null,"LogSoftmax",r)}});const ma=ee({logSumExp_:function(t,e=null,n=!1){const s=Qt(t,"x","logSumExp"),r=x(e,s.shape),a=ha(s,r,!0),i=pa(s,a),o=_r(i),l=da(o,r),u=sa(l),c=ss(on(a,u.shape),u);if(n){const t=fs(c.shape,r);return on(c,t)}return c}});const ga=ee({logicalAnd_:function(t,e){const n=Qt(t,"a","logicalAnd","bool"),s=Qt(e,"b","logicalAnd","bool");Cr(n.shape,s.shape);const r={a:n,b:s};return Ht.runKernelFunc(t=>t.logicalAnd(n,s),r,null,"LogicalAnd")}});const ya=ee({logicalNot_:function(t){const e=Qt(t,"x","logicalNot","bool"),n={x:e};return Ht.runKernelFunc(t=>t.logicalNot(e),n,null,"LogicalNot")}});const ba=ee({logicalOr_:function(t,e){const n=Qt(t,"a","logicalOr","bool"),s=Qt(e,"b","logicalOr","bool");Cr(n.shape,s.shape);const r={a:n,b:s};return Ht.runKernelFunc(t=>t.logicalOr(n,s),r,null,"LogicalOr")}});const xa=ee({logicalXor_:function(t,e){const n=Qt(t,"a","logicalXor","bool"),s=Qt(e,"b","logicalXor","bool");return Cr(n.shape,s.shape),ga(ba(t,e),ya(ga(t,e)))}});const wa=ee({maxPool_:function(t,e,n,s,r){const a=Qt(t,"x","maxPool");let i=a,o=!1;3===a.rank&&(o=!0,i=on(a,[1,a.shape[0],a.shape[1],a.shape[2]])),l(4===i.rank,()=>`Error in maxPool: input must be rank 4 but got rank ${i.rank}.`),l(Bs(n,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`),null!=r&&l(f(s),()=>`Error in maxPool: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`);const u={x:i},c={filterSize:e,strides:n,pad:s,dimRoundingMode:r},h=Ht.runKernelFunc((t,a)=>{const o=$s(i.shape,e,n,1,s,r);let l;return l=1===o.filterWidth&&1===o.filterHeight&&d(o.inShape,o.outShape)?i.clone():t.maxPool(i,o),a([i,l]),l},u,null,"MaxPool",c);return o?on(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const va=ee({maxPool3d_:function(t,e=[1,1,1],n,s,r,a="NDHWC",i){null==i?i=[1,1,1]:Kn("dilations is deprecated, this field will be gone in v3.0.0.");const o=Qt(t,"x","maxPool3d");let u=o,c=!1;4===o.rank&&(c=!0,u=on(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),l(5===u.rank,()=>`Error in maxPool3d: x must be rank 5 but got rank ${u.rank}.`),l("NDHWC"===a,()=>"Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of "+a),l(Bs(n,i),()=>`Error in maxPool3d: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`),null!=r&&l(f(s),()=>`Error in maxPool3d: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`);const h={x:u},p={filterSize:e,strides:n,pad:s,dimRoundingMode:r,dataFormat:a,dilations:i},d=Ht.runKernelFunc((t,o)=>{null==i&&(i=[1,1,1]);const l=As(u.shape,e,n,i,s,r,a),c=t.maxPool3d(u,l);return o([u,c]),c},h,null,"MaxPool3D",p);return c?on(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const ka=ee({maxPoolWithArgmax_:function(t,e,n,s,r=!1){const a={x:Qt(t,"x","maxPoolWithArgmax")},i={filterSize:e,strides:n,pad:s,includeBatchInIndex:r},o=Ht.runKernel("MaxPoolWithArgmax",a,i);return{result:o[0],indexes:o[1]}}});function Na(t,e="float32"){if("complex64"===e){const e=Na(t,"float32"),n=Na(t,"float32");return ne(e,n)}const n=z(p(t),e);return Ht.makeTensor(n,t,e)}function Ia(t,e="float32"){if("complex64"===e){const e=Ia(t,"float32"),n=Na(t,"float32");return ne(e,n)}const n=L(p(t),e);return Ht.makeTensor(n,t,e)}const Ca=ee({mean_:function(t,e=null,n=!1){const s=Qt(t,"x","mean"),r=x(e,s.shape),a=p(ds(s.shape,r)[1]),i={x:s},o={axis:e,keepDims:n},l=()=>{const t=Jr(a),r=t.dtype===s.dtype?s:Ve(s,t.dtype),i=as(r,t);return da(i,e,n)};return ia(t=>({value:Ht.runKernelFunc(l,i,null,"Mean",o),gradFunc:e=>{const n=t.shape.slice();r.forEach(t=>{n[t]=1});const s=on(e,n);return as(is(s,Ia(t.shape,"float32")),a)}}))(s)}});const Sa=ee({min_:function(t,e=null,n=!1){const s=Qt(t,"x","min"),r={x:s},a={axis:e,keepDims:n};return Ht.runKernelFunc((t,r)=>{const a=x(e,s.shape);let i=a;const o=gs(i,s.rank);let l=s;null!=o&&(l=cn(s,o),i=bs(i.length,s.rank));const u=t.min(l,i);null!=o&&l.dispose();let c=u;if(n){const t=fs(c.shape,a);c=on(u,t),u.dispose()}return r([s,c]),c},r,null,"Min",a)}});const Ta=ee({minimum_:function(t,e){let n=Qt(t,"a","minimum"),s=Qt(e,"b","minimum");[n,s]=Lt(n,s),"bool"===n.dtype&&(n=Ve(n,"int32"),s=Ve(s,"int32")),Cr(n.shape,s.shape);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.minimum(n,s);return e([n,s]),r},r,null,"Minimum")}});const Ea=ee({mirrorPad_:function(t,e,n){l("reflect"===n||"symmetric"===n,()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`);const s=Qt(t,"x","mirrorPad");if(0===s.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");l(e.length===s.rank,()=>`Padding doesn't match input. Must be ${s.rank}. Got ${e.length}.`);const r="reflect"===n?1:0;for(let t=0;t<s.rank;t++)l(2===e[t].length,()=>"Invalid number of paddings. Must be length of 2 each."),l(e[t][0]>=0&&e[t][0]<=s.shape[t]-r&&e[t][1]>=0&&e[t][1]<=s.shape[t]-r,()=>`Padding in dimension ${t} cannot be greater than or equal to ${s.shape[t]-r} or less than 0 for input of shape `+s.shape);const a={paddings:e,mode:n},i={x:s};return Ht.runKernel("MirrorPad",i,a)}});const $a=ee({mod_:function(t,e){let n=Qt(t,"a","mod"),s=Qt(e,"b","mod");[n,s]=Lt(n,s);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.mod(n,s);return e([n,s]),r},r,null,"Mod")}});const Aa=ee({square_:function(t){const e=Qt(t,"x","square"),n=[e];return Ht.runKernelFunc((t,n)=>(n([e]),t.square(e)),{x:e},null,"Square",{},n,[])}});const Ra=ee({moments_:function(t,e=null,n=!1){const s=x(e,(t=Qt(t,"x","moments")).shape),r=Ca(t,s,n);let a=r.shape;n||(a=fs(r.shape,s));const i=Aa(pa(Ve(t,"float32"),on(r,a)));return{mean:r,variance:Ca(i,s,n)}}});const Da=ee({multiRNNCell_:function(t,e,n,s){const r=Qt(e,"data","multiRNNCell"),a=te(n,"c","multiRNNCell"),i=te(s,"h","multiRNNCell");let o=r;const l=[];for(let e=0;e<t.length;e++){const n=t[e](o,a[e],i[e]);l.push(n[0]),l.push(n[1]),o=n[1]}const u=[],c=[];for(let t=0;t<l.length;t+=2)u.push(l[t]),c.push(l[t+1]);return[u,c]}});const _a=ee({multinomial_:function(t,e,n,s=!1){const r=Qt(t,"logits","multinomial"),a=r.size,i=r.rank;if(a<2)throw new Error("Error in multinomial: you need at least 2 outcomes, but got "+a+".");if(i>2)throw new Error("Rank of probabilities must be 1 or 2, but is "+i);n=n||Math.random();const o=1===i?on(r,[1,-1]):r,l=Ht.runKernelFunc(t=>t.multinomial(o,s,e,n),{logits2D:o});return 1===i?on(l,[l.size]):l}});const Fa=ee({notEqual_:function(t,e){let n=Qt(t,"a","notEqual"),s=Qt(e,"b","notEqual");[n,s]=Lt(n,s),Cr(n.shape,s.shape);const r={a:n,b:s};return Ht.runKernelFunc(t=>t.notEqual(n,s),r,null,"NotEqual")}});const Oa=ee({real_:function(t){const e=Qt(t,"input","real"),n={input:e};return Ht.runKernelFunc(t=>t.real(e),n,null,"Real")}});const Ma=ee({onesLike_:function(t){const e=Qt(t,"x","onesLike"),n={x:e};return Ht.runKernelFunc((t,n)=>{if("complex64"===e.dtype){const t=Ma(Oa(e)),n=Er(jr(e));return ne(t,n)}return t.onesLike(e)},n,null,"OnesLike")}});const La=ee({outerProduct_:function(t,e){const n=Qt(t,"v1","outerProduct"),s=Qt(e,"v2","outerProduct");l(1===n.rank&&1===s.rank,()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${s.rank}.`);const r=on(n,[-1,1]),a=on(s,[1,-1]);return ln(r,a)}});const za=ee({pad_:function(t,e,n=0){const s=Qt(t,"x","pad");if(0===s.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const r={paddings:e,constantValue:n},a={x:s};return Ht.runKernelFunc((t,r)=>(r([s]),t.pad(s,e,n)),a,null,"PadV2",r)}});const Ba=ee({pad1d_:function(t,e,n=0){return l(2===e.length,()=>"Invalid number of paddings. Must be length of 2."),za(t,[e],n)}});const Pa=ee({pad2d_:function(t,e,n=0){return l(2===e.length&&2===e[0].length&&2===e[1].length,()=>"Invalid number of paddings. Must be length of 2 each."),za(t,e,n)}});const Wa=ee({pad3d_:function(t,e,n=0){return l(3===e.length&&2===e[0].length&&2===e[1].length&&2===e[2].length,()=>"Invalid number of paddings. Must be length of 2 each."),za(t,e,n)}});const Va=ee({pad4d_:function(t,e,n=0){return l(4===e.length&&2===e[0].length&&2===e[1].length&&2===e[2].length&&2===e[3].length,()=>"Invalid number of paddings. Must be length of 2 each."),za(t,e,n)}});const Ua=ee({spaceToBatchND_:function(t,e,n){const s=Qt(t,"x","spaceToBatchND");l(s.rank>=1+e.length,()=>`input rank ${s.rank} should be > than [blockShape] ${e.length}`),l(n.length===e.length,()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${e.length}`),l(s.shape.reduce((t,s,r)=>r>0&&r<=e.length?t&&(s+n[r-1][0]+n[r-1][1])%e[r-1]==0:t,!0),()=>`input spatial dimensions ${s.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${e.toString()}`);const r={x:s},a={blockShape:e,paddings:n};return Ht.runKernelFunc(t=>t.spaceToBatchND(s,e,n),r,null,"SpaceToBatchND",a)}});const Ga=ee({pool_:function(t,e,n,s,r,a){null==r&&(r=[1,1]),null==a&&(a=1),0===s&&(s="valid");const i=Qt(t,"x","maxPool");let o=i,u=!1;3===i.rank&&(u=!0,o=on(i,[1,i.shape[0],i.shape[1],i.shape[2]])),l(Bs(a,r),()=>`Error in pool: Either strides or dilations must be 1. Got strides ${a} and dilations '${r}'`);const c=$s(o.shape,e,a,r,s),h=[c.dilationHeight,c.dilationWidth];let p;p="same"===s?function(t,e){const n=t.map((t,n)=>t+(t-1)*(e[n]-1)).map(t=>t-1),s=n.map(t=>Math.floor(t/2)),r=n.map((t,e)=>t-s[e]);return n.map((t,e)=>[s[e],r[e]])}([c.filterHeight,c.filterWidth],h):[[0,0],[0,0]];const d=1===h[0]&&1===h[1],[f,m]=function(t,e,n){const s=n.map(t=>t[0]),r=n.map(t=>t[1]),a=t.concat(s,r),i=e.map((t,e)=>(t-a[e]%t)%t),o=r.map((t,e)=>t+i[e]),l=e.map((t,e)=>[s[e],o[e]]),u=e.map((t,e)=>[0,i[e]]);return[l,u]}([c.inHeight,c.inWidth],h,p),g=d?s:"valid",y=d?o:Ua(o,h,f),b=("avg"===n?()=>Ws(y,e,a,g):()=>wa(y,e,a,g))(),x=d?b:Ys(b,h,m);return u?on(x,[x.shape[1],x.shape[2],x.shape[3]]):x}});const Ha=ee({pow_:function(t,e){let n=Qt(t,"base","pow"),s=Qt(e,"exp","pow");[n,s]=Lt(n,s);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.pow(n,s);return e([n,s,r]),r},r,null,"Pow")}});const ja=ee({prelu_:function(t,e){const n=Qt(t,"x","prelu"),s=Qt(e,"alpha","prelu"),r={x:n,alpha:s};return Ht.runKernelFunc((t,e)=>{const r=t.prelu(n,s);return e([n,s]),r},r,null,"Prelu")}});const qa=ee({prod_:function(t,e=null,n=!1){let s=Qt(t,"x","prod");"bool"===s.dtype&&(s=Ve(s,"int32"));const r={x:s},a={axis:e,keepDims:n};return Ht.runKernelFunc(t=>{const r=x(e,s.shape),a=gs(r,s.rank);let i=r,o=s;null!=a&&(o=cn(s,a),i=bs(i.length,s.rank));let l=t.prod(o,i);if(n){const t=fs(l.shape,r);l=on(l,t)}return l},r,null,"Prod",a)}});const Ka=ee({rand_:function(t,e,n){const s=p(t);let r=null;if(null==n||"float32"===n)r=new Float32Array(s);else if("int32"===n)r=new Int32Array(s);else{if("bool"!==n)throw new Error("Unknown data type "+n);r=new Uint8Array(s)}for(let t=0;t<s;t++)r[t]=e();return Ht.makeTensor(r,t,n)}});"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self&&self;function Xa(t,e){return t(e={exports:{}},e.exports),e.exports}var Ya=Xa((function(t){!function(t,e,n){function s(t){var e,n=this,s=(e=4022871197,function(t){t=t.toString();for(var n=0;n<t.length;n++){var s=.02519603282416938*(e+=t.charCodeAt(n));s-=e=s>>>0,e=(s*=e)>>>0,e+=4294967296*(s-=e)}return 2.3283064365386963e-10*(e>>>0)});n.next=function(){var t=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=t-(n.c=0|t)},n.c=1,n.s0=s(" "),n.s1=s(" "),n.s2=s(" "),n.s0-=s(t),n.s0<0&&(n.s0+=1),n.s1-=s(t),n.s1<0&&(n.s1+=1),n.s2-=s(t),n.s2<0&&(n.s2+=1),s=null}function r(t,e){return e.c=t.c,e.s0=t.s0,e.s1=t.s1,e.s2=t.s2,e}function a(t,e){var n=new s(t),a=e&&e.state,i=n.next;return i.int32=function(){return 4294967296*n.next()|0},i.double=function(){return i()+11102230246251565e-32*(2097152*i()|0)},i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}e&&e.exports?e.exports=a:n&&n.amd?n((function(){return a})):this.alea=a}(0,t,!1)})),Ja=Xa((function(t){!function(t,e,n){function s(t){var e=this,n="";e.x=0,e.y=0,e.z=0,e.w=0,e.next=function(){var t=e.x^e.x<<11;return e.x=e.y,e.y=e.z,e.z=e.w,e.w^=e.w>>>19^t^t>>>8},t===(0|t)?e.x=t:n+=t;for(var s=0;s<n.length+64;s++)e.x^=0|n.charCodeAt(s),e.next()}function r(t,e){return e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e}function a(t,e){var n=new s(t),a=e&&e.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}e&&e.exports?e.exports=a:n&&n.amd?n((function(){return a})):this.xor128=a}(0,t,!1)})),Za=Xa((function(t){!function(t,e,n){function s(t){var e=this,n="";e.next=function(){var t=e.x^e.x>>>2;return e.x=e.y,e.y=e.z,e.z=e.w,e.w=e.v,(e.d=e.d+362437|0)+(e.v=e.v^e.v<<4^t^t<<1)|0},e.x=0,e.y=0,e.z=0,e.w=0,e.v=0,t===(0|t)?e.x=t:n+=t;for(var s=0;s<n.length+64;s++)e.x^=0|n.charCodeAt(s),s==n.length&&(e.d=e.x<<10^e.x>>>4),e.next()}function r(t,e){return e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e.v=t.v,e.d=t.d,e}function a(t,e){var n=new s(t),a=e&&e.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}e&&e.exports?e.exports=a:n&&n.amd?n((function(){return a})):this.xorwow=a}(0,t,!1)})),Qa=Xa((function(t){!function(t,e,n){function s(t){var e=this;e.next=function(){var t,n,s=e.x,r=e.i;return t=s[r],n=(t^=t>>>7)^t<<24,n^=(t=s[r+1&7])^t>>>10,n^=(t=s[r+3&7])^t>>>3,n^=(t=s[r+4&7])^t<<7,t=s[r+7&7],n^=(t^=t<<13)^t<<9,s[r]=n,e.i=r+1&7,n},function(t,e){var n,s=[];if(e===(0|e))s[0]=e;else for(e=""+e,n=0;n<e.length;++n)s[7&n]=s[7&n]<<15^e.charCodeAt(n)+s[n+1&7]<<13;for(;s.length<8;)s.push(0);for(n=0;n<8&&0===s[n];++n);for(8==n?s[7]=-1:s[n],t.x=s,t.i=0,n=256;n>0;--n)t.next()}(e,t)}function r(t,e){return e.x=t.x.slice(),e.i=t.i,e}function a(t,e){null==t&&(t=+new Date);var n=new s(t),a=e&&e.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},i.int32=n.next,i.quick=i,a&&(a.x&&r(a,n),i.state=function(){return r(n,{})}),i}e&&e.exports?e.exports=a:n&&n.amd?n((function(){return a})):this.xorshift7=a}(0,t,!1)})),ti=Xa((function(t){!function(t,e,n){function s(t){var e=this;e.next=function(){var t,n,s=e.w,r=e.X,a=e.i;return e.w=s=s+1640531527|0,n=r[a+34&127],t=r[a=a+1&127],n^=n<<13,t^=t<<17,n^=n>>>15,t^=t>>>12,n=r[a]=n^t,e.i=a,n+(s^s>>>16)|0},function(t,e){var n,s,r,a,i,o=[],l=128;for(e===(0|e)?(s=e,e=null):(e+="\0",s=0,l=Math.max(l,e.length)),r=0,a=-32;a<l;++a)e&&(s^=e.charCodeAt((a+32)%e.length)),0===a&&(i=s),s^=s<<10,s^=s>>>15,s^=s<<4,s^=s>>>13,a>=0&&(i=i+1640531527|0,r=0==(n=o[127&a]^=s+i)?r+1:0);for(r>=128&&(o[127&(e&&e.length||0)]=-1),r=127,a=512;a>0;--a)s=o[r+34&127],n=o[r=r+1&127],s^=s<<13,n^=n<<17,s^=s>>>15,n^=n>>>12,o[r]=s^n;t.w=i,t.X=o,t.i=r}(e,t)}function r(t,e){return e.i=t.i,e.w=t.w,e.X=t.X.slice(),e}function a(t,e){null==t&&(t=+new Date);var n=new s(t),a=e&&e.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},i.int32=n.next,i.quick=i,a&&(a.X&&r(a,n),i.state=function(){return r(n,{})}),i}e&&e.exports?e.exports=a:n&&n.amd?n((function(){return a})):this.xor4096=a}(0,t,!1)})),ei=Xa((function(t){!function(t,e,n){function s(t){var e=this,n="";e.next=function(){var t=e.b,n=e.c,s=e.d,r=e.a;return t=t<<25^t>>>7^n,n=n-s|0,s=s<<24^s>>>8^r,r=r-t|0,e.b=t=t<<20^t>>>12^n,e.c=n=n-s|0,e.d=s<<16^n>>>16^r,e.a=r-t|0},e.a=0,e.b=0,e.c=-1640531527,e.d=1367130551,t===Math.floor(t)?(e.a=t/4294967296|0,e.b=0|t):n+=t;for(var s=0;s<n.length+20;s++)e.b^=0|n.charCodeAt(s),e.next()}function r(t,e){return e.a=t.a,e.b=t.b,e.c=t.c,e.d=t.d,e}function a(t,e){var n=new s(t),a=e&&e.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}e&&e.exports?e.exports=a:n&&n.amd?n((function(){return a})):this.tychei=a}(0,t,!1)})),ni=Xa((function(t){!function(e,n){var s,r=this,a=n.pow(256,6),i=n.pow(2,52),o=2*i;function l(t,l,d){var f=[],m=h(function t(e,n){var s,r=[],a=typeof e;if(n&&"object"==a)for(s in e)try{r.push(t(e[s],n-1))}catch(t){}return r.length?r:"string"==a?e:e+"\0"}((l=1==l?{entropy:!0}:l||{}).entropy?[t,p(e)]:null==t?function(){try{var t;return s&&(t=s.randomBytes)?t=t(256):(t=new Uint8Array(256),(r.crypto||r.msCrypto).getRandomValues(t)),p(t)}catch(t){var n=r.navigator,a=n&&n.plugins;return[+new Date,r,a,r.screen,p(e)]}}():t,3),f),g=new u(f),y=function(){for(var t=g.g(6),e=a,n=0;t<i;)t=256*(t+n),e*=256,n=g.g(1);for(;t>=o;)t/=2,e/=2,n>>>=1;return(t+n)/e};return y.int32=function(){return 0|g.g(4)},y.quick=function(){return g.g(4)/4294967296},y.double=y,h(p(g.S),e),(l.pass||d||function(t,e,s,r){return r&&(r.S&&c(r,g),t.state=function(){return c(g,{})}),s?(n.random=t,e):t})(y,m,"global"in l?l.global:this==n,l.state)}function u(t){var e,n=t.length,s=this,r=0,a=s.i=s.j=0,i=s.S=[];for(n||(t=[n++]);r<256;)i[r]=r++;for(r=0;r<256;r++)i[r]=i[a=255&a+t[r%n]+(e=i[r])],i[a]=e;(s.g=function(t){for(var e,n=0,r=s.i,a=s.j,i=s.S;t--;)e=i[r=255&r+1],n=256*n+i[255&(i[r]=i[a=255&a+e])+(i[a]=e)];return s.i=r,s.j=a,n})(256)}function c(t,e){return e.i=t.i,e.j=t.j,e.S=t.S.slice(),e}function h(t,e){for(var n,s=t+"",r=0;r<s.length;)e[255&r]=255&(n^=19*e[255&r])+s.charCodeAt(r++);return p(e)}function p(t){return String.fromCharCode.apply(0,t)}if(n.seedrandom=l,h(n.random(),e),t.exports){t.exports=l;try{s=require("crypto")}catch(t){}}else 0}([],Math)}));ni.alea=Ya,ni.xor128=Ja,ni.xorwow=Za,ni.xorshift7=Qa,ni.xor4096=ti,ni.tychei=ei;var si=ni.alea;class ri{constructor(t,e,n,s,r){this.mean=t,this.stdDev=e,this.dtype=n,this.nextVal=NaN,this.truncated=s,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const a=r||Math.random();this.random=si(a.toString())}nextValue(){if(!isNaN(this.nextVal)){const t=this.nextVal;return this.nextVal=NaN,t}let t,e,n=!1;for(;!n;){let s,r,a;do{s=2*this.random()-1,r=2*this.random()-1,a=s*s+r*r}while(a>=1||0===a);const i=Math.sqrt(-2*Math.log(a)/a);t=this.mean+this.stdDev*s*i,e=this.mean+this.stdDev*r*i,this.truncated&&!this.isValidTruncated(t)||(n=!0)}return this.truncated&&!this.isValidTruncated(e)||(this.nextVal=this.convertValue(e)),this.convertValue(t)}convertValue(t){return null==this.dtype||"float32"===this.dtype?t:Math.round(t)}isValidTruncated(t){return t<=this.upper&&t>=this.lower}}class ai{constructor(t,e,n,s){this.alpha=t,this.beta=1/e,this.dtype=n;const r=s||Math.random();this.randu=si(r.toString()),this.randn=new ri(0,1,n,!1,this.randu()),this.d=t<1?t+2/3:t-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let t,e,n,s,r,a;for(;;){do{s=this.randn.nextValue(),a=1+this.c*s}while(a<=0);if(a*=a*a,t=s*s,e=1-.331*t*t,n=.5*t+this.d*(1-a+Math.log(a)),r=this.randu(),r<e||Math.log(r)<n)break}return a=1/this.beta*this.d*a,this.alpha<1&&(a*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(a)}convertValue(t){return"float32"===this.dtype?t:Math.round(t)}}class ii{constructor(t=0,e=1,n,s){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=t,this.range=e-t,this.dtype=n,null==s&&(s=Math.random()),"number"==typeof s&&(s=s.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${t} - ${e} <= 1 and dtype is not float`);this.random=si(s)}convertValue(t){return this.canReturnFloat()?t:Math.round(t)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const oi=ee({randomGamma_:function(t,e,n=1,s="float32",r){if(null==n&&(n=1),null==s&&(s="float32"),"float32"!==s&&"int32"!==s)throw new Error("Unsupported data type "+s);const a=new ai(e,n,s,r),i=We(t,s);for(let t=0;t<i.values.length;t++)i.values[t]=a.nextValue();return i.toTensor()}});const li=ee({randomNormal_:function(t,e=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error("Unsupported data type "+s);const a=new ri(e,n,s,!1,r),i=We(t,s);for(let t=0;t<i.values.length;t++)i.values[t]=a.nextValue();return i.toTensor()}});const ui=ee({randomUniform_:function(t,e=0,n=1,s="float32",r){const a=We(t,s),i=new ii(e,n,null,r);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}});function ci(t,e){c(t);const n=Jt(t,e);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return se(t,null,n,e)}function hi(t,e,n=1,s="float32"){if(0===n)throw new Error("Cannot have a step of zero");const r={start:t,stop:e,step:n,dtype:s};return Ht.runKernelFunc(()=>{if(t===e||t<e&&n<0||e<t&&n>1)return Na([0],s);const r=z(Math.abs(Math.ceil((e-t)/n)),s);e<t&&1===n&&(n=-1),r[0]=t;for(let t=1;t<r.length;t++)r[t]=r[t-1]+n;return ci(r,s)},{},null,"Range",r)}const pi=ee({reciprocal_:function(t){const e=Qt(t,"x","reciprocal"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.reciprocal(e);return n([e]),s},n,null,"Reciprocal")}});const di=ee({relu_:function(t){const e=Qt(t,"x","relu"),n={x:e};return Ht.runKernelFunc((t,n)=>(n([e]),"bool"===e.dtype?Ve(e,"int32"):t.relu(e)),n,null,"Relu")}});const fi=ee({relu6_:function(t){const e=Qt(t,"x","relu6"),n={x:e};return Ht.runKernelFunc((t,n)=>(n([e]),"bool"===e.dtype?Ve(e,"int32"):t.relu6(e)),n,null,"Relu6")}});const mi=ee({reverse_:function(t,e){const n=Qt(t,"x","reverse"),s={x:n},r={dims:e};return Ht.runKernelFunc(t=>{const s=x(e,n.shape);if(0===n.rank)return Ue(n);const r=t.reverse(n,s);return on(r,n.shape)},s,null,"Reverse",r)}});const gi=ee({reverse1d_:function(t){const e=Qt(t,"x","reverse");return l(1===e.rank,()=>`Error in reverse1D: x must be rank 1 but got rank ${e.rank}.`),mi(e,0)}});const yi=ee({reverse2d_:function(t,e){const n=Qt(t,"x","reverse");return l(2===n.rank,()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`),mi(n,e)}});const bi=ee({reverse3d_:function(t,e){const n=Qt(t,"x","reverse");return l(3===n.rank,()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`),mi(n,e)}});const xi=ee({reverse4d_:function(t,e){const n=Qt(t,"x","reverse");return l(4===n.rank,()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`),mi(n,e)}});const wi=ee({round_:function(t){const e=Qt(t,"x","round"),n={x:e};return Ht.runKernelFunc(t=>t.round(e),n,null,"Round")}});const vi=ee({rsqrt_:function(t){const e=Qt(t,"x","rsqrt"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.rsqrt(e);return n([e]),s},n,null,"Rsqrt")}});const ki=ee({selu_:function(t){const e=Qt(t,"x","selu"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.selu(e);return n([e]),s},n,null,"Selu")}});const Ni=ee({separableConv2d_:function(t,e,n,s,r,a=[1,1],i="NHWC"){const o=Qt(t,"x","separableConv2d"),u=Qt(e,"depthwiseFilter","separableConv2d"),c=Qt(n,"pointwiseFilter","separableConv2d");let h=o,p=!1;if(3===o.rank&&(p=!0,h=on(o,[1,o.shape[0],o.shape[1],o.shape[2]])),"NCHW"===i)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");l(4===h.rank,()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`),l(4===u.rank,()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${u.rank}.`),l(4===c.rank,()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${u.rank}.`),l(1===c.shape[0],()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${c.shape[0]}.`),l(1===c.shape[1],()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${c.shape[1]}.`);const d=u.shape[2],f=u.shape[3];l(c.shape[2]===d*f,()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${d*f}, but got ${c.shape[2]}.`);const m=wr(h,u,s,r,i,a),g=ur(m,c,1,"valid",i);return p?on(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const Ii=async function(t,e){const n=Qt(t,"x","setdiff1d"),s=Qt(e,"y","setdiff1d");l(n.dtype===s.dtype,()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${s.dtype}).`),l(1===n.rank,()=>`x should be 1D tensor, but got x (${n.shape}).`),l(1===s.rank,()=>`y should be 1D tensor, but got y (${s.shape}).`);const r=await n.data(),a=await s.data(),i=new Set(a);let o=0;for(let t=0;t<r.length;t++)i.has(r[t])||o++;const u=new Nt([o],n.dtype),c=new Nt([o],"int32");for(let t=0,e=0;t<r.length;t++)i.has(r[t])||(u.values[e]=r[t],c.values[e]=t,e++);return[u.toTensor(),c.toTensor()]};const Ci=ee({sign_:function(t){const e=Qt(t,"x","sign"),n={x:e};return Ht.runKernelFunc(t=>t.sign(e),n,null,"Sign")}});const Si=ee({sin_:function(t){const e=Qt(t,"x","sin"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.sin(e);return n([e]),s},n,null,Z)}});const Ti=ee({sinh_:function(t){const e=Qt(t,"x","sinh"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.sinh(e);return n([e]),s},n,null,"Sinh")}});const Ei=ee({slice1d_:function(t,e,n){const s=Qt(t,"x","slice1d");return l(1===s.rank,()=>`slice1d expects a rank-1 tensor, but got a rank-${s.rank} tensor`),qs(s,[e],[n])}});const $i=ee({slice2d_:function(t,e,n){const s=Qt(t,"x","slice2d");return l(2===s.rank,()=>`slice2d expects a rank-2 tensor, but got a rank-${s.rank} tensor`),qs(s,e,n)}});const Ai=ee({slice3d_:function(t,e,n){const s=Qt(t,"x","slice3d");return l(3===s.rank,()=>`slice3d expects a rank-3 tensor, but got a rank-${s.rank} tensor`),qs(s,e,n)}});const Ri=ee({slice4d_:function(t,e,n){const s=Qt(t,"x","slice4d");return l(4===s.rank,()=>`slice4d expects a rank-4 tensor, but got a rank-${s.rank} tensor`),qs(s,e,n)}});const Di=ee({softmax_:function(t,e=-1){const n=Qt(t,"logits","softmax","float32");if(-1===e&&(e=n.rank-1),e!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${e}`);const s={logits:n},r={dim:e};return Ht.runKernelFunc((t,s)=>{const r=t.softmax(n,e);return s([r]),r},s,null,"Softmax",r)}});const _i=ee({fft_:function(t){l("complex64"===t.dtype,()=>`The dtype for tf.spectral.fft() must be complex64 but got ${t.dtype}.`);const e={input:t};return Ht.runKernelFunc(e=>{const n=t.shape[t.shape.length-1],s=t.size/n,r=t.as2D(s,n);return e.fft(r).reshape(t.shape)},e,null,"FFT")}});const Fi=ee({ifft_:function(t){l("complex64"===t.dtype,()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${t.dtype}.`);const e={input:t};return Ht.runKernelFunc(e=>{const n=t.shape[t.shape.length-1],s=t.size/n,r=on(t,[s,n]),a=e.ifft(r);return on(a,t.shape)},e,null,"IFFT")}});const Oi=ee({irfft_:function(t){const e=t.shape[t.shape.length-1],n=t.size/e;let s;if(e<=2){const r=on(t,[n,e]);s=Fi(r)}else{const r=[n,2*(e-1)],a=on(Oa(t),[n,e]),i=on(jr(t),[n,e]),o=mi(qs(a,[0,1],[n,e-2]),1),l=is(mi(qs(i,[0,1],[n,e-2]),1),Jr(-1)),u=Hs([a,o],1),c=Hs([i,l],1),h=on(ne(u,c),[r[0],r[1]]);s=Fi(h)}if(s=Oa(s),3===t.rank&&0!==t.shape[0]){const e=s,n=t.shape[0];s=on(s,[n,s.shape[0]/n,s.shape[1]]),e.dispose()}return s}});function Mi(t,e,n=0){let s=[];if("number"==typeof e)l(t.shape[n]%e==0,()=>"Number of splits must evenly divide the axis."),s=new Array(e).fill(t.shape[n]/e);else{l(e.reduce((t,e)=>(-1===e&&(t+=1),t),0)<=1,()=>"There should be only one negative value in split array.");const r=e.indexOf(-1);if(-1!==r){const s=e.reduce((t,e)=>e>0?t+e:t);e[r]=t.shape[n]-s}l(t.shape[n]===e.reduce((t,e)=>t+e),()=>"The sum of sizes must match the size of the axis dimension."),s=e}return s}const Li=ee({split_:function(t,e,n=0){const s=Qt(t,"x","split"),r={x:s},a={numOrSizeSplits:e,axis:n};return Ht.runKernelFunc((t,r)=>{const a=x(n,s.shape)[0],i=Mi(s,e,a);return t.split(s,i,a)},r,null,"SplitV",a)}});const zi=ee({rfft_:function(t,e){l("float32"===t.dtype,()=>"The dtype for rfft() must be real value but got "+t.dtype);let n=t.shape[t.shape.length-1];const s=t.size/n;let r;if(null!=e&&e<n){const s=t.shape.map(t=>0),a=t.shape.map(t=>t);a[t.shape.length-1]=e,r=qs(t,s,a),n=e}else if(null!=e&&e>n){const s=t.shape.map(t=>t);s[t.shape.length-1]=e-n,r=Hs([t,Na(s)],t.shape.length-1),n=e}else r=t;const a=Er(r),i=on(ne(r,a),[s,n]),o=_i(i),u=Math.floor(n/2)+1,c=Oa(o),h=jr(o),p=Li(c,[u,n-u],c.shape.length-1),d=Li(h,[u,n-u],h.shape.length-1),f=r.shape.slice();return f[r.shape.length-1]=u,on(ne(p[0],d[0]),f)}});const Bi=ee({sqrt_:function(t){const e=Qt(t,"x","sqrt"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.sqrt(e);return n([e]),s},n,null,"Sqrt")}});const Pi=ee({squaredDifference_:function(t,e){let n=Qt(t,"a","squaredDifference"),s=Qt(e,"b","squaredDifference");[n,s]=Lt(n,s),Cr(n.shape,s.shape);const r={a:n,b:s};return Ht.runKernelFunc((t,e)=>{const r=t.squaredDifference(n,s);return e([n,s]),r},r,null,"SquaredDifference",{})}});const Wi=ee({squeeze_:function(t,e){const n=Qt(t,"x","squeeze");return on(n,w(n.shape,e).newShape)}});const Vi=ee({stack_:function(t,e=0){const n=te(t,"tensors","stack");if(l(n.length>=1,()=>"Pass at least one tensor to tf.stack"),1===n.length)return Fr(n[0],e);const s=n[0].rank,r=n[0].shape,a=n[0].dtype;l(e<=s,()=>"Axis must be <= rank of the tensor"),n.forEach(t=>{u(r,t.shape,"All tensors passed to stack must have matching shapes"),l(a===t.dtype,()=>"All tensors passed to stack must have matching dtypes")});const i=n.map(t=>Fr(t,e));return Hs(i,e)}});const Ui=ee({step_:function(t,e=0){const n=Qt(t,"x","step"),s={x:n},r={alpha:e};return Ht.runKernelFunc(t=>t.step(n,e),s,null,"Step",r)}});const Gi=ee({stridedSlice_:function(t,e,n,s,r=0,a=0,i=0,o=0,l=0){let u=Qt(t,"x","stridedSlice");const c={x:u},h={begin:e,end:n,strides:s,beginMask:r,endMask:a,ellipsisMask:i,newAxisMask:o,shrinkAxisMask:l};return Ht.runKernelFunc(t=>{null==s&&(s=new Array(e.length));const c=In(i);if(c.length>1)throw new Error("Multiple ellipses in slice is not allowed.");if(0!==i&&0!==o)throw new Error("Using both ellipsisMask and newAxisMask is not yet supported.");if(0!==i&&0!==l)throw new Error("Using both ellipsisMask and shrinkAxisMask is not yet supported.");const h=u.rank-e.length,p=In(o),d=u.shape.slice();p.forEach(t=>{e[t]=0,n[t]=1,d.splice(t,0,1)}),u=on(u,d);const{begin:f,end:m,strides:g}=$n(u.shape,c,h,e,n,s,r,a,i);e=f,n=m,s=g;const y=In(l);y.forEach(t=>{n[t]=e[t]+1,s[t]=1});const b=Cn(e,n,s),x=b.filter((t,e)=>-1===y.indexOf(e));if(s.every(t=>1===t))return on(qs(u,e,b),x);const w=t.stridedSlice(u,e,n,s);return on(w,x)},c,null,"StridedSlice",h)}});const Hi=ee({tan_:function(t){const e=Qt(t,"x","tan"),n={x:e};return Ht.runKernelFunc((t,n)=>{const s=t.tan(e);return n([e]),s},n,null,tt)}});function ji(t,e,n){if(c(t),null!=e&&2!==e.length)throw new Error("tensor2d() requires shape to have two numbers");const s=Jt(t,n);if(2!==s.length&&1!==s.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return se(t,e,s,n)}function qi(t,e,n){if(c(t),null!=e&&4!==e.length)throw new Error("tensor4d() requires shape to have four numbers");const s=Jt(t,n);if(4!==s.length&&1!==s.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return se(t,e,s,n)}const Ki=ee({topk_:function(t,e=1,n=!0){const s=Qt(t,"x","topk");if(0===s.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const r=s.shape[s.shape.length-1];if(e>r)throw new Error(`'k' passed to topk() must be <= the last dimension (${r}) but got `+e);const a={x:s},i={k:e,sorted:n},[o,l]=Ht.runKernelFunc(t=>t.topk(s,e,n),a,null,"TopK",i);return{values:o,indices:l}}});const Xi=ee({truncatedNormal_:function(t,e=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error("Unsupported data type $ { dtype }");const a=new ri(e,n,s,!0,r),i=We(t,s);for(let t=0;t<i.values.length;t++)i.values[t]=a.nextValue();return i.toTensor()}});const Yi=ee({unique_:function(t,e=0){const n=Qt(t,"x","unique",null);l(n.rank>0,()=>"The input tensor must be at least 1D");const s={x:n},r={axis:e},[a,i]=Ht.runKernel("Unique",s,r);return{values:a,indices:i}}});const Ji=ee({unsortedSegmentSum_:function(t,e,n){const s=Qt(t,"x","unsortedSegmentSum"),r=Qt(e,"segmentIds","unsortedSegmentSum","int32");l(f(n),()=>"numSegments must be of dtype int");const a={x:s,segmentIds:r},i={numSegments:n};return Ht.runKernelFunc((t,e)=>{const a=t.unsortedSegmentSum(s,r,n);return e([r]),a},a,null,"UnsortedSegmentSum",i)}});const Zi=ee({unstack_:function(t,e=0){const n=Qt(t,"x","unstack");l(e>=-n.shape.length&&e<n.shape.length,()=>`Axis = ${e} is not in [-${n.shape.length}, ${n.shape.length})`),e<0&&(e+=n.shape.length);const s={value:n},r={axis:e};return Ht.runKernelFunc(t=>t.unstack(n,e),s,null,"Unpack",r)}});function Qi(t,e=!0,n,s){return Ht.makeVariable(t,e,n,s)}function to(t,e){const n=[];for(let t=0;t<e.length;t++)e[t]&&n.push(t);const s=We(t,"int32"),r=We([n.length,t.length],"int32");for(let e=0;e<n.length;e++){const a=s.indexToLoc(n[e]),i=e*t.length;r.values.set(a,i)}return r.toTensor()}const eo=async function(t){const e=Qt(t,"condition","whereAsync","bool"),n=await e.data(),s=to(e.shape,n);return t!==e&&e.dispose(),s};const no=async function(t,e,n){const s=Qt(t,"tensor","boolMask"),r=Qt(e,"mask","boolMask","bool"),a=null==n?0:n,i=r.rank,o=s.shape;l(i>0,()=>"mask cannot be scalar"),u(o.slice(a,a+i),r.shape,"mask's shape must match the first K dimensions of tensor's shape,");let c=1;for(let t=a;t<a+i;t++)c*=o[t];const h=o.slice(0,a).concat([c],o.slice(a+i)),p=on(s,h),d=on(r,[-1]),f=await eo(d),m=Wi(f,[1]),g=Ur(p,m,a);return t!==s&&s.dispose(),e!==r&&r.dispose(),m.dispose(),p.dispose(),d.dispose(),f.dispose(),g};const so=ee({equalStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","equalStrict"),s=Qt(e,"b","equalStrict");return u(n.shape,s.shape,"Error in equalStrict: "),Sr(n,s)}}),ro=ee({greaterEqualStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","greaterEqualStrict"),s=Qt(e,"b","greaterEqualStrict");return u(n.shape,s.shape,"Error in greaterEqualStrict: "),Hr(n,s)}}),ao=ee({greaterStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","greaterStrict"),s=Qt(e,"b","greaterStrict");return u(n.shape,s.shape,"Error in greaterStrict: "),Gr(n,s)}}),io=ee({lessEqualStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","lessEqualStrict"),s=Qt(e,"b","lessEqualStrict");return u(n.shape,s.shape,"Error in lessEqualStrict: "),ta(n,s)}}),oo=ee({lessStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","lessStrict"),s=Qt(e,"b","lessStrict");return u(n.shape,s.shape,"Error in lessStrict: "),Qr(n,s)}}),lo=ee({notEqualStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","notEqualStrict"),s=Qt(e,"b","notEqualStrict");return u(n.shape,s.shape,"Error in notEqualStrict: "),Fa(n,s)}});const uo=ee({addStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","addStrict"),s=Qt(e,"b","addStrict");return u(n.shape,s.shape,"Error in addStrict: "),ss(n,s)}}),co=ee({divStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","div"),s=Qt(e,"b","div");return u(n.shape,s.shape,"Error in divideStrict: "),as(n,s)}}),ho=ee({maximumStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","maximumStrict"),s=Qt(e,"b","maximumStrict");return u(n.shape,s.shape,"Error in maximumStrict: "),Yr(n,s)}}),po=ee({minimumStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","minimumStrict"),s=Qt(e,"b","minimumStrict");return u(n.shape,s.shape,"Error in minimumStrict: "),Ta(n,s)}}),fo=ee({modStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","modStrict"),s=Qt(e,"b","modStrict");return u(n.shape,s.shape,"Error in modStrict: "),$a(n,s)}}),mo=ee({mulStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","mul"),s=Qt(e,"b","mul");return u(n.shape,s.shape,"Error in multiplyStrict: "),is(n,s)}}),go=ee({powStrict_:function(t,e){return Kn("strict variants of ops have been deprecated and will be removed in future"),u(t.shape,e.shape,"Error in powStrict: "),Ha(t,e)}}),yo=ee({squaredDifferenceStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","squaredDifferenceStrict"),s=Qt(e,"b","squaredDifferenceStrict");return u(n.shape,s.shape,"Error in squaredDifferenceStrict: "),Pi(n,s)}}),bo=ee({subStrict_:function(t,e){Kn("strict variants of ops have been deprecated and will be removed in future");const n=Qt(t,"a","subStrict"),s=Qt(e,"b","subStrict");return u(n.shape,s.shape,"Error in subStrict: "),pa(n,s)}});const xo=ee({norm_:function(t,e="euclidean",n=null,s=!1){const r=function t(e,n,s=null){if(0===e.rank)return os(e);if(1!==e.rank&&null===s)return t(on(e,[-1]),n,s);if(1===e.rank||"number"==typeof s||Array.isArray(s)&&1===s.length){if(1===n)return da(os(e),s);if(n===1/0)return ha(os(e),s);if(n===-1/0)return Sa(os(e),s);if("euclidean"===n||2===n)return Bi(da(Ha(os(e),Jr(2,"int32")),s));throw new Error("Error in norm: invalid ord value: "+n)}if(Array.isArray(s)&&2===s.length){if(1===n)return ha(da(os(e),s[0]),s[1]-1);if(n===1/0)return ha(da(os(e),s[1]),s[0]);if(n===-1/0)return Sa(da(os(e),s[1]),s[0]);if("fro"===n||"euclidean"===n)return Bi(da(Aa(e),s));throw new Error("Error in norm: invalid ord value: "+n)}throw new Error("Error in norm: invalid axis: "+s)}(t=Qt(t,"x","norm"),e,n);let a=r.shape;if(s){const e=x(n,t.shape);a=fs(r.shape,e)}return on(r,a)}});const wo=ee({movingAverage_:function(t,e,n,s,r=!0){const a=Qt(t,"v","movingAverage"),i=Qt(e,"x","movingAverage"),o=Qt(n,"decay","movingAverage");zt(a,i),l(d(a.shape,i.shape),()=>"Shape mismatch in v and x");const u=Jr(1),c=pa(u,o);let h=is(pa(i,a),c);if(r){l(null!=s,()=>"When using zeroDebias: true, step is required.");const t=Qt(s,"step","movingAverage");h=as(h,pa(u,Ha(o,t)))}return ss(a,h)}});const vo=ee({scatterND_:function(t,e,n){const s=Qt(t,"indices","scatterND","int32"),r=Qt(e,"updates","scatterND");wn(r,s,n);const a={indices:s,updates:r},i={shape:n};return Ht.runKernelFunc(t=>t.scatterND(s,r,n),a,null,"ScatterNd",i)}});const ko=ee({sparseToDense_:function(t,e,n,s=0){const r=Qt(t,"sparseIndices","sparseToDense","int32"),a=Qt(e,"sparseValues","sparseToDense"),i=Qt(s,"defaultValue","sparseToDense",a.dtype);!function(t,e,n,s){if("int32"!==t.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${t.shape}.`);const r=t.rank>0?t.shape[0]:1,a=t.rank>1?t.shape[1]:1;if(n.length!==a)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${a}.`);const i=e.size;if(0!==e.rank&&(1!==e.rank||i!==r))throw new Error(`sparseValues has incorrect shape ${e.shape}, should be [] or [${r}]`);if(e.dtype!==s.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(r,a,n,i);const o={sparseIndices:r,sparseValues:a,defaultValue:i},l={outputShape:n};return Ht.runKernelFunc(t=>t.sparseToDense(r,a,n,i),o,null,"SparseToDense",l)}});const No=ee({gatherND_:function(t,e){const n=Qt(e,"indices","gatherND","int32"),s=Qt(t,"x","gatherND"),r={params:s,indices:n};return Ht.runKernelFunc(t=>t.gatherND(s,n),r,null,"GatherNd")}});const Io=ee({dropout_:function(t,e,n,s){const r=Qt(t,"x","dropout");if(l("float32"===r.dtype,()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${r.dtype} tensor instead.`),l(e>=0&&e<1,()=>`rate must be a float in the range [0, 1), but got ${e}.`),0===e)return t instanceof Tt?r.clone():r;const a=function(t,e){if(null==e)return t.shape.slice();if(d(t.shape,e))return e;if(t.shape.length===e.length){const n=[];for(let s=0;s<t.shape.length;s++)null==e[s]&&null!=t.shape[s]?n.push(t.shape[s]):n.push(e[s]);return n}return e}(r,n),i=1-e,o=as(Br(ss(ui(a,0,1,"float32",s),i)),i);return is(r,o)}});function Co(t){return Math.floor(Math.pow(2,Math.ceil(Math.log(t)/Math.log(2))))}function So(t,e,n){const s=1-t%2,r=new Float32Array(t);for(let a=0;a<t;++a){const i=2*Math.PI*a/(t+s-1);r[a]=e-n*Math.cos(i)}return ci(r,"float32")}const To=async function(t,e,n=1){const s=Qt(t,"predictions","inTopK"),r=Qt(e,"targets","inTopK");l(s.rank>1,()=>"inTopK() expects the predictions to be of rank 2 or higher, but got "+s.rank),l(s.rank-1===r.rank,()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${s.rank} and targets rank ${r.rank}`),u(s.shape.slice(0,s.shape.length-1),r.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const a=s.shape[s.shape.length-1];l(n>0&&n<=a,()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${a}), but got ${n}`);const i=await s.data(),o=await r.data(),[c,h]=[i.length/a,a],p=v("bool",c);for(let t=0;t<c;t++){const e=t*h,s=i.subarray(e,e+h),r=[];for(let t=0;t<s.length;t++)r.push({value:s[t],index:t});r.sort((t,e)=>e.value-t.value),p[t]=0;for(let e=0;e<n;e++)if(r[e].index===o[t]){p[t]=1;break}}return t!==s&&s.dispose(),e!==r&&r.dispose(),re(p,r.shape,"bool")};const Eo=ee({conv2DBackpropFilter_:function(t,e,n,s,r,a="NHWC",i){let o=t;3===t.rank&&(o=on(t,[1,t.shape[0],t.shape[1],t.shape[2]]));let u=e;3===u.rank&&(u=on(e,[1,e.shape[0],e.shape[1],e.shape[2]])),l(4===o.rank,()=>"Error in conv2dDerFilter: input must be rank 4, but got shape "+o.shape+"."),l(4===u.rank,()=>"Error in conv2dDerFilter: dy must be rank 4, but got shape "+u.shape+"."),l(4===n.length,()=>"Error in conv2dDerFilter: filterShape must be length 4, but got "+n+".");const c="NHWC"===a?o.shape[3]:o.shape[1],h="NHWC"===a?u.shape[3]:u.shape[1];l(c===n[2],()=>`Error in conv2dDerFilter: depth of input ${c}) must match input depth in filter (${n[2]}.`),l(h===n[3],()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`),null!=i&&l(f(r),()=>`Error in conv2dDerFilter: pad must be an integer when using, dimRoundingMode ${i} but got pad ${r}.`);const p={x:o,dy:u},d={strides:s,pad:r,dataFormat:a,dimRoundingMode:i,filterShape:n};return Ht.runKernelFunc(t=>{const e=Ps(a),l=Rs(o.shape,n,s,1,r,i,!1,e);return t.conv2dDerFilter(o,u,l)},p,null,"Conv2DBackpropFilter",d)}});function $o(t,e,n){if(null==n||"linear"===n)return t;if("relu"===n)return is(t,Ui(e));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function Ao(t,e){let n=e;const s=Ir(t.shape,e.shape);return s.length>0&&(n=da(n,s)),on(n,t.shape)}function Ro(t,e,n){if("linear"===e)return t;if("relu"===e)return di(t);if("elu"===e)return Rr(t);if("relu6"===e)return fi(t);if("prelu"===e)return ja(t,n);throw new Error(`Unknown fused activation ${e}.`)}const Do=(t,e)=>!(t>0)||"linear"===e;const _o=ee({fusedConv2d_:function({x:t,filter:e,strides:n,pad:s,dataFormat:r="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:o,activation:u="linear",preluActivationWeights:c}){if(u=u||"linear",!1===Do(Ht.state.gradientDepth,u)){let l=ur(t,e,n,s,r,a,i);return null!=o&&(l=ss(l,o)),Ro(l,u,c)}const h=Qt(t,"x","conv2d"),p=Qt(e,"filter","conv2d");let d=h,m=!1;3===h.rank&&(m=!0,d=on(h,[1,h.shape[0],h.shape[1],h.shape[2]])),l(4===d.rank,()=>"Error in fused conv2d: input must be rank 4, but got rank "+d.rank+"."),l(4===p.rank,()=>"Error in fused conv2d: filter must be rank 4, but got rank "+p.rank+"."),null!=i&&l(f(s),()=>`Error in fused conv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`),l(d.shape[3]===p.shape[2],()=>`Error in conv2d: depth of input (${d.shape[3]}) must match input depth for filter ${p.shape[2]}.`),l(Bs(n,a),()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`),l("NHWC"===r,()=>`Error in conv2d: got dataFormat of ${r} but only NHWC is currently supported.`);const g=Rs(d.shape,p.shape,n,a,s,i);let y,b;null!=o&&(y=Qt(o,"bias","fused conv2d"),[y]=Lt(y,h),Cr(g.outShape,y.shape)),null!=c&&(b=Qt(c,"prelu weights","fused conv2d"));const x=(t,e)=>{const[r,i,o,c]=e,h=$o(t,o,u);l(zs(a),()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`);const p=[hr(i.shape,h,r,n,s),Eo(i,h,r.shape,n,s)];if(null!=c){const t=Ao(c,h);p.push(t)}return p},w=t=>t.fusedConv2d({input:d,filter:p,convInfo:g,bias:y,activation:u,preluActivationWeights:b}),v={x:d,filter:p,bias:y,preluActivationWeights:b},k={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i,activation:u};if(null==o){return ia((t,e,n)=>{let s=Ht.runKernelFunc(w,v,null,"FusedConv2D",k);return n([e,t,s]),m&&(s=on(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:x}})(d,p)}return ia((t,e,n,s)=>{let r=Ht.runKernelFunc(w,v,null,"FusedConv2D",k);return s([e,t,r,n]),m&&(r=on(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:x}})(d,p,y)}});const Fo=ee({depthwiseConv2dNativeBackpropFilter_:function(t,e,n,s,r,a=[1,1],i){let o=t;3===t.rank&&(o=on(t,[1,t.shape[0],t.shape[1],t.shape[2]]));let l=e;3===l.rank&&(l=on(e,[1,e.shape[0],e.shape[1],e.shape[2]]));const u={x:o,dy:l},c={strides:s,pad:r,dimRoundingMode:i,dilations:a,filterShape:n};return Ht.runKernelFunc(e=>{const u=Rs(t.shape,n,s,a,r,i,!0);return e.depthwiseConv2DDerFilter(o,l,u)},u,null,"DepthwiseConv2dNativeBackpropFilter",c)}});const Oo=ee({depthwiseConv2dNativeBackpropInput_:function(t,e,n,s,r,a=[1,1],i){let o=e,l=!1;3===e.rank&&(l=!0,o=on(e,[1,e.shape[0],e.shape[1],e.shape[2]]));const u={dy:o,filter:n},c={strides:s,pad:r,dimRoundingMode:i,dilations:a,inputShape:t},h=Ht.runKernelFunc(e=>{const l=Rs(t,n.shape,s,a,r,i,!0);return e.depthwiseConv2DDerInput(o,n,l)},u,null,"DepthwiseConv2dNativeBackpropInput",c);return l?on(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Mo=ee({fusedDepthwiseConv2d_:function({x:t,filter:e,strides:n,pad:s,dataFormat:r="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:o,activation:u="linear",preluActivationWeights:c}){if(!1===Do(Ht.state.gradientDepth,u)){let l=wr(t,e,n,s,r,a,i);return null!=o&&(l=ss(l,o)),Ro(l,u,c)}const h=Qt(t,"x","depthwiseConv2d"),p=Qt(e,"filter","depthwiseConv2d");let d=h,m=!1;3===h.rank&&(m=!0,d=on(h,[1,h.shape[0],h.shape[1],h.shape[2]])),l(4===d.rank,()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${d.rank}.`),l(4===p.rank,()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${p.rank}.`),l(d.shape[3]===p.shape[2],()=>`Error in fused depthwiseConv2d: number of input channels (${d.shape[3]}) must match the inChannels dimension in filter ${p.shape[2]}.`),null==a&&(a=[1,1]),l(Bs(n,a),()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`),null!=i&&l(f(s),()=>`Error in fused depthwiseConv2d: pad must be an integer when using dimRoundingMode ${i} but got pad ${s}.`);const g=Rs(d.shape,p.shape,n,a,s,i,!0);let y,b;null!=o&&(y=Qt(o,"bias","fused conv2d"),[y]=Lt(y,h),Cr(g.outShape,y.shape)),null!=c&&(b=Qt(c,"prelu weights","fused depthwiseConv2d"));const x=(t,e)=>{l(zs(a),()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${a}'`);const[r,o,c,h]=e,p=$o(t,c,u),d=Oo(o.shape,p,r,n,s,a,i),f=Fo(o,p,r.shape,n,s,a,i);if(null!=h){return[d,f,Ao(y,p)]}return[d,f]},w=t=>t.fusedDepthwiseConv2D({input:d,filter:p,convInfo:g,bias:y,activation:u,preluActivationWeights:b}),v={x:d,filter:p,bias:y,preluActivationWeights:b},k={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i,activation:u};if(null==o){return ia((t,e,n)=>{let s=Ht.runKernelFunc(w,v,null,"FusedDepthwiseConv2D",k);return n([e,t,s]),m&&(s=on(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:x}})(d,p)}return ia((t,e,n,s)=>{let r=Ht.runKernelFunc(w,v,null,"FusedDepthwiseConv2D",k);return s([e,t,r,n]),m&&(r=on(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:x}})(d,p,y)}});const Lo=ee({fusedMatMul_:function({a:t,b:e,transposeA:n=!1,transposeB:s=!1,bias:r,activation:a="linear",preluActivationWeights:i}){if(!1===Do(Ht.state.gradientDepth,a)){let o=ln(t,e,n,s);return null!=r&&(o=ss(o,r)),Ro(o,a,i)}let o=Qt(t,"a","fused matMul"),u=Qt(e,"b","fused matMul");[o,u]=Lt(o,u);const c=n?o.shape[o.rank-2]:o.shape[o.rank-1],h=s?u.shape[u.rank-1]:u.shape[u.rank-2],f=n?o.shape[o.rank-1]:o.shape[o.rank-2],m=s?u.shape[u.rank-2]:u.shape[u.rank-1],g=o.shape.slice(0,-2),y=u.shape.slice(0,-2),b=p(g),x=p(y);l(o.rank>=2&&u.rank>=2&&o.rank===u.rank,()=>`Error in fused matMul: inputs must have the same rank of at least 2, got ranks ${o.rank} and ${u.rank}.`),l(d(g,y),()=>`Error in fused matMul: outer dimensions (${g}) and (${y}) of Tensors with shapes ${o.shape} and `+u.shape+" must match."),l(c===h,()=>`Error in fused matMul: inner shapes (${c}) and (${h}) of Tensors with shapes ${o.shape} and ${u.shape} and transposeA=${n} and transposeB=${s} must match.`);const w=o.shape.slice(0,-2).concat([f,m]),v=on(o,n?[b,c,f]:[b,f,c]),k=on(u,s?[x,m,h]:[x,h,m]);let N,I;null!=r&&(N=Qt(r,"bias","fused matMul"),[N]=Lt(N,o),Cr(w,N.shape)),null!=i&&(I=Qt(i,"prelu weights","fused matMul"));const C=(t,e)=>{const[i,o,l,u]=e,c=$o(on(t,l.shape),l,a);let h,p;if(n||s?!n&&s?(h=ln(c,o,!1,!1),p=ln(c,i,!0,!1)):n&&!s?(h=ln(o,c,!1,!0),p=ln(i,c,!1,!1)):(h=ln(o,c,!0,!0),p=ln(c,i,!0,!0)):(h=ln(c,o,!1,!0),p=ln(i,c,!0,!1)),null!=r){return[h,p,Ao(u,c)]}return[h,p]},S=t=>t.fusedBatchMatMul({a:v,b:k,transposeA:n,transposeB:s,bias:N,activation:a,preluActivationWeights:I}),T={a:v,b:k,bias:N,preluActivationWeights:I},E={transposeA:n,transposeB:s,activation:a};if(null==r){return ia((t,e,n)=>{const s=Ht.runKernelFunc(S,T,null,"_FusedMatMul",E);return n([t,e,s]),{value:on(s,w),gradFunc:C}})(v,k)}return ia((t,e,n,s)=>{const r=Ht.runKernelFunc(S,T,null,"_FusedMatMul",E);return s([t,e,r,n]),{value:on(r,w),gradFunc:C}})(v,k,N)}});var zo=Object.freeze({__proto__:null,conv2d:_o,depthwiseConv2d:Mo,matMul:Lo});const Bo=ee({hammingWindow_:function(t){return So(t,.54,.46)}});const Po=ee({hannWindow_:function(t){return So(t,.5,.5)}});const Wo=ee({frame_:function(t,e,n,s=!1,r=0){let a=0;const i=[];for(;a+e<=t.size;)i.push(qs(t,a,e)),a+=n;if(s)for(;a<t.size;){const s=a+e-t.size,o=Hs([qs(t,a,e-s),zr([s],r)]);i.push(o),a+=n}return 0===i.length?ji([],[0,e]):on(Hs(i),[i.length,e])}});const Vo=ee({stft_:function(t,e,n,s,r=Po){null==s&&(s=Co(e));const a=Wo(t,e,n),i=is(a,r(e)),o=[];for(let t=0;t<a.shape[0];t++)o.push(zi(qs(i,[t,0],[1,e]),s));return Hs(o)}});const Uo=ee({cropAndResize_:function(t,e,n,s,r,a){const i=Qt(t,"image","cropAndResize"),o=Qt(e,"boxes","cropAndResize","float32"),u=Qt(n,"boxInd","cropAndResize","int32");r=r||"bilinear",a=a||0;const c=o.shape[0];l(4===i.rank,()=>`Error in cropAndResize: image must be rank 4,but got rank ${i.rank}.`),l(2===o.rank&&4===o.shape[1],()=>`Error in cropAndResize: boxes must be have size [${c},4] but had shape ${o.shape}.`),l(1===u.rank&&u.shape[0]===c,()=>`Error in cropAndResize: boxInd must be have size [${c}] but had shape ${o.shape}.`),l(2===s.length,()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${s.length}.`),l(s[0]>=1&&s[1]>=1,()=>"cropSize must be atleast [1,1], but was "+s),l("bilinear"===r||"nearest"===r,()=>"method must be bilinear or nearest, but was "+r);const h={image:i,boxes:o,boxInd:u},p={method:r,extrapolationValue:a,cropSize:s};return Ht.runKernelFunc(t=>t.cropAndResize(i,o,u,s,r,a),h,null,"CropAndResize",p)}});const Go=ee({flipLeftRight_:function(t){const e=Qt(t,"image","flipLeftRight","float32");l(4===e.rank,()=>`Error in flipLeftRight: image must be rank 4,but got rank ${e.rank}.`);const n={image:e};return Ht.runKernel("FlipLeftRight",n,{})}});const Ho=ee({rotateWithOffset_:function(t,e,n=0,s=.5){const r=Qt(t,"image","rotateWithOffset","float32");l(4===r.rank,()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${r.rank}.`);const a={image:r},i={radians:e,fillValue:n,center:s};return Ht.runKernel("RotateWithOffset",a,i)}});function jo(t,e,n,s,r,a){null==s&&(s=.5),null==r&&(r=Number.NEGATIVE_INFINITY),null==a&&(a=0);const i=t.shape[0];return n=Math.min(n,i),l(0<=s&&s<=1,()=>`iouThreshold must be in [0, 1], but was '${s}'`),l(2===t.rank,()=>`boxes must be a 2D tensor, but was of rank '${t.rank}'`),l(4===t.shape[1],()=>"boxes must have 4 columns, but 2nd dimension was "+t.shape[1]),l(1===e.rank,()=>"scores must be a 1D tensor"),l(e.shape[0]===i,()=>`scores has incompatible shape with boxes. Expected ${i}, but was `+e.shape[0]),l(0<=a&&a<=1,()=>`softNmsSigma must be in [0, 1], but was '${a}'`),{maxOutputSize:n,iouThreshold:s,scoreThreshold:r,softNmsSigma:a}}const qo=ee({nonMaxSuppression_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY){const a=Qt(t,"boxes","nonMaxSuppression"),i=Qt(e,"scores","nonMaxSuppression"),o=jo(a,i,n,s,r);n=o.maxOutputSize,s=o.iouThreshold,r=o.scoreThreshold;const l={maxOutputSize:n,iouThreshold:s,scoreThreshold:r};return Ht.runKernelFunc(t=>t.nonMaxSuppression(a,i,n,s,r),{boxes:a,scores:i},null,"NonMaxSuppressionV3",l)}});function Ko(t,e,n){const s=function(t,e,n){return function(t,e,n){let s=0,r=t.length,a=0,i=!1;for(;s<r;){a=s+(r-s>>>1);const o=n(e,t[a]);o>0?s=a+1:(r=a,i=!o)}return i?s:-s-1}(t,e,n||Xo)}(t,e,n),r=s<0?-(s+1):s;t.splice(r,0,e)}function Xo(t,e){return t>e?1:t<e?-1:0}function Yo(t,e,n,s,r){return Qo(t,e,n,s,r,0).selectedIndices}function Jo(t,e,n,s,r,a){return Qo(t,e,n,s,r,0,!1,a,!0)}function Zo(t,e,n,s,r,a){return Qo(t,e,n,s,r,a,!0)}function Qo(t,e,n,s,r,a,i=!1,o=!1,l=!1){const u=[];for(let t=0;t<e.length;t++)e[t]>r&&u.push({score:e[t],boxIndex:t,suppressBeginIndex:0});u.sort(nl);const c=a>0?-.5/a:0,h=[],p=[];for(;h.length<n&&u.length>0;){const e=u.pop(),{score:n,boxIndex:a,suppressBeginIndex:i}=e;if(n<r)break;let o=!1;for(let n=h.length-1;n>=i;--n){const i=tl(t,a,h[n]);if(i>=s){o=!0;break}if(e.score=e.score*el(s,c,i),e.score<=r)break}e.suppressBeginIndex=h.length,o||(e.score===n?(h.push(a),p.push(e.score)):e.score>r&&Ko(u,e,nl))}const d=h.length,f=n-d;o&&f>0&&(h.push(...new Array(f).fill(0)),p.push(...new Array(f).fill(0)));const m={selectedIndices:ci(h,"int32")};return i&&(m.selectedScores=ci(p,"float32")),l&&(m.validOutputs=Jr(d,"int32")),m}function tl(t,e,n){const s=t.subarray(4*e,4*e+4),r=t.subarray(4*n,4*n+4),a=Math.min(s[0],s[2]),i=Math.min(s[1],s[3]),o=Math.max(s[0],s[2]),l=Math.max(s[1],s[3]),u=Math.min(r[0],r[2]),c=Math.min(r[1],r[3]),h=Math.max(r[0],r[2]),p=Math.max(r[1],r[3]),d=(o-a)*(l-i),f=(h-u)*(p-c);if(d<=0||f<=0)return 0;const m=Math.max(a,u),g=Math.max(i,c),y=Math.min(o,h),b=Math.min(l,p),x=Math.max(y-m,0)*Math.max(b-g,0);return x/(d+f-x)}function el(t,e,n){const s=Math.exp(e*n*n);return n<=t?s:0}function nl(t,e){return t.score-e.score||t.score===e.score&&e.boxIndex-t.boxIndex}const sl=async function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY){const a=Qt(t,"boxes","nonMaxSuppressionAsync"),i=Qt(e,"scores","nonMaxSuppressionAsync"),o=jo(a,i,n,s,r);n=o.maxOutputSize,s=o.iouThreshold,r=o.scoreThreshold;const l=await Promise.all([a.data(),i.data()]),u=Yo(l[0],l[1],n,s,r);return a!==t&&a.dispose(),i!==e&&i.dispose(),u};const rl=ee({nonMaxSuppressionWithScore_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY,a=0){const i=Qt(t,"boxes","nonMaxSuppression"),o=Qt(e,"scores","nonMaxSuppression"),l=jo(i,o,n,s,r,a),u={boxes:i,scores:o},c={maxOutputSize:n=l.maxOutputSize,iouThreshold:s=l.iouThreshold,scoreThreshold:r=l.scoreThreshold,softNmsSigma:a=l.softNmsSigma},h=Ht.runKernel("NonMaxSuppressionV5",u,c);return{selectedIndices:h[0],selectedScores:h[1]}}});const al=async function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY,a=0){const i=Qt(t,"boxes","nonMaxSuppressionAsync"),o=Qt(e,"scores","nonMaxSuppressionAsync"),l=jo(i,o,n,s,r,a);n=l.maxOutputSize,s=l.iouThreshold,r=l.scoreThreshold,a=l.softNmsSigma;const u=await Promise.all([i.data(),o.data()]),c=Zo(u[0],u[1],n,s,r,a);return i!==t&&i.dispose(),o!==e&&o.dispose(),c};const il=ee({nonMaxSuppressionPadded_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY,a=!1){const i=Qt(t,"boxes","nonMaxSuppression"),o=Qt(e,"scores","nonMaxSuppression"),l=jo(i,o,n,s,r,null),u={boxes:i,scores:o},c={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:a},h=Ht.runKernel("NonMaxSuppressionV4",u,c);return{selectedIndices:h[0],validOutputs:h[1]}}});const ol=async function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY,a=!1){const i=Qt(t,"boxes","nonMaxSuppressionAsync"),o=Qt(e,"scores","nonMaxSuppressionAsync"),l=jo(i,o,n,s,r,null),u=l.maxOutputSize,c=l.iouThreshold,h=l.scoreThreshold,[p,d]=await Promise.all([i.data(),o.data()]),f=Jo(p,d,u,c,h,a);return i!==t&&i.dispose(),o!==e&&o.dispose(),f};const ll=ee({resizeBilinear_:function(t,e,n=!1){const s=Qt(t,"images","resizeBilinear");l(3===s.rank||4===s.rank,()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${s.rank}.`),l(2===e.length,()=>"Error in resizeBilinear: new shape must 2D, but got shape "+e+".");let r=s,a=!1;3===s.rank&&(a=!0,r=on(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const[i,o]=e,u={images:r},c={alignCorners:n,size:e},h=Ht.runKernelFunc((t,e)=>(e([r]),t.resizeBilinear(r,i,o,n)),u,null,"ResizeBilinear",c);return a?on(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const ul=ee({resizeNearestNeighbor_:function(t,e,n=!1){const s=Qt(t,"images","resizeNearestNeighbor");l(3===s.rank||4===s.rank,()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${s.rank}.`),l(2===e.length,()=>"Error in resizeNearestNeighbor: new shape must 2D, but got shape "+e+"."),l("float32"===s.dtype||"int32"===s.dtype,()=>"`images` must have `int32` or `float32` as dtype");let r=s,a=!1;3===s.rank&&(a=!0,r=on(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const[i,o]=e,u={images:r},c={alignCorners:n,size:e},h=Ht.runKernelFunc((t,e)=>(e([r]),t.resizeNearestNeighbor(r,i,o,n)),u,null,"ResizeNearestNeighbor",c);return a?on(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const cl=ee({bandPart_:function(t,e,n){l(e%1==0,()=>`bandPart(): numLower must be an integer, got ${e}.`),l(n%1==0,()=>`bandPart(): numUpper must be an integer, got ${n}.`);const s=Qt(t,"a","bandPart");l(s.rank>=2,()=>`bandPart(): Rank must be at least 2, got ${s.rank}.`);const r=s.shape,[a,i]=s.shape.slice(-2);if(!(e<=a))throw new Error(`bandPart(): numLower (${e}) must not be greater than the number of rows (${a}).`);if(!(n<=i))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${i}).`);e<0&&(e=a),n<0&&(n=i);const o=on(hi(0,a,1,"int32"),[-1,1]),u=hi(0,i,1,"int32"),c=pa(o,u),h=ga(ta(c,Jr(+e,"int32")),Hr(c,Jr(-n,"int32"))),p=Na([a,i],s.dtype);return on(Vi(Zi(on(s,[-1,a,i])).map(t=>Tr(h,t,p))),r)}});const hl=ee({gramSchmidt_:function(t){let e;if(Array.isArray(t)){e=!1,l(null!=t&&t.length>0,()=>"Gram-Schmidt process: input must not be null, undefined, or empty");const n=t[0].shape[0];for(let e=1;e<t.length;++e)l(t[e].shape[0]===n,()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${t[e].shape[0]} vs. ${n})`)}else e=!0,t=Li(t,t.shape[0],0).map(t=>Wi(t,[0]));l(t.length<=t[0].shape[0],()=>`Gram-Schmidt: Number of vectors (${t.length}) exceeds number of dimensions (${t[0].shape[0]}).`);const n=[],s=t;for(let e=0;e<t.length;++e)n.push(Ht.tidy(()=>{let t=s[e];if(e>0)for(let s=0;s<e;++s){const e=is(da(is(n[s],t)),n[s]);t=pa(t,e)}return as(t,xo(t,"euclidean"))}));return e?Vi(n,0):n}});function pl(t,e=!1){return Ht.tidy(()=>{l(2===t.shape.length,()=>`qr2d() requires a 2D Tensor, but got a ${t.shape.length}D Tensor.`);const n=t.shape[0],s=t.shape[1];let r=Lr(n),a=Ue(t);const i=ji([[1]],[1,1]);let o=Ue(i);const u=n>=s?s:n;for(let t=0;t<u;++t){const e=a,l=o,u=r;[o,a,r]=Ht.tidy(()=>{const e=qs(a,[t,t],[n-t,1]),l=xo(e),u=qs(a,[t,t],[1,1]),c=Tr(Gr(u,0),ji([[-1]]),ji([[1]])),h=pa(u,is(c,l)),p=as(e,h);o=1===p.shape[0]?Ue(i):Hs([i,qs(p,[1,0],[p.shape[0]-1,p.shape[1]])],0);const d=la(as(ln(c,h),l)),f=qs(a,[t,0],[n-t,s]),m=is(d,o),g=cn(o);if(0===t)a=pa(f,ln(m,ln(g,f)));else{const e=pa(f,ln(m,ln(g,f)));a=Hs([qs(a,[0,0],[t,s]),e],0)}const y=cn(m),b=qs(r,[0,t],[n,r.shape[1]-t]);if(0===t)r=pa(b,ln(ln(b,o),y));else{const e=pa(b,ln(ln(b,o),y));r=Hs([qs(r,[0,0],[n,t]),e],1)}return[o,a,r]}),Zn([e,l,u])}return!e&&n>s&&(r=qs(r,[0,0],[n,s]),a=qs(a,[0,0],[s,s])),[r,a]})}const dl=ee({qr_:function(t,e=!1){if(l(t.rank>=2,()=>"qr() requires input tensor to have a rank >= 2, but got rank "+t.rank),2===t.rank)return pl(t,e);{const n=t.shape.slice(0,t.shape.length-2).reduce((t,e)=>t*e),s=Zi(on(t,[n,t.shape[t.shape.length-2],t.shape[t.shape.length-1]]),0),r=[],a=[];return s.forEach(t=>{const[n,s]=pl(t,e);r.push(n),a.push(s)}),[on(Vi(r,0),t.shape),on(Vi(a,0),t.shape)]}}});var fl;(fl=t.Reduction||(t.Reduction={}))[fl.NONE=0]="NONE",fl[fl.MEAN=1]="MEAN",fl[fl.SUM=2]="SUM",fl[fl.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS";const ml=ee({computeWeightedLoss_:function(e,n,s=t.Reduction.SUM_BY_NONZERO_WEIGHTS){const r=Qt(e,"losses","computeWeightedLoss");let a=null;null!=n&&(a=Qt(n,"weights","computeWeightedLoss"));const i=null==a?r:is(r,a);if(s===t.Reduction.NONE)return i;if(s===t.Reduction.SUM)return da(i);if(s===t.Reduction.MEAN){if(null==a)return Ca(i);{const t=r.size/a.size,e=as(da(i),da(a));return t>1?as(e,Jr(t)):e}}if(s===t.Reduction.SUM_BY_NONZERO_WEIGHTS){if(null==a)return as(da(i),Jr(r.size));{const t=is(a,Ia(r.shape)),e=Ve(da(Fa(t,Jr(0))),"float32");return as(da(i),e)}}throw Error("Unknown reduction: "+s)}});const gl=ee({absoluteDifference_:function(e,n,s,r=t.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=Qt(e,"labels","absoluteDifference"),i=Qt(n,"predictions","absoluteDifference");let o=null;null!=s&&(o=Qt(s,"weights","absoluteDifference")),u(a.shape,i.shape,"Error in absoluteDifference: ");const l=os(pa(a,i));return ml(l,o,r)}});const yl=ee({cosineDistance_:function(e,n,s,r,a=t.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=Qt(e,"labels","cosineDistance"),o=Qt(n,"predictions","cosineDistance");let l=null;null!=r&&(l=Qt(r,"weights","cosineDistance")),u(i.shape,o.shape,"Error in cosineDistance: ");const c=Jr(1),h=pa(c,da(is(i,o),s,!0));return ml(h,l,a)}});const bl=ee({hingeLoss_:function(e,n,s,r=t.Reduction.SUM_BY_NONZERO_WEIGHTS){let a=Qt(e,"labels","hingeLoss");const i=Qt(n,"predictions","hingeLoss");let o=null;null!=s&&(o=Qt(s,"weights","hingeLoss")),u(a.shape,i.shape,"Error in hingeLoss: ");const l=Jr(1);a=pa(is(Jr(2),a),l);const c=di(pa(l,is(a,i)));return ml(c,o,r)}});const xl=ee({huberLoss_:function(e,n,s,r=1,a=t.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=Qt(e,"labels","huberLoss"),o=Qt(n,"predictions","huberLoss");let l=null;null!=s&&(l=Qt(s,"weights","huberLoss")),u(i.shape,o.shape,"Error in huberLoss: ");const c=Jr(r),h=os(pa(o,i)),p=Ta(h,c),d=pa(h,p),f=ss(is(Jr(.5),Aa(p)),is(c,d));return ml(f,l,a)}});const wl=ee({logLoss_:function(e,n,s,r=1e-7,a=t.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=Qt(e,"labels","logLoss"),o=Qt(n,"predictions","logLoss");let l=null;null!=s&&(l=Qt(s,"weights","logLoss")),u(i.shape,o.shape,"Error in logLoss: ");const c=Jr(1),h=Jr(r),p=la(is(i,sa(ss(o,h)))),d=is(pa(c,i),sa(ss(pa(c,o),h))),f=pa(p,d);return ml(f,l,a)}});const vl=ee({meanSquaredError_:function(e,n,s,r=t.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=Qt(e,"labels","meanSquaredError"),i=Qt(n,"predictions","meanSquaredError");let o=null;null!=s&&(o=Qt(s,"weights","meanSquaredError")),u(a.shape,i.shape,"Error in meanSquaredError: ");const l=Pi(a,i);return ml(l,o,r)}});const kl=ee({sigmoidCrossEntropy_:function(e,n,s,r=0,a=t.Reduction.SUM_BY_NONZERO_WEIGHTS){let i=Qt(e,"multiClassLabels","sigmoidCrossEntropy");const o=Qt(n,"logits","sigmoidCrossEntropy");let l=null;if(null!=s&&(l=Qt(s,"weights","sigmoidCrossEntropy")),u(i.shape,o.shape,"Error in sigmoidCrossEntropy: "),r>0){const t=Jr(r),e=Jr(1),n=Jr(.5);i=ss(is(i,pa(e,t)),is(n,t))}const c=function(t,e){const n=Qt(t,"labels","sigmoidCrossEntropyWithLogits"),s=Qt(e,"logits","sigmoidCrossEntropyWithLogits");u(n.shape,s.shape,"Error in sigmoidCrossEntropyWithLogits: ");const r=di(s),a=is(s,n),i=ra(_r(la(os(s))));return ss(pa(r,a),i)}(i,o);return ml(c,l,a)}});const Nl=ee({softmaxCrossEntropy_:function(e,n,s,r=0,a=t.Reduction.SUM_BY_NONZERO_WEIGHTS){let i=Qt(e,"onehotLabels","softmaxCrossEntropy");const o=Qt(n,"logits","softmaxCrossEntropy");let l=null;if(null!=s&&(l=Qt(s,"weights","softmaxCrossEntropy")),u(i.shape,o.shape,"Error in softmaxCrossEntropy: "),r>0){const t=Jr(r),e=Jr(1),n=Jr(i.shape[1]);i=ss(is(i,pa(e,t)),as(t,n))}const c=function(t,e,n=-1){if(-1===n&&(n=e.rank-1),n!==e.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${e.rank} and dim was `+n);return ia((t,e,s)=>{const r=ma(e,[n],!0),a=pa(Ve(e,"float32"),r);s([t,a]);const i=la(is(a,t));return{value:da(i,[n]),gradFunc:(t,e)=>{const[s,r]=e,a=fs(t.shape,[n]);return[is(on(t,a),pa(Ve(s,"float32"),_r(r))),is(on(t,a),pa(_r(r),Ve(s,"float32")))]}}})(t,e)}(i,o);return ml(c,l,a)}}),Il={fft:_i,ifft:Fi,rfft:zi,irfft:Oi},Cl={hammingWindow:Bo,hannWindow:Po,frame:Wo,stft:Vo},Sl={flipLeftRight:Go,resizeNearestNeighbor:ul,resizeBilinear:ll,rotateWithOffset:Ho,cropAndResize:Uo,nonMaxSuppression:qo,nonMaxSuppressionAsync:sl,nonMaxSuppressionWithScore:rl,nonMaxSuppressionWithScoreAsync:al,nonMaxSuppressionPadded:il,nonMaxSuppressionPaddedAsync:ol},Tl={bandPart:cl,gramSchmidt:hl,qr:dl},El={absoluteDifference:gl,computeWeightedLoss:ml,cosineDistance:yl,hingeLoss:bl,huberLoss:xl,logLoss:wl,meanSquaredError:vl,sigmoidCrossEntropy:kl,softmaxCrossEntropy:Nl};class $l extends Bn{minimize(t,e=!1,n){const{value:s,grads:r}=this.computeGradients(t,n);if(null!=n){const t=n.map(t=>({name:t.name,tensor:r[t.name]}));this.applyGradients(t)}else this.applyGradients(r);return Zn(r),e?s:(s.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(t,e){return aa(t,e)}dispose(){null!=this.iterations_&&Zn(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:Jr(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(t){throw new Error("setWeights() is not implemented for this optimizer class "+this.getClassName())}async extractIterations(t){return this.iterations_=(await t[0].tensor.data())[0],t.slice(1)}}Object.defineProperty($l,Symbol.hasInstance,{value:t=>null!=t.minimize&&null!=t.computeGradients&&null!=t.applyGradients});class Al extends $l{constructor(t,e,n=null){super(),this.learningRate=t,this.rho=e,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=Ht.backend.epsilon())}applyGradients(t){(Array.isArray(t)?t.map(t=>t.name):Object.keys(t)).forEach((e,n)=>{const s=Ht.registeredVariables[e];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:e+"/accum_grad",variable:Jn(()=>Er(s).variable(!1))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:e+"/accum_var",variable:Jn(()=>Er(s).variable(!1))});const r=Array.isArray(t)?t[n].tensor:t[e];if(null==r)return;const a=this.accumulatedGrads[n].variable,i=this.accumulatedUpdates[n].variable;Jn(()=>{const t=ss(is(a,this.rho),is(Aa(r),1-this.rho)),e=is(as(Bi(ss(i,this.epsilon)),Bi(ss(a,this.epsilon))),r),n=ss(is(i,this.rho),is(Aa(e),1-this.rho));a.assign(t),i.assign(n);const o=ss(is(e,-this.learningRate),s);s.assign(o)})}),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(Zn(this.accumulatedGrads.map(t=>t.variable)),Zn(this.accumulatedUpdates.map(t=>t.variable)))}async getWeights(){const t=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(t.map(t=>({name:t.originalName,tensor:t.variable})))}async setWeights(t){const e=(t=await this.extractIterations(t)).length/2;this.accumulatedGrads=t.slice(0,e).map(t=>({originalName:t.name,variable:t.tensor.variable(!1)})),this.accumulatedUpdates=t.slice(e,2*e).map(t=>({originalName:t.name,variable:t.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(t,e){return new t(e.learningRate,e.rho,e.epsilon)}}Al.className="Adadelta",Wn(Al);class Rl extends $l{constructor(t,e=.1){super(),this.learningRate=t,this.initialAccumulatorValue=e,this.accumulatedGrads=[]}applyGradients(t){(Array.isArray(t)?t.map(t=>t.name):Object.keys(t)).forEach((e,n)=>{const s=Ht.registeredVariables[e];if(null==this.accumulatedGrads[n]){const t=!1;this.accumulatedGrads[n]={originalName:e+"/accumulator",variable:Jn(()=>zr(s.shape,this.initialAccumulatorValue).variable(t))}}const r=Array.isArray(t)?t[n].tensor:t[e];if(null==r)return;const a=this.accumulatedGrads[n].variable;Jn(()=>{const t=ss(a,Aa(r));a.assign(t);const e=ss(is(as(r,Bi(ss(t,Ht.backend.epsilon()))),-this.learningRate),s);s.assign(e)})}),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&Zn(this.accumulatedGrads.map(t=>t.variable))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map(t=>({name:t.originalName,tensor:t.variable})))}async setWeights(t){t=await this.extractIterations(t);this.accumulatedGrads=t.map(t=>({originalName:t.name,variable:t.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(t,e){return new t(e.learningRate,e.initialAccumulatorValue)}}Rl.className="Adagrad",Wn(Rl);class Dl extends $l{constructor(t,e,n,s=null){super(),this.learningRate=t,this.beta1=e,this.beta2=n,this.epsilon=s,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],Jn(()=>{this.accBeta1=Jr(e).variable(),this.accBeta2=Jr(n).variable()}),null==s&&(this.epsilon=Ht.backend.epsilon())}applyGradients(t){const e=Array.isArray(t)?t.map(t=>t.name):Object.keys(t);Jn(()=>{const n=pa(1,this.accBeta1),s=pa(1,this.accBeta2);e.forEach((e,r)=>{const a=Ht.registeredVariables[e];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:e+"/m",variable:Jn(()=>Er(a).variable(!1))}),null==this.accumulatedSecondMoment[r]&&(this.accumulatedSecondMoment[r]={originalName:e+"/v",variable:Jn(()=>Er(a).variable(!1))});const i=Array.isArray(t)?t[r].tensor:t[e];if(null==i)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedSecondMoment[r].variable,u=ss(is(o,this.beta1),is(i,1-this.beta1)),c=ss(is(l,this.beta2),is(Aa(i),1-this.beta2)),h=as(u,n),p=as(c,s);o.assign(u),l.assign(c);const d=ss(is(as(h,ss(Bi(p),this.epsilon)),-this.learningRate),a);a.assign(d)}),this.accBeta1.assign(is(this.accBeta1,this.beta1)),this.accBeta2.assign(is(this.accBeta2,this.beta2))}),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&Zn(this.accumulatedFirstMoment.map(t=>t.variable)),null!=this.accumulatedSecondMoment&&Zn(this.accumulatedSecondMoment.map(t=>t.variable))}async getWeights(){const t=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(t.map(t=>({name:t.originalName,tensor:t.variable})))}async setWeights(t){t=await this.extractIterations(t),Jn(()=>{this.accBeta1.assign(Ha(this.beta1,this.iterations_+1)),this.accBeta2.assign(Ha(this.beta2,this.iterations_+1))});const e=t.length/2;this.accumulatedFirstMoment=t.slice(0,e).map(t=>({originalName:t.name,variable:t.tensor.variable(!1)})),this.accumulatedSecondMoment=t.slice(e,2*e).map(t=>({originalName:t.name,variable:t.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(t,e){return new t(e.learningRate,e.beta1,e.beta2,e.epsilon)}}Dl.className="Adam",Wn(Dl);class _l extends $l{constructor(t,e,n,s=null,r=0){super(),this.learningRate=t,this.beta1=e,this.beta2=n,this.epsilon=s,this.decay=r,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],Jn(()=>{this.iteration=Jr(0).variable(),this.accBeta1=Jr(e).variable()}),null==s&&(this.epsilon=Ht.backend.epsilon())}applyGradients(t){const e=Array.isArray(t)?t.map(t=>t.name):Object.keys(t);Jn(()=>{const n=pa(1,this.accBeta1),s=as(-this.learningRate,ss(is(this.iteration,this.decay),1));e.forEach((e,r)=>{const a=Ht.registeredVariables[e];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:e+"/m",variable:Er(a).variable(!1)}),null==this.accumulatedWeightedInfNorm[r]&&(this.accumulatedWeightedInfNorm[r]={originalName:e+"/v",variable:Er(a).variable(!1)});const i=Array.isArray(t)?t[r].tensor:t[e];if(null==i)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedWeightedInfNorm[r].variable,u=ss(is(o,this.beta1),is(i,1-this.beta1)),c=is(l,this.beta2),h=os(i),p=Yr(c,h);o.assign(u),l.assign(p);const d=ss(is(as(s,n),as(u,ss(p,this.epsilon))),a);a.assign(d)}),this.iteration.assign(ss(this.iteration,1)),this.accBeta1.assign(is(this.accBeta1,this.beta1))}),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&Zn(this.accumulatedFirstMoment.map(t=>t.variable)),null!=this.accumulatedWeightedInfNorm&&Zn(this.accumulatedWeightedInfNorm.map(t=>t.variable))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(t){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(t,e){return new t(e.learningRate,e.beta1,e.beta2,e.epsilon,e.decay)}}_l.className="Adamax",Wn(_l);class Fl extends $l{constructor(t){super(),this.learningRate=t,this.setLearningRate(t)}applyGradients(t){(Array.isArray(t)?t.map(t=>t.name):Object.keys(t)).forEach((e,n)=>{const s=Array.isArray(t)?t[n].tensor:t[e];if(null==s)return;const r=Ht.registeredVariables[e];Jn(()=>{const t=ss(is(this.c,s),r);r.assign(t)})}),this.incrementIterations()}setLearningRate(t){this.learningRate=t,null!=this.c&&this.c.dispose(),this.c=Qn(Jr(-t))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(t){if(0!==(t=await this.extractIterations(t)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(t,e){return new t(e.learningRate)}}Fl.className="SGD",Wn(Fl);class Ol extends Fl{constructor(t,e,n=!1){super(t),this.learningRate=t,this.momentum=e,this.useNesterov=n,this.accumulations=[],this.m=Jr(this.momentum)}applyGradients(t){(Array.isArray(t)?t.map(t=>t.name):Object.keys(t)).forEach((e,n)=>{const s=Ht.registeredVariables[e];if(null==this.accumulations[n]){const t=!1;this.accumulations[n]={originalName:e+"/momentum",variable:Jn(()=>Er(s).variable(t))}}const r=this.accumulations[n].variable,a=Array.isArray(t)?t[n].tensor:t[e];null!=a&&Jn(()=>{let t;const e=ss(is(this.m,r),a);t=this.useNesterov?ss(is(this.c,ss(a,is(e,this.m))),s):ss(is(this.c,e),s),r.assign(e),s.assign(t)})}),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&Zn(this.accumulations.map(t=>t.variable))}setMomentum(t){this.momentum=t}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map(t=>({name:t.originalName,tensor:t.variable})))}async setWeights(t){t=await this.extractIterations(t);this.accumulations=t.map(t=>({originalName:t.name,variable:t.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(t,e){return new t(e.learningRate,e.momentum,e.useNesterov)}}Ol.className="Momentum",Wn(Ol);class Ml extends $l{constructor(t,e=.9,n=0,s=null,r=!1){if(super(),this.learningRate=t,this.decay=e,this.momentum=n,this.epsilon=s,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=r,null==s&&(this.epsilon=Ht.backend.epsilon()),null==t)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(t){(Array.isArray(t)?t.map(t=>t.name):Object.keys(t)).forEach((e,n)=>{const s=Ht.registeredVariables[e];null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:e+"/rms",variable:Jn(()=>Er(s).variable(!1))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:e+"/momentum",variable:Jn(()=>Er(s).variable(!1))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:e+"/mg",variable:Jn(()=>Er(s).variable(!1))});const r=Array.isArray(t)?t[n].tensor:t[e];if(null==r)return;const a=this.accumulatedMeanSquares[n].variable,i=this.accumulatedMoments[n].variable;Jn(()=>{const t=ss(is(a,this.decay),is(Aa(r),1-this.decay));if(this.centered){const e=this.accumulatedMeanGrads[n].variable,o=ss(is(e,this.decay),is(r,1-this.decay)),l=as(is(r,this.learningRate),Bi(pa(t,ss(Aa(o),this.epsilon)))),u=ss(is(i,this.momentum),l);a.assign(t),e.assign(o),i.assign(u);const c=pa(s,u);s.assign(c)}else{const t=ss(is(a,this.decay),is(Aa(r),1-this.decay)),e=ss(is(i,this.momentum),as(is(r,this.learningRate),Bi(ss(t,this.epsilon))));a.assign(t),i.assign(e);const n=pa(s,e);s.assign(n)}})}),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&Zn(this.accumulatedMeanSquares.map(t=>t.variable)),null!=this.accumulatedMeanGrads&&this.centered&&Zn(this.accumulatedMeanGrads.map(t=>t.variable)),null!=this.accumulatedMoments&&Zn(this.accumulatedMoments.map(t=>t.variable))}async getWeights(){const t=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&t.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(t.map(t=>({name:t.originalName,tensor:t.variable})))}async setWeights(t){t=await this.extractIterations(t);const e=this.centered?t.length/3:t.length/2;this.accumulatedMeanSquares=t.slice(0,e).map(t=>({originalName:t.name,variable:t.tensor.variable(!1)})),this.accumulatedMoments=t.slice(e,2*e).map(t=>({originalName:t.name,variable:t.tensor.variable(!1)})),this.centered&&(this.accumulatedMeanGrads=t.slice(2*e,3*e).map(t=>({originalName:t.name,variable:t.tensor.variable(!1)})))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(t,e){return new t(e.learningRate,e.decay,e.momentum,e.epsilon,e.centered)}}Ml.className="RMSProp",Wn(Ml);class Ll{static sgd(t){return new Fl(t)}static momentum(t,e,n=!1){return new Ol(t,e,n)}static rmsprop(t,e=.9,n=0,s=null,r=!1){return new Ml(t,e,n,s,r)}static adam(t=.001,e=.9,n=.999,s=null){return new Dl(t,e,n,s)}static adadelta(t=.001,e=.95,n=null){return new Al(t,e,n)}static adamax(t=.002,e=.9,n=.999,s=null,r=0){return new _l(t,e,n,s,r)}static adagrad(t,e=.1){return new Rl(t,e)}}const zl={sgd:Ll.sgd,momentum:Ll.momentum,adadelta:Ll.adadelta,adagrad:Ll.adagrad,rmsprop:Ll.rmsprop,adamax:Ll.adamax,adam:Ll.adam},Bl="undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate?setImmediate:t=>t();function Pl(){return new Promise(t=>Bl(()=>t()))}function Wl(t,e,n){return[n*("number"==typeof t?t:t[0]),e*("number"==typeof t?t:t[1])]}function Vl(t,e,n,s=!0){let r=[];if(s)r=r.concat(e.slice(0)),r.push(t[0]/n),r=r.concat(t.slice(1));else{r=r.concat(t[0]);const n=e.length;for(let s=0;s<n;++s)r=r.concat([t[s+1]/e[s],e[s]]);r=r.concat(t.slice(n+1))}return r}function Ul(t,e,n=!0){const s=[];if(n){s.push(e);for(let n=e+1;n<t;++n)n<=2*e?(s.push(n),s.push(n-(e+1))):s.push(n)}else{const n=[],r=[];for(let s=1;s<t;++s)s>=2*e+1||s%2==1?r.push(s):n.push(s);s.push(...n),s.push(0),s.push(...r)}return s}function Gl(t,e,n,s=!0){const r=[];s?r.push(t[0]/n):r.push(t[0]*n);for(let n=1;n<t.length;++n)n<=e.length?s?r.push(e[n-1]*t[n]):r.push(t[n]/e[n-1]):r.push(t[n]);return r}function Hl(t,e){const n=[0];for(let s=0;s<e;++s)n.push(t[s][0]);return n}function jl(t,e,n){const s=t.slice(0,1);for(let r=0;r<n;++r)s.push(t[r+1]-e[r][0]-e[r][1]);return s}const ql=1.0507009873554805;function Kl(...t){H().getBool("IS_TEST")||console.warn(...t)}function Xl(t,e){if(t.length!==e.length)throw new Error(`Cannot merge real and imag arrays of different lengths. real:${t.length}, imag: ${e.length}.`);const n=new Float32Array(2*t.length);for(let s=0;s<n.length;s+=2)n[s]=t[s/2],n[s+1]=e[s/2];return n}function Yl(t){const e=new Float32Array(t.length/2),n=new Float32Array(t.length/2);for(let s=0;s<t.length;s+=2)e[s/2]=t[s],n[s/2]=t[s+1];return{real:e,imag:n}}function Jl(t){const e=Math.ceil(t.length/4),n=new Float32Array(e),s=new Float32Array(e);for(let e=0;e<t.length;e+=4)n[Math.floor(e/4)]=t[e],s[Math.floor(e/4)]=t[e+1];return{real:n,imag:s}}function Zl(t){const e=Math.floor(t.length/4),n=new Float32Array(e),s=new Float32Array(e);for(let e=2;e<t.length;e+=4)n[Math.floor(e/4)]=t[e],s[Math.floor(e/4)]=t[e+1];return{real:n,imag:s}}function Ql(t,e){return{real:t[2*e],imag:t[2*e+1]}}function tu(t,e,n,s){t[2*s]=e,t[2*s+1]=n}function eu(t,e){const n=new Float32Array(t/2),s=new Float32Array(t/2);for(let r=0;r<Math.ceil(t/2);r++){const a=(e?2:-2)*Math.PI*(r/t);n[r]=Math.cos(a),s[r]=Math.sin(a)}return{real:n,imag:s}}function nu(t,e,n){const s=(n?2:-2)*Math.PI*(t/e);return{real:Math.cos(s),imag:Math.sin(s)}}function su(t,e){return Ht.makeTensorFromDataId(t.dataId,e,t.dtype)}function ru(t,e,n){const s=(e-t)/(n-1),r=z(n,"float32");r[0]=t;for(let t=1;t<r.length;t++)r[t]=r[t-1]+s;return ci(r,"float32")}var au=Object.freeze({__proto__:null,slice_util:zn,segment_util:Vr,castTensor:function(t,e,n){if("complex64"===e){if("complex64"===t.dtype)return t.clone();const e=Na(t.shape),s=Ve(t,"float32"),r=n.complex(s,e);return e.dispose(),s.dispose(),r}if(!C(t.dtype,e))return Ht.makeTensorFromDataId(t.dataId,t.shape,e);if("complex64"===t.dtype){const s=n.real(t),r=Ve(s,e);return s.dispose(),r}if("int32"===e)return n.int(t);if("bool"===e){const e=Jr(0,t.dtype),s=n.notEqual(t,e);return e.dispose(),s}throw new Error(`Error in Cast: failed to cast ${t.dtype} to ${e}`)},reshapeTensor:su,linspaceImpl:ru,upcastType:Ot,axesAreInnerMostDims:hs,combineLocations:ps,computeOutAndReduceShapes:ds,expandShapeToKeepDim:fs,assertAxesAreInnerMostDims:ms,getAxesPermutation:gs,getUndoAxesPermutation:ys,getInnerMostAxes:bs,getBroadcastDims:Nr,getReductionAxes:Ir,assertAndGetBroadcastShape:Cr,assertParamsConsistent:Us,computeOutShape:Gs,computeDilation2DInfo:Es,computePool2DInfo:$s,computePool3DInfo:As,computeConv2DInfo:Rs,computeConv3DInfo:Ds,computeDefaultPad:_s,tupleValuesAreOne:zs,eitherStridesOrDilationsAreOne:Bs,convertConv2DDataFormat:Ps,getFusedDyActivation:$o,getFusedBiasGradient:Ao,applyActivation:Ro,shouldFuse:Do,PARALLELIZE_THRESHOLD:30,computeOptimalWindowSize:Pr,getImageCenter:Wl,getReshaped:Vl,getPermuted:Ul,getReshapedPermuted:Gl,getSliceBeginCoords:Hl,getSliceSize:jl,prepareAndValidate:yn,validateUpdateShape:xn,validateInput:wn,calculateShapes:vn,SELU_SCALEALPHA:1.7580993408473768,SELU_SCALE:ql,ERF_P:.3275911,ERF_A1:.254829592,ERF_A2:-.284496736,ERF_A3:1.421413741,ERF_A4:-1.453152027,ERF_A5:1.061405429,warn:Kl,log:function(...t){H().getBool("IS_TEST")||console.log(...t)},mergeRealAndImagArrays:Xl,splitRealAndImagArrays:Yl,complexWithEvenIndex:Jl,complexWithOddIndex:Zl,getComplexWithIndex:Ql,assignToTypedArray:tu,exponents:eu,exponent:nu,prepareSplitSize:Mi});function iu(t,e,n){const s=new Array(t.rank).fill(0),r=t.shape.slice();return e.map(e=>{const a=[...r];a[n]=e;const i=qs(t,s,a);return s[n]+=e,i})}function ou(t,e){const n=new Array(t.rank);for(let s=0;s<n.length;s++)n[s]=t.shape[s]*e[s];const s=We(n,t.dtype);for(let e=0;e<s.values.length;++e){const n=s.indexToLoc(e),r=new Array(t.rank);for(let e=0;e<r.length;e++)r[e]=n[e]%t.shape[e];const a=t.locToIndex(r);s.values[e]=t.values[a]}return s.toTensor()}function lu(t,e,n,s,r){const a=e[e.length-1],[i,o]=[t.length/a,a],l=v(n,i*s),u=v("int32",i*s);for(let e=0;e<i;e++){const n=e*o,r=t.subarray(n,n+o),a=[];for(let t=0;t<r.length;t++)a.push({value:r[t],index:t});a.sort((t,e)=>e.value-t.value);const i=e*s,c=l.subarray(i,i+s),h=u.subarray(i,i+s);for(let t=0;t<s;t++)c[t]=a[t].value,h[t]=a[t].index}const c=e.slice();return c[c.length-1]=s,[re(l,c,n),re(u,c,"int32")]}var uu=Object.freeze({__proto__:null,nonMaxSuppressionV3Impl:Yo,nonMaxSuppressionV4Impl:Jo,nonMaxSuppressionV5Impl:Zo,split:iu,tile:ou,topkImpl:lu,whereImpl:to});const cu={kernelName:"Abs",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>is(t,Ui(Ve(n,"float32"),-1))}}},hu={kernelName:"Acos",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Aa(Ve(n,"float32")),s=Bi(pa(Jr(1),e));return la(as(t,s))}}}},pu={kernelName:"Acosh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Bi(pa(Aa(Ve(n,"float32")),1));return as(t,e)}}}},du={kernelName:X,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Cr(n.shape,s.shape);return{a:()=>{let e=t;const s=Ir(n.shape,r);return s.length>0&&(e=da(e,s)),on(e,n.shape)},b:()=>{let e=t;const n=Ir(s.shape,r);return n.length>0&&(e=da(e,n)),on(e,s.shape)}}}},fu={kernelName:"AddN",saveAllInputs:!0,gradFunc:(t,e)=>{const n={};return e.forEach((e,s)=>{n[s]=()=>t.clone()}),n}},mu={kernelName:"ArgMax",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Er(n)}}},gu={kernelName:"ArgMin",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Er(n)}}},yu={kernelName:"Asin",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>as(t,Bi(pa(Jr(1),Aa(Ve(n,"float32")))))}}},bu={kernelName:"Asinh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Bi(ss(Jr(1),Aa(Ve(n,"float32"))));return as(t,e)}}}},xu={kernelName:"Atan2",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Cr(n.shape,s.shape);return{a:()=>{const e=ss(Aa(n),Aa(s));let a=is(t,as(s,e));const i=Ir(n.shape,r);return i.length>0&&(a=da(a,i)),on(a,n.shape)},b:()=>{const e=ss(Aa(n),Aa(s));let a=la(is(t,as(n,e)));const i=Ir(s.shape,r);return i.length>0&&(a=da(a,i)),on(a,s.shape)}}}},wu={kernelName:"Atan",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>as(t,ss(Aa(Ve(n,"float32")),1))}}},vu={kernelName:"Atanh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>as(t,pa(Jr(1),Aa(Ve(n,"float32"))))}}};const ku=ee({avgPool3dBackprop_:function(t,e,n,s,r=[1,1,1],a,i){const o=Qt(t,"dy","avgPool3dBackprop"),u=Qt(e,"input","avgPool3dBackprop");let c=o,h=u,p=!1;4===u.rank&&(p=!0,c=on(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]]),h=on(u,[1,u.shape[0],u.shape[1],u.shape[2],u.shape[3]])),l(5===c.rank,()=>"Error in avgPool3dBackprop: dy must be rank 5 but got rank "+c.rank+"."),l(5===h.rank,()=>"Error in avgPool3dBackprop: input must be rank 5 but got rank "+h.rank+"."),l(Bs(s,r),()=>`Error in avgPool3dBackprop: Either strides or dilations must be 1. Got strides ${s} and dilations '${r}'`),null!=i&&l(f(a),()=>`Error in maxPool3dBackprop: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`);const d={dy:c,input:h},m={filterSize:n,strides:s,dilations:r,pad:a,dimRoundingMode:i},g=Ht.runKernelFunc(t=>{const e=As(h.shape,n,s,r,a,i);return t.avgPool3dBackprop(c,h,e)},d,null,"AvgPool3DBackprop",m);return p?on(g,[g.shape[1],g.shape[2],g.shape[3],g.shape[4]]):g}}),Nu={kernelName:"AvgPool3D",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{filterSize:r,strides:a,dilations:i,pad:o,dimRoundingMode:l}=n,u=null==i?[1,1,1]:i;return{x:()=>ku(t,s,r,a,u,o,l)}}};const Iu=ee({avgPoolBackprop_:function(t,e,n,s,r){const a=Qt(t,"dy","avgPoolBackprop"),i=Qt(e,"input","avgPoolBackprop");l(i.rank===a.rank,()=>`Rank of input (${i.rank}) does not match rank of dy (${a.rank})`);let o=i,u=a,c=!1;3===i.rank&&(c=!0,o=on(i,[1,i.shape[0],i.shape[1],i.shape[2]]),u=on(a,[1,a.shape[0],a.shape[1],a.shape[2]])),l(4===u.rank,()=>"Error in avgPoolBackprop: dy must be rank 4 but got rank "+u.rank+"."),l(4===o.rank,()=>"Error in avgPoolBackprop: input must be rank 4 but got rank "+o.rank+".");const h={dy:u,input:o},p={filterSize:n,strides:s,pad:r},d=Ht.runKernelFunc(t=>{const e=$s(o.shape,n,s,1,r);return t.avgPoolBackprop(u,o,e)},h,null,"AvgPoolBackprop",p);return c?on(d,[d.shape[1],d.shape[2],d.shape[3]]):d}}),Cu={kernelName:"AvgPool",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{filterSize:r,strides:a,pad:i}=n;return{x:()=>Iu(t,s,r,a,i)}}},Su={kernelName:"BatchMatMul",inputsToSave:["a","b"],gradFunc:(t,e,n)=>{const[s,r]=e,{transposeA:a,transposeB:i}=n;return a||i?!a&&i?{a:()=>ln(t,r,!1,!1),b:()=>ln(t,s,!0,!1)}:a&&!i?{a:()=>ln(r,t,!1,!0),b:()=>ln(s,t,!1,!1)}:{a:()=>ln(r,t,!0,!0),b:()=>ln(t,s,!0,!0)}:{a:()=>ln(t,r,!1,!0),b:()=>ln(s,t,!0,!1)}}},Tu={kernelName:"BatchToSpaceND",gradFunc:(t,e,n)=>{const{blockShape:s,crops:r}=n;return{x:()=>Ua(t,s,r)}}},Eu={kernelName:"BroadcastTo",gradFunc:(t,e,n)=>{const s=n,r=s.inputShape,a=s.shape,i=Array.from(a);for(let t=r.length-1;t>=0;t--)if(r[t]===a[t])i[t]=1;else if(1!==r[t])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${a}].`);const o=[];for(let t=0;t<i.length;t++)i[t]>1&&o.push(t);return{x:()=>da(t,o,!0)}}},$u={kernelName:"Cast",gradFunc:t=>({x:()=>t.clone()})},Au={kernelName:"Ceil",gradFunc:t=>({x:()=>Er(t)})},Ru={kernelName:"ClipByValue",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{clipValueMin:r,clipValueMax:a}=n;return{x:()=>Tr(ga(Hr(s,r),ta(s,a)),t,Er(t))}}},Du={kernelName:"Concat",saveAllInputs:!0,gradFunc:(t,e,n)=>{const s=e.map(t=>t.shape),{axis:r}=n,a=x(r,e[0].shape)[0],i=s.map(t=>t[a]);return Li(t,i,a).map(t=>()=>t)}},_u={kernelName:"Conv2D",inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,{dilations:a,strides:i,pad:o,dataFormat:u}=n;return l(zs(a),()=>`Error in gradient of conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`),{x:()=>hr(s.shape,t,r,i,o,u),filter:()=>Eo(s,t,r.shape,i,o,u)}}},Fu={kernelName:"Conv2DBackpropInput",inputsToSave:["dy","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,{strides:a,pad:i,dataFormat:o,dimRoundingMode:l}=n;return{dy:()=>ur(t,r,a,i,o,1,l),filter:()=>Eo(t,s,r.shape,a,i,o,l)}}};const Ou=ee({conv3DBackpropFilter_:function(t,e,n,s,r){let a=t;4===t.rank&&(a=on(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]));let i=e;4===i.rank&&(i=on(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]])),l(5===a.rank,()=>"Error in conv3dDerFilter: input must be rank 5, but got shape "+a.shape+"."),l(5===i.rank,()=>"Error in conv3dDerFilter: dy must be rank 5, but got shape "+i.shape+"."),l(5===n.length,()=>"Error in conv3dDerFilter: filterShape must be length 5, but got "+n+"."),l(a.shape[4]===n[3],()=>`Error in conv3dDerFilter: depth of input ${a.shape[4]}) must match input depth in filter (${n[3]}.`),l(i.shape[4]===n[4],()=>`Error in conv3dDerFilter: depth of dy (${i.shape[4]}) must match output depth for filter (${n[4]}).`);const o={x:a,dy:i},u={strides:s,pad:r,filterShape:n};return Ht.runKernelFunc(t=>{const e=Ds(a.shape,n,s,1,r);return t.conv3dDerFilter(a,i,e)},o,null,"Conv3DBackpropFilterV2",u)}}),Mu={kernelName:"Conv3D",inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const{dilations:s,strides:r,pad:a}=n;l(zs(s),()=>`Error in gradient of conv3D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${s}'`);const[i,o]=e;return{x:()=>fr(i.shape,t,o,r,a),filter:()=>Ou(i,t,o.shape,r,a)}}},Lu={kernelName:Y,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>is(la(Si(Ve(n,"float32"))),t)}}},zu={kernelName:"Cosh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>is(Ti(Ve(n,"float32")),t)}}},Bu={kernelName:"Cumsum",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r,exclusive:a,reverse:i}=n;return{x:()=>{const e=gs([r],s.rank);let n=br(t,r,a,!i);return null!=e&&(n=cn(n,e)),n}}}},Pu={kernelName:"DepthwiseConv2dNative",inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const{dilations:s,strides:r,pad:a,dimRoundingMode:i}=n,o=null==s?[1,1]:s;l(zs(o),()=>`Error in gradient of depthwiseConv2dNative: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`);const[u,c]=e;return l(4===u.rank,()=>`Error in gradient of depthwiseConv2dNative: input must be rank 4, but got rank ${u.rank}.`),l(4===c.rank,()=>`Error in gradient of depthwiseConv2dNative: filter must be rank 4, but got rank ${c.rank}.`),l(u.shape[3]===c.shape[2],()=>`Error in gradient of depthwiseConv2d: number of input channels (${u.shape[3]}) must match the inChannels dimension in filter ${c.shape[2]}.`),l(Bs(r,o),()=>`Error in gradient of depthwiseConv2d: Either strides or dilations must be  1. Got strides ${r} and dilations '${o}'.`),null!=i&&l(f(a),()=>`Error in depthwiseConv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`),{x:()=>Oo(u.shape,t,c,r,a,s,i),filter:()=>Fo(u,t,c.shape,r,a,s,i)}}},Wu={kernelName:"Dilation2D",inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,a={x:s,filter:r,dy:t},i={x:s,filter:r,dy:t};return{x:()=>Ht.runKernel("Dilation2DBackpropInput",a,n),filter:()=>Ht.runKernel("Dilation2DBackpropFilter",i,n)}}},Vu={kernelName:J,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Cr(n.shape,s.shape);return{a:()=>{const e=as(t,Ve(s,"float32")),a=Ir(n.shape,r);return a.length>0?on(da(e,a),n.shape):e},b:()=>{let e=is(t,Ve(n,"float32"));const a=Ir(s.shape,r);a.length>0&&(e=on(da(e,a),s.shape));const i=Aa(s);return la(as(e,Ve(i,"float32")))}}}},Uu={kernelName:"Elu",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e,s=e=>e.eluDer(t,n),r={dy:t,y:n};return{x:()=>Ht.runKernelFunc(s,r,null,"EluGrad")}}},Gu={kernelName:"Erf",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e,s=is(_r(la(Aa(n))),2/Math.sqrt(Math.PI));return{x:()=>is(t,s)}}},Hu={kernelName:"Exp",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>is(t,n)}}},ju={kernelName:"Expm1",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>is(t,_r(n))}}},qu={kernelName:"Floor",gradFunc:t=>({x:()=>Er(t)})},Ku={kernelName:"FloorDiv",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Cr(n.shape,s.shape);return{a:()=>{const e=as(t,Ve(s,"float32")),a=Ir(n.shape,r);return a.length>0?on(da(e,a),n.shape):e},b:()=>{let e=is(t,Ve(n,"float32"));const a=Ir(s.shape,r);a.length>0&&(e=on(da(e,a),s.shape));const i=Aa(s);return la(as(e,Ve(i,"float32")))}}}},Xu={kernelName:"FusedBatchNorm",inputsToSave:["x","mean","variance","scale"],gradFunc:(t,e,n)=>{const{varianceEpsilon:s}=n,[r,a,i,o]=e,l=null==o?Jr(1):o,u=Ir(a.shape,r.shape),c=[];if(1===a.rank){for(let t=0;t<r.shape.length-1;++t)c.push(r.shape[t]);c.push(1)}const h=pa(r,a),p=is(t,l),d=vi(ss(i,Jr(s))),f=is(is(is(d,d),d),Jr(-.5));return{x:()=>1===a.rank?on(is(is(t,Mr(on(d,[1,1,1,a.shape[0]]),c)),l),r.shape):on(is(is(t,d),l),r.shape),mean:()=>{let t=is(is(d,Jr(-1)),p);return 1===a.rank&&(t=da(t,u)),on(t,a.shape)},variance:()=>{let t=is(is(f,h),p);return 1===a.rank&&(t=da(t,u)),on(t,a.shape)},scale:()=>{const e=is(h,d);let n=is(t,e);return 1===a.rank&&(n=da(n,u)),on(n,a.shape)},offset:()=>{let e=t;return 1===a.rank&&(e=da(e,u)),on(e,a.shape)}}}},Yu={kernelName:"GatherV2",inputsToSave:["x","indices"],gradFunc:(t,e,n)=>{const[s,r]=e,{axis:a}=n,i=x(a,s.shape)[0];return{x:()=>{const e=s.shape,n=r.size,o=e.slice(0,i),l=o.length,u=e.slice(a,e.length).slice(1),c=u.length,h=Ju(0,l),p=Ju(l+1,l+1+c),d=Zu([o,[n],u]),f=on(t,d),m=on(r,[n]),g=Zu([[l],h,p]),y=cn(f,g);let b=Ji(y,m,s.shape[i]);const x=ys(g);return b=cn(b,x),b},indices:()=>r}}};function Ju(t,e){const n=[];for(let s=t;s<e;++s)n.push(s);return n}function Zu(t){const e=[];for(let n=0;n<t.length;++n)for(let s=0;s<t[n].length;++s)e.push(t[n][s]);return e}const Qu={kernelName:"GreaterEqual",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>Er(n),b:()=>Er(s)}}},tc={kernelName:"Identity",gradFunc:t=>({x:()=>Ve(t,"float32")})},ec={kernelName:"IsFinite",gradFunc:t=>({x:()=>Er(t)})},nc={kernelName:"IsInf",gradFunc:t=>({x:()=>Er(t)})},sc={kernelName:"IsNan",gradFunc:t=>({x:()=>Er(t)})},rc={kernelName:"Log1p",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>as(t,ss(n,1))}}},ac={kernelName:"Log",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>as(t,Ve(n,"float32"))}}},ic={kernelName:"LogSoftmax",inputsToSave:[],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n;return{logits:()=>{const e=_r(s);return pa(t,is(da(t,r,!0),e))}}}};const oc=ee({localResponseNormalizationBackprop_:function(t,e,n,s=5,r=1,a=1,i=.5){const o={x:t,y:e,dy:n},l={depthRadius:s,bias:r,alpha:a,beta:i};return Ht.runKernelFunc(o=>o.LRNGrad(n,t,e,s,r,a,i),o,null,"LRNBackprop",l)}}),lc={kernelName:"LRN",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{depthRadius:a,bias:i,alpha:o,beta:l}=n;return{x:()=>oc(s,r,t,a,i,o,l)}}};function uc(t,e,n,s){return e.rank<n.rank&&(e=on(e,fs(e.shape,s))),t.rank<n.rank&&(t=on(t,fs(t.shape,s))),{x:()=>is(t,Ve(Sr(n,e),t.dtype))}}const cc={kernelName:"Max",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const s=n,{reductionIndices:r}=s,a=e[0],i=uc(t,e[1],a,x(r,a.shape));return{x:()=>i.x()}}},hc={kernelName:"Maximum",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>is(t,Ve(Hr(n,s),"float32")),b:()=>is(t,Ve(Qr(n,s),"float32"))}}};const pc=ee({maxPool3dBackprop_:function(t,e,n,s,r,a=[1,1,1],i,o){const u=Qt(t,"dy","maxPool3dBackprop"),c=Qt(e,"input","maxPool3dBackprop"),h=Qt(n,"output","maxPool3dBackprop");let p=u,d=c,m=h,g=!1;4===c.rank&&(g=!0,p=on(u,[1,u.shape[0],u.shape[1],u.shape[2],u.shape[3]]),d=on(c,[1,c.shape[0],c.shape[1],c.shape[2],c.shape[3]]),m=on(h,[1,h.shape[0],h.shape[1],h.shape[2],h.shape[3]])),l(5===p.rank,()=>"Error in maxPool3dBackprop: dy must be rank 5 but got rank "+p.rank+"."),l(5===d.rank,()=>"Error in maxPool3dBackprop: input must be rank 5 but got rank "+d.rank+"."),l(5===m.rank,()=>"Error in maxPool3dBackprop: output must be rank 5 but got rank "+m.rank+"."),l(Bs(r,a),()=>`Error in maxPool3dBackprop: Either strides or dilations must be 1. Got strides ${r} and dilations '${a}'`),null!=o&&l(f(i),()=>`Error in maxPool3dBackprop: pad must be an integer when using, dimRoundingMode ${o} but got pad ${i}.`);const y={dy:p,input:d,output:m},b={filterSize:s,strides:r,dilations:a,pad:i,dimRoundingMode:o},x=Ht.runKernelFunc(t=>{const e=As(d.shape,s,r,a,i,o);return t.maxPool3dBackprop(p,d,m,e)},y,null,"MaxPool3DBackprop",b);return g?on(x,[x.shape[1],x.shape[2],x.shape[3],x.shape[4]]):x}}),dc={kernelName:"MaxPool3D",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{filterSize:a,strides:i,dilations:o,pad:l,dimRoundingMode:u}=n,c=null==o?[1,1,1]:o;return{x:()=>pc(t,s,r,a,i,c,l,u)}}};const fc=ee({maxPoolBackprop_:function(t,e,n,s,r,a,i){const o=Qt(t,"dy","maxPoolBackprop"),u=Qt(e,"input","maxPoolBackprop"),c=Qt(n,"output","maxPoolBackprop");l(u.rank===o.rank,()=>`Rank of input (${u.rank}) does not match rank of dy (${o.rank})`),l(4===o.rank,()=>"Error in maxPoolBackprop: dy must be rank 4 but got rank "+o.rank+"."),l(4===u.rank,()=>"Error in maxPoolBackprop: input must be rank 4 but got rank "+u.rank+"."),null!=i&&l(f(a),()=>`Error in maxPoolBackprop: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`);const h={dy:o,input:u,output:c},p={filterSize:s,strides:r,pad:a,dimRoundingMode:i};return Ht.runKernelFunc(t=>{const e=$s(u.shape,s,r,1,a,i);return t.maxPoolBackprop(o,u,c,e)},h,null,"MaxPoolBackprop",p)}}),mc={kernelName:"PadV2",inputsToSave:["x"],gradFunc:(t,e,n)=>{const s=e[0],{paddings:r}=n,a=r.map(t=>t[0]);return{x:()=>qs(t,a,s.shape)}}},gc={kernelName:"SpaceToBatchND",gradFunc:(t,e,n)=>{const{blockShape:s,paddings:r}=n;return{x:()=>Ys(t,s,r)}}},yc={kernelName:"SplitV",gradFunc:(t,e,n)=>{const{axis:s}=n;return{x:()=>Hs(t,s)}}};const bc=[cu,hu,pu,du,fu,mu,gu,yu,bu,xu,wu,vu,Nu,Cu,Su,Tu,Eu,$u,Au,Ru,Du,Fu,_u,Mu,Lu,zu,Bu,Pu,Wu,Vu,Uu,Gu,Hu,ju,Ku,qu,Xu,Yu,Qu,tc,ec,nc,sc,rc,ac,ic,lc,cc,cc,hc,dc,{kernelName:"MaxPool",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{filterSize:a,strides:i,pad:o}=n;return{x:()=>fc(t,s,r,a,i,o)}}},{kernelName:"Min",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const s=n,{axis:r}=s,[a,i]=e,o=uc(t,i,a,x(r,a.shape));return{x:()=>o.x()}}},{kernelName:"Minimum",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>is(t,Ve(ta(n,s),"float32")),b:()=>is(t,Ve(Gr(n,s),"float32"))}}},{kernelName:"MirrorPad",inputsToSave:["x"],gradFunc:(t,e,n)=>{const s=e[0],{paddings:r}=n,a=r.map(t=>t[0]);return{x:()=>qs(t,a,s.shape)}}},{kernelName:"Mod",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Cr(n.shape,s.shape);return{a:()=>{const e=Ir(n.shape,r);return e.length>0?on(da(t,e),n.shape):t},b:()=>{const e=is(t,la(Br(as(n,s)))),a=Ir(s.shape,r);return a.length>0?on(da(e,a),s.shape):e}}}},{kernelName:"Multiply",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Cr(n.shape,s.shape);return{a:()=>{const e=is(t,Ve(s,"float32")),a=Ir(n.shape,r);return a.length>0?on(da(e,a),n.shape):e},b:()=>{const e=is(t,Ve(n,"float32")),a=Ir(s.shape,r);return a.length>0?on(da(e,a),s.shape):e}}}},{kernelName:"Negate",gradFunc:t=>({x:()=>la(t)})},{kernelName:"OneHot",inputsToSave:["indices"],gradFunc:(t,e)=>{const n=e[0];return{indices:()=>Na(n.shape,"float32")}}},{kernelName:"OnesLike",gradFunc:t=>({x:()=>Er(t)})},mc,mc,{kernelName:"Pow",inputsToSave:["a","b"],outputsToSave:[!0],gradFunc:(t,e)=>{const[n,s,r]=e,a=n,i=s,o=Cr(a.shape,i.shape);return{a:()=>{const e=Ve(i,"float32");let n=is(t,is(e,Ha(a,pa(e,Jr(1)))));const s=Ir(a.shape,o);return s.length>0&&(n=da(n,s)),on(n,a.shape)},b:()=>{const e=Gr(a,0),n=Tr(e,sa(a),Er(a));let s=is(t,is(r,n));const l=Ir(i.shape,o);return l.length>0&&(s=da(s,l)),on(s,i.shape)}}}},{kernelName:"Prelu",inputsToSave:["x","alpha"],gradFunc:(t,e)=>{const[n,s]=e,r=Gr(n,0);return{x:()=>Tr(r,t,is(t,s)),alpha:()=>{let e=Tr(r,Er(t),is(t,n));const a=Ir(s.shape,t.shape);return a.length>0&&(e=da(e,a)),on(e,s.shape)}}}},{kernelName:"Reciprocal",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>as(t,la(Aa(n)))}}},{kernelName:"Relu6",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e,s=is(ta(n,6),Ui(n));return{x:()=>is(t,Ve(s,"float32"))}}},{kernelName:"Relu",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>is(t,Ve(Ui(n),"float32"))}}},{kernelName:"Reshape",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>on(t,n.shape)}}},{kernelName:"ResizeBilinear",inputsToSave:["images"],gradFunc:(t,e,n)=>{const[s]=e,r=e=>{const{alignCorners:r}=n;return e.resizeBilinearBackprop(t,s,r)},a={images:s};return{images:()=>Ht.runKernelFunc(r,a,null,"ResizeBilinearGrad",n)}}},{kernelName:"ResizeNearestNeighbor",inputsToSave:["images"],gradFunc:(t,e,n)=>{const[s]=e,r=e=>{const{alignCorners:r}=n;return e.resizeNearestNeighborBackprop(t,s,r)},a={images:s};return{images:()=>Ht.runKernelFunc(r,a,null,"ResizeNearestNeighborGrad",n)}}},{kernelName:"Reverse",gradFunc:(t,e,n)=>{const{dims:s}=n,r=x(s,t.shape);return{x:()=>mi(t,r)}}},{kernelName:"Round",gradFunc:t=>({x:()=>Er(t)})},{kernelName:"Rsqrt",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>la(as(t,is(Ha(n,1.5),2)))}}},{kernelName:"SelectV2",inputsToSave:["condition"],gradFunc:(t,e)=>{const[n]=e;return{condition:()=>Ve(Er(n),"float32"),t:()=>is(t,Ve(n,t.dtype)),e:()=>is(t,Ve(ya(n),t.dtype))}}},{kernelName:"Selu",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Gr(n,Jr(0)),s=Jr(1.7580993408473768),r=Jr(ql),a=is(t,r),i=is(is(t,s),_r(Ve(n,"float32")));return Tr(e,a,i)}}}},{kernelName:"Sigmoid",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>is(t,is(n,pa(Jr(1),n)))}}},{kernelName:"Sign",gradFunc:t=>({x:()=>Er(t)})},{kernelName:Z,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>is(gr(Ve(n,"float32")),t)}}},{kernelName:"Sinh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>is(yr(Ve(n,"float32")),t)}}},{kernelName:"Slice",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{begin:r,size:a}=n,i=s.shape,[o,l]=Ln(s,r,a),u=[];for(let e=0;e<t.rank;e++)u.push([o[e],i[e]-o[e]-l[e]]);return{x:()=>za(t,u)}}},{kernelName:"Softmax",outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s]=e,{dim:r}=n,a=is(t,s);return{logits:()=>pa(a,is(da(a,[r],!0),s))}}},{kernelName:"Softplus",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>is(t,js(n))}}},gc,gc,yc,yc,{kernelName:"Sqrt",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>as(t,is(Bi(Ve(n,"float32")),2))}}},{kernelName:"SquaredDifference",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Jr(2);return{a:()=>is(t,is(r,pa(n,s))),b:()=>is(t,is(r,pa(s,n)))}}},{kernelName:"Square",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>is(t,is(Ve(n,"float32"),2))}}},{kernelName:"Step",gradFunc:t=>({x:()=>Er(t)})},{kernelName:Q,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Cr(n.shape,s.shape);return{a:()=>{let e=t;const s=Ir(n.shape,r);return s.length>0&&(e=da(e,s)),on(e,n.shape)},b:()=>{let e=t;const n=Ir(s.shape,r);return n.length>0&&(e=da(e,n)),on(la(e),s.shape)}}}},{kernelName:"Sum",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,r=s.shape.slice(),{axis:a}=n;x(a,s.shape).forEach(t=>{r[t]=1});const i=on(t,r),o=is(i,Ia(s.shape,"float32"));return{x:()=>o}}},{kernelName:tt,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>as(t,Aa(gr(n)))}}},{kernelName:"Tanh",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>is(pa(Jr(1),Aa(n)),t)}}},{kernelName:"Tile",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{reps:r}=n;return{x:()=>{let e=Er(s);if(1===s.rank)for(let n=0;n<r[0];++n)e=ss(e,qs(t,[n*s.shape[0]],[s.shape[0]]));else if(2===s.rank)for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)e=ss(e,qs(t,[n*s.shape[0],a*s.shape[1]],[s.shape[0],s.shape[1]]));else if(3===s.rank)for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)for(let i=0;i<r[2];++i)e=ss(e,qs(t,[n*s.shape[0],a*s.shape[1],i*s.shape[2]],[s.shape[0],s.shape[1],s.shape[2]]));else{if(4!==s.rank)throw new Error("Gradient for tile operation is not implemented for rank-"+s.rank+" tensors yet.");for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)for(let i=0;i<r[2];++i)for(let o=0;o<r[3];++o)e=ss(e,qs(t,[n*s.shape[0],a*s.shape[1],i*s.shape[2],o*s.shape[3]],[s.shape[0],s.shape[1],s.shape[2],s.shape[3]]))}return e}}}},{kernelName:"Transpose",gradFunc:(t,e,n)=>{const s=n,{perm:r}=s,a=ys(r);return{x:()=>cn(t,a)}}},{kernelName:"Unpack",gradFunc:(t,e,n)=>{const s=n,{axis:r}=s;return{value:()=>Vi(t,r)}}},{kernelName:"UnsortedSegmentSum",inputsToSave:["segmentIds"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>function(t,e){const n=Yr(e,Er(e)),s=Ur(t,n);let r=Hr(e,Jr(0,"int32"));const a=s.rank-r.rank;for(let t=0;t<a;++t)r=Fr(r,t+1);r=ga(r,Ia(s.shape,"bool"));const i=Er(s);return Tr(r,s,i)}(t,n)}}},{kernelName:"ZerosLike",gradFunc:t=>({x:()=>Er(t)})}];for(const t of bc)ot(t);let xc;function wc(){return null==xc&&(xc=ns().epsilon()),xc}Tt.prototype.abs=function(){return this.throwIfDisposed(),os(this)},Tt.prototype.acos=function(){return this.throwIfDisposed(),ls(this)},Tt.prototype.acosh=function(){return this.throwIfDisposed(),us(this)},Tt.prototype.addStrict=function(t){return this.throwIfDisposed(),uo(this,t)},Tt.prototype.add=function(t){return this.throwIfDisposed(),ss(this,t)},Tt.prototype.all=function(t,e){return this.throwIfDisposed(),xs(this,t,e)},Tt.prototype.any=function(t,e){return this.throwIfDisposed(),ws(this,t,e)},Tt.prototype.argMax=function(t){return this.throwIfDisposed(),vs(this,t)},Tt.prototype.argMin=function(t){return this.throwIfDisposed(),ks(this,t)},Tt.prototype.asScalar=function(){return this.throwIfDisposed(),l(1===this.size,()=>"The array must have only 1 element."),on(this,[])},Tt.prototype.asType=function(t){return this.throwIfDisposed(),Ve(this,t)},Tt.prototype.as1D=function(){return this.throwIfDisposed(),on(this,[this.size])},Tt.prototype.as2D=function(t,e){return this.throwIfDisposed(),on(this,[t,e])},Tt.prototype.as3D=function(t,e,n){return this.throwIfDisposed(),on(this,[t,e,n])},Tt.prototype.as4D=function(t,e,n,s){return this.throwIfDisposed(),on(this,[t,e,n,s])},Tt.prototype.as5D=function(t,e,n,s,r){return this.throwIfDisposed(),on(this,[t,e,n,s,r])},Tt.prototype.asin=function(){return this.throwIfDisposed(),Ns(this)},Tt.prototype.asinh=function(){return this.throwIfDisposed(),Is(this)},Tt.prototype.atan=function(){return this.throwIfDisposed(),Cs(this)},Tt.prototype.atan2=function(t){return this.throwIfDisposed(),Ss(this,t)},Tt.prototype.atanh=function(){return this.throwIfDisposed(),Ts(this)},Tt.prototype.avgPool=function(t,e,n,s){return this.throwIfDisposed(),Ws(this,t,e,n,s)},Tt.prototype.batchToSpaceND=function(t,e){return this.throwIfDisposed(),Ys(this,t,e)},Tt.prototype.batchNorm=function(t,e,n,s,r){return this.throwIfDisposed(),Zs(this,t,e,n,s,r)},Tt.prototype.broadcastTo=function(t){return this.throwIfDisposed(),nr(this,t)},Tt.prototype.cast=function(t){return this.throwIfDisposed(),Ve(this,t)},Tt.prototype.ceil=function(){return this.throwIfDisposed(),sr(this)},Tt.prototype.clipByValue=function(t,e){return this.throwIfDisposed(),rr(this,t,e)},Tt.prototype.concat=function(t,e){return this.throwIfDisposed(),t instanceof Tt&&(t=[t]),Hs([this,...t],e)},Tt.prototype.conv1d=function(t,e,n,s,r,a){return this.throwIfDisposed(),cr(this,t,e,n,s,r,a)},Tt.prototype.conv2dTranspose=function(t,e,n,s,r){return this.throwIfDisposed(),pr(this,t,e,n,s,r)},Tt.prototype.conv2d=function(t,e,n,s,r,a){return this.throwIfDisposed(),ur(this,t,e,n,s,r,a)},Tt.prototype.cos=function(){return this.throwIfDisposed(),gr(this)},Tt.prototype.cosh=function(){return this.throwIfDisposed(),yr(this)},Tt.prototype.cumsum=function(t,e,n){return this.throwIfDisposed(),br(this,t,e,n)},Tt.prototype.depthToSpace=function(t,e){return this.throwIfDisposed(),xr(this,t,e)},Tt.prototype.depthwiseConv2D=function(t,e,n,s,r,a){return Kn("depthwiseConv2D is deprecated, use depthwiseConv2d instead"),this.throwIfDisposed(),wr(this,t,e,n,s,r,a)},Tt.prototype.depthwiseConv2d=function(t,e,n,s,r,a){return this.throwIfDisposed(),wr(this,t,e,n,s,r,a)},Tt.prototype.dilation2d=function(t,e,n,s,r){return this.throwIfDisposed(),kr(this,t,e,n,s,r)},Tt.prototype.divNoNan=function(t){return this.throwIfDisposed(),$r(this,t)},Tt.prototype.divStrict=function(t){return this.throwIfDisposed(),co(this,t)},Tt.prototype.div=function(t){return this.throwIfDisposed(),as(this,t)},Tt.prototype.dot=function(t){return this.throwIfDisposed(),Ar(this,t)},Tt.prototype.elu=function(){return this.throwIfDisposed(),Rr(this)},Tt.prototype.equalStrict=function(t){return this.throwIfDisposed(),so(this,t)},Tt.prototype.equal=function(t){return this.throwIfDisposed(),Sr(this,t)},Tt.prototype.erf=function(){return this.throwIfDisposed(),Dr(this)},Tt.prototype.exp=function(){return this.throwIfDisposed(),_r(this)},Tt.prototype.expandDims=function(t){return this.throwIfDisposed(),Fr(this,t)},Tt.prototype.expm1=function(){return this.throwIfDisposed(),Or(this)},Tt.prototype.fft=function(){return this.throwIfDisposed(),_i(this)},Tt.prototype.flatten=function(){return this.throwIfDisposed(),on(this,[this.size])},Tt.prototype.floor=function(){return this.throwIfDisposed(),Br(this)},Tt.prototype.floorDiv=function(t){return this.throwIfDisposed(),rs(this,t)},Tt.prototype.gather=function(t,e){return this.throwIfDisposed(),Ur(this,t,e)},Tt.prototype.greaterEqualStrict=function(t){return this.throwIfDisposed(),ro(this,t)},Tt.prototype.greaterEqual=function(t){return this.throwIfDisposed(),Hr(this,t)},Tt.prototype.greaterStrict=function(t){return this.throwIfDisposed(),ao(this,t)},Tt.prototype.greater=function(t){return this.throwIfDisposed(),Gr(this,t)},Tt.prototype.ifft=function(){return this.throwIfDisposed(),Fi(this)},Tt.prototype.irfft=function(){return this.throwIfDisposed(),Oi(this)},Tt.prototype.isFinite=function(){return this.throwIfDisposed(),qr(this)},Tt.prototype.isInf=function(){return this.throwIfDisposed(),Kr(this)},Tt.prototype.isNaN=function(){return this.throwIfDisposed(),Xr(this)},Tt.prototype.leakyRelu=function(t){return this.throwIfDisposed(),Zr(this,t)},Tt.prototype.lessEqualStrict=function(t){return this.throwIfDisposed(),io(this,t)},Tt.prototype.lessEqual=function(t){return this.throwIfDisposed(),ta(this,t)},Tt.prototype.lessStrict=function(t){return this.throwIfDisposed(),oo(this,t)},Tt.prototype.less=function(t){return this.throwIfDisposed(),Qr(this,t)},Tt.prototype.localResponseNormalization=function(t,e,n,s){return this.throwIfDisposed(),na(this,t,e,n,s)},Tt.prototype.logSigmoid=function(){return this.throwIfDisposed(),ca(this)},Tt.prototype.logSoftmax=function(t){return this.throwIfDisposed(),fa(this,t)},Tt.prototype.logSumExp=function(t,e){return this.throwIfDisposed(),ma(this,t,e)},Tt.prototype.log=function(){return this.throwIfDisposed(),sa(this)},Tt.prototype.log1p=function(){return this.throwIfDisposed(),ra(this)},Tt.prototype.logicalAnd=function(t){return this.throwIfDisposed(),ga(this,t)},Tt.prototype.logicalNot=function(){return this.throwIfDisposed(),ya(this)},Tt.prototype.logicalOr=function(t){return this.throwIfDisposed(),ba(this,t)},Tt.prototype.logicalXor=function(t){return this.throwIfDisposed(),xa(this,t)},Tt.prototype.matMul=function(t,e,n){return this.throwIfDisposed(),ln(this,t,e,n)},Tt.prototype.maxPool=function(t,e,n,s){return this.throwIfDisposed(),wa(this,t,e,n,s)},Tt.prototype.max=function(t,e){return this.throwIfDisposed(),ha(this,t,e)},Tt.prototype.maximumStrict=function(t){return this.throwIfDisposed(),ho(this,t)},Tt.prototype.maximum=function(t){return this.throwIfDisposed(),Yr(this,t)},Tt.prototype.mean=function(t,e){return this.throwIfDisposed(),Ca(this,t,e)},Tt.prototype.min=function(t,e){return this.throwIfDisposed(),Sa(this,t,e)},Tt.prototype.minimumStrict=function(t){return this.throwIfDisposed(),po(this,t)},Tt.prototype.minimum=function(t){return this.throwIfDisposed(),Ta(this,t)},Tt.prototype.mirrorPad=function(t,e){return this.throwIfDisposed(),Ea(this,t,e)},Tt.prototype.modStrict=function(t){return this.throwIfDisposed(),fo(this,t)},Tt.prototype.mod=function(t){return this.throwIfDisposed(),$a(this,t)},Tt.prototype.mulStrict=function(t){return this.throwIfDisposed(),mo(this,t)},Tt.prototype.mul=function(t){return this.throwIfDisposed(),is(this,t)},Tt.prototype.neg=function(){return this.throwIfDisposed(),la(this)},Tt.prototype.norm=function(t,e,n){return this.throwIfDisposed(),xo(this,t,e,n)},Tt.prototype.notEqualStrict=function(t){return this.throwIfDisposed(),lo(this,t)},Tt.prototype.notEqual=function(t){return this.throwIfDisposed(),Fa(this,t)},Tt.prototype.oneHot=function(t,e=1,n=0){return this.throwIfDisposed(),un(this,t,e,n)},Tt.prototype.onesLike=function(){return this.throwIfDisposed(),Ma(this)},Tt.prototype.pad=function(t,e){return this.throwIfDisposed(),za(this,t,e)},Tt.prototype.pool=function(t,e,n,s,r){return this.throwIfDisposed(),Ga(this,t,e,n,s,r)},Tt.prototype.powStrict=function(t){return this.throwIfDisposed(),go(this,t)},Tt.prototype.pow=function(t){return this.throwIfDisposed(),Ha(this,t)},Tt.prototype.prelu=function(t){return this.throwIfDisposed(),ja(this,t)},Tt.prototype.prod=function(t,e){return this.throwIfDisposed(),qa(this,t,e)},Tt.prototype.reciprocal=function(){return this.throwIfDisposed(),pi(this)},Tt.prototype.relu=function(){return this.throwIfDisposed(),di(this)},Tt.prototype.relu6=function(){return this.throwIfDisposed(),fi(this)},Tt.prototype.reshapeAs=function(t){return this.throwIfDisposed(),on(this,t.shape)},Tt.prototype.reshape=function(t){return this.throwIfDisposed(),on(this,t)},Tt.prototype.resizeBilinear=function(t,e){return this.throwIfDisposed(),ll(this,t,e)},Tt.prototype.resizeNearestNeighbor=function(t,e){return this.throwIfDisposed(),ul(this,t,e)},Tt.prototype.reverse=function(t){return this.throwIfDisposed(),mi(this,t)},Tt.prototype.rfft=function(){return this.throwIfDisposed(),zi(this)},Tt.prototype.round=function(){return this.throwIfDisposed(),wi(this)},Tt.prototype.rsqrt=function(){return this.throwIfDisposed(),vi(this)},Tt.prototype.selu=function(){return this.throwIfDisposed(),ki(this)},Tt.prototype.separableConv2d=function(t,e,n,s,r,a){return this.throwIfDisposed(),Ni(this,t,e,n,s,r,a)},Tt.prototype.sigmoid=function(){return this.throwIfDisposed(),js(this)},Tt.prototype.sign=function(){return this.throwIfDisposed(),Ci(this)},Tt.prototype.sin=function(){return this.throwIfDisposed(),Si(this)},Tt.prototype.sinh=function(){return this.throwIfDisposed(),Ti(this)},Tt.prototype.slice=function(t,e){return this.throwIfDisposed(),qs(this,t,e)},Tt.prototype.softmax=function(t){return this.throwIfDisposed(),Di(this,t)},Tt.prototype.softplus=function(){return this.throwIfDisposed(),ua(this)},Tt.prototype.spaceToBatchND=function(t,e){return this.throwIfDisposed(),Ua(this,t,e)},Tt.prototype.split=function(t,e){return this.throwIfDisposed(),Li(this,t,e)},Tt.prototype.sqrt=function(){return this.throwIfDisposed(),Bi(this)},Tt.prototype.square=function(){return this.throwIfDisposed(),Aa(this)},Tt.prototype.squaredDifference=function(t){return this.throwIfDisposed(),Pi(this,t)},Tt.prototype.squaredDifferenceStrict=function(t){return this.throwIfDisposed(),yo(this,t)},Tt.prototype.squeeze=function(t){return this.throwIfDisposed(),Wi(this,t)},Tt.prototype.stack=function(t,e){this.throwIfDisposed();const n=t instanceof Tt?[this,t]:[this,...t];return Vi(n,e)},Tt.prototype.step=function(t){return this.throwIfDisposed(),Ui(this,t)},Tt.prototype.stridedSlice=function(t,e,n,s,r,a,i,o){return this.throwIfDisposed(),Gi(this,t,e,n,s,r,a,i,o)},Tt.prototype.subStrict=function(t){return this.throwIfDisposed(),bo(this,t)},Tt.prototype.sub=function(t){return this.throwIfDisposed(),pa(this,t)},Tt.prototype.sum=function(t,e){return this.throwIfDisposed(),da(this,t,e)},Tt.prototype.tan=function(){return this.throwIfDisposed(),Hi(this)},Tt.prototype.tanh=function(){return this.throwIfDisposed(),Ks(this)},Tt.prototype.tile=function(t){return this.throwIfDisposed(),Mr(this,t)},Tt.prototype.toBool=function(){return this.throwIfDisposed(),Ve(this,"bool")},Tt.prototype.toFloat=function(){return this.throwIfDisposed(),Ve(this,"float32")},Tt.prototype.toInt=function(){return this.throwIfDisposed(),Ve(this,"int32")},Tt.prototype.topk=function(t,e){return this.throwIfDisposed(),Ki(this,t,e)},Tt.prototype.transpose=function(t){return this.throwIfDisposed(),cn(this,t)},Tt.prototype.unique=function(t){return this.throwIfDisposed(),Yi(this,t)},Tt.prototype.unsortedSegmentSum=function(t,e){return this.throwIfDisposed(),Ji(this,t,e)},Tt.prototype.unstack=function(t){return this.throwIfDisposed(),Zi(this,t)},Tt.prototype.where=function(t,e){return this.throwIfDisposed(),Tr(t,this,e)},Tt.prototype.zerosLike=function(){return this.throwIfDisposed(),Er(this)};class vc extends Error{constructor(t){super(t),Object.setPrototypeOf(this,vc.prototype)}}class kc extends Error{constructor(t){super(t),Object.setPrototypeOf(this,kc.prototype)}}class Nc extends Error{constructor(t){super(t),Object.setPrototypeOf(this,Nc.prototype)}}class Ic extends Error{constructor(t){super(t),Object.setPrototypeOf(this,Ic.prototype)}}class Cc extends Error{constructor(t){super(t),Object.setPrototypeOf(this,Cc.prototype)}}Error;function Sc(t,e){if(Array.isArray(t)){let n=[];for(let s=0;s<e;s++)n=n.concat(t);return n}{const n=new Array(e);return n.fill(t),n}}function Tc(t,e){if(!t)throw new Cc(e)}function Ec(t,e){let n=0;for(const s of t)s===e&&n++;return n}function $c(t){return 1===t.length?t[0]:t}function Ac(t){return Array.isArray(t)?t:[t]}function Rc(t){const e=t.replace(/(.)([A-Z][a-z0-9]+)/g,"$1_$2").replace(/([a-z])([A-Z])/g,"$1_$2").toLowerCase();return"_"!==e[0]?e:"private"+e}function Dc(t){return t.length<=1||-1===t.indexOf("_")?t:t.replace(/[_]+(\w|$)/g,(t,e)=>e.toUpperCase())}let _c={};function Fc(t){if(null==t)return null;const e={};return e.className=t.getClassName(),e.config=t.getConfig(),e}function Oc(t,e={},n={},s="object",r=!1){if("string"==typeof t){const r=t;let a;if(r in n)a=n[r];else if(r in _c)a=_c[r];else if(a=e[r],null==a)throw new Nc(`Unknown ${s}: ${t}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);return a}{const a=t;if(null==a.className||null==a.config)throw new Nc(s+": Improper config format: "+JSON.stringify(a)+".\n'className' and 'config' must set.");const i=a.className;let o,l;if(i in n?[o,l]=n[i]:i in _c?[o,l]=_c.className:i in e&&([o,l]=e[i]),null==o)throw new Nc(`Unknown ${s}: ${i}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);if(null!=l){const t={};for(const e of Object.keys(_c))t[e]=_c[e];for(const e of Object.keys(n))t[e]=n[e];a.config.customObjects=t;const e=Object.assign({},_c);for(const t of Object.keys(n))_c[t]=n[t];!function t(e){if(null!=e&&"object"==typeof e)if(Array.isArray(e))e.forEach(e=>t(e));else{const n=Object.keys(e);for(const s of n){const n=e[s];null!=n&&"object"==typeof n&&(Array.isArray(n)||"ndarray"!==n.type||"number"!=typeof n.value?t(n):e[s]=n.value)}}}(a.config);const s=l(o,a.config,n,r);return _c=Object.assign({},e),s}{const t=Object.assign({},_c);for(const t of Object.keys(n))_c[t]=n[t];const e=new o(a.config);return _c=Object.assign({},t),e}}}function Mc(t,e){return-1*function(t,e){return t<e?-1:t>e?1:0}(t,e)}function Lc(t){if(null==t)return t;const e=[];for(const n of t)-1===e.indexOf(n)&&e.push(n);return e}function zc(t){if(null==t)throw new Nc("Invalid value in obj: "+JSON.stringify(t));for(const e in t)if(t.hasOwnProperty(e))return!1;return!0}function Bc(t,e,n){if(null!=n&&t.indexOf(n)<0)throw new Nc(`${n} is not a valid ${e}.  Valid values are ${t} or null/undefined.`)}function Pc(t,e,n=0,s=1/0){return Tc(n>=0),Tc(s>=n),Array.isArray(t)&&t.length>=n&&t.length<=s&&t.every(t=>typeof t===e)}function Wc(t,e){Array.isArray(t)?(l(t.length>0,()=>e+" is unexpectedly an empty array."),t.forEach((t,n)=>Wc(t,`element ${n+1} of ${e}`))):l(Number.isInteger(t)&&t>0,()=>`Expected ${e} to be a positive integer, but got `+function t(e){return null===e?"null":Array.isArray(e)?"["+e.map(e=>t(e)).join(",")+"]":"string"==typeof e?`"${e}"`:""+e}(t)+".")}function Vc(t){return"relu"===t?"relu":"linear"===t?"linear":"elu"===t?"elu":null}function Uc(t,e){return Jn(()=>Bi(da(is(t,t),e,!0)))}class Gc extends Bn{getConfig(){return{}}}class Hc extends Gc{constructor(t){super(),this.defaultMaxValue=2,this.defaultAxis=0,this.maxValue=null!=t.maxValue?t.maxValue:this.defaultMaxValue,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(t){return Jn(()=>{const e=Uc(t,this.axis),n=rr(e,0,this.maxValue);return is(t,as(n,ss(wc(),e)))})}getConfig(){return{maxValue:this.maxValue,axis:this.axis}}}Hc.className="MaxNorm",Wn(Hc);class jc extends Gc{constructor(t){super(),this.defaultAxis=0,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(t){return Jn(()=>as(t,ss(wc(),Uc(t,this.axis))))}getConfig(){return{axis:this.axis}}}jc.className="UnitNorm",Wn(jc);class qc extends Gc{apply(t){return di(t)}}qc.className="NonNeg",Wn(qc);class Kc extends Gc{constructor(t){super(),this.defaultMinValue=0,this.defaultMaxValue=1,this.defaultRate=1,this.defaultAxis=0,this.minValue=null!=t.minValue?t.minValue:this.defaultMinValue,this.maxValue=null!=t.maxValue?t.maxValue:this.defaultMaxValue,this.rate=null!=t.rate?t.rate:this.defaultRate,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(t){return Jn(()=>{const e=Uc(t,this.axis),n=ss(is(this.rate,rr(e,this.minValue,this.maxValue)),is(1-this.rate,e));return is(t,as(n,ss(wc(),e)))})}getConfig(){return{minValue:this.minValue,maxValue:this.maxValue,rate:this.rate,axis:this.axis}}}Kc.className="MinMaxNorm",Wn(Kc);const Xc={maxNorm:"MaxNorm",minMaxNorm:"MinMaxNorm",nonNeg:"NonNeg",unitNorm:"UnitNorm"};function Yc(t){return Fc(t)}function Jc(t,e={}){return Oc(t,Pn.getMap().classNameMap,e,"constraint")}function Zc(t){if(null==t)return null;if("string"==typeof t){return Jc({className:t in Xc?Xc[t]:t,config:{}})}return t instanceof Gc?t:Jc(t)}var Qc=Object.freeze({__proto__:null,maxNorm:function(t){return new Hc(t)},unitNorm:function(t){return new jc(t)},nonNeg:function(){return new qc},minMaxNorm:function(t){return new Kc(t)}});const th=["channelsFirst","channelsLast"],eh=["valid","same","causal"],nh=["max","avg"],sh=["sum","mul","concat","ave"],rh=new Map;function ah(t){Bc(th,"DataFormat",t)}function ih(t){Bc(eh,"PaddingMode",t)}function oh(t){Bc(nh,"PoolMode",t)}const lh=[];function uh(t,e){lh.push(t);try{const t=e();return lh.pop(),t}catch(t){throw lh.pop(),t}}function ch(t){if(!dh(t))throw new Error("Not a valid tensor name: '"+t+"'");return(0===lh.length?"":lh.join("/")+"/")+t}function hh(t){if(!dh(t))throw new Error("Not a valid tensor name: '"+t+"'");rh.has(t)||rh.set(t,0);const e=rh.get(t);if(rh.set(t,rh.get(t)+1),e>0){const n=`${t}_${e}`;return rh.set(n,1),n}return t}const ph=new RegExp(/^[A-Za-z0-9][-A-Za-z0-9\._\/]*$/);function dh(t){return!!t.match(ph)}function fh(t,e,n){null==e&&(e=0),null==n&&(n=t.length);let s=1;for(let r=e;r<n;++r)s*=t[r];return s}function mh(t){return ci(t=Array.isArray(t)?new Float32Array(t):t)}function gh(t){return Sa(mh(t)).dataSync()[0]}function yh(t){return ha(mh(t)).dataSync()[0]}function bh(t,e){if(e<t)throw new Nc(`end (${e}) < begin (${t}) is forbidden.`);const n=[];for(let s=t;s<e;++s)n.push(s);return n}function xh(t,e){return t.asType(e)}function wh(t,e=-1){const n=t.shape.slice();return e<0&&(e=n.length+e+1),n.splice(e,0,1),t.reshape(n)}function vh(t,e,n){return Jn(()=>{switch(t.rank){case 1:return Ei(t,e,n);case 2:return $i(t,[e,0],[n,t.shape[1]]);case 3:return Ai(t,[e,0,0],[n,t.shape[1],t.shape[2]]);case 4:return Ri(t,[e,0,0,0],[n,t.shape[1],t.shape[2],t.shape[3]]);case 5:return qs(t,[e,0,0,0,0],[n,t.shape[1],t.shape[2],t.shape[3],t.shape[4]]);case 6:return qs(t,[e,0,0,0,0,0],[n,t.shape[1],t.shape[2],t.shape[3],t.shape[4],t.shape[5]]);default:throw new Nc("sliceAlongFirstAxis() received an unsupported tensor rank: "+t.rank)}})}function kh(t,e,n){return Jn(()=>{switch(t.rank){case 1:return Ei(t,e,n);case 2:return $i(t,[0,e],[t.shape[0],n]);case 3:return Ai(t,[0,0,e],[t.shape[0],t.shape[1],n]);case 4:return Ri(t,[0,0,0,e],[t.shape[0],t.shape[1],t.shape[2],n]);default:throw new Nc("sliceAlongLastAxis() received an unsupported tensor rank: "+t.rank)}})}function Nh(t,e,n,s){return Jn(()=>{switch(t.rank){case 1:return Ei(t,e,n);case 2:switch(s){case 1:return vh(t,e,n);case 2:return kh(t,e,n);default:throw new Nc("The axis is not within the rank of the tensor "+s)}case 3:switch(s){case 1:return vh(t,e,n);case 2:return Ai(t,[0,e,0],[t.shape[0],n,t.shape[2]]);case 3:return kh(t,e,n);default:throw new Nc("The axis is not within the rank of the tensor "+s)}case 4:switch(s){case 1:return vh(t,e,n);case 2:return Ri(t,[0,e,0,0],[t.shape[0],n,t.shape[2],t.shape[3]]);case 3:return Ri(t,[0,0,e,0],[t.shape[0],t.shape[1],n,t.shape[3]]);case 4:return kh(t,e,n);default:throw new Nc("The axis is not within the rank of the tensor "+s)}default:throw new Nc("sliceAlongLastAxis() received an unsupported tensor rank: "+t.rank)}})}function Ih(t,e=-1){let n;return e<0&&(n=t[0].rank,e=0!==n?n:0),e===t[0].rank&&(e=-1),Hs(t,e)}function Ch(t,e){switch(t.rank){case 1:return ar([t,e]);case 2:return ir([t,e],0);case 3:return or([t,e],0);case 4:return lr([t,e],0);default:throw new Nc("concatAlongFirstAxis() received an unsupported tensor rank: "+t.rank)}}function Sh(t,e){if(Array.isArray(e)||(e=[e]),t.rank!==e.length)throw new Nc(`The length of input n (${e.length}) does not match the number of dimensions in input x (${t.rank})`);return Mr(t,e)}function Th(t,e=0,n=1,s,r){return li(t,e,n,s,r)}function Eh(t,e,n,s){if(t.rank<2||e.rank<2)throw new Ic(`dot requires both inputs to be rank >= 2 but got x shape = ${t.shape} and y shape = ${e.shape}`);if(e.rank>=3){if(t.shape.slice(-1)[0]!==e.shape.slice(-2)[0])throw new Ic(`If rank y >= 3, then the second last dim of y must equal the last dim of x but got x shape = ${t.shape} and  y shape = `+e.shape)}if(2===t.rank&&2===e.rank){return Lo({a:t,b:e,transposeA:!1,transposeB:!1,bias:s?Rh(t.rank,s,"channelsLast"):null,activation:n})}{const r=t.shape.slice(),a=r.pop();t=t.reshape([-1,a]);const i=e.shape.slice(),o=i.pop(),l=i.pop(),u=[...i,o],c=Array.from({length:e.rank},(t,n)=>0===n?e.rank-2:n<=e.rank-2?n-1:n);e=e.transpose(c).reshape([l,-1]);const h=[...r,...u];return Lo({a:t,b:e,transposeA:!1,transposeB:!1,bias:s?Rh(t.rank,s,"channelsLast"):null,activation:n}).reshape(h)}}function $h(t,e,n){return Jn(()=>(e=Array.isArray(e)?ci(e,"int32"):e.toInt(),Ur(t,e,n)))}function Ah(t){return is(t,t)}function Rh(t,e,n){const s=e.shape;if(1!==e.rank&&e.rank!==t)throw new Nc("Unexpected bias dimensions: "+e.rank+"; expected it to be 1 or "+t);if(5===t){if("channelsFirst"===n)return 1===s.length?e.reshape([1,s[0],1,1,1]):e.reshape([1,s[3],s[0],s[1],s[2]]);if("channelsLast"===n)return 1===s.length?e.reshape([1,1,1,1,s[0]]):e.reshape([1].concat(s))}else if(4===t){if("channelsFirst"===n)return 1===s.length?e.reshape([1,s[0],1,1]):e.reshape([1,s[2],s[0],s[1]]);if("channelsLast"===n)return 1===s.length?e.reshape([1,1,1,s[0]]):e.reshape([1].concat(s))}else if(3===t){if("channelsFirst"===n)return 1===s.length?e.reshape([1,s[0],1]):e.reshape([1,s[1],s[0]]);if("channelsLast"===n)return 1===s.length?e.reshape([1,1,s[0]]):e.reshape([1].concat(s))}else if(t<3)return e;throw new Nc("Unsupported input rank by biasAdd: "+e.rank)}function Dh(t,e,n){return Jn(()=>(null==n&&(n="channelsLast"),ah(n),t.add(Rh(t.rank,e,n))))}function _h(t,e,n,s){return Jn(()=>Io(t,e,n,s))}function Fh(t,e,n=!1){return n?t():e()}const Oh=["fanIn","fanOut","fanAvg"],Mh=["normal","uniform","truncatedNormal"];class Lh extends Bn{fromConfigUsesCustomObjects(){return!1}getConfig(){return{}}}class zh extends Lh{apply(t,e){return Na(t,e)}}zh.className="Zeros",Wn(zh);class Bh extends Lh{apply(t,e){return Ia(t,e)}}Bh.className="Ones",Wn(Bh);class Ph extends Lh{constructor(t){if(super(),"object"!=typeof t)throw new Nc("Expected argument of type ConstantConfig but got "+t);if(void 0===t.value)throw new Nc("config must have value set but got "+t);this.value=t.value}apply(t,e){return Jn(()=>is(Jr(this.value),Ia(t,e)))}getConfig(){return{value:this.value}}}Ph.className="Constant",Wn(Ph);class Wh extends Lh{constructor(t){super(),this.DEFAULT_MINVAL=-.05,this.DEFAULT_MAXVAL=.05,this.minval=t.minval||this.DEFAULT_MINVAL,this.maxval=t.maxval||this.DEFAULT_MAXVAL,this.seed=t.seed}apply(t,e){return ui(t,this.minval,this.maxval,e)}getConfig(){return{minval:this.minval,maxval:this.maxval,seed:this.seed}}}Wh.className="RandomUniform",Wn(Wh);class Vh extends Lh{constructor(t){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=t.mean||this.DEFAULT_MEAN,this.stddev=t.stddev||this.DEFAULT_STDDEV,this.seed=t.seed}apply(t,e){if("float32"!==(e=e||"float32")&&"int32"!==e)throw new Ic(`randomNormal does not support dType ${e}.`);return Th(t,this.mean,this.stddev,e,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}Vh.className="RandomNormal",Wn(Vh);class Uh extends Lh{constructor(t){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=t.mean||this.DEFAULT_MEAN,this.stddev=t.stddev||this.DEFAULT_STDDEV,this.seed=t.seed}apply(t,e){if("float32"!==(e=e||"float32")&&"int32"!==e)throw new Ic(`truncatedNormal does not support dType ${e}.`);return Xi(t,this.mean,this.stddev,e,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}Uh.className="TruncatedNormal",Wn(Uh);class Gh extends Lh{constructor(t){super(),this.gain=null!=t.gain?t.gain:1}apply(t,e){return Jn(()=>{if(2!==t.length||t[0]!==t[1])throw new Nc("Identity matrix initializer can only be used for 2D square matrices.");return is(this.gain,Lr(t[0]))})}getConfig(){return{gain:this.gain}}}Gh.className="Identity",Wn(Gh);class Hh extends Lh{constructor(t){if(super(),t.scale<0)throw new Nc("scale must be a positive float. Got: "+t.scale);var e;this.scale=null==t.scale?1:t.scale,this.mode=null==t.mode?"fanIn":t.mode,e=this.mode,Bc(Oh,"FanMode",e),this.distribution=null==t.distribution?"normal":t.distribution,function(t){Bc(Mh,"Distribution",t)}(this.distribution),this.seed=t.seed}apply(t,e){const n=function(t,e="channelsLast"){let n,s;if(ah(e),2===t.length)n=t[0],s=t[1];else if(-1!==[3,4,5].indexOf(t.length)){if("channelsFirst"===e){const e=fh(t,2);n=t[1]*e,s=t[0]*e}else if("channelsLast"===e){const e=fh(t,0,t.length-2);n=t[t.length-2]*e,s=t[t.length-1]*e}}else{const e=fh(t);n=Math.sqrt(e),s=Math.sqrt(e)}return[n,s]}(t),s=n[0],r=n[1];let a=this.scale;if("fanIn"===this.mode?a/=Math.max(1,s):"fanOut"===this.mode?a/=Math.max(1,r):a/=Math.max(1,(s+r)/2),"normal"===this.distribution){const n=Math.sqrt(a);if("float32"!==(e=e||"float32")&&"int32"!==e)throw new Ic(`${this.getClassName()} does not support dType ${e}.`);return Xi(t,0,n,e,this.seed)}{const n=Math.sqrt(3*a);return ui(t,-n,n,e)}}getConfig(){return{scale:this.scale,mode:this.mode,distribution:this.distribution,seed:this.seed}}}Hh.className="VarianceScaling",Wn(Hh);class jh extends Hh{constructor(t){super({scale:1,mode:"fanAvg",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return Hh.className}}jh.className="GlorotUniform",Wn(jh);class qh extends Hh{constructor(t){super({scale:1,mode:"fanAvg",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return Hh.className}}qh.className="GlorotNormal",Wn(qh);class Kh extends Hh{constructor(t){super({scale:2,mode:"fanIn",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return Hh.className}}Kh.className="HeNormal",Wn(Kh);class Xh extends Hh{constructor(t){super({scale:2,mode:"fanIn",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return Hh.className}}Xh.className="HeUniform",Wn(Xh);class Yh extends Hh{constructor(t){super({scale:1,mode:"fanIn",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return Hh.className}}Yh.className="LeCunNormal",Wn(Yh);class Jh extends Hh{constructor(t){super({scale:1,mode:"fanIn",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return Hh.className}}Jh.className="LeCunNormal",Wn(Jh);class Zh extends Lh{constructor(t){if(super(),this.DEFAULT_GAIN=1,this.gain=null==t.gain?this.DEFAULT_GAIN:t.gain,this.seed=t.seed,null!=this.seed)throw new Ic("Random seed is not implemented for Orthogonal Initializer yet.")}apply(t,e){return Jn(()=>{if(t.length<2)throw new Ic("Shape must be at least 2D.");t[0]*t[1]>2e3&&console.warn(`Orthogonal initializer is being called on a matrix with more than 2000 (${t[0]*t[1]}) elements: Slowness may result.`);const e=Th(t[0]>t[1]?[t[1],t[0]]:t,0,1,"float32");let n=Tl.gramSchmidt(e);return t[0]>t[1]&&(n=n.transpose()),is(this.gain,n)})}getConfig(){return{gain:this.gain,seed:this.seed}}}Zh.className="Orthogonal",Wn(Zh);const Qh={constant:"Constant",glorotNormal:"GlorotNormal",glorotUniform:"GlorotUniform",heNormal:"HeNormal",heUniform:"HeUniform",identity:"Identity",leCunNormal:"LeCunNormal",leCunUniform:"LeCunUniform",ones:"Ones",orthogonal:"Orthogonal",randomNormal:"RandomNormal",randomUniform:"RandomUniform",truncatedNormal:"TruncatedNormal",varianceScaling:"VarianceScaling",zeros:"Zeros"};function tp(t,e={}){return Oc(t,Pn.getMap().classNameMap,e,"initializer")}function ep(t){return Fc(t)}function np(t){if("string"==typeof t){const e=t in Qh?Qh[t]:t;if("GlorotNormal"===e)return new qh;if("GlorotUniform"===e)return new jh;if("HeNormal"===e)return new Kh;if("HeUniform"===e)return new Xh;if("LeCunNormal"===e)return new Yh;if("LeCunUniform"===e)return new Jh;{const t={};return t.className=e,t.config={},tp(t)}}return t instanceof Lh?t:tp(t)}var sp=Object.freeze({__proto__:null,zeros:function(){return new zh},ones:function(){return new Bh},constant:function(t){return new Ph(t)},randomUniform:function(t){return new Wh(t)},randomNormal:function(t){return new Vh(t)},truncatedNormal:function(t){return new Uh(t)},identity:function(t){return new Gh(t)},varianceScaling:function(t){return new Hh(t)},glorotUniform:function(t){return new jh(t)},glorotNormal:function(t){return new qh(t)},heNormal:function(t){return new Kh(t)},heUniform:function(t){return new Xh(t)},leCunNormal:function(t){return new Yh(t)},leCunUniform:function(t){return new Jh(t)},orthogonal:function(t){return new Zh(t)}});let rp=0;function ap(){return rp++}const ip={};function op(t=""){return t in ip||(ip[t]=0),ip[t]+=1,t+ip[t].toString()}function lp(t){return Array.isArray(t)&&Array.isArray(t[0])}function up(t){return 0===t.length?[]:Array.isArray(t[0])?t:[t]}function cp(t){let e;if(Array.isArray(t)){if(1!==t.length)throw new Nc("Expected Tensor length to be 1; got "+t.length);e=t[0]}else e=t;return e}function hp(t){if(Array.isArray(t)&&Array.isArray(t[0])){if(1===t.length)return(t=t)[0];throw new Nc("Expected exactly 1 Shape; got "+t.length)}return t}function pp(t){let e=0;for(const n of t)0===n.shape.length?e+=1:e+=n.shape.reduce((t,e)=>t*e);return e}class dp{constructor(t,e="float32",n="Variable",s=!0,r=null){this.dtype=null==e?"float32":e,this.shape=t.shape,this.id=ap(),n=null==n?"Variable":n,this.originalName=ch(n),this.name=hh(this.originalName),this.trainable_=s,this.constraint=r,this.val=Qi(t,this.trainable_,this.name,this.dtype)}read(){return this.assertNotDisposed(),this.val}write(t){return this.assertNotDisposed(),function(t,e){if(t.shape.toString()!==e.shape.toString())throw new Error("Shape mismatch: "+JSON.stringify(t.shape)+" vs. "+JSON.stringify(e.shape))}(this.val,t),this.val.id!==t.id&&(this.val.assign(t),null!=this.constraint&&this.val.assign(this.constraint.apply(this.val))),this}dispose(){this.assertNotDisposed(),this.val.dispose()}assertNotDisposed(){if(this.val.isDisposed)throw new Error(`LayersVariable ${this.name} is already disposed.`)}get trainable(){return this.trainable_}set trainable(t){this.trainable_=t,this.val.trainable=t}}function fp(t){return t.map(t=>t.read())}function mp(t){t.forEach(t=>{t[0].write(t[1])})}class gp{constructor(t){this.dtype=t.dtype,this.shape=t.shape,null!=t.shape?this.ndim=t.shape.length:this.ndim=t.ndim,this.maxNDim=t.maxNDim,this.minNDim=t.minNDim,this.axes=t.axes||{}}}class yp{constructor(t,e,n,s,r,a,i){this.dtype=t,this.shape=e,this.sourceLayer=n,this.inputs=s,this.callArgs=r,this.outputTensorIndex=i,this.id=ap(),null!=a&&(this.originalName=ch(a),this.name=hh(this.originalName)),this.rank=e.length}}let bp=0;class xp{constructor(t,e){this.callArgs=e,this.id=bp++,this.outboundLayer=t.outboundLayer,this.inboundLayers=t.inboundLayers,this.nodeIndices=t.nodeIndices,this.tensorIndices=t.tensorIndices,this.inputTensors=t.inputTensors,this.outputTensors=t.outputTensors,this.inputMasks=t.inputMasks,this.outputMasks=t.outputMasks,this.inputShapes=t.inputShapes,this.outputShapes=t.outputShapes;for(const e of t.inboundLayers)null!=e&&e.outboundNodes.push(this);t.outboundLayer.inboundNodes.push(this)}getConfig(){const t=[];for(const e of this.inboundLayers)null!=e?t.push(e.name):t.push(null);return{outboundLayer:this.outboundLayer?this.outboundLayer.name:null,inboundLayers:t,nodeIndices:this.nodeIndices,tensorIndices:this.tensorIndices}}}let wp=0;class vp extends Bn{constructor(t={}){super(),this._callHook=null,this._addedWeightNames=[],this._stateful=!1,this.id=wp++,this.activityRegularizer=null,this.inputSpec=null,this.supportsMasking=!1,this._trainableWeights=[],this._nonTrainableWeights=[],this._losses=[],this._updates=[],this._built=!1,this.inboundNodes=[],this.outboundNodes=[];let e=t.name;if(!e){const t=this.getClassName();e=Rc(t)+"_"+op(t)}if(this.name=e,this.trainable_=null==t.trainable||t.trainable,null!=t.inputShape||null!=t.batchInputShape){let e;if(null!=t.batchInputShape)e=t.batchInputShape;else if(null!=t.inputShape){let n=null;null!=t.batchSize&&(n=t.batchSize),e=[n].concat(t.inputShape)}this.batchInputShape=e;let n=t.dtype;null==n&&(n=t.inputDType),null==n&&(n="float32"),this.dtype=n}null!=t.weights?this.initialWeights=t.weights:this.initialWeights=null,this._refCount=null,this.fastWeightInitDuringBuild=!1}static nodeKey(t,e){return t.name+"_ib-"+e.toString()}getNodeAtIndex(t,e){if(0===this.inboundNodes.length)throw new kc(`The layer has never been called and thus has no defined ${e}.`);if(this.inboundNodes.length<=t)throw new Nc(`Asked to get ${e} at node ${t}, but the layer has only ${this.inboundNodes.length} inbound nodes.`);return this.inboundNodes[t]}getInputAt(t){return $c(this.getNodeAtIndex(t,"input").inputTensors)}getOutputAt(t){return $c(this.getNodeAtIndex(t,"output").outputTensors)}get input(){if(this.inboundNodes.length>1)throw new vc("Layer "+this.name+' has multiple inbound nodes, hence the notion of "layer input" is ill-defined. Use `getInputAt(nodeIndex)` instead.');if(0===this.inboundNodes.length)throw new vc("Layer "+this.name+" is not connected, no input to return.");return $c(this.getNodeAtIndex(0,"input").inputTensors)}get output(){if(0===this.inboundNodes.length)throw new vc("Layer "+this.name+" has no inbound nodes.");if(this.inboundNodes.length>1)throw new vc("Layer "+this.name+' has multiple inbound nodes, hence the notion of "layer output" is ill-defined. Use `getOutputAt(nodeIndex)` instead.');return $c(this.getNodeAtIndex(0,"output").outputTensors)}get losses(){return this._losses}calculateLosses(){return this.losses.map(t=>t())}get updates(){return this._updates}get built(){return this._built}set built(t){this._built=t}get trainable(){return this.trainable_}set trainable(t){this._trainableWeights.forEach(e=>e.trainable=t),this.trainable_=t}get trainableWeights(){return this.trainable_?this._trainableWeights.filter(t=>t.trainable):[]}set trainableWeights(t){this._trainableWeights=t}get nonTrainableWeights(){return this.trainable?this._trainableWeights.filter(t=>!t.trainable).concat(this._nonTrainableWeights):this._trainableWeights.concat(this._nonTrainableWeights)}set nonTrainableWeights(t){this._nonTrainableWeights=t}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}get stateful(){return this._stateful}resetStates(){if(!this.stateful)throw new Error("Cannot call the resetStates() method of a non-stateful Layer object.")}assertInputCompatibility(t){if(t=Ac(t),null==this.inputSpec||0===this.inputSpec.length)return;const e=Ac(this.inputSpec);if(t.length!==e.length)throw new Nc(`Layer ${this.name} expects ${e.length} inputs, but it received ${t.length} input tensors. Input received: `+t);for(let n=0;n<t.length;n++){const s=t[n],r=e[n];if(null==r)continue;const a=s.rank;if(null!=r.ndim&&a!==r.ndim)throw new Nc(`Input ${n} is incompatible with layer ${this.name}: expected ndim=${r.ndim}, found ndim=${a}`);if(null!=r.maxNDim&&a>r.maxNDim)throw new Nc(`Input ${n} is incompatible with layer ${this.name}: expected max_ndim=${r.maxNDim}, found ndim=${a}`);if(null!=r.minNDim&&a<r.minNDim)throw new Nc(`Input ${n} is incompatible with layer ${this.name}: expected min_ndim=${r.minNDim}, found ndim=${a}.`);if(null!=r.dtype&&s.dtype!==r.dtype)throw new Nc(`Input ${n} is incompatible with layer ${this.name} : expected dtype=${r.dtype}, found dtype=${s.dtype}.`);if(r.axes){const t=s.shape;for(const e in r.axes){const s=Number(e),a=r.axes[e],i=s>=0?t[s]:t[t.length+s];if(null!=a&&-1===[a,null].indexOf(i))throw new Nc(`Input ${n} is incompatible with layer ${this.name}: expected axis ${s} of input shape to have value ${a} but got shape ${t}.`)}}if(null!=r.shape)for(let t=0;t<r.shape.length;++t){const e=r.shape[t],a=s.shape[t];if(null!=e&&null!=a&&e!==a)throw new Nc(`Input ${n} is incompatible with layer ${this.name}: expected shape=${r.shape}, found shape=${s.shape}.`)}}}call(t,e){return t}invokeCallHook(t,e){null!=this._callHook&&this._callHook(t,e)}setCallHook(t){this._callHook=t}clearCallHook(){this._callHook=null}apply(t,e){e=e||{},this.assertNotDisposed();const n=Ac(t);let s=!0;for(const t of n)if(!(t instanceof yp)){s=!1;break}let r=!0;for(const t of n)if(t instanceof yp){r=!1;break}if(s===r)throw new Nc("Arguments to apply() must be all SymbolicTensors or all Tensors");return uh(this.name,()=>{if(!this.built){this.assertInputCompatibility(t);const e=[];for(const n of Ac(t))e.push(n.shape);this.build($c(e)),this.built=!0,this.initialWeights&&this.setWeights(this.initialWeights),null===this._refCount&&r&&(this._refCount=1)}if(this.assertInputCompatibility(t),r){let s=this.call(t,e);const r=Ac(s),a=[];for(let t of r)-1!==n.indexOf(t)&&(t=t.clone()),a.push(t);if(s=$c(a),null!=this.activityRegularizer)throw new Ic("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return s}{const n=function(t){t=Ac(t);const e=[];for(const n of t)e.push(n.shape);return $c(e)}(t),s=this.computeOutputShape(n);let r;const a="float32";if(this.warnOnIncompatibleInputShape(Array.isArray(t)?n[0]:n),r=null!=s&&s.length>0&&Array.isArray(s[0])?s.map((n,s)=>new yp(a,n,this,Ac(t),e,this.name,s)):new yp(a,s,this,Ac(t),e,this.name),this.addInboundNode(t,r,null,null,n,s,e),this._refCount++,null!=this.activityRegularizer)throw new Ic("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return r}})}warnOnIncompatibleInputShape(t){if(null!=this.batchInputShape)if(t.length!==this.batchInputShape.length)console.warn("The rank of the input tensor provided (shape: "+JSON.stringify(t)+") does not match that of the "+`batchInputShape (${JSON.stringify(this.batchInputShape)}) of the layer `+this.name);else{let e=!1;this.batchInputShape.forEach((n,s)=>{null!=n&&null!=t[s]&&t[s]!==n&&(e=!0)}),e&&console.warn(`The shape of the input tensor (${JSON.stringify(t)}) does not match the expectation of layer ${this.name}: `+JSON.stringify(this.batchInputShape))}}get outputShape(){if(null==this.inboundNodes||0===this.inboundNodes.length)throw new vc(`The layer ${this.name} has never been called and thus has no defined output shape.`);const t=[];for(const e of this.inboundNodes){const n=JSON.stringify(e.outputShapes);-1===t.indexOf(n)&&t.push(n)}if(1===t.length){const t=this.inboundNodes[0].outputShapes;return Array.isArray(t)&&Array.isArray(t[0])&&1===t.length?t[0]:t}throw new vc(`The layer ${this.name} has multiple inbound nodes with different output shapes. Hence the notion of "output shape" is ill-defined for the layer.`)}countParams(){if(!this.built)throw new kc(`You tried to call countParams() on ${this.name}, but the layer is not built yet. Build it first by calling build(batchInputShape).`);return pp(this.weights)}build(t){this.built=!0}getWeights(t=!1){return fp(t?this.trainableWeights:this.weights)}setWeights(t){Jn(()=>{const e=this.weights;if(e.length!==t.length)throw new Nc(`You called setWeights(weights) on layer "${this.name}" with a weight list of length ${t.length}, but the layer was expecting ${e.length} weights. Provided weights: ${t}...`);if(0===e.length)return;const n=[],s=fp(e);for(let r=0;r<s.length;++r){const a=s[r],i=e[r],o=t[r];if(!d(a.shape,o.shape))throw new Nc(`Layer weight shape ${a.shape} not compatible with provided weight shape `+o.shape);n.push([i,o])}mp(n)})}addWeight(t,e,n,s,r,a,i){if(-1!==this._addedWeightNames.indexOf(t))throw new Nc(`Duplicate weight name ${t} for layer ${this.name}`);this._addedWeightNames.push(t),null==n&&(n="float32"),this.fastWeightInitDuringBuild&&(s=np("zeros"));const o=s.apply(e,n),l=new dp(o,n,t,a,i);return o.dispose(),null!=r&&this.addLoss(()=>r.apply(l.read())),null==a&&(a=!0),a?this._trainableWeights.push(l):this._nonTrainableWeights.push(l),l}setFastWeightInitDuringBuild(t){this.fastWeightInitDuringBuild=t}addLoss(t){null==t||Array.isArray(t)&&0===t.length||(t=Ac(t),void 0!==this._losses&&null!==this._losses&&this.losses.push(...t))}computeOutputShape(t){return t}computeMask(t,e){if(!this.supportsMasking){if(null!=e){if(!Array.isArray(e))throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);e.forEach(t=>{if(null!=t)throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`)})}return null}return e}addInboundNode(t,e,n,s,r,a,i=null){const o=Ac(t);e=Ac(e),n=Ac(n),s=Ac(s),r=up(r),a=up(a);const l=[],u=[],c=[];for(const t of o)l.push(t.sourceLayer),u.push(t.nodeIndex),c.push(t.tensorIndex);new xp({outboundLayer:this,inboundLayers:l,nodeIndices:u,tensorIndices:c,inputTensors:o,outputTensors:e,inputMasks:n,outputMasks:s,inputShapes:r,outputShapes:a},i);for(let t=0;t<e.length;t++)e[t].sourceLayer=this,e[t].nodeIndex=this.inboundNodes.length-1,e[t].tensorIndex=t}getConfig(){const t={name:this.name,trainable:this.trainable};return null!=this.batchInputShape&&(t.batchInputShape=this.batchInputShape),null!=this.dtype&&(t.dtype=this.dtype),t}disposeWeights(){return this.weights.forEach(t=>t.dispose()),this.weights.length}assertNotDisposed(){if(0===this._refCount)throw new Error(`Layer '${this.name}' is already disposed.`)}dispose(){if(!this.built)throw new Error(`Cannot dispose Layer ${this.name} because it has not been built yet.`);if(null===this._refCount)throw new Error(`Cannot dispose Layer ${this.name} because it has not been used yet.`);this.assertNotDisposed();let t=0;return 0==--this._refCount&&(t=this.disposeWeights()),{refCountAfterDispose:this._refCount,numDisposedVariables:t}}}class kp extends vp{constructor(t){if(super({dtype:t.dtype,name:null!=t.name?t.name:op("input").toString()}),null==t.batchSize&&(t.batchSize=null),null==t.sparse&&(t.sparse=!1),this.trainable=!1,this.built=!0,this.sparse=t.sparse,null!=t.inputShape&&null!=t.batchInputShape)throw new Nc("Only provide the inputShape OR batchInputShape argument to inputLayer, not both at the same time.");let e=t.batchInputShape;if(null==e){if(null==t.inputShape)throw new Nc("An InputLayer should be passed either a `batchInputShape` or an `inputShape`.");e=[t.batchSize].concat(t.inputShape)}else if(null!=t.batchSize)throw new Nc("Cannot specify batchSize if batchInputShape is specified when creating an InputLayer.");const n=t.dtype||"float32";this.batchInputShape=e,this.dtype=n,this.inputSpec=[{shape:e}];const s=new yp(this.dtype,this.batchInputShape,this,[],{},this.name);s.nodeIndex=0,s.tensorIndex=0,new xp({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:[s],outputTensors:[s],inputMasks:[null],outputMasks:[null],inputShapes:[e],outputShapes:[e]})}apply(t,e){throw new Nc("Cannot pass any input to an InputLayer's apply() method. InputLayer name: "+this.name)}dispose(){return{refCountAfterDispose:this._refCount,numDisposedVariables:0}}getConfig(){return{batchInputShape:this.batchInputShape,dtype:this.dtype,sparse:this.sparse,name:this.name}}}function Np(t){if(null==t.batchShape&&null==t.shape)throw new Error("Please provide to Input either a `shape` or a `batchShape` argument. Note that `shape` does not include the batch dimension.");if(null!=t.batchShape&&null!=t.shape)throw new Nc("Please provide either a `shape` or `batchShape` argument to Input, but not both.");let e=t.batchShape;null!=t.shape&&null==e&&(e=[null].concat(t.shape));let n=t.dtype;return null==n&&(n="float32"),new kp({batchInputShape:e,name:t.name,dtype:n,sparse:t.sparse}).inboundNodes[0].outputTensors[0]}async function Ip(t){if(null==t)return;const e=[],n=[],s=[];for(const r in t){const a=t[r];if("number"!=typeof a){const t=a;e.push(t.data()),n.push(r),s.push(t)}}if(e.length>0){const r=await Promise.all(e);for(let e=0;e<r.length;++e)t[n[e]]=r[e][0];Zn(s)}}function Cp(t){if(null!=t)for(const e in t){const n=t[e];"number"!=typeof n&&n.dispose()}}var Sp;kp.className="InputLayer",Wn(kp),function(t){t[t.SILENT=0]="SILENT",t[t.VERBOSE=1]="VERBOSE"}(Sp||(Sp={}));class Tp{constructor(){this.validationData=null}setParams(t){this.params=t}async onEpochBegin(t,e){}async onEpochEnd(t,e){}async onBatchBegin(t,e){}async onBatchEnd(t,e){}async onTrainBegin(t){}async onTrainEnd(t){}setModel(t){}}class Ep{constructor(t,e=10){null==t&&(t=[]),this.callbacks=t,this.queueLength=e}append(t){this.callbacks.push(t)}setParams(t){for(const e of this.callbacks)e.setParams(t)}setModel(t){for(const e of this.callbacks)e.setModel(t)}async onEpochBegin(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onEpochBegin(t,e)}async onEpochEnd(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onEpochEnd(t,e)}async onBatchBegin(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onBatchBegin(t,e)}async onBatchEnd(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onBatchEnd(t,e)}async onTrainBegin(t){null==t&&(t={});for(const e of this.callbacks)await e.onTrainBegin(t)}async onTrainEnd(t){null==t&&(t={});for(const e of this.callbacks)await e.onTrainEnd(t)}}class $p extends Tp{constructor(){super()}async onEpochBegin(t){this.seen=0,this.totals={}}async onBatchEnd(t,e){null==e&&(e={});const n=null==e.size?0:e.size;this.seen+=n;for(const t in e){const s=e[t];if("number"==typeof s)this.totals.hasOwnProperty(t)||(this.totals[t]=0),this.totals[t]=this.totals[t]+s*n;else{let e;t in this.totals?e=this.totals[t]:this.totals[t]=0;const r=Jn(()=>ss(this.totals[t],is(s,n)));this.totals[t]=r,null!=e&&e.dispose()}}}async onEpochEnd(t,e){if(null!=e)for(const t of this.params.metrics)null!=this.totals[t]&&("number"==typeof this.totals[t]?e[t]=this.totals[t]/this.seen:Jn(()=>{const n=is(as(1,this.seen),this.totals[t]);e[t]=n,this.totals[t].dispose(),Qn(e[t])}))}}class Ap extends Tp{async onTrainBegin(t){this.epoch=[],this.history={}}async onEpochEnd(t,e){null==e&&(e={}),this.epoch.push(t);for(const t in e)null==this.history[t]&&(this.history[t]=[]),this.history[t].push(e[t])}async syncData(){const t=[],e=[],n=[];for(const s in this.history){const r=this.history[s];for(let a=0;a<r.length;++a)if("number"!=typeof r[a]){const i=r[a];t.push(i.data()),e.push(s),n.push(a)}}const s=await Promise.all(t);for(let t=0;t<s.length;++t){this.history[e[t]][n[t]].dispose(),this.history[e[t]][n[t]]=s[t][0]}}}class Rp extends Tp{constructor(t,e){if(super(),this.currentEpoch=0,this.yieldEvery=e||"auto","auto"===this.yieldEvery&&(this.yieldEvery=125),"never"===this.yieldEvery&&null!=t.onYield)throw new Error("yieldEvery is `never` but you provided an `onYield` callback. Either change `yieldEvery` or remove the callback");R(this.yieldEvery)&&(this.maybeWait=function(t,e){let n,s=ht();return(...r)=>{const a=ht();return a-s<e||(s=a,n=t(...r)),n}}(this.maybeWait.bind(this),this.yieldEvery)),this.trainBegin=t.onTrainBegin,this.trainEnd=t.onTrainEnd,this.epochBegin=t.onEpochBegin,this.epochEnd=t.onEpochEnd,this.batchBegin=t.onBatchBegin,this.batchEnd=t.onBatchEnd,this.yield=t.onYield}async maybeWait(t,e,n){const s=[];null!=this.yield&&(await Ip(n),s.push(this.yield(t,e,n))),s.push(Pl()),await Promise.all(s)}async onEpochBegin(t,e){this.currentEpoch=t,null!=this.epochBegin&&(await Ip(e),await this.epochBegin(t,e))}async onEpochEnd(t,e){const n=[];null!=this.epochEnd&&(await Ip(e),n.push(this.epochEnd(t,e))),"epoch"===this.yieldEvery&&n.push(Pl()),await Promise.all(n)}async onBatchBegin(t,e){null!=this.batchBegin&&(await Ip(e),await this.batchBegin(t,e))}async onBatchEnd(t,e){const n=[];null!=this.batchEnd&&(await Ip(e),n.push(this.batchEnd(t,e))),"batch"===this.yieldEvery?n.push(Pl()):R(this.yieldEvery)&&n.push(this.maybeWait(this.currentEpoch,t,e)),await Promise.all(n)}async onTrainBegin(t){null!=this.trainBegin&&(await Ip(t),await this.trainBegin(t))}async onTrainEnd(t){null!=this.trainEnd&&(await Ip(t),await this.trainEnd(t))}}function Dp(t,e){if(null==t&&(t={}),t instanceof Tp)return[t];if(Array.isArray(t)&&t[0]instanceof Tp)return t;return Ac(t).map(t=>new Rp(t,e))}class _p{constructor(){}static registerCallbackConstructor(t,e){l(t>=0&&Number.isInteger(t),()=>"Verbosity level is expected to be an integer >= 0, but got "+t),_p.checkForDuplicate(e),null==_p.constructors[t]&&(_p.constructors[t]=[]),_p.constructors[t].push(e)}static checkForDuplicate(t){for(const e in _p.constructors){_p.constructors[+e].forEach(e=>{if(e===t)throw new Nc("Duplicate callback constructor.")})}}static clear(){_p.constructors={}}static createCallbacks(t){const e=[];for(const n in _p.constructors){const s=+n;t>=s&&e.push(..._p.constructors[s])}return e.map(t=>new t)}}function Fp(t,e,n,s,r,a,i,o,l){const u=new Ap,c=[new $p,..._p.createCallbacks(e)];null!=t&&c.push(...t),c.push(u);const h=new Ep(c);return h.setParams({epochs:n,initialEpoch:s,samples:r,steps:a,batchSize:i,verbose:e,doValidation:o,metrics:l}),{callbackList:h,history:u}}function Op(t,e={},n=!1){return Oc(t,Pn.getMap().classNameMap,e,"layer",n)}function Mp(t,e){return Jn(()=>{"float32"!==t.dtype&&(t=t.asType("float32"));const n=da(Ah(t),e,!0),s=zr(n.shape,wc()),r=Bi(Yr(n,s));return as(t,r)})}function Lp(t,e){return Jn(()=>Ca(Ah(pa(e,t)),-1))}function zp(t,e){return Jn(()=>Ca(os(pa(e,t)),-1))}function Bp(t,e){return Jn(()=>{const n=pa(t,e),s=rr(os(t),wc(),Number.MAX_VALUE),r=os(as(n,s));return is(100,Ca(r,-1))})}function Pp(t,e){return Jn(()=>{const n=rr(e,wc(),Number.MAX_VALUE),s=sa(ss(1,n)),r=rr(t,wc(),Number.MAX_VALUE),a=sa(ss(1,r));return Ca(Ah(pa(s,a)),-1)})}function Wp(t,e,n=!1){return Jn(()=>{if(n)e=Di(e);else{const t=da(e,e.shape.length-1,!0);e=as(e,t)}return e=rr(e,wc(),1-wc()),la(da(is(t.toFloat(),sa(e)),e.shape.length-1))})}function Vp(t,e,n=!1){return Jn(()=>{const s=Br(function(t){const e=[fh(t.shape)];return t.reshape(e)}(t)).toInt(),r=(e=rr(e,wc(),1-wc())).shape;return Wp(un(s,r[r.length-1]).reshape(r),e,n)})}function Up(t,e){return Jn(()=>{let n;return n=rr(e,wc(),1-wc()),n=sa(as(n,pa(1,n))),Ca(function(t,e){if(!d(t.shape,e.shape))throw new Nc(`logits and labels must have the same shape, but got shapes ${JSON.stringify(t.shape)} and ${JSON.stringify(e.shape)}`);return Jn(()=>{const n=e.relu(),s=e.abs().neg();return n.sub(e.mul(t)).add(s.exp().log1p())})}(t,n),-1)})}function Gp(t,e){return Jn(()=>{const n=rr(t,wc(),1),s=rr(e,wc(),1);return da(is(t,sa(as(n,s))),-1)})}function Hp(t,e){return Jn(()=>{const n=Mp(t,-1),s=Mp(e,-1),r=is(n,s);return la(da(r,-1))})}_p.constructors={};const jp={meanSquaredError:Lp,meanAbsoluteError:zp,meanAbsolutePercentageError:Bp,meanSquaredLogarithmicError:Pp,squaredHinge:function(t,e){return Jn(()=>{const n=Yr(0,pa(1,is(t,e)));return Ca(Ah(n),-1)})},hinge:function(t,e){return Jn(()=>{const n=Yr(0,pa(1,is(t,e)));return Ca(n,-1)})},categoricalHinge:function(t,e){return Jn(()=>{const n=da(is(t,e),-1),s=ha(is(pa(1,t),e),-1);return Yr(0,ss(1,pa(s,n)))})},logcosh:function(t,e){return Jn(()=>{const n=Math.log(2),s=pa(e,t),r=pa(ss(s,ua(is(-2,s))),n);return Ca(r,-1)})},categoricalCrossentropy:Wp,sparseCategoricalCrossentropy:Vp,binaryCrossentropy:Up,kullbackLeiblerDivergence:Gp,poisson:function(t,e){return Jn(()=>{const n=sa(ss(wc(),e));return Ca(pa(e,is(t,n)),-1)})},cosineProximity:Hp};function qp(t){if("string"==typeof t){if(t in jp)return jp[t];let e="Unknown loss "+t;throw t.toLowerCase().includes("softmaxcrossentropy")&&(e=`Unknown loss ${t}. Use "categoricalCrossentropy" as the string name for tf.losses.softmaxCrossEntropy`),new Nc(e)}return t}function Kp(t,e){return Jn(()=>{const n=is(.5,Ma(e)),s=xh(Gr(e,n),t.dtype);return Ca(Sr(t,s),-1)})}function Xp(t,e){return Jn(()=>xh(Sr(vs(t,-1),vs(e,-1)),"float32"))}function Yp(t,e){return Jn(()=>ga(t.equal(1),e.equal(1)).sum().cast("float32"))}function Jp(t,e){return Jn(()=>{const n=Yp(t,e),s=function(t,e){return Jn(()=>ga(t.equal(0),e.equal(1)).sum().cast("float32"))}(t,e),r=n.add(s);return Tr(Gr(r,0),n.div(r),0).cast("float32")})}function Zp(t,e){return Jn(()=>{const n=Yp(t,e),s=function(t,e){return Jn(()=>ga(t.equal(1),e.equal(0)).sum().cast("float32"))}(t,e),r=n.add(s);return Tr(Gr(r,0),n.div(r),0).cast("float32")})}function Qp(t,e){return Up(t,e)}function td(t,e){return t.rank===e.rank&&(t=t.squeeze([t.rank-1])),(e=e.argMax(-1)).dtype!==t.dtype&&(e=e.asType(t.dtype)),Sr(t,e).asType("float32")}const ed=Wp,nd=Vp,sd={binaryAccuracy:Kp,categoricalAccuracy:Xp,precision:Jp,categoricalCrossentropy:ed,sparseCategoricalCrossentropy:nd,mse:Lp,MSE:Lp,mae:zp,MAE:zp,mape:Bp,MAPE:Bp,cosine:Hp};function rd(t){if("string"==typeof t&&t in sd)return sd[t];if("string"!=typeof t&&null!=t)return t;throw new Nc("Unknown metric "+t)}function ad(t){if(Tc(null!==t,"Unknown LossOrMetricFn "+t),"string"==typeof t)return t;{let e;for(const n of Object.keys(jp))if(jp[n]===t){e=n;break}if(void 0!==e)return e;for(const n of Object.keys(sd))if(sd[n]===t){e=n;break}return void 0!==e?e:t.name}}function id(t,e,n=!1){if(null==t||"object"!=typeof t||Object.getPrototypeOf(t)!==Object.prototype||!function t(e){if(null===e)return!0;if("object"==typeof e){if(Object.getPrototypeOf(e)===Object.prototype){const n=Object.keys(e);for(const s of n){if("string"!=typeof s)return!1;if(!t(e[s]))return!1}return!0}if(Array.isArray(e)){for(const n of e)if(!t(n))return!1;return!0}return!1}{const t=typeof e;return"string"===t||"number"===t||"boolean"===t}}(t))throw new Error("User-defined metadata is expected to be a JSON object, but is not.");if(n){const n=JSON.stringify(t);n.length>1048576&&console.warn(`User-defined metadata of model "${e}" is too large in size (length=${n.length} when serialized). It is not recommended to store such large objects in user-defined metadata. Please make sure its serialized length is <= 1048576.`)}}function od(t,e,n,s=console.log){const r=function(t){let e=!0;const n=[],s=[];for(const e in t.nodesByDepth)n.push(t.nodesByDepth[e]);for(const t of n){if(t.length>1||1===t.length&&t[0].inboundLayers.length>1){e=!1;break}s.push(...t)}if(e)for(const n of t.layers){let t=!1;for(const r of n.inboundNodes)if(-1!==s.indexOf(r)){if(t){e=!1;break}t=!0}if(!e)break}return e}(t),a=["Layer (type)","Output shape","Param #"];let i;if(r?(e=e||65,n=n||[.45,.85,1]):(e=e||98,n=n||[.33,.55,.67,1]),n[n.length-1]<=1&&(n=n.map(t=>Math.floor(e*t))),!r){a.push("Receives inputs"),i=[];for(const e in t.nodesByDepth)i.push(...t.nodesByDepth[e])}s("_".repeat(e)),ld(a,n,s),s("=".repeat(e));const o=t.layers;for(let t=0;t<o.length;++t)r?ud(o[t],n,s):cd(o[t],n,i,s),s((t===o.length-1?"=":"_").repeat(e));t.checkTrainableWeightsConsistency();const l=function(t){let e;e=null!=t.collectedTrainableWeights?pp(t.collectedTrainableWeights):pp(t.trainableWeights);return e}(t),u=pp(t.nonTrainableWeights);s("Total params: "+(l+u)),s("Trainable params: "+l),s("Non-trainable params: "+u),s("_".repeat(e))}function ld(t,e,n=console.log){let s="";for(let n=0;n<t.length;++n)n>0&&(s=s.slice(0,s.length-1)+" "),s+=t[n],s=s.slice(0,e[n]),s+=" ".repeat(e[n]-s.length);n(s)}function ud(t,e,n){let s;try{s=JSON.stringify(t.outputShape)}catch(t){s="multiple"}ld([`${t.name} (${t.getClassName()})`,s,t.countParams().toString()],e,n)}function cd(t,e,n,s){let r;try{r=JSON.stringify(t.outputShape)}catch(t){r="multiple"}const a=[];for(const e of t.inboundNodes)if(!(null!=n&&n.length>0&&-1===n.indexOf(e)))for(let t=0;t<e.inboundLayers.length;++t){const n=e.inboundLayers[t].name,s=e.nodeIndices[t],r=e.tensorIndices[t];a.push(`${n}[${s}][${r}]`)}const i=t.name,o=t.getClassName(),l=0===a.length?"":a[0];ld([`${i} (${o})`,r,t.countParams().toString(),l],e,s);for(let t=1;t<a.length;++t)ld(["","","",a[t]],e,s)}function hd(t,e,n){return("inboundNodes"===t||"outputLayers"===t||"inputLayers"===t)&&0===e&&"string"==typeof n}function pd(t,e){if(null===t)return null;if("string"==typeof t)return Dc(t);if("number"==typeof t||"boolean"==typeof t)return t;if(t instanceof Array){const n=[],s=t.length;for(let r=0;r<s;++r){const s=t[r];hd(e,r,s)?n.push(s):n.push(pd(s,e))}return n}{const e={};for(const n of Object.keys(t)){const s=t[n];if("name"===n&&"string"==typeof s)e[n]=s;else{const t=Dc(n);e[t]=pd(s,t)}}return e}}class dd{constructor(t){if(this.id2Value={},this.id2Mask={},this.name2Id={},t instanceof dd)for(const e in t.id2Value)this.id2Value[e]=t.id2Value[e],e in t.id2Mask&&(this.id2Mask[e]=t.id2Mask[e]);else{if(null==t)return;for(const e of t)this.add(e.key,e.value)}}add(t,e,n){if(null!=this.id2Value[t.id])throw new Nc(`Duplicate key: name=${t.name}, id=${t.id}`);return this.id2Value[t.id]=function(t,e){if(null==t.dtype||t.dtype===e.dtype)return e;try{return Ve(e,t.dtype)}catch(n){throw new Nc(`The dtype of the feed (${e.dtype}) can not be cast to the dtype of the key '${t.name}' (${t.dtype}).`)}}(t,e),this.name2Id[t.name]=t.id,null!=n&&(this.id2Mask[t.id]=n),this}addFeed(t){this.add(t.key,t.value)}hasKey(t){return null!=this.id2Value[t.id]}names(){return Object.keys(this.name2Id)}getValue(t){if(t instanceof yp){if(null==this.id2Value[t.id])throw new Nc("Nonexistent key: "+t.name);return this.id2Value[t.id]}{const e=this.name2Id[t];if(null==e)throw new Nc("Feed dict has no SymbolicTensor name: "+t);return this.id2Value[e]}}getMask(t){if(t instanceof yp){if(null==this.id2Value[t.id])throw new Nc("Nonexistent key: "+t.name);return this.id2Mask[t.id]}{const e=this.name2Id[t];if(null==e)throw new Nc("Feed dict has no SymbolicTensor name: "+t);return this.id2Mask[e]}}disposeMasks(){null!=this.id2Mask&&Zn(this.id2Mask)}}const fd={},md={};function gd(t,e,n,s){const r=null!=n&&n.training,a=Array.isArray(t),i=a?t:[t],o=i.map(t=>t.name),u=[],c=e.names();for(const t of o)-1!==c.indexOf(t)?u.push(e.getValue(t)):u.push(null);null!=s&&(s.maxNumTensors=-1/0,s.minNumTensors=1/0);const h=o.join(",")+"|"+e.names().join(",");let p,d;if(null==fd[h]){const t=function(t,e){l(null!=t&&t.length>0,()=>"Expected at least one fetch, got none");let n=[],s={};if(1===t.length){const r=bd(t[0],e);n=r.sorted,s=r.recipientMap}else{const r=new Set;for(const a of t){const{sorted:t,recipientMap:i}=bd(a,e);for(const e of t)r.has(e.name)||(n.push(e),r.add(e.name));for(const t in i)null==s[t]&&(s[t]=new Set),i[t].forEach(e=>s[t].add(e))}}return{sorted:n,recipientCounts:yd(s)}}(i,e);p=t.sorted,d=t.recipientCounts,fd[h]=p,md[h]=d}p=fd[h],d={},r||Object.assign(d,md[h]);const f=new dd(e);for(let t=0;t<p.length;++t){if(null!=s){const t=Yn().numTensors;t>s.maxNumTensors&&(s.maxNumTensors=t),t<s.minNumTensors&&(s.minNumTensors=t)}const a=p[t],i=a.sourceLayer;if(i instanceof kp)continue;const l=[],c=[],h=[];let m=!1;for(const t of a.inputs){const n=f.getValue(t),s=f.getMask(t);l.push(n),c.push(s),null!=s&&(m=!0),r||(d[t.name]--,0!==d[t.name]||e.hasKey(t)||-1!==o.indexOf(t.name)||n.isDisposed||!0===t.sourceLayer.stateful||h.push(n))}m&&((n=n||{}).mask=c[0]);const g=Ac(i.apply(l,n));let y=null;i.supportsMasking&&(y=i.computeMask(l,c));const b=xd(a),x=Array.isArray(b)?b:[b];for(let t=0;t<x.length;++t){f.hasKey(x[t])||f.add(x[t],g[t],Array.isArray(y)?y[0]:y);const e=o.indexOf(x[t].name);-1!==e&&(u[e]=g[t])}r||Zn(h)}return f.disposeMasks(),a?u:u[0]}function yd(t){const e={};for(const n in t)e[n]=t[n].size;return e}function bd(t,e){const n=new Set,s=[],r={};for(const t of e.names())n.add(t);const a=[],i=[];for(a.push(t);a.length>0;){const t=a[a.length-1];if(n.has(t.name)){a.pop();continue}const e=i[i.length-1]===a.length-1;if(0===t.inputs.length||e)a.pop(),s.push(t),n.add(t.name),e&&i.pop();else{i.push(a.length-1);for(const e of t.inputs)null==r[e.name]&&(r[e.name]=new Set),r[e.name].add(t.name),n.has(e.name)||a.push(e)}}return{sorted:s,recipientMap:r}}function xd(t){let e;if(1===t.sourceLayer.inboundNodes.length)e=t.sourceLayer.output;else{let n=null;for(let e=0;e<t.sourceLayer.inboundNodes.length;++e)for(const s of t.sourceLayer.inboundNodes[e].outputTensors)if(s.id===t.id){n=e;break}e=t.sourceLayer.getOutputAt(n)}return e}class wd extends vp{constructor(t){if(super({}),this.containerNodes=new Set,this.name=t.name,null==this.name){const t=this.getClassName().toLowerCase();this.name=op(t)}if(this.supportsMasking=!1,this.trainable_=!0,Array.isArray(t.inputs)?this.inputs=t.inputs.slice():this.inputs=[t.inputs],Array.isArray(t.outputs)?this.outputs=t.outputs.slice():this.outputs=[t.outputs],Lc(this.inputs).length!==this.inputs.length)throw new Nc("The list of inputs passed to the model is redundant. All inputs should only appear once. Found: "+this.inputs.map(t=>t.name));Lc(this.outputs).length!==this.outputs.length&&console.warn("The list of outputs passed to the model is redundant. All outputs should only appear once. Found: "+this.outputs.map(t=>t.name)),this.inputLayers=[],this.inputLayersNodeIndices=[],this.inputLayersTensorIndices=[],this.outputLayers=[],this.outputLayersNodeIndices=[],this.outputLayersTensorIndices=[],this.layers=[],this.internalContainerRefs=[];for(const t of this.outputs){const e=t.sourceLayer,n=t.nodeIndex,s=t.tensorIndex;this.outputLayers.push(e),this.outputLayersNodeIndices.push(n),this.outputLayersTensorIndices.push(s)}for(const t of this.inputs){const e=t.sourceLayer,n=t.nodeIndex,s=t.tensorIndex;Tc(0===n,"input layer has >1 nodes"),Tc(0===s,"input layer has >1 tensors"),this.inputLayers.push(e),this.inputLayersNodeIndices.push(n),this.inputLayersTensorIndices.push(s)}this.inputNames=[],this.outputNames=[],this.feedInputShapes=[],this.feedInputNames=[],this.feedOutputNames=[];for(let e=0;e<this.inputLayers.length;e++){const n=this.inputLayers[e];if(!(n instanceof kp))throw new TypeError(`Input layers to a LayersModel must be InputLayer objects. Received inputs: ${t.inputs}. Input ${e} (0-based) originates from layer type ${n.getClassName()}.`);this.inputNames.push(n.name),this.feedInputShapes.push(n.batchInputShape),this.feedInputNames.push(n.name)}for(const t of this.outputLayers)this.outputNames.push(t.name);this.internalInputShapes=this.inputs.map(t=>t.shape),this.internalOutputShapes=this.outputs.map(t=>t.shape);const e={},n={},s={},r={},a={},i=[],o=(t,e,n,s,r,l)=>{null!=s&&null!=r&&null!=l||(s=t.sourceLayer,r=t.nodeIndex,l=t.tensorIndex);const u=s.inboundNodes[r];if(-1!==n.indexOf(u))throw new kc(`The tensor ${t.name} at layer "${s.name}" is part of a cycle.`);if(-1!==e.indexOf(u))return;this.containerNodes.add(wd.nodeKey(s,r)),s.id in a||(a[s.id]=Object.keys(a).length),-1===n.indexOf(u)&&n.push(u);const c=u.inboundLayers.length;for(let t=0;t<c;t++){const s=u.inputTensors[t],r=u.inboundLayers[t],a=u.nodeIndices[t],i=u.tensorIndices[t];o(s,e,n,r,a,i)}for(e.push(u);n.indexOf(u)>=0;)n.splice(n.indexOf(u),1);i.push(u)},l=[],u=[];for(const t of this.outputs)o(t,l,u);const c=i.slice().reverse();for(const t of c){n[t.id]=t,t.id in e||(e[t.id]=0);let a=e[t.id];const i=null==s[t.outboundLayer.id]?0:s[t.outboundLayer.id];a=Math.max(a,i),s[t.outboundLayer.id]=a,r[t.outboundLayer.id]=t.outboundLayer,e[t.id]=a;for(let s=0;s<t.inboundLayers.length;s++){const r=t.inboundLayers[s],i=t.nodeIndices[s],o=r.inboundNodes[i],l=null==e[o.id]?0:e[o.id];e[o.id]=Math.max(a+1,l),n[o.id]=o}}const h={};for(const t in e){const s=e[t];s in h||(h[s]=[]),h[s].push(n[t])}const p={};for(const t in s){const e=s[t];e in p||(p[e]=[]),p[e].push(r[t])}let d=Object.keys(p).map(t=>parseInt(t,10)).sort(Mc);this.layers=[];for(const t of d){const e=p[t];e.sort((t,e)=>{const n=a[t.id],s=a[e.id];return n<s?-1:n>s?1:0});for(const t of e)t instanceof wd&&this.internalContainerRefs.push(t),this.layers.push(t)}this.layersByDepth=p,d=Object.keys(h).map(t=>parseInt(t,10)).sort(Mc);const f=this.inputs.slice(),m=[];for(const t of d)for(const e of h[t]){const t=e.outboundLayer;if(null!=t){for(const n of e.inputTensors)if(-1===f.indexOf(n))throw new kc("Graph disconnected: cannot obtain value for tensor "+n+` at layer "${t.name}". The following previous layers were accessed without issue: `+m);for(const t of e.outputTensors)f.push(t);m.push(t.name)}}this.nodesByDepth=h;const g=this.layers.map(t=>t.name);for(const t of g){const e=g.filter(e=>e===t).length;if(1!==e)throw new kc(`The name "${t}" is used ${e} times in the model. All layer names should be unique. Layer names: `+JSON.stringify(g))}this.outboundNodes=[],this.inboundNodes=[],new xp({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:this.inputs.map(t=>null),outputMasks:this.outputs.map(t=>null),inputShapes:this.inputs.map(t=>t.shape),outputShapes:this.outputs.map(t=>t.shape)}),this.built=!0,this._refCount=1}assertNotDisposed(){if(0===this._refCount)throw new Error(`Container '${this.name}' is already disposed.`)}dispose(){this.assertNotDisposed();const t={refCountAfterDispose:null,numDisposedVariables:0};if(0==--this._refCount){for(const e of this.layers)t.numDisposedVariables+=e.dispose().numDisposedVariables;for(const e of this.internalContainerRefs)t.numDisposedVariables+=e.dispose().numDisposedVariables}return t.refCountAfterDispose=this._refCount,t}get trainable(){return this.trainable_}set trainable(t){this.layers.forEach(e=>{e._trainableWeights.forEach(e=>e.trainable=t)}),this.trainable_=t}get trainableWeights(){if(this._trainableWeights.length>0)throw new Nc("Container instance unexpectedly contains _trainableWeights.The trainable weights of a Container are a union of the trainable weights of its consituent Layers. Its own _trainableWeights must remain an empty Array.");if(!this.trainable)return[];let t=[];for(const e of this.layers)t=t.concat(e.trainableWeights);return t}get nonTrainableWeights(){const t=[];for(const e of this.layers)t.push(...e.nonTrainableWeights);if(!this.trainable){const e=[];for(const t of this.layers)e.push(...t.trainableWeights);return e.concat(t)}return t}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}loadWeights(t,e=!0){const n={};let s=0;for(const t of this.layers)for(const e of t.weights){if(null!=n[e.originalName])throw new Nc("Duplicate weight name: "+e.originalName);n[e.originalName]=e,s++}const r=[];for(const s in t){let a=s;if(null==n[s]){const t=s.split("/");a=t.slice(0,-2).concat([t[t.length-1]]).join("/")}if(null!=n[a])r.push([n[a],t[s]]);else if(e)throw new Nc("Provided weight data has no target variable: "+s);delete n[a]}if(e){const t=[];for(const e in n)t.push(e);if(t.length>0)throw new Nc(`${t.length} of ${s} weights are not set: `+t)}mp(r)}updatedConfig(){const t=this.getConfig(),e={};return e.className=this.getClassName(),e.config=t,e.kerasVersion="tfjs-layers 2.7.0",e.backend="TensorFlow.js",e}toJSON(t,e=!0){const n=function t(e,n){if(null==e)return null;if("string"==typeof e)return Rc(e);if("number"==typeof e||"boolean"==typeof e)return e;if(e instanceof Array){const s=[],r=e.length;for(let a=0;a<r;++a){const r=e[a];hd(n,a,r)?s.push(r):s.push(t(r,n))}return s}{const n={};for(const s of Object.keys(e)){const r=e[s],a=Rc(s);n[a]="name"!==s&&"className"!==s||"string"!=typeof r?t(r,s):r}return n}}(this.updatedConfig());return e?JSON.stringify(n):n}call(t,e){return Jn(()=>{t=Ac(t);const n=new dd;for(let e=0;e<this.inputs.length;++e)n.add(this.inputs[e],t[e]);return gd(this.outputs,n,e)})}computeMask(t,e){return Jn(()=>{let n;return t=Ac(t),n=null==e?Sc(null,t.length):Ac(e),this.runInternalGraph(t,n)[1]})}computeOutputShape(t){const e=up(t);if(e.length!==this.inputLayers.length)throw new Nc(`Invalid inputShape argument ${t}: model has ${this.inputLayers.length} tensor inputs.`);const n={};for(let t=0;t<e.length;t++){const s=this.inputLayers[t],r=e[t];n[s.name+"_0_0"]=r}const s=Object.keys(this.nodesByDepth).map(t=>parseInt(t,10)).sort(Mc);if(s.length>1)for(const t of s){const e=this.nodesByDepth[t];for(const t of e){const e=t.outboundLayer;if(-1!==this.inputLayers.map(t=>t.id).indexOf(e.id))continue;const s=[];for(let e=0;e<t.inboundLayers.length;e++){const r=t.inboundLayers[e],a=t.nodeIndices[e],i=t.tensorIndices[e],o=n[`${r.name}_${a}_${i}`];s.push(o)}const r=up(e.computeOutputShape($c(s))),a=e.inboundNodes.indexOf(t);for(let t=0;t<r.length;t++){n[`${e.name}_${a}_${t}`]=r[t]}}}const r=[],a=[];for(let t=0;t<this.outputLayers.length;t++){const e=this.outputLayers[t],n=this.outputLayersNodeIndices[t],s=this.outputLayersTensorIndices[t],r=`${e.name}_${n}_${s}`;a.push(r)}for(let t=0;t<a.length;t++){const e=a[t];Tc(e in n),r.push(n[e])}return $c(r)}runInternalGraph(t,e){null==e&&(e=Sc(null,t.length));const n={};for(let s=0;s<this.inputs.length;++s){const r=this.inputs[s],a=t[s],i=e[s];n[r.id]=[a,i]}const s=Object.keys(this.nodesByDepth).map(t=>parseInt(t,10)).sort(Mc);for(const t of s){const e=this.nodesByDepth[t];for(const t of e){const e=t.outboundLayer,s=t.inputTensors,r=t.outputTensors,a=new Array;for(const t of s)t.id in n&&a.push(n[t.id]);if(a.length===s.length){let s,i,o,l,u={};if(null!=t.callArgs&&(u=t.callArgs),1===a.length){const[t,n]=a[0];null==u.mask&&(u.mask=n),o=Ac(e.call(t,u)),l=Ac(e.computeMask(t,n)),s=[t],i=[n]}else s=a.map(t=>t[0]),i=a.map(t=>t[1]),null==u.mask&&(u.mask=i),o=Ac(e.call(s,u)),l=Ac(e.computeMask(s,i));if(e.activityRegularizer)throw new Ic("LayersModel invocation with concrete Tensor value(s) in the presence of activity regularizer(s) is not supported yet.");for(let t=0;t<r.length;++t){const e=r[t],s=o[t],a=l[t];n[e.id]=[s,a]}}}}const r=[],a=[],i=[];for(const t of this.outputs){Tc(t.id in n,`Could not compute output ${t.name} : ${t.id}`);const[e,s]=n[t.id];i.push(e.shape),r.push(e),a.push(s)}return[r,a,i]}buildNodeConversionMap(t){const e={};let n;for(const t of this.layers){n=t instanceof wd?1:0;for(let s=0;s<t.inboundNodes.length;s++){const r=wd.nodeKey(t,s);this.containerNodes.has(r)&&(e[r]=n,n+=1)}}return e}getLayer(t,e){if(null!=e){if(this.layers.length<=e)throw new Nc(`Was asked to retrieve layer at index ${e}, but model only has ${this.layers.length} layer(s).`);return this.layers[e]}if(null==t)throw new Nc("Provide either a layer name or layer index");for(const e of this.layers)if(e.name===t)return e;throw new Nc("No such layer: "+t)}calculateLosses(){return Jn(()=>{const t=[];for(const e of this.layers)for(let n=0;n<e.inboundNodes.length;++n){const s=wd.nodeKey(e,n);this.containerNodes.has(s)&&t.push(...e.calculateLosses())}return t})}getConfig(){const t={name:this.name},e=this.buildNodeConversionMap(this.layers),n=[];for(const t of this.layers){const s=t.getClassName(),r=t.getConfig(),a=[];for(let n=0;n<t.inboundNodes.length;n++){const s=t.inboundNodes[n],r=wd.nodeKey(t,n);let i={};if(this.containerNodes.has(r)){if(s.callArgs)try{JSON.stringify(s.callArgs),i=s.callArgs}catch(e){console.warn(`Layer ${t.name} was passed non-serializable keyword arguments: `+s.callArgs+". They will not be included in the serialized model (and thus will be missing at deserialization time)."),i={}}if(s.inboundLayers.length>0){const t=[];for(let n=0;n<s.inboundLayers.length;n++){const r=s.inboundLayers[n],a=s.nodeIndices[n],o=s.tensorIndices[n];let l=e[wd.nodeKey(r,a)];null==l&&(l=0),t.push([r.name,l,o,i])}a.push(t)}}}const i={};i.name=t.name,i.className=s,i.config=r,i.inboundNodes=a,n.push(i)}t.layers=n;const s=[];for(let t=0;t<this.inputLayers.length;t++){const n=this.inputLayers[t],r=this.inputLayersNodeIndices[t],a=wd.nodeKey(n,r);if(!this.containerNodes.has(a))continue;let i=e[a];null==i&&(i=0);const o=this.inputLayersTensorIndices[t];s.push([n.name,i,o])}t.inputLayers=s;const r=[];for(let t=0;t<this.outputLayers.length;t++){const n=this.outputLayers[t],s=this.outputLayersNodeIndices[t],a=wd.nodeKey(n,s);if(!this.containerNodes.has(a))continue;let i=e[a];null==i&&(i=0);const o=this.outputLayersTensorIndices[t];r.push([n.name,i,o])}return t.outputLayers=r,t}static fromConfig(t,e,n={},s=!1){const r={},a={};function i(t,e){t.name in a?a[t.name].push(e):a[t.name]=[e]}function o(t,e){const n=[];let s;for(const a of e){const o=a[0],l=a[1],u=a[2];if(s=null==a[3]?{}:a[3],!(o in r))return void i(t,e);const c=r[o];if(c.inboundNodes.length<=l)return void i(t,e);const h=c.inboundNodes[l];n.push(h.outputTensors[u])}n.length>0&&t.apply($c(n),s)}function l(t){const n=t.name,a=Op(t,null!=e.customObjects?e.customObjects:{});a.setFastWeightInitDuringBuild(s),r[n]=a,t.inboundNodes.forEach(t=>{if(!(t instanceof Array))throw new Nc("Corrupted configuration, expected array for nodeData: "+t);i(a,t)})}const u=e.name,c=e.layers;for(const t of c)l(t);for(;!zc(a);)for(const t of c){const e=r[t.name];if(e.name in a){const t=a[e.name];delete a[e.name];for(const n of t)o(e,n)}}const h=[],p=[],d=e.inputLayers;for(const t of d){const e=t[0],n=t[1],s=t[2];Tc(e in r);const a=r[e].inboundNodes[n].outputTensors;h.push(a[s])}const f=e.outputLayers;for(const t of f){const e=t[0],n=t[1],s=t[2];Tc(e in r);const a=r[e].inboundNodes[n].outputTensors;p.push(a[s])}return new t({inputs:h,outputs:p,name:u})}get stateful(){if(this._stateful)throw new Nc("Container instance unexpectedly has _stateful = true. The statefulness of a Container is determined by the Layers it contains. Its _stateful property must remain the default false.");for(const t of this.layers)if(t.stateful)return!0;return!1}resetStates(){Jn(()=>{this.layers.forEach(t=>{t.stateful&&t.resetStates()})})}}function vd(t,e,n){const s=e.length;if(null==t||Array.isArray(t)&&0===t.length)return e.map(t=>null);if(1===s)return Array.isArray(t)&&1===t.length?t:"object"==typeof t&&e[0]in t?[t[e[0]]]:[t];if(Array.isArray(t)){if(t.length!==s)throw new Error(`Provided ${n} is an array of ${t.length} element(s), but the model has ${s} outputs. Make sure a set of weights is provided for each model output.`);return t}if("object"==typeof t&&Object.keys(t).length>0&&"object"==typeof t[Object.keys(t)[0]]){const n=[];return e.forEach(e=>{e in t?n.push(t[e]):n.push(null)}),n}throw new Error(`The model has multiple (${s}) outputs, so ${n} must be either an array with ${s} elements or an object with ${e} keys. Provided ${n} not understood: ${JSON.stringify(t)}`)}function kd(t,e){return vd(t,e,"classWeight")}async function Nd(t,e,n,s){if(null!=e||null!=s)throw new Error("Support sampleWeight is not implemented yet");if(null!=n){const e=Jn(()=>{if(1===t.shape.length)return t.clone();if(2===t.shape.length){if(t.shape[1]>1){const e=1;return t.argMax(e)}if(1===t.shape[1])return t.reshape([t.shape[0]]);throw new Error(`Encountered unexpected last-dimension size (${t.shape[1]}) during handling of class weights. The size is expected to be >= 1.`)}throw new Error(`Unexpected rank of target (y) tensor (${t.rank}) during handling of class weights. The rank is expected to be 1 or 2.`)}),s=Array.from(await e.data());Zn(e);const r=[];return s.forEach(t=>{if(null==n[t])throw new Error(`classWeight must contain all classes in the training data. The class ${t} exists in the data but not in classWeight`);r.push(n[t])}),ci(r,"float32")}return null}function Id(t,e){return is(t,e)}function Cd(t,e){let n,s;const r=e;n=r.xs,s=r.ys,l(null!=n&&null!=s,()=>"A Dataset iterator for fitDataset() is expected to generate objects of the form `{xs: xVal, ys: yVal}`, where the two values may be `tf.Tensor`, an array of Tensors, or a map of string to Tensor.  The provided Dataset instead generates "+e);const a=Sd("input",t.inputNames,n),i=Sd("output",t.outputNames,s),o=a[0].shape[0];l(a.length===t.inputs.length,()=>`LayersModel has ${t.inputs.length} inputs, but the dataset provides ${a.length} inputs.  (Expected input keys: `+JSON.stringify(t.inputNames)+")"),l(i.length===t.outputs.length,()=>`LayersModel has ${t.outputs.length} outputs, but the dataset provides ${i.length} outputs.  (Expected output keys: `+JSON.stringify(t.outputNames)+")");for(let e=0;e<a.length;e++)l(a[e].shape[0]===o,()=>`Batch size mismatch: input ${t.inputNames[e]} has ${a[e].shape[0]}; expected  ${o} based on input ${t.inputNames[0]}.`);for(let e=0;e<i.length;e++)l(i[e].shape[0]===o,()=>`Batch size mismatch: output ${t.outputNames[e]} has ${i[e].shape[0]}; expected  ${o} based on input ${t.inputNames[0]}.`);return{xs:a,ys:i}}function Sd(t,e,n){if(n instanceof Tt)return[n];if(Array.isArray(n))return l(n.length===e.length,()=>`Received an array of ${n.length} Tensors, but expected ${e.length} to match the ${t} keys ${e}.`),n;{const s=[];for(const r of e){if(null==n[r])throw new Nc(`The feature data generated by the dataset lacks the required ${t} key '${r}'.`);s.push(n[r])}return s}}async function Td(t,e,n){const s=null!=n.batchesPerEpoch;if(l(null!=t.optimizer,()=>"You must compile a model before training/testing. Use LayersModel.compile(modelCompileConfig)."),l(null!=n,()=>"For fitDataset(), the 2nd argument (config) is required, but it is not provided in this call."),l(null!=n.epochs&&n.epochs>0&&Number.isInteger(n.epochs),()=>"For fitDataset(), config.epochs is expected to be a positive integer, but got "+n.epochs),l(!s||n.batchesPerEpoch>0&&Number.isInteger(n.batchesPerEpoch),()=>"For fitDataset(), config.batchesPerEpoch is expected to be a positive integer if specified, but got "+n.batchesPerEpoch),l(null==n.validationSplit,()=>"`validationSplit` is not supported by `fitDataset()`. Use validationData instead."),t.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");t.isTraining=!0;try{const r=null!=n.validationData;let a,i;if(r)if(Ed(n.validationData))l(null==n.validationBatches||n.validationBatches>0&&Number.isInteger(n.validationBatches),()=>"For fitDataset() with dataset-based validation, config.validationBatches is expected not to be provided, or to be a positive integer, but got "+n.validationBatches);else{const t=function(t){if(3===t.length)throw new Ic("Validation with sample weights is not implemented yet.");return{xs:t[0],ys:t[1]}}(n.validationData);a=t.xs,i=t.ys}const o=t.makeTrainFunction(),u=t.getDedupedMetricsNames();let c;c=r?u.slice().concat(u.map(t=>"val_"+t)):u.slice();const h=Dp(n.callbacks,n.yieldEvery),p=null==n.verbose?1:n.verbose,{callbackList:d,history:f}=Fp(h,p,n.epochs,null,null,function(t,e){let n=null;null!=e.batchesPerEpoch?n=e.batchesPerEpoch:Number.isFinite(t.size)&&(n=t.size);return n}(e,n),null,r,c);d.setModel(t),t.history=f,await d.onTrainBegin(),t.stopTraining_=!1;let m=null==n.initialEpoch?0:n.initialEpoch,g=await e.iterator();for(;m<n.epochs;){const l={};await d.onEpochBegin(m);let c=0,h=0;for(s||(g=await e.iterator());!s||c<n.batchesPerEpoch;){const e=await g.next();if(s&&e.done){console.warn("You provided `batchesPerEpoch` as "+n.batchesPerEpoch+", but your dataset iterator ran out of data after "+c+" batches; interrupting training. Make sure that your dataset can generate at least `batchesPerEpoch * epochs` batches (in this case, "+n.batchesPerEpoch*n.epochs+" batches). You may need to use the repeat() function when building your dataset.");break}if(null!=e.value){const{xs:s,ys:r}=Cd(t,e.value),a={};a.batch=h,a.size=s[0].shape[0],await d.onBatchBegin(h,a);const i=[];if(null!=n.classWeight){const e=kd(n.classWeight,t.outputNames);for(let t=0;t<e.length;++t)i.push(await Nd(r[t],null,e[t]))}const l=s.concat(r).concat(i),p=o(l);Zn(l);for(let t=0;t<u.length;++t){const e=u[t],n=p[t];a[e]=n,Qn(n)}await d.onBatchEnd(h,a),Cp(a),h++,c++}if(s?c>=n.batchesPerEpoch:e.done){if(r){let e;e=Ed(n.validationData)?Ac(await t.evaluateDataset(n.validationData,{batches:n.validationBatches})):Ac(t.evaluate(a,i,{batchSize:null==n.validationBatchSize?32:n.validationBatchSize,verbose:0}));for(let n=0;n<t.metricsNames.length;++n)l["val_"+t.metricsNames[n]]=e[n]}break}if(t.stopTraining_)break}if(await d.onEpochEnd(m,l),m++,t.stopTraining_)break}return await d.onTrainEnd(),await t.history.syncData(),t.history}finally{t.isTraining=!1}}function Ed(t){return"function"==typeof t.iterator}function $d(t){l(t>0&&Number.isInteger(t),()=>"batchSize is required to be a positive integer, but got "+t)}function Ad(t,e,n){return null==t?[null]:Array.isArray(t)?t.map(t=>vh(t,e,n-e)):vh(t,e,n-e)}function Rd(t,e){return Jn(()=>null==t?null:Array.isArray(t)?t.map(t=>Rd(t,e)):$h(t,"int32"===e.dtype?e:e.toInt()))}function Dd(t,e){const n=[];let s=0,r=null;for(;s<t;)r=s+e,r>=t&&(r=t),n.push([s,r]),s=r;return n}async function _d(t,e,n,s={}){if(t.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");let a,i,o,l,u,c,h;t.isTraining=!0;try{const p=null==s.batchSize?32:s.batchSize;$d(p);const d=!1,f=await t.standardizeUserData(e,n,s.sampleWeight,s.classWeight,d,p);a=f[0],i=f[1],h=f[2];let m,g=!1;if(null!=s.validationData&&s.validationData.length>0){if(g=!0,2!==s.validationData.length)throw 3===s.validationData.length?new Ic("validationData including sample weights is not supported yet."):new Nc("When passing validation data, it must contain 2 (valX, valY) or 3 (valX, valY, valSampleWeight) items; "+s.validationData+" is invalid.");o=s.validationData[0],l=s.validationData[1];const e=!0,n=await t.standardizeUserData(o,l,null,null,e,p);u=n[0],c=n[1],m=u.concat(c)}else if(null!=s.validationSplit&&s.validationSplit>0&&s.validationSplit<1){g=!0;const t=Math.floor(a[0].shape[0]*(1-s.validationSplit)),e=a[0].shape[0];u=Ad(a,t,e),a=Ad(a,0,t),c=Ad(i,t,e),i=Ad(i,0,t),m=u.concat(c)}else null!=s.validationSteps&&(g=!0);const y=a.concat(i).concat(h);t.checkTrainableWeightsConsistency();const b=t.makeTrainFunction(),x=t.getDedupedMetricsNames();let w,v;g?(t.makeTestFunction(),w=t.testFunction,v=x.slice().concat(x.map(t=>"val_"+t))):(w=null,m=[],v=x.slice());const k=Dp(s.callbacks,s.yieldEvery);return await async function(t,e,n,s,a,i,o,l,u,c,h,p,d,f,m){null==a&&(a=32),null==i&&(i=1),null==h&&(h=!0),null==d&&(d=0);let g=!1;if(null!=u&&null!=c&&(g=!0),null!=m&&(g=!0,null==f))throw new Nc("Can only use `validationSteps` when doing step-wise training, i.e., `stepsPerEpoch` must be set.");const y=t.checkNumSamples(n,a,f,"steps_per_epoch");let b;null!=y&&(b=bh(0,y)),null==o&&(o=1);const{callbackList:x,history:w}=Fp(l,o,i,d,y,f,a,g,p);x.setModel(t),t.history=w,await x.onTrainBegin(),t.stopTraining_=!1;for(let o=d;o<i;++o){await x.onEpochBegin(o);const i={};if(null!=f)throw new Ic("stepsPerEpoch mode is not implemented yet.");{if("batch"===h)throw new Ic("batch shuffling is not implemneted yet");h&&r(b);const o=ci(b),l=Dd(y,a);for(let r=0;r<l.length;++r){const h={};if(await x.onBatchBegin(r,h),Jn(()=>{const p=l[r][0],d=l[r][1],f=vh(o,p,d-p);h.batch=r,h.size=d-p;const m=Rd(n,f),y=e(m);for(let t=0;t<s.length;++t){const e=s[t],n=y[t];h[e]=n,Qn(n)}if(r===l.length-1&&g){const e=t.testLoop(u,c,a);for(let t=0;t<s.length;++t){const n=s[t],r=e[t];Qn(r),i["val_"+n]=r}}}),await x.onBatchEnd(r,h),Cp(h),t.stopTraining_)break}o.dispose()}if(await x.onEpochEnd(o,i),t.stopTraining_)break}return await x.onTrainEnd(),await t.history.syncData(),t.history}(t,b,y,x,p,s.epochs,s.verbose,k,w,m,s.shuffle,v,s.initialEpoch,null,null)}finally{t.isTraining=!1,Od(a,e),Od(i,n),Od(u,o),Od(c,l),null!=h&&Zn(h)}}function Fd(t){const e=[];t instanceof Tt&&(t=[t]);for(let n=0;n<t.length;++n){const s=t[n];if(1===s.rank)e.push(wh(s,1));else{if(0===s.rank)throw new Error("Expected tensor to be at least 1D, but received a 0D tensor (scalar).");e.push(s)}}return e}function Od(t,e){if(null==t)return;const n=[];if(e instanceof Tt)n.push(e.id);else if(Array.isArray(e))e.forEach(t=>n.push(t.id));else if(null!=e)for(const t in e){const s=e[t];n.push(s.id)}const s=[];if(t instanceof Tt)-1===n.indexOf(t.id)&&s.push(t);else if(Array.isArray(t))t.forEach(t=>{-1===n.indexOf(t.id)&&s.push(t)});else if(null!=t)for(const e in t){const r=t[e];-1===n.indexOf(r.id)&&s.push(r)}s.forEach(t=>{t.isDisposed||t.dispose()})}function Md(t){return Array.isArray(t)}function Ld(t){return!function(t){return t instanceof Tt}(t)&&!Md(t)}function zd(t,e,n,s=!0,r=""){if(null==e||0===e.length){if(null!=t){let e=!1;if(Md(t)&&t.length>0)e=!0;else if(Ld(t)){for(const n in t)if(t.hasOwnProperty(n)){e=!0;break}}else e=!0;if(e)throw new Nc(`Error when checking model ${r} expected no data, but got `+t)}return[]}if(null==t)return e.map(t=>null);let a;if(Ld(t)){t=t,a=[];for(const n of e){if(null==t[n])throw new Nc(`No data provided for "${n}". Need data for each key in: `+e);a.push(t[n])}}else if(Md(t)){if((t=t).length!==e.length)throw new Nc(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the model expected. Expected to see ${e.length} Tensor(s), but instead got the following list of Tensor(s): `+t);a=t}else{if(t=t,e.length>1)throw new Nc(`The model ${r} expects ${e.length} Tensor(s), but only received one Tensor. Found: Tensor with shape `+t.shape);a=[t]}if(a=Fd(a),null!=n)for(let t=0;t<e.length;++t){if(null==n[t])continue;const i=a[t];if(i.shape.length!==n[t].length)throw new Nc(`Error when checking ${r}: expected ${e[t]} to have ${n[t].length} dimension(s). but got array with shape `+i.shape);for(let a=0;a<n[t].length;++a){if(0===a&&!s)continue;const o=i.shape[a],l=n[t][a];if(null!=l&&l>=0&&o!==l)throw new Nc(`Error when checking ${r}: expected ${e[t]} to have shape [${n[t]}], but got array with shape [${i.shape}].`)}}return a}function Bd(t,e,n,s=!0,r=""){let a;if(Array.isArray(t)){if(t.length!==e.length)throw new Nc(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the the model expected. Expected to see ${e.length} Tensor(s), but instead got ${t.length} Tensors(s).`);a=t}else{if(e.length>1)throw new Nc(`The model expects ${e.length} ${r} Tensors, but only received one Tensor. Found: array with shape `+JSON.stringify(t.shape)+".");a=[t]}if(null!=n)for(let t=0;t<e.length;++t){if(null==n[t])continue;const i=a[t];if(i.shape.length!==n[t].length)throw new Nc(`Error when checking ${r}: expected ${e[t]} to have ${n[t].length} dimension(s), but got array with shape `+JSON.stringify(i.shape));for(let a=0;a<n[t].length;++a){if(0===a&&!s)continue;const o=i.shape[a],l=n[t][a];if(null!=l&&l!==o)throw new Nc(`Error when checking ${r}: expected ${e[t]} to have shape ${JSON.stringify(n[t])} but got array with shape ${JSON.stringify(i.shape)}.`)}}}class Pd extends wd{constructor(t){super(t),this.isTraining=!1}summary(t,e,n=console.log){if(!this.built)throw new Nc("This model has never been called, thus its weights have not been created yet. So no summary can be displayed. Build the model first (e.g., by calling it on some test data).");od(this,t,e,n)}compile(t){if(null==t.loss&&(t.loss=[]),this.loss=t.loss,"string"==typeof t.optimizer)this.optimizer_=function(t){const e={Adagrad:()=>zl.adagrad(.01),Adadelta:()=>zl.adadelta(1,.95,wc()),Adam:()=>zl.adam(.001,.9,.999,wc()),Adamax:()=>zl.adamax(.002,.9,.999,wc(),0),RMSProp:()=>zl.rmsprop(.001,.9,0,wc()),SGD:()=>zl.sgd(.01)};if(e.adagrad=e.Adagrad,e.adadelta=e.Adadelta,e.adam=e.Adam,e.adamax=e.Adamax,e.rmsprop=e.RMSProp,e.sgd=e.SGD,t in e)return e[t]();throw new Nc("Unknown Optimizer "+t)}(t.optimizer),this.isOptimizerOwned=!0;else{if(!(t.optimizer instanceof $l))throw new Nc("User-defined optimizer must be an instance of tf.Optimizer.");this.optimizer_=t.optimizer,this.isOptimizerOwned=!1}let e=[];if(Array.isArray(t.loss)||"string"==typeof t.loss||"function"==typeof t.loss)if(Array.isArray(t.loss)){if(t.loss.length!==this.outputs.length)throw new Nc(`When passing an Array as loss, it should have one entry per model output. The model has ${this.outputs.length} output(s), but you passed loss=${t.loss}.`);const n=t.loss;e=n.map(t=>qp(t))}else{const n=qp(t.loss);this.outputs.forEach(t=>{e.push(n)})}else{t.loss=t.loss;for(const e in t.loss)if(-1===this.outputNames.indexOf(e))throw new Nc(`Unknown entry in loss dictionary: "${e}". Only expected the following keys: `+this.outputNames);for(const n of this.outputNames)null==t.loss[n]&&console.warn(`Output "${n}" is missing from loss dictionary. We assume this was done on purpose, and we will not be expecting data to be passed to ${n} during training`),e.push(qp(t.loss[n]))}this.lossFunctions=e,this.feedOutputNames=[],this.feedOutputShapes=[],this.feedLossFns=[];for(let t=0;t<this.outputs.length;++t){const e=this.internalOutputShapes[t],n=this.outputNames[t];this.feedOutputNames.push(n),this.feedOutputShapes.push(e),this.feedLossFns.push(this.lossFunctions[t])}const n=[];this.metrics=t.metrics,this.metricsNames=["loss"],this.metricsTensors=[],uh("loss",()=>{for(let t=0;t<this.outputs.length;++t){if(-1!==n.indexOf(t))continue;const e=this.lossFunctions[t];this.outputs.length>1&&(this.metricsTensors.push([e,t]),this.metricsNames.push(this.outputNames[t]+"_loss"))}});const s=function(t,e){if(null==t||Array.isArray(t)&&0===t.length)return e.map(t=>[]);let n;if("string"==typeof t||"function"==typeof t)n=[t];else{if(!Array.isArray(t)&&"object"!=typeof t)throw new TypeError("Type of metrics argument not understood. Expected an string,function, Array, or Object, found: "+t);n=t}if(Array.isArray(n))return e.map(t=>n);{const t=[];for(const s of e){let e=n.hasOwnProperty(s)?n[s]:[];Array.isArray(e)||(e=[e]),t.push(e)}return t}}(t.metrics,this.outputNames),r=(t,e,n)=>{this.outputNames.length>1&&(e=this.outputNames[t]+"_"+e),this.metricsNames.push(e),this.metricsTensors.push([n,t])};uh("metric",()=>{for(let t=0;t<this.outputs.length;++t){if(-1!==n.indexOf(t))continue;(e=>{let n,s,a;for(const i of e){if("string"==typeof i&&-1!==["accuracy","acc","crossentropy","ce"].indexOf(i)){const e=this.internalOutputShapes[t];let r;1===e[e.length-1]||this.lossFunctions[t]===Up?-1!==["accuracy","acc"].indexOf(i)?s=Kp:-1!==["crossentropy","ce"].indexOf(i)&&(s=Qp):this.lossFunctions[t]===Vp?-1!==["accuracy","acc"].indexOf(i)?s=td:-1!==["crossentropy","ce"].indexOf(i)&&(s=nd):-1!==["accuracy","acc"].indexOf(i)?s=Xp:-1!==["crossentropy","ce"].indexOf(i)&&(s=ed),-1!==["accuracy","acc"].indexOf(i)?r="acc":-1!==["crossentropy","ce"].indexOf(i)&&(r="ce"),a=s,n=""+r}else{const t=rd(i);a=t,n=""+ad(i)}let e;uh(n,()=>{e=a}),r(t,n,e)}})(s[t])}}),this.collectedTrainableWeights=this.trainableWeights}checkTrainableWeightsConsistency(){null!=this.collectedTrainableWeights&&this.trainableWeights.length!==this.collectedTrainableWeights.length&&console.warn("Discrepancy between trainableweights and collected trainable weights. Did you set `model.trainable` without calling `model.compile()` afterwards?")}evaluate(t,e,n={}){const s=null==n.batchSize?32:n.batchSize;$d(s);const r=this.standardizeUserDataXY(t,e,!0,s);try{const a=r[0].concat(r[1]);this.makeTestFunction();const i=this.testFunction;return $c(this.testLoop(i,a,s,n.verbose,n.steps))}finally{Od(r[0],t),Od(r[1],e)}}async evaluateDataset(t,e){return this.makeTestFunction(),async function(t,e,n){const s=null!=(n=n||{}).batches,r=t.testFunction;let a=[];if(n.verbose>0)throw new Ic("Verbose mode is not implemented yet.");l(!s||n.batches>0&&Number.isInteger(n.batches),()=>"Test loop expects `batches` to be a positive integer, but received "+JSON.stringify(n.batches));const i="function"==typeof e.next?e:await e.iterator();let o=0,u=0;for(;!s||u<n.batches;){const e=await i.next();if(a=Jn(()=>{if(e.value){const{xs:n,ys:s}=Cd(t,e.value),i=n.concat(s),l=Jn(()=>r(i));if(Zn(i),0===u)for(let t=0;t<l.length;++t)a.push(Jr(0));const c=i[0].shape[0];for(let t=0;t<l.length;++t){const e=l[t],n=a[t];a[t]=Jn(()=>ss(a[t],is(c,e))),u>0&&Zn(n)}Zn(l),o+=c,++u}return a}),e.done){s&&console.warn(`Your dataset iterator ran out of data during evaluateDataset(). Interrupting evalution. Make sure that your dataset can generate at least \`batches\` batches (in this case, ${n.batches} batches). You may need to use the repeat() function when building your dataset.`);break}}for(let t=0;t<a.length;++t){const e=a[t];a[t]=as(a[t],o),Zn(e)}return $c(a)}(this,t,e)}checkNumSamples(t,e,n,s="steps"){let r;if(null!=n){if(r=null,null!=e)throw new Nc(`If ${s} is set, batchSize must be null or undefined.Got batchSize = `+e)}else{if(null==t)throw new Nc("Either the input data should have a defined shape, or "+s+" shoud be specified.");r=Array.isArray(t)?t[0].shape[0]:t.shape[0]}return r}execute(t,e){if(Array.isArray(e)&&0===e.length)throw new Nc("`outputs` is an empty Array, which is not allowed.");const n=Array.isArray(e),s=n?e:[e],r=this.retrieveSymbolicTensors(s),a=new dd;if(t instanceof Tt&&(t=[t]),Array.isArray(t)){if(t.length!==this.inputs.length)throw new Nc(`The number of inputs provided (${t.length}) does not match the number of inputs of this model (${this.inputs.length}).`);for(let e=0;e<this.inputs.length;++e)a.add(this.inputs[e],t[e])}else for(const e of this.inputs){const n=t[e.name];if(null==n)throw new Nc("No value is provided for the model's input "+e.name);a.add(e,n)}const i=gd(r,a);return n?i:i[0]}retrieveSymbolicTensors(t){const e=Sc(null,t.length);let n=t.length;for(const s of this.layers){const r=Array.isArray(s.output)?s.output:[s.output],a=r.map(t=>t.name);for(let s=0;s<t.length;++s){const i=a.indexOf(t[s]);if(-1!==i&&(e[s]=r[i],n--),0===n)break}if(0===n)break}if(n>0){const n=[];throw e.forEach((e,s)=>{null==e&&n.push(t[s])}),new Nc("Cannot find SymbolicTensors for output name(s): "+JSON.stringify(n))}return e}predictLoop(t,e=32,n=!1){return Jn(()=>{const s=this.checkNumSamples(t);if(n)throw new Ic("Verbose predictLoop() is not implemented yet.");const r=Dd(s,e),a=this.outputs.map(t=>[]);for(let e=0;e<r.length;++e){Jn(()=>{const n=r[e][0],s=r[e][1],a=Ad(t,n,s),i=[];if(Array.isArray(a))for(let t=0;t<a.length;++t)i.push({key:this.inputs[t],value:a[t]});else i.push({key:this.inputs[0],value:a});const o=new dd(i);return gd(this.outputs,o)}).forEach((t,e)=>a[e].push(t))}return $c(a.map(t=>Hs(t,0)))})}predict(t,e={}){const n=Fd(t);Bd(n,this.inputNames,this.feedInputShapes,!1);try{const s=null==e.batchSize?32:e.batchSize;return $d(s),this.predictLoop(n,s)}finally{Od(n,t)}}predictOnBatch(t){Bd(t,this.inputNames,this.feedInputShapes,!0);const e=(Array.isArray(t)?t[0]:t).shape[0];return this.predictLoop(t,e)}standardizeUserDataXY(t,e,n=!0,s){if(null==this.optimizer_)throw new kc("You must compile a model before training/testing. Use LayersModel.compile(modelCompileArgs).");const r=[];for(let t=0;t<this.feedOutputShapes.length;++t){const e=this.feedOutputShapes[t];this.feedLossFns[t]===Vp?r.push(e.slice(0,e.length-1).concat([1])):r.push(e)}if(function(t,e,n){const s=Lc(t.map(t=>t.shape[0]));s.sort();const r=Lc(e.map(t=>t.shape[0]));if(r.sort(),s.length>1)throw new Nc("All input Tensors (x) should have the same number of samples. Got array shapes: "+JSON.stringify(t.map(t=>t.shape)));if(r.length>1)throw new Nc("All target Tensors (y) should have the same number of samples. Got array shapes: "+JSON.stringify(e.map(t=>t.shape)));if(s.length>0&&r.length>0&&!d(s,r))throw new Nc(`Input Tensors should have the same number of samples as target Tensors. Found ${s[0]} input sample(s) and ${r[0]} target sample(s).`)}(t=zd(t,this.feedInputNames,this.feedInputShapes,!1,"input"),e=zd(e,this.feedOutputNames,r,!1,"target")),function(t,e,n){const s=[Lp,Up,Wp];for(let r=0;r<t.length;++r){const a=t[r],i=e[r],o=n[r];if(null!=i){if(i===Wp&&1===a.shape[a.shape.length-1])throw new Nc(`You are passing a target array of shape ${a.shape} while using a loss 'categorical_crossentropy'. 'categorical_crossentropy'expects targets to be binary matrices (1s and 0s) of shape [samples, classes].`);if(-1!==s.indexOf(i)){const t=a.shape.slice(1),e=o.slice(1);for(let n=0;n<t.length;++n){const s=t[n],r=e[n];if(null!=r&&s!==r)throw new Nc(`A target Tensor with shape ${a.shape} was passed for an output of shape ${o}, while using a loss function that expects targets to have the same shape as the output.`)}}}}}(e,this.feedLossFns,this.feedOutputShapes),this.stateful&&null!=s&&s>0&&t[0].shape[0]%s!=0)throw new Nc(`In a stateful network, you should only pass inputs with a number of samples that is divisible by the batch size ${s}. Found: ${t[0].shape[0]} sample(s).`);return[t,e]}async standardizeUserData(t,e,n,s,r=!0,a){const[i,o]=this.standardizeUserDataXY(t,e,r,a);if(null!=n)throw new Error("sample weight is not supported yet.");let l=null;if(null!=s){const t=kd(s,this.outputNames);l=[];for(let e=0;e<t.length;++e)l.push(await Nd(o[e],null,t[e]))}return[i,o,l]}testLoop(t,e,n,s=0,r){return Jn(()=>{const a=this.checkNumSamples(e,n,r,"steps"),i=[];if(s>0)throw new Ic("Verbose mode is not implemented yet.");if(null!=r)throw new Ic("steps mode in testLoop() is not implemented yet");{const s=Dd(a,n),r=ci(bh(0,a));for(let n=0;n<s.length;++n){const a=s[n][0],o=s[n][1],l=vh(r,a,o-a),u=Rd(e,l),c=t(u);if(0===n)for(let t=0;t<c.length;++t)i.push(Jr(0));for(let t=0;t<c.length;++t){const e=c[t];i[t]=ss(i[t],is(o-a,e))}}for(let t=0;t<i.length;++t)i[t]=as(i[t],a)}return i})}getDedupedMetricsNames(){const t=this.metricsNames,e=[];for(let n=0;n<t.length;++n){const s=t[n];let r=s;if(Ec(t,s)>1){r+="_"+Ec(t.slice(0,n),s)}e.push(r)}return e}makeTrainFunction(){return t=>{const e=[],n=t.slice(0,this.inputs.length),s=t.slice(this.inputs.length,this.inputs.length+this.outputs.length),r=t.slice(this.inputs.length+this.outputs.length,this.inputs.length+2*this.outputs.length),a=[],i=this.collectedTrainableWeights.map(t=>t.read());return[this.optimizer_.minimize(()=>{const t=[];for(let e=0;e<this.inputs.length;++e)t.push({key:this.inputs[e],value:n[e]});const i=new dd(t),o=gd(this.outputs,i,{training:!0});let l;for(let t=0;t<this.lossFunctions.length;++t){let n=(0,this.lossFunctions[t])(s[t],o[t]);null!=r[t]&&(n=Id(n,r[t]));const a=Ca(n);e.push(a),l=0===t?n:ss(l,n)}for(let t=0;t<this.metricsTensors.length;++t){let n;if(this.outputs.length>1&&t<this.outputs.length)n=e[t];else{const e=this.metricsTensors[t][0],r=this.metricsTensors[t][1];n=Ca(e(s[r],o[r]))}Qn(n),a.push(n)}return l=Ca(l),this.calculateLosses().forEach(t=>{l=ss(l,t)}),l},!0,i)].concat(a)}}makeTestFunction(){this.testFunction=t=>Jn(()=>{const e=[];let n;const s=t.slice(0,this.inputs.length),r=t.slice(this.inputs.length,this.inputs.length+this.outputs.length),a=[];for(let t=0;t<this.inputs.length;++t)a.push({key:this.inputs[t],value:s[t]});const i=new dd(a),o=gd(this.outputs,i);for(let t=0;t<this.lossFunctions.length;++t){const s=this.lossFunctions[t],a=Ca(s(r[t],o[t]));n=0===t?a:ss(n,a),e.push(n)}for(let t=0;t<this.metricsTensors.length;++t){const n=this.metricsTensors[t][0],s=this.metricsTensors[t][1],a=Ca(n(r[s],o[s]));e.push(a)}return e})}async fit(t,e,n={}){return _d(this,t,e,n)}async fitDataset(t,e){return Td(this,t,e)}async trainOnBatch(t,e){const n=await this.standardizeUserData(t,e),s=n[0],r=n[1],a=this.makeTrainFunction()(s.concat(r)),i=[];for(const t of a){const e=await t.data();i.push(e[0])}return Zn(a),$c(i)}getNamedWeights(t){const e=[],n=null!=t&&t.trainableOnly,s=n?this.trainableWeights:this.weights,r=this.getWeights(n);for(let t=0;t<s.length;++t)n&&!s[t].trainable||e.push({name:s[t].originalName,tensor:r[t]});return e}set stopTraining(t){this.stopTraining_=t}get stopTraining(){return this.stopTraining_}get optimizer(){return this.optimizer_}set optimizer(t){this.optimizer_!==t&&(this.optimizer_=t,this.isOptimizerOwned=!1)}dispose(){const t=super.dispose();if(0===t.refCountAfterDispose&&null!=this.optimizer&&this.isOptimizerOwned){const e=Yn().numTensors;this.optimizer_.dispose(),t.numDisposedVariables+=e-Yn().numTensors}return t}getLossIdentifiers(){let t;if("string"==typeof this.loss)t=Rc(this.loss);else if(Array.isArray(this.loss)){for(const t of this.loss)if("string"!=typeof t)throw new Error("Serialization of non-string loss is not supported.");t=this.loss.map(t=>Rc(t))}else{const e=Object.keys(this.loss);t={};const n=this.loss;for(const s of e){if("string"!=typeof n[s])throw new Error("Serialization of non-string loss is not supported.");t[s]=Rc(n[s])}}return t}getMetricIdentifiers(){if("string"==typeof this.metrics||"function"==typeof this.metrics)return[Rc(ad(this.metrics))];if(Array.isArray(this.metrics))return this.metrics.map(t=>Rc(ad(t)));{const t={};for(const e in this.metrics)t[e]=Rc(ad(this.metrics[e]));return t}}getTrainingConfig(){return{loss:this.getLossIdentifiers(),metrics:this.getMetricIdentifiers(),optimizer_config:{class_name:this.optimizer.getClassName(),config:this.optimizer.getConfig()}}}loadTrainingConfig(t){if(null!=t.weighted_metrics)throw new Error("Loading weight_metrics is not supported yet.");if(null!=t.loss_weights)throw new Error("Loading loss_weights is not supported yet.");if(null!=t.sample_weight_mode)throw new Error("Loading sample_weight_mode is not supported yet.");const e=Op(pd(t.optimizer_config));let n,s;if("string"==typeof t.loss)n=Dc(t.loss);else if(Array.isArray(t.loss))n=t.loss.map(t=>Dc(t));else if(null!=t.loss){n={};for(const e in t.loss)n[e]=Dc(t.loss[e])}if(Array.isArray(t.metrics))s=t.metrics.map(t=>Dc(t));else if(null!=t.metrics){s={};for(const e in t.metrics)s[e]=Dc(t.metrics[e])}this.compile({loss:n,metrics:s,optimizer:e})}async save(t,e){if("string"==typeof t){const e=ge(t);if(0===e.length)throw new Nc(`Cannot find any save handlers for URL '${t}'`);if(e.length>1)throw new Nc(`Found more than one (${e.length}) save handlers for URL '${t}'`);t=e[0]}if(null==t.save)throw new Nc("LayersModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");const n=await ie(this.getNamedWeights(e)),s={modelTopology:this.toJSON(null,!1),format:"layers-model",generatedBy:"TensorFlow.js tfjs-layers v2.7.0",convertedBy:null};if(null!=e&&e.includeOptimizer&&null!=this.optimizer){s.trainingConfig=this.getTrainingConfig();const t="optimizer",{data:e,specs:r}=await ie(await this.optimizer.getWeights(),t);n.specs.push(...r),n.data=he([n.data,e])}if(null!=this.userDefinedMetadata){const t=!0;id(this.userDefinedMetadata,this.name,t),s.userDefinedMetadata=this.userDefinedMetadata}return s.weightData=n.data,s.weightSpecs=n.specs,t.save(s)}setUserDefinedMetadata(t){id(t,this.name),this.userDefinedMetadata=t}getUserDefinedMetadata(){return this.userDefinedMetadata}}Pd.className="Model",Wn(Pd);class Wd extends Pd{}async function Vd(t,e){if(null==e&&(e={}),"string"==typeof t){const n=ye(t,e);if(0===n.length)n.push(nn(t,e));else if(n.length>1)throw new Nc(`Found more than one (${n.length}) load handlers for URL '${t}'`);t=n[0]}return async function(t,e,n){null==n&&(n={});if(null==t.load)throw new Nc("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const s=await t.load();let r=s.modelTopology;null!=r.model_config&&(r=r.model_config);const a=null==n.strict||n.strict,i=null!=s.weightData&&null!=s.weightSpecs&&a,o=Op(pd(r),e,i),l=s.trainingConfig;null!=l&&o.loadTrainingConfig(l);null!=s.userDefinedMetadata&&o.setUserDefinedMetadata(s.userDefinedMetadata);if(null!=s.weightData){if(null==s.weightSpecs)throw new Nc("LayersModel artifacts contains weight data, but not weight specs. Therefore loading of weights cannot proceed.");const{modelWeights:t,optimizerWeights:e}=function(t,e){const n=oe(t,e),s={},r=[];return e.forEach(t=>{"optimizer"===t.group?r.push({name:t.name,tensor:n[t.name]}):s[t.name]=n[t.name]}),{modelWeights:s,optimizerWeights:r}}(s.weightData,s.weightSpecs);o.loadWeights(t,a),null!=o.optimizer&&e.length>0&&await o.optimizer.setWeights(e),Zn(t),Zn(e.map(t=>t.tensor))}return o}(t,void 0,e)}Wd.className="Functional",Wn(Wd);class Ud extends Pd{constructor(t){if(super({inputs:[],outputs:[]}),t=t||{},this.trainable=!0,this.built=!1,this.name=null!=t.name?t.name:op("sequential_"),null!=t.layers)for(const e of t.layers)this.add(e)}checkShape(t){if(t.inboundNodes[0].outputTensors[0].shape.some(t=>t<0))throw new Nc("Negative dimension size caused by adding layer "+t.name+" with input shape ["+t.inboundNodes[0].inputTensors[0].shape+"]")}add(t){const e=t instanceof Ud||t instanceof Pd;let n;if(e){if(n=t,1!==n.outputs.length)throw new Nc("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");if(1!==n.inputs.length)throw new Nc("All layers in a Sequential model should have a single input tensor. For multi-input layers, use the functional API.")}if(0===this.outputs.length){if(0===t.inboundNodes.length){if(null==t.batchInputShape)throw new Nc("The first layer in a Sequential model must get an `inputShape` or `batchInputShape` argument.");const e=Np({batchShape:t.batchInputShape,dtype:t.dtype,name:t.name+"_input"});t.apply(e)}if(e)this.outputs=n.outputs,this.inputs=n.inputs;else{if(1!==t.inboundNodes.length)throw new Nc(`A layer added to a Sequential model must not already be connected somewhere else. LayersModel received layer ${t.name} which has ${t.inboundNodes.length} pre-existing inbound connections.`);if(1!==t.inboundNodes[0].outputTensors.length)throw new Nc("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(t),this.outputs=[t.inboundNodes[0].outputTensors[0]],this.inputs=function t(e,n,s){if((null==n||null!=s&&s>0)&&(n=e.sourceLayer,s=e.nodeIndex),0===n.inboundNodes.length)return[e];{const e=n.inboundNodes[s];if(0===e.inboundLayers.length)return e.inputTensors;{const n=[];for(let s=0;s<e.inboundLayers.length;s++){const r=t(e.inputTensors[s],e.inboundLayers[s],e.nodeIndices[s]);for(const t of r)-1===n.indexOf(t)&&n.push(t)}return n}}}(this.outputs[0])}this.inboundNodes=[],new xp({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:Sc(null,this.inputs.length),outputMasks:[null],inputShapes:this.inputs.map(t=>t.shape),outputShapes:this.outputs[0].shape})}else{const e=t.apply(this.outputs[0]);if(Array.isArray(e))throw new TypeError("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(t),this.outputs=[e],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}this.layers.push(t),this.built=!1}pop(){if(0===this.layers.length)throw new TypeError("There are no layers in the model.");if(this.layers.pop(),0===this.layers.length)this.outputs=[],this.inboundNodes=[],this.outboundNodes=[];else{const t=this.layers.length-1;this.layers[t].outboundNodes=[],this.outputs=[this.layers[t].output],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}}call(t,e){return null==this.model&&this.build(),this.model.call(t,e)}build(t){if(hp(t),0===this.inputs.length||0===this.outputs.length)throw new TypeError("Sequential model cannot be built: model is empty. Add some layers first.");this.model=new Pd({inputs:this.inputs,outputs:this.outputs[0],name:this.name+"_model"}),this.model.trainable=this.trainable,this.supportsMasking=this.model.supportsMasking,this.inputLayers=this.model.inputLayers,this.inputLayersNodeIndices=this.model.inputLayersNodeIndices,this.inputLayersTensorIndices=this.model.inputLayersTensorIndices,this.outputLayers=this.model.outputLayers,this.outputLayersNodeIndices=this.model.outputLayersNodeIndices,this.outputLayersTensorIndices=this.model.outputLayersTensorIndices,this.nodesByDepth=this.model.nodesByDepth,this.containerNodes=this.model.containerNodes,this.outputNames=this.model.outputNames,this.inputNames=this.model.inputNames,this.built=!0}countParams(){return this.built||this.build(),super.countParams()}summary(t,e,n=console.log){this.built||this.build(),super.summary(t,e,n)}setWeights(t){null==this.model&&this.build(),this.model.setWeights(t)}evaluate(t,e,n={}){if(!this.built)throw new kc("The model needs to be compiled before being used.");return this.model.evaluate(t,e,n)}async evaluateDataset(t,e){if(!this.built)throw new kc("The model needs to be compiled before being used.");return this.model.evaluateDataset(t,e)}predict(t,e={}){return null==this.model&&this.build(),this.model.predict(t,e)}predictOnBatch(t){return null==this.model&&this.build(),this.model.predictOnBatch(t)}compile(t){this.build(),this.model.compile(t),this.optimizer_=this.model.optimizer,this.isOptimizerOwned=this.model.isOptimizerOwned,this.loss=this.model.loss,this.metrics=this.model.metrics,this.metricsTensors=this.model.metricsTensors,this.metricsNames=this.model.metricsNames}get optimizer(){return null==this.model?void 0:this.model.optimizer}set optimizer(t){this.model.optimizer=t}async fit(t,e,n={}){if(!this.built)throw new kc("The model needs to be compiled before being used.");return this.model.fit(t,e,n)}async fitDataset(t,e){if(!this.built)throw new kc("The model needs to be compiled before being used.");return this.model.fitDataset(t,e)}async trainOnBatch(t,e){return this.model.trainOnBatch(t,e)}static fromConfig(t,e,n={},s=!1){let r,a={};if(e instanceof Array){if(null==e[0].className||"Merge"===e[0].className)throw new Nc("Legacy serialization format not supported yet.");r=e}else l(null!=e.layers,()=>"When the config data for a Sequential model is not an Array, it must be an Object that contains the 'layers' field."),r=e.layers,delete e.layers,a=e;const i=new t(a);if(!(i instanceof Ud))throw new Ic("Sequential.fromConfig called on non-Sequential input: "+i);for(const t of r){const e=Op(t,void 0,s);s&&e.setFastWeightInitDuringBuild(!0),i.add(e)}return i}set stopTraining(t){if(null==this.model)throw new Nc("Cannot set the stopTraining property of a sequential model before it is compiled.");this.model.stopTraining=t}get stopTraining(){if(null==this.model)throw new Nc("Cannot get the stopTraining property of a sequential model before it is compiled.");return this.model.stopTraining}getConfig(){const t=[];for(const e of this.layers){const n={};n.className=e.getClassName(),n.config=e.getConfig(),t.push(n)}return{name:this.name,layers:t}}}function Gd(t){return Np(t)}Ud.className="Sequential",Wn(Ud);class Hd extends Bn{getConfig(){return{}}}class jd extends Hd{apply(t,e=1){return function(t,e=1){if(1!==e)throw new Ic(`Support for alpha values other than 1 (${e}) is not implemented yet.`);return Rr(t)}(t,e)}}jd.className="elu",Wn(jd);class qd extends Hd{apply(t){return ki(t)}}qd.className="selu",Wn(qd);class Kd extends Hd{apply(t){return di(t)}}Kd.className="relu",Wn(Kd);class Xd extends Hd{apply(t){return Jn(()=>Ta(6,di(t)))}}Xd.className="relu6",Wn(Xd);class Yd extends Hd{apply(t){return t}}Yd.className="linear",Wn(Yd);class Jd extends Hd{apply(t){return js(t)}}Jd.className="sigmoid",Wn(Jd);class Zd extends Hd{apply(t){return function(t){return Jn(()=>{const e=ss(.5,is(.2,t));return rr(e,0,1)})}(t)}}Zd.className="hardSigmoid",Wn(Zd);class Qd extends Hd{apply(t){return ua(t)}}Qd.className="softplus",Wn(Qd);class tf extends Hd{apply(t){return function(t){return Jn(()=>as(t,os(t).add(1)))}(t)}}tf.className="softsign",Wn(tf);class ef extends Hd{apply(t){return Ks(t)}}ef.className="tanh",Wn(ef);class nf extends Hd{apply(t,e=-1){return Di(t,e)}}nf.className="softmax",Wn(nf);class sf extends Hd{apply(t,e=-1){return fa(t,e)}}sf.className="logSoftmax",Wn(sf);class rf extends Hd{apply(t,e=1){return Jn(()=>js(t.mul(e)).mul(t))}}function af(t){return t.getClassName()}function of(t,e={}){return Oc(t,Pn.getMap().classNameMap,e,"activation")}function lf(t){if(null==t){const t={className:"linear",config:{}};return of(t)}if("string"==typeof t){const e={};return e.className=t,e.config={},of(e)}return t instanceof Hd?t:of(t)}function uf(t){if(null!=t&&"object"!=typeof t)throw new Error("Argument to L1L2 regularizer's constructor is expected to be an object, but received: "+t)}rf.className="swish",Wn(rf);class cf extends Bn{}class hf extends cf{constructor(t){super(),uf(t),this.l1=null==t||null==t.l1?.01:t.l1,this.l2=null==t||null==t.l2?.01:t.l2,this.hasL1=0!==this.l1,this.hasL2=0!==this.l2}apply(t){return Jn(()=>{let e=Na([1]);return this.hasL1&&(e=ss(e,da(is(this.l1,os(t))))),this.hasL2&&(e=ss(e,da(is(this.l2,Ah(t))))),e.asScalar()})}getConfig(){return{l1:this.l1,l2:this.l2}}static fromConfig(t,e){return new t({l1:e.l1,l2:e.l2})}}hf.className="L1L2",Wn(hf);const pf={l1l2:"L1L2"};function df(t){return Fc(t)}function ff(t,e={}){return Oc(t,Pn.getMap().classNameMap,e,"regularizer")}function mf(t){if(null==t)return null;if("string"==typeof t){return ff({className:t in pf?pf[t]:t,config:{}})}return t instanceof cf?t:ff(t)}class gf extends vp{constructor(t){super(null==t?{}:t),this.supportsMasking=!0,null!=t&&(this.maxValue=t.maxValue)}call(t,e){t=cp(t);let n=di(t);return null!=this.maxValue&&(n=rr(n,0,this.maxValue)),n}computeOutputShape(t){return t}getConfig(){const t={maxValue:this.maxValue},e=super.getConfig();return Object.assign(t,e),t}}gf.className="ReLU",Wn(gf);class yf extends vp{constructor(t){super(null==t?{}:t),this.DEFAULT_ALPHA=.3,null==t&&(t={}),this.alpha=null==t.alpha?this.DEFAULT_ALPHA:t.alpha}call(t,e){const n=cp(t);return Zr(n,this.alpha)}computeOutputShape(t){return t}getConfig(){const t={alpha:this.alpha},e=super.getConfig();return Object.assign(t,e),t}}yf.className="LeakyReLU",Wn(yf);class bf extends vp{constructor(t){if(super(null==t?{}:t),this.DEFAULT_ALPHA_INITIALIZER="zeros",null==t&&(t={}),this.supportsMasking=!0,this.alphaInitializer=np(t.alphaInitializer||this.DEFAULT_ALPHA_INITIALIZER),this.alphaRegularizer=mf(t.alphaRegularizer),this.alphaConstraint=Zc(t.alphaConstraint),null==t.sharedAxes)this.sharedAxes=null;else if(Array.isArray(t.sharedAxes))this.sharedAxes=t.sharedAxes;else{if("number"!=typeof t.sharedAxes)throw new Nc("Expected sharedAxes to be a number or an array of numbers, but got "+t.sharedAxes);this.sharedAxes=[t.sharedAxes]}}build(t){const e=(t=hp(t)).slice(1);if(null!=this.sharedAxes)for(const t of this.sharedAxes)e[t-1]=1;this.alpha=this.addWeight("alpha",e,"float32",this.alphaInitializer,this.alphaRegularizer,!0,this.alphaConstraint);const n={};if(null!=this.sharedAxes)for(let e=1;e<t.length;++e)n[e]=t[e];this.inputSpec=[new gp({ndim:t.length,axes:n})],this.built=!0}call(t,e){return t=cp(t),ja(t,this.alpha.read())}getConfig(){const t={alphaInitializer:ep(this.alphaInitializer),alphaRegularizer:df(this.alphaRegularizer),alphaConstraint:Yc(this.alphaConstraint),sharedAxes:this.sharedAxes},e=super.getConfig();return Object.assign(t,e),t}}bf.className="PReLU",Wn(bf);class xf extends vp{constructor(t){if(super(null==t?{}:t),this.DEFAULT_ALPHA=1,null==t&&(t={}),null!=t.alpha&&t.alpha!==this.DEFAULT_ALPHA)throw new Ic(`Non-default alpha value (${t.alpha}) is not supported by the ELU layer yet.`);this.alpha=null==t.alpha?this.DEFAULT_ALPHA:t.alpha}call(t,e){const n=cp(t);return Rr(n)}computeOutputShape(t){return t}getConfig(){const t={alpha:this.alpha},e=super.getConfig();return Object.assign(t,e),t}}xf.className="ELU",Wn(xf);class wf extends vp{constructor(t){super(null==t?{}:t),this.DEFAULT_THETA=1,null==t&&(t={}),this.theta=null==t.theta?this.DEFAULT_THETA:t.theta}call(t,e){const n=cp(t);return n.mul(xh(n.greater(this.theta),"float32"))}computeOutputShape(t){return t}getConfig(){const t={theta:this.theta},e=super.getConfig();return Object.assign(t,e),t}}wf.className="ThresholdedReLU",Wn(wf);class vf extends vp{constructor(t){super(null==t?{}:t),this.DEFAULT_AXIS=1,null==t&&(t={}),this.softmax=(new nf).apply,this.axis=null==t.axis?this.DEFAULT_AXIS:t.axis}call(t,e){const n=cp(t);return this.softmax(n,this.axis)}computeOutputShape(t){return t}getConfig(){const t={axis:this.axis},e=super.getConfig();return Object.assign(t,e),t}}function kf(t,e,n){if("number"==typeof t)return Sc(t,e);if(t.length!==e)throw new Nc(`The ${n} argument must be an integer or tuple of ${e} integers. Received: ${t.length} elements.`);for(let r=0;r<e;++r){const a=t[r];if((s=a)!==parseInt(s.toString(),10))throw new Nc(`The ${n} argument must be an integer or tuple of ${e} integers. Received: ${JSON.stringify(t)} including a non-integer number `+a)}return t;var s}function Nf(t,e,n,s,r=1){if(null==t)return t;let a;return a="same"===n?t:t-(e+(e-1)*(r-1))+1,Math.floor((a+s-1)/s)}function If(t,e,n,s){if(null==t)return null;if("valid"===s)t=t*e+yh([n-e,0]);else{if("same"!==s)throw new Nc(`Unsupport padding mode: ${s}.`);t*=e}return t}function Cf(t,e){return Jn(()=>(ah(e),"channelsFirst"===e?cn(t,[0,2,3,1]):t))}function Sf(t,e){return Jn(()=>(ah(e),"channelsFirst"===e?cn(t,[0,2,3,4,1]):t))}function Tf(t,e,n,s=1,r="valid",a,i=1){return Jn(()=>{if(null==a&&(a="channelsLast"),ah(a),3!==t.shape.length)throw new Nc("The input of a conv1dWithBias operation should be 3, but is "+t.shape.length+" instead.");if(3!==e.shape.length)throw new Nc("The kernel for a conv1dWithBias operation should be 3, but is "+e.shape.length+" instead");if(null!=n&&1!==n.shape.length)throw new Nc("The bias for a conv1dWithBias operation should be 1, but is "+e.shape.length+" instead");if("channelsFirst"===a&&(t=cn(t,[0,2,1])),"causal"===r)throw new Ic("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");let o=cr(t,e,s,"same"===r?"same":"valid","NWC",i);return null!=n&&(o=Dh(o,n)),o})}function Ef(t,e,n,s=[1,1],r="valid",a,i,o=null){return Jn(()=>{if(null==a&&(a="channelsLast"),ah(a),3!==t.rank&&4!==t.rank)throw new Nc(`conv2dWithBiasActivation expects input to be of rank 3 or 4, but received ${t.rank}.`);if(3!==e.rank&&4!==e.rank)throw new Nc(`conv2dWithBiasActivation expects kernel to be of rank 3 or 4, but received ${t.rank}.`);let l=Cf(t,a);if("causal"===r)throw new Ic("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");return l=_o({x:l,filter:e,strides:s,pad:"same"===r?"same":"valid",dilations:i,dataFormat:"NHWC",bias:n,activation:o}),"channelsFirst"===a&&(l=cn(l,[0,3,1,2])),l})}function $f(t,e,n,s=[1,1,1],r="valid",a,i){return Jn(()=>{if(null==a&&(a="channelsLast"),ah(a),4!==t.rank&&5!==t.rank)throw new Nc("conv3dWithBias expects input to be of rank 4 or 5, but received "+t.rank+".");if(4!==e.rank&&5!==e.rank)throw new Nc("conv3dWithBias expects kernel to be of rank 4 or 5, but received "+t.rank+".");let o=Sf(t,a);if("causal"===r)throw new Ic("The support for CAUSAL padding mode in conv3dWithBias is not implemented yet.");return o=dr(o,e,s,"same"===r?"same":"valid","NDHWC",i),null!=n&&(o=Dh(o,n)),"channelsFirst"===a&&(o=cn(o,[0,4,1,2,3])),o})}vf.className="Softmax",Wn(vf);class Af extends vp{constructor(t,e){if(super(e),this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",Af.verifyArgs(e),this.rank=t,Wc(this.rank,"rank"),1!==this.rank&&2!==this.rank&&3!==this.rank)throw new Ic(`Convolution layer for rank other than 1, 2, or 3 (${this.rank}) is not implemented yet.`);if(this.kernelSize=kf(e.kernelSize,t,"kernelSize"),this.strides=kf(null==e.strides?1:e.strides,t,"strides"),this.padding=null==e.padding?"valid":e.padding,ih(this.padding),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,ah(this.dataFormat),this.activation=lf(e.activation),this.useBias=null==e.useBias||e.useBias,this.biasInitializer=np(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.biasConstraint=Zc(e.biasConstraint),this.biasRegularizer=mf(e.biasRegularizer),this.activityRegularizer=mf(e.activityRegularizer),this.dilationRate=kf(null==e.dilationRate?1:e.dilationRate,t,"dilationRate"),1===this.rank&&Array.isArray(this.dilationRate)&&1!==this.dilationRate.length)throw new Nc("dilationRate must be a number or an array of a single number for 1D convolution, but received "+JSON.stringify(this.dilationRate));if(2===this.rank){if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate];else if(2!==this.dilationRate.length)throw new Nc("dilationRate must be a number or array of two numbers for 2D convolution, but received "+JSON.stringify(this.dilationRate))}else if(3===this.rank)if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate,this.dilationRate];else if(3!==this.dilationRate.length)throw new Nc("dilationRate must be a number or array of three numbers for 3D convolution, but received "+JSON.stringify(this.dilationRate))}static verifyArgs(t){if(Tc("kernelSize"in t,"required key 'kernelSize' not in config"),"number"!=typeof t.kernelSize&&!Pc(t.kernelSize,"number",1,3))throw new Nc(`BaseConv expects config.kernelSize to be number or number[] with length 1, 2, or 3, but received ${JSON.stringify(t.kernelSize)}.`)}getConfig(){const t={kernelSize:this.kernelSize,strides:this.strides,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,activation:af(this.activation),useBias:this.useBias,biasInitializer:ep(this.biasInitializer),biasRegularizer:df(this.biasRegularizer),activityRegularizer:df(this.activityRegularizer),biasConstraint:Yc(this.biasConstraint)},e=super.getConfig();return Object.assign(t,e),t}}class Rf extends Af{constructor(t,e){super(t,e),this.kernel=null,Rf.verifyArgs(e),this.filters=e.filters,Wc(this.filters,"filters"),this.kernelInitializer=np(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.kernelConstraint=Zc(e.kernelConstraint),this.kernelRegularizer=mf(e.kernelRegularizer)}build(t){t=hp(t);const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new Nc("The channel dimension of the input should be defined. Found "+t[e]);const n=t[e],s=this.kernelSize.concat([n,this.filters]);this.kernel=this.addWeight("kernel",s,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[{ndim:this.rank+2,axes:{[e]:n}}],this.built=!0}call(t,e){return Jn(()=>{let e;t=cp(t);const n=null==this.bias?null:this.bias.read(),s=Vc(this.activation.getClassName());if(null!=s&&2===this.rank)e=Ef(t,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate,s);else{if(1===this.rank)e=Tf(t,this.kernel.read(),n,this.strides[0],this.padding,this.dataFormat,this.dilationRate[0]);else if(2===this.rank)e=Ef(t,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate);else{if(3!==this.rank)throw new Ic("convolutions greater than 3D are not implemented yet.");e=$f(t,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate)}null!=this.activation&&(e=this.activation.apply(e))}return e})}computeOutputShape(t){t=hp(t);const e=[],n="channelsLast"===this.dataFormat?t.slice(1,t.length-1):t.slice(2);for(let t=0;t<n.length;++t){const s=Nf(n[t],this.kernelSize[t],this.padding,this.strides[t],"number"==typeof this.dilationRate?this.dilationRate:this.dilationRate[t]);e.push(s)}let s=[t[0]];return"channelsLast"===this.dataFormat?(s=s.concat(e),s.push(this.filters)):(s.push(this.filters),s=s.concat(e)),s}getConfig(){const t={filters:this.filters,kernelInitializer:ep(this.kernelInitializer),kernelRegularizer:df(this.kernelRegularizer),kernelConstraint:Yc(this.kernelConstraint)},e=super.getConfig();return Object.assign(t,e),t}static verifyArgs(t){if(!("filters"in t)||"number"!=typeof t.filters||t.filters<1)throw new Nc("Convolution layer expected config.filters to be a 'number' > 0 but got "+JSON.stringify(t.filters))}}class Df extends Rf{constructor(t){super(2,t),Df.verifyArgs(t)}getConfig(){const t=super.getConfig();return delete t.rank,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&!Pc(t.kernelSize,"number",1,2))throw new Nc(`Conv2D expects config.kernelSize to be number or number[] with length 1 or 2, but received ${JSON.stringify(t.kernelSize)}.`)}}Df.className="Conv2D",Wn(Df);class _f extends Rf{constructor(t){super(3,t),_f.verifyArgs(t)}getConfig(){const t=super.getConfig();return delete t.rank,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&(!Array.isArray(t.kernelSize)||1!==t.kernelSize.length&&3!==t.kernelSize.length))throw new Nc(`Conv3D expects config.kernelSize to be number or [number, number, number], but received ${JSON.stringify(t.kernelSize)}.`)}}_f.className="Conv3D",Wn(_f);class Ff extends Df{constructor(t){if(super(t),this.inputSpec=[new gp({ndim:4})],"same"!==this.padding&&"valid"!==this.padding)throw new Nc("Conv2DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode "+this.padding)}build(t){if(4!==(t=hp(t)).length)throw new Nc("Input should have rank 4; Received input shape: "+JSON.stringify(t));const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new Nc("The channel dimension of the inputs should be defined. Found `None`.");const n=t[e],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new gp({ndim:4,axes:{[e]:n}})],this.built=!0}call(t,e){return Jn(()=>{let e=cp(t);if(4!==e.shape.length)throw new Nc("Conv2DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-"+e.shape.length);const n=e.shape,s=n[0];let r,a;"channelsFirst"===this.dataFormat?(r=2,a=3):(r=1,a=2);const i=n[r],o=n[a],l=this.kernelSize[0],u=this.kernelSize[1],c=this.strides[0],h=this.strides[1],p=[s,If(i,c,l,this.padding),If(o,h,u,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(e=cn(e,[0,2,3,1]));let d=pr(e,this.kernel.read(),p,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(d=cn(d,[0,3,1,2])),null!=this.bias&&(d=Dh(d,this.bias.read(),this.dataFormat)),null!=this.activation&&(d=this.activation.apply(d)),d})}computeOutputShape(t){const e=(t=hp(t)).slice();let n,s,r;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3):(n=3,s=1,r=2);const a=this.kernelSize[0],i=this.kernelSize[1],o=this.strides[0],l=this.strides[1];return e[n]=this.filters,e[s]=If(e[s],o,a,this.padding),e[r]=If(e[r],l,i,this.padding),e}getConfig(){const t=super.getConfig();return delete t.dilationRate,t}}Ff.className="Conv2DTranspose",Wn(Ff);class Of extends Rf{constructor(t,e){if(super(t,e),this.DEFAULT_DEPTHWISE_INITIALIZER="glorotUniform",this.DEFAULT_POINTWISE_INITIALIZER="glorotUniform",this.depthwiseKernel=null,this.pointwiseKernel=null,null==e.filters)throw new Nc("The `filters` configuration field is required by SeparableConv, but is unspecified.");if(null!=e.kernelInitializer||null!=e.kernelRegularizer||null!=e.kernelConstraint)throw new Nc("Fields kernelInitializer, kernelRegularizer and kernelConstraint are invalid for SeparableConv2D. Use depthwiseInitializer, depthwiseRegularizer, depthwiseConstraint, pointwiseInitializer, pointwiseRegularizer and pointwiseConstraint instead.");if(null!=e.padding&&"same"!==e.padding&&"valid"!==e.padding)throw new Nc(`SeparableConv${this.rank}D supports only padding modes: 'same' and 'valid', but received `+JSON.stringify(e.padding));this.depthMultiplier=null==e.depthMultiplier?1:e.depthMultiplier,this.depthwiseInitializer=np(e.depthwiseInitializer||this.DEFAULT_DEPTHWISE_INITIALIZER),this.depthwiseRegularizer=mf(e.depthwiseRegularizer),this.depthwiseConstraint=Zc(e.depthwiseConstraint),this.pointwiseInitializer=np(e.depthwiseInitializer||this.DEFAULT_POINTWISE_INITIALIZER),this.pointwiseRegularizer=mf(e.pointwiseRegularizer),this.pointwiseConstraint=Zc(e.pointwiseConstraint)}build(t){if((t=hp(t)).length<this.rank+2)throw new Nc(`Inputs to SeparableConv${this.rank}D should have rank `+(this.rank+2)+", but received input shape: "+JSON.stringify(t));const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e]||t[e]<0)throw new Nc("The channel dimension of the inputs should be defined, but found "+JSON.stringify(t[e]));const n=t[e],s=this.kernelSize.concat([n,this.depthMultiplier]),r=[];for(let t=0;t<this.rank;++t)r.push(1);r.push(n*this.depthMultiplier,this.filters);this.depthwiseKernel=this.addWeight("depthwise_kernel",s,"float32",this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.pointwiseKernel=this.addWeight("pointwise_kernel",r,"float32",this.pointwiseInitializer,this.pointwiseRegularizer,!0,this.pointwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.inputSpec=[new gp({ndim:this.rank+2,axes:{[e]:n}})],this.built=!0}call(t,e){return Jn(()=>{let e;if(t=cp(t),1===this.rank)throw new Ic("1D separable convolution is not implemented yet.");return 2===this.rank&&("channelsFirst"===this.dataFormat&&(t=cn(t,[0,2,3,1])),e=Ni(t,this.depthwiseKernel.read(),this.pointwiseKernel.read(),this.strides,this.padding,this.dilationRate,"NHWC")),this.useBias&&(e=Dh(e,this.bias.read(),this.dataFormat)),null!=this.activation&&(e=this.activation.apply(e)),"channelsFirst"===this.dataFormat&&(e=cn(e,[0,3,1,2])),e})}getConfig(){const t=super.getConfig();return delete t.rank,delete t.kernelInitializer,delete t.kernelRegularizer,delete t.kernelConstraint,t.depthwiseInitializer=ep(this.depthwiseInitializer),t.pointwiseInitializer=ep(this.pointwiseInitializer),t.depthwiseRegularizer=df(this.depthwiseRegularizer),t.pointwiseRegularizer=df(this.pointwiseRegularizer),t.depthwiseConstraint=Yc(this.depthwiseConstraint),t.pointwiseConstraint=Yc(this.pointwiseConstraint),t}}Of.className="SeparableConv";class Mf extends Of{constructor(t){super(2,t)}}Mf.className="SeparableConv2D",Wn(Mf);class Lf extends Rf{constructor(t){super(1,t),Lf.verifyArgs(t),this.inputSpec=[{ndim:3}]}getConfig(){const t=super.getConfig();return delete t.rank,delete t.dataFormat,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&!Pc(t.kernelSize,"number",1,1))throw new Nc(`Conv1D expects config.kernelSize to be number or number[] with length 1, but received ${JSON.stringify(t.kernelSize)}.`)}}Lf.className="Conv1D",Wn(Lf);class zf extends vp{constructor(t){super(t),"number"==typeof t.cropping?this.cropping=[[t.cropping,t.cropping],[t.cropping,t.cropping]]:"number"==typeof t.cropping[0]?this.cropping=[[t.cropping[0],t.cropping[0]],[t.cropping[1],t.cropping[1]]]:this.cropping=t.cropping,this.dataFormat=void 0===t.dataFormat?"channelsLast":t.dataFormat,this.inputSpec=[{ndim:4}]}computeOutputShape(t){return"channelsFirst"===this.dataFormat?[t[0],t[1],t[2]-this.cropping[0][0]-this.cropping[0][1],t[3]-this.cropping[1][0]-this.cropping[1][1]]:[t[0],t[1]-this.cropping[0][0]-this.cropping[0][1],t[2]-this.cropping[1][0]-this.cropping[1][1],t[3]]}call(t,e){return Jn(()=>{if(t=cp(t),"channelsLast"===this.dataFormat){const e=Nh(t,this.cropping[0][0],t.shape[1]-this.cropping[0][0]-this.cropping[0][1],2);return Nh(e,this.cropping[1][0],t.shape[2]-this.cropping[1][1]-this.cropping[1][0],3)}{const e=Nh(t,this.cropping[0][0],t.shape[2]-this.cropping[0][0]-this.cropping[0][1],3);return Nh(e,this.cropping[1][0],t.shape[3]-this.cropping[1][1]-this.cropping[1][0],4)}})}getConfig(){const t={cropping:this.cropping,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}zf.className="Cropping2D",Wn(zf);class Bf extends vp{constructor(t){super(t),this.DEFAULT_SIZE=[2,2],this.inputSpec=[{ndim:4}],this.size=null==t.size?this.DEFAULT_SIZE:t.size,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat}computeOutputShape(t){if("channelsFirst"===this.dataFormat){const e=null==t[2]?null:this.size[0]*t[2],n=null==t[3]?null:this.size[1]*t[3];return[t[0],t[1],e,n]}{const e=null==t[1]?null:this.size[0]*t[1],n=null==t[2]?null:this.size[1]*t[2];return[t[0],e,n,t[3]]}}call(t,e){return Jn(()=>{let e=cp(t);const n=e.shape;if("channelsFirst"===this.dataFormat){e=cn(e,[0,2,3,1]);const t=this.size[0]*n[2],s=this.size[1]*n[3],r=e.resizeNearestNeighbor([t,s]);return cn(r,[0,3,1,2])}{const t=this.size[0]*n[1],s=this.size[1]*n[2];return e.resizeNearestNeighbor([t,s])}})}getConfig(){const t={size:this.size,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}Bf.className="UpSampling2D",Wn(Bf);class Pf extends Af{constructor(t){super(2,t),this.depthwiseKernel=null,this.depthMultiplier=null==t.depthMultiplier?1:t.depthMultiplier,this.depthwiseInitializer=np(t.depthwiseInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.depthwiseConstraint=Zc(t.depthwiseConstraint),this.depthwiseRegularizer=mf(t.depthwiseRegularizer)}build(t){if((t=hp(t)).length<4)throw new Nc(`Inputs to DepthwiseConv2D should have rank 4. Received input shape: ${JSON.stringify(t)}.`);const e="channelsFirst"===this.dataFormat?1:3;if(null==t[e]||t[e]<0)throw new Nc(`The channel dimension of the inputs to DepthwiseConv2D should be defined, but is not (${t[e]}).`);const n=t[e],s=[this.kernelSize[0],this.kernelSize[1],n,this.depthMultiplier];this.depthwiseKernel=this.addWeight("depthwise_kernel",s,null,this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[n*this.depthMultiplier],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(t,e){return Jn(()=>{let e=function(t,e,n=[1,1],s="valid",r,a){return Jn(()=>{null==r&&(r="channelsLast"),ah(r);let i=Cf(t,r);if(4!==t.rank)throw new Nc("Input for depthwiseConv2d is required to be 4-D, but is instead "+t.rank+"-D");if(4!==e.rank)throw new Nc("depthwiseKernel is required to be 4-D, but is instead "+e.rank+"-D");return i=wr(i,e,n,"same"===s?"same":"valid","NHWC",a),"channelsFirst"===r&&(i=cn(i,[0,3,1,2])),i})}(t=cp(t),this.depthwiseKernel.read(),this.strides,this.padding,this.dataFormat,null);return this.useBias&&(e=Dh(e,this.bias.read(),this.dataFormat)),null!=this.activation&&(e=this.activation.apply(e)),e})}computeOutputShape(t){t=hp(t);const e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2],s="channelsFirst"===this.dataFormat?t[1]*this.depthMultiplier:t[3]*this.depthMultiplier,r=Nf(e,this.kernelSize[0],this.padding,this.strides[0]),a=Nf(n,this.kernelSize[1],this.padding,this.strides[1]);return"channelsFirst"===this.dataFormat?[t[0],s,r,a]:[t[0],r,a,s]}getConfig(){const t=super.getConfig();return t.depthMultiplier=this.depthMultiplier,t.depthwiseInitializer=ep(this.depthwiseInitializer),t.depthwiseRegularizer=df(this.depthwiseRegularizer),t.depthwiseConstraint=Yc(this.depthwiseRegularizer),t}}function Wf(t,e,n,s){if(Array.isArray(t)){if(null!=e||null!=n)throw new Nc("When inputs is an array, neither initialState or constants should be provided");null!=s&&(n=t.slice(t.length-s,t.length),t=t.slice(0,t.length-s)),t.length>1&&(e=t.slice(1,t.length)),t=t[0]}function r(t){return null==t||Array.isArray(t)?t:[t]}return{inputs:t,initialState:e=r(e),constants:n=r(n)}}function Vf(t,e,n,s=!1,r,a,i=!1,o=!1){return Jn(()=>{const l=e.shape.length;if(l<3)throw new Nc(`Input should be at least 3D, but is ${l}D.`);const u=[1,0].concat(bh(2,l));if(e=cn(e,u),null!=a)throw new Ic("The rnn() functoin of the deeplearn.js backend does not support constants yet.");i&&console.warn("Backend rnn(): the unroll = true option is not applicable to the imperative deeplearn.js backend."),null!=r&&((r=r.asType("bool").asType("float32")).rank===l-1&&(r=Fr(r,-1)),r=cn(r,u)),s&&(e=mi(e,0),null!=r&&(r=mi(r,0)));const c=[];let h,p=n;const d=e.shape[0],f=Zi(e);let m,g;null!=r&&(m=Zi(r));for(let e=0;e<d;++e){const n=f[e],s=Jn(()=>t(n,p));if(null==r)h=s[0],p=s[1];else{const t=Jn(()=>{const t=m[e],n=Ma(t).sub(t);return{output:s[0].mul(t).add(p[0].mul(n)),newStates:p.map((e,r)=>s[1][r].mul(t).add(e.mul(n)))}});h=t.output,p=t.newStates}o&&c.push(h)}if(o){g=Vi(c,1)}return[h,g,p]})}Pf.className="DepthwiseConv2D",Wn(Pf);class Uf extends vp{constructor(t){let e;if(super(t),null==t.cell)throw new Nc("cell property is missing for the constructor of RNN.");if(e=Array.isArray(t.cell)?new Jf({cells:t.cell}):t.cell,null==e.stateSize)throw new Nc("The RNN cell should have an attribute `stateSize` (tuple of integers, one integer per RNN state).");this.cell=e,this.returnSequences=null!=t.returnSequences&&t.returnSequences,this.returnState=null!=t.returnState&&t.returnState,this.goBackwards=null!=t.goBackwards&&t.goBackwards,this._stateful=null!=t.stateful&&t.stateful,this.unroll=null!=t.unroll&&t.unroll,this.supportsMasking=!0,this.inputSpec=[new gp({ndim:3})],this.stateSpec=null,this.states_=null,this.numConstants=null,this.keptStates=[]}getStates(){if(null==this.states_){return bh(0,Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1).map(t=>null)}return this.states_}setStates(t){this.states_=t}computeOutputShape(t){lp(t)&&(t=t[0]),t=t;let e=this.cell.stateSize;Array.isArray(e)||(e=[e]);const n=e[0];let s;if(s=this.returnSequences?[t[0],t[1],n]:[t[0],n],this.returnState){const n=[];for(const s of e)n.push([t[0],s]);return[s].concat(n)}return s}computeMask(t,e){return Jn(()=>{Array.isArray(e)&&(e=e[0]);const t=this.returnSequences?e:null;if(this.returnState){const e=this.states.map(t=>null);return[t].concat(e)}return t})}get states(){if(null==this.states_){const t=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1,e=[];for(let n=0;n<t;++n)e.push(null);return e}return this.states_}set states(t){this.states_=t}build(t){if(null!=this.numConstants)throw new Ic("Constants support is not implemented in RNN yet.");lp(t)&&(t=t[0]),t=t;const e=this.stateful?t[0]:null,n=t.slice(2);this.inputSpec[0]=new gp({shape:[e,null,...n]});const s=[t[0]].concat(t.slice(2));let r;if(this.cell.build(s),r=Array.isArray(this.cell.stateSize)?this.cell.stateSize:[this.cell.stateSize],null!=this.stateSpec){if(!d(this.stateSpec.map(t=>t.shape[t.shape.length-1]),r))throw new Nc(`An initialState was passed that is not compatible with cell.stateSize. Received stateSpec=${this.stateSpec}; However cell.stateSize is `+this.cell.stateSize)}else this.stateSpec=r.map(t=>new gp({shape:[null,t]}));this.stateful&&this.resetStates()}resetStates(t,e=!1){Jn(()=>{if(!this.stateful)throw new vc("Cannot call resetStates() on an RNN Layer that is not stateful.");const n=this.inputSpec[0].shape[0];if(null==n)throw new Nc("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.states_)Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(t=>Na([n,t])):this.states_=[Na([n,this.cell.stateSize])];else if(null==t)Zn(this.states_),null!=this.keptStates&&(Zn(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(t=>Na([n,t])):this.states_[0]=Na([n,this.cell.stateSize]);else{if(Array.isArray(t)||(t=[t]),t.length!==this.states_.length)throw new Nc(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${t.length} state value(s). Input received: `+t);!0===e?this.keptStates.push(this.states_.slice()):Zn(this.states_);for(let e=0;e<this.states_.length;++e){const s=t[e],r=Array.isArray(this.cell.stateSize)?this.cell.stateSize[e]:this.cell.stateSize,a=[n,r];if(!d(s.shape,a))throw new Nc(`State ${e} is incompatible with layer ${this.name}: expected shape=${a}, received shape=${s.shape}`);this.states_[e]=s}}this.states_=this.states_.map(t=>Qn(t.clone()))})}apply(t,e){let n=null==e?null:e.initialState,s=null==e?null:e.constants;null==e&&(e={});const r=Wf(t,n,s,this.numConstants);t=r.inputs,n=r.initialState,s=r.constants;let a=[],i=[];if(null!=n){e.initialState=n,a=a.concat(n),this.stateSpec=[];for(const t of n)this.stateSpec.push(new gp({shape:t.shape}));i=i.concat(this.stateSpec)}if(null!=s&&(e.constants=s,a=a.concat(s),this.numConstants=s.length),a[0]instanceof yp){const n=[t].concat(a),s=this.inputSpec.concat(i),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,e);return this.inputSpec=r,o}return super.apply(t,e)}call(t,e){return Jn(()=>{const n=null==e?null:e.mask,s=null==e?null:e.training;let r=null==e?null:e.initialState;t=cp(t),null==r&&(r=this.stateful?this.states_:this.getInitialState(t));const a=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1;if(r.length!==a)throw new Nc(`RNN Layer has ${a} state(s) but was passed `+r.length+" initial state(s).");this.unroll&&console.warn("Ignoring unroll = true for RNN layer, due to imperative backend.");const i={training:s},o=Vf((t,e)=>{const n=this.cell.call([t].concat(e),i);return[n[0],n.slice(1)]},t,r,this.goBackwards,n,null,this.unroll,this.returnSequences),l=o[0],u=o[1],c=o[2];this.stateful&&this.resetStates(c,s);const h=this.returnSequences?u:l;return this.returnState?[h].concat(c):h})}getInitialState(t){return Jn(()=>{let e=Na(t.shape);return e=da(e,[1,2]),e=wh(e),Array.isArray(this.cell.stateSize)?this.cell.stateSize.map(t=>t>1?Sh(e,[1,t]):e):this.cell.stateSize>1?[Sh(e,[1,this.cell.stateSize])]:[e]})}get trainableWeights(){return this.trainable?this.cell.trainableWeights:[]}get nonTrainableWeights(){return this.trainable?this.cell.nonTrainableWeights:this.cell.weights}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.cell&&this.cell.setFastWeightInitDuringBuild(t)}getConfig(){const t=super.getConfig(),e={returnSequences:this.returnSequences,returnState:this.returnState,goBackwards:this.goBackwards,stateful:this.stateful,unroll:this.unroll};null!=this.numConstants&&(e.numConstants=this.numConstants);const n=this.cell.getConfig();return this.getClassName()===Uf.className&&(e.cell={className:this.cell.getClassName(),config:n}),Object.assign({},n,t,e)}static fromConfig(t,e,n={}){const s=Op(e.cell,n);return new t(Object.assign(e,{cell:s}))}}Uf.className="RNN",Wn(Uf);class Gf extends vp{}class Hf extends Gf{constructor(t){super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=t.units,Wc(this.units,"units"),this.activation=lf(null==t.activation?this.DEFAULT_ACTIVATION:t.activation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=np(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=np(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=np(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=mf(t.kernelRegularizer),this.recurrentRegularizer=mf(t.recurrentRegularizer),this.biasRegularizer=mf(t.biasRegularizer),this.kernelConstraint=Zc(t.kernelConstraint),this.recurrentConstraint=Zc(t.recurrentConstraint),this.biasConstraint=Zc(t.biasConstraint),this.dropout=gh([1,yh([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=gh([1,yh([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){t=hp(t),this.kernel=this.addWeight("kernel",[t[t.length-1],this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(t,e){return Jn(()=>{if(2!==(t=t).length)throw new Nc(`SimpleRNNCell expects 2 input Tensors, got ${t.length}.`);let n=t[1];t=t[0];const s=null!=e.training&&e.training;let r;0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Zf({ones:()=>Ma(t),rate:this.dropout,training:s})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Zf({ones:()=>Ma(n),rate:this.recurrentDropout,training:s}));const a=this.dropoutMask,i=this.recurrentDropoutMask;r=Eh(null!=a?is(t,a):t,this.kernel.read()),null!=this.bias&&(r=Dh(r,this.bias.read())),null!=i&&(n=is(n,i));let o=ss(r,Eh(n,this.recurrentKernel.read()));return null!=this.activation&&(o=this.activation.apply(o)),[o,o]})}getConfig(){const t=super.getConfig(),e={units:this.units,activation:af(this.activation),useBias:this.useBias,kernelInitializer:ep(this.kernelInitializer),recurrentInitializer:ep(this.recurrentInitializer),biasInitializer:ep(this.biasInitializer),kernelRegularizer:df(this.kernelRegularizer),recurrentRegularizer:df(this.recurrentRegularizer),biasRegularizer:df(this.biasRegularizer),activityRegularizer:df(this.activityRegularizer),kernelConstraint:Yc(this.kernelConstraint),recurrentConstraint:Yc(this.recurrentConstraint),biasConstraint:Yc(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout};return Object.assign({},t,e)}}Hf.className="SimpleRNNCell",Wn(Hf);class jf extends Uf{constructor(t){t.cell=new Hf(t),super(t)}call(t,e){return Jn(()=>{null!=this.cell.dropoutMask&&(Zn(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(Zn(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==e?null:e.mask,s=null==e?null:e.training,r=null==e?null:e.initialState;return super.call(t,{mask:n,training:s,initialState:r})})}static fromConfig(t,e){return new t(e)}}jf.className="SimpleRNN",Wn(jf);class qf extends Gf{constructor(t){if(super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",t.resetAfter)throw new Nc("GRUCell does not support reset_after parameter set to true.");this.units=t.units,Wc(this.units,"units"),this.activation=lf(void 0===t.activation?this.DEFAULT_ACTIVATION:t.activation),this.recurrentActivation=lf(void 0===t.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:t.recurrentActivation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=np(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=np(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=np(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=mf(t.kernelRegularizer),this.recurrentRegularizer=mf(t.recurrentRegularizer),this.biasRegularizer=mf(t.biasRegularizer),this.kernelConstraint=Zc(t.kernelConstraint),this.recurrentConstraint=Zc(t.recurrentConstraint),this.biasConstraint=Zc(t.biasConstraint),this.dropout=gh([1,yh([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=gh([1,yh([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.implementation=t.implementation,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){const e=(t=hp(t))[t.length-1];this.kernel=this.addWeight("kernel",[e,3*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,3*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[3*this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(t,e){return Jn(()=>{if(2!==(t=t).length)throw new Nc("GRUCell expects 2 input Tensors (inputs, h, c), got "+t.length+".");const n=null!=e.training&&e.training;let s=t[1];t=t[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Zf({ones:()=>Ma(t),rate:this.dropout,training:n,count:3})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Zf({ones:()=>Ma(s),rate:this.recurrentDropout,training:n,count:3}));const r=this.dropoutMask,a=this.recurrentDropoutMask;let i,o,l;0<this.dropout&&this.dropout<1&&(t=is(t,r[0]));let u=Eh(t,this.kernel.read());this.useBias&&(u=Dh(u,this.bias.read())),0<this.recurrentDropout&&this.recurrentDropout<1&&(s=is(s,a[0]));const c=this.recurrentKernel.read(),[h,p]=Li(c,[2*this.units,this.units],c.rank-1),d=Eh(s,h),[f,m,g]=Li(u,3,u.rank-1),[y,b]=Li(d,2,d.rank-1);i=this.recurrentActivation.apply(ss(f,y)),o=this.recurrentActivation.apply(ss(m,b));const x=Eh(is(o,s),p);l=this.activation.apply(ss(g,x));const w=ss(is(i,s),is(ss(1,la(i)),l));return[w,w]})}getConfig(){const t=super.getConfig(),e={units:this.units,activation:af(this.activation),recurrentActivation:af(this.recurrentActivation),useBias:this.useBias,kernelInitializer:ep(this.kernelInitializer),recurrentInitializer:ep(this.recurrentInitializer),biasInitializer:ep(this.biasInitializer),kernelRegularizer:df(this.kernelRegularizer),recurrentRegularizer:df(this.recurrentRegularizer),biasRegularizer:df(this.biasRegularizer),activityRegularizer:df(this.activityRegularizer),kernelConstraint:Yc(this.kernelConstraint),recurrentConstraint:Yc(this.recurrentConstraint),biasConstraint:Yc(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation,resetAfter:!1};return Object.assign({},t,e)}}qf.className="GRUCell",Wn(qf);class Kf extends Uf{constructor(t){0===t.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),t.cell=new qf(t),super(t)}call(t,e){return Jn(()=>{null!=this.cell.dropoutMask&&(Zn(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(Zn(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==e?null:e.mask,s=null==e?null:e.training,r=null==e?null:e.initialState;return super.call(t,{mask:n,training:s,initialState:r})})}static fromConfig(t,e){return 0===e.implmentation&&(e.implementation=1),new t(e)}}Kf.className="GRU",Wn(Kf);class Xf extends Gf{constructor(t){super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=t.units,Wc(this.units,"units"),this.activation=lf(void 0===t.activation?this.DEFAULT_ACTIVATION:t.activation),this.recurrentActivation=lf(void 0===t.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:t.recurrentActivation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=np(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=np(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=np(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.unitForgetBias=t.unitForgetBias,this.kernelRegularizer=mf(t.kernelRegularizer),this.recurrentRegularizer=mf(t.recurrentRegularizer),this.biasRegularizer=mf(t.biasRegularizer),this.kernelConstraint=Zc(t.kernelConstraint),this.recurrentConstraint=Zc(t.recurrentConstraint),this.biasConstraint=Zc(t.biasConstraint),this.dropout=gh([1,yh([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=gh([1,yh([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.implementation=t.implementation,this.stateSize=[this.units,this.units],this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){var e;const n=(t=hp(t))[t.length-1];let s;if(this.kernel=this.addWeight("kernel",[n,4*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,4*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){if(this.unitForgetBias){const t=this.biasInitializer,n=this.units;s=new((e=class extends Lh{apply(e,s){const r=t.apply([n]),a=(new Bh).apply([n]),i=t.apply([2*n]);return Ch(Ch(r,a),i)}}).className="CustomInit",e)}else s=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.units],null,s,this.biasRegularizer,!0,this.biasConstraint)}else this.bias=null;this.built=!0}call(t,e){return Jn(()=>{const n=null!=e.training&&e.training;if(3!==(t=t).length)throw new Nc("LSTMCell expects 3 input Tensors (inputs, h, c), got "+t.length+".");let s=t[1];const r=t[2];t=t[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Zf({ones:()=>Ma(t),rate:this.dropout,training:n,count:4})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Zf({ones:()=>Ma(s),rate:this.recurrentDropout,training:n,count:4}));const a=this.dropoutMask,i=this.recurrentDropoutMask;let o,l,u,c;0<this.dropout&&this.dropout<1&&(t=is(t,a[0]));let h=Eh(t,this.kernel.read());0<this.recurrentDropout&&this.recurrentDropout<1&&(s=is(s,i[0])),h=ss(h,Eh(s,this.recurrentKernel.read())),this.useBias&&(h=Dh(h,this.bias.read()));const[p,d,f,m]=Li(h,4,h.rank-1);o=this.recurrentActivation.apply(p),l=this.recurrentActivation.apply(d),u=ss(is(l,r),is(o,this.activation.apply(f))),c=this.recurrentActivation.apply(m);const g=is(c,this.activation.apply(u));return[g,g,u]})}getConfig(){const t=super.getConfig(),e={units:this.units,activation:af(this.activation),recurrentActivation:af(this.recurrentActivation),useBias:this.useBias,kernelInitializer:ep(this.kernelInitializer),recurrentInitializer:ep(this.recurrentInitializer),biasInitializer:ep(this.biasInitializer),unitForgetBias:this.unitForgetBias,kernelRegularizer:df(this.kernelRegularizer),recurrentRegularizer:df(this.recurrentRegularizer),biasRegularizer:df(this.biasRegularizer),activityRegularizer:df(this.activityRegularizer),kernelConstraint:Yc(this.kernelConstraint),recurrentConstraint:Yc(this.recurrentConstraint),biasConstraint:Yc(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation};return Object.assign({},t,e)}}Xf.className="LSTMCell",Wn(Xf);class Yf extends Uf{constructor(t){0===t.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),t.cell=new Xf(t),super(t)}call(t,e){return Jn(()=>{null!=this.cell.dropoutMask&&(Zn(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(Zn(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==e?null:e.mask,s=null==e?null:e.training,r=null==e?null:e.initialState;return super.call(t,{mask:n,training:s,initialState:r})})}static fromConfig(t,e){return 0===e.implmentation&&(e.implementation=1),new t(e)}}Yf.className="LSTM",Wn(Yf);class Jf extends Gf{constructor(t){super(t),this.cells=t.cells}get stateSize(){const t=[];for(const e of this.cells.slice().reverse())Array.isArray(e.stateSize)?t.push(...e.stateSize):t.push(e.stateSize);return t}call(t,e){return Jn(()=>{let n=(t=t).slice(1);const s=[];for(const t of this.cells.slice().reverse())Array.isArray(t.stateSize)?s.push(n.splice(0,t.stateSize.length)):s.push(n.splice(0,1));s.reverse();const r=[];let a;for(let i=0;i<this.cells.length;++i){const o=this.cells[i];n=s[i],a=0===i?[t[0]].concat(n):[a[0]].concat(n),a=o.call(a,e),r.push(a.slice(1))}n=[];for(const t of r.slice().reverse())n.push(...t);return[a[0]].concat(n)})}build(t){let e;lp(t)&&(t=t[0]),t=t,this.cells.forEach((n,s)=>{uh("RNNCell_"+s,()=>{n.build(t),e=Array.isArray(n.stateSize)?n.stateSize[0]:n.stateSize,t=[t[0],e]})}),this.built=!0}getConfig(){const t=super.getConfig(),e={cells:this.cells.map(t=>({className:t.getClassName(),config:t.getConfig()}))};return Object.assign({},t,e)}static fromConfig(t,e,n={}){const s=[];for(const t of e.cells)s.push(Op(t,n));return new t({cells:s})}get trainableWeights(){if(!this.trainable)return[];const t=[];for(const e of this.cells)t.push(...e.trainableWeights);return t}get nonTrainableWeights(){const t=[];for(const e of this.cells)t.push(...e.nonTrainableWeights);if(!this.trainable){const e=[];for(const t of this.cells)e.push(...t.trainableWeights);return e.concat(t)}return t}getWeights(){const t=[];for(const e of this.cells)t.push(...e.weights);return fp(t)}setWeights(t){const e=[];for(const n of this.cells){const s=n.weights.length,r=t.splice(s);for(let t=0;t<n.weights.length;++t)e.push([n.weights[t],r[t]])}mp(e)}}function Zf(t){const{ones:e,rate:n,training:s=!1,count:r=1}=t,a=()=>_h(e(),n),i=()=>Fh(a,e,s);return!r||r<=1?Qn(i().clone()):Array(r).fill(void 0).map(i).map(t=>Qn(t.clone()))}Jf.className="StackedRNNCells",Wn(Jf);var Qf=function(t,e){var n={};for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&e.indexOf(s)<0&&(n[s]=t[s]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var r=0;for(s=Object.getOwnPropertySymbols(t);r<s.length;r++)e.indexOf(s[r])<0&&Object.prototype.propertyIsEnumerable.call(t,s[r])&&(n[s[r]]=t[s[r]])}return n};class tm extends Uf{constructor(t){if(t.unroll)throw new Ic("Unrolling is not possible with convolutional RNNs.");if(Array.isArray(t.cell))throw new Ic("It is not possible at the moment to stack convolutional cells.");super(t),this.inputSpec=[new gp({ndim:5})]}call(t,e){return Jn(()=>{if(null!=this.cell.dropoutMask&&(Zn(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(Zn(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null),e&&e.constants)throw new Nc("ConvRNN2D cell does not support constants");const n=null==e?null:e.mask,s=null==e?null:e.training,r=null==e?null:e.initialState;return super.call(t,{mask:n,training:s,initialState:r})})}computeOutputShape(t){let e=this.computeSingleOutputShape(t);return this.returnSequences||(e=[e[0],...e.slice(2)]),this.returnState&&(e=[e,...Array(2).fill([t[0],...e.slice(-3)])]),e}getInitialState(t){return Jn(()=>{const{stateSize:e}=this.cell,n=t.shape,s=this.computeSingleOutputShape(n),r=Na([s[0],...s.slice(2)]);return Array.isArray(e)?Array(e.length).fill(r):[r]})}resetStates(t,e=!1){Jn(()=>{if(!this.stateful)throw new vc("Cannot call resetStates() on an RNN Layer that is not stateful.");const n=this.inputSpec[0].shape,s=this.computeSingleOutputShape(n),r=[s[0],...s.slice(2)];if(null==n[0])throw new Nc("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.getStates())Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(()=>Na(r)):this.states_=[Na(r)];else if(null==t)Zn(this.states_),null!=this.keptStates&&(Zn(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(()=>Na(r)):this.states_[0]=Na(r);else{if(Array.isArray(t)||(t=[t]),t.length!==this.states_.length)throw new Nc(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${t.length} state value(s). Input received: `+t);e?this.keptStates.push(this.states_.slice()):Zn(this.states_);for(let e=0;e<this.states_.length;++e){const n=t[e],s=r;if(!d(n.shape,s))throw new Nc(`State ${e} is incompatible with layer ${this.name}: expected shape=${s}, received shape=${n.shape}`);this.states_[e]=n}}this.states_=this.states_.map(t=>Qn(t.clone()))})}computeSingleOutputShape(t){const{dataFormat:e,filters:n,kernelSize:s,padding:r,strides:a,dilationRate:i}=this.cell,o="channelsFirst"===e,l=t[o?3:2],u=t[o?4:3],c=Nf(l,s[0],r,a[0],i[0]),h=Nf(u,s[1],r,a[1],i[1]);return[...t.slice(0,2),...o?[n,c,h]:[c,h,n]]}}tm.className="ConvRNN2D";class em extends Xf{constructor(t){const{filters:e,kernelSize:n,strides:s,padding:r,dataFormat:a,dilationRate:i}=t;super(Object.assign({},t,{units:e})),this.filters=e,Wc(this.filters,"filters"),this.kernelSize=kf(n,2,"kernelSize"),this.kernelSize.forEach(t=>Wc(t,"kernelSize")),this.strides=kf(s||1,2,"strides"),this.strides.forEach(t=>Wc(t,"strides")),this.padding=r||"valid",ih(this.padding),this.dataFormat=a||"channelsLast",ah(this.dataFormat),this.dilationRate=kf(i||1,2,"dilationRate"),this.dilationRate.forEach(t=>Wc(t,"dilationRate"))}build(t){var e;t=hp(t);const n="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[n])throw new Nc("The channel dimension of the input should be defined. Found "+t[n]);const s=t[n],r=this.kernelSize.concat([s,4*this.filters]);this.kernel=this.addWeight("kernel",r,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint);const a=this.kernelSize.concat([this.filters,4*this.filters]);if(this.recurrentKernel=this.addWeight("recurrent_kernel",a,null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){let t;if(this.unitForgetBias){const n=this.biasInitializer,s=this.filters;t=new((e=class extends Lh{apply(t,e){return Ih([n.apply([s]),Ia([s]),n.apply([2*s])])}}).className="CustomInit",e)}else t=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.filters],null,t,this.biasRegularizer,!0,this.biasConstraint)}this.built=!0}call(t,e){return Jn(()=>{if(3!==t.length)throw new Nc("ConvLSTM2DCell expects 3 input Tensors (inputs, h, c), got "+t.length+".");const n=e.training||!1,s=t[0],r=t[1],a=t[2];0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Zf({ones:()=>Ma(s),rate:this.dropout,training:n,count:4}));const i=this.dropoutMask,o=(t,e,n)=>e&&e[n]?is(e[n],t):t;let l=o(s,i,0),u=o(s,i,1),c=o(s,i,2),h=o(s,i,3);0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Zf({ones:()=>Ma(r),rate:this.recurrentDropout,training:n,count:4}));const p=this.recurrentDropoutMask;let d=o(r,p,0),f=o(r,p,1),m=o(r,p,2),g=o(r,p,3);const[y,b,x,w]=Li(this.kernel.read(),4,3),[v,k,N,I]=this.useBias?Li(this.bias.read(),4):[null,null,null,null];l=this.inputConv(l,y,v,this.padding),u=this.inputConv(u,b,k,this.padding),c=this.inputConv(c,x,N,this.padding),h=this.inputConv(h,w,I,this.padding);const[C,S,T,E]=Li(this.recurrentKernel.read(),4,3);d=this.recurrentConv(d,C),f=this.recurrentConv(f,S),m=this.recurrentConv(m,T),g=this.recurrentConv(g,E);const $=this.recurrentActivation.apply(ss(l,d)),A=this.recurrentActivation.apply(ss(u,f)),R=ss(is(A,a),is($,this.activation.apply(ss(c,m)))),D=is(this.recurrentActivation.apply(ss(h,g)),this.activation.apply(R));return[D,D,R]})}getConfig(){const t=super.getConfig(),{units:e}=t,n=Qf(t,["units"]),s={filters:this.filters,kernelSize:this.kernelSize,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,strides:this.strides};return Object.assign({},n,s)}inputConv(t,e,n,s){const r=ur(t,e,this.strides,s||"valid","channelsFirst"===this.dataFormat?"NCHW":"NHWC",this.dilationRate);return n?Dh(r,n,this.dataFormat):r}recurrentConv(t,e){return ur(t,e,1,"same","channelsFirst"===this.dataFormat?"NCHW":"NHWC")}}em.className="ConvLSTM2DCell",Wn(em);class nm extends tm{constructor(t){const e=new em(t);super(Object.assign({},t,{cell:e}))}static fromConfig(t,e){return new t(e)}}nm.className="ConvLSTM2D",Wn(nm);class sm extends vp{constructor(t){super(t),this.rate=Math.max(Math.min(t.rate,1),0),this.noiseShape=t.noiseShape,this.seed=t.seed,this.supportsMasking=!0}getNoiseShape(t){if(null==this.noiseShape)return this.noiseShape;const e=t.shape,n=[];for(let t=0;t<this.noiseShape.length;++t)n.push(null==this.noiseShape[t]?e[t]:this.noiseShape[t]);return n}call(t,e){return Jn(()=>{this.invokeCallHook(t,e);const n=cp(t);if(0<this.rate&&this.rate<1){const t=null!=e.training&&e.training,s=this.getNoiseShape(n);return Fh(()=>_h(n,this.rate,s,this.seed),()=>n,t)}return t})}getConfig(){const t={rate:this.rate,noiseShape:this.noiseShape,seed:this.seed},e=super.getConfig();return Object.assign(t,e),t}dispose(){return super.dispose()}}sm.className="Dropout",Wn(sm);class rm extends sm{constructor(t){super(t),this.inputSpec=[{ndim:3}]}getNoiseShape(t){const e=t.shape;return[e[0],1,e[2]]}}rm.className="SpatialDropout1D",Wn(rm);class am extends vp{constructor(t){if(super(t),this.activation=null,this.useBias=!0,this.kernel=null,this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",null==t.batchInputShape&&null==t.inputShape&&null!=t.inputDim){let e=null;null!=t.batchSize&&(e=t.batchSize),this.batchInputShape=[e,t.inputDim]}this.units=t.units,Wc(this.units,"units"),this.activation=lf(t.activation),null!=t.useBias&&(this.useBias=t.useBias),this.kernelInitializer=np(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.biasInitializer=np(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelConstraint=Zc(t.kernelConstraint),this.biasConstraint=Zc(t.biasConstraint),this.kernelRegularizer=mf(t.kernelRegularizer),this.biasRegularizer=mf(t.biasRegularizer),this.activityRegularizer=mf(t.activityRegularizer),this.supportsMasking=!0,this.inputSpec=[{minNDim:2}]}build(t){const e=(t=hp(t))[t.length-1];null==this.kernel&&(this.kernel=this.addWeight("kernel",[e,this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint))),this.inputSpec=[{minNDim:2,axes:{[-1]:e}}],this.built=!0}computeOutputShape(t){const e=(t=hp(t)).slice();return e[e.length-1]=this.units,e}call(t,e){return Jn(()=>{this.invokeCallHook(t,e);const n=cp(t),s=Vc(this.activation.getClassName());let r;return null!=s?r=Eh(n,this.kernel.read(),s,this.bias?this.bias.read():null):(r=Eh(n,this.kernel.read()),null!=this.bias&&(r=Dh(r,this.bias.read())),null!=this.activation&&(r=this.activation.apply(r))),r})}getConfig(){const t={units:this.units,activation:af(this.activation),useBias:this.useBias,kernelInitializer:ep(this.kernelInitializer),biasInitializer:ep(this.biasInitializer),kernelRegularizer:df(this.kernelRegularizer),biasRegularizer:df(this.biasRegularizer),activityRegularizer:df(this.activityRegularizer),kernelConstraint:Yc(this.kernelConstraint),biasConstraint:Yc(this.biasConstraint)},e=super.getConfig();return Object.assign(t,e),t}}am.className="Dense",Wn(am);class im extends vp{constructor(t){super(t=t||{}),this.inputSpec=[{minNDim:3}],this.dataFormat=t.dataFormat}computeOutputShape(t){t=hp(t);for(const e of t.slice(1))if(null==e)throw new Nc(`The shape of the input to "Flatten" is not fully defined (got ${t.slice(1)}). Make sure to pass a complete "input_shape" or "batch_input_shape" argument to the first layer in your model.`);return[t[0],fh(t,1)]}call(t,e){return Jn(()=>{this.invokeCallHook(t,e);let n=cp(t);if("channelsFirst"===this.dataFormat&&n.rank>1){const t=[0];for(let e=2;e<n.rank;++e)t.push(e);t.push(1),n=n.transpose(t)}return function(t){if(t.rank<=1)throw new Nc(`batchFlatten requires a minimum rank of 2. Got rank: ${t.rank}.`);const e=[t.shape[0],fh(t.shape,1)];return t.reshape(e)}(n)})}getConfig(){const t={};null!=this.dataFormat&&(t.dataFormat=this.dataFormat);const e=super.getConfig();return Object.assign(t,e),t}}im.className="Flatten",Wn(im);class om extends vp{constructor(t){super(t),this.supportsMasking=!0,this.activation=lf(t.activation)}call(t,e){return Jn(()=>{this.invokeCallHook(t,e);const n=cp(t);return this.activation.apply(n)})}getConfig(){const t={activation:af(this.activation)},e=super.getConfig();return Object.assign(t,e),t}}om.className="Activation",Wn(om);class lm extends vp{constructor(t){super(t),this.n=t.n,this.inputSpec=[{ndim:2}]}computeOutputShape(t){return[t[0],this.n,t[1]]}call(t,e){return Jn(()=>{return t=cp(t),e=t,n=this.n,Jn(()=>{if(2!==e.shape.length)throw new Nc(`repeat() expects a rank-2 tensor, but received a rank-${e.shape.length} tensor.`);return Sh(wh(e,1),[1,n,1])});var e,n})}getConfig(){const t={n:this.n},e=super.getConfig();return Object.assign(t,e),t}}lm.className="RepeatVector",Wn(lm);class um extends vp{constructor(t){super(t),this.targetShape=t.targetShape;for(let t=0;t<this.targetShape.length;++t)this.isUnknown(this.targetShape[t])&&(this.targetShape[t]=null)}isUnknown(t){return t<0||null==t}fixUnknownDimension(t,e){const n="Total size of new array must be unchanged.",s=e.slice();let r=1,a=null;for(let t=0;t<s.length;++t){const e=s[t];if(this.isUnknown(e)){if(null!==a)throw new Nc("Can only specifiy one unknown dimension.");a=t}else r*=e}const i=fh(t);if(null!==a){if(0===r||i%r!=0)throw new Nc(n);s[a]=i/r}else if(i!==r)throw new Nc(n);return s}computeOutputShape(t){let e=!1;for(let n=0;n<t.length;++n)if(this.isUnknown(t[n])){e=!0;break}return e?t.slice(0,1).concat(this.targetShape):t.slice(0,1).concat(this.fixUnknownDimension(t.slice(1),this.targetShape))}call(t,e){return Jn(()=>{this.invokeCallHook(t,e);const n=cp(t),s=n.shape,r=s.slice(0,1).concat(this.fixUnknownDimension(s.slice(1),this.targetShape));return n.reshape(r)})}getConfig(){const t={targetShape:this.targetShape},e=super.getConfig();return Object.assign(t,e),t}}um.className="Reshape",Wn(um);class cm extends vp{constructor(t){if(super(t),null==t.dims)throw new Error("Required configuration field `dims` is missing during Permute constructor call.");if(!Array.isArray(t.dims))throw new Error("Permute constructor requires `dims` to be an Array, but received "+t.dims+" instead.");const e=bh(1,t.dims.length+1);if(!d(t.dims.slice().sort(),e))throw new Error("Invalid permutation `dims`: "+JSON.stringify(t.dims)+" `dims` must contain consecutive integers starting from 1.");this.dims=t.dims,this.dimsIncludingBatch=[0].concat(this.dims),this.inputSpec=[new gp({ndim:this.dims.length+1})]}computeOutputShape(t){const e=(t=hp(t)).slice();return this.dims.forEach((n,s)=>{e[s+1]=t[n]}),e}call(t,e){return cn(cp(t),this.dimsIncludingBatch)}getConfig(){const t={dims:this.dims},e=super.getConfig();return Object.assign(t,e),t}}cm.className="Permute",Wn(cm);class hm extends vp{constructor(t){super(null==t?{}:t),this.supportsMasking=!0,this.maskValue=null!=t?null==t.maskValue?0:t.maskValue:0}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={maskValue:this.maskValue};return Object.assign(e,t),e}computeMask(t,e){const n=cp(t);return ws(Fa(n,this.maskValue),-1)}call(t,e){return Jn(()=>{this.invokeCallHook(t,e);const n=cp(t),s=ws(Fa(n,this.maskValue),-1,!0);return n.mul(s.asType(n.dtype))})}}hm.className="Masking",Wn(hm);class pm extends vp{constructor(t){if(super(t),this.embeddings=null,this.DEFAULT_EMBEDDINGS_INITIALIZER="randomUniform",null==t.batchInputShape&&null==t.inputShape){let e=null;null!=t.batchSize&&(e=t.batchSize),null==t.inputLength?this.batchInputShape=[e,null]:this.batchInputShape=[e].concat(Ac(t.inputLength))}this.inputDim=t.inputDim,Wc(this.inputDim,"inputDim"),this.outputDim=t.outputDim,Wc(this.outputDim,"outputDim"),this.embeddingsInitializer=np(t.embeddingsInitializer||this.DEFAULT_EMBEDDINGS_INITIALIZER),this.embeddingsRegularizer=mf(t.embeddingsRegularizer),this.activityRegularizer=mf(t.activityRegularizer),this.embeddingsConstraint=Zc(t.embeddingsConstraint),this.maskZero=t.maskZero,this.supportsMasking=t.maskZero,this.inputLength=t.inputLength}build(t){this.embeddings=this.addWeight("embeddings",[this.inputDim,this.outputDim],this.dtype,this.embeddingsInitializer,this.embeddingsRegularizer,!0,this.embeddingsConstraint),this.built=!0}warnOnIncompatibleInputShape(t){}computeMask(t,e){return Jn(()=>this.maskZero?(t=cp(t),Fa(t,Er(t))):null)}computeOutputShape(t){if(t=hp(t),null==this.inputLength)return[...t,this.outputDim];const e=Ac(this.inputLength);if(e.length!==t.length-1)throw new Nc(`"inputLength" is ${this.inputLength}, but received input shape has shape `+t);{let n=0;for(let s=0;s<e.length;++s){const r=e[s],a=t[s+1];if(null!=r&&null!=a&&r!==a)throw new Nc(`"inputLength" is ${this.inputLength}, but received input shape has shape `+t);null==r&&(e[n]=a),n++}}return[t[0],...e,this.outputDim]}call(t,e){return Jn(()=>{this.invokeCallHook(t,e);let n=cp(t);return"int32"!==n.dtype&&(n=xh(n,"int32")),$h(this.embeddings.read(),n.as1D()).reshape(hp(this.computeOutputShape(n.shape)))})}getConfig(){const t={inputDim:this.inputDim,outputDim:this.outputDim,embeddingsInitializer:ep(this.embeddingsInitializer),embeddingsRegularizer:df(this.embeddingsRegularizer),activityRegularizer:df(this.activityRegularizer),embeddingsConstraint:Yc(this.embeddingsConstraint),maskZero:this.maskZero,inputLength:this.inputLength},e=super.getConfig();return Object.assign(t,e),t}}pm.className="Embedding",Wn(pm);class dm extends vp{constructor(t){super(t||{}),this.supportsMasking=!0}mergeFunction(t){throw new Ic}computeElementwiseOpOutputShape(t,e){if(null==t||null==e)return null;if(t.length<e.length)return this.computeElementwiseOpOutputShape(e,t);if(0===e.length)return t;const n=t.slice(0,t.length-e.length);for(let s=0;s<e.length;++s){const r=t[t.length-e.length+s],a=e[s];if(null==r||null==a||r<0||a<0)n.push(null);else if(1===r)n.push(a);else if(1===a)n.push(r);else{if(r!==a)throw new Nc("Operands could not be broadcast together with shapes "+JSON.stringify(t)+" "+JSON.stringify(e));n.push(r)}}return n}build(t){if(Array.isArray(t)&&!Array.isArray(t[0])&&(t=[hp(t)]),(t=t).length<2)throw new Nc(`A merge layer should be called on an Array of at least 2 inputs. Got ${t.length} input(s).`);let e=[];for(const n of t)null!=n&&null!==n[0]&&e.push(n[0]);if(e=Lc(e),e.length>1)throw new Nc(`Can not merge tensors with different batch sizes. Got tensors with shapes: ${JSON.stringify(t)}.`);let n=null==t[0]?null:t[0].slice(1);for(let e=1;e<t.length;++e){const s=null==t[e]?null:t[e].slice(1);n=this.computeElementwiseOpOutputShape(n,s)}const s=t.map(t=>t.length);-1===t.indexOf(null)&&1===Lc(s).length?this.reshapeRequired=!1:this.reshapeRequired=!0}call(t,e){return Jn(()=>{if(t=t,this.reshapeRequired){const e=[],n=t.map(t=>t.rank);if(-1===n.indexOf(null)){const s=yh(n);for(let n of t){const t=n.rank;for(let e=0;e<s-t;++e)n=wh(n,1);e.push(n)}return this.mergeFunction(e)}{let n=!1;for(const s of t){const t=s.rank;if(null==t){const t=s.shape,r=t[0],a=t.slice(1).concat([r]);let i=s.reshape([r].concat(fh(t.slice(1))));i=cn(i,[1,0]),i=i.reshape(a),e.push(i),n=!0}else if(t>1){const r=bh(1,t).concat([0]);e.push(cn(s,r)),n=!0}else e.push(s)}let s=this.mergeFunction(e);const r=s.rank;if(n)if(null==r){const t=s.shape,e=t[t.length-1],n=[e].concat(t.slice(0,t.length-1));s=cn(s.reshape([-1,e]),[1,0]).reshape(n)}else if(r>1){const t=[r-1].concat(bh(0,r-1));s=cn(s,t)}return s}}return this.mergeFunction(t)})}computeOutputShape(t){let e;e=null==(t=t)[0]?null:t[0].slice(1);for(let n=1;n<t.length;++n){const s=null==t[n]?null:t[n].slice(1);e=this.computeElementwiseOpOutputShape(e,s)}let n=[];for(const e of t)null!=e&&null!==e[0]&&n.push(e[0]);return n=Lc(n),e=1===n.length?n.concat(e):[null].concat(e),e}computeMask(t,e){return Jn(()=>{if(null==e)return null;if(!Array.isArray(e))throw new Nc("`mask` should be an Array");if(!Array.isArray(t))throw new Nc("`inputs` should be an Array");if(e.length!==t.length)throw new Nc(`The Array 'inputs' and 'mask' are expected to have the same length, but have different lengths (${t.length} vs ${e.length})`);if(e.every(t=>null==t))return null;let n=(e=e.map(t=>null==t?t:Fr(t,0)))[0];for(let t=1;t<e.length-1;++t)n=ga(n,e[t]);return n})}}class fm extends dm{constructor(t){super(t)}mergeFunction(t){return Jn(()=>{let e=t[0].clone();for(let n=1;n<t.length;++n)e=ss(e,t[n]);return e})}}fm.className="Add",Wn(fm);class mm extends dm{constructor(t){super(t)}mergeFunction(t){return Jn(()=>{let e=t[0].clone();for(let n=1;n<t.length;++n)e=is(e,t[n]);return e})}}mm.className="Multiply",Wn(mm);class gm extends dm{constructor(t){super(t)}mergeFunction(t){return Jn(()=>{let e=t[0].clone();for(let n=1;n<t.length;++n)e=ss(e,t[n]);return is(1/t.length,e)})}}gm.className="Average",Wn(gm);class ym extends dm{constructor(t){super(t)}mergeFunction(t){return Jn(()=>{let e=t[0];for(let n=1;n<t.length;++n)e=Yr(e,t[n]);return e})}}ym.className="Maximum",Wn(ym);class bm extends dm{constructor(t){super(t)}mergeFunction(t){return Jn(()=>{let e=t[0];for(let n=1;n<t.length;++n)e=Ta(e,t[n]);return e})}}bm.className="Minimum",Wn(bm);class xm extends dm{constructor(t){super(t),this.DEFAULT_AXIS=-1,null==t&&(t={}),this.axis=null==t.axis?this.DEFAULT_AXIS:t.axis,this.supportsMasking=!0,this.reshapeRequired=!1}build(t){if(!Array.isArray(t)||!Array.isArray(t[0])||1===t.length)throw new Nc("A `Concatenate` layer should be called on a list of at least 2 inputs");t=t;let e=!0;for(const n of t)if(null!=n){e=!1;break}if(e)return;const n=[];for(let e=0;e<t.length;++e){const s=t[e].slice();s.splice(this.axis,1);let r=!1;for(const t of n)if(d(t,s)){r=!0;break}r||n.push(s)}if(n.length>1)throw new Nc("A `Concatenate` layer requires inputs with matching shapes except for the concat axis. Got input shapes: "+JSON.stringify(t))}mergeFunction(t){return Jn(()=>Ih(t,this.axis))}computeOutputShape(t){if(!Array.isArray(t)||!Array.isArray(t[0]))throw new Nc("A `Concatenate` layer should be called on a list of inputs.");const e=t,n=e[0].slice(),s=this.axis<0?n.length+this.axis:this.axis;for(const t of e.slice(1)){if(null==n[s]||null==t[s]){n[s]=null;break}n[s]+=t[s]}return n}computeMask(t,e){if(null==e)return null;if(!Array.isArray(e))throw new Nc("`mask` should be an array for Concatenate");if(!Array.isArray(t))throw new Nc("`inputs` should be an array for Concatenate");if(e.length!==t.length)throw new Nc(`Mismatch in the length of mask (${e.length}) and the legnth of inputs (${t.length})`);return Jn(()=>{let n=!0;if(e.forEach(t=>{null==t||(n=!1)}),n)return null;const s=[];for(let n=0;n<t.length;++n)null==e[n]?s.push(Ma(t[n]).asType("bool")):e[n].rank<t[n].rank?s.push(Fr(e[n],-1)):s.push(e[n]);const r=Hs(s,this.axis);return xs(r,-1,!1)})}getConfig(){const t={axis:this.axis},e=super.getConfig();return Object.assign(t,e),t}}function wm(t,e){for(;t<0;)t+=e;return t}xm.className="Concatenate",Wn(xm);class vm extends dm{constructor(t){super(t),this.axes=t.axes,this.normalize=null!=t.normalize&&t.normalize,this.supportsMasking=!0,this.reshapeRequired=!1}build(t){l(Array.isArray(t)&&2===t.length&&Array.isArray(t[0])&&Array.isArray(t[1]),()=>"A `Dot` layer should be called on a list of exactly 2 inputs.");const e=t[0],n=t[1];if(e.length>3||n.length>3)throw new Ic("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(e,n);if(e[s[0]]!==n[s[1]])throw new Nc(`Dimension incompatibility: ${e[s[0]]} !== ${n[s[1]]}`)}mergeFunction(t){if(2!==t.length)throw new Nc(`A \`Dot\` layer must be called on exactly 2 inputs, but received ${t.length} input(s).`);let e,n=t[0],s=t[1];return e=Array.isArray(this.axes)?this.axes.map((e,n)=>wm(e,t[n].shape.length)):[wm(this.axes,n.shape.length),wm(this.axes,s.shape.length)],this.normalize&&(n=Mp(n,e[0]),s=Mp(s,e[1])),function(t,e,n){if(t.shape.length>3||e.shape.length>3)throw new Ic("batchDot is not implemented for tensors of 4D or higher rank yet");if(l(t.shape.length>=2,()=>"batchDot requires the rank of x to be >= 2, but got "+t.shape.length),l(t.shape.length>=2,()=>"batchDot requires the rank of y to be >= 2, but got "+e.shape.length),"number"==typeof n&&(n=[n,n]),"complex64"===t.dtype||"complex64"===e.dtype)throw new Ic("batchDot is not implemented for complex64-type Tensors yet.");const s=t.shape.length,r=e.shape.length;null==n&&(n=[s-1,r-2]);const a=n;return Jn(()=>{let n,i;if(s>r){n=s-r;const t=[];for(let e=0;e<n;++e)t.push(1);e=e.reshape(e.shape.concat(t))}else if(r>s){n=r-s;const e=[];for(let t=0;t<n;++t)e.push(1);t=t.reshape(t.shape.concat(e))}else n=0;if(2===t.shape.length&&2===e.shape.length)i=a[0]===a[1]?t.mul(e).sum(a[0]):t.transpose([1,0]).mul(e).sum(a[1]);else{const n=a[0]!==t.shape.length-1,s=a[1]===e.shape.length-1;i=t.matMul(e,n,s)}if(n>0){let t;t=s>r?s+r-3:s-1;const e=[];for(let s=t;s<t+n;++s)e.push(s);i=i.squeeze(e)}return 1===i.shape.length&&(i=i.expandDims(1)),i})}(n,s,e)}interpretAxes(t,e){let n;return n=Array.isArray(this.axes)?this.axes:[wm(this.axes,t.length),wm(this.axes,e.length)],n}computeOutputShape(t){l(Array.isArray(t)&&2===t.length&&Array.isArray(t[0])&&Array.isArray(t[1]),()=>"A `Dot` layer should be called on a list of exactly 2 inputs.");const e=t[0].slice(),n=t[1].slice();if(e.length>3||n.length>3)throw new Ic("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(e,n);e.splice(s[0],1),n.splice(s[1],1),n.splice(0,1);const r=e.concat(n);return 1===r.length&&r.push(1),r}computeMask(t,e){return null}getConfig(){const t={axes:this.axes,normalize:this.normalize},e=super.getConfig();return Object.assign(t,e),t}}vm.className="Dot",Wn(vm);class km extends vp{constructor(t){super(t),this.supportsMasking=!0,this.stddev=t.stddev}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={stddev:this.stddev};return Object.assign(e,t),e}call(t,e){return Jn(()=>{this.invokeCallHook(t,e);const n=cp(t);return Fh(()=>Th(n.shape,0,this.stddev).add(n),()=>n,e.training||!1)})}}km.className="GaussianNoise",Wn(km);class Nm extends vp{constructor(t){super(t),this.supportsMasking=!0,this.rate=t.rate}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={rate:this.rate};return Object.assign(e,t),e}call(t,e){return Jn(()=>{this.invokeCallHook(t,e);const n=cp(t);if(this.rate>0&&this.rate<1){return Fh(()=>{const t=Math.sqrt(this.rate/(1-this.rate));return n.mul(Th(n.shape,1,t))},()=>n,e.training||!1)}return n})}}Nm.className="GaussianDropout",Wn(Nm);class Im extends vp{constructor(t){super(t),this.supportsMasking=!0,this.rate=t.rate,this.noiseShape=t.noiseShape}_getNoiseShape(t){return this.noiseShape||cp(t).shape}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={rate:this.rate};return Object.assign(e,t),e}call(t,e){return Jn(()=>{if(this.rate<1&&this.rate>0){const n=this._getNoiseShape(t);return Fh(()=>{const e=cp(t),s=-1.7580993408473766;let r=Hr(ui(n),this.rate);r=xh(r,"float32");const a=((1-this.rate)*(1+this.rate*s**2))**-.5,i=-a*s*this.rate;return e.mul(r).add(r.add(-1).mul(s)).mul(a).add(i)},()=>cp(t),e.training||!1)}return t})}}function Cm(t,e,n,s,r,a=.001){let i;if(2===t.rank)i=Qs(t,e,n,s,r,a);else if(3===t.rank)i=tr(t,e,n,s,r,a);else{if(4!==t.rank)throw new Ic(`batchNormalization is not implemented for array of rank ${t.rank} yet`);i=er(t,e,n,s,r,a)}return i}function Sm(t,e,n,s,r=.001){return d(s.slice().sort(),bh(0,t.rank-1))?function(t,e,n,s,r=.001){return Jn(()=>{const a=Ra(t,s),i=a.mean,o=a.variance;return[Cm(t,i,o,n,e,r),i,o]})}(t,e,n,s,r):function(t,e,n,s,r=.001){return Jn(()=>{const a=Ra(t,s),i=a.mean,o=a.variance,l=[];for(const e of bh(0,t.rank))-1!==s.indexOf(e)?l.push(1):l.push(t.shape[e]);const u=i.reshape(l),c=o.reshape(l),h=null==e?null:e.reshape(l),p=null==n?null:n.reshape(l);return[Cm(t,u,c,p,h,r),i,o]})}(t,e,n,s,r)}Im.className="AlphaDropout",Wn(Im);class Tm extends vp{constructor(t){null==t&&(t={}),super(t),this.supportsMasking=!0,this.axis=null==t.axis?-1:t.axis,this.momentum=null==t.momentum?.99:t.momentum,this.epsilon=null==t.epsilon?.001:t.epsilon,this.center=null==t.center||t.center,this.scale=null==t.scale||t.scale,this.betaInitializer=np(t.betaInitializer||"zeros"),this.gammaInitializer=np(t.gammaInitializer||"ones"),this.movingMeanInitializer=np(t.movingMeanInitializer||"zeros"),this.movingVarianceInitializer=np(t.movingVarianceInitializer||"ones"),this.betaConstraint=Zc(t.betaConstraint),this.gammaConstraint=Zc(t.gammaConstraint),this.betaRegularizer=mf(t.betaRegularizer),this.gammaRegularizer=mf(t.gammaRegularizer)}build(t){t=hp(t);const e=this.axis>=0?this.axis:this.axis+t.length,n=t[e];if(null==n)throw new Nc(`Axis ${e} of input tensor should have a defined dimension but the layer received an input with shape `+JSON.stringify(t)+".");this.inputSpec=[new gp({ndim:t.length,axes:{[e]:n}})];const s=[n];this.scale&&(this.gamma=this.addWeight("gamma",s,null,this.gammaInitializer,this.gammaRegularizer,!0,this.gammaConstraint)),this.center&&(this.beta=this.addWeight("beta",s,null,this.betaInitializer,this.betaRegularizer,!0,this.betaConstraint)),this.movingMean=this.addWeight("moving_mean",s,null,this.movingMeanInitializer,null,!1),this.movingVariance=this.addWeight("moving_variance",s,null,this.movingVarianceInitializer,null,!1),this.built=!0}call(t,e){return Jn(()=>{const n=null!=e.training&&e.training,s=cp(t),r=s.shape,a=r.length,i=bh(0,a),o=this.axis>=0?this.axis:this.axis+a;i.splice(o,1);const l=Sc(1,a);l[o]=r[o];const u=i.slice();u.sort();const c=!d(u,bh(0,a).slice(0,a-1));if(!n)return(()=>{if(c){const t=this.movingMean.read().reshape(l),e=this.movingVariance.read().reshape(l),n=this.center?this.beta.read().reshape(l):null,r=this.scale?this.gamma.read().reshape(l):null;return Cm(s,t,e,n,r,this.epsilon)}return Cm(s,this.movingMean.read(),this.movingVariance.read(),null==this.beta?null:this.beta.read(),null==this.gamma?null:this.gamma.read(),this.epsilon)})();const[h,p,f]=Sm(s,this.gamma.read(),this.beta.read(),i,this.epsilon),m=(t,e,n)=>{Jn(()=>{const s=1-n,r=t.read(),a=r.sub(e).mul(s);t.write(r.sub(a))})};return(()=>{m(this.movingMean,p,this.momentum),m(this.movingVariance,f,this.momentum)})(),h})}getConfig(){const t={axis:this.axis,momentum:this.momentum,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:ep(this.betaInitializer),gammaInitializer:ep(this.gammaInitializer),movingMeanInitializer:ep(this.movingMeanInitializer),movingVarianceInitializer:ep(this.movingVarianceInitializer),betaRegularizer:df(this.betaRegularizer),gammaRegularizer:df(this.gammaRegularizer),betaConstraint:Yc(this.betaConstraint),gammaConstraint:Yc(this.gammaConstraint)},e=super.getConfig();return Object.assign(t,e),t}}Tm.className="BatchNormalization",Wn(Tm);class Em extends vp{constructor(t){if(null==t&&(t={}),super(t),this.axis=null==t.axis?-1:t.axis,"number"==typeof this.axis){if(!Number.isInteger(this.axis))throw new Error("Expected axis to be an integer, but received "+this.axis)}else{if(!Array.isArray(this.axis))throw new Error("Expected axis to be an integer or an array of integers, but received "+JSON.stringify(this.axis));for(const t of this.axis)if(!Number.isInteger(t))throw new Error("Expected axis to be an array of integers, but received "+JSON.stringify(this.axis))}this.epsilon=null==t.epsilon?.001:t.epsilon,this.center=null==t.center||t.center,this.scale=null==t.scale||t.scale,this.betaInitializer=np(t.betaInitializer||"zeros"),this.gammaInitializer=np(t.gammaInitializer||"ones"),this.betaRegularizer=mf(t.betaRegularizer),this.gammaRegularizer=mf(t.gammaRegularizer),this.supportsMasking=!0}build(t){const e=(t=hp(t)).length;"number"==typeof this.axis&&(this.axis=[this.axis]);for(let t=0;t<this.axis.length;++t)this.axis[t]<0&&(this.axis[t]+=e);for(const t of this.axis)if(t<0||t>=e)throw new Error("Invalid axis: "+t);if(this.axis.length!==Lc(this.axis).length)throw new Error("Found duplicate axes in: "+this.axis);const n=this.axis.map(e=>t[e]);this.scale?this.gamma=this.addWeight("gamma",n,"float32",this.gammaInitializer,this.gammaRegularizer,!0):this.gamma=null,this.center?this.beta=this.addWeight("beta",n,"float32",this.betaInitializer,this.betaRegularizer,!0):this.beta=null,this.built=!0}call(t,e){const n=cp(t),s=n.shape,r=s.length;return Jn(()=>{let{mean:t,variance:e}=Ra(n,this.axis,!0);const a=Sc(1,r);for(const t of this.axis)a[t]=s[t];const i=t=>null!=t&&t.shape.length!==r&&this.axis!==[r-1]?t.reshape(a):t;let o=i(this.gamma.read()),l=i(this.beta.read());const u=[],c=[];for(let t=0;t<r;++t)-1!==this.axis.indexOf(t)?(u.push(s[t]),c.push(1)):(u.push(1),c.push(s[t]));return t=t.tile(u),e=e.tile(u),o=o.tile(c),l=l.tile(c),Cm(n,t,e,l,o,this.epsilon)})}getConfig(){const t={axis:this.axis,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:ep(this.betaInitializer),gammaInitializer:ep(this.gammaInitializer),betaRegularizer:df(this.betaRegularizer),gammaRegularizer:df(this.gammaRegularizer)},e=super.getConfig();return Object.assign(t,e),t}}Em.className="LayerNormalization",Wn(Em);class $m extends vp{constructor(t){if(null==t&&(t={}),super(t),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,null==t.padding)this.padding=[[1,1],[1,1]];else if("number"==typeof t.padding)this.padding=[[t.padding,t.padding],[t.padding,t.padding]];else{if(t.padding=t.padding,2!==t.padding.length)throw new Nc(`ZeroPadding2D expects padding to be a length-2 array, but received a length-${t.padding.length} array.`);let e,n;if("number"==typeof t.padding[0])e=[t.padding[0],t.padding[0]],n=[t.padding[1],t.padding[1]];else{if(t.padding=t.padding,2!==t.padding[0].length)throw new Nc(`ZeroPadding2D expects height padding to be a length-2 array, but received a length-${t.padding[0].length} array.`);if(e=t.padding[0],2!==t.padding[1].length)throw new Nc(`ZeroPadding2D expects width padding to be a length-2 array, but received a length-${t.padding[1].length} array.`);n=t.padding[1]}this.padding=[e,n]}this.inputSpec=[new gp({ndim:4})]}computeOutputShape(t){let e,n;return t=hp(t),"channelsFirst"===this.dataFormat?(e=null!=t[2]&&t[2]>=0?t[2]+this.padding[0][0]+this.padding[0][1]:null,n=null!=t[3]&&t[3]>=0?t[3]+this.padding[1][0]+this.padding[1][1]:null,[t[0],t[1],e,n]):(e=null!=t[1]&&t[1]>=0?t[1]+this.padding[0][0]+this.padding[0][1]:null,n=null!=t[2]&&t[2]>=0?t[2]+this.padding[1][0]+this.padding[1][1]:null,[t[0],e,n,t[3]])}call(t,e){return Jn(()=>{return e=cp(t),n=this.padding,s=this.dataFormat,Jn(()=>{if(4!==e.rank)throw new Nc("temporalPadding expects input tensor to be 4-D, but received a "+e.rank+"-D tensor.");if(null==n&&(n=[[1,1],[1,1]]),2!==n.length||2!==n[0].length||2!==n[1].length)throw new Nc("spatial2dPadding expects `padding` to be an Array of two Arrays, each of which is an Array of two integers.");if(null==s&&(s="channelsLast"),"channelsLast"!==s&&"channelsFirst"!==s)throw new Nc(`Unknown data format: ${s}. Supported data formats are 'channelsLast' and 'channelsFirst.`);let t;return t="channelsFirst"===s?[[0,0],[0,0],n[0],n[1]]:[[0,0],n[0],n[1],[0,0]],za(e,t)});var e,n,s})}getConfig(){const t={padding:this.padding,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}function Am(t,e,n,s,r,a){return Jn(()=>{let i;ah(r),oh(a),ih(s),null==n&&(n=[1,1]),null==s&&(s="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),t=Cf(t,r);const o="same"===s?"same":"valid";return i="max"===a?wa(t,e,n,o):Ws(t,e,n,o),"channelsFirst"===r&&(i=cn(i,[0,3,1,2])),i})}function Rm(t,e,n,s,r,a){return Jn(()=>{let i;ah(r),oh(a),ih(s),null==n&&(n=[1,1,1]),null==s&&(s="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),t=Sf(t,r);const o="same"===s?"same":"valid";return i="max"===a?va(t,e,n,o):Vs(t,e,n,o),"channelsFirst"===r&&(i=cn(i,[0,4,1,2,3])),i})}$m.className="ZeroPadding2D",Wn($m);class Dm extends vp{constructor(t){if(null==t.poolSize&&(t.poolSize=2),super(t),"number"==typeof t.poolSize)this.poolSize=[t.poolSize];else{if(!Array.isArray(t.poolSize)||1!==t.poolSize.length||"number"!=typeof t.poolSize[0])throw new Nc("poolSize for 1D convolutional layer must be a number or an Array of a single number, but received "+JSON.stringify(t.poolSize));this.poolSize=t.poolSize}if(Wc(this.poolSize,"poolSize"),null==t.strides)this.strides=this.poolSize;else if("number"==typeof t.strides)this.strides=[t.strides];else{if(!Array.isArray(t.strides)||1!==t.strides.length||"number"!=typeof t.strides[0])throw new Nc("strides for 1D convolutional layer must be a number or an Array of a single number, but received "+JSON.stringify(t.strides));this.strides=t.strides}Wc(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,ih(this.padding),this.inputSpec=[new gp({ndim:3})]}computeOutputShape(t){const e=Nf((t=hp(t))[1],this.poolSize[0],this.padding,this.strides[0]);return[t[0],e,t[2]]}call(t,e){return Jn(()=>{this.invokeCallHook(t,e),t=wh(cp(t),2);const n=this.poolingFunction(cp(t),[this.poolSize[0],1],[this.strides[0],1],this.padding,"channelsLast");return Wi(n,[2])})}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides},e=super.getConfig();return Object.assign(t,e),t}}class _m extends Dm{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return ah(r),ih(s),Am(t,e,n,s,r,"max")}}_m.className="MaxPooling1D",Wn(_m);class Fm extends Dm{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return ah(r),ih(s),Am(t,e,n,s,r,"avg")}}Fm.className="AveragePooling1D",Wn(Fm);class Om extends vp{constructor(t){if(null==t.poolSize&&(t.poolSize=[2,2]),super(t),this.poolSize=Array.isArray(t.poolSize)?t.poolSize:[t.poolSize,t.poolSize],null==t.strides)this.strides=this.poolSize;else if(Array.isArray(t.strides)){if(2!==t.strides.length)throw new Nc("If the strides property of a 2D pooling layer is an Array, it is expected to have a length of 2, but received length "+t.strides.length+".");this.strides=t.strides}else this.strides=[t.strides,t.strides];Wc(this.poolSize,"poolSize"),Wc(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,ah(this.dataFormat),ih(this.padding),this.inputSpec=[new gp({ndim:4})]}computeOutputShape(t){t=hp(t);let e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2];return e=Nf(e,this.poolSize[0],this.padding,this.strides[0]),n=Nf(n,this.poolSize[1],this.padding,this.strides[1]),"channelsFirst"===this.dataFormat?[t[0],t[1],e,n]:[t[0],e,n,t[3]]}call(t,e){return Jn(()=>(this.invokeCallHook(t,e),this.poolingFunction(cp(t),this.poolSize,this.strides,this.padding,this.dataFormat)))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class Mm extends Om{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return ah(r),ih(s),Am(t,e,n,s,r,"max")}}Mm.className="MaxPooling2D",Wn(Mm);class Lm extends Om{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return ah(r),ih(s),Am(t,e,n,s,r,"avg")}}Lm.className="AveragePooling2D",Wn(Lm);class zm extends vp{constructor(t){if(null==t.poolSize&&(t.poolSize=[2,2,2]),super(t),this.poolSize=Array.isArray(t.poolSize)?t.poolSize:[t.poolSize,t.poolSize,t.poolSize],null==t.strides)this.strides=this.poolSize;else if(Array.isArray(t.strides)){if(3!==t.strides.length)throw new Nc("If the strides property of a 3D pooling layer is an Array, it is expected to have a length of 3, but received length "+t.strides.length+".");this.strides=t.strides}else this.strides=[t.strides,t.strides,t.strides];Wc(this.poolSize,"poolSize"),Wc(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,ah(this.dataFormat),ih(this.padding),this.inputSpec=[new gp({ndim:5})]}computeOutputShape(t){t=hp(t);let e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2],s="channelsFirst"===this.dataFormat?t[4]:t[3];return e=Nf(e,this.poolSize[0],this.padding,this.strides[0]),n=Nf(n,this.poolSize[1],this.padding,this.strides[1]),s=Nf(s,this.poolSize[2],this.padding,this.strides[2]),"channelsFirst"===this.dataFormat?[t[0],t[1],e,n,s]:[t[0],e,n,s,t[4]]}call(t,e){return Jn(()=>(this.invokeCallHook(t,e),this.poolingFunction(cp(t),this.poolSize,this.strides,this.padding,this.dataFormat)))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class Bm extends zm{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return ah(r),ih(s),Rm(t,e,n,s,r,"max")}}Bm.className="MaxPooling3D",Wn(Bm);class Pm extends zm{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return ah(r),ih(s),Rm(t,e,n,s,r,"avg")}}Pm.className="AveragePooling3D",Wn(Pm);class Wm extends vp{constructor(t){super(t),this.inputSpec=[new gp({ndim:3})]}computeOutputShape(t){return[t[0],t[2]]}call(t,e){throw new Ic}}class Vm extends Wm{constructor(t){super(t||{})}call(t,e){return Jn(()=>{const e=cp(t);return Ca(e,1)})}}Vm.className="GlobalAveragePooling1D",Wn(Vm);class Um extends Wm{constructor(t){super(t||{})}call(t,e){return Jn(()=>{const e=cp(t);return ha(e,1)})}}Um.className="GlobalMaxPooling1D",Wn(Um);class Gm extends vp{constructor(t){super(t),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,ah(this.dataFormat),this.inputSpec=[new gp({ndim:4})]}computeOutputShape(t){return t=t,"channelsLast"===this.dataFormat?[t[0],t[3]]:[t[0],t[1]]}call(t,e){throw new Ic}getConfig(){const t={dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class Hm extends Gm{call(t,e){return Jn(()=>{const e=cp(t);return"channelsLast"===this.dataFormat?Ca(e,[1,2]):Ca(e,[2,3])})}}Hm.className="GlobalAveragePooling2D",Wn(Hm);class jm extends Gm{call(t,e){return Jn(()=>{const e=cp(t);return"channelsLast"===this.dataFormat?ha(e,[1,2]):ha(e,[2,3])})}}jm.className="GlobalMaxPooling2D",Wn(jm);class qm extends vp{constructor(t){super(t),this.layer=t.layer}build(t){this.built=!0}get trainable(){return null!=this.layer&&this.layer.trainable}set trainable(t){null!=this.layer&&(this.layer.trainable=t)}get trainableWeights(){return this.layer.trainableWeights}get nonTrainableWeights(){return this.layer.nonTrainableWeights}get updates(){return this.layer._updates}get losses(){return this.layer.losses}getWeights(){return this.layer.getWeights()}setWeights(t){this.layer.setWeights(t)}getConfig(){const t={layer:{className:this.layer.getClassName(),config:this.layer.getConfig()}},e=super.getConfig();return Object.assign(t,e),t}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.layer&&this.layer.setFastWeightInitDuringBuild(t)}static fromConfig(t,e,n={}){const s=Op(e.layer,n);delete e.layer;const r={layer:s};return Object.assign(r,e),new t(r)}}class Km extends qm{constructor(t){super(t),this.supportsMasking=!0}build(t){if((t=hp(t)).length<3)throw new Nc("TimeDistributed layer expects an input shape >= 3D, but received input shape "+JSON.stringify(t));this.inputSpec=[{shape:t}];const e=[t[0]].concat(t.slice(2));this.layer.built||(this.layer.build(e),this.layer.built=!0),super.build(t)}computeOutputShape(t){const e=[(t=hp(t))[0]].concat(t.slice(2)),n=this.layer.computeOutputShape(e),s=t[1];return[n[0],s].concat(n.slice(1))}call(t,e){return Jn(()=>Vf((t,n)=>[cp(this.layer.call(t,e)),[]],t=cp(t),[],!1,null,null,!1,!0)[1])}}Km.className="TimeDistributed",Wn(Km);class Xm extends qm{constructor(t){super(t);const e=t.layer.getConfig(),n={};n.className=t.layer.getClassName(),n.config=e,this.forwardLayer=Op(n),e.goBackwards=!0!==e.goBackwards;const s={};var r;if(s.className=t.layer.getClassName(),s.config=e,this.backwardLayer=Op(s),this.forwardLayer.name="forward_"+this.forwardLayer.name,this.backwardLayer.name="backward_"+this.backwardLayer.name,this.mergeMode=void 0===t.mergeMode?"concat":t.mergeMode,r=this.mergeMode,Bc(sh,"BidirectionalMergeMode",r),t.weights)throw new Ic("weights support is not implemented for Bidirectional layer yet.");this._stateful=t.layer.stateful,this.returnSequences=t.layer.returnSequences,this.returnState=t.layer.returnState,this.supportsMasking=!0,this._trainable=!0,this.inputSpec=t.layer.inputSpec,this.numConstants=null}get trainable(){return this._trainable}set trainable(t){this._trainable=t,null!=this.forwardLayer&&(this.forwardLayer.trainable=t),null!=this.backwardLayer&&(this.backwardLayer.trainable=t)}getWeights(){return this.forwardLayer.getWeights().concat(this.backwardLayer.getWeights())}setWeights(t){const e=t.length,n=Math.floor(e/2);this.forwardLayer.setWeights(t.slice(0,n)),this.backwardLayer.setWeights(t.slice(n))}computeOutputShape(t){let e,n,s,r=this.forwardLayer.computeOutputShape(t);return Array.isArray(r)&&Array.isArray(r[0])||(r=[r]),r=r,this.returnState?(s=r.slice(1),e=r[0]):e=r[0],e=e,"concat"===this.mergeMode?(e[e.length-1]*=2,n=[e]):n=null==this.mergeMode?[e,e.slice()]:[e],this.returnState?null==this.mergeMode?n.concat(s).concat(s.slice()):[e].concat(s).concat(s.slice()):$c(n)}apply(t,e){let n=null==e?null:e.initialState,s=null==e?null:e.constants;null==e&&(e={});const r=Wf(t,n,s,this.numConstants);if(t=r.inputs,n=r.initialState,s=r.constants,Array.isArray(t)&&(n=t.slice(1),t=t[0]),(null==n||0===n.length)&&null==s)return super.apply(t,e);const a=[],i=[];if(null!=n){const t=n.length;if(t%2>0)throw new Nc("When passing `initialState` to a Bidrectional RNN, the state should be an Array containing the states of the underlying RNNs.");e.initialState=n,a.push(...n);const s=n.map(t=>new gp({shape:t.shape}));this.forwardLayer.stateSpec=s.slice(0,t/2),this.backwardLayer.stateSpec=s.slice(t/2),i.push(...s)}if(null!=s)throw new Ic("Support for constants in Bidirectional layers is not implemented yet.");const o=a[0]instanceof yp;for(const t of a)if(t instanceof yp!==o)throw new Nc("The initial state of a Bidirectional layer cannot be specified as a mix of symbolic and non-symbolic tensors");if(o){const n=[t].concat(a),s=this.inputSpec.concat(i),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,e);return this.inputSpec=r,o}return super.apply(t,e)}call(t,e){return Jn(()=>{const n=e.initialState;let s,r,a,i;if(null==n)s=this.forwardLayer.call(t,e),r=this.backwardLayer.call(t,e);else{const a=n.slice(0,n.length/2),i=n.slice(n.length/2);s=this.forwardLayer.call(t,Object.assign(e,{initialState:a})),r=this.backwardLayer.call(t,Object.assign(e,{initialState:i}))}return this.returnState&&(Array.isArray(s)&&(a=s.slice(1).concat(r.slice(1))),s=s[0],r=r[0]),this.returnSequences&&(r=mi(r,1)),"concat"===this.mergeMode?i=Ih([s,r]):"sum"===this.mergeMode?i=ss(s,r):"ave"===this.mergeMode?i=is(.5,ss(s,r)):"mul"===this.mergeMode?i=is(s,r):null==this.mergeMode&&(i=[s,r]),this.returnState?null==this.mergeMode?i.concat(a):[i].concat(a):i})}resetStates(t){this.forwardLayer.resetStates(),this.backwardLayer.resetStates()}build(t){uh(this.forwardLayer.name,()=>{this.forwardLayer.build(t)}),uh(this.backwardLayer.name,()=>{this.backwardLayer.build(t)}),this.built=!0}computeMask(t,e){let n;if(Array.isArray(e)&&(e=e[0]),n=this.returnSequences?null==this.mergeMode?[e,e]:e:null==this.mergeMode?[null,null]:null,this.returnState){const t=this.forwardLayer.states.map(t=>null);return Array.isArray(n)?n.concat(t).concat(t):[n].concat(t).concat(t)}return n}get trainableWeights(){return this.forwardLayer.trainableWeights.concat(this.backwardLayer.trainableWeights)}get nonTrainableWeights(){return this.forwardLayer.nonTrainableWeights.concat(this.backwardLayer.nonTrainableWeights)}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.forwardLayer&&this.forwardLayer.setFastWeightInitDuringBuild(t),null!=this.backwardLayer&&this.backwardLayer.setFastWeightInitDuringBuild(t)}getConfig(){const t={mergeMode:this.mergeMode},e=super.getConfig();return Object.assign(t,e),t}static fromConfig(t,e){const n=Op(e.layer);if(delete e.layer,null!=e.numConstants)throw new Ic("Deserialization of a Bidirectional layer with numConstants present is not supported yet.");const s=e;return s.layer=n,new t(s)}}function Ym(t){return new Fm(t)}function Jm(t){return new Lm(t)}function Zm(t){return new Pm(t)}function Qm(t){return new Um(t)}function tg(t){return new jm(t)}function eg(t){return new _m(t)}function ng(t){return new Mm(t)}Xm.className="Bidirectional",Wn(Xm);const sg=Qm,rg=tg,ag=eg,ig=ng;var og=Object.freeze({__proto__:null,inputLayer:function(t){return new kp(t)},elu:function(t){return new xf(t)},reLU:function(t){return new gf(t)},leakyReLU:function(t){return new yf(t)},prelu:function(t){return new bf(t)},softmax:function(t){return new vf(t)},thresholdedReLU:function(t){return new wf(t)},conv1d:function(t){return new Lf(t)},conv2d:function(t){return new Df(t)},conv2dTranspose:function(t){return new Ff(t)},conv3d:function(t){return new _f(t)},separableConv2d:function(t){return new Mf(t)},cropping2D:function(t){return new zf(t)},upSampling2d:function(t){return new Bf(t)},depthwiseConv2d:function(t){return new Pf(t)},activation:function(t){return new om(t)},dense:function(t){return new am(t)},dropout:function(t){return new sm(t)},spatialDropout1d:function(t){return new rm(t)},flatten:function(t){return new im(t)},repeatVector:function(t){return new lm(t)},reshape:function(t){return new um(t)},permute:function(t){return new cm(t)},embedding:function(t){return new pm(t)},add:function(t){return new fm(t)},average:function(t){return new gm(t)},concatenate:function(t){return new xm(t)},maximum:function(t){return new ym(t)},minimum:function(t){return new bm(t)},multiply:function(t){return new mm(t)},dot:function(t){return new vm(t)},batchNormalization:function(t){return new Tm(t)},layerNormalization:function(t){return new Em(t)},zeroPadding2d:function(t){return new $m(t)},averagePooling1d:Ym,avgPool1d:function(t){return Ym(t)},avgPooling1d:function(t){return Ym(t)},averagePooling2d:Jm,avgPool2d:function(t){return Jm(t)},avgPooling2d:function(t){return Jm(t)},averagePooling3d:Zm,avgPool3d:function(t){return Zm(t)},avgPooling3d:function(t){return Zm(t)},globalAveragePooling1d:function(t){return new Vm(t)},globalAveragePooling2d:function(t){return new Hm(t)},globalMaxPooling1d:Qm,globalMaxPooling2d:tg,maxPooling1d:eg,maxPooling2d:ng,maxPooling3d:function(t){return new Bm(t)},gru:function(t){return new Kf(t)},gruCell:function(t){return new qf(t)},lstm:function(t){return new Yf(t)},lstmCell:function(t){return new Xf(t)},simpleRNN:function(t){return new jf(t)},simpleRNNCell:function(t){return new Hf(t)},convLstm2d:function(t){return new nm(t)},convLstm2dCell:function(t){return new em(t)},rnn:function(t){return new Uf(t)},stackedRNNCells:function(t){return new Jf(t)},bidirectional:function(t){return new Xm(t)},timeDistributed:function(t){return new Km(t)},globalMaxPool1d:sg,globalMaxPool2d:rg,maxPool1d:ag,maxPool2d:ig,Layer:vp,RNN:Uf,RNNCell:Gf,input:Gd,gaussianNoise:function(t){return new km(t)},gaussianDropout:function(t){return new Nm(t)},alphaDropout:function(t){return new Im(t)},masking:function(t){return new hm(t)}});var lg=Object.freeze({__proto__:null,binaryAccuracy:function(t,e){return Kp(t,e)},binaryCrossentropy:function(t,e){return Qp(t,e)},sparseCategoricalAccuracy:function(t,e){return td(t,e)},categoricalAccuracy:function(t,e){return Xp(t,e)},categoricalCrossentropy:function(t,e){return ed(t,e)},precision:function(t,e){return Jp(t,e)},recall:function(t,e){return Zp(t,e)},cosineProximity:function(t,e){return Hp(t,e)},meanAbsoluteError:function(t,e){return zp(t,e)},meanAbsolutePercentageError:function(t,e){return Bp(t,e)},MAPE:function(t,e){return Bp(t,e)},mape:function(t,e){return Bp(t,e)},meanSquaredError:function(t,e){return Lp(t,e)},MSE:function(t,e){return Lp(t,e)},mse:function(t,e){return Lp(t,e)}}),ug=Object.freeze({__proto__:null,modelFromJSON:async function(t,e){"modelTopology"in t||(t={modelTopology:t});let n=(t=t).modelTopology;null!=n.model_config&&(n=n.model_config);const s=Op(pd(n),e);if(null!=t.weightsManifest){const e=await Ye(t.weightsManifest,t.pathPrefix,s.weights.map(t=>t.originalName)),n={};for(const t of s.weights)n[t.originalName]=e[t.originalName];s.loadWeights(n),Zn(e)}return s}});var cg=Object.freeze({__proto__:null,l1l2:function(t){return new hf(t)},l1:function(t){return uf(e=t),new hf({l1:null!=e?e.l1:null,l2:0});var e},l2:function(t){return uf(e=t),new hf({l2:null!=e?e.l2:null,l1:0});var e}});class hg extends Tp{constructor(){super(...arguments),this.model=null}setModel(t){if(!(t instanceof Pd))throw new Error("model must be a LayersModel, not some other Container");this.model=t}}function pg(t,e){return t<e}function dg(t,e){return t>e}class fg extends hg{constructor(t){if(super(),null==t&&(t={}),t.restoreBestWeights)throw new Ic("restoreBestWeights = True is not implemented in EarlyStopping yet.");this.monitor=t.monitor||"val_loss",this.minDelta=Math.abs(t.minDelta||0),this.patience=t.patience||0,this.verbose=t.verbose||0,this.mode=t.mode||"auto",this.baseline=t.baseline,-1===["auto","min","max"].indexOf(this.mode)&&(console.warn(`EarlyStopping mode '${this.mode}' is invalid. Falling back to mode 'auto'.`),this.mode="auto"),"min"===this.mode?this.monitorFunc=pg:"max"===this.mode||-1!==this.monitor.indexOf("acc")?this.monitorFunc=dg:this.monitorFunc=pg,this.monitorFunc===pg&&(this.minDelta*=-1)}async onTrainBegin(t){this.wait=0,this.stoppedEpoch=0,null!=this.baseline?this.best=this.baseline:this.best=this.monitorFunc===pg?1/0:-1/0}async onEpochEnd(t,e){await Ip(e);const n=this.getMonitorValue(e);null!=n&&(this.monitorFunc(n-this.minDelta,this.best)?(this.best=n,this.wait=0):(this.wait++,this.wait>=this.patience&&(this.stoppedEpoch=t,this.model.stopTraining=!0)))}async onTrainEnd(t){this.stoppedEpoch>0&&this.verbose&&console.log(`Epoch ${this.stoppedEpoch}: early stopping.`)}getMonitorValue(t){null==t&&(t={});const e=t[this.monitor];return null==e&&console.warn(`Metric for EarlyStopping ${this.monitor} is not available. Available metrics are: `+Object.keys(t)),e}}const mg={earlyStopping:function(t){return new fg(t)}};var gg,yg;!function(t){t[t.DT_INVALID=0]="DT_INVALID",t[t.DT_FLOAT=1]="DT_FLOAT",t[t.DT_DOUBLE=2]="DT_DOUBLE",t[t.DT_INT32=3]="DT_INT32",t[t.DT_UINT8=4]="DT_UINT8",t[t.DT_INT16=5]="DT_INT16",t[t.DT_INT8=6]="DT_INT8",t[t.DT_STRING=7]="DT_STRING",t[t.DT_COMPLEX64=8]="DT_COMPLEX64",t[t.DT_INT64=9]="DT_INT64",t[t.DT_BOOL=10]="DT_BOOL",t[t.DT_QINT8=11]="DT_QINT8",t[t.DT_QUINT8=12]="DT_QUINT8",t[t.DT_QINT32=13]="DT_QINT32",t[t.DT_BFLOAT16=14]="DT_BFLOAT16",t[t.DT_FLOAT_REF=101]="DT_FLOAT_REF",t[t.DT_DOUBLE_REF=102]="DT_DOUBLE_REF",t[t.DT_INT32_REF=103]="DT_INT32_REF",t[t.DT_UINT8_REF=104]="DT_UINT8_REF",t[t.DT_INT16_REF=105]="DT_INT16_REF",t[t.DT_INT8_REF=106]="DT_INT8_REF",t[t.DT_STRING_REF=107]="DT_STRING_REF",t[t.DT_COMPLEX64_REF=108]="DT_COMPLEX64_REF",t[t.DT_INT64_REF=109]="DT_INT64_REF",t[t.DT_BOOL_REF=110]="DT_BOOL_REF",t[t.DT_QINT8_REF=111]="DT_QINT8_REF",t[t.DT_QUINT8_REF=112]="DT_QUINT8_REF",t[t.DT_QINT32_REF=113]="DT_QINT32_REF",t[t.DT_BFLOAT16_REF=114]="DT_BFLOAT16_REF"}(gg||(gg={})),function(t){let e;!function(t){t[t.LEGACY=0]="LEGACY",t[t.V1=1]="V1",t[t.V2=2]="V2"}(e=t.CheckpointFormatVersion||(t.CheckpointFormatVersion={}))}(yg||(yg={}));const bg={};function xg(t){return bg[t]}function wg(t,e,n,s,r){const a=e.inputParams[t];if(a&&void 0!==a.inputIndexStart){const t=a.inputIndexStart,i=0===a.inputIndexEnd?void 0:void 0===a.inputIndexEnd?t+1:a.inputIndexEnd;if("tensor"===a.type)return vg(e.inputNames[a.inputIndexStart],n,s,r);if("tensors"===a.type){return e.inputNames.slice(t,i).map(t=>vg(t,n,s,r))}const o=vg(e.inputNames.slice(t)[0],n,s,r),l=o.dataSync();return"number"===a.type?l[0]:M(o.shape,l)}const i=e.attrParams[t];return i&&i.value}function vg(t,e,n,s){const[r,a]=Ig(t);if(null!=s){const t=s.getHashTableHandleByName(r);if(null!=t)return t}const i=n.currentContextIds.find(t=>!!e[Ng(r,t)]);return void 0!==i?e[Ng(r,i)][a]:void 0}function kg(t,e){const[n,s]=Ig(t);return[Ng(n,e&&e.currentContextId),s]}function Ng(t,e){return e?`${t}-${e}`:t}function Ig(t){const e=t.split(":");return 1===e.length?[t,0]:[e[0],Number(e[e.length-1])]}function Cg(t,e,n){let s=wg("pad",t,e,n);if("explicit"===s){s=wg("explicitPaddings",t,e,n);const r=[[0,0],[0,0],[0,0],[0,0]];for(let t=0;t<4;t++)r[t][0]=s[2*t],r[t][1]=s[2*t+1];return r}return s}function Sg(t){return t.kept?t:Ue(t)}var Tg=Object.freeze({__proto__:null,json:[{tfOpName:"Add",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddV2",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddN",category:"arithmetic",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"BiasAdd",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sub",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"RealDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Div",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"DivNoNan",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mul",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Maximum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}]},{tfOpName:"Minimum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}]},{tfOpName:"Pow",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SquaredDifference",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorMod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Eg=Object.freeze({__proto__:null,json:[{tfOpName:"Abs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan2",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ceil",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ClipByValue",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"clip_value_min",name:"clipValueMin",type:"number"},{tfName:"clip_value_max",name:"clipValueMax",type:"number"}]},{tfOpName:"Complex",category:"basic_math",inputs:[{start:0,name:"real",type:"tensor"},{start:1,name:"imag",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ComplexAbs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Elu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Exp",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Floor",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Imag",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Neg",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Real",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Prelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"alpha",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu6",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"clipValueMin",name:"clipValueMin",type:"number",defaultValue:0},{tfName:"clipValueMax",name:"clipValueMax",type:"number",defaultValue:6}]},{tfOpName:"Selu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sigmoid",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Rsqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Square",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sign",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Round",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Expm1",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log1p",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Reciprocal",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Softplus",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Erf",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Prod",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axes",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LeakyRelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"alpha",name:"alpha",type:"number",defaultValue:.2},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var $g=Object.freeze({__proto__:null,json:[{tfOpName:"LoopCond",category:"control",inputs:[{start:0,name:"pred",type:"tensor"}]},{tfOpName:"Switch",category:"control",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"pred",type:"tensor"}]},{tfOpName:"Merge",category:"control",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"Enter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"frame_name",name:"frameName",type:"string"},{tfName:"is_constant",name:"isConstant",type:"bool"}]},{tfOpName:"Exit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NextIteration",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayV3",category:"control",inputs:[{start:0,name:"size",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"dynamic_size",name:"dynamicSize",type:"bool"},{tfName:"clear_after_read",name:"clearAfterRead",type:"bool"},{tfName:"identical_element_shapes",name:"identicalElementShapes",type:"bool"},{tfName:"tensor_array_name",name:"name",type:"string"}]},{tfOpName:"TensorArrayWriteV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayReadV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayGatherV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"}]},{tfOpName:"TensorArrayScatterV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArrayConcatV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape_except0",name:"elementShapeExcept0",type:"shape",notSupported:!0}]},{tfOpName:"TensorArraySplitV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"tensor",type:"tensor"},{start:2,name:"lengths",type:"number[]"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArraySizeV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}]},{tfOpName:"TensorArrayCloseV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"}]},{tfOpName:"StatelessIf",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"If",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"StatelessWhile",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"While",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"TensorListScatter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListScatterV2",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"},{start:3,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGather",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListSetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListReserve",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListFromTensor",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListStack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"},{tfName:"num_elements",name:"numElements",type:"dtype"}]},{tfOpName:"TensorListSplit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"},{start:2,name:"lengths",type:"number[]"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListConcat",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}],attrs:[{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPopBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPushBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]}]});var Ag=Object.freeze({__proto__:null,json:[{tfOpName:"AvgPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPoolWithArgmax",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"include_batch_in_index",name:"includeBatchInIndex",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AvgPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Conv1D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"stride",name:"stride",type:"number"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NWC"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"dilation",name:"dilation",type:"number",defaultValue:1}]},{tfOpName:"Conv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"useCudnnOnGpu",name:"useCudnnOnGpu",type:"bool"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"_FusedConv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"use_cudnn_on_gpu",name:"useCudnnOnGpu",type:"bool",defaultValue:!0},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4}]},{tfOpName:"Conv2DBackpropInput",category:"convolution",inputs:[{start:2,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:0,name:"outputShape",type:"number[]"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]}]},{tfOpName:"DepthwiseConv2d",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"DepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"FusedDepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]}]},{tfOpName:"Conv3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"Dilation2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"rates",name:"dilations",type:"number[]"},{tfName:"padding",name:"pad",type:"string"}]}]});var Rg=Object.freeze({__proto__:null,json:[{tfOpName:"Fill",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"},{start:1,name:"value",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"LinSpace",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"num",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"OneHot",category:"creation",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"depth",type:"number"},{start:2,name:"onValue",type:"number",defaultValue:1},{start:3,name:"offValue",type:"number",defaultValue:0}],attrs:[{tfName:"axis",name:"axis",type:"number",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ones",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"OnesLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"RandomUniform",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"minval",name:"minval",type:"number",defaultValue:0},{tfName:"maxval",name:"maxval",type:"number",defaultValue:1},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Range",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"step",type:"number",defaultValue:0}],attrs:[{tfName:"Tidx",name:"dtype",type:"dtype"}]},{tfOpName:"TruncatedNormal",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"means",name:"mean",type:"number",defaultValue:0},{tfName:"stddev",name:"stdDev",type:"number",defaultValue:1},{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Zeros",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"ZerosLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"Multinomial",category:"creation",inputs:[{start:0,name:"logits",type:"tensor"},{start:1,name:"numSamples",type:"number"}],attrs:[{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number"},{tfName:"T",name:"dtype",type:"dtype"},{tfName:"output_dtype",name:"output_dtype",type:"dtype"}]}]});var Dg=Object.freeze({__proto__:null,json:[{tfOpName:"NonMaxSuppressionV2",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV3",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV4",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"T_threshold",name:"threshold",type:"dtype",notSupported:!0},{tfName:"pad_to_max_output_size",name:"padToMaxOutputSize",type:"bool"}]},{tfOpName:"NonMaxSuppressionV5",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"},{start:5,name:"softNmsSigma",type:"number"}]},{tfOpName:"Where",category:"dynamic",inputs:[{start:0,name:"condition",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ListDiff",category:"dynamic",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var _g=Object.freeze({__proto__:null,json:[{tfOpName:"TopKV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"k",type:"number"}],attrs:[{tfName:"sorted",name:"sorted",type:"bool"}]},{tfOpName:"Unique",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"UniqueV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]}]});var Fg=Object.freeze({__proto__:null,json:[{tfOpName:"PlaceholderWithDefault",category:"graph",inputs:[{start:0,name:"default",type:"tensor"}],attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Placeholder",category:"graph",attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Const",category:"graph"},{tfOpName:"Identity",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IdentityN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Snapshot",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Rank",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Size",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Shape",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"ShapeN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Print",category:"graph",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"data",type:"tensors"}],attrs:[{tfName:"message",name:"message",type:"string"},{tfName:"first_n",name:"firstN",type:"number",notSupported:!0},{tfName:"summarize",name:"summarize",type:"number",defaultValue:3}]},{tfOpName:"NoOp",category:"graph",inputs:[]},{tfOpName:"StopGradient",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"FakeQuantWithMinMaxVars",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"min",name:"min",type:"number"},{tfName:"max",name:"max",type:"number"}]}]});var Og=Object.freeze({__proto__:null,json:[{tfOpName:"HashTable",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"HashTableV2",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"LookupTableImport",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableImportV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFind",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFindV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]}]});var Mg=Object.freeze({__proto__:null,json:[{tfOpName:"ResizeBilinear",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ResizeNearestNeighbor",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"CropAndResize",category:"image",inputs:[{start:0,name:"image",type:"tensor"},{start:1,name:"boxes",type:"tensor"},{start:2,name:"boxInd",type:"tensor"},{start:3,name:"cropSize",type:"number[]"}],attrs:[{tfName:"method",name:"method",type:"string"},{tfName:"extrapolation_value",name:"extrapolationValue",type:"number"}]}]});var Lg=Object.freeze({__proto__:null,json:[{tfOpName:"Equal",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NotEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Greater",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"GreaterEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Less",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LessEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalAnd",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalNot",category:"logical",inputs:[{start:0,name:"a",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalOr",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Select",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SelectV2",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var zg=Object.freeze({__proto__:null,json:[{tfOpName:"_FusedMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMulV2",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Transpose",category:"matrices",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"perm",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Bg=Object.freeze({__proto__:null,json:[{tfOpName:"FusedBatchNorm",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV2",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV3",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"LRN",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"depth_radius",name:"radius",type:"number",defaultValue:5},{tfName:"bias",name:"bias",type:"number",defaultValue:1},{tfName:"alpha",name:"alpha",type:"number",defaultValue:1},{tfName:"beta",name:"beta",type:"number",defaultValue:.5}]},{tfOpName:"Softmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"LogSoftmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"SparseToDense",category:"normalization",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!0,notSupported:!0}]}]});var Pg=Object.freeze({__proto__:null,json:[{tfOpName:"Max",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Mean",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Min",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Sum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"All",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Any",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"ArgMax",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"ArgMin",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"Prod",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Cumsum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}],attrs:[{tfName:"exclusive",name:"exclusive",type:"bool"},{tfName:"reverse",name:"reverse",type:"bool"}]}]});var Wg=Object.freeze({__proto__:null,json:[{tfOpName:"ConcatV2",category:"slice_join",inputs:[{start:0,end:-1,name:"tensors",type:"tensors"},{start:-1,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"Concat",category:"slice_join",inputs:[{start:1,end:0,name:"tensors",type:"tensors"},{start:0,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"GatherV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"axis",type:"number",defaultValue:0}]},{tfOpName:"Gather",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0},{tfName:"validate_indices",name:"validateIndices",type:"bool",notSupported:!0}]},{tfOpName:"Reverse",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"dims",type:"bool",notSupported:!0}]},{tfOpName:"ReverseV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}]},{tfOpName:"Slice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"size",type:"number[]"}]},{tfOpName:"StridedSlice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"end",type:"number[]"},{start:3,name:"strides",type:"number[]"}],attrs:[{tfName:"begin_mask",name:"beginMask",type:"number",defaultValue:0},{tfName:"end_mask",name:"endMask",type:"number",defaultValue:0},{tfName:"new_axis_mask",name:"newAxisMask",type:"number",defaultValue:0},{tfName:"ellipsis_mask",name:"ellipsisMask",type:"number",defaultValue:0},{tfName:"shrink_axis_mask",name:"shrinkAxisMask",type:"number",defaultValue:0}]},{tfOpName:"Pack",category:"slice_join",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0}]},{tfOpName:"Unpack",category:"slice_join",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0},{tfName:"num",name:"num",type:"number",defaultValue:0,notSupported:!0}]},{tfOpName:"Tile",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"reps",type:"number[]"}]},{tfOpName:"Split",category:"slice_join",inputs:[{start:0,name:"axis",type:"number",defaultValue:0},{start:1,name:"x",type:"tensor"}],attrs:[{tfName:"num_split",name:"numOrSizeSplits",type:"number",defaultValue:1}]},{tfOpName:"SplitV",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"numOrSizeSplits",type:"number[]"},{start:2,name:"axis",type:"number",defaultValue:0}]},{tfOpName:"ScatterNd",category:"slice_join",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"values",type:"tensor"},{start:2,name:"shape",type:"number[]"}]},{tfOpName:"GatherNd",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}]},{tfOpName:"SparseToDense",category:"slice_join",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!1,notSupported:!0}]}]});var Vg=Object.freeze({__proto__:null,json:[{tfOpName:"FFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"RFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]},{tfOpName:"IRFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]}]});var Ug=Object.freeze({__proto__:null,json:[{tfOpName:"Cast",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"SrcT",name:"sdtype",type:"dtype",notSupported:!0},{tfName:"DstT",name:"dtype",type:"dtype"}]},{tfOpName:"ExpandDims",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"MirrorPad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"mode",name:"mode",type:"string"}]},{tfOpName:"Pad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"constant_value",name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"PadV2",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"},{start:2,name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"Reshape",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}]},{tfOpName:"Squeeze",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"axis",tfDeprecatedName:"squeeze_dims",name:"axis",type:"number[]"}]},{tfOpName:"SpaceToBatchND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"paddings",type:"number[]"}]},{tfOpName:"BatchToSpaceND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"crops",type:"number[]"}]},{tfOpName:"DepthToSpace",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"block_size",name:"blockSize",type:"number"},{tfName:"data_format",name:"dataFormat",type:"string"}]},{tfOpName:"BroadcastTo",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}],attrs:[]}]});class Gg{static get Instance(){return this._instance||(this._instance=new this)}constructor(){const t=[].concat(...[Tg,Eg,$g,Ag,Rg,Dg,_g,Lg,Mg,Fg,zg,Bg,Pg,Wg,Vg,Ug,Og].map(t=>t.json));this.opMappers=t.reduce((t,e)=>(t[e.tfOpName]=e,t),{})}transformGraph(t,e={}){const n=t.node,s=[],r=[],a=[],i=n.reduce((t,e)=>(t[e.name]=this.mapNode(e),e.op.startsWith("Placeholder")?s.push(t[e.name]):"Const"===e.op?r.push(t[e.name]):null!=e.input&&0!==e.input.length||a.push(t[e.name]),t),{});let o=[];const l=[];let u={},c={};null!=e&&(u=this.mapSignatureEntries(e.inputs),c=this.mapSignatureEntries(e.outputs));const h=Object.keys(i);h.forEach(t=>{const e=i[t];e.inputNames.forEach(t=>{const[n]=kg(t);e.inputs.push(i[n]),i[n].children.push(e)})}),0===Object.keys(c).length?h.forEach(t=>{const e=i[t];0===e.children.length&&l.push(e)}):Object.keys(c).forEach(t=>{const[e]=kg(t),n=i[e];null!=n&&(n.signatureKey=c[t],l.push(n))}),Object.keys(u).length>0?Object.keys(u).forEach(t=>{const[e]=kg(t),n=i[e];n&&(n.signatureKey=u[t],o.push(n))}):o=s;let p={};null!=t.library&&null!=t.library.function&&(p=t.library.function.reduce((t,e)=>(t[e.signature.name]=this.mapFunction(e),t),{}));const d={nodes:i,inputs:o,outputs:l,weights:r,placeholders:s,signature:e,functions:p};return a.length>0&&(d.initNodes=a),d}mapSignatureEntries(t){return Object.keys(t||{}).reduce((e,n)=>(e[t[n].name]=n,e),{})}mapNode(t){const e=xg(t.op)||this.opMappers[t.op]||{};null==t.attr&&(t.attr={});const n={name:t.name,op:t.op,category:e.category,inputNames:(t.input||[]).map(t=>t.startsWith("^")?t.substr(1):t),inputs:[],children:[],inputParams:{},attrParams:{},rawAttrs:t.attr};return null!=e.inputs&&(n.inputParams=e.inputs.reduce((t,e)=>(t[e.name]={type:e.type,inputIndexStart:e.start,inputIndexEnd:e.end},t),{})),null!=e.attrs&&(n.attrParams=e.attrs.reduce((e,n)=>{const s=n.type;let r=void 0;switch(n.type){case"string":r=jg(t.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=jg(t.attr,n.tfDeprecatedName,n.defaultValue));break;case"string[]":r=ny(t.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=ny(t.attr,n.tfDeprecatedName,n.defaultValue));break;case"number":r=Kg(t.attr,n.tfName,n.defaultValue||0),void 0===r&&n.tfDeprecatedName&&(r=Kg(t.attr,n.tfDeprecatedName,n.defaultValue));break;case"number[]":r=ey(t.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=ey(t.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool":r=qg(t.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=qg(t.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool[]":r=ry(t.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=ry(t.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape":r=ty(t.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=ty(t.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape[]":r=sy(t.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=sy(t.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype":r=Jg(t.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Jg(t.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype[]":r=Zg(t.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Zg(t.attr,n.tfDeprecatedName,n.defaultValue));break;case"func":r=Yg(t.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Yg(t.attr,n.tfDeprecatedName,n.defaultValue));break;case"tensor":case"tensors":break;default:throw new Error(`Unsupported param type: ${n.type} for op: ${t.op}`)}return e[n.name]={value:r,type:s},e},{})),n}mapFunction(t){const e=t.nodeDef,n=[];let s={};null!=e&&(s=e.reduce((t,e)=>(t[e.name]=this.mapNode(e),"Const"===e.op&&n.push(t[e.name]),t),{}));const r=[],a=[];t.signature.inputArg.forEach(t=>{const[e]=kg(t.name),n={name:e,op:"Placeholder",inputs:[],inputNames:[],category:"graph",inputParams:{},attrParams:{dtype:{value:Xg(t.type),type:"dtype"}},children:[]};n.signatureKey=t.name,r.push(n),s[e]=n}),Object.keys(s).forEach(t=>{const e=s[t];e.inputNames.forEach(t=>{const[n]=kg(t);e.inputs.push(s[n]),s[n].children.push(e)})});const i=t.ret;t.signature.outputArg.forEach(t=>{const[e,n]=kg(i[t.name]),r=s[e];null!=r&&(r.defaultOutput=n,a.push(r))});const o=this.mapArgsToSignature(t);return{nodes:s,inputs:r,outputs:a,weights:n,placeholders:[],signature:o}}mapArgsToSignature(t){return{methodName:t.signature.name,inputs:t.signature.inputArg.reduce((t,e)=>(t[e.name]=this.mapArgToTensorInfo(e),t),{}),outputs:t.signature.outputArg.reduce((e,n)=>(e[n.name]=this.mapArgToTensorInfo(n,t.ret),e),{})}}mapArgToTensorInfo(t,e){let n=t.name;return null!=e&&(n=e[n]),{name:n,dtype:t.type}}}function Hg(t,e){const n=Array.isArray(t)?String.fromCharCode.apply(null,t):function(t){const e=H().global;if(void 0!==e.atob)return e.atob(t);if("undefined"!=typeof Buffer)return new Buffer(t,"base64").toString();throw new Error("Unable to decode base64 in this environment. Missing built-in atob() or Buffer()")}(t);return e?n:n.toLowerCase()}function jg(t,e,n,s=!1){const r=t[e];return null!=r?Hg(r.s,s):n}function qg(t,e,n){const s=t[e];return s?s.b:n}function Kg(t,e,n){const s=t[e]||{},r=null!=s.i?s.i:null!=s.f?s.f:n;return"number"==typeof r?r:parseInt(r,10)}function Xg(t){switch("string"==typeof t&&(t=gg[t]),t){case gg.DT_FLOAT:return"float32";case gg.DT_INT32:case gg.DT_INT64:case gg.DT_INT8:case gg.DT_UINT8:return"int32";case gg.DT_BOOL:return"bool";case gg.DT_DOUBLE:return"float32";case gg.DT_STRING:return"string";default:return null}}function Yg(t,e,n){const s=t[e];return s&&s.func?s.func.name:n}function Jg(t,e,n){const s=t[e];return s&&s.type?Xg(s.type):n}function Zg(t,e,n){const s=t[e];return s&&s.list&&s.list.type?s.list.type.map(t=>Xg(t)):n}function Qg(t){if(!t.unknownRank)return null!=t.dim?t.dim.map(t=>"number"==typeof t.size?t.size:parseInt(t.size,10)):[]}function ty(t,e,n){const s=t[e];return s&&s.shape?Qg(s.shape):n}function ey(t,e,n){const s=t[e];return s?((s.list.f&&s.list.f.length?s.list.f:s.list.i)||[]).map(t=>"number"==typeof t?t:parseInt(t,10)):n}function ny(t,e,n,s=!1){const r=t[e];return r&&r.list&&r.list.s?r.list.s.map(t=>Hg(t,s)):n}function sy(t,e,n){const s=t[e];return s&&s.list&&s.list.shape?s.list.shape.map(t=>Qg(t)):n}function ry(t,e,n){const s=t[e];return s&&s.list&&s.list.b?s.list.b:n}class ay{constructor(t,e,n){this.node=t,this.tensorMap=e,this.context=n,this.inputs=[],this.attrs={},this.inputs=t.inputNames.map(t=>this.getInput(t)),null!=t.rawAttrs&&(this.attrs=Object.keys(t.rawAttrs).reduce((t,e)=>(t[e]=this.getAttr(e),t),{}))}getInput(t){return vg(t,this.tensorMap,this.context)}getAttr(t,e){const n=this.node.rawAttrs[t];if(null!=n.tensor)return vg(t,this.tensorMap,this.context);if(null!=n.i||null!=n.f)return Kg(this.node.rawAttrs,t,e);if(null!=n.s)return jg(this.node.rawAttrs,t,e);if(null!=n.b)return qg(this.node.rawAttrs,t,e);if(null!=n.shape)return ty(this.node.rawAttrs,t,e);if(null!=n.type)return Jg(this.node.rawAttrs,t,e);if(null!=n.list){if(null!=n.list.i||null!=n.list.f)return ey(this.node.rawAttrs,t,e);if(null!=n.list.s)return ny(this.node.rawAttrs,t,e);if(null!=n.list.shape)return sy(this.node.rawAttrs,t,e);if(null!=n.list.b)return ry(this.node.rawAttrs,t,e);if(null!=n.list.type)return Zg(this.node.rawAttrs,t,e)}return e}}function iy(t,e,n=""){l(function(t,e){if(t.length!==e.length)return!1;for(let n=0;n<t.length;n++)if(-1!==t[n]&&-1!==e[n]&&t[n]!==e[n])return!1;return!0}(t,e),()=>n+` Shapes ${t} and ${e} must match`)}class oy{constructor(t,e,n,s,r,a,i){this.name=t,this.dtype=e,this.maxSize=n,this.elementShape=s,this.identicalElementShapes=r,this.dynamicSize=a,this.clearAfterRead=i,this.tensors=[],this.closed_=!1,this.idTensor=Jr(0),Qn(this.idTensor)}get id(){return this.idTensor.id}get closed(){return this.closed_}clearAndClose(t){this.tensors.forEach(e=>{null!=t&&t.has(e.tensor.id)||e.tensor.dispose()}),this.tensors=[],this.closed_=!0,this.idTensor.dispose()}size(){return this.tensors.length}read(t){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(t<0||t>=this.size())throw new Error(`Tried to read from index ${t}, but array size is: ${this.size()}`);const e=this.tensors[t];if(e.cleared)throw new Error(`TensorArray ${this.name}: Could not read index ${t} twice because it was cleared after a previous read (perhaps try setting clear_after_read = false?).`);return this.clearAfterRead&&(e.cleared=!0),e.read=!0,e.tensor}readMany(t){return t.map(t=>this.read(t))}write(t,e){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(t<0||!this.dynamicSize&&t>=this.maxSize)throw new Error(`Tried to write to index ${t}, but array is not resizeable and size is: ${this.maxSize}`);const n=this.tensors[t]||{};if(e.dtype!==this.dtype)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${t},\n          because the value dtype is ${e.dtype}, but TensorArray dtype is ${this.dtype}.`);if(0!==this.size()||null!=this.elementShape&&0!==this.elementShape.length||(this.elementShape=e.shape),iy(this.elementShape,e.shape,`TensorArray ${this.name}: Could not write to TensorArray index ${t}.`),n.read)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${t}, because it has already been read.`);if(n.written)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${t}, because it has already been written.`);n.tensor=e,Qn(e),n.written=!0,this.tensors[t]=n}writeMany(t,e){if(t.length!==e.length)throw new Error(`TensorArray ${this.name}: could not write multiple tensors,because the index size: ${t.length} is not the same as tensors size: ${e.length}.`);t.forEach((t,n)=>this.write(t,e[n]))}gather(t,e){if(e&&e!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but gather requested dtype ${e}`);if(t)t=t.slice(0,this.size());else{t=[];for(let e=0;e<this.size();e++)t.push(e)}if(0===t.length)return re([],[0].concat(this.elementShape));const n=this.readMany(t);return iy(this.elementShape,n[0].shape,"TensorArray shape mismatch: "),Vi(n,0)}concat(t){if(t&&t!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but concat requested dtype ${t}`);if(0===this.size())return re([],[0].concat(this.elementShape));const e=[];for(let t=0;t<this.size();t++)e.push(t);const n=this.readMany(e);return iy(this.elementShape,n[0].shape,`TensorArray shape mismatch: tensor array shape (${this.elementShape}) vs first tensor shape (${n[0].shape})`),Hs(n,0)}scatter(t,e){if(e.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${e.dtype}`);if(t.length!==e.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${t.length} vs. ${e.shape[0]}`);const n=Math.max(...t);if(!this.dynamicSize&&n>=this.maxSize)throw new Error(`Max index must be < array size (${n}  vs. ${this.maxSize})`);this.writeMany(t,Zi(e,0))}split(t,e){if(e.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${e.dtype}`);let n=0;const s=t.map(t=>(n+=t,n));if(n!==e.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${n}, and tensor's shape is: ${e.shape}`);if(!this.dynamicSize&&t.length!==this.maxSize)throw new Error(`TensorArray's size is not equal to the size of lengths (${this.maxSize} vs. ${t.length}), and the TensorArray is not marked as dynamically resizeable`);const r=0===n?0:e.size/n,a=[];Jn(()=>{e=on(e,[1,n,r]);for(let n=0;n<t.length;++n){const i=[0,0===n?0:s[n-1],0],o=[1,t[n],r];a[n]=on(qs(e,i,o),this.elementShape)}return a});const i=[];for(let e=0;e<t.length;e++)i[e]=e;this.writeMany(i,a)}}class ly{constructor(t,e,n,s=-1){this.tensors=t,this.elementShape=e,this.elementDtype=n,null!=t&&t.forEach(t=>{if(n!==t.dtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${t.dtype}`);iy(e,t.shape,"TensorList shape mismatch: "),Qn(t)}),this.idTensor=Jr(0),this.maxNumElements=s,Qn(this.idTensor)}get id(){return this.idTensor.id}copy(){return new ly([...this.tensors],this.elementShape,this.elementDtype)}clearAndClose(t){this.tensors.forEach(e=>{null!=t&&t.has(e.id)||e.dispose()}),this.tensors.length=0,this.idTensor.dispose()}size(){return this.tensors.length}stack(t,e,n=-1){if(e!==this.elementDtype)throw new Error(`Invalid data types; op elements ${e}, but list elements ${this.elementDtype}`);if(-1!==n&&this.tensors.length!==n)throw new Error(`Operation expected a list with ${n} elements but got a list with ${this.tensors.length} elements.`);return iy(t,this.elementShape,"TensorList shape mismatch: "),Jn(()=>{const e=this.tensors.map(e=>on(e,t));return Vi(e,0)})}popBack(t,e){if(e!==this.elementDtype)throw new Error(`Invalid data types; op elements ${e}, but list elements ${this.elementDtype}`);if(0===this.size())throw new Error("Trying to pop from an empty list.");const n=this.tensors.pop();return iy(n.shape,t,"TensorList shape mismatch: "),on(n,t)}pushBack(t){if(t.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t.dtype}, but list elements ${this.elementDtype}`);if(iy(t.shape,this.elementShape,"TensorList shape mismatch: "),this.maxNumElements===this.size())throw new Error("Trying to push element into a full list.");Qn(t),this.tensors.push(t)}resize(t){if(t<0)throw new Error("TensorListResize expects size to be non-negative. Got: "+t);if(-1!==this.maxNumElements&&t>this.maxNumElements)throw new Error(`TensorListResize input size ${t} is greater maxNumElement ${this.maxNumElements}.`);this.tensors.length=t}getItem(t,e,n){if(n!==this.elementDtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${this.elementDtype}`);if(t<0||t>this.tensors.length)throw new Error(`Trying to access element ${t} in a list with ${this.tensors.length} elements.`);if(null==this.tensors[t])throw new Error(`element at index ${t} is null.`);return iy(this.tensors[t].shape,e,"TensorList shape mismatch: "),this.tensors[t]}setItem(t,e){if(e.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${this.elementDtype}`);if(t<0||-1!==this.maxNumElements&&t>=this.maxNumElements)throw new Error(`Trying to set element ${t} in a list with max ${this.maxNumElements} elements.`);iy(this.elementShape,e.shape,"TensorList shape mismatch: "),Qn(e),this.tensors[t]=e}gather(t,e,n){if(e!==this.elementDtype)throw new Error(`Invalid data types; op elements ${e}, but list elements ${this.elementDtype}`);return iy(this.elementShape,n,"TensorList shape mismatch: "),0===(t=t.slice(0,this.size())).length?re([],[0].concat(this.elementShape)):Jn(()=>{const e=t.map(t=>on(this.tensors[t],n));return Vi(e,0)})}concat(t,e){if(t&&t!==this.elementDtype)throw new Error(`TensorList dtype is ${this.elementDtype} but concat requested dtype ${t}`);return iy(this.elementShape,e,"TensorList shape mismatch: "),0===this.size()?re([],[0].concat(this.elementShape)):Jn(()=>{const t=this.tensors.map(t=>on(t,e));return Hs(t,0)})}}const uy=async(t,e,n)=>{switch(t.op){case"If":case"StatelessIf":{const s=wg("thenBranch",t,e,n),r=wg("elseBranch",t,e,n),a=wg("cond",t,e,n),i=wg("args",t,e,n);return(await a.data())[0]?n.functionMap[s].executeFunctionAsync(i,n.tensorArrayMap,n.tensorListMap):n.functionMap[r].executeFunctionAsync(i,n.tensorArrayMap,n.tensorListMap)}case"While":case"StatelessWhile":{const s=wg("body",t,e,n),r=wg("cond",t,e,n),a=wg("args",t,e,n),i=await n.functionMap[r].executeFunctionAsync(a,n.tensorArrayMap,n.tensorListMap),o=a.map(t=>t.id);let l=await i[0].data();i.forEach(t=>{t.kept||-1!==o.indexOf(t.id)||t.dispose()});let u=a;for(;l[0];){const t=u;u=await n.functionMap[s].executeFunctionAsync(u,n.tensorArrayMap,n.tensorListMap);const e=u.map(t=>t.id);t.forEach(t=>{t.kept||-1!==o.indexOf(t.id)||-1!==e.indexOf(t.id)||t.dispose()});const a=await n.functionMap[r].executeFunctionAsync(u,n.tensorArrayMap,n.tensorListMap);l=await a[0].data(),a.forEach(t=>{t.kept||-1!==o.indexOf(t.id)||-1!==e.indexOf(t.id)||t.dispose()})}return u}case"LoopCond":return[Sg(wg("pred",t,e,n))];case"Switch":{const s=wg("pred",t,e,n);let r=wg("data",t,e,n);return r.kept||(r=Sg(r)),(await s.data())[0]?[void 0,r]:[r,void 0]}case"Merge":{const s=t.inputNames.find(t=>void 0!==vg(t,e,n));if(s){return[Sg(vg(s,e,n))]}return}case"Enter":{const s=wg("frameName",t,e,n),r=wg("tensor",t,e,n);return n.enterFrame(s),[Sg(r)]}case"Exit":{const s=wg("tensor",t,e,n);return n.exitFrame(),[Sg(s)]}case"NextIteration":{const s=wg("tensor",t,e,n);return n.nextIteration(),[Sg(s)]}case"TensorArrayV3":{const s=wg("size",t,e,n),r=wg("dtype",t,e,n),a=wg("elementShape",t,e,n),i=wg("dynamicSize",t,e,n),o=wg("clearAfterRead",t,e,n),l=wg("identicalElementShapes",t,e,n),u=wg("name",t,e,n),c=new oy(u,r,s,a,l,i,o);return n.addTensorArray(c),[c.idTensor,Jr(1)]}case"TensorArrayWriteV3":{const s=wg("tensorArrayId",t,e,n),r=wg("index",t,e,n),a=wg("tensor",t,e,n),i=n.getTensorArray(s.id);return i.write(r,a),[i.idTensor]}case"TensorArrayReadV3":{const s=wg("tensorArrayId",t,e,n),r=wg("index",t,e,n);return[n.getTensorArray(s.id).read(r)]}case"TensorArrayGatherV3":{const s=wg("tensorArrayId",t,e,n),r=wg("indices",t,e,n),a=wg("dtype",t,e,n);return[n.getTensorArray(s.id).gather(r,a)]}case"TensorArrayScatterV3":{const s=wg("tensorArrayId",t,e,n),r=wg("indices",t,e,n),a=wg("tensor",t,e,n),i=n.getTensorArray(s.id);return i.scatter(r,a),[i.idTensor]}case"TensorArrayConcatV3":{const s=wg("tensorArrayId",t,e,n),r=n.getTensorArray(s.id),a=wg("dtype",t,e,n);return[r.concat(a)]}case"TensorArraySplitV3":{const s=wg("tensorArrayId",t,e,n),r=wg("tensor",t,e,n),a=wg("lengths",t,e,n),i=n.getTensorArray(s.id);return i.split(a,r),[i.idTensor]}case"TensorArraySizeV3":{const s=wg("tensorArrayId",t,e,n);return[Jr(n.getTensorArray(s.id).size(),"int32")]}case"TensorArrayCloseV3":{const s=wg("tensorArrayId",t,e,n),r=n.getTensorArray(s.id);return r.clearAndClose(),[r.idTensor]}case"TensorListSetItem":{const s=wg("tensorListId",t,e,n),r=wg("index",t,e,n),a=wg("tensor",t,e,n),i=n.getTensorList(s.id);return i.setItem(r,a),[i.idTensor]}case"TensorListGetItem":{const s=wg("tensorListId",t,e,n),r=wg("index",t,e,n),a=wg("elementShape",t,e,n),i=wg("elementDType",t,e,n);return[n.getTensorList(s.id).getItem(r,a,i)]}case"TensorListScatterV2":case"TensorListScatter":{const s=wg("indices",t,e,n),r=function(t,e,n,s){if(e.length!==t.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${e.length} vs. ${t.shape[0]}`);const r=Math.max(...e);if(null!=s&&-1!==s&&r>=s)throw new Error(`Max index must be < array size (${r}  vs. ${s})`);const a=new ly([],n,t.dtype,s),i=Zi(t,0);return e.forEach((t,e)=>{a.setItem(t,i[e])}),a}(wg("tensor",t,e,n),s,wg("elementShape",t,e,n),wg("numElements",t,e,n));return n.addTensorList(r),[r.idTensor]}case"TensorListReserve":{const s=function(t,e,n){return new ly([],t,e,n)}(wg("elementShape",t,e,n),wg("elementDType",t,e,n),wg("numElements",t,e,n));return n.addTensorList(s),[s.idTensor]}case"TensorListGather":{const s=wg("tensorListId",t,e,n),r=wg("indices",t,e,n),a=wg("elementShape",t,e,n),i=wg("elementDType",t,e,n);return[n.getTensorList(s.id).gather(r,i,a)]}case"TensorListStack":{const s=wg("tensorListId",t,e,n),r=wg("elementShape",t,e,n),a=wg("elementDType",t,e,n),i=wg("numElements",t,e,n);return[n.getTensorList(s.id).stack(r,a,i)]}case"TensorListFromTensor":{const s=function(t,e,n){const s=t.dtype;if(t.shape.length<1)throw new Error("Tensor must be at least a vector, but saw shape: "+t.shape);if(t.dtype!==n)throw new Error(`Invalid data types; op elements ${t.dtype}, but list elements ${n}`);iy(t.shape.slice(1),e,"TensorList shape mismatch: ");const r=Zi(t);return new ly(r,e,s)}(wg("tensor",t,e,n),wg("elementShape",t,e,n),wg("elementDType",t,e,n));return n.addTensorList(s),[s.idTensor]}case"TensorListConcat":{const s=wg("tensorListId",t,e,n),r=n.getTensorList(s.id),a=wg("dtype",t,e,n),i=wg("elementShape",t,e,n);return[r.concat(a,i)]}case"TensorListPushBack":{const s=wg("tensorListId",t,e,n),r=wg("tensor",t,e,n),a=n.getTensorList(s.id);return a.pushBack(r),[a.idTensor]}case"TensorListPopBack":{const s=wg("tensorListId",t,e,n),r=wg("elementShape",t,e,n),a=wg("elementDType",t,e,n);return[n.getTensorList(s.id).popBack(r,a)]}case"TensorListSplit":{const s=wg("tensor",t,e,n),r=wg("elementShape",t,e,n),a=function(t,e,n){let s=0;const r=e.map(t=>(s+=t,s));if(s!==t.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${s}, and tensor's shape is: ${t.shape}`);const a=0===s?0:t.size/s,i=Jn(()=>{const i=[];t=on(t,[1,s,a]);for(let s=0;s<e.length;++s){const o=[0,0===s?0:r[s-1],0],l=[1,e[s],a];i[s]=on(qs(t,o,l),n)}return t.dispose(),i}),o=new ly([],n,t.dtype,e.length);for(let t=0;t<i.length;t++)o.setItem(t,i[t]);return o}(s,wg("lengths",t,e,n),r);return n.addTensorList(a),[a.idTensor]}default:throw TypeError(`Node type ${t.op} is not implemented`)}};function cy(t,e,n){const[s,r]=wg("fusedOps",t,e,n),a="biasadd"===s,i="prelu"===r,o="fusedbatchnorm"===s,l=wg("numArgs",t,e,n);if(a){if(i&&2!==l)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!i&&1!==l)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd must have one extra argument: bias.")}if(o)throw new Error("FusedConv2d and DepthwiseConv2d with FusedBatchNorm is not supported.");const u=wg("strides",t,e,n),c=Cg(t,e,n),h=wg("dataFormat",t,e,n).toUpperCase(),p=wg("dilations",t,e,n),[d,f]=wg("args",t,e,n);return{stride:u,pad:c,dataFormat:h,dilations:p,biasArg:d,preluArg:f,activationFunc:r}}function hy(t,e,n){return{boxes:wg("boxes",t,e,n),scores:wg("scores",t,e,n),maxOutputSize:wg("maxOutputSize",t,e,n),iouThreshold:wg("iouThreshold",t,e,n),scoreThreshold:wg("scoreThreshold",t,e,n),softNmsSigma:wg("softNmsSigma",t,e,n)}}class py{constructor(t,e){this.keyDType=t,this.valueDType=e,this.handle=Jr(0),this.tensorMap=new Map,Qn(this.handle)}get id(){return this.handle.id}clearAndClose(){this.tensorMap.forEach(t=>t.dispose()),this.tensorMap.clear(),this.handle.dispose()}size(){return this.tensorMap.size}async import(t,e){this.checkKeyAndValueTensor(t,e);const n=await t.data();return this.tensorMap.forEach(t=>t.dispose()),this.tensorMap.clear(),Jn(()=>{const t=Zi(e),s=n.length,r=t.length;l(s===r,()=>`The number of elements doesn't match, keys has ${s} elements, the values has ${r} elements.`);for(let e=0;e<s;e++){const s=n[e],r=t[e];Qn(r),this.tensorMap.set(s,r)}return this.handle})}async find(t,e){this.checkKeyAndValueTensor(t,e);const n=await t.data();return Jn(()=>{const t=[];for(let s=0;s<n.length;s++){const r=n[s],a=this.findWithDefault(r,e);t.push(a)}return Vi(t)})}findWithDefault(t,e){const n=this.tensorMap.get(t);return null!=n?n:e}checkKeyAndValueTensor(t,e){if(t.dtype!==this.keyDType)throw new Error(`Expect key dtype ${this.keyDType}, but got `+t.dtype);if(e.dtype!==this.valueDType)throw new Error(`Expect value dtype ${this.valueDType}, but got `+e.dtype)}}function dy(t,e,n,s){const r=((t,e,n)=>{switch(t.category){case"arithmetic":return Jn(()=>((t,e,n)=>{switch(t.op){case"BiasAdd":case"AddV2":case"Add":return[ss(wg("a",t,e,n),wg("b",t,e,n))];case"AddN":return[cs(wg("tensors",t,e,n))];case"FloorMod":case"Mod":return[$a(wg("a",t,e,n),wg("b",t,e,n))];case"Mul":return[is(wg("a",t,e,n),wg("b",t,e,n))];case"RealDiv":case"Div":return[as(wg("a",t,e,n),wg("b",t,e,n))];case"DivNoNan":return[$r(wg("a",t,e,n),wg("b",t,e,n))];case"FloorDiv":return[rs(wg("a",t,e,n),wg("b",t,e,n))];case"Sub":return[pa(wg("a",t,e,n),wg("b",t,e,n))];case"Minimum":return[Ta(wg("a",t,e,n),wg("b",t,e,n))];case"Maximum":return[Yr(wg("a",t,e,n),wg("b",t,e,n))];case"Pow":return[Ha(wg("a",t,e,n),wg("b",t,e,n))];case"SquaredDifference":return[Pi(wg("a",t,e,n),wg("b",t,e,n))];default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"basic_math":return Jn(()=>((t,e,n)=>{switch(t.op){case"Abs":case"ComplexAbs":return[os(wg("x",t,e,n))];case"Acos":return[ls(wg("x",t,e,n))];case"Acosh":return[us(wg("x",t,e,n))];case"Asin":return[Ns(wg("x",t,e,n))];case"Asinh":return[Is(wg("x",t,e,n))];case"Atan":return[Cs(wg("x",t,e,n))];case"Atan2":return[Ss(wg("x",t,e,n),wg("y",t,e,n))];case"Atanh":return[Ts(wg("x",t,e,n))];case"Ceil":return[sr(wg("x",t,e,n))];case"Complex":return[ne(wg("real",t,e,n),wg("imag",t,e,n))];case"Cos":return[gr(wg("x",t,e,n))];case"Cosh":return[yr(wg("x",t,e,n))];case"Elu":return[Rr(wg("x",t,e,n))];case"Erf":return[Dr(wg("x",t,e,n))];case"Exp":return[_r(wg("x",t,e,n))];case"Expm1":return[Or(wg("x",t,e,n))];case"Floor":return[Br(wg("x",t,e,n))];case"Log":return[sa(wg("x",t,e,n))];case"Log1p":return[ra(wg("x",t,e,n))];case"Imag":return[jr(wg("x",t,e,n))];case"Neg":return[la(wg("x",t,e,n))];case"Reciprocal":return[pi(wg("x",t,e,n))];case"Real":return[Oa(wg("x",t,e,n))];case"Relu":return[di(wg("x",t,e,n))];case"Round":return[wi(wg("x",t,e,n))];case"Selu":return[ki(wg("x",t,e,n))];case"Sigmoid":return[js(wg("x",t,e,n))];case"Sin":return[Si(wg("x",t,e,n))];case"Sign":return[Ci(wg("x",t,e,n))];case"Sinh":return[Ti(wg("x",t,e,n))];case"Softplus":return[ua(wg("x",t,e,n))];case"Sqrt":return[Bi(wg("x",t,e,n))];case"Square":return[Aa(wg("x",t,e,n))];case"Tanh":return[Ks(wg("x",t,e,n))];case"Tan":return[Hi(wg("x",t,e,n))];case"Relu6":case"ClipByValue":return[rr(wg("x",t,e,n),wg("clipValueMin",t,e,n),wg("clipValueMax",t,e,n))];case"Rsqrt":return[vi(vg(t.inputNames[0],e,n))];case"Prod":return[qa(wg("x",t,e,n),wg("axes",t,e,n))];case"LeakyRelu":return[Zr(wg("x",t,e,n),wg("alpha",t,e,n))];case"Prelu":return[ja(wg("x",t,e,n),wg("alpha",t,e,n))];default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"control":return uy(t,e,n);case"convolution":return Jn(()=>((t,e,n)=>{switch(t.op){case"Conv1D":{const s=wg("stride",t,e,n),r=wg("pad",t,e,n),a=wg("dataFormat",t,e,n).toUpperCase(),i=wg("dilation",t,e,n);return[cr(wg("x",t,e,n),wg("filter",t,e,n),s,r,a,i)]}case"Conv2D":{const s=wg("strides",t,e,n),r=Cg(t,e,n),a=wg("dataFormat",t,e,n).toUpperCase(),i=wg("dilations",t,e,n);return[ur(wg("x",t,e,n),wg("filter",t,e,n),[s[1],s[2]],r,a,[i[1],i[2]])]}case"_FusedConv2D":{const{stride:s,pad:r,dataFormat:a,dilations:i,biasArg:o,preluArg:l,activationFunc:u}=cy(t,e,n);return[_o({x:wg("x",t,e,n),filter:wg("filter",t,e,n),strides:[s[1],s[2]],pad:r,dataFormat:a,dilations:[i[1],i[2]],bias:o,activation:u,preluActivationWeights:l})]}case"FusedDepthwiseConv2dNative":{const{stride:s,pad:r,dataFormat:a,dilations:i,biasArg:o,preluArg:l,activationFunc:u}=cy(t,e,n);return[Mo({x:wg("x",t,e,n),filter:wg("filter",t,e,n),strides:[s[1],s[2]],pad:r,dataFormat:a,dilations:[i[1],i[2]],bias:o,activation:u,preluActivationWeights:l})]}case"Conv2DBackpropInput":case"Conv2dTranspose":{const s=wg("outputShape",t,e,n),r=wg("strides",t,e,n),a=Cg(t,e,n);return[pr(wg("x",t,e,n),wg("filter",t,e,n),s,[r[1],r[2]],a)]}case"DepthwiseConv2dNative":case"DepthwiseConv2d":{const s=wg("strides",t,e,n),r=Cg(t,e,n),a=wg("dilations",t,e,n),i=wg("dataFormat",t,e,n).toUpperCase();return[wr(wg("input",t,e,n),wg("filter",t,e,n),[s[1],s[2]],r,i,[a[1],a[2]])]}case"Conv3D":{const s=wg("strides",t,e,n),r=wg("pad",t,e,n),a=wg("dataFormat",t,e,n).toUpperCase(),i=wg("dilations",t,e,n);return[dr(wg("x",t,e,n),wg("filter",t,e,n),[s[1],s[2],s[3]],r,a,[i[1],i[2],i[3]])]}case"AvgPool":{const s=wg("strides",t,e,n),r=wg("pad",t,e,n),a=wg("kernelSize",t,e,n);return[Ws(wg("x",t,e,n),[a[1],a[2]],[s[1],s[2]],r)]}case"MaxPool":{const s=wg("strides",t,e,n),r=wg("pad",t,e,n),a=wg("kernelSize",t,e,n);return[wa(wg("x",t,e,n),[a[1],a[2]],[s[1],s[2]],r)]}case"MaxPoolWithArgmax":{const s=wg("strides",t,e,n),r=wg("pad",t,e,n),a=wg("kernelSize",t,e,n),i=wg("includeBatchInIndex",t,e,n),{result:o,indexes:l}=ka(wg("x",t,e,n),[a[1],a[2]],[s[1],s[2]],r,i);return[o,l]}case"AvgPool3D":{const s=wg("strides",t,e,n),r=wg("pad",t,e,n),a=wg("kernelSize",t,e,n);return[Vs(wg("x",t,e,n),[a[1],a[2],a[3]],[s[1],s[2],s[3]],r)]}case"MaxPool3D":{const s=wg("strides",t,e,n),r=wg("pad",t,e,n),a=wg("kernelSize",t,e,n);return[va(wg("x",t,e,n),[a[1],a[2],a[3]],[s[1],s[2],s[3]],r)]}case"Dilation2D":{const s=wg("strides",t,e,n),r=wg("pad",t,e,n),a=wg("dilations",t,e,n),i=s[1],o=s[2],l=a[1],u=a[2];return[kr(wg("x",t,e,n),wg("filter",t,e,n),[i,o],r,[l,u],"NHWC")]}default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"creation":return Jn(()=>((t,e,n)=>{switch(t.op){case"Fill":{const s=wg("shape",t,e,n),r=wg("dtype",t,e,n);return[zr(s,wg("value",t,e,n),r)]}case"LinSpace":return[ea(wg("start",t,e,n),wg("stop",t,e,n),wg("num",t,e,n))];case"Multinomial":{const s=wg("logits",t,e,n),r=wg("numSamples",t,e,n),a=wg("seed",t,e,n);return[_a(s,r,a)]}case"OneHot":{const s=wg("indices",t,e,n),r=wg("depth",t,e,n),a=wg("onValue",t,e,n),i=wg("offValue",t,e,n);return[un(s,r,a,i)]}case"Ones":return[Ia(wg("shape",t,e,n),wg("dtype",t,e,n))];case"OnesLike":return[Ma(wg("x",t,e,n))];case"RandomUniform":return[ui(wg("shape",t,e,n),wg("minval",t,e,n),wg("maxval",t,e,n),wg("dtype",t,e,n))];case"Range":return[hi(wg("start",t,e,n),wg("stop",t,e,n),wg("step",t,e,n),wg("dtype",t,e,n))];case"TruncatedNormal":{const s=wg("shape",t,e,n),r=wg("mean",t,e,n),a=wg("stdDev",t,e,n),i=wg("seed",t,e,n);return[Xi(s,r,a,wg("dtype",t,e,n),i)]}case"Zeros":return[Na(wg("shape",t,e,n),wg("dtype",t,e,n))];case"ZerosLike":return[Er(wg("x",t,e,n))];default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"dynamic":return(async(t,e,n)=>{switch(t.op){case"NonMaxSuppressionV5":{const{boxes:s,scores:r,maxOutputSize:a,iouThreshold:i,scoreThreshold:o,softNmsSigma:l}=hy(t,e,n),u=await Sl.nonMaxSuppressionWithScoreAsync(s,r,a,i,o,l);return[u.selectedIndices,u.selectedScores]}case"NonMaxSuppressionV4":{const{boxes:s,scores:r,maxOutputSize:a,iouThreshold:i,scoreThreshold:o}=hy(t,e,n),l=wg("padToMaxOutputSize",t,e,n),u=await Sl.nonMaxSuppressionPaddedAsync(s,r,a,i,o,l);return[u.selectedIndices,u.validOutputs]}case"NonMaxSuppressionV3":case"NonMaxSuppressionV2":{const{boxes:s,scores:r,maxOutputSize:a,iouThreshold:i,scoreThreshold:o}=hy(t,e,n);return[await Sl.nonMaxSuppressionAsync(s,r,a,i,o)]}case"Where":{const s=Ve(wg("condition",t,e,n),"bool"),r=[await eo(s)];return s.dispose(),r}case"ListDiff":return Ii(wg("x",t,e,n),wg("y",t,e,n));default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n);case"evaluation":return Jn(()=>((t,e,n)=>{switch(t.op){case"TopKV2":{const s=wg("x",t,e,n),r=wg("k",t,e,n),a=wg("sorted",t,e,n),i=Ki(s,r,a);return[i.values,i.indices]}case"Unique":{const s=wg("x",t,e,n),r=Yi(s);return[r.values,r.indices]}case"UniqueV2":{const s=wg("x",t,e,n),r=wg("axis",t,e,n),a=Yi(s,r);return[a.values,a.indices]}default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"image":return Jn(()=>((t,e,n)=>{switch(t.op){case"ResizeBilinear":{const s=wg("images",t,e,n),r=wg("size",t,e,n),a=wg("alignCorners",t,e,n);return[Sl.resizeBilinear(s,[r[0],r[1]],a)]}case"ResizeNearestNeighbor":{const s=wg("images",t,e,n),r=wg("size",t,e,n),a=wg("alignCorners",t,e,n);return[Sl.resizeNearestNeighbor(s,[r[0],r[1]],a)]}case"CropAndResize":{const s=wg("image",t,e,n),r=wg("boxes",t,e,n),a=wg("boxInd",t,e,n),i=wg("cropSize",t,e,n),o=wg("method",t,e,n),l=wg("extrapolationValue",t,e,n);return[Sl.cropAndResize(s,r,a,i,o,l)]}default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"graph":return Jn(()=>((t,e,n)=>{switch(t.op){case"Const":return e[t.name];case"PlaceholderWithDefault":const s=wg("default",t,e,n);return[vg(t.name,e,n)||s];case"Placeholder":return[vg(t.name,e,n)];case"Identity":case"StopGradient":case"FakeQuantWithMinMaxVars":return[Sg(wg("x",t,e,n))];case"IdentityN":return wg("x",t,e,n).map(t=>Sg(t));case"Snapshot":return[Sg(wg("x",t,e,n))];case"Shape":return[ci(wg("x",t,e,n).shape,"int32")];case"ShapeN":return wg("x",t,e,n).map(t=>ci(t.shape));case"Size":return[Jr(wg("x",t,e,n).size,"int32")];case"Rank":return[Jr(wg("x",t,e,n).rank,"int32")];case"NoOp":return[Jr(1)];case"Print":const r=wg("x",t,e,n),a=wg("data",t,e,n),i=wg("message",t,e,n),o=wg("summarize",t,e,n);console.warn("The graph has a tf.print() operation,usually used for debugging, which slows down performance."),console.log(i);for(let t=0;t<a.length;t++)console.log(Array.prototype.slice.call(a[t].dataSync()).slice(0,o));return[r];default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"logical":return Jn(()=>((t,e,n)=>{switch(t.op){case"Equal":return[Sr(wg("a",t,e,n),wg("b",t,e,n))];case"NotEqual":return[Fa(wg("a",t,e,n),wg("b",t,e,n))];case"Greater":return[Gr(wg("a",t,e,n),wg("b",t,e,n))];case"GreaterEqual":return[Hr(wg("a",t,e,n),wg("b",t,e,n))];case"Less":return[Qr(wg("a",t,e,n),wg("b",t,e,n))];case"LessEqual":return[ta(wg("a",t,e,n),wg("b",t,e,n))];case"LogicalAnd":return[ga(wg("a",t,e,n),wg("b",t,e,n))];case"LogicalNot":return[ya(wg("a",t,e,n))];case"LogicalOr":return[ba(wg("a",t,e,n),wg("b",t,e,n))];case"Select":case"SelectV2":return[Tr(wg("condition",t,e,n),wg("a",t,e,n),wg("b",t,e,n))];default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"matrices":return Jn(()=>((t,e,n)=>{switch(t.op){case"BatchMatMul":case"BatchMatMulV2":case"MatMul":return[ln(wg("a",t,e,n),wg("b",t,e,n),wg("transposeA",t,e,n),wg("transposeB",t,e,n))];case"Transpose":return[cn(wg("x",t,e,n),wg("perm",t,e,n))];case"_FusedMatMul":const[s,r]=wg("fusedOps",t,e,n),a="biasadd"===s,i="prelu"===r,o=wg("numArgs",t,e,n);if(a){if(i&&2!==o)throw new Error("Fused MatMul with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!i&&1!==o)throw new Error("Fused MatMul with BiasAdd must have one extra argument: bias.")}const[l,u]=wg("args",t,e,n);return[Lo({a:wg("a",t,e,n),b:wg("b",t,e,n),transposeA:wg("transposeA",t,e,n),transposeB:wg("transposeB",t,e,n),bias:l,activation:r,preluActivationWeights:u})];default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"normalization":return Jn(()=>((t,e,n)=>{switch(t.op){case"FusedBatchNorm":case"FusedBatchNormV2":case"FusedBatchNormV3":return[Zs(wg("x",t,e,n),wg("mean",t,e,n),wg("variance",t,e,n),wg("offset",t,e,n),wg("scale",t,e,n),wg("epsilon",t,e,n))];case"LRN":return[na(wg("x",t,e,n),wg("radius",t,e,n),wg("bias",t,e,n),wg("alpha",t,e,n),wg("beta",t,e,n))];case"Softmax":return[Di(wg("x",t,e,n))];case"LogSoftmax":return[fa(wg("x",t,e,n))];case"SparseToDense":return[ko(wg("sparseIndices",t,e,n),wg("outputShape",t,e,n),wg("sparseValues",t,e,n),wg("defaultValue",t,e,n))];default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"reduction":return Jn(()=>((t,e,n)=>{switch(t.op){case"Max":{const s=wg("axis",t,e,n),r=wg("keepDims",t,e,n);return[ha(wg("x",t,e,n),s,r)]}case"Mean":{const s=wg("axis",t,e,n),r=wg("keepDims",t,e,n);return[Ca(wg("x",t,e,n),s,r)]}case"Min":{const s=wg("axis",t,e,n),r=wg("keepDims",t,e,n);return[Sa(wg("x",t,e,n),s,r)]}case"Sum":{const s=wg("axis",t,e,n),r=wg("keepDims",t,e,n);return[da(wg("x",t,e,n),s,r)]}case"All":{const s=wg("axis",t,e,n),r=wg("keepDims",t,e,n);return[xs(wg("x",t,e,n),s,r)]}case"Any":{const s=wg("axis",t,e,n),r=wg("keepDims",t,e,n);return[ws(wg("x",t,e,n),s,r)]}case"ArgMax":{const s=wg("axis",t,e,n);return[vs(wg("x",t,e,n),s)]}case"ArgMin":{const s=wg("axis",t,e,n);return[ks(wg("x",t,e,n),s)]}case"Prod":{const s=wg("axis",t,e,n),r=wg("keepDims",t,e,n);return[qa(wg("x",t,e,n),s,r)]}case"Cumsum":{const s=wg("axis",t,e,n),r=wg("exclusive",t,e,n),a=wg("reverse",t,e,n);return[br(wg("x",t,e,n),s,r,a)]}default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"slice_join":return Jn(()=>((t,e,n)=>{switch(t.op){case"ConcatV2":case"Concat":{const s=wg("n",t,e,n),r=wg("axis",t,e,n);let a=wg("tensors",t,e,n);return a=a.slice(0,s),[Hs(a,r)]}case"GatherV2":case"Gather":{const s=wg("axis",t,e,n),r=wg("x",t,e,n),a=wg("indices",t,e,n);return[Ur(r,Ve(a,"int32"),s)]}case"ReverseV2":case"Reverse":{const s=wg("axis",t,e,n),r=wg("x",t,e,n);return[mi(r,s)]}case"Slice":{const s=wg("begin",t,e,n),r=wg("size",t,e,n);return[qs(wg("x",t,e,n),s,r)]}case"StridedSlice":{const s=wg("begin",t,e,n),r=wg("end",t,e,n),a=wg("strides",t,e,n),i=wg("beginMask",t,e,n),o=wg("endMask",t,e,n),l=wg("ellipsisMask",t,e,n),u=wg("newAxisMask",t,e,n),c=wg("shrinkAxisMask",t,e,n),h=wg("x",t,e,n);return[Gi(h,s,r,a,i,o,l,u,c)]}case"Pack":return Jn(()=>{const s=wg("axis",t,e,n),r=wg("tensors",t,e,n),a=r[0].shape,i=Wi(r[0]).shape,o=r.map(t=>{const e=d(t.shape,a);if(!e&&!d(Wi(t).shape,i))throw new Error("the input tensors shape does not match");return e?t:on(t,a)});return[Vi(o,s)]});case"Unpack":{const s=wg("axis",t,e,n),r=wg("tensor",t,e,n);return Zi(r,s)}case"Tile":{const s=wg("reps",t,e,n);return[Mr(wg("x",t,e,n),s)]}case"Split":case"SplitV":{const s=wg("axis",t,e,n),r=wg("numOrSizeSplits",t,e,n),a=wg("x",t,e,n);return Li(a,r,s)}case"ScatterNd":{const s=wg("indices",t,e,n),r=wg("values",t,e,n),a=wg("shape",t,e,n);return[vo(s,r,a)]}case"GatherNd":{const s=wg("x",t,e,n),r=wg("indices",t,e,n);return[No(s,r)]}case"SparseToDense":{const s=wg("sparseIndices",t,e,n),r=wg("outputShape",t,e,n),a=wg("sparseValues",t,e,n),i=wg("defaultValue",t,e,n);return[ko(s,a,r,a.dtype===i.dtype?i:Ve(i,a.dtype))]}default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"spectral":return Jn(()=>((t,e,n)=>{switch(t.op){case"FFT":return[_i(wg("x",t,e,n))];case"IFFT":return[Fi(wg("x",t,e,n))];case"RFFT":return[zi(wg("x",t,e,n))];case"IRFFT":return[Oi(wg("x",t,e,n))];default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"transformation":return Jn(()=>((t,e,n)=>{switch(t.op){case"Cast":return[Ve(wg("x",t,e,n),wg("dtype",t,e,n))];case"ExpandDims":{const s=wg("axis",t,e,n);return[Fr(wg("x",t,e,n),s)]}case"Squeeze":{const s=wg("axis",t,e,n);return[Wi(wg("x",t,e,n),s)]}case"Reshape":return[on(wg("x",t,e,n),wg("shape",t,e,n))];case"MirrorPad":return[Ea(wg("x",t,e,n),wg("padding",t,e,n),wg("mode",t,e,n))];case"PadV2":case"Pad":return[za(wg("x",t,e,n),wg("padding",t,e,n),wg("constantValue",t,e,n))];case"SpaceToBatchND":{const s=wg("blockShape",t,e,n),r=wg("paddings",t,e,n);return[Ua(wg("x",t,e,n),s,r)]}case"BatchToSpaceND":{const s=wg("blockShape",t,e,n),r=wg("crops",t,e,n);return[Ys(wg("x",t,e,n),s,r)]}case"DepthToSpace":{const s=wg("blockSize",t,e,n),r=wg("dataFormat",t,e,n).toUpperCase();return[xr(wg("x",t,e,n),s,r)]}case"BroadcastTo":return[nr(wg("x",t,e,n),wg("shape",t,e,n))];default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n));case"hash_table":return(async(t,e,n,s)=>{switch(t.op){case"HashTable":case"HashTableV2":{const r=wg("keyDType",t,e,n),a=wg("valueDType",t,e,n),i=new py(r,a);return s.addHashTable(t.name,i),[i.handle]}case"LookupTableImport":case"LookupTableImportV2":{const r=wg("tableHandle",t,e,n,s),a=wg("keys",t,e,n),i=wg("values",t,e,n),o=s.getHashTableById(r.id);return[await o.import(a,i)]}case"LookupTableFind":case"LookupTableFindV2":{const r=wg("tableHandle",t,e,n,s),a=wg("keys",t,e,n),i=wg("defaultValue",t,e,n),o=s.getHashTableById(r.id);return[await o.find(a,i)]}default:throw TypeError(`Node type ${t.op} is not implemented`)}})(t,e,n,s);case"custom":const r=xg(t.op);if(r&&r.customExecutor)return r.customExecutor(new ay(t,e,n));throw TypeError(`Custom op ${t.op} is not registered.`);default:throw TypeError(`Unknown op '${t.op}'. File an issue at https://github.com/tensorflow/tfjs/issues so we can add it, or register a custom execution with tf.registerOp()`)}})(t,e,n);return U(r)?r.then(t=>[].concat(t)):[].concat(r)}class fy{constructor(t={},e={},n={},s={}){this.weightMap=t,this.tensorArrayMap=e,this.tensorListMap=n,this.functionMap=s,this.rootContext={id:0,frameName:"",iterationId:0},this.contexts=[this.rootContext],this.lastId=0,this.generateCurrentContextIds()}newFrame(t,e){return{id:t,frameName:e,iterationId:0}}set currentContext(t){this.contexts!==t&&(this.contexts=t,this.generateCurrentContextIds())}get currentContext(){return this.contexts}get currentContextId(){return this._currentContextIds[0]}get currentContextIds(){return this._currentContextIds}generateCurrentContextIds(){const t=[];for(let e=0;e<this.contexts.length-1;e++){const n=this.contexts.slice(0,this.contexts.length-e);t.push(this.contextIdforContexts(n))}t.push(""),this._currentContextIds=t}contextIdforContexts(t){return t?t.map(t=>0===t.id&&0===t.iterationId?"":`${t.frameName}-${t.iterationId}`).join("/"):""}enterFrame(t){this.contexts&&(this.lastId++,this.contexts=this.contexts.slice(),this.contexts.push(this.newFrame(this.lastId,t)),this._currentContextIds.unshift(this.contextIdforContexts(this.contexts)))}exitFrame(){if(!(this.contexts&&this.contexts.length>1))throw new Error("Cannot exit frame, the context is empty");this.contexts=this.contexts.slice(),this.contexts.splice(-1),this.currentContextIds.shift()}nextIteration(){if(!(this.contexts&&this.contexts.length>0))throw new Error("Cannot increase frame iteration, the context is empty");{this.contexts=this.contexts.slice(),this.lastId++;const t=Object.assign({},this.contexts[this.contexts.length-1]);t.iterationId+=1,t.id=this.lastId,this.contexts.splice(-1,1,t),this._currentContextIds.splice(0,1,this.contextIdforContexts(this.contexts))}}getWeight(t){return this.weightMap[t]}addTensorArray(t){this.tensorArrayMap[t.id]=t}getTensorArray(t){return this.tensorArrayMap[t]}addTensorList(t){this.tensorListMap[t.id]=t}getTensorList(t){return this.tensorListMap[t]}dispose(t){for(const e in this.tensorArrayMap)this.tensorArrayMap[e].clearAndClose(t);for(const e in this.tensorListMap)this.tensorListMap[e].clearAndClose(t)}}function my(t,e,n,s){const r=new Set,a=[];let i=null,o=null;const l=new Set,u=Object.keys(t).map(t=>Ig(t)[0]);let c=[];null!=s&&(c=s.map(t=>Ig(t.name)[0]));const h=[...e];for(;h.length>0;){const t=h.pop();(xy(t)||wy(t)||vy(t))&&null==i&&(i=t,o=i.children.map(t=>t.name).filter(t=>r.has(t))),r.add(t.name),null==n[t.name]&&(-1===u.indexOf(t.name)&&-1===c.indexOf(t.name)&&(0!==t.inputs.length?t.inputs.forEach(t=>{l.has(t.name)||(l.add(t.name),h.push(t))}):a.push(t.name)))}return{inputs:t,outputs:e,usedNodes:r,missingInputs:a,dynamicNode:i,syncInputs:o}}const gy=["Switch","Merge","Enter","Exit","NextIteration","StatelessIf","StatelessWhile","if","While"],yy=["NonMaxSuppressionV2","NonMaxSuppressionV3","NonMaxSuppressionV5","Where"],by=["HashTable","HashTableV2","LookupTableImport","LookupTableImportV2","LookupTableFind","LookupTableFindV2"];function xy(t){return gy.indexOf(t.op)>=0}function wy(t){return yy.indexOf(t.op)>=0}function vy(t){return by.indexOf(t.op)>=0}class ky{constructor(t,e){this.graph=t,this.parent=e,this.compiledMap=new Map,this._weightMap={},this.SEPERATOR=",",this._functions={},this._functionExecutorMap={},this._outputs=t.outputs,this._inputs=t.inputs,this._initNodes=t.initNodes,this._signature=t.signature,this._functions=t.functions,null!=t.functions&&Object.keys(t.functions).forEach(e=>{this._functionExecutorMap[e]=new ky(t.functions[e],this)})}get weightIds(){return this.parent?this.parent.weightIds:this._weightIds}get functionExecutorMap(){return this.parent?this.parent.functionExecutorMap:this._functionExecutorMap}get weightMap(){return this.parent?this.parent.weightMap:this._weightMap}set weightMap(t){const e=Object.keys(t).map(e=>t[e].map(t=>t.id));this._weightIds=[].concat(...e),this._weightMap=t}set resourceManager(t){this._resourceManager=t}get inputs(){return this._inputs.map(t=>({name:t.name,shape:t.attrParams.shape?t.attrParams.shape.value:void 0,dtype:t.attrParams.dtype?t.attrParams.dtype.value:void 0}))}get outputs(){return this._outputs.map(t=>({name:t.name,shape:t.attrParams.shape?t.attrParams.shape.value:void 0,dtype:t.attrParams.dtype?t.attrParams.dtype.value:void 0}))}get inputNodes(){return this._inputs.map(t=>t.signatureKey||t.name)}get outputNodes(){return this._outputs.map(t=>{const e=t.signatureKey||t.name;return t.defaultOutput?`${e}:${t.defaultOutput}`:e})}get functions(){return Object.keys(this._functions).reduce((t,e)=>(t[e]=this._functions[e].signature,t),{})}getCompilationKey(t,e){const n=t.map(t=>t.name).sort(),s=e.map(t=>t.name).sort();return n.join(this.SEPERATOR)+"--"+s.join(this.SEPERATOR)}compile(t,e){const n=my(t,e,this.weightMap,this._initNodes),{missingInputs:s,dynamicNode:r,syncInputs:a}=n;if(null!=r)throw new Error(`This execution contains the node '${r.name}', which has the dynamic op '${r.op}'. Please use model.executeAsync() instead. Alternatively, to avoid the dynamic ops, specify the inputs [${a}]`);if(s.length>0){const n=e.map(t=>t.name),r=Object.keys(t);throw new Error(`Cannot compute the outputs [${n}] from the provided inputs [${r}]. Missing the following inputs: [${s}]`)}return function(t,e,n){const{usedNodes:s,inputs:r}=n,a=[],i=Object.keys(r).map(t=>Ig(t)[0]).map(e=>t.nodes[e]),o=t.initNodes;i.forEach(t=>{s.has(t.name)&&a.push(t)}),t.weights.forEach(t=>{s.has(t.name)&&a.push(t)}),null!=o&&o.forEach(t=>{s.has(t.name)&&a.push(t)});const l=new Set,u=[];for(;a.length>0;){const t=a.pop();l.add(t.name),e[t.name]||u.push(t),t.children.forEach(t=>{!l.has(t.name)&&s.has(t.name)&&t.inputs.every(t=>l.has(t.name))&&a.push(t)})}return u}(this.graph,this.weightMap,n)}execute(t,e){t=this.mapInputs(t);const n=Object.keys(t).sort();this.checkInputs(t),this.checkInputShapeAndType(t),e=this.mapOutputs(e),this.checkOutputs(e);const s=n.map(t=>this.graph.nodes[Ig(t)[0]]),r=e.map(t=>Ig(t)[0]);let a=r.map(t=>this.graph.nodes[t]);0===a.length&&(a=this._outputs);const i=this.getCompilationKey(s,a);let o=this.compiledMap.get(i);null==o&&(o=this.compile(t,a),this.compiledMap.set(i,o));const l={},u={};return Jn(()=>{const n=new fy(this.weightMap,l,u,this.functionExecutorMap),s=Object.assign({},this.weightMap);Object.keys(t).forEach(e=>{const[n,r]=Ig(e),a=[];a[r]=t[e],s[n]=a});const a=this.getFrozenTensorIds(s),i={};for(let t=0;t<o.length;t++){const e=o[t];if(!s[e.name]){const t=dy(e,s,n,this._resourceManager);if(U(t))throw new Error(`The execution of the op '${e.op}' returned a promise. Please use model.executeAsync() instead.`);s[e.name]=t,this.checkTensorForDisposal(e.name,e,s,n,a,r,i)}}return null==this.parent&&n.dispose(a),e.map(t=>vg(t,s,n))})}getFrozenTensorIds(t){const e=[].concat.apply([],Object.keys(t).map(e=>t[e]).map(t=>t.map(t=>t.id)));return new Set(e)}checkTensorForDisposal(t,e,n,s,r,a,i){"control"!==e.category&&-1===a.indexOf(t)&&(n[t].forEach(t=>{null!=t&&(i[t.id]=(i[t.id]||0)+e.children.length)}),e.inputs.forEach(t=>{if("control"!==t.category){const e=function(t,e,n){return e[Ng(t,n.currentContextId)]}(t.name,n,s);null!=e&&e.forEach(t=>{if(t&&!r.has(t.id)){const e=i[t.id];1===e?(t.dispose(),delete i[t.id]):null!=e&&i[t.id]--}})}}))}async executeAsync(t,e){return this._executeAsync(t,e)}async _executeAsync(t,e,n=!1,s={},r={}){n||(t=this.mapInputs(t),this.checkInputs(t),this.checkInputShapeAndType(t),e=this.mapOutputs(e),this.checkOutputs(e));const a=new fy(this.weightMap,s,r,this.functionExecutorMap),i=await this.executeWithControlFlow(t,a,e,n),o=e.map(t=>vg(t,i,a)),l=o.map(t=>t.id),u=Object.keys(t).map(e=>t[e].id),c=new Set([...l,...u,...this.weightIds]);return Object.keys(i).forEach(t=>{i[t].forEach(t=>{!t||t.isDisposed||c.has(t.id)||t.dispose()})}),null==this.parent&&a.dispose(c),o}async executeFunctionAsync(t,e,n){const s=t.reduce((t,e,n)=>(t[this.inputs[n].name]=e,t),{});return this._executeAsync(s,this.outputNodes,!0,e,n)}async executeWithControlFlow(t,e,n,s){const r=Object.keys(t),a=r.map(t=>this.graph.nodes[Ig(t)[0]]),i=n.map(t=>Ig(t)[0]);let o=i.map(t=>this.graph.nodes[t]);0===o.length&&(o=this._outputs);const{usedNodes:l,missingInputs:u,dynamicNode:c,syncInputs:h}=my(t,o,this.weightMap,this._initNodes),p=[...a,...this.graph.weights,...this._initNodes||[]].map(t=>({node:t,contexts:e.currentContext})),d=Object.assign({},this.weightMap);Object.keys(t).forEach(e=>{const[n,s]=Ig(e),r=[];r[s]=t[e],d[n]=r});const f={},m=this.getFrozenTensorIds(d),g={};for(;p.length>0;){const t=this.processStack(a,p,e,d,g,m,i,f,l);await Promise.all(t)}null!=c||s||console.warn("This model execution did not contain any nodes with control flow or dynamic output shapes. You can use model.execute() instead.");const y=o.filter(t=>!xy(t)&&!vg(t.name,d,e)).map(t=>t.name);if(y.length>0){let t="";throw null!=c&&(t=`Alternatively, to avoid the dynamic ops, use model.execute() and specify the inputs [${h}]`),new Error(`Cannot compute the outputs [${y}] from the provided inputs [${r}]. Consider providing the following inputs: [${u}]. ${t}`)}return d}processStack(t,e,n,s,r,a,i,o,l){const u=[];for(;e.length>0;){const t=e.pop();n.currentContext=t.contexts;let c="";if("Enter"===t.node.op&&wg("isConstant",t.node,s,n)&&([c]=kg(t.node.name,n)),null==s[t.node.name]){const h=dy(t.node,s,n,this._resourceManager);c||([c]=kg(t.node.name,n));const p=n.currentContext;U(h)?u.push(h.then(u=>(s[c]=u,n.currentContext=p,this.checkTensorForDisposal(c,t.node,s,n,a,i,o),this.processChildNodes(t.node,e,n,s,r,l),u))):(s[c]=h,this.checkTensorForDisposal(c,t.node,s,n,a,i,o),this.processChildNodes(t.node,e,n,s,r,l))}else this.processChildNodes(t.node,e,n,s,r,l)}return u}processChildNodes(t,e,n,s,r,a){t.children.forEach(t=>{const[i]=kg(t.name,n);!r[i]&&a.has(t.name)&&("Merge"===t.op?t.inputNames.some(t=>!!vg(t,s,n))&&(r[i]=!0,e.push({contexts:n.currentContext,node:t})):t.inputNames.every(t=>!!vg(t,s,n))&&(r[i]=!0,e.push({contexts:n.currentContext,node:t})))})}dispose(){Object.keys(this.weightMap).forEach(t=>this.weightMap[t].forEach(t=>t.dispose()))}checkInputShapeAndType(t){Object.keys(t).forEach(e=>{const n=t[e],[s]=Ig(e),r=this.graph.nodes[s];if(r.attrParams.shape&&r.attrParams.shape.value){const t=r.attrParams.shape.value;l(t.length===n.shape.length&&n.shape.every((e,n)=>-1===t[n]||t[n]===e),()=>`The shape of dict['${r.name}'] provided in model.execute(dict) must be [${t}], but was [${n.shape}]`)}r.attrParams.dtype&&r.attrParams.dtype.value&&l(n.dtype===r.attrParams.dtype.value,()=>`The dtype of dict['${r.name}'] provided in model.execute(dict) must be ${r.attrParams.dtype.value}, but was ${n.dtype}`)})}mapInputs(t){const e={};for(const n in t)if(null!=this._signature&&null!=this._signature.inputs&&null!=this._signature.inputs[n]){e[this._signature.inputs[n].name]=t[n]}else e[n]=t[n];return e}checkInputs(t){const e=Object.keys(t).filter(t=>{const[e]=Ig(t);return null==this.graph.nodes[e]});if(e.length>0)throw new Error(`The dict provided in model.execute(dict) has keys: [${e}] that are not part of graph`)}mapOutputs(t){return t.map(t=>{if(null!=this._signature&&null!=this._signature.outputs&&null!=this._signature.outputs[t]){return this._signature.outputs[t].name}return t},{})}checkOutputs(t){t.forEach(t=>{const[e]=Ig(t);if(!this.graph.nodes[e])throw new Error(`The output '${t}' is not found in the graph`)})}}class Ny{constructor(t={},e={}){this.hashTableNameToHandle=t,this.hashTableMap=e}addHashTable(t,e){this.hashTableNameToHandle[t]=e.handle,this.hashTableMap[e.id]=e}getHashTableHandleByName(t){return this.hashTableNameToHandle[t]}getHashTableById(t){return this.hashTableMap[t]}dispose(){for(const t in this.hashTableMap)this.hashTableMap[t].clearAndClose(),delete this.hashTableMap[t];for(const t in this.hashTableNameToHandle)this.hashTableNameToHandle[t].dispose(),delete this.hashTableNameToHandle[t]}}class Iy{constructor(t,e={}){this.modelUrl=t,this.loadOptions=e,this.version="n/a",null==e&&(this.loadOptions={}),this.resourceManager=new Ny}get modelVersion(){return this.version}get inputNodes(){return this.executor.inputNodes}get outputNodes(){return this.executor.outputNodes}get inputs(){return this.executor.inputs}get outputs(){return this.executor.outputs}get weights(){return this.executor.weightMap}findIOHandler(){const t=this.modelUrl;if(null!=t.load)this.handler=t;else if(null!=this.loadOptions.requestInit)this.handler=nn(t,this.loadOptions);else{const e=ye(t,this.loadOptions);if(0===e.length)e.push(nn(t,this.loadOptions));else if(e.length>1)throw new Error(`Found more than one (${e.length}) load handlers for URL '${[t]}'`);this.handler=e[0]}}async load(){if(this.findIOHandler(),null==this.handler.load)throw new Error("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const t=await this.handler.load();return this.loadSync(t)}loadSync(t){this.artifacts=t;const e=this.artifacts.modelTopology;let n={};null!=this.artifacts.userDefinedMetadata&&(n=this.artifacts.userDefinedMetadata.signature),this.version=`${e.versions.producer}.${e.versions.minConsumer}`;const s=oe(this.artifacts.weightData,this.artifacts.weightSpecs);if(this.executor=new ky(Gg.Instance.transformGraph(e,n)),this.executor.weightMap=this.convertTensorMapToTensorsMap(s),this.executor.resourceManager=this.resourceManager,null!=t.modelInitializer){const e=Gg.Instance.transformGraph(t.modelInitializer);this.initializer=new ky(e),this.initializer.weightMap=this.executor.weightMap,this.initializer.resourceManager=this.resourceManager,this.initializer.executeAsync({},[])}return!0}async save(t,e){if("string"==typeof t){const e=ge(t);if(0===e.length)throw new Error(`Cannot find any save handlers for URL '${t}'`);if(e.length>1)throw new Error(`Found more than one (${e.length}) save handlers for URL '${t}'`);t=e[0]}if(null==t.save)throw new Error("GraphModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");return t.save(this.artifacts)}predict(t,e){return this.execute(t,this.outputNodes)}normalizeInputs(t){if(!(t instanceof Tt||Array.isArray(t)))return t;if((t=Array.isArray(t)?t:[t]).length!==this.inputNodes.length)throw new Error(`Input tensor count mismatch,the graph model has ${this.inputNodes.length} placeholders, while there are ${t.length} input tensors.`);return this.inputNodes.reduce((e,n,s)=>(e[n]=t[s],e),{})}normalizeOutputs(t){return t=t||this.outputNodes,Array.isArray(t)?t:[t]}execute(t,e){t=this.normalizeInputs(t),e=this.normalizeOutputs(e);const n=this.executor.execute(t,e);return n.length>1?n:n[0]}async executeAsync(t,e){t=this.normalizeInputs(t),e=this.normalizeOutputs(e);const n=await this.executor.executeAsync(t,e);return n.length>1?n:n[0]}convertTensorMapToTensorsMap(t){return Object.keys(t).reduce((e,n)=>(e[n]=[t[n]],e),{})}dispose(){this.executor.dispose(),this.initializer&&this.initializer.dispose(),this.resourceManager.dispose()}}function Cy(t,e,n=new Map,s=new Set){if(null==t)return null;if(s.has(t))throw new Error("Circular references are not supported.");if(n.has(t))return n.get(t);const r=e(t);if(r.recurse&&null!==r.value)throw new Error("A deep map function may not return both a value and recurse=true.");if(r.recurse){if($y(t)){const r=Array.isArray(t)?[]:{};s.add(t);for(const a in t){const i=Cy(t[a],e,n,s);r[a]=i}return s.delete(t),r}throw new Error("Can't recurse into non-iterable type: "+t)}return n.set(t,r.value),r.value}function Sy(t,e=Ty){return function t(e,n,s=new Set){const r=e[0];if(s.has(r))throw new Error("Circular references are not supported.");const a=n(e);if(a.recurse&&null!==a.value)throw new Error("A deep zip function may not return both a value and recurse=true.");if(a.recurse){if($y(r)){const a=Array.isArray(r)?[]:{};s.add(r);for(const i in r){const r=e.map(t=>t[i]),o=t(r,n,s);a[i]=o}return s.delete(r),a}throw new Error("Can't recurse into non-iterable type: "+r)}return a.value}(t,e)}function Ty(t){return null===t?null:$y(t[0])?{value:null,recurse:!0}:{value:t,recurse:!1}}async function Ey(t,e){const n=new Map;Cy(t,e,n);for(const t of Array.from(n.keys())){const e=n.get(t);if(U(e)){const s=await e;n.set(t,s)}}return Cy(t,e,n)}function $y(t){return null!=t&&!ArrayBuffer.isView(t)&&(Array.isArray(t)||"object"==typeof t&&!(t instanceof Tt))}function Ay(t){return function(t,e){return Cy(t,e)}(t,Ry)}function Ry(t){return t instanceof Tt?{value:t.clone(),recurse:!1}:$y(t)?{value:null,recurse:!0}:{value:t,recurse:!1}}class Dy{constructor(t){if(this.capacity=t,this.begin=0,this.end=0,null==t)throw new RangeError("Can't create a ring buffer of unknown capacity.");if(t<1)throw new RangeError("Can't create ring buffer of capacity < 1.");this.data=new Array(t),this.doubledCapacity=2*t}wrap(t){for(;t<0;)t+=this.doubledCapacity;return t%this.doubledCapacity}get(t){if(t<0)throw new RangeError("Can't get item at a negative index.");return this.data[t%this.capacity]}set(t,e){if(t<0)throw new RangeError("Can't set item at a negative index.");this.data[t%this.capacity]=e}length(){let t=this.end-this.begin;return t<0&&(t=this.doubledCapacity+t),t}isFull(){return this.length()===this.capacity}isEmpty(){return 0===this.length()}push(t){if(this.isFull())throw new RangeError("Ring buffer is full.");this.set(this.end,t),this.end=this.wrap(this.end+1)}pushAll(t){for(const e of t)this.push(e)}pop(){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");this.end=this.wrap(this.end-1);const t=this.get(this.end);return this.set(this.end,void 0),t}unshift(t){if(this.isFull())throw new RangeError("Ring buffer is full.");this.begin=this.wrap(this.begin-1),this.set(this.begin,t)}shift(){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");const t=this.get(this.begin);return this.set(this.begin,void 0),this.begin=this.wrap(this.begin+1),t}shuffleExcise(t){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");const e=this.wrap(this.begin+t),n=this.get(e);return this.set(e,this.pop()),n}}class _y extends Dy{constructor(){super(_y.INITIAL_CAPACITY)}isFull(){return!1}push(t){super.isFull()&&this.expand(),super.push(t)}unshift(t){super.isFull()&&this.expand(),super.unshift(t)}expand(){const t=2*this.capacity,e=new Array(t),n=this.length();for(let t=0;t<n;t++)e[t]=this.get(this.wrap(this.begin+t));this.data=e,this.capacity=t,this.doubledCapacity=2*this.capacity,this.begin=0,this.end=n}}function Fy(t){return new zy(t)}function Oy(t){return new By(t)}function My(t,e){return new Yy(t,e)}_y.INITIAL_CAPACITY=32;class Ly{async toArray(){const t=[];let e=await this.next();for(;!e.done;)t.push(e.value),e=await this.next();return t}async toArrayForTest(){const t=this.prefetch(100),e=[];let n=await t.next();for(;!n.done;)e.push(n.value),n=await t.next();return e}async resolveFully(){let t=await this.next();for(;!t.done;)t=await this.next()}async resolveWhile(t){let e=await this.next(),n=t(e.value);for(;!e.done&&n;)e=await this.next(),n=t(e.value)}handleErrors(t){return new jy(this,t)}filter(t){return new Gy(this,t)}map(t){return new Hy(this,t)}mapAsync(t){return new qy(this,t)}serialMapAsync(t){return new qy(this,t).serial()}flatmap(t){return new Xy(this,t)}async forEachAsync(t){return this.map(t).resolveFully()}async serialForEach(t){return this.serialMapAsync(t).resolveWhile(t=>!0===t)}rowMajorBatch(t,e=!0){return new Uy(this,t,e)}columnMajorBatch(t,e=!0,n=Ty){return this.rowMajorBatch(t,e).map(t=>Sy(t,n))}concatenate(t,e){return new Yy(Fy([this,t]),e)}take(t){return t<0||null==t?this:new Vy(this,t)}skip(t){return t<0||null==t?this:new Wy(this,t)}prefetch(t){return new Qy(this,t)}shuffle(t,e){return new tb(this,t,e)}serial(){return new Py(this)}}class zy extends Ly{constructor(t){super(),this.items=t,this.trav=0}summary(){return`Array of ${this.items.length} items`}async next(){if(this.trav>=this.items.length)return{value:null,done:!0};const t=this.items[this.trav];return this.trav++,{value:Ay(t),done:!1}}}class By extends Ly{constructor(t){super(),this.nextFn=t}summary(){return"Function call"}async next(){try{return this.nextFn()}catch(t){throw t.message="Error thrown while iterating through a dataset: "+t.message,t}}}class Py extends Ly{constructor(t){super(),this.upstream=t,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> Serial"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){return this.upstream.next()}}class Wy extends Ly{constructor(t,e){super(),this.upstream=t,this.maxCount=e,this.count=0,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> Skip"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){for(;this.count++<this.maxCount;){const t=await this.upstream.next();if(t.done)return t;Zn(t.value)}return this.upstream.next()}}class Vy extends Ly{constructor(t,e){super(),this.upstream=t,this.maxCount=e,this.count=0}summary(){return this.upstream.summary()+" -> Take"}async next(){return this.count++>=this.maxCount?{value:null,done:!0}:this.upstream.next()}}class Uy extends Ly{constructor(t,e,n=!0){super(),this.upstream=t,this.batchSize=e,this.enableSmallLastBatch=n,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> RowMajorBatch"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){const t=[];for(;t.length<this.batchSize;){const e=await this.upstream.next();if(e.done)return this.enableSmallLastBatch&&t.length>0?{value:t,done:!1}:{value:null,done:!0};t.push(e.value)}return{value:t,done:!1}}}class Gy extends Ly{constructor(t,e){super(),this.upstream=t,this.predicate=e,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> Filter"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){for(;;){const t=await this.upstream.next();if(t.done||this.predicate(t.value))return t;Zn(t.value)}}}class Hy extends Ly{constructor(t,e){super(),this.upstream=t,this.transform=e}summary(){return this.upstream.summary()+" -> Map"}async next(){const t=await this.upstream.next();if(t.done)return{value:null,done:!0};const e=Pt(t.value),n=this.transform(t.value),s=Pt(n);for(const t of e)Bt(t,s)||t.dispose();return{value:n,done:!1}}}class jy extends Ly{constructor(t,e){super(),this.upstream=t,this.handler=e,this.count=0,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> handleErrors"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){for(;;)try{return await this.upstream.next()}catch(t){if(!this.handler(t))return{value:null,done:!0}}}}class qy extends Ly{constructor(t,e){super(),this.upstream=t,this.transform=e}summary(){return this.upstream.summary()+" -> AsyncMap"}async next(){const t=await this.upstream.next();if(t.done)return{value:null,done:!0};const e=Pt(t.value),n=await this.transform(t.value),s=Pt(n);for(const t of e)Bt(t,s)||t.dispose();return{value:n,done:!1}}}class Ky extends Ly{constructor(){super(),this.outputQueue=new _y,this.lastRead=Promise.resolve({value:null,done:!1})}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){for(;0===this.outputQueue.length();)if(!await this.pump())return{value:null,done:!0};return{value:this.outputQueue.shift(),done:!1}}}class Xy extends Ky{constructor(t,e){super(),this.upstream=t,this.transform=e}summary(){return this.upstream.summary()+" -> Flatmap"}async pump(){const t=await this.upstream.next();if(t.done)return!1;const e=Pt(t.value),n=this.transform(t.value),s=Pt(n);this.outputQueue.pushAll(n);for(const t of e)Bt(t,s)||t.dispose();return!0}}class Yy extends Ly{constructor(t,e){super(),this.baseErrorHandler=e,this.lastRead=null,this.iterator=null,this.moreIterators=t}summary(){return"TODO: fill in upstream of chained summaries -> Chained"}async next(){return this.lastRead=this.readFromChain(this.lastRead),this.lastRead}async readFromChain(t){if(await t,null==this.iterator){const t=await this.moreIterators.next();if(t.done)return{value:null,done:!0};this.iterator=t.value,null!=this.baseErrorHandler&&(this.iterator=this.iterator.handleErrors(this.baseErrorHandler))}const e=await this.iterator.next();return e.done?(this.iterator=null,this.readFromChain(t)):e}}var Jy;!function(t){t[t.FAIL=0]="FAIL",t[t.SHORTEST=1]="SHORTEST",t[t.LONGEST=2]="LONGEST"}(Jy||(Jy={}));class Zy extends Ly{constructor(t,e=Jy.FAIL){super(),this.iterators=t,this.mismatchMode=e,this.count=0,this.currentPromise=null}summary(){return"{TODO: fill in upstream of zip summaries} -> Zip"}async nextState(t){await t;let e=0,n=0;const s=await Ey(this.iterators,(function(t){if(t instanceof Ly){return{value:t.next().then(t=>(e++,t.done&&n++,t.value)),recurse:!1}}return{value:null,recurse:!0}}));if(e===n)return{value:null,done:!0};if(n>0)switch(this.mismatchMode){case Jy.FAIL:throw new Error(`Zipped streams should have the same length. Mismatched at element ${this.count}.`);case Jy.SHORTEST:return{value:null,done:!0};case Jy.LONGEST:}return this.count++,{value:s,done:!1}}async next(){return this.currentPromise=this.nextState(this.currentPromise),this.currentPromise}}class Qy extends Ly{constructor(t,e){super(),this.upstream=t,this.bufferSize=e,this.buffer=new Dy(e)}summary(){return this.upstream.summary()+" -> Prefetch"}refill(){for(;!this.buffer.isFull();){const t=this.upstream.next();this.buffer.push(t)}}next(){return this.refill(),this.buffer.shift()}}class tb extends Qy{constructor(t,e,n){super(t,e),this.upstream=t,this.windowSize=e,this.upstreamExhausted=!1,this.random=si(n||ht().toString()),this.lastRead=Promise.resolve({value:null,done:!1})}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}randomInt(t){return Math.floor(this.random()*t)}chooseIndex(){return this.randomInt(this.buffer.length())}async serialNext(){for(this.upstreamExhausted||this.refill();!this.buffer.isEmpty();){const t=this.chooseIndex(),e=await this.buffer.shuffleExcise(t);if(!e.done)return this.refill(),e;this.upstreamExhausted=!0}return{value:null,done:!0}}}class eb{constructor(){this.size=null}batch(t,e=!0){const n=this;let s;return l(t>0,()=>"batchSize needs to be positive, but it is\n      "+t),s=this.size===1/0||null==this.size?this.size:e?Math.ceil(this.size/t):Math.floor(this.size/t),nb(async()=>(await n.iterator()).columnMajorBatch(t,e,sb),s)}concatenate(t){const e=this;let n;return n=this.size===1/0||t.size===1/0?1/0:null!=this.size&&null!=t.size?this.size+t.size:null,nb(async()=>(await e.iterator()).concatenate(await t.iterator()),n)}filter(t){const e=this;let n;return n=this.size===1/0?1/0:null,nb(async()=>(await e.iterator()).filter(e=>Jn(()=>t(e))),n)}async forEachAsync(t){return(await this.iterator()).forEachAsync(t)}map(t){const e=this;return nb(async()=>(await e.iterator()).map(e=>Jn(()=>t(e))),this.size)}mapAsync(t){const e=this;return nb(async()=>(await e.iterator()).mapAsync(t),this.size)}prefetch(t){if(null==t)throw new RangeError("`Dataset.prefetch()` requires bufferSize to be specified.");const e=this;return nb(async()=>(await e.iterator()).prefetch(t),this.size)}repeat(t){const e=this;let n;return n=null!=this.size&&t>0?this.size*t:0===t?0:null!=this.size&&(void 0===t||t<0)?1/0:null,nb(async()=>My(Oy(async()=>({value:await e.iterator(),done:!1})).take(t)),n)}skip(t){const e=this;let n;return n=null!=this.size&&t>=0&&this.size>=t?this.size-t:null!=this.size&&(this.size<t||void 0===t||t<0)?0:null,nb(async()=>(await e.iterator()).skip(t),n)}shuffle(t,e,n=!0){if(null==t||t<0)throw null==this.size?new RangeError("`Dataset.shuffle()` requires bufferSize to be specified."):new RangeError(`\`Dataset.shuffle()\` requires bufferSize to be specified.  If your data fits in main memory (for regular JS objects), and/or GPU memory (for \`tf.Tensor\`s), consider setting bufferSize to the dataset size (${this.size} elements)`);const s=this,r=si(e||ht().toString());return nb(async()=>{let e=r.int32();return n&&(e+=r.int32()),(await s.iterator()).shuffle(t,e.toString())},this.size)}take(t){const e=this;let n;return n=null!=this.size&&this.size>t?t:null!=this.size&&this.size<=t?this.size:null,nb(async()=>(await e.iterator()).take(t),n)}async toArray(){if(this.size===1/0)throw new Error("Can not convert infinite data stream to array.");return(await this.iterator()).toArray()}async toArrayForTest(){if(this.size===1/0)throw new Error("Can not convert infinite data stream to array.");return(await this.iterator()).toArrayForTest()}}function nb(t,e=null){return new class extends eb{constructor(){super(...arguments),this.size=e}async iterator(){return t()}}}function sb(t){if(null===t)return null;const e=t[0];if(null==(n=e)||null===(s=n)||"object"!=typeof s&&"function"!=typeof s||Array.isArray(n)||"object"==typeof n&&n instanceof Tt||S(n)){return{value:function(t){if(0===t.length)throw new Error("Can't make a batch of zero elements.");return t[0]instanceof Tt?Vi(t):re(t)}(t),recurse:!1}}var n,s;return{value:null,recurse:!0}}eb.MAX_BUFFER_SIZE=1e4;class rb extends eb{constructor(t){super(),this.input=t}async iterator(){return(await this.input.iterator()).decodeUTF8().split("\n").map(t=>(t.endsWith("\r")&&(t=t.slice(0,-1)),t))}}const ab=Symbol("out"),ib=Symbol("field"),ob=Symbol("quote"),lb=Symbol("quoteafterquote"),ub=Symbol("quoteinquote");class cb extends eb{constructor(t,e){super(),this.input=t,this.hasHeader=!0,this.fullColumnNames=null,this.columnNamesValidated=!1,this.columnConfigs=null,this.configuredColumnsOnly=!1,this.delimiter=",",this.delimWhitespace=!1,this.base=new rb(t),e||(e={}),this.hasHeader=!1!==e.hasHeader,this.fullColumnNames=e.columnNames,this.columnConfigs=e.columnConfigs,this.configuredColumnsOnly=e.configuredColumnsOnly,e.delimWhitespace?(l(null==e.delimiter,()=>"Delimiter should not be provided when delimWhitespace is true."),this.delimWhitespace=!0,this.delimiter=" "):this.delimiter=e.delimiter?e.delimiter:","}async columnNames(){return this.columnNamesValidated||await this.setColumnNames(),this.configuredColumnsOnly?Object.keys(this.columnConfigs):this.fullColumnNames}async setColumnNames(){const t=await this.maybeReadHeaderLine();if(!this.fullColumnNames&&!t)throw new Error("Column names must be provided if there is no header line.");this.fullColumnNames&&t&&l(t.length===this.fullColumnNames.length,()=>"The length of provided columnNames ("+this.fullColumnNames.length.toString()+") does not match the length of the header line read from file ("+t.length.toString()+")."),this.fullColumnNames||(this.fullColumnNames=t);const e=this.fullColumnNames.reduce((t,e)=>(t[e]=t[e]+1||1,t),{}),n=Object.keys(e).filter(t=>e[t]>1);if(l(0===n.length,()=>"Duplicate column names found: "+n.toString()),this.columnConfigs)for(const t of Object.keys(this.columnConfigs)){if(-1===this.fullColumnNames.indexOf(t))throw new Error('The key "'+t+'" provided in columnConfigs does not match any of the column names ('+this.fullColumnNames.toString()+").")}this.columnNamesValidated=!0}async maybeReadHeaderLine(){if(this.hasHeader){const t=await this.base.iterator(),e=await t.next();if(e.done)throw new Error("No data was found for CSV parsing.");const n=e.value;return this.parseRow(n,!1)}return null}async iterator(){this.columnNamesValidated||await this.setColumnNames();let t=await this.base.iterator();return this.hasHeader&&(t=t.skip(1)),t.map(t=>this.makeDataElement(t))}makeDataElement(t){const e=this.parseRow(t),n={},s={};for(let r=0;r<this.fullColumnNames.length;r++){const a=this.fullColumnNames[r],i=this.columnConfigs?this.columnConfigs[a]:null;if(!this.configuredColumnsOnly||i){const o=e[r];let l=null;if(""===o)if(i&&void 0!==i.default)l=i.default;else{if(i&&(i.required||i.isLabel))throw new Error(`Required column ${a} is empty in this line: ${t}`);l=void 0}else{const t=Number(o);if(isNaN(t))l=i&&"bool"===i.dtype?this.getBoolean(o):o;else if(i&&i.dtype)switch(i.dtype){case"float32":l=t;break;case"int32":l=Math.floor(t);break;case"bool":l=this.getBoolean(o);break;default:l=t}else l=t}i&&i.isLabel?s[a]=l:n[a]=l}}return 0===Object.keys(s).length?n:{xs:n,ys:s}}getBoolean(t){return"1"===t||"true"===t.toLowerCase()?1:0}parseRow(t,e=!0){const n=[];let s=0;const r=t.length;let a=ab;for(let e=0;e<r;e++)switch(a){case ab:switch(t.charAt(e)){case'"':s=e+1,a=ob;break;case this.delimiter:if(s=e+1," "===this.delimiter&&this.delimWhitespace)break;n.push(""),a=ab;break;default:a=ib,s=e}break;case ib:switch(t.charAt(e)){case this.delimiter:n.push(t.substring(s,e)),a=ab,s=e+1}break;case ob:switch(t.charAt(e)){case'"':a=lb}break;case lb:switch(t.charAt(e)){case this.delimiter:n.push(t.substring(s,e-1)),a=ab,s=e+1;break;case'"':a=ob;break;default:a=ub}break;case ub:switch(t.charAt(e)){case'"':a=ob}}if(a===lb?n.push(t.substring(s,r-1)):n.push(t.substring(s)),e&&n.length!==this.fullColumnNames.length)throw new Error(`Invalid row in csv file. Should have ${this.fullColumnNames.length} elements in a row, but got ${n}`);return n}}class hb extends Ly{constructor(t){super(),this.microphoneConfig=t,this.isClosed=!1,this.fftSize=t.fftSize||1024;const e=Math.log2(this.fftSize);if(this.fftSize<0||e<4||e>14||!Number.isInteger(e))throw new Error("Invalid fftSize: it must be a power of 2 between 2 to 4 and 2 to 14, but got "+this.fftSize);if(this.numFrames=t.numFramesPerSpectrogram||43,this.sampleRateHz=t.sampleRateHz,this.columnTruncateLength=t.columnTruncateLength||this.fftSize,this.audioTrackConstraints=t.audioTrackConstraints,this.smoothingTimeConstant=t.smoothingTimeConstant||0,this.includeSpectrogram=!1!==t.includeSpectrogram,this.includeWaveform=!0===t.includeWaveform,!this.includeSpectrogram&&!this.includeWaveform)throw new Error("Both includeSpectrogram and includeWaveform are false. At least one type of data should be returned.")}summary(){return"microphone"}static async create(t={}){if(H().get("IS_NODE"))throw new Error("microphone API is only supported in browser environment.");const e=new hb(t);return await e.start(),e}async start(){try{this.stream=await navigator.mediaDevices.getUserMedia({audio:null==this.audioTrackConstraints||this.audioTrackConstraints,video:!1})}catch(t){throw new Error("Error thrown while initializing video stream: "+t.message)}if(!this.stream)throw new Error("Could not obtain audio from microphone.");const t=window.AudioContext||window.webkitAudioContext;if(this.audioContext=new t,this.sampleRateHz){if(this.audioContext.sampleRate!==this.sampleRateHz)throw new Error(`Mismatch in sampling rate: Expected: ${this.sampleRateHz}; Actual: `+this.audioContext.sampleRate)}else this.sampleRateHz=this.audioContext.sampleRate;const e=this.audioContext.createMediaStreamSource(this.stream);this.analyser=this.audioContext.createAnalyser(),this.analyser.fftSize=2*this.fftSize,this.analyser.smoothingTimeConstant=this.smoothingTimeConstant,e.connect(this.analyser),this.freqData=new Float32Array(this.fftSize),this.timeData=new Float32Array(this.fftSize)}async next(){if(this.isClosed)return{value:null,done:!0};let t,e;const n=await this.getAudioData();if(this.includeSpectrogram){const e=this.flattenQueue(n.freqDataQueue);t=this.getTensorFromAudioDataArray(e,[this.numFrames,this.columnTruncateLength,1])}if(this.includeWaveform){const t=this.flattenQueue(n.timeDataQueue);e=this.getTensorFromAudioDataArray(t,[this.numFrames*this.fftSize,1])}return{value:{spectrogram:t,waveform:e},done:!1}}async capture(){return(await this.next()).value}async getAudioData(){const t=[],e=[];let n=0;return new Promise(s=>{const r=setInterval(()=>{this.includeSpectrogram&&(this.analyser.getFloatFrequencyData(this.freqData),this.freqData[0]===-1/0&&s({freqDataQueue:t,timeDataQueue:e}),t.push(this.freqData.slice(0,this.columnTruncateLength))),this.includeWaveform&&(this.analyser.getFloatTimeDomainData(this.timeData),e.push(this.timeData.slice())),++n===this.numFrames&&(clearInterval(r),s({freqDataQueue:t,timeDataQueue:e}))},this.fftSize/this.sampleRateHz*1e3)})}stop(){this.isClosed||(this.isClosed=!0,this.analyser.disconnect(),this.audioContext.close(),null!=this.stream&&this.stream.getTracks().length>0&&this.stream.getTracks()[0].stop())}toArray(){throw new Error("Can not convert infinite audio stream to array.")}getSampleRate(){return this.sampleRateHz}flattenQueue(t){const e=t[0].length,n=new Float32Array(t.length*e);return t.forEach((t,s)=>n.set(t,s*e)),n}getTensorFromAudioDataArray(t,e){const n=new Float32Array(p(e));return n.set(t,n.length-t.length),re(n,e)}}class pb extends Ly{constructor(t,e){if(super(),this.webcamVideoElement=t,this.webcamConfig=e,this.isClosed=!0,this.resize=!1,this.needToResize())if(this.resize=!0,this.cropSize=[this.webcamConfig.resizeHeight,this.webcamConfig.resizeWidth],this.cropBoxInd=ci([0],"int32"),this.webcamConfig.centerCrop){const t=1*this.webcamConfig.resizeWidth/this.webcamVideoElement.width,e=1*this.webcamConfig.resizeHeight/this.webcamVideoElement.height,n=(1-t)/2,s=(1-e)/2,r=n+t,a=e+s;this.cropBox=ji([s,n,a,r],[1,4])}else this.cropBox=ji([0,0,1,1],[1,4])}summary(){return"webcam"}static async create(t,e={}){if(H().get("IS_NODE"))throw new Error("tf.data.webcam is only supported in browser environment.");if(!t){if(t=document.createElement("video"),!e.resizeWidth||!e.resizeHeight)throw new Error("Please provide webcam video element, or resizeWidth and resizeHeight to create a hidden video element.");t.width=e.resizeWidth,t.height=e.resizeHeight}const n=new pb(t,e);return await n.start(),n}async start(){this.webcamConfig.facingMode&&l("user"===this.webcamConfig.facingMode||"environment"===this.webcamConfig.facingMode,()=>`Invalid webcam facing mode: ${this.webcamConfig.facingMode}. Please provide 'user' or 'environment'`);try{this.stream=await navigator.mediaDevices.getUserMedia({video:{deviceId:this.webcamConfig.deviceId,facingMode:this.webcamConfig.facingMode?this.webcamConfig.facingMode:"user",width:this.webcamVideoElement.width,height:this.webcamVideoElement.height}})}catch(t){throw t.message="Error thrown while initializing video stream: "+t.message,t}if(!this.stream)throw new Error("Could not obtain video from webcam.");try{this.webcamVideoElement.srcObject=this.stream}catch(t){console.log(t),this.webcamVideoElement.src=window.URL.createObjectURL(this.stream)}return this.webcamVideoElement.play(),this.isClosed=!1,new Promise(t=>{this.webcamVideoElement.onloadedmetadata=()=>{t()}})}async next(){if(this.isClosed)return{value:null,done:!0};let t;try{t=mn(this.webcamVideoElement)}catch(t){throw new Error("Error thrown converting video to pixels: "+JSON.stringify(t))}if(!this.resize)return{value:t,done:!1};try{return{value:this.cropAndResizeFrame(t),done:!1}}catch(t){throw new Error("Error thrown cropping the video: "+t.message)}finally{t.dispose()}}needToResize(){return!(!this.webcamConfig.resizeWidth||!this.webcamConfig.resizeHeight||this.webcamVideoElement.width===this.webcamConfig.resizeWidth&&this.webcamVideoElement.height===this.webcamConfig.resizeHeight)}cropAndResizeFrame(t){return Jn(()=>{const e=t.toFloat().expandDims(0);let n;n=Sl.cropAndResize(e,this.cropBox,this.cropBoxInd,this.cropSize,"bilinear");const s=n.shape;return n.reshape(s.slice(1))})}async capture(){return(await this.next()).value}stop(){this.stream.getTracks().forEach(t=>t.stop());try{this.webcamVideoElement.srcObject=null}catch(t){console.log(t),this.webcamVideoElement.src=null}this.isClosed=!0}toArray(){throw new Error("Can not convert infinite video stream to array.")}}class db{}class fb extends Ly{split(t){return new mb(this,t)}}class mb extends fb{constructor(t,e){super(),this.upstream=t,this.impl=new gb(t,e)}summary(){return this.impl.summary()}async next(){return this.impl.next()}}class gb extends Ky{constructor(t,e){super(),this.upstream=t,this.separator=e,this.carryover=""}summary(){return`${this.upstream.summary()} -> Split('${this.separator}')`}async pump(){const t=await this.upstream.next();if(t.done)return""!==this.carryover&&(this.outputQueue.push(this.carryover),this.carryover="",!0);const e=t.value.split(this.separator);e[0]=this.carryover+e[0];for(const t of e.slice(0,-1))this.outputQueue.push(t);return this.carryover=e[e.length-1],!0}}class yb extends Ly{decodeUTF8(){return new bb(this)}}class bb extends fb{constructor(t){super(),this.upstream=t,this.impl=new xb(t)}summary(){return this.impl.summary()}async next(){return this.impl.next()}}class xb extends Ky{constructor(t){if(super(),this.upstream=t,H().get("IS_BROWSER"))this.decoder=new TextDecoder("utf-8");else{const{StringDecoder:t}=require("string_decoder");this.decoder=new t("utf8")}}summary(){return this.upstream.summary()+" -> Utf8"}async pump(){const t=await this.upstream.next();let e,n;return!t.done&&(e=t.value,n=H().get("IS_BROWSER")?this.decoder.decode(e,{stream:!0}):this.decoder.write(Buffer.from(e.buffer)),this.outputQueue.push(n),!0)}}class wb extends yb{constructor(t,e={}){super(),this.file=t,this.options=e,l(t instanceof Uint8Array||!!H().get("IS_BROWSER")&&(t instanceof File||t instanceof Blob),()=>"FileChunkIterator only supports File, Blob and Uint8Array right now."),this.offset=e.offset||0,this.chunkSize=e.chunkSize||1048576}summary(){return"FileChunks "+this.file}async next(){if(this.offset>=(this.file instanceof Uint8Array?this.file.byteLength:this.file.size))return{value:null,done:!0};const t=new Promise((t,e)=>{const n=this.offset+this.chunkSize;if(this.file instanceof Uint8Array)t(new Uint8Array(this.file.slice(this.offset,n)));else{const s=new FileReader;s.onload=n=>{let r=s.result;if(r instanceof ArrayBuffer&&(r=new Uint8Array(r)),!(r instanceof Uint8Array))return e(new TypeError("FileReader returned unknown type."));t(r)},s.onabort=t=>e(new Error("Aborted")),s.onerror=t=>e(new Error(t.type));const r=this.file.slice(this.offset,n);s.readAsArrayBuffer(r)}this.offset=n});return{value:await t,done:!1}}}const vb=t=>({method:t.method,headers:t.headers,body:t.body,mode:t.mode,credentials:t.credentials,cache:t.cache,redirect:t.redirect,referrer:t.referrer,integrity:t.integrity});function kb(t){return"string"==typeof t&&"file://"===t.substr(0,7)}class Nb extends db{constructor(t,e={}){super(),this.input=t,this.options=e}async iterator(){if(kb(this.input)&&H().get("IS_NODE")){const t=require("fs");this.input=t.readFileSync(this.input.substr(7))}return new wb(this.input,this.options)}}class Ib extends db{constructor(t,e={}){super(),this.url=t,this.fileOptions=e}async iterator(){return kb(this.url)?new Nb(this.url,this.fileOptions).iterator():async function(t,e={}){let n,s;"string"==typeof t?n=t:(n=t.url,s=vb(t));const r=await pt(n,s);if(r.ok){const t=new Uint8Array(await r.arrayBuffer());return new wb(t,e)}throw new Error(r.statusText)}(this.url,this.fileOptions)}}var Cb=Object.freeze({__proto__:null,array:function(t){return nb(async()=>Fy(t),t.length)},Dataset:eb,zip:function(t){if(!$y(t))throw new Error("The argument to zip() must be an object or array.");let e;if(Array.isArray(t))for(let n=0;n<t.length;n++)e=null==e?t[n].size:Math.min(e,t[n].size);else if(t instanceof Object)for(const n in t)e=null==e?t[n].size:Math.min(e,t[n].size);return nb(async()=>function(t,e=Jy.FAIL){return new Zy(t,e)}(await Ey(t,t=>{if(t instanceof eb)return{value:t.iterator(),recurse:!1};if($y(t))return{value:null,recurse:!0};throw new Error("Leaves of the structure passed to zip() must be Datasets, not primitives.")}),Jy.SHORTEST),e)},CSVDataset:cb,TextLineDataset:rb,csv:function(t,e={}){return new cb(new Ib(t),e)},func:function(t){const e=Oy(t);return nb(async()=>e)},generator:function(t){return nb(async()=>{const e=await t();return Oy(()=>e.next())})},microphone:async function(t){return hb.create(t)},webcam:async function(t,e){return pb.create(t,e)},FileDataSource:Nb,URLDataSource:Ib,version_data:"2.7.0"});function Sb(t,e){Array.isArray(t)||(t=[t]),t.forEach(t=>{null!=t&&l("complex64"!==t.dtype,()=>e+" does not support complex64 tensors in the CPU backend.")})}const Tb=Yo,Eb=iu,$b=ou,Ab=lu,Rb=to;class Db extends n{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new e(this,Xn())}write(t,e,n){this.firstUse&&(this.firstUse=!1,H().get("IS_NODE")&&Kl("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));const s={};return this.data.set(s,{values:t,dtype:n,refCount:1}),s}makeTensorInfo(t,e,n){let s;if("string"===e&&null!=n&&n.length>0&&$(n[0])){const r=n.map(t=>dt(t));s=this.write(r,t,e)}else s=this.write(n,t,e);return{dataId:s,shape:t,dtype:e}}incRef(t){this.data.get(t).refCount++}decRef(t){if(this.data.has(t)){this.data.get(t).refCount--}}move(t,e,n,s){this.data.set(t,{values:e,dtype:s,refCount:1})}numDataIds(){return this.data.numDataIds()}async read(t){return this.readSync(t)}readSync(t){const{dtype:e,complexTensorInfos:n}=this.data.get(t);if("complex64"===e){return Xl(this.readSync(n.real.dataId),this.readSync(n.imag.dataId))}return this.data.get(t).values}bufferSync(t){const e=this.readSync(t.dataId);let n=e;if("string"===t.dtype)try{n=e.map(t=>ft(t))}catch(t){throw new Error("Failed to decode encoded string bytes into utf-8")}return We(t.shape,t.dtype,n)}makeOutput(t,e,n){const s=this.write(t,e,n);return Xn().makeTensorFromDataId(s,e,n,this)}disposeData(t){if(this.data.has(t)){const{complexTensorInfos:e}=this.data.get(t);null!=e&&(this.disposeData(e.real.dataId),this.disposeData(e.imag.dataId)),this.data.delete(t)}}disposeIntermediateTensorInfo(t){const e=t.dataId;if(this.data.has(e)){const t=this.data.get(e);t.refCount--,t.refCount<1&&this.disposeData(e)}}async time(t){const e=ht();return t(),{kernelMs:ht()-e}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}stridedSlice(t,e,n,s){Sb(t,"stridedSlice");const r=Cn(e,n,s);if(r.some(t=>0===t))return re([],r);const a=We(r,t.dtype),i=this.bufferSync(t);for(let t=0;t<a.size;t++){const n=a.indexToLoc(t),r=new Array(n.length);for(let t=0;t<r.length;t++)r[t]=n[t]*s[t]+e[t];a.set(i.get(...r),...n)}return a.toTensor()}diag(t){const e=this.readSync(t.dataId),n=We([t.size,t.size],t.dtype),s=n.values;for(let n=0;n<e.length;n++)s[n*t.size+n]=e[n];return n.toTensor()}unstack(t,e){const n=t.shape[e],s=new Array(t.rank-1);let r=0;for(let n=0;n<t.rank;n++)n!==e&&(s[r++]=t.shape[n]);const a=new Array(t.rank).fill(0),i=t.shape.slice();i[e]=1;const o=new Array(n);for(let n=0;n<o.length;n++)a[e]=n,o[n]=qs(t,a,i).reshape(s);return o}reverse(t,e){Sb(t,"reverse");const n=We(t.shape,t.dtype),s=this.bufferSync(t);for(let r=0;r<n.size;r++){const a=n.indexToLoc(r),i=a.slice();e.forEach(e=>i[e]=t.shape[e]-1-i[e]),n.set(s.get(...i),...a)}return n.toTensor()}neg(t){return Sb(t,"neg"),is(Jr(-1),t)}addN(t){Sb(t,"addN");const e=t.map(t=>this.readSync(t.dataId)),n=We(t[0].shape,t[0].dtype),s=n.values;for(let n=0;n<t.length;n++){const t=e[n];for(let e=0;e<s.length;e++)s[e]+=t[e]}return n.toTensor()}softmax(t,e){const n=x([e],t.shape),s=ha(t,n),r=fs(s.shape,n),a=pa(t,s.reshape(r)),i=_r(a),o=this.sum(i,n).reshape(r);return as(i,o)}pow(t,e){return Sb([t,e],"pow"),this.broadcastedBinaryOp(t,e,t.dtype,(t,e)=>Math.pow(t,e))}floorDiv(t,e){Sb([t,e],"floorDiv");return this.broadcastedBinaryOp(t,e,"int32",(t,e)=>Math.floor(t/e))}sum(t,e){Sb(t,"sum"),ms("sum",e,t.rank);const[n,s]=ds(t.shape,e),r=Na(n,Ot(t.dtype,"int32")),a=p(s),i=this.readSync(r.dataId),o=this.readSync(t.dataId);for(let t=0;t<i.length;++t){const e=t*a;let n=0;for(let t=0;t<a;++t)n+=o[e+t];i[t]=n}return r}prod(t,e){Sb(t,"sum");const[n,s]=ds(t.shape,e),r=Na(n,Ot(t.dtype,"int32")),a=p(s),i=this.readSync(r.dataId),o=this.readSync(t.dataId);for(let t=0;t<i.length;++t){const e=t*a;let n=1;for(let t=0;t<a;++t)n*=o[e+t];i[t]=n}return r}unsortedSegmentSum(t,e,n){Sb(t,"unsortedSegmentSum");const s=[],r=t.rank-e.rank;for(let t=0;t<r;++t)e=e.expandDims(t+1);for(let r=0;r<n;++r){const n=Jr(r,"int32"),a=Sr(n,e).asType("float32").mul(t).sum(0);s.push(a)}return Vi(s)}argMin(t,e){Sb(t,"argMin");const n=[e];ms("argMin",n,t.rank);const[s,r]=ds(t.shape,n),a=Na(s,"int32"),i=p(r),o=this.readSync(a.dataId),l=this.readSync(t.dataId);for(let t=0;t<o.length;++t){const e=t*i;let n=l[e],s=0;for(let t=0;t<i;++t){const r=l[e+t];r<n&&(n=r,s=t)}o[t]=s}return a}argMax(t,e){Sb(t,"argMax");const n=[e];ms("argMax",n,t.rank);const[s,r]=ds(t.shape,n),a=Na(s,"int32"),i=p(r),o=this.readSync(a.dataId),l=this.readSync(t.dataId);for(let t=0;t<o.length;++t){const e=t*i;let n=l[e],s=0;for(let t=0;t<i;++t){const r=l[e+t];r>n&&(n=r,s=t)}o[t]=s}return a}cumsum(t,e,n,s){if(Sb(t,"cumsum"),e!==t.rank-1)throw new Error(`backend.cumsum in CPU expects an inner-most axis=${t.rank-1} but got axis=`+e);const r=Ot(t.dtype,"int32"),a=Na(t.shape,r),i=this.readSync(a.dataId),o=this.readSync(t.dataId),l=t.shape[t.rank-1],u=s?(t,e)=>t+l-e-1:(t,e)=>t+e;for(let t=0;t<o.length;t+=l)for(let e=0;e<l;e++){const s=u(t,e);if(0===e)i[s]=n?0:o[s];else{const r=u(t,e-1);i[s]=n?o[r]+i[r]:o[s]+i[r]}}return a}equal(t,e){return Sb([t,e],"equal"),this.broadcastedBinaryOp(t,e,"bool",(t,e)=>t===e?1:0)}notEqual(t,e){return Sb([t,e],"notEqual"),this.broadcastedBinaryOp(t,e,"bool",(t,e)=>t!==e?1:0)}less(t,e){return Sb([t,e],"less"),this.broadcastedBinaryOp(t,e,"bool",(t,e)=>t<e?1:0)}lessEqual(t,e){return Sb([t,e],"lessEqual"),this.broadcastedBinaryOp(t,e,"bool",(t,e)=>t<=e?1:0)}greater(t,e){return Sb([t,e],"greater"),this.broadcastedBinaryOp(t,e,"bool",(t,e)=>t>e?1:0)}greaterEqual(t,e){return Sb([t,e],"greaterEqual"),this.broadcastedBinaryOp(t,e,"bool",(t,e)=>t>=e?1:0)}logicalAnd(t,e){return Sb([t,e],"logicalAnd"),this.broadcastedBinaryOp(t,e,"bool",(t,e)=>t&&e)}logicalOr(t,e){return Sb([t,e],"logicalOr"),this.broadcastedBinaryOp(t,e,"bool",(t,e)=>t||e)}select(t,e,n){Sb([t,e,n],"select");const s=this.readSync(t.dataId),r=this.readSync(e.dataId),a=this.readSync(n.dataId),i=Na(e.shape,Ot(e.dtype,n.dtype)),o=this.readSync(i.dataId);let l=0;const u=0===t.rank||t.rank>1||1===e.rank?1:p(e.shape.slice(1));for(let t=0;t<s.length;t++)for(let e=0;e<u;e++)1===s[t]?o[l++]=r[t]:o[l++]=a[t];return i}where(t){Sb([t],"where");const e=this.readSync(t.dataId);return Rb(t.shape,e)}topk(t,e,n){Sb(t,"topk");const s=this.readSync(t.dataId);return Ab(s,t.shape,t.dtype,e,n)}min(t,e){Sb(t,"min"),ms("min",e,t.rank);const[n,s]=ds(t.shape,e),r=Na(n,t.dtype),a=p(s),i=this.readSync(r.dataId),o=this.readSync(t.dataId);for(let t=0;t<i.length;++t){const e=t*a;let n=o[e];for(let t=0;t<a;++t){const s=o[e+t];s<n&&(n=s)}i[t]=n}return r}minimum(t,e){return Sb([t,e],"minimum"),this.broadcastedBinaryOp(t,e,t.dtype,(t,e)=>Math.min(t,e))}mod(t,e){return Sb([t,e],"mod"),this.broadcastedBinaryOp(t,e,t.dtype,(t,e)=>{const n=t%e;return t<0&&e<0||t>=0&&e>=0?n:(n+e)%e})}maximum(t,e){return Sb([t,e],"maximum"),this.broadcastedBinaryOp(t,e,t.dtype,(t,e)=>Math.max(t,e))}all(t,e){Sb(t,"all"),ms("all",e,t.rank);const[n,s]=ds(t.shape,e),r=Na(n,t.dtype),a=p(s),i=this.readSync(r.dataId),o=this.readSync(t.dataId);for(let t=0;t<i.length;++t){const e=t*a;let n=o[e];for(let t=0;t<a;++t){const s=o[e+t];n=n&&s}i[t]=n}return r}any(t,e){Sb(t,"any"),ms("any",e,t.rank);const[n,s]=ds(t.shape,e),r=Na(n,t.dtype),a=p(s),i=this.readSync(r.dataId),o=this.readSync(t.dataId);for(let t=0;t<i.length;++t){const e=t*a;let n=o[e];for(let t=0;t<a;++t){const s=o[e+t];n=n||s}i[t]=n}return r}squaredDifference(t,e){return Sb([t,e],"squaredDifference"),this.broadcastedBinaryOp(t,e,t.dtype,(t,e)=>{const n=t-e;return n*n})}eluDer(t,e){Sb([t,e],"eluDer");const n=new Float32Array(e.size),s=this.readSync(e.dataId),r=this.readSync(t.dataId);for(let t=0;t<s.length;++t){const e=s[t];n[t]=e>=1?r[t]:r[t]*(e+1)}return this.makeOutput(n,e.shape,"float32")}atan2(t,e){return Sb([t,e],"atan2"),this.broadcastedBinaryOp(t,e,t.dtype,(t,e)=>Math.atan2(t,e))}tile(t,e){return Sb(t,"tile"),$b(this.bufferSync(t),e)}gather(t,e,n){Sb([t,e],"gather");const s=t.shape.slice(),r=this.readSync(e.dataId);s[n]=r.length;const a=We(s,t.dtype),i=this.bufferSync(t);for(let t=0;t<a.size;++t){const e=a.indexToLoc(t),s=e.slice();s[n]=r[e[n]];const o=i.locToIndex(s);a.values[t]=i.values[o]}return a.toTensor()}batchToSpaceND(t,e,n){Sb([t],"batchToSpaceND");const s=e.reduce((t,e)=>t*e),r=Vl(t.shape,e,s),a=Ul(r.length,e.length),i=Gl(t.shape,e,s),o=Hl(n,e.length),l=jl(i,n,e.length);return cn(t.reshape(r),a).reshape(i).slice(o,l)}pool3d(t,e,n){Sb(t,"pool3d");const s=e.strideDepth,r=e.strideHeight,a=e.strideWidth,i=e.dilationDepth,o=e.dilationHeight,l=e.dilationWidth,u=e.effectiveFilterDepth,c=e.effectiveFilterHeight,h=e.effectiveFilterWidth,p=e.padInfo.front,d=e.padInfo.top,f=e.padInfo.left,m="max"===n?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,g=this.readSync(t.dataId),y=We(e.outShape,t.dtype),b=y.values,x=e.outShape[1]*e.outShape[2]*e.outShape[3]*e.outShape[4],w=e.outShape[2]*e.outShape[3]*e.outShape[4],v=e.outShape[3]*e.outShape[4],k=e.outShape[4];for(let y=0;y<e.batchSize;++y){const N=y*x,I=y*t.strides[0];for(let y=0;y<e.inChannels;++y)for(let x=0;x<e.outDepth;++x){const C=x*s-p;let S=C;for(;S<0;)S+=i;const T=Math.min(e.inDepth,u+C),E=N+x*w;for(let s=0;s<e.outHeight;++s){const u=s*r-d;let p=u;for(;p<0;)p+=o;const x=Math.min(e.inHeight,c+u),w=E+s*v;for(let s=0;s<e.outWidth;++s){const r=s*a-f;let u=r;for(;u<0;)u+=l;const c=Math.min(e.inWidth,h+r),d=w+s*k;let v=m,N=0,C=0;for(let e=S;e<T;e+=i){const s=I+e*t.strides[1];for(let e=p;e<x;e+=o){const r=s+e*t.strides[2];for(let e=u;e<c;e+=l){const s=g[r+e*t.strides[3]+y];if("max"===n&&s>v?v=s:"avg"===n&&(N+=s,C++),isNaN(v))break}if(isNaN(v))break}if(isNaN(v))break}b[d+y]="avg"===n?N/C:v}}}}return y.toTensor()}avgPool3d(t,e){return Sb(t,"avgPool3d"),this.pool3d(t,e,"avg").toFloat()}avgPool3dBackprop(t,e,n){Sb([t,e],"avgPool3dBackprop");const s=n.strideDepth,r=n.strideHeight,a=n.strideWidth,i=n.filterDepth,o=n.filterHeight,l=n.filterWidth,u=n.dilationDepth,c=n.dilationHeight,h=n.dilationWidth,p=n.effectiveFilterDepth,d=n.effectiveFilterHeight,f=n.effectiveFilterWidth,m=p-1-n.padInfo.front,g=f-1-n.padInfo.left,y=d-1-n.padInfo.top,b=We(e.shape,"float32"),x=1/(i*o*l),w=this.bufferSync(t);for(let t=0;t<n.batchSize;++t)for(let e=0;e<n.inChannels;++e)for(let i=0;i<n.inDepth;++i)for(let o=0;o<n.inHeight;++o)for(let l=0;l<n.inWidth;++l){const v=i-m,k=o-y,N=l-g;let I=0;for(let i=0;i<p;i+=u){const o=(v+i)/s;if(!(o<0||o>=n.outDepth||Math.floor(o)!==o))for(let s=0;s<d;s+=c){const i=(k+s)/r;if(!(i<0||i>=n.outHeight||Math.floor(i)!==i))for(let s=0;s<f;s+=h){const r=(N+s)/a;r<0||r>=n.outWidth||Math.floor(r)!==r||(I+=w.get(t,o,i,r,e))}}}b.set(I*x,t,i,o,l,e)}return b.toTensor()}maxPool3d(t,e){return Sb(t,"maxPool3d"),this.pool3d(t,e,"max").toFloat()}maxPool3dPositions(t,e){const n=We(e.outShape,"int32"),s=e.strideDepth,r=e.strideHeight,a=e.strideWidth,i=e.dilationDepth,o=e.dilationHeight,l=e.dilationWidth,u=e.effectiveFilterDepth,c=e.effectiveFilterHeight,h=e.effectiveFilterWidth,p=e.padInfo.front,d=e.padInfo.top,f=e.padInfo.left,m=this.bufferSync(t);for(let t=0;t<e.batchSize;++t)for(let g=0;g<e.inChannels;++g)for(let y=0;y<e.outDepth;++y){const b=y*s-p;let x=b;for(;x<0;)x+=i;const w=Math.min(e.inDepth,u+b);for(let s=0;s<e.outHeight;++s){const u=s*r-d;let p=u;for(;p<0;)p+=o;const v=Math.min(e.inHeight,c+u);for(let r=0;r<e.outWidth;++r){const d=r*a-f;let k=d;for(;k<0;)k+=l;const N=Math.min(e.inWidth,h+d);let I=Number.NEGATIVE_INFINITY,C=-1;for(let e=x;e<w;e+=i){const n=e-b;for(let s=p;s<v;s+=o){const r=s-u;for(let a=k;a<N;a+=l){const i=a-d,o=m.get(t,e,s,a,g);o>=I&&(I=o,C=n*c*h+r*c+i)}}}n.set(C,t,y,s,r,g)}}}return n.toTensor()}maxPool3dBackprop(t,e,n,s){Sb([e,n],"maxPool3dBackprop");const r=this.maxPool3dPositions(e,s),a=s.strideDepth,i=s.strideHeight,o=s.strideWidth,l=s.dilationDepth,u=s.dilationHeight,c=s.dilationWidth,h=s.effectiveFilterDepth,p=s.effectiveFilterHeight,d=s.effectiveFilterWidth,f=h-1-s.padInfo.front,m=d-1-s.padInfo.left,g=p-1-s.padInfo.top,y=We(e.shape,"float32"),b=this.bufferSync(r),x=this.bufferSync(t);for(let t=0;t<s.batchSize;++t)for(let e=0;e<s.inChannels;++e)for(let n=0;n<s.inDepth;++n)for(let r=0;r<s.inHeight;++r)for(let w=0;w<s.inWidth;++w){const v=n-f,k=r-g,N=w-m;let I=0;for(let n=0;n<h;n+=l){const r=(v+n)/a;if(!(r<0||r>=s.outDepth||Math.floor(r)!==r))for(let a=0;a<p;a+=u){const l=(k+a)/i;if(!(l<0||l>=s.outHeight||Math.floor(l)!==l))for(let i=0;i<d;i+=c){const u=(N+i)/o;if(u<0||u>=s.outWidth||Math.floor(u)!==u)continue;const c=h*p*d-1-b.get(t,r,l,u,e)===n*p*d+a*d+i?1:0;0!==c&&(I+=x.get(t,r,l,u,e)*c)}}}y.set(I,t,n,r,w,e)}return y.toTensor()}resizeBilinear(t,e,n,s){Sb(t,"resizeBilinear");const[r,a,i,o]=t.shape,l=this.readSync(t.dataId),u=new Float32Array(p([r,e,n,o])),c=[s&&e>1?a-1:a,s&&n>1?i-1:i],h=[s&&e>1?e-1:e,s&&n>1?n-1:n];let d=0;const f=c[0]/h[0],m=c[1]/h[1];for(let s=0;s<r;s++)for(let r=0;r<e;r++){const e=f*r,c=Math.floor(e),h=e-c,p=Math.min(a-1,Math.ceil(e)),g=s*t.strides[0]+c*t.strides[1],y=s*t.strides[0]+p*t.strides[1];for(let e=0;e<n;e++){const n=m*e,s=Math.floor(n),r=n-s,a=Math.min(i-1,Math.ceil(n)),c=g+s*t.strides[2],p=y+s*t.strides[2],f=g+a*t.strides[2],b=y+a*t.strides[2];for(let t=0;t<o;t++){const e=l[c+t],n=l[p+t],s=e+(l[f+t]-e)*r,a=s+(n+(l[b+t]-n)*r-s)*h;u[d++]=a}}}return re(u,[r,e,n,o])}resizeBilinearBackprop(t,e,n){Sb([t,e],"resizeBilinearBackprop");const[s,r,a,i]=e.shape,[,o,l]=t.shape,u=new Float32Array(s*r*a*i),c=[n&&o>1?r-1:r,n&&l>1?a-1:a],h=[n&&o>1?o-1:o,n&&l>1?l-1:l],p=c[0]/h[0],d=c[1]/h[1],f=this.readSync(t.dataId);let m=0;for(let t=0;t<s;t++){const n=t*e.strides[0];for(let t=0;t<o;t++){const s=t*p,o=Math.floor(s),c=Math.min(Math.ceil(s),r-1),h=n+o*e.strides[1],g=n+c*e.strides[1],y=s-o,b=1-y;for(let t=0;t<l;t++){const n=t*d,s=Math.floor(n),r=Math.min(Math.ceil(n),a-1),o=n-s,l=1-o,c=h+s*e.strides[2],p=h+r*e.strides[2],x=g+s*e.strides[2],w=g+r*e.strides[2],v=b*l,k=b*o,N=y*l,I=y*o;for(let t=0;t<i;t++){const e=f[m++];u[c+t]+=e*v,u[p+t]+=e*k,u[x+t]+=e*N,u[w+t]+=e*I}}}}return qi(u,[s,a,r,i],e.dtype)}resizeNearestNeighbor(t,e,n,s){Sb(t,"resizeNearestNeighbor");const[r,a,i,o]=t.shape,l=this.readSync(t.dataId),u=new Float32Array(r*e*n*o),c=[s&&e>1?a-1:a,s&&n>1?i-1:i],h=[s&&e>1?e-1:e,s&&n>1?n-1:n],p=c[0]/h[0],d=c[1]/h[1];let f=0;for(let c=0;c<r;c++){const r=c*t.strides[0];for(let c=0;c<e;c++){const e=p*c,h=r+Math.min(a-1,s?Math.round(e):Math.floor(e))*t.strides[1];for(let e=0;e<n;e++){const n=d*e,r=h+Math.min(i-1,s?Math.round(n):Math.floor(n))*t.strides[2];for(let t=0;t<o;t++){const e=l[r+t];u[f++]=e}}}}return re(u,[r,e,n,o],t.dtype)}resizeNearestNeighborBackprop(t,e,n){Sb([t,e],"resizeNearestNeighborBackprop");const[s,r,a,i]=e.shape,[,o,l]=t.shape,u=new Float32Array(s*r*a*i),c=this.readSync(t.dataId),h=[n&&o>1?r-1:r,n&&l>1?a-1:a],p=[n&&o>1?o-1:o,n&&l>1?l-1:l],d=h[0]/p[0],f=h[1]/p[1],m=1/d,g=1/f,y=2*Math.ceil(m)+2,b=2*Math.ceil(g)+2;for(let h=0;h<s;h++){const s=h*e.strides[0];for(let h=0;h<r;h++){const p=s+h*e.strides[1],x=Math.floor(h*m),w=Math.floor(x-y/2);for(let m=0;m<a;m++){const x=p+m*e.strides[2],v=Math.floor(m*g),k=Math.floor(v-b/2);for(let e=0;e<i;e++){let i=0;for(let u=0;u<y;u++){const p=u+w;if(p<0||p>=o)continue;const g=s+p*t.strides[1],y=p*d;if(h===Math.min(r-1,n?Math.round(y):Math.floor(y)))for(let s=0;s<b;s++){const r=s+k;if(r<0||r>=l)continue;const o=g+r*t.strides[2],u=r*f;m===Math.min(a-1,n?Math.round(u):Math.floor(u))&&(i+=c[o+e])}}u[x+e]=i}}}}return qi(u,e.shape,e.dtype)}localResponseNormalization4D(t,e,n,s,r){Sb(t,"localResponseNormalization4D");const a=t.shape[3],i=a-1,o=this.readSync(t.dataId),l=t.size,u=new Float32Array(l);function c(t){const n=t%a;let s=t-n+Math.max(0,n-e);const r=t-n+Math.min(n+e,i);let l=0;for(;s<=r;s++){const t=o[s];l+=t*t}return l}for(let t=0;t<l;t++){const e=c(t),a=o[t]*Math.pow(n+s*e,-r);u[t]=a}return qi(u,t.shape)}LRNGrad(t,e,n,s,r,a,i){Sb(t,"LRNGrad");const o=t.shape[3],l=this.readSync(t.dataId),u=this.readSync(e.dataId),c=this.readSync(n.dataId),h=new Float32Array(t.size),p=t.size;for(let t=0;t<p;t++){const e=t%o,n=t-e+Math.max(0,e-s),p=t-e+Math.min(o,e+s+1);let d=0;for(let t=n;t<p;t++)d+=Math.pow(u[t],2);d=a*d+r;for(let e=n;e<p;e++){let n=-2*a*i*u[e]*c[t]/d;t===e&&(n+=Math.pow(d,-i)),n*=l[t],h[e]+=n}}return qi(h,t.shape)}multinomial(t,e,n,s){Sb(t,"multinomial");const r=e?t:Di(t),a=r.shape[0],i=r.shape[1],o=Na([a,n],"int32"),l=this.readSync(o.dataId),u=this.readSync(r.dataId);for(let t=0;t<a;++t){const e=t*i,r=new Float32Array(i-1);r[0]=u[e];for(let t=1;t<r.length;++t)r[t]=r[t-1]+u[e+t];const a=si(s.toString()),o=t*n;for(let t=0;t<n;++t){const e=a();l[o+t]=r.length;for(let n=0;n<r.length;n++)if(e<r[n]){l[o+t]=n;break}}}return o}oneHot(t,e,n,s){Sb(t,"oneHot");const r=new Float32Array(t.size*e);r.fill(s);const a=this.readSync(t.dataId);for(let s=0;s<t.size;++s)a[s]>=0&&a[s]<e&&(r[s*e+a[s]]=n);return ji(r,[t.size,e],"int32")}nonMaxSuppression(t,e,n,s,r){Sb(t,"nonMaxSuppression");const a=this.readSync(t.dataId),i=this.readSync(e.dataId);return Tb(a,i,n,s,r)}depthToSpace(t,e,n){l("NHWC"===n,()=>"Only NHWC dataFormat supported on CPU for depthToSpace. Got "+n),l(e>1,()=>"blockSize should be > 1 for depthToSpace, but was: "+e);const s=t.shape[0],r=t.shape[1],a=t.shape[2],i=t.shape[3],o=r*e,u=a*e,c=i/(e*e),h=this.readSync(t.dataId),p=new Float32Array(s*o*u*c);let d=0;for(let t=0;t<s;++t)for(let n=0;n<o;++n){const s=Math.floor(n/e),o=n%e;for(let n=0;n<u;++n){const l=Math.floor(n/e),u=(o*e+n%e)*c;for(let e=0;e<c;++e){const n=e+u+i*(l+a*(s+r*t));p[d++]=h[n]}}}return qi(p,[s,o,u,c])}broadcastedBinaryOp(t,e,n,s){const r=Cr(t.shape,e.shape),a=We(r,n),i=this.readSync(t.dataId),o=this.readSync(e.dataId),l=Nr(t.shape,r),u=Nr(e.shape,r),c=a.values;if(l.length+u.length===0)for(let t=0;t<c.length;++t)c[t]=s(i[t%i.length],o[t%o.length]);else{const n=this.bufferSync(t),r=this.bufferSync(e);for(let h=0;h<c.length;++h){const p=a.indexToLoc(h),d=p.slice(-t.rank);l.forEach(t=>d[t]=0);const f=n.locToIndex(d),m=p.slice(-e.rank);u.forEach(t=>m[t]=0);const g=r.locToIndex(m);c[h]=s(i[f],o[g])}}return a.toTensor()}split(t,e,n){return Eb(t,e,n)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}cropAndResize(t,e,n,s,r,a){const[i,o,l,u]=t.shape,c=e.shape[0],[h,p]=s,d=We([c,h,p,u],"float32"),f=this.readSync(e.dataId),m=this.readSync(n.dataId),g=this.readSync(t.dataId),y=t.strides,b=d.strides;for(let t=0;t<c;t++){const e=4*t,n=f[e],s=f[e+1],c=f[e+2],x=f[e+3],w=m[t];if(w>=i)continue;const v=h>1?(c-n)*(o-1)/(h-1):0,k=p>1?(x-s)*(l-1)/(p-1):0;for(let e=0;e<h;e++){const i=h>1?n*(o-1)+e*v:.5*(n+c)*(o-1);if(i<0||i>o-1)for(let n=0;n<p;n++)for(let s=0;s<u;s++){const r=s+n*b[2]+e*b[1]+t*b[0];d.values[r]=a}else if("bilinear"===r){const n=Math.floor(i),r=Math.ceil(i),o=i-n;for(let i=0;i<p;i++){const c=p>1?s*(l-1)+i*k:.5*(s+x)*(l-1);if(c<0||c>l-1){for(let n=0;n<u;n++){const s=n+i*b[2]+e*b[1]+t*b[0];d.values[s]=a}continue}const h=Math.floor(c),f=Math.ceil(c),m=c-h;for(let s=0;s<u;s++){let a=s+h*y[2]+n*y[1]+w*y[0];const l=g[a];a=s+f*y[2]+n*y[1]+w*y[0];const u=g[a];a=s+h*y[2]+r*y[1]+w*y[0];const c=g[a];a=s+f*y[2]+r*y[1]+w*y[0];const p=l+(u-l)*m,x=c+(g[a]-c)*m;a=s+i*b[2]+e*b[1]+t*b[0],d.values[a]=p+(x-p)*o}}}else for(let n=0;n<p;++n){const r=p>1?s*(l-1)+n*k:.5*(s+x)*(l-1);if(r<0||r>l-1){for(let s=0;s<u;s++){const r=s+n*b[2]+e*b[1]+t*b[0];d.values[r]=a}continue}const o=Math.round(r),c=Math.round(i);for(let s=0;s<u;s++){const r=s+o*y[2]+c*y[1]+w*y[0],a=s+n*b[2]+e*b[1]+t*b[0];d.values[a]=g[r]}}}}return d.toTensor()}sparseToDense(t,e,n,s){const{sliceRank:r,numUpdates:a,sliceSize:i,strides:o,outputSize:l}=vn(0,t,n);return this.scatter(t,e,n,l,i,a,r,o,s,!1)}gatherND(t,e){const n=e.shape,s=n[n.length-1],[r,a,i,o]=yn(t,e);if(0===a)return re([],r,t.dtype);const l=new Nt([a,i],t.dtype),u=this.readSync(e.dataId),c=this.readSync(t.dataId);for(let e=0;e<a;e++){const n=[];let r=0;for(let t=0;t<s;t++){const a=u[e*s+t];r+=a*o[t],n.push(a)}if(r<0||r>=t.size/i)throw new Error(`Invalid indices: ${n} does not index into ${t.shape}`);for(let t=0;t<i;t++)l.values[e*i+t]=c[r*i+t]}return l.toTensor().reshape(r)}scatterND(t,e,n){const{sliceRank:s,numUpdates:r,sliceSize:a,strides:i,outputSize:o}=vn(0,t,n),l=Jr(0);return this.scatter(t,e,n,o,a,r,s,i,l,!0)}onesLike(t){if("string"===t.dtype)throw new Error("onesLike is not supported for string tensors");return zr(t.shape,1,t.dtype)}zerosLike(t){const e=k(t.dtype,p(t.shape));return this.makeOutput(e,t.shape,t.dtype)}linspace(t,e,n){return ru(t,e,n)}scatter(t,e,n,s,r,a,i,o,l,u){const c=[s/r,r],h=this.readSync(t.dataId),p=this.readSync(e.dataId);if(0===s)return re([],n,e.dtype);const d=new Nt(c,e.dtype);d.values.fill(this.readSync(l.dataId)[0]);for(let t=0;t<a;t++){const a=[];let l=0;for(let e=0;e<i;e++){const n=h[t*i+e];a.push(n),l+=n*o[e]}if(l<0||l>=s/r)throw new Error(`Invalid indices: ${a} does not index into ${n}`);for(let n=0;n<r;n++)u?d.values[l*r+n]+=p[t*r+n]:d.values[l*r+n]=0===e.rank?p[0]:p[t*r+n]}return d.toTensor().reshape(n)}}function _b(t){const e=new Float32Array(t.length);for(let n=0;n<t.length;++n)e[n]=Math.abs(t[n]);return e}const Fb={kernelName:"Abs",backendName:"cpu",kernelFunc:t=>{const{x:e}=t.inputs,n=t.backend;let s=new Float32Array(p(e.shape));if("complex64"!==e.dtype){s=_b(n.data.get(e.dataId).values)}else{const t=n.data.get(e.dataId),r=t.complexTensorInfos.real,a=t.complexTensorInfos.imag,i=n.data.get(r.dataId).values,o=n.data.get(a.dataId).values;for(let t=0;t<i.length;t++){const e=i[t],n=o[t];s[t]=Math.hypot(e,n)}}return n.makeOutput(s,e.shape,"float32")}};function Ob(t){return(e,n,s,r,a)=>{const i=Cr(e,n),o=i.length,l=O(i),u=v(a,p(i)),c=e.length,h=n.length,d=O(e),f=O(n),m=Nr(e,i),g=Nr(n,i);if(m.length+g.length===0)for(let e=0;e<u.length;++e)u[e]=t(s[e%s.length],r[e%r.length]);else for(let e=0;e<u.length;++e){const n=V(e,o,l),a=n.slice(-c);m.forEach(t=>a[t]=0);const i=W(a,c,d),p=n.slice(-h);g.forEach(t=>p[t]=0);const y=W(p,h,f);u[e]=t(s[i],r[y])}return[u,i]}}function Mb(t){const{inputs:e,backend:n}=t,{real:s,imag:r}=e,a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,o=n.makeTensorInfo(s.shape,"complex64");return n.data.get(o.dataId).complexTensorInfos={real:n.makeTensorInfo(s.shape,"float32",a),imag:n.makeTensorInfo(r.shape,"float32",i)},o}const Lb={kernelName:"Complex",backendName:"cpu",kernelFunc:Mb};function zb(t){const{inputs:e,backend:n}=t,{x:s}=e;return n.incRef(s.dataId),{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}const Bb={kernelName:"Identity",backendName:"cpu",kernelFunc:zb};function Pb(t){const{inputs:e,backend:n}=t,{input:s}=e,r=n.data.get(s.dataId).complexTensorInfos.real,a=n.data.get(r.dataId).values;return n.makeTensorInfo(r.shape,r.dtype,a)}const Wb={kernelName:"Real",backendName:"cpu",kernelFunc:Pb};function Vb(t){const{inputs:e,backend:n,attrs:s}=t,{x:r}=e,{dtype:a}=s;if("complex64"===a){if("complex64"===r.dtype)return zb({inputs:{x:r},backend:n});const t=Na(r.shape),e=Vb({inputs:{x:r},backend:n,attrs:{dtype:"float32"}}),s=Mb({inputs:{real:e,imag:t},backend:n});return t.dispose(),n.disposeIntermediateTensorInfo(e),s}if("complex64"===r.dtype){const t=Pb({inputs:{input:r},backend:n}),e=Vb({inputs:{x:t},backend:n,attrs:{dtype:a}});return n.disposeIntermediateTensorInfo(t),e}if(!C(r.dtype,a)){const t=zb({inputs:{x:r},backend:n});return{dataId:t.dataId,shape:t.shape,dtype:a}}if("int32"===a){const t=n.data.get(r.dataId).values,e=Int32Array.from(t);return n.makeTensorInfo(r.shape,"int32",e)}if("bool"===a){const t=n.data.get(r.dataId).values,e=ct([0],r.dtype),[s,a]=Ob((t,e)=>t!==e?1:0)(r.shape,[],t,e,"bool");return n.makeTensorInfo(a,"bool",s)}throw new Error(`Error in Cast: failed to cast ${r.dtype} to ${a}`)}const Ub={kernelName:"Cast",backendName:"cpu",kernelFunc:Vb};function Gb(t,e,n,s){return null==n?({inputs:n,backend:r})=>{const{a:a,b:i}=n,o=r;Sb([a,i],t);const l=o.data.get(a.dataId).values,u=o.data.get(i.dataId).values,c=s||a.dtype,[h,p]=e(a.shape,i.shape,l,u,c);return o.makeTensorInfo(p,c,h)}:({inputs:t,backend:r})=>{const{a:a,b:i}=t,o=r;if("complex64"===a.dtype||"complex64"===i.dtype){const t=Vb({inputs:{x:a},backend:o,attrs:{dtype:"complex64"}}),e=o.data.get(t.dataId),s=e.complexTensorInfos.real,r=e.complexTensorInfos.imag,l=o.data.get(s.dataId).values,u=o.data.get(r.dataId).values,c=Vb({inputs:{x:i},backend:o,attrs:{dtype:"complex64"}}),h=o.data.get(c.dataId),p=h.complexTensorInfos.real,d=h.complexTensorInfos.imag,f=o.data.get(p.dataId).values,m=o.data.get(d.dataId).values,[g,y,b]=n(a.shape,i.shape,l,u,f,m),x=o.makeTensorInfo(b,"float32",g),w=o.makeTensorInfo(b,"float32",y),v=Mb({inputs:{real:x,imag:w},backend:o});return o.disposeIntermediateTensorInfo(t),o.disposeIntermediateTensorInfo(c),o.disposeIntermediateTensorInfo(x),o.disposeIntermediateTensorInfo(w),v}{const t=o.data.get(a.dataId).values,n=o.data.get(i.dataId).values,r=s||a.dtype,[l,u]=e(a.shape,i.shape,t,n,r);return o.makeTensorInfo(u,r,l)}}}function Hb(t){return(e,n,s,r,a,i)=>{const o=Cr(e,n),l=p(o),u=o.length,c=O(o),h=v("float32",l),d=v("float32",l),f=Nr(e,o),m=Nr(n,o),g=Xl(s,r),y=Xl(a,i),b=e.length,x=O(e),w=n.length,k=O(n);if(f.length+m.length===0)for(let e=0;e<h.length;e++){const n=e%g.length,s=e%y.length,r=t(g[2*n],g[2*n+1],y[2*s],y[2*s+1]);h[e]=r.real,d[e]=r.imag}else for(let e=0;e<h.length;e++){const n=V(e,u,c),s=n.slice(-b);f.forEach(t=>s[t]=0);const r=W(s,b,x),a=n.slice(-w);m.forEach(t=>a[t]=0);const i=W(a,w,k),o=t(g[2*r],g[2*r+1],y[2*i],y[2*i+1]);h[e]=o.real,d[e]=o.imag}return[h,d,o]}}const jb=Ob((t,e)=>t+e),qb=Hb((t,e,n,s)=>({real:t+n,imag:e+s})),Kb=Gb(X,jb,qb),Xb={kernelName:X,backendName:"cpu",kernelFunc:Kb};function Yb(t){return(e,n,s)=>{const r=v(n,e.length);for(let n=0;n<e.length;++n)r[n]=t(e[n],s);return r}}function Jb(t,e,n){return({inputs:s,attrs:r,backend:a})=>{const{x:i}=s;if(Sb(i,t),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const o=a,l=o.data.get(i.dataId).values,u=p(i.shape),c=n||i.dtype,h=k(c,u);for(let t=0;t<u;++t)h[t]=e(l[t],r);return o.makeTensorInfo(i.shape,c,h)}}function Zb(t,e,n){return({inputs:s,attrs:r,backend:a})=>{const{x:i}=s;if(Sb(i,t),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const o=a,l=o.data.get(i.dataId).values,u=n||i.dtype,c=e(l,u,r);return o.makeTensorInfo(i.shape,u,c)}}const Qb=Yb(t=>Math.ceil(t)),tx={kernelName:"Ceil",backendName:"cpu",kernelFunc:Zb("Ceil",Qb)},ex=Yb(t=>Math.exp(t)),nx={kernelName:"Exp",backendName:"cpu",kernelFunc:Zb("Exp",ex)},sx=Yb(t=>Math.expm1(t)),rx={kernelName:"Expm1",backendName:"cpu",kernelFunc:Zb("Expm1",sx)},ax=Yb(t=>Math.floor(t)),ix={kernelName:"Floor",backendName:"cpu",kernelFunc:Zb("Floor",ax)},ox=Yb(t=>Math.log(t)),lx={kernelName:"Log",backendName:"cpu",kernelFunc:Zb("Log",ox)};function ux(t,e,n,s){const r=v(s,p(n));for(let n=0;n<r.length;++n){const s=n*e;let a=t[s];for(let n=0;n<e;++n){const e=t[s+n];e>a&&(a=e)}r[n]=a}return r}const cx=Ob((t,e)=>t*e),hx=Gb("Multiply",cx,Hb((t,e,n,s)=>({real:t*n-e*s,imag:t*s+e*n}))),px={kernelName:"Multiply",backendName:"cpu",kernelFunc:hx},dx=Ob((t,e)=>t!==e?1:0),fx={kernelName:"NotEqual",backendName:"cpu",kernelFunc:Gb("NotEqual",dx,null,"bool")},mx=Yb(t=>1/Math.sqrt(t)),gx={kernelName:"Rsqrt",backendName:"cpu",kernelFunc:Zb("Rsqrt",mx)};function yx(t,e,n,s,r){const a=On(s,e,n),i=p(n),o=O(s);if(a){const n=Mn(e,o);return t.subarray(n,n+i)}const l=v(r,i);for(let r=0;r<i;++r){const a=W(V(r,n.length,O(n)).map((t,n)=>t+e[n]),s.length,o);l[r]=t[a]}return l}function bx(t){const{inputs:e,backend:n,attrs:s}=t,{x:r}=e,{begin:a,size:i}=s;Sb(r,"slice");const[o,l]=Ln(r,a,i);Nn(r,o,l);const u=yx(n.data.get(r.dataId).values,o,l,r.shape,r.dtype);return n.makeTensorInfo(l,r.dtype,u)}const xx={kernelName:"Slice",backendName:"cpu",kernelFunc:bx},wx=Ob((t,e)=>{const n=t-e;return n*n}),vx={kernelName:"SquaredDifference",backendName:"cpu",kernelFunc:Gb("SquaredDifference",wx)},kx=Ob((t,e)=>t-e),Nx=Hb((t,e,n,s)=>({real:t-n,imag:e-s})),Ix=Gb(Q,kx,Nx),Cx={kernelName:Q,backendName:"cpu",kernelFunc:Ix};function Sx(t,e,n,s,r){const a=e.length,i=p(e),o=O(e),l=O(r),u=v(n,p(r));for(let e=0;e<i;++e){const n=V(e,a,o),r=new Array(n.length);for(let t=0;t<r.length;t++)r[t]=n[s[t]];u[W(r,a,l)]=t[e]}return u}function Tx(t,e,n,s){const r=x(e,n)[0],a=[1,n[0],1];for(let t=0;t<r;t++)a[0]*=n[t];a[1]=n[r];for(let t=r+1;t<n.length;t++)a[2]*=n[t];const i={},o=new Int32Array(n[r]),l=new Nt(a,s,t),u=[],c=1===a[0]&&1===a[2];for(let e=0;e<n[r];e++){let n;if(c)n=t[e].toString();else{const t=[];for(let n=0;n<a[0];n++)for(let s=0;s<a[2];s++)t.push(l.get(n,e,s));n=t.join(",")}if(void 0!==i[n])o[e]=i[n];else{const t=Object.keys(i).length;i[n]=t,o[e]=t,u.push(e)}}const h=a.slice();h[1]=Object.keys(i).length;const p=new Nt(h,s);u.forEach((t,e)=>{for(let n=0;n<a[0];n++)for(let s=0;s<a[2];s++)p.set(l.get(n,t,s),n,e,s)});const d=n.slice();return d[r]=h[1],{outputValues:p.values,outputShape:d,indices:o}}var Ex=Object.freeze({__proto__:null,simpleAbsImpl:_b,addImpl:jb,ceilImpl:Qb,expImpl:ex,expm1Impl:sx,floorImpl:ax,logImpl:ox,maxImpl:ux,multiplyImpl:cx,notEqualImpl:dx,rsqrtImpl:mx,sliceImpl:yx,squaredDifferenceImpl:wx,subImpl:kx,transposeImpl:Sx,uniqueImpl:Tx});es("cpu",()=>new Db,1);const $x=Jb("Elu",t=>t>=0?t:Math.exp(t)-1),Ax={kernelName:"Elu",backendName:"cpu",kernelFunc:$x},Rx=Ob((t,e)=>t<0?e*t:t);function Dx(t){const{inputs:e,backend:n}=t,{x:s,alpha:r}=e;Sb([s,r],"prelu");const a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,[o,l]=Rx(s.shape,r.shape,a,i,s.dtype);return n.makeTensorInfo(l,s.dtype,o)}const _x={kernelName:"Prelu",backendName:"cpu",kernelFunc:Dx},Fx=Jb("Relu",t=>Math.max(0,t)),Ox={kernelName:"Relu",backendName:"cpu",kernelFunc:Fx},Mx=Jb("Relu6",t=>Math.min(Math.max(0,t),6)),Lx={kernelName:"Relu6",backendName:"cpu",kernelFunc:Mx};function zx(t,e,n,s){if("linear"===n)return zb({inputs:{x:e},backend:t});if("relu"===n)return Fx({inputs:{x:e},backend:t});if("elu"===n)return $x({inputs:{x:e},backend:t});if("relu6"===n)return Mx({inputs:{x:e},backend:t});if("prelu"===n)return Dx({inputs:{x:e,alpha:s},backend:t});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function Bx(t){const{inputs:e,backend:n,attrs:s}=t,{x:r}=e,{shape:a}=s,i=p(r.shape),o=b(a,i),u=p(o);l(i===u,()=>`The new shape (${o}) has ${u} elements and the old shape (${r.shape}) has ${i} elements. The new shape and old shape must have the same number of elements.`),n.incRef(r.dataId);const c=n.data.get(r.dataId);if(null!=c.complexTensorInfos){const t=c.complexTensorInfos.real,e=c.complexTensorInfos.imag;t.shape=o,e.shape=o}return{dataId:r.dataId,shape:o,dtype:r.dtype}}const Px={kernelName:"Reshape",backendName:"cpu",kernelFunc:Bx};function Wx(t){const{inputs:e,backend:n,attrs:s}=t,{a:r,b:a}=e,{transposeA:i,transposeB:o}=s;Sb([r,a],"matMul");const u=r.shape.length,c=a.shape.length,h=i?r.shape[u-2]:r.shape[u-1],d=o?a.shape[c-1]:a.shape[c-2],f=i?r.shape[u-1]:r.shape[u-2],m=o?a.shape[c-2]:a.shape[c-1],g=r.shape.slice(0,-2),y=a.shape.slice(0,-2),b=p(g),x=p(y);l(u>=2&&c>=2&&(b===x||1===b||1===x),()=>`Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of (${g}) and (${y}).`);const w=(b>x?r.shape.slice(0,-2):a.shape.slice(0,-2)).concat([f,m]);l(h===d,()=>`Error in matMul: inner shapes (${h}) and (${d}) of Tensors with shapes ${r.shape} and ${a.shape} and transposeA=${i} and transposeB=${o} must match.`);const v=o?[x,m,d]:[x,d,m],k=Bx({inputs:{x:r},backend:n,attrs:{shape:i?[b,h,f]:[b,f,h]}}),N=Bx({inputs:{x:a},backend:n,attrs:{shape:v}}),I=i?k.shape[1]:k.shape[2],C=i?k.shape[2]:k.shape[1],S=o?N.shape[1]:N.shape[2],T=Math.max(b,x),E=n.data.get(k.dataId).values,$=n.data.get(N.dataId).values,A=O(k.shape),R=O(N.shape),[D,_,F]=i?[A[0],1,A[1]]:[A[0],A[1],1],[M,L,z]=o?[1,R[1],R[0]]:[R[1],1,R[0]],B=C*S,P=We([T,C,S],k.dtype),W=P.values,V=n.blockSize;for(let t=0;t<T;t++)for(let e=0;e<C;e+=V)for(let n=0;n<S;n+=V)for(let s=0;s<I;s+=V){const r=Math.min(e+V,C),a=Math.min(n+V,S),i=Math.min(s+V,I);for(let o=e;o<r;o++)for(let e=n;e<a;e++){let n=0;for(let r=s;r<i;r++){const s=Math.min(t,b-1)*D,a=Math.min(t,x-1)*z;n+=E[s+o*_+r*F]*$[r*M+e*L+a]}W[t*B+(o*S+e)]+=n}}return n.disposeIntermediateTensorInfo(k),n.disposeIntermediateTensorInfo(N),n.makeTensorInfo(w,P.dtype,P.values)}const Vx={kernelName:"BatchMatMul",backendName:"cpu",kernelFunc:Wx};const Ux={kernelName:"_FusedMatMul",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{a:r,b:a,bias:i,preluActivationWeights:o}=e,{transposeA:l,transposeB:u,activation:c}=s;let h,p,d;const f=[];h=Wx({inputs:{a:r,b:a},attrs:{transposeA:l,transposeB:u},backend:n}),i&&(p=Kb({inputs:{a:h,b:i},backend:n}),f.push(h),h=p),c&&(d=zx(n,h,c,o),f.push(h),h=d);for(const t of f)n.disposeIntermediateTensorInfo(t);return h}},Gx={kernelName:"Acos",backendName:"cpu",kernelFunc:Jb("Acos",t=>Math.acos(t))},Hx={kernelName:"Acosh",backendName:"cpu",kernelFunc:Jb("Acosh",t=>Math.acosh(t))},jx={kernelName:"Asin",backendName:"cpu",kernelFunc:Jb("Asin",t=>Math.asin(t))},qx={kernelName:"Asinh",backendName:"cpu",kernelFunc:Jb("Asinh",t=>Math.asinh(t))},Kx={kernelName:"Atan",backendName:"cpu",kernelFunc:Jb("Atan",t=>Math.atan(t))},Xx={kernelName:"Atanh",backendName:"cpu",kernelFunc:Jb("Atanh",t=>Math.atanh(t))};function Yx(t,e,n,s,r,a){const i=r.strideHeight,o=r.strideWidth,l=r.dilationHeight,u=r.dilationWidth,c=r.effectiveFilterHeight,h=r.effectiveFilterWidth,p=r.padInfo.top,d=r.padInfo.left,f="max"===a?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,m=We(r.outShape,n),g=m.values,y=r.outShape[1]*r.outShape[2]*r.outShape[3],b=r.outShape[2]*r.outShape[3],x=r.outShape[3];for(let e=0;e<r.batchSize;++e){const n=e*y,m=e*s[0];for(let e=0;e<r.inChannels;++e)for(let y=0;y<r.outHeight;++y){const w=y*i-p,v=Math.max(0,w),k=Math.min(r.inHeight,c+w),N=n+y*b;for(let n=0;n<r.outWidth;++n){const i=n*o-d,c=Math.max(0,i),p=Math.min(r.inWidth,h+i);let y=f,b=0,w=0;for(let n=v;n<k;n+=l){const r=m+n*s[1];for(let n=c;n<p;n+=u){const i=t[r+n*s[2]+e];"max"===a&&i>y?y=i:"avg"===a&&(b+=i,w++)}if(isNaN(y))break}g[N+n*x+e]="avg"===a?b/w:y}}}return m}function Jx(t,e,n,s,r=!1,a=!1){const i=We(s.outShape,"int32"),o=s.strideHeight,l=s.strideWidth,u=s.dilationHeight,c=s.dilationWidth,h=s.effectiveFilterHeight,p=s.effectiveFilterWidth,d=s.padInfo.top,f=s.padInfo.left,m=We(e,n,t);for(let t=0;t<s.batchSize;++t)for(let e=0;e<s.inChannels;++e)for(let n=0;n<s.outHeight;++n){const g=n*o-d;let y=g;for(;y<0;)y+=u;const b=Math.min(s.inHeight,h+g);for(let o=0;o<s.outWidth;++o){const h=o*l-f;let d=h;for(;d<0;)d+=c;const x=Math.min(s.inWidth,p+h);let w=Number.NEGATIVE_INFINITY,v=-1;for(let n=y;n<b;n+=u){const i=n-g;for(let o=d;o<x;o+=c){const l=o-h,u=m.get(t,n,o,e);u>w&&(w=u,v=r?a?((t*s.inHeight+n)*s.inWidth+o)*s.inChannels+e:(n*s.inWidth+o)*s.inChannels+e:i*p+l)}}i.set(v,t,n,o,e)}}return i}const Zx={kernelName:"AvgPool",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r}=e;Sb(r,"avgPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:u}=s;l(Bs(i,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`);const c=$s(r.shape,a,i,1,o,u);let h;if(1===c.filterWidth&&1===c.filterHeight&&d(c.inShape,c.outShape))h=zb({inputs:{x:r},backend:n});else{const t=n.data.get(r.dataId).values,e=O(r.shape),s=Yx(t,r.shape,r.dtype,e,c,"avg");h=n.makeTensorInfo(c.outShape,r.dtype,s.values)}return h}};const Qx={kernelName:"AvgPoolBackprop",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{dy:r,input:a}=e,i=a;Sb([r,a],"avgPoolBackprop");const{filterSize:o,strides:l,pad:u}=s,c=$s(i.shape,o,l,1,u),h=c.strideHeight,p=c.strideWidth,d=c.filterHeight,f=c.filterWidth,m=c.dilationHeight,g=c.dilationWidth,y=c.effectiveFilterHeight,b=c.effectiveFilterWidth,x=b-1-c.padInfo.left,w=y-1-c.padInfo.top,v=We(i.shape,"float32"),k=1/(d*f),N=n.data.get(r.dataId).values,I=We(r.shape,"float32",N);for(let t=0;t<c.batchSize;++t)for(let e=0;e<c.inChannels;++e)for(let n=0;n<c.inHeight;++n)for(let s=0;s<c.inWidth;++s){const r=n-w,a=s-x;let i=0;for(let n=0;n<y;n+=m){const s=(r+n)/h;if(!(s<0||s>=c.outHeight||Math.floor(s)!==s))for(let n=0;n<b;n+=g){const r=(a+n)/p;r<0||r>=c.outWidth||Math.floor(r)!==r||(i+=I.get(t,s,r,e))}}v.set(i*k,t,n,s,e)}return n.makeTensorInfo(v.shape,v.dtype,v.values)}};const tw={kernelName:"FusedBatchNorm",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r,scale:a,offset:i,mean:o,variance:u}=e;l(o.shape.length===u.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),l(null==i||o.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),l(null==a||o.shape.length===a.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks."),Sb([r,o,u,a,i],"batchNorm");let{varianceEpsilon:c}=s;null==c&&(c=.001);const h=n.data.get(r.dataId).values,p=n.data.get(o.dataId).values,d=n.data.get(u.dataId).values,f=a?n.data.get(a.dataId).values:new Float32Array([1]),m=i?n.data.get(i.dataId).values:new Float32Array([0]),g=new Float32Array(h.length),y=m.length,b=f.length,x=d.length,w=p.length;let v=0,k=0,N=0,I=0;for(let t=0;t<h.length;++t)g[t]=m[v++]+(h[t]-p[k++])*f[N++]/Math.sqrt(d[I++]+c),v>=y&&(v=0),k>=w&&(k=0),N>=b&&(N=0),I>=x&&(I=0);return n.makeTensorInfo(r.shape,r.dtype,g)}},ew={kernelName:"ClipByValue",backendName:"cpu",kernelFunc:Jb("ClipByValue",(t,e)=>{const n=e;return t>n.clipValueMax?n.clipValueMax:t<n.clipValueMin?n.clipValueMin:t})};function nw(t){const{inputs:e,backend:n}=t,{input:s}=e,r=n.data.get(s.dataId).complexTensorInfos.imag,a=n.data.get(r.dataId).values;return n.makeTensorInfo(r.shape,r.dtype,a)}const sw={kernelName:"Imag",backendName:"cpu",kernelFunc:nw};function rw(t){const{inputs:e,backend:n,attrs:s}=t,{axis:r}=s,a=x(r,e[0].shape)[0];let i=Gs(e.map(t=>t.shape),a);if(0===p(i))return n.makeTensorInfo(i,e[0].dtype,[]);const o=e.filter(t=>p(t.shape)>0);if(1===o.length)return o[0];if(Us(o.map(t=>t.shape),a),"complex64"===o[0].dtype){const t=o.map(t=>Pb({inputs:{input:t},backend:n})),e=o.map(t=>nw({inputs:{input:t},backend:n})),s=rw({inputs:t,backend:n,attrs:{axis:a}}),r=rw({inputs:e,backend:n,attrs:{axis:a}}),i=Mb({inputs:{real:s,imag:r},backend:n});return t.forEach(t=>n.disposeIntermediateTensorInfo(t)),e.forEach(t=>n.disposeIntermediateTensorInfo(t)),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),i}const l=o.map(t=>{const e=p(t.shape.slice(a));return Bx({inputs:{x:t},backend:n,attrs:{shape:[-1,e]}})});i=Gs(l.map(t=>t.shape),1);const u=v(o[0].dtype,p(i));if(1===l[0].shape[0]){let t=0;l.forEach(e=>{const s=n.data.get(e.dataId).values,r=p(e.shape);u.set(s,t),t+=r})}else{let t=0;l.forEach(e=>{const s=n.data.get(e.dataId).values;let r=0;for(let n=0;n<e.shape[0];++n){const a=n*i[1]+t;for(let t=0;t<e.shape[1];++t)u[a+t]=s[r++]}t+=e.shape[1]})}const c=Gs(o.map(t=>t.shape),a),h=n.makeTensorInfo(c,e[0].dtype,u);return l.forEach(t=>n.disposeIntermediateTensorInfo(t)),h}const aw={kernelName:"Concat",backendName:"cpu",kernelFunc:rw};function iw(t){const{inputs:e,backend:n,attrs:s}=t,{x:r,filter:a}=e,{strides:i,pad:o,dataFormat:l,dilations:u,dimRoundingMode:c}=s;Sb([r,a],"conv2d");const h=Ps(l),p=Rs(r.shape,a.shape,i,u,o,c,!1,h),d=p.filterHeight,f=p.filterWidth,m=p.dilationHeight,g=p.dilationWidth,y=p.padInfo.left,b=p.padInfo.top,x="channelsLast"===p.dataFormat,w=new Nt(p.outShape,r.dtype),v=O(r.shape),k=O(a.shape),N=v[0],I=x?v[1]:v[2],C=x?v[2]:1,S=x?1:v[1],T=w.strides[0],E=x?w.strides[1]:w.strides[2],$=x?w.strides[2]:1,A=x?1:w.strides[1],R=n.data.get(r.dataId).values,D=n.data.get(a.dataId).values,_=w.values;for(let t=0;t<p.batchSize;++t){const e=t*N,n=t*T;for(let t=0;t<p.outHeight;++t){const s=n+t*E,r=t*p.strideHeight-b;for(let t=0;t<d;++t){const n=r+t*m;if(n<0||n>=p.inHeight)continue;const a=t*k[0],i=e+n*I;for(let t=0;t<p.outWidth;++t){const e=s+t*$,n=t*p.strideWidth-y;for(let t=0;t<f;++t){const s=n+t*g;if(s<0||s>=p.inWidth)continue;const r=i+s*C;let o=a+t*k[1];for(let t=0;t<p.inChannels;++t){const n=R[r+t*S];for(let t=0;t<p.outChannels;++t)_[e+t*A]+=n*D[o+t];o+=p.outChannels}}}}}}return n.makeTensorInfo(w.shape,w.dtype,_)}const ow={kernelName:"Conv2D",backendName:"cpu",kernelFunc:iw};const lw={kernelName:"Conv2DBackpropFilter",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r,dy:a}=e,{strides:i,pad:o,dataFormat:l,dimRoundingMode:u,filterShape:c}=s;Sb([r,a],"conv2dBackpropFilter");const h=Ps(l),p=Rs(r.shape,c,i,1,o,u,!1,h),{strideHeight:d,strideWidth:f,filterHeight:m,filterWidth:g}=p,y="channelsLast"===p.dataFormat,b=new Nt(p.filterShape,"float32"),x=p.padInfo.left,w=p.padInfo.top,v=n.data.get(r.dataId).values,k=n.data.get(a.dataId).values,N=new Nt(r.shape,r.dtype,v),I=new Nt(a.shape,a.dtype,k);for(let t=0;t<m;++t){const e=Math.max(0,Math.ceil((w-t)/d)),n=Math.min(p.outHeight,(p.inHeight+w-t)/d);for(let s=0;s<g;++s){const r=Math.max(0,Math.ceil((x-s)/f)),a=Math.min(p.outWidth,(p.inWidth+x-s)/f);for(let i=0;i<p.inChannels;++i)for(let o=0;o<p.outChannels;++o){let l=0;for(let u=0;u<p.batchSize;++u)for(let c=e;c<n;++c){const e=t+c*d-w;for(let t=r;t<a;++t){const n=s+t*f-x;l+=y?N.get(u,e,n,i)*I.get(u,c,t,o):N.get(u,i,e,n)*I.get(u,o,c,t)}}b.set(l,t,s,i,o)}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const uw={kernelName:"Conv2DBackpropInput",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{dy:r,filter:a}=e,{inputShape:i,strides:o,pad:l,dataFormat:u,dimRoundingMode:c}=s;Sb([r,a],"conv2dBackpropInput");const h=O(a.shape),p=O(r.shape);let d=Ps(u);const f=Rs(i,a.shape,o,1,l,c,!1,d),m=new Nt(f.inShape,"float32"),g=m.values,y=n.data.get(r.dataId).values,b=n.data.get(a.dataId).values,[x,w,v]=h,{batchSize:k,filterHeight:N,filterWidth:I,inChannels:C,inHeight:S,inWidth:T,outChannels:E,outHeight:$,outWidth:A,strideHeight:R,strideWidth:D}=f;d=f.dataFormat;const _=N-1-f.padInfo.top,F=I-1-f.padInfo.left,M="channelsLast"===d,L=m.strides[0],z=M?m.strides[1]:m.strides[2],B=M?m.strides[2]:1,P=M?1:m.strides[1],W=p[0],V=M?p[1]:p[2],U=M?p[2]:1,G=M?1:p[1];for(let t=0;t<k;++t)for(let e=0;e<C;++e)for(let n=0;n<S;++n){const s=n-_,r=Math.max(0,Math.ceil(s/R)),a=Math.min($,(N+s)/R);for(let i=0;i<T;++i){const o=i-F,l=Math.max(0,Math.ceil(o/D)),u=Math.min(A,(I+o)/D);let c=0;for(let n=r;n<a;++n){const r=n*R-s;for(let s=l;s<u;++s){const a=W*t+V*n+U*s,i=x*(N-1-r)+w*(I-1-(s*D-o))+v*e;for(let t=0;t<E;++t){c+=y[a+G*t]*b[i+t]}}}g[L*t+z*n+B*i+P*e]=c}}return n.makeTensorInfo(m.shape,m.dtype,m.values)}};const cw={kernelName:"Conv3D",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r,filter:a}=e,{strides:i,pad:o,dilations:l}=s;Sb([r,a],"conv3d");const u=Ds(r.shape,a.shape,i,l,o),{filterDepth:c,filterHeight:h,filterWidth:p,dilationDepth:d,dilationHeight:f,dilationWidth:m,padInfo:g}=u,y=g.front,b=g.left,x=g.top,w=new Nt(u.outShape,r.dtype),v=n.data.get(r.dataId).values,k=n.data.get(a.dataId).values,N=w.values,I=O(r.shape),C=O(a.shape);for(let t=0;t<u.batchSize;++t){const e=t*I[0],n=t*w.strides[0];for(let t=0;t<u.outDepth;++t){const s=n+t*w.strides[1],r=t*u.strideDepth-y;for(let t=0;t<c;++t){const n=r+t*d;if(n<0||n>=u.inDepth)continue;const a=t*C[0],i=e+n*I[1];for(let t=0;t<u.outHeight;++t){const e=s+t*w.strides[2],n=t*u.strideHeight-x;for(let t=0;t<h;++t){const s=n+t*f;if(s<0||s>=u.inHeight)continue;const r=a+t*C[1],o=i+s*I[2];for(let t=0;t<u.outWidth;++t){const n=e+t*u.outChannels,s=t*u.strideWidth-b;for(let t=0;t<p;++t){const e=s+t*m;if(e<0||e>=u.inWidth)continue;const a=r+t*C[2],i=o+e*u.inChannels;let l=a;for(let t=0;t<u.inChannels;++t){const e=v[i+t];for(let t=0;t<u.outChannels;++t)N[n+t]+=e*k[l+t];l+=u.outChannels}}}}}}}}return n.makeTensorInfo(w.shape,w.dtype,w.values)}};const hw={kernelName:"Conv3DBackpropFilterV2",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r,dy:a}=e,{strides:i,pad:o,filterShape:l}=s;Sb([r,a],"conv3dBackpropFilterV2");const u=O(r.shape),c=O(a.shape),h=Ds(r.shape,l,i,1,o),p=h.strideDepth,d=h.strideHeight,f=h.strideWidth,m=h.filterDepth,g=h.filterHeight,y=h.filterWidth,b=new Nt(h.filterShape,"float32"),x=b.values,[w,v,k,N]=b.strides,I=n.data.get(a.dataId).values,[C,S,T,E]=c,$=n.data.get(r.dataId).values,[A,R,D,_]=u,F=h.padInfo.front,M=h.padInfo.left,L=h.padInfo.top;for(let t=0;t<m;++t){const e=Math.max(0,Math.ceil((F-t)/p)),n=Math.min(h.outDepth,(h.inDepth+F-t)/p),s=t*w;for(let r=0;r<g;++r){const a=Math.max(0,Math.ceil((L-r)/d)),i=Math.min(h.outHeight,(h.inHeight+L-r)/d),o=r*v+s;for(let s=0;s<y;++s){const l=Math.max(0,Math.ceil((M-s)/f)),u=Math.min(h.outWidth,(h.inWidth+M-s)/f),c=s*k+o;for(let o=0;o<h.inChannels;++o){const m=o*N+c;for(let c=0;c<h.outChannels;++c){let g=0;for(let m=0;m<h.batchSize;++m){const h=m*A,y=m*C;for(let m=e;m<n;++m){const e=(t+m*p-F)*R+h,n=m*S+y;for(let t=a;t<i;++t){const a=(r+t*d-L)*D+e,i=t*T+n;for(let t=l;t<u;++t){const e=t*E+i;g+=$[(s+t*f-M)*_+a+o]*I[e+c]}}}}x[m+c]=g}}}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const pw={kernelName:"Conv3DBackpropInputV2",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{dy:r,filter:a}=e,{pad:i,strides:o,inputShape:l}=s;Sb([r],"conv3dBackpropInputV2");const u=O(r.shape),c=O(a.shape),h=Ds(l,a.shape,o,1,i),p=new Nt(h.inShape,"float32"),d=p.values,[f,m,g,y]=p.strides,b=n.data.get(r.dataId).values,[x,w,v,k]=u,N=n.data.get(a.dataId).values,[I,C,S,T]=c,{batchSize:E,filterDepth:$,filterHeight:A,filterWidth:R,inChannels:D,inDepth:_,inHeight:F,inWidth:M,outChannels:L,outDepth:z,outHeight:B,outWidth:P,strideDepth:W,strideHeight:V,strideWidth:U}=h,G=$-1-h.padInfo.front,H=A-1-h.padInfo.top,j=R-1-h.padInfo.left;for(let t=0;t<E;++t)for(let e=0;e<D;++e)for(let n=0;n<_;++n){const s=n-G,r=Math.max(0,Math.ceil(s/W)),a=Math.min(z,($+s)/W);for(let i=0;i<F;++i){const o=i-H,l=Math.max(0,Math.ceil(o/V)),u=Math.min(B,(A+o)/V);for(let c=0;c<M;++c){const h=c-j,p=Math.max(0,Math.ceil(h/U)),E=Math.min(P,(R+h)/U);let D=0;for(let n=r;n<a;++n){const r=n*W-s;for(let s=l;s<u;++s){const a=s*V-o;for(let i=p;i<E;++i){const o=x*t+w*n+v*s+k*i,l=I*($-1-r)+C*(A-1-a)+S*(R-1-(i*U-h))+T*e;for(let t=0;t<L;++t){D+=b[o+t]*N[l+t]}}}}d[f*t+m*n+g*i+y*c+e]=D}}}return n.makeTensorInfo(p.shape,p.dtype,p.values)}},dw=Jb(Y,t=>Math.cos(t)),fw={kernelName:Y,backendName:"cpu",kernelFunc:dw},mw={kernelName:"Cosh",backendName:"cpu",kernelFunc:Jb("Cosh",t=>Math.cosh(t))};function gw(t){const{inputs:e,backend:n,attrs:s}=t,{x:r,filter:a}=e,{strides:i,pad:o,dilations:u,dimRoundingMode:c}=s;Sb([r,a],"depthwiseConv2DNative");const h=O(r.shape),p=O(a.shape);let d=u;null==d&&(d=[1,1]),l(Bs(i,d),()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${i} and dilations '${d}'`);const f=Rs(r.shape,a.shape,i,d,o,c,!0),{filterHeight:m,filterWidth:g,dilationHeight:y,dilationWidth:b,padInfo:x}=f,w=x.left,v=x.top,k=f.outChannels/f.inChannels,N=new Nt(f.outShape,r.dtype),I=n.data.get(r.dataId).values,C=n.data.get(a.dataId).values,S=N.values;for(let t=0;t<f.batchSize;++t){const e=t*h[0],n=t*N.strides[0];for(let t=0;t<f.outHeight;++t){const s=n+t*N.strides[1],r=t*f.strideHeight-w;for(let t=0;t<m;++t){const n=r+t*y;if(n<0||n>=f.inHeight)continue;const a=t*p[0],i=e+n*h[1];for(let t=0;t<f.outWidth;++t){const e=s+t*N.strides[2],n=t*f.strideWidth-v;for(let t=0;t<g;++t){const s=n+t*b;if(s<0||s>=f.inWidth)continue;const r=a+t*p[1],o=i+s*f.inChannels;let l=e,u=r;for(let t=0;t<f.inChannels;++t){const e=I[o+t];for(let t=0;t<k;++t)S[l+t]+=e*C[u+t];l+=k,u+=k}}}}}}return n.makeTensorInfo(N.shape,N.dtype,N.values)}const yw={kernelName:"DepthwiseConv2dNative",backendName:"cpu",kernelFunc:gw};const bw={kernelName:"DepthwiseConv2dNativeBackpropFilter",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r,dy:a}=e,{strides:i,dilations:o,pad:l,dimRoundingMode:u,filterShape:c}=s;Sb([r,a],"depthwiseConv2dNativeBackpropFilter");const h=Rs(r.shape,c,i,o,l,u,!0),{strideHeight:p,strideWidth:d,filterHeight:f,filterWidth:m}=h,g=new Nt(h.filterShape,"float32"),y=h.padInfo.left,b=h.padInfo.top,x=h.outChannels/h.inChannels,w=n.data.get(r.dataId).values,v=new Nt(r.shape,r.dtype,w),k=n.data.get(a.dataId).values,N=new Nt(a.shape,a.dtype,k);for(let t=0;t<f;++t){const e=Math.max(0,Math.ceil((b-t)/p)),n=Math.min(h.outHeight,(h.inHeight+b-t)/p);for(let s=0;s<m;++s){const r=Math.max(0,Math.ceil((y-s)/d)),a=Math.min(h.outWidth,(h.inWidth+y-s)/d);for(let i=0;i<h.outChannels;++i){const o=Math.trunc(i/x),l=i%x;let u=0;for(let l=0;l<h.batchSize;++l)for(let c=e;c<n;++c){const e=t+c*p-b;for(let t=r;t<a;++t){const n=s+t*d-y;u+=v.get(l,e,n,o)*N.get(l,c,t,i)}}g.set(u,t,s,o,l)}}}return n.makeTensorInfo(g.shape,g.dtype,g.values)}};const xw={kernelName:"DepthwiseConv2dNativeBackpropInput",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{dy:r,filter:a}=e,{strides:i,dilations:o,pad:l,dimRoundingMode:u,inputShape:c}=s;Sb([r,a],"depthwiseConv2DNativeBackpropInput");const h=O(r.shape),p=O(a.shape),d=Rs(c,a.shape,i,o,l,u,!0),f=new Nt(d.inShape,"float32"),m=f.values,[g,y,b]=f.strides,x=n.data.get(r.dataId).values,[w,v,k]=h,N=n.data.get(a.dataId).values,[I,C,S]=p,{batchSize:T,filterHeight:E,filterWidth:$,inChannels:A,inHeight:R,inWidth:D,outChannels:_,outHeight:F,outWidth:M,strideHeight:L,strideWidth:z}=d,B=E-1-d.padInfo.top,P=$-1-d.padInfo.left,W=_/A;for(let t=0;t<T;++t)for(let e=0;e<A;++e)for(let n=0;n<R;++n){const s=n-B,r=Math.max(0,Math.ceil(s/L)),a=Math.min(F,(E+s)/L);for(let i=0;i<D;++i){const o=i-P,l=Math.max(0,Math.ceil(o/z)),u=Math.min(M,($+o)/z);let c=0;for(let n=r;n<a;++n){const r=n*L-s;for(let s=l;s<u;++s){const a=w*t+v*n+k*s,i=I*(E-1-r)+C*($-1-(s*z-o))+S*e;for(let t=0;t<W;++t){c+=x[a+(e*W+t)]*N[i+t]}}}m[g*t+y*n+b*i+e]=c}}return n.makeTensorInfo(f.shape,f.dtype,f.values)}},ww={kernelName:"Dilation2D",backendName:"cpu",kernelFunc:({inputs:t,backend:e,attrs:n})=>{const{x:s,filter:r}=t,{strides:a,pad:i,dilations:o}=n,l=e,u=l.data.get(s.dataId).values,c=s.shape.length,h=l.data.get(r.dataId).values,d=r.shape.length,{batchSize:f,inHeight:m,inWidth:g,inChannels:y,outHeight:b,outWidth:x,padInfo:w,strideHeight:v,strideWidth:N,filterHeight:I,filterWidth:C,dilationHeight:S,dilationWidth:T,outShape:E}=Es(s.shape,r.shape,a,i,"NHWC",o),$=p(E),A=E.length,R=k(s.dtype,$);for(let t=0;t<f;++t)for(let e=0;e<b;++e){const n=e*v-w.top;for(let a=0;a<x;++a){const i=a*N-w.left;for(let o=0;o<y;++o){let l=Number.MIN_SAFE_INTEGER;for(let e=0;e<I;++e){const a=n+e*S;if(a>=0&&a<m)for(let n=0;n<C;++n){const p=i+n*T;if(p>=0&&p<g){const i=W([t,a,p,o],c,O(s.shape)),f=W([e,n,o],d,O(r.shape)),m=u[i]+h[f];m>l&&(l=m)}}}R[W([t,e,a,o],A,O(E))]=l}}}return{dataId:l.write(ct(R,s.dtype),E,s.dtype),shape:E,dtype:s.dtype}}},vw={kernelName:"Dilation2DBackpropFilter",backendName:"cpu",kernelFunc:({inputs:t,backend:e,attrs:n})=>{const{x:s,filter:r,dy:a}=t,{strides:i,pad:o,dilations:u}=n,c=e,h=M(s.shape,c.data.get(s.dataId).values),p=M(r.shape,c.data.get(r.dataId).values),{batchSize:d,inHeight:f,inWidth:m,inChannels:g,outHeight:y,outWidth:b,padInfo:x,strideHeight:w,strideWidth:v,filterHeight:k,filterWidth:N,dilationHeight:I,dilationWidth:C,outShape:S}=Es(s.shape,r.shape,i,o,"NHWC",u);l(a.rank===S.length,()=>`Error in Dilation2DBackpropFilter, dy must have the same rank as output ${S.length}, but got `+a.rank);const T=M(S,c.data.get(a.dataId).values),E=B(r.shape,r.dtype);for(let t=0;t<d;++t)for(let e=0;e<y;++e){const n=e*w-x.top;for(let s=0;s<b;++s){const r=s*v-x.left;for(let a=0;a<g;++a){let i=Number.MIN_SAFE_INTEGER,o=0,l=0;for(let e=0;e<k;++e){const s=n+e*I;if(s>=0&&s<f)for(let n=0;n<N;++n){const u=r+n*C;if(u>=0&&u<m){const r=h[t][s][u][a]+p[e][n][a];r>i&&(i=r,o=e,l=n)}}}E[o][l][a]+=T[t][e][s][a]}}}return{dataId:c.write(ct(E,s.dtype),r.shape,r.dtype),shape:r.shape,dtype:r.dtype}}},kw={kernelName:"Dilation2DBackpropInput",backendName:"cpu",kernelFunc:({inputs:t,backend:e,attrs:n})=>{const{x:s,filter:r,dy:a}=t,{strides:i,pad:o,dilations:u}=n,c=e,h=M(s.shape,c.data.get(s.dataId).values),p=M(r.shape,c.data.get(r.dataId).values),{batchSize:d,inHeight:f,inWidth:m,inChannels:g,outHeight:y,outWidth:b,padInfo:x,strideHeight:w,strideWidth:v,filterHeight:k,filterWidth:N,dilationHeight:I,dilationWidth:C,outShape:S}=Es(s.shape,r.shape,i,o,"NHWC",u);l(a.rank===S.length,()=>`Error in Dilation2DBackpropInput, dy must have the same rank as output ${S.length}, but got `+a.rank);const T=M(S,c.data.get(a.dataId).values),E=B(s.shape,s.dtype);for(let t=0;t<d;++t)for(let e=0;e<y;++e){const n=e*w-x.top;for(let s=0;s<b;++s){const r=s*v-x.left;for(let a=0;a<g;++a){let i=Number.MIN_SAFE_INTEGER,o=n<0?0:n,l=r<0?0:r;for(let e=0;e<k;++e){const s=n+e*I;if(s>=0&&s<f)for(let n=0;n<N;++n){const u=r+n*C;if(u>=0&&u<m){const r=h[t][s][u][a]+p[e][n][a];r>i&&(i=r,o=s,l=u)}}}E[t][o][l][a]+=T[t][e][s][a]}}}return{dataId:c.write(ct(E,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},Nw=Ob((t,e)=>t/e),Iw=Gb(J,Nw),Cw={kernelName:J,backendName:"cpu",kernelFunc:Iw},Sw={kernelName:"Erf",backendName:"cpu",kernelFunc:Jb("Erf",t=>{const e=Math.sign(t),n=Math.abs(t),s=1/(1+.3275911*n);return e*(1-((((1.061405429*s-1.453152027)*s+1.421413741)*s-.284496736)*s+.254829592)*s*Math.exp(-n*n))})};function Tw(t,e,n){const s=t.shape,r=s[0],a=s[1],i=n.data.get(t.dataId),o=i.complexTensorInfos.real,l=i.complexTensorInfos.imag,u=[r,a],c=p(u),h=v("float32",c),d=v("float32",c);for(let t=0;t<r;t++){const s=bx({inputs:{x:o},backend:n,attrs:{begin:[t,0],size:[1,a]}}),r=bx({inputs:{x:l},backend:n,attrs:{begin:[t,0],size:[1,a]}}),i=Mb({inputs:{real:s,imag:r},backend:n}),{real:u,imag:c}=Ew(i,e,n),p=Xl(u,c);for(let e=0;e<a;e++){const n=Ql(p,e);h[t*a+e]=n.real,d[t*a+e]=n.imag}n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(i)}const f=n.makeTensorInfo(u,"float32",h),m=n.makeTensorInfo(u,"float32",d),g=Mb({inputs:{real:f,imag:m},backend:n});return n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}function Ew(t,e,n){const s=p(t.shape),r=n.data.get(t.dataId),a=n.data.get(r.complexTensorInfos.real.dataId).values,i=n.data.get(r.complexTensorInfos.imag.dataId).values;if(0==((o=s)&o-1)){const r=function t(e,n,s,r,a){if(1===s)return{real:e,imag:n};const i=Xl(e,n),o=s/2,l=Jl(i),u=l.real,c=l.imag,h=[u.length],p=a.makeTensorInfo(h,"float32",u),d=a.makeTensorInfo(h,"float32",c),f=Mb({inputs:{real:p,imag:d},backend:a}),m=Zl(i),g=m.real,y=m.imag,b=[g.length],x=a.makeTensorInfo(b,"float32",g),w=a.makeTensorInfo(b,"float32",y),v=Mb({inputs:{real:x,imag:w},backend:a}),k=t(u,c,o,r,a),N=k.real,I=k.imag,C=[N.length],S=a.makeTensorInfo(C,"float32",N),T=a.makeTensorInfo(C,"float32",I),E=Mb({inputs:{real:S,imag:T},backend:a}),$=t(g,y,o,r,a),A=$.real,R=$.imag,D=[A.length],_=a.makeTensorInfo(D,"float32",A),F=a.makeTensorInfo(D,"float32",R),O=Mb({inputs:{real:_,imag:F},backend:a}),M=eu(s,r),L=[M.real.length],z=a.makeTensorInfo(L,"float32",M.real),B=a.makeTensorInfo(L,"float32",M.imag),P=Mb({inputs:{real:z,imag:B},backend:a}),W=hx({inputs:{a:P,b:O},backend:a}),V=Kb({inputs:{a:E,b:W},backend:a}),U=Ix({inputs:{a:E,b:W},backend:a}),G=Pb({inputs:{input:V},backend:a}),H=Pb({inputs:{input:U},backend:a}),j=nw({inputs:{input:V},backend:a}),q=nw({inputs:{input:U},backend:a}),K=rw({inputs:[G,H],backend:a,attrs:{axis:0}}),X=rw({inputs:[j,q],backend:a,attrs:{axis:0}}),Y=a.data.get(K.dataId).values,J=a.data.get(X.dataId).values;return a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(d),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(x),a.disposeIntermediateTensorInfo(w),a.disposeIntermediateTensorInfo(v),a.disposeIntermediateTensorInfo(S),a.disposeIntermediateTensorInfo(T),a.disposeIntermediateTensorInfo(E),a.disposeIntermediateTensorInfo(_),a.disposeIntermediateTensorInfo(F),a.disposeIntermediateTensorInfo(O),a.disposeIntermediateTensorInfo(z),a.disposeIntermediateTensorInfo(B),a.disposeIntermediateTensorInfo(P),a.disposeIntermediateTensorInfo(W),a.disposeIntermediateTensorInfo(V),a.disposeIntermediateTensorInfo(U),a.disposeIntermediateTensorInfo(G),a.disposeIntermediateTensorInfo(j),a.disposeIntermediateTensorInfo(H),a.disposeIntermediateTensorInfo(q),a.disposeIntermediateTensorInfo(K),a.disposeIntermediateTensorInfo(X),{real:Y,imag:J}}(a,i,s,e,n),o=[t.shape[0],t.shape[1]];if(e){const t=n.makeTensorInfo(o,"float32",r.real),e=n.makeTensorInfo(o,"float32",r.imag),a=n.makeTensorInfo([],"float32",ut(s,"float32")),i=zb({inputs:{x:a},backend:n}),l=Cw.kernelFunc({inputs:{a:t,b:a},backend:n}),u=Cw.kernelFunc({inputs:{a:e,b:i},backend:n}),c=n.data.get(l.dataId).values,h=n.data.get(u.dataId).values;return n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(a),n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(u),{real:c,imag:h}}return r}return Yl(function(t,e,n){const s=new Float32Array(2*e);for(let r=0;r<e;r++){let a=0,i=0;for(let s=0;s<e;s++){const o=nu(r*s,e,n),l=Ql(t,s);a+=l.real*o.real-l.imag*o.imag,i+=l.real*o.imag+l.imag*o.real}n&&(a/=e,i/=e),tu(s,a,i,r)}return s}(Xl(a,i),s,e));var o}const $w={kernelName:"FFT",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n}=t,{input:s}=e,r=p(s.shape),a=s.shape[s.shape.length-1],i=Bx({inputs:{x:s},backend:n,attrs:{shape:[r/a,a]}}),o=Tw(i,!1,n),l=Bx({inputs:{x:o},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),l}};const Aw={kernelName:"Fill",backendName:"cpu",kernelFunc:function(t){const{backend:e,attrs:n}=t,{shape:s,value:r,dtype:a}=n,i=a||D(r),o=k(i,p(s));return function(t,e,n){t.fill(e)}(o,r),e.makeTensorInfo(s,i,o)}};const Rw={kernelName:"FlipLeftRight",backendName:"cpu",kernelFunc:({inputs:t,attrs:e,backend:n})=>{const{image:s}=t,r=n,a=v(s.dtype,p(s.shape)),[i,o,l,u]=s.shape,c=r.data.get(s.dataId).values;for(let t=0;t<i;t++){const e=t*l*o*u;for(let t=0;t<o;t++){const n=t*(l*u);for(let s=0;s<l;s++){const r=s*u;for(let o=0;o<u;o++){const h=[i,t,s,o][2],p=Math.round(l-h),d=e+n+r+o;let f=c[d];if(p>=0&&p<l){f=c[e+n+p*u+o]}a[d]=f}}}}return{dataId:r.write(a,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};const Dw={kernelName:"FusedConv2D",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r,filter:a,bias:i,preluActivationWeights:o}=e,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d}=s;let f=iw({inputs:{x:r,filter:a},backend:n,attrs:{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p}});if(i){const t=f;f=Kb({inputs:{a:f,b:i},backend:n}),n.disposeIntermediateTensorInfo(t)}if(d){const t=f;f=zx(n,f,d,o),n.disposeIntermediateTensorInfo(t)}return f}};const _w={kernelName:"FusedDepthwiseConv2D",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r,filter:a,bias:i,preluActivationWeights:o}=e,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d}=s;let f=gw({inputs:{x:r,filter:a},backend:n,attrs:{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p}});if(i){const t=f;f=Kb({inputs:{a:f,b:i},backend:n}),n.disposeIntermediateTensorInfo(t)}if(d){const t=f;f=zx(n,f,d,o),n.disposeIntermediateTensorInfo(t)}return f}};const Fw={kernelName:"IFFT",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n}=t,{input:s}=e,r=p(s.shape),a=s.shape[s.shape.length-1],i=Bx({inputs:{x:s},backend:n,attrs:{shape:[r/a,a]}}),o=Tw(i,!0,n),l=Bx({inputs:{x:o},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),l}},Ow={kernelName:"IsFinite",backendName:"cpu",kernelFunc:Jb("IsFinite",t=>Number.isFinite(t)?1:0,"bool")},Mw={kernelName:"IsInf",backendName:"cpu",kernelFunc:Jb("IsInf",t=>Math.abs(t)===1/0?1:0,"bool")},Lw={kernelName:"IsNan",backendName:"cpu",kernelFunc:Jb("IsNan",t=>Number.isNaN(t)?1:0,"bool")},zw={kernelName:"Log1p",backendName:"cpu",kernelFunc:Jb("Log1p",t=>Math.log1p(t))},Bw={kernelName:"LogicalNot",backendName:"cpu",kernelFunc:Jb("LogicalNot",t=>t?0:1,"bool")},Pw={kernelName:"Max",backendName:"cpu",kernelFunc:({inputs:t,attrs:e,backend:n})=>{const{x:s}=t,{reductionIndices:r,keepDims:a}=e,i=n;let o=s.shape;const l=o.length,u=x(r,o);let c=u;const h=gs(c,l);let d=i.data.get(s.dataId).values;if(null!=h){const t=new Array(l);for(let e=0;e<t.length;e++)t[e]=o[h[e]];d=Sx(d,o,s.dtype,h,t),c=bs(c.length,l),o=t}Sb(s,"max"),ms("max",c,l);const[f,m]=ds(o,c),g=ux(d,p(m),f,s.dtype),y=i.write(g,f,s.dtype);let b=f;if(a){b=fs(f,u)}return{dataId:y,shape:b,dtype:s.dtype}}};const Ww={kernelName:"MaxPool",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r}=e;Sb(r,"maxPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:u}=s;l(Bs(i,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`);const c=$s(r.shape,a,i,1,o,u);let h;if(1===c.filterWidth&&1===c.filterHeight&&d(c.inShape,c.outShape))h=zb({inputs:{x:r},backend:n});else{const t=n.data.get(r.dataId).values,e=O(r.shape),s=Yx(t,r.shape,r.dtype,e,c,"max");h=n.makeTensorInfo(c.outShape,r.dtype,s.values)}return h}};const Vw={kernelName:"MaxPoolBackprop",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{dy:r,input:a,output:i}=e,o=a;Sb([a,i],"maxPoolBackprop");const{filterSize:l,strides:u,pad:c,dimRoundingMode:h}=s,p=$s(o.shape,l,u,1,c,h),d=n.data.get(o.dataId).values,f=We(p.outShape,o.dtype,Jx(d,o.shape,o.dtype,p).values),m=p.strideHeight,g=p.strideWidth,y=p.dilationHeight,b=p.dilationWidth,x=p.effectiveFilterHeight,w=p.effectiveFilterWidth,v=w-1-p.padInfo.left,k=x-1-p.padInfo.top,N=We(o.shape,"float32"),I=n.data.get(r.dataId).values,C=We(r.shape,"float32",I);for(let t=0;t<p.batchSize;++t)for(let e=0;e<p.inChannels;++e)for(let n=0;n<p.inHeight;++n)for(let s=0;s<p.inWidth;++s){const r=n-k,a=s-v;let i=0;for(let n=0;n<x;n+=y){const s=(r+n)/m;if(!(s<0||s>=p.outHeight||Math.floor(s)!==s))for(let r=0;r<w;r+=b){const o=(a+r)/g;if(o<0||o>=p.outWidth||Math.floor(o)!==o)continue;const l=x*w-1-f.get(t,s,o,e)===n*w+r?1:0;0!==l&&(i+=C.get(t,s,o,e)*l)}}N.set(i,t,n,s,e)}return n.makeTensorInfo(N.shape,N.dtype,N.values)}};const Uw={kernelName:"MaxPoolWithArgmax",backendName:"cpu",kernelFunc:({inputs:t,attrs:e,backend:n})=>{const{x:s}=t,{filterSize:r,strides:a,pad:i,includeBatchInIndex:o}=e,l=n;Sb(s,"MaxPoolWithArgmax");const u=l.data.get(s.dataId).values,c=$s(s.shape,r,a,[1,1],i),[h,p]=function(t,e,n,s,r){const a=Yx(t,0,n,O(e),r,"max"),i=Jx(t,e,n,r,!0,s);return[a.values,i.values]}(u,s.shape,s.dtype,o,c),d=l.write(h,c.outShape,s.dtype),f=l.write(p,c.outShape,s.dtype);return[{dataId:d,shape:c.outShape,dtype:s.dtype},{dataId:f,shape:c.outShape,dtype:"int32"}]}};const Gw={kernelName:"MirrorPad",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r}=e,{paddings:a,mode:i}=s;Sb(r,"mirrorPad");const o=a.map((t,e)=>t[0]+r.shape[e]+t[1]),l=a.map(t=>t[0]),u=a.map((t,e)=>t[0]+r.shape[e]),c="reflect"===i?0:1,h=n.data.get(r.dataId).values,d=r.shape.length,f=O(r.shape),m=p(o),g=o.length,y=O(o),b=v(r.dtype,m);for(let t=0;t<m;t++){let e=V(t,g,y);for(let t=0;t<g;t++)e[t]<l[t]?e[t]=2*l[t]-e[t]-c:e[t]>=u[t]&&(e[t]=2*(u[t]-1)-e[t]+c);e=e.map((t,e)=>t-l[e]);const n=W(e,d,f);b[t]=h[n]}return{dataId:n.write(b,o,r.dtype),shape:o,dtype:r.dtype}}},Hw=Jo,jw={kernelName:"NonMaxSuppressionV4",backendName:"cpu",kernelFunc:({inputs:t,backend:e,attrs:n})=>{const{boxes:s,scores:r}=t,{maxOutputSize:a,iouThreshold:i,scoreThreshold:o,padToMaxOutputSize:l}=n,u=e;Sb(s,"NonMaxSuppressionPadded");const c=u.data.get(s.dataId).values,h=u.data.get(r.dataId).values,{selectedIndices:p,validOutputs:d}=Hw(c,h,a,i,o,l);return[p,d]}},qw=Zo,Kw={kernelName:"NonMaxSuppressionV5",backendName:"cpu",kernelFunc:({inputs:t,backend:e,attrs:n})=>{const{boxes:s,scores:r}=t,{maxOutputSize:a,iouThreshold:i,scoreThreshold:o,softNmsSigma:l}=n,u=e;Sb(s,"NonMaxSuppressionWithScore");const c=u.data.get(s.dataId).values,h=u.data.get(r.dataId).values,p=a,d=i,f=o,m=l,{selectedIndices:g,selectedScores:y}=qw(c,h,p,d,f,m);return[g,y]}};const Xw={kernelName:"PadV2",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r}=e,{paddings:a,constantValue:i}=s;Sb(r,"pad");const o=a.map((t,e)=>t[0]+r.shape[e]+t[1]),l=a.map(t=>t[0]),u=n.data.get(r.dataId).values,c=p(r.shape),h=r.shape.length,d=O(r.shape),f=p(o),m=o.length,g=O(o),y=v(r.dtype,f);0!==i&&y.fill(i);for(let t=0;t<c;t++){y[W(V(t,h,d).map((t,e)=>t+l[e]),m,g)]=u[t]}return{dataId:n.write(y,o,r.dtype),shape:o,dtype:r.dtype}}},Yw={kernelName:"Reciprocal",backendName:"cpu",kernelFunc:Jb("Reciprocal",t=>1/t)},Jw={kernelName:"RotateWithOffset",backendName:"cpu",kernelFunc:({inputs:t,attrs:e,backend:n})=>{const{image:s}=t,{radians:r,fillValue:a,center:i}=e,o=n,l=v(s.dtype,p(s.shape)),[u,c,h,d]=s.shape,[f,m]=Wl(i,c,h),g=Math.sin(r),y=Math.cos(r),b=o.data.get(s.dataId).values;for(let t=0;t<u;t++){const e=t*h*c*d;for(let t=0;t<c;t++){const n=t*(h*d);for(let s=0;s<h;s++){const r=s*d;for(let i=0;i<d;i++){const o=[u,t,s,i],p=o[2],x=o[1];let w=(p-f)*y-(x-m)*g,v=(p-f)*g+(x-m)*y;w=Math.round(w+f),v=Math.round(v+m);let k=a;if("number"!=typeof a&&(k=3===i?255:a[i]),w>=0&&w<h&&v>=0&&v<c){k=b[e+v*(h*d)+w*d+i]}l[e+n+r+i]=k}}}}return{dataId:o.write(l,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},Zw={kernelName:"Round",backendName:"cpu",kernelFunc:Jb("Round",t=>{const e=Math.floor(t);return t-e<.5?Math.floor(t):t-e>.5?Math.ceil(t):e%2==0?e:e+1})},Qw={kernelName:"Selu",backendName:"cpu",kernelFunc:Jb("Selu",t=>t>=0?1.0507009873554805*t:1.7580993408473768*(Math.exp(t)-1))},tv={kernelName:"Sigmoid",backendName:"cpu",kernelFunc:Jb("Sigmoid",t=>1/(1+Math.exp(-t)))},ev={kernelName:"Sign",backendName:"cpu",kernelFunc:Jb("Sign",t=>t<0?-1:t>0?1:0)},nv=Jb(Z,t=>Math.sin(t)),sv={kernelName:Z,backendName:"cpu",kernelFunc:nv},rv={kernelName:"Sinh",backendName:"cpu",kernelFunc:Jb("Sinh",t=>Math.sinh(t))},av=Math.log(1.1920928955078125e-7)+2,iv={kernelName:"Softplus",backendName:"cpu",kernelFunc:Jb("Softplus",t=>{const e=t>-av,n=t<av,s=Math.exp(t);let r;return r=n?s:e?t:Math.log(1+s),r})};function ov(t){const{inputs:e,attrs:n,backend:s}=t,{x:r}=e,{perm:a}=n;Sb(r,"transpose");const i=r.shape.length,o=new Array(i);for(let t=0;t<o.length;t++)o[t]=r.shape[a[t]];const l=Sx(s.data.get(r.dataId).values,r.shape,r.dtype,a,o);return{dataId:s.write(l,o,r.dtype),shape:o,dtype:r.dtype}}const lv={kernelName:"Transpose",backendName:"cpu",kernelFunc:ov};const uv={kernelName:"SpaceToBatchND",backendName:"cpu",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r}=e,{blockShape:a,paddings:i}=s;Sb([r],"spaceToBatchND");const o=p(a),l=[[0,0]];l.push(...i);for(let t=1+a.length;t<r.shape.length;++t)l.push([0,0]);const u=Xw.kernelFunc({inputs:{x:r},backend:n,attrs:{paddings:l,constantValue:0}}),c=Vl(u.shape,a,o,!1),h=Ul(c.length,a.length,!1),d=Gl(u.shape,a,o,!1),f=Bx({inputs:{x:u},backend:n,attrs:{shape:c}}),m=ov({inputs:{x:f},backend:n,attrs:{perm:h}}),g=Bx({inputs:{x:m},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}},cv={kernelName:"Sqrt",backendName:"cpu",kernelFunc:Jb("Sqrt",t=>Math.sqrt(t))},hv={kernelName:"Square",backendName:"cpu",kernelFunc:({inputs:t,backend:e})=>{const{x:n}=t,s=e;Sb(n,"square");const r=s.data.get(n.dataId).values,a=new Float32Array(r.length);for(let t=0;t<r.length;++t){const e=r[t];a[t]=e*e}return{dataId:s.write(a,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},pv={kernelName:"Step",backendName:"cpu",kernelFunc:Jb("Step",(t,e)=>{const n=e;return isNaN(t)?NaN:t>0?1:n.alpha})},dv=Jb(tt,t=>Math.tan(t)),fv={kernelName:tt,backendName:"cpu",kernelFunc:dv},mv=Jb("Tanh",t=>Math.tanh(t));const gv=[Ux,Fb,Gx,Hx,Xb,jx,qx,Kx,Xx,Zx,Qx,Vx,tw,Ub,tx,ew,Lb,aw,lw,uw,ow,hw,pw,cw,fw,mw,yw,bw,xw,ww,kw,vw,Cw,Ax,Sw,nx,rx,$w,Aw,Rw,ix,Dw,_w,Bb,Fw,sw,Ow,Mw,Lw,lx,zw,Bw,Ww,Vw,Uw,Pw,Gw,px,jw,Kw,fx,Xw,_x,Wb,Yw,Ox,Lx,Px,Jw,Zw,gx,Qw,tv,ev,sv,rv,xx,iv,uv,cv,hv,vx,pv,Cx,fv,{kernelName:"Tanh",backendName:"cpu",kernelFunc:mv},lv,{kernelName:"Unique",backendName:"cpu",kernelFunc:function(t){const{inputs:e,attrs:n,backend:s}=t,{axis:r}=n,{x:a}=e;Sb(a,"unique");const i=s.data.get(a.dataId).values,{outputValues:o,outputShape:l,indices:u}=Tx(i,r,a.shape,a.dtype);return[s.makeTensorInfo(l,a.dtype,o),s.makeTensorInfo([u.length],"int32",u)]}}];for(const t of gv)it(t);const yv={},bv={alpha:!1,antialias:!1,premultipliedAlpha:!1,preserveDrawingBuffer:!1,depth:!1,stencil:!1,failIfMajorPerformanceCaveat:!0};function xv(t){if(!(t in yv)){const e=function(t){if(1!==t&&2!==t)throw new Error("Cannot get WebGL rendering context, WebGL is disabled.");const e=function(t){if("undefined"!=typeof OffscreenCanvas&&2===t)return new OffscreenCanvas(300,150);if("undefined"!=typeof document)return document.createElement("canvas");throw new Error("Cannot create a canvas in this context")}(t);if(e.addEventListener("webglcontextlost",e=>{e.preventDefault(),delete yv[t]},!1),1===t)return e.getContext("webgl",bv)||e.getContext("experimental-webgl",bv);return e.getContext("webgl2",bv)}(t);if(null===e)return console.log("Could not get context for WebGL version",t),null;yv[t]=e}const e=yv[t];return e.isContextLost()?(delete yv[t],xv(t)):(e.disable(e.DEPTH_TEST),e.disable(e.STENCIL_TEST),e.disable(e.BLEND),e.disable(e.DITHER),e.disable(e.POLYGON_OFFSET_FILL),e.disable(e.SAMPLE_COVERAGE),e.enable(e.SCISSOR_TEST),e.enable(e.CULL_FACE),e.cullFace(e.BACK),yv[t])}var wv,vv,kv;function Nv(t,e){return[e,t]}function Iv(t){const e=p(t);return m(Math.ceil(e/4))}function Cv(t,e){return[Math.max(1,Math.ceil(e/2)),Math.max(1,Math.ceil(t/2))]}function Sv(t,e){const n=t;let s,r,a,i,o,l,u,c,h,p;return 2===H().getNumber("WEBGL_VERSION")?(s=n.R32F,r=n.R16F,a=n.RGBA16F,i=n.RGBA32F,o=n.RED,u=4,c=1,h=n.HALF_FLOAT,p=n.FLOAT):(s=t.RGBA,r=t.RGBA,a=t.RGBA,i=n.RGBA,o=t.RGBA,u=4,c=4,h=null!=e?e.HALF_FLOAT_OES:null,p=t.FLOAT),l=t.RGBA,{internalFormatFloat:s,internalFormatHalfFloat:r,internalFormatPackedHalfFloat:a,internalFormatPackedFloat:i,textureFormatFloat:o,downloadTextureFormat:l,downloadUnpackNumChannels:u,defaultNumChannels:c,textureTypeHalfFloat:h,textureTypeFloat:p}}function Tv(t,e){const n=e();return H().getBool("DEBUG")&&function(t){const e=t.getError();if(e!==t.NO_ERROR)throw new Error("WebGL Error: "+function(t,e){switch(e){case t.NO_ERROR:return"NO_ERROR";case t.INVALID_ENUM:return"INVALID_ENUM";case t.INVALID_VALUE:return"INVALID_VALUE";case t.INVALID_OPERATION:return"INVALID_OPERATION";case t.INVALID_FRAMEBUFFER_OPERATION:return"INVALID_FRAMEBUFFER_OPERATION";case t.OUT_OF_MEMORY:return"OUT_OF_MEMORY";case t.CONTEXT_LOST_WEBGL:return"CONTEXT_LOST_WEBGL";default:return"Unknown error code "+e}}(t,e))}(t),n}!function(t){t[t.DENSE=0]="DENSE",t[t.SHARED_BATCH=1]="SHARED_BATCH"}(wv||(wv={})),function(t){t[t.RENDER=0]="RENDER",t[t.UPLOAD=1]="UPLOAD",t[t.PIXELS=2]="PIXELS",t[t.DOWNLOAD=3]="DOWNLOAD"}(vv||(vv={})),function(t){t[t.UNPACKED_FLOAT16=0]="UNPACKED_FLOAT16",t[t.UNPACKED_FLOAT32=1]="UNPACKED_FLOAT32",t[t.PACKED_4X1_UNSIGNED_BYTE=2]="PACKED_4X1_UNSIGNED_BYTE",t[t.PACKED_2X2_FLOAT32=3]="PACKED_2X2_FLOAT32",t[t.PACKED_2X2_FLOAT16=4]="PACKED_2X2_FLOAT16"}(kv||(kv={}));function Ev(t){return!!(H().getBool("WEBGL_RENDER_FLOAT32_ENABLED")||0===t||5.96e-8<Math.abs(t)&&Math.abs(t)<65504)}function $v(t,e){return zv(t,()=>t.getExtension(e),'Extension "'+e+'" not supported on this browser.')}function Av(t,e){const n=zv(t,()=>t.createShader(t.FRAGMENT_SHADER),"Unable to create fragment WebGLShader.");if(Tv(t,()=>t.shaderSource(n,e)),Tv(t,()=>t.compileShader(n)),!1===t.getShaderParameter(n,t.COMPILE_STATUS))throw function(t,e){const n=Rv.exec(e);if(null==n)return console.log("Couldn't parse line number in error: "+e),void console.log(t);const s=+n[1],r=t.split("\n"),a=r.length.toString().length+2,i=r.map((t,e)=>g((e+1).toString(),a)+t);let o=0;for(let t=0;t<i.length;t++)o=Math.max(i[t].length,o);const l=i.slice(0,s-1),u=i.slice(s-1,s),c=i.slice(s);console.log(l.join("\n")),console.log(e.split("\n")[0]),console.log("%c "+g(u[0],o),"border:1px solid red; background-color:#e3d2d2; color:#a61717"),console.log(c.join("\n"))}(e,t.getShaderInfoLog(n)),new Error("Failed to compile fragment shader.");return n}const Rv=/ERROR: [0-9]+:([0-9]+):/g;function Dv(t,e){if(Tv(t,()=>t.validateProgram(e)),!1===t.getProgramParameter(e,t.VALIDATE_STATUS))throw console.log(t.getProgramInfoLog(e)),new Error("Shader program validation failed.")}function _v(t,e,n,s,r,a,i){const o=t.getAttribLocation(e,n);return-1!==o&&(Tv(t,()=>t.bindBuffer(t.ARRAY_BUFFER,s)),Tv(t,()=>t.vertexAttribPointer(o,r,t.FLOAT,!1,a,i)),Tv(t,()=>t.enableVertexAttribArray(o)),!0)}function Fv(t,e,n,s){Tv(t,()=>function(t,e,n){Bv(t,n),Tv(t,()=>t.activeTexture(t.TEXTURE0+n)),Tv(t,()=>t.bindTexture(t.TEXTURE_2D,e))}(t,e,s)),Tv(t,()=>t.uniform1i(n,s))}function Ov(t,e,n){Tv(t,()=>t.bindFramebuffer(t.FRAMEBUFFER,n)),Tv(t,()=>t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0))}function Mv(t,e){Tv(t,()=>t.bindFramebuffer(t.FRAMEBUFFER,e)),Tv(t,()=>t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,null,0))}function Lv(t){const e=t.checkFramebufferStatus(t.FRAMEBUFFER);if(e!==t.FRAMEBUFFER_COMPLETE)throw new Error("Error binding framebuffer: "+function(t,e){switch(e){case t.FRAMEBUFFER_INCOMPLETE_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_ATTACHMENT";case t.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";case t.FRAMEBUFFER_INCOMPLETE_DIMENSIONS:return"FRAMEBUFFER_INCOMPLETE_DIMENSIONS";case t.FRAMEBUFFER_UNSUPPORTED:return"FRAMEBUFFER_UNSUPPORTED";default:return"unknown error "+e}}(t,e))}function zv(t,e,n){const s=Tv(t,()=>e());if(null==s)throw new Error(n);return s}function Bv(t,e){const n=t.MAX_COMBINED_TEXTURE_IMAGE_UNITS-1,s=e+t.TEXTURE0;if(s<t.TEXTURE0||s>n){throw new Error(`textureUnit must be in ${`[gl.TEXTURE0, gl.TEXTURE${n}]`}.`)}}function Pv(t,e=2){return p(t.slice(0,t.length-e))}function Wv(t){if(0===t.length)throw Error("Cannot get rows and columns of an empty shape array.");return[t.length>1?t[t.length-2]:1,t[t.length-1]]}function Vv(t){let e=[1,1,1];return 0===t.length||1===t.length&&1===t[0]||(e=[Pv(t),...Wv(t)]),e}function Uv(t){return t%2==0}function Gv(t,e){if(d(t=t.slice(-2),e=e.slice(-2)))return!0;if(!t.length||!e.length)return!0;if(0===t[0]||0===t[1]||0===e[0]||0===e[1])return!0;if(t.length!==e.length){const n=t.slice(-1)[0],s=e.slice(-1)[0];if(n===s)return!0;if(Uv(n)&&Uv(s)&&(1===t[0]||1===e[0]))return!0}return t[1]===e[1]&&Uv(t[0])&&Uv(e[0])}let Hv,jv;function qv(t,e){return null!=t.getExtension(e)}function Kv(t){try{if(null!=xv(t))return!0}catch(t){return console.log("Error when getting WebGL context: ",t),!1}return!1}function Xv(t){if(0===t)return!1;const e=xv(t);if(1!==t){if(qv(e,"EXT_color_buffer_float"))return Yv(e);const t="EXT_color_buffer_half_float";if(qv(e,t)){const n=e.getExtension(t);return function(t,e){const n=Sv(t,e),s=t.createTexture();t.bindTexture(t.TEXTURE_2D,s);t.texImage2D(t.TEXTURE_2D,0,n.internalFormatHalfFloat,1,1,0,n.textureFormatFloat,n.textureTypeHalfFloat,null);const r=t.createFramebuffer();t.bindFramebuffer(t.FRAMEBUFFER,r),t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,s,0);const a=t.checkFramebufferStatus(t.FRAMEBUFFER)===t.FRAMEBUFFER_COMPLETE;return t.bindTexture(t.TEXTURE_2D,null),t.bindFramebuffer(t.FRAMEBUFFER,null),t.deleteTexture(s),t.deleteFramebuffer(r),a}(e,n)}return!1}return!!qv(e,"OES_texture_float")&&(!!qv(e,"WEBGL_color_buffer_float")&&Yv(e))}function Yv(t){const e=Sv(t),n=t.createTexture();t.bindTexture(t.TEXTURE_2D,n);t.texImage2D(t.TEXTURE_2D,0,e.internalFormatFloat,1,1,0,e.textureFormatFloat,e.textureTypeFloat,null);const s=t.createFramebuffer();t.bindFramebuffer(t.FRAMEBUFFER,s),t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,n,0);const r=t.checkFramebufferStatus(t.FRAMEBUFFER)===t.FRAMEBUFFER_COMPLETE;return t.bindTexture(t.TEXTURE_2D,null),t.bindFramebuffer(t.FRAMEBUFFER,null),t.deleteTexture(n),t.deleteFramebuffer(s),r}function Jv(t,e){Array.isArray(t)||(t=[t]),t.forEach(t=>{null!=t&&l("complex64"!==t.dtype,()=>e+" does not support complex64 tensors in the WebGL backend.")})}const Zv=H();Zv.registerFlag("HAS_WEBGL",()=>Zv.getNumber("WEBGL_VERSION")>0),Zv.registerFlag("WEBGL_VERSION",()=>Kv(2)?2:Kv(1)?1:0),Zv.registerFlag("WEBGL_CHECK_NUMERICAL_PROBLEMS",()=>!1),Zv.registerFlag("WEBGL_BUFFER_SUPPORTED",()=>2===Zv.get("WEBGL_VERSION")),Zv.registerFlag("WEBGL_CPU_FORWARD",()=>!0),Zv.registerFlag("WEBGL_FORCE_F16_TEXTURES",()=>!1),Zv.registerFlag("WEBGL_PACK",()=>Zv.getBool("HAS_WEBGL")),Zv.registerFlag("WEBGL_PACK_NORMALIZATION",()=>Zv.getBool("WEBGL_PACK")),Zv.registerFlag("WEBGL_PACK_CLIP",()=>Zv.getBool("WEBGL_PACK")),Zv.registerFlag("WEBGL_PACK_DEPTHWISECONV",()=>!1),Zv.registerFlag("WEBGL_PACK_BINARY_OPERATIONS",()=>Zv.getBool("WEBGL_PACK")),Zv.registerFlag("WEBGL_PACK_UNARY_OPERATIONS",()=>Zv.getBool("WEBGL_PACK")),Zv.registerFlag("WEBGL_PACK_ARRAY_OPERATIONS",()=>Zv.getBool("WEBGL_PACK")),Zv.registerFlag("WEBGL_PACK_IMAGE_OPERATIONS",()=>Zv.getBool("WEBGL_PACK")),Zv.registerFlag("WEBGL_PACK_REDUCE",()=>Zv.getBool("WEBGL_PACK")),Zv.registerFlag("WEBGL_LAZILY_UNPACK",()=>Zv.getBool("WEBGL_PACK")),Zv.registerFlag("WEBGL_CONV_IM2COL",()=>Zv.getBool("WEBGL_PACK")),Zv.registerFlag("WEBGL_MAX_TEXTURE_SIZE",()=>function(t){if(null==Hv){const e=xv(t);Hv=e.getParameter(e.MAX_TEXTURE_SIZE)}return Hv}(Zv.getNumber("WEBGL_VERSION"))),Zv.registerFlag("WEBGL_MAX_TEXTURES_IN_SHADER",()=>function(t){if(null==jv){const e=xv(t);jv=e.getParameter(e.MAX_TEXTURE_IMAGE_UNITS)}return Math.min(16,jv)}(Zv.getNumber("WEBGL_VERSION"))),Zv.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION",()=>{const t=Zv.getNumber("WEBGL_VERSION");return 0===t?0:function(t){if(0===t)return 0;let e;const n=xv(t);return e=qv(n,"EXT_disjoint_timer_query_webgl2")&&2===t?2:qv(n,"EXT_disjoint_timer_query")?1:0,e}(t)}),Zv.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE",()=>Zv.getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0&&!qt()),Zv.registerFlag("WEBGL_RENDER_FLOAT32_CAPABLE",()=>function(t){if(0===t)return!1;const e=xv(t);if(1===t){if(!qv(e,"OES_texture_float"))return!1}else if(!qv(e,"EXT_color_buffer_float"))return!1;return Yv(e)}(Zv.getNumber("WEBGL_VERSION"))),Zv.registerFlag("WEBGL_RENDER_FLOAT32_ENABLED",()=>!Zv.getBool("WEBGL_FORCE_F16_TEXTURES")&&Zv.getBool("WEBGL_RENDER_FLOAT32_CAPABLE")),Zv.registerFlag("WEBGL_DOWNLOAD_FLOAT_ENABLED",()=>Xv(Zv.getNumber("WEBGL_VERSION"))),Zv.registerFlag("WEBGL_FENCE_API_ENABLED",()=>{return 2===(t=Zv.getNumber("WEBGL_VERSION"))&&null!=xv(t).fenceSync;var t}),Zv.registerFlag("WEBGL_SIZE_UPLOAD_UNIFORM",()=>Zv.getBool("WEBGL_RENDER_FLOAT32_ENABLED")?4:0),Zv.registerFlag("WEBGL_DELETE_TEXTURE_THRESHOLD",()=>-1,t=>{if(t<0&&-1!==t)throw new Error(`WEBGL_DELETE_TEXTURE_THRESHOLD must be -1 (indicating never delete) or at least 0, but got ${t}.`)});const{simpleAbsImpl:Qv,addImpl:tk,ceilImpl:ek,expImpl:nk,expm1Impl:sk,floorImpl:rk,logImpl:ak,maxImpl:ik,multiplyImpl:ok,rsqrtImpl:lk,sliceImpl:uk,subImpl:ck,transposeImpl:hk,uniqueImpl:pk}=Ex;class dk{constructor(t,e){this.outputShape=[],this.outputShape=t,this.variableNames=e.map((t,e)=>"T"+e);const n=[];this.variableNames.forEach(t=>{n.push(`float v${t} = get${t}AtOutCoords();`)});const s=this.variableNames.map(t=>"v"+t).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        float result = ${s};\n        setOutput(result);\n      }\n    `}}class fk{constructor(t,e){this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t,this.variableNames=e.map((t,e)=>"T"+e);const n=[];this.variableNames.forEach(t=>{n.push(`vec4 v${t} = get${t}AtOutCoords();`)});const s=this.variableNames.map(t=>"v"+t).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        vec4 result = ${s};\n        setOutput(result);\n      }\n    `}}class mk{constructor(t,e,n){this.variableNames=["A"];const{windowSize:s,batchSize:r,outSize:a}=t;n||this.variableNames.push("bestIndicesA"),this.outputShape=[r,a];const i="max"===e?">":"<",o=n?"inOffset + i;":"round(getBestIndicesA(batch, inOffset + i));";this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${s};\n\n        int bestIndex = inOffset;\n        float bestValue = getA(batch, bestIndex);\n\n        for (int i = 0; i < ${s}; i++) {\n          int inIdx = ${o};\n          float candidate = getA(batch, inIdx);\n          if (candidate ${i} bestValue) {\n            bestValue = candidate;\n            bestIndex = inIdx;\n          }\n        }\n        setOutput(float(bestIndex));\n      }\n    `}}function gk(t,e){return["x","y","z","w","u","v"].slice(0,e).map(e=>`${t}.${e}`)}function yk(t,e){return 1===e?[t]:gk(t,e)}function bk(){let t,e,n,s,r,a,i,o,l,u;return 2===H().getNumber("WEBGL_VERSION")?(t="#version 300 es",e="in",n="out",s="in",r="texture",a="outputColor",i="out vec4 outputColor;",o="\n      bool isnan_custom(float val) {\n        return (val > 0.0 || val < 0.0) ? false : val != 0.0;\n      }\n\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan_custom(val.x),\n          isnan_custom(val.y), isnan_custom(val.z), isnan_custom(val.w));\n      }\n\n      #define isnan(value) isnan_custom(value)\n    ",l="",u="\n      #define round(value) newRound(value)\n      int newRound(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 newRound(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "):(t="",e="attribute",n="varying",s="varying",r="texture2D",a="gl_FragColor",i="",o="\n      #define isnan(value) isnan_custom(value)\n      bool isnan_custom(float val) {\n        return (val > 0. || val < 1. || val == 0.) ? false : true;\n      }\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan(val.x), isnan(val.y), isnan(val.z), isnan(val.w));\n      }\n    ",l="\n      uniform float INFINITY;\n\n      bool isinf(float val) {\n        return abs(val) == INFINITY;\n      }\n      bvec4 isinf(vec4 val) {\n        return equal(abs(val), vec4(INFINITY));\n      }\n    ",u="\n      int round(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 round(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "),{version:t,attribute:e,varyingVs:n,varyingFs:s,texture2D:r,output:a,defineOutput:i,defineSpecialNaN:o,defineSpecialInf:l,defineRound:u}}function xk(t,e,n="index"){const s=O(e);return s.map((e,r)=>`${`int ${t[r]} = ${n} / ${e}`}; ${r===s.length-1?`int ${t[r+1]} = ${n} - ${t[r]} * ${e}`:`index -= ${t[r]} * ${e}`};`).join("")}function wk(t){const e=O(t).map(t=>t.toString());return`\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * ${e[0]} + coords.y * ${e[1]} + coords.z;\n  }\n`}const vk="\n  const float FLOAT_MAX = 1.70141184e38;\n  const float FLOAT_MIN = 1.17549435e-38;\n\n  lowp vec4 encode_float(highp float v) {\n    if (isnan(v)) {\n      return vec4(255, 255, 255, 255);\n    }\n\n    highp float av = abs(v);\n\n    if(av < FLOAT_MIN) {\n      return vec4(0.0, 0.0, 0.0, 0.0);\n    } else if(v > FLOAT_MAX) {\n      return vec4(0.0, 0.0, 128.0, 127.0) / 255.0;\n    } else if(v < -FLOAT_MAX) {\n      return vec4(0.0, 0.0,  128.0, 255.0) / 255.0;\n    }\n\n    highp vec4 c = vec4(0,0,0,0);\n\n    highp float e = floor(log2(av));\n    highp float m = exp2(fract(log2(av))) - 1.0;\n\n    c[2] = floor(128.0 * m);\n    m -= c[2] / 128.0;\n    c[1] = floor(32768.0 * m);\n    m -= c[1] / 32768.0;\n    c[0] = floor(8388608.0 * m);\n\n    highp float ebias = e + 127.0;\n    c[3] = floor(ebias / 2.0);\n    ebias -= c[3] * 2.0;\n    c[2] += floor(ebias) * 128.0;\n\n    c[3] += 128.0 * step(0.0, -v);\n\n    return c / 255.0;\n  }\n",{getBroadcastDims:kk}=au;function Nk(t,e,n,s){const r=[];t.forEach(t=>{const e=p(t.shapeInfo.logicalShape);t.shapeInfo.isUniform?r.push(`uniform float ${t.name}${e>1?`[${e}]`:""};`):(r.push(`uniform sampler2D ${t.name};`),r.push(`uniform int offset${t.name};`))});const a=r.join("\n"),i=t.map(t=>function(t,e,n=!1){let s="";s+=n?Ck(t):Ik(t);const r=t.shapeInfo.logicalShape,a=e.logicalShape;r.length<=a.length&&(s+=n?function(t,e){const n=t.name,s=n.charAt(0).toUpperCase()+n.slice(1),r="get"+s+"AtOutCoords",a=t.shapeInfo.logicalShape.length,i=e.logicalShape.length,o=kk(t.shapeInfo.logicalShape,e.logicalShape),l=_k(i),u=i-a;let c;const h=["x","y","z","w","u","v"];c=0===a?"":i<2&&o.length>=1?"coords = 0;":o.map(t=>`coords.${h[t+u]} = 0;`).join("\n");let d="";d=i<2&&a>0?"coords":t.shapeInfo.logicalShape.map((t,e)=>"coords."+h[e+u]).join(", ");let f="return outputValue;";const m=1===p(t.shapeInfo.logicalShape),g=1===p(e.logicalShape);if(1!==a||m||g){if(m&&!g)f=1===i?"\n        return vec4(outputValue.x, outputValue.x, 0., 0.);\n      ":"\n        return vec4(outputValue.x);\n      ";else if(o.length){const t=a-2,e=a-1;o.indexOf(t)>-1&&o.indexOf(e)>-1?f="return vec4(outputValue.x);":o.indexOf(t)>-1?f="return vec4(outputValue.x, outputValue.y, outputValue.x, outputValue.y);":o.indexOf(e)>-1&&(f="return vec4(outputValue.xx, outputValue.zz);")}}else f="\n      return vec4(outputValue.xy, outputValue.xy);\n    ";return`\n    vec4 ${r}() {\n      ${l} coords = getOutputCoords();\n      ${c}\n      vec4 outputValue = get${s}(${d});\n      ${f}\n    }\n  `}(t,e):function(t,e){const n=t.name,s=n.charAt(0).toUpperCase()+n.slice(1),r="get"+s+"AtOutCoords",a=e.texShape,i=t.shapeInfo.texShape,o=t.shapeInfo.logicalShape.length,l=e.logicalShape.length;if(!t.shapeInfo.isUniform&&o===l&&null==t.shapeInfo.flatOffset&&d(i,a))return`\n      float ${r}() {\n        return sampleTexture(${n}, resultUV);\n      }\n    `;const u=_k(l),c=kk(t.shapeInfo.logicalShape,e.logicalShape),h=l-o;let p;const f=["x","y","z","w","u","v"];p=0===o?"":l<2&&c.length>=1?"coords = 0;":c.map(t=>`coords.${f[t+h]} = 0;`).join("\n");let m="";m=l<2&&o>0?"coords":t.shapeInfo.logicalShape.map((t,e)=>"coords."+f[e+h]).join(", ");return`\n    float ${r}() {\n      ${u} coords = getOutputCoords();\n      ${p}\n      return get${s}(${m});\n    }\n  `}(t,e));return s}(t,e,s)).join("\n"),o=e.texShape,l=bk(),u=function(t){return`\n    float sampleTexture(sampler2D textureSampler, vec2 uv) {\n      return ${t.texture2D}(textureSampler, uv).r;\n    }\n  `}(l);let c,h,f=function(t){return`${t.version}\n    precision highp float;\n    precision highp int;\n    precision highp sampler2D;\n    ${t.varyingFs} vec2 resultUV;\n    ${t.defineOutput}\n    const vec2 halfCR = vec2(0.5, 0.5);\n\n    struct ivec5\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n    };\n\n    struct ivec6\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n      int v;\n    };\n\n    uniform float NAN;\n    ${t.defineSpecialNaN}\n    ${t.defineSpecialInf}\n    ${t.defineRound}\n\n    int imod(int x, int y) {\n      return x - y * (x / y);\n    }\n\n    int idiv(int a, int b, float sign) {\n      int res = a / b;\n      int mod = imod(a, b);\n      if (sign < 0. && mod != 0) {\n        res -= 1;\n      }\n      return res;\n    }\n\n    //Based on the work of Dave Hoskins\n    //https://www.shadertoy.com/view/4djSRW\n    #define HASHSCALE1 443.8975\n    float random(float seed){\n      vec2 p = resultUV * seed;\n      vec3 p3  = fract(vec3(p.xyx) * HASHSCALE1);\n      p3 += dot(p3, p3.yzx + 19.19);\n      return fract((p3.x + p3.y) * p3.z);\n    }\n\n    ${Sk}\n    ${Tk}\n    ${Ek}\n  `}(l);return e.isPacked?(c=function(t,e){switch(t.length){case 0:return Ak();case 1:return function(t,e){const n=[Math.ceil(e[0]/2),Math.ceil(e[1]/2)];if(1===n[0])return`\n      int getOutputCoords() {\n        return 2 * int(resultUV.x * ${n[1]}.0);\n      }\n    `;if(1===n[1])return`\n      int getOutputCoords() {\n        return 2 * int(resultUV.y * ${n[0]}.0);\n      }\n    `;return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      return 2 * (resTexRC.x * ${n[1]} + resTexRC.y);\n    }\n  `}(0,e);case 2:return function(t,e){const n=[Math.ceil(e[0]/2),Math.ceil(e[1]/2)];if(d(t,e))return`\n      ivec2 getOutputCoords() {\n        return 2 * ivec2(resultUV.yx * vec2(${n[0]}, ${n[1]}));\n      }\n    `;const s=Math.ceil(t[1]/2);return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n      int r = 2 * (index / ${s});\n      int c = imod(index, ${s}) * 2;\n\n      return ivec2(r, c);\n    }\n  `}(t,e);case 3:return function(t,e){const n=[Math.ceil(e[0]/2),Math.ceil(e[1]/2)],s=Math.ceil(t[2]/2),r=s*Math.ceil(t[1]/2);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      int b = index / ${r};\n      index -= b * ${r};\n\n      int r = 2 * (index / ${s});\n      int c = imod(index, ${s}) * 2;\n\n      return ivec3(b, r, c);\n    }\n  `}(t,e);default:return function(t,e){const n=[Math.ceil(e[0]/2),Math.ceil(e[1]/2)],s=Math.ceil(t[t.length-1]/2),r=s*Math.ceil(t[t.length-2]/2);let a=r,i="",o="b, r, c";for(let e=2;e<t.length-1;e++)a*=t[t.length-e-1],i=`\n      int b${e} = index / ${a};\n      index -= b${e} * ${a};\n    `+i,o=`b${e}, `+o;return`\n    ivec${t.length} getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      ${i}\n\n      int b = index / ${r};\n      index -= b * ${r};\n\n      int r = 2 * (index / ${s});\n      int c = imod(index, ${s}) * 2;\n\n      return ivec${t.length}(${o});\n    }\n  `}(t,e)}}(e.logicalShape,o),h=function(t){return`\n    void setOutput(vec4 val) {\n      ${t.output} = val;\n    }\n  `}(l)):(c=function(t,e){switch(t.length){case 0:return Ak();case 1:return function(t,e){if(1===e[0])return`\n      int getOutputCoords() {\n        return int(resultUV.x * ${e[1]}.0);\n      }\n    `;if(1===e[1])return`\n      int getOutputCoords() {\n        return int(resultUV.y * ${e[0]}.0);\n      }\n    `;return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${e[0]}, ${e[1]}));\n      return resTexRC.x * ${e[1]} + resTexRC.y;\n    }\n  `}(0,e);case 2:return function(t,e){if(d(t,e))return`\n      ivec2 getOutputCoords() {\n        return ivec2(resultUV.yx * vec2(${e[0]}, ${e[1]}));\n      }\n    `;if(1===t[1])return`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${e[0]}, ${e[1]}));\n        int index = resTexRC.x * ${e[1]} + resTexRC.y;\n        return ivec2(index, 0);\n      }\n    `;if(1===t[0])return`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${e[0]}, ${e[1]}));\n        int index = resTexRC.x * ${e[1]} + resTexRC.y;\n        return ivec2(0, index);\n      }\n    `;return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${e[0]}, ${e[1]}));\n      int index = resTexRC.x * ${e[1]} + resTexRC.y;\n      int r = index / ${t[1]};\n      int c = index - r * ${t[1]};\n      return ivec2(r, c);\n    }\n  `}(t,e);case 3:return function(t,e){const n=xk(["r","c","d"],t);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${e[0]}, ${e[1]}));\n      int index = resTexRC.x * ${e[1]} + resTexRC.y;\n      ${n}\n      return ivec3(r, c, d);\n    }\n  `}(t,e);case 4:return function(t,e){const n=xk(["r","c","d","d2"],t);return`\n    ivec4 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${e[0]}, ${e[1]}));\n      int index = resTexRC.x * ${e[1]} + resTexRC.y;\n      ${n}\n      return ivec4(r, c, d, d2);\n    }\n  `}(t,e);case 5:return function(t,e){const n=xk(["r","c","d","d2","d3"],t);return`\n    ivec5 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx * vec2(${e[0]},\n                             ${e[1]}));\n\n      int index = resTexRC.x * ${e[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec5 outShape = ivec5(r, c, d, d2, d3);\n      return outShape;\n    }\n  `}(t,e);case 6:return function(t,e){const n=xk(["r","c","d","d2","d3","d4"],t);return`\n    ivec6 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${e[0]}, ${e[1]}));\n      int index = resTexRC.x * ${e[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec6 result = ivec6(r, c, d, d2, d3, d4);\n      return result;\n    }\n  `}(t,e);default:throw new Error(t.length+"-D output sampling is not yet supported")}}(e.logicalShape,o),h=function(t){return`\n    void setOutput(float val) {\n      ${t.output} = vec4(val, 0, 0, 0);\n    }\n  `}(l)),s&&(f+=$k),[f,u,h,a,c,i,n].join("\n")}function Ik(t){const e=t.shapeInfo.logicalShape;switch(e.length){case 0:return function(t){const e=t.name,n="get"+e.charAt(0).toUpperCase()+e.slice(1);if(t.shapeInfo.isUniform)return`float ${n}() {return ${e};}`;const[s,r]=t.shapeInfo.texShape;if(1===s&&1===r)return`\n      float ${n}() {\n        return sampleTexture(${e}, halfCR);\n      }\n    `;const[a,i]=t.shapeInfo.texShape,o=Rk(e);return`\n    float ${n}() {\n      vec2 uv = uvFromFlat(${a}, ${i}, ${o});\n      return sampleTexture(${e}, uv);\n    }\n  `}(t);case 1:return function(t){const e=t.name,n="get"+e.charAt(0).toUpperCase()+e.slice(1);if(t.shapeInfo.isUniform)return`\n      float ${n}(int index) {\n        ${Dk(t)}\n      }\n    `;const s=t.shapeInfo.texShape,r=s[0],a=s[1];if(1===a&&1===r)return`\n      float ${n}(int index) {\n        return sampleTexture(${e}, halfCR);\n      }\n    `;const i=Rk(e);if(1===a)return`\n      float ${n}(int index) {\n        vec2 uv = vec2(0.5, (float(index + ${i}) + 0.5) / ${r}.0);\n        return sampleTexture(${e}, uv);\n      }\n    `;if(1===r)return`\n      float ${n}(int index) {\n        vec2 uv = vec2((float(index + ${i}) + 0.5) / ${a}.0, 0.5);\n        return sampleTexture(${e}, uv);\n      }\n    `;return`\n    float ${n}(int index) {\n      vec2 uv = uvFromFlat(${r}, ${a}, index + ${i});\n      return sampleTexture(${e}, uv);\n    }\n  `}(t);case 2:return function(t){const e=t.shapeInfo.logicalShape,n=t.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t.shapeInfo.texShape;if(null!=r&&d(e,r)){const t=r[0],e=r[1];return`\n    float ${s}(int row, int col) {\n      vec2 uv = (vec2(col, row) + halfCR) / vec2(${e}.0, ${t}.0);\n      return sampleTexture(${n}, uv);\n    }\n  `}const{newShape:a,keptDims:i}=w(e),o=a;if(o.length<e.length){const e=Fk(t,o),n=["row","col"];return`\n      ${Ik(e)}\n      float ${s}(int row, int col) {\n        return ${s}(${Ok(n,i)});\n      }\n    `}if(t.shapeInfo.isUniform)return`\n      float ${s}(int row, int col) {\n        int index = round(dot(vec2(row, col), vec2(${e[1]}, 1)));\n        ${Dk(t)}\n      }\n    `;const l=r[0],u=r[1],c=Rk(n);if(1===u)return`\n    float ${s}(int row, int col) {\n      float index = dot(vec3(row, col, ${c}), vec3(${e[1]}, 1, 1));\n      vec2 uv = vec2(0.5, (index + 0.5) / ${l}.0);\n      return sampleTexture(${n}, uv);\n    }\n  `;if(1===l)return`\n    float ${s}(int row, int col) {\n      float index = dot(vec3(row, col, ${c}), vec3(${e[1]}, 1, 1));\n      vec2 uv = vec2((index + 0.5) / ${u}.0, 0.5);\n      return sampleTexture(${n}, uv);\n    }\n  `;return`\n  float ${s}(int row, int col) {\n    // Explicitly use integer operations as dot() only works on floats.\n    int index = row * ${e[1]} + col + ${c};\n    vec2 uv = uvFromFlat(${l}, ${u}, index);\n    return sampleTexture(${n}, uv);\n  }\n`}(t);case 3:return function(t){const e=t.shapeInfo.logicalShape,n=t.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e[1]*e[2],a=e[2],{newShape:i,keptDims:o}=w(e),l=i;if(l.length<e.length){const e=Fk(t,l),n=["row","col","depth"];return`\n        ${Ik(e)}\n        float ${s}(int row, int col, int depth) {\n          return ${s}(${Ok(n,o)});\n        }\n      `}if(t.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth) {\n        int index = round(dot(vec3(row, col, depth),\n                          vec3(${r}, ${a}, 1)));\n        ${Dk(t)}\n      }\n    `;const u=t.shapeInfo.texShape,c=u[0],h=u[1],p=t.shapeInfo.flatOffset;if(h===r&&null==p)return`\n        float ${s}(int row, int col, int depth) {\n          float texR = float(row);\n          float texC = dot(vec2(col, depth), vec2(${a}, 1));\n          vec2 uv = (vec2(texC, texR) + halfCR) /\n                     vec2(${h}.0, ${c}.0);\n          return sampleTexture(${n}, uv);\n        }\n      `;if(h===a&&null==p)return`\n    float ${s}(int row, int col, int depth) {\n      float texR = dot(vec2(row, col), vec2(${e[1]}, 1));\n      float texC = float(depth);\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${h}.0, ${c}.0);\n      return sampleTexture(${n}, uv);\n    }\n  `;const d=Rk(n);return`\n      float ${s}(int row, int col, int depth) {\n        // Explicitly use integer operations as dot() only works on floats.\n        int index = row * ${r} + col * ${a} + depth + ${d};\n        vec2 uv = uvFromFlat(${c}, ${h}, index);\n        return sampleTexture(${n}, uv);\n      }\n  `}(t);case 4:return function(t){const e=t.shapeInfo.logicalShape,n=t.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e[3],a=e[2]*r,i=e[1]*a,{newShape:o,keptDims:l}=w(e);if(o.length<e.length){const e=Fk(t,o),n=["row","col","depth","depth2"];return`\n      ${Ik(e)}\n      float ${s}(int row, int col, int depth, int depth2) {\n        return ${s}(${Ok(n,l)});\n      }\n    `}if(t.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth, int depth2) {\n        int index = round(dot(vec4(row, col, depth, depth2),\n                          vec4(${i}, ${a}, ${r}, 1)));\n        ${Dk(t)}\n      }\n    `;const u=t.shapeInfo.flatOffset,c=t.shapeInfo.texShape,h=c[0],p=c[1];if(p===i&&null==u)return`\n      float ${s}(int row, int col, int depth, int depth2) {\n        float texR = float(row);\n        float texC =\n            dot(vec3(col, depth, depth2),\n                vec3(${a}, ${r}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${p}.0, ${h}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(p===r&&null==u)return`\n      float ${s}(int row, int col, int depth, int depth2) {\n        float texR = dot(vec3(row, col, depth),\n                         vec3(${e[1]*e[2]}, ${e[2]}, 1));\n        float texC = float(depth2);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${p}.0, ${h}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const d=Rk(n);return`\n    float ${s}(int row, int col, int depth, int depth2) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${i} + col * ${a} +\n          depth * ${r} + depth2;\n      vec2 uv = uvFromFlat(${h}, ${p}, index + ${d});\n      return sampleTexture(${n}, uv);\n    }\n  `}(t);case 5:return function(t){const e=t.shapeInfo.logicalShape,n=t.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e[4],a=e[3]*r,i=e[2]*a,o=e[1]*i,{newShape:l,keptDims:u}=w(e);if(l.length<e.length){const e=Fk(t,l),n=["row","col","depth","depth2","depth3"];return`\n      ${Ik(e)}\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        return ${s}(${Ok(n,u)});\n      }\n    `}if(t.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        float index = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${o}, ${i}, ${a}, ${r})) +\n          depth3;\n        ${Dk(t)}\n      }\n    `;const c=t.shapeInfo.flatOffset,h=t.shapeInfo.texShape,p=h[0],d=h[1];if(d===o&&null==c)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n                         vec4(${i}, ${a}, ${r}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${d}.0, ${p}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(d===r&&null==c)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        float texR = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${e[1]*e[2]*e[3]},\n               ${e[2]*e[3]}, ${e[3]}, 1));\n        int texC = depth3;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${d}.0, ${p}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const f=Rk(n);return`\n    float ${s}(int row, int col, int depth, int depth2, int depth3) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${o} + col * ${i} + depth * ${a} +\n          depth2 * ${r} + depth3 + ${f};\n      vec2 uv = uvFromFlat(${p}, ${d}, index);\n      return sampleTexture(${n}, uv);\n    }\n  `}(t);case 6:return function(t){const e=t.shapeInfo.logicalShape,n=t.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),{newShape:r,keptDims:a}=w(e);if(r.length<e.length){const e=Fk(t,r),n=["row","col","depth","depth2","depth3","depth4"];return`\n      ${Ik(e)}\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        return ${s}(${Ok(n,a)});\n      }\n    `}const i=e[5],o=e[4]*i,l=e[3]*o,u=e[2]*l,c=e[1]*u;if(t.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n        int index = round(dot(\n          vec4(row, col, depth, depth2),\n          vec4(${c}, ${u}, ${l}, ${o})) +\n          dot(\n            vec2(depth3, depth4),\n            vec2(${i}, 1)));\n        ${Dk(t)}\n      }\n    `;const h=t.shapeInfo.flatOffset,p=t.shapeInfo.texShape,d=p[0],f=p[1];if(f===c&&null==h)return`\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n          vec4(${u}, ${l}, ${o}, ${i})) +\n               float(depth4);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${f}.0, ${d}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(f===i&&null==h)return`\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        float texR = dot(vec4(row, col, depth, depth2),\n          vec4(${e[1]*e[2]*e[3]*e[4]},\n               ${e[2]*e[3]*e[4]},\n               ${e[3]*e[4]},\n               ${e[4]})) + float(depth3);\n        int texC = depth4;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${f}.0, ${d}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const m=Rk(n);return`\n    float ${s}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${c} + col * ${u} + depth * ${l} +\n          depth2 * ${o} + depth3 * ${i} + depth4 + ${m};\n      vec2 uv = uvFromFlat(${d}, ${f}, index);\n      return sampleTexture(${n}, uv);\n    }\n  `}(t);default:throw new Error(e.length+"-D input sampling is not yet supported")}}function Ck(t){switch(t.shapeInfo.logicalShape.length){case 0:return function(t){const e=t.name,n="get"+e.charAt(0).toUpperCase()+e.slice(1),s=bk();return`\n    vec4 ${n}() {\n      return ${s.texture2D}(${e}, halfCR);\n    }\n  `}(t);case 1:return function(t){const e=t.name,n="get"+e.charAt(0).toUpperCase()+e.slice(1),s=t.shapeInfo.texShape,r=[Math.ceil(s[0]/2),Math.ceil(s[1]/2)],a=bk();return`\n    vec4 ${n}(int index) {\n      vec2 uv = packedUVfrom1D(\n        ${r[0]}, ${r[1]}, index);\n      return ${a.texture2D}(${e}, uv);\n    }\n  `}(t);case 2:return function(t){const e=t.shapeInfo.logicalShape,n=t.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t.shapeInfo.texShape,a=r[0],i=r[1],o=bk();if(null!=r&&d(e,r))return`\n      vec4 ${s}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${i}.0, ${a}.0);\n\n        return ${o.texture2D}(${n}, uv);\n      }\n    `;const l=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)],u=Math.ceil(e[1]/2);return`\n    vec4 ${s}(int row, int col) {\n      vec2 uv = packedUVfrom2D(${u}, ${l[0]}, ${l[1]}, row, col);\n      return ${o.texture2D}(${n}, uv);\n    }\n  `}(t);case 3:return function(t){const e=t.shapeInfo.logicalShape,n=t.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t.shapeInfo.texShape,a=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)];if(1===e[0]){const n=e.slice(1),r=[1,2],a=Fk(t,n),i=["b","row","col"];return`\n        ${Ck(a)}\n        vec4 ${s}(int b, int row, int col) {\n          return ${s}(${Ok(i,r)});\n        }\n      `}const i=a[0],o=a[1],l=Math.ceil(e[2]/2),u=l*Math.ceil(e[1]/2),c=bk();return`\n    vec4 ${s}(int b, int row, int col) {\n      vec2 uv = packedUVfrom3D(\n        ${i}, ${o}, ${u}, ${l}, b, row, col);\n      return ${c.texture2D}(${n}, uv);\n    }\n  `}(t);default:return function(t){const e=t.shapeInfo.logicalShape,n=e.length,s=t.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=t.shapeInfo.texShape,i=[Math.ceil(a[0]/2),Math.ceil(a[1]/2)],o=i[0],l=i[1],u=Math.ceil(e[n-1]/2);let c=u*Math.ceil(e[n-2]/2),h="int b, int row, int col",p=`b * ${c} + (row / 2) * ${u} + (col / 2)`;for(let t=2;t<n-1;t++)h=`int b${t}, `+h,c*=e[n-t-1],p=`b${t} * ${c} + `+p;const d=bk();return`\n    vec4 ${r}(${h}) {\n      int index = ${p};\n      int texR = index / ${l};\n      int texC = index - texR * ${l};\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${l}, ${o});\n      return ${d.texture2D}(${s}, uv);\n    }\n  `}(t)}}const Sk="\nvec2 uvFromFlat(int texNumR, int texNumC, int index) {\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\nvec2 packedUVfrom1D(int texNumR, int texNumC, int index) {\n  int texelIndex = index / 2;\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",Tk="\nvec2 packedUVfrom2D(int texelsInLogicalRow, int texNumR,\n  int texNumC, int row, int col) {\n  int texelIndex = (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",Ek="\nvec2 packedUVfrom3D(int texNumR, int texNumC,\n    int texelsInBatch, int texelsInLogicalRow, int b,\n    int row, int col) {\n  int index = b * texelsInBatch + (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",$k="\n  float getChannel(vec4 frag, vec2 innerDims) {\n    vec2 modCoord = mod(innerDims, 2.);\n    return modCoord.x == 0. ?\n      (modCoord.y == 0. ? frag.r : frag.g) :\n      (modCoord.y == 0. ? frag.b : frag.a);\n  }\n  float getChannel(vec4 frag, int dim) {\n    float modCoord = mod(float(dim), 2.);\n    return modCoord == 0. ? frag.r : frag.g;\n  }\n";function Ak(){return"\n    int getOutputCoords() {\n      return 0;\n    }\n  "}function Rk(t){return"offset"+t}function Dk(t){const e=t.name,n=p(t.shapeInfo.logicalShape);return n<2?`return ${e};`:`\n    for (int i = 0; i < ${n}; i++) {\n      if (i == index) {\n        return ${e}[i];\n      }\n    }\n  `}function _k(t){if(t<=1)return"int";if(2===t)return"ivec2";if(3===t)return"ivec3";if(4===t)return"ivec4";if(5===t)return"ivec5";if(6===t)return"ivec6";throw Error(`GPU for rank ${t} is not yet supported`)}function Fk(t,e){const n=JSON.parse(JSON.stringify(t));return n.shapeInfo.logicalShape=e,n}function Ok(t,e){return e.map(e=>t[e]).join(", ")}class Mk{constructor(t,e,n,s){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,l(t.length>2,()=>`Packed arg${n.charAt(0).toUpperCase()+n.slice(1)} supports only inputs with rank above 2.`);const r=t[t.length-1],a=Math.ceil(r/e);this.outputShape=t.slice(0,-1),a>1&&this.outputShape.push(a),s||this.variableNames.push("bestIndicesA");const i=this.outputShape,o=i.length,u=_k(o),c=yk("coords",o);let h,p;if(1===a){p=o+1;const t=_k(p);h=`\n        ${t} sourceLocR = ${t}(${c.join()}, 0);\n        ++${c[o-1]};\n        ${t} sourceLocG = ${t}(${c.join()}, 0);\n        ++${c[o-2]};\n        ${t} sourceLocA = ${t}(${c.join()}, 0);\n        --${c[o-1]};\n        ${t} sourceLocB = ${t}(${c.join()}, 0);\n        --${c[o-2]};`}else p=o,h=`\n        ${u} sourceLocR = coords;\n        ++${c[o-1]};\n        ${u} sourceLocG = coords;\n        ++${c[o-2]};\n        ${u} sourceLocA = coords;\n        --${c[o-1]};\n        ${u} sourceLocB = coords;\n        --${c[o-2]};`;const d=["x","y","z","w","u","v"].slice(0,p),f="."+d[p-1],m=d.map(t=>"int "+t),g=yk("sourceLocR",p-1).concat("inIdx.r"),y=yk("sourceLocG",p-1).concat("inIdx.g"),b=yk("sourceLocB",p-1).concat("inIdx.b"),x=yk("sourceLocA",p-1).concat("inIdx.a"),w="max"===n?"greaterThan":"lessThan",v=s?"":`\n          inIdx = round(vec4(getBestIndicesAChannel(${g.join()}),\n                             getBestIndicesAChannel(${y.join()}),\n                             getBestIndicesAChannel(${b.join()}),\n                             getBestIndicesAChannel(${x.join()})));`,k=`vec4(\n            getAChannel(${g.join()}),\n            hasNextCol ? getAChannel(${y.join()}) : 0.,\n            hasNextRow ? getAChannel(${b.join()}) : 0.,\n            hasNextRow && hasNextCol ? getAChannel(${x.join()}) : 0.)`,N=s?"":`\n      float getBestIndicesAChannel(${m.join()}) {\n        return getChannel(getBestIndicesA(${d.join()}),\n                                          vec2(${d.slice(-2).join()}));\n      }`;this.userCode=`\n      float getAChannel(${m.join()}) {\n        return getChannel(getA(${d.join()}),\n                               vec2(${d.slice(-2).join()}));\n      }\n      ${N}\n      void main() {\n        ${u} coords = getOutputCoords();\n        bool hasNextCol = ${c[o-1]} < ${i[o-1]-1};\n        bool hasNextRow = ${c[o-2]} < ${i[o-2]-1};\n        ${h}\n        ivec4 srcIdx = ivec4(sourceLocR${f}, sourceLocG${f},\n          sourceLocB${f}, sourceLocA${f}) * ${e};\n        ivec4 inIdx = srcIdx;\n        vec4 bestIndex = vec4(inIdx);\n        vec4 bestValue = ${k};\n\n        for (int i = 0; i < ${e}; i++) {\n          inIdx = srcIdx;\n          ${v}\n          vec4 candidate = ${k};\n          bvec4 nan = isnan(candidate);\n          bvec4 replace = bvec4(\n            vec4(${w}(candidate, bestValue)) * (vec4(1.0) - vec4(nan)));\n\n          bestValue = vec4(replace.x  ? candidate.x : bestValue.x,\n                           replace.y  ? candidate.y : bestValue.y,\n                           replace.z  ? candidate.z : bestValue.z,\n                           replace.w  ? candidate.w : bestValue.w);\n          bestIndex = mix(bestIndex, vec4(inIdx), vec4(replace));\n          srcIdx++;\n        }\n        setOutput(bestIndex);\n      }\n    `}}class Lk{constructor(t){this.variableNames=["dy"],this.outputShape=t.inShape;const e=t.filterHeight,n=t.filterWidth,s=t.strideHeight,r=t.strideWidth,a=t.dilationHeight,i=t.dilationWidth,o=t.effectiveFilterHeight,l=t.effectiveFilterWidth,u=o-1-t.padInfo.top,c=l-1-t.padInfo.left,h=1/(e*n);this.userCode=`\n      const ivec2 pads = ivec2(${u}, ${c});\n      const float avgMultiplier = float(${h});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${o};\n            wR += ${a}) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${t.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${l};\n            wC+= ${i}) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${t.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n\n            dotProd += dyValue * avgMultiplier;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class zk{constructor(t){this.variableNames=["dy"],this.outputShape=t.inShape;const e=t.filterDepth,n=t.filterHeight,s=t.filterWidth,r=t.strideDepth,a=t.strideHeight,i=t.strideWidth,o=t.dilationDepth,l=t.dilationHeight,u=t.dilationWidth,c=t.effectiveFilterDepth,h=t.effectiveFilterHeight,p=t.effectiveFilterWidth,d=c-1-t.padInfo.front,f=h-1-t.padInfo.top,m=p-1-t.padInfo.left,g=1/(e*n*s);this.userCode=`\n      const ivec3 pads = ivec3(${d}, ${f}, ${m});\n      const float avgMultiplier = float(${g});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, d) with pos mask(:, :, :, ch) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${c};\n            wD += ${o}) {\n          float dyD = float(dyDCorner + wD) / ${r}.0;\n\n          if (dyD < 0.0 || dyD >= ${t.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${h};\n              wR += ${l}) {\n            float dyR = float(dyRCorner + wR) / ${a}.0;\n\n            if (dyR < 0.0 || dyR >= ${t.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${p};\n                wC += ${u}) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${t.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n\n              dotProd += dyValue * avgMultiplier;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const Bk="return (a < 0.) ? b * a : a;";class Pk{constructor(t,e,n){this.variableNames=["A","B"],this.outputShape=Cr(e,n),this.userCode=`\n      float binaryOperation(float a, float b) {\n        ${t}\n      }\n\n      void main() {\n        float a = getAAtOutCoords();\n        float b = getBAtOutCoords();\n        setOutput(binaryOperation(a, b));\n      }\n    `}}const Wk="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";class Vk{constructor(t,e,n,s=!1){this.variableNames=["A","B"],this.supportsBroadcasting=!0,this.packedInputs=!0,this.packedOutput=!0,this.outputShape=Cr(e,n);const r=this.outputShape.length;let a="";if(s)if(0===r||1===p(this.outputShape))a="\n          result.y = 0.;\n          result.z = 0.;\n          result.w = 0.;\n        ";else{if(a=`\n          ${_k(r)} coords = getOutputCoords();\n        `,1===r)a+=`\n            result.y = (coords + 1) >= ${this.outputShape[0]} ? 0. : result.y;\n            result.z = 0.;\n            result.w = 0.;\n          `;else{const t=yk("coords",r);a+=`\n            bool nextRowOutOfBounds =\n              (${t[r-2]} + 1) >= ${this.outputShape[r-2]};\n            bool nextColOutOfBounds =\n              (${t[r-1]} + 1) >= ${this.outputShape[r-1]};\n            result.y = nextColOutOfBounds ? 0. : result.y;\n            result.z = nextRowOutOfBounds ? 0. : result.z;\n            result.w = nextColOutOfBounds || nextRowOutOfBounds ? 0. : result.w;\n          `}}this.userCode=`\n      vec4 binaryOperation(vec4 a, vec4 b) {\n        ${t}\n      }\n\n      void main() {\n        vec4 a = getAAtOutCoords();\n        vec4 b = getBAtOutCoords();\n\n        vec4 result = binaryOperation(a, b);\n        ${a}\n\n        setOutput(result);\n      }\n    `}}class Uk{constructor(t){this.variableNames=["A"],this.outputShape=t,this.userCode="\n      uniform float minVal;\n      uniform float maxVal;\n\n      void main() {\n        float value = getAAtOutCoords();\n        if (isnan(value)) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, minVal, maxVal));\n      }\n    "}getCustomSetupFunc(t,e){return(n,s)=>{null==this.minLoc&&(this.minLoc=n.getUniformLocationNoThrow(s,"minVal"),this.maxLoc=n.getUniformLocationNoThrow(s,"maxVal")),n.gl.uniform1f(this.minLoc,t),n.gl.uniform1f(this.maxLoc,e)}}}class Gk{constructor(t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t,this.userCode="\n      uniform float minVal;\n      uniform float maxVal;\n\n      void main() {\n        vec4 value = getAAtOutCoords();\n\n        if (any(isnan(value))) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, vec4(minVal), vec4(maxVal)));\n      }\n    "}getCustomSetupFunc(t,e){return(n,s)=>{null==this.minLoc&&(this.minLoc=n.getUniformLocationNoThrow(s,"minVal"),this.maxLoc=n.getUniformLocationNoThrow(s,"maxVal")),n.gl.uniform1f(this.minLoc,t),n.gl.uniform1f(this.maxLoc,e)}}}class Hk{constructor(t){this.variableNames=["real","imag"],this.outputShape=t,this.userCode="\n      void main() {\n        float re = abs(getRealAtOutCoords());\n        float im = abs(getImagAtOutCoords());\n        float mx = max(re, im);\n\n        // sadly the length function in glsl is not underflow-safe\n        // (at least not on Intel GPUs). So the safe solution is\n        // to ensure underflow-safety in all cases.\n        setOutput(\n          mx == 0.0 ? 0.0 : mx * length(vec2(1, min(re, im)/mx))\n        );\n      }\n    "}}class jk{constructor(t){this.variableNames=["x","dy"],this.outputShape=t.filterShape;const e=t.strideHeight,n=t.strideWidth,s=t.padInfo.top,r=t.padInfo.left,a="channelsLast"===t.dataFormat;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int d2 = coords.w;\n\n        // Convolve x(?, ?, d1) with dy(:, :, d2) to get dw(wR, wC, d1, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${t.batchSize}; b++) {\n          for (int yR = 0; yR < ${t.outHeight}; yR++) {\n            int xR = wR + yR * ${e} - ${s};\n\n            if (xR < 0 || xR >= ${t.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${t.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${r};\n\n              if (xC < 0 || xC >= ${t.inWidth}) {\n                continue;\n              }\n\n              if (${a}) {\n                float dyValue = getDy(b, yR, yC, d2);\n                float xValue = getX(b, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              } else {\n                float dyValue = getDy(b, d2, yR, yC);\n                float xValue = getX(b, d1, xR, xC);\n                dotProd += (xValue * dyValue);\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class qk{constructor(t){this.variableNames=["dy","W"],this.outputShape=t.inShape;const e=t.filterHeight,n=t.filterWidth,s=t.strideHeight,r=t.strideWidth,a="channelsLast"===t.dataFormat,i=e-1-t.padInfo.top,o=n-1-t.padInfo.left,l=a?1:2,u=a?2:3,c=a?3:1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${o});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[${c}];\n\n        ivec2 dyCorner = ivec2(coords[${l}], coords[${u}]) - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${e}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${t.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${e} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${t.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            for (int d2 = 0; d2 < ${t.outChannels}; d2++) {\n\n              if (${a}) {\n                float xValue = getDy(batch, idyR, idyC, d2);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              } else {\n                float xValue = getDy(batch, d2, idyR, idyC);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class Kk{constructor(t){this.variableNames=["x","dy"],this.outputShape=t.filterShape;const e=t.strideDepth,n=t.strideHeight,s=t.strideWidth,r=t.padInfo.front,a=t.padInfo.top,i=t.padInfo.left;this.userCode=`\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int wF = coords.x;\n        int wR = coords.y;\n        int wC = coords.z;\n        int d1 = coords.w;\n        int d2 = coords.u;\n\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${t.batchSize}; b++) {\n          for (int yF = 0; yF < ${t.outDepth}; yF++) {\n            int xF = wF + yF * ${e} - ${r};\n\n            if (xF < 0 || xF >= ${t.inDepth}) {\n              continue;\n            }\n\n            for (int yR = 0; yR < ${t.outHeight}; yR++) {\n              int xR = wR + yR * ${n} - ${a};\n\n              if (xR < 0 || xR >= ${t.inHeight}) {\n                continue;\n              }\n\n              for (int yC = 0; yC < ${t.outWidth}; yC++) {\n                int xC = wC + yC * ${s} - ${i};\n\n                if (xC < 0 || xC >= ${t.inWidth}) {\n                  continue;\n                }\n\n                float dyValue = getDy(b, yF, yR, yC, d2);\n                float xValue = getX(b, xF, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class Xk{constructor(t){this.variableNames=["dy","W"],this.outputShape=t.inShape;const e=t.filterDepth,n=t.filterHeight,s=t.filterWidth,r=t.strideDepth,a=t.strideHeight,i=t.strideWidth,o=e-1-t.padInfo.front,l=n-1-t.padInfo.top,u=s-1-t.padInfo.left;this.userCode=`\n      const ivec3 pads = ivec3(${o}, ${l}, ${u});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.u;\n\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyFCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${e}; wF++) {\n          float dyF = float(dyFCorner + wF) / ${r}.0;\n\n          if (dyF < 0.0 || dyF >= ${t.outDepth}.0 || fract(dyF) > 0.0) {\n            continue;\n          }\n          int idyF = int(dyF);\n\n          int wFPerm = ${e} - 1 - wF;\n\n          for (int wR = 0; wR < ${n}; wR++) {\n            float dyR = float(dyRCorner + wR) / ${a}.0;\n\n            if (dyR < 0.0 || dyR >= ${t.outHeight}.0 ||\n              fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            int wRPerm = ${n} - 1 - wR;\n\n            for (int wC = 0; wC < ${s}; wC++) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${t.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              int wCPerm = ${s} - 1 - wC;\n\n              for (int d2 = 0; d2 < ${t.outChannels}; d2++) {\n                float xValue = getDy(batch, idyF, idyR, idyC, d2);\n                float wValue = getW(wFPerm, wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class Yk{constructor(t){this.variableNames=["x","dy"],this.outputShape=t.filterShape;const e=t.strideHeight,n=t.strideWidth,s=t.padInfo.top,r=t.padInfo.left,a=t.outChannels/t.inChannels;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int dm = coords.w;\n        int d2 = d1 * ${a} + dm;\n\n        float dotProd = 0.0;\n\n        // TO DO: Vec4 over the batch size\n        for (int b = 0; b < ${t.batchSize}; b++) {\n          for (int yR = 0; yR < ${t.outHeight}; yR++) {\n            int xR = wR + yR * ${e} - ${s};\n\n            if (xR < 0 || xR >= ${t.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${t.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${r};\n\n              if (xC < 0 || xC >= ${t.inWidth}) {\n                continue;\n              }\n\n              float dyValue = getDy(b, yR, yC, d2);\n              float xValue = getX(b, xR, xC, d1);\n              dotProd += (xValue * dyValue);\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class Jk{constructor(t){this.variableNames=["dy","W"],this.outputShape=t.inShape;const e=t.filterHeight,n=t.filterWidth,s=t.strideHeight,r=t.strideWidth,a=e-1-t.padInfo.top,i=n-1-t.padInfo.left,o=t.outChannels/t.inChannels;this.userCode=`\n      const ivec2 pads = ivec2(${a}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[3];\n        ivec2 dyCorner = coords.yz - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        float dotProd = 0.0;\n\n        for (int wR = 0; wR < ${e}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${t.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${e} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${t.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            // TO DO: Vec4 over the channelMul\n            for (int dm = 0; dm < ${o}; dm++) {\n              int d2 = d1 * ${o} + dm;\n              float xValue = getDy(batch, idyR, idyC, d2);\n              float wValue = getW(wRPerm, wCPerm, d1, dm);\n              dotProd += xValue * wValue;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class Zk{constructor(t,e=!1,n=null,s=!1){this.variableNames=["x","W"],this.outputShape=t.outShape;const r=t.padInfo.top,a=t.padInfo.left,i=t.strideHeight,o=t.strideWidth,l=t.dilationHeight,u=t.dilationWidth,c=t.filterHeight,h=t.filterWidth,p=4*Math.floor(t.inChannels/4),d=t.inChannels%4,f="channelsLast"===t.dataFormat,m=f?1:2,g=f?2:3,y=f?3:1;let b="",x="";n&&(b=s?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,x="result = activation(result);");const w=e?"result += getBiasAtOutCoords();":"";e&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),this.userCode=`\n      ${b}\n\n      const ivec2 strides = ivec2(${i}, ${o});\n      const ivec2 pads = ivec2(${r}, ${a});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d2 = coords[${y}];\n\n        ivec2 xRCCorner =\n            ivec2(coords[${m}], coords[${g}]) * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, d2) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${c}; wR++) {\n          int xR = xRCorner + wR * ${l};\n\n          if (xR < 0 || xR >= ${t.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${h}; wC++) {\n            int xC = xCCorner + wC * ${u};\n\n            if (xC < 0 || xC >= ${t.inWidth}) {\n              continue;\n            }\n\n            for (int d1 = 0; d1 < ${p}; d1 += 4) {\n              vec4 wValues = vec4(\n                getW(wR, wC, d1, d2),\n                getW(wR, wC, d1 + 1, d2),\n                getW(wR, wC, d1 + 2, d2),\n                getW(wR, wC, d1 + 3, d2)\n              );\n\n              if (${f}) {\n                vec4 xValues = vec4(\n                  getX(batch, xR, xC, d1),\n                  getX(batch, xR, xC, d1 + 1),\n                  getX(batch, xR, xC, d1 + 2),\n                  getX(batch, xR, xC, d1 + 3)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec4 xValues = vec4(\n                  getX(batch, d1, xR, xC),\n                  getX(batch, d1 + 1, xR, xC),\n                  getX(batch, d1 + 2, xR, xC),\n                  getX(batch, d1 + 3, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n\n            if (${1===d}) {\n\n              if (${f}) {\n                dotProd +=\n                    getX(batch, xR, xC, ${p}) *\n                    getW(wR, wC, ${p}, d2);\n              } else {\n                dotProd +=\n                    getX(batch, ${p}, xR, xC) *\n                    getW(wR, wC, ${p}, d2);\n              }\n\n            } else if (${2===d}) {\n              vec2 wValues = vec2(\n                getW(wR, wC, ${p}, d2),\n                getW(wR, wC, ${p} + 1, d2)\n              );\n\n              if (${f}) {\n                vec2 xValues = vec2(\n                  getX(batch, xR, xC, ${p}),\n                  getX(batch, xR, xC, ${p} + 1)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec2 xValues = vec2(\n                  getX(batch, ${p}, xR, xC),\n                  getX(batch, ${p} + 1, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            } else if (${3===d}) {\n              vec3 wValues = vec3(\n                getW(wR, wC, ${p}, d2),\n                getW(wR, wC, ${p} + 1, d2),\n                getW(wR, wC, ${p} + 2, d2)\n              );\n\n              if (${f}) {\n                vec3 xValues = vec3(\n                  getX(batch, xR, xC, ${p}),\n                  getX(batch, xR, xC, ${p} + 1),\n                  getX(batch, xR, xC, ${p} + 2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec3 xValues = vec3(\n                  getX(batch, ${p}, xR, xC),\n                  getX(batch, ${p} + 1, xR, xC),\n                  getX(batch, ${p} + 2, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            }\n          }\n        }\n\n        float result = dotProd;\n        ${w}\n        ${x}\n        setOutput(result);\n      }\n    `}}class Qk{constructor(t){this.variableNames=["x","W"],this.outputShape=t.outShape;const e=t.padInfo.front,n=t.padInfo.top,s=t.padInfo.left,r=t.strideDepth,a=t.strideHeight,i=t.strideWidth,o=t.dilationDepth,l=t.dilationHeight,u=t.dilationWidth,c=t.filterDepth,h=t.filterHeight,p=t.filterWidth,d=4*Math.floor(t.inChannels/4),f=t.inChannels%4;this.userCode=`\n      const ivec3 strides = ivec3(${r}, ${a}, ${i});\n      const ivec3 pads = ivec3(${e}, ${n}, ${s});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d2 = coords.u;\n\n        ivec3 xFRCCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xFCorner = xFRCCorner.x;\n        int xRCorner = xFRCCorner.y;\n        int xCCorner = xFRCCorner.z;\n\n        // Convolve x(?, ?, ?, d1) with w(:, :, :, d1, d2) to get\n        // y(yF, yR, yC, d2). ? = to be determined. : = across all\n        // values in that axis.\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${c}; wF++) {\n          int xF = xFCorner + wF * ${o};\n\n          if (xF < 0 || xF >= ${t.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${h}; wR++) {\n            int xR = xRCorner + wR * ${l};\n\n            if (xR < 0 || xR >= ${t.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${p}; wC++) {\n              int xC = xCCorner + wC * ${u};\n\n              if (xC < 0 || xC >= ${t.inWidth}) {\n                continue;\n              }\n\n              for (int d1 = 0; d1 < ${d}; d1 += 4) {\n                vec4 xValues = vec4(\n                  getX(batch, xF, xR, xC, d1),\n                  getX(batch, xF, xR, xC, d1 + 1),\n                  getX(batch, xF, xR, xC, d1 + 2),\n                  getX(batch, xF, xR, xC, d1 + 3)\n                );\n                vec4 wValues = vec4(\n                  getW(wF, wR, wC, d1, d2),\n                  getW(wF, wR, wC, d1 + 1, d2),\n                  getW(wF, wR, wC, d1 + 2, d2),\n                  getW(wF, wR, wC, d1 + 3, d2)\n                );\n\n                dotProd += dot(xValues, wValues);\n              }\n\n              if (${1===f}) {\n                dotProd +=\n                  getX(batch, xF, xR, xC, ${d}) *\n                  getW(wF, wR, wC, ${d}, d2);\n              } else if (${2===f}) {\n                vec2 xValues = vec2(\n                  getX(batch, xF, xR, xC, ${d}),\n                  getX(batch, xF, xR, xC, ${d} + 1)\n                );\n                vec2 wValues = vec2(\n                  getW(wF, wR, wC, ${d}, d2),\n                  getW(wF, wR, wC, ${d} + 1, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else if (${3===f}) {\n                vec3 xValues = vec3(\n                  getX(batch, xF, xR, xC, ${d}),\n                  getX(batch, xF, xR, xC, ${d} + 1),\n                  getX(batch, xF, xR, xC, ${d} + 2)\n                );\n                vec3 wValues = vec3(\n                  getW(wF, wR, wC, ${d}, d2),\n                  getW(wF, wR, wC, ${d} + 1, d2),\n                  getW(wF, wR, wC, ${d} + 2, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class tN{constructor(t,e=!1,n=null,s=!1){this.variableNames=["x","W"],this.outputShape=t.outShape;const r=t.inHeight,a=t.inWidth,i=t.padInfo.top,o=t.padInfo.left,l=t.strideHeight,u=t.strideWidth,c=t.dilationHeight,h=t.dilationWidth,p=t.filterHeight,d=t.filterWidth,f=t.outChannels/t.inChannels;let m="",g="";n&&(m=s?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,g="result = activation(result);");const y=e?"result += getBiasAtOutCoords();":"";e&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),this.userCode=`\n      ${m}\n\n      const ivec2 strides = ivec2(${l}, ${u});\n      const ivec2 pads = ivec2(${i}, ${o});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${f};\n        int q = d2 - d1 * ${f};\n\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, q) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        // TO DO(dsmilkov): Flatten the two for loops and vec4 the operations.\n        for (int wR = 0; wR < ${p}; wR++) {\n          int xR = xRCorner + wR * ${c};\n\n          if (xR < 0 || xR >= ${r}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${d}; wC++) {\n            int xC = xCCorner + wC * ${h};\n\n            if (xC < 0 || xC >= ${a}) {\n              continue;\n            }\n\n            float xVal = getX(batch, xR, xC, d1);\n            float wVal = getW(wR, wC, d1, q);\n            dotProd += xVal * wVal;\n          }\n        }\n\n        float result = dotProd;\n        ${y}\n        ${g}\n        setOutput(result);\n      }\n    `}}class eN{constructor(t,e=!1,n=null,s=!1){this.variableNames=["x","W"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t.outShape;const r=t.inHeight,a=t.inWidth,o=t.padInfo.top,l=t.padInfo.left,u=t.strideHeight,c=t.strideWidth,h=t.dilationHeight,p=t.dilationWidth,d=t.filterHeight,f=t.filterWidth,m=f;let g="int xR; int xC; int xCOffset;";for(let t=0;t<d;t++)for(let e=0;e<f;e++)g+=`\n          vec4 xTexelR${t}C${2*e} = vec4(0.);\n          vec4 wR${t}C${e} = vec4(0.);\n          vec4 xR${t}C${e} = vec4(0.);`;for(let t=0;t<d;t++)for(let e=0;e<m;e++){const n=2*e;if(g+=`\n          xR = xRCorner + ${t*h};\n          xC = xCCorner + ${n*p};\n        `,1===c){if(n<f&&(g+=l%2==1?`\n                xCOffset = xC + 1;\n                if(xR >= 0 && xR < ${r} && xCOffset >= 0 && xCOffset < ${a}) {\n                  xTexelR${t}C${n} = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if(xCOffset + 1 >= ${a}) {\n                    xTexelR${t}C${n}.zw = vec2(0.);\n                  }\n                } else {\n                  xTexelR${t}C${n} = vec4(0.);\n                }\n\n                xCOffset = xC + 1 - 2;\n                if(xR >= 0 && xR < ${r} && xCOffset >= 0 && xCOffset < ${a}) {\n                  vec4 previous = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if(xCOffset + 1 >= ${a}) {\n                    previous.zw = vec2(0.);\n                  }\n\n                  xR${t}C${n} = vec4(previous.zw, xTexelR${t}C${n}.xy);\n                } else {\n                  xR${t}C${n} = vec4(0, 0, xTexelR${t}C${n}.xy);\n                }\n              `:`\n                if(xR >= 0 && xR < ${r} && xC >= 0 && xC < ${a}) {\n                  xTexelR${t}C${n} = getX(batch, xR, xC, d1);\n                } else {\n                  xTexelR${t}C${n} = vec4(0.);\n                }\n\n                xR${t}C${n} = xTexelR${t}C${n};\n              `,n+1<f)){const e=l%2==0?i(p):p;p%2==0&&l%2==1||p%2!=0&&l%2!=1?(g+=`\n                  xCOffset = xC + ${l%2} + ${e};\n\n                  if(xR >= 0 && xR < ${r} &&\n                    xCOffset >= 0 && xCOffset < ${a}) {\n                    xTexelR${t}C${n+2} = getX(batch, xR, xCOffset, d1);\n                  }\n                `,p>1&&(g+=`\n                    xCOffset -= 2;\n                    if(xR >= 0 && xR < ${r} &&\n                      xCOffset >= 0 && xCOffset < ${a}) {\n                      xTexelR${t}C${n} = getX(batch, xR, xCOffset, d1);\n                    } else {\n                      xTexelR${t}C${n} = vec4(0.);\n                    }\n                  `),g+=`\n                  xR${t}C${n+1} = vec4(\n                    xTexelR${t}C${n}.zw, xTexelR${t}C${n+2}.xy);\n                `):g+=`\n                  xCOffset = xC + ${e};\n\n                  if(xR >= 0 && xR < ${r} &&\n                    xCOffset >= 0 && xCOffset < ${a}) {\n                    xTexelR${t}C${n+2} = getX(batch, xR, xCOffset, d1);\n                  }\n\n                  xR${t}C${n+1} = xTexelR${t}C${n+2};\n                `}}else n<f&&(g+=`\n              if(xR >= 0 && xR < ${r}) {\n            `,l%2==1?(g+=`\n                xCOffset = xC + 1 - ${c};\n                if(xCOffset >= 0 && xCOffset < ${a}) {\n                  xTexelR${t}C${n} = getX(batch, xR, xCOffset, d1);\n                } else {\n                  xTexelR${t}C${n} = vec4(0.);\n                }\n\n                if(xC + 1 >= 0 && xC + 1 < ${a}) {\n                  xTexelR${t}C${n+2} = getX(batch, xR, xC + 1, d1);\n                } else {\n                  xTexelR${t}C${n+2} = vec4(0.);\n                }\n\n                xR${t}C${n} = vec4(\n                  xTexelR${t}C${n}.zw, xTexelR${t}C${n+2}.zw);\n              `,n+1<f&&(g+=`\n                  vec4 final = vec4(0.);\n                  xCOffset = xC + 1 + ${c};\n                  if(xCOffset >= 0 && xCOffset < ${a}) {\n                    final = getX(batch, xR, xCOffset, d1);\n                  }\n                  xR${t}C${n+1} = vec4(xTexelR${t}C${n+2}.xy, final.xy);\n                `)):(g+=`\n                if(xC >= 0 && xC < ${a}) {\n                  xTexelR${t}C${n} = getX(batch, xR, xC, d1);\n                } else {\n                  xTexelR${t}C${n} = vec4(0.);\n                }\n\n                xCOffset = xC + ${c};\n                if(xCOffset >= 0 && xCOffset < ${a}) {\n                  xTexelR${t}C${n+2} = getX(batch, xR, xCOffset, d1);\n                } else {\n                  xTexelR${t}C${n+2} = vec4(0.);\n                }\n\n                xR${t}C${n} = vec4(\n                  xTexelR${t}C${n}.xy, xTexelR${t}C${n+2}.xy);\n              `,n+1<f&&(g+=`\n                  xR${t}C${n+1} = vec4(\n                    xTexelR${t}C${n}.zw, xTexelR${t}C${n+2}.zw);\n                `)),g+="}");n<f&&(g+=`\n            vec4 wTexelR${t}C${n} = getW(${t}, ${n}, d1, q);\n            wR${t}C${n} = vec4(wTexelR${t}C${n}.xz, wTexelR${t}C${n}.xz);\n          `,n+1<f&&(g+=`\n              vec4 wTexelR${t}C${n+1} = getW(${t}, ${n+1}, d1, q);\n              wR${t}C${n+1} =\n                vec4(wTexelR${t}C${n+1}.xz, wTexelR${t}C${n+1}.xz);`))}for(let t=0;t<d;t++)for(let e=0;e<f;e++)g+=`dotProd += xR${t}C${e} * wR${t}C${e};`;let y="",b="";n&&(y=s?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:`vec4 activation(vec4 x) {\n          ${n}\n        }`,b="result = activation(result);");const x=e?"result += getBiasAtOutCoords();":"";e&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),this.userCode=`\n      ${y}\n\n      const ivec2 strides = ivec2(${u}, ${c});\n      const ivec2 pads = ivec2(${o}, ${l});\n\n      void main() {\n\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2;\n        int q = 0;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        vec4 dotProd = vec4(0.);\n\n        ${g}\n\n        vec4 result = dotProd;\n        ${x}\n        ${b}\n        setOutput(result);\n      }\n    `}}class nN{constructor(t,e,n,s,r){this.variableNames=["Image","Boxes","BoxInd"],this.outputShape=[];const[a,i,o,l]=t,[u]=e,[c,h]=n;this.outputShape=[u,c,h,l];const p="bilinear"===s?1:0,[d,f]=[i-1+".0",o-1+".0"],[m,g,y]=c>1?[""+(i-1)/(c-1),"(y2-y1) * height_ratio",`y1*${d} + float(y)*(height_scale)`]:["0.0","0.0","0.5 * (y1+y2) * "+d],[b,x,w]=h>1?[""+(o-1)/(h-1),"(x2-x1) * width_ratio",`x1*${f} + float(x)*(width_scale)`]:["0.0","0.0","0.5 * (x1+x2) * "+f];this.userCode=`\n      const float height_ratio = float(${m});\n      const float width_ratio = float(${b});\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int y = coords[1];\n        int x = coords[2];\n        int d = coords[3];\n\n        // get box vals\n        float y1 = getBoxes(b,0);\n        float x1 = getBoxes(b,1);\n        float y2 = getBoxes(b,2);\n        float x2 = getBoxes(b,3);\n\n        // get image in batch index\n        int bInd = round(getBoxInd(b));\n        if(bInd < 0 || bInd >= ${a}) {\n          return;\n        }\n\n        float height_scale = ${g};\n        float width_scale = ${x};\n\n        float in_y = ${y};\n        if( in_y < 0.0 || in_y > ${d} ) {\n          setOutput(float(${r}));\n          return;\n        }\n        float in_x = ${w};\n        if( in_x < 0.0 || in_x > ${f} ) {\n          setOutput(float(${r}));\n          return;\n        }\n\n        vec2 sourceFracIndexCR = vec2(in_x,in_y);\n        if(${p} == 1) {\n          // Compute the four integer indices.\n          ivec2 sourceFloorCR = ivec2(sourceFracIndexCR);\n          ivec2 sourceCeilCR = ivec2(ceil(sourceFracIndexCR));\n\n          float topLeft = getImage(b, sourceFloorCR.y, sourceFloorCR.x, d);\n          float bottomLeft = getImage(b, sourceCeilCR.y, sourceFloorCR.x, d);\n          float topRight = getImage(b, sourceFloorCR.y, sourceCeilCR.x, d);\n          float bottomRight = getImage(b, sourceCeilCR.y, sourceCeilCR.x, d);\n\n          vec2 fracCR = sourceFracIndexCR - vec2(sourceFloorCR);\n\n          float top = topLeft + (topRight - topLeft) * fracCR.x;\n          float bottom = bottomLeft + (bottomRight - bottomLeft) * fracCR.x;\n          float newValue = top + (bottom - top) * fracCR.y;\n          setOutput(newValue);\n        } else {\n          // Compute the coordinators of nearest neighbor point.\n          ivec2 sourceNearestCR = ivec2(floor(\n            sourceFracIndexCR + vec2(0.5,0.5)));\n          float newValue = getImage(b, sourceNearestCR.y, sourceNearestCR.x, d);\n          setOutput(newValue);\n        }\n      }\n    `}}class sN{constructor(t,e,n){this.variableNames=["x"],this.outputShape=t;const s=t.length,r=e?"0.0":`getX(${rN(s,"coords")})`,a=t[t.length-1];let i="",o="";e?(i=n?"end != "+(a-1):"end != 0",o=n?"end + 1":"end - 1"):(i=n?"end + pow2 < "+a:"end >= pow2",o=n?"end + pow2":"end - pow2"),this.userCode=`\n      uniform float index;\n      void main() {\n        ${_k(s)} coords = getOutputCoords();\n        int end = ${aN(s,"coords")};\n        float val = ${r};\n        int pow2 = int(pow(2.0, index));\n        if (${i}) {\n          int idx = ${o};\n          ${aN(s,"coords")} = idx;\n          val += getX(${rN(s,"coords")});\n        }\n        setOutput(val);\n      }\n    `}getCustomSetupFunc(t){return(e,n)=>{null==this.index&&(this.index=e.getUniformLocation(n,"index")),e.gl.uniform1f(this.index,t)}}}function rN(t,e){if(1===t)return""+e;if(2===t)return`${e}.x, ${e}.y`;if(3===t)return`${e}.x, ${e}.y, ${e}.z`;if(4===t)return`${e}.x, ${e}.y, ${e}.z, ${e}.w`;throw Error(`Cumulative sum for rank ${t} is not yet supported`)}function aN(t,e){if(1===t)return""+e;if(2===t)return e+".y";if(3===t)return e+".z";if(4===t)return e+".w";throw Error(`Cumulative sum for rank ${t} is not yet supported`)}class iN{constructor(t){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outPackingScheme=wv.DENSE;const e=Iv(t),n=bk();this.outputShape=t,this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${xk(["r","c","d"],t)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n          vec2(${e[0]}, ${e[1]}));\n        int index = 4 * (resTexRC.x * ${e[1]} + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getA(rc.x, rc.y, rc.z);\n        }\n\n        ${n.output} = result;\n      }\n    `}}class oN{constructor(t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outPackingScheme=wv.DENSE;const e=Iv(t),n=bk();this.outputShape=t,this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${xk(["r","c","d"],t)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n          vec2(${e[0]}, ${e[1]}));\n        int index = 4 * (resTexRC.x * ${e[1]} + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getChannel(getA(rc.x, rc.y, rc.z), vec2(rc.y, rc.z));\n        }\n\n        ${n.output} = result;\n      }\n    `}}class lN{constructor(t,e,n){this.variableNames=["x"],this.outputShape=[],this.outputShape=t,this.blockSize=e,this.dataFormat=n,this.userCode=`\n    void main() {\n      ivec4 coords = getOutputCoords();\n      int b = coords[0];\n      int h = ${this.getHeightCoordString()};\n      int w = ${this.getWidthCoordString()};\n      int d = ${this.getDepthCoordString()};\n\n      int in_h = h / ${e};\n      int offset_h = imod(h, ${e});\n      int in_w = w / ${e};\n      int offset_w = imod(w, ${e});\n      int offset_d = (offset_h * ${e} + offset_w) *\n        ${this.getOutputDepthSize()};\n      int in_d = d + offset_d;\n\n      float result = ${this.getInputSamplingString()};\n      setOutput(result);\n    }\n  `}getHeightCoordString(){return"NHWC"===this.dataFormat?"coords[1]":"coords[2]"}getWidthCoordString(){return"NHWC"===this.dataFormat?"coords[2]":"coords[3]"}getDepthCoordString(){return"NHWC"===this.dataFormat?"coords[3]":"coords[1]"}getOutputDepthSize(){return"NHWC"===this.dataFormat?this.outputShape[3]:this.outputShape[1]}getInputSamplingString(){return"NHWC"===this.dataFormat?"getX(b, in_h, in_w, in_d)":"getX(b, in_d, in_h, in_w)"}}class uN{constructor(t){this.variableNames=["X"],this.outputShape=[t,t],this.userCode="\n      void main() {\n          ivec2 coords = getOutputCoords();\n          float val = coords[0] == coords[1] ? getX(coords[0]) : 0.0;\n          setOutput(val);\n      }\n    "}}class cN{constructor(t){this.variableNames=["A"],this.outTexUsage=vv.DOWNLOAD;const e=bk();this.outputShape=t,this.userCode=`\n      ${vk}\n\n      void main() {\n        float x = getAAtOutCoords();\n        ${e.output} = encode_float(x);\n      }\n    `}}class hN{constructor(t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outTexUsage=vv.DOWNLOAD;const e=bk();this.outputShape=t,this.userCode=`\n      ${vk}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n        float x = getChannel(getAAtOutCoords(), vec2(coords.y, coords.z));\n        ${e.output} = encode_float(x);\n      }\n    `}}class pN{constructor(t,e,n=!1){this.variableNames=["A"];const s=bk(),[r,a]=e;this.outputShape=t;let i="result";n&&(i="floor(result * 255. + 0.5)"),this.userCode=`\n      ${wk(t)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        int flatIndex = getFlatIndex(coords);\n        int offset = imod(flatIndex, 4);\n\n        flatIndex = idiv(flatIndex, 4, 1.);\n\n        int r = flatIndex / ${a};\n        int c = imod(flatIndex, ${a});\n        vec2 uv = (vec2(c, r) + halfCR) / vec2(${a}.0, ${r}.0);\n        vec4 values = ${s.texture2D}(A, uv);\n\n        float result;\n\n        if(offset == 0) {\n          result = values[0];\n        } else if(offset == 1) {\n          result = values[1];\n        } else if(offset == 2) {\n          result = values[2];\n        } else {\n          result = values[3];\n        }\n\n        ${s.output} = vec4(${i}, 0., 0., 0.);\n      }\n    `}}class dN{constructor(t,e,n=!1){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const s=bk(),[r,a]=e;this.outputShape=t;let i="",o="result";n&&(o="floor(result * 255. + 0.5)");for(let e=0;e<=1;e++)for(let n=0;n<=1;n++){const o=2*e+n;i+=`\n          localCoords = coords;\n          if(localCoords[2] + ${n} < ${t[2]}) {\n            localCoords[2] += ${n};\n            if(localCoords[1] + ${e} < ${t[1]}) {\n              localCoords[1] += ${e};\n\n              flatIndex = getFlatIndex(localCoords);\n              offset = imod(flatIndex, 4);\n\n              flatIndex = idiv(flatIndex, 4, 1.);\n\n              r = flatIndex / ${a};\n              c = imod(flatIndex, ${a});\n              uv = (vec2(c, r) + halfCR) / vec2(${a}.0, ${r}.0);\n              values = ${s.texture2D}(A, uv);\n\n              if(offset == 0) {\n                result[${o}] = values[0];\n              } else if(offset == 1) {\n                result[${o}] = values[1];\n              } else if(offset == 2) {\n                result[${o}] = values[2];\n              } else {\n                result[${o}] = values[3];\n              }\n            }\n          }\n        `}this.userCode=`\n      ${wk(t)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        vec4 result = vec4(0.);\n        int flatIndex, r, c, offset;\n        ivec3 localCoords;\n        vec2 uv;\n        vec4 values;\n\n        ${i}\n\n        ${s.output} = ${o};\n      }\n    `}}class fN{constructor(t,e){this.outputShape=[],this.variableNames=["x"],this.outputShape=t,this.userCode="\n      uniform float value;\n      void main() {\n        // Input can be obtained from uniform value.\n        setOutput(value);\n      }\n    "}getCustomSetupFunc(t){return(e,n)=>{null==this.valueLoc&&(this.valueLoc=e.getUniformLocationNoThrow(n,"value")),e.gl.uniform1f(this.valueLoc,t)}}}class mN{constructor(t,e,n){this.variableNames=["A","indices"];const s=t.slice();s[n]=e,this.outputShape=s,this.rank=s.length;const r=_k(this.rank),a=function(t,e){const n=t.length;if(n>4)throw Error(`Gather for rank ${n} is not yet supported`);if(1===n)return"int(getIndices(resRC))";const s=["resRC.x","resRC.y","resRC.z","resRC.w"],r=[];for(let n=0;n<t.length;n++)n===e?r.push(`int(getIndices(${s[n]}))`):r.push(""+s[n]);return r.join()}(t,n);this.userCode=`\n      void main() {\n        ${r} resRC = getOutputCoords();\n        setOutput(getA(${a}));\n      }\n    `}}class gN{constructor(t,e,n){this.sliceDim=t,this.strides=e,this.variableNames=["x","indices"],this.outputShape=n;const s=_k(e.length),r=_k(n.length),a=this.sliceDim>1?"strides[j]":"strides";this.userCode=`\n        ${s} strides = ${s}(${this.strides});\n         void main() {\n          ${r} coords = getOutputCoords();\n          int flattenIndex = 0;\n          for (int j = 0; j < ${this.sliceDim}; j++) {\n            int index = round(getIndices(coords[0], j));\n            flattenIndex += index * ${a};\n          }\n          setOutput(getX(flattenIndex, coords[1]));\n        }\n      `}}function yN(t){const e=bk();return function(t,e){const n=zv(t,()=>t.createShader(t.VERTEX_SHADER),"Unable to create vertex WebGLShader.");if(Tv(t,()=>t.shaderSource(n,e)),Tv(t,()=>t.compileShader(n)),!1===t.getShaderParameter(n,t.COMPILE_STATUS))throw console.log(t.getShaderInfoLog(n)),new Error("Failed to compile vertex shader.");return n}(t,`${e.version}\n    precision highp float;\n    ${e.attribute} vec3 clipSpacePos;\n    ${e.attribute} vec2 uv;\n    ${e.varyingVs} vec2 resultUV;\n\n    void main() {\n      gl_Position = vec4(clipSpacePos, 1);\n      resultUV = uv;\n    }`)}function bN(t){return function(t,e){const n=zv(t,()=>t.createBuffer(),"Unable to create WebGLBuffer");return Tv(t,()=>t.bindBuffer(t.ARRAY_BUFFER,n)),Tv(t,()=>t.bufferData(t.ARRAY_BUFFER,e,t.STATIC_DRAW)),n}(t,new Float32Array([-1,1,0,0,1,-1,-1,0,0,0,1,1,0,1,1,1,-1,0,1,0]))}function xN(t){return function(t,e){const n=zv(t,()=>t.createBuffer(),"Unable to create WebGLBuffer");return Tv(t,()=>t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,n)),Tv(t,()=>t.bufferData(t.ELEMENT_ARRAY_BUFFER,e,t.STATIC_DRAW)),n}(t,new Uint16Array([0,1,2,2,1,3]))}function wN(t,e,n,s,r,a){!function(t,e){const n=H().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(t<=0||e<=0){throw new Error("Requested texture size "+`[${t}x${e}]`+" is invalid.")}if(t>n||e>n){throw new Error("Requested texture size "+`[${t}x${e}]`+" greater than WebGL maximum on this browser / GPU "+`[${n}x${n}]`+".")}}(e,n);const i=function(t){return zv(t,()=>t.createTexture(),"Unable to create WebGLTexture.")}(t),o=t.TEXTURE_2D;return Tv(t,()=>t.bindTexture(o,i)),Tv(t,()=>t.texParameteri(o,t.TEXTURE_WRAP_S,t.CLAMP_TO_EDGE)),Tv(t,()=>t.texParameteri(o,t.TEXTURE_WRAP_T,t.CLAMP_TO_EDGE)),Tv(t,()=>t.texParameteri(o,t.TEXTURE_MIN_FILTER,t.NEAREST)),Tv(t,()=>t.texParameteri(o,t.TEXTURE_MAG_FILTER,t.NEAREST)),Tv(t,()=>t.texImage2D(o,0,s,e,n,0,r,a,null)),Tv(t,()=>t.bindTexture(t.TEXTURE_2D,null)),i}function vN(t){return t.internalFormatFloat}function kN(t){return t.internalFormatHalfFloat}function NN(t){return t.downloadTextureFormat}function IN(t){return t.internalFormatPackedFloat}function CN(t){return t.internalFormatPackedHalfFloat}function SN(t,e,n,s,r,a,i,o){const l=t,u=new Float32Array(function(t,e){const[n,s]=Cv(t,e);return n*s*4}(a,i));return l.bindBuffer(l.PIXEL_PACK_BUFFER,e),l.getBufferSubData(l.PIXEL_PACK_BUFFER,0,u),l.bindBuffer(l.PIXEL_PACK_BUFFER,null),u}class TN{constructor(t){this.outputTexture=null,this.program=null,this.disposed=!1,this.vertexAttrsAreBound=!1,this.itemsToPoll=[];const e=H().getNumber("WEBGL_VERSION");null!=t?(this.gl=t,function(t,e){yv[t]=e}(e,t)):this.gl=xv(e);let n="WEBGL_color_buffer_float";if(1===H().getNumber("WEBGL_VERSION")){const t="OES_texture_float",e="OES_texture_half_float";if(this.textureFloatExtension=$v(this.gl,t),qv(this.gl,e))this.textureHalfFloatExtension=$v(this.gl,e);else if(H().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support half float textures, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.");if(this.colorBufferFloatExtension=this.gl.getExtension(n),qv(this.gl,"EXT_color_buffer_half_float"))this.colorBufferHalfFloatExtension=$v(this.gl,"EXT_color_buffer_half_float");else if(H().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support color renderable half floats, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.")}else if(n="EXT_color_buffer_float",qv(this.gl,n))this.colorBufferFloatExtension=this.gl.getExtension(n);else{if(!qv(this.gl,"EXT_color_buffer_half_float"))throw new Error("GL context does not support color renderable floats");this.colorBufferHalfFloatExtension=this.gl.getExtension("EXT_color_buffer_half_float")}this.vertexBuffer=bN(this.gl),this.indexBuffer=xN(this.gl),this.framebuffer=function(t){return zv(t,()=>t.createFramebuffer(),"Unable to create WebGLFramebuffer.")}(this.gl),this.textureConfig=Sv(this.gl,this.textureHalfFloatExtension)}get debug(){return H().getBool("DEBUG")}dispose(){if(this.disposed)return;null!=this.program&&console.warn("Disposing a GPGPUContext that still has a bound WebGLProgram. This is probably a resource leak, delete the program with GPGPUContext.deleteProgram before disposing."),null!=this.outputTexture&&console.warn("Disposing a GPGPUContext that still has a bound output matrix texture.  This is probably a resource leak, delete the output matrix texture with GPGPUContext.deleteMatrixTexture before disposing.");const t=this.gl;Tv(t,()=>t.finish()),Tv(t,()=>t.bindFramebuffer(t.FRAMEBUFFER,null)),Tv(t,()=>t.deleteFramebuffer(this.framebuffer)),Tv(t,()=>t.bindBuffer(t.ARRAY_BUFFER,null)),Tv(t,()=>t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,null)),Tv(t,()=>t.deleteBuffer(this.indexBuffer)),this.disposed=!0}createFloat32MatrixTexture(t,e){return this.throwIfDisposed(),function(t,e,n,s){const[r,a]=Nv(e,n);return wN(t,r,a,vN(s),s.textureFormatFloat,t.FLOAT)}(this.gl,t,e,this.textureConfig)}createFloat16MatrixTexture(t,e){return this.throwIfDisposed(),function(t,e,n,s){const[r,a]=Nv(e,n);return wN(t,r,a,kN(s),s.textureFormatFloat,s.textureTypeHalfFloat)}(this.gl,t,e,this.textureConfig)}createUnsignedBytesMatrixTexture(t,e){return this.throwIfDisposed(),function(t,e,n,s){const[r,a]=Nv(e,n);return wN(t,r,a,NN(s),t.RGBA,t.UNSIGNED_BYTE)}(this.gl,t,e,this.textureConfig)}uploadPixelDataToTexture(t,e){this.throwIfDisposed(),function(t,e,n){Tv(t,()=>t.bindTexture(t.TEXTURE_2D,e)),n.data instanceof Uint8Array?Tv(t,()=>t.texImage2D(t.TEXTURE_2D,0,t.RGBA,n.width,n.height,0,t.RGBA,t.UNSIGNED_BYTE,n.data)):Tv(t,()=>t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,n)),Tv(t,()=>t.bindTexture(t.TEXTURE_2D,null))}(this.gl,t,e)}uploadDenseMatrixToTexture(t,e,n,s){this.throwIfDisposed(),function(t,e,n,s,r,a){let i,o,l;Tv(t,()=>t.bindTexture(t.TEXTURE_2D,e)),r instanceof Uint8Array?(i=new Uint8Array(n*s*4),o=t.UNSIGNED_BYTE,l=t.RGBA):(i=new Float32Array(n*s*4),o=t.FLOAT,l=a.internalFormatPackedFloat),i.set(r),Tv(t,()=>t.texImage2D(t.TEXTURE_2D,0,l,n,s,0,t.RGBA,o,i)),Tv(t,()=>t.bindTexture(t.TEXTURE_2D,null))}(this.gl,t,e,n,s,this.textureConfig)}createFloat16PackedMatrixTexture(t,e){return this.throwIfDisposed(),function(t,e,n,s){const[r,a]=Cv(e,n);return wN(t,r,a,CN(s),t.RGBA,s.textureTypeHalfFloat)}(this.gl,t,e,this.textureConfig)}createPackedMatrixTexture(t,e){return this.throwIfDisposed(),function(t,e,n,s){const[r,a]=Cv(e,n);return wN(t,r,a,IN(s),t.RGBA,t.FLOAT)}(this.gl,t,e,this.textureConfig)}deleteMatrixTexture(t){this.throwIfDisposed(),this.outputTexture===t&&(Mv(this.gl,this.framebuffer),this.outputTexture=null),Tv(this.gl,()=>this.gl.deleteTexture(t))}downloadByteEncodedFloatMatrixFromOutputTexture(t,e,n){return this.downloadMatrixDriver(t,()=>function(t,e,n,s){const[r,a]=Nv(e,n),i=new Uint8Array(e*n*4);return Tv(t,()=>t.readPixels(0,0,r,a,s.downloadTextureFormat,t.UNSIGNED_BYTE,i)),new Float32Array(i.buffer)}(this.gl,e,n,this.textureConfig))}downloadPackedMatrixFromBuffer(t,e,n,s,r,a){return SN(this.gl,t,0,0,0,r,a,this.textureConfig)}downloadFloat32MatrixFromBuffer(t,e){return function(t,e,n){const s=t,r=new Float32Array(n);return s.bindBuffer(s.PIXEL_PACK_BUFFER,e),s.getBufferSubData(s.PIXEL_PACK_BUFFER,0,r),s.bindBuffer(s.PIXEL_PACK_BUFFER,null),r}(this.gl,t,e)}createBufferFromTexture(t,e,n){this.bindTextureToFrameBuffer(t);const s=function(t,e,n,s){const r=t.createBuffer();Tv(t,()=>t.bindBuffer(t.PIXEL_PACK_BUFFER,r));const a=16*e*n;return Tv(t,()=>t.bufferData(t.PIXEL_PACK_BUFFER,a,t.STREAM_READ)),Tv(t,()=>t.readPixels(0,0,n,e,t.RGBA,t.FLOAT,0)),Tv(t,()=>t.bindBuffer(t.PIXEL_PACK_BUFFER,null)),r}(this.gl,e,n,this.textureConfig);return this.unbindTextureToFrameBuffer(),s}createAndWaitForFence(){const t=this.createFence(this.gl);return this.pollFence(t)}createFence(t){let e,n;if(H().getBool("WEBGL_FENCE_API_ENABLED")){const s=t,r=s.fenceSync(s.SYNC_GPU_COMMANDS_COMPLETE,0);t.flush(),n=()=>{const t=s.clientWaitSync(r,0,0);return t===s.ALREADY_SIGNALED||t===s.CONDITION_SATISFIED},e=r}else H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0?(e=this.beginQuery(),this.endQuery(),n=()=>this.isQueryAvailable(e,H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))):n=()=>!0;return{query:e,isFencePassed:n}}downloadMatrixFromPackedTexture(t,e,n){return this.downloadMatrixDriver(t,()=>function(t,e,n){const s=new Float32Array(e*n*4);return Tv(t,()=>t.readPixels(0,0,n,e,t.RGBA,t.FLOAT,s)),s}(this.gl,e,n))}createProgram(t){this.throwIfDisposed();const e=this.gl,n=Av(e,t),s=yN(e),r=function(t){return zv(t,()=>t.createProgram(),"Unable to create WebGLProgram.")}(e);return Tv(e,()=>e.attachShader(r,s)),Tv(e,()=>e.attachShader(r,n)),function(t,e){if(Tv(t,()=>t.linkProgram(e)),!1===t.getProgramParameter(e,t.LINK_STATUS))throw console.log(t.getProgramInfoLog(e)),new Error("Failed to link vertex and fragment shaders.")}(e,r),this.debug&&Dv(e,r),this.vertexAttrsAreBound||(this.setProgram(r),this.vertexAttrsAreBound=function(t,e,n){return Tv(t,()=>t.bindBuffer(t.ARRAY_BUFFER,n)),_v(t,e,"clipSpacePos",n,3,20,0)&&_v(t,e,"uv",n,2,20,12)}(e,this.program,this.vertexBuffer)),r}deleteProgram(t){this.throwIfDisposed(),t===this.program&&(this.program=null),null!=t&&Tv(this.gl,()=>this.gl.deleteProgram(t))}setProgram(t){this.throwIfDisposed(),this.program=t,null!=this.program&&this.debug&&Dv(this.gl,this.program),Tv(this.gl,()=>this.gl.useProgram(t))}getUniformLocation(t,e,n=!0){return this.throwIfDisposed(),n?function(t,e,n){return zv(t,()=>t.getUniformLocation(e,n),'uniform "'+n+'" not present in program.')}(this.gl,t,e):function(t,e,n){return t.getUniformLocation(e,n)}(this.gl,t,e)}getAttributeLocation(t,e){return this.throwIfDisposed(),Tv(this.gl,()=>this.gl.getAttribLocation(t,e))}getUniformLocationNoThrow(t,e){return this.throwIfDisposed(),this.gl.getUniformLocation(t,e)}setInputMatrixTexture(t,e,n){this.throwIfDisposed(),this.throwIfNoProgram(),Fv(this.gl,t,e,n)}setOutputMatrixTexture(t,e,n){this.setOutputMatrixTextureDriver(t,n,e)}setOutputPackedMatrixTexture(t,e,n){this.throwIfDisposed();const[s,r]=Cv(e,n);this.setOutputMatrixTextureDriver(t,s,r)}setOutputMatrixWriteRegion(t,e,n,s){this.setOutputMatrixWriteRegionDriver(n,t,s,e)}setOutputPackedMatrixWriteRegion(t,e,n,s){throw new Error("setOutputPackedMatrixWriteRegion not implemented.")}debugValidate(){null!=this.program&&Dv(this.gl,this.program),Lv(this.gl)}executeProgram(){this.throwIfDisposed(),this.throwIfNoProgram();const t=this.gl;this.debug&&this.debugValidate(),Tv(t,()=>t.drawElements(t.TRIANGLES,6,t.UNSIGNED_SHORT,0))}blockUntilAllProgramsCompleted(){this.throwIfDisposed(),Tv(this.gl,()=>this.gl.finish())}getQueryTimerExtension(){return null==this.disjointQueryTimerExtension&&(this.disjointQueryTimerExtension=$v(this.gl,2===H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")?"EXT_disjoint_timer_query_webgl2":"EXT_disjoint_timer_query")),this.disjointQueryTimerExtension}getQueryTimerExtensionWebGL2(){return this.getQueryTimerExtension()}getQueryTimerExtensionWebGL1(){return this.getQueryTimerExtension()}beginQuery(){if(2===H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const t=this.gl,e=this.getQueryTimerExtensionWebGL2(),n=t.createQuery();return t.beginQuery(e.TIME_ELAPSED_EXT,n),n}const t=this.getQueryTimerExtensionWebGL1(),e=t.createQueryEXT();return t.beginQueryEXT(t.TIME_ELAPSED_EXT,e),e}endQuery(){if(2===H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const t=this.gl,e=this.getQueryTimerExtensionWebGL2();return void t.endQuery(e.TIME_ELAPSED_EXT)}const t=this.getQueryTimerExtensionWebGL1();t.endQueryEXT(t.TIME_ELAPSED_EXT)}async waitForQueryAndGetTime(t){return await y(()=>this.disposed||this.isQueryAvailable(t,H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))),this.getQueryTime(t,H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))}getQueryTime(t,e){if(0===e)return null;if(2===e){const e=this.gl;return e.getQueryParameter(t,e.QUERY_RESULT)/1e6}{const e=this.getQueryTimerExtensionWebGL1();return e.getQueryObjectEXT(t,e.QUERY_RESULT_EXT)/1e6}}isQueryAvailable(t,e){if(0===e)return!0;if(2===e){const e=this.gl,n=this.getQueryTimerExtensionWebGL2(),s=e.getQueryParameter(t,e.QUERY_RESULT_AVAILABLE);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(n.GPU_DISJOINT_EXT)),s&&!this.disjoint}{const e=this.getQueryTimerExtensionWebGL1(),n=e.getQueryObjectEXT(t,e.QUERY_RESULT_AVAILABLE_EXT);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(e.GPU_DISJOINT_EXT)),n&&!this.disjoint}}pollFence(t){return new Promise(e=>{this.addItemToPoll(()=>t.isFencePassed(),()=>e())})}pollItems(){const t=function(t){let e=0;for(;e<t.length;++e){if(!t[e]())break}return e-1}(this.itemsToPoll.map(t=>t.isDoneFn));for(let e=0;e<=t;++e){const{resolveFn:t}=this.itemsToPoll[e];t()}this.itemsToPoll=this.itemsToPoll.slice(t+1)}addItemToPoll(t,e){this.itemsToPoll.push({isDoneFn:t,resolveFn:e}),this.itemsToPoll.length>1||y(()=>(this.pollItems(),0===this.itemsToPoll.length))}bindTextureToFrameBuffer(t){this.throwIfDisposed(),Ov(this.gl,t,this.framebuffer),this.debug&&Lv(this.gl)}unbindTextureToFrameBuffer(){null!=this.outputTexture?(Ov(this.gl,this.outputTexture,this.framebuffer),this.debug&&Lv(this.gl)):Mv(this.gl,this.framebuffer)}downloadMatrixDriver(t,e){this.bindTextureToFrameBuffer(t);const n=e();return this.unbindTextureToFrameBuffer(),n}setOutputMatrixTextureDriver(t,e,n){this.throwIfDisposed();const s=this.gl;Ov(s,t,this.framebuffer),this.debug&&Lv(s),this.outputTexture=t,Tv(s,()=>s.viewport(0,0,e,n)),Tv(s,()=>s.scissor(0,0,e,n))}setOutputMatrixWriteRegionDriver(t,e,n,s){this.throwIfDisposed(),Tv(this.gl,()=>this.gl.scissor(t,e,n,s))}throwIfDisposed(){if(this.disposed)throw new Error("Attempted to use disposed GPGPUContext.")}throwIfNoProgram(){if(null==this.program)throw new Error("No GPU program is currently set.")}}function EN(t,e){if(t.length!==e.length)throw Error(`Binary was compiled with ${t.length} inputs, but was executed with ${e.length} inputs`);t.forEach((t,n)=>{const s=t.logicalShape,r=e[n],a=r.shape;if(!d(s,a))throw Error(`Binary was compiled with different shapes than the current args. Shapes ${s} and ${a} must match`);if(t.isUniform&&r.isUniform)return;const i=t.texShape,o=r.isUniform?null:r.texData.texShape;if(!d(i,o))throw Error(`Binary was compiled with different texture shapes than the current args. Shape ${i} and ${o} must match`)})}class $N{constructor(t,e,n){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t;const{filterWidth:s,inChannels:r,strideWidth:a,strideHeight:i,padInfo:o,outWidth:l,dilationWidth:u,dilationHeight:c,dataFormat:h}=n,{left:p,top:d}=o,f=r*s,m=bk(),g="channelsLast"===h,y=g?0:1,b=g?1:2;let x="";for(let n=0;n<=1;n++)for(let s=0;s<=1;s++)x+=`\n          blockIndex = rc.y + ${s};\n          pos = rc.x + ${n};\n\n          if(blockIndex < ${t[1]} && pos < ${t[0]}) {\n            offsetY = int(blockIndex / (${l})) * ${i} - ${d};\n            d0 = offsetY + ${c} * (pos / ${f});\n\n            if(d0 < ${e[y]} && d0 >= 0) {\n\n              offsetX = int(mod(float(blockIndex), ${l}.) * ${a}. - ${p}.);\n              d1 = offsetX + ${u} * (int(mod(float(pos), ${f}.) / ${r}.));\n\n              if(d1 < ${e[b]} && d1 >= 0) {\n\n                ch = int(mod(float(pos), ${r}.));\n\n                if (${g}) {\n                  innerDims = vec2(d1, ch);\n                  result[${2*n+s}] = getChannel(\n                    getA(d0, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                } else {\n                  innerDims = vec2(d0, d1);\n                  result[${2*n+s}] = getChannel(\n                    getA(ch, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                }\n              }\n            }\n          }\n        `;this.userCode=`\n      void main() {\n        ivec2 rc = getOutputCoords();\n\n        vec4 result = vec4(0);\n\n        int blockIndex, pos, offsetY, d0, offsetX, d1, ch;\n        vec2 innerDims;\n\n        ${x}\n\n        ${m.output} = result;\n      }\n    `}}class AN{constructor(t,e,n,s,r){this.variableNames=["x"],this.outputShape=[];const a=e,i=t[3]-1;let o;this.outputShape=t;const l=`float(${n}) + float(${s}) * sum`;o=.5===r?`inversesqrt(${l})`:1===r?`1.0/(${l})`:`exp(log(${l}) * float(-${r}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n        int d = coords[3];\n        float x = getX(b, r, c, d);\n        float sum = 0.0;\n        for (int j = -${a}; j <= ${a}; j++) {\n          int idx = d + j;\n          if (idx >= 0 && idx <=  ${i}) {\n            float z = getX(b, r, c, idx);\n            sum += z * z;\n          }\n        }\n        float val = x * ${o};\n        setOutput(val);\n      }\n    `}}class RN{constructor(t,e,n,s,r){this.variableNames=["inputImage","outputImage","dy"],this.outputShape=[],this.outputShape=t,this.depth=t[3],this.depthRadius=e,this.bias=n,this.alpha=s,this.beta=r,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n\n        float result = 0.0;\n        for (int d = 0; d < ${this.depth}; ++d) {\n          int depthBegin = int(max(0.0, float(d - ${e})));\n          int depthEnd = int(min(float(${this.depth}),\n              float(d + ${e} + 1)));\n\n          const int MIN_DEPTH_BEGIN = 0;\n          const int MAX_DEPTH_END = ${this.depth};\n\n          float norm = 0.0;\n          for (int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k) {\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd) {\n              norm += getInputImage(b, r, c, k) * getInputImage(b, r, c, k);\n            }\n            else {\n              break;\n            }\n          }\n\n          norm = float(${s}) * norm + float(${n});\n\n          for(int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k){\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd){\n              float dyi = -2.0 * float(${s})\n                * float(${r})\n                * getInputImage(b ,r ,c, k) * getOutputImage(b, r, c, d)\n                / norm;\n              if (k == d) {\n                dyi += pow(norm, -1.0 * ${r});\n              }\n              if (k == coords[3]) {\n                dyi *= getDy(b, r, c, d);\n                result += dyi;\n              }\n            }\n            else {\n              break;\n            }\n          }\n      }\n      setOutput(result);\n      }\n    `}}class DN{constructor(t,e,n,s,r){this.variableNames=["x"],this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0;const a=e,i=t[3]-1;let o;this.outputShape=t;const l=`float(${n}) + float(${s}) * sum`;o=.5===r?`inversesqrt(${l})`:1===r?`1.0/(${l})`:`exp(log(${l}) * float(-${r}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords.x;\n        int r = coords.y;\n        int c = coords.z;\n        int d = coords.w;\n\n        bool hasNextCol = d < ${this.outputShape[3]};\n        bool hasNextRow = c < ${this.outputShape[2]};\n\n        vec4 sum = vec4(0.);\n        vec4 xFragAtOutputCoords = getX(b, r, c, d);\n\n        vec4 xAtOutputCoords = vec4(\n          getChannel(xFragAtOutputCoords, vec2(c, d)),\n          hasNextCol ?\n            getChannel(xFragAtOutputCoords, vec2(c, d + 1)) : 0.0,\n          hasNextRow ?\n            getChannel(xFragAtOutputCoords , vec2(c + 1, d)) : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getChannel(xFragAtOutputCoords, vec2(c + 1, d + 1)) : 0.0\n        );\n\n        int firstChannel = d - ${a};\n        vec2 cache = vec2(0.);\n        if(firstChannel >= 0){\n          vec4 firstChannelFrag = getX(b, r, c, firstChannel);\n          cache.x = getChannel(firstChannelFrag, vec2(c, firstChannel));\n            if(hasNextRow){\n              cache.y = getChannel(firstChannelFrag, vec2(c + 1, firstChannel));\n            }\n        }\n\n        ivec2 depth = ivec2(d, d + 1);\n        for (int j = - ${a}; j <= ${a}; j++) {\n          ivec2 idx = depth + j;\n          bvec2 aboveLowerBound = greaterThanEqual(idx, ivec2(0));\n          bvec2 belowUpperBound = lessThanEqual(idx, ivec2(${i}));\n\n          bool depthInRange = aboveLowerBound.x && belowUpperBound.x;\n          bool depthPlusOneInRange = aboveLowerBound.y && belowUpperBound.y;\n\n          if(depthInRange || depthPlusOneInRange){\n            vec4 z = vec4(0.);\n            vec4 xFragAtCurrentDepth;\n            z.xz = cache.xy;\n            if(depthPlusOneInRange && hasNextCol){\n              xFragAtCurrentDepth = idx.y != d ?\n                getX(b, r, c, idx.y) : xFragAtOutputCoords;\n              z.y = getChannel(xFragAtCurrentDepth, vec2(c, idx.y));\n              if(hasNextRow){\n                z.w = getChannel(xFragAtCurrentDepth, vec2(c + 1, idx.y));\n              }\n            }\n            cache.xy = z.yw;\n            sum += z * z;\n          }\n        }\n        vec4 result = xAtOutputCoords * ${o};\n        setOutput(result);\n      }\n    `}}class _N{constructor(t){this.variableNames=["dy","maxPos"],this.outputShape=t.inShape;const e=t.strideHeight,n=t.strideWidth,s=t.dilationHeight,r=t.effectiveFilterHeight,a=t.effectiveFilterWidth,i=r-1-t.padInfo.top,o=a-1-t.padInfo.left,l=r*a-1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${o});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${r};\n          wR += ${s}) {\n          float dyR = float(dyRCorner + wR) / ${e}.0;\n\n          if (dyR < 0.0 || dyR >= ${t.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${a}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${n}.0;\n\n            if (dyC < 0.0 || dyC >= ${t.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n            int maxPosValue = ${l} - int(getMaxPos(b, idyR, idyC, d));\n\n            // Get the current value, check it against the value from the\n            // position matrix.\n            int curPosValue = wR * ${a} + wC;\n            float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n            dotProd += dyValue * mask;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class FN{constructor(t){this.variableNames=["dy","maxPos"],this.outputShape=t.inShape;const e=t.strideDepth,n=t.strideHeight,s=t.strideWidth,r=t.dilationDepth,a=t.dilationHeight,i=t.dilationWidth,o=t.effectiveFilterDepth,l=t.effectiveFilterHeight,u=t.effectiveFilterWidth,c=o-1-t.padInfo.front,h=l-1-t.padInfo.top,p=u-1-t.padInfo.left,d=o*l*u-1;this.userCode=`\n      const ivec3 pads = ivec3(${c}, ${h}, ${p});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, ch) with pos mask(:, :, :, d) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${o};\n           wD += ${r}) {\n          float dyD = float(dyDCorner + wD) / ${e}.0;\n\n          if (dyD < 0.0 || dyD >= ${t.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${l};\n              wR += ${a}) {\n            float dyR = float(dyRCorner + wR) / ${n}.0;\n\n            if (dyR < 0.0 || dyR >= ${t.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${u};\n                wC += ${i}) {\n              float dyC = float(dyCCorner + wC) / ${s}.0;\n\n              if (dyC < 0.0 || dyC >= ${t.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n              int maxPosValue = ${d} -\n                  int(getMaxPos(batch, idyD, idyR, idyC, ch));\n\n              // Get the current value, check it against the value from the\n              // position matrix.\n              int curPosValue =\n                  wD * ${l} * ${u} +\n                  wR * ${u} + wC;\n              float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n              dotProd += dyValue * mask;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class ON{constructor(t,e,n,s=!1,r=!1,a=!1,i=null,o=!1){this.variableNames=["matrixA","matrixB"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=n;const l=s?t[1]:t[2],u=Math.ceil(l/2),c=s?"i * 2, rc.y":"rc.y, i * 2",h=r?"rc.z, i * 2":"i * 2, rc.z",p=s?["a.xxyy","a.zzww"]:["a.xxzz","a.yyww"],d=r?["b.xzxz","b.ywyw"]:["b.xyxy","b.zwzw"];let f="",m="";i&&(f=o?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${i}\n        }`:`vec4 activation(vec4 x) {\n          ${i}\n        }`,m="result = activation(result);");const g=a?"result += getBiasAtOutCoords();":"";a&&this.variableNames.push("bias"),o&&this.variableNames.push("preluActivationWeights");let y="rc.x",b="rc.x";t[0]<e[0]?y=`int(min(float(rc.x), ${t[0]-1}.))`:e[0]<t[0]&&(b=`int(min(float(rc.x), ${e[0]-1}.))`),this.userCode=`\n      ${f}\n\n      const float sharedDimension = ${u}.0;\n\n      vec4 dot2x2ARowBCol(ivec3 rc) {\n        vec4 result = vec4(0);\n        for (int i = 0; i < ${u}; i++) {\n          int batchA = ${y};\n          int batchB = ${b};\n          vec4 a = getMatrixA(batchA, ${c});\n          vec4 b = getMatrixB(batchB, ${h});\n\n          // These swizzled products need to be separately added.\n          // See: https://github.com/tensorflow/tfjs/issues/1735\n          result += (${p[0]} * ${d[0]});\n          result += (${p[1]} * ${d[1]});\n        }\n        return result;\n      }\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n        vec4 result = dot2x2ARowBCol(rc);\n\n        ${g}\n\n        ${m}\n\n        setOutput(result);\n      }\n    `}}class MN{constructor(t,e,n){this.variableNames=["probs"],this.outputShape=[t,n],this.userCode=`\n      uniform float seed;\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n\n        float r = random(seed);\n        float cdf = 0.0;\n\n        for (int i = 0; i < ${e-1}; i++) {\n          cdf += getProbs(batch, i);\n\n          if (r < cdf) {\n            setOutput(float(i));\n            return;\n          }\n        }\n\n        // If no other event happened, last event happened.\n        setOutput(float(${e-1}));\n      }\n    `}getCustomSetupFunc(t){return(e,n)=>{null==this.seedLoc&&(this.seedLoc=e.getUniformLocation(n,"seed")),e.gl.uniform1f(this.seedLoc,t)}}}class LN{constructor(t,e,n,s){this.variableNames=["indices"],this.outputShape=[t,e],this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int index = round(getIndices(coords.x));\n        setOutput(mix(float(${s}), float(${n}),\n                      float(index == coords.y)));\n      }\n    `}}class zN{constructor(t){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outputShape=t;const e=t.length;if(0===e)this.userCode="\n        void main() {\n          setOutput(vec4(getA(), 0., 0., 0.));\n        }\n      ";else{const n=yk("rc",e),s=_k(e),r=function(t,e,n){if(1===t)return"rc > "+e[0];let s="";for(let r=t-2;r<t;r++)s+=`${n[r]} >= ${e[r]}`,r<t-1&&(s+="||");return s}(e,t,n),a=function(t,e,n,s){if(1===t)return"";const r=s.slice(-2);return`\n    int r = ${r[0]};\n    int c = ${r[1]};\n    int rp1 = r + 1;\n    int cp1 = c + 1;\n\n    bool cEdge = cp1 >= ${e};\n    bool rEdge = rp1 >= ${n};\n  `}(e,t[t.length-1],t[t.length-2],n),i=function(t,e){const n=t.length,s=function(t,e){const n=[];for(let s=0;s<=1;s++)for(let r=0;r<=1;r++){let a=`${0===s?"r":"rp1"}, ${0===r?"c":"cp1"}`;for(let n=2;n<t;n++)a=e[e.length-1-n]+","+a;n.push(a)}return n}(n,e);if(1===n)return`getA(rc),\n            rc + 1 >= ${t[0]} ? 0. : getA(rc + 1),\n            0, 0`;return`getA(${s[0]}),\n          cEdge ? 0. : getA(${s[1]}),\n          rEdge ? 0. : getA(${s[2]}),\n          rEdge || cEdge ? 0. : getA(${s[3]})`}(t,n);this.userCode=`\n        void main() {\n          ${s} rc = getOutputCoords();\n\n          if(${r}) {\n            setOutput(vec4(0));\n          } else {\n            ${a}\n\n            setOutput(vec4(${i}));\n          }\n        }\n      `}}}class BN{constructor(t,e,n){this.variableNames=["x"],this.outputShape=e.map((e,n)=>e[0]+t[n]+e[1]);const s=t.length,r=_k(s),a=e.map(t=>t[0]).join(","),i=e.map((e,n)=>e[0]+t[n]).join(","),o=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,s);this.userCode=1!==s?`\n      ${r} start = ${r}(${a});\n      ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outC = getOutputCoords();\n        if (any(lessThan(outC, start)) || any(greaterThanEqual(outC, end))) {\n          setOutput(float(${n}));\n        } else {\n          ${r} coords = outC - start;\n          setOutput(getX(${o}));\n        }\n      }\n    `:`\n        int start = ${a};\n        int end = ${i};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start || outC >= end) {\n            setOutput(float(${n}));\n          } else {\n            setOutput(getX(outC - start));\n          }\n        }\n      `}}class PN{constructor(t,e,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e.map((e,n)=>e[0]+t[n]+e[1]);const s=t.length,r=_k(s),a=e.map(t=>t[0]).join(","),i=e.map((e,n)=>e[0]+t[n]).join(","),o=yk("rc",s),l=yk("source",s),u=`${o[s-1]} < ${this.outputShape[s-1]}`,c=1===s?"source":`vec2(${l.slice(-2).join()})`,h=[r+" rc = outputLoc;",`${o[s-1]} += 1;\n       if(${u}) {\n      `,1===s?"":`}\n       rc = outputLoc;\n       ${o[s-2]} += 1;\n       if(${o[s-2]} < ${this.outputShape[s-2]}) {`,1===s?"":`  ${o[s-1]} += 1;\n         if(${u}) {`],p=1===s?"rc < start || rc >= end":"any(lessThan(rc, start)) || any(greaterThanEqual(rc, end))";let d="";for(let t=0,e=1===s?2:4;t<e;t++)d+=`\n        ${h[t]}\n        if (${p}) {\n          result[${t}] = float(${n});\n        } else {\n          ${r} source = rc - start;\n          result[${t}] = getChannel(getX(${l.join()}), ${c});\n        }\n      `;d+=1===s?"} ":"}}",this.userCode=`\n      const ${r} start = ${r}(${a});\n      const ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${d}\n        setOutput(result);\n      }\n    `}}class WN{constructor(t,e,n,s=!1,r=!1){if(this.variableNames=["x"],"avg"===e&&n)throw new Error("Cannot compute positions for average pool.");const a=t.filterWidth,i=t.strideHeight,o=t.strideWidth,l=t.dilationHeight,u=t.dilationWidth,c=t.effectiveFilterHeight,h=t.effectiveFilterWidth,p=t.padInfo.top,d=t.padInfo.left;this.outputShape=t.outShape;const f="avg"===e,m=`((batch  * ${t.inHeight} + xR) * ${t.inWidth} + xC) * ${t.inChannels} + d`,g=`(xR * ${t.inWidth} + xC) * ${t.inChannels} + d`;let y="0.0";if(f||(y="-1.0 / 1e-20"),n){const e=">=";return void(this.userCode=`\n        const ivec2 strides = ivec2(${i}, ${o});\n        const ivec2 pads = ivec2(${p}, ${d});\n\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int batch = coords[0];\n          int d = coords[3];\n\n          ivec2 xRCCorner = coords.yz * strides - pads;\n          int xRCorner = xRCCorner.x;\n          int xCCorner = xRCCorner.y;\n\n          // max/min x(?, ?, d) to get y(yR, yC, d).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n          float avgValue = 0.0;\n\n          for (int wR = 0; wR < ${c};\n              wR += ${l}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${t.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${h};\n                wC += ${u}) {\n              int xC = xCCorner + wC;\n\n              if (xC < 0 || xC >= ${t.inWidth}) {\n                continue;\n              }\n\n              float value = getX(batch, xR, xC, d);\n\n              // If a min / max value has already been found, use it. If not,\n              // use the current value.\n              float currMinMaxValue = mix(\n                  value, minMaxValue, minMaxValueFound);\n              if (value ${e} currMinMaxValue) {\n                minMaxValue = value;\n                minMaxValueFound = 1.0;\n                minMaxPosition = ${s?r?m:g:`wR * ${h} + wC`};\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let b=`${e}(${e}(${e}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===e&&(b="avgValue / count");const x=4*Math.floor(a/4),w=a%4,v=`\n      if (${f}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec2 strides = ivec2(${i}, ${o});\n      const ivec2 pads = ivec2(${p}, ${d});\n      const float initializationValue = ${y};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xR, int xC, int d) {\n        if (xC < 0 || xC >= ${t.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xR, xC, d);\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d = coords[3];\n\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // max/min x(?, ?, d) to get y(yR, yC, d).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${y});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wR = 0; wR < ${c};\n            wR += ${l}) {\n          int xR = xRCorner + wR;\n\n          if (xR < 0 || xR >= ${t.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${x}; wC += 4) {\n            int xC = xCCorner + wC * ${u};\n\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              getValue(batch, xR, xC + 2 * ${u}, d),\n              getValue(batch, xR, xC + 3 * ${u}, d)\n            );\n\n            ${v}\n          }\n\n          int xC = xCCorner + ${x};\n          if (${1===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              initializationValue,\n              initializationValue,\n              initializationValue\n            );\n\n            ${v}\n          } else if (${2===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              initializationValue,\n              initializationValue\n            );\n\n            ${v}\n          } else if (${3===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              getValue(batch, xR, xC + 2 * ${u}, d),\n              initializationValue\n            );\n\n            ${v}\n          }\n        }\n        setOutput(${b});\n      }\n    `}}class VN{constructor(t,e,n,s=!1,r=!1){if(this.variableNames=["x"],"avg"===e&&n)throw new Error("Cannot compute positions for average pool.");const a=t.filterWidth,i=t.strideDepth,o=t.strideHeight,l=t.strideWidth,u=t.dilationDepth,c=t.dilationHeight,h=t.dilationWidth,p=t.effectiveFilterDepth,d=t.effectiveFilterHeight,f=t.effectiveFilterWidth,m=t.padInfo.front,g=t.padInfo.top,y=t.padInfo.left;this.outputShape=t.outShape;const b="avg"===e;let x="0.0";if(b||(x="-1.0 / 1e-20"),n){const e=">=";return void(this.userCode=`\n        const ivec3 strides =\n            ivec3(${i}, ${o}, ${l});\n        const ivec3 pads = ivec3(${m}, ${g}, ${y});\n\n        void main() {\n          ivec5 coords = getOutputCoords();\n          int batch = coords.x;\n          int ch = coords.u;\n\n          ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n          int xDCorner = xCorner.x;\n          int xRCorner = xCorner.y;\n          int xCCorner = xCorner.z;\n\n          // max/min x(?, ?, ?, ch) to get y(yD, yR, yC, ch).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n\n          for (int wD = 0; wD < ${p};\n              wD += ${u}) {\n            int xD = xDCorner + wD;\n\n            if (xD < 0 || xD >= ${t.inDepth}) {\n              continue;\n            }\n\n            for (int wR = 0; wR < ${d};\n                wR += ${c}) {\n              int xR = xRCorner + wR;\n\n              if (xR < 0 || xR >= ${t.inHeight}) {\n                continue;\n              }\n\n              for (int wC = 0; wC < ${f};\n                  wC += ${h}) {\n                int xC = xCCorner + wC;\n\n                if (xC < 0 || xC >= ${t.inWidth}) {\n                  continue;\n                }\n\n                float value = getX(batch, xD, xR, xC, ch);\n\n                // If a min / max value has already been found, use it. If not,\n                // use the current value.\n                float currMinMaxValue = mix(\n                    value, minMaxValue, minMaxValueFound);\n                if (value ${e} currMinMaxValue) {\n                  minMaxValue = value;\n                  minMaxValueFound = 1.0;\n                  minMaxPosition = ${s?r?`(((batch * ${t.inDepth} + xD) * ${t.inHeight} + xR) * ${t.inWidth} + xC) * ${t.inChannels} + ch`:`((xD * ${t.inHeight} + xR) * ${t.inWidth} + xC) * ${t.inChannels} + ch`:`wD * ${d} * ${f} +\n                      wR * ${f} + wC`};\n                }\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let w=`${e}(${e}(${e}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===e&&(w="avgValue / count");const v=4*Math.floor(a/4),k=a%4,N=`\n      if (${b}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec3 strides =\n        ivec3(${i}, ${o}, ${l});\n      const ivec3 pads = ivec3(${m}, ${g}, ${y});\n      const float initializationValue = ${x};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xD, int xR, int xC, int ch) {\n        if (xC < 0 || xC >= ${t.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xD, xR, xC, ch);\n      }\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xDCorner = xCorner.x;\n        int xRCorner = xCorner.y;\n        int xCCorner = xCorner.z;\n\n        // max/min x(?, ?, ?, d) to get y(yD, yR, yC, ch).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${x});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wD = 0; wD < ${p};\n            wD += ${u}) {\n          int xD = xDCorner + wD;\n\n          if (xD < 0 || xD >= ${t.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${d};\n            wR += ${c}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${t.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${v}; wC += 4) {\n              int xC = xCCorner + wC * ${h};\n\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${h}, ch),\n                getValue(batch, xD, xR, xC + 3 * ${h}, ch)\n              );\n\n              ${N}\n            }\n\n            int xC = xCCorner + ${v};\n            if (${1===k}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                initializationValue,\n                initializationValue,\n                initializationValue\n              );\n\n              ${N}\n            } else if (${2===k}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                initializationValue,\n                initializationValue\n              );\n\n              ${N}\n            } else if (${3===k}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${h}, ch),\n                initializationValue\n              );\n\n              ${N}\n            }\n          }\n          setOutput(${w});\n        }\n      }\n    `}}class UN{constructor(t,e){this.variableNames=["x"];const{windowSize:n,batchSize:s,inSize:r,outSize:a}=t;this.outputShape=[s,a];let i="0.0",o="";"prod"===e?i="1.0":"min"===e?(i="1.0 / 1e-20",o="min"):"max"===e&&(i="-1.0 / 1e-20",o="max");let l=`${e}(${e}(${e}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"sum"===e?l="sumValue":"prod"===e?l="prodValue":"all"===e?l="allValue":"any"===e&&(l="anyValue");const u=4*Math.floor(n/4),c=n%4;let h=`\n      if (${"sum"===e}) {\n        sumValue += dot(values, ones);\n      } else if (${"prod"===e}) {\n        vec2 tmp = vec2(values[0], values[1]) * vec2(values[2], values[3]);\n        prodValue *= tmp[0] * tmp[1];\n      } else {\n        minMaxValue = ${o}(values, minMaxValue);\n      }\n    `,p="vec4";"all"===e?(i="1.0",h="\n        bool reducedAllValue = all(values);\n        float floatedReducedAllValue = float(reducedAllValue);\n        allValue = float(allValue >= 1.0 && floatedReducedAllValue >= 1.0);\n      ",p="bvec4"):"any"===e&&(i="0.0",h="\n        bool reducedAnyValue = any(values);\n        float floatedReducedAnyValue = float(reducedAnyValue);\n        anyValue = float(anyValue >= 1.0 || floatedReducedAnyValue >= 1.0);\n      ",p="bvec4");let d="";r%n>0&&(d=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return initializationValue;\n        }\n      `),this.userCode=`\n      const float initializationValue = ${i};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${d}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        vec4 minMaxValue = vec4(${i});\n        float prodValue = 1.0;\n        float sumValue = 0.0;\n        float allValue = 1.0;\n        float anyValue = 0.0;\n\n        for (int i = 0; i < ${u}; i += 4) {\n          int inIdx = inOffset + i;\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${h}\n        }\n\n        int inIdx = inOffset + ${u};\n        if (${1===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          ${h}\n        } else if (${2===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          ${h}\n        } else if (${3===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          ${h}\n        }\n        setOutput(${l});\n      }\n    `}}class GN{constructor(t,e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t;let n="";for(let t=0;t<4;t++){let e="thisRC = rc;";t%2==1&&(e+="thisRC.z += 1;"),t>1&&(e+="thisRC.y += 1;"),n+=`\n        ${e}\n        ${t>0?"if(thisRC.y < rows && thisRC.z < cols){":""}\n          int flatIndex = getFlatIndex(thisRC);\n\n          ivec3 inputRC = inputCoordsFromReshapedOutCoords(flatIndex);\n          vec2 inputRCInnerDims = vec2(float(inputRC.y),float(inputRC.z));\n\n          result[${t}] =\n            getChannel(getA(inputRC.x, inputRC.y, inputRC.z), inputRCInnerDims);\n        ${t>0?"}":""}\n      `}var s;this.userCode=`\n      ${s=e,`\n    ivec3 inputCoordsFromReshapedOutCoords(int index) {\n      ${xk(["r","c","d"],s)}\n      return ivec3(r, c, d);\n    }\n  `}\n      ${wk(t)}\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n\n        vec4 result = vec4(0.);\n\n        ivec3 thisRC;\n        int rows = ${t[1]};\n        int cols = ${t[2]};\n\n        ${n}\n\n        setOutput(result);\n      }\n    `}}class HN{constructor(t,e,n){this.variableNames=["dy"],this.outputShape=[],this.outputShape=e.shape;const[,s,r]=e.shape,[,a,i]=t.shape,o=[n&&a>1?s-1:s,n&&i>1?r-1:r],l=[n&&a>1?a-1:a,n&&i>1?i-1:i],u=o[0]/l[0],c=o[1]/l[1],h=1/u,p=1/c,d=2*Math.ceil(h)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${u});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${h});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${d});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(startRLerp - float(winHeight / 2));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(startCLerp - float(winWidth / 2));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${a}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${i}) {\n              continue;\n            }\n\n            float dxR = float(dyR) * heightScale;\n            int topDxRIndex = int(floor(dxR));\n            int bottomDxRIndex = int(min(ceil(dxR), ${s-1}.0));\n            float dxRLerp = dxR - float(topDxRIndex);\n            float inverseDxRLerp = 1.0 - dxRLerp;\n\n            float dxC = float(dyC) * widthScale;\n            int leftDxCIndex = int(floor(dxC));\n            int rightDxCIndex = int(min(ceil(dxC), ${r-1}.0));\n            float dxCLerp = dxC - float(leftDxCIndex);\n            float inverseDxCLerp = 1.0 - dxCLerp;\n\n            if (r == topDxRIndex && c == leftDxCIndex) {\n              // topLeft\n              accumulator +=\n                getDy(b, dyR, dyC, d) * inverseDxRLerp * inverseDxCLerp;\n            }\n\n            if (r == topDxRIndex && c == rightDxCIndex) {\n              // topRight\n              accumulator += getDy(b, dyR, dyC, d) * inverseDxRLerp * dxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == leftDxCIndex) {\n              // bottomLeft\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * inverseDxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == rightDxCIndex) {\n              // bottomRight\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * dxCLerp;\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}class jN{constructor(t,e,n,s){this.variableNames=["A"],this.outputShape=[];const[r,a,i,o]=t;this.outputShape=[r,e,n,o];const l=[s&&e>1?a-1:a,s&&n>1?i-1:i],u=[s&&e>1?e-1:e,s&&n>1?n-1:n];this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${l[0]/u[0]},\n          ${l[1]/u[1]});\n      const vec2 inputShapeRC = vec2(${a}.0, ${i}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = vec2(yRC) * effectiveInputOverOutputRatioRC;\n\n        // Compute the four integer indices.\n        ivec2 sourceFloorRC = ivec2(sourceFracIndexRC);\n        ivec2 sourceCeilRC = ivec2(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        float topLeft = getA(b, sourceFloorRC.x, sourceFloorRC.y, d);\n        float bottomLeft = getA(b, sourceCeilRC.x, sourceFloorRC.y, d);\n        float topRight = getA(b, sourceFloorRC.x, sourceCeilRC.y, d);\n        float bottomRight = getA(b, sourceCeilRC.x, sourceCeilRC.y, d);\n\n        vec2 fracRC = sourceFracIndexRC - vec2(sourceFloorRC);\n\n        float top = topLeft + (topRight - topLeft) * fracRC.y;\n        float bottom = bottomLeft + (bottomRight - bottomLeft) * fracRC.y;\n        float newValue = top + (bottom - top) * fracRC.x;\n\n        setOutput(newValue);\n      }\n    `}}class qN{constructor(t,e,n,s){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[];const[r,a,i,o]=t;this.outputShape=[r,e,n,o];const l=[s&&e>1?a-1:a,s&&n>1?i-1:i],u=[s&&e>1?e-1:e,s&&n>1?n-1:n];this.userCode=`\n      const vec3 effectiveInputOverOutputRatioRC = vec3(\n          ${l[0]/u[0]},\n          ${l[1]/u[1]},\n          ${l[1]/u[1]});\n      const vec3 inputShapeRC = vec3(${a}.0, ${i}.0,\n                                     ${i}.0);\n\n      float getAValue(int b, int r, int c, int d) {\n        return getChannel(getA(b, r, c, d), vec2(c, d));\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        // Calculate values for next column in yRC.z.\n        ivec3 yRC = coords.yzz + ivec3(0, 0, 1);\n\n        // Fractional source index.\n        vec3 sourceFracIndexRC = vec3(yRC) * effectiveInputOverOutputRatioRC;\n\n        // Compute the four integer indices.\n        ivec3 sourceFloorRC = ivec3(sourceFracIndexRC);\n        ivec3 sourceCeilRC = ivec3(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        // Should we calculate next column and row elements in 2x2 packed cell.\n        bool hasNextCol = d < ${o-1};\n        bool hasNextRow = coords.z < ${n-1};\n\n        // In parallel, construct four corners for all four components in\n        // packed 2x2 cell.\n        vec4 topLeft = vec4(\n          getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 bottomLeft = vec4(\n          getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 topRight = vec4(\n          getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec4 bottomRight = vec4(\n          getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec3 fracRC = sourceFracIndexRC - vec3(sourceFloorRC);\n\n        vec4 top = mix(topLeft, topRight, fracRC.yyzz);\n        vec4 bottom = mix(bottomLeft, bottomRight, fracRC.yyzz);\n        vec4 newValue = mix(top, bottom, fracRC.x);\n\n        setOutput(newValue);\n      }\n    `}}class KN{constructor(t,e,n){this.variableNames=["dy"],this.outputShape=[],this.outputShape=e.shape;const[,s,r]=e.shape,[,a,i]=t.shape,o=[n&&a>1?s-1:s,n&&i>1?r-1:r],l=[n&&a>1?a-1:a,n&&i>1?i-1:i],u=o[0]/l[0],c=o[1]/l[1],h=1/u,p=1/c,d=2*Math.ceil(h)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${u});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${h});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${d});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(floor(startRLerp - float(winHeight / 2)));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(floor(startCLerp - float(winWidth / 2)));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${a}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${i}) {\n              continue;\n            }\n\n            float sourceFracRow =\n              float(${o[0]}) *\n                (float(dyR) / float(${l[0]}));\n\n            float sourceFracCol =\n                float(${o[1]}) *\n                  (float(dyC) / float(${l[1]}));\n\n            int sourceNearestRow = int(min(\n                float(int(${s}) - 1),\n                ${n} ? float(round(sourceFracRow)) :\n                                  float(floor(sourceFracRow))));\n\n            int sourceNearestCol = int(min(\n                float(int(${r}) - 1),\n                ${n} ? float(round(sourceFracCol)) :\n                                  float(floor(sourceFracCol))));\n\n            if (r == sourceNearestRow && c == sourceNearestCol) {\n              accumulator += getDy(b, dyR, dyC, d);\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}class XN{constructor(t,e,n,s){this.variableNames=["A"],this.outputShape=[];const[r,a,i,o]=t;this.outputShape=[r,e,n,o];const l=[s&&e>1?a-1:a,s&&n>1?i-1:i],u=[s&&e>1?e-1:e,s&&n>1?n-1:n],c=s?"0.5":"0.0";this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${l[0]/u[0]},\n          ${l[1]/u[1]});\n      const vec2 inputShapeRC = vec2(${a}.0, ${i}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = vec2(yRC) * effectiveInputOverOutputRatioRC;\n\n        // Compute the coordinators of nearest neighbor point.\n        ivec2 sourceNearestRC = ivec2(\n          min(inputShapeRC - 1.0, floor(sourceFracIndexRC + ${c})));\n\n        float newValue = getA(b, sourceNearestRC.x, sourceNearestRC.y, d);\n\n        setOutput(newValue);\n      }\n    `}}class YN{constructor(t,e){this.variableNames=["x"];const n=t.length;if(n>4)throw new Error(`WebGL backend: Reverse of rank-${n} tensor is not yet supported`);if(this.outputShape=t,1===n)return void(this.userCode=`\n        void main() {\n          int coord = getOutputCoords();\n          setOutput(getX(${t[0]} - coord - 1));\n        }\n      `);const s=t.map((n,s)=>(n=>-1!==e.indexOf(n)&&1!==t[n]?`${t[n]} - coords[${n}] - 1`:`coords[${n}]`)(s)).join(","),r=_k(n);this.userCode=`\n      void main() {\n        ${r} coords = getOutputCoords();\n        setOutput(getX(${s}));\n      }\n    `}}class JN{constructor(t,e){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0;const n=t.length;if(n>4)throw new Error(`WebGL backend: Reverse of rank-${n} tensor is not yet supported`);this.outputShape=t;const s=yk("rc",n),r=`${s[n-1]} + 1 < ${this.outputShape[n-1]}`,a=`${s[n-2]} + 1 < ${this.outputShape[n-2]}`,i=_k(n);function o(n){const s=t.map((s,r)=>function(n,s){return-1!==e.indexOf(n)&&1!==t[n]?`${t[n]} - ${s[n]} - 1`:""+s[n]}(r,n));return`getChannel(getX(${s.join(",")}), vec2(${s.slice(-2).join(",")}))`}this.userCode=1===n?`\n        void main(){\n          int rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = getChannel(getX(${t[0]} - rc - 1),\n            ${t[0]} - rc - 1);\n          if(${r}){\n              result.g = getChannel(getX(${t[0]} - (rc  + 1) - 1),\n                ${t[0]} - (rc  + 1) - 1);\n          }\n          setOutput(result);\n        }\n      `:`\n        void main() {\n          ${i} rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = ${function(t){return o(t)}(s.slice())};\n          if(${r}){\n            result.g = ${function(t){return t[n-1]="("+t[n-1]+" + 1)",o(t)}(s.slice())};\n          }\n          if(${a}) {\n            result.b = ${function(t){return t[n-2]="("+t[n-2]+" + 1)",o(t)}(s.slice())};\n            if(${r}) {\n              result.a = ${function(t){return t[n-1]="("+t[n-1]+" + 1)",t[n-2]="("+t[n-2]+" + 1)",o(t)}(s.slice())};\n            }\n          }\n          setOutput(result);\n        }\n    `}}class ZN{constructor(t,e,n,s,r,a,i=!0){this.variableNames=["updates","indices","defaultValue"],this.outputShape=a;const o=_k(r.length),l=_k(a.length);let u="";1===n?u="i":2===n&&(u="i, j");const c=`getIndices(${u})`;let h="";1===s?h="i":2===s&&(h="i, coords[1]");const p=`getUpdates(${h})`,d=e>1?"strides[j]":"strides";this.userCode=`\n        ${o} strides = ${o}(${r});\n\n        void main() {\n          ${l} coords = getOutputCoords();\n          float sum = 0.0;\n          bool found = false;\n          for (int i = 0; i < ${t}; i++) {\n            int flattenedIndex = 0;\n            for (int j = 0; j < ${e}; j++) {\n              int index = round(${c});\n              flattenedIndex += index * ${d};\n            }\n            if (flattenedIndex == coords[0]) {\n              sum += ${p};\n              found = true;\n            }\n          }\n          setOutput(mix(getDefaultValue(), sum, float(found)));\n        }\n      `}}class QN{constructor(t,e){this.variableNames=["x","segmentIds"];const n=t.windowSize,s=t.batchSize,r=t.inSize,a=t.numSegments,i=a*Math.ceil(r/n);this.outputShape=[s,i];const o=4*Math.floor(n/4),l=n%4,u="\n        sumValue += dot(values, segFilter);\n    ";let c="";r%n>0&&(c=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return initializationValue;\n        }\n      `);let h="";r%n>0&&(h=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return -1.0;\n        }\n      `),this.userCode=`\n      const float initializationValue = 0.0;\n\n      float getValue(int batch, int inIdx) {\n        ${c}\n        return getX(batch, inIdx);\n      }\n\n      float getSegmentIdAtIndex(int inIdx) {\n        ${h}\n        return getSegmentIds(inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = int(floor(float(outIdx) / float(\n          ${a})) * float(${n}));\n        int currentSeg = int(mod(float(outIdx), float(${a})));\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${o}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 3)) == currentSeg ? 1 : 0\n          );\n\n          ${u}\n        }\n\n        int inIdx = inOffset + ${o};\n        if (${1===l}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          int inIdxSeg = int(getSegmentIdAtIndex(inIdx));\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            0,\n            0,\n            0\n          );\n\n          ${u}\n        } else if (${2===l}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n              0,\n              0\n          );\n\n          ${u}\n        } else if (${3===l}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            0\n          );\n\n          ${u}\n        }\n        setOutput(sumValue);\n      }\n    `}}class tI{constructor(t,e,n){let s,r;if(this.variableNames=["c","a","b"],this.outputShape=e,n>4)throw Error(`Where for rank ${n} is not yet supported`);if(1===n)r="resRC",s="resRC";else{const n=["resRC.x","resRC.y","resRC.z","resRC.w"],a=[],i=[];for(let s=0;s<e.length;s++)i.push(""+n[s]),s<t&&a.push(""+n[s]);s=a.join(),r=i.join()}const a=_k(n);this.userCode=`\n      void main() {\n        ${a} resRC = getOutputCoords();\n        float cVal = getC(${s});\n        if (cVal >= 1.0) {\n          setOutput(getA(${r}));\n        } else {\n          setOutput(getB(${r}));\n        }\n      }\n    `}}class eI{constructor(t){this.variableNames=["source"],this.outputShape=t,this.rank=t.length;const e=_k(this.rank),n=`uniform int start[${this.rank}];`,s=function(t){if(1===t)return"sourceLoc";if(t<=6)return nI.slice(0,t).map(t=>"sourceLoc."+t).join(",");throw Error(`Slicing for rank ${t} is not yet supported`)}(this.rank);let r;r=`\n        ${e} sourceLoc;\n        ${e} coords = getOutputCoords();\n        ${t.map((t,e)=>`sourceLoc.${nI[e]} = start[${e}] + coords.${nI[e]};`).join("\n")}\n      `,this.userCode=`\n      ${n}\n      void main() {\n        ${r}\n        setOutput(getSource(${s}));\n      }\n    `}getCustomSetupFunc(t){if(t.length!==this.rank)throw Error(`The rank (${this.rank}) of the program must match the length of start (${t.length})`);return(e,n)=>{null==this.startLoc&&(this.startLoc=e.getUniformLocationNoThrow(n,"start"),null==this.startLoc)||e.gl.uniform1iv(this.startLoc,t)}}}const nI=["x","y","z","w","u","v"];class sI{constructor(t){this.variableNames=["source"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t,this.rank=t.length;const e=_k(this.rank),n=yk("coords",this.rank),s=yk("sourceLoc",this.rank),r=1===this.rank?"sourceLoc":`vec2(${s.slice(-2).join()})`,a=`getChannel(getSource(${s.join()}), ${r})`,i=`\n      result.x = ${a};\n      if (++${n[this.rank-1]} < ${t[this.rank-1]}) {\n        ++${s[this.rank-1]};\n        result.y = ${a};\n        --${s[this.rank-1]};\n      }\n    `,o=1===this.rank?"":`\n      --${n[this.rank-1]};\n      if (++${n[this.rank-2]} < ${t[this.rank-2]}) {\n        ++${s[this.rank-2]};\n        result.z = ${a};\n        if (++${n[this.rank-1]} < ${t[this.rank-1]}) {\n          ++${s[this.rank-1]};\n          result.w = ${a};\n        }\n      }\n    `,l=this.rank<=4?`sourceLoc = coords +\n            ${e}(${t.map((t,e)=>`start[${e}]`).join()});`:t.map((t,e)=>`${s[e]} = ${n[e]} + start[${e}];`).join("\n");this.userCode=`\n      uniform int start[${this.rank}];\n      void main() {\n        ${e} coords = getOutputCoords();\n        ${e} sourceLoc;\n        ${l}\n        vec4 result = vec4(0.);\n        ${i}\n        ${o}\n        setOutput(result);\n      }\n    `}getCustomSetupFunc(t){if(t.length!==this.rank)throw Error(`The rank (${this.rank}) of the program must match the length of start (${t.length})`);return(e,n)=>{null==this.startLoc&&(this.startLoc=e.getUniformLocationNoThrow(n,"start"),null==this.startLoc)||e.gl.uniform1iv(this.startLoc,t)}}}class rI{constructor(t,e,n){this.variableNames=["x"],this.outputShape=n;const s=n.length,r=_k(n.length),a=_k(n.length);let i="";if(1===s)i="coords * strides + begin";else{let t=0;i=n.map((e,s)=>(t++,1===n.length?`coords * strides[${s}] + begin[${s}]`:`coords[${t-1}] * strides[${s}] + begin[${s}]`)).join(",")}this.userCode=`\n      ${r} begin = ${r}(${t});\n      ${r} strides = ${r}(${e});\n\n      void main() {\n        ${a} coords = getOutputCoords();\n        setOutput(getX(${i}));\n      }\n    `}}class aI{constructor(t){this.gpgpu=t,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0,this.freeTextures={},this.logEnabled=!1,this.usedTextures={}}acquireTexture(t,e,n){const s=oI(e,n),r=lI(t,s,n);r in this.freeTextures||(this.freeTextures[r]=[]),r in this.usedTextures||(this.usedTextures[r]=[]);const a=iI(t,s,this.gpgpu.gl,this.gpgpu.textureConfig,n);if(this.freeTextures[r].length>0){this.numFreeTextures--,this.numUsedTextures++,this._numBytesFree-=a,this.log();const t=this.freeTextures[r].shift();return this.usedTextures[r].push(t),t}let i;return s===kv.PACKED_2X2_FLOAT32?i=this.gpgpu.createPackedMatrixTexture(t[0],t[1]):s===kv.PACKED_2X2_FLOAT16?i=this.gpgpu.createFloat16PackedMatrixTexture(t[0],t[1]):s===kv.UNPACKED_FLOAT32?i=this.gpgpu.createFloat32MatrixTexture(t[0],t[1]):s===kv.UNPACKED_FLOAT16?i=this.gpgpu.createFloat16MatrixTexture(t[0],t[1]):s===kv.PACKED_4X1_UNSIGNED_BYTE&&(i=this.gpgpu.createUnsignedBytesMatrixTexture(t[0],t[1])),this.usedTextures[r].push(i),this.numUsedTextures++,this._numBytesAllocated+=a,this.log(),i}releaseTexture(t,e,n,s){if(null==this.freeTextures)return;const r=oI(n,s),a=lI(e,r,s);a in this.freeTextures||(this.freeTextures[a]=[]);const i=iI(e,r,this.gpgpu.gl,this.gpgpu.textureConfig,s),o=H().get("WEBGL_DELETE_TEXTURE_THRESHOLD");-1!==o&&this._numBytesAllocated>o?(this.gpgpu.deleteMatrixTexture(t),this._numBytesAllocated-=i):(this.freeTextures[a].push(t),this.numFreeTextures++,this._numBytesFree+=i),this.numUsedTextures--;const l=this.usedTextures[a],u=l.indexOf(t);if(u<0)throw new Error("Cannot release a texture that was never provided by this texture manager");l.splice(u,1),this.log()}log(){if(!this.logEnabled)return;const t=this.numFreeTextures+this.numUsedTextures;console.log("Free/Used",`${this.numFreeTextures} / ${this.numUsedTextures}`,`(${t})`);const e=this._numBytesFree/this._numBytesAllocated;console.log("Bytes allocated: "+this._numBytesAllocated),console.log(`Bytes unused: ${this._numBytesFree} (${Math.round(100*e)}%)`)}get numBytesAllocated(){return this._numBytesAllocated}get numBytesFree(){return this._numBytesFree}getNumUsedTextures(){return this.numUsedTextures}getNumFreeTextures(){return this.numFreeTextures}dispose(){if(null!=this.freeTextures){for(const t in this.freeTextures)this.freeTextures[t].forEach(t=>{this.gpgpu.deleteMatrixTexture(t)});for(const t in this.usedTextures)this.usedTextures[t].forEach(t=>{this.gpgpu.deleteMatrixTexture(t)});this.freeTextures=null,this.usedTextures=null,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0}}}function iI(t,e,n,s,r){const a=function(t,e){switch(t){case kv.PACKED_2X2_FLOAT32:return IN(e);case kv.PACKED_2X2_FLOAT16:return CN(e);case kv.UNPACKED_FLOAT32:return vN(e);case kv.UNPACKED_FLOAT16:return kN(e);case kv.PACKED_4X1_UNSIGNED_BYTE:return NN(e);default:throw new Error("Unknown physical texture type "+t)}}(e,s);let i;if(r){const[e,n]=Cv(t[0],t[1]);i=e*n}else{const[e,n]=Nv(t[0],t[1]);i=e*n}return i*function(t,e){const n=t;if(e===n.R32F)return 4;if(e===n.R16F)return 2;if(e===n.RGBA32F)return 16;if(e===t.RGBA)return 16;if(e===n.RGBA16F)return 8;throw new Error("Unknown internal format "+e)}(n,a)}function oI(t,e){if(t===vv.UPLOAD)return kv.PACKED_2X2_FLOAT32;if(t===vv.RENDER||null==t)return function(t){return H().getBool("WEBGL_RENDER_FLOAT32_ENABLED")?t?kv.PACKED_2X2_FLOAT32:kv.UNPACKED_FLOAT32:t?kv.PACKED_2X2_FLOAT16:kv.UNPACKED_FLOAT16}(e);if(t===vv.DOWNLOAD||t===vv.PIXELS)return kv.PACKED_4X1_UNSIGNED_BYTE;throw new Error("Unknown logical texture type "+t)}function lI(t,e,n){return`${t[0]}_${t[1]}_${e}_${n}`}class uI{constructor(t,e){this.variableNames=["A"];const n=new Array(t.length);for(let s=0;s<n.length;s++)n[s]=t[s]*e[s];this.outputShape=n,this.rank=n.length;const s=_k(this.rank),r=function(t){const e=t.length;if(e>5)throw Error(`Tile for rank ${e} is not yet supported`);if(1===e)return`imod(resRC, ${t[0]})`;const n=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u"],s=[];for(let e=0;e<t.length;e++)s.push(`imod(${n[e]}, ${t[e]})`);return s.join()}(t);this.userCode=`\n      void main() {\n        ${s} resRC = getOutputCoords();\n        setOutput(getA(${r}));\n      }\n    `}}class cI{constructor(t,e){this.variableNames=["A"],this.outputShape=t,this.userCode=`\n      float unaryOperation(float x) {\n        ${e}\n      }\n\n      void main() {\n        float x = getAAtOutCoords();\n        float y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}const hI="if (isnan(x)) return x;",pI="return abs(x);",dI=hI+"\n  return (x < 0.0) ? 0.0 : x;\n",fI=hI+"\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n",mI="return (x >= 0.0) ? x : (exp(x) - 1.0);",gI=`\n  // Stable and Attracting Fixed Point (0, 1) for Normalized Weights.\n  // see: https://arxiv.org/abs/1706.02515\n  float scaleAlpha = 1.7580993408473768;\n  float scale = ${ql};\n  return (x >= 0.0) ? scale * x : scaleAlpha * (exp(x) - 1.0);\n`;const yI="return -x;",bI="return ceil(x);",xI="return floor(x);",wI="return exp(x);",vI="return exp(x) - 1.0;",kI="return x;",NI="\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n",II="\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n",CI="\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n";class SI{constructor(t,e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t,this.userCode=`\n      vec4 unaryOperation(vec4 x) {\n        ${e}\n      }\n\n      void main() {\n        vec4 x = getAAtOutCoords();\n        vec4 y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}class TI{constructor(t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outputShape=t;const e=t.length,n=yk("rc",e),s=_k(e),r=function(t,e){if(1===t)return"rc";let n="";for(let s=0;s<t;s++)n+=e[s],s<t-1&&(n+=",");return n}(e,n),a=n.slice(-2),i=e<=1?"rc":`vec2(${a.join(",")})`;this.userCode=`\n      void main() {\n        ${s} rc = getOutputCoords();\n        vec4 packedInput = getA(${r});\n\n        setOutput(getChannel(packedInput, ${i}));\n      }\n    `}}const{segment_util:EI}=au,$I=iu,AI=ou,RI=lu,DI=to,_I={};function FI(t,e=!1){if("linear"===t)return"return x;";if("relu"===t)return e?NI:dI;if("elu"===t)return e?CI:mI;if("relu6"===t)return e?II:fI;if("prelu"===t)return e?Wk:Bk;throw new Error(`Activation ${t} has not been implemented for the WebGL backend.`)}class OI extends n{constructor(t){if(super(),this.pendingRead=new WeakMap,this.pendingDisposal=new WeakSet,this.dataRefCount=new WeakMap,this.numBytesInGPU=0,this.uploadWaitMs=0,this.downloadWaitMs=0,this.warnedAboutMemory=!1,this.warnedAboutCPUBackend=!1,this.pendingDeletes=0,this.disposed=!1,!H().getBool("HAS_WEBGL"))throw new Error("WebGL is not supported on this device");if(null==t){const t=xv(H().getNumber("WEBGL_VERSION"));this.binaryCache=((n=H().getNumber("WEBGL_VERSION"))in _I||(_I[n]={}),_I[n]),this.gpgpu=new TN(t),this.canvas=t.canvas,this.gpgpuCreatedLocally=!0}else this.gpgpu=t,this.binaryCache={},this.gpgpuCreatedLocally=!1,this.canvas=t.gl.canvas;var n;this.textureManager=new aI(this.gpgpu),this.numMBBeforeWarning=null==H().global.screen?1024:H().global.screen.height*H().global.screen.width*window.devicePixelRatio*600/1024/1024,this.texData=new e(this,Xn())}numDataIds(){return this.texData.numDataIds()+(this.cpuBackend?this.cpuBackend.numDataIds():0)-this.pendingDeletes}write(t,e,n){if((H().getBool("WEBGL_CHECK_NUMERICAL_PROBLEMS")||H().getBool("DEBUG"))&&this.checkNumericalProblems(t),"complex64"===n&&null!=t)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");const s={};return this.texData.set(s,{shape:e,dtype:n,values:t,usage:vv.UPLOAD,refCount:1,complexParentRefCount:0}),s}incRef(t){this.texData.get(t).refCount++}decRef(t){if(this.texData.has(t)){this.texData.get(t).refCount--}}move(t,e,n,s){if(H().getBool("DEBUG")&&this.checkNumericalProblems(e),"complex64"===s)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");this.texData.set(t,{shape:n,dtype:s,values:e,usage:vv.UPLOAD,refCount:1,complexParentRefCount:0})}disposeIntermediateTensorInfo(t){const e=t.dataId;if(this.texData.has(e)){const t=this.texData.get(e);t.refCount--,t.refCount<1&&this.disposeData(e)}}readSync(t){const e=this.texData.get(t),{values:n,dtype:s,complexTensorInfos:r,slice:a,shape:i,isPacked:o}=e;if(null!=a){let e;e=o?new SI(i,kI):new cI(i,kI);const n=this.runWebGLProgram(e,[{dataId:t,shape:i,dtype:s}],s),r=this.readSync(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=n)return this.convertAndCacheOnCPU(t);if("string"===s)return n;const l=null!=this.activeTimers;let u,c;if(l&&(u=ht()),"complex64"===s){c=Xl(this.readSync(r.real.dataId),this.readSync(r.imag.dataId))}else c=this.getValuesFromTexture(t);return l&&(this.downloadWaitMs+=ht()-u),this.convertAndCacheOnCPU(t,c)}async read(t){if(this.pendingRead.has(t)){const e=this.pendingRead.get(t);return new Promise(t=>e.push(t))}const e=this.texData.get(t),{values:n,shape:s,slice:r,dtype:a,complexTensorInfos:i,isPacked:o}=e;if(null!=r){let e;e=o?new SI(s,kI):new cI(s,kI);const n=this.runWebGLProgram(e,[{dataId:t,shape:s,dtype:a}],a),r=this.read(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=n)return this.convertAndCacheOnCPU(t);if(!H().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")&&2===H().getNumber("WEBGL_VERSION"))throw new Error("tensor.data() with WEBGL_DOWNLOAD_FLOAT_ENABLED=false and WEBGL_VERSION=2 not yet supported.");let l,u,c=null;if("complex64"!==a&&H().get("WEBGL_BUFFER_SUPPORTED")){l=this.decode(t);const e=this.texData.get(l.dataId);c=this.gpgpu.createBufferFromTexture(e.texture,...Iv(s))}if(this.pendingRead.set(t,[]),"complex64"!==a&&await this.gpgpu.createAndWaitForFence(),"complex64"===a){const t=await Promise.all([this.read(i.real.dataId),this.read(i.imag.dataId)]);u=Xl(t[0],t[1])}else if(null==c)u=this.getValuesFromTexture(t);else{const t=p(s);u=this.gpgpu.downloadFloat32MatrixFromBuffer(c,t)}null!=l&&this.disposeIntermediateTensorInfo(l);const h=this.convertAndCacheOnCPU(t,u),d=this.pendingRead.get(t);return this.pendingRead.delete(t),d.forEach(t=>t(h)),this.pendingDisposal.has(t)&&(this.pendingDisposal.delete(t),this.disposeData(t),this.pendingDeletes--),h}checkNumericalProblems(t){if(null!=t)for(let e=0;e<t.length;e++){const n=t[e];if(!Ev(n)){if(H().getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))throw Error(`The value ${n} cannot be represented with your current settings. Consider enabling float32 rendering: 'tf.env().set('WEBGL_RENDER_FLOAT32_ENABLED', true);'`);throw Error(`The value ${n} cannot be represented on this device.`)}}}getValuesFromTexture(t){const{shape:e,dtype:n,isPacked:s}=this.texData.get(t),r=p(e);if(H().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")){const n=this.decode(t),s=this.texData.get(n.dataId),a=this.gpgpu.downloadMatrixFromPackedTexture(s.texture,...Iv(e)).subarray(0,r);return this.disposeIntermediateTensorInfo(n),a}const a=H().getBool("WEBGL_PACK")&&!0===s,i=a?Vv(e):e,o=a?new hN(i):new cN(i),l=this.runWebGLProgram(o,[{shape:i,dtype:n,dataId:t}],"float32"),u=this.texData.get(l.dataId),c=this.gpgpu.downloadByteEncodedFloatMatrixFromOutputTexture(u.texture,u.texShape[0],u.texShape[1]).subarray(0,r);return this.disposeIntermediateTensorInfo(l),c}async time(t){const e=this.activeTimers,n=[];let s=!1;null==this.programTimersStack?(this.programTimersStack=n,s=!0):this.activeTimers.push(n),this.activeTimers=n,t();const r=h(this.activeTimers.map(t=>t.query)).filter(t=>null!=t),a=h(this.activeTimers.map(t=>t.name)).filter(t=>null!=t);this.activeTimers=e,s&&(this.programTimersStack=null);const i={uploadWaitMs:this.uploadWaitMs,downloadWaitMs:this.downloadWaitMs,kernelMs:null,wallMs:null};if(H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0){const t=await Promise.all(r);i.kernelMs=o(t),i.getExtraProfileInfo=()=>t.map((t,e)=>({name:a[e],ms:t})).map(t=>`${t.name}: ${t.ms}`).join(", ")}else i.kernelMs={error:"WebGL query timers are not supported in this environment."};return this.uploadWaitMs=0,this.downloadWaitMs=0,i}memory(){return{unreliable:!1,numBytesInGPU:this.numBytesInGPU,numBytesInGPUAllocated:this.textureManager.numBytesAllocated,numBytesInGPUFree:this.textureManager.numBytesFree}}startTimer(){return H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?this.gpgpu.beginQuery():{startMs:ht(),endMs:null}}endTimer(t){return H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?(this.gpgpu.endQuery(),t):(t.endMs=ht(),t)}async getQueryTime(t){if(H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0)return this.gpgpu.waitForQueryAndGetTime(t);const e=t;return e.endMs-e.startMs}disposeData(t){if(this.pendingDisposal.has(t))return;if(this.pendingRead.has(t))return this.pendingDisposal.add(t),void this.pendingDeletes++;if(!this.texData.has(t))return;if(this.texData.get(t).complexParentRefCount>0)return void this.texData.get(t).refCount--;this.releaseGPUData(t);const{complexTensorInfos:e}=this.texData.get(t);null!=e&&(this.texData.get(e.real.dataId).complexParentRefCount--,this.disposeIntermediateTensorInfo(e.real),this.texData.get(e.imag.dataId).complexParentRefCount--,this.disposeIntermediateTensorInfo(e.imag)),this.texData.delete(t)}releaseGPUData(t){const{texture:e,dtype:n,texShape:s,usage:r,isPacked:a,slice:i}=this.texData.get(t),o=i&&i.origDataId||t,l=this.dataRefCount.get(o);l>1?this.dataRefCount.set(o,l-1):(this.dataRefCount.delete(o),null!=e&&(this.numBytesInGPU-=this.computeBytes(s,n),this.textureManager.releaseTexture(e,s,r,a)));const u=this.texData.get(t);u.texture=null,u.texShape=null,u.isPacked=!1,u.slice=null}getTexture(t){return this.uploadToGPU(t),this.texData.get(t).texture}getDataInfo(t){return this.texData.get(t)}getCPUBackend(){return H().getBool("WEBGL_CPU_FORWARD")?(null==this.cpuBackend&&(this.cpuBackend=Xn().findBackend("cpu")),this.cpuBackend):null}shouldExecuteOnCPU(t,e=128){const n=this.getCPUBackend();return this.warnedAboutCPUBackend||null!=n||(console.warn("Your application contains ops that are small enough to be executed on the CPU backend, however the CPU backend cannot be found. Consider importing the CPU backend (@tensorflow/tfjs-backend-cpu) for better performance."),this.warnedAboutCPUBackend=!0),null!=n&&t.every(t=>null==this.texData.get(t.dataId).texture&&p(t.shape)<e)}getGPGPUContext(){return this.gpgpu}slice(t,e,n){if(this.shouldExecuteOnCPU([t])){const s=uk(this.texData.get(t.dataId).values,e,n,t.shape,t.dtype);return this.makeOutput(n,t.dtype,s)}if(0===p(n))return re([],n,t.dtype);const{isPacked:s}=this.texData.get(t.dataId),r=On(t.shape,e,n);if(s||!r){const s=H().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new sI(n):new eI(n),r=s.getCustomSetupFunc(e);return this.compileAndRun(s,[t],null,r)}return this.uploadToGPU(t.dataId),this.shallowSlice(t,e,n)}shallowSlice(t,e,n){const s=this.texData.get(t.dataId),r=this.makeOutput(n,t.dtype),a=this.texData.get(r.dataId);Object.assign(a,s),a.shape=n,a.dtype=t.dtype;let i=Mn(e,t.strides);s.slice&&(i+=s.slice.flatOffset),a.slice={flatOffset:i,origDataId:s.slice&&s.slice.origDataId||t.dataId};const o=this.dataRefCount.get(a.slice.origDataId)||1;return this.dataRefCount.set(a.slice.origDataId,o+1),r}stridedSlice(t,e,n,s){const r=this.tryRunOnCpuOrThrow([t],()=>this.cpuBackend.stridedSlice(t,e,n,s));if(r)return r;const a=Cn(e,n,s);if(a.some(t=>0===t))return re([],a);const i=new rI(e,s,a);return this.compileAndRun(i,[t])}reverse(t,e){const n=H().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new JN(t.shape,e):new YN(t.shape,e);return this.compileAndRun(n,[t])}neg(t){const e=this.tryRunOnCpuOrThrow([t],()=>this.cpuBackend.neg(t));if(e)return e;if(H().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(t,yI,t.dtype);const n=new cI(t.shape,yI);return this.compileAndRun(n,[t])}batchMatMul(t,e,n,s){const r=n?t.shape[2]:t.shape[1],a=s?e.shape[1]:e.shape[2],i=n?t.shape[1]:t.shape[2],o=Math.max(t.shape[0],e.shape[0]);if((1===r||1===a)&&i>1e3){n&&(t=cn(t,[0,2,1])),s&&(e=cn(e,[0,2,1]));const r=1===a?t:t.as3D(o,i,1),l=1===a?2:1,u=1===a?e.as3D(o,1,i):e;return is(r,u).sum(l,!0)}const l=Ot(t.dtype,e.dtype),u=new ON(t.shape,e.shape,[o,r,a],n,s);return this.compileAndRun(u,[t,e],l)}fusedBatchMatMul({a:t,b:e,transposeA:n,transposeB:s,bias:r,activation:a,preluActivationWeights:i}){const o=n?t.shape[2]:t.shape[1],l=s?e.shape[1]:e.shape[2],u=Math.max(t.shape[0],e.shape[0]),c=Ot(t.dtype,e.dtype),h=null!=r,p=null!=i,d=a?FI(a,!0):null,f=new ON(t.shape,e.shape,[u,o,l],n,s,h,d,p),m=[t,e];return r&&m.push(r),i&&m.push(i),this.compileAndRun(f,m,c)}localResponseNormalization4D(t,e,n,s,r){const a=H().getBool("WEBGL_PACK_NORMALIZATION")?new DN(t.shape,e,n,s,r):new AN(t.shape,e,n,s,r);return this.compileAndRun(a,[t])}LRNGrad(t,e,n,s,r,a,i){const o=new RN(e.shape,s,r,a,i);return this.compileAndRun(o,[e,n,t])}tile(t,e){if("string"===t.dtype){const n=this.readSync(t.dataId).map(t=>ft(t)),s=We(t.shape,t.dtype,n);return AI(s,e)}const n=new uI(t.shape,e);return this.compileAndRun(n,[t])}pad(t,e,n){const s=H().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new PN(t.shape,e,n):new BN(t.shape,e,n);return this.compileAndRun(s,[t])}gather(t,e,n){const s=this.tryRunOnCpuOrThrow([t,e],()=>this.cpuBackend.gather(t,e,n));if(s)return s;const r=new mN(t.shape,e.size,n);return this.compileAndRun(r,[t,e])}batchToSpaceND(t,e,n){l(t.rank<=4,()=>"batchToSpaceND for rank > 4 with a WebGL backend not implemented yet");const s=e.reduce((t,e)=>t*e),r=Vl(t.shape,e,s),a=Ul(r.length,e.length),i=Gl(t.shape,e,s),o=Hl(n,e.length),u=jl(i,n,e.length);return cn(t.reshape(r),a).reshape(i).slice(o,u)}spaceToBatchND(t,e,n){l(t.rank<=4,()=>"spaceToBatchND for rank > 4 with a WebGL backend not implemented yet");const s=e.reduce((t,e)=>t*e),r=[[0,0]];r.push(...n);for(let n=1+e.length;n<t.shape.length;++n)r.push([0,0]);const a=t.pad(r),i=Vl(a.shape,e,s,!1),o=Ul(i.length,e.length,!1),u=Gl(a.shape,e,s,!1),c=cn(a.reshape(i),o);return on(c,u)}reduce(t,e,n){const s=t.shape[0],r=t.shape[1],a=Pr(r),i=Math.ceil(r/a),o=new UN({windowSize:a,inSize:r,batchSize:s,outSize:i},e),l=this.compileAndRun(o,[t],n);return 1===l.shape[1]?l:this.reduce(l,e,n)}argReduce(t,e,n=null){let s=t.shape[0],r=t.shape[1];null!=n&&(s=n.shape[0],r=n.shape[1]);const a=Pr(r),i={windowSize:a,inSize:r,batchSize:s,outSize:Math.ceil(r/a)},o=new mk(i,e,null==n),l=[t];null!=n&&l.push(n);const u=this.compileAndRun(o,l,"int32");return 1===u.shape[1]?u:this.argReduce(t,e,u)}argReducePacked(t,e,n=null){const s=null!=n?n.shape:t.shape,r=Pr(s[s.length-1]),a=new Mk(s,r,e,null==n),i=null==n?[t]:[t,n],o=this.compileAndRun(a,i,"int32");return o.rank===t.rank?this.argReducePacked(t,e,o):o}sum(t,e){ms("sum",e,t.rank);const[n,s]=ds(t.shape,e),r=p(s),a=t.as2D(-1,r),i=Mt(t.dtype);return this.reduce(a,"sum",i).reshape(n)}prod(t,e){const n=this.tryRunOnCpuOrThrow([t],()=>this.cpuBackend.prod(t,e));if(n)return n;const[s,r]=ds(t.shape,e),a=p(r),i=t.as2D(-1,a),o=Mt(t.dtype);return this.reduce(i,"prod",o).reshape(s)}unsortedSegmentSum(t,e,n){let s=0;const r=gs([s],t.rank);let a=t;null!=r&&(a=cn(t,r),s=bs(1,t.rank)[0]);const i=EI.computeOutShape(a.shape,s,n),o=p([a.shape[s]]),l=a.as2D(-1,o),u=Mt(t.dtype);let c=this.segOpCompute(l,"unsortedSegmentSum",e,u,n).reshape(i);return null!=r&&(c=cn(c,ys(r))),c}segOpCompute(t,e,n,s,r){const a=t.shape[0],i=t.shape[1],o=EI.segOpComputeOptimalWindowSize(i,r),l=new QN({windowSize:o,inSize:i,batchSize:a,numSegments:r},e),u=this.compileAndRun(l,[t,n],s);return u.shape[1]===r?u:(n=hi(0,r).tile([i/o]),this.segOpCompute(u,e,n,s,r))}argMinMaxReduce(t,e,n){const s=[e];if(ms("arg"+n.charAt(0).toUpperCase()+n.slice(1),s,t.rank),!H().getBool("WEBGL_PACK_REDUCE")||t.rank<=2){const[e,r]=ds(t.shape,s),a=p(r),i=t.as2D(-1,a);return this.argReduce(i,n).reshape(e)}return this.argReducePacked(t,n)}argMin(t,e){return this.argMinMaxReduce(t,e,"min")}argMax(t,e){return this.argMinMaxReduce(t,e,"max")}cumsum(t,e,n,s){if(e!==t.rank-1)throw new Error(`WebGL cumsum shader expects an inner-most axis=${t.rank-1} but got axis=`+e);const r=t.shape[e];let a=t;for(let e=0;e<=Math.ceil(Math.log2(r))-1;e++){const n=new sN(t.shape,!1,s),r=n.getCustomSetupFunc(e),i=a;a=this.compileAndRun(n,[a],a.dtype,r),i.dispose()}if(n){const e=new sN(t.shape,n,s),r=a;a=this.compileAndRun(e,[a]),r.dispose()}return a}equal(t,e){if(H().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(t,e,"\n  return vec4(equal(a, b));\n","bool");const n=new Pk("return float(a == b);",t.shape,e.shape);return this.compileAndRun(n,[t,e],"bool")}less(t,e){const n=this.tryRunOnCpuOrThrow([t,e],()=>this.cpuBackend.less(t,e));if(n)return n;if(H().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(t,e,"\n  return vec4(lessThan(a, b));\n","bool");const s=new Pk("return float(a < b);",t.shape,e.shape);return this.compileAndRun(s,[t,e],"bool")}lessEqual(t,e){if(H().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(t,e,"\n  return vec4(lessThanEqual(a, b));\n","bool");const n=new Pk("return float(a <= b);",t.shape,e.shape);return this.compileAndRun(n,[t,e],"bool")}greater(t,e){const n=this.tryRunOnCpuOrThrow([t,e],()=>this.cpuBackend.greater(t,e));if(n)return n;if(H().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(t,e,"\n  return vec4(greaterThan(a, b));\n","bool");const s=new Pk("return float(a > b);",t.shape,e.shape);return this.compileAndRun(s,[t,e],"bool")}greaterEqual(t,e){if(H().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(t,e,"\n  return vec4(greaterThanEqual(a, b));\n","bool");const n=new Pk("return float(a >= b);",t.shape,e.shape);return this.compileAndRun(n,[t,e],"bool")}logicalNot(t){const e=new cI(t.shape,"return float(!(x >= 1.0));");return this.compileAndRun(e,[t])}logicalAnd(t,e){if(H().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(t,e,"\n  return vec4(\n    vec4(greaterThanEqual(a, vec4(1.0))) *\n    vec4(greaterThanEqual(b, vec4(1.0))));\n","bool");const n=new Pk("return float(a >= 1.0 && b >= 1.0);",t.shape,e.shape);return this.compileAndRun(n,[t,e],"bool")}logicalOr(t,e){if(H().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(t,e,"\n  return min(\n    vec4(greaterThanEqual(a, vec4(1.0))) +\n    vec4(greaterThanEqual(b, vec4(1.0))),\n    vec4(1.0));\n","bool");const n=new Pk("return float(a >= 1.0 || b >= 1.0);",t.shape,e.shape);return this.compileAndRun(n,[t,e],"bool")}select(t,e,n){const s=new tI(t.rank,e.shape,e.rank);return this.compileAndRun(s,[t,e,n],Ot(e.dtype,n.dtype))}where(t){Kl("tf.where() in webgl locks the UI thread. Call tf.whereAsync() instead");const e=t.dataSync();return DI(t.shape,e)}topk(t,e,n){const s=t.dataSync();return RI(s,t.shape,t.dtype,e,n)}min(t,e){ms("min",e,t.rank);const[n,s]=ds(t.shape,e),r=p(s),a=t.as2D(-1,r);return this.reduce(a,"min",a.dtype).reshape(n)}minimum(t,e){const n=this.tryRunOnCpuOrThrow([t,e],()=>this.cpuBackend.minimum(t,e));if(n)return n;const s=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Vk("\n  vec4 result = vec4(min(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",t.shape,e.shape):new Pk("\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return min(a, b);\n",t.shape,e.shape);return this.compileAndRun(s,[t,e])}mod(t,e){const n=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Vk("\n  vec4 result = mod(a, b);\n  vec4 isNaN = vec4(equal(b, vec4(0.0)));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",t.shape,e.shape):new Pk("if (b == 0.0) return NAN;\n  return mod(a, b);",t.shape,e.shape);return this.compileAndRun(n,[t,e])}maximum(t,e){const n=this.tryRunOnCpuOrThrow([t,e],()=>this.cpuBackend.maximum(t,e));if(n)return n;const s=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Vk("\n  vec4 result = vec4(max(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",t.shape,e.shape):new Pk("\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return max(a, b);\n",t.shape,e.shape);return this.compileAndRun(s,[t,e])}all(t,e){ms("all",e,t.rank);const[n,s]=ds(t.shape,e),r=p(s),a=t.as2D(-1,r);return this.reduce(a,"all",a.dtype).reshape(n)}any(t,e){ms("any",e,t.rank);const[n,s]=ds(t.shape,e),r=p(s),a=t.as2D(-1,r);return this.reduce(a,"any",a.dtype).reshape(n)}floorDiv(t,e){if(H().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(t,e,"\n  ivec4 ia = round(a);\n  ivec4 ib = round(b);\n  bvec4 cond = notEqual(ib, ivec4(0));\n  ivec4 result = ivec4(0);\n  vec4 s = sign(a) * sign(b);\n\n  // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n  if (cond[0]) {\n    result[0] = idiv(ia[0], ib[0], s[0]);\n  }\n  if (cond[1]) {\n    result[1] = idiv(ia[1], ib[1], s[1]);\n  }\n  if (cond[2]) {\n    result[2] = idiv(ia[2], ib[2], s[2]);\n  }\n  if (cond[3]) {\n    result[3] = idiv(ia[3], ib[3], s[3]);\n  }\n  return vec4(result);\n","int32");const n=new Pk("\n  float s = sign(a) * sign(b);\n  int ia = round(a);\n  int ib = round(b);\n  if (ib != 0) {\n    // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n    return float(idiv(ia, ib, s));\n  } else {\n    return NAN;\n  }\n",t.shape,e.shape);return this.compileAndRun(n,[t,e],"int32")}packedUnaryOp(t,e,n){const s=new SI(t.shape,e);return this.compileAndRun(s,[t],n)}packedBinaryOp(t,e,n,s,r=!1){const a=new Vk(n,t.shape,e.shape,r);return this.compileAndRun(a,[t,e],s)}makeComplexComponentTensorInfo(t,e){return{dataId:e.dataId,dtype:e.dtype,shape:t.shape}}addN(t){if(1===t.length)return t[0];if(t.length>H().get("WEBGL_MAX_TEXTURES_IN_SHADER")){const e=Math.floor(t.length/2),n=this.addN(t.slice(0,e)),s=this.addN(t.slice(e));return this.addN([n,s])}const e=t.map(t=>t.dtype).reduce((t,e)=>Ot(t,e)),n=t.map(t=>t.shape),s=H().getBool("WEBGL_PACK")?new fk(t[0].shape,n):new dk(t[0].shape,n);return this.compileAndRun(s,t,e)}pow(t,e){const n=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Vk("\n  // isModRound1 has 1 for components with round(mod(b, 2.0)) == 1, 0 otherwise.\n  vec4 isModRound1 = vec4(equal(round(mod(b, 2.0)), ivec4(1)));\n  vec4 multiplier = sign(a) * isModRound1 + (vec4(1.0) - isModRound1);\n  vec4 result = multiplier * pow(abs(a), b);\n\n  // Ensure that a^0 = 1, including 0^0 = 1 as this correspond to TF and JS\n  bvec4 isExpZero = equal(b, vec4(0.0));\n  result.r = isExpZero.r ? 1.0 : result.r;\n  result.g = isExpZero.g ? 1.0 : result.g;\n  result.b = isExpZero.b ? 1.0 : result.b;\n  result.a = isExpZero.a ? 1.0 : result.a;\n\n  vec4 isNaN = vec4(lessThan(a, vec4(0.0))) * vec4(lessThan(floor(b), b));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",t.shape,e.shape):new Pk("\nif(a < 0.0 && floor(b) < b){\n  return NAN;\n}\nif (b == 0.0) {\n  return 1.0;\n}\nreturn (round(mod(b, 2.0)) != 1) ?\n    pow(abs(a), b) : sign(a) * pow(abs(a), b);\n",t.shape,e.shape),s=Ot(t.dtype,e.dtype);return this.compileAndRun(n,[t,e],s)}ceil(t){if(this.shouldExecuteOnCPU([t])){const e=ek(this.texData.get(t.dataId).values,t.dtype);return this.makeOutput(t.shape,t.dtype,e)}if(H().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(t,bI,t.dtype);const e=new cI(t.shape,bI);return this.compileAndRun(e,[t])}floor(t){if(this.shouldExecuteOnCPU([t])){const e=rk(this.texData.get(t.dataId).values,t.dtype);return this.makeOutput(t.shape,t.dtype,e)}if(H().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(t,xI,t.dtype);const e=new cI(t.shape,xI);return this.compileAndRun(e,[t])}sign(t){const e=new cI(t.shape,"\n  if (isnan(x)) { return 0.0; }\n  return sign(x);\n");return this.compileAndRun(e,[t])}isNaN(t){const e=new cI(t.shape,"return float(isnan(x));");return this.compileAndRun(e,[t],"bool")}isInf(t){const e=new cI(t.shape,"return float(isinf(x));");return this.compileAndRun(e,[t],"bool")}isFinite(t){const e=new cI(t.shape,"return float(!isnan(x) && !isinf(x));");return this.compileAndRun(e,[t],"bool")}round(t){const e=new cI(t.shape,"\n  // OpenGL ES does not support round function.\n  // The algorithm is based on banker's rounding.\n  float base = floor(x);\n  if ((x - base) < 0.5) {\n    return floor(x);\n  } else if ((x - base) > 0.5) {\n    return ceil(x);\n  } else {\n    if (mod(base, 2.0) == 0.0) {\n      return base;\n    } else {\n      return base + 1.0;\n    }\n  }\n");return this.compileAndRun(e,[t])}exp(t){if(this.shouldExecuteOnCPU([t])){const e=nk(this.texData.get(t.dataId).values,t.dtype);return this.makeOutput(t.shape,t.dtype,e)}if(H().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(t,wI,t.dtype);const e=new cI(t.shape,wI);return this.compileAndRun(e,[t])}expm1(t){if(this.shouldExecuteOnCPU([t])){const e=sk(this.texData.get(t.dataId).values,t.dtype);return this.makeOutput(t.shape,t.dtype,e)}if(H().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(t,vI,t.dtype);const e=new cI(t.shape,vI);return this.compileAndRun(e,[t])}softmax(t,e){const n=x([e],t.shape),s=ha(t,n),r=fs(s.shape,n),a=pa(t,s.reshape(r)),i=this.exp(a),o=this.sum(i,n).reshape(r);return as(i,o)}log(t){if(this.shouldExecuteOnCPU([t])){const e=ak(this.texData.get(t.dataId).values,t.dtype);return this.makeOutput(t.shape,t.dtype,e)}if(H().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(t,"\n  vec4 result = log(x);\n  vec4 isNaN = vec4(lessThan(x, vec4(0.0)));\n  result.r = isNaN.r == 1.0 ? NAN : result.r;\n  result.g = isNaN.g == 1.0 ? NAN : result.g;\n  result.b = isNaN.b == 1.0 ? NAN : result.b;\n  result.a = isNaN.a == 1.0 ? NAN : result.a;\n\n  return result;\n",t.dtype);const e=new cI(t.shape,"if (x < 0.0) return NAN;\n  return log(x);");return this.compileAndRun(e,[t])}log1p(t){const e=new cI(t.shape,"return log(1.0 + x);");return this.compileAndRun(e,[t])}sqrt(t){const e=new cI(t.shape,"return sqrt(x);");return this.compileAndRun(e,[t])}rsqrt(t){if(this.shouldExecuteOnCPU([t])){const e=lk(this.texData.get(t.dataId).values,t.dtype);return this.makeOutput(t.shape,t.dtype,e)}const e=new cI(t.shape,"return inversesqrt(x);");return this.compileAndRun(e,[t])}reciprocal(t){const e=new cI(t.shape,"return 1.0 / x;");return this.compileAndRun(e,[t])}relu(t){let e;return e=H().getBool("WEBGL_PACK")?new SI(t.shape,NI):new cI(t.shape,dI),this.compileAndRun(e,[t])}relu6(t){let e;return e=H().getBool("WEBGL_PACK")?new SI(t.shape,II):new cI(t.shape,fI),this.compileAndRun(e,[t])}prelu(t,e){const n=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Vk(Wk,t.shape,e.shape):new Pk(Bk,t.shape,e.shape);return this.compileAndRun(n,[t,e])}elu(t){if(H().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(t,CI,t.dtype);const e=new cI(t.shape,mI);return this.compileAndRun(e,[t])}eluDer(t,e){const n=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Vk("\n  vec4 bGTEZero = vec4(greaterThanEqual(b, vec4(0.)));\n  return (bGTEZero * a) + ((vec4(1.0) - bGTEZero) * (a * (b + vec4(1.0))));\n",t.shape,e.shape):new Pk("return (b >= 1.0) ? a : a * (b + 1.0);",t.shape,e.shape);return this.compileAndRun(n,[t,e])}selu(t){const e=new cI(t.shape,gI);return this.compileAndRun(e,[t])}clip(t,e,n){let s;s=H().getBool("WEBGL_PACK_CLIP")?new Gk(t.shape):new Uk(t.shape);const r=s.getCustomSetupFunc(e,n);return this.compileAndRun(s,[t],null,r)}abs(t){if(this.shouldExecuteOnCPU([t])&&"complex64"!==t.dtype){const e=Qv(this.texData.get(t.dataId).values);return this.makeOutput(t.shape,t.dtype,e)}if(H().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(t,pI,t.dtype);const e=new cI(t.shape,pI);return this.compileAndRun(e,[t])}complexAbs(t){const e=this.texData.get(t.dataId),n=new Hk(t.shape),s=[this.makeComplexComponentTensorInfo(t,e.complexTensorInfos.real),this.makeComplexComponentTensorInfo(t,e.complexTensorInfos.imag)];return this.compileAndRun(n,s)}sigmoid(t){const e=new cI(t.shape,"return 1.0 / (1.0 + exp(-1.0 * x));");return this.compileAndRun(e,[t])}softplus(t){const e=new cI(t.shape,"\n  float epsilon = 1.1920928955078125e-7;\n  float threshold = log(epsilon) + 2.0;\n\n  bool too_large = x > -threshold;\n  bool too_small = x < threshold;\n\n  float result;\n  float exp_x = exp(x);\n\n  if (too_large){\n    result = x;\n  }\n  else if (too_small){\n    result = exp_x;\n  }\n  else{\n    result = log(exp_x + 1.0);\n  }\n  return result;\n");return this.compileAndRun(e,[t])}asin(t){const e=new cI(t.shape,"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return asin(x);\n");return this.compileAndRun(e,[t])}acos(t){const e=new cI(t.shape,"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return acos(x);\n");return this.compileAndRun(e,[t])}atan(t){const e=new cI(t.shape,"if (isnan(x)) return x;\n  return atan(x);\n");return this.compileAndRun(e,[t])}sinh(t){const e=new cI(t.shape,"\n  float e2x = exp(x);\n  return (e2x - 1.0 / e2x) / 2.0;\n");return this.compileAndRun(e,[t])}cosh(t){const e=new cI(t.shape,"\n  float e2x = exp(-x);\n  return (e2x + 1.0 / e2x) / 2.0;\n");return this.compileAndRun(e,[t])}tanh(t){const e=new cI(t.shape,"\n  float e2x = exp(-2.0 * abs(x));\n  return sign(x) * (1.0 - e2x) / (1.0 + e2x);\n");return this.compileAndRun(e,[t])}asinh(t){const e=new cI(t.shape,"if (isnan(x)) return x;return log(x + sqrt(x * x + 1.0));");return this.compileAndRun(e,[t])}acosh(t){const e=new cI(t.shape,"if (isnan(x)) return x;\n  if (x < 1.0) return NAN;\n  return log(x + sqrt(x * x - 1.0));");return this.compileAndRun(e,[t])}atanh(t){const e=new cI(t.shape,"if (isnan(x)) return x;\n  if ((x < -1.0) || (x > 1.0)) return NAN;\n  return (log(1.0 + x) - log(1.0 - x)) / 2.0;");return this.compileAndRun(e,[t])}erf(t){const e=new cI(t.shape,'\n  // Error function is calculated approximately with elementary function.\n  // See "Handbook of Mathematical Functions with Formulas,\n  // Graphs, and Mathematical Tables", Abramowitz and Stegun.\n  float p = 0.3275911;\n  float a1 = 0.254829592;\n  float a2 = -0.284496736;\n  float a3 = 1.421413741;\n  float a4 = -1.453152027;\n  float a5 = 1.061405429;\n\n  float sign = sign(x);\n  x = abs(x);\n  float t = 1.0 / (1.0 + p * x);\n  return sign * (1.0 - (((((a5*t + a4)*t) + a3)*t + a2)*t + a1)*t*exp(-x*x));\n');return this.compileAndRun(e,[t])}step(t,e){const n=new cI(t.shape,function(t=0){return`if (isnan(x)) return x;\n    return x > 0.0 ? 1.0 : float(${t});\n  `}(e));return this.compileAndRun(n,[t])}conv2dByMatMul(t,e,n,s,r,a){const i=t.shape,o=this.texData.get(t.dataId),u=n.inChannels,c=i[0]*i[1]*i[2],h=n.outChannels,p="channelsLast"===n.dataFormat,d=(1===c||1===h)&&u>1e3,f=i[2]%2!=0&&!!o.isPacked;if(d||!H().getBool("WEBGL_LAZILY_UNPACK")||!H().getBool("WEBGL_PACK_BINARY_OPERATIONS")||!f){const o=p?i[0]*i[1]*i[2]:i[0]*i[2]*i[3],l=on(t,[1,o,n.inChannels]),u=on(e,[1,n.inChannels,n.outChannels]),c=this.fusedBatchMatMul({a:l,b:u,transposeA:!1,transposeB:!1,bias:s,activation:r,preluActivationWeights:a});return on(c,n.outShape)}const m=p?i[0]*i[1]*(i[2]+1):i[0]*i[2]*(i[3]+1),g={dataId:t.dataId,shape:[1,m,n.inChannels],dtype:t.dtype},y=o.shape;o.shape=o.shape.slice(),o.shape[o.shape.length-2]++,l(Gv(o.shape,g.shape),()=>`packed reshape ${o.shape} to ${g.shape} isn't free`);const b=on(e,[1,n.inChannels,n.outChannels]),x=this.fusedBatchMatMul({a:g,b:b,transposeA:!1,transposeB:!1,bias:s,activation:r,preluActivationWeights:a}),w=this.texData.get(x.dataId);return l(w.isPacked,()=>"batchMatMul result is expected to be packed"),o.shape=y,w.shape=n.outShape,Xn().makeTensorFromDataId(x.dataId,n.outShape,x.dtype)}conv2dWithIm2Row(t,e,n,s,r,a){const{filterWidth:i,filterHeight:o,inChannels:l,outWidth:u,outHeight:c,dataFormat:h}=n,p="channelsLast"===h,d=i*o*l,f=c*u,m=[d,f],g=t.squeeze([0]),y=e.reshape([1,d,-1]),b=new $N(m,g.shape,n),x=this.compileAndRun(b,[g]).reshape([1,m[0],m[1]]),w=null!=s,v=null!=a,k=r?FI(r,!0):null,N=new ON(x.shape,y.shape,[1,f,n.outChannels],!0,!1,w,k,v),I=[x,y];s&&I.push(s),v&&I.push(a);const C=this.compileAndRun(N,I);return p?C.reshape([1,c,u,n.outChannels]):C.reshape([1,n.outChannels,c,u])}fusedConv2d({input:t,filter:e,convInfo:n,bias:s,activation:r,preluActivationWeights:a}){if(1===n.filterHeight&&1===n.filterWidth&&1===n.dilationHeight&&1===n.dilationWidth&&1===n.strideHeight&&1===n.strideWidth&&("SAME"===n.padInfo.type||"VALID"===n.padInfo.type))return this.conv2dByMatMul(t,e,n,s,r,a);if(H().getBool("WEBGL_CONV_IM2COL")&&1===t.shape[0])return this.conv2dWithIm2Row(t,e,n,s,r,a);const i=null!=s,o=null!=a,l=r?FI(r,!1):null,u=new Zk(n,i,l,o),c=[t,e];return s&&c.push(s),a&&c.push(a),this.compileAndRun(u,c)}conv2d(t,e,n){if(1===n.filterHeight&&1===n.filterWidth&&1===n.dilationHeight&&1===n.dilationWidth&&1===n.strideHeight&&1===n.strideWidth&&("SAME"===n.padInfo.type||"VALID"===n.padInfo.type))return this.conv2dByMatMul(t,e,n);if(H().getBool("WEBGL_CONV_IM2COL")&&1===t.shape[0])return this.conv2dWithIm2Row(t,e,n);const s=new Zk(n);return this.compileAndRun(s,[t,e])}conv2dDerInput(t,e,n){const s=new qk(n);return this.compileAndRun(s,[t,e])}conv2dDerFilter(t,e,n){const s=new jk(n);return this.compileAndRun(s,[t,e])}fusedDepthwiseConv2D({input:t,filter:e,convInfo:n,bias:s,activation:r,preluActivationWeights:a}){const i=H().getBool("WEBGL_PACK_DEPTHWISECONV")&&n.strideWidth<=2&&n.outChannels/n.inChannels==1,o=r?FI(r,i):null,l=[t,e],u=null!=s,c=null!=a;let h;return u&&l.push(s),c&&l.push(a),i?(h=new eN(n,u,o,c),this.compileAndRun(h,l)):(h=new tN(n,u,o,c),this.compileAndRun(h,l))}depthwiseConv2D(t,e,n){let s;return H().getBool("WEBGL_PACK_DEPTHWISECONV")&&n.strideWidth<=2&&n.outChannels/n.inChannels==1?(s=new eN(n),this.compileAndRun(s,[t,e])):(s=new tN(n),this.compileAndRun(s,[t,e]))}depthwiseConv2DDerInput(t,e,n){const s=new Jk(n);return this.compileAndRun(s,[t,e])}depthwiseConv2DDerFilter(t,e,n){const s=new Yk(n);return this.compileAndRun(s,[t,e])}conv3d(t,e,n){const s=new Qk(n);return this.compileAndRun(s,[t,e])}conv3dDerInput(t,e,n){const s=new Xk(n);return this.compileAndRun(s,[t,e])}conv3dDerFilter(t,e,n){const s=new Kk(n);return this.compileAndRun(s,[t,e])}unstack(t,e){const n=t.shape[e],s=new Array(t.rank-1);let r=0;for(let n=0;n<t.rank;n++)n!==e&&(s[r++]=t.shape[n]);const a=new Array(t.rank).fill(0),i=t.shape.slice();i[e]=1;const o=new Array(n);for(let n=0;n<o.length;n++)a[e]=n,o[n]=this.slice(t,a,i).reshape(s);return o}avgPool3d(t,e){const n=new VN(e,"avg",!1);return this.compileAndRun(n,[t],"float32")}avgPool3dBackprop(t,e,n){const s=new zk(n);return this.compileAndRun(s,[t],e.dtype)}maxPool3d(t,e){const n=new VN(e,"max",!1);return this.compileAndRun(n,[t],"float32")}maxPool3dBackprop(t,e,n,s){const r=new VN(s,"max",!0),a=this.compileAndRun(r,[e]),i=new FN(s),o=this.compileAndRun(i,[t,a],e.dtype);return a.dispose(),o}resizeBilinear(t,e,n,s){const r=H().getBool("WEBGL_PACK_IMAGE_OPERATIONS")?new qN(t.shape,e,n,s):new jN(t.shape,e,n,s);return this.compileAndRun(r,[t],"float32")}resizeBilinearBackprop(t,e,n){const s=new HN(t,e,n);return this.compileAndRun(s,[t])}resizeNearestNeighbor(t,e,n,s){const r=new XN(t.shape,e,n,s);return this.compileAndRun(r,[t])}resizeNearestNeighborBackprop(t,e,n){const s=new KN(t,e,n);return this.compileAndRun(s,[t])}multinomial(t,e,n,s){const r=e?t:Di(t),a=r.shape[0],i=r.shape[1],o=new MN(a,i,n),l=o.getCustomSetupFunc(s);return this.compileAndRun(o,[r],"int32",l)}oneHot(t,e,n,s){const r=new LN(t.size,e,n,s);return this.compileAndRun(r,[t])}diag(t){const e=new uN(t.size);return this.compileAndRun(e,[t])}cropAndResize(t,e,n,s,r,a){const i=new nN(t.shape,e.shape,s,r,a);return this.compileAndRun(i,[t,e,n],"float32")}depthToSpace(t,e,n){l(e>1,()=>"blockSize should be > 1 for depthToSpace, but was: "+e);const s=t.shape[0],r="NHWC"===n?t.shape[1]:t.shape[2],a="NHWC"===n?t.shape[2]:t.shape[3],i="NHWC"===n?t.shape[3]:t.shape[1],o=r*e,u=a*e,c=i/(e*e),h=new lN("NHWC"===n?[s,o,u,c]:[s,c,o,u],e,n);return this.compileAndRun(h,[t])}split(t,e,n){return $I(t,e,n)}scatterND(t,e,n){const{sliceRank:s,numUpdates:r,sliceSize:a,strides:i,outputSize:o}=vn(0,t,n),l=[o/a,a],u=t.reshape([r,s]),c=e.reshape([r,a]);if(0===o)return su(re([]),n);const h=Jr(0),p=new ZN(r,s,u.rank,c.rank,i,l);return this.compileAndRun(p,[c,u,h]).reshape(n)}sparseToDense(t,e,n,s){const{sliceRank:r,numUpdates:a,strides:i,outputSize:o}=vn(0,t,n),l=new ZN(a,r,t.rank,e.rank,i,[o,1],!1);return this.compileAndRun(l,[e,t,s]).reshape(n)}gatherND(t,e){const n=e.shape,s=n[n.length-1],[r,a,i,o]=yn(t,e),l=e.reshape([a,s]),u=t.reshape([t.size/i,i]),c=new gN(s,o,[a,i]);return this.compileAndRun(c,[u,l]).reshape(r)}fill(t,e,n){if("string"===(n=n||D(e))){const s=k(n,p(t));return s.fill(e),Xn().makeTensor(s,t,n,this)}{const s=new fN(t,e),r=s.getCustomSetupFunc(e);return this.compileAndRun(s,[],n,r)}}onesLike(t){if("string"===t.dtype)throw new Error("onesLike is not supported under string dtype");return this.fill(t.shape,1,t.dtype)}zerosLike(t){return this.fill(t.shape,"string"===t.dtype?"":0,t.dtype)}linspace(t,e,n){return ru(t,e,n)}makeTensorInfo(t,e,n){const s=this.write(n,t,e);return this.texData.get(s).usage=null,{dataId:s,shape:t,dtype:e}}makeOutput(t,e,n){const{dataId:s}=this.makeTensorInfo(t,e,n);return Xn().makeTensorFromDataId(s,t,e,this)}unpackTensor(t){const e=new TI(t.shape);return this.runWebGLProgram(e,[t],t.dtype)}packTensor(t){const e=new zN(t.shape);return this.runWebGLProgram(e,[t],t.dtype,null,!0)}packedReshape(t,e){const n=[Pv(t.shape),...Wv(t.shape)],s={dtype:t.dtype,shape:n,dataId:t.dataId},r=[Pv(e),...Wv(e)],a=new GN(r,n),i=this.runWebGLProgram(a,[s],t.dtype,null,!0);return{dataId:i.dataId,shape:e,dtype:i.dtype}}decode(t){const e=this.texData.get(t),{isPacked:n,shape:s,dtype:r}=e,a=Vv(s);let i;i=n?new oN(a):new iN(a);return{dtype:r,shape:s,dataId:this.runWebGLProgram(i,[{shape:a,dtype:r,dataId:t}],r,null,!0).dataId}}runWebGLProgram(t,e,n,s,r=!1){const a=this.makeTensorInfo(t.outputShape,n),i=this.texData.get(a.dataId);if(t.packedOutput&&(i.isPacked=!0),t.outPackingScheme===wv.DENSE){const e=Iv(t.outputShape);i.texShape=e.map(t=>2*t)}if(null!=t.outTexUsage&&(i.usage=t.outTexUsage),0===p(a.shape))return i.values=v(a.dtype,0),a;const o=[],l=e.map(e=>{if("complex64"===e.dtype)throw new Error("GPGPUProgram does not support complex64 input. For complex64 dtypes, please separate the program into real and imaginary parts.");let n=this.texData.get(e.dataId);if(null==n.texture){if(!t.packedInputs&&p(e.shape)<=H().getNumber("WEBGL_SIZE_UPLOAD_UNIFORM"))return{shape:e.shape,texData:null,isUniform:!0,uniformValues:n.values};t.packedInputs&&(n.isPacked=!0,n.shape=e.shape)}else if(!!n.isPacked!=!!t.packedInputs)e=n.isPacked?this.unpackTensor(e):this.packTensor(e),o.push(e),n=this.texData.get(e.dataId);else if(n.isPacked&&!Gv(n.shape,e.shape)){const t=e,s=e.shape;e.shape=n.shape,e=this.packedReshape(e,s),o.push(e),n=this.texData.get(e.dataId),t.shape=s}return this.uploadToGPU(e.dataId),{shape:e.shape,texData:n,isUniform:!1}});this.uploadToGPU(a.dataId);const u={shape:a.shape,texData:i,isUniform:!1},c=function(t,e,n){let s="";e.concat(n).forEach(t=>{const e=null!=t.texData&&null!=t.texData.slice&&t.texData.slice.flatOffset>0,n=t.isUniform?"uniform":t.texData.texShape;s+=`${t.shape}_${n}_${e}`});const r=t.userCode;let a=t.constructor.name;return a+="_"+s+"_"+r,a}(t,l,u),h=this.getAndSaveBinary(c,()=>function(t,e,n,s){const r=e.userCode,a=n.map((t,n)=>{const s={logicalShape:t.shape,texShape:t.isUniform?null:t.texData.texShape,isUniform:t.isUniform,isPacked:!t.isUniform&&t.texData.isPacked,flatOffset:null};return null!=t.texData&&null!=t.texData.slice&&t.texData.slice.flatOffset>0&&(s.flatOffset=t.texData.slice.flatOffset),{name:e.variableNames[n],shapeInfo:s}}),i=a.map(t=>t.shapeInfo),o={logicalShape:s.shape,texShape:s.texData.texShape,isUniform:!1,isPacked:s.texData.isPacked,flatOffset:null},l=Nk(a,o,r,e.packedInputs),u=t.createProgram(l);let c=null;const h=t.getUniformLocation(u,"NAN",!1);1===H().getNumber("WEBGL_VERSION")&&(c=t.getUniformLocation(u,"INFINITY",!1));const p={};for(let n=0;n<e.variableNames.length;n++){const s=e.variableNames[n],r=!1;p[s]=t.getUniformLocation(u,s,r),p["offset"+s]=t.getUniformLocation(u,"offset"+s,r)}return{program:e,source:l,webGLProgram:u,uniformLocations:p,inShapeInfos:i,outShapeInfo:o,infLoc:c,nanLoc:h}}(this.gpgpu,t,l,u)),d=null!=this.activeTimers;let f;if(d&&(f=this.startTimer()),function(t,e,n,s,r){EN(e.inShapeInfos,n),EN([e.outShapeInfo],[s]);const a=s.texData.texture,i=s.texData.texShape;s.texData.isPacked?t.setOutputPackedMatrixTexture(a,i[0],i[1]):t.setOutputMatrixTexture(a,i[0],i[1]),t.setProgram(e.webGLProgram),1===H().getNumber("WEBGL_VERSION")&&null!==e.infLoc&&t.gl.uniform1f(e.infLoc,1/0),null!==e.nanLoc&&t.gl.uniform1f(e.nanLoc,NaN),n.forEach((n,s)=>{const r=e.program.variableNames[s],a=e.uniformLocations[r],i=e.uniformLocations["offset"+r];if(null!=a)if(n.isUniform)if(p(n.shape)<2)t.gl.uniform1f(a,n.uniformValues[0]);else{let e=n.uniformValues;e instanceof Float32Array||(e=new Float32Array(e)),t.gl.uniform1fv(a,e)}else null!=n.texData.slice&&null!=i&&t.gl.uniform1i(i,n.texData.slice.flatOffset),t.setInputMatrixTexture(n.texData.texture,a,s)}),null!=r&&r(t,e.webGLProgram),t.executeProgram()}(this.gpgpu,h,l,u,s),o.forEach(t=>this.disposeIntermediateTensorInfo(t)),d&&(f=this.endTimer(f),this.activeTimers.push({name:t.constructor.name,query:this.getQueryTime(f)})),!H().getBool("WEBGL_LAZILY_UNPACK")&&i.isPacked&&!1===r){const t=this.unpackTensor(a);return this.disposeIntermediateTensorInfo(a),t}return a}compileAndRun(t,e,n,s,r=!1){n=n||e[0].dtype;const a=this.runWebGLProgram(t,e,n,s,r);return Xn().makeTensorFromDataId(a.dataId,a.shape,a.dtype)}getAndSaveBinary(t,e){return t in this.binaryCache||(this.binaryCache[t]=e()),this.binaryCache[t]}getTextureManager(){return this.textureManager}dispose(){if(!this.disposed){if(!H().getBool("IS_TEST")){Object.keys(this.binaryCache).forEach(t=>{this.gpgpu.deleteProgram(this.binaryCache[t].webGLProgram),delete this.binaryCache[t]})}this.textureManager.dispose(),null!=this.canvas&&"undefined"!=typeof HTMLCanvasElement&&this.canvas instanceof HTMLCanvasElement?this.canvas.remove():this.canvas=null,this.gpgpuCreatedLocally&&(this.gpgpu.program=null,this.gpgpu.dispose()),this.disposed=!0}}floatPrecision(){return null==this.floatPrecisionValue&&(this.floatPrecisionValue=Jn(()=>{if(!H().get("WEBGL_RENDER_FLOAT32_ENABLED")){const t=H().getBool("DEBUG");H().set("DEBUG",!1);const e=this.abs(Jr(1e-8)).dataSync()[0];if(H().set("DEBUG",t),e>0)return 32}return 16})),this.floatPrecisionValue}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}uploadToGPU(t){const e=this.texData.get(t),{shape:n,dtype:s,values:r,texture:a,usage:o,isPacked:l}=e;if(null!=a)return;const u=null!=this.activeTimers;let c;u&&(c=ht());let h=e.texShape;if(null==h&&(h=function(t,e=!1){let n=H().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(e&&(n*=2,1===(t=t.map((e,n)=>n>=t.length-2?i(t[n]):t[n])).length&&(t=[2,t[0]])),2!==t.length){const e=w(t);t=e.newShape}let s=p(t);if(t.length<=1&&s<=n)return[1,s];if(2===t.length&&t[0]<=n&&t[1]<=n)return t;if(3===t.length&&t[0]*t[1]<=n&&t[2]<=n)return[t[0]*t[1],t[2]];if(3===t.length&&t[0]<=n&&t[1]*t[2]<=n)return[t[0],t[1]*t[2]];if(4===t.length&&t[0]*t[1]*t[2]<=n&&t[3]<=n)return[t[0]*t[1]*t[2],t[3]];if(4===t.length&&t[0]<=n&&t[1]*t[2]*t[3]<=n)return[t[0],t[1]*t[2]*t[3]];if(e){const e=Pv(t);let n=2,r=2;return t.length&&([n,r]=Wv(t)),s=e*(n/2)*(r/2),m(s).map(t=>2*t)}return m(s)}(n,l),e.texShape=h),null!=r){const t=Vv(n);let a,i=h[1],o=h[0];const p=r instanceof Uint8Array;l?([i,o]=Cv(h[0],h[1]),a=new dN(t,[o,i],p)):a=new pN(t,[o,i],p);const d=this.makeTensorInfo([o,i],s);this.texData.get(d.dataId).usage=p?vv.PIXELS:vv.UPLOAD,this.gpgpu.uploadDenseMatrixToTexture(this.getTexture(d.dataId),i,o,r);const f=!0,m=this.runWebGLProgram(a,[d],s,null,f),g=this.texData.get(m.dataId);e.texture=g.texture,e.texShape=g.texShape,e.isPacked=g.isPacked,e.usage=g.usage,this.disposeIntermediateTensorInfo(d),this.texData.delete(m.dataId),e.values=null,u&&(this.uploadWaitMs+=ht()-c)}else{const t=this.acquireTexture(h,o,s,l);e.texture=t}}convertAndCacheOnCPU(t,e){const n=this.texData.get(t),{dtype:s}=n;return this.releaseGPUData(t),null!=e&&(n.values=function(t,e){if("float32"===e||"complex64"===e)return t;if("int32"===e||"bool"===e){const n="int32"===e?new Int32Array(t.length):new Uint8Array(t.length);for(let e=0;e<n.length;++e)n[e]=Math.round(t[e]);return n}throw new Error("Unknown dtype "+e)}(e,s)),n.values}acquireTexture(t,e,n,s){if(this.numBytesInGPU+=this.computeBytes(t,n),!this.warnedAboutMemory&&this.numBytesInGPU>1024*this.numMBBeforeWarning*1024){const t=(this.numBytesInGPU/1024/1024).toFixed(2);this.warnedAboutMemory=!0,console.warn(`High memory usage in GPU: ${t} MB, most likely due to a memory leak`)}return this.textureManager.acquireTexture(t,e,s)}computeBytes(t,e){return t[0]*t[1]*T(e)}tryRunOnCpuOrThrow(t,e){if(this.shouldExecuteOnCPU(t))try{return e()}catch(t){if(H().getBool("IS_TEST"))throw new Error("CPU forwarding failed")}return null}}Kt()&&es("webgl",()=>new OI,2);function MI(t){const{inputs:e,backend:n}=t,{x:s}=e;return n.incRef(s.dataId),{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}const LI={kernelName:"Identity",backendName:"webgl",kernelFunc:MI};function zI(t){const{inputs:e,backend:n}=t,{real:s,imag:r}=e,a=n.makeTensorInfo(s.shape,"complex64"),i=n.texData.get(a.dataId),o=MI({inputs:{x:s},backend:n});n.texData.get(o.dataId).complexParentRefCount++;const l=MI({inputs:{x:r},backend:n});return n.texData.get(l.dataId).complexParentRefCount++,i.complexTensorInfos={real:o,imag:l},a}const BI={kernelName:"Complex",backendName:"webgl",kernelFunc:zI};function PI(t){return({inputs:e,backend:n})=>{const{x:s}=e,r=n,a=new cI(s.shape,t);return r.runWebGLProgram(a,[s],s.dtype)}}function WI({opSnippet:t,packedOpSnippet:e,checkOutOfBounds:n=!1,supportsComplex:s=!1,cpuKernelImpl:r,dtype:a}){return({inputs:i,backend:o})=>{const{a:l,b:u}=i,c=o;if(s&&"complex64"===l.dtype){const e=c.texData.get(l.dataId),n=c.texData.get(u.dataId),[s,r]=[[e.complexTensorInfos.real,n.complexTensorInfos.real],[e.complexTensorInfos.imag,n.complexTensorInfos.imag]].map(e=>{const[n,s]=e,r={dataId:n.dataId,dtype:n.dtype,shape:l.shape},a={dataId:s.dataId,dtype:s.dtype,shape:u.shape},i=new Pk(t,l.shape,u.shape);return c.runWebGLProgram(i,[r,a],Ot(n.dtype,s.dtype))}),a=zI({inputs:{real:s,imag:r},backend:c});return c.disposeIntermediateTensorInfo(s),c.disposeIntermediateTensorInfo(r),a}const h=a||Ot(l.dtype,u.dtype);if(c.shouldExecuteOnCPU([l,u])&&null!=r){const t=c.texData.get(l.dataId),e=c.texData.get(u.dataId),[n,s]=r(l.shape,u.shape,t.values,e.values,h),a=c.makeTensorInfo(s,h);return c.texData.get(a.dataId).values=n,a}let p;return p=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&null!=e?new Vk(e,l.shape,u.shape,n):new Pk(t,l.shape,u.shape),c.runWebGLProgram(p,[l,u],h)}}const VI="return a + b;",UI=WI({opSnippet:VI,packedOpSnippet:VI,supportsComplex:!0,cpuKernelImpl:tk}),GI={kernelName:X,backendName:"webgl",kernelFunc:UI},HI={kernelName:"Atan2",backendName:"webgl",kernelFunc:WI({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return atan(a, b);\n",packedOpSnippet:"\n  vec4 result = atan(a, b);\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"})};const jI={kernelName:"AvgPool",backendName:"webgl",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r}=e;Jv(r,"avgPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:u}=s;l(Bs(i,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`);const c=$s(r.shape,a,i,1,o,u);if(1===c.filterWidth&&1===c.filterHeight&&d(c.inShape,c.outShape))return MI({inputs:{x:r},backend:n});const h=new WN(c,"avg",!1);return n.runWebGLProgram(h,[r],"float32")}};const qI={kernelName:"AvgPoolBackprop",backendName:"webgl",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{dy:r,input:a}=e,i=a;Jv([r,a],"avgPoolBackprop");const{filterSize:o,strides:l,pad:u}=s,c=$s(i.shape,o,l,1,u),h=new Lk(c);return n.runWebGLProgram(h,[r],i.dtype)}};class KI{constructor(t,e,n,s,r,a){this.outputShape=[],this.variableNames=["x","mean","variance"],Cr(t,e),Cr(t,n);let i="0.0";null!=s&&(Cr(t,s),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let o="1.0";null!=r&&(Cr(t,r),this.variableNames.push("scale"),o="getScaleAtOutCoords()"),this.outputShape=t,this.userCode=`\n      void main() {\n        float x = getXAtOutCoords();\n        float mean = getMeanAtOutCoords();\n        float variance = getVarianceAtOutCoords();\n        float offset = ${i};\n        float scale = ${o};\n        float inv = scale * inversesqrt(variance + float(${a}));\n        setOutput(dot(vec3(x, -mean, offset), vec3(inv, inv, 1)));\n      }\n    `}}class XI{constructor(t,e,n,s,r,a){this.packedInputs=!0,this.packedOutput=!0,this.variableNames=["x","mean","variance"],Cr(t,e),Cr(t,n);let i="vec4(0.0)";null!=s&&(Cr(t,s),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let o="vec4(1.0)";null!=r&&(Cr(t,r),this.variableNames.push("scale"),o="getScaleAtOutCoords()"),this.outputShape=t,this.userCode=`\n      void main() {\n        vec4 offset = ${i};\n        vec4 scale = ${o};\n\n        vec4 x = getXAtOutCoords();\n        vec4 mean = getMeanAtOutCoords();\n        vec4 variance = getVarianceAtOutCoords();\n\n        vec4 inv = scale * inversesqrt(variance + vec4(${a}));\n\n        setOutput((x - mean) * inv + offset);\n      }\n    `}}const YI={kernelName:"FusedBatchNorm",backendName:"webgl",kernelFunc:({inputs:t,backend:e,attrs:n})=>{const{x:s,mean:r,variance:a,offset:i,scale:o}=t;l(r.shape.length===a.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),l(null==i||r.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),l(null==o||r.shape.length===o.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks.");let{varianceEpsilon:u}=n;null==u&&(u=.001);const c=[s,r,a];let h=null;null!=i&&(h=i.shape,c.push(i));let p=null;null!=o&&(p=o.shape,c.push(o));const d=H().getBool("WEBGL_PACK_NORMALIZATION")?new XI(s.shape,r.shape,a.shape,h,p,u):new KI(s.shape,r.shape,a.shape,h,p,u);return e.runWebGLProgram(d,c,c[0].dtype)}},JI=WI({opSnippet:"return float(a != b);",dtype:"bool"}),ZI={kernelName:"NotEqual",backendName:"webgl",kernelFunc:JI};function QI(t){const{inputs:e,backend:n}=t,{input:s}=e;return MI({inputs:{x:n.texData.get(s.dataId).complexTensorInfos.real},backend:n})}const tC={kernelName:"Real",backendName:"webgl",kernelFunc:QI};const eC={kernelName:"Cast",backendName:"webgl",kernelFunc:function t(e){const{inputs:n,backend:s,attrs:r}=e,{x:a}=n,{dtype:i}=r;if("complex64"===i){if("complex64"===a.dtype)return MI({inputs:{x:a},backend:s});const e=Na(a.shape),n=t({inputs:{x:a},backend:s,attrs:{dtype:"float32"}}),r=zI({inputs:{real:n,imag:e},backend:s});return e.dispose(),s.disposeIntermediateTensorInfo(n),r}if("complex64"===a.dtype){const e=QI({inputs:{input:a},backend:s}),n=t({inputs:{x:e},backend:s,attrs:{dtype:i}});return s.disposeIntermediateTensorInfo(e),n}if(!C(a.dtype,i)){const t=MI({inputs:{x:a},backend:s});return{dataId:t.dataId,shape:t.shape,dtype:i}}if("int32"===i)return function(t,e){const n=new cI(t.shape,"return float(int(x));"),s=e.runWebGLProgram(n,[t],"int32");return{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}(a,s);if("bool"===i){const t=s.makeTensorInfo([],"bool",v("bool",1)),e=JI({inputs:{a:a,b:t},backend:s});return s.disposeIntermediateTensorInfo(t),e}throw new Error(`Error in Cast: failed to cast ${a.dtype} to ${i}`)}};class nC{constructor(t){this.outputShape=[],this.outputShape=Gs(t,1),this.variableNames=t.map((t,e)=>"T"+e);const e=new Array(t.length-1);e[0]=t[0][1];for(let n=1;n<e.length;n++)e[n]=e[n-1]+t[n][1];const n=[`if (yC < ${e[0]}) setOutput(getT0(yR, yC));`];for(let t=1;t<e.length;t++){const s=e[t-1];n.push(`else if (yC < ${e[t]}) setOutput(getT${t}(yR, yC-${s}));`)}const s=e.length,r=e[e.length-1];n.push(`else setOutput(getT${s}(yR, yC-${r}));`),this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int yR = coords.x;\n        int yC = coords.y;\n\n        ${n.join("\n        ")}\n      }\n    `}}class sC{constructor(t,e){this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[],this.outputShape=Gs(t,e);const n=this.outputShape,s=n.length,r=_k(s),a=yk("coords",s),i=["x","y","z","w","u","v"].slice(0,s);this.variableNames=t.map((t,e)=>"T"+e);const o=new Array(t.length-1);o[0]=t[0][e];for(let n=1;n<o.length;n++)o[n]=o[n-1]+t[n][e];const l=i[e],u=i.slice(-2),c=i.join();let h=`if (${l} < ${o[0]}) {\n        return getChannel(\n            getT0(${c}), vec2(${u.join()}));\n        }`;for(let t=1;t<o.length;t++){const e=o[t-1];h+=`\n        if (${l} < ${o[t]}  && ${l} >= ${o[t-1]}) {\n          return getChannel(\n            getT${t}(${rC(i,l,e)}),\n            vec2(${rC(u,l,e)}));\n        }`}const p=o.length,d=o[o.length-1];h+=`\n        return getChannel(\n          getT${p}(${rC(i,l,d)}),\n          vec2(${rC(u,l,d)}));`,this.userCode=`\n      float getValue(${i.map(t=>"int "+t)}) {\n        ${h}\n      }\n\n      void main() {\n        ${r} coords = getOutputCoords();\n        vec4 result = vec4(getValue(${a}), 0., 0., 0.);\n\n        ${a[s-1]} = ${a[s-1]} + 1;\n        if (${a[s-1]} < ${n[s-1]}) {\n          result.g = getValue(${a});\n        }\n\n        ${a[s-2]} = ${a[s-2]} + 1;\n        if (${a[s-2]} < ${n[s-2]}) {\n          result.a = getValue(${a});\n        }\n\n        ${a[s-1]} = ${a[s-1]} - 1;\n        if (${a[s-2]} < ${n[s-2]} &&\n            ${a[s-1]} < ${n[s-1]}) {\n          result.b = getValue(${a});\n        }\n        setOutput(result);\n      }\n    `}}function rC(t,e,n){const s=t.indexOf(e);return t.map((t,e)=>e===s?`${t} - ${n}`:t).join()}function aC(t){const{inputs:e,backend:n}=t,{input:s}=e;return MI({inputs:{x:n.texData.get(s.dataId).complexTensorInfos.imag},backend:n})}const iC={kernelName:"Imag",backendName:"webgl",kernelFunc:aC};function oC(t){const{inputs:e,backend:n,attrs:s}=t,{x:r}=e,{shape:a}=s,i=n,o=p(r.shape),u=b(a,o),c=p(u);l(o===c,()=>`The new shape (${u}) has ${c} elements and the old shape (${r.shape}) has ${o} elements. The new shape and old shape must have the same number of elements.`);const h=i.texData.get(r.dataId);return!h.isPacked||Gv(r.shape,u)||null!==h.texture&&Gv(h.shape,u)?(i.incRef(r.dataId),{dataId:r.dataId,shape:u,dtype:r.dtype}):function(t,e,n){const s=[Pv(t.shape),...Wv(t.shape)],r={dtype:t.dtype,shape:s,dataId:t.dataId},a=[Pv(e),...Wv(e)],i=new GN(a,s),o=n.runWebGLProgram(i,[r],t.dtype,null,!0);return{dataId:o.dataId,shape:e,dtype:o.dtype}}(r,u,i)}const lC={kernelName:"Reshape",backendName:"webgl",kernelFunc:oC};const uC={kernelName:"Concat",backendName:"webgl",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{axis:r}=s,a=x(r,e[0].shape)[0],i=Gs(e.map(t=>t.shape),a);if(0===p(i))return n.makeTensorInfo(i,e[0].dtype,[]);const o=e.filter(t=>p(t.shape)>0);return 1===o.length?o[0]:(Us(o.map(t=>t.shape),a),function t(e,n,s){const r=e[0].dtype;if("complex64"===r){const r=e.map(t=>QI({inputs:{input:t},backend:s})),a=e.map(t=>aC({inputs:{input:t},backend:s})),i=t(r,n,s),o=t(a,n,s),l=zI({inputs:{real:i,imag:o},backend:s});return r.forEach(t=>s.disposeIntermediateTensorInfo(t)),a.forEach(t=>s.disposeIntermediateTensorInfo(t)),s.disposeIntermediateTensorInfo(i),s.disposeIntermediateTensorInfo(o),l}if(e.length>H().getNumber("WEBGL_MAX_TEXTURES_IN_SHADER")){const r=Math.floor(e.length/2),a=t(e.slice(0,r),n,s),i=t(e.slice(r),n,s),o=t([a,i],n,s);return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}if(H().getBool("WEBGL_PACK_ARRAY_OPERATIONS")&&e[0].shape.length>1){const t=new sC(e.map(t=>t.shape),n);return s.runWebGLProgram(t,e,r)}const a=Gs(e.map(t=>t.shape),n),i=e.map(t=>oC({inputs:{x:t},attrs:{shape:[-1,p(t.shape.slice(n))]},backend:s})),o=new nC(i.map(t=>t.shape)),l=s.runWebGLProgram(o,i,r);i.forEach(t=>s.disposeIntermediateTensorInfo(t));const u=oC({inputs:{x:l},attrs:{shape:a},backend:s});return s.disposeIntermediateTensorInfo(l),u}(o,a,n))}},cC=PI("if (isnan(x)) return x;\n  return cos(x);\n"),hC={kernelName:Y,backendName:"webgl",kernelFunc:cC},pC=WI({opSnippet:"\nif (a == b) {\n  return 1.0;\n};\nreturn a / b;",packedOpSnippet:"\n  // vec4 one = vec4(equal(a, b));\n  // return one + (vec4(1.0) - one) * a / b;\n  vec4 result = a / b;\n  if(a.x == b.x) {\n    result.x = 1.;\n  }\n  if(a.y == b.y) {\n    result.y = 1.;\n  }\n  if(a.z == b.z) {\n    result.z = 1.;\n  }\n  if(a.w == b.w) {\n    result.w = 1.;\n  }\n\n  return result;\n",checkOutOfBounds:!0}),dC={kernelName:J,backendName:"webgl",kernelFunc:pC};class fC{constructor(t,e,n){this.variableNames=["real","imag"];const s=e[1];this.outputShape=e;const r=n?"2.0 * "+Math.PI:"-2.0 * "+Math.PI,a=n?s+".0":"1.0";let i;if("real"===t)i="return real * expR - imag * expI;";else{if("imag"!==t)throw new Error(`FFT component must be either "real" or "imag", got ${t}.`);i="return real * expI + imag * expR;"}this.userCode=`\n      const float exponentMultiplier = ${r};\n\n      float unaryOpComplex(float real, float expR, float imag, float expI) {\n        ${i}\n      }\n\n      float mulMatDFT(int batch, int index) {\n        float indexRatio = float(index) / float(${s});\n        float exponentMultiplierTimesIndexRatio =\n            exponentMultiplier * indexRatio;\n\n        float result = 0.0;\n\n        for (int i = 0; i < ${s}; i++) {\n          // x = (-2|2 * PI / N) * index * i;\n          float x = exponentMultiplierTimesIndexRatio * float(i);\n          float expR = cos(x);\n          float expI = sin(x);\n          float real = getReal(batch, i);\n          float imag = getImag(batch, i);\n\n          result +=\n              unaryOpComplex(real, expR, imag, expI) / ${a};\n        }\n\n        return result;\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        setOutput(mulMatDFT(coords[0], coords[1]));\n      }\n    `}}function mC(t,e,n){const s=n.texData.get(t.dataId),r=p(t.shape),a=t.shape[t.shape.length-1],i=oC({inputs:{x:t},backend:n,attrs:{shape:[r/a,a]}}).shape,o=new fC("real",i,e),l=new fC("imag",i,e),u=[{dataId:s.complexTensorInfos.real.dataId,dtype:s.complexTensorInfos.real.dtype,shape:i},{dataId:s.complexTensorInfos.imag.dataId,dtype:s.complexTensorInfos.imag.dtype,shape:i}],c=n.runWebGLProgram(o,u,"float32"),h=n.runWebGLProgram(l,u,"float32"),d=zI({inputs:{real:c,imag:h},backend:n});n.disposeIntermediateTensorInfo(c),n.disposeIntermediateTensorInfo(h);const f=oC({inputs:{x:d},backend:n,attrs:{shape:t.shape}});return n.disposeIntermediateTensorInfo(f),f}const gC={kernelName:"FFT",backendName:"webgl",kernelFunc:function(t){const{inputs:e,backend:n}=t,{input:s}=e;return mC(s,!1,n)}};class yC{constructor(t){this.variableNames=["Image"],this.outputShape=[];const e=t[2];this.outputShape=t,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n\n          int coordX = ${e} - x;\n          float outputValue;\n          if(coordX >= 0 && coordX < ${e}) {\n            outputValue = getImage(coords[0], coords[1], coordX, coords[3]);\n          } else {\n            outputValue = getImage(coords[0], coords[1], coords[2], coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const bC={kernelName:"FlipLeftRight",backendName:"webgl",kernelFunc:({inputs:t,backend:e})=>{const{image:n}=t,s=e,r=new yC(n.shape);return s.runWebGLProgram(r,[n],n.dtype)}};class xC{constructor(t){this.variableNames=["A"];const e=bk(),[n,s]=t;this.outputShape=t,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n        vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${s}.0, ${n}.0);\n\n        vec4 values = ${e.texture2D}(A, uv);\n        float value;\n        if (depth == 0) {\n          value = values.r;\n        } else if (depth == 1) {\n          value = values.g;\n        } else if (depth == 2) {\n          value = values.b;\n        } else if (depth == 3) {\n          value = values.a;\n        }\n\n        setOutput(floor(value * 255.0 + 0.5));\n      }\n    `}}class wC{constructor(t){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const e=bk(),[n,s]=t;this.outputShape=t,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n\n        vec4 result = vec4(0.);\n\n        for(int row=0; row<=1; row++) {\n          for(int col=0; col<=1; col++) {\n            texC = coords[1] + row;\n            depth = coords[2] + col;\n\n            vec2 uv = (vec2(texC, texR) + halfCR) /\n                       vec2(${s}.0, ${n}.0);\n            vec4 values = ${e.texture2D}(A, uv);\n            float value;\n            if (depth == 0) {\n              value = values.r;\n            } else if (depth == 1) {\n              value = values.g;\n            } else if (depth == 2) {\n              value = values.b;\n            } else if (depth == 3) {\n              value = values.a;\n            }\n\n            result[row * 2 + col] = floor(value * 255.0 + 0.5);\n          }\n        }\n\n        ${e.output} = result;\n      }\n    `}}const vC={kernelName:"FromPixels",backendName:"webgl",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t;let{pixels:r}=e;const{numChannels:a}=s,i="undefined"!=typeof HTMLVideoElement&&r instanceof HTMLVideoElement,o="undefined"!=typeof HTMLImageElement&&r instanceof HTMLImageElement,[l,u]=i?[r.videoWidth,r.videoHeight]:[r.width,r.height],c=[u,l],h=[u,l,a];(o||i)&&(null==kC&&(kC=document.createElement("canvas").getContext("2d")),kC.canvas.width=l,kC.canvas.height=u,kC.drawImage(r,0,0,l,u),r=kC.canvas);const p=n.makeTensorInfo(c,"int32");n.texData.get(p.dataId).usage=vv.PIXELS,n.gpgpu.uploadPixelDataToTexture(n.getTexture(p.dataId),r);const d=H().getBool("WEBGL_PACK")?new wC(h):new xC(h),f=n.runWebGLProgram(d,[p],"int32");return n.disposeData(p.dataId),f}};let kC;const NC={kernelName:"IFFT",backendName:"webgl",kernelFunc:function(t){const{inputs:e,backend:n}=t,{input:s}=e;return mC(s,!0,n)}};class IC{constructor(t,e){this.variableNames=["x"];const{windowSize:n,batchSize:s,inSize:r,outSize:a}=t;this.outputShape=[s,a];const i=4*Math.floor(n/4),o=n%4;let l="sumValue += dot(values, ones);";if(null!=e){const t=1/e;l=`sumValue += dot(values * ${f(t)?t.toPrecision(2):t}, ones);`}let u="";r%n>0&&(u=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return 0.0;\n        }\n      `),this.userCode=`\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${u}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${i}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${l}\n        }\n\n        int inIdx = inOffset + ${i};\n        if (${1===o}) {\n          vec4 values = vec4(getValue(batch, inIdx), 0.0, 0.0, 0.0);\n\n          ${l}\n        } else if (${2===o}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1), 0.0, 0.0);\n\n          ${l}\n        } else if (${3===o}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2), 0.0);\n\n          ${l}\n        }\n        setOutput(sumValue);\n      }\n    `}}function CC(t,e,n,s){const r=function(t){const e=[];for(;0===e.length||1!==e[e.length-1].outSize;){const n=e.length?e[e.length-1].outSize:t[1],s=Pr(n);e.push({inSize:n,windowSize:s,outSize:Math.ceil(n/s)})}return e}(t.shape);let a=t;for(let i=0;i<r.length;i++){const{inSize:o,windowSize:l,outSize:u}=r[i];let c,h;c="mean"===n?0===i?new IC({windowSize:l,inSize:o,batchSize:t.shape[0],outSize:u},o):new IC({windowSize:l,inSize:o,batchSize:t.shape[0],outSize:u}):new UN({windowSize:l,inSize:o,batchSize:t.shape[0],outSize:u},n),h=a,a=s.runWebGLProgram(c,[a],e),h.dataId!==t.dataId&&s.disposeIntermediateTensorInfo(h)}return a}class SC{constructor(t,e){this.variableNames=["A"];const n=new Array(t.length);for(let s=0;s<n.length;s++)n[s]=t[e[s]];this.outputShape=n,this.rank=n.length;const s=_k(this.rank),r=function(t){const e=t.length;if(e>6)throw Error(`Transpose for rank ${e} is not yet supported`);const n=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u","resRC.v"],s=new Array(e);for(let e=0;e<t.length;e++)s[t[e]]=n[e];return s.join()}(e);this.userCode=`\n    void main() {\n      ${s} resRC = getOutputCoords();\n      setOutput(getA(${r}));\n    }\n    `}}class TC{constructor(t,e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0;const n=new Array(t.length);for(let s=0;s<n.length;s++)n[s]=t[e[s]];if(this.outputShape=n,this.rank=n.length,this.rank>6)throw Error(`Packed transpose for rank ${this.rank} is not yet supported.`);const s=_k(this.rank),r=gk("rc",this.rank),a=new Array(this.rank);for(let t=0;t<e.length;t++)a[e[t]]=r[t];const i=`vec2(${a.slice(-2).join()})`,o=`++${r[this.rank-1]} < ${n[this.rank-1]}`,l=`getChannel(getA(${a.join()}), ${i})`;this.userCode=`\n    void main() {\n      ${s} rc = getOutputCoords();\n      vec4 result = vec4(0.);\n      result[0] = ${l};\n      if(${o}) {\n        result[1] = ${l};\n      }\n      --${r[this.rank-1]};\n      if(++${r[this.rank-2]} < ${n[this.rank-2]}) {\n        result[2] = ${l};\n        if(${o}) {\n          result[3] = ${l};\n        }\n      }\n      setOutput(result);\n    }\n    `}}function EC(t,e,n){const s=H().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new TC(t.shape,e):new SC(t.shape,e);return n.runWebGLProgram(s,[t],t.dtype)}const $C={kernelName:"Max",backendName:"webgl",kernelFunc:({inputs:t,attrs:e,backend:n})=>{const{x:s}=t,{reductionIndices:r,keepDims:a}=e,i=n,o=s.shape.length,l=x(r,s.shape);let u=l;const c=gs(u,o),h=null!=c,d=i.shouldExecuteOnCPU([s]);let f=s;if(h){if(d){const t=i.texData.get(f.dataId).values,e=new Array(o);for(let t=0;t<e.length;t++)e[t]=s.shape[c[t]];const n=hk(t,s.shape,s.dtype,c,e);f=i.makeTensorInfo(e,s.dtype),i.texData.get(f.dataId).values=n}else f=EC(s,c,i);u=bs(u.length,o)}ms("max",u,o);const[m,g]=ds(f.shape,u);let y,b=m;if(a&&(b=fs(m,l)),d){const t=i.texData.get(f.dataId).values,e=ik(t,p(g),b,s.dtype);y=i.makeTensorInfo(b,s.dtype),i.texData.get(y.dataId).values=e}else y=function(t,e,n,s){const r=p(e),a=oC({inputs:{x:t},attrs:{shape:[p(t.shape)/r,r]},backend:s}),i=CC(a,t.dtype,"max",s),o=oC({inputs:{x:i},attrs:{shape:n},backend:s});return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}(f,g,b,i);return h&&i.disposeIntermediateTensorInfo(f),y}};const AC={kernelName:"MaxPool",backendName:"webgl",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{x:r}=e;Jv(r,"maxPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:u}=s;l(Bs(i,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`);const c=$s(r.shape,a,i,1,o,u);if(1===c.filterWidth&&1===c.filterHeight&&d(c.inShape,c.outShape))return MI({inputs:{x:r},backend:n});const h=new WN(c,"max",!1);return n.runWebGLProgram(h,[r],r.dtype)}};const RC={kernelName:"MaxPoolBackprop",backendName:"webgl",kernelFunc:function(t){const{inputs:e,backend:n,attrs:s}=t,{dy:r,input:a,output:i}=e,o=a;Jv([a,i],"maxPoolBackprop");const{filterSize:l,strides:u,pad:c,dimRoundingMode:h}=s,p=$s(o.shape,l,u,1,c,h),d=new WN(p,"max",!0),f=n.runWebGLProgram(d,[o],o.dtype),m=new _N(p),g=n.runWebGLProgram(m,[r,f],o.dtype);return n.disposeIntermediateTensorInfo(f),g}};const DC={kernelName:"MaxPoolWithArgmax",backendName:"webgl",kernelFunc:({inputs:t,attrs:e,backend:n})=>{const{x:s}=t,{filterSize:r,strides:a,pad:i,includeBatchInIndex:o}=e,u=n;l(4===s.shape.length,()=>`Error in maxPool: input must be rank 4 but got rank ${s.shape.length}.`);const c=[1,1];l(Bs(a,c),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${a} and dilations '${c}'`);const h=$s(s.shape,r,a,c,i),[p,d]=function(t,e,n,s){let r=new WN(n,"max",!1);const a=s.runWebGLProgram(r,[t],"float32");return r=new WN(n,"max",!0,!0,e),[a,s.runWebGLProgram(r,[t],"float32")]}(s,o,h,u);return[p,d]}};const _C={kernelName:"Mean",backendName:"webgl",kernelFunc:({inputs:t,attrs:e,backend:n})=>{const{x:s}=t,{keepDims:r,axis:a}=e,i=n,o=s.shape.length,l=x(a,s.shape);let u=l;const c=gs(u,o),h=null!=c,d=i.shouldExecuteOnCPU([s]),f=[];let m=s;if(h){if(d){const t=i.texData.get(m.dataId).values,e=new Array(o);for(let t=0;t<e.length;t++)e[t]=s.shape[c[t]];const n=hk(t,s.shape,s.dtype,c,e);m=i.makeTensorInfo(e,s.dtype),i.texData.get(m.dataId).values=n}else m=EC(s,c,i);f.push(m),u=bs(u.length,o)}ms("sum",u,o);const[g,y]=ds(m.shape,u);let b=g;r&&(b=fs(g,l));const w=function(t,e,n,s){const r=p(e),a=oC({inputs:{x:t},attrs:{shape:[p(t.shape)/r,r]},backend:s}),i=CC(a,"float32","mean",s),o=oC({inputs:{x:i},attrs:{shape:n},backend:s});return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}(m,y,b,i);for(const t of f)i.disposeIntermediateTensorInfo(t);return w}};class FC{constructor(t,e,n){this.variableNames=["x"],this.outputShape=e.map((e,n)=>e[0]+t[n]+e[1]);const s=t.length,r=_k(s),a=e.map(t=>t[0]).join(","),i=e.map((e,n)=>e[0]+t[n]).join(","),o=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,s),l="reflect"===n?0:1;this.userCode=1!==s?`\n      ${r} start = ${r}(${a});\n      ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outC = getOutputCoords();\n        for (int i = 0; i < ${s}; i++) {\n          if (outC[i] < start[i]) {\n            outC[i] = start[i] * 2 - outC[i] - ${l};\n          } else if(outC[i] >= end[i]) {\n            outC[i] = (end[i] - 1) * 2 - outC[i] + ${l};\n          }\n        }\n        ${r} coords = outC - start;\n        setOutput(getX(${o}));\n      }\n    `:`\n        int start = ${a};\n        int end = ${i};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start) {\n            outC = start * 2 - outC - ${l};\n          } else if(outC >= end) {\n            outC = (end - 1) * 2 - outC + ${l};\n          }\n          setOutput(getX(outC - start));\n        }\n      `}}class OC{constructor(t,e,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e.map((e,n)=>e[0]+t[n]+e[1]);const s=t.length,r=_k(s),a=e.map(t=>t[0]).join(","),i=e.map((e,n)=>e[0]+t[n]).join(","),o=yk("rc",s),l=yk("source",s),u=`${o[s-1]} < ${this.outputShape[s-1]}`,c=1===s?"source":`vec2(${l.slice(-2).join()})`,h="reflect"===n?0:1;let p="";if(1===s){const t=`\n        ${r} source = rc;\n        if (source < start) {\n          source = start * 2 - source - ${h};\n        } else if (source >= end) {\n          source = (end - 1) * 2 - source + ${h};\n        }\n        source -= start;\n      `;p=`\n        ${r} rc = outputLoc;\n        ${t}\n        result[0] = getChannel(getX(${l.join()}), ${c});\n        ${o[s-1]} += 1;\n        if(${u}) {\n          ${t}\n          result[1] = getChannel(getX(${l.join()}), ${c});\n        }\n      `}else{const t=`\n        ${r} source = rc;\n        ${r} lt = ${r}(lessThan(source, start));\n        ${r} gte = ${r}(greaterThanEqual(source, end));\n        ${r} orig = 1 - (lt + gte);\n        source = orig * source +\n                lt * (start * 2 - source - ${h}) +\n                gte * ((end - 1) * 2 - source + ${h});\n        source -= start;\n      `;p=`\n        ${r} rc = outputLoc;\n        ${t}\n        result[0] = getChannel(getX(${l.join()}), ${c});\n        ${o[s-1]} += 1;\n        if(${u}) {\n          ${t}\n          result[1] = getChannel(getX(${l.join()}), ${c});\n        }\n        rc = outputLoc;\n        ${o[s-2]} += 1;\n        if(${o[s-2]} < ${this.outputShape[s-2]}) {\n          ${t}\n          result[2] = getChannel(getX(${l.join()}), ${c});\n          ${o[s-1]} += 1;\n          if(${u}) {\n            ${t}\n            result[3] = getChannel(getX(${l.join()}), ${c});\n          }\n        }\n      `}this.userCode=`\n      const ${r} start = ${r}(${a});\n      const ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${p}\n        setOutput(result);\n      }\n    `}}const MC={kernelName:"MirrorPad",backendName:"webgl",kernelFunc:({inputs:t,backend:e,attrs:n})=>{const{x:s}=t,{paddings:r,mode:a}=n,i=H().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new OC(s.shape,r,a):new FC(s.shape,r,a);return e.runWebGLProgram(i,[s],s.dtype)}},LC="return areal * breal - aimag * bimag;",zC="return areal * bimag + aimag * breal;";class BC{constructor(t,e,n){this.variableNames=["AReal","AImag","BReal","BImag"],this.outputShape=Cr(e,n),this.userCode=`\n      float binaryOpComplex(\n          float areal, float aimag, float breal, float bimag) {\n        ${t}\n      }\n\n      void main() {\n        float areal = getARealAtOutCoords();\n        float aimag = getAImagAtOutCoords();\n        float breal = getBRealAtOutCoords();\n        float bimag = getBImagAtOutCoords();\n        setOutput(binaryOpComplex(areal, aimag, breal, bimag));\n      }\n    `}}const PC="return a * b;";const WC={kernelName:"Multiply",backendName:"webgl",kernelFunc:function(t){const{inputs:e,backend:n}=t,{a:s,b:r}=e,a=Ot(s.dtype,r.dtype);if("complex64"===s.dtype){const t=n.texData.get(s.dataId),e=n.texData.get(r.dataId),a=new BC(LC,s.shape,r.shape),i=new BC(zC,s.shape,r.shape),o=[{dataId:t.complexTensorInfos.real.dataId,dtype:t.complexTensorInfos.real.dtype,shape:s.shape},{dataId:t.complexTensorInfos.imag.dataId,dtype:t.complexTensorInfos.imag.dtype,shape:s.shape},{dataId:e.complexTensorInfos.real.dataId,dtype:e.complexTensorInfos.real.dtype,shape:r.shape},{dataId:e.complexTensorInfos.imag.dataId,dtype:e.complexTensorInfos.imag.dtype,shape:r.shape}],l=n.runWebGLProgram(a,o,"float32"),u=n.runWebGLProgram(i,o,"float32"),c=zI({inputs:{real:l,imag:u},backend:n});return n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(u),c}if(n.shouldExecuteOnCPU([s,r])){const t=n.texData.get(s.dataId),e=n.texData.get(r.dataId),[i,o]=ok(s.shape,r.shape,t.values,e.values,a),l=n.makeTensorInfo(o,a);return n.texData.get(l.dataId).values=i,l}let i;return i=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Vk(PC,s.shape,r.shape):new Pk(PC,s.shape,r.shape),n.runWebGLProgram(i,[s,r],a)}},VC={kernelName:"NonMaxSuppressionV3",backendName:"webgl",kernelFunc:({inputs:t,backend:e,attrs:n})=>{Kl("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{boxes:s,scores:r}=t,{maxOutputSize:a,iouThreshold:i,scoreThreshold:o}=n,l=e;return Yo(l.readSync(s.dataId),l.readSync(r.dataId),a,i,o)}},UC=Jo,GC={kernelName:"NonMaxSuppressionV4",backendName:"webgl",kernelFunc:({inputs:t,backend:e,attrs:n})=>{Kl("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{boxes:s,scores:r}=t,{maxOutputSize:a,iouThreshold:i,scoreThreshold:o,padToMaxOutputSize:l}=n,u=e,c=u.readSync(s.dataId),h=u.readSync(r.dataId),{selectedIndices:p,validOutputs:d}=UC(c,h,a,i,o,l);return[p,d]}},HC=Zo,jC={kernelName:"NonMaxSuppressionV5",backendName:"webgl",kernelFunc:({inputs:t,backend:e,attrs:n})=>{Kl("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{boxes:s,scores:r}=t,{maxOutputSize:a,iouThreshold:i,scoreThreshold:o,softNmsSigma:l}=n,u=e,c=u.readSync(s.dataId),h=u.readSync(r.dataId),p=a,d=i,f=o,m=l,{selectedIndices:g,selectedScores:y}=HC(c,h,p,d,f,m);return[g,y]}};class qC{constructor(t,e,n,s){this.variableNames=["Image"],this.outputShape=[];const r=t[1],a=t[2],i=Math.sin(e).toFixed(3),o=Math.cos(e).toFixed(3);this.outputShape=t;const[l,u]=Wl(s,r,a),c=l.toFixed(3),h=u.toFixed(3);let p="";p="number"==typeof n?`float outputValue = ${n.toFixed(2)};`:`\n        vec3 fill = vec3(${n.join(",")});\n        float outputValue = fill[coords[3]];`,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n          int y = coords[1];\n          float coordXFloat = (float(x) - ${c}) * ${o} - (float(y) - ${h}) * ${i};\n          float coordYFloat = (float(x) - ${c}) * ${i} + (float(y) - ${h}) * ${o};\n          int coordX = int(round(coordXFloat + ${c}));\n          int coordY = int(round(coordYFloat + ${h}));\n          ${p}\n          if(coordX >= 0 && coordX < ${a} && coordY >= 0 && coordY < ${r}) {\n            outputValue = getImage(coords[0], coordY, coordX, coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const KC={kernelName:"RotateWithOffset",backendName:"webgl",kernelFunc:({inputs:t,attrs:e,backend:n})=>{const{image:s}=t,{radians:r,fillValue:a,center:i}=e,o=n,l=new qC(s.shape,r,a,i);return o.runWebGLProgram(l,[s],s.dtype)}},XC=PI("if (isnan(x)) return x;\n  return sin(x);\n"),YC={kernelName:Z,backendName:"webgl",kernelFunc:XC},JC={kernelName:"Square",backendName:"webgl",kernelFunc:PI("return x * x;")},ZC={kernelName:"SquaredDifference",backendName:"webgl",kernelFunc:WI({opSnippet:"return (a - b) * (a - b);",packedOpSnippet:"return (a - b) * (a - b);"})},QC="return a - b;",tS=WI({opSnippet:QC,packedOpSnippet:QC,supportsComplex:!0,cpuKernelImpl:ck}),eS={kernelName:Q,backendName:"webgl",kernelFunc:tS},nS=PI("return tan(x);");const sS=[GI,HI,jI,qI,YI,eC,BI,uC,hC,dC,gC,bC,vC,LI,NC,iC,$C,AC,RC,DC,_C,MC,WC,VC,GC,jC,ZI,tC,lC,KC,YC,JC,eS,ZC,{kernelName:tt,backendName:"webgl",kernelFunc:nS},{kernelName:"Transpose",backendName:"webgl",kernelFunc:({inputs:t,attrs:e,backend:n})=>{const{x:s}=t,{perm:r}=e,a=n,i=s.shape.length,o=new Array(i);for(let t=0;t<o.length;t++)o[t]=s.shape[r[t]];let l;if(a.shouldExecuteOnCPU([s])){const t=a.texData.get(s.dataId).values,e=hk(t,s.shape,s.dtype,r,o);l=a.makeTensorInfo(o,s.dtype),a.texData.get(l.dataId).values=e}else l=EC(s,r,a);return l}},{kernelName:"Unique",backendName:"webgl",kernelFunc:function(t){const{inputs:e,attrs:n,backend:s}=t,{axis:r}=n,{x:a}=e;Jv(a,"unique"),console.warn("WARNING: ","UI might be locked temporarily as data is being downloaded");const i=s.readSync(a.dataId),{outputValues:o,outputShape:l,indices:u}=pk(i,r,a.shape,a.dtype);return[s.makeTensorInfo(l,a.dtype,o),s.makeTensorInfo([u.length],"int32",u)]}}];for(const t of sS)it(t);const rS={"tfjs-core":"2.7.0","tfjs-backend-cpu":"2.7.0","tfjs-backend-webgl":"2.7.0","tfjs-data":"2.7.0","tfjs-layers":"2.7.0","tfjs-converter":"2.7.0",tfjs:"2.7.0"};t.Abs="Abs",t.Acos="Acos",t.Acosh="Acosh",t.AdadeltaOptimizer=Al,t.AdagradOptimizer=Rl,t.AdamOptimizer=Dl,t.AdamaxOptimizer=_l,t.Add=X,t.AddN="AddN",t.All="All",t.Any="Any",t.ArgMax="ArgMax",t.ArgMin="ArgMin",t.Asin="Asin",t.Asinh="Asinh",t.Atan="Atan",t.Atan2="Atan2",t.Atanh="Atanh",t.AvgPool="AvgPool",t.AvgPool3D="AvgPool3D",t.AvgPool3DBackprop="AvgPool3DBackprop",t.AvgPoolBackprop="AvgPoolBackprop",t.BatchMatMul="BatchMatMul",t.BatchToSpaceND="BatchToSpaceND",t.BroadcastTo="BroadcastTo",t.Callback=hg,t.CallbackList=Ep,t.Cast="Cast",t.Ceil="Ceil",t.ClipByValue="ClipByValue",t.Complex="Complex",t.Concat="Concat",t.Conv2D="Conv2D",t.Conv2DBackpropFilter="Conv2DBackpropFilter",t.Conv2DBackpropInput="Conv2DBackpropInput",t.Conv3D="Conv3D",t.Conv3DBackpropFilterV2="Conv3DBackpropFilterV2",t.Conv3DBackpropInputV2="Conv3DBackpropInputV2",t.Cos=Y,t.Cosh="Cosh",t.CropAndResize="CropAndResize",t.Cumsum="Cumsum",t.CustomCallback=Rp,t.DataStorage=e,t.DepthToSpace="DepthToSpace",t.DepthwiseConv2dNative="DepthwiseConv2dNative",t.DepthwiseConv2dNativeBackpropFilter="DepthwiseConv2dNativeBackpropFilter",t.DepthwiseConv2dNativeBackpropInput="DepthwiseConv2dNativeBackpropInput",t.Diag="Diag",t.Dilation2D="Dilation2D",t.Dilation2DBackpropFilter="Dilation2DBackpropFilter",t.Dilation2DBackpropInput="Dilation2DBackpropInput",t.Div=J,t.EarlyStopping=fg,t.Elu="Elu",t.EluGrad="EluGrad",t.Environment=G,t.Equal="Equal",t.Erf="Erf",t.Exp="Exp",t.Expm1="Expm1",t.FFT="FFT",t.Fill="Fill",t.FlipLeftRight="FlipLeftRight",t.Floor="Floor",t.FloorDiv="FloorDiv",t.FromPixels="FromPixels",t.FusedBatchNorm="FusedBatchNorm",t.FusedConv2D="FusedConv2D",t.FusedDepthwiseConv2D="FusedDepthwiseConv2D",t.GatherNd="GatherNd",t.GatherV2="GatherV2",t.GraphModel=Iy,t.Greater="Greater",t.GreaterEqual="GreaterEqual",t.History=Ap,t.IFFT="IFFT",t.Identity="Identity",t.Imag="Imag",t.InputSpec=gp,t.IsFinite="IsFinite",t.IsInf="IsInf",t.IsNan="IsNan",t.KernelBackend=n,t.LRN="LRN",t.LRNBackprop="LRNBackprop",t.LayerVariable=dp,t.LayersModel=Pd,t.Less="Less",t.LessEqual="LessEqual",t.LinSpace="LinSpace",t.Log="Log",t.Log1p="Log1p",t.LogSoftmax="LogSoftmax",t.LogicalAnd="LogicalAnd",t.LogicalNot="LogicalNot",t.LogicalOr="LogicalOr",t.Max="Max",t.MaxPool="MaxPool",t.MaxPool3D="MaxPool3D",t.MaxPool3DBackprop="MaxPool3DBackprop",t.MaxPoolBackprop="MaxPoolBackprop",t.MaxPoolWithArgmax="MaxPoolWithArgmax",t.Maximum="Maximum",t.Mean="Mean",t.Min="Min",t.Minimum="Minimum",t.MirrorPad="MirrorPad",t.Mod="Mod",t.MomentumOptimizer=Ol,t.Multiply="Multiply",t.Negate="Negate",t.NonMaxSuppressionV3="NonMaxSuppressionV3",t.NonMaxSuppressionV4="NonMaxSuppressionV4",t.NonMaxSuppressionV5="NonMaxSuppressionV5",t.NotEqual="NotEqual",t.OP_SCOPE_SUFFIX="__op",t.OneHot="OneHot",t.OnesLike="OnesLike",t.Optimizer=$l,t.PadV2="PadV2",t.Pool="Pool",t.Pow="Pow",t.Prelu="Prelu",t.Prod="Prod",t.RMSPropOptimizer=Ml,t.RNN=Uf,t.Range="Range",t.Real="Real",t.Reciprocal="Reciprocal",t.Relu="Relu",t.Relu6="Relu6",t.Reshape="Reshape",t.ResizeBilinear="ResizeBilinear",t.ResizeBilinearGrad="ResizeBilinearGrad",t.ResizeNearestNeighbor="ResizeNearestNeighbor",t.ResizeNearestNeighborGrad="ResizeNearestNeighborGrad",t.Reverse="Reverse",t.RotateWithOffset="RotateWithOffset",t.Round="Round",t.Rsqrt="Rsqrt",t.SGDOptimizer=Fl,t.ScatterNd="ScatterNd",t.SelectV2="SelectV2",t.Selu="Selu",t.Sequential=Ud,t.Sigmoid="Sigmoid",t.Sign="Sign",t.Sin=Z,t.Sinh="Sinh",t.Slice="Slice",t.Softmax="Softmax",t.Softplus="Softplus",t.SpaceToBatchND="SpaceToBatchND",t.SparseToDense="SparseToDense",t.SplitV="SplitV",t.Sqrt="Sqrt",t.Square="Square",t.SquaredDifference="SquaredDifference",t.Step="Step",t.StridedSlice="StridedSlice",t.Sub=Q,t.Sum="Sum",t.SymbolicTensor=yp,t.Tan=tt,t.Tanh="Tanh",t.Tensor=Tt,t.TensorBuffer=Nt,t.Tile="Tile",t.TopK="TopK",t.Transpose="Transpose",t.Unique="Unique",t.Unpack="Unpack",t.UnsortedSegmentSum="UnsortedSegmentSum",t.Variable=Et,t.ZerosLike="ZerosLike",t._FusedMatMul="_FusedMatMul",t.abs=os,t.acos=ls,t.acosh=us,t.add=ss,t.addN=cs,t.addStrict=uo,t.all=xs,t.any=ws,t.argMax=vs,t.argMin=ks,t.asin=Ns,t.asinh=Is,t.atan=Cs,t.atan2=Ss,t.atanh=Ts,t.avgPool=Ws,t.avgPool3d=Vs,t.backend=ns,t.backend_util=au,t.basicLSTMCell=Xs,t.batchNorm=Zs,t.batchNorm2d=Qs,t.batchNorm3d=tr,t.batchNorm4d=er,t.batchToSpaceND=Ys,t.booleanMaskAsync=no,t.broadcastTo=nr,t.browser=gn,t.buffer=We,t.callbacks=mg,t.cast=Ve,t.ceil=sr,t.clipByValue=rr,t.clone=Ue,t.complex=ne,t.concat=Hs,t.concat1d=ar,t.concat2d=ir,t.concat3d=or,t.concat4d=lr,t.constraints=Qc,t.conv1d=cr,t.conv2d=ur,t.conv2dTranspose=pr,t.conv3d=dr,t.conv3dTranspose=mr,t.copyRegisteredKernels=function(t,e){at(t).forEach(t=>{it(Object.assign({},t,{backendName:e}))})},t.cos=gr,t.cosh=yr,t.cosineWindow=So,t.cumsum=br,t.customGrad=ia,t.data=Cb,t.deprecationWarn=Kn,t.depthToSpace=xr,t.depthwiseConv2d=wr,t.deregisterOp=function(t){delete bg[t]},t.device_util=Xt,t.diag=vr,t.dilation2d=kr,t.disableDeprecationWarnings=function(){H().set("DEPRECATION_WARNINGS_ENABLED",!1),console.warn("TensorFlow.js deprecation warnings have been disabled.")},t.dispose=Zn,t.disposeVariables=function(){Ht.disposeVariables()},t.div=as,t.divNoNan=$r,t.divStrict=co,t.dot=Ar,t.dropout=Io,t.elu=Rr,t.enableDebugMode=function(){H().set("DEBUG",!0)},t.enableProdMode=function(){H().set("PROD",!0)},t.enclosingPowerOfTwo=Co,t.engine=Xn,t.env=H,t.equal=Sr,t.equalStrict=so,t.erf=Dr,t.exp=_r,t.expandDims=Fr,t.expm1=Or,t.eye=Lr,t.fft=_i,t.fill=zr,t.findBackend=function(t){return Ht.findBackend(t)},t.findBackendFactory=function(t){return Ht.findBackendFactory(t)},t.floor=Br,t.floorDiv=rs,t.fused=zo,t.gather=Ur,t.gatherND=No,t.gather_util=bn,t.getBackend=function(){return Ht.backendName},t.getGradient=rt,t.getKernel=st,t.getKernelsForBackend=at,t.grad=function(t){return l(_(t),()=>"The f passed in grad(f) must be a function"),(e,n)=>{const s=Qt(e,"x","tf.grad",null),r=null!=n?Qt(n,"dy","tf.grad"):null;return Ht.tidy(()=>{const{value:e,grads:n}=Ht.gradients(()=>t(s),[s],r);return null!=r&&u(e.shape,r.shape,"The shape of dy passed in grad(f)(x, dy) must match the shape returned by f(x)"),oa(n),n[0]})}},t.grads=function(t){return l(_(t),()=>"The f passed in grads(f) must be a function"),(e,n)=>{l(Array.isArray(e),()=>"The args passed in grads(f)(args) must be an array of `Tensor`s or `TensorLike`s");const s=te(e,"args","tf.grads",null),r=null!=n?Qt(n,"dy","tf.grads"):null;return Ht.tidy(()=>{const{value:e,grads:n}=Ht.gradients(()=>t(...s),s,r);return null!=r&&u(e.shape,r.shape,"The shape of dy passed in grads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),oa(n),n})}},t.greater=Gr,t.greaterEqual=Hr,t.greaterEqualStrict=ro,t.greaterStrict=ao,t.ifft=Fi,t.imag=jr,t.image=Sl,t.inTopKAsync=To,t.initializers=sp,t.input=Gd,t.io=an,t.irfft=Oi,t.isFinite=qr,t.isInf=Kr,t.isNaN=Xr,t.keep=Qn,t.kernel_impls=uu,t.layers=og,t.leakyRelu=Zr,t.less=Qr,t.lessEqual=ta,t.lessEqualStrict=io,t.lessStrict=oo,t.linalg=Tl,t.linspace=ea,t.loadGraphModel=async function(t,e={}){if(null==t)throw new Error("modelUrl in loadGraphModel() cannot be null. Please provide a url or an IOHandler that loads the model");null==e&&(e={}),e.fromTFHub&&null==t.load&&(t.endsWith("/")||(t+="/"),t+="model.json?tfjs-format=file");const n=new Iy(t,e);return await n.load(),n},t.loadLayersModel=function(t,e){return null==e&&(e={}),Vd(t,e)},t.localResponseNormalization=na,t.log=sa,t.log1p=ra,t.logSigmoid=ca,t.logSoftmax=fa,t.logSumExp=ma,t.logicalAnd=ga,t.logicalNot=ya,t.logicalOr=ba,t.logicalXor=xa,t.losses=El,t.matMul=ln,t.math=pn,t.max=ha,t.maxPool=wa,t.maxPool3d=va,t.maxPoolWithArgmax=ka,t.maximum=Yr,t.maximumStrict=ho,t.mean=Ca,t.memory=Yn,t.metrics=lg,t.min=Sa,t.minimum=Ta,t.minimumStrict=po,t.mirrorPad=Ea,t.mod=$a,t.modStrict=fo,t.model=function(t){return new Pd(t)},t.models=ug,t.moments=Ra,t.movingAverage=wo,t.mul=is,t.mulStrict=mo,t.multiRNNCell=Da,t.multinomial=_a,t.neg=la,t.nextFrame=Pl,t.norm=xo,t.notEqual=Fa,t.notEqualStrict=lo,t.oneHot=un,t.ones=Ia,t.onesLike=Ma,t.op=ee,t.outerProduct=La,t.pad=za,t.pad1d=Ba,t.pad2d=Pa,t.pad3d=Wa,t.pad4d=Va,t.pool=Ga,t.pow=Ha,t.powStrict=go,t.prelu=ja,t.print=Ge,t.prod=qa,t.profile=function(t){return Ht.profile(t)},t.rand=Ka,t.randomGamma=oi,t.randomNormal=li,t.randomUniform=ui,t.range=hi,t.ready=function(){return Ht.ready()},t.real=Oa,t.reciprocal=pi,t.registerBackend=es,t.registerCallbackConstructor=function(t,e){_p.registerCallbackConstructor(t,e)},t.registerGradient=ot,t.registerKernel=it,t.registerOp=function(t,e){const n={tfOpName:t,category:"custom",inputs:[],attrs:[],customExecutor:e};bg[t]=n},t.regularizers=cg,t.relu=di,t.relu6=fi,t.removeBackend=function(t){Ht.removeBackend(t)},t.reshape=on,t.reverse=mi,t.reverse1d=gi,t.reverse2d=yi,t.reverse3d=bi,t.reverse4d=xi,t.rfft=zi,t.round=wi,t.rsqrt=vi,t.scalar=Jr,t.scatterND=vo,t.scatter_util=kn,t.selu=ki,t.separableConv2d=Ni,t.sequential=function(t){return new Ud(t)},t.serialization=Vn,t.setBackend=ts,t.setPlatform=function(t,e){H().setPlatform(t,e)},t.setdiff1dAsync=Ii,t.sigmoid=js,t.sign=Ci,t.signal=Cl,t.sin=Si,t.sinh=Ti,t.slice=qs,t.slice1d=Ei,t.slice2d=$i,t.slice3d=Ai,t.slice4d=Ri,t.slice_util=zn,t.softmax=Di,t.softplus=ua,t.spaceToBatchND=Ua,t.sparseToDense=ko,t.spectral=Il,t.split=Li,t.sqrt=Bi,t.square=Aa,t.squaredDifference=Pi,t.squaredDifferenceStrict=yo,t.squeeze=Wi,t.stack=Vi,t.step=Ui,t.stridedSlice=Gi,t.sub=pa,t.subStrict=bo,t.sum=da,t.sumOutType=Mt,t.tan=Hi,t.tanh=Ks,t.tensor=re,t.tensor1d=ci,t.tensor2d=ji,t.tensor3d=dn,t.tensor4d=qi,t.tensor5d=function(t,e,n){if(c(t),null!=e&&5!==e.length)throw new Error("tensor5d() requires shape to have five numbers");const s=Jt(t,n);if(5!==s.length&&1!==s.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return se(t,e,s,n)},t.tensor6d=function(t,e,n){if(c(t),null!=e&&6!==e.length)throw new Error("tensor6d() requires shape to have six numbers");const s=Jt(t,n);if(6!==s.length&&1!==s.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return se(t,e=e||s,s,n)},t.tensor_util=Wt,t.test_util=qn,t.tidy=Jn,t.tile=Mr,t.time=function(t){return Ht.time(t)},t.topk=Ki,t.train=zl,t.transpose=cn,t.truncatedNormal=Xi,t.unique=Yi,t.unregisterGradient=function(t){if(!nt.has(t))throw new Error(`The gradient '${t}' for backend is not registered`);nt.delete(t)},t.unregisterKernel=function(t,e){const n=lt(t,e);if(!et.has(n))throw new Error(`The kernel '${t}' for backend '${e}' is not registered`);et.delete(n)},t.unsortedSegmentSum=Ji,t.unstack=Zi,t.upcastType=Ot,t.util=mt,t.valueAndGrad=function(t){return l(_(t),()=>"The f passed in valueAndGrad(f) must be a function"),(e,n)=>{l(e instanceof Tt,()=>"The x passed in valueAndGrad(f)(x) must be a tensor"),l(null==n||n instanceof Tt,()=>"The dy passed in valueAndGrad(f)(x, dy) must be a tensor");const{grads:s,value:r}=Ht.gradients(()=>t(e),[e],n);return oa(s),{grad:s[0],value:r}}},t.valueAndGrads=function(t){return l(_(t),()=>"The f passed in valueAndGrads(f) must be a function"),(e,n)=>{l(Array.isArray(e)&&e.every(t=>t instanceof Tt),()=>"The args passed in valueAndGrads(f)(args) must be array of tensors"),l(null==n||n instanceof Tt,()=>"The dy passed in valueAndGrads(f)(args, dy) must be a tensor");const s=Ht.gradients(()=>t(...e),e,n);return null!=n&&u(s.value.shape,n.shape,"The shape of dy passed in valueAndGrads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),oa(s.grads),s}},t.variable=Qi,t.variableGrads=aa,t.version=rS,t.version_converter="2.7.0",t.version_core="2.7.0",t.version_layers="2.7.0",t.where=Tr,t.whereAsync=eo,t.zeros=Na,t.zerosLike=Er,Object.defineProperty(t,"__esModule",{value:!0})}));
//# sourceMappingURL=tf.es2017.min.js.map
