/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e=e||self).tf=e.tf||{})}(this,(function(e){"use strict";class t{constructor(e,t){this.backend=e,this.dataMover=t,this.data=new WeakMap,this.dataIdsCount=0}get(e){return this.data.has(e)||this.dataMover.moveData(this.backend,e),this.data.get(e)}set(e,t){this.dataIdsCount++,this.data.set(e,t)}has(e){return this.data.has(e)}delete(e){return this.dataIdsCount--,this.data.delete(e)}numDataIds(){return this.dataIdsCount}}class n{decComplexRef(e){}time(e){return s("time")}read(e){return s("read")}readSync(e){return s("readSync")}numDataIds(){return s("numDataIds")}disposeData(e){return s("disposeData")}write(e,t,n){return s("write")}move(e,t,n,r){return s("move")}memory(){return s("memory")}floatPrecision(){return s("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return s("dispose")}}function s(e){throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function r(e){let t=e.length,n=0,s=0;for(;t>0;)s=Math.random()*t|0,t--,n=e[t],e[t]=e[s],e[s]=n}function a(e,t,n){return Math.max(e,Math.min(t,n))}function i(e){return e%2==0?e:e+1}function o(e){let t=0;for(let n=0;n<e.length;n++)t+=e[n];return t}function l(e,t){if(!e)throw new Error("string"==typeof t?t:t())}function u(e,t,n=""){l(d(e,t),()=>n+` Shapes ${e} and ${t} must match`)}function c(e){l(null!=e,()=>"The input to the tensor constructor must be a non-null value.")}function h(e,t=[],n=!1){if(null==t&&(t=[]),Array.isArray(e)||S(e)&&!n)for(let s=0;s<e.length;++s)h(e[s],t,n);else t.push(e);return t}function p(e){if(0===e.length)return 1;let t=e[0];for(let n=1;n<e.length;n++)t*=e[n];return t}function d(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function f(e){return e%1==0}function m(e){const t=Math.ceil(Math.sqrt(e));return[t,Math.ceil(e/t)]}function g(e,t){return t<=e.length?e:e+" ".repeat(t-e.length)}function y(e,t=(e=>0),n){return new Promise((s,r)=>{let a=0;const i=()=>{if(e())return void s();a++;const o=t(a);null!=n&&a>=n?r():setTimeout(i,o)};i()})}function b(e,t){let n=1,s=-1;for(let t=0;t<e.length;++t)if(e[t]>=0)n*=e[t];else if(-1===e[t]){if(-1!==s)throw Error(`Shapes can only have 1 implicit size. Found -1 at dim ${s} and dim ${t}`);s=t}else if(e[t]<0)throw Error(`Shapes can not be < 0. Found ${e[t]} at dim ${t}`);if(-1===s){if(t>0&&t!==n)throw Error(`Size(${t}) must match the product of shape ${e}`);return e}if(0===n)throw Error(`Cannot infer the missing size in [${e}] when there are 0 elements`);if(t%n!=0)throw Error(`The implicit shape can't be a fractional number. Got ${t} / ${n}`);const r=e.slice();return r[s]=t/n,r}function x(e,t){const n=t.length;return l((e=null==e?t.map((e,t)=>t):[].concat(e)).every(e=>e>=-n&&e<n),()=>`All values in axis param must be in range [-${n}, ${n}) but got axis `+e),l(e.every(e=>f(e)),()=>"All values in axis param must be integers but got axis "+e),e.map(e=>e<0?n+e:e)}function w(e,t){const n=[],s=[],r=null!=t&&Array.isArray(t)&&0===t.length,a=null==t||r?null:x(t,e).sort();let i=0;for(let t=0;t<e.length;++t){if(null!=a){if(a[i]===t&&1!==e[t])throw new Error(`Can't squeeze axis ${t} since its dim '${e[t]}' is not 1`);(null==a[i]||a[i]>t)&&1===e[t]&&(n.push(e[t]),s.push(t)),a[i]<=t&&i++}1!==e[t]&&(n.push(e[t]),s.push(t))}return{newShape:n,keptDims:s}}function k(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else{if("bool"!==e)throw new Error("Unknown data type "+e);n=new Uint8Array(t)}return n}function v(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else if("bool"===e)n=new Uint8Array(t);else{if("string"!==e)throw new Error("Unknown data type "+e);n=new Array(t)}return n}function N(e,t){for(let n=0;n<e.length;n++){const s=e[n];if(isNaN(s)||!isFinite(s))throw Error(`A tensor of type ${t} being uploaded contains ${s}.`)}}function I(e){return"bool"===e||"complex64"===e||"float32"===e||"int32"===e||"string"===e}function C(e,t){return"complex64"!==t&&(("float32"!==t||"complex64"===e)&&(("int32"!==t||"float32"===e||"complex64"===e)&&("bool"!==t||"bool"!==e)))}function S(e){return e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array}function T(e){if("float32"===e||"int32"===e)return 4;if("complex64"===e)return 8;if("bool"===e)return 1;throw new Error("Unknown dtype "+e)}function E(e){if(null==e)return 0;let t=0;return e.forEach(e=>t+=e.length),t}function $(e){return"string"==typeof e||e instanceof String}function A(e){return"boolean"==typeof e}function R(e){return"number"==typeof e}function F(e){return Array.isArray(e)?F(e[0]):e instanceof Float32Array?"float32":e instanceof Int32Array||e instanceof Uint8Array?"int32":R(e)?"float32":$(e)?"string":A(e)?"bool":"float32"}function D(e){return!!(e&&e.constructor&&e.call&&e.apply)}function _(e,t){for(let n=t;n<e;++n)if(e%n==0)return n;return e}function O(e){const t=e.length;if(t<2)return[];const n=new Array(t-1);n[t-2]=e[t-1];for(let s=t-3;s>=0;--s)n[s]=n[s+1]*e[s+1];return n}function M(e,t){if(0===e.length)return t[0];const n=e.reduce((e,t)=>e*t);if(0===n)return[];if(n!==t.length)throw new Error(`[${e}] does not match the input size ${t.length}.`);return function e(t,n,s){const r=new Array;if(1===n.length){const e=n[0];for(let n=0;n<e;n++)r[n]=s[t+n]}else{const a=n[0],i=n.slice(1),o=i.reduce((e,t)=>e*t);for(let n=0;n<a;n++)r[n]=e(t+n*o,i,s)}return r}(0,e,t)}function L(e,t){const n=z(e,t);for(let e=0;e<n.length;e++)n[e]=1;return n}function z(e,t){if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t)return new Uint8Array(e);throw new Error("Unknown data type "+t)}function B(e,t){const n=e.reduce((e,t)=>e*t,1);if(null==t||"float32"===t)return M(e,new Float32Array(n));if("int32"===t)return M(e,new Int32Array(n));if("bool"===t)return M(e,new Uint8Array(n));throw new Error("Unknown data type "+t)}function P(e){e.forEach(t=>{l(Number.isInteger(t)&&t>=0,()=>`Tensor must have a shape comprised of positive integers but got shape [${e}].`)})}function W(e,t,n){if(0===t)return 0;if(1===t)return e[0];let s=e[e.length-1];for(let t=0;t<e.length-1;++t)s+=n[t]*e[t];return s}function V(e,t,n){if(0===t)return[];if(1===t)return[e];const s=new Array(t);for(let t=0;t<s.length-1;++t)s[t]=Math.floor(e/n[t]),e-=s[t]*n[t];return s[s.length-1]=e,s}function U(e){return e&&e.then&&"function"==typeof e.then}class G{constructor(e){this.global=e,this.flags={},this.flagRegistry={},this.urlFlags={},this.populateURLFlags()}setPlatform(e,t){null!=this.platform&&console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${t}.`),this.platformName=e,this.platform=t}registerFlag(e,t,n){if(this.flagRegistry[e]={evaluationFn:t,setHook:n},null!=this.urlFlags[e]){const t=this.urlFlags[e];console.warn(`Setting feature override from URL ${e}: ${t}.`),this.set(e,t)}}async getAsync(e){return e in this.flags||(this.flags[e]=await this.evaluateFlag(e)),this.flags[e]}get(e){if(e in this.flags)return this.flags[e];const t=this.evaluateFlag(e);if(U(t))throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[e]=t,this.flags[e]}getNumber(e){return this.get(e)}getBool(e){return this.get(e)}getFlags(){return this.flags}get features(){return this.flags}set(e,t){if(null==this.flagRegistry[e])throw new Error(`Cannot set flag ${e} as it has not been registered.`);this.flags[e]=t,null!=this.flagRegistry[e].setHook&&this.flagRegistry[e].setHook(t)}evaluateFlag(e){if(null==this.flagRegistry[e])throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);return this.flagRegistry[e].evaluationFn()}setFlags(e){this.flags=Object.assign({},e)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if(void 0===this.global||void 0===this.global.location||void 0===this.global.location.search)return;const e=function(e){const t={};return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,(e,...n)=>(function(e,t,n){e[decodeURIComponent(t)]=decodeURIComponent(n||"")}(t,n[0],n[1]),n.join("="))),t}(this.global.location.search);if("tfjsflags"in e){e.tfjsflags.split(",").forEach(e=>{const[t,n]=e.split(":");this.urlFlags[t]=function(e,t){if("true"===(t=t.toLowerCase())||"false"===t)return"true"===t;if(""+ +t===t)return+t;throw new Error(`Could not parse value flag value ${t} for flag ${e}.`)}(t,n)})}}}function H(){return e.ENV}let j;function q(){if(null==j){let e;if("undefined"!=typeof window)e=window;else if("undefined"!=typeof global)e=global;else if("undefined"!=typeof process)e=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");e=self}j=e}return j}function K(e,t){const n=function(){const e=q();return null==e._tfGlobals&&(e._tfGlobals=new Map),e._tfGlobals}();if(n.has(e))return n.get(e);{const s=t();return n.set(e,s),n.get(e)}}e.ENV=null;const X="Add",Y="Cos",J="Elu",Z="Erf",Q="Exp",ee="Log",te="Mod",ne="Pow",se="Sin",re="Sub",ae="Tan",ie=K("kernelRegistry",()=>new Map),oe=K("gradRegistry",()=>new Map);function le(e,t){const n=de(e,t);return ie.get(n)}function ue(e){return oe.get(e)}function ce(e){const t=ie.entries(),n=[];for(;;){const{done:s,value:r}=t.next();if(s)break;const[a,i]=r,[o]=a.split("_");o===e&&n.push(i)}return n}function he(e){const{kernelName:t,backendName:n}=e,s=de(t,n);ie.has(s)&&console.warn(`The kernel '${t}' for backend '${n}' is already registered`),ie.set(s,e)}function pe(e){const{kernelName:t}=e;oe.has(t)&&H().getBool("DEBUG")&&console.warn(`Overriding the gradient for '${t}'`),oe.set(t,e)}function de(e,t){return`${t}_${e}`}function fe(e,t){return"string"===t?be(e):me([e],t)}function me(e,t){if("string"===t)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(e)&&(e=h(e)),H().getBool("DEBUG")&&N(e,t),function(e,t){return e instanceof Float32Array&&"float32"===t||e instanceof Int32Array&&"int32"===t||e instanceof Uint8Array&&"bool"===t}(e,t))return e;if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t){const t=new Uint8Array(e.length);for(let n=0;n<t.length;++n)0!==Math.round(e[n])&&(t[n]=1);return t}throw new Error("Unknown data type "+t)}function ge(){return H().platform.now()}function ye(e,t){return H().platform.fetch(e,t)}function be(e,t="utf-8"){return t=t||"utf-8",H().platform.encode(e,t)}function xe(e,t="utf-8"){return t=t||"utf-8",H().platform.decode(e,t)}var we=Object.freeze({__proto__:null,createScalarValue:fe,toTypedArray:me,now:ge,fetch:ye,encodeString:be,decodeString:xe,shuffle:r,shuffleCombo:function(e,t){if(e.length!==t.length)throw Error("Array sizes must match to be shuffled together First array length was "+e.length+"Second array length was "+t.length);let n,s,r=e.length,a=0;for(;r>0;)a=Math.random()*r|0,r--,n=e[r],s=t[r],e[r]=e[a],t[r]=t[a],e[a]=n,t[a]=s},clamp:a,nearestLargerEven:i,sum:o,randUniform:function(e,t){const n=Math.random();return t*n+(1-n)*e},distSquared:function(e,t){let n=0;for(let s=0;s<e.length;s++){const r=Number(e[s])-Number(t[s]);n+=r*r}return n},assert:l,assertShapesMatch:u,assertNonNull:c,flatten:h,sizeFromShape:p,isScalarShape:function(e){return 0===e.length},arraysEqual:d,isInt:f,tanh:function(e){if(null!=Math.tanh)return Math.tanh(e);if(e===1/0)return 1;if(e===-1/0)return-1;{const t=Math.exp(2*e);return(t-1)/(t+1)}},sizeToSquarishShape:m,createShuffledIndices:function(e){const t=new Uint32Array(e);for(let n=0;n<e;++n)t[n]=n;return r(t),t},rightPad:g,repeatedTry:y,inferFromImplicitShape:b,parseAxisParam:x,squeezeShape:w,getTypedArrayFromDType:k,getArrayFromDType:v,checkConversionForErrors:N,isValidDtype:I,hasEncodingLoss:C,isTypedArray:S,bytesPerElement:T,bytesFromStringArray:E,isString:$,isBoolean:A,isNumber:R,inferDtype:F,isFunction:D,nearestDivisor:_,computeStrides:O,toNestedArray:M,makeOnesTypedArray:L,makeZerosTypedArray:z,makeZerosNestedTypedArray:B,assertNonNegativeIntegerDimensions:P,locToIndex:W,indexToLoc:V,isPromise:U});class ke{constructor(e,t){this.backendTimer=e,this.logger=t,null==t&&(this.logger=new Ne)}profileKernel(e,t,n){let s;const r=this.backendTimer.time(()=>{s=n()});if(H().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let t=0;t<s.length;t++){const n=s[t];n.data().then(t=>{ve(t,n.dtype,e)})}return{kernelName:e,outputs:s,inputs:t,timeMs:r.then(e=>e.kernelMs),extraInfo:r.then(e=>null!=e.getExtraProfileInfo?e.getExtraProfileInfo():"")}}logKernelProfile(e){const{kernelName:t,outputs:n,timeMs:s,inputs:r,extraInfo:a}=e;n.forEach(e=>{Promise.all([e.data(),s,a]).then(n=>{this.logger.logKernelProfile(t,e,n[0],n[1],r,n[2])})})}}function ve(e,t,n){if("float32"!==t)return!1;for(let t=0;t<e.length;t++){const s=e[t];if(isNaN(s)||!isFinite(s))return console.warn(`Found ${s} in the result of '${n}'`),!0}return!1}class Ne{logKernelProfile(e,t,n,s,r,a){const i="number"==typeof s?g(s+"ms",9):s.error,o=g(e,25),l=t.rank,u=t.size,c=g(t.shape.toString(),14);let h="";for(const e in r){const n=r[e];if(null!=n){const s=n.shape||t.shape,r=s.length;h+=`${e}: ${r}D ${r>0?s:""} `}}console.log(`%c${o}\t%c${i}\t%c${l}D ${c}\t%c${u}\t%c${h}\t%c${a}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function Ie(e,t,n,s){const r=O(t),a=function(e,t,n,s){const r=p(t),a=s[s.length-1],i=new Array(a).fill(0),o=t.length,l="complex64"===n?Te(e):e;if(o>1)for(let e=0;e<r/a;e++){const t=e*a;for(let e=0;e<a;e++)i[e]=Math.max(i[e],Ce(l[t+e],0,n).length)}return i}(e,t,n,r),i=t.length,o=function e(t,n,s,r,a,i=!0){const o="complex64"===s?2:1,l=n[0],u=n.length;if(0===u){if("complex64"===s){return[Ce(Te(t)[0],0,s)]}return"bool"===s?[Se(t[0])]:[t[0].toString()]}if(1===u){if(l>20){const e=3*o;let n=Array.from(t.slice(0,e)),r=Array.from(t.slice((l-3)*o,l*o));return"complex64"===s&&(n=Te(n),r=Te(r)),["["+n.map((e,t)=>Ce(e,a[t],s)).join(", ")+", ..., "+r.map((e,t)=>Ce(e,a[l-3+t],s)).join(", ")+"]"]}return["["+("complex64"===s?Te(t):Array.from(t)).map((e,t)=>Ce(e,a[t],s)).join(", ")+"]"]}const c=n.slice(1),h=r.slice(1),p=r[0]*o,d=[];if(l>20){for(let n=0;n<3;n++){const r=n*p,i=r+p;d.push(...e(t.slice(r,i),c,s,h,a,!1))}d.push("...");for(let n=l-3;n<l;n++){const r=n*p,i=r+p;d.push(...e(t.slice(r,i),c,s,h,a,n===l-1))}}else for(let n=0;n<l;n++){const r=n*p,i=r+p;d.push(...e(t.slice(r,i),c,s,h,a,n===l-1))}const f=2===u?",":"";d[0]="["+d[0]+f;for(let e=1;e<d.length-1;e++)d[e]=" "+d[e]+f;let m=",\n";for(let e=2;e<u;e++)m+="\n";return d[d.length-1]=" "+d[d.length-1]+"]"+(i?"":m),d}(e,t,n,r,a),l=["Tensor"];return s&&(l.push("  dtype: "+n),l.push("  rank: "+i),l.push(`  shape: [${t}]`),l.push("  values:")),l.push(o.map(e=>"    "+e).join("\n")),l.join("\n")}function Ce(e,t,n){let s;return s=Array.isArray(e)?parseFloat(e[0].toFixed(7))+" + "+parseFloat(e[1].toFixed(7))+"j":$(e)?`'${e}'`:"bool"===n?Se(e):parseFloat(e.toFixed(7)).toString(),g(s,t)}function Se(e){return 0===e?"false":"true"}function Te(e){const t=[];for(let n=0;n<e.length;n+=2)t.push([e[n],e[n+1]]);return t}class Ee{constructor(e,t,n){if(this.dtype=t,this.shape=e.slice(),this.size=p(e),null!=n){const e=n.length;l(e===this.size,()=>`Length of values '${e}' does not match the size inferred by the shape '${this.size}'.`)}if("complex64"===t)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||v(t,this.size),this.strides=O(e)}set(e,...t){0===t.length&&(t=[0]),l(t.length===this.rank,()=>`The number of provided coordinates (${t.length}) must match the rank (${this.rank})`);const n=this.locToIndex(t);this.values[n]=e}get(...e){0===e.length&&(e=[0]);let t=0;for(const n of e){if(n<0||n>=this.shape[t]){const t=`Requested out of range element at ${e}.   Buffer shape=`+this.shape;throw new Error(t)}t++}let n=e[e.length-1];for(let t=0;t<e.length-1;++t)n+=this.strides[t]*e[t];return this.values[n]}locToIndex(e){if(0===this.rank)return 0;if(1===this.rank)return e[0];let t=e[e.length-1];for(let n=0;n<e.length-1;++n)t+=this.strides[n]*e[n];return t}indexToLoc(e){if(0===this.rank)return[];if(1===this.rank)return[e];const t=new Array(this.shape.length);for(let n=0;n<t.length-1;++n)t[n]=Math.floor(e/this.strides[n]),e-=t[n]*this.strides[n];return t[t.length-1]=e,t}get rank(){return this.shape.length}toTensor(){return $e().makeTensor(this.values,this.shape,this.dtype)}}let $e=null,Ae=null,Re=null;class Fe{constructor(e,t,n,s){this.kept=!1,this.isDisposedInternal=!1,this.shape=e.slice(),this.dtype=t||"float32",this.size=p(e),this.strides=O(e),this.dataId=n,this.id=s,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const e=await this.data();return Ae.buffer(this.shape,this.dtype,e)}bufferSync(){return Ae.buffer(this.shape,this.dtype,this.dataSync())}async array(){const e=await this.data();return M(this.shape,e)}arraySync(){return M(this.shape,this.dataSync())}async data(){this.throwIfDisposed();const e=$e().read(this.dataId);if("string"===this.dtype){const t=await e;try{return t.map(e=>xe(e))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return e}dataSync(){this.throwIfDisposed();const e=$e().readSync(this.dataId);if("string"===this.dtype)try{return e.map(e=>xe(e))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return e}async bytes(){this.throwIfDisposed();const e=await $e().read(this.dataId);return"string"===this.dtype?e:new Uint8Array(e.buffer)}dispose(){this.isDisposed||($e().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(e=!1){return Ae.print(this,e)}clone(){return this.throwIfDisposed(),Ae.clone(this)}toString(e=!1){return Ie(this.dataSync(),this.shape,this.dtype,e)}cast(e){return this.throwIfDisposed(),Ae.cast(this,e)}variable(e=!0,t,n){return this.throwIfDisposed(),$e().makeVariable(this,e,t,n)}}function De(){return K("Tensor",()=>Fe)}Object.defineProperty(Fe,Symbol.hasInstance,{value:e=>!!e&&null!=e.data&&null!=e.dataSync&&null!=e.throwIfDisposed}),De();class _e extends Fe{constructor(e,t,n,s){super(e.shape,e.dtype,e.dataId,s),this.trainable=t,this.name=n}assign(e){if(e.dtype!==this.dtype)throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);if(!d(e.shape,this.shape))throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);$e().disposeTensor(this),this.dataId=e.dataId,$e().incRef(this,null)}dispose(){$e().disposeVariable(this),this.isDisposedInternal=!0}}var Oe,Me,Le,ze,Be;Object.defineProperty(_e,Symbol.hasInstance,{value:e=>e instanceof Fe&&null!=e.assign&&e.assign instanceof Function}),(Oe=e.Rank||(e.Rank={})).R0="R0",Oe.R1="R1",Oe.R2="R2",Oe.R3="R3",Oe.R4="R4",Oe.R5="R5",Oe.R6="R6",function(e){e.float32="float32",e.int32="int32",e.bool="int32",e.complex64="complex64"}(Me||(Me={})),function(e){e.float32="float32",e.int32="int32",e.bool="bool",e.complex64="complex64"}(Le||(Le={})),function(e){e.float32="float32",e.int32="float32",e.bool="float32",e.complex64="complex64"}(ze||(ze={})),function(e){e.float32="complex64",e.int32="complex64",e.bool="complex64",e.complex64="complex64"}(Be||(Be={}));const Pe={float32:ze,int32:Me,bool:Le,complex64:Be};function We(e,t){if("string"===e||"string"===t){if("string"===e&&"string"===t)return"string";throw new Error(`Can not upcast ${e} with ${t}`)}return Pe[e][t]}function Ve(e){return We(e,"int32")}function Ue(e,t){if(e.dtype===t.dtype)return[e,t];const n=We(e.dtype,t.dtype);return[e.cast(n),t.cast(n)]}function Ge(e,t){l(e.dtype===t.dtype,()=>`The dtypes of the first(${e.dtype}) and second(${t.dtype}) input must match`)}function He(e,t){return t.some(t=>t.id===e.id)}function je(e){const t=[];return function e(t,n,s){if(null==t)return;if(t instanceof Fe)return void n.push(t);if(r=t,!Array.isArray(r)&&"object"!=typeof r)return;var r;const a=t;for(const t in a){const r=a[t];s.has(r)||(s.add(r),e(r,n,s))}}(e,t,new Set),t}var qe=Object.freeze({__proto__:null,makeTypesMatch:Ue,assertTypesMatch:Ge,isTensorInList:He,getTensorsInContainer:je});function Ke(e){return null!=e.kernelName}class Xe{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map(e=>e.name)))}}}dispose(){for(const e in this.registeredVariables)this.registeredVariables[e].dispose()}}class Ye{constructor(e){this.ENV=e,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new Xe}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then(()=>{});if(null!=this.backendInstance)return;const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:e,asyncInit:t}=this.initializeBackendsAndReturnBest();if(t)throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(e)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(e){if(!(e in this.registry)){if(!(e in this.registryFactory))return null;{const{asyncInit:t}=this.initializeBackend(e);if(t)return null}}return this.registry[e]}findBackendFactory(e){return e in this.registryFactory?this.registryFactory[e].factory:null}registerBackend(e,t,n=1){return e in this.registryFactory?(console.warn(e+" backend was already registered. Reusing existing backend factory."),!1):(this.registryFactory[e]={factory:t,priority:n},!0)}async setBackend(e){if(null==this.registryFactory[e])throw new Error(`Backend name '${e}' not found in registry`);if(this.backendName=e,null==this.registry[e]){this.backendInstance=null;const{success:t,asyncInit:n}=this.initializeBackend(e);if(!(n?await t:t))return!1}return this.backendInstance=this.registry[e],this.setupRegisteredKernels(),this.profiler=new ke(this.backendInstance),!0}setupRegisteredKernels(){ce(this.backendName).forEach(e=>{null!=e.setupFunc&&e.setupFunc(this.backendInstance)})}disposeRegisteredKernels(e){ce(e).forEach(t=>{null!=t.disposeFunc&&t.disposeFunc(this.registry[e])})}initializeBackend(e){const t=this.registryFactory[e];if(null==t)throw new Error(`Cannot initialize backend ${e}, no registration found.`);try{const s=t.factory();if(!s||s instanceof n||"function"!=typeof s.then)return this.registry[e]=s,{success:!0,asyncInit:!1};{const t=++this.pendingBackendInitId,n=s.then(n=>!(t<this.pendingBackendInitId)&&(this.registry[e]=n,this.pendingBackendInit=null,!0)).catch(n=>(t<this.pendingBackendInitId||(this.pendingBackendInit=null,console.warn(`Initialization of backend ${e} failed`),console.warn(n.stack||n.message)),!1));return this.pendingBackendInit=n,{success:n,asyncInit:!0}}}catch(t){return console.warn(`Initialization of backend ${e} failed`),console.warn(t.stack||t.message),{success:!1,asyncInit:!1}}}removeBackend(e){if(!(e in this.registryFactory))throw new Error(e+" backend not found in registry");this.backendName===e&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,e in this.registry&&(this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e]),delete this.registryFactory[e],this.backendName===e&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort((e,t)=>this.registryFactory[t].priority-this.registryFactory[e].priority)}initializeBackendsAndReturnBest(){const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t],{success:s,asyncInit:r}=this.initializeBackend(n);if(r||s)return{name:n,asyncInit:r}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(e,t){const n=this.state.tensorInfo.get(t),s=n.backend,r=this.readSync(t);s.disposeData(t),n.backend=e,e.move(t,r,n.shape,n.dtype),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(e,t){let n,s=null;if(null==t){if("function"!=typeof e)throw new Error("Please provide a function to tidy()");t=e}else{if("string"!=typeof e&&!(e instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof t)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");s=e}return this.scopedRun(()=>this.startScope(s),()=>this.endScope(n),()=>(n=t(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n))}scopedRun(e,t,n){e();try{const e=n();return t(),e}catch(e){throw t(),e}}nextTensorId(){return Ye.nextTensorId++}nextVariableId(){return Ye.nextVariableId++}clone(e){const t=this.makeTensorFromDataId(e.dataId,e.shape,e.dtype),n={x:e};return this.addTapeNode(this.state.activeScope.name,n,[t],e=>({x:()=>{const t={x:e},n={dtype:"float32"};return Ze.runKernel("Cast",t,n)}}),[],{}),t}runKernel(e,t,n){if(!(null!=le(e,this.backendName)))throw new Error(`Kernel '${e}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:e,inputs:t,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(e,t,n){const s=this.backend.numDataIds();let r=0;n.forEach(e=>{r+="complex64"===e.dtype?3:1});const a=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],i=s-t-r-a;if(i>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${i} data ids) after running '${e}'`)}runKernelFunc(e){let t,n=[];const s=this.isTapeOn(),r=this.state.numBytes,a=this.state.numTensors;let i,o;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const u=Ke(e)?e.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(Ke(e)){const{kernelName:t,inputs:r,attrs:a}=e;null==this.backendName&&this.backend;const u=le(t,this.backendName);l(null!=u,()=>`Cannot find registered kernel '${t}' for backend '${this.backendName}'`),i=()=>{const e=this.backend.numDataIds();o=u.kernelFunc({inputs:r,attrs:a,backend:this.backend});const i=Array.isArray(o)?o:[o];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(t,e,i);const l=i.map(e=>{if(null!=e.rank)return e;const{dataId:t,shape:n,dtype:s}=e;return this.makeTensorFromDataId(t,n,s)});if(s){const e=this.getTensorsForGradient(t,r,l);n=this.saveTensorsForBackwardMode(e)}return l}}else{const{forwardFunc:t}=e,r=e=>{s&&(n=e.map(e=>this.keep(this.clone(e))))};i=()=>{const e=this.backend.numDataIds();o=this.tidy(()=>t(this.backend,r));const n=Array.isArray(o)?o:[o];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(u,e,n),n}}const{inputs:c,attrs:h}=e,p=Ke(e)?null:e.backwardsFunc;let d;return this.scopedRun(()=>this.state.kernelDepth++,()=>this.state.kernelDepth--,()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(d=this.profiler.profileKernel(u,c,()=>i()),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(d),t=d.outputs):t=i()}),s&&this.addTapeNode(u,c,t,p,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:u,bytesAdded:this.state.numBytes-r,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-a,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(c).map(e=>null!=c[e]?c[e].shape:null),outputShapes:t.map(e=>e.shape),kernelTimeMs:d.timeMs,extraInfo:d.extraInfo}),Array.isArray(o)?t:t[0]}saveTensorsForBackwardMode(e){return e.map(e=>this.keep(this.clone(e)))}getTensorsForGradient(e,t,n){const s=ue(e);if(null!=s){const e=s.inputsToSave||[],r=s.outputsToSave||[];let a;s.saveAllInputs?(l(Array.isArray(t),()=>"saveAllInputs is true, expected inputs to be an array."),a=Object.keys(t).map(e=>t[e])):a=e.map(e=>t[e]);const i=n.filter((e,t)=>r[t]);return a.concat(i)}return[]}makeTensor(e,t,n,s){if(null==e)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",s=s||this.backend;let r=e;"string"===n&&$(e[0])&&(r=e.map(e=>be(e)));const a=s.write(r,t,n),i=new Fe(t,n,a,this.nextTensorId());if(this.incRef(i,s),"string"===n){const e=this.state.tensorInfo.get(a),t=E(r);this.state.numBytes+=t-e.bytes,e.bytes=t}return i}makeTensorFromDataId(e,t,n,s){const r=new Fe(t,n=n||"float32",e,this.nextTensorId());return this.incRef(r,s),r}makeVariable(e,t=!0,n,s){n=n||this.nextVariableId().toString(),null!=s&&s!==e.dtype&&(e=e.cast(s));const r=new _e(e,t,n,this.nextTensorId());if(null!=this.state.registeredVariables[r.name])throw new Error(`Variable with name ${r.name} was already registered`);return this.state.registeredVariables[r.name]=r,this.incRef(r,this.backend),r}incRef(e,t){const n=this.state.tensorInfo.has(e.dataId)?this.state.tensorInfo.get(e.dataId).refCount:0;if(this.state.numTensors++,"string"===e.dtype&&this.state.numStringTensors++,0===n){this.state.numDataBuffers++;let n=0;"complex64"!==e.dtype&&"string"!==e.dtype&&(n=e.size*T(e.dtype)),this.state.tensorInfo.set(e.dataId,{backend:t||this.backend,dtype:e.dtype,shape:e.shape,bytes:n,refCount:0}),this.state.numBytes+=n}this.state.tensorInfo.get(e.dataId).refCount++,e instanceof _e||this.track(e)}disposeTensor(e){if(!this.state.tensorInfo.has(e.dataId))return;this.state.numTensors--,"string"===e.dtype&&this.state.numStringTensors--;const t=this.state.tensorInfo.get(e.dataId);t.refCount<=1?("complex64"!==e.dtype&&(this.state.numBytes-=t.bytes),this.state.numDataBuffers--,t.backend.disposeData(e.dataId),this.state.tensorInfo.delete(e.dataId)):(t.backend.decComplexRef(e.dataId),this.state.tensorInfo.get(e.dataId).refCount--)}disposeVariables(){for(const e in this.state.registeredVariables){const t=this.state.registeredVariables[e];this.disposeVariable(t)}}disposeVariable(e){this.disposeTensor(e),null!=this.state.registeredVariables[e.name]&&delete this.state.registeredVariables[e.name]}memory(){const e=this.backend.memory();return e.numTensors=this.state.numTensors,e.numDataBuffers=this.state.numDataBuffers,e.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(e.unreliable=!0,null==e.reasons&&(e.reasons=[]),e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),e}async profile(e){this.state.profiling=!0;const t=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await e(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map(e=>e.totalBytesSnapshot)),this.state.activeProfile.newBytes=this.state.numBytes-t,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const e of this.state.activeProfile.kernels)e.kernelTimeMs=await e.kernelTimeMs,e.extraInfo=await e.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(e,t,n,s,r,a){const i={id:this.state.nextTapeNodeId++,kernelName:e,inputs:t,outputs:n,saved:r},o=ue(e);null!=o&&(s=o.gradFunc),null!=s&&(i.gradient=e=>(e=e.map((e,t)=>{if(null==e){const e=n[t],s=z(e.size,e.dtype);return this.makeTensor(s,e.shape,e.dtype)}return e}),s(e.length>1?e:e[0],r,a))),this.state.activeTape.push(i)}keep(e){return e.kept=!0,e}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(e){const t={track:[],name:"unnamed scope",id:this.state.nextScopeId++};e&&(t.name=e),this.state.scopeStack.push(t),this.state.activeScope=t}endScope(e){const t=je(e),n=new Set(t.map(e=>e.id));for(let e=0;e<this.state.activeScope.track.length;e++){const t=this.state.activeScope.track[e];t.kept||n.has(t.id)||t.dispose()}const s=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],t.forEach(e=>{e.kept||e.scopeId!==s.id||this.track(e)})}gradients(e,t,n,s=!1){if(l(t.length>0,()=>"gradients() received an empty list of xs."),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const r=this.scopedRun(()=>this.startTape(),()=>this.endTape(),()=>this.tidy("forward",e));l(r instanceof Fe,()=>"The result y returned by f() must be a tensor.");const a=function(e,t,n){const s={},r={};for(let e=0;e<t.length;e++)s[t[e].id]=!0;for(let n=0;n<e.length;n++){const a=e[n],i=a.inputs;for(const e in i){const n=i[e];let o=!1;for(let e=0;e<t.length;e++)if(s[n.id]){a.outputs.forEach(e=>s[e.id]=!0),o=!0,r[a.id]=!0;break}if(o)break}}const a={};a[n.id]=!0;const i={};for(let t=e.length-1;t>=0;t--){const n=e[t],s=n.inputs;for(let e=0;e<n.outputs.length;e++)if(a[n.outputs[e].id]){for(const e in s)a[s[e].id]=!0,i[n.id]=!0;break}}const o=[];for(let t=0;t<e.length;t++){const n=e[t];if(r[n.id]&&i[n.id]){const e={};for(const t in n.inputs){const r=n.inputs[t];s[r.id]&&(e[t]=r)}const t=Object.assign({},n);t.inputs=e,t.outputs=n.outputs,o.push(t)}}return o}(this.state.activeTape,t,r);if(!s&&0===a.length&&t.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",()=>{const e={};e[r.id]=null==n?function(e){const t=L(p(e),"float32");return Ze.makeTensor(t,e,"float32")}(r.shape):n,function(e,t,n,s){for(let r=t.length-1;r>=0;r--){const a=t[r],i=[];if(a.outputs.forEach(t=>{const n=e[t.id];null!=n?i.push(n):i.push(null)}),null==a.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${a.kernelName}.`);const o=a.gradient(i);for(const t in a.inputs){if(!(t in o))throw new Error(`Cannot backprop through input ${t}. Available gradients found: ${Object.keys(o)}.`);const r=n(()=>o[t]());if("float32"!==r.dtype)throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input ${t} must have 'float32' dtype, but has '${r.dtype}'`);const i=a.inputs[t];if(!d(r.shape,i.shape))throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input '${t}' has shape '${r.shape}', which does not match the shape of the input '${i.shape}'`);if(null==e[i.id])e[i.id]=r;else{const t=e[i.id];e[i.id]=s(t,r),t.dispose()}}}}(e,a,e=>this.tidy(e),Qe);const s=t.map(t=>e[t.id]);return 0===this.state.gradientDepth&&(this.state.activeTape.forEach(e=>{for(const t of e.saved)t.dispose()}),this.state.activeTape=null),{value:r,grads:s}})}customGrad(e){return l(D(e),()=>"The f passed in customGrad(f) must be a function."),(...t)=>{let n;l(t.every(e=>e instanceof Fe),()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors");const s={};t.forEach((e,t)=>{s[t]=e});return this.runKernelFunc({forwardFunc:(s,r)=>(n=e(...t,r),l(n.value instanceof Fe,()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor"),l(D(n.gradFunc),()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function."),n.value),backwardsFunc:(e,s)=>{const r=n.gradFunc(e,s),a=Array.isArray(r)?r:[r];l(a.length===t.length,()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...)."),l(a.every(e=>e instanceof Fe),()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors.");const i={};return a.forEach((e,t)=>{i[t]=()=>e}),i},inputs:s})}}readSync(e){return this.state.tensorInfo.get(e).backend.readSync(e)}read(e){return this.state.tensorInfo.get(e).backend.read(e)}async time(e){const t=ge(),n=await this.backend.time(e);return n.wallMs=ge()-t,n}track(e){return null!=this.state.activeScope&&(e.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(e)),e}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new Xe;for(const e in this.registry)this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}function Je(){const t=q();if(null==t._tfengine){const e=new G(t);t._tfengine=new Ye(e)}var n;return n=t._tfengine.ENV,e.ENV=n,$e=()=>t._tfengine,t._tfengine}Ye.nextTensorId=0,Ye.nextVariableId=0;const Ze=Je();function Qe(e,t){const n={a:e,b:t};return Ze.runKernel(X,n)}function et(){if("undefined"!=typeof navigator&&null!=navigator){const e=navigator.userAgent||navigator.vendor||window.opera;return/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(e)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(e.substr(0,4))}return!1}function tt(){return"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope}var nt=Object.freeze({__proto__:null,isMobile:et,isBrowser:tt});const st=H();function rt(e,t){let n=e;if(S(e))return"string"===t?[]:[e.length];if(!Array.isArray(e))return[];const s=[];for(;Array.isArray(n)||S(n)&&"string"!==t;)s.push(n.length),n=n[0];return Array.isArray(e)&&H().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&function e(t,n,s){if(s=s||[],!Array.isArray(t)&&!S(t))return void l(0===n.length,()=>`Element arr[${s.join("][")}] is a primitive, but should be an array/TypedArray of ${n[0]} elements`);l(n.length>0,()=>`Element arr[${s.join("][")}] should be a primitive, but is an array of ${t.length} elements`),l(t.length===n[0],()=>`Element arr[${s.join("][")}] should have ${n[0]} elements, but has ${t.length} elements`);const r=n.slice(1);for(let n=0;n<t.length;++n)e(t[n],r,s.concat(n))}(e,s,[]),s}function at(e,t,n,s){if("string_or_numeric"!==e){if(null==e)throw new Error("Expected dtype cannot be null.");if("numeric"!==e&&e!==t||"numeric"===e&&"string"===t)throw new Error(`Argument '${n}' passed to '${s}' must be ${e} tensor, but got ${t} tensor`)}}function it(e,t,n,s="numeric"){if(e instanceof Fe)return at(s,e.dtype,t,n),e;let r=F(e);if("string"!==r&&["bool","int32","float32"].indexOf(s)>=0&&(r=s),at(s,r,t,n),null==e||!S(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e){const s=null==e?"null":e.constructor.name;throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${s}'`)}const a=rt(e,r);S(e)||Array.isArray(e)||(e=[e]);const i="string"!==r?me(e,r):h(e,[],!0);return Ze.makeTensor(i,a,r)}function ot(e,t,n,s="numeric"){if(!Array.isArray(e))throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return e.map((e,r)=>it(e,`${t}[${r}]`,n,s))}st.registerFlag("DEBUG",()=>!1,e=>{e&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")}),st.registerFlag("IS_BROWSER",()=>tt()),st.registerFlag("IS_NODE",()=>"undefined"!=typeof process&&void 0!==process.versions&&void 0!==process.versions.node),st.registerFlag("IS_CHROME",()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor)),st.registerFlag("PROD",()=>!1),st.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",()=>st.getBool("DEBUG")),st.registerFlag("DEPRECATION_WARNINGS_ENABLED",()=>!0),st.registerFlag("IS_TEST",()=>!1),st.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",()=>!0);function lt(e){const t=Object.keys(e);if(1!==t.length)throw new Error("Please provide an object with a single key (operation name) mapping to a function. Got an object with "+t.length+" keys.");let n=t[0];const s=e[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+="__op";const r=(...e)=>{Ze.startScope(n);try{const t=s(...e);return U(t)&&console.error("Cannot return a Promise inside of tidy."),Ze.endScope(t),t}catch(e){throw Ze.endScope(null),e}};return Object.defineProperty(r,"name",{value:n,configurable:!0}),r}const ut=lt({complex_:function(e,t){const n=it(e,"real","complex"),s=it(t,"imag","complex");u(n.shape,s.shape,`real and imag shapes, ${n.shape} and ${s.shape}, must match in call to tf.complex().`);const r={real:n,imag:s};return Ze.runKernel("Complex",r)}});function ct(e,t,n,s){if(null==s&&(s=F(e)),"complex64"===s)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!S(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=t){P(t);const e=p(t),s=p(n);l(e===s,()=>`Based on the provided shape, [${t}], the tensor should have ${e} values but has ${s}`);for(let e=0;e<n.length;++e){const s=n[e],r=e!==n.length-1||s!==p(t.slice(e));l(n[e]===t[e]||!r,()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `)}}return S(e)||Array.isArray(e)||(e=[e]),t=t||n,e="string"!==s?me(e,s):h(e,[],!0),Ze.makeTensor(e,t,s)}function ht(e,t,n){return ct(e,t,rt(e,n),n)}const pt={float32:4,float16:2,int32:4,uint16:2,uint8:1,bool:1,complex64:8};async function dt(e,t){const n=[],s=[],r=Array.isArray(e)?e.map(e=>e.name):Object.keys(e);for(let a=0;a<r.length;++a){const i=r[a],o=Array.isArray(e)?e[a].tensor:e[i];if("float32"!==o.dtype&&"int32"!==o.dtype&&"bool"!==o.dtype&&"string"!==o.dtype&&"complex64"!==o.dtype)throw new Error(`Unsupported dtype in weight '${i}': ${o.dtype}`);const l={name:i,shape:o.shape,dtype:o.dtype};if("string"===o.dtype){const e=new Promise(async e=>{const t=await o.bytes(),n=t.reduce((e,t)=>e+t.length,0)+4*t.length,s=new Uint8Array(n);let r=0;for(let e=0;e<t.length;e++){const n=t[e],a=new Uint8Array(new Uint32Array([n.length]).buffer);s.set(a,r),r+=4,s.set(n,r),r+=n.length}e(s)});s.push(e)}else s.push(o.data());null!=t&&(l.group=t),n.push(l)}return{data:mt(await Promise.all(s)),specs:n}}function ft(e,t){const n={};let s,r=0;for(const a of t){const t=a.name,i=a.dtype,o=a.shape,l=p(o);let u;if("quantization"in a){const n=a.quantization;if("uint8"===n.dtype||"uint16"===n.dtype){if(!("min"in n)||!("scale"in n))throw new Error(`Weight ${a.name} with quantization ${n.dtype} doesn't have corresponding metadata min and scale.`)}else{if("float16"!==n.dtype)throw new Error(`Weight ${a.name} has unknown quantization dtype ${n.dtype}. Supported quantization dtypes are: 'uint8', 'uint16', and 'float16'.`);if("float32"!==i)throw new Error(`Weight ${a.name} is quantized with ${n.dtype} which only supports weights of type float32 not ${i}.`)}const o=pt[n.dtype],c=e.slice(r,r+l*o),h="uint8"===n.dtype?new Uint8Array(c):new Uint16Array(c);if("float32"===i)if("uint8"===n.dtype||"uint16"===n.dtype){u=new Float32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=t*n.scale+n.min}}else{if("float16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type float32.`);void 0===s&&(s=kt()),u=s(h)}else{if("int32"!==i)throw new Error(`Unsupported dtype in weight '${t}': ${i}`);if("uint8"!==n.dtype&&"uint16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type int32.`);u=new Int32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=Math.round(t*n.scale+n.min)}}r+=l*o}else if("string"===i){const t=p(a.shape);u=[];for(let n=0;n<t;n++){const t=new Uint32Array(e.slice(r,r+4))[0];r+=4;const n=new Uint8Array(e.slice(r,r+t));u.push(n),r+=t}}else{const s=pt[i],a=e.slice(r,r+l*s);if("float32"===i)u=new Float32Array(a);else if("int32"===i)u=new Int32Array(a);else if("bool"===i)u=new Uint8Array(a);else{if("complex64"!==i)throw new Error(`Unsupported dtype in weight '${t}': ${i}`);{u=new Float32Array(a);const e=new Float32Array(u.length/2),s=new Float32Array(u.length/2);for(let t=0;t<e.length;t++)e[t]=u[2*t],s[t]=u[2*t+1];const r=ht(e,o,"float32"),i=ht(s,o,"float32");n[t]=ut(r,i),r.dispose(),i.dispose()}}r+=l*s}"complex64"!==i&&(n[t]=ht(u,o,i))}return n}function mt(e){if(null===e)throw new Error("Invalid input value: "+JSON.stringify(e));let t=0;const n=[];e.forEach(e=>{if(t+=e.byteLength,n.push(e.byteLength===e.buffer.byteLength?e:new e.constructor(e)),!(e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array))throw new Error("Unsupported TypedArray subtype: "+e.constructor.name)});const s=new Uint8Array(t);let r=0;return n.forEach(e=>{s.set(new Uint8Array(e.buffer),r),r+=e.byteLength}),s.buffer}const gt="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function yt(e){return gt?Buffer.byteLength(e):new Blob([e]).size}function bt(e){if(1===e.length)return e[0];let t=0;e.forEach(e=>{t+=e.byteLength});const n=new Uint8Array(t);let s=0;return e.forEach(e=>{n.set(new Uint8Array(e),s),s+=e.byteLength}),n.buffer}function xt(e){for(e=e.trim();e.endsWith("/");)e=e.slice(0,e.length-1);const t=e.split("/");return t[t.length-1]}function wt(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==e.modelTopology?0:yt(JSON.stringify(e.modelTopology)),weightSpecsBytes:null==e.weightSpecs?0:yt(JSON.stringify(e.weightSpecs)),weightDataBytes:null==e.weightData?0:e.weightData.byteLength}}function kt(){const e=function(){const e=e=>{let t=e<<13,n=0;for(;0==(8388608&t);)n-=8388608,t<<=1;return t&=-8388609,n+=947912704,t|n},t=new Uint32Array(2048);t[0]=0;for(let n=1;n<1024;n++)t[n]=e(n);for(let e=1024;e<2048;e++)t[e]=939524096+(e-1024<<13);return t}(),t=function(){const e=new Uint32Array(64);e[0]=0,e[31]=1199570944,e[32]=2147483648,e[63]=3347054592;for(let t=1;t<31;t++)e[t]=t<<23;for(let t=33;t<63;t++)e[t]=2147483648+(t-32<<23);return e}(),n=function(){const e=new Uint32Array(64);for(let t=0;t<64;t++)e[t]=1024;return e[0]=e[32]=0,e}();return s=>{const r=new ArrayBuffer(4*s.length),a=new Uint32Array(r);for(let r=0;r<s.length;r++){const i=s[r],o=e[n[i>>10]+(1023&i)]+t[i>>10];a[r]=o}return new Float32Array(r)}}class vt{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==vt.instance&&(vt.instance=new vt),vt.instance}static registerSaveRouter(e){vt.getInstance().saveRouters.push(e)}static registerLoadRouter(e){vt.getInstance().loadRouters.push(e)}static getSaveHandlers(e){return vt.getHandlers(e,"save")}static getLoadHandlers(e,t){return vt.getHandlers(e,"load",t)}static getHandlers(e,t,n){const s=[];return("load"===t?vt.getInstance().loadRouters:vt.getInstance().saveRouters).forEach(t=>{const r=t(e,n);null!==r&&s.push(r)}),s}}const Nt=e=>vt.getSaveHandlers(e),It=(e,t)=>vt.getLoadHandlers(e,t);function Ct(){if(!H().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const e="undefined"==typeof window?self:window,t=e.indexedDB||e.mozIndexedDB||e.webkitIndexedDB||e.msIndexedDB||e.shimIndexedDB;if(null==t)throw new Error("The current browser does not appear to support IndexedDB.");return t}function St(e){const t=e.result;t.createObjectStore("models_store",{keyPath:"modelPath"}),t.createObjectStore("model_info_store",{keyPath:"modelPath"})}class Tt{constructor(e){if(this.indexedDB=Ct(),null==e||!e)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=e}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,e)}async load(){return this.databaseAction(this.modelPath)}databaseAction(e,t){return new Promise((e,n)=>{const s=this.indexedDB.open("tensorflowjs",1);s.onupgradeneeded=()=>St(s),s.onsuccess=()=>{const r=s.result;if(null==t){const t=r.transaction("models_store","readonly"),s=t.objectStore("models_store").get(this.modelPath);s.onsuccess=()=>{if(null==s.result)return r.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));e(s.result.modelArtifacts)},s.onerror=e=>(r.close(),n(s.error)),t.oncomplete=()=>r.close()}else{const s=wt(t),a=r.transaction("model_info_store","readwrite");let i=a.objectStore("model_info_store");const o=i.put({modelPath:this.modelPath,modelArtifactsInfo:s});let l;o.onsuccess=()=>{l=r.transaction("models_store","readwrite");const o=l.objectStore("models_store").put({modelPath:this.modelPath,modelArtifacts:t,modelArtifactsInfo:s});o.onsuccess=()=>e({modelArtifactsInfo:s}),o.onerror=e=>{i=a.objectStore("model_info_store");const t=i.delete(this.modelPath);t.onsuccess=()=>(r.close(),n(o.error)),t.onerror=e=>(r.close(),n(o.error))}},o.onerror=e=>(r.close(),n(o.error)),a.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}}},s.onerror=e=>n(s.error)})}}Tt.URL_SCHEME="indexeddb://";const Et=e=>{return H().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Tt.URL_SCHEME)?(t=e.slice(Tt.URL_SCHEME.length),new Tt(t)):null;var t};vt.registerSaveRouter(Et),vt.registerLoadRouter(Et);class $t{constructor(){this.indexedDB=Ct()}async listModels(){return new Promise((e,t)=>{const n=this.indexedDB.open("tensorflowjs",1);n.onupgradeneeded=()=>St(n),n.onsuccess=()=>{const s=n.result,r=s.transaction("model_info_store","readonly"),a=r.objectStore("model_info_store").getAll();a.onsuccess=()=>{const t={};for(const e of a.result)t[e.modelPath]=e.modelArtifactsInfo;e(t)},a.onerror=e=>(s.close(),t(a.error)),r.oncomplete=()=>s.close()},n.onerror=e=>t(n.error)})}async removeModel(e){var t;return e=(t=e).startsWith(Tt.URL_SCHEME)?t.slice(Tt.URL_SCHEME.length):t,new Promise((t,n)=>{const s=this.indexedDB.open("tensorflowjs",1);s.onupgradeneeded=()=>St(s),s.onsuccess=()=>{const r=s.result,a=r.transaction("model_info_store","readwrite"),i=a.objectStore("model_info_store"),o=i.get(e);let l;o.onsuccess=()=>{if(null==o.result)return r.close(),n(new Error(`Cannot find model with path '${e}' in IndexedDB.`));{const s=i.delete(e),a=()=>{l=r.transaction("models_store","readwrite");const s=l.objectStore("models_store").delete(e);s.onsuccess=()=>t(o.result.modelArtifactsInfo),s.onerror=e=>n(o.error)};s.onsuccess=a,s.onerror=e=>(a(),r.close(),n(o.error))}},o.onerror=e=>(r.close(),n(o.error)),a.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}},s.onerror=e=>n(s.error)})}}const At="tensorflowjs_models",Rt="info",Ft="model_topology",Dt="weight_specs",_t="weight_data",Ot="model_metadata";function Mt(e){return{info:[At,e,Rt].join("/"),topology:[At,e,Ft].join("/"),weightSpecs:[At,e,Dt].join("/"),weightData:[At,e,_t].join("/"),modelMetadata:[At,e,Ot].join("/")}}function Lt(e){const t=e.split("/");if(t.length<3)throw new Error("Invalid key format: "+e);return t.slice(1,t.length-1).join("/")}class zt{constructor(e){if(!H().getBool("IS_BROWSER")||"undefined"==typeof window||void 0===window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==e||!e)throw new Error("For local storage, modelPath must not be null, undefined or empty.");this.modelPath=e,this.keys=Mt(this.modelPath)}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const t=JSON.stringify(e.modelTopology),n=JSON.stringify(e.weightSpecs),s=wt(e);try{this.LS.setItem(this.keys.info,JSON.stringify(s)),this.LS.setItem(this.keys.topology,t),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(e){if(gt)return Buffer.from(e).toString("base64");const t=new Uint8Array(e);let n="";for(let e=0,s=t.length;e<s;e++)n+=String.fromCharCode(t[e]);return btoa(n)}(e.weightData));const r={format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy};return null!=e.signature&&(r.signature=e.signature),null!=e.userDefinedMetadata&&(r.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(r.modelInitializer=e.modelInitializer),this.LS.setItem(this.keys.modelMetadata,JSON.stringify(r)),{modelArtifactsInfo:s}}catch(e){throw this.LS.removeItem(this.keys.info),this.LS.removeItem(this.keys.topology),this.LS.removeItem(this.keys.weightSpecs),this.LS.removeItem(this.keys.weightData),this.LS.removeItem(this.keys.modelMetadata),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${s.modelTopologyBytes}, weightSpecsBytes=${s.weightSpecsBytes}, weightDataBytes=${s.weightDataBytes}.`)}}}async load(){const e=JSON.parse(this.LS.getItem(this.keys.info));if(null==e)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==e.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const t={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);t.modelTopology=n;const s=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==s)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);t.weightSpecs=s;const r=this.LS.getItem(this.keys.modelMetadata);if(null!=r){const e=JSON.parse(r);t.format=e.format,t.generatedBy=e.generatedBy,t.convertedBy=e.convertedBy,null!=e.signature&&(t.signature=e.signature),null!=e.userDefinedMetadata&&(t.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(t.modelInitializer=e.modelInitializer)}const a=this.LS.getItem(this.keys.weightData);if(null==a)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return t.weightData=function(e){if(gt){const t=Buffer.from(e,"base64");return t.buffer.slice(t.byteOffset,t.byteOffset+t.byteLength)}const t=atob(e),n=new Uint8Array(t.length);for(let e=0;e<t.length;++e)n.set([t.charCodeAt(e)],e);return n.buffer}(a),t}}zt.URL_SCHEME="localstorage://";const Bt=e=>{return H().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(zt.URL_SCHEME)?(t=e.slice(zt.URL_SCHEME.length),new zt(t)):null;var t};vt.registerSaveRouter(Bt),vt.registerLoadRouter(Bt);class Pt{constructor(){l(H().getBool("IS_BROWSER"),()=>"Current environment is not a web browser"),l("undefined"==typeof window||void 0!==window.localStorage,()=>"Current browser does not appear to support localStorage"),this.LS=window.localStorage}async listModels(){const e={},t=At+"/",n="/"+Rt;for(let s=0;s<this.LS.length;++s){const r=this.LS.key(s);if(r.startsWith(t)&&r.endsWith(n)){e[Lt(r)]=JSON.parse(this.LS.getItem(r))}}return e}async removeModel(e){var t;const n=Mt(e=(t=e).startsWith(zt.URL_SCHEME)?t.slice(zt.URL_SCHEME.length):t);if(null==this.LS.getItem(n.info))throw new Error(`Cannot find model at path '${e}'`);const s=JSON.parse(this.LS.getItem(n.info));return this.LS.removeItem(n.info),this.LS.removeItem(n.topology),this.LS.removeItem(n.weightSpecs),this.LS.removeItem(n.weightData),s}}class Wt{constructor(){this.managers={}}static getInstance(){return null==Wt.instance&&(Wt.instance=new Wt),Wt.instance}static registerManager(e,t){l(null!=e,()=>"scheme must not be undefined or null."),e.endsWith("://")&&(e=e.slice(0,e.indexOf("://"))),l(e.length>0,()=>"scheme must not be an empty string.");const n=Wt.getInstance();l(null==n.managers[e],()=>`A model store manager is already registered for scheme '${e}'.`),n.managers[e]=t}static getManager(e){const t=this.getInstance().managers[e];if(null==t)throw new Error(`Cannot find model manager for scheme '${e}'`);return t}static getSchemes(){return Object.keys(this.getInstance().managers)}}function Vt(e){if(-1===e.indexOf("://"))throw new Error("The url string provided does not contain a scheme. Supported schemes are: "+Wt.getSchemes().join(","));return{scheme:e.split("://")[0],path:e.split("://")[1]}}async function Ut(e,t,n=!1){l(e!==t,()=>`Old path and new path are the same: '${e}'`);const s=vt.getLoadHandlers(e);l(s.length>0,()=>`Copying failed because no load handler is found for source URL ${e}.`),l(s.length<2,()=>`Copying failed because more than one (${s.length}) load handlers for source URL ${e}.`);const r=s[0],a=vt.getSaveHandlers(t);l(a.length>0,()=>`Copying failed because no save handler is found for destination URL ${t}.`),l(a.length<2,()=>`Copying failed because more than one (${s.length}) save handlers for destination URL ${t}.`);const i=a[0],o=Vt(e).scheme,u=Vt(e).path,c=o===Vt(e).scheme,h=await r.load();n&&c&&await Wt.getManager(o).removeModel(u);const p=await i.save(h);return n&&!c&&await Wt.getManager(o).removeModel(u),p.modelArtifactsInfo}class Gt{fetch(e,t){return fetch(e,t)}now(){return performance.now()}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error("Browser's encoder only supports utf-8, but got "+t);return null==this.textEncoder&&(this.textEncoder=new TextEncoder),this.textEncoder.encode(e)}decode(e,t){return new TextDecoder(t).decode(e)}}if(H().get("IS_BROWSER")){H().setPlatform("browser",new Gt);try{Wt.registerManager(zt.URL_SCHEME,new Pt)}catch(e){}try{Wt.registerManager(Tt.URL_SCHEME,new $t)}catch(e){}}const Ht=()=>require("node-fetch");let jt;class qt{constructor(){this.util=require("util"),this.textEncoder=new this.util.TextEncoder}fetch(e,t){return null!=H().global.fetch?H().global.fetch(e,t):(null==jt&&(jt=Ht()),jt(e,t))}now(){const e=process.hrtime();return 1e3*e[0]+e[1]/1e6}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error("Node built-in encoder only supports utf-8, but got "+t);return this.textEncoder.encode(e)}decode(e,t){return 0===e.length?"":new this.util.TextDecoder(t).decode(e)}}function Kt(e,t="float32",n){return t=t||"float32",P(e),new Ee(e,t,n)}H().get("IS_NODE")&&H().setPlatform("node",new qt);const Xt=lt({cast_:function(e,t){const n=it(e,"x","cast");if(!I(t))throw new Error("Failed to cast to unknown dtype "+t);if("string"===t&&"string"!==n.dtype||"string"!==t&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const s={x:n},r={dtype:t};return Ze.runKernel("Cast",s,r)}});const Yt=lt({clone_:function(e){const t={x:it(e,"x","clone","string_or_numeric")};return Ze.runKernel("Identity",t)}});function Jt(e,t=!1){console.log(e.toString(t))}Je(),Ae={buffer:Kt,cast:Xt,clone:Yt,print:Jt};function Zt(e){return new Promise(e=>setTimeout(e)).then(e)}class Qt{constructor(e){if(!H().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");e.startsWith(Qt.URL_SCHEME)&&(e=e.slice(Qt.URL_SCHEME.length)),null!=e&&0!==e.length||(e="model"),this.modelTopologyFileName=e+".json",this.weightDataFileName=e+".weights.bin"}async save(e){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const t=window.URL.createObjectURL(new Blob([e.weightData],{type:"application/octet-stream"}));if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=[{paths:["./"+this.weightDataFileName],weights:e.weightSpecs}],s={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:n};null!=e.signature&&(s.signature=e.signature),null!=e.userDefinedMetadata&&(s.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(s.modelInitializer=e.modelInitializer);const r=window.URL.createObjectURL(new Blob([JSON.stringify(s)],{type:"application/json"})),a=null==this.jsonAnchor?document.createElement("a"):this.jsonAnchor;if(a.download=this.modelTopologyFileName,a.href=r,await Zt(()=>a.dispatchEvent(new MouseEvent("click"))),null!=e.weightData){const e=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;e.download=this.weightDataFileName,e.href=t,await Zt(()=>e.dispatchEvent(new MouseEvent("click")))}return{modelArtifactsInfo:wt(e)}}}}Qt.URL_SCHEME="downloads://";class en{constructor(e){if(null==e||e.length<1)throw new Error("When calling browserFiles, at least 1 file is required, but received "+e);this.files=e}async load(){const e=this.files[0],t=this.files.slice(1);return new Promise((n,s)=>{const r=new FileReader;r.onload=r=>{const a=JSON.parse(r.target.result),i=a.modelTopology;if(null==i)return void s(new Error("modelTopology field is missing from file "+e.name));0===t.length&&n({modelTopology:i});const o=a.weightsManifest;if(null==o)return void s(new Error("weightManifest field is missing from file "+e.name));let l;try{l=this.checkManifestAndWeightFiles(o,t)}catch(e){return void s(e)}const u=[],c=[],h=[];o.forEach(e=>{e.paths.forEach(e=>{c.push(e),h.push(null)}),u.push(...e.weights)}),o.forEach(e=>{e.paths.forEach(e=>{const t=new FileReader;t.onload=t=>{const s=t.target.result,r=c.indexOf(e);if(h[r]=s,-1===h.indexOf(null)){const e={modelTopology:i,weightSpecs:u,weightData:bt(h),format:a.format,generatedBy:a.generatedBy,convertedBy:a.convertedBy};null!=a.signature&&(e.signature=a.signature),null!=a.userDefinedMetadata&&(e.userDefinedMetadata=a.userDefinedMetadata),null!=a.modelInitializer&&(e.modelInitializer=a.modelInitializer),n(e)}},t.onerror=t=>s(`Failed to weights data from file of path '${e}'.`),t.readAsArrayBuffer(l[e])})})},r.onerror=t=>s(`Failed to read model topology and weights manifest JSON from file '${e.name}'. BrowserFiles supports loading Keras-style tf.Model artifacts only.`),r.readAsText(e)})}checkManifestAndWeightFiles(e,t){const n=[],s=t.map(e=>xt(e.name)),r={};for(const a of e)a.paths.forEach(e=>{const a=xt(e);if(-1!==n.indexOf(a))throw new Error(`Duplicate file basename found in weights manifest: '${a}'`);if(n.push(a),-1===s.indexOf(a))throw new Error(`Weight file with basename '${a}' is not provided.`);r[e]=t[s.indexOf(a)]});if(n.length!==t.length)throw new Error(`Mismatch in the number of files in weights manifest (${n.length}) and the number of weight files provided (${t.length}).`);return r}}function tn(e,t,n,s){!function(e){l(null!=e&&Array.isArray(e)&&e.length>0,()=>"promises must be a none empty array")}(e),function(e,t){l(e>=0&&e<=1,()=>"Progress fraction must be in range [0, 1], but got startFraction "+e),l(t>=0&&t<=1,()=>"Progress fraction must be in range [0, 1], but got endFraction "+t),l(t>=e,()=>`startFraction must be no more than endFraction, but got startFraction ${e} and endFraction `+t)}(n=null==n?0:n,s=null==s?1:s);let r=0;return Promise.all(e.map(a=>(a.then(a=>{const i=n+ ++r/e.length*(s-n);return t(i),a}),a)))}async function nn(e,t){null==t&&(t={});const n=null==t.fetchFunc?H().platform.fetch:t.fetchFunc,s=e.map(e=>n(e,t.requestInit,{isBinary:!0})),r=(null==t.onProgress?await Promise.all(s):await tn(s,t.onProgress,0,.5)).map(e=>e.arrayBuffer());return null==t.onProgress?await Promise.all(r):await tn(r,t.onProgress,.5,1)}async function sn(e,t="",n,s){return rn(e=>nn(e,{requestInit:s}))(e,t,n)}function rn(e){return async(t,n="",s)=>{const r=t.map(()=>!1),a={},i=null!=s?s.map(()=>!1):[],o=[];if(t.forEach((e,t)=>{let n=0;e.weights.forEach(e=>{const l="quantization"in e?e.quantization.dtype:e.dtype,u=pt[l]*p(e.shape),c=()=>{r[t]=!0,null==a[t]&&(a[t]=[]),a[t].push({manifestEntry:e,groupOffset:n,sizeBytes:u})};null!=s?s.forEach((t,n)=>{t===e.name&&(c(),i[n]=!0)}):c(),o.push(e.name),n+=u})}),!i.every(e=>e)){const e=s.filter((e,t)=>!i[t]);throw new Error("Could not find weights in manifest with names: "+e.join(", ")+". \nManifest JSON has weights with names: "+o.join(", ")+".")}const l=r.reduce((e,t,n)=>(t&&e.push(n),e),[]),u=[];l.forEach(e=>{t[e].paths.forEach(e=>{const t=n+(n.endsWith("/")?"":"/")+e;u.push(t)})});const c=await e(u),h={};let d=0;return l.forEach(e=>{const n=t[e].paths.length;let s=0;for(let e=0;e<n;e++)s+=c[d+e].byteLength;const r=new ArrayBuffer(s),i=new Uint8Array(r);let o=0;for(let e=0;e<n;e++){const t=new Uint8Array(c[d+e]);i.set(t,o),o+=t.byteLength}a[e].forEach(e=>{const t=ft(r.slice(e.groupOffset,e.groupOffset+e.sizeBytes),[e.manifestEntry]);for(const e in t)h[e]=t[e]}),d+=n}),h}}vt.registerSaveRouter(e=>H().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Qt.URL_SCHEME)?function(e="model"){return new Qt(e)}(e.slice(Qt.URL_SCHEME.length)):null);class an{constructor(e,t){if(this.DEFAULT_METHOD="POST",null==t&&(t={}),this.weightPathPrefix=t.weightPathPrefix,this.onProgress=t.onProgress,this.weightUrlConverter=t.weightUrlConverter,null!=t.fetchFunc?(l("function"==typeof t.fetchFunc,()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)"),this.fetch=t.fetchFunc):this.fetch=H().platform.fetch,l(null!=e&&e.length>0,()=>"URL path for http must not be null, undefined or empty."),Array.isArray(e)&&l(2===e.length,()=>`URL paths for http must have a length of 2, (actual length is ${e.length}).`),this.path=e,null!=t.requestInit&&null!=t.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=t.requestInit||{}}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const t=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);t.body=new FormData;const n=[{paths:["./model.weights.bin"],weights:e.weightSpecs}],s={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:n};null!=e.signature&&(s.signature=e.signature),null!=e.userDefinedMetadata&&(s.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(s.modelInitializer=e.modelInitializer),t.body.append("model.json",new Blob([JSON.stringify(s)],{type:"application/json"}),"model.json"),null!=e.weightData&&t.body.append("model.weights.bin",new Blob([e.weightData],{type:"application/octet-stream"}),"model.weights.bin");const r=await this.fetch(this.path,t);if(r.ok)return{modelArtifactsInfo:wt(e),responses:[r]};throw new Error("BrowserHTTPRequest.save() failed due to HTTP response status "+r.status+".")}async load(){const e=await this.fetch(this.path,this.requestInit);if(!e.ok)throw new Error(`Request to ${this.path} failed with status code `+e.status+". Please verify this URL points to the model JSON of the model to load.");let t;try{t=await e.json()}catch(e){let t=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?t+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":t+=" Please make sure the server is serving valid JSON for this request.",new Error(t)}const n=t.modelTopology,s=t.weightsManifest,r=t.generatedBy,a=t.convertedBy,i=t.format,o=t.signature,l=t.userDefinedMetadata;if(null==n&&null==s)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);let u,c;if(null!=s){const e=await this.loadWeights(s);[u,c]=e}const h={modelTopology:n,weightSpecs:u,weightData:c,generatedBy:r,convertedBy:a,format:i};null!=o&&(h.signature=o),null!=l&&(h.userDefinedMetadata=l);const p=t.modelInitializer;return p&&(h.modelInitializer=p),h}async loadWeights(e){const t=Array.isArray(this.path)?this.path[1]:this.path,[n,s]=function(e){const t=e.lastIndexOf("/"),n=e.lastIndexOf("?"),s=e.substring(0,t),r=n>t?e.substring(n):"";return[s+"/",r]}(t),r=this.weightPathPrefix||n,a=[];for(const t of e)a.push(...t.weights);const i=[],o=[];for(const t of e)for(const e of t.paths)null!=this.weightUrlConverter?o.push(this.weightUrlConverter(e)):i.push(r+e+s);return this.weightUrlConverter&&i.push(...await Promise.all(o)),[a,bt(await nn(i,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress}))]}}function on(e){return null!=e.match(an.URL_SCHEME_REGEX)}an.URL_SCHEME_REGEX=/^https?:\/\//;const ln=(e,t)=>{if("undefined"==typeof fetch&&(null==t||null==t.fetchFunc))return null;{let n=!0;if(n=Array.isArray(e)?e.every(e=>on(e)):on(e),n)return un(e,t)}return null};function un(e,t){return new an(e,t)}function cn(e,t){return un(e,t)}vt.registerSaveRouter(ln),vt.registerLoadRouter(ln);class hn{constructor(e){this.modelArtifacts=e}async load(){return this.modelArtifacts}}class pn{constructor(e){this.saveHandler=e}async save(e){return this.saveHandler(e)}}var dn=Object.freeze({__proto__:null,browserFiles:function(e){return new en(e)},browserHTTPRequest:cn,concatenateArrayBuffers:bt,decodeWeights:ft,encodeWeights:dt,fromMemory:function(e,t,n,s){if(1===arguments.length){return null!=e.modelTopology||null!=e.weightSpecs?new hn(e):(console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new hn({modelTopology:e}))}return console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new hn({modelTopology:e,weightSpecs:t,weightData:n,trainingConfig:s})},getLoadHandlers:It,getModelArtifactsInfoForJSON:wt,getSaveHandlers:Nt,http:un,isHTTPScheme:on,loadWeights:sn,registerLoadRouter:e=>vt.registerLoadRouter(e),registerSaveRouter:e=>vt.registerSaveRouter(e),weightsLoaderFactory:rn,withSaveHandler:function(e){return new pn(e)},copyModel:async function(e,t){return Ut(e,t,!1)},listModels:async function(){const e=Wt.getSchemes(),t={};for(const n of e){const e=await Wt.getManager(n).listModels();for(const s in e){t[n+"://"+s]=e[s]}}return t},moveModel:async function(e,t){return Ut(e,t,!0)},removeModel:async function(e){const t=Vt(e);return Wt.getManager(t.scheme).removeModel(t.path)}});const fn=lt({matMul_:function(e,t,n=!1,s=!1){let r=it(e,"a","matMul"),a=it(t,"b","matMul");[r,a]=Ue(r,a);const i={a:r,b:a},o={transposeA:n,transposeB:s};return Ze.runKernel("BatchMatMul",i,o)}});const mn=lt({oneHot_:function(e,t,n=1,s=0){if(t<2)throw new Error("Error in oneHot: depth must be >=2, but it is "+t);const r={indices:it(e,"indices","oneHot","int32")},a={depth:t,onValue:n,offValue:s};return Ze.runKernel("OneHot",r,a)}});const gn=lt({transpose_:function(e,t){const n=it(e,"x","transpose");if(null==t&&(t=n.shape.map((e,t)=>t).reverse()),l(n.rank===t.length,()=>`Error in transpose: rank of input ${n.rank} must match length of perm ${t}.`),t.forEach(e=>{l(e>=0&&e<n.rank,()=>"All entries in 'perm' must be between 0 and "+(n.rank-1)+" but got "+t)}),n.rank<=1)return n.clone();const s={x:n},r={perm:t};return Ze.runKernel("Transpose",s,r)}});const yn=lt({confusionMatrix_:function(e,t,n){const s=it(e,"labels","confusionMatrix"),r=it(t,"predictions","confusionMatrix");l(null==n||n>0&&Number.isInteger(n),()=>"If provided, numClasses must be a positive integer, but got "+n),l(1===s.rank,()=>"Expected the rank of labels to be 1, but got "+s.rank),l(1===r.rank,()=>"Expected the rank of predictions to be 1, but got "+r.rank),l(s.shape[0]===r.shape[0],()=>`Mismatch in the number of examples: ${s.shape[0]} vs. ${r.shape[0]}. Labels and predictions should have the same number of elements.`),l(n>0&&Number.isInteger(n),()=>"numClasses is required to be a positive integer, but got "+n);const a=mn(Xt(s,"int32"),n),i=mn(Xt(r,"int32"),n),o=gn(a),u=fn(o,i);return Xt(u,"int32")}});var bn=Object.freeze({__proto__:null,confusionMatrix:yn});function xn(e,t,n){if(c(e),null!=t&&3!==t.length)throw new Error("tensor3d() requires shape to have three numbers");const s=rt(e,n);if(3!==s.length&&1!==s.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return ct(e,t,s,n)}let wn;const kn=lt({fromPixels_:function(e,t=3){if(t>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==e)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,s=!1,r=!1,a=!1,i=!1,o=!1;if(e.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&e instanceof ImageData)s=!0;else if("undefined"!=typeof HTMLVideoElement&&e instanceof HTMLVideoElement)r=!0;else if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement)a=!0;else if(null!=e.getContext)i=!0;else{if(!("undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap))throw new Error("pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was "+e.constructor.name);o=!0}if(r){const t=2;if(r&&e.readyState<t)throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.")}if(null!=le("FromPixels",Ze.backendName)){const n={pixels:e},s={numChannels:t};return Ze.runKernel("FromPixels",n,s)}const[l,u]=r?[e.videoWidth,e.videoHeight]:[e.width,e.height];let c,h;if(i?c=e.getContext("2d").getImageData(0,0,l,u).data:s||n?c=e.data:(a||r||o)&&(null==wn&&(wn=document.createElement("canvas").getContext("2d")),wn.canvas.width=l,wn.canvas.height=u,wn.drawImage(e,0,0,l,u),c=wn.getImageData(0,0,l,u).data),4===t)h=new Int32Array(c);else{const e=l*u;h=new Int32Array(e*t);for(let n=0;n<e;n++)for(let e=0;e<t;++e)h[n*t+e]=c[4*n+e]}return xn(h,[u,l,t],"int32")}});var vn=Object.freeze({__proto__:null,toPixels:async function(e,t){let n=it(e,"img","toPixels");if(!(e instanceof Fe)){const e=n;n=Xt(e,"int32"),e.dispose()}if(2!==n.rank&&3!==n.rank)throw new Error(`toPixels only supports rank 2 or 3 tensors, got rank ${n.rank}.`);const[s,r]=n.shape.slice(0,2),a=2===n.rank?1:n.shape[2];if(a>4||2===a)throw new Error("toPixels only supports depth of size 1, 3 or 4 but got "+a);if("float32"!==n.dtype&&"int32"!==n.dtype)throw new Error(`Unsupported type for toPixels: ${n.dtype}. Please use float32 or int32 tensors.`);const i=await n.data(),o="float32"===n.dtype?255:1,l=new Uint8ClampedArray(r*s*4);for(let e=0;e<s*r;++e){const t=[0,0,0,255];for(let s=0;s<a;s++){const r=i[e*a+s];if("float32"===n.dtype){if(r<0||r>1)throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${r}.`)}else if("int32"===n.dtype&&(r<0||r>255))throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${r}.`);1===a?(t[0]=r*o,t[1]=r*o,t[2]=r*o):t[s]=r*o}const s=4*e;l[s+0]=Math.round(t[0]),l[s+1]=Math.round(t[1]),l[s+2]=Math.round(t[2]),l[s+3]=Math.round(t[3])}if(null!=t){t.width=r,t.height=s;const e=t.getContext("2d"),n=new ImageData(l,r,s);e.putImageData(n,0,0)}return n!==e&&n.dispose(),l},fromPixels:kn});function Nn(e,t){const n=e.shape.length,s=t.shape.length;if(n<1)throw new Error(`tf.gatherND() expects the input to be rank 1 or higher, but the rank was ${n}.`);if(s<1)throw new Error(`tf.gatherND() expects the indices to be rank 1 or higher, but the rank was ${s}.`);if("int32"!==t.dtype)throw new Error(`tf.gatherND() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.shape[s-1]>n)throw new Error(`index innermost dimension length must be <= tensor rank; saw: ${t.shape[s-1]} vs. ${n}`);if(0===p(e.shape))throw new Error(`Requested more than 0 entries, but input is empty. Input shape: ${e.shape}.`);const r=t.shape,a=r[r.length-1];let i=1;for(let e=0;e<r.length-1;++e)i*=r[e];const o=e.shape,l=r.slice();l.pop();let u=1;for(let e=a;e<n;++e)u*=o[e],l.push(o[e]);const c=[...O(e.shape).map(e=>e/u),1].slice(0,a);return[l,i,u,c]}var In=Object.freeze({__proto__:null,prepareAndValidate:Nn});function Cn(e,t,n){const s=t.rank>1?t.shape[t.rank-1]:1,r=t.rank>1?t.rank-1:1,a="Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: "+n.shape+`, indices.shape: ${t.shape}, shape: ${e}`+`, sliceDim: ${s}, and batchDim: ${r}.`;if(n.rank<r)throw new Error(a+` update.rank < ${r}. `);if(e.length<s+(n.rank-r))throw new Error(a+" Output shape length < "+(s+(n.rank-r)));if(n.rank!==r+e.length-s)throw new Error(a+" update.rank != "+(r+e.length-s));for(let e=0;e<r;++e)if(n.shape[e]!==t.shape[e])throw new Error(a+` updates.shape[${e}] (${n.shape[e]}) != indices.shape[${e}] (${t.shape[e]}).`);for(let t=0;t<n.rank-r;++t)if(n.shape[t+r]!==e[t+s])throw new Error(a+` updates.shape[${t+r}] (${n.shape[t+r]}) != shape[${t+r}] (${e[t+r]})`)}function Sn(e,t,n){if(t.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==t.dtype)throw new Error("The dtype of 'indices' should be int32, but got dtype: "+t.dtype);if(n.length<1)throw new Error("Output rank must be greater or equal to 1, but got shape: "+n);if(0===n.length){if(0===t.size)throw new Error("Indices specified for empty output. indices shape: "+t.shape);if(0===e.size)throw new Error("Updates specified for empty output. updates shape: "+e.shape)}Cn(n,t,e)}function Tn(e,t,n){const s=t.shape.length,r=s>1?t.shape[s-1]:1,a=n.length;let i=1;for(let e=r;e<a;++e)i*=n[e];const o=r<1?1:r;return{sliceRank:r,numUpdates:p(t.shape)/o,sliceSize:i,strides:[...O(n.slice(0,r)),1],outputSize:p(n)}}var En=Object.freeze({__proto__:null,validateUpdateShape:Cn,validateInput:Sn,calculateShapes:Tn});function $n(e,t,n){const s=e.shape.length;l(s===t.length,()=>`Error in slice${s}D: Length of begin ${t} must match the rank of the array (${s}).`),l(s===n.length,()=>`Error in slice${s}D: Length of size ${n} must match the rank of the array (${s}).`);for(let r=0;r<s;++r)l(t[r]+n[r]<=e.shape[r],()=>`Error in slice${s}D: begin[${r}] + size[${r}] (${t[r]+n[r]}) would overflow input.shape[${r}] (${e.shape[r]})`)}function An(e){const t=[];let n=0;for(;e>0;)1&e&&t.push(n),e/=2,n++;return t}function Rn(e,t,n){const s=[];for(let r=0;r<e.length;r++)s[r]=Math.ceil((t[r]-e[r])/n[r]);return s}function Fn(e,t,n,s){const r=[...e];for(let e=r.length;e<s.length;e++)r.push(1);for(let e=0;e<n;e++)0===e?r[t]=1:(r.splice(t,0,1),r.pop());return r}function Dn(e,t,n){return n<=e?n:n-(t-1)}function _n(e,t){const n=[];for(let s=0;s<e;s++)n.push(t+s);return n}function On(e,t,n,s,r,a,i,o,l){const u=e.length;let c=new Array(u),h=new Array(u),p=new Array(u);if(t.length&&n>0){const l=t[0],u=n+1;c=Mn(i,l,u,s,e),h=Ln(o,l,u,r,e),p=Fn(a,l,u,e)}else for(let t=0;t<u;t++)c[t]=Bn(i,s,a,e,t,l),h[t]=Pn(o,r,a,e,t,l),p[t]=zn(a,t,l);return{begin:c,end:h,strides:p}}function Mn(e,t,n,s,r){const a=[...r],i=_n(n,t);for(let r=0;r<a.length;r++)if(i.indexOf(r)>-1)a[r]=0;else{const i=Dn(t,n,r);let o=s[i];e&1<<i&&(o=0),a[r]=o}return a}function Ln(e,t,n,s,r){const i=[...r],o=_n(n,t);for(let r=0;r<i.length;r++)if(o.indexOf(r)>-1)i[r]=Number.MAX_SAFE_INTEGER;else{const a=Dn(t,n,r);let o=s[a];e&1<<a&&(o=Number.MAX_SAFE_INTEGER),i[r]=o}for(let e=0;e<i.length;e++){const t=r[e];i[e]<0&&(i[e]+=t),i[e]=a(0,i[e],r[e])}return i}function zn(e,t,n){let s=e[t];return(n&1<<t||null==s)&&(s=1),s}function Bn(e,t,n,s,r,i){let o=t[r];const l=n[r]||1;(e&1<<r||i&1<<r||null==o)&&(o=l>0?Number.MIN_SAFE_INTEGER:Number.MAX_SAFE_INTEGER);const u=s[r];return o<0&&(o+=u),o=a(0,o,u-1),o}function Pn(e,t,n,s,r,i){let o=t[r];const l=n[r]||1;(e&1<<r||i&1<<r||null==o)&&(o=l>0?Number.MAX_SAFE_INTEGER:Number.MIN_SAFE_INTEGER);const u=s[r];return o<0&&(o+=u),o=l>0?a(0,o,u):a(-1,o,u-1),o}function Wn(e,t,n){let s=n.length;for(let e=0;e<n.length;e++)if(n[e]>1){s=e;break}for(let r=s+1;r<n.length;r++)if(t[r]>0||n[r]!==e[r])return!1;return!0}function Vn(e,t){let n=e.length>0?e[e.length-1]:1;for(let s=0;s<e.length-1;s++)n+=e[s]*t[s];return n}function Un(e,t,n){let s;const r=e.shape.length;let a;return s="number"==typeof t?[t,...new Array(r-1).fill(0)]:t.length<r?t.concat(new Array(r-t.length).fill(0)):t.slice(),s.forEach(e=>{l(-1!==e,()=>"slice() does not support negative begin indexing.")}),a=null==n?new Array(r).fill(-1):"number"==typeof n?[n,...new Array(r-1).fill(-1)]:n.length<r?n.concat(new Array(r-n.length).fill(-1)):n,a=a.map((t,n)=>t>=0?t:(l(-1===t,()=>`Negative size values should be exactly -1 but got ${t} for the slice() size at index ${n}.`),e.shape[n]-s[n])),[s,a]}function Gn(e,t,n,s,r,a,i,o,l){let u=t.slice(),c=n.slice(),h=s;null==s&&(h=new Array(u.length));const p=An(i);if(p.length>1)throw new Error("Multiple ellipses in slice is not allowed.");if(0!==i&&0!==o)throw new Error("Using both ellipsisMask and newAxisMask is not yet supported.");if(0!==i&&0!==l)throw new Error("Using both ellipsisMask and shrinkAxisMask is not yet supported.");const d=e.length-u.length,f=An(o),m=e.slice();f.forEach(e=>{u[e]=0,c[e]=1,m.splice(e,0,1)});const{begin:g,end:y,strides:b}=On(m,p,d,u,c,h,r,a,i);u=g,c=y,h=b;const x=An(l);x.forEach(e=>{c[e]=u[e]+1,h[e]=1});const w=Rn(u,c,h),k=w.filter((e,t)=>-1===x.indexOf(t));return{nonStrided:h.every(e=>1===e),$begin:u,$end:c,$strides:h,size:w,newShape:m,outShape:k}}var Hn=Object.freeze({__proto__:null,assertParamsValid:$n,maskToAxes:An,computeOutShape:Rn,stridesWithElidedDims:Fn,getNormalizedAxes:On,startIndicesWithElidedDims:Mn,stopIndicesWithElidedDims:Ln,stridesForAxis:zn,startForAxis:Bn,stopForAxis:Pn,isSliceContinous:Wn,computeFlatOffset:Vn,parseSliceParams:Un,sliceInfo:Gn});class jn{getClassName(){return this.constructor.className}static fromConfig(e,t){return new e(t)}}class qn{constructor(){this.classNameMap={}}static getMap(){return null==qn.instance&&(qn.instance=new qn),qn.instance}static register(e){qn.getMap().classNameMap[e.className]=[e,e.fromConfig]}}function Kn(e){l(null!=e.className,()=>"Class being registered does not have the static className property defined."),l("string"==typeof e.className,()=>"className is required to be a string, but got type "+typeof e.className),l(e.className.length>0,()=>"Class being registered has an empty-string as its className, which is disallowed."),qn.register(e)}var Xn=Object.freeze({__proto__:null,Serializable:jn,SerializationMap:qn,registerClass:Kn});function Yn(){return 32===Ze.backend.floatPrecision()?.001:.1}function Jn(e,t,n){let s=!0;if((S(e)||S(t))&&(s=!1),S(e)&&S(t)&&(s=!0),s){const n=e.constructor.name,s=t.constructor.name;if(n!==s)throw new Error(`Arrays are of different type. Actual: ${n}. Expected: `+s)}if(Array.isArray(e)&&Array.isArray(t)){const n=rt(e),s=rt(t);if(!d(n,s))throw new Error(`Arrays have different shapes. Actual: [${n}]. Expected: [${s}]`)}const r=S(e)?e:h(e),a=S(t)?t:h(t);if(r.length!==a.length)throw new Error(`Arrays have different lengths actual: ${r.length} vs expected: ${a.length}.\nActual:   ${r}.\nExpected: ${a}.`);for(let e=0;e<a.length;++e){const t=r[e],s=a[e];if(!n(t,s))throw new Error(`Arrays differ: actual[${e}] = ${t}, expected[${e}] = ${s}.\nActual:   ${r}.\nExpected: ${a}.`)}}function Zn(e,t,n){if(null==n&&(n=Yn()),!Qn(e,t,n))throw new Error(`Numbers differ: actual === ${e}, expected === ${t}`)}function Qn(e,t,n){return!isFinite(e)&&!isFinite(t)||!(isNaN(e)||isNaN(t)||Math.abs(e-t)>n)}var es=Object.freeze({__proto__:null,TEST_EPSILON_FLOAT16:.1,expectArraysClose:function(e,t,n){return null==n&&(n=Yn()),Jn(e,t,(e,t)=>Qn(e,t,n))},testEpsilon:Yn,expectPromiseToFail:function(e,t){e().then(()=>t.fail(),()=>t())},expectArraysEqual:function(e,t){const n="string"==typeof t||"number"==typeof t||"boolean"==typeof t?[t]:t;return $(e)||$(e[0])||$(t)||$(t[0])?Jn(e,n,(e,t)=>e==t):Jn(e,t,(e,t)=>Qn(e,t,0))},expectNumbersClose:Zn,expectValuesInRange:function(e,t,n){for(let s=0;s<e.length;s++)if(e[s]<t||e[s]>n)throw new Error(`Value out of range:${e[s]} low: ${t}, high: ${n}`)},expectArrayBuffersEqual:function(e,t){expect(new Float32Array(e)).toEqual(new Float32Array(t))},encodeStrings:function e(t){for(let n=0;n<t.length;n++){const s=t[n];Array.isArray(s)?e(s):t[n]=be(s)}return t}});function ts(e){H().getBool("DEPRECATION_WARNINGS_ENABLED")&&console.warn(e+" You can disable deprecation warnings with tf.disableDeprecationWarnings().")}function ns(){return Ze}function ss(){return Ze.memory()}function rs(e,t){return Ze.tidy(e,t)}function as(e){je(e).forEach(e=>e.dispose())}function is(e){return Ze.keep(e)}function os(e){return Ze.setBackend(e)}function ls(e,t,n=1){return Ze.registerBackend(e,t,n)}function us(){return Ze.backend}Re=ts;const cs=lt({add_:function(e,t){let n=it(e,"a","add"),s=it(t,"b","add");[n,s]=Ue(n,s);const r={a:n,b:s};return Ze.runKernel(X,r)}});const hs=lt({floorDiv_:function(e,t){let n=it(e,"a","floorDiv"),s=it(t,"b","floorDiv");[n,s]=Ue(n,s);const r={a:n,b:s};return Ze.runKernel("FloorDiv",r)}});const ps=lt({div_:function(e,t){let n=it(e,"a","div"),s=it(t,"b","div");if([n,s]=Ue(n,s),"int32"===n.dtype&&"int32"===s.dtype)return hs(n,s);const r={a:n,b:s};return Ze.runKernel("RealDiv",r,{})}});const ds=lt({mul_:function(e,t){let n=it(e,"a","mul"),s=it(t,"b","mul");[n,s]=Ue(n,s);const r={a:n,b:s};return Ze.runKernel("Multiply",r)}});const fs=lt({abs_:function(e){const t=it(e,"x","abs");if("complex64"===t.dtype){const e={x:t};return Ze.runKernel("ComplexAbs",e)}{const e={x:t};return Ze.runKernel("Abs",e)}}});const ms=lt({acos_:function(e){const t={x:it(e,"x","acos")};return Ze.runKernel("Acos",t)}});const gs=lt({acosh_:function(e){const t={x:it(e,"x","acosh")};return Ze.runKernel("Acosh",t)}});const ys=lt({addN_:function(e){l(Array.isArray(e),()=>"The argument passed to tf.addN() must be a list of tensors"),l(e.length>=1,()=>"Must pass at least one tensor to tf.addN(), but got "+e.length);const t=e.map((e,t)=>it(e,"tensors"+t,"addN")),n=t[0];t.forEach(e=>{if(e.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")}),t.forEach(e=>{if(!d(e.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")});const s=t;return Ze.runKernel("AddN",s)}});const bs=lt({all_:function(e,t=null,n=!1){const s={x:it(e,"x","all","bool")},r={axis:t,keepDims:n};return Ze.runKernel("All",s,r)}});const xs=lt({any_:function(e,t=null,n=!1){const s={x:it(e,"x","any","bool")},r={axis:t,keepDims:n};return Ze.runKernel("Any",s,r)}});const ws=lt({argMax_:function(e,t=0){const n={x:it(e,"x","argMax")},s={axis:t};return Ze.runKernel("ArgMax",n,s)}});const ks=lt({argMin_:function(e,t=0){const n={x:it(e,"x","argMin")},s={axis:t};return Ze.runKernel("ArgMin",n,s)}});const vs=lt({asin_:function(e){const t={x:it(e,"x","asin")};return Ze.runKernel("Asin",t)}});const Ns=lt({asinh_:function(e){const t={x:it(e,"x","asinh")};return Ze.runKernel("Asinh",t)}});const Is=lt({atan_:function(e){const t={x:it(e,"x","atan")};return Ze.runKernel("Atan",t)}});const Cs=lt({atan2_:function(e,t){let n=it(e,"a","atan2"),s=it(t,"b","atan2");[n,s]=Ue(n,s);const r={a:n,b:s};return Ze.runKernel("Atan2",r)}});const Ss=lt({atanh_:function(e){const t={x:it(e,"x","atanh")};return Ze.runKernel("Atanh",t)}});function Ts(e,t,n,s,r="NHWC",a){return As(e,[...t,e[3]],n,a,s,null,null,Bs(r))}function Es(e,t,n,s,r,a,i="channelsLast"){const[o,l]=Ds(t);let u;if("channelsLast"===i)u=[o,l,e[3],e[3]];else{if("channelsFirst"!==i)throw new Error("Unknown dataFormat "+i);u=[o,l,e[1],e[1]]}return As(e,u,n,s,r,a,!1,i)}function $s(e,t,n,s,r,a,i="NDHWC"){const[o,l,u]=_s(t);let c,h;if("NDHWC"===i)h="channelsLast",c=[o,l,u,e[4],e[4]];else{if("NCDHW"!==i)throw new Error("Unknown dataFormat "+i);h="channelsFirst",c=[o,l,u,e[1],e[1]]}return Rs(e,c,n,s,r,!1,h,a)}function As(e,t,n,s,r,a,i=!1,o="channelsLast"){let[l,u,c,h]=[-1,-1,-1,-1];if("channelsLast"===o)[l,u,c,h]=e;else{if("channelsFirst"!==o)throw new Error("Unknown dataFormat "+o);[l,h,u,c]=e}const[p,d,,f]=t,[m,g]=Ds(n),[y,b]=Ds(s),x=Os(p,y),w=Os(d,b),{padInfo:k,outHeight:v,outWidth:N}=function(e,t,n,s,r,a,i,o,l){let u,c,h;if("number"==typeof e){u={top:e,bottom:e,left:e,right:e,type:0===e?"VALID":"NUMBER"};const r=function(e,t,n,s,r){null==s&&(s=Fs(e,t,n));const a=e[0],i=e[1],o=Ms((a-t+2*s)/n+1,r),l=Ms((i-t+2*s)/n+1,r);return[o,l]}([t,n],a,s,e,o);c=r[0],h=r[1]}else if("same"===e){c=Math.ceil(t/s),h=Math.ceil(n/r);const e=Math.max(0,(c-1)*s+a-t),o=Math.max(0,(h-1)*r+i-n),l=Math.floor(e/2),p=e-l,d=Math.floor(o/2);u={top:l,bottom:p,left:d,right:o-d,type:"SAME"}}else if("valid"===e)u={top:0,bottom:0,left:0,right:0,type:"VALID"},c=Math.ceil((t-a+1)/s),h=Math.ceil((n-i+1)/r);else{if("object"!=typeof e)throw Error("Unknown padding parameter: "+e);{const p="channelsLast"===l?e[1][0]:e[2][0],d="channelsLast"===l?e[1][1]:e[2][1],f="channelsLast"===l?e[2][0]:e[3][0],m="channelsLast"===l?e[2][1]:e[3][1];u={top:p,bottom:d,left:f,right:m,type:0===p&&0===d&&0===f&&0===m?"VALID":"EXPLICIT"},c=Ms((t-a+p+d)/s+1,o),h=Ms((n-i+f+m)/r+1,o)}}return{padInfo:u,outHeight:c,outWidth:h}}(r,u,c,m,g,x,w,a,o),I=i?f*h:f;let C;return"channelsFirst"===o?C=[l,I,v,N]:"channelsLast"===o&&(C=[l,v,N,I]),{batchSize:l,dataFormat:o,inHeight:u,inWidth:c,inChannels:h,outHeight:v,outWidth:N,outChannels:I,padInfo:k,strideHeight:m,strideWidth:g,filterHeight:p,filterWidth:d,effectiveFilterHeight:x,effectiveFilterWidth:w,dilationHeight:y,dilationWidth:b,inShape:e,outShape:C,filterShape:t}}function Rs(e,t,n,s,r,a=!1,i="channelsLast",o){let[l,u,c,h,p]=[-1,-1,-1,-1,-1];if("channelsLast"===i)[l,u,c,h,p]=e;else{if("channelsFirst"!==i)throw new Error("Unknown dataFormat "+i);[l,p,u,c,h]=e}const[d,f,m,,g]=t,[y,b,x]=_s(n),[w,k,v]=_s(s),N=Os(d,w),I=Os(f,k),C=Os(m,v),{padInfo:S,outDepth:T,outHeight:E,outWidth:$}=function(e,t,n,s,r,a,i,o,l,u,c){let h,p,d,f;if("number"==typeof e){h={top:e,bottom:e,left:e,right:e,front:e,back:e,type:0===e?"VALID":"NUMBER"};const a=function(e,t,n,s,r,a){null==r&&(r=Fs(e,t,s));const i=e[0],o=e[1],l=e[2],u=Ms((i-t+2*r)/s+1,a),c=Ms((o-t+2*r)/s+1,a),h=Ms((l-t+2*r)/s+1,a);return[u,c,h,n]}([t,n,s,1],o,1,r,e,c);p=a[0],d=a[1],f=a[2]}else if("same"===e){p=Math.ceil(t/r),d=Math.ceil(n/a),f=Math.ceil(s/i);const e=(p-1)*r+o-t,c=(d-1)*a+l-n,m=(f-1)*i+u-s,g=Math.floor(e/2),y=e-g,b=Math.floor(c/2),x=c-b,w=Math.floor(m/2);h={top:b,bottom:x,left:w,right:m-w,front:g,back:y,type:"SAME"}}else{if("valid"!==e)throw Error("Unknown padding parameter: "+e);h={top:0,bottom:0,left:0,right:0,front:0,back:0,type:"VALID"},p=Math.ceil((t-o+1)/r),d=Math.ceil((n-l+1)/a),f=Math.ceil((s-u+1)/i)}return{padInfo:h,outDepth:p,outHeight:d,outWidth:f}}(r,u,c,h,y,b,x,N,I,C,o),A=a?g*p:g;let R;return"channelsFirst"===i?R=[l,A,T,E,$]:"channelsLast"===i&&(R=[l,T,E,$,A]),{batchSize:l,dataFormat:i,inDepth:u,inHeight:c,inWidth:h,inChannels:p,outDepth:T,outHeight:E,outWidth:$,outChannels:A,padInfo:S,strideDepth:y,strideHeight:b,strideWidth:x,filterDepth:d,filterHeight:f,filterWidth:m,effectiveFilterDepth:N,effectiveFilterHeight:I,effectiveFilterWidth:C,dilationDepth:w,dilationHeight:k,dilationWidth:v,inShape:e,outShape:R,filterShape:t}}function Fs(e,t,n,s=1){const r=Os(t,s);return Math.floor((e[0]*(n-1)-n+r)/2)}function Ds(e){return"number"==typeof e?[e,e,e]:2===e.length?[e[0],e[1],1]:e}function _s(e){return"number"==typeof e?[e,e,e]:e}function Os(e,t){return t<=1?e:e+(e-1)*(t-1)}function Ms(e,t){if(!t)return Math.trunc(e);switch(t){case"round":return Math.round(e);case"ceil":return Math.ceil(e);case"floor":return Math.floor(e);default:throw new Error("Unknown roundingMode "+t)}}function Ls(e){const[t,n,s]=Ds(e);return 1===t&&1===n&&1===s}function zs(e,t){return Ls(e)||Ls(t)}function Bs(e){if("NHWC"===e)return"channelsLast";if("NCHW"===e)return"channelsFirst";throw new Error("Unknown dataFormat "+e)}const Ps=lt({reshape_:function(e,t){const n={x:it(e,"x","reshape","string_or_numeric")},s={shape:t};return Ze.runKernel("Reshape",n,s)}});const Ws=lt({avgPool_:function(e,t,n,s,r){const a=it(e,"x","avgPool","float32");l(zs(n,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`);let i=a,o=!1;3===a.rank&&(o=!0,i=Ps(a,[1,a.shape[0],a.shape[1],a.shape[2]])),l(4===i.rank,()=>`Error in avgPool: x must be rank 4 but got rank ${i.rank}.`),null!=r&&l(f(s),()=>`Error in avgPool: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`);const u={x:i},c={filterSize:t,strides:n,pad:s,dimRoundingMode:r};let h=Ze.runKernel("AvgPool",u,c);return h=Xt(h,a.dtype),o?Ps(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Vs=lt({avgPool3d_:function(e,t,n,s,r,a="NDHWC"){const i=it(e,"x","avgPool3d","float32");let o=i,u=!1;4===i.rank&&(u=!0,o=Ps(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),l(5===o.rank,()=>`Error in avgPool3d: x must be rank 5 but got rank ${o.rank}.`),l("NDHWC"===a,()=>"Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of "+a),null!=r&&l(f(s),()=>`Error in avgPool3d: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`);const c={x:o},h={filterSize:t,strides:n,pad:s,dimRoundingMode:r,dataFormat:a};let p=Ze.runKernel("AvgPool3D",c,h);return p=Xt(p,o.dtype),u?Ps(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const Us=lt({concat_:function(e,t=0){l(e.length>=1,()=>"Pass at least one tensor to concat");const n=ot(e,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach(e=>{if("complex64"!==e.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${e.dtype}. `)}),1===n.length)return Yt(n[0]);const s=n,r={axis:t};return Ze.runKernel("Concat",s,r)}});const Gs=lt({sigmoid_:function(e){const t={x:it(e,"x","sigmoid")};return Ze.runKernel("Sigmoid",t)}});const Hs=lt({slice_:function(e,t,n){const s=it(e,"x","slice","string_or_numeric");if(0===s.rank)throw new Error("Slicing scalar is not possible");const r={x:s},a={begin:t,size:n};return Ze.runKernel("Slice",r,a)}});const js=lt({tanh_:function(e){const t={x:it(e,"x","tanh")};return Ze.runKernel("Tanh",t)}});const qs=lt({basicLSTMCell_:function(e,t,n,s,r,a){const i=it(e,"forgetBias","basicLSTMCell"),o=it(t,"lstmKernel","basicLSTMCell"),l=it(n,"lstmBias","basicLSTMCell"),u=it(s,"data","basicLSTMCell"),c=it(r,"c","basicLSTMCell"),h=it(a,"h","basicLSTMCell"),p=Us([u,h],1),d=fn(p,o),f=cs(d,l),m=f.shape[0],g=f.shape[1]/4,y=[m,g],b=Hs(f,[0,0],y),x=Hs(f,[0,g],y),w=Hs(f,[0,2*g],y),k=Hs(f,[0,3*g],y),v=cs(ds(Gs(b),js(x)),ds(c,Gs(cs(i,w))));return[v,ds(js(v),Gs(k))]}});const Ks=lt({batchToSpaceND_:function(e,t,n){const s=it(e,"x","batchToSpaceND"),r=t.reduce((e,t)=>e*t);l(s.rank>=1+t.length,()=>`input rank is ${s.rank} but should be > than blockShape.length ${t.length}`),l(n.length===t.length,()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`),l(s.shape[0]%r==0,()=>`input tensor batch is ${s.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${r}`);const a={x:s},i={blockShape:t,crops:n};return Ze.runKernel("BatchToSpaceND",a,i)}});const Xs=lt({batchNorm_:function(e,t,n,s,r,a){null==a&&(a=.001);const i=it(e,"x","batchNorm"),o=it(t,"mean","batchNorm"),u=it(n,"variance","batchNorm");let c,h;null!=r&&(c=it(r,"scale","batchNorm")),null!=s&&(h=it(s,"offset","batchNorm")),l(o.rank===u.rank,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),l(null==h||o.rank===h.rank,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),l(null==c||o.rank===c.rank,()=>"Batch normalization gradient requires mean and scale to have equal ranks.");const p={x:function(e){let t;return t=0===e.rank||1===e.rank?Ps(e,[1,1,1,e.size]):2===e.rank?Ps(e,[1,1,e.shape[0],e.shape[1]]):3===e.rank?Ps(e,[1,e.shape[0],e.shape[1],e.shape[2]]):e,t}(i),scale:c,offset:h,mean:o,variance:u},d={varianceEpsilon:a},f=Ze.runKernel("FusedBatchNorm",p,d);return Ps(f,i.shape)}});const Ys=lt({batchNorm2d_:function(e,t,n,s,r,a){const i=it(e,"x","batchNorm"),o=it(t,"mean","batchNorm"),u=it(n,"variance","batchNorm");let c,h;return null!=r&&(c=it(r,"scale","batchNorm")),null!=s&&(h=it(s,"offset","batchNorm")),l(2===i.rank,()=>"Error in batchNorm2D: x must be rank 2 but got rank "+i.rank+"."),l(2===o.rank||1===o.rank,()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${o.rank}.`),l(2===u.rank||1===u.rank,()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${u.rank}.`),null!=c&&l(2===c.rank||1===c.rank,()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${c.rank}.`),null!=h&&l(2===h.rank||1===h.rank,()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`),Xs(i,o,u,h,c,a)}});const Js=lt({batchNorm3d_:function(e,t,n,s,r,a){const i=it(e,"x","batchNorm"),o=it(t,"mean","batchNorm"),u=it(n,"variance","batchNorm");let c,h;return null!=r&&(c=it(r,"scale","batchNorm")),null!=s&&(h=it(s,"offset","batchNorm")),l(3===i.rank,()=>"Error in batchNorm3D: x must be rank 3 but got rank "+i.rank+"."),l(3===o.rank||1===o.rank,()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${o.rank}.`),l(3===u.rank||1===u.rank,()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${u.rank}.`),null!=c&&l(3===c.rank||1===c.rank,()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${c.rank}.`),null!=h&&l(3===h.rank||1===h.rank,()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`),Xs(i,o,u,h,c,a)}});const Zs=lt({batchNorm4d_:function(e,t,n,s,r,a){const i=it(e,"x","batchNorm"),o=it(t,"mean","batchNorm"),u=it(n,"variance","batchNorm");let c,h;return null!=r&&(c=it(r,"scale","batchNorm")),null!=s&&(h=it(s,"offset","batchNorm")),l(4===i.rank,()=>"Error in batchNorm4D: x must be rank 4 but got rank "+i.rank+"."),l(4===o.rank||1===o.rank,()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${o.rank}.`),l(4===u.rank||1===u.rank,()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${u.rank}.`),null!=c&&l(4===c.rank||1===c.rank,()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${c.rank}.`),null!=h&&l(4===h.rank||1===h.rank,()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`),Xs(i,o,u,h,c,a)}});const Qs=lt({bincount_:function(e,t,n){const s=it(e,"x","bincount"),r=it(t,"weights","bincount");l("int32"===s.dtype,()=>"Error in bincount: input dtype must be int32, but got "+s.dtype),l(n>=0,()=>`size must be non-negative, but got ${n}.`),l(r.size===s.size||0===r.size,()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${s.shape}, weights shape: `+r.shape+".");const a={x:s,weights:r},i={size:n};return Ze.runKernel("Bincount",a,i)}});const er=lt({broadcastTo_:function(e,t){let n=it(e,"broadcastTo","x");const s=n.shape;if(t.some(e=>!(e>0)||e%1!=0))throw new Error(`broadcastTo(): Invalid broadcast shape [${t}].`);if(t.length<n.rank)throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);if(t.length>n.rank){const e=n.shape.slice();for(;e.length<t.length;)e.unshift(1);n=Ps(n,e)}const r=n.shape,a=Array.from(t);for(let e=t.length-1;e>=0;e--)if(r[e]===t[e])a[e]=1;else if(1!==n.shape[e])throw new Error(`broadcastTo(): [${s}] cannot be broadcast to [${t}].`);if(0===a.map((e,t)=>e>1?t:-1).filter(e=>e>=0).length)return Yt(n);const i={x:n},o={reps:a};return Ze.runKernel("Tile",i,o)}});const tr=lt({ceil_:function(e){const t={x:it(e,"x","ceil")};return Ze.runKernel("Ceil",t)}});const nr=lt({clipByValue_:function(e,t,n){const s=it(e,"x","clipByValue");l(t<=n,()=>`Error in clip: min (${t}) must be less than or equal to max (${n}).`);const r={x:s},a={clipValueMin:t,clipValueMax:n};return Ze.runKernel("ClipByValue",r,a)}});const sr=lt({concat1d_:function(e){return Us(e,0)}});const rr=lt({concat2d_:function(e,t){return Us(e,t)}});const ar=lt({concat3d_:function(e,t){return Us(e,t)}});const ir=lt({concat4d_:function(e,t){return Us(e,t)}});const or=lt({conv2d_:function(e,t,n,s,r="NHWC",a=[1,1],i){const o=it(e,"x","conv2d"),u=it(t,"filter","conv2d");let c=o,h=!1;3===o.rank&&(h=!0,c=Ps(o,[1,o.shape[0],o.shape[1],o.shape[2]])),l(4===c.rank,()=>`Error in conv2d: input must be rank 4, but got rank ${c.rank}.`),l(4===u.rank,()=>"Error in conv2d: filter must be rank 4, but got rank "+u.rank+"."),null!=i&&l(f(s),()=>`Error in conv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`);const p="NHWC"===r?c.shape[3]:c.shape[1];l(p===u.shape[2],()=>`Error in conv2d: depth of input (${p}) must match input depth for filter ${u.shape[2]}.`),l(zs(n,a),()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`);const d={x:c,filter:u},m={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i},g=Ze.runKernel("Conv2D",d,m);return h?Ps(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const lr=lt({conv1d_:function(e,t,n,s,r="NWC",a=1,i){const o=it(e,"x","conv1d"),u=it(t,"filter","conv1d");let c=o,h=!1;2===o.rank&&(h=!0,c=Ps(o,[1,o.shape[0],o.shape[1]])),l(3===c.rank,()=>`Error in conv1d: input must be rank 3, but got rank ${c.rank}.`),l(3===u.rank,()=>"Error in conv1d: filter must be rank 3, but got rank "+u.rank+"."),null!=i&&l(f(s),()=>`Error in conv1d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`),l(c.shape[2]===u.shape[1],()=>`Error in conv1d: depth of input (${c.shape[2]}) must match input depth for filter ${u.shape[1]}.`),l(zs(n,a),()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${a}'`),l("NWC"===r,()=>`Error in conv1d: got dataFormat of ${r} but only NWC is currently supported.`);const p=Ps(u,[1,u.shape[0],u.shape[1],u.shape[2]]),d=Ps(c,[c.shape[0],1,c.shape[1],c.shape[2]]),m=or(d,p,[1,n],s,"NHWC",[1,a],i);return Ps(m,h?[m.shape[2],m.shape[3]]:[m.shape[0],m.shape[2],m.shape[3]])}});const ur=lt({conv2DBackpropInput_:function(e,t,n,s,r,a="NHWC",i){l(e.length===t.rank,()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`);let o=e,u=t,c=!1;3===t.rank&&(c=!0,u=Ps(t,[1,t.shape[0],t.shape[1],t.shape[2]]),o=[1,e[0],e[1],e[2]]),l(4===o.length,()=>"Error in conv2dDerInput: inShape must be length 4, but got length "+o.length+"."),l(4===u.rank,()=>"Error in conv2dDerInput: dy must be rank 4, but got rank "+u.rank),l(4===n.rank,()=>"Error in conv2dDerInput: filter must be rank 4, but got rank "+n.rank);const h="NHWC"===a?o[3]:o[1],p="NHWC"===a?u.shape[3]:u.shape[1];l(h===n.shape[2],()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`),l(p===n.shape[3],()=>`Error in conv2dDerInput: depth of output (${p}) must match output depth for filter ${n.shape[3]}.`),null!=i&&l(f(r),()=>`Error in conv2dDerInput: pad must be an integer when using, dimRoundingMode ${i} but got pad ${r}.`);const d={dy:u,filter:n},m={strides:s,pad:r,dataFormat:a,dimRoundingMode:i,inputShape:o},g=Ze.runKernel("Conv2DBackpropInput",d,m);return c?Ps(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const cr=lt({conv2dTranspose_:function(e,t,n,s,r,a){const i=it(e,"x","conv2dTranspose"),o=it(t,"filter","conv2dTranspose");return ur(n,i,o,s,r,"NHWC",a)}});const hr=lt({conv3d_:function(e,t,n,s,r="NDHWC",a=[1,1,1]){const i=it(e,"x","conv3d"),o=it(t,"filter","conv3d");let u=i,c=!1;4===i.rank&&(c=!0,u=Ps(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),l(5===u.rank,()=>`Error in conv3d: input must be rank 5, but got rank ${u.rank}.`),l(5===o.rank,()=>"Error in conv3d: filter must be rank 5, but got rank "+o.rank+"."),l(u.shape[4]===o.shape[3],()=>`Error in conv3d: depth of input (${u.shape[4]}) must match input depth for filter ${o.shape[3]}.`),l(zs(n,a),()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`),l("NDHWC"===r,()=>`Error in conv3d: got dataFormat of ${r} but only NDHWC is currently supported.`);const h={x:u,filter:o},p={strides:n,pad:s,dataFormat:r,dilations:a},d=Ze.runKernel("Conv3D",h,p);return c?Ps(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const pr=lt({conv3DBackpropInput_:function(e,t,n,s,r){l(e.length===t.rank,()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`);let a=e,i=t,o=!1;4===t.rank&&(o=!0,i=Ps(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]),a=[1,e[0],e[1],e[2],e[3]]);const u=a[4],c=i.shape[4];l(5===a.length,()=>"Error in conv3dDerInput: inShape must be length 5, but got length "+a.length+"."),l(5===i.rank,()=>"Error in conv3dDerInput: dy must be rank 5, but got rank "+i.rank),l(5===n.rank,()=>"Error in conv3dDerInput: filter must be rank 5, but got rank "+n.rank),l(u===n.shape[3],()=>`Error in conv3dDerInput: depth of input (${u}) must match input depth for filter ${n.shape[3]}.`),l(c===n.shape[4],()=>`Error in conv3dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[4]}.`);const h={dy:i,filter:n},p={pad:r,strides:s,inputShape:a},d=Ze.runKernel("Conv3DBackpropInputV2",h,p);return o?Ps(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const dr=lt({conv3dTranspose_:function(e,t,n,s,r){const a=it(e,"x","conv3dTranspose"),i=it(t,"filter","conv3dTranspose");return pr(n,a,i,s,r)}});const fr=lt({cos_:function(e){const t={x:it(e,"x","cos")};return Ze.runKernel(Y,t)}});const mr=lt({cosh_:function(e){const t={x:it(e,"x","cosh")};return Ze.runKernel("Cosh",t)}});const gr=lt({cumsum_:function(e,t=0,n=!1,s=!1){const r={x:it(e,"x","cumsum")},a={axis:t,exclusive:n,reverse:s};return Ze.runKernel("Cumsum",r,a)}});const yr=lt({denseBincount_:function(e,t,n,s=!1){const r=it(e,"x","denseBincount"),a=it(t,"weights","denseBincount");l("int32"===r.dtype,()=>"Error in denseBincount: input dtype must be int32, but got "+r.dtype),l(r.rank<=2,()=>`Error in denseBincount: input must be at most rank 2, but got rank ${r.rank}.`),l(n>=0,()=>`size must be non-negative, but got ${n}.`),l(a.size===r.size||0===a.size,()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${r.shape}, weights shape: `+a.shape+".");const i={x:r,weights:a},o={size:n,binaryOutput:s};return Ze.runKernel("DenseBincount",i,o)}});const br=lt({depthToSpace_:function(e,t,n="NHWC"){const s=it(e,"x","depthToSpace"),r="NHWC"===n?s.shape[1]:s.shape[2],a="NHWC"===n?s.shape[2]:s.shape[3],i="NHWC"===n?s.shape[3]:s.shape[1];l(r*t>=0,()=>`Negative dimension size caused by overflow when multiplying\n    ${r} and ${t}  for depthToSpace with input shape\n    ${s.shape}`),l(a*t>=0,()=>`Negative dimension size caused by overflow when multiplying\n    ${a} and ${t} for depthToSpace with input shape\n        ${s.shape}`),l(i%(t*t)==0,()=>`Dimension size must be evenly divisible by ${t*t} but is ${i} for depthToSpace with input shape ${s.shape}`);const o={x:s},u={blockSize:t,dataFormat:n};return Ze.runKernel("DepthToSpace",o,u)}});const xr=lt({depthwiseConv2d_:function(e,t,n,s,r="NHWC",a=[1,1],i){const o=it(e,"x","depthwiseConv2d"),u=it(t,"filter","depthwiseConv2d");let c=o,h=!1;3===o.rank&&(h=!0,c=Ps(o,[1,o.shape[0],o.shape[1],o.shape[2]])),l(4===c.rank,()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${c.rank}.`),l(4===u.rank,()=>"Error in depthwiseConv2d: filter must be rank 4, but got rank "+u.rank+"."),l(c.shape[3]===u.shape[2],()=>`Error in depthwiseConv2d: number of input channels (${c.shape[3]}) must match the inChannels dimension in filter ${u.shape[2]}.`),null!=i&&l(f(s),()=>`Error in depthwiseConv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`);const p={x:c,filter:u},d={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i},m=Ze.runKernel("DepthwiseConv2dNative",p,d);return h?Ps(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const wr=lt({diag_:function(e){const t={x:it(e,"x","diag")};return Ze.runKernel("Diag",t)}});const kr=lt({dilation2d_:function(e,t,n,s,r=[1,1],a="NHWC"){const i=it(e,"x","dilation2d"),o=it(t,"filter","dilation2d");l(3===i.rank||4===i.rank,()=>"Error in dilation2d: input must be rank 3 or 4, but got rank "+i.rank+"."),l(3===o.rank,()=>"Error in dilation2d: filter must be rank 3, but got rank "+o.rank+"."),l("NHWC"===a,()=>"Error in dilation2d: Only NHWC is currently supported, but got dataFormat of "+a);let u=i,c=!1;3===i.rank&&(u=Ps(i,[1,i.shape[0],i.shape[1],i.shape[2]]),c=!0);const h={x:u,filter:o},p={strides:n,pad:s,dilations:r},d=Ze.runKernel("Dilation2D",h,p);return c?Ps(d,[d.shape[1],d.shape[2],d.shape[3]]):d}});function vr(e,t){const n=e.length,s=[];for(let r=0;r<n;r++){const a=n-1-r,i=e[a]||1;(t[t.length-1-r]||1)>1&&1===i&&s.unshift(a)}return s}function Nr(e,t){const n=[];for(let s=0;s<t.length;s++){const r=e[e.length-s-1],a=t.length-s-1,i=t[a];(null==r||1===r&&i>1)&&n.unshift(a)}return n}function Ir(e,t){const n=[],s=Math.max(e.length,t.length);for(let r=0;r<s;r++){let s=e[e.length-r-1];null==s&&(s=1);let a=t[t.length-r-1];if(null==a&&(a=1),1===s)n.unshift(a);else if(1===a)n.unshift(s);else{if(s!==a){throw Error(`Operands could not be broadcast together with shapes ${e} and ${t}.`)}n.unshift(s)}}return n}const Cr=lt({equal_:function(e,t){let n=it(e,"a","equal"),s=it(t,"b","equal");[n,s]=Ue(n,s),Ir(n.shape,s.shape);const r={a:n,b:s};return Ze.runKernel("Equal",r)}});const Sr=lt({where_:function(e,t,n){const s=it(t,"a","where"),r=it(n,"b","where"),a=it(e,"condition","where","bool"),i=Ir(s.shape,r.shape),o=er(s,i),c=er(r,i);1===a.rank&&l(a.shape[0]===s.shape[0],()=>"The first dimension of `a` must match the size of `condition`."),1!==a.rank&&u(a.shape,c.shape,"Error in where: ");const h={condition:a,t:o,e:c};return Ze.runKernel("Select",h)}});const Tr=lt({zerosLike_:function(e){const t={x:it(e,"x","zerosLike")};return Ze.runKernel("ZerosLike",t)}});const Er=lt({divNoNan_:function(e,t){let n=it(e,"a","div"),s=it(t,"b","div");[n,s]=Ue(n,s);const r=ps(n,s),a=Tr(r),i=Cr(s,a);return Sr(i,a,r)}});const $r=lt({dot_:function(e,t){const n=it(e,"t1","dot"),s=it(t,"t2","dot");l(!(1!==n.rank&&2!==n.rank||1!==s.rank&&2!==s.rank),()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${s.rank}.`);const r=1===n.rank?n.size:n.shape[1],a=1===s.rank?s.size:s.shape[0];if(l(r===a,()=>`Error in dot: inner dimensions of inputs must match, but got ${r} and ${a}.`),1===n.rank&&1===s.rank){const e=Ps(n,[1,-1]),t=Ps(s,[-1,1]),r=fn(e,t);return Ps(r,[])}if(1===n.rank&&2===s.rank){const e=Ps(n,[1,-1]),t=Ps(s,[s.shape[0],s.shape[1]]),r=fn(e,t);return Ps(r,[r.size])}if(2===n.rank&&1===s.rank){const e=Ps(s,[-1,1]),t=fn(n,e);return Ps(t,[t.size])}{const e=Ps(s,[s.shape[0],s.shape[1]]);return fn(n,e)}}});const Ar=lt({elu_:function(e){const t={x:it(e,"x","elu")};return Ze.runKernel(J,t)}});const Rr=lt({erf_:function(e){let t=it(e,"x","erf");l("int32"===t.dtype||"float32"===t.dtype,()=>"Input dtype must be `int32` or `float32`."),"int32"===t.dtype&&(t=Xt(t,"float32"));const n={x:t};return Ze.runKernel(Z,n)}});const Fr=lt({exp_:function(e){const t={x:it(e,"x","exp")};return Ze.runKernel(Q,t)}});const Dr=lt({expandDims_:function(e,t=0){const n=it(e,"x","expandDims","string_or_numeric");l(t<=n.rank,()=>"Axis must be <= rank of the tensor");const s={input:n},r={dim:t};return Ze.runKernel("ExpandDims",s,r)}});const _r=lt({expm1_:function(e){const t={x:it(e,"x","expm1")};return Ze.runKernel("Expm1",t)}});const Or=lt({tile_:function(e,t){const n=it(e,"x","tile","string_or_numeric");l(n.rank===t.length,()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`);const s={x:n},r={reps:t};return Ze.runKernel("Tile",s,r)}});const Mr=lt({eye_:function(e,t,n,s="float32"){null==t&&(t=e);const r=Kt([e,t],s),a=e<=t?e:t;for(let e=0;e<a;++e)r.set(1,e,e);const i=Ps(r.toTensor(),[e,t]);if(null==n)return i;if(1===n.length)return Or(Dr(i,0),[n[0],1,1]);if(2===n.length)return Or(Dr(Dr(i,0),0),[n[0],n[1],1,1]);if(3===n.length)return Or(Dr(Dr(Dr(i,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function Lr(e,t,n){const s={shape:e,value:t,dtype:n};return Ze.runKernel("Fill",{},s)}const zr=lt({floor_:function(e){const t={x:it(e,"x","floor")};return Ze.runKernel("Floor",t)}});const Br=lt({gather_:function(e,t,n=0,s=0){const r={x:it(e,"x","gather"),indices:it(t,"indices","gather","int32")},a={axis:n,batchDims:s};return Ze.runKernel("GatherV2",r,a)}});const Pr=lt({greater_:function(e,t){let n=it(e,"a","greater"),s=it(t,"b","greater");[n,s]=Ue(n,s),Ir(n.shape,s.shape);const r={a:n,b:s};return Ze.runKernel("Greater",r)}});const Wr=lt({greaterEqual_:function(e,t){let n=it(e,"a","greaterEqual"),s=it(t,"b","greaterEqual");[n,s]=Ue(n,s),Ir(n.shape,s.shape);const r={a:n,b:s};return Ze.runKernel("GreaterEqual",r)}});const Vr=lt({imag_:function(e){const t={input:it(e,"input","imag")};return Ze.runKernel("Imag",t)}});const Ur=lt({isFinite_:function(e){const t={x:it(e,"x","isFinite")};return Ze.runKernel("IsFinite",t)}});const Gr=lt({isInf_:function(e){const t={x:it(e,"x","isInf")};return Ze.runKernel("IsInf",t)}});const Hr=lt({isNaN_:function(e){const t={x:it(e,"x","isNaN")};return Ze.runKernel("IsNan",t)}});const jr=lt({leakyRelu_:function(e,t=.2){const n={x:it(e,"x","leakyRelu")},s={alpha:t};return Ze.runKernel("LeakyRelu",n,s)}});const qr=lt({less_:function(e,t){let n=it(e,"a","less"),s=it(t,"b","less");[n,s]=Ue(n,s),Ir(n.shape,s.shape);const r={a:n,b:s};return Ze.runKernel("Less",r)}});const Kr=lt({lessEqual_:function(e,t){let n=it(e,"a","lessEqual"),s=it(t,"b","lessEqual");[n,s]=Ue(n,s),Ir(n.shape,s.shape);const r={a:n,b:s};return Ze.runKernel("LessEqual",r)}});function Xr(e,t,n){if(n<=0)throw new Error("The number of values should be positive.");const s={start:e,stop:t,num:n};return Ze.runKernel("LinSpace",{},s)}const Yr=lt({localResponseNormalization_:function(e,t=5,n=1,s=1,r=.5){const a=it(e,"x","localResponseNormalization");l(4===a.rank||3===a.rank,()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${a.rank}.`),l(f(t),()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`);let i=a,o=!1;3===a.rank&&(o=!0,i=Ps(a,[1,a.shape[0],a.shape[1],a.shape[2]]));const u={x:i},c={depthRadius:t,bias:n,alpha:s,beta:r},h=Ze.runKernel("LRN",u,c);return o?Ps(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Jr=lt({log_:function(e){const t={x:it(e,"x","log")};return Ze.runKernel(ee,t)}});const Zr=lt({log1p_:function(e){const t={x:it(e,"x","log1p")};return Ze.runKernel("Log1p",t)}});function Qr(e,t){l(D(e),()=>"The f passed in variableGrads(f) must be a function"),l(null==t||Array.isArray(t)&&t.every(e=>e instanceof _e),()=>"The varList passed in variableGrads(f, varList) must be an array of variables");const n=null!=t;if(!n){t=[];for(const e in Ze.registeredVariables)t.push(Ze.registeredVariables[e])}const s=n?t.filter(e=>!e.trainable):null,r=t.length;l((t=t.filter(e=>e.trainable)).length>0,()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${r} variables is trainable.`);const{value:a,grads:i}=Ze.gradients(e,t,null,!0);l(i.some(e=>null!=e),()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize()."),l(0===a.rank,()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${a.rank} tensor`);const o={};return t.forEach((e,t)=>{null!=i[t]&&(o[e.name]=i[t])}),null!=s&&s.forEach(e=>o[e.name]=null),{value:a,grads:o}}function ea(e){return Ze.customGrad(e)}function ta(e){if(e.filter(e=>null==e).length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that\n    the f you passed encloses all operations that lead from x to y.")}const na=lt({neg_:function(e){const t={x:it(e,"x","neg")};return Ze.runKernel("Neg",t)}});const sa=lt({softplus_:function(e){const t={x:it(e,"x","softplus")};return Ze.runKernel("Softplus",t)}});const ra=lt({logSigmoid_:function(e){const t=it(e,"x","logSigmoid");return ea(e=>({value:na(sa(na(e))),gradFunc:t=>ds(t,Gs(na(e)))}))(t)}});const aa=lt({max_:function(e,t=null,n=!1){const s={x:it(e,"x","max")},r={reductionIndices:t,keepDims:n};return Ze.runKernel("Max",s,r)}});const ia=lt({sub_:function(e,t){let n=it(e,"a","sub"),s=it(t,"b","sub");[n,s]=Ue(n,s);const r={a:n,b:s};return Ze.runKernel(re,r)}});const oa=lt({sum_:function(e,t=null,n=!1){let s=it(e,"x","sum");"bool"===s.dtype&&(s=Xt(s,"int32"));const r={x:s},a={axis:t,keepDims:n};return Ze.runKernel("Sum",r,a)}});const la=lt({logSoftmax_:function(e,t=-1){const n=it(e,"logits","logSoftmax");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);return ea((e,n)=>{const s=aa(e,t,!0),r=ia(e,s),a=ia(Xt(r,"float32"),Jr(oa(Fr(r),t,!0)));n([a]);return{value:a,gradFunc:(e,n)=>{const[s]=n,r=Fr(s);return ia(e,ds(oa(e,t,!0),r))}}})(n)}});function ua(e,t){for(let n=0;n<e.length;++n)if(e[e.length-n-1]!==t-1-n)return!1;return!0}function ca(e,t,n){const s=e.length+t.length,r=[];let a=0,i=0;for(let o=0;o<s;o++)-1===n.indexOf(o)?r.push(e[a++]):r.push(t[i++]);return r}function ha(e,t){const n=[],s=e.length;for(let r=0;r<s;r++)-1===t.indexOf(r)&&n.push(e[r]);return[n,t.map(t=>e[t])]}function pa(e,t){return ca(e,t.map(e=>1),t)}function da(e,t,n){l(ua(t,n),()=>e+" supports only inner-most axes for now. "+`Got axes ${t} and rank-${n} input.`)}function fa(e,t){if(ua(e,t))return null;const n=[];for(let s=0;s<t;++s)-1===e.indexOf(s)&&n.push(s);return e.forEach(e=>n.push(e)),n}function ma(e){return e.map((e,t)=>[t,e]).sort((e,t)=>e[1]-t[1]).map(e=>e[0])}function ga(e,t){const n=[];for(let s=t-e;s<t;++s)n.push(s);return n}const ya=lt({logSumExp_:function(e,t=null,n=!1){const s=it(e,"x","logSumExp"),r=x(t,s.shape),a=aa(s,r,!0),i=ia(s,a),o=Fr(i),l=oa(o,r),u=Jr(l),c=cs(Ps(a,u.shape),u);if(n){const e=pa(c.shape,r);return Ps(c,e)}return c}});const ba=lt({logicalAnd_:function(e,t){const n=it(e,"a","logicalAnd","bool"),s=it(t,"b","logicalAnd","bool");Ir(n.shape,s.shape);const r={a:n,b:s};return Ze.runKernel("LogicalAnd",r)}});const xa=lt({logicalNot_:function(e){const t={x:it(e,"x","logicalNot","bool")};return Ze.runKernel("LogicalNot",t)}});const wa=lt({logicalOr_:function(e,t){const n=it(e,"a","logicalOr","bool"),s=it(t,"b","logicalOr","bool");Ir(n.shape,s.shape);const r={a:n,b:s};return Ze.runKernel("LogicalOr",r)}});const ka=lt({logicalXor_:function(e,t){const n=it(e,"a","logicalXor","bool"),s=it(t,"b","logicalXor","bool");return Ir(n.shape,s.shape),ba(wa(e,t),xa(ba(e,t)))}});const va=lt({maxPool_:function(e,t,n,s,r){const a=it(e,"x","maxPool");let i=a,o=!1;3===a.rank&&(o=!0,i=Ps(a,[1,a.shape[0],a.shape[1],a.shape[2]])),l(4===i.rank,()=>`Error in maxPool: input must be rank 4 but got rank ${i.rank}.`),l(zs(n,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`),null!=r&&l(f(s),()=>`Error in maxPool: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`);const u={x:i},c={filterSize:t,strides:n,pad:s,dimRoundingMode:r},h=Ze.runKernel("MaxPool",u,c);return o?Ps(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Na=lt({maxPool3d_:function(e,t=[1,1,1],n,s,r,a="NDHWC"){const i=it(e,"x","maxPool3d");let o=i,u=!1;4===i.rank&&(u=!0,o=Ps(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),l(5===o.rank,()=>`Error in maxPool3d: x must be rank 5 but got rank ${o.rank}.`),l("NDHWC"===a,()=>"Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of "+a),null!=r&&l(f(s),()=>`Error in maxPool3d: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`);const c={x:o},h={filterSize:t,strides:n,pad:s,dimRoundingMode:r,dataFormat:a},p=Ze.runKernel("MaxPool3D",c,h);return u?Ps(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const Ia=lt({maxPoolWithArgmax_:function(e,t,n,s,r=!1){const a={x:it(e,"x","maxPoolWithArgmax")},i={filterSize:t,strides:n,pad:s,includeBatchInIndex:r},o=Ze.runKernel("MaxPoolWithArgmax",a,i);return{result:o[0],indexes:o[1]}}});const Ca=lt({maximum_:function(e,t){let n=it(e,"a","maximum"),s=it(t,"b","maximum");[n,s]=Ue(n,s),"bool"===n.dtype&&(n=Xt(n,"int32"),s=Xt(s,"int32")),Ir(n.shape,s.shape);const r={a:n,b:s};return Ze.runKernel("Maximum",r)}});const Sa=lt({mean_:function(e,t=null,n=!1){const s={x:it(e,"x","mean")},r={axis:t,keepDims:n};return Ze.runKernel("Mean",s,r)}});const Ta=lt({min_:function(e,t=null,n=!1){const s={x:it(e,"x","min")},r={axis:t,keepDims:n};return Ze.runKernel("Min",s,r)}});const Ea=lt({minimum_:function(e,t){let n=it(e,"a","minimum"),s=it(t,"b","minimum");[n,s]=Ue(n,s),"bool"===n.dtype&&(n=Xt(n,"int32"),s=Xt(s,"int32")),Ir(n.shape,s.shape);const r={a:n,b:s};return Ze.runKernel("Minimum",r)}});const $a=lt({mirrorPad_:function(e,t,n){l("reflect"===n||"symmetric"===n,()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`);const s=it(e,"x","mirrorPad");if(0===s.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");l(t.length===s.rank,()=>`Padding doesn't match input. Must be ${s.rank}. Got ${t.length}.`);const r="reflect"===n?1:0;for(let e=0;e<s.rank;e++)l(2===t[e].length,()=>"Invalid number of paddings. Must be length of 2 each."),l(t[e][0]>=0&&t[e][0]<=s.shape[e]-r&&t[e][1]>=0&&t[e][1]<=s.shape[e]-r,()=>`Padding in dimension ${e} cannot be greater than or equal to ${s.shape[e]-r} or less than 0 for input of shape `+s.shape);const a={paddings:t,mode:n},i={x:s};return Ze.runKernel("MirrorPad",i,a)}});const Aa=lt({mod_:function(e,t){let n=it(e,"a","mod"),s=it(t,"b","mod");[n,s]=Ue(n,s);const r={a:n,b:s};return Ze.runKernel(te,r)}});const Ra=lt({square_:function(e){const t=it(e,"x","square");return Ze.runKernel("Square",{x:t},{})}});const Fa=lt({moments_:function(e,t=null,n=!1){const s=x(t,(e=it(e,"x","moments")).shape),r=Sa(e,s,n);let a=r.shape;n||(a=pa(r.shape,s));const i=Ra(ia(Xt(e,"float32"),Ps(r,a)));return{mean:r,variance:Sa(i,s,n)}}});const Da=lt({multiRNNCell_:function(e,t,n,s){const r=it(t,"data","multiRNNCell"),a=ot(n,"c","multiRNNCell"),i=ot(s,"h","multiRNNCell");let o=r;const l=[];for(let t=0;t<e.length;t++){const n=e[t](o,a[t],i[t]);l.push(n[0]),l.push(n[1]),o=n[1]}const u=[],c=[];for(let e=0;e<l.length;e+=2)u.push(l[e]),c.push(l[e+1]);return[u,c]}});const _a=lt({multinomial_:function(e,t,n,s=!1){const r=it(e,"logits","multinomial"),a=r.size,i=r.rank;if(a<2)throw new Error("Error in multinomial: you need at least 2 outcomes, but got "+a+".");if(i>2)throw new Error("Rank of probabilities must be 1 or 2, but is "+i);n=n||Math.random();const o={logits:1===i?Ps(r,[1,-1]):r},l={numSamples:t,seed:n,normalized:s},u=Ze.runKernel("Multinomial",o,l);return 1===i?Ps(u,[u.size]):u}});const Oa=lt({notEqual_:function(e,t){let n=it(e,"a","notEqual"),s=it(t,"b","notEqual");[n,s]=Ue(n,s),Ir(n.shape,s.shape);const r={a:n,b:s};return Ze.runKernel("NotEqual",r)}});function Ma(e,t="float32"){if("complex64"===t){const t=Ma(e,"float32"),n=Ma(e,"float32");return ut(t,n)}const n=z(p(e),t);return Ze.makeTensor(n,e,t)}function La(e,t="float32"){if("complex64"===t){const t=La(e,"float32"),n=Ma(e,"float32");return ut(t,n)}const n=L(p(e),t);return Ze.makeTensor(n,e,t)}const za=lt({onesLike_:function(e){const t={x:it(e,"x","onesLike")};return Ze.runKernel("OnesLike",t)}});const Ba=lt({outerProduct_:function(e,t){const n=it(e,"v1","outerProduct"),s=it(t,"v2","outerProduct");l(1===n.rank&&1===s.rank,()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${s.rank}.`);const r=Ps(n,[-1,1]),a=Ps(s,[1,-1]);return fn(r,a)}});const Pa=lt({pad_:function(e,t,n=0){const s=it(e,"x","pad");if(0===s.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const r={paddings:t,constantValue:n},a={x:s};return Ze.runKernel("PadV2",a,r)}});const Wa=lt({pad1d_:function(e,t,n=0){return l(2===t.length,()=>"Invalid number of paddings. Must be length of 2."),Pa(e,[t],n)}});const Va=lt({pad2d_:function(e,t,n=0){return l(2===t.length&&2===t[0].length&&2===t[1].length,()=>"Invalid number of paddings. Must be length of 2 each."),Pa(e,t,n)}});const Ua=lt({pad3d_:function(e,t,n=0){return l(3===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length,()=>"Invalid number of paddings. Must be length of 2 each."),Pa(e,t,n)}});const Ga=lt({pad4d_:function(e,t,n=0){return l(4===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length&&2===t[3].length,()=>"Invalid number of paddings. Must be length of 2 each."),Pa(e,t,n)}});const Ha=lt({spaceToBatchND_:function(e,t,n){const s=it(e,"x","spaceToBatchND");l(s.rank>=1+t.length,()=>`input rank ${s.rank} should be > than [blockShape] ${t.length}`),l(n.length===t.length,()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`),l(s.shape.reduce((e,s,r)=>r>0&&r<=t.length?e&&(s+n[r-1][0]+n[r-1][1])%t[r-1]==0:e,!0),()=>`input spatial dimensions ${s.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`);const r={x:s},a={blockShape:t,paddings:n};return Ze.runKernel("SpaceToBatchND",r,a)}});const ja=lt({pool_:function(e,t,n,s,r,a){null==r&&(r=[1,1]),null==a&&(a=1),0===s&&(s="valid");const i=it(e,"x","maxPool");let o=i,u=!1;3===i.rank&&(u=!0,o=Ps(i,[1,i.shape[0],i.shape[1],i.shape[2]])),l(zs(a,r),()=>`Error in pool: Either strides or dilations must be 1. Got strides ${a} and dilations '${r}'`);const c=Es(o.shape,t,a,r,s),h=[c.dilationHeight,c.dilationWidth];let p;p="same"===s?function(e,t){const n=e.map((e,n)=>e+(e-1)*(t[n]-1)).map(e=>e-1),s=n.map(e=>Math.floor(e/2)),r=n.map((e,t)=>e-s[t]);return n.map((e,t)=>[s[t],r[t]])}([c.filterHeight,c.filterWidth],h):[[0,0],[0,0]];const d=1===h[0]&&1===h[1],[f,m]=function(e,t,n){const s=n.map(e=>e[0]),r=n.map(e=>e[1]),a=e.concat(s,r),i=t.map((e,t)=>(e-a[t]%e)%e),o=r.map((e,t)=>e+i[t]),l=t.map((e,t)=>[s[t],o[t]]),u=t.map((e,t)=>[0,i[t]]);return[l,u]}([c.inHeight,c.inWidth],h,p),g=d?s:"valid",y=d?o:Ha(o,h,f),b=("avg"===n?()=>Ws(y,t,a,g):()=>va(y,t,a,g))(),x=d?b:Ks(b,h,m);return u?Ps(x,[x.shape[1],x.shape[2],x.shape[3]]):x}});const qa=lt({pow_:function(e,t){let n=it(e,"base","pow"),s=it(t,"exp","pow");[n,s]=Ue(n,s);const r={a:n,b:s};return Ze.runKernel(ne,r)}});const Ka=lt({prelu_:function(e,t){const n={x:it(e,"x","prelu"),alpha:it(t,"alpha","prelu")};return Ze.runKernel("Prelu",n)}});const Xa=lt({prod_:function(e,t=null,n=!1){let s=it(e,"x","prod");"bool"===s.dtype&&(s=Xt(s,"int32"));const r={x:s},a={axis:t,keepDims:n};return Ze.runKernel("Prod",r,a)}});const Ya=lt({rand_:function(e,t,n){const s=p(e);let r=null;if(null==n||"float32"===n)r=new Float32Array(s);else if("int32"===n)r=new Int32Array(s);else{if("bool"!==n)throw new Error("Unknown data type "+n);r=new Uint8Array(s)}for(let e=0;e<s;e++)r[e]=t();return Ze.makeTensor(r,e,n)}});"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self&&self;function Ja(e,t){return e(t={exports:{}},t.exports),t.exports}var Za=Ja((function(e){!function(e,t,n){function s(e){var t,n=this,s=(t=4022871197,function(e){e=e.toString();for(var n=0;n<e.length;n++){var s=.02519603282416938*(t+=e.charCodeAt(n));s-=t=s>>>0,t=(s*=t)>>>0,t+=4294967296*(s-=t)}return 2.3283064365386963e-10*(t>>>0)});n.next=function(){var e=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=e-(n.c=0|e)},n.c=1,n.s0=s(" "),n.s1=s(" "),n.s2=s(" "),n.s0-=s(e),n.s0<0&&(n.s0+=1),n.s1-=s(e),n.s1<0&&(n.s1+=1),n.s2-=s(e),n.s2<0&&(n.s2+=1),s=null}function r(e,t){return t.c=e.c,t.s0=e.s0,t.s1=e.s1,t.s2=e.s2,t}function a(e,t){var n=new s(e),a=t&&t.state,i=n.next;return i.int32=function(){return 4294967296*n.next()|0},i.double=function(){return i()+11102230246251565e-32*(2097152*i()|0)},i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.alea=a}(0,e,!1)})),Qa=Ja((function(e){!function(e,t,n){function s(e){var t=this,n="";t.x=0,t.y=0,t.z=0,t.w=0,t.next=function(){var e=t.x^t.x<<11;return t.x=t.y,t.y=t.z,t.z=t.w,t.w^=t.w>>>19^e^e>>>8},e===(0|e)?t.x=e:n+=e;for(var s=0;s<n.length+64;s++)t.x^=0|n.charCodeAt(s),t.next()}function r(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor128=a}(0,e,!1)})),ei=Ja((function(e){!function(e,t,n){function s(e){var t=this,n="";t.next=function(){var e=t.x^t.x>>>2;return t.x=t.y,t.y=t.z,t.z=t.w,t.w=t.v,(t.d=t.d+362437|0)+(t.v=t.v^t.v<<4^e^e<<1)|0},t.x=0,t.y=0,t.z=0,t.w=0,t.v=0,e===(0|e)?t.x=e:n+=e;for(var s=0;s<n.length+64;s++)t.x^=0|n.charCodeAt(s),s==n.length&&(t.d=t.x<<10^t.x>>>4),t.next()}function r(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t.v=e.v,t.d=e.d,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorwow=a}(0,e,!1)})),ti=Ja((function(e){!function(e,t,n){function s(e){var t=this;t.next=function(){var e,n,s=t.x,r=t.i;return e=s[r],n=(e^=e>>>7)^e<<24,n^=(e=s[r+1&7])^e>>>10,n^=(e=s[r+3&7])^e>>>3,n^=(e=s[r+4&7])^e<<7,e=s[r+7&7],n^=(e^=e<<13)^e<<9,s[r]=n,t.i=r+1&7,n},function(e,t){var n,s=[];if(t===(0|t))s[0]=t;else for(t=""+t,n=0;n<t.length;++n)s[7&n]=s[7&n]<<15^t.charCodeAt(n)+s[n+1&7]<<13;for(;s.length<8;)s.push(0);for(n=0;n<8&&0===s[n];++n);for(8==n?s[7]=-1:s[n],e.x=s,e.i=0,n=256;n>0;--n)e.next()}(t,e)}function r(e,t){return t.x=e.x.slice(),t.i=e.i,t}function a(e,t){null==e&&(e=+new Date);var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&(a.x&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorshift7=a}(0,e,!1)})),ni=Ja((function(e){!function(e,t,n){function s(e){var t=this;t.next=function(){var e,n,s=t.w,r=t.X,a=t.i;return t.w=s=s+1640531527|0,n=r[a+34&127],e=r[a=a+1&127],n^=n<<13,e^=e<<17,n^=n>>>15,e^=e>>>12,n=r[a]=n^e,t.i=a,n+(s^s>>>16)|0},function(e,t){var n,s,r,a,i,o=[],l=128;for(t===(0|t)?(s=t,t=null):(t+="\0",s=0,l=Math.max(l,t.length)),r=0,a=-32;a<l;++a)t&&(s^=t.charCodeAt((a+32)%t.length)),0===a&&(i=s),s^=s<<10,s^=s>>>15,s^=s<<4,s^=s>>>13,a>=0&&(i=i+1640531527|0,r=0==(n=o[127&a]^=s+i)?r+1:0);for(r>=128&&(o[127&(t&&t.length||0)]=-1),r=127,a=512;a>0;--a)s=o[r+34&127],n=o[r=r+1&127],s^=s<<13,n^=n<<17,s^=s>>>15,n^=n>>>12,o[r]=s^n;e.w=i,e.X=o,e.i=r}(t,e)}function r(e,t){return t.i=e.i,t.w=e.w,t.X=e.X.slice(),t}function a(e,t){null==e&&(e=+new Date);var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&(a.X&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor4096=a}(0,e,!1)})),si=Ja((function(e){!function(e,t,n){function s(e){var t=this,n="";t.next=function(){var e=t.b,n=t.c,s=t.d,r=t.a;return e=e<<25^e>>>7^n,n=n-s|0,s=s<<24^s>>>8^r,r=r-e|0,t.b=e=e<<20^e>>>12^n,t.c=n=n-s|0,t.d=s<<16^n>>>16^r,t.a=r-e|0},t.a=0,t.b=0,t.c=-1640531527,t.d=1367130551,e===Math.floor(e)?(t.a=e/4294967296|0,t.b=0|e):n+=e;for(var s=0;s<n.length+20;s++)t.b^=0|n.charCodeAt(s),t.next()}function r(e,t){return t.a=e.a,t.b=e.b,t.c=e.c,t.d=e.d,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.tychei=a}(0,e,!1)})),ri=Ja((function(e){!function(t,n){var s,r=this,a=n.pow(256,6),i=n.pow(2,52),o=2*i;function l(e,l,d){var f=[],m=h(function e(t,n){var s,r=[],a=typeof t;if(n&&"object"==a)for(s in t)try{r.push(e(t[s],n-1))}catch(e){}return r.length?r:"string"==a?t:t+"\0"}((l=1==l?{entropy:!0}:l||{}).entropy?[e,p(t)]:null==e?function(){try{var e;return s&&(e=s.randomBytes)?e=e(256):(e=new Uint8Array(256),(r.crypto||r.msCrypto).getRandomValues(e)),p(e)}catch(e){var n=r.navigator,a=n&&n.plugins;return[+new Date,r,a,r.screen,p(t)]}}():e,3),f),g=new u(f),y=function(){for(var e=g.g(6),t=a,n=0;e<i;)e=256*(e+n),t*=256,n=g.g(1);for(;e>=o;)e/=2,t/=2,n>>>=1;return(e+n)/t};return y.int32=function(){return 0|g.g(4)},y.quick=function(){return g.g(4)/4294967296},y.double=y,h(p(g.S),t),(l.pass||d||function(e,t,s,r){return r&&(r.S&&c(r,g),e.state=function(){return c(g,{})}),s?(n.random=e,t):e})(y,m,"global"in l?l.global:this==n,l.state)}function u(e){var t,n=e.length,s=this,r=0,a=s.i=s.j=0,i=s.S=[];for(n||(e=[n++]);r<256;)i[r]=r++;for(r=0;r<256;r++)i[r]=i[a=255&a+e[r%n]+(t=i[r])],i[a]=t;(s.g=function(e){for(var t,n=0,r=s.i,a=s.j,i=s.S;e--;)t=i[r=255&r+1],n=256*n+i[255&(i[r]=i[a=255&a+t])+(i[a]=t)];return s.i=r,s.j=a,n})(256)}function c(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function h(e,t){for(var n,s=e+"",r=0;r<s.length;)t[255&r]=255&(n^=19*t[255&r])+s.charCodeAt(r++);return p(t)}function p(e){return String.fromCharCode.apply(0,e)}if(n.seedrandom=l,h(n.random(),t),e.exports){e.exports=l;try{s=require("crypto")}catch(e){}}else 0}([],Math)}));ri.alea=Za,ri.xor128=Qa,ri.xorwow=ei,ri.xorshift7=ti,ri.xor4096=ni,ri.tychei=si;var ai=ri.alea;class ii{constructor(e,t,n,s,r){this.mean=e,this.stdDev=t,this.dtype=n,this.nextVal=NaN,this.truncated=s,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const a=r||Math.random();this.random=ai(a.toString())}nextValue(){if(!isNaN(this.nextVal)){const e=this.nextVal;return this.nextVal=NaN,e}let e,t,n=!1;for(;!n;){let s,r,a;do{s=2*this.random()-1,r=2*this.random()-1,a=s*s+r*r}while(a>=1||0===a);const i=Math.sqrt(-2*Math.log(a)/a);e=this.mean+this.stdDev*s*i,t=this.mean+this.stdDev*r*i,this.truncated&&!this.isValidTruncated(e)||(n=!0)}return this.truncated&&!this.isValidTruncated(t)||(this.nextVal=this.convertValue(t)),this.convertValue(e)}convertValue(e){return null==this.dtype||"float32"===this.dtype?e:Math.round(e)}isValidTruncated(e){return e<=this.upper&&e>=this.lower}}class oi{constructor(e,t,n,s){this.alpha=e,this.beta=1/t,this.dtype=n;const r=s||Math.random();this.randu=ai(r.toString()),this.randn=new ii(0,1,n,!1,this.randu()),this.d=e<1?e+2/3:e-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let e,t,n,s,r,a;for(;;){do{s=this.randn.nextValue(),a=1+this.c*s}while(a<=0);if(a*=a*a,e=s*s,t=1-.331*e*e,n=.5*e+this.d*(1-a+Math.log(a)),r=this.randu(),r<t||Math.log(r)<n)break}return a=1/this.beta*this.d*a,this.alpha<1&&(a*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(a)}convertValue(e){return"float32"===this.dtype?e:Math.round(e)}}class li{constructor(e=0,t=1,n,s){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=e,this.range=t-e,this.dtype=n,null==s&&(s=Math.random()),"number"==typeof s&&(s=s.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);this.random=ai(s)}convertValue(e){return this.canReturnFloat()?e:Math.round(e)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const ui=lt({randomGamma_:function(e,t,n=1,s="float32",r){if(null==n&&(n=1),null==s&&(s="float32"),"float32"!==s&&"int32"!==s)throw new Error("Unsupported data type "+s);const a=new oi(t,n,s,r),i=Kt(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const ci=lt({randomNormal_:function(e,t=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error("Unsupported data type "+s);const a=new ii(t,n,s,!1,r),i=Kt(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const hi=lt({randomUniform_:function(e,t=0,n=1,s="float32",r){const a=Kt(e,s),i=new li(t,n,null,r);for(let e=0;e<a.values.length;e++)a.values[e]=i.nextValue();return a.toTensor()}});function pi(e,t,n=1,s="float32"){if(0===n)throw new Error("Cannot have a step of zero");const r={start:e,stop:t,step:n,dtype:s};return Ze.runKernel("Range",{},r)}const di=lt({real_:function(e){const t={input:it(e,"input","real")};return Ze.runKernel("Real",t)}});const fi=lt({reciprocal_:function(e){const t={x:it(e,"x","reciprocal")};return Ze.runKernel("Reciprocal",t)}});const mi=lt({relu_:function(e){const t={x:it(e,"x","relu")};return Ze.runKernel("Relu",t)}});const gi=lt({relu6_:function(e){const t={x:it(e,"x","relu6")};return Ze.runKernel("Relu6",t)}});const yi=lt({reverse_:function(e,t){const n={x:it(e,"x","reverse")},s={dims:t};return Ze.runKernel("Reverse",n,s)}});const bi=lt({reverse1d_:function(e){const t=it(e,"x","reverse");return l(1===t.rank,()=>`Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`),yi(t,0)}});const xi=lt({reverse2d_:function(e,t){const n=it(e,"x","reverse");return l(2===n.rank,()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`),yi(n,t)}});const wi=lt({reverse3d_:function(e,t){const n=it(e,"x","reverse");return l(3===n.rank,()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`),yi(n,t)}});const ki=lt({reverse4d_:function(e,t){const n=it(e,"x","reverse");return l(4===n.rank,()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`),yi(n,t)}});const vi=lt({round_:function(e){const t={x:it(e,"x","round")};return Ze.runKernel("Round",t)}});const Ni=lt({rsqrt_:function(e){const t={x:it(e,"x","rsqrt")};return Ze.runKernel("Rsqrt",t)}});function Ii(e,t){if((S(e)&&"string"!==t||Array.isArray(e))&&"complex64"!==t)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===t&&S(e)&&!(e instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return ct(e,[],[],t)}const Ci=lt({selu_:function(e){const t={x:it(e,"x","selu")};return Ze.runKernel("Selu",t)}});const Si=lt({separableConv2d_:function(e,t,n,s,r,a=[1,1],i="NHWC"){const o=it(e,"x","separableConv2d"),u=it(t,"depthwiseFilter","separableConv2d"),c=it(n,"pointwiseFilter","separableConv2d");let h=o,p=!1;if(3===o.rank&&(p=!0,h=Ps(o,[1,o.shape[0],o.shape[1],o.shape[2]])),"NCHW"===i)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");l(4===h.rank,()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`),l(4===u.rank,()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${u.rank}.`),l(4===c.rank,()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${u.rank}.`),l(1===c.shape[0],()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${c.shape[0]}.`),l(1===c.shape[1],()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${c.shape[1]}.`);const d=u.shape[2],f=u.shape[3];l(c.shape[2]===d*f,()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${d*f}, but got ${c.shape[2]}.`);const m=xr(h,u,s,r,i,a),g=or(m,c,1,"valid",i);return p?Ps(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const Ti=async function(e,t){const n=it(e,"x","setdiff1d"),s=it(t,"y","setdiff1d");l(n.dtype===s.dtype,()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${s.dtype}).`),l(1===n.rank,()=>`x should be 1D tensor, but got x (${n.shape}).`),l(1===s.rank,()=>`y should be 1D tensor, but got y (${s.shape}).`);const r=await n.data(),a=await s.data(),i=new Set(a);let o=0;for(let e=0;e<r.length;e++)i.has(r[e])||o++;const u=new Ee([o],n.dtype),c=new Ee([o],"int32");for(let e=0,t=0;e<r.length;e++)i.has(r[e])||(u.values[t]=r[e],c.values[t]=e,t++);return[u.toTensor(),c.toTensor()]};const Ei=lt({sign_:function(e){const t={x:it(e,"x","sign")};return Ze.runKernel("Sign",t)}});const $i=lt({sin_:function(e){const t={x:it(e,"x","sin")};return Ze.runKernel(se,t)}});const Ai=lt({sinh_:function(e){const t={x:it(e,"x","sinh")};return Ze.runKernel("Sinh",t)}});const Ri=lt({slice1d_:function(e,t,n){const s=it(e,"x","slice1d");return l(1===s.rank,()=>`slice1d expects a rank-1 tensor, but got a rank-${s.rank} tensor`),Hs(s,[t],[n])}});const Fi=lt({slice2d_:function(e,t,n){const s=it(e,"x","slice2d");return l(2===s.rank,()=>`slice2d expects a rank-2 tensor, but got a rank-${s.rank} tensor`),Hs(s,t,n)}});const Di=lt({slice3d_:function(e,t,n){const s=it(e,"x","slice3d");return l(3===s.rank,()=>`slice3d expects a rank-3 tensor, but got a rank-${s.rank} tensor`),Hs(s,t,n)}});const _i=lt({slice4d_:function(e,t,n){const s=it(e,"x","slice4d");return l(4===s.rank,()=>`slice4d expects a rank-4 tensor, but got a rank-${s.rank} tensor`),Hs(s,t,n)}});const Oi=lt({softmax_:function(e,t=-1){const n=it(e,"logits","softmax","float32");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);const s={logits:n},r={dim:t};return Ze.runKernel("Softmax",s,r)}});const Mi=lt({fft_:function(e){l("complex64"===e.dtype,()=>`The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`);const t={input:e};return Ze.runKernel("FFT",t)}});const Li=lt({ifft_:function(e){l("complex64"===e.dtype,()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`);const t={input:e};return Ze.runKernel("IFFT",t)}});const zi=lt({irfft_:function(e){const t=e.shape[e.shape.length-1],n=e.size/t;let s;if(t<=2){const r=Ps(e,[n,t]);s=Li(r)}else{const r=[n,2*(t-1)],a=Ps(di(e),[n,t]),i=Ps(Vr(e),[n,t]),o=yi(Hs(a,[0,1],[n,t-2]),1),l=ds(yi(Hs(i,[0,1],[n,t-2]),1),Ii(-1)),u=Us([a,o],1),c=Us([i,l],1),h=Ps(ut(u,c),[r[0],r[1]]);s=Li(h)}if(s=di(s),3===e.rank&&0!==e.shape[0]){const t=s,n=e.shape[0];s=Ps(s,[n,s.shape[0]/n,s.shape[1]]),t.dispose()}return s}});const Bi=lt({split_:function(e,t,n=0){const s={x:it(e,"x","split")},r={numOrSizeSplits:t,axis:n};return Ze.runKernel("SplitV",s,r)}});const Pi=lt({rfft_:function(e,t){l("float32"===e.dtype,()=>"The dtype for rfft() must be real value but got "+e.dtype);let n=e.shape[e.shape.length-1];const s=e.size/n;let r;if(null!=t&&t<n){const s=e.shape.map(e=>0),a=e.shape.map(e=>e);a[e.shape.length-1]=t,r=Hs(e,s,a),n=t}else if(null!=t&&t>n){const s=e.shape.map(e=>e);s[e.shape.length-1]=t-n,r=Us([e,Ma(s)],e.shape.length-1),n=t}else r=e;const a=Tr(r),i=Ps(ut(r,a),[s,n]),o=Mi(i),u=Math.floor(n/2)+1,c=di(o),h=Vr(o),p=Bi(c,[u,n-u],c.shape.length-1),d=Bi(h,[u,n-u],h.shape.length-1),f=r.shape.slice();return f[r.shape.length-1]=u,Ps(ut(p[0],d[0]),f)}});const Wi=lt({sqrt_:function(e){const t={x:it(e,"x","sqrt")};return Ze.runKernel("Sqrt",t)}});const Vi=lt({squaredDifference_:function(e,t){let n=it(e,"a","squaredDifference"),s=it(t,"b","squaredDifference");[n,s]=Ue(n,s),Ir(n.shape,s.shape);const r={a:n,b:s};return Ze.runKernel("SquaredDifference",r,{})}});const Ui=lt({squeeze_:function(e,t){const n=it(e,"x","squeeze");return Ps(n,w(n.shape,t).newShape)}});const Gi=lt({stack_:function(e,t=0){const n=ot(e,"tensors","stack","string_or_numeric");l(n.length>=1,()=>"Pass at least one tensor to tf.stack"),n.length>0&&l(t<=n[0].rank,()=>"Axis must be <= rank of the tensor");const s=n,r={axis:t};return Ze.runKernel("Pack",s,r)}});const Hi=lt({step_:function(e,t=0){const n={x:it(e,"x","step")},s={alpha:t};return Ze.runKernel("Step",n,s)}});const ji=lt({stridedSlice_:function(e,t,n,s,r=0,a=0,i=0,o=0,l=0){const u={x:it(e,"x","stridedSlice")},c={begin:t,end:n,strides:s,beginMask:r,endMask:a,ellipsisMask:i,newAxisMask:o,shrinkAxisMask:l};return Ze.runKernel("StridedSlice",u,c)}});const qi=lt({tan_:function(e){const t={x:it(e,"x","tan")};return Ze.runKernel(ae,t)}});function Ki(e,t){c(e);const n=rt(e,t);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return ct(e,null,n,t)}function Xi(e,t,n){if(c(e),null!=t&&2!==t.length)throw new Error("tensor2d() requires shape to have two numbers");const s=rt(e,n);if(2!==s.length&&1!==s.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return ct(e,t,s,n)}const Yi=lt({topk_:function(e,t=1,n=!0){const s=it(e,"x","topk");if(0===s.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const r=s.shape[s.shape.length-1];if(t>r)throw new Error(`'k' passed to topk() must be <= the last dimension (${r}) but got `+t);const a={x:s},i={k:t,sorted:n},[o,l]=Ze.runKernel("TopK",a,i);return{values:o,indices:l}}});const Ji=lt({truncatedNormal_:function(e,t=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error("Unsupported data type $ { dtype }");const a=new ii(t,n,s,!0,r),i=Kt(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const Zi=lt({unique_:function(e,t=0){const n=it(e,"x","unique","string_or_numeric");l(n.rank>0,()=>"The input tensor must be at least 1D");const s={x:n},r={axis:t},[a,i]=Ze.runKernel("Unique",s,r);return{values:a,indices:i}}});const Qi=lt({unsortedSegmentSum_:function(e,t,n){const s=it(e,"x","unsortedSegmentSum"),r=it(t,"segmentIds","unsortedSegmentSum","int32");l(f(n),()=>"numSegments must be of dtype int");const a={x:s,segmentIds:r},i={numSegments:n};return Ze.runKernel("UnsortedSegmentSum",a,i)}});const eo=lt({unstack_:function(e,t=0){const n=it(e,"x","unstack","string_or_numeric");l(t>=-n.shape.length&&t<n.shape.length,()=>`Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`);const s={value:n},r={axis:t};return Ze.runKernel("Unpack",s,r)}});function to(e,t=!0,n,s){return Ze.makeVariable(e,t,n,s)}function no(e,t){const n=[];for(let e=0;e<t.length;e++)t[e]&&n.push(e);const s=Kt(e,"int32"),r=Kt([n.length,e.length],"int32");for(let t=0;t<n.length;t++){const a=s.indexToLoc(n[t]),i=t*e.length;r.values.set(a,i)}return r.toTensor()}const so=async function(e){const t=it(e,"condition","whereAsync","bool"),n=await t.data(),s=no(t.shape,n);return e!==t&&t.dispose(),s};const ro=async function(e,t,n){const s=it(e,"tensor","boolMask"),r=it(t,"mask","boolMask","bool"),a=null==n?0:n,i=r.rank,o=s.shape;l(i>0,()=>"mask cannot be scalar"),u(o.slice(a,a+i),r.shape,"mask's shape must match the first K dimensions of tensor's shape,");let c=1;for(let e=a;e<a+i;e++)c*=o[e];const h=o.slice(0,a).concat([c],o.slice(a+i)),p=Ps(s,h),d=Ps(r,[-1]),f=await so(d),m=Ui(f,[1]),g=Br(p,m,a);return e!==s&&s.dispose(),t!==r&&r.dispose(),m.dispose(),p.dispose(),d.dispose(),f.dispose(),g};const ao=lt({norm_:function(e,t="euclidean",n=null,s=!1){const r=function e(t,n,s=null){if(0===t.rank)return fs(t);if(1!==t.rank&&null===s)return e(Ps(t,[-1]),n,s);if(1===t.rank||"number"==typeof s||Array.isArray(s)&&1===s.length){if(1===n)return oa(fs(t),s);if(n===1/0)return aa(fs(t),s);if(n===-1/0)return Ta(fs(t),s);if("euclidean"===n||2===n)return Wi(oa(qa(fs(t),Ii(2,"int32")),s));throw new Error("Error in norm: invalid ord value: "+n)}if(Array.isArray(s)&&2===s.length){if(1===n)return aa(oa(fs(t),s[0]),s[1]-1);if(n===1/0)return aa(oa(fs(t),s[1]),s[0]);if(n===-1/0)return Ta(oa(fs(t),s[1]),s[0]);if("fro"===n||"euclidean"===n)return Wi(oa(Ra(t),s));throw new Error("Error in norm: invalid ord value: "+n)}throw new Error("Error in norm: invalid axis: "+s)}(e=it(e,"x","norm"),t,n);let a=r.shape;if(s){const t=x(n,e.shape);a=pa(r.shape,t)}return Ps(r,a)}});const io=lt({movingAverage_:function(e,t,n,s,r=!0){const a=it(e,"v","movingAverage"),i=it(t,"x","movingAverage"),o=it(n,"decay","movingAverage");Ge(a,i),l(d(a.shape,i.shape),()=>"Shape mismatch in v and x");const u=Ii(1),c=ia(u,o);let h=ds(ia(i,a),c);if(r){l(null!=s,()=>"When using zeroDebias: true, step is required.");const e=it(s,"step","movingAverage");h=ps(h,ia(u,qa(o,e)))}return cs(a,h)}});const oo=lt({scatterND_:function(e,t,n){const s=it(e,"indices","scatterND","int32"),r=it(t,"updates","scatterND");Sn(r,s,n);const a={indices:s,updates:r},i={shape:n};return Ze.runKernel("ScatterNd",a,i)}});const lo=lt({sparseToDense_:function(e,t,n,s=0){const r=it(e,"sparseIndices","sparseToDense","int32"),a=it(t,"sparseValues","sparseToDense"),i=it(s,"defaultValue","sparseToDense",a.dtype);!function(e,t,n,s){if("int32"!==e.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);const r=e.rank>0?e.shape[0]:1,a=e.rank>1?e.shape[1]:1;if(n.length!==a)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${a}.`);const i=t.size;if(0!==t.rank&&(1!==t.rank||i!==r))throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${r}]`);if(t.dtype!==s.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(r,a,n,i);const o={sparseIndices:r,sparseValues:a,defaultValue:i},l={outputShape:n};return Ze.runKernel("SparseToDense",o,l)}});const uo=lt({gatherND_:function(e,t){const n=it(t,"indices","gatherND","int32"),s={params:it(e,"x","gatherND"),indices:n};return Ze.runKernel("GatherNd",s)}});const co=lt({dropout_:function(e,t,n,s){const r=it(e,"x","dropout");if(l("float32"===r.dtype,()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${r.dtype} tensor instead.`),l(t>=0&&t<1,()=>`rate must be a float in the range [0, 1), but got ${t}.`),0===t)return e instanceof Fe?r.clone():r;const a=function(e,t){if(null==t)return e.shape.slice();if(d(e.shape,t))return t;if(e.shape.length===t.length){const n=[];for(let s=0;s<e.shape.length;s++)null==t[s]&&null!=e.shape[s]?n.push(e.shape[s]):n.push(t[s]);return n}return t}(r,n),i=1-t,o=ps(zr(cs(hi(a,0,1,"float32",s),i)),i);return ds(r,o)}});function ho(e){return Math.floor(Math.pow(2,Math.ceil(Math.log(e)/Math.log(2))))}function po(e,t,n){const s=1-e%2,r=new Float32Array(e);for(let a=0;a<e;++a){const i=2*Math.PI*a/(e+s-1);r[a]=t-n*Math.cos(i)}return Ki(r,"float32")}const fo=async function(e,t,n=1){const s=it(e,"predictions","inTopK"),r=it(t,"targets","inTopK");l(s.rank>1,()=>"inTopK() expects the predictions to be of rank 2 or higher, but got "+s.rank),l(s.rank-1===r.rank,()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${s.rank} and targets rank ${r.rank}`),u(s.shape.slice(0,s.shape.length-1),r.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const a=s.shape[s.shape.length-1];l(n>0&&n<=a,()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${a}), but got ${n}`);const i=await s.data(),o=await r.data(),[c,h]=[i.length/a,a],p=k("bool",c);for(let e=0;e<c;e++){const t=e*h,s=i.subarray(t,t+h),r=[];for(let e=0;e<s.length;e++)r.push({value:s[e],index:e});r.sort((e,t)=>t.value-e.value),p[e]=0;for(let t=0;t<n;t++)if(r[t].index===o[e]){p[e]=1;break}}return e!==s&&s.dispose(),t!==r&&r.dispose(),ht(p,r.shape,"bool")};const mo=lt({conv2DBackpropFilter_:function(e,t,n,s,r,a="NHWC",i){let o=e;3===e.rank&&(o=Ps(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let u=t;3===u.rank&&(u=Ps(t,[1,t.shape[0],t.shape[1],t.shape[2]])),l(4===o.rank,()=>"Error in conv2dDerFilter: input must be rank 4, but got shape "+o.shape+"."),l(4===u.rank,()=>"Error in conv2dDerFilter: dy must be rank 4, but got shape "+u.shape+"."),l(4===n.length,()=>"Error in conv2dDerFilter: filterShape must be length 4, but got "+n+".");const c="NHWC"===a?o.shape[3]:o.shape[1],h="NHWC"===a?u.shape[3]:u.shape[1];l(c===n[2],()=>`Error in conv2dDerFilter: depth of input ${c}) must match input depth in filter (${n[2]}.`),l(h===n[3],()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`),null!=i&&l(f(r),()=>`Error in conv2dDerFilter: pad must be an integer when using, dimRoundingMode ${i} but got pad ${r}.`);const p={x:o,dy:u},d={strides:s,pad:r,dataFormat:a,dimRoundingMode:i,filterShape:n};return Ze.runKernel("Conv2DBackpropFilter",p,d)}});function go(e,t,n){if(null==n||"linear"===n)return e;if("relu"===n)return ds(e,Hi(t));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function yo(e,t){let n=t;const s=Nr(e.shape,t.shape);return s.length>0&&(n=oa(n,s)),Ps(n,e.shape)}function bo(e,t,n,s){if("linear"===t)return e;if("relu"===t)return mi(e);if("elu"===t)return Ar(e);if("relu6"===t)return gi(e);if("prelu"===t)return Ka(e,n);if("leakyrelu"===t)return jr(e,s);throw new Error(`Unknown fused activation ${t}.`)}const xo=(e,t)=>!(e>0)||"linear"===t;const wo=lt({fusedConv2d_:function({x:e,filter:t,strides:n,pad:s,dataFormat:r="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:o,activation:u="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(u=u||"linear",!1===xo(Ze.state.gradientDepth,u)){let l=or(e,t,n,s,r,a,i);return null!=o&&(l=cs(l,o)),bo(l,u,c,h)}const p=it(e,"x","conv2d"),d=it(t,"filter","conv2d");let m=p,g=!1;3===p.rank&&(g=!0,m=Ps(p,[1,p.shape[0],p.shape[1],p.shape[2]])),l(4===m.rank,()=>"Error in fused conv2d: input must be rank 4, but got rank "+m.rank+"."),l(4===d.rank,()=>"Error in fused conv2d: filter must be rank 4, but got rank "+d.rank+"."),null!=i&&l(f(s),()=>`Error in fused conv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`),l(m.shape[3]===d.shape[2],()=>`Error in conv2d: depth of input (${m.shape[3]}) must match input depth for filter ${d.shape[2]}.`),l(zs(n,a),()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`),l("NHWC"===r,()=>`Error in conv2d: got dataFormat of ${r} but only NHWC is currently supported.`);const y=As(m.shape,d.shape,n,a,s,i);let b,x;null!=o&&(b=it(o,"bias","fused conv2d"),[b]=Ue(b,p),Ir(y.outShape,b.shape)),null!=c&&(x=it(c,"prelu weights","fused conv2d"));const w=(e,t)=>{const[r,i,o,c]=t,h=go(e,o,u);l(Ls(a),()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`);const p=[ur(i.shape,h,r,n,s),mo(i,h,r.shape,n,s)];if(null!=c){const e=yo(c,h);p.push(e)}return p},k={x:m,filter:d,bias:b,preluActivationWeights:x},v={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i,activation:u,leakyreluAlpha:h};if(null==o){return ea((e,t,n)=>{let s=Ze.runKernel("FusedConv2D",k,v);return n([t,e,s]),g&&(s=Ps(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}})(m,d)}return ea((e,t,n,s)=>{let r=Ze.runKernel("FusedConv2D",k,v);return s([t,e,r,n]),g&&(r=Ps(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}})(m,d,b)}});const ko=lt({depthwiseConv2dNativeBackpropFilter_:function(e,t,n,s,r,a=[1,1],i){let o=e;3===e.rank&&(o=Ps(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=Ps(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={x:o,dy:l},c={strides:s,pad:r,dimRoundingMode:i,dilations:a,filterShape:n};return Ze.runKernel("DepthwiseConv2dNativeBackpropFilter",u,c)}});const vo=lt({depthwiseConv2dNativeBackpropInput_:function(e,t,n,s,r,a=[1,1],i){let o=t,l=!1;3===t.rank&&(l=!0,o=Ps(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={dy:o,filter:n},c={strides:s,pad:r,dimRoundingMode:i,dilations:a,inputShape:e},h=Ze.runKernel("DepthwiseConv2dNativeBackpropInput",u,c);return l?Ps(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const No=lt({fusedDepthwiseConv2d_:function({x:e,filter:t,strides:n,pad:s,dataFormat:r="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:o,activation:u="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(!1===xo(Ze.state.gradientDepth,u)){let l=xr(e,t,n,s,r,a,i);return null!=o&&(l=cs(l,o)),bo(l,u,c,h)}const p=it(e,"x","depthwiseConv2d"),d=it(t,"filter","depthwiseConv2d");let m=p,g=!1;3===p.rank&&(g=!0,m=Ps(p,[1,p.shape[0],p.shape[1],p.shape[2]])),l(4===m.rank,()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${m.rank}.`),l(4===d.rank,()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${d.rank}.`),l(m.shape[3]===d.shape[2],()=>`Error in fused depthwiseConv2d: number of input channels (${m.shape[3]}) must match the inChannels dimension in filter ${d.shape[2]}.`),null==a&&(a=[1,1]),l(zs(n,a),()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`),null!=i&&l(f(s),()=>`Error in fused depthwiseConv2d: pad must be an integer when using dimRoundingMode ${i} but got pad ${s}.`);const y=As(m.shape,d.shape,n,a,s,i,!0);let b,x;null!=o&&(b=it(o,"bias","fused conv2d"),[b]=Ue(b,p),Ir(y.outShape,b.shape)),null!=c&&(x=it(c,"prelu weights","fused depthwiseConv2d"));const w=(e,t)=>{l(Ls(a),()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${a}'`);const[r,o,c,h]=t,p=go(e,c,u),d=vo(o.shape,p,r,n,s,a,i),f=ko(o,p,r.shape,n,s,a,i);if(null!=h){return[d,f,yo(b,p)]}return[d,f]},k={x:m,filter:d,bias:b,preluActivationWeights:x},v={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i,activation:u,leakyreluAlpha:h};if(null==o){return ea((e,t,n)=>{let s=Ze.runKernel("FusedDepthwiseConv2D",k,v);return n([t,e,s]),g&&(s=Ps(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}})(m,d)}return ea((e,t,n,s)=>{let r=Ze.runKernel("FusedDepthwiseConv2D",k,v);return s([t,e,r,n]),g&&(r=Ps(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}})(m,d,b)}});const Io=lt({fusedMatMul_:function({a:e,b:t,transposeA:n=!1,transposeB:s=!1,bias:r,activation:a="linear",preluActivationWeights:i,leakyreluAlpha:o}){if(!1===xo(Ze.state.gradientDepth,a)){let l=fn(e,t,n,s);return null!=r&&(l=cs(l,r)),bo(l,a,i,o)}let u=it(e,"a","fused matMul"),c=it(t,"b","fused matMul");[u,c]=Ue(u,c);const h=n?u.shape[u.rank-2]:u.shape[u.rank-1],f=s?c.shape[c.rank-1]:c.shape[c.rank-2],m=n?u.shape[u.rank-1]:u.shape[u.rank-2],g=s?c.shape[c.rank-2]:c.shape[c.rank-1],y=u.shape.slice(0,-2),b=c.shape.slice(0,-2),x=p(y),w=p(b);l(u.rank>=2&&c.rank>=2&&u.rank===c.rank,()=>`Error in fused matMul: inputs must have the same rank of at least 2, got ranks ${u.rank} and ${c.rank}.`),l(d(y,b),()=>`Error in fused matMul: outer dimensions (${y}) and (${b}) of Tensors with shapes ${u.shape} and `+c.shape+" must match."),l(h===f,()=>`Error in fused matMul: inner shapes (${h}) and (${f}) of Tensors with shapes ${u.shape} and ${c.shape} and transposeA=${n} and transposeB=${s} must match.`);const k=u.shape.slice(0,-2).concat([m,g]),v=Ps(u,n?[x,h,m]:[x,m,h]),N=Ps(c,s?[w,g,f]:[w,f,g]);let I,C;null!=r&&(I=it(r,"bias","fused matMul"),[I]=Ue(I,u),Ir(k,I.shape)),null!=i&&(C=it(i,"prelu weights","fused matMul"));const S=(e,t)=>{const[i,o,l,u]=t,c=go(Ps(e,l.shape),l,a);let h,p;if(n||s?!n&&s?(h=fn(c,o,!1,!1),p=fn(c,i,!0,!1)):n&&!s?(h=fn(o,c,!1,!0),p=fn(i,c,!1,!1)):(h=fn(o,c,!0,!0),p=fn(c,i,!0,!0)):(h=fn(c,o,!1,!0),p=fn(i,c,!0,!1)),null!=r){return[h,p,yo(u,c)]}return[h,p]},T={a:v,b:N,bias:I,preluActivationWeights:C},E={transposeA:n,transposeB:s,activation:a,leakyreluAlpha:o};if(null==r){return ea((e,t,n)=>{const s=Ze.runKernel("_FusedMatMul",T,E);return n([e,t,s]),{value:Ps(s,k),gradFunc:S}})(v,N)}return ea((e,t,n,s)=>{const r=Ze.runKernel("_FusedMatMul",T,E);return s([e,t,r,n]),{value:Ps(r,k),gradFunc:S}})(v,N,I)}});var Co=Object.freeze({__proto__:null,conv2d:wo,depthwiseConv2d:No,matMul:Io});const So=lt({hammingWindow_:function(e){return po(e,.54,.46)}});const To=lt({hannWindow_:function(e){return po(e,.5,.5)}});const Eo=lt({frame_:function(e,t,n,s=!1,r=0){let a=0;const i=[];for(;a+t<=e.size;)i.push(Hs(e,a,t)),a+=n;if(s)for(;a<e.size;){const s=a+t-e.size,o=Us([Hs(e,a,t-s),Lr([s],r)]);i.push(o),a+=n}return 0===i.length?Xi([],[0,t]):Ps(Us(i),[i.length,t])}});const $o=lt({stft_:function(e,t,n,s,r=To){null==s&&(s=ho(t));const a=Eo(e,t,n),i=ds(a,r(t)),o=[];for(let e=0;e<a.shape[0];e++)o.push(Pi(Hs(i,[e,0],[1,t]),s));return Us(o)}});const Ao=lt({cropAndResize_:function(e,t,n,s,r="bilinear",a=0){const i=it(e,"image","cropAndResize"),o=it(t,"boxes","cropAndResize","float32"),u=it(n,"boxInd","cropAndResize","int32"),c=o.shape[0];l(4===i.rank,()=>`Error in cropAndResize: image must be rank 4,but got rank ${i.rank}.`),l(2===o.rank&&4===o.shape[1],()=>`Error in cropAndResize: boxes must be have size [${c},4] but had shape ${o.shape}.`),l(1===u.rank&&u.shape[0]===c,()=>`Error in cropAndResize: boxInd must be have size [${c}] but had shape ${o.shape}.`),l(2===s.length,()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${s.length}.`),l(s[0]>=1&&s[1]>=1,()=>"cropSize must be atleast [1,1], but was "+s),l("bilinear"===r||"nearest"===r,()=>"method must be bilinear or nearest, but was "+r);const h={image:i,boxes:o,boxInd:u},p={method:r,extrapolationValue:a,cropSize:s};return Ze.runKernel("CropAndResize",h,p)}});const Ro=lt({flipLeftRight_:function(e){const t=it(e,"image","flipLeftRight","float32");l(4===t.rank,()=>`Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`);const n={image:t};return Ze.runKernel("FlipLeftRight",n,{})}});const Fo=lt({rotateWithOffset_:function(e,t,n=0,s=.5){const r=it(e,"image","rotateWithOffset","float32");l(4===r.rank,()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${r.rank}.`);const a={image:r},i={radians:t,fillValue:n,center:s};return Ze.runKernel("RotateWithOffset",a,i)}});function Do(e,t,n,s,r,a){null==s&&(s=.5),null==r&&(r=Number.NEGATIVE_INFINITY),null==a&&(a=0);const i=e.shape[0];return n=Math.min(n,i),l(0<=s&&s<=1,()=>`iouThreshold must be in [0, 1], but was '${s}'`),l(2===e.rank,()=>`boxes must be a 2D tensor, but was of rank '${e.rank}'`),l(4===e.shape[1],()=>"boxes must have 4 columns, but 2nd dimension was "+e.shape[1]),l(1===t.rank,()=>"scores must be a 1D tensor"),l(t.shape[0]===i,()=>`scores has incompatible shape with boxes. Expected ${i}, but was `+t.shape[0]),l(0<=a&&a<=1,()=>`softNmsSigma must be in [0, 1], but was '${a}'`),{maxOutputSize:n,iouThreshold:s,scoreThreshold:r,softNmsSigma:a}}const _o=lt({nonMaxSuppression_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY){const a=it(e,"boxes","nonMaxSuppression"),i=it(t,"scores","nonMaxSuppression"),o=Do(a,i,n,s,r),l={maxOutputSize:n=o.maxOutputSize,iouThreshold:s=o.iouThreshold,scoreThreshold:r=o.scoreThreshold};return Ze.runKernel("NonMaxSuppressionV3",{boxes:a,scores:i},l)}});function Oo(e,t,n){const s=function(e,t,n){return function(e,t,n){let s=0,r=e.length,a=0,i=!1;for(;s<r;){a=s+(r-s>>>1);const o=n(t,e[a]);o>0?s=a+1:(r=a,i=!o)}return i?s:-s-1}(e,t,n||Mo)}(e,t,n),r=s<0?-(s+1):s;e.splice(r,0,t)}function Mo(e,t){return e>t?1:e<t?-1:0}function Lo(e,t,n,s,r){return Po(e,t,n,s,r,0)}function zo(e,t,n,s,r,a){return Po(e,t,n,s,r,0,!1,a,!0)}function Bo(e,t,n,s,r,a){return Po(e,t,n,s,r,a,!0)}function Po(e,t,n,s,r,a,i=!1,o=!1,l=!1){const u=[];for(let e=0;e<t.length;e++)t[e]>r&&u.push({score:t[e],boxIndex:e,suppressBeginIndex:0});u.sort(Uo);const c=a>0?-.5/a:0,h=[],p=[];for(;h.length<n&&u.length>0;){const t=u.pop(),{score:n,boxIndex:a,suppressBeginIndex:i}=t;if(n<r)break;let o=!1;for(let n=h.length-1;n>=i;--n){const i=Wo(e,a,h[n]);if(i>=s){o=!0;break}if(t.score=t.score*Vo(s,c,i),t.score<=r)break}t.suppressBeginIndex=h.length,o||(t.score===n?(h.push(a),p.push(t.score)):t.score>r&&Oo(u,t,Uo))}const d=h.length,f=n-d;o&&f>0&&(h.push(...new Array(f).fill(0)),p.push(...new Array(f).fill(0)));const m={selectedIndices:h};return i&&(m.selectedScores=p),l&&(m.validOutputs=d),m}function Wo(e,t,n){const s=e.subarray(4*t,4*t+4),r=e.subarray(4*n,4*n+4),a=Math.min(s[0],s[2]),i=Math.min(s[1],s[3]),o=Math.max(s[0],s[2]),l=Math.max(s[1],s[3]),u=Math.min(r[0],r[2]),c=Math.min(r[1],r[3]),h=Math.max(r[0],r[2]),p=Math.max(r[1],r[3]),d=(o-a)*(l-i),f=(h-u)*(p-c);if(d<=0||f<=0)return 0;const m=Math.max(a,u),g=Math.max(i,c),y=Math.min(o,h),b=Math.min(l,p),x=Math.max(y-m,0)*Math.max(b-g,0);return x/(d+f-x)}function Vo(e,t,n){const s=Math.exp(t*n*n);return n<=e?s:0}function Uo(e,t){return e.score-t.score||e.score===t.score&&t.boxIndex-e.boxIndex}const Go=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY){const a=it(e,"boxes","nonMaxSuppressionAsync"),i=it(t,"scores","nonMaxSuppressionAsync"),o=Do(a,i,n,s,r);n=o.maxOutputSize,s=o.iouThreshold,r=o.scoreThreshold;const l=await Promise.all([a.data(),i.data()]),u=l[0],c=l[1],{selectedIndices:h}=Lo(u,c,n,s,r);return a!==e&&a.dispose(),i!==t&&i.dispose(),Ki(h,"int32")};const Ho=lt({nonMaxSuppressionWithScore_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=0){const i=it(e,"boxes","nonMaxSuppression"),o=it(t,"scores","nonMaxSuppression"),l=Do(i,o,n,s,r,a),u={boxes:i,scores:o},c={maxOutputSize:n=l.maxOutputSize,iouThreshold:s=l.iouThreshold,scoreThreshold:r=l.scoreThreshold,softNmsSigma:a=l.softNmsSigma},h=Ze.runKernel("NonMaxSuppressionV5",u,c);return{selectedIndices:h[0],selectedScores:h[1]}}});const jo=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=0){const i=it(e,"boxes","nonMaxSuppressionAsync"),o=it(t,"scores","nonMaxSuppressionAsync"),l=Do(i,o,n,s,r,a);n=l.maxOutputSize,s=l.iouThreshold,r=l.scoreThreshold,a=l.softNmsSigma;const u=await Promise.all([i.data(),o.data()]),c=u[0],h=u[1],{selectedIndices:p,selectedScores:d}=Bo(c,h,n,s,r,a);return i!==e&&i.dispose(),o!==t&&o.dispose(),{selectedIndices:Ki(p,"int32"),selectedScores:Ki(d)}};const qo=lt({nonMaxSuppressionPadded_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=!1){const i=it(e,"boxes","nonMaxSuppression"),o=it(t,"scores","nonMaxSuppression"),l=Do(i,o,n,s,r,null),u={boxes:i,scores:o},c={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:a},h=Ze.runKernel("NonMaxSuppressionV4",u,c);return{selectedIndices:h[0],validOutputs:h[1]}}});const Ko=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=!1){const i=it(e,"boxes","nonMaxSuppressionAsync"),o=it(t,"scores","nonMaxSuppressionAsync"),l=Do(i,o,n,s,r,null),u=l.maxOutputSize,c=l.iouThreshold,h=l.scoreThreshold,[p,d]=await Promise.all([i.data(),o.data()]),{selectedIndices:f,validOutputs:m}=zo(p,d,u,c,h,a);return i!==e&&i.dispose(),o!==t&&o.dispose(),{selectedIndices:Ki(f,"int32"),validOutputs:Ii(m,"int32")}};const Xo=lt({resizeBilinear_:function(e,t,n=!1,s=!1){const r=it(e,"images","resizeBilinear");l(3===r.rank||4===r.rank,()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${r.rank}.`),l(2===t.length,()=>"Error in resizeBilinear: new shape must 2D, but got shape "+t+"."),l(!1===s||!1===n,()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false.");let a=r,i=!1;3===r.rank&&(i=!0,a=Ps(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const[]=t,o={images:a},u={alignCorners:n,halfPixelCenters:s,size:t},c=Ze.runKernel("ResizeBilinear",o,u);return i?Ps(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const Yo=lt({resizeNearestNeighbor_:function(e,t,n=!1,s=!1){const r=it(e,"images","resizeNearestNeighbor");l(3===r.rank||4===r.rank,()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${r.rank}.`),l(2===t.length,()=>"Error in resizeNearestNeighbor: new shape must 2D, but got shape "+t+"."),l("float32"===r.dtype||"int32"===r.dtype,()=>"`images` must have `int32` or `float32` as dtype"),l(!1===s||!1===n,()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false.");let a=r,i=!1;3===r.rank&&(i=!0,a=Ps(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const[]=t,o={images:a},u={alignCorners:n,halfPixelCenters:s,size:t},c=Ze.runKernel("ResizeNearestNeighbor",o,u);return i?Ps(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const Jo=lt({bandPart_:function(e,t,n){l(t%1==0,()=>`bandPart(): numLower must be an integer, got ${t}.`),l(n%1==0,()=>`bandPart(): numUpper must be an integer, got ${n}.`);const s=it(e,"a","bandPart");l(s.rank>=2,()=>`bandPart(): Rank must be at least 2, got ${s.rank}.`);const r=s.shape,[a,i]=s.shape.slice(-2);if(!(t<=a))throw new Error(`bandPart(): numLower (${t}) must not be greater than the number of rows (${a}).`);if(!(n<=i))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${i}).`);t<0&&(t=a),n<0&&(n=i);const o=Ps(pi(0,a,1,"int32"),[-1,1]),u=pi(0,i,1,"int32"),c=ia(o,u),h=ba(Kr(c,Ii(+t,"int32")),Wr(c,Ii(-n,"int32"))),p=Ma([a,i],s.dtype);return Ps(Gi(eo(Ps(s,[-1,a,i])).map(e=>Sr(h,e,p))),r)}});const Zo=lt({gramSchmidt_:function(e){let t;if(Array.isArray(e)){t=!1,l(null!=e&&e.length>0,()=>"Gram-Schmidt process: input must not be null, undefined, or empty");const n=e[0].shape[0];for(let t=1;t<e.length;++t)l(e[t].shape[0]===n,()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[t].shape[0]} vs. ${n})`)}else t=!0,e=Bi(e,e.shape[0],0).map(e=>Ui(e,[0]));l(e.length<=e[0].shape[0],()=>`Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`);const n=[],s=e;for(let t=0;t<e.length;++t)n.push(Ze.tidy(()=>{let e=s[t];if(t>0)for(let s=0;s<t;++s){const t=ds(oa(ds(n[s],e)),n[s]);e=ia(e,t)}return ps(e,ao(e,"euclidean"))}));return t?Gi(n,0):n}});function Qo(e,t=!1){return Ze.tidy(()=>{l(2===e.shape.length,()=>`qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`);const n=e.shape[0],s=e.shape[1];let r=Mr(n),a=Yt(e);const i=Xi([[1]],[1,1]);let o=Yt(i);const u=n>=s?s:n;for(let e=0;e<u;++e){const t=a,l=o,u=r;[o,a,r]=Ze.tidy(()=>{const t=Hs(a,[e,e],[n-e,1]),l=ao(t),u=Hs(a,[e,e],[1,1]),c=Sr(Pr(u,0),Xi([[-1]]),Xi([[1]])),h=ia(u,ds(c,l)),p=ps(t,h);o=1===p.shape[0]?Yt(i):Us([i,Hs(p,[1,0],[p.shape[0]-1,p.shape[1]])],0);const d=na(ps(fn(c,h),l)),f=Hs(a,[e,0],[n-e,s]),m=ds(d,o),g=gn(o);if(0===e)a=ia(f,fn(m,fn(g,f)));else{const t=ia(f,fn(m,fn(g,f)));a=Us([Hs(a,[0,0],[e,s]),t],0)}const y=gn(m),b=Hs(r,[0,e],[n,r.shape[1]-e]);if(0===e)r=ia(b,fn(fn(b,o),y));else{const t=ia(b,fn(fn(b,o),y));r=Us([Hs(r,[0,0],[n,e]),t],1)}return[o,a,r]}),as([t,l,u])}return!t&&n>s&&(r=Hs(r,[0,0],[n,s]),a=Hs(a,[0,0],[s,s])),[r,a]})}const el=lt({qr_:function(e,t=!1){if(l(e.rank>=2,()=>"qr() requires input tensor to have a rank >= 2, but got rank "+e.rank),2===e.rank)return Qo(e,t);{const n=e.shape.slice(0,e.shape.length-2).reduce((e,t)=>e*t),s=eo(Ps(e,[n,e.shape[e.shape.length-2],e.shape[e.shape.length-1]]),0),r=[],a=[];return s.forEach(e=>{const[n,s]=Qo(e,t);r.push(n),a.push(s)}),[Ps(Gi(r,0),e.shape),Ps(Gi(a,0),e.shape)]}}});var tl;(tl=e.Reduction||(e.Reduction={}))[tl.NONE=0]="NONE",tl[tl.MEAN=1]="MEAN",tl[tl.SUM=2]="SUM",tl[tl.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS";const nl=lt({computeWeightedLoss_:function(t,n,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const r=it(t,"losses","computeWeightedLoss");let a=null;null!=n&&(a=it(n,"weights","computeWeightedLoss"));const i=null==a?r:ds(r,a);if(s===e.Reduction.NONE)return i;if(s===e.Reduction.SUM)return oa(i);if(s===e.Reduction.MEAN){if(null==a)return Sa(i);{const e=r.size/a.size,t=ps(oa(i),oa(a));return e>1?ps(t,Ii(e)):t}}if(s===e.Reduction.SUM_BY_NONZERO_WEIGHTS){if(null==a)return ps(oa(i),Ii(r.size));{const e=ds(a,La(r.shape)),t=Xt(oa(Oa(e,Ii(0))),"float32");return ps(oa(i),t)}}throw Error("Unknown reduction: "+s)}});const sl=lt({absoluteDifference_:function(t,n,s,r=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=it(t,"labels","absoluteDifference"),i=it(n,"predictions","absoluteDifference");let o=null;null!=s&&(o=it(s,"weights","absoluteDifference")),u(a.shape,i.shape,"Error in absoluteDifference: ");const l=fs(ia(a,i));return nl(l,o,r)}});const rl=lt({cosineDistance_:function(t,n,s,r,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=it(t,"labels","cosineDistance"),o=it(n,"predictions","cosineDistance");let l=null;null!=r&&(l=it(r,"weights","cosineDistance")),u(i.shape,o.shape,"Error in cosineDistance: ");const c=Ii(1),h=ia(c,oa(ds(i,o),s,!0));return nl(h,l,a)}});const al=lt({hingeLoss_:function(t,n,s,r=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let a=it(t,"labels","hingeLoss");const i=it(n,"predictions","hingeLoss");let o=null;null!=s&&(o=it(s,"weights","hingeLoss")),u(a.shape,i.shape,"Error in hingeLoss: ");const l=Ii(1);a=ia(ds(Ii(2),a),l);const c=mi(ia(l,ds(a,i)));return nl(c,o,r)}});const il=lt({huberLoss_:function(t,n,s,r=1,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=it(t,"labels","huberLoss"),o=it(n,"predictions","huberLoss");let l=null;null!=s&&(l=it(s,"weights","huberLoss")),u(i.shape,o.shape,"Error in huberLoss: ");const c=Ii(r),h=fs(ia(o,i)),p=Ea(h,c),d=ia(h,p),f=cs(ds(Ii(.5),Ra(p)),ds(c,d));return nl(f,l,a)}});const ol=lt({logLoss_:function(t,n,s,r=1e-7,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=it(t,"labels","logLoss"),o=it(n,"predictions","logLoss");let l=null;null!=s&&(l=it(s,"weights","logLoss")),u(i.shape,o.shape,"Error in logLoss: ");const c=Ii(1),h=Ii(r),p=na(ds(i,Jr(cs(o,h)))),d=ds(ia(c,i),Jr(cs(ia(c,o),h))),f=ia(p,d);return nl(f,l,a)}});const ll=lt({meanSquaredError_:function(t,n,s,r=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=it(t,"labels","meanSquaredError"),i=it(n,"predictions","meanSquaredError");let o=null;null!=s&&(o=it(s,"weights","meanSquaredError")),u(a.shape,i.shape,"Error in meanSquaredError: ");const l=Vi(a,i);return nl(l,o,r)}});const ul=lt({sigmoidCrossEntropy_:function(t,n,s,r=0,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let i=it(t,"multiClassLabels","sigmoidCrossEntropy");const o=it(n,"logits","sigmoidCrossEntropy");let l=null;if(null!=s&&(l=it(s,"weights","sigmoidCrossEntropy")),u(i.shape,o.shape,"Error in sigmoidCrossEntropy: "),r>0){const e=Ii(r),t=Ii(1),n=Ii(.5);i=cs(ds(i,ia(t,e)),ds(n,e))}const c=function(e,t){const n=it(e,"labels","sigmoidCrossEntropyWithLogits"),s=it(t,"logits","sigmoidCrossEntropyWithLogits");u(n.shape,s.shape,"Error in sigmoidCrossEntropyWithLogits: ");const r=mi(s),a=ds(s,n),i=Zr(Fr(na(fs(s))));return cs(ia(r,a),i)}(i,o);return nl(c,l,a)}});const cl=lt({softmaxCrossEntropy_:function(t,n,s,r=0,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let i=it(t,"onehotLabels","softmaxCrossEntropy");const o=it(n,"logits","softmaxCrossEntropy");let l=null;if(null!=s&&(l=it(s,"weights","softmaxCrossEntropy")),u(i.shape,o.shape,"Error in softmaxCrossEntropy: "),r>0){const e=Ii(r),t=Ii(1),n=Ii(i.shape[1]);i=cs(ds(i,ia(t,e)),ps(e,n))}const c=function(e,t,n=-1){if(-1===n&&(n=t.rank-1),n!==t.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was `+n);return ea((e,t,s)=>{const r=ya(t,[n],!0),a=ia(Xt(t,"float32"),r);s([e,a]);const i=na(ds(a,e));return{value:oa(i,[n]),gradFunc:(e,t)=>{const[s,r]=t,a=pa(e.shape,[n]);return[ds(Ps(e,a),ia(Xt(s,"float32"),Fr(r))),ds(Ps(e,a),ia(Fr(r),Xt(s,"float32")))]}}})(e,t)}(i,o);return nl(c,l,a)}}),hl={fft:Mi,ifft:Li,rfft:Pi,irfft:zi},pl={hammingWindow:So,hannWindow:To,frame:Eo,stft:$o},dl={flipLeftRight:Ro,resizeNearestNeighbor:Yo,resizeBilinear:Xo,rotateWithOffset:Fo,cropAndResize:Ao,nonMaxSuppression:_o,nonMaxSuppressionAsync:Go,nonMaxSuppressionWithScore:Ho,nonMaxSuppressionWithScoreAsync:jo,nonMaxSuppressionPadded:qo,nonMaxSuppressionPaddedAsync:Ko},fl={bandPart:Jo,gramSchmidt:Zo,qr:el},ml={absoluteDifference:sl,computeWeightedLoss:nl,cosineDistance:rl,hingeLoss:al,huberLoss:il,logLoss:ol,meanSquaredError:ll,sigmoidCrossEntropy:ul,softmaxCrossEntropy:cl};class gl extends jn{minimize(e,t=!1,n){const{value:s,grads:r}=this.computeGradients(e,n);if(null!=n){const e=n.map(e=>({name:e.name,tensor:r[e.name]}));this.applyGradients(e)}else this.applyGradients(r);return as(r),t?s:(s.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(e,t){return Qr(e,t)}dispose(){null!=this.iterations_&&as(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:Ii(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for this optimizer class "+this.getClassName())}async extractIterations(e){return this.iterations_=(await e[0].tensor.data())[0],e.slice(1)}}Object.defineProperty(gl,Symbol.hasInstance,{value:e=>null!=e.minimize&&null!=e.computeGradients&&null!=e.applyGradients});class yl extends gl{constructor(e,t,n=null){super(),this.learningRate=e,this.rho=t,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=Ze.backend.epsilon())}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const s=Ze.registeredVariables[t];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:t+"/accum_grad",variable:rs(()=>Tr(s).variable(!1))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:t+"/accum_var",variable:rs(()=>Tr(s).variable(!1))});const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const a=this.accumulatedGrads[n].variable,i=this.accumulatedUpdates[n].variable;rs(()=>{const e=cs(ds(a,this.rho),ds(Ra(r),1-this.rho)),t=ds(ps(Wi(cs(i,this.epsilon)),Wi(cs(a,this.epsilon))),r),n=cs(ds(i,this.rho),ds(Ra(t),1-this.rho));a.assign(e),i.assign(n);const o=cs(ds(t,-this.learningRate),s);s.assign(o)})}),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(as(this.accumulatedGrads.map(e=>e.variable)),as(this.accumulatedUpdates.map(e=>e.variable)))}async getWeights(){const e=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(e.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){const t=(e=await this.extractIterations(e)).length/2;this.accumulatedGrads=e.slice(0,t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})),this.accumulatedUpdates=e.slice(t,2*t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.rho,t.epsilon)}}yl.className="Adadelta",Kn(yl);class bl extends gl{constructor(e,t=.1){super(),this.learningRate=e,this.initialAccumulatorValue=t,this.accumulatedGrads=[]}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const s=Ze.registeredVariables[t];if(null==this.accumulatedGrads[n]){const e=!1;this.accumulatedGrads[n]={originalName:t+"/accumulator",variable:rs(()=>Lr(s.shape,this.initialAccumulatorValue).variable(e))}}const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const a=this.accumulatedGrads[n].variable;rs(()=>{const e=cs(a,Ra(r));a.assign(e);const t=cs(ds(ps(r,Wi(cs(e,Ze.backend.epsilon()))),-this.learningRate),s);s.assign(t)})}),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&as(this.accumulatedGrads.map(e=>e.variable))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){e=await this.extractIterations(e);this.accumulatedGrads=e.map(e=>({originalName:e.name,variable:e.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(e,t){return new e(t.learningRate,t.initialAccumulatorValue)}}bl.className="Adagrad",Kn(bl);class xl extends gl{constructor(e,t,n,s=null){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=s,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],rs(()=>{this.accBeta1=Ii(t).variable(),this.accBeta2=Ii(n).variable()}),null==s&&(this.epsilon=Ze.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map(e=>e.name):Object.keys(e);rs(()=>{const n=ia(1,this.accBeta1),s=ia(1,this.accBeta2);t.forEach((t,r)=>{const a=Ze.registeredVariables[t];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:t+"/m",variable:rs(()=>Tr(a).variable(!1))}),null==this.accumulatedSecondMoment[r]&&(this.accumulatedSecondMoment[r]={originalName:t+"/v",variable:rs(()=>Tr(a).variable(!1))});const i=Array.isArray(e)?e[r].tensor:e[t];if(null==i)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedSecondMoment[r].variable,u=cs(ds(o,this.beta1),ds(i,1-this.beta1)),c=cs(ds(l,this.beta2),ds(Ra(i),1-this.beta2)),h=ps(u,n),p=ps(c,s);o.assign(u),l.assign(c);const d=cs(ds(ps(h,cs(Wi(p),this.epsilon)),-this.learningRate),a);a.assign(d)}),this.accBeta1.assign(ds(this.accBeta1,this.beta1)),this.accBeta2.assign(ds(this.accBeta2,this.beta2))}),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&as(this.accumulatedFirstMoment.map(e=>e.variable)),null!=this.accumulatedSecondMoment&&as(this.accumulatedSecondMoment.map(e=>e.variable))}async getWeights(){const e=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(e.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){e=await this.extractIterations(e),rs(()=>{this.accBeta1.assign(qa(this.beta1,this.iterations_+1)),this.accBeta2.assign(qa(this.beta2,this.iterations_+1))});const t=e.length/2;this.accumulatedFirstMoment=e.slice(0,t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})),this.accumulatedSecondMoment=e.slice(t,2*t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon)}}xl.className="Adam",Kn(xl);class wl extends gl{constructor(e,t,n,s=null,r=0){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=s,this.decay=r,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],rs(()=>{this.iteration=Ii(0).variable(),this.accBeta1=Ii(t).variable()}),null==s&&(this.epsilon=Ze.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map(e=>e.name):Object.keys(e);rs(()=>{const n=ia(1,this.accBeta1),s=ps(-this.learningRate,cs(ds(this.iteration,this.decay),1));t.forEach((t,r)=>{const a=Ze.registeredVariables[t];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:t+"/m",variable:Tr(a).variable(!1)}),null==this.accumulatedWeightedInfNorm[r]&&(this.accumulatedWeightedInfNorm[r]={originalName:t+"/v",variable:Tr(a).variable(!1)});const i=Array.isArray(e)?e[r].tensor:e[t];if(null==i)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedWeightedInfNorm[r].variable,u=cs(ds(o,this.beta1),ds(i,1-this.beta1)),c=ds(l,this.beta2),h=fs(i),p=Ca(c,h);o.assign(u),l.assign(p);const d=cs(ds(ps(s,n),ps(u,cs(p,this.epsilon))),a);a.assign(d)}),this.iteration.assign(cs(this.iteration,1)),this.accBeta1.assign(ds(this.accBeta1,this.beta1))}),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&as(this.accumulatedFirstMoment.map(e=>e.variable)),null!=this.accumulatedWeightedInfNorm&&as(this.accumulatedWeightedInfNorm.map(e=>e.variable))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon,t.decay)}}wl.className="Adamax",Kn(wl);class kl extends gl{constructor(e){super(),this.learningRate=e,this.setLearningRate(e)}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const r=Ze.registeredVariables[t];rs(()=>{const e=cs(ds(this.c,s),r);r.assign(e)})}),this.incrementIterations()}setLearningRate(e){this.learningRate=e,null!=this.c&&this.c.dispose(),this.c=is(Ii(-e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(e){if(0!==(e=await this.extractIterations(e)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(e,t){return new e(t.learningRate)}}kl.className="SGD",Kn(kl);class vl extends kl{constructor(e,t,n=!1){super(e),this.learningRate=e,this.momentum=t,this.useNesterov=n,this.accumulations=[],this.m=Ii(this.momentum)}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const s=Ze.registeredVariables[t];if(null==this.accumulations[n]){const e=!1;this.accumulations[n]={originalName:t+"/momentum",variable:rs(()=>Tr(s).variable(e))}}const r=this.accumulations[n].variable,a=Array.isArray(e)?e[n].tensor:e[t];null!=a&&rs(()=>{let e;const t=cs(ds(this.m,r),a);e=this.useNesterov?cs(ds(this.c,cs(a,ds(t,this.m))),s):cs(ds(this.c,t),s),r.assign(t),s.assign(e)})}),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&as(this.accumulations.map(e=>e.variable))}setMomentum(e){this.momentum=e}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){e=await this.extractIterations(e);this.accumulations=e.map(e=>({originalName:e.name,variable:e.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(e,t){return new e(t.learningRate,t.momentum,t.useNesterov)}}vl.className="Momentum",Kn(vl);class Nl extends gl{constructor(e,t=.9,n=0,s=null,r=!1){if(super(),this.learningRate=e,this.decay=t,this.momentum=n,this.epsilon=s,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=r,null==s&&(this.epsilon=Ze.backend.epsilon()),null==e)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const s=Ze.registeredVariables[t];null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:t+"/rms",variable:rs(()=>Tr(s).variable(!1))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:t+"/momentum",variable:rs(()=>Tr(s).variable(!1))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:t+"/mg",variable:rs(()=>Tr(s).variable(!1))});const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const a=this.accumulatedMeanSquares[n].variable,i=this.accumulatedMoments[n].variable;rs(()=>{const e=cs(ds(a,this.decay),ds(Ra(r),1-this.decay));if(this.centered){const t=this.accumulatedMeanGrads[n].variable,o=cs(ds(t,this.decay),ds(r,1-this.decay)),l=ps(ds(r,this.learningRate),Wi(ia(e,cs(Ra(o),this.epsilon)))),u=cs(ds(i,this.momentum),l);a.assign(e),t.assign(o),i.assign(u);const c=ia(s,u);s.assign(c)}else{const e=cs(ds(a,this.decay),ds(Ra(r),1-this.decay)),t=cs(ds(i,this.momentum),ps(ds(r,this.learningRate),Wi(cs(e,this.epsilon))));a.assign(e),i.assign(t);const n=ia(s,t);s.assign(n)}})}),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&as(this.accumulatedMeanSquares.map(e=>e.variable)),null!=this.accumulatedMeanGrads&&this.centered&&as(this.accumulatedMeanGrads.map(e=>e.variable)),null!=this.accumulatedMoments&&as(this.accumulatedMoments.map(e=>e.variable))}async getWeights(){const e=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&e.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(e.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){e=await this.extractIterations(e);const t=this.centered?e.length/3:e.length/2;this.accumulatedMeanSquares=e.slice(0,t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})),this.accumulatedMoments=e.slice(t,2*t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})),this.centered&&(this.accumulatedMeanGrads=e.slice(2*t,3*t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(e,t){return new e(t.learningRate,t.decay,t.momentum,t.epsilon,t.centered)}}Nl.className="RMSProp",Kn(Nl);class Il{static sgd(e){return new kl(e)}static momentum(e,t,n=!1){return new vl(e,t,n)}static rmsprop(e,t=.9,n=0,s=null,r=!1){return new Nl(e,t,n,s,r)}static adam(e=.001,t=.9,n=.999,s=null){return new xl(e,t,n,s)}static adadelta(e=.001,t=.95,n=null){return new yl(e,t,n)}static adamax(e=.002,t=.9,n=.999,s=null,r=0){return new wl(e,t,n,s,r)}static adagrad(e,t=.1){return new bl(e,t)}}const Cl={sgd:Il.sgd,momentum:Il.momentum,adadelta:Il.adadelta,adagrad:Il.adagrad,rmsprop:Il.rmsprop,adamax:Il.adamax,adam:Il.adam},Sl="undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate?setImmediate:e=>e();function Tl(){return new Promise(e=>Sl(()=>e()))}function El(e,t){const n=e[0].length;e.forEach((e,t)=>{l(e.length===n,()=>`Error in concat${n}D: rank of tensors[${t}] must be the same as the rank of the rest (${n})`)}),l(t>=0&&t<n,()=>`Error in concat${n}D: axis must be between 0 and ${n-1}.`);const s=e[0];e.forEach((e,r)=>{for(let a=0;a<n;a++)l(a===t||e[a]===s[a],()=>`Error in concat${n}D: Shape of tensors[${r}] (${e}) does not match the shape of the rest (${s}) along the non-concatenated axis ${r}.`)})}function $l(e,t){const n=e[0].slice();for(let s=1;s<e.length;s++)n[t]+=e[s][t];return n}function Al(e){return e<=30?e:_(e,Math.floor(Math.sqrt(e)))}function Rl(e,t,n){return[n*("number"==typeof e?e:e[0]),t*("number"==typeof e?e:e[1])]}function Fl(e,t,n,s=!0){let r=[];if(s)r=r.concat(t.slice(0)),r.push(e[0]/n),r=r.concat(e.slice(1));else{r=r.concat(e[0]);const n=t.length;for(let s=0;s<n;++s)r=r.concat([e[s+1]/t[s],t[s]]);r=r.concat(e.slice(n+1))}return r}function Dl(e,t,n=!0){const s=[];if(n){s.push(t);for(let n=t+1;n<e;++n)n<=2*t?(s.push(n),s.push(n-(t+1))):s.push(n)}else{const n=[],r=[];for(let s=1;s<e;++s)s>=2*t+1||s%2==1?r.push(s):n.push(s);s.push(...n),s.push(0),s.push(...r)}return s}function _l(e,t,n,s=!0){const r=[];s?r.push(e[0]/n):r.push(e[0]*n);for(let n=1;n<e.length;++n)n<=t.length?s?r.push(t[n-1]*e[n]):r.push(e[n]/t[n-1]):r.push(e[n]);return r}function Ol(e,t){const n=[0];for(let s=0;s<t;++s)n.push(e[s][0]);return n}function Ml(e,t,n){const s=e.slice(0,1);for(let r=0;r<n;++r)s.push(e[r+1]-t[r][0]-t[r][1]);return s}const Ll=1.0507009873554805;function zl(...e){H().getBool("IS_TEST")||console.warn(...e)}function Bl(e,t){if(e.length!==t.length)throw new Error(`Cannot merge real and imag arrays of different lengths. real:${e.length}, imag: ${t.length}.`);const n=new Float32Array(2*e.length);for(let s=0;s<n.length;s+=2)n[s]=e[s/2],n[s+1]=t[s/2];return n}function Pl(e){const t=new Float32Array(e.length/2),n=new Float32Array(e.length/2);for(let s=0;s<e.length;s+=2)t[s/2]=e[s],n[s/2]=e[s+1];return{real:t,imag:n}}function Wl(e){const t=Math.ceil(e.length/4),n=new Float32Array(t),s=new Float32Array(t);for(let t=0;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],s[Math.floor(t/4)]=e[t+1];return{real:n,imag:s}}function Vl(e){const t=Math.floor(e.length/4),n=new Float32Array(t),s=new Float32Array(t);for(let t=2;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],s[Math.floor(t/4)]=e[t+1];return{real:n,imag:s}}function Ul(e,t){return{real:e[2*t],imag:e[2*t+1]}}function Gl(e,t,n,s){e[2*s]=t,e[2*s+1]=n}function Hl(e,t){const n=new Float32Array(e/2),s=new Float32Array(e/2);for(let r=0;r<Math.ceil(e/2);r++){const a=(t?2:-2)*Math.PI*(r/e);n[r]=Math.cos(a),s[r]=Math.sin(a)}return{real:n,imag:s}}function jl(e,t,n){const s=(n?2:-2)*Math.PI*(e/t);return{real:Math.cos(s),imag:Math.sin(s)}}function ql(e,t,n=0){let s=[];if("number"==typeof t)l(e.shape[n]%t==0,()=>"Number of splits must evenly divide the axis."),s=new Array(t).fill(e.shape[n]/t);else{l(t.reduce((e,t)=>(-1===t&&(e+=1),e),0)<=1,()=>"There should be only one negative value in split array.");const r=t.indexOf(-1);if(-1!==r){const s=t.reduce((e,t)=>t>0?e+t:e);t[r]=e.shape[n]-s}l(e.shape[n]===t.reduce((e,t)=>e+t),()=>"The sum of sizes must match the size of the axis dimension."),s=t}return s}function Kl(e,t){let n,s=!1;for(e<=30?(n=e,s=!0):n=_(e,Math.floor(Math.sqrt(e)));!s;)n>t||n===e?s=!0:n=_(e,n+1);return n}function Xl(e,t,n){const s=[],r=e.length;for(let a=0;a<r;a++)a!==t?s.push(e[a]):s.push(n);return s}function Yl(e,t,n,s){const r=t.shape.length,a=e.shape.length;if(0!==s&&(s<-r||s>r))throw new Error(`Expect batchDims in the range of [-${r}, ${r}], but got ${s}`);if(s<0&&(s+=r),s>a)throw new Error(`batchDims (${s}) must be less than rank(x) (\n    ${a}).`);if(n<s)throw new Error(`batchDims (${s}) must be less than or equal to axis (${n}).`);for(let n=0;n<s;++n)if(e.shape[n]!==t.shape[n])throw new Error(`x.shape[${n}]: ${e.shape[n]} should be equal to indices.shape[${n}]: ${t.shape[n]}.`);const i=e.shape[n],o=[];let l=1,u=1,c=1;for(let t=0;t<s;++t)o.push(e.shape[t]),l*=e.shape[t];for(let t=s;t<n;t++)o.push(e.shape[t]),u*=e.shape[t];for(let e=s;e<r;e++)o.push(t.shape[e]);for(let t=n+1;t<a;t++)o.push(e.shape[t]),c*=e.shape[t];return{batchSize:l,sliceSize:c,outerSize:u,dimSize:i,outputShape:o}}var Jl=Object.freeze({__proto__:null,segOpComputeOptimalWindowSize:Kl,computeOutShape:Xl,collectGatherOpShapeInfo:Yl});function Zl(e){try{return e.map(e=>xe(e))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8, error: "+e)}}function Ql(e){return e.map(e=>be(e))}var eu=Object.freeze({__proto__:null,slice_util:Hn,segment_util:Jl,fromUint8ToStringArray:Zl,fromStringArrayToUint8:Ql,upcastType:We,axesAreInnerMostDims:ua,combineLocations:ca,computeOutAndReduceShapes:ha,expandShapeToKeepDim:pa,assertAxesAreInnerMostDims:da,getAxesPermutation:fa,getUndoAxesPermutation:ma,getInnerMostAxes:ga,getBroadcastDims:vr,getReductionAxes:Nr,assertAndGetBroadcastShape:Ir,assertParamsConsistent:El,computeOutShape:$l,computeDilation2DInfo:Ts,computePool2DInfo:Es,computePool3DInfo:$s,computeConv2DInfo:As,computeConv3DInfo:Rs,computeDefaultPad:Fs,tupleValuesAreOne:Ls,eitherStridesOrDilationsAreOne:zs,convertConv2DDataFormat:Bs,getFusedDyActivation:go,getFusedBiasGradient:yo,applyActivation:bo,shouldFuse:xo,PARALLELIZE_THRESHOLD:30,computeOptimalWindowSize:Al,getImageCenter:Rl,getReshaped:Fl,getPermuted:Dl,getReshapedPermuted:_l,getSliceBeginCoords:Ol,getSliceSize:Ml,prepareAndValidate:Nn,validateUpdateShape:Cn,validateInput:Sn,calculateShapes:Tn,SELU_SCALEALPHA:1.7580993408473768,SELU_SCALE:Ll,ERF_P:.3275911,ERF_A1:.254829592,ERF_A2:-.284496736,ERF_A3:1.421413741,ERF_A4:-1.453152027,ERF_A5:1.061405429,warn:zl,log:function(...e){H().getBool("IS_TEST")||console.log(...e)},mergeRealAndImagArrays:Bl,splitRealAndImagArrays:Pl,complexWithEvenIndex:Wl,complexWithOddIndex:Vl,getComplexWithIndex:Ul,assignToTypedArray:Gl,exponents:Hl,exponent:jl,prepareSplitSize:ql}),tu=Object.freeze({__proto__:null,nonMaxSuppressionV3Impl:Lo,nonMaxSuppressionV4Impl:zo,nonMaxSuppressionV5Impl:Bo,whereImpl:no});const nu={kernelName:"Abs",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ds(e,Hi(Xt(n,"float32"),-1))}}},su={kernelName:"Acos",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Ra(Xt(n,"float32")),s=Wi(ia(Ii(1),t));return na(ps(e,s))}}}},ru={kernelName:"Acosh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Wi(ia(Ra(Xt(n,"float32")),1));return ps(e,t)}}}},au={kernelName:X,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=Ir(n.shape,s.shape);return{a:()=>{let t=e;const s=Nr(n.shape,r);return s.length>0&&(t=oa(t,s)),Ps(t,n.shape)},b:()=>{let t=e;const n=Nr(s.shape,r);return n.length>0&&(t=oa(t,n)),Ps(t,s.shape)}}}},iu={kernelName:"AddN",saveAllInputs:!0,gradFunc:(e,t)=>{const n={};return t.forEach((t,s)=>{n[s]=()=>e.clone()}),n}},ou={kernelName:"ArgMax",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Tr(n)}}},lu={kernelName:"ArgMin",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Tr(n)}}},uu={kernelName:"Asin",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ps(e,Wi(ia(Ii(1),Ra(Xt(n,"float32")))))}}},cu={kernelName:"Asinh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Wi(cs(Ii(1),Ra(Xt(n,"float32"))));return ps(e,t)}}}},hu={kernelName:"Atan2",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=Ir(n.shape,s.shape);return{a:()=>{const t=cs(Ra(n),Ra(s));let a=ds(e,ps(s,t));const i=Nr(n.shape,r);return i.length>0&&(a=oa(a,i)),Ps(a,n.shape)},b:()=>{const t=cs(Ra(n),Ra(s));let a=na(ds(e,ps(n,t)));const i=Nr(s.shape,r);return i.length>0&&(a=oa(a,i)),Ps(a,s.shape)}}}},pu={kernelName:"Atan",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ps(e,cs(Ra(Xt(n,"float32")),1))}}},du={kernelName:"Atanh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ps(e,ia(Ii(1),Ra(Xt(n,"float32"))))}}};const fu=lt({avgPool3dGrad_:function(e,t,n,s,r,a){const i=it(e,"dy","avgPool3dGrad"),o=it(t,"input","avgPool3dGrad");let u=i,c=o,h=!1;4===o.rank&&(h=!0,u=Ps(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]]),c=Ps(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),l(5===u.rank,()=>"Error in avgPool3dGrad: dy must be rank 5 but got rank "+u.rank+"."),l(5===c.rank,()=>"Error in avgPool3dGrad: input must be rank 5 but got rank "+c.rank+"."),null!=a&&l(f(r),()=>`Error in avgPool3dGrad: pad must be an integer when using, dimRoundingMode ${a} but got pad ${r}.`);const p={dy:u,input:c},d={filterSize:n,strides:s,pad:r,dimRoundingMode:a},m=Ze.runKernel("AvgPool3DGrad",p,d);return h?Ps(m,[m.shape[1],m.shape[2],m.shape[3],m.shape[4]]):m}}),mu={kernelName:"AvgPool3D",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{filterSize:r,strides:a,pad:i,dimRoundingMode:o}=n;return{x:()=>fu(e,s,r,a,i,o)}}};const gu=lt({avgPoolGrad_:function(e,t,n,s,r){const a=it(e,"dy","avgPoolGrad"),i=it(t,"input","avgPoolGrad");l(i.rank===a.rank,()=>`Rank of input (${i.rank}) does not match rank of dy (${a.rank})`);let o=i,u=a,c=!1;3===i.rank&&(c=!0,o=Ps(i,[1,i.shape[0],i.shape[1],i.shape[2]]),u=Ps(a,[1,a.shape[0],a.shape[1],a.shape[2]])),l(4===u.rank,()=>"Error in avgPoolGrad: dy must be rank 4 but got rank "+u.rank+"."),l(4===o.rank,()=>"Error in avgPoolGrad: input must be rank 4 but got rank "+o.rank+".");const h={dy:u,input:o},p={filterSize:n,strides:s,pad:r},d=Ze.runKernel("AvgPoolGrad",h,p);return c?Ps(d,[d.shape[1],d.shape[2],d.shape[3]]):d}}),yu={kernelName:"AvgPool",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{filterSize:r,strides:a,pad:i}=n;return{x:()=>gu(e,s,r,a,i)}}},bu={kernelName:"BatchMatMul",inputsToSave:["a","b"],gradFunc:(e,t,n)=>{const[s,r]=t,{transposeA:a,transposeB:i}=n;return a||i?!a&&i?{a:()=>fn(e,r,!1,!1),b:()=>fn(e,s,!0,!1)}:a&&!i?{a:()=>fn(r,e,!1,!0),b:()=>fn(s,e,!1,!1)}:{a:()=>fn(r,e,!0,!0),b:()=>fn(e,s,!0,!0)}:{a:()=>fn(e,r,!1,!0),b:()=>fn(s,e,!0,!1)}}},xu={kernelName:"BatchToSpaceND",gradFunc:(e,t,n)=>{const{blockShape:s,crops:r}=n;return{x:()=>Ha(e,s,r)}}},wu={kernelName:"BroadcastTo",gradFunc:(e,t,n)=>{const s=n,r=s.inputShape,a=s.shape,i=Array.from(a);for(let e=r.length-1;e>=0;e--)if(r[e]===a[e])i[e]=1;else if(1!==r[e])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${a}].`);const o=[];for(let e=0;e<i.length;e++)i[e]>1&&o.push(e);return{x:()=>oa(e,o,!0)}}},ku={kernelName:"Cast",gradFunc:e=>({x:()=>e.clone()})},vu={kernelName:"Ceil",gradFunc:e=>({x:()=>Tr(e)})},Nu={kernelName:"ClipByValue",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{clipValueMin:r,clipValueMax:a}=n;return{x:()=>Sr(ba(Wr(s,r),Kr(s,a)),e,Tr(e))}}},Iu={kernelName:"ComplexAbs",inputsToSave:["x"],gradFunc:nu.gradFunc},Cu={kernelName:"Concat",saveAllInputs:!0,gradFunc:(e,t,n)=>{const s=t.map(e=>e.shape),{axis:r}=n,a=x(r,t[0].shape)[0],i=s.map(e=>e[a]);return Bi(e,i,a).map(e=>()=>e)}},Su={kernelName:"Conv2D",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,{dilations:a,strides:i,pad:o,dataFormat:u}=n;return l(Ls(a),()=>`Error in gradient of conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`),{x:()=>ur(s.shape,e,r,i,o,u),filter:()=>mo(s,e,r.shape,i,o,u)}}},Tu={kernelName:"Conv2DBackpropInput",inputsToSave:["dy","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,{strides:a,pad:i,dataFormat:o,dimRoundingMode:l}=n;return{dy:()=>or(e,r,a,i,o,1,l),filter:()=>mo(e,s,r.shape,a,i,o,l)}}};const Eu=lt({conv3DBackpropFilter_:function(e,t,n,s,r){let a=e;4===e.rank&&(a=Ps(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]]));let i=t;4===i.rank&&(i=Ps(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]])),l(5===a.rank,()=>"Error in conv3dDerFilter: input must be rank 5, but got shape "+a.shape+"."),l(5===i.rank,()=>"Error in conv3dDerFilter: dy must be rank 5, but got shape "+i.shape+"."),l(5===n.length,()=>"Error in conv3dDerFilter: filterShape must be length 5, but got "+n+"."),l(a.shape[4]===n[3],()=>`Error in conv3dDerFilter: depth of input ${a.shape[4]}) must match input depth in filter (${n[3]}.`),l(i.shape[4]===n[4],()=>`Error in conv3dDerFilter: depth of dy (${i.shape[4]}) must match output depth for filter (${n[4]}).`);const o={x:a,dy:i},u={strides:s,pad:r,filterShape:n};return Ze.runKernel("Conv3DBackpropFilterV2",o,u)}}),$u={kernelName:"Conv3D",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const{dilations:s,strides:r,pad:a}=n;l(Ls(s),()=>`Error in gradient of conv3D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${s}'`);const[i,o]=t;return{x:()=>pr(i.shape,e,o,r,a),filter:()=>Eu(i,e,o.shape,r,a)}}},Au={kernelName:Y,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ds(na($i(Xt(n,"float32"))),e)}}},Ru={kernelName:"Cosh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ds(Ai(Xt(n,"float32")),e)}}},Fu={kernelName:"Cumsum",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{axis:r,exclusive:a,reverse:i}=n;return{x:()=>{const t=fa([r],s.rank);let n=gr(e,r,a,!i);return null!=t&&(n=gn(n,t)),n}}}},Du={kernelName:"DepthwiseConv2dNative",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const{dilations:s,strides:r,pad:a,dimRoundingMode:i}=n,o=null==s?[1,1]:s;l(Ls(o),()=>`Error in gradient of depthwiseConv2dNative: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`);const[u,c]=t;return l(4===u.rank,()=>`Error in gradient of depthwiseConv2dNative: input must be rank 4, but got rank ${u.rank}.`),l(4===c.rank,()=>`Error in gradient of depthwiseConv2dNative: filter must be rank 4, but got rank ${c.rank}.`),l(u.shape[3]===c.shape[2],()=>`Error in gradient of depthwiseConv2d: number of input channels (${u.shape[3]}) must match the inChannels dimension in filter ${c.shape[2]}.`),l(zs(r,o),()=>`Error in gradient of depthwiseConv2d: Either strides or dilations must be  1. Got strides ${r} and dilations '${o}'.`),null!=i&&l(f(a),()=>`Error in depthwiseConv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`),{x:()=>vo(u.shape,e,c,r,a,s,i),filter:()=>ko(u,e,c.shape,r,a,s,i)}}},_u={kernelName:"Dilation2D",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,a={x:s,filter:r,dy:e},i={x:s,filter:r,dy:e};return{x:()=>Ze.runKernel("Dilation2DBackpropInput",a,n),filter:()=>Ze.runKernel("Dilation2DBackpropFilter",i,n)}}},Ou={kernelName:J,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t,s={dy:e,y:n};return{x:()=>Ze.runKernel("EluGrad",s)}}},Mu={kernelName:Z,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t,s=ds(Fr(na(Ra(n))),2/Math.sqrt(Math.PI));return{x:()=>ds(e,s)}}},Lu={kernelName:Q,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ds(e,n)}}},zu={kernelName:"ExpandDims",inputsToSave:["input"],gradFunc:(e,t)=>{const[n]=t;return{input:()=>Ps(e,n.shape)}}},Bu={kernelName:"Expm1",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ds(e,Fr(n))}}},Pu={kernelName:"Floor",gradFunc:e=>({x:()=>Tr(e)})},Wu={kernelName:"FloorDiv",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=Ir(n.shape,s.shape);return{a:()=>{const t=ps(e,Xt(s,"float32")),a=Nr(n.shape,r);return a.length>0?Ps(oa(t,a),n.shape):t},b:()=>{let t=ds(e,Xt(n,"float32"));const a=Nr(s.shape,r);a.length>0&&(t=Ps(oa(t,a),s.shape));const i=Ra(s);return na(ps(t,Xt(i,"float32")))}}}},Vu={kernelName:"FusedBatchNorm",inputsToSave:["x","mean","variance","scale"],gradFunc:(e,t,n)=>{const{varianceEpsilon:s}=n,[r,a,i,o]=t,l=null==o?Ii(1):o,u=Nr(a.shape,r.shape),c=[];if(1===a.rank){for(let e=0;e<r.shape.length-1;++e)c.push(r.shape[e]);c.push(1)}const h=ia(r,a),p=ds(e,l),d=Ni(cs(i,Ii(s))),f=ds(ds(ds(d,d),d),Ii(-.5));return{x:()=>1===a.rank?Ps(ds(ds(e,Or(Ps(d,[1,1,1,a.shape[0]]),c)),l),r.shape):Ps(ds(ds(e,d),l),r.shape),mean:()=>{let e=ds(ds(d,Ii(-1)),p);return 1===a.rank&&(e=oa(e,u)),Ps(e,a.shape)},variance:()=>{let e=ds(ds(f,h),p);return 1===a.rank&&(e=oa(e,u)),Ps(e,a.shape)},scale:()=>{const t=ds(h,d);let n=ds(e,t);return 1===a.rank&&(n=oa(n,u)),Ps(n,a.shape)},offset:()=>{let t=e;return 1===a.rank&&(t=oa(t,u)),Ps(t,a.shape)}}}},Uu={kernelName:"GatherV2",inputsToSave:["x","indices"],gradFunc:(e,t,n)=>{const[s,r]=t,{axis:a}=n,i=x(a,s.shape)[0];return{x:()=>{const t=s.shape,n=r.size,o=t.slice(0,i),l=o.length,u=t.slice(a,t.length).slice(1),c=u.length,h=Gu(0,l),p=Gu(l+1,l+1+c),d=Hu([o,[n],u]),f=Ps(e,d),m=Ps(r,[n]),g=Hu([[l],h,p]),y=gn(f,g);let b=Qi(y,m,s.shape[i]);const x=ma(g);return b=gn(b,x),b},indices:()=>r}}};function Gu(e,t){const n=[];for(let s=e;s<t;++s)n.push(s);return n}function Hu(e){const t=[];for(let n=0;n<e.length;++n)for(let s=0;s<e[n].length;++s)t.push(e[n][s]);return t}const ju={kernelName:"GreaterEqual",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>Tr(n),b:()=>Tr(s)}}},qu={kernelName:"Identity",gradFunc:e=>({x:()=>Xt(e,"float32")})},Ku={kernelName:"IsFinite",gradFunc:e=>({x:()=>Tr(e)})},Xu={kernelName:"IsInf",gradFunc:e=>({x:()=>Tr(e)})},Yu={kernelName:"IsNan",gradFunc:e=>({x:()=>Tr(e)})},Ju={kernelName:"LeakyRelu",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{alpha:r}=n,a=Pr(s,0);return{x:()=>Sr(a,e,ds(e,r))}}},Zu={kernelName:"Log1p",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ps(e,cs(n,1))}}},Qu={kernelName:ee,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ps(e,Xt(n,"float32"))}}},ec={kernelName:"LogSoftmax",inputsToSave:[],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s]=t,{axis:r}=n;return{logits:()=>{const t=Fr(s);return ia(e,ds(oa(e,r,!0),t))}}}};const tc=lt({localResponseNormalizationBackprop_:function(e,t,n,s=5,r=1,a=1,i=.5){const o={x:e,y:t,dy:n},l={depthRadius:s,bias:r,alpha:a,beta:i};return Ze.runKernel("LRNGrad",o,l)}}),nc={kernelName:"LRN",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{depthRadius:a,bias:i,alpha:o,beta:l}=n;return{x:()=>tc(s,r,e,a,i,o,l)}}};function sc(e,t,n,s){return t.rank<n.rank&&(t=Ps(t,pa(t.shape,s))),e.rank<n.rank&&(e=Ps(e,pa(e.shape,s))),{x:()=>ds(e,Xt(Cr(n,t),e.dtype))}}const rc={kernelName:"Max",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const s=n,{reductionIndices:r}=s,a=t[0],i=sc(e,t[1],a,x(r,a.shape));return{x:()=>i.x()}}},ac={kernelName:"Maximum",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>ds(e,Xt(Wr(n,s),"float32")),b:()=>ds(e,Xt(qr(n,s),"float32"))}}};const ic=lt({maxPool3dGrad_:function(e,t,n,s,r,a,i){const o=it(e,"dy","maxPool3dGrad"),u=it(t,"input","maxPool3dGrad"),c=it(n,"output","maxPool3dGrad");let h=o,p=u,d=c,m=!1;4===u.rank&&(m=!0,h=Ps(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]]),p=Ps(u,[1,u.shape[0],u.shape[1],u.shape[2],u.shape[3]]),d=Ps(c,[1,c.shape[0],c.shape[1],c.shape[2],c.shape[3]])),l(5===h.rank,()=>"Error in maxPool3dGrad: dy must be rank 5 but got rank "+h.rank+"."),l(5===p.rank,()=>"Error in maxPool3dGrad: input must be rank 5 but got rank "+p.rank+"."),l(5===d.rank,()=>"Error in maxPool3dGrad: output must be rank 5 but got rank "+d.rank+"."),null!=i&&l(f(a),()=>`Error in maxPool3dGrad: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`);const g={dy:h,input:p,output:d},y={filterSize:s,strides:r,pad:a,dimRoundingMode:i},b=Ze.runKernel("MaxPool3DGrad",g,y);return m?Ps(b,[b.shape[1],b.shape[2],b.shape[3],b.shape[4]]):b}}),oc={kernelName:"MaxPool3D",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l}=n;return{x:()=>ic(e,s,r,a,i,o,l)}}};const lc=lt({maxPoolGrad_:function(e,t,n,s,r,a,i){const o=it(e,"dy","maxPoolGrad"),u=it(t,"input","maxPoolGrad"),c=it(n,"output","maxPoolGrad");l(u.rank===o.rank,()=>`Rank of input (${u.rank}) does not match rank of dy (${o.rank})`),l(4===o.rank,()=>"Error in maxPoolGrad: dy must be rank 4 but got rank "+o.rank+"."),l(4===u.rank,()=>"Error in maxPoolGrad: input must be rank 4 but got rank "+u.rank+"."),null!=i&&l(f(a),()=>`Error in maxPoolGrad: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`);const h={dy:o,input:u,output:c},p={filterSize:s,strides:r,pad:a,dimRoundingMode:i};return Ze.runKernel("MaxPoolGrad",h,p)}}),uc={kernelName:"PadV2",inputsToSave:["x"],gradFunc:(e,t,n)=>{const s=t[0],{paddings:r}=n,a=r.map(e=>e[0]);return{x:()=>Hs(e,a,s.shape)}}},cc={kernelName:"SpaceToBatchND",gradFunc:(e,t,n)=>{const{blockShape:s,paddings:r}=n;return{x:()=>Ks(e,s,r)}}},hc={kernelName:"SplitV",gradFunc:(e,t,n)=>{const{axis:s}=n;return{x:()=>Us(e,s)}}};const pc=[nu,su,ru,au,iu,ou,lu,uu,cu,hu,pu,du,mu,yu,bu,xu,wu,ku,vu,Nu,Iu,Cu,Tu,Su,$u,Au,Ru,Fu,Du,_u,{kernelName:"RealDiv",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=Ir(n.shape,s.shape);return{a:()=>{const t=ps(e,Xt(s,"float32")),a=Nr(n.shape,r);return a.length>0?Ps(oa(t,a),n.shape):t},b:()=>{let t=ds(e,Xt(n,"float32"));const a=Nr(s.shape,r);a.length>0&&(t=Ps(oa(t,a),s.shape));const i=Ra(s);return na(ps(t,Xt(i,"float32")))}}}},Ou,Mu,Lu,zu,Bu,Wu,Pu,Vu,Uu,ju,qu,Ku,Xu,Yu,Ju,Zu,Qu,ec,nc,rc,rc,ac,oc,{kernelName:"MaxPool",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{filterSize:a,strides:i,pad:o}=n;return{x:()=>lc(e,s,r,a,i,o)}}},{kernelName:"Mean",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{axis:r}=n,a=x(r,s.shape),i=p(ha(s.shape,a)[1]);return{x:()=>{const t=s.shape.slice();a.forEach(e=>{t[e]=1});const n=Ps(e,t);return ps(ds(n,La(s.shape,"float32")),i)}}}},{kernelName:"Min",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const s=n,{axis:r}=s,[a,i]=t,o=sc(e,i,a,x(r,a.shape));return{x:()=>o.x()}}},{kernelName:"Minimum",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>ds(e,Xt(Kr(n,s),"float32")),b:()=>ds(e,Xt(Pr(n,s),"float32"))}}},{kernelName:"MirrorPad",inputsToSave:["x"],gradFunc:(e,t,n)=>{const s=t[0],{paddings:r}=n,a=r.map(e=>e[0]);return{x:()=>Hs(e,a,s.shape)}}},{kernelName:te,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=Ir(n.shape,s.shape);return{a:()=>{const t=Nr(n.shape,r);return t.length>0?Ps(oa(e,t),n.shape):e},b:()=>{const t=ds(e,na(zr(ps(n,s)))),a=Nr(s.shape,r);return a.length>0?Ps(oa(t,a),s.shape):t}}}},{kernelName:"Multiply",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=Ir(n.shape,s.shape);return{a:()=>{const t=ds(e,Xt(s,"float32")),a=Nr(n.shape,r);return a.length>0?Ps(oa(t,a),n.shape):t},b:()=>{const t=ds(e,Xt(n,"float32")),a=Nr(s.shape,r);return a.length>0?Ps(oa(t,a),s.shape):t}}}},{kernelName:"Neg",gradFunc:e=>({x:()=>na(e)})},{kernelName:"OneHot",inputsToSave:["indices"],gradFunc:(e,t)=>{const n=t[0];return{indices:()=>Ma(n.shape,"float32")}}},{kernelName:"OnesLike",gradFunc:e=>({x:()=>Tr(e)})},{kernelName:"Pack",saveAllInputs:!0,gradFunc:(e,t,n)=>{const{axis:s}=n;return eo(e,s).map(e=>()=>e)}},uc,uc,{kernelName:ne,inputsToSave:["a","b"],outputsToSave:[!0],gradFunc:(e,t)=>{const[n,s,r]=t,a=n,i=s,o=Ir(a.shape,i.shape);return{a:()=>{const t=Xt(i,"float32");let n=ds(e,ds(t,qa(a,ia(t,Ii(1)))));const s=Nr(a.shape,o);return s.length>0&&(n=oa(n,s)),Ps(n,a.shape)},b:()=>{const t=Pr(a,0),n=Sr(t,Jr(a),Tr(a));let s=ds(e,ds(r,n));const l=Nr(i.shape,o);return l.length>0&&(s=oa(s,l)),Ps(s,i.shape)}}}},{kernelName:"Prelu",inputsToSave:["x","alpha"],gradFunc:(e,t)=>{const[n,s]=t,r=Pr(n,0);return{x:()=>Sr(r,e,ds(e,s)),alpha:()=>{let t=Sr(r,Tr(e),ds(e,n));const a=Nr(s.shape,e.shape);return a.length>0&&(t=oa(t,a)),Ps(t,s.shape)}}}},{kernelName:"Reciprocal",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ps(e,na(Ra(n)))}}},{kernelName:"Relu6",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t,s=ds(Kr(n,6),Hi(n));return{x:()=>ds(e,Xt(s,"float32"))}}},{kernelName:"Relu",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ds(e,Xt(Hi(n),"float32"))}}},{kernelName:"Reshape",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Ps(e,n.shape)}}},{kernelName:"ResizeBilinear",inputsToSave:["images"],gradFunc:(e,t,n)=>{const[s]=t,r={dy:e,images:s};return{images:()=>Ze.runKernel("ResizeBilinearGrad",r,n)}}},{kernelName:"ResizeNearestNeighbor",inputsToSave:["images"],gradFunc:(e,t,n)=>{const[s]=t,r={dy:e,images:s};return{images:()=>Ze.runKernel("ResizeNearestNeighborGrad",r,n)}}},{kernelName:"Reverse",gradFunc:(e,t,n)=>{const{dims:s}=n,r=x(s,e.shape);return{x:()=>yi(e,r)}}},{kernelName:"Round",gradFunc:e=>({x:()=>Tr(e)})},{kernelName:"Rsqrt",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>na(ps(e,ds(qa(n,1.5),2)))}}},{kernelName:"Select",inputsToSave:["condition"],gradFunc:(e,t)=>{const[n]=t;return{condition:()=>Xt(Tr(n),"float32"),t:()=>ds(e,Xt(n,e.dtype)),e:()=>ds(e,Xt(xa(n),e.dtype))}}},{kernelName:"Selu",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Pr(n,Ii(0)),s=Ii(1.7580993408473768),r=Ii(Ll),a=ds(e,r),i=ds(ds(e,s),Fr(Xt(n,"float32")));return Sr(t,a,i)}}}},{kernelName:"Sigmoid",outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ds(e,ds(n,ia(Ii(1),n)))}}},{kernelName:"Sign",gradFunc:e=>({x:()=>Tr(e)})},{kernelName:se,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ds(fr(Xt(n,"float32")),e)}}},{kernelName:"Sinh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ds(mr(Xt(n,"float32")),e)}}},{kernelName:"Slice",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{begin:r,size:a}=n,i=s.shape,[o,l]=Un(s,r,a),u=[];for(let t=0;t<e.rank;t++)u.push([o[t],i[t]-o[t]-l[t]]);return{x:()=>Pa(e,u)}}},{kernelName:"Softmax",outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s]=t,{dim:r}=n,a=ds(e,s);return{logits:()=>ia(a,ds(oa(a,[r],!0),s))}}},{kernelName:"Softplus",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ds(e,Gs(n))}}},cc,cc,hc,hc,{kernelName:"Sqrt",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ps(e,ds(Wi(Xt(n,"float32")),2))}}},{kernelName:"SquaredDifference",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=Ii(2);return{a:()=>ds(e,ds(r,ia(n,s))),b:()=>ds(e,ds(r,ia(s,n)))}}},{kernelName:"Square",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ds(e,ds(Xt(n,"float32"),2))}}},{kernelName:"Step",gradFunc:e=>({x:()=>Tr(e)})},{kernelName:re,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=Ir(n.shape,s.shape);return{a:()=>{let t=e;const s=Nr(n.shape,r);return s.length>0&&(t=oa(t,s)),Ps(t,n.shape)},b:()=>{let t=e;const n=Nr(s.shape,r);return n.length>0&&(t=oa(t,n)),Ps(na(t),s.shape)}}}},{kernelName:"Sum",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,r=s.shape.slice(),{axis:a}=n;x(a,s.shape).forEach(e=>{r[e]=1});const i=Ps(e,r),o=ds(i,La(s.shape,"float32"));return{x:()=>o}}},{kernelName:ae,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ps(e,Ra(fr(n)))}}},{kernelName:"Tanh",outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ds(ia(Ii(1),Ra(n)),e)}}},{kernelName:"Tile",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{reps:r}=n;return{x:()=>{let t=Tr(s);if(1===s.rank)for(let n=0;n<r[0];++n)t=cs(t,Hs(e,[n*s.shape[0]],[s.shape[0]]));else if(2===s.rank)for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)t=cs(t,Hs(e,[n*s.shape[0],a*s.shape[1]],[s.shape[0],s.shape[1]]));else if(3===s.rank)for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)for(let i=0;i<r[2];++i)t=cs(t,Hs(e,[n*s.shape[0],a*s.shape[1],i*s.shape[2]],[s.shape[0],s.shape[1],s.shape[2]]));else{if(4!==s.rank)throw new Error("Gradient for tile operation is not implemented for rank-"+s.rank+" tensors yet.");for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)for(let i=0;i<r[2];++i)for(let o=0;o<r[3];++o)t=cs(t,Hs(e,[n*s.shape[0],a*s.shape[1],i*s.shape[2],o*s.shape[3]],[s.shape[0],s.shape[1],s.shape[2],s.shape[3]]))}return t}}}},{kernelName:"Transpose",gradFunc:(e,t,n)=>{const s=n,{perm:r}=s,a=ma(r);return{x:()=>gn(e,a)}}},{kernelName:"Unpack",gradFunc:(e,t,n)=>{const s=n,{axis:r}=s;return{value:()=>Gi(e,r)}}},{kernelName:"UnsortedSegmentSum",inputsToSave:["segmentIds"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>function(e,t){const n=Ca(t,Tr(t)),s=Br(e,n);let r=Wr(t,Ii(0,"int32"));const a=s.rank-r.rank;for(let e=0;e<a;++e)r=Dr(r,e+1);r=ba(r,La(s.shape,"bool"));const i=Tr(s);return Sr(r,s,i)}(e,n)}}},{kernelName:"ZerosLike",gradFunc:e=>({x:()=>Tr(e)})}];for(const e of pc)pe(e);let dc;function fc(){return null==dc&&(dc=us().epsilon()),dc}De().prototype.abs=function(){return this.throwIfDisposed(),fs(this)},De().prototype.acos=function(){return this.throwIfDisposed(),ms(this)},De().prototype.acosh=function(){return this.throwIfDisposed(),gs(this)},De().prototype.add=function(e){return this.throwIfDisposed(),cs(this,e)},De().prototype.all=function(e,t){return this.throwIfDisposed(),bs(this,e,t)},De().prototype.any=function(e,t){return this.throwIfDisposed(),xs(this,e,t)},De().prototype.argMax=function(e){return this.throwIfDisposed(),ws(this,e)},De().prototype.argMin=function(e){return this.throwIfDisposed(),ks(this,e)},De().prototype.asScalar=function(){return this.throwIfDisposed(),l(1===this.size,()=>"The array must have only 1 element."),Ps(this,[])},De().prototype.asType=function(e){return this.throwIfDisposed(),Xt(this,e)},De().prototype.as1D=function(){return this.throwIfDisposed(),Ps(this,[this.size])},De().prototype.as2D=function(e,t){return this.throwIfDisposed(),Ps(this,[e,t])},De().prototype.as3D=function(e,t,n){return this.throwIfDisposed(),Ps(this,[e,t,n])},De().prototype.as4D=function(e,t,n,s){return this.throwIfDisposed(),Ps(this,[e,t,n,s])},De().prototype.as5D=function(e,t,n,s,r){return this.throwIfDisposed(),Ps(this,[e,t,n,s,r])},De().prototype.asin=function(){return this.throwIfDisposed(),vs(this)},De().prototype.asinh=function(){return this.throwIfDisposed(),Ns(this)},De().prototype.atan=function(){return this.throwIfDisposed(),Is(this)},De().prototype.atan2=function(e){return this.throwIfDisposed(),Cs(this,e)},De().prototype.atanh=function(){return this.throwIfDisposed(),Ss(this)},De().prototype.avgPool=function(e,t,n,s){return this.throwIfDisposed(),Ws(this,e,t,n,s)},De().prototype.batchToSpaceND=function(e,t){return this.throwIfDisposed(),Ks(this,e,t)},De().prototype.batchNorm=function(e,t,n,s,r){return this.throwIfDisposed(),Xs(this,e,t,n,s,r)},De().prototype.broadcastTo=function(e){return this.throwIfDisposed(),er(this,e)},De().prototype.cast=function(e){return this.throwIfDisposed(),Xt(this,e)},De().prototype.ceil=function(){return this.throwIfDisposed(),tr(this)},De().prototype.clipByValue=function(e,t){return this.throwIfDisposed(),nr(this,e,t)},De().prototype.concat=function(e,t){return this.throwIfDisposed(),e instanceof Fe&&(e=[e]),Us([this,...e],t)},De().prototype.conv1d=function(e,t,n,s,r,a){return this.throwIfDisposed(),lr(this,e,t,n,s,r,a)},De().prototype.conv2dTranspose=function(e,t,n,s,r){return this.throwIfDisposed(),cr(this,e,t,n,s,r)},De().prototype.conv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),or(this,e,t,n,s,r,a)},De().prototype.cos=function(){return this.throwIfDisposed(),fr(this)},De().prototype.cosh=function(){return this.throwIfDisposed(),mr(this)},De().prototype.cumsum=function(e,t,n){return this.throwIfDisposed(),gr(this,e,t,n)},De().prototype.depthToSpace=function(e,t){return this.throwIfDisposed(),br(this,e,t)},De().prototype.depthwiseConv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),xr(this,e,t,n,s,r,a)},De().prototype.dilation2d=function(e,t,n,s,r){return this.throwIfDisposed(),kr(this,e,t,n,s,r)},De().prototype.divNoNan=function(e){return this.throwIfDisposed(),Er(this,e)},De().prototype.div=function(e){return this.throwIfDisposed(),ps(this,e)},De().prototype.dot=function(e){return this.throwIfDisposed(),$r(this,e)},De().prototype.elu=function(){return this.throwIfDisposed(),Ar(this)},De().prototype.equal=function(e){return this.throwIfDisposed(),Cr(this,e)},De().prototype.erf=function(){return this.throwIfDisposed(),Rr(this)},De().prototype.exp=function(){return this.throwIfDisposed(),Fr(this)},De().prototype.expandDims=function(e){return this.throwIfDisposed(),Dr(this,e)},De().prototype.expm1=function(){return this.throwIfDisposed(),_r(this)},De().prototype.fft=function(){return this.throwIfDisposed(),Mi(this)},De().prototype.flatten=function(){return this.throwIfDisposed(),Ps(this,[this.size])},De().prototype.floor=function(){return this.throwIfDisposed(),zr(this)},De().prototype.floorDiv=function(e){return this.throwIfDisposed(),hs(this,e)},De().prototype.gather=function(e,t){return this.throwIfDisposed(),Br(this,e,t)},De().prototype.greaterEqual=function(e){return this.throwIfDisposed(),Wr(this,e)},De().prototype.greater=function(e){return this.throwIfDisposed(),Pr(this,e)},De().prototype.ifft=function(){return this.throwIfDisposed(),Li(this)},De().prototype.irfft=function(){return this.throwIfDisposed(),zi(this)},De().prototype.isFinite=function(){return this.throwIfDisposed(),Ur(this)},De().prototype.isInf=function(){return this.throwIfDisposed(),Gr(this)},De().prototype.isNaN=function(){return this.throwIfDisposed(),Hr(this)},De().prototype.leakyRelu=function(e){return this.throwIfDisposed(),jr(this,e)},De().prototype.lessEqual=function(e){return this.throwIfDisposed(),Kr(this,e)},De().prototype.less=function(e){return this.throwIfDisposed(),qr(this,e)},De().prototype.localResponseNormalization=function(e,t,n,s){return this.throwIfDisposed(),Yr(this,e,t,n,s)},De().prototype.logSigmoid=function(){return this.throwIfDisposed(),ra(this)},De().prototype.logSoftmax=function(e){return this.throwIfDisposed(),la(this,e)},De().prototype.logSumExp=function(e,t){return this.throwIfDisposed(),ya(this,e,t)},De().prototype.log=function(){return this.throwIfDisposed(),Jr(this)},De().prototype.log1p=function(){return this.throwIfDisposed(),Zr(this)},De().prototype.logicalAnd=function(e){return this.throwIfDisposed(),ba(this,e)},De().prototype.logicalNot=function(){return this.throwIfDisposed(),xa(this)},De().prototype.logicalOr=function(e){return this.throwIfDisposed(),wa(this,e)},De().prototype.logicalXor=function(e){return this.throwIfDisposed(),ka(this,e)},De().prototype.matMul=function(e,t,n){return this.throwIfDisposed(),fn(this,e,t,n)},De().prototype.maxPool=function(e,t,n,s){return this.throwIfDisposed(),va(this,e,t,n,s)},De().prototype.max=function(e,t){return this.throwIfDisposed(),aa(this,e,t)},De().prototype.maximum=function(e){return this.throwIfDisposed(),Ca(this,e)},De().prototype.mean=function(e,t){return this.throwIfDisposed(),Sa(this,e,t)},De().prototype.min=function(e,t){return this.throwIfDisposed(),Ta(this,e,t)},De().prototype.minimum=function(e){return this.throwIfDisposed(),Ea(this,e)},De().prototype.mirrorPad=function(e,t){return this.throwIfDisposed(),$a(this,e,t)},De().prototype.mod=function(e){return this.throwIfDisposed(),Aa(this,e)},De().prototype.mul=function(e){return this.throwIfDisposed(),ds(this,e)},De().prototype.neg=function(){return this.throwIfDisposed(),na(this)},De().prototype.norm=function(e,t,n){return this.throwIfDisposed(),ao(this,e,t,n)},De().prototype.notEqual=function(e){return this.throwIfDisposed(),Oa(this,e)},De().prototype.oneHot=function(e,t=1,n=0){return this.throwIfDisposed(),mn(this,e,t,n)},De().prototype.onesLike=function(){return this.throwIfDisposed(),za(this)},De().prototype.pad=function(e,t){return this.throwIfDisposed(),Pa(this,e,t)},De().prototype.pool=function(e,t,n,s,r){return this.throwIfDisposed(),ja(this,e,t,n,s,r)},De().prototype.pow=function(e){return this.throwIfDisposed(),qa(this,e)},De().prototype.prelu=function(e){return this.throwIfDisposed(),Ka(this,e)},De().prototype.prod=function(e,t){return this.throwIfDisposed(),Xa(this,e,t)},De().prototype.reciprocal=function(){return this.throwIfDisposed(),fi(this)},De().prototype.relu=function(){return this.throwIfDisposed(),mi(this)},De().prototype.relu6=function(){return this.throwIfDisposed(),gi(this)},De().prototype.reshapeAs=function(e){return this.throwIfDisposed(),Ps(this,e.shape)},De().prototype.reshape=function(e){return this.throwIfDisposed(),Ps(this,e)},De().prototype.resizeBilinear=function(e,t,n){return this.throwIfDisposed(),Xo(this,e,t,n)},De().prototype.resizeNearestNeighbor=function(e,t,n){return this.throwIfDisposed(),Yo(this,e,t,n)},De().prototype.reverse=function(e){return this.throwIfDisposed(),yi(this,e)},De().prototype.rfft=function(){return this.throwIfDisposed(),Pi(this)},De().prototype.round=function(){return this.throwIfDisposed(),vi(this)},De().prototype.rsqrt=function(){return this.throwIfDisposed(),Ni(this)},De().prototype.selu=function(){return this.throwIfDisposed(),Ci(this)},De().prototype.separableConv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),Si(this,e,t,n,s,r,a)},De().prototype.sigmoid=function(){return this.throwIfDisposed(),Gs(this)},De().prototype.sign=function(){return this.throwIfDisposed(),Ei(this)},De().prototype.sin=function(){return this.throwIfDisposed(),$i(this)},De().prototype.sinh=function(){return this.throwIfDisposed(),Ai(this)},De().prototype.slice=function(e,t){return this.throwIfDisposed(),Hs(this,e,t)},De().prototype.softmax=function(e){return this.throwIfDisposed(),Oi(this,e)},De().prototype.softplus=function(){return this.throwIfDisposed(),sa(this)},De().prototype.spaceToBatchND=function(e,t){return this.throwIfDisposed(),Ha(this,e,t)},De().prototype.split=function(e,t){return this.throwIfDisposed(),Bi(this,e,t)},De().prototype.sqrt=function(){return this.throwIfDisposed(),Wi(this)},De().prototype.square=function(){return this.throwIfDisposed(),Ra(this)},De().prototype.squaredDifference=function(e){return this.throwIfDisposed(),Vi(this,e)},De().prototype.squeeze=function(e){return this.throwIfDisposed(),Ui(this,e)},De().prototype.stack=function(e,t){this.throwIfDisposed();const n=e instanceof Fe?[this,e]:[this,...e];return Gi(n,t)},De().prototype.step=function(e){return this.throwIfDisposed(),Hi(this,e)},De().prototype.stridedSlice=function(e,t,n,s,r,a,i,o){return this.throwIfDisposed(),ji(this,e,t,n,s,r,a,i,o)},De().prototype.sub=function(e){return this.throwIfDisposed(),ia(this,e)},De().prototype.sum=function(e,t){return this.throwIfDisposed(),oa(this,e,t)},De().prototype.tan=function(){return this.throwIfDisposed(),qi(this)},De().prototype.tanh=function(){return this.throwIfDisposed(),js(this)},De().prototype.tile=function(e){return this.throwIfDisposed(),Or(this,e)},De().prototype.toBool=function(){return this.throwIfDisposed(),Xt(this,"bool")},De().prototype.toFloat=function(){return this.throwIfDisposed(),Xt(this,"float32")},De().prototype.toInt=function(){return this.throwIfDisposed(),Xt(this,"int32")},De().prototype.topk=function(e,t){return this.throwIfDisposed(),Yi(this,e,t)},De().prototype.transpose=function(e){return this.throwIfDisposed(),gn(this,e)},De().prototype.unique=function(e){return this.throwIfDisposed(),Zi(this,e)},De().prototype.unsortedSegmentSum=function(e,t){return this.throwIfDisposed(),Qi(this,e,t)},De().prototype.unstack=function(e){return this.throwIfDisposed(),eo(this,e)},De().prototype.where=function(e,t){return this.throwIfDisposed(),Sr(e,this,t)},De().prototype.zerosLike=function(){return this.throwIfDisposed(),Tr(this)};class mc extends Error{constructor(e){super(e),Object.setPrototypeOf(this,mc.prototype)}}class gc extends Error{constructor(e){super(e),Object.setPrototypeOf(this,gc.prototype)}}class yc extends Error{constructor(e){super(e),Object.setPrototypeOf(this,yc.prototype)}}class bc extends Error{constructor(e){super(e),Object.setPrototypeOf(this,bc.prototype)}}class xc extends Error{constructor(e){super(e),Object.setPrototypeOf(this,xc.prototype)}}Error;function wc(e,t){if(Array.isArray(e)){let n=[];for(let s=0;s<t;s++)n=n.concat(e);return n}{const n=new Array(t);return n.fill(e),n}}function kc(e,t){if(!e)throw new xc(t)}function vc(e,t){let n=0;for(const s of e)s===t&&n++;return n}function Nc(e){return 1===e.length?e[0]:e}function Ic(e){return Array.isArray(e)?e:[e]}function Cc(e){const t=e.replace(/(.)([A-Z][a-z0-9]+)/g,"$1_$2").replace(/([a-z])([A-Z])/g,"$1_$2").toLowerCase();return"_"!==t[0]?t:"private"+t}function Sc(e){return e.length<=1||-1===e.indexOf("_")?e:e.replace(/[_]+(\w|$)/g,(e,t)=>t.toUpperCase())}let Tc={};function Ec(e){if(null==e)return null;const t={};return t.className=e.getClassName(),t.config=e.getConfig(),t}function $c(e,t={},n={},s="object",r=!1){if("string"==typeof e){const r=e;let a;if(r in n)a=n[r];else if(r in Tc)a=Tc[r];else if(a=t[r],null==a)throw new yc(`Unknown ${s}: ${e}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);return a}{const a=e;if(null==a.className||null==a.config)throw new yc(s+": Improper config format: "+JSON.stringify(a)+".\n'className' and 'config' must set.");const i=a.className;let o,l;if(i in n?[o,l]=n[i]:i in Tc?[o,l]=Tc.className:i in t&&([o,l]=t[i]),null==o)throw new yc(`Unknown ${s}: ${i}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);if(null!=l){const e={};for(const t of Object.keys(Tc))e[t]=Tc[t];for(const t of Object.keys(n))e[t]=n[t];a.config.customObjects=e;const t=Object.assign({},Tc);for(const e of Object.keys(n))Tc[e]=n[e];!function e(t){if(null!=t&&"object"==typeof t)if(Array.isArray(t))t.forEach(t=>e(t));else{const n=Object.keys(t);for(const s of n){const n=t[s];null!=n&&"object"==typeof n&&(Array.isArray(n)||"ndarray"!==n.type||"number"!=typeof n.value?e(n):t[s]=n.value)}}}(a.config);const s=l(o,a.config,n,r);return Tc=Object.assign({},t),s}{const e=Object.assign({},Tc);for(const e of Object.keys(n))Tc[e]=n[e];const t=new o(a.config);return Tc=Object.assign({},e),t}}}function Ac(e,t){return-1*function(e,t){return e<t?-1:e>t?1:0}(e,t)}function Rc(e){if(null==e)return e;const t=[];for(const n of e)-1===t.indexOf(n)&&t.push(n);return t}function Fc(e){if(null==e)throw new yc("Invalid value in obj: "+JSON.stringify(e));for(const t in e)if(e.hasOwnProperty(t))return!1;return!0}function Dc(e,t,n){if(null!=n&&e.indexOf(n)<0)throw new yc(`${n} is not a valid ${t}.  Valid values are ${e} or null/undefined.`)}function _c(e,t,n=0,s=1/0){return kc(n>=0),kc(s>=n),Array.isArray(e)&&e.length>=n&&e.length<=s&&e.every(e=>typeof e===t)}function Oc(e,t){Array.isArray(e)?(l(e.length>0,()=>t+" is unexpectedly an empty array."),e.forEach((e,n)=>Oc(e,`element ${n+1} of ${t}`))):l(Number.isInteger(e)&&e>0,()=>`Expected ${t} to be a positive integer, but got `+function e(t){return null===t?"null":Array.isArray(t)?"["+t.map(t=>e(t)).join(",")+"]":"string"==typeof t?`"${t}"`:""+t}(e)+".")}function Mc(e){return"relu"===e?"relu":"linear"===e?"linear":"elu"===e?"elu":null}function Lc(e,t){return rs(()=>Wi(oa(ds(e,e),t,!0)))}class zc extends jn{getConfig(){return{}}}class Bc extends zc{constructor(e){super(),this.defaultMaxValue=2,this.defaultAxis=0,this.maxValue=null!=e.maxValue?e.maxValue:this.defaultMaxValue,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return rs(()=>{const t=Lc(e,this.axis),n=nr(t,0,this.maxValue);return ds(e,ps(n,cs(fc(),t)))})}getConfig(){return{maxValue:this.maxValue,axis:this.axis}}}Bc.className="MaxNorm",Kn(Bc);class Pc extends zc{constructor(e){super(),this.defaultAxis=0,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return rs(()=>ps(e,cs(fc(),Lc(e,this.axis))))}getConfig(){return{axis:this.axis}}}Pc.className="UnitNorm",Kn(Pc);class Wc extends zc{apply(e){return mi(e)}}Wc.className="NonNeg",Kn(Wc);class Vc extends zc{constructor(e){super(),this.defaultMinValue=0,this.defaultMaxValue=1,this.defaultRate=1,this.defaultAxis=0,this.minValue=null!=e.minValue?e.minValue:this.defaultMinValue,this.maxValue=null!=e.maxValue?e.maxValue:this.defaultMaxValue,this.rate=null!=e.rate?e.rate:this.defaultRate,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return rs(()=>{const t=Lc(e,this.axis),n=cs(ds(this.rate,nr(t,this.minValue,this.maxValue)),ds(1-this.rate,t));return ds(e,ps(n,cs(fc(),t)))})}getConfig(){return{minValue:this.minValue,maxValue:this.maxValue,rate:this.rate,axis:this.axis}}}Vc.className="MinMaxNorm",Kn(Vc);const Uc={maxNorm:"MaxNorm",minMaxNorm:"MinMaxNorm",nonNeg:"NonNeg",unitNorm:"UnitNorm"};function Gc(e){return Ec(e)}function Hc(e,t={}){return $c(e,qn.getMap().classNameMap,t,"constraint")}function jc(e){if(null==e)return null;if("string"==typeof e){return Hc({className:e in Uc?Uc[e]:e,config:{}})}return e instanceof zc?e:Hc(e)}var qc=Object.freeze({__proto__:null,maxNorm:function(e){return new Bc(e)},unitNorm:function(e){return new Pc(e)},nonNeg:function(){return new Wc},minMaxNorm:function(e){return new Vc(e)}});const Kc=["channelsFirst","channelsLast"],Xc=["nearest","bilinear"],Yc=["valid","same","causal"],Jc=["max","avg"],Zc=["sum","mul","concat","ave"],Qc=new Map;function eh(e){Dc(Kc,"DataFormat",e)}function th(e){Dc(Yc,"PaddingMode",e)}function nh(e){Dc(Jc,"PoolMode",e)}const sh=[];function rh(e,t){sh.push(e);try{const e=t();return sh.pop(),e}catch(e){throw sh.pop(),e}}function ah(e){if(!lh(e))throw new Error("Not a valid tensor name: '"+e+"'");return(0===sh.length?"":sh.join("/")+"/")+e}function ih(e){if(!lh(e))throw new Error("Not a valid tensor name: '"+e+"'");Qc.has(e)||Qc.set(e,0);const t=Qc.get(e);if(Qc.set(e,Qc.get(e)+1),t>0){const n=`${e}_${t}`;return Qc.set(n,1),n}return e}const oh=new RegExp(/^[A-Za-z0-9][-A-Za-z0-9\._\/]*$/);function lh(e){return!!e.match(oh)}function uh(e,t,n){null==t&&(t=0),null==n&&(n=e.length);let s=1;for(let r=t;r<n;++r)s*=e[r];return s}function ch(e){return Ki(e=Array.isArray(e)?new Float32Array(e):e)}function hh(e){return Ta(ch(e)).dataSync()[0]}function ph(e){return aa(ch(e)).dataSync()[0]}function dh(e,t){if(t<e)throw new yc(`end (${t}) < begin (${e}) is forbidden.`);const n=[];for(let s=e;s<t;++s)n.push(s);return n}function fh(e,t){return e.asType(t)}function mh(e,t=-1){const n=e.shape.slice();return t<0&&(t=n.length+t+1),n.splice(t,0,1),e.reshape(n)}function gh(e,t,n){return rs(()=>{switch(e.rank){case 1:return Ri(e,t,n);case 2:return Fi(e,[t,0],[n,e.shape[1]]);case 3:return Di(e,[t,0,0],[n,e.shape[1],e.shape[2]]);case 4:return _i(e,[t,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3]]);case 5:return Hs(e,[t,0,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3],e.shape[4]]);case 6:return Hs(e,[t,0,0,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3],e.shape[4],e.shape[5]]);default:throw new yc("sliceAlongFirstAxis() received an unsupported tensor rank: "+e.rank)}})}function yh(e,t,n){return rs(()=>{switch(e.rank){case 1:return Ri(e,t,n);case 2:return Fi(e,[0,t],[e.shape[0],n]);case 3:return Di(e,[0,0,t],[e.shape[0],e.shape[1],n]);case 4:return _i(e,[0,0,0,t],[e.shape[0],e.shape[1],e.shape[2],n]);default:throw new yc("sliceAlongLastAxis() received an unsupported tensor rank: "+e.rank)}})}function bh(e,t,n,s){return rs(()=>{switch(e.rank){case 1:return Ri(e,t,n);case 2:switch(s){case 1:return gh(e,t,n);case 2:return yh(e,t,n);default:throw new yc("The axis is not within the rank of the tensor "+s)}case 3:switch(s){case 1:return gh(e,t,n);case 2:return Di(e,[0,t,0],[e.shape[0],n,e.shape[2]]);case 3:return yh(e,t,n);default:throw new yc("The axis is not within the rank of the tensor "+s)}case 4:switch(s){case 1:return gh(e,t,n);case 2:return _i(e,[0,t,0,0],[e.shape[0],n,e.shape[2],e.shape[3]]);case 3:return _i(e,[0,0,t,0],[e.shape[0],e.shape[1],n,e.shape[3]]);case 4:return yh(e,t,n);default:throw new yc("The axis is not within the rank of the tensor "+s)}default:throw new yc("sliceAlongLastAxis() received an unsupported tensor rank: "+e.rank)}})}function xh(e,t=-1){let n;return t<0&&(n=e[0].rank,t=0!==n?n:0),t===e[0].rank&&(t=-1),Us(e,t)}function wh(e,t){switch(e.rank){case 1:return sr([e,t]);case 2:return rr([e,t],0);case 3:return ar([e,t],0);case 4:return ir([e,t],0);default:throw new yc("concatAlongFirstAxis() received an unsupported tensor rank: "+e.rank)}}function kh(e,t){if(Array.isArray(t)||(t=[t]),e.rank!==t.length)throw new yc(`The length of input n (${t.length}) does not match the number of dimensions in input x (${e.rank})`);return Or(e,t)}function vh(e,t=0,n=1,s,r){return ci(e,t,n,s,r)}function Nh(e,t,n,s){if(e.rank<2||t.rank<2)throw new bc(`dot requires both inputs to be rank >= 2 but got x shape = ${e.shape} and y shape = ${t.shape}`);if(t.rank>=3){if(e.shape.slice(-1)[0]!==t.shape.slice(-2)[0])throw new bc(`If rank y >= 3, then the second last dim of y must equal the last dim of x but got x shape = ${e.shape} and  y shape = `+t.shape)}if(2===e.rank&&2===t.rank){return Io({a:e,b:t,transposeA:!1,transposeB:!1,bias:s?Sh(e.rank,s,"channelsLast"):null,activation:n})}{const r=e.shape.slice(),a=r.pop();e=e.reshape([-1,a]);const i=t.shape.slice(),o=i.pop(),l=i.pop(),u=[...i,o],c=Array.from({length:t.rank},(e,n)=>0===n?t.rank-2:n<=t.rank-2?n-1:n);t=t.transpose(c).reshape([l,-1]);const h=[...r,...u];return Io({a:e,b:t,transposeA:!1,transposeB:!1,bias:s?Sh(e.rank,s,"channelsLast"):null,activation:n}).reshape(h)}}function Ih(e,t,n){return rs(()=>(t=Array.isArray(t)?Ki(t,"int32"):t.toInt(),Br(e,t,n)))}function Ch(e){return ds(e,e)}function Sh(e,t,n){const s=t.shape;if(1!==t.rank&&t.rank!==e)throw new yc("Unexpected bias dimensions: "+t.rank+"; expected it to be 1 or "+e);if(5===e){if("channelsFirst"===n)return 1===s.length?t.reshape([1,s[0],1,1,1]):t.reshape([1,s[3],s[0],s[1],s[2]]);if("channelsLast"===n)return 1===s.length?t.reshape([1,1,1,1,s[0]]):t.reshape([1].concat(s))}else if(4===e){if("channelsFirst"===n)return 1===s.length?t.reshape([1,s[0],1,1]):t.reshape([1,s[2],s[0],s[1]]);if("channelsLast"===n)return 1===s.length?t.reshape([1,1,1,s[0]]):t.reshape([1].concat(s))}else if(3===e){if("channelsFirst"===n)return 1===s.length?t.reshape([1,s[0],1]):t.reshape([1,s[1],s[0]]);if("channelsLast"===n)return 1===s.length?t.reshape([1,1,s[0]]):t.reshape([1].concat(s))}else if(e<3)return t;throw new yc("Unsupported input rank by biasAdd: "+t.rank)}function Th(e,t,n){return rs(()=>(null==n&&(n="channelsLast"),eh(n),e.add(Sh(e.rank,t,n))))}function Eh(e,t,n,s){return rs(()=>co(e,t,n,s))}function $h(e,t,n=!1){return n?e():t()}const Ah=["fanIn","fanOut","fanAvg"],Rh=["normal","uniform","truncatedNormal"];class Fh extends jn{fromConfigUsesCustomObjects(){return!1}getConfig(){return{}}}class Dh extends Fh{apply(e,t){return Ma(e,t)}}Dh.className="Zeros",Kn(Dh);class _h extends Fh{apply(e,t){return La(e,t)}}_h.className="Ones",Kn(_h);class Oh extends Fh{constructor(e){if(super(),"object"!=typeof e)throw new yc("Expected argument of type ConstantConfig but got "+e);if(void 0===e.value)throw new yc("config must have value set but got "+e);this.value=e.value}apply(e,t){return rs(()=>ds(Ii(this.value),La(e,t)))}getConfig(){return{value:this.value}}}Oh.className="Constant",Kn(Oh);class Mh extends Fh{constructor(e){super(),this.DEFAULT_MINVAL=-.05,this.DEFAULT_MAXVAL=.05,this.minval=e.minval||this.DEFAULT_MINVAL,this.maxval=e.maxval||this.DEFAULT_MAXVAL,this.seed=e.seed}apply(e,t){return hi(e,this.minval,this.maxval,t)}getConfig(){return{minval:this.minval,maxval:this.maxval,seed:this.seed}}}Mh.className="RandomUniform",Kn(Mh);class Lh extends Fh{constructor(e){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=e.mean||this.DEFAULT_MEAN,this.stddev=e.stddev||this.DEFAULT_STDDEV,this.seed=e.seed}apply(e,t){if("float32"!==(t=t||"float32")&&"int32"!==t)throw new bc(`randomNormal does not support dType ${t}.`);return vh(e,this.mean,this.stddev,t,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}Lh.className="RandomNormal",Kn(Lh);class zh extends Fh{constructor(e){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=e.mean||this.DEFAULT_MEAN,this.stddev=e.stddev||this.DEFAULT_STDDEV,this.seed=e.seed}apply(e,t){if("float32"!==(t=t||"float32")&&"int32"!==t)throw new bc(`truncatedNormal does not support dType ${t}.`);return Ji(e,this.mean,this.stddev,t,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}zh.className="TruncatedNormal",Kn(zh);class Bh extends Fh{constructor(e){super(),this.gain=null!=e.gain?e.gain:1}apply(e,t){return rs(()=>{if(2!==e.length||e[0]!==e[1])throw new yc("Identity matrix initializer can only be used for 2D square matrices.");return ds(this.gain,Mr(e[0]))})}getConfig(){return{gain:this.gain}}}Bh.className="Identity",Kn(Bh);class Ph extends Fh{constructor(e){if(super(),e.scale<0)throw new yc("scale must be a positive float. Got: "+e.scale);var t;this.scale=null==e.scale?1:e.scale,this.mode=null==e.mode?"fanIn":e.mode,t=this.mode,Dc(Ah,"FanMode",t),this.distribution=null==e.distribution?"normal":e.distribution,function(e){Dc(Rh,"Distribution",e)}(this.distribution),this.seed=e.seed}apply(e,t){const n=function(e,t="channelsLast"){let n,s;if(eh(t),2===e.length)n=e[0],s=e[1];else if(-1!==[3,4,5].indexOf(e.length)){if("channelsFirst"===t){const t=uh(e,2);n=e[1]*t,s=e[0]*t}else if("channelsLast"===t){const t=uh(e,0,e.length-2);n=e[e.length-2]*t,s=e[e.length-1]*t}}else{const t=uh(e);n=Math.sqrt(t),s=Math.sqrt(t)}return[n,s]}(e),s=n[0],r=n[1];let a=this.scale;if("fanIn"===this.mode?a/=Math.max(1,s):"fanOut"===this.mode?a/=Math.max(1,r):a/=Math.max(1,(s+r)/2),"normal"===this.distribution){const n=Math.sqrt(a);if("float32"!==(t=t||"float32")&&"int32"!==t)throw new bc(`${this.getClassName()} does not support dType ${t}.`);return Ji(e,0,n,t,this.seed)}{const n=Math.sqrt(3*a);return hi(e,-n,n,t)}}getConfig(){return{scale:this.scale,mode:this.mode,distribution:this.distribution,seed:this.seed}}}Ph.className="VarianceScaling",Kn(Ph);class Wh extends Ph{constructor(e){super({scale:1,mode:"fanAvg",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return Ph.className}}Wh.className="GlorotUniform",Kn(Wh);class Vh extends Ph{constructor(e){super({scale:1,mode:"fanAvg",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return Ph.className}}Vh.className="GlorotNormal",Kn(Vh);class Uh extends Ph{constructor(e){super({scale:2,mode:"fanIn",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return Ph.className}}Uh.className="HeNormal",Kn(Uh);class Gh extends Ph{constructor(e){super({scale:2,mode:"fanIn",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return Ph.className}}Gh.className="HeUniform",Kn(Gh);class Hh extends Ph{constructor(e){super({scale:1,mode:"fanIn",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return Ph.className}}Hh.className="LeCunNormal",Kn(Hh);class jh extends Ph{constructor(e){super({scale:1,mode:"fanIn",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return Ph.className}}jh.className="LeCunNormal",Kn(jh);class qh extends Fh{constructor(e){if(super(),this.DEFAULT_GAIN=1,this.gain=null==e.gain?this.DEFAULT_GAIN:e.gain,this.seed=e.seed,null!=this.seed)throw new bc("Random seed is not implemented for Orthogonal Initializer yet.")}apply(e,t){return rs(()=>{if(e.length<2)throw new bc("Shape must be at least 2D.");e[0]*e[1]>2e3&&console.warn(`Orthogonal initializer is being called on a matrix with more than 2000 (${e[0]*e[1]}) elements: Slowness may result.`);const t=vh(e[0]>e[1]?[e[1],e[0]]:e,0,1,"float32");let n=fl.gramSchmidt(t);return e[0]>e[1]&&(n=n.transpose()),ds(this.gain,n)})}getConfig(){return{gain:this.gain,seed:this.seed}}}qh.className="Orthogonal",Kn(qh);const Kh={constant:"Constant",glorotNormal:"GlorotNormal",glorotUniform:"GlorotUniform",heNormal:"HeNormal",heUniform:"HeUniform",identity:"Identity",leCunNormal:"LeCunNormal",leCunUniform:"LeCunUniform",ones:"Ones",orthogonal:"Orthogonal",randomNormal:"RandomNormal",randomUniform:"RandomUniform",truncatedNormal:"TruncatedNormal",varianceScaling:"VarianceScaling",zeros:"Zeros"};function Xh(e,t={}){return $c(e,qn.getMap().classNameMap,t,"initializer")}function Yh(e){return Ec(e)}function Jh(e){if("string"==typeof e){const t=e in Kh?Kh[e]:e;if("GlorotNormal"===t)return new Vh;if("GlorotUniform"===t)return new Wh;if("HeNormal"===t)return new Uh;if("HeUniform"===t)return new Gh;if("LeCunNormal"===t)return new Hh;if("LeCunUniform"===t)return new jh;{const e={};return e.className=t,e.config={},Xh(e)}}return e instanceof Fh?e:Xh(e)}var Zh=Object.freeze({__proto__:null,zeros:function(){return new Dh},ones:function(){return new _h},constant:function(e){return new Oh(e)},randomUniform:function(e){return new Mh(e)},randomNormal:function(e){return new Lh(e)},truncatedNormal:function(e){return new zh(e)},identity:function(e){return new Bh(e)},varianceScaling:function(e){return new Ph(e)},glorotUniform:function(e){return new Wh(e)},glorotNormal:function(e){return new Vh(e)},heNormal:function(e){return new Uh(e)},heUniform:function(e){return new Gh(e)},leCunNormal:function(e){return new Hh(e)},leCunUniform:function(e){return new jh(e)},orthogonal:function(e){return new qh(e)}});let Qh=0;function ep(){return Qh++}const tp={};function np(e=""){return e in tp||(tp[e]=0),tp[e]+=1,e+tp[e].toString()}function sp(e){return Array.isArray(e)&&Array.isArray(e[0])}function rp(e){return 0===e.length?[]:Array.isArray(e[0])?e:[e]}function ap(e){let t;if(Array.isArray(e)){if(1!==e.length)throw new yc("Expected Tensor length to be 1; got "+e.length);t=e[0]}else t=e;return t}function ip(e){if(Array.isArray(e)&&Array.isArray(e[0])){if(1===e.length)return(e=e)[0];throw new yc("Expected exactly 1 Shape; got "+e.length)}return e}function op(e){let t=0;for(const n of e)0===n.shape.length?t+=1:t+=n.shape.reduce((e,t)=>e*t);return t}class lp{constructor(e,t="float32",n="Variable",s=!0,r=null){this.dtype=null==t?"float32":t,this.shape=e.shape,this.id=ep(),n=null==n?"Variable":n,this.originalName=ah(n),this.name=ih(this.originalName),this.trainable_=s,this.constraint=r,this.val=to(e,this.trainable_,this.name,this.dtype)}read(){return this.assertNotDisposed(),this.val}write(e){return this.assertNotDisposed(),function(e,t){if(e.shape.toString()!==t.shape.toString())throw new Error("Shape mismatch: "+JSON.stringify(e.shape)+" vs. "+JSON.stringify(t.shape))}(this.val,e),this.val.id!==e.id&&(this.val.assign(e),null!=this.constraint&&this.val.assign(this.constraint.apply(this.val))),this}dispose(){this.assertNotDisposed(),this.val.dispose()}assertNotDisposed(){if(this.val.isDisposed)throw new Error(`LayersVariable ${this.name} is already disposed.`)}get trainable(){return this.trainable_}set trainable(e){this.trainable_=e,this.val.trainable=e}}function up(e){return e.map(e=>e.read())}function cp(e){e.forEach(e=>{e[0].write(e[1])})}class hp{constructor(e){this.dtype=e.dtype,this.shape=e.shape,null!=e.shape?this.ndim=e.shape.length:this.ndim=e.ndim,this.maxNDim=e.maxNDim,this.minNDim=e.minNDim,this.axes=e.axes||{}}}class pp{constructor(e,t,n,s,r,a,i){this.dtype=e,this.shape=t,this.sourceLayer=n,this.inputs=s,this.callArgs=r,this.outputTensorIndex=i,this.id=ep(),null!=a&&(this.originalName=ah(a),this.name=ih(this.originalName)),this.rank=t.length}}let dp=0;class fp{constructor(e,t){this.callArgs=t,this.id=dp++,this.outboundLayer=e.outboundLayer,this.inboundLayers=e.inboundLayers,this.nodeIndices=e.nodeIndices,this.tensorIndices=e.tensorIndices,this.inputTensors=e.inputTensors,this.outputTensors=e.outputTensors,this.inputMasks=e.inputMasks,this.outputMasks=e.outputMasks,this.inputShapes=e.inputShapes,this.outputShapes=e.outputShapes;for(const t of e.inboundLayers)null!=t&&t.outboundNodes.push(this);e.outboundLayer.inboundNodes.push(this)}getConfig(){const e=[];for(const t of this.inboundLayers)null!=t?e.push(t.name):e.push(null);return{outboundLayer:this.outboundLayer?this.outboundLayer.name:null,inboundLayers:e,nodeIndices:this.nodeIndices,tensorIndices:this.tensorIndices}}}let mp=0;class gp extends jn{constructor(e={}){super(),this._callHook=null,this._addedWeightNames=[],this._stateful=!1,this.id=mp++,this.activityRegularizer=null,this.inputSpec=null,this.supportsMasking=!1,this._trainableWeights=[],this._nonTrainableWeights=[],this._losses=[],this._updates=[],this._built=!1,this.inboundNodes=[],this.outboundNodes=[];let t=e.name;if(!t){const e=this.getClassName();t=Cc(e)+"_"+np(e)}if(this.name=t,this.trainable_=null==e.trainable||e.trainable,null!=e.inputShape||null!=e.batchInputShape){let t;if(null!=e.batchInputShape)t=e.batchInputShape;else if(null!=e.inputShape){let n=null;null!=e.batchSize&&(n=e.batchSize),t=[n].concat(e.inputShape)}this.batchInputShape=t;let n=e.dtype;null==n&&(n=e.inputDType),null==n&&(n="float32"),this.dtype=n}null!=e.weights?this.initialWeights=e.weights:this.initialWeights=null,this._refCount=null,this.fastWeightInitDuringBuild=!1}static nodeKey(e,t){return e.name+"_ib-"+t.toString()}getNodeAtIndex(e,t){if(0===this.inboundNodes.length)throw new gc(`The layer has never been called and thus has no defined ${t}.`);if(this.inboundNodes.length<=e)throw new yc(`Asked to get ${t} at node ${e}, but the layer has only ${this.inboundNodes.length} inbound nodes.`);return this.inboundNodes[e]}getInputAt(e){return Nc(this.getNodeAtIndex(e,"input").inputTensors)}getOutputAt(e){return Nc(this.getNodeAtIndex(e,"output").outputTensors)}get input(){if(this.inboundNodes.length>1)throw new mc("Layer "+this.name+' has multiple inbound nodes, hence the notion of "layer input" is ill-defined. Use `getInputAt(nodeIndex)` instead.');if(0===this.inboundNodes.length)throw new mc("Layer "+this.name+" is not connected, no input to return.");return Nc(this.getNodeAtIndex(0,"input").inputTensors)}get output(){if(0===this.inboundNodes.length)throw new mc("Layer "+this.name+" has no inbound nodes.");if(this.inboundNodes.length>1)throw new mc("Layer "+this.name+' has multiple inbound nodes, hence the notion of "layer output" is ill-defined. Use `getOutputAt(nodeIndex)` instead.');return Nc(this.getNodeAtIndex(0,"output").outputTensors)}get losses(){return this._losses}calculateLosses(){return this.losses.map(e=>e())}get updates(){return this._updates}get built(){return this._built}set built(e){this._built=e}get trainable(){return this.trainable_}set trainable(e){this._trainableWeights.forEach(t=>t.trainable=e),this.trainable_=e}get trainableWeights(){return this.trainable_?this._trainableWeights.filter(e=>e.trainable):[]}set trainableWeights(e){this._trainableWeights=e}get nonTrainableWeights(){return this.trainable?this._trainableWeights.filter(e=>!e.trainable).concat(this._nonTrainableWeights):this._trainableWeights.concat(this._nonTrainableWeights)}set nonTrainableWeights(e){this._nonTrainableWeights=e}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}get stateful(){return this._stateful}resetStates(){if(!this.stateful)throw new Error("Cannot call the resetStates() method of a non-stateful Layer object.")}assertInputCompatibility(e){if(e=Ic(e),null==this.inputSpec||0===this.inputSpec.length)return;const t=Ic(this.inputSpec);if(e.length!==t.length)throw new yc(`Layer ${this.name} expects ${t.length} inputs, but it received ${e.length} input tensors. Input received: `+e);for(let n=0;n<e.length;n++){const s=e[n],r=t[n];if(null==r)continue;const a=s.rank;if(null!=r.ndim&&a!==r.ndim)throw new yc(`Input ${n} is incompatible with layer ${this.name}: expected ndim=${r.ndim}, found ndim=${a}`);if(null!=r.maxNDim&&a>r.maxNDim)throw new yc(`Input ${n} is incompatible with layer ${this.name}: expected max_ndim=${r.maxNDim}, found ndim=${a}`);if(null!=r.minNDim&&a<r.minNDim)throw new yc(`Input ${n} is incompatible with layer ${this.name}: expected min_ndim=${r.minNDim}, found ndim=${a}.`);if(null!=r.dtype&&s.dtype!==r.dtype)throw new yc(`Input ${n} is incompatible with layer ${this.name} : expected dtype=${r.dtype}, found dtype=${s.dtype}.`);if(r.axes){const e=s.shape;for(const t in r.axes){const s=Number(t),a=r.axes[t],i=s>=0?e[s]:e[e.length+s];if(null!=a&&-1===[a,null].indexOf(i))throw new yc(`Input ${n} is incompatible with layer ${this.name}: expected axis ${s} of input shape to have value ${a} but got shape ${e}.`)}}if(null!=r.shape)for(let e=0;e<r.shape.length;++e){const t=r.shape[e],a=s.shape[e];if(null!=t&&null!=a&&t!==a)throw new yc(`Input ${n} is incompatible with layer ${this.name}: expected shape=${r.shape}, found shape=${s.shape}.`)}}}call(e,t){return e}invokeCallHook(e,t){null!=this._callHook&&this._callHook(e,t)}setCallHook(e){this._callHook=e}clearCallHook(){this._callHook=null}apply(e,t){t=t||{},this.assertNotDisposed();const n=Ic(e);let s=!0;for(const e of n)if(!(e instanceof pp)){s=!1;break}let r=!0;for(const e of n)if(e instanceof pp){r=!1;break}if(s===r)throw new yc("Arguments to apply() must be all SymbolicTensors or all Tensors");return rh(this.name,()=>{if(!this.built){this.assertInputCompatibility(e);const t=[];for(const n of Ic(e))t.push(n.shape);this.build(Nc(t)),this.built=!0,this.initialWeights&&this.setWeights(this.initialWeights),null===this._refCount&&r&&(this._refCount=1)}if(this.assertInputCompatibility(e),r){let s=this.call(e,t);const r=Ic(s),a=[];for(let e of r)-1!==n.indexOf(e)&&(e=e.clone()),a.push(e);if(s=Nc(a),null!=this.activityRegularizer)throw new bc("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return s}{const n=function(e){e=Ic(e);const t=[];for(const n of e)t.push(n.shape);return Nc(t)}(e),s=this.computeOutputShape(n);let r;const a="float32";if(this.warnOnIncompatibleInputShape(Array.isArray(e)?n[0]:n),r=null!=s&&s.length>0&&Array.isArray(s[0])?s.map((n,s)=>new pp(a,n,this,Ic(e),t,this.name,s)):new pp(a,s,this,Ic(e),t,this.name),this.addInboundNode(e,r,null,null,n,s,t),this._refCount++,null!=this.activityRegularizer)throw new bc("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return r}})}warnOnIncompatibleInputShape(e){if(null!=this.batchInputShape)if(e.length!==this.batchInputShape.length)console.warn("The rank of the input tensor provided (shape: "+JSON.stringify(e)+") does not match that of the "+`batchInputShape (${JSON.stringify(this.batchInputShape)}) of the layer `+this.name);else{let t=!1;this.batchInputShape.forEach((n,s)=>{null!=n&&null!=e[s]&&e[s]!==n&&(t=!0)}),t&&console.warn(`The shape of the input tensor (${JSON.stringify(e)}) does not match the expectation of layer ${this.name}: `+JSON.stringify(this.batchInputShape))}}get outputShape(){if(null==this.inboundNodes||0===this.inboundNodes.length)throw new mc(`The layer ${this.name} has never been called and thus has no defined output shape.`);const e=[];for(const t of this.inboundNodes){const n=JSON.stringify(t.outputShapes);-1===e.indexOf(n)&&e.push(n)}if(1===e.length){const e=this.inboundNodes[0].outputShapes;return Array.isArray(e)&&Array.isArray(e[0])&&1===e.length?e[0]:e}throw new mc(`The layer ${this.name} has multiple inbound nodes with different output shapes. Hence the notion of "output shape" is ill-defined for the layer.`)}countParams(){if(!this.built)throw new gc(`You tried to call countParams() on ${this.name}, but the layer is not built yet. Build it first by calling build(batchInputShape).`);return op(this.weights)}build(e){this.built=!0}getWeights(e=!1){return up(e?this.trainableWeights:this.weights)}setWeights(e){rs(()=>{const t=this.weights;if(t.length!==e.length)throw new yc(`You called setWeights(weights) on layer "${this.name}" with a weight list of length ${e.length}, but the layer was expecting ${t.length} weights. Provided weights: ${e}...`);if(0===t.length)return;const n=[],s=up(t);for(let r=0;r<s.length;++r){const a=s[r],i=t[r],o=e[r];if(!d(a.shape,o.shape))throw new yc(`Layer weight shape ${a.shape} not compatible with provided weight shape `+o.shape);n.push([i,o])}cp(n)})}addWeight(e,t,n,s,r,a,i){if(-1!==this._addedWeightNames.indexOf(e))throw new yc(`Duplicate weight name ${e} for layer ${this.name}`);this._addedWeightNames.push(e),null==n&&(n="float32"),this.fastWeightInitDuringBuild&&(s=Jh("zeros"));const o=s.apply(t,n),l=new lp(o,n,e,a,i);return o.dispose(),null!=r&&this.addLoss(()=>r.apply(l.read())),null==a&&(a=!0),a?this._trainableWeights.push(l):this._nonTrainableWeights.push(l),l}setFastWeightInitDuringBuild(e){this.fastWeightInitDuringBuild=e}addLoss(e){null==e||Array.isArray(e)&&0===e.length||(e=Ic(e),void 0!==this._losses&&null!==this._losses&&this.losses.push(...e))}computeOutputShape(e){return e}computeMask(e,t){if(!this.supportsMasking){if(null!=t){if(!Array.isArray(t))throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);t.forEach(e=>{if(null!=e)throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`)})}return null}return t}addInboundNode(e,t,n,s,r,a,i=null){const o=Ic(e);t=Ic(t),n=Ic(n),s=Ic(s),r=rp(r),a=rp(a);const l=[],u=[],c=[];for(const e of o)l.push(e.sourceLayer),u.push(e.nodeIndex),c.push(e.tensorIndex);new fp({outboundLayer:this,inboundLayers:l,nodeIndices:u,tensorIndices:c,inputTensors:o,outputTensors:t,inputMasks:n,outputMasks:s,inputShapes:r,outputShapes:a},i);for(let e=0;e<t.length;e++)t[e].sourceLayer=this,t[e].nodeIndex=this.inboundNodes.length-1,t[e].tensorIndex=e}getConfig(){const e={name:this.name,trainable:this.trainable};return null!=this.batchInputShape&&(e.batchInputShape=this.batchInputShape),null!=this.dtype&&(e.dtype=this.dtype),e}disposeWeights(){return this.weights.forEach(e=>e.dispose()),this.weights.length}assertNotDisposed(){if(0===this._refCount)throw new Error(`Layer '${this.name}' is already disposed.`)}dispose(){if(!this.built)throw new Error(`Cannot dispose Layer ${this.name} because it has not been built yet.`);if(null===this._refCount)throw new Error(`Cannot dispose Layer ${this.name} because it has not been used yet.`);this.assertNotDisposed();let e=0;return 0==--this._refCount&&(e=this.disposeWeights()),{refCountAfterDispose:this._refCount,numDisposedVariables:e}}}class yp extends gp{constructor(e){if(super({dtype:e.dtype,name:null!=e.name?e.name:np("input").toString()}),null==e.batchSize&&(e.batchSize=null),null==e.sparse&&(e.sparse=!1),this.trainable=!1,this.built=!0,this.sparse=e.sparse,null!=e.inputShape&&null!=e.batchInputShape)throw new yc("Only provide the inputShape OR batchInputShape argument to inputLayer, not both at the same time.");let t=e.batchInputShape;if(null==t){if(null==e.inputShape)throw new yc("An InputLayer should be passed either a `batchInputShape` or an `inputShape`.");t=[e.batchSize].concat(e.inputShape)}else if(null!=e.batchSize)throw new yc("Cannot specify batchSize if batchInputShape is specified when creating an InputLayer.");const n=e.dtype||"float32";this.batchInputShape=t,this.dtype=n,this.inputSpec=[{shape:t}];const s=new pp(this.dtype,this.batchInputShape,this,[],{},this.name);s.nodeIndex=0,s.tensorIndex=0,new fp({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:[s],outputTensors:[s],inputMasks:[null],outputMasks:[null],inputShapes:[t],outputShapes:[t]})}apply(e,t){throw new yc("Cannot pass any input to an InputLayer's apply() method. InputLayer name: "+this.name)}dispose(){return{refCountAfterDispose:this._refCount,numDisposedVariables:0}}getConfig(){return{batchInputShape:this.batchInputShape,dtype:this.dtype,sparse:this.sparse,name:this.name}}}function bp(e){if(null==e.batchShape&&null==e.shape)throw new Error("Please provide to Input either a `shape` or a `batchShape` argument. Note that `shape` does not include the batch dimension.");if(null!=e.batchShape&&null!=e.shape)throw new yc("Please provide either a `shape` or `batchShape` argument to Input, but not both.");let t=e.batchShape;null!=e.shape&&null==t&&(t=[null].concat(e.shape));let n=e.dtype;return null==n&&(n="float32"),new yp({batchInputShape:t,name:e.name,dtype:n,sparse:e.sparse}).inboundNodes[0].outputTensors[0]}async function xp(e){if(null==e)return;const t=[],n=[],s=[];for(const r in e){const a=e[r];if("number"!=typeof a){const e=a;t.push(e.data()),n.push(r),s.push(e)}}if(t.length>0){const r=await Promise.all(t);for(let t=0;t<r.length;++t)e[n[t]]=r[t][0];as(s)}}function wp(e){if(null!=e)for(const t in e){const n=e[t];"number"!=typeof n&&n.dispose()}}var kp;yp.className="InputLayer",Kn(yp),function(e){e[e.SILENT=0]="SILENT",e[e.VERBOSE=1]="VERBOSE"}(kp||(kp={}));class vp{constructor(){this.validationData=null}setParams(e){this.params=e}async onEpochBegin(e,t){}async onEpochEnd(e,t){}async onBatchBegin(e,t){}async onBatchEnd(e,t){}async onTrainBegin(e){}async onTrainEnd(e){}setModel(e){}}class Np{constructor(e,t=10){null==e&&(e=[]),this.callbacks=e,this.queueLength=t}append(e){this.callbacks.push(e)}setParams(e){for(const t of this.callbacks)t.setParams(e)}setModel(e){for(const t of this.callbacks)t.setModel(e)}async onEpochBegin(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onEpochBegin(e,t)}async onEpochEnd(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onEpochEnd(e,t)}async onBatchBegin(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onBatchBegin(e,t)}async onBatchEnd(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onBatchEnd(e,t)}async onTrainBegin(e){null==e&&(e={});for(const t of this.callbacks)await t.onTrainBegin(e)}async onTrainEnd(e){null==e&&(e={});for(const t of this.callbacks)await t.onTrainEnd(e)}}class Ip extends vp{constructor(){super()}async onEpochBegin(e){this.seen=0,this.totals={}}async onBatchEnd(e,t){null==t&&(t={});const n=null==t.size?0:t.size;this.seen+=n;for(const e in t){const s=t[e];if("number"==typeof s)this.totals.hasOwnProperty(e)||(this.totals[e]=0),this.totals[e]=this.totals[e]+s*n;else{let t;e in this.totals?t=this.totals[e]:this.totals[e]=0;const r=rs(()=>cs(this.totals[e],ds(s,n)));this.totals[e]=r,null!=t&&t.dispose()}}}async onEpochEnd(e,t){if(null!=t)for(const e of this.params.metrics)null!=this.totals[e]&&("number"==typeof this.totals[e]?t[e]=this.totals[e]/this.seen:rs(()=>{const n=ds(ps(1,this.seen),this.totals[e]);t[e]=n,this.totals[e].dispose(),is(t[e])}))}}class Cp extends vp{async onTrainBegin(e){this.epoch=[],this.history={}}async onEpochEnd(e,t){null==t&&(t={}),this.epoch.push(e);for(const e in t)null==this.history[e]&&(this.history[e]=[]),this.history[e].push(t[e])}async syncData(){const e=[],t=[],n=[];for(const s in this.history){const r=this.history[s];for(let a=0;a<r.length;++a)if("number"!=typeof r[a]){const i=r[a];e.push(i.data()),t.push(s),n.push(a)}}const s=await Promise.all(e);for(let e=0;e<s.length;++e){this.history[t[e]][n[e]].dispose(),this.history[t[e]][n[e]]=s[e][0]}}}class Sp extends vp{constructor(e,t){if(super(),this.currentEpoch=0,this.yieldEvery=t||"auto","auto"===this.yieldEvery&&(this.yieldEvery=125),"never"===this.yieldEvery&&null!=e.onYield)throw new Error("yieldEvery is `never` but you provided an `onYield` callback. Either change `yieldEvery` or remove the callback");R(this.yieldEvery)&&(this.maybeWait=function(e,t){let n,s=ge();return(...r)=>{const a=ge();return a-s<t||(s=a,n=e(...r)),n}}(this.maybeWait.bind(this),this.yieldEvery)),this.trainBegin=e.onTrainBegin,this.trainEnd=e.onTrainEnd,this.epochBegin=e.onEpochBegin,this.epochEnd=e.onEpochEnd,this.batchBegin=e.onBatchBegin,this.batchEnd=e.onBatchEnd,this.yield=e.onYield}async maybeWait(e,t,n){const s=[];null!=this.yield&&(await xp(n),s.push(this.yield(e,t,n))),s.push(Tl()),await Promise.all(s)}async onEpochBegin(e,t){this.currentEpoch=e,null!=this.epochBegin&&(await xp(t),await this.epochBegin(e,t))}async onEpochEnd(e,t){const n=[];null!=this.epochEnd&&(await xp(t),n.push(this.epochEnd(e,t))),"epoch"===this.yieldEvery&&n.push(Tl()),await Promise.all(n)}async onBatchBegin(e,t){null!=this.batchBegin&&(await xp(t),await this.batchBegin(e,t))}async onBatchEnd(e,t){const n=[];null!=this.batchEnd&&(await xp(t),n.push(this.batchEnd(e,t))),"batch"===this.yieldEvery?n.push(Tl()):R(this.yieldEvery)&&n.push(this.maybeWait(this.currentEpoch,e,t)),await Promise.all(n)}async onTrainBegin(e){null!=this.trainBegin&&(await xp(e),await this.trainBegin(e))}async onTrainEnd(e){null!=this.trainEnd&&(await xp(e),await this.trainEnd(e))}}function Tp(e,t){if(null==e&&(e={}),e instanceof vp)return[e];if(Array.isArray(e)&&e[0]instanceof vp)return e;return Ic(e).map(e=>new Sp(e,t))}class Ep{constructor(){}static registerCallbackConstructor(e,t){l(e>=0&&Number.isInteger(e),()=>"Verbosity level is expected to be an integer >= 0, but got "+e),Ep.checkForDuplicate(t),null==Ep.constructors[e]&&(Ep.constructors[e]=[]),Ep.constructors[e].push(t)}static checkForDuplicate(e){for(const t in Ep.constructors){Ep.constructors[+t].forEach(t=>{if(t===e)throw new yc("Duplicate callback constructor.")})}}static clear(){Ep.constructors={}}static createCallbacks(e){const t=[];for(const n in Ep.constructors){const s=+n;e>=s&&t.push(...Ep.constructors[s])}return t.map(e=>new e)}}function $p(e,t,n,s,r,a,i,o,l){const u=new Cp,c=[new Ip,...Ep.createCallbacks(t)];null!=e&&c.push(...e),c.push(u);const h=new Np(c);return h.setParams({epochs:n,initialEpoch:s,samples:r,steps:a,batchSize:i,verbose:t,doValidation:o,metrics:l}),{callbackList:h,history:u}}function Ap(e,t={},n=!1){return $c(e,qn.getMap().classNameMap,t,"layer",n)}function Rp(e,t){return rs(()=>{"float32"!==e.dtype&&(e=e.asType("float32"));const n=oa(Ch(e),t,!0),s=Lr(n.shape,fc()),r=Wi(Ca(n,s));return ps(e,r)})}function Fp(e,t){return rs(()=>Sa(Ch(ia(t,e)),-1))}function Dp(e,t){return rs(()=>Sa(fs(ia(t,e)),-1))}function _p(e,t){return rs(()=>{const n=ia(e,t),s=nr(fs(e),fc(),Number.MAX_VALUE),r=fs(ps(n,s));return ds(100,Sa(r,-1))})}function Op(e,t){return rs(()=>{const n=nr(t,fc(),Number.MAX_VALUE),s=Jr(cs(1,n)),r=nr(e,fc(),Number.MAX_VALUE),a=Jr(cs(1,r));return Sa(Ch(ia(s,a)),-1)})}function Mp(e,t,n=!1){return rs(()=>{if(n)t=Oi(t);else{const e=oa(t,t.shape.length-1,!0);t=ps(t,e)}return t=nr(t,fc(),1-fc()),na(oa(ds(e.toFloat(),Jr(t)),t.shape.length-1))})}function Lp(e,t,n=!1){return rs(()=>{const s=zr(function(e){const t=[uh(e.shape)];return e.reshape(t)}(e)).toInt(),r=(t=nr(t,fc(),1-fc())).shape;return Mp(mn(s,r[r.length-1]).reshape(r),t,n)})}function zp(e,t){return rs(()=>{let n;return n=nr(t,fc(),1-fc()),n=Jr(ps(n,ia(1,n))),Sa(function(e,t){if(!d(e.shape,t.shape))throw new yc(`logits and labels must have the same shape, but got shapes ${JSON.stringify(e.shape)} and ${JSON.stringify(t.shape)}`);return rs(()=>{const n=t.relu(),s=t.abs().neg();return n.sub(t.mul(e)).add(s.exp().log1p())})}(e,n),-1)})}function Bp(e,t){return rs(()=>{const n=nr(e,fc(),1),s=nr(t,fc(),1);return oa(ds(e,Jr(ps(n,s))),-1)})}function Pp(e,t){return rs(()=>{const n=Rp(e,-1),s=Rp(t,-1),r=ds(n,s);return na(oa(r,-1))})}Ep.constructors={};const Wp={meanSquaredError:Fp,meanAbsoluteError:Dp,meanAbsolutePercentageError:_p,meanSquaredLogarithmicError:Op,squaredHinge:function(e,t){return rs(()=>{const n=Ca(0,ia(1,ds(e,t)));return Sa(Ch(n),-1)})},hinge:function(e,t){return rs(()=>{const n=Ca(0,ia(1,ds(e,t)));return Sa(n,-1)})},categoricalHinge:function(e,t){return rs(()=>{const n=oa(ds(e,t),-1),s=aa(ds(ia(1,e),t),-1);return Ca(0,cs(1,ia(s,n)))})},logcosh:function(e,t){return rs(()=>{const n=Math.log(2),s=ia(t,e),r=ia(cs(s,sa(ds(-2,s))),n);return Sa(r,-1)})},categoricalCrossentropy:Mp,sparseCategoricalCrossentropy:Lp,binaryCrossentropy:zp,kullbackLeiblerDivergence:Bp,poisson:function(e,t){return rs(()=>{const n=Jr(cs(fc(),t));return Sa(ia(t,ds(e,n)),-1)})},cosineProximity:Pp};function Vp(e){if("string"==typeof e){if(e in Wp)return Wp[e];let t="Unknown loss "+e;throw e.toLowerCase().includes("softmaxcrossentropy")&&(t=`Unknown loss ${e}. Use "categoricalCrossentropy" as the string name for tf.losses.softmaxCrossEntropy`),new yc(t)}return e}function Up(e,t){return rs(()=>{const n=ds(.5,za(t)),s=fh(Pr(t,n),e.dtype);return Sa(Cr(e,s),-1)})}function Gp(e,t){return rs(()=>fh(Cr(ws(e,-1),ws(t,-1)),"float32"))}function Hp(e,t){return rs(()=>ba(e.equal(1),t.equal(1)).sum().cast("float32"))}function jp(e,t){return rs(()=>{const n=Hp(e,t),s=function(e,t){return rs(()=>ba(e.equal(0),t.equal(1)).sum().cast("float32"))}(e,t),r=n.add(s);return Sr(Pr(r,0),n.div(r),0).cast("float32")})}function qp(e,t){return rs(()=>{const n=Hp(e,t),s=function(e,t){return rs(()=>ba(e.equal(1),t.equal(0)).sum().cast("float32"))}(e,t),r=n.add(s);return Sr(Pr(r,0),n.div(r),0).cast("float32")})}function Kp(e,t){return zp(e,t)}function Xp(e,t){return e.rank===t.rank&&(e=e.squeeze([e.rank-1])),(t=t.argMax(-1)).dtype!==e.dtype&&(t=t.asType(e.dtype)),Cr(e,t).asType("float32")}const Yp=Mp,Jp=Lp,Zp={binaryAccuracy:Up,categoricalAccuracy:Gp,precision:jp,categoricalCrossentropy:Yp,sparseCategoricalCrossentropy:Jp,mse:Fp,MSE:Fp,mae:Dp,MAE:Dp,mape:_p,MAPE:_p,cosine:Pp};function Qp(e){if("string"==typeof e&&e in Zp)return Zp[e];if("string"!=typeof e&&null!=e)return e;throw new yc("Unknown metric "+e)}function ed(e){if(kc(null!==e,"Unknown LossOrMetricFn "+e),"string"==typeof e)return e;{let t;for(const n of Object.keys(Wp))if(Wp[n]===e){t=n;break}if(void 0!==t)return t;for(const n of Object.keys(Zp))if(Zp[n]===e){t=n;break}return void 0!==t?t:e.name}}function td(e,t,n=!1){if(null==e||"object"!=typeof e||Object.getPrototypeOf(e)!==Object.prototype||!function e(t){if(null===t)return!0;if("object"==typeof t){if(Object.getPrototypeOf(t)===Object.prototype){const n=Object.keys(t);for(const s of n){if("string"!=typeof s)return!1;if(!e(t[s]))return!1}return!0}if(Array.isArray(t)){for(const n of t)if(!e(n))return!1;return!0}return!1}{const e=typeof t;return"string"===e||"number"===e||"boolean"===e}}(e))throw new Error("User-defined metadata is expected to be a JSON object, but is not.");if(n){const n=JSON.stringify(e);n.length>1048576&&console.warn(`User-defined metadata of model "${t}" is too large in size (length=${n.length} when serialized). It is not recommended to store such large objects in user-defined metadata. Please make sure its serialized length is <= 1048576.`)}}function nd(e,t,n,s=console.log){const r=function(e){let t=!0;const n=[],s=[];for(const t in e.nodesByDepth)n.push(e.nodesByDepth[t]);for(const e of n){if(e.length>1||1===e.length&&e[0].inboundLayers.length>1){t=!1;break}s.push(...e)}if(t)for(const n of e.layers){let e=!1;for(const r of n.inboundNodes)if(-1!==s.indexOf(r)){if(e){t=!1;break}e=!0}if(!t)break}return t}(e),a=["Layer (type)","Output shape","Param #"];let i;if(r?(t=t||65,n=n||[.45,.85,1]):(t=t||98,n=n||[.33,.55,.67,1]),n[n.length-1]<=1&&(n=n.map(e=>Math.floor(t*e))),!r){a.push("Receives inputs"),i=[];for(const t in e.nodesByDepth)i.push(...e.nodesByDepth[t])}s("_".repeat(t)),sd(a,n,s),s("=".repeat(t));const o=e.layers;for(let e=0;e<o.length;++e)r?rd(o[e],n,s):ad(o[e],n,i,s),s((e===o.length-1?"=":"_").repeat(t));e.checkTrainableWeightsConsistency();const l=function(e){let t;t=null!=e.collectedTrainableWeights?op(e.collectedTrainableWeights):op(e.trainableWeights);return t}(e),u=op(e.nonTrainableWeights);s("Total params: "+(l+u)),s("Trainable params: "+l),s("Non-trainable params: "+u),s("_".repeat(t))}function sd(e,t,n=console.log){let s="";for(let n=0;n<e.length;++n)n>0&&(s=s.slice(0,s.length-1)+" "),s+=e[n],s=s.slice(0,t[n]),s+=" ".repeat(t[n]-s.length);n(s)}function rd(e,t,n){let s;try{s=JSON.stringify(e.outputShape)}catch(e){s="multiple"}sd([`${e.name} (${e.getClassName()})`,s,e.countParams().toString()],t,n)}function ad(e,t,n,s){let r;try{r=JSON.stringify(e.outputShape)}catch(e){r="multiple"}const a=[];for(const t of e.inboundNodes)if(!(null!=n&&n.length>0&&-1===n.indexOf(t)))for(let e=0;e<t.inboundLayers.length;++e){const n=t.inboundLayers[e].name,s=t.nodeIndices[e],r=t.tensorIndices[e];a.push(`${n}[${s}][${r}]`)}const i=e.name,o=e.getClassName(),l=0===a.length?"":a[0];sd([`${i} (${o})`,r,e.countParams().toString(),l],t,s);for(let e=1;e<a.length;++e)sd(["","","",a[e]],t,s)}function id(e,t,n){return("inboundNodes"===e||"outputLayers"===e||"inputLayers"===e)&&0===t&&"string"==typeof n}function od(e,t){if(null===e)return null;if("string"==typeof e)return Sc(e);if("number"==typeof e||"boolean"==typeof e)return e;if(e instanceof Array){const n=[],s=e.length;for(let r=0;r<s;++r){const s=e[r];id(t,r,s)?n.push(s):n.push(od(s,t))}return n}{const t={};for(const n of Object.keys(e)){const s=e[n];if("name"===n&&"string"==typeof s)t[n]=s;else{const e=Sc(n);t[e]=od(s,e)}}return t}}class ld{constructor(e){if(this.id2Value={},this.id2Mask={},this.name2Id={},e instanceof ld)for(const t in e.id2Value)this.id2Value[t]=e.id2Value[t],t in e.id2Mask&&(this.id2Mask[t]=e.id2Mask[t]);else{if(null==e)return;for(const t of e)this.add(t.key,t.value)}}add(e,t,n){if(null!=this.id2Value[e.id])throw new yc(`Duplicate key: name=${e.name}, id=${e.id}`);return this.id2Value[e.id]=function(e,t){if(null==e.dtype||e.dtype===t.dtype)return t;try{return Xt(t,e.dtype)}catch(n){throw new yc(`The dtype of the feed (${t.dtype}) can not be cast to the dtype of the key '${e.name}' (${e.dtype}).`)}}(e,t),this.name2Id[e.name]=e.id,null!=n&&(this.id2Mask[e.id]=n),this}addFeed(e){this.add(e.key,e.value)}hasKey(e){return null!=this.id2Value[e.id]}names(){return Object.keys(this.name2Id)}getValue(e){if(e instanceof pp){if(null==this.id2Value[e.id])throw new yc("Nonexistent key: "+e.name);return this.id2Value[e.id]}{const t=this.name2Id[e];if(null==t)throw new yc("Feed dict has no SymbolicTensor name: "+e);return this.id2Value[t]}}getMask(e){if(e instanceof pp){if(null==this.id2Value[e.id])throw new yc("Nonexistent key: "+e.name);return this.id2Mask[e.id]}{const t=this.name2Id[e];if(null==t)throw new yc("Feed dict has no SymbolicTensor name: "+e);return this.id2Mask[t]}}disposeMasks(){null!=this.id2Mask&&as(this.id2Mask)}}const ud={},cd={};function hd(e,t,n,s){const r=null!=n&&n.training,a=Array.isArray(e),i=a?e:[e],o=i.map(e=>e.name),u=[],c=t.names();for(const e of o)-1!==c.indexOf(e)?u.push(t.getValue(e)):u.push(null);null!=s&&(s.maxNumTensors=-1/0,s.minNumTensors=1/0);const h=o.join(",")+"|"+t.names().join(",");let p,d;if(null==ud[h]){const e=function(e,t){l(null!=e&&e.length>0,()=>"Expected at least one fetch, got none");let n=[],s={};if(1===e.length){const r=dd(e[0],t);n=r.sorted,s=r.recipientMap}else{const r=new Set;for(const a of e){const{sorted:e,recipientMap:i}=dd(a,t);for(const t of e)r.has(t.name)||(n.push(t),r.add(t.name));for(const e in i)null==s[e]&&(s[e]=new Set),i[e].forEach(t=>s[e].add(t))}}return{sorted:n,recipientCounts:pd(s)}}(i,t);p=e.sorted,d=e.recipientCounts,ud[h]=p,cd[h]=d}p=ud[h],d={},r||Object.assign(d,cd[h]);const f=new ld(t);for(let e=0;e<p.length;++e){if(null!=s){const e=ss().numTensors;e>s.maxNumTensors&&(s.maxNumTensors=e),e<s.minNumTensors&&(s.minNumTensors=e)}const a=p[e],i=a.sourceLayer;if(i instanceof yp)continue;const l=[],c=[],h=[];let m=!1;for(const e of a.inputs){const n=f.getValue(e),s=f.getMask(e);l.push(n),c.push(s),null!=s&&(m=!0),r||(d[e.name]--,0!==d[e.name]||t.hasKey(e)||-1!==o.indexOf(e.name)||n.isDisposed||!0===e.sourceLayer.stateful||h.push(n))}m&&((n=n||{}).mask=c[0]);const g=Ic(i.apply(l,n));let y=null;i.supportsMasking&&(y=i.computeMask(l,c));const b=fd(a),x=Array.isArray(b)?b:[b];for(let e=0;e<x.length;++e){f.hasKey(x[e])||f.add(x[e],g[e],Array.isArray(y)?y[0]:y);const t=o.indexOf(x[e].name);-1!==t&&(u[t]=g[e])}r||as(h)}return f.disposeMasks(),a?u:u[0]}function pd(e){const t={};for(const n in e)t[n]=e[n].size;return t}function dd(e,t){const n=new Set,s=[],r={};for(const e of t.names())n.add(e);const a=[],i=[];for(a.push(e);a.length>0;){const e=a[a.length-1];if(n.has(e.name)){a.pop();continue}const t=i[i.length-1]===a.length-1;if(0===e.inputs.length||t)a.pop(),s.push(e),n.add(e.name),t&&i.pop();else{i.push(a.length-1);for(const t of e.inputs)null==r[t.name]&&(r[t.name]=new Set),r[t.name].add(e.name),n.has(t.name)||a.push(t)}}return{sorted:s,recipientMap:r}}function fd(e){let t;if(1===e.sourceLayer.inboundNodes.length)t=e.sourceLayer.output;else{let n=null;for(let t=0;t<e.sourceLayer.inboundNodes.length;++t)for(const s of e.sourceLayer.inboundNodes[t].outputTensors)if(s.id===e.id){n=t;break}t=e.sourceLayer.getOutputAt(n)}return t}class md extends gp{constructor(e){if(super({}),this.containerNodes=new Set,this.name=e.name,null==this.name){const e=this.getClassName().toLowerCase();this.name=np(e)}if(this.supportsMasking=!1,this.trainable_=!0,Array.isArray(e.inputs)?this.inputs=e.inputs.slice():this.inputs=[e.inputs],Array.isArray(e.outputs)?this.outputs=e.outputs.slice():this.outputs=[e.outputs],Rc(this.inputs).length!==this.inputs.length)throw new yc("The list of inputs passed to the model is redundant. All inputs should only appear once. Found: "+this.inputs.map(e=>e.name));Rc(this.outputs).length!==this.outputs.length&&console.warn("The list of outputs passed to the model is redundant. All outputs should only appear once. Found: "+this.outputs.map(e=>e.name)),this.inputLayers=[],this.inputLayersNodeIndices=[],this.inputLayersTensorIndices=[],this.outputLayers=[],this.outputLayersNodeIndices=[],this.outputLayersTensorIndices=[],this.layers=[],this.internalContainerRefs=[];for(const e of this.outputs){const t=e.sourceLayer,n=e.nodeIndex,s=e.tensorIndex;this.outputLayers.push(t),this.outputLayersNodeIndices.push(n),this.outputLayersTensorIndices.push(s)}for(const e of this.inputs){const t=e.sourceLayer,n=e.nodeIndex,s=e.tensorIndex;kc(0===n,"input layer has >1 nodes"),kc(0===s,"input layer has >1 tensors"),this.inputLayers.push(t),this.inputLayersNodeIndices.push(n),this.inputLayersTensorIndices.push(s)}this.inputNames=[],this.outputNames=[],this.feedInputShapes=[],this.feedInputNames=[],this.feedOutputNames=[];for(let t=0;t<this.inputLayers.length;t++){const n=this.inputLayers[t];if(!(n instanceof yp))throw new TypeError(`Input layers to a LayersModel must be InputLayer objects. Received inputs: ${e.inputs}. Input ${t} (0-based) originates from layer type ${n.getClassName()}.`);this.inputNames.push(n.name),this.feedInputShapes.push(n.batchInputShape),this.feedInputNames.push(n.name)}for(const e of this.outputLayers)this.outputNames.push(e.name);this.internalInputShapes=this.inputs.map(e=>e.shape),this.internalOutputShapes=this.outputs.map(e=>e.shape);const t={},n={},s={},r={},a={},i=[],o=(e,t,n,s,r,l)=>{null!=s&&null!=r&&null!=l||(s=e.sourceLayer,r=e.nodeIndex,l=e.tensorIndex);const u=s.inboundNodes[r];if(-1!==n.indexOf(u))throw new gc(`The tensor ${e.name} at layer "${s.name}" is part of a cycle.`);if(-1!==t.indexOf(u))return;this.containerNodes.add(md.nodeKey(s,r)),s.id in a||(a[s.id]=Object.keys(a).length),-1===n.indexOf(u)&&n.push(u);const c=u.inboundLayers.length;for(let e=0;e<c;e++){const s=u.inputTensors[e],r=u.inboundLayers[e],a=u.nodeIndices[e],i=u.tensorIndices[e];o(s,t,n,r,a,i)}for(t.push(u);n.indexOf(u)>=0;)n.splice(n.indexOf(u),1);i.push(u)},l=[],u=[];for(const e of this.outputs)o(e,l,u);const c=i.slice().reverse();for(const e of c){n[e.id]=e,e.id in t||(t[e.id]=0);let a=t[e.id];const i=null==s[e.outboundLayer.id]?0:s[e.outboundLayer.id];a=Math.max(a,i),s[e.outboundLayer.id]=a,r[e.outboundLayer.id]=e.outboundLayer,t[e.id]=a;for(let s=0;s<e.inboundLayers.length;s++){const r=e.inboundLayers[s],i=e.nodeIndices[s],o=r.inboundNodes[i],l=null==t[o.id]?0:t[o.id];t[o.id]=Math.max(a+1,l),n[o.id]=o}}const h={};for(const e in t){const s=t[e];s in h||(h[s]=[]),h[s].push(n[e])}const p={};for(const e in s){const t=s[e];t in p||(p[t]=[]),p[t].push(r[e])}let d=Object.keys(p).map(e=>parseInt(e,10)).sort(Ac);this.layers=[];for(const e of d){const t=p[e];t.sort((e,t)=>{const n=a[e.id],s=a[t.id];return n<s?-1:n>s?1:0});for(const e of t)e instanceof md&&this.internalContainerRefs.push(e),this.layers.push(e)}this.layersByDepth=p,d=Object.keys(h).map(e=>parseInt(e,10)).sort(Ac);const f=this.inputs.slice(),m=[];for(const e of d)for(const t of h[e]){const e=t.outboundLayer;if(null!=e){for(const n of t.inputTensors)if(-1===f.indexOf(n))throw new gc("Graph disconnected: cannot obtain value for tensor "+n+` at layer "${e.name}". The following previous layers were accessed without issue: `+m);for(const e of t.outputTensors)f.push(e);m.push(e.name)}}this.nodesByDepth=h;const g=this.layers.map(e=>e.name);for(const e of g){const t=g.filter(t=>t===e).length;if(1!==t)throw new gc(`The name "${e}" is used ${t} times in the model. All layer names should be unique. Layer names: `+JSON.stringify(g))}this.outboundNodes=[],this.inboundNodes=[],new fp({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:this.inputs.map(e=>null),outputMasks:this.outputs.map(e=>null),inputShapes:this.inputs.map(e=>e.shape),outputShapes:this.outputs.map(e=>e.shape)}),this.built=!0,this._refCount=1}assertNotDisposed(){if(0===this._refCount)throw new Error(`Container '${this.name}' is already disposed.`)}dispose(){this.assertNotDisposed();const e={refCountAfterDispose:null,numDisposedVariables:0};if(0==--this._refCount){for(const t of this.layers)e.numDisposedVariables+=t.dispose().numDisposedVariables;for(const t of this.internalContainerRefs)e.numDisposedVariables+=t.dispose().numDisposedVariables}return e.refCountAfterDispose=this._refCount,e}get trainable(){return this.trainable_}set trainable(e){this.layers.forEach(t=>{t._trainableWeights.forEach(t=>t.trainable=e)}),this.trainable_=e}get trainableWeights(){if(this._trainableWeights.length>0)throw new yc("Container instance unexpectedly contains _trainableWeights.The trainable weights of a Container are a union of the trainable weights of its consituent Layers. Its own _trainableWeights must remain an empty Array.");if(!this.trainable)return[];let e=[];for(const t of this.layers)e=e.concat(t.trainableWeights);return e}get nonTrainableWeights(){const e=[];for(const t of this.layers)e.push(...t.nonTrainableWeights);if(!this.trainable){const t=[];for(const e of this.layers)t.push(...e.trainableWeights);return t.concat(e)}return e}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}loadWeights(e,t=!0){const n={};let s=0;for(const e of this.layers)for(const t of e.weights){if(null!=n[t.originalName])throw new yc("Duplicate weight name: "+t.originalName);n[t.originalName]=t,s++}const r=[];for(const s in e){let a=s;if(null==n[s]){const e=s.split("/");a=e.slice(0,-2).concat([e[e.length-1]]).join("/")}if(null!=n[a])r.push([n[a],e[s]]);else if(t)throw new yc("Provided weight data has no target variable: "+s);delete n[a]}if(t){const e=[];for(const t in n)e.push(t);if(e.length>0)throw new yc(`${e.length} of ${s} weights are not set: `+e)}cp(r)}updatedConfig(){const e=this.getConfig(),t={};return t.className=this.getClassName(),t.config=e,t.kerasVersion="tfjs-layers 3.0.0",t.backend="TensorFlow.js",t}toJSON(e,t=!0){const n=function e(t,n){if(null==t)return null;if("string"==typeof t)return Cc(t);if("number"==typeof t||"boolean"==typeof t)return t;if(t instanceof Array){const s=[],r=t.length;for(let a=0;a<r;++a){const r=t[a];id(n,a,r)?s.push(r):s.push(e(r,n))}return s}{const n={};for(const s of Object.keys(t)){const r=t[s],a=Cc(s);n[a]="name"!==s&&"className"!==s||"string"!=typeof r?e(r,s):r}return n}}(this.updatedConfig());return t?JSON.stringify(n):n}call(e,t){return rs(()=>{e=Ic(e);const n=new ld;for(let t=0;t<this.inputs.length;++t)n.add(this.inputs[t],e[t]);return hd(this.outputs,n,t)})}computeMask(e,t){return rs(()=>{let n;return e=Ic(e),n=null==t?wc(null,e.length):Ic(t),this.runInternalGraph(e,n)[1]})}computeOutputShape(e){const t=rp(e);if(t.length!==this.inputLayers.length)throw new yc(`Invalid inputShape argument ${e}: model has ${this.inputLayers.length} tensor inputs.`);const n={};for(let e=0;e<t.length;e++){const s=this.inputLayers[e],r=t[e];n[s.name+"_0_0"]=r}const s=Object.keys(this.nodesByDepth).map(e=>parseInt(e,10)).sort(Ac);if(s.length>1)for(const e of s){const t=this.nodesByDepth[e];for(const e of t){const t=e.outboundLayer;if(-1!==this.inputLayers.map(e=>e.id).indexOf(t.id))continue;const s=[];for(let t=0;t<e.inboundLayers.length;t++){const r=e.inboundLayers[t],a=e.nodeIndices[t],i=e.tensorIndices[t],o=n[`${r.name}_${a}_${i}`];s.push(o)}const r=rp(t.computeOutputShape(Nc(s))),a=t.inboundNodes.indexOf(e);for(let e=0;e<r.length;e++){n[`${t.name}_${a}_${e}`]=r[e]}}}const r=[],a=[];for(let e=0;e<this.outputLayers.length;e++){const t=this.outputLayers[e],n=this.outputLayersNodeIndices[e],s=this.outputLayersTensorIndices[e],r=`${t.name}_${n}_${s}`;a.push(r)}for(let e=0;e<a.length;e++){const t=a[e];kc(t in n),r.push(n[t])}return Nc(r)}runInternalGraph(e,t){null==t&&(t=wc(null,e.length));const n={};for(let s=0;s<this.inputs.length;++s){const r=this.inputs[s],a=e[s],i=t[s];n[r.id]=[a,i]}const s=Object.keys(this.nodesByDepth).map(e=>parseInt(e,10)).sort(Ac);for(const e of s){const t=this.nodesByDepth[e];for(const e of t){const t=e.outboundLayer,s=e.inputTensors,r=e.outputTensors,a=new Array;for(const e of s)e.id in n&&a.push(n[e.id]);if(a.length===s.length){let s,i,o,l,u={};if(null!=e.callArgs&&(u=e.callArgs),1===a.length){const[e,n]=a[0];null==u.mask&&(u.mask=n),o=Ic(t.call(e,u)),l=Ic(t.computeMask(e,n)),s=[e],i=[n]}else s=a.map(e=>e[0]),i=a.map(e=>e[1]),null==u.mask&&(u.mask=i),o=Ic(t.call(s,u)),l=Ic(t.computeMask(s,i));if(t.activityRegularizer)throw new bc("LayersModel invocation with concrete Tensor value(s) in the presence of activity regularizer(s) is not supported yet.");for(let e=0;e<r.length;++e){const t=r[e],s=o[e],a=l[e];n[t.id]=[s,a]}}}}const r=[],a=[],i=[];for(const e of this.outputs){kc(e.id in n,`Could not compute output ${e.name} : ${e.id}`);const[t,s]=n[e.id];i.push(t.shape),r.push(t),a.push(s)}return[r,a,i]}buildNodeConversionMap(e){const t={};let n;for(const e of this.layers){n=e instanceof md?1:0;for(let s=0;s<e.inboundNodes.length;s++){const r=md.nodeKey(e,s);this.containerNodes.has(r)&&(t[r]=n,n+=1)}}return t}getLayer(e,t){if(null!=t){if(this.layers.length<=t)throw new yc(`Was asked to retrieve layer at index ${t}, but model only has ${this.layers.length} layer(s).`);return this.layers[t]}if(null==e)throw new yc("Provide either a layer name or layer index");for(const t of this.layers)if(t.name===e)return t;throw new yc("No such layer: "+e)}calculateLosses(){return rs(()=>{const e=[];for(const t of this.layers)for(let n=0;n<t.inboundNodes.length;++n){const s=md.nodeKey(t,n);this.containerNodes.has(s)&&e.push(...t.calculateLosses())}return e})}getConfig(){const e={name:this.name},t=this.buildNodeConversionMap(this.layers),n=[];for(const e of this.layers){const s=e.getClassName(),r=e.getConfig(),a=[];for(let n=0;n<e.inboundNodes.length;n++){const s=e.inboundNodes[n],r=md.nodeKey(e,n);let i={};if(this.containerNodes.has(r)){if(s.callArgs)try{JSON.stringify(s.callArgs),i=s.callArgs}catch(t){console.warn(`Layer ${e.name} was passed non-serializable keyword arguments: `+s.callArgs+". They will not be included in the serialized model (and thus will be missing at deserialization time)."),i={}}if(s.inboundLayers.length>0){const e=[];for(let n=0;n<s.inboundLayers.length;n++){const r=s.inboundLayers[n],a=s.nodeIndices[n],o=s.tensorIndices[n];let l=t[md.nodeKey(r,a)];null==l&&(l=0),e.push([r.name,l,o,i])}a.push(e)}}}const i={};i.name=e.name,i.className=s,i.config=r,i.inboundNodes=a,n.push(i)}e.layers=n;const s=[];for(let e=0;e<this.inputLayers.length;e++){const n=this.inputLayers[e],r=this.inputLayersNodeIndices[e],a=md.nodeKey(n,r);if(!this.containerNodes.has(a))continue;let i=t[a];null==i&&(i=0);const o=this.inputLayersTensorIndices[e];s.push([n.name,i,o])}e.inputLayers=s;const r=[];for(let e=0;e<this.outputLayers.length;e++){const n=this.outputLayers[e],s=this.outputLayersNodeIndices[e],a=md.nodeKey(n,s);if(!this.containerNodes.has(a))continue;let i=t[a];null==i&&(i=0);const o=this.outputLayersTensorIndices[e];r.push([n.name,i,o])}return e.outputLayers=r,e}static fromConfig(e,t,n={},s=!1){const r={},a={};function i(e,t){e.name in a?a[e.name].push(t):a[e.name]=[t]}function o(e,t){const n=[];let s;for(const a of t){const o=a[0],l=a[1],u=a[2];if(s=null==a[3]?{}:a[3],!(o in r))return void i(e,t);const c=r[o];if(c.inboundNodes.length<=l)return void i(e,t);const h=c.inboundNodes[l];n.push(h.outputTensors[u])}n.length>0&&e.apply(Nc(n),s)}function l(e){const n=e.name,a=Ap(e,null!=t.customObjects?t.customObjects:{});a.setFastWeightInitDuringBuild(s),r[n]=a,e.inboundNodes.forEach(e=>{if(!(e instanceof Array))throw new yc("Corrupted configuration, expected array for nodeData: "+e);i(a,e)})}const u=t.name,c=t.layers;for(const e of c)l(e);for(;!Fc(a);)for(const e of c){const t=r[e.name];if(t.name in a){const e=a[t.name];delete a[t.name];for(const n of e)o(t,n)}}const h=[],p=[],d=t.inputLayers;for(const e of d){const t=e[0],n=e[1],s=e[2];kc(t in r);const a=r[t].inboundNodes[n].outputTensors;h.push(a[s])}const f=t.outputLayers;for(const e of f){const t=e[0],n=e[1],s=e[2];kc(t in r);const a=r[t].inboundNodes[n].outputTensors;p.push(a[s])}return new e({inputs:h,outputs:p,name:u})}get stateful(){if(this._stateful)throw new yc("Container instance unexpectedly has _stateful = true. The statefulness of a Container is determined by the Layers it contains. Its _stateful property must remain the default false.");for(const e of this.layers)if(e.stateful)return!0;return!1}resetStates(){rs(()=>{this.layers.forEach(e=>{e.stateful&&e.resetStates()})})}}function gd(e,t,n){const s=t.length;if(null==e||Array.isArray(e)&&0===e.length)return t.map(e=>null);if(1===s)return Array.isArray(e)&&1===e.length?e:"object"==typeof e&&t[0]in e?[e[t[0]]]:[e];if(Array.isArray(e)){if(e.length!==s)throw new Error(`Provided ${n} is an array of ${e.length} element(s), but the model has ${s} outputs. Make sure a set of weights is provided for each model output.`);return e}if("object"==typeof e&&Object.keys(e).length>0&&"object"==typeof e[Object.keys(e)[0]]){const n=[];return t.forEach(t=>{t in e?n.push(e[t]):n.push(null)}),n}throw new Error(`The model has multiple (${s}) outputs, so ${n} must be either an array with ${s} elements or an object with ${t} keys. Provided ${n} not understood: ${JSON.stringify(e)}`)}function yd(e,t){return gd(e,t,"classWeight")}async function bd(e,t,n,s){if(null!=t||null!=s)throw new Error("Support sampleWeight is not implemented yet");if(null!=n){const t=rs(()=>{if(1===e.shape.length)return e.clone();if(2===e.shape.length){if(e.shape[1]>1){const t=1;return e.argMax(t)}if(1===e.shape[1])return e.reshape([e.shape[0]]);throw new Error(`Encountered unexpected last-dimension size (${e.shape[1]}) during handling of class weights. The size is expected to be >= 1.`)}throw new Error(`Unexpected rank of target (y) tensor (${e.rank}) during handling of class weights. The rank is expected to be 1 or 2.`)}),s=Array.from(await t.data());as(t);const r=[];return s.forEach(e=>{if(null==n[e])throw new Error(`classWeight must contain all classes in the training data. The class ${e} exists in the data but not in classWeight`);r.push(n[e])}),Ki(r,"float32")}return null}function xd(e,t){return ds(e,t)}function wd(e,t){let n,s;const r=t;n=r.xs,s=r.ys,l(null!=n&&null!=s,()=>"A Dataset iterator for fitDataset() is expected to generate objects of the form `{xs: xVal, ys: yVal}`, where the two values may be `tf.Tensor`, an array of Tensors, or a map of string to Tensor.  The provided Dataset instead generates "+t);const a=kd("input",e.inputNames,n),i=kd("output",e.outputNames,s),o=a[0].shape[0];l(a.length===e.inputs.length,()=>`LayersModel has ${e.inputs.length} inputs, but the dataset provides ${a.length} inputs.  (Expected input keys: `+JSON.stringify(e.inputNames)+")"),l(i.length===e.outputs.length,()=>`LayersModel has ${e.outputs.length} outputs, but the dataset provides ${i.length} outputs.  (Expected output keys: `+JSON.stringify(e.outputNames)+")");for(let t=0;t<a.length;t++)l(a[t].shape[0]===o,()=>`Batch size mismatch: input ${e.inputNames[t]} has ${a[t].shape[0]}; expected  ${o} based on input ${e.inputNames[0]}.`);for(let t=0;t<i.length;t++)l(i[t].shape[0]===o,()=>`Batch size mismatch: output ${e.outputNames[t]} has ${i[t].shape[0]}; expected  ${o} based on input ${e.inputNames[0]}.`);return{xs:a,ys:i}}function kd(e,t,n){if(n instanceof Fe)return[n];if(Array.isArray(n))return l(n.length===t.length,()=>`Received an array of ${n.length} Tensors, but expected ${t.length} to match the ${e} keys ${t}.`),n;{const s=[];for(const r of t){if(null==n[r])throw new yc(`The feature data generated by the dataset lacks the required ${e} key '${r}'.`);s.push(n[r])}return s}}async function vd(e,t,n){const s=null!=n.batchesPerEpoch;if(l(null!=e.optimizer,()=>"You must compile a model before training/testing. Use LayersModel.compile(modelCompileConfig)."),l(null!=n,()=>"For fitDataset(), the 2nd argument (config) is required, but it is not provided in this call."),l(null!=n.epochs&&n.epochs>0&&Number.isInteger(n.epochs),()=>"For fitDataset(), config.epochs is expected to be a positive integer, but got "+n.epochs),l(!s||n.batchesPerEpoch>0&&Number.isInteger(n.batchesPerEpoch),()=>"For fitDataset(), config.batchesPerEpoch is expected to be a positive integer if specified, but got "+n.batchesPerEpoch),l(null==n.validationSplit,()=>"`validationSplit` is not supported by `fitDataset()`. Use validationData instead."),e.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");e.isTraining=!0;try{const r=null!=n.validationData;let a,i;if(r)if(Nd(n.validationData))l(null==n.validationBatches||n.validationBatches>0&&Number.isInteger(n.validationBatches),()=>"For fitDataset() with dataset-based validation, config.validationBatches is expected not to be provided, or to be a positive integer, but got "+n.validationBatches);else{const e=function(e){if(3===e.length)throw new bc("Validation with sample weights is not implemented yet.");return{xs:e[0],ys:e[1]}}(n.validationData);a=e.xs,i=e.ys}const o=e.makeTrainFunction(),u=e.getDedupedMetricsNames();let c;c=r?u.slice().concat(u.map(e=>"val_"+e)):u.slice();const h=Tp(n.callbacks,n.yieldEvery),p=null==n.verbose?1:n.verbose,{callbackList:d,history:f}=$p(h,p,n.epochs,null,null,function(e,t){let n=null;null!=t.batchesPerEpoch?n=t.batchesPerEpoch:Number.isFinite(e.size)&&(n=e.size);return n}(t,n),null,r,c);d.setModel(e),e.history=f,await d.onTrainBegin(),e.stopTraining_=!1;let m=null==n.initialEpoch?0:n.initialEpoch,g=await t.iterator();for(;m<n.epochs;){const l={};await d.onEpochBegin(m);let c=0,h=0;for(s||(g=await t.iterator());!s||c<n.batchesPerEpoch;){const t=await g.next();if(s&&t.done){console.warn("You provided `batchesPerEpoch` as "+n.batchesPerEpoch+", but your dataset iterator ran out of data after "+c+" batches; interrupting training. Make sure that your dataset can generate at least `batchesPerEpoch * epochs` batches (in this case, "+n.batchesPerEpoch*n.epochs+" batches). You may need to use the repeat() function when building your dataset.");break}if(null!=t.value){const{xs:s,ys:r}=wd(e,t.value),a={};a.batch=h,a.size=s[0].shape[0],await d.onBatchBegin(h,a);const i=[];if(null!=n.classWeight){const t=yd(n.classWeight,e.outputNames);for(let e=0;e<t.length;++e)i.push(await bd(r[e],null,t[e]))}const l=s.concat(r).concat(i),p=o(l);as(l);for(let e=0;e<u.length;++e){const t=u[e],n=p[e];a[t]=n,is(n)}await d.onBatchEnd(h,a),wp(a),h++,c++}if(s?c>=n.batchesPerEpoch:t.done){if(r){let t;t=Nd(n.validationData)?Ic(await e.evaluateDataset(n.validationData,{batches:n.validationBatches})):Ic(e.evaluate(a,i,{batchSize:null==n.validationBatchSize?32:n.validationBatchSize,verbose:0}));for(let n=0;n<e.metricsNames.length;++n)l["val_"+e.metricsNames[n]]=t[n]}break}if(e.stopTraining_)break}if(await d.onEpochEnd(m,l),m++,e.stopTraining_)break}return await d.onTrainEnd(),await e.history.syncData(),e.history}finally{e.isTraining=!1}}function Nd(e){return"function"==typeof e.iterator}function Id(e){l(e>0&&Number.isInteger(e),()=>"batchSize is required to be a positive integer, but got "+e)}function Cd(e,t,n){return null==e?[null]:Array.isArray(e)?e.map(e=>gh(e,t,n-t)):gh(e,t,n-t)}function Sd(e,t){return rs(()=>null==e?null:Array.isArray(e)?e.map(e=>Sd(e,t)):Ih(e,"int32"===t.dtype?t:t.toInt()))}function Td(e,t){const n=[];let s=0,r=null;for(;s<e;)r=s+t,r>=e&&(r=e),n.push([s,r]),s=r;return n}async function Ed(e,t,n,s={}){if(e.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");let a,i,o,l,u,c,h;e.isTraining=!0;try{const p=null==s.batchSize?32:s.batchSize;Id(p);const d=!1,f=await e.standardizeUserData(t,n,s.sampleWeight,s.classWeight,d,p);a=f[0],i=f[1],h=f[2];let m,g=!1;if(null!=s.validationData&&s.validationData.length>0){if(g=!0,2!==s.validationData.length)throw 3===s.validationData.length?new bc("validationData including sample weights is not supported yet."):new yc("When passing validation data, it must contain 2 (valX, valY) or 3 (valX, valY, valSampleWeight) items; "+s.validationData+" is invalid.");o=s.validationData[0],l=s.validationData[1];const t=!0,n=await e.standardizeUserData(o,l,null,null,t,p);u=n[0],c=n[1],m=u.concat(c)}else if(null!=s.validationSplit&&s.validationSplit>0&&s.validationSplit<1){g=!0;const e=Math.floor(a[0].shape[0]*(1-s.validationSplit)),t=a[0].shape[0];u=Cd(a,e,t),a=Cd(a,0,e),c=Cd(i,e,t),i=Cd(i,0,e),m=u.concat(c)}else null!=s.validationSteps&&(g=!0);const y=a.concat(i).concat(h);e.checkTrainableWeightsConsistency();const b=e.makeTrainFunction(),x=e.getDedupedMetricsNames();let w,k;g?(e.makeTestFunction(),w=e.testFunction,k=x.slice().concat(x.map(e=>"val_"+e))):(w=null,m=[],k=x.slice());const v=Tp(s.callbacks,s.yieldEvery);return await async function(e,t,n,s,a,i,o,l,u,c,h,p,d,f,m){null==a&&(a=32),null==i&&(i=1),null==h&&(h=!0),null==d&&(d=0);let g=!1;if(null!=u&&null!=c&&(g=!0),null!=m&&(g=!0,null==f))throw new yc("Can only use `validationSteps` when doing step-wise training, i.e., `stepsPerEpoch` must be set.");const y=e.checkNumSamples(n,a,f,"steps_per_epoch");let b;null!=y&&(b=dh(0,y)),null==o&&(o=1);const{callbackList:x,history:w}=$p(l,o,i,d,y,f,a,g,p);x.setModel(e),e.history=w,await x.onTrainBegin(),e.stopTraining_=!1;for(let o=d;o<i;++o){await x.onEpochBegin(o);const i={};if(null!=f)throw new bc("stepsPerEpoch mode is not implemented yet.");{if("batch"===h)throw new bc("batch shuffling is not implemneted yet");h&&r(b);const o=Ki(b),l=Td(y,a);for(let r=0;r<l.length;++r){const h={};if(await x.onBatchBegin(r,h),rs(()=>{const p=l[r][0],d=l[r][1],f=gh(o,p,d-p);h.batch=r,h.size=d-p;const m=Sd(n,f),y=t(m);for(let e=0;e<s.length;++e){const t=s[e],n=y[e];h[t]=n,is(n)}if(r===l.length-1&&g){const t=e.testLoop(u,c,a);for(let e=0;e<s.length;++e){const n=s[e],r=t[e];is(r),i["val_"+n]=r}}}),await x.onBatchEnd(r,h),wp(h),e.stopTraining_)break}o.dispose()}if(await x.onEpochEnd(o,i),e.stopTraining_)break}return await x.onTrainEnd(),await e.history.syncData(),e.history}(e,b,y,x,p,s.epochs,s.verbose,v,w,m,s.shuffle,k,s.initialEpoch,null,null)}finally{e.isTraining=!1,Ad(a,t),Ad(i,n),Ad(u,o),Ad(c,l),null!=h&&as(h)}}function $d(e){const t=[];e instanceof Fe&&(e=[e]);for(let n=0;n<e.length;++n){const s=e[n];if(1===s.rank)t.push(mh(s,1));else{if(0===s.rank)throw new Error("Expected tensor to be at least 1D, but received a 0D tensor (scalar).");t.push(s)}}return t}function Ad(e,t){if(null==e)return;const n=[];if(t instanceof Fe)n.push(t.id);else if(Array.isArray(t))t.forEach(e=>n.push(e.id));else if(null!=t)for(const e in t){const s=t[e];n.push(s.id)}const s=[];if(e instanceof Fe)-1===n.indexOf(e.id)&&s.push(e);else if(Array.isArray(e))e.forEach(e=>{-1===n.indexOf(e.id)&&s.push(e)});else if(null!=e)for(const t in e){const r=e[t];-1===n.indexOf(r.id)&&s.push(r)}s.forEach(e=>{e.isDisposed||e.dispose()})}function Rd(e){return Array.isArray(e)}function Fd(e){return!function(e){return e instanceof Fe}(e)&&!Rd(e)}function Dd(e,t,n,s=!0,r=""){if(null==t||0===t.length){if(null!=e){let t=!1;if(Rd(e)&&e.length>0)t=!0;else if(Fd(e)){for(const n in e)if(e.hasOwnProperty(n)){t=!0;break}}else t=!0;if(t)throw new yc(`Error when checking model ${r} expected no data, but got `+e)}return[]}if(null==e)return t.map(e=>null);let a;if(Fd(e)){e=e,a=[];for(const n of t){if(null==e[n])throw new yc(`No data provided for "${n}". Need data for each key in: `+t);a.push(e[n])}}else if(Rd(e)){if((e=e).length!==t.length)throw new yc(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the model expected. Expected to see ${t.length} Tensor(s), but instead got the following list of Tensor(s): `+e);a=e}else{if(e=e,t.length>1)throw new yc(`The model ${r} expects ${t.length} Tensor(s), but only received one Tensor. Found: Tensor with shape `+e.shape);a=[e]}if(a=$d(a),null!=n)for(let e=0;e<t.length;++e){if(null==n[e])continue;const i=a[e];if(i.shape.length!==n[e].length)throw new yc(`Error when checking ${r}: expected ${t[e]} to have ${n[e].length} dimension(s). but got array with shape `+i.shape);for(let a=0;a<n[e].length;++a){if(0===a&&!s)continue;const o=i.shape[a],l=n[e][a];if(null!=l&&l>=0&&o!==l)throw new yc(`Error when checking ${r}: expected ${t[e]} to have shape [${n[e]}], but got array with shape [${i.shape}].`)}}return a}function _d(e,t,n,s=!0,r=""){let a;if(Array.isArray(e)){if(e.length!==t.length)throw new yc(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the the model expected. Expected to see ${t.length} Tensor(s), but instead got ${e.length} Tensors(s).`);a=e}else{if(t.length>1)throw new yc(`The model expects ${t.length} ${r} Tensors, but only received one Tensor. Found: array with shape `+JSON.stringify(e.shape)+".");a=[e]}if(null!=n)for(let e=0;e<t.length;++e){if(null==n[e])continue;const i=a[e];if(i.shape.length!==n[e].length)throw new yc(`Error when checking ${r}: expected ${t[e]} to have ${n[e].length} dimension(s), but got array with shape `+JSON.stringify(i.shape));for(let a=0;a<n[e].length;++a){if(0===a&&!s)continue;const o=i.shape[a],l=n[e][a];if(null!=l&&l!==o)throw new yc(`Error when checking ${r}: expected ${t[e]} to have shape ${JSON.stringify(n[e])} but got array with shape ${JSON.stringify(i.shape)}.`)}}}class Od extends md{constructor(e){super(e),this.isTraining=!1}summary(e,t,n=console.log){if(!this.built)throw new yc("This model has never been called, thus its weights have not been created yet. So no summary can be displayed. Build the model first (e.g., by calling it on some test data).");nd(this,e,t,n)}compile(e){if(null==e.loss&&(e.loss=[]),this.loss=e.loss,"string"==typeof e.optimizer)this.optimizer_=function(e){const t={Adagrad:()=>Cl.adagrad(.01),Adadelta:()=>Cl.adadelta(1,.95,fc()),Adam:()=>Cl.adam(.001,.9,.999,fc()),Adamax:()=>Cl.adamax(.002,.9,.999,fc(),0),RMSProp:()=>Cl.rmsprop(.001,.9,0,fc()),SGD:()=>Cl.sgd(.01)};if(t.adagrad=t.Adagrad,t.adadelta=t.Adadelta,t.adam=t.Adam,t.adamax=t.Adamax,t.rmsprop=t.RMSProp,t.sgd=t.SGD,e in t)return t[e]();throw new yc("Unknown Optimizer "+e)}(e.optimizer),this.isOptimizerOwned=!0;else{if(!(e.optimizer instanceof gl))throw new yc("User-defined optimizer must be an instance of tf.Optimizer.");this.optimizer_=e.optimizer,this.isOptimizerOwned=!1}let t=[];if(Array.isArray(e.loss)||"string"==typeof e.loss||"function"==typeof e.loss)if(Array.isArray(e.loss)){if(e.loss.length!==this.outputs.length)throw new yc(`When passing an Array as loss, it should have one entry per model output. The model has ${this.outputs.length} output(s), but you passed loss=${e.loss}.`);const n=e.loss;t=n.map(e=>Vp(e))}else{const n=Vp(e.loss);this.outputs.forEach(e=>{t.push(n)})}else{e.loss=e.loss;for(const t in e.loss)if(-1===this.outputNames.indexOf(t))throw new yc(`Unknown entry in loss dictionary: "${t}". Only expected the following keys: `+this.outputNames);for(const n of this.outputNames)null==e.loss[n]&&console.warn(`Output "${n}" is missing from loss dictionary. We assume this was done on purpose, and we will not be expecting data to be passed to ${n} during training`),t.push(Vp(e.loss[n]))}this.lossFunctions=t,this.feedOutputNames=[],this.feedOutputShapes=[],this.feedLossFns=[];for(let e=0;e<this.outputs.length;++e){const t=this.internalOutputShapes[e],n=this.outputNames[e];this.feedOutputNames.push(n),this.feedOutputShapes.push(t),this.feedLossFns.push(this.lossFunctions[e])}const n=[];this.metrics=e.metrics,this.metricsNames=["loss"],this.metricsTensors=[],rh("loss",()=>{for(let e=0;e<this.outputs.length;++e){if(-1!==n.indexOf(e))continue;const t=this.lossFunctions[e];this.outputs.length>1&&(this.metricsTensors.push([t,e]),this.metricsNames.push(this.outputNames[e]+"_loss"))}});const s=function(e,t){if(null==e||Array.isArray(e)&&0===e.length)return t.map(e=>[]);let n;if("string"==typeof e||"function"==typeof e)n=[e];else{if(!Array.isArray(e)&&"object"!=typeof e)throw new TypeError("Type of metrics argument not understood. Expected an string,function, Array, or Object, found: "+e);n=e}if(Array.isArray(n))return t.map(e=>n);{const e=[];for(const s of t){let t=n.hasOwnProperty(s)?n[s]:[];Array.isArray(t)||(t=[t]),e.push(t)}return e}}(e.metrics,this.outputNames),r=(e,t,n)=>{this.outputNames.length>1&&(t=this.outputNames[e]+"_"+t),this.metricsNames.push(t),this.metricsTensors.push([n,e])};rh("metric",()=>{for(let e=0;e<this.outputs.length;++e){if(-1!==n.indexOf(e))continue;(t=>{let n,s,a;for(const i of t){if("string"==typeof i&&-1!==["accuracy","acc","crossentropy","ce"].indexOf(i)){const t=this.internalOutputShapes[e];let r;1===t[t.length-1]||this.lossFunctions[e]===zp?-1!==["accuracy","acc"].indexOf(i)?s=Up:-1!==["crossentropy","ce"].indexOf(i)&&(s=Kp):this.lossFunctions[e]===Lp?-1!==["accuracy","acc"].indexOf(i)?s=Xp:-1!==["crossentropy","ce"].indexOf(i)&&(s=Jp):-1!==["accuracy","acc"].indexOf(i)?s=Gp:-1!==["crossentropy","ce"].indexOf(i)&&(s=Yp),-1!==["accuracy","acc"].indexOf(i)?r="acc":-1!==["crossentropy","ce"].indexOf(i)&&(r="ce"),a=s,n=""+r}else{const e=Qp(i);a=e,n=""+ed(i)}let t;rh(n,()=>{t=a}),r(e,n,t)}})(s[e])}}),this.collectedTrainableWeights=this.trainableWeights}checkTrainableWeightsConsistency(){null!=this.collectedTrainableWeights&&this.trainableWeights.length!==this.collectedTrainableWeights.length&&console.warn("Discrepancy between trainableweights and collected trainable weights. Did you set `model.trainable` without calling `model.compile()` afterwards?")}evaluate(e,t,n={}){const s=null==n.batchSize?32:n.batchSize;Id(s);const r=this.standardizeUserDataXY(e,t,!0,s);try{const a=r[0].concat(r[1]);this.makeTestFunction();const i=this.testFunction;return Nc(this.testLoop(i,a,s,n.verbose,n.steps))}finally{Ad(r[0],e),Ad(r[1],t)}}async evaluateDataset(e,t){return this.makeTestFunction(),async function(e,t,n){const s=null!=(n=n||{}).batches,r=e.testFunction;let a=[];if(n.verbose>0)throw new bc("Verbose mode is not implemented yet.");l(!s||n.batches>0&&Number.isInteger(n.batches),()=>"Test loop expects `batches` to be a positive integer, but received "+JSON.stringify(n.batches));const i="function"==typeof t.next?t:await t.iterator();let o=0,u=0;for(;!s||u<n.batches;){const t=await i.next();if(a=rs(()=>{if(t.value){const{xs:n,ys:s}=wd(e,t.value),i=n.concat(s),l=rs(()=>r(i));if(as(i),0===u)for(let e=0;e<l.length;++e)a.push(Ii(0));const c=i[0].shape[0];for(let e=0;e<l.length;++e){const t=l[e],n=a[e];a[e]=rs(()=>cs(a[e],ds(c,t))),u>0&&as(n)}as(l),o+=c,++u}return a}),t.done){s&&console.warn(`Your dataset iterator ran out of data during evaluateDataset(). Interrupting evalution. Make sure that your dataset can generate at least \`batches\` batches (in this case, ${n.batches} batches). You may need to use the repeat() function when building your dataset.`);break}}for(let e=0;e<a.length;++e){const t=a[e];a[e]=ps(a[e],o),as(t)}return Nc(a)}(this,e,t)}checkNumSamples(e,t,n,s="steps"){let r;if(null!=n){if(r=null,null!=t)throw new yc(`If ${s} is set, batchSize must be null or undefined.Got batchSize = `+t)}else{if(null==e)throw new yc("Either the input data should have a defined shape, or "+s+" shoud be specified.");r=Array.isArray(e)?e[0].shape[0]:e.shape[0]}return r}execute(e,t){if(Array.isArray(t)&&0===t.length)throw new yc("`outputs` is an empty Array, which is not allowed.");const n=Array.isArray(t),s=n?t:[t],r=this.retrieveSymbolicTensors(s),a=new ld;if(e instanceof Fe&&(e=[e]),Array.isArray(e)){if(e.length!==this.inputs.length)throw new yc(`The number of inputs provided (${e.length}) does not match the number of inputs of this model (${this.inputs.length}).`);for(let t=0;t<this.inputs.length;++t)a.add(this.inputs[t],e[t])}else for(const t of this.inputs){const n=e[t.name];if(null==n)throw new yc("No value is provided for the model's input "+t.name);a.add(t,n)}const i=hd(r,a);return n?i:i[0]}retrieveSymbolicTensors(e){const t=wc(null,e.length);let n=e.length;for(const s of this.layers){const r=Array.isArray(s.output)?s.output:[s.output],a=r.map(e=>e.name);for(let s=0;s<e.length;++s){const i=a.indexOf(e[s]);if(-1!==i&&(t[s]=r[i],n--),0===n)break}if(0===n)break}if(n>0){const n=[];throw t.forEach((t,s)=>{null==t&&n.push(e[s])}),new yc("Cannot find SymbolicTensors for output name(s): "+JSON.stringify(n))}return t}predictLoop(e,t=32,n=!1){return rs(()=>{const s=this.checkNumSamples(e);if(n)throw new bc("Verbose predictLoop() is not implemented yet.");const r=Td(s,t),a=this.outputs.map(e=>[]);for(let t=0;t<r.length;++t){rs(()=>{const n=r[t][0],s=r[t][1],a=Cd(e,n,s),i=[];if(Array.isArray(a))for(let e=0;e<a.length;++e)i.push({key:this.inputs[e],value:a[e]});else i.push({key:this.inputs[0],value:a});const o=new ld(i);return hd(this.outputs,o)}).forEach((e,t)=>a[t].push(e))}return Nc(a.map(e=>Us(e,0)))})}predict(e,t={}){const n=$d(e);_d(n,this.inputNames,this.feedInputShapes,!1);try{const s=null==t.batchSize?32:t.batchSize;return Id(s),this.predictLoop(n,s)}finally{Ad(n,e)}}predictOnBatch(e){_d(e,this.inputNames,this.feedInputShapes,!0);const t=(Array.isArray(e)?e[0]:e).shape[0];return this.predictLoop(e,t)}standardizeUserDataXY(e,t,n=!0,s){if(null==this.optimizer_)throw new gc("You must compile a model before training/testing. Use LayersModel.compile(modelCompileArgs).");const r=[];for(let e=0;e<this.feedOutputShapes.length;++e){const t=this.feedOutputShapes[e];this.feedLossFns[e]===Lp?r.push(t.slice(0,t.length-1).concat([1])):r.push(t)}if(function(e,t,n){const s=Rc(e.map(e=>e.shape[0]));s.sort();const r=Rc(t.map(e=>e.shape[0]));if(r.sort(),s.length>1)throw new yc("All input Tensors (x) should have the same number of samples. Got array shapes: "+JSON.stringify(e.map(e=>e.shape)));if(r.length>1)throw new yc("All target Tensors (y) should have the same number of samples. Got array shapes: "+JSON.stringify(t.map(e=>e.shape)));if(s.length>0&&r.length>0&&!d(s,r))throw new yc(`Input Tensors should have the same number of samples as target Tensors. Found ${s[0]} input sample(s) and ${r[0]} target sample(s).`)}(e=Dd(e,this.feedInputNames,this.feedInputShapes,!1,"input"),t=Dd(t,this.feedOutputNames,r,!1,"target")),function(e,t,n){const s=[Fp,zp,Mp];for(let r=0;r<e.length;++r){const a=e[r],i=t[r],o=n[r];if(null!=i){if(i===Mp&&1===a.shape[a.shape.length-1])throw new yc(`You are passing a target array of shape ${a.shape} while using a loss 'categorical_crossentropy'. 'categorical_crossentropy'expects targets to be binary matrices (1s and 0s) of shape [samples, classes].`);if(-1!==s.indexOf(i)){const e=a.shape.slice(1),t=o.slice(1);for(let n=0;n<e.length;++n){const s=e[n],r=t[n];if(null!=r&&s!==r)throw new yc(`A target Tensor with shape ${a.shape} was passed for an output of shape ${o}, while using a loss function that expects targets to have the same shape as the output.`)}}}}}(t,this.feedLossFns,this.feedOutputShapes),this.stateful&&null!=s&&s>0&&e[0].shape[0]%s!=0)throw new yc(`In a stateful network, you should only pass inputs with a number of samples that is divisible by the batch size ${s}. Found: ${e[0].shape[0]} sample(s).`);return[e,t]}async standardizeUserData(e,t,n,s,r=!0,a){const[i,o]=this.standardizeUserDataXY(e,t,r,a);if(null!=n)throw new Error("sample weight is not supported yet.");let l=null;if(null!=s){const e=yd(s,this.outputNames);l=[];for(let t=0;t<e.length;++t)l.push(await bd(o[t],null,e[t]))}return[i,o,l]}testLoop(e,t,n,s=0,r){return rs(()=>{const a=this.checkNumSamples(t,n,r,"steps"),i=[];if(s>0)throw new bc("Verbose mode is not implemented yet.");if(null!=r)throw new bc("steps mode in testLoop() is not implemented yet");{const s=Td(a,n),r=Ki(dh(0,a));for(let n=0;n<s.length;++n){const a=s[n][0],o=s[n][1],l=gh(r,a,o-a),u=Sd(t,l),c=e(u);if(0===n)for(let e=0;e<c.length;++e)i.push(Ii(0));for(let e=0;e<c.length;++e){const t=c[e];i[e]=cs(i[e],ds(o-a,t))}}for(let e=0;e<i.length;++e)i[e]=ps(i[e],a)}return i})}getDedupedMetricsNames(){const e=this.metricsNames,t=[];for(let n=0;n<e.length;++n){const s=e[n];let r=s;if(vc(e,s)>1){r+="_"+vc(e.slice(0,n),s)}t.push(r)}return t}makeTrainFunction(){return e=>{const t=[],n=e.slice(0,this.inputs.length),s=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),r=e.slice(this.inputs.length+this.outputs.length,this.inputs.length+2*this.outputs.length),a=[],i=this.collectedTrainableWeights.map(e=>e.read());return[this.optimizer_.minimize(()=>{const e=[];for(let t=0;t<this.inputs.length;++t)e.push({key:this.inputs[t],value:n[t]});const i=new ld(e),o=hd(this.outputs,i,{training:!0});let l;for(let e=0;e<this.lossFunctions.length;++e){let n=(0,this.lossFunctions[e])(s[e],o[e]);null!=r[e]&&(n=xd(n,r[e]));const a=Sa(n);t.push(a),l=0===e?n:cs(l,n)}for(let e=0;e<this.metricsTensors.length;++e){let n;if(this.outputs.length>1&&e<this.outputs.length)n=t[e];else{const t=this.metricsTensors[e][0],r=this.metricsTensors[e][1];n=Sa(t(s[r],o[r]))}is(n),a.push(n)}return l=Sa(l),this.calculateLosses().forEach(e=>{l=cs(l,e)}),l},!0,i)].concat(a)}}makeTestFunction(){this.testFunction=e=>rs(()=>{const t=[];let n;const s=e.slice(0,this.inputs.length),r=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),a=[];for(let e=0;e<this.inputs.length;++e)a.push({key:this.inputs[e],value:s[e]});const i=new ld(a),o=hd(this.outputs,i);for(let e=0;e<this.lossFunctions.length;++e){const s=this.lossFunctions[e],a=Sa(s(r[e],o[e]));n=0===e?a:cs(n,a),t.push(n)}for(let e=0;e<this.metricsTensors.length;++e){const n=this.metricsTensors[e][0],s=this.metricsTensors[e][1],a=Sa(n(r[s],o[s]));t.push(a)}return t})}async fit(e,t,n={}){return Ed(this,e,t,n)}async fitDataset(e,t){return vd(this,e,t)}async trainOnBatch(e,t){const n=await this.standardizeUserData(e,t),s=n[0],r=n[1],a=this.makeTrainFunction()(s.concat(r)),i=[];for(const e of a){const t=await e.data();i.push(t[0])}return as(a),Nc(i)}getNamedWeights(e){const t=[],n=null!=e&&e.trainableOnly,s=n?this.trainableWeights:this.weights,r=this.getWeights(n);for(let e=0;e<s.length;++e)n&&!s[e].trainable||t.push({name:s[e].originalName,tensor:r[e]});return t}set stopTraining(e){this.stopTraining_=e}get stopTraining(){return this.stopTraining_}get optimizer(){return this.optimizer_}set optimizer(e){this.optimizer_!==e&&(this.optimizer_=e,this.isOptimizerOwned=!1)}dispose(){const e=super.dispose();if(0===e.refCountAfterDispose&&null!=this.optimizer&&this.isOptimizerOwned){const t=ss().numTensors;this.optimizer_.dispose(),e.numDisposedVariables+=t-ss().numTensors}return e}getLossIdentifiers(){let e;if("string"==typeof this.loss)e=Cc(this.loss);else if(Array.isArray(this.loss)){for(const e of this.loss)if("string"!=typeof e)throw new Error("Serialization of non-string loss is not supported.");e=this.loss.map(e=>Cc(e))}else{const t=Object.keys(this.loss);e={};const n=this.loss;for(const s of t){if("string"!=typeof n[s])throw new Error("Serialization of non-string loss is not supported.");e[s]=Cc(n[s])}}return e}getMetricIdentifiers(){if("string"==typeof this.metrics||"function"==typeof this.metrics)return[Cc(ed(this.metrics))];if(Array.isArray(this.metrics))return this.metrics.map(e=>Cc(ed(e)));{const e={};for(const t in this.metrics)e[t]=Cc(ed(this.metrics[t]));return e}}getTrainingConfig(){return{loss:this.getLossIdentifiers(),metrics:this.getMetricIdentifiers(),optimizer_config:{class_name:this.optimizer.getClassName(),config:this.optimizer.getConfig()}}}loadTrainingConfig(e){if(null!=e.weighted_metrics)throw new Error("Loading weight_metrics is not supported yet.");if(null!=e.loss_weights)throw new Error("Loading loss_weights is not supported yet.");if(null!=e.sample_weight_mode)throw new Error("Loading sample_weight_mode is not supported yet.");const t=Ap(od(e.optimizer_config));let n,s;if("string"==typeof e.loss)n=Sc(e.loss);else if(Array.isArray(e.loss))n=e.loss.map(e=>Sc(e));else if(null!=e.loss){n={};for(const t in e.loss)n[t]=Sc(e.loss[t])}if(Array.isArray(e.metrics))s=e.metrics.map(e=>Sc(e));else if(null!=e.metrics){s={};for(const t in e.metrics)s[t]=Sc(e.metrics[t])}this.compile({loss:n,metrics:s,optimizer:t})}async save(e,t){if("string"==typeof e){const t=Nt(e);if(0===t.length)throw new yc(`Cannot find any save handlers for URL '${e}'`);if(t.length>1)throw new yc(`Found more than one (${t.length}) save handlers for URL '${e}'`);e=t[0]}if(null==e.save)throw new yc("LayersModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");const n=await dt(this.getNamedWeights(t)),s={modelTopology:this.toJSON(null,!1),format:"layers-model",generatedBy:"TensorFlow.js tfjs-layers v3.0.0",convertedBy:null};if(null!=t&&t.includeOptimizer&&null!=this.optimizer){s.trainingConfig=this.getTrainingConfig();const e="optimizer",{data:t,specs:r}=await dt(await this.optimizer.getWeights(),e);n.specs.push(...r),n.data=bt([n.data,t])}if(null!=this.userDefinedMetadata){const e=!0;td(this.userDefinedMetadata,this.name,e),s.userDefinedMetadata=this.userDefinedMetadata}return s.weightData=n.data,s.weightSpecs=n.specs,e.save(s)}setUserDefinedMetadata(e){td(e,this.name),this.userDefinedMetadata=e}getUserDefinedMetadata(){return this.userDefinedMetadata}}Od.className="Model",Kn(Od);class Md extends Od{}async function Ld(e,t){if(null==t&&(t={}),"string"==typeof e){const n=It(e,t);if(0===n.length)n.push(cn(e,t));else if(n.length>1)throw new yc(`Found more than one (${n.length}) load handlers for URL '${e}'`);e=n[0]}return async function(e,t,n){null==n&&(n={});if(null==e.load)throw new yc("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const s=await e.load();let r=s.modelTopology;null!=r.model_config&&(r=r.model_config);const a=null==n.strict||n.strict,i=null!=s.weightData&&null!=s.weightSpecs&&a,o=Ap(od(r),t,i),l=s.trainingConfig;null!=l&&o.loadTrainingConfig(l);null!=s.userDefinedMetadata&&o.setUserDefinedMetadata(s.userDefinedMetadata);if(null!=s.weightData){if(null==s.weightSpecs)throw new yc("LayersModel artifacts contains weight data, but not weight specs. Therefore loading of weights cannot proceed.");const{modelWeights:e,optimizerWeights:t}=function(e,t){const n=ft(e,t),s={},r=[];return t.forEach(e=>{"optimizer"===e.group?r.push({name:e.name,tensor:n[e.name]}):s[e.name]=n[e.name]}),{modelWeights:s,optimizerWeights:r}}(s.weightData,s.weightSpecs);o.loadWeights(e,a),null!=o.optimizer&&t.length>0&&await o.optimizer.setWeights(t),as(e),as(t.map(e=>e.tensor))}return o}(e,void 0,t)}Md.className="Functional",Kn(Md);class zd extends Od{constructor(e){if(super({inputs:[],outputs:[]}),e=e||{},this.trainable=!0,this.built=!1,this.name=null!=e.name?e.name:np("sequential_"),null!=e.layers)for(const t of e.layers)this.add(t)}checkShape(e){if(e.inboundNodes[0].outputTensors[0].shape.some(e=>e<0))throw new yc("Negative dimension size caused by adding layer "+e.name+" with input shape ["+e.inboundNodes[0].inputTensors[0].shape+"]")}add(e){const t=e instanceof zd||e instanceof Od;let n;if(t){if(n=e,1!==n.outputs.length)throw new yc("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");if(1!==n.inputs.length)throw new yc("All layers in a Sequential model should have a single input tensor. For multi-input layers, use the functional API.")}if(0===this.outputs.length){if(0===e.inboundNodes.length){if(null==e.batchInputShape)throw new yc("The first layer in a Sequential model must get an `inputShape` or `batchInputShape` argument.");const t=bp({batchShape:e.batchInputShape,dtype:e.dtype,name:e.name+"_input"});e.apply(t)}if(t)this.outputs=n.outputs,this.inputs=n.inputs;else{if(1!==e.inboundNodes.length)throw new yc(`A layer added to a Sequential model must not already be connected somewhere else. LayersModel received layer ${e.name} which has ${e.inboundNodes.length} pre-existing inbound connections.`);if(1!==e.inboundNodes[0].outputTensors.length)throw new yc("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(e),this.outputs=[e.inboundNodes[0].outputTensors[0]],this.inputs=function e(t,n,s){if((null==n||null!=s&&s>0)&&(n=t.sourceLayer,s=t.nodeIndex),0===n.inboundNodes.length)return[t];{const t=n.inboundNodes[s];if(0===t.inboundLayers.length)return t.inputTensors;{const n=[];for(let s=0;s<t.inboundLayers.length;s++){const r=e(t.inputTensors[s],t.inboundLayers[s],t.nodeIndices[s]);for(const e of r)-1===n.indexOf(e)&&n.push(e)}return n}}}(this.outputs[0])}this.inboundNodes=[],new fp({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:wc(null,this.inputs.length),outputMasks:[null],inputShapes:this.inputs.map(e=>e.shape),outputShapes:this.outputs[0].shape})}else{const t=e.apply(this.outputs[0]);if(Array.isArray(t))throw new TypeError("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(e),this.outputs=[t],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}this.layers.push(e),this.built=!1}pop(){if(0===this.layers.length)throw new TypeError("There are no layers in the model.");if(this.layers.pop(),0===this.layers.length)this.outputs=[],this.inboundNodes=[],this.outboundNodes=[];else{const e=this.layers.length-1;this.layers[e].outboundNodes=[],this.outputs=[this.layers[e].output],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}}call(e,t){return null==this.model&&this.build(),this.model.call(e,t)}build(e){if(ip(e),0===this.inputs.length||0===this.outputs.length)throw new TypeError("Sequential model cannot be built: model is empty. Add some layers first.");this.model=new Od({inputs:this.inputs,outputs:this.outputs[0],name:this.name+"_model"}),this.model.trainable=this.trainable,this.supportsMasking=this.model.supportsMasking,this.inputLayers=this.model.inputLayers,this.inputLayersNodeIndices=this.model.inputLayersNodeIndices,this.inputLayersTensorIndices=this.model.inputLayersTensorIndices,this.outputLayers=this.model.outputLayers,this.outputLayersNodeIndices=this.model.outputLayersNodeIndices,this.outputLayersTensorIndices=this.model.outputLayersTensorIndices,this.nodesByDepth=this.model.nodesByDepth,this.containerNodes=this.model.containerNodes,this.outputNames=this.model.outputNames,this.inputNames=this.model.inputNames,this.built=!0}countParams(){return this.built||this.build(),super.countParams()}summary(e,t,n=console.log){this.built||this.build(),super.summary(e,t,n)}setWeights(e){null==this.model&&this.build(),this.model.setWeights(e)}evaluate(e,t,n={}){if(!this.built)throw new gc("The model needs to be compiled before being used.");return this.model.evaluate(e,t,n)}async evaluateDataset(e,t){if(!this.built)throw new gc("The model needs to be compiled before being used.");return this.model.evaluateDataset(e,t)}predict(e,t={}){return null==this.model&&this.build(),this.model.predict(e,t)}predictOnBatch(e){return null==this.model&&this.build(),this.model.predictOnBatch(e)}compile(e){this.build(),this.model.compile(e),this.optimizer_=this.model.optimizer,this.isOptimizerOwned=this.model.isOptimizerOwned,this.loss=this.model.loss,this.metrics=this.model.metrics,this.metricsTensors=this.model.metricsTensors,this.metricsNames=this.model.metricsNames}get optimizer(){return null==this.model?void 0:this.model.optimizer}set optimizer(e){this.model.optimizer=e}async fit(e,t,n={}){if(!this.built)throw new gc("The model needs to be compiled before being used.");return this.model.fit(e,t,n)}async fitDataset(e,t){if(!this.built)throw new gc("The model needs to be compiled before being used.");return this.model.fitDataset(e,t)}async trainOnBatch(e,t){return this.model.trainOnBatch(e,t)}static fromConfig(e,t,n={},s=!1){let r,a={};if(t instanceof Array){if(null==t[0].className||"Merge"===t[0].className)throw new yc("Legacy serialization format not supported yet.");r=t}else l(null!=t.layers,()=>"When the config data for a Sequential model is not an Array, it must be an Object that contains the 'layers' field."),r=t.layers,delete t.layers,a=t;const i=new e(a);if(!(i instanceof zd))throw new bc("Sequential.fromConfig called on non-Sequential input: "+i);for(const e of r){const t=Ap(e,void 0,s);s&&t.setFastWeightInitDuringBuild(!0),i.add(t)}return i}set stopTraining(e){if(null==this.model)throw new yc("Cannot set the stopTraining property of a sequential model before it is compiled.");this.model.stopTraining=e}get stopTraining(){if(null==this.model)throw new yc("Cannot get the stopTraining property of a sequential model before it is compiled.");return this.model.stopTraining}getConfig(){const e=[];for(const t of this.layers){const n={};n.className=t.getClassName(),n.config=t.getConfig(),e.push(n)}return{name:this.name,layers:e}}}function Bd(e){return bp(e)}zd.className="Sequential",Kn(zd);class Pd extends jn{getConfig(){return{}}}class Wd extends Pd{apply(e,t=1){return function(e,t=1){if(1!==t)throw new bc(`Support for alpha values other than 1 (${t}) is not implemented yet.`);return Ar(e)}(e,t)}}Wd.className="elu",Kn(Wd);class Vd extends Pd{apply(e){return Ci(e)}}Vd.className="selu",Kn(Vd);class Ud extends Pd{apply(e){return mi(e)}}Ud.className="relu",Kn(Ud);class Gd extends Pd{apply(e){return rs(()=>Ea(6,mi(e)))}}Gd.className="relu6",Kn(Gd);class Hd extends Pd{apply(e){return e}}Hd.className="linear",Kn(Hd);class jd extends Pd{apply(e){return Gs(e)}}jd.className="sigmoid",Kn(jd);class qd extends Pd{apply(e){return function(e){return rs(()=>{const t=cs(.5,ds(.2,e));return nr(t,0,1)})}(e)}}qd.className="hardSigmoid",Kn(qd);class Kd extends Pd{apply(e){return sa(e)}}Kd.className="softplus",Kn(Kd);class Xd extends Pd{apply(e){return function(e){return rs(()=>ps(e,fs(e).add(1)))}(e)}}Xd.className="softsign",Kn(Xd);class Yd extends Pd{apply(e){return js(e)}}Yd.className="tanh",Kn(Yd);class Jd extends Pd{apply(e,t=-1){return Oi(e,t)}}Jd.className="softmax",Kn(Jd);class Zd extends Pd{apply(e,t=-1){return la(e,t)}}Zd.className="logSoftmax",Kn(Zd);class Qd extends Pd{apply(e,t=1){return rs(()=>Gs(e.mul(t)).mul(e))}}function ef(e){return e.getClassName()}function tf(e,t={}){return $c(e,qn.getMap().classNameMap,t,"activation")}function nf(e){if(null==e){const e={className:"linear",config:{}};return tf(e)}if("string"==typeof e){const t={};return t.className=e,t.config={},tf(t)}return e instanceof Pd?e:tf(e)}function sf(e){if(null!=e&&"object"!=typeof e)throw new Error("Argument to L1L2 regularizer's constructor is expected to be an object, but received: "+e)}Qd.className="swish",Kn(Qd);class rf extends jn{}class af extends rf{constructor(e){super(),sf(e),this.l1=null==e||null==e.l1?.01:e.l1,this.l2=null==e||null==e.l2?.01:e.l2,this.hasL1=0!==this.l1,this.hasL2=0!==this.l2}apply(e){return rs(()=>{let t=Ma([1]);return this.hasL1&&(t=cs(t,oa(ds(this.l1,fs(e))))),this.hasL2&&(t=cs(t,oa(ds(this.l2,Ch(e))))),t.asScalar()})}getConfig(){return{l1:this.l1,l2:this.l2}}static fromConfig(e,t){return new e({l1:t.l1,l2:t.l2})}}af.className="L1L2",Kn(af);const of={l1l2:"L1L2"};function lf(e){return Ec(e)}function uf(e,t={}){return $c(e,qn.getMap().classNameMap,t,"regularizer")}function cf(e){if(null==e)return null;if("string"==typeof e){return uf({className:e in of?of[e]:e,config:{}})}return e instanceof rf?e:uf(e)}class hf extends gp{constructor(e){super(null==e?{}:e),this.supportsMasking=!0,null!=e&&(this.maxValue=e.maxValue)}call(e,t){e=ap(e);let n=mi(e);return null!=this.maxValue&&(n=nr(n,0,this.maxValue)),n}computeOutputShape(e){return e}getConfig(){const e={maxValue:this.maxValue},t=super.getConfig();return Object.assign(e,t),e}}hf.className="ReLU",Kn(hf);class pf extends gp{constructor(e){super(null==e?{}:e),this.DEFAULT_ALPHA=.3,null==e&&(e={}),this.alpha=null==e.alpha?this.DEFAULT_ALPHA:e.alpha}call(e,t){const n=ap(e);return jr(n,this.alpha)}computeOutputShape(e){return e}getConfig(){const e={alpha:this.alpha},t=super.getConfig();return Object.assign(e,t),e}}pf.className="LeakyReLU",Kn(pf);class df extends gp{constructor(e){if(super(null==e?{}:e),this.DEFAULT_ALPHA_INITIALIZER="zeros",null==e&&(e={}),this.supportsMasking=!0,this.alphaInitializer=Jh(e.alphaInitializer||this.DEFAULT_ALPHA_INITIALIZER),this.alphaRegularizer=cf(e.alphaRegularizer),this.alphaConstraint=jc(e.alphaConstraint),null==e.sharedAxes)this.sharedAxes=null;else if(Array.isArray(e.sharedAxes))this.sharedAxes=e.sharedAxes;else{if("number"!=typeof e.sharedAxes)throw new yc("Expected sharedAxes to be a number or an array of numbers, but got "+e.sharedAxes);this.sharedAxes=[e.sharedAxes]}}build(e){const t=(e=ip(e)).slice(1);if(null!=this.sharedAxes)for(const e of this.sharedAxes)t[e-1]=1;this.alpha=this.addWeight("alpha",t,"float32",this.alphaInitializer,this.alphaRegularizer,!0,this.alphaConstraint);const n={};if(null!=this.sharedAxes)for(let t=1;t<e.length;++t)n[t]=e[t];this.inputSpec=[new hp({ndim:e.length,axes:n})],this.built=!0}call(e,t){return e=ap(e),Ka(e,this.alpha.read())}getConfig(){const e={alphaInitializer:Yh(this.alphaInitializer),alphaRegularizer:lf(this.alphaRegularizer),alphaConstraint:Gc(this.alphaConstraint),sharedAxes:this.sharedAxes},t=super.getConfig();return Object.assign(e,t),e}}df.className="PReLU",Kn(df);class ff extends gp{constructor(e){if(super(null==e?{}:e),this.DEFAULT_ALPHA=1,null==e&&(e={}),null!=e.alpha&&e.alpha!==this.DEFAULT_ALPHA)throw new bc(`Non-default alpha value (${e.alpha}) is not supported by the ELU layer yet.`);this.alpha=null==e.alpha?this.DEFAULT_ALPHA:e.alpha}call(e,t){const n=ap(e);return Ar(n)}computeOutputShape(e){return e}getConfig(){const e={alpha:this.alpha},t=super.getConfig();return Object.assign(e,t),e}}ff.className="ELU",Kn(ff);class mf extends gp{constructor(e){super(null==e?{}:e),this.DEFAULT_THETA=1,null==e&&(e={}),this.theta=null==e.theta?this.DEFAULT_THETA:e.theta}call(e,t){const n=ap(e);return n.mul(fh(n.greater(this.theta),"float32"))}computeOutputShape(e){return e}getConfig(){const e={theta:this.theta},t=super.getConfig();return Object.assign(e,t),e}}mf.className="ThresholdedReLU",Kn(mf);class gf extends gp{constructor(e){super(null==e?{}:e),this.DEFAULT_AXIS=1,null==e&&(e={}),this.softmax=(new Jd).apply,this.axis=null==e.axis?this.DEFAULT_AXIS:e.axis}call(e,t){const n=ap(e);return this.softmax(n,this.axis)}computeOutputShape(e){return e}getConfig(){const e={axis:this.axis},t=super.getConfig();return Object.assign(e,t),e}}function yf(e,t,n){if("number"==typeof e)return wc(e,t);if(e.length!==t)throw new yc(`The ${n} argument must be an integer or tuple of ${t} integers. Received: ${e.length} elements.`);for(let r=0;r<t;++r){const a=e[r];if((s=a)!==parseInt(s.toString(),10))throw new yc(`The ${n} argument must be an integer or tuple of ${t} integers. Received: ${JSON.stringify(e)} including a non-integer number `+a)}return e;var s}function bf(e,t,n,s,r=1){if(null==e)return e;let a;return a="same"===n?e:e-(t+(t-1)*(r-1))+1,Math.floor((a+s-1)/s)}function xf(e,t,n,s){if(null==e)return null;if("valid"===s)e=e*t+ph([n-t,0]);else{if("same"!==s)throw new yc(`Unsupport padding mode: ${s}.`);e*=t}return e}function wf(e,t){return rs(()=>(eh(t),"channelsFirst"===t?gn(e,[0,2,3,1]):e))}function kf(e,t){return rs(()=>(eh(t),"channelsFirst"===t?gn(e,[0,2,3,4,1]):e))}function vf(e,t,n,s=1,r="valid",a,i=1){return rs(()=>{if(null==a&&(a="channelsLast"),eh(a),3!==e.shape.length)throw new yc("The input of a conv1dWithBias operation should be 3, but is "+e.shape.length+" instead.");if(3!==t.shape.length)throw new yc("The kernel for a conv1dWithBias operation should be 3, but is "+t.shape.length+" instead");if(null!=n&&1!==n.shape.length)throw new yc("The bias for a conv1dWithBias operation should be 1, but is "+t.shape.length+" instead");if("channelsFirst"===a&&(e=gn(e,[0,2,1])),"causal"===r)throw new bc("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");let o=lr(e,t,s,"same"===r?"same":"valid","NWC",i);return null!=n&&(o=Th(o,n)),o})}function Nf(e,t,n,s=[1,1],r="valid",a,i,o=null){return rs(()=>{if(null==a&&(a="channelsLast"),eh(a),3!==e.rank&&4!==e.rank)throw new yc(`conv2dWithBiasActivation expects input to be of rank 3 or 4, but received ${e.rank}.`);if(3!==t.rank&&4!==t.rank)throw new yc(`conv2dWithBiasActivation expects kernel to be of rank 3 or 4, but received ${e.rank}.`);let l=wf(e,a);if("causal"===r)throw new bc("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");return l=wo({x:l,filter:t,strides:s,pad:"same"===r?"same":"valid",dilations:i,dataFormat:"NHWC",bias:n,activation:o}),"channelsFirst"===a&&(l=gn(l,[0,3,1,2])),l})}function If(e,t,n,s=[1,1,1],r="valid",a,i){return rs(()=>{if(null==a&&(a="channelsLast"),eh(a),4!==e.rank&&5!==e.rank)throw new yc("conv3dWithBias expects input to be of rank 4 or 5, but received "+e.rank+".");if(4!==t.rank&&5!==t.rank)throw new yc("conv3dWithBias expects kernel to be of rank 4 or 5, but received "+e.rank+".");let o=kf(e,a);if("causal"===r)throw new bc("The support for CAUSAL padding mode in conv3dWithBias is not implemented yet.");return o=hr(o,t,s,"same"===r?"same":"valid","NDHWC",i),null!=n&&(o=Th(o,n)),"channelsFirst"===a&&(o=gn(o,[0,4,1,2,3])),o})}gf.className="Softmax",Kn(gf);class Cf extends gp{constructor(e,t){if(super(t),this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",Cf.verifyArgs(t),this.rank=e,Oc(this.rank,"rank"),1!==this.rank&&2!==this.rank&&3!==this.rank)throw new bc(`Convolution layer for rank other than 1, 2, or 3 (${this.rank}) is not implemented yet.`);if(this.kernelSize=yf(t.kernelSize,e,"kernelSize"),this.strides=yf(null==t.strides?1:t.strides,e,"strides"),this.padding=null==t.padding?"valid":t.padding,th(this.padding),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,eh(this.dataFormat),this.activation=nf(t.activation),this.useBias=null==t.useBias||t.useBias,this.biasInitializer=Jh(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.biasConstraint=jc(t.biasConstraint),this.biasRegularizer=cf(t.biasRegularizer),this.activityRegularizer=cf(t.activityRegularizer),this.dilationRate=yf(null==t.dilationRate?1:t.dilationRate,e,"dilationRate"),1===this.rank&&Array.isArray(this.dilationRate)&&1!==this.dilationRate.length)throw new yc("dilationRate must be a number or an array of a single number for 1D convolution, but received "+JSON.stringify(this.dilationRate));if(2===this.rank){if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate];else if(2!==this.dilationRate.length)throw new yc("dilationRate must be a number or array of two numbers for 2D convolution, but received "+JSON.stringify(this.dilationRate))}else if(3===this.rank)if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate,this.dilationRate];else if(3!==this.dilationRate.length)throw new yc("dilationRate must be a number or array of three numbers for 3D convolution, but received "+JSON.stringify(this.dilationRate))}static verifyArgs(e){if(kc("kernelSize"in e,"required key 'kernelSize' not in config"),"number"!=typeof e.kernelSize&&!_c(e.kernelSize,"number",1,3))throw new yc(`BaseConv expects config.kernelSize to be number or number[] with length 1, 2, or 3, but received ${JSON.stringify(e.kernelSize)}.`)}getConfig(){const e={kernelSize:this.kernelSize,strides:this.strides,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,activation:ef(this.activation),useBias:this.useBias,biasInitializer:Yh(this.biasInitializer),biasRegularizer:lf(this.biasRegularizer),activityRegularizer:lf(this.activityRegularizer),biasConstraint:Gc(this.biasConstraint)},t=super.getConfig();return Object.assign(e,t),e}}class Sf extends Cf{constructor(e,t){super(e,t),this.kernel=null,Sf.verifyArgs(t),this.filters=t.filters,Oc(this.filters,"filters"),this.kernelInitializer=Jh(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.kernelConstraint=jc(t.kernelConstraint),this.kernelRegularizer=cf(t.kernelRegularizer)}build(e){e=ip(e);const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new yc("The channel dimension of the input should be defined. Found "+e[t]);const n=e[t],s=this.kernelSize.concat([n,this.filters]);this.kernel=this.addWeight("kernel",s,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[{ndim:this.rank+2,axes:{[t]:n}}],this.built=!0}call(e,t){return rs(()=>{let t;e=ap(e);const n=null==this.bias?null:this.bias.read(),s=Mc(this.activation.getClassName());if(null!=s&&2===this.rank)t=Nf(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate,s);else{if(1===this.rank)t=vf(e,this.kernel.read(),n,this.strides[0],this.padding,this.dataFormat,this.dilationRate[0]);else if(2===this.rank)t=Nf(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate);else{if(3!==this.rank)throw new bc("convolutions greater than 3D are not implemented yet.");t=If(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate)}null!=this.activation&&(t=this.activation.apply(t))}return t})}computeOutputShape(e){e=ip(e);const t=[],n="channelsLast"===this.dataFormat?e.slice(1,e.length-1):e.slice(2);for(let e=0;e<n.length;++e){const s=bf(n[e],this.kernelSize[e],this.padding,this.strides[e],"number"==typeof this.dilationRate?this.dilationRate:this.dilationRate[e]);t.push(s)}let s=[e[0]];return"channelsLast"===this.dataFormat?(s=s.concat(t),s.push(this.filters)):(s.push(this.filters),s=s.concat(t)),s}getConfig(){const e={filters:this.filters,kernelInitializer:Yh(this.kernelInitializer),kernelRegularizer:lf(this.kernelRegularizer),kernelConstraint:Gc(this.kernelConstraint)},t=super.getConfig();return Object.assign(e,t),e}static verifyArgs(e){if(!("filters"in e)||"number"!=typeof e.filters||e.filters<1)throw new yc("Convolution layer expected config.filters to be a 'number' > 0 but got "+JSON.stringify(e.filters))}}class Tf extends Sf{constructor(e){super(2,e),Tf.verifyArgs(e)}getConfig(){const e=super.getConfig();return delete e.rank,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&!_c(e.kernelSize,"number",1,2))throw new yc(`Conv2D expects config.kernelSize to be number or number[] with length 1 or 2, but received ${JSON.stringify(e.kernelSize)}.`)}}Tf.className="Conv2D",Kn(Tf);class Ef extends Sf{constructor(e){super(3,e),Ef.verifyArgs(e)}getConfig(){const e=super.getConfig();return delete e.rank,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&(!Array.isArray(e.kernelSize)||1!==e.kernelSize.length&&3!==e.kernelSize.length))throw new yc(`Conv3D expects config.kernelSize to be number or [number, number, number], but received ${JSON.stringify(e.kernelSize)}.`)}}Ef.className="Conv3D",Kn(Ef);class $f extends Tf{constructor(e){if(super(e),this.inputSpec=[new hp({ndim:4})],"same"!==this.padding&&"valid"!==this.padding)throw new yc("Conv2DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode "+this.padding)}build(e){if(4!==(e=ip(e)).length)throw new yc("Input should have rank 4; Received input shape: "+JSON.stringify(e));const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new yc("The channel dimension of the inputs should be defined. Found `None`.");const n=e[t],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new hp({ndim:4,axes:{[t]:n}})],this.built=!0}call(e,t){return rs(()=>{let t=ap(e);if(4!==t.shape.length)throw new yc("Conv2DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-"+t.shape.length);const n=t.shape,s=n[0];let r,a;"channelsFirst"===this.dataFormat?(r=2,a=3):(r=1,a=2);const i=n[r],o=n[a],l=this.kernelSize[0],u=this.kernelSize[1],c=this.strides[0],h=this.strides[1],p=[s,xf(i,c,l,this.padding),xf(o,h,u,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(t=gn(t,[0,2,3,1]));let d=cr(t,this.kernel.read(),p,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(d=gn(d,[0,3,1,2])),null!=this.bias&&(d=Th(d,this.bias.read(),this.dataFormat)),null!=this.activation&&(d=this.activation.apply(d)),d})}computeOutputShape(e){const t=(e=ip(e)).slice();let n,s,r;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3):(n=3,s=1,r=2);const a=this.kernelSize[0],i=this.kernelSize[1],o=this.strides[0],l=this.strides[1];return t[n]=this.filters,t[s]=xf(t[s],o,a,this.padding),t[r]=xf(t[r],l,i,this.padding),t}getConfig(){const e=super.getConfig();return delete e.dilationRate,e}}$f.className="Conv2DTranspose",Kn($f);class Af extends Sf{constructor(e,t){if(super(e,t),this.DEFAULT_DEPTHWISE_INITIALIZER="glorotUniform",this.DEFAULT_POINTWISE_INITIALIZER="glorotUniform",this.depthwiseKernel=null,this.pointwiseKernel=null,null==t.filters)throw new yc("The `filters` configuration field is required by SeparableConv, but is unspecified.");if(null!=t.kernelInitializer||null!=t.kernelRegularizer||null!=t.kernelConstraint)throw new yc("Fields kernelInitializer, kernelRegularizer and kernelConstraint are invalid for SeparableConv2D. Use depthwiseInitializer, depthwiseRegularizer, depthwiseConstraint, pointwiseInitializer, pointwiseRegularizer and pointwiseConstraint instead.");if(null!=t.padding&&"same"!==t.padding&&"valid"!==t.padding)throw new yc(`SeparableConv${this.rank}D supports only padding modes: 'same' and 'valid', but received `+JSON.stringify(t.padding));this.depthMultiplier=null==t.depthMultiplier?1:t.depthMultiplier,this.depthwiseInitializer=Jh(t.depthwiseInitializer||this.DEFAULT_DEPTHWISE_INITIALIZER),this.depthwiseRegularizer=cf(t.depthwiseRegularizer),this.depthwiseConstraint=jc(t.depthwiseConstraint),this.pointwiseInitializer=Jh(t.depthwiseInitializer||this.DEFAULT_POINTWISE_INITIALIZER),this.pointwiseRegularizer=cf(t.pointwiseRegularizer),this.pointwiseConstraint=jc(t.pointwiseConstraint)}build(e){if((e=ip(e)).length<this.rank+2)throw new yc(`Inputs to SeparableConv${this.rank}D should have rank `+(this.rank+2)+", but received input shape: "+JSON.stringify(e));const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t]||e[t]<0)throw new yc("The channel dimension of the inputs should be defined, but found "+JSON.stringify(e[t]));const n=e[t],s=this.kernelSize.concat([n,this.depthMultiplier]),r=[];for(let e=0;e<this.rank;++e)r.push(1);r.push(n*this.depthMultiplier,this.filters);this.depthwiseKernel=this.addWeight("depthwise_kernel",s,"float32",this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.pointwiseKernel=this.addWeight("pointwise_kernel",r,"float32",this.pointwiseInitializer,this.pointwiseRegularizer,!0,this.pointwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.inputSpec=[new hp({ndim:this.rank+2,axes:{[t]:n}})],this.built=!0}call(e,t){return rs(()=>{let t;if(e=ap(e),1===this.rank)throw new bc("1D separable convolution is not implemented yet.");return 2===this.rank&&("channelsFirst"===this.dataFormat&&(e=gn(e,[0,2,3,1])),t=Si(e,this.depthwiseKernel.read(),this.pointwiseKernel.read(),this.strides,this.padding,this.dilationRate,"NHWC")),this.useBias&&(t=Th(t,this.bias.read(),this.dataFormat)),null!=this.activation&&(t=this.activation.apply(t)),"channelsFirst"===this.dataFormat&&(t=gn(t,[0,3,1,2])),t})}getConfig(){const e=super.getConfig();return delete e.rank,delete e.kernelInitializer,delete e.kernelRegularizer,delete e.kernelConstraint,e.depthwiseInitializer=Yh(this.depthwiseInitializer),e.pointwiseInitializer=Yh(this.pointwiseInitializer),e.depthwiseRegularizer=lf(this.depthwiseRegularizer),e.pointwiseRegularizer=lf(this.pointwiseRegularizer),e.depthwiseConstraint=Gc(this.depthwiseConstraint),e.pointwiseConstraint=Gc(this.pointwiseConstraint),e}}Af.className="SeparableConv";class Rf extends Af{constructor(e){super(2,e)}}Rf.className="SeparableConv2D",Kn(Rf);class Ff extends Sf{constructor(e){super(1,e),Ff.verifyArgs(e),this.inputSpec=[{ndim:3}]}getConfig(){const e=super.getConfig();return delete e.rank,delete e.dataFormat,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&!_c(e.kernelSize,"number",1,1))throw new yc(`Conv1D expects config.kernelSize to be number or number[] with length 1, but received ${JSON.stringify(e.kernelSize)}.`)}}Ff.className="Conv1D",Kn(Ff);class Df extends gp{constructor(e){super(e),"number"==typeof e.cropping?this.cropping=[[e.cropping,e.cropping],[e.cropping,e.cropping]]:"number"==typeof e.cropping[0]?this.cropping=[[e.cropping[0],e.cropping[0]],[e.cropping[1],e.cropping[1]]]:this.cropping=e.cropping,this.dataFormat=void 0===e.dataFormat?"channelsLast":e.dataFormat,this.inputSpec=[{ndim:4}]}computeOutputShape(e){return"channelsFirst"===this.dataFormat?[e[0],e[1],e[2]-this.cropping[0][0]-this.cropping[0][1],e[3]-this.cropping[1][0]-this.cropping[1][1]]:[e[0],e[1]-this.cropping[0][0]-this.cropping[0][1],e[2]-this.cropping[1][0]-this.cropping[1][1],e[3]]}call(e,t){return rs(()=>{if(e=ap(e),"channelsLast"===this.dataFormat){const t=bh(e,this.cropping[0][0],e.shape[1]-this.cropping[0][0]-this.cropping[0][1],2);return bh(t,this.cropping[1][0],e.shape[2]-this.cropping[1][1]-this.cropping[1][0],3)}{const t=bh(e,this.cropping[0][0],e.shape[2]-this.cropping[0][0]-this.cropping[0][1],3);return bh(t,this.cropping[1][0],e.shape[3]-this.cropping[1][1]-this.cropping[1][0],4)}})}getConfig(){const e={cropping:this.cropping,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}Df.className="Cropping2D",Kn(Df);class _f extends gp{constructor(e){var t;super(e),this.DEFAULT_SIZE=[2,2],this.inputSpec=[{ndim:4}],this.size=null==e.size?this.DEFAULT_SIZE:e.size,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,eh(this.dataFormat),this.interpolation=null==e.interpolation?"nearest":e.interpolation,t=this.interpolation,Dc(Xc,"InterpolationFormat",t)}computeOutputShape(e){if("channelsFirst"===this.dataFormat){const t=null==e[2]?null:this.size[0]*e[2],n=null==e[3]?null:this.size[1]*e[3];return[e[0],e[1],t,n]}{const t=null==e[1]?null:this.size[0]*e[1],n=null==e[2]?null:this.size[1]*e[2];return[e[0],t,n,e[3]]}}call(e,t){return rs(()=>{let t=ap(e);const n=t.shape;if("channelsFirst"===this.dataFormat){t=gn(t,[0,2,3,1]);const e=this.size[0]*n[2],s=this.size[1]*n[3],r="nearest"===this.interpolation?t.resizeNearestNeighbor([e,s]):t.resizeBilinear([e,s]);return gn(r,[0,3,1,2])}{const e=this.size[0]*n[1],s=this.size[1]*n[2];return"nearest"===this.interpolation?t.resizeNearestNeighbor([e,s]):t.resizeBilinear([e,s])}})}getConfig(){const e={size:this.size,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}_f.className="UpSampling2D",Kn(_f);class Of extends Cf{constructor(e){super(2,e),this.depthwiseKernel=null,this.depthMultiplier=null==e.depthMultiplier?1:e.depthMultiplier,this.depthwiseInitializer=Jh(e.depthwiseInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.depthwiseConstraint=jc(e.depthwiseConstraint),this.depthwiseRegularizer=cf(e.depthwiseRegularizer)}build(e){if((e=ip(e)).length<4)throw new yc(`Inputs to DepthwiseConv2D should have rank 4. Received input shape: ${JSON.stringify(e)}.`);const t="channelsFirst"===this.dataFormat?1:3;if(null==e[t]||e[t]<0)throw new yc(`The channel dimension of the inputs to DepthwiseConv2D should be defined, but is not (${e[t]}).`);const n=e[t],s=[this.kernelSize[0],this.kernelSize[1],n,this.depthMultiplier];this.depthwiseKernel=this.addWeight("depthwise_kernel",s,null,this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[n*this.depthMultiplier],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return rs(()=>{let t=function(e,t,n=[1,1],s="valid",r,a){return rs(()=>{null==r&&(r="channelsLast"),eh(r);let i=wf(e,r);if(4!==e.rank)throw new yc("Input for depthwiseConv2d is required to be 4-D, but is instead "+e.rank+"-D");if(4!==t.rank)throw new yc("depthwiseKernel is required to be 4-D, but is instead "+t.rank+"-D");return i=xr(i,t,n,"same"===s?"same":"valid","NHWC",a),"channelsFirst"===r&&(i=gn(i,[0,3,1,2])),i})}(e=ap(e),this.depthwiseKernel.read(),this.strides,this.padding,this.dataFormat,null);return this.useBias&&(t=Th(t,this.bias.read(),this.dataFormat)),null!=this.activation&&(t=this.activation.apply(t)),t})}computeOutputShape(e){e=ip(e);const t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2],s="channelsFirst"===this.dataFormat?e[1]*this.depthMultiplier:e[3]*this.depthMultiplier,r=bf(t,this.kernelSize[0],this.padding,this.strides[0]),a=bf(n,this.kernelSize[1],this.padding,this.strides[1]);return"channelsFirst"===this.dataFormat?[e[0],s,r,a]:[e[0],r,a,s]}getConfig(){const e=super.getConfig();return e.depthMultiplier=this.depthMultiplier,e.depthwiseInitializer=Yh(this.depthwiseInitializer),e.depthwiseRegularizer=lf(this.depthwiseRegularizer),e.depthwiseConstraint=Gc(this.depthwiseRegularizer),e}}function Mf(e,t,n,s){if(Array.isArray(e)){if(null!=t||null!=n)throw new yc("When inputs is an array, neither initialState or constants should be provided");null!=s&&(n=e.slice(e.length-s,e.length),e=e.slice(0,e.length-s)),e.length>1&&(t=e.slice(1,e.length)),e=e[0]}function r(e){return null==e||Array.isArray(e)?e:[e]}return{inputs:e,initialState:t=r(t),constants:n=r(n)}}function Lf(e,t,n,s=!1,r,a,i=!1,o=!1){return rs(()=>{const l=t.shape.length;if(l<3)throw new yc(`Input should be at least 3D, but is ${l}D.`);const u=[1,0].concat(dh(2,l));if(t=gn(t,u),null!=a)throw new bc("The rnn() functoin of the deeplearn.js backend does not support constants yet.");i&&console.warn("Backend rnn(): the unroll = true option is not applicable to the imperative deeplearn.js backend."),null!=r&&((r=r.asType("bool").asType("float32")).rank===l-1&&(r=Dr(r,-1)),r=gn(r,u)),s&&(t=yi(t,0),null!=r&&(r=yi(r,0)));const c=[];let h,p=n;const d=t.shape[0],f=eo(t);let m,g;null!=r&&(m=eo(r));for(let t=0;t<d;++t){const n=f[t],s=rs(()=>e(n,p));if(null==r)h=s[0],p=s[1];else{const e=rs(()=>{const e=m[t],n=za(e).sub(e);return{output:s[0].mul(e).add(p[0].mul(n)),newStates:p.map((t,r)=>s[1][r].mul(e).add(t.mul(n)))}});h=e.output,p=e.newStates}o&&c.push(h)}if(o){g=Gi(c,1)}return[h,g,p]})}Of.className="DepthwiseConv2D",Kn(Of);class zf extends gp{constructor(e){let t;if(super(e),null==e.cell)throw new yc("cell property is missing for the constructor of RNN.");if(t=Array.isArray(e.cell)?new jf({cells:e.cell}):e.cell,null==t.stateSize)throw new yc("The RNN cell should have an attribute `stateSize` (tuple of integers, one integer per RNN state).");this.cell=t,this.returnSequences=null!=e.returnSequences&&e.returnSequences,this.returnState=null!=e.returnState&&e.returnState,this.goBackwards=null!=e.goBackwards&&e.goBackwards,this._stateful=null!=e.stateful&&e.stateful,this.unroll=null!=e.unroll&&e.unroll,this.supportsMasking=!0,this.inputSpec=[new hp({ndim:3})],this.stateSpec=null,this.states_=null,this.numConstants=null,this.keptStates=[]}getStates(){if(null==this.states_){return dh(0,Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1).map(e=>null)}return this.states_}setStates(e){this.states_=e}computeOutputShape(e){sp(e)&&(e=e[0]),e=e;let t=this.cell.stateSize;Array.isArray(t)||(t=[t]);const n=t[0];let s;if(s=this.returnSequences?[e[0],e[1],n]:[e[0],n],this.returnState){const n=[];for(const s of t)n.push([e[0],s]);return[s].concat(n)}return s}computeMask(e,t){return rs(()=>{Array.isArray(t)&&(t=t[0]);const e=this.returnSequences?t:null;if(this.returnState){const t=this.states.map(e=>null);return[e].concat(t)}return e})}get states(){if(null==this.states_){const e=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1,t=[];for(let n=0;n<e;++n)t.push(null);return t}return this.states_}set states(e){this.states_=e}build(e){if(null!=this.numConstants)throw new bc("Constants support is not implemented in RNN yet.");sp(e)&&(e=e[0]),e=e;const t=this.stateful?e[0]:null,n=e.slice(2);this.inputSpec[0]=new hp({shape:[t,null,...n]});const s=[e[0]].concat(e.slice(2));let r;if(this.cell.build(s),r=Array.isArray(this.cell.stateSize)?this.cell.stateSize:[this.cell.stateSize],null!=this.stateSpec){if(!d(this.stateSpec.map(e=>e.shape[e.shape.length-1]),r))throw new yc(`An initialState was passed that is not compatible with cell.stateSize. Received stateSpec=${this.stateSpec}; However cell.stateSize is `+this.cell.stateSize)}else this.stateSpec=r.map(e=>new hp({shape:[null,e]}));this.stateful&&this.resetStates()}resetStates(e,t=!1){rs(()=>{if(!this.stateful)throw new mc("Cannot call resetStates() on an RNN Layer that is not stateful.");const n=this.inputSpec[0].shape[0];if(null==n)throw new yc("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.states_)Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(e=>Ma([n,e])):this.states_=[Ma([n,this.cell.stateSize])];else if(null==e)as(this.states_),null!=this.keptStates&&(as(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(e=>Ma([n,e])):this.states_[0]=Ma([n,this.cell.stateSize]);else{if(Array.isArray(e)||(e=[e]),e.length!==this.states_.length)throw new yc(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${e.length} state value(s). Input received: `+e);!0===t?this.keptStates.push(this.states_.slice()):as(this.states_);for(let t=0;t<this.states_.length;++t){const s=e[t],r=Array.isArray(this.cell.stateSize)?this.cell.stateSize[t]:this.cell.stateSize,a=[n,r];if(!d(s.shape,a))throw new yc(`State ${t} is incompatible with layer ${this.name}: expected shape=${a}, received shape=${s.shape}`);this.states_[t]=s}}this.states_=this.states_.map(e=>is(e.clone()))})}apply(e,t){let n=null==t?null:t.initialState,s=null==t?null:t.constants;null==t&&(t={});const r=Mf(e,n,s,this.numConstants);e=r.inputs,n=r.initialState,s=r.constants;let a=[],i=[];if(null!=n){t.initialState=n,a=a.concat(n),this.stateSpec=[];for(const e of n)this.stateSpec.push(new hp({shape:e.shape}));i=i.concat(this.stateSpec)}if(null!=s&&(t.constants=s,a=a.concat(s),this.numConstants=s.length),a[0]instanceof pp){const n=[e].concat(a),s=this.inputSpec.concat(i),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,t);return this.inputSpec=r,o}return super.apply(e,t)}call(e,t){return rs(()=>{const n=null==t?null:t.mask,s=null==t?null:t.training;let r=null==t?null:t.initialState;e=ap(e),null==r&&(r=this.stateful?this.states_:this.getInitialState(e));const a=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1;if(r.length!==a)throw new yc(`RNN Layer has ${a} state(s) but was passed `+r.length+" initial state(s).");this.unroll&&console.warn("Ignoring unroll = true for RNN layer, due to imperative backend.");const i={training:s},o=Lf((e,t)=>{const n=this.cell.call([e].concat(t),i);return[n[0],n.slice(1)]},e,r,this.goBackwards,n,null,this.unroll,this.returnSequences),l=o[0],u=o[1],c=o[2];this.stateful&&this.resetStates(c,s);const h=this.returnSequences?u:l;return this.returnState?[h].concat(c):h})}getInitialState(e){return rs(()=>{let t=Ma(e.shape);return t=oa(t,[1,2]),t=mh(t),Array.isArray(this.cell.stateSize)?this.cell.stateSize.map(e=>e>1?kh(t,[1,e]):t):this.cell.stateSize>1?[kh(t,[1,this.cell.stateSize])]:[t]})}get trainableWeights(){return this.trainable?this.cell.trainableWeights:[]}get nonTrainableWeights(){return this.trainable?this.cell.nonTrainableWeights:this.cell.weights}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.cell&&this.cell.setFastWeightInitDuringBuild(e)}getConfig(){const e=super.getConfig(),t={returnSequences:this.returnSequences,returnState:this.returnState,goBackwards:this.goBackwards,stateful:this.stateful,unroll:this.unroll};null!=this.numConstants&&(t.numConstants=this.numConstants);const n=this.cell.getConfig();return this.getClassName()===zf.className&&(t.cell={className:this.cell.getClassName(),config:n}),Object.assign({},n,e,t)}static fromConfig(e,t,n={}){const s=Ap(t.cell,n);return new e(Object.assign(t,{cell:s}))}}zf.className="RNN",Kn(zf);class Bf extends gp{}class Pf extends Bf{constructor(e){super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=e.units,Oc(this.units,"units"),this.activation=nf(null==e.activation?this.DEFAULT_ACTIVATION:e.activation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=Jh(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Jh(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Jh(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=cf(e.kernelRegularizer),this.recurrentRegularizer=cf(e.recurrentRegularizer),this.biasRegularizer=cf(e.biasRegularizer),this.kernelConstraint=jc(e.kernelConstraint),this.recurrentConstraint=jc(e.recurrentConstraint),this.biasConstraint=jc(e.biasConstraint),this.dropout=hh([1,ph([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=hh([1,ph([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){e=ip(e),this.kernel=this.addWeight("kernel",[e[e.length-1],this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return rs(()=>{if(2!==(e=e).length)throw new yc(`SimpleRNNCell expects 2 input Tensors, got ${e.length}.`);let n=e[1];e=e[0];const s=null!=t.training&&t.training;let r;0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=qf({ones:()=>za(e),rate:this.dropout,training:s})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=qf({ones:()=>za(n),rate:this.recurrentDropout,training:s}));const a=this.dropoutMask,i=this.recurrentDropoutMask;r=Nh(null!=a?ds(e,a):e,this.kernel.read()),null!=this.bias&&(r=Th(r,this.bias.read())),null!=i&&(n=ds(n,i));let o=cs(r,Nh(n,this.recurrentKernel.read()));return null!=this.activation&&(o=this.activation.apply(o)),[o,o]})}getConfig(){const e=super.getConfig(),t={units:this.units,activation:ef(this.activation),useBias:this.useBias,kernelInitializer:Yh(this.kernelInitializer),recurrentInitializer:Yh(this.recurrentInitializer),biasInitializer:Yh(this.biasInitializer),kernelRegularizer:lf(this.kernelRegularizer),recurrentRegularizer:lf(this.recurrentRegularizer),biasRegularizer:lf(this.biasRegularizer),activityRegularizer:lf(this.activityRegularizer),kernelConstraint:Gc(this.kernelConstraint),recurrentConstraint:Gc(this.recurrentConstraint),biasConstraint:Gc(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout};return Object.assign({},e,t)}}Pf.className="SimpleRNNCell",Kn(Pf);class Wf extends zf{constructor(e){e.cell=new Pf(e),super(e)}call(e,t){return rs(()=>{null!=this.cell.dropoutMask&&(as(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(as(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})})}static fromConfig(e,t){return new e(t)}}Wf.className="SimpleRNN",Kn(Wf);class Vf extends Bf{constructor(e){if(super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",e.resetAfter)throw new yc("GRUCell does not support reset_after parameter set to true.");this.units=e.units,Oc(this.units,"units"),this.activation=nf(void 0===e.activation?this.DEFAULT_ACTIVATION:e.activation),this.recurrentActivation=nf(void 0===e.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:e.recurrentActivation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=Jh(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Jh(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Jh(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=cf(e.kernelRegularizer),this.recurrentRegularizer=cf(e.recurrentRegularizer),this.biasRegularizer=cf(e.biasRegularizer),this.kernelConstraint=jc(e.kernelConstraint),this.recurrentConstraint=jc(e.recurrentConstraint),this.biasConstraint=jc(e.biasConstraint),this.dropout=hh([1,ph([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=hh([1,ph([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.implementation=e.implementation,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){const t=(e=ip(e))[e.length-1];this.kernel=this.addWeight("kernel",[t,3*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,3*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[3*this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return rs(()=>{if(2!==(e=e).length)throw new yc("GRUCell expects 2 input Tensors (inputs, h, c), got "+e.length+".");const n=null!=t.training&&t.training;let s=e[1];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=qf({ones:()=>za(e),rate:this.dropout,training:n,count:3})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=qf({ones:()=>za(s),rate:this.recurrentDropout,training:n,count:3}));const r=this.dropoutMask,a=this.recurrentDropoutMask;let i,o,l;0<this.dropout&&this.dropout<1&&(e=ds(e,r[0]));let u=Nh(e,this.kernel.read());this.useBias&&(u=Th(u,this.bias.read())),0<this.recurrentDropout&&this.recurrentDropout<1&&(s=ds(s,a[0]));const c=this.recurrentKernel.read(),[h,p]=Bi(c,[2*this.units,this.units],c.rank-1),d=Nh(s,h),[f,m,g]=Bi(u,3,u.rank-1),[y,b]=Bi(d,2,d.rank-1);i=this.recurrentActivation.apply(cs(f,y)),o=this.recurrentActivation.apply(cs(m,b));const x=Nh(ds(o,s),p);l=this.activation.apply(cs(g,x));const w=cs(ds(i,s),ds(cs(1,na(i)),l));return[w,w]})}getConfig(){const e=super.getConfig(),t={units:this.units,activation:ef(this.activation),recurrentActivation:ef(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Yh(this.kernelInitializer),recurrentInitializer:Yh(this.recurrentInitializer),biasInitializer:Yh(this.biasInitializer),kernelRegularizer:lf(this.kernelRegularizer),recurrentRegularizer:lf(this.recurrentRegularizer),biasRegularizer:lf(this.biasRegularizer),activityRegularizer:lf(this.activityRegularizer),kernelConstraint:Gc(this.kernelConstraint),recurrentConstraint:Gc(this.recurrentConstraint),biasConstraint:Gc(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation,resetAfter:!1};return Object.assign({},e,t)}}Vf.className="GRUCell",Kn(Vf);class Uf extends zf{constructor(e){0===e.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),e.cell=new Vf(e),super(e)}call(e,t){return rs(()=>{null!=this.cell.dropoutMask&&(as(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(as(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})})}static fromConfig(e,t){return 0===t.implmentation&&(t.implementation=1),new e(t)}}Uf.className="GRU",Kn(Uf);class Gf extends Bf{constructor(e){super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=e.units,Oc(this.units,"units"),this.activation=nf(void 0===e.activation?this.DEFAULT_ACTIVATION:e.activation),this.recurrentActivation=nf(void 0===e.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:e.recurrentActivation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=Jh(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Jh(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Jh(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.unitForgetBias=e.unitForgetBias,this.kernelRegularizer=cf(e.kernelRegularizer),this.recurrentRegularizer=cf(e.recurrentRegularizer),this.biasRegularizer=cf(e.biasRegularizer),this.kernelConstraint=jc(e.kernelConstraint),this.recurrentConstraint=jc(e.recurrentConstraint),this.biasConstraint=jc(e.biasConstraint),this.dropout=hh([1,ph([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=hh([1,ph([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.implementation=e.implementation,this.stateSize=[this.units,this.units],this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){var t;const n=(e=ip(e))[e.length-1];let s;if(this.kernel=this.addWeight("kernel",[n,4*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,4*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){if(this.unitForgetBias){const e=this.biasInitializer,n=this.units;s=new((t=class extends Fh{apply(t,s){const r=e.apply([n]),a=(new _h).apply([n]),i=e.apply([2*n]);return wh(wh(r,a),i)}}).className="CustomInit",t)}else s=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.units],null,s,this.biasRegularizer,!0,this.biasConstraint)}else this.bias=null;this.built=!0}call(e,t){return rs(()=>{const n=null!=t.training&&t.training;if(3!==(e=e).length)throw new yc("LSTMCell expects 3 input Tensors (inputs, h, c), got "+e.length+".");let s=e[1];const r=e[2];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=qf({ones:()=>za(e),rate:this.dropout,training:n,count:4})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=qf({ones:()=>za(s),rate:this.recurrentDropout,training:n,count:4}));const a=this.dropoutMask,i=this.recurrentDropoutMask;let o,l,u,c;0<this.dropout&&this.dropout<1&&(e=ds(e,a[0]));let h=Nh(e,this.kernel.read());0<this.recurrentDropout&&this.recurrentDropout<1&&(s=ds(s,i[0])),h=cs(h,Nh(s,this.recurrentKernel.read())),this.useBias&&(h=Th(h,this.bias.read()));const[p,d,f,m]=Bi(h,4,h.rank-1);o=this.recurrentActivation.apply(p),l=this.recurrentActivation.apply(d),u=cs(ds(l,r),ds(o,this.activation.apply(f))),c=this.recurrentActivation.apply(m);const g=ds(c,this.activation.apply(u));return[g,g,u]})}getConfig(){const e=super.getConfig(),t={units:this.units,activation:ef(this.activation),recurrentActivation:ef(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Yh(this.kernelInitializer),recurrentInitializer:Yh(this.recurrentInitializer),biasInitializer:Yh(this.biasInitializer),unitForgetBias:this.unitForgetBias,kernelRegularizer:lf(this.kernelRegularizer),recurrentRegularizer:lf(this.recurrentRegularizer),biasRegularizer:lf(this.biasRegularizer),activityRegularizer:lf(this.activityRegularizer),kernelConstraint:Gc(this.kernelConstraint),recurrentConstraint:Gc(this.recurrentConstraint),biasConstraint:Gc(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation};return Object.assign({},e,t)}}Gf.className="LSTMCell",Kn(Gf);class Hf extends zf{constructor(e){0===e.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),e.cell=new Gf(e),super(e)}call(e,t){return rs(()=>{null!=this.cell.dropoutMask&&(as(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(as(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})})}static fromConfig(e,t){return 0===t.implmentation&&(t.implementation=1),new e(t)}}Hf.className="LSTM",Kn(Hf);class jf extends Bf{constructor(e){super(e),this.cells=e.cells}get stateSize(){const e=[];for(const t of this.cells.slice().reverse())Array.isArray(t.stateSize)?e.push(...t.stateSize):e.push(t.stateSize);return e}call(e,t){return rs(()=>{let n=(e=e).slice(1);const s=[];for(const e of this.cells.slice().reverse())Array.isArray(e.stateSize)?s.push(n.splice(0,e.stateSize.length)):s.push(n.splice(0,1));s.reverse();const r=[];let a;for(let i=0;i<this.cells.length;++i){const o=this.cells[i];n=s[i],a=0===i?[e[0]].concat(n):[a[0]].concat(n),a=o.call(a,t),r.push(a.slice(1))}n=[];for(const e of r.slice().reverse())n.push(...e);return[a[0]].concat(n)})}build(e){let t;sp(e)&&(e=e[0]),e=e,this.cells.forEach((n,s)=>{rh("RNNCell_"+s,()=>{n.build(e),t=Array.isArray(n.stateSize)?n.stateSize[0]:n.stateSize,e=[e[0],t]})}),this.built=!0}getConfig(){const e=super.getConfig(),t={cells:this.cells.map(e=>({className:e.getClassName(),config:e.getConfig()}))};return Object.assign({},e,t)}static fromConfig(e,t,n={}){const s=[];for(const e of t.cells)s.push(Ap(e,n));return new e({cells:s})}get trainableWeights(){if(!this.trainable)return[];const e=[];for(const t of this.cells)e.push(...t.trainableWeights);return e}get nonTrainableWeights(){const e=[];for(const t of this.cells)e.push(...t.nonTrainableWeights);if(!this.trainable){const t=[];for(const e of this.cells)t.push(...e.trainableWeights);return t.concat(e)}return e}getWeights(){const e=[];for(const t of this.cells)e.push(...t.weights);return up(e)}setWeights(e){const t=[];for(const n of this.cells){const s=n.weights.length,r=e.splice(s);for(let e=0;e<n.weights.length;++e)t.push([n.weights[e],r[e]])}cp(t)}}function qf(e){const{ones:t,rate:n,training:s=!1,count:r=1}=e,a=()=>Eh(t(),n),i=()=>$h(a,t,s);return!r||r<=1?is(i().clone()):Array(r).fill(void 0).map(i).map(e=>is(e.clone()))}jf.className="StackedRNNCells",Kn(jf);var Kf=function(e,t){var n={};for(var s in e)Object.prototype.hasOwnProperty.call(e,s)&&t.indexOf(s)<0&&(n[s]=e[s]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var r=0;for(s=Object.getOwnPropertySymbols(e);r<s.length;r++)t.indexOf(s[r])<0&&Object.prototype.propertyIsEnumerable.call(e,s[r])&&(n[s[r]]=e[s[r]])}return n};class Xf extends zf{constructor(e){if(e.unroll)throw new bc("Unrolling is not possible with convolutional RNNs.");if(Array.isArray(e.cell))throw new bc("It is not possible at the moment to stack convolutional cells.");super(e),this.inputSpec=[new hp({ndim:5})]}call(e,t){return rs(()=>{if(null!=this.cell.dropoutMask&&(as(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(as(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null),t&&t.constants)throw new yc("ConvRNN2D cell does not support constants");const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})})}computeOutputShape(e){let t=this.computeSingleOutputShape(e);return this.returnSequences||(t=[t[0],...t.slice(2)]),this.returnState&&(t=[t,...Array(2).fill([e[0],...t.slice(-3)])]),t}getInitialState(e){return rs(()=>{const{stateSize:t}=this.cell,n=e.shape,s=this.computeSingleOutputShape(n),r=Ma([s[0],...s.slice(2)]);return Array.isArray(t)?Array(t.length).fill(r):[r]})}resetStates(e,t=!1){rs(()=>{if(!this.stateful)throw new mc("Cannot call resetStates() on an RNN Layer that is not stateful.");const n=this.inputSpec[0].shape,s=this.computeSingleOutputShape(n),r=[s[0],...s.slice(2)];if(null==n[0])throw new yc("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.getStates())Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(()=>Ma(r)):this.states_=[Ma(r)];else if(null==e)as(this.states_),null!=this.keptStates&&(as(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(()=>Ma(r)):this.states_[0]=Ma(r);else{if(Array.isArray(e)||(e=[e]),e.length!==this.states_.length)throw new yc(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${e.length} state value(s). Input received: `+e);t?this.keptStates.push(this.states_.slice()):as(this.states_);for(let t=0;t<this.states_.length;++t){const n=e[t],s=r;if(!d(n.shape,s))throw new yc(`State ${t} is incompatible with layer ${this.name}: expected shape=${s}, received shape=${n.shape}`);this.states_[t]=n}}this.states_=this.states_.map(e=>is(e.clone()))})}computeSingleOutputShape(e){const{dataFormat:t,filters:n,kernelSize:s,padding:r,strides:a,dilationRate:i}=this.cell,o="channelsFirst"===t,l=e[o?3:2],u=e[o?4:3],c=bf(l,s[0],r,a[0],i[0]),h=bf(u,s[1],r,a[1],i[1]);return[...e.slice(0,2),...o?[n,c,h]:[c,h,n]]}}Xf.className="ConvRNN2D";class Yf extends Gf{constructor(e){const{filters:t,kernelSize:n,strides:s,padding:r,dataFormat:a,dilationRate:i}=e;super(Object.assign({},e,{units:t})),this.filters=t,Oc(this.filters,"filters"),this.kernelSize=yf(n,2,"kernelSize"),this.kernelSize.forEach(e=>Oc(e,"kernelSize")),this.strides=yf(s||1,2,"strides"),this.strides.forEach(e=>Oc(e,"strides")),this.padding=r||"valid",th(this.padding),this.dataFormat=a||"channelsLast",eh(this.dataFormat),this.dilationRate=yf(i||1,2,"dilationRate"),this.dilationRate.forEach(e=>Oc(e,"dilationRate"))}build(e){var t;e=ip(e);const n="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[n])throw new yc("The channel dimension of the input should be defined. Found "+e[n]);const s=e[n],r=this.kernelSize.concat([s,4*this.filters]);this.kernel=this.addWeight("kernel",r,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint);const a=this.kernelSize.concat([this.filters,4*this.filters]);if(this.recurrentKernel=this.addWeight("recurrent_kernel",a,null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){let e;if(this.unitForgetBias){const n=this.biasInitializer,s=this.filters;e=new((t=class extends Fh{apply(e,t){return xh([n.apply([s]),La([s]),n.apply([2*s])])}}).className="CustomInit",t)}else e=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.filters],null,e,this.biasRegularizer,!0,this.biasConstraint)}this.built=!0}call(e,t){return rs(()=>{if(3!==e.length)throw new yc("ConvLSTM2DCell expects 3 input Tensors (inputs, h, c), got "+e.length+".");const n=t.training||!1,s=e[0],r=e[1],a=e[2];0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=qf({ones:()=>za(s),rate:this.dropout,training:n,count:4}));const i=this.dropoutMask,o=(e,t,n)=>t&&t[n]?ds(t[n],e):e;let l=o(s,i,0),u=o(s,i,1),c=o(s,i,2),h=o(s,i,3);0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=qf({ones:()=>za(r),rate:this.recurrentDropout,training:n,count:4}));const p=this.recurrentDropoutMask;let d=o(r,p,0),f=o(r,p,1),m=o(r,p,2),g=o(r,p,3);const[y,b,x,w]=Bi(this.kernel.read(),4,3),[k,v,N,I]=this.useBias?Bi(this.bias.read(),4):[null,null,null,null];l=this.inputConv(l,y,k,this.padding),u=this.inputConv(u,b,v,this.padding),c=this.inputConv(c,x,N,this.padding),h=this.inputConv(h,w,I,this.padding);const[C,S,T,E]=Bi(this.recurrentKernel.read(),4,3);d=this.recurrentConv(d,C),f=this.recurrentConv(f,S),m=this.recurrentConv(m,T),g=this.recurrentConv(g,E);const $=this.recurrentActivation.apply(cs(l,d)),A=this.recurrentActivation.apply(cs(u,f)),R=cs(ds(A,a),ds($,this.activation.apply(cs(c,m)))),F=ds(this.recurrentActivation.apply(cs(h,g)),this.activation.apply(R));return[F,F,R]})}getConfig(){const e=super.getConfig(),{units:t}=e,n=Kf(e,["units"]),s={filters:this.filters,kernelSize:this.kernelSize,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,strides:this.strides};return Object.assign({},n,s)}inputConv(e,t,n,s){const r=or(e,t,this.strides,s||"valid","channelsFirst"===this.dataFormat?"NCHW":"NHWC",this.dilationRate);return n?Th(r,n,this.dataFormat):r}recurrentConv(e,t){return or(e,t,1,"same","channelsFirst"===this.dataFormat?"NCHW":"NHWC")}}Yf.className="ConvLSTM2DCell",Kn(Yf);class Jf extends Xf{constructor(e){const t=new Yf(e);super(Object.assign({},e,{cell:t}))}static fromConfig(e,t){return new e(t)}}Jf.className="ConvLSTM2D",Kn(Jf);class Zf extends gp{constructor(e){super(e),this.rate=Math.max(Math.min(e.rate,1),0),this.noiseShape=e.noiseShape,this.seed=e.seed,this.supportsMasking=!0}getNoiseShape(e){if(null==this.noiseShape)return this.noiseShape;const t=e.shape,n=[];for(let e=0;e<this.noiseShape.length;++e)n.push(null==this.noiseShape[e]?t[e]:this.noiseShape[e]);return n}call(e,t){return rs(()=>{this.invokeCallHook(e,t);const n=ap(e);if(0<this.rate&&this.rate<1){const e=null!=t.training&&t.training,s=this.getNoiseShape(n);return $h(()=>Eh(n,this.rate,s,this.seed),()=>n,e)}return e})}getConfig(){const e={rate:this.rate,noiseShape:this.noiseShape,seed:this.seed},t=super.getConfig();return Object.assign(e,t),e}dispose(){return super.dispose()}}Zf.className="Dropout",Kn(Zf);class Qf extends Zf{constructor(e){super(e),this.inputSpec=[{ndim:3}]}getNoiseShape(e){const t=e.shape;return[t[0],1,t[2]]}}Qf.className="SpatialDropout1D",Kn(Qf);class em extends gp{constructor(e){if(super(e),this.activation=null,this.useBias=!0,this.kernel=null,this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",null==e.batchInputShape&&null==e.inputShape&&null!=e.inputDim){let t=null;null!=e.batchSize&&(t=e.batchSize),this.batchInputShape=[t,e.inputDim]}this.units=e.units,Oc(this.units,"units"),this.activation=nf(e.activation),null!=e.useBias&&(this.useBias=e.useBias),this.kernelInitializer=Jh(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.biasInitializer=Jh(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelConstraint=jc(e.kernelConstraint),this.biasConstraint=jc(e.biasConstraint),this.kernelRegularizer=cf(e.kernelRegularizer),this.biasRegularizer=cf(e.biasRegularizer),this.activityRegularizer=cf(e.activityRegularizer),this.supportsMasking=!0,this.inputSpec=[{minNDim:2}]}build(e){const t=(e=ip(e))[e.length-1];null==this.kernel&&(this.kernel=this.addWeight("kernel",[t,this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint))),this.inputSpec=[{minNDim:2,axes:{[-1]:t}}],this.built=!0}computeOutputShape(e){const t=(e=ip(e)).slice();return t[t.length-1]=this.units,t}call(e,t){return rs(()=>{this.invokeCallHook(e,t);const n=ap(e),s=Mc(this.activation.getClassName());let r;return null!=s?r=Nh(n,this.kernel.read(),s,this.bias?this.bias.read():null):(r=Nh(n,this.kernel.read()),null!=this.bias&&(r=Th(r,this.bias.read())),null!=this.activation&&(r=this.activation.apply(r))),r})}getConfig(){const e={units:this.units,activation:ef(this.activation),useBias:this.useBias,kernelInitializer:Yh(this.kernelInitializer),biasInitializer:Yh(this.biasInitializer),kernelRegularizer:lf(this.kernelRegularizer),biasRegularizer:lf(this.biasRegularizer),activityRegularizer:lf(this.activityRegularizer),kernelConstraint:Gc(this.kernelConstraint),biasConstraint:Gc(this.biasConstraint)},t=super.getConfig();return Object.assign(e,t),e}}em.className="Dense",Kn(em);class tm extends gp{constructor(e){super(e=e||{}),this.inputSpec=[{minNDim:3}],this.dataFormat=e.dataFormat}computeOutputShape(e){e=ip(e);for(const t of e.slice(1))if(null==t)throw new yc(`The shape of the input to "Flatten" is not fully defined (got ${e.slice(1)}). Make sure to pass a complete "input_shape" or "batch_input_shape" argument to the first layer in your model.`);return[e[0],uh(e,1)]}call(e,t){return rs(()=>{this.invokeCallHook(e,t);let n=ap(e);if("channelsFirst"===this.dataFormat&&n.rank>1){const e=[0];for(let t=2;t<n.rank;++t)e.push(t);e.push(1),n=n.transpose(e)}return function(e){if(e.rank<=1)throw new yc(`batchFlatten requires a minimum rank of 2. Got rank: ${e.rank}.`);const t=[e.shape[0],uh(e.shape,1)];return e.reshape(t)}(n)})}getConfig(){const e={};null!=this.dataFormat&&(e.dataFormat=this.dataFormat);const t=super.getConfig();return Object.assign(e,t),e}}tm.className="Flatten",Kn(tm);class nm extends gp{constructor(e){super(e),this.supportsMasking=!0,this.activation=nf(e.activation)}call(e,t){return rs(()=>{this.invokeCallHook(e,t);const n=ap(e);return this.activation.apply(n)})}getConfig(){const e={activation:ef(this.activation)},t=super.getConfig();return Object.assign(e,t),e}}nm.className="Activation",Kn(nm);class sm extends gp{constructor(e){super(e),this.n=e.n,this.inputSpec=[{ndim:2}]}computeOutputShape(e){return[e[0],this.n,e[1]]}call(e,t){return rs(()=>{return e=ap(e),t=e,n=this.n,rs(()=>{if(2!==t.shape.length)throw new yc(`repeat() expects a rank-2 tensor, but received a rank-${t.shape.length} tensor.`);return kh(mh(t,1),[1,n,1])});var t,n})}getConfig(){const e={n:this.n},t=super.getConfig();return Object.assign(e,t),e}}sm.className="RepeatVector",Kn(sm);class rm extends gp{constructor(e){super(e),this.targetShape=e.targetShape;for(let e=0;e<this.targetShape.length;++e)this.isUnknown(this.targetShape[e])&&(this.targetShape[e]=null)}isUnknown(e){return e<0||null==e}fixUnknownDimension(e,t){const n="Total size of new array must be unchanged.",s=t.slice();let r=1,a=null;for(let e=0;e<s.length;++e){const t=s[e];if(this.isUnknown(t)){if(null!==a)throw new yc("Can only specifiy one unknown dimension.");a=e}else r*=t}const i=uh(e);if(null!==a){if(0===r||i%r!=0)throw new yc(n);s[a]=i/r}else if(i!==r)throw new yc(n);return s}computeOutputShape(e){let t=!1;for(let n=0;n<e.length;++n)if(this.isUnknown(e[n])){t=!0;break}return t?e.slice(0,1).concat(this.targetShape):e.slice(0,1).concat(this.fixUnknownDimension(e.slice(1),this.targetShape))}call(e,t){return rs(()=>{this.invokeCallHook(e,t);const n=ap(e),s=n.shape,r=s.slice(0,1).concat(this.fixUnknownDimension(s.slice(1),this.targetShape));return n.reshape(r)})}getConfig(){const e={targetShape:this.targetShape},t=super.getConfig();return Object.assign(e,t),e}}rm.className="Reshape",Kn(rm);class am extends gp{constructor(e){if(super(e),null==e.dims)throw new Error("Required configuration field `dims` is missing during Permute constructor call.");if(!Array.isArray(e.dims))throw new Error("Permute constructor requires `dims` to be an Array, but received "+e.dims+" instead.");const t=dh(1,e.dims.length+1);if(!d(e.dims.slice().sort(),t))throw new Error("Invalid permutation `dims`: "+JSON.stringify(e.dims)+" `dims` must contain consecutive integers starting from 1.");this.dims=e.dims,this.dimsIncludingBatch=[0].concat(this.dims),this.inputSpec=[new hp({ndim:this.dims.length+1})]}computeOutputShape(e){const t=(e=ip(e)).slice();return this.dims.forEach((n,s)=>{t[s+1]=e[n]}),t}call(e,t){return gn(ap(e),this.dimsIncludingBatch)}getConfig(){const e={dims:this.dims},t=super.getConfig();return Object.assign(e,t),e}}am.className="Permute",Kn(am);class im extends gp{constructor(e){super(null==e?{}:e),this.supportsMasking=!0,this.maskValue=null!=e?null==e.maskValue?0:e.maskValue:0}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={maskValue:this.maskValue};return Object.assign(t,e),t}computeMask(e,t){const n=ap(e);return xs(Oa(n,this.maskValue),-1)}call(e,t){return rs(()=>{this.invokeCallHook(e,t);const n=ap(e),s=xs(Oa(n,this.maskValue),-1,!0);return n.mul(s.asType(n.dtype))})}}im.className="Masking",Kn(im);class om extends gp{constructor(e){if(super(e),this.embeddings=null,this.DEFAULT_EMBEDDINGS_INITIALIZER="randomUniform",null==e.batchInputShape&&null==e.inputShape){let t=null;null!=e.batchSize&&(t=e.batchSize),null==e.inputLength?this.batchInputShape=[t,null]:this.batchInputShape=[t].concat(Ic(e.inputLength))}this.inputDim=e.inputDim,Oc(this.inputDim,"inputDim"),this.outputDim=e.outputDim,Oc(this.outputDim,"outputDim"),this.embeddingsInitializer=Jh(e.embeddingsInitializer||this.DEFAULT_EMBEDDINGS_INITIALIZER),this.embeddingsRegularizer=cf(e.embeddingsRegularizer),this.activityRegularizer=cf(e.activityRegularizer),this.embeddingsConstraint=jc(e.embeddingsConstraint),this.maskZero=e.maskZero,this.supportsMasking=e.maskZero,this.inputLength=e.inputLength}build(e){this.embeddings=this.addWeight("embeddings",[this.inputDim,this.outputDim],this.dtype,this.embeddingsInitializer,this.embeddingsRegularizer,!0,this.embeddingsConstraint),this.built=!0}warnOnIncompatibleInputShape(e){}computeMask(e,t){return rs(()=>this.maskZero?(e=ap(e),Oa(e,Tr(e))):null)}computeOutputShape(e){if(e=ip(e),null==this.inputLength)return[...e,this.outputDim];const t=Ic(this.inputLength);if(t.length!==e.length-1)throw new yc(`"inputLength" is ${this.inputLength}, but received input shape has shape `+e);{let n=0;for(let s=0;s<t.length;++s){const r=t[s],a=e[s+1];if(null!=r&&null!=a&&r!==a)throw new yc(`"inputLength" is ${this.inputLength}, but received input shape has shape `+e);null==r&&(t[n]=a),n++}}return[e[0],...t,this.outputDim]}call(e,t){return rs(()=>{this.invokeCallHook(e,t);let n=ap(e);return"int32"!==n.dtype&&(n=fh(n,"int32")),Ih(this.embeddings.read(),n.as1D()).reshape(ip(this.computeOutputShape(n.shape)))})}getConfig(){const e={inputDim:this.inputDim,outputDim:this.outputDim,embeddingsInitializer:Yh(this.embeddingsInitializer),embeddingsRegularizer:lf(this.embeddingsRegularizer),activityRegularizer:lf(this.activityRegularizer),embeddingsConstraint:Gc(this.embeddingsConstraint),maskZero:this.maskZero,inputLength:this.inputLength},t=super.getConfig();return Object.assign(e,t),e}}om.className="Embedding",Kn(om);class lm extends gp{constructor(e){super(e||{}),this.supportsMasking=!0}mergeFunction(e){throw new bc}computeElementwiseOpOutputShape(e,t){if(null==e||null==t)return null;if(e.length<t.length)return this.computeElementwiseOpOutputShape(t,e);if(0===t.length)return e;const n=e.slice(0,e.length-t.length);for(let s=0;s<t.length;++s){const r=e[e.length-t.length+s],a=t[s];if(null==r||null==a||r<0||a<0)n.push(null);else if(1===r)n.push(a);else if(1===a)n.push(r);else{if(r!==a)throw new yc("Operands could not be broadcast together with shapes "+JSON.stringify(e)+" "+JSON.stringify(t));n.push(r)}}return n}build(e){if(Array.isArray(e)&&!Array.isArray(e[0])&&(e=[ip(e)]),(e=e).length<2)throw new yc(`A merge layer should be called on an Array of at least 2 inputs. Got ${e.length} input(s).`);let t=[];for(const n of e)null!=n&&null!==n[0]&&t.push(n[0]);if(t=Rc(t),t.length>1)throw new yc(`Can not merge tensors with different batch sizes. Got tensors with shapes: ${JSON.stringify(e)}.`);let n=null==e[0]?null:e[0].slice(1);for(let t=1;t<e.length;++t){const s=null==e[t]?null:e[t].slice(1);n=this.computeElementwiseOpOutputShape(n,s)}const s=e.map(e=>e.length);-1===e.indexOf(null)&&1===Rc(s).length?this.reshapeRequired=!1:this.reshapeRequired=!0}call(e,t){return rs(()=>{if(e=e,this.reshapeRequired){const t=[],n=e.map(e=>e.rank);if(-1===n.indexOf(null)){const s=ph(n);for(let n of e){const e=n.rank;for(let t=0;t<s-e;++t)n=mh(n,1);t.push(n)}return this.mergeFunction(t)}{let n=!1;for(const s of e){const e=s.rank;if(null==e){const e=s.shape,r=e[0],a=e.slice(1).concat([r]);let i=s.reshape([r].concat(uh(e.slice(1))));i=gn(i,[1,0]),i=i.reshape(a),t.push(i),n=!0}else if(e>1){const r=dh(1,e).concat([0]);t.push(gn(s,r)),n=!0}else t.push(s)}let s=this.mergeFunction(t);const r=s.rank;if(n)if(null==r){const e=s.shape,t=e[e.length-1],n=[t].concat(e.slice(0,e.length-1));s=gn(s.reshape([-1,t]),[1,0]).reshape(n)}else if(r>1){const e=[r-1].concat(dh(0,r-1));s=gn(s,e)}return s}}return this.mergeFunction(e)})}computeOutputShape(e){let t;t=null==(e=e)[0]?null:e[0].slice(1);for(let n=1;n<e.length;++n){const s=null==e[n]?null:e[n].slice(1);t=this.computeElementwiseOpOutputShape(t,s)}let n=[];for(const t of e)null!=t&&null!==t[0]&&n.push(t[0]);return n=Rc(n),t=1===n.length?n.concat(t):[null].concat(t),t}computeMask(e,t){return rs(()=>{if(null==t)return null;if(!Array.isArray(t))throw new yc("`mask` should be an Array");if(!Array.isArray(e))throw new yc("`inputs` should be an Array");if(t.length!==e.length)throw new yc(`The Array 'inputs' and 'mask' are expected to have the same length, but have different lengths (${e.length} vs ${t.length})`);if(t.every(e=>null==e))return null;let n=(t=t.map(e=>null==e?e:Dr(e,0)))[0];for(let e=1;e<t.length-1;++e)n=ba(n,t[e]);return n})}}class um extends lm{constructor(e){super(e)}mergeFunction(e){return rs(()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=cs(t,e[n]);return t})}}um.className="Add",Kn(um);class cm extends lm{constructor(e){super(e)}mergeFunction(e){return rs(()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=ds(t,e[n]);return t})}}cm.className="Multiply",Kn(cm);class hm extends lm{constructor(e){super(e)}mergeFunction(e){return rs(()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=cs(t,e[n]);return ds(1/e.length,t)})}}hm.className="Average",Kn(hm);class pm extends lm{constructor(e){super(e)}mergeFunction(e){return rs(()=>{let t=e[0];for(let n=1;n<e.length;++n)t=Ca(t,e[n]);return t})}}pm.className="Maximum",Kn(pm);class dm extends lm{constructor(e){super(e)}mergeFunction(e){return rs(()=>{let t=e[0];for(let n=1;n<e.length;++n)t=Ea(t,e[n]);return t})}}dm.className="Minimum",Kn(dm);class fm extends lm{constructor(e){super(e),this.DEFAULT_AXIS=-1,null==e&&(e={}),this.axis=null==e.axis?this.DEFAULT_AXIS:e.axis,this.supportsMasking=!0,this.reshapeRequired=!1}build(e){if(!Array.isArray(e)||!Array.isArray(e[0])||1===e.length)throw new yc("A `Concatenate` layer should be called on a list of at least 2 inputs");e=e;let t=!0;for(const n of e)if(null!=n){t=!1;break}if(t)return;const n=[];for(let t=0;t<e.length;++t){const s=e[t].slice();s.splice(this.axis,1);let r=!1;for(const e of n)if(d(e,s)){r=!0;break}r||n.push(s)}if(n.length>1)throw new yc("A `Concatenate` layer requires inputs with matching shapes except for the concat axis. Got input shapes: "+JSON.stringify(e))}mergeFunction(e){return rs(()=>xh(e,this.axis))}computeOutputShape(e){if(!Array.isArray(e)||!Array.isArray(e[0]))throw new yc("A `Concatenate` layer should be called on a list of inputs.");const t=e,n=t[0].slice(),s=this.axis<0?n.length+this.axis:this.axis;for(const e of t.slice(1)){if(null==n[s]||null==e[s]){n[s]=null;break}n[s]+=e[s]}return n}computeMask(e,t){if(null==t)return null;if(!Array.isArray(t))throw new yc("`mask` should be an array for Concatenate");if(!Array.isArray(e))throw new yc("`inputs` should be an array for Concatenate");if(t.length!==e.length)throw new yc(`Mismatch in the length of mask (${t.length}) and the legnth of inputs (${e.length})`);return rs(()=>{let n=!0;if(t.forEach(e=>{null==e||(n=!1)}),n)return null;const s=[];for(let n=0;n<e.length;++n)null==t[n]?s.push(za(e[n]).asType("bool")):t[n].rank<e[n].rank?s.push(Dr(t[n],-1)):s.push(t[n]);const r=Us(s,this.axis);return bs(r,-1,!1)})}getConfig(){const e={axis:this.axis},t=super.getConfig();return Object.assign(e,t),e}}function mm(e,t){for(;e<0;)e+=t;return e}fm.className="Concatenate",Kn(fm);class gm extends lm{constructor(e){super(e),this.axes=e.axes,this.normalize=null!=e.normalize&&e.normalize,this.supportsMasking=!0,this.reshapeRequired=!1}build(e){l(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),()=>"A `Dot` layer should be called on a list of exactly 2 inputs.");const t=e[0],n=e[1];if(t.length>3||n.length>3)throw new bc("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(t,n);if(t[s[0]]!==n[s[1]])throw new yc(`Dimension incompatibility: ${t[s[0]]} !== ${n[s[1]]}`)}mergeFunction(e){if(2!==e.length)throw new yc(`A \`Dot\` layer must be called on exactly 2 inputs, but received ${e.length} input(s).`);let t,n=e[0],s=e[1];return t=Array.isArray(this.axes)?this.axes.map((t,n)=>mm(t,e[n].shape.length)):[mm(this.axes,n.shape.length),mm(this.axes,s.shape.length)],this.normalize&&(n=Rp(n,t[0]),s=Rp(s,t[1])),function(e,t,n){if(e.shape.length>3||t.shape.length>3)throw new bc("batchDot is not implemented for tensors of 4D or higher rank yet");if(l(e.shape.length>=2,()=>"batchDot requires the rank of x to be >= 2, but got "+e.shape.length),l(e.shape.length>=2,()=>"batchDot requires the rank of y to be >= 2, but got "+t.shape.length),"number"==typeof n&&(n=[n,n]),"complex64"===e.dtype||"complex64"===t.dtype)throw new bc("batchDot is not implemented for complex64-type Tensors yet.");const s=e.shape.length,r=t.shape.length;null==n&&(n=[s-1,r-2]);const a=n;return rs(()=>{let n,i;if(s>r){n=s-r;const e=[];for(let t=0;t<n;++t)e.push(1);t=t.reshape(t.shape.concat(e))}else if(r>s){n=r-s;const t=[];for(let e=0;e<n;++e)t.push(1);e=e.reshape(e.shape.concat(t))}else n=0;if(2===e.shape.length&&2===t.shape.length)i=a[0]===a[1]?e.mul(t).sum(a[0]):e.transpose([1,0]).mul(t).sum(a[1]);else{const n=a[0]!==e.shape.length-1,s=a[1]===t.shape.length-1;i=e.matMul(t,n,s)}if(n>0){let e;e=s>r?s+r-3:s-1;const t=[];for(let s=e;s<e+n;++s)t.push(s);i=i.squeeze(t)}return 1===i.shape.length&&(i=i.expandDims(1)),i})}(n,s,t)}interpretAxes(e,t){let n;return n=Array.isArray(this.axes)?this.axes:[mm(this.axes,e.length),mm(this.axes,t.length)],n}computeOutputShape(e){l(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),()=>"A `Dot` layer should be called on a list of exactly 2 inputs.");const t=e[0].slice(),n=e[1].slice();if(t.length>3||n.length>3)throw new bc("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(t,n);t.splice(s[0],1),n.splice(s[1],1),n.splice(0,1);const r=t.concat(n);return 1===r.length&&r.push(1),r}computeMask(e,t){return null}getConfig(){const e={axes:this.axes,normalize:this.normalize},t=super.getConfig();return Object.assign(e,t),e}}gm.className="Dot",Kn(gm);class ym extends gp{constructor(e){super(e),this.supportsMasking=!0,this.stddev=e.stddev}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={stddev:this.stddev};return Object.assign(t,e),t}call(e,t){return rs(()=>{this.invokeCallHook(e,t);const n=ap(e);return $h(()=>vh(n.shape,0,this.stddev).add(n),()=>n,t.training||!1)})}}ym.className="GaussianNoise",Kn(ym);class bm extends gp{constructor(e){super(e),this.supportsMasking=!0,this.rate=e.rate}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={rate:this.rate};return Object.assign(t,e),t}call(e,t){return rs(()=>{this.invokeCallHook(e,t);const n=ap(e);if(this.rate>0&&this.rate<1){return $h(()=>{const e=Math.sqrt(this.rate/(1-this.rate));return n.mul(vh(n.shape,1,e))},()=>n,t.training||!1)}return n})}}bm.className="GaussianDropout",Kn(bm);class xm extends gp{constructor(e){super(e),this.supportsMasking=!0,this.rate=e.rate,this.noiseShape=e.noiseShape}_getNoiseShape(e){return this.noiseShape||ap(e).shape}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={rate:this.rate};return Object.assign(t,e),t}call(e,t){return rs(()=>{if(this.rate<1&&this.rate>0){const n=this._getNoiseShape(e);return $h(()=>{const t=ap(e),s=-1.7580993408473766;let r=Wr(hi(n),this.rate);r=fh(r,"float32");const a=((1-this.rate)*(1+this.rate*s**2))**-.5,i=-a*s*this.rate;return t.mul(r).add(r.add(-1).mul(s)).mul(a).add(i)},()=>ap(e),t.training||!1)}return e})}}function wm(e,t,n,s,r,a=.001){let i;if(2===e.rank)i=Ys(e,t,n,s,r,a);else if(3===e.rank)i=Js(e,t,n,s,r,a);else{if(4!==e.rank)throw new bc(`batchNormalization is not implemented for array of rank ${e.rank} yet`);i=Zs(e,t,n,s,r,a)}return i}function km(e,t,n,s,r=.001){return d(s.slice().sort(),dh(0,e.rank-1))?function(e,t,n,s,r=.001){return rs(()=>{const a=Fa(e,s),i=a.mean,o=a.variance;return[wm(e,i,o,n,t,r),i,o]})}(e,t,n,s,r):function(e,t,n,s,r=.001){return rs(()=>{const a=Fa(e,s),i=a.mean,o=a.variance,l=[];for(const t of dh(0,e.rank))-1!==s.indexOf(t)?l.push(1):l.push(e.shape[t]);const u=i.reshape(l),c=o.reshape(l),h=null==t?null:t.reshape(l),p=null==n?null:n.reshape(l);return[wm(e,u,c,p,h,r),i,o]})}(e,t,n,s,r)}xm.className="AlphaDropout",Kn(xm);class vm extends gp{constructor(e){null==e&&(e={}),super(e),this.supportsMasking=!0,this.axis=null==e.axis?-1:e.axis,this.momentum=null==e.momentum?.99:e.momentum,this.epsilon=null==e.epsilon?.001:e.epsilon,this.center=null==e.center||e.center,this.scale=null==e.scale||e.scale,this.betaInitializer=Jh(e.betaInitializer||"zeros"),this.gammaInitializer=Jh(e.gammaInitializer||"ones"),this.movingMeanInitializer=Jh(e.movingMeanInitializer||"zeros"),this.movingVarianceInitializer=Jh(e.movingVarianceInitializer||"ones"),this.betaConstraint=jc(e.betaConstraint),this.gammaConstraint=jc(e.gammaConstraint),this.betaRegularizer=cf(e.betaRegularizer),this.gammaRegularizer=cf(e.gammaRegularizer)}build(e){e=ip(e);const t=this.axis>=0?this.axis:this.axis+e.length,n=e[t];if(null==n)throw new yc(`Axis ${t} of input tensor should have a defined dimension but the layer received an input with shape `+JSON.stringify(e)+".");this.inputSpec=[new hp({ndim:e.length,axes:{[t]:n}})];const s=[n];this.scale&&(this.gamma=this.addWeight("gamma",s,null,this.gammaInitializer,this.gammaRegularizer,!0,this.gammaConstraint)),this.center&&(this.beta=this.addWeight("beta",s,null,this.betaInitializer,this.betaRegularizer,!0,this.betaConstraint)),this.movingMean=this.addWeight("moving_mean",s,null,this.movingMeanInitializer,null,!1),this.movingVariance=this.addWeight("moving_variance",s,null,this.movingVarianceInitializer,null,!1),this.built=!0}call(e,t){return rs(()=>{const n=null!=t.training&&t.training,s=ap(e),r=s.shape,a=r.length,i=dh(0,a),o=this.axis>=0?this.axis:this.axis+a;i.splice(o,1);const l=wc(1,a);l[o]=r[o];const u=i.slice();u.sort();const c=!d(u,dh(0,a).slice(0,a-1));if(!n)return(()=>{if(c){const e=this.movingMean.read().reshape(l),t=this.movingVariance.read().reshape(l),n=this.center?this.beta.read().reshape(l):null,r=this.scale?this.gamma.read().reshape(l):null;return wm(s,e,t,n,r,this.epsilon)}return wm(s,this.movingMean.read(),this.movingVariance.read(),null==this.beta?null:this.beta.read(),null==this.gamma?null:this.gamma.read(),this.epsilon)})();const[h,p,f]=km(s,this.gamma.read(),this.beta.read(),i,this.epsilon),m=(e,t,n)=>{rs(()=>{const s=1-n,r=e.read(),a=r.sub(t).mul(s);e.write(r.sub(a))})};return(()=>{m(this.movingMean,p,this.momentum),m(this.movingVariance,f,this.momentum)})(),h})}getConfig(){const e={axis:this.axis,momentum:this.momentum,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Yh(this.betaInitializer),gammaInitializer:Yh(this.gammaInitializer),movingMeanInitializer:Yh(this.movingMeanInitializer),movingVarianceInitializer:Yh(this.movingVarianceInitializer),betaRegularizer:lf(this.betaRegularizer),gammaRegularizer:lf(this.gammaRegularizer),betaConstraint:Gc(this.betaConstraint),gammaConstraint:Gc(this.gammaConstraint)},t=super.getConfig();return Object.assign(e,t),e}}vm.className="BatchNormalization",Kn(vm);class Nm extends gp{constructor(e){if(null==e&&(e={}),super(e),this.axis=null==e.axis?-1:e.axis,"number"==typeof this.axis){if(!Number.isInteger(this.axis))throw new Error("Expected axis to be an integer, but received "+this.axis)}else{if(!Array.isArray(this.axis))throw new Error("Expected axis to be an integer or an array of integers, but received "+JSON.stringify(this.axis));for(const e of this.axis)if(!Number.isInteger(e))throw new Error("Expected axis to be an array of integers, but received "+JSON.stringify(this.axis))}this.epsilon=null==e.epsilon?.001:e.epsilon,this.center=null==e.center||e.center,this.scale=null==e.scale||e.scale,this.betaInitializer=Jh(e.betaInitializer||"zeros"),this.gammaInitializer=Jh(e.gammaInitializer||"ones"),this.betaRegularizer=cf(e.betaRegularizer),this.gammaRegularizer=cf(e.gammaRegularizer),this.supportsMasking=!0}build(e){const t=(e=ip(e)).length;"number"==typeof this.axis&&(this.axis=[this.axis]);for(let e=0;e<this.axis.length;++e)this.axis[e]<0&&(this.axis[e]+=t);for(const e of this.axis)if(e<0||e>=t)throw new Error("Invalid axis: "+e);if(this.axis.length!==Rc(this.axis).length)throw new Error("Found duplicate axes in: "+this.axis);const n=this.axis.map(t=>e[t]);this.scale?this.gamma=this.addWeight("gamma",n,"float32",this.gammaInitializer,this.gammaRegularizer,!0):this.gamma=null,this.center?this.beta=this.addWeight("beta",n,"float32",this.betaInitializer,this.betaRegularizer,!0):this.beta=null,this.built=!0}call(e,t){const n=ap(e),s=n.shape,r=s.length;return rs(()=>{let{mean:e,variance:t}=Fa(n,this.axis,!0);const a=wc(1,r);for(const e of this.axis)a[e]=s[e];const i=e=>null!=e&&e.shape.length!==r&&this.axis!==[r-1]?e.reshape(a):e;let o=i(this.gamma.read()),l=i(this.beta.read());const u=[],c=[];for(let e=0;e<r;++e)-1!==this.axis.indexOf(e)?(u.push(s[e]),c.push(1)):(u.push(1),c.push(s[e]));return e=e.tile(u),t=t.tile(u),o=o.tile(c),l=l.tile(c),wm(n,e,t,l,o,this.epsilon)})}getConfig(){const e={axis:this.axis,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Yh(this.betaInitializer),gammaInitializer:Yh(this.gammaInitializer),betaRegularizer:lf(this.betaRegularizer),gammaRegularizer:lf(this.gammaRegularizer)},t=super.getConfig();return Object.assign(e,t),e}}Nm.className="LayerNormalization",Kn(Nm);class Im extends gp{constructor(e){if(null==e&&(e={}),super(e),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,null==e.padding)this.padding=[[1,1],[1,1]];else if("number"==typeof e.padding)this.padding=[[e.padding,e.padding],[e.padding,e.padding]];else{if(e.padding=e.padding,2!==e.padding.length)throw new yc(`ZeroPadding2D expects padding to be a length-2 array, but received a length-${e.padding.length} array.`);let t,n;if("number"==typeof e.padding[0])t=[e.padding[0],e.padding[0]],n=[e.padding[1],e.padding[1]];else{if(e.padding=e.padding,2!==e.padding[0].length)throw new yc(`ZeroPadding2D expects height padding to be a length-2 array, but received a length-${e.padding[0].length} array.`);if(t=e.padding[0],2!==e.padding[1].length)throw new yc(`ZeroPadding2D expects width padding to be a length-2 array, but received a length-${e.padding[1].length} array.`);n=e.padding[1]}this.padding=[t,n]}this.inputSpec=[new hp({ndim:4})]}computeOutputShape(e){let t,n;return e=ip(e),"channelsFirst"===this.dataFormat?(t=null!=e[2]&&e[2]>=0?e[2]+this.padding[0][0]+this.padding[0][1]:null,n=null!=e[3]&&e[3]>=0?e[3]+this.padding[1][0]+this.padding[1][1]:null,[e[0],e[1],t,n]):(t=null!=e[1]&&e[1]>=0?e[1]+this.padding[0][0]+this.padding[0][1]:null,n=null!=e[2]&&e[2]>=0?e[2]+this.padding[1][0]+this.padding[1][1]:null,[e[0],t,n,e[3]])}call(e,t){return rs(()=>{return t=ap(e),n=this.padding,s=this.dataFormat,rs(()=>{if(4!==t.rank)throw new yc("temporalPadding expects input tensor to be 4-D, but received a "+t.rank+"-D tensor.");if(null==n&&(n=[[1,1],[1,1]]),2!==n.length||2!==n[0].length||2!==n[1].length)throw new yc("spatial2dPadding expects `padding` to be an Array of two Arrays, each of which is an Array of two integers.");if(null==s&&(s="channelsLast"),"channelsLast"!==s&&"channelsFirst"!==s)throw new yc(`Unknown data format: ${s}. Supported data formats are 'channelsLast' and 'channelsFirst.`);let e;return e="channelsFirst"===s?[[0,0],[0,0],n[0],n[1]]:[[0,0],n[0],n[1],[0,0]],Pa(t,e)});var t,n,s})}getConfig(){const e={padding:this.padding,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}function Cm(e,t,n,s,r,a){return rs(()=>{let i;eh(r),nh(a),th(s),null==n&&(n=[1,1]),null==s&&(s="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),e=wf(e,r);const o="same"===s?"same":"valid";return i="max"===a?va(e,t,n,o):Ws(e,t,n,o),"channelsFirst"===r&&(i=gn(i,[0,3,1,2])),i})}function Sm(e,t,n,s,r,a){return rs(()=>{let i;eh(r),nh(a),th(s),null==n&&(n=[1,1,1]),null==s&&(s="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),e=kf(e,r);const o="same"===s?"same":"valid";return i="max"===a?Na(e,t,n,o):Vs(e,t,n,o),"channelsFirst"===r&&(i=gn(i,[0,4,1,2,3])),i})}Im.className="ZeroPadding2D",Kn(Im);class Tm extends gp{constructor(e){if(null==e.poolSize&&(e.poolSize=2),super(e),"number"==typeof e.poolSize)this.poolSize=[e.poolSize];else{if(!Array.isArray(e.poolSize)||1!==e.poolSize.length||"number"!=typeof e.poolSize[0])throw new yc("poolSize for 1D convolutional layer must be a number or an Array of a single number, but received "+JSON.stringify(e.poolSize));this.poolSize=e.poolSize}if(Oc(this.poolSize,"poolSize"),null==e.strides)this.strides=this.poolSize;else if("number"==typeof e.strides)this.strides=[e.strides];else{if(!Array.isArray(e.strides)||1!==e.strides.length||"number"!=typeof e.strides[0])throw new yc("strides for 1D convolutional layer must be a number or an Array of a single number, but received "+JSON.stringify(e.strides));this.strides=e.strides}Oc(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,th(this.padding),this.inputSpec=[new hp({ndim:3})]}computeOutputShape(e){const t=bf((e=ip(e))[1],this.poolSize[0],this.padding,this.strides[0]);return[e[0],t,e[2]]}call(e,t){return rs(()=>{this.invokeCallHook(e,t),e=mh(ap(e),2);const n=this.poolingFunction(ap(e),[this.poolSize[0],1],[this.strides[0],1],this.padding,"channelsLast");return Ui(n,[2])})}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides},t=super.getConfig();return Object.assign(e,t),e}}class Em extends Tm{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return eh(r),th(s),Cm(e,t,n,s,r,"max")}}Em.className="MaxPooling1D",Kn(Em);class $m extends Tm{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return eh(r),th(s),Cm(e,t,n,s,r,"avg")}}$m.className="AveragePooling1D",Kn($m);class Am extends gp{constructor(e){if(null==e.poolSize&&(e.poolSize=[2,2]),super(e),this.poolSize=Array.isArray(e.poolSize)?e.poolSize:[e.poolSize,e.poolSize],null==e.strides)this.strides=this.poolSize;else if(Array.isArray(e.strides)){if(2!==e.strides.length)throw new yc("If the strides property of a 2D pooling layer is an Array, it is expected to have a length of 2, but received length "+e.strides.length+".");this.strides=e.strides}else this.strides=[e.strides,e.strides];Oc(this.poolSize,"poolSize"),Oc(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,eh(this.dataFormat),th(this.padding),this.inputSpec=[new hp({ndim:4})]}computeOutputShape(e){e=ip(e);let t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2];return t=bf(t,this.poolSize[0],this.padding,this.strides[0]),n=bf(n,this.poolSize[1],this.padding,this.strides[1]),"channelsFirst"===this.dataFormat?[e[0],e[1],t,n]:[e[0],t,n,e[3]]}call(e,t){return rs(()=>(this.invokeCallHook(e,t),this.poolingFunction(ap(e),this.poolSize,this.strides,this.padding,this.dataFormat)))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class Rm extends Am{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return eh(r),th(s),Cm(e,t,n,s,r,"max")}}Rm.className="MaxPooling2D",Kn(Rm);class Fm extends Am{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return eh(r),th(s),Cm(e,t,n,s,r,"avg")}}Fm.className="AveragePooling2D",Kn(Fm);class Dm extends gp{constructor(e){if(null==e.poolSize&&(e.poolSize=[2,2,2]),super(e),this.poolSize=Array.isArray(e.poolSize)?e.poolSize:[e.poolSize,e.poolSize,e.poolSize],null==e.strides)this.strides=this.poolSize;else if(Array.isArray(e.strides)){if(3!==e.strides.length)throw new yc("If the strides property of a 3D pooling layer is an Array, it is expected to have a length of 3, but received length "+e.strides.length+".");this.strides=e.strides}else this.strides=[e.strides,e.strides,e.strides];Oc(this.poolSize,"poolSize"),Oc(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,eh(this.dataFormat),th(this.padding),this.inputSpec=[new hp({ndim:5})]}computeOutputShape(e){e=ip(e);let t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2],s="channelsFirst"===this.dataFormat?e[4]:e[3];return t=bf(t,this.poolSize[0],this.padding,this.strides[0]),n=bf(n,this.poolSize[1],this.padding,this.strides[1]),s=bf(s,this.poolSize[2],this.padding,this.strides[2]),"channelsFirst"===this.dataFormat?[e[0],e[1],t,n,s]:[e[0],t,n,s,e[4]]}call(e,t){return rs(()=>(this.invokeCallHook(e,t),this.poolingFunction(ap(e),this.poolSize,this.strides,this.padding,this.dataFormat)))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class _m extends Dm{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return eh(r),th(s),Sm(e,t,n,s,r,"max")}}_m.className="MaxPooling3D",Kn(_m);class Om extends Dm{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return eh(r),th(s),Sm(e,t,n,s,r,"avg")}}Om.className="AveragePooling3D",Kn(Om);class Mm extends gp{constructor(e){super(e),this.inputSpec=[new hp({ndim:3})]}computeOutputShape(e){return[e[0],e[2]]}call(e,t){throw new bc}}class Lm extends Mm{constructor(e){super(e||{})}call(e,t){return rs(()=>{const t=ap(e);return Sa(t,1)})}}Lm.className="GlobalAveragePooling1D",Kn(Lm);class zm extends Mm{constructor(e){super(e||{})}call(e,t){return rs(()=>{const t=ap(e);return aa(t,1)})}}zm.className="GlobalMaxPooling1D",Kn(zm);class Bm extends gp{constructor(e){super(e),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,eh(this.dataFormat),this.inputSpec=[new hp({ndim:4})]}computeOutputShape(e){return e=e,"channelsLast"===this.dataFormat?[e[0],e[3]]:[e[0],e[1]]}call(e,t){throw new bc}getConfig(){const e={dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class Pm extends Bm{call(e,t){return rs(()=>{const t=ap(e);return"channelsLast"===this.dataFormat?Sa(t,[1,2]):Sa(t,[2,3])})}}Pm.className="GlobalAveragePooling2D",Kn(Pm);class Wm extends Bm{call(e,t){return rs(()=>{const t=ap(e);return"channelsLast"===this.dataFormat?aa(t,[1,2]):aa(t,[2,3])})}}Wm.className="GlobalMaxPooling2D",Kn(Wm);class Vm extends gp{constructor(e){super(e),this.layer=e.layer}build(e){this.built=!0}get trainable(){return null!=this.layer&&this.layer.trainable}set trainable(e){null!=this.layer&&(this.layer.trainable=e)}get trainableWeights(){return this.layer.trainableWeights}get nonTrainableWeights(){return this.layer.nonTrainableWeights}get updates(){return this.layer._updates}get losses(){return this.layer.losses}getWeights(){return this.layer.getWeights()}setWeights(e){this.layer.setWeights(e)}getConfig(){const e={layer:{className:this.layer.getClassName(),config:this.layer.getConfig()}},t=super.getConfig();return Object.assign(e,t),e}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.layer&&this.layer.setFastWeightInitDuringBuild(e)}static fromConfig(e,t,n={}){const s=Ap(t.layer,n);delete t.layer;const r={layer:s};return Object.assign(r,t),new e(r)}}class Um extends Vm{constructor(e){super(e),this.supportsMasking=!0}build(e){if((e=ip(e)).length<3)throw new yc("TimeDistributed layer expects an input shape >= 3D, but received input shape "+JSON.stringify(e));this.inputSpec=[{shape:e}];const t=[e[0]].concat(e.slice(2));this.layer.built||(this.layer.build(t),this.layer.built=!0),super.build(e)}computeOutputShape(e){const t=[(e=ip(e))[0]].concat(e.slice(2)),n=this.layer.computeOutputShape(t),s=e[1];return[n[0],s].concat(n.slice(1))}call(e,t){return rs(()=>Lf((e,n)=>[ap(this.layer.call(e,t)),[]],e=ap(e),[],!1,null,null,!1,!0)[1])}}Um.className="TimeDistributed",Kn(Um);class Gm extends Vm{constructor(e){super(e);const t=e.layer.getConfig(),n={};n.className=e.layer.getClassName(),n.config=t,this.forwardLayer=Ap(n),t.goBackwards=!0!==t.goBackwards;const s={};var r;if(s.className=e.layer.getClassName(),s.config=t,this.backwardLayer=Ap(s),this.forwardLayer.name="forward_"+this.forwardLayer.name,this.backwardLayer.name="backward_"+this.backwardLayer.name,this.mergeMode=void 0===e.mergeMode?"concat":e.mergeMode,r=this.mergeMode,Dc(Zc,"BidirectionalMergeMode",r),e.weights)throw new bc("weights support is not implemented for Bidirectional layer yet.");this._stateful=e.layer.stateful,this.returnSequences=e.layer.returnSequences,this.returnState=e.layer.returnState,this.supportsMasking=!0,this._trainable=!0,this.inputSpec=e.layer.inputSpec,this.numConstants=null}get trainable(){return this._trainable}set trainable(e){this._trainable=e,null!=this.forwardLayer&&(this.forwardLayer.trainable=e),null!=this.backwardLayer&&(this.backwardLayer.trainable=e)}getWeights(){return this.forwardLayer.getWeights().concat(this.backwardLayer.getWeights())}setWeights(e){const t=e.length,n=Math.floor(t/2);this.forwardLayer.setWeights(e.slice(0,n)),this.backwardLayer.setWeights(e.slice(n))}computeOutputShape(e){let t,n,s,r=this.forwardLayer.computeOutputShape(e);return Array.isArray(r)&&Array.isArray(r[0])||(r=[r]),r=r,this.returnState?(s=r.slice(1),t=r[0]):t=r[0],t=t,"concat"===this.mergeMode?(t[t.length-1]*=2,n=[t]):n=null==this.mergeMode?[t,t.slice()]:[t],this.returnState?null==this.mergeMode?n.concat(s).concat(s.slice()):[t].concat(s).concat(s.slice()):Nc(n)}apply(e,t){let n=null==t?null:t.initialState,s=null==t?null:t.constants;null==t&&(t={});const r=Mf(e,n,s,this.numConstants);if(e=r.inputs,n=r.initialState,s=r.constants,Array.isArray(e)&&(n=e.slice(1),e=e[0]),(null==n||0===n.length)&&null==s)return super.apply(e,t);const a=[],i=[];if(null!=n){const e=n.length;if(e%2>0)throw new yc("When passing `initialState` to a Bidrectional RNN, the state should be an Array containing the states of the underlying RNNs.");t.initialState=n,a.push(...n);const s=n.map(e=>new hp({shape:e.shape}));this.forwardLayer.stateSpec=s.slice(0,e/2),this.backwardLayer.stateSpec=s.slice(e/2),i.push(...s)}if(null!=s)throw new bc("Support for constants in Bidirectional layers is not implemented yet.");const o=a[0]instanceof pp;for(const e of a)if(e instanceof pp!==o)throw new yc("The initial state of a Bidirectional layer cannot be specified as a mix of symbolic and non-symbolic tensors");if(o){const n=[e].concat(a),s=this.inputSpec.concat(i),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,t);return this.inputSpec=r,o}return super.apply(e,t)}call(e,t){return rs(()=>{const n=t.initialState;let s,r,a,i;if(null==n)s=this.forwardLayer.call(e,t),r=this.backwardLayer.call(e,t);else{const a=n.slice(0,n.length/2),i=n.slice(n.length/2);s=this.forwardLayer.call(e,Object.assign(t,{initialState:a})),r=this.backwardLayer.call(e,Object.assign(t,{initialState:i}))}return this.returnState&&(Array.isArray(s)&&(a=s.slice(1).concat(r.slice(1))),s=s[0],r=r[0]),this.returnSequences&&(r=yi(r,1)),"concat"===this.mergeMode?i=xh([s,r]):"sum"===this.mergeMode?i=cs(s,r):"ave"===this.mergeMode?i=ds(.5,cs(s,r)):"mul"===this.mergeMode?i=ds(s,r):null==this.mergeMode&&(i=[s,r]),this.returnState?null==this.mergeMode?i.concat(a):[i].concat(a):i})}resetStates(e){this.forwardLayer.resetStates(),this.backwardLayer.resetStates()}build(e){rh(this.forwardLayer.name,()=>{this.forwardLayer.build(e)}),rh(this.backwardLayer.name,()=>{this.backwardLayer.build(e)}),this.built=!0}computeMask(e,t){let n;if(Array.isArray(t)&&(t=t[0]),n=this.returnSequences?null==this.mergeMode?[t,t]:t:null==this.mergeMode?[null,null]:null,this.returnState){const e=this.forwardLayer.states.map(e=>null);return Array.isArray(n)?n.concat(e).concat(e):[n].concat(e).concat(e)}return n}get trainableWeights(){return this.forwardLayer.trainableWeights.concat(this.backwardLayer.trainableWeights)}get nonTrainableWeights(){return this.forwardLayer.nonTrainableWeights.concat(this.backwardLayer.nonTrainableWeights)}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.forwardLayer&&this.forwardLayer.setFastWeightInitDuringBuild(e),null!=this.backwardLayer&&this.backwardLayer.setFastWeightInitDuringBuild(e)}getConfig(){const e={mergeMode:this.mergeMode},t=super.getConfig();return Object.assign(e,t),e}static fromConfig(e,t){const n=Ap(t.layer);if(delete t.layer,null!=t.numConstants)throw new bc("Deserialization of a Bidirectional layer with numConstants present is not supported yet.");const s=t;return s.layer=n,new e(s)}}function Hm(e){return new $m(e)}function jm(e){return new Fm(e)}function qm(e){return new Om(e)}function Km(e){return new zm(e)}function Xm(e){return new Wm(e)}function Ym(e){return new Em(e)}function Jm(e){return new Rm(e)}Gm.className="Bidirectional",Kn(Gm);const Zm=Km,Qm=Xm,eg=Ym,tg=Jm;var ng=Object.freeze({__proto__:null,inputLayer:function(e){return new yp(e)},elu:function(e){return new ff(e)},reLU:function(e){return new hf(e)},leakyReLU:function(e){return new pf(e)},prelu:function(e){return new df(e)},softmax:function(e){return new gf(e)},thresholdedReLU:function(e){return new mf(e)},conv1d:function(e){return new Ff(e)},conv2d:function(e){return new Tf(e)},conv2dTranspose:function(e){return new $f(e)},conv3d:function(e){return new Ef(e)},separableConv2d:function(e){return new Rf(e)},cropping2D:function(e){return new Df(e)},upSampling2d:function(e){return new _f(e)},depthwiseConv2d:function(e){return new Of(e)},activation:function(e){return new nm(e)},dense:function(e){return new em(e)},dropout:function(e){return new Zf(e)},spatialDropout1d:function(e){return new Qf(e)},flatten:function(e){return new tm(e)},repeatVector:function(e){return new sm(e)},reshape:function(e){return new rm(e)},permute:function(e){return new am(e)},embedding:function(e){return new om(e)},add:function(e){return new um(e)},average:function(e){return new hm(e)},concatenate:function(e){return new fm(e)},maximum:function(e){return new pm(e)},minimum:function(e){return new dm(e)},multiply:function(e){return new cm(e)},dot:function(e){return new gm(e)},batchNormalization:function(e){return new vm(e)},layerNormalization:function(e){return new Nm(e)},zeroPadding2d:function(e){return new Im(e)},averagePooling1d:Hm,avgPool1d:function(e){return Hm(e)},avgPooling1d:function(e){return Hm(e)},averagePooling2d:jm,avgPool2d:function(e){return jm(e)},avgPooling2d:function(e){return jm(e)},averagePooling3d:qm,avgPool3d:function(e){return qm(e)},avgPooling3d:function(e){return qm(e)},globalAveragePooling1d:function(e){return new Lm(e)},globalAveragePooling2d:function(e){return new Pm(e)},globalMaxPooling1d:Km,globalMaxPooling2d:Xm,maxPooling1d:Ym,maxPooling2d:Jm,maxPooling3d:function(e){return new _m(e)},gru:function(e){return new Uf(e)},gruCell:function(e){return new Vf(e)},lstm:function(e){return new Hf(e)},lstmCell:function(e){return new Gf(e)},simpleRNN:function(e){return new Wf(e)},simpleRNNCell:function(e){return new Pf(e)},convLstm2d:function(e){return new Jf(e)},convLstm2dCell:function(e){return new Yf(e)},rnn:function(e){return new zf(e)},stackedRNNCells:function(e){return new jf(e)},bidirectional:function(e){return new Gm(e)},timeDistributed:function(e){return new Um(e)},globalMaxPool1d:Zm,globalMaxPool2d:Qm,maxPool1d:eg,maxPool2d:tg,Layer:gp,RNN:zf,RNNCell:Bf,input:Bd,gaussianNoise:function(e){return new ym(e)},gaussianDropout:function(e){return new bm(e)},alphaDropout:function(e){return new xm(e)},masking:function(e){return new im(e)}});var sg=Object.freeze({__proto__:null,binaryAccuracy:function(e,t){return Up(e,t)},binaryCrossentropy:function(e,t){return Kp(e,t)},sparseCategoricalAccuracy:function(e,t){return Xp(e,t)},categoricalAccuracy:function(e,t){return Gp(e,t)},categoricalCrossentropy:function(e,t){return Yp(e,t)},precision:function(e,t){return jp(e,t)},recall:function(e,t){return qp(e,t)},cosineProximity:function(e,t){return Pp(e,t)},meanAbsoluteError:function(e,t){return Dp(e,t)},meanAbsolutePercentageError:function(e,t){return _p(e,t)},MAPE:function(e,t){return _p(e,t)},mape:function(e,t){return _p(e,t)},meanSquaredError:function(e,t){return Fp(e,t)},MSE:function(e,t){return Fp(e,t)},mse:function(e,t){return Fp(e,t)}}),rg=Object.freeze({__proto__:null,modelFromJSON:async function(e,t){"modelTopology"in e||(e={modelTopology:e});let n=(e=e).modelTopology;null!=n.model_config&&(n=n.model_config);const s=Ap(od(n),t);if(null!=e.weightsManifest){const t=await sn(e.weightsManifest,e.pathPrefix,s.weights.map(e=>e.originalName)),n={};for(const e of s.weights)n[e.originalName]=t[e.originalName];s.loadWeights(n),as(t)}return s}});var ag=Object.freeze({__proto__:null,l1l2:function(e){return new af(e)},l1:function(e){return sf(t=e),new af({l1:null!=t?t.l1:null,l2:0});var t},l2:function(e){return sf(t=e),new af({l2:null!=t?t.l2:null,l1:0});var t}});class ig extends vp{constructor(){super(...arguments),this.model=null}setModel(e){if(!(e instanceof Od))throw new Error("model must be a LayersModel, not some other Container");this.model=e}}function og(e,t){return e<t}function lg(e,t){return e>t}class ug extends ig{constructor(e){if(super(),null==e&&(e={}),e.restoreBestWeights)throw new bc("restoreBestWeights = True is not implemented in EarlyStopping yet.");this.monitor=e.monitor||"val_loss",this.minDelta=Math.abs(e.minDelta||0),this.patience=e.patience||0,this.verbose=e.verbose||0,this.mode=e.mode||"auto",this.baseline=e.baseline,-1===["auto","min","max"].indexOf(this.mode)&&(console.warn(`EarlyStopping mode '${this.mode}' is invalid. Falling back to mode 'auto'.`),this.mode="auto"),"min"===this.mode?this.monitorFunc=og:"max"===this.mode||-1!==this.monitor.indexOf("acc")?this.monitorFunc=lg:this.monitorFunc=og,this.monitorFunc===og&&(this.minDelta*=-1)}async onTrainBegin(e){this.wait=0,this.stoppedEpoch=0,null!=this.baseline?this.best=this.baseline:this.best=this.monitorFunc===og?1/0:-1/0}async onEpochEnd(e,t){await xp(t);const n=this.getMonitorValue(t);null!=n&&(this.monitorFunc(n-this.minDelta,this.best)?(this.best=n,this.wait=0):(this.wait++,this.wait>=this.patience&&(this.stoppedEpoch=e,this.model.stopTraining=!0)))}async onTrainEnd(e){this.stoppedEpoch>0&&this.verbose&&console.log(`Epoch ${this.stoppedEpoch}: early stopping.`)}getMonitorValue(e){null==e&&(e={});const t=e[this.monitor];return null==t&&console.warn(`Metric for EarlyStopping ${this.monitor} is not available. Available metrics are: `+Object.keys(e)),t}}const cg={earlyStopping:function(e){return new ug(e)}};var hg,pg;!function(e){e[e.DT_INVALID=0]="DT_INVALID",e[e.DT_FLOAT=1]="DT_FLOAT",e[e.DT_DOUBLE=2]="DT_DOUBLE",e[e.DT_INT32=3]="DT_INT32",e[e.DT_UINT8=4]="DT_UINT8",e[e.DT_INT16=5]="DT_INT16",e[e.DT_INT8=6]="DT_INT8",e[e.DT_STRING=7]="DT_STRING",e[e.DT_COMPLEX64=8]="DT_COMPLEX64",e[e.DT_INT64=9]="DT_INT64",e[e.DT_BOOL=10]="DT_BOOL",e[e.DT_QINT8=11]="DT_QINT8",e[e.DT_QUINT8=12]="DT_QUINT8",e[e.DT_QINT32=13]="DT_QINT32",e[e.DT_BFLOAT16=14]="DT_BFLOAT16",e[e.DT_FLOAT_REF=101]="DT_FLOAT_REF",e[e.DT_DOUBLE_REF=102]="DT_DOUBLE_REF",e[e.DT_INT32_REF=103]="DT_INT32_REF",e[e.DT_UINT8_REF=104]="DT_UINT8_REF",e[e.DT_INT16_REF=105]="DT_INT16_REF",e[e.DT_INT8_REF=106]="DT_INT8_REF",e[e.DT_STRING_REF=107]="DT_STRING_REF",e[e.DT_COMPLEX64_REF=108]="DT_COMPLEX64_REF",e[e.DT_INT64_REF=109]="DT_INT64_REF",e[e.DT_BOOL_REF=110]="DT_BOOL_REF",e[e.DT_QINT8_REF=111]="DT_QINT8_REF",e[e.DT_QUINT8_REF=112]="DT_QUINT8_REF",e[e.DT_QINT32_REF=113]="DT_QINT32_REF",e[e.DT_BFLOAT16_REF=114]="DT_BFLOAT16_REF"}(hg||(hg={})),function(e){let t;!function(e){e[e.LEGACY=0]="LEGACY",e[e.V1=1]="V1",e[e.V2=2]="V2"}(t=e.CheckpointFormatVersion||(e.CheckpointFormatVersion={}))}(pg||(pg={}));const dg={};function fg(e){return dg[e]}function mg(e,t,n,s,r){const a=t.inputParams[e];if(a&&void 0!==a.inputIndexStart){const e=a.inputIndexStart,i=0===a.inputIndexEnd?void 0:void 0===a.inputIndexEnd?e+1:a.inputIndexEnd;if("tensor"===a.type)return gg(t.inputNames[a.inputIndexStart],n,s,r);if("tensors"===a.type){return t.inputNames.slice(e,i).map(e=>gg(e,n,s,r))}const o=gg(t.inputNames.slice(e)[0],n,s,r),l=o.dataSync();return"number"===a.type?l[0]:M(o.shape,l)}const i=t.attrParams[e];return i&&i.value}function gg(e,t,n,s){const[r,a]=xg(e);if(null!=s){const e=s.getHashTableHandleByName(r);if(null!=e)return e}const i=n.currentContextIds.find(e=>!!t[bg(r,e)]);return void 0!==i?t[bg(r,i)][a]:void 0}function yg(e,t){const[n,s]=xg(e);return[bg(n,t&&t.currentContextId),s]}function bg(e,t){return t?`${e}-${t}`:e}function xg(e){const t=e.split(":");return 1===t.length?[e,0]:[t[0],Number(t[t.length-1])]}function wg(e,t,n){let s=mg("pad",e,t,n);if("explicit"===s){s=mg("explicitPaddings",e,t,n);const r=[[0,0],[0,0],[0,0],[0,0]];for(let e=0;e<4;e++)r[e][0]=s[2*e],r[e][1]=s[2*e+1];return r}return s}function kg(e){return e.kept?e:Yt(e)}var vg=Object.freeze({__proto__:null,json:[{tfOpName:"Add",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddV2",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddN",category:"arithmetic",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"BiasAdd",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"Sub",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"RealDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Div",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"DivNoNan",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mul",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Maximum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Minimum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Pow",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SquaredDifference",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorMod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Ng=Object.freeze({__proto__:null,json:[{tfOpName:"Abs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan2",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ceil",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ClipByValue",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"clipValueMin",type:"number"},{start:2,name:"clipValueMax",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Complex",category:"basic_math",inputs:[{start:0,name:"real",type:"tensor"},{start:1,name:"imag",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ComplexAbs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Elu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Exp",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Floor",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Imag",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Neg",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Real",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Prelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"alpha",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu6",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Selu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sigmoid",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Rsqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Square",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sign",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Round",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Expm1",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log1p",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Reciprocal",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Softplus",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Erf",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Prod",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axes",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LeakyRelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"alpha",name:"alpha",type:"number",defaultValue:.2},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Ig=Object.freeze({__proto__:null,json:[{tfOpName:"EmptyTensorList",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"maxNumElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"LoopCond",category:"control",inputs:[{start:0,name:"pred",type:"tensor"}]},{tfOpName:"Switch",category:"control",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"pred",type:"tensor"}]},{tfOpName:"Merge",category:"control",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"Enter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"frame_name",name:"frameName",type:"string"},{tfName:"is_constant",name:"isConstant",type:"bool"}]},{tfOpName:"Exit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NextIteration",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayV3",category:"control",inputs:[{start:0,name:"size",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"dynamic_size",name:"dynamicSize",type:"bool"},{tfName:"clear_after_read",name:"clearAfterRead",type:"bool"},{tfName:"identical_element_shapes",name:"identicalElementShapes",type:"bool"},{tfName:"tensor_array_name",name:"name",type:"string"}]},{tfOpName:"TensorArrayWriteV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayReadV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayGatherV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"}]},{tfOpName:"TensorArrayScatterV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArrayConcatV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape_except0",name:"elementShapeExcept0",type:"shape",notSupported:!0}]},{tfOpName:"TensorArraySplitV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"tensor",type:"tensor"},{start:2,name:"lengths",type:"number[]"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArraySizeV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}]},{tfOpName:"TensorArrayCloseV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"}]},{tfOpName:"StatelessIf",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"If",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"StatelessWhile",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"While",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"TensorListScatter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListScatterV2",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"},{start:3,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGather",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListSetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListReserve",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListFromTensor",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListStack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"},{tfName:"num_elements",name:"numElements",type:"dtype"}]},{tfOpName:"TensorListSplit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"},{start:2,name:"lengths",type:"number[]"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListConcat",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}],attrs:[{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPopBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPushBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]}]});var Cg=Object.freeze({__proto__:null,json:[{tfOpName:"AvgPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[],notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPoolWithArgmax",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"include_batch_in_index",name:"includeBatchInIndex",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AvgPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Conv1D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"stride",name:"stride",type:"number"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NWC"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"dilation",name:"dilation",type:"number",defaultValue:1}]},{tfOpName:"Conv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"useCudnnOnGpu",name:"useCudnnOnGpu",type:"bool"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"_FusedConv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"use_cudnn_on_gpu",name:"useCudnnOnGpu",type:"bool",defaultValue:!0},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"leakyrelu_alpha",name:"leakyreluAlpha",type:"number"}]},{tfOpName:"Conv2DBackpropInput",category:"convolution",inputs:[{start:2,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:0,name:"outputShape",type:"number[]"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]",notSupported:!0}]},{tfOpName:"DepthwiseConv2d",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"DepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"FusedDepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]}]},{tfOpName:"Conv3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"Dilation2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"rates",name:"dilations",type:"number[]"},{tfName:"padding",name:"pad",type:"string"}]}]});var Sg=Object.freeze({__proto__:null,json:[{tfOpName:"Fill",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"},{start:1,name:"value",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"LinSpace",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"num",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"OneHot",category:"creation",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"depth",type:"number"},{start:2,name:"onValue",type:"number",defaultValue:1},{start:3,name:"offValue",type:"number",defaultValue:0}],attrs:[{tfName:"axis",name:"axis",type:"number",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ones",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"OnesLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"RandomUniform",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"minval",name:"minval",type:"number",defaultValue:0},{tfName:"maxval",name:"maxval",type:"number",defaultValue:1},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Range",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"step",type:"number",defaultValue:0}],attrs:[{tfName:"Tidx",name:"dtype",type:"dtype"}]},{tfOpName:"TruncatedNormal",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"means",name:"mean",type:"number",defaultValue:0},{tfName:"stddev",name:"stdDev",type:"number",defaultValue:1},{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Zeros",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"ZerosLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"Multinomial",category:"creation",inputs:[{start:0,name:"logits",type:"tensor"},{start:1,name:"numSamples",type:"number"}],attrs:[{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number"},{tfName:"T",name:"dtype",type:"dtype"},{tfName:"output_dtype",name:"output_dtype",type:"dtype"}]}]});var Tg=Object.freeze({__proto__:null,json:[{tfOpName:"NonMaxSuppressionV2",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV3",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV4",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"T_threshold",name:"threshold",type:"dtype",notSupported:!0},{tfName:"pad_to_max_output_size",name:"padToMaxOutputSize",type:"bool"}]},{tfOpName:"NonMaxSuppressionV5",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"},{start:5,name:"softNmsSigma",type:"number"}]},{tfOpName:"Where",category:"dynamic",inputs:[{start:0,name:"condition",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ListDiff",category:"dynamic",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Eg=Object.freeze({__proto__:null,json:[{tfOpName:"TopKV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"k",type:"number"}],attrs:[{tfName:"sorted",name:"sorted",type:"bool"}]},{tfOpName:"Unique",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"UniqueV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]}]});var $g=Object.freeze({__proto__:null,json:[{tfOpName:"PlaceholderWithDefault",category:"graph",inputs:[{start:0,name:"default",type:"tensor"}],attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Placeholder",category:"graph",attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Const",category:"graph"},{tfOpName:"Identity",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IdentityN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Snapshot",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Rank",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Size",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Shape",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"ShapeN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Print",category:"graph",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"data",type:"tensors"}],attrs:[{tfName:"message",name:"message",type:"string"},{tfName:"first_n",name:"firstN",type:"number",notSupported:!0},{tfName:"summarize",name:"summarize",type:"number",defaultValue:3}]},{tfOpName:"NoOp",category:"graph",inputs:[]},{tfOpName:"StopGradient",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"FakeQuantWithMinMaxVars",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"min",name:"min",type:"number"},{tfName:"max",name:"max",type:"number"}]}]});var Ag=Object.freeze({__proto__:null,json:[{tfOpName:"HashTable",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"HashTableV2",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"LookupTableImport",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableImportV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFind",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFindV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]}]});var Rg=Object.freeze({__proto__:null,json:[{tfOpName:"ResizeBilinear",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ResizeNearestNeighbor",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"CropAndResize",category:"image",inputs:[{start:0,name:"image",type:"tensor"},{start:1,name:"boxes",type:"tensor"},{start:2,name:"boxInd",type:"tensor"},{start:3,name:"cropSize",type:"number[]"}],attrs:[{tfName:"method",name:"method",type:"string"},{tfName:"extrapolation_value",name:"extrapolationValue",type:"number"}]}]});var Fg=Object.freeze({__proto__:null,json:[{tfOpName:"Equal",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NotEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Greater",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"GreaterEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Less",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LessEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalAnd",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalNot",category:"logical",inputs:[{start:0,name:"a",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalOr",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Select",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SelectV2",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Dg=Object.freeze({__proto__:null,json:[{tfOpName:"_FusedMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMulV2",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Transpose",category:"matrices",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"perm",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var _g=Object.freeze({__proto__:null,json:[{tfOpName:"FusedBatchNorm",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV2",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV3",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"LRN",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"depth_radius",name:"radius",type:"number",defaultValue:5},{tfName:"bias",name:"bias",type:"number",defaultValue:1},{tfName:"alpha",name:"alpha",type:"number",defaultValue:1},{tfName:"beta",name:"beta",type:"number",defaultValue:.5}]},{tfOpName:"Softmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"LogSoftmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"SparseToDense",category:"normalization",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!0,notSupported:!0}]}]});var Og=Object.freeze({__proto__:null,json:[{tfOpName:"Bincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}]},{tfOpName:"DenseBincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}],attrs:[{tfName:"binary_output",name:"binaryOutput",type:"bool"}]},{tfOpName:"Max",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Mean",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Min",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Sum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"All",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Any",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"ArgMax",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"ArgMin",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"Prod",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Cumsum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}],attrs:[{tfName:"exclusive",name:"exclusive",type:"bool"},{tfName:"reverse",name:"reverse",type:"bool"}]}]});var Mg=Object.freeze({__proto__:null,json:[{tfOpName:"ConcatV2",category:"slice_join",inputs:[{start:0,end:-1,name:"tensors",type:"tensors"},{start:-1,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"Concat",category:"slice_join",inputs:[{start:1,end:0,name:"tensors",type:"tensors"},{start:0,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"GatherV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"axis",type:"number",defaultValue:0}],attrs:[{tfName:"batch_dims",name:"batchDims",type:"number",defaultValue:0}]},{tfOpName:"Gather",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",notSupported:!0}]},{tfOpName:"Reverse",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"dims",type:"bool[]"}]},{tfOpName:"ReverseV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}]},{tfOpName:"Slice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"size",type:"number[]"}]},{tfOpName:"StridedSlice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"end",type:"number[]"},{start:3,name:"strides",type:"number[]"}],attrs:[{tfName:"begin_mask",name:"beginMask",type:"number",defaultValue:0},{tfName:"end_mask",name:"endMask",type:"number",defaultValue:0},{tfName:"new_axis_mask",name:"newAxisMask",type:"number",defaultValue:0},{tfName:"ellipsis_mask",name:"ellipsisMask",type:"number",defaultValue:0},{tfName:"shrink_axis_mask",name:"shrinkAxisMask",type:"number",defaultValue:0}]},{tfOpName:"Pack",category:"slice_join",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0}]},{tfOpName:"Unpack",category:"slice_join",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0},{tfName:"num",name:"num",type:"number",defaultValue:0,notSupported:!0}]},{tfOpName:"Tile",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"reps",type:"number[]"}]},{tfOpName:"Split",category:"slice_join",inputs:[{start:0,name:"axis",type:"number",defaultValue:0},{start:1,name:"x",type:"tensor"}],attrs:[{tfName:"num_split",name:"numOrSizeSplits",type:"number",defaultValue:1}]},{tfOpName:"SplitV",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"numOrSizeSplits",type:"number[]"},{start:2,name:"axis",type:"number",defaultValue:0}]},{tfOpName:"ScatterNd",category:"slice_join",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"values",type:"tensor"},{start:2,name:"shape",type:"number[]"}]},{tfOpName:"GatherNd",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}]},{tfOpName:"SparseToDense",category:"slice_join",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!1,notSupported:!0}]}]});var Lg=Object.freeze({__proto__:null,json:[{tfOpName:"FFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"RFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]},{tfOpName:"IRFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]}]});var zg=Object.freeze({__proto__:null,json:[{tfOpName:"Cast",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"SrcT",name:"sdtype",type:"dtype",notSupported:!0},{tfName:"DstT",name:"dtype",type:"dtype"}]},{tfOpName:"ExpandDims",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"MirrorPad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"mode",name:"mode",type:"string"}]},{tfOpName:"Pad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"constant_value",name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"PadV2",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"},{start:2,name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"Reshape",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}]},{tfOpName:"Squeeze",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"axis",tfDeprecatedName:"squeeze_dims",name:"axis",type:"number[]"}]},{tfOpName:"SpaceToBatchND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"paddings",type:"number[]"}]},{tfOpName:"BatchToSpaceND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"crops",type:"number[]"}]},{tfOpName:"DepthToSpace",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"block_size",name:"blockSize",type:"number"},{tfName:"data_format",name:"dataFormat",type:"string"}]},{tfOpName:"BroadcastTo",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}],attrs:[]}]});class Bg{static get Instance(){return this._instance||(this._instance=new this)}constructor(){const e=[].concat(...[vg,Ng,Ig,Cg,Sg,Tg,Eg,Fg,Rg,$g,Dg,_g,Og,Mg,Lg,zg,Ag].map(e=>e.json));this.opMappers=e.reduce((e,t)=>(e[t.tfOpName]=t,e),{})}transformGraph(e,t={}){const n=e.node,s=[],r=[],a=[],i=n.reduce((e,t)=>(e[t.name]=this.mapNode(t),t.op.startsWith("Placeholder")?s.push(e[t.name]):"Const"===t.op?r.push(e[t.name]):null!=t.input&&0!==t.input.length||a.push(e[t.name]),e),{});let o=[];const l=[];let u={},c={};null!=t&&(u=this.mapSignatureEntries(t.inputs),c=this.mapSignatureEntries(t.outputs));const h=Object.keys(i);h.forEach(e=>{const t=i[e];t.inputNames.forEach(e=>{const[n]=yg(e);t.inputs.push(i[n]),i[n].children.push(t)})}),0===Object.keys(c).length?h.forEach(e=>{const t=i[e];0===t.children.length&&l.push(t)}):Object.keys(c).forEach(e=>{const[t]=yg(e),n=i[t];null!=n&&(n.signatureKey=c[e],l.push(n))}),Object.keys(u).length>0?Object.keys(u).forEach(e=>{const[t]=yg(e),n=i[t];n&&(n.signatureKey=u[e],o.push(n))}):o=s;let p={};null!=e.library&&null!=e.library.function&&(p=e.library.function.reduce((e,t)=>(e[t.signature.name]=this.mapFunction(t),e),{}));const d={nodes:i,inputs:o,outputs:l,weights:r,placeholders:s,signature:t,functions:p};return a.length>0&&(d.initNodes=a),d}mapSignatureEntries(e){return Object.keys(e||{}).reduce((t,n)=>(t[e[n].name]=n,t),{})}mapNode(e){const t=fg(e.op)||this.opMappers[e.op]||{};null==e.attr&&(e.attr={});const n={name:e.name,op:e.op,category:t.category,inputNames:(e.input||[]).map(e=>e.startsWith("^")?e.substr(1):e),inputs:[],children:[],inputParams:{},attrParams:{},rawAttrs:e.attr};return null!=t.inputs&&(n.inputParams=t.inputs.reduce((e,t)=>(e[t.name]={type:t.type,inputIndexStart:t.start,inputIndexEnd:t.end},e),{})),null!=t.attrs&&(n.attrParams=t.attrs.reduce((t,n)=>{const s=n.type;let r=void 0;switch(n.type){case"string":r=Wg(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Wg(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"string[]":r=Jg(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Jg(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number":r=Ug(e.attr,n.tfName,n.defaultValue||0),void 0===r&&n.tfDeprecatedName&&(r=Ug(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number[]":r=Yg(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Yg(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool":r=Vg(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Vg(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool[]":r=Qg(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Qg(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape":r=Xg(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Xg(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape[]":r=Zg(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Zg(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype":r=jg(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=jg(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype[]":r=qg(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=qg(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"func":r=Hg(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Hg(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"tensor":case"tensors":break;default:throw new Error(`Unsupported param type: ${n.type} for op: ${e.op}`)}return t[n.name]={value:r,type:s},t},{})),n}mapFunction(e){const t=e.nodeDef,n=[];let s={};null!=t&&(s=t.reduce((e,t)=>(e[t.name]=this.mapNode(t),"Const"===t.op&&n.push(e[t.name]),e),{}));const r=[],a=[];e.signature.inputArg.forEach(e=>{const[t]=yg(e.name),n={name:t,op:"Placeholder",inputs:[],inputNames:[],category:"graph",inputParams:{},attrParams:{dtype:{value:Gg(e.type),type:"dtype"}},children:[]};n.signatureKey=e.name,r.push(n),s[t]=n}),Object.keys(s).forEach(e=>{const t=s[e];t.inputNames.forEach(e=>{const[n]=yg(e);t.inputs.push(s[n]),s[n].children.push(t)})});const i=e.ret;e.signature.outputArg.forEach(e=>{const[t,n]=yg(i[e.name]),r=s[t];null!=r&&(r.defaultOutput=n,a.push(r))});const o=this.mapArgsToSignature(e);return{nodes:s,inputs:r,outputs:a,weights:n,placeholders:[],signature:o}}mapArgsToSignature(e){return{methodName:e.signature.name,inputs:e.signature.inputArg.reduce((e,t)=>(e[t.name]=this.mapArgToTensorInfo(t),e),{}),outputs:e.signature.outputArg.reduce((t,n)=>(t[n.name]=this.mapArgToTensorInfo(n,e.ret),t),{})}}mapArgToTensorInfo(e,t){let n=e.name;return null!=t&&(n=t[n]),{name:n,dtype:e.type}}}function Pg(e,t){const n=Array.isArray(e)?String.fromCharCode.apply(null,e):function(e){const t=H().global;if(void 0!==t.atob)return t.atob(e);if("undefined"!=typeof Buffer)return new Buffer(e,"base64").toString();throw new Error("Unable to decode base64 in this environment. Missing built-in atob() or Buffer()")}(e);return t?n:n.toLowerCase()}function Wg(e,t,n,s=!1){const r=e[t];return null!=r?Pg(r.s,s):n}function Vg(e,t,n){const s=e[t];return s?s.b:n}function Ug(e,t,n){const s=e[t]||{},r=null!=s.i?s.i:null!=s.f?s.f:n;return"number"==typeof r?r:parseInt(r,10)}function Gg(e){switch("string"==typeof e&&(e=hg[e]),e){case hg.DT_FLOAT:return"float32";case hg.DT_INT32:case hg.DT_INT64:case hg.DT_INT8:case hg.DT_UINT8:return"int32";case hg.DT_BOOL:return"bool";case hg.DT_DOUBLE:return"float32";case hg.DT_STRING:return"string";default:return null}}function Hg(e,t,n){const s=e[t];return s&&s.func?s.func.name:n}function jg(e,t,n){const s=e[t];return s&&s.type?Gg(s.type):n}function qg(e,t,n){const s=e[t];return s&&s.list&&s.list.type?s.list.type.map(e=>Gg(e)):n}function Kg(e){if(!e.unknownRank)return null!=e.dim?e.dim.map(e=>"number"==typeof e.size?e.size:parseInt(e.size,10)):[]}function Xg(e,t,n){const s=e[t];return s&&s.shape?Kg(s.shape):n}function Yg(e,t,n){const s=e[t];return s?((s.list.f&&s.list.f.length?s.list.f:s.list.i)||[]).map(e=>"number"==typeof e?e:parseInt(e,10)):n}function Jg(e,t,n,s=!1){const r=e[t];return r&&r.list&&r.list.s?r.list.s.map(e=>Pg(e,s)):n}function Zg(e,t,n){const s=e[t];return s&&s.list&&s.list.shape?s.list.shape.map(e=>Kg(e)):n}function Qg(e,t,n){const s=e[t];return s&&s.list&&s.list.b?s.list.b:n}class ey{constructor(e,t,n){this.node=e,this.tensorMap=t,this.context=n,this.inputs=[],this.attrs={},this.inputs=e.inputNames.map(e=>this.getInput(e)),null!=e.rawAttrs&&(this.attrs=Object.keys(e.rawAttrs).reduce((e,t)=>(e[t]=this.getAttr(t),e),{}))}getInput(e){return gg(e,this.tensorMap,this.context)}getAttr(e,t){const n=this.node.rawAttrs[e];if(null!=n.tensor)return gg(e,this.tensorMap,this.context);if(null!=n.i||null!=n.f)return Ug(this.node.rawAttrs,e,t);if(null!=n.s)return Wg(this.node.rawAttrs,e,t);if(null!=n.b)return Vg(this.node.rawAttrs,e,t);if(null!=n.shape)return Xg(this.node.rawAttrs,e,t);if(null!=n.type)return jg(this.node.rawAttrs,e,t);if(null!=n.list){if(null!=n.list.i||null!=n.list.f)return Yg(this.node.rawAttrs,e,t);if(null!=n.list.s)return Jg(this.node.rawAttrs,e,t);if(null!=n.list.shape)return Zg(this.node.rawAttrs,e,t);if(null!=n.list.b)return Qg(this.node.rawAttrs,e,t);if(null!=n.list.type)return qg(this.node.rawAttrs,e,t)}return t}}function ty(e,t,n=""){l(function(e,t){if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(-1!==e[n]&&-1!==t[n]&&e[n]!==t[n])return!1;return!0}(e,t),()=>n+` Shapes ${e} and ${t} must match`)}class ny{constructor(e,t,n,s,r,a,i){this.name=e,this.dtype=t,this.maxSize=n,this.elementShape=s,this.identicalElementShapes=r,this.dynamicSize=a,this.clearAfterRead=i,this.tensors=[],this.closed_=!1,this.idTensor=Ii(0),is(this.idTensor)}get id(){return this.idTensor.id}get closed(){return this.closed_}clearAndClose(e){this.tensors.forEach(t=>{null!=e&&e.has(t.tensor.id)||t.tensor.dispose()}),this.tensors=[],this.closed_=!0,this.idTensor.dispose()}size(){return this.tensors.length}read(e){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||e>=this.size())throw new Error(`Tried to read from index ${e}, but array size is: ${this.size()}`);const t=this.tensors[e];if(t.cleared)throw new Error(`TensorArray ${this.name}: Could not read index ${e} twice because it was cleared after a previous read (perhaps try setting clear_after_read = false?).`);return this.clearAfterRead&&(t.cleared=!0),t.read=!0,t.tensor}readMany(e){return e.map(e=>this.read(e))}write(e,t){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||!this.dynamicSize&&e>=this.maxSize)throw new Error(`Tried to write to index ${e}, but array is not resizeable and size is: ${this.maxSize}`);const n=this.tensors[e]||{};if(t.dtype!==this.dtype)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e},\n          because the value dtype is ${t.dtype}, but TensorArray dtype is ${this.dtype}.`);if(0!==this.size()||null!=this.elementShape&&0!==this.elementShape.length||(this.elementShape=t.shape),ty(this.elementShape,t.shape,`TensorArray ${this.name}: Could not write to TensorArray index ${e}.`),n.read)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been read.`);if(n.written)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been written.`);n.tensor=t,is(t),n.written=!0,this.tensors[e]=n}writeMany(e,t){if(e.length!==t.length)throw new Error(`TensorArray ${this.name}: could not write multiple tensors,because the index size: ${e.length} is not the same as tensors size: ${t.length}.`);e.forEach((e,n)=>this.write(e,t[n]))}gather(e,t){if(t&&t!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but gather requested dtype ${t}`);if(e)e=e.slice(0,this.size());else{e=[];for(let t=0;t<this.size();t++)e.push(t)}if(0===e.length)return ht([],[0].concat(this.elementShape));const n=this.readMany(e);return ty(this.elementShape,n[0].shape,"TensorArray shape mismatch: "),Gi(n,0)}concat(e){if(e&&e!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but concat requested dtype ${e}`);if(0===this.size())return ht([],[0].concat(this.elementShape));const t=[];for(let e=0;e<this.size();e++)t.push(e);const n=this.readMany(t);return ty(this.elementShape,n[0].shape,`TensorArray shape mismatch: tensor array shape (${this.elementShape}) vs first tensor shape (${n[0].shape})`),Us(n,0)}scatter(e,t){if(t.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);if(e.length!==t.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${e.length} vs. ${t.shape[0]}`);const n=Math.max(...e);if(!this.dynamicSize&&n>=this.maxSize)throw new Error(`Max index must be < array size (${n}  vs. ${this.maxSize})`);this.writeMany(e,eo(t,0))}split(e,t){if(t.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);let n=0;const s=e.map(e=>(n+=e,n));if(n!==t.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${n}, and tensor's shape is: ${t.shape}`);if(!this.dynamicSize&&e.length!==this.maxSize)throw new Error(`TensorArray's size is not equal to the size of lengths (${this.maxSize} vs. ${e.length}), and the TensorArray is not marked as dynamically resizeable`);const r=0===n?0:t.size/n,a=[];rs(()=>{t=Ps(t,[1,n,r]);for(let n=0;n<e.length;++n){const i=[0,0===n?0:s[n-1],0],o=[1,e[n],r];a[n]=Ps(Hs(t,i,o),this.elementShape)}return a});const i=[];for(let t=0;t<e.length;t++)i[t]=t;this.writeMany(i,a)}}class sy{constructor(e,t,n,s=-1){this.tensors=e,this.elementShape=t,this.elementDtype=n,null!=e&&e.forEach(e=>{if(n!==e.dtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${e.dtype}`);ty(t,e.shape,"TensorList shape mismatch: "),is(e)}),this.idTensor=Ii(0),this.maxNumElements=s,is(this.idTensor)}get id(){return this.idTensor.id}copy(){return new sy([...this.tensors],this.elementShape,this.elementDtype)}clearAndClose(e){this.tensors.forEach(t=>{null!=e&&e.has(t.id)||t.dispose()}),this.tensors.length=0,this.idTensor.dispose()}size(){return this.tensors.length}stack(e,t,n=-1){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);if(-1!==n&&this.tensors.length!==n)throw new Error(`Operation expected a list with ${n} elements but got a list with ${this.tensors.length} elements.`);return ty(e,this.elementShape,"TensorList shape mismatch: "),rs(()=>{const t=this.tensors.map(t=>Ps(t,e));return Gi(t,0)})}popBack(e,t){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);if(0===this.size())throw new Error("Trying to pop from an empty list.");const n=this.tensors.pop();return ty(n.shape,e,"TensorList shape mismatch: "),Ps(n,e)}pushBack(e){if(e.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${this.elementDtype}`);if(ty(e.shape,this.elementShape,"TensorList shape mismatch: "),this.maxNumElements===this.size())throw new Error("Trying to push element into a full list.");is(e),this.tensors.push(e)}resize(e){if(e<0)throw new Error("TensorListResize expects size to be non-negative. Got: "+e);if(-1!==this.maxNumElements&&e>this.maxNumElements)throw new Error(`TensorListResize input size ${e} is greater maxNumElement ${this.maxNumElements}.`);this.tensors.length=e}getItem(e,t,n){if(n!==this.elementDtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${this.elementDtype}`);if(e<0||e>this.tensors.length)throw new Error(`Trying to access element ${e} in a list with ${this.tensors.length} elements.`);if(null==this.tensors[e])throw new Error(`element at index ${e} is null.`);return ty(this.tensors[e].shape,t,"TensorList shape mismatch: "),this.tensors[e]}setItem(e,t){if(t.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t.dtype}, but list elements ${this.elementDtype}`);if(e<0||-1!==this.maxNumElements&&e>=this.maxNumElements)throw new Error(`Trying to set element ${e} in a list with max ${this.maxNumElements} elements.`);ty(this.elementShape,t.shape,"TensorList shape mismatch: "),is(t),this.tensors[e]=t}gather(e,t,n){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);return ty(this.elementShape,n,"TensorList shape mismatch: "),0===(e=e.slice(0,this.size())).length?ht([],[0].concat(this.elementShape)):rs(()=>{const t=e.map(e=>Ps(this.tensors[e],n));return Gi(t,0)})}concat(e,t){if(e&&e!==this.elementDtype)throw new Error(`TensorList dtype is ${this.elementDtype} but concat requested dtype ${e}`);return ty(this.elementShape,t,"TensorList shape mismatch: "),0===this.size()?ht([],[0].concat(this.elementShape)):rs(()=>{const e=this.tensors.map(e=>Ps(e,t));return Us(e,0)})}}const ry=async(e,t,n)=>{switch(e.op){case"If":case"StatelessIf":{const s=mg("thenBranch",e,t,n),r=mg("elseBranch",e,t,n),a=mg("cond",e,t,n),i=mg("args",e,t,n);return(await a.data())[0]?n.functionMap[s].executeFunctionAsync(i,n.tensorArrayMap,n.tensorListMap):n.functionMap[r].executeFunctionAsync(i,n.tensorArrayMap,n.tensorListMap)}case"While":case"StatelessWhile":{const s=mg("body",e,t,n),r=mg("cond",e,t,n),a=mg("args",e,t,n),i=await n.functionMap[r].executeFunctionAsync(a,n.tensorArrayMap,n.tensorListMap),o=a.map(e=>e.id);let l=await i[0].data();i.forEach(e=>{e.kept||-1!==o.indexOf(e.id)||e.dispose()});let u=a;for(;l[0];){const e=u;u=await n.functionMap[s].executeFunctionAsync(u,n.tensorArrayMap,n.tensorListMap);const t=u.map(e=>e.id);e.forEach(e=>{e.kept||-1!==o.indexOf(e.id)||-1!==t.indexOf(e.id)||e.dispose()});const a=await n.functionMap[r].executeFunctionAsync(u,n.tensorArrayMap,n.tensorListMap);l=await a[0].data(),a.forEach(e=>{e.kept||-1!==o.indexOf(e.id)||-1!==t.indexOf(e.id)||e.dispose()})}return u}case"LoopCond":return[kg(mg("pred",e,t,n))];case"Switch":{const s=mg("pred",e,t,n);let r=mg("data",e,t,n);return r.kept||(r=kg(r)),(await s.data())[0]?[void 0,r]:[r,void 0]}case"Merge":{const s=e.inputNames.find(e=>void 0!==gg(e,t,n));if(s){return[kg(gg(s,t,n))]}return}case"Enter":{const s=mg("frameName",e,t,n),r=mg("tensor",e,t,n);return n.enterFrame(s),[kg(r)]}case"Exit":{const s=mg("tensor",e,t,n);return n.exitFrame(),[kg(s)]}case"NextIteration":{const s=mg("tensor",e,t,n);return n.nextIteration(),[kg(s)]}case"TensorArrayV3":{const s=mg("size",e,t,n),r=mg("dtype",e,t,n),a=mg("elementShape",e,t,n),i=mg("dynamicSize",e,t,n),o=mg("clearAfterRead",e,t,n),l=mg("identicalElementShapes",e,t,n),u=mg("name",e,t,n),c=new ny(u,r,s,a,l,i,o);return n.addTensorArray(c),[c.idTensor,Ii(1)]}case"TensorArrayWriteV3":{const s=mg("tensorArrayId",e,t,n),r=mg("index",e,t,n),a=mg("tensor",e,t,n),i=n.getTensorArray(s.id);return i.write(r,a),[i.idTensor]}case"TensorArrayReadV3":{const s=mg("tensorArrayId",e,t,n),r=mg("index",e,t,n);return[n.getTensorArray(s.id).read(r)]}case"TensorArrayGatherV3":{const s=mg("tensorArrayId",e,t,n),r=mg("indices",e,t,n),a=mg("dtype",e,t,n);return[n.getTensorArray(s.id).gather(r,a)]}case"TensorArrayScatterV3":{const s=mg("tensorArrayId",e,t,n),r=mg("indices",e,t,n),a=mg("tensor",e,t,n),i=n.getTensorArray(s.id);return i.scatter(r,a),[i.idTensor]}case"TensorArrayConcatV3":{const s=mg("tensorArrayId",e,t,n),r=n.getTensorArray(s.id),a=mg("dtype",e,t,n);return[r.concat(a)]}case"TensorArraySplitV3":{const s=mg("tensorArrayId",e,t,n),r=mg("tensor",e,t,n),a=mg("lengths",e,t,n),i=n.getTensorArray(s.id);return i.split(a,r),[i.idTensor]}case"TensorArraySizeV3":{const s=mg("tensorArrayId",e,t,n);return[Ii(n.getTensorArray(s.id).size(),"int32")]}case"TensorArrayCloseV3":{const s=mg("tensorArrayId",e,t,n),r=n.getTensorArray(s.id);return r.clearAndClose(),[r.idTensor]}case"TensorListSetItem":{const s=mg("tensorListId",e,t,n),r=mg("index",e,t,n),a=mg("tensor",e,t,n),i=n.getTensorList(s.id);return i.setItem(r,a),[i.idTensor]}case"TensorListGetItem":{const s=mg("tensorListId",e,t,n),r=mg("index",e,t,n),a=mg("elementShape",e,t,n),i=mg("elementDType",e,t,n);return[n.getTensorList(s.id).getItem(r,a,i)]}case"TensorListScatterV2":case"TensorListScatter":{const s=mg("indices",e,t,n),r=function(e,t,n,s){if(t.length!==e.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${t.length} vs. ${e.shape[0]}`);const r=Math.max(...t);if(null!=s&&-1!==s&&r>=s)throw new Error(`Max index must be < array size (${r}  vs. ${s})`);const a=new sy([],n,e.dtype,s),i=eo(e,0);return t.forEach((e,t)=>{a.setItem(e,i[t])}),a}(mg("tensor",e,t,n),s,mg("elementShape",e,t,n),mg("numElements",e,t,n));return n.addTensorList(r),[r.idTensor]}case"TensorListReserve":case"EmptyTensorList":{const s=mg("elementShape",e,t,n),r=mg("elementDType",e,t,n);let a;a="TensorListReserve"===e.op?"numElements":"maxNumElements";const i=function(e,t,n){return new sy([],e,t,n)}(s,r,mg(a,e,t,n));return n.addTensorList(i),[i.idTensor]}case"TensorListGather":{const s=mg("tensorListId",e,t,n),r=mg("indices",e,t,n),a=mg("elementShape",e,t,n),i=mg("elementDType",e,t,n);return[n.getTensorList(s.id).gather(r,i,a)]}case"TensorListStack":{const s=mg("tensorListId",e,t,n),r=mg("elementShape",e,t,n),a=mg("elementDType",e,t,n),i=mg("numElements",e,t,n);return[n.getTensorList(s.id).stack(r,a,i)]}case"TensorListFromTensor":{const s=function(e,t,n){const s=e.dtype;if(e.shape.length<1)throw new Error("Tensor must be at least a vector, but saw shape: "+e.shape);if(e.dtype!==n)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${n}`);ty(e.shape.slice(1),t,"TensorList shape mismatch: ");const r=eo(e);return new sy(r,t,s)}(mg("tensor",e,t,n),mg("elementShape",e,t,n),mg("elementDType",e,t,n));return n.addTensorList(s),[s.idTensor]}case"TensorListConcat":{const s=mg("tensorListId",e,t,n),r=n.getTensorList(s.id),a=mg("dtype",e,t,n),i=mg("elementShape",e,t,n);return[r.concat(a,i)]}case"TensorListPushBack":{const s=mg("tensorListId",e,t,n),r=mg("tensor",e,t,n),a=n.getTensorList(s.id);return a.pushBack(r),[a.idTensor]}case"TensorListPopBack":{const s=mg("tensorListId",e,t,n),r=mg("elementShape",e,t,n),a=mg("elementDType",e,t,n);return[n.getTensorList(s.id).popBack(r,a)]}case"TensorListSplit":{const s=mg("tensor",e,t,n),r=mg("elementShape",e,t,n),a=function(e,t,n){let s=0;const r=t.map(e=>(s+=e,s));if(s!==e.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${s}, and tensor's shape is: ${e.shape}`);const a=0===s?0:e.size/s,i=rs(()=>{const i=[];e=Ps(e,[1,s,a]);for(let s=0;s<t.length;++s){const o=[0,0===s?0:r[s-1],0],l=[1,t[s],a];i[s]=Ps(Hs(e,o,l),n)}return e.dispose(),i}),o=new sy([],n,e.dtype,t.length);for(let e=0;e<i.length;e++)o.setItem(e,i[e]);return o}(s,mg("lengths",e,t,n),r);return n.addTensorList(a),[a.idTensor]}default:throw TypeError(`Node type ${e.op} is not implemented`)}};function ay(e,t,n){const[s,r]=mg("fusedOps",e,t,n),a="biasadd"===s,i="prelu"===r,o="fusedbatchnorm"===s,l=mg("numArgs",e,t,n);if(a){if(i&&2!==l)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!i&&1!==l)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd must have one extra argument: bias.")}if(o)throw new Error("FusedConv2d and DepthwiseConv2d with FusedBatchNorm is not supported.");const u=mg("strides",e,t,n),c=wg(e,t,n),h=mg("dataFormat",e,t,n).toUpperCase(),p=mg("dilations",e,t,n),[d,f]=mg("args",e,t,n);return{stride:u,pad:c,dataFormat:h,dilations:p,biasArg:d,preluArg:f,activationFunc:r,leakyreluAlpha:mg("leakyreluAlpha",e,t,n)}}function iy(e,t,n){return{boxes:mg("boxes",e,t,n),scores:mg("scores",e,t,n),maxOutputSize:mg("maxOutputSize",e,t,n),iouThreshold:mg("iouThreshold",e,t,n),scoreThreshold:mg("scoreThreshold",e,t,n),softNmsSigma:mg("softNmsSigma",e,t,n)}}class oy{constructor(e,t){this.keyDType=e,this.valueDType=t,this.handle=Ii(0),this.tensorMap=new Map,is(this.handle)}get id(){return this.handle.id}clearAndClose(){this.tensorMap.forEach(e=>e.dispose()),this.tensorMap.clear(),this.handle.dispose()}size(){return this.tensorMap.size}async import(e,t){this.checkKeyAndValueTensor(e,t);const n=await e.data();return this.tensorMap.forEach(e=>e.dispose()),this.tensorMap.clear(),rs(()=>{const e=eo(t),s=n.length,r=e.length;l(s===r,()=>`The number of elements doesn't match, keys has ${s} elements, the values has ${r} elements.`);for(let t=0;t<s;t++){const s=n[t],r=e[t];is(r),this.tensorMap.set(s,r)}return this.handle})}async find(e,t){this.checkKeyAndValueTensor(e,t);const n=await e.data();return rs(()=>{const e=[];for(let s=0;s<n.length;s++){const r=n[s],a=this.findWithDefault(r,t);e.push(a)}return Gi(e)})}findWithDefault(e,t){const n=this.tensorMap.get(e);return null!=n?n:t}checkKeyAndValueTensor(e,t){if(e.dtype!==this.keyDType)throw new Error(`Expect key dtype ${this.keyDType}, but got `+e.dtype);if(t.dtype!==this.valueDType)throw new Error(`Expect value dtype ${this.valueDType}, but got `+t.dtype)}}function ly(e,t,n,s){const r=((e,t,n)=>{switch(e.category){case"arithmetic":return rs(()=>((e,t,n)=>{switch(e.op){case"BiasAdd":case"AddV2":case"Add":return[cs(mg("a",e,t,n),mg("b",e,t,n))];case"AddN":return[ys(mg("tensors",e,t,n))];case"FloorMod":case"Mod":return[Aa(mg("a",e,t,n),mg("b",e,t,n))];case"Mul":return[ds(mg("a",e,t,n),mg("b",e,t,n))];case"RealDiv":case"Div":return[ps(mg("a",e,t,n),mg("b",e,t,n))];case"DivNoNan":return[Er(mg("a",e,t,n),mg("b",e,t,n))];case"FloorDiv":return[hs(mg("a",e,t,n),mg("b",e,t,n))];case"Sub":return[ia(mg("a",e,t,n),mg("b",e,t,n))];case"Minimum":return[Ea(mg("a",e,t,n),mg("b",e,t,n))];case"Maximum":return[Ca(mg("a",e,t,n),mg("b",e,t,n))];case"Pow":return[qa(mg("a",e,t,n),mg("b",e,t,n))];case"SquaredDifference":return[Vi(mg("a",e,t,n),mg("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"basic_math":return rs(()=>((e,t,n)=>{switch(e.op){case"Abs":case"ComplexAbs":return[fs(mg("x",e,t,n))];case"Acos":return[ms(mg("x",e,t,n))];case"Acosh":return[gs(mg("x",e,t,n))];case"Asin":return[vs(mg("x",e,t,n))];case"Asinh":return[Ns(mg("x",e,t,n))];case"Atan":return[Is(mg("x",e,t,n))];case"Atan2":return[Cs(mg("x",e,t,n),mg("y",e,t,n))];case"Atanh":return[Ss(mg("x",e,t,n))];case"Ceil":return[tr(mg("x",e,t,n))];case"Complex":return[ut(mg("real",e,t,n),mg("imag",e,t,n))];case"Cos":return[fr(mg("x",e,t,n))];case"Cosh":return[mr(mg("x",e,t,n))];case"Elu":return[Ar(mg("x",e,t,n))];case"Erf":return[Rr(mg("x",e,t,n))];case"Exp":return[Fr(mg("x",e,t,n))];case"Expm1":return[_r(mg("x",e,t,n))];case"Floor":return[zr(mg("x",e,t,n))];case"Log":return[Jr(mg("x",e,t,n))];case"Log1p":return[Zr(mg("x",e,t,n))];case"Imag":return[Vr(mg("x",e,t,n))];case"Neg":return[na(mg("x",e,t,n))];case"Reciprocal":return[fi(mg("x",e,t,n))];case"Real":return[di(mg("x",e,t,n))];case"Relu":return[mi(mg("x",e,t,n))];case"Round":return[vi(mg("x",e,t,n))];case"Selu":return[Ci(mg("x",e,t,n))];case"Sigmoid":return[Gs(mg("x",e,t,n))];case"Sin":return[$i(mg("x",e,t,n))];case"Sign":return[Ei(mg("x",e,t,n))];case"Sinh":return[Ai(mg("x",e,t,n))];case"Softplus":return[sa(mg("x",e,t,n))];case"Sqrt":return[Wi(mg("x",e,t,n))];case"Square":return[Ra(mg("x",e,t,n))];case"Tanh":return[js(mg("x",e,t,n))];case"Tan":return[qi(mg("x",e,t,n))];case"ClipByValue":return[nr(mg("x",e,t,n),mg("clipValueMin",e,t,n),mg("clipValueMax",e,t,n))];case"Relu6":return[gi(mg("x",e,t,n))];case"Rsqrt":return[Ni(gg(e.inputNames[0],t,n))];case"Prod":return[Xa(mg("x",e,t,n),mg("axes",e,t,n))];case"LeakyRelu":return[jr(mg("x",e,t,n),mg("alpha",e,t,n))];case"Prelu":return[Ka(mg("x",e,t,n),mg("alpha",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"control":return ry(e,t,n);case"convolution":return rs(()=>((e,t,n)=>{switch(e.op){case"Conv1D":{const s=mg("stride",e,t,n),r=mg("pad",e,t,n),a=mg("dataFormat",e,t,n).toUpperCase(),i=mg("dilation",e,t,n);return[lr(mg("x",e,t,n),mg("filter",e,t,n),s,r,a,i)]}case"Conv2D":{const s=mg("strides",e,t,n),r=wg(e,t,n),a=mg("dataFormat",e,t,n).toUpperCase(),i=mg("dilations",e,t,n);return[or(mg("x",e,t,n),mg("filter",e,t,n),[s[1],s[2]],r,a,[i[1],i[2]])]}case"_FusedConv2D":{const{stride:s,pad:r,dataFormat:a,dilations:i,biasArg:o,preluArg:l,activationFunc:u,leakyreluAlpha:c}=ay(e,t,n);return[wo({x:mg("x",e,t,n),filter:mg("filter",e,t,n),strides:[s[1],s[2]],pad:r,dataFormat:a,dilations:[i[1],i[2]],bias:o,activation:u,preluActivationWeights:l,leakyreluAlpha:c})]}case"FusedDepthwiseConv2dNative":{const{stride:s,pad:r,dataFormat:a,dilations:i,biasArg:o,preluArg:l,activationFunc:u,leakyreluAlpha:c}=ay(e,t,n);return[No({x:mg("x",e,t,n),filter:mg("filter",e,t,n),strides:[s[1],s[2]],pad:r,dataFormat:a,dilations:[i[1],i[2]],bias:o,activation:u,preluActivationWeights:l,leakyreluAlpha:c})]}case"Conv2DBackpropInput":case"Conv2dTranspose":{const s=mg("outputShape",e,t,n),r=mg("strides",e,t,n),a=wg(e,t,n);return[cr(mg("x",e,t,n),mg("filter",e,t,n),s,[r[1],r[2]],a)]}case"DepthwiseConv2dNative":case"DepthwiseConv2d":{const s=mg("strides",e,t,n),r=wg(e,t,n),a=mg("dilations",e,t,n),i=mg("dataFormat",e,t,n).toUpperCase();return[xr(mg("input",e,t,n),mg("filter",e,t,n),[s[1],s[2]],r,i,[a[1],a[2]])]}case"Conv3D":{const s=mg("strides",e,t,n),r=mg("pad",e,t,n),a=mg("dataFormat",e,t,n).toUpperCase(),i=mg("dilations",e,t,n);return[hr(mg("x",e,t,n),mg("filter",e,t,n),[s[1],s[2],s[3]],r,a,[i[1],i[2],i[3]])]}case"AvgPool":{const s=mg("strides",e,t,n),r=mg("pad",e,t,n),a=mg("kernelSize",e,t,n);return[Ws(mg("x",e,t,n),[a[1],a[2]],[s[1],s[2]],r)]}case"MaxPool":{const s=mg("strides",e,t,n),r=mg("pad",e,t,n),a=mg("kernelSize",e,t,n);return[va(mg("x",e,t,n),[a[1],a[2]],[s[1],s[2]],r)]}case"MaxPoolWithArgmax":{const s=mg("strides",e,t,n),r=mg("pad",e,t,n),a=mg("kernelSize",e,t,n),i=mg("includeBatchInIndex",e,t,n),{result:o,indexes:l}=Ia(mg("x",e,t,n),[a[1],a[2]],[s[1],s[2]],r,i);return[o,l]}case"AvgPool3D":{const s=mg("strides",e,t,n),r=mg("pad",e,t,n),a=mg("kernelSize",e,t,n);return[Vs(mg("x",e,t,n),[a[1],a[2],a[3]],[s[1],s[2],s[3]],r)]}case"MaxPool3D":{const s=mg("strides",e,t,n),r=mg("pad",e,t,n),a=mg("kernelSize",e,t,n);return[Na(mg("x",e,t,n),[a[1],a[2],a[3]],[s[1],s[2],s[3]],r)]}case"Dilation2D":{const s=mg("strides",e,t,n),r=mg("pad",e,t,n),a=mg("dilations",e,t,n),i=s[1],o=s[2],l=a[1],u=a[2];return[kr(mg("x",e,t,n),mg("filter",e,t,n),[i,o],r,[l,u],"NHWC")]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"creation":return rs(()=>((e,t,n)=>{switch(e.op){case"Fill":{const s=mg("shape",e,t,n),r=mg("dtype",e,t,n);return[Lr(s,mg("value",e,t,n),r)]}case"LinSpace":return[Xr(mg("start",e,t,n),mg("stop",e,t,n),mg("num",e,t,n))];case"Multinomial":{const s=mg("logits",e,t,n),r=mg("numSamples",e,t,n),a=mg("seed",e,t,n);return[_a(s,r,a)]}case"OneHot":{const s=mg("indices",e,t,n),r=mg("depth",e,t,n),a=mg("onValue",e,t,n),i=mg("offValue",e,t,n);return[mn(s,r,a,i)]}case"Ones":return[La(mg("shape",e,t,n),mg("dtype",e,t,n))];case"OnesLike":return[za(mg("x",e,t,n))];case"RandomUniform":return[hi(mg("shape",e,t,n),mg("minval",e,t,n),mg("maxval",e,t,n),mg("dtype",e,t,n))];case"Range":return[pi(mg("start",e,t,n),mg("stop",e,t,n),mg("step",e,t,n),mg("dtype",e,t,n))];case"TruncatedNormal":{const s=mg("shape",e,t,n),r=mg("mean",e,t,n),a=mg("stdDev",e,t,n),i=mg("seed",e,t,n);return[Ji(s,r,a,mg("dtype",e,t,n),i)]}case"Zeros":return[Ma(mg("shape",e,t,n),mg("dtype",e,t,n))];case"ZerosLike":return[Tr(mg("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"dynamic":return(async(e,t,n)=>{switch(e.op){case"NonMaxSuppressionV5":{const{boxes:s,scores:r,maxOutputSize:a,iouThreshold:i,scoreThreshold:o,softNmsSigma:l}=iy(e,t,n),u=await dl.nonMaxSuppressionWithScoreAsync(s,r,a,i,o,l);return[u.selectedIndices,u.selectedScores]}case"NonMaxSuppressionV4":{const{boxes:s,scores:r,maxOutputSize:a,iouThreshold:i,scoreThreshold:o}=iy(e,t,n),l=mg("padToMaxOutputSize",e,t,n),u=await dl.nonMaxSuppressionPaddedAsync(s,r,a,i,o,l);return[u.selectedIndices,u.validOutputs]}case"NonMaxSuppressionV3":case"NonMaxSuppressionV2":{const{boxes:s,scores:r,maxOutputSize:a,iouThreshold:i,scoreThreshold:o}=iy(e,t,n);return[await dl.nonMaxSuppressionAsync(s,r,a,i,o)]}case"Where":{const s=Xt(mg("condition",e,t,n),"bool"),r=[await so(s)];return s.dispose(),r}case"ListDiff":return Ti(mg("x",e,t,n),mg("y",e,t,n));default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n);case"evaluation":return rs(()=>((e,t,n)=>{switch(e.op){case"TopKV2":{const s=mg("x",e,t,n),r=mg("k",e,t,n),a=mg("sorted",e,t,n),i=Yi(s,r,a);return[i.values,i.indices]}case"Unique":{const s=mg("x",e,t,n),r=Zi(s);return[r.values,r.indices]}case"UniqueV2":{const s=mg("x",e,t,n),r=mg("axis",e,t,n),a=Zi(s,r);return[a.values,a.indices]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"image":return rs(()=>((e,t,n)=>{switch(e.op){case"ResizeBilinear":{const s=mg("images",e,t,n),r=mg("size",e,t,n),a=mg("alignCorners",e,t,n),i=mg("halfPixelCenters",e,t,n);return[dl.resizeBilinear(s,[r[0],r[1]],a,i)]}case"ResizeNearestNeighbor":{const s=mg("images",e,t,n),r=mg("size",e,t,n),a=mg("alignCorners",e,t,n),i=mg("halfPixelCenters",e,t,n);return[dl.resizeNearestNeighbor(s,[r[0],r[1]],a,i)]}case"CropAndResize":{const s=mg("image",e,t,n),r=mg("boxes",e,t,n),a=mg("boxInd",e,t,n),i=mg("cropSize",e,t,n),o=mg("method",e,t,n),l=mg("extrapolationValue",e,t,n);return[dl.cropAndResize(s,r,a,i,o,l)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"graph":return rs(()=>((e,t,n)=>{switch(e.op){case"Const":return t[e.name];case"PlaceholderWithDefault":const s=mg("default",e,t,n);return[gg(e.name,t,n)||s];case"Placeholder":return[gg(e.name,t,n)];case"Identity":case"StopGradient":case"FakeQuantWithMinMaxVars":return[kg(mg("x",e,t,n))];case"IdentityN":return mg("x",e,t,n).map(e=>kg(e));case"Snapshot":return[kg(mg("x",e,t,n))];case"Shape":return[Ki(mg("x",e,t,n).shape,"int32")];case"ShapeN":return mg("x",e,t,n).map(e=>Ki(e.shape));case"Size":return[Ii(mg("x",e,t,n).size,"int32")];case"Rank":return[Ii(mg("x",e,t,n).rank,"int32")];case"NoOp":return[Ii(1)];case"Print":const r=mg("x",e,t,n),a=mg("data",e,t,n),i=mg("message",e,t,n),o=mg("summarize",e,t,n);console.warn("The graph has a tf.print() operation,usually used for debugging, which slows down performance."),console.log(i);for(let e=0;e<a.length;e++)console.log(Array.prototype.slice.call(a[e].dataSync()).slice(0,o));return[r];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"logical":return rs(()=>((e,t,n)=>{switch(e.op){case"Equal":return[Cr(mg("a",e,t,n),mg("b",e,t,n))];case"NotEqual":return[Oa(mg("a",e,t,n),mg("b",e,t,n))];case"Greater":return[Pr(mg("a",e,t,n),mg("b",e,t,n))];case"GreaterEqual":return[Wr(mg("a",e,t,n),mg("b",e,t,n))];case"Less":return[qr(mg("a",e,t,n),mg("b",e,t,n))];case"LessEqual":return[Kr(mg("a",e,t,n),mg("b",e,t,n))];case"LogicalAnd":return[ba(mg("a",e,t,n),mg("b",e,t,n))];case"LogicalNot":return[xa(mg("a",e,t,n))];case"LogicalOr":return[wa(mg("a",e,t,n),mg("b",e,t,n))];case"Select":case"SelectV2":return[Sr(mg("condition",e,t,n),mg("a",e,t,n),mg("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"matrices":return rs(()=>((e,t,n)=>{switch(e.op){case"BatchMatMul":case"BatchMatMulV2":case"MatMul":return[fn(mg("a",e,t,n),mg("b",e,t,n),mg("transposeA",e,t,n),mg("transposeB",e,t,n))];case"Transpose":return[gn(mg("x",e,t,n),mg("perm",e,t,n))];case"_FusedMatMul":const[s,r]=mg("fusedOps",e,t,n),a="biasadd"===s,i="prelu"===r,o=mg("numArgs",e,t,n),l=mg("leakyreluAlpha",e,t,n);if(a){if(i&&2!==o)throw new Error("Fused MatMul with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!i&&1!==o)throw new Error("Fused MatMul with BiasAdd must have one extra argument: bias.")}const[u,c]=mg("args",e,t,n);return[Io({a:mg("a",e,t,n),b:mg("b",e,t,n),transposeA:mg("transposeA",e,t,n),transposeB:mg("transposeB",e,t,n),bias:u,activation:r,preluActivationWeights:c,leakyreluAlpha:l})];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"normalization":return rs(()=>((e,t,n)=>{switch(e.op){case"FusedBatchNorm":case"FusedBatchNormV2":case"FusedBatchNormV3":return[Xs(mg("x",e,t,n),mg("mean",e,t,n),mg("variance",e,t,n),mg("offset",e,t,n),mg("scale",e,t,n),mg("epsilon",e,t,n))];case"LRN":return[Yr(mg("x",e,t,n),mg("radius",e,t,n),mg("bias",e,t,n),mg("alpha",e,t,n),mg("beta",e,t,n))];case"Softmax":return[Oi(mg("x",e,t,n))];case"LogSoftmax":return[la(mg("x",e,t,n))];case"SparseToDense":return[lo(mg("sparseIndices",e,t,n),mg("outputShape",e,t,n),mg("sparseValues",e,t,n),mg("defaultValue",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"reduction":return rs(()=>((e,t,n)=>{switch(e.op){case"Max":{const s=mg("axis",e,t,n),r=mg("keepDims",e,t,n);return[aa(mg("x",e,t,n),s,r)]}case"Mean":{const s=mg("axis",e,t,n),r=mg("keepDims",e,t,n);return[Sa(mg("x",e,t,n),s,r)]}case"Min":{const s=mg("axis",e,t,n),r=mg("keepDims",e,t,n);return[Ta(mg("x",e,t,n),s,r)]}case"Sum":{const s=mg("axis",e,t,n),r=mg("keepDims",e,t,n);return[oa(mg("x",e,t,n),s,r)]}case"All":{const s=mg("axis",e,t,n),r=mg("keepDims",e,t,n);return[bs(mg("x",e,t,n),s,r)]}case"Any":{const s=mg("axis",e,t,n),r=mg("keepDims",e,t,n);return[xs(mg("x",e,t,n),s,r)]}case"ArgMax":{const s=mg("axis",e,t,n);return[ws(mg("x",e,t,n),s)]}case"ArgMin":{const s=mg("axis",e,t,n);return[ks(mg("x",e,t,n),s)]}case"Prod":{const s=mg("axis",e,t,n),r=mg("keepDims",e,t,n);return[Xa(mg("x",e,t,n),s,r)]}case"Cumsum":{const s=mg("axis",e,t,n),r=mg("exclusive",e,t,n),a=mg("reverse",e,t,n);return[gr(mg("x",e,t,n),s,r,a)]}case"Bincount":const s=mg("x",e,t,n),r=mg("weights",e,t,n),a=mg("size",e,t,n);return[Qs(s,r,a)];case"DenseBincount":{const s=mg("x",e,t,n),r=mg("weights",e,t,n),a=mg("size",e,t,n),i=mg("binaryOutput",e,t,n);return[yr(s,r,a,i)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"slice_join":return rs(()=>((e,t,n)=>{switch(e.op){case"ConcatV2":case"Concat":{const s=mg("n",e,t,n),r=mg("axis",e,t,n);let a=mg("tensors",e,t,n);return a=a.slice(0,s),[Us(a,r)]}case"Gather":{const s=mg("x",e,t,n),r=mg("indices",e,t,n);return[Br(s,Xt(r,"int32"),0)]}case"GatherV2":{const s=mg("axis",e,t,n),r=mg("batchDims",e,t,n),a=mg("x",e,t,n),i=mg("indices",e,t,n);return[Br(a,Xt(i,"int32"),s,r)]}case"Reverse":{const s=mg("dims",e,t,n),r=[];for(let e=0;e<s.length;e++)s[e]&&r.push(e);const a=mg("x",e,t,n);return[yi(a,r)]}case"ReverseV2":{const s=mg("axis",e,t,n),r=mg("x",e,t,n);return[yi(r,s)]}case"Slice":{const s=mg("begin",e,t,n),r=mg("size",e,t,n);return[Hs(mg("x",e,t,n),s,r)]}case"StridedSlice":{const s=mg("begin",e,t,n),r=mg("end",e,t,n),a=mg("strides",e,t,n),i=mg("beginMask",e,t,n),o=mg("endMask",e,t,n),l=mg("ellipsisMask",e,t,n),u=mg("newAxisMask",e,t,n),c=mg("shrinkAxisMask",e,t,n),h=mg("x",e,t,n);return[ji(h,s,r,a,i,o,l,u,c)]}case"Pack":return rs(()=>{const s=mg("axis",e,t,n),r=mg("tensors",e,t,n),a=r[0].shape,i=Ui(r[0]).shape,o=r.map(e=>{const t=d(e.shape,a);if(!t&&!d(Ui(e).shape,i))throw new Error("the input tensors shape does not match");return t?e:Ps(e,a)});return[Gi(o,s)]});case"Unpack":{const s=mg("axis",e,t,n),r=mg("tensor",e,t,n);return eo(r,s)}case"Tile":{const s=mg("reps",e,t,n);return[Or(mg("x",e,t,n),s)]}case"Split":case"SplitV":{const s=mg("axis",e,t,n),r=mg("numOrSizeSplits",e,t,n),a=mg("x",e,t,n);return Bi(a,r,s)}case"ScatterNd":{const s=mg("indices",e,t,n),r=mg("values",e,t,n),a=mg("shape",e,t,n);return[oo(s,r,a)]}case"GatherNd":{const s=mg("x",e,t,n),r=mg("indices",e,t,n);return[uo(s,r)]}case"SparseToDense":{const s=mg("sparseIndices",e,t,n),r=mg("outputShape",e,t,n),a=mg("sparseValues",e,t,n),i=mg("defaultValue",e,t,n);return[lo(s,a,r,a.dtype===i.dtype?i:Xt(i,a.dtype))]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"spectral":return rs(()=>((e,t,n)=>{switch(e.op){case"FFT":return[Mi(mg("x",e,t,n))];case"IFFT":return[Li(mg("x",e,t,n))];case"RFFT":return[Pi(mg("x",e,t,n))];case"IRFFT":return[zi(mg("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"transformation":return rs(()=>((e,t,n)=>{switch(e.op){case"Cast":return[Xt(mg("x",e,t,n),mg("dtype",e,t,n))];case"ExpandDims":{const s=mg("axis",e,t,n);return[Dr(mg("x",e,t,n),s)]}case"Squeeze":{const s=mg("axis",e,t,n);return[Ui(mg("x",e,t,n),s)]}case"Reshape":return[Ps(mg("x",e,t,n),mg("shape",e,t,n))];case"MirrorPad":return[$a(mg("x",e,t,n),mg("padding",e,t,n),mg("mode",e,t,n))];case"PadV2":case"Pad":return[Pa(mg("x",e,t,n),mg("padding",e,t,n),mg("constantValue",e,t,n))];case"SpaceToBatchND":{const s=mg("blockShape",e,t,n),r=mg("paddings",e,t,n);return[Ha(mg("x",e,t,n),s,r)]}case"BatchToSpaceND":{const s=mg("blockShape",e,t,n),r=mg("crops",e,t,n);return[Ks(mg("x",e,t,n),s,r)]}case"DepthToSpace":{const s=mg("blockSize",e,t,n),r=mg("dataFormat",e,t,n).toUpperCase();return[br(mg("x",e,t,n),s,r)]}case"BroadcastTo":return[er(mg("x",e,t,n),mg("shape",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"hash_table":return(async(e,t,n,s)=>{switch(e.op){case"HashTable":case"HashTableV2":{const r=mg("keyDType",e,t,n),a=mg("valueDType",e,t,n),i=new oy(r,a);return s.addHashTable(e.name,i),[i.handle]}case"LookupTableImport":case"LookupTableImportV2":{const r=mg("tableHandle",e,t,n,s),a=mg("keys",e,t,n),i=mg("values",e,t,n),o=s.getHashTableById(r.id);return[await o.import(a,i)]}case"LookupTableFind":case"LookupTableFindV2":{const r=mg("tableHandle",e,t,n,s),a=mg("keys",e,t,n),i=mg("defaultValue",e,t,n),o=s.getHashTableById(r.id);return[await o.find(a,i)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n,s);case"custom":const r=fg(e.op);if(r&&r.customExecutor)return r.customExecutor(new ey(e,t,n));throw TypeError(`Custom op ${e.op} is not registered.`);default:throw TypeError(`Unknown op '${e.op}'. File an issue at https://github.com/tensorflow/tfjs/issues so we can add it, or register a custom execution with tf.registerOp()`)}})(e,t,n);return U(r)?r.then(e=>[].concat(e)):[].concat(r)}class uy{constructor(e={},t={},n={},s={}){this.weightMap=e,this.tensorArrayMap=t,this.tensorListMap=n,this.functionMap=s,this.rootContext={id:0,frameName:"",iterationId:0},this.contexts=[this.rootContext],this.lastId=0,this.generateCurrentContextIds()}newFrame(e,t){return{id:e,frameName:t,iterationId:0}}set currentContext(e){this.contexts!==e&&(this.contexts=e,this.generateCurrentContextIds())}get currentContext(){return this.contexts}get currentContextId(){return this._currentContextIds[0]}get currentContextIds(){return this._currentContextIds}generateCurrentContextIds(){const e=[];for(let t=0;t<this.contexts.length-1;t++){const n=this.contexts.slice(0,this.contexts.length-t);e.push(this.contextIdforContexts(n))}e.push(""),this._currentContextIds=e}contextIdforContexts(e){return e?e.map(e=>0===e.id&&0===e.iterationId?"":`${e.frameName}-${e.iterationId}`).join("/"):""}enterFrame(e){this.contexts&&(this.lastId++,this.contexts=this.contexts.slice(),this.contexts.push(this.newFrame(this.lastId,e)),this._currentContextIds.unshift(this.contextIdforContexts(this.contexts)))}exitFrame(){if(!(this.contexts&&this.contexts.length>1))throw new Error("Cannot exit frame, the context is empty");this.contexts=this.contexts.slice(),this.contexts.splice(-1),this.currentContextIds.shift()}nextIteration(){if(!(this.contexts&&this.contexts.length>0))throw new Error("Cannot increase frame iteration, the context is empty");{this.contexts=this.contexts.slice(),this.lastId++;const e=Object.assign({},this.contexts[this.contexts.length-1]);e.iterationId+=1,e.id=this.lastId,this.contexts.splice(-1,1,e),this._currentContextIds.splice(0,1,this.contextIdforContexts(this.contexts))}}getWeight(e){return this.weightMap[e]}addTensorArray(e){this.tensorArrayMap[e.id]=e}getTensorArray(e){return this.tensorArrayMap[e]}addTensorList(e){this.tensorListMap[e.id]=e}getTensorList(e){return this.tensorListMap[e]}dispose(e){for(const t in this.tensorArrayMap)this.tensorArrayMap[t].clearAndClose(e);for(const t in this.tensorListMap)this.tensorListMap[t].clearAndClose(e)}}function cy(e,t,n,s){const r=new Set,a=[];let i=null,o=null;const l=new Set,u=Object.keys(e).map(e=>xg(e)[0]);let c=[];null!=s&&(c=s.map(e=>xg(e.name)[0]));const h=[...t];for(;h.length>0;){const e=h.pop();(fy(e)||my(e)||gy(e))&&null==i&&(i=e,o=i.children.map(e=>e.name).filter(e=>r.has(e))),r.add(e.name),null==n[e.name]&&(-1===u.indexOf(e.name)&&-1===c.indexOf(e.name)&&(0!==e.inputs.length?e.inputs.forEach(e=>{l.has(e.name)||(l.add(e.name),h.push(e))}):a.push(e.name)))}return{inputs:e,outputs:t,usedNodes:r,missingInputs:a,dynamicNode:i,syncInputs:o}}const hy=["Switch","Merge","Enter","Exit","NextIteration","StatelessIf","StatelessWhile","if","While"],py=["NonMaxSuppressionV2","NonMaxSuppressionV3","NonMaxSuppressionV5","Where"],dy=["HashTable","HashTableV2","LookupTableImport","LookupTableImportV2","LookupTableFind","LookupTableFindV2"];function fy(e){return hy.indexOf(e.op)>=0}function my(e){return py.indexOf(e.op)>=0}function gy(e){return dy.indexOf(e.op)>=0}class yy{constructor(e,t){this.graph=e,this.parent=t,this.compiledMap=new Map,this._weightMap={},this.SEPERATOR=",",this._functions={},this._functionExecutorMap={},this._outputs=e.outputs,this._inputs=e.inputs,this._initNodes=e.initNodes,this._signature=e.signature,this._functions=e.functions,null!=e.functions&&Object.keys(e.functions).forEach(t=>{this._functionExecutorMap[t]=new yy(e.functions[t],this)})}get weightIds(){return this.parent?this.parent.weightIds:this._weightIds}get functionExecutorMap(){return this.parent?this.parent.functionExecutorMap:this._functionExecutorMap}get weightMap(){return this.parent?this.parent.weightMap:this._weightMap}set weightMap(e){const t=Object.keys(e).map(t=>e[t].map(e=>e.id));this._weightIds=[].concat(...t),this._weightMap=e}set resourceManager(e){this._resourceManager=e}get inputs(){return this._inputs.map(e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0}))}get outputs(){return this._outputs.map(e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0}))}get inputNodes(){return this._inputs.map(e=>e.signatureKey||e.name)}get outputNodes(){return this._outputs.map(e=>{const t=e.signatureKey||e.name;return e.defaultOutput?`${t}:${e.defaultOutput}`:t})}get functions(){return Object.keys(this._functions).reduce((e,t)=>(e[t]=this._functions[t].signature,e),{})}getCompilationKey(e,t){const n=e.map(e=>e.name).sort(),s=t.map(e=>e.name).sort();return n.join(this.SEPERATOR)+"--"+s.join(this.SEPERATOR)}compile(e,t){const n=cy(e,t,this.weightMap,this._initNodes),{missingInputs:s,dynamicNode:r,syncInputs:a}=n;if(null!=r)throw new Error(`This execution contains the node '${r.name}', which has the dynamic op '${r.op}'. Please use model.executeAsync() instead. Alternatively, to avoid the dynamic ops, specify the inputs [${a}]`);if(s.length>0){const n=t.map(e=>e.name),r=Object.keys(e);throw new Error(`Cannot compute the outputs [${n}] from the provided inputs [${r}]. Missing the following inputs: [${s}]`)}return function(e,t,n){const{usedNodes:s,inputs:r}=n,a=[],i=Object.keys(r).map(e=>xg(e)[0]).map(t=>e.nodes[t]),o=e.initNodes;i.forEach(e=>{s.has(e.name)&&a.push(e)}),e.weights.forEach(e=>{s.has(e.name)&&a.push(e)}),null!=o&&o.forEach(e=>{s.has(e.name)&&a.push(e)});const l=new Set,u=[];for(;a.length>0;){const e=a.pop();l.add(e.name),t[e.name]||u.push(e),e.children.forEach(e=>{!l.has(e.name)&&s.has(e.name)&&e.inputs.every(e=>l.has(e.name))&&a.push(e)})}return u}(this.graph,this.weightMap,n)}execute(e,t){e=this.mapInputs(e);const n=Object.keys(e).sort();this.checkInputs(e),this.checkInputShapeAndType(e),t=this.mapOutputs(t),this.checkOutputs(t);const s=n.map(e=>this.graph.nodes[xg(e)[0]]),r=t.map(e=>xg(e)[0]);let a=r.map(e=>this.graph.nodes[e]);0===a.length&&(a=this._outputs);const i=this.getCompilationKey(s,a);let o=this.compiledMap.get(i);null==o&&(o=this.compile(e,a),this.compiledMap.set(i,o));const l={},u={};return rs(()=>{const n=new uy(this.weightMap,l,u,this.functionExecutorMap),s=Object.assign({},this.weightMap);Object.keys(e).forEach(t=>{const[n,r]=xg(t),a=[];a[r]=e[t],s[n]=a});const a=this.getFrozenTensorIds(s),i={};for(let e=0;e<o.length;e++){const t=o[e];if(!s[t.name]){const e=ly(t,s,n,this._resourceManager);if(U(e))throw new Error(`The execution of the op '${t.op}' returned a promise. Please use model.executeAsync() instead.`);s[t.name]=e,this.checkTensorForDisposal(t.name,t,s,n,a,r,i)}}return null==this.parent&&n.dispose(a),t.map(e=>gg(e,s,n))})}getFrozenTensorIds(e){const t=[].concat.apply([],Object.keys(e).map(t=>e[t]).map(e=>e.map(e=>e.id)));return new Set(t)}checkTensorForDisposal(e,t,n,s,r,a,i){"control"!==t.category&&-1===a.indexOf(e)&&(n[e].forEach(e=>{null!=e&&(i[e.id]=(i[e.id]||0)+t.children.length)}),t.inputs.forEach(e=>{if("control"!==e.category){const t=function(e,t,n){return t[bg(e,n.currentContextId)]}(e.name,n,s);null!=t&&t.forEach(e=>{if(e&&!r.has(e.id)){const t=i[e.id];1===t?(e.dispose(),delete i[e.id]):null!=t&&i[e.id]--}})}}))}async executeAsync(e,t){return this._executeAsync(e,t)}async _executeAsync(e,t,n=!1,s={},r={}){n||(e=this.mapInputs(e),this.checkInputs(e),this.checkInputShapeAndType(e),t=this.mapOutputs(t),this.checkOutputs(t));const a=new uy(this.weightMap,s,r,this.functionExecutorMap),i=await this.executeWithControlFlow(e,a,t,n),o=t.map(e=>gg(e,i,a)),l=o.map(e=>e.id),u=Object.keys(e).map(t=>e[t].id),c=new Set([...l,...u,...this.weightIds]);return Object.keys(i).forEach(e=>{i[e].forEach(e=>{!e||e.isDisposed||c.has(e.id)||e.dispose()})}),null==this.parent&&a.dispose(c),o}async executeFunctionAsync(e,t,n){const s=e.reduce((e,t,n)=>(e[this.inputs[n].name]=t,e),{});return this._executeAsync(s,this.outputNodes,!0,t,n)}async executeWithControlFlow(e,t,n,s){const r=Object.keys(e),a=r.map(e=>this.graph.nodes[xg(e)[0]]),i=n.map(e=>xg(e)[0]);let o=i.map(e=>this.graph.nodes[e]);0===o.length&&(o=this._outputs);const{usedNodes:l,missingInputs:u,dynamicNode:c,syncInputs:h}=cy(e,o,this.weightMap,this._initNodes),p=[...a,...this.graph.weights,...this._initNodes||[]].map(e=>({node:e,contexts:t.currentContext})),d=Object.assign({},this.weightMap);Object.keys(e).forEach(t=>{const[n,s]=xg(t),r=[];r[s]=e[t],d[n]=r});const f={},m=this.getFrozenTensorIds(d),g={};for(;p.length>0;){const e=this.processStack(a,p,t,d,g,m,i,f,l);await Promise.all(e)}null!=c||s||console.warn("This model execution did not contain any nodes with control flow or dynamic output shapes. You can use model.execute() instead.");const y=o.filter(e=>!fy(e)&&!gg(e.name,d,t)).map(e=>e.name);if(y.length>0){let e="";throw null!=c&&(e=`Alternatively, to avoid the dynamic ops, use model.execute() and specify the inputs [${h}]`),new Error(`Cannot compute the outputs [${y}] from the provided inputs [${r}]. Consider providing the following inputs: [${u}]. ${e}`)}return d}processStack(e,t,n,s,r,a,i,o,l){const u=[];for(;t.length>0;){const e=t.pop();n.currentContext=e.contexts;let c="";if("Enter"===e.node.op&&mg("isConstant",e.node,s,n)&&([c]=yg(e.node.name,n)),null==s[e.node.name]){const h=ly(e.node,s,n,this._resourceManager);c||([c]=yg(e.node.name,n));const p=n.currentContext;U(h)?u.push(h.then(u=>(s[c]=u,n.currentContext=p,this.checkTensorForDisposal(c,e.node,s,n,a,i,o),this.processChildNodes(e.node,t,n,s,r,l),u))):(s[c]=h,this.checkTensorForDisposal(c,e.node,s,n,a,i,o),this.processChildNodes(e.node,t,n,s,r,l))}else this.processChildNodes(e.node,t,n,s,r,l)}return u}processChildNodes(e,t,n,s,r,a){e.children.forEach(e=>{const[i]=yg(e.name,n);!r[i]&&a.has(e.name)&&("Merge"===e.op?e.inputNames.some(e=>!!gg(e,s,n))&&(r[i]=!0,t.push({contexts:n.currentContext,node:e})):e.inputNames.every(e=>!!gg(e,s,n))&&(r[i]=!0,t.push({contexts:n.currentContext,node:e})))})}dispose(){Object.keys(this.weightMap).forEach(e=>this.weightMap[e].forEach(e=>e.dispose()))}checkInputShapeAndType(e){Object.keys(e).forEach(t=>{const n=e[t],[s]=xg(t),r=this.graph.nodes[s];if(r.attrParams.shape&&r.attrParams.shape.value){const e=r.attrParams.shape.value;l(e.length===n.shape.length&&n.shape.every((t,n)=>-1===e[n]||e[n]===t),()=>`The shape of dict['${r.name}'] provided in model.execute(dict) must be [${e}], but was [${n.shape}]`)}r.attrParams.dtype&&r.attrParams.dtype.value&&l(n.dtype===r.attrParams.dtype.value,()=>`The dtype of dict['${r.name}'] provided in model.execute(dict) must be ${r.attrParams.dtype.value}, but was ${n.dtype}`)})}mapInputs(e){const t={};for(const n in e)if(null!=this._signature&&null!=this._signature.inputs&&null!=this._signature.inputs[n]){t[this._signature.inputs[n].name]=e[n]}else t[n]=e[n];return t}checkInputs(e){const t=Object.keys(e).filter(e=>{const[t]=xg(e);return null==this.graph.nodes[t]});if(t.length>0)throw new Error(`The dict provided in model.execute(dict) has keys: [${t}] that are not part of graph`)}mapOutputs(e){return e.map(e=>{if(null!=this._signature&&null!=this._signature.outputs&&null!=this._signature.outputs[e]){return this._signature.outputs[e].name}return e},{})}checkOutputs(e){e.forEach(e=>{const[t]=xg(e);if(!this.graph.nodes[t])throw new Error(`The output '${e}' is not found in the graph`)})}}class by{constructor(e={},t={}){this.hashTableNameToHandle=e,this.hashTableMap=t}addHashTable(e,t){this.hashTableNameToHandle[e]=t.handle,this.hashTableMap[t.id]=t}getHashTableHandleByName(e){return this.hashTableNameToHandle[e]}getHashTableById(e){return this.hashTableMap[e]}dispose(){for(const e in this.hashTableMap)this.hashTableMap[e].clearAndClose(),delete this.hashTableMap[e];for(const e in this.hashTableNameToHandle)this.hashTableNameToHandle[e].dispose(),delete this.hashTableNameToHandle[e]}}class xy{constructor(e,t={}){this.modelUrl=e,this.loadOptions=t,this.version="n/a",null==t&&(this.loadOptions={}),this.resourceManager=new by}get modelVersion(){return this.version}get inputNodes(){return this.executor.inputNodes}get outputNodes(){return this.executor.outputNodes}get inputs(){return this.executor.inputs}get outputs(){return this.executor.outputs}get weights(){return this.executor.weightMap}get metadata(){return this.artifacts.userDefinedMetadata}get modelSignature(){return this.signature}findIOHandler(){const e=this.modelUrl;if(null!=e.load)this.handler=e;else if(null!=this.loadOptions.requestInit)this.handler=cn(e,this.loadOptions);else{const t=It(e,this.loadOptions);if(0===t.length)t.push(cn(e,this.loadOptions));else if(t.length>1)throw new Error(`Found more than one (${t.length}) load handlers for URL '${[e]}'`);this.handler=t[0]}}async load(){if(this.findIOHandler(),null==this.handler.load)throw new Error("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const e=await this.handler.load();return this.loadSync(e)}loadSync(e){this.artifacts=e;const t=this.artifacts.modelTopology;let n;n=null!=this.artifacts.userDefinedMetadata&&null!=this.artifacts.userDefinedMetadata.signature?this.artifacts.userDefinedMetadata.signature:this.artifacts.signature,this.signature=n,this.version=`${t.versions.producer}.${t.versions.minConsumer}`;const s=ft(this.artifacts.weightData,this.artifacts.weightSpecs);if(this.executor=new yy(Bg.Instance.transformGraph(t,this.signature)),this.executor.weightMap=this.convertTensorMapToTensorsMap(s),this.executor.resourceManager=this.resourceManager,null!=e.modelInitializer&&null!=e.modelInitializer.node){const t=Bg.Instance.transformGraph(e.modelInitializer);this.initializer=new yy(t),this.initializer.weightMap=this.executor.weightMap,this.initializer.resourceManager=this.resourceManager,this.initializer.executeAsync({},[])}return!0}async save(e,t){if("string"==typeof e){const t=Nt(e);if(0===t.length)throw new Error(`Cannot find any save handlers for URL '${e}'`);if(t.length>1)throw new Error(`Found more than one (${t.length}) save handlers for URL '${e}'`);e=t[0]}if(null==e.save)throw new Error("GraphModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");return e.save(this.artifacts)}predict(e,t){return this.execute(e,this.outputNodes)}normalizeInputs(e){if(!(e instanceof Fe||Array.isArray(e)))return e;if((e=Array.isArray(e)?e:[e]).length!==this.inputNodes.length)throw new Error(`Input tensor count mismatch,the graph model has ${this.inputNodes.length} placeholders, while there are ${e.length} input tensors.`);return this.inputNodes.reduce((t,n,s)=>(t[n]=e[s],t),{})}normalizeOutputs(e){return e=e||this.outputNodes,Array.isArray(e)?e:[e]}execute(e,t){e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=this.executor.execute(e,t);return n.length>1?n:n[0]}async executeAsync(e,t){e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=await this.executor.executeAsync(e,t);return n.length>1?n:n[0]}convertTensorMapToTensorsMap(e){return Object.keys(e).reduce((t,n)=>(t[n]=[e[n]],t),{})}dispose(){this.executor.dispose(),this.initializer&&this.initializer.dispose(),this.resourceManager.dispose()}}function wy(e,t,n=new Map,s=new Set){if(null==e)return null;if(s.has(e))throw new Error("Circular references are not supported.");if(n.has(e))return n.get(e);const r=t(e);if(r.recurse&&null!==r.value)throw new Error("A deep map function may not return both a value and recurse=true.");if(r.recurse){if(Iy(e)){const r=Array.isArray(e)?[]:{};s.add(e);for(const a in e){const i=wy(e[a],t,n,s);r[a]=i}return s.delete(e),r}throw new Error("Can't recurse into non-iterable type: "+e)}return n.set(e,r.value),r.value}function ky(e,t=vy){return function e(t,n,s=new Set){const r=t[0];if(s.has(r))throw new Error("Circular references are not supported.");const a=n(t);if(a.recurse&&null!==a.value)throw new Error("A deep zip function may not return both a value and recurse=true.");if(a.recurse){if(Iy(r)){const a=Array.isArray(r)?[]:{};s.add(r);for(const i in r){const r=t.map(e=>e[i]),o=e(r,n,s);a[i]=o}return s.delete(r),a}throw new Error("Can't recurse into non-iterable type: "+r)}return a.value}(e,t)}function vy(e){return null===e?null:Iy(e[0])?{value:null,recurse:!0}:{value:e,recurse:!1}}async function Ny(e,t){const n=new Map;wy(e,t,n);for(const e of Array.from(n.keys())){const t=n.get(e);if(U(t)){const s=await t;n.set(e,s)}}return wy(e,t,n)}function Iy(e){return null!=e&&!ArrayBuffer.isView(e)&&(Array.isArray(e)||"object"==typeof e&&!(e instanceof Fe))}function Cy(e){return function(e,t){return wy(e,t)}(e,Sy)}function Sy(e){return e instanceof Fe?{value:e.clone(),recurse:!1}:Iy(e)?{value:null,recurse:!0}:{value:e,recurse:!1}}class Ty{constructor(e){if(this.capacity=e,this.begin=0,this.end=0,null==e)throw new RangeError("Can't create a ring buffer of unknown capacity.");if(e<1)throw new RangeError("Can't create ring buffer of capacity < 1.");this.data=new Array(e),this.doubledCapacity=2*e}wrap(e){for(;e<0;)e+=this.doubledCapacity;return e%this.doubledCapacity}get(e){if(e<0)throw new RangeError("Can't get item at a negative index.");return this.data[e%this.capacity]}set(e,t){if(e<0)throw new RangeError("Can't set item at a negative index.");this.data[e%this.capacity]=t}length(){let e=this.end-this.begin;return e<0&&(e=this.doubledCapacity+e),e}isFull(){return this.length()===this.capacity}isEmpty(){return 0===this.length()}push(e){if(this.isFull())throw new RangeError("Ring buffer is full.");this.set(this.end,e),this.end=this.wrap(this.end+1)}pushAll(e){for(const t of e)this.push(t)}pop(){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");this.end=this.wrap(this.end-1);const e=this.get(this.end);return this.set(this.end,void 0),e}unshift(e){if(this.isFull())throw new RangeError("Ring buffer is full.");this.begin=this.wrap(this.begin-1),this.set(this.begin,e)}shift(){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");const e=this.get(this.begin);return this.set(this.begin,void 0),this.begin=this.wrap(this.begin+1),e}shuffleExcise(e){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");const t=this.wrap(this.begin+e),n=this.get(t);return this.set(t,this.pop()),n}}class Ey extends Ty{constructor(){super(Ey.INITIAL_CAPACITY)}isFull(){return!1}push(e){super.isFull()&&this.expand(),super.push(e)}unshift(e){super.isFull()&&this.expand(),super.unshift(e)}expand(){const e=2*this.capacity,t=new Array(e),n=this.length();for(let e=0;e<n;e++)t[e]=this.get(this.wrap(this.begin+e));this.data=t,this.capacity=e,this.doubledCapacity=2*this.capacity,this.begin=0,this.end=n}}function $y(e){return new Dy(e)}function Ay(e){return new _y(e)}function Ry(e,t){return new Hy(e,t)}Ey.INITIAL_CAPACITY=32;class Fy{async toArray(){const e=[];let t=await this.next();for(;!t.done;)e.push(t.value),t=await this.next();return e}async toArrayForTest(){const e=this.prefetch(100),t=[];let n=await e.next();for(;!n.done;)t.push(n.value),n=await e.next();return t}async resolveFully(){let e=await this.next();for(;!e.done;)e=await this.next()}async resolveWhile(e){let t=await this.next(),n=e(t.value);for(;!t.done&&n;)t=await this.next(),n=e(t.value)}handleErrors(e){return new Wy(this,e)}filter(e){return new By(this,e)}map(e){return new Py(this,e)}mapAsync(e){return new Vy(this,e)}serialMapAsync(e){return new Vy(this,e).serial()}flatmap(e){return new Gy(this,e)}async forEachAsync(e){return this.map(e).resolveFully()}async serialForEach(e){return this.serialMapAsync(e).resolveWhile(e=>!0===e)}rowMajorBatch(e,t=!0){return new zy(this,e,t)}columnMajorBatch(e,t=!0,n=vy){return this.rowMajorBatch(e,t).map(e=>ky(e,n))}concatenate(e,t){return new Hy($y([this,e]),t)}take(e){return e<0||null==e?this:new Ly(this,e)}skip(e){return e<0||null==e?this:new My(this,e)}prefetch(e){return new Ky(this,e)}shuffle(e,t){return new Xy(this,e,t)}serial(){return new Oy(this)}}class Dy extends Fy{constructor(e){super(),this.items=e,this.trav=0}summary(){return`Array of ${this.items.length} items`}async next(){if(this.trav>=this.items.length)return{value:null,done:!0};const e=this.items[this.trav];return this.trav++,{value:Cy(e),done:!1}}}class _y extends Fy{constructor(e){super(),this.nextFn=e}summary(){return"Function call"}async next(){try{return this.nextFn()}catch(e){throw e.message="Error thrown while iterating through a dataset: "+e.message,e}}}class Oy extends Fy{constructor(e){super(),this.upstream=e,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> Serial"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){return this.upstream.next()}}class My extends Fy{constructor(e,t){super(),this.upstream=e,this.maxCount=t,this.count=0,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> Skip"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){for(;this.count++<this.maxCount;){const e=await this.upstream.next();if(e.done)return e;as(e.value)}return this.upstream.next()}}class Ly extends Fy{constructor(e,t){super(),this.upstream=e,this.maxCount=t,this.count=0}summary(){return this.upstream.summary()+" -> Take"}async next(){return this.count++>=this.maxCount?{value:null,done:!0}:this.upstream.next()}}class zy extends Fy{constructor(e,t,n=!0){super(),this.upstream=e,this.batchSize=t,this.enableSmallLastBatch=n,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> RowMajorBatch"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){const e=[];for(;e.length<this.batchSize;){const t=await this.upstream.next();if(t.done)return this.enableSmallLastBatch&&e.length>0?{value:e,done:!1}:{value:null,done:!0};e.push(t.value)}return{value:e,done:!1}}}class By extends Fy{constructor(e,t){super(),this.upstream=e,this.predicate=t,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> Filter"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){for(;;){const e=await this.upstream.next();if(e.done||this.predicate(e.value))return e;as(e.value)}}}class Py extends Fy{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return this.upstream.summary()+" -> Map"}async next(){const e=await this.upstream.next();if(e.done)return{value:null,done:!0};const t=je(e.value),n=this.transform(e.value),s=je(n);for(const e of t)He(e,s)||e.dispose();return{value:n,done:!1}}}class Wy extends Fy{constructor(e,t){super(),this.upstream=e,this.handler=t,this.count=0,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> handleErrors"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){for(;;)try{return await this.upstream.next()}catch(e){if(!this.handler(e))return{value:null,done:!0}}}}class Vy extends Fy{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return this.upstream.summary()+" -> AsyncMap"}async next(){const e=await this.upstream.next();if(e.done)return{value:null,done:!0};const t=je(e.value),n=await this.transform(e.value),s=je(n);for(const e of t)He(e,s)||e.dispose();return{value:n,done:!1}}}class Uy extends Fy{constructor(){super(),this.outputQueue=new Ey,this.lastRead=Promise.resolve({value:null,done:!1})}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){for(;0===this.outputQueue.length();)if(!await this.pump())return{value:null,done:!0};return{value:this.outputQueue.shift(),done:!1}}}class Gy extends Uy{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return this.upstream.summary()+" -> Flatmap"}async pump(){const e=await this.upstream.next();if(e.done)return!1;const t=je(e.value),n=this.transform(e.value),s=je(n);this.outputQueue.pushAll(n);for(const e of t)He(e,s)||e.dispose();return!0}}class Hy extends Fy{constructor(e,t){super(),this.baseErrorHandler=t,this.lastRead=null,this.iterator=null,this.moreIterators=e}summary(){return"TODO: fill in upstream of chained summaries -> Chained"}async next(){return this.lastRead=this.readFromChain(this.lastRead),this.lastRead}async readFromChain(e){if(await e,null==this.iterator){const e=await this.moreIterators.next();if(e.done)return{value:null,done:!0};this.iterator=e.value,null!=this.baseErrorHandler&&(this.iterator=this.iterator.handleErrors(this.baseErrorHandler))}const t=await this.iterator.next();return t.done?(this.iterator=null,this.readFromChain(e)):t}}var jy;!function(e){e[e.FAIL=0]="FAIL",e[e.SHORTEST=1]="SHORTEST",e[e.LONGEST=2]="LONGEST"}(jy||(jy={}));class qy extends Fy{constructor(e,t=jy.FAIL){super(),this.iterators=e,this.mismatchMode=t,this.count=0,this.currentPromise=null}summary(){return"{TODO: fill in upstream of zip summaries} -> Zip"}async nextState(e){await e;let t=0,n=0;const s=await Ny(this.iterators,(function(e){if(e instanceof Fy){return{value:e.next().then(e=>(t++,e.done&&n++,e.value)),recurse:!1}}return{value:null,recurse:!0}}));if(t===n)return{value:null,done:!0};if(n>0)switch(this.mismatchMode){case jy.FAIL:throw new Error(`Zipped streams should have the same length. Mismatched at element ${this.count}.`);case jy.SHORTEST:return{value:null,done:!0};case jy.LONGEST:}return this.count++,{value:s,done:!1}}async next(){return this.currentPromise=this.nextState(this.currentPromise),this.currentPromise}}class Ky extends Fy{constructor(e,t){super(),this.upstream=e,this.bufferSize=t,this.buffer=new Ty(t)}summary(){return this.upstream.summary()+" -> Prefetch"}refill(){for(;!this.buffer.isFull();){const e=this.upstream.next();this.buffer.push(e)}}next(){return this.refill(),this.buffer.shift()}}class Xy extends Ky{constructor(e,t,n){super(e,t),this.upstream=e,this.windowSize=t,this.upstreamExhausted=!1,this.random=ai(n||ge().toString()),this.lastRead=Promise.resolve({value:null,done:!1})}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}randomInt(e){return Math.floor(this.random()*e)}chooseIndex(){return this.randomInt(this.buffer.length())}async serialNext(){for(this.upstreamExhausted||this.refill();!this.buffer.isEmpty();){const e=this.chooseIndex(),t=await this.buffer.shuffleExcise(e);if(!t.done)return this.refill(),t;this.upstreamExhausted=!0}return{value:null,done:!0}}}class Yy{constructor(){this.size=null}batch(e,t=!0){const n=this;let s;return l(e>0,()=>"batchSize needs to be positive, but it is\n      "+e),s=this.size===1/0||null==this.size?this.size:t?Math.ceil(this.size/e):Math.floor(this.size/e),Jy(async()=>(await n.iterator()).columnMajorBatch(e,t,Zy),s)}concatenate(e){const t=this;let n;return n=this.size===1/0||e.size===1/0?1/0:null!=this.size&&null!=e.size?this.size+e.size:null,Jy(async()=>(await t.iterator()).concatenate(await e.iterator()),n)}filter(e){const t=this;let n;return n=this.size===1/0?1/0:null,Jy(async()=>(await t.iterator()).filter(t=>rs(()=>e(t))),n)}async forEachAsync(e){return(await this.iterator()).forEachAsync(e)}map(e){const t=this;return Jy(async()=>(await t.iterator()).map(t=>rs(()=>e(t))),this.size)}mapAsync(e){const t=this;return Jy(async()=>(await t.iterator()).mapAsync(e),this.size)}prefetch(e){if(null==e)throw new RangeError("`Dataset.prefetch()` requires bufferSize to be specified.");const t=this;return Jy(async()=>(await t.iterator()).prefetch(e),this.size)}repeat(e){const t=this;let n;return n=null!=this.size&&e>0?this.size*e:0===e?0:null!=this.size&&(void 0===e||e<0)?1/0:null,Jy(async()=>Ry(Ay(async()=>({value:await t.iterator(),done:!1})).take(e)),n)}skip(e){const t=this;let n;return n=null!=this.size&&e>=0&&this.size>=e?this.size-e:null!=this.size&&(this.size<e||void 0===e||e<0)?0:null,Jy(async()=>(await t.iterator()).skip(e),n)}shuffle(e,t,n=!0){if(null==e||e<0)throw null==this.size?new RangeError("`Dataset.shuffle()` requires bufferSize to be specified."):new RangeError(`\`Dataset.shuffle()\` requires bufferSize to be specified.  If your data fits in main memory (for regular JS objects), and/or GPU memory (for \`tf.Tensor\`s), consider setting bufferSize to the dataset size (${this.size} elements)`);const s=this,r=ai(t||ge().toString());return Jy(async()=>{let t=r.int32();return n&&(t+=r.int32()),(await s.iterator()).shuffle(e,t.toString())},this.size)}take(e){const t=this;let n;return n=null!=this.size&&this.size>e?e:null!=this.size&&this.size<=e?this.size:null,Jy(async()=>(await t.iterator()).take(e),n)}async toArray(){if(this.size===1/0)throw new Error("Can not convert infinite data stream to array.");return(await this.iterator()).toArray()}async toArrayForTest(){if(this.size===1/0)throw new Error("Can not convert infinite data stream to array.");return(await this.iterator()).toArrayForTest()}}function Jy(e,t=null){return new class extends Yy{constructor(){super(...arguments),this.size=t}async iterator(){return e()}}}function Zy(e){if(null===e)return null;const t=e[0];if(null==(n=t)||null===(s=n)||"object"!=typeof s&&"function"!=typeof s||Array.isArray(n)||"object"==typeof n&&n instanceof Fe||S(n)){return{value:function(e){if(0===e.length)throw new Error("Can't make a batch of zero elements.");return e[0]instanceof Fe?Gi(e):ht(e)}(e),recurse:!1}}var n,s;return{value:null,recurse:!0}}Yy.MAX_BUFFER_SIZE=1e4;class Qy extends Yy{constructor(e){super(),this.input=e}async iterator(){return(await this.input.iterator()).decodeUTF8().split("\n").map(e=>(e.endsWith("\r")&&(e=e.slice(0,-1)),e))}}const eb=Symbol("out"),tb=Symbol("field"),nb=Symbol("quote"),sb=Symbol("quoteafterquote"),rb=Symbol("quoteinquote");class ab extends Yy{constructor(e,t){super(),this.input=e,this.hasHeader=!0,this.fullColumnNames=null,this.columnNamesValidated=!1,this.columnConfigs=null,this.configuredColumnsOnly=!1,this.delimiter=",",this.delimWhitespace=!1,this.base=new Qy(e),t||(t={}),this.hasHeader=!1!==t.hasHeader,this.fullColumnNames=t.columnNames,this.columnConfigs=t.columnConfigs,this.configuredColumnsOnly=t.configuredColumnsOnly,t.delimWhitespace?(l(null==t.delimiter,()=>"Delimiter should not be provided when delimWhitespace is true."),this.delimWhitespace=!0,this.delimiter=" "):this.delimiter=t.delimiter?t.delimiter:","}async columnNames(){return this.columnNamesValidated||await this.setColumnNames(),this.configuredColumnsOnly?Object.keys(this.columnConfigs):this.fullColumnNames}async setColumnNames(){const e=await this.maybeReadHeaderLine();if(!this.fullColumnNames&&!e)throw new Error("Column names must be provided if there is no header line.");this.fullColumnNames&&e&&l(e.length===this.fullColumnNames.length,()=>"The length of provided columnNames ("+this.fullColumnNames.length.toString()+") does not match the length of the header line read from file ("+e.length.toString()+")."),this.fullColumnNames||(this.fullColumnNames=e);const t=this.fullColumnNames.reduce((e,t)=>(e[t]=e[t]+1||1,e),{}),n=Object.keys(t).filter(e=>t[e]>1);if(l(0===n.length,()=>"Duplicate column names found: "+n.toString()),this.columnConfigs)for(const e of Object.keys(this.columnConfigs)){if(-1===this.fullColumnNames.indexOf(e))throw new Error('The key "'+e+'" provided in columnConfigs does not match any of the column names ('+this.fullColumnNames.toString()+").")}this.columnNamesValidated=!0}async maybeReadHeaderLine(){if(this.hasHeader){const e=await this.base.iterator(),t=await e.next();if(t.done)throw new Error("No data was found for CSV parsing.");const n=t.value;return this.parseRow(n,!1)}return null}async iterator(){this.columnNamesValidated||await this.setColumnNames();let e=await this.base.iterator();return this.hasHeader&&(e=e.skip(1)),e.map(e=>this.makeDataElement(e))}makeDataElement(e){const t=this.parseRow(e),n={},s={};for(let r=0;r<this.fullColumnNames.length;r++){const a=this.fullColumnNames[r],i=this.columnConfigs?this.columnConfigs[a]:null;if(!this.configuredColumnsOnly||i){const o=t[r];let l=null;if(""===o)if(i&&void 0!==i.default)l=i.default;else{if(i&&(i.required||i.isLabel))throw new Error(`Required column ${a} is empty in this line: ${e}`);l=void 0}else{const e=Number(o);if(isNaN(e))l=i&&"bool"===i.dtype?this.getBoolean(o):o;else if(i&&i.dtype)switch(i.dtype){case"float32":l=e;break;case"int32":l=Math.floor(e);break;case"bool":l=this.getBoolean(o);break;default:l=e}else l=e}i&&i.isLabel?s[a]=l:n[a]=l}}return 0===Object.keys(s).length?n:{xs:n,ys:s}}getBoolean(e){return"1"===e||"true"===e.toLowerCase()?1:0}parseRow(e,t=!0){const n=[];let s=0;const r=e.length;let a=eb;for(let t=0;t<r;t++)switch(a){case eb:switch(e.charAt(t)){case'"':s=t+1,a=nb;break;case this.delimiter:if(s=t+1," "===this.delimiter&&this.delimWhitespace)break;n.push(""),a=eb;break;default:a=tb,s=t}break;case tb:switch(e.charAt(t)){case this.delimiter:n.push(e.substring(s,t)),a=eb,s=t+1}break;case nb:switch(e.charAt(t)){case'"':a=sb}break;case sb:switch(e.charAt(t)){case this.delimiter:n.push(e.substring(s,t-1)),a=eb,s=t+1;break;case'"':a=nb;break;default:a=rb}break;case rb:switch(e.charAt(t)){case'"':a=nb}}if(a===sb?n.push(e.substring(s,r-1)):n.push(e.substring(s)),t&&n.length!==this.fullColumnNames.length)throw new Error(`Invalid row in csv file. Should have ${this.fullColumnNames.length} elements in a row, but got ${n}`);return n}}class ib extends Fy{constructor(e){super(),this.microphoneConfig=e,this.isClosed=!1,this.fftSize=e.fftSize||1024;const t=Math.log2(this.fftSize);if(this.fftSize<0||t<4||t>14||!Number.isInteger(t))throw new Error("Invalid fftSize: it must be a power of 2 between 2 to 4 and 2 to 14, but got "+this.fftSize);if(this.numFrames=e.numFramesPerSpectrogram||43,this.sampleRateHz=e.sampleRateHz,this.columnTruncateLength=e.columnTruncateLength||this.fftSize,this.audioTrackConstraints=e.audioTrackConstraints,this.smoothingTimeConstant=e.smoothingTimeConstant||0,this.includeSpectrogram=!1!==e.includeSpectrogram,this.includeWaveform=!0===e.includeWaveform,!this.includeSpectrogram&&!this.includeWaveform)throw new Error("Both includeSpectrogram and includeWaveform are false. At least one type of data should be returned.")}summary(){return"microphone"}static async create(e={}){if(H().get("IS_NODE"))throw new Error("microphone API is only supported in browser environment.");const t=new ib(e);return await t.start(),t}async start(){try{this.stream=await navigator.mediaDevices.getUserMedia({audio:null==this.audioTrackConstraints||this.audioTrackConstraints,video:!1})}catch(e){throw new Error("Error thrown while initializing video stream: "+e.message)}if(!this.stream)throw new Error("Could not obtain audio from microphone.");const e=window.AudioContext||window.webkitAudioContext;if(this.audioContext=new e,this.sampleRateHz){if(this.audioContext.sampleRate!==this.sampleRateHz)throw new Error(`Mismatch in sampling rate: Expected: ${this.sampleRateHz}; Actual: `+this.audioContext.sampleRate)}else this.sampleRateHz=this.audioContext.sampleRate;const t=this.audioContext.createMediaStreamSource(this.stream);this.analyser=this.audioContext.createAnalyser(),this.analyser.fftSize=2*this.fftSize,this.analyser.smoothingTimeConstant=this.smoothingTimeConstant,t.connect(this.analyser),this.freqData=new Float32Array(this.fftSize),this.timeData=new Float32Array(this.fftSize)}async next(){if(this.isClosed)return{value:null,done:!0};let e,t;const n=await this.getAudioData();if(this.includeSpectrogram){const t=this.flattenQueue(n.freqDataQueue);e=this.getTensorFromAudioDataArray(t,[this.numFrames,this.columnTruncateLength,1])}if(this.includeWaveform){const e=this.flattenQueue(n.timeDataQueue);t=this.getTensorFromAudioDataArray(e,[this.numFrames*this.fftSize,1])}return{value:{spectrogram:e,waveform:t},done:!1}}async capture(){return(await this.next()).value}async getAudioData(){const e=[],t=[];let n=0;return new Promise(s=>{const r=setInterval(()=>{this.includeSpectrogram&&(this.analyser.getFloatFrequencyData(this.freqData),this.freqData[0]===-1/0&&s({freqDataQueue:e,timeDataQueue:t}),e.push(this.freqData.slice(0,this.columnTruncateLength))),this.includeWaveform&&(this.analyser.getFloatTimeDomainData(this.timeData),t.push(this.timeData.slice())),++n===this.numFrames&&(clearInterval(r),s({freqDataQueue:e,timeDataQueue:t}))},this.fftSize/this.sampleRateHz*1e3)})}stop(){this.isClosed||(this.isClosed=!0,this.analyser.disconnect(),this.audioContext.close(),null!=this.stream&&this.stream.getTracks().length>0&&this.stream.getTracks()[0].stop())}toArray(){throw new Error("Can not convert infinite audio stream to array.")}getSampleRate(){return this.sampleRateHz}flattenQueue(e){const t=e[0].length,n=new Float32Array(e.length*t);return e.forEach((e,s)=>n.set(e,s*t)),n}getTensorFromAudioDataArray(e,t){const n=new Float32Array(p(t));return n.set(e,n.length-e.length),ht(n,t)}}class ob extends Fy{constructor(e,t){if(super(),this.webcamVideoElement=e,this.webcamConfig=t,this.isClosed=!0,this.resize=!1,this.needToResize())if(this.resize=!0,this.cropSize=[this.webcamConfig.resizeHeight,this.webcamConfig.resizeWidth],this.cropBoxInd=Ki([0],"int32"),this.webcamConfig.centerCrop){const e=1*this.webcamConfig.resizeWidth/this.webcamVideoElement.width,t=1*this.webcamConfig.resizeHeight/this.webcamVideoElement.height,n=(1-e)/2,s=(1-t)/2,r=n+e,a=t+s;this.cropBox=Xi([s,n,a,r],[1,4])}else this.cropBox=Xi([0,0,1,1],[1,4])}summary(){return"webcam"}static async create(e,t={}){if(H().get("IS_NODE"))throw new Error("tf.data.webcam is only supported in browser environment.");if(!e){if(e=document.createElement("video"),!t.resizeWidth||!t.resizeHeight)throw new Error("Please provide webcam video element, or resizeWidth and resizeHeight to create a hidden video element.");e.width=t.resizeWidth,e.height=t.resizeHeight}const n=new ob(e,t);return await n.start(),n}async start(){this.webcamConfig.facingMode&&l("user"===this.webcamConfig.facingMode||"environment"===this.webcamConfig.facingMode,()=>`Invalid webcam facing mode: ${this.webcamConfig.facingMode}. Please provide 'user' or 'environment'`);try{this.stream=await navigator.mediaDevices.getUserMedia({video:{deviceId:this.webcamConfig.deviceId,facingMode:this.webcamConfig.facingMode?this.webcamConfig.facingMode:"user",width:this.webcamVideoElement.width,height:this.webcamVideoElement.height}})}catch(e){throw e.message="Error thrown while initializing video stream: "+e.message,e}if(!this.stream)throw new Error("Could not obtain video from webcam.");try{this.webcamVideoElement.srcObject=this.stream}catch(e){console.log(e),this.webcamVideoElement.src=window.URL.createObjectURL(this.stream)}return this.webcamVideoElement.play(),this.isClosed=!1,new Promise(e=>{this.webcamVideoElement.onloadedmetadata=()=>{e()}})}async next(){if(this.isClosed)return{value:null,done:!0};let e;try{e=kn(this.webcamVideoElement)}catch(e){throw new Error("Error thrown converting video to pixels: "+JSON.stringify(e))}if(!this.resize)return{value:e,done:!1};try{return{value:this.cropAndResizeFrame(e),done:!1}}catch(e){throw new Error("Error thrown cropping the video: "+e.message)}finally{e.dispose()}}needToResize(){return!(!this.webcamConfig.resizeWidth||!this.webcamConfig.resizeHeight||this.webcamVideoElement.width===this.webcamConfig.resizeWidth&&this.webcamVideoElement.height===this.webcamConfig.resizeHeight)}cropAndResizeFrame(e){return rs(()=>{const t=Dr(Xt(e,"float32"),0);let n;n=dl.cropAndResize(t,this.cropBox,this.cropBoxInd,this.cropSize,"bilinear");const s=n.shape;return Ps(n,s.slice(1))})}async capture(){return(await this.next()).value}stop(){this.stream.getTracks().forEach(e=>e.stop());try{this.webcamVideoElement.srcObject=null}catch(e){console.log(e),this.webcamVideoElement.src=null}this.isClosed=!0}toArray(){throw new Error("Can not convert infinite video stream to array.")}}class lb{}class ub extends Fy{split(e){return new cb(this,e)}}class cb extends ub{constructor(e,t){super(),this.upstream=e,this.impl=new hb(e,t)}summary(){return this.impl.summary()}async next(){return this.impl.next()}}class hb extends Uy{constructor(e,t){super(),this.upstream=e,this.separator=t,this.carryover=""}summary(){return`${this.upstream.summary()} -> Split('${this.separator}')`}async pump(){const e=await this.upstream.next();if(e.done)return""!==this.carryover&&(this.outputQueue.push(this.carryover),this.carryover="",!0);const t=e.value.split(this.separator);t[0]=this.carryover+t[0];for(const e of t.slice(0,-1))this.outputQueue.push(e);return this.carryover=t[t.length-1],!0}}class pb extends Fy{decodeUTF8(){return new db(this)}}class db extends ub{constructor(e){super(),this.upstream=e,this.impl=new fb(e)}summary(){return this.impl.summary()}async next(){return this.impl.next()}}class fb extends Uy{constructor(e){if(super(),this.upstream=e,H().get("IS_BROWSER"))this.decoder=new TextDecoder("utf-8");else{const{StringDecoder:e}=require("string_decoder");this.decoder=new e("utf8")}}summary(){return this.upstream.summary()+" -> Utf8"}async pump(){const e=await this.upstream.next();let t,n;return!e.done&&(t=e.value,n=H().get("IS_BROWSER")?this.decoder.decode(t,{stream:!0}):this.decoder.write(Buffer.from(t.buffer)),this.outputQueue.push(n),!0)}}class mb extends pb{constructor(e,t={}){super(),this.file=e,this.options=t,l(e instanceof Uint8Array||!!H().get("IS_BROWSER")&&(e instanceof File||e instanceof Blob),()=>"FileChunkIterator only supports File, Blob and Uint8Array right now."),this.offset=t.offset||0,this.chunkSize=t.chunkSize||1048576}summary(){return"FileChunks "+this.file}async next(){if(this.offset>=(this.file instanceof Uint8Array?this.file.byteLength:this.file.size))return{value:null,done:!0};const e=new Promise((e,t)=>{const n=this.offset+this.chunkSize;if(this.file instanceof Uint8Array)e(new Uint8Array(this.file.slice(this.offset,n)));else{const s=new FileReader;s.onload=n=>{let r=s.result;if(r instanceof ArrayBuffer&&(r=new Uint8Array(r)),!(r instanceof Uint8Array))return t(new TypeError("FileReader returned unknown type."));e(r)},s.onabort=e=>t(new Error("Aborted")),s.onerror=e=>t(new Error(e.type));const r=this.file.slice(this.offset,n);s.readAsArrayBuffer(r)}this.offset=n});return{value:await e,done:!1}}}const gb=e=>({method:e.method,headers:e.headers,body:e.body,mode:e.mode,credentials:e.credentials,cache:e.cache,redirect:e.redirect,referrer:e.referrer,integrity:e.integrity});function yb(e){return"string"==typeof e&&"file://"===e.substr(0,7)}class bb extends lb{constructor(e,t={}){super(),this.input=e,this.options=t}async iterator(){if(yb(this.input)&&H().get("IS_NODE")){const e=require("fs");this.input=e.readFileSync(this.input.substr(7))}return new mb(this.input,this.options)}}class xb extends lb{constructor(e,t={}){super(),this.url=e,this.fileOptions=t}async iterator(){return yb(this.url)?new bb(this.url,this.fileOptions).iterator():async function(e,t={}){let n,s;"string"==typeof e?n=e:(n=e.url,s=gb(e));const r=await ye(n,s);if(r.ok){const e=new Uint8Array(await r.arrayBuffer());return new mb(e,t)}throw new Error(r.statusText)}(this.url,this.fileOptions)}}var wb=Object.freeze({__proto__:null,array:function(e){return Jy(async()=>$y(e),e.length)},Dataset:Yy,zip:function(e){if(!Iy(e))throw new Error("The argument to zip() must be an object or array.");let t;if(Array.isArray(e))for(let n=0;n<e.length;n++)t=null==t?e[n].size:Math.min(t,e[n].size);else if(e instanceof Object)for(const n in e)t=null==t?e[n].size:Math.min(t,e[n].size);return Jy(async()=>function(e,t=jy.FAIL){return new qy(e,t)}(await Ny(e,e=>{if(e instanceof Yy)return{value:e.iterator(),recurse:!1};if(Iy(e))return{value:null,recurse:!0};throw new Error("Leaves of the structure passed to zip() must be Datasets, not primitives.")}),jy.SHORTEST),t)},CSVDataset:ab,TextLineDataset:Qy,csv:function(e,t={}){return new ab(new xb(e),t)},func:function(e){const t=Ay(e);return Jy(async()=>t)},generator:function(e){return Jy(async()=>{const t=await e();return Ay(()=>t.next())})},microphone:async function(e){return ib.create(e)},webcam:async function(e,t){return ob.create(e,t)},FileDataSource:bb,URLDataSource:xb,version_data:"3.0.0"});function kb(e,t){Array.isArray(e)||(e=[e]),e.forEach(e=>{null!=e&&l("complex64"!==e.dtype,()=>t+" does not support complex64 tensors in the CPU backend.")})}const vb=no;class Nb extends n{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new t(this,ns())}write(e,t,n){this.firstUse&&(this.firstUse=!1,H().get("IS_NODE")&&zl("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));const s={};return this.data.set(s,{values:e,dtype:n,refCount:1}),s}makeTensorInfo(e,t,n){let s;if("string"===t&&null!=n&&n.length>0&&$(n[0])){const r=n.map(e=>be(e));s=this.write(r,e,t)}else s=this.write(n,e,t);return{dataId:s,shape:e,dtype:t}}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,n,s){this.data.set(e,{values:t,dtype:s,refCount:1})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:t,complexTensorInfos:n}=this.data.get(e);if("complex64"===t){return Bl(this.readSync(n.real.dataId),this.readSync(n.imag.dataId))}return this.data.get(e).values}bufferSync(e){const t=this.readSync(e.dataId);let n=t;if("string"===e.dtype)try{n=t.map(e=>xe(e))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return Kt(e.shape,e.dtype,n)}makeOutput(e,t,n){const s=this.write(e,t,n);return ns().makeTensorFromDataId(s,t,n,this)}disposeData(e){if(this.data.has(e)){const{complexTensorInfos:t}=this.data.get(e);null!=t&&(this.disposeData(t.real.dataId),this.disposeData(t.imag.dataId)),this.data.delete(e)}}disposeIntermediateTensorInfo(e){const t=e.dataId;if(this.data.has(t)){const e=this.data.get(t);e.refCount--,e.refCount<1&&this.disposeData(t)}}async time(e){const t=ge();return e(),{kernelMs:ge()-t}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}where(e){kb([e],"where");const t=this.readSync(e.dataId);return vb(e.shape,t)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}}function Ib(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t}const Cb={kernelName:"Abs",backendName:"cpu",kernelFunc:e=>{const{x:t}=e.inputs,n=e.backend;kb(t,"abs");let s=new Float32Array(p(t.shape));return s=Ib(n.data.get(t.dataId).values),n.makeOutput(s,t.shape,"float32")}};function Sb(e){return(t,n,s,r,a)=>{const i=Ir(t,n),o=i.length,l=O(i),u=k(a,p(i)),c=t.length,h=n.length,d=O(t),f=O(n),m=vr(t,i),g=vr(n,i);if(m.length+g.length===0)for(let t=0;t<u.length;++t)u[t]=e(s[t%s.length],r[t%r.length]);else for(let t=0;t<u.length;++t){const n=V(t,o,l),a=n.slice(-c);m.forEach(e=>a[e]=0);const i=W(a,c,d),p=n.slice(-h);g.forEach(e=>p[e]=0);const y=W(p,h,f);u[t]=e(s[i],r[y])}return[u,i]}}function Tb(e){const{inputs:t,backend:n}=e,{real:s,imag:r}=t,a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,o=n.makeTensorInfo(s.shape,"complex64");return n.data.get(o.dataId).complexTensorInfos={real:n.makeTensorInfo(s.shape,"float32",a),imag:n.makeTensorInfo(r.shape,"float32",i)},o}const Eb={kernelName:"Complex",backendName:"cpu",kernelFunc:Tb};function $b(e,t,n="float32"){if("complex64"===n){return Tb({inputs:{real:$b(e,t,"float32"),imag:$b(e,t,"float32")},backend:e})}const s=z(p(t),n);return e.makeTensorInfo(t,n,s)}function Ab(e){const{inputs:t,backend:n}=e,{x:s}=t;return n.incRef(s.dataId),{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}const Rb={kernelName:"Identity",backendName:"cpu",kernelFunc:Ab};function Fb(e){const{inputs:t,backend:n}=e,{input:s}=t,r=n.data.get(s.dataId).complexTensorInfos.real,a=n.data.get(r.dataId).values;return n.makeTensorInfo(r.shape,r.dtype,a)}const Db={kernelName:"Real",backendName:"cpu",kernelFunc:Fb};function _b(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dtype:a}=s;if("complex64"===a){if("complex64"===r.dtype)return Ab({inputs:{x:r},backend:n});const e=$b(n,r.shape,r.dtype),t=_b({inputs:{x:r},backend:n,attrs:{dtype:"float32"}}),s=Tb({inputs:{real:t,imag:e},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),s}if("complex64"===r.dtype){const e=Fb({inputs:{input:r},backend:n}),t=_b({inputs:{x:e},backend:n,attrs:{dtype:a}});return n.disposeIntermediateTensorInfo(e),t}if(!C(r.dtype,a)){const e=Ab({inputs:{x:r},backend:n});return{dataId:e.dataId,shape:e.shape,dtype:a}}if("int32"===a){const e=n.data.get(r.dataId).values,t=Int32Array.from(e);return n.makeTensorInfo(r.shape,"int32",t)}if("bool"===a){const e=n.data.get(r.dataId).values,t=me([0],r.dtype),[s,a]=Sb((e,t)=>e!==t?1:0)(r.shape,[],e,t,"bool");return n.makeTensorInfo(a,"bool",s)}throw new Error(`Error in Cast: failed to cast ${r.dtype} to ${a}`)}const Ob={kernelName:"Cast",backendName:"cpu",kernelFunc:_b};function Mb(e,t,n,s){return null==n?({inputs:n,backend:r})=>{const{a:a,b:i}=n,o=r;kb([a,i],e);const l=o.data.get(a.dataId).values,u=o.data.get(i.dataId).values,c=s||a.dtype,[h,p]=t(a.shape,i.shape,l,u,c);return o.makeTensorInfo(p,c,h)}:({inputs:e,backend:r})=>{const{a:a,b:i}=e,o=r;if("complex64"===a.dtype||"complex64"===i.dtype){const e=_b({inputs:{x:a},backend:o,attrs:{dtype:"complex64"}}),t=o.data.get(e.dataId),s=t.complexTensorInfos.real,r=t.complexTensorInfos.imag,l=o.data.get(s.dataId).values,u=o.data.get(r.dataId).values,c=_b({inputs:{x:i},backend:o,attrs:{dtype:"complex64"}}),h=o.data.get(c.dataId),p=h.complexTensorInfos.real,d=h.complexTensorInfos.imag,f=o.data.get(p.dataId).values,m=o.data.get(d.dataId).values,[g,y,b]=n(a.shape,i.shape,l,u,f,m),x=o.makeTensorInfo(b,"float32",g),w=o.makeTensorInfo(b,"float32",y),k=Tb({inputs:{real:x,imag:w},backend:o});return o.disposeIntermediateTensorInfo(e),o.disposeIntermediateTensorInfo(c),o.disposeIntermediateTensorInfo(x),o.disposeIntermediateTensorInfo(w),k}{const e=o.data.get(a.dataId).values,n=o.data.get(i.dataId).values,r=s||a.dtype,[l,u]=t(a.shape,i.shape,e,n,r);return o.makeTensorInfo(u,r,l)}}}function Lb(e){return(t,n,s,r,a,i)=>{const o=Ir(t,n),l=p(o),u=o.length,c=O(o),h=k("float32",l),d=k("float32",l),f=vr(t,o),m=vr(n,o),g=Bl(s,r),y=Bl(a,i),b=t.length,x=O(t),w=n.length,v=O(n);if(f.length+m.length===0)for(let t=0;t<h.length;t++){const n=t%g.length,s=t%y.length,r=e(g[2*n],g[2*n+1],y[2*s],y[2*s+1]);h[t]=r.real,d[t]=r.imag}else for(let t=0;t<h.length;t++){const n=V(t,u,c),s=n.slice(-b);f.forEach(e=>s[e]=0);const r=W(s,b,x),a=n.slice(-w);m.forEach(e=>a[e]=0);const i=W(a,w,v),o=e(g[2*r],g[2*r+1],y[2*i],y[2*i+1]);h[t]=o.real,d[t]=o.imag}return[h,d,o]}}const zb=Sb((e,t)=>e+t),Bb=Lb((e,t,n,s)=>({real:e+n,imag:t+s})),Pb=Mb(X,zb,Bb),Wb={kernelName:X,backendName:"cpu",kernelFunc:Pb};function Vb(e,t,n,s,r){const a=p(s),i=z(r,n);for(let n=0;n<e.length;n++){const s=e[n];if(s<0)throw new Error("Input x must be non-negative!");s>=r||(i[s]+=a>0?t[n]:1)}return i}function Ub(e,t,n,s=!1){const r=e.shape[0],a=e.shape[1],i=Kt([r,n],t.dtype);for(let o=0;o<r;o++)for(let r=0;r<a;r++){const a=e.get(o,r);if(a<0)throw new Error("Input x must be non-negative!");a>=n||(s?i.set(1,o,a):t.size>0?i.set(i.get(o,a)+t.get(o,r),o,a):i.set(i.get(o,a)+1,o,a))}return i}function Gb(e){return(t,n,s)=>{const r=k(n,t.length);for(let n=0;n<t.length;++n)r[n]=e(t[n],s);return r}}function Hb(e,t,n){return({inputs:s,attrs:r,backend:a})=>{const{x:i}=s;if(kb(i,e),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const o=a,l=o.data.get(i.dataId).values,u=p(i.shape),c=n||i.dtype,h=v(c,u);for(let e=0;e<u;++e)h[e]=t(l[e],r);return o.makeTensorInfo(i.shape,c,h)}}function jb(e,t,n){return({inputs:s,attrs:r,backend:a})=>{const{x:i}=s;if(kb(i,e),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const o=a,l=o.data.get(i.dataId).values,u=n||i.dtype,c=t(l,u,r);return o.makeTensorInfo(i.shape,u,c)}}const qb=Gb(e=>Math.ceil(e)),Kb={kernelName:"Ceil",backendName:"cpu",kernelFunc:jb("Ceil",qb)};function Xb(e,t,n,s){const r=v(n,p(t));if(s&&"string"!==n){let t=0;e.forEach(e=>{const n=p(e.shape);r.set(e.vals,t),t+=n})}else{let s=0;e.forEach(e=>{const a="string"===n?Zl(e.vals):e.vals;let i=0;for(let n=0;n<e.shape[0];++n){const o=n*t[1]+s;for(let t=0;t<e.shape[1];++t)r[o+t]=a[i++]}s+=e.shape[1]})}return r}const Yb=Gb(e=>Math.exp(e)),Jb=jb(Q,Yb),Zb={kernelName:Q,backendName:"cpu",kernelFunc:Jb},Qb=Gb(e=>Math.expm1(e)),ex={kernelName:"Expm1",backendName:"cpu",kernelFunc:jb("Expm1",Qb)},tx=Gb(e=>Math.floor(e)),nx={kernelName:"Floor",backendName:"cpu",kernelFunc:jb("Floor",tx)};function sx(e,t,n){const s=Kt(n,e.dtype);for(let n=0;n<s.size;++n){const r=s.indexToLoc(n).slice(),a=r[0],i=r[2],o=t.locToIndex([a,i]);r[2]=t.values[o];const l=e.locToIndex(r);s.values[n]=e.values[l]}return s}const rx=Sb((e,t)=>e>t?1:0),ax={kernelName:"Greater",backendName:"cpu",kernelFunc:Mb("Greater",rx,null,"bool")},ix=Sb((e,t)=>e<t?1:0),ox={kernelName:"Less",backendName:"cpu",kernelFunc:Mb("Less",ix,null,"bool")};function lx(e,t,n){const s=(t-e)/(n-1),r=z(n,"float32");r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+s;return r}const ux=Gb(e=>Math.log(e)),cx=jb(ee,ux),hx={kernelName:ee,backendName:"cpu",kernelFunc:cx};function px(e,t,n,s){const r=k(s,p(n));for(let n=0;n<r.length;++n){const s=n*t;let a=e[s];for(let n=0;n<t;++n){const t=e[s+n];t>a&&(a=t)}r[n]=a}return r}const dx=Sb((e,t)=>Math.max(e,t)),fx={kernelName:"Maximum",backendName:"cpu",kernelFunc:Mb("Maximum",dx)},mx=Sb((e,t)=>Math.min(e,t)),gx={kernelName:"Minimum",backendName:"cpu",kernelFunc:Mb("Minimum",mx)},yx=Sb((e,t)=>e*t),bx=Lb((e,t,n,s)=>({real:e*n-t*s,imag:e*s+t*n})),xx=Mb("Multiply",yx,bx),wx={kernelName:"Multiply",backendName:"cpu",kernelFunc:xx};function kx(e,t,n){const s=fe(-1,n);return yx([],t,s,e,n)}const vx={kernelName:"Neg",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;kb(s,"neg");const r=n.data.get(s.dataId).values,[a,i]=kx(r,s.shape,s.dtype);return n.makeTensorInfo(i,s.dtype,a)}},Nx=Sb((e,t)=>e!==t?1:0),Ix={kernelName:"NotEqual",backendName:"cpu",kernelFunc:Mb("NotEqual",Nx,null,"bool")};function Cx(e,t,n,s,r){const a=t.length,i=p(t),o=O(t),l=O(r),u=k(n,p(r));for(let t=0;t<i;++t){const n=V(t,a,o),r=new Array(n.length);for(let e=0;e<r.length;e++)r[e]=n[s[e]];u[W(r,a,l)]=e[t]}return u}function Sx(e){const{inputs:t,attrs:n,backend:s}=e,{x:r}=t,{perm:a}=n;kb(r,"transpose");const i=r.shape.length,o=new Array(i);for(let e=0;e<o.length;e++)o[e]=r.shape[a[e]];const l=Cx(s.data.get(r.dataId).values,r.shape,r.dtype,a,o);return{dataId:s.write(l,o,r.dtype),shape:o,dtype:r.dtype}}const Tx={kernelName:"Transpose",backendName:"cpu",kernelFunc:Sx};function Ex(e,t,n,s){const[r,a]=ha(e,s),i=We(t,"int32"),o=z(p(r),i),l=p(a);for(let e=0;e<o.length;++e){const t=e*l;let s=1;for(let e=0;e<l;++e)s*=n[t+e];o[e]=s}return{outVals:o,outShape:r,outDtype:i}}const $x={kernelName:"Prod",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;kb(r,"prod");const o=r.shape.length,l=x(a,r.shape),u=fa(l,o);let c=l,h=r;const p=[];null!=u&&(h=Sx({inputs:{x:r},backend:n,attrs:{perm:u}}),p.push(h),c=ga(c.length,o));const d=n.data.get(h.dataId).values,{outVals:f,outShape:m,outDtype:g}=Ex(h.shape,h.dtype,d,c);let y=m;return i&&(y=pa(m,l)),p.forEach(e=>n.disposeIntermediateTensorInfo(e)),n.makeTensorInfo(y,g,f)}};function Ax(e,t,n,s){if(e===t||e<t&&n<0||t<e&&n>1)return z(0,s);const r=z(Math.abs(Math.ceil((t-e)/n)),s);t<e&&1===n&&(n=-1),r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+n;return r}const Rx=Gb(e=>1/Math.sqrt(e)),Fx={kernelName:"Rsqrt",backendName:"cpu",kernelFunc:jb("Rsqrt",Rx)};function Dx(e,t,n,s,r){const a=Wn(s,t,n),i=p(n),o=O(s);if(a){const n=Vn(t,o);return"string"===r?e.slice(n,n+i):e.subarray(n,n+i)}const l=Kt(s,r,"string"===r?Zl(e):e),u=Kt(n,r);for(let e=0;e<u.size;++e){const n=u.indexToLoc(e),s=n.map((e,n)=>e+t[n]);u.set(l.get(...s),...n)}return"string"===r?Ql(u.values):u.values}function _x(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,size:i}=s;kb(r,"slice");const[o,l]=Un(r,a,i);$n(r,o,l);const u=Dx(n.data.get(r.dataId).values,o,l,r.shape,r.dtype);return n.makeTensorInfo(l,r.dtype,u)}const Ox={kernelName:"Slice",backendName:"cpu",kernelFunc:_x},Mx=Sb((e,t)=>{const n=e-t;return n*n}),Lx={kernelName:"SquaredDifference",backendName:"cpu",kernelFunc:Mb("SquaredDifference",Mx)};function zx(e,t,n,s){const r=Kt(e,t.dtype);for(let e=0;e<r.size;e++){const a=r.indexToLoc(e),i=new Array(a.length);for(let e=0;e<i.length;e++)i[e]=a[e]*n[e]+s[e];r.set(t.get(...i),...a)}return r}const Bx=Sb((e,t)=>e-t),Px=Lb((e,t,n,s)=>({real:e-n,imag:t-s})),Wx=Mb(re,Bx,Px),Vx={kernelName:re,backendName:"cpu",kernelFunc:Wx};function Ux(e,t){const n=new Array(e.rank);for(let s=0;s<n.length;s++)n[s]=e.shape[s]*t[s];const s=Kt(n,e.dtype);for(let t=0;t<s.values.length;++t){const n=s.indexToLoc(t),r=new Array(e.rank);for(let t=0;t<r.length;t++)r[t]=n[t]%e.shape[t];const a=e.locToIndex(r);s.values[t]=e.values[a]}return s}function Gx(e,t,n,s,r){const a=t[t.length-1],[i,o]=[e.length/a,a],l=k(n,i*s),u=k("int32",i*s);for(let t=0;t<i;t++){const n=t*o,r=e.subarray(n,n+o),a=[];for(let e=0;e<r.length;e++)a.push({value:r[e],index:e});a.sort((e,t)=>t.value-e.value);const i=t*s,c=l.subarray(i,i+s),h=u.subarray(i,i+s);for(let e=0;e<s;e++)c[e]=a[e].value,h[e]=a[e].index}const c=t.slice();return c[c.length-1]=s,[Kt(c,n,l),Kt(c,"int32",u)]}function Hx(e,t,n,s){const r=x(t,n)[0],a=[1,n[0],1];for(let e=0;e<r;e++)a[0]*=n[e];a[1]=n[r];for(let e=r+1;e<n.length;e++)a[2]*=n[e];const i={},o=new Int32Array(n[r]),l=new Ee(a,s,e),u=[],c=1===a[0]&&1===a[2];for(let t=0;t<n[r];t++){let n;if(c)n=e[t].toString();else{const e=[];for(let n=0;n<a[0];n++)for(let s=0;s<a[2];s++)e.push(l.get(n,t,s));n=e.join(",")}if(void 0!==i[n])o[t]=i[n];else{const e=Object.keys(i).length;i[n]=e,o[t]=e,u.push(t)}}const h=a.slice();h[1]=Object.keys(i).length;const p=new Ee(h,s);u.forEach((e,t)=>{for(let n=0;n<a[0];n++)for(let s=0;s<a[2];s++)p.set(l.get(n,e,s),n,t,s)});const d=n.slice();return d[r]=h[1],{outputValues:p.values,outputShape:d,indices:o}}var jx=Object.freeze({__proto__:null,simpleAbsImpl:Ib,addImpl:zb,bincountImpl:Vb,bincountReduceImpl:Ub,ceilImpl:qb,concatImpl:Xb,expImpl:Yb,expm1Impl:Qb,floorImpl:tx,gatherV2Impl:sx,greaterImpl:rx,lessImpl:ix,linSpaceImpl:lx,logImpl:ux,maxImpl:px,maximumImpl:dx,minimumImpl:mx,multiplyImpl:yx,negImpl:kx,notEqualImpl:Nx,prodImpl:Ex,rangeImpl:Ax,rsqrtImpl:Rx,sliceImpl:Dx,squaredDifferenceImpl:Mx,stridedSliceImpl:zx,subImpl:Bx,tileImpl:Ux,topKImpl:Gx,transposeImpl:Cx,uniqueImpl:Hx});ls("cpu",()=>new Nb,1);const qx=Hb(J,e=>e>=0?e:Math.exp(e)-1),Kx={kernelName:J,backendName:"cpu",kernelFunc:qx};function Xx(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{alpha:a}=s;kb([r],"leakyRelu");const i=p(r.shape),o=n.data.get(r.dataId).values,l=k("float32",i);for(let e=0;e<o.length;e++)l[e]=o[e]<0?a*o[e]:o[e];return n.makeTensorInfo(r.shape,"float32",l)}const Yx={kernelName:"LeakyRelu",backendName:"cpu",kernelFunc:Xx},Jx=Sb((e,t)=>e<0?t*e:e);function Zx(e){const{inputs:t,backend:n}=e,{x:s,alpha:r}=t;kb([s,r],"prelu");const a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,[o,l]=Jx(s.shape,r.shape,a,i,s.dtype);return n.makeTensorInfo(l,s.dtype,o)}const Qx={kernelName:"Prelu",backendName:"cpu",kernelFunc:Zx},ew=Hb("Relu",e=>Math.max(0,e)),tw={kernelName:"Relu",backendName:"cpu",kernelFunc:ew},nw=Hb("Relu6",e=>Math.min(Math.max(0,e),6)),sw={kernelName:"Relu6",backendName:"cpu",kernelFunc:nw};function rw(e,t,n,s,r){if("linear"===n)return Ab({inputs:{x:t},backend:e});if("relu"===n)return ew({inputs:{x:t},backend:e});if("elu"===n)return qx({inputs:{x:t},backend:e});if("relu6"===n)return nw({inputs:{x:t},backend:e});if("prelu"===n)return Zx({inputs:{x:t,alpha:s},backend:e});if("leakyrelu"===n)return Xx({inputs:{x:t},backend:e,attrs:{alpha:r}});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function aw(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{shape:a}=s,i=p(r.shape),o=b(a,i),u=p(o);l(i===u,()=>`The new shape (${o}) has ${u} elements and the old shape (${r.shape}) has ${i} elements. The new shape and old shape must have the same number of elements.`),n.incRef(r.dataId);const c=n.data.get(r.dataId);if(null!=c.complexTensorInfos){const e=c.complexTensorInfos.real,t=c.complexTensorInfos.imag;e.shape=o,t.shape=o}return{dataId:r.dataId,shape:o,dtype:r.dtype}}const iw={kernelName:"Reshape",backendName:"cpu",kernelFunc:aw};function ow(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a}=t,{transposeA:i,transposeB:o}=s;kb([r,a],"matMul");const u=r.shape.length,c=a.shape.length,h=i?r.shape[u-2]:r.shape[u-1],d=o?a.shape[c-1]:a.shape[c-2],f=i?r.shape[u-1]:r.shape[u-2],m=o?a.shape[c-2]:a.shape[c-1],g=r.shape.slice(0,-2),y=a.shape.slice(0,-2),b=p(g),x=p(y);l(u>=2&&c>=2&&(b===x||1===b||1===x),()=>`Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of (${g}) and (${y}).`);const w=(b>x?r.shape.slice(0,-2):a.shape.slice(0,-2)).concat([f,m]);l(h===d,()=>`Error in matMul: inner shapes (${h}) and (${d}) of Tensors with shapes ${r.shape} and ${a.shape} and transposeA=${i} and transposeB=${o} must match.`);const k=o?[x,m,d]:[x,d,m],v=aw({inputs:{x:r},backend:n,attrs:{shape:i?[b,h,f]:[b,f,h]}}),N=aw({inputs:{x:a},backend:n,attrs:{shape:k}}),I=i?v.shape[1]:v.shape[2],C=i?v.shape[2]:v.shape[1],S=o?N.shape[1]:N.shape[2],T=Math.max(b,x),E=n.data.get(v.dataId).values,$=n.data.get(N.dataId).values,A=O(v.shape),R=O(N.shape),[F,D,_]=i?[A[0],1,A[1]]:[A[0],A[1],1],[M,L,z]=o?[1,R[1],R[0]]:[R[1],1,R[0]],B=C*S,P=Kt([T,C,S],v.dtype),W=P.values,V=n.blockSize;for(let e=0;e<T;e++)for(let t=0;t<C;t+=V)for(let n=0;n<S;n+=V)for(let s=0;s<I;s+=V){const r=Math.min(t+V,C),a=Math.min(n+V,S),i=Math.min(s+V,I);for(let o=t;o<r;o++)for(let t=n;t<a;t++){let n=0;for(let r=s;r<i;r++){const s=Math.min(e,b-1)*F,a=Math.min(e,x-1)*z;n+=E[s+o*D+r*_]*$[r*M+t*L+a]}W[e*B+(o*S+t)]+=n}}return n.disposeIntermediateTensorInfo(v),n.disposeIntermediateTensorInfo(N),n.makeTensorInfo(w,P.dtype,P.values)}const lw={kernelName:"BatchMatMul",backendName:"cpu",kernelFunc:ow};const uw={kernelName:"_FusedMatMul",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a,bias:i,preluActivationWeights:o}=t,{transposeA:l,transposeB:u,activation:c,leakyreluAlpha:h}=s;let p,d,f;const m=[];p=ow({inputs:{a:r,b:a},attrs:{transposeA:l,transposeB:u},backend:n}),i&&(d=Pb({inputs:{a:p,b:i},backend:n}),m.push(p),p=d),c&&(f=rw(n,p,c,o,h),m.push(p),p=f);for(const e of m)n.disposeIntermediateTensorInfo(e);return p}},cw={kernelName:"Acos",backendName:"cpu",kernelFunc:Hb("Acos",e=>Math.acos(e))},hw={kernelName:"Acosh",backendName:"cpu",kernelFunc:Hb("Acosh",e=>Math.acosh(e))};const pw={kernelName:"AddN",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,s=t;kb(t,"addN");const r=s.map(e=>n.data.get(e.dataId).values),a=Kt(s[0].shape,s[0].dtype),i=a.values;for(let e=0;e<s.length;e++){const t=r[e];for(let e=0;e<i.length;e++)i[e]+=t[e]}return n.makeTensorInfo(a.shape,a.dtype,a.values)}};const dw={kernelName:"All",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;kb(r,"all");const o=x(a,r.shape);let l=o;const u=fa(l,r.shape.length);let c=r;null!=u&&(c=Sx({inputs:{x:r},backend:n,attrs:{perm:u}}),l=ga(l.length,r.shape.length)),da("all",l,c.shape.length);const[h,d]=ha(c.shape,l),f=p(d),m=z(p(h),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];n=n&&s}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(h,c.dtype,m);if(i){const e=aw({inputs:{x:y},backend:n,attrs:{shape:pa(h,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const fw={kernelName:"Any",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;kb(r,"any");const o=x(a,r.shape);let l=o;const u=fa(l,r.shape.length);let c=r;null!=u&&(c=Sx({inputs:{x:r},backend:n,attrs:{perm:u}}),l=ga(l.length,r.shape.length)),da("any",l,c.shape.length);const[h,d]=ha(c.shape,l),f=p(d),m=z(p(h),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];n=n||s}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(h,c.dtype,m);if(i){const e=aw({inputs:{x:y},backend:n,attrs:{shape:pa(h,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const mw={kernelName:"ArgMax",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;kb(r,"argMax");let i=x(a,r.shape);const o=fa(i,r.shape.length);let l=r;const u=[];null!=o&&(l=Sx({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=ga(i.length,l.shape.length)),i=[i[0]],da("argMax",i,l.shape.length);const[c,h]=ha(l.shape,i),d=z(p(c),"int32"),f=p(h),m=n.data.get(l.dataId).values;for(let e=0;e<d.length;++e){const t=e*f;let n=m[t],s=0;for(let e=0;e<f;++e){const r=m[t+e];r>n&&(n=r,s=e)}d[e]=s}return u.forEach(e=>n.disposeIntermediateTensorInfo(e)),n.makeTensorInfo(c,"int32",d)}};const gw={kernelName:"ArgMin",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;kb(r,"argMin");let i=x(a,r.shape);const o=fa(i,r.shape.length);let l=r;const u=[];null!=o&&(l=Sx({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=ga(i.length,l.shape.length)),i=[i[0]],da("argMin",i,l.shape.length);const[c,h]=ha(l.shape,i),d=z(p(c),"int32"),f=p(h),m=n.data.get(l.dataId).values;for(let e=0;e<d.length;++e){const t=e*f;let n=m[t],s=0;for(let e=0;e<f;++e){const r=m[t+e];r<n&&(n=r,s=e)}d[e]=s}return u.forEach(e=>n.disposeIntermediateTensorInfo(e)),n.makeTensorInfo(c,"int32",d)}},yw={kernelName:"Asin",backendName:"cpu",kernelFunc:Hb("Asin",e=>Math.asin(e))},bw={kernelName:"Asinh",backendName:"cpu",kernelFunc:Hb("Asinh",e=>Math.asinh(e))},xw={kernelName:"Atan",backendName:"cpu",kernelFunc:Hb("Atan",e=>Math.atan(e))},ww={kernelName:"Atan2",backendName:"cpu",kernelFunc:Mb("Atan2",Sb((e,t)=>Math.atan2(e,t)))},kw={kernelName:"Atanh",backendName:"cpu",kernelFunc:Hb("Atanh",e=>Math.atanh(e))};function vw(e,t,n,s,r,a){const i=r.strideHeight,o=r.strideWidth,l=r.dilationHeight,u=r.dilationWidth,c=r.effectiveFilterHeight,h=r.effectiveFilterWidth,p=r.padInfo.top,d=r.padInfo.left,f="max"===a?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,m=Kt(r.outShape,n),g=m.values,y=r.outShape[1]*r.outShape[2]*r.outShape[3],b=r.outShape[2]*r.outShape[3],x=r.outShape[3];for(let t=0;t<r.batchSize;++t){const n=t*y,m=t*s[0];for(let t=0;t<r.inChannels;++t)for(let y=0;y<r.outHeight;++y){const w=y*i-p,k=Math.max(0,w),v=Math.min(r.inHeight,c+w),N=n+y*b;for(let n=0;n<r.outWidth;++n){const i=n*o-d,c=Math.max(0,i),p=Math.min(r.inWidth,h+i);let y=f,b=0,w=0;for(let n=k;n<v;n+=l){const r=m+n*s[1];for(let n=c;n<p;n+=u){const i=e[r+n*s[2]+t];"max"===a&&i>y?y=i:"avg"===a&&(b+=i,w++)}if(isNaN(y))break}g[N+n*x+t]="avg"===a?b/w:y}}}return m}function Nw(e,t,n,s,r=!1,a=!1){const i=Kt(s.outShape,"int32"),o=s.strideHeight,l=s.strideWidth,u=s.dilationHeight,c=s.dilationWidth,h=s.effectiveFilterHeight,p=s.effectiveFilterWidth,d=s.padInfo.top,f=s.padInfo.left,m=Kt(t,n,e);for(let e=0;e<s.batchSize;++e)for(let t=0;t<s.inChannels;++t)for(let n=0;n<s.outHeight;++n){const g=n*o-d;let y=g;for(;y<0;)y+=u;const b=Math.min(s.inHeight,h+g);for(let o=0;o<s.outWidth;++o){const h=o*l-f;let d=h;for(;d<0;)d+=c;const x=Math.min(s.inWidth,p+h);let w=Number.NEGATIVE_INFINITY,k=-1;for(let n=y;n<b;n+=u){const i=n-g;for(let o=d;o<x;o+=c){const l=o-h,u=m.get(e,n,o,t);u>w&&(w=u,k=r?a?((e*s.inHeight+n)*s.inWidth+o)*s.inChannels+t:(n*s.inWidth+o)*s.inChannels+t:i*p+l)}}i.set(k,e,n,o,t)}}return i}function Iw(e,t,n,s,r,a){const i=r.strideDepth,o=r.strideHeight,l=r.strideWidth,u=r.dilationDepth,c=r.dilationHeight,h=r.dilationWidth,p=r.effectiveFilterDepth,d=r.effectiveFilterHeight,f=r.effectiveFilterWidth,m=r.padInfo.front,g=r.padInfo.top,y=r.padInfo.left,b="max"===a?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,x=Kt(r.outShape,n),w=x.values,k=r.outShape[1]*r.outShape[2]*r.outShape[3]*r.outShape[4],v=r.outShape[2]*r.outShape[3]*r.outShape[4],N=r.outShape[3]*r.outShape[4],I=r.outShape[4];for(let t=0;t<r.batchSize;++t){const n=t*k,x=t*s[0];for(let t=0;t<r.inChannels;++t)for(let k=0;k<r.outDepth;++k){const C=k*i-m;let S=C;for(;S<0;)S+=u;const T=Math.min(r.inDepth,p+C),E=n+k*v;for(let n=0;n<r.outHeight;++n){const i=n*o-g;let p=i;for(;p<0;)p+=c;const m=Math.min(r.inHeight,d+i),k=E+n*N;for(let n=0;n<r.outWidth;++n){const i=n*l-y;let o=i;for(;o<0;)o+=h;const d=Math.min(r.inWidth,f+i),g=k+n*I;let v=b,N=0,C=0;for(let n=S;n<T;n+=u){const r=x+n*s[1];for(let n=p;n<m;n+=c){const i=r+n*s[2];for(let n=o;n<d;n+=h){const r=e[i+n*s[3]+t];if("max"===a&&r>v?v=r:"avg"===a&&(N+=r,C++),isNaN(v))break}if(isNaN(v))break}if(isNaN(v))break}w[g+t]="avg"===a?N/C:v}}}}return x}const Cw={kernelName:"AvgPool",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;kb(r,"avgPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:u}=s;l(zs(i,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`);const c=Es(r.shape,a,i,1,o,u);let h;if(1===c.filterWidth&&1===c.filterHeight&&d(c.inShape,c.outShape))h=Ab({inputs:{x:r},backend:n});else{const e=n.data.get(r.dataId).values,t=O(r.shape),s=vw(e,r.shape,r.dtype,t,c,"avg");h=n.makeTensorInfo(c.outShape,r.dtype,s.values)}return h}};const Sw={kernelName:"AvgPool3D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s;kb(r,"avgPool3d");const c=$s(r.shape,a,i,1,o,l,u),h=Iw(n.data.get(r.dataId).values,r.shape,r.dtype,O(r.shape),c,"avg");return n.makeTensorInfo(h.shape,"float32",h.values)}};const Tw={kernelName:"AvgPool3DGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,{filterSize:i,strides:o,pad:l,dimRoundingMode:u}=s;kb([r,a],"avgPool3DGrad");const c=$s(a.shape,i,o,1,l,u),h=c.strideDepth,p=c.strideHeight,d=c.strideWidth,f=c.filterDepth,m=c.filterHeight,g=c.filterWidth,y=c.dilationDepth,b=c.dilationHeight,x=c.dilationWidth,w=c.effectiveFilterDepth,k=c.effectiveFilterHeight,v=c.effectiveFilterWidth,N=w-1-c.padInfo.front,I=v-1-c.padInfo.left,C=k-1-c.padInfo.top,S=Kt(a.shape,"float32"),T=1/(f*m*g),E=n.bufferSync(r);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inDepth;++n)for(let s=0;s<c.inHeight;++s)for(let r=0;r<c.inWidth;++r){const a=n-N,i=s-C,o=r-I;let l=0;for(let n=0;n<w;n+=y){const s=(a+n)/h;if(!(s<0||s>=c.outDepth||Math.floor(s)!==s))for(let n=0;n<k;n+=b){const r=(i+n)/p;if(!(r<0||r>=c.outHeight||Math.floor(r)!==r))for(let n=0;n<v;n+=x){const a=(o+n)/d;a<0||a>=c.outWidth||Math.floor(a)!==a||(l+=E.get(e,s,r,a,t))}}}S.set(l*T,e,n,s,r,t)}return n.makeTensorInfo(S.shape,S.dtype,S.values)}};const Ew={kernelName:"AvgPoolGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a;kb([r,a],"avgPoolGrad");const{filterSize:o,strides:l,pad:u}=s,c=Es(i.shape,o,l,1,u),h=c.strideHeight,p=c.strideWidth,d=c.filterHeight,f=c.filterWidth,m=c.dilationHeight,g=c.dilationWidth,y=c.effectiveFilterHeight,b=c.effectiveFilterWidth,x=b-1-c.padInfo.left,w=y-1-c.padInfo.top,k=Kt(i.shape,"float32"),v=1/(d*f),N=n.data.get(r.dataId).values,I=Kt(r.shape,"float32",N);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inHeight;++n)for(let s=0;s<c.inWidth;++s){const r=n-w,a=s-x;let i=0;for(let n=0;n<y;n+=m){const s=(r+n)/h;if(!(s<0||s>=c.outHeight||Math.floor(s)!==s))for(let n=0;n<b;n+=g){const r=(a+n)/p;r<0||r>=c.outWidth||Math.floor(r)!==r||(i+=I.get(e,s,r,t))}}k.set(i*v,e,n,s,t)}return n.makeTensorInfo(k.shape,k.dtype,k.values)}};const $w={kernelName:"FusedBatchNorm",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,scale:a,offset:i,mean:o,variance:u}=t;l(o.shape.length===u.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),l(null==i||o.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),l(null==a||o.shape.length===a.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks."),kb([r,o,u,a,i],"batchNorm");let{varianceEpsilon:c}=s;null==c&&(c=.001);const h=n.data.get(r.dataId).values,p=n.data.get(o.dataId).values,d=n.data.get(u.dataId).values,f=a?n.data.get(a.dataId).values:new Float32Array([1]),m=i?n.data.get(i.dataId).values:new Float32Array([0]),g=new Float32Array(h.length),y=m.length,b=f.length,x=d.length,w=p.length;let k=0,v=0,N=0,I=0;for(let e=0;e<h.length;++e)g[e]=m[k++]+(h[e]-p[v++])*f[N++]/Math.sqrt(d[I++]+c),k>=y&&(k=0),v>=w&&(v=0),N>=b&&(N=0),I>=x&&(I=0);return n.makeTensorInfo(r.shape,r.dtype,g)}};const Aw={kernelName:"BatchToSpaceND",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,crops:i}=s;kb([r],"batchToSpaceND");const o=a.reduce((e,t)=>e*t),l=Fl(r.shape,a,o),u=Dl(l.length,a.length),c=_l(r.shape,a,o),h=Ol(i,a.length),p=Ml(c,i,a.length),d=aw({inputs:{x:r},backend:n,attrs:{shape:l}}),f=Sx({inputs:{x:d},backend:n,attrs:{perm:u}}),m=aw({inputs:{x:f},backend:n,attrs:{shape:c}}),g=_x({inputs:{x:m},backend:n,attrs:{begin:h,size:p}});return n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}};const Rw={kernelName:"Bincount",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i}=s,o=Vb(n.data.get(r.dataId).values,n.data.get(a.dataId).values,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,o)}},Fw={kernelName:"ClipByValue",backendName:"cpu",kernelFunc:Hb("ClipByValue",(e,t)=>{const n=t;return e>n.clipValueMax?n.clipValueMax:e<n.clipValueMin?n.clipValueMin:e})},Dw={kernelName:"ComplexAbs",backendName:"cpu",kernelFunc:e=>{const{x:t}=e.inputs,n=e.backend,s=new Float32Array(p(t.shape)),r=n.data.get(t.dataId),a=r.complexTensorInfos.real,i=r.complexTensorInfos.imag,o=n.data.get(a.dataId).values,l=n.data.get(i.dataId).values;for(let e=0;e<o.length;e++){const t=o[e],n=l[e];s[e]=Math.hypot(t,n)}return n.makeOutput(s,t.shape,"float32")}};function _w(e){const{inputs:t,backend:n}=e,{input:s}=t,r=n.data.get(s.dataId).complexTensorInfos.imag,a=n.data.get(r.dataId).values;return n.makeTensorInfo(r.shape,r.dtype,a)}const Ow={kernelName:"Imag",backendName:"cpu",kernelFunc:_w};function Mw(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s,a=x(r,t[0].shape)[0];let i=$l(t.map(e=>e.shape),a);if(0===p(i))return n.makeTensorInfo(i,t[0].dtype,[]);const o=t.filter(e=>p(e.shape)>0);if(1===o.length)return Ab({inputs:{x:o[0]},backend:n});if(El(o.map(e=>e.shape),a),"complex64"===o[0].dtype){const e=o.map(e=>Fb({inputs:{input:e},backend:n})),t=o.map(e=>_w({inputs:{input:e},backend:n})),s=Mw({inputs:e,backend:n,attrs:{axis:a}}),r=Mw({inputs:t,backend:n,attrs:{axis:a}}),i=Tb({inputs:{real:s,imag:r},backend:n});return e.forEach(e=>n.disposeIntermediateTensorInfo(e)),t.forEach(e=>n.disposeIntermediateTensorInfo(e)),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),i}const l=o.map(e=>{const t=p(e.shape.slice(a));return aw({inputs:{x:e},backend:n,attrs:{shape:[-1,t]}})}),u=l.map(e=>({vals:n.data.get(e.dataId).values,shape:e.shape}));i=$l(l.map(e=>e.shape),1);const c=1===l[0].shape[0],h=Xb(u,i,t[0].dtype,c),d=$l(o.map(e=>e.shape),a),f=n.makeTensorInfo(d,t[0].dtype,h);return l.forEach(e=>n.disposeIntermediateTensorInfo(e)),f}const Lw={kernelName:"Concat",backendName:"cpu",kernelFunc:Mw};function zw(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dataFormat:l,dilations:u,dimRoundingMode:c}=s;kb([r,a],"conv2d");const h=Bs(l),p=As(r.shape,a.shape,i,u,o,c,!1,h),d=p.filterHeight,f=p.filterWidth,m=p.dilationHeight,g=p.dilationWidth,y=p.padInfo.left,b=p.padInfo.top,x="channelsLast"===p.dataFormat,w=new Ee(p.outShape,r.dtype),k=O(r.shape),v=O(a.shape),N=k[0],I=x?k[1]:k[2],C=x?k[2]:1,S=x?1:k[1],T=w.strides[0],E=x?w.strides[1]:w.strides[2],$=x?w.strides[2]:1,A=x?1:w.strides[1],R=n.data.get(r.dataId).values,F=n.data.get(a.dataId).values,D=w.values;for(let e=0;e<p.batchSize;++e){const t=e*N,n=e*T;for(let e=0;e<p.outHeight;++e){const s=n+e*E,r=e*p.strideHeight-b;for(let e=0;e<d;++e){const n=r+e*m;if(n<0||n>=p.inHeight)continue;const a=e*v[0],i=t+n*I;for(let e=0;e<p.outWidth;++e){const t=s+e*$,n=e*p.strideWidth-y;for(let e=0;e<f;++e){const s=n+e*g;if(s<0||s>=p.inWidth)continue;const r=i+s*C;let o=a+e*v[1];for(let e=0;e<p.inChannels;++e){const n=R[r+e*S];for(let e=0;e<p.outChannels;++e)D[t+e*A]+=n*F[o+e];o+=p.outChannels}}}}}}return n.makeTensorInfo(w.shape,w.dtype,D)}const Bw={kernelName:"Conv2D",backendName:"cpu",kernelFunc:zw};const Pw={kernelName:"Conv2DBackpropFilter",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,dataFormat:l,dimRoundingMode:u,filterShape:c}=s;kb([r,a],"conv2dBackpropFilter");const h=Bs(l),p=As(r.shape,c,i,1,o,u,!1,h),{strideHeight:d,strideWidth:f,filterHeight:m,filterWidth:g}=p,y="channelsLast"===p.dataFormat,b=new Ee(p.filterShape,"float32"),x=p.padInfo.left,w=p.padInfo.top,k=n.data.get(r.dataId).values,v=n.data.get(a.dataId).values,N=new Ee(r.shape,r.dtype,k),I=new Ee(a.shape,a.dtype,v);for(let e=0;e<m;++e){const t=Math.max(0,Math.ceil((w-e)/d)),n=Math.min(p.outHeight,(p.inHeight+w-e)/d);for(let s=0;s<g;++s){const r=Math.max(0,Math.ceil((x-s)/f)),a=Math.min(p.outWidth,(p.inWidth+x-s)/f);for(let i=0;i<p.inChannels;++i)for(let o=0;o<p.outChannels;++o){let l=0;for(let u=0;u<p.batchSize;++u)for(let c=t;c<n;++c){const t=e+c*d-w;for(let e=r;e<a;++e){const n=s+e*f-x;l+=y?N.get(u,t,n,i)*I.get(u,c,e,o):N.get(u,i,t,n)*I.get(u,o,c,e)}}b.set(l,e,s,i,o)}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const Ww={kernelName:"Conv2DBackpropInput",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{inputShape:i,strides:o,pad:l,dataFormat:u,dimRoundingMode:c}=s;kb([r,a],"conv2dBackpropInput");const h=O(a.shape),p=O(r.shape);let d=Bs(u);const f=As(i,a.shape,o,1,l,c,!1,d),m=new Ee(f.inShape,"float32"),g=m.values,y=n.data.get(r.dataId).values,b=n.data.get(a.dataId).values,[x,w,k]=h,{batchSize:v,filterHeight:N,filterWidth:I,inChannels:C,inHeight:S,inWidth:T,outChannels:E,outHeight:$,outWidth:A,strideHeight:R,strideWidth:F}=f;d=f.dataFormat;const D=N-1-f.padInfo.top,_=I-1-f.padInfo.left,M="channelsLast"===d,L=m.strides[0],z=M?m.strides[1]:m.strides[2],B=M?m.strides[2]:1,P=M?1:m.strides[1],W=p[0],V=M?p[1]:p[2],U=M?p[2]:1,G=M?1:p[1];for(let e=0;e<v;++e)for(let t=0;t<C;++t)for(let n=0;n<S;++n){const s=n-D,r=Math.max(0,Math.ceil(s/R)),a=Math.min($,(N+s)/R);for(let i=0;i<T;++i){const o=i-_,l=Math.max(0,Math.ceil(o/F)),u=Math.min(A,(I+o)/F);let c=0;for(let n=r;n<a;++n){const r=n*R-s;for(let s=l;s<u;++s){const a=W*e+V*n+U*s,i=x*(N-1-r)+w*(I-1-(s*F-o))+k*t;for(let e=0;e<E;++e){c+=y[a+G*e]*b[i+e]}}}g[L*e+z*n+B*i+P*t]=c}}return n.makeTensorInfo(m.shape,m.dtype,m.values)}};const Vw={kernelName:"Conv3D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s;kb([r,a],"conv3d");const u=Rs(r.shape,a.shape,i,l,o),{filterDepth:c,filterHeight:h,filterWidth:p,dilationDepth:d,dilationHeight:f,dilationWidth:m,padInfo:g}=u,y=g.front,b=g.left,x=g.top,w=new Ee(u.outShape,r.dtype),k=n.data.get(r.dataId).values,v=n.data.get(a.dataId).values,N=w.values,I=O(r.shape),C=O(a.shape);for(let e=0;e<u.batchSize;++e){const t=e*I[0],n=e*w.strides[0];for(let e=0;e<u.outDepth;++e){const s=n+e*w.strides[1],r=e*u.strideDepth-y;for(let e=0;e<c;++e){const n=r+e*d;if(n<0||n>=u.inDepth)continue;const a=e*C[0],i=t+n*I[1];for(let e=0;e<u.outHeight;++e){const t=s+e*w.strides[2],n=e*u.strideHeight-x;for(let e=0;e<h;++e){const s=n+e*f;if(s<0||s>=u.inHeight)continue;const r=a+e*C[1],o=i+s*I[2];for(let e=0;e<u.outWidth;++e){const n=t+e*u.outChannels,s=e*u.strideWidth-b;for(let e=0;e<p;++e){const t=s+e*m;if(t<0||t>=u.inWidth)continue;const a=r+e*C[2],i=o+t*u.inChannels;let l=a;for(let e=0;e<u.inChannels;++e){const t=k[i+e];for(let e=0;e<u.outChannels;++e)N[n+e]+=t*v[l+e];l+=u.outChannels}}}}}}}}return n.makeTensorInfo(w.shape,w.dtype,w.values)}};const Uw={kernelName:"Conv3DBackpropFilterV2",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,filterShape:l}=s;kb([r,a],"conv3dBackpropFilterV2");const u=O(r.shape),c=O(a.shape),h=Rs(r.shape,l,i,1,o),p=h.strideDepth,d=h.strideHeight,f=h.strideWidth,m=h.filterDepth,g=h.filterHeight,y=h.filterWidth,b=new Ee(h.filterShape,"float32"),x=b.values,[w,k,v,N]=b.strides,I=n.data.get(a.dataId).values,[C,S,T,E]=c,$=n.data.get(r.dataId).values,[A,R,F,D]=u,_=h.padInfo.front,M=h.padInfo.left,L=h.padInfo.top;for(let e=0;e<m;++e){const t=Math.max(0,Math.ceil((_-e)/p)),n=Math.min(h.outDepth,(h.inDepth+_-e)/p),s=e*w;for(let r=0;r<g;++r){const a=Math.max(0,Math.ceil((L-r)/d)),i=Math.min(h.outHeight,(h.inHeight+L-r)/d),o=r*k+s;for(let s=0;s<y;++s){const l=Math.max(0,Math.ceil((M-s)/f)),u=Math.min(h.outWidth,(h.inWidth+M-s)/f),c=s*v+o;for(let o=0;o<h.inChannels;++o){const m=o*N+c;for(let c=0;c<h.outChannels;++c){let g=0;for(let m=0;m<h.batchSize;++m){const h=m*A,y=m*C;for(let m=t;m<n;++m){const t=(e+m*p-_)*R+h,n=m*S+y;for(let e=a;e<i;++e){const a=(r+e*d-L)*F+t,i=e*T+n;for(let e=l;e<u;++e){const t=e*E+i;g+=$[(s+e*f-M)*D+a+o]*I[t+c]}}}}x[m+c]=g}}}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const Gw={kernelName:"Conv3DBackpropInputV2",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{pad:i,strides:o,inputShape:l}=s;kb([r],"conv3dBackpropInputV2");const u=O(r.shape),c=O(a.shape),h=Rs(l,a.shape,o,1,i),p=new Ee(h.inShape,"float32"),d=p.values,[f,m,g,y]=p.strides,b=n.data.get(r.dataId).values,[x,w,k,v]=u,N=n.data.get(a.dataId).values,[I,C,S,T]=c,{batchSize:E,filterDepth:$,filterHeight:A,filterWidth:R,inChannels:F,inDepth:D,inHeight:_,inWidth:M,outChannels:L,outDepth:z,outHeight:B,outWidth:P,strideDepth:W,strideHeight:V,strideWidth:U}=h,G=$-1-h.padInfo.front,H=A-1-h.padInfo.top,j=R-1-h.padInfo.left;for(let e=0;e<E;++e)for(let t=0;t<F;++t)for(let n=0;n<D;++n){const s=n-G,r=Math.max(0,Math.ceil(s/W)),a=Math.min(z,($+s)/W);for(let i=0;i<_;++i){const o=i-H,l=Math.max(0,Math.ceil(o/V)),u=Math.min(B,(A+o)/V);for(let c=0;c<M;++c){const h=c-j,p=Math.max(0,Math.ceil(h/U)),E=Math.min(P,(R+h)/U);let F=0;for(let n=r;n<a;++n){const r=n*W-s;for(let s=l;s<u;++s){const a=s*V-o;for(let i=p;i<E;++i){const o=x*e+w*n+k*s+v*i,l=I*($-1-r)+C*(A-1-a)+S*(R-1-(i*U-h))+T*t;for(let e=0;e<L;++e){F+=b[o+e]*N[l+e]}}}}d[f*e+m*n+g*i+y*c+t]=F}}}return n.makeTensorInfo(p.shape,p.dtype,p.values)}},Hw=Hb(Y,e=>Math.cos(e)),jw={kernelName:Y,backendName:"cpu",kernelFunc:Hw},qw={kernelName:"Cosh",backendName:"cpu",kernelFunc:Hb("Cosh",e=>Math.cosh(e))};const Kw={kernelName:"CropAndResize",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{image:r,boxes:a,boxInd:i}=t,{cropSize:o,method:l,extrapolationValue:u}=s,[c,h,p,d]=r.shape,f=a.shape[0],[m,g]=o,y=Kt([f,m,g,d],"float32"),b=n.data.get(a.dataId).values,x=n.data.get(i.dataId).values,w=n.data.get(r.dataId).values,k=O(r.shape),v=O(y.shape);for(let e=0;e<f;e++){const t=4*e,n=b[t],s=b[t+1],r=b[t+2],a=b[t+3],i=x[e];if(i>=c)continue;const o=m>1?(r-n)*(h-1)/(m-1):0,f=g>1?(a-s)*(p-1)/(g-1):0;for(let t=0;t<m;t++){const c=m>1?n*(h-1)+t*o:.5*(n+r)*(h-1);if(c<0||c>h-1)for(let n=0;n<g;n++)for(let s=0;s<d;s++){const r=s+n*v[2]+t*v[1]+e*v[0];y.values[r]=u}else if("bilinear"===l){const n=Math.floor(c),r=Math.ceil(c),o=c-n;for(let l=0;l<g;l++){const c=g>1?s*(p-1)+l*f:.5*(s+a)*(p-1);if(c<0||c>p-1){for(let n=0;n<d;n++){const s=n+l*v[2]+t*v[1]+e*v[0];y.values[s]=u}continue}const h=Math.floor(c),m=Math.ceil(c),b=c-h;for(let s=0;s<d;s++){let a=s+h*k[2]+n*k[1]+i*k[0];const u=w[a];a=s+m*k[2]+n*k[1]+i*k[0];const c=w[a];a=s+h*k[2]+r*k[1]+i*k[0];const p=w[a];a=s+m*k[2]+r*k[1]+i*k[0];const d=u+(c-u)*b,f=p+(w[a]-p)*b;a=s+l*v[2]+t*v[1]+e*v[0],y.values[a]=d+(f-d)*o}}}else for(let n=0;n<g;++n){const r=g>1?s*(p-1)+n*f:.5*(s+a)*(p-1);if(r<0||r>p-1){for(let s=0;s<d;s++){const r=s+n*v[2]+t*v[1]+e*v[0];y.values[r]=u}continue}const o=Math.round(r),l=Math.round(c);for(let s=0;s<d;s++){const r=s+o*k[2]+l*k[1]+i*k[0],a=s+n*v[2]+t*v[1]+e*v[0];y.values[a]=w[r]}}}}return n.makeTensorInfo(y.shape,y.dtype,y.values)}};const Xw={kernelName:"Cumsum",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s;kb(r,"cumsum");const l=fa([a],r.shape.length);let u=r;null!=l&&(u=Sx({inputs:{x:r},backend:n,attrs:{perm:l}}));const c=ga(1,r.shape.length)[0];if(c!==u.shape.length-1)throw new Error(`backend.cumsum in CPU expects an inner-most axis=${u.shape.length-1} but got axis=${c}`);const h=We(u.dtype,"int32"),d=z(p(u.shape),h),f=n.data.get(u.dataId).values,m=u.shape[u.shape.length-1],g=o?(e,t)=>e+m-t-1:(e,t)=>e+t;for(let e=0;e<f.length;e+=m)for(let t=0;t<m;t++){const n=g(e,t);if(0===t)d[n]=i?0:f[n];else{const s=g(e,t-1);d[n]=i?f[s]+d[s]:f[n]+d[s]}}const y=n.makeTensorInfo(u.shape,h,d);if(null!=l){const e=Sx({inputs:{x:y},backend:n,attrs:{perm:ma(l)}});return n.disposeIntermediateTensorInfo(y),n.disposeIntermediateTensorInfo(u),e}return y}};const Yw={kernelName:"DenseBincount",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i,binaryOutput:o}=s;if(1===r.shape.length){const e=Vb(n.data.get(r.dataId).values,n.data.get(a.dataId).values,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,e)}if(2===r.shape.length){const e=Ub(n.bufferSync(r),n.bufferSync(a),i,o);return n.makeTensorInfo(e.shape,a.dtype,e.values)}throw new Error("Error in denseBincount: input must be at most rank 2, but got rank"+r.shape.length+".")}};const Jw={kernelName:"DepthToSpace",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockSize:a,dataFormat:i}=s;l("NHWC"===i,()=>"Only NHWC dataFormat supported on CPU for depthToSpace. Got "+i),l(a>1,()=>"blockSize should be > 1 for depthToSpace, but was: "+a);const o=r.shape[0],u=r.shape[1],c=r.shape[2],h=r.shape[3],p=u*a,d=c*a,f=h/(a*a),m=n.data.get(r.dataId).values,g=new Float32Array(o*p*d*f);let y=0;for(let e=0;e<o;++e)for(let t=0;t<p;++t){const n=Math.floor(t/a),s=t%a;for(let t=0;t<d;++t){const r=Math.floor(t/a),i=(s*a+t%a)*f;for(let t=0;t<f;++t){const s=t+i+h*(r+c*(n+u*e));g[y++]=m[s]}}}return n.makeTensorInfo([o,p,d,f],r.dtype,g)}};function Zw(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:u,dimRoundingMode:c}=s;kb([r,a],"depthwiseConv2DNative");const h=O(r.shape),p=O(a.shape);let d=u;null==d&&(d=[1,1]),l(zs(i,d),()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${i} and dilations '${d}'`);const f=As(r.shape,a.shape,i,d,o,c,!0),{filterHeight:m,filterWidth:g,dilationHeight:y,dilationWidth:b,padInfo:x}=f,w=x.left,k=x.top,v=f.outChannels/f.inChannels,N=new Ee(f.outShape,r.dtype),I=n.data.get(r.dataId).values,C=n.data.get(a.dataId).values,S=N.values;for(let e=0;e<f.batchSize;++e){const t=e*h[0],n=e*N.strides[0];for(let e=0;e<f.outHeight;++e){const s=n+e*N.strides[1],r=e*f.strideHeight-w;for(let e=0;e<m;++e){const n=r+e*y;if(n<0||n>=f.inHeight)continue;const a=e*p[0],i=t+n*h[1];for(let e=0;e<f.outWidth;++e){const t=s+e*N.strides[2],n=e*f.strideWidth-k;for(let e=0;e<g;++e){const s=n+e*b;if(s<0||s>=f.inWidth)continue;const r=a+e*p[1],o=i+s*f.inChannels;let l=t,u=r;for(let e=0;e<f.inChannels;++e){const t=I[o+e];for(let e=0;e<v;++e)S[l+e]+=t*C[u+e];l+=v,u+=v}}}}}}return n.makeTensorInfo(N.shape,N.dtype,N.values)}const Qw={kernelName:"DepthwiseConv2dNative",backendName:"cpu",kernelFunc:Zw};const ek={kernelName:"DepthwiseConv2dNativeBackpropFilter",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,filterShape:c}=s;kb([r,a],"depthwiseConv2dNativeBackpropFilter");const h=As(r.shape,c,i,o,l,u,!0),{strideHeight:p,strideWidth:d,filterHeight:f,filterWidth:m}=h,g=new Ee(h.filterShape,"float32"),y=h.padInfo.left,b=h.padInfo.top,x=h.outChannels/h.inChannels,w=n.data.get(r.dataId).values,k=new Ee(r.shape,r.dtype,w),v=n.data.get(a.dataId).values,N=new Ee(a.shape,a.dtype,v);for(let e=0;e<f;++e){const t=Math.max(0,Math.ceil((b-e)/p)),n=Math.min(h.outHeight,(h.inHeight+b-e)/p);for(let s=0;s<m;++s){const r=Math.max(0,Math.ceil((y-s)/d)),a=Math.min(h.outWidth,(h.inWidth+y-s)/d);for(let i=0;i<h.outChannels;++i){const o=Math.trunc(i/x),l=i%x;let u=0;for(let l=0;l<h.batchSize;++l)for(let c=t;c<n;++c){const t=e+c*p-b;for(let e=r;e<a;++e){const n=s+e*d-y;u+=k.get(l,t,n,o)*N.get(l,c,e,i)}}g.set(u,e,s,o,l)}}}return n.makeTensorInfo(g.shape,g.dtype,g.values)}};const tk={kernelName:"DepthwiseConv2dNativeBackpropInput",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,inputShape:c}=s;kb([r,a],"depthwiseConv2DNativeBackpropInput");const h=O(r.shape),p=O(a.shape),d=As(c,a.shape,i,o,l,u,!0),f=new Ee(d.inShape,"float32"),m=f.values,[g,y,b]=f.strides,x=n.data.get(r.dataId).values,[w,k,v]=h,N=n.data.get(a.dataId).values,[I,C,S]=p,{batchSize:T,filterHeight:E,filterWidth:$,inChannels:A,inHeight:R,inWidth:F,outChannels:D,outHeight:_,outWidth:M,strideHeight:L,strideWidth:z}=d,B=E-1-d.padInfo.top,P=$-1-d.padInfo.left,W=D/A;for(let e=0;e<T;++e)for(let t=0;t<A;++t)for(let n=0;n<R;++n){const s=n-B,r=Math.max(0,Math.ceil(s/L)),a=Math.min(_,(E+s)/L);for(let i=0;i<F;++i){const o=i-P,l=Math.max(0,Math.ceil(o/z)),u=Math.min(M,($+o)/z);let c=0;for(let n=r;n<a;++n){const r=n*L-s;for(let s=l;s<u;++s){const a=w*e+k*n+v*s,i=I*(E-1-r)+C*($-1-(s*z-o))+S*t;for(let e=0;e<W;++e){c+=x[a+(t*W+e)]*N[i+e]}}}m[g*e+y*n+b*i+t]=c}}return n.makeTensorInfo(f.shape,f.dtype,f.values)}};const nk={kernelName:"Diag",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=p(s.shape),a=n.data.get(s.dataId).values,i=Kt([r,r],s.dtype),o=i.values;for(let e=0;e<a.length;e++)o[e*r+e]=a[e];const l=[...s.shape,...s.shape];return n.makeTensorInfo(l,i.dtype,i.values)}},sk={kernelName:"Dilation2D",backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r}=e,{strides:a,pad:i,dilations:o}=n,l=t,u=l.data.get(s.dataId).values,c=s.shape.length,h=l.data.get(r.dataId).values,d=r.shape.length,{batchSize:f,inHeight:m,inWidth:g,inChannels:y,outHeight:b,outWidth:x,padInfo:w,strideHeight:k,strideWidth:N,filterHeight:I,filterWidth:C,dilationHeight:S,dilationWidth:T,outShape:E}=Ts(s.shape,r.shape,a,i,"NHWC",o),$=p(E),A=E.length,R=v(s.dtype,$);for(let e=0;e<f;++e)for(let t=0;t<b;++t){const n=t*k-w.top;for(let a=0;a<x;++a){const i=a*N-w.left;for(let o=0;o<y;++o){let l=Number.MIN_SAFE_INTEGER;for(let t=0;t<I;++t){const a=n+t*S;if(a>=0&&a<m)for(let n=0;n<C;++n){const p=i+n*T;if(p>=0&&p<g){const i=W([e,a,p,o],c,O(s.shape)),f=W([t,n,o],d,O(r.shape)),m=u[i]+h[f];m>l&&(l=m)}}}R[W([e,t,a,o],A,O(E))]=l}}}return{dataId:l.write(me(R,s.dtype),E,s.dtype),shape:E,dtype:s.dtype}}},rk={kernelName:"Dilation2DBackpropFilter",backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r,dy:a}=e,{strides:i,pad:o,dilations:u}=n,c=t,h=M(s.shape,c.data.get(s.dataId).values),p=M(r.shape,c.data.get(r.dataId).values),{batchSize:d,inHeight:f,inWidth:m,inChannels:g,outHeight:y,outWidth:b,padInfo:x,strideHeight:w,strideWidth:k,filterHeight:v,filterWidth:N,dilationHeight:I,dilationWidth:C,outShape:S}=Ts(s.shape,r.shape,i,o,"NHWC",u);l(a.rank===S.length,()=>`Error in Dilation2DBackpropFilter, dy must have the same rank as output ${S.length}, but got `+a.rank);const T=M(S,c.data.get(a.dataId).values),E=B(r.shape,r.dtype);for(let e=0;e<d;++e)for(let t=0;t<y;++t){const n=t*w-x.top;for(let s=0;s<b;++s){const r=s*k-x.left;for(let a=0;a<g;++a){let i=Number.MIN_SAFE_INTEGER,o=0,l=0;for(let t=0;t<v;++t){const s=n+t*I;if(s>=0&&s<f)for(let n=0;n<N;++n){const u=r+n*C;if(u>=0&&u<m){const r=h[e][s][u][a]+p[t][n][a];r>i&&(i=r,o=t,l=n)}}}E[o][l][a]+=T[e][t][s][a]}}}return{dataId:c.write(me(E,s.dtype),r.shape,r.dtype),shape:r.shape,dtype:r.dtype}}},ak={kernelName:"Dilation2DBackpropInput",backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r,dy:a}=e,{strides:i,pad:o,dilations:u}=n,c=t,h=M(s.shape,c.data.get(s.dataId).values),p=M(r.shape,c.data.get(r.dataId).values),{batchSize:d,inHeight:f,inWidth:m,inChannels:g,outHeight:y,outWidth:b,padInfo:x,strideHeight:w,strideWidth:k,filterHeight:v,filterWidth:N,dilationHeight:I,dilationWidth:C,outShape:S}=Ts(s.shape,r.shape,i,o,"NHWC",u);l(a.rank===S.length,()=>`Error in Dilation2DBackpropInput, dy must have the same rank as output ${S.length}, but got `+a.rank);const T=M(S,c.data.get(a.dataId).values),E=B(s.shape,s.dtype);for(let e=0;e<d;++e)for(let t=0;t<y;++t){const n=t*w-x.top;for(let s=0;s<b;++s){const r=s*k-x.left;for(let a=0;a<g;++a){let i=Number.MIN_SAFE_INTEGER,o=n<0?0:n,l=r<0?0:r;for(let t=0;t<v;++t){const s=n+t*I;if(s>=0&&s<f)for(let n=0;n<N;++n){const u=r+n*C;if(u>=0&&u<m){const r=h[e][s][u][a]+p[t][n][a];r>i&&(i=r,o=s,l=u)}}}E[e][o][l][a]+=T[e][t][s][a]}}}return{dataId:c.write(me(E,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};const ik={kernelName:"EluGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{dy:s,y:r}=t;kb([s,r],"eluGrad");const a=new Float32Array(p(r.shape)),i=n.data.get(r.dataId).values,o=n.data.get(s.dataId).values;for(let e=0;e<i.length;++e){const t=i[e];a[e]=t>=1?o[e]:o[e]*(t+1)}return n.makeTensorInfo(r.shape,"float32",a)}},ok=Mb("Equal",Sb((e,t)=>e===t?1:0),null,"bool"),lk={kernelName:"Equal",backendName:"cpu",kernelFunc:ok},uk=Hb(Z,e=>{const t=Math.sign(e),n=Math.abs(e),s=1/(1+.3275911*n);return t*(1-((((1.061405429*s-1.453152027)*s+1.421413741)*s-.284496736)*s+.254829592)*s*Math.exp(-n*n))}),ck={kernelName:Z,backendName:"cpu",kernelFunc:uk};function hk(e){const{inputs:t,backend:n,attrs:s}=e,{input:r}=t,{dim:a}=s,i=r.shape.length,o=r.shape.slice();let u=a;return a<0&&(l(-(i+1)<=a,()=>`Axis must be in the interval [${-(i+1)}, ${i}]`),u=i+a+1),o.splice(u,0,1),aw({inputs:{x:r},backend:n,attrs:{shape:o}})}const pk={kernelName:"ExpandDims",backendName:"cpu",kernelFunc:hk},dk=Mb("RealDiv",Sb((e,t)=>e/t)),fk={kernelName:"RealDiv",backendName:"cpu",kernelFunc:dk};function mk(e,t,n){const s=e.shape,r=s[0],a=s[1],i=n.data.get(e.dataId),o=i.complexTensorInfos.real,l=i.complexTensorInfos.imag,u=[r,a],c=p(u),h=k("float32",c),d=k("float32",c);for(let e=0;e<r;e++){const s=_x({inputs:{x:o},backend:n,attrs:{begin:[e,0],size:[1,a]}}),r=_x({inputs:{x:l},backend:n,attrs:{begin:[e,0],size:[1,a]}}),i=Tb({inputs:{real:s,imag:r},backend:n}),{real:u,imag:c}=gk(i,t,n),p=Bl(u,c);for(let t=0;t<a;t++){const n=Ul(p,t);h[e*a+t]=n.real,d[e*a+t]=n.imag}n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(i)}const f=n.makeTensorInfo(u,"float32",h),m=n.makeTensorInfo(u,"float32",d),g=Tb({inputs:{real:f,imag:m},backend:n});return n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}function gk(e,t,n){const s=p(e.shape),r=n.data.get(e.dataId),a=n.data.get(r.complexTensorInfos.real.dataId).values,i=n.data.get(r.complexTensorInfos.imag.dataId).values;if(0==((o=s)&o-1)){const r=function e(t,n,s,r,a){if(1===s)return{real:t,imag:n};const i=Bl(t,n),o=s/2,l=Wl(i),u=l.real,c=l.imag,h=[u.length],p=a.makeTensorInfo(h,"float32",u),d=a.makeTensorInfo(h,"float32",c),f=Tb({inputs:{real:p,imag:d},backend:a}),m=Vl(i),g=m.real,y=m.imag,b=[g.length],x=a.makeTensorInfo(b,"float32",g),w=a.makeTensorInfo(b,"float32",y),k=Tb({inputs:{real:x,imag:w},backend:a}),v=e(u,c,o,r,a),N=v.real,I=v.imag,C=[N.length],S=a.makeTensorInfo(C,"float32",N),T=a.makeTensorInfo(C,"float32",I),E=Tb({inputs:{real:S,imag:T},backend:a}),$=e(g,y,o,r,a),A=$.real,R=$.imag,F=[A.length],D=a.makeTensorInfo(F,"float32",A),_=a.makeTensorInfo(F,"float32",R),O=Tb({inputs:{real:D,imag:_},backend:a}),M=Hl(s,r),L=[M.real.length],z=a.makeTensorInfo(L,"float32",M.real),B=a.makeTensorInfo(L,"float32",M.imag),P=Tb({inputs:{real:z,imag:B},backend:a}),W=xx({inputs:{a:P,b:O},backend:a}),V=Pb({inputs:{a:E,b:W},backend:a}),U=Wx({inputs:{a:E,b:W},backend:a}),G=Fb({inputs:{input:V},backend:a}),H=Fb({inputs:{input:U},backend:a}),j=_w({inputs:{input:V},backend:a}),q=_w({inputs:{input:U},backend:a}),K=Mw({inputs:[G,H],backend:a,attrs:{axis:0}}),X=Mw({inputs:[j,q],backend:a,attrs:{axis:0}}),Y=a.data.get(K.dataId).values,J=a.data.get(X.dataId).values;return a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(d),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(x),a.disposeIntermediateTensorInfo(w),a.disposeIntermediateTensorInfo(k),a.disposeIntermediateTensorInfo(S),a.disposeIntermediateTensorInfo(T),a.disposeIntermediateTensorInfo(E),a.disposeIntermediateTensorInfo(D),a.disposeIntermediateTensorInfo(_),a.disposeIntermediateTensorInfo(O),a.disposeIntermediateTensorInfo(z),a.disposeIntermediateTensorInfo(B),a.disposeIntermediateTensorInfo(P),a.disposeIntermediateTensorInfo(W),a.disposeIntermediateTensorInfo(V),a.disposeIntermediateTensorInfo(U),a.disposeIntermediateTensorInfo(G),a.disposeIntermediateTensorInfo(j),a.disposeIntermediateTensorInfo(H),a.disposeIntermediateTensorInfo(q),a.disposeIntermediateTensorInfo(K),a.disposeIntermediateTensorInfo(X),{real:Y,imag:J}}(a,i,s,t,n),o=[e.shape[0],e.shape[1]];if(t){const e=n.makeTensorInfo(o,"float32",r.real),t=n.makeTensorInfo(o,"float32",r.imag),a=n.makeTensorInfo([],"float32",fe(s,"float32")),i=Ab({inputs:{x:a},backend:n}),l=fk.kernelFunc({inputs:{a:e,b:a},backend:n}),u=fk.kernelFunc({inputs:{a:t,b:i},backend:n}),c=n.data.get(l.dataId).values,h=n.data.get(u.dataId).values;return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(a),n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(u),{real:c,imag:h}}return r}return Pl(function(e,t,n){const s=new Float32Array(2*t);for(let r=0;r<t;r++){let a=0,i=0;for(let s=0;s<t;s++){const o=jl(r*s,t,n),l=Ul(e,s);a+=l.real*o.real-l.imag*o.imag,i+=l.real*o.imag+l.imag*o.real}n&&(a/=t,i/=t),Gl(s,a,i,r)}return s}(Bl(a,i),s,t));var o}const yk={kernelName:"FFT",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t,r=p(s.shape),a=s.shape[s.shape.length-1],i=aw({inputs:{x:s},backend:n,attrs:{shape:[r/a,a]}}),o=mk(i,!1,n),l=aw({inputs:{x:o},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),l}};function bk(e){const{backend:t,attrs:n}=e,{shape:s,value:r,dtype:a}=n,i=a||F(r),o=v(i,p(s));return function(e,t,n){e.fill(t)}(o,r),t.makeTensorInfo(s,i,o)}const xk={kernelName:"Fill",backendName:"cpu",kernelFunc:bk};const wk={kernelName:"FlipLeftRight",backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,r=n,a=k(s.dtype,p(s.shape)),[i,o,l,u]=s.shape,c=r.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*l*o*u;for(let e=0;e<o;e++){const n=e*(l*u);for(let s=0;s<l;s++){const r=s*u;for(let o=0;o<u;o++){const h=[i,e,s,o][2],p=Math.round(l-h),d=t+n+r+o;let f=c[d];if(p>=0&&p<l){f=c[t+n+p*u+o]}a[d]=f}}}}return{dataId:r.write(a,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},kk={kernelName:"FloorDiv",backendName:"cpu",kernelFunc:Mb("FloorDiv",Sb((e,t)=>Math.floor(e/t)),null,"int32")};const vk={kernelName:"FusedConv2D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s;let m=zw({inputs:{x:r,filter:a},backend:n,attrs:{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p}});if(i){const e=m;m=Pb({inputs:{a:m,b:i},backend:n}),n.disposeIntermediateTensorInfo(e)}if(d){const e=m;m=rw(n,m,d,o,f),n.disposeIntermediateTensorInfo(e)}return m}};const Nk={kernelName:"FusedDepthwiseConv2D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s;let m=Zw({inputs:{x:r,filter:a},backend:n,attrs:{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p}});if(i){const e=m;m=Pb({inputs:{a:m,b:i},backend:n}),n.disposeIntermediateTensorInfo(e)}if(d){const e=m;m=rw(n,m,d,o,f),n.disposeIntermediateTensorInfo(e)}return m}};const Ik={kernelName:"GatherNd",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{params:s,indices:r}=t,a=p(s.shape),i=r.shape,o=i[i.length-1],[l,u,c,h]=Nn(s,r);if(0===u)return n.makeTensorInfo(l,s.dtype,[]);const d=Kt([u,c],s.dtype),f=n.data.get(r.dataId).values,m=n.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=[];let n=0;for(let s=0;s<o;s++){const r=f[e*o+s];n+=r*h[s],t.push(r)}if(n<0||n>=a/c)throw new Error(`Invalid indices: ${t} does not index into ${s.shape}`);for(let t=0;t<c;t++)d.values[e*c+t]=m[n*c+t]}return n.makeTensorInfo(l,d.dtype,d.values)}};const Ck={kernelName:"GatherV2",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,indices:a}=t,{axis:i,batchDims:o}=s;kb([r,a],"gatherV2");let l=o;null==o&&(l=0);const u=p(a.shape),c=Yl(r,a,x(i,r.shape)[0],l),h=aw({inputs:{x:r},backend:n,attrs:{shape:[c.batchSize,c.outerSize,c.dimSize,c.sliceSize]}}),d=aw({inputs:{x:a},backend:n,attrs:{shape:[c.batchSize,u/c.batchSize]}}),f=[c.batchSize,c.outerSize,u/c.batchSize,c.sliceSize],m=n.bufferSync(d),g=sx(n.bufferSync(h),m,f);return n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(d),n.makeTensorInfo(c.outputShape,g.dtype,g.values)}},Sk={kernelName:"GreaterEqual",backendName:"cpu",kernelFunc:Mb("GreaterEqual",Sb((e,t)=>e>=t?1:0),null,"bool")};const Tk={kernelName:"IFFT",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t,r=p(s.shape),a=s.shape[s.shape.length-1],i=aw({inputs:{x:s},backend:n,attrs:{shape:[r/a,a]}}),o=mk(i,!0,n),l=aw({inputs:{x:o},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),l}},Ek={kernelName:"IsFinite",backendName:"cpu",kernelFunc:Hb("IsFinite",e=>Number.isFinite(e)?1:0,"bool")},$k={kernelName:"IsInf",backendName:"cpu",kernelFunc:Hb("IsInf",e=>Math.abs(e)===1/0?1:0,"bool")},Ak={kernelName:"IsNan",backendName:"cpu",kernelFunc:Hb("IsNan",e=>Number.isNaN(e)?1:0,"bool")},Rk={kernelName:"LessEqual",backendName:"cpu",kernelFunc:Mb("LessEqual",Sb((e,t)=>e<=t?1:0),null,"bool")};const Fk={kernelName:"LinSpace",backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,num:a}=n,i=lx(s,r,a);return t.makeTensorInfo([i.length],"float32",i)}},Dk={kernelName:"Log1p",backendName:"cpu",kernelFunc:Hb("Log1p",e=>Math.log1p(e))},_k={kernelName:"LogicalAnd",backendName:"cpu",kernelFunc:Mb("LogicalAnd",Sb((e,t)=>e&&t),null,"bool")},Ok={kernelName:"LogicalNot",backendName:"cpu",kernelFunc:Hb("LogicalNot",e=>e?0:1,"bool")},Mk={kernelName:"LogicalOr",backendName:"cpu",kernelFunc:Mb("LogicalOr",Sb((e,t)=>e||t),null,"bool")};const Lk={kernelName:"LRN",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{depthRadius:a,bias:i,alpha:o,beta:l}=s;kb(r,"LRN");const u=r.shape[3],c=u-1,h=n.data.get(r.dataId).values,d=p(r.shape),f=new Float32Array(d);function m(e){const t=e%u;let n=e-t+Math.max(0,t-a);const s=e-t+Math.min(t+a,c);let r=0;for(;n<=s;n++){const e=h[n];r+=e*e}return r}for(let e=0;e<d;e++){const t=m(e),n=h[e]*Math.pow(i+o*t,-l);f[e]=n}return n.makeTensorInfo(r.shape,r.dtype,f)}};const zk={kernelName:"LRNGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,y:a,dy:i}=t,{depthRadius:o,bias:l,alpha:u,beta:c}=s;kb(i,"LRNGrad");const h=p(i.shape),d=i.shape[3],f=n.data.get(i.dataId).values,m=n.data.get(r.dataId).values,g=n.data.get(a.dataId).values,y=new Float32Array(h),b=h;for(let e=0;e<b;e++){const t=e%d,n=e-t+Math.max(0,t-o),s=e-t+Math.min(d,t+o+1);let r=0;for(let e=n;e<s;e++)r+=Math.pow(m[e],2);r=u*r+l;for(let t=n;t<s;t++){let n=-2*u*c*m[t]*g[e]/r;e===t&&(n+=Math.pow(r,-c)),n*=f[e],y[t]+=n}}return n.makeTensorInfo(i.shape,r.dtype,y)}};function Bk(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reductionIndices:a,keepDims:i}=s,o=n;let l=r.shape;const u=l.length,c=x(a,l);let h=c;const d=fa(h,u);let f=o.data.get(r.dataId).values;if(null!=d){const e=new Array(u);for(let t=0;t<e.length;t++)e[t]=l[d[t]];f=Cx(f,l,r.dtype,d,e),h=ga(h.length,u),l=e}kb(r,"max"),da("max",h,u);const[m,g]=ha(l,h),y=px(f,p(g),m,r.dtype),b=o.write(y,m,r.dtype);let w=m;if(i){w=pa(m,c)}return{dataId:b,shape:w,dtype:r.dtype}}const Pk={kernelName:"Max",backendName:"cpu",kernelFunc:Bk};const Wk={kernelName:"MaxPool",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;kb(r,"maxPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:u}=s;l(zs(i,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`);const c=Es(r.shape,a,i,1,o,u);let h;if(1===c.filterWidth&&1===c.filterHeight&&d(c.inShape,c.outShape))h=Ab({inputs:{x:r},backend:n});else{const e=n.data.get(r.dataId).values,t=O(r.shape),s=vw(e,r.shape,r.dtype,t,c,"max");h=n.makeTensorInfo(c.outShape,r.dtype,s.values)}return h}};const Vk={kernelName:"MaxPool3D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s;kb(r,"maxPool3d");const c=$s(r.shape,a,i,1,o,l,u),h=Iw(n.data.get(r.dataId).values,r.shape,r.dtype,O(r.shape),c,"max");return n.makeTensorInfo(h.shape,"float32",h.values)}};const Uk={kernelName:"MaxPool3DGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,{filterSize:i,strides:o,pad:l,dimRoundingMode:u}=s;kb([r,a],"maxPool3DGrad");const c=$s(a.shape,i,o,1,l,u),h=function(e,t){const n=Kt(t.outShape,"int32"),s=t.strideDepth,r=t.strideHeight,a=t.strideWidth,i=t.dilationDepth,o=t.dilationHeight,l=t.dilationWidth,u=t.effectiveFilterDepth,c=t.effectiveFilterHeight,h=t.effectiveFilterWidth,p=t.padInfo.front,d=t.padInfo.top,f=t.padInfo.left;for(let m=0;m<t.batchSize;++m)for(let g=0;g<t.inChannels;++g)for(let y=0;y<t.outDepth;++y){const b=y*s-p;let x=b;for(;x<0;)x+=i;const w=Math.min(t.inDepth,u+b);for(let s=0;s<t.outHeight;++s){const u=s*r-d;let p=u;for(;p<0;)p+=o;const k=Math.min(t.inHeight,c+u);for(let r=0;r<t.outWidth;++r){const d=r*a-f;let v=d;for(;v<0;)v+=l;const N=Math.min(t.inWidth,h+d);let I=Number.NEGATIVE_INFINITY,C=-1;for(let t=x;t<w;t+=i){const n=t-b;for(let s=p;s<k;s+=o){const r=s-u;for(let a=v;a<N;a+=l){const i=a-d,o=e.get(m,t,s,a,g);o>=I&&(I=o,C=n*c*h+r*c+i)}}}n.set(C,m,y,s,r,g)}}}return n}(n.bufferSync(a),c),p=c.strideDepth,d=c.strideHeight,f=c.strideWidth,m=c.dilationDepth,g=c.dilationHeight,y=c.dilationWidth,b=c.effectiveFilterDepth,x=c.effectiveFilterHeight,w=c.effectiveFilterWidth,k=b-1-c.padInfo.front,v=w-1-c.padInfo.left,N=x-1-c.padInfo.top,I=Kt(a.shape,"float32"),C=n.bufferSync(r);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inDepth;++n)for(let s=0;s<c.inHeight;++s)for(let r=0;r<c.inWidth;++r){const a=n-k,i=s-N,o=r-v;let l=0;for(let n=0;n<b;n+=m){const s=(a+n)/p;if(!(s<0||s>=c.outDepth||Math.floor(s)!==s))for(let r=0;r<x;r+=g){const a=(i+r)/d;if(!(a<0||a>=c.outHeight||Math.floor(a)!==a))for(let i=0;i<w;i+=y){const u=(o+i)/f;if(u<0||u>=c.outWidth||Math.floor(u)!==u)continue;const p=b*x*w-1-h.get(e,s,a,u,t)===n*x*w+r*w+i?1:0;0!==p&&(l+=C.get(e,s,a,u,t)*p)}}}I.set(l,e,n,s,r,t)}return n.makeTensorInfo(I.shape,I.dtype,I.values)}};const Gk={kernelName:"MaxPoolGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a,output:i}=t,o=a;kb([a,i],"maxPoolGrad");const{filterSize:l,strides:u,pad:c,dimRoundingMode:h}=s,p=Es(o.shape,l,u,1,c,h),d=n.data.get(o.dataId).values,f=Kt(p.outShape,o.dtype,Nw(d,o.shape,o.dtype,p).values),m=p.strideHeight,g=p.strideWidth,y=p.dilationHeight,b=p.dilationWidth,x=p.effectiveFilterHeight,w=p.effectiveFilterWidth,k=w-1-p.padInfo.left,v=x-1-p.padInfo.top,N=Kt(o.shape,"float32"),I=n.data.get(r.dataId).values,C=Kt(r.shape,"float32",I);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inHeight;++n)for(let s=0;s<p.inWidth;++s){const r=n-v,a=s-k;let i=0;for(let n=0;n<x;n+=y){const s=(r+n)/m;if(!(s<0||s>=p.outHeight||Math.floor(s)!==s))for(let r=0;r<w;r+=b){const o=(a+r)/g;if(o<0||o>=p.outWidth||Math.floor(o)!==o)continue;const l=x*w-1-f.get(e,s,o,t)===n*w+r?1:0;0!==l&&(i+=C.get(e,s,o,t)*l)}}N.set(i,e,n,s,t)}return n.makeTensorInfo(N.shape,N.dtype,N.values)}};const Hk={kernelName:"MaxPoolWithArgmax",backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{filterSize:r,strides:a,pad:i,includeBatchInIndex:o}=t,l=n;kb(s,"MaxPoolWithArgmax");const u=l.data.get(s.dataId).values,c=Es(s.shape,r,a,[1,1],i),[h,p]=function(e,t,n,s,r){const a=vw(e,0,n,O(t),r,"max"),i=Nw(e,t,n,r,!0,s);return[a.values,i.values]}(u,s.shape,s.dtype,o,c),d=l.write(h,c.outShape,s.dtype),f=l.write(p,c.outShape,s.dtype);return[{dataId:d,shape:c.outShape,dtype:s.dtype},{dataId:f,shape:c.outShape,dtype:"int32"}]}};function jk(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;let o;kb(r,"sum"),o="bool"===r.dtype?_b({inputs:{x:r},backend:n,attrs:{dtype:"int32"}}):Ab({inputs:{x:r},backend:n});const l=o.shape.length,u=x(a,o.shape),c=fa(u,l);let h=u,d=o;null!=c&&(d=Sx({inputs:{x:o},backend:n,attrs:{perm:c}}),h=ga(h.length,l)),da("sum",h,d.shape.length);const[f,m]=ha(d.shape,h);let g=$b(n,f,We(d.dtype,"int32"));const y=p(m),b=n.data.get(g.dataId).values,w=n.data.get(d.dataId).values;for(let e=0;e<b.length;++e){const t=e*y;let n=0;for(let e=0;e<y;++e)n+=w[t+e];b[e]=n}if(i){const e=g;g=aw({inputs:{x:g},backend:n,attrs:{shape:pa(g.shape,u)}}),n.disposeIntermediateTensorInfo(e)}return n.disposeIntermediateTensorInfo(o),null!=c&&n.disposeIntermediateTensorInfo(d),g}const qk={kernelName:"Sum",backendName:"cpu",kernelFunc:jk};const Kk={kernelName:"Mean",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=x(a,r.shape),l=p(ha(r.shape,o)[1]),u=[],c=n.makeTensorInfo([],"float32",new Float32Array([l]));u.push(c);const h=_b({inputs:{x:r},backend:n,attrs:{dtype:"float32"}});u.push(h);const d=dk({inputs:{a:h,b:c},backend:n});u.push(d);const f=jk({inputs:{x:d},backend:n,attrs:{axis:a,keepDims:i}});return u.forEach(e=>n.disposeIntermediateTensorInfo(e)),f}};const Xk={kernelName:"Min",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;kb(r,"min");const o=x(a,r.shape);let l=o;const u=fa(l,r.shape.length);let c=r;null!=u&&(c=Sx({inputs:{x:r},backend:n,attrs:{perm:u}}),l=ga(l.length,r.shape.length)),da("min",l,c.shape.length);const[h,d]=ha(c.shape,l),f=p(d),m=z(p(h),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];s<n&&(n=s)}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(h,c.dtype,m);if(i){const e=aw({inputs:{x:y},backend:n,attrs:{shape:pa(h,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const Yk={kernelName:"MirrorPad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,mode:i}=s;kb(r,"mirrorPad");const o=a.map((e,t)=>e[0]+r.shape[t]+e[1]),l=a.map(e=>e[0]),u=a.map((e,t)=>e[0]+r.shape[t]),c="reflect"===i?0:1,h=n.data.get(r.dataId).values,d=r.shape.length,f=O(r.shape),m=p(o),g=o.length,y=O(o),b=k(r.dtype,m);for(let e=0;e<m;e++){let t=V(e,g,y);for(let e=0;e<g;e++)t[e]<l[e]?t[e]=2*l[e]-t[e]-c:t[e]>=u[e]&&(t[e]=2*(u[e]-1)-t[e]+c);t=t.map((e,t)=>e-l[t]);const n=W(t,d,f);b[e]=h[n]}return{dataId:n.write(b,o,r.dtype),shape:o,dtype:r.dtype}}},Jk=Sb((e,t)=>{const n=e%t;return e<0&&t<0||e>=0&&t>=0?n:(n+t)%t}),Zk=Mb(te,Jk),Qk={kernelName:te,backendName:"cpu",kernelFunc:Zk};function ev(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{dim:a}=s,i=r.shape.length;let o=a;if(-1===o&&(o=i-1),o!==i-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${i} and dim was ${o}`);const l=x([o],r.shape),u=Bk({inputs:{x:r},backend:n,attrs:{reductionIndices:l,keepDims:!1}}),c=pa(u.shape,l),h=aw({inputs:{x:u},backend:n,attrs:{shape:c}}),p=Wx({inputs:{a:r,b:h},backend:n}),d=Jb({inputs:{x:p},backend:n}),f=jk({inputs:{x:d},backend:n,attrs:{axis:l,keepDims:!1}}),m=aw({inputs:{x:f},backend:n,attrs:{shape:c}}),g=dk({inputs:{a:d,b:m},backend:n});return n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}const tv={kernelName:"Softmax",backendName:"cpu",kernelFunc:ev};const nv={kernelName:"Multinomial",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{numSamples:a,seed:i,normalized:o}=s;kb(r,"multinomial");const l=o?r:ev({inputs:{logits:r},backend:n,attrs:{dim:-1}}),u=l.shape[0],c=l.shape[1],h=n.data.get(l.dataId).values,d=[u,a],f=z(p(d),"int32");for(let e=0;e<u;++e){const t=e*c,n=new Float32Array(c-1);n[0]=h[t];for(let e=1;e<n.length;++e)n[e]=n[e-1]+h[t+e];const s=ai(i.toString()),r=e*a;for(let e=0;e<a;++e){const t=s();f[r+e]=n.length;for(let s=0;s<n.length;s++)if(t<n[s]){f[r+e]=s;break}}}return o||n.disposeIntermediateTensorInfo(l),n.makeTensorInfo(d,"int32",f)}},sv=Lo;const rv={kernelName:"NonMaxSuppressionV3",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=s;kb(r,"NonMaxSuppression");const u=n.data.get(r.dataId).values,c=n.data.get(a.dataId).values,{selectedIndices:h}=sv(u,c,i,o,l);return n.makeTensorInfo([h.length],"int32",new Int32Array(h))}},av=zo;const iv={kernelName:"NonMaxSuppressionV4",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,padToMaxOutputSize:u}=s;kb(r,"NonMaxSuppressionPadded");const c=n.data.get(r.dataId).values,h=n.data.get(a.dataId).values,{selectedIndices:p,validOutputs:d}=av(c,h,i,o,l,u);return[n.makeTensorInfo([p.length],"int32",new Int32Array(p)),n.makeTensorInfo([],"int32",new Int32Array([d]))]}},ov=Bo;const lv={kernelName:"NonMaxSuppressionV5",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,softNmsSigma:u}=s;kb(r,"NonMaxSuppressionWithScore");const c=n.data.get(r.dataId).values,h=n.data.get(a.dataId).values,p=i,d=o,f=l,m=u,{selectedIndices:g,selectedScores:y}=ov(c,h,p,d,f,m);return[n.makeTensorInfo([g.length],"int32",new Int32Array(g)),n.makeTensorInfo([y.length],"float32",new Float32Array(y))]}};const uv={kernelName:"OneHot",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r}=t,{depth:a,onValue:i,offValue:o}=s;kb(r,"oneHot");const l=p(r.shape),u=new Float32Array(l*a);u.fill(o);const c=n.data.get(r.dataId).values;for(let e=0;e<l;++e)c[e]>=0&&c[e]<a&&(u[e*a+c[e]]=i);return n.makeTensorInfo([...r.shape,a],"int32",u)}};function cv(e){const{inputs:t,backend:n}=e,{x:s}=t;if("string"===s.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===s.dtype){const e=Fb({inputs:{input:s},backend:n}),t=cv({inputs:{x:e},backend:n}),r=_w({inputs:{input:s},backend:n}),a=cv({inputs:{x:r},backend:n}),i=Tb({inputs:{real:t,imag:a},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(a),i}return bk({backend:n,attrs:{shape:s.shape,value:0,dtype:s.dtype}})}const hv={kernelName:"ZerosLike",backendName:"cpu",kernelFunc:cv};const pv={kernelName:"OnesLike",backendName:"cpu",kernelFunc:function e(t){const{inputs:n,backend:s}=t,{x:r}=n;if("string"===r.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===r.dtype){const t=Fb({inputs:{input:r},backend:s}),n=e({inputs:{x:t},backend:s}),a=_w({inputs:{input:r},backend:s}),i=cv({inputs:{x:a},backend:s}),o=Tb({inputs:{real:n,imag:i},backend:s});return s.disposeIntermediateTensorInfo(t),s.disposeIntermediateTensorInfo(n),s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}return bk({backend:s,attrs:{shape:r.shape,value:1,dtype:r.dtype}})}};function dv(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s;if(1===t.length)return hk({inputs:{input:t[0]},backend:n,attrs:{dim:r}});const a=t[0].shape,i=t[0].dtype;t.forEach(e=>{u(a,e.shape,"All tensors passed to stack must have matching shapes"),l(i===e.dtype,()=>"All tensors passed to stack must have matching dtypes")});const o=[],c=Mw({inputs:t.map(e=>{const t=hk({inputs:{input:e},backend:n,attrs:{dim:r}});return o.push(t),t}),backend:n,attrs:{axis:r}});return o.forEach(e=>n.disposeIntermediateTensorInfo(e)),c}const fv={kernelName:"Pack",backendName:"cpu",kernelFunc:dv};const mv={kernelName:"PadV2",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,constantValue:i}=s;kb(r,"pad");const o=a.map((e,t)=>e[0]+r.shape[t]+e[1]),l=a.map(e=>e[0]),u=n.data.get(r.dataId).values,c=p(r.shape),h=r.shape.length,d=O(r.shape),f=p(o),m=o.length,g=O(o),y=k(r.dtype,f);0!==i&&y.fill(i);for(let e=0;e<c;e++){y[W(V(e,h,d).map((e,t)=>e+l[t]),m,g)]=u[e]}return{dataId:n.write(y,o,r.dtype),shape:o,dtype:r.dtype}}},gv=Sb((e,t)=>Math.pow(e,t)),yv=Mb(ne,gv),bv={kernelName:ne,backendName:"cpu",kernelFunc:yv};const xv={kernelName:"Range",backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,dtype:a,step:i}=n,o=Ax(s,r,i,a);return t.makeTensorInfo([o.length],a,o)}},wv={kernelName:"Reciprocal",backendName:"cpu",kernelFunc:Hb("Reciprocal",e=>1/e)};const kv={kernelName:"ResizeBilinear",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s;kb(r,"resizeBilinear");const l=O(r.shape),[u,c]=o,[h,d,f,m]=r.shape,g=n.data.get(r.dataId).values,y=new Float32Array(p([h,u,c,m])),b=[a&&u>1?d-1:d,a&&c>1?f-1:f],x=[a&&u>1?u-1:u,a&&c>1?c-1:c];let w=0;const k=b[0]/x[0],v=b[1]/x[1];for(let e=0;e<h;e++)for(let t=0;t<u;t++){let n;n=i?k*(t+.5)-.5:k*t;const s=Math.max(0,Math.floor(n)),r=n-s,a=Math.min(d-1,Math.ceil(n)),o=e*l[0]+s*l[1],u=e*l[0]+a*l[1];for(let e=0;e<c;e++){let t;t=i?v*(e+.5)-.5:v*e;const n=Math.max(0,Math.floor(t)),s=t-n,a=Math.min(f-1,Math.ceil(t)),c=o+n*l[2],h=u+n*l[2],p=o+a*l[2],d=u+a*l[2];for(let e=0;e<m;e++){const t=g[c+e],n=g[h+e],a=t+(g[p+e]-t)*s,i=a+(n+(g[d+e]-n)*s-a)*r;y[w++]=i}}}return n.makeTensorInfo([h,u,c,m],"float32",y)}};const vv={kernelName:"ResizeBilinearGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s;kb([a,r],"resizeBilinearGrad");const o=O(r.shape),[l,u,c,h]=r.shape,[,p,d]=a.shape,f=new Float32Array(l*u*c*h),m=[i&&p>1?u-1:u,i&&d>1?c-1:c],g=[i&&p>1?p-1:p,i&&d>1?d-1:d],y=m[0]/g[0],b=m[1]/g[1],x=n.data.get(a.dataId).values;let w=0;for(let e=0;e<l;e++){const t=e*o[0];for(let e=0;e<p;e++){const n=e*y,s=Math.floor(n),r=Math.min(Math.ceil(n),u-1),a=t+s*o[1],i=t+r*o[1],l=n-s,p=1-l;for(let e=0;e<d;e++){const t=e*b,n=Math.floor(t),s=Math.min(Math.ceil(t),c-1),r=t-n,u=1-r,d=a+n*o[2],m=a+s*o[2],g=i+n*o[2],y=i+s*o[2],k=p*u,v=p*r,N=l*u,I=l*r;for(let e=0;e<h;e++){const t=x[w++];f[d+e]+=t*k,f[m+e]+=t*v,f[g+e]+=t*N,f[y+e]+=t*I}}}}return n.makeTensorInfo([l,c,u,h],"float32",f)}};const Nv={kernelName:"ResizeNearestNeighbor",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s;kb(r,"resizeNearestNeighbor");const l=O(r.shape),[u,c]=o,[h,p,d,f]=r.shape,m=n.data.get(r.dataId).values,g=new Float32Array(h*u*c*f),y=[a&&u>1?p-1:p,a&&c>1?d-1:d],b=[a&&u>1?u-1:u,a&&c>1?c-1:c],x=y[0]/b[0],w=y[1]/b[1];let k=0;for(let e=0;e<h;e++){const t=e*l[0];for(let e=0;e<u;e++){const n=i?x*(e+.5):x*e;let s=Math.min(p-1,a?Math.round(n):Math.floor(n));i&&(s=Math.max(0,s));const r=t+s*l[1];for(let e=0;e<c;e++){const t=i?w*(e+.5):w*e;let n=Math.min(d-1,a?Math.round(t):Math.floor(t));i&&(n=Math.max(0,n));const s=r+n*l[2];for(let e=0;e<f;e++){const t=m[s+e];g[k++]=t}}}}return n.makeTensorInfo([h,u,c,f],r.dtype,g)}};const Iv={kernelName:"ResizeNearestNeighborGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s;kb([a,r],"resizeNearestNeighborGrad");const o=O(r.shape),l=O(a.shape),[u,c,h,p]=r.shape,[,d,f]=a.shape,m=new Float32Array(u*c*h*p),g=n.data.get(a.dataId).values,y=[i&&d>1?c-1:c,i&&f>1?h-1:h],b=[i&&d>1?d-1:d,i&&f>1?f-1:f],x=y[0]/b[0],w=y[1]/b[1],k=1/x,v=1/w,N=2*Math.ceil(k)+2,I=2*Math.ceil(v)+2;for(let e=0;e<u;e++){const t=e*o[0];for(let e=0;e<c;e++){const n=t+e*o[1],s=Math.floor(e*k),r=Math.floor(s-N/2);for(let s=0;s<h;s++){const a=n+s*o[2],u=Math.floor(s*v),y=Math.floor(u-I/2);for(let n=0;n<p;n++){let o=0;for(let a=0;a<N;a++){const u=a+r;if(u<0||u>=d)continue;const p=t+u*l[1],m=u*x;if(e===Math.min(c-1,i?Math.round(m):Math.floor(m)))for(let e=0;e<I;e++){const t=e+y;if(t<0||t>=f)continue;const r=p+t*l[2],a=t*w;s===Math.min(h-1,i?Math.round(a):Math.floor(a))&&(o+=g[r+n])}}m[a+n]=o}}}}return n.makeTensorInfo(r.shape,r.dtype,m)}};const Cv={kernelName:"Reverse",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dims:a}=s;kb(r,"reverse");const i=r.shape.length,o=x(a,r.shape);if(0===i)return Ab({inputs:{x:r},backend:n});const l=new Ee(r.shape,r.dtype),u=n.bufferSync(r);for(let e=0;e<l.size;e++){const t=l.indexToLoc(e),n=t.slice();o.forEach(e=>n[e]=r.shape[e]-1-n[e]),l.set(u.get(...n),...t)}return n.makeTensorInfo(l.shape,l.dtype,l.values)}},Sv={kernelName:"RotateWithOffset",backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,{radians:r,fillValue:a,center:i}=t,o=n,l=k(s.dtype,p(s.shape)),[u,c,h,d]=s.shape,[f,m]=Rl(i,c,h),g=Math.sin(r),y=Math.cos(r),b=o.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=e*h*c*d;for(let e=0;e<c;e++){const n=e*(h*d);for(let s=0;s<h;s++){const r=s*d;for(let i=0;i<d;i++){const o=[u,e,s,i],p=o[2],x=o[1];let w=(p-f)*y-(x-m)*g,k=(p-f)*g+(x-m)*y;w=Math.round(w+f),k=Math.round(k+m);let v=a;if("number"!=typeof a&&(v=3===i?255:a[i]),w>=0&&w<h&&k>=0&&k<c){v=b[t+k*(h*d)+w*d+i]}l[t+n+r+i]=v}}}}return{dataId:o.write(l,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},Tv={kernelName:"Round",backendName:"cpu",kernelFunc:Hb("Round",e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1})};function Ev(e,t,n,s,r,a,i,o,l,u){const c=[s/r,r],h=e.values,p=t.values;if(0===s)return Kt(n,t.dtype);const d=Kt(c,t.dtype);d.values.fill(l);for(let e=0;e<a;e++){const a=[];let l=0;for(let t=0;t<i;t++){const n=h[e*i+t];a.push(n),l+=n*o[t]}if(l<0||l>=s/r)throw new Error(`Invalid indices: ${a} does not index into ${n}`);for(let n=0;n<r;n++)u?d.values[l*r+n]+=p[e*r+n]:d.values[l*r+n]=0===t.rank?p[0]:p[e*r+n]}return d}const $v={kernelName:"ScatterNd",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r,updates:a}=t,{shape:i}=s,{sliceRank:o,numUpdates:l,sliceSize:u,strides:c,outputSize:h}=Tn(0,r,i),p=Ev(n.bufferSync(r),n.bufferSync(a),i,h,u,l,o,c,0,!0);return n.makeTensorInfo(i,p.dtype,p.values)}};const Av={kernelName:"Select",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{condition:s,t:r,e:a}=t;kb([s,r,a],"select");const i=s.shape.length,o=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,u=n.data.get(a.dataId).values,c=We(r.dtype,a.dtype),h=z(p(r.shape),c);let d=0;const f=0===i||i>1||1===r.shape.length?1:p(r.shape.slice(1));for(let e=0;e<o.length;e++)for(let t=0;t<f;t++)1===o[e]?h[d++]=l[e]:h[d++]=u[e];return n.makeTensorInfo(r.shape,c,h)}},Rv={kernelName:"Selu",backendName:"cpu",kernelFunc:Hb("Selu",e=>e>=0?1.0507009873554805*e:1.7580993408473768*(Math.exp(e)-1))},Fv={kernelName:"Sigmoid",backendName:"cpu",kernelFunc:Hb("Sigmoid",e=>1/(1+Math.exp(-e)))},Dv={kernelName:"Sign",backendName:"cpu",kernelFunc:Hb("Sign",e=>e<0?-1:e>0?1:0)},_v=Hb(se,e=>Math.sin(e)),Ov={kernelName:se,backendName:"cpu",kernelFunc:_v},Mv={kernelName:"Sinh",backendName:"cpu",kernelFunc:Hb("Sinh",e=>Math.sinh(e))},Lv=Math.log(1.1920928955078125e-7)+2,zv={kernelName:"Softplus",backendName:"cpu",kernelFunc:Hb("Softplus",e=>{const t=e>-Lv,n=e<Lv,s=Math.exp(e);let r;return r=n?s:t?e:Math.log(1+s),r})};const Bv={kernelName:"SpaceToBatchND",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,paddings:i}=s;kb([r],"spaceToBatchND");const o=p(a),l=[[0,0]];l.push(...i);for(let e=1+a.length;e<r.shape.length;++e)l.push([0,0]);const u=mv.kernelFunc({inputs:{x:r},backend:n,attrs:{paddings:l,constantValue:0}}),c=Fl(u.shape,a,o,!1),h=Dl(c.length,a.length,!1),d=_l(u.shape,a,o,!1),f=aw({inputs:{x:u},backend:n,attrs:{shape:c}}),m=Sx({inputs:{x:f},backend:n,attrs:{perm:h}}),g=aw({inputs:{x:m},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}};const Pv={kernelName:"SparseToDense",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{sparseIndices:r,sparseValues:a,defaultValue:i}=t,{outputShape:o}=s,{sliceRank:l,numUpdates:u,sliceSize:c,strides:h,outputSize:p}=Tn(0,r,o),d=Ev(n.bufferSync(r),n.bufferSync(a),o,p,c,u,l,h,n.data.get(i.dataId).values[0],!1);return n.makeTensorInfo(o,d.dtype,d.values)}};const Wv={kernelName:"SplitV",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{numOrSizeSplits:a,axis:i}=s,o=x(i,r.shape)[0],l=ql(r,a,o),u=new Array(r.shape.length).fill(0),c=r.shape.slice();return l.map(e=>{const t=[...c];t[o]=e;const s=_x({inputs:{x:r},backend:n,attrs:{begin:u,size:t}});return u[o]+=e,s})}},Vv={kernelName:"Sqrt",backendName:"cpu",kernelFunc:Hb("Sqrt",e=>Math.sqrt(e))},Uv={kernelName:"Square",backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:n}=e,s=t;kb(n,"square");const r=s.data.get(n.dataId).values,a=new Float32Array(r.length);for(let e=0;e<r.length;++e){const t=r[e];a[e]=t*t}return{dataId:s.write(a,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},Gv={kernelName:"Step",backendName:"cpu",kernelFunc:Hb("Step",(e,t)=>{const n=t;return isNaN(e)?NaN:e>0?1:n.alpha})};const Hv={kernelName:"StridedSlice",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,end:i,strides:o,beginMask:l,endMask:u,ellipsisMask:c,newAxisMask:h,shrinkAxisMask:p}=s;kb(r,"stridedSlice");const{nonStrided:d,$begin:f,$strides:m,size:g,newShape:y,outShape:b}=Gn(r.shape,a,i,o,l,u,c,h,p),x=aw({inputs:{x:r},backend:n,attrs:{shape:y}});let w;if(d){const e=_x({inputs:{x:x},backend:n,attrs:{begin:f,size:g}});w=aw({inputs:{x:e},backend:n,attrs:{shape:b}}),n.disposeIntermediateTensorInfo(e)}else if(b.some(e=>0===e))w=n.makeTensorInfo(b,r.dtype,[]);else{const e=zx(b,n.bufferSync(x),m,f);w=n.makeTensorInfo(e.shape,e.dtype,e.values)}const k=aw({inputs:{x:w},backend:n,attrs:{shape:b}});return n.disposeIntermediateTensorInfo(x),n.disposeIntermediateTensorInfo(w),k}},jv=Hb(ae,e=>Math.tan(e)),qv={kernelName:ae,backendName:"cpu",kernelFunc:jv},Kv=Hb("Tanh",e=>Math.tanh(e));const Xv=[uw,Cb,cw,hw,Wb,pw,dw,fw,mw,gw,yw,bw,xw,ww,kw,Cw,Sw,Tw,Ew,lw,$w,Aw,Rw,Ob,Kb,Fw,Eb,Dw,Lw,Pw,Ww,Bw,Uw,Gw,Vw,jw,qw,Kw,Xw,Yw,Jw,Qw,ek,tk,nk,sk,ak,rk,fk,Kx,ik,lk,ck,Zb,pk,ex,yk,xk,wk,nx,kk,vk,Nk,Ik,Ck,ax,Sk,Rb,Tk,Ow,Ek,$k,Ak,Yx,ox,Rk,Fk,hx,Dk,_k,Ok,Mk,Lk,zk,fx,Wk,Vk,Uk,Gk,Hk,Pk,Kk,Xk,gx,Yk,Qk,nv,wx,vx,rv,iv,lv,Ix,uv,pv,fv,mv,bv,Qx,$x,xv,Db,wv,tw,sw,iw,kv,vv,Nv,Iv,Cv,Sv,Tv,Fx,$v,Av,Rv,Fv,Dv,Ov,Mv,Ox,tv,zv,Bv,Pv,Wv,Vv,Uv,Lx,Gv,Hv,Vx,qk,qv,{kernelName:"Tanh",backendName:"cpu",kernelFunc:Kv},{kernelName:"Tile",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reps:a}=s;kb(r,"tile");const i=Ux(n.bufferSync(r),a);return n.makeTensorInfo(i.shape,i.dtype,i.values)}},{kernelName:"TopK",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{k:a,sorted:i}=s;kb(r,"topk");const o=n.data.get(r.dataId).values,[l,u]=Gx(o,r.shape,r.dtype,a);return[n.makeTensorInfo(l.shape,l.dtype,l.values),n.makeTensorInfo(u.shape,u.dtype,u.values)]}},Tx,{kernelName:"Unique",backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{axis:r}=n,{x:a}=t;kb(a,"unique");const i=s.data.get(a.dataId).values,{outputValues:o,outputShape:l,indices:u}=Hx(i,r,a.shape,a.dtype);return[s.makeTensorInfo(l,a.dtype,o),s.makeTensorInfo([u.length],"int32",u)]}},{kernelName:"Unpack",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{value:r}=t;let{axis:a}=s;a<0&&(a+=r.shape.length);const i=r.shape.length,o=r.shape[a],l=new Array(i-1);let u=0;for(let e=0;e<i;e++)e!==a&&(l[u++]=r.shape[e]);const c=new Array(i).fill(0),h=r.shape.slice();h[a]=1;const p=new Array(o);for(let e=0;e<p.length;e++){c[a]=e;const t=_x({inputs:{x:r},backend:n,attrs:{begin:c,size:h}});p[e]=aw({inputs:{x:t},backend:n,attrs:{shape:l}}),n.disposeIntermediateTensorInfo(t)}return p}},{kernelName:"UnsortedSegmentSum",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,segmentIds:a}=t,{numSegments:i}=s;kb(r,"unsortedSegmentSum");const o=[],l=[],u=r.shape.length-a.shape.length;let c=a;for(let e=0;e<u;++e){const t=hk({inputs:{input:c},backend:n,attrs:{dim:e+1}});c=t,l.push(t)}for(let e=0;e<i;++e){const t=fe(e,"int32"),s=n.makeTensorInfo([],"int32",t),a=ok({inputs:{a:s,b:c},backend:n}),i=_b({inputs:{x:a},backend:n,attrs:{dtype:"float32"}}),u=xx({inputs:{a:i,b:r},backend:n}),h=jk({inputs:{x:u},backend:n,attrs:{axis:0,keepDims:!1}});o.push(h),l.push(s),l.push(a),l.push(i),l.push(u),l.push(h)}const h=dv({inputs:o,backend:n,attrs:{axis:0}});return l.forEach(e=>n.disposeIntermediateTensorInfo(e)),h}},hv];for(const e of Xv)he(e);const Yv={},Jv={alpha:!1,antialias:!1,premultipliedAlpha:!1,preserveDrawingBuffer:!1,depth:!1,stencil:!1,failIfMajorPerformanceCaveat:!0};function Zv(e){if(!(e in Yv)){const t=function(e){if(1!==e&&2!==e)throw new Error("Cannot get WebGL rendering context, WebGL is disabled.");const t=function(e){if("undefined"!=typeof OffscreenCanvas&&2===e)return new OffscreenCanvas(300,150);if("undefined"!=typeof document)return document.createElement("canvas");throw new Error("Cannot create a canvas in this context")}(e);if(t.addEventListener("webglcontextlost",t=>{t.preventDefault(),delete Yv[e]},!1),1===e)return t.getContext("webgl",Jv)||t.getContext("experimental-webgl",Jv);return t.getContext("webgl2",Jv)}(e);if(null===t)return console.log("Could not get context for WebGL version",e),null;Yv[e]=t}const t=Yv[e];return t.isContextLost()?(delete Yv[e],Zv(e)):(t.disable(t.DEPTH_TEST),t.disable(t.STENCIL_TEST),t.disable(t.BLEND),t.disable(t.DITHER),t.disable(t.POLYGON_OFFSET_FILL),t.disable(t.SAMPLE_COVERAGE),t.enable(t.SCISSOR_TEST),t.enable(t.CULL_FACE),t.cullFace(t.BACK),Yv[e])}var Qv,eN,tN;function nN(e,t){return[t,e]}function sN(e){const t=p(e);return m(Math.ceil(t/4))}function rN(e,t){return[Math.max(1,Math.ceil(t/2)),Math.max(1,Math.ceil(e/2))]}function aN(e,t){const n=e;let s,r,a,i,o,l,u,c,h,p;return 2===H().getNumber("WEBGL_VERSION")?(s=n.R32F,r=n.R16F,a=n.RGBA16F,i=n.RGBA32F,o=n.RED,u=4,c=1,h=n.HALF_FLOAT,p=n.FLOAT):(s=e.RGBA,r=e.RGBA,a=e.RGBA,i=n.RGBA,o=e.RGBA,u=4,c=4,h=null!=t?t.HALF_FLOAT_OES:null,p=e.FLOAT),l=e.RGBA,{internalFormatFloat:s,internalFormatHalfFloat:r,internalFormatPackedHalfFloat:a,internalFormatPackedFloat:i,textureFormatFloat:o,downloadTextureFormat:l,downloadUnpackNumChannels:u,defaultNumChannels:c,textureTypeHalfFloat:h,textureTypeFloat:p}}function iN(e,t){const n=t();return H().getBool("DEBUG")&&function(e){const t=e.getError();if(t!==e.NO_ERROR)throw new Error("WebGL Error: "+function(e,t){switch(t){case e.NO_ERROR:return"NO_ERROR";case e.INVALID_ENUM:return"INVALID_ENUM";case e.INVALID_VALUE:return"INVALID_VALUE";case e.INVALID_OPERATION:return"INVALID_OPERATION";case e.INVALID_FRAMEBUFFER_OPERATION:return"INVALID_FRAMEBUFFER_OPERATION";case e.OUT_OF_MEMORY:return"OUT_OF_MEMORY";case e.CONTEXT_LOST_WEBGL:return"CONTEXT_LOST_WEBGL";default:return"Unknown error code "+t}}(e,t))}(e),n}!function(e){e[e.DENSE=0]="DENSE",e[e.SHARED_BATCH=1]="SHARED_BATCH"}(Qv||(Qv={})),function(e){e[e.RENDER=0]="RENDER",e[e.UPLOAD=1]="UPLOAD",e[e.PIXELS=2]="PIXELS",e[e.DOWNLOAD=3]="DOWNLOAD"}(eN||(eN={})),function(e){e[e.UNPACKED_FLOAT16=0]="UNPACKED_FLOAT16",e[e.UNPACKED_FLOAT32=1]="UNPACKED_FLOAT32",e[e.PACKED_4X1_UNSIGNED_BYTE=2]="PACKED_4X1_UNSIGNED_BYTE",e[e.PACKED_2X2_FLOAT32=3]="PACKED_2X2_FLOAT32",e[e.PACKED_2X2_FLOAT16=4]="PACKED_2X2_FLOAT16"}(tN||(tN={}));function oN(e){return!!(H().getBool("WEBGL_RENDER_FLOAT32_ENABLED")||0===e||5.96e-8<Math.abs(e)&&Math.abs(e)<65504)}function lN(e,t){return yN(e,()=>e.getExtension(t),'Extension "'+t+'" not supported on this browser.')}function uN(e,t){const n=yN(e,()=>e.createShader(e.FRAGMENT_SHADER),"Unable to create fragment WebGLShader.");if(iN(e,()=>e.shaderSource(n,t)),iN(e,()=>e.compileShader(n)),!1===e.getShaderParameter(n,e.COMPILE_STATUS))throw function(e,t){const n=cN.exec(t);if(null==n)return console.log("Couldn't parse line number in error: "+t),void console.log(e);const s=+n[1],r=e.split("\n"),a=r.length.toString().length+2,i=r.map((e,t)=>g((t+1).toString(),a)+e);let o=0;for(let e=0;e<i.length;e++)o=Math.max(i[e].length,o);const l=i.slice(0,s-1),u=i.slice(s-1,s),c=i.slice(s);console.log(l.join("\n")),console.log(t.split("\n")[0]),console.log("%c "+g(u[0],o),"border:1px solid red; background-color:#e3d2d2; color:#a61717"),console.log(c.join("\n"))}(t,e.getShaderInfoLog(n)),new Error("Failed to compile fragment shader.");return n}const cN=/ERROR: [0-9]+:([0-9]+):/g;function hN(e,t){if(iN(e,()=>e.validateProgram(t)),!1===e.getProgramParameter(t,e.VALIDATE_STATUS))throw console.log(e.getProgramInfoLog(t)),new Error("Shader program validation failed.")}function pN(e,t,n,s,r,a,i){const o=e.getAttribLocation(t,n);return-1!==o&&(iN(e,()=>e.bindBuffer(e.ARRAY_BUFFER,s)),iN(e,()=>e.vertexAttribPointer(o,r,e.FLOAT,!1,a,i)),iN(e,()=>e.enableVertexAttribArray(o)),!0)}function dN(e,t,n,s){iN(e,()=>function(e,t,n){bN(e,n),iN(e,()=>e.activeTexture(e.TEXTURE0+n)),iN(e,()=>e.bindTexture(e.TEXTURE_2D,t))}(e,t,s)),iN(e,()=>e.uniform1i(n,s))}function fN(e,t,n){iN(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,n)),iN(e,()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0))}function mN(e,t){iN(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,t)),iN(e,()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,null,0))}function gN(e){const t=e.checkFramebufferStatus(e.FRAMEBUFFER);if(t!==e.FRAMEBUFFER_COMPLETE)throw new Error("Error binding framebuffer: "+function(e,t){switch(t){case e.FRAMEBUFFER_INCOMPLETE_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_DIMENSIONS:return"FRAMEBUFFER_INCOMPLETE_DIMENSIONS";case e.FRAMEBUFFER_UNSUPPORTED:return"FRAMEBUFFER_UNSUPPORTED";default:return"unknown error "+t}}(e,t))}function yN(e,t,n){const s=iN(e,()=>t());if(null==s)throw new Error(n);return s}function bN(e,t){const n=e.MAX_COMBINED_TEXTURE_IMAGE_UNITS-1,s=t+e.TEXTURE0;if(s<e.TEXTURE0||s>n){throw new Error(`textureUnit must be in ${`[gl.TEXTURE0, gl.TEXTURE${n}]`}.`)}}function xN(e,t=2){return p(e.slice(0,e.length-t))}function wN(e){if(0===e.length)throw Error("Cannot get rows and columns of an empty shape array.");return[e.length>1?e[e.length-2]:1,e[e.length-1]]}function kN(e){let t=[1,1,1];return 0===e.length||1===e.length&&1===e[0]||(t=[xN(e),...wN(e)]),t}function vN(e){return e%2==0}function NN(e,t){if(d(e=e.slice(-2),t=t.slice(-2)))return!0;if(!e.length||!t.length)return!0;if(0===e[0]||0===e[1]||0===t[0]||0===t[1])return!0;if(e.length!==t.length){const n=e.slice(-1)[0],s=t.slice(-1)[0];if(n===s)return!0;if(vN(n)&&vN(s)&&(1===e[0]||1===t[0]))return!0}return e[1]===t[1]&&vN(e[0])&&vN(t[0])}let IN,CN;function SN(e,t){return null!=e.getExtension(t)}function TN(e){try{if(null!=Zv(e))return!0}catch(e){return console.log("Error when getting WebGL context: ",e),!1}return!1}function EN(e){if(0===e)return!1;const t=Zv(e);if(1!==e){if(SN(t,"EXT_color_buffer_float"))return $N(t);const e="EXT_color_buffer_half_float";if(SN(t,e)){const n=t.getExtension(e);return function(e,t){const n=aN(e,t),s=e.createTexture();e.bindTexture(e.TEXTURE_2D,s);e.texImage2D(e.TEXTURE_2D,0,n.internalFormatHalfFloat,1,1,0,n.textureFormatFloat,n.textureTypeHalfFloat,null);const r=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,r),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,s,0);const a=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(s),e.deleteFramebuffer(r),a}(t,n)}return!1}return!!SN(t,"OES_texture_float")&&(!!SN(t,"WEBGL_color_buffer_float")&&$N(t))}function $N(e){const t=aN(e),n=e.createTexture();e.bindTexture(e.TEXTURE_2D,n);e.texImage2D(e.TEXTURE_2D,0,t.internalFormatFloat,1,1,0,t.textureFormatFloat,t.textureTypeFloat,null);const s=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,s),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,n,0);const r=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(n),e.deleteFramebuffer(s),r}function AN(e,t){Array.isArray(e)||(e=[e]),e.forEach(e=>{null!=e&&l("complex64"!==e.dtype,()=>t+" does not support complex64 tensors in the WebGL backend.")})}const RN=H();function FN(){let e,t,n,s,r,a,i,o,l,u;return 2===H().getNumber("WEBGL_VERSION")?(e="#version 300 es",t="in",n="out",s="in",r="texture",a="outputColor",i="out vec4 outputColor;",o="\n      bool isnan_custom(float val) {\n        return (val > 0.0 || val < 0.0) ? false : val != 0.0;\n      }\n\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan_custom(val.x),\n          isnan_custom(val.y), isnan_custom(val.z), isnan_custom(val.w));\n      }\n\n      #define isnan(value) isnan_custom(value)\n    ",l="",u="\n      #define round(value) newRound(value)\n      int newRound(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 newRound(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "):(e="",t="attribute",n="varying",s="varying",r="texture2D",a="gl_FragColor",i="",o="\n      #define isnan(value) isnan_custom(value)\n      bool isnan_custom(float val) {\n        return (val > 0. || val < 1. || val == 0.) ? false : true;\n      }\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan(val.x), isnan(val.y), isnan(val.z), isnan(val.w));\n      }\n    ",l="\n      uniform float INFINITY;\n\n      bool isinf(float val) {\n        return abs(val) == INFINITY;\n      }\n      bvec4 isinf(vec4 val) {\n        return equal(abs(val), vec4(INFINITY));\n      }\n    ",u="\n      int round(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 round(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "),{version:e,attribute:t,varyingVs:n,varyingFs:s,texture2D:r,output:a,defineOutput:i,defineSpecialNaN:o,defineSpecialInf:l,defineRound:u}}function DN(e,t,n="index"){const s=O(t);return s.map((t,r)=>`${`int ${e[r]} = ${n} / ${t}`}; ${r===s.length-1?`int ${e[r+1]} = ${n} - ${e[r]} * ${t}`:`index -= ${e[r]} * ${t}`};`).join("")}function _N(e){const t=O(e).map(e=>e.toString());return`\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * ${t[0]} + coords.y * ${t[1]} + coords.z;\n  }\n`}RN.registerFlag("HAS_WEBGL",()=>RN.getNumber("WEBGL_VERSION")>0),RN.registerFlag("WEBGL_VERSION",()=>TN(2)?2:TN(1)?1:0),RN.registerFlag("WEBGL_CHECK_NUMERICAL_PROBLEMS",()=>!1),RN.registerFlag("WEBGL_BUFFER_SUPPORTED",()=>2===RN.get("WEBGL_VERSION")),RN.registerFlag("WEBGL_CPU_FORWARD",()=>!0),RN.registerFlag("WEBGL_FORCE_F16_TEXTURES",()=>!1),RN.registerFlag("WEBGL_PACK",()=>RN.getBool("HAS_WEBGL")),RN.registerFlag("WEBGL_PACK_NORMALIZATION",()=>RN.getBool("WEBGL_PACK")),RN.registerFlag("WEBGL_PACK_CLIP",()=>RN.getBool("WEBGL_PACK")),RN.registerFlag("WEBGL_PACK_DEPTHWISECONV",()=>!1),RN.registerFlag("WEBGL_PACK_BINARY_OPERATIONS",()=>RN.getBool("WEBGL_PACK")),RN.registerFlag("WEBGL_PACK_UNARY_OPERATIONS",()=>RN.getBool("WEBGL_PACK")),RN.registerFlag("WEBGL_PACK_ARRAY_OPERATIONS",()=>RN.getBool("WEBGL_PACK")),RN.registerFlag("WEBGL_PACK_IMAGE_OPERATIONS",()=>RN.getBool("WEBGL_PACK")),RN.registerFlag("WEBGL_PACK_REDUCE",()=>RN.getBool("WEBGL_PACK")),RN.registerFlag("WEBGL_LAZILY_UNPACK",()=>RN.getBool("WEBGL_PACK")),RN.registerFlag("WEBGL_CONV_IM2COL",()=>RN.getBool("WEBGL_PACK")),RN.registerFlag("WEBGL_MAX_TEXTURE_SIZE",()=>function(e){if(null==IN){const t=Zv(e);IN=t.getParameter(t.MAX_TEXTURE_SIZE)}return IN}(RN.getNumber("WEBGL_VERSION"))),RN.registerFlag("WEBGL_MAX_TEXTURES_IN_SHADER",()=>function(e){if(null==CN){const t=Zv(e);CN=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS)}return Math.min(16,CN)}(RN.getNumber("WEBGL_VERSION"))),RN.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION",()=>{const e=RN.getNumber("WEBGL_VERSION");return 0===e?0:function(e){if(0===e)return 0;let t;const n=Zv(e);return t=SN(n,"EXT_disjoint_timer_query_webgl2")&&2===e?2:SN(n,"EXT_disjoint_timer_query")?1:0,t}(e)}),RN.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE",()=>RN.getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0&&!et()),RN.registerFlag("WEBGL_RENDER_FLOAT32_CAPABLE",()=>function(e){if(0===e)return!1;const t=Zv(e);if(1===e){if(!SN(t,"OES_texture_float"))return!1}else if(!SN(t,"EXT_color_buffer_float"))return!1;return $N(t)}(RN.getNumber("WEBGL_VERSION"))),RN.registerFlag("WEBGL_RENDER_FLOAT32_ENABLED",()=>!RN.getBool("WEBGL_FORCE_F16_TEXTURES")&&RN.getBool("WEBGL_RENDER_FLOAT32_CAPABLE")),RN.registerFlag("WEBGL_DOWNLOAD_FLOAT_ENABLED",()=>EN(RN.getNumber("WEBGL_VERSION"))),RN.registerFlag("WEBGL_FENCE_API_ENABLED",()=>{return 2===(e=RN.getNumber("WEBGL_VERSION"))&&null!=Zv(e).fenceSync;var e}),RN.registerFlag("WEBGL_SIZE_UPLOAD_UNIFORM",()=>RN.getBool("WEBGL_RENDER_FLOAT32_ENABLED")?4:0),RN.registerFlag("WEBGL_DELETE_TEXTURE_THRESHOLD",()=>-1,e=>{if(e<0&&-1!==e)throw new Error(`WEBGL_DELETE_TEXTURE_THRESHOLD must be -1 (indicating never delete) or at least 0, but got ${e}.`)});const ON="\n  const float FLOAT_MAX = 1.70141184e38;\n  const float FLOAT_MIN = 1.17549435e-38;\n\n  lowp vec4 encode_float(highp float v) {\n    if (isnan(v)) {\n      return vec4(255, 255, 255, 255);\n    }\n\n    highp float av = abs(v);\n\n    if(av < FLOAT_MIN) {\n      return vec4(0.0, 0.0, 0.0, 0.0);\n    } else if(v > FLOAT_MAX) {\n      return vec4(0.0, 0.0, 128.0, 127.0) / 255.0;\n    } else if(v < -FLOAT_MAX) {\n      return vec4(0.0, 0.0,  128.0, 255.0) / 255.0;\n    }\n\n    highp vec4 c = vec4(0,0,0,0);\n\n    highp float e = floor(log2(av));\n    highp float m = exp2(fract(log2(av))) - 1.0;\n\n    c[2] = floor(128.0 * m);\n    m -= c[2] / 128.0;\n    c[1] = floor(32768.0 * m);\n    m -= c[1] / 32768.0;\n    c[0] = floor(8388608.0 * m);\n\n    highp float ebias = e + 127.0;\n    c[3] = floor(ebias / 2.0);\n    ebias -= c[3] * 2.0;\n    c[2] += floor(ebias) * 128.0;\n\n    c[3] += 128.0 * step(0.0, -v);\n\n    return c / 255.0;\n  }\n";class MN{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outPackingScheme=Qv.DENSE;const t=sN(e),n=FN();this.outputShape=e,this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${DN(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n          vec2(${t[0]}, ${t[1]}));\n        int index = 4 * (resTexRC.x * ${t[1]} + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getA(rc.x, rc.y, rc.z);\n        }\n\n        ${n.output} = result;\n      }\n    `}}class LN{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outPackingScheme=Qv.DENSE;const t=sN(e),n=FN();this.outputShape=e,this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${DN(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n          vec2(${t[0]}, ${t[1]}));\n        int index = 4 * (resTexRC.x * ${t[1]} + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getChannel(getA(rc.x, rc.y, rc.z), vec2(rc.y, rc.z));\n        }\n\n        ${n.output} = result;\n      }\n    `}}class zN{constructor(e){this.variableNames=["A"],this.outTexUsage=eN.DOWNLOAD;const t=FN();this.outputShape=e,this.userCode=`\n      ${ON}\n\n      void main() {\n        float x = getAAtOutCoords();\n        ${t.output} = encode_float(x);\n      }\n    `}}class BN{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outTexUsage=eN.DOWNLOAD;const t=FN();this.outputShape=e,this.userCode=`\n      ${ON}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n        float x = getChannel(getAAtOutCoords(), vec2(coords.y, coords.z));\n        ${t.output} = encode_float(x);\n      }\n    `}}class PN{constructor(e,t,n=!1){this.variableNames=["A"];const s=FN(),[r,a]=t;this.outputShape=e;let i="result";n&&(i="floor(result * 255. + 0.5)"),this.userCode=`\n      ${_N(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        int flatIndex = getFlatIndex(coords);\n        int offset = imod(flatIndex, 4);\n\n        flatIndex = idiv(flatIndex, 4, 1.);\n\n        int r = flatIndex / ${a};\n        int c = imod(flatIndex, ${a});\n        vec2 uv = (vec2(c, r) + halfCR) / vec2(${a}.0, ${r}.0);\n        vec4 values = ${s.texture2D}(A, uv);\n\n        float result;\n\n        if(offset == 0) {\n          result = values[0];\n        } else if(offset == 1) {\n          result = values[1];\n        } else if(offset == 2) {\n          result = values[2];\n        } else {\n          result = values[3];\n        }\n\n        ${s.output} = vec4(${i}, 0., 0., 0.);\n      }\n    `}}class WN{constructor(e,t,n=!1){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const s=FN(),[r,a]=t;this.outputShape=e;let i="",o="result";n&&(o="floor(result * 255. + 0.5)");for(let t=0;t<=1;t++)for(let n=0;n<=1;n++){const o=2*t+n;i+=`\n          localCoords = coords;\n          if(localCoords[2] + ${n} < ${e[2]}) {\n            localCoords[2] += ${n};\n            if(localCoords[1] + ${t} < ${e[1]}) {\n              localCoords[1] += ${t};\n\n              flatIndex = getFlatIndex(localCoords);\n              offset = imod(flatIndex, 4);\n\n              flatIndex = idiv(flatIndex, 4, 1.);\n\n              r = flatIndex / ${a};\n              c = imod(flatIndex, ${a});\n              uv = (vec2(c, r) + halfCR) / vec2(${a}.0, ${r}.0);\n              values = ${s.texture2D}(A, uv);\n\n              if(offset == 0) {\n                result[${o}] = values[0];\n              } else if(offset == 1) {\n                result[${o}] = values[1];\n              } else if(offset == 2) {\n                result[${o}] = values[2];\n              } else {\n                result[${o}] = values[3];\n              }\n            }\n          }\n        `}this.userCode=`\n      ${_N(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        vec4 result = vec4(0.);\n        int flatIndex, r, c, offset;\n        ivec3 localCoords;\n        vec2 uv;\n        vec4 values;\n\n        ${i}\n\n        ${s.output} = ${o};\n      }\n    `}}function VN(e){const t=FN();return function(e,t){const n=yN(e,()=>e.createShader(e.VERTEX_SHADER),"Unable to create vertex WebGLShader.");if(iN(e,()=>e.shaderSource(n,t)),iN(e,()=>e.compileShader(n)),!1===e.getShaderParameter(n,e.COMPILE_STATUS))throw console.log(e.getShaderInfoLog(n)),new Error("Failed to compile vertex shader.");return n}(e,`${t.version}\n    precision highp float;\n    ${t.attribute} vec3 clipSpacePos;\n    ${t.attribute} vec2 uv;\n    ${t.varyingVs} vec2 resultUV;\n\n    void main() {\n      gl_Position = vec4(clipSpacePos, 1);\n      resultUV = uv;\n    }`)}function UN(e){return function(e,t){const n=yN(e,()=>e.createBuffer(),"Unable to create WebGLBuffer");return iN(e,()=>e.bindBuffer(e.ARRAY_BUFFER,n)),iN(e,()=>e.bufferData(e.ARRAY_BUFFER,t,e.STATIC_DRAW)),n}(e,new Float32Array([-1,1,0,0,1,-1,-1,0,0,0,1,1,0,1,1,1,-1,0,1,0]))}function GN(e){return function(e,t){const n=yN(e,()=>e.createBuffer(),"Unable to create WebGLBuffer");return iN(e,()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,n)),iN(e,()=>e.bufferData(e.ELEMENT_ARRAY_BUFFER,t,e.STATIC_DRAW)),n}(e,new Uint16Array([0,1,2,2,1,3]))}function HN(e,t,n,s,r,a){!function(e,t){const n=H().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(e<=0||t<=0){throw new Error("Requested texture size "+`[${e}x${t}]`+" is invalid.")}if(e>n||t>n){throw new Error("Requested texture size "+`[${e}x${t}]`+" greater than WebGL maximum on this browser / GPU "+`[${n}x${n}]`+".")}}(t,n);const i=function(e){return yN(e,()=>e.createTexture(),"Unable to create WebGLTexture.")}(e),o=e.TEXTURE_2D;return iN(e,()=>e.bindTexture(o,i)),iN(e,()=>e.texParameteri(o,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE)),iN(e,()=>e.texParameteri(o,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE)),iN(e,()=>e.texParameteri(o,e.TEXTURE_MIN_FILTER,e.NEAREST)),iN(e,()=>e.texParameteri(o,e.TEXTURE_MAG_FILTER,e.NEAREST)),iN(e,()=>e.texImage2D(o,0,s,t,n,0,r,a,null)),iN(e,()=>e.bindTexture(e.TEXTURE_2D,null)),i}function jN(e){return e.internalFormatFloat}function qN(e){return e.internalFormatHalfFloat}function KN(e){return e.downloadTextureFormat}function XN(e){return e.internalFormatPackedFloat}function YN(e){return e.internalFormatPackedHalfFloat}function JN(e,t,n,s,r,a,i,o){const l=e,u=new Float32Array(function(e,t){const[n,s]=rN(e,t);return n*s*4}(a,i));return l.bindBuffer(l.PIXEL_PACK_BUFFER,t),l.getBufferSubData(l.PIXEL_PACK_BUFFER,0,u),l.bindBuffer(l.PIXEL_PACK_BUFFER,null),u}class ZN{constructor(e){this.outputTexture=null,this.program=null,this.disposed=!1,this.vertexAttrsAreBound=!1,this.itemsToPoll=[];const t=H().getNumber("WEBGL_VERSION");null!=e?(this.gl=e,function(e,t){Yv[e]=t}(t,e)):this.gl=Zv(t);let n="WEBGL_color_buffer_float";if(1===H().getNumber("WEBGL_VERSION")){const e="OES_texture_float",t="OES_texture_half_float";if(this.textureFloatExtension=lN(this.gl,e),SN(this.gl,t))this.textureHalfFloatExtension=lN(this.gl,t);else if(H().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support half float textures, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.");if(this.colorBufferFloatExtension=this.gl.getExtension(n),SN(this.gl,"EXT_color_buffer_half_float"))this.colorBufferHalfFloatExtension=lN(this.gl,"EXT_color_buffer_half_float");else if(H().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support color renderable half floats, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.")}else if(n="EXT_color_buffer_float",SN(this.gl,n))this.colorBufferFloatExtension=this.gl.getExtension(n);else{if(!SN(this.gl,"EXT_color_buffer_half_float"))throw new Error("GL context does not support color renderable floats");this.colorBufferHalfFloatExtension=this.gl.getExtension("EXT_color_buffer_half_float")}this.vertexBuffer=UN(this.gl),this.indexBuffer=GN(this.gl),this.framebuffer=function(e){return yN(e,()=>e.createFramebuffer(),"Unable to create WebGLFramebuffer.")}(this.gl),this.textureConfig=aN(this.gl,this.textureHalfFloatExtension)}get debug(){return H().getBool("DEBUG")}dispose(){if(this.disposed)return;null!=this.program&&console.warn("Disposing a GPGPUContext that still has a bound WebGLProgram. This is probably a resource leak, delete the program with GPGPUContext.deleteProgram before disposing."),null!=this.outputTexture&&console.warn("Disposing a GPGPUContext that still has a bound output matrix texture.  This is probably a resource leak, delete the output matrix texture with GPGPUContext.deleteMatrixTexture before disposing.");const e=this.gl;iN(e,()=>e.finish()),iN(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,null)),iN(e,()=>e.deleteFramebuffer(this.framebuffer)),iN(e,()=>e.bindBuffer(e.ARRAY_BUFFER,null)),iN(e,()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,null)),iN(e,()=>e.deleteBuffer(this.indexBuffer)),this.disposed=!0}createFloat32MatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=nN(t,n);return HN(e,r,a,jN(s),s.textureFormatFloat,e.FLOAT)}(this.gl,e,t,this.textureConfig)}createFloat16MatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=nN(t,n);return HN(e,r,a,qN(s),s.textureFormatFloat,s.textureTypeHalfFloat)}(this.gl,e,t,this.textureConfig)}createUnsignedBytesMatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=nN(t,n);return HN(e,r,a,KN(s),e.RGBA,e.UNSIGNED_BYTE)}(this.gl,e,t,this.textureConfig)}uploadPixelDataToTexture(e,t){this.throwIfDisposed(),function(e,t,n){iN(e,()=>e.bindTexture(e.TEXTURE_2D,t)),n.data instanceof Uint8Array?iN(e,()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,n.width,n.height,0,e.RGBA,e.UNSIGNED_BYTE,n.data)):iN(e,()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,n)),iN(e,()=>e.bindTexture(e.TEXTURE_2D,null))}(this.gl,e,t)}uploadDenseMatrixToTexture(e,t,n,s){this.throwIfDisposed(),function(e,t,n,s,r,a){let i,o,l;iN(e,()=>e.bindTexture(e.TEXTURE_2D,t)),r instanceof Uint8Array?(i=new Uint8Array(n*s*4),o=e.UNSIGNED_BYTE,l=e.RGBA):(i=new Float32Array(n*s*4),o=e.FLOAT,l=a.internalFormatPackedFloat),i.set(r),iN(e,()=>e.texImage2D(e.TEXTURE_2D,0,l,n,s,0,e.RGBA,o,i)),iN(e,()=>e.bindTexture(e.TEXTURE_2D,null))}(this.gl,e,t,n,s,this.textureConfig)}createFloat16PackedMatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=rN(t,n);return HN(e,r,a,YN(s),e.RGBA,s.textureTypeHalfFloat)}(this.gl,e,t,this.textureConfig)}createPackedMatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=rN(t,n);return HN(e,r,a,XN(s),e.RGBA,e.FLOAT)}(this.gl,e,t,this.textureConfig)}deleteMatrixTexture(e){this.throwIfDisposed(),this.outputTexture===e&&(mN(this.gl,this.framebuffer),this.outputTexture=null),iN(this.gl,()=>this.gl.deleteTexture(e))}downloadByteEncodedFloatMatrixFromOutputTexture(e,t,n){return this.downloadMatrixDriver(e,()=>function(e,t,n,s){const[r,a]=nN(t,n),i=new Uint8Array(t*n*4);return iN(e,()=>e.readPixels(0,0,r,a,s.downloadTextureFormat,e.UNSIGNED_BYTE,i)),new Float32Array(i.buffer)}(this.gl,t,n,this.textureConfig))}downloadPackedMatrixFromBuffer(e,t,n,s,r,a){return JN(this.gl,e,0,0,0,r,a,this.textureConfig)}downloadFloat32MatrixFromBuffer(e,t){return function(e,t,n){const s=e,r=new Float32Array(n);return s.bindBuffer(s.PIXEL_PACK_BUFFER,t),s.getBufferSubData(s.PIXEL_PACK_BUFFER,0,r),s.bindBuffer(s.PIXEL_PACK_BUFFER,null),r}(this.gl,e,t)}createBufferFromTexture(e,t,n){this.bindTextureToFrameBuffer(e);const s=function(e,t,n,s){const r=e.createBuffer();iN(e,()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,r));const a=16*t*n;return iN(e,()=>e.bufferData(e.PIXEL_PACK_BUFFER,a,e.STREAM_READ)),iN(e,()=>e.readPixels(0,0,n,t,e.RGBA,e.FLOAT,0)),iN(e,()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,null)),r}(this.gl,t,n,this.textureConfig);return this.unbindTextureToFrameBuffer(),s}createAndWaitForFence(){const e=this.createFence(this.gl);return this.pollFence(e)}createFence(e){let t,n;if(H().getBool("WEBGL_FENCE_API_ENABLED")){const s=e,r=s.fenceSync(s.SYNC_GPU_COMMANDS_COMPLETE,0);e.flush(),n=()=>{const e=s.clientWaitSync(r,0,0);return e===s.ALREADY_SIGNALED||e===s.CONDITION_SATISFIED},t=r}else H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0?(t=this.beginQuery(),this.endQuery(),n=()=>this.isQueryAvailable(t,H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))):n=()=>!0;return{query:t,isFencePassed:n}}downloadMatrixFromPackedTexture(e,t,n){return this.downloadMatrixDriver(e,()=>function(e,t,n){const s=new Float32Array(t*n*4);return iN(e,()=>e.readPixels(0,0,n,t,e.RGBA,e.FLOAT,s)),s}(this.gl,t,n))}createProgram(e){this.throwIfDisposed();const t=this.gl,n=uN(t,e),s=VN(t),r=function(e){return yN(e,()=>e.createProgram(),"Unable to create WebGLProgram.")}(t);return iN(t,()=>t.attachShader(r,s)),iN(t,()=>t.attachShader(r,n)),function(e,t){if(iN(e,()=>e.linkProgram(t)),!1===e.getProgramParameter(t,e.LINK_STATUS))throw console.log(e.getProgramInfoLog(t)),new Error("Failed to link vertex and fragment shaders.")}(t,r),this.debug&&hN(t,r),this.vertexAttrsAreBound||(this.setProgram(r),this.vertexAttrsAreBound=function(e,t,n){return iN(e,()=>e.bindBuffer(e.ARRAY_BUFFER,n)),pN(e,t,"clipSpacePos",n,3,20,0)&&pN(e,t,"uv",n,2,20,12)}(t,this.program,this.vertexBuffer)),r}deleteProgram(e){this.throwIfDisposed(),e===this.program&&(this.program=null),null!=e&&iN(this.gl,()=>this.gl.deleteProgram(e))}setProgram(e){this.throwIfDisposed(),this.program=e,null!=this.program&&this.debug&&hN(this.gl,this.program),iN(this.gl,()=>this.gl.useProgram(e))}getUniformLocation(e,t,n=!0){return this.throwIfDisposed(),n?function(e,t,n){return yN(e,()=>e.getUniformLocation(t,n),'uniform "'+n+'" not present in program.')}(this.gl,e,t):function(e,t,n){return e.getUniformLocation(t,n)}(this.gl,e,t)}getAttributeLocation(e,t){return this.throwIfDisposed(),iN(this.gl,()=>this.gl.getAttribLocation(e,t))}getUniformLocationNoThrow(e,t){return this.throwIfDisposed(),this.gl.getUniformLocation(e,t)}setInputMatrixTexture(e,t,n){this.throwIfDisposed(),this.throwIfNoProgram(),dN(this.gl,e,t,n)}setOutputMatrixTexture(e,t,n){this.setOutputMatrixTextureDriver(e,n,t)}setOutputPackedMatrixTexture(e,t,n){this.throwIfDisposed();const[s,r]=rN(t,n);this.setOutputMatrixTextureDriver(e,s,r)}setOutputMatrixWriteRegion(e,t,n,s){this.setOutputMatrixWriteRegionDriver(n,e,s,t)}setOutputPackedMatrixWriteRegion(e,t,n,s){throw new Error("setOutputPackedMatrixWriteRegion not implemented.")}debugValidate(){null!=this.program&&hN(this.gl,this.program),gN(this.gl)}executeProgram(){this.throwIfDisposed(),this.throwIfNoProgram();const e=this.gl;this.debug&&this.debugValidate(),iN(e,()=>e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0))}blockUntilAllProgramsCompleted(){this.throwIfDisposed(),iN(this.gl,()=>this.gl.finish())}getQueryTimerExtension(){return null==this.disjointQueryTimerExtension&&(this.disjointQueryTimerExtension=lN(this.gl,2===H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")?"EXT_disjoint_timer_query_webgl2":"EXT_disjoint_timer_query")),this.disjointQueryTimerExtension}getQueryTimerExtensionWebGL2(){return this.getQueryTimerExtension()}getQueryTimerExtensionWebGL1(){return this.getQueryTimerExtension()}beginQuery(){if(2===H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,t=this.getQueryTimerExtensionWebGL2(),n=e.createQuery();return e.beginQuery(t.TIME_ELAPSED_EXT,n),n}const e=this.getQueryTimerExtensionWebGL1(),t=e.createQueryEXT();return e.beginQueryEXT(e.TIME_ELAPSED_EXT,t),t}endQuery(){if(2===H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,t=this.getQueryTimerExtensionWebGL2();return void e.endQuery(t.TIME_ELAPSED_EXT)}const e=this.getQueryTimerExtensionWebGL1();e.endQueryEXT(e.TIME_ELAPSED_EXT)}async waitForQueryAndGetTime(e){return await y(()=>this.disposed||this.isQueryAvailable(e,H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))),this.getQueryTime(e,H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))}getQueryTime(e,t){if(0===t)return null;if(2===t){const t=this.gl;return t.getQueryParameter(e,t.QUERY_RESULT)/1e6}{const t=this.getQueryTimerExtensionWebGL1();return t.getQueryObjectEXT(e,t.QUERY_RESULT_EXT)/1e6}}isQueryAvailable(e,t){if(0===t)return!0;if(2===t){const t=this.gl,n=this.getQueryTimerExtensionWebGL2(),s=t.getQueryParameter(e,t.QUERY_RESULT_AVAILABLE);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(n.GPU_DISJOINT_EXT)),s&&!this.disjoint}{const t=this.getQueryTimerExtensionWebGL1(),n=t.getQueryObjectEXT(e,t.QUERY_RESULT_AVAILABLE_EXT);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(t.GPU_DISJOINT_EXT)),n&&!this.disjoint}}pollFence(e){return new Promise(t=>{this.addItemToPoll(()=>e.isFencePassed(),()=>t())})}pollItems(){const e=function(e){let t=0;for(;t<e.length;++t){if(!e[t]())break}return t-1}(this.itemsToPoll.map(e=>e.isDoneFn));for(let t=0;t<=e;++t){const{resolveFn:e}=this.itemsToPoll[t];e()}this.itemsToPoll=this.itemsToPoll.slice(e+1)}addItemToPoll(e,t){this.itemsToPoll.push({isDoneFn:e,resolveFn:t}),this.itemsToPoll.length>1||y(()=>(this.pollItems(),0===this.itemsToPoll.length))}bindTextureToFrameBuffer(e){this.throwIfDisposed(),fN(this.gl,e,this.framebuffer),this.debug&&gN(this.gl)}unbindTextureToFrameBuffer(){null!=this.outputTexture?(fN(this.gl,this.outputTexture,this.framebuffer),this.debug&&gN(this.gl)):mN(this.gl,this.framebuffer)}downloadMatrixDriver(e,t){this.bindTextureToFrameBuffer(e);const n=t();return this.unbindTextureToFrameBuffer(),n}setOutputMatrixTextureDriver(e,t,n){this.throwIfDisposed();const s=this.gl;fN(s,e,this.framebuffer),this.debug&&gN(s),this.outputTexture=e,iN(s,()=>s.viewport(0,0,t,n)),iN(s,()=>s.scissor(0,0,t,n))}setOutputMatrixWriteRegionDriver(e,t,n,s){this.throwIfDisposed(),iN(this.gl,()=>this.gl.scissor(e,t,n,s))}throwIfDisposed(){if(this.disposed)throw new Error("Attempted to use disposed GPGPUContext.")}throwIfNoProgram(){if(null==this.program)throw new Error("No GPU program is currently set.")}}const{getBroadcastDims:QN}=eu;function eI(e,t,n,s){const r=[];e.forEach(e=>{const t=p(e.shapeInfo.logicalShape);e.shapeInfo.isUniform?r.push(`uniform float ${e.name}${t>1?`[${t}]`:""};`):(r.push(`uniform sampler2D ${e.name};`),r.push(`uniform int offset${e.name};`))});const a=r.join("\n"),i=e.map(e=>function(e,t,n=!1){let s="";s+=n?nI(e):tI(e);const r=e.shapeInfo.logicalShape,a=t.logicalShape;r.length<=a.length&&(s+=n?function(e,t){const n=e.name,s=n.charAt(0).toUpperCase()+n.slice(1),r="get"+s+"AtOutCoords",a=e.shapeInfo.logicalShape.length,i=t.logicalShape.length,o=QN(e.shapeInfo.logicalShape,t.logicalShape),l=cI(i),u=i-a;let c;const h=["x","y","z","w","u","v"];c=0===a?"":i<2&&o.length>=1?"coords = 0;":o.map(e=>`coords.${h[e+u]} = 0;`).join("\n");let d="";d=i<2&&a>0?"coords":e.shapeInfo.logicalShape.map((e,t)=>"coords."+h[t+u]).join(", ");let f="return outputValue;";const m=1===p(e.shapeInfo.logicalShape),g=1===p(t.logicalShape);if(1!==a||m||g){if(m&&!g)f=1===i?"\n        return vec4(outputValue.x, outputValue.x, 0., 0.);\n      ":"\n        return vec4(outputValue.x);\n      ";else if(o.length){const e=a-2,t=a-1;o.indexOf(e)>-1&&o.indexOf(t)>-1?f="return vec4(outputValue.x);":o.indexOf(e)>-1?f="return vec4(outputValue.x, outputValue.y, outputValue.x, outputValue.y);":o.indexOf(t)>-1&&(f="return vec4(outputValue.xx, outputValue.zz);")}}else f="\n      return vec4(outputValue.xy, outputValue.xy);\n    ";return`\n    vec4 ${r}() {\n      ${l} coords = getOutputCoords();\n      ${c}\n      vec4 outputValue = get${s}(${d});\n      ${f}\n    }\n  `}(e,t):function(e,t){const n=e.name,s=n.charAt(0).toUpperCase()+n.slice(1),r="get"+s+"AtOutCoords",a=t.texShape,i=e.shapeInfo.texShape,o=e.shapeInfo.logicalShape.length,l=t.logicalShape.length;if(!e.shapeInfo.isUniform&&o===l&&null==e.shapeInfo.flatOffset&&d(i,a))return`\n      float ${r}() {\n        return sampleTexture(${n}, resultUV);\n      }\n    `;const u=cI(l),c=QN(e.shapeInfo.logicalShape,t.logicalShape),h=l-o;let p;const f=["x","y","z","w","u","v"];p=0===o?"":l<2&&c.length>=1?"coords = 0;":c.map(e=>`coords.${f[e+h]} = 0;`).join("\n");let m="";m=l<2&&o>0?"coords":e.shapeInfo.logicalShape.map((e,t)=>"coords."+f[t+h]).join(", ");return`\n    float ${r}() {\n      ${u} coords = getOutputCoords();\n      ${p}\n      return get${s}(${m});\n    }\n  `}(e,t));return s}(e,t,s)).join("\n"),o=t.texShape,l=FN(),u=function(e){return`\n    float sampleTexture(sampler2D textureSampler, vec2 uv) {\n      return ${e.texture2D}(textureSampler, uv).r;\n    }\n  `}(l);let c,h,f=function(e){return`${e.version}\n    precision highp float;\n    precision highp int;\n    precision highp sampler2D;\n    ${e.varyingFs} vec2 resultUV;\n    ${e.defineOutput}\n    const vec2 halfCR = vec2(0.5, 0.5);\n\n    struct ivec5\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n    };\n\n    struct ivec6\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n      int v;\n    };\n\n    uniform float NAN;\n    ${e.defineSpecialNaN}\n    ${e.defineSpecialInf}\n    ${e.defineRound}\n\n    int imod(int x, int y) {\n      return x - y * (x / y);\n    }\n\n    int idiv(int a, int b, float sign) {\n      int res = a / b;\n      int mod = imod(a, b);\n      if (sign < 0. && mod != 0) {\n        res -= 1;\n      }\n      return res;\n    }\n\n    //Based on the work of Dave Hoskins\n    //https://www.shadertoy.com/view/4djSRW\n    #define HASHSCALE1 443.8975\n    float random(float seed){\n      vec2 p = resultUV * seed;\n      vec3 p3  = fract(vec3(p.xyx) * HASHSCALE1);\n      p3 += dot(p3, p3.yzx + 19.19);\n      return fract((p3.x + p3.y) * p3.z);\n    }\n\n    ${sI}\n    ${rI}\n    ${aI}\n  `}(l);return t.isPacked?(c=function(e,t){switch(e.length){case 0:return oI();case 1:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(1===n[0])return`\n      int getOutputCoords() {\n        return 2 * int(resultUV.x * ${n[1]}.0);\n      }\n    `;if(1===n[1])return`\n      int getOutputCoords() {\n        return 2 * int(resultUV.y * ${n[0]}.0);\n      }\n    `;return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      return 2 * (resTexRC.x * ${n[1]} + resTexRC.y);\n    }\n  `}(0,t);case 2:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(d(e,t))return`\n      ivec2 getOutputCoords() {\n        return 2 * ivec2(resultUV.yx * vec2(${n[0]}, ${n[1]}));\n      }\n    `;const s=Math.ceil(e[1]/2);return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n      int r = 2 * (index / ${s});\n      int c = imod(index, ${s}) * 2;\n\n      return ivec2(r, c);\n    }\n  `}(e,t);case 3:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)],s=Math.ceil(e[2]/2),r=s*Math.ceil(e[1]/2);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      int b = index / ${r};\n      index -= b * ${r};\n\n      int r = 2 * (index / ${s});\n      int c = imod(index, ${s}) * 2;\n\n      return ivec3(b, r, c);\n    }\n  `}(e,t);default:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)],s=Math.ceil(e[e.length-1]/2),r=s*Math.ceil(e[e.length-2]/2);let a=r,i="",o="b, r, c";for(let t=2;t<e.length-1;t++)a*=e[e.length-t-1],i=`\n      int b${t} = index / ${a};\n      index -= b${t} * ${a};\n    `+i,o=`b${t}, `+o;return`\n    ivec${e.length} getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      ${i}\n\n      int b = index / ${r};\n      index -= b * ${r};\n\n      int r = 2 * (index / ${s});\n      int c = imod(index, ${s}) * 2;\n\n      return ivec${e.length}(${o});\n    }\n  `}(e,t)}}(t.logicalShape,o),h=function(e){return`\n    void setOutput(vec4 val) {\n      ${e.output} = val;\n    }\n  `}(l)):(c=function(e,t){switch(e.length){case 0:return oI();case 1:return function(e,t){if(1===t[0])return`\n      int getOutputCoords() {\n        return int(resultUV.x * ${t[1]}.0);\n      }\n    `;if(1===t[1])return`\n      int getOutputCoords() {\n        return int(resultUV.y * ${t[0]}.0);\n      }\n    `;return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      return resTexRC.x * ${t[1]} + resTexRC.y;\n    }\n  `}(0,t);case 2:return function(e,t){if(d(e,t))return`\n      ivec2 getOutputCoords() {\n        return ivec2(resultUV.yx * vec2(${t[0]}, ${t[1]}));\n      }\n    `;if(1===e[1])return`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(index, 0);\n      }\n    `;if(1===e[0])return`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(0, index);\n      }\n    `;return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      int r = index / ${e[1]};\n      int c = index - r * ${e[1]};\n      return ivec2(r, c);\n    }\n  `}(e,t);case 3:return function(e,t){const n=DN(["r","c","d"],e);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      ${n}\n      return ivec3(r, c, d);\n    }\n  `}(e,t);case 4:return function(e,t){const n=DN(["r","c","d","d2"],e);return`\n    ivec4 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      ${n}\n      return ivec4(r, c, d, d2);\n    }\n  `}(e,t);case 5:return function(e,t){const n=DN(["r","c","d","d2","d3"],e);return`\n    ivec5 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx * vec2(${t[0]},\n                             ${t[1]}));\n\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec5 outShape = ivec5(r, c, d, d2, d3);\n      return outShape;\n    }\n  `}(e,t);case 6:return function(e,t){const n=DN(["r","c","d","d2","d3","d4"],e);return`\n    ivec6 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec6 result = ivec6(r, c, d, d2, d3, d4);\n      return result;\n    }\n  `}(e,t);default:throw new Error(e.length+"-D output sampling is not yet supported")}}(t.logicalShape,o),h=function(e){return`\n    void setOutput(float val) {\n      ${e.output} = vec4(val, 0, 0, 0);\n    }\n  `}(l)),s&&(f+=iI),[f,u,h,a,c,i,n].join("\n")}function tI(e){const t=e.shapeInfo.logicalShape;switch(t.length){case 0:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1);if(e.shapeInfo.isUniform)return`float ${n}() {return ${t};}`;const[s,r]=e.shapeInfo.texShape;if(1===s&&1===r)return`\n      float ${n}() {\n        return sampleTexture(${t}, halfCR);\n      }\n    `;const[a,i]=e.shapeInfo.texShape,o=lI(t);return`\n    float ${n}() {\n      vec2 uv = uvFromFlat(${a}, ${i}, ${o});\n      return sampleTexture(${t}, uv);\n    }\n  `}(e);case 1:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1);if(e.shapeInfo.isUniform)return`\n      float ${n}(int index) {\n        ${uI(e)}\n      }\n    `;const s=e.shapeInfo.texShape,r=s[0],a=s[1];if(1===a&&1===r)return`\n      float ${n}(int index) {\n        return sampleTexture(${t}, halfCR);\n      }\n    `;const i=lI(t);if(1===a)return`\n      float ${n}(int index) {\n        vec2 uv = vec2(0.5, (float(index + ${i}) + 0.5) / ${r}.0);\n        return sampleTexture(${t}, uv);\n      }\n    `;if(1===r)return`\n      float ${n}(int index) {\n        vec2 uv = vec2((float(index + ${i}) + 0.5) / ${a}.0, 0.5);\n        return sampleTexture(${t}, uv);\n      }\n    `;return`\n    float ${n}(int index) {\n      vec2 uv = uvFromFlat(${r}, ${a}, index + ${i});\n      return sampleTexture(${t}, uv);\n    }\n  `}(e);case 2:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e.shapeInfo.texShape;if(null!=r&&d(t,r)){const e=r[0],t=r[1];return`\n    float ${s}(int row, int col) {\n      vec2 uv = (vec2(col, row) + halfCR) / vec2(${t}.0, ${e}.0);\n      return sampleTexture(${n}, uv);\n    }\n  `}const{newShape:a,keptDims:i}=w(t),o=a;if(o.length<t.length){const t=hI(e,o),n=["row","col"];return`\n      ${tI(t)}\n      float ${s}(int row, int col) {\n        return ${s}(${pI(n,i)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col) {\n        int index = round(dot(vec2(row, col), vec2(${t[1]}, 1)));\n        ${uI(e)}\n      }\n    `;const l=r[0],u=r[1],c=lI(n);if(1===u)return`\n    float ${s}(int row, int col) {\n      float index = dot(vec3(row, col, ${c}), vec3(${t[1]}, 1, 1));\n      vec2 uv = vec2(0.5, (index + 0.5) / ${l}.0);\n      return sampleTexture(${n}, uv);\n    }\n  `;if(1===l)return`\n    float ${s}(int row, int col) {\n      float index = dot(vec3(row, col, ${c}), vec3(${t[1]}, 1, 1));\n      vec2 uv = vec2((index + 0.5) / ${u}.0, 0.5);\n      return sampleTexture(${n}, uv);\n    }\n  `;return`\n  float ${s}(int row, int col) {\n    // Explicitly use integer operations as dot() only works on floats.\n    int index = row * ${t[1]} + col + ${c};\n    vec2 uv = uvFromFlat(${l}, ${u}, index);\n    return sampleTexture(${n}, uv);\n  }\n`}(e);case 3:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t[1]*t[2],a=t[2],{newShape:i,keptDims:o}=w(t),l=i;if(l.length<t.length){const t=hI(e,l),n=["row","col","depth"];return`\n        ${tI(t)}\n        float ${s}(int row, int col, int depth) {\n          return ${s}(${pI(n,o)});\n        }\n      `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth) {\n        int index = round(dot(vec3(row, col, depth),\n                          vec3(${r}, ${a}, 1)));\n        ${uI(e)}\n      }\n    `;const u=e.shapeInfo.texShape,c=u[0],h=u[1],p=e.shapeInfo.flatOffset;if(h===r&&null==p)return`\n        float ${s}(int row, int col, int depth) {\n          float texR = float(row);\n          float texC = dot(vec2(col, depth), vec2(${a}, 1));\n          vec2 uv = (vec2(texC, texR) + halfCR) /\n                     vec2(${h}.0, ${c}.0);\n          return sampleTexture(${n}, uv);\n        }\n      `;if(h===a&&null==p)return`\n    float ${s}(int row, int col, int depth) {\n      float texR = dot(vec2(row, col), vec2(${t[1]}, 1));\n      float texC = float(depth);\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${h}.0, ${c}.0);\n      return sampleTexture(${n}, uv);\n    }\n  `;const d=lI(n);return`\n      float ${s}(int row, int col, int depth) {\n        // Explicitly use integer operations as dot() only works on floats.\n        int index = row * ${r} + col * ${a} + depth + ${d};\n        vec2 uv = uvFromFlat(${c}, ${h}, index);\n        return sampleTexture(${n}, uv);\n      }\n  `}(e);case 4:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t[3],a=t[2]*r,i=t[1]*a,{newShape:o,keptDims:l}=w(t);if(o.length<t.length){const t=hI(e,o),n=["row","col","depth","depth2"];return`\n      ${tI(t)}\n      float ${s}(int row, int col, int depth, int depth2) {\n        return ${s}(${pI(n,l)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth, int depth2) {\n        int index = round(dot(vec4(row, col, depth, depth2),\n                          vec4(${i}, ${a}, ${r}, 1)));\n        ${uI(e)}\n      }\n    `;const u=e.shapeInfo.flatOffset,c=e.shapeInfo.texShape,h=c[0],p=c[1];if(p===i&&null==u)return`\n      float ${s}(int row, int col, int depth, int depth2) {\n        float texR = float(row);\n        float texC =\n            dot(vec3(col, depth, depth2),\n                vec3(${a}, ${r}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${p}.0, ${h}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(p===r&&null==u)return`\n      float ${s}(int row, int col, int depth, int depth2) {\n        float texR = dot(vec3(row, col, depth),\n                         vec3(${t[1]*t[2]}, ${t[2]}, 1));\n        float texC = float(depth2);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${p}.0, ${h}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const d=lI(n);return`\n    float ${s}(int row, int col, int depth, int depth2) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${i} + col * ${a} +\n          depth * ${r} + depth2;\n      vec2 uv = uvFromFlat(${h}, ${p}, index + ${d});\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);case 5:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t[4],a=t[3]*r,i=t[2]*a,o=t[1]*i,{newShape:l,keptDims:u}=w(t);if(l.length<t.length){const t=hI(e,l),n=["row","col","depth","depth2","depth3"];return`\n      ${tI(t)}\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        return ${s}(${pI(n,u)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        float index = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${o}, ${i}, ${a}, ${r})) +\n          depth3;\n        ${uI(e)}\n      }\n    `;const c=e.shapeInfo.flatOffset,h=e.shapeInfo.texShape,p=h[0],d=h[1];if(d===o&&null==c)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n                         vec4(${i}, ${a}, ${r}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${d}.0, ${p}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(d===r&&null==c)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        float texR = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]},\n               ${t[2]*t[3]}, ${t[3]}, 1));\n        int texC = depth3;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${d}.0, ${p}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const f=lI(n);return`\n    float ${s}(int row, int col, int depth, int depth2, int depth3) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${o} + col * ${i} + depth * ${a} +\n          depth2 * ${r} + depth3 + ${f};\n      vec2 uv = uvFromFlat(${p}, ${d}, index);\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);case 6:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),{newShape:r,keptDims:a}=w(t);if(r.length<t.length){const t=hI(e,r),n=["row","col","depth","depth2","depth3","depth4"];return`\n      ${tI(t)}\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        return ${s}(${pI(n,a)});\n      }\n    `}const i=t[5],o=t[4]*i,l=t[3]*o,u=t[2]*l,c=t[1]*u;if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n        int index = round(dot(\n          vec4(row, col, depth, depth2),\n          vec4(${c}, ${u}, ${l}, ${o})) +\n          dot(\n            vec2(depth3, depth4),\n            vec2(${i}, 1)));\n        ${uI(e)}\n      }\n    `;const h=e.shapeInfo.flatOffset,p=e.shapeInfo.texShape,d=p[0],f=p[1];if(f===c&&null==h)return`\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n          vec4(${u}, ${l}, ${o}, ${i})) +\n               float(depth4);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${f}.0, ${d}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(f===i&&null==h)return`\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        float texR = dot(vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]*t[4]},\n               ${t[2]*t[3]*t[4]},\n               ${t[3]*t[4]},\n               ${t[4]})) + float(depth3);\n        int texC = depth4;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${f}.0, ${d}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const m=lI(n);return`\n    float ${s}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${c} + col * ${u} + depth * ${l} +\n          depth2 * ${o} + depth3 * ${i} + depth4 + ${m};\n      vec2 uv = uvFromFlat(${d}, ${f}, index);\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);default:throw new Error(t.length+"-D input sampling is not yet supported")}}function nI(e){switch(e.shapeInfo.logicalShape.length){case 0:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1),s=FN();return`\n    vec4 ${n}() {\n      return ${s.texture2D}(${t}, halfCR);\n    }\n  `}(e);case 1:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1),s=e.shapeInfo.texShape,r=[Math.ceil(s[0]/2),Math.ceil(s[1]/2)],a=FN();return`\n    vec4 ${n}(int index) {\n      vec2 uv = packedUVfrom1D(\n        ${r[0]}, ${r[1]}, index);\n      return ${a.texture2D}(${t}, uv);\n    }\n  `}(e);case 2:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e.shapeInfo.texShape,a=r[0],i=r[1],o=FN();if(null!=r&&d(t,r))return`\n      vec4 ${s}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${i}.0, ${a}.0);\n\n        return ${o.texture2D}(${n}, uv);\n      }\n    `;const l=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)],u=Math.ceil(t[1]/2);return`\n    vec4 ${s}(int row, int col) {\n      vec2 uv = packedUVfrom2D(${u}, ${l[0]}, ${l[1]}, row, col);\n      return ${o.texture2D}(${n}, uv);\n    }\n  `}(e);case 3:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e.shapeInfo.texShape,a=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)];if(1===t[0]){const n=t.slice(1),r=[1,2],a=hI(e,n),i=["b","row","col"];return`\n        ${nI(a)}\n        vec4 ${s}(int b, int row, int col) {\n          return ${s}(${pI(i,r)});\n        }\n      `}const i=a[0],o=a[1],l=Math.ceil(t[2]/2),u=l*Math.ceil(t[1]/2),c=FN();return`\n    vec4 ${s}(int b, int row, int col) {\n      vec2 uv = packedUVfrom3D(\n        ${i}, ${o}, ${u}, ${l}, b, row, col);\n      return ${c.texture2D}(${n}, uv);\n    }\n  `}(e);default:return function(e){const t=e.shapeInfo.logicalShape,n=t.length,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=e.shapeInfo.texShape,i=[Math.ceil(a[0]/2),Math.ceil(a[1]/2)],o=i[0],l=i[1],u=Math.ceil(t[n-1]/2);let c=u*Math.ceil(t[n-2]/2),h="int b, int row, int col",p=`b * ${c} + (row / 2) * ${u} + (col / 2)`;for(let e=2;e<n-1;e++)h=`int b${e}, `+h,c*=t[n-e-1],p=`b${e} * ${c} + `+p;const d=FN();return`\n    vec4 ${r}(${h}) {\n      int index = ${p};\n      int texR = index / ${l};\n      int texC = index - texR * ${l};\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${l}, ${o});\n      return ${d.texture2D}(${s}, uv);\n    }\n  `}(e)}}const sI="\nvec2 uvFromFlat(int texNumR, int texNumC, int index) {\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\nvec2 packedUVfrom1D(int texNumR, int texNumC, int index) {\n  int texelIndex = index / 2;\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",rI="\nvec2 packedUVfrom2D(int texelsInLogicalRow, int texNumR,\n  int texNumC, int row, int col) {\n  int texelIndex = (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",aI="\nvec2 packedUVfrom3D(int texNumR, int texNumC,\n    int texelsInBatch, int texelsInLogicalRow, int b,\n    int row, int col) {\n  int index = b * texelsInBatch + (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",iI="\n  float getChannel(vec4 frag, vec2 innerDims) {\n    vec2 modCoord = mod(innerDims, 2.);\n    return modCoord.x == 0. ?\n      (modCoord.y == 0. ? frag.r : frag.g) :\n      (modCoord.y == 0. ? frag.b : frag.a);\n  }\n  float getChannel(vec4 frag, int dim) {\n    float modCoord = mod(float(dim), 2.);\n    return modCoord == 0. ? frag.r : frag.g;\n  }\n";function oI(){return"\n    int getOutputCoords() {\n      return 0;\n    }\n  "}function lI(e){return"offset"+e}function uI(e){const t=e.name,n=p(e.shapeInfo.logicalShape);return n<2?`return ${t};`:`\n    for (int i = 0; i < ${n}; i++) {\n      if (i == index) {\n        return ${t}[i];\n      }\n    }\n  `}function cI(e){if(e<=1)return"int";if(2===e)return"ivec2";if(3===e)return"ivec3";if(4===e)return"ivec4";if(5===e)return"ivec5";if(6===e)return"ivec6";throw Error(`GPU for rank ${e} is not yet supported`)}function hI(e,t){const n=JSON.parse(JSON.stringify(e));return n.shapeInfo.logicalShape=t,n}function pI(e,t){return t.map(t=>e[t]).join(", ")}function dI(e,t){if(e.length!==t.length)throw Error(`Binary was compiled with ${e.length} inputs, but was executed with ${t.length} inputs`);e.forEach((e,n)=>{const s=e.logicalShape,r=t[n],a=r.shape;if(!d(s,a))throw Error(`Binary was compiled with different shapes than the current args. Shapes ${s} and ${a} must match`);if(e.isUniform&&r.isUniform)return;const i=e.texShape,o=r.isUniform?null:r.texData.texShape;if(!d(i,o))throw Error(`Binary was compiled with different texture shapes than the current args. Shape ${i} and ${o} must match`)})}const{addImpl:fI,bincountImpl:mI,bincountReduceImpl:gI,ceilImpl:yI,concatImpl:bI,expImpl:xI,expm1Impl:wI,floorImpl:kI,gatherV2Impl:vI,greaterImpl:NI,lessImpl:II,linSpaceImpl:CI,logImpl:SI,maxImpl:TI,maximumImpl:EI,minimumImpl:$I,multiplyImpl:AI,negImpl:RI,prodImpl:FI,rangeImpl:DI,rsqrtImpl:_I,simpleAbsImpl:OI,sliceImpl:MI,stridedSliceImpl:LI,subImpl:zI,tileImpl:BI,topKImpl:PI,transposeImpl:WI,uniqueImpl:VI}=jx;function UI(e,t){return["x","y","z","w","u","v"].slice(0,t).map(t=>`${e}.${t}`)}function GI(e,t){return 1===t?[e]:UI(e,t)}class HI{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outputShape=e;const t=e.length;if(0===t)this.userCode="\n        void main() {\n          setOutput(vec4(getA(), 0., 0., 0.));\n        }\n      ";else{const n=GI("rc",t),s=cI(t),r=function(e,t,n){if(1===e)return"rc > "+t[0];let s="";for(let r=e-2;r<e;r++)s+=`${n[r]} >= ${t[r]}`,r<e-1&&(s+="||");return s}(t,e,n),a=function(e,t,n,s){if(1===e)return"";const r=s.slice(-2);return`\n    int r = ${r[0]};\n    int c = ${r[1]};\n    int rp1 = r + 1;\n    int cp1 = c + 1;\n\n    bool cEdge = cp1 >= ${t};\n    bool rEdge = rp1 >= ${n};\n  `}(t,e[e.length-1],e[e.length-2],n),i=function(e,t){const n=e.length,s=function(e,t){const n=[];for(let s=0;s<=1;s++)for(let r=0;r<=1;r++){let a=`${0===s?"r":"rp1"}, ${0===r?"c":"cp1"}`;for(let n=2;n<e;n++)a=t[t.length-1-n]+","+a;n.push(a)}return n}(n,t);if(1===n)return`getA(rc),\n            rc + 1 >= ${e[0]} ? 0. : getA(rc + 1),\n            0, 0`;return`getA(${s[0]}),\n          cEdge ? 0. : getA(${s[1]}),\n          rEdge ? 0. : getA(${s[2]}),\n          rEdge || cEdge ? 0. : getA(${s[3]})`}(e,n);this.userCode=`\n        void main() {\n          ${s} rc = getOutputCoords();\n\n          if(${r}) {\n            setOutput(vec4(0));\n          } else {\n            ${a}\n\n            setOutput(vec4(${i}));\n          }\n        }\n      `}}}class jI{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e;let n="";for(let e=0;e<4;e++){let t="thisRC = rc;";e%2==1&&(t+="thisRC.z += 1;"),e>1&&(t+="thisRC.y += 1;"),n+=`\n        ${t}\n        ${e>0?"if(thisRC.y < rows && thisRC.z < cols){":""}\n          int flatIndex = getFlatIndex(thisRC);\n\n          ivec3 inputRC = inputCoordsFromReshapedOutCoords(flatIndex);\n          vec2 inputRCInnerDims = vec2(float(inputRC.y),float(inputRC.z));\n\n          result[${e}] =\n            getChannel(getA(inputRC.x, inputRC.y, inputRC.z), inputRCInnerDims);\n        ${e>0?"}":""}\n      `}var s;this.userCode=`\n      ${s=t,`\n    ivec3 inputCoordsFromReshapedOutCoords(int index) {\n      ${DN(["r","c","d"],s)}\n      return ivec3(r, c, d);\n    }\n  `}\n      ${_N(e)}\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n\n        vec4 result = vec4(0.);\n\n        ivec3 thisRC;\n        int rows = ${e[1]};\n        int cols = ${e[2]};\n\n        ${n}\n\n        setOutput(result);\n      }\n    `}}class qI{constructor(e){this.gpgpu=e,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0,this.freeTextures={},this.logEnabled=!1,this.usedTextures={}}acquireTexture(e,t,n){const s=XI(t,n),r=YI(e,s,n);r in this.freeTextures||(this.freeTextures[r]=[]),r in this.usedTextures||(this.usedTextures[r]=[]);const a=KI(e,s,this.gpgpu.gl,this.gpgpu.textureConfig,n);if(this.freeTextures[r].length>0){this.numFreeTextures--,this.numUsedTextures++,this._numBytesFree-=a,this.log();const e=this.freeTextures[r].shift();return this.usedTextures[r].push(e),e}let i;return s===tN.PACKED_2X2_FLOAT32?i=this.gpgpu.createPackedMatrixTexture(e[0],e[1]):s===tN.PACKED_2X2_FLOAT16?i=this.gpgpu.createFloat16PackedMatrixTexture(e[0],e[1]):s===tN.UNPACKED_FLOAT32?i=this.gpgpu.createFloat32MatrixTexture(e[0],e[1]):s===tN.UNPACKED_FLOAT16?i=this.gpgpu.createFloat16MatrixTexture(e[0],e[1]):s===tN.PACKED_4X1_UNSIGNED_BYTE&&(i=this.gpgpu.createUnsignedBytesMatrixTexture(e[0],e[1])),this.usedTextures[r].push(i),this.numUsedTextures++,this._numBytesAllocated+=a,this.log(),i}releaseTexture(e,t,n,s){if(null==this.freeTextures)return;const r=XI(n,s),a=YI(t,r,s);a in this.freeTextures||(this.freeTextures[a]=[]);const i=KI(t,r,this.gpgpu.gl,this.gpgpu.textureConfig,s),o=H().get("WEBGL_DELETE_TEXTURE_THRESHOLD");-1!==o&&this._numBytesAllocated>o?(this.gpgpu.deleteMatrixTexture(e),this._numBytesAllocated-=i):(this.freeTextures[a].push(e),this.numFreeTextures++,this._numBytesFree+=i),this.numUsedTextures--;const l=this.usedTextures[a],u=l.indexOf(e);if(u<0)throw new Error("Cannot release a texture that was never provided by this texture manager");l.splice(u,1),this.log()}log(){if(!this.logEnabled)return;const e=this.numFreeTextures+this.numUsedTextures;console.log("Free/Used",`${this.numFreeTextures} / ${this.numUsedTextures}`,`(${e})`);const t=this._numBytesFree/this._numBytesAllocated;console.log("Bytes allocated: "+this._numBytesAllocated),console.log(`Bytes unused: ${this._numBytesFree} (${Math.round(100*t)}%)`)}get numBytesAllocated(){return this._numBytesAllocated}get numBytesFree(){return this._numBytesFree}getNumUsedTextures(){return this.numUsedTextures}getNumFreeTextures(){return this.numFreeTextures}dispose(){if(null!=this.freeTextures){for(const e in this.freeTextures)this.freeTextures[e].forEach(e=>{this.gpgpu.deleteMatrixTexture(e)});for(const e in this.usedTextures)this.usedTextures[e].forEach(e=>{this.gpgpu.deleteMatrixTexture(e)});this.freeTextures=null,this.usedTextures=null,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0}}}function KI(e,t,n,s,r){const a=function(e,t){switch(e){case tN.PACKED_2X2_FLOAT32:return XN(t);case tN.PACKED_2X2_FLOAT16:return YN(t);case tN.UNPACKED_FLOAT32:return jN(t);case tN.UNPACKED_FLOAT16:return qN(t);case tN.PACKED_4X1_UNSIGNED_BYTE:return KN(t);default:throw new Error("Unknown physical texture type "+e)}}(t,s);let i;if(r){const[t,n]=rN(e[0],e[1]);i=t*n}else{const[t,n]=nN(e[0],e[1]);i=t*n}return i*function(e,t){const n=e;if(t===n.R32F)return 4;if(t===n.R16F)return 2;if(t===n.RGBA32F)return 16;if(t===e.RGBA)return 16;if(t===n.RGBA16F)return 8;throw new Error("Unknown internal format "+t)}(n,a)}function XI(e,t){if(e===eN.UPLOAD)return tN.PACKED_2X2_FLOAT32;if(e===eN.RENDER||null==e)return function(e){return H().getBool("WEBGL_RENDER_FLOAT32_ENABLED")?e?tN.PACKED_2X2_FLOAT32:tN.UNPACKED_FLOAT32:e?tN.PACKED_2X2_FLOAT16:tN.UNPACKED_FLOAT16}(t);if(e===eN.DOWNLOAD||e===eN.PIXELS)return tN.PACKED_4X1_UNSIGNED_BYTE;throw new Error("Unknown logical texture type "+e)}function YI(e,t,n){return`${e[0]}_${e[1]}_${t}_${n}`}class JI{constructor(e,t){this.variableNames=["A"],this.outputShape=e,this.userCode=`\n      float unaryOperation(float x) {\n        ${t}\n      }\n\n      void main() {\n        float x = getAAtOutCoords();\n        float y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}const ZI="return abs(x);";const QI="return x;";class eC{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.userCode=`\n      vec4 unaryOperation(vec4 x) {\n        ${t}\n      }\n\n      void main() {\n        vec4 x = getAAtOutCoords();\n        vec4 y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}class tC{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outputShape=e;const t=e.length,n=GI("rc",t),s=cI(t),r=function(e,t){if(1===e)return"rc";let n="";for(let s=0;s<e;s++)n+=t[s],s<e-1&&(n+=",");return n}(t,n),a=n.slice(-2),i=t<=1?"rc":`vec2(${a.join(",")})`;this.userCode=`\n      void main() {\n        ${s} rc = getOutputCoords();\n        vec4 packedInput = getA(${r});\n\n        setOutput(getChannel(packedInput, ${i}));\n      }\n    `}}const nC=no,sC={};class rC extends n{constructor(e){if(super(),this.pendingRead=new WeakMap,this.pendingDisposal=new WeakSet,this.dataRefCount=new WeakMap,this.numBytesInGPU=0,this.uploadWaitMs=0,this.downloadWaitMs=0,this.warnedAboutMemory=!1,this.warnedAboutCPUBackend=!1,this.pendingDeletes=0,this.disposed=!1,!H().getBool("HAS_WEBGL"))throw new Error("WebGL is not supported on this device");if(null==e){const e=Zv(H().getNumber("WEBGL_VERSION"));this.binaryCache=((n=H().getNumber("WEBGL_VERSION"))in sC||(sC[n]={}),sC[n]),this.gpgpu=new ZN(e),this.canvas=e.canvas,this.gpgpuCreatedLocally=!0}else this.gpgpu=e,this.binaryCache={},this.gpgpuCreatedLocally=!1,this.canvas=e.gl.canvas;var n;this.textureManager=new qI(this.gpgpu),this.numMBBeforeWarning=null==H().global.screen?1024:H().global.screen.height*H().global.screen.width*window.devicePixelRatio*600/1024/1024,this.texData=new t(this,ns())}numDataIds(){return this.texData.numDataIds()+(this.cpuBackend?this.cpuBackend.numDataIds():0)-this.pendingDeletes}write(e,t,n){if((H().getBool("WEBGL_CHECK_NUMERICAL_PROBLEMS")||H().getBool("DEBUG"))&&this.checkNumericalProblems(e),"complex64"===n&&null!=e)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");const s={};return this.texData.set(s,{shape:t,dtype:n,values:e,usage:eN.UPLOAD,refCount:1,complexParentRefCount:0}),s}incRef(e){this.texData.get(e).refCount++}decRef(e){if(this.texData.has(e)){this.texData.get(e).refCount--}}decComplexRef(e){if(this.texData.has(e)){const t=this.texData.get(e);t.complexParentRefCount>0&&t.refCount--}}move(e,t,n,s){if(H().getBool("DEBUG")&&this.checkNumericalProblems(t),"complex64"===s)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");this.texData.set(e,{shape:n,dtype:s,values:t,usage:eN.UPLOAD,refCount:1,complexParentRefCount:0})}disposeIntermediateTensorInfo(e){const t=e.dataId;if(this.texData.has(t)){const e=this.texData.get(t);e.refCount--,e.refCount<1&&this.disposeData(t)}}readSync(e){const t=this.texData.get(e),{values:n,dtype:s,complexTensorInfos:r,slice:a,shape:i,isPacked:o}=t;if(null!=a){let t;t=o?new eC(i,QI):new JI(i,QI);const n=this.runWebGLProgram(t,[{dataId:e,shape:i,dtype:s}],s),r=this.readSync(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=n)return this.convertAndCacheOnCPU(e);if("string"===s)return n;const l=null!=this.activeTimers;let u,c;if(l&&(u=ge()),"complex64"===s){c=Bl(this.readSync(r.real.dataId),this.readSync(r.imag.dataId))}else c=this.getValuesFromTexture(e);return l&&(this.downloadWaitMs+=ge()-u),this.convertAndCacheOnCPU(e,c)}async read(e){if(this.pendingRead.has(e)){const t=this.pendingRead.get(e);return new Promise(e=>t.push(e))}const t=this.texData.get(e),{values:n,shape:s,slice:r,dtype:a,complexTensorInfos:i,isPacked:o}=t;if(null!=r){let t;t=o?new eC(s,QI):new JI(s,QI);const n=this.runWebGLProgram(t,[{dataId:e,shape:s,dtype:a}],a),r=this.read(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=n)return this.convertAndCacheOnCPU(e);if(!H().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")&&2===H().getNumber("WEBGL_VERSION"))throw new Error("tensor.data() with WEBGL_DOWNLOAD_FLOAT_ENABLED=false and WEBGL_VERSION=2 not yet supported.");let l,u,c=null;if("complex64"!==a&&H().get("WEBGL_BUFFER_SUPPORTED")){l=this.decode(e);const t=this.texData.get(l.dataId);c=this.gpgpu.createBufferFromTexture(t.texture,...sN(s))}if(this.pendingRead.set(e,[]),"complex64"!==a&&await this.gpgpu.createAndWaitForFence(),"complex64"===a){const e=await Promise.all([this.read(i.real.dataId),this.read(i.imag.dataId)]);u=Bl(e[0],e[1])}else if(null==c)u=this.getValuesFromTexture(e);else{const e=p(s);u=this.gpgpu.downloadFloat32MatrixFromBuffer(c,e)}null!=l&&this.disposeIntermediateTensorInfo(l);const h=this.convertAndCacheOnCPU(e,u),d=this.pendingRead.get(e);return this.pendingRead.delete(e),d.forEach(e=>e(h)),this.pendingDisposal.has(e)&&(this.pendingDisposal.delete(e),this.disposeData(e),this.pendingDeletes--),h}bufferSync(e){const t=this.readSync(e.dataId);let n=t;if("string"===e.dtype)try{n=t.map(e=>xe(e))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return Kt(e.shape,e.dtype,n)}checkNumericalProblems(e){if(null!=e)for(let t=0;t<e.length;t++){const n=e[t];if(!oN(n)){if(H().getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))throw Error(`The value ${n} cannot be represented with your current settings. Consider enabling float32 rendering: 'tf.env().set('WEBGL_RENDER_FLOAT32_ENABLED', true);'`);throw Error(`The value ${n} cannot be represented on this device.`)}}}getValuesFromTexture(e){const{shape:t,dtype:n,isPacked:s}=this.texData.get(e),r=p(t);if(H().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")){const n=this.decode(e),s=this.texData.get(n.dataId),a=this.gpgpu.downloadMatrixFromPackedTexture(s.texture,...sN(t)).subarray(0,r);return this.disposeIntermediateTensorInfo(n),a}const a=H().getBool("WEBGL_PACK")&&!0===s,i=a?kN(t):t,o=a?new BN(i):new zN(i),l=this.runWebGLProgram(o,[{shape:i,dtype:n,dataId:e}],"float32"),u=this.texData.get(l.dataId),c=this.gpgpu.downloadByteEncodedFloatMatrixFromOutputTexture(u.texture,u.texShape[0],u.texShape[1]).subarray(0,r);return this.disposeIntermediateTensorInfo(l),c}async time(e){const t=this.activeTimers,n=[];let s=!1;null==this.programTimersStack?(this.programTimersStack=n,s=!0):this.activeTimers.push(n),this.activeTimers=n,e();const r=h(this.activeTimers.map(e=>e.query)).filter(e=>null!=e),a=h(this.activeTimers.map(e=>e.name)).filter(e=>null!=e);this.activeTimers=t,s&&(this.programTimersStack=null);const i={uploadWaitMs:this.uploadWaitMs,downloadWaitMs:this.downloadWaitMs,kernelMs:null,wallMs:null};if(H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0){const e=await Promise.all(r);i.kernelMs=o(e),i.getExtraProfileInfo=()=>e.map((e,t)=>({name:a[t],ms:e})).map(e=>`${e.name}: ${e.ms}`).join(", ")}else i.kernelMs={error:"WebGL query timers are not supported in this environment."};return this.uploadWaitMs=0,this.downloadWaitMs=0,i}memory(){return{unreliable:!1,numBytesInGPU:this.numBytesInGPU,numBytesInGPUAllocated:this.textureManager.numBytesAllocated,numBytesInGPUFree:this.textureManager.numBytesFree}}startTimer(){return H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?this.gpgpu.beginQuery():{startMs:ge(),endMs:null}}endTimer(e){return H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?(this.gpgpu.endQuery(),e):(e.endMs=ge(),e)}async getQueryTime(e){if(H().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0)return this.gpgpu.waitForQueryAndGetTime(e);const t=e;return t.endMs-t.startMs}disposeData(e){if(this.pendingDisposal.has(e))return;if(this.pendingRead.has(e))return this.pendingDisposal.add(e),void this.pendingDeletes++;if(!this.texData.has(e))return;if(this.texData.get(e).complexParentRefCount>0)return void this.texData.get(e).refCount--;this.releaseGPUData(e);const{complexTensorInfos:t}=this.texData.get(e);null!=t&&(this.texData.get(t.real.dataId).complexParentRefCount--,this.disposeIntermediateTensorInfo(t.real),this.texData.get(t.imag.dataId).complexParentRefCount--,this.disposeIntermediateTensorInfo(t.imag)),this.texData.delete(e)}releaseGPUData(e){const{texture:t,dtype:n,texShape:s,usage:r,isPacked:a,slice:i}=this.texData.get(e),o=i&&i.origDataId||e,l=this.dataRefCount.get(o);l>1?this.dataRefCount.set(o,l-1):(this.dataRefCount.delete(o),null!=t&&(this.numBytesInGPU-=this.computeBytes(s,n),this.textureManager.releaseTexture(t,s,r,a)));const u=this.texData.get(e);u.texture=null,u.texShape=null,u.isPacked=!1,u.slice=null}getTexture(e){return this.uploadToGPU(e),this.texData.get(e).texture}getDataInfo(e){return this.texData.get(e)}getCPUBackend(){return H().getBool("WEBGL_CPU_FORWARD")?(null==this.cpuBackend&&(this.cpuBackend=ns().findBackend("cpu")),this.cpuBackend):null}shouldExecuteOnCPU(e,t=128){const n=this.getCPUBackend();return H().getBool("IS_TEST")||this.warnedAboutCPUBackend||null!=n||(console.warn("Your application contains ops that are small enough to be executed on the CPU backend, however the CPU backend cannot be found. Consider importing the CPU backend (@tensorflow/tfjs-backend-cpu) for better performance."),this.warnedAboutCPUBackend=!0),null!=n&&e.every(e=>null==this.texData.get(e.dataId).texture&&p(e.shape)<t)}getGPGPUContext(){return this.gpgpu}where(e){zl("tf.where() in webgl locks the UI thread. Call tf.whereAsync() instead");const t=e.dataSync();return nC(e.shape,t)}packedUnaryOp(e,t,n){const s=new eC(e.shape,t);return this.compileAndRun(s,[e],n)}abs(e){if(this.shouldExecuteOnCPU([e])&&"complex64"!==e.dtype){const t=OI(this.texData.get(e.dataId).values);return this.makeOutput(e.shape,e.dtype,t)}if(H().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,ZI,e.dtype);const t=new JI(e.shape,ZI);return this.compileAndRun(t,[e])}makeTensorInfo(e,t,n){let s;if("string"===t&&null!=n&&n.length>0&&$(n[0])){const r=n.map(e=>be(e));s=this.write(r,e,t)}else s=this.write(n,e,t);return this.texData.get(s).usage=null,{dataId:s,shape:e,dtype:t}}makeOutput(e,t,n){const{dataId:s}=this.makeTensorInfo(e,t,n);return ns().makeTensorFromDataId(s,e,t,this)}unpackTensor(e){const t=new tC(e.shape);return this.runWebGLProgram(t,[e],e.dtype)}packTensor(e){const t=new HI(e.shape);return this.runWebGLProgram(t,[e],e.dtype,null,!0)}packedReshape(e,t){const n=[xN(e.shape),...wN(e.shape)],s={dtype:e.dtype,shape:n,dataId:e.dataId},r=[xN(t),...wN(t)],a=new jI(r,n),i=this.runWebGLProgram(a,[s],e.dtype,null,!0);return{dataId:i.dataId,shape:t,dtype:i.dtype}}decode(e){const t=this.texData.get(e),{isPacked:n,shape:s,dtype:r}=t,a=kN(s);let i;i=n?new LN(a):new MN(a);return{dtype:r,shape:s,dataId:this.runWebGLProgram(i,[{shape:a,dtype:r,dataId:e}],r,null,!0).dataId}}runWebGLProgram(e,t,n,s,r=!1){const a=this.makeTensorInfo(e.outputShape,n),i=this.texData.get(a.dataId);if(e.packedOutput&&(i.isPacked=!0),e.outPackingScheme===Qv.DENSE){const t=sN(e.outputShape);i.texShape=t.map(e=>2*e)}if(null!=e.outTexUsage&&(i.usage=e.outTexUsage),0===p(a.shape))return i.values=k(a.dtype,0),a;const o=[],l=t.map(t=>{if("complex64"===t.dtype)throw new Error("GPGPUProgram does not support complex64 input. For complex64 dtypes, please separate the program into real and imaginary parts.");let n=this.texData.get(t.dataId);if(null==n.texture){if(!e.packedInputs&&p(t.shape)<=H().getNumber("WEBGL_SIZE_UPLOAD_UNIFORM"))return{shape:t.shape,texData:null,isUniform:!0,uniformValues:n.values};e.packedInputs&&(n.isPacked=!0,n.shape=t.shape)}else if(!!n.isPacked!=!!e.packedInputs)t=n.isPacked?this.unpackTensor(t):this.packTensor(t),o.push(t),n=this.texData.get(t.dataId);else if(n.isPacked&&!NN(n.shape,t.shape)){const e=t,s=t.shape;t.shape=n.shape,t=this.packedReshape(t,s),o.push(t),n=this.texData.get(t.dataId),e.shape=s}return this.uploadToGPU(t.dataId),{shape:t.shape,texData:n,isUniform:!1}});this.uploadToGPU(a.dataId);const u={shape:a.shape,texData:i,isUniform:!1},c=function(e,t,n){let s="";t.concat(n).forEach(e=>{const t=null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0,n=e.isUniform?"uniform":e.texData.texShape;s+=`${e.shape}_${n}_${t}`});const r=e.userCode;let a=e.constructor.name;return a+="_"+s+"_"+r,a}(e,l,u),h=this.getAndSaveBinary(c,()=>function(e,t,n,s){const r=t.userCode,a=n.map((e,n)=>{const s={logicalShape:e.shape,texShape:e.isUniform?null:e.texData.texShape,isUniform:e.isUniform,isPacked:!e.isUniform&&e.texData.isPacked,flatOffset:null};return null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0&&(s.flatOffset=e.texData.slice.flatOffset),{name:t.variableNames[n],shapeInfo:s}}),i=a.map(e=>e.shapeInfo),o={logicalShape:s.shape,texShape:s.texData.texShape,isUniform:!1,isPacked:s.texData.isPacked,flatOffset:null},l=eI(a,o,r,t.packedInputs),u=e.createProgram(l);let c=null;const h=e.getUniformLocation(u,"NAN",!1);1===H().getNumber("WEBGL_VERSION")&&(c=e.getUniformLocation(u,"INFINITY",!1));const p={};for(let n=0;n<t.variableNames.length;n++){const s=t.variableNames[n],r=!1;p[s]=e.getUniformLocation(u,s,r),p["offset"+s]=e.getUniformLocation(u,"offset"+s,r)}return{program:t,source:l,webGLProgram:u,uniformLocations:p,inShapeInfos:i,outShapeInfo:o,infLoc:c,nanLoc:h}}(this.gpgpu,e,l,u)),d=null!=this.activeTimers;let f;if(d&&(f=this.startTimer()),function(e,t,n,s,r){dI(t.inShapeInfos,n),dI([t.outShapeInfo],[s]);const a=s.texData.texture,i=s.texData.texShape;s.texData.isPacked?e.setOutputPackedMatrixTexture(a,i[0],i[1]):e.setOutputMatrixTexture(a,i[0],i[1]),e.setProgram(t.webGLProgram),1===H().getNumber("WEBGL_VERSION")&&null!==t.infLoc&&e.gl.uniform1f(t.infLoc,1/0),null!==t.nanLoc&&e.gl.uniform1f(t.nanLoc,NaN),n.forEach((n,s)=>{const r=t.program.variableNames[s],a=t.uniformLocations[r],i=t.uniformLocations["offset"+r];if(null!=a)if(n.isUniform)if(p(n.shape)<2)e.gl.uniform1f(a,n.uniformValues[0]);else{let t=n.uniformValues;t instanceof Float32Array||(t=new Float32Array(t)),e.gl.uniform1fv(a,t)}else null!=n.texData.slice&&null!=i&&e.gl.uniform1i(i,n.texData.slice.flatOffset),e.setInputMatrixTexture(n.texData.texture,a,s)}),null!=r&&r(e,t.webGLProgram),e.executeProgram()}(this.gpgpu,h,l,u,s),o.forEach(e=>this.disposeIntermediateTensorInfo(e)),d&&(f=this.endTimer(f),this.activeTimers.push({name:e.constructor.name,query:this.getQueryTime(f)})),!H().getBool("WEBGL_LAZILY_UNPACK")&&i.isPacked&&!1===r){const e=this.unpackTensor(a);return this.disposeIntermediateTensorInfo(a),e}return a}compileAndRun(e,t,n,s,r=!1){n=n||t[0].dtype;const a=this.runWebGLProgram(e,t,n,s,r);return ns().makeTensorFromDataId(a.dataId,a.shape,a.dtype)}getAndSaveBinary(e,t){return e in this.binaryCache||(this.binaryCache[e]=t()),this.binaryCache[e]}getTextureManager(){return this.textureManager}dispose(){if(!this.disposed){if(!H().getBool("IS_TEST")){Object.keys(this.binaryCache).forEach(e=>{this.gpgpu.deleteProgram(this.binaryCache[e].webGLProgram),delete this.binaryCache[e]})}this.textureManager.dispose(),null!=this.canvas&&"undefined"!=typeof HTMLCanvasElement&&this.canvas instanceof HTMLCanvasElement?this.canvas.remove():this.canvas=null,this.gpgpuCreatedLocally&&(this.gpgpu.program=null,this.gpgpu.dispose()),this.disposed=!0}}floatPrecision(){return null==this.floatPrecisionValue&&(this.floatPrecisionValue=rs(()=>{if(!H().get("WEBGL_RENDER_FLOAT32_ENABLED")){const e=H().getBool("DEBUG");H().set("DEBUG",!1);const t=this.abs(Ii(1e-8)).dataSync()[0];if(H().set("DEBUG",e),t>0)return 32}return 16})),this.floatPrecisionValue}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}uploadToGPU(e){const t=this.texData.get(e),{shape:n,dtype:s,values:r,texture:a,usage:o,isPacked:l}=t;if(null!=a)return;const u=null!=this.activeTimers;let c;u&&(c=ge());let h=t.texShape;if(null==h&&(h=function(e,t=!1){let n=H().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(t&&(n*=2,1===(e=e.map((t,n)=>n>=e.length-2?i(e[n]):e[n])).length&&(e=[2,e[0]])),2!==e.length){const t=w(e);e=t.newShape}let s=p(e);if(e.length<=1&&s<=n)return[1,s];if(2===e.length&&e[0]<=n&&e[1]<=n)return e;if(3===e.length&&e[0]*e[1]<=n&&e[2]<=n)return[e[0]*e[1],e[2]];if(3===e.length&&e[0]<=n&&e[1]*e[2]<=n)return[e[0],e[1]*e[2]];if(4===e.length&&e[0]*e[1]*e[2]<=n&&e[3]<=n)return[e[0]*e[1]*e[2],e[3]];if(4===e.length&&e[0]<=n&&e[1]*e[2]*e[3]<=n)return[e[0],e[1]*e[2]*e[3]];if(t){const t=xN(e);let n=2,r=2;return e.length&&([n,r]=wN(e)),s=t*(n/2)*(r/2),m(s).map(e=>2*e)}return m(s)}(n,l),t.texShape=h),null!=r){const e=kN(n);let a,i=h[1],o=h[0];const p=r instanceof Uint8Array;l?([i,o]=rN(h[0],h[1]),a=new WN(e,[o,i],p)):a=new PN(e,[o,i],p);const d=this.makeTensorInfo([o,i],s);this.texData.get(d.dataId).usage=p?eN.PIXELS:eN.UPLOAD,this.gpgpu.uploadDenseMatrixToTexture(this.getTexture(d.dataId),i,o,r);const f=!0,m=this.runWebGLProgram(a,[d],s,null,f),g=this.texData.get(m.dataId);t.texture=g.texture,t.texShape=g.texShape,t.isPacked=g.isPacked,t.usage=g.usage,this.disposeIntermediateTensorInfo(d),this.texData.delete(m.dataId),t.values=null,u&&(this.uploadWaitMs+=ge()-c)}else{const e=this.acquireTexture(h,o,s,l);t.texture=e}}convertAndCacheOnCPU(e,t){const n=this.texData.get(e),{dtype:s}=n;return this.releaseGPUData(e),null!=t&&(n.values=function(e,t){if("float32"===t||"complex64"===t)return e;if("int32"===t||"bool"===t){const n="int32"===t?new Int32Array(e.length):new Uint8Array(e.length);for(let t=0;t<n.length;++t)n[t]=Math.round(e[t]);return n}throw new Error("Unknown dtype "+t)}(t,s)),n.values}acquireTexture(e,t,n,s){if(this.numBytesInGPU+=this.computeBytes(e,n),!this.warnedAboutMemory&&this.numBytesInGPU>1024*this.numMBBeforeWarning*1024){const e=(this.numBytesInGPU/1024/1024).toFixed(2);this.warnedAboutMemory=!0,console.warn(`High memory usage in GPU: ${e} MB, most likely due to a memory leak`)}return this.textureManager.acquireTexture(e,t,s)}computeBytes(e,t){return e[0]*e[1]*T(t)}}tt()&&ls("webgl",()=>new rC,2);class aC{constructor(e,t,n){this.variableNames=["A","B"],this.outputShape=Ir(t,n),this.userCode=`\n      float binaryOperation(float a, float b) {\n        ${e}\n      }\n\n      void main() {\n        float a = getAAtOutCoords();\n        float b = getBAtOutCoords();\n        setOutput(binaryOperation(a, b));\n      }\n    `}}class iC{constructor(e,t,n,s=!1){this.variableNames=["A","B"],this.supportsBroadcasting=!0,this.packedInputs=!0,this.packedOutput=!0,this.outputShape=Ir(t,n);const r=this.outputShape.length;let a="";if(s)if(0===r||1===p(this.outputShape))a="\n          result.y = 0.;\n          result.z = 0.;\n          result.w = 0.;\n        ";else{if(a=`\n          ${cI(r)} coords = getOutputCoords();\n        `,1===r)a+=`\n            result.y = (coords + 1) >= ${this.outputShape[0]} ? 0. : result.y;\n            result.z = 0.;\n            result.w = 0.;\n          `;else{const e=GI("coords",r);a+=`\n            bool nextRowOutOfBounds =\n              (${e[r-2]} + 1) >= ${this.outputShape[r-2]};\n            bool nextColOutOfBounds =\n              (${e[r-1]} + 1) >= ${this.outputShape[r-1]};\n            result.y = nextColOutOfBounds ? 0. : result.y;\n            result.z = nextRowOutOfBounds ? 0. : result.z;\n            result.w = nextColOutOfBounds || nextRowOutOfBounds ? 0. : result.w;\n          `}}this.userCode=`\n      vec4 binaryOperation(vec4 a, vec4 b) {\n        ${e}\n      }\n\n      void main() {\n        vec4 a = getAAtOutCoords();\n        vec4 b = getBAtOutCoords();\n\n        vec4 result = binaryOperation(a, b);\n        ${a}\n\n        setOutput(result);\n      }\n    `}}function oC(e){const{inputs:t,backend:n}=e,{x:s}=t;return n.incRef(s.dataId),{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}const lC={kernelName:"Identity",backendName:"webgl",kernelFunc:oC};function uC(e){const{inputs:t,backend:n}=e,{real:s,imag:r}=t,a=n.makeTensorInfo(s.shape,"complex64"),i=n.texData.get(a.dataId),o=oC({inputs:{x:s},backend:n});n.texData.get(o.dataId).complexParentRefCount++;const l=oC({inputs:{x:r},backend:n});return n.texData.get(l.dataId).complexParentRefCount++,i.complexTensorInfos={real:o,imag:l},a}const cC={kernelName:"Complex",backendName:"webgl",kernelFunc:uC},hC="return (a < 0.) ? b * a : a;",pC="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const dC={kernelName:"LeakyRelu",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{alpha:a}=s,i=n.makeTensorInfo([],"float32",fe(a,"float32")),o=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new iC(pC,r.shape,i.shape):new aC(hC,r.shape,i.shape),l=n.runWebGLProgram(o,[r,i],r.dtype);return n.disposeIntermediateTensorInfo(i),l}},fC="return (a < 0.) ? b * a : a;",mC="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const gC={kernelName:"Prelu",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s,alpha:r}=t,a=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new iC(mC,s.shape,r.shape):new aC(fC,s.shape,r.shape);return n.runWebGLProgram(a,[s,r],s.dtype)}};function yC({opSnippet:e,packedOpSnippet:t,cpuKernelImpl:n,dtype:s}){return({inputs:r,backend:a})=>{const{x:i}=r,o=a,l=s||i.dtype;if(o.shouldExecuteOnCPU([i])&&null!=n){const e=o.texData.get(i.dataId),t=n(e.values,l);return o.makeTensorInfo(i.shape,l,t)}let u;return u=H().getBool("WEBGL_PACK_UNARY_OPERATIONS")&&null!=t?new eC(i.shape,t):new JI(i.shape,e),o.runWebGLProgram(u,[i],l)}}function bC({opSnippet:e,packedOpSnippet:t,checkOutOfBounds:n=!1,supportsComplex:s=!1,cpuKernelImpl:r,dtype:a}){return({inputs:i,backend:o})=>{const{a:l,b:u}=i,c=o;if(s&&"complex64"===l.dtype){const t=c.texData.get(l.dataId),n=c.texData.get(u.dataId),[s,r]=[[t.complexTensorInfos.real,n.complexTensorInfos.real],[t.complexTensorInfos.imag,n.complexTensorInfos.imag]].map(t=>{const[n,s]=t,r={dataId:n.dataId,dtype:n.dtype,shape:l.shape},a={dataId:s.dataId,dtype:s.dtype,shape:u.shape},i=new aC(e,l.shape,u.shape);return c.runWebGLProgram(i,[r,a],We(n.dtype,s.dtype))}),a=uC({inputs:{real:s,imag:r},backend:c});return c.disposeIntermediateTensorInfo(s),c.disposeIntermediateTensorInfo(r),a}const h=a||We(l.dtype,u.dtype);if(c.shouldExecuteOnCPU([l,u])&&null!=r){const e=c.texData.get(l.dataId),t=c.texData.get(u.dataId),[n,s]=r(l.shape,u.shape,e.values,t.values,h),a=c.makeTensorInfo(s,h);return c.texData.get(a.dataId).values=n,a}let p;return p=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&null!=t?new iC(t,l.shape,u.shape,n):new aC(e,l.shape,u.shape),c.runWebGLProgram(p,[l,u],h)}}function xC(e,t=!1){if("linear"===e)return"return x;";if("relu"===e)return t?"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n";if("elu"===e)return t?"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n":"return (x >= 0.0) ? x : (exp(x) - 1.0);";if("relu6"===e)return t?"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n";if("prelu"===e)return t?mC:fC;if("leakyrelu"===e)return t?pC:hC;throw new Error(`Activation ${e} has not been implemented for the WebGL backend.`)}class wC{constructor(e,t,n,s=!1,r=!1,a=!1,i=null,o=!1,l=!1){this.variableNames=["matrixA","matrixB"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=n;const u=s?e[1]:e[2],c=Math.ceil(u/2),h=s?"i * 2, rc.y":"rc.y, i * 2",p=r?"rc.z, i * 2":"i * 2, rc.z",d=s?["a.xxyy","a.zzww"]:["a.xxzz","a.yyww"],f=r?["b.xzxz","b.ywyw"]:["b.xyxy","b.zwzw"];let m="",g="";i&&(m=o?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${i}\n        }`:l?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${i}\n        }`:`vec4 activation(vec4 x) {\n          ${i}\n        }`,g="result = activation(result);");const y=a?"result += getBiasAtOutCoords();":"";a&&this.variableNames.push("bias"),o&&this.variableNames.push("preluActivationWeights"),l&&this.variableNames.push("leakyreluAlpha");let b="rc.x",x="rc.x";e[0]<t[0]?b=`int(min(float(rc.x), ${e[0]-1}.))`:t[0]<e[0]&&(x=`int(min(float(rc.x), ${t[0]-1}.))`),this.userCode=`\n      ${m}\n\n      const float sharedDimension = ${c}.0;\n\n      vec4 dot2x2ARowBCol(ivec3 rc) {\n        vec4 result = vec4(0);\n        for (int i = 0; i < ${c}; i++) {\n          int batchA = ${b};\n          int batchB = ${x};\n          vec4 a = getMatrixA(batchA, ${h});\n          vec4 b = getMatrixB(batchB, ${p});\n\n          // These swizzled products need to be separately added.\n          // See: https://github.com/tensorflow/tfjs/issues/1735\n          result += (${d[0]} * ${f[0]});\n          result += (${d[1]} * ${f[1]});\n        }\n        return result;\n      }\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n        vec4 result = dot2x2ARowBCol(rc);\n\n        ${y}\n\n        ${g}\n\n        setOutput(result);\n      }\n    `}}const kC="return areal * breal - aimag * bimag;",vC="return areal * bimag + aimag * breal;";class NC{constructor(e,t,n){this.variableNames=["AReal","AImag","BReal","BImag"],this.outputShape=Ir(t,n),this.userCode=`\n      float binaryOpComplex(\n          float areal, float aimag, float breal, float bimag) {\n        ${e}\n      }\n\n      void main() {\n        float areal = getARealAtOutCoords();\n        float aimag = getAImagAtOutCoords();\n        float breal = getBRealAtOutCoords();\n        float bimag = getBImagAtOutCoords();\n        setOutput(binaryOpComplex(areal, aimag, breal, bimag));\n      }\n    `}}const IC="return a * b;";function CC(e){const{inputs:t,backend:n}=e,{a:s,b:r}=t,a=We(s.dtype,r.dtype);if("complex64"===s.dtype){const e=n.texData.get(s.dataId),t=n.texData.get(r.dataId),a=new NC(kC,s.shape,r.shape),i=new NC(vC,s.shape,r.shape),o=[{dataId:e.complexTensorInfos.real.dataId,dtype:e.complexTensorInfos.real.dtype,shape:s.shape},{dataId:e.complexTensorInfos.imag.dataId,dtype:e.complexTensorInfos.imag.dtype,shape:s.shape},{dataId:t.complexTensorInfos.real.dataId,dtype:t.complexTensorInfos.real.dtype,shape:r.shape},{dataId:t.complexTensorInfos.imag.dataId,dtype:t.complexTensorInfos.imag.dtype,shape:r.shape}],l=n.runWebGLProgram(a,o,"float32"),u=n.runWebGLProgram(i,o,"float32"),c=uC({inputs:{real:l,imag:u},backend:n});return n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(u),c}if(n.shouldExecuteOnCPU([s,r])){const e=n.texData.get(s.dataId),t=n.texData.get(r.dataId),[i,o]=AI(s.shape,r.shape,e.values,t.values,a),l=n.makeTensorInfo(o,a);return n.texData.get(l.dataId).values=i,l}let i;return i=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new iC(IC,s.shape,r.shape):new aC(IC,s.shape,r.shape),n.runWebGLProgram(i,[s,r],a)}const SC={kernelName:"Multiply",backendName:"webgl",kernelFunc:CC};function TC(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{shape:a}=s,i=n,o=p(r.shape),u=b(a,o),c=p(u);l(o===c,()=>`The new shape (${u}) has ${c} elements and the old shape (${r.shape}) has ${o} elements. The new shape and old shape must have the same number of elements.`);const h=i.texData.get(r.dataId);return!h.isPacked||NN(r.shape,u)||null!==h.texture&&NN(h.shape,u)?(i.incRef(r.dataId),{dataId:r.dataId,shape:u,dtype:r.dtype}):function(e,t,n){const s=[xN(e.shape),...wN(e.shape)],r={dtype:e.dtype,shape:s,dataId:e.dataId},a=[xN(t),...wN(t)],i=new jI(a,s),o=n.runWebGLProgram(i,[r],e.dtype,null,!0);return{dataId:o.dataId,shape:t,dtype:o.dtype}}(r,u,i)}const EC={kernelName:"Reshape",backendName:"webgl",kernelFunc:TC};class $C{constructor(e,t){this.variableNames=["x"];const{windowSize:n,batchSize:s,inSize:r,outSize:a}=e;this.outputShape=[s,a];const i=4*Math.floor(n/4),o=n%4;let l="sumValue += dot(values, ones);";if(null!=t){const e=1/t;l=`sumValue += dot(values * ${f(e)?e.toPrecision(2):e}, ones);`}let u="";r%n>0&&(u=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return 0.0;\n        }\n      `),this.userCode=`\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${u}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${i}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${l}\n        }\n\n        int inIdx = inOffset + ${i};\n        if (${1===o}) {\n          vec4 values = vec4(getValue(batch, inIdx), 0.0, 0.0, 0.0);\n\n          ${l}\n        } else if (${2===o}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1), 0.0, 0.0);\n\n          ${l}\n        } else if (${3===o}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2), 0.0);\n\n          ${l}\n        }\n        setOutput(sumValue);\n      }\n    `}}class AC{constructor(e,t){this.variableNames=["x"];const{windowSize:n,batchSize:s,inSize:r,outSize:a}=e;this.outputShape=[s,a];let i="0.0",o="";"prod"===t?i="1.0":"min"===t?(i="1.0 / 1e-20",o="min"):"max"===t&&(i="-1.0 / 1e-20",o="max");let l=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"sum"===t?l="sumValue":"prod"===t?l="prodValue":"all"===t?l="allValue":"any"===t&&(l="anyValue");const u=4*Math.floor(n/4),c=n%4;let h=`\n      if (${"sum"===t}) {\n        sumValue += dot(values, ones);\n      } else if (${"prod"===t}) {\n        vec2 tmp = vec2(values[0], values[1]) * vec2(values[2], values[3]);\n        prodValue *= tmp[0] * tmp[1];\n      } else {\n        minMaxValue = ${o}(values, minMaxValue);\n      }\n    `,p="vec4";"all"===t?(i="1.0",h="\n        bool reducedAllValue = all(values);\n        float floatedReducedAllValue = float(reducedAllValue);\n        allValue = float(allValue >= 1.0 && floatedReducedAllValue >= 1.0);\n      ",p="bvec4"):"any"===t&&(i="0.0",h="\n        bool reducedAnyValue = any(values);\n        float floatedReducedAnyValue = float(reducedAnyValue);\n        anyValue = float(anyValue >= 1.0 || floatedReducedAnyValue >= 1.0);\n      ",p="bvec4");let d="";r%n>0&&(d=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return initializationValue;\n        }\n      `),this.userCode=`\n      const float initializationValue = ${i};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${d}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        vec4 minMaxValue = vec4(${i});\n        float prodValue = 1.0;\n        float sumValue = 0.0;\n        float allValue = 1.0;\n        float anyValue = 0.0;\n\n        for (int i = 0; i < ${u}; i += 4) {\n          int inIdx = inOffset + i;\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${h}\n        }\n\n        int inIdx = inOffset + ${u};\n        if (${1===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          ${h}\n        } else if (${2===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          ${h}\n        } else if (${3===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          ${h}\n        }\n        setOutput(${l});\n      }\n    `}}function RC(e,t,n,s){const r=function(e){const t=[];for(;0===t.length||1!==t[t.length-1].outSize;){const n=t.length?t[t.length-1].outSize:e[1],s=Al(n);t.push({inSize:n,windowSize:s,outSize:Math.ceil(n/s)})}return t}(e.shape);let a=e;for(let i=0;i<r.length;i++){const{inSize:o,windowSize:l,outSize:u}=r[i];let c,h;c="mean"===n?0===i?new $C({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u},o):new $C({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u}):new AC({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u},n),h=a,a=s.runWebGLProgram(c,[a],t),h.dataId!==e.dataId&&s.disposeIntermediateTensorInfo(h)}return a}class FC{constructor(e,t){this.variableNames=["A"];const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[t[s]];this.outputShape=n,this.rank=n.length;const s=cI(this.rank),r=function(e){const t=e.length;if(t>6)throw Error(`Transpose for rank ${t} is not yet supported`);const n=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u","resRC.v"],s=new Array(t);for(let t=0;t<e.length;t++)s[e[t]]=n[t];return s.join()}(t);this.userCode=`\n    void main() {\n      ${s} resRC = getOutputCoords();\n      setOutput(getA(${r}));\n    }\n    `}}class DC{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0;const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[t[s]];if(this.outputShape=n,this.rank=n.length,this.rank>6)throw Error(`Packed transpose for rank ${this.rank} is not yet supported.`);const s=cI(this.rank),r=UI("rc",this.rank),a=new Array(this.rank);for(let e=0;e<t.length;e++)a[t[e]]=r[e];const i=`vec2(${a.slice(-2).join()})`,o=`++${r[this.rank-1]} < ${n[this.rank-1]}`,l=`getChannel(getA(${a.join()}), ${i})`;this.userCode=`\n    void main() {\n      ${s} rc = getOutputCoords();\n      vec4 result = vec4(0.);\n      result[0] = ${l};\n      if(${o}) {\n        result[1] = ${l};\n      }\n      --${r[this.rank-1]};\n      if(++${r[this.rank-2]} < ${n[this.rank-2]}) {\n        result[2] = ${l};\n        if(${o}) {\n          result[3] = ${l};\n        }\n      }\n      setOutput(result);\n    }\n    `}}function _C(e,t,n){const s=H().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new DC(e.shape,t):new FC(e.shape,t);return n.runWebGLProgram(s,[e],e.dtype)}function OC(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;return function(e,t,n,s){const r=t,a=e.shape.length,i=x(r,e.shape);let o=i;const l=fa(o,a),u=null!=l;let c=e;u&&(c=_C(e,l,s),o=ga(o.length,a)),da("sum",o,a);const[h,d]=ha(c.shape,o);let f=h;n&&(f=pa(h,i));const m=p(d),g=TC({inputs:{x:c},attrs:{shape:[p(e.shape)/m,m]},backend:s}),y=RC(g,Ve(e.dtype),"sum",s),b=TC({inputs:{x:y},attrs:{shape:f},backend:s});return s.disposeIntermediateTensorInfo(g),s.disposeIntermediateTensorInfo(y),u&&s.disposeIntermediateTensorInfo(c),b}(r,a,i,n)}const MC={kernelName:"Sum",backendName:"webgl",kernelFunc:OC};function LC(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{perm:a}=s,i=n,o=r.shape.length,l=new Array(o);for(let e=0;e<l.length;e++)l[e]=r.shape[a[e]];let u;if(i.shouldExecuteOnCPU([r])){const e=i.texData.get(r.dataId).values,t=WI(e,r.shape,r.dtype,a,l);u=i.makeTensorInfo(l,r.dtype),i.texData.get(u.dataId).values=t}else u=_C(r,a,i);return u}const zC={kernelName:"Transpose",backendName:"webgl",kernelFunc:LC};function BC({a:e,b:t,transposeA:n,transposeB:s,backend:r,bias:a=null,preluActivationWeights:i=null,leakyreluAlpha:o=0,activation:u=null}){const c=e.shape.length,h=t.shape.length,d=n?e.shape[c-2]:e.shape[c-1],f=s?t.shape[h-1]:t.shape[h-2],m=n?e.shape[c-1]:e.shape[c-2],g=s?t.shape[h-2]:t.shape[h-1],y=e.shape.slice(0,-2),b=t.shape.slice(0,-2),x=p(y),w=p(b);l(c>=2&&h>=2&&(x===w||1===x||1===w),()=>`Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of (${y}) and (${b}).`);const k=(x>w?e.shape.slice(0,-2):t.shape.slice(0,-2)).concat([m,g]);l(d===f,()=>`Error in matMul: inner shapes (${d}) and (${f}) of Tensors with shapes ${e.shape} and ${t.shape} and transposeA=${n} and transposeB=${s} must match.`);const v=n?[x,d,m]:[x,m,d],N=s?[w,g,f]:[w,f,g],I=TC({inputs:{x:e},backend:r,attrs:{shape:v}}),C=TC({inputs:{x:t},backend:r,attrs:{shape:N}}),S=[I,C],T=Math.max(x,w),E=n?I.shape[1]:I.shape[2],$=null!=a,A=null!=i,R="leakyrelu"===u,F=null!=u?xC(u,!0):null;let D;if((1===m||1===g)&&E>1e3&&!1===($||A||R||null!=F)){let e=I,t=C;n&&(e=LC({inputs:{x:I},backend:r,attrs:{perm:[0,2,1]}}),S.push(e)),s&&(t=LC({inputs:{x:C},backend:r,attrs:{perm:[0,2,1]}}),S.push(t));const a=1===g;let i=e;1!==g&&(i=TC({inputs:{x:e},backend:r,attrs:{shape:[T,E,1]}}),S.push(i));const o=1===g?2:1;let l=t;a&&(l=TC({inputs:{x:t},backend:r,attrs:{shape:[T,1,E]}}),S.push(l));const u=CC({inputs:{a:i,b:l},backend:r});D=OC({inputs:{x:u},backend:r,attrs:{axis:o,keepDims:!0}}),S.push(u)}else{const l=We(e.dtype,t.dtype),u=new wC(v,N,[T,m,g],n,s,$,F,A,R),c=[I,C];if(null!=a&&c.push(a),A&&c.push(i),R){const e=r.makeTensorInfo([],"float32",fe(o,"float32"));c.push(e),S.push(e)}D=r.runWebGLProgram(u,c,l)}const _=TC({inputs:{x:D},backend:r,attrs:{shape:k}});S.push(D);for(const e of S)r.disposeIntermediateTensorInfo(e);return _}const PC={kernelName:"_FusedMatMul",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a,bias:i,preluActivationWeights:o}=t,{transposeA:l,transposeB:u,activation:c,leakyreluAlpha:h}=s;return BC({a:r,b:a,transposeA:l,transposeB:u,backend:n,bias:i,preluActivationWeights:o,leakyreluAlpha:h,activation:c})}};const WC={kernelName:"Abs",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;if(n.shouldExecuteOnCPU([s])&&"complex64"!==s.dtype){const e=n.texData.get(s.dataId),t=OI(e.values);return n.makeTensorInfo(s.shape,s.dtype,t)}let r;return r=H().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new eC(s.shape,"return abs(x);"):new JI(s.shape,"return abs(x);"),n.runWebGLProgram(r,[s],s.dtype)}},VC={kernelName:"Acos",backendName:"webgl",kernelFunc:yC({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return acos(x);\n"})},UC={kernelName:"Acosh",backendName:"webgl",kernelFunc:yC({opSnippet:"if (isnan(x)) return x;\n  if (x < 1.0) return NAN;\nreturn log(x + sqrt(x * x - 1.0));"})},GC="return a + b;",HC=bC({opSnippet:GC,packedOpSnippet:GC,supportsComplex:!0,cpuKernelImpl:fI}),jC={kernelName:X,backendName:"webgl",kernelFunc:HC};class qC{constructor(e,t){this.outputShape=[],this.outputShape=e,this.variableNames=t.map((e,t)=>"T"+t);const n=[];this.variableNames.forEach(e=>{n.push(`float v${e} = get${e}AtOutCoords();`)});const s=this.variableNames.map(e=>"v"+e).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        float result = ${s};\n        setOutput(result);\n      }\n    `}}class KC{constructor(e,t){this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.variableNames=t.map((e,t)=>"T"+t);const n=[];this.variableNames.forEach(e=>{n.push(`vec4 v${e} = get${e}AtOutCoords();`)});const s=this.variableNames.map(e=>"v"+e).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        vec4 result = ${s};\n        setOutput(result);\n      }\n    `}}const XC={kernelName:"AddN",backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s}=t,r=n;if(1===r.length)return oC({inputs:{x:r[0]},backend:s});if(r.length>H().get("WEBGL_MAX_TEXTURES_IN_SHADER")){const t=Math.floor(r.length/2),n=e({inputs:r.slice(0,t),backend:s}),a=e({inputs:r.slice(t),backend:s});return e({inputs:[n,a],backend:s})}const a=r.map(e=>e.dtype).reduce((e,t)=>We(e,t)),i=r.map(e=>e.shape),o=H().getBool("WEBGL_PACK")?new KC(r[0].shape,i):new qC(r[0].shape,i);return s.runWebGLProgram(o,r,a)}};const YC={kernelName:"All",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=x(a,r.shape);let u=l;const c=fa(u,o);let h=r;null!=c&&(h=LC({inputs:{x:r},backend:n,attrs:{perm:c}}),u=ga(u.length,o)),da("all",u,o);const[d,f]=ha(h.shape,u),m=TC({inputs:{x:h},backend:n,attrs:{shape:[-1,p(f)]}}),g=RC(m,m.dtype,"all",n);let y;if(i){y=TC({inputs:{x:g},backend:n,attrs:{shape:pa(d,l)}})}else y=TC({inputs:{x:g},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(h),y}};const JC={kernelName:"Any",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=x(a,r.shape);let u=l;const c=fa(u,o);let h=r;null!=c&&(h=LC({inputs:{x:r},backend:n,attrs:{perm:c}}),u=ga(u.length,o)),da("any",u,o);const[d,f]=ha(h.shape,u),m=TC({inputs:{x:h},backend:n,attrs:{shape:[-1,p(f)]}}),g=RC(m,m.dtype,"any",n);let y;if(i){y=TC({inputs:{x:g},backend:n,attrs:{shape:pa(d,l)}})}else y=TC({inputs:{x:g},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(h),y}};class ZC{constructor(e,t,n){this.variableNames=["A"];const{windowSize:s,batchSize:r,outSize:a}=e;n||this.variableNames.push("bestIndicesA"),this.outputShape=[r,a];const i="max"===t?">":"<",o=n?"inOffset + i;":"round(getBestIndicesA(batch, inOffset + i));";this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${s};\n\n        int bestIndex = inOffset;\n        float bestValue = getA(batch, bestIndex);\n\n        for (int i = 0; i < ${s}; i++) {\n          int inIdx = ${o};\n          float candidate = getA(batch, inIdx);\n          if (candidate ${i} bestValue) {\n            bestValue = candidate;\n            bestIndex = inIdx;\n          }\n        }\n        setOutput(float(bestIndex));\n      }\n    `}}class QC{constructor(e,t,n,s){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,l(e.length>2,()=>`Packed arg${n.charAt(0).toUpperCase()+n.slice(1)} supports only inputs with rank above 2.`);const r=e[e.length-1],a=Math.ceil(r/t);this.outputShape=e.slice(0,-1),a>1&&this.outputShape.push(a),s||this.variableNames.push("bestIndicesA");const i=this.outputShape,o=i.length,u=cI(o),c=GI("coords",o);let h,p;if(1===a){p=o+1;const e=cI(p);h=`\n        ${e} sourceLocR = ${e}(${c.join()}, 0);\n        ++${c[o-1]};\n        ${e} sourceLocG = ${e}(${c.join()}, 0);\n        ++${c[o-2]};\n        ${e} sourceLocA = ${e}(${c.join()}, 0);\n        --${c[o-1]};\n        ${e} sourceLocB = ${e}(${c.join()}, 0);\n        --${c[o-2]};`}else p=o,h=`\n        ${u} sourceLocR = coords;\n        ++${c[o-1]};\n        ${u} sourceLocG = coords;\n        ++${c[o-2]};\n        ${u} sourceLocA = coords;\n        --${c[o-1]};\n        ${u} sourceLocB = coords;\n        --${c[o-2]};`;const d=["x","y","z","w","u","v"].slice(0,p),f="."+d[p-1],m=d.map(e=>"int "+e),g=GI("sourceLocR",p-1).concat("inIdx.r"),y=GI("sourceLocG",p-1).concat("inIdx.g"),b=GI("sourceLocB",p-1).concat("inIdx.b"),x=GI("sourceLocA",p-1).concat("inIdx.a"),w="max"===n?"greaterThan":"lessThan",k=s?"":`\n          inIdx = round(vec4(getBestIndicesAChannel(${g.join()}),\n                             getBestIndicesAChannel(${y.join()}),\n                             getBestIndicesAChannel(${b.join()}),\n                             getBestIndicesAChannel(${x.join()})));`,v=`vec4(\n            getAChannel(${g.join()}),\n            hasNextCol ? getAChannel(${y.join()}) : 0.,\n            hasNextRow ? getAChannel(${b.join()}) : 0.,\n            hasNextRow && hasNextCol ? getAChannel(${x.join()}) : 0.)`,N=s?"":`\n      float getBestIndicesAChannel(${m.join()}) {\n        return getChannel(getBestIndicesA(${d.join()}),\n                                          vec2(${d.slice(-2).join()}));\n      }`;this.userCode=`\n      float getAChannel(${m.join()}) {\n        return getChannel(getA(${d.join()}),\n                               vec2(${d.slice(-2).join()}));\n      }\n      ${N}\n      void main() {\n        ${u} coords = getOutputCoords();\n        bool hasNextCol = ${c[o-1]} < ${i[o-1]-1};\n        bool hasNextRow = ${c[o-2]} < ${i[o-2]-1};\n        ${h}\n        ivec4 srcIdx = ivec4(sourceLocR${f}, sourceLocG${f},\n          sourceLocB${f}, sourceLocA${f}) * ${t};\n        ivec4 inIdx = srcIdx;\n        vec4 bestIndex = vec4(inIdx);\n        vec4 bestValue = ${v};\n\n        for (int i = 0; i < ${t}; i++) {\n          inIdx = srcIdx;\n          ${k}\n          vec4 candidate = ${v};\n          bvec4 nan = isnan(candidate);\n          bvec4 replace = bvec4(\n            vec4(${w}(candidate, bestValue)) * (vec4(1.0) - vec4(nan)));\n\n          bestValue = vec4(replace.x  ? candidate.x : bestValue.x,\n                           replace.y  ? candidate.y : bestValue.y,\n                           replace.z  ? candidate.z : bestValue.z,\n                           replace.w  ? candidate.w : bestValue.w);\n          bestIndex = mix(bestIndex, vec4(inIdx), vec4(replace));\n          srcIdx++;\n        }\n        setOutput(bestIndex);\n      }\n    `}}function eS(e,t,n,s){const r=[n];if(da("arg"+s.charAt(0).toUpperCase()+s.slice(1),r,t.shape.length),!H().getBool("WEBGL_PACK_REDUCE")||t.shape.length<=2){const n=[],[a,i]=ha(t.shape,r),o=p(i),l=TC({inputs:{x:t},backend:e,attrs:{shape:[-1,o]}});n.push(l);const u=function e(t,n,s,r=null){let a=n.shape[0],i=n.shape[1];null!=r&&(a=r.shape[0],i=r.shape[1]);const o=Al(i),l={windowSize:o,inSize:i,batchSize:a,outSize:Math.ceil(i/o)},u=new ZC(l,s,null==r),c=[n];null!=r&&c.push(r);const h=t.runWebGLProgram(u,c,"int32");if(1===h.shape[1])return h;const p=e(t,n,s,h);return t.disposeIntermediateTensorInfo(h),p}(e,l,s);n.push(u);const c=TC({inputs:{x:u},backend:e,attrs:{shape:a}});return n.forEach(t=>e.disposeIntermediateTensorInfo(t)),c}return function e(t,n,s,r=null){const a=null!=r?r.shape:n.shape,i=Al(a[a.length-1]),o=new QC(a,i,s,null==r),l=null==r?[n]:[n,r],u=t.runWebGLProgram(o,l,"int32");if(u.shape.length===n.shape.length){const r=e(t,n,s,u);return t.disposeIntermediateTensorInfo(u),r}return u}(e,t,s)}const tS={kernelName:"ArgMax",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;let i=x(a,r.shape);const o=fa(i,r.shape.length);let l=r;const u=[];null!=o&&(l=LC({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=ga(i.length,l.shape.length)),da("argMax",[i[0]],l.shape.length);const c=eS(n,l,i[0],"max");return u.forEach(e=>n.disposeIntermediateTensorInfo(e)),c}};const nS={kernelName:"ArgMin",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;let i=x(a,r.shape);const o=fa(i,r.shape.length);let l=r;const u=[];null!=o&&(l=LC({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=ga(i.length,l.shape.length)),da("argMin",[i[0]],l.shape.length);const c=eS(n,l,i[0],"min");return u.forEach(e=>n.disposeIntermediateTensorInfo(e)),c}},sS={kernelName:"Asin",backendName:"webgl",kernelFunc:yC({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return asin(x);\n"})},rS={kernelName:"Asinh",backendName:"webgl",kernelFunc:yC({opSnippet:"if (isnan(x)) return x;return log(x + sqrt(x * x + 1.0));"})},aS={kernelName:"Atan",backendName:"webgl",kernelFunc:yC({opSnippet:"if (isnan(x)) return x;\n  return atan(x);\n"})},iS={kernelName:"Atan2",backendName:"webgl",kernelFunc:bC({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return atan(a, b);\n",packedOpSnippet:"\n  vec4 result = atan(a, b);\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"})},oS={kernelName:"Atanh",backendName:"webgl",kernelFunc:yC({opSnippet:"if (isnan(x)) return x;\n  if ((x < -1.0) || (x > 1.0)) return NAN;\nreturn (log(1.0 + x) - log(1.0 - x)) / 2.0;"})};class lS{constructor(e,t,n,s=!1,r=!1){if(this.variableNames=["x"],"avg"===t&&n)throw new Error("Cannot compute positions for average pool.");const a=e.filterWidth,i=e.strideHeight,o=e.strideWidth,l=e.dilationHeight,u=e.dilationWidth,c=e.effectiveFilterHeight,h=e.effectiveFilterWidth,p=e.padInfo.top,d=e.padInfo.left;this.outputShape=e.outShape;const f="avg"===t,m=`((batch  * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + d`,g=`(xR * ${e.inWidth} + xC) * ${e.inChannels} + d`;let y="0.0";if(f||(y="-1.0 / 1e-20"),n){const t=">=";return void(this.userCode=`\n        const ivec2 strides = ivec2(${i}, ${o});\n        const ivec2 pads = ivec2(${p}, ${d});\n\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int batch = coords[0];\n          int d = coords[3];\n\n          ivec2 xRCCorner = coords.yz * strides - pads;\n          int xRCorner = xRCCorner.x;\n          int xCCorner = xRCCorner.y;\n\n          // max/min x(?, ?, d) to get y(yR, yC, d).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n          float avgValue = 0.0;\n\n          for (int wR = 0; wR < ${c};\n              wR += ${l}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${h};\n                wC += ${u}) {\n              int xC = xCCorner + wC;\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float value = getX(batch, xR, xC, d);\n\n              // If a min / max value has already been found, use it. If not,\n              // use the current value.\n              float currMinMaxValue = mix(\n                  value, minMaxValue, minMaxValueFound);\n              if (value ${t} currMinMaxValue) {\n                minMaxValue = value;\n                minMaxValueFound = 1.0;\n                minMaxPosition = ${s?r?m:g:`wR * ${h} + wC`};\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let b=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===t&&(b="avgValue / count");const x=4*Math.floor(a/4),w=a%4,k=`\n      if (${f}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec2 strides = ivec2(${i}, ${o});\n      const ivec2 pads = ivec2(${p}, ${d});\n      const float initializationValue = ${y};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xR, int xC, int d) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xR, xC, d);\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d = coords[3];\n\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // max/min x(?, ?, d) to get y(yR, yC, d).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${y});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wR = 0; wR < ${c};\n            wR += ${l}) {\n          int xR = xRCorner + wR;\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${x}; wC += 4) {\n            int xC = xCCorner + wC * ${u};\n\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              getValue(batch, xR, xC + 2 * ${u}, d),\n              getValue(batch, xR, xC + 3 * ${u}, d)\n            );\n\n            ${k}\n          }\n\n          int xC = xCCorner + ${x};\n          if (${1===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              initializationValue,\n              initializationValue,\n              initializationValue\n            );\n\n            ${k}\n          } else if (${2===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              initializationValue,\n              initializationValue\n            );\n\n            ${k}\n          } else if (${3===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              getValue(batch, xR, xC + 2 * ${u}, d),\n              initializationValue\n            );\n\n            ${k}\n          }\n        }\n        setOutput(${b});\n      }\n    `}}class uS{constructor(e,t,n,s=!1,r=!1){if(this.variableNames=["x"],"avg"===t&&n)throw new Error("Cannot compute positions for average pool.");const a=e.filterWidth,i=e.strideDepth,o=e.strideHeight,l=e.strideWidth,u=e.dilationDepth,c=e.dilationHeight,h=e.dilationWidth,p=e.effectiveFilterDepth,d=e.effectiveFilterHeight,f=e.effectiveFilterWidth,m=e.padInfo.front,g=e.padInfo.top,y=e.padInfo.left;this.outputShape=e.outShape;const b="avg"===t;let x="0.0";if(b||(x="-1.0 / 1e-20"),n){const t=">=";return void(this.userCode=`\n        const ivec3 strides =\n            ivec3(${i}, ${o}, ${l});\n        const ivec3 pads = ivec3(${m}, ${g}, ${y});\n\n        void main() {\n          ivec5 coords = getOutputCoords();\n          int batch = coords.x;\n          int ch = coords.u;\n\n          ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n          int xDCorner = xCorner.x;\n          int xRCorner = xCorner.y;\n          int xCCorner = xCorner.z;\n\n          // max/min x(?, ?, ?, ch) to get y(yD, yR, yC, ch).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n\n          for (int wD = 0; wD < ${p};\n              wD += ${u}) {\n            int xD = xDCorner + wD;\n\n            if (xD < 0 || xD >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int wR = 0; wR < ${d};\n                wR += ${c}) {\n              int xR = xRCorner + wR;\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int wC = 0; wC < ${f};\n                  wC += ${h}) {\n                int xC = xCCorner + wC;\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float value = getX(batch, xD, xR, xC, ch);\n\n                // If a min / max value has already been found, use it. If not,\n                // use the current value.\n                float currMinMaxValue = mix(\n                    value, minMaxValue, minMaxValueFound);\n                if (value ${t} currMinMaxValue) {\n                  minMaxValue = value;\n                  minMaxValueFound = 1.0;\n                  minMaxPosition = ${s?r?`(((batch * ${e.inDepth} + xD) * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`((xD * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`wD * ${d} * ${f} +\n                      wR * ${f} + wC`};\n                }\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let w=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===t&&(w="avgValue / count");const k=4*Math.floor(a/4),v=a%4,N=`\n      if (${b}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec3 strides =\n        ivec3(${i}, ${o}, ${l});\n      const ivec3 pads = ivec3(${m}, ${g}, ${y});\n      const float initializationValue = ${x};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xD, int xR, int xC, int ch) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xD, xR, xC, ch);\n      }\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xDCorner = xCorner.x;\n        int xRCorner = xCorner.y;\n        int xCCorner = xCorner.z;\n\n        // max/min x(?, ?, ?, d) to get y(yD, yR, yC, ch).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${x});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wD = 0; wD < ${p};\n            wD += ${u}) {\n          int xD = xDCorner + wD;\n\n          if (xD < 0 || xD >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${d};\n            wR += ${c}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${k}; wC += 4) {\n              int xC = xCCorner + wC * ${h};\n\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${h}, ch),\n                getValue(batch, xD, xR, xC + 3 * ${h}, ch)\n              );\n\n              ${N}\n            }\n\n            int xC = xCCorner + ${k};\n            if (${1===v}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                initializationValue,\n                initializationValue,\n                initializationValue\n              );\n\n              ${N}\n            } else if (${2===v}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                initializationValue,\n                initializationValue\n              );\n\n              ${N}\n            } else if (${3===v}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${h}, ch),\n                initializationValue\n              );\n\n              ${N}\n            }\n          }\n          setOutput(${w});\n        }\n      }\n    `}}const cS={kernelName:"AvgPool",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;AN(r,"avgPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:u}=s;l(zs(i,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`);const c=Es(r.shape,a,i,1,o,u);if(1===c.filterWidth&&1===c.filterHeight&&d(c.inShape,c.outShape))return oC({inputs:{x:r},backend:n});const h=new lS(c,"avg",!1);return n.runWebGLProgram(h,[r],"float32")}};const hS={kernelName:"AvgPool3D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s,c=$s(r.shape,a,i,[1,1,1],o,l,u),h=new uS(c,"avg",!1);return n.runWebGLProgram(h,[r],"float32")}};class pS{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a=e.dilationHeight,i=e.dilationWidth,o=e.effectiveFilterHeight,l=e.effectiveFilterWidth,u=o-1-e.padInfo.top,c=l-1-e.padInfo.left,h=1/(t*n);this.userCode=`\n      const ivec2 pads = ivec2(${u}, ${c});\n      const float avgMultiplier = float(${h});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${o};\n            wR += ${a}) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${l};\n            wC+= ${i}) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n\n            dotProd += dyValue * avgMultiplier;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class dS{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const t=e.filterDepth,n=e.filterHeight,s=e.filterWidth,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=e.dilationDepth,l=e.dilationHeight,u=e.dilationWidth,c=e.effectiveFilterDepth,h=e.effectiveFilterHeight,p=e.effectiveFilterWidth,d=c-1-e.padInfo.front,f=h-1-e.padInfo.top,m=p-1-e.padInfo.left,g=1/(t*n*s);this.userCode=`\n      const ivec3 pads = ivec3(${d}, ${f}, ${m});\n      const float avgMultiplier = float(${g});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, d) with pos mask(:, :, :, ch) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${c};\n            wD += ${o}) {\n          float dyD = float(dyDCorner + wD) / ${r}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${h};\n              wR += ${l}) {\n            float dyR = float(dyRCorner + wR) / ${a}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${p};\n                wC += ${u}) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n\n              dotProd += dyValue * avgMultiplier;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const fS={kernelName:"AvgPool3DGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a,{filterSize:o,strides:l,pad:u,dimRoundingMode:c}=s,h=$s(i.shape,o,l,[1,1,1],u,c),p=new dS(h);return n.runWebGLProgram(p,[r],i.dtype)}};const mS={kernelName:"AvgPoolGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a;AN([r,a],"avgPoolGrad");const{filterSize:o,strides:l,pad:u}=s,c=Es(i.shape,o,l,1,u),h=new pS(c);return n.runWebGLProgram(h,[r],i.dtype)}};const gS={kernelName:"BatchMatMul",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a}=t,{transposeA:i,transposeB:o}=s;return BC({a:r,b:a,transposeA:i,transposeB:o,backend:n})}};class yS{constructor(e,t,n,s,r,a){this.outputShape=[],this.variableNames=["x","mean","variance"],Ir(e,t),Ir(e,n);let i="0.0";null!=s&&(Ir(e,s),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let o="1.0";null!=r&&(Ir(e,r),this.variableNames.push("scale"),o="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        float x = getXAtOutCoords();\n        float mean = getMeanAtOutCoords();\n        float variance = getVarianceAtOutCoords();\n        float offset = ${i};\n        float scale = ${o};\n        float inv = scale * inversesqrt(variance + float(${a}));\n        setOutput(dot(vec3(x, -mean, offset), vec3(inv, inv, 1)));\n      }\n    `}}class bS{constructor(e,t,n,s,r,a){this.packedInputs=!0,this.packedOutput=!0,this.variableNames=["x","mean","variance"],Ir(e,t),Ir(e,n);let i="vec4(0.0)";null!=s&&(Ir(e,s),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let o="vec4(1.0)";null!=r&&(Ir(e,r),this.variableNames.push("scale"),o="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        vec4 offset = ${i};\n        vec4 scale = ${o};\n\n        vec4 x = getXAtOutCoords();\n        vec4 mean = getMeanAtOutCoords();\n        vec4 variance = getVarianceAtOutCoords();\n\n        vec4 inv = scale * inversesqrt(variance + vec4(${a}));\n\n        setOutput((x - mean) * inv + offset);\n      }\n    `}}const xS={kernelName:"FusedBatchNorm",backendName:"webgl",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,mean:r,variance:a,offset:i,scale:o}=e;l(r.shape.length===a.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),l(null==i||r.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),l(null==o||r.shape.length===o.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks.");let{varianceEpsilon:u}=n;null==u&&(u=.001);const c=[s,r,a];let h=null;null!=i&&(h=i.shape,c.push(i));let p=null;null!=o&&(p=o.shape,c.push(o));const d=H().getBool("WEBGL_PACK_NORMALIZATION")?new bS(s.shape,r.shape,a.shape,h,p,u):new yS(s.shape,r.shape,a.shape,h,p,u);return t.runWebGLProgram(d,c,c[0].dtype)}};class wS{constructor(e){this.variableNames=["source"],this.outputShape=e,this.rank=e.length;const t=cI(this.rank),n=`uniform int start[${this.rank}];`,s=function(e){if(1===e)return"sourceLoc";if(e<=6)return kS.slice(0,e).map(e=>"sourceLoc."+e).join(",");throw Error(`Slicing for rank ${e} is not yet supported`)}(this.rank);let r;r=`\n        ${t} sourceLoc;\n        ${t} coords = getOutputCoords();\n        ${e.map((e,t)=>`sourceLoc.${kS[t]} = start[${t}] + coords.${kS[t]};`).join("\n")}\n      `,this.userCode=`\n      ${n}\n      void main() {\n        ${r}\n        setOutput(getSource(${s}));\n      }\n    `}getCustomSetupFunc(e){if(e.length!==this.rank)throw Error(`The rank (${this.rank}) of the program must match the length of start (${e.length})`);return(t,n)=>{null==this.startLoc&&(this.startLoc=t.getUniformLocationNoThrow(n,"start"),null==this.startLoc)||t.gl.uniform1iv(this.startLoc,e)}}}const kS=["x","y","z","w","u","v"];class vS{constructor(e){this.variableNames=["source"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.rank=e.length;const t=cI(this.rank),n=GI("coords",this.rank),s=GI("sourceLoc",this.rank),r=1===this.rank?"sourceLoc":`vec2(${s.slice(-2).join()})`,a=`getChannel(getSource(${s.join()}), ${r})`,i=`\n      result.x = ${a};\n      if (++${n[this.rank-1]} < ${e[this.rank-1]}) {\n        ++${s[this.rank-1]};\n        result.y = ${a};\n        --${s[this.rank-1]};\n      }\n    `,o=1===this.rank?"":`\n      --${n[this.rank-1]};\n      if (++${n[this.rank-2]} < ${e[this.rank-2]}) {\n        ++${s[this.rank-2]};\n        result.z = ${a};\n        if (++${n[this.rank-1]} < ${e[this.rank-1]}) {\n          ++${s[this.rank-1]};\n          result.w = ${a};\n        }\n      }\n    `,l=this.rank<=4?`sourceLoc = coords +\n            ${t}(${e.map((e,t)=>`start[${t}]`).join()});`:e.map((e,t)=>`${s[t]} = ${n[t]} + start[${t}];`).join("\n");this.userCode=`\n      uniform int start[${this.rank}];\n      void main() {\n        ${t} coords = getOutputCoords();\n        ${t} sourceLoc;\n        ${l}\n        vec4 result = vec4(0.);\n        ${i}\n        ${o}\n        setOutput(result);\n      }\n    `}getCustomSetupFunc(e){if(e.length!==this.rank)throw Error(`The rank (${this.rank}) of the program must match the length of start (${e.length})`);return(t,n)=>{null==this.startLoc&&(this.startLoc=t.getUniformLocationNoThrow(n,"start"),null==this.startLoc)||t.gl.uniform1iv(this.startLoc,e)}}}function NS(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,size:i}=s,[o,l]=Un(r,a,i);if($n(r,o,l),0===p(l))return n.makeTensorInfo(l,r.dtype,[]);if(n.shouldExecuteOnCPU([r])||"string"===r.dtype){const e=n.texData.get(r.dataId),t=MI(e.values,o,l,r.shape,r.dtype);return n.makeTensorInfo(l,r.dtype,t)}const{isPacked:u}=n.texData.get(r.dataId),c=Wn(r.shape,o,l);if(u||!c){const e=H().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new vS(l):new wS(l),t=e.getCustomSetupFunc(o);return n.runWebGLProgram(e,[r],r.dtype,t)}return n.uploadToGPU(r.dataId),function(e,t,n,s){const r=s.texData.get(e.dataId),a=s.makeTensorInfo(n,e.dtype),i=s.texData.get(a.dataId);Object.assign(i,r),i.complexParentRefCount=0,i.refCount=1,i.shape=n,i.dtype=e.dtype;let o=Vn(t,O(e.shape));r.slice&&(o+=r.slice.flatOffset),i.slice={flatOffset:o,origDataId:r.slice&&r.slice.origDataId||e.dataId};const l=s.dataRefCount.get(i.slice.origDataId)||1;return s.dataRefCount.set(i.slice.origDataId,l+1),a}(r,o,l,n)}const IS={kernelName:"Slice",backendName:"webgl",kernelFunc:NS},CS={kernelName:"BatchToSpaceND",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,crops:i}=s;l(r.shape.length<=4,()=>"batchToSpaceND for rank > 4 with a WebGL backend not implemented yet");const o=a.reduce((e,t)=>e*t),u=Fl(r.shape,a,o),c=Dl(u.length,a.length),h=_l(r.shape,a,o),p=Ol(i,a.length),d=Ml(h,i,a.length),f=[],m=TC({inputs:{x:r},backend:n,attrs:{shape:u}}),g=LC({inputs:{x:m},backend:n,attrs:{perm:c}}),y=TC({inputs:{x:g},backend:n,attrs:{shape:h}}),b=NS({inputs:{x:y},backend:n,attrs:{begin:p,size:d}});return f.push(m),f.push(g),f.push(y),f.forEach(e=>n.disposeIntermediateTensorInfo(e)),b}};const SS={kernelName:"Bincount",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i}=s,o=n.readSync(r.dataId),l=n.readSync(a.dataId),u=mI(o,l,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,u)}},TS=bC({opSnippet:"return float(a != b);",dtype:"bool"}),ES={kernelName:"NotEqual",backendName:"webgl",kernelFunc:TS};function $S(e){const{inputs:t,backend:n}=e,{input:s}=t;return oC({inputs:{x:n.texData.get(s.dataId).complexTensorInfos.real},backend:n})}const AS={kernelName:"Real",backendName:"webgl",kernelFunc:$S};const RS={kernelName:"Cast",backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s,attrs:r}=t,{x:a}=n,{dtype:i}=r;if("complex64"===i){if("complex64"===a.dtype)return oC({inputs:{x:a},backend:s});const t=Ma(a.shape),n=e({inputs:{x:a},backend:s,attrs:{dtype:"float32"}}),r=uC({inputs:{real:n,imag:t},backend:s});return t.dispose(),s.disposeIntermediateTensorInfo(n),r}if("complex64"===a.dtype){const t=$S({inputs:{input:a},backend:s}),n=e({inputs:{x:t},backend:s,attrs:{dtype:i}});return s.disposeIntermediateTensorInfo(t),n}if(!C(a.dtype,i)){const e=oC({inputs:{x:a},backend:s});return{dataId:e.dataId,shape:e.shape,dtype:i}}if("int32"===i)return function(e,t){const n=new JI(e.shape,"return float(int(x));"),s=t.runWebGLProgram(n,[e],"int32");return{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}(a,s);if("bool"===i){const e=s.makeTensorInfo([],"bool",k("bool",1)),t=TS({inputs:{a:a,b:e},backend:s});return s.disposeIntermediateTensorInfo(e),t}throw new Error(`Error in Cast: failed to cast ${a.dtype} to ${i}`)}},FS="return ceil(x);",DS={kernelName:"Ceil",backendName:"webgl",kernelFunc:yC({opSnippet:FS,packedOpSnippet:FS,cpuKernelImpl:yI})};class _S{constructor(e){this.variableNames=["A"],this.outputShape=e,this.userCode="\n      uniform float minVal;\n      uniform float maxVal;\n\n      void main() {\n        float value = getAAtOutCoords();\n        if (isnan(value)) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, minVal, maxVal));\n      }\n    "}getCustomSetupFunc(e,t){return(n,s)=>{null==this.minLoc&&(this.minLoc=n.getUniformLocationNoThrow(s,"minVal"),this.maxLoc=n.getUniformLocationNoThrow(s,"maxVal")),n.gl.uniform1f(this.minLoc,e),n.gl.uniform1f(this.maxLoc,t)}}}class OS{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.userCode="\n      uniform float minVal;\n      uniform float maxVal;\n\n      void main() {\n        vec4 value = getAAtOutCoords();\n\n        if (any(isnan(value))) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, vec4(minVal), vec4(maxVal)));\n      }\n    "}getCustomSetupFunc(e,t){return(n,s)=>{null==this.minLoc&&(this.minLoc=n.getUniformLocationNoThrow(s,"minVal"),this.maxLoc=n.getUniformLocationNoThrow(s,"maxVal")),n.gl.uniform1f(this.minLoc,e),n.gl.uniform1f(this.maxLoc,t)}}}const MS={kernelName:"ClipByValue",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{clipValueMin:a,clipValueMax:i}=s;let o;o=H().getBool("WEBGL_PACK_CLIP")?new OS(r.shape):new _S(r.shape);const l=o.getCustomSetupFunc(a,i);return n.runWebGLProgram(o,[r],r.dtype,l)}};class LS{constructor(e){this.variableNames=["real","imag"],this.outputShape=e,this.userCode="\n      void main() {\n        float re = abs(getRealAtOutCoords());\n        float im = abs(getImagAtOutCoords());\n        float mx = max(re, im);\n\n        // sadly the length function in glsl is not underflow-safe\n        // (at least not on Intel GPUs). So the safe solution is\n        // to ensure underflow-safety in all cases.\n        setOutput(\n          mx == 0.0 ? 0.0 : mx * length(vec2(1, min(re, im)/mx))\n        );\n      }\n    "}}function zS(e,t){return{dataId:t.dataId,dtype:t.dtype,shape:e.shape}}const BS={kernelName:"ComplexAbs",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=n.texData.get(s.dataId),a=new LS(s.shape),i=[zS(s,r.complexTensorInfos.real),zS(s,r.complexTensorInfos.imag)];return n.runWebGLProgram(a,i,i[0].dtype)}};class PS{constructor(e){this.outputShape=[],this.outputShape=$l(e,1),this.variableNames=e.map((e,t)=>"T"+t);const t=new Array(e.length-1);t[0]=e[0][1];for(let n=1;n<t.length;n++)t[n]=t[n-1]+e[n][1];const n=[`if (yC < ${t[0]}) setOutput(getT0(yR, yC));`];for(let e=1;e<t.length;e++){const s=t[e-1];n.push(`else if (yC < ${t[e]}) setOutput(getT${e}(yR, yC-${s}));`)}const s=t.length,r=t[t.length-1];n.push(`else setOutput(getT${s}(yR, yC-${r}));`),this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int yR = coords.x;\n        int yC = coords.y;\n\n        ${n.join("\n        ")}\n      }\n    `}}class WS{constructor(e,t){this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[],this.outputShape=$l(e,t);const n=this.outputShape,s=n.length,r=cI(s),a=GI("coords",s),i=["x","y","z","w","u","v"].slice(0,s);this.variableNames=e.map((e,t)=>"T"+t);const o=new Array(e.length-1);o[0]=e[0][t];for(let n=1;n<o.length;n++)o[n]=o[n-1]+e[n][t];const l=i[t],u=i.slice(-2),c=i.join();let h=`if (${l} < ${o[0]}) {\n        return getChannel(\n            getT0(${c}), vec2(${u.join()}));\n        }`;for(let e=1;e<o.length;e++){const t=o[e-1];h+=`\n        if (${l} < ${o[e]}  && ${l} >= ${o[e-1]}) {\n          return getChannel(\n            getT${e}(${VS(i,l,t)}),\n            vec2(${VS(u,l,t)}));\n        }`}const p=o.length,d=o[o.length-1];h+=`\n        return getChannel(\n          getT${p}(${VS(i,l,d)}),\n          vec2(${VS(u,l,d)}));`,this.userCode=`\n      float getValue(${i.map(e=>"int "+e)}) {\n        ${h}\n      }\n\n      void main() {\n        ${r} coords = getOutputCoords();\n        vec4 result = vec4(getValue(${a}), 0., 0., 0.);\n\n        ${a[s-1]} = ${a[s-1]} + 1;\n        if (${a[s-1]} < ${n[s-1]}) {\n          result.g = getValue(${a});\n        }\n\n        ${a[s-2]} = ${a[s-2]} + 1;\n        if (${a[s-2]} < ${n[s-2]}) {\n          result.a = getValue(${a});\n        }\n\n        ${a[s-1]} = ${a[s-1]} - 1;\n        if (${a[s-2]} < ${n[s-2]} &&\n            ${a[s-1]} < ${n[s-1]}) {\n          result.b = getValue(${a});\n        }\n        setOutput(result);\n      }\n    `}}function VS(e,t,n){const s=e.indexOf(t);return e.map((e,t)=>t===s?`${e} - ${n}`:e).join()}function US(e){const{inputs:t,backend:n}=e,{input:s}=t;return oC({inputs:{x:n.texData.get(s.dataId).complexTensorInfos.imag},backend:n})}const GS={kernelName:"Imag",backendName:"webgl",kernelFunc:US};function HS(e,t,n){const s=$l(e.map(e=>e.shape),t);return{tensors2D:e.map(e=>TC({inputs:{x:e},attrs:{shape:[-1,p(e.shape.slice(t))]},backend:n})),outShape:s}}function jS(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s,a=x(r,t[0].shape)[0],i=$l(t.map(e=>e.shape),a);if(0===p(i))return n.makeTensorInfo(i,t[0].dtype,[]);const o=t.filter(e=>p(e.shape)>0);return 1===o.length?oC({inputs:{x:o[0]},backend:n}):(El(o.map(e=>e.shape),a),function e(t,n,s){const r=t[0].dtype;if("complex64"===r){const r=t.map(e=>$S({inputs:{input:e},backend:s})),a=t.map(e=>US({inputs:{input:e},backend:s})),i=e(r,n,s),o=e(a,n,s),l=uC({inputs:{real:i,imag:o},backend:s});return r.forEach(e=>s.disposeIntermediateTensorInfo(e)),a.forEach(e=>s.disposeIntermediateTensorInfo(e)),s.disposeIntermediateTensorInfo(i),s.disposeIntermediateTensorInfo(o),l}if("string"===r){const{tensors2D:e,outShape:a}=HS(t,n,s),i=e.map(e=>({vals:s.readSync(e.dataId),shape:e.shape})),o=1===e[0].shape[0],l=bI(i,a,r,o),u=$l(t.map(e=>e.shape),n),c=s.makeTensorInfo(u,r,l);return e.forEach(e=>s.disposeIntermediateTensorInfo(e)),c}if(t.length>H().getNumber("WEBGL_MAX_TEXTURES_IN_SHADER")){const r=Math.floor(t.length/2),a=e(t.slice(0,r),n,s),i=e(t.slice(r),n,s),o=e([a,i],n,s);return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}if(H().getBool("WEBGL_PACK_ARRAY_OPERATIONS")&&t[0].shape.length>1){const e=new WS(t.map(e=>e.shape),n);return s.runWebGLProgram(e,t,r)}const{tensors2D:a,outShape:i}=HS(t,n,s),o=new PS(a.map(e=>e.shape)),l=s.runWebGLProgram(o,a,r);a.forEach(e=>s.disposeIntermediateTensorInfo(e));const u=TC({inputs:{x:l},attrs:{shape:i},backend:s});return s.disposeIntermediateTensorInfo(l),u}(o,a,n))}const qS={kernelName:"Concat",backendName:"webgl",kernelFunc:jS};class KS{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const a=e.padInfo.top,i=e.padInfo.left,o=e.strideHeight,l=e.strideWidth,u=e.dilationHeight,c=e.dilationWidth,h=e.filterHeight,p=e.filterWidth,d=4*Math.floor(e.inChannels/4),f=e.inChannels%4,m="channelsLast"===e.dataFormat,g=m?1:2,y=m?2:3,b=m?3:1;let x="",w="";n&&(x=s?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,w="result = activation(result);");const k=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${x}\n\n      const ivec2 strides = ivec2(${o}, ${l});\n      const ivec2 pads = ivec2(${a}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d2 = coords[${b}];\n\n        ivec2 xRCCorner =\n            ivec2(coords[${g}], coords[${y}]) * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, d2) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${h}; wR++) {\n          int xR = xRCorner + wR * ${u};\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${p}; wC++) {\n            int xC = xCCorner + wC * ${c};\n\n            if (xC < 0 || xC >= ${e.inWidth}) {\n              continue;\n            }\n\n            for (int d1 = 0; d1 < ${d}; d1 += 4) {\n              vec4 wValues = vec4(\n                getW(wR, wC, d1, d2),\n                getW(wR, wC, d1 + 1, d2),\n                getW(wR, wC, d1 + 2, d2),\n                getW(wR, wC, d1 + 3, d2)\n              );\n\n              if (${m}) {\n                vec4 xValues = vec4(\n                  getX(batch, xR, xC, d1),\n                  getX(batch, xR, xC, d1 + 1),\n                  getX(batch, xR, xC, d1 + 2),\n                  getX(batch, xR, xC, d1 + 3)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec4 xValues = vec4(\n                  getX(batch, d1, xR, xC),\n                  getX(batch, d1 + 1, xR, xC),\n                  getX(batch, d1 + 2, xR, xC),\n                  getX(batch, d1 + 3, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n\n            if (${1===f}) {\n\n              if (${m}) {\n                dotProd +=\n                    getX(batch, xR, xC, ${d}) *\n                    getW(wR, wC, ${d}, d2);\n              } else {\n                dotProd +=\n                    getX(batch, ${d}, xR, xC) *\n                    getW(wR, wC, ${d}, d2);\n              }\n\n            } else if (${2===f}) {\n              vec2 wValues = vec2(\n                getW(wR, wC, ${d}, d2),\n                getW(wR, wC, ${d} + 1, d2)\n              );\n\n              if (${m}) {\n                vec2 xValues = vec2(\n                  getX(batch, xR, xC, ${d}),\n                  getX(batch, xR, xC, ${d} + 1)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec2 xValues = vec2(\n                  getX(batch, ${d}, xR, xC),\n                  getX(batch, ${d} + 1, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            } else if (${3===f}) {\n              vec3 wValues = vec3(\n                getW(wR, wC, ${d}, d2),\n                getW(wR, wC, ${d} + 1, d2),\n                getW(wR, wC, ${d} + 2, d2)\n              );\n\n              if (${m}) {\n                vec3 xValues = vec3(\n                  getX(batch, xR, xC, ${d}),\n                  getX(batch, xR, xC, ${d} + 1),\n                  getX(batch, xR, xC, ${d} + 2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec3 xValues = vec3(\n                  getX(batch, ${d}, xR, xC),\n                  getX(batch, ${d} + 1, xR, xC),\n                  getX(batch, ${d} + 2, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            }\n          }\n        }\n\n        float result = dotProd;\n        ${k}\n        ${w}\n        setOutput(result);\n      }\n    `}}class XS{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const t=e.padInfo.front,n=e.padInfo.top,s=e.padInfo.left,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=e.dilationDepth,l=e.dilationHeight,u=e.dilationWidth,c=e.filterDepth,h=e.filterHeight,p=e.filterWidth,d=4*Math.floor(e.inChannels/4),f=e.inChannels%4;this.userCode=`\n      const ivec3 strides = ivec3(${r}, ${a}, ${i});\n      const ivec3 pads = ivec3(${t}, ${n}, ${s});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d2 = coords.u;\n\n        ivec3 xFRCCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xFCorner = xFRCCorner.x;\n        int xRCorner = xFRCCorner.y;\n        int xCCorner = xFRCCorner.z;\n\n        // Convolve x(?, ?, ?, d1) with w(:, :, :, d1, d2) to get\n        // y(yF, yR, yC, d2). ? = to be determined. : = across all\n        // values in that axis.\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${c}; wF++) {\n          int xF = xFCorner + wF * ${o};\n\n          if (xF < 0 || xF >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${h}; wR++) {\n            int xR = xRCorner + wR * ${l};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${p}; wC++) {\n              int xC = xCCorner + wC * ${u};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              for (int d1 = 0; d1 < ${d}; d1 += 4) {\n                vec4 xValues = vec4(\n                  getX(batch, xF, xR, xC, d1),\n                  getX(batch, xF, xR, xC, d1 + 1),\n                  getX(batch, xF, xR, xC, d1 + 2),\n                  getX(batch, xF, xR, xC, d1 + 3)\n                );\n                vec4 wValues = vec4(\n                  getW(wF, wR, wC, d1, d2),\n                  getW(wF, wR, wC, d1 + 1, d2),\n                  getW(wF, wR, wC, d1 + 2, d2),\n                  getW(wF, wR, wC, d1 + 3, d2)\n                );\n\n                dotProd += dot(xValues, wValues);\n              }\n\n              if (${1===f}) {\n                dotProd +=\n                  getX(batch, xF, xR, xC, ${d}) *\n                  getW(wF, wR, wC, ${d}, d2);\n              } else if (${2===f}) {\n                vec2 xValues = vec2(\n                  getX(batch, xF, xR, xC, ${d}),\n                  getX(batch, xF, xR, xC, ${d} + 1)\n                );\n                vec2 wValues = vec2(\n                  getW(wF, wR, wC, ${d}, d2),\n                  getW(wF, wR, wC, ${d} + 1, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else if (${3===f}) {\n                vec3 xValues = vec3(\n                  getX(batch, xF, xR, xC, ${d}),\n                  getX(batch, xF, xR, xC, ${d} + 1),\n                  getX(batch, xF, xR, xC, ${d} + 2)\n                );\n                vec3 wValues = vec3(\n                  getW(wF, wR, wC, ${d}, d2),\n                  getW(wF, wR, wC, ${d} + 1, d2),\n                  getW(wF, wR, wC, ${d} + 2, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class YS{constructor(e,t,n){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e;const{filterWidth:s,inChannels:r,strideWidth:a,strideHeight:i,padInfo:o,outWidth:l,dilationWidth:u,dilationHeight:c,dataFormat:h}=n,{left:p,top:d}=o,f=r*s,m=FN(),g="channelsLast"===h,y=g?0:1,b=g?1:2;let x="";for(let n=0;n<=1;n++)for(let s=0;s<=1;s++)x+=`\n          blockIndex = rc.y + ${s};\n          pos = rc.x + ${n};\n\n          if(blockIndex < ${e[1]} && pos < ${e[0]}) {\n            offsetY = int(blockIndex / (${l})) * ${i} - ${d};\n            d0 = offsetY + ${c} * (pos / ${f});\n\n            if(d0 < ${t[y]} && d0 >= 0) {\n\n              offsetX = int(mod(float(blockIndex), ${l}.) * ${a}. - ${p}.);\n              d1 = offsetX + ${u} * (int(mod(float(pos), ${f}.) / ${r}.));\n\n              if(d1 < ${t[b]} && d1 >= 0) {\n\n                ch = int(mod(float(pos), ${r}.));\n\n                if (${g}) {\n                  innerDims = vec2(d1, ch);\n                  result[${2*n+s}] = getChannel(\n                    getA(d0, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                } else {\n                  innerDims = vec2(d0, d1);\n                  result[${2*n+s}] = getChannel(\n                    getA(ch, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                }\n              }\n            }\n          }\n        `;this.userCode=`\n      void main() {\n        ivec2 rc = getOutputCoords();\n\n        vec4 result = vec4(0);\n\n        int blockIndex, pos, offsetY, d0, offsetX, d1, ch;\n        vec2 innerDims;\n\n        ${x}\n\n        ${m.output} = result;\n      }\n    `}}function JS({x:e,filter:t,convInfo:n,backend:s,bias:r=null,preluActivationWeights:a=null,leakyreluAlpha:i=0,activation:o=null}){const u=e.shape,c=s.texData.get(e.dataId),h=n.inChannels,p=u[0]*u[1]*u[2],d=n.outChannels,f="channelsLast"===n.dataFormat;let m;const g=[],y=(1===p||1===d)&&h>1e3,b=u[2]%2!=0&&!!c.isPacked;if(!y&&H().getBool("WEBGL_LAZILY_UNPACK")&&H().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&b){const h=f?u[0]*u[1]*(u[2]+1):u[0]*u[2]*(u[3]+1),p={dataId:e.dataId,shape:[1,h,n.inChannels],dtype:e.dtype},d=c.shape;c.shape=c.shape.slice(),c.shape[c.shape.length-2]++,l(NN(c.shape,p.shape),()=>`packed reshape ${c.shape} to ${p.shape} isn't free`);const y=TC({inputs:{x:t},backend:s,attrs:{shape:[1,n.inChannels,n.outChannels]}});g.push(y);const b=BC({a:p,b:y,backend:s,transposeA:!1,transposeB:!1,bias:r,activation:o,preluActivationWeights:a,leakyreluAlpha:i}),x=s.texData.get(b.dataId);l(x.isPacked,()=>"batchMatMul result is expected to be packed"),c.shape=d,x.shape=n.outShape,m=oC({inputs:{x:b},backend:s}),m.shape=n.outShape,g.push(b)}else{const l=TC({inputs:{x:e},backend:s,attrs:{shape:[1,f?u[0]*u[1]*u[2]:u[0]*u[2]*u[3],n.inChannels]}}),c=TC({inputs:{x:t},backend:s,attrs:{shape:[1,n.inChannels,n.outChannels]}}),h=BC({a:l,b:c,transposeA:!1,transposeB:!1,backend:s,bias:r,activation:o,preluActivationWeights:a,leakyreluAlpha:i});m=TC({inputs:{x:h},backend:s,attrs:{shape:n.outShape}}),g.push(l),g.push(c),g.push(h)}for(const e of g)s.disposeIntermediateTensorInfo(e);return m}function ZS({x:e,filter:t,convInfo:n,backend:s,bias:r=null,preluActivationWeights:a=null,leakyreluAlpha:i=0,activation:o=null}){const{filterWidth:l,filterHeight:u,inChannels:c,outWidth:h,outHeight:d,dataFormat:f}=n,m="channelsLast"===f,g=l*u*c,y=d*h,b=[g,y],x=[],w=TC({inputs:{x:e},backend:s,attrs:{shape:e.shape.slice(1)}}),k=TC({inputs:{x:t},backend:s,attrs:{shape:[1,g,p(t.shape)/g]}});x.push(w),x.push(k);const v=new YS(b,w.shape,n),N=s.runWebGLProgram(v,[w],"float32"),I=TC({inputs:{x:N},backend:s,attrs:{shape:[1,b[0],b[1]]}});x.push(N),x.push(I);const C=null!=r,S=null!=a,T="leakyrelu"===o,E=o?xC(o,!0):null,$=new wC(I.shape,k.shape,[1,y,n.outChannels],!0,!1,C,E,S,T),A=[I,k];if(r&&A.push(r),S&&A.push(a),T){const e=s.makeTensorInfo([],"float32",fe(i,"float32"));A.push(e),x.push(e)}const R=s.runWebGLProgram($,A,"float32"),F=TC({inputs:{x:R},backend:s,attrs:{shape:m?[1,d,h,n.outChannels]:[1,n.outChannels,d,h]}});x.push(R);for(const e of x)s.disposeIntermediateTensorInfo(e);return F}const QS={kernelName:"Conv2D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dataFormat:l,dilations:u,dimRoundingMode:c}=s,h=Bs(l),p=As(r.shape,a.shape,i,u,o,c,!1,h);let d;if(1!==p.filterHeight||1!==p.filterWidth||1!==p.dilationHeight||1!==p.dilationWidth||1!==p.strideHeight||1!==p.strideWidth||"SAME"!==p.padInfo.type&&"VALID"!==p.padInfo.type)if(H().getBool("WEBGL_CONV_IM2COL")&&1===r.shape[0])d=ZS({x:r,filter:a,convInfo:p,backend:n});else{const e=new KS(p);d=n.runWebGLProgram(e,[r,a],"float32")}else d=JS({x:r,filter:a,convInfo:p,backend:n});const f=TC({inputs:{x:d},backend:n,attrs:{shape:p.outShape}});return n.disposeIntermediateTensorInfo(d),f}};class eT{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideHeight,n=e.strideWidth,s=e.padInfo.top,r=e.padInfo.left,a="channelsLast"===e.dataFormat;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int d2 = coords.w;\n\n        // Convolve x(?, ?, d1) with dy(:, :, d2) to get dw(wR, wC, d1, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${t} - ${s};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${r};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              if (${a}) {\n                float dyValue = getDy(b, yR, yC, d2);\n                float xValue = getX(b, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              } else {\n                float dyValue = getDy(b, d2, yR, yC);\n                float xValue = getX(b, d1, xR, xC);\n                dotProd += (xValue * dyValue);\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class tT{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a="channelsLast"===e.dataFormat,i=t-1-e.padInfo.top,o=n-1-e.padInfo.left,l=a?1:2,u=a?2:3,c=a?3:1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${o});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[${c}];\n\n        ivec2 dyCorner = ivec2(coords[${l}], coords[${u}]) - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n\n              if (${a}) {\n                float xValue = getDy(batch, idyR, idyC, d2);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              } else {\n                float xValue = getDy(batch, d2, idyR, idyC);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class nT{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideDepth,n=e.strideHeight,s=e.strideWidth,r=e.padInfo.front,a=e.padInfo.top,i=e.padInfo.left;this.userCode=`\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int wF = coords.x;\n        int wR = coords.y;\n        int wC = coords.z;\n        int d1 = coords.w;\n        int d2 = coords.u;\n\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yF = 0; yF < ${e.outDepth}; yF++) {\n            int xF = wF + yF * ${t} - ${r};\n\n            if (xF < 0 || xF >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int yR = 0; yR < ${e.outHeight}; yR++) {\n              int xR = wR + yR * ${n} - ${a};\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int yC = 0; yC < ${e.outWidth}; yC++) {\n                int xC = wC + yC * ${s} - ${i};\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float dyValue = getDy(b, yF, yR, yC, d2);\n                float xValue = getX(b, xF, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class sT{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterDepth,n=e.filterHeight,s=e.filterWidth,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=t-1-e.padInfo.front,l=n-1-e.padInfo.top,u=s-1-e.padInfo.left;this.userCode=`\n      const ivec3 pads = ivec3(${o}, ${l}, ${u});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.u;\n\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyFCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${t}; wF++) {\n          float dyF = float(dyFCorner + wF) / ${r}.0;\n\n          if (dyF < 0.0 || dyF >= ${e.outDepth}.0 || fract(dyF) > 0.0) {\n            continue;\n          }\n          int idyF = int(dyF);\n\n          int wFPerm = ${t} - 1 - wF;\n\n          for (int wR = 0; wR < ${n}; wR++) {\n            float dyR = float(dyRCorner + wR) / ${a}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n              fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            int wRPerm = ${n} - 1 - wR;\n\n            for (int wC = 0; wC < ${s}; wC++) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              int wCPerm = ${s} - 1 - wC;\n\n              for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n                float xValue = getDy(batch, idyF, idyR, idyC, d2);\n                float wValue = getW(wFPerm, wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const rT={kernelName:"Conv2DBackpropFilter",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,dataFormat:l,dimRoundingMode:u,filterShape:c}=s,h=Bs(l),p=As(r.shape,c,i,1,o,u,!1,h),d=new eT(p);return n.runWebGLProgram(d,[r,a],"float32")}};const aT={kernelName:"Conv2DBackpropInput",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{inputShape:i,strides:o,pad:l,dataFormat:u,dimRoundingMode:c}=s,h=Bs(u),p=As(i,a.shape,o,1,l,c,!1,h),d=new tT(p);return n.runWebGLProgram(d,[r,a],"float32")}};const iT={kernelName:"Conv3D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s,u=Rs(r.shape,a.shape,i,l,o),c=new XS(u);return n.runWebGLProgram(c,[r,a],"float32")}};const oT={kernelName:"Conv3DBackpropFilterV2",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,filterShape:l}=s,u=Rs(r.shape,l,i,1,o),c=new nT(u);return n.runWebGLProgram(c,[r,a],"float32")}};const lT={kernelName:"Conv3DBackpropInputV2",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{pad:i,strides:o,inputShape:l}=s,u=Rs(l,a.shape,o,1,i),c=new sT(u);return n.runWebGLProgram(c,[r,a],"float32")}},uT=yC({opSnippet:"if (isnan(x)) return x;\n  return cos(x);\n"}),cT={kernelName:Y,backendName:"webgl",kernelFunc:uT},hT={kernelName:"Cosh",backendName:"webgl",kernelFunc:yC({opSnippet:"\n  float e2x = exp(-x);\n  return (e2x + 1.0 / e2x) / 2.0;\n"})};class pT{constructor(e,t,n,s,r){this.variableNames=["Image","Boxes","BoxInd"],this.outputShape=[];const[a,i,o,l]=e,[u]=t,[c,h]=n;this.outputShape=[u,c,h,l];const p="bilinear"===s?1:0,[d,f]=[i-1+".0",o-1+".0"],[m,g,y]=c>1?[""+(i-1)/(c-1),"(y2-y1) * height_ratio",`y1*${d} + float(y)*(height_scale)`]:["0.0","0.0","0.5 * (y1+y2) * "+d],[b,x,w]=h>1?[""+(o-1)/(h-1),"(x2-x1) * width_ratio",`x1*${f} + float(x)*(width_scale)`]:["0.0","0.0","0.5 * (x1+x2) * "+f];this.userCode=`\n      const float height_ratio = float(${m});\n      const float width_ratio = float(${b});\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int y = coords[1];\n        int x = coords[2];\n        int d = coords[3];\n\n        // get box vals\n        float y1 = getBoxes(b,0);\n        float x1 = getBoxes(b,1);\n        float y2 = getBoxes(b,2);\n        float x2 = getBoxes(b,3);\n\n        // get image in batch index\n        int bInd = round(getBoxInd(b));\n        if(bInd < 0 || bInd >= ${a}) {\n          return;\n        }\n\n        float height_scale = ${g};\n        float width_scale = ${x};\n\n        float in_y = ${y};\n        if( in_y < 0.0 || in_y > ${d} ) {\n          setOutput(float(${r}));\n          return;\n        }\n        float in_x = ${w};\n        if( in_x < 0.0 || in_x > ${f} ) {\n          setOutput(float(${r}));\n          return;\n        }\n\n        vec2 sourceFracIndexCR = vec2(in_x,in_y);\n        if(${p} == 1) {\n          // Compute the four integer indices.\n          ivec2 sourceFloorCR = ivec2(sourceFracIndexCR);\n          ivec2 sourceCeilCR = ivec2(ceil(sourceFracIndexCR));\n\n          float topLeft = getImage(b, sourceFloorCR.y, sourceFloorCR.x, d);\n          float bottomLeft = getImage(b, sourceCeilCR.y, sourceFloorCR.x, d);\n          float topRight = getImage(b, sourceFloorCR.y, sourceCeilCR.x, d);\n          float bottomRight = getImage(b, sourceCeilCR.y, sourceCeilCR.x, d);\n\n          vec2 fracCR = sourceFracIndexCR - vec2(sourceFloorCR);\n\n          float top = topLeft + (topRight - topLeft) * fracCR.x;\n          float bottom = bottomLeft + (bottomRight - bottomLeft) * fracCR.x;\n          float newValue = top + (bottom - top) * fracCR.y;\n          setOutput(newValue);\n        } else {\n          // Compute the coordinators of nearest neighbor point.\n          ivec2 sourceNearestCR = ivec2(floor(\n            sourceFracIndexCR + vec2(0.5,0.5)));\n          float newValue = getImage(b, sourceNearestCR.y, sourceNearestCR.x, d);\n          setOutput(newValue);\n        }\n      }\n    `}}const dT={kernelName:"CropAndResize",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{image:r,boxes:a,boxInd:i}=t,{cropSize:o,method:l,extrapolationValue:u}=s,c=new pT(r.shape,a.shape,o,l,u);return n.runWebGLProgram(c,[r,a,i],"float32")}};class fT{constructor(e,t,n){this.variableNames=["x"],this.outputShape=e;const s=e.length,r=t?"0.0":`getX(${mT(s,"coords")})`,a=e[e.length-1];let i="",o="";t?(i=n?"end != "+(a-1):"end != 0",o=n?"end + 1":"end - 1"):(i=n?"end + pow2 < "+a:"end >= pow2",o=n?"end + pow2":"end - pow2"),this.userCode=`\n      uniform float index;\n      void main() {\n        ${cI(s)} coords = getOutputCoords();\n        int end = ${gT(s,"coords")};\n        float val = ${r};\n        int pow2 = int(pow(2.0, index));\n        if (${i}) {\n          int idx = ${o};\n          ${gT(s,"coords")} = idx;\n          val += getX(${mT(s,"coords")});\n        }\n        setOutput(val);\n      }\n    `}getCustomSetupFunc(e){return(t,n)=>{null==this.index&&(this.index=t.getUniformLocation(n,"index")),t.gl.uniform1f(this.index,e)}}}function mT(e,t){if(1===e)return""+t;if(2===e)return`${t}.x, ${t}.y`;if(3===e)return`${t}.x, ${t}.y, ${t}.z`;if(4===e)return`${t}.x, ${t}.y, ${t}.z, ${t}.w`;throw Error(`Cumulative sum for rank ${e} is not yet supported`)}function gT(e,t){if(1===e)return""+t;if(2===e)return t+".y";if(3===e)return t+".z";if(4===e)return t+".w";throw Error(`Cumulative sum for rank ${e} is not yet supported`)}const yT={kernelName:"Cumsum",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s,l=r.shape.length,u=fa([a],l);let c=r;null!=u&&(c=LC({inputs:{x:r},backend:n,attrs:{perm:u}}));const h=ga(1,l)[0];if(h!==l-1)throw new Error(`WebGL cumsum shader expects an inner-most axis=${r.shape.length-1} but got axis=`+a);const p=r.shape[h];let d=oC({inputs:{x:c},backend:n});for(let e=0;e<=Math.ceil(Math.log2(p))-1;e++){const t=new fT(c.shape,!1,o),s=t.getCustomSetupFunc(e),r=d;d=n.runWebGLProgram(t,[d],d.dtype,s),n.disposeIntermediateTensorInfo(r)}if(i){const e=new fT(c.shape,i,o),t=d;d=n.runWebGLProgram(e,[d],d.dtype),n.disposeIntermediateTensorInfo(t)}if(null!=u){const e=LC({inputs:{x:d},backend:n,attrs:{perm:ma(u)}});return n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(c),e}return d}};const bT={kernelName:"DenseBincount",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i,binaryOutput:o}=s;if(1===r.shape.length){const e=n.readSync(r.dataId),t=n.readSync(a.dataId),s=mI(e,t,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,s)}if(2===r.shape.length){const e=n.bufferSync(r),t=n.bufferSync(a),s=gI(e,t,i,o);return n.makeTensorInfo(s.shape,a.dtype,s.values)}throw new Error("Error in denseBincount: input must be at most rank 2, but got rank"+r.shape.length+".")}};class xT{constructor(e,t,n){this.variableNames=["x"],this.outputShape=[],this.outputShape=e,this.blockSize=t,this.dataFormat=n,this.userCode=`\n    void main() {\n      ivec4 coords = getOutputCoords();\n      int b = coords[0];\n      int h = ${this.getHeightCoordString()};\n      int w = ${this.getWidthCoordString()};\n      int d = ${this.getDepthCoordString()};\n\n      int in_h = h / ${t};\n      int offset_h = imod(h, ${t});\n      int in_w = w / ${t};\n      int offset_w = imod(w, ${t});\n      int offset_d = (offset_h * ${t} + offset_w) *\n        ${this.getOutputDepthSize()};\n      int in_d = d + offset_d;\n\n      float result = ${this.getInputSamplingString()};\n      setOutput(result);\n    }\n  `}getHeightCoordString(){return"NHWC"===this.dataFormat?"coords[1]":"coords[2]"}getWidthCoordString(){return"NHWC"===this.dataFormat?"coords[2]":"coords[3]"}getDepthCoordString(){return"NHWC"===this.dataFormat?"coords[3]":"coords[1]"}getOutputDepthSize(){return"NHWC"===this.dataFormat?this.outputShape[3]:this.outputShape[1]}getInputSamplingString(){return"NHWC"===this.dataFormat?"getX(b, in_h, in_w, in_d)":"getX(b, in_d, in_h, in_w)"}}const wT={kernelName:"DepthToSpace",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockSize:a,dataFormat:i}=s;l(a>1,()=>"blockSize should be > 1 for depthToSpace, but was: "+a);const o=r.shape[0],u="NHWC"===i?r.shape[1]:r.shape[2],c="NHWC"===i?r.shape[2]:r.shape[3],h="NHWC"===i?r.shape[3]:r.shape[1],p=u*a,d=c*a,f=h/(a*a),m=new xT("NHWC"===i?[o,p,d,f]:[o,f,p,d],a,i);return n.runWebGLProgram(m,[r],r.dtype)}};class kT{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const a=e.inHeight,i=e.inWidth,o=e.padInfo.top,l=e.padInfo.left,u=e.strideHeight,c=e.strideWidth,h=e.dilationHeight,p=e.dilationWidth,d=e.filterHeight,f=e.filterWidth,m=e.outChannels/e.inChannels;let g="",y="";n&&(g=s?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,y="result = activation(result);");const b=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${g}\n\n      const ivec2 strides = ivec2(${u}, ${c});\n      const ivec2 pads = ivec2(${o}, ${l});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${m};\n        int q = d2 - d1 * ${m};\n\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, q) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        // TO DO(dsmilkov): Flatten the two for loops and vec4 the operations.\n        for (int wR = 0; wR < ${d}; wR++) {\n          int xR = xRCorner + wR * ${h};\n\n          if (xR < 0 || xR >= ${a}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${f}; wC++) {\n            int xC = xCCorner + wC * ${p};\n\n            if (xC < 0 || xC >= ${i}) {\n              continue;\n            }\n\n            float xVal = getX(batch, xR, xC, d1);\n            float wVal = getW(wR, wC, d1, q);\n            dotProd += xVal * wVal;\n          }\n        }\n\n        float result = dotProd;\n        ${b}\n        ${y}\n        setOutput(result);\n      }\n    `}}class vT{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e.outShape;const a=e.inHeight,o=e.inWidth,l=e.padInfo.top,u=e.padInfo.left,c=e.strideHeight,h=e.strideWidth,p=e.dilationHeight,d=e.dilationWidth,f=e.filterHeight,m=e.filterWidth,g=m;let y="int xR; int xC; int xCOffset;";for(let e=0;e<f;e++)for(let t=0;t<m;t++)y+=`\n          vec4 xTexelR${e}C${2*t} = vec4(0.);\n          vec4 wR${e}C${t} = vec4(0.);\n          vec4 xR${e}C${t} = vec4(0.);`;for(let e=0;e<f;e++)for(let t=0;t<g;t++){const n=2*t;if(y+=`\n          xR = xRCorner + ${e*p};\n          xC = xCCorner + ${n*d};\n        `,1===h){if(n<m&&(y+=u%2==1?`\n                xCOffset = xC + 1;\n                if(xR >= 0 && xR < ${a} && xCOffset >= 0 && xCOffset < ${o}) {\n                  xTexelR${e}C${n} = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if(xCOffset + 1 >= ${o}) {\n                    xTexelR${e}C${n}.zw = vec2(0.);\n                  }\n                } else {\n                  xTexelR${e}C${n} = vec4(0.);\n                }\n\n                xCOffset = xC + 1 - 2;\n                if(xR >= 0 && xR < ${a} && xCOffset >= 0 && xCOffset < ${o}) {\n                  vec4 previous = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if(xCOffset + 1 >= ${o}) {\n                    previous.zw = vec2(0.);\n                  }\n\n                  xR${e}C${n} = vec4(previous.zw, xTexelR${e}C${n}.xy);\n                } else {\n                  xR${e}C${n} = vec4(0, 0, xTexelR${e}C${n}.xy);\n                }\n              `:`\n                if(xR >= 0 && xR < ${a} && xC >= 0 && xC < ${o}) {\n                  xTexelR${e}C${n} = getX(batch, xR, xC, d1);\n                } else {\n                  xTexelR${e}C${n} = vec4(0.);\n                }\n\n                xR${e}C${n} = xTexelR${e}C${n};\n              `,n+1<m)){const t=u%2==0?i(d):d;d%2==0&&u%2==1||d%2!=0&&u%2!=1?(y+=`\n                  xCOffset = xC + ${u%2} + ${t};\n\n                  if(xR >= 0 && xR < ${a} &&\n                    xCOffset >= 0 && xCOffset < ${o}) {\n                    xTexelR${e}C${n+2} = getX(batch, xR, xCOffset, d1);\n                  }\n                `,d>1&&(y+=`\n                    xCOffset -= 2;\n                    if(xR >= 0 && xR < ${a} &&\n                      xCOffset >= 0 && xCOffset < ${o}) {\n                      xTexelR${e}C${n} = getX(batch, xR, xCOffset, d1);\n                    } else {\n                      xTexelR${e}C${n} = vec4(0.);\n                    }\n                  `),y+=`\n                  xR${e}C${n+1} = vec4(\n                    xTexelR${e}C${n}.zw, xTexelR${e}C${n+2}.xy);\n                `):y+=`\n                  xCOffset = xC + ${t};\n\n                  if(xR >= 0 && xR < ${a} &&\n                    xCOffset >= 0 && xCOffset < ${o}) {\n                    xTexelR${e}C${n+2} = getX(batch, xR, xCOffset, d1);\n                  }\n\n                  xR${e}C${n+1} = xTexelR${e}C${n+2};\n                `}}else n<m&&(y+=`\n              if(xR >= 0 && xR < ${a}) {\n            `,u%2==1?(y+=`\n                xCOffset = xC + 1 - ${h};\n                if(xCOffset >= 0 && xCOffset < ${o}) {\n                  xTexelR${e}C${n} = getX(batch, xR, xCOffset, d1);\n                } else {\n                  xTexelR${e}C${n} = vec4(0.);\n                }\n\n                if(xC + 1 >= 0 && xC + 1 < ${o}) {\n                  xTexelR${e}C${n+2} = getX(batch, xR, xC + 1, d1);\n                } else {\n                  xTexelR${e}C${n+2} = vec4(0.);\n                }\n\n                xR${e}C${n} = vec4(\n                  xTexelR${e}C${n}.zw, xTexelR${e}C${n+2}.zw);\n              `,n+1<m&&(y+=`\n                  vec4 final = vec4(0.);\n                  xCOffset = xC + 1 + ${h};\n                  if(xCOffset >= 0 && xCOffset < ${o}) {\n                    final = getX(batch, xR, xCOffset, d1);\n                  }\n                  xR${e}C${n+1} = vec4(xTexelR${e}C${n+2}.xy, final.xy);\n                `)):(y+=`\n                if(xC >= 0 && xC < ${o}) {\n                  xTexelR${e}C${n} = getX(batch, xR, xC, d1);\n                } else {\n                  xTexelR${e}C${n} = vec4(0.);\n                }\n\n                xCOffset = xC + ${h};\n                if(xCOffset >= 0 && xCOffset < ${o}) {\n                  xTexelR${e}C${n+2} = getX(batch, xR, xCOffset, d1);\n                } else {\n                  xTexelR${e}C${n+2} = vec4(0.);\n                }\n\n                xR${e}C${n} = vec4(\n                  xTexelR${e}C${n}.xy, xTexelR${e}C${n+2}.xy);\n              `,n+1<m&&(y+=`\n                  xR${e}C${n+1} = vec4(\n                    xTexelR${e}C${n}.zw, xTexelR${e}C${n+2}.zw);\n                `)),y+="}");n<m&&(y+=`\n            vec4 wTexelR${e}C${n} = getW(${e}, ${n}, d1, q);\n            wR${e}C${n} = vec4(wTexelR${e}C${n}.xz, wTexelR${e}C${n}.xz);\n          `,n+1<m&&(y+=`\n              vec4 wTexelR${e}C${n+1} = getW(${e}, ${n+1}, d1, q);\n              wR${e}C${n+1} =\n                vec4(wTexelR${e}C${n+1}.xz, wTexelR${e}C${n+1}.xz);`))}for(let e=0;e<f;e++)for(let t=0;t<m;t++)y+=`dotProd += xR${e}C${t} * wR${e}C${t};`;let b="",x="";n&&(b=s?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`vec4 activation(vec4 x) {\n          ${n}\n        }`,x="result = activation(result);");const w=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${b}\n\n      const ivec2 strides = ivec2(${c}, ${h});\n      const ivec2 pads = ivec2(${l}, ${u});\n\n      void main() {\n\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2;\n        int q = 0;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        vec4 dotProd = vec4(0.);\n\n        ${y}\n\n        vec4 result = dotProd;\n        ${w}\n        ${x}\n        setOutput(result);\n      }\n    `}}const NT={kernelName:"DepthwiseConv2dNative",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:u,dimRoundingMode:c}=s;let h=u;null==h&&(h=[1,1]),l(zs(i,h),()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${i} and dilations '${h}'`);const p=As(r.shape,a.shape,i,h,o,c,!0);let d;return d=H().getBool("WEBGL_PACK_DEPTHWISECONV")&&p.strideWidth<=2&&p.outChannels/p.inChannels==1?new vT(p):new kT(p),n.runWebGLProgram(d,[r,a],"float32")}};class IT{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideHeight,n=e.strideWidth,s=e.padInfo.top,r=e.padInfo.left,a=e.outChannels/e.inChannels;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int dm = coords.w;\n        int d2 = d1 * ${a} + dm;\n\n        float dotProd = 0.0;\n\n        // TO DO: Vec4 over the batch size\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${t} - ${s};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${r};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float dyValue = getDy(b, yR, yC, d2);\n              float xValue = getX(b, xR, xC, d1);\n              dotProd += (xValue * dyValue);\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class CT{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a=t-1-e.padInfo.top,i=n-1-e.padInfo.left,o=e.outChannels/e.inChannels;this.userCode=`\n      const ivec2 pads = ivec2(${a}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[3];\n        ivec2 dyCorner = coords.yz - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        float dotProd = 0.0;\n\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            // TO DO: Vec4 over the channelMul\n            for (int dm = 0; dm < ${o}; dm++) {\n              int d2 = d1 * ${o} + dm;\n              float xValue = getDy(batch, idyR, idyC, d2);\n              float wValue = getW(wRPerm, wCPerm, d1, dm);\n              dotProd += xValue * wValue;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const ST={kernelName:"DepthwiseConv2dNativeBackpropFilter",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,filterShape:c}=s,h=As(r.shape,c,i,o,l,u,!0),p=new IT(h);return n.runWebGLProgram(p,[r,a],"float32")}};const TT={kernelName:"DepthwiseConv2dNativeBackpropInput",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,inputShape:c}=s,h=As(c,a.shape,i,o,l,u,!0),p=new CT(h);return n.runWebGLProgram(p,[r,a],"float32")}};class ET{constructor(e){this.variableNames=["X"],this.outputShape=[e,e],this.userCode="\n      void main() {\n          ivec2 coords = getOutputCoords();\n          float val = coords[0] == coords[1] ? getX(coords[0]) : 0.0;\n          setOutput(val);\n      }\n    "}}const $T={kernelName:"Diag",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=[...s.shape,...s.shape],a=p(s.shape),i=TC({inputs:{x:s},backend:n,attrs:{shape:[a]}}),o=new ET(a),l=n.runWebGLProgram(o,[i],i.dtype),u=TC({inputs:{x:l},backend:n,attrs:{shape:r}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(l),u}};class AT{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const{inHeight:t,inWidth:n,padInfo:s,strideHeight:r,strideWidth:a,filterHeight:i,filterWidth:o,dilationHeight:l,dilationWidth:u}=e,{top:c,left:h}=s;this.userCode=`\n      const ivec2 strides = ivec2(${r}, ${a});\n      const ivec2 pads = ivec2(${c}, ${h});\n      const float neg_infinity = -3.4e38;\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.w;\n        ivec2 outTopLeftCorner =\n            coords.yz * strides - pads;\n        int hBeg = outTopLeftCorner.x;\n        int wBeg = outTopLeftCorner.y;\n\n        float curVal = neg_infinity;\n        for (int h = 0; h < ${i}; h++) {\n          int hIn = hBeg + h * ${l};\n\n          if (hIn >= 0 && hIn < ${t}) {\n            for (int w = 0; w < ${o}; w++) {\n              int wIn = wBeg + w * ${u};\n\n              if (wIn >= 0 && wIn < ${n}) {\n                float xVal = getX(batch, hIn, wIn, d1);\n                float wVal = getW(h, w, d1);\n\n                float val = xVal + wVal;\n                if (val > curVal) {\n                  curVal = val;\n                }\n              }\n            }\n          }\n        }\n\n        float result = curVal;\n        setOutput(result);\n      }\n    `}}const RT={kernelName:"Dilation2D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s,u=Ts(r.shape,a.shape,i,o,"NHWC",l);let c;const h=new AT(u);c=n.runWebGLProgram(h,[r,a],"float32");const p=TC({inputs:{x:c},backend:n,attrs:{shape:u.outShape}});return n.disposeIntermediateTensorInfo(c),p}},FT=yC({opSnippet:"return (x >= 0.0) ? x : (exp(x) - 1.0);",packedOpSnippet:"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n"}),DT={kernelName:J,backendName:"webgl",kernelFunc:FT},_T={kernelName:"EluGrad",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n}=e,{dy:s,y:r}=t,a=H().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new iC("\n  vec4 bGTEZero = vec4(greaterThanEqual(b, vec4(0.)));\n  return (bGTEZero * a) + ((vec4(1.0) - bGTEZero) * (a * (b + vec4(1.0))));\n",s.shape,r.shape):new aC("return (b >= 1.0) ? a : a * (b + 1.0);",s.shape,r.shape);return n.runWebGLProgram(a,[s,r],s.dtype)}},OT={kernelName:"Equal",backendName:"webgl",kernelFunc:bC({opSnippet:"return float(a == b);",packedOpSnippet:"\n  return vec4(equal(a, b));\n",dtype:"bool"})},MT=yC({opSnippet:'\n  // Error function is calculated approximately with elementary function.\n  // See "Handbook of Mathematical Functions with Formulas,\n  // Graphs, and Mathematical Tables", Abramowitz and Stegun.\n  float p = 0.3275911;\n  float a1 = 0.254829592;\n  float a2 = -0.284496736;\n  float a3 = 1.421413741;\n  float a4 = -1.453152027;\n  float a5 = 1.061405429;\n\n  float sign = sign(x);\n  x = abs(x);\n  float t = 1.0 / (1.0 + p * x);\n  return sign * (1.0 - (((((a5*t + a4)*t) + a3)*t + a2)*t + a1)*t*exp(-x*x));\n'}),LT={kernelName:Z,backendName:"webgl",kernelFunc:MT},zT="return exp(x);",BT=yC({opSnippet:zT,packedOpSnippet:zT,cpuKernelImpl:xI}),PT={kernelName:Q,backendName:"webgl",kernelFunc:BT};function WT(e){const{inputs:t,attrs:n,backend:s}=e,{dim:r}=n,{input:a}=t,i=a.shape.length,o=a.shape.slice();let u=r;return r<0&&(l(-(i+1)<=r,()=>`Axis must be in the interval [${-(i+1)}, ${i}]`),u=i+r+1),o.splice(u,0,1),TC({inputs:{x:a},backend:s,attrs:{shape:o}})}const VT={kernelName:"ExpandDims",backendName:"webgl",kernelFunc:WT},UT="return exp(x) - 1.0;",GT={kernelName:"Expm1",backendName:"webgl",kernelFunc:yC({opSnippet:UT,packedOpSnippet:UT,cpuKernelImpl:wI})};class HT{constructor(e,t,n){this.variableNames=["real","imag"];const s=t[1];this.outputShape=t;const r=n?"2.0 * "+Math.PI:"-2.0 * "+Math.PI,a=n?s+".0":"1.0";let i;if("real"===e)i="return real * expR - imag * expI;";else{if("imag"!==e)throw new Error(`FFT component must be either "real" or "imag", got ${e}.`);i="return real * expI + imag * expR;"}this.userCode=`\n      const float exponentMultiplier = ${r};\n\n      float unaryOpComplex(float real, float expR, float imag, float expI) {\n        ${i}\n      }\n\n      float mulMatDFT(int batch, int index) {\n        float indexRatio = float(index) / float(${s});\n        float exponentMultiplierTimesIndexRatio =\n            exponentMultiplier * indexRatio;\n\n        float result = 0.0;\n\n        for (int i = 0; i < ${s}; i++) {\n          // x = (-2|2 * PI / N) * index * i;\n          float x = exponentMultiplierTimesIndexRatio * float(i);\n          float expR = cos(x);\n          float expI = sin(x);\n          float real = getReal(batch, i);\n          float imag = getImag(batch, i);\n\n          result +=\n              unaryOpComplex(real, expR, imag, expI) / ${a};\n        }\n\n        return result;\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        setOutput(mulMatDFT(coords[0], coords[1]));\n      }\n    `}}function jT(e,t,n){const s=n.texData.get(e.dataId),r=p(e.shape),a=e.shape[e.shape.length-1],i=TC({inputs:{x:e},backend:n,attrs:{shape:[r/a,a]}}),o=i.shape,l=new HT("real",o,t),u=new HT("imag",o,t),c=[{dataId:s.complexTensorInfos.real.dataId,dtype:s.complexTensorInfos.real.dtype,shape:o},{dataId:s.complexTensorInfos.imag.dataId,dtype:s.complexTensorInfos.imag.dtype,shape:o}],h=n.runWebGLProgram(l,c,"float32"),d=n.runWebGLProgram(u,c,"float32"),f=uC({inputs:{real:h,imag:d},backend:n});n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(d);const m=TC({inputs:{x:f},backend:n,attrs:{shape:e.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(f),m}const qT={kernelName:"FFT",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t;return jT(s,!1,n)}};class KT{constructor(e,t){this.outputShape=[],this.variableNames=["x"],this.outputShape=e,this.userCode="\n      uniform float value;\n      void main() {\n        // Input can be obtained from uniform value.\n        setOutput(value);\n      }\n    "}getCustomSetupFunc(e){return(t,n)=>{null==this.valueLoc&&(this.valueLoc=t.getUniformLocationNoThrow(n,"value")),t.gl.uniform1f(this.valueLoc,e)}}}function XT(e){const{backend:t,attrs:n}=e,{shape:s,value:r}=n;let{dtype:a}=n;if(a=a||F(r),"string"===a){const e=v(a,p(s));return e.fill(r),t.makeTensorInfo(s,a,e)}{const e=new KT(s,r),n=e.getCustomSetupFunc(r);return t.runWebGLProgram(e,[],a,n)}}const YT={kernelName:"Fill",backendName:"webgl",kernelFunc:XT};class JT{constructor(e){this.variableNames=["Image"],this.outputShape=[];const t=e[2];this.outputShape=e,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n\n          int coordX = ${t} - x;\n          float outputValue;\n          if(coordX >= 0 && coordX < ${t}) {\n            outputValue = getImage(coords[0], coords[1], coordX, coords[3]);\n          } else {\n            outputValue = getImage(coords[0], coords[1], coords[2], coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const ZT={kernelName:"FlipLeftRight",backendName:"webgl",kernelFunc:({inputs:e,backend:t})=>{const{image:n}=e,s=t,r=new JT(n.shape);return s.runWebGLProgram(r,[n],n.dtype)}},QT="return floor(x);",eE={kernelName:"Floor",backendName:"webgl",kernelFunc:yC({opSnippet:QT,packedOpSnippet:QT,cpuKernelImpl:kI})},tE={kernelName:"FloorDiv",backendName:"webgl",kernelFunc:bC({opSnippet:"\n  float s = sign(a) * sign(b);\n  int ia = round(a);\n  int ib = round(b);\n  if (ib != 0) {\n    // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n    return float(idiv(ia, ib, s));\n  } else {\n    return NAN;\n  }\n",packedOpSnippet:"\n  ivec4 ia = round(a);\n  ivec4 ib = round(b);\n  bvec4 cond = notEqual(ib, ivec4(0));\n  ivec4 result = ivec4(0);\n  vec4 s = sign(a) * sign(b);\n\n  // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n  if (cond[0]) {\n    result[0] = idiv(ia[0], ib[0], s[0]);\n  }\n  if (cond[1]) {\n    result[1] = idiv(ia[1], ib[1], s[1]);\n  }\n  if (cond[2]) {\n    result[2] = idiv(ia[2], ib[2], s[2]);\n  }\n  if (cond[3]) {\n    result[3] = idiv(ia[3], ib[3], s[3]);\n  }\n  return vec4(result);\n",dtype:"int32"})};class nE{constructor(e){this.variableNames=["A"];const t=FN(),[n,s]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n        vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${s}.0, ${n}.0);\n\n        vec4 values = ${t.texture2D}(A, uv);\n        float value;\n        if (depth == 0) {\n          value = values.r;\n        } else if (depth == 1) {\n          value = values.g;\n        } else if (depth == 2) {\n          value = values.b;\n        } else if (depth == 3) {\n          value = values.a;\n        }\n\n        setOutput(floor(value * 255.0 + 0.5));\n      }\n    `}}class sE{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const t=FN(),[n,s]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n\n        vec4 result = vec4(0.);\n\n        for(int row=0; row<=1; row++) {\n          for(int col=0; col<=1; col++) {\n            texC = coords[1] + row;\n            depth = coords[2] + col;\n\n            vec2 uv = (vec2(texC, texR) + halfCR) /\n                       vec2(${s}.0, ${n}.0);\n            vec4 values = ${t.texture2D}(A, uv);\n            float value;\n            if (depth == 0) {\n              value = values.r;\n            } else if (depth == 1) {\n              value = values.g;\n            } else if (depth == 2) {\n              value = values.b;\n            } else if (depth == 3) {\n              value = values.a;\n            }\n\n            result[row * 2 + col] = floor(value * 255.0 + 0.5);\n          }\n        }\n\n        ${t.output} = result;\n      }\n    `}}const rE={kernelName:"FromPixels",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e;let{pixels:r}=t;const{numChannels:a}=s,i="undefined"!=typeof HTMLVideoElement&&r instanceof HTMLVideoElement,o="undefined"!=typeof HTMLImageElement&&r instanceof HTMLImageElement,l="undefined"!=typeof ImageBitmap&&r instanceof ImageBitmap,[u,c]=i?[r.videoWidth,r.videoHeight]:[r.width,r.height],h=[c,u],p=[c,u,a];(o||i||l)&&(null==aE&&(aE=document.createElement("canvas").getContext("2d")),aE.canvas.width=u,aE.canvas.height=c,aE.drawImage(r,0,0,u,c),r=aE.canvas);const d=n.makeTensorInfo(h,"int32");n.texData.get(d.dataId).usage=eN.PIXELS,n.gpgpu.uploadPixelDataToTexture(n.getTexture(d.dataId),r);const f=H().getBool("WEBGL_PACK")?new sE(p):new nE(p),m=n.runWebGLProgram(f,[d],"int32");return n.disposeData(d.dataId),m}};let aE;const iE={kernelName:"FusedConv2D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s,m=Bs(c),g=As(r.shape,a.shape,l,h,u,p,!1,m);let y;const b=[];if(1!==g.filterHeight||1!==g.filterWidth||1!==g.dilationHeight||1!==g.dilationWidth||1!==g.strideHeight||1!==g.strideWidth||"SAME"!==g.padInfo.type&&"VALID"!==g.padInfo.type)if(H().getBool("WEBGL_CONV_IM2COL")&&1===r.shape[0])y=ZS({x:r,filter:a,convInfo:g,backend:n,bias:i,activation:d,preluActivationWeights:o,leakyreluAlpha:f});else{const e=null!=i,t=null!=o,s="leakyrelu"===d,l=d?xC(d,!1):null,u=new KS(g,e,l,t,s),c=[r,a];if(i&&c.push(i),o&&c.push(o),s){const e=n.makeTensorInfo([],"float32",fe(f,"float32"));c.push(e),b.push(e)}y=n.runWebGLProgram(u,c,"float32")}else y=JS({x:r,filter:a,convInfo:g,backend:n,bias:i,activation:d,preluActivationWeights:o,leakyreluAlpha:f});const x=TC({inputs:{x:y},backend:n,attrs:{shape:g.outShape}});return b.push(y),b.forEach(e=>n.disposeIntermediateTensorInfo(e)),x}};const oE={kernelName:"FusedDepthwiseConv2D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:u,pad:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s,m=[];let g=h;null==g&&(g=[1,1]),l(zs(u,g),()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${u} and dilations '${g}'`);const y=As(r.shape,a.shape,u,g,c,p,!0),b=H().getBool("WEBGL_PACK_DEPTHWISECONV")&&y.strideWidth<=2&&y.outChannels/y.inChannels==1,x=d?xC(d,b):null,w=[r,a],k=null!=i,v=null!=o,N="leakyrelu"===d;if(k&&w.push(i),v&&w.push(o),N){const e=n.makeTensorInfo([],"float32",fe(f,"float32"));w.push(e),m.push(e)}let I;I=b?new vT(y,k,x,v,N):new kT(y,k,x,v,N);const C=n.runWebGLProgram(I,w,"float32");return m.forEach(e=>n.disposeIntermediateTensorInfo(e)),C}};class lE{constructor(e,t,n){this.sliceDim=e,this.strides=t,this.variableNames=["x","indices"],this.outputShape=n;const s=cI(t.length),r=cI(n.length),a=this.sliceDim>1?"strides[j]":"strides";this.userCode=`\n        ${s} strides = ${s}(${this.strides});\n         void main() {\n          ${r} coords = getOutputCoords();\n          int flattenIndex = 0;\n          for (int j = 0; j < ${this.sliceDim}; j++) {\n            int index = round(getIndices(coords[0], j));\n            flattenIndex += index * ${a};\n          }\n          setOutput(getX(flattenIndex, coords[1]));\n        }\n      `}}const uE={kernelName:"GatherNd",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{params:s,indices:r}=t,a=r.shape,i=a[a.length-1],[o,l,u,c]=Nn(s,r),h=TC({inputs:{x:r},backend:n,attrs:{shape:[l,i]}}),d=TC({inputs:{x:s},backend:n,attrs:{shape:[p(s.shape)/u,u]}}),f=new lE(i,c,[l,u]),m=n.runWebGLProgram(f,[d,h],d.dtype),g=TC({inputs:{x:m},backend:n,attrs:{shape:o}});return n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(m),g}};class cE{constructor(e,t){this.variableNames=["A","indices"],this.outputShape=t,this.rank=t.length;const n=cI(this.rank),s=function(e,t){const n=["resRC.x","resRC.y","resRC.z","resRC.w"],s=[];for(let t=0;t<e.length;t++)2===t?s.push("int(getIndices(resRC.x, resRC.z))"):s.push(""+n[t]);return s.join()}(e);this.userCode=`\n      void main() {\n        ${n} resRC = getOutputCoords();\n        setOutput(getA(${s}));\n      }\n    `}}const hE={kernelName:"GatherV2",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,indices:a}=t,{axis:i,batchDims:o}=s,l=Yl(r,a,x(i,r.shape)[0],o),u=p(a.shape),c=[],h=TC({inputs:{x:r},backend:n,attrs:{shape:[l.batchSize,l.outerSize,l.dimSize,l.sliceSize]}}),d=TC({inputs:{x:a},backend:n,attrs:{shape:[l.batchSize,u/l.batchSize]}});c.push(h),c.push(d);const f=[l.batchSize,l.outerSize,u/l.batchSize,l.sliceSize];if(n.shouldExecuteOnCPU([r,a])||"string"===r.dtype){const e=n.bufferSync(d),t=n.bufferSync(h),s=vI(t,e,f);return c.forEach(e=>n.disposeIntermediateTensorInfo(e)),n.makeTensorInfo(l.outputShape,s.dtype,s.values)}const m=new cE(h.shape,f),g=n.runWebGLProgram(m,[h,d],h.dtype);c.push(g);const y=TC({inputs:{x:g},backend:n,attrs:{shape:l.outputShape}});return c.forEach(e=>n.disposeIntermediateTensorInfo(e)),y}},pE={kernelName:"Greater",backendName:"webgl",kernelFunc:bC({opSnippet:"return float(a > b);",packedOpSnippet:"\n  return vec4(greaterThan(a, b));\n",cpuKernelImpl:NI,dtype:"bool"})},dE={kernelName:"GreaterEqual",backendName:"webgl",kernelFunc:bC({opSnippet:"return float(a >= b);",packedOpSnippet:"\n  return vec4(greaterThanEqual(a, b));\n",dtype:"bool"})};const fE={kernelName:"IFFT",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t;return jT(s,!0,n)}},mE={kernelName:"IsFinite",backendName:"webgl",kernelFunc:yC({opSnippet:"return float(!isnan(x) && !isinf(x));",dtype:"bool"})},gE={kernelName:"IsInf",backendName:"webgl",kernelFunc:yC({opSnippet:"return float(isinf(x));",dtype:"bool"})},yE={kernelName:"IsNan",backendName:"webgl",kernelFunc:yC({opSnippet:"return float(isnan(x));",dtype:"bool"})},bE={kernelName:"Less",backendName:"webgl",kernelFunc:bC({opSnippet:"return float(a < b);",packedOpSnippet:"\n  return vec4(lessThan(a, b));\n",cpuKernelImpl:II,dtype:"bool"})},xE={kernelName:"LessEqual",backendName:"webgl",kernelFunc:bC({opSnippet:"return float(a <= b);",packedOpSnippet:"\n  return vec4(lessThanEqual(a, b));\n",dtype:"bool"})};const wE={kernelName:"LinSpace",backendName:"webgl",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,num:a}=n,i=CI(s,r,a);return t.makeTensorInfo([i.length],"float32",i)}},kE=yC({opSnippet:"if (x < 0.0) return NAN;\n  return log(x);",packedOpSnippet:"\n  vec4 result = log(x);\n  vec4 isNaN = vec4(lessThan(x, vec4(0.0)));\n  result.r = isNaN.r == 1.0 ? NAN : result.r;\n  result.g = isNaN.g == 1.0 ? NAN : result.g;\n  result.b = isNaN.b == 1.0 ? NAN : result.b;\n  result.a = isNaN.a == 1.0 ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:SI}),vE={kernelName:ee,backendName:"webgl",kernelFunc:kE},NE={kernelName:"Log1p",backendName:"webgl",kernelFunc:yC({opSnippet:"return log(1.0 + x);"})},IE={kernelName:"LogicalAnd",backendName:"webgl",kernelFunc:bC({opSnippet:"return float(a >= 1.0 && b >= 1.0);",packedOpSnippet:"\n  return vec4(\n    vec4(greaterThanEqual(a, vec4(1.0))) *\n    vec4(greaterThanEqual(b, vec4(1.0))));\n",dtype:"bool"})},CE={kernelName:"LogicalNot",backendName:"webgl",kernelFunc:yC({opSnippet:"return float(!(x >= 1.0));"})},SE={kernelName:"LogicalOr",backendName:"webgl",kernelFunc:bC({opSnippet:"return float(a >= 1.0 || b >= 1.0);",packedOpSnippet:"\n  return min(\n    vec4(greaterThanEqual(a, vec4(1.0))) +\n    vec4(greaterThanEqual(b, vec4(1.0))),\n    vec4(1.0));\n",dtype:"bool"})};class TE{constructor(e,t,n,s,r){this.variableNames=["x"],this.outputShape=[];const a=t,i=e[3]-1;let o;this.outputShape=e;const l=`float(${n}) + float(${s}) * sum`;o=.5===r?`inversesqrt(${l})`:1===r?`1.0/(${l})`:`exp(log(${l}) * float(-${r}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n        int d = coords[3];\n        float x = getX(b, r, c, d);\n        float sum = 0.0;\n        for (int j = -${a}; j <= ${a}; j++) {\n          int idx = d + j;\n          if (idx >= 0 && idx <=  ${i}) {\n            float z = getX(b, r, c, idx);\n            sum += z * z;\n          }\n        }\n        float val = x * ${o};\n        setOutput(val);\n      }\n    `}}class EE{constructor(e,t,n,s,r){this.variableNames=["x"],this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0;const a=t,i=e[3]-1;let o;this.outputShape=e;const l=`float(${n}) + float(${s}) * sum`;o=.5===r?`inversesqrt(${l})`:1===r?`1.0/(${l})`:`exp(log(${l}) * float(-${r}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords.x;\n        int r = coords.y;\n        int c = coords.z;\n        int d = coords.w;\n\n        bool hasNextCol = d < ${this.outputShape[3]};\n        bool hasNextRow = c < ${this.outputShape[2]};\n\n        vec4 sum = vec4(0.);\n        vec4 xFragAtOutputCoords = getX(b, r, c, d);\n\n        vec4 xAtOutputCoords = vec4(\n          getChannel(xFragAtOutputCoords, vec2(c, d)),\n          hasNextCol ?\n            getChannel(xFragAtOutputCoords, vec2(c, d + 1)) : 0.0,\n          hasNextRow ?\n            getChannel(xFragAtOutputCoords , vec2(c + 1, d)) : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getChannel(xFragAtOutputCoords, vec2(c + 1, d + 1)) : 0.0\n        );\n\n        int firstChannel = d - ${a};\n        vec2 cache = vec2(0.);\n        if(firstChannel >= 0){\n          vec4 firstChannelFrag = getX(b, r, c, firstChannel);\n          cache.x = getChannel(firstChannelFrag, vec2(c, firstChannel));\n            if(hasNextRow){\n              cache.y = getChannel(firstChannelFrag, vec2(c + 1, firstChannel));\n            }\n        }\n\n        ivec2 depth = ivec2(d, d + 1);\n        for (int j = - ${a}; j <= ${a}; j++) {\n          ivec2 idx = depth + j;\n          bvec2 aboveLowerBound = greaterThanEqual(idx, ivec2(0));\n          bvec2 belowUpperBound = lessThanEqual(idx, ivec2(${i}));\n\n          bool depthInRange = aboveLowerBound.x && belowUpperBound.x;\n          bool depthPlusOneInRange = aboveLowerBound.y && belowUpperBound.y;\n\n          if(depthInRange || depthPlusOneInRange){\n            vec4 z = vec4(0.);\n            vec4 xFragAtCurrentDepth;\n            z.xz = cache.xy;\n            if(depthPlusOneInRange && hasNextCol){\n              xFragAtCurrentDepth = idx.y != d ?\n                getX(b, r, c, idx.y) : xFragAtOutputCoords;\n              z.y = getChannel(xFragAtCurrentDepth, vec2(c, idx.y));\n              if(hasNextRow){\n                z.w = getChannel(xFragAtCurrentDepth, vec2(c + 1, idx.y));\n              }\n            }\n            cache.xy = z.yw;\n            sum += z * z;\n          }\n        }\n        vec4 result = xAtOutputCoords * ${o};\n        setOutput(result);\n      }\n    `}}const $E={kernelName:"LRN",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{depthRadius:a,bias:i,alpha:o,beta:l}=s,u=H().getBool("WEBGL_PACK_NORMALIZATION")?new EE(r.shape,a,i,o,l):new TE(r.shape,a,i,o,l);return n.runWebGLProgram(u,[r],r.dtype)}};class AE{constructor(e,t,n,s,r){this.variableNames=["inputImage","outputImage","dy"],this.outputShape=[],this.outputShape=e,this.depth=e[3],this.depthRadius=t,this.bias=n,this.alpha=s,this.beta=r,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n\n        float result = 0.0;\n        for (int d = 0; d < ${this.depth}; ++d) {\n          int depthBegin = int(max(0.0, float(d - ${t})));\n          int depthEnd = int(min(float(${this.depth}),\n              float(d + ${t} + 1)));\n\n          const int MIN_DEPTH_BEGIN = 0;\n          const int MAX_DEPTH_END = ${this.depth};\n\n          float norm = 0.0;\n          for (int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k) {\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd) {\n              norm += getInputImage(b, r, c, k) * getInputImage(b, r, c, k);\n            }\n            else {\n              break;\n            }\n          }\n\n          norm = float(${s}) * norm + float(${n});\n\n          for(int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k){\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd){\n              float dyi = -2.0 * float(${s})\n                * float(${r})\n                * getInputImage(b ,r ,c, k) * getOutputImage(b, r, c, d)\n                / norm;\n              if (k == d) {\n                dyi += pow(norm, -1.0 * ${r});\n              }\n              if (k == coords[3]) {\n                dyi *= getDy(b, r, c, d);\n                result += dyi;\n              }\n            }\n            else {\n              break;\n            }\n          }\n      }\n      setOutput(result);\n      }\n    `}}const RE={kernelName:"LRNGrad",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r,y:a,dy:i}=t,{depthRadius:o,bias:l,alpha:u,beta:c}=s,h=new AE(r.shape,o,l,u,c);return n.runWebGLProgram(h,[r,a,i],r.dtype)}};function FE(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reductionIndices:a,keepDims:i}=s,o=r.shape.length,l=x(a,r.shape);let u=l;const c=fa(u,o),h=null!=c,d=n.shouldExecuteOnCPU([r]);let f=r;if(h){if(d){const e=n.texData.get(f.dataId).values,t=new Array(o);for(let e=0;e<t.length;e++)t[e]=r.shape[c[e]];const s=WI(e,r.shape,r.dtype,c,t);f=n.makeTensorInfo(t,r.dtype),n.texData.get(f.dataId).values=s}else f=_C(r,c,n);u=ga(u.length,o)}da("max",u,o);const[m,g]=ha(f.shape,u);let y,b=m;if(i&&(b=pa(m,l)),d){const e=n.texData.get(f.dataId).values,t=TI(e,p(g),b,r.dtype);y=n.makeTensorInfo(b,r.dtype),n.texData.get(y.dataId).values=t}else y=function(e,t,n,s){const r=p(t),a=TC({inputs:{x:e},attrs:{shape:[p(e.shape)/r,r]},backend:s}),i=RC(a,e.dtype,"max",s),o=TC({inputs:{x:i},attrs:{shape:n},backend:s});return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}(f,g,b,n);return h&&n.disposeIntermediateTensorInfo(f),y}const DE={kernelName:"Max",backendName:"webgl",kernelFunc:FE},_E={kernelName:"Maximum",backendName:"webgl",kernelFunc:bC({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return max(a, b);\n",packedOpSnippet:"\n  vec4 result = vec4(max(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:EI})};const OE={kernelName:"MaxPool",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;AN(r,"maxPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:u}=s;l(zs(i,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`);const c=Es(r.shape,a,i,1,o,u);if(1===c.filterWidth&&1===c.filterHeight&&d(c.inShape,c.outShape))return oC({inputs:{x:r},backend:n});const h=new lS(c,"max",!1);return n.runWebGLProgram(h,[r],r.dtype)}};const ME={kernelName:"MaxPool3D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dataFormat:l,dimRoundingMode:u}=s,c=$s(r.shape,a,i,[1,1,1],o,u,l),h=new uS(c,"max",!1);return n.runWebGLProgram(h,[r],r.dtype)}};class LE{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const t=e.strideHeight,n=e.strideWidth,s=e.dilationHeight,r=e.effectiveFilterHeight,a=e.effectiveFilterWidth,i=r-1-e.padInfo.top,o=a-1-e.padInfo.left,l=r*a-1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${o});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${r};\n          wR += ${s}) {\n          float dyR = float(dyRCorner + wR) / ${t}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${a}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${n}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n            int maxPosValue = ${l} - int(getMaxPos(b, idyR, idyC, d));\n\n            // Get the current value, check it against the value from the\n            // position matrix.\n            int curPosValue = wR * ${a} + wC;\n            float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n            dotProd += dyValue * mask;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class zE{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const t=e.strideDepth,n=e.strideHeight,s=e.strideWidth,r=e.dilationDepth,a=e.dilationHeight,i=e.dilationWidth,o=e.effectiveFilterDepth,l=e.effectiveFilterHeight,u=e.effectiveFilterWidth,c=o-1-e.padInfo.front,h=l-1-e.padInfo.top,p=u-1-e.padInfo.left,d=o*l*u-1;this.userCode=`\n      const ivec3 pads = ivec3(${c}, ${h}, ${p});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, ch) with pos mask(:, :, :, d) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${o};\n           wD += ${r}) {\n          float dyD = float(dyDCorner + wD) / ${t}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${l};\n              wR += ${a}) {\n            float dyR = float(dyRCorner + wR) / ${n}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${u};\n                wC += ${i}) {\n              float dyC = float(dyCCorner + wC) / ${s}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n              int maxPosValue = ${d} -\n                  int(getMaxPos(batch, idyD, idyR, idyC, ch));\n\n              // Get the current value, check it against the value from the\n              // position matrix.\n              int curPosValue =\n                  wD * ${l} * ${u} +\n                  wR * ${u} + wC;\n              float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n              dotProd += dyValue * mask;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const BE={kernelName:"MaxPool3DGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a,{filterSize:o,strides:l,pad:u,dimRoundingMode:c}=s,h=$s(i.shape,o,l,[1,1,1],u,c),p=new uS(h,"max",!0),d=n.runWebGLProgram(p,[i],i.dtype),f=new zE(h),m=n.runWebGLProgram(f,[r,d],i.dtype);return n.disposeIntermediateTensorInfo(d),m}};const PE={kernelName:"MaxPoolGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a,output:i}=t,o=a;AN([a,i],"maxPoolGrad");const{filterSize:l,strides:u,pad:c,dimRoundingMode:h}=s,p=Es(o.shape,l,u,1,c,h),d=new lS(p,"max",!0),f=n.runWebGLProgram(d,[o],o.dtype),m=new LE(p),g=n.runWebGLProgram(m,[r,f],o.dtype);return n.disposeIntermediateTensorInfo(f),g}};const WE={kernelName:"MaxPoolWithArgmax",backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{filterSize:r,strides:a,pad:i,includeBatchInIndex:o}=t,u=n;l(4===s.shape.length,()=>`Error in maxPool: input must be rank 4 but got rank ${s.shape.length}.`);const c=[1,1];l(zs(a,c),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${a} and dilations '${c}'`);const h=Es(s.shape,r,a,c,i),[p,d]=function(e,t,n,s){let r=new lS(n,"max",!1);const a=s.runWebGLProgram(r,[e],"float32");return r=new lS(n,"max",!0,!0,t),[a,s.runWebGLProgram(r,[e],"float32")]}(s,o,h,u);return[p,d]}};const VE={kernelName:"Mean",backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{keepDims:r,axis:a}=t,i=n,o=s.shape.length,l=x(a,s.shape);let u=l;const c=fa(u,o),h=null!=c,d=i.shouldExecuteOnCPU([s]),f=[];let m=s;if(h){if(d){const e=i.texData.get(m.dataId).values,t=new Array(o);for(let e=0;e<t.length;e++)t[e]=s.shape[c[e]];const n=WI(e,s.shape,s.dtype,c,t);m=i.makeTensorInfo(t,s.dtype),i.texData.get(m.dataId).values=n}else m=_C(s,c,i);f.push(m),u=ga(u.length,o)}da("sum",u,o);const[g,y]=ha(m.shape,u);let b=g;r&&(b=pa(g,l));const w=function(e,t,n,s){const r=p(t),a=TC({inputs:{x:e},attrs:{shape:[p(e.shape)/r,r]},backend:s}),i=RC(a,"float32","mean",s),o=TC({inputs:{x:i},attrs:{shape:n},backend:s});return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}(m,y,b,i);for(const e of f)i.disposeIntermediateTensorInfo(e);return w}};const UE={kernelName:"Min",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=x(a,r.shape);let u=l;const c=fa(u,o);let h=r;null!=c&&(h=LC({inputs:{x:r},backend:n,attrs:{perm:c}}),u=ga(u.length,r.shape.length)),da("min",u,o);const[d,f]=ha(h.shape,u),m=TC({inputs:{x:h},backend:n,attrs:{shape:[-1,p(f)]}}),g=RC(m,m.dtype,"min",n);let y;if(i){y=TC({inputs:{x:g},backend:n,attrs:{shape:pa(d,l)}})}else y=TC({inputs:{x:g},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(h),y}},GE={kernelName:"Minimum",backendName:"webgl",kernelFunc:bC({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return min(a, b);\n",packedOpSnippet:"\n  vec4 result = vec4(min(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:$I})};class HE{constructor(e,t,n){this.variableNames=["x"],this.outputShape=t.map((t,n)=>t[0]+e[n]+t[1]);const s=e.length,r=cI(s),a=t.map(e=>e[0]).join(","),i=t.map((t,n)=>t[0]+e[n]).join(","),o=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,s),l="reflect"===n?0:1;this.userCode=1!==s?`\n      ${r} start = ${r}(${a});\n      ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outC = getOutputCoords();\n        for (int i = 0; i < ${s}; i++) {\n          if (outC[i] < start[i]) {\n            outC[i] = start[i] * 2 - outC[i] - ${l};\n          } else if(outC[i] >= end[i]) {\n            outC[i] = (end[i] - 1) * 2 - outC[i] + ${l};\n          }\n        }\n        ${r} coords = outC - start;\n        setOutput(getX(${o}));\n      }\n    `:`\n        int start = ${a};\n        int end = ${i};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start) {\n            outC = start * 2 - outC - ${l};\n          } else if(outC >= end) {\n            outC = (end - 1) * 2 - outC + ${l};\n          }\n          setOutput(getX(outC - start));\n        }\n      `}}class jE{constructor(e,t,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t.map((t,n)=>t[0]+e[n]+t[1]);const s=e.length,r=cI(s),a=t.map(e=>e[0]).join(","),i=t.map((t,n)=>t[0]+e[n]).join(","),o=GI("rc",s),l=GI("source",s),u=`${o[s-1]} < ${this.outputShape[s-1]}`,c=1===s?"source":`vec2(${l.slice(-2).join()})`,h="reflect"===n?0:1;let p="";if(1===s){const e=`\n        ${r} source = rc;\n        if (source < start) {\n          source = start * 2 - source - ${h};\n        } else if (source >= end) {\n          source = (end - 1) * 2 - source + ${h};\n        }\n        source -= start;\n      `;p=`\n        ${r} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${l.join()}), ${c});\n        ${o[s-1]} += 1;\n        if(${u}) {\n          ${e}\n          result[1] = getChannel(getX(${l.join()}), ${c});\n        }\n      `}else{const e=`\n        ${r} source = rc;\n        ${r} lt = ${r}(lessThan(source, start));\n        ${r} gte = ${r}(greaterThanEqual(source, end));\n        ${r} orig = 1 - (lt + gte);\n        source = orig * source +\n                lt * (start * 2 - source - ${h}) +\n                gte * ((end - 1) * 2 - source + ${h});\n        source -= start;\n      `;p=`\n        ${r} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${l.join()}), ${c});\n        ${o[s-1]} += 1;\n        if(${u}) {\n          ${e}\n          result[1] = getChannel(getX(${l.join()}), ${c});\n        }\n        rc = outputLoc;\n        ${o[s-2]} += 1;\n        if(${o[s-2]} < ${this.outputShape[s-2]}) {\n          ${e}\n          result[2] = getChannel(getX(${l.join()}), ${c});\n          ${o[s-1]} += 1;\n          if(${u}) {\n            ${e}\n            result[3] = getChannel(getX(${l.join()}), ${c});\n          }\n        }\n      `}this.userCode=`\n      const ${r} start = ${r}(${a});\n      const ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${p}\n        setOutput(result);\n      }\n    `}}const qE={kernelName:"MirrorPad",backendName:"webgl",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s}=e,{paddings:r,mode:a}=n,i=H().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new jE(s.shape,r,a):new HE(s.shape,r,a);return t.runWebGLProgram(i,[s],s.dtype)}},KE=bC({opSnippet:"if (b == 0.0) return NAN;\n  return mod(a, b);",packedOpSnippet:"\n  vec4 result = mod(a, b);\n  vec4 isNaN = vec4(equal(b, vec4(0.0)));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),XE={kernelName:te,backendName:"webgl",kernelFunc:KE};class YE{constructor(e,t,n){this.variableNames=["probs"],this.outputShape=[e,n],this.userCode=`\n      uniform float seed;\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n\n        float r = random(seed);\n        float cdf = 0.0;\n\n        for (int i = 0; i < ${t-1}; i++) {\n          cdf += getProbs(batch, i);\n\n          if (r < cdf) {\n            setOutput(float(i));\n            return;\n          }\n        }\n\n        // If no other event happened, last event happened.\n        setOutput(float(${t-1}));\n      }\n    `}getCustomSetupFunc(e){return(t,n)=>{null==this.seedLoc&&(this.seedLoc=t.getUniformLocation(n,"seed")),t.gl.uniform1f(this.seedLoc,e)}}}const JE=bC({opSnippet:"\nif (a == b) {\n  return 1.0;\n};\nreturn a / b;",packedOpSnippet:"\n  // vec4 one = vec4(equal(a, b));\n  // return one + (vec4(1.0) - one) * a / b;\n  vec4 result = a / b;\n  if(a.x == b.x) {\n    result.x = 1.;\n  }\n  if(a.y == b.y) {\n    result.y = 1.;\n  }\n  if(a.z == b.z) {\n    result.z = 1.;\n  }\n  if(a.w == b.w) {\n    result.w = 1.;\n  }\n\n  return result;\n",checkOutOfBounds:!0}),ZE={kernelName:"RealDiv",backendName:"webgl",kernelFunc:JE},QE="return a - b;",e$=bC({opSnippet:QE,packedOpSnippet:QE,supportsComplex:!0,cpuKernelImpl:zI}),t$={kernelName:re,backendName:"webgl",kernelFunc:e$};function n$(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{dim:a}=s,i=x([a],r.shape),o=FE({inputs:{x:r},backend:n,attrs:{reductionIndices:i,keepDims:!1}}),l=pa(o.shape,i),u=TC({inputs:{x:o},backend:n,attrs:{shape:l}}),c=e$({inputs:{a:r,b:u},backend:n}),h=BT({inputs:{x:c},backend:n}),p=OC({inputs:{x:h},backend:n,attrs:{axis:i,keepDims:!1}}),d=TC({inputs:{x:p},backend:n,attrs:{shape:l}}),f=JE({inputs:{a:h,b:d},backend:n});return n.disposeIntermediateTensorInfo(o),n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(c),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(d),f}const s$={kernelName:"Softmax",backendName:"webgl",kernelFunc:n$};const r$={kernelName:"Multinomial",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{numSamples:a,seed:i,normalized:o}=s,l=o?r:n$({inputs:{logits:r},backend:n,attrs:{dim:r.shape.length-1}}),u=l.shape[0],c=l.shape[1],h=new YE(u,c,a),p=h.getCustomSetupFunc(i),d=n.runWebGLProgram(h,[l],"int32",p);return o||n.disposeIntermediateTensorInfo(l),d}},a$="return -x;";const i$={kernelName:"Neg",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;if(n.shouldExecuteOnCPU([s])){const e=n.texData.get(s.dataId),[t,r]=RI(e.values,s.shape,s.dtype);return n.makeTensorInfo(r,s.dtype,t)}let r;return r=H().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new eC(s.shape,a$):new JI(s.shape,a$),n.runWebGLProgram(r,[s],s.dtype)}},o$=Lo;const l$={kernelName:"NonMaxSuppressionV3",backendName:"webgl",kernelFunc:function(e){zl("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=s,u=n.readSync(r.dataId),c=n.readSync(a.dataId),{selectedIndices:h}=o$(u,c,i,o,l);return n.makeTensorInfo([h.length],"int32",new Int32Array(h))}},u$=zo;const c$={kernelName:"NonMaxSuppressionV4",backendName:"webgl",kernelFunc:function(e){zl("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,padToMaxOutputSize:u}=s,c=n.readSync(r.dataId),h=n.readSync(a.dataId),{selectedIndices:p,validOutputs:d}=u$(c,h,i,o,l,u);return[n.makeTensorInfo([p.length],"int32",new Int32Array(p)),n.makeTensorInfo([],"int32",new Int32Array([d]))]}},h$=Bo;const p$={kernelName:"NonMaxSuppressionV5",backendName:"webgl",kernelFunc:function(e){zl("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,softNmsSigma:u}=s,c=n.readSync(r.dataId),h=n.readSync(a.dataId),p=i,d=o,f=l,m=u,{selectedIndices:g,selectedScores:y}=h$(c,h,p,d,f,m);return[n.makeTensorInfo([g.length],"int32",new Int32Array(g)),n.makeTensorInfo([y.length],"float32",new Float32Array(y))]}};class d${constructor(e,t,n,s){this.variableNames=["indices"],this.outputShape=[e,t],this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int index = round(getIndices(coords.x));\n        setOutput(mix(float(${s}), float(${n}),\n                      float(index == coords.y)));\n      }\n    `}}const f$={kernelName:"OneHot",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{indices:r}=t,{depth:a,onValue:i,offValue:o}=s,l=p(r.shape),u=new d$(l,a,i,o),c=TC({inputs:{x:r},backend:n,attrs:{shape:[l]}}),h=n.runWebGLProgram(u,[c],r.dtype);n.disposeIntermediateTensorInfo(c);const d=TC({inputs:{x:h},backend:n,attrs:{shape:[...r.shape,a]}});return n.disposeIntermediateTensorInfo(h),d}};function m$(e){const{inputs:t,backend:n}=e,{x:s}=t;if("complex64"===s.dtype){const e=$S({inputs:{input:s},backend:n}),t=m$({inputs:{x:e},backend:n}),r=US({inputs:{input:s},backend:n}),a=m$({inputs:{x:r},backend:n}),i=uC({inputs:{real:t,imag:a},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(a),i}return XT({attrs:{shape:s.shape,dtype:s.dtype,value:"string"===s.dtype?"":0},backend:n})}const g$={kernelName:"ZerosLike",backendName:"webgl",kernelFunc:m$};const y$={kernelName:"OnesLike",backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s}=t,{x:r}=n;if("string"===r.dtype)throw new Error("onesLike is not supported under string dtype");if("complex64"===r.dtype){const t=$S({inputs:{input:r},backend:s}),n=e({inputs:{x:t},backend:s}),a=US({inputs:{input:r},backend:s}),i=m$({inputs:{x:a},backend:s}),o=uC({inputs:{real:n,imag:i},backend:s});return s.disposeIntermediateTensorInfo(t),s.disposeIntermediateTensorInfo(n),s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}return XT({attrs:{shape:r.shape,dtype:r.dtype,value:1},backend:s})}};const b$={kernelName:"Pack",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s;if(1===t.length)return WT({inputs:{input:t[0]},backend:n,attrs:{dim:r}});const a=t[0].shape,i=t[0].dtype;t.forEach(e=>{u(a,e.shape,"All tensors passed to stack must have matching shapes"),l(i===e.dtype,()=>"All tensors passed to stack must have matching dtypes")});const o=[],c=jS({inputs:t.map(e=>{const t=WT({inputs:{input:e},backend:n,attrs:{dim:r}});return o.push(t),t}),backend:n,attrs:{axis:r}});return o.forEach(e=>n.disposeIntermediateTensorInfo(e)),c}};class x${constructor(e,t,n){this.variableNames=["x"],this.outputShape=t.map((t,n)=>t[0]+e[n]+t[1]);const s=e.length,r=cI(s),a=t.map(e=>e[0]).join(","),i=t.map((t,n)=>t[0]+e[n]).join(","),o=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,s);this.userCode=1!==s?`\n      ${r} start = ${r}(${a});\n      ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outC = getOutputCoords();\n        if (any(lessThan(outC, start)) || any(greaterThanEqual(outC, end))) {\n          setOutput(float(${n}));\n        } else {\n          ${r} coords = outC - start;\n          setOutput(getX(${o}));\n        }\n      }\n    `:`\n        int start = ${a};\n        int end = ${i};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start || outC >= end) {\n            setOutput(float(${n}));\n          } else {\n            setOutput(getX(outC - start));\n          }\n        }\n      `}}class w${constructor(e,t,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t.map((t,n)=>t[0]+e[n]+t[1]);const s=e.length,r=cI(s),a=t.map(e=>e[0]).join(","),i=t.map((t,n)=>t[0]+e[n]).join(","),o=GI("rc",s),l=GI("source",s),u=`${o[s-1]} < ${this.outputShape[s-1]}`,c=1===s?"source":`vec2(${l.slice(-2).join()})`,h=[r+" rc = outputLoc;",`${o[s-1]} += 1;\n       if(${u}) {\n      `,1===s?"":`}\n       rc = outputLoc;\n       ${o[s-2]} += 1;\n       if(${o[s-2]} < ${this.outputShape[s-2]}) {`,1===s?"":`  ${o[s-1]} += 1;\n         if(${u}) {`],p=1===s?"rc < start || rc >= end":"any(lessThan(rc, start)) || any(greaterThanEqual(rc, end))";let d="";for(let e=0,t=1===s?2:4;e<t;e++)d+=`\n        ${h[e]}\n        if (${p}) {\n          result[${e}] = float(${n});\n        } else {\n          ${r} source = rc - start;\n          result[${e}] = getChannel(getX(${l.join()}), ${c});\n        }\n      `;d+=1===s?"} ":"}}",this.userCode=`\n      const ${r} start = ${r}(${a});\n      const ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${d}\n        setOutput(result);\n      }\n    `}}const k$=e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,constantValue:i}=s,o=H().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new w$(r.shape,a,i):new x$(r.shape,a,i);return n.runWebGLProgram(o,[r],r.dtype)},v$={kernelName:"PadV2",backendName:"webgl",kernelFunc:k$},N$=bC({opSnippet:"\n  if(a < 0.0 && floor(b) < b){\n    return NAN;\n  }\n  if (b == 0.0) {\n    return 1.0;\n  }\n  return (round(mod(b, 2.0)) != 1) ?\n      pow(abs(a), b) : sign(a) * pow(abs(a), b);\n",packedOpSnippet:"\n  // isModRound1 has 1 for components with round(mod(b, 2.0)) == 1, 0 otherwise.\n  vec4 isModRound1 = vec4(equal(round(mod(b, 2.0)), ivec4(1)));\n  vec4 multiplier = sign(a) * isModRound1 + (vec4(1.0) - isModRound1);\n  vec4 result = multiplier * pow(abs(a), b);\n\n  // Ensure that a^0 = 1, including 0^0 = 1 as this correspond to TF and JS\n  bvec4 isExpZero = equal(b, vec4(0.0));\n  result.r = isExpZero.r ? 1.0 : result.r;\n  result.g = isExpZero.g ? 1.0 : result.g;\n  result.b = isExpZero.b ? 1.0 : result.b;\n  result.a = isExpZero.a ? 1.0 : result.a;\n\n  vec4 isNaN = vec4(lessThan(a, vec4(0.0))) * vec4(lessThan(floor(b), b));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),I$={kernelName:ne,backendName:"webgl",kernelFunc:N$};const C$={kernelName:"Prod",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=[],u=x(a,r.shape);let c=u;const h=fa(c,o);let d,f=r;if(null!=h&&(f=LC({inputs:{x:r},backend:n,attrs:{perm:h}}),c=ga(c.length,o),l.push(f)),da("prod",c,o),n.shouldExecuteOnCPU([f])){const e=n.texData.get(f.dataId).values,{outVals:t,outShape:s,outDtype:r}=FI(f.shape,f.dtype,e,c);d=n.makeTensorInfo(s,r,t)}else{const[e,t]=ha(f.shape,c),s=p(t),a=TC({inputs:{x:f},backend:n,attrs:{shape:[-1,s]}}),i=RC(a,Ve(r.dtype),"prod",n);d=TC({inputs:{x:i},backend:n,attrs:{shape:e}}),l.push(a),l.push(i)}if(i){l.push(d);const e=pa(d.shape,u);d=TC({inputs:{x:d},backend:n,attrs:{shape:e}})}return l.forEach(e=>n.disposeIntermediateTensorInfo(e)),d}},S$=e=>{const{backend:t,attrs:n}=e,{start:s,stop:r,step:a,dtype:i}=n,o=DI(s,r,a,i);return t.makeTensorInfo([o.length],i,o)},T$={kernelName:"Range",backendName:"webgl",kernelFunc:S$},E$={kernelName:"Reciprocal",backendName:"webgl",kernelFunc:yC({opSnippet:"return 1.0 / x;"})},$$={kernelName:"Relu",backendName:"webgl",kernelFunc:yC({opSnippet:"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n",packedOpSnippet:"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"})},A$={kernelName:"Relu6",backendName:"webgl",kernelFunc:yC({opSnippet:"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n",packedOpSnippet:"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"})};class R${constructor(e,t,n,s,r){this.variableNames=["A"],this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n];let h;h=r?"(vec2(yRC) + vec2(0.5)) * effectiveInputOverOutputRatioRC - vec2(0.5)":"vec2(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]});\n      const vec2 inputShapeRC = vec2(${i}.0, ${o}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = ${h};\n\n        // Compute the four integer indices.\n        ivec2 sourceFloorRC = ivec2(max(sourceFracIndexRC, vec2(0.0)));\n        ivec2 sourceCeilRC = ivec2(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        float topLeft = getA(b, sourceFloorRC.x, sourceFloorRC.y, d);\n        float bottomLeft = getA(b, sourceCeilRC.x, sourceFloorRC.y, d);\n        float topRight = getA(b, sourceFloorRC.x, sourceCeilRC.y, d);\n        float bottomRight = getA(b, sourceCeilRC.x, sourceCeilRC.y, d);\n\n        vec2 fracRC = sourceFracIndexRC - vec2(sourceFloorRC);\n\n        float top = topLeft + (topRight - topLeft) * fracRC.y;\n        float bottom = bottomLeft + (bottomRight - bottomLeft) * fracRC.y;\n        float newValue = top + (bottom - top) * fracRC.x;\n\n        setOutput(newValue);\n      }\n    `}}class F${constructor(e,t,n,s,r){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n];let h;h=r?"(vec3(yRC) + vec3(0.5)) * effectiveInputOverOutputRatioRC - vec3(0.5)":"vec3(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec3 effectiveInputOverOutputRatioRC = vec3(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]},\n          ${u[1]/c[1]});\n      const vec3 inputShapeRC = vec3(${i}.0, ${o}.0,\n                                     ${o}.0);\n\n      float getAValue(int b, int r, int c, int d) {\n        return getChannel(getA(b, r, c, d), vec2(c, d));\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        // Calculate values for next column in yRC.z.\n        ivec3 yRC = coords.yzz + ivec3(0, 0, 1);\n\n        // Fractional source index.\n        vec3 sourceFracIndexRC = ${h};\n\n        // Compute the four integer indices.\n        ivec3 sourceFloorRC = ivec3(max(sourceFracIndexRC, vec3(0.0)));\n        ivec3 sourceCeilRC = ivec3(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        // Should we calculate next column and row elements in 2x2 packed cell.\n        bool hasNextCol = d < ${l-1};\n        bool hasNextRow = coords.z < ${n-1};\n\n        // In parallel, construct four corners for all four components in\n        // packed 2x2 cell.\n        vec4 topLeft = vec4(\n          getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 bottomLeft = vec4(\n          getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 topRight = vec4(\n          getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec4 bottomRight = vec4(\n          getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec3 fracRC = sourceFracIndexRC - vec3(sourceFloorRC);\n\n        vec4 top = mix(topLeft, topRight, fracRC.yyzz);\n        vec4 bottom = mix(bottomLeft, bottomRight, fracRC.yyzz);\n        vec4 newValue = mix(top, bottom, fracRC.x);\n\n        setOutput(newValue);\n      }\n    `}}const D$={kernelName:"ResizeBilinear",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s,[l,u]=o,c=H().getBool("WEBGL_PACK_IMAGE_OPERATIONS")?new F$(r.shape,l,u,a,i):new R$(r.shape,l,u,a,i);return n.runWebGLProgram(c,[r],"float32")}};class _${constructor(e,t,n){this.variableNames=["dy"],this.outputShape=[],this.outputShape=t;const[,s,r]=t,[,a,i]=e,o=[n&&a>1?s-1:s,n&&i>1?r-1:r],l=[n&&a>1?a-1:a,n&&i>1?i-1:i],u=o[0]/l[0],c=o[1]/l[1],h=1/u,p=1/c,d=2*Math.ceil(h)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${u});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${h});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${d});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(startRLerp - float(winHeight / 2));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(startCLerp - float(winWidth / 2));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${a}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${i}) {\n              continue;\n            }\n\n            float dxR = float(dyR) * heightScale;\n            int topDxRIndex = int(floor(dxR));\n            int bottomDxRIndex = int(min(ceil(dxR), ${s-1}.0));\n            float dxRLerp = dxR - float(topDxRIndex);\n            float inverseDxRLerp = 1.0 - dxRLerp;\n\n            float dxC = float(dyC) * widthScale;\n            int leftDxCIndex = int(floor(dxC));\n            int rightDxCIndex = int(min(ceil(dxC), ${r-1}.0));\n            float dxCLerp = dxC - float(leftDxCIndex);\n            float inverseDxCLerp = 1.0 - dxCLerp;\n\n            if (r == topDxRIndex && c == leftDxCIndex) {\n              // topLeft\n              accumulator +=\n                getDy(b, dyR, dyC, d) * inverseDxRLerp * inverseDxCLerp;\n            }\n\n            if (r == topDxRIndex && c == rightDxCIndex) {\n              // topRight\n              accumulator += getDy(b, dyR, dyC, d) * inverseDxRLerp * dxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == leftDxCIndex) {\n              // bottomLeft\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * inverseDxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == rightDxCIndex) {\n              // bottomRight\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * dxCLerp;\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}const O$={kernelName:"ResizeBilinearGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s,o=new _$(a.shape,r.shape,i);return n.runWebGLProgram(o,[a],a.dtype)}};class M${constructor(e,t,n,s,r){this.variableNames=["A"],this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n],h=s?"0.5":"0.0";let p;p=r?"max((vec2(yRC) + vec2(0.5)) * effectiveInputOverOutputRatioRC, vec2(0.0))":"vec2(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]});\n      const vec2 inputShapeRC = vec2(${i}.0, ${o}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = ${p};\n\n        // Compute the coordinators of nearest neighbor point.\n        ivec2 sourceNearestRC = ivec2(\n          min(inputShapeRC - 1.0, floor(sourceFracIndexRC + ${h})));\n        float newValue = getA(b, sourceNearestRC.x, sourceNearestRC.y, d);\n\n        setOutput(newValue);\n      }\n    `}}const L$={kernelName:"ResizeNearestNeighbor",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s,[l,u]=o,c=new M$(r.shape,l,u,a,i);return n.runWebGLProgram(c,[r],r.dtype)}};class z${constructor(e,t,n){this.variableNames=["dy"],this.outputShape=[],this.outputShape=t;const[,s,r]=t,[,a,i]=e,o=[n&&a>1?s-1:s,n&&i>1?r-1:r],l=[n&&a>1?a-1:a,n&&i>1?i-1:i],u=o[0]/l[0],c=o[1]/l[1],h=1/u,p=1/c,d=2*Math.ceil(h)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${u});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${h});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${d});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(floor(startRLerp - float(winHeight / 2)));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(floor(startCLerp - float(winWidth / 2)));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${a}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${i}) {\n              continue;\n            }\n\n            float sourceFracRow =\n              float(${o[0]}) *\n                (float(dyR) / float(${l[0]}));\n\n            float sourceFracCol =\n                float(${o[1]}) *\n                  (float(dyC) / float(${l[1]}));\n\n            int sourceNearestRow = int(min(\n                float(int(${s}) - 1),\n                ${n} ? float(round(sourceFracRow)) :\n                                  float(floor(sourceFracRow))));\n\n            int sourceNearestCol = int(min(\n                float(int(${r}) - 1),\n                ${n} ? float(round(sourceFracCol)) :\n                                  float(floor(sourceFracCol))));\n\n            if (r == sourceNearestRow && c == sourceNearestCol) {\n              accumulator += getDy(b, dyR, dyC, d);\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}const B$={kernelName:"ResizeNearestNeighborGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s,o=new z$(a.shape,r.shape,i);return n.runWebGLProgram(o,[a],a.dtype)}};class P${constructor(e,t){this.variableNames=["x"];const n=e.length;if(n>4)throw new Error(`WebGL backend: Reverse of rank-${n} tensor is not yet supported`);if(this.outputShape=e,1===n)return void(this.userCode=`\n        void main() {\n          int coord = getOutputCoords();\n          setOutput(getX(${e[0]} - coord - 1));\n        }\n      `);const s=e.map((n,s)=>(n=>-1!==t.indexOf(n)&&1!==e[n]?`${e[n]} - coords[${n}] - 1`:`coords[${n}]`)(s)).join(","),r=cI(n);this.userCode=`\n      void main() {\n        ${r} coords = getOutputCoords();\n        setOutput(getX(${s}));\n      }\n    `}}class W${constructor(e,t){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0;const n=e.length;if(n>4)throw new Error(`WebGL backend: Reverse of rank-${n} tensor is not yet supported`);this.outputShape=e;const s=GI("rc",n),r=`${s[n-1]} + 1 < ${this.outputShape[n-1]}`,a=`${s[n-2]} + 1 < ${this.outputShape[n-2]}`,i=cI(n);function o(n){const s=e.map((s,r)=>function(n,s){return-1!==t.indexOf(n)&&1!==e[n]?`${e[n]} - ${s[n]} - 1`:""+s[n]}(r,n));return`getChannel(getX(${s.join(",")}), vec2(${s.slice(-2).join(",")}))`}this.userCode=1===n?`\n        void main(){\n          int rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = getChannel(getX(${e[0]} - rc - 1),\n            ${e[0]} - rc - 1);\n          if(${r}){\n              result.g = getChannel(getX(${e[0]} - (rc  + 1) - 1),\n                ${e[0]} - (rc  + 1) - 1);\n          }\n          setOutput(result);\n        }\n      `:`\n        void main() {\n          ${i} rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = ${function(e){return o(e)}(s.slice())};\n          if(${r}){\n            result.g = ${function(e){return e[n-1]="("+e[n-1]+" + 1)",o(e)}(s.slice())};\n          }\n          if(${a}) {\n            result.b = ${function(e){return e[n-2]="("+e[n-2]+" + 1)",o(e)}(s.slice())};\n            if(${r}) {\n              result.a = ${function(e){return e[n-1]="("+e[n-1]+" + 1)",e[n-2]="("+e[n-2]+" + 1)",o(e)}(s.slice())};\n            }\n          }\n          setOutput(result);\n        }\n    `}}const V$={kernelName:"Reverse",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dims:a}=s,i=r.shape.length,o=x(a,r.shape);if(0===i)return oC({inputs:{x:r},backend:n});const l=H().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new W$(r.shape,o):new P$(r.shape,o);return n.runWebGLProgram(l,[r],r.dtype)}};class U${constructor(e,t,n,s){this.variableNames=["Image"],this.outputShape=[];const r=e[1],a=e[2],i=Math.sin(t).toFixed(3),o=Math.cos(t).toFixed(3);this.outputShape=e;const[l,u]=Rl(s,r,a),c=l.toFixed(3),h=u.toFixed(3);let p="";p="number"==typeof n?`float outputValue = ${n.toFixed(2)};`:`\n        vec3 fill = vec3(${n.join(",")});\n        float outputValue = fill[coords[3]];`,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n          int y = coords[1];\n          float coordXFloat = (float(x) - ${c}) * ${o} - (float(y) - ${h}) * ${i};\n          float coordYFloat = (float(x) - ${c}) * ${i} + (float(y) - ${h}) * ${o};\n          int coordX = int(round(coordXFloat + ${c}));\n          int coordY = int(round(coordYFloat + ${h}));\n          ${p}\n          if(coordX >= 0 && coordX < ${a} && coordY >= 0 && coordY < ${r}) {\n            outputValue = getImage(coords[0], coordY, coordX, coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const G$={kernelName:"RotateWithOffset",backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,{radians:r,fillValue:a,center:i}=t,o=n,l=new U$(s.shape,r,a,i);return o.runWebGLProgram(l,[s],s.dtype)}},H$={kernelName:"Round",backendName:"webgl",kernelFunc:yC({opSnippet:"\n  // OpenGL ES does not support round function.\n  // The algorithm is based on banker's rounding.\n  float base = floor(x);\n  if ((x - base) < 0.5) {\n    return floor(x);\n  } else if ((x - base) > 0.5) {\n    return ceil(x);\n  } else {\n    if (mod(base, 2.0) == 0.0) {\n      return base;\n    } else {\n      return base + 1.0;\n    }\n  }\n"})},j$={kernelName:"Rsqrt",backendName:"webgl",kernelFunc:yC({opSnippet:"return inversesqrt(x);",cpuKernelImpl:_I})};class q${constructor(e,t,n,s,r,a,i=!0){this.variableNames=["updates","indices","defaultValue"],this.outputShape=a;const o=cI(r.length),l=cI(a.length);let u="";1===n?u="i":2===n&&(u="i, j");const c=`getIndices(${u})`;let h="";1===s?h="i":2===s&&(h="i, coords[1]");const p=`getUpdates(${h})`,d=t>1?"strides[j]":"strides";this.userCode=`\n        ${o} strides = ${o}(${r});\n\n        void main() {\n          ${l} coords = getOutputCoords();\n          float sum = 0.0;\n          bool found = false;\n          for (int i = 0; i < ${e}; i++) {\n            int flattenedIndex = 0;\n            for (int j = 0; j < ${t}; j++) {\n              int index = round(${c});\n              flattenedIndex += index * ${d};\n            }\n            if (flattenedIndex == coords[0]) {\n              sum += ${p};\n              found = true;\n            }\n          }\n          setOutput(mix(getDefaultValue(), sum, float(found)));\n        }\n      `}}const K$={kernelName:"ScatterNd",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r,updates:a}=t,{shape:i}=s,{sliceRank:o,numUpdates:l,sliceSize:u,strides:c,outputSize:h}=Tn(0,r,i),p=[h/u,u];if(0===h)return n.makeTensorInfo(i,r.dtype);const d=TC({inputs:{x:r},backend:n,attrs:{shape:[l,o]}}),f=TC({inputs:{x:a},backend:n,attrs:{shape:[l,u]}}),m=n.makeTensorInfo([],"float32",new Float32Array([0])),g=new q$(l,o,d.shape.length,f.shape.length,c,p),y=n.runWebGLProgram(g,[f,d,m],f.dtype),b=TC({inputs:{x:y},backend:n,attrs:{shape:i}});return n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(y),n.disposeIntermediateTensorInfo(m),b}};class X${constructor(e,t,n){let s,r;if(this.variableNames=["c","a","b"],this.outputShape=t,n>4)throw Error(`Where for rank ${n} is not yet supported`);if(1===n)r="resRC",s="resRC";else{const n=["resRC.x","resRC.y","resRC.z","resRC.w"],a=[],i=[];for(let s=0;s<t.length;s++)i.push(""+n[s]),s<e&&a.push(""+n[s]);s=a.join(),r=i.join()}const a=cI(n);this.userCode=`\n      void main() {\n        ${a} resRC = getOutputCoords();\n        float cVal = getC(${s});\n        if (cVal >= 1.0) {\n          setOutput(getA(${r}));\n        } else {\n          setOutput(getB(${r}));\n        }\n      }\n    `}}const Y$={kernelName:"Select",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{condition:s,t:r,e:a}=t,i=new X$(s.shape.length,r.shape,r.shape.length);return n.runWebGLProgram(i,[s,r,a],We(r.dtype,a.dtype))}},J$={kernelName:"Selu",backendName:"webgl",kernelFunc:yC({opSnippet:`\n  // Stable and Attracting Fixed Point (0, 1) for Normalized Weights.\n  // see: https://arxiv.org/abs/1706.02515\n  float scaleAlpha = 1.7580993408473768;\n  float scale = ${Ll};\n  return (x >= 0.0) ? scale * x : scaleAlpha * (exp(x) - 1.0);\n`})},Z$={kernelName:"Sigmoid",backendName:"webgl",kernelFunc:yC({opSnippet:"return 1.0 / (1.0 + exp(-1.0 * x));"})},Q$={kernelName:"Sign",backendName:"webgl",kernelFunc:yC({opSnippet:"\n  if (isnan(x)) { return 0.0; }\n  return sign(x);\n"})},eA=yC({opSnippet:"if (isnan(x)) return x;\n  return sin(x);\n"}),tA={kernelName:se,backendName:"webgl",kernelFunc:eA},nA={kernelName:"Sinh",backendName:"webgl",kernelFunc:yC({opSnippet:"\n  float e2x = exp(x);\n  return (e2x - 1.0 / e2x) / 2.0;\n"})},sA={kernelName:"Softplus",backendName:"webgl",kernelFunc:yC({opSnippet:"\n  float epsilon = 1.1920928955078125e-7;\n  float threshold = log(epsilon) + 2.0;\n\n  bool too_large = x > -threshold;\n  bool too_small = x < threshold;\n\n  float result;\n  float exp_x = exp(x);\n\n  if (too_large){\n    result = x;\n  }\n  else if (too_small){\n    result = exp_x;\n  }\n  else{\n    result = log(exp_x + 1.0);\n  }\n  return result;\n"})},rA={kernelName:"SpaceToBatchND",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,paddings:i}=s;l(r.shape.length<=4,()=>"spaceToBatchND for rank > 4 with a WebGL backend not implemented yet");const o=a.reduce((e,t)=>e*t),u=[[0,0]];u.push(...i);for(let e=1+a.length;e<r.shape.length;++e)u.push([0,0]);const c=[],h=k$({inputs:{x:r},backend:n,attrs:{paddings:u,constantValue:0}}),p=Fl(h.shape,a,o,!1),d=Dl(p.length,a.length,!1),f=_l(h.shape,a,o,!1),m=TC({inputs:{x:h},backend:n,attrs:{shape:p}}),g=LC({inputs:{x:m},backend:n,attrs:{perm:d}}),y=TC({inputs:{x:g},backend:n,attrs:{shape:f}});return c.push(h),c.push(m),c.push(g),c.forEach(e=>n.disposeIntermediateTensorInfo(e)),y}};const aA={kernelName:"SparseToDense",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{sparseIndices:r,sparseValues:a,defaultValue:i}=t,{outputShape:o}=s,{sliceRank:l,numUpdates:u,strides:c,outputSize:h}=Tn(0,r,o),p=new q$(u,l,r.shape.length,a.shape.length,c,[h,1],!1),d=n.runWebGLProgram(p,[a,r,i],a.dtype),f=TC({inputs:{x:d},backend:n,attrs:{shape:o}});return n.disposeIntermediateTensorInfo(d),f}};const iA={kernelName:"SplitV",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{numOrSizeSplits:a,axis:i}=s,o=x(i,r.shape)[0],l=ql(r,a,o),u=r.shape.length,c=new Array(u).fill(0),h=r.shape.slice();return l.map(e=>{const t=[...h];t[o]=e;const s=NS({inputs:{x:r},backend:n,attrs:{begin:c,size:t}});return c[o]+=e,s})}},oA={kernelName:"Sqrt",backendName:"webgl",kernelFunc:yC({opSnippet:"return sqrt(x);"})},lA={kernelName:"Square",backendName:"webgl",kernelFunc:yC({opSnippet:"return x * x;"})},uA={kernelName:"SquaredDifference",backendName:"webgl",kernelFunc:bC({opSnippet:"return (a - b) * (a - b);",packedOpSnippet:"return (a - b) * (a - b);"})};const cA={kernelName:"Step",backendName:"webgl",kernelFunc:function({inputs:e,attrs:t,backend:n}){const{x:s}=e,r=`if (isnan(x)) return x;\n    return x > 0.0 ? 1.0 : float(${t.alpha});\n  `,a=new JI(s.shape,r);return n.runWebGLProgram(a,[s],s.dtype)}};class hA{constructor(e,t,n){this.variableNames=["x"],this.outputShape=n;const s=n.length,r=cI(n.length),a=cI(n.length);let i="";if(1===s)i="coords * strides + begin";else{let e=0;i=n.map((t,s)=>(e++,1===n.length?`coords * strides[${s}] + begin[${s}]`:`coords[${e-1}] * strides[${s}] + begin[${s}]`)).join(",")}this.userCode=`\n      ${r} begin = ${r}(${e});\n      ${r} strides = ${r}(${t});\n\n      void main() {\n        ${a} coords = getOutputCoords();\n        setOutput(getX(${i}));\n      }\n    `}}const pA={kernelName:"StridedSlice",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,end:i,strides:o,beginMask:l,endMask:u,ellipsisMask:c,newAxisMask:h,shrinkAxisMask:p}=s,{nonStrided:d,$begin:f,$strides:m,size:g,newShape:y,outShape:b}=Gn(r.shape,a,i,o,l,u,c,h,p),x=TC({inputs:{x:r},backend:n,attrs:{shape:y}});let w;if(d){const e=NS({inputs:{x:x},backend:n,attrs:{begin:f,size:g}});w=TC({inputs:{x:e},backend:n,attrs:{shape:b}}),n.disposeIntermediateTensorInfo(e)}else if(b.some(e=>0===e))w=n.makeTensorInfo(b,r.dtype,[]);else{if(n.shouldExecuteOnCPU([x])){const e=n.texData.get(x.dataId).values,t=Kt(x.shape,x.dtype,e),s=LI(b,t,m,f);w=n.makeTensorInfo(b,x.dtype,s.values)}else{const e=new hA(f,m,b);w=n.runWebGLProgram(e,[x],x.dtype)}}const k=TC({inputs:{x:w},backend:n,attrs:{shape:b}});return n.disposeIntermediateTensorInfo(x),n.disposeIntermediateTensorInfo(w),k}},dA=yC({opSnippet:"return tan(x);"}),fA={kernelName:ae,backendName:"webgl",kernelFunc:dA},mA={kernelName:"Tanh",backendName:"webgl",kernelFunc:yC({opSnippet:"\n  float e2x = exp(-2.0 * abs(x));\n  return sign(x) * (1.0 - e2x) / (1.0 + e2x);\n"})};class gA{constructor(e,t){this.variableNames=["A"];const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[s]*t[s];this.outputShape=n,this.rank=n.length;const s=cI(this.rank),r=function(e){const t=e.length;if(t>5)throw Error(`Tile for rank ${t} is not yet supported`);if(1===t)return`imod(resRC, ${e[0]})`;const n=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u"],s=[];for(let t=0;t<e.length;t++)s.push(`imod(${n[t]}, ${e[t]})`);return s.join()}(e);this.userCode=`\n      void main() {\n        ${s} resRC = getOutputCoords();\n        setOutput(getA(${r}));\n      }\n    `}}function yA(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reps:a}=s;if("string"===r.dtype){const e=n.readSync(r.dataId).map(e=>xe(e)),t=Kt(r.shape,r.dtype,e),s=BI(t,a);return n.makeTensorInfo(s.shape,s.dtype,s.values)}const i=new gA(r.shape,a);return n.runWebGLProgram(i,[r],r.dtype)}const bA={kernelName:"Tile",backendName:"webgl",kernelFunc:yA};const xA={kernelName:"TopK",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{k:a,sorted:i}=s,o=n.readSync(r.dataId),[l,u]=PI(o,r.shape,r.dtype,a,i);return[n.makeTensorInfo(l.shape,l.dtype,l.values),n.makeTensorInfo(u.shape,u.dtype,u.values)]}};const wA={kernelName:"Unique",backendName:"webgl",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{axis:r}=n,{x:a}=t;AN(a,"unique"),console.warn("WARNING: ","UI might be locked temporarily as data is being downloaded");const i=s.readSync(a.dataId),{outputValues:o,outputShape:l,indices:u}=VI(i,r,a.shape,a.dtype);return[s.makeTensorInfo(l,a.dtype,o),s.makeTensorInfo([u.length],"int32",u)]}};const kA={kernelName:"Unpack",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{value:r}=t;let{axis:a}=s;a<0&&(a+=r.shape.length);const i=r,o=i.shape.length,l=r.shape[a],u=new Array(o-1);let c=0;for(let e=0;e<o;e++)e!==a&&(u[c++]=i.shape[e]);const h=[],p=new Array(o).fill(0),d=i.shape.slice();d[a]=1;const f=new Array(l);for(let e=0;e<f.length;e++){p[a]=e;const t=NS({inputs:{x:i},backend:n,attrs:{begin:p,size:d}}),s=TC({inputs:{x:t},backend:n,attrs:{shape:u}});f[e]=s,h.push(t)}return h.forEach(e=>n.disposeIntermediateTensorInfo(e)),f}};class vA{constructor(e,t){this.variableNames=["x","segmentIds"];const n=e.windowSize,s=e.batchSize,r=e.inSize,a=e.numSegments,i=a*Math.ceil(r/n);this.outputShape=[s,i];const o=4*Math.floor(n/4),l=n%4,u="\n        sumValue += dot(values, segFilter);\n    ";let c="";r%n>0&&(c=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return initializationValue;\n        }\n      `);let h="";r%n>0&&(h=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return -1.0;\n        }\n      `),this.userCode=`\n      const float initializationValue = 0.0;\n\n      float getValue(int batch, int inIdx) {\n        ${c}\n        return getX(batch, inIdx);\n      }\n\n      float getSegmentIdAtIndex(int inIdx) {\n        ${h}\n        return getSegmentIds(inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = int(floor(float(outIdx) / float(\n          ${a})) * float(${n}));\n        int currentSeg = int(mod(float(outIdx), float(${a})));\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${o}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 3)) == currentSeg ? 1 : 0\n          );\n\n          ${u}\n        }\n\n        int inIdx = inOffset + ${o};\n        if (${1===l}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          int inIdxSeg = int(getSegmentIdAtIndex(inIdx));\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            0,\n            0,\n            0\n          );\n\n          ${u}\n        } else if (${2===l}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n              0,\n              0\n          );\n\n          ${u}\n        } else if (${3===l}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            0\n          );\n\n          ${u}\n        }\n        setOutput(sumValue);\n      }\n    `}}const NA=[$E,RE,PC,WC,VC,UC,jC,XC,YC,JC,tS,nS,sS,rS,iS,aS,oS,hS,cS,fS,mS,gS,xS,CS,SS,RS,DS,MS,BS,cC,qS,rT,aT,QS,oT,lT,iT,cT,hT,dT,yT,bT,wT,ST,TT,NT,$T,RT,DT,_T,OT,LT,PT,VT,GT,qT,YT,ZT,eE,tE,rE,iE,oE,uE,hE,pE,dE,lC,fE,GS,mE,gE,yE,dC,bE,xE,wE,NE,vE,IE,CE,SE,DE,ME,OE,BE,PE,WE,_E,VE,UE,GE,qE,XE,r$,SC,i$,l$,c$,p$,ES,f$,y$,b$,v$,I$,gC,C$,T$,AS,ZE,E$,A$,$$,EC,D$,O$,L$,B$,V$,G$,H$,j$,K$,Y$,J$,Z$,Q$,tA,nA,IS,s$,sA,rA,aA,iA,oA,lA,uA,cA,pA,t$,MC,fA,mA,bA,xA,zC,wA,kA,{kernelName:"UnsortedSegmentSum",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,segmentIds:a}=t,{numSegments:i}=s,o=r.shape.length,l=[];let u=0;const c=fa([u],o);let h=r;null!=c&&(h=LC({inputs:{x:r},backend:n,attrs:{perm:c}}),l.push(h),u=ga(1,o)[0]);const d=Xl(h.shape,u,i),f=p([h.shape[u]]),m=TC({inputs:{x:h},backend:n,attrs:{shape:[-1,f]}});l.push(m);const g=Ve(r.dtype),y=(e,t,s,r,a)=>{const i=e.shape[0],o=e.shape[1],u=Kl(o,a),c=new vA({windowSize:u,inSize:o,batchSize:i,numSegments:a},t),h=n.compileAndRun(c,[e,s],r);if(l.push(h),h.shape[1]===a)return h;const p=S$({backend:n,attrs:{start:0,stop:a,step:1,dtype:"float32"}}),d=yA({inputs:{x:p},backend:n,attrs:{reps:[o/u]}});return l.push(p),l.push(d),y(h,t,d,r,a)},b=TC({inputs:{x:y(m,"unsortedSegmentSum",a,g,i)},backend:n,attrs:{shape:d}});let x=b;if(null!=c){l.push(b);const e=ma(c);x=LC({inputs:{x:x},backend:n,attrs:{perm:e}})}return l.forEach(e=>n.disposeIntermediateTensorInfo(e)),x}},g$];for(const e of NA)he(e);const IA={"tfjs-core":"3.0.0","tfjs-backend-cpu":"3.0.0","tfjs-backend-webgl":"3.0.0","tfjs-data":"3.0.0","tfjs-layers":"3.0.0","tfjs-converter":"3.0.0",tfjs:"3.0.0"};e.Abs="Abs",e.Acos="Acos",e.Acosh="Acosh",e.AdadeltaOptimizer=yl,e.AdagradOptimizer=bl,e.AdamOptimizer=xl,e.AdamaxOptimizer=wl,e.Add=X,e.AddN="AddN",e.All="All",e.Any="Any",e.ArgMax="ArgMax",e.ArgMin="ArgMin",e.Asin="Asin",e.Asinh="Asinh",e.Atan="Atan",e.Atan2="Atan2",e.Atanh="Atanh",e.AvgPool="AvgPool",e.AvgPool3D="AvgPool3D",e.AvgPool3DGrad="AvgPool3DGrad",e.AvgPoolGrad="AvgPoolGrad",e.BatchMatMul="BatchMatMul",e.BatchToSpaceND="BatchToSpaceND",e.Bincount="Bincount",e.BroadcastTo="BroadcastTo",e.Callback=ig,e.CallbackList=Np,e.Cast="Cast",e.Ceil="Ceil",e.ClipByValue="ClipByValue",e.Complex="Complex",e.ComplexAbs="ComplexAbs",e.Concat="Concat",e.Conv2D="Conv2D",e.Conv2DBackpropFilter="Conv2DBackpropFilter",e.Conv2DBackpropInput="Conv2DBackpropInput",e.Conv3D="Conv3D",e.Conv3DBackpropFilterV2="Conv3DBackpropFilterV2",e.Conv3DBackpropInputV2="Conv3DBackpropInputV2",e.Cos=Y,e.Cosh="Cosh",e.CropAndResize="CropAndResize",e.Cumsum="Cumsum",e.CustomCallback=Sp,e.DataStorage=t,e.DenseBincount="DenseBincount",e.DepthToSpace="DepthToSpace",e.DepthwiseConv2dNative="DepthwiseConv2dNative",e.DepthwiseConv2dNativeBackpropFilter="DepthwiseConv2dNativeBackpropFilter",e.DepthwiseConv2dNativeBackpropInput="DepthwiseConv2dNativeBackpropInput",e.Diag="Diag",e.Dilation2D="Dilation2D",e.Dilation2DBackpropFilter="Dilation2DBackpropFilter",e.Dilation2DBackpropInput="Dilation2DBackpropInput",e.EarlyStopping=ug,e.Elu=J,e.EluGrad="EluGrad",e.Environment=G,e.Equal="Equal",e.Erf=Z,e.Exp=Q,e.ExpandDims="ExpandDims",e.Expm1="Expm1",e.FFT="FFT",e.Fill="Fill",e.FlipLeftRight="FlipLeftRight",e.Floor="Floor",e.FloorDiv="FloorDiv",e.FromPixels="FromPixels",e.FusedBatchNorm="FusedBatchNorm",e.FusedConv2D="FusedConv2D",e.FusedDepthwiseConv2D="FusedDepthwiseConv2D",e.GatherNd="GatherNd",e.GatherV2="GatherV2",e.GraphModel=xy,e.Greater="Greater",e.GreaterEqual="GreaterEqual",e.History=Cp,e.IFFT="IFFT",e.Identity="Identity",e.Imag="Imag",e.InputSpec=hp,e.IsFinite="IsFinite",e.IsInf="IsInf",e.IsNan="IsNan",e.KernelBackend=n,e.LRN="LRN",e.LRNGrad="LRNGrad",e.LayerVariable=lp,e.LayersModel=Od,e.LeakyRelu="LeakyRelu",e.Less="Less",e.LessEqual="LessEqual",e.LinSpace="LinSpace",e.Log=ee,e.Log1p="Log1p",e.LogSoftmax="LogSoftmax",e.LogicalAnd="LogicalAnd",e.LogicalNot="LogicalNot",e.LogicalOr="LogicalOr",e.Max="Max",e.MaxPool="MaxPool",e.MaxPool3D="MaxPool3D",e.MaxPool3DGrad="MaxPool3DGrad",e.MaxPoolGrad="MaxPoolGrad",e.MaxPoolWithArgmax="MaxPoolWithArgmax",e.Maximum="Maximum",e.Mean="Mean",e.Min="Min",e.Minimum="Minimum",e.MirrorPad="MirrorPad",e.Mod=te,e.MomentumOptimizer=vl,e.Multinomial="Multinomial",e.Multiply="Multiply",e.Neg="Neg",e.NonMaxSuppressionV3="NonMaxSuppressionV3",e.NonMaxSuppressionV4="NonMaxSuppressionV4",e.NonMaxSuppressionV5="NonMaxSuppressionV5",e.NotEqual="NotEqual",e.OP_SCOPE_SUFFIX="__op",e.OneHot="OneHot",e.OnesLike="OnesLike",e.Optimizer=gl,e.Pack="Pack",e.PadV2="PadV2",e.Pool="Pool",e.Pow=ne,e.Prelu="Prelu",e.Prod="Prod",e.RMSPropOptimizer=Nl,e.RNN=zf,e.Range="Range",e.Real="Real",e.RealDiv="RealDiv",e.Reciprocal="Reciprocal",e.Relu="Relu",e.Relu6="Relu6",e.Reshape="Reshape",e.ResizeBilinear="ResizeBilinear",e.ResizeBilinearGrad="ResizeBilinearGrad",e.ResizeNearestNeighbor="ResizeNearestNeighbor",e.ResizeNearestNeighborGrad="ResizeNearestNeighborGrad",e.Reverse="Reverse",e.RotateWithOffset="RotateWithOffset",e.Round="Round",e.Rsqrt="Rsqrt",e.SGDOptimizer=kl,e.ScatterNd="ScatterNd",e.Select="Select",e.Selu="Selu",e.Sequential=zd,e.Sigmoid="Sigmoid",e.Sign="Sign",e.Sin=se,e.Sinh="Sinh",e.Slice="Slice",e.Softmax="Softmax",e.Softplus="Softplus",e.SpaceToBatchND="SpaceToBatchND",e.SparseToDense="SparseToDense",e.SplitV="SplitV",e.Sqrt="Sqrt",e.Square="Square",e.SquaredDifference="SquaredDifference",e.Step="Step",e.StridedSlice="StridedSlice",e.Sub=re,e.Sum="Sum",e.SymbolicTensor=pp,e.Tan=ae,e.Tanh="Tanh",e.Tensor=Fe,e.TensorBuffer=Ee,e.Tile="Tile",e.TopK="TopK",e.Transpose="Transpose",e.Unique="Unique",e.Unpack="Unpack",e.UnsortedSegmentSum="UnsortedSegmentSum",e.Variable=_e,e.ZerosLike="ZerosLike",e._FusedMatMul="_FusedMatMul",e.abs=fs,e.acos=ms,e.acosh=gs,e.add=cs,e.addN=ys,e.all=bs,e.any=xs,e.argMax=ws,e.argMin=ks,e.asin=vs,e.asinh=Ns,e.atan=Is,e.atan2=Cs,e.atanh=Ss,e.avgPool=Ws,e.avgPool3d=Vs,e.backend=us,e.backend_util=eu,e.basicLSTMCell=qs,e.batchNorm=Xs,e.batchNorm2d=Ys,e.batchNorm3d=Js,e.batchNorm4d=Zs,e.batchToSpaceND=Ks,e.bincount=Qs,e.booleanMaskAsync=ro,e.broadcastTo=er,e.browser=vn,e.buffer=Kt,e.callbacks=cg,e.cast=Xt,e.ceil=tr,e.clipByValue=nr,e.clone=Yt,e.complex=ut,e.concat=Us,e.concat1d=sr,e.concat2d=rr,e.concat3d=ar,e.concat4d=ir,e.constraints=qc,e.conv1d=lr,e.conv2d=or,e.conv2dTranspose=cr,e.conv3d=hr,e.conv3dTranspose=dr,e.copyRegisteredKernels=function(e,t){ce(e).forEach(e=>{he(Object.assign({},e,{backendName:t}))})},e.cos=fr,e.cosh=mr,e.cosineWindow=po,e.cumsum=gr,e.customGrad=ea,e.data=wb,e.denseBincount=yr,e.deprecationWarn=ts,e.depthToSpace=br,e.depthwiseConv2d=xr,e.deregisterOp=function(e){delete dg[e]},e.device_util=nt,e.diag=wr,e.dilation2d=kr,e.disableDeprecationWarnings=function(){H().set("DEPRECATION_WARNINGS_ENABLED",!1),console.warn("TensorFlow.js deprecation warnings have been disabled.")},e.dispose=as,e.disposeVariables=function(){Ze.disposeVariables()},e.div=ps,e.divNoNan=Er,e.dot=$r,e.dropout=co,e.elu=Ar,e.enableDebugMode=function(){H().set("DEBUG",!0)},e.enableProdMode=function(){H().set("PROD",!0)},e.enclosingPowerOfTwo=ho,e.engine=ns,e.env=H,e.equal=Cr,e.erf=Rr,e.exp=Fr,e.expandDims=Dr,e.expm1=_r,e.eye=Mr,e.fft=Mi,e.fill=Lr,e.findBackend=function(e){return Ze.findBackend(e)},e.findBackendFactory=function(e){return Ze.findBackendFactory(e)},e.floor=zr,e.floorDiv=hs,e.fused=Co,e.gather=Br,e.gatherND=uo,e.gather_util=In,e.getBackend=function(){return Ze.backendName},e.getGradient=ue,e.getKernel=le,e.getKernelsForBackend=ce,e.grad=function(e){return l(D(e),()=>"The f passed in grad(f) must be a function"),(t,n)=>{const s=it(t,"x","tf.grad","string_or_numeric"),r=null!=n?it(n,"dy","tf.grad"):null;return Ze.tidy(()=>{const{value:t,grads:n}=Ze.gradients(()=>e(s),[s],r);return null!=r&&u(t.shape,r.shape,"The shape of dy passed in grad(f)(x, dy) must match the shape returned by f(x)"),ta(n),n[0]})}},e.grads=function(e){return l(D(e),()=>"The f passed in grads(f) must be a function"),(t,n)=>{l(Array.isArray(t),()=>"The args passed in grads(f)(args) must be an array of `Tensor`s or `TensorLike`s");const s=ot(t,"args","tf.grads","string_or_numeric"),r=null!=n?it(n,"dy","tf.grads"):null;return Ze.tidy(()=>{const{value:t,grads:n}=Ze.gradients(()=>e(...s),s,r);return null!=r&&u(t.shape,r.shape,"The shape of dy passed in grads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),ta(n),n})}},e.greater=Pr,e.greaterEqual=Wr,e.ifft=Li,e.imag=Vr,e.image=dl,e.inTopKAsync=fo,e.initializers=Zh,e.input=Bd,e.io=dn,e.irfft=zi,e.isFinite=Ur,e.isInf=Gr,e.isNaN=Hr,e.keep=is,e.kernel_impls=tu,e.layers=ng,e.leakyRelu=jr,e.less=qr,e.lessEqual=Kr,e.linalg=fl,e.linspace=Xr,e.loadGraphModel=async function(e,t={}){if(null==e)throw new Error("modelUrl in loadGraphModel() cannot be null. Please provide a url or an IOHandler that loads the model");null==t&&(t={}),t.fromTFHub&&null==e.load&&(e.endsWith("/")||(e+="/"),e+="model.json?tfjs-format=file");const n=new xy(e,t);return await n.load(),n},e.loadLayersModel=function(e,t){return null==t&&(t={}),Ld(e,t)},e.localResponseNormalization=Yr,e.log=Jr,e.log1p=Zr,e.logSigmoid=ra,e.logSoftmax=la,e.logSumExp=ya,e.logicalAnd=ba,e.logicalNot=xa,e.logicalOr=wa,e.logicalXor=ka,e.losses=ml,e.matMul=fn,e.math=bn,e.max=aa,e.maxPool=va,e.maxPool3d=Na,e.maxPoolWithArgmax=Ia,e.maximum=Ca,e.mean=Sa,e.memory=ss,e.metrics=sg,e.min=Ta,e.minimum=Ea,e.mirrorPad=$a,e.mod=Aa,e.model=function(e){return new Od(e)},e.models=rg,e.moments=Fa,e.movingAverage=io,e.mul=ds,e.multiRNNCell=Da,e.multinomial=_a,e.neg=na,e.nextFrame=Tl,e.norm=ao,e.notEqual=Oa,e.oneHot=mn,e.ones=La,e.onesLike=za,e.op=lt,e.outerProduct=Ba,e.pad=Pa,e.pad1d=Wa,e.pad2d=Va,e.pad3d=Ua,e.pad4d=Ga,e.pool=ja,e.pow=qa,e.prelu=Ka,e.print=Jt,e.prod=Xa,e.profile=function(e){return Ze.profile(e)},e.rand=Ya,e.randomGamma=ui,e.randomNormal=ci,e.randomUniform=hi,e.range=pi,e.ready=function(){return Ze.ready()},e.real=di,e.reciprocal=fi,e.registerBackend=ls,e.registerCallbackConstructor=function(e,t){Ep.registerCallbackConstructor(e,t)},e.registerGradient=pe,e.registerKernel=he,e.registerOp=function(e,t){const n={tfOpName:e,category:"custom",inputs:[],attrs:[],customExecutor:t};dg[e]=n},e.regularizers=ag,e.relu=mi,e.relu6=gi,e.removeBackend=function(e){Ze.removeBackend(e)},e.reshape=Ps,e.reverse=yi,e.reverse1d=bi,e.reverse2d=xi,e.reverse3d=wi,e.reverse4d=ki,e.rfft=Pi,e.round=vi,e.rsqrt=Ni,e.scalar=Ii,e.scatterND=oo,e.scatter_util=En,e.selu=Ci,e.separableConv2d=Si,e.sequential=function(e){return new zd(e)},e.serialization=Xn,e.setBackend=os,e.setPlatform=function(e,t){H().setPlatform(e,t)},e.setdiff1dAsync=Ti,e.sigmoid=Gs,e.sign=Ei,e.signal=pl,e.sin=$i,e.sinh=Ai,e.slice=Hs,e.slice1d=Ri,e.slice2d=Fi,e.slice3d=Di,e.slice4d=_i,e.slice_util=Hn,e.softmax=Oi,e.softplus=sa,e.spaceToBatchND=Ha,e.sparseToDense=lo,e.spectral=hl,e.split=Bi,e.sqrt=Wi,e.square=Ra,e.squaredDifference=Vi,e.squeeze=Ui,e.stack=Gi,e.step=Hi,e.stridedSlice=ji,e.sub=ia,e.sum=oa,e.sumOutType=Ve,e.tan=qi,e.tanh=js,e.tensor=ht,e.tensor1d=Ki,e.tensor2d=Xi,e.tensor3d=xn,e.tensor4d=function(e,t,n){if(c(e),null!=t&&4!==t.length)throw new Error("tensor4d() requires shape to have four numbers");const s=rt(e,n);if(4!==s.length&&1!==s.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return ct(e,t,s,n)},e.tensor5d=function(e,t,n){if(c(e),null!=t&&5!==t.length)throw new Error("tensor5d() requires shape to have five numbers");const s=rt(e,n);if(5!==s.length&&1!==s.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return ct(e,t,s,n)},e.tensor6d=function(e,t,n){if(c(e),null!=t&&6!==t.length)throw new Error("tensor6d() requires shape to have six numbers");const s=rt(e,n);if(6!==s.length&&1!==s.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return ct(e,t=t||s,s,n)},e.tensor_util=qe,e.test_util=es,e.tidy=rs,e.tile=Or,e.time=function(e){return Ze.time(e)},e.topk=Yi,e.train=Cl,e.transpose=gn,e.truncatedNormal=Ji,e.unique=Zi,e.unregisterGradient=function(e){if(!oe.has(e))throw new Error(`The gradient '${e}' for backend is not registered`);oe.delete(e)},e.unregisterKernel=function(e,t){const n=de(e,t);if(!ie.has(n))throw new Error(`The kernel '${e}' for backend '${t}' is not registered`);ie.delete(n)},e.unsortedSegmentSum=Qi,e.unstack=eo,e.upcastType=We,e.util=we,e.valueAndGrad=function(e){return l(D(e),()=>"The f passed in valueAndGrad(f) must be a function"),(t,n)=>{l(t instanceof Fe,()=>"The x passed in valueAndGrad(f)(x) must be a tensor"),l(null==n||n instanceof Fe,()=>"The dy passed in valueAndGrad(f)(x, dy) must be a tensor");const{grads:s,value:r}=Ze.gradients(()=>e(t),[t],n);return ta(s),{grad:s[0],value:r}}},e.valueAndGrads=function(e){return l(D(e),()=>"The f passed in valueAndGrads(f) must be a function"),(t,n)=>{l(Array.isArray(t)&&t.every(e=>e instanceof Fe),()=>"The args passed in valueAndGrads(f)(args) must be array of tensors"),l(null==n||n instanceof Fe,()=>"The dy passed in valueAndGrads(f)(args, dy) must be a tensor");const s=Ze.gradients(()=>e(...t),t,n);return null!=n&&u(s.value.shape,n.shape,"The shape of dy passed in valueAndGrads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),ta(s.grads),s}},e.variable=to,e.variableGrads=Qr,e.version=IA,e.version_converter="3.0.0",e.version_core="3.0.0",e.version_layers="3.0.0",e.where=Sr,e.whereAsync=so,e.zeros=Ma,e.zerosLike=Tr,Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf.es2017.min.js.map
