/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(global = global || self, factory(global.tf = global.tf || {}));
}(this, (function (exports) { 'use strict';

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function unwrapExports (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function createCommonjsModule(fn, module) {
		return module = { exports: {} }, fn(module, module.exports), module.exports;
	}

	function getCjsExportFromNamespace (n) {
		return n && n['default'] || n;
	}

	function commonjsRequire () {
		throw new Error('Dynamic requires are not currently supported by @rollup/plugin-commonjs');
	}

	var check = function check(it) {
	  return it && it.Math == Math && it;
	}; // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028


	var global_1 = // eslint-disable-next-line no-undef
	check(typeof globalThis == 'object' && globalThis) || check(typeof window == 'object' && window) || check(typeof self == 'object' && self) || check(typeof commonjsGlobal == 'object' && commonjsGlobal) || // eslint-disable-next-line no-new-func
	Function('return this')();

	var fails = function fails(exec) {
	  try {
	    return !!exec();
	  } catch (error) {
	    return true;
	  }
	};

	var descriptors = !fails(function () {
	  return Object.defineProperty({}, 1, {
	    get: function get() {
	      return 7;
	    }
	  })[1] != 7;
	});

	'use strict';

	var nativePropertyIsEnumerable = {}.propertyIsEnumerable;
	var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor; // Nashorn ~ JDK8 bug

	var NASHORN_BUG = getOwnPropertyDescriptor && !nativePropertyIsEnumerable.call({
	  1: 2
	}, 1); // `Object.prototype.propertyIsEnumerable` method implementation
	// https://tc39.github.io/ecma262/#sec-object.prototype.propertyisenumerable

	var f = NASHORN_BUG ? function propertyIsEnumerable(V) {
	  var descriptor = getOwnPropertyDescriptor(this, V);
	  return !!descriptor && descriptor.enumerable;
	} : nativePropertyIsEnumerable;
	var objectPropertyIsEnumerable = {
	  f: f
	};

	var createPropertyDescriptor = function createPropertyDescriptor(bitmap, value) {
	  return {
	    enumerable: !(bitmap & 1),
	    configurable: !(bitmap & 2),
	    writable: !(bitmap & 4),
	    value: value
	  };
	};

	var toString = {}.toString;

	var classofRaw = function classofRaw(it) {
	  return toString.call(it).slice(8, -1);
	};

	var split = ''.split; // fallback for non-array-like ES3 and non-enumerable old V8 strings

	var indexedObject = fails(function () {
	  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
	  // eslint-disable-next-line no-prototype-builtins
	  return !Object('z').propertyIsEnumerable(0);
	}) ? function (it) {
	  return classofRaw(it) == 'String' ? split.call(it, '') : Object(it);
	} : Object;

	// `RequireObjectCoercible` abstract operation
	// https://tc39.github.io/ecma262/#sec-requireobjectcoercible
	var requireObjectCoercible = function requireObjectCoercible(it) {
	  if (it == undefined) throw TypeError("Can't call method on " + it);
	  return it;
	};

	var toIndexedObject = function toIndexedObject(it) {
	  return indexedObject(requireObjectCoercible(it));
	};

	var isObject = function isObject(it) {
	  return typeof it === 'object' ? it !== null : typeof it === 'function';
	};

	// https://tc39.github.io/ecma262/#sec-toprimitive
	// instead of the ES6 spec version, we didn't implement @@toPrimitive case
	// and the second argument - flag - preferred type is a string

	var toPrimitive = function toPrimitive(input, PREFERRED_STRING) {
	  if (!isObject(input)) return input;
	  var fn, val;
	  if (PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
	  if (typeof (fn = input.valueOf) == 'function' && !isObject(val = fn.call(input))) return val;
	  if (!PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input))) return val;
	  throw TypeError("Can't convert object to primitive value");
	};

	var hasOwnProperty = {}.hasOwnProperty;

	var has = function has(it, key) {
	  return hasOwnProperty.call(it, key);
	};

	var document$1 = global_1.document; // typeof document.createElement is 'object' in old IE

	var EXISTS = isObject(document$1) && isObject(document$1.createElement);

	var documentCreateElement = function documentCreateElement(it) {
	  return EXISTS ? document$1.createElement(it) : {};
	};

	var ie8DomDefine = !descriptors && !fails(function () {
	  return Object.defineProperty(documentCreateElement('div'), 'a', {
	    get: function get() {
	      return 7;
	    }
	  }).a != 7;
	});

	var nativeGetOwnPropertyDescriptor = Object.getOwnPropertyDescriptor; // `Object.getOwnPropertyDescriptor` method
	// https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptor

	var f$1 = descriptors ? nativeGetOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
	  O = toIndexedObject(O);
	  P = toPrimitive(P, true);
	  if (ie8DomDefine) try {
	    return nativeGetOwnPropertyDescriptor(O, P);
	  } catch (error) {
	    /* empty */
	  }
	  if (has(O, P)) return createPropertyDescriptor(!objectPropertyIsEnumerable.f.call(O, P), O[P]);
	};
	var objectGetOwnPropertyDescriptor = {
	  f: f$1
	};

	var anObject = function anObject(it) {
	  if (!isObject(it)) {
	    throw TypeError(String(it) + ' is not an object');
	  }

	  return it;
	};

	var nativeDefineProperty = Object.defineProperty; // `Object.defineProperty` method
	// https://tc39.github.io/ecma262/#sec-object.defineproperty

	var f$2 = descriptors ? nativeDefineProperty : function defineProperty(O, P, Attributes) {
	  anObject(O);
	  P = toPrimitive(P, true);
	  anObject(Attributes);
	  if (ie8DomDefine) try {
	    return nativeDefineProperty(O, P, Attributes);
	  } catch (error) {
	    /* empty */
	  }
	  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported');
	  if ('value' in Attributes) O[P] = Attributes.value;
	  return O;
	};
	var objectDefineProperty = {
	  f: f$2
	};

	var createNonEnumerableProperty = descriptors ? function (object, key, value) {
	  return objectDefineProperty.f(object, key, createPropertyDescriptor(1, value));
	} : function (object, key, value) {
	  object[key] = value;
	  return object;
	};

	var setGlobal = function setGlobal(key, value) {
	  try {
	    createNonEnumerableProperty(global_1, key, value);
	  } catch (error) {
	    global_1[key] = value;
	  }

	  return value;
	};

	var SHARED = '__core-js_shared__';
	var store = global_1[SHARED] || setGlobal(SHARED, {});
	var sharedStore = store;

	var functionToString = Function.toString; // this helper broken in `3.4.1-3.4.4`, so we can't use `shared` helper

	if (typeof sharedStore.inspectSource != 'function') {
	  sharedStore.inspectSource = function (it) {
	    return functionToString.call(it);
	  };
	}

	var inspectSource = sharedStore.inspectSource;

	var WeakMap$1 = global_1.WeakMap;
	var nativeWeakMap = typeof WeakMap$1 === 'function' && /native code/.test(inspectSource(WeakMap$1));

	var isPure = false;

	var shared = createCommonjsModule(function (module) {
	  (module.exports = function (key, value) {
	    return sharedStore[key] || (sharedStore[key] = value !== undefined ? value : {});
	  })('versions', []).push({
	    version: '3.6.5',
	    mode: isPure ? 'pure' : 'global',
	    copyright: '© 2020 Denis Pushkarev (zloirock.ru)'
	  });
	});

	var id = 0;
	var postfix = Math.random();

	var uid = function uid(key) {
	  return 'Symbol(' + String(key === undefined ? '' : key) + ')_' + (++id + postfix).toString(36);
	};

	var keys = shared('keys');

	var sharedKey = function sharedKey(key) {
	  return keys[key] || (keys[key] = uid(key));
	};

	var hiddenKeys = {};

	var WeakMap$2 = global_1.WeakMap;
	var set, get, has$1;

	var enforce = function enforce(it) {
	  return has$1(it) ? get(it) : set(it, {});
	};

	var getterFor = function getterFor(TYPE) {
	  return function (it) {
	    var state;

	    if (!isObject(it) || (state = get(it)).type !== TYPE) {
	      throw TypeError('Incompatible receiver, ' + TYPE + ' required');
	    }

	    return state;
	  };
	};

	if (nativeWeakMap) {
	  var store$1 = new WeakMap$2();
	  var wmget = store$1.get;
	  var wmhas = store$1.has;
	  var wmset = store$1.set;

	  set = function set(it, metadata) {
	    wmset.call(store$1, it, metadata);
	    return metadata;
	  };

	  get = function get(it) {
	    return wmget.call(store$1, it) || {};
	  };

	  has$1 = function has(it) {
	    return wmhas.call(store$1, it);
	  };
	} else {
	  var STATE = sharedKey('state');
	  hiddenKeys[STATE] = true;

	  set = function set(it, metadata) {
	    createNonEnumerableProperty(it, STATE, metadata);
	    return metadata;
	  };

	  get = function get(it) {
	    return has(it, STATE) ? it[STATE] : {};
	  };

	  has$1 = function has$1(it) {
	    return has(it, STATE);
	  };
	}

	var internalState = {
	  set: set,
	  get: get,
	  has: has$1,
	  enforce: enforce,
	  getterFor: getterFor
	};
	var internalState_1 = internalState.set;
	var internalState_2 = internalState.get;
	var internalState_3 = internalState.has;
	var internalState_4 = internalState.enforce;
	var internalState_5 = internalState.getterFor;

	var redefine = createCommonjsModule(function (module) {
	  var getInternalState = internalState.get;
	  var enforceInternalState = internalState.enforce;
	  var TEMPLATE = String(String).split('String');
	  (module.exports = function (O, key, value, options) {
	    var unsafe = options ? !!options.unsafe : false;
	    var simple = options ? !!options.enumerable : false;
	    var noTargetGet = options ? !!options.noTargetGet : false;

	    if (typeof value == 'function') {
	      if (typeof key == 'string' && !has(value, 'name')) createNonEnumerableProperty(value, 'name', key);
	      enforceInternalState(value).source = TEMPLATE.join(typeof key == 'string' ? key : '');
	    }

	    if (O === global_1) {
	      if (simple) O[key] = value;else setGlobal(key, value);
	      return;
	    } else if (!unsafe) {
	      delete O[key];
	    } else if (!noTargetGet && O[key]) {
	      simple = true;
	    }

	    if (simple) O[key] = value;else createNonEnumerableProperty(O, key, value); // add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
	  })(Function.prototype, 'toString', function toString() {
	    return typeof this == 'function' && getInternalState(this).source || inspectSource(this);
	  });
	});

	var path = global_1;

	var aFunction = function aFunction(variable) {
	  return typeof variable == 'function' ? variable : undefined;
	};

	var getBuiltIn = function getBuiltIn(namespace, method) {
	  return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(global_1[namespace]) : path[namespace] && path[namespace][method] || global_1[namespace] && global_1[namespace][method];
	};

	var ceil = Math.ceil;
	var floor = Math.floor; // `ToInteger` abstract operation
	// https://tc39.github.io/ecma262/#sec-tointeger

	var toInteger = function toInteger(argument) {
	  return isNaN(argument = +argument) ? 0 : (argument > 0 ? floor : ceil)(argument);
	};

	var min = Math.min; // `ToLength` abstract operation
	// https://tc39.github.io/ecma262/#sec-tolength

	var toLength = function toLength(argument) {
	  return argument > 0 ? min(toInteger(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
	};

	var max = Math.max;
	var min$1 = Math.min; // Helper for a popular repeating case of the spec:
	// Let integer be ? ToInteger(index).
	// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).

	var toAbsoluteIndex = function toAbsoluteIndex(index, length) {
	  var integer = toInteger(index);
	  return integer < 0 ? max(integer + length, 0) : min$1(integer, length);
	};

	var createMethod = function createMethod(IS_INCLUDES) {
	  return function ($this, el, fromIndex) {
	    var O = toIndexedObject($this);
	    var length = toLength(O.length);
	    var index = toAbsoluteIndex(fromIndex, length);
	    var value; // Array#includes uses SameValueZero equality algorithm
	    // eslint-disable-next-line no-self-compare

	    if (IS_INCLUDES && el != el) while (length > index) {
	      value = O[index++]; // eslint-disable-next-line no-self-compare

	      if (value != value) return true; // Array#indexOf ignores holes, Array#includes - not
	    } else for (; length > index; index++) {
	      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
	    }
	    return !IS_INCLUDES && -1;
	  };
	};

	var arrayIncludes = {
	  // `Array.prototype.includes` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.includes
	  includes: createMethod(true),
	  // `Array.prototype.indexOf` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.indexof
	  indexOf: createMethod(false)
	};
	var arrayIncludes_1 = arrayIncludes.includes;
	var arrayIncludes_2 = arrayIncludes.indexOf;

	var indexOf = arrayIncludes.indexOf;

	var objectKeysInternal = function objectKeysInternal(object, names) {
	  var O = toIndexedObject(object);
	  var i = 0;
	  var result = [];
	  var key;

	  for (key in O) {
	    !has(hiddenKeys, key) && has(O, key) && result.push(key);
	  } // Don't enum bug & hidden keys


	  while (names.length > i) {
	    if (has(O, key = names[i++])) {
	      ~indexOf(result, key) || result.push(key);
	    }
	  }

	  return result;
	};

	// IE8- don't enum bug keys
	var enumBugKeys = ['constructor', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'toLocaleString', 'toString', 'valueOf'];

	var hiddenKeys$1 = enumBugKeys.concat('length', 'prototype'); // `Object.getOwnPropertyNames` method
	// https://tc39.github.io/ecma262/#sec-object.getownpropertynames

	var f$3 = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
	  return objectKeysInternal(O, hiddenKeys$1);
	};

	var objectGetOwnPropertyNames = {
	  f: f$3
	};

	var f$4 = Object.getOwnPropertySymbols;
	var objectGetOwnPropertySymbols = {
	  f: f$4
	};

	var ownKeys = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
	  var keys = objectGetOwnPropertyNames.f(anObject(it));
	  var getOwnPropertySymbols = objectGetOwnPropertySymbols.f;
	  return getOwnPropertySymbols ? keys.concat(getOwnPropertySymbols(it)) : keys;
	};

	var copyConstructorProperties = function copyConstructorProperties(target, source) {
	  var keys = ownKeys(source);
	  var defineProperty = objectDefineProperty.f;
	  var getOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;

	  for (var i = 0; i < keys.length; i++) {
	    var key = keys[i];
	    if (!has(target, key)) defineProperty(target, key, getOwnPropertyDescriptor(source, key));
	  }
	};

	var replacement = /#|\.prototype\./;

	var isForced = function isForced(feature, detection) {
	  var value = data[normalize(feature)];
	  return value == POLYFILL ? true : value == NATIVE ? false : typeof detection == 'function' ? fails(detection) : !!detection;
	};

	var normalize = isForced.normalize = function (string) {
	  return String(string).replace(replacement, '.').toLowerCase();
	};

	var data = isForced.data = {};
	var NATIVE = isForced.NATIVE = 'N';
	var POLYFILL = isForced.POLYFILL = 'P';
	var isForced_1 = isForced;

	var getOwnPropertyDescriptor$1 = objectGetOwnPropertyDescriptor.f;
	/*
	  options.target      - name of the target object
	  options.global      - target is the global object
	  options.stat        - export as static methods of target
	  options.proto       - export as prototype methods of target
	  options.real        - real prototype method for the `pure` version
	  options.forced      - export even if the native feature is available
	  options.bind        - bind methods to the target, required for the `pure` version
	  options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
	  options.unsafe      - use the simple assignment of property instead of delete + defineProperty
	  options.sham        - add a flag to not completely full polyfills
	  options.enumerable  - export as enumerable property
	  options.noTargetGet - prevent calling a getter on target
	*/

	var _export = function _export(options, source) {
	  var TARGET = options.target;
	  var GLOBAL = options.global;
	  var STATIC = options.stat;
	  var FORCED, target, key, targetProperty, sourceProperty, descriptor;

	  if (GLOBAL) {
	    target = global_1;
	  } else if (STATIC) {
	    target = global_1[TARGET] || setGlobal(TARGET, {});
	  } else {
	    target = (global_1[TARGET] || {}).prototype;
	  }

	  if (target) for (key in source) {
	    sourceProperty = source[key];

	    if (options.noTargetGet) {
	      descriptor = getOwnPropertyDescriptor$1(target, key);
	      targetProperty = descriptor && descriptor.value;
	    } else targetProperty = target[key];

	    FORCED = isForced_1(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced); // contained in target

	    if (!FORCED && targetProperty !== undefined) {
	      if (typeof sourceProperty === typeof targetProperty) continue;
	      copyConstructorProperties(sourceProperty, targetProperty);
	    } // add a flag to not completely full polyfills


	    if (options.sham || targetProperty && targetProperty.sham) {
	      createNonEnumerableProperty(sourceProperty, 'sham', true);
	    } // extend global


	    redefine(target, key, sourceProperty, options);
	  }
	};

	var nativeSymbol = !!Object.getOwnPropertySymbols && !fails(function () {
	  // Chrome 38 Symbol has incorrect toString conversion
	  // eslint-disable-next-line no-undef
	  return !String(Symbol());
	});

	var useSymbolAsUid = nativeSymbol // eslint-disable-next-line no-undef
	&& !Symbol.sham // eslint-disable-next-line no-undef
	&& typeof Symbol.iterator == 'symbol';

	// https://tc39.github.io/ecma262/#sec-isarray

	var isArray = Array.isArray || function isArray(arg) {
	  return classofRaw(arg) == 'Array';
	};

	// https://tc39.github.io/ecma262/#sec-toobject

	var toObject = function toObject(argument) {
	  return Object(requireObjectCoercible(argument));
	};

	// https://tc39.github.io/ecma262/#sec-object.keys

	var objectKeys = Object.keys || function keys(O) {
	  return objectKeysInternal(O, enumBugKeys);
	};

	// https://tc39.github.io/ecma262/#sec-object.defineproperties

	var objectDefineProperties = descriptors ? Object.defineProperties : function defineProperties(O, Properties) {
	  anObject(O);
	  var keys = objectKeys(Properties);
	  var length = keys.length;
	  var index = 0;
	  var key;

	  while (length > index) {
	    objectDefineProperty.f(O, key = keys[index++], Properties[key]);
	  }

	  return O;
	};

	var html = getBuiltIn('document', 'documentElement');

	var GT = '>';
	var LT = '<';
	var PROTOTYPE = 'prototype';
	var SCRIPT = 'script';
	var IE_PROTO = sharedKey('IE_PROTO');

	var EmptyConstructor = function EmptyConstructor() {
	  /* empty */
	};

	var scriptTag = function scriptTag(content) {
	  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
	}; // Create object with fake `null` prototype: use ActiveX Object with cleared prototype


	var NullProtoObjectViaActiveX = function NullProtoObjectViaActiveX(activeXDocument) {
	  activeXDocument.write(scriptTag(''));
	  activeXDocument.close();
	  var temp = activeXDocument.parentWindow.Object;
	  activeXDocument = null; // avoid memory leak

	  return temp;
	}; // Create object with fake `null` prototype: use iframe Object with cleared prototype


	var NullProtoObjectViaIFrame = function NullProtoObjectViaIFrame() {
	  // Thrash, waste and sodomy: IE GC bug
	  var iframe = documentCreateElement('iframe');
	  var JS = 'java' + SCRIPT + ':';
	  var iframeDocument;
	  iframe.style.display = 'none';
	  html.appendChild(iframe); // https://github.com/zloirock/core-js/issues/475

	  iframe.src = String(JS);
	  iframeDocument = iframe.contentWindow.document;
	  iframeDocument.open();
	  iframeDocument.write(scriptTag('document.F=Object'));
	  iframeDocument.close();
	  return iframeDocument.F;
	}; // Check for document.domain and active x support
	// No need to use active x approach when document.domain is not set
	// see https://github.com/es-shims/es5-shim/issues/150
	// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
	// avoid IE GC bug


	var activeXDocument;

	var _NullProtoObject = function NullProtoObject() {
	  try {
	    /* global ActiveXObject */
	    activeXDocument = document.domain && new ActiveXObject('htmlfile');
	  } catch (error) {
	    /* ignore */
	  }

	  _NullProtoObject = activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : NullProtoObjectViaIFrame();
	  var length = enumBugKeys.length;

	  while (length--) {
	    delete _NullProtoObject[PROTOTYPE][enumBugKeys[length]];
	  }

	  return _NullProtoObject();
	};

	hiddenKeys[IE_PROTO] = true; // `Object.create` method
	// https://tc39.github.io/ecma262/#sec-object.create

	var objectCreate = Object.create || function create(O, Properties) {
	  var result;

	  if (O !== null) {
	    EmptyConstructor[PROTOTYPE] = anObject(O);
	    result = new EmptyConstructor();
	    EmptyConstructor[PROTOTYPE] = null; // add "__proto__" for Object.getPrototypeOf polyfill

	    result[IE_PROTO] = O;
	  } else result = _NullProtoObject();

	  return Properties === undefined ? result : objectDefineProperties(result, Properties);
	};

	var nativeGetOwnPropertyNames = objectGetOwnPropertyNames.f;
	var toString$1 = {}.toString;
	var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [];

	var getWindowNames = function getWindowNames(it) {
	  try {
	    return nativeGetOwnPropertyNames(it);
	  } catch (error) {
	    return windowNames.slice();
	  }
	}; // fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window


	var f$5 = function getOwnPropertyNames(it) {
	  return windowNames && toString$1.call(it) == '[object Window]' ? getWindowNames(it) : nativeGetOwnPropertyNames(toIndexedObject(it));
	};

	var objectGetOwnPropertyNamesExternal = {
	  f: f$5
	};

	var WellKnownSymbolsStore = shared('wks');
	var Symbol$1 = global_1.Symbol;
	var createWellKnownSymbol = useSymbolAsUid ? Symbol$1 : Symbol$1 && Symbol$1.withoutSetter || uid;

	var wellKnownSymbol = function wellKnownSymbol(name) {
	  if (!has(WellKnownSymbolsStore, name)) {
	    if (nativeSymbol && has(Symbol$1, name)) WellKnownSymbolsStore[name] = Symbol$1[name];else WellKnownSymbolsStore[name] = createWellKnownSymbol('Symbol.' + name);
	  }

	  return WellKnownSymbolsStore[name];
	};

	var f$6 = wellKnownSymbol;
	var wellKnownSymbolWrapped = {
	  f: f$6
	};

	var defineProperty = objectDefineProperty.f;

	var defineWellKnownSymbol = function defineWellKnownSymbol(NAME) {
	  var Symbol = path.Symbol || (path.Symbol = {});
	  if (!has(Symbol, NAME)) defineProperty(Symbol, NAME, {
	    value: wellKnownSymbolWrapped.f(NAME)
	  });
	};

	var defineProperty$1 = objectDefineProperty.f;
	var TO_STRING_TAG = wellKnownSymbol('toStringTag');

	var setToStringTag = function setToStringTag(it, TAG, STATIC) {
	  if (it && !has(it = STATIC ? it : it.prototype, TO_STRING_TAG)) {
	    defineProperty$1(it, TO_STRING_TAG, {
	      configurable: true,
	      value: TAG
	    });
	  }
	};

	var aFunction$1 = function aFunction(it) {
	  if (typeof it != 'function') {
	    throw TypeError(String(it) + ' is not a function');
	  }

	  return it;
	};

	var functionBindContext = function functionBindContext(fn, that, length) {
	  aFunction$1(fn);
	  if (that === undefined) return fn;

	  switch (length) {
	    case 0:
	      return function () {
	        return fn.call(that);
	      };

	    case 1:
	      return function (a) {
	        return fn.call(that, a);
	      };

	    case 2:
	      return function (a, b) {
	        return fn.call(that, a, b);
	      };

	    case 3:
	      return function (a, b, c) {
	        return fn.call(that, a, b, c);
	      };
	  }

	  return function ()
	  /* ...args */
	  {
	    return fn.apply(that, arguments);
	  };
	};

	var SPECIES = wellKnownSymbol('species'); // `ArraySpeciesCreate` abstract operation
	// https://tc39.github.io/ecma262/#sec-arrayspeciescreate

	var arraySpeciesCreate = function arraySpeciesCreate(originalArray, length) {
	  var C;

	  if (isArray(originalArray)) {
	    C = originalArray.constructor; // cross-realm fallback

	    if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;else if (isObject(C)) {
	      C = C[SPECIES];
	      if (C === null) C = undefined;
	    }
	  }

	  return new (C === undefined ? Array : C)(length === 0 ? 0 : length);
	};

	var push = [].push; // `Array.prototype.{ forEach, map, filter, some, every, find, findIndex }` methods implementation

	var createMethod$1 = function createMethod(TYPE) {
	  var IS_MAP = TYPE == 1;
	  var IS_FILTER = TYPE == 2;
	  var IS_SOME = TYPE == 3;
	  var IS_EVERY = TYPE == 4;
	  var IS_FIND_INDEX = TYPE == 6;
	  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
	  return function ($this, callbackfn, that, specificCreate) {
	    var O = toObject($this);
	    var self = indexedObject(O);
	    var boundFunction = functionBindContext(callbackfn, that, 3);
	    var length = toLength(self.length);
	    var index = 0;
	    var create = specificCreate || arraySpeciesCreate;
	    var target = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;
	    var value, result;

	    for (; length > index; index++) {
	      if (NO_HOLES || index in self) {
	        value = self[index];
	        result = boundFunction(value, index, O);

	        if (TYPE) {
	          if (IS_MAP) target[index] = result; // map
	          else if (result) switch (TYPE) {
	              case 3:
	                return true;
	              // some

	              case 5:
	                return value;
	              // find

	              case 6:
	                return index;
	              // findIndex

	              case 2:
	                push.call(target, value);
	              // filter
	            } else if (IS_EVERY) return false; // every
	        }
	      }
	    }

	    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
	  };
	};

	var arrayIteration = {
	  // `Array.prototype.forEach` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.foreach
	  forEach: createMethod$1(0),
	  // `Array.prototype.map` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.map
	  map: createMethod$1(1),
	  // `Array.prototype.filter` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.filter
	  filter: createMethod$1(2),
	  // `Array.prototype.some` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.some
	  some: createMethod$1(3),
	  // `Array.prototype.every` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.every
	  every: createMethod$1(4),
	  // `Array.prototype.find` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.find
	  find: createMethod$1(5),
	  // `Array.prototype.findIndex` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.findIndex
	  findIndex: createMethod$1(6)
	};
	var arrayIteration_1 = arrayIteration.forEach;
	var arrayIteration_2 = arrayIteration.map;
	var arrayIteration_3 = arrayIteration.filter;
	var arrayIteration_4 = arrayIteration.some;
	var arrayIteration_5 = arrayIteration.every;
	var arrayIteration_6 = arrayIteration.find;
	var arrayIteration_7 = arrayIteration.findIndex;

	'use strict';

	var $forEach = arrayIteration.forEach;
	var HIDDEN = sharedKey('hidden');
	var SYMBOL = 'Symbol';
	var PROTOTYPE$1 = 'prototype';
	var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');
	var setInternalState = internalState.set;
	var getInternalState = internalState.getterFor(SYMBOL);
	var ObjectPrototype = Object[PROTOTYPE$1];
	var $Symbol = global_1.Symbol;
	var $stringify = getBuiltIn('JSON', 'stringify');
	var nativeGetOwnPropertyDescriptor$1 = objectGetOwnPropertyDescriptor.f;
	var nativeDefineProperty$1 = objectDefineProperty.f;
	var nativeGetOwnPropertyNames$1 = objectGetOwnPropertyNamesExternal.f;
	var nativePropertyIsEnumerable$1 = objectPropertyIsEnumerable.f;
	var AllSymbols = shared('symbols');
	var ObjectPrototypeSymbols = shared('op-symbols');
	var StringToSymbolRegistry = shared('string-to-symbol-registry');
	var SymbolToStringRegistry = shared('symbol-to-string-registry');
	var WellKnownSymbolsStore$1 = shared('wks');
	var QObject = global_1.QObject; // Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173

	var USE_SETTER = !QObject || !QObject[PROTOTYPE$1] || !QObject[PROTOTYPE$1].findChild; // fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687

	var setSymbolDescriptor = descriptors && fails(function () {
	  return objectCreate(nativeDefineProperty$1({}, 'a', {
	    get: function get() {
	      return nativeDefineProperty$1(this, 'a', {
	        value: 7
	      }).a;
	    }
	  })).a != 7;
	}) ? function (O, P, Attributes) {
	  var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor$1(ObjectPrototype, P);
	  if (ObjectPrototypeDescriptor) delete ObjectPrototype[P];
	  nativeDefineProperty$1(O, P, Attributes);

	  if (ObjectPrototypeDescriptor && O !== ObjectPrototype) {
	    nativeDefineProperty$1(ObjectPrototype, P, ObjectPrototypeDescriptor);
	  }
	} : nativeDefineProperty$1;

	var wrap = function wrap(tag, description) {
	  var symbol = AllSymbols[tag] = objectCreate($Symbol[PROTOTYPE$1]);
	  setInternalState(symbol, {
	    type: SYMBOL,
	    tag: tag,
	    description: description
	  });
	  if (!descriptors) symbol.description = description;
	  return symbol;
	};

	var isSymbol = useSymbolAsUid ? function (it) {
	  return typeof it == 'symbol';
	} : function (it) {
	  return Object(it) instanceof $Symbol;
	};

	var $defineProperty = function defineProperty(O, P, Attributes) {
	  if (O === ObjectPrototype) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
	  anObject(O);
	  var key = toPrimitive(P, true);
	  anObject(Attributes);

	  if (has(AllSymbols, key)) {
	    if (!Attributes.enumerable) {
	      if (!has(O, HIDDEN)) nativeDefineProperty$1(O, HIDDEN, createPropertyDescriptor(1, {}));
	      O[HIDDEN][key] = true;
	    } else {
	      if (has(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
	      Attributes = objectCreate(Attributes, {
	        enumerable: createPropertyDescriptor(0, false)
	      });
	    }

	    return setSymbolDescriptor(O, key, Attributes);
	  }

	  return nativeDefineProperty$1(O, key, Attributes);
	};

	var $defineProperties = function defineProperties(O, Properties) {
	  anObject(O);
	  var properties = toIndexedObject(Properties);
	  var keys = objectKeys(properties).concat($getOwnPropertySymbols(properties));
	  $forEach(keys, function (key) {
	    if (!descriptors || $propertyIsEnumerable.call(properties, key)) $defineProperty(O, key, properties[key]);
	  });
	  return O;
	};

	var $create = function create(O, Properties) {
	  return Properties === undefined ? objectCreate(O) : $defineProperties(objectCreate(O), Properties);
	};

	var $propertyIsEnumerable = function propertyIsEnumerable(V) {
	  var P = toPrimitive(V, true);
	  var enumerable = nativePropertyIsEnumerable$1.call(this, P);
	  if (this === ObjectPrototype && has(AllSymbols, P) && !has(ObjectPrototypeSymbols, P)) return false;
	  return enumerable || !has(this, P) || !has(AllSymbols, P) || has(this, HIDDEN) && this[HIDDEN][P] ? enumerable : true;
	};

	var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
	  var it = toIndexedObject(O);
	  var key = toPrimitive(P, true);
	  if (it === ObjectPrototype && has(AllSymbols, key) && !has(ObjectPrototypeSymbols, key)) return;
	  var descriptor = nativeGetOwnPropertyDescriptor$1(it, key);

	  if (descriptor && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key])) {
	    descriptor.enumerable = true;
	  }

	  return descriptor;
	};

	var $getOwnPropertyNames = function getOwnPropertyNames(O) {
	  var names = nativeGetOwnPropertyNames$1(toIndexedObject(O));
	  var result = [];
	  $forEach(names, function (key) {
	    if (!has(AllSymbols, key) && !has(hiddenKeys, key)) result.push(key);
	  });
	  return result;
	};

	var $getOwnPropertySymbols = function getOwnPropertySymbols(O) {
	  var IS_OBJECT_PROTOTYPE = O === ObjectPrototype;
	  var names = nativeGetOwnPropertyNames$1(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject(O));
	  var result = [];
	  $forEach(names, function (key) {
	    if (has(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || has(ObjectPrototype, key))) {
	      result.push(AllSymbols[key]);
	    }
	  });
	  return result;
	}; // `Symbol` constructor
	// https://tc39.github.io/ecma262/#sec-symbol-constructor


	if (!nativeSymbol) {
	  $Symbol = function Symbol() {
	    if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor');
	    var description = !arguments.length || arguments[0] === undefined ? undefined : String(arguments[0]);
	    var tag = uid(description);

	    var setter = function setter(value) {
	      if (this === ObjectPrototype) setter.call(ObjectPrototypeSymbols, value);
	      if (has(this, HIDDEN) && has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
	      setSymbolDescriptor(this, tag, createPropertyDescriptor(1, value));
	    };

	    if (descriptors && USE_SETTER) setSymbolDescriptor(ObjectPrototype, tag, {
	      configurable: true,
	      set: setter
	    });
	    return wrap(tag, description);
	  };

	  redefine($Symbol[PROTOTYPE$1], 'toString', function toString() {
	    return getInternalState(this).tag;
	  });
	  redefine($Symbol, 'withoutSetter', function (description) {
	    return wrap(uid(description), description);
	  });
	  objectPropertyIsEnumerable.f = $propertyIsEnumerable;
	  objectDefineProperty.f = $defineProperty;
	  objectGetOwnPropertyDescriptor.f = $getOwnPropertyDescriptor;
	  objectGetOwnPropertyNames.f = objectGetOwnPropertyNamesExternal.f = $getOwnPropertyNames;
	  objectGetOwnPropertySymbols.f = $getOwnPropertySymbols;

	  wellKnownSymbolWrapped.f = function (name) {
	    return wrap(wellKnownSymbol(name), name);
	  };

	  if (descriptors) {
	    // https://github.com/tc39/proposal-Symbol-description
	    nativeDefineProperty$1($Symbol[PROTOTYPE$1], 'description', {
	      configurable: true,
	      get: function description() {
	        return getInternalState(this).description;
	      }
	    });

	    if (!isPure) {
	      redefine(ObjectPrototype, 'propertyIsEnumerable', $propertyIsEnumerable, {
	        unsafe: true
	      });
	    }
	  }
	}

	_export({
	  global: true,
	  wrap: true,
	  forced: !nativeSymbol,
	  sham: !nativeSymbol
	}, {
	  Symbol: $Symbol
	});
	$forEach(objectKeys(WellKnownSymbolsStore$1), function (name) {
	  defineWellKnownSymbol(name);
	});
	_export({
	  target: SYMBOL,
	  stat: true,
	  forced: !nativeSymbol
	}, {
	  // `Symbol.for` method
	  // https://tc39.github.io/ecma262/#sec-symbol.for
	  'for': function _for(key) {
	    var string = String(key);
	    if (has(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
	    var symbol = $Symbol(string);
	    StringToSymbolRegistry[string] = symbol;
	    SymbolToStringRegistry[symbol] = string;
	    return symbol;
	  },
	  // `Symbol.keyFor` method
	  // https://tc39.github.io/ecma262/#sec-symbol.keyfor
	  keyFor: function keyFor(sym) {
	    if (!isSymbol(sym)) throw TypeError(sym + ' is not a symbol');
	    if (has(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
	  },
	  useSetter: function useSetter() {
	    USE_SETTER = true;
	  },
	  useSimple: function useSimple() {
	    USE_SETTER = false;
	  }
	});
	_export({
	  target: 'Object',
	  stat: true,
	  forced: !nativeSymbol,
	  sham: !descriptors
	}, {
	  // `Object.create` method
	  // https://tc39.github.io/ecma262/#sec-object.create
	  create: $create,
	  // `Object.defineProperty` method
	  // https://tc39.github.io/ecma262/#sec-object.defineproperty
	  defineProperty: $defineProperty,
	  // `Object.defineProperties` method
	  // https://tc39.github.io/ecma262/#sec-object.defineproperties
	  defineProperties: $defineProperties,
	  // `Object.getOwnPropertyDescriptor` method
	  // https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptors
	  getOwnPropertyDescriptor: $getOwnPropertyDescriptor
	});
	_export({
	  target: 'Object',
	  stat: true,
	  forced: !nativeSymbol
	}, {
	  // `Object.getOwnPropertyNames` method
	  // https://tc39.github.io/ecma262/#sec-object.getownpropertynames
	  getOwnPropertyNames: $getOwnPropertyNames,
	  // `Object.getOwnPropertySymbols` method
	  // https://tc39.github.io/ecma262/#sec-object.getownpropertysymbols
	  getOwnPropertySymbols: $getOwnPropertySymbols
	}); // Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
	// https://bugs.chromium.org/p/v8/issues/detail?id=3443

	_export({
	  target: 'Object',
	  stat: true,
	  forced: fails(function () {
	    objectGetOwnPropertySymbols.f(1);
	  })
	}, {
	  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
	    return objectGetOwnPropertySymbols.f(toObject(it));
	  }
	}); // `JSON.stringify` method behavior with symbols
	// https://tc39.github.io/ecma262/#sec-json.stringify

	if ($stringify) {
	  var FORCED_JSON_STRINGIFY = !nativeSymbol || fails(function () {
	    var symbol = $Symbol(); // MS Edge converts symbol values to JSON as {}

	    return $stringify([symbol]) != '[null]' // WebKit converts symbol values to JSON as null
	    || $stringify({
	      a: symbol
	    }) != '{}' // V8 throws on boxed symbols
	    || $stringify(Object(symbol)) != '{}';
	  });
	  _export({
	    target: 'JSON',
	    stat: true,
	    forced: FORCED_JSON_STRINGIFY
	  }, {
	    // eslint-disable-next-line no-unused-vars
	    stringify: function stringify(it, replacer, space) {
	      var args = [it];
	      var index = 1;
	      var $replacer;

	      while (arguments.length > index) {
	        args.push(arguments[index++]);
	      }

	      $replacer = replacer;
	      if (!isObject(replacer) && it === undefined || isSymbol(it)) return; // IE8 returns string on undefined

	      if (!isArray(replacer)) replacer = function replacer(key, value) {
	        if (typeof $replacer == 'function') value = $replacer.call(this, key, value);
	        if (!isSymbol(value)) return value;
	      };
	      args[1] = replacer;
	      return $stringify.apply(null, args);
	    }
	  });
	} // `Symbol.prototype[@@toPrimitive]` method
	// https://tc39.github.io/ecma262/#sec-symbol.prototype-@@toprimitive


	if (!$Symbol[PROTOTYPE$1][TO_PRIMITIVE]) {
	  createNonEnumerableProperty($Symbol[PROTOTYPE$1], TO_PRIMITIVE, $Symbol[PROTOTYPE$1].valueOf);
	} // `Symbol.prototype[@@toStringTag]` property
	// https://tc39.github.io/ecma262/#sec-symbol.prototype-@@tostringtag


	setToStringTag($Symbol, SYMBOL);
	hiddenKeys[HIDDEN] = true;
	var es_symbol = {};

	// https://tc39.github.io/ecma262/#sec-symbol.asynciterator

	defineWellKnownSymbol('asyncIterator');
	var es_symbol_asyncIterator = {};

	// https://tc39.github.io/ecma262/#sec-symbol.prototype.description

	'use strict';

	var defineProperty$2 = objectDefineProperty.f;
	var NativeSymbol = global_1.Symbol;

	if (descriptors && typeof NativeSymbol == 'function' && (!('description' in NativeSymbol.prototype) || // Safari 12 bug
	NativeSymbol().description !== undefined)) {
	  var EmptyStringDescriptionStore = {}; // wrap Symbol constructor for correct work with undefined description

	  var SymbolWrapper = function Symbol() {
	    var description = arguments.length < 1 || arguments[0] === undefined ? undefined : String(arguments[0]);
	    var result = this instanceof SymbolWrapper ? new NativeSymbol(description) // in Edge 13, String(Symbol(undefined)) === 'Symbol(undefined)'
	    : description === undefined ? NativeSymbol() : NativeSymbol(description);
	    if (description === '') EmptyStringDescriptionStore[result] = true;
	    return result;
	  };

	  copyConstructorProperties(SymbolWrapper, NativeSymbol);
	  var symbolPrototype = SymbolWrapper.prototype = NativeSymbol.prototype;
	  symbolPrototype.constructor = SymbolWrapper;
	  var symbolToString = symbolPrototype.toString;
	  var native = String(NativeSymbol('test')) == 'Symbol(test)';
	  var regexp = /^Symbol\((.*)\)[^)]+$/;
	  defineProperty$2(symbolPrototype, 'description', {
	    configurable: true,
	    get: function description() {
	      var symbol = isObject(this) ? this.valueOf() : this;
	      var string = symbolToString.call(symbol);
	      if (has(EmptyStringDescriptionStore, symbol)) return '';
	      var desc = native ? string.slice(7, -1) : string.replace(regexp, '$1');
	      return desc === '' ? undefined : desc;
	    }
	  });
	  _export({
	    global: true,
	    forced: true
	  }, {
	    Symbol: SymbolWrapper
	  });
	}

	var es_symbol_description = {};

	// https://tc39.github.io/ecma262/#sec-symbol.hasinstance

	defineWellKnownSymbol('hasInstance');
	var es_symbol_hasInstance = {};

	// https://tc39.github.io/ecma262/#sec-symbol.isconcatspreadable

	defineWellKnownSymbol('isConcatSpreadable');
	var es_symbol_isConcatSpreadable = {};

	// https://tc39.github.io/ecma262/#sec-symbol.iterator

	defineWellKnownSymbol('iterator');
	var es_symbol_iterator = {};

	// https://tc39.github.io/ecma262/#sec-symbol.match

	defineWellKnownSymbol('match');
	var es_symbol_match = {};

	defineWellKnownSymbol('matchAll');
	var es_symbol_matchAll = {};

	// https://tc39.github.io/ecma262/#sec-symbol.replace

	defineWellKnownSymbol('replace');
	var es_symbol_replace = {};

	// https://tc39.github.io/ecma262/#sec-symbol.search

	defineWellKnownSymbol('search');
	var es_symbol_search = {};

	// https://tc39.github.io/ecma262/#sec-symbol.species

	defineWellKnownSymbol('species');
	var es_symbol_species = {};

	// https://tc39.github.io/ecma262/#sec-symbol.split

	defineWellKnownSymbol('split');
	var es_symbol_split = {};

	// https://tc39.github.io/ecma262/#sec-symbol.toprimitive

	defineWellKnownSymbol('toPrimitive');
	var es_symbol_toPrimitive = {};

	// https://tc39.github.io/ecma262/#sec-symbol.tostringtag

	defineWellKnownSymbol('toStringTag');
	var es_symbol_toStringTag = {};

	// https://tc39.github.io/ecma262/#sec-symbol.unscopables

	defineWellKnownSymbol('unscopables');
	var es_symbol_unscopables = {};

	'use strict';

	var nativeAssign = Object.assign;
	var defineProperty$3 = Object.defineProperty; // `Object.assign` method
	// https://tc39.github.io/ecma262/#sec-object.assign

	var objectAssign = !nativeAssign || fails(function () {
	  // should have correct order of operations (Edge bug)
	  if (descriptors && nativeAssign({
	    b: 1
	  }, nativeAssign(defineProperty$3({}, 'a', {
	    enumerable: true,
	    get: function get() {
	      defineProperty$3(this, 'b', {
	        value: 3,
	        enumerable: false
	      });
	    }
	  }), {
	    b: 2
	  })).b !== 1) return true; // should work with symbols and should have deterministic property order (V8 bug)

	  var A = {};
	  var B = {}; // eslint-disable-next-line no-undef

	  var symbol = Symbol();
	  var alphabet = 'abcdefghijklmnopqrst';
	  A[symbol] = 7;
	  alphabet.split('').forEach(function (chr) {
	    B[chr] = chr;
	  });
	  return nativeAssign({}, A)[symbol] != 7 || objectKeys(nativeAssign({}, B)).join('') != alphabet;
	}) ? function assign(target, source) {
	  // eslint-disable-line no-unused-vars
	  var T = toObject(target);
	  var argumentsLength = arguments.length;
	  var index = 1;
	  var getOwnPropertySymbols = objectGetOwnPropertySymbols.f;
	  var propertyIsEnumerable = objectPropertyIsEnumerable.f;

	  while (argumentsLength > index) {
	    var S = indexedObject(arguments[index++]);
	    var keys = getOwnPropertySymbols ? objectKeys(S).concat(getOwnPropertySymbols(S)) : objectKeys(S);
	    var length = keys.length;
	    var j = 0;
	    var key;

	    while (length > j) {
	      key = keys[j++];
	      if (!descriptors || propertyIsEnumerable.call(S, key)) T[key] = S[key];
	    }
	  }

	  return T;
	} : nativeAssign;

	// https://tc39.github.io/ecma262/#sec-object.assign

	_export({
	  target: 'Object',
	  stat: true,
	  forced: Object.assign !== objectAssign
	}, {
	  assign: objectAssign
	});
	var es_object_assign = {};

	// https://tc39.github.io/ecma262/#sec-object.create

	_export({
	  target: 'Object',
	  stat: true,
	  sham: !descriptors
	}, {
	  create: objectCreate
	});
	var es_object_create = {};

	// https://tc39.github.io/ecma262/#sec-object.defineproperty

	_export({
	  target: 'Object',
	  stat: true,
	  forced: !descriptors,
	  sham: !descriptors
	}, {
	  defineProperty: objectDefineProperty.f
	});
	var es_object_defineProperty = {};

	// https://tc39.github.io/ecma262/#sec-object.defineproperties

	_export({
	  target: 'Object',
	  stat: true,
	  forced: !descriptors,
	  sham: !descriptors
	}, {
	  defineProperties: objectDefineProperties
	});
	var es_object_defineProperties = {};

	var propertyIsEnumerable = objectPropertyIsEnumerable.f; // `Object.{ entries, values }` methods implementation

	var createMethod$2 = function createMethod(TO_ENTRIES) {
	  return function (it) {
	    var O = toIndexedObject(it);
	    var keys = objectKeys(O);
	    var length = keys.length;
	    var i = 0;
	    var result = [];
	    var key;

	    while (length > i) {
	      key = keys[i++];

	      if (!descriptors || propertyIsEnumerable.call(O, key)) {
	        result.push(TO_ENTRIES ? [key, O[key]] : O[key]);
	      }
	    }

	    return result;
	  };
	};

	var objectToArray = {
	  // `Object.entries` method
	  // https://tc39.github.io/ecma262/#sec-object.entries
	  entries: createMethod$2(true),
	  // `Object.values` method
	  // https://tc39.github.io/ecma262/#sec-object.values
	  values: createMethod$2(false)
	};
	var objectToArray_1 = objectToArray.entries;
	var objectToArray_2 = objectToArray.values;

	var $entries = objectToArray.entries; // `Object.entries` method
	// https://tc39.github.io/ecma262/#sec-object.entries

	_export({
	  target: 'Object',
	  stat: true
	}, {
	  entries: function entries(O) {
	    return $entries(O);
	  }
	});
	var es_object_entries = {};

	var freezing = !fails(function () {
	  return Object.isExtensible(Object.preventExtensions({}));
	});

	var internalMetadata = createCommonjsModule(function (module) {
	  var defineProperty = objectDefineProperty.f;
	  var METADATA = uid('meta');
	  var id = 0;

	  var isExtensible = Object.isExtensible || function () {
	    return true;
	  };

	  var setMetadata = function setMetadata(it) {
	    defineProperty(it, METADATA, {
	      value: {
	        objectID: 'O' + ++id,
	        // object ID
	        weakData: {} // weak collections IDs

	      }
	    });
	  };

	  var fastKey = function fastKey(it, create) {
	    // return a primitive with prefix
	    if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;

	    if (!has(it, METADATA)) {
	      // can't set metadata to uncaught frozen object
	      if (!isExtensible(it)) return 'F'; // not necessary to add metadata

	      if (!create) return 'E'; // add missing metadata

	      setMetadata(it); // return object ID
	    }

	    return it[METADATA].objectID;
	  };

	  var getWeakData = function getWeakData(it, create) {
	    if (!has(it, METADATA)) {
	      // can't set metadata to uncaught frozen object
	      if (!isExtensible(it)) return true; // not necessary to add metadata

	      if (!create) return false; // add missing metadata

	      setMetadata(it); // return the store of weak collections IDs
	    }

	    return it[METADATA].weakData;
	  }; // add metadata on freeze-family methods calling


	  var onFreeze = function onFreeze(it) {
	    if (freezing && meta.REQUIRED && isExtensible(it) && !has(it, METADATA)) setMetadata(it);
	    return it;
	  };

	  var meta = module.exports = {
	    REQUIRED: false,
	    fastKey: fastKey,
	    getWeakData: getWeakData,
	    onFreeze: onFreeze
	  };
	  hiddenKeys[METADATA] = true;
	});
	var internalMetadata_1 = internalMetadata.REQUIRED;
	var internalMetadata_2 = internalMetadata.fastKey;
	var internalMetadata_3 = internalMetadata.getWeakData;
	var internalMetadata_4 = internalMetadata.onFreeze;

	var onFreeze = internalMetadata.onFreeze;
	var nativeFreeze = Object.freeze;
	var FAILS_ON_PRIMITIVES = fails(function () {
	  nativeFreeze(1);
	}); // `Object.freeze` method
	// https://tc39.github.io/ecma262/#sec-object.freeze

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES,
	  sham: !freezing
	}, {
	  freeze: function freeze(it) {
	    return nativeFreeze && isObject(it) ? nativeFreeze(onFreeze(it)) : it;
	  }
	});
	var es_object_freeze = {};

	var iterators = {};

	var ITERATOR = wellKnownSymbol('iterator');
	var ArrayPrototype = Array.prototype; // check on default Array iterator

	var isArrayIteratorMethod = function isArrayIteratorMethod(it) {
	  return it !== undefined && (iterators.Array === it || ArrayPrototype[ITERATOR] === it);
	};

	var TO_STRING_TAG$1 = wellKnownSymbol('toStringTag');
	var test = {};
	test[TO_STRING_TAG$1] = 'z';
	var toStringTagSupport = String(test) === '[object z]';

	var TO_STRING_TAG$2 = wellKnownSymbol('toStringTag'); // ES3 wrong here

	var CORRECT_ARGUMENTS = classofRaw(function () {
	  return arguments;
	}()) == 'Arguments'; // fallback for IE11 Script Access Denied error

	var tryGet = function tryGet(it, key) {
	  try {
	    return it[key];
	  } catch (error) {
	    /* empty */
	  }
	}; // getting tag from ES6+ `Object.prototype.toString`


	var classof = toStringTagSupport ? classofRaw : function (it) {
	  var O, tag, result;
	  return it === undefined ? 'Undefined' : it === null ? 'Null' // @@toStringTag case
	  : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG$2)) == 'string' ? tag // builtinTag case
	  : CORRECT_ARGUMENTS ? classofRaw(O) // ES3 arguments fallback
	  : (result = classofRaw(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : result;
	};

	var ITERATOR$1 = wellKnownSymbol('iterator');

	var getIteratorMethod = function getIteratorMethod(it) {
	  if (it != undefined) return it[ITERATOR$1] || it['@@iterator'] || iterators[classof(it)];
	};

	var callWithSafeIterationClosing = function callWithSafeIterationClosing(iterator, fn, value, ENTRIES) {
	  try {
	    return ENTRIES ? fn(anObject(value)[0], value[1]) : fn(value); // 7.4.6 IteratorClose(iterator, completion)
	  } catch (error) {
	    var returnMethod = iterator['return'];
	    if (returnMethod !== undefined) anObject(returnMethod.call(iterator));
	    throw error;
	  }
	};

	var iterate_1 = createCommonjsModule(function (module) {
	  var Result = function Result(stopped, result) {
	    this.stopped = stopped;
	    this.result = result;
	  };

	  var iterate = module.exports = function (iterable, fn, that, AS_ENTRIES, IS_ITERATOR) {
	    var boundFunction = functionBindContext(fn, that, AS_ENTRIES ? 2 : 1);
	    var iterator, iterFn, index, length, result, next, step;

	    if (IS_ITERATOR) {
	      iterator = iterable;
	    } else {
	      iterFn = getIteratorMethod(iterable);
	      if (typeof iterFn != 'function') throw TypeError('Target is not iterable'); // optimisation for array iterators

	      if (isArrayIteratorMethod(iterFn)) {
	        for (index = 0, length = toLength(iterable.length); length > index; index++) {
	          result = AS_ENTRIES ? boundFunction(anObject(step = iterable[index])[0], step[1]) : boundFunction(iterable[index]);
	          if (result && result instanceof Result) return result;
	        }

	        return new Result(false);
	      }

	      iterator = iterFn.call(iterable);
	    }

	    next = iterator.next;

	    while (!(step = next.call(iterator)).done) {
	      result = callWithSafeIterationClosing(iterator, boundFunction, step.value, AS_ENTRIES);
	      if (typeof result == 'object' && result && result instanceof Result) return result;
	    }

	    return new Result(false);
	  };

	  iterate.stop = function (result) {
	    return new Result(true, result);
	  };
	});

	'use strict';

	var createProperty = function createProperty(object, key, value) {
	  var propertyKey = toPrimitive(key);
	  if (propertyKey in object) objectDefineProperty.f(object, propertyKey, createPropertyDescriptor(0, value));else object[propertyKey] = value;
	};

	// https://github.com/tc39/proposal-object-from-entries

	_export({
	  target: 'Object',
	  stat: true
	}, {
	  fromEntries: function fromEntries(iterable) {
	    var obj = {};
	    iterate_1(iterable, function (k, v) {
	      createProperty(obj, k, v);
	    }, undefined, true);
	    return obj;
	  }
	});
	var es_object_fromEntries = {};

	var nativeGetOwnPropertyDescriptor$2 = objectGetOwnPropertyDescriptor.f;
	var FAILS_ON_PRIMITIVES$1 = fails(function () {
	  nativeGetOwnPropertyDescriptor$2(1);
	});
	var FORCED = !descriptors || FAILS_ON_PRIMITIVES$1; // `Object.getOwnPropertyDescriptor` method
	// https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptor

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FORCED,
	  sham: !descriptors
	}, {
	  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
	    return nativeGetOwnPropertyDescriptor$2(toIndexedObject(it), key);
	  }
	});
	var es_object_getOwnPropertyDescriptor = {};

	// https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptors

	_export({
	  target: 'Object',
	  stat: true,
	  sham: !descriptors
	}, {
	  getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
	    var O = toIndexedObject(object);
	    var getOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
	    var keys = ownKeys(O);
	    var result = {};
	    var index = 0;
	    var key, descriptor;

	    while (keys.length > index) {
	      descriptor = getOwnPropertyDescriptor(O, key = keys[index++]);
	      if (descriptor !== undefined) createProperty(result, key, descriptor);
	    }

	    return result;
	  }
	});
	var es_object_getOwnPropertyDescriptors = {};

	var nativeGetOwnPropertyNames$2 = objectGetOwnPropertyNamesExternal.f;
	var FAILS_ON_PRIMITIVES$2 = fails(function () {
	  return !Object.getOwnPropertyNames(1);
	}); // `Object.getOwnPropertyNames` method
	// https://tc39.github.io/ecma262/#sec-object.getownpropertynames

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$2
	}, {
	  getOwnPropertyNames: nativeGetOwnPropertyNames$2
	});
	var es_object_getOwnPropertyNames = {};

	var correctPrototypeGetter = !fails(function () {
	  function F() {
	    /* empty */
	  }

	  F.prototype.constructor = null;
	  return Object.getPrototypeOf(new F()) !== F.prototype;
	});

	var IE_PROTO$1 = sharedKey('IE_PROTO');
	var ObjectPrototype$1 = Object.prototype; // `Object.getPrototypeOf` method
	// https://tc39.github.io/ecma262/#sec-object.getprototypeof

	var objectGetPrototypeOf = correctPrototypeGetter ? Object.getPrototypeOf : function (O) {
	  O = toObject(O);
	  if (has(O, IE_PROTO$1)) return O[IE_PROTO$1];

	  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
	    return O.constructor.prototype;
	  }

	  return O instanceof Object ? ObjectPrototype$1 : null;
	};

	var FAILS_ON_PRIMITIVES$3 = fails(function () {
	  objectGetPrototypeOf(1);
	}); // `Object.getPrototypeOf` method
	// https://tc39.github.io/ecma262/#sec-object.getprototypeof

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$3,
	  sham: !correctPrototypeGetter
	}, {
	  getPrototypeOf: function getPrototypeOf(it) {
	    return objectGetPrototypeOf(toObject(it));
	  }
	});
	var es_object_getPrototypeOf = {};

	// `SameValue` abstract operation
	// https://tc39.github.io/ecma262/#sec-samevalue
	var sameValue = Object.is || function is(x, y) {
	  // eslint-disable-next-line no-self-compare
	  return x === y ? x !== 0 || 1 / x === 1 / y : x != x && y != y;
	};

	// https://tc39.github.io/ecma262/#sec-object.is

	_export({
	  target: 'Object',
	  stat: true
	}, {
	  is: sameValue
	});
	var es_object_is = {};

	var nativeIsExtensible = Object.isExtensible;
	var FAILS_ON_PRIMITIVES$4 = fails(function () {
	  nativeIsExtensible(1);
	}); // `Object.isExtensible` method
	// https://tc39.github.io/ecma262/#sec-object.isextensible

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$4
	}, {
	  isExtensible: function isExtensible(it) {
	    return isObject(it) ? nativeIsExtensible ? nativeIsExtensible(it) : true : false;
	  }
	});
	var es_object_isExtensible = {};

	var nativeIsFrozen = Object.isFrozen;
	var FAILS_ON_PRIMITIVES$5 = fails(function () {
	  nativeIsFrozen(1);
	}); // `Object.isFrozen` method
	// https://tc39.github.io/ecma262/#sec-object.isfrozen

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$5
	}, {
	  isFrozen: function isFrozen(it) {
	    return isObject(it) ? nativeIsFrozen ? nativeIsFrozen(it) : false : true;
	  }
	});
	var es_object_isFrozen = {};

	var nativeIsSealed = Object.isSealed;
	var FAILS_ON_PRIMITIVES$6 = fails(function () {
	  nativeIsSealed(1);
	}); // `Object.isSealed` method
	// https://tc39.github.io/ecma262/#sec-object.issealed

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$6
	}, {
	  isSealed: function isSealed(it) {
	    return isObject(it) ? nativeIsSealed ? nativeIsSealed(it) : false : true;
	  }
	});
	var es_object_isSealed = {};

	var FAILS_ON_PRIMITIVES$7 = fails(function () {
	  objectKeys(1);
	}); // `Object.keys` method
	// https://tc39.github.io/ecma262/#sec-object.keys

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$7
	}, {
	  keys: function keys(it) {
	    return objectKeys(toObject(it));
	  }
	});
	var es_object_keys = {};

	var onFreeze$1 = internalMetadata.onFreeze;
	var nativePreventExtensions = Object.preventExtensions;
	var FAILS_ON_PRIMITIVES$8 = fails(function () {
	  nativePreventExtensions(1);
	}); // `Object.preventExtensions` method
	// https://tc39.github.io/ecma262/#sec-object.preventextensions

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$8,
	  sham: !freezing
	}, {
	  preventExtensions: function preventExtensions(it) {
	    return nativePreventExtensions && isObject(it) ? nativePreventExtensions(onFreeze$1(it)) : it;
	  }
	});
	var es_object_preventExtensions = {};

	var onFreeze$2 = internalMetadata.onFreeze;
	var nativeSeal = Object.seal;
	var FAILS_ON_PRIMITIVES$9 = fails(function () {
	  nativeSeal(1);
	}); // `Object.seal` method
	// https://tc39.github.io/ecma262/#sec-object.seal

	_export({
	  target: 'Object',
	  stat: true,
	  forced: FAILS_ON_PRIMITIVES$9,
	  sham: !freezing
	}, {
	  seal: function seal(it) {
	    return nativeSeal && isObject(it) ? nativeSeal(onFreeze$2(it)) : it;
	  }
	});
	var es_object_seal = {};

	var aPossiblePrototype = function aPossiblePrototype(it) {
	  if (!isObject(it) && it !== null) {
	    throw TypeError("Can't set " + String(it) + ' as a prototype');
	  }

	  return it;
	};

	// https://tc39.github.io/ecma262/#sec-object.setprototypeof
	// Works with __proto__ only. Old v8 can't work with null proto objects.

	/* eslint-disable no-proto */

	var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
	  var CORRECT_SETTER = false;
	  var test = {};
	  var setter;

	  try {
	    setter = Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set;
	    setter.call(test, []);
	    CORRECT_SETTER = test instanceof Array;
	  } catch (error) {
	    /* empty */
	  }

	  return function setPrototypeOf(O, proto) {
	    anObject(O);
	    aPossiblePrototype(proto);
	    if (CORRECT_SETTER) setter.call(O, proto);else O.__proto__ = proto;
	    return O;
	  };
	}() : undefined);

	// https://tc39.github.io/ecma262/#sec-object.setprototypeof

	_export({
	  target: 'Object',
	  stat: true
	}, {
	  setPrototypeOf: objectSetPrototypeOf
	});
	var es_object_setPrototypeOf = {};

	var $values = objectToArray.values; // `Object.values` method
	// https://tc39.github.io/ecma262/#sec-object.values

	_export({
	  target: 'Object',
	  stat: true
	}, {
	  values: function values(O) {
	    return $values(O);
	  }
	});
	var es_object_values = {};

	'use strict'; // `Object.prototype.toString` method implementation
	// https://tc39.github.io/ecma262/#sec-object.prototype.tostring


	var objectToString = toStringTagSupport ? {}.toString : function toString() {
	  return '[object ' + classof(this) + ']';
	};

	// https://tc39.github.io/ecma262/#sec-object.prototype.tostring

	if (!toStringTagSupport) {
	  redefine(Object.prototype, 'toString', objectToString, {
	    unsafe: true
	  });
	}

	var es_object_toString = {};

	'use strict'; // Forced replacement object prototype accessors methods


	var objectPrototypeAccessorsForced = isPure || !fails(function () {
	  var key = Math.random(); // In FF throws only define methods
	  // eslint-disable-next-line no-undef, no-useless-call

	  __defineSetter__.call(null, key, function () {
	    /* empty */
	  });

	  delete global_1[key];
	});

	'use strict'; // `Object.prototype.__defineGetter__` method
	// https://tc39.github.io/ecma262/#sec-object.prototype.__defineGetter__


	if (descriptors) {
	  _export({
	    target: 'Object',
	    proto: true,
	    forced: objectPrototypeAccessorsForced
	  }, {
	    __defineGetter__: function __defineGetter__(P, getter) {
	      objectDefineProperty.f(toObject(this), P, {
	        get: aFunction$1(getter),
	        enumerable: true,
	        configurable: true
	      });
	    }
	  });
	}

	var es_object_defineGetter = {};

	'use strict'; // `Object.prototype.__defineSetter__` method
	// https://tc39.github.io/ecma262/#sec-object.prototype.__defineSetter__


	if (descriptors) {
	  _export({
	    target: 'Object',
	    proto: true,
	    forced: objectPrototypeAccessorsForced
	  }, {
	    __defineSetter__: function __defineSetter__(P, setter) {
	      objectDefineProperty.f(toObject(this), P, {
	        set: aFunction$1(setter),
	        enumerable: true,
	        configurable: true
	      });
	    }
	  });
	}

	var es_object_defineSetter = {};

	'use strict';

	var getOwnPropertyDescriptor$2 = objectGetOwnPropertyDescriptor.f; // `Object.prototype.__lookupGetter__` method
	// https://tc39.github.io/ecma262/#sec-object.prototype.__lookupGetter__

	if (descriptors) {
	  _export({
	    target: 'Object',
	    proto: true,
	    forced: objectPrototypeAccessorsForced
	  }, {
	    __lookupGetter__: function __lookupGetter__(P) {
	      var O = toObject(this);
	      var key = toPrimitive(P, true);
	      var desc;

	      do {
	        if (desc = getOwnPropertyDescriptor$2(O, key)) return desc.get;
	      } while (O = objectGetPrototypeOf(O));
	    }
	  });
	}

	var es_object_lookupGetter = {};

	'use strict';

	var getOwnPropertyDescriptor$3 = objectGetOwnPropertyDescriptor.f; // `Object.prototype.__lookupSetter__` method
	// https://tc39.github.io/ecma262/#sec-object.prototype.__lookupSetter__

	if (descriptors) {
	  _export({
	    target: 'Object',
	    proto: true,
	    forced: objectPrototypeAccessorsForced
	  }, {
	    __lookupSetter__: function __lookupSetter__(P) {
	      var O = toObject(this);
	      var key = toPrimitive(P, true);
	      var desc;

	      do {
	        if (desc = getOwnPropertyDescriptor$3(O, key)) return desc.set;
	      } while (O = objectGetPrototypeOf(O));
	    }
	  });
	}

	var es_object_lookupSetter = {};

	'use strict';

	var slice = [].slice;
	var factories = {};

	var construct = function construct(C, argsLength, args) {
	  if (!(argsLength in factories)) {
	    for (var list = [], i = 0; i < argsLength; i++) {
	      list[i] = 'a[' + i + ']';
	    } // eslint-disable-next-line no-new-func


	    factories[argsLength] = Function('C,a', 'return new C(' + list.join(',') + ')');
	  }

	  return factories[argsLength](C, args);
	}; // `Function.prototype.bind` method implementation
	// https://tc39.github.io/ecma262/#sec-function.prototype.bind


	var functionBind = Function.bind || function bind(that
	/* , ...args */
	) {
	  var fn = aFunction$1(this);
	  var partArgs = slice.call(arguments, 1);

	  var boundFunction = function bound()
	  /* args... */
	  {
	    var args = partArgs.concat(slice.call(arguments));
	    return this instanceof boundFunction ? construct(fn, args.length, args) : fn.apply(that, args);
	  };

	  if (isObject(fn.prototype)) boundFunction.prototype = fn.prototype;
	  return boundFunction;
	};

	// https://tc39.github.io/ecma262/#sec-function.prototype.bind

	_export({
	  target: 'Function',
	  proto: true
	}, {
	  bind: functionBind
	});
	var es_function_bind = {};

	var defineProperty$4 = objectDefineProperty.f;
	var FunctionPrototype = Function.prototype;
	var FunctionPrototypeToString = FunctionPrototype.toString;
	var nameRE = /^\s*function ([^ (]*)/;
	var NAME = 'name'; // Function instances `.name` property
	// https://tc39.github.io/ecma262/#sec-function-instances-name

	if (descriptors && !(NAME in FunctionPrototype)) {
	  defineProperty$4(FunctionPrototype, NAME, {
	    configurable: true,
	    get: function get() {
	      try {
	        return FunctionPrototypeToString.call(this).match(nameRE)[1];
	      } catch (error) {
	        return '';
	      }
	    }
	  });
	}

	var es_function_name = {};

	'use strict';

	var HAS_INSTANCE = wellKnownSymbol('hasInstance');
	var FunctionPrototype$1 = Function.prototype; // `Function.prototype[@@hasInstance]` method
	// https://tc39.github.io/ecma262/#sec-function.prototype-@@hasinstance

	if (!(HAS_INSTANCE in FunctionPrototype$1)) {
	  objectDefineProperty.f(FunctionPrototype$1, HAS_INSTANCE, {
	    value: function value(O) {
	      if (typeof this != 'function' || !isObject(O)) return false;
	      if (!isObject(this.prototype)) return O instanceof this; // for environment w/o native `@@hasInstance` logic enough `instanceof`, but add this:

	      while (O = objectGetPrototypeOf(O)) {
	        if (this.prototype === O) return true;
	      }

	      return false;
	    }
	  });
	}

	var es_function_hasInstance = {};

	// https://github.com/tc39/proposal-global

	_export({
	  global: true
	}, {
	  globalThis: global_1
	});
	var es_globalThis = {};

	'use strict'; // `Array.from` method implementation
	// https://tc39.github.io/ecma262/#sec-array.from


	var arrayFrom = function from(arrayLike
	/* , mapfn = undefined, thisArg = undefined */
	) {
	  var O = toObject(arrayLike);
	  var C = typeof this == 'function' ? this : Array;
	  var argumentsLength = arguments.length;
	  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
	  var mapping = mapfn !== undefined;
	  var iteratorMethod = getIteratorMethod(O);
	  var index = 0;
	  var length, result, step, iterator, next, value;
	  if (mapping) mapfn = functionBindContext(mapfn, argumentsLength > 2 ? arguments[2] : undefined, 2); // if the target is not iterable or it's an array with the default iterator - use a simple case

	  if (iteratorMethod != undefined && !(C == Array && isArrayIteratorMethod(iteratorMethod))) {
	    iterator = iteratorMethod.call(O);
	    next = iterator.next;
	    result = new C();

	    for (; !(step = next.call(iterator)).done; index++) {
	      value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true) : step.value;
	      createProperty(result, index, value);
	    }
	  } else {
	    length = toLength(O.length);
	    result = new C(length);

	    for (; length > index; index++) {
	      value = mapping ? mapfn(O[index], index) : O[index];
	      createProperty(result, index, value);
	    }
	  }

	  result.length = index;
	  return result;
	};

	var ITERATOR$2 = wellKnownSymbol('iterator');
	var SAFE_CLOSING = false;

	try {
	  var called = 0;
	  var iteratorWithReturn = {
	    next: function next() {
	      return {
	        done: !!called++
	      };
	    },
	    'return': function _return() {
	      SAFE_CLOSING = true;
	    }
	  };

	  iteratorWithReturn[ITERATOR$2] = function () {
	    return this;
	  }; // eslint-disable-next-line no-throw-literal


	  Array.from(iteratorWithReturn, function () {
	    throw 2;
	  });
	} catch (error) {
	  /* empty */
	}

	var checkCorrectnessOfIteration = function checkCorrectnessOfIteration(exec, SKIP_CLOSING) {
	  if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
	  var ITERATION_SUPPORT = false;

	  try {
	    var object = {};

	    object[ITERATOR$2] = function () {
	      return {
	        next: function next() {
	          return {
	            done: ITERATION_SUPPORT = true
	          };
	        }
	      };
	    };

	    exec(object);
	  } catch (error) {
	    /* empty */
	  }

	  return ITERATION_SUPPORT;
	};

	var INCORRECT_ITERATION = !checkCorrectnessOfIteration(function (iterable) {
	  Array.from(iterable);
	}); // `Array.from` method
	// https://tc39.github.io/ecma262/#sec-array.from

	_export({
	  target: 'Array',
	  stat: true,
	  forced: INCORRECT_ITERATION
	}, {
	  from: arrayFrom
	});
	var es_array_from = {};

	// https://tc39.github.io/ecma262/#sec-array.isarray

	_export({
	  target: 'Array',
	  stat: true
	}, {
	  isArray: isArray
	});
	var es_array_isArray = {};

	'use strict';

	var ISNT_GENERIC = fails(function () {
	  function F() {
	    /* empty */
	  }

	  return !(Array.of.call(F) instanceof F);
	}); // `Array.of` method
	// https://tc39.github.io/ecma262/#sec-array.of
	// WebKit Array.of isn't generic

	_export({
	  target: 'Array',
	  stat: true,
	  forced: ISNT_GENERIC
	}, {
	  of: function of()
	  /* ...args */
	  {
	    var index = 0;
	    var argumentsLength = arguments.length;
	    var result = new (typeof this == 'function' ? this : Array)(argumentsLength);

	    while (argumentsLength > index) {
	      createProperty(result, index, arguments[index++]);
	    }

	    result.length = argumentsLength;
	    return result;
	  }
	});
	var es_array_of = {};

	var engineUserAgent = getBuiltIn('navigator', 'userAgent') || '';

	var process$1 = global_1.process;
	var versions = process$1 && process$1.versions;
	var v8 = versions && versions.v8;
	var match, version;

	if (v8) {
	  match = v8.split('.');
	  version = match[0] + match[1];
	} else if (engineUserAgent) {
	  match = engineUserAgent.match(/Edge\/(\d+)/);

	  if (!match || match[1] >= 74) {
	    match = engineUserAgent.match(/Chrome\/(\d+)/);
	    if (match) version = match[1];
	  }
	}

	var engineV8Version = version && +version;

	var SPECIES$1 = wellKnownSymbol('species');

	var arrayMethodHasSpeciesSupport = function arrayMethodHasSpeciesSupport(METHOD_NAME) {
	  // We can't use this feature detection in V8 since it causes
	  // deoptimization and serious performance degradation
	  // https://github.com/zloirock/core-js/issues/677
	  return engineV8Version >= 51 || !fails(function () {
	    var array = [];
	    var constructor = array.constructor = {};

	    constructor[SPECIES$1] = function () {
	      return {
	        foo: 1
	      };
	    };

	    return array[METHOD_NAME](Boolean).foo !== 1;
	  });
	};

	'use strict';

	var IS_CONCAT_SPREADABLE = wellKnownSymbol('isConcatSpreadable');
	var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF;
	var MAXIMUM_ALLOWED_INDEX_EXCEEDED = 'Maximum allowed index exceeded'; // We can't use this feature detection in V8 since it causes
	// deoptimization and serious performance degradation
	// https://github.com/zloirock/core-js/issues/679

	var IS_CONCAT_SPREADABLE_SUPPORT = engineV8Version >= 51 || !fails(function () {
	  var array = [];
	  array[IS_CONCAT_SPREADABLE] = false;
	  return array.concat()[0] !== array;
	});
	var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('concat');

	var isConcatSpreadable = function isConcatSpreadable(O) {
	  if (!isObject(O)) return false;
	  var spreadable = O[IS_CONCAT_SPREADABLE];
	  return spreadable !== undefined ? !!spreadable : isArray(O);
	};

	var FORCED$1 = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT; // `Array.prototype.concat` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.concat
	// with adding support of @@isConcatSpreadable and @@species

	_export({
	  target: 'Array',
	  proto: true,
	  forced: FORCED$1
	}, {
	  concat: function concat(arg) {
	    // eslint-disable-line no-unused-vars
	    var O = toObject(this);
	    var A = arraySpeciesCreate(O, 0);
	    var n = 0;
	    var i, k, length, len, E;

	    for (i = -1, length = arguments.length; i < length; i++) {
	      E = i === -1 ? O : arguments[i];

	      if (isConcatSpreadable(E)) {
	        len = toLength(E.length);
	        if (n + len > MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);

	        for (k = 0; k < len; k++, n++) {
	          if (k in E) createProperty(A, n, E[k]);
	        }
	      } else {
	        if (n >= MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
	        createProperty(A, n++, E);
	      }
	    }

	    A.length = n;
	    return A;
	  }
	});
	var es_array_concat = {};

	'use strict';

	var min$2 = Math.min; // `Array.prototype.copyWithin` method implementation
	// https://tc39.github.io/ecma262/#sec-array.prototype.copywithin

	var arrayCopyWithin = [].copyWithin || function copyWithin(target
	/* = 0 */
	, start
	/* = 0, end = @length */
	) {
	  var O = toObject(this);
	  var len = toLength(O.length);
	  var to = toAbsoluteIndex(target, len);
	  var from = toAbsoluteIndex(start, len);
	  var end = arguments.length > 2 ? arguments[2] : undefined;
	  var count = min$2((end === undefined ? len : toAbsoluteIndex(end, len)) - from, len - to);
	  var inc = 1;

	  if (from < to && to < from + count) {
	    inc = -1;
	    from += count - 1;
	    to += count - 1;
	  }

	  while (count-- > 0) {
	    if (from in O) O[to] = O[from];else delete O[to];
	    to += inc;
	    from += inc;
	  }

	  return O;
	};

	var UNSCOPABLES = wellKnownSymbol('unscopables');
	var ArrayPrototype$1 = Array.prototype; // Array.prototype[@@unscopables]
	// https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	if (ArrayPrototype$1[UNSCOPABLES] == undefined) {
	  objectDefineProperty.f(ArrayPrototype$1, UNSCOPABLES, {
	    configurable: true,
	    value: objectCreate(null)
	  });
	} // add a key to Array.prototype[@@unscopables]


	var addToUnscopables = function addToUnscopables(key) {
	  ArrayPrototype$1[UNSCOPABLES][key] = true;
	};

	// https://tc39.github.io/ecma262/#sec-array.prototype.copywithin

	_export({
	  target: 'Array',
	  proto: true
	}, {
	  copyWithin: arrayCopyWithin
	}); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	addToUnscopables('copyWithin');
	var es_array_copyWithin = {};

	'use strict';

	var arrayMethodIsStrict = function arrayMethodIsStrict(METHOD_NAME, argument) {
	  var method = [][METHOD_NAME];
	  return !!method && fails(function () {
	    // eslint-disable-next-line no-useless-call,no-throw-literal
	    method.call(null, argument || function () {
	      throw 1;
	    }, 1);
	  });
	};

	var defineProperty$5 = Object.defineProperty;
	var cache = {};

	var thrower = function thrower(it) {
	  throw it;
	};

	var arrayMethodUsesToLength = function arrayMethodUsesToLength(METHOD_NAME, options) {
	  if (has(cache, METHOD_NAME)) return cache[METHOD_NAME];
	  if (!options) options = {};
	  var method = [][METHOD_NAME];
	  var ACCESSORS = has(options, 'ACCESSORS') ? options.ACCESSORS : false;
	  var argument0 = has(options, 0) ? options[0] : thrower;
	  var argument1 = has(options, 1) ? options[1] : undefined;
	  return cache[METHOD_NAME] = !!method && !fails(function () {
	    if (ACCESSORS && !descriptors) return true;
	    var O = {
	      length: -1
	    };
	    if (ACCESSORS) defineProperty$5(O, 1, {
	      enumerable: true,
	      get: thrower
	    });else O[1] = 1;
	    method.call(O, argument0, argument1);
	  });
	};

	'use strict';

	var $every = arrayIteration.every;
	var STRICT_METHOD = arrayMethodIsStrict('every');
	var USES_TO_LENGTH = arrayMethodUsesToLength('every'); // `Array.prototype.every` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.every

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !STRICT_METHOD || !USES_TO_LENGTH
	}, {
	  every: function every(callbackfn
	  /* , thisArg */
	  ) {
	    return $every(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	var es_array_every = {};

	'use strict'; // `Array.prototype.fill` method implementation
	// https://tc39.github.io/ecma262/#sec-array.prototype.fill


	var arrayFill = function fill(value
	/* , start = 0, end = @length */
	) {
	  var O = toObject(this);
	  var length = toLength(O.length);
	  var argumentsLength = arguments.length;
	  var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
	  var end = argumentsLength > 2 ? arguments[2] : undefined;
	  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);

	  while (endPos > index) {
	    O[index++] = value;
	  }

	  return O;
	};

	// https://tc39.github.io/ecma262/#sec-array.prototype.fill

	_export({
	  target: 'Array',
	  proto: true
	}, {
	  fill: arrayFill
	}); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	addToUnscopables('fill');
	var es_array_fill = {};

	'use strict';

	var $filter = arrayIteration.filter;
	var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter'); // Edge 14- issue

	var USES_TO_LENGTH$1 = arrayMethodUsesToLength('filter'); // `Array.prototype.filter` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.filter
	// with adding support of @@species

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH$1
	}, {
	  filter: function filter(callbackfn
	  /* , thisArg */
	  ) {
	    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	var es_array_filter = {};

	'use strict';

	var $find = arrayIteration.find;
	var FIND = 'find';
	var SKIPS_HOLES = true;
	var USES_TO_LENGTH$2 = arrayMethodUsesToLength(FIND); // Shouldn't skip holes

	if (FIND in []) Array(1)[FIND](function () {
	  SKIPS_HOLES = false;
	}); // `Array.prototype.find` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.find

	_export({
	  target: 'Array',
	  proto: true,
	  forced: SKIPS_HOLES || !USES_TO_LENGTH$2
	}, {
	  find: function find(callbackfn
	  /* , that = undefined */
	  ) {
	    return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	}); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	addToUnscopables(FIND);
	var es_array_find = {};

	'use strict';

	var $findIndex = arrayIteration.findIndex;
	var FIND_INDEX = 'findIndex';
	var SKIPS_HOLES$1 = true;
	var USES_TO_LENGTH$3 = arrayMethodUsesToLength(FIND_INDEX); // Shouldn't skip holes

	if (FIND_INDEX in []) Array(1)[FIND_INDEX](function () {
	  SKIPS_HOLES$1 = false;
	}); // `Array.prototype.findIndex` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.findindex

	_export({
	  target: 'Array',
	  proto: true,
	  forced: SKIPS_HOLES$1 || !USES_TO_LENGTH$3
	}, {
	  findIndex: function findIndex(callbackfn
	  /* , that = undefined */
	  ) {
	    return $findIndex(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	}); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	addToUnscopables(FIND_INDEX);
	var es_array_findIndex = {};

	'use strict'; // `FlattenIntoArray` abstract operation
	// https://tc39.github.io/proposal-flatMap/#sec-FlattenIntoArray


	var flattenIntoArray = function flattenIntoArray(target, original, source, sourceLen, start, depth, mapper, thisArg) {
	  var targetIndex = start;
	  var sourceIndex = 0;
	  var mapFn = mapper ? functionBindContext(mapper, thisArg, 3) : false;
	  var element;

	  while (sourceIndex < sourceLen) {
	    if (sourceIndex in source) {
	      element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];

	      if (depth > 0 && isArray(element)) {
	        targetIndex = flattenIntoArray(target, original, element, toLength(element.length), targetIndex, depth - 1) - 1;
	      } else {
	        if (targetIndex >= 0x1FFFFFFFFFFFFF) throw TypeError('Exceed the acceptable array length');
	        target[targetIndex] = element;
	      }

	      targetIndex++;
	    }

	    sourceIndex++;
	  }

	  return targetIndex;
	};

	var flattenIntoArray_1 = flattenIntoArray;

	'use strict'; // `Array.prototype.flat` method
	// https://github.com/tc39/proposal-flatMap


	_export({
	  target: 'Array',
	  proto: true
	}, {
	  flat: function flat()
	  /* depthArg = 1 */
	  {
	    var depthArg = arguments.length ? arguments[0] : undefined;
	    var O = toObject(this);
	    var sourceLen = toLength(O.length);
	    var A = arraySpeciesCreate(O, 0);
	    A.length = flattenIntoArray_1(A, O, O, sourceLen, 0, depthArg === undefined ? 1 : toInteger(depthArg));
	    return A;
	  }
	});
	var es_array_flat = {};

	'use strict'; // `Array.prototype.flatMap` method
	// https://github.com/tc39/proposal-flatMap


	_export({
	  target: 'Array',
	  proto: true
	}, {
	  flatMap: function flatMap(callbackfn
	  /* , thisArg */
	  ) {
	    var O = toObject(this);
	    var sourceLen = toLength(O.length);
	    var A;
	    aFunction$1(callbackfn);
	    A = arraySpeciesCreate(O, 0);
	    A.length = flattenIntoArray_1(A, O, O, sourceLen, 0, 1, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	    return A;
	  }
	});
	var es_array_flatMap = {};

	'use strict';

	var $forEach$1 = arrayIteration.forEach;
	var STRICT_METHOD$1 = arrayMethodIsStrict('forEach');
	var USES_TO_LENGTH$4 = arrayMethodUsesToLength('forEach'); // `Array.prototype.forEach` method implementation
	// https://tc39.github.io/ecma262/#sec-array.prototype.foreach

	var arrayForEach = !STRICT_METHOD$1 || !USES_TO_LENGTH$4 ? function forEach(callbackfn
	/* , thisArg */
	) {
	  return $forEach$1(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	} : [].forEach;

	'use strict'; // `Array.prototype.forEach` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.foreach


	_export({
	  target: 'Array',
	  proto: true,
	  forced: [].forEach != arrayForEach
	}, {
	  forEach: arrayForEach
	});
	var es_array_forEach = {};

	'use strict';

	var $includes = arrayIncludes.includes;
	var USES_TO_LENGTH$5 = arrayMethodUsesToLength('indexOf', {
	  ACCESSORS: true,
	  1: 0
	}); // `Array.prototype.includes` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.includes

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !USES_TO_LENGTH$5
	}, {
	  includes: function includes(el
	  /* , fromIndex = 0 */
	  ) {
	    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
	  }
	}); // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	addToUnscopables('includes');
	var es_array_includes = {};

	'use strict';

	var $indexOf = arrayIncludes.indexOf;
	var nativeIndexOf = [].indexOf;
	var NEGATIVE_ZERO = !!nativeIndexOf && 1 / [1].indexOf(1, -0) < 0;
	var STRICT_METHOD$2 = arrayMethodIsStrict('indexOf');
	var USES_TO_LENGTH$6 = arrayMethodUsesToLength('indexOf', {
	  ACCESSORS: true,
	  1: 0
	}); // `Array.prototype.indexOf` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.indexof

	_export({
	  target: 'Array',
	  proto: true,
	  forced: NEGATIVE_ZERO || !STRICT_METHOD$2 || !USES_TO_LENGTH$6
	}, {
	  indexOf: function indexOf(searchElement
	  /* , fromIndex = 0 */
	  ) {
	    return NEGATIVE_ZERO // convert -0 to +0
	    ? nativeIndexOf.apply(this, arguments) || 0 : $indexOf(this, searchElement, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	var es_array_indexOf = {};

	'use strict';

	var nativeJoin = [].join;
	var ES3_STRINGS = indexedObject != Object;
	var STRICT_METHOD$3 = arrayMethodIsStrict('join', ','); // `Array.prototype.join` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.join

	_export({
	  target: 'Array',
	  proto: true,
	  forced: ES3_STRINGS || !STRICT_METHOD$3
	}, {
	  join: function join(separator) {
	    return nativeJoin.call(toIndexedObject(this), separator === undefined ? ',' : separator);
	  }
	});
	var es_array_join = {};

	'use strict';

	var min$3 = Math.min;
	var nativeLastIndexOf = [].lastIndexOf;
	var NEGATIVE_ZERO$1 = !!nativeLastIndexOf && 1 / [1].lastIndexOf(1, -0) < 0;
	var STRICT_METHOD$4 = arrayMethodIsStrict('lastIndexOf'); // For preventing possible almost infinite loop in non-standard implementations, test the forward version of the method

	var USES_TO_LENGTH$7 = arrayMethodUsesToLength('indexOf', {
	  ACCESSORS: true,
	  1: 0
	});
	var FORCED$2 = NEGATIVE_ZERO$1 || !STRICT_METHOD$4 || !USES_TO_LENGTH$7; // `Array.prototype.lastIndexOf` method implementation
	// https://tc39.github.io/ecma262/#sec-array.prototype.lastindexof

	var arrayLastIndexOf = FORCED$2 ? function lastIndexOf(searchElement
	/* , fromIndex = @[*-1] */
	) {
	  // convert -0 to +0
	  if (NEGATIVE_ZERO$1) return nativeLastIndexOf.apply(this, arguments) || 0;
	  var O = toIndexedObject(this);
	  var length = toLength(O.length);
	  var index = length - 1;
	  if (arguments.length > 1) index = min$3(index, toInteger(arguments[1]));
	  if (index < 0) index = length + index;

	  for (; index >= 0; index--) {
	    if (index in O && O[index] === searchElement) return index || 0;
	  }

	  return -1;
	} : nativeLastIndexOf;

	// https://tc39.github.io/ecma262/#sec-array.prototype.lastindexof

	_export({
	  target: 'Array',
	  proto: true,
	  forced: arrayLastIndexOf !== [].lastIndexOf
	}, {
	  lastIndexOf: arrayLastIndexOf
	});
	var es_array_lastIndexOf = {};

	'use strict';

	var $map = arrayIteration.map;
	var HAS_SPECIES_SUPPORT$1 = arrayMethodHasSpeciesSupport('map'); // FF49- issue

	var USES_TO_LENGTH$8 = arrayMethodUsesToLength('map'); // `Array.prototype.map` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.map
	// with adding support of @@species

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$1 || !USES_TO_LENGTH$8
	}, {
	  map: function map(callbackfn
	  /* , thisArg */
	  ) {
	    return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	var es_array_map = {};

	var createMethod$3 = function createMethod(IS_RIGHT) {
	  return function (that, callbackfn, argumentsLength, memo) {
	    aFunction$1(callbackfn);
	    var O = toObject(that);
	    var self = indexedObject(O);
	    var length = toLength(O.length);
	    var index = IS_RIGHT ? length - 1 : 0;
	    var i = IS_RIGHT ? -1 : 1;
	    if (argumentsLength < 2) while (true) {
	      if (index in self) {
	        memo = self[index];
	        index += i;
	        break;
	      }

	      index += i;

	      if (IS_RIGHT ? index < 0 : length <= index) {
	        throw TypeError('Reduce of empty array with no initial value');
	      }
	    }

	    for (; IS_RIGHT ? index >= 0 : length > index; index += i) {
	      if (index in self) {
	        memo = callbackfn(memo, self[index], index, O);
	      }
	    }

	    return memo;
	  };
	};

	var arrayReduce = {
	  // `Array.prototype.reduce` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.reduce
	  left: createMethod$3(false),
	  // `Array.prototype.reduceRight` method
	  // https://tc39.github.io/ecma262/#sec-array.prototype.reduceright
	  right: createMethod$3(true)
	};
	var arrayReduce_1 = arrayReduce.left;
	var arrayReduce_2 = arrayReduce.right;

	'use strict';

	var $reduce = arrayReduce.left;
	var STRICT_METHOD$5 = arrayMethodIsStrict('reduce');
	var USES_TO_LENGTH$9 = arrayMethodUsesToLength('reduce', {
	  1: 0
	}); // `Array.prototype.reduce` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.reduce

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !STRICT_METHOD$5 || !USES_TO_LENGTH$9
	}, {
	  reduce: function reduce(callbackfn
	  /* , initialValue */
	  ) {
	    return $reduce(this, callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	var es_array_reduce = {};

	'use strict';

	var $reduceRight = arrayReduce.right;
	var STRICT_METHOD$6 = arrayMethodIsStrict('reduceRight'); // For preventing possible almost infinite loop in non-standard implementations, test the forward version of the method

	var USES_TO_LENGTH$a = arrayMethodUsesToLength('reduce', {
	  1: 0
	}); // `Array.prototype.reduceRight` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.reduceright

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !STRICT_METHOD$6 || !USES_TO_LENGTH$a
	}, {
	  reduceRight: function reduceRight(callbackfn
	  /* , initialValue */
	  ) {
	    return $reduceRight(this, callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	var es_array_reduceRight = {};

	'use strict';

	var nativeReverse = [].reverse;
	var test$1 = [1, 2]; // `Array.prototype.reverse` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.reverse
	// fix for Safari 12.0 bug
	// https://bugs.webkit.org/show_bug.cgi?id=188794

	_export({
	  target: 'Array',
	  proto: true,
	  forced: String(test$1) === String(test$1.reverse())
	}, {
	  reverse: function reverse() {
	    // eslint-disable-next-line no-self-assign
	    if (isArray(this)) this.length = this.length;
	    return nativeReverse.call(this);
	  }
	});
	var es_array_reverse = {};

	'use strict';

	var HAS_SPECIES_SUPPORT$2 = arrayMethodHasSpeciesSupport('slice');
	var USES_TO_LENGTH$b = arrayMethodUsesToLength('slice', {
	  ACCESSORS: true,
	  0: 0,
	  1: 2
	});
	var SPECIES$2 = wellKnownSymbol('species');
	var nativeSlice = [].slice;
	var max$1 = Math.max; // `Array.prototype.slice` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.slice
	// fallback for not array-like ES3 strings and DOM objects

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$2 || !USES_TO_LENGTH$b
	}, {
	  slice: function slice(start, end) {
	    var O = toIndexedObject(this);
	    var length = toLength(O.length);
	    var k = toAbsoluteIndex(start, length);
	    var fin = toAbsoluteIndex(end === undefined ? length : end, length); // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible

	    var Constructor, result, n;

	    if (isArray(O)) {
	      Constructor = O.constructor; // cross-realm fallback

	      if (typeof Constructor == 'function' && (Constructor === Array || isArray(Constructor.prototype))) {
	        Constructor = undefined;
	      } else if (isObject(Constructor)) {
	        Constructor = Constructor[SPECIES$2];
	        if (Constructor === null) Constructor = undefined;
	      }

	      if (Constructor === Array || Constructor === undefined) {
	        return nativeSlice.call(O, k, fin);
	      }
	    }

	    result = new (Constructor === undefined ? Array : Constructor)(max$1(fin - k, 0));

	    for (n = 0; k < fin; k++, n++) {
	      if (k in O) createProperty(result, n, O[k]);
	    }

	    result.length = n;
	    return result;
	  }
	});
	var es_array_slice = {};

	'use strict';

	var $some = arrayIteration.some;
	var STRICT_METHOD$7 = arrayMethodIsStrict('some');
	var USES_TO_LENGTH$c = arrayMethodUsesToLength('some'); // `Array.prototype.some` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.some

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !STRICT_METHOD$7 || !USES_TO_LENGTH$c
	}, {
	  some: function some(callbackfn
	  /* , thisArg */
	  ) {
	    return $some(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	var es_array_some = {};

	'use strict';

	var test$2 = [];
	var nativeSort = test$2.sort; // IE8-

	var FAILS_ON_UNDEFINED = fails(function () {
	  test$2.sort(undefined);
	}); // V8 bug

	var FAILS_ON_NULL = fails(function () {
	  test$2.sort(null);
	}); // Old WebKit

	var STRICT_METHOD$8 = arrayMethodIsStrict('sort');
	var FORCED$3 = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD$8; // `Array.prototype.sort` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.sort

	_export({
	  target: 'Array',
	  proto: true,
	  forced: FORCED$3
	}, {
	  sort: function sort(comparefn) {
	    return comparefn === undefined ? nativeSort.call(toObject(this)) : nativeSort.call(toObject(this), aFunction$1(comparefn));
	  }
	});
	var es_array_sort = {};

	'use strict';

	var HAS_SPECIES_SUPPORT$3 = arrayMethodHasSpeciesSupport('splice');
	var USES_TO_LENGTH$d = arrayMethodUsesToLength('splice', {
	  ACCESSORS: true,
	  0: 0,
	  1: 2
	});
	var max$2 = Math.max;
	var min$4 = Math.min;
	var MAX_SAFE_INTEGER$1 = 0x1FFFFFFFFFFFFF;
	var MAXIMUM_ALLOWED_LENGTH_EXCEEDED = 'Maximum allowed length exceeded'; // `Array.prototype.splice` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.splice
	// with adding support of @@species

	_export({
	  target: 'Array',
	  proto: true,
	  forced: !HAS_SPECIES_SUPPORT$3 || !USES_TO_LENGTH$d
	}, {
	  splice: function splice(start, deleteCount
	  /* , ...items */
	  ) {
	    var O = toObject(this);
	    var len = toLength(O.length);
	    var actualStart = toAbsoluteIndex(start, len);
	    var argumentsLength = arguments.length;
	    var insertCount, actualDeleteCount, A, k, from, to;

	    if (argumentsLength === 0) {
	      insertCount = actualDeleteCount = 0;
	    } else if (argumentsLength === 1) {
	      insertCount = 0;
	      actualDeleteCount = len - actualStart;
	    } else {
	      insertCount = argumentsLength - 2;
	      actualDeleteCount = min$4(max$2(toInteger(deleteCount), 0), len - actualStart);
	    }

	    if (len + insertCount - actualDeleteCount > MAX_SAFE_INTEGER$1) {
	      throw TypeError(MAXIMUM_ALLOWED_LENGTH_EXCEEDED);
	    }

	    A = arraySpeciesCreate(O, actualDeleteCount);

	    for (k = 0; k < actualDeleteCount; k++) {
	      from = actualStart + k;
	      if (from in O) createProperty(A, k, O[from]);
	    }

	    A.length = actualDeleteCount;

	    if (insertCount < actualDeleteCount) {
	      for (k = actualStart; k < len - actualDeleteCount; k++) {
	        from = k + actualDeleteCount;
	        to = k + insertCount;
	        if (from in O) O[to] = O[from];else delete O[to];
	      }

	      for (k = len; k > len - actualDeleteCount + insertCount; k--) {
	        delete O[k - 1];
	      }
	    } else if (insertCount > actualDeleteCount) {
	      for (k = len - actualDeleteCount; k > actualStart; k--) {
	        from = k + actualDeleteCount - 1;
	        to = k + insertCount - 1;
	        if (from in O) O[to] = O[from];else delete O[to];
	      }
	    }

	    for (k = 0; k < insertCount; k++) {
	      O[k + actualStart] = arguments[k + 2];
	    }

	    O.length = len - actualDeleteCount + insertCount;
	    return A;
	  }
	});
	var es_array_splice = {};

	'use strict';

	var SPECIES$3 = wellKnownSymbol('species');

	var setSpecies = function setSpecies(CONSTRUCTOR_NAME) {
	  var Constructor = getBuiltIn(CONSTRUCTOR_NAME);
	  var defineProperty = objectDefineProperty.f;

	  if (descriptors && Constructor && !Constructor[SPECIES$3]) {
	    defineProperty(Constructor, SPECIES$3, {
	      configurable: true,
	      get: function get() {
	        return this;
	      }
	    });
	  }
	};

	// https://tc39.github.io/ecma262/#sec-get-array-@@species

	setSpecies('Array');
	var es_array_species = {};

	// in popular engines, so it's moved to a separate module

	addToUnscopables('flat');
	var es_array_unscopables_flat = {};

	// in popular engines, so it's moved to a separate module

	addToUnscopables('flatMap');
	var es_array_unscopables_flatMap = {};

	'use strict';

	var ITERATOR$3 = wellKnownSymbol('iterator');
	var BUGGY_SAFARI_ITERATORS = false;

	var returnThis = function returnThis() {
	  return this;
	}; // `%IteratorPrototype%` object
	// https://tc39.github.io/ecma262/#sec-%iteratorprototype%-object


	var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;

	if ([].keys) {
	  arrayIterator = [].keys(); // Safari 8 has buggy iterators w/o `next`

	  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;else {
	    PrototypeOfArrayIteratorPrototype = objectGetPrototypeOf(objectGetPrototypeOf(arrayIterator));
	    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
	  }
	}

	if (IteratorPrototype == undefined) IteratorPrototype = {}; // 25.1.2.1.1 %IteratorPrototype%[@@iterator]()

	if (!isPure && !has(IteratorPrototype, ITERATOR$3)) {
	  createNonEnumerableProperty(IteratorPrototype, ITERATOR$3, returnThis);
	}

	var iteratorsCore = {
	  IteratorPrototype: IteratorPrototype,
	  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
	};
	var iteratorsCore_1 = iteratorsCore.IteratorPrototype;
	var iteratorsCore_2 = iteratorsCore.BUGGY_SAFARI_ITERATORS;

	'use strict';

	var IteratorPrototype$1 = iteratorsCore.IteratorPrototype;

	var returnThis$1 = function returnThis() {
	  return this;
	};

	var createIteratorConstructor = function createIteratorConstructor(IteratorConstructor, NAME, next) {
	  var TO_STRING_TAG = NAME + ' Iterator';
	  IteratorConstructor.prototype = objectCreate(IteratorPrototype$1, {
	    next: createPropertyDescriptor(1, next)
	  });
	  setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
	  iterators[TO_STRING_TAG] = returnThis$1;
	  return IteratorConstructor;
	};

	'use strict';

	var IteratorPrototype$2 = iteratorsCore.IteratorPrototype;
	var BUGGY_SAFARI_ITERATORS$1 = iteratorsCore.BUGGY_SAFARI_ITERATORS;
	var ITERATOR$4 = wellKnownSymbol('iterator');
	var KEYS = 'keys';
	var VALUES = 'values';
	var ENTRIES = 'entries';

	var returnThis$2 = function returnThis() {
	  return this;
	};

	var defineIterator = function defineIterator(Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
	  createIteratorConstructor(IteratorConstructor, NAME, next);

	  var getIterationMethod = function getIterationMethod(KIND) {
	    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
	    if (!BUGGY_SAFARI_ITERATORS$1 && KIND in IterablePrototype) return IterablePrototype[KIND];

	    switch (KIND) {
	      case KEYS:
	        return function keys() {
	          return new IteratorConstructor(this, KIND);
	        };

	      case VALUES:
	        return function values() {
	          return new IteratorConstructor(this, KIND);
	        };

	      case ENTRIES:
	        return function entries() {
	          return new IteratorConstructor(this, KIND);
	        };
	    }

	    return function () {
	      return new IteratorConstructor(this);
	    };
	  };

	  var TO_STRING_TAG = NAME + ' Iterator';
	  var INCORRECT_VALUES_NAME = false;
	  var IterablePrototype = Iterable.prototype;
	  var nativeIterator = IterablePrototype[ITERATOR$4] || IterablePrototype['@@iterator'] || DEFAULT && IterablePrototype[DEFAULT];
	  var defaultIterator = !BUGGY_SAFARI_ITERATORS$1 && nativeIterator || getIterationMethod(DEFAULT);
	  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
	  var CurrentIteratorPrototype, methods, KEY; // fix native

	  if (anyNativeIterator) {
	    CurrentIteratorPrototype = objectGetPrototypeOf(anyNativeIterator.call(new Iterable()));

	    if (IteratorPrototype$2 !== Object.prototype && CurrentIteratorPrototype.next) {
	      if (!isPure && objectGetPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype$2) {
	        if (objectSetPrototypeOf) {
	          objectSetPrototypeOf(CurrentIteratorPrototype, IteratorPrototype$2);
	        } else if (typeof CurrentIteratorPrototype[ITERATOR$4] != 'function') {
	          createNonEnumerableProperty(CurrentIteratorPrototype, ITERATOR$4, returnThis$2);
	        }
	      } // Set @@toStringTag to native iterators


	      setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
	      if (isPure) iterators[TO_STRING_TAG] = returnThis$2;
	    }
	  } // fix Array#{values, @@iterator}.name in V8 / FF


	  if (DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
	    INCORRECT_VALUES_NAME = true;

	    defaultIterator = function values() {
	      return nativeIterator.call(this);
	    };
	  } // define iterator


	  if ((!isPure || FORCED) && IterablePrototype[ITERATOR$4] !== defaultIterator) {
	    createNonEnumerableProperty(IterablePrototype, ITERATOR$4, defaultIterator);
	  }

	  iterators[NAME] = defaultIterator; // export additional methods

	  if (DEFAULT) {
	    methods = {
	      values: getIterationMethod(VALUES),
	      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
	      entries: getIterationMethod(ENTRIES)
	    };
	    if (FORCED) for (KEY in methods) {
	      if (BUGGY_SAFARI_ITERATORS$1 || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
	        redefine(IterablePrototype, KEY, methods[KEY]);
	      }
	    } else _export({
	      target: NAME,
	      proto: true,
	      forced: BUGGY_SAFARI_ITERATORS$1 || INCORRECT_VALUES_NAME
	    }, methods);
	  }

	  return methods;
	};

	'use strict';

	var ARRAY_ITERATOR = 'Array Iterator';
	var setInternalState$1 = internalState.set;
	var getInternalState$1 = internalState.getterFor(ARRAY_ITERATOR); // `Array.prototype.entries` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.entries
	// `Array.prototype.keys` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.keys
	// `Array.prototype.values` method
	// https://tc39.github.io/ecma262/#sec-array.prototype.values
	// `Array.prototype[@@iterator]` method
	// https://tc39.github.io/ecma262/#sec-array.prototype-@@iterator
	// `CreateArrayIterator` internal method
	// https://tc39.github.io/ecma262/#sec-createarrayiterator

	var es_array_iterator = defineIterator(Array, 'Array', function (iterated, kind) {
	  setInternalState$1(this, {
	    type: ARRAY_ITERATOR,
	    target: toIndexedObject(iterated),
	    // target
	    index: 0,
	    // next index
	    kind: kind // kind

	  }); // `%ArrayIteratorPrototype%.next` method
	  // https://tc39.github.io/ecma262/#sec-%arrayiteratorprototype%.next
	}, function () {
	  var state = getInternalState$1(this);
	  var target = state.target;
	  var kind = state.kind;
	  var index = state.index++;

	  if (!target || index >= target.length) {
	    state.target = undefined;
	    return {
	      value: undefined,
	      done: true
	    };
	  }

	  if (kind == 'keys') return {
	    value: index,
	    done: false
	  };
	  if (kind == 'values') return {
	    value: target[index],
	    done: false
	  };
	  return {
	    value: [index, target[index]],
	    done: false
	  };
	}, 'values'); // argumentsList[@@iterator] is %ArrayProto_values%
	// https://tc39.github.io/ecma262/#sec-createunmappedargumentsobject
	// https://tc39.github.io/ecma262/#sec-createmappedargumentsobject

	iterators.Arguments = iterators.Array; // https://tc39.github.io/ecma262/#sec-array.prototype-@@unscopables

	addToUnscopables('keys');
	addToUnscopables('values');
	addToUnscopables('entries');

	var fromCharCode = String.fromCharCode;
	var nativeFromCodePoint = String.fromCodePoint; // length should be 1, old FF problem

	var INCORRECT_LENGTH = !!nativeFromCodePoint && nativeFromCodePoint.length != 1; // `String.fromCodePoint` method
	// https://tc39.github.io/ecma262/#sec-string.fromcodepoint

	_export({
	  target: 'String',
	  stat: true,
	  forced: INCORRECT_LENGTH
	}, {
	  fromCodePoint: function fromCodePoint(x) {
	    // eslint-disable-line no-unused-vars
	    var elements = [];
	    var length = arguments.length;
	    var i = 0;
	    var code;

	    while (length > i) {
	      code = +arguments[i++];
	      if (toAbsoluteIndex(code, 0x10FFFF) !== code) throw RangeError(code + ' is not a valid code point');
	      elements.push(code < 0x10000 ? fromCharCode(code) : fromCharCode(((code -= 0x10000) >> 10) + 0xD800, code % 0x400 + 0xDC00));
	    }

	    return elements.join('');
	  }
	});
	var es_string_fromCodePoint = {};

	// https://tc39.github.io/ecma262/#sec-string.raw

	_export({
	  target: 'String',
	  stat: true
	}, {
	  raw: function raw(template) {
	    var rawTemplate = toIndexedObject(template.raw);
	    var literalSegments = toLength(rawTemplate.length);
	    var argumentsLength = arguments.length;
	    var elements = [];
	    var i = 0;

	    while (literalSegments > i) {
	      elements.push(String(rawTemplate[i++]));
	      if (i < argumentsLength) elements.push(String(arguments[i]));
	    }

	    return elements.join('');
	  }
	});
	var es_string_raw = {};

	var createMethod$4 = function createMethod(CONVERT_TO_STRING) {
	  return function ($this, pos) {
	    var S = String(requireObjectCoercible($this));
	    var position = toInteger(pos);
	    var size = S.length;
	    var first, second;
	    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
	    first = S.charCodeAt(position);
	    return first < 0xD800 || first > 0xDBFF || position + 1 === size || (second = S.charCodeAt(position + 1)) < 0xDC00 || second > 0xDFFF ? CONVERT_TO_STRING ? S.charAt(position) : first : CONVERT_TO_STRING ? S.slice(position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
	  };
	};

	var stringMultibyte = {
	  // `String.prototype.codePointAt` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.codepointat
	  codeAt: createMethod$4(false),
	  // `String.prototype.at` method
	  // https://github.com/mathiasbynens/String.prototype.at
	  charAt: createMethod$4(true)
	};
	var stringMultibyte_1 = stringMultibyte.codeAt;
	var stringMultibyte_2 = stringMultibyte.charAt;

	'use strict';

	var codeAt = stringMultibyte.codeAt; // `String.prototype.codePointAt` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.codepointat

	_export({
	  target: 'String',
	  proto: true
	}, {
	  codePointAt: function codePointAt(pos) {
	    return codeAt(this, pos);
	  }
	});
	var es_string_codePointAt = {};

	var MATCH = wellKnownSymbol('match'); // `IsRegExp` abstract operation
	// https://tc39.github.io/ecma262/#sec-isregexp

	var isRegexp = function isRegexp(it) {
	  var isRegExp;
	  return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : classofRaw(it) == 'RegExp');
	};

	var notARegexp = function notARegexp(it) {
	  if (isRegexp(it)) {
	    throw TypeError("The method doesn't accept regular expressions");
	  }

	  return it;
	};

	var MATCH$1 = wellKnownSymbol('match');

	var correctIsRegexpLogic = function correctIsRegexpLogic(METHOD_NAME) {
	  var regexp = /./;

	  try {
	    '/./'[METHOD_NAME](regexp);
	  } catch (e) {
	    try {
	      regexp[MATCH$1] = false;
	      return '/./'[METHOD_NAME](regexp);
	    } catch (f) {
	      /* empty */
	    }
	  }

	  return false;
	};

	'use strict';

	var getOwnPropertyDescriptor$4 = objectGetOwnPropertyDescriptor.f;
	var nativeEndsWith = ''.endsWith;
	var min$5 = Math.min;
	var CORRECT_IS_REGEXP_LOGIC = correctIsRegexpLogic('endsWith'); // https://github.com/zloirock/core-js/pull/702

	var MDN_POLYFILL_BUG = !isPure && !CORRECT_IS_REGEXP_LOGIC && !!function () {
	  var descriptor = getOwnPropertyDescriptor$4(String.prototype, 'endsWith');
	  return descriptor && !descriptor.writable;
	}(); // `String.prototype.endsWith` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.endswith

	_export({
	  target: 'String',
	  proto: true,
	  forced: !MDN_POLYFILL_BUG && !CORRECT_IS_REGEXP_LOGIC
	}, {
	  endsWith: function endsWith(searchString
	  /* , endPosition = @length */
	  ) {
	    var that = String(requireObjectCoercible(this));
	    notARegexp(searchString);
	    var endPosition = arguments.length > 1 ? arguments[1] : undefined;
	    var len = toLength(that.length);
	    var end = endPosition === undefined ? len : min$5(toLength(endPosition), len);
	    var search = String(searchString);
	    return nativeEndsWith ? nativeEndsWith.call(that, search, end) : that.slice(end - search.length, end) === search;
	  }
	});
	var es_string_endsWith = {};

	'use strict'; // `String.prototype.includes` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.includes


	_export({
	  target: 'String',
	  proto: true,
	  forced: !correctIsRegexpLogic('includes')
	}, {
	  includes: function includes(searchString
	  /* , position = 0 */
	  ) {
	    return !!~String(requireObjectCoercible(this)).indexOf(notARegexp(searchString), arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	var es_string_includes = {};

	'use strict'; // `RegExp.prototype.flags` getter implementation
	// https://tc39.github.io/ecma262/#sec-get-regexp.prototype.flags


	var regexpFlags = function regexpFlags() {
	  var that = anObject(this);
	  var result = '';
	  if (that.global) result += 'g';
	  if (that.ignoreCase) result += 'i';
	  if (that.multiline) result += 'm';
	  if (that.dotAll) result += 's';
	  if (that.unicode) result += 'u';
	  if (that.sticky) result += 'y';
	  return result;
	};

	'use strict'; // babel-minify transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError,
	// so we use an intermediate function.


	function RE(s, f) {
	  return RegExp(s, f);
	}

	var UNSUPPORTED_Y = fails(function () {
	  // babel-minify transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError
	  var re = RE('a', 'y');
	  re.lastIndex = 2;
	  return re.exec('abcd') != null;
	});
	var BROKEN_CARET = fails(function () {
	  // https://bugzilla.mozilla.org/show_bug.cgi?id=773687
	  var re = RE('^r', 'gy');
	  re.lastIndex = 2;
	  return re.exec('str') != null;
	});
	var regexpStickyHelpers = {
	  UNSUPPORTED_Y: UNSUPPORTED_Y,
	  BROKEN_CARET: BROKEN_CARET
	};

	'use strict';

	var nativeExec = RegExp.prototype.exec; // This always refers to the native implementation, because the
	// String#replace polyfill uses ./fix-regexp-well-known-symbol-logic.js,
	// which loads this file before patching the method.

	var nativeReplace = String.prototype.replace;
	var patchedExec = nativeExec;

	var UPDATES_LAST_INDEX_WRONG = function () {
	  var re1 = /a/;
	  var re2 = /b*/g;
	  nativeExec.call(re1, 'a');
	  nativeExec.call(re2, 'a');
	  return re1.lastIndex !== 0 || re2.lastIndex !== 0;
	}();

	var UNSUPPORTED_Y$1 = regexpStickyHelpers.UNSUPPORTED_Y || regexpStickyHelpers.BROKEN_CARET; // nonparticipating capturing group, copied from es5-shim's String#split patch.

	var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;
	var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y$1;

	if (PATCH) {
	  patchedExec = function exec(str) {
	    var re = this;
	    var lastIndex, reCopy, match, i;
	    var sticky = UNSUPPORTED_Y$1 && re.sticky;
	    var flags = regexpFlags.call(re);
	    var source = re.source;
	    var charsAdded = 0;
	    var strCopy = str;

	    if (sticky) {
	      flags = flags.replace('y', '');

	      if (flags.indexOf('g') === -1) {
	        flags += 'g';
	      }

	      strCopy = String(str).slice(re.lastIndex); // Support anchored sticky behavior.

	      if (re.lastIndex > 0 && (!re.multiline || re.multiline && str[re.lastIndex - 1] !== '\n')) {
	        source = '(?: ' + source + ')';
	        strCopy = ' ' + strCopy;
	        charsAdded++;
	      } // ^(? + rx + ) is needed, in combination with some str slicing, to
	      // simulate the 'y' flag.


	      reCopy = new RegExp('^(?:' + source + ')', flags);
	    }

	    if (NPCG_INCLUDED) {
	      reCopy = new RegExp('^' + source + '$(?!\\s)', flags);
	    }

	    if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;
	    match = nativeExec.call(sticky ? reCopy : re, strCopy);

	    if (sticky) {
	      if (match) {
	        match.input = match.input.slice(charsAdded);
	        match[0] = match[0].slice(charsAdded);
	        match.index = re.lastIndex;
	        re.lastIndex += match[0].length;
	      } else re.lastIndex = 0;
	    } else if (UPDATES_LAST_INDEX_WRONG && match) {
	      re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
	    }

	    if (NPCG_INCLUDED && match && match.length > 1) {
	      // Fix browsers whose `exec` methods don't consistently return `undefined`
	      // for NPCG, like IE8. NOTE: This doesn' work for /(.?)?/
	      nativeReplace.call(match[0], reCopy, function () {
	        for (i = 1; i < arguments.length - 2; i++) {
	          if (arguments[i] === undefined) match[i] = undefined;
	        }
	      });
	    }

	    return match;
	  };
	}

	var regexpExec = patchedExec;

	'use strict';

	_export({
	  target: 'RegExp',
	  proto: true,
	  forced: /./.exec !== regexpExec
	}, {
	  exec: regexpExec
	});
	var es_regexp_exec = {};

	'use strict'; // TODO: Remove from `core-js@4` since it's moved to entry points


	var SPECIES$4 = wellKnownSymbol('species');
	var REPLACE_SUPPORTS_NAMED_GROUPS = !fails(function () {
	  // #replace needs built-in support for named groups.
	  // #match works fine because it just return the exec results, even if it has
	  // a "grops" property.
	  var re = /./;

	  re.exec = function () {
	    var result = [];
	    result.groups = {
	      a: '7'
	    };
	    return result;
	  };

	  return ''.replace(re, '$<a>') !== '7';
	}); // IE <= 11 replaces $0 with the whole match, as if it was $&
	// https://stackoverflow.com/questions/6024666/getting-ie-to-replace-a-regex-with-the-literal-string-0

	var REPLACE_KEEPS_$0 = function () {
	  return 'a'.replace(/./, '$0') === '$0';
	}();

	var REPLACE = wellKnownSymbol('replace'); // Safari <= 13.0.3(?) substitutes nth capture where n>m with an empty string

	var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = function () {
	  if (/./[REPLACE]) {
	    return /./[REPLACE]('a', '$0') === '';
	  }

	  return false;
	}(); // Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
	// Weex JS has frozen built-in prototypes, so use try / catch wrapper


	var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails(function () {
	  var re = /(?:)/;
	  var originalExec = re.exec;

	  re.exec = function () {
	    return originalExec.apply(this, arguments);
	  };

	  var result = 'ab'.split(re);
	  return result.length !== 2 || result[0] !== 'a' || result[1] !== 'b';
	});

	var fixRegexpWellKnownSymbolLogic = function fixRegexpWellKnownSymbolLogic(KEY, length, exec, sham) {
	  var SYMBOL = wellKnownSymbol(KEY);
	  var DELEGATES_TO_SYMBOL = !fails(function () {
	    // String methods call symbol-named RegEp methods
	    var O = {};

	    O[SYMBOL] = function () {
	      return 7;
	    };

	    return ''[KEY](O) != 7;
	  });
	  var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails(function () {
	    // Symbol-named RegExp methods call .exec
	    var execCalled = false;
	    var re = /a/;

	    if (KEY === 'split') {
	      // We can't use real regex here since it causes deoptimization
	      // and serious performance degradation in V8
	      // https://github.com/zloirock/core-js/issues/306
	      re = {}; // RegExp[@@split] doesn't call the regex's exec method, but first creates
	      // a new one. We need to return the patched regex when creating the new one.

	      re.constructor = {};

	      re.constructor[SPECIES$4] = function () {
	        return re;
	      };

	      re.flags = '';
	      re[SYMBOL] = /./[SYMBOL];
	    }

	    re.exec = function () {
	      execCalled = true;
	      return null;
	    };

	    re[SYMBOL]('');
	    return !execCalled;
	  });

	  if (!DELEGATES_TO_SYMBOL || !DELEGATES_TO_EXEC || KEY === 'replace' && !(REPLACE_SUPPORTS_NAMED_GROUPS && REPLACE_KEEPS_$0 && !REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE) || KEY === 'split' && !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC) {
	    var nativeRegExpMethod = /./[SYMBOL];
	    var methods = exec(SYMBOL, ''[KEY], function (nativeMethod, regexp, str, arg2, forceStringMethod) {
	      if (regexp.exec === regexpExec) {
	        if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
	          // The native String method already delegates to @@method (this
	          // polyfilled function), leasing to infinite recursion.
	          // We avoid it by directly calling the native @@method method.
	          return {
	            done: true,
	            value: nativeRegExpMethod.call(regexp, str, arg2)
	          };
	        }

	        return {
	          done: true,
	          value: nativeMethod.call(str, regexp, arg2)
	        };
	      }

	      return {
	        done: false
	      };
	    }, {
	      REPLACE_KEEPS_$0: REPLACE_KEEPS_$0,
	      REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE: REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE
	    });
	    var stringMethod = methods[0];
	    var regexMethod = methods[1];
	    redefine(String.prototype, KEY, stringMethod);
	    redefine(RegExp.prototype, SYMBOL, length == 2 // 21.2.5.8 RegExp.prototype[@@replace](string, replaceValue)
	    // 21.2.5.11 RegExp.prototype[@@split](string, limit)
	    ? function (string, arg) {
	      return regexMethod.call(string, this, arg);
	    } // 21.2.5.6 RegExp.prototype[@@match](string)
	    // 21.2.5.9 RegExp.prototype[@@search](string)
	    : function (string) {
	      return regexMethod.call(string, this);
	    });
	  }

	  if (sham) createNonEnumerableProperty(RegExp.prototype[SYMBOL], 'sham', true);
	};

	'use strict';

	var charAt = stringMultibyte.charAt; // `AdvanceStringIndex` abstract operation
	// https://tc39.github.io/ecma262/#sec-advancestringindex

	var advanceStringIndex = function advanceStringIndex(S, index, unicode) {
	  return index + (unicode ? charAt(S, index).length : 1);
	};

	// https://tc39.github.io/ecma262/#sec-regexpexec

	var regexpExecAbstract = function regexpExecAbstract(R, S) {
	  var exec = R.exec;

	  if (typeof exec === 'function') {
	    var result = exec.call(R, S);

	    if (typeof result !== 'object') {
	      throw TypeError('RegExp exec method returned something other than an Object or null');
	    }

	    return result;
	  }

	  if (classofRaw(R) !== 'RegExp') {
	    throw TypeError('RegExp#exec called on incompatible receiver');
	  }

	  return regexpExec.call(R, S);
	};

	'use strict'; // @@match logic


	fixRegexpWellKnownSymbolLogic('match', 1, function (MATCH, nativeMatch, maybeCallNative) {
	  return [// `String.prototype.match` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.match
	  function match(regexp) {
	    var O = requireObjectCoercible(this);
	    var matcher = regexp == undefined ? undefined : regexp[MATCH];
	    return matcher !== undefined ? matcher.call(regexp, O) : new RegExp(regexp)[MATCH](String(O));
	  }, // `RegExp.prototype[@@match]` method
	  // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@match
	  function (regexp) {
	    var res = maybeCallNative(nativeMatch, regexp, this);
	    if (res.done) return res.value;
	    var rx = anObject(regexp);
	    var S = String(this);
	    if (!rx.global) return regexpExecAbstract(rx, S);
	    var fullUnicode = rx.unicode;
	    rx.lastIndex = 0;
	    var A = [];
	    var n = 0;
	    var result;

	    while ((result = regexpExecAbstract(rx, S)) !== null) {
	      var matchStr = String(result[0]);
	      A[n] = matchStr;
	      if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
	      n++;
	    }

	    return n === 0 ? null : A;
	  }];
	});
	var es_string_match = {};

	var SPECIES$5 = wellKnownSymbol('species'); // `SpeciesConstructor` abstract operation
	// https://tc39.github.io/ecma262/#sec-speciesconstructor

	var speciesConstructor = function speciesConstructor(O, defaultConstructor) {
	  var C = anObject(O).constructor;
	  var S;
	  return C === undefined || (S = anObject(C)[SPECIES$5]) == undefined ? defaultConstructor : aFunction$1(S);
	};

	'use strict';

	var MATCH_ALL = wellKnownSymbol('matchAll');
	var REGEXP_STRING = 'RegExp String';
	var REGEXP_STRING_ITERATOR = REGEXP_STRING + ' Iterator';
	var setInternalState$2 = internalState.set;
	var getInternalState$2 = internalState.getterFor(REGEXP_STRING_ITERATOR);
	var RegExpPrototype = RegExp.prototype;
	var regExpBuiltinExec = RegExpPrototype.exec;
	var nativeMatchAll = ''.matchAll;
	var WORKS_WITH_NON_GLOBAL_REGEX = !!nativeMatchAll && !fails(function () {
	  'a'.matchAll(/./);
	});

	var regExpExec = function regExpExec(R, S) {
	  var exec = R.exec;
	  var result;

	  if (typeof exec == 'function') {
	    result = exec.call(R, S);
	    if (typeof result != 'object') throw TypeError('Incorrect exec result');
	    return result;
	  }

	  return regExpBuiltinExec.call(R, S);
	}; // eslint-disable-next-line max-len


	var $RegExpStringIterator = createIteratorConstructor(function RegExpStringIterator(regexp, string, global, fullUnicode) {
	  setInternalState$2(this, {
	    type: REGEXP_STRING_ITERATOR,
	    regexp: regexp,
	    string: string,
	    global: global,
	    unicode: fullUnicode,
	    done: false
	  });
	}, REGEXP_STRING, function next() {
	  var state = getInternalState$2(this);
	  if (state.done) return {
	    value: undefined,
	    done: true
	  };
	  var R = state.regexp;
	  var S = state.string;
	  var match = regExpExec(R, S);
	  if (match === null) return {
	    value: undefined,
	    done: state.done = true
	  };

	  if (state.global) {
	    if (String(match[0]) == '') R.lastIndex = advanceStringIndex(S, toLength(R.lastIndex), state.unicode);
	    return {
	      value: match,
	      done: false
	    };
	  }

	  state.done = true;
	  return {
	    value: match,
	    done: false
	  };
	});

	var $matchAll = function $matchAll(string) {
	  var R = anObject(this);
	  var S = String(string);
	  var C, flagsValue, flags, matcher, global, fullUnicode;
	  C = speciesConstructor(R, RegExp);
	  flagsValue = R.flags;

	  if (flagsValue === undefined && R instanceof RegExp && !('flags' in RegExpPrototype)) {
	    flagsValue = regexpFlags.call(R);
	  }

	  flags = flagsValue === undefined ? '' : String(flagsValue);
	  matcher = new C(C === RegExp ? R.source : R, flags);
	  global = !!~flags.indexOf('g');
	  fullUnicode = !!~flags.indexOf('u');
	  matcher.lastIndex = toLength(R.lastIndex);
	  return new $RegExpStringIterator(matcher, S, global, fullUnicode);
	}; // `String.prototype.matchAll` method
	// https://github.com/tc39/proposal-string-matchall


	_export({
	  target: 'String',
	  proto: true,
	  forced: WORKS_WITH_NON_GLOBAL_REGEX
	}, {
	  matchAll: function matchAll(regexp) {
	    var O = requireObjectCoercible(this);
	    var flags, S, matcher, rx;

	    if (regexp != null) {
	      if (isRegexp(regexp)) {
	        flags = String(requireObjectCoercible('flags' in RegExpPrototype ? regexp.flags : regexpFlags.call(regexp)));
	        if (!~flags.indexOf('g')) throw TypeError('`.matchAll` does not allow non-global regexes');
	      }

	      if (WORKS_WITH_NON_GLOBAL_REGEX) return nativeMatchAll.apply(O, arguments);
	      matcher = regexp[MATCH_ALL];
	      if (matcher === undefined && isPure && classofRaw(regexp) == 'RegExp') matcher = $matchAll;
	      if (matcher != null) return aFunction$1(matcher).call(regexp, O);
	    } else if (WORKS_WITH_NON_GLOBAL_REGEX) return nativeMatchAll.apply(O, arguments);

	    S = String(O);
	    rx = new RegExp(regexp, 'g');
	    return isPure ? $matchAll.call(rx, S) : rx[MATCH_ALL](S);
	  }
	});
	isPure || MATCH_ALL in RegExpPrototype || createNonEnumerableProperty(RegExpPrototype, MATCH_ALL, $matchAll);
	var es_string_matchAll = {};

	'use strict'; // `String.prototype.repeat` method implementation
	// https://tc39.github.io/ecma262/#sec-string.prototype.repeat


	var stringRepeat = ''.repeat || function repeat(count) {
	  var str = String(requireObjectCoercible(this));
	  var result = '';
	  var n = toInteger(count);
	  if (n < 0 || n == Infinity) throw RangeError('Wrong number of repetitions');

	  for (; n > 0; (n >>>= 1) && (str += str)) {
	    if (n & 1) result += str;
	  }

	  return result;
	};

	var ceil$1 = Math.ceil; // `String.prototype.{ padStart, padEnd }` methods implementation

	var createMethod$5 = function createMethod(IS_END) {
	  return function ($this, maxLength, fillString) {
	    var S = String(requireObjectCoercible($this));
	    var stringLength = S.length;
	    var fillStr = fillString === undefined ? ' ' : String(fillString);
	    var intMaxLength = toLength(maxLength);
	    var fillLen, stringFiller;
	    if (intMaxLength <= stringLength || fillStr == '') return S;
	    fillLen = intMaxLength - stringLength;
	    stringFiller = stringRepeat.call(fillStr, ceil$1(fillLen / fillStr.length));
	    if (stringFiller.length > fillLen) stringFiller = stringFiller.slice(0, fillLen);
	    return IS_END ? S + stringFiller : stringFiller + S;
	  };
	};

	var stringPad = {
	  // `String.prototype.padStart` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.padstart
	  start: createMethod$5(false),
	  // `String.prototype.padEnd` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.padend
	  end: createMethod$5(true)
	};
	var stringPad_1 = stringPad.start;
	var stringPad_2 = stringPad.end;

	// eslint-disable-next-line unicorn/no-unsafe-regex

	var stringPadWebkitBug = /Version\/10\.\d+(\.\d+)?( Mobile\/\w+)? Safari\//.test(engineUserAgent);

	'use strict';

	var $padEnd = stringPad.end; // `String.prototype.padEnd` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.padend

	_export({
	  target: 'String',
	  proto: true,
	  forced: stringPadWebkitBug
	}, {
	  padEnd: function padEnd(maxLength
	  /* , fillString = ' ' */
	  ) {
	    return $padEnd(this, maxLength, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	var es_string_padEnd = {};

	'use strict';

	var $padStart = stringPad.start; // `String.prototype.padStart` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.padstart

	_export({
	  target: 'String',
	  proto: true,
	  forced: stringPadWebkitBug
	}, {
	  padStart: function padStart(maxLength
	  /* , fillString = ' ' */
	  ) {
	    return $padStart(this, maxLength, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	var es_string_padStart = {};

	// https://tc39.github.io/ecma262/#sec-string.prototype.repeat

	_export({
	  target: 'String',
	  proto: true
	}, {
	  repeat: stringRepeat
	});
	var es_string_repeat = {};

	'use strict';

	var max$3 = Math.max;
	var min$6 = Math.min;
	var floor$1 = Math.floor;
	var SUBSTITUTION_SYMBOLS = /\$([$&'`]|\d\d?|<[^>]*>)/g;
	var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&'`]|\d\d?)/g;

	var maybeToString = function maybeToString(it) {
	  return it === undefined ? it : String(it);
	}; // @@replace logic


	fixRegexpWellKnownSymbolLogic('replace', 2, function (REPLACE, nativeReplace, maybeCallNative, reason) {
	  var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = reason.REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE;
	  var REPLACE_KEEPS_$0 = reason.REPLACE_KEEPS_$0;
	  var UNSAFE_SUBSTITUTE = REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE ? '$' : '$0';
	  return [// `String.prototype.replace` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.replace
	  function replace(searchValue, replaceValue) {
	    var O = requireObjectCoercible(this);
	    var replacer = searchValue == undefined ? undefined : searchValue[REPLACE];
	    return replacer !== undefined ? replacer.call(searchValue, O, replaceValue) : nativeReplace.call(String(O), searchValue, replaceValue);
	  }, // `RegExp.prototype[@@replace]` method
	  // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@replace
	  function (regexp, replaceValue) {
	    if (!REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE && REPLACE_KEEPS_$0 || typeof replaceValue === 'string' && replaceValue.indexOf(UNSAFE_SUBSTITUTE) === -1) {
	      var res = maybeCallNative(nativeReplace, regexp, this, replaceValue);
	      if (res.done) return res.value;
	    }

	    var rx = anObject(regexp);
	    var S = String(this);
	    var functionalReplace = typeof replaceValue === 'function';
	    if (!functionalReplace) replaceValue = String(replaceValue);
	    var global = rx.global;

	    if (global) {
	      var fullUnicode = rx.unicode;
	      rx.lastIndex = 0;
	    }

	    var results = [];

	    while (true) {
	      var result = regexpExecAbstract(rx, S);
	      if (result === null) break;
	      results.push(result);
	      if (!global) break;
	      var matchStr = String(result[0]);
	      if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
	    }

	    var accumulatedResult = '';
	    var nextSourcePosition = 0;

	    for (var i = 0; i < results.length; i++) {
	      result = results[i];
	      var matched = String(result[0]);
	      var position = max$3(min$6(toInteger(result.index), S.length), 0);
	      var captures = []; // NOTE: This is equivalent to
	      //   captures = result.slice(1).map(maybeToString)
	      // but for some reason `nativeSlice.call(result, 1, result.length)` (called in
	      // the slice polyfill when slicing native arrays) "doesn't work" in safari 9 and
	      // causes a crash (https://pastebin.com/N21QzeQA) when trying to debug it.

	      for (var j = 1; j < result.length; j++) {
	        captures.push(maybeToString(result[j]));
	      }

	      var namedCaptures = result.groups;

	      if (functionalReplace) {
	        var replacerArgs = [matched].concat(captures, position, S);
	        if (namedCaptures !== undefined) replacerArgs.push(namedCaptures);
	        var replacement = String(replaceValue.apply(undefined, replacerArgs));
	      } else {
	        replacement = getSubstitution(matched, S, position, captures, namedCaptures, replaceValue);
	      }

	      if (position >= nextSourcePosition) {
	        accumulatedResult += S.slice(nextSourcePosition, position) + replacement;
	        nextSourcePosition = position + matched.length;
	      }
	    }

	    return accumulatedResult + S.slice(nextSourcePosition);
	  }]; // https://tc39.github.io/ecma262/#sec-getsubstitution

	  function getSubstitution(matched, str, position, captures, namedCaptures, replacement) {
	    var tailPos = position + matched.length;
	    var m = captures.length;
	    var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;

	    if (namedCaptures !== undefined) {
	      namedCaptures = toObject(namedCaptures);
	      symbols = SUBSTITUTION_SYMBOLS;
	    }

	    return nativeReplace.call(replacement, symbols, function (match, ch) {
	      var capture;

	      switch (ch.charAt(0)) {
	        case '$':
	          return '$';

	        case '&':
	          return matched;

	        case '`':
	          return str.slice(0, position);

	        case "'":
	          return str.slice(tailPos);

	        case '<':
	          capture = namedCaptures[ch.slice(1, -1)];
	          break;

	        default:
	          // \d\d?
	          var n = +ch;
	          if (n === 0) return match;

	          if (n > m) {
	            var f = floor$1(n / 10);
	            if (f === 0) return match;
	            if (f <= m) return captures[f - 1] === undefined ? ch.charAt(1) : captures[f - 1] + ch.charAt(1);
	            return match;
	          }

	          capture = captures[n - 1];
	      }

	      return capture === undefined ? '' : capture;
	    });
	  }
	});
	var es_string_replace = {};

	'use strict'; // @@search logic


	fixRegexpWellKnownSymbolLogic('search', 1, function (SEARCH, nativeSearch, maybeCallNative) {
	  return [// `String.prototype.search` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.search
	  function search(regexp) {
	    var O = requireObjectCoercible(this);
	    var searcher = regexp == undefined ? undefined : regexp[SEARCH];
	    return searcher !== undefined ? searcher.call(regexp, O) : new RegExp(regexp)[SEARCH](String(O));
	  }, // `RegExp.prototype[@@search]` method
	  // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@search
	  function (regexp) {
	    var res = maybeCallNative(nativeSearch, regexp, this);
	    if (res.done) return res.value;
	    var rx = anObject(regexp);
	    var S = String(this);
	    var previousLastIndex = rx.lastIndex;
	    if (!sameValue(previousLastIndex, 0)) rx.lastIndex = 0;
	    var result = regexpExecAbstract(rx, S);
	    if (!sameValue(rx.lastIndex, previousLastIndex)) rx.lastIndex = previousLastIndex;
	    return result === null ? -1 : result.index;
	  }];
	});
	var es_string_search = {};

	'use strict';

	var arrayPush = [].push;
	var min$7 = Math.min;
	var MAX_UINT32 = 0xFFFFFFFF; // babel-minify transpiles RegExp('x', 'y') -> /x/y and it causes SyntaxError

	var SUPPORTS_Y = !fails(function () {
	  return !RegExp(MAX_UINT32, 'y');
	}); // @@split logic

	fixRegexpWellKnownSymbolLogic('split', 2, function (SPLIT, nativeSplit, maybeCallNative) {
	  var internalSplit;

	  if ('abbc'.split(/(b)*/)[1] == 'c' || 'test'.split(/(?:)/, -1).length != 4 || 'ab'.split(/(?:ab)*/).length != 2 || '.'.split(/(.?)(.?)/).length != 4 || '.'.split(/()()/).length > 1 || ''.split(/.?/).length) {
	    // based on es5-shim implementation, need to rework it
	    internalSplit = function internalSplit(separator, limit) {
	      var string = String(requireObjectCoercible(this));
	      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
	      if (lim === 0) return [];
	      if (separator === undefined) return [string]; // If `separator` is not a regex, use native split

	      if (!isRegexp(separator)) {
	        return nativeSplit.call(string, separator, lim);
	      }

	      var output = [];
	      var flags = (separator.ignoreCase ? 'i' : '') + (separator.multiline ? 'm' : '') + (separator.unicode ? 'u' : '') + (separator.sticky ? 'y' : '');
	      var lastLastIndex = 0; // Make `global` and avoid `lastIndex` issues by working with a copy

	      var separatorCopy = new RegExp(separator.source, flags + 'g');
	      var match, lastIndex, lastLength;

	      while (match = regexpExec.call(separatorCopy, string)) {
	        lastIndex = separatorCopy.lastIndex;

	        if (lastIndex > lastLastIndex) {
	          output.push(string.slice(lastLastIndex, match.index));
	          if (match.length > 1 && match.index < string.length) arrayPush.apply(output, match.slice(1));
	          lastLength = match[0].length;
	          lastLastIndex = lastIndex;
	          if (output.length >= lim) break;
	        }

	        if (separatorCopy.lastIndex === match.index) separatorCopy.lastIndex++; // Avoid an infinite loop
	      }

	      if (lastLastIndex === string.length) {
	        if (lastLength || !separatorCopy.test('')) output.push('');
	      } else output.push(string.slice(lastLastIndex));

	      return output.length > lim ? output.slice(0, lim) : output;
	    }; // Chakra, V8

	  } else if ('0'.split(undefined, 0).length) {
	    internalSplit = function internalSplit(separator, limit) {
	      return separator === undefined && limit === 0 ? [] : nativeSplit.call(this, separator, limit);
	    };
	  } else internalSplit = nativeSplit;

	  return [// `String.prototype.split` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.split
	  function split(separator, limit) {
	    var O = requireObjectCoercible(this);
	    var splitter = separator == undefined ? undefined : separator[SPLIT];
	    return splitter !== undefined ? splitter.call(separator, O, limit) : internalSplit.call(String(O), separator, limit);
	  }, // `RegExp.prototype[@@split]` method
	  // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@split
	  //
	  // NOTE: This cannot be properly polyfilled in engines that don't support
	  // the 'y' flag.
	  function (regexp, limit) {
	    var res = maybeCallNative(internalSplit, regexp, this, limit, internalSplit !== nativeSplit);
	    if (res.done) return res.value;
	    var rx = anObject(regexp);
	    var S = String(this);
	    var C = speciesConstructor(rx, RegExp);
	    var unicodeMatching = rx.unicode;
	    var flags = (rx.ignoreCase ? 'i' : '') + (rx.multiline ? 'm' : '') + (rx.unicode ? 'u' : '') + (SUPPORTS_Y ? 'y' : 'g'); // ^(? + rx + ) is needed, in combination with some S slicing, to
	    // simulate the 'y' flag.

	    var splitter = new C(SUPPORTS_Y ? rx : '^(?:' + rx.source + ')', flags);
	    var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
	    if (lim === 0) return [];
	    if (S.length === 0) return regexpExecAbstract(splitter, S) === null ? [S] : [];
	    var p = 0;
	    var q = 0;
	    var A = [];

	    while (q < S.length) {
	      splitter.lastIndex = SUPPORTS_Y ? q : 0;
	      var z = regexpExecAbstract(splitter, SUPPORTS_Y ? S : S.slice(q));
	      var e;

	      if (z === null || (e = min$7(toLength(splitter.lastIndex + (SUPPORTS_Y ? 0 : q)), S.length)) === p) {
	        q = advanceStringIndex(S, q, unicodeMatching);
	      } else {
	        A.push(S.slice(p, q));
	        if (A.length === lim) return A;

	        for (var i = 1; i <= z.length - 1; i++) {
	          A.push(z[i]);
	          if (A.length === lim) return A;
	        }

	        q = p = e;
	      }
	    }

	    A.push(S.slice(p));
	    return A;
	  }];
	}, !SUPPORTS_Y);
	var es_string_split = {};

	'use strict';

	var getOwnPropertyDescriptor$5 = objectGetOwnPropertyDescriptor.f;
	var nativeStartsWith = ''.startsWith;
	var min$8 = Math.min;
	var CORRECT_IS_REGEXP_LOGIC$1 = correctIsRegexpLogic('startsWith'); // https://github.com/zloirock/core-js/pull/702

	var MDN_POLYFILL_BUG$1 = !isPure && !CORRECT_IS_REGEXP_LOGIC$1 && !!function () {
	  var descriptor = getOwnPropertyDescriptor$5(String.prototype, 'startsWith');
	  return descriptor && !descriptor.writable;
	}(); // `String.prototype.startsWith` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.startswith

	_export({
	  target: 'String',
	  proto: true,
	  forced: !MDN_POLYFILL_BUG$1 && !CORRECT_IS_REGEXP_LOGIC$1
	}, {
	  startsWith: function startsWith(searchString
	  /* , position = 0 */
	  ) {
	    var that = String(requireObjectCoercible(this));
	    notARegexp(searchString);
	    var index = toLength(min$8(arguments.length > 1 ? arguments[1] : undefined, that.length));
	    var search = String(searchString);
	    return nativeStartsWith ? nativeStartsWith.call(that, search, index) : that.slice(index, index + search.length) === search;
	  }
	});
	var es_string_startsWith = {};

	// a string of all valid unicode whitespaces
	// eslint-disable-next-line max-len
	var whitespaces = "\t\n\x0B\f\r \xA0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF";

	var whitespace = '[' + whitespaces + ']';
	var ltrim = RegExp('^' + whitespace + whitespace + '*');
	var rtrim = RegExp(whitespace + whitespace + '*$'); // `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation

	var createMethod$6 = function createMethod(TYPE) {
	  return function ($this) {
	    var string = String(requireObjectCoercible($this));
	    if (TYPE & 1) string = string.replace(ltrim, '');
	    if (TYPE & 2) string = string.replace(rtrim, '');
	    return string;
	  };
	};

	var stringTrim = {
	  // `String.prototype.{ trimLeft, trimStart }` methods
	  // https://tc39.github.io/ecma262/#sec-string.prototype.trimstart
	  start: createMethod$6(1),
	  // `String.prototype.{ trimRight, trimEnd }` methods
	  // https://tc39.github.io/ecma262/#sec-string.prototype.trimend
	  end: createMethod$6(2),
	  // `String.prototype.trim` method
	  // https://tc39.github.io/ecma262/#sec-string.prototype.trim
	  trim: createMethod$6(3)
	};
	var stringTrim_1 = stringTrim.start;
	var stringTrim_2 = stringTrim.end;
	var stringTrim_3 = stringTrim.trim;

	var non = "\u200B\x85\u180E"; // check that a method works with the correct list
	// of whitespaces and has a correct name

	var stringTrimForced = function stringTrimForced(METHOD_NAME) {
	  return fails(function () {
	    return !!whitespaces[METHOD_NAME]() || non[METHOD_NAME]() != non || whitespaces[METHOD_NAME].name !== METHOD_NAME;
	  });
	};

	'use strict';

	var $trim = stringTrim.trim; // `String.prototype.trim` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.trim

	_export({
	  target: 'String',
	  proto: true,
	  forced: stringTrimForced('trim')
	}, {
	  trim: function trim() {
	    return $trim(this);
	  }
	});
	var es_string_trim = {};

	'use strict';

	var $trimStart = stringTrim.start;
	var FORCED$4 = stringTrimForced('trimStart');
	var trimStart = FORCED$4 ? function trimStart() {
	  return $trimStart(this);
	} : ''.trimStart; // `String.prototype.{ trimStart, trimLeft }` methods
	// https://github.com/tc39/ecmascript-string-left-right-trim

	_export({
	  target: 'String',
	  proto: true,
	  forced: FORCED$4
	}, {
	  trimStart: trimStart,
	  trimLeft: trimStart
	});
	var es_string_trimStart = {};

	'use strict';

	var $trimEnd = stringTrim.end;
	var FORCED$5 = stringTrimForced('trimEnd');
	var trimEnd = FORCED$5 ? function trimEnd() {
	  return $trimEnd(this);
	} : ''.trimEnd; // `String.prototype.{ trimEnd, trimRight }` methods
	// https://github.com/tc39/ecmascript-string-left-right-trim

	_export({
	  target: 'String',
	  proto: true,
	  forced: FORCED$5
	}, {
	  trimEnd: trimEnd,
	  trimRight: trimEnd
	});
	var es_string_trimEnd = {};

	'use strict';

	var charAt$1 = stringMultibyte.charAt;
	var STRING_ITERATOR = 'String Iterator';
	var setInternalState$3 = internalState.set;
	var getInternalState$3 = internalState.getterFor(STRING_ITERATOR); // `String.prototype[@@iterator]` method
	// https://tc39.github.io/ecma262/#sec-string.prototype-@@iterator

	defineIterator(String, 'String', function (iterated) {
	  setInternalState$3(this, {
	    type: STRING_ITERATOR,
	    string: String(iterated),
	    index: 0
	  }); // `%StringIteratorPrototype%.next` method
	  // https://tc39.github.io/ecma262/#sec-%stringiteratorprototype%.next
	}, function next() {
	  var state = getInternalState$3(this);
	  var string = state.string;
	  var index = state.index;
	  var point;
	  if (index >= string.length) return {
	    value: undefined,
	    done: true
	  };
	  point = charAt$1(string, index);
	  state.index += point.length;
	  return {
	    value: point,
	    done: false
	  };
	});
	var es_string_iterator = {};

	var quot = /"/g; // B.2.3.2.1 CreateHTML(string, tag, attribute, value)
	// https://tc39.github.io/ecma262/#sec-createhtml

	var createHtml = function createHtml(string, tag, attribute, value) {
	  var S = String(requireObjectCoercible(string));
	  var p1 = '<' + tag;
	  if (attribute !== '') p1 += ' ' + attribute + '="' + String(value).replace(quot, '&quot;') + '"';
	  return p1 + '>' + S + '</' + tag + '>';
	};

	// of a tag and escaping quotes in arguments

	var stringHtmlForced = function stringHtmlForced(METHOD_NAME) {
	  return fails(function () {
	    var test = ''[METHOD_NAME]('"');
	    return test !== test.toLowerCase() || test.split('"').length > 3;
	  });
	};

	'use strict'; // `String.prototype.anchor` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.anchor


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('anchor')
	}, {
	  anchor: function anchor(name) {
	    return createHtml(this, 'a', 'name', name);
	  }
	});
	var es_string_anchor = {};

	'use strict'; // `String.prototype.big` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.big


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('big')
	}, {
	  big: function big() {
	    return createHtml(this, 'big', '', '');
	  }
	});
	var es_string_big = {};

	'use strict'; // `String.prototype.blink` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.blink


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('blink')
	}, {
	  blink: function blink() {
	    return createHtml(this, 'blink', '', '');
	  }
	});
	var es_string_blink = {};

	'use strict'; // `String.prototype.bold` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.bold


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('bold')
	}, {
	  bold: function bold() {
	    return createHtml(this, 'b', '', '');
	  }
	});
	var es_string_bold = {};

	'use strict'; // `String.prototype.fixed` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.fixed


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('fixed')
	}, {
	  fixed: function fixed() {
	    return createHtml(this, 'tt', '', '');
	  }
	});
	var es_string_fixed = {};

	'use strict'; // `String.prototype.fontcolor` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.fontcolor


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('fontcolor')
	}, {
	  fontcolor: function fontcolor(color) {
	    return createHtml(this, 'font', 'color', color);
	  }
	});
	var es_string_fontcolor = {};

	'use strict'; // `String.prototype.fontsize` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.fontsize


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('fontsize')
	}, {
	  fontsize: function fontsize(size) {
	    return createHtml(this, 'font', 'size', size);
	  }
	});
	var es_string_fontsize = {};

	'use strict'; // `String.prototype.italics` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.italics


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('italics')
	}, {
	  italics: function italics() {
	    return createHtml(this, 'i', '', '');
	  }
	});
	var es_string_italics = {};

	'use strict'; // `String.prototype.link` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.link


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('link')
	}, {
	  link: function link(url) {
	    return createHtml(this, 'a', 'href', url);
	  }
	});
	var es_string_link = {};

	'use strict'; // `String.prototype.small` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.small


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('small')
	}, {
	  small: function small() {
	    return createHtml(this, 'small', '', '');
	  }
	});
	var es_string_small = {};

	'use strict'; // `String.prototype.strike` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.strike


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('strike')
	}, {
	  strike: function strike() {
	    return createHtml(this, 'strike', '', '');
	  }
	});
	var es_string_strike = {};

	'use strict'; // `String.prototype.sub` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.sub


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('sub')
	}, {
	  sub: function sub() {
	    return createHtml(this, 'sub', '', '');
	  }
	});
	var es_string_sub = {};

	'use strict'; // `String.prototype.sup` method
	// https://tc39.github.io/ecma262/#sec-string.prototype.sup


	_export({
	  target: 'String',
	  proto: true,
	  forced: stringHtmlForced('sup')
	}, {
	  sup: function sup() {
	    return createHtml(this, 'sup', '', '');
	  }
	});
	var es_string_sup = {};

	var inheritIfRequired = function inheritIfRequired($this, dummy, Wrapper) {
	  var NewTarget, NewTargetPrototype;
	  if ( // it can work only with native `setPrototypeOf`
	  objectSetPrototypeOf && // we haven't completely correct pre-ES6 way for getting `new.target`, so use this
	  typeof (NewTarget = dummy.constructor) == 'function' && NewTarget !== Wrapper && isObject(NewTargetPrototype = NewTarget.prototype) && NewTargetPrototype !== Wrapper.prototype) objectSetPrototypeOf($this, NewTargetPrototype);
	  return $this;
	};

	var defineProperty$6 = objectDefineProperty.f;
	var getOwnPropertyNames = objectGetOwnPropertyNames.f;
	var setInternalState$4 = internalState.set;
	var MATCH$2 = wellKnownSymbol('match');
	var NativeRegExp = global_1.RegExp;
	var RegExpPrototype$1 = NativeRegExp.prototype;
	var re1 = /a/g;
	var re2 = /a/g; // "new" should create a new object, old webkit bug

	var CORRECT_NEW = new NativeRegExp(re1) !== re1;
	var UNSUPPORTED_Y$2 = regexpStickyHelpers.UNSUPPORTED_Y;
	var FORCED$6 = descriptors && isForced_1('RegExp', !CORRECT_NEW || UNSUPPORTED_Y$2 || fails(function () {
	  re2[MATCH$2] = false; // RegExp constructor can alter flags and IsRegExp works correct with @@match

	  return NativeRegExp(re1) != re1 || NativeRegExp(re2) == re2 || NativeRegExp(re1, 'i') != '/a/i';
	})); // `RegExp` constructor
	// https://tc39.github.io/ecma262/#sec-regexp-constructor

	if (FORCED$6) {
	  var RegExpWrapper = function RegExp(pattern, flags) {
	    var thisIsRegExp = this instanceof RegExpWrapper;
	    var patternIsRegExp = isRegexp(pattern);
	    var flagsAreUndefined = flags === undefined;
	    var sticky;

	    if (!thisIsRegExp && patternIsRegExp && pattern.constructor === RegExpWrapper && flagsAreUndefined) {
	      return pattern;
	    }

	    if (CORRECT_NEW) {
	      if (patternIsRegExp && !flagsAreUndefined) pattern = pattern.source;
	    } else if (pattern instanceof RegExpWrapper) {
	      if (flagsAreUndefined) flags = regexpFlags.call(pattern);
	      pattern = pattern.source;
	    }

	    if (UNSUPPORTED_Y$2) {
	      sticky = !!flags && flags.indexOf('y') > -1;
	      if (sticky) flags = flags.replace(/y/g, '');
	    }

	    var result = inheritIfRequired(CORRECT_NEW ? new NativeRegExp(pattern, flags) : NativeRegExp(pattern, flags), thisIsRegExp ? this : RegExpPrototype$1, RegExpWrapper);
	    if (UNSUPPORTED_Y$2 && sticky) setInternalState$4(result, {
	      sticky: sticky
	    });
	    return result;
	  };

	  var proxy = function proxy(key) {
	    key in RegExpWrapper || defineProperty$6(RegExpWrapper, key, {
	      configurable: true,
	      get: function get() {
	        return NativeRegExp[key];
	      },
	      set: function set(it) {
	        NativeRegExp[key] = it;
	      }
	    });
	  };

	  var keys$1 = getOwnPropertyNames(NativeRegExp);
	  var index = 0;

	  while (keys$1.length > index) {
	    proxy(keys$1[index++]);
	  }

	  RegExpPrototype$1.constructor = RegExpWrapper;
	  RegExpWrapper.prototype = RegExpPrototype$1;
	  redefine(global_1, 'RegExp', RegExpWrapper);
	} // https://tc39.github.io/ecma262/#sec-get-regexp-@@species


	setSpecies('RegExp');
	var es_regexp_constructor = {};

	var UNSUPPORTED_Y$3 = regexpStickyHelpers.UNSUPPORTED_Y; // `RegExp.prototype.flags` getter
	// https://tc39.github.io/ecma262/#sec-get-regexp.prototype.flags

	if (descriptors && (/./g.flags != 'g' || UNSUPPORTED_Y$3)) {
	  objectDefineProperty.f(RegExp.prototype, 'flags', {
	    configurable: true,
	    get: regexpFlags
	  });
	}

	var es_regexp_flags = {};

	var UNSUPPORTED_Y$4 = regexpStickyHelpers.UNSUPPORTED_Y;
	var defineProperty$7 = objectDefineProperty.f;
	var getInternalState$4 = internalState.get;
	var RegExpPrototype$2 = RegExp.prototype; // `RegExp.prototype.sticky` getter

	if (descriptors && UNSUPPORTED_Y$4) {
	  defineProperty$7(RegExp.prototype, 'sticky', {
	    configurable: true,
	    get: function get() {
	      if (this === RegExpPrototype$2) return undefined; // We can't use InternalStateModule.getterFor because
	      // we don't add metadata for regexps created by a literal.

	      if (this instanceof RegExp) {
	        return !!getInternalState$4(this).sticky;
	      }

	      throw TypeError('Incompatible receiver, RegExp required');
	    }
	  });
	}

	var es_regexp_sticky = {};

	'use strict'; // TODO: Remove from `core-js@4` since it's moved to entry points


	var DELEGATES_TO_EXEC = function () {
	  var execCalled = false;
	  var re = /[ac]/;

	  re.exec = function () {
	    execCalled = true;
	    return /./.exec.apply(this, arguments);
	  };

	  return re.test('abc') === true && execCalled;
	}();

	var nativeTest = /./.test;
	_export({
	  target: 'RegExp',
	  proto: true,
	  forced: !DELEGATES_TO_EXEC
	}, {
	  test: function test(str) {
	    if (typeof this.exec !== 'function') {
	      return nativeTest.call(this, str);
	    }

	    var result = this.exec(str);

	    if (result !== null && !isObject(result)) {
	      throw new Error('RegExp exec method returned something other than an Object or null');
	    }

	    return !!result;
	  }
	});
	var es_regexp_test = {};

	'use strict';

	var TO_STRING = 'toString';
	var RegExpPrototype$3 = RegExp.prototype;
	var nativeToString = RegExpPrototype$3[TO_STRING];
	var NOT_GENERIC = fails(function () {
	  return nativeToString.call({
	    source: 'a',
	    flags: 'b'
	  }) != '/a/b';
	}); // FF44- RegExp#toString has a wrong name

	var INCORRECT_NAME = nativeToString.name != TO_STRING; // `RegExp.prototype.toString` method
	// https://tc39.github.io/ecma262/#sec-regexp.prototype.tostring

	if (NOT_GENERIC || INCORRECT_NAME) {
	  redefine(RegExp.prototype, TO_STRING, function toString() {
	    var R = anObject(this);
	    var p = String(R.source);
	    var rf = R.flags;
	    var f = String(rf === undefined && R instanceof RegExp && !('flags' in RegExpPrototype$3) ? regexpFlags.call(R) : rf);
	    return '/' + p + '/' + f;
	  }, {
	    unsafe: true
	  });
	}

	var es_regexp_toString = {};

	var trim = stringTrim.trim;
	var $parseInt = global_1.parseInt;
	var hex = /^[+-]?0[Xx]/;
	var FORCED$7 = $parseInt(whitespaces + '08') !== 8 || $parseInt(whitespaces + '0x16') !== 22; // `parseInt` method
	// https://tc39.github.io/ecma262/#sec-parseint-string-radix

	var numberParseInt = FORCED$7 ? function parseInt(string, radix) {
	  var S = trim(String(string));
	  return $parseInt(S, radix >>> 0 || (hex.test(S) ? 16 : 10));
	} : $parseInt;

	// https://tc39.github.io/ecma262/#sec-parseint-string-radix

	_export({
	  global: true,
	  forced: parseInt != numberParseInt
	}, {
	  parseInt: numberParseInt
	});
	var es_parseInt = {};

	var trim$1 = stringTrim.trim;
	var $parseFloat = global_1.parseFloat;
	var FORCED$8 = 1 / $parseFloat(whitespaces + '-0') !== -Infinity; // `parseFloat` method
	// https://tc39.github.io/ecma262/#sec-parsefloat-string

	var numberParseFloat = FORCED$8 ? function parseFloat(string) {
	  var trimmedString = trim$1(String(string));
	  var result = $parseFloat(trimmedString);
	  return result === 0 && trimmedString.charAt(0) == '-' ? -0 : result;
	} : $parseFloat;

	// https://tc39.github.io/ecma262/#sec-parsefloat-string

	_export({
	  global: true,
	  forced: parseFloat != numberParseFloat
	}, {
	  parseFloat: numberParseFloat
	});
	var es_parseFloat = {};

	'use strict';

	var getOwnPropertyNames$1 = objectGetOwnPropertyNames.f;
	var getOwnPropertyDescriptor$6 = objectGetOwnPropertyDescriptor.f;
	var defineProperty$8 = objectDefineProperty.f;
	var trim$2 = stringTrim.trim;
	var NUMBER = 'Number';
	var NativeNumber = global_1[NUMBER];
	var NumberPrototype = NativeNumber.prototype; // Opera ~12 has broken Object#toString

	var BROKEN_CLASSOF = classofRaw(objectCreate(NumberPrototype)) == NUMBER; // `ToNumber` abstract operation
	// https://tc39.github.io/ecma262/#sec-tonumber

	var toNumber = function toNumber(argument) {
	  var it = toPrimitive(argument, false);
	  var first, third, radix, maxCode, digits, length, index, code;

	  if (typeof it == 'string' && it.length > 2) {
	    it = trim$2(it);
	    first = it.charCodeAt(0);

	    if (first === 43 || first === 45) {
	      third = it.charCodeAt(2);
	      if (third === 88 || third === 120) return NaN; // Number('+0x1') should be NaN, old V8 fix
	    } else if (first === 48) {
	      switch (it.charCodeAt(1)) {
	        case 66:
	        case 98:
	          radix = 2;
	          maxCode = 49;
	          break;
	        // fast equal of /^0b[01]+$/i

	        case 79:
	        case 111:
	          radix = 8;
	          maxCode = 55;
	          break;
	        // fast equal of /^0o[0-7]+$/i

	        default:
	          return +it;
	      }

	      digits = it.slice(2);
	      length = digits.length;

	      for (index = 0; index < length; index++) {
	        code = digits.charCodeAt(index); // parseInt parses a string to a first unavailable symbol
	        // but ToNumber should return NaN if a string contains unavailable symbols

	        if (code < 48 || code > maxCode) return NaN;
	      }

	      return parseInt(digits, radix);
	    }
	  }

	  return +it;
	}; // `Number` constructor
	// https://tc39.github.io/ecma262/#sec-number-constructor


	if (isForced_1(NUMBER, !NativeNumber(' 0o1') || !NativeNumber('0b1') || NativeNumber('+0x1'))) {
	  var NumberWrapper = function Number(value) {
	    var it = arguments.length < 1 ? 0 : value;
	    var dummy = this;
	    return dummy instanceof NumberWrapper // check on 1..constructor(foo) case
	    && (BROKEN_CLASSOF ? fails(function () {
	      NumberPrototype.valueOf.call(dummy);
	    }) : classofRaw(dummy) != NUMBER) ? inheritIfRequired(new NativeNumber(toNumber(it)), dummy, NumberWrapper) : toNumber(it);
	  };

	  for (var keys$2 = descriptors ? getOwnPropertyNames$1(NativeNumber) : ( // ES3:
	  'MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,' + // ES2015 (in case, if modules with ES2015 Number statics required before):
	  'EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,' + 'MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger').split(','), j = 0, key; keys$2.length > j; j++) {
	    if (has(NativeNumber, key = keys$2[j]) && !has(NumberWrapper, key)) {
	      defineProperty$8(NumberWrapper, key, getOwnPropertyDescriptor$6(NativeNumber, key));
	    }
	  }

	  NumberWrapper.prototype = NumberPrototype;
	  NumberPrototype.constructor = NumberWrapper;
	  redefine(global_1, NUMBER, NumberWrapper);
	}

	var es_number_constructor = {};

	// https://tc39.github.io/ecma262/#sec-number.epsilon

	_export({
	  target: 'Number',
	  stat: true
	}, {
	  EPSILON: Math.pow(2, -52)
	});
	var es_number_epsilon = {};

	var globalIsFinite = global_1.isFinite; // `Number.isFinite` method
	// https://tc39.github.io/ecma262/#sec-number.isfinite

	var numberIsFinite = Number.isFinite || function isFinite(it) {
	  return typeof it == 'number' && globalIsFinite(it);
	};

	// https://tc39.github.io/ecma262/#sec-number.isfinite

	_export({
	  target: 'Number',
	  stat: true
	}, {
	  isFinite: numberIsFinite
	});
	var es_number_isFinite = {};

	var floor$2 = Math.floor; // `Number.isInteger` method implementation
	// https://tc39.github.io/ecma262/#sec-number.isinteger

	var isInteger = function isInteger(it) {
	  return !isObject(it) && isFinite(it) && floor$2(it) === it;
	};

	// https://tc39.github.io/ecma262/#sec-number.isinteger

	_export({
	  target: 'Number',
	  stat: true
	}, {
	  isInteger: isInteger
	});
	var es_number_isInteger = {};

	// https://tc39.github.io/ecma262/#sec-number.isnan

	_export({
	  target: 'Number',
	  stat: true
	}, {
	  isNaN: function isNaN(number) {
	    // eslint-disable-next-line no-self-compare
	    return number != number;
	  }
	});
	var es_number_isNan = {};

	var abs = Math.abs; // `Number.isSafeInteger` method
	// https://tc39.github.io/ecma262/#sec-number.issafeinteger

	_export({
	  target: 'Number',
	  stat: true
	}, {
	  isSafeInteger: function isSafeInteger(number) {
	    return isInteger(number) && abs(number) <= 0x1FFFFFFFFFFFFF;
	  }
	});
	var es_number_isSafeInteger = {};

	// https://tc39.github.io/ecma262/#sec-number.max_safe_integer

	_export({
	  target: 'Number',
	  stat: true
	}, {
	  MAX_SAFE_INTEGER: 0x1FFFFFFFFFFFFF
	});
	var es_number_maxSafeInteger = {};

	// https://tc39.github.io/ecma262/#sec-number.min_safe_integer

	_export({
	  target: 'Number',
	  stat: true
	}, {
	  MIN_SAFE_INTEGER: -0x1FFFFFFFFFFFFF
	});
	var es_number_minSafeInteger = {};

	// https://tc39.github.io/ecma262/#sec-number.parseFloat

	_export({
	  target: 'Number',
	  stat: true,
	  forced: Number.parseFloat != numberParseFloat
	}, {
	  parseFloat: numberParseFloat
	});
	var es_number_parseFloat = {};

	// https://tc39.github.io/ecma262/#sec-number.parseint

	_export({
	  target: 'Number',
	  stat: true,
	  forced: Number.parseInt != numberParseInt
	}, {
	  parseInt: numberParseInt
	});
	var es_number_parseInt = {};

	// https://tc39.github.io/ecma262/#sec-thisnumbervalue

	var thisNumberValue = function thisNumberValue(value) {
	  if (typeof value != 'number' && classofRaw(value) != 'Number') {
	    throw TypeError('Incorrect invocation');
	  }

	  return +value;
	};

	'use strict';

	var nativeToFixed = 1.0.toFixed;
	var floor$3 = Math.floor;

	var pow = function pow(x, n, acc) {
	  return n === 0 ? acc : n % 2 === 1 ? pow(x, n - 1, acc * x) : pow(x * x, n / 2, acc);
	};

	var log = function log(x) {
	  var n = 0;
	  var x2 = x;

	  while (x2 >= 4096) {
	    n += 12;
	    x2 /= 4096;
	  }

	  while (x2 >= 2) {
	    n += 1;
	    x2 /= 2;
	  }

	  return n;
	};

	var FORCED$9 = nativeToFixed && (0.00008.toFixed(3) !== '0.000' || 0.9.toFixed(0) !== '1' || 1.255.toFixed(2) !== '1.25' || 1000000000000000128.0.toFixed(0) !== '1000000000000000128') || !fails(function () {
	  // V8 ~ Android 4.3-
	  nativeToFixed.call({});
	}); // `Number.prototype.toFixed` method
	// https://tc39.github.io/ecma262/#sec-number.prototype.tofixed

	_export({
	  target: 'Number',
	  proto: true,
	  forced: FORCED$9
	}, {
	  // eslint-disable-next-line max-statements
	  toFixed: function toFixed(fractionDigits) {
	    var number = thisNumberValue(this);
	    var fractDigits = toInteger(fractionDigits);
	    var data = [0, 0, 0, 0, 0, 0];
	    var sign = '';
	    var result = '0';
	    var e, z, j, k;

	    var multiply = function multiply(n, c) {
	      var index = -1;
	      var c2 = c;

	      while (++index < 6) {
	        c2 += n * data[index];
	        data[index] = c2 % 1e7;
	        c2 = floor$3(c2 / 1e7);
	      }
	    };

	    var divide = function divide(n) {
	      var index = 6;
	      var c = 0;

	      while (--index >= 0) {
	        c += data[index];
	        data[index] = floor$3(c / n);
	        c = c % n * 1e7;
	      }
	    };

	    var dataToString = function dataToString() {
	      var index = 6;
	      var s = '';

	      while (--index >= 0) {
	        if (s !== '' || index === 0 || data[index] !== 0) {
	          var t = String(data[index]);
	          s = s === '' ? t : s + stringRepeat.call('0', 7 - t.length) + t;
	        }
	      }

	      return s;
	    };

	    if (fractDigits < 0 || fractDigits > 20) throw RangeError('Incorrect fraction digits'); // eslint-disable-next-line no-self-compare

	    if (number != number) return 'NaN';
	    if (number <= -1e21 || number >= 1e21) return String(number);

	    if (number < 0) {
	      sign = '-';
	      number = -number;
	    }

	    if (number > 1e-21) {
	      e = log(number * pow(2, 69, 1)) - 69;
	      z = e < 0 ? number * pow(2, -e, 1) : number / pow(2, e, 1);
	      z *= 0x10000000000000;
	      e = 52 - e;

	      if (e > 0) {
	        multiply(0, z);
	        j = fractDigits;

	        while (j >= 7) {
	          multiply(1e7, 0);
	          j -= 7;
	        }

	        multiply(pow(10, j, 1), 0);
	        j = e - 1;

	        while (j >= 23) {
	          divide(1 << 23);
	          j -= 23;
	        }

	        divide(1 << j);
	        multiply(1, 1);
	        divide(2);
	        result = dataToString();
	      } else {
	        multiply(0, z);
	        multiply(1 << -e, 0);
	        result = dataToString() + stringRepeat.call('0', fractDigits);
	      }
	    }

	    if (fractDigits > 0) {
	      k = result.length;
	      result = sign + (k <= fractDigits ? '0.' + stringRepeat.call('0', fractDigits - k) + result : result.slice(0, k - fractDigits) + '.' + result.slice(k - fractDigits));
	    } else {
	      result = sign + result;
	    }

	    return result;
	  }
	});
	var es_number_toFixed = {};

	'use strict';

	var nativeToPrecision = 1.0.toPrecision;
	var FORCED$a = fails(function () {
	  // IE7-
	  return nativeToPrecision.call(1, undefined) !== '1';
	}) || !fails(function () {
	  // V8 ~ Android 4.3-
	  nativeToPrecision.call({});
	}); // `Number.prototype.toPrecision` method
	// https://tc39.github.io/ecma262/#sec-number.prototype.toprecision

	_export({
	  target: 'Number',
	  proto: true,
	  forced: FORCED$a
	}, {
	  toPrecision: function toPrecision(precision) {
	    return precision === undefined ? nativeToPrecision.call(thisNumberValue(this)) : nativeToPrecision.call(thisNumberValue(this), precision);
	  }
	});
	var es_number_toPrecision = {};

	var log$1 = Math.log; // `Math.log1p` method implementation
	// https://tc39.github.io/ecma262/#sec-math.log1p

	var mathLog1p = Math.log1p || function log1p(x) {
	  return (x = +x) > -1e-8 && x < 1e-8 ? x - x * x / 2 : log$1(1 + x);
	};

	var nativeAcosh = Math.acosh;
	var log$2 = Math.log;
	var sqrt = Math.sqrt;
	var LN2 = Math.LN2;
	var FORCED$b = !nativeAcosh // V8 bug: https://code.google.com/p/v8/issues/detail?id=3509
	|| Math.floor(nativeAcosh(Number.MAX_VALUE)) != 710 // Tor Browser bug: Math.acosh(Infinity) -> NaN
	|| nativeAcosh(Infinity) != Infinity; // `Math.acosh` method
	// https://tc39.github.io/ecma262/#sec-math.acosh

	_export({
	  target: 'Math',
	  stat: true,
	  forced: FORCED$b
	}, {
	  acosh: function acosh(x) {
	    return (x = +x) < 1 ? NaN : x > 94906265.62425156 ? log$2(x) + LN2 : mathLog1p(x - 1 + sqrt(x - 1) * sqrt(x + 1));
	  }
	});
	var es_math_acosh = {};

	var nativeAsinh = Math.asinh;
	var log$3 = Math.log;
	var sqrt$1 = Math.sqrt;

	function asinh(x) {
	  return !isFinite(x = +x) || x == 0 ? x : x < 0 ? -asinh(-x) : log$3(x + sqrt$1(x * x + 1));
	} // `Math.asinh` method
	// https://tc39.github.io/ecma262/#sec-math.asinh
	// Tor Browser bug: Math.asinh(0) -> -0


	_export({
	  target: 'Math',
	  stat: true,
	  forced: !(nativeAsinh && 1 / nativeAsinh(0) > 0)
	}, {
	  asinh: asinh
	});
	var es_math_asinh = {};

	var nativeAtanh = Math.atanh;
	var log$4 = Math.log; // `Math.atanh` method
	// https://tc39.github.io/ecma262/#sec-math.atanh
	// Tor Browser bug: Math.atanh(-0) -> 0

	_export({
	  target: 'Math',
	  stat: true,
	  forced: !(nativeAtanh && 1 / nativeAtanh(-0) < 0)
	}, {
	  atanh: function atanh(x) {
	    return (x = +x) == 0 ? x : log$4((1 + x) / (1 - x)) / 2;
	  }
	});
	var es_math_atanh = {};

	// `Math.sign` method implementation
	// https://tc39.github.io/ecma262/#sec-math.sign
	var mathSign = Math.sign || function sign(x) {
	  // eslint-disable-next-line no-self-compare
	  return (x = +x) == 0 || x != x ? x : x < 0 ? -1 : 1;
	};

	var abs$1 = Math.abs;
	var pow$1 = Math.pow; // `Math.cbrt` method
	// https://tc39.github.io/ecma262/#sec-math.cbrt

	_export({
	  target: 'Math',
	  stat: true
	}, {
	  cbrt: function cbrt(x) {
	    return mathSign(x = +x) * pow$1(abs$1(x), 1 / 3);
	  }
	});
	var es_math_cbrt = {};

	var floor$4 = Math.floor;
	var log$5 = Math.log;
	var LOG2E = Math.LOG2E; // `Math.clz32` method
	// https://tc39.github.io/ecma262/#sec-math.clz32

	_export({
	  target: 'Math',
	  stat: true
	}, {
	  clz32: function clz32(x) {
	    return (x >>>= 0) ? 31 - floor$4(log$5(x + 0.5) * LOG2E) : 32;
	  }
	});
	var es_math_clz32 = {};

	var nativeExpm1 = Math.expm1;
	var exp = Math.exp; // `Math.expm1` method implementation
	// https://tc39.github.io/ecma262/#sec-math.expm1

	var mathExpm1 = !nativeExpm1 // Old FF bug
	|| nativeExpm1(10) > 22025.465794806719 || nativeExpm1(10) < 22025.4657948067165168 // Tor Browser bug
	|| nativeExpm1(-2e-17) != -2e-17 ? function expm1(x) {
	  return (x = +x) == 0 ? x : x > -1e-6 && x < 1e-6 ? x + x * x / 2 : exp(x) - 1;
	} : nativeExpm1;

	var nativeCosh = Math.cosh;
	var abs$2 = Math.abs;
	var E = Math.E; // `Math.cosh` method
	// https://tc39.github.io/ecma262/#sec-math.cosh

	_export({
	  target: 'Math',
	  stat: true,
	  forced: !nativeCosh || nativeCosh(710) === Infinity
	}, {
	  cosh: function cosh(x) {
	    var t = mathExpm1(abs$2(x) - 1) + 1;
	    return (t + 1 / (t * E * E)) * (E / 2);
	  }
	});
	var es_math_cosh = {};

	// https://tc39.github.io/ecma262/#sec-math.expm1

	_export({
	  target: 'Math',
	  stat: true,
	  forced: mathExpm1 != Math.expm1
	}, {
	  expm1: mathExpm1
	});
	var es_math_expm1 = {};

	var abs$3 = Math.abs;
	var pow$2 = Math.pow;
	var EPSILON = pow$2(2, -52);
	var EPSILON32 = pow$2(2, -23);
	var MAX32 = pow$2(2, 127) * (2 - EPSILON32);
	var MIN32 = pow$2(2, -126);

	var roundTiesToEven = function roundTiesToEven(n) {
	  return n + 1 / EPSILON - 1 / EPSILON;
	}; // `Math.fround` method implementation
	// https://tc39.github.io/ecma262/#sec-math.fround


	var mathFround = Math.fround || function fround(x) {
	  var $abs = abs$3(x);
	  var $sign = mathSign(x);
	  var a, result;
	  if ($abs < MIN32) return $sign * roundTiesToEven($abs / MIN32 / EPSILON32) * MIN32 * EPSILON32;
	  a = (1 + EPSILON32 / EPSILON) * $abs;
	  result = a - (a - $abs); // eslint-disable-next-line no-self-compare

	  if (result > MAX32 || result != result) return $sign * Infinity;
	  return $sign * result;
	};

	// https://tc39.github.io/ecma262/#sec-math.fround

	_export({
	  target: 'Math',
	  stat: true
	}, {
	  fround: mathFround
	});
	var es_math_fround = {};

	var $hypot = Math.hypot;
	var abs$4 = Math.abs;
	var sqrt$2 = Math.sqrt; // Chrome 77 bug
	// https://bugs.chromium.org/p/v8/issues/detail?id=9546

	var BUGGY = !!$hypot && $hypot(Infinity, NaN) !== Infinity; // `Math.hypot` method
	// https://tc39.github.io/ecma262/#sec-math.hypot

	_export({
	  target: 'Math',
	  stat: true,
	  forced: BUGGY
	}, {
	  hypot: function hypot(value1, value2) {
	    // eslint-disable-line no-unused-vars
	    var sum = 0;
	    var i = 0;
	    var aLen = arguments.length;
	    var larg = 0;
	    var arg, div;

	    while (i < aLen) {
	      arg = abs$4(arguments[i++]);

	      if (larg < arg) {
	        div = larg / arg;
	        sum = sum * div * div + 1;
	        larg = arg;
	      } else if (arg > 0) {
	        div = arg / larg;
	        sum += div * div;
	      } else sum += arg;
	    }

	    return larg === Infinity ? Infinity : larg * sqrt$2(sum);
	  }
	});
	var es_math_hypot = {};

	var nativeImul = Math.imul;
	var FORCED$c = fails(function () {
	  return nativeImul(0xFFFFFFFF, 5) != -5 || nativeImul.length != 2;
	}); // `Math.imul` method
	// https://tc39.github.io/ecma262/#sec-math.imul
	// some WebKit versions fails with big numbers, some has wrong arity

	_export({
	  target: 'Math',
	  stat: true,
	  forced: FORCED$c
	}, {
	  imul: function imul(x, y) {
	    var UINT16 = 0xFFFF;
	    var xn = +x;
	    var yn = +y;
	    var xl = UINT16 & xn;
	    var yl = UINT16 & yn;
	    return 0 | xl * yl + ((UINT16 & xn >>> 16) * yl + xl * (UINT16 & yn >>> 16) << 16 >>> 0);
	  }
	});
	var es_math_imul = {};

	var log$6 = Math.log;
	var LOG10E = Math.LOG10E; // `Math.log10` method
	// https://tc39.github.io/ecma262/#sec-math.log10

	_export({
	  target: 'Math',
	  stat: true
	}, {
	  log10: function log10(x) {
	    return log$6(x) * LOG10E;
	  }
	});
	var es_math_log10 = {};

	// https://tc39.github.io/ecma262/#sec-math.log1p

	_export({
	  target: 'Math',
	  stat: true
	}, {
	  log1p: mathLog1p
	});
	var es_math_log1p = {};

	var log$7 = Math.log;
	var LN2$1 = Math.LN2; // `Math.log2` method
	// https://tc39.github.io/ecma262/#sec-math.log2

	_export({
	  target: 'Math',
	  stat: true
	}, {
	  log2: function log2(x) {
	    return log$7(x) / LN2$1;
	  }
	});
	var es_math_log2 = {};

	// https://tc39.github.io/ecma262/#sec-math.sign

	_export({
	  target: 'Math',
	  stat: true
	}, {
	  sign: mathSign
	});
	var es_math_sign = {};

	var abs$5 = Math.abs;
	var exp$1 = Math.exp;
	var E$1 = Math.E;
	var FORCED$d = fails(function () {
	  return Math.sinh(-2e-17) != -2e-17;
	}); // `Math.sinh` method
	// https://tc39.github.io/ecma262/#sec-math.sinh
	// V8 near Chromium 38 has a problem with very small numbers

	_export({
	  target: 'Math',
	  stat: true,
	  forced: FORCED$d
	}, {
	  sinh: function sinh(x) {
	    return abs$5(x = +x) < 1 ? (mathExpm1(x) - mathExpm1(-x)) / 2 : (exp$1(x - 1) - exp$1(-x - 1)) * (E$1 / 2);
	  }
	});
	var es_math_sinh = {};

	var exp$2 = Math.exp; // `Math.tanh` method
	// https://tc39.github.io/ecma262/#sec-math.tanh

	_export({
	  target: 'Math',
	  stat: true
	}, {
	  tanh: function tanh(x) {
	    var a = mathExpm1(x = +x);
	    var b = mathExpm1(-x);
	    return a == Infinity ? 1 : b == Infinity ? -1 : (a - b) / (exp$2(x) + exp$2(-x));
	  }
	});
	var es_math_tanh = {};

	// https://tc39.github.io/ecma262/#sec-math-@@tostringtag

	setToStringTag(Math, 'Math', true);
	var es_math_toStringTag = {};

	var ceil$2 = Math.ceil;
	var floor$5 = Math.floor; // `Math.trunc` method
	// https://tc39.github.io/ecma262/#sec-math.trunc

	_export({
	  target: 'Math',
	  stat: true
	}, {
	  trunc: function trunc(it) {
	    return (it > 0 ? floor$5 : ceil$2)(it);
	  }
	});
	var es_math_trunc = {};

	// https://tc39.github.io/ecma262/#sec-date.now

	_export({
	  target: 'Date',
	  stat: true
	}, {
	  now: function now() {
	    return new Date().getTime();
	  }
	});
	var es_date_now = {};

	'use strict';

	var FORCED$e = fails(function () {
	  return new Date(NaN).toJSON() !== null || Date.prototype.toJSON.call({
	    toISOString: function toISOString() {
	      return 1;
	    }
	  }) !== 1;
	}); // `Date.prototype.toJSON` method
	// https://tc39.github.io/ecma262/#sec-date.prototype.tojson

	_export({
	  target: 'Date',
	  proto: true,
	  forced: FORCED$e
	}, {
	  // eslint-disable-next-line no-unused-vars
	  toJSON: function toJSON(key) {
	    var O = toObject(this);
	    var pv = toPrimitive(O);
	    return typeof pv == 'number' && !isFinite(pv) ? null : O.toISOString();
	  }
	});
	var es_date_toJson = {};

	'use strict';

	var padStart = stringPad.start;
	var abs$6 = Math.abs;
	var DatePrototype = Date.prototype;
	var getTime = DatePrototype.getTime;
	var nativeDateToISOString = DatePrototype.toISOString; // `Date.prototype.toISOString` method implementation
	// https://tc39.github.io/ecma262/#sec-date.prototype.toisostring
	// PhantomJS / old WebKit fails here:

	var dateToIsoString = fails(function () {
	  return nativeDateToISOString.call(new Date(-5e13 - 1)) != '0385-07-25T07:06:39.999Z';
	}) || !fails(function () {
	  nativeDateToISOString.call(new Date(NaN));
	}) ? function toISOString() {
	  if (!isFinite(getTime.call(this))) throw RangeError('Invalid time value');
	  var date = this;
	  var year = date.getUTCFullYear();
	  var milliseconds = date.getUTCMilliseconds();
	  var sign = year < 0 ? '-' : year > 9999 ? '+' : '';
	  return sign + padStart(abs$6(year), sign ? 6 : 4, 0) + '-' + padStart(date.getUTCMonth() + 1, 2, 0) + '-' + padStart(date.getUTCDate(), 2, 0) + 'T' + padStart(date.getUTCHours(), 2, 0) + ':' + padStart(date.getUTCMinutes(), 2, 0) + ':' + padStart(date.getUTCSeconds(), 2, 0) + '.' + padStart(milliseconds, 3, 0) + 'Z';
	} : nativeDateToISOString;

	// https://tc39.github.io/ecma262/#sec-date.prototype.toisostring
	// PhantomJS / old WebKit has a broken implementations

	_export({
	  target: 'Date',
	  proto: true,
	  forced: Date.prototype.toISOString !== dateToIsoString
	}, {
	  toISOString: dateToIsoString
	});
	var es_date_toIsoString = {};

	var DatePrototype$1 = Date.prototype;
	var INVALID_DATE = 'Invalid Date';
	var TO_STRING$1 = 'toString';
	var nativeDateToString = DatePrototype$1[TO_STRING$1];
	var getTime$1 = DatePrototype$1.getTime; // `Date.prototype.toString` method
	// https://tc39.github.io/ecma262/#sec-date.prototype.tostring

	if (new Date(NaN) + '' != INVALID_DATE) {
	  redefine(DatePrototype$1, TO_STRING$1, function toString() {
	    var value = getTime$1.call(this); // eslint-disable-next-line no-self-compare

	    return value === value ? nativeDateToString.call(this) : INVALID_DATE;
	  });
	}

	var es_date_toString = {};

	'use strict';

	var dateToPrimitive = function dateToPrimitive(hint) {
	  if (hint !== 'string' && hint !== 'number' && hint !== 'default') {
	    throw TypeError('Incorrect hint');
	  }

	  return toPrimitive(anObject(this), hint !== 'number');
	};

	var TO_PRIMITIVE$1 = wellKnownSymbol('toPrimitive');
	var DatePrototype$2 = Date.prototype; // `Date.prototype[@@toPrimitive]` method
	// https://tc39.github.io/ecma262/#sec-date.prototype-@@toprimitive

	if (!(TO_PRIMITIVE$1 in DatePrototype$2)) {
	  createNonEnumerableProperty(DatePrototype$2, TO_PRIMITIVE$1, dateToPrimitive);
	}

	var es_date_toPrimitive = {};

	var $stringify$1 = getBuiltIn('JSON', 'stringify');
	var re = /[\uD800-\uDFFF]/g;
	var low = /^[\uD800-\uDBFF]$/;
	var hi = /^[\uDC00-\uDFFF]$/;

	var fix = function fix(match, offset, string) {
	  var prev = string.charAt(offset - 1);
	  var next = string.charAt(offset + 1);

	  if (low.test(match) && !hi.test(next) || hi.test(match) && !low.test(prev)) {
	    return "\\u" + match.charCodeAt(0).toString(16);
	  }

	  return match;
	};

	var FORCED$f = fails(function () {
	  return $stringify$1("\uDF06\uD834") !== "\"\\udf06\\ud834\"" || $stringify$1("\uDEAD") !== "\"\\udead\"";
	});

	if ($stringify$1) {
	  // https://github.com/tc39/proposal-well-formed-stringify
	  _export({
	    target: 'JSON',
	    stat: true,
	    forced: FORCED$f
	  }, {
	    // eslint-disable-next-line no-unused-vars
	    stringify: function stringify(it, replacer, space) {
	      var result = $stringify$1.apply(null, arguments);
	      return typeof result == 'string' ? result.replace(re, fix) : result;
	    }
	  });
	}

	var es_json_stringify = {};

	// https://tc39.github.io/ecma262/#sec-json-@@tostringtag

	setToStringTag(global_1.JSON, 'JSON', true);
	var es_json_toStringTag = {};

	var nativePromiseConstructor = global_1.Promise;

	var redefineAll = function redefineAll(target, src, options) {
	  for (var key in src) {
	    redefine(target, key, src[key], options);
	  }

	  return target;
	};

	var anInstance = function anInstance(it, Constructor, name) {
	  if (!(it instanceof Constructor)) {
	    throw TypeError('Incorrect ' + (name ? name + ' ' : '') + 'invocation');
	  }

	  return it;
	};

	var engineIsIos = /(iphone|ipod|ipad).*applewebkit/i.test(engineUserAgent);

	var location = global_1.location;
	var set$1 = global_1.setImmediate;
	var clear = global_1.clearImmediate;
	var process$2 = global_1.process;
	var MessageChannel = global_1.MessageChannel;
	var Dispatch = global_1.Dispatch;
	var counter = 0;
	var queue = {};
	var ONREADYSTATECHANGE = 'onreadystatechange';
	var defer, channel, port;

	var run = function run(id) {
	  // eslint-disable-next-line no-prototype-builtins
	  if (queue.hasOwnProperty(id)) {
	    var fn = queue[id];
	    delete queue[id];
	    fn();
	  }
	};

	var runner = function runner(id) {
	  return function () {
	    run(id);
	  };
	};

	var listener = function listener(event) {
	  run(event.data);
	};

	var post = function post(id) {
	  // old engines have not location.origin
	  global_1.postMessage(id + '', location.protocol + '//' + location.host);
	}; // Node.js 0.9+ & IE10+ has setImmediate, otherwise:


	if (!set$1 || !clear) {
	  set$1 = function setImmediate(fn) {
	    var args = [];
	    var i = 1;

	    while (arguments.length > i) {
	      args.push(arguments[i++]);
	    }

	    queue[++counter] = function () {
	      // eslint-disable-next-line no-new-func
	      (typeof fn == 'function' ? fn : Function(fn)).apply(undefined, args);
	    };

	    defer(counter);
	    return counter;
	  };

	  clear = function clearImmediate(id) {
	    delete queue[id];
	  }; // Node.js 0.8-


	  if (classofRaw(process$2) == 'process') {
	    defer = function defer(id) {
	      process$2.nextTick(runner(id));
	    }; // Sphere (JS game engine) Dispatch API

	  } else if (Dispatch && Dispatch.now) {
	    defer = function defer(id) {
	      Dispatch.now(runner(id));
	    }; // Browsers with MessageChannel, includes WebWorkers
	    // except iOS - https://github.com/zloirock/core-js/issues/624

	  } else if (MessageChannel && !engineIsIos) {
	    channel = new MessageChannel();
	    port = channel.port2;
	    channel.port1.onmessage = listener;
	    defer = functionBindContext(port.postMessage, port, 1); // Browsers with postMessage, skip WebWorkers
	    // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
	  } else if (global_1.addEventListener && typeof postMessage == 'function' && !global_1.importScripts && !fails(post) && location.protocol !== 'file:') {
	    defer = post;
	    global_1.addEventListener('message', listener, false); // IE8-
	  } else if (ONREADYSTATECHANGE in documentCreateElement('script')) {
	    defer = function defer(id) {
	      html.appendChild(documentCreateElement('script'))[ONREADYSTATECHANGE] = function () {
	        html.removeChild(this);
	        run(id);
	      };
	    }; // Rest old browsers

	  } else {
	    defer = function defer(id) {
	      setTimeout(runner(id), 0);
	    };
	  }
	}

	var task = {
	  set: set$1,
	  clear: clear
	};
	var task_1 = task.set;
	var task_2 = task.clear;

	var getOwnPropertyDescriptor$7 = objectGetOwnPropertyDescriptor.f;
	var macrotask = task.set;
	var MutationObserver = global_1.MutationObserver || global_1.WebKitMutationObserver;
	var process$3 = global_1.process;
	var Promise$1 = global_1.Promise;
	var IS_NODE = classofRaw(process$3) == 'process'; // Node.js 11 shows ExperimentalWarning on getting `queueMicrotask`

	var queueMicrotaskDescriptor = getOwnPropertyDescriptor$7(global_1, 'queueMicrotask');
	var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;
	var flush, head, last, notify, toggle, node, promise, then; // modern engines have queueMicrotask method

	if (!queueMicrotask) {
	  flush = function flush() {
	    var parent, fn;
	    if (IS_NODE && (parent = process$3.domain)) parent.exit();

	    while (head) {
	      fn = head.fn;
	      head = head.next;

	      try {
	        fn();
	      } catch (error) {
	        if (head) notify();else last = undefined;
	        throw error;
	      }
	    }

	    last = undefined;
	    if (parent) parent.enter();
	  }; // Node.js


	  if (IS_NODE) {
	    notify = function notify() {
	      process$3.nextTick(flush);
	    }; // browsers with MutationObserver, except iOS - https://github.com/zloirock/core-js/issues/339

	  } else if (MutationObserver && !engineIsIos) {
	    toggle = true;
	    node = document.createTextNode('');
	    new MutationObserver(flush).observe(node, {
	      characterData: true
	    });

	    notify = function notify() {
	      node.data = toggle = !toggle;
	    }; // environments with maybe non-completely correct, but existent Promise

	  } else if (Promise$1 && Promise$1.resolve) {
	    // Promise.resolve without an argument throws an error in LG WebOS 2
	    promise = Promise$1.resolve(undefined);
	    then = promise.then;

	    notify = function notify() {
	      then.call(promise, flush);
	    }; // for other environments - macrotask based on:
	    // - setImmediate
	    // - MessageChannel
	    // - window.postMessag
	    // - onreadystatechange
	    // - setTimeout

	  } else {
	    notify = function notify() {
	      // strange IE + webpack dev server bug - use .call(global)
	      macrotask.call(global_1, flush);
	    };
	  }
	}

	var microtask = queueMicrotask || function (fn) {
	  var task = {
	    fn: fn,
	    next: undefined
	  };
	  if (last) last.next = task;

	  if (!head) {
	    head = task;
	    notify();
	  }

	  last = task;
	};

	'use strict';

	var PromiseCapability = function PromiseCapability(C) {
	  var resolve, reject;
	  this.promise = new C(function ($$resolve, $$reject) {
	    if (resolve !== undefined || reject !== undefined) throw TypeError('Bad Promise constructor');
	    resolve = $$resolve;
	    reject = $$reject;
	  });
	  this.resolve = aFunction$1(resolve);
	  this.reject = aFunction$1(reject);
	}; // 25.4.1.5 NewPromiseCapability(C)


	var f$7 = function f(C) {
	  return new PromiseCapability(C);
	};

	var newPromiseCapability = {
	  f: f$7
	};

	var promiseResolve = function promiseResolve(C, x) {
	  anObject(C);
	  if (isObject(x) && x.constructor === C) return x;
	  var promiseCapability = newPromiseCapability.f(C);
	  var resolve = promiseCapability.resolve;
	  resolve(x);
	  return promiseCapability.promise;
	};

	var hostReportErrors = function hostReportErrors(a, b) {
	  var console = global_1.console;

	  if (console && console.error) {
	    arguments.length === 1 ? console.error(a) : console.error(a, b);
	  }
	};

	var perform = function perform(exec) {
	  try {
	    return {
	      error: false,
	      value: exec()
	    };
	  } catch (error) {
	    return {
	      error: true,
	      value: error
	    };
	  }
	};

	'use strict';

	var task$1 = task.set;
	var SPECIES$6 = wellKnownSymbol('species');
	var PROMISE = 'Promise';
	var getInternalState$5 = internalState.get;
	var setInternalState$5 = internalState.set;
	var getInternalPromiseState = internalState.getterFor(PROMISE);
	var PromiseConstructor = nativePromiseConstructor;
	var TypeError$1 = global_1.TypeError;
	var document$2 = global_1.document;
	var process$4 = global_1.process;
	var $fetch = getBuiltIn('fetch');
	var newPromiseCapability$1 = newPromiseCapability.f;
	var newGenericPromiseCapability = newPromiseCapability$1;
	var IS_NODE$1 = classofRaw(process$4) == 'process';
	var DISPATCH_EVENT = !!(document$2 && document$2.createEvent && global_1.dispatchEvent);
	var UNHANDLED_REJECTION = 'unhandledrejection';
	var REJECTION_HANDLED = 'rejectionhandled';
	var PENDING = 0;
	var FULFILLED = 1;
	var REJECTED = 2;
	var HANDLED = 1;
	var UNHANDLED = 2;
	var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;
	var FORCED$g = isForced_1(PROMISE, function () {
	  var GLOBAL_CORE_JS_PROMISE = inspectSource(PromiseConstructor) !== String(PromiseConstructor);

	  if (!GLOBAL_CORE_JS_PROMISE) {
	    // V8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
	    // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
	    // We can't detect it synchronously, so just check versions
	    if (engineV8Version === 66) return true; // Unhandled rejections tracking support, NodeJS Promise without it fails @@species test

	    if (!IS_NODE$1 && typeof PromiseRejectionEvent != 'function') return true;
	  } // We need Promise#finally in the pure version for preventing prototype pollution


	  if (isPure && !PromiseConstructor.prototype['finally']) return true; // We can't use @@species feature detection in V8 since it causes
	  // deoptimization and performance degradation
	  // https://github.com/zloirock/core-js/issues/679

	  if (engineV8Version >= 51 && /native code/.test(PromiseConstructor)) return false; // Detect correctness of subclassing with @@species support

	  var promise = PromiseConstructor.resolve(1);

	  var FakePromise = function FakePromise(exec) {
	    exec(function () {
	      /* empty */
	    }, function () {
	      /* empty */
	    });
	  };

	  var constructor = promise.constructor = {};
	  constructor[SPECIES$6] = FakePromise;
	  return !(promise.then(function () {
	    /* empty */
	  }) instanceof FakePromise);
	});
	var INCORRECT_ITERATION$1 = FORCED$g || !checkCorrectnessOfIteration(function (iterable) {
	  PromiseConstructor.all(iterable)['catch'](function () {
	    /* empty */
	  });
	}); // helpers

	var isThenable = function isThenable(it) {
	  var then;
	  return isObject(it) && typeof (then = it.then) == 'function' ? then : false;
	};

	var notify$1 = function notify(promise, state, isReject) {
	  if (state.notified) return;
	  state.notified = true;
	  var chain = state.reactions;
	  microtask(function () {
	    var value = state.value;
	    var ok = state.state == FULFILLED;
	    var index = 0; // variable length - can't use forEach

	    while (chain.length > index) {
	      var reaction = chain[index++];
	      var handler = ok ? reaction.ok : reaction.fail;
	      var resolve = reaction.resolve;
	      var reject = reaction.reject;
	      var domain = reaction.domain;
	      var result, then, exited;

	      try {
	        if (handler) {
	          if (!ok) {
	            if (state.rejection === UNHANDLED) onHandleUnhandled(promise, state);
	            state.rejection = HANDLED;
	          }

	          if (handler === true) result = value;else {
	            if (domain) domain.enter();
	            result = handler(value); // can throw

	            if (domain) {
	              domain.exit();
	              exited = true;
	            }
	          }

	          if (result === reaction.promise) {
	            reject(TypeError$1('Promise-chain cycle'));
	          } else if (then = isThenable(result)) {
	            then.call(result, resolve, reject);
	          } else resolve(result);
	        } else reject(value);
	      } catch (error) {
	        if (domain && !exited) domain.exit();
	        reject(error);
	      }
	    }

	    state.reactions = [];
	    state.notified = false;
	    if (isReject && !state.rejection) onUnhandled(promise, state);
	  });
	};

	var dispatchEvent = function dispatchEvent(name, promise, reason) {
	  var event, handler;

	  if (DISPATCH_EVENT) {
	    event = document$2.createEvent('Event');
	    event.promise = promise;
	    event.reason = reason;
	    event.initEvent(name, false, true);
	    global_1.dispatchEvent(event);
	  } else event = {
	    promise: promise,
	    reason: reason
	  };

	  if (handler = global_1['on' + name]) handler(event);else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
	};

	var onUnhandled = function onUnhandled(promise, state) {
	  task$1.call(global_1, function () {
	    var value = state.value;
	    var IS_UNHANDLED = isUnhandled(state);
	    var result;

	    if (IS_UNHANDLED) {
	      result = perform(function () {
	        if (IS_NODE$1) {
	          process$4.emit('unhandledRejection', value, promise);
	        } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
	      }); // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should

	      state.rejection = IS_NODE$1 || isUnhandled(state) ? UNHANDLED : HANDLED;
	      if (result.error) throw result.value;
	    }
	  });
	};

	var isUnhandled = function isUnhandled(state) {
	  return state.rejection !== HANDLED && !state.parent;
	};

	var onHandleUnhandled = function onHandleUnhandled(promise, state) {
	  task$1.call(global_1, function () {
	    if (IS_NODE$1) {
	      process$4.emit('rejectionHandled', promise);
	    } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
	  });
	};

	var bind = function bind(fn, promise, state, unwrap) {
	  return function (value) {
	    fn(promise, state, value, unwrap);
	  };
	};

	var internalReject = function internalReject(promise, state, value, unwrap) {
	  if (state.done) return;
	  state.done = true;
	  if (unwrap) state = unwrap;
	  state.value = value;
	  state.state = REJECTED;
	  notify$1(promise, state, true);
	};

	var internalResolve = function internalResolve(promise, state, value, unwrap) {
	  if (state.done) return;
	  state.done = true;
	  if (unwrap) state = unwrap;

	  try {
	    if (promise === value) throw TypeError$1("Promise can't be resolved itself");
	    var then = isThenable(value);

	    if (then) {
	      microtask(function () {
	        var wrapper = {
	          done: false
	        };

	        try {
	          then.call(value, bind(internalResolve, promise, wrapper, state), bind(internalReject, promise, wrapper, state));
	        } catch (error) {
	          internalReject(promise, wrapper, error, state);
	        }
	      });
	    } else {
	      state.value = value;
	      state.state = FULFILLED;
	      notify$1(promise, state, false);
	    }
	  } catch (error) {
	    internalReject(promise, {
	      done: false
	    }, error, state);
	  }
	}; // constructor polyfill


	if (FORCED$g) {
	  // 25.4.3.1 Promise(executor)
	  PromiseConstructor = function Promise(executor) {
	    anInstance(this, PromiseConstructor, PROMISE);
	    aFunction$1(executor);
	    Internal.call(this);
	    var state = getInternalState$5(this);

	    try {
	      executor(bind(internalResolve, this, state), bind(internalReject, this, state));
	    } catch (error) {
	      internalReject(this, state, error);
	    }
	  }; // eslint-disable-next-line no-unused-vars


	  Internal = function Promise(executor) {
	    setInternalState$5(this, {
	      type: PROMISE,
	      done: false,
	      notified: false,
	      parent: false,
	      reactions: [],
	      rejection: false,
	      state: PENDING,
	      value: undefined
	    });
	  };

	  Internal.prototype = redefineAll(PromiseConstructor.prototype, {
	    // `Promise.prototype.then` method
	    // https://tc39.github.io/ecma262/#sec-promise.prototype.then
	    then: function then(onFulfilled, onRejected) {
	      var state = getInternalPromiseState(this);
	      var reaction = newPromiseCapability$1(speciesConstructor(this, PromiseConstructor));
	      reaction.ok = typeof onFulfilled == 'function' ? onFulfilled : true;
	      reaction.fail = typeof onRejected == 'function' && onRejected;
	      reaction.domain = IS_NODE$1 ? process$4.domain : undefined;
	      state.parent = true;
	      state.reactions.push(reaction);
	      if (state.state != PENDING) notify$1(this, state, false);
	      return reaction.promise;
	    },
	    // `Promise.prototype.catch` method
	    // https://tc39.github.io/ecma262/#sec-promise.prototype.catch
	    'catch': function _catch(onRejected) {
	      return this.then(undefined, onRejected);
	    }
	  });

	  OwnPromiseCapability = function OwnPromiseCapability() {
	    var promise = new Internal();
	    var state = getInternalState$5(promise);
	    this.promise = promise;
	    this.resolve = bind(internalResolve, promise, state);
	    this.reject = bind(internalReject, promise, state);
	  };

	  newPromiseCapability.f = newPromiseCapability$1 = function newPromiseCapability(C) {
	    return C === PromiseConstructor || C === PromiseWrapper ? new OwnPromiseCapability(C) : newGenericPromiseCapability(C);
	  };

	  if (!isPure && typeof nativePromiseConstructor == 'function') {
	    nativeThen = nativePromiseConstructor.prototype.then; // wrap native Promise#then for native async functions

	    redefine(nativePromiseConstructor.prototype, 'then', function then(onFulfilled, onRejected) {
	      var that = this;
	      return new PromiseConstructor(function (resolve, reject) {
	        nativeThen.call(that, resolve, reject);
	      }).then(onFulfilled, onRejected); // https://github.com/zloirock/core-js/issues/640
	    }, {
	      unsafe: true
	    }); // wrap fetch result

	    if (typeof $fetch == 'function') _export({
	      global: true,
	      enumerable: true,
	      forced: true
	    }, {
	      // eslint-disable-next-line no-unused-vars
	      fetch: function fetch(input
	      /* , init */
	      ) {
	        return promiseResolve(PromiseConstructor, $fetch.apply(global_1, arguments));
	      }
	    });
	  }
	}

	_export({
	  global: true,
	  wrap: true,
	  forced: FORCED$g
	}, {
	  Promise: PromiseConstructor
	});
	setToStringTag(PromiseConstructor, PROMISE, false, true);
	setSpecies(PROMISE);
	PromiseWrapper = getBuiltIn(PROMISE); // statics

	_export({
	  target: PROMISE,
	  stat: true,
	  forced: FORCED$g
	}, {
	  // `Promise.reject` method
	  // https://tc39.github.io/ecma262/#sec-promise.reject
	  reject: function reject(r) {
	    var capability = newPromiseCapability$1(this);
	    capability.reject.call(undefined, r);
	    return capability.promise;
	  }
	});
	_export({
	  target: PROMISE,
	  stat: true,
	  forced: isPure || FORCED$g
	}, {
	  // `Promise.resolve` method
	  // https://tc39.github.io/ecma262/#sec-promise.resolve
	  resolve: function resolve(x) {
	    return promiseResolve(isPure && this === PromiseWrapper ? PromiseConstructor : this, x);
	  }
	});
	_export({
	  target: PROMISE,
	  stat: true,
	  forced: INCORRECT_ITERATION$1
	}, {
	  // `Promise.all` method
	  // https://tc39.github.io/ecma262/#sec-promise.all
	  all: function all(iterable) {
	    var C = this;
	    var capability = newPromiseCapability$1(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform(function () {
	      var $promiseResolve = aFunction$1(C.resolve);
	      var values = [];
	      var counter = 0;
	      var remaining = 1;
	      iterate_1(iterable, function (promise) {
	        var index = counter++;
	        var alreadyCalled = false;
	        values.push(undefined);
	        remaining++;
	        $promiseResolve.call(C, promise).then(function (value) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = value;
	          --remaining || resolve(values);
	        }, reject);
	      });
	      --remaining || resolve(values);
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  },
	  // `Promise.race` method
	  // https://tc39.github.io/ecma262/#sec-promise.race
	  race: function race(iterable) {
	    var C = this;
	    var capability = newPromiseCapability$1(C);
	    var reject = capability.reject;
	    var result = perform(function () {
	      var $promiseResolve = aFunction$1(C.resolve);
	      iterate_1(iterable, function (promise) {
	        $promiseResolve.call(C, promise).then(capability.resolve, reject);
	      });
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});
	var es_promise = {};

	'use strict'; // `Promise.allSettled` method
	// https://github.com/tc39/proposal-promise-allSettled


	_export({
	  target: 'Promise',
	  stat: true
	}, {
	  allSettled: function allSettled(iterable) {
	    var C = this;
	    var capability = newPromiseCapability.f(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform(function () {
	      var promiseResolve = aFunction$1(C.resolve);
	      var values = [];
	      var counter = 0;
	      var remaining = 1;
	      iterate_1(iterable, function (promise) {
	        var index = counter++;
	        var alreadyCalled = false;
	        values.push(undefined);
	        remaining++;
	        promiseResolve.call(C, promise).then(function (value) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = {
	            status: 'fulfilled',
	            value: value
	          };
	          --remaining || resolve(values);
	        }, function (e) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = {
	            status: 'rejected',
	            reason: e
	          };
	          --remaining || resolve(values);
	        });
	      });
	      --remaining || resolve(values);
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});
	var es_promise_allSettled = {};

	'use strict'; // Safari bug https://bugs.webkit.org/show_bug.cgi?id=200829


	var NON_GENERIC = !!nativePromiseConstructor && fails(function () {
	  nativePromiseConstructor.prototype['finally'].call({
	    then: function then() {
	      /* empty */
	    }
	  }, function () {
	    /* empty */
	  });
	}); // `Promise.prototype.finally` method
	// https://tc39.github.io/ecma262/#sec-promise.prototype.finally

	_export({
	  target: 'Promise',
	  proto: true,
	  real: true,
	  forced: NON_GENERIC
	}, {
	  'finally': function _finally(onFinally) {
	    var C = speciesConstructor(this, getBuiltIn('Promise'));
	    var isFunction = typeof onFinally == 'function';
	    return this.then(isFunction ? function (x) {
	      return promiseResolve(C, onFinally()).then(function () {
	        return x;
	      });
	    } : onFinally, isFunction ? function (e) {
	      return promiseResolve(C, onFinally()).then(function () {
	        throw e;
	      });
	    } : onFinally);
	  }
	}); // patch native Promise.prototype for native async functions

	if (!isPure && typeof nativePromiseConstructor == 'function' && !nativePromiseConstructor.prototype['finally']) {
	  redefine(nativePromiseConstructor.prototype, 'finally', getBuiltIn('Promise').prototype['finally']);
	}

	var es_promise_finally = {};

	'use strict';

	var collection = function collection(CONSTRUCTOR_NAME, wrapper, common) {
	  var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
	  var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
	  var ADDER = IS_MAP ? 'set' : 'add';
	  var NativeConstructor = global_1[CONSTRUCTOR_NAME];
	  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
	  var Constructor = NativeConstructor;
	  var exported = {};

	  var fixMethod = function fixMethod(KEY) {
	    var nativeMethod = NativePrototype[KEY];
	    redefine(NativePrototype, KEY, KEY == 'add' ? function add(value) {
	      nativeMethod.call(this, value === 0 ? 0 : value);
	      return this;
	    } : KEY == 'delete' ? function (key) {
	      return IS_WEAK && !isObject(key) ? false : nativeMethod.call(this, key === 0 ? 0 : key);
	    } : KEY == 'get' ? function get(key) {
	      return IS_WEAK && !isObject(key) ? undefined : nativeMethod.call(this, key === 0 ? 0 : key);
	    } : KEY == 'has' ? function has(key) {
	      return IS_WEAK && !isObject(key) ? false : nativeMethod.call(this, key === 0 ? 0 : key);
	    } : function set(key, value) {
	      nativeMethod.call(this, key === 0 ? 0 : key, value);
	      return this;
	    });
	  }; // eslint-disable-next-line max-len


	  if (isForced_1(CONSTRUCTOR_NAME, typeof NativeConstructor != 'function' || !(IS_WEAK || NativePrototype.forEach && !fails(function () {
	    new NativeConstructor().entries().next();
	  })))) {
	    // create collection constructor
	    Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
	    internalMetadata.REQUIRED = true;
	  } else if (isForced_1(CONSTRUCTOR_NAME, true)) {
	    var instance = new Constructor(); // early implementations not supports chaining

	    var HASNT_CHAINING = instance[ADDER](IS_WEAK ? {} : -0, 1) != instance; // V8 ~ Chromium 40- weak-collections throws on primitives, but should return false

	    var THROWS_ON_PRIMITIVES = fails(function () {
	      instance.has(1);
	    }); // most early implementations doesn't supports iterables, most modern - not close it correctly
	    // eslint-disable-next-line no-new

	    var ACCEPT_ITERABLES = checkCorrectnessOfIteration(function (iterable) {
	      new NativeConstructor(iterable);
	    }); // for early implementations -0 and +0 not the same

	    var BUGGY_ZERO = !IS_WEAK && fails(function () {
	      // V8 ~ Chromium 42- fails only with 5+ elements
	      var $instance = new NativeConstructor();
	      var index = 5;

	      while (index--) {
	        $instance[ADDER](index, index);
	      }

	      return !$instance.has(-0);
	    });

	    if (!ACCEPT_ITERABLES) {
	      Constructor = wrapper(function (dummy, iterable) {
	        anInstance(dummy, Constructor, CONSTRUCTOR_NAME);
	        var that = inheritIfRequired(new NativeConstructor(), dummy, Constructor);
	        if (iterable != undefined) iterate_1(iterable, that[ADDER], that, IS_MAP);
	        return that;
	      });
	      Constructor.prototype = NativePrototype;
	      NativePrototype.constructor = Constructor;
	    }

	    if (THROWS_ON_PRIMITIVES || BUGGY_ZERO) {
	      fixMethod('delete');
	      fixMethod('has');
	      IS_MAP && fixMethod('get');
	    }

	    if (BUGGY_ZERO || HASNT_CHAINING) fixMethod(ADDER); // weak collections should not contains .clear method

	    if (IS_WEAK && NativePrototype.clear) delete NativePrototype.clear;
	  }

	  exported[CONSTRUCTOR_NAME] = Constructor;
	  _export({
	    global: true,
	    forced: Constructor != NativeConstructor
	  }, exported);
	  setToStringTag(Constructor, CONSTRUCTOR_NAME);
	  if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);
	  return Constructor;
	};

	'use strict';

	var defineProperty$9 = objectDefineProperty.f;
	var fastKey = internalMetadata.fastKey;
	var setInternalState$6 = internalState.set;
	var internalStateGetterFor = internalState.getterFor;
	var collectionStrong = {
	  getConstructor: function getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
	    var C = wrapper(function (that, iterable) {
	      anInstance(that, C, CONSTRUCTOR_NAME);
	      setInternalState$6(that, {
	        type: CONSTRUCTOR_NAME,
	        index: objectCreate(null),
	        first: undefined,
	        last: undefined,
	        size: 0
	      });
	      if (!descriptors) that.size = 0;
	      if (iterable != undefined) iterate_1(iterable, that[ADDER], that, IS_MAP);
	    });
	    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);

	    var define = function define(that, key, value) {
	      var state = getInternalState(that);
	      var entry = getEntry(that, key);
	      var previous, index; // change existing entry

	      if (entry) {
	        entry.value = value; // create new entry
	      } else {
	        state.last = entry = {
	          index: index = fastKey(key, true),
	          key: key,
	          value: value,
	          previous: previous = state.last,
	          next: undefined,
	          removed: false
	        };
	        if (!state.first) state.first = entry;
	        if (previous) previous.next = entry;
	        if (descriptors) state.size++;else that.size++; // add to index

	        if (index !== 'F') state.index[index] = entry;
	      }

	      return that;
	    };

	    var getEntry = function getEntry(that, key) {
	      var state = getInternalState(that); // fast case

	      var index = fastKey(key);
	      var entry;
	      if (index !== 'F') return state.index[index]; // frozen object case

	      for (entry = state.first; entry; entry = entry.next) {
	        if (entry.key == key) return entry;
	      }
	    };

	    redefineAll(C.prototype, {
	      // 23.1.3.1 Map.prototype.clear()
	      // 23.2.3.2 Set.prototype.clear()
	      clear: function clear() {
	        var that = this;
	        var state = getInternalState(that);
	        var data = state.index;
	        var entry = state.first;

	        while (entry) {
	          entry.removed = true;
	          if (entry.previous) entry.previous = entry.previous.next = undefined;
	          delete data[entry.index];
	          entry = entry.next;
	        }

	        state.first = state.last = undefined;
	        if (descriptors) state.size = 0;else that.size = 0;
	      },
	      // 23.1.3.3 Map.prototype.delete(key)
	      // 23.2.3.4 Set.prototype.delete(value)
	      'delete': function _delete(key) {
	        var that = this;
	        var state = getInternalState(that);
	        var entry = getEntry(that, key);

	        if (entry) {
	          var next = entry.next;
	          var prev = entry.previous;
	          delete state.index[entry.index];
	          entry.removed = true;
	          if (prev) prev.next = next;
	          if (next) next.previous = prev;
	          if (state.first == entry) state.first = next;
	          if (state.last == entry) state.last = prev;
	          if (descriptors) state.size--;else that.size--;
	        }

	        return !!entry;
	      },
	      // 23.2.3.6 Set.prototype.forEach(callbackfn, thisArg = undefined)
	      // 23.1.3.5 Map.prototype.forEach(callbackfn, thisArg = undefined)
	      forEach: function forEach(callbackfn
	      /* , that = undefined */
	      ) {
	        var state = getInternalState(this);
	        var boundFunction = functionBindContext(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);
	        var entry;

	        while (entry = entry ? entry.next : state.first) {
	          boundFunction(entry.value, entry.key, this); // revert to the last existing entry

	          while (entry && entry.removed) {
	            entry = entry.previous;
	          }
	        }
	      },
	      // 23.1.3.7 Map.prototype.has(key)
	      // 23.2.3.7 Set.prototype.has(value)
	      has: function has(key) {
	        return !!getEntry(this, key);
	      }
	    });
	    redefineAll(C.prototype, IS_MAP ? {
	      // 23.1.3.6 Map.prototype.get(key)
	      get: function get(key) {
	        var entry = getEntry(this, key);
	        return entry && entry.value;
	      },
	      // 23.1.3.9 Map.prototype.set(key, value)
	      set: function set(key, value) {
	        return define(this, key === 0 ? 0 : key, value);
	      }
	    } : {
	      // 23.2.3.1 Set.prototype.add(value)
	      add: function add(value) {
	        return define(this, value = value === 0 ? 0 : value, value);
	      }
	    });
	    if (descriptors) defineProperty$9(C.prototype, 'size', {
	      get: function get() {
	        return getInternalState(this).size;
	      }
	    });
	    return C;
	  },
	  setStrong: function setStrong(C, CONSTRUCTOR_NAME, IS_MAP) {
	    var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
	    var getInternalCollectionState = internalStateGetterFor(CONSTRUCTOR_NAME);
	    var getInternalIteratorState = internalStateGetterFor(ITERATOR_NAME); // add .keys, .values, .entries, [@@iterator]
	    // 23.1.3.4, 23.1.3.8, 23.1.3.11, 23.1.3.12, 23.2.3.5, 23.2.3.8, 23.2.3.10, 23.2.3.11

	    defineIterator(C, CONSTRUCTOR_NAME, function (iterated, kind) {
	      setInternalState$6(this, {
	        type: ITERATOR_NAME,
	        target: iterated,
	        state: getInternalCollectionState(iterated),
	        kind: kind,
	        last: undefined
	      });
	    }, function () {
	      var state = getInternalIteratorState(this);
	      var kind = state.kind;
	      var entry = state.last; // revert to the last existing entry

	      while (entry && entry.removed) {
	        entry = entry.previous;
	      } // get next entry


	      if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
	        // or finish the iteration
	        state.target = undefined;
	        return {
	          value: undefined,
	          done: true
	        };
	      } // return step by kind


	      if (kind == 'keys') return {
	        value: entry.key,
	        done: false
	      };
	      if (kind == 'values') return {
	        value: entry.value,
	        done: false
	      };
	      return {
	        value: [entry.key, entry.value],
	        done: false
	      };
	    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true); // add [@@species], 23.1.2.2, 23.2.2.2

	    setSpecies(CONSTRUCTOR_NAME);
	  }
	};
	var collectionStrong_1 = collectionStrong.getConstructor;
	var collectionStrong_2 = collectionStrong.setStrong;

	'use strict'; // `Map` constructor
	// https://tc39.github.io/ecma262/#sec-map-objects


	var es_map = collection('Map', function (init) {
	  return function Map() {
	    return init(this, arguments.length ? arguments[0] : undefined);
	  };
	}, collectionStrong);

	'use strict'; // `Set` constructor
	// https://tc39.github.io/ecma262/#sec-set-objects


	var es_set = collection('Set', function (init) {
	  return function Set() {
	    return init(this, arguments.length ? arguments[0] : undefined);
	  };
	}, collectionStrong);

	'use strict';

	var getWeakData = internalMetadata.getWeakData;
	var setInternalState$7 = internalState.set;
	var internalStateGetterFor$1 = internalState.getterFor;
	var find = arrayIteration.find;
	var findIndex = arrayIteration.findIndex;
	var id$1 = 0; // fallback for uncaught frozen keys

	var uncaughtFrozenStore = function uncaughtFrozenStore(store) {
	  return store.frozen || (store.frozen = new UncaughtFrozenStore());
	};

	var UncaughtFrozenStore = function UncaughtFrozenStore() {
	  this.entries = [];
	};

	var findUncaughtFrozen = function findUncaughtFrozen(store, key) {
	  return find(store.entries, function (it) {
	    return it[0] === key;
	  });
	};

	UncaughtFrozenStore.prototype = {
	  get: function get(key) {
	    var entry = findUncaughtFrozen(this, key);
	    if (entry) return entry[1];
	  },
	  has: function has(key) {
	    return !!findUncaughtFrozen(this, key);
	  },
	  set: function set(key, value) {
	    var entry = findUncaughtFrozen(this, key);
	    if (entry) entry[1] = value;else this.entries.push([key, value]);
	  },
	  'delete': function _delete(key) {
	    var index = findIndex(this.entries, function (it) {
	      return it[0] === key;
	    });
	    if (~index) this.entries.splice(index, 1);
	    return !!~index;
	  }
	};
	var collectionWeak = {
	  getConstructor: function getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
	    var C = wrapper(function (that, iterable) {
	      anInstance(that, C, CONSTRUCTOR_NAME);
	      setInternalState$7(that, {
	        type: CONSTRUCTOR_NAME,
	        id: id$1++,
	        frozen: undefined
	      });
	      if (iterable != undefined) iterate_1(iterable, that[ADDER], that, IS_MAP);
	    });
	    var getInternalState = internalStateGetterFor$1(CONSTRUCTOR_NAME);

	    var define = function define(that, key, value) {
	      var state = getInternalState(that);
	      var data = getWeakData(anObject(key), true);
	      if (data === true) uncaughtFrozenStore(state).set(key, value);else data[state.id] = value;
	      return that;
	    };

	    redefineAll(C.prototype, {
	      // 23.3.3.2 WeakMap.prototype.delete(key)
	      // 23.4.3.3 WeakSet.prototype.delete(value)
	      'delete': function _delete(key) {
	        var state = getInternalState(this);
	        if (!isObject(key)) return false;
	        var data = getWeakData(key);
	        if (data === true) return uncaughtFrozenStore(state)['delete'](key);
	        return data && has(data, state.id) && delete data[state.id];
	      },
	      // 23.3.3.4 WeakMap.prototype.has(key)
	      // 23.4.3.4 WeakSet.prototype.has(value)
	      has: function has$1(key) {
	        var state = getInternalState(this);
	        if (!isObject(key)) return false;
	        var data = getWeakData(key);
	        if (data === true) return uncaughtFrozenStore(state).has(key);
	        return data && has(data, state.id);
	      }
	    });
	    redefineAll(C.prototype, IS_MAP ? {
	      // 23.3.3.3 WeakMap.prototype.get(key)
	      get: function get(key) {
	        var state = getInternalState(this);

	        if (isObject(key)) {
	          var data = getWeakData(key);
	          if (data === true) return uncaughtFrozenStore(state).get(key);
	          return data ? data[state.id] : undefined;
	        }
	      },
	      // 23.3.3.5 WeakMap.prototype.set(key, value)
	      set: function set(key, value) {
	        return define(this, key, value);
	      }
	    } : {
	      // 23.4.3.1 WeakSet.prototype.add(value)
	      add: function add(value) {
	        return define(this, value, true);
	      }
	    });
	    return C;
	  }
	};
	var collectionWeak_1 = collectionWeak.getConstructor;

	var es_weakMap = createCommonjsModule(function (module) {
	  'use strict';

	  var enforceIternalState = internalState.enforce;
	  var IS_IE11 = !global_1.ActiveXObject && 'ActiveXObject' in global_1;
	  var isExtensible = Object.isExtensible;
	  var InternalWeakMap;

	  var wrapper = function wrapper(init) {
	    return function WeakMap() {
	      return init(this, arguments.length ? arguments[0] : undefined);
	    };
	  }; // `WeakMap` constructor
	  // https://tc39.github.io/ecma262/#sec-weakmap-constructor


	  var $WeakMap = module.exports = collection('WeakMap', wrapper, collectionWeak); // IE11 WeakMap frozen keys fix
	  // We can't use feature detection because it crash some old IE builds
	  // https://github.com/zloirock/core-js/issues/485

	  if (nativeWeakMap && IS_IE11) {
	    InternalWeakMap = collectionWeak.getConstructor(wrapper, 'WeakMap', true);
	    internalMetadata.REQUIRED = true;
	    var WeakMapPrototype = $WeakMap.prototype;
	    var nativeDelete = WeakMapPrototype['delete'];
	    var nativeHas = WeakMapPrototype.has;
	    var nativeGet = WeakMapPrototype.get;
	    var nativeSet = WeakMapPrototype.set;
	    redefineAll(WeakMapPrototype, {
	      'delete': function _delete(key) {
	        if (isObject(key) && !isExtensible(key)) {
	          var state = enforceIternalState(this);
	          if (!state.frozen) state.frozen = new InternalWeakMap();
	          return nativeDelete.call(this, key) || state.frozen['delete'](key);
	        }

	        return nativeDelete.call(this, key);
	      },
	      has: function has(key) {
	        if (isObject(key) && !isExtensible(key)) {
	          var state = enforceIternalState(this);
	          if (!state.frozen) state.frozen = new InternalWeakMap();
	          return nativeHas.call(this, key) || state.frozen.has(key);
	        }

	        return nativeHas.call(this, key);
	      },
	      get: function get(key) {
	        if (isObject(key) && !isExtensible(key)) {
	          var state = enforceIternalState(this);
	          if (!state.frozen) state.frozen = new InternalWeakMap();
	          return nativeHas.call(this, key) ? nativeGet.call(this, key) : state.frozen.get(key);
	        }

	        return nativeGet.call(this, key);
	      },
	      set: function set(key, value) {
	        if (isObject(key) && !isExtensible(key)) {
	          var state = enforceIternalState(this);
	          if (!state.frozen) state.frozen = new InternalWeakMap();
	          nativeHas.call(this, key) ? nativeSet.call(this, key, value) : state.frozen.set(key, value);
	        } else nativeSet.call(this, key, value);

	        return this;
	      }
	    });
	  }
	});

	'use strict'; // `WeakSet` constructor
	// https://tc39.github.io/ecma262/#sec-weakset-constructor


	collection('WeakSet', function (init) {
	  return function WeakSet() {
	    return init(this, arguments.length ? arguments[0] : undefined);
	  };
	}, collectionWeak);
	var es_weakSet = {};

	var arrayBufferNative = typeof ArrayBuffer !== 'undefined' && typeof DataView !== 'undefined';

	// https://tc39.github.io/ecma262/#sec-toindex

	var toIndex = function toIndex(it) {
	  if (it === undefined) return 0;
	  var number = toInteger(it);
	  var length = toLength(number);
	  if (number !== length) throw RangeError('Wrong length or index');
	  return length;
	};

	// IEEE754 conversions based on https://github.com/feross/ieee754
	// eslint-disable-next-line no-shadow-restricted-names
	var Infinity$1 = 1 / 0;
	var abs$7 = Math.abs;
	var pow$3 = Math.pow;
	var floor$6 = Math.floor;
	var log$8 = Math.log;
	var LN2$2 = Math.LN2;

	var pack = function pack(number, mantissaLength, bytes) {
	  var buffer = new Array(bytes);
	  var exponentLength = bytes * 8 - mantissaLength - 1;
	  var eMax = (1 << exponentLength) - 1;
	  var eBias = eMax >> 1;
	  var rt = mantissaLength === 23 ? pow$3(2, -24) - pow$3(2, -77) : 0;
	  var sign = number < 0 || number === 0 && 1 / number < 0 ? 1 : 0;
	  var index = 0;
	  var exponent, mantissa, c;
	  number = abs$7(number); // eslint-disable-next-line no-self-compare

	  if (number != number || number === Infinity$1) {
	    // eslint-disable-next-line no-self-compare
	    mantissa = number != number ? 1 : 0;
	    exponent = eMax;
	  } else {
	    exponent = floor$6(log$8(number) / LN2$2);

	    if (number * (c = pow$3(2, -exponent)) < 1) {
	      exponent--;
	      c *= 2;
	    }

	    if (exponent + eBias >= 1) {
	      number += rt / c;
	    } else {
	      number += rt * pow$3(2, 1 - eBias);
	    }

	    if (number * c >= 2) {
	      exponent++;
	      c /= 2;
	    }

	    if (exponent + eBias >= eMax) {
	      mantissa = 0;
	      exponent = eMax;
	    } else if (exponent + eBias >= 1) {
	      mantissa = (number * c - 1) * pow$3(2, mantissaLength);
	      exponent = exponent + eBias;
	    } else {
	      mantissa = number * pow$3(2, eBias - 1) * pow$3(2, mantissaLength);
	      exponent = 0;
	    }
	  }

	  for (; mantissaLength >= 8; buffer[index++] = mantissa & 255, mantissa /= 256, mantissaLength -= 8) {
	    ;
	  }

	  exponent = exponent << mantissaLength | mantissa;
	  exponentLength += mantissaLength;

	  for (; exponentLength > 0; buffer[index++] = exponent & 255, exponent /= 256, exponentLength -= 8) {
	    ;
	  }

	  buffer[--index] |= sign * 128;
	  return buffer;
	};

	var unpack = function unpack(buffer, mantissaLength) {
	  var bytes = buffer.length;
	  var exponentLength = bytes * 8 - mantissaLength - 1;
	  var eMax = (1 << exponentLength) - 1;
	  var eBias = eMax >> 1;
	  var nBits = exponentLength - 7;
	  var index = bytes - 1;
	  var sign = buffer[index--];
	  var exponent = sign & 127;
	  var mantissa;
	  sign >>= 7;

	  for (; nBits > 0; exponent = exponent * 256 + buffer[index], index--, nBits -= 8) {
	    ;
	  }

	  mantissa = exponent & (1 << -nBits) - 1;
	  exponent >>= -nBits;
	  nBits += mantissaLength;

	  for (; nBits > 0; mantissa = mantissa * 256 + buffer[index], index--, nBits -= 8) {
	    ;
	  }

	  if (exponent === 0) {
	    exponent = 1 - eBias;
	  } else if (exponent === eMax) {
	    return mantissa ? NaN : sign ? -Infinity$1 : Infinity$1;
	  } else {
	    mantissa = mantissa + pow$3(2, mantissaLength);
	    exponent = exponent - eBias;
	  }

	  return (sign ? -1 : 1) * mantissa * pow$3(2, exponent - mantissaLength);
	};

	var ieee754 = {
	  pack: pack,
	  unpack: unpack
	};
	var ieee754_1 = ieee754.pack;
	var ieee754_2 = ieee754.unpack;

	'use strict';

	var getOwnPropertyNames$2 = objectGetOwnPropertyNames.f;
	var defineProperty$a = objectDefineProperty.f;
	var getInternalState$6 = internalState.get;
	var setInternalState$8 = internalState.set;
	var ARRAY_BUFFER = 'ArrayBuffer';
	var DATA_VIEW = 'DataView';
	var PROTOTYPE$2 = 'prototype';
	var WRONG_LENGTH = 'Wrong length';
	var WRONG_INDEX = 'Wrong index';
	var NativeArrayBuffer = global_1[ARRAY_BUFFER];
	var $ArrayBuffer = NativeArrayBuffer;
	var $DataView = global_1[DATA_VIEW];
	var $DataViewPrototype = $DataView && $DataView[PROTOTYPE$2];
	var ObjectPrototype$2 = Object.prototype;
	var RangeError$1 = global_1.RangeError;
	var packIEEE754 = ieee754.pack;
	var unpackIEEE754 = ieee754.unpack;

	var packInt8 = function packInt8(number) {
	  return [number & 0xFF];
	};

	var packInt16 = function packInt16(number) {
	  return [number & 0xFF, number >> 8 & 0xFF];
	};

	var packInt32 = function packInt32(number) {
	  return [number & 0xFF, number >> 8 & 0xFF, number >> 16 & 0xFF, number >> 24 & 0xFF];
	};

	var unpackInt32 = function unpackInt32(buffer) {
	  return buffer[3] << 24 | buffer[2] << 16 | buffer[1] << 8 | buffer[0];
	};

	var packFloat32 = function packFloat32(number) {
	  return packIEEE754(number, 23, 4);
	};

	var packFloat64 = function packFloat64(number) {
	  return packIEEE754(number, 52, 8);
	};

	var addGetter = function addGetter(Constructor, key) {
	  defineProperty$a(Constructor[PROTOTYPE$2], key, {
	    get: function get() {
	      return getInternalState$6(this)[key];
	    }
	  });
	};

	var get$1 = function get(view, count, index, isLittleEndian) {
	  var intIndex = toIndex(index);
	  var store = getInternalState$6(view);
	  if (intIndex + count > store.byteLength) throw RangeError$1(WRONG_INDEX);
	  var bytes = getInternalState$6(store.buffer).bytes;
	  var start = intIndex + store.byteOffset;
	  var pack = bytes.slice(start, start + count);
	  return isLittleEndian ? pack : pack.reverse();
	};

	var set$2 = function set(view, count, index, conversion, value, isLittleEndian) {
	  var intIndex = toIndex(index);
	  var store = getInternalState$6(view);
	  if (intIndex + count > store.byteLength) throw RangeError$1(WRONG_INDEX);
	  var bytes = getInternalState$6(store.buffer).bytes;
	  var start = intIndex + store.byteOffset;
	  var pack = conversion(+value);

	  for (var i = 0; i < count; i++) {
	    bytes[start + i] = pack[isLittleEndian ? i : count - i - 1];
	  }
	};

	if (!arrayBufferNative) {
	  $ArrayBuffer = function ArrayBuffer(length) {
	    anInstance(this, $ArrayBuffer, ARRAY_BUFFER);
	    var byteLength = toIndex(length);
	    setInternalState$8(this, {
	      bytes: arrayFill.call(new Array(byteLength), 0),
	      byteLength: byteLength
	    });
	    if (!descriptors) this.byteLength = byteLength;
	  };

	  $DataView = function DataView(buffer, byteOffset, byteLength) {
	    anInstance(this, $DataView, DATA_VIEW);
	    anInstance(buffer, $ArrayBuffer, DATA_VIEW);
	    var bufferLength = getInternalState$6(buffer).byteLength;
	    var offset = toInteger(byteOffset);
	    if (offset < 0 || offset > bufferLength) throw RangeError$1('Wrong offset');
	    byteLength = byteLength === undefined ? bufferLength - offset : toLength(byteLength);
	    if (offset + byteLength > bufferLength) throw RangeError$1(WRONG_LENGTH);
	    setInternalState$8(this, {
	      buffer: buffer,
	      byteLength: byteLength,
	      byteOffset: offset
	    });

	    if (!descriptors) {
	      this.buffer = buffer;
	      this.byteLength = byteLength;
	      this.byteOffset = offset;
	    }
	  };

	  if (descriptors) {
	    addGetter($ArrayBuffer, 'byteLength');
	    addGetter($DataView, 'buffer');
	    addGetter($DataView, 'byteLength');
	    addGetter($DataView, 'byteOffset');
	  }

	  redefineAll($DataView[PROTOTYPE$2], {
	    getInt8: function getInt8(byteOffset) {
	      return get$1(this, 1, byteOffset)[0] << 24 >> 24;
	    },
	    getUint8: function getUint8(byteOffset) {
	      return get$1(this, 1, byteOffset)[0];
	    },
	    getInt16: function getInt16(byteOffset
	    /* , littleEndian */
	    ) {
	      var bytes = get$1(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
	      return (bytes[1] << 8 | bytes[0]) << 16 >> 16;
	    },
	    getUint16: function getUint16(byteOffset
	    /* , littleEndian */
	    ) {
	      var bytes = get$1(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
	      return bytes[1] << 8 | bytes[0];
	    },
	    getInt32: function getInt32(byteOffset
	    /* , littleEndian */
	    ) {
	      return unpackInt32(get$1(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined));
	    },
	    getUint32: function getUint32(byteOffset
	    /* , littleEndian */
	    ) {
	      return unpackInt32(get$1(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined)) >>> 0;
	    },
	    getFloat32: function getFloat32(byteOffset
	    /* , littleEndian */
	    ) {
	      return unpackIEEE754(get$1(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 23);
	    },
	    getFloat64: function getFloat64(byteOffset
	    /* , littleEndian */
	    ) {
	      return unpackIEEE754(get$1(this, 8, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 52);
	    },
	    setInt8: function setInt8(byteOffset, value) {
	      set$2(this, 1, byteOffset, packInt8, value);
	    },
	    setUint8: function setUint8(byteOffset, value) {
	      set$2(this, 1, byteOffset, packInt8, value);
	    },
	    setInt16: function setInt16(byteOffset, value
	    /* , littleEndian */
	    ) {
	      set$2(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setUint16: function setUint16(byteOffset, value
	    /* , littleEndian */
	    ) {
	      set$2(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setInt32: function setInt32(byteOffset, value
	    /* , littleEndian */
	    ) {
	      set$2(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setUint32: function setUint32(byteOffset, value
	    /* , littleEndian */
	    ) {
	      set$2(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setFloat32: function setFloat32(byteOffset, value
	    /* , littleEndian */
	    ) {
	      set$2(this, 4, byteOffset, packFloat32, value, arguments.length > 2 ? arguments[2] : undefined);
	    },
	    setFloat64: function setFloat64(byteOffset, value
	    /* , littleEndian */
	    ) {
	      set$2(this, 8, byteOffset, packFloat64, value, arguments.length > 2 ? arguments[2] : undefined);
	    }
	  });
	} else {
	  if (!fails(function () {
	    NativeArrayBuffer(1);
	  }) || !fails(function () {
	    new NativeArrayBuffer(-1); // eslint-disable-line no-new
	  }) || fails(function () {
	    new NativeArrayBuffer(); // eslint-disable-line no-new

	    new NativeArrayBuffer(1.5); // eslint-disable-line no-new

	    new NativeArrayBuffer(NaN); // eslint-disable-line no-new

	    return NativeArrayBuffer.name != ARRAY_BUFFER;
	  })) {
	    $ArrayBuffer = function ArrayBuffer(length) {
	      anInstance(this, $ArrayBuffer);
	      return new NativeArrayBuffer(toIndex(length));
	    };

	    var ArrayBufferPrototype = $ArrayBuffer[PROTOTYPE$2] = NativeArrayBuffer[PROTOTYPE$2];

	    for (var keys$3 = getOwnPropertyNames$2(NativeArrayBuffer), j$1 = 0, key$1; keys$3.length > j$1;) {
	      if (!((key$1 = keys$3[j$1++]) in $ArrayBuffer)) {
	        createNonEnumerableProperty($ArrayBuffer, key$1, NativeArrayBuffer[key$1]);
	      }
	    }

	    ArrayBufferPrototype.constructor = $ArrayBuffer;
	  } // WebKit bug - the same parent prototype for typed arrays and data view


	  if (objectSetPrototypeOf && objectGetPrototypeOf($DataViewPrototype) !== ObjectPrototype$2) {
	    objectSetPrototypeOf($DataViewPrototype, ObjectPrototype$2);
	  } // iOS Safari 7.x bug


	  var testView = new $DataView(new $ArrayBuffer(2));
	  var nativeSetInt8 = $DataViewPrototype.setInt8;
	  testView.setInt8(0, 2147483648);
	  testView.setInt8(1, 2147483649);
	  if (testView.getInt8(0) || !testView.getInt8(1)) redefineAll($DataViewPrototype, {
	    setInt8: function setInt8(byteOffset, value) {
	      nativeSetInt8.call(this, byteOffset, value << 24 >> 24);
	    },
	    setUint8: function setUint8(byteOffset, value) {
	      nativeSetInt8.call(this, byteOffset, value << 24 >> 24);
	    }
	  }, {
	    unsafe: true
	  });
	}

	setToStringTag($ArrayBuffer, ARRAY_BUFFER);
	setToStringTag($DataView, DATA_VIEW);
	var arrayBuffer = {
	  ArrayBuffer: $ArrayBuffer,
	  DataView: $DataView
	};

	'use strict';

	var ARRAY_BUFFER$1 = 'ArrayBuffer';
	var ArrayBuffer$1 = arrayBuffer[ARRAY_BUFFER$1];
	var NativeArrayBuffer$1 = global_1[ARRAY_BUFFER$1]; // `ArrayBuffer` constructor
	// https://tc39.github.io/ecma262/#sec-arraybuffer-constructor

	_export({
	  global: true,
	  forced: NativeArrayBuffer$1 !== ArrayBuffer$1
	}, {
	  ArrayBuffer: ArrayBuffer$1
	});
	setSpecies(ARRAY_BUFFER$1);
	var es_arrayBuffer_constructor = {};

	'use strict';

	var defineProperty$b = objectDefineProperty.f;
	var Int8Array$1 = global_1.Int8Array;
	var Int8ArrayPrototype = Int8Array$1 && Int8Array$1.prototype;
	var Uint8ClampedArray$1 = global_1.Uint8ClampedArray;
	var Uint8ClampedArrayPrototype = Uint8ClampedArray$1 && Uint8ClampedArray$1.prototype;
	var TypedArray = Int8Array$1 && objectGetPrototypeOf(Int8Array$1);
	var TypedArrayPrototype = Int8ArrayPrototype && objectGetPrototypeOf(Int8ArrayPrototype);
	var ObjectPrototype$3 = Object.prototype;
	var isPrototypeOf = ObjectPrototype$3.isPrototypeOf;
	var TO_STRING_TAG$3 = wellKnownSymbol('toStringTag');
	var TYPED_ARRAY_TAG = uid('TYPED_ARRAY_TAG'); // Fixing native typed arrays in Opera Presto crashes the browser, see #595

	var NATIVE_ARRAY_BUFFER_VIEWS = arrayBufferNative && !!objectSetPrototypeOf && classof(global_1.opera) !== 'Opera';
	var TYPED_ARRAY_TAG_REQIRED = false;
	var NAME$1;
	var TypedArrayConstructorsList = {
	  Int8Array: 1,
	  Uint8Array: 1,
	  Uint8ClampedArray: 1,
	  Int16Array: 2,
	  Uint16Array: 2,
	  Int32Array: 4,
	  Uint32Array: 4,
	  Float32Array: 4,
	  Float64Array: 8
	};

	var isView = function isView(it) {
	  var klass = classof(it);
	  return klass === 'DataView' || has(TypedArrayConstructorsList, klass);
	};

	var isTypedArray = function isTypedArray(it) {
	  return isObject(it) && has(TypedArrayConstructorsList, classof(it));
	};

	var aTypedArray = function aTypedArray(it) {
	  if (isTypedArray(it)) return it;
	  throw TypeError('Target is not a typed array');
	};

	var aTypedArrayConstructor = function aTypedArrayConstructor(C) {
	  if (objectSetPrototypeOf) {
	    if (isPrototypeOf.call(TypedArray, C)) return C;
	  } else for (var ARRAY in TypedArrayConstructorsList) {
	    if (has(TypedArrayConstructorsList, NAME$1)) {
	      var TypedArrayConstructor = global_1[ARRAY];

	      if (TypedArrayConstructor && (C === TypedArrayConstructor || isPrototypeOf.call(TypedArrayConstructor, C))) {
	        return C;
	      }
	    }
	  }

	  throw TypeError('Target is not a typed array constructor');
	};

	var exportTypedArrayMethod = function exportTypedArrayMethod(KEY, property, forced) {
	  if (!descriptors) return;
	  if (forced) for (var ARRAY in TypedArrayConstructorsList) {
	    var TypedArrayConstructor = global_1[ARRAY];

	    if (TypedArrayConstructor && has(TypedArrayConstructor.prototype, KEY)) {
	      delete TypedArrayConstructor.prototype[KEY];
	    }
	  }

	  if (!TypedArrayPrototype[KEY] || forced) {
	    redefine(TypedArrayPrototype, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && Int8ArrayPrototype[KEY] || property);
	  }
	};

	var exportTypedArrayStaticMethod = function exportTypedArrayStaticMethod(KEY, property, forced) {
	  var ARRAY, TypedArrayConstructor;
	  if (!descriptors) return;

	  if (objectSetPrototypeOf) {
	    if (forced) for (ARRAY in TypedArrayConstructorsList) {
	      TypedArrayConstructor = global_1[ARRAY];

	      if (TypedArrayConstructor && has(TypedArrayConstructor, KEY)) {
	        delete TypedArrayConstructor[KEY];
	      }
	    }

	    if (!TypedArray[KEY] || forced) {
	      // V8 ~ Chrome 49-50 `%TypedArray%` methods are non-writable non-configurable
	      try {
	        return redefine(TypedArray, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && Int8Array$1[KEY] || property);
	      } catch (error) {
	        /* empty */
	      }
	    } else return;
	  }

	  for (ARRAY in TypedArrayConstructorsList) {
	    TypedArrayConstructor = global_1[ARRAY];

	    if (TypedArrayConstructor && (!TypedArrayConstructor[KEY] || forced)) {
	      redefine(TypedArrayConstructor, KEY, property);
	    }
	  }
	};

	for (NAME$1 in TypedArrayConstructorsList) {
	  if (!global_1[NAME$1]) NATIVE_ARRAY_BUFFER_VIEWS = false;
	} // WebKit bug - typed arrays constructors prototype is Object.prototype


	if (!NATIVE_ARRAY_BUFFER_VIEWS || typeof TypedArray != 'function' || TypedArray === Function.prototype) {
	  // eslint-disable-next-line no-shadow
	  TypedArray = function TypedArray() {
	    throw TypeError('Incorrect invocation');
	  };

	  if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME$1 in TypedArrayConstructorsList) {
	    if (global_1[NAME$1]) objectSetPrototypeOf(global_1[NAME$1], TypedArray);
	  }
	}

	if (!NATIVE_ARRAY_BUFFER_VIEWS || !TypedArrayPrototype || TypedArrayPrototype === ObjectPrototype$3) {
	  TypedArrayPrototype = TypedArray.prototype;
	  if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME$1 in TypedArrayConstructorsList) {
	    if (global_1[NAME$1]) objectSetPrototypeOf(global_1[NAME$1].prototype, TypedArrayPrototype);
	  }
	} // WebKit bug - one more object in Uint8ClampedArray prototype chain


	if (NATIVE_ARRAY_BUFFER_VIEWS && objectGetPrototypeOf(Uint8ClampedArrayPrototype) !== TypedArrayPrototype) {
	  objectSetPrototypeOf(Uint8ClampedArrayPrototype, TypedArrayPrototype);
	}

	if (descriptors && !has(TypedArrayPrototype, TO_STRING_TAG$3)) {
	  TYPED_ARRAY_TAG_REQIRED = true;
	  defineProperty$b(TypedArrayPrototype, TO_STRING_TAG$3, {
	    get: function get() {
	      return isObject(this) ? this[TYPED_ARRAY_TAG] : undefined;
	    }
	  });

	  for (NAME$1 in TypedArrayConstructorsList) {
	    if (global_1[NAME$1]) {
	      createNonEnumerableProperty(global_1[NAME$1], TYPED_ARRAY_TAG, NAME$1);
	    }
	  }
	}

	var arrayBufferViewCore = {
	  NATIVE_ARRAY_BUFFER_VIEWS: NATIVE_ARRAY_BUFFER_VIEWS,
	  TYPED_ARRAY_TAG: TYPED_ARRAY_TAG_REQIRED && TYPED_ARRAY_TAG,
	  aTypedArray: aTypedArray,
	  aTypedArrayConstructor: aTypedArrayConstructor,
	  exportTypedArrayMethod: exportTypedArrayMethod,
	  exportTypedArrayStaticMethod: exportTypedArrayStaticMethod,
	  isView: isView,
	  isTypedArray: isTypedArray,
	  TypedArray: TypedArray,
	  TypedArrayPrototype: TypedArrayPrototype
	};
	var arrayBufferViewCore_1 = arrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS;
	var arrayBufferViewCore_2 = arrayBufferViewCore.TYPED_ARRAY_TAG;
	var arrayBufferViewCore_3 = arrayBufferViewCore.aTypedArray;
	var arrayBufferViewCore_4 = arrayBufferViewCore.aTypedArrayConstructor;
	var arrayBufferViewCore_5 = arrayBufferViewCore.exportTypedArrayMethod;
	var arrayBufferViewCore_6 = arrayBufferViewCore.exportTypedArrayStaticMethod;
	var arrayBufferViewCore_7 = arrayBufferViewCore.isView;
	var arrayBufferViewCore_8 = arrayBufferViewCore.isTypedArray;
	var arrayBufferViewCore_9 = arrayBufferViewCore.TypedArray;
	var arrayBufferViewCore_10 = arrayBufferViewCore.TypedArrayPrototype;

	var NATIVE_ARRAY_BUFFER_VIEWS$1 = arrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS; // `ArrayBuffer.isView` method
	// https://tc39.github.io/ecma262/#sec-arraybuffer.isview

	_export({
	  target: 'ArrayBuffer',
	  stat: true,
	  forced: !NATIVE_ARRAY_BUFFER_VIEWS$1
	}, {
	  isView: arrayBufferViewCore.isView
	});
	var es_arrayBuffer_isView = {};

	'use strict';

	var ArrayBuffer$2 = arrayBuffer.ArrayBuffer;
	var DataView$1 = arrayBuffer.DataView;
	var nativeArrayBufferSlice = ArrayBuffer$2.prototype.slice;
	var INCORRECT_SLICE = fails(function () {
	  return !new ArrayBuffer$2(2).slice(1, undefined).byteLength;
	}); // `ArrayBuffer.prototype.slice` method
	// https://tc39.github.io/ecma262/#sec-arraybuffer.prototype.slice

	_export({
	  target: 'ArrayBuffer',
	  proto: true,
	  unsafe: true,
	  forced: INCORRECT_SLICE
	}, {
	  slice: function slice(start, end) {
	    if (nativeArrayBufferSlice !== undefined && end === undefined) {
	      return nativeArrayBufferSlice.call(anObject(this), start); // FF fix
	    }

	    var length = anObject(this).byteLength;
	    var first = toAbsoluteIndex(start, length);
	    var fin = toAbsoluteIndex(end === undefined ? length : end, length);
	    var result = new (speciesConstructor(this, ArrayBuffer$2))(toLength(fin - first));
	    var viewSource = new DataView$1(this);
	    var viewTarget = new DataView$1(result);
	    var index = 0;

	    while (first < fin) {
	      viewTarget.setUint8(index++, viewSource.getUint8(first++));
	    }

	    return result;
	  }
	});
	var es_arrayBuffer_slice = {};

	// https://tc39.github.io/ecma262/#sec-dataview-constructor

	_export({
	  global: true,
	  forced: !arrayBufferNative
	}, {
	  DataView: arrayBuffer.DataView
	});
	var es_dataView = {};

	/* eslint-disable no-new */

	var NATIVE_ARRAY_BUFFER_VIEWS$2 = arrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS;
	var ArrayBuffer$3 = global_1.ArrayBuffer;
	var Int8Array$2 = global_1.Int8Array;
	var typedArrayConstructorsRequireWrappers = !NATIVE_ARRAY_BUFFER_VIEWS$2 || !fails(function () {
	  Int8Array$2(1);
	}) || !fails(function () {
	  new Int8Array$2(-1);
	}) || !checkCorrectnessOfIteration(function (iterable) {
	  new Int8Array$2();
	  new Int8Array$2(null);
	  new Int8Array$2(1.5);
	  new Int8Array$2(iterable);
	}, true) || fails(function () {
	  // Safari (11+) bug - a reason why even Safari 13 should load a typed array polyfill
	  return new Int8Array$2(new ArrayBuffer$3(2), 1, undefined).length !== 1;
	});

	var toPositiveInteger = function toPositiveInteger(it) {
	  var result = toInteger(it);
	  if (result < 0) throw RangeError("The argument can't be less than 0");
	  return result;
	};

	var toOffset = function toOffset(it, BYTES) {
	  var offset = toPositiveInteger(it);
	  if (offset % BYTES) throw RangeError('Wrong offset');
	  return offset;
	};

	var aTypedArrayConstructor$1 = arrayBufferViewCore.aTypedArrayConstructor;

	var typedArrayFrom = function from(source
	/* , mapfn, thisArg */
	) {
	  var O = toObject(source);
	  var argumentsLength = arguments.length;
	  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
	  var mapping = mapfn !== undefined;
	  var iteratorMethod = getIteratorMethod(O);
	  var i, length, result, step, iterator, next;

	  if (iteratorMethod != undefined && !isArrayIteratorMethod(iteratorMethod)) {
	    iterator = iteratorMethod.call(O);
	    next = iterator.next;
	    O = [];

	    while (!(step = next.call(iterator)).done) {
	      O.push(step.value);
	    }
	  }

	  if (mapping && argumentsLength > 2) {
	    mapfn = functionBindContext(mapfn, arguments[2], 2);
	  }

	  length = toLength(O.length);
	  result = new (aTypedArrayConstructor$1(this))(length);

	  for (i = 0; length > i; i++) {
	    result[i] = mapping ? mapfn(O[i], i) : O[i];
	  }

	  return result;
	};

	var typedArrayConstructor = createCommonjsModule(function (module) {
	  'use strict';

	  var getOwnPropertyNames = objectGetOwnPropertyNames.f;
	  var forEach = arrayIteration.forEach;
	  var getInternalState = internalState.get;
	  var setInternalState = internalState.set;
	  var nativeDefineProperty = objectDefineProperty.f;
	  var nativeGetOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
	  var round = Math.round;
	  var RangeError = global_1.RangeError;
	  var ArrayBuffer = arrayBuffer.ArrayBuffer;
	  var DataView = arrayBuffer.DataView;
	  var NATIVE_ARRAY_BUFFER_VIEWS = arrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS;
	  var TYPED_ARRAY_TAG = arrayBufferViewCore.TYPED_ARRAY_TAG;
	  var TypedArray = arrayBufferViewCore.TypedArray;
	  var TypedArrayPrototype = arrayBufferViewCore.TypedArrayPrototype;
	  var aTypedArrayConstructor = arrayBufferViewCore.aTypedArrayConstructor;
	  var isTypedArray = arrayBufferViewCore.isTypedArray;
	  var BYTES_PER_ELEMENT = 'BYTES_PER_ELEMENT';
	  var WRONG_LENGTH = 'Wrong length';

	  var fromList = function fromList(C, list) {
	    var index = 0;
	    var length = list.length;
	    var result = new (aTypedArrayConstructor(C))(length);

	    while (length > index) {
	      result[index] = list[index++];
	    }

	    return result;
	  };

	  var addGetter = function addGetter(it, key) {
	    nativeDefineProperty(it, key, {
	      get: function get() {
	        return getInternalState(this)[key];
	      }
	    });
	  };

	  var isArrayBuffer = function isArrayBuffer(it) {
	    var klass;
	    return it instanceof ArrayBuffer || (klass = classof(it)) == 'ArrayBuffer' || klass == 'SharedArrayBuffer';
	  };

	  var isTypedArrayIndex = function isTypedArrayIndex(target, key) {
	    return isTypedArray(target) && typeof key != 'symbol' && key in target && String(+key) == String(key);
	  };

	  var wrappedGetOwnPropertyDescriptor = function getOwnPropertyDescriptor(target, key) {
	    return isTypedArrayIndex(target, key = toPrimitive(key, true)) ? createPropertyDescriptor(2, target[key]) : nativeGetOwnPropertyDescriptor(target, key);
	  };

	  var wrappedDefineProperty = function defineProperty(target, key, descriptor) {
	    if (isTypedArrayIndex(target, key = toPrimitive(key, true)) && isObject(descriptor) && has(descriptor, 'value') && !has(descriptor, 'get') && !has(descriptor, 'set') // TODO: add validation descriptor w/o calling accessors
	    && !descriptor.configurable && (!has(descriptor, 'writable') || descriptor.writable) && (!has(descriptor, 'enumerable') || descriptor.enumerable)) {
	      target[key] = descriptor.value;
	      return target;
	    }

	    return nativeDefineProperty(target, key, descriptor);
	  };

	  if (descriptors) {
	    if (!NATIVE_ARRAY_BUFFER_VIEWS) {
	      objectGetOwnPropertyDescriptor.f = wrappedGetOwnPropertyDescriptor;
	      objectDefineProperty.f = wrappedDefineProperty;
	      addGetter(TypedArrayPrototype, 'buffer');
	      addGetter(TypedArrayPrototype, 'byteOffset');
	      addGetter(TypedArrayPrototype, 'byteLength');
	      addGetter(TypedArrayPrototype, 'length');
	    }

	    _export({
	      target: 'Object',
	      stat: true,
	      forced: !NATIVE_ARRAY_BUFFER_VIEWS
	    }, {
	      getOwnPropertyDescriptor: wrappedGetOwnPropertyDescriptor,
	      defineProperty: wrappedDefineProperty
	    });

	    module.exports = function (TYPE, wrapper, CLAMPED) {
	      var BYTES = TYPE.match(/\d+$/)[0] / 8;
	      var CONSTRUCTOR_NAME = TYPE + (CLAMPED ? 'Clamped' : '') + 'Array';
	      var GETTER = 'get' + TYPE;
	      var SETTER = 'set' + TYPE;
	      var NativeTypedArrayConstructor = global_1[CONSTRUCTOR_NAME];
	      var TypedArrayConstructor = NativeTypedArrayConstructor;
	      var TypedArrayConstructorPrototype = TypedArrayConstructor && TypedArrayConstructor.prototype;
	      var exported = {};

	      var getter = function getter(that, index) {
	        var data = getInternalState(that);
	        return data.view[GETTER](index * BYTES + data.byteOffset, true);
	      };

	      var setter = function setter(that, index, value) {
	        var data = getInternalState(that);
	        if (CLAMPED) value = (value = round(value)) < 0 ? 0 : value > 0xFF ? 0xFF : value & 0xFF;
	        data.view[SETTER](index * BYTES + data.byteOffset, value, true);
	      };

	      var addElement = function addElement(that, index) {
	        nativeDefineProperty(that, index, {
	          get: function get() {
	            return getter(this, index);
	          },
	          set: function set(value) {
	            return setter(this, index, value);
	          },
	          enumerable: true
	        });
	      };

	      if (!NATIVE_ARRAY_BUFFER_VIEWS) {
	        TypedArrayConstructor = wrapper(function (that, data, offset, $length) {
	          anInstance(that, TypedArrayConstructor, CONSTRUCTOR_NAME);
	          var index = 0;
	          var byteOffset = 0;
	          var buffer, byteLength, length;

	          if (!isObject(data)) {
	            length = toIndex(data);
	            byteLength = length * BYTES;
	            buffer = new ArrayBuffer(byteLength);
	          } else if (isArrayBuffer(data)) {
	            buffer = data;
	            byteOffset = toOffset(offset, BYTES);
	            var $len = data.byteLength;

	            if ($length === undefined) {
	              if ($len % BYTES) throw RangeError(WRONG_LENGTH);
	              byteLength = $len - byteOffset;
	              if (byteLength < 0) throw RangeError(WRONG_LENGTH);
	            } else {
	              byteLength = toLength($length) * BYTES;
	              if (byteLength + byteOffset > $len) throw RangeError(WRONG_LENGTH);
	            }

	            length = byteLength / BYTES;
	          } else if (isTypedArray(data)) {
	            return fromList(TypedArrayConstructor, data);
	          } else {
	            return typedArrayFrom.call(TypedArrayConstructor, data);
	          }

	          setInternalState(that, {
	            buffer: buffer,
	            byteOffset: byteOffset,
	            byteLength: byteLength,
	            length: length,
	            view: new DataView(buffer)
	          });

	          while (index < length) {
	            addElement(that, index++);
	          }
	        });
	        if (objectSetPrototypeOf) objectSetPrototypeOf(TypedArrayConstructor, TypedArray);
	        TypedArrayConstructorPrototype = TypedArrayConstructor.prototype = objectCreate(TypedArrayPrototype);
	      } else if (typedArrayConstructorsRequireWrappers) {
	        TypedArrayConstructor = wrapper(function (dummy, data, typedArrayOffset, $length) {
	          anInstance(dummy, TypedArrayConstructor, CONSTRUCTOR_NAME);
	          return inheritIfRequired(function () {
	            if (!isObject(data)) return new NativeTypedArrayConstructor(toIndex(data));
	            if (isArrayBuffer(data)) return $length !== undefined ? new NativeTypedArrayConstructor(data, toOffset(typedArrayOffset, BYTES), $length) : typedArrayOffset !== undefined ? new NativeTypedArrayConstructor(data, toOffset(typedArrayOffset, BYTES)) : new NativeTypedArrayConstructor(data);
	            if (isTypedArray(data)) return fromList(TypedArrayConstructor, data);
	            return typedArrayFrom.call(TypedArrayConstructor, data);
	          }(), dummy, TypedArrayConstructor);
	        });
	        if (objectSetPrototypeOf) objectSetPrototypeOf(TypedArrayConstructor, TypedArray);
	        forEach(getOwnPropertyNames(NativeTypedArrayConstructor), function (key) {
	          if (!(key in TypedArrayConstructor)) {
	            createNonEnumerableProperty(TypedArrayConstructor, key, NativeTypedArrayConstructor[key]);
	          }
	        });
	        TypedArrayConstructor.prototype = TypedArrayConstructorPrototype;
	      }

	      if (TypedArrayConstructorPrototype.constructor !== TypedArrayConstructor) {
	        createNonEnumerableProperty(TypedArrayConstructorPrototype, 'constructor', TypedArrayConstructor);
	      }

	      if (TYPED_ARRAY_TAG) {
	        createNonEnumerableProperty(TypedArrayConstructorPrototype, TYPED_ARRAY_TAG, CONSTRUCTOR_NAME);
	      }

	      exported[CONSTRUCTOR_NAME] = TypedArrayConstructor;
	      _export({
	        global: true,
	        forced: TypedArrayConstructor != NativeTypedArrayConstructor,
	        sham: !NATIVE_ARRAY_BUFFER_VIEWS
	      }, exported);

	      if (!(BYTES_PER_ELEMENT in TypedArrayConstructor)) {
	        createNonEnumerableProperty(TypedArrayConstructor, BYTES_PER_ELEMENT, BYTES);
	      }

	      if (!(BYTES_PER_ELEMENT in TypedArrayConstructorPrototype)) {
	        createNonEnumerableProperty(TypedArrayConstructorPrototype, BYTES_PER_ELEMENT, BYTES);
	      }

	      setSpecies(CONSTRUCTOR_NAME);
	    };
	  } else module.exports = function () {
	    /* empty */
	  };
	});

	// https://tc39.github.io/ecma262/#sec-typedarray-objects

	typedArrayConstructor('Int8', function (init) {
	  return function Int8Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});
	var es_typedArray_int8Array = {};

	// https://tc39.github.io/ecma262/#sec-typedarray-objects

	typedArrayConstructor('Uint8', function (init) {
	  return function Uint8Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});
	var es_typedArray_uint8Array = {};

	// https://tc39.github.io/ecma262/#sec-typedarray-objects

	typedArrayConstructor('Uint8', function (init) {
	  return function Uint8ClampedArray(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	}, true);
	var es_typedArray_uint8ClampedArray = {};

	// https://tc39.github.io/ecma262/#sec-typedarray-objects

	typedArrayConstructor('Int16', function (init) {
	  return function Int16Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});
	var es_typedArray_int16Array = {};

	// https://tc39.github.io/ecma262/#sec-typedarray-objects

	typedArrayConstructor('Uint16', function (init) {
	  return function Uint16Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});
	var es_typedArray_uint16Array = {};

	// https://tc39.github.io/ecma262/#sec-typedarray-objects

	typedArrayConstructor('Int32', function (init) {
	  return function Int32Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});
	var es_typedArray_int32Array = {};

	// https://tc39.github.io/ecma262/#sec-typedarray-objects

	typedArrayConstructor('Uint32', function (init) {
	  return function Uint32Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});
	var es_typedArray_uint32Array = {};

	// https://tc39.github.io/ecma262/#sec-typedarray-objects

	typedArrayConstructor('Float32', function (init) {
	  return function Float32Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});
	var es_typedArray_float32Array = {};

	// https://tc39.github.io/ecma262/#sec-typedarray-objects

	typedArrayConstructor('Float64', function (init) {
	  return function Float64Array(data, byteOffset, length) {
	    return init(this, data, byteOffset, length);
	  };
	});
	var es_typedArray_float64Array = {};

	'use strict';

	var exportTypedArrayStaticMethod$1 = arrayBufferViewCore.exportTypedArrayStaticMethod; // `%TypedArray%.from` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.from

	exportTypedArrayStaticMethod$1('from', typedArrayFrom, typedArrayConstructorsRequireWrappers);
	var es_typedArray_from = {};

	'use strict';

	var aTypedArrayConstructor$2 = arrayBufferViewCore.aTypedArrayConstructor;
	var exportTypedArrayStaticMethod$2 = arrayBufferViewCore.exportTypedArrayStaticMethod; // `%TypedArray%.of` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.of

	exportTypedArrayStaticMethod$2('of', function of()
	/* ...items */
	{
	  var index = 0;
	  var length = arguments.length;
	  var result = new (aTypedArrayConstructor$2(this))(length);

	  while (length > index) {
	    result[index] = arguments[index++];
	  }

	  return result;
	}, typedArrayConstructorsRequireWrappers);
	var es_typedArray_of = {};

	'use strict';

	var aTypedArray$1 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$1 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.copyWithin` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.copywithin

	exportTypedArrayMethod$1('copyWithin', function copyWithin(target, start
	/* , end */
	) {
	  return arrayCopyWithin.call(aTypedArray$1(this), target, start, arguments.length > 2 ? arguments[2] : undefined);
	});
	var es_typedArray_copyWithin = {};

	'use strict';

	var $every$1 = arrayIteration.every;
	var aTypedArray$2 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$2 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.every` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.every

	exportTypedArrayMethod$2('every', function every(callbackfn
	/* , thisArg */
	) {
	  return $every$1(aTypedArray$2(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	});
	var es_typedArray_every = {};

	'use strict';

	var aTypedArray$3 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$3 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.fill` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.fill
	// eslint-disable-next-line no-unused-vars

	exportTypedArrayMethod$3('fill', function fill(value
	/* , start, end */
	) {
	  return arrayFill.apply(aTypedArray$3(this), arguments);
	});
	var es_typedArray_fill = {};

	'use strict';

	var $filter$1 = arrayIteration.filter;
	var aTypedArray$4 = arrayBufferViewCore.aTypedArray;
	var aTypedArrayConstructor$3 = arrayBufferViewCore.aTypedArrayConstructor;
	var exportTypedArrayMethod$4 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.filter` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.filter

	exportTypedArrayMethod$4('filter', function filter(callbackfn
	/* , thisArg */
	) {
	  var list = $filter$1(aTypedArray$4(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	  var C = speciesConstructor(this, this.constructor);
	  var index = 0;
	  var length = list.length;
	  var result = new (aTypedArrayConstructor$3(C))(length);

	  while (length > index) {
	    result[index] = list[index++];
	  }

	  return result;
	});
	var es_typedArray_filter = {};

	'use strict';

	var $find$1 = arrayIteration.find;
	var aTypedArray$5 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$5 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.find` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.find

	exportTypedArrayMethod$5('find', function find(predicate
	/* , thisArg */
	) {
	  return $find$1(aTypedArray$5(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
	});
	var es_typedArray_find = {};

	'use strict';

	var $findIndex$1 = arrayIteration.findIndex;
	var aTypedArray$6 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$6 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.findIndex` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.findindex

	exportTypedArrayMethod$6('findIndex', function findIndex(predicate
	/* , thisArg */
	) {
	  return $findIndex$1(aTypedArray$6(this), predicate, arguments.length > 1 ? arguments[1] : undefined);
	});
	var es_typedArray_findIndex = {};

	'use strict';

	var $forEach$2 = arrayIteration.forEach;
	var aTypedArray$7 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$7 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.forEach` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.foreach

	exportTypedArrayMethod$7('forEach', function forEach(callbackfn
	/* , thisArg */
	) {
	  $forEach$2(aTypedArray$7(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	});
	var es_typedArray_forEach = {};

	'use strict';

	var $includes$1 = arrayIncludes.includes;
	var aTypedArray$8 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$8 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.includes` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.includes

	exportTypedArrayMethod$8('includes', function includes(searchElement
	/* , fromIndex */
	) {
	  return $includes$1(aTypedArray$8(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
	});
	var es_typedArray_includes = {};

	'use strict';

	var $indexOf$1 = arrayIncludes.indexOf;
	var aTypedArray$9 = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$9 = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.indexOf` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.indexof

	exportTypedArrayMethod$9('indexOf', function indexOf(searchElement
	/* , fromIndex */
	) {
	  return $indexOf$1(aTypedArray$9(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);
	});
	var es_typedArray_indexOf = {};

	'use strict';

	var ITERATOR$5 = wellKnownSymbol('iterator');
	var Uint8Array$1 = global_1.Uint8Array;
	var arrayValues = es_array_iterator.values;
	var arrayKeys = es_array_iterator.keys;
	var arrayEntries = es_array_iterator.entries;
	var aTypedArray$a = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$a = arrayBufferViewCore.exportTypedArrayMethod;
	var nativeTypedArrayIterator = Uint8Array$1 && Uint8Array$1.prototype[ITERATOR$5];
	var CORRECT_ITER_NAME = !!nativeTypedArrayIterator && (nativeTypedArrayIterator.name == 'values' || nativeTypedArrayIterator.name == undefined);

	var typedArrayValues = function values() {
	  return arrayValues.call(aTypedArray$a(this));
	}; // `%TypedArray%.prototype.entries` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.entries


	exportTypedArrayMethod$a('entries', function entries() {
	  return arrayEntries.call(aTypedArray$a(this));
	}); // `%TypedArray%.prototype.keys` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.keys

	exportTypedArrayMethod$a('keys', function keys() {
	  return arrayKeys.call(aTypedArray$a(this));
	}); // `%TypedArray%.prototype.values` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.values

	exportTypedArrayMethod$a('values', typedArrayValues, !CORRECT_ITER_NAME); // `%TypedArray%.prototype[@@iterator]` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype-@@iterator

	exportTypedArrayMethod$a(ITERATOR$5, typedArrayValues, !CORRECT_ITER_NAME);
	var es_typedArray_iterator = {};

	'use strict';

	var aTypedArray$b = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$b = arrayBufferViewCore.exportTypedArrayMethod;
	var $join = [].join; // `%TypedArray%.prototype.join` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.join
	// eslint-disable-next-line no-unused-vars

	exportTypedArrayMethod$b('join', function join(separator) {
	  return $join.apply(aTypedArray$b(this), arguments);
	});
	var es_typedArray_join = {};

	'use strict';

	var aTypedArray$c = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$c = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.lastIndexOf` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.lastindexof
	// eslint-disable-next-line no-unused-vars

	exportTypedArrayMethod$c('lastIndexOf', function lastIndexOf(searchElement
	/* , fromIndex */
	) {
	  return arrayLastIndexOf.apply(aTypedArray$c(this), arguments);
	});
	var es_typedArray_lastIndexOf = {};

	'use strict';

	var $map$1 = arrayIteration.map;
	var aTypedArray$d = arrayBufferViewCore.aTypedArray;
	var aTypedArrayConstructor$4 = arrayBufferViewCore.aTypedArrayConstructor;
	var exportTypedArrayMethod$d = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.map` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.map

	exportTypedArrayMethod$d('map', function map(mapfn
	/* , thisArg */
	) {
	  return $map$1(aTypedArray$d(this), mapfn, arguments.length > 1 ? arguments[1] : undefined, function (O, length) {
	    return new (aTypedArrayConstructor$4(speciesConstructor(O, O.constructor)))(length);
	  });
	});
	var es_typedArray_map = {};

	'use strict';

	var $reduce$1 = arrayReduce.left;
	var aTypedArray$e = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$e = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.reduce` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.reduce

	exportTypedArrayMethod$e('reduce', function reduce(callbackfn
	/* , initialValue */
	) {
	  return $reduce$1(aTypedArray$e(this), callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
	});
	var es_typedArray_reduce = {};

	'use strict';

	var $reduceRight$1 = arrayReduce.right;
	var aTypedArray$f = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$f = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.reduceRicht` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.reduceright

	exportTypedArrayMethod$f('reduceRight', function reduceRight(callbackfn
	/* , initialValue */
	) {
	  return $reduceRight$1(aTypedArray$f(this), callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : undefined);
	});
	var es_typedArray_reduceRight = {};

	'use strict';

	var aTypedArray$g = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$g = arrayBufferViewCore.exportTypedArrayMethod;
	var floor$7 = Math.floor; // `%TypedArray%.prototype.reverse` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.reverse

	exportTypedArrayMethod$g('reverse', function reverse() {
	  var that = this;
	  var length = aTypedArray$g(that).length;
	  var middle = floor$7(length / 2);
	  var index = 0;
	  var value;

	  while (index < middle) {
	    value = that[index];
	    that[index++] = that[--length];
	    that[length] = value;
	  }

	  return that;
	});
	var es_typedArray_reverse = {};

	'use strict';

	var aTypedArray$h = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$h = arrayBufferViewCore.exportTypedArrayMethod;
	var FORCED$h = fails(function () {
	  // eslint-disable-next-line no-undef
	  new Int8Array(1).set({});
	}); // `%TypedArray%.prototype.set` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.set

	exportTypedArrayMethod$h('set', function set(arrayLike
	/* , offset */
	) {
	  aTypedArray$h(this);
	  var offset = toOffset(arguments.length > 1 ? arguments[1] : undefined, 1);
	  var length = this.length;
	  var src = toObject(arrayLike);
	  var len = toLength(src.length);
	  var index = 0;
	  if (len + offset > length) throw RangeError('Wrong length');

	  while (index < len) {
	    this[offset + index] = src[index++];
	  }
	}, FORCED$h);
	var es_typedArray_set = {};

	'use strict';

	var aTypedArray$i = arrayBufferViewCore.aTypedArray;
	var aTypedArrayConstructor$5 = arrayBufferViewCore.aTypedArrayConstructor;
	var exportTypedArrayMethod$i = arrayBufferViewCore.exportTypedArrayMethod;
	var $slice = [].slice;
	var FORCED$i = fails(function () {
	  // eslint-disable-next-line no-undef
	  new Int8Array(1).slice();
	}); // `%TypedArray%.prototype.slice` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.slice

	exportTypedArrayMethod$i('slice', function slice(start, end) {
	  var list = $slice.call(aTypedArray$i(this), start, end);
	  var C = speciesConstructor(this, this.constructor);
	  var index = 0;
	  var length = list.length;
	  var result = new (aTypedArrayConstructor$5(C))(length);

	  while (length > index) {
	    result[index] = list[index++];
	  }

	  return result;
	}, FORCED$i);
	var es_typedArray_slice = {};

	'use strict';

	var $some$1 = arrayIteration.some;
	var aTypedArray$j = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$j = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.some` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.some

	exportTypedArrayMethod$j('some', function some(callbackfn
	/* , thisArg */
	) {
	  return $some$1(aTypedArray$j(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);
	});
	var es_typedArray_some = {};

	'use strict';

	var aTypedArray$k = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$k = arrayBufferViewCore.exportTypedArrayMethod;
	var $sort = [].sort; // `%TypedArray%.prototype.sort` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.sort

	exportTypedArrayMethod$k('sort', function sort(comparefn) {
	  return $sort.call(aTypedArray$k(this), comparefn);
	});
	var es_typedArray_sort = {};

	'use strict';

	var aTypedArray$l = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$l = arrayBufferViewCore.exportTypedArrayMethod; // `%TypedArray%.prototype.subarray` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.subarray

	exportTypedArrayMethod$l('subarray', function subarray(begin, end) {
	  var O = aTypedArray$l(this);
	  var length = O.length;
	  var beginIndex = toAbsoluteIndex(begin, length);
	  return new (speciesConstructor(O, O.constructor))(O.buffer, O.byteOffset + beginIndex * O.BYTES_PER_ELEMENT, toLength((end === undefined ? length : toAbsoluteIndex(end, length)) - beginIndex));
	});
	var es_typedArray_subarray = {};

	'use strict';

	var Int8Array$3 = global_1.Int8Array;
	var aTypedArray$m = arrayBufferViewCore.aTypedArray;
	var exportTypedArrayMethod$m = arrayBufferViewCore.exportTypedArrayMethod;
	var $toLocaleString = [].toLocaleString;
	var $slice$1 = [].slice; // iOS Safari 6.x fails here

	var TO_LOCALE_STRING_BUG = !!Int8Array$3 && fails(function () {
	  $toLocaleString.call(new Int8Array$3(1));
	});
	var FORCED$j = fails(function () {
	  return [1, 2].toLocaleString() != new Int8Array$3([1, 2]).toLocaleString();
	}) || !fails(function () {
	  Int8Array$3.prototype.toLocaleString.call([1, 2]);
	}); // `%TypedArray%.prototype.toLocaleString` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.tolocalestring

	exportTypedArrayMethod$m('toLocaleString', function toLocaleString() {
	  return $toLocaleString.apply(TO_LOCALE_STRING_BUG ? $slice$1.call(aTypedArray$m(this)) : aTypedArray$m(this), arguments);
	}, FORCED$j);
	var es_typedArray_toLocaleString = {};

	'use strict';

	var exportTypedArrayMethod$n = arrayBufferViewCore.exportTypedArrayMethod;
	var Uint8Array$2 = global_1.Uint8Array;
	var Uint8ArrayPrototype = Uint8Array$2 && Uint8Array$2.prototype || {};
	var arrayToString = [].toString;
	var arrayJoin = [].join;

	if (fails(function () {
	  arrayToString.call({});
	})) {
	  arrayToString = function toString() {
	    return arrayJoin.call(this);
	  };
	}

	var IS_NOT_ARRAY_METHOD = Uint8ArrayPrototype.toString != arrayToString; // `%TypedArray%.prototype.toString` method
	// https://tc39.github.io/ecma262/#sec-%typedarray%.prototype.tostring

	exportTypedArrayMethod$n('toString', arrayToString, IS_NOT_ARRAY_METHOD);
	var es_typedArray_toString = {};

	var nativeApply = getBuiltIn('Reflect', 'apply');
	var functionApply = Function.apply; // MS Edge argumentsList argument is optional

	var OPTIONAL_ARGUMENTS_LIST = !fails(function () {
	  nativeApply(function () {
	    /* empty */
	  });
	}); // `Reflect.apply` method
	// https://tc39.github.io/ecma262/#sec-reflect.apply

	_export({
	  target: 'Reflect',
	  stat: true,
	  forced: OPTIONAL_ARGUMENTS_LIST
	}, {
	  apply: function apply(target, thisArgument, argumentsList) {
	    aFunction$1(target);
	    anObject(argumentsList);
	    return nativeApply ? nativeApply(target, thisArgument, argumentsList) : functionApply.call(target, thisArgument, argumentsList);
	  }
	});
	var es_reflect_apply = {};

	var nativeConstruct = getBuiltIn('Reflect', 'construct'); // `Reflect.construct` method
	// https://tc39.github.io/ecma262/#sec-reflect.construct
	// MS Edge supports only 2 arguments and argumentsList argument is optional
	// FF Nightly sets third argument as `new.target`, but does not create `this` from it

	var NEW_TARGET_BUG = fails(function () {
	  function F() {
	    /* empty */
	  }

	  return !(nativeConstruct(function () {
	    /* empty */
	  }, [], F) instanceof F);
	});
	var ARGS_BUG = !fails(function () {
	  nativeConstruct(function () {
	    /* empty */
	  });
	});
	var FORCED$k = NEW_TARGET_BUG || ARGS_BUG;
	_export({
	  target: 'Reflect',
	  stat: true,
	  forced: FORCED$k,
	  sham: FORCED$k
	}, {
	  construct: function construct(Target, args
	  /* , newTarget */
	  ) {
	    aFunction$1(Target);
	    anObject(args);
	    var newTarget = arguments.length < 3 ? Target : aFunction$1(arguments[2]);
	    if (ARGS_BUG && !NEW_TARGET_BUG) return nativeConstruct(Target, args, newTarget);

	    if (Target == newTarget) {
	      // w/o altered newTarget, optimization for 0-4 arguments
	      switch (args.length) {
	        case 0:
	          return new Target();

	        case 1:
	          return new Target(args[0]);

	        case 2:
	          return new Target(args[0], args[1]);

	        case 3:
	          return new Target(args[0], args[1], args[2]);

	        case 4:
	          return new Target(args[0], args[1], args[2], args[3]);
	      } // w/o altered newTarget, lot of arguments case


	      var $args = [null];
	      $args.push.apply($args, args);
	      return new (functionBind.apply(Target, $args))();
	    } // with altered newTarget, not support built-in constructors


	    var proto = newTarget.prototype;
	    var instance = objectCreate(isObject(proto) ? proto : Object.prototype);
	    var result = Function.apply.call(Target, instance, args);
	    return isObject(result) ? result : instance;
	  }
	});
	var es_reflect_construct = {};

	var ERROR_INSTEAD_OF_FALSE = fails(function () {
	  // eslint-disable-next-line no-undef
	  Reflect.defineProperty(objectDefineProperty.f({}, 1, {
	    value: 1
	  }), 1, {
	    value: 2
	  });
	}); // `Reflect.defineProperty` method
	// https://tc39.github.io/ecma262/#sec-reflect.defineproperty

	_export({
	  target: 'Reflect',
	  stat: true,
	  forced: ERROR_INSTEAD_OF_FALSE,
	  sham: !descriptors
	}, {
	  defineProperty: function defineProperty(target, propertyKey, attributes) {
	    anObject(target);
	    var key = toPrimitive(propertyKey, true);
	    anObject(attributes);

	    try {
	      objectDefineProperty.f(target, key, attributes);
	      return true;
	    } catch (error) {
	      return false;
	    }
	  }
	});
	var es_reflect_defineProperty = {};

	var getOwnPropertyDescriptor$8 = objectGetOwnPropertyDescriptor.f; // `Reflect.deleteProperty` method
	// https://tc39.github.io/ecma262/#sec-reflect.deleteproperty

	_export({
	  target: 'Reflect',
	  stat: true
	}, {
	  deleteProperty: function deleteProperty(target, propertyKey) {
	    var descriptor = getOwnPropertyDescriptor$8(anObject(target), propertyKey);
	    return descriptor && !descriptor.configurable ? false : delete target[propertyKey];
	  }
	});
	var es_reflect_deleteProperty = {};

	// https://tc39.github.io/ecma262/#sec-reflect.get

	function get$2(target, propertyKey
	/* , receiver */
	) {
	  var receiver = arguments.length < 3 ? target : arguments[2];
	  var descriptor, prototype;
	  if (anObject(target) === receiver) return target[propertyKey];
	  if (descriptor = objectGetOwnPropertyDescriptor.f(target, propertyKey)) return has(descriptor, 'value') ? descriptor.value : descriptor.get === undefined ? undefined : descriptor.get.call(receiver);
	  if (isObject(prototype = objectGetPrototypeOf(target))) return get$2(prototype, propertyKey, receiver);
	}

	_export({
	  target: 'Reflect',
	  stat: true
	}, {
	  get: get$2
	});
	var es_reflect_get = {};

	// https://tc39.github.io/ecma262/#sec-reflect.getownpropertydescriptor

	_export({
	  target: 'Reflect',
	  stat: true,
	  sham: !descriptors
	}, {
	  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(target, propertyKey) {
	    return objectGetOwnPropertyDescriptor.f(anObject(target), propertyKey);
	  }
	});
	var es_reflect_getOwnPropertyDescriptor = {};

	// https://tc39.github.io/ecma262/#sec-reflect.getprototypeof

	_export({
	  target: 'Reflect',
	  stat: true,
	  sham: !correctPrototypeGetter
	}, {
	  getPrototypeOf: function getPrototypeOf(target) {
	    return objectGetPrototypeOf(anObject(target));
	  }
	});
	var es_reflect_getPrototypeOf = {};

	// https://tc39.github.io/ecma262/#sec-reflect.has

	_export({
	  target: 'Reflect',
	  stat: true
	}, {
	  has: function has(target, propertyKey) {
	    return propertyKey in target;
	  }
	});
	var es_reflect_has = {};

	var objectIsExtensible = Object.isExtensible; // `Reflect.isExtensible` method
	// https://tc39.github.io/ecma262/#sec-reflect.isextensible

	_export({
	  target: 'Reflect',
	  stat: true
	}, {
	  isExtensible: function isExtensible(target) {
	    anObject(target);
	    return objectIsExtensible ? objectIsExtensible(target) : true;
	  }
	});
	var es_reflect_isExtensible = {};

	// https://tc39.github.io/ecma262/#sec-reflect.ownkeys

	_export({
	  target: 'Reflect',
	  stat: true
	}, {
	  ownKeys: ownKeys
	});
	var es_reflect_ownKeys = {};

	// https://tc39.github.io/ecma262/#sec-reflect.preventextensions

	_export({
	  target: 'Reflect',
	  stat: true,
	  sham: !freezing
	}, {
	  preventExtensions: function preventExtensions(target) {
	    anObject(target);

	    try {
	      var objectPreventExtensions = getBuiltIn('Object', 'preventExtensions');
	      if (objectPreventExtensions) objectPreventExtensions(target);
	      return true;
	    } catch (error) {
	      return false;
	    }
	  }
	});
	var es_reflect_preventExtensions = {};

	// https://tc39.github.io/ecma262/#sec-reflect.set

	function set$3(target, propertyKey, V
	/* , receiver */
	) {
	  var receiver = arguments.length < 4 ? target : arguments[3];
	  var ownDescriptor = objectGetOwnPropertyDescriptor.f(anObject(target), propertyKey);
	  var existingDescriptor, prototype;

	  if (!ownDescriptor) {
	    if (isObject(prototype = objectGetPrototypeOf(target))) {
	      return set$3(prototype, propertyKey, V, receiver);
	    }

	    ownDescriptor = createPropertyDescriptor(0);
	  }

	  if (has(ownDescriptor, 'value')) {
	    if (ownDescriptor.writable === false || !isObject(receiver)) return false;

	    if (existingDescriptor = objectGetOwnPropertyDescriptor.f(receiver, propertyKey)) {
	      if (existingDescriptor.get || existingDescriptor.set || existingDescriptor.writable === false) return false;
	      existingDescriptor.value = V;
	      objectDefineProperty.f(receiver, propertyKey, existingDescriptor);
	    } else objectDefineProperty.f(receiver, propertyKey, createPropertyDescriptor(0, V));

	    return true;
	  }

	  return ownDescriptor.set === undefined ? false : (ownDescriptor.set.call(receiver, V), true);
	} // MS Edge 17-18 Reflect.set allows setting the property to object
	// with non-writable property on the prototype


	var MS_EDGE_BUG = fails(function () {
	  var object = objectDefineProperty.f({}, 'a', {
	    configurable: true
	  }); // eslint-disable-next-line no-undef

	  return Reflect.set(objectGetPrototypeOf(object), 'a', 1, object) !== false;
	});
	_export({
	  target: 'Reflect',
	  stat: true,
	  forced: MS_EDGE_BUG
	}, {
	  set: set$3
	});
	var es_reflect_set = {};

	// https://tc39.github.io/ecma262/#sec-reflect.setprototypeof

	if (objectSetPrototypeOf) _export({
	  target: 'Reflect',
	  stat: true
	}, {
	  setPrototypeOf: function setPrototypeOf(target, proto) {
	    anObject(target);
	    aPossiblePrototype(proto);

	    try {
	      objectSetPrototypeOf(target, proto);
	      return true;
	    } catch (error) {
	      return false;
	    }
	  }
	});
	var es_reflect_setPrototypeOf = {};

	var es = path;

	// iterable DOM collections
	// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
	var domIterables = {
	  CSSRuleList: 0,
	  CSSStyleDeclaration: 0,
	  CSSValueList: 0,
	  ClientRectList: 0,
	  DOMRectList: 0,
	  DOMStringList: 0,
	  DOMTokenList: 1,
	  DataTransferItemList: 0,
	  FileList: 0,
	  HTMLAllCollection: 0,
	  HTMLCollection: 0,
	  HTMLFormElement: 0,
	  HTMLSelectElement: 0,
	  MediaList: 0,
	  MimeTypeArray: 0,
	  NamedNodeMap: 0,
	  NodeList: 1,
	  PaintRequestList: 0,
	  Plugin: 0,
	  PluginArray: 0,
	  SVGLengthList: 0,
	  SVGNumberList: 0,
	  SVGPathSegList: 0,
	  SVGPointList: 0,
	  SVGStringList: 0,
	  SVGTransformList: 0,
	  SourceBufferList: 0,
	  StyleSheetList: 0,
	  TextTrackCueList: 0,
	  TextTrackList: 0,
	  TouchList: 0
	};
	var domIterables_1 = domIterables.CSSRuleList;
	var domIterables_2 = domIterables.CSSStyleDeclaration;
	var domIterables_3 = domIterables.CSSValueList;
	var domIterables_4 = domIterables.ClientRectList;
	var domIterables_5 = domIterables.DOMRectList;
	var domIterables_6 = domIterables.DOMStringList;
	var domIterables_7 = domIterables.DOMTokenList;
	var domIterables_8 = domIterables.DataTransferItemList;
	var domIterables_9 = domIterables.FileList;
	var domIterables_10 = domIterables.HTMLAllCollection;
	var domIterables_11 = domIterables.HTMLCollection;
	var domIterables_12 = domIterables.HTMLFormElement;
	var domIterables_13 = domIterables.HTMLSelectElement;
	var domIterables_14 = domIterables.MediaList;
	var domIterables_15 = domIterables.MimeTypeArray;
	var domIterables_16 = domIterables.NamedNodeMap;
	var domIterables_17 = domIterables.NodeList;
	var domIterables_18 = domIterables.PaintRequestList;
	var domIterables_19 = domIterables.Plugin;
	var domIterables_20 = domIterables.PluginArray;
	var domIterables_21 = domIterables.SVGLengthList;
	var domIterables_22 = domIterables.SVGNumberList;
	var domIterables_23 = domIterables.SVGPathSegList;
	var domIterables_24 = domIterables.SVGPointList;
	var domIterables_25 = domIterables.SVGStringList;
	var domIterables_26 = domIterables.SVGTransformList;
	var domIterables_27 = domIterables.SourceBufferList;
	var domIterables_28 = domIterables.StyleSheetList;
	var domIterables_29 = domIterables.TextTrackCueList;
	var domIterables_30 = domIterables.TextTrackList;
	var domIterables_31 = domIterables.TouchList;

	for (var COLLECTION_NAME in domIterables) {
	  var Collection = global_1[COLLECTION_NAME];
	  var CollectionPrototype = Collection && Collection.prototype; // some Chrome versions have non-configurable methods on DOMTokenList

	  if (CollectionPrototype && CollectionPrototype.forEach !== arrayForEach) try {
	    createNonEnumerableProperty(CollectionPrototype, 'forEach', arrayForEach);
	  } catch (error) {
	    CollectionPrototype.forEach = arrayForEach;
	  }
	}

	var web_domCollections_forEach = {};

	var ITERATOR$6 = wellKnownSymbol('iterator');
	var TO_STRING_TAG$4 = wellKnownSymbol('toStringTag');
	var ArrayValues = es_array_iterator.values;

	for (var COLLECTION_NAME$1 in domIterables) {
	  var Collection$1 = global_1[COLLECTION_NAME$1];
	  var CollectionPrototype$1 = Collection$1 && Collection$1.prototype;

	  if (CollectionPrototype$1) {
	    // some Chrome versions have non-configurable methods on DOMTokenList
	    if (CollectionPrototype$1[ITERATOR$6] !== ArrayValues) try {
	      createNonEnumerableProperty(CollectionPrototype$1, ITERATOR$6, ArrayValues);
	    } catch (error) {
	      CollectionPrototype$1[ITERATOR$6] = ArrayValues;
	    }

	    if (!CollectionPrototype$1[TO_STRING_TAG$4]) {
	      createNonEnumerableProperty(CollectionPrototype$1, TO_STRING_TAG$4, COLLECTION_NAME$1);
	    }

	    if (domIterables[COLLECTION_NAME$1]) for (var METHOD_NAME in es_array_iterator) {
	      // some Chrome versions have non-configurable methods on DOMTokenList
	      if (CollectionPrototype$1[METHOD_NAME] !== es_array_iterator[METHOD_NAME]) try {
	        createNonEnumerableProperty(CollectionPrototype$1, METHOD_NAME, es_array_iterator[METHOD_NAME]);
	      } catch (error) {
	        CollectionPrototype$1[METHOD_NAME] = es_array_iterator[METHOD_NAME];
	      }
	    }
	  }
	}

	var web_domCollections_iterator = {};

	var FORCED$l = !global_1.setImmediate || !global_1.clearImmediate; // http://w3c.github.io/setImmediate/

	_export({
	  global: true,
	  bind: true,
	  enumerable: true,
	  forced: FORCED$l
	}, {
	  // `setImmediate` method
	  // http://w3c.github.io/setImmediate/#si-setImmediate
	  setImmediate: task.set,
	  // `clearImmediate` method
	  // http://w3c.github.io/setImmediate/#si-clearImmediate
	  clearImmediate: task.clear
	});
	var web_immediate = {};

	var process$5 = global_1.process;
	var isNode = classofRaw(process$5) == 'process'; // `queueMicrotask` method
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-queuemicrotask

	_export({
	  global: true,
	  enumerable: true,
	  noTargetGet: true
	}, {
	  queueMicrotask: function queueMicrotask(fn) {
	    var domain = isNode && process$5.domain;
	    microtask(domain ? domain.bind(fn) : fn);
	  }
	});
	var web_queueMicrotask = {};

	var slice$1 = [].slice;
	var MSIE = /MSIE .\./.test(engineUserAgent); // <- dirty ie9- check

	var wrap$1 = function wrap(scheduler) {
	  return function (handler, timeout
	  /* , ...arguments */
	  ) {
	    var boundArgs = arguments.length > 2;
	    var args = boundArgs ? slice$1.call(arguments, 2) : undefined;
	    return scheduler(boundArgs ? function () {
	      // eslint-disable-next-line no-new-func
	      (typeof handler == 'function' ? handler : Function(handler)).apply(this, args);
	    } : handler, timeout);
	  };
	}; // ie9- setTimeout & setInterval additional parameters fix
	// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#timers


	_export({
	  global: true,
	  bind: true,
	  forced: MSIE
	}, {
	  // `setTimeout` method
	  // https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-settimeout
	  setTimeout: wrap$1(global_1.setTimeout),
	  // `setInterval` method
	  // https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-setinterval
	  setInterval: wrap$1(global_1.setInterval)
	});
	var web_timers = {};

	var ITERATOR$7 = wellKnownSymbol('iterator');
	var nativeUrl = !fails(function () {
	  var url = new URL('b?a=1&b=2&c=3', 'http://a');
	  var searchParams = url.searchParams;
	  var result = '';
	  url.pathname = 'c%20d';
	  searchParams.forEach(function (value, key) {
	    searchParams['delete']('b');
	    result += key + value;
	  });
	  return isPure && !url.toJSON || !searchParams.sort || url.href !== 'http://a/c%20d?a=1&c=3' || searchParams.get('c') !== '3' || String(new URLSearchParams('?a=1')) !== 'a=1' || !searchParams[ITERATOR$7] // throws in Edge
	  || new URL('https://a@b').username !== 'a' || new URLSearchParams(new URLSearchParams('a=b')).get('a') !== 'b' // not punycoded in Edge
	  || new URL('http://тест').host !== 'xn--e1aybc' // not escaped in Chrome 62-
	  || new URL('http://a#б').hash !== '#%D0%B1' // fails in Chrome 66-
	  || result !== 'a1c3' // throws in Safari
	  || new URL('http://x', undefined).host !== 'x';
	});

	'use strict'; // based on https://github.com/bestiejs/punycode.js/blob/master/punycode.js

	var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1

	var base = 36;
	var tMin = 1;
	var tMax = 26;
	var skew = 38;
	var damp = 700;
	var initialBias = 72;
	var initialN = 128; // 0x80

	var delimiter = '-'; // '\x2D'

	var regexNonASCII = /[^\0-\u007E]/; // non-ASCII chars

	var regexSeparators = /[.\u3002\uFF0E\uFF61]/g; // RFC 3490 separators

	var OVERFLOW_ERROR = 'Overflow: input needs wider integers to process';
	var baseMinusTMin = base - tMin;
	var floor$8 = Math.floor;
	var stringFromCharCode = String.fromCharCode;
	/**
	 * Creates an array containing the numeric code points of each Unicode
	 * character in the string. While JavaScript uses UCS-2 internally,
	 * this function will convert a pair of surrogate halves (each of which
	 * UCS-2 exposes as separate characters) into a single code point,
	 * matching UTF-16.
	 */

	var ucs2decode = function ucs2decode(string) {
	  var output = [];
	  var counter = 0;
	  var length = string.length;

	  while (counter < length) {
	    var value = string.charCodeAt(counter++);

	    if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
	      // It's a high surrogate, and there is a next character.
	      var extra = string.charCodeAt(counter++);

	      if ((extra & 0xFC00) == 0xDC00) {
	        // Low surrogate.
	        output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
	      } else {
	        // It's an unmatched surrogate; only append this code unit, in case the
	        // next code unit is the high surrogate of a surrogate pair.
	        output.push(value);
	        counter--;
	      }
	    } else {
	      output.push(value);
	    }
	  }

	  return output;
	};
	/**
	 * Converts a digit/integer into a basic code point.
	 */


	var digitToBasic = function digitToBasic(digit) {
	  //  0..25 map to ASCII a..z or A..Z
	  // 26..35 map to ASCII 0..9
	  return digit + 22 + 75 * (digit < 26);
	};
	/**
	 * Bias adaptation function as per section 3.4 of RFC 3492.
	 * https://tools.ietf.org/html/rfc3492#section-3.4
	 */


	var adapt = function adapt(delta, numPoints, firstTime) {
	  var k = 0;
	  delta = firstTime ? floor$8(delta / damp) : delta >> 1;
	  delta += floor$8(delta / numPoints);

	  for (; delta > baseMinusTMin * tMax >> 1; k += base) {
	    delta = floor$8(delta / baseMinusTMin);
	  }

	  return floor$8(k + (baseMinusTMin + 1) * delta / (delta + skew));
	};
	/**
	 * Converts a string of Unicode symbols (e.g. a domain name label) to a
	 * Punycode string of ASCII-only symbols.
	 */
	// eslint-disable-next-line  max-statements


	var encode = function encode(input) {
	  var output = []; // Convert the input in UCS-2 to an array of Unicode code points.

	  input = ucs2decode(input); // Cache the length.

	  var inputLength = input.length; // Initialize the state.

	  var n = initialN;
	  var delta = 0;
	  var bias = initialBias;
	  var i, currentValue; // Handle the basic code points.

	  for (i = 0; i < input.length; i++) {
	    currentValue = input[i];

	    if (currentValue < 0x80) {
	      output.push(stringFromCharCode(currentValue));
	    }
	  }

	  var basicLength = output.length; // number of basic code points.

	  var handledCPCount = basicLength; // number of code points that have been handled;
	  // Finish the basic string with a delimiter unless it's empty.

	  if (basicLength) {
	    output.push(delimiter);
	  } // Main encoding loop:


	  while (handledCPCount < inputLength) {
	    // All non-basic code points < n have been handled already. Find the next larger one:
	    var m = maxInt;

	    for (i = 0; i < input.length; i++) {
	      currentValue = input[i];

	      if (currentValue >= n && currentValue < m) {
	        m = currentValue;
	      }
	    } // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>, but guard against overflow.


	    var handledCPCountPlusOne = handledCPCount + 1;

	    if (m - n > floor$8((maxInt - delta) / handledCPCountPlusOne)) {
	      throw RangeError(OVERFLOW_ERROR);
	    }

	    delta += (m - n) * handledCPCountPlusOne;
	    n = m;

	    for (i = 0; i < input.length; i++) {
	      currentValue = input[i];

	      if (currentValue < n && ++delta > maxInt) {
	        throw RangeError(OVERFLOW_ERROR);
	      }

	      if (currentValue == n) {
	        // Represent delta as a generalized variable-length integer.
	        var q = delta;

	        for (var k = base;;
	        /* no condition */
	        k += base) {
	          var t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
	          if (q < t) break;
	          var qMinusT = q - t;
	          var baseMinusT = base - t;
	          output.push(stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT)));
	          q = floor$8(qMinusT / baseMinusT);
	        }

	        output.push(stringFromCharCode(digitToBasic(q)));
	        bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
	        delta = 0;
	        ++handledCPCount;
	      }
	    }

	    ++delta;
	    ++n;
	  }

	  return output.join('');
	};

	var stringPunycodeToAscii = function stringPunycodeToAscii(input) {
	  var encoded = [];
	  var labels = input.toLowerCase().replace(regexSeparators, ".").split('.');
	  var i, label;

	  for (i = 0; i < labels.length; i++) {
	    label = labels[i];
	    encoded.push(regexNonASCII.test(label) ? 'xn--' + encode(label) : label);
	  }

	  return encoded.join('.');
	};

	var getIterator = function getIterator(it) {
	  var iteratorMethod = getIteratorMethod(it);

	  if (typeof iteratorMethod != 'function') {
	    throw TypeError(String(it) + ' is not iterable');
	  }

	  return anObject(iteratorMethod.call(it));
	};

	'use strict'; // TODO: in core-js@4, move /modules/ dependencies to public entries for better optimization by tools like `preset-env`


	var $fetch$1 = getBuiltIn('fetch');
	var Headers = getBuiltIn('Headers');
	var ITERATOR$8 = wellKnownSymbol('iterator');
	var URL_SEARCH_PARAMS = 'URLSearchParams';
	var URL_SEARCH_PARAMS_ITERATOR = URL_SEARCH_PARAMS + 'Iterator';
	var setInternalState$9 = internalState.set;
	var getInternalParamsState = internalState.getterFor(URL_SEARCH_PARAMS);
	var getInternalIteratorState = internalState.getterFor(URL_SEARCH_PARAMS_ITERATOR);
	var plus = /\+/g;
	var sequences = Array(4);

	var percentSequence = function percentSequence(bytes) {
	  return sequences[bytes - 1] || (sequences[bytes - 1] = RegExp('((?:%[\\da-f]{2}){' + bytes + '})', 'gi'));
	};

	var percentDecode = function percentDecode(sequence) {
	  try {
	    return decodeURIComponent(sequence);
	  } catch (error) {
	    return sequence;
	  }
	};

	var deserialize = function deserialize(it) {
	  var result = it.replace(plus, ' ');
	  var bytes = 4;

	  try {
	    return decodeURIComponent(result);
	  } catch (error) {
	    while (bytes) {
	      result = result.replace(percentSequence(bytes--), percentDecode);
	    }

	    return result;
	  }
	};

	var find$1 = /[!'()~]|%20/g;
	var replace = {
	  '!': '%21',
	  "'": '%27',
	  '(': '%28',
	  ')': '%29',
	  '~': '%7E',
	  '%20': '+'
	};

	var replacer = function replacer(match) {
	  return replace[match];
	};

	var serialize = function serialize(it) {
	  return encodeURIComponent(it).replace(find$1, replacer);
	};

	var parseSearchParams = function parseSearchParams(result, query) {
	  if (query) {
	    var attributes = query.split('&');
	    var index = 0;
	    var attribute, entry;

	    while (index < attributes.length) {
	      attribute = attributes[index++];

	      if (attribute.length) {
	        entry = attribute.split('=');
	        result.push({
	          key: deserialize(entry.shift()),
	          value: deserialize(entry.join('='))
	        });
	      }
	    }
	  }
	};

	var updateSearchParams = function updateSearchParams(query) {
	  this.entries.length = 0;
	  parseSearchParams(this.entries, query);
	};

	var validateArgumentsLength = function validateArgumentsLength(passed, required) {
	  if (passed < required) throw TypeError('Not enough arguments');
	};

	var URLSearchParamsIterator = createIteratorConstructor(function Iterator(params, kind) {
	  setInternalState$9(this, {
	    type: URL_SEARCH_PARAMS_ITERATOR,
	    iterator: getIterator(getInternalParamsState(params).entries),
	    kind: kind
	  });
	}, 'Iterator', function next() {
	  var state = getInternalIteratorState(this);
	  var kind = state.kind;
	  var step = state.iterator.next();
	  var entry = step.value;

	  if (!step.done) {
	    step.value = kind === 'keys' ? entry.key : kind === 'values' ? entry.value : [entry.key, entry.value];
	  }

	  return step;
	}); // `URLSearchParams` constructor
	// https://url.spec.whatwg.org/#interface-urlsearchparams

	var URLSearchParamsConstructor = function URLSearchParams()
	/* init */
	{
	  anInstance(this, URLSearchParamsConstructor, URL_SEARCH_PARAMS);
	  var init = arguments.length > 0 ? arguments[0] : undefined;
	  var that = this;
	  var entries = [];
	  var iteratorMethod, iterator, next, step, entryIterator, entryNext, first, second, key;
	  setInternalState$9(that, {
	    type: URL_SEARCH_PARAMS,
	    entries: entries,
	    updateURL: function updateURL() {
	      /* empty */
	    },
	    updateSearchParams: updateSearchParams
	  });

	  if (init !== undefined) {
	    if (isObject(init)) {
	      iteratorMethod = getIteratorMethod(init);

	      if (typeof iteratorMethod === 'function') {
	        iterator = iteratorMethod.call(init);
	        next = iterator.next;

	        while (!(step = next.call(iterator)).done) {
	          entryIterator = getIterator(anObject(step.value));
	          entryNext = entryIterator.next;
	          if ((first = entryNext.call(entryIterator)).done || (second = entryNext.call(entryIterator)).done || !entryNext.call(entryIterator).done) throw TypeError('Expected sequence with length 2');
	          entries.push({
	            key: first.value + '',
	            value: second.value + ''
	          });
	        }
	      } else for (key in init) {
	        if (has(init, key)) entries.push({
	          key: key,
	          value: init[key] + ''
	        });
	      }
	    } else {
	      parseSearchParams(entries, typeof init === 'string' ? init.charAt(0) === '?' ? init.slice(1) : init : init + '');
	    }
	  }
	};

	var URLSearchParamsPrototype = URLSearchParamsConstructor.prototype;
	redefineAll(URLSearchParamsPrototype, {
	  // `URLSearchParams.prototype.appent` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-append
	  append: function append(name, value) {
	    validateArgumentsLength(arguments.length, 2);
	    var state = getInternalParamsState(this);
	    state.entries.push({
	      key: name + '',
	      value: value + ''
	    });
	    state.updateURL();
	  },
	  // `URLSearchParams.prototype.delete` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-delete
	  'delete': function _delete(name) {
	    validateArgumentsLength(arguments.length, 1);
	    var state = getInternalParamsState(this);
	    var entries = state.entries;
	    var key = name + '';
	    var index = 0;

	    while (index < entries.length) {
	      if (entries[index].key === key) entries.splice(index, 1);else index++;
	    }

	    state.updateURL();
	  },
	  // `URLSearchParams.prototype.get` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-get
	  get: function get(name) {
	    validateArgumentsLength(arguments.length, 1);
	    var entries = getInternalParamsState(this).entries;
	    var key = name + '';
	    var index = 0;

	    for (; index < entries.length; index++) {
	      if (entries[index].key === key) return entries[index].value;
	    }

	    return null;
	  },
	  // `URLSearchParams.prototype.getAll` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-getall
	  getAll: function getAll(name) {
	    validateArgumentsLength(arguments.length, 1);
	    var entries = getInternalParamsState(this).entries;
	    var key = name + '';
	    var result = [];
	    var index = 0;

	    for (; index < entries.length; index++) {
	      if (entries[index].key === key) result.push(entries[index].value);
	    }

	    return result;
	  },
	  // `URLSearchParams.prototype.has` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-has
	  has: function has(name) {
	    validateArgumentsLength(arguments.length, 1);
	    var entries = getInternalParamsState(this).entries;
	    var key = name + '';
	    var index = 0;

	    while (index < entries.length) {
	      if (entries[index++].key === key) return true;
	    }

	    return false;
	  },
	  // `URLSearchParams.prototype.set` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-set
	  set: function set(name, value) {
	    validateArgumentsLength(arguments.length, 1);
	    var state = getInternalParamsState(this);
	    var entries = state.entries;
	    var found = false;
	    var key = name + '';
	    var val = value + '';
	    var index = 0;
	    var entry;

	    for (; index < entries.length; index++) {
	      entry = entries[index];

	      if (entry.key === key) {
	        if (found) entries.splice(index--, 1);else {
	          found = true;
	          entry.value = val;
	        }
	      }
	    }

	    if (!found) entries.push({
	      key: key,
	      value: val
	    });
	    state.updateURL();
	  },
	  // `URLSearchParams.prototype.sort` method
	  // https://url.spec.whatwg.org/#dom-urlsearchparams-sort
	  sort: function sort() {
	    var state = getInternalParamsState(this);
	    var entries = state.entries; // Array#sort is not stable in some engines

	    var slice = entries.slice();
	    var entry, entriesIndex, sliceIndex;
	    entries.length = 0;

	    for (sliceIndex = 0; sliceIndex < slice.length; sliceIndex++) {
	      entry = slice[sliceIndex];

	      for (entriesIndex = 0; entriesIndex < sliceIndex; entriesIndex++) {
	        if (entries[entriesIndex].key > entry.key) {
	          entries.splice(entriesIndex, 0, entry);
	          break;
	        }
	      }

	      if (entriesIndex === sliceIndex) entries.push(entry);
	    }

	    state.updateURL();
	  },
	  // `URLSearchParams.prototype.forEach` method
	  forEach: function forEach(callback
	  /* , thisArg */
	  ) {
	    var entries = getInternalParamsState(this).entries;
	    var boundFunction = functionBindContext(callback, arguments.length > 1 ? arguments[1] : undefined, 3);
	    var index = 0;
	    var entry;

	    while (index < entries.length) {
	      entry = entries[index++];
	      boundFunction(entry.value, entry.key, this);
	    }
	  },
	  // `URLSearchParams.prototype.keys` method
	  keys: function keys() {
	    return new URLSearchParamsIterator(this, 'keys');
	  },
	  // `URLSearchParams.prototype.values` method
	  values: function values() {
	    return new URLSearchParamsIterator(this, 'values');
	  },
	  // `URLSearchParams.prototype.entries` method
	  entries: function entries() {
	    return new URLSearchParamsIterator(this, 'entries');
	  }
	}, {
	  enumerable: true
	}); // `URLSearchParams.prototype[@@iterator]` method

	redefine(URLSearchParamsPrototype, ITERATOR$8, URLSearchParamsPrototype.entries); // `URLSearchParams.prototype.toString` method
	// https://url.spec.whatwg.org/#urlsearchparams-stringification-behavior

	redefine(URLSearchParamsPrototype, 'toString', function toString() {
	  var entries = getInternalParamsState(this).entries;
	  var result = [];
	  var index = 0;
	  var entry;

	  while (index < entries.length) {
	    entry = entries[index++];
	    result.push(serialize(entry.key) + '=' + serialize(entry.value));
	  }

	  return result.join('&');
	}, {
	  enumerable: true
	});
	setToStringTag(URLSearchParamsConstructor, URL_SEARCH_PARAMS);
	_export({
	  global: true,
	  forced: !nativeUrl
	}, {
	  URLSearchParams: URLSearchParamsConstructor
	}); // Wrap `fetch` for correct work with polyfilled `URLSearchParams`
	// https://github.com/zloirock/core-js/issues/674

	if (!nativeUrl && typeof $fetch$1 == 'function' && typeof Headers == 'function') {
	  _export({
	    global: true,
	    enumerable: true,
	    forced: true
	  }, {
	    fetch: function fetch(input
	    /* , init */
	    ) {
	      var args = [input];
	      var init, body, headers;

	      if (arguments.length > 1) {
	        init = arguments[1];

	        if (isObject(init)) {
	          body = init.body;

	          if (classof(body) === URL_SEARCH_PARAMS) {
	            headers = init.headers ? new Headers(init.headers) : new Headers();

	            if (!headers.has('content-type')) {
	              headers.set('content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
	            }

	            init = objectCreate(init, {
	              body: createPropertyDescriptor(0, String(body)),
	              headers: createPropertyDescriptor(0, headers)
	            });
	          }
	        }

	        args.push(init);
	      }

	      return $fetch$1.apply(this, args);
	    }
	  });
	}

	var web_urlSearchParams = {
	  URLSearchParams: URLSearchParamsConstructor,
	  getState: getInternalParamsState
	};
	var web_urlSearchParams_1 = web_urlSearchParams.URLSearchParams;
	var web_urlSearchParams_2 = web_urlSearchParams.getState;

	'use strict'; // TODO: in core-js@4, move /modules/ dependencies to public entries for better optimization by tools like `preset-env`


	var codeAt$1 = stringMultibyte.codeAt;
	var NativeURL = global_1.URL;
	var URLSearchParams$1 = web_urlSearchParams.URLSearchParams;
	var getInternalSearchParamsState = web_urlSearchParams.getState;
	var setInternalState$a = internalState.set;
	var getInternalURLState = internalState.getterFor('URL');
	var floor$9 = Math.floor;
	var pow$4 = Math.pow;
	var INVALID_AUTHORITY = 'Invalid authority';
	var INVALID_SCHEME = 'Invalid scheme';
	var INVALID_HOST = 'Invalid host';
	var INVALID_PORT = 'Invalid port';
	var ALPHA = /[A-Za-z]/;
	var ALPHANUMERIC = /[\d+-.A-Za-z]/;
	var DIGIT = /\d/;
	var HEX_START = /^(0x|0X)/;
	var OCT = /^[0-7]+$/;
	var DEC = /^\d+$/;
	var HEX = /^[\dA-Fa-f]+$/; // eslint-disable-next-line no-control-regex

	var FORBIDDEN_HOST_CODE_POINT = /[\u0000\u0009\u000A\u000D #%/:?@[\\]]/; // eslint-disable-next-line no-control-regex

	var FORBIDDEN_HOST_CODE_POINT_EXCLUDING_PERCENT = /[\u0000\u0009\u000A\u000D #/:?@[\\]]/; // eslint-disable-next-line no-control-regex

	var LEADING_AND_TRAILING_C0_CONTROL_OR_SPACE = /^[\u0000-\u001F ]+|[\u0000-\u001F ]+$/g; // eslint-disable-next-line no-control-regex

	var TAB_AND_NEW_LINE = /[\u0009\u000A\u000D]/g;
	var EOF;

	var parseHost = function parseHost(url, input) {
	  var result, codePoints, index;

	  if (input.charAt(0) == '[') {
	    if (input.charAt(input.length - 1) != ']') return INVALID_HOST;
	    result = parseIPv6(input.slice(1, -1));
	    if (!result) return INVALID_HOST;
	    url.host = result; // opaque host
	  } else if (!isSpecial(url)) {
	    if (FORBIDDEN_HOST_CODE_POINT_EXCLUDING_PERCENT.test(input)) return INVALID_HOST;
	    result = '';
	    codePoints = arrayFrom(input);

	    for (index = 0; index < codePoints.length; index++) {
	      result += percentEncode(codePoints[index], C0ControlPercentEncodeSet);
	    }

	    url.host = result;
	  } else {
	    input = stringPunycodeToAscii(input);
	    if (FORBIDDEN_HOST_CODE_POINT.test(input)) return INVALID_HOST;
	    result = parseIPv4(input);
	    if (result === null) return INVALID_HOST;
	    url.host = result;
	  }
	};

	var parseIPv4 = function parseIPv4(input) {
	  var parts = input.split('.');
	  var partsLength, numbers, index, part, radix, number, ipv4;

	  if (parts.length && parts[parts.length - 1] == '') {
	    parts.pop();
	  }

	  partsLength = parts.length;
	  if (partsLength > 4) return input;
	  numbers = [];

	  for (index = 0; index < partsLength; index++) {
	    part = parts[index];
	    if (part == '') return input;
	    radix = 10;

	    if (part.length > 1 && part.charAt(0) == '0') {
	      radix = HEX_START.test(part) ? 16 : 8;
	      part = part.slice(radix == 8 ? 1 : 2);
	    }

	    if (part === '') {
	      number = 0;
	    } else {
	      if (!(radix == 10 ? DEC : radix == 8 ? OCT : HEX).test(part)) return input;
	      number = parseInt(part, radix);
	    }

	    numbers.push(number);
	  }

	  for (index = 0; index < partsLength; index++) {
	    number = numbers[index];

	    if (index == partsLength - 1) {
	      if (number >= pow$4(256, 5 - partsLength)) return null;
	    } else if (number > 255) return null;
	  }

	  ipv4 = numbers.pop();

	  for (index = 0; index < numbers.length; index++) {
	    ipv4 += numbers[index] * pow$4(256, 3 - index);
	  }

	  return ipv4;
	}; // eslint-disable-next-line max-statements


	var parseIPv6 = function parseIPv6(input) {
	  var address = [0, 0, 0, 0, 0, 0, 0, 0];
	  var pieceIndex = 0;
	  var compress = null;
	  var pointer = 0;
	  var value, length, numbersSeen, ipv4Piece, number, swaps, swap;

	  var char = function char() {
	    return input.charAt(pointer);
	  };

	  if (char() == ':') {
	    if (input.charAt(1) != ':') return;
	    pointer += 2;
	    pieceIndex++;
	    compress = pieceIndex;
	  }

	  while (char()) {
	    if (pieceIndex == 8) return;

	    if (char() == ':') {
	      if (compress !== null) return;
	      pointer++;
	      pieceIndex++;
	      compress = pieceIndex;
	      continue;
	    }

	    value = length = 0;

	    while (length < 4 && HEX.test(char())) {
	      value = value * 16 + parseInt(char(), 16);
	      pointer++;
	      length++;
	    }

	    if (char() == '.') {
	      if (length == 0) return;
	      pointer -= length;
	      if (pieceIndex > 6) return;
	      numbersSeen = 0;

	      while (char()) {
	        ipv4Piece = null;

	        if (numbersSeen > 0) {
	          if (char() == '.' && numbersSeen < 4) pointer++;else return;
	        }

	        if (!DIGIT.test(char())) return;

	        while (DIGIT.test(char())) {
	          number = parseInt(char(), 10);
	          if (ipv4Piece === null) ipv4Piece = number;else if (ipv4Piece == 0) return;else ipv4Piece = ipv4Piece * 10 + number;
	          if (ipv4Piece > 255) return;
	          pointer++;
	        }

	        address[pieceIndex] = address[pieceIndex] * 256 + ipv4Piece;
	        numbersSeen++;
	        if (numbersSeen == 2 || numbersSeen == 4) pieceIndex++;
	      }

	      if (numbersSeen != 4) return;
	      break;
	    } else if (char() == ':') {
	      pointer++;
	      if (!char()) return;
	    } else if (char()) return;

	    address[pieceIndex++] = value;
	  }

	  if (compress !== null) {
	    swaps = pieceIndex - compress;
	    pieceIndex = 7;

	    while (pieceIndex != 0 && swaps > 0) {
	      swap = address[pieceIndex];
	      address[pieceIndex--] = address[compress + swaps - 1];
	      address[compress + --swaps] = swap;
	    }
	  } else if (pieceIndex != 8) return;

	  return address;
	};

	var findLongestZeroSequence = function findLongestZeroSequence(ipv6) {
	  var maxIndex = null;
	  var maxLength = 1;
	  var currStart = null;
	  var currLength = 0;
	  var index = 0;

	  for (; index < 8; index++) {
	    if (ipv6[index] !== 0) {
	      if (currLength > maxLength) {
	        maxIndex = currStart;
	        maxLength = currLength;
	      }

	      currStart = null;
	      currLength = 0;
	    } else {
	      if (currStart === null) currStart = index;
	      ++currLength;
	    }
	  }

	  if (currLength > maxLength) {
	    maxIndex = currStart;
	    maxLength = currLength;
	  }

	  return maxIndex;
	};

	var serializeHost = function serializeHost(host) {
	  var result, index, compress, ignore0; // ipv4

	  if (typeof host == 'number') {
	    result = [];

	    for (index = 0; index < 4; index++) {
	      result.unshift(host % 256);
	      host = floor$9(host / 256);
	    }

	    return result.join('.'); // ipv6
	  } else if (typeof host == 'object') {
	    result = '';
	    compress = findLongestZeroSequence(host);

	    for (index = 0; index < 8; index++) {
	      if (ignore0 && host[index] === 0) continue;
	      if (ignore0) ignore0 = false;

	      if (compress === index) {
	        result += index ? ':' : '::';
	        ignore0 = true;
	      } else {
	        result += host[index].toString(16);
	        if (index < 7) result += ':';
	      }
	    }

	    return '[' + result + ']';
	  }

	  return host;
	};

	var C0ControlPercentEncodeSet = {};
	var fragmentPercentEncodeSet = objectAssign({}, C0ControlPercentEncodeSet, {
	  ' ': 1,
	  '"': 1,
	  '<': 1,
	  '>': 1,
	  '`': 1
	});
	var pathPercentEncodeSet = objectAssign({}, fragmentPercentEncodeSet, {
	  '#': 1,
	  '?': 1,
	  '{': 1,
	  '}': 1
	});
	var userinfoPercentEncodeSet = objectAssign({}, pathPercentEncodeSet, {
	  '/': 1,
	  ':': 1,
	  ';': 1,
	  '=': 1,
	  '@': 1,
	  '[': 1,
	  '\\': 1,
	  ']': 1,
	  '^': 1,
	  '|': 1
	});

	var percentEncode = function percentEncode(char, set) {
	  var code = codeAt$1(char, 0);
	  return code > 0x20 && code < 0x7F && !has(set, char) ? char : encodeURIComponent(char);
	};

	var specialSchemes = {
	  ftp: 21,
	  file: null,
	  http: 80,
	  https: 443,
	  ws: 80,
	  wss: 443
	};

	var isSpecial = function isSpecial(url) {
	  return has(specialSchemes, url.scheme);
	};

	var includesCredentials = function includesCredentials(url) {
	  return url.username != '' || url.password != '';
	};

	var cannotHaveUsernamePasswordPort = function cannotHaveUsernamePasswordPort(url) {
	  return !url.host || url.cannotBeABaseURL || url.scheme == 'file';
	};

	var isWindowsDriveLetter = function isWindowsDriveLetter(string, normalized) {
	  var second;
	  return string.length == 2 && ALPHA.test(string.charAt(0)) && ((second = string.charAt(1)) == ':' || !normalized && second == '|');
	};

	var startsWithWindowsDriveLetter = function startsWithWindowsDriveLetter(string) {
	  var third;
	  return string.length > 1 && isWindowsDriveLetter(string.slice(0, 2)) && (string.length == 2 || (third = string.charAt(2)) === '/' || third === '\\' || third === '?' || third === '#');
	};

	var shortenURLsPath = function shortenURLsPath(url) {
	  var path = url.path;
	  var pathSize = path.length;

	  if (pathSize && (url.scheme != 'file' || pathSize != 1 || !isWindowsDriveLetter(path[0], true))) {
	    path.pop();
	  }
	};

	var isSingleDot = function isSingleDot(segment) {
	  return segment === '.' || segment.toLowerCase() === '%2e';
	};

	var isDoubleDot = function isDoubleDot(segment) {
	  segment = segment.toLowerCase();
	  return segment === '..' || segment === '%2e.' || segment === '.%2e' || segment === '%2e%2e';
	}; // States:


	var SCHEME_START = {};
	var SCHEME = {};
	var NO_SCHEME = {};
	var SPECIAL_RELATIVE_OR_AUTHORITY = {};
	var PATH_OR_AUTHORITY = {};
	var RELATIVE = {};
	var RELATIVE_SLASH = {};
	var SPECIAL_AUTHORITY_SLASHES = {};
	var SPECIAL_AUTHORITY_IGNORE_SLASHES = {};
	var AUTHORITY = {};
	var HOST = {};
	var HOSTNAME = {};
	var PORT = {};
	var FILE = {};
	var FILE_SLASH = {};
	var FILE_HOST = {};
	var PATH_START = {};
	var PATH = {};
	var CANNOT_BE_A_BASE_URL_PATH = {};
	var QUERY = {};
	var FRAGMENT = {}; // eslint-disable-next-line max-statements

	var parseURL = function parseURL(url, input, stateOverride, base) {
	  var state = stateOverride || SCHEME_START;
	  var pointer = 0;
	  var buffer = '';
	  var seenAt = false;
	  var seenBracket = false;
	  var seenPasswordToken = false;
	  var codePoints, char, bufferCodePoints, failure;

	  if (!stateOverride) {
	    url.scheme = '';
	    url.username = '';
	    url.password = '';
	    url.host = null;
	    url.port = null;
	    url.path = [];
	    url.query = null;
	    url.fragment = null;
	    url.cannotBeABaseURL = false;
	    input = input.replace(LEADING_AND_TRAILING_C0_CONTROL_OR_SPACE, '');
	  }

	  input = input.replace(TAB_AND_NEW_LINE, '');
	  codePoints = arrayFrom(input);

	  while (pointer <= codePoints.length) {
	    char = codePoints[pointer];

	    switch (state) {
	      case SCHEME_START:
	        if (char && ALPHA.test(char)) {
	          buffer += char.toLowerCase();
	          state = SCHEME;
	        } else if (!stateOverride) {
	          state = NO_SCHEME;
	          continue;
	        } else return INVALID_SCHEME;

	        break;

	      case SCHEME:
	        if (char && (ALPHANUMERIC.test(char) || char == '+' || char == '-' || char == '.')) {
	          buffer += char.toLowerCase();
	        } else if (char == ':') {
	          if (stateOverride && (isSpecial(url) != has(specialSchemes, buffer) || buffer == 'file' && (includesCredentials(url) || url.port !== null) || url.scheme == 'file' && !url.host)) return;
	          url.scheme = buffer;

	          if (stateOverride) {
	            if (isSpecial(url) && specialSchemes[url.scheme] == url.port) url.port = null;
	            return;
	          }

	          buffer = '';

	          if (url.scheme == 'file') {
	            state = FILE;
	          } else if (isSpecial(url) && base && base.scheme == url.scheme) {
	            state = SPECIAL_RELATIVE_OR_AUTHORITY;
	          } else if (isSpecial(url)) {
	            state = SPECIAL_AUTHORITY_SLASHES;
	          } else if (codePoints[pointer + 1] == '/') {
	            state = PATH_OR_AUTHORITY;
	            pointer++;
	          } else {
	            url.cannotBeABaseURL = true;
	            url.path.push('');
	            state = CANNOT_BE_A_BASE_URL_PATH;
	          }
	        } else if (!stateOverride) {
	          buffer = '';
	          state = NO_SCHEME;
	          pointer = 0;
	          continue;
	        } else return INVALID_SCHEME;

	        break;

	      case NO_SCHEME:
	        if (!base || base.cannotBeABaseURL && char != '#') return INVALID_SCHEME;

	        if (base.cannotBeABaseURL && char == '#') {
	          url.scheme = base.scheme;
	          url.path = base.path.slice();
	          url.query = base.query;
	          url.fragment = '';
	          url.cannotBeABaseURL = true;
	          state = FRAGMENT;
	          break;
	        }

	        state = base.scheme == 'file' ? FILE : RELATIVE;
	        continue;

	      case SPECIAL_RELATIVE_OR_AUTHORITY:
	        if (char == '/' && codePoints[pointer + 1] == '/') {
	          state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
	          pointer++;
	        } else {
	          state = RELATIVE;
	          continue;
	        }

	        break;

	      case PATH_OR_AUTHORITY:
	        if (char == '/') {
	          state = AUTHORITY;
	          break;
	        } else {
	          state = PATH;
	          continue;
	        }

	      case RELATIVE:
	        url.scheme = base.scheme;

	        if (char == EOF) {
	          url.username = base.username;
	          url.password = base.password;
	          url.host = base.host;
	          url.port = base.port;
	          url.path = base.path.slice();
	          url.query = base.query;
	        } else if (char == '/' || char == '\\' && isSpecial(url)) {
	          state = RELATIVE_SLASH;
	        } else if (char == '?') {
	          url.username = base.username;
	          url.password = base.password;
	          url.host = base.host;
	          url.port = base.port;
	          url.path = base.path.slice();
	          url.query = '';
	          state = QUERY;
	        } else if (char == '#') {
	          url.username = base.username;
	          url.password = base.password;
	          url.host = base.host;
	          url.port = base.port;
	          url.path = base.path.slice();
	          url.query = base.query;
	          url.fragment = '';
	          state = FRAGMENT;
	        } else {
	          url.username = base.username;
	          url.password = base.password;
	          url.host = base.host;
	          url.port = base.port;
	          url.path = base.path.slice();
	          url.path.pop();
	          state = PATH;
	          continue;
	        }

	        break;

	      case RELATIVE_SLASH:
	        if (isSpecial(url) && (char == '/' || char == '\\')) {
	          state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
	        } else if (char == '/') {
	          state = AUTHORITY;
	        } else {
	          url.username = base.username;
	          url.password = base.password;
	          url.host = base.host;
	          url.port = base.port;
	          state = PATH;
	          continue;
	        }

	        break;

	      case SPECIAL_AUTHORITY_SLASHES:
	        state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
	        if (char != '/' || buffer.charAt(pointer + 1) != '/') continue;
	        pointer++;
	        break;

	      case SPECIAL_AUTHORITY_IGNORE_SLASHES:
	        if (char != '/' && char != '\\') {
	          state = AUTHORITY;
	          continue;
	        }

	        break;

	      case AUTHORITY:
	        if (char == '@') {
	          if (seenAt) buffer = '%40' + buffer;
	          seenAt = true;
	          bufferCodePoints = arrayFrom(buffer);

	          for (var i = 0; i < bufferCodePoints.length; i++) {
	            var codePoint = bufferCodePoints[i];

	            if (codePoint == ':' && !seenPasswordToken) {
	              seenPasswordToken = true;
	              continue;
	            }

	            var encodedCodePoints = percentEncode(codePoint, userinfoPercentEncodeSet);
	            if (seenPasswordToken) url.password += encodedCodePoints;else url.username += encodedCodePoints;
	          }

	          buffer = '';
	        } else if (char == EOF || char == '/' || char == '?' || char == '#' || char == '\\' && isSpecial(url)) {
	          if (seenAt && buffer == '') return INVALID_AUTHORITY;
	          pointer -= arrayFrom(buffer).length + 1;
	          buffer = '';
	          state = HOST;
	        } else buffer += char;

	        break;

	      case HOST:
	      case HOSTNAME:
	        if (stateOverride && url.scheme == 'file') {
	          state = FILE_HOST;
	          continue;
	        } else if (char == ':' && !seenBracket) {
	          if (buffer == '') return INVALID_HOST;
	          failure = parseHost(url, buffer);
	          if (failure) return failure;
	          buffer = '';
	          state = PORT;
	          if (stateOverride == HOSTNAME) return;
	        } else if (char == EOF || char == '/' || char == '?' || char == '#' || char == '\\' && isSpecial(url)) {
	          if (isSpecial(url) && buffer == '') return INVALID_HOST;
	          if (stateOverride && buffer == '' && (includesCredentials(url) || url.port !== null)) return;
	          failure = parseHost(url, buffer);
	          if (failure) return failure;
	          buffer = '';
	          state = PATH_START;
	          if (stateOverride) return;
	          continue;
	        } else {
	          if (char == '[') seenBracket = true;else if (char == ']') seenBracket = false;
	          buffer += char;
	        }

	        break;

	      case PORT:
	        if (DIGIT.test(char)) {
	          buffer += char;
	        } else if (char == EOF || char == '/' || char == '?' || char == '#' || char == '\\' && isSpecial(url) || stateOverride) {
	          if (buffer != '') {
	            var port = parseInt(buffer, 10);
	            if (port > 0xFFFF) return INVALID_PORT;
	            url.port = isSpecial(url) && port === specialSchemes[url.scheme] ? null : port;
	            buffer = '';
	          }

	          if (stateOverride) return;
	          state = PATH_START;
	          continue;
	        } else return INVALID_PORT;

	        break;

	      case FILE:
	        url.scheme = 'file';
	        if (char == '/' || char == '\\') state = FILE_SLASH;else if (base && base.scheme == 'file') {
	          if (char == EOF) {
	            url.host = base.host;
	            url.path = base.path.slice();
	            url.query = base.query;
	          } else if (char == '?') {
	            url.host = base.host;
	            url.path = base.path.slice();
	            url.query = '';
	            state = QUERY;
	          } else if (char == '#') {
	            url.host = base.host;
	            url.path = base.path.slice();
	            url.query = base.query;
	            url.fragment = '';
	            state = FRAGMENT;
	          } else {
	            if (!startsWithWindowsDriveLetter(codePoints.slice(pointer).join(''))) {
	              url.host = base.host;
	              url.path = base.path.slice();
	              shortenURLsPath(url);
	            }

	            state = PATH;
	            continue;
	          }
	        } else {
	          state = PATH;
	          continue;
	        }
	        break;

	      case FILE_SLASH:
	        if (char == '/' || char == '\\') {
	          state = FILE_HOST;
	          break;
	        }

	        if (base && base.scheme == 'file' && !startsWithWindowsDriveLetter(codePoints.slice(pointer).join(''))) {
	          if (isWindowsDriveLetter(base.path[0], true)) url.path.push(base.path[0]);else url.host = base.host;
	        }

	        state = PATH;
	        continue;

	      case FILE_HOST:
	        if (char == EOF || char == '/' || char == '\\' || char == '?' || char == '#') {
	          if (!stateOverride && isWindowsDriveLetter(buffer)) {
	            state = PATH;
	          } else if (buffer == '') {
	            url.host = '';
	            if (stateOverride) return;
	            state = PATH_START;
	          } else {
	            failure = parseHost(url, buffer);
	            if (failure) return failure;
	            if (url.host == 'localhost') url.host = '';
	            if (stateOverride) return;
	            buffer = '';
	            state = PATH_START;
	          }

	          continue;
	        } else buffer += char;

	        break;

	      case PATH_START:
	        if (isSpecial(url)) {
	          state = PATH;
	          if (char != '/' && char != '\\') continue;
	        } else if (!stateOverride && char == '?') {
	          url.query = '';
	          state = QUERY;
	        } else if (!stateOverride && char == '#') {
	          url.fragment = '';
	          state = FRAGMENT;
	        } else if (char != EOF) {
	          state = PATH;
	          if (char != '/') continue;
	        }

	        break;

	      case PATH:
	        if (char == EOF || char == '/' || char == '\\' && isSpecial(url) || !stateOverride && (char == '?' || char == '#')) {
	          if (isDoubleDot(buffer)) {
	            shortenURLsPath(url);

	            if (char != '/' && !(char == '\\' && isSpecial(url))) {
	              url.path.push('');
	            }
	          } else if (isSingleDot(buffer)) {
	            if (char != '/' && !(char == '\\' && isSpecial(url))) {
	              url.path.push('');
	            }
	          } else {
	            if (url.scheme == 'file' && !url.path.length && isWindowsDriveLetter(buffer)) {
	              if (url.host) url.host = '';
	              buffer = buffer.charAt(0) + ':'; // normalize windows drive letter
	            }

	            url.path.push(buffer);
	          }

	          buffer = '';

	          if (url.scheme == 'file' && (char == EOF || char == '?' || char == '#')) {
	            while (url.path.length > 1 && url.path[0] === '') {
	              url.path.shift();
	            }
	          }

	          if (char == '?') {
	            url.query = '';
	            state = QUERY;
	          } else if (char == '#') {
	            url.fragment = '';
	            state = FRAGMENT;
	          }
	        } else {
	          buffer += percentEncode(char, pathPercentEncodeSet);
	        }

	        break;

	      case CANNOT_BE_A_BASE_URL_PATH:
	        if (char == '?') {
	          url.query = '';
	          state = QUERY;
	        } else if (char == '#') {
	          url.fragment = '';
	          state = FRAGMENT;
	        } else if (char != EOF) {
	          url.path[0] += percentEncode(char, C0ControlPercentEncodeSet);
	        }

	        break;

	      case QUERY:
	        if (!stateOverride && char == '#') {
	          url.fragment = '';
	          state = FRAGMENT;
	        } else if (char != EOF) {
	          if (char == "'" && isSpecial(url)) url.query += '%27';else if (char == '#') url.query += '%23';else url.query += percentEncode(char, C0ControlPercentEncodeSet);
	        }

	        break;

	      case FRAGMENT:
	        if (char != EOF) url.fragment += percentEncode(char, fragmentPercentEncodeSet);
	        break;
	    }

	    pointer++;
	  }
	}; // `URL` constructor
	// https://url.spec.whatwg.org/#url-class


	var URLConstructor = function URL(url
	/* , base */
	) {
	  var that = anInstance(this, URLConstructor, 'URL');
	  var base = arguments.length > 1 ? arguments[1] : undefined;
	  var urlString = String(url);
	  var state = setInternalState$a(that, {
	    type: 'URL'
	  });
	  var baseState, failure;

	  if (base !== undefined) {
	    if (base instanceof URLConstructor) baseState = getInternalURLState(base);else {
	      failure = parseURL(baseState = {}, String(base));
	      if (failure) throw TypeError(failure);
	    }
	  }

	  failure = parseURL(state, urlString, null, baseState);
	  if (failure) throw TypeError(failure);
	  var searchParams = state.searchParams = new URLSearchParams$1();
	  var searchParamsState = getInternalSearchParamsState(searchParams);
	  searchParamsState.updateSearchParams(state.query);

	  searchParamsState.updateURL = function () {
	    state.query = String(searchParams) || null;
	  };

	  if (!descriptors) {
	    that.href = serializeURL.call(that);
	    that.origin = getOrigin.call(that);
	    that.protocol = getProtocol.call(that);
	    that.username = getUsername.call(that);
	    that.password = getPassword.call(that);
	    that.host = getHost.call(that);
	    that.hostname = getHostname.call(that);
	    that.port = getPort.call(that);
	    that.pathname = getPathname.call(that);
	    that.search = getSearch.call(that);
	    that.searchParams = getSearchParams.call(that);
	    that.hash = getHash.call(that);
	  }
	};

	var URLPrototype = URLConstructor.prototype;

	var serializeURL = function serializeURL() {
	  var url = getInternalURLState(this);
	  var scheme = url.scheme;
	  var username = url.username;
	  var password = url.password;
	  var host = url.host;
	  var port = url.port;
	  var path = url.path;
	  var query = url.query;
	  var fragment = url.fragment;
	  var output = scheme + ':';

	  if (host !== null) {
	    output += '//';

	    if (includesCredentials(url)) {
	      output += username + (password ? ':' + password : '') + '@';
	    }

	    output += serializeHost(host);
	    if (port !== null) output += ':' + port;
	  } else if (scheme == 'file') output += '//';

	  output += url.cannotBeABaseURL ? path[0] : path.length ? '/' + path.join('/') : '';
	  if (query !== null) output += '?' + query;
	  if (fragment !== null) output += '#' + fragment;
	  return output;
	};

	var getOrigin = function getOrigin() {
	  var url = getInternalURLState(this);
	  var scheme = url.scheme;
	  var port = url.port;
	  if (scheme == 'blob') try {
	    return new URL(scheme.path[0]).origin;
	  } catch (error) {
	    return 'null';
	  }
	  if (scheme == 'file' || !isSpecial(url)) return 'null';
	  return scheme + '://' + serializeHost(url.host) + (port !== null ? ':' + port : '');
	};

	var getProtocol = function getProtocol() {
	  return getInternalURLState(this).scheme + ':';
	};

	var getUsername = function getUsername() {
	  return getInternalURLState(this).username;
	};

	var getPassword = function getPassword() {
	  return getInternalURLState(this).password;
	};

	var getHost = function getHost() {
	  var url = getInternalURLState(this);
	  var host = url.host;
	  var port = url.port;
	  return host === null ? '' : port === null ? serializeHost(host) : serializeHost(host) + ':' + port;
	};

	var getHostname = function getHostname() {
	  var host = getInternalURLState(this).host;
	  return host === null ? '' : serializeHost(host);
	};

	var getPort = function getPort() {
	  var port = getInternalURLState(this).port;
	  return port === null ? '' : String(port);
	};

	var getPathname = function getPathname() {
	  var url = getInternalURLState(this);
	  var path = url.path;
	  return url.cannotBeABaseURL ? path[0] : path.length ? '/' + path.join('/') : '';
	};

	var getSearch = function getSearch() {
	  var query = getInternalURLState(this).query;
	  return query ? '?' + query : '';
	};

	var getSearchParams = function getSearchParams() {
	  return getInternalURLState(this).searchParams;
	};

	var getHash = function getHash() {
	  var fragment = getInternalURLState(this).fragment;
	  return fragment ? '#' + fragment : '';
	};

	var accessorDescriptor = function accessorDescriptor(getter, setter) {
	  return {
	    get: getter,
	    set: setter,
	    configurable: true,
	    enumerable: true
	  };
	};

	if (descriptors) {
	  objectDefineProperties(URLPrototype, {
	    // `URL.prototype.href` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-href
	    href: accessorDescriptor(serializeURL, function (href) {
	      var url = getInternalURLState(this);
	      var urlString = String(href);
	      var failure = parseURL(url, urlString);
	      if (failure) throw TypeError(failure);
	      getInternalSearchParamsState(url.searchParams).updateSearchParams(url.query);
	    }),
	    // `URL.prototype.origin` getter
	    // https://url.spec.whatwg.org/#dom-url-origin
	    origin: accessorDescriptor(getOrigin),
	    // `URL.prototype.protocol` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-protocol
	    protocol: accessorDescriptor(getProtocol, function (protocol) {
	      var url = getInternalURLState(this);
	      parseURL(url, String(protocol) + ':', SCHEME_START);
	    }),
	    // `URL.prototype.username` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-username
	    username: accessorDescriptor(getUsername, function (username) {
	      var url = getInternalURLState(this);
	      var codePoints = arrayFrom(String(username));
	      if (cannotHaveUsernamePasswordPort(url)) return;
	      url.username = '';

	      for (var i = 0; i < codePoints.length; i++) {
	        url.username += percentEncode(codePoints[i], userinfoPercentEncodeSet);
	      }
	    }),
	    // `URL.prototype.password` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-password
	    password: accessorDescriptor(getPassword, function (password) {
	      var url = getInternalURLState(this);
	      var codePoints = arrayFrom(String(password));
	      if (cannotHaveUsernamePasswordPort(url)) return;
	      url.password = '';

	      for (var i = 0; i < codePoints.length; i++) {
	        url.password += percentEncode(codePoints[i], userinfoPercentEncodeSet);
	      }
	    }),
	    // `URL.prototype.host` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-host
	    host: accessorDescriptor(getHost, function (host) {
	      var url = getInternalURLState(this);
	      if (url.cannotBeABaseURL) return;
	      parseURL(url, String(host), HOST);
	    }),
	    // `URL.prototype.hostname` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-hostname
	    hostname: accessorDescriptor(getHostname, function (hostname) {
	      var url = getInternalURLState(this);
	      if (url.cannotBeABaseURL) return;
	      parseURL(url, String(hostname), HOSTNAME);
	    }),
	    // `URL.prototype.port` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-port
	    port: accessorDescriptor(getPort, function (port) {
	      var url = getInternalURLState(this);
	      if (cannotHaveUsernamePasswordPort(url)) return;
	      port = String(port);
	      if (port == '') url.port = null;else parseURL(url, port, PORT);
	    }),
	    // `URL.prototype.pathname` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-pathname
	    pathname: accessorDescriptor(getPathname, function (pathname) {
	      var url = getInternalURLState(this);
	      if (url.cannotBeABaseURL) return;
	      url.path = [];
	      parseURL(url, pathname + '', PATH_START);
	    }),
	    // `URL.prototype.search` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-search
	    search: accessorDescriptor(getSearch, function (search) {
	      var url = getInternalURLState(this);
	      search = String(search);

	      if (search == '') {
	        url.query = null;
	      } else {
	        if ('?' == search.charAt(0)) search = search.slice(1);
	        url.query = '';
	        parseURL(url, search, QUERY);
	      }

	      getInternalSearchParamsState(url.searchParams).updateSearchParams(url.query);
	    }),
	    // `URL.prototype.searchParams` getter
	    // https://url.spec.whatwg.org/#dom-url-searchparams
	    searchParams: accessorDescriptor(getSearchParams),
	    // `URL.prototype.hash` accessors pair
	    // https://url.spec.whatwg.org/#dom-url-hash
	    hash: accessorDescriptor(getHash, function (hash) {
	      var url = getInternalURLState(this);
	      hash = String(hash);

	      if (hash == '') {
	        url.fragment = null;
	        return;
	      }

	      if ('#' == hash.charAt(0)) hash = hash.slice(1);
	      url.fragment = '';
	      parseURL(url, hash, FRAGMENT);
	    })
	  });
	} // `URL.prototype.toJSON` method
	// https://url.spec.whatwg.org/#dom-url-tojson


	redefine(URLPrototype, 'toJSON', function toJSON() {
	  return serializeURL.call(this);
	}, {
	  enumerable: true
	}); // `URL.prototype.toString` method
	// https://url.spec.whatwg.org/#URL-stringification-behavior

	redefine(URLPrototype, 'toString', function toString() {
	  return serializeURL.call(this);
	}, {
	  enumerable: true
	});

	if (NativeURL) {
	  var nativeCreateObjectURL = NativeURL.createObjectURL;
	  var nativeRevokeObjectURL = NativeURL.revokeObjectURL; // `URL.createObjectURL` method
	  // https://developer.mozilla.org/en-US/docs/Web/API/URL/createObjectURL
	  // eslint-disable-next-line no-unused-vars

	  if (nativeCreateObjectURL) redefine(URLConstructor, 'createObjectURL', function createObjectURL(blob) {
	    return nativeCreateObjectURL.apply(NativeURL, arguments);
	  }); // `URL.revokeObjectURL` method
	  // https://developer.mozilla.org/en-US/docs/Web/API/URL/revokeObjectURL
	  // eslint-disable-next-line no-unused-vars

	  if (nativeRevokeObjectURL) redefine(URLConstructor, 'revokeObjectURL', function revokeObjectURL(url) {
	    return nativeRevokeObjectURL.apply(NativeURL, arguments);
	  });
	}

	setToStringTag(URLConstructor, 'URL');
	_export({
	  global: true,
	  forced: !nativeUrl,
	  sham: !descriptors
	}, {
	  URL: URLConstructor
	});
	var web_url = {};

	'use strict'; // `URL.prototype.toJSON` method
	// https://url.spec.whatwg.org/#dom-url-tojson


	_export({
	  target: 'URL',
	  proto: true,
	  enumerable: true
	}, {
	  toJSON: function toJSON() {
	    return URL.prototype.toString.call(this);
	  }
	});
	var web_url_toJson = {};

	var web = path;

	var stable = path;

	var runtime_1 = createCommonjsModule(function (module) {
	  /**
	   * Copyright (c) 2014-present, Facebook, Inc.
	   *
	   * This source code is licensed under the MIT license found in the
	   * LICENSE file in the root directory of this source tree.
	   */
	  var runtime = function (exports) {
	    "use strict";

	    var Op = Object.prototype;
	    var hasOwn = Op.hasOwnProperty;
	    var undefined$1; // More compressible than void 0.

	    var $Symbol = typeof Symbol === "function" ? Symbol : {};
	    var iteratorSymbol = $Symbol.iterator || "@@iterator";
	    var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
	    var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

	    function wrap(innerFn, outerFn, self, tryLocsList) {
	      // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
	      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
	      var generator = Object.create(protoGenerator.prototype);
	      var context = new Context(tryLocsList || []); // The ._invoke method unifies the implementations of the .next,
	      // .throw, and .return methods.

	      generator._invoke = makeInvokeMethod(innerFn, self, context);
	      return generator;
	    }

	    exports.wrap = wrap; // Try/catch helper to minimize deoptimizations. Returns a completion
	    // record like context.tryEntries[i].completion. This interface could
	    // have been (and was previously) designed to take a closure to be
	    // invoked without arguments, but in all the cases we care about we
	    // already have an existing method we want to call, so there's no need
	    // to create a new function object. We can even get away with assuming
	    // the method takes exactly one argument, since that happens to be true
	    // in every case, so we don't have to touch the arguments object. The
	    // only additional allocation required is the completion record, which
	    // has a stable shape and so hopefully should be cheap to allocate.

	    function tryCatch(fn, obj, arg) {
	      try {
	        return {
	          type: "normal",
	          arg: fn.call(obj, arg)
	        };
	      } catch (err) {
	        return {
	          type: "throw",
	          arg: err
	        };
	      }
	    }

	    var GenStateSuspendedStart = "suspendedStart";
	    var GenStateSuspendedYield = "suspendedYield";
	    var GenStateExecuting = "executing";
	    var GenStateCompleted = "completed"; // Returning this object from the innerFn has the same effect as
	    // breaking out of the dispatch switch statement.

	    var ContinueSentinel = {}; // Dummy constructor functions that we use as the .constructor and
	    // .constructor.prototype properties for functions that return Generator
	    // objects. For full spec compliance, you may wish to configure your
	    // minifier not to mangle the names of these two functions.

	    function Generator() {}

	    function GeneratorFunction() {}

	    function GeneratorFunctionPrototype() {} // This is a polyfill for %IteratorPrototype% for environments that
	    // don't natively support it.


	    var IteratorPrototype = {};

	    IteratorPrototype[iteratorSymbol] = function () {
	      return this;
	    };

	    var getProto = Object.getPrototypeOf;
	    var NativeIteratorPrototype = getProto && getProto(getProto(values([])));

	    if (NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
	      // This environment has a native %IteratorPrototype%; use it instead
	      // of the polyfill.
	      IteratorPrototype = NativeIteratorPrototype;
	    }

	    var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
	    GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
	    GeneratorFunctionPrototype.constructor = GeneratorFunction;
	    GeneratorFunctionPrototype[toStringTagSymbol] = GeneratorFunction.displayName = "GeneratorFunction"; // Helper for defining the .next, .throw, and .return methods of the
	    // Iterator interface in terms of a single ._invoke method.

	    function defineIteratorMethods(prototype) {
	      ["next", "throw", "return"].forEach(function (method) {
	        prototype[method] = function (arg) {
	          return this._invoke(method, arg);
	        };
	      });
	    }

	    exports.isGeneratorFunction = function (genFun) {
	      var ctor = typeof genFun === "function" && genFun.constructor;
	      return ctor ? ctor === GeneratorFunction || // For the native GeneratorFunction constructor, the best we can
	      // do is to check its .name property.
	      (ctor.displayName || ctor.name) === "GeneratorFunction" : false;
	    };

	    exports.mark = function (genFun) {
	      if (Object.setPrototypeOf) {
	        Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
	      } else {
	        genFun.__proto__ = GeneratorFunctionPrototype;

	        if (!(toStringTagSymbol in genFun)) {
	          genFun[toStringTagSymbol] = "GeneratorFunction";
	        }
	      }

	      genFun.prototype = Object.create(Gp);
	      return genFun;
	    }; // Within the body of any async function, `await x` is transformed to
	    // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
	    // `hasOwn.call(value, "__await")` to determine if the yielded value is
	    // meant to be awaited.


	    exports.awrap = function (arg) {
	      return {
	        __await: arg
	      };
	    };

	    function AsyncIterator(generator, PromiseImpl) {
	      function invoke(method, arg, resolve, reject) {
	        var record = tryCatch(generator[method], generator, arg);

	        if (record.type === "throw") {
	          reject(record.arg);
	        } else {
	          var result = record.arg;
	          var value = result.value;

	          if (value && typeof value === "object" && hasOwn.call(value, "__await")) {
	            return PromiseImpl.resolve(value.__await).then(function (value) {
	              invoke("next", value, resolve, reject);
	            }, function (err) {
	              invoke("throw", err, resolve, reject);
	            });
	          }

	          return PromiseImpl.resolve(value).then(function (unwrapped) {
	            // When a yielded Promise is resolved, its final value becomes
	            // the .value of the Promise<{value,done}> result for the
	            // current iteration.
	            result.value = unwrapped;
	            resolve(result);
	          }, function (error) {
	            // If a rejected Promise was yielded, throw the rejection back
	            // into the async generator function so it can be handled there.
	            return invoke("throw", error, resolve, reject);
	          });
	        }
	      }

	      var previousPromise;

	      function enqueue(method, arg) {
	        function callInvokeWithMethodAndArg() {
	          return new PromiseImpl(function (resolve, reject) {
	            invoke(method, arg, resolve, reject);
	          });
	        }

	        return previousPromise = // If enqueue has been called before, then we want to wait until
	        // all previous Promises have been resolved before calling invoke,
	        // so that results are always delivered in the correct order. If
	        // enqueue has not been called before, then it is important to
	        // call invoke immediately, without waiting on a callback to fire,
	        // so that the async generator function has the opportunity to do
	        // any necessary setup in a predictable way. This predictability
	        // is why the Promise constructor synchronously invokes its
	        // executor callback, and why async functions synchronously
	        // execute code before the first await. Since we implement simple
	        // async functions in terms of async generators, it is especially
	        // important to get this right, even though it requires care.
	        previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, // Avoid propagating failures to Promises returned by later
	        // invocations of the iterator.
	        callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
	      } // Define the unified helper method that is used to implement .next,
	      // .throw, and .return (see defineIteratorMethods).


	      this._invoke = enqueue;
	    }

	    defineIteratorMethods(AsyncIterator.prototype);

	    AsyncIterator.prototype[asyncIteratorSymbol] = function () {
	      return this;
	    };

	    exports.AsyncIterator = AsyncIterator; // Note that simple async functions are implemented on top of
	    // AsyncIterator objects; they just return a Promise for the value of
	    // the final result produced by the iterator.

	    exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
	      if (PromiseImpl === void 0) PromiseImpl = Promise;
	      var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
	      return exports.isGeneratorFunction(outerFn) ? iter // If outerFn is a generator, return the full iterator.
	      : iter.next().then(function (result) {
	        return result.done ? result.value : iter.next();
	      });
	    };

	    function makeInvokeMethod(innerFn, self, context) {
	      var state = GenStateSuspendedStart;
	      return function invoke(method, arg) {
	        if (state === GenStateExecuting) {
	          throw new Error("Generator is already running");
	        }

	        if (state === GenStateCompleted) {
	          if (method === "throw") {
	            throw arg;
	          } // Be forgiving, per 25.3.3.3.3 of the spec:
	          // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume


	          return doneResult();
	        }

	        context.method = method;
	        context.arg = arg;

	        while (true) {
	          var delegate = context.delegate;

	          if (delegate) {
	            var delegateResult = maybeInvokeDelegate(delegate, context);

	            if (delegateResult) {
	              if (delegateResult === ContinueSentinel) continue;
	              return delegateResult;
	            }
	          }

	          if (context.method === "next") {
	            // Setting context._sent for legacy support of Babel's
	            // function.sent implementation.
	            context.sent = context._sent = context.arg;
	          } else if (context.method === "throw") {
	            if (state === GenStateSuspendedStart) {
	              state = GenStateCompleted;
	              throw context.arg;
	            }

	            context.dispatchException(context.arg);
	          } else if (context.method === "return") {
	            context.abrupt("return", context.arg);
	          }

	          state = GenStateExecuting;
	          var record = tryCatch(innerFn, self, context);

	          if (record.type === "normal") {
	            // If an exception is thrown from innerFn, we leave state ===
	            // GenStateExecuting and loop back for another invocation.
	            state = context.done ? GenStateCompleted : GenStateSuspendedYield;

	            if (record.arg === ContinueSentinel) {
	              continue;
	            }

	            return {
	              value: record.arg,
	              done: context.done
	            };
	          } else if (record.type === "throw") {
	            state = GenStateCompleted; // Dispatch the exception by looping back around to the
	            // context.dispatchException(context.arg) call above.

	            context.method = "throw";
	            context.arg = record.arg;
	          }
	        }
	      };
	    } // Call delegate.iterator[context.method](context.arg) and handle the
	    // result, either by returning a { value, done } result from the
	    // delegate iterator, or by modifying context.method and context.arg,
	    // setting context.delegate to null, and returning the ContinueSentinel.


	    function maybeInvokeDelegate(delegate, context) {
	      var method = delegate.iterator[context.method];

	      if (method === undefined$1) {
	        // A .throw or .return when the delegate iterator has no .throw
	        // method always terminates the yield* loop.
	        context.delegate = null;

	        if (context.method === "throw") {
	          // Note: ["return"] must be used for ES3 parsing compatibility.
	          if (delegate.iterator["return"]) {
	            // If the delegate iterator has a return method, give it a
	            // chance to clean up.
	            context.method = "return";
	            context.arg = undefined$1;
	            maybeInvokeDelegate(delegate, context);

	            if (context.method === "throw") {
	              // If maybeInvokeDelegate(context) changed context.method from
	              // "return" to "throw", let that override the TypeError below.
	              return ContinueSentinel;
	            }
	          }

	          context.method = "throw";
	          context.arg = new TypeError("The iterator does not provide a 'throw' method");
	        }

	        return ContinueSentinel;
	      }

	      var record = tryCatch(method, delegate.iterator, context.arg);

	      if (record.type === "throw") {
	        context.method = "throw";
	        context.arg = record.arg;
	        context.delegate = null;
	        return ContinueSentinel;
	      }

	      var info = record.arg;

	      if (!info) {
	        context.method = "throw";
	        context.arg = new TypeError("iterator result is not an object");
	        context.delegate = null;
	        return ContinueSentinel;
	      }

	      if (info.done) {
	        // Assign the result of the finished delegate to the temporary
	        // variable specified by delegate.resultName (see delegateYield).
	        context[delegate.resultName] = info.value; // Resume execution at the desired location (see delegateYield).

	        context.next = delegate.nextLoc; // If context.method was "throw" but the delegate handled the
	        // exception, let the outer generator proceed normally. If
	        // context.method was "next", forget context.arg since it has been
	        // "consumed" by the delegate iterator. If context.method was
	        // "return", allow the original .return call to continue in the
	        // outer generator.

	        if (context.method !== "return") {
	          context.method = "next";
	          context.arg = undefined$1;
	        }
	      } else {
	        // Re-yield the result returned by the delegate method.
	        return info;
	      } // The delegate iterator is finished, so forget it and continue with
	      // the outer generator.


	      context.delegate = null;
	      return ContinueSentinel;
	    } // Define Generator.prototype.{next,throw,return} in terms of the
	    // unified ._invoke helper method.


	    defineIteratorMethods(Gp);
	    Gp[toStringTagSymbol] = "Generator"; // A Generator should always return itself as the iterator object when the
	    // @@iterator function is called on it. Some browsers' implementations of the
	    // iterator prototype chain incorrectly implement this, causing the Generator
	    // object to not be returned from this call. This ensures that doesn't happen.
	    // See https://github.com/facebook/regenerator/issues/274 for more details.

	    Gp[iteratorSymbol] = function () {
	      return this;
	    };

	    Gp.toString = function () {
	      return "[object Generator]";
	    };

	    function pushTryEntry(locs) {
	      var entry = {
	        tryLoc: locs[0]
	      };

	      if (1 in locs) {
	        entry.catchLoc = locs[1];
	      }

	      if (2 in locs) {
	        entry.finallyLoc = locs[2];
	        entry.afterLoc = locs[3];
	      }

	      this.tryEntries.push(entry);
	    }

	    function resetTryEntry(entry) {
	      var record = entry.completion || {};
	      record.type = "normal";
	      delete record.arg;
	      entry.completion = record;
	    }

	    function Context(tryLocsList) {
	      // The root entry object (effectively a try statement without a catch
	      // or a finally block) gives us a place to store values thrown from
	      // locations where there is no enclosing try statement.
	      this.tryEntries = [{
	        tryLoc: "root"
	      }];
	      tryLocsList.forEach(pushTryEntry, this);
	      this.reset(true);
	    }

	    exports.keys = function (object) {
	      var keys = [];

	      for (var key in object) {
	        keys.push(key);
	      }

	      keys.reverse(); // Rather than returning an object with a next method, we keep
	      // things simple and return the next function itself.

	      return function next() {
	        while (keys.length) {
	          var key = keys.pop();

	          if (key in object) {
	            next.value = key;
	            next.done = false;
	            return next;
	          }
	        } // To avoid creating an additional object, we just hang the .value
	        // and .done properties off the next function object itself. This
	        // also ensures that the minifier will not anonymize the function.


	        next.done = true;
	        return next;
	      };
	    };

	    function values(iterable) {
	      if (iterable) {
	        var iteratorMethod = iterable[iteratorSymbol];

	        if (iteratorMethod) {
	          return iteratorMethod.call(iterable);
	        }

	        if (typeof iterable.next === "function") {
	          return iterable;
	        }

	        if (!isNaN(iterable.length)) {
	          var i = -1,
	              next = function next() {
	            while (++i < iterable.length) {
	              if (hasOwn.call(iterable, i)) {
	                next.value = iterable[i];
	                next.done = false;
	                return next;
	              }
	            }

	            next.value = undefined$1;
	            next.done = true;
	            return next;
	          };

	          return next.next = next;
	        }
	      } // Return an iterator with no values.


	      return {
	        next: doneResult
	      };
	    }

	    exports.values = values;

	    function doneResult() {
	      return {
	        value: undefined$1,
	        done: true
	      };
	    }

	    Context.prototype = {
	      constructor: Context,
	      reset: function reset(skipTempReset) {
	        this.prev = 0;
	        this.next = 0; // Resetting context._sent for legacy support of Babel's
	        // function.sent implementation.

	        this.sent = this._sent = undefined$1;
	        this.done = false;
	        this.delegate = null;
	        this.method = "next";
	        this.arg = undefined$1;
	        this.tryEntries.forEach(resetTryEntry);

	        if (!skipTempReset) {
	          for (var name in this) {
	            // Not sure about the optimal order of these conditions:
	            if (name.charAt(0) === "t" && hasOwn.call(this, name) && !isNaN(+name.slice(1))) {
	              this[name] = undefined$1;
	            }
	          }
	        }
	      },
	      stop: function stop() {
	        this.done = true;
	        var rootEntry = this.tryEntries[0];
	        var rootRecord = rootEntry.completion;

	        if (rootRecord.type === "throw") {
	          throw rootRecord.arg;
	        }

	        return this.rval;
	      },
	      dispatchException: function dispatchException(exception) {
	        if (this.done) {
	          throw exception;
	        }

	        var context = this;

	        function handle(loc, caught) {
	          record.type = "throw";
	          record.arg = exception;
	          context.next = loc;

	          if (caught) {
	            // If the dispatched exception was caught by a catch block,
	            // then let that catch block handle the exception normally.
	            context.method = "next";
	            context.arg = undefined$1;
	          }

	          return !!caught;
	        }

	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];
	          var record = entry.completion;

	          if (entry.tryLoc === "root") {
	            // Exception thrown outside of any try block that could handle
	            // it, so set the completion value of the entire function to
	            // throw the exception.
	            return handle("end");
	          }

	          if (entry.tryLoc <= this.prev) {
	            var hasCatch = hasOwn.call(entry, "catchLoc");
	            var hasFinally = hasOwn.call(entry, "finallyLoc");

	            if (hasCatch && hasFinally) {
	              if (this.prev < entry.catchLoc) {
	                return handle(entry.catchLoc, true);
	              } else if (this.prev < entry.finallyLoc) {
	                return handle(entry.finallyLoc);
	              }
	            } else if (hasCatch) {
	              if (this.prev < entry.catchLoc) {
	                return handle(entry.catchLoc, true);
	              }
	            } else if (hasFinally) {
	              if (this.prev < entry.finallyLoc) {
	                return handle(entry.finallyLoc);
	              }
	            } else {
	              throw new Error("try statement without catch or finally");
	            }
	          }
	        }
	      },
	      abrupt: function abrupt(type, arg) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];

	          if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
	            var finallyEntry = entry;
	            break;
	          }
	        }

	        if (finallyEntry && (type === "break" || type === "continue") && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc) {
	          // Ignore the finally entry if control is not jumping to a
	          // location outside the try/catch block.
	          finallyEntry = null;
	        }

	        var record = finallyEntry ? finallyEntry.completion : {};
	        record.type = type;
	        record.arg = arg;

	        if (finallyEntry) {
	          this.method = "next";
	          this.next = finallyEntry.finallyLoc;
	          return ContinueSentinel;
	        }

	        return this.complete(record);
	      },
	      complete: function complete(record, afterLoc) {
	        if (record.type === "throw") {
	          throw record.arg;
	        }

	        if (record.type === "break" || record.type === "continue") {
	          this.next = record.arg;
	        } else if (record.type === "return") {
	          this.rval = this.arg = record.arg;
	          this.method = "return";
	          this.next = "end";
	        } else if (record.type === "normal" && afterLoc) {
	          this.next = afterLoc;
	        }

	        return ContinueSentinel;
	      },
	      finish: function finish(finallyLoc) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];

	          if (entry.finallyLoc === finallyLoc) {
	            this.complete(entry.completion, entry.afterLoc);
	            resetTryEntry(entry);
	            return ContinueSentinel;
	          }
	        }
	      },
	      "catch": function _catch(tryLoc) {
	        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
	          var entry = this.tryEntries[i];

	          if (entry.tryLoc === tryLoc) {
	            var record = entry.completion;

	            if (record.type === "throw") {
	              var thrown = record.arg;
	              resetTryEntry(entry);
	            }

	            return thrown;
	          }
	        } // The context.catch method must only be called with a location
	        // argument that corresponds to a known catch block.


	        throw new Error("illegal catch attempt");
	      },
	      delegateYield: function delegateYield(iterable, resultName, nextLoc) {
	        this.delegate = {
	          iterator: values(iterable),
	          resultName: resultName,
	          nextLoc: nextLoc
	        };

	        if (this.method === "next") {
	          // Deliberately forget the last sent value so that we don't
	          // accidentally pass it on to the delegate.
	          this.arg = undefined$1;
	        }

	        return ContinueSentinel;
	      }
	    }; // Regardless of whether this script is executing as a CommonJS module
	    // or not, return the runtime object so that we can declare the variable
	    // regeneratorRuntime in the outer scope, which allows this module to be
	    // injected easily by `bin/regenerator --include-runtime script.js`.

	    return exports;
	  }( // If this script is executing as a CommonJS module, use module.exports
	  // as the regeneratorRuntime namespace. Otherwise create a new empty
	  // object. Either way, the resulting object will be used to initialize
	  // the regeneratorRuntime variable at the top of this file.
	  'object' === "object" ? module.exports : {});

	  try {
	    regeneratorRuntime = runtime;
	  } catch (accidentalStrictMode) {
	    // This module should not be running in strict mode, so the above
	    // assignment should always work unless something is misconfigured. Just
	    // in case runtime.js accidentally runs in strict mode, we can escape
	    // strict mode using a global Function call. This could conceivably fail
	    // if a Content Security Policy forbids using Function, but in that case
	    // the proper solution is to fix the accidental strict mode problem. If
	    // you've misconfigured your bundler to force strict mode and applied a
	    // CSP to forbid Function, and you're not willing to fix either of those
	    // problems, please detail your unique predicament in a GitHub issue.
	    Function("r", "regeneratorRuntime = r")(runtime);
	  }
	});

	function _typeof(obj) {
	  "@babel/helpers - typeof";

	  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
	    _typeof = function (obj) {
	      return typeof obj;
	    };
	  } else {
	    _typeof = function (obj) {
	      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	    };
	  }

	  return _typeof(obj);
	}

	var REACT_ELEMENT_TYPE;

	function _jsx(type, props, key, children) {
	  if (!REACT_ELEMENT_TYPE) {
	    REACT_ELEMENT_TYPE = typeof Symbol === "function" && Symbol["for"] && Symbol["for"]("react.element") || 0xeac7;
	  }

	  var defaultProps = type && type.defaultProps;
	  var childrenLength = arguments.length - 3;

	  if (!props && childrenLength !== 0) {
	    props = {
	      children: void 0
	    };
	  }

	  if (childrenLength === 1) {
	    props.children = children;
	  } else if (childrenLength > 1) {
	    var childArray = new Array(childrenLength);

	    for (var i = 0; i < childrenLength; i++) {
	      childArray[i] = arguments[i + 3];
	    }

	    props.children = childArray;
	  }

	  if (props && defaultProps) {
	    for (var propName in defaultProps) {
	      if (props[propName] === void 0) {
	        props[propName] = defaultProps[propName];
	      }
	    }
	  } else if (!props) {
	    props = defaultProps || {};
	  }

	  return {
	    $$typeof: REACT_ELEMENT_TYPE,
	    type: type,
	    key: key === undefined ? null : '' + key,
	    ref: null,
	    props: props,
	    _owner: null
	  };
	}

	function _asyncIterator(iterable) {
	  var method;

	  if (typeof Symbol !== "undefined") {
	    if (Symbol.asyncIterator) {
	      method = iterable[Symbol.asyncIterator];
	      if (method != null) return method.call(iterable);
	    }

	    if (Symbol.iterator) {
	      method = iterable[Symbol.iterator];
	      if (method != null) return method.call(iterable);
	    }
	  }

	  throw new TypeError("Object is not async iterable");
	}

	function _AwaitValue(value) {
	  this.wrapped = value;
	}

	function _AsyncGenerator(gen) {
	  var front, back;

	  function send(key, arg) {
	    return new Promise(function (resolve, reject) {
	      var request = {
	        key: key,
	        arg: arg,
	        resolve: resolve,
	        reject: reject,
	        next: null
	      };

	      if (back) {
	        back = back.next = request;
	      } else {
	        front = back = request;
	        resume(key, arg);
	      }
	    });
	  }

	  function resume(key, arg) {
	    try {
	      var result = gen[key](arg);
	      var value = result.value;
	      var wrappedAwait = value instanceof _AwaitValue;
	      Promise.resolve(wrappedAwait ? value.wrapped : value).then(function (arg) {
	        if (wrappedAwait) {
	          resume(key === "return" ? "return" : "next", arg);
	          return;
	        }

	        settle(result.done ? "return" : "normal", arg);
	      }, function (err) {
	        resume("throw", err);
	      });
	    } catch (err) {
	      settle("throw", err);
	    }
	  }

	  function settle(type, value) {
	    switch (type) {
	      case "return":
	        front.resolve({
	          value: value,
	          done: true
	        });
	        break;

	      case "throw":
	        front.reject(value);
	        break;

	      default:
	        front.resolve({
	          value: value,
	          done: false
	        });
	        break;
	    }

	    front = front.next;

	    if (front) {
	      resume(front.key, front.arg);
	    } else {
	      back = null;
	    }
	  }

	  this._invoke = send;

	  if (typeof gen.return !== "function") {
	    this.return = undefined;
	  }
	}

	if (typeof Symbol === "function" && Symbol.asyncIterator) {
	  _AsyncGenerator.prototype[Symbol.asyncIterator] = function () {
	    return this;
	  };
	}

	_AsyncGenerator.prototype.next = function (arg) {
	  return this._invoke("next", arg);
	};

	_AsyncGenerator.prototype.throw = function (arg) {
	  return this._invoke("throw", arg);
	};

	_AsyncGenerator.prototype.return = function (arg) {
	  return this._invoke("return", arg);
	};

	function _wrapAsyncGenerator(fn) {
	  return function () {
	    return new _AsyncGenerator(fn.apply(this, arguments));
	  };
	}

	function _awaitAsyncGenerator(value) {
	  return new _AwaitValue(value);
	}

	function _asyncGeneratorDelegate(inner, awaitWrap) {
	  var iter = {},
	      waiting = false;

	  function pump(key, value) {
	    waiting = true;
	    value = new Promise(function (resolve) {
	      resolve(inner[key](value));
	    });
	    return {
	      done: false,
	      value: awaitWrap(value)
	    };
	  }

	  ;

	  if (typeof Symbol === "function" && Symbol.iterator) {
	    iter[Symbol.iterator] = function () {
	      return this;
	    };
	  }

	  iter.next = function (value) {
	    if (waiting) {
	      waiting = false;
	      return value;
	    }

	    return pump("next", value);
	  };

	  if (typeof inner.throw === "function") {
	    iter.throw = function (value) {
	      if (waiting) {
	        waiting = false;
	        throw value;
	      }

	      return pump("throw", value);
	    };
	  }

	  if (typeof inner.return === "function") {
	    iter.return = function (value) {
	      if (waiting) {
	        waiting = false;
	        return value;
	      }

	      return pump("return", value);
	    };
	  }

	  return iter;
	}

	function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
	  try {
	    var info = gen[key](arg);
	    var value = info.value;
	  } catch (error) {
	    reject(error);
	    return;
	  }

	  if (info.done) {
	    resolve(value);
	  } else {
	    Promise.resolve(value).then(_next, _throw);
	  }
	}

	function _asyncToGenerator(fn) {
	  return function () {
	    var self = this,
	        args = arguments;
	    return new Promise(function (resolve, reject) {
	      var gen = fn.apply(self, args);

	      function _next(value) {
	        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
	      }

	      function _throw(err) {
	        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
	      }

	      _next(undefined);
	    });
	  };
	}

	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;
	    Object.defineProperty(target, descriptor.key, descriptor);
	  }
	}

	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);
	  return Constructor;
	}

	function _defineEnumerableProperties(obj, descs) {
	  for (var key in descs) {
	    var desc = descs[key];
	    desc.configurable = desc.enumerable = true;
	    if ("value" in desc) desc.writable = true;
	    Object.defineProperty(obj, key, desc);
	  }

	  if (Object.getOwnPropertySymbols) {
	    var objectSymbols = Object.getOwnPropertySymbols(descs);

	    for (var i = 0; i < objectSymbols.length; i++) {
	      var sym = objectSymbols[i];
	      var desc = descs[sym];
	      desc.configurable = desc.enumerable = true;
	      if ("value" in desc) desc.writable = true;
	      Object.defineProperty(obj, sym, desc);
	    }
	  }

	  return obj;
	}

	function _defaults(obj, defaults) {
	  var keys = Object.getOwnPropertyNames(defaults);

	  for (var i = 0; i < keys.length; i++) {
	    var key = keys[i];
	    var value = Object.getOwnPropertyDescriptor(defaults, key);

	    if (value && value.configurable && obj[key] === undefined) {
	      Object.defineProperty(obj, key, value);
	    }
	  }

	  return obj;
	}

	function _defineProperty(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	}

	function _extends() {
	  _extends = Object.assign || function (target) {
	    for (var i = 1; i < arguments.length; i++) {
	      var source = arguments[i];

	      for (var key in source) {
	        if (Object.prototype.hasOwnProperty.call(source, key)) {
	          target[key] = source[key];
	        }
	      }
	    }

	    return target;
	  };

	  return _extends.apply(this, arguments);
	}

	function _objectSpread(target) {
	  for (var i = 1; i < arguments.length; i++) {
	    var source = arguments[i] != null ? Object(arguments[i]) : {};
	    var ownKeys = Object.keys(source);

	    if (typeof Object.getOwnPropertySymbols === 'function') {
	      ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
	        return Object.getOwnPropertyDescriptor(source, sym).enumerable;
	      }));
	    }

	    ownKeys.forEach(function (key) {
	      _defineProperty(target, key, source[key]);
	    });
	  }

	  return target;
	}

	function ownKeys$1(object, enumerableOnly) {
	  var keys = Object.keys(object);

	  if (Object.getOwnPropertySymbols) {
	    var symbols = Object.getOwnPropertySymbols(object);
	    if (enumerableOnly) symbols = symbols.filter(function (sym) {
	      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
	    });
	    keys.push.apply(keys, symbols);
	  }

	  return keys;
	}

	function _objectSpread2(target) {
	  for (var i = 1; i < arguments.length; i++) {
	    var source = arguments[i] != null ? arguments[i] : {};

	    if (i % 2) {
	      ownKeys$1(Object(source), true).forEach(function (key) {
	        _defineProperty(target, key, source[key]);
	      });
	    } else if (Object.getOwnPropertyDescriptors) {
	      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
	    } else {
	      ownKeys$1(Object(source)).forEach(function (key) {
	        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
	      });
	    }
	  }

	  return target;
	}

	function _inherits(subClass, superClass) {
	  if (typeof superClass !== "function" && superClass !== null) {
	    throw new TypeError("Super expression must either be null or a function");
	  }

	  subClass.prototype = Object.create(superClass && superClass.prototype, {
	    constructor: {
	      value: subClass,
	      writable: true,
	      configurable: true
	    }
	  });
	  if (superClass) _setPrototypeOf(subClass, superClass);
	}

	function _inheritsLoose(subClass, superClass) {
	  subClass.prototype = Object.create(superClass.prototype);
	  subClass.prototype.constructor = subClass;
	  subClass.__proto__ = superClass;
	}

	function _getPrototypeOf(o) {
	  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
	    return o.__proto__ || Object.getPrototypeOf(o);
	  };
	  return _getPrototypeOf(o);
	}

	function _setPrototypeOf(o, p) {
	  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
	    o.__proto__ = p;
	    return o;
	  };

	  return _setPrototypeOf(o, p);
	}

	function _isNativeReflectConstruct() {
	  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
	  if (Reflect.construct.sham) return false;
	  if (typeof Proxy === "function") return true;

	  try {
	    Date.prototype.toString.call(Reflect.construct(Date, [], function () {}));
	    return true;
	  } catch (e) {
	    return false;
	  }
	}

	function _construct(Parent, args, Class) {
	  if (_isNativeReflectConstruct()) {
	    _construct = Reflect.construct;
	  } else {
	    _construct = function _construct(Parent, args, Class) {
	      var a = [null];
	      a.push.apply(a, args);
	      var Constructor = Function.bind.apply(Parent, a);
	      var instance = new Constructor();
	      if (Class) _setPrototypeOf(instance, Class.prototype);
	      return instance;
	    };
	  }

	  return _construct.apply(null, arguments);
	}

	function _isNativeFunction(fn) {
	  return Function.toString.call(fn).indexOf("[native code]") !== -1;
	}

	function _wrapNativeSuper(Class) {
	  var _cache = typeof Map === "function" ? new Map() : undefined;

	  _wrapNativeSuper = function _wrapNativeSuper(Class) {
	    if (Class === null || !_isNativeFunction(Class)) return Class;

	    if (typeof Class !== "function") {
	      throw new TypeError("Super expression must either be null or a function");
	    }

	    if (typeof _cache !== "undefined") {
	      if (_cache.has(Class)) return _cache.get(Class);

	      _cache.set(Class, Wrapper);
	    }

	    function Wrapper() {
	      return _construct(Class, arguments, _getPrototypeOf(this).constructor);
	    }

	    Wrapper.prototype = Object.create(Class.prototype, {
	      constructor: {
	        value: Wrapper,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	    return _setPrototypeOf(Wrapper, Class);
	  };

	  return _wrapNativeSuper(Class);
	}

	function _instanceof(left, right) {
	  if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) {
	    return !!right[Symbol.hasInstance](left);
	  } else {
	    return left instanceof right;
	  }
	}

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : {
	    default: obj
	  };
	}

	function _getRequireWildcardCache() {
	  if (typeof WeakMap !== "function") return null;
	  var cache = new WeakMap();

	  _getRequireWildcardCache = function () {
	    return cache;
	  };

	  return cache;
	}

	function _interopRequireWildcard(obj) {
	  if (obj && obj.__esModule) {
	    return obj;
	  }

	  if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
	    return {
	      default: obj
	    };
	  }

	  var cache = _getRequireWildcardCache();

	  if (cache && cache.has(obj)) {
	    return cache.get(obj);
	  }

	  var newObj = {};
	  var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

	  for (var key in obj) {
	    if (Object.prototype.hasOwnProperty.call(obj, key)) {
	      var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

	      if (desc && (desc.get || desc.set)) {
	        Object.defineProperty(newObj, key, desc);
	      } else {
	        newObj[key] = obj[key];
	      }
	    }
	  }

	  newObj.default = obj;

	  if (cache) {
	    cache.set(obj, newObj);
	  }

	  return newObj;
	}

	function _newArrowCheck(innerThis, boundThis) {
	  if (innerThis !== boundThis) {
	    throw new TypeError("Cannot instantiate an arrow function");
	  }
	}

	function _objectDestructuringEmpty(obj) {
	  if (obj == null) throw new TypeError("Cannot destructure undefined");
	}

	function _objectWithoutPropertiesLoose(source, excluded) {
	  if (source == null) return {};
	  var target = {};
	  var sourceKeys = Object.keys(source);
	  var key, i;

	  for (i = 0; i < sourceKeys.length; i++) {
	    key = sourceKeys[i];
	    if (excluded.indexOf(key) >= 0) continue;
	    target[key] = source[key];
	  }

	  return target;
	}

	function _objectWithoutProperties(source, excluded) {
	  if (source == null) return {};

	  var target = _objectWithoutPropertiesLoose(source, excluded);

	  var key, i;

	  if (Object.getOwnPropertySymbols) {
	    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

	    for (i = 0; i < sourceSymbolKeys.length; i++) {
	      key = sourceSymbolKeys[i];
	      if (excluded.indexOf(key) >= 0) continue;
	      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
	      target[key] = source[key];
	    }
	  }

	  return target;
	}

	function _assertThisInitialized(self) {
	  if (self === void 0) {
	    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  }

	  return self;
	}

	function _possibleConstructorReturn(self, call) {
	  if (call && (typeof call === "object" || typeof call === "function")) {
	    return call;
	  }

	  return _assertThisInitialized(self);
	}

	function _createSuper(Derived) {
	  return function () {
	    var Super = _getPrototypeOf(Derived),
	        result;

	    if (_isNativeReflectConstruct()) {
	      var NewTarget = _getPrototypeOf(this).constructor;

	      result = Reflect.construct(Super, arguments, NewTarget);
	    } else {
	      result = Super.apply(this, arguments);
	    }

	    return _possibleConstructorReturn(this, result);
	  };
	}

	function _superPropBase(object, property) {
	  while (!Object.prototype.hasOwnProperty.call(object, property)) {
	    object = _getPrototypeOf(object);
	    if (object === null) break;
	  }

	  return object;
	}

	function _get(target, property, receiver) {
	  if (typeof Reflect !== "undefined" && Reflect.get) {
	    _get = Reflect.get;
	  } else {
	    _get = function _get(target, property, receiver) {
	      var base = _superPropBase(target, property);

	      if (!base) return;
	      var desc = Object.getOwnPropertyDescriptor(base, property);

	      if (desc.get) {
	        return desc.get.call(receiver);
	      }

	      return desc.value;
	    };
	  }

	  return _get(target, property, receiver || target);
	}

	function set$4(target, property, value, receiver) {
	  if (typeof Reflect !== "undefined" && Reflect.set) {
	    set$4 = Reflect.set;
	  } else {
	    set$4 = function set(target, property, value, receiver) {
	      var base = _superPropBase(target, property);

	      var desc;

	      if (base) {
	        desc = Object.getOwnPropertyDescriptor(base, property);

	        if (desc.set) {
	          desc.set.call(receiver, value);
	          return true;
	        } else if (!desc.writable) {
	          return false;
	        }
	      }

	      desc = Object.getOwnPropertyDescriptor(receiver, property);

	      if (desc) {
	        if (!desc.writable) {
	          return false;
	        }

	        desc.value = value;
	        Object.defineProperty(receiver, property, desc);
	      } else {
	        _defineProperty(receiver, property, value);
	      }

	      return true;
	    };
	  }

	  return set$4(target, property, value, receiver);
	}

	function _set(target, property, value, receiver, isStrict) {
	  var s = set$4(target, property, value, receiver || target);

	  if (!s && isStrict) {
	    throw new Error('failed to set property');
	  }

	  return value;
	}

	function _taggedTemplateLiteral(strings, raw) {
	  if (!raw) {
	    raw = strings.slice(0);
	  }

	  return Object.freeze(Object.defineProperties(strings, {
	    raw: {
	      value: Object.freeze(raw)
	    }
	  }));
	}

	function _taggedTemplateLiteralLoose(strings, raw) {
	  if (!raw) {
	    raw = strings.slice(0);
	  }

	  strings.raw = raw;
	  return strings;
	}

	function _readOnlyError(name) {
	  throw new Error("\"" + name + "\" is read-only");
	}

	function _classNameTDZError(name) {
	  throw new Error("Class \"" + name + "\" cannot be referenced in computed property keys.");
	}

	function _temporalUndefined() {}

	function _tdz(name) {
	  throw new ReferenceError(name + " is not defined - temporal dead zone");
	}

	function _temporalRef(val, name) {
	  return val === _temporalUndefined ? _tdz(name) : val;
	}

	function _slicedToArray(arr, i) {
	  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
	}

	function _slicedToArrayLoose(arr, i) {
	  return _arrayWithHoles(arr) || _iterableToArrayLimitLoose(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
	}

	function _toArray(arr) {
	  return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest();
	}

	function _toConsumableArray(arr) {
	  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
	}

	function _arrayWithoutHoles(arr) {
	  if (Array.isArray(arr)) return _arrayLikeToArray(arr);
	}

	function _arrayWithHoles(arr) {
	  if (Array.isArray(arr)) return arr;
	}

	function _iterableToArray(iter) {
	  if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter);
	}

	function _iterableToArrayLimit(arr, i) {
	  if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;
	  var _arr = [];
	  var _n = true;
	  var _d = false;
	  var _e = undefined;

	  try {
	    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
	      _arr.push(_s.value);

	      if (i && _arr.length === i) break;
	    }
	  } catch (err) {
	    _d = true;
	    _e = err;
	  } finally {
	    try {
	      if (!_n && _i["return"] != null) _i["return"]();
	    } finally {
	      if (_d) throw _e;
	    }
	  }

	  return _arr;
	}

	function _iterableToArrayLimitLoose(arr, i) {
	  if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;
	  var _arr = [];

	  for (var _iterator = arr[Symbol.iterator](), _step; !(_step = _iterator.next()).done;) {
	    _arr.push(_step.value);

	    if (i && _arr.length === i) break;
	  }

	  return _arr;
	}

	function _unsupportedIterableToArray(o, minLen) {
	  if (!o) return;
	  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
	  var n = Object.prototype.toString.call(o).slice(8, -1);
	  if (n === "Object" && o.constructor) n = o.constructor.name;
	  if (n === "Map" || n === "Set") return Array.from(n);
	  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
	}

	function _arrayLikeToArray(arr, len) {
	  if (len == null || len > arr.length) len = arr.length;

	  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

	  return arr2;
	}

	function _nonIterableSpread() {
	  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	function _nonIterableRest() {
	  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	function _createForOfIteratorHelper(o) {
	  if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) {
	    if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) {
	      var i = 0;

	      var F = function () {};

	      return {
	        s: F,
	        n: function () {
	          if (i >= o.length) return {
	            done: true
	          };
	          return {
	            done: false,
	            value: o[i++]
	          };
	        },
	        e: function (e) {
	          throw e;
	        },
	        f: F
	      };
	    }

	    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	  }

	  var it,
	      normalCompletion = true,
	      didErr = false,
	      err;
	  return {
	    s: function () {
	      it = o[Symbol.iterator]();
	    },
	    n: function () {
	      var step = it.next();
	      normalCompletion = step.done;
	      return step;
	    },
	    e: function (e) {
	      didErr = true;
	      err = e;
	    },
	    f: function () {
	      try {
	        if (!normalCompletion && it.return != null) it.return();
	      } finally {
	        if (didErr) throw err;
	      }
	    }
	  };
	}

	function _createForOfIteratorHelperLoose(o) {
	  var i = 0;

	  if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) {
	    if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) return function () {
	      if (i >= o.length) return {
	        done: true
	      };
	      return {
	        done: false,
	        value: o[i++]
	      };
	    };
	    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	  }

	  i = o[Symbol.iterator]();
	  return i.next.bind(i);
	}

	function _skipFirstGeneratorNext(fn) {
	  return function () {
	    var it = fn.apply(this, arguments);
	    it.next();
	    return it;
	  };
	}

	function _toPrimitive(input, hint) {
	  if (typeof input !== "object" || input === null) return input;
	  var prim = input[Symbol.toPrimitive];

	  if (prim !== undefined) {
	    var res = prim.call(input, hint || "default");
	    if (typeof res !== "object") return res;
	    throw new TypeError("@@toPrimitive must return a primitive value.");
	  }

	  return (hint === "string" ? String : Number)(input);
	}

	function _toPropertyKey(arg) {
	  var key = _toPrimitive(arg, "string");

	  return typeof key === "symbol" ? key : String(key);
	}

	function _initializerWarningHelper(descriptor, context) {
	  throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.');
	}

	function _initializerDefineProperty(target, property, descriptor, context) {
	  if (!descriptor) return;
	  Object.defineProperty(target, property, {
	    enumerable: descriptor.enumerable,
	    configurable: descriptor.configurable,
	    writable: descriptor.writable,
	    value: descriptor.initializer ? descriptor.initializer.call(context) : void 0
	  });
	}

	function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
	  var desc = {};
	  Object.keys(descriptor).forEach(function (key) {
	    desc[key] = descriptor[key];
	  });
	  desc.enumerable = !!desc.enumerable;
	  desc.configurable = !!desc.configurable;

	  if ('value' in desc || desc.initializer) {
	    desc.writable = true;
	  }

	  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
	    return decorator(target, property, desc) || desc;
	  }, desc);

	  if (context && desc.initializer !== void 0) {
	    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
	    desc.initializer = undefined;
	  }

	  if (desc.initializer === void 0) {
	    Object.defineProperty(target, property, desc);
	    desc = null;
	  }

	  return desc;
	}

	var id$2 = 0;

	function _classPrivateFieldLooseKey(name) {
	  return "__private_" + id$2++ + "_" + name;
	}

	function _classPrivateFieldLooseBase(receiver, privateKey) {
	  if (!Object.prototype.hasOwnProperty.call(receiver, privateKey)) {
	    throw new TypeError("attempted to use private field on non-instance");
	  }

	  return receiver;
	}

	function _classPrivateFieldGet(receiver, privateMap) {
	  var descriptor = privateMap.get(receiver);

	  if (!descriptor) {
	    throw new TypeError("attempted to get private field on non-instance");
	  }

	  if (descriptor.get) {
	    return descriptor.get.call(receiver);
	  }

	  return descriptor.value;
	}

	function _classPrivateFieldSet(receiver, privateMap, value) {
	  var descriptor = privateMap.get(receiver);

	  if (!descriptor) {
	    throw new TypeError("attempted to set private field on non-instance");
	  }

	  if (descriptor.set) {
	    descriptor.set.call(receiver, value);
	  } else {
	    if (!descriptor.writable) {
	      throw new TypeError("attempted to set read only private field");
	    }

	    descriptor.value = value;
	  }

	  return value;
	}

	function _classPrivateFieldDestructureSet(receiver, privateMap) {
	  if (!privateMap.has(receiver)) {
	    throw new TypeError("attempted to set private field on non-instance");
	  }

	  var descriptor = privateMap.get(receiver);

	  if (descriptor.set) {
	    if (!("__destrObj" in descriptor)) {
	      descriptor.__destrObj = {
	        set value(v) {
	          descriptor.set.call(receiver, v);
	        }

	      };
	    }

	    return descriptor.__destrObj;
	  } else {
	    if (!descriptor.writable) {
	      throw new TypeError("attempted to set read only private field");
	    }

	    return descriptor;
	  }
	}

	function _classStaticPrivateFieldSpecGet(receiver, classConstructor, descriptor) {
	  if (receiver !== classConstructor) {
	    throw new TypeError("Private static access of wrong provenance");
	  }

	  if (descriptor.get) {
	    return descriptor.get.call(receiver);
	  }

	  return descriptor.value;
	}

	function _classStaticPrivateFieldSpecSet(receiver, classConstructor, descriptor, value) {
	  if (receiver !== classConstructor) {
	    throw new TypeError("Private static access of wrong provenance");
	  }

	  if (descriptor.set) {
	    descriptor.set.call(receiver, value);
	  } else {
	    if (!descriptor.writable) {
	      throw new TypeError("attempted to set read only private field");
	    }

	    descriptor.value = value;
	  }

	  return value;
	}

	function _classStaticPrivateMethodGet(receiver, classConstructor, method) {
	  if (receiver !== classConstructor) {
	    throw new TypeError("Private static access of wrong provenance");
	  }

	  return method;
	}

	function _classStaticPrivateMethodSet() {
	  throw new TypeError("attempted to set read only static private field");
	}

	function _decorate(decorators, factory, superClass, mixins) {
	  var api = _getDecoratorsApi();

	  if (mixins) {
	    for (var i = 0; i < mixins.length; i++) {
	      api = mixins[i](api);
	    }
	  }

	  var r = factory(function initialize(O) {
	    api.initializeInstanceElements(O, decorated.elements);
	  }, superClass);
	  var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators);
	  api.initializeClassElements(r.F, decorated.elements);
	  return api.runClassFinishers(r.F, decorated.finishers);
	}

	function _getDecoratorsApi() {
	  _getDecoratorsApi = function () {
	    return api;
	  };

	  var api = {
	    elementsDefinitionOrder: [["method"], ["field"]],
	    initializeInstanceElements: function (O, elements) {
	      ["method", "field"].forEach(function (kind) {
	        elements.forEach(function (element) {
	          if (element.kind === kind && element.placement === "own") {
	            this.defineClassElement(O, element);
	          }
	        }, this);
	      }, this);
	    },
	    initializeClassElements: function (F, elements) {
	      var proto = F.prototype;
	      ["method", "field"].forEach(function (kind) {
	        elements.forEach(function (element) {
	          var placement = element.placement;

	          if (element.kind === kind && (placement === "static" || placement === "prototype")) {
	            var receiver = placement === "static" ? F : proto;
	            this.defineClassElement(receiver, element);
	          }
	        }, this);
	      }, this);
	    },
	    defineClassElement: function (receiver, element) {
	      var descriptor = element.descriptor;

	      if (element.kind === "field") {
	        var initializer = element.initializer;
	        descriptor = {
	          enumerable: descriptor.enumerable,
	          writable: descriptor.writable,
	          configurable: descriptor.configurable,
	          value: initializer === void 0 ? void 0 : initializer.call(receiver)
	        };
	      }

	      Object.defineProperty(receiver, element.key, descriptor);
	    },
	    decorateClass: function (elements, decorators) {
	      var newElements = [];
	      var finishers = [];
	      var placements = {
	        static: [],
	        prototype: [],
	        own: []
	      };
	      elements.forEach(function (element) {
	        this.addElementPlacement(element, placements);
	      }, this);
	      elements.forEach(function (element) {
	        if (!_hasDecorators(element)) return newElements.push(element);
	        var elementFinishersExtras = this.decorateElement(element, placements);
	        newElements.push(elementFinishersExtras.element);
	        newElements.push.apply(newElements, elementFinishersExtras.extras);
	        finishers.push.apply(finishers, elementFinishersExtras.finishers);
	      }, this);

	      if (!decorators) {
	        return {
	          elements: newElements,
	          finishers: finishers
	        };
	      }

	      var result = this.decorateConstructor(newElements, decorators);
	      finishers.push.apply(finishers, result.finishers);
	      result.finishers = finishers;
	      return result;
	    },
	    addElementPlacement: function (element, placements, silent) {
	      var keys = placements[element.placement];

	      if (!silent && keys.indexOf(element.key) !== -1) {
	        throw new TypeError("Duplicated element (" + element.key + ")");
	      }

	      keys.push(element.key);
	    },
	    decorateElement: function (element, placements) {
	      var extras = [];
	      var finishers = [];

	      for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) {
	        var keys = placements[element.placement];
	        keys.splice(keys.indexOf(element.key), 1);
	        var elementObject = this.fromElementDescriptor(element);
	        var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject);
	        element = elementFinisherExtras.element;
	        this.addElementPlacement(element, placements);

	        if (elementFinisherExtras.finisher) {
	          finishers.push(elementFinisherExtras.finisher);
	        }

	        var newExtras = elementFinisherExtras.extras;

	        if (newExtras) {
	          for (var j = 0; j < newExtras.length; j++) {
	            this.addElementPlacement(newExtras[j], placements);
	          }

	          extras.push.apply(extras, newExtras);
	        }
	      }

	      return {
	        element: element,
	        finishers: finishers,
	        extras: extras
	      };
	    },
	    decorateConstructor: function (elements, decorators) {
	      var finishers = [];

	      for (var i = decorators.length - 1; i >= 0; i--) {
	        var obj = this.fromClassDescriptor(elements);
	        var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj);

	        if (elementsAndFinisher.finisher !== undefined) {
	          finishers.push(elementsAndFinisher.finisher);
	        }

	        if (elementsAndFinisher.elements !== undefined) {
	          elements = elementsAndFinisher.elements;

	          for (var j = 0; j < elements.length - 1; j++) {
	            for (var k = j + 1; k < elements.length; k++) {
	              if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) {
	                throw new TypeError("Duplicated element (" + elements[j].key + ")");
	              }
	            }
	          }
	        }
	      }

	      return {
	        elements: elements,
	        finishers: finishers
	      };
	    },
	    fromElementDescriptor: function (element) {
	      var obj = {
	        kind: element.kind,
	        key: element.key,
	        placement: element.placement,
	        descriptor: element.descriptor
	      };
	      var desc = {
	        value: "Descriptor",
	        configurable: true
	      };
	      Object.defineProperty(obj, Symbol.toStringTag, desc);
	      if (element.kind === "field") obj.initializer = element.initializer;
	      return obj;
	    },
	    toElementDescriptors: function (elementObjects) {
	      if (elementObjects === undefined) return;
	      return _toArray(elementObjects).map(function (elementObject) {
	        var element = this.toElementDescriptor(elementObject);
	        this.disallowProperty(elementObject, "finisher", "An element descriptor");
	        this.disallowProperty(elementObject, "extras", "An element descriptor");
	        return element;
	      }, this);
	    },
	    toElementDescriptor: function (elementObject) {
	      var kind = String(elementObject.kind);

	      if (kind !== "method" && kind !== "field") {
	        throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"');
	      }

	      var key = _toPropertyKey(elementObject.key);

	      var placement = String(elementObject.placement);

	      if (placement !== "static" && placement !== "prototype" && placement !== "own") {
	        throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"');
	      }

	      var descriptor = elementObject.descriptor;
	      this.disallowProperty(elementObject, "elements", "An element descriptor");
	      var element = {
	        kind: kind,
	        key: key,
	        placement: placement,
	        descriptor: Object.assign({}, descriptor)
	      };

	      if (kind !== "field") {
	        this.disallowProperty(elementObject, "initializer", "A method descriptor");
	      } else {
	        this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor");
	        this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor");
	        this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor");
	        element.initializer = elementObject.initializer;
	      }

	      return element;
	    },
	    toElementFinisherExtras: function (elementObject) {
	      var element = this.toElementDescriptor(elementObject);

	      var finisher = _optionalCallableProperty(elementObject, "finisher");

	      var extras = this.toElementDescriptors(elementObject.extras);
	      return {
	        element: element,
	        finisher: finisher,
	        extras: extras
	      };
	    },
	    fromClassDescriptor: function (elements) {
	      var obj = {
	        kind: "class",
	        elements: elements.map(this.fromElementDescriptor, this)
	      };
	      var desc = {
	        value: "Descriptor",
	        configurable: true
	      };
	      Object.defineProperty(obj, Symbol.toStringTag, desc);
	      return obj;
	    },
	    toClassDescriptor: function (obj) {
	      var kind = String(obj.kind);

	      if (kind !== "class") {
	        throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"');
	      }

	      this.disallowProperty(obj, "key", "A class descriptor");
	      this.disallowProperty(obj, "placement", "A class descriptor");
	      this.disallowProperty(obj, "descriptor", "A class descriptor");
	      this.disallowProperty(obj, "initializer", "A class descriptor");
	      this.disallowProperty(obj, "extras", "A class descriptor");

	      var finisher = _optionalCallableProperty(obj, "finisher");

	      var elements = this.toElementDescriptors(obj.elements);
	      return {
	        elements: elements,
	        finisher: finisher
	      };
	    },
	    runClassFinishers: function (constructor, finishers) {
	      for (var i = 0; i < finishers.length; i++) {
	        var newConstructor = (0, finishers[i])(constructor);

	        if (newConstructor !== undefined) {
	          if (typeof newConstructor !== "function") {
	            throw new TypeError("Finishers must return a constructor.");
	          }

	          constructor = newConstructor;
	        }
	      }

	      return constructor;
	    },
	    disallowProperty: function (obj, name, objectType) {
	      if (obj[name] !== undefined) {
	        throw new TypeError(objectType + " can't have a ." + name + " property.");
	      }
	    }
	  };
	  return api;
	}

	function _createElementDescriptor(def) {
	  var key = _toPropertyKey(def.key);

	  var descriptor;

	  if (def.kind === "method") {
	    descriptor = {
	      value: def.value,
	      writable: true,
	      configurable: true,
	      enumerable: false
	    };
	  } else if (def.kind === "get") {
	    descriptor = {
	      get: def.value,
	      configurable: true,
	      enumerable: false
	    };
	  } else if (def.kind === "set") {
	    descriptor = {
	      set: def.value,
	      configurable: true,
	      enumerable: false
	    };
	  } else if (def.kind === "field") {
	    descriptor = {
	      configurable: true,
	      writable: true,
	      enumerable: true
	    };
	  }

	  var element = {
	    kind: def.kind === "field" ? "field" : "method",
	    key: key,
	    placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype",
	    descriptor: descriptor
	  };
	  if (def.decorators) element.decorators = def.decorators;
	  if (def.kind === "field") element.initializer = def.value;
	  return element;
	}

	function _coalesceGetterSetter(element, other) {
	  if (element.descriptor.get !== undefined) {
	    other.descriptor.get = element.descriptor.get;
	  } else {
	    other.descriptor.set = element.descriptor.set;
	  }
	}

	function _coalesceClassElements(elements) {
	  var newElements = [];

	  var isSameElement = function (other) {
	    return other.kind === "method" && other.key === element.key && other.placement === element.placement;
	  };

	  for (var i = 0; i < elements.length; i++) {
	    var element = elements[i];
	    var other;

	    if (element.kind === "method" && (other = newElements.find(isSameElement))) {
	      if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) {
	        if (_hasDecorators(element) || _hasDecorators(other)) {
	          throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated.");
	        }

	        other.descriptor = element.descriptor;
	      } else {
	        if (_hasDecorators(element)) {
	          if (_hasDecorators(other)) {
	            throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ").");
	          }

	          other.decorators = element.decorators;
	        }

	        _coalesceGetterSetter(element, other);
	      }
	    } else {
	      newElements.push(element);
	    }
	  }

	  return newElements;
	}

	function _hasDecorators(element) {
	  return element.decorators && element.decorators.length;
	}

	function _isDataDescriptor(desc) {
	  return desc !== undefined && !(desc.value === undefined && desc.writable === undefined);
	}

	function _optionalCallableProperty(obj, name) {
	  var value = obj[name];

	  if (value !== undefined && typeof value !== "function") {
	    throw new TypeError("Expected '" + name + "' to be a function");
	  }

	  return value;
	}

	function _classPrivateMethodGet(receiver, privateSet, fn) {
	  if (!privateSet.has(receiver)) {
	    throw new TypeError("attempted to get private field on non-instance");
	  }

	  return fn;
	}

	function _classPrivateMethodSet() {
	  throw new TypeError("attempted to reassign private method");
	}

	function _wrapRegExp(re, groups) {
	  _wrapRegExp = function (re, groups) {
	    return new BabelRegExp(re, undefined, groups);
	  };

	  var _RegExp = _wrapNativeSuper(RegExp);

	  var _super = RegExp.prototype;

	  var _groups = new WeakMap();

	  function BabelRegExp(re, flags, groups) {
	    var _this = _RegExp.call(this, re, flags);

	    _groups.set(_this, groups || _groups.get(re));

	    return _this;
	  }

	  _inherits(BabelRegExp, _RegExp);

	  BabelRegExp.prototype.exec = function (str) {
	    var result = _super.exec.call(this, str);

	    if (result) result.groups = buildGroups(result, this);
	    return result;
	  };

	  BabelRegExp.prototype[Symbol.replace] = function (str, substitution) {
	    if (typeof substitution === "string") {
	      var groups = _groups.get(this);

	      return _super[Symbol.replace].call(this, str, substitution.replace(/\$<([^>]+)>/g, function (_, name) {
	        return "$" + groups[name];
	      }));
	    } else if (typeof substitution === "function") {
	      var _this = this;

	      return _super[Symbol.replace].call(this, str, function () {
	        var args = [];
	        args.push.apply(args, arguments);

	        if (typeof args[args.length - 1] !== "object") {
	          args.push(buildGroups(args, _this));
	        }

	        return substitution.apply(this, args);
	      });
	    } else {
	      return _super[Symbol.replace].call(this, str, substitution);
	    }
	  };

	  function buildGroups(result, re) {
	    var g = _groups.get(re);

	    return Object.keys(g).reduce(function (groups, name) {
	      groups[name] = result[g[name]];
	      return groups;
	    }, Object.create(null));
	  }

	  return _wrapRegExp.apply(this, arguments);
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var EPSILON_FLOAT32 = 1e-7;
	var EPSILON_FLOAT16 = 1e-4;
	/** Convenient class for storing tensor-related data. */

	var DataStorage = /*#__PURE__*/function () {
	  function DataStorage(backend, dataMover) {
	    this.backend = backend;
	    this.dataMover = dataMover;
	    this.data = new WeakMap();
	    this.dataIdsCount = 0;
	  }

	  var _proto = DataStorage.prototype;

	  _proto.get = function get(dataId) {
	    if (!this.data.has(dataId)) {
	      this.dataMover.moveData(this.backend, dataId);
	    }

	    return this.data.get(dataId);
	  };

	  _proto.set = function set(dataId, value) {
	    this.dataIdsCount++;
	    this.data.set(dataId, value);
	  };

	  _proto.has = function has(dataId) {
	    return this.data.has(dataId);
	  };

	  _proto.delete = function _delete(dataId) {
	    this.dataIdsCount--;
	    return this.data.delete(dataId);
	  };

	  _proto.numDataIds = function numDataIds() {
	    return this.dataIdsCount;
	  };

	  return DataStorage;
	}();
	/**
	 * The interface that defines the kernels that should be implemented when
	 * adding a new backend. New backends don't need to implement every one of the
	 * methods, this can be done gradually (throw an error for unimplemented
	 * methods).
	 */

	var KernelBackend = /*#__PURE__*/function () {
	  function KernelBackend() {}

	  var _proto2 = KernelBackend.prototype;

	  /**
	   * Decrease the complex ref count for the dataId, this is useful for WebGL
	   * backend to keep the real and imag components of the complex tensor in sync
	   * with the engine. WASM and node do not have internal ref count, they will
	   * use on the default implementation.
	   * @param dataId
	   */
	  _proto2.decComplexRef = function decComplexRef(dataId) {
	    return;
	  };

	  _proto2.time = function time(f) {
	    return notYetImplemented('time');
	  };

	  _proto2.read = function read(dataId) {
	    return notYetImplemented('read');
	  };

	  _proto2.readSync = function readSync(dataId) {
	    return notYetImplemented('readSync');
	  };

	  _proto2.numDataIds = function numDataIds() {
	    return notYetImplemented('numDataIds');
	  };

	  _proto2.disposeData = function disposeData(dataId) {
	    return notYetImplemented('disposeData');
	  };

	  _proto2.write = function write(values, shape, dtype) {
	    return notYetImplemented('write');
	  };

	  _proto2.move = function move(dataId, values, shape, dtype) {
	    return notYetImplemented('move');
	  };

	  _proto2.memory = function memory() {
	    return notYetImplemented('memory');
	  }
	  /** Returns the highest precision for floats in bits (e.g. 16 or 32) */
	  ;

	  _proto2.floatPrecision = function floatPrecision() {
	    return notYetImplemented('floatPrecision');
	  }
	  /** Returns the smallest representable number.  */
	  ;

	  _proto2.epsilon = function epsilon() {
	    return this.floatPrecision() === 32 ? EPSILON_FLOAT32 : EPSILON_FLOAT16;
	  };

	  _proto2.dispose = function dispose() {
	    return notYetImplemented('dispose');
	  };

	  return KernelBackend;
	}();

	function notYetImplemented(kernelName) {
	  throw new Error("'" + kernelName + "' not yet implemented or not found in the registry. " + "This kernel may not be supported by the tfjs backend you have chosen");
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */

	/**
	 * Shuffles the array in-place using Fisher-Yates algorithm.
	 *
	 * ```js
	 * const a = [1, 2, 3, 4, 5];
	 * tf.util.shuffle(a);
	 * console.log(a);
	 * ```
	 *
	 * @param array The array to shuffle in-place.
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */
	// tslint:disable-next-line:no-any
	function shuffle(array) {
	  var counter = array.length;
	  var temp = 0;
	  var index = 0; // While there are elements in the array

	  while (counter > 0) {
	    // Pick a random index
	    index = Math.random() * counter | 0; // Decrease counter by 1

	    counter--; // And swap the last element with it

	    temp = array[counter];
	    array[counter] = array[index];
	    array[index] = temp;
	  }
	}
	/**
	 * Shuffles two arrays in-place the same way using Fisher-Yates algorithm.
	 *
	 * ```js
	 * const a = [1,2,3,4,5];
	 * const b = [11,22,33,44,55];
	 * tf.util.shuffleCombo(a, b);
	 * console.log(a, b);
	 * ```
	 *
	 * @param array The first array to shuffle in-place.
	 * @param array2 The second array to shuffle in-place with the same permutation
	 *     as the first array.
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */
	// tslint:disable-next-line:no-any

	function shuffleCombo(array, // tslint:disable-next-line:no-any
	array2) {
	  if (array.length !== array2.length) {
	    throw Error("Array sizes must match to be shuffled together " + ("First array length was " + array.length) + ("Second array length was " + array2.length));
	  }

	  var counter = array.length;
	  var temp, temp2;
	  var index = 0; // While there are elements in the array

	  while (counter > 0) {
	    // Pick a random index
	    index = Math.random() * counter | 0; // Decrease counter by 1

	    counter--; // And swap the last element of each array with it

	    temp = array[counter];
	    temp2 = array2[counter];
	    array[counter] = array[index];
	    array2[counter] = array2[index];
	    array[index] = temp;
	    array2[index] = temp2;
	  }
	}
	/** Clamps a value to a specified range. */

	function clamp(min, x, max) {
	  return Math.max(min, Math.min(x, max));
	}
	function nearestLargerEven(val) {
	  return val % 2 === 0 ? val : val + 1;
	}
	function sum(arr) {
	  var sum = 0;

	  for (var i = 0; i < arr.length; i++) {
	    sum += arr[i];
	  }

	  return sum;
	}
	/**
	 * Returns a sample from a uniform [a, b) distribution.
	 *
	 * @param a The minimum support (inclusive).
	 * @param b The maximum support (exclusive).
	 * @return A pseudorandom number on the half-open interval [a,b).
	 */

	function randUniform(a, b) {
	  var r = Math.random();
	  return b * r + (1 - r) * a;
	}
	/** Returns the squared Euclidean distance between two vectors. */

	function distSquared(a, b) {
	  var result = 0;

	  for (var i = 0; i < a.length; i++) {
	    var diff = Number(a[i]) - Number(b[i]);
	    result += diff * diff;
	  }

	  return result;
	}
	/**
	 * Asserts that the expression is true. Otherwise throws an error with the
	 * provided message.
	 *
	 * ```js
	 * const x = 2;
	 * tf.util.assert(x === 2, 'x is not 2');
	 * ```
	 *
	 * @param expr The expression to assert (as a boolean).
	 * @param msg A function that returns the message to report when throwing an
	 *     error. We use a function for performance reasons.
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */

	function assert(expr, msg) {
	  if (!expr) {
	    throw new Error(typeof msg === 'string' ? msg : msg());
	  }
	}
	function assertShapesMatch(shapeA, shapeB, errorMessagePrefix) {
	  if (errorMessagePrefix === void 0) {
	    errorMessagePrefix = '';
	  }

	  assert(arraysEqual(shapeA, shapeB), function () {
	    return errorMessagePrefix + (" Shapes " + shapeA + " and " + shapeB + " must match");
	  });
	}
	function assertNonNull(a) {
	  assert(a != null, function () {
	    return "The input to the tensor constructor must be a non-null value.";
	  });
	} // NOTE: We explicitly type out what T extends instead of any so that
	// util.flatten on a nested array of number doesn't try to infer T as a
	// number[][], causing us to explicitly type util.flatten<number>().

	/**
	 *  Flattens an arbitrarily nested array.
	 *
	 * ```js
	 * const a = [[1, 2], [3, 4], [5, [6, [7]]]];
	 * const flat = tf.util.flatten(a);
	 * console.log(flat);
	 * ```
	 *
	 *  @param arr The nested array to flatten.
	 *  @param result The destination array which holds the elements.
	 *  @param skipTypedArray If true, avoids flattening the typed arrays. Defaults
	 *      to false.
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */

	function flatten(arr, result, skipTypedArray) {
	  if (result === void 0) {
	    result = [];
	  }

	  if (skipTypedArray === void 0) {
	    skipTypedArray = false;
	  }

	  if (result == null) {
	    result = [];
	  }

	  if (Array.isArray(arr) || isTypedArray$1(arr) && !skipTypedArray) {
	    for (var i = 0; i < arr.length; ++i) {
	      flatten(arr[i], result, skipTypedArray);
	    }
	  } else {
	    result.push(arr);
	  }

	  return result;
	}
	/**
	 * Returns the size (number of elements) of the tensor given its shape.
	 *
	 * ```js
	 * const shape = [3, 4, 2];
	 * const size = tf.util.sizeFromShape(shape);
	 * console.log(size);
	 * ```
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */

	function sizeFromShape(shape) {
	  if (shape.length === 0) {
	    // Scalar.
	    return 1;
	  }

	  var size = shape[0];

	  for (var i = 1; i < shape.length; i++) {
	    size *= shape[i];
	  }

	  return size;
	}
	function isScalarShape(shape) {
	  return shape.length === 0;
	}
	function arraysEqual(n1, n2) {
	  if (n1 === n2) {
	    return true;
	  }

	  if (n1 == null || n2 == null) {
	    return false;
	  }

	  if (n1.length !== n2.length) {
	    return false;
	  }

	  for (var i = 0; i < n1.length; i++) {
	    if (n1[i] !== n2[i]) {
	      return false;
	    }
	  }

	  return true;
	}
	function isInt(a) {
	  return a % 1 === 0;
	}
	function tanh(x) {
	  // tslint:disable-next-line:no-any
	  if (Math.tanh != null) {
	    // tslint:disable-next-line:no-any
	    return Math.tanh(x);
	  }

	  if (x === Infinity) {
	    return 1;
	  } else if (x === -Infinity) {
	    return -1;
	  } else {
	    var e2x = Math.exp(2 * x);
	    return (e2x - 1) / (e2x + 1);
	  }
	}
	function sizeToSquarishShape(size) {
	  var width = Math.ceil(Math.sqrt(size));
	  return [width, Math.ceil(size / width)];
	}
	/**
	 * Creates a new array with randomized indicies to a given quantity.
	 *
	 * ```js
	 * const randomTen = tf.util.createShuffledIndices(10);
	 * console.log(randomTen);
	 * ```
	 *
	 * @param number Quantity of how many shuffled indicies to create.
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */

	function createShuffledIndices(n) {
	  var shuffledIndices = new Uint32Array(n);

	  for (var i = 0; i < n; ++i) {
	    shuffledIndices[i] = i;
	  }

	  shuffle(shuffledIndices);
	  return shuffledIndices;
	}
	function rightPad(a, size) {
	  if (size <= a.length) {
	    return a;
	  }

	  return a + ' '.repeat(size - a.length);
	}
	function repeatedTry(checkFn, delayFn, maxCounter) {
	  if (delayFn === void 0) {
	    delayFn = function delayFn(counter) {
	      return 0;
	    };
	  }

	  return new Promise(function (resolve, reject) {
	    var tryCount = 0;

	    var tryFn = function tryFn() {
	      if (checkFn()) {
	        resolve();
	        return;
	      }

	      tryCount++;
	      var nextBackoff = delayFn(tryCount);

	      if (maxCounter != null && tryCount >= maxCounter) {
	        reject();
	        return;
	      }

	      setTimeout(tryFn, nextBackoff);
	    };

	    tryFn();
	  });
	}
	/**
	 * Given the full size of the array and a shape that may contain -1 as the
	 * implicit dimension, returns the inferred shape where -1 is replaced.
	 * E.g. For shape=[2, -1, 3] and size=24, it will return [2, 4, 3].
	 *
	 * @param shape The shape, which may contain -1 in some dimension.
	 * @param size The full size (number of elements) of the array.
	 * @return The inferred shape where -1 is replaced with the inferred size.
	 */

	function inferFromImplicitShape(shape, size) {
	  var shapeProd = 1;
	  var implicitIdx = -1;

	  for (var i = 0; i < shape.length; ++i) {
	    if (shape[i] >= 0) {
	      shapeProd *= shape[i];
	    } else if (shape[i] === -1) {
	      if (implicitIdx !== -1) {
	        throw Error("Shapes can only have 1 implicit size. " + ("Found -1 at dim " + implicitIdx + " and dim " + i));
	      }

	      implicitIdx = i;
	    } else if (shape[i] < 0) {
	      throw Error("Shapes can not be < 0. Found " + shape[i] + " at dim " + i);
	    }
	  }

	  if (implicitIdx === -1) {
	    if (size > 0 && size !== shapeProd) {
	      throw Error("Size(" + size + ") must match the product of shape " + shape);
	    }

	    return shape;
	  }

	  if (shapeProd === 0) {
	    throw Error("Cannot infer the missing size in [" + shape + "] when " + "there are 0 elements");
	  }

	  if (size % shapeProd !== 0) {
	    throw Error("The implicit shape can't be a fractional number. " + ("Got " + size + " / " + shapeProd));
	  }

	  var newShape = shape.slice();
	  newShape[implicitIdx] = size / shapeProd;
	  return newShape;
	}
	function parseAxisParam(axis, shape) {
	  var rank = shape.length; // Normalize input

	  axis = axis == null ? shape.map(function (s, i) {
	    return i;
	  }) : [].concat(axis); // Check for valid range

	  assert(axis.every(function (ax) {
	    return ax >= -rank && ax < rank;
	  }), function () {
	    return "All values in axis param must be in range [-" + rank + ", " + rank + ") but " + ("got axis " + axis);
	  }); // Check for only integers

	  assert(axis.every(function (ax) {
	    return isInt(ax);
	  }), function () {
	    return "All values in axis param must be integers but " + ("got axis " + axis);
	  }); // Handle negative axis.

	  return axis.map(function (a) {
	    return a < 0 ? rank + a : a;
	  });
	}
	/** Reduces the shape by removing all dimensions of shape 1. */

	function squeezeShape(shape, axis) {
	  var newShape = [];
	  var keptDims = [];
	  var isEmptyArray = axis != null && Array.isArray(axis) && axis.length === 0;
	  var axes = axis == null || isEmptyArray ? null : parseAxisParam(axis, shape).sort();
	  var j = 0;

	  for (var i = 0; i < shape.length; ++i) {
	    if (axes != null) {
	      if (axes[j] === i && shape[i] !== 1) {
	        throw new Error("Can't squeeze axis " + i + " since its dim '" + shape[i] + "' is not 1");
	      }

	      if ((axes[j] == null || axes[j] > i) && shape[i] === 1) {
	        newShape.push(shape[i]);
	        keptDims.push(i);
	      }

	      if (axes[j] <= i) {
	        j++;
	      }
	    }

	    if (shape[i] !== 1) {
	      newShape.push(shape[i]);
	      keptDims.push(i);
	    }
	  }

	  return {
	    newShape: newShape,
	    keptDims: keptDims
	  };
	}
	function getTypedArrayFromDType(dtype, size) {
	  var values = null;

	  if (dtype == null || dtype === 'float32') {
	    values = new Float32Array(size);
	  } else if (dtype === 'int32') {
	    values = new Int32Array(size);
	  } else if (dtype === 'bool') {
	    values = new Uint8Array(size);
	  } else {
	    throw new Error("Unknown data type " + dtype);
	  }

	  return values;
	}
	function getArrayFromDType(dtype, size) {
	  var values = null;

	  if (dtype == null || dtype === 'float32') {
	    values = new Float32Array(size);
	  } else if (dtype === 'int32') {
	    values = new Int32Array(size);
	  } else if (dtype === 'bool') {
	    values = new Uint8Array(size);
	  } else if (dtype === 'string') {
	    values = new Array(size);
	  } else {
	    throw new Error("Unknown data type " + dtype);
	  }

	  return values;
	}
	function checkConversionForErrors(vals, dtype) {
	  for (var i = 0; i < vals.length; i++) {
	    var num = vals[i];

	    if (isNaN(num) || !isFinite(num)) {
	      throw Error("A tensor of type " + dtype + " being uploaded contains " + num + ".");
	    }
	  }
	}
	/** Returns true if the dtype is valid. */

	function isValidDtype(dtype) {
	  return dtype === 'bool' || dtype === 'complex64' || dtype === 'float32' || dtype === 'int32' || dtype === 'string';
	}
	/**
	 * Returns true if the new type can't encode the old type without loss of
	 * precision.
	 */

	function hasEncodingLoss(oldType, newType) {
	  if (newType === 'complex64') {
	    return false;
	  }

	  if (newType === 'float32' && oldType !== 'complex64') {
	    return false;
	  }

	  if (newType === 'int32' && oldType !== 'float32' && oldType !== 'complex64') {
	    return false;
	  }

	  if (newType === 'bool' && oldType === 'bool') {
	    return false;
	  }

	  return true;
	}
	function isTypedArray$1(a) {
	  return a instanceof Float32Array || a instanceof Int32Array || a instanceof Uint8Array;
	}
	function bytesPerElement(dtype) {
	  if (dtype === 'float32' || dtype === 'int32') {
	    return 4;
	  } else if (dtype === 'complex64') {
	    return 8;
	  } else if (dtype === 'bool') {
	    return 1;
	  } else {
	    throw new Error("Unknown dtype " + dtype);
	  }
	}
	/**
	 * Returns the approximate number of bytes allocated in the string array - 2
	 * bytes per character. Computing the exact bytes for a native string in JS is
	 * not possible since it depends on the encoding of the html page that serves
	 * the website.
	 */

	function bytesFromStringArray(arr) {
	  if (arr == null) {
	    return 0;
	  }

	  var bytes = 0;
	  arr.forEach(function (x) {
	    return bytes += x.length;
	  });
	  return bytes;
	}
	/** Returns true if the value is a string. */

	function isString(value) {
	  return typeof value === 'string' || value instanceof String;
	}
	function isBoolean(value) {
	  return typeof value === 'boolean';
	}
	function isNumber(value) {
	  return typeof value === 'number';
	}
	function inferDtype(values) {
	  if (Array.isArray(values)) {
	    return inferDtype(values[0]);
	  }

	  if (values instanceof Float32Array) {
	    return 'float32';
	  } else if (values instanceof Int32Array || values instanceof Uint8Array) {
	    return 'int32';
	  } else if (isNumber(values)) {
	    return 'float32';
	  } else if (isString(values)) {
	    return 'string';
	  } else if (isBoolean(values)) {
	    return 'bool';
	  }

	  return 'float32';
	}
	function isFunction(f) {
	  return !!(f && f.constructor && f.call && f.apply);
	}
	function nearestDivisor(size, start) {
	  for (var i = start; i < size; ++i) {
	    if (size % i === 0) {
	      return i;
	    }
	  }

	  return size;
	}
	function computeStrides(shape) {
	  var rank = shape.length;

	  if (rank < 2) {
	    return [];
	  } // Last dimension has implicit stride of 1, thus having D-1 (instead of D)
	  // strides.


	  var strides = new Array(rank - 1);
	  strides[rank - 2] = shape[rank - 1];

	  for (var i = rank - 3; i >= 0; --i) {
	    strides[i] = strides[i + 1] * shape[i + 1];
	  }

	  return strides;
	}

	function createNestedArray(offset, shape, a) {
	  var ret = new Array();

	  if (shape.length === 1) {
	    var d = shape[0];

	    for (var i = 0; i < d; i++) {
	      ret[i] = a[offset + i];
	    }
	  } else {
	    var _d = shape[0];
	    var rest = shape.slice(1);
	    var len = rest.reduce(function (acc, c) {
	      return acc * c;
	    });

	    for (var _i = 0; _i < _d; _i++) {
	      ret[_i] = createNestedArray(offset + _i * len, rest, a);
	    }
	  }

	  return ret;
	} // Provide a nested array of TypedArray in given shape.


	function toNestedArray(shape, a) {
	  if (shape.length === 0) {
	    // Scalar type should return a single number.
	    return a[0];
	  }

	  var size = shape.reduce(function (acc, c) {
	    return acc * c;
	  });

	  if (size === 0) {
	    // A tensor with shape zero should be turned into empty list.
	    return [];
	  }

	  if (size !== a.length) {
	    throw new Error("[" + shape + "] does not match the input size " + a.length + ".");
	  }

	  return createNestedArray(0, shape, a);
	}
	function makeOnesTypedArray(size, dtype) {
	  var array = makeZerosTypedArray(size, dtype);

	  for (var i = 0; i < array.length; i++) {
	    array[i] = 1;
	  }

	  return array;
	}
	function makeZerosTypedArray(size, dtype) {
	  if (dtype == null || dtype === 'float32' || dtype === 'complex64') {
	    return new Float32Array(size);
	  } else if (dtype === 'int32') {
	    return new Int32Array(size);
	  } else if (dtype === 'bool') {
	    return new Uint8Array(size);
	  } else {
	    throw new Error("Unknown data type " + dtype);
	  }
	}
	/**
	 * Make nested `TypedArray` filled with zeros.
	 * @param shape The shape information for the nested array.
	 * @param dtype dtype of the array element.
	 */

	function makeZerosNestedTypedArray(shape, dtype) {
	  var size = shape.reduce(function (prev, curr) {
	    return prev * curr;
	  }, 1);

	  if (dtype == null || dtype === 'float32') {
	    return toNestedArray(shape, new Float32Array(size));
	  } else if (dtype === 'int32') {
	    return toNestedArray(shape, new Int32Array(size));
	  } else if (dtype === 'bool') {
	    return toNestedArray(shape, new Uint8Array(size));
	  } else {
	    throw new Error("Unknown data type " + dtype);
	  }
	}
	function assertNonNegativeIntegerDimensions(shape) {
	  shape.forEach(function (dimSize) {
	    assert(Number.isInteger(dimSize) && dimSize >= 0, function () {
	      return "Tensor must have a shape comprised of positive integers but got " + ("shape [" + shape + "].");
	    });
	  });
	}
	/**
	 * Computes flat index for a given location (multidimentionsal index) in a
	 * Tensor/multidimensional array.
	 *
	 * @param locs Location in the tensor.
	 * @param rank Rank of the tensor.
	 * @param strides Tensor strides.
	 */

	function locToIndex(locs, rank, strides) {
	  if (rank === 0) {
	    return 0;
	  } else if (rank === 1) {
	    return locs[0];
	  }

	  var index = locs[locs.length - 1];

	  for (var i = 0; i < locs.length - 1; ++i) {
	    index += strides[i] * locs[i];
	  }

	  return index;
	}
	/**
	 * Computes the location (multidimensional index) in a tensor/multidimentional
	 * array for a given flat index.
	 *
	 * @param index Index in flat array.
	 * @param rank Rank of tensor.
	 * @param strides Strides of tensor.
	 */

	function indexToLoc(index, rank, strides) {
	  if (rank === 0) {
	    return [];
	  } else if (rank === 1) {
	    return [index];
	  }

	  var locs = new Array(rank);

	  for (var i = 0; i < locs.length - 1; ++i) {
	    locs[i] = Math.floor(index / strides[i]);
	    index -= locs[i] * strides[i];
	  }

	  locs[locs.length - 1] = index;
	  return locs;
	}
	/**
	 * This method asserts whether an object is a Promise instance.
	 * @param object
	 */
	// tslint:disable-next-line: no-any

	function isPromise(object) {
	  //  We chose to not use 'obj instanceOf Promise' for two reasons:
	  //  1. It only reliably works for es6 Promise, not other Promise
	  //  implementations.
	  //  2. It doesn't work with framework that uses zone.js. zone.js monkey patch
	  //  the async calls, so it is possible the obj (patched) is comparing to a
	  //  pre-patched Promise.
	  return object && object.then && typeof object.then === 'function';
	}

	var TENSORFLOWJS_FLAGS_PREFIX = 'tfjsflags';
	/**
	 * The environment contains evaluated flags as well as the registered platform.
	 * This is always used as a global singleton and can be retrieved with
	 * `tf.env()`.
	 *
	 * @doc {heading: 'Environment'}
	 */

	var Environment = /*#__PURE__*/function () {
	  // tslint:disable-next-line: no-any
	  function Environment(global) {
	    this.global = global;
	    this.flags = {};
	    this.flagRegistry = {};
	    this.urlFlags = {};
	    this.populateURLFlags();
	  }

	  var _proto = Environment.prototype;

	  _proto.setPlatform = function setPlatform(platformName, platform) {
	    if (this.platform != null) {
	      console.warn("Platform " + this.platformName + " has already been set. " + ("Overwriting the platform with " + platform + "."));
	    }

	    this.platformName = platformName;
	    this.platform = platform;
	  };

	  _proto.registerFlag = function registerFlag(flagName, evaluationFn, setHook) {
	    this.flagRegistry[flagName] = {
	      evaluationFn: evaluationFn,
	      setHook: setHook
	    }; // Override the flag value from the URL. This has to happen here because the
	    // environment is initialized before flags get registered.

	    if (this.urlFlags[flagName] != null) {
	      var flagValue = this.urlFlags[flagName];
	      console.warn("Setting feature override from URL " + flagName + ": " + flagValue + ".");
	      this.set(flagName, flagValue);
	    }
	  };

	  _proto.getAsync = /*#__PURE__*/function () {
	    var _getAsync = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(flagName) {
	      return regeneratorRuntime.wrap(function _callee$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              if (!(flagName in this.flags)) {
	                _context.next = 2;
	                break;
	              }

	              return _context.abrupt("return", this.flags[flagName]);

	            case 2:
	              _context.next = 4;
	              return this.evaluateFlag(flagName);

	            case 4:
	              this.flags[flagName] = _context.sent;
	              return _context.abrupt("return", this.flags[flagName]);

	            case 6:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, _callee, this);
	    }));

	    function getAsync(_x) {
	      return _getAsync.apply(this, arguments);
	    }

	    return getAsync;
	  }();

	  _proto.get = function get(flagName) {
	    if (flagName in this.flags) {
	      return this.flags[flagName];
	    }

	    var flagValue = this.evaluateFlag(flagName);

	    if (isPromise(flagValue)) {
	      throw new Error("Flag " + flagName + " cannot be synchronously evaluated. " + "Please use getAsync() instead.");
	    }

	    this.flags[flagName] = flagValue;
	    return this.flags[flagName];
	  };

	  _proto.getNumber = function getNumber(flagName) {
	    return this.get(flagName);
	  };

	  _proto.getBool = function getBool(flagName) {
	    return this.get(flagName);
	  };

	  _proto.getFlags = function getFlags() {
	    return this.flags;
	  } // For backwards compatibility.
	  ;

	  _proto.set = function set(flagName, value) {
	    if (this.flagRegistry[flagName] == null) {
	      throw new Error("Cannot set flag " + flagName + " as it has not been registered.");
	    }

	    this.flags[flagName] = value;

	    if (this.flagRegistry[flagName].setHook != null) {
	      this.flagRegistry[flagName].setHook(value);
	    }
	  };

	  _proto.evaluateFlag = function evaluateFlag(flagName) {
	    if (this.flagRegistry[flagName] == null) {
	      throw new Error("Cannot evaluate flag '" + flagName + "': no evaluation function found.");
	    }

	    return this.flagRegistry[flagName].evaluationFn();
	  };

	  _proto.setFlags = function setFlags(flags) {
	    this.flags = Object.assign({}, flags);
	  };

	  _proto.reset = function reset() {
	    this.flags = {};
	    this.urlFlags = {};
	    this.populateURLFlags();
	  };

	  _proto.populateURLFlags = function populateURLFlags() {
	    var _this = this;

	    if (typeof this.global === 'undefined' || typeof this.global.location === 'undefined' || typeof this.global.location.search === 'undefined') {
	      return;
	    }

	    var urlParams = getQueryParams(this.global.location.search);

	    if (TENSORFLOWJS_FLAGS_PREFIX in urlParams) {
	      var keyValues = urlParams[TENSORFLOWJS_FLAGS_PREFIX].split(',');
	      keyValues.forEach(function (keyValue) {
	        var _keyValue$split = keyValue.split(':'),
	            key = _keyValue$split[0],
	            value = _keyValue$split[1];

	        _this.urlFlags[key] = parseValue(key, value);
	      });
	    }
	  };

	  _createClass(Environment, [{
	    key: "features",
	    get: function get() {
	      return this.flags;
	    }
	  }]);

	  return Environment;
	}();
	function getQueryParams(queryString) {
	  var params = {};
	  queryString.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g, function (s) {
	    for (var _len = arguments.length, t = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	      t[_key - 1] = arguments[_key];
	    }

	    decodeParam(params, t[0], t[1]);
	    return t.join('=');
	  });
	  return params;
	}

	function decodeParam(params, name, value) {
	  params[decodeURIComponent(name)] = decodeURIComponent(value || '');
	}

	function parseValue(flagName, value) {
	  value = value.toLowerCase();

	  if (value === 'true' || value === 'false') {
	    return value === 'true';
	  } else if ("" + +value === value) {
	    return +value;
	  }

	  throw new Error("Could not parse value flag value " + value + " for flag " + flagName + ".");
	}
	/**
	 * Returns the current environment (a global singleton).
	 *
	 * The environment object contains the evaluated feature values as well as the
	 * active platform.
	 *
	 * @doc {heading: 'Environment'}
	 */


	function env() {
	  return exports.ENV;
	}
	exports.ENV = null;
	function setEnvironmentGlobal(environment) {
	  exports.ENV = environment;
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	// Note that the identifier globalNameSpace is scoped to this module, but will
	// always resolve to the same global object regardless of how the module is
	// resolved.
	// tslint:disable-next-line:no-any
	var globalNameSpace; // tslint:disable-next-line:no-any

	function getGlobalNamespace() {
	  if (globalNameSpace == null) {
	    // tslint:disable-next-line:no-any
	    var ns;

	    if (typeof window !== 'undefined') {
	      ns = window;
	    } else if (typeof global !== 'undefined') {
	      ns = global;
	    } else if (typeof process !== 'undefined') {
	      ns = process;
	    } else if (typeof self !== 'undefined') {
	      ns = self;
	    } else {
	      throw new Error('Could not find a global object');
	    }

	    globalNameSpace = ns;
	  }

	  return globalNameSpace;
	} // tslint:disable-next-line:no-any

	function getGlobalMap() {
	  var ns = getGlobalNamespace();

	  if (ns._tfGlobals == null) {
	    ns._tfGlobals = new Map();
	  }

	  return ns._tfGlobals;
	}
	/**
	 * Returns a globally accessible 'singleton' object.
	 *
	 * @param key the name of the object
	 * @param init a function to initialize to initialize this object
	 *             the first time it is fetched.
	 */


	function getGlobal(key, init) {
	  var globalMap = getGlobalMap();

	  if (globalMap.has(key)) {
	    return globalMap.get(key);
	  } else {
	    var singleton = init();
	    globalMap.set(key, singleton);
	    return globalMap.get(key);
	  }
	}

	var Abs = 'Abs';
	var Acos = 'Acos';
	var Acosh = 'Acosh';
	var Add = 'Add';
	var AddN = 'AddN';
	var All = 'All';
	var Any = 'Any';
	var ArgMax = 'ArgMax';
	var ArgMin = 'ArgMin';
	var Asin = 'Asin';
	var Asinh = 'Asinh';
	var Atan = 'Atan';
	var Atanh = 'Atanh';
	var Atan2 = 'Atan2';
	var AvgPool = 'AvgPool';
	var AvgPoolGrad = 'AvgPoolGrad';
	var AvgPool3D = 'AvgPool3D';
	var AvgPool3DGrad = 'AvgPool3DGrad';
	var BatchMatMul = 'BatchMatMul';
	var BatchToSpaceND = 'BatchToSpaceND';
	var Bincount = 'Bincount';
	var BroadcastTo = 'BroadcastTo';
	var Cast = 'Cast';
	var Ceil = 'Ceil';
	var ClipByValue = 'ClipByValue';
	var Complex = 'Complex';
	var ComplexAbs = 'ComplexAbs';
	var Concat = 'Concat';
	var Conv2D = 'Conv2D';
	var Conv2DBackpropFilter = 'Conv2DBackpropFilter';
	var Conv2DBackpropInput = 'Conv2DBackpropInput';
	var Conv3D = 'Conv3D';
	var Conv3DBackpropFilterV2 = 'Conv3DBackpropFilterV2';
	var Conv3DBackpropInputV2 = 'Conv3DBackpropInputV2';
	var Cos = 'Cos';
	var Cosh = 'Cosh';
	var Cumsum = 'Cumsum';
	var CropAndResize = 'CropAndResize';
	var DenseBincount = 'DenseBincount';
	var DepthToSpace = 'DepthToSpace';
	var DepthwiseConv2dNative = 'DepthwiseConv2dNative';
	var DepthwiseConv2dNativeBackpropFilter = 'DepthwiseConv2dNativeBackpropFilter';
	var DepthwiseConv2dNativeBackpropInput = 'DepthwiseConv2dNativeBackpropInput';
	var Diag = 'Diag';
	var Dilation2D = 'Dilation2D';
	var Dilation2DBackpropInput = 'Dilation2DBackpropInput';
	var Dilation2DBackpropFilter = 'Dilation2DBackpropFilter';
	var RealDiv = 'RealDiv';
	var Elu = 'Elu';
	var EluGrad = 'EluGrad';
	var Erf = 'Erf';
	var Equal = 'Equal';
	var Exp = 'Exp';
	var ExpandDims = 'ExpandDims';
	var Expm1 = 'Expm1';
	var FFT = 'FFT';
	var Fill = 'Fill';
	var FlipLeftRight = 'FlipLeftRight';
	var Floor = 'Floor';
	var FloorDiv = 'FloorDiv';
	var FusedBatchNorm = 'FusedBatchNorm';
	var GatherV2 = 'GatherV2';
	var GatherNd = 'GatherNd';
	var Greater = 'Greater';
	var GreaterEqual = 'GreaterEqual';
	var Identity = 'Identity';
	var IFFT = 'IFFT';
	var Imag = 'Imag';
	var IsFinite = 'IsFinite';
	var IsInf = 'IsInf';
	var IsNan = 'IsNan';
	var LeakyRelu = 'LeakyRelu';
	var Less = 'Less';
	var LessEqual = 'LessEqual';
	var LinSpace = 'LinSpace';
	var Log = 'Log';
	var Log1p = 'Log1p';
	var LogicalAnd = 'LogicalAnd';
	var LogicalNot = 'LogicalNot';
	var LogicalOr = 'LogicalOr';
	var LogSoftmax = 'LogSoftmax';
	var LRN = 'LRN';
	var LRNGrad = 'LRNGrad';
	var Max = 'Max';
	var Maximum = 'Maximum';
	var MaxPool = 'MaxPool';
	var MaxPoolGrad = 'MaxPoolGrad';
	var MaxPool3D = 'MaxPool3D';
	var MaxPool3DGrad = 'MaxPool3DGrad';
	var MaxPoolWithArgmax = 'MaxPoolWithArgmax';
	var Mean = 'Mean';
	var Min = 'Min';
	var Minimum = 'Minimum';
	var MirrorPad = 'MirrorPad';
	var Mod = 'Mod';
	var Multinomial = 'Multinomial';
	var Multiply = 'Multiply';
	var Neg = 'Neg';
	var NotEqual = 'NotEqual';
	var NonMaxSuppressionV3 = 'NonMaxSuppressionV3';
	var NonMaxSuppressionV4 = 'NonMaxSuppressionV4';
	var NonMaxSuppressionV5 = 'NonMaxSuppressionV5';
	var OnesLike = 'OnesLike';
	var OneHot = 'OneHot';
	var Pack = 'Pack';
	var PadV2 = 'PadV2';
	var Pool = 'Pool';
	var Pow = 'Pow';
	var Prelu = 'Prelu';
	var Prod = 'Prod';
	var Range = 'Range';
	var Real = 'Real';
	var Reciprocal = 'Reciprocal';
	var Relu = 'Relu';
	var Reshape = 'Reshape';
	var ResizeNearestNeighbor = 'ResizeNearestNeighbor';
	var ResizeNearestNeighborGrad = 'ResizeNearestNeighborGrad';
	var ResizeBilinear = 'ResizeBilinear';
	var ResizeBilinearGrad = 'ResizeBilinearGrad';
	var Relu6 = 'Relu6';
	var Reverse = 'Reverse';
	var Round = 'Round';
	var Rsqrt = 'Rsqrt';
	var ScatterNd = 'ScatterNd';
	var Select = 'Select';
	var Selu = 'Selu';
	var Slice = 'Slice';
	var Sin = 'Sin';
	var Sinh = 'Sinh';
	var Sign = 'Sign';
	var Sigmoid = 'Sigmoid';
	var Softplus = 'Softplus';
	var Sqrt = 'Sqrt';
	var Sum = 'Sum';
	var SpaceToBatchND = 'SpaceToBatchND';
	var SplitV = 'SplitV';
	var Softmax = 'Softmax';
	var SquaredDifference = 'SquaredDifference';
	var Square = 'Square';
	var Sub = 'Sub';
	var SparseToDense = 'SparseToDense';
	var StridedSlice = 'StridedSlice';
	var Tan = 'Tan';
	var Tanh = 'Tanh';
	var Tile = 'Tile';
	var TopK = 'TopK';
	var Transpose = 'Transpose';
	var Unique = 'Unique';
	var Unpack = 'Unpack';
	var UnsortedSegmentSum = 'UnsortedSegmentSum';
	var ZerosLike = 'ZerosLike';
	/**
	 * TensorFlow.js-only kernels
	 */

	var Step = 'Step';
	var FromPixels = 'FromPixels';
	var RotateWithOffset = 'RotateWithOffset';
	var _FusedMatMul = '_FusedMatMul';
	var FusedConv2D = 'FusedConv2D';
	var FusedDepthwiseConv2D = 'FusedDepthwiseConv2D';

	/**
	 * @license
	 * Copyright 2019 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var kernelRegistry = getGlobal('kernelRegistry', function () {
	  return new Map();
	});
	var gradRegistry = getGlobal('gradRegistry', function () {
	  return new Map();
	});
	/**
	 * Returns the kernel function (code) associated with the provided names.
	 *
	 * @param kernelName The official name of the kernel.
	 * @param backendName The official name of the backend.
	 */

	function getKernel(kernelName, backendName) {
	  var key = makeKey(kernelName, backendName);
	  return kernelRegistry.get(key);
	}
	/**
	 * Returns the registered gradient info associated with the provided kernel.
	 * @param kernelName The official TF kernel name.
	 */

	function getGradient(kernelName) {
	  return gradRegistry.get(kernelName);
	}
	function getKernelsForBackend(backendName) {
	  var it = kernelRegistry.entries();
	  var result = [];

	  while (true) {
	    var _it$next = it.next(),
	        done = _it$next.done,
	        value = _it$next.value;

	    if (done) {
	      break;
	    }

	    var key = value[0],
	        config = value[1];

	    var _key$split = key.split('_'),
	        backend = _key$split[0];

	    if (backend === backendName) {
	      result.push(config);
	    }
	  }

	  return result;
	}
	/**
	 * Registers the function (forward pass) for the kernel in a global registry.
	 *
	 * @param config A config object with the following properties:
	 * - `kernelName` The official name of the kernel.
	 * - `backendName` The official name of the backend.
	 * - `kernelFunc` The function to run during the forward pass of the kernel.
	 * - `setupFunc` Optional. Gets called once, after the backend initializes.
	 * - `disposeFunc` Optional. Gets called once, right before the backend is
	 * disposed.
	 */

	function registerKernel(config) {
	  var kernelName = config.kernelName,
	      backendName = config.backendName;
	  var key = makeKey(kernelName, backendName);

	  if (kernelRegistry.has(key)) {
	    console.warn("The kernel '" + kernelName + "' for backend " + ("'" + backendName + "' is already registered"));
	  }

	  kernelRegistry.set(key, config);
	}
	/**
	 * Registers a gradient function for a given kernel in the global registry,
	 * to be used during the back-propagation of that kernel.
	 *
	 * @param config An object with the following properties:
	 * - `kernelName` The name of the kernel that the gradient function is for.
	 * - `gradFunc` The function to run during back-propagation.
	 */

	function registerGradient(config) {
	  var kernelName = config.kernelName;

	  if (gradRegistry.has(kernelName)) {
	    // TODO (yassogba) after 3.0 assess whether we need to keep this gated
	    // to debug mode.
	    if (env().getBool('DEBUG')) {
	      console.warn("Overriding the gradient for '" + kernelName + "'");
	    }
	  }

	  gradRegistry.set(kernelName, config);
	}
	/**
	 * Removes the kernel function from the registry.
	 *
	 * @param kernelName The official name of the kernel.
	 * @param backendName The official name of the backend.
	 *
	 */

	function unregisterKernel(kernelName, backendName) {
	  var key = makeKey(kernelName, backendName);

	  if (!kernelRegistry.has(key)) {
	    throw new Error("The kernel '" + kernelName + "' for backend " + ("'" + backendName + "' is not registered"));
	  }

	  kernelRegistry.delete(key);
	}
	/** Removes the registered gradient from the global registry. */

	function unregisterGradient(kernelName) {
	  if (!gradRegistry.has(kernelName)) {
	    throw new Error("The gradient '" + kernelName + "' for backend is not registered");
	  }

	  gradRegistry.delete(kernelName);
	}
	/**
	 * Finds kernels that have already been registered to a backend and re-registers
	 * them for a new backend. Useful for registering custom backends.
	 * @param registeredBackendName Already registered backend.
	 * @param newBackendName New backend.
	 */

	function copyRegisteredKernels(registeredBackendName, newBackendName) {
	  var kernels = getKernelsForBackend(registeredBackendName);
	  kernels.forEach(function (kernelConfig) {
	    var newKernelConfig = Object.assign({}, kernelConfig, {
	      backendName: newBackendName
	    });
	    registerKernel(newKernelConfig);
	  });
	}

	function makeKey(kernelName, backendName) {
	  return backendName + "_" + kernelName;
	}

	/**
	 * @license
	 * Copyright 2017 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Create typed array for scalar value. Used for storing in `DataStorage`.
	 */

	function createScalarValue(value, dtype) {
	  if (dtype === 'string') {
	    return encodeString(value);
	  }

	  return toTypedArray([value], dtype);
	}

	function noConversionNeeded(a, dtype) {
	  return a instanceof Float32Array && dtype === 'float32' || a instanceof Int32Array && dtype === 'int32' || a instanceof Uint8Array && dtype === 'bool';
	}

	function toTypedArray(a, dtype) {
	  if (dtype === 'string') {
	    throw new Error('Cannot convert a string[] to a TypedArray');
	  }

	  if (Array.isArray(a)) {
	    a = flatten(a);
	  }

	  if (env().getBool('DEBUG')) {
	    checkConversionForErrors(a, dtype);
	  }

	  if (noConversionNeeded(a, dtype)) {
	    return a;
	  }

	  if (dtype == null || dtype === 'float32' || dtype === 'complex64') {
	    return new Float32Array(a);
	  } else if (dtype === 'int32') {
	    return new Int32Array(a);
	  } else if (dtype === 'bool') {
	    var bool = new Uint8Array(a.length);

	    for (var i = 0; i < bool.length; ++i) {
	      if (Math.round(a[i]) !== 0) {
	        bool[i] = 1;
	      }
	    }

	    return bool;
	  } else {
	    throw new Error("Unknown data type " + dtype);
	  }
	}
	/**
	 * Returns the current high-resolution time in milliseconds relative to an
	 * arbitrary time in the past. It works across different platforms (node.js,
	 * browsers).
	 *
	 * ```js
	 * console.log(tf.util.now());
	 * ```
	 *
	 * @doc {heading: 'Util', namespace: 'util'}
	 */

	function now() {
	  return env().platform.now();
	}
	/**
	 * Returns a platform-specific implementation of
	 * [`fetch`](https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API).
	 *
	 * If `fetch` is defined on the global object (`window`, `process`, etc.),
	 * `tf.util.fetch` returns that function.
	 *
	 * If not, `tf.util.fetch` returns a platform-specific solution.
	 *
	 * ```js
	 * const resource = await tf.util.fetch('https://unpkg.com/@tensorflow/tfjs');
	 * // handle response
	 * ```
	 *
	 * @doc {heading: 'Util'}
	 */

	function fetch$1(path, requestInits) {
	  return env().platform.fetch(path, requestInits);
	}
	/**
	 * Encodes the provided string into bytes using the provided encoding scheme.
	 *
	 * @param s The string to encode.
	 * @param encoding The encoding scheme. Defaults to utf-8.
	 *
	 * @doc {heading: 'Util'}
	 */

	function encodeString(s, encoding) {
	  if (encoding === void 0) {
	    encoding = 'utf-8';
	  }

	  encoding = encoding || 'utf-8';
	  return env().platform.encode(s, encoding);
	}
	/**
	 * Decodes the provided bytes into a string using the provided encoding scheme.
	 * @param bytes The bytes to decode.
	 *
	 * @param encoding The encoding scheme. Defaults to utf-8.
	 *
	 * @doc {heading: 'Util'}
	 */

	function decodeString(bytes, encoding) {
	  if (encoding === void 0) {
	    encoding = 'utf-8';
	  }

	  encoding = encoding || 'utf-8';
	  return env().platform.decode(bytes, encoding);
	}

	var util = {
		__proto__: null,
		createScalarValue: createScalarValue,
		toTypedArray: toTypedArray,
		now: now,
		fetch: fetch$1,
		encodeString: encodeString,
		decodeString: decodeString,
		shuffle: shuffle,
		shuffleCombo: shuffleCombo,
		clamp: clamp,
		nearestLargerEven: nearestLargerEven,
		sum: sum,
		randUniform: randUniform,
		distSquared: distSquared,
		assert: assert,
		assertShapesMatch: assertShapesMatch,
		assertNonNull: assertNonNull,
		flatten: flatten,
		sizeFromShape: sizeFromShape,
		isScalarShape: isScalarShape,
		arraysEqual: arraysEqual,
		isInt: isInt,
		tanh: tanh,
		sizeToSquarishShape: sizeToSquarishShape,
		createShuffledIndices: createShuffledIndices,
		rightPad: rightPad,
		repeatedTry: repeatedTry,
		inferFromImplicitShape: inferFromImplicitShape,
		parseAxisParam: parseAxisParam,
		squeezeShape: squeezeShape,
		getTypedArrayFromDType: getTypedArrayFromDType,
		getArrayFromDType: getArrayFromDType,
		checkConversionForErrors: checkConversionForErrors,
		isValidDtype: isValidDtype,
		hasEncodingLoss: hasEncodingLoss,
		isTypedArray: isTypedArray$1,
		bytesPerElement: bytesPerElement,
		bytesFromStringArray: bytesFromStringArray,
		isString: isString,
		isBoolean: isBoolean,
		isNumber: isNumber,
		inferDtype: inferDtype,
		isFunction: isFunction,
		nearestDivisor: nearestDivisor,
		computeStrides: computeStrides,
		toNestedArray: toNestedArray,
		makeOnesTypedArray: makeOnesTypedArray,
		makeZerosTypedArray: makeZerosTypedArray,
		makeZerosNestedTypedArray: makeZerosNestedTypedArray,
		assertNonNegativeIntegerDimensions: assertNonNegativeIntegerDimensions,
		locToIndex: locToIndex,
		indexToLoc: indexToLoc,
		isPromise: isPromise
	};

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var Profiler = /*#__PURE__*/function () {
	  function Profiler(backendTimer, logger) {
	    this.backendTimer = backendTimer;
	    this.logger = logger;

	    if (logger == null) {
	      this.logger = new Logger();
	    }
	  }

	  var _proto = Profiler.prototype;

	  _proto.profileKernel = function profileKernel(kernelName, inputs, f) {
	    var outputs;

	    var holdResultWrapperFn = function holdResultWrapperFn() {
	      outputs = f();
	    };

	    var timer = this.backendTimer.time(holdResultWrapperFn);

	    if (env().getBool('CHECK_COMPUTATION_FOR_ERRORS')) {
	      var _loop = function _loop(i) {
	        var output = outputs[i]; // Dangling promise here because we don't want to propagate up
	        // asynchronicity.

	        output.data().then(function (tensorVals) {
	          checkComputationForErrors(tensorVals, output.dtype, kernelName);
	        });
	      };

	      for (var i = 0; i < outputs.length; i++) {
	        _loop(i);
	      }
	    }

	    var kernelProfile = {
	      kernelName: kernelName,
	      outputs: outputs,
	      inputs: inputs,
	      timeMs: timer.then(function (timing) {
	        return timing.kernelMs;
	      }),
	      extraInfo: timer.then(function (timing) {
	        return timing.getExtraProfileInfo != null ? timing.getExtraProfileInfo() : '';
	      })
	    };
	    return kernelProfile;
	  };

	  _proto.logKernelProfile = function logKernelProfile(kernelProfile) {
	    var _this = this;

	    var kernelName = kernelProfile.kernelName,
	        outputs = kernelProfile.outputs,
	        timeMs = kernelProfile.timeMs,
	        inputs = kernelProfile.inputs,
	        extraInfo = kernelProfile.extraInfo;
	    outputs.forEach(function (result) {
	      Promise.all([result.data(), timeMs, extraInfo]).then(function (valueContainer) {
	        _this.logger.logKernelProfile(kernelName, result, valueContainer[0], valueContainer[1], inputs, valueContainer[2]);
	      });
	    });
	  };

	  return Profiler;
	}();
	function checkComputationForErrors(vals, dtype, kernelName) {
	  if (dtype !== 'float32') {
	    // Only floating point computations will generate NaN values
	    return false;
	  }

	  for (var i = 0; i < vals.length; i++) {
	    var num = vals[i];

	    if (isNaN(num) || !isFinite(num)) {
	      // Throwing custom exception so behavior is testable.
	      console.warn("Found " + num + " in the result of '" + kernelName + "'");
	      return true;
	    }
	  }

	  return false;
	}
	var Logger = /*#__PURE__*/function () {
	  function Logger() {}

	  var _proto2 = Logger.prototype;

	  _proto2.logKernelProfile = function logKernelProfile(name, result, vals, timeMs, inputs, extraInfo) {
	    var time = typeof timeMs === 'number' ? rightPad(timeMs + "ms", 9) : timeMs['error'];
	    var paddedName = rightPad(name, 25);
	    var rank = result.rank;
	    var size = result.size;
	    var shape = rightPad(result.shape.toString(), 14);
	    var inputShapesDescription = '';

	    for (var _name in inputs) {
	      var input = inputs[_name];

	      if (input != null) {
	        // The input might be a non-tensor (e.g HTMLImageElement), in which case
	        // we claim the output shape as input shape.
	        var inputShape = input.shape || result.shape;
	        var inputRank = inputShape.length;
	        inputShapesDescription += _name + ": " + inputRank + "D " + (inputRank > 0 ? inputShape : '') + " ";
	      }
	    }

	    console.log("%c" + paddedName + "\t%c" + time + "\t%c" + rank + "D " + shape + "\t%c" + size + "\t%c" + inputShapesDescription + "\t%c" + extraInfo, 'font-weight:bold', 'color:red', 'color:blue', 'color: orange', 'color: green', 'color: steelblue');
	  };

	  return Logger;
	}();

	/**
	 * @license
	 * Copyright 2017 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes a list of TapeNodes that connect x to y, filtering everything else
	 * out and preserving the order of the original tape elements.
	 *
	 * @param tape The tape elements to filter.
	 * @param xs The input Tensors.
	 * @param y The output Tensor.
	 */

	function getFilteredNodesXToY(tape, xs, y) {
	  // Forward pass to compute all the nodes and Tensors that are transitively a
	  // function of x.
	  var tensorsFromX = {};
	  var nodesFromX = {};

	  for (var i = 0; i < xs.length; i++) {
	    tensorsFromX[xs[i].id] = true;
	  }

	  for (var _i = 0; _i < tape.length; _i++) {
	    var node = tape[_i];
	    var nodeInputs = node.inputs;

	    for (var inputName in nodeInputs) {
	      var input = nodeInputs[inputName];
	      var anyInputFromX = false;

	      for (var j = 0; j < xs.length; j++) {
	        if (tensorsFromX[input.id]) {
	          node.outputs.forEach(function (output) {
	            return tensorsFromX[output.id] = true;
	          });
	          anyInputFromX = true;
	          nodesFromX[node.id] = true;
	          break;
	        }
	      }

	      if (anyInputFromX) {
	        break;
	      }
	    }
	  } // Backward pass to find all of the nodes and Tensors that lead to y.


	  var tensorsLeadToY = {};
	  tensorsLeadToY[y.id] = true;
	  var nodesToY = {};

	  for (var _i2 = tape.length - 1; _i2 >= 0; _i2--) {
	    var _node = tape[_i2];
	    var _nodeInputs = _node.inputs; // If any of the outputs lead to y, mark all of the inputs as leading to y.

	    for (var _j = 0; _j < _node.outputs.length; _j++) {
	      if (tensorsLeadToY[_node.outputs[_j].id]) {
	        for (var _inputName in _nodeInputs) {
	          tensorsLeadToY[_nodeInputs[_inputName].id] = true;
	          nodesToY[_node.id] = true;
	        }

	        break;
	      }
	    }
	  } // Return the paths that come from x and lead to y.


	  var filteredTape = [];

	  for (var _i3 = 0; _i3 < tape.length; _i3++) {
	    var _node2 = tape[_i3];

	    if (nodesFromX[_node2.id] && nodesToY[_node2.id]) {
	      // Prune the inputs from the node that aren't a function of x.
	      var prunedInputs = {};

	      for (var _inputName2 in _node2.inputs) {
	        var nodeInput = _node2.inputs[_inputName2];

	        if (tensorsFromX[nodeInput.id]) {
	          prunedInputs[_inputName2] = nodeInput;
	        }
	      } // Copy the node and overwrite inputsAndArgs to the pruned version.


	      var prunedNode = Object.assign({}, _node2);
	      prunedNode.inputs = prunedInputs;
	      prunedNode.outputs = _node2.outputs;
	      filteredTape.push(prunedNode);
	    }
	  }

	  return filteredTape;
	}
	/**
	 * Backpropagate gradients through the filtered TapeNodes.
	 *
	 * @param tensorAccumulatedGradientMap A map of Tensor to its gradient. This map
	 * is mutated by this method.
	 * @param filteredTape The filtered TapeNodes to backprop through.
	 */

	function backpropagateGradients(tensorAccumulatedGradientMap, filteredTape, tidy, add) {
	  var _loop = function _loop(i) {
	    var node = filteredTape[i];
	    var dys = [];
	    node.outputs.forEach(function (o) {
	      var gradTensor = tensorAccumulatedGradientMap[o.id];

	      if (gradTensor != null) {
	        dys.push(gradTensor);
	      } else {
	        // This particular output is not in the back-propagation subgraph, so it
	        // does not affect the final output, thus we put null for its dy.
	        dys.push(null);
	      }
	    });

	    if (node.gradient == null) {
	      throw new Error("Cannot compute gradient: gradient function not found " + ("for " + node.kernelName + "."));
	    } // Backprop dy through this node and accumulate gradients over the inputs.


	    var inputGradients = node.gradient(dys);

	    var _loop2 = function _loop2(inputName) {
	      if (!(inputName in inputGradients)) {
	        throw new Error("Cannot backprop through input " + inputName + ". " + ("Available gradients found: " + Object.keys(inputGradients) + "."));
	      } // Call the gradient function.


	      var dx = tidy(function () {
	        return inputGradients[inputName]();
	      });

	      if (dx.dtype !== 'float32') {
	        throw new Error("Error in gradient for op " + node.kernelName + ". The gradient of input " + (inputName + " must have 'float32' dtype, but has '" + dx.dtype + "'"));
	      }

	      var x = node.inputs[inputName];

	      if (!arraysEqual(dx.shape, x.shape)) {
	        throw new Error("Error in gradient for op " + node.kernelName + ". The gradient of input " + ("'" + inputName + "' has shape '" + dx.shape + "', which does not match ") + ("the shape of the input '" + x.shape + "'"));
	      }

	      if (tensorAccumulatedGradientMap[x.id] == null) {
	        tensorAccumulatedGradientMap[x.id] = dx;
	      } else {
	        var curGradient = tensorAccumulatedGradientMap[x.id];
	        tensorAccumulatedGradientMap[x.id] = add(curGradient, dx);
	        curGradient.dispose();
	      }
	    };

	    for (var inputName in node.inputs) {
	      _loop2(inputName);
	    }
	  };

	  // Walk the tape backward and keep a map of Tensor to its gradient.
	  for (var i = filteredTape.length - 1; i >= 0; i--) {
	    _loop(i);
	  }
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */

	var FORMAT_LIMIT_NUM_VALS = 20; // Number of first and last values to show when displaying a, b,...,y, z.

	var FORMAT_NUM_FIRST_LAST_VALS = 3; // Number of significant digits to show.

	var FORMAT_NUM_SIG_DIGITS = 7;
	function tensorToString(vals, shape, dtype, verbose) {
	  var strides = computeStrides(shape);
	  var padPerCol = computeMaxSizePerColumn(vals, shape, dtype, strides);
	  var rank = shape.length;
	  var valsLines = subTensorToString(vals, shape, dtype, strides, padPerCol);
	  var lines = ['Tensor'];

	  if (verbose) {
	    lines.push("  dtype: " + dtype);
	    lines.push("  rank: " + rank);
	    lines.push("  shape: [" + shape + "]");
	    lines.push("  values:");
	  }

	  lines.push(valsLines.map(function (l) {
	    return '    ' + l;
	  }).join('\n'));
	  return lines.join('\n');
	}

	function computeMaxSizePerColumn(vals, shape, dtype, strides) {
	  var n = sizeFromShape(shape);
	  var numCols = strides[strides.length - 1];
	  var padPerCol = new Array(numCols).fill(0);
	  var rank = shape.length;
	  var valuesOrTuples = dtype === 'complex64' ? createComplexTuples(vals) : vals;

	  if (rank > 1) {
	    for (var row = 0; row < n / numCols; row++) {
	      var offset = row * numCols;

	      for (var j = 0; j < numCols; j++) {
	        padPerCol[j] = Math.max(padPerCol[j], valToString(valuesOrTuples[offset + j], 0, dtype).length);
	      }
	    }
	  }

	  return padPerCol;
	}

	function valToString(val, pad, dtype) {
	  var valStr;

	  if (Array.isArray(val)) {
	    valStr = parseFloat(val[0].toFixed(FORMAT_NUM_SIG_DIGITS)) + " + " + (parseFloat(val[1].toFixed(FORMAT_NUM_SIG_DIGITS)) + "j");
	  } else if (isString(val)) {
	    valStr = "'" + val + "'";
	  } else if (dtype === 'bool') {
	    valStr = boolNumToString(val);
	  } else {
	    valStr = parseFloat(val.toFixed(FORMAT_NUM_SIG_DIGITS)).toString();
	  }

	  return rightPad(valStr, pad);
	}

	function boolNumToString(v) {
	  return v === 0 ? 'false' : 'true';
	}

	function subTensorToString(vals, shape, dtype, strides, padPerCol, isLast) {
	  if (isLast === void 0) {
	    isLast = true;
	  }

	  var storagePerElement = dtype === 'complex64' ? 2 : 1;
	  var size = shape[0];
	  var rank = shape.length;

	  if (rank === 0) {
	    if (dtype === 'complex64') {
	      var complexTuple = createComplexTuples(vals);
	      return [valToString(complexTuple[0], 0, dtype)];
	    }

	    if (dtype === 'bool') {
	      return [boolNumToString(vals[0])];
	    }

	    return [vals[0].toString()];
	  }

	  if (rank === 1) {
	    if (size > FORMAT_LIMIT_NUM_VALS) {
	      var firstValsSize = FORMAT_NUM_FIRST_LAST_VALS * storagePerElement;
	      var firstVals = Array.from(vals.slice(0, firstValsSize));
	      var lastVals = Array.from(vals.slice((size - FORMAT_NUM_FIRST_LAST_VALS) * storagePerElement, size * storagePerElement));

	      if (dtype === 'complex64') {
	        firstVals = createComplexTuples(firstVals);
	        lastVals = createComplexTuples(lastVals);
	      }

	      return ['[' + firstVals.map(function (x, i) {
	        return valToString(x, padPerCol[i], dtype);
	      }).join(', ') + ', ..., ' + lastVals.map(function (x, i) {
	        return valToString(x, padPerCol[size - FORMAT_NUM_FIRST_LAST_VALS + i], dtype);
	      }).join(', ') + ']'];
	    }

	    var displayVals = dtype === 'complex64' ? createComplexTuples(vals) : Array.from(vals);
	    return ['[' + displayVals.map(function (x, i) {
	      return valToString(x, padPerCol[i], dtype);
	    }).join(', ') + ']'];
	  } // The array is rank 2 or more.


	  var subshape = shape.slice(1);
	  var substrides = strides.slice(1);
	  var stride = strides[0] * storagePerElement;
	  var lines = [];

	  if (size > FORMAT_LIMIT_NUM_VALS) {
	    for (var i = 0; i < FORMAT_NUM_FIRST_LAST_VALS; i++) {
	      var start = i * stride;
	      var end = start + stride;
	      lines.push.apply(lines, subTensorToString(vals.slice(start, end), subshape, dtype, substrides, padPerCol, false
	      /* isLast */
	      ));
	    }

	    lines.push('...');

	    for (var _i = size - FORMAT_NUM_FIRST_LAST_VALS; _i < size; _i++) {
	      var _start = _i * stride;

	      var _end = _start + stride;

	      lines.push.apply(lines, subTensorToString(vals.slice(_start, _end), subshape, dtype, substrides, padPerCol, _i === size - 1
	      /* isLast */
	      ));
	    }
	  } else {
	    for (var _i2 = 0; _i2 < size; _i2++) {
	      var _start2 = _i2 * stride;

	      var _end2 = _start2 + stride;

	      lines.push.apply(lines, subTensorToString(vals.slice(_start2, _end2), subshape, dtype, substrides, padPerCol, _i2 === size - 1
	      /* isLast */
	      ));
	    }
	  }

	  var sep = rank === 2 ? ',' : '';
	  lines[0] = '[' + lines[0] + sep;

	  for (var _i3 = 1; _i3 < lines.length - 1; _i3++) {
	    lines[_i3] = ' ' + lines[_i3] + sep;
	  }

	  var newLineSep = ',\n';

	  for (var _i4 = 2; _i4 < rank; _i4++) {
	    newLineSep += '\n';
	  }

	  lines[lines.length - 1] = ' ' + lines[lines.length - 1] + ']' + (isLast ? '' : newLineSep);
	  return lines;
	}

	function createComplexTuples(vals) {
	  var complexTuples = [];

	  for (var i = 0; i < vals.length; i += 2) {
	    complexTuples.push([vals[i], vals[i + 1]]);
	  }

	  return complexTuples;
	}

	/**
	 * A mutable object, similar to `tf.Tensor`, that allows users to set values
	 * at locations before converting to an immutable `tf.Tensor`.
	 *
	 * See `tf.buffer` for creating a tensor buffer.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Classes'}
	 */

	var TensorBuffer = /*#__PURE__*/function () {
	  function TensorBuffer(shape, dtype, values) {
	    var _this = this;

	    this.dtype = dtype;
	    this.shape = shape.slice();
	    this.size = sizeFromShape(shape);

	    if (values != null) {
	      var n = values.length;
	      assert(n === this.size, function () {
	        return "Length of values '" + n + "' does not match the size " + ("inferred by the shape '" + _this.size + "'.");
	      });
	    }

	    if (dtype === 'complex64') {
	      throw new Error("complex64 dtype TensorBuffers are not supported. Please create " + "a TensorBuffer for the real and imaginary parts separately and " + "call tf.complex(real, imag).");
	    }

	    this.values = values || getArrayFromDType(dtype, this.size);
	    this.strides = computeStrides(shape);
	  }
	  /**
	   * Sets a value in the buffer at a given location.
	   *
	   * @param value The value to set.
	   * @param locs  The location indices.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Creation'}
	   */


	  var _proto = TensorBuffer.prototype;

	  _proto.set = function set(value) {
	    var _this2 = this;

	    for (var _len = arguments.length, locs = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	      locs[_key - 1] = arguments[_key];
	    }

	    if (locs.length === 0) {
	      locs = [0];
	    }

	    assert(locs.length === this.rank, function () {
	      return "The number of provided coordinates (" + locs.length + ") must " + ("match the rank (" + _this2.rank + ")");
	    });
	    var index = this.locToIndex(locs);
	    this.values[index] = value;
	  }
	  /**
	   * Returns the value in the buffer at the provided location.
	   *
	   * @param locs The location indices.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Creation'}
	   */
	  ;

	  _proto.get = function get() {
	    for (var _len2 = arguments.length, locs = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
	      locs[_key2] = arguments[_key2];
	    }

	    if (locs.length === 0) {
	      locs = [0];
	    }

	    var i = 0;

	    for (var _i = 0, _locs = locs; _i < _locs.length; _i++) {
	      var loc = _locs[_i];

	      if (loc < 0 || loc >= this.shape[i]) {
	        var msg = "Requested out of range element at " + locs + ". " + ("  Buffer shape=" + this.shape);
	        throw new Error(msg);
	      }

	      i++;
	    }

	    var index = locs[locs.length - 1];

	    for (var _i2 = 0; _i2 < locs.length - 1; ++_i2) {
	      index += this.strides[_i2] * locs[_i2];
	    }

	    return this.values[index];
	  };

	  _proto.locToIndex = function locToIndex(locs) {
	    if (this.rank === 0) {
	      return 0;
	    } else if (this.rank === 1) {
	      return locs[0];
	    }

	    var index = locs[locs.length - 1];

	    for (var i = 0; i < locs.length - 1; ++i) {
	      index += this.strides[i] * locs[i];
	    }

	    return index;
	  };

	  _proto.indexToLoc = function indexToLoc(index) {
	    if (this.rank === 0) {
	      return [];
	    } else if (this.rank === 1) {
	      return [index];
	    }

	    var locs = new Array(this.shape.length);

	    for (var i = 0; i < locs.length - 1; ++i) {
	      locs[i] = Math.floor(index / this.strides[i]);
	      index -= locs[i] * this.strides[i];
	    }

	    locs[locs.length - 1] = index;
	    return locs;
	  };

	  /**
	   * Creates an immutable `tf.Tensor` object from the buffer.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Creation'}
	   */
	  _proto.toTensor = function toTensor() {
	    return trackerFn().makeTensor(this.values, this.shape, this.dtype);
	  };

	  _createClass(TensorBuffer, [{
	    key: "rank",
	    get: function get() {
	      return this.shape.length;
	    }
	  }]);

	  return TensorBuffer;
	}(); // For tracking tensor creation and disposal.

	var trackerFn = null; // Used by chaining methods to call into ops.

	var opHandler = null; // Used to warn about deprecated methods.

	var deprecationWarningFn = null; // This here so that we can use this method on dev branches and keep the
	// functionality at master.
	// tslint:disable-next-line:no-unused-expression

	[deprecationWarningFn];
	/**
	 * An external consumer can register itself as the tensor tracker. This way
	 * the Tensor class can notify the tracker for every tensor created and
	 * disposed.
	 */

	function setTensorTracker(fn) {
	  trackerFn = fn;
	}
	/**
	 * An external consumer can register itself as the op handler. This way the
	 * Tensor class can have chaining methods that call into ops via the op
	 * handler.
	 */

	function setOpHandler(handler) {
	  opHandler = handler;
	}
	/**
	 * Sets the deprecation warning function to be used by this file. This way the
	 * Tensor class can be a leaf but still use the environment.
	 */

	function setDeprecationWarningFn(fn) {
	  deprecationWarningFn = fn;
	}
	/**
	 * A `tf.Tensor` object represents an immutable, multidimensional array of
	 * numbers that has a shape and a data type.
	 *
	 * See `tf.tensor` for details on how to create a `tf.Tensor`.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Classes'}
	 */

	var Tensor = /*#__PURE__*/function () {
	  function Tensor(shape, dtype, dataId, id) {
	    /** Whether this tensor has been globally kept. */
	    this.kept = false;
	    this.isDisposedInternal = false;
	    this.shape = shape.slice();
	    this.dtype = dtype || 'float32';
	    this.size = sizeFromShape(shape);
	    this.strides = computeStrides(shape);
	    this.dataId = dataId;
	    this.id = id;
	    this.rankType = this.rank < 5 ? this.rank.toString() : 'higher';
	  }

	  var _proto2 = Tensor.prototype;

	  /**
	   * Returns a promise of `tf.TensorBuffer` that holds the underlying data.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Classes'}
	   */
	  _proto2.buffer =
	  /*#__PURE__*/
	  function () {
	    var _buffer = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
	      var vals;
	      return regeneratorRuntime.wrap(function _callee$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              _context.next = 2;
	              return this.data();

	            case 2:
	              vals = _context.sent;
	              return _context.abrupt("return", opHandler.buffer(this.shape, this.dtype, vals));

	            case 4:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, _callee, this);
	    }));

	    function buffer() {
	      return _buffer.apply(this, arguments);
	    }

	    return buffer;
	  }()
	  /**
	   * Returns a `tf.TensorBuffer` that holds the underlying data.
	   * @doc {heading: 'Tensors', subheading: 'Classes'}
	   */
	  ;

	  _proto2.bufferSync = function bufferSync() {
	    return opHandler.buffer(this.shape, this.dtype, this.dataSync());
	  }
	  /**
	   * Returns the tensor data as a nested array. The transfer of data is done
	   * asynchronously.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Classes'}
	   */
	  ;

	  _proto2.array =
	  /*#__PURE__*/
	  function () {
	    var _array = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
	      var vals;
	      return regeneratorRuntime.wrap(function _callee2$(_context2) {
	        while (1) {
	          switch (_context2.prev = _context2.next) {
	            case 0:
	              _context2.next = 2;
	              return this.data();

	            case 2:
	              vals = _context2.sent;
	              return _context2.abrupt("return", toNestedArray(this.shape, vals));

	            case 4:
	            case "end":
	              return _context2.stop();
	          }
	        }
	      }, _callee2, this);
	    }));

	    function array() {
	      return _array.apply(this, arguments);
	    }

	    return array;
	  }()
	  /**
	   * Returns the tensor data as a nested array. The transfer of data is done
	   * synchronously.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Classes'}
	   */
	  ;

	  _proto2.arraySync = function arraySync() {
	    return toNestedArray(this.shape, this.dataSync());
	  }
	  /**
	   * Asynchronously downloads the values from the `tf.Tensor`. Returns a
	   * promise of `TypedArray` that resolves when the computation has finished.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Classes'}
	   */
	  ;

	  _proto2.data =
	  /*#__PURE__*/
	  function () {
	    var _data = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
	      var data, bytes;
	      return regeneratorRuntime.wrap(function _callee3$(_context3) {
	        while (1) {
	          switch (_context3.prev = _context3.next) {
	            case 0:
	              this.throwIfDisposed();
	              data = trackerFn().read(this.dataId);

	              if (!(this.dtype === 'string')) {
	                _context3.next = 13;
	                break;
	              }

	              _context3.next = 5;
	              return data;

	            case 5:
	              bytes = _context3.sent;
	              _context3.prev = 6;
	              return _context3.abrupt("return", bytes.map(function (b) {
	                return decodeString(b);
	              }));

	            case 10:
	              _context3.prev = 10;
	              _context3.t0 = _context3["catch"](6);
	              throw new Error('Failed to decode the string bytes into utf-8. ' + 'To get the original bytes, call tensor.bytes().');

	            case 13:
	              return _context3.abrupt("return", data);

	            case 14:
	            case "end":
	              return _context3.stop();
	          }
	        }
	      }, _callee3, this, [[6, 10]]);
	    }));

	    function data() {
	      return _data.apply(this, arguments);
	    }

	    return data;
	  }()
	  /**
	   * Synchronously downloads the values from the `tf.Tensor`. This blocks the
	   * UI thread until the values are ready, which can cause performance issues.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Classes'}
	   */
	  ;

	  _proto2.dataSync = function dataSync() {
	    this.throwIfDisposed();
	    var data = trackerFn().readSync(this.dataId);

	    if (this.dtype === 'string') {
	      try {
	        return data.map(function (b) {
	          return decodeString(b);
	        });
	      } catch (_a) {
	        throw new Error('Failed to decode the string bytes into utf-8. ' + 'To get the original bytes, call tensor.bytes().');
	      }
	    }

	    return data;
	  }
	  /** Returns the underlying bytes of the tensor's data. */
	  ;

	  _proto2.bytes =
	  /*#__PURE__*/
	  function () {
	    var _bytes = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
	      var data;
	      return regeneratorRuntime.wrap(function _callee4$(_context4) {
	        while (1) {
	          switch (_context4.prev = _context4.next) {
	            case 0:
	              this.throwIfDisposed();
	              _context4.next = 3;
	              return trackerFn().read(this.dataId);

	            case 3:
	              data = _context4.sent;

	              if (!(this.dtype === 'string')) {
	                _context4.next = 8;
	                break;
	              }

	              return _context4.abrupt("return", data);

	            case 8:
	              return _context4.abrupt("return", new Uint8Array(data.buffer));

	            case 9:
	            case "end":
	              return _context4.stop();
	          }
	        }
	      }, _callee4, this);
	    }));

	    function bytes() {
	      return _bytes.apply(this, arguments);
	    }

	    return bytes;
	  }()
	  /**
	   * Disposes `tf.Tensor` from memory.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Classes'}
	   */
	  ;

	  _proto2.dispose = function dispose() {
	    if (this.isDisposed) {
	      return;
	    }

	    trackerFn().disposeTensor(this);
	    this.isDisposedInternal = true;
	  };

	  _proto2.throwIfDisposed = function throwIfDisposed() {
	    if (this.isDisposed) {
	      throw new Error("Tensor is disposed.");
	    }
	  }
	  /**
	   * Prints the `tf.Tensor`. See `tf.print` for details.
	   *
	   * @param verbose Whether to print verbose information about the tensor,
	   *    including dtype and size.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Classes'}
	   */
	  ;

	  _proto2.print = function print(verbose) {
	    if (verbose === void 0) {
	      verbose = false;
	    }

	    return opHandler.print(this, verbose);
	  }
	  /**
	   * Returns a copy of the tensor. See `tf.clone` for details.
	   * @doc {heading: 'Tensors', subheading: 'Classes'}
	   */
	  ;

	  _proto2.clone = function clone() {
	    this.throwIfDisposed();
	    return opHandler.clone(this);
	  }
	  /**
	   * Returns a human-readable description of the tensor. Useful for logging.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Classes'}
	   */
	  ;

	  _proto2.toString = function toString(verbose) {
	    if (verbose === void 0) {
	      verbose = false;
	    }

	    var vals = this.dataSync();
	    return tensorToString(vals, this.shape, this.dtype, verbose);
	  };

	  _proto2.cast = function cast(dtype) {
	    this.throwIfDisposed();
	    return opHandler.cast(this, dtype);
	  };

	  _proto2.variable = function variable(trainable, name, dtype) {
	    if (trainable === void 0) {
	      trainable = true;
	    }

	    this.throwIfDisposed();
	    return trackerFn().makeVariable(this, trainable, name, dtype);
	  };

	  _createClass(Tensor, [{
	    key: "rank",
	    get: function get() {
	      return this.shape.length;
	    }
	  }, {
	    key: "isDisposed",
	    get: function get() {
	      return this.isDisposedInternal;
	    }
	  }]);

	  return Tensor;
	}();
	Object.defineProperty(Tensor, Symbol.hasInstance, {
	  value: function value(instance) {
	    // Implementation note: we should use properties of the object that will be
	    // defined before the constructor body has finished executing (methods).
	    // This is because when this code is transpiled by babel, babel will call
	    // classCallCheck before the constructor body is run.
	    // See https://github.com/tensorflow/tfjs/issues/3384 for backstory.
	    return !!instance && instance.data != null && instance.dataSync != null && instance.throwIfDisposed != null;
	  }
	});
	function getGlobalTensorClass() {
	  // Use getGlobal so that we can augment the Tensor class across package
	  // boundaries becase the node resolution alg may result in different modules
	  // being returned for this file depending on the path they are loaded from.
	  return getGlobal('Tensor', function () {
	    return Tensor;
	  });
	} // Global side effect. Cache global reference to Tensor class

	getGlobalTensorClass();
	/**
	 * A mutable `tf.Tensor`, useful for persisting state, e.g. for training.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Classes'}
	 */

	var Variable = /*#__PURE__*/function (_Tensor) {
	  _inheritsLoose(Variable, _Tensor);

	  function Variable(initialValue, trainable, name, tensorId) {
	    var _this3;

	    _this3 = _Tensor.call(this, initialValue.shape, initialValue.dtype, initialValue.dataId, tensorId) || this;
	    _this3.trainable = trainable;
	    _this3.name = name;
	    return _this3;
	  }
	  /**
	   * Assign a new `tf.Tensor` to this variable. The new `tf.Tensor` must have
	   * the same shape and dtype as the old `tf.Tensor`.
	   *
	   * @param newValue New tensor to be assigned to this variable.
	   *
	   * @doc {heading: 'Tensors', subheading: 'Classes'}
	   */


	  var _proto3 = Variable.prototype;

	  _proto3.assign = function assign(newValue) {
	    if (newValue.dtype !== this.dtype) {
	      throw new Error("dtype of the new value (" + newValue.dtype + ") and " + ("previous value (" + this.dtype + ") must match"));
	    }

	    if (!arraysEqual(newValue.shape, this.shape)) {
	      throw new Error("shape of the new value (" + newValue.shape + ") and " + ("previous value (" + this.shape + ") must match"));
	    }

	    trackerFn().disposeTensor(this);
	    this.dataId = newValue.dataId;
	    trackerFn().incRef(this, null
	    /* backend */
	    );
	  };

	  _proto3.dispose = function dispose() {
	    trackerFn().disposeVariable(this);
	    this.isDisposedInternal = true;
	  };

	  return Variable;
	}(Tensor);
	Object.defineProperty(Variable, Symbol.hasInstance, {
	  value: function value(instance) {
	    return instance instanceof Tensor && instance.assign != null && instance.assign instanceof Function;
	  }
	});

	/**
	 * @license
	 * Copyright 2017 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */

	(function (Rank) {
	  Rank["R0"] = "R0";
	  Rank["R1"] = "R1";
	  Rank["R2"] = "R2";
	  Rank["R3"] = "R3";
	  Rank["R4"] = "R4";
	  Rank["R5"] = "R5";
	  Rank["R6"] = "R6";
	})(exports.Rank || (exports.Rank = {})); // Looks for upcasting types. Used, for example, in operations with mixed dtype
	// inputs.


	var UpcastInt32AndMap;

	(function (UpcastInt32AndMap) {
	  UpcastInt32AndMap["float32"] = "float32";
	  UpcastInt32AndMap["int32"] = "int32";
	  UpcastInt32AndMap["bool"] = "int32";
	  UpcastInt32AndMap["complex64"] = "complex64";
	})(UpcastInt32AndMap || (UpcastInt32AndMap = {}));

	var UpcastBoolAndMap;

	(function (UpcastBoolAndMap) {
	  UpcastBoolAndMap["float32"] = "float32";
	  UpcastBoolAndMap["int32"] = "int32";
	  UpcastBoolAndMap["bool"] = "bool";
	  UpcastBoolAndMap["complex64"] = "complex64";
	})(UpcastBoolAndMap || (UpcastBoolAndMap = {}));

	var UpcastFloat32AndMap;

	(function (UpcastFloat32AndMap) {
	  UpcastFloat32AndMap["float32"] = "float32";
	  UpcastFloat32AndMap["int32"] = "float32";
	  UpcastFloat32AndMap["bool"] = "float32";
	  UpcastFloat32AndMap["complex64"] = "complex64";
	})(UpcastFloat32AndMap || (UpcastFloat32AndMap = {}));

	var UpcastComplex64AndMap;

	(function (UpcastComplex64AndMap) {
	  UpcastComplex64AndMap["float32"] = "complex64";
	  UpcastComplex64AndMap["int32"] = "complex64";
	  UpcastComplex64AndMap["bool"] = "complex64";
	  UpcastComplex64AndMap["complex64"] = "complex64";
	})(UpcastComplex64AndMap || (UpcastComplex64AndMap = {}));

	var upcastTypeMap = {
	  'float32': UpcastFloat32AndMap,
	  'int32': UpcastInt32AndMap,
	  'bool': UpcastBoolAndMap,
	  'complex64': UpcastComplex64AndMap
	};
	function upcastType(typeA, typeB) {
	  if (typeA === 'string' || typeB === 'string') {
	    if (typeA === 'string' && typeB === 'string') {
	      return 'string';
	    }

	    throw new Error("Can not upcast " + typeA + " with " + typeB);
	  }

	  return upcastTypeMap[typeA][typeB];
	}
	/** Returns the output type after summation. */

	function sumOutType(type) {
	  return upcastType(type, 'int32');
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	function makeTypesMatch(a, b) {
	  if (a.dtype === b.dtype) {
	    return [a, b];
	  }

	  var dtype = upcastType(a.dtype, b.dtype);
	  return [a.cast(dtype), b.cast(dtype)];
	}
	function assertTypesMatch(a, b) {
	  assert(a.dtype === b.dtype, function () {
	    return "The dtypes of the first(" + a.dtype + ") and" + (" second(" + b.dtype + ") input must match");
	  });
	}
	function isTensorInList(tensor, tensorList) {
	  return tensorList.some(function (x) {
	    return x.id === tensor.id;
	  });
	}
	/**
	 * Extracts any `Tensor`s found within the provided object.
	 *
	 * @param container an object that may be a `Tensor` or may directly contain
	 *   `Tensor`s, such as a `Tensor[]` or `{key: Tensor, ...}`. In general it
	 *   is safe to pass any object here, except that `Promise`s are not
	 *   supported.
	 * @returns An array of `Tensors` found within the passed object. If the
	 *   argument is simply a `Tensor', a list containing that `Tensor` is
	 *   returned. If the object is not a `Tensor` or does not
	 *   contain `Tensors`, an empty list is returned.
	 */

	function getTensorsInContainer(result) {
	  var list = [];
	  var seen = new Set();
	  walkTensorContainer(result, list, seen);
	  return list;
	}

	function walkTensorContainer(container, list, seen) {
	  if (container == null) {
	    return;
	  }

	  if (container instanceof Tensor) {
	    list.push(container);
	    return;
	  }

	  if (!isIterable(container)) {
	    return;
	  } // Iteration over keys works also for arrays.


	  var iterable = container;

	  for (var k in iterable) {
	    var val = iterable[k];

	    if (!seen.has(val)) {
	      seen.add(val);
	      walkTensorContainer(val, list, seen);
	    }
	  }
	} // tslint:disable-next-line:no-any


	function isIterable(obj) {
	  return Array.isArray(obj) || typeof obj === 'object';
	}

	var tensor_util = {
		__proto__: null,
		makeTypesMatch: makeTypesMatch,
		assertTypesMatch: assertTypesMatch,
		isTensorInList: isTensorInList,
		getTensorsInContainer: getTensorsInContainer
	};

	function isRegisteredKernelInvocation(kernelInvocation) {
	  return kernelInvocation.kernelName != null;
	}

	var EngineState = /*#__PURE__*/function () {
	  function EngineState() {
	    // Public since optimizers will use it.
	    this.registeredVariables = {};
	    this.nextTapeNodeId = 0;
	    this.numBytes = 0;
	    this.numTensors = 0;
	    this.numStringTensors = 0;
	    this.numDataBuffers = 0; // Number of nested tf.grad() statements when computing higher-order
	    // gradients. E.g. `1` for first-order gradients and `2` for second-order
	    // gradients. Used to track if the tape should be removed after a backprop.

	    this.gradientDepth = 0; // Number of nested kernel calls. When kernel depth is greater than 1, we turn
	    // off the tape.

	    this.kernelDepth = 0;
	    this.scopeStack = [];
	    /**
	     * Keeps track of the number of data moves during a kernel execution. We
	     * maintain a stack since kernels can call other kernels, recursively.
	     */

	    this.numDataMovesStack = [];
	    this.nextScopeId = 0;
	    this.tensorInfo = new WeakMap();
	    this.profiling = false;
	    this.activeProfile = {
	      newBytes: 0,
	      newTensors: 0,
	      peakBytes: 0,
	      kernels: [],
	      result: null,

	      get kernelNames() {
	        return Array.from(new Set(this.kernels.map(function (k) {
	          return k.name;
	        })));
	      }

	    };
	  }

	  var _proto = EngineState.prototype;

	  _proto.dispose = function dispose() {
	    for (var variableName in this.registeredVariables) {
	      this.registeredVariables[variableName].dispose();
	    }
	  };

	  return EngineState;
	}();

	var Engine = /*#__PURE__*/function () {
	  function Engine(ENV) {
	    this.ENV = ENV;
	    this.registry = {};
	    this.registryFactory = {};
	    this.pendingBackendInitId = 0;
	    this.state = new EngineState();
	  }

	  var _proto2 = Engine.prototype;

	  _proto2.ready = /*#__PURE__*/function () {
	    var _ready = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
	      var sortedBackends, i, backendName, success;
	      return regeneratorRuntime.wrap(function _callee$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              if (!(this.pendingBackendInit != null)) {
	                _context.next = 2;
	                break;
	              }

	              return _context.abrupt("return", this.pendingBackendInit.then(function () {}));

	            case 2:
	              if (!(this.backendInstance != null)) {
	                _context.next = 4;
	                break;
	              }

	              return _context.abrupt("return");

	            case 4:
	              sortedBackends = this.getSortedBackends();
	              i = 0;

	            case 6:
	              if (!(i < sortedBackends.length)) {
	                _context.next = 18;
	                break;
	              }

	              backendName = sortedBackends[i];
	              _context.next = 10;
	              return this.initializeBackend(backendName).success;

	            case 10:
	              success = _context.sent;

	              if (!success) {
	                _context.next = 15;
	                break;
	              }

	              _context.next = 14;
	              return this.setBackend(backendName);

	            case 14:
	              return _context.abrupt("return");

	            case 15:
	              i++;
	              _context.next = 6;
	              break;

	            case 18:
	              throw new Error("Could not initialize any backends, all backend initializations " + "failed.");

	            case 19:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, _callee, this);
	    }));

	    function ready() {
	      return _ready.apply(this, arguments);
	    }

	    return ready;
	  }();

	  _proto2.backendNames = function backendNames() {
	    return Object.keys(this.registryFactory);
	  };

	  _proto2.findBackend = function findBackend(backendName) {
	    if (!(backendName in this.registry)) {
	      // If the backend hasn't been initialized but we have a registry entry for
	      // it, initialize it and return it.
	      if (backendName in this.registryFactory) {
	        var _this$initializeBacke = this.initializeBackend(backendName),
	            asyncInit = _this$initializeBacke.asyncInit;

	        if (asyncInit) {
	          // Backend is not ready yet.
	          return null;
	        }
	      } else {
	        return null;
	      }
	    }

	    return this.registry[backendName];
	  };

	  _proto2.findBackendFactory = function findBackendFactory(backendName) {
	    if (!(backendName in this.registryFactory)) {
	      return null;
	    }

	    return this.registryFactory[backendName].factory;
	  };

	  _proto2.registerBackend = function registerBackend(backendName, factory, priority) {
	    if (priority === void 0) {
	      priority = 1;
	    }

	    if (backendName in this.registryFactory) {
	      console.warn(backendName + " backend was already registered. " + "Reusing existing backend factory.");
	      return false;
	    }

	    this.registryFactory[backendName] = {
	      factory: factory,
	      priority: priority
	    };
	    return true;
	  };

	  _proto2.setBackend = /*#__PURE__*/function () {
	    var _setBackend = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(backendName) {
	      var _this$initializeBacke2, success, asyncInit, result;

	      return regeneratorRuntime.wrap(function _callee2$(_context2) {
	        while (1) {
	          switch (_context2.prev = _context2.next) {
	            case 0:
	              if (!(this.registryFactory[backendName] == null)) {
	                _context2.next = 2;
	                break;
	              }

	              throw new Error("Backend name '" + backendName + "' not found in registry");

	            case 2:
	              this.backendName = backendName;

	              if (!(this.registry[backendName] == null)) {
	                _context2.next = 16;
	                break;
	              }

	              this.backendInstance = null;
	              _this$initializeBacke2 = this.initializeBackend(backendName), success = _this$initializeBacke2.success, asyncInit = _this$initializeBacke2.asyncInit;

	              if (!asyncInit) {
	                _context2.next = 12;
	                break;
	              }

	              _context2.next = 9;
	              return success;

	            case 9:
	              _context2.t0 = _context2.sent;
	              _context2.next = 13;
	              break;

	            case 12:
	              _context2.t0 = success;

	            case 13:
	              result = _context2.t0;

	              if (result) {
	                _context2.next = 16;
	                break;
	              }

	              return _context2.abrupt("return", false);

	            case 16:
	              this.backendInstance = this.registry[backendName];
	              this.setupRegisteredKernels(); // Reset the profiler.

	              this.profiler = new Profiler(this.backendInstance);
	              return _context2.abrupt("return", true);

	            case 20:
	            case "end":
	              return _context2.stop();
	          }
	        }
	      }, _callee2, this);
	    }));

	    function setBackend(_x) {
	      return _setBackend.apply(this, arguments);
	    }

	    return setBackend;
	  }();

	  _proto2.setupRegisteredKernels = function setupRegisteredKernels() {
	    var _this = this;

	    var kernels = getKernelsForBackend(this.backendName);
	    kernels.forEach(function (kernel) {
	      if (kernel.setupFunc != null) {
	        kernel.setupFunc(_this.backendInstance);
	      }
	    });
	  };

	  _proto2.disposeRegisteredKernels = function disposeRegisteredKernels(backendName) {
	    var _this2 = this;

	    var kernels = getKernelsForBackend(backendName);
	    kernels.forEach(function (kernel) {
	      if (kernel.disposeFunc != null) {
	        kernel.disposeFunc(_this2.registry[backendName]);
	      }
	    });
	  }
	  /**
	   * Initializes a backend by looking up the backend name in the factory
	   * registry and calling the factory method. Returns a boolean representing
	   * whether the initialization of the backend suceeded. Throws an error if
	   * there is no backend in the factory registry.
	   */
	  ;

	  _proto2.initializeBackend = function initializeBackend(backendName) {
	    var _this3 = this;

	    var registryFactoryEntry = this.registryFactory[backendName];

	    if (registryFactoryEntry == null) {
	      throw new Error("Cannot initialize backend " + backendName + ", no registration found.");
	    }

	    try {
	      var backend = registryFactoryEntry.factory();
	      /* Test if the factory returns a promise.
	      Done in a more liberal way than
	      previous 'Promise.resolve(backend)===backend'
	      as we needed to account for custom Promise
	      implementations (e.g. Angular) */

	      if (backend && !(backend instanceof KernelBackend) && typeof backend.then === 'function') {
	        var promiseId = ++this.pendingBackendInitId;
	        var success = backend.then(function (backendInstance) {
	          // Outdated promise. Another backend was set in the meantime.
	          if (promiseId < _this3.pendingBackendInitId) {
	            return false;
	          }

	          _this3.registry[backendName] = backendInstance;
	          _this3.pendingBackendInit = null;
	          return true;
	        }).catch(function (err) {
	          // Outdated promise. Another backend was set in the meantime.
	          if (promiseId < _this3.pendingBackendInitId) {
	            return false;
	          }

	          _this3.pendingBackendInit = null;
	          console.warn("Initialization of backend " + backendName + " failed");
	          console.warn(err.stack || err.message);
	          return false;
	        });
	        this.pendingBackendInit = success;
	        return {
	          success: success,
	          asyncInit: true
	        };
	      } else {
	        this.registry[backendName] = backend;
	        return {
	          success: true,
	          asyncInit: false
	        };
	      }
	    } catch (err) {
	      console.warn("Initialization of backend " + backendName + " failed");
	      console.warn(err.stack || err.message);
	      return {
	        success: false,
	        asyncInit: false
	      };
	    }
	  };

	  _proto2.removeBackend = function removeBackend(backendName) {
	    if (!(backendName in this.registryFactory)) {
	      throw new Error(backendName + " backend not found in registry");
	    }

	    if (this.backendName === backendName && this.pendingBackendInit != null) {
	      // There is a pending promise of the backend we want to remove. Make it
	      // obsolete.
	      this.pendingBackendInitId++;
	    }

	    if (backendName in this.registry) {
	      this.disposeRegisteredKernels(backendName);
	      this.registry[backendName].dispose();
	      delete this.registry[backendName];
	    }

	    delete this.registryFactory[backendName]; // Unset the backend if it is active.

	    if (this.backendName === backendName) {
	      this.pendingBackendInit = null;
	      this.backendName = null;
	      this.backendInstance = null;
	    }
	  };

	  _proto2.getSortedBackends = function getSortedBackends() {
	    var _this4 = this;

	    if (Object.keys(this.registryFactory).length === 0) {
	      throw new Error('No backend found in registry.');
	    }

	    return Object.keys(this.registryFactory).sort(function (a, b) {
	      // Highest priority comes first.
	      return _this4.registryFactory[b].priority - _this4.registryFactory[a].priority;
	    });
	  };

	  _proto2.initializeBackendsAndReturnBest = function initializeBackendsAndReturnBest() {
	    var sortedBackends = this.getSortedBackends();

	    for (var i = 0; i < sortedBackends.length; i++) {
	      var backendName = sortedBackends[i];

	      var _this$initializeBacke3 = this.initializeBackend(backendName),
	          success = _this$initializeBacke3.success,
	          asyncInit = _this$initializeBacke3.asyncInit;

	      if (asyncInit || success) {
	        return {
	          name: backendName,
	          asyncInit: asyncInit
	        };
	      }
	    }

	    throw new Error("Could not initialize any backends, all backend initializations " + "failed.");
	  };

	  _proto2.moveData = function moveData(backend, dataId) {
	    var info = this.state.tensorInfo.get(dataId);
	    var srcBackend = info.backend;
	    var values = this.readSync(dataId); // Delete the tensor from the old backend and move it to the new
	    // backend.

	    srcBackend.disposeData(dataId);
	    info.backend = backend;
	    backend.move(dataId, values, info.shape, info.dtype);

	    if (this.shouldCheckForMemLeaks()) {
	      // Track the number of moves during a kernel execution to correctly
	      // detect memory leaks.
	      this.state.numDataMovesStack[this.state.numDataMovesStack.length - 1]++;
	    }
	  };

	  _proto2.tidy = function tidy(nameOrFn, fn) {
	    var _this5 = this;

	    var name = null;

	    if (fn == null) {
	      // Called with only 1 argument.
	      if (typeof nameOrFn !== 'function') {
	        throw new Error('Please provide a function to tidy()');
	      }

	      fn = nameOrFn;
	    } else {
	      // Called with 2 arguments.
	      if (typeof nameOrFn !== 'string' && !(nameOrFn instanceof String)) {
	        throw new Error('When calling with two arguments, the first argument ' + 'to tidy() must be a string');
	      }

	      if (typeof fn !== 'function') {
	        throw new Error('When calling with two arguments, the 2nd argument ' + 'to tidy() must be a function');
	      }

	      name = nameOrFn; // TODO(nsthorat,smilkov): Do operation logging and performance
	      // profiling.
	    }

	    var result;
	    return this.scopedRun(function () {
	      return _this5.startScope(name);
	    }, function () {
	      return _this5.endScope(result);
	    }, function () {
	      result = fn();

	      if (result instanceof Promise) {
	        console.error('Cannot return a Promise inside of tidy.');
	      }

	      return result;
	    });
	  };

	  _proto2.scopedRun = function scopedRun(start, end, f) {
	    start();

	    try {
	      var res = f();
	      end();
	      return res;
	    } catch (ex) {
	      end();
	      throw ex;
	    }
	  };

	  _proto2.nextTensorId = function nextTensorId() {
	    return Engine.nextTensorId++;
	  };

	  _proto2.nextVariableId = function nextVariableId() {
	    return Engine.nextVariableId++;
	  }
	  /**
	   * This method is called instead of the public-facing tensor.clone() when
	   * saving a tensor for backwards pass. It makes sure to add the clone
	   * operation to the tape regardless of being called inside a kernel
	   * execution.
	   */
	  ;

	  _proto2.clone = function clone(x) {
	    var y = this.makeTensorFromDataId(x.dataId, x.shape, x.dtype);
	    var inputs = {
	      x: x
	    };

	    var grad = function grad(dy) {
	      return {
	        x: function x() {
	          var dtype = 'float32';
	          var gradInputs = {
	            x: dy
	          };
	          var attrs = {
	            dtype: dtype
	          };
	          return ENGINE.runKernel(Cast, gradInputs, // tslint:disable-next-line: no-unnecessary-type-assertion
	          attrs);
	        }
	      };
	    };

	    var saved = [];
	    this.addTapeNode(this.state.activeScope.name, inputs, [y], grad, saved, {});
	    return y;
	  }
	  /**
	   * Execute a kernel with the given name and return the output tensor.
	   *
	   * @param kernelName The name of the kernel to execute.
	   * @param inputs A map of input names to tensors.
	   * @param attrs A map of attribute names to their values. An attribute is a
	   *     primitive (non-tensor) input to the kernel.
	   * @param inputsToSave A list of tensors, inputs to save for the backprop
	   *     computation.
	   * @param outputsToSave A list of booleans, specifying which output to save
	   *     for the backprop computation. These are booleans since the output
	   * tensors are not visible to the user.
	   */
	  ;

	  _proto2.runKernel = function runKernel(kernelName, inputs, attrs) {
	    var hasKernel = getKernel(kernelName, this.backendName) != null;

	    if (!hasKernel) {
	      throw new Error("Kernel '" + kernelName + "' not registered for backend '" + this.backendName + "'");
	    }

	    return this.runKernelFunc({
	      kernelName: kernelName,
	      inputs: inputs,
	      attrs: attrs
	    });
	  };

	  _proto2.shouldCheckForMemLeaks = function shouldCheckForMemLeaks() {
	    return this.ENV.getBool('IS_TEST');
	  };

	  _proto2.checkKernelForMemLeak = function checkKernelForMemLeak(kernelName, numDataIdsBefore, outInfos) {
	    var numDataIdsAfter = this.backend.numDataIds(); // Count the number of data ids associated with the result of the kernel.

	    var numOutputDataIds = 0;
	    outInfos.forEach(function (info) {
	      // Complex numbers allocate 3 data ids, one for 'real', one for
	      // 'imaginary', and one for the container that holds the former two.
	      numOutputDataIds += info.dtype === 'complex64' ? 3 : 1;
	    }); // Account for the number of moves during kernel execution. A "data move"
	    // can happen in the middle of a kernel execution, placing a new (key,value)
	    // pair in the data storage. Since data moves have net zero effect (we
	    // always remove the data from the old backend), we have to cancel them out
	    // when detecting memory leaks.

	    var numMoves = this.state.numDataMovesStack[this.state.numDataMovesStack.length - 1];
	    var dataIdsLeaked = numDataIdsAfter - numDataIdsBefore - numOutputDataIds - numMoves;

	    if (dataIdsLeaked > 0) {
	      throw new Error("Backend '" + this.backendName + "' has an internal memory leak " + ("(" + dataIdsLeaked + " data ids) after running '" + kernelName + "'"));
	    }
	  }
	  /**
	   * Internal helper method to execute a kernel Func
	   *
	   * Use `runKernel` to execute kernels from outside of engine.
	   */
	  ;

	  _proto2.runKernelFunc = function runKernelFunc(kernelParams) {
	    var _this6 = this;

	    var outputs;
	    var saved = [];
	    var isTapeOn = this.isTapeOn();
	    var startingBytecount = this.state.numBytes;
	    var startingNumTensors = this.state.numTensors;

	    if (this.shouldCheckForMemLeaks()) {
	      this.state.numDataMovesStack.push(0);
	    }

	    var kernelFunc;

	    if (this.backendName == null) {
	      // backend has not been initialized yet (backend initialization is lazy
	      // can be deferred until an op/ kernel is run).
	      // The below getter has side effects that will try to initialize the
	      // backend and set properties like this.backendName
	      // tslint:disable-next-line: no-unused-expression
	      this.backend;
	    }

	    var out;
	    var kernelOrScopeName = isRegisteredKernelInvocation(kernelParams) ? kernelParams.kernelName : this.state.activeScope != null ? this.state.activeScope.name : ''; // Create the kernelFunc from either a registered kernel OR passed in
	    // forward/backward functions (used by custom grad). In this context a
	    // kernelFunc wraps a kernel implementation with some bookkeeping.

	    if (isRegisteredKernelInvocation(kernelParams)) {
	      var kernelName = kernelParams.kernelName,
	          _inputs = kernelParams.inputs,
	          _attrs = kernelParams.attrs;

	      if (this.backendName == null) {
	        // backend has not been initialized yet (backend initialization is lazy
	        // can be deferred until an op/ kernel is run).
	        // The below getter has side effects that will try to initialize the
	        // backend and set properties like this.backendName
	        // tslint:disable-next-line: no-unused-expression
	        this.backend;
	      }

	      var kernel = getKernel(kernelName, this.backendName);
	      assert(kernel != null, function () {
	        return "Cannot find registered kernel '" + kernelName + "' for backend '" + _this6.backendName + "'";
	      });

	      kernelFunc = function kernelFunc() {
	        var numDataIdsBefore = _this6.backend.numDataIds();

	        out = kernel.kernelFunc({
	          inputs: _inputs,
	          attrs: _attrs,
	          backend: _this6.backend
	        });
	        var outInfos = Array.isArray(out) ? out : [out];

	        if (_this6.shouldCheckForMemLeaks()) {
	          _this6.checkKernelForMemLeak(kernelName, numDataIdsBefore, outInfos);
	        }

	        var outTensors = outInfos.map(function (outInfo) {
	          // todo (yassogba) remove this option (Tensor) when node backend
	          // methods have been modularized and they all return tensorInfo.
	          // TensorInfos do not have a rank attribute.
	          if (outInfo.rank != null) {
	            return outInfo;
	          }

	          var dataId = outInfo.dataId,
	              shape = outInfo.shape,
	              dtype = outInfo.dtype;
	          return _this6.makeTensorFromDataId(dataId, shape, dtype);
	        }); // Save any required inputs and outputs.
	        // Do not save unless we are recording to the tape. Otherwise it would
	        // cause a mem leak since there would be no backprop for these tensors
	        // (which would otherwise dispose them).

	        if (isTapeOn) {
	          var tensorsToSave = _this6.getTensorsForGradient(kernelName, _inputs, outTensors);

	          saved = _this6.saveTensorsForBackwardMode(tensorsToSave);
	        }

	        return outTensors;
	      };
	    } else {
	      var forwardFunc = kernelParams.forwardFunc; // Running a customGrad op.

	      var saveFunc = function saveFunc(tensors) {
	        // Do not save unless we are recording to the tape. Otherwise it would
	        // cause a mem leak since we would never run backprop, which disposes
	        // the kept tensors.
	        if (!isTapeOn) {
	          return;
	        }

	        saved = tensors.map(function (tensor) {
	          return _this6.keep(_this6.clone(tensor));
	        });
	      };

	      kernelFunc = function kernelFunc() {
	        var numDataIdsBefore = _this6.backend.numDataIds();

	        out = _this6.tidy(function () {
	          return forwardFunc(_this6.backend, saveFunc);
	        });
	        var outs = Array.isArray(out) ? out : [out];

	        if (_this6.shouldCheckForMemLeaks()) {
	          // Scope name is used to print a more helpful error message if needed.
	          _this6.checkKernelForMemLeak(kernelOrScopeName, numDataIdsBefore, outs);
	        }

	        return outs;
	      };
	    } //
	    // Run the kernelFunc. Optionally profiling it.
	    //


	    var inputs = kernelParams.inputs,
	        attrs = kernelParams.attrs;
	    var backwardsFunc = isRegisteredKernelInvocation(kernelParams) ? null : kernelParams.backwardsFunc;
	    var kernelProfile;
	    this.scopedRun( // Stop recording to a tape when running a kernel.
	    function () {
	      return _this6.state.kernelDepth++;
	    }, function () {
	      return _this6.state.kernelDepth--;
	    }, function () {
	      if (!_this6.ENV.getBool('DEBUG') && !_this6.state.profiling) {
	        outputs = kernelFunc();
	      } else {
	        kernelProfile = _this6.profiler.profileKernel(kernelOrScopeName, inputs, function () {
	          return kernelFunc();
	        });

	        if (_this6.ENV.getBool('DEBUG')) {
	          _this6.profiler.logKernelProfile(kernelProfile);
	        }

	        outputs = kernelProfile.outputs;
	      }
	    });

	    if (isTapeOn) {
	      this.addTapeNode(kernelOrScopeName, inputs, outputs, backwardsFunc, saved, attrs);
	    }

	    if (this.state.profiling) {
	      this.state.activeProfile.kernels.push({
	        name: kernelOrScopeName,
	        bytesAdded: this.state.numBytes - startingBytecount,
	        totalBytesSnapshot: this.state.numBytes,
	        tensorsAdded: this.state.numTensors - startingNumTensors,
	        totalTensorsSnapshot: this.state.numTensors,
	        inputShapes: Object.keys(inputs).map(function (key) {
	          return inputs[key] != null ? inputs[key].shape : null;
	        }),
	        outputShapes: outputs.map(function (item) {
	          return item.shape;
	        }),
	        kernelTimeMs: kernelProfile.timeMs,
	        extraInfo: kernelProfile.extraInfo
	      });
	    }

	    return Array.isArray(out) ? outputs : outputs[0];
	  }
	  /**
	   * Saves tensors used in forward mode for use in backward mode.
	   *
	   * @param tensors the list of tensors to save.
	   */
	  ;

	  _proto2.saveTensorsForBackwardMode = function saveTensorsForBackwardMode(tensors) {
	    var _this7 = this;

	    var saved = tensors.map(function (tensor) {
	      return _this7.keep(_this7.clone(tensor));
	    });
	    return saved;
	  }
	  /**
	   * Returns a list of tensors to save for a given gradient calculation.
	   *
	   * @param kernelName name of kernel to look up gradient for.
	   * @param inputs a map of input tensors.
	   * @param outputs an array of output tensors from forward mode of kernel.
	   */
	  ;

	  _proto2.getTensorsForGradient = function getTensorsForGradient(kernelName, inputs, outputs) {
	    var gradConfig = getGradient(kernelName);

	    if (gradConfig != null) {
	      var inputsToSave = gradConfig.inputsToSave || [];
	      var outputsToSave = gradConfig.outputsToSave || []; // If saveAllInputs is true, all inputs will be saved. Otherwise, inputs
	      // specified in inputsToSave will be saved.

	      var inputTensorsToSave;

	      if (gradConfig.saveAllInputs) {
	        assert(Array.isArray(inputs), function () {
	          return 'saveAllInputs is true, expected inputs to be an array.';
	        });
	        inputTensorsToSave = Object.keys(inputs).map(function (key) {
	          return inputs[key];
	        });
	      } else {
	        inputTensorsToSave = inputsToSave.map(function (inputName) {
	          return inputs[inputName];
	        });
	      }

	      var outputTensorsToSave = outputs.filter(function (_, i) {
	        return outputsToSave[i];
	      });
	      return inputTensorsToSave.concat(outputTensorsToSave);
	    } // We return an empty list rather than throw an error because the kernel we
	    // are looking up may not actually be relevant to backproping through the
	    // overall function
	    //
	    // See 'does not error if irrelevant (pruned) ops are missing grads' test
	    // in gradients_test.ts for an example.


	    return [];
	  }
	  /**
	   * Internal method used by public APIs for tensor creation. Makes a new
	   * tensor with the provided shape, dtype and values. It always
	   * creates a new data id and writes the values to the underlying backend.
	   */
	  ;

	  _proto2.makeTensor = function makeTensor(values, shape, dtype, backend) {
	    if (values == null) {
	      throw new Error('Values passed to engine.makeTensor() are null');
	    }

	    dtype = dtype || 'float32';
	    backend = backend || this.backend;
	    var backendVals = values;

	    if (dtype === 'string' && isString(values[0])) {
	      backendVals = values.map(function (d) {
	        return encodeString(d);
	      });
	    }

	    var dataId = backend.write(backendVals, shape, dtype);
	    var t = new Tensor(shape, dtype, dataId, this.nextTensorId());
	    this.incRef(t, backend); // Count bytes for string tensors.

	    if (dtype === 'string') {
	      var info = this.state.tensorInfo.get(dataId);
	      var newBytes = bytesFromStringArray(backendVals);
	      this.state.numBytes += newBytes - info.bytes;
	      info.bytes = newBytes;
	    }

	    return t;
	  }
	  /**
	   * Internal method used by backends. Makes a new tensor
	   * that is a wrapper around an existing data id. It doesn't create
	   * a new data id, only increments the ref count used in memory tracking.
	   */
	  ;

	  _proto2.makeTensorFromDataId = function makeTensorFromDataId(dataId, shape, dtype, backend) {
	    dtype = dtype || 'float32';
	    var t = new Tensor(shape, dtype, dataId, this.nextTensorId());
	    this.incRef(t, backend);
	    return t;
	  };

	  _proto2.makeVariable = function makeVariable(initialValue, trainable, name, dtype) {
	    if (trainable === void 0) {
	      trainable = true;
	    }

	    name = name || this.nextVariableId().toString();

	    if (dtype != null && dtype !== initialValue.dtype) {
	      initialValue = initialValue.cast(dtype);
	    }

	    var v = new Variable(initialValue, trainable, name, this.nextTensorId());

	    if (this.state.registeredVariables[v.name] != null) {
	      throw new Error("Variable with name " + v.name + " was already registered");
	    }

	    this.state.registeredVariables[v.name] = v;
	    this.incRef(v, this.backend);
	    return v;
	  };

	  _proto2.incRef = function incRef(a, backend) {
	    var refCount = this.state.tensorInfo.has(a.dataId) ? this.state.tensorInfo.get(a.dataId).refCount : 0;
	    this.state.numTensors++;

	    if (a.dtype === 'string') {
	      this.state.numStringTensors++;
	    }

	    if (refCount === 0) {
	      this.state.numDataBuffers++; // Bytes for complex numbers are counted by their components. Bytes for
	      // string tensors are counted when writing values.

	      var bytes = 0;

	      if (a.dtype !== 'complex64' && a.dtype !== 'string') {
	        bytes = a.size * bytesPerElement(a.dtype);
	      }

	      this.state.tensorInfo.set(a.dataId, {
	        backend: backend || this.backend,
	        dtype: a.dtype,
	        shape: a.shape,
	        bytes: bytes,
	        refCount: 0
	      });
	      this.state.numBytes += bytes;
	    }

	    this.state.tensorInfo.get(a.dataId).refCount++;

	    if (!(a instanceof Variable)) {
	      this.track(a);
	    }
	  };

	  _proto2.disposeTensor = function disposeTensor(a) {
	    if (!this.state.tensorInfo.has(a.dataId)) {
	      return;
	    }

	    this.state.numTensors--;

	    if (a.dtype === 'string') {
	      this.state.numStringTensors--;
	    }

	    var info = this.state.tensorInfo.get(a.dataId);
	    var refCount = info.refCount;

	    if (refCount <= 1) {
	      // Don't count bytes for complex numbers as they are counted by their
	      // components.
	      if (a.dtype !== 'complex64') {
	        this.state.numBytes -= info.bytes;
	      }

	      this.state.numDataBuffers--;
	      info.backend.disposeData(a.dataId);
	      this.state.tensorInfo.delete(a.dataId);
	    } else {
	      // Notify the backend to descrease the ref count for complex tensor
	      // components. This method is only implemented in WebGL right now. When
	      // there are multiple references, complex tensor cannot dispose the
	      // components if ref count is not in sync with engine.
	      info.backend.decComplexRef(a.dataId);
	      this.state.tensorInfo.get(a.dataId).refCount--;
	    } // TODO(nsthorat): Construct an error and save the stack trace for
	    // debugging when in debug mode. Creating a stack trace is too expensive
	    // to do unconditionally.

	  };

	  _proto2.disposeVariables = function disposeVariables() {
	    for (var varName in this.state.registeredVariables) {
	      var v = this.state.registeredVariables[varName];
	      this.disposeVariable(v);
	    }
	  };

	  _proto2.disposeVariable = function disposeVariable(v) {
	    this.disposeTensor(v);

	    if (this.state.registeredVariables[v.name] != null) {
	      delete this.state.registeredVariables[v.name];
	    }
	  };

	  _proto2.memory = function memory() {
	    var info = this.backend.memory();
	    info.numTensors = this.state.numTensors;
	    info.numDataBuffers = this.state.numDataBuffers;
	    info.numBytes = this.state.numBytes;

	    if (this.state.numStringTensors > 0) {
	      info.unreliable = true;

	      if (info.reasons == null) {
	        info.reasons = [];
	      }

	      info.reasons.push('Memory usage by string tensors is approximate ' + '(2 bytes per character)');
	    }

	    return info;
	  };

	  _proto2.profile = /*#__PURE__*/function () {
	    var _profile = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(query) {
	      var startBytes, startNumTensors, _iterator, _step, kernel;

	      return regeneratorRuntime.wrap(function _callee3$(_context3) {
	        while (1) {
	          switch (_context3.prev = _context3.next) {
	            case 0:
	              this.state.profiling = true;
	              startBytes = this.state.numBytes;
	              startNumTensors = this.state.numTensors;
	              this.state.activeProfile.kernels = [];
	              _context3.next = 6;
	              return query();

	            case 6:
	              this.state.activeProfile.result = _context3.sent;
	              this.state.profiling = false;
	              this.state.activeProfile.peakBytes = Math.max.apply(Math, this.state.activeProfile.kernels.map(function (d) {
	                return d.totalBytesSnapshot;
	              }));
	              this.state.activeProfile.newBytes = this.state.numBytes - startBytes;
	              this.state.activeProfile.newTensors = this.state.numTensors - startNumTensors;
	              _iterator = _createForOfIteratorHelperLoose(this.state.activeProfile.kernels);

	            case 12:
	              if ((_step = _iterator()).done) {
	                _context3.next = 22;
	                break;
	              }

	              kernel = _step.value;
	              _context3.next = 16;
	              return kernel.kernelTimeMs;

	            case 16:
	              kernel.kernelTimeMs = _context3.sent;
	              _context3.next = 19;
	              return kernel.extraInfo;

	            case 19:
	              kernel.extraInfo = _context3.sent;

	            case 20:
	              _context3.next = 12;
	              break;

	            case 22:
	              return _context3.abrupt("return", this.state.activeProfile);

	            case 23:
	            case "end":
	              return _context3.stop();
	          }
	        }
	      }, _callee3, this);
	    }));

	    function profile(_x2) {
	      return _profile.apply(this, arguments);
	    }

	    return profile;
	  }();

	  _proto2.isTapeOn = function isTapeOn() {
	    return this.state.gradientDepth > 0 && this.state.kernelDepth === 0;
	  };

	  _proto2.addTapeNode = function addTapeNode(kernelName, inputs, outputs, gradientsFunc, saved, attrs) {
	    var _this8 = this;

	    var tapeNode = {
	      id: this.state.nextTapeNodeId++,
	      kernelName: kernelName,
	      inputs: inputs,
	      outputs: outputs,
	      saved: saved
	    };
	    var gradConfig = getGradient(kernelName);

	    if (gradConfig != null) {
	      gradientsFunc = gradConfig.gradFunc;
	    }

	    if (gradientsFunc != null) {
	      tapeNode.gradient = function (dys) {
	        // TODO(smilkov): To optimize back-prop, pass dys that are not used in
	        // the backprop graph to the user as null instead of zeros
	        dys = dys.map(function (dy, i) {
	          if (dy == null) {
	            var output = outputs[i];
	            var vals = makeZerosTypedArray(output.size, output.dtype);
	            return _this8.makeTensor(vals, output.shape, output.dtype);
	          }

	          return dy;
	        }); // Grad functions of ops with single outputs expect a dy, while ops
	        // with multiple outputs expect dys (array of dy).

	        return gradientsFunc(dys.length > 1 ? dys : dys[0], saved, attrs);
	      };
	    }

	    this.state.activeTape.push(tapeNode);
	  };

	  _proto2.keep = function keep(result) {
	    result.kept = true;
	    return result;
	  };

	  _proto2.startTape = function startTape() {
	    if (this.state.gradientDepth === 0) {
	      this.state.activeTape = [];
	    }

	    this.state.gradientDepth++;
	  };

	  _proto2.endTape = function endTape() {
	    this.state.gradientDepth--;
	  }
	  /**
	   * Start a scope. Use this with endScope() to achieve the same functionality
	   * as scope() without the need for a function closure.
	   */
	  ;

	  _proto2.startScope = function startScope(name) {
	    var scopeInfo = {
	      track: [],
	      name: 'unnamed scope',
	      id: this.state.nextScopeId++
	    };

	    if (name) {
	      scopeInfo.name = name;
	    }

	    this.state.scopeStack.push(scopeInfo);
	    this.state.activeScope = scopeInfo;
	  }
	  /**
	   * End a scope. Use this with startScope() to achieve the same functionality
	   * as scope() without the need for a function closure.
	   */
	  ;

	  _proto2.endScope = function endScope(result) {
	    var _this9 = this;

	    var tensorsToTrackInParent = getTensorsInContainer(result);
	    var tensorsToTrackInParentSet = new Set(tensorsToTrackInParent.map(function (t) {
	      return t.id;
	    })); // Dispose the arrays tracked in this scope.

	    for (var i = 0; i < this.state.activeScope.track.length; i++) {
	      var tensor = this.state.activeScope.track[i];

	      if (!tensor.kept && !tensorsToTrackInParentSet.has(tensor.id)) {
	        tensor.dispose();
	      }
	    }

	    var oldScope = this.state.scopeStack.pop();
	    this.state.activeScope = this.state.scopeStack.length === 0 ? null : this.state.scopeStack[this.state.scopeStack.length - 1]; // Track the current result in the parent scope.

	    tensorsToTrackInParent.forEach(function (tensor) {
	      // Only track the tensor if was allocated in the inner scope and is not
	      // globally kept.
	      if (!tensor.kept && tensor.scopeId === oldScope.id) {
	        _this9.track(tensor);
	      }
	    });
	  }
	  /**
	   * Returns gradients of `f` with respect to each of the `xs`. The gradients
	   * returned are of the same length as `xs`, but some might be null if `f`
	   * was not a function of that `x`. It also takes optional dy to multiply the
	   * gradient, which defaults to `1`.
	   */
	  ;

	  _proto2.gradients = function gradients(f, xs, dy, allowNoGradients) {
	    var _this10 = this;

	    if (allowNoGradients === void 0) {
	      allowNoGradients = false;
	    }

	    assert(xs.length > 0, function () {
	      return 'gradients() received an empty list of xs.';
	    });

	    if (dy != null && dy.dtype !== 'float32') {
	      throw new Error("dy must have 'float32' dtype, but has '" + dy.dtype + "'");
	    }

	    var y = this.scopedRun(function () {
	      return _this10.startTape();
	    }, function () {
	      return _this10.endTape();
	    }, function () {
	      return _this10.tidy('forward', f);
	    });
	    assert(y instanceof Tensor, function () {
	      return 'The result y returned by f() must be a tensor.';
	    }); // Filter out the nodes that don't connect x => y.

	    var filteredTape = getFilteredNodesXToY(this.state.activeTape, xs, y);

	    if (!allowNoGradients && filteredTape.length === 0 && xs.length > 0) {
	      throw new Error('Cannot compute gradient of y=f(x) with respect to x. Make sure ' + 'that the f you passed encloses all operations that lead from x ' + 'to y.');
	    }

	    return this.tidy('backward', function () {
	      var accumulatedGradientMap = {};
	      accumulatedGradientMap[y.id] = dy == null ? ones(y.shape) : dy; // Backprop gradients through the filtered nodes.

	      backpropagateGradients(accumulatedGradientMap, filteredTape, // Pass the tidy function to avoid circular dep with `tape.ts`.
	      function (f) {
	        return _this10.tidy(f);
	      }, // Pass an add function to avoide a circular dep with `tape.ts`.
	      add);
	      var grads = xs.map(function (x) {
	        return accumulatedGradientMap[x.id];
	      });

	      if (_this10.state.gradientDepth === 0) {
	        // This means that we are not computing higher-order gradients
	        // and can clean up the tape.
	        _this10.state.activeTape.forEach(function (node) {
	          for (var _iterator2 = _createForOfIteratorHelperLoose(node.saved), _step2; !(_step2 = _iterator2()).done;) {
	            var tensor = _step2.value;
	            tensor.dispose();
	          }
	        });

	        _this10.state.activeTape = null;
	      }

	      return {
	        value: y,
	        grads: grads
	      };
	    });
	  };

	  _proto2.customGrad = function customGrad(f) {
	    var _this11 = this;

	    assert(isFunction(f), function () {
	      return 'The f passed in customGrad(f) must be a function.';
	    });
	    return function () {
	      for (var _len = arguments.length, inputs = new Array(_len), _key = 0; _key < _len; _key++) {
	        inputs[_key] = arguments[_key];
	      }

	      assert(inputs.every(function (t) {
	        return t instanceof Tensor;
	      }), function () {
	        return 'The args passed in customGrad(f)(x1, x2,...) must all be ' + 'tensors';
	      });
	      var res;
	      var inputMap = {};
	      inputs.forEach(function (input, i) {
	        inputMap[i] = input;
	      });

	      var forwardFunc = function forwardFunc(_, save) {
	        res = f.apply(void 0, [].concat(inputs, [save]));
	        assert(res.value instanceof Tensor, function () {
	          return 'The function f passed in customGrad(f) must return an ' + 'object where `obj.value` is a tensor';
	        });
	        assert(isFunction(res.gradFunc), function () {
	          return 'The function f passed in customGrad(f) must return an ' + 'object where `obj.gradFunc` is a function.';
	        });
	        return res.value;
	      };

	      var backwardsFunc = function backwardsFunc(dy, saved) {
	        var gradRes = res.gradFunc(dy, saved);
	        var grads = Array.isArray(gradRes) ? gradRes : [gradRes];
	        assert(grads.length === inputs.length, function () {
	          return 'The function f passed in customGrad(f) must return an ' + 'object where `obj.gradFunc` is a function that returns ' + 'the same number of tensors as inputs passed to f(...).';
	        });
	        assert(grads.every(function (t) {
	          return t instanceof Tensor;
	        }), function () {
	          return 'The function f passed in customGrad(f) must return an ' + 'object where `obj.gradFunc` is a function that returns ' + 'a list of only tensors.';
	        });
	        var gradMap = {};
	        grads.forEach(function (grad, i) {
	          gradMap[i] = function () {
	            return grad;
	          };
	        });
	        return gradMap;
	      };

	      return _this11.runKernelFunc({
	        forwardFunc: forwardFunc,
	        backwardsFunc: backwardsFunc,
	        inputs: inputMap
	      });
	    };
	  };

	  _proto2.readSync = function readSync(dataId) {
	    // Route the read to the correct backend.
	    var info = this.state.tensorInfo.get(dataId);
	    return info.backend.readSync(dataId);
	  };

	  _proto2.read = function read(dataId) {
	    // Route the read to the correct backend.
	    var info = this.state.tensorInfo.get(dataId);
	    return info.backend.read(dataId);
	  };

	  _proto2.time = /*#__PURE__*/function () {
	    var _time = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(query) {
	      var start, timingInfo;
	      return regeneratorRuntime.wrap(function _callee4$(_context4) {
	        while (1) {
	          switch (_context4.prev = _context4.next) {
	            case 0:
	              start = now();
	              _context4.next = 3;
	              return this.backend.time(query);

	            case 3:
	              timingInfo = _context4.sent;
	              timingInfo.wallMs = now() - start;
	              return _context4.abrupt("return", timingInfo);

	            case 6:
	            case "end":
	              return _context4.stop();
	          }
	        }
	      }, _callee4, this);
	    }));

	    function time(_x3) {
	      return _time.apply(this, arguments);
	    }

	    return time;
	  }()
	  /**
	   * Tracks a Tensor in the current scope to be automatically cleaned up
	   * when the current scope ends, and returns the value.
	   *
	   * @param result The Tensor to track in the current scope.
	   */
	  ;

	  _proto2.track = function track(result) {
	    if (this.state.activeScope != null) {
	      result.scopeId = this.state.activeScope.id;
	      this.state.activeScope.track.push(result);
	    }

	    return result;
	  };

	  /**
	   * Resets the engine state. Removes all backends but does not remove
	   * registered backend factories.
	   */
	  _proto2.reset = function reset() {
	    // Make any pending promise obsolete.
	    this.pendingBackendInitId++;
	    this.state.dispose();
	    this.ENV.reset();
	    this.state = new EngineState();

	    for (var backendName in this.registry) {
	      this.disposeRegisteredKernels(backendName);
	      this.registry[backendName].dispose();
	      delete this.registry[backendName];
	    }

	    this.backendName = null;
	    this.backendInstance = null;
	    this.pendingBackendInit = null;
	  };

	  _createClass(Engine, [{
	    key: "backend",
	    get: function get() {
	      if (this.pendingBackendInit != null) {
	        throw new Error("Backend '" + this.backendName + "' has not yet been initialized. Make " + "sure to await tf.ready() or await tf.setBackend() before calling " + "other methods");
	      }

	      if (this.backendInstance == null) {
	        var _this$initializeBacke4 = this.initializeBackendsAndReturnBest(),
	            name = _this$initializeBacke4.name,
	            asyncInit = _this$initializeBacke4.asyncInit;

	        if (asyncInit) {
	          throw new Error("The highest priority backend '" + name + "' has not yet been " + "initialized. Make sure to await tf.ready() or " + "await tf.setBackend() before calling other methods");
	        }

	        this.setBackend(name);
	      }

	      return this.backendInstance;
	    }
	  }, {
	    key: "registeredVariables",
	    get: function get() {
	      return this.state.registeredVariables;
	    }
	  }]);

	  return Engine;
	}();
	Engine.nextTensorId = 0;
	Engine.nextVariableId = 0;

	function ones(shape) {
	  var values = makeOnesTypedArray(sizeFromShape(shape), 'float32');
	  return ENGINE.makeTensor(values, shape, 'float32');
	}

	function getOrMakeEngine() {
	  var ns = getGlobalNamespace();

	  if (ns._tfengine == null) {
	    var environment = new Environment(ns);
	    ns._tfengine = new Engine(environment);
	  }

	  setEnvironmentGlobal(ns._tfengine.ENV); // Tell the current tensor interface that the global engine is responsible
	  // for tracking.

	  setTensorTracker(function () {
	    return ns._tfengine;
	  });
	  return ns._tfengine;
	}
	var ENGINE = getOrMakeEngine();
	/**
	 * A implementation of the add op for use within engine and tape.
	 *
	 * This allows us to avoid a circular dependency between add.ts and engine.
	 * It is exported to be available in tape tests.
	 */

	function add(a, b) {
	  // We duplicate Add here to avoid a circular dependency with add.ts.
	  var inputs = {
	    a: a,
	    b: b
	  };
	  return ENGINE.runKernel(Add, inputs);
	}

	/**
	 * @license
	 * Copyright 2017 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	// tslint:disable-next-line:no-any
	function _isNavigatorDefined() {
	  return typeof navigator !== 'undefined' && navigator != null;
	}

	function isMobile() {
	  if (_isNavigatorDefined()) {
	    // tslint:disable-next-line:no-any
	    var a = navigator.userAgent || navigator.vendor || window.opera; // tslint:disable-next-line:max-line-length

	    return /(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) || // tslint:disable-next-line:max-line-length
	    /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4));
	  }

	  return false;
	}
	function isBrowser() {
	  return typeof window !== 'undefined' && window.document != null || //@ts-ignore
	  typeof WorkerGlobalScope !== 'undefined';
	}

	var device_util = {
		__proto__: null,
		isMobile: isMobile,
		isBrowser: isBrowser
	};

	/**
	 * @license
	 * Copyright 2019 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var ENV = env();
	/**
	 * This file contains environment-related flag registrations.
	 */

	/** Whether to enable debug mode. */

	ENV.registerFlag('DEBUG', function () {
	  return false;
	}, function (debugValue) {
	  if (debugValue) {
	    console.warn('Debugging mode is ON. The output of every math call will ' + 'be downloaded to CPU and checked for NaNs. ' + 'This significantly impacts performance.');
	  }
	});
	/** Whether we are in a browser (as versus, say, node.js) environment. */

	ENV.registerFlag('IS_BROWSER', function () {
	  return isBrowser();
	});
	/** Whether we are in a browser (as versus, say, node.js) environment. */

	ENV.registerFlag('IS_NODE', function () {
	  return typeof process !== 'undefined' && typeof process.versions !== 'undefined' && typeof process.versions.node !== 'undefined';
	});
	/** Whether this browser is Chrome. */

	ENV.registerFlag('IS_CHROME', function () {
	  return typeof navigator !== 'undefined' && navigator != null && navigator.userAgent != null && /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);
	});
	/**
	 * True when the environment is "production" where we disable safety checks
	 * to gain performance.
	 */

	ENV.registerFlag('PROD', function () {
	  return false;
	});
	/**
	 * Whether to do sanity checks when inferring a shape from user-provided
	 * values, used when creating a new tensor.
	 */

	ENV.registerFlag('TENSORLIKE_CHECK_SHAPE_CONSISTENCY', function () {
	  return ENV.getBool('DEBUG');
	});
	/** Whether deprecation warnings are enabled. */

	ENV.registerFlag('DEPRECATION_WARNINGS_ENABLED', function () {
	  return true;
	});
	/** True if running unit tests. */

	ENV.registerFlag('IS_TEST', function () {
	  return false;
	});
	/** Whether to check computation result for errors. */

	ENV.registerFlag('CHECK_COMPUTATION_FOR_ERRORS', function () {
	  return true;
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	function inferShape(val, dtype) {
	  var firstElem = val;

	  if (isTypedArray$1(val)) {
	    return dtype === 'string' ? [] : [val.length];
	  }

	  if (!Array.isArray(val)) {
	    return []; // Scalar.
	  }

	  var shape = [];

	  while (Array.isArray(firstElem) || isTypedArray$1(firstElem) && dtype !== 'string') {
	    shape.push(firstElem.length);
	    firstElem = firstElem[0];
	  }

	  if (Array.isArray(val) && env().getBool('TENSORLIKE_CHECK_SHAPE_CONSISTENCY')) {
	    deepAssertShapeConsistency(val, shape, []);
	  }

	  return shape;
	}

	function deepAssertShapeConsistency(val, shape, indices) {
	  indices = indices || [];

	  if (!Array.isArray(val) && !isTypedArray$1(val)) {
	    assert(shape.length === 0, function () {
	      return "Element arr[" + indices.join('][') + "] is a primitive, " + ("but should be an array/TypedArray of " + shape[0] + " elements");
	    });
	    return;
	  }

	  assert(shape.length > 0, function () {
	    return "Element arr[" + indices.join('][') + "] should be a primitive, " + ("but is an array of " + val.length + " elements");
	  });
	  assert(val.length === shape[0], function () {
	    return "Element arr[" + indices.join('][') + "] should have " + shape[0] + " " + ("elements, but has " + val.length + " elements");
	  });
	  var subShape = shape.slice(1);

	  for (var i = 0; i < val.length; ++i) {
	    deepAssertShapeConsistency(val[i], subShape, indices.concat(i));
	  }
	}

	function assertDtype(expectedDtype, actualDType, argName, functionName) {
	  if (expectedDtype === 'string_or_numeric') {
	    return;
	  }

	  if (expectedDtype == null) {
	    throw new Error("Expected dtype cannot be null.");
	  }

	  if (expectedDtype !== 'numeric' && expectedDtype !== actualDType || expectedDtype === 'numeric' && actualDType === 'string') {
	    throw new Error("Argument '" + argName + "' passed to '" + functionName + "' must " + ("be " + expectedDtype + " tensor, but got " + actualDType + " tensor"));
	  }
	}

	function convertToTensor(x, argName, functionName, parseAsDtype) {
	  if (parseAsDtype === void 0) {
	    parseAsDtype = 'numeric';
	  }

	  if (x instanceof Tensor) {
	    assertDtype(parseAsDtype, x.dtype, argName, functionName);
	    return x;
	  }

	  var inferredDtype = inferDtype(x); // If the user expects a bool/int/float, use that info to update the
	  // inferredDtype when it is not a string.

	  if (inferredDtype !== 'string' && ['bool', 'int32', 'float32'].indexOf(parseAsDtype) >= 0) {
	    inferredDtype = parseAsDtype;
	  }

	  assertDtype(parseAsDtype, inferredDtype, argName, functionName);

	  if (x == null || !isTypedArray$1(x) && !Array.isArray(x) && typeof x !== 'number' && typeof x !== 'boolean' && typeof x !== 'string') {
	    var type = x == null ? 'null' : x.constructor.name;
	    throw new Error("Argument '" + argName + "' passed to '" + functionName + "' must be a " + ("Tensor or TensorLike, but got '" + type + "'"));
	  }

	  var inferredShape = inferShape(x, inferredDtype);

	  if (!isTypedArray$1(x) && !Array.isArray(x)) {
	    x = [x];
	  }

	  var skipTypedArray = true;
	  var values = inferredDtype !== 'string' ? toTypedArray(x, inferredDtype) : flatten(x, [], skipTypedArray);
	  return ENGINE.makeTensor(values, inferredShape, inferredDtype);
	}
	function convertToTensorArray(arg, argName, functionName, parseAsDtype) {
	  if (parseAsDtype === void 0) {
	    parseAsDtype = 'numeric';
	  }

	  if (!Array.isArray(arg)) {
	    throw new Error("Argument " + argName + " passed to " + functionName + " must be a " + '`Tensor[]` or `TensorLike[]`');
	  }

	  var tensors = arg;
	  return tensors.map(function (t, i) {
	    return convertToTensor(t, argName + "[" + i + "]", functionName, parseAsDtype);
	  });
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var OP_SCOPE_SUFFIX = '__op';
	/**
	 * Used for wrapping functions that perform math operations on
	 * Tensors. The function will be wrapped in a named scope that cleans all
	 * memory usage after the function is done.
	 */

	function op(f) {
	  var keys = Object.keys(f);

	  if (keys.length !== 1) {
	    throw new Error("Please provide an object with a single key " + "(operation name) mapping to a function. Got an object with " + (keys.length + " keys."));
	  }

	  var opName = keys[0];
	  var fn = f[opName]; // Strip the underscore from the end of the function name.

	  if (opName.endsWith('_')) {
	    opName = opName.substring(0, opName.length - 1);
	  } // add an __op suffix to distinguish ops from kernels in tf.profile


	  opName = opName + OP_SCOPE_SUFFIX; // tslint:disable-next-line:no-any

	  var f2 = function f2() {
	    ENGINE.startScope(opName);

	    try {
	      var result = fn.apply(void 0, arguments);

	      if (isPromise(result)) {
	        console.error('Cannot return a Promise inside of tidy.');
	      }

	      ENGINE.endScope(result);
	      return result;
	    } catch (ex) {
	      ENGINE.endScope(null);
	      throw ex;
	    }
	  };

	  Object.defineProperty(f2, 'name', {
	    value: opName,
	    configurable: true
	  }); // tslint:disable-next-line:no-any

	  return f2;
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Converts two real numbers to a complex number.
	 *
	 * Given a tensor `real` representing the real part of a complex number, and a
	 * tensor `imag` representing the imaginary part of a complex number, this
	 * operation returns complex numbers elementwise of the form [r0, i0, r1, i1],
	 * where r represents the real part and i represents the imag part.
	 *
	 * The input tensors real and imag must have the same shape.
	 *
	 * ```js
	 * const real = tf.tensor1d([2.25, 3.25]);
	 * const imag = tf.tensor1d([4.75, 5.75]);
	 * const complex = tf.complex(real, imag);
	 *
	 * complex.print();
	 * ```
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */

	function complex_(real, imag) {
	  var $real = convertToTensor(real, 'real', 'complex');
	  var $imag = convertToTensor(imag, 'imag', 'complex');
	  assertShapesMatch($real.shape, $imag.shape, "real and imag shapes, " + $real.shape + " and " + $imag.shape + ", " + "must match in call to tf.complex().");
	  var inputs = {
	    real: $real,
	    imag: $imag
	  };
	  return ENGINE.runKernel(Complex, inputs);
	}

	var complex = op({
	  complex_: complex_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/** This is shared code across all tensor creation methods. */

	function makeTensor(values, shape, inferredShape, dtype) {
	  if (dtype == null) {
	    dtype = inferDtype(values);
	  }

	  if (dtype === 'complex64') {
	    throw new Error("Cannot construct a complex64 tensor directly. " + "Please use tf.complex(real, imag).");
	  }

	  if (!isTypedArray$1(values) && !Array.isArray(values) && typeof values !== 'number' && typeof values !== 'boolean' && typeof values !== 'string') {
	    throw new Error('values passed to tensor(values) must be a number/boolean/string or ' + 'an array of numbers/booleans/strings, or a TypedArray');
	  }

	  if (shape != null) {
	    assertNonNegativeIntegerDimensions(shape);
	    var providedSize = sizeFromShape(shape);
	    var inferredSize = sizeFromShape(inferredShape);
	    assert(providedSize === inferredSize, function () {
	      return "Based on the provided shape, [" + shape + "], the tensor should have " + (providedSize + " values but has " + inferredSize);
	    });

	    for (var i = 0; i < inferredShape.length; ++i) {
	      var inferred = inferredShape[i];
	      var flatDimsDontMatch = i === inferredShape.length - 1 ? inferred !== sizeFromShape(shape.slice(i)) : true;
	      assert(inferredShape[i] === shape[i] || !flatDimsDontMatch, function () {
	        return "Error creating a new Tensor. Inferred shape " + ("(" + inferredShape + ") does not match the provided ") + ("shape (" + shape + "). ");
	      });
	    }
	  }

	  if (!isTypedArray$1(values) && !Array.isArray(values)) {
	    values = [values];
	  }

	  shape = shape || inferredShape;
	  values = dtype !== 'string' ? toTypedArray(values, dtype) : flatten(values, [], true);
	  return ENGINE.makeTensor(values, shape, dtype);
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Creates a `tf.Tensor` with the provided values, shape and dtype.
	 *
	 * ```js
	 * // Pass an array of values to create a vector.
	 * tf.tensor([1, 2, 3, 4]).print();
	 * ```
	 *
	 * ```js
	 * // Pass a nested array of values to make a matrix or a higher
	 * // dimensional tensor.
	 * tf.tensor([[1, 2], [3, 4]]).print();
	 * ```
	 *
	 * ```js
	 * // Pass a flat array and specify a shape yourself.
	 * tf.tensor([1, 2, 3, 4], [2, 2]).print();
	 * ```
	 *
	 * @param values The values of the tensor. Can be nested array of numbers,
	 *     or a flat array, or a `TypedArray`. If the values are strings,
	 *     they will be encoded as utf-8 and kept as `Uint8Array[]`.
	 * @param shape The shape of the tensor. Optional. If not provided,
	 *   it is inferred from `values`.
	 * @param dtype The data type.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */

	function tensor(values, shape, dtype) {
	  var inferredShape = inferShape(values, dtype);
	  return makeTensor(values, shape, inferredShape, dtype);
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */

	/* Type definitions for exporting and importing of models. */

	/**
	 * A map from Tensor dtype to number of bytes per element of the Tensor.
	 */
	var DTYPE_VALUE_SIZE_MAP = {
	  'float32': 4,
	  'float16': 2,
	  'int32': 4,
	  'uint16': 2,
	  'uint8': 1,
	  'bool': 1,
	  'complex64': 8
	};

	/** Number of bytes reserved for the length of the string. (32bit integer). */

	var NUM_BYTES_STRING_LENGTH = 4;
	/**
	 * Encode a map from names to weight values as an ArrayBuffer, along with an
	 * `Array` of `WeightsManifestEntry` as specification of the encoded weights.
	 *
	 * This function does not perform sharding.
	 *
	 * This function is the reverse of `decodeWeights`.
	 *
	 * @param tensors A map ("dict") from names to tensors.
	 * @param group Group to which the weights belong (optional).
	 * @returns A `Promise` of
	 *   - A flat `ArrayBuffer` with all the binary values of the `Tensor`s
	 *     concatenated.
	 *   - An `Array` of `WeightManifestEntry`s, carrying information including
	 *     tensor names, `dtype`s and shapes.
	 * @throws Error: on unsupported tensor `dtype`.
	 */

	function encodeWeights(_x, _x2) {
	  return _encodeWeights.apply(this, arguments);
	}
	/**
	 * Decode flat ArrayBuffer as weights.
	 *
	 * This function does not handle sharding.
	 *
	 * This function is the reverse of `encodeWeights`.
	 *
	 * @param buffer A flat ArrayBuffer carrying the binary values of the tensors
	 *   concatenated in the order specified in `specs`.
	 * @param specs Specifications of the names, dtypes and shapes of the tensors
	 *   whose value are encoded by `buffer`.
	 * @return A map from tensor name to tensor value, with the names corresponding
	 *   to names in `specs`.
	 * @throws Error, if any of the tensors has unsupported dtype.
	 */

	function _encodeWeights() {
	  _encodeWeights = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(tensors, group) {
	    var specs, dataPromises, names, _loop, i, tensorValues;

	    return regeneratorRuntime.wrap(function _callee2$(_context2) {
	      while (1) {
	        switch (_context2.prev = _context2.next) {
	          case 0:
	            // TODO(adarob, cais): Support quantization.
	            specs = [];
	            dataPromises = [];
	            names = Array.isArray(tensors) ? tensors.map(function (tensor) {
	              return tensor.name;
	            }) : Object.keys(tensors);

	            _loop = function _loop(i) {
	              var name = names[i];
	              var t = Array.isArray(tensors) ? tensors[i].tensor : tensors[name];

	              if (t.dtype !== 'float32' && t.dtype !== 'int32' && t.dtype !== 'bool' && t.dtype !== 'string' && t.dtype !== 'complex64') {
	                throw new Error("Unsupported dtype in weight '" + name + "': " + t.dtype);
	              }

	              var spec = {
	                name: name,
	                shape: t.shape,
	                dtype: t.dtype
	              };

	              if (t.dtype === 'string') {
	                var utf8bytes = new Promise( /*#__PURE__*/function () {
	                  var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(resolve) {
	                    var vals, totalNumBytes, bytes, offset, _i6, val, bytesOfLength;

	                    return regeneratorRuntime.wrap(function _callee$(_context) {
	                      while (1) {
	                        switch (_context.prev = _context.next) {
	                          case 0:
	                            _context.next = 2;
	                            return t.bytes();

	                          case 2:
	                            vals = _context.sent;
	                            totalNumBytes = vals.reduce(function (p, c) {
	                              return p + c.length;
	                            }, 0) + NUM_BYTES_STRING_LENGTH * vals.length;
	                            bytes = new Uint8Array(totalNumBytes);
	                            offset = 0;

	                            for (_i6 = 0; _i6 < vals.length; _i6++) {
	                              val = vals[_i6];
	                              bytesOfLength = new Uint8Array(new Uint32Array([val.length]).buffer);
	                              bytes.set(bytesOfLength, offset);
	                              offset += NUM_BYTES_STRING_LENGTH;
	                              bytes.set(val, offset);
	                              offset += val.length;
	                            }

	                            resolve(bytes);

	                          case 8:
	                          case "end":
	                            return _context.stop();
	                        }
	                      }
	                    }, _callee);
	                  }));

	                  return function (_x3) {
	                    return _ref.apply(this, arguments);
	                  };
	                }());
	                dataPromises.push(utf8bytes);
	              } else {
	                dataPromises.push(t.data());
	              }

	              if (group != null) {
	                spec.group = group;
	              }

	              specs.push(spec);
	            };

	            for (i = 0; i < names.length; ++i) {
	              _loop(i);
	            }

	            _context2.next = 7;
	            return Promise.all(dataPromises);

	          case 7:
	            tensorValues = _context2.sent;
	            return _context2.abrupt("return", {
	              data: concatenateTypedArrays(tensorValues),
	              specs: specs
	            });

	          case 9:
	          case "end":
	            return _context2.stop();
	        }
	      }
	    }, _callee2);
	  }));
	  return _encodeWeights.apply(this, arguments);
	}

	function decodeWeights(buffer, specs) {
	  // TODO(adarob, cais): Support quantization.
	  var out = {};
	  var float16Decode;
	  var offset = 0;

	  for (var _iterator = _createForOfIteratorHelperLoose(specs), _step; !(_step = _iterator()).done;) {
	    var spec = _step.value;
	    var name = spec.name;
	    var dtype = spec.dtype;
	    var shape = spec.shape;
	    var size = sizeFromShape(shape);
	    var values = void 0;

	    if ('quantization' in spec) {
	      var quantization = spec.quantization;

	      if (quantization.dtype === 'uint8' || quantization.dtype === 'uint16') {
	        if (!('min' in quantization && 'scale' in quantization)) {
	          throw new Error("Weight " + spec.name + " with quantization " + quantization.dtype + " " + "doesn't have corresponding metadata min and scale.");
	        }
	      } else if (quantization.dtype === 'float16') {
	        if (dtype !== 'float32') {
	          throw new Error("Weight " + spec.name + " is quantized with " + quantization.dtype + " " + ("which only supports weights of type float32 not " + dtype + "."));
	        }
	      } else {
	        throw new Error("Weight " + spec.name + " has unknown " + ("quantization dtype " + quantization.dtype + ". ") + "Supported quantization dtypes are: " + "'uint8', 'uint16', and 'float16'.");
	      }

	      var quantizationSizeFactor = DTYPE_VALUE_SIZE_MAP[quantization.dtype];
	      var byteBuffer = buffer.slice(offset, offset + size * quantizationSizeFactor);
	      var quantizedArray = quantization.dtype === 'uint8' ? new Uint8Array(byteBuffer) : new Uint16Array(byteBuffer);

	      if (dtype === 'float32') {
	        if (quantization.dtype === 'uint8' || quantization.dtype === 'uint16') {
	          values = new Float32Array(quantizedArray.length);

	          for (var i = 0; i < quantizedArray.length; i++) {
	            var v = quantizedArray[i];
	            values[i] = v * quantization.scale + quantization.min;
	          }
	        } else if (quantization.dtype === 'float16') {
	          if (float16Decode === undefined) {
	            float16Decode = getFloat16Decoder();
	          }

	          values = float16Decode(quantizedArray);
	        } else {
	          throw new Error("Unsupported quantization type " + quantization.dtype + " " + "for weight type float32.");
	        }
	      } else if (dtype === 'int32') {
	        if (quantization.dtype !== 'uint8' && quantization.dtype !== 'uint16') {
	          throw new Error("Unsupported quantization type " + quantization.dtype + " " + "for weight type int32.");
	        }

	        values = new Int32Array(quantizedArray.length);

	        for (var _i = 0; _i < quantizedArray.length; _i++) {
	          var _v = quantizedArray[_i];
	          values[_i] = Math.round(_v * quantization.scale + quantization.min);
	        }
	      } else {
	        throw new Error("Unsupported dtype in weight '" + name + "': " + dtype);
	      }

	      offset += size * quantizationSizeFactor;
	    } else if (dtype === 'string') {
	      var _size = sizeFromShape(spec.shape);

	      values = [];

	      for (var _i2 = 0; _i2 < _size; _i2++) {
	        var byteLength = new Uint32Array(buffer.slice(offset, offset + NUM_BYTES_STRING_LENGTH))[0];
	        offset += NUM_BYTES_STRING_LENGTH;
	        var bytes = new Uint8Array(buffer.slice(offset, offset + byteLength));
	        values.push(bytes);
	        offset += byteLength;
	      }
	    } else {
	      var dtypeFactor = DTYPE_VALUE_SIZE_MAP[dtype];

	      var _byteBuffer = buffer.slice(offset, offset + size * dtypeFactor);

	      if (dtype === 'float32') {
	        values = new Float32Array(_byteBuffer);
	      } else if (dtype === 'int32') {
	        values = new Int32Array(_byteBuffer);
	      } else if (dtype === 'bool') {
	        values = new Uint8Array(_byteBuffer);
	      } else if (dtype === 'complex64') {
	        values = new Float32Array(_byteBuffer);
	        var real = new Float32Array(values.length / 2);
	        var image = new Float32Array(values.length / 2);

	        for (var _i3 = 0; _i3 < real.length; _i3++) {
	          real[_i3] = values[_i3 * 2];
	          image[_i3] = values[_i3 * 2 + 1];
	        }

	        var realTensor = tensor(real, shape, 'float32');
	        var imageTensor = tensor(image, shape, 'float32');
	        out[name] = complex(realTensor, imageTensor);
	        realTensor.dispose();
	        imageTensor.dispose();
	      } else {
	        throw new Error("Unsupported dtype in weight '" + name + "': " + dtype);
	      }

	      offset += size * dtypeFactor;
	    }

	    if (dtype !== 'complex64') {
	      out[name] = tensor(values, shape, dtype);
	    }
	  }

	  return out;
	}
	/**
	 * Concatenate TypedArrays into an ArrayBuffer.
	 */

	function concatenateTypedArrays(xs) {
	  // TODO(adarob, cais): Support quantization.
	  if (xs === null) {
	    throw new Error("Invalid input value: " + JSON.stringify(xs));
	  }

	  var totalByteLength = 0; // `normalizedXs` is here for this reason: a `TypedArray`'s `buffer'
	  // can have a different byte length from that of the `TypedArray` itself,
	  // for example, when the `TypedArray` is created from an offset in an
	  // `ArrayBuffer`. `normliazedXs` holds `TypedArray`s whose `buffer`s match
	  // the `TypedArray` in byte length. If an element of `xs` does not show
	  // this property, a new `TypedArray` that satisfy this property will be
	  // constructed and pushed into `normalizedXs`.

	  var normalizedXs = [];
	  xs.forEach(function (x) {
	    totalByteLength += x.byteLength; // tslint:disable:no-any

	    normalizedXs.push(x.byteLength === x.buffer.byteLength ? x : new x.constructor(x));

	    if (!(x instanceof Float32Array || x instanceof Int32Array || x instanceof Uint8Array)) {
	      throw new Error("Unsupported TypedArray subtype: " + x.constructor.name);
	    } // tslint:enable:no-any

	  });
	  var y = new Uint8Array(totalByteLength);
	  var offset = 0;
	  normalizedXs.forEach(function (x) {
	    y.set(new Uint8Array(x.buffer), offset);
	    offset += x.byteLength;
	  });
	  return y.buffer;
	} // Use Buffer on Node.js instead of Blob/atob/btoa

	var useNodeBuffer = typeof Buffer !== 'undefined' && (typeof Blob === 'undefined' || typeof atob === 'undefined' || typeof btoa === 'undefined');
	/**
	 * Calculate the byte length of a JavaScript string.
	 *
	 * Note that a JavaScript string can contain wide characters, therefore the
	 * length of the string is not necessarily equal to the byte length.
	 *
	 * @param str Input string.
	 * @returns Byte length.
	 */

	function stringByteLength(str) {
	  if (useNodeBuffer) {
	    return Buffer.byteLength(str);
	  }

	  return new Blob([str]).size;
	}
	/**
	 * Encode an ArrayBuffer as a base64 encoded string.
	 *
	 * @param buffer `ArrayBuffer` to be converted.
	 * @returns A string that base64-encodes `buffer`.
	 */

	function arrayBufferToBase64String(buffer) {
	  if (useNodeBuffer) {
	    return Buffer.from(buffer).toString('base64');
	  }

	  var buf = new Uint8Array(buffer);
	  var s = '';

	  for (var i = 0, l = buf.length; i < l; i++) {
	    s += String.fromCharCode(buf[i]);
	  }

	  return btoa(s);
	}
	/**
	 * Decode a base64 string as an ArrayBuffer.
	 *
	 * @param str Base64 string.
	 * @returns Decoded `ArrayBuffer`.
	 */

	function base64StringToArrayBuffer(str) {
	  if (useNodeBuffer) {
	    var buf = Buffer.from(str, 'base64');
	    return buf.buffer.slice(buf.byteOffset, buf.byteOffset + buf.byteLength);
	  }

	  var s = atob(str);
	  var buffer = new Uint8Array(s.length);

	  for (var i = 0; i < s.length; ++i) {
	    buffer.set([s.charCodeAt(i)], i);
	  }

	  return buffer.buffer;
	}
	/**
	 * Concatenate a number of ArrayBuffers into one.
	 *
	 * @param buffers A number of array buffers to concatenate.
	 * @returns Result of concatenating `buffers` in order.
	 */

	function concatenateArrayBuffers(buffers) {
	  if (buffers.length === 1) {
	    return buffers[0];
	  }

	  var totalByteLength = 0;
	  buffers.forEach(function (buffer) {
	    totalByteLength += buffer.byteLength;
	  });
	  var temp = new Uint8Array(totalByteLength);
	  var offset = 0;
	  buffers.forEach(function (buffer) {
	    temp.set(new Uint8Array(buffer), offset);
	    offset += buffer.byteLength;
	  });
	  return temp.buffer;
	}
	/**
	 * Get the basename of a path.
	 *
	 * Behaves in a way analogous to Linux's basename command.
	 *
	 * @param path
	 */

	function basename(path) {
	  var SEPARATOR = '/';
	  path = path.trim();

	  while (path.endsWith(SEPARATOR)) {
	    path = path.slice(0, path.length - 1);
	  }

	  var items = path.split(SEPARATOR);
	  return items[items.length - 1];
	}
	/**
	 * Populate ModelArtifactsInfo fields for a model with JSON topology.
	 * @param modelArtifacts
	 * @returns A ModelArtifactsInfo object.
	 */

	function getModelArtifactsInfoForJSON(modelArtifacts) {
	  if (modelArtifacts.modelTopology instanceof ArrayBuffer) {
	    throw new Error('Expected JSON model topology, received ArrayBuffer.');
	  }

	  return {
	    dateSaved: new Date(),
	    modelTopologyType: 'JSON',
	    modelTopologyBytes: modelArtifacts.modelTopology == null ? 0 : stringByteLength(JSON.stringify(modelArtifacts.modelTopology)),
	    weightSpecsBytes: modelArtifacts.weightSpecs == null ? 0 : stringByteLength(JSON.stringify(modelArtifacts.weightSpecs)),
	    weightDataBytes: modelArtifacts.weightData == null ? 0 : modelArtifacts.weightData.byteLength
	  };
	}
	/**
	 * Computes mantisa table for casting Float16 to Float32
	 * See http://www.fox-toolkit.org/ftp/fasthalffloatconversion.pdf
	 *
	 * @returns Uint32Array, 2048 mantissa lookup values.
	 */

	function computeFloat16MantisaTable() {
	  var convertMantissa = function convertMantissa(i) {
	    var m = i << 13;
	    var e = 0;

	    while ((m & 0x00800000) === 0) {
	      e -= 0x00800000;
	      m <<= 1;
	    }

	    m &= ~0x00800000;
	    e += 0x38800000;
	    return m | e;
	  };

	  var mantisaTable = new Uint32Array(2048);
	  mantisaTable[0] = 0;

	  for (var i = 1; i < 1024; i++) {
	    mantisaTable[i] = convertMantissa(i);
	  }

	  for (var _i4 = 1024; _i4 < 2048; _i4++) {
	    mantisaTable[_i4] = 0x38000000 + (_i4 - 1024 << 13);
	  }

	  return mantisaTable;
	}
	/**
	 * Computes exponent table for casting Float16 to Float32
	 * See http://www.fox-toolkit.org/ftp/fasthalffloatconversion.pdf
	 *
	 * @returns Uint32Array, 64 exponent lookup values.
	 */


	function computeFloat16ExponentTable() {
	  var exponentTable = new Uint32Array(64);
	  exponentTable[0] = 0;
	  exponentTable[31] = 0x47800000;
	  exponentTable[32] = 0x80000000;
	  exponentTable[63] = 0xc7800000;

	  for (var i = 1; i < 31; i++) {
	    exponentTable[i] = i << 23;
	  }

	  for (var _i5 = 33; _i5 < 63; _i5++) {
	    exponentTable[_i5] = 0x80000000 + (_i5 - 32 << 23);
	  }

	  return exponentTable;
	}
	/**
	 * Computes offset table for casting Float16 to Float32
	 * See http://www.fox-toolkit.org/ftp/fasthalffloatconversion.pdf
	 *
	 * @returns Uint32Array, 6d offset values.
	 */


	function computeFloat16OffsetTable() {
	  var offsetTable = new Uint32Array(64);

	  for (var i = 0; i < 64; i++) {
	    offsetTable[i] = 1024;
	  }

	  offsetTable[0] = offsetTable[32] = 0;
	  return offsetTable;
	}
	/**
	 * Retrieve a Float16 decoder which will decode a ByteArray of Float16 values
	 * to a Float32Array.
	 *
	 * @returns Function (buffer: Uint16Array) => Float32Array which decodes
	 *          the Uint16Array of Float16 bytes to a Float32Array.
	 */


	function getFloat16Decoder() {
	  // Algorithm is based off of
	  // http://www.fox-toolkit.org/ftp/fasthalffloatconversion.pdf
	  // Cache lookup tables
	  var mantisaTable = computeFloat16MantisaTable();
	  var exponentTable = computeFloat16ExponentTable();
	  var offsetTable = computeFloat16OffsetTable();
	  return function (quantizedArray) {
	    var buffer = new ArrayBuffer(4 * quantizedArray.length);
	    var bufferUint32View = new Uint32Array(buffer);

	    for (var index = 0; index < quantizedArray.length; index++) {
	      var float16Bits = quantizedArray[index];
	      var float32Bits = mantisaTable[offsetTable[float16Bits >> 10] + (float16Bits & 0x3ff)] + exponentTable[float16Bits >> 10];
	      bufferUint32View[index] = float32Bits;
	    }

	    return new Float32Array(buffer);
	  };
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var IORouterRegistry = /*#__PURE__*/function () {
	  function IORouterRegistry() {
	    this.saveRouters = [];
	    this.loadRouters = [];
	  }

	  IORouterRegistry.getInstance = function getInstance() {
	    if (IORouterRegistry.instance == null) {
	      IORouterRegistry.instance = new IORouterRegistry();
	    }

	    return IORouterRegistry.instance;
	  }
	  /**
	   * Register a save-handler router.
	   *
	   * @param saveRouter A function that maps a URL-like string onto an instance
	   * of `IOHandler` with the `save` method defined or `null`.
	   */
	  ;

	  IORouterRegistry.registerSaveRouter = function registerSaveRouter(saveRouter) {
	    IORouterRegistry.getInstance().saveRouters.push(saveRouter);
	  }
	  /**
	   * Register a load-handler router.
	   *
	   * @param loadRouter A function that maps a URL-like string onto an instance
	   * of `IOHandler` with the `load` method defined or `null`.
	   */
	  ;

	  IORouterRegistry.registerLoadRouter = function registerLoadRouter(loadRouter) {
	    IORouterRegistry.getInstance().loadRouters.push(loadRouter);
	  }
	  /**
	   * Look up IOHandler for saving, given a URL-like string.
	   *
	   * @param url
	   * @returns If only one match is found, an instance of IOHandler with the
	   * `save` method defined. If no match is found, `null`.
	   * @throws Error, if more than one match is found.
	   */
	  ;

	  IORouterRegistry.getSaveHandlers = function getSaveHandlers(url) {
	    return IORouterRegistry.getHandlers(url, 'save');
	  }
	  /**
	   * Look up IOHandler for loading, given a URL-like string.
	   *
	   * @param url
	   * @param loadOptions Optional, custom load options.
	   * @returns All valid handlers for `url`, given the currently registered
	   *   handler routers.
	   */
	  ;

	  IORouterRegistry.getLoadHandlers = function getLoadHandlers(url, loadOptions) {
	    return IORouterRegistry.getHandlers(url, 'load', loadOptions);
	  };

	  IORouterRegistry.getHandlers = function getHandlers(url, handlerType, loadOptions) {
	    var validHandlers = [];
	    var routers = handlerType === 'load' ? IORouterRegistry.getInstance().loadRouters : IORouterRegistry.getInstance().saveRouters;
	    routers.forEach(function (router) {
	      var handler = router(url, loadOptions);

	      if (handler !== null) {
	        validHandlers.push(handler);
	      }
	    });
	    return validHandlers;
	  };

	  return IORouterRegistry;
	}();
	var registerSaveRouter = function registerSaveRouter(loudRouter) {
	  return IORouterRegistry.registerSaveRouter(loudRouter);
	};
	var registerLoadRouter = function registerLoadRouter(loudRouter) {
	  return IORouterRegistry.registerLoadRouter(loudRouter);
	};
	var getSaveHandlers = function getSaveHandlers(url) {
	  return IORouterRegistry.getSaveHandlers(url);
	};
	var getLoadHandlers = function getLoadHandlers(url, loadOptions) {
	  return IORouterRegistry.getLoadHandlers(url, loadOptions);
	};

	var DATABASE_NAME = 'tensorflowjs';
	var DATABASE_VERSION = 1; // Model data and ModelArtifactsInfo (metadata) are stored in two separate
	// stores for efficient access of the list of stored models and their metadata.
	// 1. The object store for model data: topology, weights and weight manifests.

	var MODEL_STORE_NAME = 'models_store'; // 2. The object store for ModelArtifactsInfo, including meta-information such
	//    as the type of topology (JSON vs binary), byte size of the topology, byte
	//    size of the weights, etc.

	var INFO_STORE_NAME = 'model_info_store';
	/**
	 * Delete the entire database for tensorflow.js, including the models store.
	 */

	function deleteDatabase() {
	  return _deleteDatabase.apply(this, arguments);
	}

	function _deleteDatabase() {
	  _deleteDatabase = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
	    var idbFactory;
	    return regeneratorRuntime.wrap(function _callee5$(_context5) {
	      while (1) {
	        switch (_context5.prev = _context5.next) {
	          case 0:
	            idbFactory = getIndexedDBFactory();
	            return _context5.abrupt("return", new Promise(function (resolve, reject) {
	              var deleteRequest = idbFactory.deleteDatabase(DATABASE_NAME);

	              deleteRequest.onsuccess = function () {
	                return resolve();
	              };

	              deleteRequest.onerror = function (error) {
	                return reject(error);
	              };
	            }));

	          case 2:
	          case "end":
	            return _context5.stop();
	        }
	      }
	    }, _callee5);
	  }));
	  return _deleteDatabase.apply(this, arguments);
	}

	function getIndexedDBFactory() {
	  if (!env().getBool('IS_BROWSER')) {
	    // TODO(cais): Add more info about what IOHandler subtypes are available.
	    //   Maybe point to a doc page on the web and/or automatically determine
	    //   the available IOHandlers and print them in the error message.
	    throw new Error('Failed to obtain IndexedDB factory because the current environment' + 'is not a web browser.');
	  } // tslint:disable-next-line:no-any


	  var theWindow = typeof window === 'undefined' ? self : window;
	  var factory = theWindow.indexedDB || theWindow.mozIndexedDB || theWindow.webkitIndexedDB || theWindow.msIndexedDB || theWindow.shimIndexedDB;

	  if (factory == null) {
	    throw new Error('The current browser does not appear to support IndexedDB.');
	  }

	  return factory;
	}

	function setUpDatabase(openRequest) {
	  var db = openRequest.result;
	  db.createObjectStore(MODEL_STORE_NAME, {
	    keyPath: 'modelPath'
	  });
	  db.createObjectStore(INFO_STORE_NAME, {
	    keyPath: 'modelPath'
	  });
	}
	/**
	 * IOHandler subclass: Browser IndexedDB.
	 *
	 * See the doc string of `browserIndexedDB` for more details.
	 */


	var BrowserIndexedDB = /*#__PURE__*/function () {
	  function BrowserIndexedDB(modelPath) {
	    this.indexedDB = getIndexedDBFactory();

	    if (modelPath == null || !modelPath) {
	      throw new Error('For IndexedDB, modelPath must not be null, undefined or empty.');
	    }

	    this.modelPath = modelPath;
	  }

	  var _proto = BrowserIndexedDB.prototype;

	  _proto.save = /*#__PURE__*/function () {
	    var _save = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(modelArtifacts) {
	      return regeneratorRuntime.wrap(function _callee$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              if (!(modelArtifacts.modelTopology instanceof ArrayBuffer)) {
	                _context.next = 2;
	                break;
	              }

	              throw new Error('BrowserLocalStorage.save() does not support saving model topology ' + 'in binary formats yet.');

	            case 2:
	              return _context.abrupt("return", this.databaseAction(this.modelPath, modelArtifacts));

	            case 3:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, _callee, this);
	    }));

	    function save(_x) {
	      return _save.apply(this, arguments);
	    }

	    return save;
	  }();

	  _proto.load = /*#__PURE__*/function () {
	    var _load = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
	      return regeneratorRuntime.wrap(function _callee2$(_context2) {
	        while (1) {
	          switch (_context2.prev = _context2.next) {
	            case 0:
	              return _context2.abrupt("return", this.databaseAction(this.modelPath));

	            case 1:
	            case "end":
	              return _context2.stop();
	          }
	        }
	      }, _callee2, this);
	    }));

	    function load() {
	      return _load.apply(this, arguments);
	    }

	    return load;
	  }()
	  /**
	   * Perform database action to put model artifacts into or read model artifacts
	   * from IndexedDB object store.
	   *
	   * Whether the action is put or get depends on whether `modelArtifacts` is
	   * specified. If it is specified, the action will be put; otherwise the action
	   * will be get.
	   *
	   * @param modelPath A unique string path for the model.
	   * @param modelArtifacts If specified, it will be the model artifacts to be
	   *   stored in IndexedDB.
	   * @returns A `Promise` of `SaveResult`, if the action is put, or a `Promise`
	   *   of `ModelArtifacts`, if the action is get.
	   */
	  ;

	  _proto.databaseAction = function databaseAction(modelPath, modelArtifacts) {
	    var _this = this;

	    return new Promise(function (resolve, reject) {
	      var openRequest = _this.indexedDB.open(DATABASE_NAME, DATABASE_VERSION);

	      openRequest.onupgradeneeded = function () {
	        return setUpDatabase(openRequest);
	      };

	      openRequest.onsuccess = function () {
	        var db = openRequest.result;

	        if (modelArtifacts == null) {
	          // Read model out from object store.
	          var modelTx = db.transaction(MODEL_STORE_NAME, 'readonly');
	          var modelStore = modelTx.objectStore(MODEL_STORE_NAME);
	          var getRequest = modelStore.get(_this.modelPath);

	          getRequest.onsuccess = function () {
	            if (getRequest.result == null) {
	              db.close();
	              return reject(new Error("Cannot find model with path '" + _this.modelPath + "' " + "in IndexedDB."));
	            } else {
	              resolve(getRequest.result.modelArtifacts);
	            }
	          };

	          getRequest.onerror = function (error) {
	            db.close();
	            return reject(getRequest.error);
	          };

	          modelTx.oncomplete = function () {
	            return db.close();
	          };
	        } else {
	          // Put model into object store.
	          var modelArtifactsInfo = getModelArtifactsInfoForJSON(modelArtifacts); // First, put ModelArtifactsInfo into info store.

	          var infoTx = db.transaction(INFO_STORE_NAME, 'readwrite');
	          var infoStore = infoTx.objectStore(INFO_STORE_NAME);
	          var putInfoRequest = infoStore.put({
	            modelPath: _this.modelPath,
	            modelArtifactsInfo: modelArtifactsInfo
	          });

	          var _modelTx;

	          putInfoRequest.onsuccess = function () {
	            // Second, put model data into model store.
	            _modelTx = db.transaction(MODEL_STORE_NAME, 'readwrite');

	            var modelStore = _modelTx.objectStore(MODEL_STORE_NAME);

	            var putModelRequest = modelStore.put({
	              modelPath: _this.modelPath,
	              modelArtifacts: modelArtifacts,
	              modelArtifactsInfo: modelArtifactsInfo
	            });

	            putModelRequest.onsuccess = function () {
	              return resolve({
	                modelArtifactsInfo: modelArtifactsInfo
	              });
	            };

	            putModelRequest.onerror = function (error) {
	              // If the put-model request fails, roll back the info entry as
	              // well.
	              infoStore = infoTx.objectStore(INFO_STORE_NAME);
	              var deleteInfoRequest = infoStore.delete(_this.modelPath);

	              deleteInfoRequest.onsuccess = function () {
	                db.close();
	                return reject(putModelRequest.error);
	              };

	              deleteInfoRequest.onerror = function (error) {
	                db.close();
	                return reject(putModelRequest.error);
	              };
	            };
	          };

	          putInfoRequest.onerror = function (error) {
	            db.close();
	            return reject(putInfoRequest.error);
	          };

	          infoTx.oncomplete = function () {
	            if (_modelTx == null) {
	              db.close();
	            } else {
	              _modelTx.oncomplete = function () {
	                return db.close();
	              };
	            }
	          };
	        }
	      };

	      openRequest.onerror = function (error) {
	        return reject(openRequest.error);
	      };
	    });
	  };

	  return BrowserIndexedDB;
	}();
	BrowserIndexedDB.URL_SCHEME = 'indexeddb://';
	var indexedDBRouter = function indexedDBRouter(url) {
	  if (!env().getBool('IS_BROWSER')) {
	    return null;
	  } else {
	    if (!Array.isArray(url) && url.startsWith(BrowserIndexedDB.URL_SCHEME)) {
	      return browserIndexedDB(url.slice(BrowserIndexedDB.URL_SCHEME.length));
	    } else {
	      return null;
	    }
	  }
	};
	IORouterRegistry.registerSaveRouter(indexedDBRouter);
	IORouterRegistry.registerLoadRouter(indexedDBRouter);
	/**
	 * Creates a browser IndexedDB IOHandler for saving and loading models.
	 *
	 * ```js
	 * const model = tf.sequential();
	 * model.add(
	 *     tf.layers.dense({units: 1, inputShape: [100], activation: 'sigmoid'}));
	 *
	 * const saveResult = await model.save('indexeddb://MyModel'));
	 * console.log(saveResult);
	 * ```
	 *
	 * @param modelPath A unique identifier for the model to be saved. Must be a
	 *   non-empty string.
	 * @returns An instance of `BrowserIndexedDB` (sublcass of `IOHandler`),
	 *   which can be used with, e.g., `tf.Model.save`.
	 */

	function browserIndexedDB(modelPath) {
	  return new BrowserIndexedDB(modelPath);
	}

	function maybeStripScheme(key) {
	  return key.startsWith(BrowserIndexedDB.URL_SCHEME) ? key.slice(BrowserIndexedDB.URL_SCHEME.length) : key;
	}

	var BrowserIndexedDBManager = /*#__PURE__*/function () {
	  function BrowserIndexedDBManager() {
	    this.indexedDB = getIndexedDBFactory();
	  }

	  var _proto2 = BrowserIndexedDBManager.prototype;

	  _proto2.listModels = /*#__PURE__*/function () {
	    var _listModels = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
	      var _this2 = this;

	      return regeneratorRuntime.wrap(function _callee3$(_context3) {
	        while (1) {
	          switch (_context3.prev = _context3.next) {
	            case 0:
	              return _context3.abrupt("return", new Promise(function (resolve, reject) {
	                var openRequest = _this2.indexedDB.open(DATABASE_NAME, DATABASE_VERSION);

	                openRequest.onupgradeneeded = function () {
	                  return setUpDatabase(openRequest);
	                };

	                openRequest.onsuccess = function () {
	                  var db = openRequest.result;
	                  var tx = db.transaction(INFO_STORE_NAME, 'readonly');
	                  var store = tx.objectStore(INFO_STORE_NAME); // tslint:disable:max-line-length
	                  // Need to cast `store` as `any` here because TypeScript's DOM
	                  // library does not have the `getAll()` method even though the
	                  // method is supported in the latest version of most mainstream
	                  // browsers:
	                  // https://developer.mozilla.org/en-US/docs/Web/API/IDBObjectStore/getAll
	                  // tslint:enable:max-line-length
	                  // tslint:disable-next-line:no-any

	                  var getAllInfoRequest = store.getAll();

	                  getAllInfoRequest.onsuccess = function () {
	                    var out = {};

	                    for (var _iterator = _createForOfIteratorHelperLoose(getAllInfoRequest.result), _step; !(_step = _iterator()).done;) {
	                      var item = _step.value;
	                      out[item.modelPath] = item.modelArtifactsInfo;
	                    }

	                    resolve(out);
	                  };

	                  getAllInfoRequest.onerror = function (error) {
	                    db.close();
	                    return reject(getAllInfoRequest.error);
	                  };

	                  tx.oncomplete = function () {
	                    return db.close();
	                  };
	                };

	                openRequest.onerror = function (error) {
	                  return reject(openRequest.error);
	                };
	              }));

	            case 1:
	            case "end":
	              return _context3.stop();
	          }
	        }
	      }, _callee3);
	    }));

	    function listModels() {
	      return _listModels.apply(this, arguments);
	    }

	    return listModels;
	  }();

	  _proto2.removeModel = /*#__PURE__*/function () {
	    var _removeModel = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(path) {
	      var _this3 = this;

	      return regeneratorRuntime.wrap(function _callee4$(_context4) {
	        while (1) {
	          switch (_context4.prev = _context4.next) {
	            case 0:
	              path = maybeStripScheme(path);
	              return _context4.abrupt("return", new Promise(function (resolve, reject) {
	                var openRequest = _this3.indexedDB.open(DATABASE_NAME, DATABASE_VERSION);

	                openRequest.onupgradeneeded = function () {
	                  return setUpDatabase(openRequest);
	                };

	                openRequest.onsuccess = function () {
	                  var db = openRequest.result;
	                  var infoTx = db.transaction(INFO_STORE_NAME, 'readwrite');
	                  var infoStore = infoTx.objectStore(INFO_STORE_NAME);
	                  var getInfoRequest = infoStore.get(path);
	                  var modelTx;

	                  getInfoRequest.onsuccess = function () {
	                    if (getInfoRequest.result == null) {
	                      db.close();
	                      return reject(new Error("Cannot find model with path '" + path + "' " + "in IndexedDB."));
	                    } else {
	                      // First, delete the entry in the info store.
	                      var deleteInfoRequest = infoStore.delete(path);

	                      var deleteModelData = function deleteModelData() {
	                        // Second, delete the entry in the model store.
	                        modelTx = db.transaction(MODEL_STORE_NAME, 'readwrite');
	                        var modelStore = modelTx.objectStore(MODEL_STORE_NAME);
	                        var deleteModelRequest = modelStore.delete(path);

	                        deleteModelRequest.onsuccess = function () {
	                          return resolve(getInfoRequest.result.modelArtifactsInfo);
	                        };

	                        deleteModelRequest.onerror = function (error) {
	                          return reject(getInfoRequest.error);
	                        };
	                      }; // Proceed with deleting model data regardless of whether deletion
	                      // of info data succeeds or not.


	                      deleteInfoRequest.onsuccess = deleteModelData;

	                      deleteInfoRequest.onerror = function (error) {
	                        deleteModelData();
	                        db.close();
	                        return reject(getInfoRequest.error);
	                      };
	                    }
	                  };

	                  getInfoRequest.onerror = function (error) {
	                    db.close();
	                    return reject(getInfoRequest.error);
	                  };

	                  infoTx.oncomplete = function () {
	                    if (modelTx == null) {
	                      db.close();
	                    } else {
	                      modelTx.oncomplete = function () {
	                        return db.close();
	                      };
	                    }
	                  };
	                };

	                openRequest.onerror = function (error) {
	                  return reject(openRequest.error);
	                };
	              }));

	            case 2:
	            case "end":
	              return _context4.stop();
	          }
	        }
	      }, _callee4);
	    }));

	    function removeModel(_x2) {
	      return _removeModel.apply(this, arguments);
	    }

	    return removeModel;
	  }();

	  return BrowserIndexedDBManager;
	}();

	var PATH_SEPARATOR = '/';
	var PATH_PREFIX = 'tensorflowjs_models';
	var INFO_SUFFIX = 'info';
	var MODEL_TOPOLOGY_SUFFIX = 'model_topology';
	var WEIGHT_SPECS_SUFFIX = 'weight_specs';
	var WEIGHT_DATA_SUFFIX = 'weight_data';
	var MODEL_METADATA_SUFFIX = 'model_metadata';
	/**
	 * Purge all tensorflow.js-saved model artifacts from local storage.
	 *
	 * @returns Paths of the models purged.
	 */

	function purgeLocalStorageArtifacts() {
	  if (!env().getBool('IS_BROWSER') || typeof window === 'undefined' || typeof window.localStorage === 'undefined') {
	    throw new Error('purgeLocalStorageModels() cannot proceed because local storage is ' + 'unavailable in the current environment.');
	  }

	  var LS = window.localStorage;
	  var purgedModelPaths = [];

	  for (var i = 0; i < LS.length; ++i) {
	    var key = LS.key(i);
	    var prefix = PATH_PREFIX + PATH_SEPARATOR;

	    if (key.startsWith(prefix) && key.length > prefix.length) {
	      LS.removeItem(key);
	      var modelName = getModelPathFromKey(key);

	      if (purgedModelPaths.indexOf(modelName) === -1) {
	        purgedModelPaths.push(modelName);
	      }
	    }
	  }

	  return purgedModelPaths;
	}

	function getModelKeys(path) {
	  return {
	    info: [PATH_PREFIX, path, INFO_SUFFIX].join(PATH_SEPARATOR),
	    topology: [PATH_PREFIX, path, MODEL_TOPOLOGY_SUFFIX].join(PATH_SEPARATOR),
	    weightSpecs: [PATH_PREFIX, path, WEIGHT_SPECS_SUFFIX].join(PATH_SEPARATOR),
	    weightData: [PATH_PREFIX, path, WEIGHT_DATA_SUFFIX].join(PATH_SEPARATOR),
	    modelMetadata: [PATH_PREFIX, path, MODEL_METADATA_SUFFIX].join(PATH_SEPARATOR)
	  };
	}
	/**
	 * Get model path from a local-storage key.
	 *
	 * E.g., 'tensorflowjs_models/my/model/1/info' --> 'my/model/1'
	 *
	 * @param key
	 */


	function getModelPathFromKey(key) {
	  var items = key.split(PATH_SEPARATOR);

	  if (items.length < 3) {
	    throw new Error("Invalid key format: " + key);
	  }

	  return items.slice(1, items.length - 1).join(PATH_SEPARATOR);
	}

	function maybeStripScheme$1(key) {
	  return key.startsWith(BrowserLocalStorage.URL_SCHEME) ? key.slice(BrowserLocalStorage.URL_SCHEME.length) : key;
	}
	/**
	 * IOHandler subclass: Browser Local Storage.
	 *
	 * See the doc string to `browserLocalStorage` for more details.
	 */


	var BrowserLocalStorage = /*#__PURE__*/function () {
	  function BrowserLocalStorage(modelPath) {
	    if (!env().getBool('IS_BROWSER') || typeof window === 'undefined' || typeof window.localStorage === 'undefined') {
	      // TODO(cais): Add more info about what IOHandler subtypes are
	      // available.
	      //   Maybe point to a doc page on the web and/or automatically determine
	      //   the available IOHandlers and print them in the error message.
	      throw new Error('The current environment does not support local storage.');
	    }

	    this.LS = window.localStorage;

	    if (modelPath == null || !modelPath) {
	      throw new Error('For local storage, modelPath must not be null, undefined or empty.');
	    }

	    this.modelPath = modelPath;
	    this.keys = getModelKeys(this.modelPath);
	  }
	  /**
	   * Save model artifacts to browser local storage.
	   *
	   * See the documentation to `browserLocalStorage` for details on the saved
	   * artifacts.
	   *
	   * @param modelArtifacts The model artifacts to be stored.
	   * @returns An instance of SaveResult.
	   */


	  var _proto = BrowserLocalStorage.prototype;

	  _proto.save =
	  /*#__PURE__*/
	  function () {
	    var _save = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(modelArtifacts) {
	      var topology, weightSpecs, modelArtifactsInfo, result;
	      return regeneratorRuntime.wrap(function _callee$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              if (!(modelArtifacts.modelTopology instanceof ArrayBuffer)) {
	                _context.next = 4;
	                break;
	              }

	              throw new Error('BrowserLocalStorage.save() does not support saving model topology ' + 'in binary formats yet.');

	            case 4:
	              topology = JSON.stringify(modelArtifacts.modelTopology);
	              weightSpecs = JSON.stringify(modelArtifacts.weightSpecs);
	              modelArtifactsInfo = getModelArtifactsInfoForJSON(modelArtifacts);
	              _context.prev = 7;
	              this.LS.setItem(this.keys.info, JSON.stringify(modelArtifactsInfo));
	              this.LS.setItem(this.keys.topology, topology);
	              this.LS.setItem(this.keys.weightSpecs, weightSpecs);
	              this.LS.setItem(this.keys.weightData, arrayBufferToBase64String(modelArtifacts.weightData));
	              result = {
	                format: modelArtifacts.format,
	                generatedBy: modelArtifacts.generatedBy,
	                convertedBy: modelArtifacts.convertedBy
	              };

	              if (modelArtifacts.signature != null) {
	                result.signature = modelArtifacts.signature;
	              }

	              if (modelArtifacts.userDefinedMetadata != null) {
	                result.userDefinedMetadata = modelArtifacts.userDefinedMetadata;
	              }

	              if (modelArtifacts.modelInitializer != null) {
	                result.modelInitializer = modelArtifacts.modelInitializer;
	              }

	              this.LS.setItem(this.keys.modelMetadata, JSON.stringify(result));
	              return _context.abrupt("return", {
	                modelArtifactsInfo: modelArtifactsInfo
	              });

	            case 20:
	              _context.prev = 20;
	              _context.t0 = _context["catch"](7);
	              // If saving failed, clean up all items saved so far.
	              this.LS.removeItem(this.keys.info);
	              this.LS.removeItem(this.keys.topology);
	              this.LS.removeItem(this.keys.weightSpecs);
	              this.LS.removeItem(this.keys.weightData);
	              this.LS.removeItem(this.keys.modelMetadata);
	              throw new Error("Failed to save model '" + this.modelPath + "' to local storage: " + "size quota being exceeded is a possible cause of this failure: " + ("modelTopologyBytes=" + modelArtifactsInfo.modelTopologyBytes + ", ") + ("weightSpecsBytes=" + modelArtifactsInfo.weightSpecsBytes + ", ") + ("weightDataBytes=" + modelArtifactsInfo.weightDataBytes + "."));

	            case 28:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, _callee, this, [[7, 20]]);
	    }));

	    function save(_x) {
	      return _save.apply(this, arguments);
	    }

	    return save;
	  }()
	  /**
	   * Load a model from local storage.
	   *
	   * See the documentation to `browserLocalStorage` for details on the saved
	   * artifacts.
	   *
	   * @returns The loaded model (if loading succeeds).
	   */
	  ;

	  _proto.load =
	  /*#__PURE__*/
	  function () {
	    var _load = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
	      var info, out, topology, weightSpecs, metadataString, metadata, weightDataBase64;
	      return regeneratorRuntime.wrap(function _callee2$(_context2) {
	        while (1) {
	          switch (_context2.prev = _context2.next) {
	            case 0:
	              info = JSON.parse(this.LS.getItem(this.keys.info));

	              if (!(info == null)) {
	                _context2.next = 3;
	                break;
	              }

	              throw new Error("In local storage, there is no model with name '" + this.modelPath + "'");

	            case 3:
	              if (!(info.modelTopologyType !== 'JSON')) {
	                _context2.next = 5;
	                break;
	              }

	              throw new Error('BrowserLocalStorage does not support loading non-JSON model ' + 'topology yet.');

	            case 5:
	              out = {}; // Load topology.

	              topology = JSON.parse(this.LS.getItem(this.keys.topology));

	              if (!(topology == null)) {
	                _context2.next = 9;
	                break;
	              }

	              throw new Error("In local storage, the topology of model '" + this.modelPath + "' " + "is missing.");

	            case 9:
	              out.modelTopology = topology; // Load weight specs.

	              weightSpecs = JSON.parse(this.LS.getItem(this.keys.weightSpecs));

	              if (!(weightSpecs == null)) {
	                _context2.next = 13;
	                break;
	              }

	              throw new Error("In local storage, the weight specs of model '" + this.modelPath + "' " + "are missing.");

	            case 13:
	              out.weightSpecs = weightSpecs; // Load meta-data fields.

	              metadataString = this.LS.getItem(this.keys.modelMetadata);

	              if (metadataString != null) {
	                metadata = JSON.parse(metadataString);
	                out.format = metadata['format'];
	                out.generatedBy = metadata['generatedBy'];
	                out.convertedBy = metadata['convertedBy'];

	                if (metadata['signature'] != null) {
	                  out.signature = metadata['signature'];
	                }

	                if (metadata['userDefinedMetadata'] != null) {
	                  out.userDefinedMetadata = metadata['userDefinedMetadata'];
	                }

	                if (metadata['modelInitializer'] != null) {
	                  out.modelInitializer = metadata['modelInitializer'];
	                }
	              } // Load weight data.


	              weightDataBase64 = this.LS.getItem(this.keys.weightData);

	              if (!(weightDataBase64 == null)) {
	                _context2.next = 19;
	                break;
	              }

	              throw new Error("In local storage, the binary weight values of model " + ("'" + this.modelPath + "' are missing."));

	            case 19:
	              out.weightData = base64StringToArrayBuffer(weightDataBase64);
	              return _context2.abrupt("return", out);

	            case 21:
	            case "end":
	              return _context2.stop();
	          }
	        }
	      }, _callee2, this);
	    }));

	    function load() {
	      return _load.apply(this, arguments);
	    }

	    return load;
	  }();

	  return BrowserLocalStorage;
	}();
	BrowserLocalStorage.URL_SCHEME = 'localstorage://';
	var localStorageRouter = function localStorageRouter(url) {
	  if (!env().getBool('IS_BROWSER')) {
	    return null;
	  } else {
	    if (!Array.isArray(url) && url.startsWith(BrowserLocalStorage.URL_SCHEME)) {
	      return browserLocalStorage(url.slice(BrowserLocalStorage.URL_SCHEME.length));
	    } else {
	      return null;
	    }
	  }
	};
	IORouterRegistry.registerSaveRouter(localStorageRouter);
	IORouterRegistry.registerLoadRouter(localStorageRouter);
	/**
	 * Factory function for local storage IOHandler.
	 *
	 * This `IOHandler` supports both `save` and `load`.
	 *
	 * For each model's saved artifacts, four items are saved to local storage.
	 *   - `${PATH_SEPARATOR}/${modelPath}/info`: Contains meta-info about the
	 *     model, such as date saved, type of the topology, size in bytes, etc.
	 *   - `${PATH_SEPARATOR}/${modelPath}/topology`: Model topology. For Keras-
	 *     style models, this is a stringized JSON.
	 *   - `${PATH_SEPARATOR}/${modelPath}/weight_specs`: Weight specs of the
	 *     model, can be used to decode the saved binary weight values (see
	 *     item below).
	 *   - `${PATH_SEPARATOR}/${modelPath}/weight_data`: Concatenated binary
	 *     weight values, stored as a base64-encoded string.
	 *
	 * Saving may throw an `Error` if the total size of the artifacts exceed the
	 * browser-specific quota.
	 *
	 * @param modelPath A unique identifier for the model to be saved. Must be a
	 *   non-empty string.
	 * @returns An instance of `IOHandler`, which can be used with, e.g.,
	 *   `tf.Model.save`.
	 */

	function browserLocalStorage(modelPath) {
	  return new BrowserLocalStorage(modelPath);
	}
	var BrowserLocalStorageManager = /*#__PURE__*/function () {
	  function BrowserLocalStorageManager() {
	    assert(env().getBool('IS_BROWSER'), function () {
	      return 'Current environment is not a web browser';
	    });
	    assert(typeof window === 'undefined' || typeof window.localStorage !== 'undefined', function () {
	      return 'Current browser does not appear to support localStorage';
	    });
	    this.LS = window.localStorage;
	  }

	  var _proto2 = BrowserLocalStorageManager.prototype;

	  _proto2.listModels = /*#__PURE__*/function () {
	    var _listModels = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
	      var out, prefix, suffix, i, key, modelPath;
	      return regeneratorRuntime.wrap(function _callee3$(_context3) {
	        while (1) {
	          switch (_context3.prev = _context3.next) {
	            case 0:
	              out = {};
	              prefix = PATH_PREFIX + PATH_SEPARATOR;
	              suffix = PATH_SEPARATOR + INFO_SUFFIX;

	              for (i = 0; i < this.LS.length; ++i) {
	                key = this.LS.key(i);

	                if (key.startsWith(prefix) && key.endsWith(suffix)) {
	                  modelPath = getModelPathFromKey(key);
	                  out[modelPath] = JSON.parse(this.LS.getItem(key));
	                }
	              }

	              return _context3.abrupt("return", out);

	            case 5:
	            case "end":
	              return _context3.stop();
	          }
	        }
	      }, _callee3, this);
	    }));

	    function listModels() {
	      return _listModels.apply(this, arguments);
	    }

	    return listModels;
	  }();

	  _proto2.removeModel = /*#__PURE__*/function () {
	    var _removeModel = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(path) {
	      var keys, info;
	      return regeneratorRuntime.wrap(function _callee4$(_context4) {
	        while (1) {
	          switch (_context4.prev = _context4.next) {
	            case 0:
	              path = maybeStripScheme$1(path);
	              keys = getModelKeys(path);

	              if (!(this.LS.getItem(keys.info) == null)) {
	                _context4.next = 4;
	                break;
	              }

	              throw new Error("Cannot find model at path '" + path + "'");

	            case 4:
	              info = JSON.parse(this.LS.getItem(keys.info));
	              this.LS.removeItem(keys.info);
	              this.LS.removeItem(keys.topology);
	              this.LS.removeItem(keys.weightSpecs);
	              this.LS.removeItem(keys.weightData);
	              return _context4.abrupt("return", info);

	            case 10:
	            case "end":
	              return _context4.stop();
	          }
	        }
	      }, _callee4, this);
	    }));

	    function removeModel(_x2) {
	      return _removeModel.apply(this, arguments);
	    }

	    return removeModel;
	  }();

	  return BrowserLocalStorageManager;
	}();

	var URL_SCHEME_SUFFIX = '://';
	var ModelStoreManagerRegistry = /*#__PURE__*/function () {
	  function ModelStoreManagerRegistry() {
	    this.managers = {};
	  }

	  ModelStoreManagerRegistry.getInstance = function getInstance() {
	    if (ModelStoreManagerRegistry.instance == null) {
	      ModelStoreManagerRegistry.instance = new ModelStoreManagerRegistry();
	    }

	    return ModelStoreManagerRegistry.instance;
	  }
	  /**
	   * Register a save-handler router.
	   *
	   * @param saveRouter A function that maps a URL-like string onto an instance
	   * of `IOHandler` with the `save` method defined or `null`.
	   */
	  ;

	  ModelStoreManagerRegistry.registerManager = function registerManager(scheme, manager) {
	    assert(scheme != null, function () {
	      return 'scheme must not be undefined or null.';
	    });

	    if (scheme.endsWith(URL_SCHEME_SUFFIX)) {
	      scheme = scheme.slice(0, scheme.indexOf(URL_SCHEME_SUFFIX));
	    }

	    assert(scheme.length > 0, function () {
	      return 'scheme must not be an empty string.';
	    });
	    var registry = ModelStoreManagerRegistry.getInstance();
	    assert(registry.managers[scheme] == null, function () {
	      return "A model store manager is already registered for scheme '" + scheme + "'.";
	    });
	    registry.managers[scheme] = manager;
	  };

	  ModelStoreManagerRegistry.getManager = function getManager(scheme) {
	    var manager = this.getInstance().managers[scheme];

	    if (manager == null) {
	      throw new Error("Cannot find model manager for scheme '" + scheme + "'");
	    }

	    return manager;
	  };

	  ModelStoreManagerRegistry.getSchemes = function getSchemes() {
	    return Object.keys(this.getInstance().managers);
	  };

	  return ModelStoreManagerRegistry;
	}();
	/**
	 * Helper method for parsing a URL string into a scheme and a path.
	 *
	 * @param url E.g., 'localstorage://my-model'
	 * @returns A dictionary with two fields: scheme and path.
	 *   Scheme: e.g., 'localstorage' in the example above.
	 *   Path: e.g., 'my-model' in the example above.
	 */

	function parseURL$1(url) {
	  if (url.indexOf(URL_SCHEME_SUFFIX) === -1) {
	    throw new Error("The url string provided does not contain a scheme. " + "Supported schemes are: " + ("" + ModelStoreManagerRegistry.getSchemes().join(',')));
	  }

	  return {
	    scheme: url.split(URL_SCHEME_SUFFIX)[0],
	    path: url.split(URL_SCHEME_SUFFIX)[1]
	  };
	}

	function cloneModelInternal(_x, _x2, _x3) {
	  return _cloneModelInternal.apply(this, arguments);
	}
	/**
	 * List all models stored in registered storage mediums.
	 *
	 * For a web browser environment, the registered mediums are Local Storage and
	 * IndexedDB.
	 *
	 * ```js
	 * // First create and save a model.
	 * const model = tf.sequential();
	 * model.add(tf.layers.dense(
	 *     {units: 1, inputShape: [10], activation: 'sigmoid'}));
	 * await model.save('localstorage://demo/management/model1');
	 *
	 * // Then list existing models.
	 * console.log(JSON.stringify(await tf.io.listModels()));
	 *
	 * // Delete the model.
	 * await tf.io.removeModel('localstorage://demo/management/model1');
	 *
	 * // List models again.
	 * console.log(JSON.stringify(await tf.io.listModels()));
	 * ```
	 *
	 * @returns A `Promise` of a dictionary mapping URLs of existing models to
	 * their model artifacts info. URLs include medium-specific schemes, e.g.,
	 *   'indexeddb://my/model/1'. Model artifacts info include type of the
	 * model's topology, byte sizes of the topology, weights, etc.
	 *
	 * @doc {
	 *   heading: 'Models',
	 *   subheading: 'Management',
	 *   namespace: 'io',
	 *   ignoreCI: true
	 * }
	 */


	function _cloneModelInternal() {
	  _cloneModelInternal = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(sourceURL, destURL, deleteSource) {
	    var loadHandlers, loadHandler, saveHandlers, saveHandler, sourceScheme, sourcePath, sameMedium, modelArtifacts, saveResult;
	    return regeneratorRuntime.wrap(function _callee$(_context) {
	      while (1) {
	        switch (_context.prev = _context.next) {
	          case 0:
	            if (deleteSource === void 0) {
	              deleteSource = false;
	            }

	            assert(sourceURL !== destURL, function () {
	              return "Old path and new path are the same: '" + sourceURL + "'";
	            });
	            loadHandlers = IORouterRegistry.getLoadHandlers(sourceURL);
	            assert(loadHandlers.length > 0, function () {
	              return "Copying failed because no load handler is found for source URL " + sourceURL + ".";
	            });
	            assert(loadHandlers.length < 2, function () {
	              return "Copying failed because more than one (" + loadHandlers.length + ") " + ("load handlers for source URL " + sourceURL + ".");
	            });
	            loadHandler = loadHandlers[0];
	            saveHandlers = IORouterRegistry.getSaveHandlers(destURL);
	            assert(saveHandlers.length > 0, function () {
	              return "Copying failed because no save handler is found for destination " + ("URL " + destURL + ".");
	            });
	            assert(saveHandlers.length < 2, function () {
	              return "Copying failed because more than one (" + loadHandlers.length + ") " + ("save handlers for destination URL " + destURL + ".");
	            });
	            saveHandler = saveHandlers[0];
	            sourceScheme = parseURL$1(sourceURL).scheme;
	            sourcePath = parseURL$1(sourceURL).path;
	            sameMedium = sourceScheme === parseURL$1(sourceURL).scheme;
	            _context.next = 15;
	            return loadHandler.load();

	          case 15:
	            modelArtifacts = _context.sent;

	            if (!(deleteSource && sameMedium)) {
	              _context.next = 19;
	              break;
	            }

	            _context.next = 19;
	            return ModelStoreManagerRegistry.getManager(sourceScheme).removeModel(sourcePath);

	          case 19:
	            _context.next = 21;
	            return saveHandler.save(modelArtifacts);

	          case 21:
	            saveResult = _context.sent;

	            if (!(deleteSource && !sameMedium)) {
	              _context.next = 25;
	              break;
	            }

	            _context.next = 25;
	            return ModelStoreManagerRegistry.getManager(sourceScheme).removeModel(sourcePath);

	          case 25:
	            return _context.abrupt("return", saveResult.modelArtifactsInfo);

	          case 26:
	          case "end":
	            return _context.stop();
	        }
	      }
	    }, _callee);
	  }));
	  return _cloneModelInternal.apply(this, arguments);
	}

	function listModels() {
	  return _listModels.apply(this, arguments);
	}
	/**
	 * Remove a model specified by URL from a reigstered storage medium.
	 *
	 * ```js
	 * // First create and save a model.
	 * const model = tf.sequential();
	 * model.add(tf.layers.dense(
	 *     {units: 1, inputShape: [10], activation: 'sigmoid'}));
	 * await model.save('localstorage://demo/management/model1');
	 *
	 * // Then list existing models.
	 * console.log(JSON.stringify(await tf.io.listModels()));
	 *
	 * // Delete the model.
	 * await tf.io.removeModel('localstorage://demo/management/model1');
	 *
	 * // List models again.
	 * console.log(JSON.stringify(await tf.io.listModels()));
	 * ```
	 *
	 * @param url A URL to a stored model, with a scheme prefix, e.g.,
	 *   'localstorage://my-model-1', 'indexeddb://my/model/2'.
	 * @returns ModelArtifactsInfo of the deleted model (if and only if deletion
	 *   is successful).
	 * @throws Error if deletion fails, e.g., if no model exists at `path`.
	 *
	 * @doc {
	 *   heading: 'Models',
	 *   subheading: 'Management',
	 *   namespace: 'io',
	 *   ignoreCI: true
	 * }
	 */


	function _listModels() {
	  _listModels = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
	    var schemes, out, _iterator, _step, scheme, schemeOut, path, url;

	    return regeneratorRuntime.wrap(function _callee2$(_context2) {
	      while (1) {
	        switch (_context2.prev = _context2.next) {
	          case 0:
	            schemes = ModelStoreManagerRegistry.getSchemes();
	            out = {};
	            _iterator = _createForOfIteratorHelperLoose(schemes);

	          case 3:
	            if ((_step = _iterator()).done) {
	              _context2.next = 11;
	              break;
	            }

	            scheme = _step.value;
	            _context2.next = 7;
	            return ModelStoreManagerRegistry.getManager(scheme).listModels();

	          case 7:
	            schemeOut = _context2.sent;

	            for (path in schemeOut) {
	              url = scheme + URL_SCHEME_SUFFIX + path;
	              out[url] = schemeOut[path];
	            }

	          case 9:
	            _context2.next = 3;
	            break;

	          case 11:
	            return _context2.abrupt("return", out);

	          case 12:
	          case "end":
	            return _context2.stop();
	        }
	      }
	    }, _callee2);
	  }));
	  return _listModels.apply(this, arguments);
	}

	function removeModel(_x4) {
	  return _removeModel.apply(this, arguments);
	}
	/**
	 * Copy a model from one URL to another.
	 *
	 * This function supports:
	 *
	 * 1. Copying within a storage medium, e.g.,
	 *    `tf.io.copyModel('localstorage://model-1', 'localstorage://model-2')`
	 * 2. Copying between two storage mediums, e.g.,
	 *    `tf.io.copyModel('localstorage://model-1', 'indexeddb://model-1')`
	 *
	 * ```js
	 * // First create and save a model.
	 * const model = tf.sequential();
	 * model.add(tf.layers.dense(
	 *     {units: 1, inputShape: [10], activation: 'sigmoid'}));
	 * await model.save('localstorage://demo/management/model1');
	 *
	 * // Then list existing models.
	 * console.log(JSON.stringify(await tf.io.listModels()));
	 *
	 * // Copy the model, from Local Storage to IndexedDB.
	 * await tf.io.copyModel(
	 *     'localstorage://demo/management/model1',
	 *     'indexeddb://demo/management/model1');
	 *
	 * // List models again.
	 * console.log(JSON.stringify(await tf.io.listModels()));
	 *
	 * // Remove both models.
	 * await tf.io.removeModel('localstorage://demo/management/model1');
	 * await tf.io.removeModel('indexeddb://demo/management/model1');
	 * ```
	 *
	 * @param sourceURL Source URL of copying.
	 * @param destURL Destination URL of copying.
	 * @returns ModelArtifactsInfo of the copied model (if and only if copying
	 *   is successful).
	 * @throws Error if copying fails, e.g., if no model exists at `sourceURL`, or
	 *   if `oldPath` and `newPath` are identical.
	 *
	 * @doc {
	 *   heading: 'Models',
	 *   subheading: 'Management',
	 *   namespace: 'io',
	 *   ignoreCI: true
	 * }
	 */


	function _removeModel() {
	  _removeModel = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(url) {
	    var schemeAndPath, manager;
	    return regeneratorRuntime.wrap(function _callee3$(_context3) {
	      while (1) {
	        switch (_context3.prev = _context3.next) {
	          case 0:
	            schemeAndPath = parseURL$1(url);
	            manager = ModelStoreManagerRegistry.getManager(schemeAndPath.scheme);
	            return _context3.abrupt("return", manager.removeModel(schemeAndPath.path));

	          case 3:
	          case "end":
	            return _context3.stop();
	        }
	      }
	    }, _callee3);
	  }));
	  return _removeModel.apply(this, arguments);
	}

	function copyModel(_x5, _x6) {
	  return _copyModel.apply(this, arguments);
	}
	/**
	 * Move a model from one URL to another.
	 *
	 * This function supports:
	 *
	 * 1. Moving within a storage medium, e.g.,
	 *    `tf.io.moveModel('localstorage://model-1', 'localstorage://model-2')`
	 * 2. Moving between two storage mediums, e.g.,
	 *    `tf.io.moveModel('localstorage://model-1', 'indexeddb://model-1')`
	 *
	 * ```js
	 * // First create and save a model.
	 * const model = tf.sequential();
	 * model.add(tf.layers.dense(
	 *     {units: 1, inputShape: [10], activation: 'sigmoid'}));
	 * await model.save('localstorage://demo/management/model1');
	 *
	 * // Then list existing models.
	 * console.log(JSON.stringify(await tf.io.listModels()));
	 *
	 * // Move the model, from Local Storage to IndexedDB.
	 * await tf.io.moveModel(
	 *     'localstorage://demo/management/model1',
	 *     'indexeddb://demo/management/model1');
	 *
	 * // List models again.
	 * console.log(JSON.stringify(await tf.io.listModels()));
	 *
	 * // Remove the moved model.
	 * await tf.io.removeModel('indexeddb://demo/management/model1');
	 * ```
	 *
	 * @param sourceURL Source URL of moving.
	 * @param destURL Destination URL of moving.
	 * @returns ModelArtifactsInfo of the copied model (if and only if copying
	 *   is successful).
	 * @throws Error if moving fails, e.g., if no model exists at `sourceURL`, or
	 *   if `oldPath` and `newPath` are identical.
	 *
	 * @doc {
	 *   heading: 'Models',
	 *   subheading: 'Management',
	 *   namespace: 'io',
	 *   ignoreCI: true
	 * }
	 */


	function _copyModel() {
	  _copyModel = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(sourceURL, destURL) {
	    var deleteSource;
	    return regeneratorRuntime.wrap(function _callee4$(_context4) {
	      while (1) {
	        switch (_context4.prev = _context4.next) {
	          case 0:
	            deleteSource = false;
	            return _context4.abrupt("return", cloneModelInternal(sourceURL, destURL, deleteSource));

	          case 2:
	          case "end":
	            return _context4.stop();
	        }
	      }
	    }, _callee4);
	  }));
	  return _copyModel.apply(this, arguments);
	}

	function moveModel(_x7, _x8) {
	  return _moveModel.apply(this, arguments);
	}

	function _moveModel() {
	  _moveModel = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5(sourceURL, destURL) {
	    var deleteSource;
	    return regeneratorRuntime.wrap(function _callee5$(_context5) {
	      while (1) {
	        switch (_context5.prev = _context5.next) {
	          case 0:
	            deleteSource = true;
	            return _context5.abrupt("return", cloneModelInternal(sourceURL, destURL, deleteSource));

	          case 2:
	          case "end":
	            return _context5.stop();
	        }
	      }
	    }, _callee5);
	  }));
	  return _moveModel.apply(this, arguments);
	}

	/**
	 * @license
	 * Copyright 2019 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var PlatformBrowser = /*#__PURE__*/function () {
	  function PlatformBrowser() {}

	  var _proto = PlatformBrowser.prototype;

	  _proto.fetch = function (_fetch) {
	    function fetch(_x, _x2) {
	      return _fetch.apply(this, arguments);
	    }

	    fetch.toString = function () {
	      return _fetch.toString();
	    };

	    return fetch;
	  }(function (path, init) {
	    return fetch(path, init);
	  });

	  _proto.now = function now() {
	    return performance.now();
	  };

	  _proto.encode = function encode(text, encoding) {
	    if (encoding !== 'utf-8' && encoding !== 'utf8') {
	      throw new Error("Browser's encoder only supports utf-8, but got " + encoding);
	    }

	    if (this.textEncoder == null) {
	      this.textEncoder = new TextEncoder();
	    }

	    return this.textEncoder.encode(text);
	  };

	  _proto.decode = function decode(bytes, encoding) {
	    return new TextDecoder(encoding).decode(bytes);
	  };

	  return PlatformBrowser;
	}();

	if (env().get('IS_BROWSER')) {
	  env().setPlatform('browser', new PlatformBrowser()); // Register LocalStorage IOHandler

	  try {
	    ModelStoreManagerRegistry.registerManager(BrowserLocalStorage.URL_SCHEME, new BrowserLocalStorageManager());
	  } catch (err) {} // Register IndexedDB IOHandler


	  try {
	    ModelStoreManagerRegistry.registerManager(BrowserIndexedDB.URL_SCHEME, new BrowserIndexedDBManager());
	  } catch (err) {}
	}

	/**
	 * @license
	 * Copyright 2019 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */

	var getNodeFetch = {
	  // tslint:disable-next-line:no-require-imports
	  importFetch: function importFetch() {
	    return require('node-fetch');
	  }
	};
	var systemFetch; // These getters and setters are for testing so we don't export a mutable
	// variable.

	function resetSystemFetch() {
	  systemFetch = null;
	}
	function setSystemFetch(fetchFn) {
	  systemFetch = fetchFn;
	}
	function getSystemFetch() {
	  return systemFetch;
	}
	var PlatformNode = /*#__PURE__*/function () {
	  function PlatformNode() {
	    // tslint:disable-next-line:no-require-imports
	    this.util = require('util'); // According to the spec, the built-in encoder can do only UTF-8 encoding.
	    // https://developer.mozilla.org/en-US/docs/Web/API/TextEncoder/TextEncoder

	    this.textEncoder = new this.util.TextEncoder();
	  }

	  var _proto = PlatformNode.prototype;

	  _proto.fetch = function fetch(path, requestInits) {
	    if (env().global.fetch != null) {
	      return env().global.fetch(path, requestInits);
	    }

	    if (systemFetch == null) {
	      systemFetch = getNodeFetch.importFetch();
	    }

	    return systemFetch(path, requestInits);
	  };

	  _proto.now = function now() {
	    var time = process.hrtime();
	    return time[0] * 1000 + time[1] / 1000000;
	  };

	  _proto.encode = function encode(text, encoding) {
	    if (encoding !== 'utf-8' && encoding !== 'utf8') {
	      throw new Error("Node built-in encoder only supports utf-8, but got " + encoding);
	    }

	    return this.textEncoder.encode(text);
	  };

	  _proto.decode = function decode(bytes, encoding) {
	    if (bytes.length === 0) {
	      return '';
	    }

	    return new this.util.TextDecoder(encoding).decode(bytes);
	  };

	  return PlatformNode;
	}();

	if (env().get('IS_NODE')) {
	  env().setPlatform('node', new PlatformNode());
	}

	/**
	 * @license
	 * Copyright 2020 Google Inc. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Creates an empty `tf.TensorBuffer` with the specified `shape` and `dtype`.
	 *
	 * The values are stored in CPU as `TypedArray`. Fill the buffer using
	 * `buffer.set()`, or by modifying directly `buffer.values`.
	 *
	 * When done, call `buffer.toTensor()` to get an immutable `tf.Tensor` with
	 * those values.
	 *
	 * ```js
	 * // Create a buffer and set values at particular indices.
	 * const buffer = tf.buffer([2, 2]);
	 * buffer.set(3, 0, 0);
	 * buffer.set(5, 1, 0);
	 *
	 * // Convert the buffer back to a tensor.
	 * buffer.toTensor().print();
	 * ```
	 *
	 * @param shape An array of integers defining the output tensor shape.
	 * @param dtype The dtype of the buffer. Defaults to 'float32'.
	 * @param values The values of the buffer as `TypedArray`. Defaults to
	 * zeros.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */

	function buffer(shape, dtype, values) {
	  if (dtype === void 0) {
	    dtype = 'float32';
	  }

	  dtype = dtype || 'float32';
	  assertNonNegativeIntegerDimensions(shape);
	  return new TensorBuffer(shape, dtype, values);
	}

	/**
	 * @license
	 * Copyright 2020 Google Inc. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Casts a `tf.Tensor` to a new dtype.
	 *
	 * ```js
	 * const x = tf.tensor1d([1.5, 2.5, 3]);
	 * tf.cast(x, 'int32').print();
	 * ```
	 * @param x The input tensor to be casted.
	 * @param dtype The dtype to cast the input tensor to.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Transformations'}
	 */

	function cast_(x, dtype) {
	  var $x = convertToTensor(x, 'x', 'cast'); // Sanity checks.

	  if (!isValidDtype(dtype)) {
	    throw new Error("Failed to cast to unknown dtype " + dtype);
	  }

	  if (dtype === 'string' && $x.dtype !== 'string' || dtype !== 'string' && $x.dtype === 'string') {
	    throw new Error('Only strings can be casted to strings');
	  }

	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    dtype: dtype
	  };
	  return ENGINE.runKernel(Cast, inputs, attrs);
	}

	var cast = op({
	  cast_: cast_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Creates a new tensor with the same values and shape as the specified
	 * tensor.
	 *
	 * ```js
	 * const x = tf.tensor([1, 2]);
	 *
	 * x.clone().print();
	 * ```
	 *
	 * @param x The tensor to clone.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */

	function clone_(x) {
	  var $x = convertToTensor(x, 'x', 'clone', 'string_or_numeric');
	  var inputs = {
	    x: $x
	  }; // Note this op is called tf.identity in python. Hence the kernel name used
	  // here.

	  return ENGINE.runKernel(Identity, inputs);
	}

	var clone = op({
	  clone_: clone_
	});

	/**
	 * @license
	 * Copyright 2020 Google Inc. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */

	/**
	 * Prints information about the `tf.Tensor` including its data.
	 *
	 * ```js
	 * const verbose = true;
	 * tf.tensor2d([1, 2, 3, 4], [2, 2]).print(verbose);
	 * ```
	 * @param x The tensor to be printed.
	 * @param verbose Whether to print verbose information about the ` Tensor`,
	 * including dtype and size.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */
	function print(x, verbose) {
	  if (verbose === void 0) {
	    verbose = false;
	  }

	  console.log(x.toString(verbose));
	}

	/**
	 * @license
	 * Copyright 2020 Google Inc. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	getOrMakeEngine(); // Register backend-agnostic flags.
	var opHandler$1 = {
	  buffer: buffer,
	  cast: cast,
	  clone: clone,
	  print: print
	};
	setOpHandler(opHandler$1);

	var DEFAULT_FILE_NAME_PREFIX = 'model';
	var DEFAULT_JSON_EXTENSION_NAME = '.json';
	var DEFAULT_WEIGHT_DATA_EXTENSION_NAME = '.weights.bin';

	function defer$1(f) {
	  return new Promise(function (resolve) {
	    return setTimeout(resolve);
	  }).then(f);
	}

	var BrowserDownloads = /*#__PURE__*/function () {
	  function BrowserDownloads(fileNamePrefix) {
	    if (!env().getBool('IS_BROWSER')) {
	      // TODO(cais): Provide info on what IOHandlers are available under the
	      //   current environment.
	      throw new Error('browserDownloads() cannot proceed because the current environment ' + 'is not a browser.');
	    }

	    if (fileNamePrefix.startsWith(BrowserDownloads.URL_SCHEME)) {
	      fileNamePrefix = fileNamePrefix.slice(BrowserDownloads.URL_SCHEME.length);
	    }

	    if (fileNamePrefix == null || fileNamePrefix.length === 0) {
	      fileNamePrefix = DEFAULT_FILE_NAME_PREFIX;
	    }

	    this.modelTopologyFileName = fileNamePrefix + DEFAULT_JSON_EXTENSION_NAME;
	    this.weightDataFileName = fileNamePrefix + DEFAULT_WEIGHT_DATA_EXTENSION_NAME;
	  }

	  var _proto = BrowserDownloads.prototype;

	  _proto.save = /*#__PURE__*/function () {
	    var _save = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(modelArtifacts) {
	      var weightsURL, weightsManifest, modelTopologyAndWeightManifest, modelTopologyAndWeightManifestURL, jsonAnchor, weightDataAnchor;
	      return regeneratorRuntime.wrap(function _callee$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              if (!(typeof document === 'undefined')) {
	                _context.next = 2;
	                break;
	              }

	              throw new Error('Browser downloads are not supported in ' + 'this environment since `document` is not present');

	            case 2:
	              weightsURL = window.URL.createObjectURL(new Blob([modelArtifacts.weightData], {
	                type: 'application/octet-stream'
	              }));

	              if (!(modelArtifacts.modelTopology instanceof ArrayBuffer)) {
	                _context.next = 7;
	                break;
	              }

	              throw new Error('BrowserDownloads.save() does not support saving model topology ' + 'in binary formats yet.');

	            case 7:
	              weightsManifest = [{
	                paths: ['./' + this.weightDataFileName],
	                weights: modelArtifacts.weightSpecs
	              }];
	              modelTopologyAndWeightManifest = {
	                modelTopology: modelArtifacts.modelTopology,
	                format: modelArtifacts.format,
	                generatedBy: modelArtifacts.generatedBy,
	                convertedBy: modelArtifacts.convertedBy,
	                weightsManifest: weightsManifest
	              };

	              if (modelArtifacts.signature != null) {
	                modelTopologyAndWeightManifest.signature = modelArtifacts.signature;
	              }

	              if (modelArtifacts.userDefinedMetadata != null) {
	                modelTopologyAndWeightManifest.userDefinedMetadata = modelArtifacts.userDefinedMetadata;
	              }

	              if (modelArtifacts.modelInitializer != null) {
	                modelTopologyAndWeightManifest.modelInitializer = modelArtifacts.modelInitializer;
	              }

	              modelTopologyAndWeightManifestURL = window.URL.createObjectURL(new Blob([JSON.stringify(modelTopologyAndWeightManifest)], {
	                type: 'application/json'
	              })); // If anchor elements are not provided, create them without attaching them
	              // to parents, so that the downloaded file names can be controlled.

	              jsonAnchor = this.jsonAnchor == null ? document.createElement('a') : this.jsonAnchor;
	              jsonAnchor.download = this.modelTopologyFileName;
	              jsonAnchor.href = modelTopologyAndWeightManifestURL; // Trigger downloads by evoking a click event on the download anchors.
	              // When multiple downloads are started synchronously, Firefox will only
	              // save the last one.

	              _context.next = 18;
	              return defer$1(function () {
	                return jsonAnchor.dispatchEvent(new MouseEvent('click'));
	              });

	            case 18:
	              if (!(modelArtifacts.weightData != null)) {
	                _context.next = 24;
	                break;
	              }

	              weightDataAnchor = this.weightDataAnchor == null ? document.createElement('a') : this.weightDataAnchor;
	              weightDataAnchor.download = this.weightDataFileName;
	              weightDataAnchor.href = weightsURL;
	              _context.next = 24;
	              return defer$1(function () {
	                return weightDataAnchor.dispatchEvent(new MouseEvent('click'));
	              });

	            case 24:
	              return _context.abrupt("return", {
	                modelArtifactsInfo: getModelArtifactsInfoForJSON(modelArtifacts)
	              });

	            case 25:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, _callee, this);
	    }));

	    function save(_x) {
	      return _save.apply(this, arguments);
	    }

	    return save;
	  }();

	  return BrowserDownloads;
	}();
	BrowserDownloads.URL_SCHEME = 'downloads://';

	var BrowserFiles = /*#__PURE__*/function () {
	  function BrowserFiles(files) {
	    if (files == null || files.length < 1) {
	      throw new Error("When calling browserFiles, at least 1 file is required, " + ("but received " + files));
	    }

	    this.files = files;
	  }

	  var _proto2 = BrowserFiles.prototype;

	  _proto2.load = /*#__PURE__*/function () {
	    var _load = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
	      var _this = this;

	      var jsonFile, weightFiles;
	      return regeneratorRuntime.wrap(function _callee2$(_context2) {
	        while (1) {
	          switch (_context2.prev = _context2.next) {
	            case 0:
	              jsonFile = this.files[0];
	              weightFiles = this.files.slice(1);
	              return _context2.abrupt("return", new Promise(function (resolve, reject) {
	                var jsonReader = new FileReader();

	                jsonReader.onload = function (event) {
	                  // tslint:disable-next-line:no-any
	                  var modelJSON = JSON.parse(event.target.result);
	                  var modelTopology = modelJSON.modelTopology;

	                  if (modelTopology == null) {
	                    reject(new Error("modelTopology field is missing from file " + jsonFile.name));
	                    return;
	                  }

	                  if (weightFiles.length === 0) {
	                    resolve({
	                      modelTopology: modelTopology
	                    });
	                  }

	                  var weightsManifest = modelJSON.weightsManifest;

	                  if (weightsManifest == null) {
	                    reject(new Error("weightManifest field is missing from file " + jsonFile.name));
	                    return;
	                  }

	                  var pathToFile;

	                  try {
	                    pathToFile = _this.checkManifestAndWeightFiles(weightsManifest, weightFiles);
	                  } catch (err) {
	                    reject(err);
	                    return;
	                  }

	                  var weightSpecs = [];
	                  var paths = [];
	                  var perFileBuffers = [];
	                  weightsManifest.forEach(function (weightsGroup) {
	                    weightsGroup.paths.forEach(function (path) {
	                      paths.push(path);
	                      perFileBuffers.push(null);
	                    });
	                    weightSpecs.push.apply(weightSpecs, weightsGroup.weights);
	                  });
	                  weightsManifest.forEach(function (weightsGroup) {
	                    weightsGroup.paths.forEach(function (path) {
	                      var weightFileReader = new FileReader();

	                      weightFileReader.onload = function (event) {
	                        // tslint:disable-next-line:no-any
	                        var weightData = event.target.result;
	                        var index = paths.indexOf(path);
	                        perFileBuffers[index] = weightData;

	                        if (perFileBuffers.indexOf(null) === -1) {
	                          var result = {
	                            modelTopology: modelTopology,
	                            weightSpecs: weightSpecs,
	                            weightData: concatenateArrayBuffers(perFileBuffers),
	                            format: modelJSON.format,
	                            generatedBy: modelJSON.generatedBy,
	                            convertedBy: modelJSON.convertedBy
	                          };

	                          if (modelJSON.signature != null) {
	                            result.signature = modelJSON.signature;
	                          }

	                          if (modelJSON.userDefinedMetadata != null) {
	                            result.userDefinedMetadata = modelJSON.userDefinedMetadata;
	                          }

	                          if (modelJSON.modelInitializer != null) {
	                            result.modelInitializer = modelJSON.modelInitializer;
	                          }

	                          resolve(result);
	                        }
	                      };

	                      weightFileReader.onerror = function (error) {
	                        return reject("Failed to weights data from file of path '" + path + "'.");
	                      };

	                      weightFileReader.readAsArrayBuffer(pathToFile[path]);
	                    });
	                  });
	                };

	                jsonReader.onerror = function (error) {
	                  return reject("Failed to read model topology and weights manifest JSON " + ("from file '" + jsonFile.name + "'. BrowserFiles supports loading ") + "Keras-style tf.Model artifacts only.");
	                };

	                jsonReader.readAsText(jsonFile);
	              }));

	            case 3:
	            case "end":
	              return _context2.stop();
	          }
	        }
	      }, _callee2, this);
	    }));

	    function load() {
	      return _load.apply(this, arguments);
	    }

	    return load;
	  }()
	  /**
	   * Check the compatibility between weights manifest and weight files.
	   */
	  ;

	  _proto2.checkManifestAndWeightFiles = function checkManifestAndWeightFiles(manifest, files) {
	    var basenames = [];
	    var fileNames = files.map(function (file) {
	      return basename(file.name);
	    });
	    var pathToFile = {};

	    for (var _iterator = _createForOfIteratorHelperLoose(manifest), _step; !(_step = _iterator()).done;) {
	      var group = _step.value;
	      group.paths.forEach(function (path) {
	        var pathBasename = basename(path);

	        if (basenames.indexOf(pathBasename) !== -1) {
	          throw new Error("Duplicate file basename found in weights manifest: " + ("'" + pathBasename + "'"));
	        }

	        basenames.push(pathBasename);

	        if (fileNames.indexOf(pathBasename) === -1) {
	          throw new Error("Weight file with basename '" + pathBasename + "' is not provided.");
	        } else {
	          pathToFile[path] = files[fileNames.indexOf(pathBasename)];
	        }
	      });
	    }

	    if (basenames.length !== files.length) {
	      throw new Error("Mismatch in the number of files in weights manifest " + ("(" + basenames.length + ") and the number of weight files provided ") + ("(" + files.length + ")."));
	    }

	    return pathToFile;
	  };

	  return BrowserFiles;
	}();

	var browserDownloadsRouter = function browserDownloadsRouter(url) {
	  if (!env().getBool('IS_BROWSER')) {
	    return null;
	  } else {
	    if (!Array.isArray(url) && url.startsWith(BrowserDownloads.URL_SCHEME)) {
	      return browserDownloads(url.slice(BrowserDownloads.URL_SCHEME.length));
	    } else {
	      return null;
	    }
	  }
	};
	IORouterRegistry.registerSaveRouter(browserDownloadsRouter);
	/**
	 * Creates an IOHandler that triggers file downloads from the browser.
	 *
	 * The returned `IOHandler` instance can be used as model exporting methods such
	 * as `tf.Model.save` and supports only saving.
	 *
	 * ```js
	 * const model = tf.sequential();
	 * model.add(tf.layers.dense(
	 *     {units: 1, inputShape: [10], activation: 'sigmoid'}));
	 * const saveResult = await model.save('downloads://mymodel');
	 * // This will trigger downloading of two files:
	 * //   'mymodel.json' and 'mymodel.weights.bin'.
	 * console.log(saveResult);
	 * ```
	 *
	 * @param fileNamePrefix Prefix name of the files to be downloaded. For use with
	 *   `tf.Model`, `fileNamePrefix` should follow either of the following two
	 *   formats:
	 *   1. `null` or `undefined`, in which case the default file
	 *      names will be used:
	 *      - 'model.json' for the JSON file containing the model topology and
	 *        weights manifest.
	 *      - 'model.weights.bin' for the binary file containing the binary weight
	 *        values.
	 *   2. A single string or an Array of a single string, as the file name prefix.
	 *      For example, if `'foo'` is provided, the downloaded JSON
	 *      file and binary weights file will be named 'foo.json' and
	 *      'foo.weights.bin', respectively.
	 * @param config Additional configuration for triggering downloads.
	 * @returns An instance of `BrowserDownloads` `IOHandler`.
	 *
	 * @doc {
	 *   heading: 'Models',
	 *   subheading: 'Loading',
	 *   namespace: 'io',
	 *   ignoreCI: true
	 * }
	 */

	function browserDownloads(fileNamePrefix) {
	  if (fileNamePrefix === void 0) {
	    fileNamePrefix = 'model';
	  }

	  return new BrowserDownloads(fileNamePrefix);
	}
	/**
	 * Creates an IOHandler that loads model artifacts from user-selected files.
	 *
	 * This method can be used for loading from files such as user-selected files
	 * in the browser.
	 * When used in conjunction with `tf.loadLayersModel`, an instance of
	 * `tf.LayersModel` (Keras-style) can be constructed from the loaded artifacts.
	 *
	 * ```js
	 * // Note: This code snippet won't run properly without the actual file input
	 * //   elements in the HTML DOM.
	 *
	 * // Suppose there are two HTML file input (`<input type="file" ...>`)
	 * // elements.
	 * const uploadJSONInput = document.getElementById('upload-json');
	 * const uploadWeightsInput = document.getElementById('upload-weights');
	 * const model = await tf.loadLayersModel(tf.io.browserFiles(
	 *     [uploadJSONInput.files[0], uploadWeightsInput.files[0]]));
	 * ```
	 *
	 * @param files `File`s to load from. Currently, this function supports only
	 *   loading from files that contain Keras-style models (i.e., `tf.Model`s), for
	 *   which an `Array` of `File`s is expected (in that order):
	 *   - A JSON file containing the model topology and weight manifest.
	 *   - Optionally, One or more binary files containing the binary weights.
	 *     These files must have names that match the paths in the `weightsManifest`
	 *     contained by the aforementioned JSON file, or errors will be thrown
	 *     during loading. These weights files have the same format as the ones
	 *     generated by `tensorflowjs_converter` that comes with the `tensorflowjs`
	 *     Python PIP package. If no weights files are provided, only the model
	 *     topology will be loaded from the JSON file above.
	 * @returns An instance of `Files` `IOHandler`.
	 *
	 * @doc {
	 *   heading: 'Models',
	 *   subheading: 'Loading',
	 *   namespace: 'io',
	 *   ignoreCI: true
	 * }
	 */

	function browserFiles(files) {
	  return new BrowserFiles(files);
	}

	/**
	 * @license
	 * Copyright 2019 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Monitor Promise.all progress, fire onProgress callback function.
	 *
	 * @param promises Promise list going to be monitored
	 * @param onProgress Callback function. Fired when a promise resolved.
	 * @param startFraction Optional fraction start. Default to 0.
	 * @param endFraction Optional fraction end. Default to 1.
	 */

	function monitorPromisesProgress(promises, onProgress, startFraction, endFraction) {
	  checkPromises(promises);
	  startFraction = startFraction == null ? 0 : startFraction;
	  endFraction = endFraction == null ? 1 : endFraction;
	  checkFraction(startFraction, endFraction);
	  var resolvedPromise = 0;

	  var registerMonitor = function registerMonitor(promise) {
	    promise.then(function (value) {
	      var fraction = startFraction + ++resolvedPromise / promises.length * (endFraction - startFraction); // pass fraction as parameter to callback function.

	      onProgress(fraction);
	      return value;
	    });
	    return promise;
	  };

	  function checkPromises(promises) {
	    assert(promises != null && Array.isArray(promises) && promises.length > 0, function () {
	      return 'promises must be a none empty array';
	    });
	  }

	  function checkFraction(startFraction, endFraction) {
	    assert(startFraction >= 0 && startFraction <= 1, function () {
	      return "Progress fraction must be in range [0, 1], but " + ("got startFraction " + startFraction);
	    });
	    assert(endFraction >= 0 && endFraction <= 1, function () {
	      return "Progress fraction must be in range [0, 1], but " + ("got endFraction " + endFraction);
	    });
	    assert(endFraction >= startFraction, function () {
	      return "startFraction must be no more than endFraction, but " + ("got startFraction " + startFraction + " and endFraction ") + ("" + endFraction);
	    });
	  }

	  return Promise.all(promises.map(registerMonitor));
	}

	/**
	 * Reads binary weights data from a number of URLs.
	 *
	 * @param fetchURLs URLs to send the HTTP requests at, using `fetch` calls.
	 * @param requestOptions RequestInit (options) for the HTTP requests.
	 * @param fetchFunc Optional overriding value for the `window.fetch` function.
	 * @param onProgress Optional, progress callback function, fired periodically
	 *   before the load is completed.
	 * @returns A `Promise` of an Array of `ArrayBuffer`. The Array has the same
	 *   length as `fetchURLs`.
	 */

	function loadWeightsAsArrayBuffer(_x, _x2) {
	  return _loadWeightsAsArrayBuffer.apply(this, arguments);
	}
	/**
	 * Reads a weights manifest JSON configuration, fetches the weights and
	 * returns them as `Tensor`s.
	 *
	 * @param manifest The weights manifest JSON.
	 * @param filePathPrefix The path prefix for filenames given in the manifest.
	 *     Defaults to the empty string.
	 * @param weightNames The names of the weights to be fetched.
	 */

	function _loadWeightsAsArrayBuffer() {
	  _loadWeightsAsArrayBuffer = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(fetchURLs, loadOptions) {
	    var fetchFunc, requests, fetchStartFraction, fetchEndFraction, responses, bufferPromises, bufferStartFraction, bufferEndFraction, buffers;
	    return regeneratorRuntime.wrap(function _callee2$(_context2) {
	      while (1) {
	        switch (_context2.prev = _context2.next) {
	          case 0:
	            if (loadOptions == null) {
	              loadOptions = {};
	            }

	            fetchFunc = loadOptions.fetchFunc == null ? env().platform.fetch : loadOptions.fetchFunc; // Create the requests for all of the weights in parallel.

	            requests = fetchURLs.map(function (fetchURL) {
	              return fetchFunc(fetchURL, loadOptions.requestInit, {
	                isBinary: true
	              });
	            });
	            fetchStartFraction = 0;
	            fetchEndFraction = 0.5;

	            if (!(loadOptions.onProgress == null)) {
	              _context2.next = 11;
	              break;
	            }

	            _context2.next = 8;
	            return Promise.all(requests);

	          case 8:
	            _context2.t0 = _context2.sent;
	            _context2.next = 14;
	            break;

	          case 11:
	            _context2.next = 13;
	            return monitorPromisesProgress(requests, loadOptions.onProgress, fetchStartFraction, fetchEndFraction);

	          case 13:
	            _context2.t0 = _context2.sent;

	          case 14:
	            responses = _context2.t0;
	            bufferPromises = responses.map(function (response) {
	              return response.arrayBuffer();
	            });
	            bufferStartFraction = 0.5;
	            bufferEndFraction = 1;

	            if (!(loadOptions.onProgress == null)) {
	              _context2.next = 24;
	              break;
	            }

	            _context2.next = 21;
	            return Promise.all(bufferPromises);

	          case 21:
	            _context2.t1 = _context2.sent;
	            _context2.next = 27;
	            break;

	          case 24:
	            _context2.next = 26;
	            return monitorPromisesProgress(bufferPromises, loadOptions.onProgress, bufferStartFraction, bufferEndFraction);

	          case 26:
	            _context2.t1 = _context2.sent;

	          case 27:
	            buffers = _context2.t1;
	            return _context2.abrupt("return", buffers);

	          case 29:
	          case "end":
	            return _context2.stop();
	        }
	      }
	    }, _callee2);
	  }));
	  return _loadWeightsAsArrayBuffer.apply(this, arguments);
	}

	function loadWeights(_x3, _x4, _x5, _x6) {
	  return _loadWeights.apply(this, arguments);
	}
	/**
	 * Creates a function, which reads a weights manifest JSON configuration,
	 * fetches the weight files using the specified function and returns them as
	 * `Tensor`s.
	 *
	 * ```js
	 * // example for creating a nodejs weight loader, which reads the weight files
	 * // from disk using fs.readFileSync
	 *
	 * import * as fs from 'fs'
	 *
	 * const fetchWeightsFromDisk = (filePaths: string[]) =>
	 *   filePaths.map(filePath => fs.readFileSync(filePath).buffer)
	 *
	 * const loadWeights = tf.io.weightsLoaderFactory(fetchWeightsFromDisk)
	 *
	 * const manifest = JSON.parse(
	 *   fs.readFileSync('./my_model-weights_manifest').toString()
	 * )
	 * const weightMap = await loadWeights(manifest, './')
	 * ```
	 * @param fetchWeightsFunction The function used for fetching the weight files.
	 * @returns Weight loading function.
	 */

	function _loadWeights() {
	  _loadWeights = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(manifest, filePathPrefix, weightNames, requestInit) {
	    var fetchWeights, loadWeights;
	    return regeneratorRuntime.wrap(function _callee3$(_context3) {
	      while (1) {
	        switch (_context3.prev = _context3.next) {
	          case 0:
	            if (filePathPrefix === void 0) {
	              filePathPrefix = '';
	            }

	            // TODO(nsthorat): Groups are currently fetched atomically. If you need a
	            // single weight from a group, the whole group will be fetched. At a future
	            // date, we should support fetching only the individual shards within a
	            // group that are needed to reconstruct the requested weight.
	            // TODO(cais): Use `decodeWeights` for implementation.
	            fetchWeights = function fetchWeights(fetchUrls) {
	              return loadWeightsAsArrayBuffer(fetchUrls, {
	                requestInit: requestInit
	              });
	            };

	            loadWeights = weightsLoaderFactory(fetchWeights);
	            return _context3.abrupt("return", loadWeights(manifest, filePathPrefix, weightNames));

	          case 4:
	          case "end":
	            return _context3.stop();
	        }
	      }
	    }, _callee3);
	  }));
	  return _loadWeights.apply(this, arguments);
	}

	function weightsLoaderFactory(fetchWeightsFunction) {
	  return /*#__PURE__*/function () {
	    var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(manifest, filePathPrefix, weightNames) {
	      var groupIndicesToFetchMap, groupWeightsToFetch, weightsFound, allManifestWeightNames, weightsNotFound, groupIndicesToFetch, fetchUrls, buffers, weightsTensorMap, bufferIndexOffset;
	      return regeneratorRuntime.wrap(function _callee$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              if (filePathPrefix === void 0) {
	                filePathPrefix = '';
	              }

	              // Collect all the groups, weights, and their relative offsets to be
	              // fetched.
	              groupIndicesToFetchMap = manifest.map(function () {
	                return false;
	              });
	              groupWeightsToFetch = {};
	              weightsFound = weightNames != null ? weightNames.map(function () {
	                return false;
	              }) : [];
	              allManifestWeightNames = [];
	              manifest.forEach(function (manifestGroupConfig, groupIndex) {
	                var groupOffset = 0;
	                manifestGroupConfig.weights.forEach(function (weightsEntry) {
	                  var rawDtype = 'quantization' in weightsEntry ? weightsEntry.quantization.dtype : weightsEntry.dtype;
	                  var weightsBytes = DTYPE_VALUE_SIZE_MAP[rawDtype] * sizeFromShape(weightsEntry.shape);

	                  var enqueueWeightsForFetchingFn = function enqueueWeightsForFetchingFn() {
	                    groupIndicesToFetchMap[groupIndex] = true;

	                    if (groupWeightsToFetch[groupIndex] == null) {
	                      groupWeightsToFetch[groupIndex] = [];
	                    }

	                    groupWeightsToFetch[groupIndex].push({
	                      manifestEntry: weightsEntry,
	                      groupOffset: groupOffset,
	                      sizeBytes: weightsBytes
	                    });
	                  };

	                  if (weightNames != null) {
	                    weightNames.forEach(function (weightName, weightIndex) {
	                      if (weightName === weightsEntry.name) {
	                        enqueueWeightsForFetchingFn();
	                        weightsFound[weightIndex] = true;
	                      }
	                    });
	                  } else {
	                    enqueueWeightsForFetchingFn();
	                  }

	                  allManifestWeightNames.push(weightsEntry.name);
	                  groupOffset += weightsBytes;
	                });
	              });

	              if (weightsFound.every(function (found) {
	                return found;
	              })) {
	                _context.next = 9;
	                break;
	              }

	              weightsNotFound = weightNames.filter(function (_, i) {
	                return !weightsFound[i];
	              });
	              throw new Error("Could not find weights in manifest with names: " + (weightsNotFound.join(', ') + ". \n") + "Manifest JSON has weights with names: " + (allManifestWeightNames.join(', ') + "."));

	            case 9:
	              // Convert the one-hot boolean groupId => shouldFetch map to a list of group
	              // IDs.
	              groupIndicesToFetch = groupIndicesToFetchMap.reduce(function (accumulator, shouldFetch, i) {
	                if (shouldFetch) {
	                  accumulator.push(i);
	                }

	                return accumulator;
	              }, []);
	              fetchUrls = [];
	              groupIndicesToFetch.forEach(function (i) {
	                manifest[i].paths.forEach(function (filepath) {
	                  var fetchUrl = filePathPrefix + (!filePathPrefix.endsWith('/') ? '/' : '') + filepath;
	                  fetchUrls.push(fetchUrl);
	                });
	              });
	              _context.next = 14;
	              return fetchWeightsFunction(fetchUrls);

	            case 14:
	              buffers = _context.sent;
	              weightsTensorMap = {};
	              bufferIndexOffset = 0;
	              groupIndicesToFetch.forEach(function (i) {
	                var numBuffers = manifest[i].paths.length;
	                var groupBytes = 0;

	                for (var _i = 0; _i < numBuffers; _i++) {
	                  groupBytes += buffers[bufferIndexOffset + _i].byteLength;
	                } // Create a buffer for the whole group.


	                var groupBuffer = new ArrayBuffer(groupBytes);
	                var groupByteBuffer = new Uint8Array(groupBuffer);
	                var groupBufferOffset = 0;

	                for (var _i2 = 0; _i2 < numBuffers; _i2++) {
	                  var buffer = new Uint8Array(buffers[bufferIndexOffset + _i2]);
	                  groupByteBuffer.set(buffer, groupBufferOffset);
	                  groupBufferOffset += buffer.byteLength;
	                }

	                var weightsEntries = groupWeightsToFetch[i];
	                weightsEntries.forEach(function (weightsEntry) {
	                  var byteBuffer = groupBuffer.slice(weightsEntry.groupOffset, weightsEntry.groupOffset + weightsEntry.sizeBytes);
	                  var nameToTensorMap = decodeWeights(byteBuffer, [weightsEntry.manifestEntry]);

	                  for (var name in nameToTensorMap) {
	                    weightsTensorMap[name] = nameToTensorMap[name];
	                  }
	                });
	                bufferIndexOffset += numBuffers;
	              });
	              return _context.abrupt("return", weightsTensorMap);

	            case 19:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, _callee);
	    }));

	    return function (_x7, _x8, _x9) {
	      return _ref.apply(this, arguments);
	    };
	  }();
	}

	var OCTET_STREAM_MIME_TYPE = 'application/octet-stream';
	var JSON_TYPE = 'application/json';
	var HTTPRequest = /*#__PURE__*/function () {
	  function HTTPRequest(path, loadOptions) {
	    this.DEFAULT_METHOD = 'POST';

	    if (loadOptions == null) {
	      loadOptions = {};
	    }

	    this.weightPathPrefix = loadOptions.weightPathPrefix;
	    this.onProgress = loadOptions.onProgress;
	    this.weightUrlConverter = loadOptions.weightUrlConverter;

	    if (loadOptions.fetchFunc != null) {
	      assert(typeof loadOptions.fetchFunc === 'function', function () {
	        return 'Must pass a function that matches the signature of ' + '`fetch` (see ' + 'https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)';
	      });
	      this.fetch = loadOptions.fetchFunc;
	    } else {
	      this.fetch = env().platform.fetch;
	    }

	    assert(path != null && path.length > 0, function () {
	      return 'URL path for http must not be null, undefined or ' + 'empty.';
	    });

	    if (Array.isArray(path)) {
	      assert(path.length === 2, function () {
	        return 'URL paths for http must have a length of 2, ' + ("(actual length is " + path.length + ").");
	      });
	    }

	    this.path = path;

	    if (loadOptions.requestInit != null && loadOptions.requestInit.body != null) {
	      throw new Error('requestInit is expected to have no pre-existing body, but has one.');
	    }

	    this.requestInit = loadOptions.requestInit || {};
	  }

	  var _proto = HTTPRequest.prototype;

	  _proto.save = /*#__PURE__*/function () {
	    var _save = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(modelArtifacts) {
	      var init, weightsManifest, modelTopologyAndWeightManifest, response;
	      return regeneratorRuntime.wrap(function _callee$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              if (!(modelArtifacts.modelTopology instanceof ArrayBuffer)) {
	                _context.next = 2;
	                break;
	              }

	              throw new Error('BrowserHTTPRequest.save() does not support saving model topology ' + 'in binary formats yet.');

	            case 2:
	              init = Object.assign({
	                method: this.DEFAULT_METHOD
	              }, this.requestInit);
	              init.body = new FormData();
	              weightsManifest = [{
	                paths: ['./model.weights.bin'],
	                weights: modelArtifacts.weightSpecs
	              }];
	              modelTopologyAndWeightManifest = {
	                modelTopology: modelArtifacts.modelTopology,
	                format: modelArtifacts.format,
	                generatedBy: modelArtifacts.generatedBy,
	                convertedBy: modelArtifacts.convertedBy,
	                weightsManifest: weightsManifest
	              };

	              if (modelArtifacts.signature != null) {
	                modelTopologyAndWeightManifest.signature = modelArtifacts.signature;
	              }

	              if (modelArtifacts.userDefinedMetadata != null) {
	                modelTopologyAndWeightManifest.userDefinedMetadata = modelArtifacts.userDefinedMetadata;
	              }

	              if (modelArtifacts.modelInitializer != null) {
	                modelTopologyAndWeightManifest.modelInitializer = modelArtifacts.modelInitializer;
	              }

	              init.body.append('model.json', new Blob([JSON.stringify(modelTopologyAndWeightManifest)], {
	                type: JSON_TYPE
	              }), 'model.json');

	              if (modelArtifacts.weightData != null) {
	                init.body.append('model.weights.bin', new Blob([modelArtifacts.weightData], {
	                  type: OCTET_STREAM_MIME_TYPE
	                }), 'model.weights.bin');
	              }

	              _context.next = 13;
	              return this.fetch(this.path, init);

	            case 13:
	              response = _context.sent;

	              if (!response.ok) {
	                _context.next = 18;
	                break;
	              }

	              return _context.abrupt("return", {
	                modelArtifactsInfo: getModelArtifactsInfoForJSON(modelArtifacts),
	                responses: [response]
	              });

	            case 18:
	              throw new Error("BrowserHTTPRequest.save() failed due to HTTP response status " + (response.status + "."));

	            case 19:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, _callee, this);
	    }));

	    function save(_x) {
	      return _save.apply(this, arguments);
	    }

	    return save;
	  }()
	  /**
	   * Load model artifacts via HTTP request(s).
	   *
	   * See the documentation to `tf.io.http` for details on the saved
	   * artifacts.
	   *
	   * @returns The loaded model artifacts (if loading succeeds).
	   */
	  ;

	  _proto.load =
	  /*#__PURE__*/
	  function () {
	    var _load = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
	      var modelConfigRequest, modelConfig, message, modelTopology, weightsManifest, generatedBy, convertedBy, format, signature, userDefinedMetadata, weightSpecs, weightData, results, artifacts, initializer;
	      return regeneratorRuntime.wrap(function _callee2$(_context2) {
	        while (1) {
	          switch (_context2.prev = _context2.next) {
	            case 0:
	              _context2.next = 2;
	              return this.fetch(this.path, this.requestInit);

	            case 2:
	              modelConfigRequest = _context2.sent;

	              if (modelConfigRequest.ok) {
	                _context2.next = 5;
	                break;
	              }

	              throw new Error("Request to " + this.path + " failed with status code " + (modelConfigRequest.status + ". Please verify this URL points to ") + "the model JSON of the model to load.");

	            case 5:
	              _context2.prev = 5;
	              _context2.next = 8;
	              return modelConfigRequest.json();

	            case 8:
	              modelConfig = _context2.sent;
	              _context2.next = 16;
	              break;

	            case 11:
	              _context2.prev = 11;
	              _context2.t0 = _context2["catch"](5);
	              message = "Failed to parse model JSON of response from " + this.path + "."; // TODO(nsthorat): Remove this after some time when we're comfortable that
	              // .pb files are mostly gone.

	              if (this.path.endsWith('.pb')) {
	                message += ' Your path contains a .pb file extension. ' + 'Support for .pb models have been removed in TensorFlow.js 1.0 ' + 'in favor of .json models. You can re-convert your Python ' + 'TensorFlow model using the TensorFlow.js 1.0 conversion scripts ' + 'or you can convert your.pb models with the \'pb2json\'' + 'NPM script in the tensorflow/tfjs-converter repository.';
	              } else {
	                message += ' Please make sure the server is serving valid ' + 'JSON for this request.';
	              }

	              throw new Error(message);

	            case 16:
	              modelTopology = modelConfig.modelTopology;
	              weightsManifest = modelConfig.weightsManifest;
	              generatedBy = modelConfig.generatedBy;
	              convertedBy = modelConfig.convertedBy;
	              format = modelConfig.format;
	              signature = modelConfig.signature;
	              userDefinedMetadata = modelConfig.userDefinedMetadata; // We do not allow both modelTopology and weightsManifest to be missing.

	              if (!(modelTopology == null && weightsManifest == null)) {
	                _context2.next = 25;
	                break;
	              }

	              throw new Error("The JSON from HTTP path " + this.path + " contains neither model " + "topology or manifest for weights.");

	            case 25:
	              if (!(weightsManifest != null)) {
	                _context2.next = 31;
	                break;
	              }

	              _context2.next = 28;
	              return this.loadWeights(weightsManifest);

	            case 28:
	              results = _context2.sent;
	              weightSpecs = results[0];
	              weightData = results[1];

	            case 31:
	              artifacts = {
	                modelTopology: modelTopology,
	                weightSpecs: weightSpecs,
	                weightData: weightData,
	                generatedBy: generatedBy,
	                convertedBy: convertedBy,
	                format: format
	              };

	              if (signature != null) {
	                artifacts.signature = signature;
	              }

	              if (userDefinedMetadata != null) {
	                artifacts.userDefinedMetadata = userDefinedMetadata;
	              }

	              initializer = modelConfig.modelInitializer;

	              if (initializer) {
	                artifacts.modelInitializer = initializer;
	              }

	              return _context2.abrupt("return", artifacts);

	            case 37:
	            case "end":
	              return _context2.stop();
	          }
	        }
	      }, _callee2, this, [[5, 11]]);
	    }));

	    function load() {
	      return _load.apply(this, arguments);
	    }

	    return load;
	  }();

	  _proto.loadWeights = /*#__PURE__*/function () {
	    var _loadWeights = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(weightsManifest) {
	      var weightPath, _parseUrl, prefix, suffix, pathPrefix, weightSpecs, _iterator, _step, entry, fetchURLs, urlPromises, _iterator2, _step2, weightsGroup, _iterator3, _step3, path, buffers;

	      return regeneratorRuntime.wrap(function _callee3$(_context3) {
	        while (1) {
	          switch (_context3.prev = _context3.next) {
	            case 0:
	              weightPath = Array.isArray(this.path) ? this.path[1] : this.path;
	              _parseUrl = parseUrl(weightPath), prefix = _parseUrl[0], suffix = _parseUrl[1];
	              pathPrefix = this.weightPathPrefix || prefix;
	              weightSpecs = [];

	              for (_iterator = _createForOfIteratorHelperLoose(weightsManifest); !(_step = _iterator()).done;) {
	                entry = _step.value;
	                weightSpecs.push.apply(weightSpecs, entry.weights);
	              }

	              fetchURLs = [];
	              urlPromises = [];

	              for (_iterator2 = _createForOfIteratorHelperLoose(weightsManifest); !(_step2 = _iterator2()).done;) {
	                weightsGroup = _step2.value;

	                for (_iterator3 = _createForOfIteratorHelperLoose(weightsGroup.paths); !(_step3 = _iterator3()).done;) {
	                  path = _step3.value;

	                  if (this.weightUrlConverter != null) {
	                    urlPromises.push(this.weightUrlConverter(path));
	                  } else {
	                    fetchURLs.push(pathPrefix + path + suffix);
	                  }
	                }
	              }

	              if (!this.weightUrlConverter) {
	                _context3.next = 15;
	                break;
	              }

	              _context3.t0 = fetchURLs.push;
	              _context3.t1 = fetchURLs;
	              _context3.next = 13;
	              return Promise.all(urlPromises);

	            case 13:
	              _context3.t2 = _context3.sent;

	              _context3.t0.apply.call(_context3.t0, _context3.t1, _context3.t2);

	            case 15:
	              _context3.next = 17;
	              return loadWeightsAsArrayBuffer(fetchURLs, {
	                requestInit: this.requestInit,
	                fetchFunc: this.fetch,
	                onProgress: this.onProgress
	              });

	            case 17:
	              buffers = _context3.sent;
	              return _context3.abrupt("return", [weightSpecs, concatenateArrayBuffers(buffers)]);

	            case 19:
	            case "end":
	              return _context3.stop();
	          }
	        }
	      }, _callee3, this);
	    }));

	    function loadWeights(_x2) {
	      return _loadWeights.apply(this, arguments);
	    }

	    return loadWeights;
	  }();

	  return HTTPRequest;
	}();
	HTTPRequest.URL_SCHEME_REGEX = /^https?:\/\//;
	/**
	 * Extract the prefix and suffix of the url, where the prefix is the path before
	 * the last file, and suffix is the search params after the last file.
	 * ```
	 * const url = 'http://tfhub.dev/model/1/tensorflowjs_model.pb?tfjs-format=file'
	 * [prefix, suffix] = parseUrl(url)
	 * // prefix = 'http://tfhub.dev/model/1/'
	 * // suffix = '?tfjs-format=file'
	 * ```
	 * @param url the model url to be parsed.
	 */

	function parseUrl(url) {
	  var lastSlash = url.lastIndexOf('/');
	  var lastSearchParam = url.lastIndexOf('?');
	  var prefix = url.substring(0, lastSlash);
	  var suffix = lastSearchParam > lastSlash ? url.substring(lastSearchParam) : '';
	  return [prefix + '/', suffix];
	}
	function isHTTPScheme(url) {
	  return url.match(HTTPRequest.URL_SCHEME_REGEX) != null;
	}
	var httpRouter = function httpRouter(url, loadOptions) {
	  if (typeof fetch === 'undefined' && (loadOptions == null || loadOptions.fetchFunc == null)) {
	    // `http` uses `fetch` or `node-fetch`, if one wants to use it in
	    // an environment that is not the browser or node they have to setup a
	    // global fetch polyfill.
	    return null;
	  } else {
	    var isHTTP = true;

	    if (Array.isArray(url)) {
	      isHTTP = url.every(function (urlItem) {
	        return isHTTPScheme(urlItem);
	      });
	    } else {
	      isHTTP = isHTTPScheme(url);
	    }

	    if (isHTTP) {
	      return http(url, loadOptions);
	    }
	  }

	  return null;
	};
	IORouterRegistry.registerSaveRouter(httpRouter);
	IORouterRegistry.registerLoadRouter(httpRouter);
	/**
	 * Creates an IOHandler subtype that sends model artifacts to HTTP server.
	 *
	 * An HTTP request of the `multipart/form-data` mime type will be sent to the
	 * `path` URL. The form data includes artifacts that represent the topology
	 * and/or weights of the model. In the case of Keras-style `tf.Model`, two
	 * blobs (files) exist in form-data:
	 *   - A JSON file consisting of `modelTopology` and `weightsManifest`.
	 *   - A binary weights file consisting of the concatenated weight values.
	 * These files are in the same format as the one generated by
	 * [tfjs_converter](https://js.tensorflow.org/tutorials/import-keras.html).
	 *
	 * The following code snippet exemplifies the client-side code that uses this
	 * function:
	 *
	 * ```js
	 * const model = tf.sequential();
	 * model.add(
	 *     tf.layers.dense({units: 1, inputShape: [100], activation: 'sigmoid'}));
	 *
	 * const saveResult = await model.save(tf.io.http(
	 *     'http://model-server:5000/upload', {requestInit: {method: 'PUT'}}));
	 * console.log(saveResult);
	 * ```
	 *
	 * If the default `POST` method is to be used, without any custom parameters
	 * such as headers, you can simply pass an HTTP or HTTPS URL to `model.save`:
	 *
	 * ```js
	 * const saveResult = await model.save('http://model-server:5000/upload');
	 * ```
	 *
	 * The following GitHub Gist
	 * https://gist.github.com/dsmilkov/1b6046fd6132d7408d5257b0976f7864
	 * implements a server based on [flask](https://github.com/pallets/flask) that
	 * can receive the request. Upon receiving the model artifacts via the requst,
	 * this particular server reconsistutes instances of [Keras
	 * Models](https://keras.io/models/model/) in memory.
	 *
	 *
	 * @param path A URL path to the model.
	 *   Can be an absolute HTTP path (e.g.,
	 *   'http://localhost:8000/model-upload)') or a relative path (e.g.,
	 *   './model-upload').
	 * @param requestInit Request configurations to be used when sending
	 *    HTTP request to server using `fetch`. It can contain fields such as
	 *    `method`, `credentials`, `headers`, `mode`, etc. See
	 *    https://developer.mozilla.org/en-US/docs/Web/API/Request/Request
	 *    for more information. `requestInit` must not have a body, because the
	 * body will be set by TensorFlow.js. File blobs representing the model
	 * topology (filename: 'model.json') and the weights of the model (filename:
	 * 'model.weights.bin') will be appended to the body. If `requestInit` has a
	 * `body`, an Error will be thrown.
	 * @param loadOptions Optional configuration for the loading. It includes the
	 *   following fields:
	 *   - weightPathPrefix Optional, this specifies the path prefix for weight
	 *     files, by default this is calculated from the path param.
	 *   - fetchFunc Optional, custom `fetch` function. E.g., in Node.js,
	 *     the `fetch` from node-fetch can be used here.
	 *   - onProgress Optional, progress callback function, fired periodically
	 *     before the load is completed.
	 * @returns An instance of `IOHandler`.
	 *
	 * @doc {
	 *   heading: 'Models',
	 *   subheading: 'Loading',
	 *   namespace: 'io',
	 *   ignoreCI: true
	 * }
	 */

	function http(path, loadOptions) {
	  return new HTTPRequest(path, loadOptions);
	}
	/**
	 * Deprecated. Use `tf.io.http`.
	 * @param path
	 * @param loadOptions
	 */

	function browserHTTPRequest(path, loadOptions) {
	  return http(path, loadOptions);
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var PassthroughLoader = /*#__PURE__*/function () {
	  function PassthroughLoader(modelArtifacts) {
	    this.modelArtifacts = modelArtifacts;
	  }

	  var _proto = PassthroughLoader.prototype;

	  _proto.load = /*#__PURE__*/function () {
	    var _load = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
	      return regeneratorRuntime.wrap(function _callee$(_context) {
	        while (1) {
	          switch (_context.prev = _context.next) {
	            case 0:
	              return _context.abrupt("return", this.modelArtifacts);

	            case 1:
	            case "end":
	              return _context.stop();
	          }
	        }
	      }, _callee, this);
	    }));

	    function load() {
	      return _load.apply(this, arguments);
	    }

	    return load;
	  }();

	  return PassthroughLoader;
	}();

	var PassthroughSaver = /*#__PURE__*/function () {
	  function PassthroughSaver(saveHandler) {
	    this.saveHandler = saveHandler;
	  }

	  var _proto2 = PassthroughSaver.prototype;

	  _proto2.save = /*#__PURE__*/function () {
	    var _save = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(modelArtifacts) {
	      return regeneratorRuntime.wrap(function _callee2$(_context2) {
	        while (1) {
	          switch (_context2.prev = _context2.next) {
	            case 0:
	              return _context2.abrupt("return", this.saveHandler(modelArtifacts));

	            case 1:
	            case "end":
	              return _context2.stop();
	          }
	        }
	      }, _callee2, this);
	    }));

	    function save(_x) {
	      return _save.apply(this, arguments);
	    }

	    return save;
	  }();

	  return PassthroughSaver;
	}();
	/**
	 * Creates an IOHandler that loads model artifacts from memory.
	 *
	 * When used in conjunction with `tf.loadLayersModel`, an instance of
	 * `tf.LayersModel` (Keras-style) can be constructed from the loaded artifacts.
	 *
	 * ```js
	 * const model = await tf.loadLayersModel(tf.io.fromMemory(
	 *     modelTopology, weightSpecs, weightData));
	 * ```
	 *
	 * @param modelArtifacts a object containing model topology (i.e., parsed from
	 *   the JSON format).
	 * @param weightSpecs An array of `WeightsManifestEntry` objects describing the
	 *   names, shapes, types, and quantization of the weight data.
	 * @param weightData A single `ArrayBuffer` containing the weight data,
	 *   concatenated in the order described by the weightSpecs.
	 * @param trainingConfig Model training configuration. Optional.
	 *
	 * @returns A passthrough `IOHandler` that simply loads the provided data.
	 */


	function fromMemory(modelArtifacts, weightSpecs, weightData, trainingConfig) {
	  if (arguments.length === 1) {
	    var isModelArtifacts = modelArtifacts.modelTopology != null || modelArtifacts.weightSpecs != null;

	    if (isModelArtifacts) {
	      return new PassthroughLoader(modelArtifacts);
	    } else {
	      // Legacy support: with only modelTopology.
	      // TODO(cais): Remove this deprecated API.
	      console.warn('Please call tf.io.fromMemory() with only one argument. ' + 'The argument should be of type ModelArtifacts. ' + 'The multi-argument signature of tf.io.fromMemory() has been ' + 'deprecated and will be removed in a future release.');
	      return new PassthroughLoader({
	        modelTopology: modelArtifacts
	      });
	    }
	  } else {
	    // Legacy support.
	    // TODO(cais): Remove this deprecated API.
	    console.warn('Please call tf.io.fromMemory() with only one argument. ' + 'The argument should be of type ModelArtifacts. ' + 'The multi-argument signature of tf.io.fromMemory() has been ' + 'deprecated and will be removed in a future release.');
	    return new PassthroughLoader({
	      modelTopology: modelArtifacts,
	      weightSpecs: weightSpecs,
	      weightData: weightData,
	      trainingConfig: trainingConfig
	    });
	  }
	}
	/**
	 * Creates an IOHandler that passes saved model artifacts to a callback.
	 *
	 * ```js
	 * function handleSave(artifacts) {
	 *   // ... do something with the artifacts ...
	 *   return {modelArtifactsInfo: {...}, ...};
	 * }
	 *
	 * const saveResult = model.save(tf.io.withSaveHandler(handleSave));
	 * ```
	 *
	 * @param saveHandler A function that accepts a `ModelArtifacts` and returns a
	 *     `SaveResult`.
	 */

	function withSaveHandler(saveHandler) {
	  return new PassthroughSaver(saveHandler);
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */

	var io = {
		__proto__: null,
		browserFiles: browserFiles,
		browserHTTPRequest: browserHTTPRequest,
		concatenateArrayBuffers: concatenateArrayBuffers,
		decodeWeights: decodeWeights,
		encodeWeights: encodeWeights,
		fromMemory: fromMemory,
		getLoadHandlers: getLoadHandlers,
		getModelArtifactsInfoForJSON: getModelArtifactsInfoForJSON,
		getSaveHandlers: getSaveHandlers,
		http: http,
		isHTTPScheme: isHTTPScheme,
		loadWeights: loadWeights,
		registerLoadRouter: registerLoadRouter,
		registerSaveRouter: registerSaveRouter,
		weightsLoaderFactory: weightsLoaderFactory,
		withSaveHandler: withSaveHandler,
		copyModel: copyModel,
		listModels: listModels,
		moveModel: moveModel,
		removeModel: removeModel
	};

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the dot product of two matrices, A * B. These must be matrices.
	 *
	 * ```js
	 * const a = tf.tensor2d([1, 2], [1, 2]);
	 * const b = tf.tensor2d([1, 2, 3, 4], [2, 2]);
	 *
	 * a.matMul(b).print();  // or tf.matMul(a, b)
	 * ```
	 * @param a First matrix in dot product operation.
	 * @param b Second matrix in dot product operation.
	 * @param transposeA If true, `a` is transposed before multiplication.
	 * @param transposeB If true, `b` is transposed before multiplication.
	 *
	 * @doc {heading: 'Operations', subheading: 'Matrices'}
	 */

	function matMul_(a, b, transposeA, transposeB) {
	  if (transposeA === void 0) {
	    transposeA = false;
	  }

	  if (transposeB === void 0) {
	    transposeB = false;
	  }

	  var $a = convertToTensor(a, 'a', 'matMul');
	  var $b = convertToTensor(b, 'b', 'matMul');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  var attrs = {
	    transposeA: transposeA,
	    transposeB: transposeB
	  };
	  return ENGINE.runKernel(BatchMatMul, inputs, attrs);
	}

	var matMul = op({
	  matMul_: matMul_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Creates a one-hot `tf.Tensor`. The locations represented by `indices` take
	 * value `onValue` (defaults to 1), while all other locations take value
	 * `offValue` (defaults to 0). If `indices` is rank `R`, the output has rank
	 * `R+1` with the last axis of size `depth`.
	 *
	 * ```js
	 * tf.oneHot(tf.tensor1d([0, 1], 'int32'), 3).print();
	 * ```
	 *
	 * @param indices `tf.Tensor` of indices with dtype `int32`.
	 * @param depth The depth of the one hot dimension.
	 * @param onValue A number used to fill in the output when the index matches
	 * the location.
	 * @param offValue A number used to fill in the output when the index does
	 *     not match the location.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */

	function oneHot_(indices, depth, onValue, offValue) {
	  if (onValue === void 0) {
	    onValue = 1;
	  }

	  if (offValue === void 0) {
	    offValue = 0;
	  }

	  if (depth < 2) {
	    throw new Error("Error in oneHot: depth must be >=2, but it is " + depth);
	  }

	  var $indices = convertToTensor(indices, 'indices', 'oneHot', 'int32');
	  var inputs = {
	    indices: $indices
	  };
	  var attrs = {
	    depth: depth,
	    onValue: onValue,
	    offValue: offValue
	  };
	  return ENGINE.runKernel(OneHot, inputs, attrs);
	}

	var oneHot = op({
	  oneHot_: oneHot_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Transposes the `tf.Tensor`. Permutes the dimensions according to `perm`.
	 *
	 * The returned `tf.Tensor`'s dimension `i` will correspond to the input
	 * dimension `perm[i]`. If `perm` is not given, it is set to `[n-1...0]`,
	 * where `n` is the rank of the input `tf.Tensor`. Hence by default, this
	 * operation performs a regular matrix transpose on 2-D input `tf.Tensor`s.
	 *
	 * ```js
	 * const a = tf.tensor2d([1, 2, 3, 4, 5, 6], [2, 3]);
	 *
	 * a.transpose().print();  // or tf.transpose(a)
	 * ```
	 *
	 * @param x The tensor to transpose.
	 * @param perm The permutation of the dimensions of a.
	 *
	 * @doc {heading: 'Operations', subheading: 'Matrices'}
	 */

	function transpose_(x, perm) {
	  var $x = convertToTensor(x, 'x', 'transpose');

	  if (perm == null) {
	    perm = $x.shape.map(function (s, i) {
	      return i;
	    }).reverse();
	  }

	  assert($x.rank === perm.length, function () {
	    return "Error in transpose: rank of input " + $x.rank + " " + ("must match length of perm " + perm + ".");
	  });
	  perm.forEach(function (axis) {
	    assert(axis >= 0 && axis < $x.rank, function () {
	      return "All entries in 'perm' must be between 0 and " + ($x.rank - 1) + (" but got " + perm);
	    });
	  });

	  if ($x.rank <= 1) {
	    return $x.clone();
	  }

	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    perm: perm
	  };
	  return ENGINE.runKernel(Transpose, inputs, attrs);
	}

	var transpose = op({
	  transpose_: transpose_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the confusion matrix from true labels and predicted labels.
	 *
	 * ```js
	 * const labels = tf.tensor1d([0, 1, 2, 1, 0], 'int32');
	 * const predictions = tf.tensor1d([0, 2, 2, 1, 0], 'int32');
	 * const numClasses = 3;
	 * const out = tf.math.confusionMatrix(labels, predictions, numClasses);
	 * out.print();
	 * // Expected output matrix:
	 * // [[2, 0, 0],
	 * //  [0, 1, 1],
	 * //  [0, 0, 1]]
	 * ```
	 *
	 * @param labels The target labels, assumed to be 0-based integers
	 *   for the classes. The shape is `[numExamples]`, where
	 *   `numExamples` is the number of examples included.
	 * @param predictions The predicted classes, assumed to be
	 *   0-based integers for the classes. Must have the same shape as `labels`.
	 * @param numClasses Number of all classes, as an integer.
	 *   Its value must be larger than the largest element in `labels` and
	 *   `predictions`.
	 * @returns The confusion matrix as a int32-type 2D tensor. The value at
	 *   row `r` and column `c` is the number of times examples of actual class
	 *   `r` were predicted as class `c`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Evaluation'}
	 */

	function confusionMatrix_(labels, predictions, numClasses) {
	  var $labels = convertToTensor(labels, 'labels', 'confusionMatrix');
	  var $predictions = convertToTensor(predictions, 'predictions', 'confusionMatrix');
	  assert(numClasses == null || numClasses > 0 && Number.isInteger(numClasses), function () {
	    return "If provided, numClasses must be a positive integer, " + ("but got " + numClasses);
	  });
	  assert($labels.rank === 1, function () {
	    return "Expected the rank of labels to be 1, but got " + $labels.rank;
	  });
	  assert($predictions.rank === 1, function () {
	    return "Expected the rank of predictions to be 1, " + ("but got " + $predictions.rank);
	  });
	  assert($labels.shape[0] === $predictions.shape[0], function () {
	    return "Mismatch in the number of examples: " + ($labels.shape[0] + " vs. " + $predictions.shape[0] + ". ") + "Labels and predictions should have the same number of elements.";
	  });
	  assert(numClasses > 0 && Number.isInteger(numClasses), function () {
	    return "numClasses is required to be a positive integer, but got " + ("" + numClasses);
	  }); // TODO(cais): In the future, if oneHot supports tensors inputs for
	  //   `numClasses`, `confusionMatrix` can make `numClasses` optional.

	  var oneHotLabels = oneHot(cast($labels, 'int32'), numClasses);
	  var oneHotPredictions = oneHot(cast($predictions, 'int32'), numClasses);
	  var oneHotLabelsT = transpose(oneHotLabels);
	  var product = matMul(oneHotLabelsT, oneHotPredictions);
	  return cast(product, 'int32');
	}
	var confusionMatrix = op({
	  confusionMatrix_: confusionMatrix_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */

	var math = {
		__proto__: null,
		confusionMatrix: confusionMatrix
	};

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Creates rank-3 `tf.Tensor` with the provided values, shape and dtype.
	 *
	 * The same functionality can be achieved with `tf.tensor`, but in general
	 * we recommend using `tf.tensor3d` as it makes the code more readable.
	 *
	 *  ```js
	 * // Pass a nested array.
	 * tf.tensor3d([[[1], [2]], [[3], [4]]]).print();
	 * ```
	 * ```js
	 * // Pass a flat array and specify a shape.
	 * tf.tensor3d([1, 2, 3, 4], [2, 2, 1]).print();
	 * ```
	 *
	 * @param values The values of the tensor. Can be nested array of numbers,
	 *     or a flat array, or a `TypedArray`.
	 * @param shape The shape of the tensor. If not provided,  it is inferred from
	 *     `values`.
	 * @param dtype The data type.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */

	function tensor3d(values, shape, dtype) {
	  assertNonNull(values);

	  if (shape != null && shape.length !== 3) {
	    throw new Error('tensor3d() requires shape to have three numbers');
	  }

	  var inferredShape = inferShape(values, dtype);

	  if (inferredShape.length !== 3 && inferredShape.length !== 1) {
	    throw new Error('tensor3d() requires values to be number[][][] or flat/TypedArray');
	  }

	  if (inferredShape.length === 1 && shape == null) {
	    throw new Error('tensor3d() requires shape to be provided when `values` ' + 'are a flat array');
	  }

	  return makeTensor(values, shape, inferredShape, dtype);
	}

	var fromPixels2DContext;
	/**
	 * Creates a `tf.Tensor` from an image.
	 *
	 * ```js
	 * const image = new ImageData(1, 1);
	 * image.data[0] = 100;
	 * image.data[1] = 150;
	 * image.data[2] = 200;
	 * image.data[3] = 255;
	 *
	 * tf.browser.fromPixels(image).print();
	 * ```
	 *
	 * @param pixels The input image to construct the tensor from. The
	 * supported image types are all 4-channel. You can also pass in an image
	 * object with following attributes:
	 * `{data: Uint8Array; width: number; height: number}`
	 * @param numChannels The number of channels of the output tensor. A
	 * numChannels value less than 4 allows you to ignore channels. Defaults to
	 * 3 (ignores alpha channel of input image).
	 *
	 * @doc {heading: 'Browser', namespace: 'browser', ignoreCI: true}
	 */

	function fromPixels_(pixels, numChannels) {
	  if (numChannels === void 0) {
	    numChannels = 3;
	  }

	  // Sanity checks.
	  if (numChannels > 4) {
	    throw new Error('Cannot construct Tensor with more than 4 channels from pixels.');
	  }

	  if (pixels == null) {
	    throw new Error('pixels passed to tf.browser.fromPixels() can not be null');
	  }

	  var isPixelData = false;
	  var isImageData = false;
	  var isVideo = false;
	  var isImage = false;
	  var isCanvasLike = false;
	  var isImageBitmap = false;

	  if (pixels.data instanceof Uint8Array) {
	    isPixelData = true;
	  } else if (typeof ImageData !== 'undefined' && pixels instanceof ImageData) {
	    isImageData = true;
	  } else if (typeof HTMLVideoElement !== 'undefined' && pixels instanceof HTMLVideoElement) {
	    isVideo = true;
	  } else if (typeof HTMLImageElement !== 'undefined' && pixels instanceof HTMLImageElement) {
	    isImage = true; // tslint:disable-next-line: no-any
	  } else if (pixels.getContext != null) {
	    isCanvasLike = true;
	  } else if (typeof ImageBitmap !== 'undefined' && pixels instanceof ImageBitmap) {
	    isImageBitmap = true;
	  } else {
	    throw new Error('pixels passed to tf.browser.fromPixels() must be either an ' + "HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData " + "in browser, or OffscreenCanvas, ImageData in webworker" + " or {data: Uint32Array, width: number, height: number}, " + ("but was " + pixels.constructor.name));
	  }

	  if (isVideo) {
	    var HAVE_CURRENT_DATA_READY_STATE = 2;

	    if (isVideo && pixels.readyState < HAVE_CURRENT_DATA_READY_STATE) {
	      throw new Error('The video element has not loaded data yet. Please wait for ' + '`loadeddata` event on the <video> element.');
	    }
	  } // If the current backend has 'FromPixels' registered, it has a more
	  // efficient way of handling pixel uploads, so we call that.


	  var kernel = getKernel(FromPixels, ENGINE.backendName);

	  if (kernel != null) {
	    var inputs = {
	      pixels: pixels
	    };
	    var attrs = {
	      numChannels: numChannels
	    };
	    return ENGINE.runKernel(FromPixels, inputs, attrs);
	  }

	  var _ref = isVideo ? [pixels.videoWidth, pixels.videoHeight] : [pixels.width, pixels.height],
	      width = _ref[0],
	      height = _ref[1];

	  var vals;

	  if (isCanvasLike) {
	    vals = // tslint:disable-next-line:no-any
	    pixels.getContext('2d').getImageData(0, 0, width, height).data;
	  } else if (isImageData || isPixelData) {
	    vals = pixels.data;
	  } else if (isImage || isVideo || isImageBitmap) {
	    if (fromPixels2DContext == null) {
	      fromPixels2DContext = document.createElement('canvas').getContext('2d');
	    }

	    fromPixels2DContext.canvas.width = width;
	    fromPixels2DContext.canvas.height = height;
	    fromPixels2DContext.drawImage(pixels, 0, 0, width, height);
	    vals = fromPixels2DContext.getImageData(0, 0, width, height).data;
	  }

	  var values;

	  if (numChannels === 4) {
	    values = new Int32Array(vals);
	  } else {
	    var numPixels = width * height;
	    values = new Int32Array(numPixels * numChannels);

	    for (var i = 0; i < numPixels; i++) {
	      for (var channel = 0; channel < numChannels; ++channel) {
	        values[i * numChannels + channel] = vals[i * 4 + channel];
	      }
	    }
	  }

	  var outShape = [height, width, numChannels];
	  return tensor3d(values, outShape, 'int32');
	}
	/**
	 * Draws a `tf.Tensor` of pixel values to a byte array or optionally a
	 * canvas.
	 *
	 * When the dtype of the input is 'float32', we assume values in the range
	 * [0-1]. Otherwise, when input is 'int32', we assume values in the range
	 * [0-255].
	 *
	 * Returns a promise that resolves when the canvas has been drawn to.
	 *
	 * @param img A rank-2 or rank-3 tensor. If rank-2, draws grayscale. If
	 *     rank-3, must have depth of 1, 3 or 4. When depth of 1, draws
	 * grayscale. When depth of 3, we draw with the first three components of
	 * the depth dimension corresponding to r, g, b and alpha = 1. When depth of
	 * 4, all four components of the depth dimension correspond to r, g, b, a.
	 * @param canvas The canvas to draw to.
	 *
	 * @doc {heading: 'Browser', namespace: 'browser'}
	 */


	function toPixels(_x, _x2) {
	  return _toPixels.apply(this, arguments);
	}

	function _toPixels() {
	  _toPixels = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(img, canvas) {
	    var $img, originalImgTensor, _$img$shape$slice, height, width, depth, data, multiplier, bytes, i, rgba, d, value, j, ctx, imageData;

	    return regeneratorRuntime.wrap(function _callee$(_context) {
	      while (1) {
	        switch (_context.prev = _context.next) {
	          case 0:
	            $img = convertToTensor(img, 'img', 'toPixels');

	            if (!(img instanceof Tensor)) {
	              // Assume int32 if user passed a native array.
	              originalImgTensor = $img;
	              $img = cast(originalImgTensor, 'int32');
	              originalImgTensor.dispose();
	            }

	            if (!($img.rank !== 2 && $img.rank !== 3)) {
	              _context.next = 4;
	              break;
	            }

	            throw new Error("toPixels only supports rank 2 or 3 tensors, got rank " + $img.rank + ".");

	          case 4:
	            _$img$shape$slice = $img.shape.slice(0, 2), height = _$img$shape$slice[0], width = _$img$shape$slice[1];
	            depth = $img.rank === 2 ? 1 : $img.shape[2];

	            if (!(depth > 4 || depth === 2)) {
	              _context.next = 8;
	              break;
	            }

	            throw new Error("toPixels only supports depth of size " + ("1, 3 or 4 but got " + depth));

	          case 8:
	            if (!($img.dtype !== 'float32' && $img.dtype !== 'int32')) {
	              _context.next = 10;
	              break;
	            }

	            throw new Error("Unsupported type for toPixels: " + $img.dtype + "." + " Please use float32 or int32 tensors.");

	          case 10:
	            _context.next = 12;
	            return $img.data();

	          case 12:
	            data = _context.sent;
	            multiplier = $img.dtype === 'float32' ? 255 : 1;
	            bytes = new Uint8ClampedArray(width * height * 4);
	            i = 0;

	          case 16:
	            if (!(i < height * width)) {
	              _context.next = 41;
	              break;
	            }

	            rgba = [0, 0, 0, 255];
	            d = 0;

	          case 19:
	            if (!(d < depth)) {
	              _context.next = 33;
	              break;
	            }

	            value = data[i * depth + d];

	            if (!($img.dtype === 'float32')) {
	              _context.next = 26;
	              break;
	            }

	            if (!(value < 0 || value > 1)) {
	              _context.next = 24;
	              break;
	            }

	            throw new Error("Tensor values for a float32 Tensor must be in the " + ("range [0 - 1] but encountered " + value + "."));

	          case 24:
	            _context.next = 29;
	            break;

	          case 26:
	            if (!($img.dtype === 'int32')) {
	              _context.next = 29;
	              break;
	            }

	            if (!(value < 0 || value > 255)) {
	              _context.next = 29;
	              break;
	            }

	            throw new Error("Tensor values for a int32 Tensor must be in the " + ("range [0 - 255] but encountered " + value + "."));

	          case 29:
	            if (depth === 1) {
	              rgba[0] = value * multiplier;
	              rgba[1] = value * multiplier;
	              rgba[2] = value * multiplier;
	            } else {
	              rgba[d] = value * multiplier;
	            }

	          case 30:
	            d++;
	            _context.next = 19;
	            break;

	          case 33:
	            j = i * 4;
	            bytes[j + 0] = Math.round(rgba[0]);
	            bytes[j + 1] = Math.round(rgba[1]);
	            bytes[j + 2] = Math.round(rgba[2]);
	            bytes[j + 3] = Math.round(rgba[3]);

	          case 38:
	            ++i;
	            _context.next = 16;
	            break;

	          case 41:
	            if (canvas != null) {
	              canvas.width = width;
	              canvas.height = height;
	              ctx = canvas.getContext('2d');
	              imageData = new ImageData(bytes, width, height);
	              ctx.putImageData(imageData, 0, 0);
	            }

	            if ($img !== img) {
	              $img.dispose();
	            }

	            return _context.abrupt("return", bytes);

	          case 44:
	          case "end":
	            return _context.stop();
	        }
	      }
	    }, _callee);
	  }));
	  return _toPixels.apply(this, arguments);
	}

	var fromPixels = op({
	  fromPixels_: fromPixels_
	});

	var browser = {
		__proto__: null,
		toPixels: toPixels,
		fromPixels: fromPixels
	};

	/**
	 * Validate gather nd inputs.
	 *
	 * @param tensor The tensor contains the source values.
	 * @param indices The tensor contains the indices to slice the source.
	 *
	 * @returns [resultShape, numUpdates, sliceSize, strides]
	 */

	function prepareAndValidate(tensor, indices) {
	  var tensorRank = tensor.shape.length;
	  var indicesRank = indices.shape.length;

	  if (tensorRank < 1) {
	    throw new Error('tf.gatherND() expects the input to be rank 1 or higher,' + (" but the rank was " + tensorRank + "."));
	  }

	  if (indicesRank < 1) {
	    throw new Error('tf.gatherND() expects the indices to be rank 1 or higher,' + (" but the rank was " + indicesRank + "."));
	  }

	  if (indices.dtype !== 'int32') {
	    throw new Error('tf.gatherND() expects the indices to be int32 type,' + (" but the dtype was " + indices.dtype + "."));
	  }

	  if (indices.shape[indicesRank - 1] > tensorRank) {
	    throw new Error('index innermost dimension length must be <= tensor rank; saw: ' + (indices.shape[indicesRank - 1] + " vs. " + tensorRank));
	  }

	  if (sizeFromShape(tensor.shape) === 0) {
	    throw new Error('Requested more than 0 entries, but input is empty.' + (" Input shape: " + tensor.shape + "."));
	  }

	  var indicesShape = indices.shape;
	  var sliceRank = indicesShape[indicesShape.length - 1]; // The result shape is
	  //   indices.shape[:-1] + params.shape[indices.shape[-1]:]

	  var nResult = 1;

	  for (var i = 0; i < indicesShape.length - 1; ++i) {
	    nResult *= indicesShape[i];
	  }

	  var inputShape = tensor.shape;
	  var resultShape = indicesShape.slice();
	  resultShape.pop();
	  var sliceSize = 1;

	  for (var _i = sliceRank; _i < tensorRank; ++_i) {
	    sliceSize *= inputShape[_i];
	    resultShape.push(inputShape[_i]);
	  }

	  var strides = [].concat(computeStrides(tensor.shape).map(function (stride) {
	    return stride / sliceSize;
	  }), [1]).slice(0, sliceRank);
	  return [resultShape, nResult, sliceSize, strides];
	}

	var gather_nd_util = {
		__proto__: null,
		prepareAndValidate: prepareAndValidate
	};

	/**
	 * Check whether updates.shape = indices.shape[:batchDim] +
	 * shape[sliceDim:]
	 *
	 * @param x The input tensor.
	 */

	function validateUpdateShape(shape, indices, updates) {
	  var sliceDim = indices.rank > 1 ? indices.shape[indices.rank - 1] : 1;
	  var batchDim = indices.rank > 1 ? indices.rank - 1 : 1;
	  var shapeError = 'Must have updates.shape = indices.shape[:batchDim] + ' + ("shape[sliceDim:], got updates.shape: " + updates.shape) + (", indices.shape: " + indices.shape + ", shape: " + shape) + (", sliceDim: " + sliceDim + ", and batchDim: " + batchDim + ".");

	  if (updates.rank < batchDim) {
	    throw new Error(shapeError + (" update.rank < " + batchDim + ". "));
	  }

	  if (shape.length < sliceDim + (updates.rank - batchDim)) {
	    throw new Error(shapeError + (" Output shape length < " + (sliceDim + (updates.rank - batchDim))));
	  }

	  if (updates.rank !== batchDim + shape.length - sliceDim) {
	    throw new Error(shapeError + (" update.rank != " + (batchDim + shape.length - sliceDim)));
	  }

	  for (var d = 0; d < batchDim; ++d) {
	    if (updates.shape[d] !== indices.shape[d]) {
	      throw new Error(shapeError + (" updates.shape[" + d + "] (" + updates.shape[d] + ") != indices.shape[" + d + "] (" + indices.shape[d] + ")."));
	    }
	  }

	  for (var _d = 0; _d < updates.rank - batchDim; ++_d) {
	    if (updates.shape[_d + batchDim] !== shape[_d + sliceDim]) {
	      throw new Error(shapeError + (" updates.shape[" + (_d + batchDim) + "] (" + updates.shape[_d + batchDim] + ") != shape[" + (_d + batchDim) + "] (" + shape[_d + batchDim] + ")"));
	    }
	  }
	}
	/**
	 * Validate scatter nd inputs.
	 *
	 * @param update The tensor contains the update values.
	 * @param indices The tensor contains the indices for the update values.
	 * @param shape The shape of the output tensor.
	 */

	function validateInput(updates, indices, shape) {
	  if (indices.rank < 1) {
	    throw new Error('tf.scatterND() expects the indices to be rank 1 or higher,' + (" but the rank was " + indices.rank + "."));
	  }

	  if (updates.rank < 1) {
	    throw new Error('tf.scatterND() expects the updates to be rank 1 or higher,' + (" but the rank was " + updates.rank + "."));
	  }

	  if (indices.dtype !== 'int32') {
	    throw new Error("The dtype of 'indices' should be int32, but got dtype: " + indices.dtype);
	  }

	  if (shape.length < 1) {
	    throw new Error("Output rank must be greater or equal to 1, but got shape: " + shape);
	  }

	  if (shape.length === 0) {
	    if (indices.size === 0) {
	      throw new Error("Indices specified for empty output. indices shape: " + indices.shape);
	    }

	    if (updates.size === 0) {
	      throw new Error("Updates specified for empty output. updates shape: " + updates.shape);
	    }
	  }

	  validateUpdateShape(shape, indices, updates);
	}
	/**
	 * Calculate the shape information for the output.
	 *
	 * @param update The tensor contains the update values.
	 * @param indices The tensor contains the indices for the update values.
	 * @param shape The shape of the output tensor.
	 *
	 * @returns ScatterShapeInfo
	 */

	function calculateShapes(updates, indices, shape) {
	  // Calculate the number of dimensions in indices
	  var indicesRank = indices.shape.length;
	  var sliceRank = indicesRank > 1 ? indices.shape[indicesRank - 1] : 1; // Calculate the number of elements that make up each slice of our updated
	  // tensor. This allows us to work with flattened tensors and copy over whole
	  // slices at a time.

	  var totalNd = shape.length;
	  var sliceSize = 1;

	  for (var i = sliceRank; i < totalNd; ++i) {
	    sliceSize *= shape[i];
	  }

	  var safeSliceDim = sliceRank < 1 ? 1 : sliceRank;
	  var numUpdates = sizeFromShape(indices.shape) / safeSliceDim;
	  var strides = [].concat(computeStrides(shape.slice(0, sliceRank)), [1]);
	  var outputSize = sizeFromShape(shape);
	  return {
	    sliceRank: sliceRank,
	    numUpdates: numUpdates,
	    sliceSize: sliceSize,
	    strides: strides,
	    outputSize: outputSize
	  };
	}

	var scatter_nd_util = {
		__proto__: null,
		validateUpdateShape: validateUpdateShape,
		validateInput: validateInput,
		calculateShapes: calculateShapes
	};

	/**
	 * @license
	 * Copyright 2017 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	function assertParamsValid(input, begin, size) {
	  var inputRank = input.shape.length;
	  assert(inputRank === begin.length, function () {
	    return "Error in slice" + inputRank + "D: Length of begin " + begin + " must " + ("match the rank of the array (" + inputRank + ").");
	  });
	  assert(inputRank === size.length, function () {
	    return "Error in slice" + inputRank + "D: Length of size " + size + " must " + ("match the rank of the array (" + inputRank + ").");
	  });

	  var _loop = function _loop(i) {
	    assert(begin[i] + size[i] <= input.shape[i], function () {
	      return "Error in slice" + inputRank + "D: begin[" + i + "] + size[" + i + "] " + ("(" + (begin[i] + size[i]) + ") would overflow input.shape[" + i + "] (" + input.shape[i] + ")");
	    });
	  };

	  for (var i = 0; i < inputRank; ++i) {
	    _loop(i);
	  }
	}
	/** Converts a binary mask to an array of axes. Used in stridedSlice(). */

	function maskToAxes(mask) {
	  var axes = [];
	  var axis = 0;

	  while (mask > 0) {
	    if (mask & 1) {
	      axes.push(axis);
	    }

	    mask /= 2;
	    axis++;
	  }

	  return axes;
	}
	/** Computes the output shape given the strided slice params. */

	function computeOutShape(begin, end, strides) {
	  var size = [];

	  for (var axis = 0; axis < begin.length; axis++) {
	    size[axis] = Math.ceil((end[axis] - begin[axis]) / strides[axis]);
	  }

	  return size;
	} // Creates full selection at the elided dimensions. If the dimension matches
	// the ellipsis mask, override the current stride value. Otherwise, insert.

	function stridesWithElidedDims(strides, ellipsisInsertionIndex, numElidedAxes, inputShape) {
	  var newStrides = [].concat(strides);

	  for (var i = newStrides.length; i < inputShape.length; i++) {
	    newStrides.push(1);
	  }

	  for (var _i = 0; _i < numElidedAxes; _i++) {
	    if (_i === 0) {
	      newStrides[ellipsisInsertionIndex] = 1;
	    } else {
	      newStrides.splice(ellipsisInsertionIndex, 0
	      /* num elements to delete */
	      , 1
	      /* element to add */
	      );
	      newStrides.pop();
	    }
	  }

	  return newStrides;
	}

	function unnormalizeAxis(ellipsisInsertionIndex, numElidedAxes, normalizedAxis) {
	  if (normalizedAxis <= ellipsisInsertionIndex) {
	    return normalizedAxis;
	  }

	  return normalizedAxis - (numElidedAxes - 1);
	}

	function getElidedAxes(numElidedAxes, ellipsisInsertionIndex) {
	  var elidedAxes = [];

	  for (var i = 0; i < numElidedAxes; i++) {
	    elidedAxes.push(ellipsisInsertionIndex + i);
	  }

	  return elidedAxes;
	} // Normalize the start, end and strides.


	function getNormalizedAxes(inputShape, ellipsisAxes, numInterpolatedAxes, begin, end, strides, beginMask, endMask, ellipsisMask) {
	  var inputRank = inputShape.length;
	  var normalizedBegin = new Array(inputRank),
	      normalizedEnd = new Array(inputRank),
	      normalizedStrides = new Array(inputRank);

	  if (ellipsisAxes.length && numInterpolatedAxes > 0) {
	    var fullIndex = ellipsisAxes[0]; // The ellipsis applies to the masked index as well as any dimensions
	    // that are interpolated.

	    var numElidedAxes = numInterpolatedAxes + 1;
	    normalizedBegin = startIndicesWithElidedDims(beginMask, fullIndex, numElidedAxes, begin, inputShape);
	    normalizedEnd = stopIndicesWithElidedDims(endMask, fullIndex, numElidedAxes, end, inputShape);
	    normalizedStrides = stridesWithElidedDims(strides, fullIndex, numElidedAxes, inputShape);
	  } else {
	    for (var axis = 0; axis < inputRank; axis++) {
	      normalizedBegin[axis] = startForAxis(beginMask, begin, strides, inputShape, axis, ellipsisMask);
	      normalizedEnd[axis] = stopForAxis(endMask, end, strides, inputShape, axis, ellipsisMask);
	      normalizedStrides[axis] = stridesForAxis(strides, axis, ellipsisMask);
	    }
	  }

	  return {
	    begin: normalizedBegin,
	    end: normalizedEnd,
	    strides: normalizedStrides
	  };
	} // Creates full selection at the elided dimensions. If the dimension matches
	// the ellipsis mask, override the current start value. Otherwise, insert.

	function startIndicesWithElidedDims(beginMask, ellipsisInsertionIndex, numElidedAxes, originalBegin, inputShape) {
	  var newIndices = [].concat(inputShape);
	  var elidedAxes = getElidedAxes(numElidedAxes, ellipsisInsertionIndex);

	  for (var axis = 0; axis < newIndices.length; axis++) {
	    if (elidedAxes.indexOf(axis) > -1) {
	      newIndices[axis] = 0;
	    } else {
	      var originalAxis = unnormalizeAxis(ellipsisInsertionIndex, numElidedAxes, axis);
	      var originalValue = originalBegin[originalAxis];

	      if (beginMask & 1 << originalAxis) {
	        originalValue = 0;
	      }

	      newIndices[axis] = originalValue;
	    }
	  }

	  return newIndices;
	} // Creates full selection at the elided dimensions. If the dimension matches
	// the ellipsis mask, override the current stop value. Otherwise, insert.

	function stopIndicesWithElidedDims(endMask, ellipsisInsertionIndex, numElidedAxes, originalEnd, inputShape) {
	  var newIndices = [].concat(inputShape);
	  var elidedAxes = getElidedAxes(numElidedAxes, ellipsisInsertionIndex);

	  for (var axis = 0; axis < newIndices.length; axis++) {
	    if (elidedAxes.indexOf(axis) > -1) {
	      newIndices[axis] = Number.MAX_SAFE_INTEGER;
	    } else {
	      var originalAxis = unnormalizeAxis(ellipsisInsertionIndex, numElidedAxes, axis);
	      var originalValue = originalEnd[originalAxis];

	      if (endMask & 1 << originalAxis) {
	        originalValue = Number.MAX_SAFE_INTEGER;
	      }

	      newIndices[axis] = originalValue;
	    }
	  }

	  for (var i = 0; i < newIndices.length; i++) {
	    // Handle negative indices
	    var axisSize = inputShape[i];

	    if (newIndices[i] < 0) {
	      newIndices[i] += axisSize;
	    }

	    newIndices[i] = clamp(0, newIndices[i], inputShape[i]);
	  }

	  return newIndices;
	}
	function stridesForAxis(strides, axis, ellipsisMask) {
	  var stride = strides[axis];

	  if (ellipsisMask & 1 << axis || stride == null) {
	    stride = 1;
	  }

	  return stride;
	}
	function startForAxis(beginMask, startIndices, strides, inputShape, axis, ellipsisMask) {
	  // Begin with the specified index
	  var start = startIndices[axis];
	  var stride = strides[axis] || 1; // Check the axis bit from right of masked axes, or the begin index is not set
	  // for the axis.

	  if (beginMask & 1 << axis || ellipsisMask & 1 << axis || start == null) {
	    if (stride > 0) {
	      // Forward iteration - use the first element. These values will get
	      // clamped below (Note: We could have set them to 0 and axis_size-1, but
	      // use lowest() and max() to maintain symmetry with StopForAxis())
	      start = Number.MIN_SAFE_INTEGER;
	    } else {
	      // Backward iteration - use the last element.
	      start = Number.MAX_SAFE_INTEGER;
	    }
	  } // Handle negative indices


	  var axisSize = inputShape[axis];

	  if (start < 0) {
	    start += axisSize;
	  } // Clamping


	  start = clamp(0, start, axisSize - 1);
	  return start;
	}
	function stopForAxis(endMask, stopIndices, strides, inputShape, axis, ellipsisMask) {
	  // Begin with the specified index
	  var stop = stopIndices[axis];
	  var stride = strides[axis] || 1; // Check the axis bit from right of masked axes, or if the stop index is not
	  // set for this axis.

	  if (endMask & 1 << axis || ellipsisMask & 1 << axis || stop == null) {
	    if (stride > 0) {
	      // Forward iteration - use the last element. These values will get
	      // clamped below
	      stop = Number.MAX_SAFE_INTEGER;
	    } else {
	      // Backward iteration - use the first element.
	      stop = Number.MIN_SAFE_INTEGER;
	    }
	  } // Handle negative indices


	  var axisSize = inputShape[axis];

	  if (stop < 0) {
	    stop += axisSize;
	  } // Clamping
	  // Because the end index points one past the last element, we need slightly
	  // different clamping ranges depending on the direction.


	  if (stride > 0) {
	    // Forward iteration
	    stop = clamp(0, stop, axisSize);
	  } else {
	    // Backward iteration
	    stop = clamp(-1, stop, axisSize - 1);
	  }

	  return stop;
	}
	/**
	 * Returns true if the slice occupies a continous set of elements in the
	 * 'flat' space.
	 */

	function isSliceContinous(shape, begin, size) {
	  // Index of the first axis that has size > 1.
	  var firstNonOneAxis = size.length;

	  for (var i = 0; i < size.length; i++) {
	    if (size[i] > 1) {
	      firstNonOneAxis = i;
	      break;
	    }
	  }

	  for (var _i2 = firstNonOneAxis + 1; _i2 < size.length; _i2++) {
	    if (begin[_i2] > 0 || size[_i2] !== shape[_i2]) {
	      return false;
	    }
	  }

	  return true;
	}
	function computeFlatOffset(begin, strides) {
	  var flatOffset = begin.length > 0 ? begin[begin.length - 1] : 1;

	  for (var i = 0; i < begin.length - 1; i++) {
	    flatOffset += begin[i] * strides[i];
	  }

	  return flatOffset;
	}
	function parseSliceParams(x, begin, size) {
	  // The following logic allows for more ergonomic calls.
	  var begin_;
	  var xRank = x.shape.length;

	  if (typeof begin === 'number') {
	    begin_ = [begin].concat(new Array(xRank - 1).fill(0));
	  } else if (begin.length < xRank) {
	    begin_ = begin.concat(new Array(xRank - begin.length).fill(0));
	  } else {
	    begin_ = begin.slice();
	  }

	  begin_.forEach(function (d) {
	    assert(d !== -1, function () {
	      return 'slice() does not support negative begin indexing.';
	    });
	  });
	  var size_;

	  if (size == null) {
	    size_ = new Array(xRank).fill(-1);
	  } else if (typeof size === 'number') {
	    size_ = [size].concat(new Array(xRank - 1).fill(-1));
	  } else if (size.length < xRank) {
	    size_ = size.concat(new Array(xRank - size.length).fill(-1));
	  } else {
	    size_ = size;
	  }

	  size_ = size_.map(function (d, i) {
	    if (d >= 0) {
	      return d;
	    } else {
	      assert(d === -1, function () {
	        return "Negative size values should be exactly -1 but got " + (d + " for the slice() size at index " + i + ".");
	      });
	      return x.shape[i] - begin_[i];
	    }
	  });
	  return [begin_, size_];
	}
	function sliceInfo(xShape, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask) {
	  // make a copy because it may be modified further down.
	  var $begin = begin.slice();
	  var $end = end.slice();
	  var $strides = strides;

	  if (strides == null) {
	    $strides = new Array($begin.length);
	  }

	  var ellipsisAxes = maskToAxes(ellipsisMask);

	  if (ellipsisAxes.length > 1) {
	    throw new Error('Multiple ellipses in slice is not allowed.');
	  }

	  if (ellipsisMask !== 0 && newAxisMask !== 0) {
	    throw new Error('Using both ellipsisMask and newAxisMask is not yet supported.');
	  }

	  if (ellipsisMask !== 0 && shrinkAxisMask !== 0) {
	    throw new Error('Using both ellipsisMask and shrinkAxisMask is not yet supported.');
	  }

	  var numInterpolatedAxes = xShape.length - $begin.length; // Expand the dims of x based on the newAxisMask.

	  var expandAxes = maskToAxes(newAxisMask);
	  var newShape = xShape.slice();
	  expandAxes.forEach(function (axis) {
	    $begin[axis] = 0;
	    $end[axis] = 1;
	    newShape.splice(axis, 0, 1);
	  });

	  var _getNormalizedAxes = getNormalizedAxes(newShape, ellipsisAxes, numInterpolatedAxes, $begin, $end, $strides, beginMask, endMask, ellipsisMask),
	      normalizedBegin = _getNormalizedAxes.begin,
	      normalizedEnd = _getNormalizedAxes.end,
	      normalizedStrides = _getNormalizedAxes.strides;

	  $begin = normalizedBegin;
	  $end = normalizedEnd;
	  $strides = normalizedStrides;
	  var shrinkAxes = maskToAxes(shrinkAxisMask); // Adjust the ends based on the shrink mask.

	  shrinkAxes.forEach(function (axis) {
	    $end[axis] = $begin[axis] + 1;
	    $strides[axis] = 1;
	  }); // Figure out the output shape.

	  var size = computeOutShape($begin, $end, $strides); // Remove the axes based on shrinkMask.

	  var outShape = size.filter(function (_, axis) {
	    return shrinkAxes.indexOf(axis) === -1;
	  });
	  var nonStrided = $strides.every(function (v) {
	    return v === 1;
	  });
	  return {
	    nonStrided: nonStrided,
	    $begin: $begin,
	    $end: $end,
	    $strides: $strides,
	    size: size,
	    newShape: newShape,
	    outShape: outShape
	  };
	}

	var slice_util = {
		__proto__: null,
		assertParamsValid: assertParamsValid,
		maskToAxes: maskToAxes,
		computeOutShape: computeOutShape,
		stridesWithElidedDims: stridesWithElidedDims,
		getNormalizedAxes: getNormalizedAxes,
		startIndicesWithElidedDims: startIndicesWithElidedDims,
		stopIndicesWithElidedDims: stopIndicesWithElidedDims,
		stridesForAxis: stridesForAxis,
		startForAxis: startForAxis,
		stopForAxis: stopForAxis,
		isSliceContinous: isSliceContinous,
		computeFlatOffset: computeFlatOffset,
		parseSliceParams: parseSliceParams,
		sliceInfo: sliceInfo
	};

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Serializable defines the serialization contract.
	 *
	 * TFJS requires serializable classes to return their className when asked
	 * to avoid issues with minification.
	 */

	var Serializable = /*#__PURE__*/function () {
	  function Serializable() {}

	  var _proto = Serializable.prototype;

	  /**
	   * Return the class name for this class to use in serialization contexts.
	   *
	   * Generally speaking this will be the same thing that constructor.name
	   * would have returned.  However, the class name needs to be robust
	   * against minification for serialization/deserialization to work properly.
	   *
	   * There's also places such as initializers.VarianceScaling, where
	   * implementation details between different languages led to different
	   * class hierarchies and a non-leaf node is used for serialization purposes.
	   */
	  _proto.getClassName = function getClassName() {
	    return this.constructor.className;
	  }
	  /**
	   * Creates an instance of T from a ConfigDict.
	   *
	   * This works for most descendants of serializable.  A few need to
	   * provide special handling.
	   * @param cls A Constructor for the class to instantiate.
	   * @param config The Configuration for the object.
	   */

	  /** @nocollapse */
	  ;

	  Serializable.fromConfig = function fromConfig(cls, config) {
	    return new cls(config);
	  };

	  return Serializable;
	}();
	/**
	 * Maps string keys to class constructors.
	 *
	 * Used during (de)serialization from the cross-language JSON format, which
	 * requires the class name in the serialization format matches the class
	 * names as used in Python, should it exist.
	 */

	var SerializationMap = /*#__PURE__*/function () {
	  function SerializationMap() {
	    this.classNameMap = {};
	  }
	  /**
	   * Returns the singleton instance of the map.
	   */


	  SerializationMap.getMap = function getMap() {
	    if (SerializationMap.instance == null) {
	      SerializationMap.instance = new SerializationMap();
	    }

	    return SerializationMap.instance;
	  }
	  /**
	   * Registers the class as serializable.
	   */
	  ;

	  SerializationMap.register = function register(cls) {
	    SerializationMap.getMap().classNameMap[cls.className] = [cls, cls.fromConfig];
	  };

	  return SerializationMap;
	}();
	/**
	 * Register a class with the serialization map of TensorFlow.js.
	 *
	 * This is often used for registering custom Layers, so they can be
	 * serialized and deserialized.
	 *
	 * Example:
	 *
	 * ```js
	 * class MyCustomLayer extends tf.layers.Layer {
	 *   static className = 'MyCustomLayer';
	 *
	 *   constructor(config) {
	 *     super(config);
	 *   }
	 * }
	 * tf.serialization.registerClass(MyCustomLayer);
	 * ```
	 *
	 * @param cls The class to be registered. It must have a public static member
	 *   called `className` defined and the value must be a non-empty string.
	 *
	 * @doc {heading: 'Models', subheading: 'Serialization', ignoreCI: true}
	 */

	function registerClass(cls) {
	  assert(cls.className != null, function () {
	    return "Class being registered does not have the static className " + "property defined.";
	  });
	  assert(typeof cls.className === 'string', function () {
	    return "className is required to be a string, but got type " + typeof cls.className;
	  });
	  assert(cls.className.length > 0, function () {
	    return "Class being registered has an empty-string as its className, " + "which is disallowed.";
	  });
	  SerializationMap.register(cls);
	}

	var serialization = {
		__proto__: null,
		Serializable: Serializable,
		SerializationMap: SerializationMap,
		registerClass: registerClass
	};

	/**
	 * @license
	 * Copyright 2017 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	var TEST_EPSILON_FLOAT32 = 1e-3;
	var TEST_EPSILON_FLOAT16 = 1e-1;
	function expectArraysClose(actual, expected, epsilon) {
	  if (epsilon == null) {
	    epsilon = testEpsilon();
	  }

	  return expectArraysPredicate(actual, expected, function (a, b) {
	    return areClose(a, b, epsilon);
	  });
	}
	function testEpsilon() {
	  return ENGINE.backend.floatPrecision() === 32 ? TEST_EPSILON_FLOAT32 : TEST_EPSILON_FLOAT16;
	}

	function expectArraysPredicate(actual, expected, predicate) {
	  var checkClassType = true;

	  if (isTypedArray$1(actual) || isTypedArray$1(expected)) {
	    checkClassType = false;
	  }

	  if (isTypedArray$1(actual) && isTypedArray$1(expected)) {
	    checkClassType = true;
	  }

	  if (checkClassType) {
	    var aType = actual.constructor.name;
	    var bType = expected.constructor.name;

	    if (aType !== bType) {
	      throw new Error("Arrays are of different type. Actual: " + aType + ". " + ("Expected: " + bType));
	    }
	  }

	  if (Array.isArray(actual) && Array.isArray(expected)) {
	    var actualShape = inferShape(actual);
	    var expectedShape = inferShape(expected);

	    if (!arraysEqual(actualShape, expectedShape)) {
	      throw new Error("Arrays have different shapes. " + ("Actual: [" + actualShape + "]. Expected: [" + expectedShape + "]"));
	    }
	  }

	  var actualFlat = isTypedArray$1(actual) ? actual : flatten(actual);
	  var expectedFlat = isTypedArray$1(expected) ? expected : flatten(expected);

	  if (actualFlat.length !== expectedFlat.length) {
	    throw new Error("Arrays have different lengths actual: " + actualFlat.length + " vs " + ("expected: " + expectedFlat.length + ".\n") + ("Actual:   " + actualFlat + ".\n") + ("Expected: " + expectedFlat + "."));
	  }

	  for (var i = 0; i < expectedFlat.length; ++i) {
	    var a = actualFlat[i];
	    var e = expectedFlat[i];

	    if (!predicate(a, e)) {
	      throw new Error("Arrays differ: actual[" + i + "] = " + a + ", expected[" + i + "] = " + e + ".\n" + ("Actual:   " + actualFlat + ".\n") + ("Expected: " + expectedFlat + "."));
	    }
	  }
	}

	function expectPromiseToFail(fn, done) {
	  fn().then(function () {
	    return done.fail();
	  }, function () {
	    return done();
	  });
	}
	function expectArraysEqual(actual, expected) {
	  var exp = typeof expected === 'string' || typeof expected === 'number' || typeof expected === 'boolean' ? [expected] : expected;

	  if (isString(actual) || isString(actual[0]) || isString(expected) || isString(expected[0])) {
	    // tslint:disable-next-line: triple-equals
	    return expectArraysPredicate(actual, exp, function (a, b) {
	      return a == b;
	    });
	  }

	  return expectArraysPredicate(actual, expected, function (a, b) {
	    return areClose(a, b, 0);
	  });
	}
	function expectNumbersClose(a, e, epsilon) {
	  if (epsilon == null) {
	    epsilon = testEpsilon();
	  }

	  if (!areClose(a, e, epsilon)) {
	    throw new Error("Numbers differ: actual === " + a + ", expected === " + e);
	  }
	}

	function areClose(a, e, epsilon) {
	  if (!isFinite(a) && !isFinite(e)) {
	    return true;
	  }

	  if (isNaN(a) || isNaN(e) || Math.abs(a - e) > epsilon) {
	    return false;
	  }

	  return true;
	}

	function expectValuesInRange(actual, low, high) {
	  for (var i = 0; i < actual.length; i++) {
	    if (actual[i] < low || actual[i] > high) {
	      throw new Error("Value out of range:" + actual[i] + " low: " + low + ", high: " + high);
	    }
	  }
	}
	function expectArrayBuffersEqual(actual, expected) {
	  // Safari & Jasmine don't like comparing ArrayBuffers directly. Wrapping in
	  // a Float32Array solves this issue.
	  expect(new Float32Array(actual)).toEqual(new Float32Array(expected));
	}
	/** Encodes strings into utf-8 bytes. */

	function encodeStrings(a) {
	  for (var i = 0; i < a.length; i++) {
	    var val = a[i];

	    if (Array.isArray(val)) {
	      encodeStrings(val);
	    } else {
	      a[i] = encodeString(val);
	    }
	  }

	  return a;
	}

	var test_util = {
		__proto__: null,
		TEST_EPSILON_FLOAT16: TEST_EPSILON_FLOAT16,
		expectArraysClose: expectArraysClose,
		testEpsilon: testEpsilon,
		expectPromiseToFail: expectPromiseToFail,
		expectArraysEqual: expectArraysEqual,
		expectNumbersClose: expectNumbersClose,
		expectValuesInRange: expectValuesInRange,
		expectArrayBuffersEqual: expectArrayBuffersEqual,
		encodeStrings: encodeStrings
	};

	/** @license See the LICENSE file. */
	// This code is auto-generated, do not modify this file!
	var version$1 = '3.0.0';

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Enables production mode which disables correctness checks in favor of
	 * performance.
	 *
	 * @doc {heading: 'Environment'}
	 */

	function enableProdMode() {
	  env().set('PROD', true);
	}
	/**
	 * Enables debug mode which will log information about all executed kernels:
	 * the elapsed time of the kernel execution, as well as the rank, shape, and
	 * size of the output tensor.
	 *
	 * Debug mode will significantly slow down your application as it will
	 * download the result of every operation to the CPU. This should not be used in
	 * production. Debug mode does not affect the timing information of the kernel
	 * execution as we do not measure download time in the kernel execution time.
	 *
	 * See also: `tf.profile`, `tf.memory`.
	 *
	 * @doc {heading: 'Environment'}
	 */

	function enableDebugMode() {
	  env().set('DEBUG', true);
	}
	/** Globally disables deprecation warnings */

	function disableDeprecationWarnings() {
	  env().set('DEPRECATION_WARNINGS_ENABLED', false);
	  console.warn("TensorFlow.js deprecation warnings have been disabled.");
	}
	/** Warn users about deprecated functionality. */

	function deprecationWarn(msg) {
	  if (env().getBool('DEPRECATION_WARNINGS_ENABLED')) {
	    console.warn(msg + ' You can disable deprecation warnings with ' + 'tf.disableDeprecationWarnings().');
	  }
	}
	setDeprecationWarningFn(deprecationWarn);
	/**
	 * Dispose all variables kept in backend engine.
	 *
	 * @doc {heading: 'Environment'}
	 */

	function disposeVariables() {
	  ENGINE.disposeVariables();
	}
	/**
	 * It returns the global engine that keeps track of all tensors and backends.
	 *
	 * @doc {heading: 'Environment'}
	 */

	function engine() {
	  return ENGINE;
	}
	/**
	 * Returns memory info at the current time in the program. The result is an
	 * object with the following properties:
	 *
	 * - `numBytes`: Number of bytes allocated (undisposed) at this time.
	 * - `numTensors`: Number of unique tensors allocated.
	 * - `numDataBuffers`: Number of unique data buffers allocated
	 *   (undisposed) at this time, which is ≤ the number of tensors
	 *   (e.g. `a.reshape(newShape)` makes a new Tensor that shares the same
	 *   data buffer with `a`).
	 * - `unreliable`: True if the memory usage is unreliable. See `reasons` when
	 *    `unreliable` is true.
	 * - `reasons`: `string[]`, reasons why the memory is unreliable, present if
	 *    `unreliable` is true.
	 *
	 * WebGL Properties:
	 * - `numBytesInGPU`: Number of bytes allocated (undisposed) in the GPU only at
	 *     this time.
	 *
	 * @doc {heading: 'Performance', subheading: 'Memory'}
	 */

	function memory() {
	  return ENGINE.memory();
	}
	/**
	 * Executes the provided function `f()` and returns a promise that resolves
	 * with information about the function's memory use:
	 * - `newBytes`: the number of new bytes allocated
	 * - `newTensors`: the number of new tensors created
	 * - `peakBytes`: the peak number of bytes allocated
	 * - `kernels`: an array of objects for each kernel involved that reports
	 * their input and output shapes, number of bytes used, and number of new
	 * tensors created.
	 * - `kernelNames`: an array of unique strings with just the names of the
	 * kernels in the `kernels` array.
	 *
	 * ```js
	 * const profile = await tf.profile(() => {
	 *   const x = tf.tensor1d([1, 2, 3]);
	 *   let x2 = x.square();
	 *   x2.dispose();
	 *   x2 = x.square();
	 *   x2.dispose();
	 *   return x;
	 * });
	 *
	 * console.log(`newBytes: ${profile.newBytes}`);
	 * console.log(`newTensors: ${profile.newTensors}`);
	 * console.log(`byte usage over all kernels: ${profile.kernels.map(k =>
	 * k.totalBytesSnapshot)}`);
	 * ```
	 *
	 *
	 * @doc {heading: 'Performance', subheading: 'Profile'}
	 */

	function profile(f) {
	  return ENGINE.profile(f);
	}
	/**
	 * Executes the provided function `fn` and after it is executed, cleans up all
	 * intermediate tensors allocated by `fn` except those returned by `fn`.
	 * `fn` must not return a Promise (async functions not allowed). The returned
	 * result can be a complex object.
	 *
	 * Using this method helps avoid memory leaks. In general, wrap calls to
	 * operations in `tf.tidy` for automatic memory cleanup.
	 *
	 * NOTE: Variables do *not* get cleaned up when inside a tidy(). If you want to
	 * dispose variables, please use `tf.disposeVariables` or call dispose()
	 * directly on variables.
	 *
	 * ```js
	 * // y = 2 ^ 2 + 1
	 * const y = tf.tidy(() => {
	 *   // a, b, and one will be cleaned up when the tidy ends.
	 *   const one = tf.scalar(1);
	 *   const a = tf.scalar(2);
	 *   const b = a.square();
	 *
	 *   console.log('numTensors (in tidy): ' + tf.memory().numTensors);
	 *
	 *   // The value returned inside the tidy function will return
	 *   // through the tidy, in this case to the variable y.
	 *   return b.add(one);
	 * });
	 *
	 * console.log('numTensors (outside tidy): ' + tf.memory().numTensors);
	 * y.print();
	 * ```
	 *
	 * @param nameOrFn The name of the closure, or the function to execute.
	 *     If a name is provided, the 2nd argument should be the function.
	 *     If debug mode is on, the timing and the memory usage of the function
	 *     will be tracked and displayed on the console using the provided name.
	 * @param fn The function to execute.
	 *
	 * @doc {heading: 'Performance', subheading: 'Memory'}
	 */

	function tidy(nameOrFn, fn) {
	  return ENGINE.tidy(nameOrFn, fn);
	}
	/**
	 * Disposes any `tf.Tensor`s found within the provided object.
	 *
	 * @param container an object that may be a `tf.Tensor` or may directly
	 *     contain `tf.Tensor`s, such as a `Tensor[]` or `{key: Tensor, ...}`. If
	 *     the object is not a `tf.Tensor` or does not contain `Tensors`, nothing
	 *     happens. In general it is safe to pass any object here, except that
	 *     `Promise`s are not supported.
	 *
	 * @doc {heading: 'Performance', subheading: 'Memory'}
	 */

	function dispose(container) {
	  var tensors = getTensorsInContainer(container);
	  tensors.forEach(function (tensor) {
	    return tensor.dispose();
	  });
	}
	/**
	 * Keeps a `tf.Tensor` generated inside a `tf.tidy` from being disposed
	 * automatically.
	 *
	 * ```js
	 * let b;
	 * const y = tf.tidy(() => {
	 *   const one = tf.scalar(1);
	 *   const a = tf.scalar(2);
	 *
	 *   // b will not be cleaned up by the tidy. a and one will be cleaned up
	 *   // when the tidy ends.
	 *   b = tf.keep(a.square());
	 *
	 *   console.log('numTensors (in tidy): ' + tf.memory().numTensors);
	 *
	 *   // The value returned inside the tidy function will return
	 *   // through the tidy, in this case to the variable y.
	 *   return b.add(one);
	 * });
	 *
	 * console.log('numTensors (outside tidy): ' + tf.memory().numTensors);
	 * console.log('y:');
	 * y.print();
	 * console.log('b:');
	 * b.print();
	 * ```
	 *
	 * @param result The tensor to keep from being disposed.
	 *
	 * @doc {heading: 'Performance', subheading: 'Memory'}
	 */

	function keep(result) {
	  return ENGINE.keep(result);
	}
	/**
	 * Executes `f()` and returns a promise that resolves with timing
	 * information.
	 *
	 * The result is an object with the following properties:
	 *
	 * - `wallMs`: Wall execution time.
	 * - `kernelMs`: Kernel execution time, ignoring data transfer. If using the
	 * WebGL backend and the query timer extension is not available, this will
	 * return an error object.
	 * - On `WebGL` The following additional properties exist:
	 *   - `uploadWaitMs`: CPU blocking time on texture uploads.
	 *   - `downloadWaitMs`: CPU blocking time on texture downloads (readPixels).
	 *
	 * ```js
	 * const x = tf.randomNormal([20, 20]);
	 * const time = await tf.time(() => x.matMul(x));
	 *
	 * console.log(`kernelMs: ${time.kernelMs}, wallTimeMs: ${time.wallMs}`);
	 * ```
	 *
	 * @param f The function to execute and time.
	 *
	 * @doc {heading: 'Performance', subheading: 'Timing'}
	 */

	function time(f) {
	  return ENGINE.time(f);
	}
	/**
	 * Sets the backend (cpu, webgl, wasm, etc) responsible for creating tensors and
	 * executing operations on those tensors. Returns a promise that resolves
	 * to a boolean if the backend initialization was successful.
	 *
	 * Note this disposes the current backend, if any, as well as any tensors
	 * associated with it. A new backend is initialized, even if it is of the
	 * same type as the previous one.
	 *
	 * @param backendName The name of the backend. Currently supports
	 *     `'webgl'|'cpu'` in the browser, `'tensorflow'` under node.js
	 *     (requires tfjs-node), and `'wasm'` (requires tfjs-backend-wasm).
	 *
	 * @doc {heading: 'Backends'}
	 */

	function setBackend(backendName) {
	  return ENGINE.setBackend(backendName);
	}
	/**
	 * Returns a promise that resolves when the currently selected backend (or the
	 * highest priority one) has initialized. Await this promise when you are using
	 * a backend that has async initialization.
	 *
	 * @doc {heading: 'Backends'}
	 */

	function ready() {
	  return ENGINE.ready();
	}
	/**
	 * Returns the current backend name (cpu, webgl, etc). The backend is
	 * responsible for creating tensors and executing operations on those tensors.
	 *
	 * @doc {heading: 'Backends'}
	 */

	function getBackend() {
	  return ENGINE.backendName;
	}
	/**
	 * Removes a backend and the registered factory.
	 *
	 * @doc {heading: 'Backends'}
	 */

	function removeBackend(name) {
	  ENGINE.removeBackend(name);
	}
	/**
	 * Finds the backend registered under the provided name. Returns null if the
	 * name is not in the registry, or the registration hasn't finished yet.
	 */

	function findBackend(name) {
	  return ENGINE.findBackend(name);
	}
	/**
	 * Finds the backend factory registered under the provided name. Returns a
	 * function that produces a new backend when called. Returns null if the name
	 * is not in the registry.
	 */

	function findBackendFactory(name) {
	  return ENGINE.findBackendFactory(name);
	}
	/**
	 * Registers a global backend. The registration should happen when importing
	 * a module file (e.g. when importing `backend_webgl.ts`), and is used for
	 * modular builds (e.g. custom tfjs bundle with only webgl support).
	 *
	 * @param factory The backend factory function. When called, it should
	 * return a backend instance, or a promise of an instance.
	 * @param priority The priority of the backend (higher = more important).
	 *     In case multiple backends are registered, the priority is used to find
	 *     the best backend. Defaults to 1.
	 * @return False if there is already a registered backend under this name, true
	 *     if not.
	 *
	 * @doc {heading: 'Backends'}
	 */

	function registerBackend(name, factory, priority) {
	  if (priority === void 0) {
	    priority = 1;
	  }

	  return ENGINE.registerBackend(name, factory, priority);
	}
	/**
	 * Gets the current backend. If no backends have been initialized, this will
	 * attempt to initialize the best backend. Will throw an error if the highest
	 * priority backend has async initialization, in which case, you should call
	 * 'await tf.ready()' before running other code.
	 *
	 * @doc {heading: 'Backends'}
	 */

	function backend() {
	  return ENGINE.backend;
	}
	/**
	 * Sets the global platform.
	 *
	 * @param platformName The name of this platform.
	 * @param platform A platform implementation.
	 */

	function setPlatform(platformName, platform) {
	  env().setPlatform(platformName, platform);
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Adds two `tf.Tensor`s element-wise, A + B. Supports broadcasting.
	 *
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2, 3, 4]);
	 * const b = tf.tensor1d([10, 20, 30, 40]);
	 *
	 * a.add(b).print();  // or tf.add(a, b)
	 * ```
	 *
	 * ```js
	 * // Broadcast add a with b.
	 * const a = tf.scalar(5);
	 * const b = tf.tensor1d([10, 20, 30, 40]);
	 *
	 * a.add(b).print();  // or tf.add(a, b)
	 * ```
	 * @param a The first `tf.Tensor` to add.
	 * @param b The second `tf.Tensor` to add. Must have the same type as `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Arithmetic'}
	 */

	function add_(a, b) {
	  var $a = convertToTensor(a, 'a', 'add');
	  var $b = convertToTensor(b, 'b', 'add');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(Add, inputs);
	}

	var add$1 = op({
	  add_: add_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Divides two `tf.Tensor`s element-wise, A / B. Supports broadcasting.
	 * The result is rounded with floor function.
	 *
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 4, 9, 16]);
	 * const b = tf.tensor1d([1, 2, 3, 4]);
	 *
	 * a.floorDiv(b).print();  // or tf.div(a, b)
	 * ```
	 *
	 * ```js
	 * // Broadcast div a with b.
	 * const a = tf.tensor1d([2, 4, 6, 8]);
	 * const b = tf.scalar(2);
	 *
	 * a.floorDiv(b).print();  // or tf.floorDiv(a, b)
	 * ```
	 *
	 * @param a The first tensor as the numerator.
	 * @param b The second tensor as the denominator. Must have the same dtype as
	 * `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Arithmetic'}
	 */

	function floorDiv_(a, b) {
	  var $a = convertToTensor(a, 'a', 'floorDiv');
	  var $b = convertToTensor(b, 'b', 'floorDiv');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(FloorDiv, inputs);
	}

	var floorDiv = op({
	  floorDiv_: floorDiv_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Divides two `tf.Tensor`s element-wise, A / B. Supports broadcasting.
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 4, 9, 16]);
	 * const b = tf.tensor1d([1, 2, 3, 4]);
	 *
	 * a.div(b).print();  // or tf.div(a, b)
	 * ```
	 *
	 * ```js
	 * // Broadcast div a with b.
	 * const a = tf.tensor1d([2, 4, 6, 8]);
	 * const b = tf.scalar(2);
	 *
	 * a.div(b).print();  // or tf.div(a, b)
	 * ```
	 *
	 * @param a The first tensor as the numerator.
	 * @param b The second tensor as the denominator. Must have the same dtype as
	 * `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Arithmetic'}
	 */

	function div_(a, b) {
	  var $a = convertToTensor(a, 'a', 'div');
	  var $b = convertToTensor(b, 'b', 'div');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];

	  if ($a.dtype === 'int32' && $b.dtype === 'int32') {
	    return floorDiv($a, $b);
	  }

	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  var attrs = {}; // tslint:disable-next-line: no-unnecessary-type-assertion

	  return ENGINE.runKernel(RealDiv, inputs, attrs);
	}

	var div = op({
	  div_: div_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Multiplies two `tf.Tensor`s element-wise, A * B. Supports broadcasting.
	 *
	 * We also expose `tf.mulStrict` which has the same signature as this op and
	 * asserts that `a` and `b` are the same shape (does not broadcast).
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2, 3, 4]);
	 * const b = tf.tensor1d([2, 3, 4, 5]);
	 *
	 * a.mul(b).print();  // or tf.mul(a, b)
	 * ```
	 *
	 * ```js
	 * // Broadcast mul a with b.
	 * const a = tf.tensor1d([1, 2, 3, 4]);
	 * const b = tf.scalar(5);
	 *
	 * a.mul(b).print();  // or tf.mul(a, b)
	 * ```
	 * @param a The first tensor to multiply.
	 * @param b The second tensor to multiply. Must have the same dtype as `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Arithmetic'}
	 */

	function mul_(a, b) {
	  var $a = convertToTensor(a, 'a', 'mul');
	  var $b = convertToTensor(b, 'b', 'mul');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(Multiply, inputs);
	}

	var mul = op({
	  mul_: mul_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes absolute value element-wise: `abs(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([-1, 2, -3, 4]);
	 *
	 * x.abs().print();  // or tf.abs(x)
	 * ```
	 * @param x The input `tf.Tensor`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function abs_(x) {
	  var $x = convertToTensor(x, 'x', 'abs');

	  if ($x.dtype === 'complex64') {
	    var inputs = {
	      x: $x
	    };
	    return ENGINE.runKernel(ComplexAbs, inputs);
	  } else {
	    var _inputs = {
	      x: $x
	    };
	    return ENGINE.runKernel(Abs, _inputs);
	  }
	}

	var abs$8 = op({
	  abs_: abs_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes acos of the input `tf.Tensor` element-wise: `acos(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([0, 1, -1, .7]);
	 *
	 * x.acos().print();  // or tf.acos(x)
	 * ```
	 * @param x The input tensor.
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function acos_(x) {
	  var $x = convertToTensor(x, 'x', 'acos');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Acos, inputs);
	}

	var acos = op({
	  acos_: acos_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the inverse hyperbolic cos of the input `tf.Tensor` element-wise:
	 * `acosh(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([10, 1, 3, 5.7]);
	 *
	 * x.acosh().print();  // or tf.acosh(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function acosh_(x) {
	  var $x = convertToTensor(x, 'x', 'acosh');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Acosh, inputs);
	}

	var acosh = op({
	  acosh_: acosh_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Adds a list of `tf.Tensor`s element-wise, each with the same shape and dtype.
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2]);
	 * const b = tf.tensor1d([3, 4]);
	 * const c = tf.tensor1d([5, 6]);
	 *
	 * tf.addN([a, b, c]).print();
	 * ```
	 * @param tensors A list of tensors with the same shape and dtype.
	 * @doc {heading: 'Operations', subheading: 'Arithmetic'}
	 */

	function addN_(tensors) {
	  assert(Array.isArray(tensors), function () {
	    return 'The argument passed to tf.addN() must be a list of tensors';
	  });
	  assert(tensors.length >= 1, function () {
	    return "Must pass at least one tensor to tf.addN(), but got " + ("" + tensors.length);
	  });
	  var $tensors = tensors.map(function (t, i) {
	    return convertToTensor(t, "tensors" + i, 'addN');
	  });
	  var firstTensor = $tensors[0];
	  $tensors.forEach(function (t) {
	    if (t.dtype !== firstTensor.dtype) {
	      throw new Error('All tensors passed to tf.addN() must have the same dtype');
	    }
	  });
	  $tensors.forEach(function (t) {
	    if (!arraysEqual(t.shape, firstTensor.shape)) {
	      throw new Error('All tensors passed to tf.addN() must have the same shape');
	    }
	  });
	  var inputs = $tensors;
	  return ENGINE.runKernel(AddN, inputs);
	}

	var addN = op({
	  addN_: addN_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the logical and of elements across dimensions of a `tf.Tensor`.
	 *
	 * Reduces the input along the dimensions given in `axes`. Unless `keepDims`
	 * is true, the rank of the `tf.Tensor` is reduced by 1 for each entry in
	 * `axes`. If `keepDims` is true, the reduced dimensions are retained with
	 * length 1. If `axes` has no entries, all dimensions are reduced, and an
	 * `tf.Tensor` with a single element is returned.
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 1, 1], 'bool');
	 *
	 * x.all().print();  // or tf.all(x)
	 * ```
	 *
	 * ```js
	 * const x = tf.tensor2d([1, 1, 0, 0], [2, 2], 'bool');
	 *
	 * const axis = 1;
	 * x.all(axis).print();  // or tf.all(x, axis)
	 * ```
	 *
	 * @param x The input tensor. Must be of dtype bool.
	 * @param axis The dimension(s) to reduce. By default it reduces
	 *     all dimensions.
	 * @param keepDims If true, retains reduced dimensions with size 1.
	 *
	 * @doc {heading: 'Operations', subheading: 'Reduction'}
	 */

	function all_(x, axis, keepDims) {
	  if (axis === void 0) {
	    axis = null;
	  }

	  if (keepDims === void 0) {
	    keepDims = false;
	  }

	  var $x = convertToTensor(x, 'x', 'all', 'bool');
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    axis: axis,
	    keepDims: keepDims
	  };
	  return ENGINE.runKernel(All, inputs, attrs);
	}

	var all = op({
	  all_: all_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the logical or of elements across dimensions of a `tf.Tensor`.
	 *
	 * Reduces the input along the dimensions given in `axes`. Unless `keepDims`
	 * is true, the rank of the `tf.Tensor` is reduced by 1 for each entry in
	 * `axes`. If `keepDims` is true, the reduced dimensions are retained with
	 * length 1. If `axes` has no entries, all dimensions are reduced, and an
	 * `tf.Tensor` with a single element is returned.
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 1, 1], 'bool');
	 *
	 * x.any().print();  // or tf.any(x)
	 * ```
	 *
	 * ```js
	 * const x = tf.tensor2d([1, 1, 0, 0], [2, 2], 'bool');
	 *
	 * const axis = 1;
	 * x.any(axis).print();  // or tf.any(x, axis)
	 * ```
	 *
	 * @param x The input tensor. Must be of dtype bool.
	 * @param axis The dimension(s) to reduce. By default it reduces
	 *     all dimensions.
	 * @param keepDims If true, retains reduced dimensions with size 1.
	 *
	 * @doc {heading: 'Operations', subheading: 'Reduction'}
	 */

	function any_(x, axis, keepDims) {
	  if (axis === void 0) {
	    axis = null;
	  }

	  if (keepDims === void 0) {
	    keepDims = false;
	  }

	  var $x = convertToTensor(x, 'x', 'any', 'bool');
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    axis: axis,
	    keepDims: keepDims
	  };
	  return ENGINE.runKernel(Any, inputs, attrs);
	} // tslint:disable-next-line:variable-name


	var any = op({
	  any_: any_
	});

	/**
	 * @license
	 * Copyright 2020 Google Inc. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the indices of the maximum values along an `axis`.
	 *
	 * The result has the same shape as `input` with the dimension along `axis`
	 * removed.
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3]);
	 *
	 * x.argMax().print();  // or tf.argMax(x)
	 * ```
	 *
	 * ```js
	 * const x = tf.tensor2d([1, 2, 4, 3], [2, 2]);
	 *
	 * const axis = 1;
	 * x.argMax(axis).print();  // or tf.argMax(x, axis)
	 * ```
	 *
	 * @param x The input tensor.
	 * @param axis The dimension to reduce. Defaults to 0 (outer-most dimension).
	 *
	 * @doc {heading: 'Operations', subheading: 'Reduction'}
	 */

	function argMax_(x, axis) {
	  if (axis === void 0) {
	    axis = 0;
	  }

	  var $x = convertToTensor(x, 'x', 'argMax');
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    axis: axis
	  };
	  return ENGINE.runKernel(ArgMax, inputs, attrs);
	}

	var argMax = op({
	  argMax_: argMax_
	});

	/**
	 * @license
	 * Copyright 2020 Google Inc. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the indices of the minimum values along an `axis`.
	 *
	 * The result has the same shape as `input` with the dimension along `axis`
	 * removed.
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3]);
	 *
	 * x.argMin().print();  // or tf.argMin(x)
	 * ```
	 *
	 * ```js
	 * const x = tf.tensor2d([1, 2, 4, 3], [2, 2]);
	 *
	 * const axis = 1;
	 * x.argMin(axis).print();  // or tf.argMin(x, axis)
	 * ```
	 *
	 * @param x The input tensor.
	 * @param axis The dimension to reduce. Defaults to 0 (outer-most dimension).
	 *
	 * @doc {heading: 'Operations', subheading: 'Reduction'}
	 */

	function argMin_(x, axis) {
	  if (axis === void 0) {
	    axis = 0;
	  }

	  var $x = convertToTensor(x, 'x', 'argMin');
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    axis: axis
	  };
	  return ENGINE.runKernel(ArgMin, inputs, attrs);
	}

	var argMin = op({
	  argMin_: argMin_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes asin of the input `tf.Tensor` element-wise: `asin(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([0, 1, -1, .7]);
	 *
	 * x.asin().print();  // or tf.asin(x)
	 * ```
	 * @param x The input tensor.
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function asin_(x) {
	  var $x = convertToTensor(x, 'x', 'asin');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Asin, inputs);
	}

	var asin = op({
	  asin_: asin_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes inverse hyperbolic sin of the input `tf.Tensor` element-wise:
	 * `asinh(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([0, 1, -1, .7]);
	 *
	 * x.asinh().print();  // or tf.asinh(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function asinh_(x) {
	  var $x = convertToTensor(x, 'x', 'asinh');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Asinh, inputs);
	}

	var asinh$1 = op({
	  asinh_: asinh_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes atan of the input `tf.Tensor` element-wise: `atan(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([0, 1, -1, .7]);
	 *
	 * x.atan().print();  // or tf.atan(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function atan_(x) {
	  var $x = convertToTensor(x, 'x', 'atan');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Atan, inputs);
	}

	var atan = op({
	  atan_: atan_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes arctangent of `tf.Tensor`s a / b element-wise: `atan2(a, b)`.
	 * Supports broadcasting.
	 *
	 * ```js
	 * const a = tf.tensor1d([1.0, 1.0, -1.0, .7]);
	 * const b = tf.tensor1d([2.0, 13.0, 3.5, .21]);
	 *
	 * tf.atan2(a, b).print()
	 * ```
	 *
	 * @param a The first tensor.
	 * @param b The second tensor. Must have the same dtype as `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function atan2_(a, b) {
	  var $a = convertToTensor(a, 'a', 'atan2');
	  var $b = convertToTensor(b, 'b', 'atan2');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(Atan2, inputs);
	}

	var atan2 = op({
	  atan2_: atan2_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes inverse hyperbolic tan of the input `tf.Tensor` element-wise:
	 * `atanh(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([0, .1, -.1, .7]);
	 *
	 * x.atanh().print();  // or tf.atanh(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function atanh_(x) {
	  var $x = convertToTensor(x, 'x', 'atanh');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Atanh, inputs);
	}

	var atanh = op({
	  atanh_: atanh_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */

	/**
	 *
	 * @param inputShape Input tensor shape is of the following dimensions:
	 *     `[batch, height, width, inChannels]`.
	 * @param filterShape The filter shape is of the following dimensions:
	 *     `[filterHeight, filterWidth, depth]`.
	 * @param strides The strides of the sliding window for each dimension of the
	 *     input tensor: `[strideHeight, strideWidth]`.
	 *     If `strides` is a single number,
	 *     then `strideHeight == strideWidth`.
	 * @param pad The type of padding algorithm.
	 *    - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *    - `valid`: output will be smaller than input if filter is larger
	 *       than 1*1x1.
	 *    - For more info, see this guide:
	 *     [https://www.tensorflow.org/api_guides/python/nn#Convolution](
	 *          https://www.tensorflow.org/api_guides/python/nn#Convolution)
	 * @param dataFormat The data format of the input and output data.
	 *     Defaults to 'NHWC'.
	 * @param dilations The dilation rates: `[dilationHeight, dilationWidth]`.
	 *     Defaults to `[1, 1]`. If `dilations` is a single number, then
	 *     `dilationHeight == dilationWidth`.
	 */
	function computeDilation2DInfo(inputShape, filterShape, strides, pad, dataFormat, dilations) {
	  if (dataFormat === void 0) {
	    dataFormat = 'NHWC';
	  }

	  // `computerConv2DInfo` require filterShape to be in the dimension of:
	  // `[filterHeight, filterWidth, depth, outDepth]`, dilation2d doesn't have
	  // outDepth, it should have the same depth as the input.
	  // Input shape: [batch, height, width, inChannels]
	  var inputChannels = inputShape[3];
	  var $filterShape = [].concat(filterShape, [inputChannels]);
	  var $dataFormat = convertConv2DDataFormat(dataFormat);
	  return computeConv2DInfo(inputShape, $filterShape, strides, dilations, pad, null
	  /* roundingMode */
	  , null
	  /* depthWise */
	  , $dataFormat);
	}
	function computePool2DInfo(inShape, filterSize, strides, dilations, pad, roundingMode, dataFormat) {
	  if (dataFormat === void 0) {
	    dataFormat = 'channelsLast';
	  }

	  var _parseTupleParam = parseTupleParam(filterSize),
	      filterHeight = _parseTupleParam[0],
	      filterWidth = _parseTupleParam[1];

	  var filterShape;

	  if (dataFormat === 'channelsLast') {
	    filterShape = [filterHeight, filterWidth, inShape[3], inShape[3]];
	  } else if (dataFormat === 'channelsFirst') {
	    filterShape = [filterHeight, filterWidth, inShape[1], inShape[1]];
	  } else {
	    throw new Error("Unknown dataFormat " + dataFormat);
	  }

	  return computeConv2DInfo(inShape, filterShape, strides, dilations, pad, roundingMode, false, dataFormat);
	}
	/**
	 * Computes the information for a forward pass of a pooling3D operation.
	 */

	function computePool3DInfo(inShape, filterSize, strides, dilations, pad, roundingMode, dataFormat) {
	  if (dataFormat === void 0) {
	    dataFormat = 'NDHWC';
	  }

	  var _parse3TupleParam = parse3TupleParam(filterSize),
	      filterDepth = _parse3TupleParam[0],
	      filterHeight = _parse3TupleParam[1],
	      filterWidth = _parse3TupleParam[2];

	  var filterShape;
	  var $dataFormat;

	  if (dataFormat === 'NDHWC') {
	    $dataFormat = 'channelsLast';
	    filterShape = [filterDepth, filterHeight, filterWidth, inShape[4], inShape[4]];
	  } else if (dataFormat === 'NCDHW') {
	    $dataFormat = 'channelsFirst';
	    filterShape = [filterDepth, filterHeight, filterWidth, inShape[1], inShape[1]];
	  } else {
	    throw new Error("Unknown dataFormat " + dataFormat);
	  }

	  return computeConv3DInfo(inShape, filterShape, strides, dilations, pad, false, $dataFormat, roundingMode);
	}
	/**
	 * Computes the information for a forward pass of a convolution/pooling
	 * operation.
	 */

	function computeConv2DInfo(inShape, filterShape, strides, dilations, pad, roundingMode, depthwise, dataFormat) {
	  if (depthwise === void 0) {
	    depthwise = false;
	  }

	  if (dataFormat === void 0) {
	    dataFormat = 'channelsLast';
	  }

	  var batchSize = -1,
	      inHeight = -1,
	      inWidth = -1,
	      inChannels = -1;

	  if (dataFormat === 'channelsLast') {
	    batchSize = inShape[0];
	    inHeight = inShape[1];
	    inWidth = inShape[2];
	    inChannels = inShape[3];
	  } else if (dataFormat === 'channelsFirst') {
	    batchSize = inShape[0];
	    inChannels = inShape[1];
	    inHeight = inShape[2];
	    inWidth = inShape[3];
	  } else {
	    throw new Error("Unknown dataFormat " + dataFormat);
	  }

	  var filterHeight = filterShape[0],
	      filterWidth = filterShape[1],
	      filterChannels = filterShape[3];

	  var _parseTupleParam2 = parseTupleParam(strides),
	      strideHeight = _parseTupleParam2[0],
	      strideWidth = _parseTupleParam2[1];

	  var _parseTupleParam3 = parseTupleParam(dilations),
	      dilationHeight = _parseTupleParam3[0],
	      dilationWidth = _parseTupleParam3[1];

	  var effectiveFilterHeight = getEffectiveFilterSize(filterHeight, dilationHeight);
	  var effectiveFilterWidth = getEffectiveFilterSize(filterWidth, dilationWidth);

	  var _getPadAndOutInfo = getPadAndOutInfo(pad, inHeight, inWidth, strideHeight, strideWidth, effectiveFilterHeight, effectiveFilterWidth, roundingMode, dataFormat),
	      padInfo = _getPadAndOutInfo.padInfo,
	      outHeight = _getPadAndOutInfo.outHeight,
	      outWidth = _getPadAndOutInfo.outWidth;

	  var outChannels = depthwise ? filterChannels * inChannels : filterChannels;
	  var outShape;

	  if (dataFormat === 'channelsFirst') {
	    outShape = [batchSize, outChannels, outHeight, outWidth];
	  } else if (dataFormat === 'channelsLast') {
	    outShape = [batchSize, outHeight, outWidth, outChannels];
	  }

	  return {
	    batchSize: batchSize,
	    dataFormat: dataFormat,
	    inHeight: inHeight,
	    inWidth: inWidth,
	    inChannels: inChannels,
	    outHeight: outHeight,
	    outWidth: outWidth,
	    outChannels: outChannels,
	    padInfo: padInfo,
	    strideHeight: strideHeight,
	    strideWidth: strideWidth,
	    filterHeight: filterHeight,
	    filterWidth: filterWidth,
	    effectiveFilterHeight: effectiveFilterHeight,
	    effectiveFilterWidth: effectiveFilterWidth,
	    dilationHeight: dilationHeight,
	    dilationWidth: dilationWidth,
	    inShape: inShape,
	    outShape: outShape,
	    filterShape: filterShape
	  };
	}
	/**
	 * Computes the information for a forward pass of a 3D convolution/pooling
	 * operation.
	 */

	function computeConv3DInfo(inShape, filterShape, strides, dilations, pad, depthwise, dataFormat, roundingMode) {
	  if (depthwise === void 0) {
	    depthwise = false;
	  }

	  if (dataFormat === void 0) {
	    dataFormat = 'channelsLast';
	  }

	  var batchSize = -1,
	      inDepth = -1,
	      inHeight = -1,
	      inWidth = -1,
	      inChannels = -1;

	  if (dataFormat === 'channelsLast') {
	    batchSize = inShape[0];
	    inDepth = inShape[1];
	    inHeight = inShape[2];
	    inWidth = inShape[3];
	    inChannels = inShape[4];
	  } else if (dataFormat === 'channelsFirst') {
	    batchSize = inShape[0];
	    inChannels = inShape[1];
	    inDepth = inShape[2];
	    inHeight = inShape[3];
	    inWidth = inShape[4];
	  } else {
	    throw new Error("Unknown dataFormat " + dataFormat);
	  }

	  var filterDepth = filterShape[0],
	      filterHeight = filterShape[1],
	      filterWidth = filterShape[2],
	      filterChannels = filterShape[4];

	  var _parse3TupleParam2 = parse3TupleParam(strides),
	      strideDepth = _parse3TupleParam2[0],
	      strideHeight = _parse3TupleParam2[1],
	      strideWidth = _parse3TupleParam2[2];

	  var _parse3TupleParam3 = parse3TupleParam(dilations),
	      dilationDepth = _parse3TupleParam3[0],
	      dilationHeight = _parse3TupleParam3[1],
	      dilationWidth = _parse3TupleParam3[2];

	  var effectiveFilterDepth = getEffectiveFilterSize(filterDepth, dilationDepth);
	  var effectiveFilterHeight = getEffectiveFilterSize(filterHeight, dilationHeight);
	  var effectiveFilterWidth = getEffectiveFilterSize(filterWidth, dilationWidth);

	  var _get3DPadAndOutInfo = get3DPadAndOutInfo(pad, inDepth, inHeight, inWidth, strideDepth, strideHeight, strideWidth, effectiveFilterDepth, effectiveFilterHeight, effectiveFilterWidth, roundingMode),
	      padInfo = _get3DPadAndOutInfo.padInfo,
	      outDepth = _get3DPadAndOutInfo.outDepth,
	      outHeight = _get3DPadAndOutInfo.outHeight,
	      outWidth = _get3DPadAndOutInfo.outWidth;

	  var outChannels = depthwise ? filterChannels * inChannels : filterChannels;
	  var outShape;

	  if (dataFormat === 'channelsFirst') {
	    outShape = [batchSize, outChannels, outDepth, outHeight, outWidth];
	  } else if (dataFormat === 'channelsLast') {
	    outShape = [batchSize, outDepth, outHeight, outWidth, outChannels];
	  }

	  return {
	    batchSize: batchSize,
	    dataFormat: dataFormat,
	    inDepth: inDepth,
	    inHeight: inHeight,
	    inWidth: inWidth,
	    inChannels: inChannels,
	    outDepth: outDepth,
	    outHeight: outHeight,
	    outWidth: outWidth,
	    outChannels: outChannels,
	    padInfo: padInfo,
	    strideDepth: strideDepth,
	    strideHeight: strideHeight,
	    strideWidth: strideWidth,
	    filterDepth: filterDepth,
	    filterHeight: filterHeight,
	    filterWidth: filterWidth,
	    effectiveFilterDepth: effectiveFilterDepth,
	    effectiveFilterHeight: effectiveFilterHeight,
	    effectiveFilterWidth: effectiveFilterWidth,
	    dilationDepth: dilationDepth,
	    dilationHeight: dilationHeight,
	    dilationWidth: dilationWidth,
	    inShape: inShape,
	    outShape: outShape,
	    filterShape: filterShape
	  };
	}

	function computeOutputShape2D(inShape, fieldSize, stride, zeroPad, roundingMode) {
	  if (zeroPad == null) {
	    zeroPad = computeDefaultPad(inShape, fieldSize, stride);
	  }

	  var inputRows = inShape[0];
	  var inputCols = inShape[1];
	  var outputRows = round((inputRows - fieldSize + 2 * zeroPad) / stride + 1, roundingMode);
	  var outputCols = round((inputCols - fieldSize + 2 * zeroPad) / stride + 1, roundingMode);
	  return [outputRows, outputCols];
	}

	function computeOutputShape4D(inShape, fieldSize, outChannels, stride, zeroPad, roundingMode) {
	  if (zeroPad == null) {
	    zeroPad = computeDefaultPad(inShape, fieldSize, stride);
	  }

	  var inputDepth = inShape[0];
	  var inputRows = inShape[1];
	  var inputCols = inShape[2];
	  var outputDepths = round((inputDepth - fieldSize + 2 * zeroPad) / stride + 1, roundingMode);
	  var outputRows = round((inputRows - fieldSize + 2 * zeroPad) / stride + 1, roundingMode);
	  var outputCols = round((inputCols - fieldSize + 2 * zeroPad) / stride + 1, roundingMode);
	  return [outputDepths, outputRows, outputCols, outChannels];
	}

	function computeDefaultPad(inputShape, fieldSize, stride, dilation) {
	  if (dilation === void 0) {
	    dilation = 1;
	  }

	  var effectiveFieldSize = getEffectiveFilterSize(fieldSize, dilation);
	  return Math.floor((inputShape[0] * (stride - 1) - stride + effectiveFieldSize) / 2);
	}

	function parseTupleParam(param) {
	  if (typeof param === 'number') {
	    return [param, param, param];
	  }

	  if (param.length === 2) {
	    return [param[0], param[1], 1];
	  }

	  return param;
	}

	function parse3TupleParam(param) {
	  return typeof param === 'number' ? [param, param, param] : param;
	}
	/* See https://www.tensorflow.org/api_docs/python/tf/nn/atrous_conv2d
	 * Atrous convolution is equivalent to standard convolution with upsampled
	 * filters with effective_filter_height =
	 * filter_height + (filter_height - 1) * (dilation - 1)
	 * and effective_filter_width =
	 * filter_width + (filter_width - 1) * (dilation - 1),
	 * produced by inserting dilation - 1 zeros along consecutive elements across
	 * the filters' spatial dimensions.
	 * When there is a dilation, this converts a filter dimension to the
	 * effective filter dimension, so it can be used in a standard convolution.
	 */


	function getEffectiveFilterSize(filterSize, dilation) {
	  if (dilation <= 1) {
	    return filterSize;
	  }

	  return filterSize + (filterSize - 1) * (dilation - 1);
	}

	function getPadAndOutInfo(pad, inHeight, inWidth, strideHeight, strideWidth, filterHeight, filterWidth, roundingMode, dataFormat) {
	  var padInfo;
	  var outHeight;
	  var outWidth;

	  if (typeof pad === 'number') {
	    var padType = pad === 0 ? 'VALID' : 'NUMBER';
	    padInfo = {
	      top: pad,
	      bottom: pad,
	      left: pad,
	      right: pad,
	      type: padType
	    };
	    var outShape = computeOutputShape2D([inHeight, inWidth], filterHeight, strideHeight, pad, roundingMode);
	    outHeight = outShape[0];
	    outWidth = outShape[1];
	  } else if (pad === 'same') {
	    outHeight = Math.ceil(inHeight / strideHeight);
	    outWidth = Math.ceil(inWidth / strideWidth);
	    var padAlongHeight = Math.max(0, (outHeight - 1) * strideHeight + filterHeight - inHeight);
	    var padAlongWidth = Math.max(0, (outWidth - 1) * strideWidth + filterWidth - inWidth);
	    var top = Math.floor(padAlongHeight / 2);
	    var bottom = padAlongHeight - top;
	    var left = Math.floor(padAlongWidth / 2);
	    var right = padAlongWidth - left;
	    padInfo = {
	      top: top,
	      bottom: bottom,
	      left: left,
	      right: right,
	      type: 'SAME'
	    };
	  } else if (pad === 'valid') {
	    padInfo = {
	      top: 0,
	      bottom: 0,
	      left: 0,
	      right: 0,
	      type: 'VALID'
	    };
	    outHeight = Math.ceil((inHeight - filterHeight + 1) / strideHeight);
	    outWidth = Math.ceil((inWidth - filterWidth + 1) / strideWidth);
	  } else if (typeof pad === 'object') {
	    var _top = dataFormat === 'channelsLast' ? pad[1][0] : pad[2][0];

	    var _bottom = dataFormat === 'channelsLast' ? pad[1][1] : pad[2][1];

	    var _left = dataFormat === 'channelsLast' ? pad[2][0] : pad[3][0];

	    var _right = dataFormat === 'channelsLast' ? pad[2][1] : pad[3][1];

	    var _padType = _top === 0 && _bottom === 0 && _left === 0 && _right === 0 ? 'VALID' : 'EXPLICIT';

	    padInfo = {
	      top: _top,
	      bottom: _bottom,
	      left: _left,
	      right: _right,
	      type: _padType
	    };
	    outHeight = round((inHeight - filterHeight + _top + _bottom) / strideHeight + 1, roundingMode);
	    outWidth = round((inWidth - filterWidth + _left + _right) / strideWidth + 1, roundingMode);
	  } else {
	    throw Error("Unknown padding parameter: " + pad);
	  }

	  return {
	    padInfo: padInfo,
	    outHeight: outHeight,
	    outWidth: outWidth
	  };
	}

	function get3DPadAndOutInfo(pad, inDepth, inHeight, inWidth, strideDepth, strideHeight, strideWidth, filterDepth, filterHeight, filterWidth, roundingMode) {
	  var padInfo;
	  var outDepth;
	  var outHeight;
	  var outWidth;

	  if (typeof pad === 'number') {
	    var padType = pad === 0 ? 'VALID' : 'NUMBER';
	    padInfo = {
	      top: pad,
	      bottom: pad,
	      left: pad,
	      right: pad,
	      front: pad,
	      back: pad,
	      type: padType
	    };
	    var outShape = computeOutputShape4D([inDepth, inHeight, inWidth, 1], filterDepth, 1, strideDepth, pad, roundingMode);
	    outDepth = outShape[0];
	    outHeight = outShape[1];
	    outWidth = outShape[2];
	  } else if (pad === 'same') {
	    outDepth = Math.ceil(inDepth / strideDepth);
	    outHeight = Math.ceil(inHeight / strideHeight);
	    outWidth = Math.ceil(inWidth / strideWidth);
	    var padAlongDepth = (outDepth - 1) * strideDepth + filterDepth - inDepth;
	    var padAlongHeight = (outHeight - 1) * strideHeight + filterHeight - inHeight;
	    var padAlongWidth = (outWidth - 1) * strideWidth + filterWidth - inWidth;
	    var front = Math.floor(padAlongDepth / 2);
	    var back = padAlongDepth - front;
	    var top = Math.floor(padAlongHeight / 2);
	    var bottom = padAlongHeight - top;
	    var left = Math.floor(padAlongWidth / 2);
	    var right = padAlongWidth - left;
	    padInfo = {
	      top: top,
	      bottom: bottom,
	      left: left,
	      right: right,
	      front: front,
	      back: back,
	      type: 'SAME'
	    };
	  } else if (pad === 'valid') {
	    padInfo = {
	      top: 0,
	      bottom: 0,
	      left: 0,
	      right: 0,
	      front: 0,
	      back: 0,
	      type: 'VALID'
	    };
	    outDepth = Math.ceil((inDepth - filterDepth + 1) / strideDepth);
	    outHeight = Math.ceil((inHeight - filterHeight + 1) / strideHeight);
	    outWidth = Math.ceil((inWidth - filterWidth + 1) / strideWidth);
	  } else {
	    throw Error("Unknown padding parameter: " + pad);
	  }

	  return {
	    padInfo: padInfo,
	    outDepth: outDepth,
	    outHeight: outHeight,
	    outWidth: outWidth
	  };
	}
	/**
	 * Rounds a value depending on the rounding mode
	 * @param value
	 * @param roundingMode A string from: 'ceil', 'round', 'floor'. If none is
	 *     provided, it will default to truncate.
	 */


	function round(value, roundingMode) {
	  if (!roundingMode) {
	    return Math.trunc(value);
	  }

	  switch (roundingMode) {
	    case 'round':
	      // used for Caffe Conv
	      return Math.round(value);

	    case 'ceil':
	      // used for Caffe Pool
	      return Math.ceil(value);

	    case 'floor':
	      return Math.floor(value);

	    default:
	      throw new Error("Unknown roundingMode " + roundingMode);
	  }
	}

	function tupleValuesAreOne(param) {
	  var _parseTupleParam4 = parseTupleParam(param),
	      dimA = _parseTupleParam4[0],
	      dimB = _parseTupleParam4[1],
	      dimC = _parseTupleParam4[2];

	  return dimA === 1 && dimB === 1 && dimC === 1;
	}
	function eitherStridesOrDilationsAreOne(strides, dilations) {
	  return tupleValuesAreOne(strides) || tupleValuesAreOne(dilations);
	}
	/**
	 * Convert Conv2D dataFormat from 'NHWC'|'NCHW' to
	 *    'channelsLast'|'channelsFirst'
	 * @param dataFormat in 'NHWC'|'NCHW' mode
	 * @return dataFormat in 'channelsLast'|'channelsFirst' mode
	 * @throws unknown dataFormat
	 */

	function convertConv2DDataFormat(dataFormat) {
	  if (dataFormat === 'NHWC') {
	    return 'channelsLast';
	  } else if (dataFormat === 'NCHW') {
	    return 'channelsFirst';
	  } else {
	    throw new Error("Unknown dataFormat " + dataFormat);
	  }
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Reshapes a `tf.Tensor` to a given shape.
	 *
	 * Given an input tensor, returns a new tensor with the same values as the
	 * input tensor with shape `shape`.
	 *
	 * If one component of shape is the special value -1, the size of that
	 * dimension is computed so that the total size remains constant. In
	 * particular, a shape of [-1] flattens into 1-D. At most one component of
	 * shape can be -1.
	 *
	 * If shape is 1-D or higher, then the operation returns a tensor with shape
	 * shape filled with the values of tensor. In this case, the number of
	 * elements implied by shape must be the same as the number of elements in
	 * tensor.
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3, 4]);
	 * x.reshape([2, 2]).print();
	 * ```
	 *
	 * @param x The input tensor to be reshaped.
	 * @param shape An array of integers defining the output tensor shape.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Transformations'}
	 */

	function reshape_(x, shape) {
	  var $x = convertToTensor(x, 'x', 'reshape', 'string_or_numeric');
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    shape: shape
	  };
	  return ENGINE.runKernel(Reshape, inputs, attrs);
	}

	var reshape = op({
	  reshape_: reshape_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the 2D average pooling of an image.
	 *
	 * @param x The input tensor, of rank 4 or rank 3 of shape
	 *     `[batch, height, width, inChannels]`. If rank 3, batch of 1 is assumed.
	 * @param filterSize The filter size: `[filterHeight, filterWidth]`. If
	 *     `filterSize` is a single number, then `filterHeight == filterWidth`.
	 * @param strides The strides of the pooling: `[strideHeight, strideWidth]`. If
	 *     `strides` is a single number, then `strideHeight == strideWidth`.
	 * @param pad The type of padding algorithm:
	 *    - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *    - `valid`: output will be smaller than input if filter is larger
	 *       than 1x1.
	 *    - For more info, see this guide:
	 *     [https://www.tensorflow.org/api_guides/python/nn#Convolution](
	 *         https://www.tensorflow.org/api_guides/python/nn#Convolution)
	 * @param dimRoundingMode A string from: 'ceil', 'round', 'floor'. If none is
	 *     provided, it will default to truncate.
	 */

	function avgPool_(x, filterSize, strides, pad, dimRoundingMode) {
	  var $x = convertToTensor(x, 'x', 'avgPool', 'float32');
	  var dilations = 1;
	  assert(eitherStridesOrDilationsAreOne(strides, dilations), function () {
	    return 'Error in avgPool: Either strides or dilations must be 1. ' + ("Got strides " + strides + " and dilations '" + dilations + "'");
	  });
	  var x4D = $x;
	  var reshapedTo4D = false;

	  if ($x.rank === 3) {
	    reshapedTo4D = true;
	    x4D = reshape($x, [1, $x.shape[0], $x.shape[1], $x.shape[2]]);
	  }

	  assert(x4D.rank === 4, function () {
	    return "Error in avgPool: x must be rank 4 but got rank " + x4D.rank + ".";
	  });

	  if (dimRoundingMode != null) {
	    assert(isInt(pad), function () {
	      return "Error in avgPool: pad must be an integer when using, " + ("dimRoundingMode " + dimRoundingMode + " but got pad " + pad + ".");
	    });
	  }

	  var inputs = {
	    x: x4D
	  };
	  var attrs = {
	    filterSize: filterSize,
	    strides: strides,
	    pad: pad,
	    dimRoundingMode: dimRoundingMode
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var res = ENGINE.runKernel(AvgPool, inputs, attrs);
	  res = cast(res, $x.dtype);

	  if (reshapedTo4D) {
	    return reshape(res, [res.shape[1], res.shape[2], res.shape[3]]);
	  }

	  return res;
	}

	var avgPool = op({
	  avgPool_: avgPool_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the 3D average pooling.
	 *
	 * ```js
	 * const x = tf.tensor5d([1, 2, 3, 4, 5, 6, 7, 8], [1, 2, 2, 2, 1]);
	 * const result = tf.avgPool3d(x, 2, 1, 'valid');
	 * result.print();
	 * ```
	 *
	 * @param x The input tensor, of rank 5 or rank 4 of shape
	 *     `[batch, depth, height, width, inChannels]`.
	 * @param filterSize The filter size:
	 *     `[filterDepth, filterHeight, filterWidth]`.
	 *     If `filterSize` is a single number,
	 *     then `filterDepth == filterHeight == filterWidth`.
	 * @param strides The strides of the pooling:
	 *     `[strideDepth, strideHeight, strideWidth]`.
	 *     If `strides` is a single number,
	 *     then `strideDepth == strideHeight == strideWidth`.
	 * @param pad The type of padding algorithm.
	 *    - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *    - `valid`: output will be smaller than input if filter is larger
	 *       than 1*1x1.
	 *    - For more info, see this guide:
	 *     [https://www.tensorflow.org/api_guides/python/nn#Convolution](
	 *          https://www.tensorflow.org/api_guides/python/nn#Convolution)
	 * @param dimRoundingMode A string from: 'ceil', 'round', 'floor'. If none is
	 *     provided, it will default to truncate.
	 * @param dataFormat An optional string from: "NDHWC", "NCDHW". Defaults to
	 *     "NDHWC". Specify the data format of the input and output data. With the
	 *     default format "NDHWC", the data is stored in the order of: [batch,
	 *     depth, height, width, channels]. Only "NDHWC" is currently supported.
	 *
	 * @doc {heading: 'Operations', subheading: 'Convolution'}
	 */

	function avgPool3d_(x, filterSize, strides, pad, dimRoundingMode, dataFormat) {
	  if (dataFormat === void 0) {
	    dataFormat = 'NDHWC';
	  }

	  var $x = convertToTensor(x, 'x', 'avgPool3d', 'float32');
	  var x5D = $x;
	  var reshapedTo5D = false;

	  if ($x.rank === 4) {
	    reshapedTo5D = true;
	    x5D = reshape($x, [1, $x.shape[0], $x.shape[1], $x.shape[2], $x.shape[3]]);
	  }

	  assert(x5D.rank === 5, function () {
	    return "Error in avgPool3d: x must be rank 5 but got rank " + x5D.rank + ".";
	  });
	  assert(dataFormat === 'NDHWC', function () {
	    return "Error in avgPool3d: Only NDHWC is currently supported, " + ("but got dataFormat of " + dataFormat);
	  });

	  if (dimRoundingMode != null) {
	    assert(isInt(pad), function () {
	      return "Error in avgPool3d: pad must be an integer when using, " + ("dimRoundingMode " + dimRoundingMode + " but got pad " + pad + ".");
	    });
	  }

	  var inputs = {
	    x: x5D
	  };
	  var attrs = {
	    filterSize: filterSize,
	    strides: strides,
	    pad: pad,
	    dimRoundingMode: dimRoundingMode,
	    dataFormat: dataFormat
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var res = ENGINE.runKernel(AvgPool3D, inputs, attrs);
	  res = cast(res, x5D.dtype);

	  if (reshapedTo5D) {
	    return reshape(res, [res.shape[1], res.shape[2], res.shape[3], res.shape[4]]);
	  }

	  return res;
	}

	var avgPool3d = op({
	  avgPool3d_: avgPool3d_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Concatenates a list of `tf.Tensor`s along a given axis.
	 *
	 * The tensors ranks and types must match, and their sizes must match in all
	 * dimensions except `axis`.
	 *
	 * Also available are stricter rank-specific methods that assert that
	 * `tensors` are of the given rank:
	 *   - `tf.concat1d`
	 *   - `tf.concat2d`
	 *   - `tf.concat3d`
	 *   - `tf.concat4d`
	 *
	 * Except `tf.concat1d` (which does not have axis param), all methods have
	 * same signature as this method.
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2]);
	 * const b = tf.tensor1d([3, 4]);
	 * a.concat(b).print();  // or a.concat(b)
	 * ```
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2]);
	 * const b = tf.tensor1d([3, 4]);
	 * const c = tf.tensor1d([5, 6]);
	 * tf.concat([a, b, c]).print();
	 * ```
	 *
	 * ```js
	 * const a = tf.tensor2d([[1, 2], [10, 20]]);
	 * const b = tf.tensor2d([[3, 4], [30, 40]]);
	 * const axis = 1;
	 * tf.concat([a, b], axis).print();
	 * ```
	 * @param tensors A list of tensors to concatenate.
	 * @param axis The axis to concate along. Defaults to 0 (the first dim).
	 *
	 * @doc {heading: 'Tensors', subheading: 'Slicing and Joining'}
	 */

	function concat_(tensors, axis) {
	  if (axis === void 0) {
	    axis = 0;
	  }

	  assert(tensors.length >= 1, function () {
	    return 'Pass at least one tensor to concat';
	  });
	  var $tensors = convertToTensorArray(tensors, 'tensors', 'concat', 'string_or_numeric');

	  if ($tensors[0].dtype === 'complex64') {
	    $tensors.forEach(function (tensor) {
	      if (tensor.dtype !== 'complex64') {
	        throw new Error("Cannot concatenate complex64 tensors with a tensor\n          with dtype " + tensor.dtype + ". ");
	      }
	    });
	  }

	  if ($tensors.length === 1) {
	    return clone($tensors[0]);
	  }

	  var inputs = $tensors;
	  var attr = {
	    axis: axis
	  };
	  return ENGINE.runKernel(Concat, inputs, attr);
	}

	var concat = op({
	  concat_: concat_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes sigmoid element-wise, `1 / (1 + exp(-x))`
	 *
	 * ```js
	 * const x = tf.tensor1d([0, -1, 2, -3]);
	 *
	 * x.sigmoid().print();  // or tf.sigmoid(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function sigmoid_(x) {
	  var $x = convertToTensor(x, 'x', 'sigmoid');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Sigmoid, inputs);
	}

	var sigmoid = op({
	  sigmoid_: sigmoid_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Extracts a slice from a `tf.Tensor` starting at coordinates `begin`
	 * and is of size `size`.
	 *
	 * Also available are stricter rank-specific methods with the same signature
	 * as this method that assert that `x` is of the given rank:
	 *   - `tf.slice1d`
	 *   - `tf.slice2d`
	 *   - `tf.slice3d`
	 *   - `tf.slice4d`
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3, 4]);
	 *
	 * x.slice([1], [2]).print();
	 * ```
	 *
	 * ```js
	 * const x = tf.tensor2d([1, 2, 3, 4], [2, 2]);
	 *
	 * x.slice([1, 0], [1, 2]).print();
	 * ```
	 * @param x The input `tf.Tensor` to slice from.
	 * @param begin The coordinates to start the slice from. The length can be
	 *     less than the rank of x - the rest of the axes will have implicit 0 as
	 *     start. Can also be a single number, in which case it specifies the
	 *     first axis.
	 * @param size The size of the slice. The length can be less than the rank of
	 *     x - the rest of the axes will have implicit -1. A value of -1 requests
	 *     the rest of the dimensions in the axis. Can also be a single number,
	 *     in which case it specifies the size of the first axis.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Slicing and Joining'}
	 */

	function slice_(x, begin, size) {
	  var $x = convertToTensor(x, 'x', 'slice', 'string_or_numeric');

	  if ($x.rank === 0) {
	    throw new Error('Slicing scalar is not possible');
	  }

	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    begin: begin,
	    size: size
	  };
	  return ENGINE.runKernel(Slice, inputs, attrs);
	}

	var slice$2 = op({
	  slice_: slice_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes hyperbolic tangent of the input `tf.Tensor` element-wise: `tanh(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([0, 1, -1, 70]);
	 *
	 * x.tanh().print();  // or tf.tanh(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function tanh_(x) {
	  var $x = convertToTensor(x, 'x', 'tanh');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Tanh, inputs);
	}

	var tanh$1 = op({
	  tanh_: tanh_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the next state and output of a BasicLSTMCell.
	 *
	 * Returns `[newC, newH]`.
	 *
	 * Derived from tf.contrib.rnn.BasicLSTMCell.
	 *
	 * @param forgetBias Forget bias for the cell.
	 * @param lstmKernel The weights for the cell.
	 * @param lstmBias The bias for the cell.
	 * @param data The input to the cell.
	 * @param c Previous cell state.
	 * @param h Previous cell output.
	 *
	 * @doc {heading: 'Operations', subheading: 'RNN'}
	 */

	function basicLSTMCell_(forgetBias, lstmKernel, lstmBias, data, c, h) {
	  var $forgetBias = convertToTensor(forgetBias, 'forgetBias', 'basicLSTMCell');
	  var $lstmKernel = convertToTensor(lstmKernel, 'lstmKernel', 'basicLSTMCell');
	  var $lstmBias = convertToTensor(lstmBias, 'lstmBias', 'basicLSTMCell');
	  var $data = convertToTensor(data, 'data', 'basicLSTMCell');
	  var $c = convertToTensor(c, 'c', 'basicLSTMCell');
	  var $h = convertToTensor(h, 'h', 'basicLSTMCell');
	  var combined = concat([$data, $h], 1);
	  var weighted = matMul(combined, $lstmKernel);
	  var res = add$1(weighted, $lstmBias); // i = input_gate, j = new_input, f = forget_gate, o = output_gate

	  var batchSize = res.shape[0];
	  var sliceCols = res.shape[1] / 4;
	  var sliceSize = [batchSize, sliceCols];
	  var i = slice$2(res, [0, 0], sliceSize);
	  var j = slice$2(res, [0, sliceCols], sliceSize);
	  var f = slice$2(res, [0, sliceCols * 2], sliceSize);
	  var o = slice$2(res, [0, sliceCols * 3], sliceSize);
	  var newC = add$1(mul(sigmoid(i), tanh$1(j)), mul($c, sigmoid(add$1($forgetBias, f))));
	  var newH = mul(tanh$1(newC), sigmoid(o));
	  return [newC, newH];
	}

	var basicLSTMCell = op({
	  basicLSTMCell_: basicLSTMCell_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * This operation reshapes the "batch" dimension 0 into `M + 1` dimensions of
	 * shape `blockShape + [batch]`, interleaves these blocks back into the grid
	 * defined by the spatial dimensions `[1, ..., M]`, to obtain a result with
	 * the same rank as the input. The spatial dimensions of this intermediate
	 * result are then optionally cropped according to `crops` to produce the
	 * output. This is the reverse of `tf.spaceToBatchND`. See below for a precise
	 * description.
	 *
	 * ```js
	 * const x = tf.tensor4d([1, 2, 3, 4], [4, 1, 1, 1]);
	 * const blockShape = [2, 2];
	 * const crops = [[0, 0], [0, 0]];
	 *
	 * x.batchToSpaceND(blockShape, crops).print();
	 * ```
	 *
	 * @param x A `tf.Tensor`. N-D with `x.shape` = `[batch] + spatialShape +
	 * remainingShape`, where spatialShape has `M` dimensions.
	 * @param blockShape A 1-D array. Must have shape `[M]`, all values must
	 * be >= 1.
	 * @param crops A 2-D array.  Must have shape `[M, 2]`, all values must be >= 0.
	 * `crops[i] = [cropStart, cropEnd]` specifies the amount to crop from input
	 * dimension `i + 1`, which corresponds to spatial dimension `i`. It is required
	 * that `cropStart[i] + cropEnd[i] <= blockShape[i] * inputShape[i + 1]`
	 *
	 * This operation is equivalent to the following steps:
	 *
	 * 1. Reshape `x` to `reshaped` of shape: `[blockShape[0], ...,
	 * blockShape[M-1], batch / prod(blockShape), x.shape[1], ...,
	 * x.shape[N-1]]`
	 *
	 * 2. Permute dimensions of `reshaped`to produce `permuted` of shape `[batch /
	 * prod(blockShape),x.shape[1], blockShape[0], ..., x.shape[M],
	 * blockShape[M-1],x.shape[M+1], ..., x.shape[N-1]]`
	 *
	 * 3. Reshape `permuted` to produce `reshapedPermuted` of shape `[batch /
	 * prod(blockShape),x.shape[1] * blockShape[0], ..., x.shape[M] *
	 * blockShape[M-1],x.shape[M+1], ..., x.shape[N-1]]`
	 *
	 * 4. Crop the start and end of dimensions `[1, ..., M]` of `reshapedPermuted`
	 * according to `crops` to produce the output of shape: `[batch /
	 * prod(blockShape),x.shape[1] * blockShape[0] - crops[0,0] - crops[0,1],
	 * ..., x.shape[M] * blockShape[M-1] - crops[M-1,0] -
	 * crops[M-1,1],x.shape[M+1], ..., x.shape[N-1]]`
	 *
	 * @doc {heading: 'Tensors', subheading: 'Transformations'}
	 */

	function batchToSpaceND_(x, blockShape, crops) {
	  var $x = convertToTensor(x, 'x', 'batchToSpaceND');
	  var prod = blockShape.reduce(function (a, b) {
	    return a * b;
	  });
	  assert($x.rank >= 1 + blockShape.length, function () {
	    return "input rank is " + $x.rank + " but should be > than blockShape.length " + blockShape.length;
	  });
	  assert(crops.length === blockShape.length, function () {
	    return "crops.length is " + crops.length + " but should be equal to blockShape.length  " + blockShape.length;
	  });
	  assert($x.shape[0] % prod === 0, function () {
	    return "input tensor batch is " + $x.shape[0] + " but is not divisible by the product of " + ("the elements of blockShape " + blockShape.join(' * ') + " === " + prod);
	  });
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    blockShape: blockShape,
	    crops: crops
	  };
	  return ENGINE.runKernel(BatchToSpaceND, inputs, attrs);
	}

	var batchToSpaceND = op({
	  batchToSpaceND_: batchToSpaceND_
	});

	function xAs4D(x) {
	  var x4D;

	  if (x.rank === 0 || x.rank === 1) {
	    x4D = reshape(x, [1, 1, 1, x.size]);
	  } else if (x.rank === 2) {
	    x4D = reshape(x, [1, 1, x.shape[0], x.shape[1]]);
	  } else if (x.rank === 3) {
	    x4D = reshape(x, [1, x.shape[0], x.shape[1], x.shape[2]]);
	  } else {
	    x4D = x;
	  }

	  return x4D;
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Batch normalization.
	 *
	 * As described in
	 * [http://arxiv.org/abs/1502.03167](http://arxiv.org/abs/1502.03167).
	 *
	 * Mean, variance, scale, and offset can be of two shapes:
	 *   - The same shape as the input.
	 *   - In the common case, the depth dimension is the last dimension of x, so
	 *     the values would be an `tf.Tensor1D` of shape [depth].
	 *
	 * Also available are stricter rank-specific methods with the same signature
	 * as this method that assert that parameters passed are of given rank
	 *   - `tf.batchNorm2d`
	 *   - `tf.batchNorm3d`
	 *   - `tf.batchNorm4d`
	 *
	 * @param x The input Tensor.
	 * @param mean A mean Tensor.
	 * @param variance A variance Tensor.
	 * @param offset An offset Tensor.
	 * @param scale A scale Tensor.
	 * @param varianceEpsilon A small float number to avoid dividing by 0.
	 *
	 * @doc {heading: 'Operations', subheading: 'Normalization'}
	 */

	function batchNorm_(x, mean, variance, offset, scale, varianceEpsilon) {
	  if (varianceEpsilon == null) {
	    varianceEpsilon = 0.001;
	  }

	  var $x = convertToTensor(x, 'x', 'batchNorm');
	  var $mean = convertToTensor(mean, 'mean', 'batchNorm');
	  var $variance = convertToTensor(variance, 'variance', 'batchNorm');
	  var $scale;

	  if (scale != null) {
	    $scale = convertToTensor(scale, 'scale', 'batchNorm');
	  }

	  var $offset;

	  if (offset != null) {
	    $offset = convertToTensor(offset, 'offset', 'batchNorm');
	  }

	  assert($mean.rank === $variance.rank, function () {
	    return 'Batch normalization gradient requires mean and variance to have ' + 'equal ranks.';
	  });
	  assert($offset == null || $mean.rank === $offset.rank, function () {
	    return 'Batch normalization gradient requires mean and offset to have ' + 'equal ranks.';
	  });
	  assert($scale == null || $mean.rank === $scale.rank, function () {
	    return 'Batch normalization gradient requires mean and scale to have ' + 'equal ranks.';
	  });
	  var x4D = xAs4D($x);
	  var inputs = {
	    x: x4D,
	    scale: $scale,
	    offset: $offset,
	    mean: $mean,
	    variance: $variance
	  };
	  var attrs = {
	    varianceEpsilon: varianceEpsilon
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var res = ENGINE.runKernel(FusedBatchNorm, inputs, attrs);
	  return reshape(res, $x.shape);
	}

	var batchNorm = op({
	  batchNorm_: batchNorm_
	});

	/**
	 * Batch normalization, strictly for 2D. For the more relaxed version, see
	 * `tf.batchNorm`.
	 *
	 * @param x The input Tensor.
	 * @param mean A mean Tensor.
	 * @param variance A variance Tensor.
	 * @param offset An offset Tensor.
	 * @param scale A scale Tensor.
	 * @param varianceEpsilon A small float number to avoid dividing by 0.
	 */

	function batchNorm2d_(x, mean, variance, offset, scale, varianceEpsilon) {
	  var $x = convertToTensor(x, 'x', 'batchNorm');
	  var $mean = convertToTensor(mean, 'mean', 'batchNorm');
	  var $variance = convertToTensor(variance, 'variance', 'batchNorm');
	  var $scale;

	  if (scale != null) {
	    $scale = convertToTensor(scale, 'scale', 'batchNorm');
	  }

	  var $offset;

	  if (offset != null) {
	    $offset = convertToTensor(offset, 'offset', 'batchNorm');
	  }

	  assert($x.rank === 2, function () {
	    return "Error in batchNorm2D: x must be rank 2 but got rank " + ($x.rank + ".");
	  });
	  assert($mean.rank === 2 || $mean.rank === 1, function () {
	    return "Error in batchNorm2D: mean must be rank 2 or rank 1 but " + ("got rank " + $mean.rank + ".");
	  });
	  assert($variance.rank === 2 || $variance.rank === 1, function () {
	    return "Error in batchNorm2D: variance must be rank 2 or rank 1 " + ("but got rank " + $variance.rank + ".");
	  });

	  if ($scale != null) {
	    assert($scale.rank === 2 || $scale.rank === 1, function () {
	      return "Error in batchNorm2D: scale must be rank 2 or rank 1 " + ("but got rank " + $scale.rank + ".");
	    });
	  }

	  if ($offset != null) {
	    assert($offset.rank === 2 || $offset.rank === 1, function () {
	      return "Error in batchNorm2D: offset must be rank 2 or rank 1 " + ("but got rank " + $offset.rank + ".");
	    });
	  }

	  return batchNorm($x, $mean, $variance, $offset, $scale, varianceEpsilon);
	}

	var batchNorm2d = op({
	  batchNorm2d_: batchNorm2d_
	});

	/**
	 * Batch normalization, strictly for 3D. For the more relaxed version, see
	 * `tf.batchNorm`.
	 *
	 * @param x The input Tensor.
	 * @param mean A mean Tensor.
	 * @param variance A variance Tensor.
	 * @param offset An offset Tensor.
	 * @param scale A scale Tensor.
	 * @param varianceEpsilon A small float number to avoid dividing by 0.
	 */

	function batchNorm3d_(x, mean, variance, offset, scale, varianceEpsilon) {
	  var $x = convertToTensor(x, 'x', 'batchNorm');
	  var $mean = convertToTensor(mean, 'mean', 'batchNorm');
	  var $variance = convertToTensor(variance, 'variance', 'batchNorm');
	  var $scale;

	  if (scale != null) {
	    $scale = convertToTensor(scale, 'scale', 'batchNorm');
	  }

	  var $offset;

	  if (offset != null) {
	    $offset = convertToTensor(offset, 'offset', 'batchNorm');
	  }

	  assert($x.rank === 3, function () {
	    return "Error in batchNorm3D: x must be rank 3 but got rank " + ($x.rank + ".");
	  });
	  assert($mean.rank === 3 || $mean.rank === 1, function () {
	    return "Error in batchNorm3D: mean must be rank 3 or rank 1 but " + ("got rank " + $mean.rank + ".");
	  });
	  assert($variance.rank === 3 || $variance.rank === 1, function () {
	    return "Error in batchNorm3D: variance must be rank 3 or rank 1 " + ("but got rank " + $variance.rank + ".");
	  });

	  if ($scale != null) {
	    assert($scale.rank === 3 || $scale.rank === 1, function () {
	      return "Error in batchNorm3D: scale must be rank 3 or rank 1 " + ("but got rank " + $scale.rank + ".");
	    });
	  }

	  if ($offset != null) {
	    assert($offset.rank === 3 || $offset.rank === 1, function () {
	      return "Error in batchNorm3D: offset must be rank 3 or rank 1 " + ("but got rank " + $offset.rank + ".");
	    });
	  }

	  return batchNorm($x, $mean, $variance, $offset, $scale, varianceEpsilon);
	}

	var batchNorm3d = op({
	  batchNorm3d_: batchNorm3d_
	});

	/**
	 * Batch normalization, strictly for 4D. For the more relaxed version, see
	 * `tf.batchNorm`.
	 *
	 * @param x The input Tensor.
	 * @param mean A mean Tensor.
	 * @param variance A variance Tensor.
	 * @param offset An offset Tensor.
	 * @param scale A scale Tensor.
	 * @param varianceEpsilon A small float number to avoid dividing by 0.
	 */

	function batchNorm4d_(x, mean, variance, offset, scale, varianceEpsilon) {
	  var $x = convertToTensor(x, 'x', 'batchNorm');
	  var $mean = convertToTensor(mean, 'mean', 'batchNorm');
	  var $variance = convertToTensor(variance, 'variance', 'batchNorm');
	  var $scale;

	  if (scale != null) {
	    $scale = convertToTensor(scale, 'scale', 'batchNorm');
	  }

	  var $offset;

	  if (offset != null) {
	    $offset = convertToTensor(offset, 'offset', 'batchNorm');
	  }

	  assert($x.rank === 4, function () {
	    return "Error in batchNorm4D: x must be rank 4 but got rank " + ($x.rank + ".");
	  });
	  assert($mean.rank === 4 || $mean.rank === 1, function () {
	    return "Error in batchNorm4D: mean must be rank 4 or rank 1 but " + ("got rank " + $mean.rank + ".");
	  });
	  assert($variance.rank === 4 || $variance.rank === 1, function () {
	    return "Error in batchNorm4D: variance must be rank 4 or rank 1 " + ("but got rank " + $variance.rank + ".");
	  });

	  if ($scale != null) {
	    assert($scale.rank === 4 || $scale.rank === 1, function () {
	      return "Error in batchNorm4D: scale must be rank 4 or rank 1 " + ("but got rank " + $scale.rank + ".");
	    });
	  }

	  if ($offset != null) {
	    assert($offset.rank === 4 || $offset.rank === 1, function () {
	      return "Error in batchNorm4D: offset must be rank 4 or rank 1 " + ("but got rank " + $offset.rank + ".");
	    });
	  }

	  return batchNorm($x, $mean, $variance, $offset, $scale, varianceEpsilon);
	}

	var batchNorm4d = op({
	  batchNorm4d_: batchNorm4d_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Outputs a vector with length `size` and the same dtype as `weights`.
	 *
	 * If `weights` are empty, then index `i` stores the number of times the value
	 * `i` is counted in `x`. If `weights` are non-empty, then index `i` stores the
	 * sum of the value in `weights` at each index where the corresponding value in
	 * `x` is `i`.
	 *
	 * Values in `x` outside of the range [0, size) are ignored.
	 *
	 * @param x The input int tensor, rank 1.
	 * @param weights The weights tensor, must have the same shape as x, or a
	 *     length-0 Tensor, in which case it acts as all weights equal to 1.
	 * @param size Non-negative integer.
	 *
	 * @doc {heading: 'Operations', subheading: 'Reduction'}
	 */

	function bincount_(x, weights, size) {
	  var $x = convertToTensor(x, 'x', 'bincount');
	  var $weights = convertToTensor(weights, 'weights', 'bincount');
	  assert($x.dtype === 'int32', function () {
	    return "Error in bincount: input " + ("dtype must be int32, but got " + $x.dtype);
	  });
	  assert(size >= 0, function () {
	    return "size must be non-negative, but got " + size + ".";
	  });
	  assert($weights.size === $x.size || $weights.size === 0, function () {
	    return "Error in bincount: weights must have the same size as input or" + ("0-length, but got input shape: " + $x.shape + ", weights shape: ") + ($weights.shape + ".");
	  });
	  var inputs = {
	    x: $x,
	    weights: $weights
	  };
	  var attrs = {
	    size: size
	  };
	  return ENGINE.runKernel(Bincount, inputs, attrs);
	}

	var bincount = op({
	  bincount_: bincount_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Broadcast an array to a compatible shape NumPy-style.
	 *
	 * The tensor's shape is compared to the broadcast shape from end to beginning.
	 * Ones are prepended to the tensor's shape until is has the same length as
	 * the broadcast shape. If input.shape[i]==shape[i], the (i+1)-th axis is
	 * already broadcast-compatible. If input.shape[i]==1 and shape[i]==N, then
	 * the input tensor is tiled N times along that axis (using tf.tile).
	 *
	 * @param input The tensor that is to be broadcasted.
	 * @param shape The input is to be broadcast to this shape.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Transformations'}
	 */

	function broadcastTo_(x, shape) {
	  var input = convertToTensor(x, 'broadcastTo', 'x');
	  var xShape = input.shape;

	  if (shape.some(function (d) {
	    return !(d > 0) || d % 1 !== 0;
	  })) {
	    throw new Error("broadcastTo(): Invalid broadcast shape [" + shape + "].");
	  }

	  if (shape.length < input.rank) {
	    throw new Error("broadcastTo(): shape.length=" + shape.length + " < input.rank=" + input.rank + ".");
	  }

	  if (shape.length > input.rank) {
	    var newShape = input.shape.slice();

	    while (newShape.length < shape.length) {
	      newShape.unshift(1);
	    }

	    input = reshape(input, newShape);
	  }

	  var inputShape = input.shape;
	  var reps = Array.from(shape);

	  for (var i = shape.length - 1; i >= 0; i--) {
	    if (inputShape[i] === shape[i]) {
	      reps[i] = 1;
	    } else if (input.shape[i] !== 1) {
	      throw new Error("broadcastTo(): [" + xShape + "] cannot be broadcast to [" + shape + "].");
	    }
	  }

	  var axes = reps.map(function (n, i) {
	    return n > 1 ? i : -1;
	  }).filter(function (i) {
	    return i >= 0;
	  });

	  if (axes.length === 0) {
	    return clone(input);
	  } // TODO call broadcastTo kernel directly once backends implement broadcstTo


	  var inputs = {
	    x: input
	  };
	  var attrs = {
	    reps: reps
	  };
	  return ENGINE.runKernel(Tile, inputs, attrs);
	}

	var broadcastTo = op({
	  broadcastTo_: broadcastTo_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes ceiling of input `tf.Tensor` element-wise: `ceil(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([.6, 1.1, -3.3]);
	 *
	 * x.ceil().print();  // or tf.ceil(x)
	 * ```
	 * @param x The input Tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function ceil_(x) {
	  var $x = convertToTensor(x, 'x', 'ceil');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Ceil, inputs);
	}

	var ceil$3 = op({
	  ceil_: ceil_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Clips values element-wise. `max(min(x, clipValueMax), clipValueMin)`
	 *
	 * ```js
	 * const x = tf.tensor1d([-1, 2, -3, 4]);
	 *
	 * x.clipByValue(-2, 3).print();  // or tf.clipByValue(x, -2, 3)
	 * ```
	 * @param x The input tensor.
	 * @param clipValueMin Lower-bound of range to be clipped to.
	 * @param clipValueMax Upper-bound of range to be clipped to.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function clipByValue_(x, clipValueMin, clipValueMax) {
	  var $x = convertToTensor(x, 'x', 'clipByValue');
	  assert(clipValueMin <= clipValueMax, function () {
	    return "Error in clip: min (" + clipValueMin + ") must be " + ("less than or equal to max (" + clipValueMax + ").");
	  });
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    clipValueMin: clipValueMin,
	    clipValueMax: clipValueMax
	  };
	  return ENGINE.runKernel(ClipByValue, inputs, attrs);
	}

	var clipByValue = op({
	  clipByValue_: clipByValue_
	});

	/**
	 * Concatenates a list of`tf.Tensor1D`s along an axis. See `concat` for details.
	 *
	 * For example, if:
	 * A: shape(3) = |r1, g1, b1|
	 * B: shape(2) = |r2, g2|
	 * C = tf.concat1d([A, B]) == |r1, g1, b1, r2, g2|
	 *
	 * @param tensors A list of`tf.Tensor`s to concatenate.
	 * @return The concatenated array.
	 */

	function concat1d_(tensors) {
	  return concat(tensors, 0
	  /* axis */
	  );
	}

	var concat1d = op({
	  concat1d_: concat1d_
	});

	/**
	 * Concatenates a list of`tf.Tensor2D`s along an axis. See `concat` for details.
	 *
	 * For example, if:
	 * A: shape(2, 3) = | r1, g1, b1 |
	 *                  | r2, g2, b2 |
	 *
	 * B: shape(2, 3) = | r3, g3, b3 |
	 *                  | r4, g4, b4 |
	 *
	 * C = tf.concat2d([A, B], axis)
	 *
	 * if axis = 0:
	 * C: shape(4, 3) = | r1, g1, b1 |
	 *                  | r2, g2, b2 |
	 *                  | r3, g3, b3 |
	 *                  | r4, g4, b4 |
	 *
	 * if axis = 1:
	 * C = shape(2, 6) = | r1, g1, b1, r3, g3, b3 |
	 *                   | r2, g2, b2, r4, g4, b4 |
	 *
	 *
	 * @param tensors A list of `tf.Tensor`s to concatenate.
	 * @param axis The axis to concatenate along.
	 * @return The concatenated array.
	 */

	function concat2d_(tensors, axis) {
	  return concat(tensors, axis);
	}

	var concat2d = op({
	  concat2d_: concat2d_
	});

	/**
	 * Concatenates a list of `tf.Tensor3D`s along an axis.
	 * See `concat` for details.
	 *
	 * For example, if:
	 * A: shape(2, 1, 3) = | r1, g1, b1 |
	 *                     | r2, g2, b2 |
	 *
	 * B: shape(2, 1, 3) = | r3, g3, b3 |
	 *                     | r4, g4, b4 |
	 *
	 * C = tf.concat3d([A, B], axis)
	 *
	 * if axis = 0:
	 * C: shape(4, 1, 3) = | r1, g1, b1 |
	 *                     | r2, g2, b2 |
	 *                     | r3, g3, b3 |
	 *                     | r4, g4, b4 |
	 *
	 * if axis = 1:
	 * C: shape(2, 2, 3) = | r1, g1, b1, r3, g3, b3 |
	 *                     | r2, g2, b2, r4, g4, b4 |
	 *
	 * if axis = 2:
	 * C = shape(2, 1, 6) = | r1, g1, b1, r3, g3, b3 |
	 *                      | r2, g2, b2, r4, g4, b4 |
	 *
	 * @param tensors A list of`tf.Tensor`s to concatenate.
	 * @param axis The axis to concate along.
	 * @return The concatenated array.
	 */

	function concat3d_(tensors, axis) {
	  return concat(tensors, axis);
	}

	var concat3d = op({
	  concat3d_: concat3d_
	});

	/**
	 * Concatenates a list of `tf.Tensor4D`s along an axis.
	 * See `concat` for details.
	 *
	 * @param tensors A list of `tf.Tensor`s to concatenate.
	 * @param axis The axis to concate along.
	 * @return The concatenated array.
	 */

	function concat4d_(tensors, axis) {
	  return concat(tensors, axis);
	}

	var concat4d = op({
	  concat4d_: concat4d_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes a 2D convolution over the input x.
	 *
	 * @param x The input tensor, of rank 4 or rank 3, of shape
	 *     `[batch, height, width, inChannels]`. If rank 3, batch of 1 is
	 * assumed.
	 * @param filter The filter, rank 4, of shape
	 *     `[filterHeight, filterWidth, inDepth, outDepth]`.
	 * @param strides The strides of the convolution: `[strideHeight,
	 * strideWidth]`.
	 * @param pad The type of padding algorithm.
	 *    - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *    - `valid`: output will be smaller than input if filter is larger
	 *       than 1x1.
	 *   - For more info, see this guide:
	 *     [https://www.tensorflow.org/api_guides/python/nn#Convolution](
	 *          https://www.tensorflow.org/api_guides/python/nn#Convolution)
	 * @param dataFormat: An optional string from: "NHWC", "NCHW". Defaults to
	 *     "NHWC". Specify the data format of the input and output data. With the
	 *     default format "NHWC", the data is stored in the order of: [batch,
	 *     height, width, channels].
	 * @param dilations The dilation rates: `[dilationHeight, dilationWidth]`
	 *     in which we sample input values across the height and width dimensions
	 *     in atrous convolution. Defaults to `[1, 1]`. If `dilations` is a single
	 *     number, then `dilationHeight == dilationWidth`. If it is greater than
	 *     1, then all values of `strides` must be 1.
	 * @param dimRoundingMode A string from: 'ceil', 'round', 'floor'. If none is
	 *     provided, it will default to truncate.
	 *
	 * @doc {heading: 'Operations', subheading: 'Convolution'}
	 */

	function conv2d_(x, filter, strides, pad, dataFormat, dilations, dimRoundingMode) {
	  if (dataFormat === void 0) {
	    dataFormat = 'NHWC';
	  }

	  if (dilations === void 0) {
	    dilations = [1, 1];
	  }

	  var $x = convertToTensor(x, 'x', 'conv2d');
	  var $filter = convertToTensor(filter, 'filter', 'conv2d');
	  var x4D = $x;
	  var reshapedTo4D = false;

	  if ($x.rank === 3) {
	    reshapedTo4D = true;
	    x4D = reshape($x, [1, $x.shape[0], $x.shape[1], $x.shape[2]]);
	  }

	  assert(x4D.rank === 4, function () {
	    return "Error in conv2d: input must be rank 4, but got rank " + x4D.rank + ".";
	  });
	  assert($filter.rank === 4, function () {
	    return "Error in conv2d: filter must be rank 4, but got rank " + ($filter.rank + ".");
	  });

	  if (dimRoundingMode != null) {
	    assert(isInt(pad), function () {
	      return "Error in conv2d: pad must be an integer when using, " + ("dimRoundingMode " + dimRoundingMode + " but got pad " + pad + ".");
	    });
	  }

	  var inDepth = dataFormat === 'NHWC' ? x4D.shape[3] : x4D.shape[1];
	  assert(inDepth === $filter.shape[2], function () {
	    return "Error in conv2d: depth of input (" + inDepth + ") must match " + ("input depth for filter " + $filter.shape[2] + ".");
	  });
	  assert(eitherStridesOrDilationsAreOne(strides, dilations), function () {
	    return 'Error in conv2D: Either strides or dilations must be 1. ' + ("Got strides " + strides + " and dilations '" + dilations + "'");
	  });
	  var inputs = {
	    x: x4D,
	    filter: $filter
	  };
	  var attrs = {
	    strides: strides,
	    pad: pad,
	    dataFormat: dataFormat,
	    dilations: dilations,
	    dimRoundingMode: dimRoundingMode
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var res = ENGINE.runKernel(Conv2D, inputs, attrs);

	  if (reshapedTo4D) {
	    return reshape(res, [res.shape[1], res.shape[2], res.shape[3]]);
	  }

	  return res;
	}

	var conv2d = op({
	  conv2d_: conv2d_
	});

	/**
	 * Computes a 1D convolution over the input x.
	 *
	 * @param x The input tensor, of rank 3 or rank 2, of shape
	 *     `[batch, width, inChannels]`. If rank 2, batch of 1 is assumed.
	 * @param filter The filter, rank 3, of shape
	 *     `[filterWidth, inDepth, outDepth]`.
	 * @param stride The number of entries by which the filter is moved right at
	 *     each step.
	 * @param pad The type of padding algorithm.
	 *    - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *    - `valid`: output will be smaller than input if filter is larger
	 *       than 1x1.
	 *   - For more info, see this guide:
	 *     [https://www.tensorflow.org/api_guides/python/nn#Convolution](
	 *          https://www.tensorflow.org/api_guides/python/nn#Convolution)
	 * @param dataFormat An optional string from "NWC", "NCW". Defaults to "NWC",
	 *     the data is stored in the order of [batch, in_width, in_channels]. Only
	 *     "NWC" is currently supported.
	 * @param dilation The dilation rate in which we sample input values in
	 *     atrous convolution. Defaults to `1`. If it is greater than 1, then
	 *     stride must be `1`.
	 * @param dimRoundingMode A string from: 'ceil', 'round', 'floor'. If none is
	 *     provided, it will default to truncate.
	 *
	 * @doc {heading: 'Operations', subheading: 'Convolution'}
	 */

	function conv1d_(x, filter, stride, pad, dataFormat, dilation, dimRoundingMode) {
	  if (dataFormat === void 0) {
	    dataFormat = 'NWC';
	  }

	  if (dilation === void 0) {
	    dilation = 1;
	  }

	  var $x = convertToTensor(x, 'x', 'conv1d');
	  var $filter = convertToTensor(filter, 'filter', 'conv1d');
	  var x3D = $x;
	  var reshapedTo3D = false;

	  if ($x.rank === 2) {
	    reshapedTo3D = true;
	    x3D = reshape($x, [1, $x.shape[0], $x.shape[1]]);
	  }

	  assert(x3D.rank === 3, function () {
	    return "Error in conv1d: input must be rank 3, but got rank " + x3D.rank + ".";
	  });
	  assert($filter.rank === 3, function () {
	    return "Error in conv1d: filter must be rank 3, but got rank " + ($filter.rank + ".");
	  });

	  if (dimRoundingMode != null) {
	    assert(isInt(pad), function () {
	      return "Error in conv1d: pad must be an integer when using, " + ("dimRoundingMode " + dimRoundingMode + " but got pad " + pad + ".");
	    });
	  }

	  assert(x3D.shape[2] === $filter.shape[1], function () {
	    return "Error in conv1d: depth of input (" + x3D.shape[2] + ") must match " + ("input depth for filter " + $filter.shape[1] + ".");
	  });
	  assert(eitherStridesOrDilationsAreOne(stride, dilation), function () {
	    return 'Error in conv1D: Either stride or dilation must be 1. ' + ("Got stride " + stride + " and dilation '" + dilation + "'");
	  });
	  assert(dataFormat === 'NWC', function () {
	    return "Error in conv1d: got dataFormat of " + dataFormat + " but only NWC is currently supported.";
	  });
	  var filter4D = reshape($filter, [1, $filter.shape[0], $filter.shape[1], $filter.shape[2]]);
	  var input4D = reshape(x3D, [x3D.shape[0], 1, x3D.shape[1], x3D.shape[2]]);
	  var strides = [1, stride];
	  var dilations = [1, dilation];
	  var conv2dDataFormat = 'NHWC';
	  var res = conv2d(input4D, filter4D, strides, pad, conv2dDataFormat, dilations, dimRoundingMode);

	  if (reshapedTo3D) {
	    return reshape(res, [res.shape[2], res.shape[3]]);
	  }

	  return reshape(res, [res.shape[0], res.shape[2], res.shape[3]]);
	}

	var conv1d = op({
	  conv1d_: conv1d_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the derivative of the input of a 2D convolution.
	 *
	 * @param xShape The shape of the input: [batch, height, width, inDepth].
	 * If length of 3, batch of 1 is assumed.
	 * @param dy The derivative of the output, of rank 4 or rank 3 of shape
	 *   `[batch, outHeight, outWidth, outDepth]`. If rank 3, batch of 1 is
	 * assumed.
	 * @param filter The filter, rank 4, of shape
	 *     `[filterHeight, filterWidth, inDepth, outDepth]`.
	 * @param strides The strides of the convolution: `[strideHeight,
	 * strideWidth]`.
	 * @param pad The type of padding algorithm used:
	 *    - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *    - `valid`: output will be smaller than input if filter is larger
	 *       than 1x1.
	 * @param dataFormat: An optional string from: "NHWC", "NCHW". Defaults to
	 *     "NHWC". Specify the data format of the input and output data. With the
	 *     default format "NHWC", the data is stored in the order of: [batch,
	 *     height, width, channels].
	 * @param dimRoundingMode A string from: 'ceil', 'round', 'floor'. If none is
	 *     provided, it will default to truncate.
	 */

	function conv2DBackpropInput_(xShape, dy, filter, strides, pad, dataFormat, dimRoundingMode) {
	  if (dataFormat === void 0) {
	    dataFormat = 'NHWC';
	  }

	  assert(xShape.length === dy.rank, function () {
	    return "Length of inShape " + ("(" + xShape.length + ") and rank of dy (" + dy.rank + ") must match");
	  });
	  var xShape4D = xShape;
	  var dy4D = dy;
	  var reshapedTo4D = false;

	  if (dy.rank === 3) {
	    reshapedTo4D = true;
	    dy4D = reshape(dy, [1, dy.shape[0], dy.shape[1], dy.shape[2]]);
	    xShape4D = [1, xShape[0], xShape[1], xShape[2]];
	  }

	  assert(xShape4D.length === 4, function () {
	    return "Error in conv2dDerInput: inShape must be length 4, but got length " + (xShape4D.length + ".");
	  });
	  assert(dy4D.rank === 4, function () {
	    return "Error in conv2dDerInput: dy must be rank 4, but got " + ("rank " + dy4D.rank);
	  });
	  assert(filter.rank === 4, function () {
	    return "Error in conv2dDerInput: filter must be rank 4, but got " + ("rank " + filter.rank);
	  });
	  var inDepth = dataFormat === 'NHWC' ? xShape4D[3] : xShape4D[1];
	  var outDepth = dataFormat === 'NHWC' ? dy4D.shape[3] : dy4D.shape[1];
	  assert(inDepth === filter.shape[2], function () {
	    return "Error in conv2dDerInput: depth of input (" + inDepth + ") must " + ("match input depth for filter " + filter.shape[2] + ".");
	  });
	  assert(outDepth === filter.shape[3], function () {
	    return "Error in conv2dDerInput: depth of output (" + outDepth + ") must " + ("match output depth for filter " + filter.shape[3] + ".");
	  });

	  if (dimRoundingMode != null) {
	    assert(isInt(pad), function () {
	      return "Error in conv2dDerInput: pad must be an integer when using, " + ("dimRoundingMode " + dimRoundingMode + " but got pad " + pad + ".");
	    });
	  }

	  var inputs = {
	    dy: dy4D,
	    filter: filter
	  };
	  var attrs = {
	    strides: strides,
	    pad: pad,
	    dataFormat: dataFormat,
	    dimRoundingMode: dimRoundingMode,
	    inputShape: xShape4D
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var res = ENGINE.runKernel(Conv2DBackpropInput, inputs, attrs);

	  if (reshapedTo4D) {
	    return reshape(res, [res.shape[1], res.shape[2], res.shape[3]]);
	  }

	  return res;
	}

	var conv2DBackpropInput = op({
	  conv2DBackpropInput_: conv2DBackpropInput_
	});

	/**
	 * Computes the transposed 2D convolution of an image, also known as a
	 * deconvolution.
	 *
	 * @param x The input image, of rank 4 or rank 3, of shape
	 *   `[batch, height, width, inDepth]`. If rank 3, batch of 1 is assumed.
	 * @param filter The filter, rank 4, of shape
	 *     `[filterHeight, filterWidth, outDepth, inDepth]`.
	 *     `inDepth` must match `inDepth` in `x`.
	 * @param outputShape Output shape, of rank 4 or rank 3:
	 *     `[batch, height, width, outDepth]`. If rank 3, batch of 1 is assumed.
	 * @param strides The strides of the original convolution:
	 *     `[strideHeight, strideWidth]`.
	 * @param pad  The type of padding algorithm used in the non-transpose version
	 *    of the op.
	 * @param dimRoundingMode A string from: 'ceil', 'round', 'floor'. If none is
	 *     provided, it will default to truncate.
	 *
	 * @doc {heading: 'Operations', subheading: 'Convolution'}
	 */

	function conv2dTranspose_(x, filter, outputShape, strides, pad, dimRoundingMode) {
	  var $x = convertToTensor(x, 'x', 'conv2dTranspose');
	  var $filter = convertToTensor(filter, 'filter', 'conv2dTranspose');
	  return conv2DBackpropInput(outputShape, $x, $filter, strides, pad, 'NHWC', dimRoundingMode);
	}

	var conv2dTranspose = op({
	  conv2dTranspose_: conv2dTranspose_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes a 3D convolution over the input x.
	 *
	 * @param x The input tensor, of rank 5 or rank 4, of shape
	 *     `[batch, depth, height, width, channels]`. If rank 4,
	 * batch of 1 is assumed.
	 * @param filter The filter, rank 5, of shape
	 *     `[filterDepth, filterHeight, filterWidth, inChannels, outChannels]`.
	 *      inChannels must match between input and filter.
	 * @param strides The strides of the convolution: `[strideDepth, strideHeight,
	 * strideWidth]`.
	 * @param pad The type of padding algorithm.
	 *    - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *    - `valid`: output will be smaller than input if filter is larger
	 *       than 1x1.
	 *   - For more info, see this guide:
	 *     [https://www.tensorflow.org/api_guides/python/nn#Convolution](
	 *          https://www.tensorflow.org/api_guides/python/nn#Convolution)
	 * @param dataFormat: An optional string from: "NDHWC", "NCDHW". Defaults to
	 *     "NDHWC". Specify the data format of the input and output data. With the
	 *     default format "NDHWC", the data is stored in the order of: [batch,
	 *     depth, height, width, channels]. Only "NDHWC" is currently supported.
	 * @param dilations The dilation rates: `[dilationDepth, dilationHeight,
	 *     dilationWidth]` in which we sample input values across the height
	 *     and width dimensions in atrous convolution. Defaults to `[1, 1, 1]`.
	 *     If `dilations` is a single number, then
	 *     `dilationDepth == dilationHeight == dilationWidth`. If it is greater
	 *     than 1, then all values of `strides` must be 1.
	 *
	 * @doc {heading: 'Operations', subheading: 'Convolution'}
	 */

	function conv3d_(x, filter, strides, pad, dataFormat, dilations) {
	  if (dataFormat === void 0) {
	    dataFormat = 'NDHWC';
	  }

	  if (dilations === void 0) {
	    dilations = [1, 1, 1];
	  }

	  var $x = convertToTensor(x, 'x', 'conv3d');
	  var $filter = convertToTensor(filter, 'filter', 'conv3d');
	  var x5D = $x;
	  var reshapedTo5D = false;

	  if ($x.rank === 4) {
	    reshapedTo5D = true;
	    x5D = reshape($x, [1, $x.shape[0], $x.shape[1], $x.shape[2], $x.shape[3]]);
	  }

	  assert(x5D.rank === 5, function () {
	    return "Error in conv3d: input must be rank 5, but got rank " + x5D.rank + ".";
	  });
	  assert($filter.rank === 5, function () {
	    return "Error in conv3d: filter must be rank 5, but got rank " + ($filter.rank + ".");
	  });
	  assert(x5D.shape[4] === $filter.shape[3], function () {
	    return "Error in conv3d: depth of input (" + x5D.shape[4] + ") must match " + ("input depth for filter " + $filter.shape[3] + ".");
	  });
	  assert(eitherStridesOrDilationsAreOne(strides, dilations), function () {
	    return 'Error in conv3D: Either strides or dilations must be 1. ' + ("Got strides " + strides + " and dilations '" + dilations + "'");
	  });
	  assert(dataFormat === 'NDHWC', function () {
	    return "Error in conv3d: got dataFormat of " + dataFormat + " but only NDHWC is currently supported.";
	  });
	  var inputs = {
	    x: x5D,
	    filter: $filter
	  };
	  var attrs = {
	    strides: strides,
	    pad: pad,
	    dataFormat: dataFormat,
	    dilations: dilations
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var res = ENGINE.runKernel(Conv3D, inputs, attrs);

	  if (reshapedTo5D) {
	    return reshape(res, [res.shape[1], res.shape[2], res.shape[3], res.shape[4]]);
	  }

	  return res;
	}

	var conv3d = op({
	  conv3d_: conv3d_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the derivative of the input of a 3D convolution.
	 *
	 * @param xShape The shape of the input: [batch, depth, height, width,
	 * in_channels]. If length of 4, batch of 1 is assumed.
	 * @param dy The derivative of the output, of rank 5 or rank 4 of shape
	 *   `[batch, outDepth, outHeight, outWidth, in_channels]`.
	 * If rank 4, batch of 1 is assumed.
	 * @param filter The filter, rank 5, of shape
	 *     `[filterDepth, filterHeight, filterWidth, inDepth, outDepth]`.
	 * @param strides The strides of the convolution: `[strideDepth, strideHeight,
	 * strideWidth]`.
	 * @param pad The type of padding algorithm used:
	 *    - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *    - `valid`: output will be smaller than input if filter is larger
	 *       than 1x1.
	 */

	function conv3DBackpropInput_(xShape, dy, filter, strides, pad) {
	  assert(xShape.length === dy.rank, function () {
	    return "Length of inShape " + ("(" + xShape.length + ") and rank of dy (" + dy.rank + ") must match");
	  });
	  var xShape5D = xShape;
	  var dy5D = dy;
	  var reshapedTo5D = false;

	  if (dy.rank === 4) {
	    reshapedTo5D = true;
	    dy5D = reshape(dy, [1, dy.shape[0], dy.shape[1], dy.shape[2], dy.shape[3]]);
	    xShape5D = [1, xShape[0], xShape[1], xShape[2], xShape[3]];
	  }

	  var inDepth = xShape5D[4];
	  var outDepth = dy5D.shape[4];
	  assert(xShape5D.length === 5, function () {
	    return "Error in conv3dDerInput: inShape must be length 5, but got length " + (xShape5D.length + ".");
	  });
	  assert(dy5D.rank === 5, function () {
	    return "Error in conv3dDerInput: dy must be rank 5, but got " + ("rank " + dy5D.rank);
	  });
	  assert(filter.rank === 5, function () {
	    return "Error in conv3dDerInput: filter must be rank 5, but got " + ("rank " + filter.rank);
	  });
	  assert(inDepth === filter.shape[3], function () {
	    return "Error in conv3dDerInput: depth of input (" + inDepth + ") must " + ("match input depth for filter " + filter.shape[3] + ".");
	  });
	  assert(outDepth === filter.shape[4], function () {
	    return "Error in conv3dDerInput: depth of output (" + outDepth + ") must " + ("match output depth for filter " + filter.shape[4] + ".");
	  });
	  var inputs = {
	    dy: dy5D,
	    filter: filter
	  };
	  var attrs = {
	    pad: pad,
	    strides: strides,
	    inputShape: xShape5D
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var res = ENGINE.runKernel(Conv3DBackpropInputV2, inputs, attrs);

	  if (reshapedTo5D) {
	    return reshape(res, [res.shape[1], res.shape[2], res.shape[3], res.shape[4]]);
	  }

	  return res;
	}

	var conv3DBackpropInput = op({
	  conv3DBackpropInput_: conv3DBackpropInput_
	});

	/**
	 * Computes the transposed 3D convolution of a volume, also known as a
	 * deconvolution.
	 *
	 * @param x The input image, of rank 5 or rank 4, of shape
	 *   `[batch, depth, height, width, inDepth]`. If rank 4, batch of 1 is assumed.
	 * @param filter The filter, rank 4, of shape
	 *     `[depth, filterHeight, filterWidth, outDepth, inDepth]`.
	 *     `inDepth` must match `inDepth` in `x`.
	 * @param outputShape Output shape, of rank 5 or rank 4:
	 *     `[batch, depth, height, width, outDepth]`. If rank 3, batch of 1 is
	 *    assumed.
	 * @param strides The strides of the original convolution:
	 *     `[strideDepth, strideHeight, strideWidth]`.
	 * @param pad  The type of padding algorithm used in the non-transpose version
	 *    of the op.
	 *
	 * @doc {heading: 'Operations', subheading: 'Convolution'}
	 */

	function conv3dTranspose_(x, filter, outputShape, strides, pad) {
	  var $x = convertToTensor(x, 'x', 'conv3dTranspose');
	  var $filter = convertToTensor(filter, 'filter', 'conv3dTranspose');
	  return conv3DBackpropInput(outputShape, $x, $filter, strides, pad);
	}

	var conv3dTranspose = op({
	  conv3dTranspose_: conv3dTranspose_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes cos of the input `tf.Tensor` element-wise: `cos(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([0, Math.PI / 2, Math.PI * 3 / 4]);
	 *
	 * x.cos().print();  // or tf.cos(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function cos_(x) {
	  var $x = convertToTensor(x, 'x', 'cos');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Cos, inputs);
	}

	var cos = op({
	  cos_: cos_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes hyperbolic cos of the input `tf.Tensor` element-wise: `cosh(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([0, 1, -1, .7]);
	 *
	 * x.cosh().print();  // or tf.cosh(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function cosh_(x) {
	  var $x = convertToTensor(x, 'x', 'cosh');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Cosh, inputs);
	}

	var cosh = op({
	  cosh_: cosh_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the cumulative sum of a `tf.Tensor` along `axis`.
	 *
	 * ```js
	 * const x = tf.tensor([1, 2, 3, 4]);
	 * x.cumsum().print();
	 * ```
	 * ```js
	 * const x = tf.tensor([[1, 2], [3, 4]]);
	 * x.cumsum().print();
	 * ```
	 *
	 * @param x The input tensor to be summed.
	 * @param axis The axis along which to sum. Optional. Defaults to 0.
	 * @param exclusive Whether to perform exclusive cumulative sum. Optional.
	 *     Defaults to false. If set to true then the sum of each tensor entry
	 *     does not include its own value, but only the values previous to it
	 *     along the specified axis.
	 * @param reverse Whether to sum in the opposite direction. Optional.
	 *     Defaults to false.
	 *
	 * @doc {heading: 'Operations', subheading: 'Scan'}
	 */

	function cumsum_(x, axis, exclusive, reverse) {
	  if (axis === void 0) {
	    axis = 0;
	  }

	  if (exclusive === void 0) {
	    exclusive = false;
	  }

	  if (reverse === void 0) {
	    reverse = false;
	  }

	  var $x = convertToTensor(x, 'x', 'cumsum');
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    axis: axis,
	    exclusive: exclusive,
	    reverse: reverse
	  };
	  return ENGINE.runKernel(Cumsum, inputs, attrs);
	}

	var cumsum = op({
	  cumsum_: cumsum_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Outputs a vector with length `size` and the same dtype as `weights`.
	 *
	 * If `weights` are empty, then index `i` stores the number of times the value
	 * `i` is counted in `x`. If `weights` are non-empty, then index `i` stores the
	 * sum of the value in `weights` at each index where the corresponding value in
	 * `x` is `i`.
	 *
	 * Values in `x` outside of the range [0, size) are ignored.
	 *
	 * @param x The input int tensor, rank 1 or rank 2.
	 * @param weights The weights tensor, must have the same shape as x, or a
	 *     length-0 Tensor, in which case it acts as all weights equal to 1.
	 * @param size Non-negative integer.
	 * @param binaryOutput Optional. Whether the kernel should count the appearance
	 *     or number of occurrences. Defaults to False.
	 *
	 * @doc {heading: 'Operations', subheading: 'Reduction'}
	 */

	function denseBincount_(x, weights, size, binaryOutput) {
	  if (binaryOutput === void 0) {
	    binaryOutput = false;
	  }

	  var $x = convertToTensor(x, 'x', 'denseBincount');
	  var $weights = convertToTensor(weights, 'weights', 'denseBincount');
	  assert($x.dtype === 'int32', function () {
	    return "Error in denseBincount: input " + ("dtype must be int32, but got " + $x.dtype);
	  });
	  assert($x.rank <= 2, function () {
	    return "Error in denseBincount: input must be at most rank 2, but got " + ("rank " + $x.rank + ".");
	  });
	  assert(size >= 0, function () {
	    return "size must be non-negative, but got " + size + ".";
	  });
	  assert($weights.size === $x.size || $weights.size === 0, function () {
	    return "Error in denseBincount: weights must have the same shape as x or " + ("0-length, but got x shape: " + $x.shape + ", weights shape: ") + ($weights.shape + ".");
	  });
	  var inputs = {
	    x: $x,
	    weights: $weights
	  };
	  var attrs = {
	    size: size,
	    binaryOutput: binaryOutput
	  };
	  return ENGINE.runKernel(DenseBincount, inputs, attrs);
	}

	var denseBincount = op({
	  denseBincount_: denseBincount_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Rearranges data from depth into blocks of spatial data. More specifically,
	 * this op outputs a copy of the input tensor where values from the `depth`
	 * dimension are moved in spatial blocks to the `height` and `width` dimensions.
	 * The attr `blockSize` indicates the input block size and how the data is
	 * moved.
	 *
	 *  - Chunks of data of size `blockSize * blockSize` from depth are rearranged
	 * into non-overlapping blocks of size `blockSize x blockSize`
	 *
	 *  - The width the output tensor is `inputWidth * blockSize`, whereas the
	 * height is `inputHeight * blockSize`
	 *
	 *  - The Y, X coordinates within each block of the output image are determined
	 * by the high order component of the input channel index
	 *
	 *  - The depth of the input tensor must be divisible by `blockSize *
	 * blockSize`
	 *
	 * The `dataFormat` attr specifies the layout of the input and output tensors
	 * with the following options: "NHWC": [ `batch, height, width, channels` ]
	 * "NCHW": [ `batch, channels, height, width` ]
	 *
	 * ```js
	 * const x = tf.tensor4d([1, 2, 3, 4], [1, 1, 1, 4]);
	 * const blockSize = 2;
	 * const dataFormat = "NHWC";
	 *
	 * tf.depthToSpace(x, blockSize, dataFormat).print();
	 * ```
	 *
	 * @param x The input tensor of rank 4
	 * @param blockSIze  An `int` that is `>= 2`. The size of the spatial block
	 * @param dataFormat An optional string from: "NHWC", "NCHW". Defaults to "NHWC"
	 *
	 * @doc {heading: 'Tensors', subheading: 'Transformations'}
	 */

	function depthToSpace_(x, blockSize, dataFormat) {
	  if (dataFormat === void 0) {
	    dataFormat = 'NHWC';
	  }

	  var $x = convertToTensor(x, 'x', 'depthToSpace');
	  var inputHeight = dataFormat === 'NHWC' ? $x.shape[1] : $x.shape[2];
	  var inputWidth = dataFormat === 'NHWC' ? $x.shape[2] : $x.shape[3];
	  var inputDepth = dataFormat === 'NHWC' ? $x.shape[3] : $x.shape[1];
	  assert(inputHeight * blockSize >= 0, function () {
	    return "Negative dimension size caused by overflow when multiplying\n    " + inputHeight + " and " + blockSize + "  for depthToSpace with input shape\n    " + $x.shape;
	  });
	  assert(inputWidth * blockSize >= 0, function () {
	    return "Negative dimension size caused by overflow when multiplying\n    " + inputWidth + " and " + blockSize + " for depthToSpace with input shape\n        " + $x.shape;
	  });
	  assert(inputDepth % (blockSize * blockSize) === 0, function () {
	    return "Dimension size must be evenly divisible by " + blockSize * blockSize + " but is " + inputDepth + " for depthToSpace with input shape " + $x.shape;
	  });
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    blockSize: blockSize,
	    dataFormat: dataFormat
	  };
	  return ENGINE.runKernel(DepthToSpace, inputs, attrs);
	}

	var depthToSpace = op({
	  depthToSpace_: depthToSpace_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Depthwise 2D convolution.
	 *
	 * Given a 4D `input` array and a `filter` array of shape
	 * `[filterHeight, filterWidth, inChannels, channelMultiplier]` containing
	 * `inChannels` convolutional filters of depth 1, this op applies a
	 * different filter to each input channel (expanding from 1 channel to
	 * `channelMultiplier` channels for each), then concatenates the results
	 * together. The output has `inChannels * channelMultiplier` channels.
	 *
	 * See
	 * [https://www.tensorflow.org/api_docs/python/tf/nn/depthwise_conv2d](
	 *     https://www.tensorflow.org/api_docs/python/tf/nn/depthwise_conv2d)
	 * for more details.
	 *
	 * @param x The input tensor, of rank 4 or rank 3, of shape
	 *     `[batch, height, width, inChannels]`. If rank 3, batch of 1 is
	 * assumed.
	 * @param filter The filter tensor, rank 4, of shape
	 *     `[filterHeight, filterWidth, inChannels, channelMultiplier]`.
	 * @param strides The strides of the convolution: `[strideHeight,
	 * strideWidth]`. If strides is a single number, then `strideHeight ==
	 * strideWidth`.
	 * @param pad The type of padding algorithm.
	 *   - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *   - `valid`: output will be smaller than input if filter is larger
	 *       than 1x1.
	 *   - For more info, see this guide:
	 *     [https://www.tensorflow.org/api_guides/python/nn#Convolution](
	 *          https://www.tensorflow.org/api_guides/python/nn#Convolution)
	 * @param dilations The dilation rates: `[dilationHeight, dilationWidth]`
	 *     in which we sample input values across the height and width dimensions
	 *     in atrous convolution. Defaults to `[1, 1]`. If `rate` is a single
	 *     number, then `dilationHeight == dilationWidth`. If it is greater than
	 *     1, then all values of `strides` must be 1.
	 * @param dataFormat: An optional string from: "NHWC", "NCHW". Defaults to
	 *     "NHWC". Specify the data format of the input and output data. With the
	 *     default format "NHWC", the data is stored in the order of: [batch,
	 *     height, width, channels]. Only "NHWC" is currently supported.
	 * @param dimRoundingMode A string from: 'ceil', 'round', 'floor'. If none is
	 *     provided, it will default to truncate.
	 *
	 * @doc {heading: 'Operations', subheading: 'Convolution'}
	 */

	function depthwiseConv2d_(x, filter, strides, pad, dataFormat, dilations, dimRoundingMode) {
	  if (dataFormat === void 0) {
	    dataFormat = 'NHWC';
	  }

	  if (dilations === void 0) {
	    dilations = [1, 1];
	  }

	  var $x = convertToTensor(x, 'x', 'depthwiseConv2d');
	  var $filter = convertToTensor(filter, 'filter', 'depthwiseConv2d');
	  var x4D = $x;
	  var reshapedTo4D = false;

	  if ($x.rank === 3) {
	    reshapedTo4D = true;
	    x4D = reshape($x, [1, $x.shape[0], $x.shape[1], $x.shape[2]]);
	  }

	  assert(x4D.rank === 4, function () {
	    return "Error in depthwiseConv2d: input must be rank 4, but got " + ("rank " + x4D.rank + ".");
	  });
	  assert($filter.rank === 4, function () {
	    return "Error in depthwiseConv2d: filter must be rank 4, but got rank " + ($filter.rank + ".");
	  });
	  assert(x4D.shape[3] === $filter.shape[2], function () {
	    return "Error in depthwiseConv2d: number of input channels " + ("(" + x4D.shape[3] + ") must match the inChannels dimension in ") + ("filter " + $filter.shape[2] + ".");
	  });

	  if (dimRoundingMode != null) {
	    assert(isInt(pad), function () {
	      return "Error in depthwiseConv2d: pad must be an integer when using, " + ("dimRoundingMode " + dimRoundingMode + " but got pad " + pad + ".");
	    });
	  }

	  var inputs = {
	    x: x4D,
	    filter: $filter
	  };
	  var attrs = {
	    strides: strides,
	    pad: pad,
	    dataFormat: dataFormat,
	    dilations: dilations,
	    dimRoundingMode: dimRoundingMode
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var res = ENGINE.runKernel(DepthwiseConv2dNative, inputs, attrs);

	  if (reshapedTo4D) {
	    return reshape(res, [res.shape[1], res.shape[2], res.shape[3]]);
	  }

	  return res;
	}

	var depthwiseConv2d = op({
	  depthwiseConv2d_: depthwiseConv2d_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns a diagonal tensor with a given diagonal values.
	 *
	 * Given a diagonal, this operation returns a tensor with the diagonal and
	 * everything else padded with zeros.
	 *
	 * Assume the input has dimensions `[D1,..., Dk]`, then the output is a tensor
	 * of rank 2k with dimensions `[D1,..., Dk, D1,..., Dk]`
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3, 4]);
	 *
	 * tf.diag(x).print()
	 * ```
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3, 4, 5, 6, 6, 8], [4, 2])
	 *
	 * tf.diag(x).print()
	 * ```
	 * @param x The input tensor.
	 */

	function diag_(x) {
	  var $x = convertToTensor(x, 'x', 'diag');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Diag, inputs);
	}

	var diag = op({
	  diag_: diag_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the grayscale dilation over the input `x`.
	 *
	 * @param x The input tensor, rank 3 or rank 4 of shape
	 *     `[batch, height, width, inChannels]`. If rank 3, batch of 1 is assumed.
	 * @param filter The filter tensor, rank 3, of shape
	 *     `[filterHeight, filterWidth, depth]`.
	 * @param strides The strides of the sliding window for each dimension of the
	 *     input tensor: `[strideHeight, strideWidth]`.
	 *     If `strides` is a single number,
	 *     then `strideHeight == strideWidth`.
	 * @param pad The type of padding algorithm.
	 *    - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *    - `valid`: output will be smaller than input if filter is larger
	 *       than 1*1x1.
	 *    - For more info, see this guide:
	 *     [https://www.tensorflow.org/api_guides/python/nn#Convolution](
	 *          https://www.tensorflow.org/api_guides/python/nn#Convolution)
	 * @param dataFormat Specify the data format of the input and output data.
	 *      Defaults to 'NHWC'. Only 'NHWC' is currently supported. With the
	 *      default format "NHWC", the data is stored in the order of: [batch,
	 *      height, width, channels].
	 * @param dilations The dilation rates: `[dilationHeight, dilationWidth]`
	 *     in which we sample input values across the height and width dimensions
	 *     for atrous morphological dilation. Defaults to `[1, 1]`. If `dilations`
	 *     is a single number, then `dilationHeight == dilationWidth`. If it is
	 *     greater than 1, then all values of `strides` must be 1.
	 *
	 * @doc {heading: 'Operations', subheading: 'Convolution'}
	 */

	function dilation2d_(x, filter, strides, pad, dilations, dataFormat) {
	  if (dilations === void 0) {
	    dilations = [1, 1];
	  }

	  if (dataFormat === void 0) {
	    dataFormat = 'NHWC';
	  }

	  var $x = convertToTensor(x, 'x', 'dilation2d');
	  var $filter = convertToTensor(filter, 'filter', 'dilation2d');
	  assert($x.rank === 3 || $x.rank === 4, function () {
	    return "Error in dilation2d: input must be rank 3 or 4, but got rank " + ($x.rank + ".");
	  });
	  assert($filter.rank === 3, function () {
	    return "Error in dilation2d: filter must be rank 3, but got rank " + ($filter.rank + ".");
	  });
	  assert(dataFormat === 'NHWC', function () {
	    return "Error in dilation2d: Only NHWC is currently supported, " + ("but got dataFormat of " + dataFormat);
	  });
	  var x4D = $x;
	  var reshapedTo4D = false;

	  if ($x.rank === 3) {
	    x4D = reshape($x, [1, $x.shape[0], $x.shape[1], $x.shape[2]]);
	    reshapedTo4D = true;
	  }

	  var inputs = {
	    x: x4D,
	    filter: $filter
	  };
	  var attrs = {
	    strides: strides,
	    pad: pad,
	    dilations: dilations
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var res = ENGINE.runKernel(Dilation2D, inputs, attrs);

	  if (reshapedTo4D) {
	    return reshape(res, [res.shape[1], res.shape[2], res.shape[3]]);
	  }

	  return res;
	}

	var dilation2d = op({
	  dilation2d_: dilation2d_
	});

	/**
	 * @license
	 * Copyright 2017 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */

	/**
	 * Returns the dimensions in the input shape that are broadcasted to
	 * produce the provided output shape.
	 *
	 * The returned dimensions are 0-indexed and sorted. An example:
	 * inShape = [4, 1, 3]
	 * outShape = [5, 4, 3, 3]
	 * result = [1]. Dimension 1 (2nd dimension of input) gets broadcasted 1 => 3.
	 */
	function getBroadcastDims(inShape, outShape) {
	  var inRank = inShape.length;
	  var dims = [];

	  for (var i = 0; i < inRank; i++) {
	    var dim = inRank - 1 - i;
	    var a = inShape[dim] || 1;
	    var b = outShape[outShape.length - 1 - i] || 1;

	    if (b > 1 && a === 1) {
	      dims.unshift(dim);
	    }
	  }

	  return dims;
	}
	/**
	 * Returns the axes in the output space that should be reduced to produce
	 * the input space.
	 */

	function getReductionAxes(inShape, outShape) {
	  var result = [];

	  for (var i = 0; i < outShape.length; i++) {
	    var inDim = inShape[inShape.length - i - 1];
	    var outAxis = outShape.length - i - 1;
	    var outDim = outShape[outAxis];

	    if (inDim == null || inDim === 1 && outDim > 1) {
	      result.unshift(outAxis);
	    }
	  }

	  return result;
	}
	function assertAndGetBroadcastShape(shapeA, shapeB) {
	  var result = [];
	  var l = Math.max(shapeA.length, shapeB.length);

	  for (var i = 0; i < l; i++) {
	    var a = shapeA[shapeA.length - i - 1];

	    if (a == null) {
	      a = 1;
	    }

	    var b = shapeB[shapeB.length - i - 1];

	    if (b == null) {
	      b = 1;
	    }

	    if (a === 1) {
	      result.unshift(b);
	    } else if (b === 1) {
	      result.unshift(a);
	    } else if (a !== b) {
	      var errMsg = "Operands could not be broadcast together with shapes " + (shapeA + " and " + shapeB + ".");
	      throw Error(errMsg);
	    } else {
	      result.unshift(a);
	    }
	  }

	  return result;
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the truth value of (a == b) element-wise. Supports broadcasting.
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2, 3]);
	 * const b = tf.tensor1d([2, 2, 2]);
	 *
	 * a.equal(b).print();
	 * ```
	 *
	 * @param a The first input tensor.
	 * @param b The second input tensor. Must have the same dtype as `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Logical'}
	 */

	function equal_(a, b) {
	  var $a = convertToTensor(a, 'a', 'equal');
	  var $b = convertToTensor(b, 'b', 'equal');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  assertAndGetBroadcastShape($a.shape, $b.shape);
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(Equal, inputs);
	}

	var equal = op({
	  equal_: equal_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the elements, either `a` or `b` depending on the `condition`.
	 *
	 * If the condition is true, select from `a`, otherwise select from `b`.
	 *
	 * ```js
	 * const cond = tf.tensor1d([false, false, true], 'bool');
	 * const a = tf.tensor1d([1 , 2, 3]);
	 * const b = tf.tensor1d([-1, -2, -3]);
	 *
	 * a.where(cond, b).print();
	 * ```
	 *
	 * @param condition The input condition. Must be of dtype bool.
	 * @param a If `condition` is rank 1, `a` may have a higher rank but
	 *     its first dimension must match the size of `condition`.
	 * @param b A tensor with the same dtype as `a` and with shape that is
	 *     compatible with `a`.
	 * @return A tensor with same dtype as `a` and `b`, and shape that is
	 *     broadcastable from `a` and `b`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Logical'}
	 */

	function where_(condition, a, b) {
	  var $a = convertToTensor(a, 'a', 'where');
	  var $b = convertToTensor(b, 'b', 'where');
	  var $condition = convertToTensor(condition, 'condition', 'where', 'bool'); // TODO: move this logic to forward function when the broadcastTo op is
	  // implemented in WASM.
	  // Find the broadcastable shape for $a and $b.

	  var broadcastShape = assertAndGetBroadcastShape($a.shape, $b.shape);
	  var $broadcastedA = broadcastTo($a, broadcastShape);
	  var $broadcastedB = broadcastTo($b, broadcastShape);

	  if ($condition.rank === 1) {
	    // If condition rank is 1, then the first dimension must match the size of
	    // condition.
	    assert($condition.shape[0] === $a.shape[0], function () {
	      return 'The first dimension of `a` must match the size of `condition`.';
	    });
	  }

	  if ($condition.rank !== 1) {
	    // A must have the same shape as condition.
	    assertShapesMatch($condition.shape, $broadcastedB.shape, 'Error in where: ');
	  }

	  var inputs = {
	    condition: $condition,
	    t: $broadcastedA,
	    e: $broadcastedB
	  };
	  return ENGINE.runKernel(Select, inputs);
	}

	var where = op({
	  where_: where_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Creates a `tf.Tensor` with all elements set to 0 with the same shape as the
	 * given tensor.
	 *
	 * ```js
	 * const x = tf.tensor([1, 2]);
	 * tf.zerosLike(x).print();
	 * ```
	 *
	 * @param x The tensor of required shape.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */

	function zerosLike_(x) {
	  var $x = convertToTensor(x, 'x', 'zerosLike');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(ZerosLike, inputs);
	}

	var zerosLike = op({
	  zerosLike_: zerosLike_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Divides two `tf.Tensor`s element-wise, A / B. Supports broadcasting. Return 0
	 * if denominator is 0.
	 *
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 4, 9, 16]);
	 * const b = tf.tensor1d([1, 2, 3, 4]);
	 * const c = tf.tensor1d([0, 0, 0, 0]);
	 *
	 * a.divNoNan(b).print();  // or tf.divNoNan(a, b)
	 * a.divNoNan(c).print();  // or tf.divNoNan(a, c)
	 * ```
	 *
	 * ```js
	 * // Broadcast div a with b.
	 * const a = tf.tensor1d([2, 4, 6, 8]);
	 * const b = tf.scalar(2);
	 * const c = tf.scalar(0);
	 *
	 * a.divNoNan(b).print();  // or tf.divNoNan(a, b)
	 * a.divNoNan(c).print();  // or tf.divNoNan(a, c)
	 * ```
	 *
	 * @param a The first tensor as the numerator.
	 * @param b The second tensor as the denominator. Must have the same dtype as
	 * `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Arithmetic'}
	 */

	function divNoNan_(a, b) {
	  // TODO: Make this into its own kernel.
	  var $a = convertToTensor(a, 'a', 'div');
	  var $b = convertToTensor(b, 'b', 'div');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  var divResult = div($a, $b);
	  var zeros = zerosLike(divResult);
	  var bEqualsZero = equal($b, zeros);
	  return where(bEqualsZero, zeros, divResult);
	}

	var divNoNan = op({
	  divNoNan_: divNoNan_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the dot product of two matrices and/or vectors, `t1` and `t2`.
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2]);
	 * const b = tf.tensor2d([[1, 2], [3, 4]]);
	 * const c = tf.tensor2d([[1, 2, 3], [4, 5, 6]]);
	 *
	 * a.dot(b).print();  // or tf.dot(a, b)
	 * b.dot(a).print();
	 * b.dot(c).print();
	 * ```
	 * @param t1 The first tensor in the dot operation.
	 * @param t2 The second tensor in the dot operation.
	 *
	 * @doc {heading: 'Operations', subheading: 'Matrices'}
	 */

	function dot_(t1, t2) {
	  var $t1 = convertToTensor(t1, 't1', 'dot');
	  var $t2 = convertToTensor(t2, 't2', 'dot');
	  assert(($t1.rank === 1 || $t1.rank === 2) && ($t2.rank === 1 || $t2.rank === 2), function () {
	    return "Error in dot: inputs must all be rank 1 or 2, but got ranks " + ($t1.rank + " and " + $t2.rank + ".");
	  });
	  var t1Inner = $t1.rank === 1 ? $t1.size : $t1.shape[1];
	  var t2Inner = $t2.rank === 1 ? $t2.size : $t2.shape[0];
	  assert(t1Inner === t2Inner, function () {
	    return "Error in dot: inner dimensions of inputs must match, but got " + (t1Inner + " and " + t2Inner + ".");
	  });

	  if ($t1.rank === 1 && $t2.rank === 1) {
	    var t12D = reshape($t1, [1, -1]);
	    var t22D = reshape($t2, [-1, 1]);
	    var t1t2 = matMul(t12D, t22D);
	    return reshape(t1t2, []);
	  } else if ($t1.rank === 1 && $t2.rank === 2) {
	    var _t12D = reshape($t1, [1, -1]);

	    var _t22D = reshape($t2, [$t2.shape[0], $t2.shape[1]]);

	    var _t1t = matMul(_t12D, _t22D);

	    return reshape(_t1t, [_t1t.size]);
	  } else if ($t1.rank === 2 && $t2.rank === 1) {
	    var _t22D2 = reshape($t2, [-1, 1]);

	    var _t1t2 = matMul($t1, _t22D2);

	    return reshape(_t1t2, [_t1t2.size]);
	  } else {
	    var _t22D3 = reshape($t2, [$t2.shape[0], $t2.shape[1]]);

	    var _t1t3 = matMul($t1, _t22D3);

	    return _t1t3;
	  }
	}

	var dot = op({
	  dot_: dot_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes exponential linear element-wise: `x > 0 ? e ^ x - 1 : 0`.
	 *
	 * ```js
	 * const x = tf.tensor1d([-1, 1, -3, 2]);
	 *
	 * x.elu().print();  // or tf.elu(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function elu_(x) {
	  var $x = convertToTensor(x, 'x', 'elu');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Elu, inputs);
	}

	var elu = op({
	  elu_: elu_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes gause error function of the input `tf.Tensor` element-wise:
	 * `erf(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([0, .1, -.1, .7]);
	 *
	 * x.erf().print(); // or tf.erf(x);
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function erf_(x) {
	  var $x = convertToTensor(x, 'x', 'erf');
	  assert($x.dtype === 'int32' || $x.dtype === 'float32', function () {
	    return 'Input dtype must be `int32` or `float32`.';
	  });

	  if ($x.dtype === 'int32') {
	    $x = cast($x, 'float32');
	  }

	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Erf, inputs);
	}

	var erf = op({
	  erf_: erf_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes exponential of the input `tf.Tensor` element-wise. `e ^ x`
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, -3]);
	 *
	 * x.exp().print();  // or tf.exp(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function exp_(x) {
	  var $x = convertToTensor(x, 'x', 'exp');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Exp, inputs);
	}

	var exp$3 = op({
	  exp_: exp_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns a `tf.Tensor` that has expanded rank, by inserting a dimension
	 * into the tensor's shape.
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3, 4]);
	 * const axis = 1;
	 * x.expandDims(axis).print();
	 * ```
	 *
	 * @param x The input tensor whose dimensions to be expanded.
	 * @param axis The dimension index at which to insert shape of `1`. Defaults
	 *     to 0 (the first dimension).
	 *
	 * @doc {heading: 'Tensors', subheading: 'Transformations'}
	 */

	function expandDims_(x, axis) {
	  if (axis === void 0) {
	    axis = 0;
	  }

	  var $x = convertToTensor(x, 'x', 'expandDims', 'string_or_numeric');
	  assert(axis <= $x.rank, function () {
	    return 'Axis must be <= rank of the tensor';
	  });
	  var inputs = {
	    input: $x
	  };
	  var attrs = {
	    dim: axis
	  };
	  return ENGINE.runKernel(ExpandDims, inputs, attrs);
	}

	var expandDims = op({
	  expandDims_: expandDims_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes exponential of the input `tf.Tensor` minus one element-wise.
	 * `e ^ x - 1`
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, -3]);
	 *
	 * x.expm1().print();  // or tf.expm1(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function expm1_(x) {
	  var $x = convertToTensor(x, 'x', 'expm1');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Expm1, inputs);
	}

	var expm1 = op({
	  expm1_: expm1_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Construct a tensor by repeating it the number of times given by reps.
	 *
	 * This operation creates a new tensor by replicating `input` `reps`
	 * times. The output tensor's i'th dimension has `input.shape[i] *
	 * reps[i]` elements, and the values of `input` are replicated
	 * `reps[i]` times along the i'th dimension. For example, tiling
	 * `[a, b, c, d]` by `[2]` produces `[a, b, c, d, a, b, c, d]`.
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2]);
	 *
	 * a.tile([2]).print();    // or a.tile([2])
	 * ```
	 *
	 * ```js
	 * const a = tf.tensor2d([1, 2, 3, 4], [2, 2]);
	 *
	 * a.tile([1, 2]).print();  // or a.tile([1, 2])
	 * ```
	 * @param x The tensor to tile.
	 * @param reps Determines the number of replications per dimension.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Slicing and Joining'}
	 */

	function tile_(x, reps) {
	  var $x = convertToTensor(x, 'x', 'tile', 'string_or_numeric');
	  assert($x.rank === reps.length, function () {
	    return "Error in transpose: rank of input " + $x.rank + " " + ("must match length of reps " + reps + ".");
	  });
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    reps: reps
	  };
	  return ENGINE.runKernel(Tile, inputs, attrs);
	}

	var tile = op({
	  tile_: tile_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Create an identity matrix.
	 *
	 * @param numRows Number of rows.
	 * @param numColumns Number of columns. Defaults to `numRows`.
	 * @param batchShape If provided, will add the batch shape to the beginning
	 *   of the shape of the returned `tf.Tensor` by repeating the identity
	 *   matrix.
	 * @param dtype Data type.
	 * @returns Identity matrix of the specified size and data type, possibly
	 *   with batch repetition if `batchShape` is specified.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */

	function eye_(numRows, numColumns, batchShape, dtype) {
	  if (dtype === void 0) {
	    dtype = 'float32';
	  }

	  if (numColumns == null) {
	    numColumns = numRows;
	  }

	  var buff = buffer([numRows, numColumns], dtype);
	  var n = numRows <= numColumns ? numRows : numColumns;

	  for (var i = 0; i < n; ++i) {
	    buff.set(1, i, i);
	  }

	  var out = reshape(buff.toTensor(), [numRows, numColumns]);

	  if (batchShape == null) {
	    return out;
	  } else {
	    if (batchShape.length === 1) {
	      return tile(expandDims(out, 0), [batchShape[0], 1, 1]);
	    } else if (batchShape.length === 2) {
	      // tslint:disable-next-line:no-unnecessary-type-assertion
	      return tile(expandDims(expandDims(out, 0), 0), [batchShape[0], batchShape[1], 1, 1]);
	    } else if (batchShape.length === 3) {
	      // tslint:disable-next-line:no-unnecessary-type-assertion
	      return tile(expandDims(expandDims(expandDims(out, 0), 0), 0), [batchShape[0], batchShape[1], batchShape[2], 1, 1]);
	    } else {
	      throw new Error("eye() currently supports only 1D and 2D " + ( // tslint:disable-next-line:no-any
	      "batchShapes, but received " + batchShape.length + "D."));
	    }
	  }
	}

	var eye = op({
	  eye_: eye_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Creates a `tf.Tensor` filled with a scalar value.
	 *
	 * ```js
	 * tf.fill([2, 2], 4).print();
	 * ```
	 *
	 * @param shape An array of integers defining the output tensor shape.
	 * @param value The scalar value to fill the tensor with.
	 * @param dtype The type of an element in the resulting tensor. Defaults to
	 * 'float'.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */

	function fill(shape, value, dtype) {
	  var attrs = {
	    shape: shape,
	    value: value,
	    dtype: dtype
	  };
	  return ENGINE.runKernel(Fill, {}, attrs);
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes floor of input `tf.Tensor` element-wise: `floor(x)`.
	 *
	 * ```js
	 * const x = tf.tensor1d([.6, 1.1, -3.3]);
	 *
	 * x.floor().print();  // or tf.floor(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function floor_(x) {
	  var $x = convertToTensor(x, 'x', 'floor');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Floor, inputs);
	}

	var floor$a = op({
	  floor_: floor_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Gather slices from tensor `x`'s axis `axis` according to `indices`.
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3, 4]);
	 * const indices = tf.tensor1d([1, 3, 3], 'int32');
	 *
	 * x.gather(indices).print();
	 * ```
	 *
	 * ```js
	 * const x = tf.tensor2d([1, 2, 3, 4], [2, 2]);
	 * const indices = tf.tensor1d([1, 1, 0], 'int32');
	 *
	 * x.gather(indices).print();
	 * ```
	 * @param x The input tensor whose slices to be gathered.
	 * @param indices The indices of the values to extract.
	 * @param axis The axis over which to select values. Defaults to 0.
	 * @param batchDims Optional. The number of batch dimensions. It must be less
	 *     than or equal to rank(indices). Defaults to 0.
	 *     The output tensor will have shape of
	 *     `x.shape[:axis] + indices.shape[batchDims:] + x.shape[axis + 1:]`
	 *
	 * @doc {heading: 'Tensors', subheading: 'Slicing and Joining'}
	 */

	function gather_(x, indices, axis, batchDims) {
	  if (axis === void 0) {
	    axis = 0;
	  }

	  if (batchDims === void 0) {
	    batchDims = 0;
	  }

	  var $x = convertToTensor(x, 'x', 'gather');
	  var $indices = convertToTensor(indices, 'indices', 'gather', 'int32');
	  var inputs = {
	    x: $x,
	    indices: $indices
	  };
	  var attrs = {
	    axis: axis,
	    batchDims: batchDims
	  };
	  return ENGINE.runKernel(GatherV2, inputs, attrs);
	}

	var gather = op({
	  gather_: gather_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the truth value of (a > b) element-wise. Supports broadcasting.
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2, 3]);
	 * const b = tf.tensor1d([2, 2, 2]);
	 *
	 * a.greater(b).print();
	 * ```
	 *
	 * @param a The first input tensor.
	 * @param b The second input tensor. Must have the same dtype as `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Logical'}
	 */

	function greater_(a, b) {
	  var $a = convertToTensor(a, 'a', 'greater');
	  var $b = convertToTensor(b, 'b', 'greater');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  assertAndGetBroadcastShape($a.shape, $b.shape);
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(Greater, inputs);
	}

	var greater = op({
	  greater_: greater_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the truth value of (a >= b) element-wise. Supports broadcasting.
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2, 3]);
	 * const b = tf.tensor1d([2, 2, 2]);
	 *
	 * a.greaterEqual(b).print();
	 * ```
	 *
	 * @param a The first input tensor.
	 * @param b The second input tensor. Must have the same dtype as `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Logical'}
	 */

	function greaterEqual_(a, b) {
	  var $a = convertToTensor(a, 'a', 'greaterEqual');
	  var $b = convertToTensor(b, 'b', 'greaterEqual');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  assertAndGetBroadcastShape($a.shape, $b.shape);
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(GreaterEqual, inputs);
	}

	var greaterEqual = op({
	  greaterEqual_: greaterEqual_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the imaginary part of a complex (or real) tensor.
	 *
	 * Given a tensor input, this operation returns a tensor of type float that is
	 * the imaginary part of each element in input considered as a complex number.
	 * If input is real, a tensor of all zeros is returned.
	 *
	 * ```js
	 * const x = tf.complex([-2.25, 3.25], [4.75, 5.75]);
	 * tf.imag(x).print();
	 * ```
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */

	function imag_(input) {
	  var $input = convertToTensor(input, 'input', 'imag');
	  var inputs = {
	    input: $input
	  };
	  return ENGINE.runKernel(Imag, inputs);
	}

	var imag = op({
	  imag_: imag_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns which elements of x are finite.
	 *
	 * ```js
	 * const x = tf.tensor1d([NaN, Infinity, -Infinity, 0, 1]);
	 *
	 * x.isFinite().print();  // or tf.isNaN(x)
	 * ```
	 * @param x The input Tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function isFinite_(x) {
	  var $x = convertToTensor(x, 'x', 'isFinite');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(IsFinite, inputs);
	}

	var isFinite$1 = op({
	  isFinite_: isFinite_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns which elements of x are Infinity or -Infinity.
	 *
	 * ```js
	 * const x = tf.tensor1d([NaN, Infinity, -Infinity, 0, 1]);
	 *
	 * x.isInf().print();  // or tf.isNaN(x)
	 * ```
	 * @param x The input Tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function isInf_(x) {
	  var $x = convertToTensor(x, 'x', 'isInf');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(IsInf, inputs);
	}

	var isInf = op({
	  isInf_: isInf_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * RReturns which elements of x are NaN.
	 *
	 * ```js
	 * const x = tf.tensor1d([NaN, Infinity, -Infinity, 0, 1]);
	 *
	 * x.isNaN().print();  // or tf.isNaN(x)
	 * ```
	 * @param x The input Tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function isNaN_(x) {
	  var $x = convertToTensor(x, 'x', 'isNaN');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(IsNan, inputs);
	}

	var isNaN$1 = op({
	  isNaN_: isNaN_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes leaky rectified linear element-wise.
	 *
	 * See
	 * [http://web.stanford.edu/~awni/papers/relu_hybrid_icml2013_final.pdf](
	 *     http://web.stanford.edu/~awni/papers/relu_hybrid_icml2013_final.pdf)
	 *
	 * ```js
	 * const x = tf.tensor1d([-1, 2, -3, 4]);
	 *
	 * x.leakyRelu(0.1).print();  // or tf.leakyRelu(x, 0.1)
	 * ```
	 * @param x The input tensor.
	 * @param alpha The scaling factor for negative values, defaults to 0.2.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function leakyRelu_(x, alpha) {
	  if (alpha === void 0) {
	    alpha = 0.2;
	  }

	  var $x = convertToTensor(x, 'x', 'leakyRelu');
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    alpha: alpha
	  };
	  return ENGINE.runKernel(LeakyRelu, inputs, attrs);
	}

	var leakyRelu = op({
	  leakyRelu_: leakyRelu_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the truth value of (a < b) element-wise. Supports broadcasting.
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2, 3]);
	 * const b = tf.tensor1d([2, 2, 2]);
	 *
	 * a.less(b).print();
	 * ```
	 * @param a The first input tensor.
	 * @param b The second input tensor. Must have the same dtype as `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Logical'}
	 */

	function less_(a, b) {
	  var $a = convertToTensor(a, 'a', 'less');
	  var $b = convertToTensor(b, 'b', 'less');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  assertAndGetBroadcastShape($a.shape, $b.shape);
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(Less, inputs);
	}

	var less = op({
	  less_: less_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the truth value of (a <= b) element-wise. Supports broadcasting.
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2, 3]);
	 * const b = tf.tensor1d([2, 2, 2]);
	 *
	 * a.lessEqual(b).print();
	 * ```
	 *
	 * @param a The first input tensor.
	 * @param b The second input tensor. Must have the same dtype as `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Logical'}
	 */

	function lessEqual_(a, b) {
	  var $a = convertToTensor(a, 'a', 'lessEqual');
	  var $b = convertToTensor(b, 'b', 'lessEqual');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  assertAndGetBroadcastShape($a.shape, $b.shape);
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(LessEqual, inputs);
	}

	var lessEqual = op({
	  lessEqual_: lessEqual_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Return an evenly spaced sequence of numbers over the given interval.
	 *
	 * ```js
	 * tf.linspace(0, 9, 10).print();
	 * ```
	 * @param start The start value of the sequence.
	 * @param stop The end value of the sequence.
	 * @param num The number of values to generate.
	 *
	 * @doc {heading: 'Tensors', subheading: 'Creation'}
	 */

	function linspace(start, stop, num) {
	  if (num <= 0) {
	    throw new Error('The number of values should be positive.');
	  }

	  var attrs = {
	    start: start,
	    stop: stop,
	    num: num
	  };
	  return ENGINE.runKernel(LinSpace, {}, attrs);
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Normalizes the activation of a local neighborhood across or within
	 * channels.
	 *
	 * @param x The input tensor. The 4-D input tensor is treated as a 3-D array
	 *     of 1D vectors (along the last dimension), and each vector is
	 *     normalized independently.
	 * @param depthRadius The number of adjacent channels in the 1D normalization
	 *     window.
	 * @param bias A constant bias term for the basis.
	 * @param alpha A scale factor, usually positive.
	 * @param beta An exponent.
	 *
	 * @doc {heading: 'Operations', subheading: 'Normalization'}
	 */

	function localResponseNormalization_(x, depthRadius, bias, alpha, beta) {
	  if (depthRadius === void 0) {
	    depthRadius = 5;
	  }

	  if (bias === void 0) {
	    bias = 1;
	  }

	  if (alpha === void 0) {
	    alpha = 1;
	  }

	  if (beta === void 0) {
	    beta = 0.5;
	  }

	  var $x = convertToTensor(x, 'x', 'localResponseNormalization');
	  assert($x.rank === 4 || $x.rank === 3, function () {
	    return "Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank " + $x.rank + ".";
	  });
	  assert(isInt(depthRadius), function () {
	    return "Error in localResponseNormalization: depthRadius must be an " + ("integer but got depthRadius " + depthRadius + ".");
	  });
	  var x4D = $x;
	  var reshapedTo4D = false;

	  if ($x.rank === 3) {
	    reshapedTo4D = true;
	    x4D = reshape($x, [1, $x.shape[0], $x.shape[1], $x.shape[2]]);
	  }

	  var inputs = {
	    x: x4D
	  };
	  var attrs = {
	    depthRadius: depthRadius,
	    bias: bias,
	    alpha: alpha,
	    beta: beta
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var res = ENGINE.runKernel(LRN, inputs, attrs);

	  if (reshapedTo4D) {
	    return reshape(res, [res.shape[1], res.shape[2], res.shape[3]]);
	  } else {
	    return res;
	  }
	}

	var localResponseNormalization = op({
	  localResponseNormalization_: localResponseNormalization_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes natural logarithm of the input `tf.Tensor` element-wise: `ln(x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, Math.E]);
	 *
	 * x.log().print();  // or tf.log(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function log_(x) {
	  var $x = convertToTensor(x, 'x', 'log');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Log, inputs);
	}

	var log$9 = op({
	  log_: log_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes natural logarithm of the input `tf.Tensor` plus one
	 * element-wise: `ln(1 + x)`
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, Math.E - 1]);
	 *
	 * x.log1p().print();  // or tf.log1p(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function log1p_(x) {
	  var $x = convertToTensor(x, 'x', 'log1p');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Log1p, inputs);
	}

	var log1p = op({
	  log1p_: log1p_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Provided `f(x)`, returns another function `g(x, dy?)`, which gives the
	 * gradient of `f(x)` with respect to `x`.
	 *
	 * If `dy` is provided, the gradient of `f(x).mul(dy).sum()` with respect to
	 * `x` is computed instead. `f(x)` must take a single tensor `x` and return a
	 * single tensor `y`. If `f()` takes multiple inputs, use `tf.grads` instead.
	 *
	 * ```js
	 * // f(x) = x ^ 2
	 * const f = x => x.square();
	 * // f'(x) = 2x
	 * const g = tf.grad(f);
	 *
	 * const x = tf.tensor1d([2, 3]);
	 * g(x).print();
	 * ```
	 *
	 * ```js
	 * // f(x) = x ^ 3
	 * const f = x => x.pow(tf.scalar(3, 'int32'));
	 * // f'(x) = 3x ^ 2
	 * const g = tf.grad(f);
	 * // f''(x) = 6x
	 * const gg = tf.grad(g);
	 *
	 * const x = tf.tensor1d([2, 3]);
	 * gg(x).print();
	 * ```
	 *
	 * @param f The function f(x), to compute gradient for.
	 *
	 * @doc {heading: 'Training', subheading: 'Gradients'}
	 */

	function grad(f) {
	  assert(isFunction(f), function () {
	    return 'The f passed in grad(f) must be a function';
	  });
	  return function (x, dy) {
	    // x can be of any dtype, thus null as the last argument.
	    var $x = convertToTensor(x, 'x', 'tf.grad', 'string_or_numeric');
	    var $dy = dy != null ? convertToTensor(dy, 'dy', 'tf.grad') : null;
	    return ENGINE.tidy(function () {
	      var _ENGINE$gradients = ENGINE.gradients(function () {
	        return f($x);
	      }, [$x], $dy),
	          value = _ENGINE$gradients.value,
	          grads = _ENGINE$gradients.grads;

	      if ($dy != null) {
	        assertShapesMatch(value.shape, $dy.shape, 'The shape of dy passed in grad(f)(x, dy) must match the shape ' + 'returned by f(x)');
	      }

	      checkGrads(grads);
	      return grads[0];
	    });
	  };
	}
	/**
	 * Provided `f(x1, x2,...)`, returns another function `g([x1, x2,...], dy?)`,
	 * which gives an array of gradients of `f()` with respect to each input
	 * [`x1`,`x2`,...].
	 *
	 * If `dy` is passed when calling `g()`, the gradient of
	 * `f(x1,...).mul(dy).sum()` with respect to each input is computed instead.
	 * The provided `f` must take one or more tensors and return a single tensor
	 * `y`. If `f()` takes a single input, we recommend using `tf.grad` instead.
	 *
	 * ```js
	 * // f(a, b) = a * b
	 * const f = (a, b) => a.mul(b);
	 * // df / da = b, df / db = a
	 * const g = tf.grads(f);
	 *
	 * const a = tf.tensor1d([2, 3]);
	 * const b = tf.tensor1d([-2, -3]);
	 * const [da, db] = g([a, b]);
	 * console.log('da');
	 * da.print();
	 * console.log('db');
	 * db.print();
	 * ```
	 *
	 * @param f The function `f(x1, x2,...)` to compute gradients for.
	 *
	 * @doc {heading: 'Training', subheading: 'Gradients'}
	 */


	function grads(f) {
	  assert(isFunction(f), function () {
	    return 'The f passed in grads(f) must be a function';
	  });
	  return function (args, dy) {
	    assert(Array.isArray(args), function () {
	      return 'The args passed in grads(f)(args) must be an array ' + 'of `Tensor`s or `TensorLike`s';
	    }); // args can be of any dtype, thus null as the last argument.

	    var $args = convertToTensorArray(args, 'args', 'tf.grads', 'string_or_numeric');
	    var $dy = dy != null ? convertToTensor(dy, 'dy', 'tf.grads') : null;
	    return ENGINE.tidy(function () {
	      var _ENGINE$gradients2 = ENGINE.gradients(function () {
	        return f.apply(void 0, $args);
	      }, $args, $dy),
	          value = _ENGINE$gradients2.value,
	          grads = _ENGINE$gradients2.grads;

	      if ($dy != null) {
	        assertShapesMatch(value.shape, $dy.shape, 'The shape of dy passed in grads(f)([x1,...], dy) must ' + 'match the shape returned by f([x1,...])');
	      }

	      checkGrads(grads);
	      return grads;
	    });
	  };
	}
	/**
	 * Like `tf.grad`, but also returns the value of `f()`. Useful when `f()`
	 * returns a metric you want to show.
	 *
	 * The result is a rich object with the following properties:
	 * - grad: The gradient of `f(x)` w.r.t `x` (result of `tf.grad`).
	 * - value: The value returned by `f(x)`.
	 *
	 * ```js
	 * // f(x) = x ^ 2
	 * const f = x => x.square();
	 * // f'(x) = 2x
	 * const g = tf.valueAndGrad(f);
	 *
	 * const x = tf.tensor1d([2, 3]);
	 * const {value, grad} = g(x);
	 *
	 * console.log('value');
	 * value.print();
	 * console.log('grad');
	 * grad.print();
	 * ```
	 *
	 * @doc {heading: 'Training', subheading: 'Gradients'}
	 */


	function valueAndGrad(f) {
	  assert(isFunction(f), function () {
	    return 'The f passed in valueAndGrad(f) must be a function';
	  });
	  return function (x, dy) {
	    assert(x instanceof Tensor, function () {
	      return 'The x passed in valueAndGrad(f)(x) must be a tensor';
	    });
	    assert(dy == null || dy instanceof Tensor, function () {
	      return 'The dy passed in valueAndGrad(f)(x, dy) must be a tensor';
	    });

	    var _ENGINE$gradients3 = ENGINE.gradients(function () {
	      return f(x);
	    }, [x], dy),
	        grads = _ENGINE$gradients3.grads,
	        value = _ENGINE$gradients3.value;

	    checkGrads(grads);
	    return {
	      grad: grads[0],
	      value: value
	    };
	  };
	}
	/**
	 * Like `tf.grads`, but returns also the value of `f()`. Useful when `f()`
	 * returns a metric you want to show.
	 *
	 * The result is a rich object with the following properties:
	 * - grads: The gradients of `f()` w.r.t each input (result of `tf.grads`).
	 * - value: The value returned by `f(x)`.
	 *
	 * ```js
	 * // f(a, b) = a * b
	 * const f = (a, b) => a.mul(b);
	 * // df/da = b, df/db = a
	 * const g = tf.valueAndGrads(f);
	 *
	 * const a = tf.tensor1d([2, 3]);
	 * const b = tf.tensor1d([-2, -3]);
	 * const {value, grads} = g([a, b]);
	 *
	 * const [da, db] = grads;
	 *
	 * console.log('value');
	 * value.print();
	 *
	 * console.log('da');
	 * da.print();
	 * console.log('db');
	 * db.print();
	 * ```
	 *
	 * @doc {heading: 'Training', subheading: 'Gradients'}
	 */


	function valueAndGrads(f) {
	  assert(isFunction(f), function () {
	    return 'The f passed in valueAndGrads(f) must be a function';
	  });
	  return function (args, dy) {
	    assert(Array.isArray(args) && args.every(function (arg) {
	      return arg instanceof Tensor;
	    }), function () {
	      return 'The args passed in valueAndGrads(f)(args) must be array of ' + 'tensors';
	    });
	    assert(dy == null || dy instanceof Tensor, function () {
	      return 'The dy passed in valueAndGrads(f)(args, dy) must be a tensor';
	    });
	    var res = ENGINE.gradients(function () {
	      return f.apply(void 0, args);
	    }, args, dy);

	    if (dy != null) {
	      assertShapesMatch(res.value.shape, dy.shape, 'The shape of dy passed in valueAndGrads(f)([x1,...], dy) must ' + 'match the shape returned by f([x1,...])');
	    }

	    checkGrads(res.grads);
	    return res;
	  };
	}
	/**
	 * Computes and returns the gradient of f(x) with respect to the list of
	 * trainable variables provided by `varList`. If no list is provided, it
	 * defaults to all trainable variables.
	 *
	 * ```js
	 * const a = tf.variable(tf.tensor1d([3, 4]));
	 * const b = tf.variable(tf.tensor1d([5, 6]));
	 * const x = tf.tensor1d([1, 2]);
	 *
	 * // f(a, b) = a * x ^ 2 + b * x
	 * const f = () => a.mul(x.square()).add(b.mul(x)).sum();
	 * // df/da = x ^ 2, df/db = x
	 * const {value, grads} = tf.variableGrads(f);
	 *
	 * Object.keys(grads).forEach(varName => grads[varName].print());
	 * ```
	 *
	 * @param f The function to execute. f() should return a scalar.
	 * @param varList The list of variables to compute the gradients with respect
	 *     to. Defaults to all trainable variables.
	 * @returns An object with the following keys and values:
	 *   - `value`: The value of the function `f`.
	 *   - `grads`: A map from the names of the variables to the gradients.
	 *     If the `varList` argument is provided explicitly and contains a subset of
	 *     non-trainable variables, this map in the return value will contain keys
	 *     that map the names of the non-trainable variables to `null`.
	 *
	 * @doc {heading: 'Training', subheading: 'Gradients'}
	 */


	function variableGrads(f, varList) {
	  assert(isFunction(f), function () {
	    return 'The f passed in variableGrads(f) must be a function';
	  });
	  assert(varList == null || Array.isArray(varList) && varList.every(function (v) {
	    return v instanceof Variable;
	  }), function () {
	    return 'The varList passed in variableGrads(f, varList) must be an array ' + 'of variables';
	  });
	  var specifiedVarList = varList != null;

	  if (!specifiedVarList) {
	    // Get all of the trainable variables.
	    varList = [];

	    for (var varName in ENGINE.registeredVariables) {
	      varList.push(ENGINE.registeredVariables[varName]);
	    }
	  }

	  var specifiedNonTrainable = specifiedVarList ? varList.filter(function (variable) {
	    return !variable.trainable;
	  }) : null; // Prune non-trainable variables.

	  var originalVarCount = varList.length;
	  varList = varList.filter(function (variable) {
	    return variable.trainable;
	  });
	  assert(varList.length > 0, function () {
	    return "variableGrads() expects at least one of the input variables to " + ("be trainable, but none of the " + originalVarCount + " variables is ") + "trainable.";
	  });
	  var allowNoGradients = true;

	  var _ENGINE$gradients4 = ENGINE.gradients(f, varList, null, allowNoGradients),
	      value = _ENGINE$gradients4.value,
	      grads = _ENGINE$gradients4.grads;

	  assert(grads.some(function (g) {
	    return g != null;
	  }), function () {
	    return 'Cannot find a connection between any variable and the result of ' + 'the loss function y=f(x). Please make sure the operations that ' + 'use variables are inside the function f passed to minimize().';
	  });
	  assert(value.rank === 0, function () {
	    return "The f passed in variableGrads(f) must return a scalar, but it " + ("returned a rank-" + value.rank + " tensor");
	  });
	  var namedGrads = {};
	  varList.forEach(function (v, i) {
	    if (grads[i] != null) {
	      namedGrads[v.name] = grads[i];
	    }
	  });

	  if (specifiedNonTrainable != null) {
	    // If varList is explicitly provided and contains non-trainable values,
	    // add them to the returned gradients with `null` values.
	    specifiedNonTrainable.forEach(function (v) {
	      return namedGrads[v.name] = null;
	    });
	  }

	  return {
	    value: value,
	    grads: namedGrads
	  };
	}
	/**
	 * Overrides the gradient computation of a function `f`.
	 *
	 * Takes a function
	 * `f(...inputs, save) => {value: Tensor, gradFunc: (dy, saved) => Tensor[]}`
	 * and returns another function `g(...inputs)` which takes the same inputs as
	 * `f`. When called, `g` returns `f().value`. In backward mode, custom gradients
	 * with respect to each input of `f` are computed using `f().gradFunc`.
	 *
	 * The `save` function passsed to `f` should be used for saving tensors needed
	 * in the gradient. And the `saved` passed to the `gradFunc` is a
	 * `NamedTensorMap`, which contains those saved tensor.
	 *
	 * ```js
	 * const customOp = tf.customGrad((x, save) => {
	 *   // Save x to make sure it's available later for the gradient.
	 *   save([x]);
	 *   // Override gradient of our custom x ^ 2 op to be dy * abs(x);
	 *   return {
	 *     value: x.square(),
	 *     // Note `saved.x` which points to the `x` we saved earlier.
	 *     gradFunc: (dy, saved) => [dy.mul(saved[0].abs())]
	 *   };
	 * });
	 *
	 * const x = tf.tensor1d([-1, -2, 3]);
	 * const dx = tf.grad(x => customOp(x));
	 *
	 * console.log(`f(x):`);
	 * customOp(x).print();
	 * console.log(`f'(x):`);
	 * dx(x).print();
	 * ```
	 *
	 * @param f The function to evaluate in forward mode, which should return
	 *     `{value: Tensor, gradFunc: (dy, saved) => Tensor[]}`, where `gradFunc`
	 *     returns the custom gradients of `f` with respect to its inputs.
	 *
	 * @doc {heading: 'Training', subheading: 'Gradients'}
	 */


	function customGrad(f) {
	  return ENGINE.customGrad(f);
	}

	function checkGrads(grads) {
	  var numNullGradients = grads.filter(function (g) {
	    return g == null;
	  }).length;

	  if (numNullGradients > 0) {
	    throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that\n    the f you passed encloses all operations that lead from x to y.");
	  }
	}

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes `-1 * x` element-wise.
	 *
	 * ```js
	 * const x = tf.tensor2d([1, 2, -2, 0], [2, 2]);
	 *
	 * x.neg().print();  // or tf.neg(x)
	 * ```
	 *
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function neg_(x) {
	  var $x = convertToTensor(x, 'x', 'neg');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Neg, inputs);
	}

	var neg = op({
	  neg_: neg_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes softplus of the input `tf.Tensor` element-wise: `log(exp(x) + 1)`
	 *
	 * ```js
	 * const x = tf.tensor1d([0, 1, -1, .7]);
	 *
	 * x.softplus().print();  // or tf.softplus(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function softplus_(x) {
	  var $x = convertToTensor(x, 'x', 'softplus');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(Softplus, inputs);
	}

	var softplus = op({
	  softplus_: softplus_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes log sigmoid of the input `tf.Tensor` element-wise:
	 * `logSigmoid(x)`. For numerical stability, we use `-tf.softplus(-x)`.
	 *
	 * ```js
	 * const x = tf.tensor1d([0, 1, -1, .7]);
	 *
	 * x.logSigmoid().print();  // or tf.logSigmoid(x)
	 * ```
	 * @param x The input tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function logSigmoid_(x) {
	  var $x = convertToTensor(x, 'x', 'logSigmoid'); // Use a custom gradient to maintain previous implementation.
	  // There is no LogSigmoid kernel in TF so we can't use engine.runKernel
	  // directly

	  var customOp = customGrad(function (x) {
	    // TODO(yassogba) we can remove the chained softplus call here only
	    // after backends have modualrized softplus at which point we can call
	    // engine runKernel(..., Sotfplus, ...) directly.
	    var value = neg(softplus(neg(x)));

	    var gradFunc = function gradFunc(dy) {
	      var derX = mul(dy, sigmoid(neg(x)));
	      return derX;
	    };

	    return {
	      value: value,
	      gradFunc: gradFunc
	    };
	  });
	  return customOp($x);
	}

	var logSigmoid = op({
	  logSigmoid_: logSigmoid_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the maximum of elements across dimensions of a `tf.Tensor`.
	 *
	 * Reduces the input along the dimensions given in `axes`. Unless `keepDims`
	 * is true, the rank of the `tf.Tensor` is reduced by 1 for each entry in
	 * `axes`. If `keepDims` is true, the reduced dimensions are retained with
	 * length 1. If `axes` has no entries, all dimensions are reduced, and an
	 * `tf.Tensor` with a single element is returned.
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3]);
	 *
	 * x.max().print();  // or tf.max(x)
	 * ```
	 *
	 * ```js
	 * const x = tf.tensor2d([1, 2, 3, 4], [2, 2]);
	 *
	 * const axis = 1;
	 * x.max(axis).print();  // or tf.max(x, axis)
	 * ```
	 *
	 * @param x The input tensor.
	 * @param axis The dimension(s) to reduce. By default it reduces
	 *     all dimensions.
	 * @param keepDims If true, retains reduced dimensions with size 1.
	 *
	 * @doc {heading: 'Operations', subheading: 'Reduction'}
	 */

	function max_(x, axis, keepDims) {
	  if (axis === void 0) {
	    axis = null;
	  }

	  if (keepDims === void 0) {
	    keepDims = false;
	  }

	  var $x = convertToTensor(x, 'x', 'max');
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    reductionIndices: axis,
	    keepDims: keepDims
	  };
	  return ENGINE.runKernel(Max, inputs, attrs);
	}

	var max$4 = op({
	  max_: max_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Subtracts two `tf.Tensor`s element-wise, A - B. Supports broadcasting.
	 *
	 * ```js
	 * const a = tf.tensor1d([10, 20, 30, 40]);
	 * const b = tf.tensor1d([1, 2, 3, 4]);
	 *
	 * a.sub(b).print();  // or tf.sub(a, b)
	 * ```
	 *
	 * ```js
	 * // Broadcast subtract a with b.
	 * const a = tf.tensor1d([10, 20, 30, 40]);
	 * const b = tf.scalar(5);
	 *
	 * a.sub(b).print();  // or tf.sub(a, b)
	 * ```
	 * @param a The first `tf.Tensor` to subtract from.
	 * @param b The second `tf.Tensor` to be subtracted. Must have the same dtype as
	 * `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Arithmetic'}
	 */

	function sub_(a, b) {
	  var $a = convertToTensor(a, 'a', 'sub');
	  var $b = convertToTensor(b, 'b', 'sub');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(Sub, inputs);
	}

	var sub = op({
	  sub_: sub_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the sum of elements across dimensions of a `tf.Tensor`.
	 *
	 * Reduces the input along the dimensions given in `axes`. Unless `keepDims`
	 * is true, the rank of the `tf.Tensor` is reduced by 1 for each entry in
	 * `axes`. If `keepDims` is true, the reduced dimensions are retained with
	 * length 1. If axes has no entries, all dimensions are reduced, and a
	 * `tf.Tensor` with a single element is returned.
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3]);
	 *
	 * x.sum().print();  // or tf.sum(x)
	 * ```
	 *
	 * ```js
	 * const x = tf.tensor2d([1, 2, 3, 4], [2, 2]);
	 *
	 * const axis = 1;
	 * x.sum(axis).print();  // or tf.sum(x, axis)
	 * ```
	 *
	 * @param x The input tensor to compute the sum over. If the dtype is `bool`
	 *   it will be converted to `int32` and the output dtype will be `int32`.
	 * @param axis The dimension(s) to reduce. By default it reduces
	 *     all dimensions.
	 * @param keepDims If true, retains reduced dimensions with size 1.
	 *
	 * @doc {heading: 'Operations', subheading: 'Reduction'}
	 */

	function sum_(x, axis, keepDims) {
	  if (axis === void 0) {
	    axis = null;
	  }

	  if (keepDims === void 0) {
	    keepDims = false;
	  }

	  var $x = convertToTensor(x, 'x', 'sum');

	  if ($x.dtype === 'bool') {
	    $x = cast($x, 'int32');
	  }

	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    axis: axis,
	    keepDims: keepDims
	  };
	  return ENGINE.runKernel(Sum, inputs, attrs);
	}

	var sum$1 = op({
	  sum_: sum_
	});

	/**
	 * @license
	 * Copyright 2020 Google Inc. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the log softmax.
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 2, 3]);
	 *
	 * a.logSoftmax().print();  // or tf.logSoftmax(a)
	 * ```
	 *
	 * ```js
	 * const a = tf.tensor2d([2, 4, 6, 1, 2, 3], [2, 3]);
	 *
	 * a.logSoftmax().print();  // or tf.logSoftmax(a)
	 * ```
	 *
	 * @param logits The logits array.
	 * @param axis The dimension softmax would be performed on. Defaults to `-1`
	 *     which indicates the last dimension.
	 *
	 * @doc {heading: 'Operations', subheading: 'Normalization'}
	 */

	function logSoftmax_(logits, axis) {
	  if (axis === void 0) {
	    axis = -1;
	  }

	  var $logits = convertToTensor(logits, 'logits', 'logSoftmax');

	  if (axis === -1) {
	    axis = $logits.rank - 1;
	  }

	  if (axis !== $logits.rank - 1) {
	    throw Error('Log Softmax along a non-last dimension is not yet supported. ' + ("Logits was rank " + $logits.rank + " and axis was " + axis));
	  } // const forward: ForwardFunc<Tensor> = (backend, save) => {
	  //   const keepDims = true;
	  //   const xMax = max(logits, axis, true);
	  //   const shifted = sub(logits, xMax);
	  //   const value =
	  //       sub(cast(shifted, 'float32'), log(sum(exp(shifted), axis,
	  //       keepDims)));
	  //   save([value]);
	  //   return value;
	  // };
	  // Use a custom gradient for numerical stability.


	  var customOp = customGrad(function (logits, save) {
	    var keepDims = true;
	    var xMax = max$4(logits, axis, true);
	    var shifted = sub(logits, xMax);
	    var value = sub(cast(shifted, 'float32'), log$9(sum$1(exp$3(shifted), axis, keepDims)));
	    save([value]);

	    var gradFunc = function gradFunc(dy, saved) {
	      var value = saved[0];
	      var keepDims = true;
	      var softmax = exp$3(value);
	      return sub(dy, mul(sum$1(dy, axis, keepDims), softmax));
	    };

	    return {
	      value: value,
	      gradFunc: gradFunc
	    };
	  });
	  return customOp($logits); // TODO Use Engine.runKernel when CPU/WebGL/WASM backends implement this.
	  // const inputs: LogSoftmaxInputs = {logits: $logits};
	  // const attrs: LogSoftmaxAttrs = {axis};
	  // return ENGINE.runKernel(
	  //            LogSoftmax, inputs as {} as NamedTensorMap,
	  //            attrs as {} as NamedAttrMap);
	}

	var logSoftmax = op({
	  logSoftmax_: logSoftmax_
	});

	/**
	 * @license
	 * Copyright 2017 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns true if the axis specifies the inner most dimensions of the
	 * array.
	 */

	function axesAreInnerMostDims(axes, rank) {
	  for (var i = 0; i < axes.length; ++i) {
	    if (axes[axes.length - i - 1] !== rank - 1 - i) {
	      return false;
	    }
	  }

	  return true;
	}
	function combineLocations(outputLoc, reduceLoc, axes) {
	  var rank = outputLoc.length + reduceLoc.length;
	  var loc = [];
	  var outIdx = 0;
	  var reduceIdx = 0;

	  for (var dim = 0; dim < rank; dim++) {
	    if (axes.indexOf(dim) === -1) {
	      loc.push(outputLoc[outIdx++]);
	    } else {
	      loc.push(reduceLoc[reduceIdx++]);
	    }
	  }

	  return loc;
	}
	function computeOutAndReduceShapes(aShape, axes) {
	  var outShape = [];
	  var rank = aShape.length;

	  for (var dim = 0; dim < rank; dim++) {
	    if (axes.indexOf(dim) === -1) {
	      outShape.push(aShape[dim]);
	    }
	  }

	  var reduceShape = axes.map(function (dim) {
	    return aShape[dim];
	  });
	  return [outShape, reduceShape];
	}
	function expandShapeToKeepDim(shape, axes) {
	  var reduceSubShape = axes.map(function (x) {
	    return 1;
	  });
	  return combineLocations(shape, reduceSubShape, axes);
	}
	function assertAxesAreInnerMostDims(msg, axes, rank) {
	  assert(axesAreInnerMostDims(axes, rank), function () {
	    return msg + " supports only inner-most axes for now. " + ("Got axes " + axes + " and rank-" + rank + " input.");
	  });
	}
	/**
	 * Returns the axes permutation to be used with `tf.transpose`, if such
	 * permutation is necessary. Otherwise it returns null. This method is used by
	 * operations that operate only on inner-most axes.
	 */

	function getAxesPermutation(axes, rank) {
	  if (axesAreInnerMostDims(axes, rank)) {
	    return null;
	  }

	  var result = [];

	  for (var i = 0; i < rank; ++i) {
	    if (axes.indexOf(i) === -1) {
	      result.push(i);
	    }
	  }

	  axes.forEach(function (axis) {
	    return result.push(axis);
	  });
	  return result;
	}
	/** Returns the axes permutation that undoes the original permutation. */

	function getUndoAxesPermutation(axes) {
	  return axes.map(function (axis, i) {
	    return [i, axis];
	  }).sort(function (a, b) {
	    return a[1] - b[1];
	  }).map(function (x) {
	    return x[0];
	  });
	}
	function getInnerMostAxes(numAxes, rank) {
	  var res = [];

	  for (var i = rank - numAxes; i < rank; ++i) {
	    res.push(i);
	  }

	  return res;
	}

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the log(sum(exp(elements across the reduction dimensions)).
	 *
	 * Reduces the input along the dimensions given in `axis`. Unless `keepDims`
	 * is true, the rank of the array is reduced by 1 for each entry in `axis`.
	 * If `keepDims` is true, the reduced dimensions are retained with length 1.
	 * If `axis` has no entries, all dimensions are reduced, and an array with a
	 * single element is returned.
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3]);
	 *
	 * x.logSumExp().print();  // or tf.logSumExp(x)
	 * ```
	 *
	 * ```js
	 * const x = tf.tensor2d([1, 2, 3, 4], [2, 2]);
	 *
	 * const axis = 1;
	 * x.logSumExp(axis).print();  // or tf.logSumExp(a, axis)
	 * ```
	 * @param x The input tensor.
	 * @param axis The dimension(s) to reduce. If null (the default),
	 *     reduces all dimensions.
	 * @param keepDims If true, retains reduced dimensions with length
	 *     of 1. Defaults to false.
	 *
	 * @doc {heading: 'Operations', subheading: 'Reduction'}
	 */

	function logSumExp_(x, axis, keepDims) {
	  if (axis === void 0) {
	    axis = null;
	  }

	  if (keepDims === void 0) {
	    keepDims = false;
	  }

	  var $x = convertToTensor(x, 'x', 'logSumExp');
	  var axes = parseAxisParam(axis, $x.shape);
	  var xMax = max$4($x, axes, true
	  /* keepDims */
	  );
	  var a = sub($x, xMax);
	  var b = exp$3(a);
	  var c = sum$1(b, axes);
	  var d = log$9(c);
	  var res = add$1(reshape(xMax, d.shape), d);

	  if (keepDims) {
	    var newShape = expandShapeToKeepDim(res.shape, axes);
	    return reshape(res, newShape);
	  }

	  return res;
	}

	var logSumExp = op({
	  logSumExp_: logSumExp_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the truth value of `a AND b` element-wise. Supports broadcasting.
	 *
	 * ```js
	 * const a = tf.tensor1d([false, false, true, true], 'bool');
	 * const b = tf.tensor1d([false, true, false, true], 'bool');
	 *
	 * a.logicalAnd(b).print();
	 * ```
	 *
	 * @param a The first input tensor. Must be of dtype bool.
	 * @param b The second input tensor. Must be of dtype bool.
	 *
	 * @doc {heading: 'Operations', subheading: 'Logical'}
	 */

	function logicalAnd_(a, b) {
	  var $a = convertToTensor(a, 'a', 'logicalAnd', 'bool');
	  var $b = convertToTensor(b, 'b', 'logicalAnd', 'bool');
	  assertAndGetBroadcastShape($a.shape, $b.shape);
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(LogicalAnd, inputs);
	}

	var logicalAnd = op({
	  logicalAnd_: logicalAnd_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the truth value of `NOT x` element-wise.
	 *
	 * ```js
	 * const a = tf.tensor1d([false, true], 'bool');
	 *
	 * a.logicalNot().print();
	 * ```
	 *
	 * @param x The input tensor. Must be of dtype 'bool'.
	 *
	 * @doc {heading: 'Operations', subheading: 'Logical'}
	 */

	function logicalNot_(x) {
	  var $x = convertToTensor(x, 'x', 'logicalNot', 'bool');
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(LogicalNot, inputs);
	}

	var logicalNot = op({
	  logicalNot_: logicalNot_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the truth value of `a OR b` element-wise. Supports broadcasting.
	 *
	 * ```js
	 * const a = tf.tensor1d([false, false, true, true], 'bool');
	 * const b = tf.tensor1d([false, true, false, true], 'bool');
	 *
	 * a.logicalOr(b).print();
	 * ```
	 * @param a The first input tensor. Must be of dtype bool.
	 * @param b The second input tensor. Must be of dtype bool.
	 *
	 * @doc {heading: 'Operations', subheading: 'Logical'}
	 */

	function logicalOr_(a, b) {
	  var $a = convertToTensor(a, 'a', 'logicalOr', 'bool');
	  var $b = convertToTensor(b, 'b', 'logicalOr', 'bool');
	  assertAndGetBroadcastShape($a.shape, $b.shape);
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(LogicalOr, inputs);
	}

	var logicalOr = op({
	  logicalOr_: logicalOr_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the truth value of `a XOR b` element-wise. Supports broadcasting.
	 *
	 * ```js
	 * const a = tf.tensor1d([false, false, true, true], 'bool');
	 * const b = tf.tensor1d([false, true, false, true], 'bool');
	 *
	 * a.logicalXor(b).print();
	 * ```
	 *
	 * @param a The first input tensor. Must be of dtype bool.
	 * @param b The second input tensor. Must be of dtype bool.
	 *
	 * @doc {heading: 'Operations', subheading: 'Logical'}
	 */

	function logicalXor_(a, b) {
	  var $a = convertToTensor(a, 'a', 'logicalXor', 'bool');
	  var $b = convertToTensor(b, 'b', 'logicalXor', 'bool');
	  assertAndGetBroadcastShape($a.shape, $b.shape); // x ^ y = (x | y) & ~(x & y)

	  return logicalAnd(logicalOr(a, b), logicalNot(logicalAnd(a, b)));
	}

	var logicalXor = op({
	  logicalXor_: logicalXor_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the 2D max pooling of an image.
	 *
	 * @param x The input tensor, of rank 4 or rank 3 of shape
	 *     `[batch, height, width, inChannels]`. If rank 3, batch of 1 is assumed.
	 * @param filterSize The filter size: `[filterHeight, filterWidth]`. If
	 *     `filterSize` is a single number, then `filterHeight == filterWidth`.
	 * @param strides The strides of the pooling: `[strideHeight, strideWidth]`. If
	 *     `strides` is a single number, then `strideHeight == strideWidth`.
	 * @param dilations The dilation rates: `[dilationHeight, dilationWidth]`
	 *     in which we sample input values across the height and width dimensions
	 *     in dilated pooling. Defaults to `[1, 1]`. If `dilations` is a single
	 *     number, then `dilationHeight == dilationWidth`. If it is greater than
	 *     1, then all values of `strides` must be 1.
	 * @param pad The type of padding algorithm.
	 *    - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *    - `valid`: output will be smaller than input if filter is larger
	 *       than 1x1.
	 *    - For more info, see this guide:
	 *     [https://www.tensorflow.org/api_guides/python/nn#Convolution](
	 *          https://www.tensorflow.org/api_guides/python/nn#Convolution)
	 * @param dimRoundingMode A string from: 'ceil', 'round', 'floor'. If none is
	 *     provided, it will default to truncate.
	 */

	function maxPool_(x, filterSize, strides, pad, dimRoundingMode) {
	  var $x = convertToTensor(x, 'x', 'maxPool');
	  var dilations = 1;
	  var x4D = $x;
	  var reshapedTo4D = false;

	  if ($x.rank === 3) {
	    reshapedTo4D = true;
	    x4D = reshape($x, [1, $x.shape[0], $x.shape[1], $x.shape[2]]);
	  }

	  assert(x4D.rank === 4, function () {
	    return "Error in maxPool: input must be rank 4 but got rank " + x4D.rank + ".";
	  });
	  assert(eitherStridesOrDilationsAreOne(strides, dilations), function () {
	    return 'Error in maxPool: Either strides or dilations must be 1. ' + ("Got strides " + strides + " and dilations '" + dilations + "'");
	  });

	  if (dimRoundingMode != null) {
	    assert(isInt(pad), function () {
	      return "Error in maxPool: pad must be an integer when using, " + ("dimRoundingMode " + dimRoundingMode + " but got pad " + pad + ".");
	    });
	  }

	  var inputs = {
	    x: x4D
	  };
	  var attrs = {
	    filterSize: filterSize,
	    strides: strides,
	    pad: pad,
	    dimRoundingMode: dimRoundingMode
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var res = ENGINE.runKernel(MaxPool, inputs, attrs);

	  if (reshapedTo4D) {
	    return reshape(res, [res.shape[1], res.shape[2], res.shape[3]]);
	  }

	  return res;
	}

	var maxPool = op({
	  maxPool_: maxPool_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the 3D max pooling.
	 *
	 * ```js
	 * const x = tf.tensor5d([1, 2, 3, 4, 5, 6, 7, 8], [1, 2, 2, 2, 1]);
	 * const result = tf.maxPool3d(x, 2, 1, 'valid');
	 * result.print();
	 * ```
	 *
	 * @param x The input tensor, of rank 5 or rank 4 of shape
	 *     `[batch, depth, height, width, inChannels]`.
	 * @param filterSize The filter size:
	 *     `[filterDepth, filterHeight, filterWidth]`.
	 *     If `filterSize` is a single number,
	 *     then `filterDepth == filterHeight == filterWidth`.
	 * @param strides The strides of the pooling:
	 *     `[strideDepth, strideHeight, strideWidth]`.
	 *     If `strides` is a single number,
	 *     then `strideDepth == strideHeight == strideWidth`.
	 * @param pad The type of padding algorithm.
	 *    - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *    - `valid`: output will be smaller than input if filter is larger
	 *       than 1*1x1.
	 *    - For more info, see this guide:
	 *     [https://www.tensorflow.org/api_guides/python/nn#Convolution](
	 *          https://www.tensorflow.org/api_guides/python/nn#Convolution)
	 * @param dimRoundingMode A string from: 'ceil', 'round', 'floor'. If none is
	 *     provided, it will default to truncate.
	 * @param dataFormat An optional string from: "NDHWC", "NCDHW". Defaults to
	 *     "NDHWC". Specify the data format of the input and output data. With the
	 *     default format "NDHWC", the data is stored in the order of: [batch,
	 *     depth, height, width, channels]. Only "NDHWC" is currently supported.
	 * @doc {heading: 'Operations', subheading: 'Convolution'}
	 */

	function maxPool3d_(x, filterSize, strides, pad, dimRoundingMode, dataFormat) {
	  if (filterSize === void 0) {
	    filterSize = [1, 1, 1];
	  }

	  if (dataFormat === void 0) {
	    dataFormat = 'NDHWC';
	  }

	  var $x = convertToTensor(x, 'x', 'maxPool3d');
	  var x5D = $x;
	  var reshapedTo5D = false;

	  if ($x.rank === 4) {
	    reshapedTo5D = true;
	    x5D = reshape($x, [1, $x.shape[0], $x.shape[1], $x.shape[2], $x.shape[3]]);
	  }

	  assert(x5D.rank === 5, function () {
	    return "Error in maxPool3d: x must be rank 5 but got rank " + x5D.rank + ".";
	  });
	  assert(dataFormat === 'NDHWC', function () {
	    return "Error in maxPool3d: Only NDHWC is currently supported, " + ("but got dataFormat of " + dataFormat);
	  });

	  if (dimRoundingMode != null) {
	    assert(isInt(pad), function () {
	      return "Error in maxPool3d: pad must be an integer when using, " + ("dimRoundingMode " + dimRoundingMode + " but got pad " + pad + ".");
	    });
	  }

	  var inputs = {
	    x: x5D
	  };
	  var attrs = {
	    filterSize: filterSize,
	    strides: strides,
	    pad: pad,
	    dimRoundingMode: dimRoundingMode,
	    dataFormat: dataFormat
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var res = ENGINE.runKernel(MaxPool3D, inputs, attrs);

	  if (reshapedTo5D) {
	    return reshape(res, [res.shape[1], res.shape[2], res.shape[3], res.shape[4]]);
	  }

	  return res;
	}

	var maxPool3d = op({
	  maxPool3d_: maxPool3d_
	});

	/**
	 * @license
	 * Copyright 2018 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the 2D max pooling of an image with Argmax index.
	 * The indices in argmax are flattened, so that a maximum value at position `[b,
	 * y, x, c]` becomes flattened index: `(y * width + x) * channels + c` if
	 * include_batch_in_index is False; `((b * height + y) * width + x) * channels
	 * +c` if include_batch_in_index is True.
	 *
	 * The indices returned are always in `[0, height) x [0, width)` before
	 * flattening.
	 *
	 * @param x The input tensor, of rank 4 or rank 3 of shape
	 *     `[batch, height, width, inChannels]`. If rank 3, batch of 1 is assumed.
	 * @param filterSize The filter size: `[filterHeight, filterWidth]`. If
	 *     `filterSize` is a single number, then `filterHeight == filterWidth`.
	 * @param strides The strides of the pooling: `[strideHeight, strideWidth]`. If
	 *     `strides` is a single number, then `strideHeight == strideWidth`.
	 * @param dataFormat An optional string from: "NDHWC", "NCDHW". Defaults to
	 *     "NDHWC". Specify the data format of the input and output data. With the
	 *     default format "NDHWC", the data is stored in the order of: [batch,
	 *     depth, height, width, channels]. Only "NDHWC" is currently supported.
	 * @param pad The type of padding algorithm.
	 *    - `same` and stride 1: output will be of same size as input,
	 *       regardless of filter size.
	 *    - `valid`: output will be smaller than input if filter is larger
	 *       than 1x1.
	 *    - For more info, see this guide:
	 *     [https://www.tensorflow.org/api_guides/python/nn#Convolution](
	 *          https://www.tensorflow.org/api_guides/python/nn#Convolution)
	 * @param includeBatchIndex Defaults to False. Whether to include batch
	 *    dimension in flattened index of argmax.
	 *
	 * @doc {heading: 'Operations', subheading: 'Convolution'}
	 */

	function maxPoolWithArgmax_(x, filterSize, strides, pad, includeBatchInIndex) {
	  if (includeBatchInIndex === void 0) {
	    includeBatchInIndex = false;
	  }

	  var $x = convertToTensor(x, 'x', 'maxPoolWithArgmax');
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    filterSize: filterSize,
	    strides: strides,
	    pad: pad,
	    includeBatchInIndex: includeBatchInIndex
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  var result = ENGINE.runKernel(MaxPoolWithArgmax, inputs, attrs);
	  return {
	    result: result[0],
	    indexes: result[1]
	  };
	}

	var maxPoolWithArgmax = op({
	  maxPoolWithArgmax_: maxPoolWithArgmax_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the max of a and b (`a > b ? a : b`) element-wise.
	 * Supports broadcasting.
	 *
	 * We also expose `tf.maximumStrict` which has the same signature as this op and
	 * asserts that `a` and `b` are the same shape (does not broadcast).
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 4, 3, 16]);
	 * const b = tf.tensor1d([1, 2, 9, 4]);
	 *
	 * a.maximum(b).print();  // or tf.maximum(a, b)
	 * ```
	 *
	 * ```js
	 * // Broadcast maximum a with b.
	 * const a = tf.tensor1d([2, 4, 6, 8]);
	 * const b = tf.scalar(5);
	 *
	 * a.maximum(b).print();  // or tf.maximum(a, b)
	 * ```
	 *
	 * @param a The first tensor.
	 * @param b The second tensor. Must have the same type as `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Arithmetic'}
	 */

	function maximum_(a, b) {
	  var $a = convertToTensor(a, 'a', 'maximum');
	  var $b = convertToTensor(b, 'b', 'maximum');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];

	  if ($a.dtype === 'bool') {
	    $a = cast($a, 'int32');
	    $b = cast($b, 'int32');
	  }

	  assertAndGetBroadcastShape($a.shape, $b.shape);
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(Maximum, inputs);
	}

	var maximum = op({
	  maximum_: maximum_
	});

	/**
	 * @license
	 * Copyright 2020 Google Inc. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the mean of elements across dimensions of a `tf.Tensor`.
	 *
	 * Reduces `x` along the dimensions given in `axis`. Unless `keepDims` is
	 * true, the rank of the `tf.Tensor` is reduced by 1 for each entry in `axis`.
	 * If `keepDims` is true, the reduced dimensions are retained with length 1.
	 * If `axis` has no entries, all dimensions are reduced, and a `tf.Tensor` with
	 * a single element is returned.
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3]);
	 *
	 * x.mean().print();  // or tf.mean(a)
	 * ```
	 *
	 * ```js
	 * const x = tf.tensor2d([1, 2, 3, 4], [2, 2]);
	 *
	 * const axis = 1;
	 * x.mean(axis).print();  // or tf.mean(x, axis)
	 * ```
	 *
	 * @param x The input tensor.
	 * @param axis The dimension(s) to reduce. By default it reduces
	 *     all dimensions.
	 * @param keepDims If true, retains reduced dimensions with size 1.
	 *
	 * @doc {heading: 'Operations', subheading: 'Reduction'}
	 */

	function mean_(x, axis, keepDims) {
	  if (axis === void 0) {
	    axis = null;
	  }

	  if (keepDims === void 0) {
	    keepDims = false;
	  }

	  var $x = convertToTensor(x, 'x', 'mean');
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    axis: axis,
	    keepDims: keepDims
	  };
	  return ENGINE.runKernel(Mean, inputs, attrs);
	}

	var mean = op({
	  mean_: mean_
	});

	/**
	 * @license
	 * Copyright 2020 Google Inc. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes the minimum value from the input.
	 *
	 * Reduces the input along the dimensions given in `axes`. Unless `keepDims`
	 * is true, the rank of the array is reduced by 1 for each entry in `axes`.
	 * If `keepDims` is true, the reduced dimensions are retained with length 1.
	 * If `axes` has no entries, all dimensions are reduced, and an array with a
	 * single element is returned.
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, 3]);
	 *
	 * x.min().print();  // or tf.min(x)
	 * ```
	 *
	 * ```js
	 * const x = tf.tensor2d([1, 2, 3, 4], [2, 2]);
	 *
	 * const axis = 1;
	 * x.min(axis).print();  // or tf.min(x, axis)
	 * ```
	 *
	 * @param x The input Tensor.
	 * @param axis The dimension(s) to reduce. By default it reduces
	 *     all dimensions.
	 * @param keepDims If true, retains reduced dimensions with size 1.
	 *
	 * @doc {heading: 'Operations', subheading: 'Reduction'}
	 */

	function min_(x, axis, keepDims) {
	  if (axis === void 0) {
	    axis = null;
	  }

	  if (keepDims === void 0) {
	    keepDims = false;
	  }

	  var $x = convertToTensor(x, 'x', 'min');
	  var inputs = {
	    x: $x
	  };
	  var attrs = {
	    axis: axis,
	    keepDims: keepDims
	  }; // tslint:disable-next-line: no-unnecessary-type-assertion

	  return ENGINE.runKernel(Min, inputs, attrs);
	}

	var min$9 = op({
	  min_: min_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the min of a and b (`a < b ? a : b`) element-wise.
	 * Supports broadcasting.
	 *
	 * We also expose `minimumStrict` which has the same signature as this op and
	 * asserts that `a` and `b` are the same shape (does not broadcast).
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 4, 3, 16]);
	 * const b = tf.tensor1d([1, 2, 9, 4]);
	 *
	 * a.minimum(b).print();  // or tf.minimum(a, b)
	 * ```
	 *
	 * ```js
	 * // Broadcast minimum a with b.
	 * const a = tf.tensor1d([2, 4, 6, 8]);
	 * const b = tf.scalar(5);
	 *
	 * a.minimum(b).print();  // or tf.minimum(a, b)
	 * ```
	 *
	 * @param a The first tensor.
	 * @param b The second tensor. Must have the same type as `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Arithmetic'}
	 */

	function minimum_(a, b) {
	  var $a = convertToTensor(a, 'a', 'minimum');
	  var $b = convertToTensor(b, 'b', 'minimum');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];

	  if ($a.dtype === 'bool') {
	    $a = cast($a, 'int32');
	    $b = cast($b, 'int32');
	  }

	  assertAndGetBroadcastShape($a.shape, $b.shape);
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(Minimum, inputs);
	}

	var minimum = op({
	  minimum_: minimum_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Pads a `tf.Tensor` using mirror padding.
	 *
	 * This operation implements the `REFLECT` and `SYMMETRIC` modes of pad.
	 *
	 * ```js
	 * const x = tf.range(0, 9).reshape([1, 1, 3, 3]);
	 * x.mirrorPad([[0, 0], [0, 0], [2, 2], [2, 2]], 'reflect').print();
	 * ```
	 * @param x The tensor to pad.
	 * @param paddings An array of length `R` (the rank of the tensor), where
	 * each element is a length-2 tuple of ints `[padBefore, padAfter]`,
	 * specifying how much to pad along each dimension of the tensor.
	 * In "reflect" mode, the padded regions do not include the borders,
	 * while in "symmetric" mode the padded regions do include the borders.
	 * For example, if the input is `[1, 2, 3]` and paddings is `[0, 2]`,
	 * then the output is `[1, 2, 3, 2, 1]` in "reflect" mode, and
	 * `[1, 2, 3, 3, 2]` in "symmetric" mode.
	 * If `mode` is "reflect" then both `paddings[D, 0]` and `paddings[D, 1]`
	 * must be no greater than `x.shape[D] - 1`. If mode is "symmetric"
	 * then both `paddings[D, 0]` and `paddings[D, 1]` must be no greater than
	 * `x.shape[D]`
	 * @param mode String to specify padding mode. Can be `'reflect' | 'symmetric'`
	 */

	/** @doc {heading: 'Tensors', subheading: 'Transformations'} */

	function mirrorPad_(x, paddings, mode) {
	  assert(mode === 'reflect' || mode === 'symmetric', function () {
	    return "Invalid mode. Mode must be either reflect or symmetric. " + ("Got " + mode + ".");
	  });
	  var $x = convertToTensor(x, 'x', 'mirrorPad');

	  if ($x.rank === 0) {
	    throw new Error('mirrorPad(scalar) is not defined. ' + 'Pass non-scalar to mirrorPad');
	  }

	  assert(paddings.length === $x.rank, function () {
	    return "Padding doesn't match input. Must be " + $x.rank + ". " + ("Got " + paddings.length + ".");
	  });
	  var shapeOffset = mode === 'reflect' ? 1 : 0;

	  var _loop = function _loop(i) {
	    assert(paddings[i].length === 2, function () {
	      return "Invalid number of paddings. Must be length of 2 each.";
	    });
	    assert(paddings[i][0] >= 0 && paddings[i][0] <= $x.shape[i] - shapeOffset && paddings[i][1] >= 0 && paddings[i][1] <= $x.shape[i] - shapeOffset, function () {
	      return "Padding in dimension " + i + " cannot be greater than or equal " + ("to " + ($x.shape[i] - shapeOffset) + " or less than 0 for input of ") + ("shape " + $x.shape);
	    });
	  };

	  for (var i = 0; i < $x.rank; i++) {
	    _loop(i);
	  }

	  var attrs = {
	    paddings: paddings,
	    mode: mode
	  };
	  var inputs = {
	    x: $x
	  };
	  return ENGINE.runKernel(MirrorPad, inputs, attrs);
	}

	var mirrorPad = op({
	  mirrorPad_: mirrorPad_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Returns the mod of a and b element-wise.
	 * `floor(x / y) * y + mod(x, y) = x`
	 * Supports broadcasting.
	 *
	 * We also expose `tf.modStrict` which has the same signature as this op and
	 * asserts that `a` and `b` are the same shape (does not broadcast).
	 *
	 * ```js
	 * const a = tf.tensor1d([1, 4, 3, 16]);
	 * const b = tf.tensor1d([1, 2, 9, 4]);
	 *
	 * a.mod(b).print();  // or tf.mod(a, b)
	 * ```
	 *
	 * ```js
	 * // Broadcast a mod b.
	 * const a = tf.tensor1d([2, 4, 6, 8]);
	 * const b = tf.scalar(5);
	 *
	 * a.mod(b).print();  // or tf.mod(a, b)
	 * ```
	 *
	 * @param a The first tensor.
	 * @param b The second tensor. Must have the same type as `a`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Arithmetic'}
	 */

	function mod_(a, b) {
	  var $a = convertToTensor(a, 'a', 'mod');
	  var $b = convertToTensor(b, 'b', 'mod');

	  var _makeTypesMatch = makeTypesMatch($a, $b);

	  $a = _makeTypesMatch[0];
	  $b = _makeTypesMatch[1];
	  var inputs = {
	    a: $a,
	    b: $b
	  };
	  return ENGINE.runKernel(Mod, inputs);
	}

	var mod = op({
	  mod_: mod_
	});

	/**
	 * @license
	 * Copyright 2019 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Computes square of `x` element-wise: `x ^ 2`
	 *
	 * ```js
	 * const x = tf.tensor1d([1, 2, Math.sqrt(2), -1]);
	 *
	 * x.square().print();  // or tf.square(x)
	 * ```
	 * @param x The input Tensor.
	 *
	 * @doc {heading: 'Operations', subheading: 'Basic math'}
	 */

	function square_(x) {
	  var $x = convertToTensor(x, 'x', 'square');
	  var attrs = {};
	  return ENGINE.runKernel('Square', {
	    x: $x
	  }, attrs);
	}

	var square = op({
	  square_: square_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Calculates the mean and variance of `x`. The mean and variance are
	 * calculated by aggregating the contents of `x` across `axes`. If `x` is
	 * 1-D and `axes = [0]` this is just the mean and variance of a vector.
	 *
	 * @param x The input tensor.
	 * @param axis The dimension(s) along with to compute mean and
	 *     variance. By default it reduces all dimensions.
	 * @param keepDims If true, the moments have the same dimensionality as the
	 *     input.
	 * @return An object with two keys: `mean` and `variance`.
	 *
	 * @doc {heading: 'Operations', subheading: 'Normalization'}
	 */

	function moments_(x, axis, keepDims) {
	  if (axis === void 0) {
	    axis = null;
	  }

	  if (keepDims === void 0) {
	    keepDims = false;
	  }

	  x = convertToTensor(x, 'x', 'moments');
	  var axes = parseAxisParam(axis, x.shape);
	  var xMean = mean(x, axes, keepDims);
	  var keepDimsShape = xMean.shape;

	  if (!keepDims) {
	    keepDimsShape = expandShapeToKeepDim(xMean.shape, axes);
	  }

	  var devSquared = square(sub(cast(x, 'float32'), reshape(xMean, keepDimsShape)));
	  var variance = mean(devSquared, axes, keepDims);
	  return {
	    mean: xMean,
	    variance: variance
	  };
	}

	var moments = op({
	  moments_: moments_
	});

	/**
	 * Computes the next states and outputs of a stack of LSTMCells.
	 *
	 * Each cell output is used as input to the next cell.
	 *
	 * Returns `[cellState, cellOutput]`.
	 *
	 * Derived from tf.contrib.rn.MultiRNNCell.
	 *
	 * @param lstmCells Array of LSTMCell functions.
	 * @param data The input to the cell.
	 * @param c Array of previous cell states.
	 * @param h Array of previous cell outputs.
	 *
	 * @doc {heading: 'Operations', subheading: 'RNN'}
	 */

	function multiRNNCell_(lstmCells, data, c, h) {
	  var $data = convertToTensor(data, 'data', 'multiRNNCell');
	  var $c = convertToTensorArray(c, 'c', 'multiRNNCell');
	  var $h = convertToTensorArray(h, 'h', 'multiRNNCell');
	  var input = $data;
	  var newStates = [];

	  for (var i = 0; i < lstmCells.length; i++) {
	    var output = lstmCells[i](input, $c[i], $h[i]);
	    newStates.push(output[0]);
	    newStates.push(output[1]);
	    input = output[1];
	  }

	  var newC = [];
	  var newH = [];

	  for (var _i = 0; _i < newStates.length; _i += 2) {
	    newC.push(newStates[_i]);
	    newH.push(newStates[_i + 1]);
	  }

	  return [newC, newH];
	}

	var multiRNNCell = op({
	  multiRNNCell_: multiRNNCell_
	});

	/**
	 * @license
	 * Copyright 2020 Google LLC. All Rights Reserved.
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 * http://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 * =============================================================================
	 */
	/**
	 * Creates a `tf.Tensor` with values drawn from a multinomial distribution.
	 *
	 * ```js
	 * const probs = tf.tensor([.75, .25]);
	 * tf.multinomial(probs, 3).print();
	 * ```
	 *
	 * @param logits 1D array with unnormalized log-probabilities, or
	 *     2D array of shape `[batchSize, numOutcomes]`. See the `normalized`
	 *     parameter.
	 * @param numSamples Number of samples to draw for each row slice.
	 * @param seed The seed number.
	 * @param normalized Whether the provided `logits` are n