/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
class e{constructor(e,t){this.backend=e,this.dataMover=t,this.data=new WeakMap,this.dataIdsCount=0}get(e){return this.data.has(e)||this.dataMover.moveData(this.backend,e),this.data.get(e)}set(e,t){this.dataIdsCount++,this.data.set(e,t)}has(e){return this.data.has(e)}delete(e){return this.dataIdsCount--,this.data.delete(e)}numDataIds(){return this.dataIdsCount}}class t{refCount(e){return n("refCount")}incRef(e){return n("incRef")}timerAvailable(){return!0}time(e){return n("time")}read(e){return n("read")}readSync(e){return n("readSync")}numDataIds(){return n("numDataIds")}disposeData(e,t){return n("disposeData")}write(e,t,s){return n("write")}move(e,t,s,r,a){return n("move")}memory(){return n("memory")}floatPrecision(){return n("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return n("dispose")}}function n(e){throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function s(e){let t=e.length,n=0,s=0;for(;t>0;)s=Math.random()*t|0,t--,n=e[t],e[t]=e[s],e[s]=n}function r(e,t,n){return Math.max(e,Math.min(t,n))}function a(e){return e%2==0?e:e+1}function i(e){let t=0;for(let n=0;n<e.length;n++)t+=e[n];return t}function o(e,t){if(!e)throw new Error("string"==typeof t?t:t())}function l(e,t,n=""){o(p(e,t),()=>n+` Shapes ${e} and ${t} must match`)}function u(e){o(null!=e,()=>"The input to the tensor constructor must be a non-null value.")}function c(e,t=[],n=!1){if(null==t&&(t=[]),Array.isArray(e)||C(e)&&!n)for(let s=0;s<e.length;++s)c(e[s],t,n);else t.push(e);return t}function h(e){if(0===e.length)return 1;let t=e[0];for(let n=1;n<e.length;n++)t*=e[n];return t}function p(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function d(e){return e%1==0}function f(e){const t=Math.ceil(Math.sqrt(e));return[t,Math.ceil(e/t)]}function m(e,t){return t<=e.length?e:e+" ".repeat(t-e.length)}function g(e,t=(e=>0),n){return new Promise((s,r)=>{let a=0;const i=()=>{if(e())return void s();a++;const o=t(a);null!=n&&a>=n?r():setTimeout(i,o)};i()})}function y(e,t){let n=1,s=-1;for(let t=0;t<e.length;++t)if(e[t]>=0)n*=e[t];else if(-1===e[t]){if(-1!==s)throw Error(`Shapes can only have 1 implicit size. Found -1 at dim ${s} and dim ${t}`);s=t}else if(e[t]<0)throw Error(`Shapes can not be < 0. Found ${e[t]} at dim ${t}`);if(-1===s){if(t>0&&t!==n)throw Error(`Size(${t}) must match the product of shape ${e}`);return e}if(0===n)throw Error(`Cannot infer the missing size in [${e}] when there are 0 elements`);if(t%n!=0)throw Error(`The implicit shape can't be a fractional number. Got ${t} / ${n}`);const r=e.slice();return r[s]=t/n,r}function b(e,t){const n=t.length;return o((e=null==e?t.map((e,t)=>t):[].concat(e)).every(e=>e>=-n&&e<n),()=>`All values in axis param must be in range [-${n}, ${n}) but got axis `+e),o(e.every(e=>d(e)),()=>"All values in axis param must be integers but got axis "+e),e.map(e=>e<0?n+e:e)}function x(e,t){const n=[],s=[],r=null!=t&&Array.isArray(t)&&0===t.length,a=null==t||r?null:b(t,e).sort();let i=0;for(let t=0;t<e.length;++t){if(null!=a){if(a[i]===t&&1!==e[t])throw new Error(`Can't squeeze axis ${t} since its dim '${e[t]}' is not 1`);(null==a[i]||a[i]>t)&&1===e[t]&&(n.push(e[t]),s.push(t)),a[i]<=t&&i++}1!==e[t]&&(n.push(e[t]),s.push(t))}return{newShape:n,keptDims:s}}function w(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else{if("bool"!==e)throw new Error("Unknown data type "+e);n=new Uint8Array(t)}return n}function k(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else if("bool"===e)n=new Uint8Array(t);else{if("string"!==e)throw new Error("Unknown data type "+e);n=new Array(t)}return n}function v(e,t){for(let n=0;n<e.length;n++){const s=e[n];if(isNaN(s)||!isFinite(s))throw Error(`A tensor of type ${t} being uploaded contains ${s}.`)}}function N(e){return"bool"===e||"complex64"===e||"float32"===e||"int32"===e||"string"===e}function I(e,t){return"complex64"!==t&&(("float32"!==t||"complex64"===e)&&(("int32"!==t||"float32"===e||"complex64"===e)&&("bool"!==t||"bool"!==e)))}function C(e){return e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array}function S(e){if("float32"===e||"int32"===e)return 4;if("complex64"===e)return 8;if("bool"===e)return 1;throw new Error("Unknown dtype "+e)}function T(e){if(null==e)return 0;let t=0;return e.forEach(e=>t+=e.length),t}function E(e){return"string"==typeof e||e instanceof String}function $(e){return"boolean"==typeof e}function A(e){return"number"==typeof e}function R(e){return Array.isArray(e)?R(e[0]):e instanceof Float32Array?"float32":e instanceof Int32Array||e instanceof Uint8Array?"int32":A(e)?"float32":E(e)?"string":$(e)?"bool":"float32"}function F(e){return!!(e&&e.constructor&&e.call&&e.apply)}function D(e,t){for(let n=t;n<e;++n)if(e%n==0)return n;return e}function _(e){const t=e.length;if(t<2)return[];const n=new Array(t-1);n[t-2]=e[t-1];for(let s=t-3;s>=0;--s)n[s]=n[s+1]*e[s+1];return n}function O(e,t){if(0===e.length)return t[0];const n=e.reduce((e,t)=>e*t);if(0===n)return[];if(n!==t.length)throw new Error(`[${e}] does not match the input size ${t.length}.`);return function e(t,n,s){const r=new Array;if(1===n.length){const e=n[0];for(let n=0;n<e;n++)r[n]=s[t+n]}else{const a=n[0],i=n.slice(1),o=i.reduce((e,t)=>e*t);for(let n=0;n<a;n++)r[n]=e(t+n*o,i,s)}return r}(0,e,t)}function M(e,t){const n=L(e,t);for(let e=0;e<n.length;e++)n[e]=1;return n}function L(e,t){if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t)return new Uint8Array(e);throw new Error("Unknown data type "+t)}function z(e,t){const n=e.reduce((e,t)=>e*t,1);if(null==t||"float32"===t)return O(e,new Float32Array(n));if("int32"===t)return O(e,new Int32Array(n));if("bool"===t)return O(e,new Uint8Array(n));throw new Error("Unknown data type "+t)}function B(e){e.forEach(t=>{o(Number.isInteger(t)&&t>=0,()=>`Tensor must have a shape comprised of positive integers but got shape [${e}].`)})}function P(e,t,n){if(0===t)return 0;if(1===t)return e[0];let s=e[e.length-1];for(let t=0;t<e.length-1;++t)s+=n[t]*e[t];return s}function W(e,t,n){if(0===t)return[];if(1===t)return[e];const s=new Array(t);for(let t=0;t<s.length-1;++t)s[t]=Math.floor(e/n[t]),e-=s[t]*n[t];return s[s.length-1]=e,s}function V(e){return e&&e.then&&"function"==typeof e.then}class U{constructor(e){this.global=e,this.flags={},this.flagRegistry={},this.urlFlags={},this.populateURLFlags()}setPlatform(e,t){null!=this.platform&&console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${t}.`),this.platformName=e,this.platform=t}registerFlag(e,t,n){if(this.flagRegistry[e]={evaluationFn:t,setHook:n},null!=this.urlFlags[e]){const t=this.urlFlags[e];console.warn(`Setting feature override from URL ${e}: ${t}.`),this.set(e,t)}}async getAsync(e){return e in this.flags||(this.flags[e]=await this.evaluateFlag(e)),this.flags[e]}get(e){if(e in this.flags)return this.flags[e];const t=this.evaluateFlag(e);if(V(t))throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[e]=t,this.flags[e]}getNumber(e){return this.get(e)}getBool(e){return this.get(e)}getFlags(){return this.flags}get features(){return this.flags}set(e,t){if(null==this.flagRegistry[e])throw new Error(`Cannot set flag ${e} as it has not been registered.`);this.flags[e]=t,null!=this.flagRegistry[e].setHook&&this.flagRegistry[e].setHook(t)}evaluateFlag(e){if(null==this.flagRegistry[e])throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);return this.flagRegistry[e].evaluationFn()}setFlags(e){this.flags=Object.assign({},e)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if(void 0===this.global||void 0===this.global.location||void 0===this.global.location.search)return;const e=function(e){const t={};return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,(e,...n)=>(function(e,t,n){e[decodeURIComponent(t)]=decodeURIComponent(n||"")}(t,n[0],n[1]),n.join("="))),t}(this.global.location.search);if("tfjsflags"in e){e.tfjsflags.split(",").forEach(e=>{const[t,n]=e.split(":");this.urlFlags[t]=function(e,t){if("true"===(t=t.toLowerCase())||"false"===t)return"true"===t;if(""+ +t===t)return+t;throw new Error(`Could not parse value flag value ${t} for flag ${e}.`)}(t,n)})}}}function G(){return j}let H,j=null;function q(){if(null==H){let e;if("undefined"!=typeof window)e=window;else if("undefined"!=typeof global)e=global;else if("undefined"!=typeof process)e=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");e=self}H=e}return H}function K(e,t){const n=function(){const e=q();return null==e._tfGlobals&&(e._tfGlobals=new Map),e._tfGlobals}();if(n.has(e))return n.get(e);{const s=t();return n.set(e,s),n.get(e)}}const X="Abs",Y="Acos",J="Acosh",Z="Add",Q="AddN",ee="All",te="Any",ne="ArgMax",se="ArgMin",re="Asin",ae="Asinh",ie="Atan",oe="Atanh",le="Atan2",ue="AvgPool",ce="AvgPoolGrad",he="AvgPool3D",pe="AvgPool3DGrad",de="BatchMatMul",fe="BatchToSpaceND",me="Bincount",ge="BroadcastTo",ye="Cast",be="Ceil",xe="ClipByValue",we="Complex",ke="ComplexAbs",ve="Concat",Ne="Conv2D",Ie="Conv2DBackpropFilter",Ce="Conv2DBackpropInput",Se="Conv3D",Te="Conv3DBackpropFilterV2",Ee="Conv3DBackpropInputV2",$e="Cos",Ae="Cosh",Re="Cumsum",Fe="CropAndResize",De="DenseBincount",_e="DepthToSpace",Oe="DepthwiseConv2dNative",Me="DepthwiseConv2dNativeBackpropFilter",Le="DepthwiseConv2dNativeBackpropInput",ze="Diag",Be="Dilation2D",Pe="Dilation2DBackpropInput",We="Dilation2DBackpropFilter",Ve="RealDiv",Ue="Elu",Ge="EluGrad",He="Erf",je="Equal",qe="Exp",Ke="ExpandDims",Xe="Expm1",Ye="FFT",Je="Fill",Ze="FlipLeftRight",Qe="Floor",et="FloorDiv",tt="FusedBatchNorm",nt="GatherV2",st="GatherNd",rt="Greater",at="GreaterEqual",it="Identity",ot="IFFT",lt="Imag",ut="IsFinite",ct="IsInf",ht="IsNan",pt="LeakyRelu",dt="Less",ft="LessEqual",mt="LinSpace",gt="Log",yt="Log1p",bt="LogicalAnd",xt="LogicalNot",wt="LogicalOr",kt="LogSoftmax",vt="LRN",Nt="LRNGrad",It="Max",Ct="Maximum",St="MaxPool",Tt="MaxPoolGrad",Et="MaxPool3D",$t="MaxPool3DGrad",At="MaxPoolWithArgmax",Rt="Mean",Ft="Min",Dt="Minimum",_t="MirrorPad",Ot="Mod",Mt="Multinomial",Lt="Multiply",zt="Neg",Bt="NotEqual",Pt="NonMaxSuppressionV3",Wt="NonMaxSuppressionV4",Vt="NonMaxSuppressionV5",Ut="OnesLike",Gt="OneHot",Ht="Pack",jt="PadV2",qt="Pool",Kt="Pow",Xt="Prelu",Yt="Prod",Jt="Range",Zt="Real",Qt="Reciprocal",en="Relu",tn="Reshape",nn="ResizeNearestNeighbor",sn="ResizeNearestNeighborGrad",rn="ResizeBilinear",an="ResizeBilinearGrad",on="Relu6",ln="Reverse",un="Round",cn="Rsqrt",hn="ScatterNd",pn="Select",dn="Selu",fn="Slice",mn="Sin",gn="Sinh",yn="Sign",bn="Sigmoid",xn="Softplus",wn="Sqrt",kn="Sum",vn="SpaceToBatchND",Nn="SplitV",In="Softmax",Cn="SquaredDifference",Sn="Square",Tn="Sub",En="SparseToDense",$n="StridedSlice",An="Tan",Rn="Tanh",Fn="Tile",Dn="TopK",_n="Transpose",On="Unique",Mn="Unpack",Ln="UnsortedSegmentSum",zn="ZerosLike",Bn="Step",Pn="FromPixels",Wn="RotateWithOffset",Vn="_FusedMatMul",Un="FusedConv2D",Gn="FusedDepthwiseConv2D",Hn=K("kernelRegistry",()=>new Map),jn=K("gradRegistry",()=>new Map);function qn(e,t){const n=ts(e,t);return Hn.get(n)}function Kn(e){return jn.get(e)}function Xn(e){const t=Hn.entries(),n=[];for(;;){const{done:s,value:r}=t.next();if(s)break;const[a,i]=r,[o]=a.split("_");o===e&&n.push(i)}return n}function Yn(e){const{kernelName:t,backendName:n}=e,s=ts(t,n);Hn.has(s)&&console.warn(`The kernel '${t}' for backend '${n}' is already registered`),Hn.set(s,e)}function Jn(e){const{kernelName:t}=e;jn.has(t)&&G().getBool("DEBUG")&&console.warn(`Overriding the gradient for '${t}'`),jn.set(t,e)}function Zn(e,t){const n=ts(e,t);if(!Hn.has(n))throw new Error(`The kernel '${e}' for backend '${t}' is not registered`);Hn.delete(n)}function Qn(e){if(!jn.has(e))throw new Error(`The gradient '${e}' for backend is not registered`);jn.delete(e)}function es(e,t){Xn(e).forEach(e=>{Yn(Object.assign({},e,{backendName:t}))})}function ts(e,t){return`${t}_${e}`}function ns(e,t){return"string"===t?is(e):ss([e],t)}function ss(e,t){if("string"===t)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(e)&&(e=c(e)),G().getBool("DEBUG")&&v(e,t),function(e,t){return e instanceof Float32Array&&"float32"===t||e instanceof Int32Array&&"int32"===t||e instanceof Uint8Array&&"bool"===t}(e,t))return e;if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t){const t=new Uint8Array(e.length);for(let n=0;n<t.length;++n)0!==Math.round(e[n])&&(t[n]=1);return t}throw new Error("Unknown data type "+t)}function rs(){return G().platform.now()}function as(e,t){return G().platform.fetch(e,t)}function is(e,t="utf-8"){return t=t||"utf-8",G().platform.encode(e,t)}function os(e,t="utf-8"){return t=t||"utf-8",G().platform.decode(e,t)}var ls=Object.freeze({__proto__:null,createScalarValue:ns,toTypedArray:ss,now:rs,fetch:as,encodeString:is,decodeString:os,shuffle:s,shuffleCombo:function(e,t){if(e.length!==t.length)throw new Error("Array sizes must match to be shuffled together First array length was "+e.length+"Second array length was "+t.length);let n,s,r=e.length,a=0;for(;r>0;)a=Math.random()*r|0,r--,n=e[r],s=t[r],e[r]=e[a],t[r]=t[a],e[a]=n,t[a]=s},clamp:r,nearestLargerEven:a,sum:i,randUniform:function(e,t){const n=Math.random();return t*n+(1-n)*e},distSquared:function(e,t){let n=0;for(let s=0;s<e.length;s++){const r=Number(e[s])-Number(t[s]);n+=r*r}return n},assert:o,assertShapesMatch:l,assertNonNull:u,flatten:c,sizeFromShape:h,isScalarShape:function(e){return 0===e.length},arraysEqual:p,isInt:d,tanh:function(e){if(null!=Math.tanh)return Math.tanh(e);if(e===1/0)return 1;if(e===-1/0)return-1;{const t=Math.exp(2*e);return(t-1)/(t+1)}},sizeToSquarishShape:f,createShuffledIndices:function(e){const t=new Uint32Array(e);for(let n=0;n<e;++n)t[n]=n;return s(t),t},rightPad:m,repeatedTry:g,inferFromImplicitShape:y,parseAxisParam:b,squeezeShape:x,getTypedArrayFromDType:w,getArrayFromDType:k,checkConversionForErrors:v,isValidDtype:N,hasEncodingLoss:I,isTypedArray:C,bytesPerElement:S,bytesFromStringArray:T,isString:E,isBoolean:$,isNumber:A,inferDtype:R,isFunction:F,nearestDivisor:D,computeStrides:_,toNestedArray:O,makeOnesTypedArray:M,makeZerosTypedArray:L,makeZerosNestedTypedArray:z,assertNonNegativeIntegerDimensions:B,locToIndex:P,indexToLoc:W,isPromise:V});class us{constructor(e,t){this.backendTimer=e,this.logger=t,null==t&&(this.logger=new hs)}profileKernel(e,t,n){let s;const r=()=>{s=n()};let a;const i=rs();if(this.backendTimer.timerAvailable())a=this.backendTimer.time(r);else{r();for(const e of s)e.dataSync();a=Promise.resolve({kernelMs:rs()-i})}if(G().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let t=0;t<s.length;t++){const n=s[t];n.data().then(t=>{cs(t,n.dtype,e)})}return{kernelName:e,outputs:s,inputs:t,timeMs:a.then(e=>e.kernelMs),extraInfo:a.then(e=>null!=e.getExtraProfileInfo?e.getExtraProfileInfo():"")}}logKernelProfile(e){const{kernelName:t,outputs:n,timeMs:s,inputs:r,extraInfo:a}=e;n.forEach(e=>{Promise.all([e.data(),s,a]).then(n=>{this.logger.logKernelProfile(t,e,n[0],n[1],r,n[2])})})}}function cs(e,t,n){if("float32"!==t)return!1;for(let t=0;t<e.length;t++){const s=e[t];if(isNaN(s)||!isFinite(s))return console.warn(`Found ${s} in the result of '${n}'`),!0}return!1}class hs{logKernelProfile(e,t,n,s,r,a){const i="number"==typeof s?m(s+"ms",9):s.error,o=m(e,25),l=t.rank,u=t.size,c=m(t.shape.toString(),14);let h="";for(const e in r){const n=r[e];if(null!=n){const s=n.shape||t.shape,r=s.length;h+=`${e}: ${r}D ${r>0?s:""} `}}console.log(`%c${o}\t%c${i}\t%c${l}D ${c}\t%c${u}\t%c${h}\t%c${a}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function ps(e,t,n,s){const r=_(t),a=function(e,t,n,s){const r=h(t),a=s[s.length-1],i=new Array(a).fill(0),o=t.length,l="complex64"===n?ms(e):e;if(o>1)for(let e=0;e<r/a;e++){const t=e*a;for(let e=0;e<a;e++)i[e]=Math.max(i[e],ds(l[t+e],0,n).length)}return i}(e,t,n,r),i=t.length,o=function e(t,n,s,r,a,i=!0){const o="complex64"===s?2:1,l=n[0],u=n.length;if(0===u){if("complex64"===s){return[ds(ms(t)[0],0,s)]}return"bool"===s?[fs(t[0])]:[t[0].toString()]}if(1===u){if(l>20){const e=3*o;let n=Array.from(t.slice(0,e)),r=Array.from(t.slice((l-3)*o,l*o));return"complex64"===s&&(n=ms(n),r=ms(r)),["["+n.map((e,t)=>ds(e,a[t],s)).join(", ")+", ..., "+r.map((e,t)=>ds(e,a[l-3+t],s)).join(", ")+"]"]}return["["+("complex64"===s?ms(t):Array.from(t)).map((e,t)=>ds(e,a[t],s)).join(", ")+"]"]}const c=n.slice(1),h=r.slice(1),p=r[0]*o,d=[];if(l>20){for(let n=0;n<3;n++){const r=n*p,i=r+p;d.push(...e(t.slice(r,i),c,s,h,a,!1))}d.push("...");for(let n=l-3;n<l;n++){const r=n*p,i=r+p;d.push(...e(t.slice(r,i),c,s,h,a,n===l-1))}}else for(let n=0;n<l;n++){const r=n*p,i=r+p;d.push(...e(t.slice(r,i),c,s,h,a,n===l-1))}const f=2===u?",":"";d[0]="["+d[0]+f;for(let e=1;e<d.length-1;e++)d[e]=" "+d[e]+f;let m=",\n";for(let e=2;e<u;e++)m+="\n";return d[d.length-1]=" "+d[d.length-1]+"]"+(i?"":m),d}(e,t,n,r,a),l=["Tensor"];return s&&(l.push("  dtype: "+n),l.push("  rank: "+i),l.push(`  shape: [${t}]`),l.push("  values:")),l.push(o.map(e=>"    "+e).join("\n")),l.join("\n")}function ds(e,t,n){let s;return s=Array.isArray(e)?parseFloat(e[0].toFixed(7))+" + "+parseFloat(e[1].toFixed(7))+"j":E(e)?`'${e}'`:"bool"===n?fs(e):parseFloat(e.toFixed(7)).toString(),m(s,t)}function fs(e){return 0===e?"false":"true"}function ms(e){const t=[];for(let n=0;n<e.length;n+=2)t.push([e[n],e[n+1]]);return t}class gs{constructor(e,t,n){if(this.dtype=t,this.shape=e.slice(),this.size=h(e),null!=n){const e=n.length;o(e===this.size,()=>`Length of values '${e}' does not match the size inferred by the shape '${this.size}'.`)}if("complex64"===t)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||k(t,this.size),this.strides=_(e)}set(e,...t){0===t.length&&(t=[0]),o(t.length===this.rank,()=>`The number of provided coordinates (${t.length}) must match the rank (${this.rank})`);const n=this.locToIndex(t);this.values[n]=e}get(...e){0===e.length&&(e=[0]);let t=0;for(const n of e){if(n<0||n>=this.shape[t]){const t=`Requested out of range element at ${e}.   Buffer shape=`+this.shape;throw new Error(t)}t++}let n=e[e.length-1];for(let t=0;t<e.length-1;++t)n+=this.strides[t]*e[t];return this.values[n]}locToIndex(e){if(0===this.rank)return 0;if(1===this.rank)return e[0];let t=e[e.length-1];for(let n=0;n<e.length-1;++n)t+=this.strides[n]*e[n];return t}indexToLoc(e){if(0===this.rank)return[];if(1===this.rank)return[e];const t=new Array(this.shape.length);for(let n=0;n<t.length-1;++n)t[n]=Math.floor(e/this.strides[n]),e-=t[n]*this.strides[n];return t[t.length-1]=e,t}get rank(){return this.shape.length}toTensor(){return ys().makeTensor(this.values,this.shape,this.dtype)}}let ys=null,bs=null,xs=null;class ws{constructor(e,t,n,s){this.kept=!1,this.isDisposedInternal=!1,this.shape=e.slice(),this.dtype=t||"float32",this.size=h(e),this.strides=_(e),this.dataId=n,this.id=s,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const e=await this.data();return bs.buffer(this.shape,this.dtype,e)}bufferSync(){return bs.buffer(this.shape,this.dtype,this.dataSync())}async array(){const e=await this.data();return O(this.shape,e)}arraySync(){return O(this.shape,this.dataSync())}async data(){this.throwIfDisposed();const e=ys().read(this.dataId);if("string"===this.dtype){const t=await e;try{return t.map(e=>os(e))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return e}dataSync(){this.throwIfDisposed();const e=ys().readSync(this.dataId);if("string"===this.dtype)try{return e.map(e=>os(e))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return e}async bytes(){this.throwIfDisposed();const e=await ys().read(this.dataId);return"string"===this.dtype?e:new Uint8Array(e.buffer)}dispose(){this.isDisposed||(ys().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(e=!1){return bs.print(this,e)}clone(){return this.throwIfDisposed(),bs.clone(this)}toString(e=!1){return ps(this.dataSync(),this.shape,this.dtype,e)}cast(e){return this.throwIfDisposed(),bs.cast(this,e)}variable(e=!0,t,n){return this.throwIfDisposed(),ys().makeVariable(this,e,t,n)}}function ks(){return K("Tensor",()=>ws)}Object.defineProperty(ws,Symbol.hasInstance,{value:e=>!!e&&null!=e.data&&null!=e.dataSync&&null!=e.throwIfDisposed}),ks();class vs extends ws{constructor(e,t,n,s){super(e.shape,e.dtype,e.dataId,s),this.trainable=t,this.name=n}assign(e){if(e.dtype!==this.dtype)throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);if(!p(e.shape,this.shape))throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);ys().disposeTensor(this),this.dataId=e.dataId,ys().incRef(this,null)}dispose(){ys().disposeVariable(this),this.isDisposedInternal=!0}}var Ns,Is,Cs,Ss,Ts;Object.defineProperty(vs,Symbol.hasInstance,{value:e=>e instanceof ws&&null!=e.assign&&e.assign instanceof Function}),function(e){e.R0="R0",e.R1="R1",e.R2="R2",e.R3="R3",e.R4="R4",e.R5="R5",e.R6="R6"}(Ns||(Ns={})),function(e){e.float32="float32",e.int32="int32",e.bool="int32",e.complex64="complex64"}(Is||(Is={})),function(e){e.float32="float32",e.int32="int32",e.bool="bool",e.complex64="complex64"}(Cs||(Cs={})),function(e){e.float32="float32",e.int32="float32",e.bool="float32",e.complex64="complex64"}(Ss||(Ss={})),function(e){e.float32="complex64",e.int32="complex64",e.bool="complex64",e.complex64="complex64"}(Ts||(Ts={}));const Es={float32:Ss,int32:Is,bool:Cs,complex64:Ts};function $s(e,t){if("string"===e||"string"===t){if("string"===e&&"string"===t)return"string";throw new Error(`Can not upcast ${e} with ${t}`)}return Es[e][t]}function As(e){return $s(e,"int32")}function Rs(e,t){if(e.dtype===t.dtype)return[e,t];const n=$s(e.dtype,t.dtype);return[e.cast(n),t.cast(n)]}function Fs(e,t){o(e.dtype===t.dtype,()=>`The dtypes of the first(${e.dtype}) and second(${t.dtype}) input must match`)}function Ds(e,t){return t.some(t=>t.id===e.id)}function _s(e){const t=[];return function e(t,n,s){if(null==t)return;if(t instanceof ws)return void n.push(t);if(r=t,!Array.isArray(r)&&"object"!=typeof r)return;var r;const a=t;for(const t in a){const r=a[t];s.has(r)||(s.add(r),e(r,n,s))}}(e,t,new Set),t}var Os=Object.freeze({__proto__:null,makeTypesMatch:Rs,assertTypesMatch:Fs,isTensorInList:Ds,getTensorsInContainer:_s});function Ms(e){return null!=e.kernelName}class Ls{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map(e=>e.name)))}}}dispose(){for(const e in this.registeredVariables)this.registeredVariables[e].dispose()}}class zs{constructor(e){this.ENV=e,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new Ls}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then(()=>{});if(null!=this.backendInstance)return;const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:e,asyncInit:t}=this.initializeBackendsAndReturnBest();if(t)throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(e)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(e){if(!(e in this.registry)){if(!(e in this.registryFactory))return null;{const{asyncInit:t}=this.initializeBackend(e);if(t)return null}}return this.registry[e]}findBackendFactory(e){return e in this.registryFactory?this.registryFactory[e].factory:null}registerBackend(e,t,n=1){return e in this.registryFactory?(console.warn(e+" backend was already registered. Reusing existing backend factory."),!1):(this.registryFactory[e]={factory:t,priority:n},!0)}async setBackend(e){if(null==this.registryFactory[e])throw new Error(`Backend name '${e}' not found in registry`);if(this.backendName=e,null==this.registry[e]){this.backendInstance=null;const{success:t,asyncInit:n}=this.initializeBackend(e);if(!(n?await t:t))return!1}return this.backendInstance=this.registry[e],this.setupRegisteredKernels(),this.profiler=new us(this.backendInstance),!0}setupRegisteredKernels(){Xn(this.backendName).forEach(e=>{null!=e.setupFunc&&e.setupFunc(this.backendInstance)})}disposeRegisteredKernels(e){Xn(e).forEach(t=>{null!=t.disposeFunc&&t.disposeFunc(this.registry[e])})}initializeBackend(e){const n=this.registryFactory[e];if(null==n)throw new Error(`Cannot initialize backend ${e}, no registration found.`);try{const s=n.factory();if(!s||s instanceof t||"function"!=typeof s.then)return this.registry[e]=s,{success:!0,asyncInit:!1};{const t=++this.pendingBackendInitId,n=s.then(n=>!(t<this.pendingBackendInitId)&&(this.registry[e]=n,this.pendingBackendInit=null,!0)).catch(n=>(t<this.pendingBackendInitId||(this.pendingBackendInit=null,console.warn(`Initialization of backend ${e} failed`),console.warn(n.stack||n.message)),!1));return this.pendingBackendInit=n,{success:n,asyncInit:!0}}}catch(t){return console.warn(`Initialization of backend ${e} failed`),console.warn(t.stack||t.message),{success:!1,asyncInit:!1}}}removeBackend(e){if(!(e in this.registryFactory))throw new Error(e+" backend not found in registry");this.backendName===e&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,e in this.registry&&(this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e]),delete this.registryFactory[e],this.backendName===e&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort((e,t)=>this.registryFactory[t].priority-this.registryFactory[e].priority)}initializeBackendsAndReturnBest(){const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t],{success:s,asyncInit:r}=this.initializeBackend(n);if(r||s)return{name:n,asyncInit:r}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(e,t){const n=this.state.tensorInfo.get(t),s=n.backend,r=this.readSync(t),a=s.refCount(t);s.disposeData(t,!0),n.backend=e,e.move(t,r,n.shape,n.dtype,a),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(e,t){let n,s=null;if(null==t){if("function"!=typeof e)throw new Error("Please provide a function to tidy()");t=e}else{if("string"!=typeof e&&!(e instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof t)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");s=e}return this.scopedRun(()=>this.startScope(s),()=>this.endScope(n),()=>(n=t(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n))}scopedRun(e,t,n){e();try{const e=n();return t(),e}catch(e){throw t(),e}}nextTensorId(){return zs.nextTensorId++}nextVariableId(){return zs.nextVariableId++}clone(e){const t=Ps.runKernel("Identity",{x:e}),n={x:e};return this.addTapeNode(this.state.activeScope.name,n,[t],e=>({x:()=>{const t={x:e},n={dtype:"float32"};return Ps.runKernel("Cast",t,n)}}),[],{}),t}runKernel(e,t,n){if(!(null!=qn(e,this.backendName)))throw new Error(`Kernel '${e}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:e,inputs:t,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(e,t,n){const s=this.backend.numDataIds();let r=0;n.forEach(e=>{r+="complex64"===e.dtype?3:1});const a=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],i=s-t-r-a;if(i>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${i} data ids) after running '${e}'`)}runKernelFunc(e){let t,n=[];const s=this.isTapeOn(),r=this.state.numBytes,a=this.state.numTensors;let i,l;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const u=Ms(e)?e.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(Ms(e)){const{kernelName:t,inputs:r,attrs:a}=e;null==this.backendName&&this.backend;const u=qn(t,this.backendName);o(null!=u,()=>`Cannot find registered kernel '${t}' for backend '${this.backendName}'`),i=()=>{const e=this.backend.numDataIds();l=u.kernelFunc({inputs:r,attrs:a,backend:this.backend});const i=Array.isArray(l)?l:[l];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(t,e,i);const o=i.map(e=>{if(null!=e.rank)return e;const{dataId:t,shape:n,dtype:s}=e;return this.makeTensorFromDataId(t,n,s)});if(s){const e=this.getTensorsForGradient(t,r,o);n=this.saveTensorsForBackwardMode(e)}return o}}else{const{forwardFunc:t}=e,r=e=>{s&&(n=e.map(e=>this.keep(this.clone(e))))};i=()=>{const e=this.backend.numDataIds();l=this.tidy(()=>t(this.backend,r));const n=Array.isArray(l)?l:[l];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(u,e,n),n}}const{inputs:c,attrs:h}=e,p=Ms(e)?null:e.backwardsFunc;let d;return this.scopedRun(()=>this.state.kernelDepth++,()=>this.state.kernelDepth--,()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(d=this.profiler.profileKernel(u,c,()=>i()),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(d),t=d.outputs):t=i()}),s&&this.addTapeNode(u,c,t,p,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:u,bytesAdded:this.state.numBytes-r,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-a,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(c).map(e=>null!=c[e]?c[e].shape:null),outputShapes:t.map(e=>e.shape),kernelTimeMs:d.timeMs,extraInfo:d.extraInfo}),Array.isArray(l)?t:t[0]}saveTensorsForBackwardMode(e){return e.map(e=>this.keep(this.clone(e)))}getTensorsForGradient(e,t,n){const s=Kn(e);if(null!=s){const e=s.inputsToSave||[],r=s.outputsToSave||[];let a;s.saveAllInputs?(o(Array.isArray(t),()=>"saveAllInputs is true, expected inputs to be an array."),a=Object.keys(t).map(e=>t[e])):a=e.map(e=>t[e]);const i=n.filter((e,t)=>r[t]);return a.concat(i)}return[]}makeTensor(e,t,n,s){if(null==e)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",s=s||this.backend;let r=e;"string"===n&&E(e[0])&&(r=e.map(e=>is(e)));const a=s.write(r,t,n),i=new ws(t,n,a,this.nextTensorId());if(this.trackTensor(i,s),"string"===n){const e=this.state.tensorInfo.get(a),t=T(r);this.state.numBytes+=t-e.bytes,e.bytes=t}return i}makeTensorFromDataId(e,t,n,s){const r=new ws(t,n=n||"float32",e,this.nextTensorId());return this.trackTensor(r,s),r}makeVariable(e,t=!0,n,s){n=n||this.nextVariableId().toString(),null!=s&&s!==e.dtype&&(e=e.cast(s));const r=new vs(e,t,n,this.nextTensorId());if(null!=this.state.registeredVariables[r.name])throw new Error(`Variable with name ${r.name} was already registered`);return this.state.registeredVariables[r.name]=r,this.incRef(r,this.backend),r}trackTensor(e,t){this.state.numTensors++,"string"===e.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==e.dtype&&"string"!==e.dtype&&(n=e.size*S(e.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(e.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(e.dataId,{backend:t||this.backend,dtype:e.dtype,shape:e.shape,bytes:n})),e instanceof vs||this.track(e)}incRef(e,t){this.trackTensor(e,t),this.backend.incRef(e.dataId)}removeDataId(e,t){this.state.tensorInfo.has(e)&&this.state.tensorInfo.get(e).backend===t&&(this.state.tensorInfo.delete(e),this.state.numDataBuffers--)}disposeTensor(e){if(!this.state.tensorInfo.has(e.dataId))return;const t=this.state.tensorInfo.get(e.dataId);if(this.state.numTensors--,"string"===e.dtype&&(this.state.numStringTensors--,this.state.numBytes-=t.bytes),"complex64"!==e.dtype&&"string"!==e.dtype){const t=e.size*S(e.dtype);this.state.numBytes-=t}t.backend.disposeData(e.dataId)&&this.removeDataId(e.dataId,t.backend)}disposeVariables(){for(const e in this.state.registeredVariables){const t=this.state.registeredVariables[e];this.disposeVariable(t)}}disposeVariable(e){this.disposeTensor(e),null!=this.state.registeredVariables[e.name]&&delete this.state.registeredVariables[e.name]}memory(){const e=this.backend.memory();return e.numTensors=this.state.numTensors,e.numDataBuffers=this.state.numDataBuffers,e.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(e.unreliable=!0,null==e.reasons&&(e.reasons=[]),e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),e}async profile(e){this.state.profiling=!0;const t=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await e(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map(e=>e.totalBytesSnapshot)),this.state.activeProfile.newBytes=this.state.numBytes-t,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const e of this.state.activeProfile.kernels)e.kernelTimeMs=await e.kernelTimeMs,e.extraInfo=await e.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(e,t,n,s,r,a){const i={id:this.state.nextTapeNodeId++,kernelName:e,inputs:t,outputs:n,saved:r},o=Kn(e);null!=o&&(s=o.gradFunc),null!=s&&(i.gradient=e=>(e=e.map((e,t)=>{if(null==e){const e=n[t],s=L(e.size,e.dtype);return this.makeTensor(s,e.shape,e.dtype)}return e}),s(e.length>1?e:e[0],r,a))),this.state.activeTape.push(i)}keep(e){return e.kept=!0,e}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(e){const t={track:[],name:"unnamed scope",id:this.state.nextScopeId++};e&&(t.name=e),this.state.scopeStack.push(t),this.state.activeScope=t}endScope(e){const t=_s(e),n=new Set(t.map(e=>e.id));for(let e=0;e<this.state.activeScope.track.length;e++){const t=this.state.activeScope.track[e];t.kept||n.has(t.id)||t.dispose()}const s=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],t.forEach(e=>{e.kept||e.scopeId!==s.id||this.track(e)})}gradients(e,t,n,s=!1){if(o(t.length>0,()=>"gradients() received an empty list of xs."),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const r=this.scopedRun(()=>this.startTape(),()=>this.endTape(),()=>this.tidy("forward",e));o(r instanceof ws,()=>"The result y returned by f() must be a tensor.");const a=function(e,t,n){const s={},r={};for(let e=0;e<t.length;e++)s[t[e].id]=!0;for(let n=0;n<e.length;n++){const a=e[n],i=a.inputs;for(const e in i){const n=i[e];let o=!1;for(let e=0;e<t.length;e++)if(s[n.id]){a.outputs.forEach(e=>s[e.id]=!0),o=!0,r[a.id]=!0;break}if(o)break}}const a={};a[n.id]=!0;const i={};for(let t=e.length-1;t>=0;t--){const n=e[t],s=n.inputs;for(let e=0;e<n.outputs.length;e++)if(a[n.outputs[e].id]){for(const e in s)a[s[e].id]=!0,i[n.id]=!0;break}}const o=[];for(let t=0;t<e.length;t++){const n=e[t];if(r[n.id]&&i[n.id]){const e={};for(const t in n.inputs){const r=n.inputs[t];s[r.id]&&(e[t]=r)}const t=Object.assign({},n);t.inputs=e,t.outputs=n.outputs,o.push(t)}}return o}(this.state.activeTape,t,r);if(!s&&0===a.length&&t.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",()=>{const e={};e[r.id]=null==n?function(e){const t=M(h(e),"float32");return Ps.makeTensor(t,e,"float32")}(r.shape):n,function(e,t,n,s){for(let r=t.length-1;r>=0;r--){const a=t[r],i=[];if(a.outputs.forEach(t=>{const n=e[t.id];null!=n?i.push(n):i.push(null)}),null==a.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${a.kernelName}.`);const o=a.gradient(i);for(const t in a.inputs){if(!(t in o))throw new Error(`Cannot backprop through input ${t}. Available gradients found: ${Object.keys(o)}.`);const r=n(()=>o[t]());if("float32"!==r.dtype)throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input ${t} must have 'float32' dtype, but has '${r.dtype}'`);const i=a.inputs[t];if(!p(r.shape,i.shape))throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input '${t}' has shape '${r.shape}', which does not match the shape of the input '${i.shape}'`);if(null==e[i.id])e[i.id]=r;else{const t=e[i.id];e[i.id]=s(t,r),t.dispose()}}}}(e,a,e=>this.tidy(e),Ws);const s=t.map(t=>e[t.id]);return 0===this.state.gradientDepth&&(this.state.activeTape.forEach(e=>{for(const t of e.saved)t.dispose()}),this.state.activeTape=null),{value:r,grads:s}})}customGrad(e){return o(F(e),()=>"The f passed in customGrad(f) must be a function."),(...t)=>{let n;o(t.every(e=>e instanceof ws),()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors");const s={};t.forEach((e,t)=>{s[t]=e});return this.runKernelFunc({forwardFunc:(s,r)=>(n=e(...t,r),o(n.value instanceof ws,()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor"),o(F(n.gradFunc),()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function."),n.value),backwardsFunc:(e,s)=>{const r=n.gradFunc(e,s),a=Array.isArray(r)?r:[r];o(a.length===t.length,()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...)."),o(a.every(e=>e instanceof ws),()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors.");const i={};return a.forEach((e,t)=>{i[t]=()=>e}),i},inputs:s})}}readSync(e){return this.state.tensorInfo.get(e).backend.readSync(e)}read(e){return this.state.tensorInfo.get(e).backend.read(e)}async time(e){const t=rs(),n=await this.backend.time(e);return n.wallMs=rs()-t,n}track(e){return null!=this.state.activeScope&&(e.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(e)),e}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new Ls;for(const e in this.registry)this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}function Bs(){const e=q();if(null==e._tfengine){const t=new U(e);e._tfengine=new zs(t)}var t;return t=e._tfengine.ENV,j=t,ys=()=>e._tfengine,e._tfengine}zs.nextTensorId=0,zs.nextVariableId=0;const Ps=Bs();function Ws(e,t){const n={a:e,b:t};return Ps.runKernel(Z,n)}function Vs(){if("undefined"!=typeof navigator&&null!=navigator){const e=navigator.userAgent||navigator.vendor||window.opera;return/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(e)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(e.substr(0,4))}return!1}function Us(){return"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope}var Gs=Object.freeze({__proto__:null,isMobile:Vs,isBrowser:Us});const Hs=G();function js(e,t){let n=e;if(C(e))return"string"===t?[]:[e.length];if(!Array.isArray(e))return[];const s=[];for(;Array.isArray(n)||C(n)&&"string"!==t;)s.push(n.length),n=n[0];return Array.isArray(e)&&G().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&function e(t,n,s){if(s=s||[],!Array.isArray(t)&&!C(t))return void o(0===n.length,()=>`Element arr[${s.join("][")}] is a primitive, but should be an array/TypedArray of ${n[0]} elements`);o(n.length>0,()=>`Element arr[${s.join("][")}] should be a primitive, but is an array of ${t.length} elements`),o(t.length===n[0],()=>`Element arr[${s.join("][")}] should have ${n[0]} elements, but has ${t.length} elements`);const r=n.slice(1);for(let n=0;n<t.length;++n)e(t[n],r,s.concat(n))}(e,s,[]),s}function qs(e,t,n,s){if("string_or_numeric"!==e){if(null==e)throw new Error("Expected dtype cannot be null.");if("numeric"!==e&&e!==t||"numeric"===e&&"string"===t)throw new Error(`Argument '${n}' passed to '${s}' must be ${e} tensor, but got ${t} tensor`)}}function Ks(e,t,n,s="numeric"){if(e instanceof ws)return qs(s,e.dtype,t,n),e;let r=R(e);if("string"!==r&&["bool","int32","float32"].indexOf(s)>=0&&(r=s),qs(s,r,t,n),null==e||!C(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e){const s=null==e?"null":e.constructor.name;throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${s}'`)}const a=js(e,r);C(e)||Array.isArray(e)||(e=[e]);const i="string"!==r?ss(e,r):c(e,[],!0);return Ps.makeTensor(i,a,r)}function Xs(e,t,n,s="numeric"){if(!Array.isArray(e))throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return e.map((e,r)=>Ks(e,`${t}[${r}]`,n,s))}Hs.registerFlag("DEBUG",()=>!1,e=>{e&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")}),Hs.registerFlag("IS_BROWSER",()=>Us()),Hs.registerFlag("IS_NODE",()=>"undefined"!=typeof process&&void 0!==process.versions&&void 0!==process.versions.node),Hs.registerFlag("IS_CHROME",()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor)),Hs.registerFlag("PROD",()=>!1),Hs.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",()=>Hs.getBool("DEBUG")),Hs.registerFlag("DEPRECATION_WARNINGS_ENABLED",()=>!0),Hs.registerFlag("IS_TEST",()=>!1),Hs.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",()=>!0);const Ys="__op";function Js(e){const t=Object.keys(e);if(1!==t.length)throw new Error("Please provide an object with a single key (operation name) mapping to a function. Got an object with "+t.length+" keys.");let n=t[0];const s=e[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+="__op";const r=(...e)=>{Ps.startScope(n);try{const t=s(...e);return V(t)&&console.error("Cannot return a Promise inside of tidy."),Ps.endScope(t),t}catch(e){throw Ps.endScope(null),e}};return Object.defineProperty(r,"name",{value:n,configurable:!0}),r}const Zs=Js({complex_:function(e,t){const n=Ks(e,"real","complex"),s=Ks(t,"imag","complex");l(n.shape,s.shape,`real and imag shapes, ${n.shape} and ${s.shape}, must match in call to tf.complex().`);const r={real:n,imag:s};return Ps.runKernel("Complex",r)}});function Qs(e,t,n,s){if(null==s&&(s=R(e)),"complex64"===s)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!C(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=t){B(t);const e=h(t),s=h(n);o(e===s,()=>`Based on the provided shape, [${t}], the tensor should have ${e} values but has ${s}`);for(let e=0;e<n.length;++e){const s=n[e],r=e!==n.length-1||s!==h(t.slice(e));o(n[e]===t[e]||!r,()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `)}}return C(e)||Array.isArray(e)||(e=[e]),t=t||n,e="string"!==s?ss(e,s):c(e,[],!0),Ps.makeTensor(e,t,s)}function er(e,t,n){return Qs(e,t,js(e,n),n)}const tr={float32:4,float16:2,int32:4,uint16:2,uint8:1,bool:1,complex64:8};async function nr(e,t){const n=[],s=[],r=Array.isArray(e)?e.map(e=>e.name):Object.keys(e);for(let a=0;a<r.length;++a){const i=r[a],o=Array.isArray(e)?e[a].tensor:e[i];if("float32"!==o.dtype&&"int32"!==o.dtype&&"bool"!==o.dtype&&"string"!==o.dtype&&"complex64"!==o.dtype)throw new Error(`Unsupported dtype in weight '${i}': ${o.dtype}`);const l={name:i,shape:o.shape,dtype:o.dtype};if("string"===o.dtype){const e=new Promise(async e=>{const t=await o.bytes(),n=t.reduce((e,t)=>e+t.length,0)+4*t.length,s=new Uint8Array(n);let r=0;for(let e=0;e<t.length;e++){const n=t[e],a=new Uint8Array(new Uint32Array([n.length]).buffer);s.set(a,r),r+=4,s.set(n,r),r+=n.length}e(s)});s.push(e)}else s.push(o.data());null!=t&&(l.group=t),n.push(l)}return{data:rr(await Promise.all(s)),specs:n}}function sr(e,t){const n={};let s,r=0;for(const a of t){const t=a.name,i=a.dtype,o=a.shape,l=h(o);let u;if("quantization"in a){const n=a.quantization;if("uint8"===n.dtype||"uint16"===n.dtype){if(!("min"in n)||!("scale"in n))throw new Error(`Weight ${a.name} with quantization ${n.dtype} doesn't have corresponding metadata min and scale.`)}else{if("float16"!==n.dtype)throw new Error(`Weight ${a.name} has unknown quantization dtype ${n.dtype}. Supported quantization dtypes are: 'uint8', 'uint16', and 'float16'.`);if("float32"!==i)throw new Error(`Weight ${a.name} is quantized with ${n.dtype} which only supports weights of type float32 not ${i}.`)}const o=tr[n.dtype],c=e.slice(r,r+l*o),h="uint8"===n.dtype?new Uint8Array(c):new Uint16Array(c);if("float32"===i)if("uint8"===n.dtype||"uint16"===n.dtype){u=new Float32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=t*n.scale+n.min}}else{if("float16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type float32.`);void 0===s&&(s=cr()),u=s(h)}else{if("int32"!==i)throw new Error(`Unsupported dtype in weight '${t}': ${i}`);if("uint8"!==n.dtype&&"uint16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type int32.`);u=new Int32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=Math.round(t*n.scale+n.min)}}r+=l*o}else if("string"===i){const t=h(a.shape);u=[];for(let n=0;n<t;n++){const t=new Uint32Array(e.slice(r,r+4))[0];r+=4;const n=new Uint8Array(e.slice(r,r+t));u.push(n),r+=t}}else{const s=tr[i],a=e.slice(r,r+l*s);if("float32"===i)u=new Float32Array(a);else if("int32"===i)u=new Int32Array(a);else if("bool"===i)u=new Uint8Array(a);else{if("complex64"!==i)throw new Error(`Unsupported dtype in weight '${t}': ${i}`);{u=new Float32Array(a);const e=new Float32Array(u.length/2),s=new Float32Array(u.length/2);for(let t=0;t<e.length;t++)e[t]=u[2*t],s[t]=u[2*t+1];const r=er(e,o,"float32"),i=er(s,o,"float32");n[t]=Zs(r,i),r.dispose(),i.dispose()}}r+=l*s}"complex64"!==i&&(n[t]=er(u,o,i))}return n}function rr(e){if(null===e)throw new Error("Invalid input value: "+JSON.stringify(e));let t=0;const n=[];e.forEach(e=>{if(t+=e.byteLength,n.push(e.byteLength===e.buffer.byteLength?e:new e.constructor(e)),!(e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array))throw new Error("Unsupported TypedArray subtype: "+e.constructor.name)});const s=new Uint8Array(t);let r=0;return n.forEach(e=>{s.set(new Uint8Array(e.buffer),r),r+=e.byteLength}),s.buffer}const ar="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function ir(e){return ar?Buffer.byteLength(e):new Blob([e]).size}function or(e){if(1===e.length)return e[0];let t=0;e.forEach(e=>{t+=e.byteLength});const n=new Uint8Array(t);let s=0;return e.forEach(e=>{n.set(new Uint8Array(e),s),s+=e.byteLength}),n.buffer}function lr(e){for(e=e.trim();e.endsWith("/");)e=e.slice(0,e.length-1);const t=e.split("/");return t[t.length-1]}function ur(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==e.modelTopology?0:ir(JSON.stringify(e.modelTopology)),weightSpecsBytes:null==e.weightSpecs?0:ir(JSON.stringify(e.weightSpecs)),weightDataBytes:null==e.weightData?0:e.weightData.byteLength}}function cr(){const e=function(){const e=e=>{let t=e<<13,n=0;for(;0==(8388608&t);)n-=8388608,t<<=1;return t&=-8388609,n+=947912704,t|n},t=new Uint32Array(2048);t[0]=0;for(let n=1;n<1024;n++)t[n]=e(n);for(let e=1024;e<2048;e++)t[e]=939524096+(e-1024<<13);return t}(),t=function(){const e=new Uint32Array(64);e[0]=0,e[31]=1199570944,e[32]=2147483648,e[63]=3347054592;for(let t=1;t<31;t++)e[t]=t<<23;for(let t=33;t<63;t++)e[t]=2147483648+(t-32<<23);return e}(),n=function(){const e=new Uint32Array(64);for(let t=0;t<64;t++)e[t]=1024;return e[0]=e[32]=0,e}();return s=>{const r=new ArrayBuffer(4*s.length),a=new Uint32Array(r);for(let r=0;r<s.length;r++){const i=s[r],o=e[n[i>>10]+(1023&i)]+t[i>>10];a[r]=o}return new Float32Array(r)}}class hr{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==hr.instance&&(hr.instance=new hr),hr.instance}static registerSaveRouter(e){hr.getInstance().saveRouters.push(e)}static registerLoadRouter(e){hr.getInstance().loadRouters.push(e)}static getSaveHandlers(e){return hr.getHandlers(e,"save")}static getLoadHandlers(e,t){return hr.getHandlers(e,"load",t)}static getHandlers(e,t,n){const s=[];return("load"===t?hr.getInstance().loadRouters:hr.getInstance().saveRouters).forEach(t=>{const r=t(e,n);null!==r&&s.push(r)}),s}}const pr=e=>hr.getSaveHandlers(e),dr=(e,t)=>hr.getLoadHandlers(e,t);function fr(){if(!G().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const e="undefined"==typeof window?self:window,t=e.indexedDB||e.mozIndexedDB||e.webkitIndexedDB||e.msIndexedDB||e.shimIndexedDB;if(null==t)throw new Error("The current browser does not appear to support IndexedDB.");return t}function mr(e){const t=e.result;t.createObjectStore("models_store",{keyPath:"modelPath"}),t.createObjectStore("model_info_store",{keyPath:"modelPath"})}class gr{constructor(e){if(this.indexedDB=fr(),null==e||!e)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=e}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,e)}async load(){return this.databaseAction(this.modelPath)}databaseAction(e,t){return new Promise((e,n)=>{const s=this.indexedDB.open("tensorflowjs",1);s.onupgradeneeded=()=>mr(s),s.onsuccess=()=>{const r=s.result;if(null==t){const t=r.transaction("models_store","readonly"),s=t.objectStore("models_store").get(this.modelPath);s.onsuccess=()=>{if(null==s.result)return r.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));e(s.result.modelArtifacts)},s.onerror=e=>(r.close(),n(s.error)),t.oncomplete=()=>r.close()}else{const s=ur(t),a=r.transaction("model_info_store","readwrite");let i=a.objectStore("model_info_store");const o=i.put({modelPath:this.modelPath,modelArtifactsInfo:s});let l;o.onsuccess=()=>{l=r.transaction("models_store","readwrite");const o=l.objectStore("models_store").put({modelPath:this.modelPath,modelArtifacts:t,modelArtifactsInfo:s});o.onsuccess=()=>e({modelArtifactsInfo:s}),o.onerror=e=>{i=a.objectStore("model_info_store");const t=i.delete(this.modelPath);t.onsuccess=()=>(r.close(),n(o.error)),t.onerror=e=>(r.close(),n(o.error))}},o.onerror=e=>(r.close(),n(o.error)),a.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}}},s.onerror=e=>n(s.error)})}}gr.URL_SCHEME="indexeddb://";const yr=e=>{return G().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(gr.URL_SCHEME)?(t=e.slice(gr.URL_SCHEME.length),new gr(t)):null;var t};hr.registerSaveRouter(yr),hr.registerLoadRouter(yr);class br{constructor(){this.indexedDB=fr()}async listModels(){return new Promise((e,t)=>{const n=this.indexedDB.open("tensorflowjs",1);n.onupgradeneeded=()=>mr(n),n.onsuccess=()=>{const s=n.result,r=s.transaction("model_info_store","readonly"),a=r.objectStore("model_info_store").getAll();a.onsuccess=()=>{const t={};for(const e of a.result)t[e.modelPath]=e.modelArtifactsInfo;e(t)},a.onerror=e=>(s.close(),t(a.error)),r.oncomplete=()=>s.close()},n.onerror=e=>t(n.error)})}async removeModel(e){var t;return e=(t=e).startsWith(gr.URL_SCHEME)?t.slice(gr.URL_SCHEME.length):t,new Promise((t,n)=>{const s=this.indexedDB.open("tensorflowjs",1);s.onupgradeneeded=()=>mr(s),s.onsuccess=()=>{const r=s.result,a=r.transaction("model_info_store","readwrite"),i=a.objectStore("model_info_store"),o=i.get(e);let l;o.onsuccess=()=>{if(null==o.result)return r.close(),n(new Error(`Cannot find model with path '${e}' in IndexedDB.`));{const s=i.delete(e),a=()=>{l=r.transaction("models_store","readwrite");const s=l.objectStore("models_store").delete(e);s.onsuccess=()=>t(o.result.modelArtifactsInfo),s.onerror=e=>n(o.error)};s.onsuccess=a,s.onerror=e=>(a(),r.close(),n(o.error))}},o.onerror=e=>(r.close(),n(o.error)),a.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}},s.onerror=e=>n(s.error)})}}const xr="tensorflowjs_models",wr="info",kr="model_topology",vr="weight_specs",Nr="weight_data",Ir="model_metadata";function Cr(e){return{info:[xr,e,wr].join("/"),topology:[xr,e,kr].join("/"),weightSpecs:[xr,e,vr].join("/"),weightData:[xr,e,Nr].join("/"),modelMetadata:[xr,e,Ir].join("/")}}function Sr(e){const t=e.split("/");if(t.length<3)throw new Error("Invalid key format: "+e);return t.slice(1,t.length-1).join("/")}class Tr{constructor(e){if(!G().getBool("IS_BROWSER")||"undefined"==typeof window||void 0===window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==e||!e)throw new Error("For local storage, modelPath must not be null, undefined or empty.");this.modelPath=e,this.keys=Cr(this.modelPath)}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const t=JSON.stringify(e.modelTopology),n=JSON.stringify(e.weightSpecs),s=ur(e);try{this.LS.setItem(this.keys.info,JSON.stringify(s)),this.LS.setItem(this.keys.topology,t),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(e){if(ar)return Buffer.from(e).toString("base64");const t=new Uint8Array(e);let n="";for(let e=0,s=t.length;e<s;e++)n+=String.fromCharCode(t[e]);return btoa(n)}(e.weightData));const r={format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy};return null!=e.signature&&(r.signature=e.signature),null!=e.userDefinedMetadata&&(r.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(r.modelInitializer=e.modelInitializer),this.LS.setItem(this.keys.modelMetadata,JSON.stringify(r)),{modelArtifactsInfo:s}}catch(e){throw this.LS.removeItem(this.keys.info),this.LS.removeItem(this.keys.topology),this.LS.removeItem(this.keys.weightSpecs),this.LS.removeItem(this.keys.weightData),this.LS.removeItem(this.keys.modelMetadata),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${s.modelTopologyBytes}, weightSpecsBytes=${s.weightSpecsBytes}, weightDataBytes=${s.weightDataBytes}.`)}}}async load(){const e=JSON.parse(this.LS.getItem(this.keys.info));if(null==e)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==e.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const t={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);t.modelTopology=n;const s=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==s)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);t.weightSpecs=s;const r=this.LS.getItem(this.keys.modelMetadata);if(null!=r){const e=JSON.parse(r);t.format=e.format,t.generatedBy=e.generatedBy,t.convertedBy=e.convertedBy,null!=e.signature&&(t.signature=e.signature),null!=e.userDefinedMetadata&&(t.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(t.modelInitializer=e.modelInitializer)}const a=this.LS.getItem(this.keys.weightData);if(null==a)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return t.weightData=function(e){if(ar){const t=Buffer.from(e,"base64");return t.buffer.slice(t.byteOffset,t.byteOffset+t.byteLength)}const t=atob(e),n=new Uint8Array(t.length);for(let e=0;e<t.length;++e)n.set([t.charCodeAt(e)],e);return n.buffer}(a),t}}Tr.URL_SCHEME="localstorage://";const Er=e=>{return G().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Tr.URL_SCHEME)?(t=e.slice(Tr.URL_SCHEME.length),new Tr(t)):null;var t};hr.registerSaveRouter(Er),hr.registerLoadRouter(Er);class $r{constructor(){o(G().getBool("IS_BROWSER"),()=>"Current environment is not a web browser"),o("undefined"==typeof window||void 0!==window.localStorage,()=>"Current browser does not appear to support localStorage"),this.LS=window.localStorage}async listModels(){const e={},t=xr+"/",n="/"+wr;for(let s=0;s<this.LS.length;++s){const r=this.LS.key(s);if(r.startsWith(t)&&r.endsWith(n)){e[Sr(r)]=JSON.parse(this.LS.getItem(r))}}return e}async removeModel(e){var t;const n=Cr(e=(t=e).startsWith(Tr.URL_SCHEME)?t.slice(Tr.URL_SCHEME.length):t);if(null==this.LS.getItem(n.info))throw new Error(`Cannot find model at path '${e}'`);const s=JSON.parse(this.LS.getItem(n.info));return this.LS.removeItem(n.info),this.LS.removeItem(n.topology),this.LS.removeItem(n.weightSpecs),this.LS.removeItem(n.weightData),s}}class Ar{constructor(){this.managers={}}static getInstance(){return null==Ar.instance&&(Ar.instance=new Ar),Ar.instance}static registerManager(e,t){o(null!=e,()=>"scheme must not be undefined or null."),e.endsWith("://")&&(e=e.slice(0,e.indexOf("://"))),o(e.length>0,()=>"scheme must not be an empty string.");const n=Ar.getInstance();o(null==n.managers[e],()=>`A model store manager is already registered for scheme '${e}'.`),n.managers[e]=t}static getManager(e){const t=this.getInstance().managers[e];if(null==t)throw new Error(`Cannot find model manager for scheme '${e}'`);return t}static getSchemes(){return Object.keys(this.getInstance().managers)}}function Rr(e){if(-1===e.indexOf("://"))throw new Error("The url string provided does not contain a scheme. Supported schemes are: "+Ar.getSchemes().join(","));return{scheme:e.split("://")[0],path:e.split("://")[1]}}async function Fr(e,t,n=!1){o(e!==t,()=>`Old path and new path are the same: '${e}'`);const s=hr.getLoadHandlers(e);o(s.length>0,()=>`Copying failed because no load handler is found for source URL ${e}.`),o(s.length<2,()=>`Copying failed because more than one (${s.length}) load handlers for source URL ${e}.`);const r=s[0],a=hr.getSaveHandlers(t);o(a.length>0,()=>`Copying failed because no save handler is found for destination URL ${t}.`),o(a.length<2,()=>`Copying failed because more than one (${s.length}) save handlers for destination URL ${t}.`);const i=a[0],l=Rr(e).scheme,u=Rr(e).path,c=l===Rr(e).scheme,h=await r.load();n&&c&&await Ar.getManager(l).removeModel(u);const p=await i.save(h);return n&&!c&&await Ar.getManager(l).removeModel(u),p.modelArtifactsInfo}class Dr{fetch(e,t){return fetch(e,t)}now(){return performance.now()}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error("Browser's encoder only supports utf-8, but got "+t);return null==this.textEncoder&&(this.textEncoder=new TextEncoder),this.textEncoder.encode(e)}decode(e,t){return new TextDecoder(t).decode(e)}}if(G().get("IS_BROWSER")){G().setPlatform("browser",new Dr);try{Ar.registerManager(Tr.URL_SCHEME,new $r)}catch(e){}try{Ar.registerManager(gr.URL_SCHEME,new br)}catch(e){}}const _r=()=>require("node-fetch");let Or;class Mr{constructor(){this.util=require("util"),this.textEncoder=new this.util.TextEncoder}fetch(e,t){return null!=G().global.fetch?G().global.fetch(e,t):(null==Or&&(Or=_r()),Or(e,t))}now(){const e=process.hrtime();return 1e3*e[0]+e[1]/1e6}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error("Node built-in encoder only supports utf-8, but got "+t);return this.textEncoder.encode(e)}decode(e,t){return 0===e.length?"":new this.util.TextDecoder(t).decode(e)}}function Lr(e,t="float32",n){return t=t||"float32",B(e),new gs(e,t,n)}G().get("IS_NODE")&&G().setPlatform("node",new Mr);const zr=Js({cast_:function(e,t){const n=Ks(e,"x","cast");if(!N(t))throw new Error("Failed to cast to unknown dtype "+t);if("string"===t&&"string"!==n.dtype||"string"!==t&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const s={x:n},r={dtype:t};return Ps.runKernel("Cast",s,r)}});const Br=Js({clone_:function(e){const t={x:Ks(e,"x","clone","string_or_numeric")};return Ps.runKernel("Identity",t)}});function Pr(e,t=!1){console.log(e.toString(t))}Bs(),bs={buffer:Lr,cast:zr,clone:Br,print:Pr};function Wr(e){return new Promise(e=>setTimeout(e)).then(e)}class Vr{constructor(e){if(!G().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");e.startsWith(Vr.URL_SCHEME)&&(e=e.slice(Vr.URL_SCHEME.length)),null!=e&&0!==e.length||(e="model"),this.modelTopologyFileName=e+".json",this.weightDataFileName=e+".weights.bin"}async save(e){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const t=window.URL.createObjectURL(new Blob([e.weightData],{type:"application/octet-stream"}));if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=[{paths:["./"+this.weightDataFileName],weights:e.weightSpecs}],s={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:n};null!=e.signature&&(s.signature=e.signature),null!=e.userDefinedMetadata&&(s.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(s.modelInitializer=e.modelInitializer);const r=window.URL.createObjectURL(new Blob([JSON.stringify(s)],{type:"application/json"})),a=null==this.jsonAnchor?document.createElement("a"):this.jsonAnchor;if(a.download=this.modelTopologyFileName,a.href=r,await Wr(()=>a.dispatchEvent(new MouseEvent("click"))),null!=e.weightData){const e=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;e.download=this.weightDataFileName,e.href=t,await Wr(()=>e.dispatchEvent(new MouseEvent("click")))}return{modelArtifactsInfo:ur(e)}}}}Vr.URL_SCHEME="downloads://";class Ur{constructor(e){if(null==e||e.length<1)throw new Error("When calling browserFiles, at least 1 file is required, but received "+e);this.files=e}async load(){const e=this.files[0],t=this.files.slice(1);return new Promise((n,s)=>{const r=new FileReader;r.onload=r=>{const a=JSON.parse(r.target.result),i=a.modelTopology;if(null==i)return void s(new Error("modelTopology field is missing from file "+e.name));0===t.length&&n({modelTopology:i});const o=a.weightsManifest;if(null==o)return void s(new Error("weightManifest field is missing from file "+e.name));let l;try{l=this.checkManifestAndWeightFiles(o,t)}catch(e){return void s(e)}const u=[],c=[],h=[];o.forEach(e=>{e.paths.forEach(e=>{c.push(e),h.push(null)}),u.push(...e.weights)}),o.forEach(e=>{e.paths.forEach(e=>{const t=new FileReader;t.onload=t=>{const s=t.target.result,r=c.indexOf(e);if(h[r]=s,-1===h.indexOf(null)){const e={modelTopology:i,weightSpecs:u,weightData:or(h),format:a.format,generatedBy:a.generatedBy,convertedBy:a.convertedBy};null!=a.signature&&(e.signature=a.signature),null!=a.userDefinedMetadata&&(e.userDefinedMetadata=a.userDefinedMetadata),null!=a.modelInitializer&&(e.modelInitializer=a.modelInitializer),n(e)}},t.onerror=t=>s(`Failed to weights data from file of path '${e}'.`),t.readAsArrayBuffer(l[e])})})},r.onerror=t=>s(`Failed to read model topology and weights manifest JSON from file '${e.name}'. BrowserFiles supports loading Keras-style tf.Model artifacts only.`),r.readAsText(e)})}checkManifestAndWeightFiles(e,t){const n=[],s=t.map(e=>lr(e.name)),r={};for(const a of e)a.paths.forEach(e=>{const a=lr(e);if(-1!==n.indexOf(a))throw new Error(`Duplicate file basename found in weights manifest: '${a}'`);if(n.push(a),-1===s.indexOf(a))throw new Error(`Weight file with basename '${a}' is not provided.`);r[e]=t[s.indexOf(a)]});if(n.length!==t.length)throw new Error(`Mismatch in the number of files in weights manifest (${n.length}) and the number of weight files provided (${t.length}).`);return r}}function Gr(e,t,n,s){!function(e){o(null!=e&&Array.isArray(e)&&e.length>0,()=>"promises must be a none empty array")}(e),function(e,t){o(e>=0&&e<=1,()=>"Progress fraction must be in range [0, 1], but got startFraction "+e),o(t>=0&&t<=1,()=>"Progress fraction must be in range [0, 1], but got endFraction "+t),o(t>=e,()=>`startFraction must be no more than endFraction, but got startFraction ${e} and endFraction `+t)}(n=null==n?0:n,s=null==s?1:s);let r=0;return Promise.all(e.map(a=>(a.then(a=>{const i=n+ ++r/e.length*(s-n);return t(i),a}),a)))}async function Hr(e,t){null==t&&(t={});const n=null==t.fetchFunc?G().platform.fetch:t.fetchFunc,s=e.map(e=>n(e,t.requestInit,{isBinary:!0})),r=(null==t.onProgress?await Promise.all(s):await Gr(s,t.onProgress,0,.5)).map(e=>e.arrayBuffer());return null==t.onProgress?await Promise.all(r):await Gr(r,t.onProgress,.5,1)}async function jr(e,t="",n,s){return qr(e=>Hr(e,{requestInit:s}))(e,t,n)}function qr(e){return async(t,n="",s)=>{const r=t.map(()=>!1),a={},i=null!=s?s.map(()=>!1):[],o=[];if(t.forEach((e,t)=>{let n=0;e.weights.forEach(e=>{const l="quantization"in e?e.quantization.dtype:e.dtype,u=tr[l]*h(e.shape),c=()=>{r[t]=!0,null==a[t]&&(a[t]=[]),a[t].push({manifestEntry:e,groupOffset:n,sizeBytes:u})};null!=s?s.forEach((t,n)=>{t===e.name&&(c(),i[n]=!0)}):c(),o.push(e.name),n+=u})}),!i.every(e=>e)){const e=s.filter((e,t)=>!i[t]);throw new Error("Could not find weights in manifest with names: "+e.join(", ")+". \nManifest JSON has weights with names: "+o.join(", ")+".")}const l=r.reduce((e,t,n)=>(t&&e.push(n),e),[]),u=[];l.forEach(e=>{t[e].paths.forEach(e=>{const t=n+(n.endsWith("/")?"":"/")+e;u.push(t)})});const c=await e(u),p={};let d=0;return l.forEach(e=>{const n=t[e].paths.length;let s=0;for(let e=0;e<n;e++)s+=c[d+e].byteLength;const r=new ArrayBuffer(s),i=new Uint8Array(r);let o=0;for(let e=0;e<n;e++){const t=new Uint8Array(c[d+e]);i.set(t,o),o+=t.byteLength}a[e].forEach(e=>{const t=sr(r.slice(e.groupOffset,e.groupOffset+e.sizeBytes),[e.manifestEntry]);for(const e in t)p[e]=t[e]}),d+=n}),p}}hr.registerSaveRouter(e=>G().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Vr.URL_SCHEME)?function(e="model"){return new Vr(e)}(e.slice(Vr.URL_SCHEME.length)):null);class Kr{constructor(e,t){if(this.DEFAULT_METHOD="POST",null==t&&(t={}),this.weightPathPrefix=t.weightPathPrefix,this.onProgress=t.onProgress,this.weightUrlConverter=t.weightUrlConverter,null!=t.fetchFunc?(o("function"==typeof t.fetchFunc,()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)"),this.fetch=t.fetchFunc):this.fetch=G().platform.fetch,o(null!=e&&e.length>0,()=>"URL path for http must not be null, undefined or empty."),Array.isArray(e)&&o(2===e.length,()=>`URL paths for http must have a length of 2, (actual length is ${e.length}).`),this.path=e,null!=t.requestInit&&null!=t.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=t.requestInit||{}}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const t=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);t.body=new FormData;const n=[{paths:["./model.weights.bin"],weights:e.weightSpecs}],s={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:n};null!=e.signature&&(s.signature=e.signature),null!=e.userDefinedMetadata&&(s.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(s.modelInitializer=e.modelInitializer),t.body.append("model.json",new Blob([JSON.stringify(s)],{type:"application/json"}),"model.json"),null!=e.weightData&&t.body.append("model.weights.bin",new Blob([e.weightData],{type:"application/octet-stream"}),"model.weights.bin");const r=await this.fetch(this.path,t);if(r.ok)return{modelArtifactsInfo:ur(e),responses:[r]};throw new Error("BrowserHTTPRequest.save() failed due to HTTP response status "+r.status+".")}async load(){const e=await this.fetch(this.path,this.requestInit);if(!e.ok)throw new Error(`Request to ${this.path} failed with status code `+e.status+". Please verify this URL points to the model JSON of the model to load.");let t;try{t=await e.json()}catch(e){let t=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?t+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":t+=" Please make sure the server is serving valid JSON for this request.",new Error(t)}const n=t.modelTopology,s=t.weightsManifest,r=t.generatedBy,a=t.convertedBy,i=t.format,o=t.signature,l=t.userDefinedMetadata;if(null==n&&null==s)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);let u,c;if(null!=s){const e=await this.loadWeights(s);[u,c]=e}const h={modelTopology:n,weightSpecs:u,weightData:c,generatedBy:r,convertedBy:a,format:i};null!=o&&(h.signature=o),null!=l&&(h.userDefinedMetadata=l);const p=t.modelInitializer;return p&&(h.modelInitializer=p),h}async loadWeights(e){const t=Array.isArray(this.path)?this.path[1]:this.path,[n,s]=function(e){const t=e.lastIndexOf("/"),n=e.lastIndexOf("?"),s=e.substring(0,t),r=n>t?e.substring(n):"";return[s+"/",r]}(t),r=this.weightPathPrefix||n,a=[];for(const t of e)a.push(...t.weights);const i=[],o=[];for(const t of e)for(const e of t.paths)null!=this.weightUrlConverter?o.push(this.weightUrlConverter(e)):i.push(r+e+s);return this.weightUrlConverter&&i.push(...await Promise.all(o)),[a,or(await Hr(i,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress}))]}}function Xr(e){return null!=e.match(Kr.URL_SCHEME_REGEX)}Kr.URL_SCHEME_REGEX=/^https?:\/\//;const Yr=(e,t)=>{if("undefined"==typeof fetch&&(null==t||null==t.fetchFunc))return null;{let n=!0;if(n=Array.isArray(e)?e.every(e=>Xr(e)):Xr(e),n)return Jr(e,t)}return null};function Jr(e,t){return new Kr(e,t)}function Zr(e,t){return Jr(e,t)}hr.registerSaveRouter(Yr),hr.registerLoadRouter(Yr);class Qr{constructor(e){this.modelArtifacts=e}async load(){return this.modelArtifacts}}class ea{constructor(e){this.saveHandler=e}async save(e){return this.saveHandler(e)}}var ta=Object.freeze({__proto__:null,browserFiles:function(e){return new Ur(e)},browserHTTPRequest:Zr,concatenateArrayBuffers:or,decodeWeights:sr,encodeWeights:nr,fromMemory:function(e,t,n,s){if(1===arguments.length){return null!=e.modelTopology||null!=e.weightSpecs?new Qr(e):(console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new Qr({modelTopology:e}))}return console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new Qr({modelTopology:e,weightSpecs:t,weightData:n,trainingConfig:s})},getLoadHandlers:dr,getModelArtifactsInfoForJSON:ur,getSaveHandlers:pr,http:Jr,isHTTPScheme:Xr,loadWeights:jr,registerLoadRouter:e=>hr.registerLoadRouter(e),registerSaveRouter:e=>hr.registerSaveRouter(e),weightsLoaderFactory:qr,withSaveHandler:function(e){return new ea(e)},copyModel:async function(e,t){return Fr(e,t,!1)},listModels:async function(){const e=Ar.getSchemes(),t={};for(const n of e){const e=await Ar.getManager(n).listModels();for(const s in e){t[n+"://"+s]=e[s]}}return t},moveModel:async function(e,t){return Fr(e,t,!0)},removeModel:async function(e){const t=Rr(e);return Ar.getManager(t.scheme).removeModel(t.path)}});const na=Js({matMul_:function(e,t,n=!1,s=!1){let r=Ks(e,"a","matMul"),a=Ks(t,"b","matMul");[r,a]=Rs(r,a);const i={a:r,b:a},o={transposeA:n,transposeB:s};return Ps.runKernel("BatchMatMul",i,o)}});const sa=Js({oneHot_:function(e,t,n=1,s=0){if(t<2)throw new Error("Error in oneHot: depth must be >=2, but it is "+t);const r={indices:Ks(e,"indices","oneHot","int32")},a={depth:t,onValue:n,offValue:s};return Ps.runKernel("OneHot",r,a)}});const ra=Js({transpose_:function(e,t){const n=Ks(e,"x","transpose");if(null==t&&(t=n.shape.map((e,t)=>t).reverse()),o(n.rank===t.length,()=>`Error in transpose: rank of input ${n.rank} must match length of perm ${t}.`),t.forEach(e=>{o(e>=0&&e<n.rank,()=>"All entries in 'perm' must be between 0 and "+(n.rank-1)+" but got "+t)}),n.rank<=1)return n.clone();const s={x:n},r={perm:t};return Ps.runKernel("Transpose",s,r)}});const aa=Js({confusionMatrix_:function(e,t,n){const s=Ks(e,"labels","confusionMatrix"),r=Ks(t,"predictions","confusionMatrix");o(null==n||n>0&&Number.isInteger(n),()=>"If provided, numClasses must be a positive integer, but got "+n),o(1===s.rank,()=>"Expected the rank of labels to be 1, but got "+s.rank),o(1===r.rank,()=>"Expected the rank of predictions to be 1, but got "+r.rank),o(s.shape[0]===r.shape[0],()=>`Mismatch in the number of examples: ${s.shape[0]} vs. ${r.shape[0]}. Labels and predictions should have the same number of elements.`),o(n>0&&Number.isInteger(n),()=>"numClasses is required to be a positive integer, but got "+n);const a=sa(zr(s,"int32"),n),i=sa(zr(r,"int32"),n),l=ra(a),u=na(l,i);return zr(u,"int32")}});var ia=Object.freeze({__proto__:null,confusionMatrix:aa});function oa(e,t,n){if(u(e),null!=t&&3!==t.length)throw new Error("tensor3d() requires shape to have three numbers");const s=js(e,n);if(3!==s.length&&1!==s.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return Qs(e,t,s,n)}let la;const ua=Js({fromPixels_:function(e,t=3){if(t>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==e)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,s=!1,r=!1,a=!1,i=!1,o=!1;if(e.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&e instanceof ImageData)s=!0;else if("undefined"!=typeof HTMLVideoElement&&e instanceof HTMLVideoElement)r=!0;else if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement)a=!0;else if(null!=e.getContext)i=!0;else{if(!("undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap))throw new Error("pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was "+e.constructor.name);o=!0}if(r){const t=2;if(r&&e.readyState<t)throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.")}if(null!=qn("FromPixels",Ps.backendName)){const n={pixels:e},s={numChannels:t};return Ps.runKernel("FromPixels",n,s)}const[l,u]=r?[e.videoWidth,e.videoHeight]:[e.width,e.height];let c,h;if(i?c=e.getContext("2d").getImageData(0,0,l,u).data:s||n?c=e.data:(a||r||o)&&(null==la&&(la=document.createElement("canvas").getContext("2d")),la.canvas.width=l,la.canvas.height=u,la.drawImage(e,0,0,l,u),c=la.getImageData(0,0,l,u).data),4===t)h=new Int32Array(c);else{const e=l*u;h=new Int32Array(e*t);for(let n=0;n<e;n++)for(let e=0;e<t;++e)h[n*t+e]=c[4*n+e]}return oa(h,[u,l,t],"int32")}});var ca=Object.freeze({__proto__:null,toPixels:async function(e,t){let n=Ks(e,"img","toPixels");if(!(e instanceof ws)){const e=n;n=zr(e,"int32"),e.dispose()}if(2!==n.rank&&3!==n.rank)throw new Error(`toPixels only supports rank 2 or 3 tensors, got rank ${n.rank}.`);const[s,r]=n.shape.slice(0,2),a=2===n.rank?1:n.shape[2];if(a>4||2===a)throw new Error("toPixels only supports depth of size 1, 3 or 4 but got "+a);if("float32"!==n.dtype&&"int32"!==n.dtype)throw new Error(`Unsupported type for toPixels: ${n.dtype}. Please use float32 or int32 tensors.`);const i=await n.data(),o="float32"===n.dtype?255:1,l=new Uint8ClampedArray(r*s*4);for(let e=0;e<s*r;++e){const t=[0,0,0,255];for(let s=0;s<a;s++){const r=i[e*a+s];if("float32"===n.dtype){if(r<0||r>1)throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${r}.`)}else if("int32"===n.dtype&&(r<0||r>255))throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${r}.`);1===a?(t[0]=r*o,t[1]=r*o,t[2]=r*o):t[s]=r*o}const s=4*e;l[s+0]=Math.round(t[0]),l[s+1]=Math.round(t[1]),l[s+2]=Math.round(t[2]),l[s+3]=Math.round(t[3])}if(null!=t){t.width=r,t.height=s;const e=t.getContext("2d"),n=new ImageData(l,r,s);e.putImageData(n,0,0)}return n!==e&&n.dispose(),l},fromPixels:ua});function ha(e,t){const n=e.shape.length,s=t.shape.length;if(n<1)throw new Error(`tf.gatherND() expects the input to be rank 1 or higher, but the rank was ${n}.`);if(s<1)throw new Error(`tf.gatherND() expects the indices to be rank 1 or higher, but the rank was ${s}.`);if("int32"!==t.dtype)throw new Error(`tf.gatherND() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.shape[s-1]>n)throw new Error(`index innermost dimension length must be <= tensor rank; saw: ${t.shape[s-1]} vs. ${n}`);if(0===h(e.shape))throw new Error(`Requested more than 0 entries, but input is empty. Input shape: ${e.shape}.`);const r=t.shape,a=r[r.length-1];let i=1;for(let e=0;e<r.length-1;++e)i*=r[e];const o=e.shape,l=r.slice();l.pop();let u=1;for(let e=a;e<n;++e)u*=o[e],l.push(o[e]);const c=[..._(e.shape).map(e=>e/u),1].slice(0,a);return[l,i,u,c]}var pa=Object.freeze({__proto__:null,prepareAndValidate:ha});function da(e,t,n){const s=t.rank>1?t.shape[t.rank-1]:1,r=t.rank>1?t.rank-1:1,a="Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: "+n.shape+`, indices.shape: ${t.shape}, shape: ${e}`+`, sliceDim: ${s}, and batchDim: ${r}.`;if(n.rank<r)throw new Error(a+` update.rank < ${r}. `);if(e.length<s+(n.rank-r))throw new Error(a+" Output shape length < "+(s+(n.rank-r)));if(n.rank!==r+e.length-s)throw new Error(a+" update.rank != "+(r+e.length-s));for(let e=0;e<r;++e)if(n.shape[e]!==t.shape[e])throw new Error(a+` updates.shape[${e}] (${n.shape[e]}) != indices.shape[${e}] (${t.shape[e]}).`);for(let t=0;t<n.rank-r;++t)if(n.shape[t+r]!==e[t+s])throw new Error(a+` updates.shape[${t+r}] (${n.shape[t+r]}) != shape[${t+r}] (${e[t+r]})`)}function fa(e,t,n){if(t.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==t.dtype)throw new Error("The dtype of 'indices' should be int32, but got dtype: "+t.dtype);if(n.length<1)throw new Error("Output rank must be greater or equal to 1, but got shape: "+n);if(0===n.length){if(0===t.size)throw new Error("Indices specified for empty output. indices shape: "+t.shape);if(0===e.size)throw new Error("Updates specified for empty output. updates shape: "+e.shape)}da(n,t,e)}function ma(e,t,n){const s=t.shape.length,r=s>1?t.shape[s-1]:1,a=n.length;let i=1;for(let e=r;e<a;++e)i*=n[e];const o=r<1?1:r;return{sliceRank:r,numUpdates:h(t.shape)/o,sliceSize:i,strides:[..._(n.slice(0,r)),1],outputSize:h(n)}}var ga=Object.freeze({__proto__:null,validateUpdateShape:da,validateInput:fa,calculateShapes:ma});function ya(e,t,n){const s=e.shape.length;o(s===t.length,()=>`Error in slice${s}D: Length of begin ${t} must match the rank of the array (${s}).`),o(s===n.length,()=>`Error in slice${s}D: Length of size ${n} must match the rank of the array (${s}).`);for(let r=0;r<s;++r)o(t[r]+n[r]<=e.shape[r],()=>`Error in slice${s}D: begin[${r}] + size[${r}] (${t[r]+n[r]}) would overflow input.shape[${r}] (${e.shape[r]})`)}function ba(e){const t=[];let n=0;for(;e>0;)1&e&&t.push(n),e/=2,n++;return t}function xa(e,t,n){const s=[];for(let r=0;r<e.length;r++)s[r]=Math.ceil((t[r]-e[r])/n[r]);return s}function wa(e,t,n,s){const r=[...e];for(let e=r.length;e<s.length;e++)r.push(1);for(let e=0;e<n;e++)0===e?r[t]=1:(r.splice(t,0,1),r.pop());return r}function ka(e,t,n){return n<=e?n:n-(t-1)}function va(e,t){const n=[];for(let s=0;s<e;s++)n.push(t+s);return n}function Na(e,t,n,s,r,a,i,o,l){const u=e.length;let c=new Array(u),h=new Array(u),p=new Array(u);if(t.length&&n>0){const l=t[0],u=n+1;c=Ia(i,l,u,s,e),h=Ca(o,l,u,r,e),p=wa(a,l,u,e)}else for(let t=0;t<u;t++)c[t]=Ta(i,s,a,e,t,l),h[t]=Ea(o,r,a,e,t,l),p[t]=Sa(a,t,l);return{begin:c,end:h,strides:p}}function Ia(e,t,n,s,r){const a=[...r],i=va(n,t);for(let r=0;r<a.length;r++)if(i.indexOf(r)>-1)a[r]=0;else{const i=ka(t,n,r);let o=s[i];e&1<<i&&(o=0),a[r]=o}return a}function Ca(e,t,n,s,a){const i=[...a],o=va(n,t);for(let r=0;r<i.length;r++)if(o.indexOf(r)>-1)i[r]=Number.MAX_SAFE_INTEGER;else{const a=ka(t,n,r);let o=s[a];e&1<<a&&(o=Number.MAX_SAFE_INTEGER),i[r]=o}for(let e=0;e<i.length;e++){const t=a[e];i[e]<0&&(i[e]+=t),i[e]=r(0,i[e],a[e])}return i}function Sa(e,t,n){let s=e[t];return(n&1<<t||null==s)&&(s=1),s}function Ta(e,t,n,s,a,i){let o=t[a];const l=n[a]||1;(e&1<<a||i&1<<a||null==o)&&(o=l>0?Number.MIN_SAFE_INTEGER:Number.MAX_SAFE_INTEGER);const u=s[a];return o<0&&(o+=u),o=r(0,o,u-1),o}function Ea(e,t,n,s,a,i){let o=t[a];const l=n[a]||1;(e&1<<a||i&1<<a||null==o)&&(o=l>0?Number.MAX_SAFE_INTEGER:Number.MIN_SAFE_INTEGER);const u=s[a];return o<0&&(o+=u),o=l>0?r(0,o,u):r(-1,o,u-1),o}function $a(e,t,n){let s=n.length;for(let e=0;e<n.length;e++)if(n[e]>1){s=e;break}for(let r=s+1;r<n.length;r++)if(t[r]>0||n[r]!==e[r])return!1;return!0}function Aa(e,t){let n=e.length>0?e[e.length-1]:1;for(let s=0;s<e.length-1;s++)n+=e[s]*t[s];return n}function Ra(e,t,n){let s;const r=e.shape.length;let a;return s="number"==typeof t?[t,...new Array(r-1).fill(0)]:t.length<r?t.concat(new Array(r-t.length).fill(0)):t.slice(),s.forEach(e=>{o(-1!==e,()=>"slice() does not support negative begin indexing.")}),a=null==n?new Array(r).fill(-1):"number"==typeof n?[n,...new Array(r-1).fill(-1)]:n.length<r?n.concat(new Array(r-n.length).fill(-1)):n,a=a.map((t,n)=>t>=0?t:(o(-1===t,()=>`Negative size values should be exactly -1 but got ${t} for the slice() size at index ${n}.`),e.shape[n]-s[n])),[s,a]}function Fa(e,t,n,s,r,a,i,o,l){let u=t.slice(),c=n.slice(),h=s;null==s&&(h=new Array(u.length));const p=ba(i);if(p.length>1)throw new Error("Multiple ellipses in slice is not allowed.");if(0!==i&&0!==o)throw new Error("Using both ellipsisMask and newAxisMask is not yet supported.");if(0!==i&&0!==l)throw new Error("Using both ellipsisMask and shrinkAxisMask is not yet supported.");const d=e.length-u.length,f=ba(o),m=e.slice();f.forEach(e=>{u[e]=0,c[e]=1,m.splice(e,0,1)});const{begin:g,end:y,strides:b}=Na(m,p,d,u,c,h,r,a,i);u=g,c=y,h=b;const x=ba(l);x.forEach(e=>{c[e]=u[e]+1,h[e]=1});const w=xa(u,c,h),k=w.filter((e,t)=>-1===x.indexOf(t));return{nonStrided:h.every(e=>1===e),$begin:u,$end:c,$strides:h,size:w,newShape:m,outShape:k}}var Da=Object.freeze({__proto__:null,assertParamsValid:ya,maskToAxes:ba,computeOutShape:xa,stridesWithElidedDims:wa,getNormalizedAxes:Na,startIndicesWithElidedDims:Ia,stopIndicesWithElidedDims:Ca,stridesForAxis:Sa,startForAxis:Ta,stopForAxis:Ea,isSliceContinous:$a,computeFlatOffset:Aa,parseSliceParams:Ra,sliceInfo:Fa});class _a{getClassName(){return this.constructor.className}static fromConfig(e,t){return new e(t)}}class Oa{constructor(){this.classNameMap={}}static getMap(){return null==Oa.instance&&(Oa.instance=new Oa),Oa.instance}static register(e){Oa.getMap().classNameMap[e.className]=[e,e.fromConfig]}}function Ma(e){o(null!=e.className,()=>"Class being registered does not have the static className property defined."),o("string"==typeof e.className,()=>"className is required to be a string, but got type "+typeof e.className),o(e.className.length>0,()=>"Class being registered has an empty-string as its className, which is disallowed."),Oa.register(e)}var La=Object.freeze({__proto__:null,Serializable:_a,SerializationMap:Oa,registerClass:Ma});function za(){return 32===Ps.backend.floatPrecision()?.001:.1}function Ba(e,t,n){let s=!0;if((C(e)||C(t))&&(s=!1),C(e)&&C(t)&&(s=!0),s){const n=e.constructor.name,s=t.constructor.name;if(n!==s)throw new Error(`Arrays are of different type. Actual: ${n}. Expected: `+s)}if(Array.isArray(e)&&Array.isArray(t)){const n=js(e),s=js(t);if(!p(n,s))throw new Error(`Arrays have different shapes. Actual: [${n}]. Expected: [${s}]`)}const r=C(e)?e:c(e),a=C(t)?t:c(t);if(r.length!==a.length)throw new Error(`Arrays have different lengths actual: ${r.length} vs expected: ${a.length}.\nActual:   ${r}.\nExpected: ${a}.`);for(let e=0;e<a.length;++e){const t=r[e],s=a[e];if(!n(t,s))throw new Error(`Arrays differ: actual[${e}] = ${t}, expected[${e}] = ${s}.\nActual:   ${r}.\nExpected: ${a}.`)}}function Pa(e,t,n){if(null==n&&(n=za()),!Wa(e,t,n))throw new Error(`Numbers differ: actual === ${e}, expected === ${t}`)}function Wa(e,t,n){return!isFinite(e)&&!isFinite(t)||!(isNaN(e)||isNaN(t)||Math.abs(e-t)>n)}var Va=Object.freeze({__proto__:null,TEST_EPSILON_FLOAT16:.1,expectArraysClose:function(e,t,n){return null==n&&(n=za()),Ba(e,t,(e,t)=>Wa(e,t,n))},testEpsilon:za,expectPromiseToFail:function(e,t){e().then(()=>t.fail(),()=>t())},expectArraysEqual:function(e,t){const n="string"==typeof t||"number"==typeof t||"boolean"==typeof t?[t]:t;return E(e)||E(e[0])||E(t)||E(t[0])?Ba(e,n,(e,t)=>e==t):Ba(e,t,(e,t)=>Wa(e,t,0))},expectNumbersClose:Pa,expectValuesInRange:function(e,t,n){for(let s=0;s<e.length;s++)if(e[s]<t||e[s]>n)throw new Error(`Value out of range:${e[s]} low: ${t}, high: ${n}`)},expectArrayBuffersEqual:function(e,t){expect(new Float32Array(e)).toEqual(new Float32Array(t))},encodeStrings:function e(t){for(let n=0;n<t.length;n++){const s=t[n];Array.isArray(s)?e(s):t[n]=is(s)}return t}});const Ua="3.2.0";function Ga(){G().set("PROD",!0)}function Ha(){G().set("DEBUG",!0)}function ja(){G().set("DEPRECATION_WARNINGS_ENABLED",!1),console.warn("TensorFlow.js deprecation warnings have been disabled.")}function qa(e){G().getBool("DEPRECATION_WARNINGS_ENABLED")&&console.warn(e+" You can disable deprecation warnings with tf.disableDeprecationWarnings().")}function Ka(){Ps.disposeVariables()}function Xa(){return Ps}function Ya(){return Ps.memory()}function Ja(e){return Ps.profile(e)}function Za(e,t){return Ps.tidy(e,t)}function Qa(e){_s(e).forEach(e=>e.dispose())}function ei(e){return Ps.keep(e)}function ti(e){return Ps.time(e)}function ni(e){return Ps.setBackend(e)}function si(){return Ps.ready()}function ri(){return Ps.backendName}function ai(e){Ps.removeBackend(e)}function ii(e){return Ps.findBackend(e)}function oi(e){return Ps.findBackendFactory(e)}function li(e,t,n=1){return Ps.registerBackend(e,t,n)}function ui(){return Ps.backend}function ci(e,t){G().setPlatform(e,t)}xs=qa;const hi=Js({add_:function(e,t){let n=Ks(e,"a","add"),s=Ks(t,"b","add");[n,s]=Rs(n,s);const r={a:n,b:s};return Ps.runKernel(Z,r)}});const pi=Js({floorDiv_:function(e,t){let n=Ks(e,"a","floorDiv"),s=Ks(t,"b","floorDiv");[n,s]=Rs(n,s);const r={a:n,b:s};return Ps.runKernel("FloorDiv",r)}});const di=Js({div_:function(e,t){let n=Ks(e,"a","div"),s=Ks(t,"b","div");if([n,s]=Rs(n,s),"int32"===n.dtype&&"int32"===s.dtype)return pi(n,s);const r={a:n,b:s};return Ps.runKernel("RealDiv",r,{})}});const fi=Js({mul_:function(e,t){let n=Ks(e,"a","mul"),s=Ks(t,"b","mul");[n,s]=Rs(n,s);const r={a:n,b:s};return Ps.runKernel("Multiply",r)}});const mi=Js({abs_:function(e){const t=Ks(e,"x","abs");if("complex64"===t.dtype){const e={x:t};return Ps.runKernel("ComplexAbs",e)}{const e={x:t};return Ps.runKernel("Abs",e)}}});const gi=Js({acos_:function(e){const t={x:Ks(e,"x","acos")};return Ps.runKernel("Acos",t)}});const yi=Js({acosh_:function(e){const t={x:Ks(e,"x","acosh")};return Ps.runKernel("Acosh",t)}});const bi=Js({addN_:function(e){o(Array.isArray(e),()=>"The argument passed to tf.addN() must be a list of tensors"),o(e.length>=1,()=>"Must pass at least one tensor to tf.addN(), but got "+e.length);const t=e.map((e,t)=>Ks(e,"tensors"+t,"addN")),n=t[0];t.forEach(e=>{if(e.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")}),t.forEach(e=>{if(!p(e.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")});const s=t;return Ps.runKernel("AddN",s)}});const xi=Js({all_:function(e,t=null,n=!1){const s={x:Ks(e,"x","all","bool")},r={axis:t,keepDims:n};return Ps.runKernel("All",s,r)}});const wi=Js({any_:function(e,t=null,n=!1){const s={x:Ks(e,"x","any","bool")},r={axis:t,keepDims:n};return Ps.runKernel("Any",s,r)}});const ki=Js({argMax_:function(e,t=0){const n={x:Ks(e,"x","argMax")},s={axis:t};return Ps.runKernel("ArgMax",n,s)}});const vi=Js({argMin_:function(e,t=0){const n={x:Ks(e,"x","argMin")},s={axis:t};return Ps.runKernel("ArgMin",n,s)}});const Ni=Js({asin_:function(e){const t={x:Ks(e,"x","asin")};return Ps.runKernel("Asin",t)}});const Ii=Js({asinh_:function(e){const t={x:Ks(e,"x","asinh")};return Ps.runKernel("Asinh",t)}});const Ci=Js({atan_:function(e){const t={x:Ks(e,"x","atan")};return Ps.runKernel("Atan",t)}});const Si=Js({atan2_:function(e,t){let n=Ks(e,"a","atan2"),s=Ks(t,"b","atan2");[n,s]=Rs(n,s);const r={a:n,b:s};return Ps.runKernel("Atan2",r)}});const Ti=Js({atanh_:function(e){const t={x:Ks(e,"x","atanh")};return Ps.runKernel("Atanh",t)}});function Ei(e,t,n,s,r="NHWC",a){return Ri(e,[...t,e[3]],n,a,s,null,null,Pi(r))}function $i(e,t,n,s,r,a,i="channelsLast"){const[o,l]=_i(t);let u;if("channelsLast"===i)u=[o,l,e[3],e[3]];else{if("channelsFirst"!==i)throw new Error("Unknown dataFormat "+i);u=[o,l,e[1],e[1]]}return Ri(e,u,n,s,r,a,!1,i)}function Ai(e,t,n,s,r,a,i="NDHWC"){const[o,l,u]=Oi(t);let c,h;if("NDHWC"===i)h="channelsLast",c=[o,l,u,e[4],e[4]];else{if("NCDHW"!==i)throw new Error("Unknown dataFormat "+i);h="channelsFirst",c=[o,l,u,e[1],e[1]]}return Fi(e,c,n,s,r,!1,h,a)}function Ri(e,t,n,s,r,a,i=!1,o="channelsLast"){let[l,u,c,h]=[-1,-1,-1,-1];if("channelsLast"===o)[l,u,c,h]=e;else{if("channelsFirst"!==o)throw new Error("Unknown dataFormat "+o);[l,h,u,c]=e}const[p,d,,f]=t,[m,g]=_i(n),[y,b]=_i(s),x=Mi(p,y),w=Mi(d,b),{padInfo:k,outHeight:v,outWidth:N}=function(e,t,n,s,r,a,i,o,l){let u,c,h;if("number"==typeof e){u={top:e,bottom:e,left:e,right:e,type:0===e?"VALID":"NUMBER"};const r=function(e,t,n,s,r){null==s&&(s=Di(e,t,n));const a=e[0],i=e[1],o=Li((a-t+2*s)/n+1,r),l=Li((i-t+2*s)/n+1,r);return[o,l]}([t,n],a,s,e,o);c=r[0],h=r[1]}else if("same"===e){c=Math.ceil(t/s),h=Math.ceil(n/r);const e=Math.max(0,(c-1)*s+a-t),o=Math.max(0,(h-1)*r+i-n),l=Math.floor(e/2),p=e-l,d=Math.floor(o/2);u={top:l,bottom:p,left:d,right:o-d,type:"SAME"}}else if("valid"===e)u={top:0,bottom:0,left:0,right:0,type:"VALID"},c=Math.ceil((t-a+1)/s),h=Math.ceil((n-i+1)/r);else{if("object"!=typeof e)throw Error("Unknown padding parameter: "+e);{const p="channelsLast"===l?e[1][0]:e[2][0],d="channelsLast"===l?e[1][1]:e[2][1],f="channelsLast"===l?e[2][0]:e[3][0],m="channelsLast"===l?e[2][1]:e[3][1];u={top:p,bottom:d,left:f,right:m,type:0===p&&0===d&&0===f&&0===m?"VALID":"EXPLICIT"},c=Li((t-a+p+d)/s+1,o),h=Li((n-i+f+m)/r+1,o)}}return{padInfo:u,outHeight:c,outWidth:h}}(r,u,c,m,g,x,w,a,o),I=i?f*h:f;let C;return"channelsFirst"===o?C=[l,I,v,N]:"channelsLast"===o&&(C=[l,v,N,I]),{batchSize:l,dataFormat:o,inHeight:u,inWidth:c,inChannels:h,outHeight:v,outWidth:N,outChannels:I,padInfo:k,strideHeight:m,strideWidth:g,filterHeight:p,filterWidth:d,effectiveFilterHeight:x,effectiveFilterWidth:w,dilationHeight:y,dilationWidth:b,inShape:e,outShape:C,filterShape:t}}function Fi(e,t,n,s,r,a=!1,i="channelsLast",o){let[l,u,c,h,p]=[-1,-1,-1,-1,-1];if("channelsLast"===i)[l,u,c,h,p]=e;else{if("channelsFirst"!==i)throw new Error("Unknown dataFormat "+i);[l,p,u,c,h]=e}const[d,f,m,,g]=t,[y,b,x]=Oi(n),[w,k,v]=Oi(s),N=Mi(d,w),I=Mi(f,k),C=Mi(m,v),{padInfo:S,outDepth:T,outHeight:E,outWidth:$}=function(e,t,n,s,r,a,i,o,l,u,c){let h,p,d,f;if("number"==typeof e){h={top:e,bottom:e,left:e,right:e,front:e,back:e,type:0===e?"VALID":"NUMBER"};const a=function(e,t,n,s,r,a){null==r&&(r=Di(e,t,s));const i=e[0],o=e[1],l=e[2],u=Li((i-t+2*r)/s+1,a),c=Li((o-t+2*r)/s+1,a),h=Li((l-t+2*r)/s+1,a);return[u,c,h,n]}([t,n,s,1],o,1,r,e,c);p=a[0],d=a[1],f=a[2]}else if("same"===e){p=Math.ceil(t/r),d=Math.ceil(n/a),f=Math.ceil(s/i);const e=(p-1)*r+o-t,c=(d-1)*a+l-n,m=(f-1)*i+u-s,g=Math.floor(e/2),y=e-g,b=Math.floor(c/2),x=c-b,w=Math.floor(m/2);h={top:b,bottom:x,left:w,right:m-w,front:g,back:y,type:"SAME"}}else{if("valid"!==e)throw Error("Unknown padding parameter: "+e);h={top:0,bottom:0,left:0,right:0,front:0,back:0,type:"VALID"},p=Math.ceil((t-o+1)/r),d=Math.ceil((n-l+1)/a),f=Math.ceil((s-u+1)/i)}return{padInfo:h,outDepth:p,outHeight:d,outWidth:f}}(r,u,c,h,y,b,x,N,I,C,o),A=a?g*p:g;let R;return"channelsFirst"===i?R=[l,A,T,E,$]:"channelsLast"===i&&(R=[l,T,E,$,A]),{batchSize:l,dataFormat:i,inDepth:u,inHeight:c,inWidth:h,inChannels:p,outDepth:T,outHeight:E,outWidth:$,outChannels:A,padInfo:S,strideDepth:y,strideHeight:b,strideWidth:x,filterDepth:d,filterHeight:f,filterWidth:m,effectiveFilterDepth:N,effectiveFilterHeight:I,effectiveFilterWidth:C,dilationDepth:w,dilationHeight:k,dilationWidth:v,inShape:e,outShape:R,filterShape:t}}function Di(e,t,n,s=1){const r=Mi(t,s);return Math.floor((e[0]*(n-1)-n+r)/2)}function _i(e){return"number"==typeof e?[e,e,e]:2===e.length?[e[0],e[1],1]:e}function Oi(e){return"number"==typeof e?[e,e,e]:e}function Mi(e,t){return t<=1?e:e+(e-1)*(t-1)}function Li(e,t){if(!t)return Math.trunc(e);switch(t){case"round":return Math.round(e);case"ceil":return Math.ceil(e);case"floor":return Math.floor(e);default:throw new Error("Unknown roundingMode "+t)}}function zi(e){const[t,n,s]=_i(e);return 1===t&&1===n&&1===s}function Bi(e,t){return zi(e)||zi(t)}function Pi(e){if("NHWC"===e)return"channelsLast";if("NCHW"===e)return"channelsFirst";throw new Error("Unknown dataFormat "+e)}const Wi=Js({reshape_:function(e,t){const n={x:Ks(e,"x","reshape","string_or_numeric")},s={shape:t};return Ps.runKernel("Reshape",n,s)}});const Vi=Js({avgPool_:function(e,t,n,s,r){const a=Ks(e,"x","avgPool","float32");o(Bi(n,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`);let i=a,l=!1;3===a.rank&&(l=!0,i=Wi(a,[1,a.shape[0],a.shape[1],a.shape[2]])),o(4===i.rank,()=>`Error in avgPool: x must be rank 4 but got rank ${i.rank}.`),null!=r&&o(d(s),()=>`Error in avgPool: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`);const u={x:i},c={filterSize:t,strides:n,pad:s,dimRoundingMode:r};let h=Ps.runKernel("AvgPool",u,c);return h=zr(h,a.dtype),l?Wi(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Ui=Js({avgPool3d_:function(e,t,n,s,r,a="NDHWC"){const i=Ks(e,"x","avgPool3d","float32");let l=i,u=!1;4===i.rank&&(u=!0,l=Wi(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),o(5===l.rank,()=>`Error in avgPool3d: x must be rank 5 but got rank ${l.rank}.`),o("NDHWC"===a,()=>"Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of "+a),null!=r&&o(d(s),()=>`Error in avgPool3d: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`);const c={x:l},h={filterSize:t,strides:n,pad:s,dimRoundingMode:r,dataFormat:a};let p=Ps.runKernel("AvgPool3D",c,h);return p=zr(p,l.dtype),u?Wi(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const Gi=Js({concat_:function(e,t=0){o(e.length>=1,()=>"Pass at least one tensor to concat");const n=Xs(e,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach(e=>{if("complex64"!==e.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${e.dtype}. `)}),1===n.length)return Br(n[0]);const s=n,r={axis:t};return Ps.runKernel("Concat",s,r)}});const Hi=Js({sigmoid_:function(e){const t={x:Ks(e,"x","sigmoid")};return Ps.runKernel("Sigmoid",t)}});const ji=Js({slice_:function(e,t,n){const s=Ks(e,"x","slice","string_or_numeric");if(0===s.rank)throw new Error("Slicing scalar is not possible");const r={x:s},a={begin:t,size:n};return Ps.runKernel("Slice",r,a)}});const qi=Js({tanh_:function(e){const t={x:Ks(e,"x","tanh")};return Ps.runKernel("Tanh",t)}});const Ki=Js({basicLSTMCell_:function(e,t,n,s,r,a){const i=Ks(e,"forgetBias","basicLSTMCell"),o=Ks(t,"lstmKernel","basicLSTMCell"),l=Ks(n,"lstmBias","basicLSTMCell"),u=Ks(s,"data","basicLSTMCell"),c=Ks(r,"c","basicLSTMCell"),h=Ks(a,"h","basicLSTMCell"),p=Gi([u,h],1),d=na(p,o),f=hi(d,l),m=f.shape[0],g=f.shape[1]/4,y=[m,g],b=ji(f,[0,0],y),x=ji(f,[0,g],y),w=ji(f,[0,2*g],y),k=ji(f,[0,3*g],y),v=hi(fi(Hi(b),qi(x)),fi(c,Hi(hi(i,w))));return[v,fi(qi(v),Hi(k))]}});const Xi=Js({batchToSpaceND_:function(e,t,n){const s=Ks(e,"x","batchToSpaceND"),r=t.reduce((e,t)=>e*t);o(s.rank>=1+t.length,()=>`input rank is ${s.rank} but should be > than blockShape.length ${t.length}`),o(n.length===t.length,()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`),o(s.shape[0]%r==0,()=>`input tensor batch is ${s.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${r}`);const a={x:s},i={blockShape:t,crops:n};return Ps.runKernel("BatchToSpaceND",a,i)}});const Yi=Js({batchNorm_:function(e,t,n,s,r,a){null==a&&(a=.001);const i=Ks(e,"x","batchNorm"),l=Ks(t,"mean","batchNorm"),u=Ks(n,"variance","batchNorm");let c,h;null!=r&&(c=Ks(r,"scale","batchNorm")),null!=s&&(h=Ks(s,"offset","batchNorm")),o(l.rank===u.rank,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),o(null==h||l.rank===h.rank,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),o(null==c||l.rank===c.rank,()=>"Batch normalization gradient requires mean and scale to have equal ranks.");const p={x:function(e){let t;return t=0===e.rank||1===e.rank?Wi(e,[1,1,1,e.size]):2===e.rank?Wi(e,[1,1,e.shape[0],e.shape[1]]):3===e.rank?Wi(e,[1,e.shape[0],e.shape[1],e.shape[2]]):e,t}(i),scale:c,offset:h,mean:l,variance:u},d={varianceEpsilon:a},f=Ps.runKernel("FusedBatchNorm",p,d);return Wi(f,i.shape)}});const Ji=Js({batchNorm2d_:function(e,t,n,s,r,a){const i=Ks(e,"x","batchNorm"),l=Ks(t,"mean","batchNorm"),u=Ks(n,"variance","batchNorm");let c,h;return null!=r&&(c=Ks(r,"scale","batchNorm")),null!=s&&(h=Ks(s,"offset","batchNorm")),o(2===i.rank,()=>"Error in batchNorm2D: x must be rank 2 but got rank "+i.rank+"."),o(2===l.rank||1===l.rank,()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${l.rank}.`),o(2===u.rank||1===u.rank,()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${u.rank}.`),null!=c&&o(2===c.rank||1===c.rank,()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${c.rank}.`),null!=h&&o(2===h.rank||1===h.rank,()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`),Yi(i,l,u,h,c,a)}});const Zi=Js({batchNorm3d_:function(e,t,n,s,r,a){const i=Ks(e,"x","batchNorm"),l=Ks(t,"mean","batchNorm"),u=Ks(n,"variance","batchNorm");let c,h;return null!=r&&(c=Ks(r,"scale","batchNorm")),null!=s&&(h=Ks(s,"offset","batchNorm")),o(3===i.rank,()=>"Error in batchNorm3D: x must be rank 3 but got rank "+i.rank+"."),o(3===l.rank||1===l.rank,()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${l.rank}.`),o(3===u.rank||1===u.rank,()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${u.rank}.`),null!=c&&o(3===c.rank||1===c.rank,()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${c.rank}.`),null!=h&&o(3===h.rank||1===h.rank,()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`),Yi(i,l,u,h,c,a)}});const Qi=Js({batchNorm4d_:function(e,t,n,s,r,a){const i=Ks(e,"x","batchNorm"),l=Ks(t,"mean","batchNorm"),u=Ks(n,"variance","batchNorm");let c,h;return null!=r&&(c=Ks(r,"scale","batchNorm")),null!=s&&(h=Ks(s,"offset","batchNorm")),o(4===i.rank,()=>"Error in batchNorm4D: x must be rank 4 but got rank "+i.rank+"."),o(4===l.rank||1===l.rank,()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${l.rank}.`),o(4===u.rank||1===u.rank,()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${u.rank}.`),null!=c&&o(4===c.rank||1===c.rank,()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${c.rank}.`),null!=h&&o(4===h.rank||1===h.rank,()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`),Yi(i,l,u,h,c,a)}});const eo=Js({bincount_:function(e,t,n){const s=Ks(e,"x","bincount"),r=Ks(t,"weights","bincount");o("int32"===s.dtype,()=>"Error in bincount: input dtype must be int32, but got "+s.dtype),o(n>=0,()=>`size must be non-negative, but got ${n}.`),o(r.size===s.size||0===r.size,()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${s.shape}, weights shape: `+r.shape+".");const a={x:s,weights:r},i={size:n};return Ps.runKernel("Bincount",a,i)}});const to=Js({broadcastTo_:function(e,t){let n=Ks(e,"broadcastTo","x");const s=n.shape;if(t.some(e=>!(e>0)||e%1!=0))throw new Error(`broadcastTo(): Invalid broadcast shape [${t}].`);if(t.length<n.rank)throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);if(t.length>n.rank){const e=n.shape.slice();for(;e.length<t.length;)e.unshift(1);n=Wi(n,e)}const r=n.shape,a=Array.from(t);for(let e=t.length-1;e>=0;e--)if(r[e]===t[e])a[e]=1;else if(1!==n.shape[e])throw new Error(`broadcastTo(): [${s}] cannot be broadcast to [${t}].`);if(0===a.map((e,t)=>e>1?t:-1).filter(e=>e>=0).length)return Br(n);const i={x:n},o={reps:a};return Ps.runKernel("Tile",i,o)}});const no=Js({ceil_:function(e){const t={x:Ks(e,"x","ceil")};return Ps.runKernel("Ceil",t)}});const so=Js({clipByValue_:function(e,t,n){const s=Ks(e,"x","clipByValue");o(t<=n,()=>`Error in clip: min (${t}) must be less than or equal to max (${n}).`);const r={x:s},a={clipValueMin:t,clipValueMax:n};return Ps.runKernel("ClipByValue",r,a)}});const ro=Js({concat1d_:function(e){return Gi(e,0)}});const ao=Js({concat2d_:function(e,t){return Gi(e,t)}});const io=Js({concat3d_:function(e,t){return Gi(e,t)}});const oo=Js({concat4d_:function(e,t){return Gi(e,t)}});const lo=Js({conv2d_:function(e,t,n,s,r="NHWC",a=[1,1],i){const l=Ks(e,"x","conv2d"),u=Ks(t,"filter","conv2d");let c=l,h=!1;3===l.rank&&(h=!0,c=Wi(l,[1,l.shape[0],l.shape[1],l.shape[2]])),o(4===c.rank,()=>`Error in conv2d: input must be rank 4, but got rank ${c.rank}.`),o(4===u.rank,()=>"Error in conv2d: filter must be rank 4, but got rank "+u.rank+"."),null!=i&&o(d(s),()=>`Error in conv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`);const p="NHWC"===r?c.shape[3]:c.shape[1];o(p===u.shape[2],()=>`Error in conv2d: depth of input (${p}) must match input depth for filter ${u.shape[2]}.`),o(Bi(n,a),()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`);const f={x:c,filter:u},m={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i},g=Ps.runKernel("Conv2D",f,m);return h?Wi(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const uo=Js({conv1d_:function(e,t,n,s,r="NWC",a=1,i){const l=Ks(e,"x","conv1d"),u=Ks(t,"filter","conv1d");let c=l,h=!1;2===l.rank&&(h=!0,c=Wi(l,[1,l.shape[0],l.shape[1]])),o(3===c.rank,()=>`Error in conv1d: input must be rank 3, but got rank ${c.rank}.`),o(3===u.rank,()=>"Error in conv1d: filter must be rank 3, but got rank "+u.rank+"."),null!=i&&o(d(s),()=>`Error in conv1d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`),o(c.shape[2]===u.shape[1],()=>`Error in conv1d: depth of input (${c.shape[2]}) must match input depth for filter ${u.shape[1]}.`),o(Bi(n,a),()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${a}'`),o("NWC"===r,()=>`Error in conv1d: got dataFormat of ${r} but only NWC is currently supported.`);const p=Wi(u,[1,u.shape[0],u.shape[1],u.shape[2]]),f=Wi(c,[c.shape[0],1,c.shape[1],c.shape[2]]),m=lo(f,p,[1,n],s,"NHWC",[1,a],i);return Wi(m,h?[m.shape[2],m.shape[3]]:[m.shape[0],m.shape[2],m.shape[3]])}});const co=Js({conv2DBackpropInput_:function(e,t,n,s,r,a="NHWC",i){o(e.length===t.rank,()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`);let l=e,u=t,c=!1;3===t.rank&&(c=!0,u=Wi(t,[1,t.shape[0],t.shape[1],t.shape[2]]),l=[1,e[0],e[1],e[2]]),o(4===l.length,()=>"Error in conv2dDerInput: inShape must be length 4, but got length "+l.length+"."),o(4===u.rank,()=>"Error in conv2dDerInput: dy must be rank 4, but got rank "+u.rank),o(4===n.rank,()=>"Error in conv2dDerInput: filter must be rank 4, but got rank "+n.rank);const h="NHWC"===a?l[3]:l[1],p="NHWC"===a?u.shape[3]:u.shape[1];o(h===n.shape[2],()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`),o(p===n.shape[3],()=>`Error in conv2dDerInput: depth of output (${p}) must match output depth for filter ${n.shape[3]}.`),null!=i&&o(d(r),()=>`Error in conv2dDerInput: pad must be an integer when using, dimRoundingMode ${i} but got pad ${r}.`);const f={dy:u,filter:n},m={strides:s,pad:r,dataFormat:a,dimRoundingMode:i,inputShape:l},g=Ps.runKernel("Conv2DBackpropInput",f,m);return c?Wi(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const ho=Js({conv2dTranspose_:function(e,t,n,s,r,a){const i=Ks(e,"x","conv2dTranspose"),o=Ks(t,"filter","conv2dTranspose");return co(n,i,o,s,r,"NHWC",a)}});const po=Js({conv3d_:function(e,t,n,s,r="NDHWC",a=[1,1,1]){const i=Ks(e,"x","conv3d"),l=Ks(t,"filter","conv3d");let u=i,c=!1;4===i.rank&&(c=!0,u=Wi(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),o(5===u.rank,()=>`Error in conv3d: input must be rank 5, but got rank ${u.rank}.`),o(5===l.rank,()=>"Error in conv3d: filter must be rank 5, but got rank "+l.rank+"."),o(u.shape[4]===l.shape[3],()=>`Error in conv3d: depth of input (${u.shape[4]}) must match input depth for filter ${l.shape[3]}.`),o(Bi(n,a),()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`),o("NDHWC"===r,()=>`Error in conv3d: got dataFormat of ${r} but only NDHWC is currently supported.`);const h={x:u,filter:l},p={strides:n,pad:s,dataFormat:r,dilations:a},d=Ps.runKernel("Conv3D",h,p);return c?Wi(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const fo=Js({conv3DBackpropInput_:function(e,t,n,s,r){o(e.length===t.rank,()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`);let a=e,i=t,l=!1;4===t.rank&&(l=!0,i=Wi(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]),a=[1,e[0],e[1],e[2],e[3]]);const u=a[4],c=i.shape[4];o(5===a.length,()=>"Error in conv3dDerInput: inShape must be length 5, but got length "+a.length+"."),o(5===i.rank,()=>"Error in conv3dDerInput: dy must be rank 5, but got rank "+i.rank),o(5===n.rank,()=>"Error in conv3dDerInput: filter must be rank 5, but got rank "+n.rank),o(u===n.shape[3],()=>`Error in conv3dDerInput: depth of input (${u}) must match input depth for filter ${n.shape[3]}.`),o(c===n.shape[4],()=>`Error in conv3dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[4]}.`);const h={dy:i,filter:n},p={pad:r,strides:s,inputShape:a},d=Ps.runKernel("Conv3DBackpropInputV2",h,p);return l?Wi(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const mo=Js({conv3dTranspose_:function(e,t,n,s,r){const a=Ks(e,"x","conv3dTranspose"),i=Ks(t,"filter","conv3dTranspose");return fo(n,a,i,s,r)}});const go=Js({cos_:function(e){const t={x:Ks(e,"x","cos")};return Ps.runKernel($e,t)}});const yo=Js({cosh_:function(e){const t={x:Ks(e,"x","cosh")};return Ps.runKernel("Cosh",t)}});const bo=Js({cumsum_:function(e,t=0,n=!1,s=!1){const r={x:Ks(e,"x","cumsum")},a={axis:t,exclusive:n,reverse:s};return Ps.runKernel("Cumsum",r,a)}});const xo=Js({denseBincount_:function(e,t,n,s=!1){const r=Ks(e,"x","denseBincount"),a=Ks(t,"weights","denseBincount");o("int32"===r.dtype,()=>"Error in denseBincount: input dtype must be int32, but got "+r.dtype),o(r.rank<=2,()=>`Error in denseBincount: input must be at most rank 2, but got rank ${r.rank}.`),o(n>=0,()=>`size must be non-negative, but got ${n}.`),o(a.size===r.size||0===a.size,()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${r.shape}, weights shape: `+a.shape+".");const i={x:r,weights:a},l={size:n,binaryOutput:s};return Ps.runKernel("DenseBincount",i,l)}});const wo=Js({depthToSpace_:function(e,t,n="NHWC"){const s=Ks(e,"x","depthToSpace"),r="NHWC"===n?s.shape[1]:s.shape[2],a="NHWC"===n?s.shape[2]:s.shape[3],i="NHWC"===n?s.shape[3]:s.shape[1];o(r*t>=0,()=>`Negative dimension size caused by overflow when multiplying\n    ${r} and ${t}  for depthToSpace with input shape\n    ${s.shape}`),o(a*t>=0,()=>`Negative dimension size caused by overflow when multiplying\n    ${a} and ${t} for depthToSpace with input shape\n        ${s.shape}`),o(i%(t*t)==0,()=>`Dimension size must be evenly divisible by ${t*t} but is ${i} for depthToSpace with input shape ${s.shape}`);const l={x:s},u={blockSize:t,dataFormat:n};return Ps.runKernel("DepthToSpace",l,u)}});const ko=Js({depthwiseConv2d_:function(e,t,n,s,r="NHWC",a=[1,1],i){const l=Ks(e,"x","depthwiseConv2d"),u=Ks(t,"filter","depthwiseConv2d");let c=l,h=!1;3===l.rank&&(h=!0,c=Wi(l,[1,l.shape[0],l.shape[1],l.shape[2]])),o(4===c.rank,()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${c.rank}.`),o(4===u.rank,()=>"Error in depthwiseConv2d: filter must be rank 4, but got rank "+u.rank+"."),o(c.shape[3]===u.shape[2],()=>`Error in depthwiseConv2d: number of input channels (${c.shape[3]}) must match the inChannels dimension in filter ${u.shape[2]}.`),null!=i&&o(d(s),()=>`Error in depthwiseConv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`);const p={x:c,filter:u},f={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i},m=Ps.runKernel("DepthwiseConv2dNative",p,f);return h?Wi(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const vo=Js({diag_:function(e){const t={x:Ks(e,"x","diag")};return Ps.runKernel("Diag",t)}});const No=Js({dilation2d_:function(e,t,n,s,r=[1,1],a="NHWC"){const i=Ks(e,"x","dilation2d"),l=Ks(t,"filter","dilation2d");o(3===i.rank||4===i.rank,()=>"Error in dilation2d: input must be rank 3 or 4, but got rank "+i.rank+"."),o(3===l.rank,()=>"Error in dilation2d: filter must be rank 3, but got rank "+l.rank+"."),o("NHWC"===a,()=>"Error in dilation2d: Only NHWC is currently supported, but got dataFormat of "+a);let u=i,c=!1;3===i.rank&&(u=Wi(i,[1,i.shape[0],i.shape[1],i.shape[2]]),c=!0);const h={x:u,filter:l},p={strides:n,pad:s,dilations:r},d=Ps.runKernel("Dilation2D",h,p);return c?Wi(d,[d.shape[1],d.shape[2],d.shape[3]]):d}});function Io(e,t){const n=e.length,s=[];for(let r=0;r<n;r++){const a=n-1-r,i=e[a]||1;(t[t.length-1-r]||1)>1&&1===i&&s.unshift(a)}return s}function Co(e,t){const n=[];for(let s=0;s<t.length;s++){const r=e[e.length-s-1],a=t.length-s-1,i=t[a];(null==r||1===r&&i>1)&&n.unshift(a)}return n}function So(e,t){const n=[],s=Math.max(e.length,t.length);for(let r=0;r<s;r++){let s=e[e.length-r-1];null==s&&(s=1);let a=t[t.length-r-1];if(null==a&&(a=1),1===s)n.unshift(a);else if(1===a)n.unshift(s);else{if(s!==a){throw Error(`Operands could not be broadcast together with shapes ${e} and ${t}.`)}n.unshift(s)}}return n}const To=Js({equal_:function(e,t){let n=Ks(e,"a","equal"),s=Ks(t,"b","equal");[n,s]=Rs(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Ps.runKernel("Equal",r)}});const Eo=Js({where_:function(e,t,n){const s=Ks(t,"a","where"),r=Ks(n,"b","where"),a=Ks(e,"condition","where","bool"),i=So(s.shape,r.shape),u=to(s,i),c=to(r,i);1===a.rank&&o(a.shape[0]===s.shape[0],()=>"The first dimension of `a` must match the size of `condition`."),1!==a.rank&&l(a.shape,c.shape,"Error in where: ");const h={condition:a,t:u,e:c};return Ps.runKernel("Select",h)}});const $o=Js({zerosLike_:function(e){const t={x:Ks(e,"x","zerosLike")};return Ps.runKernel("ZerosLike",t)}});const Ao=Js({divNoNan_:function(e,t){let n=Ks(e,"a","div"),s=Ks(t,"b","div");[n,s]=Rs(n,s);const r=di(n,s),a=$o(r),i=To(s,a);return Eo(i,a,r)}});const Ro=Js({dot_:function(e,t){const n=Ks(e,"t1","dot"),s=Ks(t,"t2","dot");o(!(1!==n.rank&&2!==n.rank||1!==s.rank&&2!==s.rank),()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${s.rank}.`);const r=1===n.rank?n.size:n.shape[1],a=1===s.rank?s.size:s.shape[0];if(o(r===a,()=>`Error in dot: inner dimensions of inputs must match, but got ${r} and ${a}.`),1===n.rank&&1===s.rank){const e=Wi(n,[1,-1]),t=Wi(s,[-1,1]),r=na(e,t);return Wi(r,[])}if(1===n.rank&&2===s.rank){const e=Wi(n,[1,-1]),t=Wi(s,[s.shape[0],s.shape[1]]),r=na(e,t);return Wi(r,[r.size])}if(2===n.rank&&1===s.rank){const e=Wi(s,[-1,1]),t=na(n,e);return Wi(t,[t.size])}{const e=Wi(s,[s.shape[0],s.shape[1]]);return na(n,e)}}});const Fo=Js({elu_:function(e){const t={x:Ks(e,"x","elu")};return Ps.runKernel(Ue,t)}});const Do=Js({erf_:function(e){let t=Ks(e,"x","erf");o("int32"===t.dtype||"float32"===t.dtype,()=>"Input dtype must be `int32` or `float32`."),"int32"===t.dtype&&(t=zr(t,"float32"));const n={x:t};return Ps.runKernel(He,n)}});const _o=Js({exp_:function(e){const t={x:Ks(e,"x","exp")};return Ps.runKernel(qe,t)}});const Oo=Js({expandDims_:function(e,t=0){const n=Ks(e,"x","expandDims","string_or_numeric");o(t<=n.rank,()=>"Axis must be <= rank of the tensor");const s={input:n},r={dim:t};return Ps.runKernel("ExpandDims",s,r)}});const Mo=Js({expm1_:function(e){const t={x:Ks(e,"x","expm1")};return Ps.runKernel("Expm1",t)}});const Lo=Js({tile_:function(e,t){const n=Ks(e,"x","tile","string_or_numeric");o(n.rank===t.length,()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`);const s={x:n},r={reps:t};return Ps.runKernel("Tile",s,r)}});const zo=Js({eye_:function(e,t,n,s="float32"){null==t&&(t=e);const r=Lr([e,t],s),a=e<=t?e:t;for(let e=0;e<a;++e)r.set(1,e,e);const i=Wi(r.toTensor(),[e,t]);if(null==n)return i;if(1===n.length)return Lo(Oo(i,0),[n[0],1,1]);if(2===n.length)return Lo(Oo(Oo(i,0),0),[n[0],n[1],1,1]);if(3===n.length)return Lo(Oo(Oo(Oo(i,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function Bo(e,t,n){const s={shape:e,value:t,dtype:n};return Ps.runKernel("Fill",{},s)}const Po=Js({floor_:function(e){const t={x:Ks(e,"x","floor")};return Ps.runKernel("Floor",t)}});const Wo=Js({gather_:function(e,t,n=0,s=0){const r={x:Ks(e,"x","gather"),indices:Ks(t,"indices","gather","int32")},a={axis:n,batchDims:s};return Ps.runKernel("GatherV2",r,a)}});const Vo=Js({greater_:function(e,t){let n=Ks(e,"a","greater"),s=Ks(t,"b","greater");[n,s]=Rs(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Ps.runKernel("Greater",r)}});const Uo=Js({greaterEqual_:function(e,t){let n=Ks(e,"a","greaterEqual"),s=Ks(t,"b","greaterEqual");[n,s]=Rs(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Ps.runKernel("GreaterEqual",r)}});const Go=Js({imag_:function(e){const t={input:Ks(e,"input","imag")};return Ps.runKernel("Imag",t)}});const Ho=Js({isFinite_:function(e){const t={x:Ks(e,"x","isFinite")};return Ps.runKernel("IsFinite",t)}});const jo=Js({isInf_:function(e){const t={x:Ks(e,"x","isInf")};return Ps.runKernel("IsInf",t)}});const qo=Js({isNaN_:function(e){const t={x:Ks(e,"x","isNaN")};return Ps.runKernel("IsNan",t)}});const Ko=Js({leakyRelu_:function(e,t=.2){const n={x:Ks(e,"x","leakyRelu")},s={alpha:t};return Ps.runKernel("LeakyRelu",n,s)}});const Xo=Js({less_:function(e,t){let n=Ks(e,"a","less"),s=Ks(t,"b","less");[n,s]=Rs(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Ps.runKernel("Less",r)}});const Yo=Js({lessEqual_:function(e,t){let n=Ks(e,"a","lessEqual"),s=Ks(t,"b","lessEqual");[n,s]=Rs(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Ps.runKernel("LessEqual",r)}});function Jo(e,t,n){if(n<=0)throw new Error("The number of values should be positive.");const s={start:e,stop:t,num:n};return Ps.runKernel("LinSpace",{},s)}const Zo=Js({localResponseNormalization_:function(e,t=5,n=1,s=1,r=.5){const a=Ks(e,"x","localResponseNormalization");o(4===a.rank||3===a.rank,()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${a.rank}.`),o(d(t),()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`);let i=a,l=!1;3===a.rank&&(l=!0,i=Wi(a,[1,a.shape[0],a.shape[1],a.shape[2]]));const u={x:i},c={depthRadius:t,bias:n,alpha:s,beta:r},h=Ps.runKernel("LRN",u,c);return l?Wi(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Qo=Js({log_:function(e){const t={x:Ks(e,"x","log")};return Ps.runKernel(gt,t)}});const el=Js({log1p_:function(e){const t={x:Ks(e,"x","log1p")};return Ps.runKernel("Log1p",t)}});function tl(e){return o(F(e),()=>"The f passed in grad(f) must be a function"),(t,n)=>{const s=Ks(t,"x","tf.grad","string_or_numeric"),r=null!=n?Ks(n,"dy","tf.grad"):null;return Ps.tidy(()=>{const{value:t,grads:n}=Ps.gradients(()=>e(s),[s],r);return null!=r&&l(t.shape,r.shape,"The shape of dy passed in grad(f)(x, dy) must match the shape returned by f(x)"),ol(n),n[0]})}}function nl(e){return o(F(e),()=>"The f passed in grads(f) must be a function"),(t,n)=>{o(Array.isArray(t),()=>"The args passed in grads(f)(args) must be an array of `Tensor`s or `TensorLike`s");const s=Xs(t,"args","tf.grads","string_or_numeric"),r=null!=n?Ks(n,"dy","tf.grads"):null;return Ps.tidy(()=>{const{value:t,grads:n}=Ps.gradients(()=>e(...s),s,r);return null!=r&&l(t.shape,r.shape,"The shape of dy passed in grads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),ol(n),n})}}function sl(e){return o(F(e),()=>"The f passed in valueAndGrad(f) must be a function"),(t,n)=>{o(t instanceof ws,()=>"The x passed in valueAndGrad(f)(x) must be a tensor"),o(null==n||n instanceof ws,()=>"The dy passed in valueAndGrad(f)(x, dy) must be a tensor");const{grads:s,value:r}=Ps.gradients(()=>e(t),[t],n);return ol(s),{grad:s[0],value:r}}}function rl(e){return o(F(e),()=>"The f passed in valueAndGrads(f) must be a function"),(t,n)=>{o(Array.isArray(t)&&t.every(e=>e instanceof ws),()=>"The args passed in valueAndGrads(f)(args) must be array of tensors"),o(null==n||n instanceof ws,()=>"The dy passed in valueAndGrads(f)(args, dy) must be a tensor");const s=Ps.gradients(()=>e(...t),t,n);return null!=n&&l(s.value.shape,n.shape,"The shape of dy passed in valueAndGrads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),ol(s.grads),s}}function al(e,t){o(F(e),()=>"The f passed in variableGrads(f) must be a function"),o(null==t||Array.isArray(t)&&t.every(e=>e instanceof vs),()=>"The varList passed in variableGrads(f, varList) must be an array of variables");const n=null!=t;if(!n){t=[];for(const e in Ps.registeredVariables)t.push(Ps.registeredVariables[e])}const s=n?t.filter(e=>!e.trainable):null,r=t.length;o((t=t.filter(e=>e.trainable)).length>0,()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${r} variables is trainable.`);const{value:a,grads:i}=Ps.gradients(e,t,null,!0);o(i.some(e=>null!=e),()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize()."),o(0===a.rank,()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${a.rank} tensor`);const l={};return t.forEach((e,t)=>{null!=i[t]&&(l[e.name]=i[t])}),null!=s&&s.forEach(e=>l[e.name]=null),{value:a,grads:l}}function il(e){return Ps.customGrad(e)}function ol(e){if(e.filter(e=>null==e).length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that\n    the f you passed encloses all operations that lead from x to y.")}const ll=Js({neg_:function(e){const t={x:Ks(e,"x","neg")};return Ps.runKernel("Neg",t)}});const ul=Js({softplus_:function(e){const t={x:Ks(e,"x","softplus")};return Ps.runKernel("Softplus",t)}});const cl=Js({logSigmoid_:function(e){const t=Ks(e,"x","logSigmoid");return il(e=>({value:ll(ul(ll(e))),gradFunc:t=>fi(t,Hi(ll(e)))}))(t)}});const hl=Js({max_:function(e,t=null,n=!1){const s={x:Ks(e,"x","max")},r={reductionIndices:t,keepDims:n};return Ps.runKernel("Max",s,r)}});const pl=Js({sub_:function(e,t){let n=Ks(e,"a","sub"),s=Ks(t,"b","sub");[n,s]=Rs(n,s);const r={a:n,b:s};return Ps.runKernel(Tn,r)}});const dl=Js({sum_:function(e,t=null,n=!1){let s=Ks(e,"x","sum");"bool"===s.dtype&&(s=zr(s,"int32"));const r={x:s},a={axis:t,keepDims:n};return Ps.runKernel("Sum",r,a)}});const fl=Js({logSoftmax_:function(e,t=-1){const n=Ks(e,"logits","logSoftmax");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);return il((e,n)=>{const s=hl(e,t,!0),r=pl(e,s),a=pl(zr(r,"float32"),Qo(dl(_o(r),t,!0)));n([a]);return{value:a,gradFunc:(e,n)=>{const[s]=n,r=_o(s);return pl(e,fi(dl(e,t,!0),r))}}})(n)}});function ml(e,t){for(let n=0;n<e.length;++n)if(e[e.length-n-1]!==t-1-n)return!1;return!0}function gl(e,t,n){const s=e.length+t.length,r=[];let a=0,i=0;for(let o=0;o<s;o++)-1===n.indexOf(o)?r.push(e[a++]):r.push(t[i++]);return r}function yl(e,t){const n=[],s=e.length;for(let r=0;r<s;r++)-1===t.indexOf(r)&&n.push(e[r]);return[n,t.map(t=>e[t])]}function bl(e,t){return gl(e,t.map(e=>1),t)}function xl(e,t,n){o(ml(t,n),()=>e+" supports only inner-most axes for now. "+`Got axes ${t} and rank-${n} input.`)}function wl(e,t){if(ml(e,t))return null;const n=[];for(let s=0;s<t;++s)-1===e.indexOf(s)&&n.push(s);return e.forEach(e=>n.push(e)),n}function kl(e){return e.map((e,t)=>[t,e]).sort((e,t)=>e[1]-t[1]).map(e=>e[0])}function vl(e,t){const n=[];for(let s=t-e;s<t;++s)n.push(s);return n}const Nl=Js({logSumExp_:function(e,t=null,n=!1){const s=Ks(e,"x","logSumExp"),r=b(t,s.shape),a=hl(s,r,!0),i=pl(s,a),o=_o(i),l=dl(o,r),u=Qo(l),c=hi(Wi(a,u.shape),u);if(n){const e=bl(c.shape,r);return Wi(c,e)}return c}});const Il=Js({logicalAnd_:function(e,t){const n=Ks(e,"a","logicalAnd","bool"),s=Ks(t,"b","logicalAnd","bool");So(n.shape,s.shape);const r={a:n,b:s};return Ps.runKernel("LogicalAnd",r)}});const Cl=Js({logicalNot_:function(e){const t={x:Ks(e,"x","logicalNot","bool")};return Ps.runKernel("LogicalNot",t)}});const Sl=Js({logicalOr_:function(e,t){const n=Ks(e,"a","logicalOr","bool"),s=Ks(t,"b","logicalOr","bool");So(n.shape,s.shape);const r={a:n,b:s};return Ps.runKernel("LogicalOr",r)}});const Tl=Js({logicalXor_:function(e,t){const n=Ks(e,"a","logicalXor","bool"),s=Ks(t,"b","logicalXor","bool");return So(n.shape,s.shape),Il(Sl(e,t),Cl(Il(e,t)))}});const El=Js({maxPool_:function(e,t,n,s,r){const a=Ks(e,"x","maxPool");let i=a,l=!1;3===a.rank&&(l=!0,i=Wi(a,[1,a.shape[0],a.shape[1],a.shape[2]])),o(4===i.rank,()=>`Error in maxPool: input must be rank 4 but got rank ${i.rank}.`),o(Bi(n,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`),null!=r&&o(d(s),()=>`Error in maxPool: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`);const u={x:i},c={filterSize:t,strides:n,pad:s,dimRoundingMode:r},h=Ps.runKernel("MaxPool",u,c);return l?Wi(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const $l=Js({maxPool3d_:function(e,t=[1,1,1],n,s,r,a="NDHWC"){const i=Ks(e,"x","maxPool3d");let l=i,u=!1;4===i.rank&&(u=!0,l=Wi(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),o(5===l.rank,()=>`Error in maxPool3d: x must be rank 5 but got rank ${l.rank}.`),o("NDHWC"===a,()=>"Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of "+a),null!=r&&o(d(s),()=>`Error in maxPool3d: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`);const c={x:l},h={filterSize:t,strides:n,pad:s,dimRoundingMode:r,dataFormat:a},p=Ps.runKernel("MaxPool3D",c,h);return u?Wi(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const Al=Js({maxPoolWithArgmax_:function(e,t,n,s,r=!1){const a={x:Ks(e,"x","maxPoolWithArgmax")},i={filterSize:t,strides:n,pad:s,includeBatchInIndex:r},o=Ps.runKernel("MaxPoolWithArgmax",a,i);return{result:o[0],indexes:o[1]}}});const Rl=Js({maximum_:function(e,t){let n=Ks(e,"a","maximum"),s=Ks(t,"b","maximum");[n,s]=Rs(n,s),"bool"===n.dtype&&(n=zr(n,"int32"),s=zr(s,"int32")),So(n.shape,s.shape);const r={a:n,b:s};return Ps.runKernel("Maximum",r)}});const Fl=Js({mean_:function(e,t=null,n=!1){const s={x:Ks(e,"x","mean")},r={axis:t,keepDims:n};return Ps.runKernel("Mean",s,r)}});const Dl=Js({min_:function(e,t=null,n=!1){const s={x:Ks(e,"x","min")},r={axis:t,keepDims:n};return Ps.runKernel("Min",s,r)}});const _l=Js({minimum_:function(e,t){let n=Ks(e,"a","minimum"),s=Ks(t,"b","minimum");[n,s]=Rs(n,s),"bool"===n.dtype&&(n=zr(n,"int32"),s=zr(s,"int32")),So(n.shape,s.shape);const r={a:n,b:s};return Ps.runKernel("Minimum",r)}});const Ol=Js({mirrorPad_:function(e,t,n){o("reflect"===n||"symmetric"===n,()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`);const s=Ks(e,"x","mirrorPad");if(0===s.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");o(t.length===s.rank,()=>`Padding doesn't match input. Must be ${s.rank}. Got ${t.length}.`);const r="reflect"===n?1:0;for(let e=0;e<s.rank;e++)o(2===t[e].length,()=>"Invalid number of paddings. Must be length of 2 each."),o(t[e][0]>=0&&t[e][0]<=s.shape[e]-r&&t[e][1]>=0&&t[e][1]<=s.shape[e]-r,()=>`Padding in dimension ${e} cannot be greater than or equal to ${s.shape[e]-r} or less than 0 for input of shape `+s.shape);const a={paddings:t,mode:n},i={x:s};return Ps.runKernel("MirrorPad",i,a)}});const Ml=Js({mod_:function(e,t){let n=Ks(e,"a","mod"),s=Ks(t,"b","mod");[n,s]=Rs(n,s);const r={a:n,b:s};return Ps.runKernel(Ot,r)}});const Ll=Js({square_:function(e){const t=Ks(e,"x","square");return Ps.runKernel("Square",{x:t},{})}});const zl=Js({moments_:function(e,t=null,n=!1){const s=b(t,(e=Ks(e,"x","moments")).shape),r=Fl(e,s,n);let a=r.shape;n||(a=bl(r.shape,s));const i=Ll(pl(zr(e,"float32"),Wi(r,a)));return{mean:r,variance:Fl(i,s,n)}}});const Bl=Js({multiRNNCell_:function(e,t,n,s){const r=Ks(t,"data","multiRNNCell"),a=Xs(n,"c","multiRNNCell"),i=Xs(s,"h","multiRNNCell");let o=r;const l=[];for(let t=0;t<e.length;t++){const n=e[t](o,a[t],i[t]);l.push(n[0]),l.push(n[1]),o=n[1]}const u=[],c=[];for(let e=0;e<l.length;e+=2)u.push(l[e]),c.push(l[e+1]);return[u,c]}});const Pl=Js({multinomial_:function(e,t,n,s=!1){const r=Ks(e,"logits","multinomial"),a=r.size,i=r.rank;if(a<2)throw new Error("Error in multinomial: you need at least 2 outcomes, but got "+a+".");if(i>2)throw new Error("Rank of probabilities must be 1 or 2, but is "+i);n=n||Math.random();const o={logits:1===i?Wi(r,[1,-1]):r},l={numSamples:t,seed:n,normalized:s},u=Ps.runKernel("Multinomial",o,l);return 1===i?Wi(u,[u.size]):u}});const Wl=Js({notEqual_:function(e,t){let n=Ks(e,"a","notEqual"),s=Ks(t,"b","notEqual");[n,s]=Rs(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Ps.runKernel("NotEqual",r)}});function Vl(e,t="float32"){if("complex64"===t){const t=Vl(e,"float32"),n=Vl(e,"float32");return Zs(t,n)}const n=L(h(e),t);return Ps.makeTensor(n,e,t)}function Ul(e,t="float32"){if("complex64"===t){const t=Ul(e,"float32"),n=Vl(e,"float32");return Zs(t,n)}const n=M(h(e),t);return Ps.makeTensor(n,e,t)}const Gl=Js({onesLike_:function(e){const t={x:Ks(e,"x","onesLike")};return Ps.runKernel("OnesLike",t)}});const Hl=Js({outerProduct_:function(e,t){const n=Ks(e,"v1","outerProduct"),s=Ks(t,"v2","outerProduct");o(1===n.rank&&1===s.rank,()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${s.rank}.`);const r=Wi(n,[-1,1]),a=Wi(s,[1,-1]);return na(r,a)}});const jl=Js({pad_:function(e,t,n=0){const s=Ks(e,"x","pad");if(0===s.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const r={paddings:t,constantValue:n},a={x:s};return Ps.runKernel("PadV2",a,r)}});const ql=Js({pad1d_:function(e,t,n=0){return o(2===t.length,()=>"Invalid number of paddings. Must be length of 2."),jl(e,[t],n)}});const Kl=Js({pad2d_:function(e,t,n=0){return o(2===t.length&&2===t[0].length&&2===t[1].length,()=>"Invalid number of paddings. Must be length of 2 each."),jl(e,t,n)}});const Xl=Js({pad3d_:function(e,t,n=0){return o(3===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length,()=>"Invalid number of paddings. Must be length of 2 each."),jl(e,t,n)}});const Yl=Js({pad4d_:function(e,t,n=0){return o(4===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length&&2===t[3].length,()=>"Invalid number of paddings. Must be length of 2 each."),jl(e,t,n)}});const Jl=Js({spaceToBatchND_:function(e,t,n){const s=Ks(e,"x","spaceToBatchND");o(s.rank>=1+t.length,()=>`input rank ${s.rank} should be > than [blockShape] ${t.length}`),o(n.length===t.length,()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`),o(s.shape.reduce((e,s,r)=>r>0&&r<=t.length?e&&(s+n[r-1][0]+n[r-1][1])%t[r-1]==0:e,!0),()=>`input spatial dimensions ${s.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`);const r={x:s},a={blockShape:t,paddings:n};return Ps.runKernel("SpaceToBatchND",r,a)}});const Zl=Js({pool_:function(e,t,n,s,r,a){null==r&&(r=[1,1]),null==a&&(a=1),0===s&&(s="valid");const i=Ks(e,"x","maxPool");let l=i,u=!1;3===i.rank&&(u=!0,l=Wi(i,[1,i.shape[0],i.shape[1],i.shape[2]])),o(Bi(a,r),()=>`Error in pool: Either strides or dilations must be 1. Got strides ${a} and dilations '${r}'`);const c=$i(l.shape,t,a,r,s),h=[c.dilationHeight,c.dilationWidth];let p;p="same"===s?function(e,t){const n=e.map((e,n)=>e+(e-1)*(t[n]-1)).map(e=>e-1),s=n.map(e=>Math.floor(e/2)),r=n.map((e,t)=>e-s[t]);return n.map((e,t)=>[s[t],r[t]])}([c.filterHeight,c.filterWidth],h):[[0,0],[0,0]];const d=1===h[0]&&1===h[1],[f,m]=function(e,t,n){const s=n.map(e=>e[0]),r=n.map(e=>e[1]),a=e.concat(s,r),i=t.map((e,t)=>(e-a[t]%e)%e),o=r.map((e,t)=>e+i[t]),l=t.map((e,t)=>[s[t],o[t]]),u=t.map((e,t)=>[0,i[t]]);return[l,u]}([c.inHeight,c.inWidth],h,p),g=d?s:"valid",y=d?l:Jl(l,h,f),b=("avg"===n?()=>Vi(y,t,a,g):()=>El(y,t,a,g))(),x=d?b:Xi(b,h,m);return u?Wi(x,[x.shape[1],x.shape[2],x.shape[3]]):x}});const Ql=Js({pow_:function(e,t){let n=Ks(e,"base","pow"),s=Ks(t,"exp","pow");[n,s]=Rs(n,s);const r={a:n,b:s};return Ps.runKernel(Kt,r)}});const eu=Js({prelu_:function(e,t){const n={x:Ks(e,"x","prelu"),alpha:Ks(t,"alpha","prelu")};return Ps.runKernel("Prelu",n)}});const tu=Js({prod_:function(e,t=null,n=!1){let s=Ks(e,"x","prod");"bool"===s.dtype&&(s=zr(s,"int32"));const r={x:s},a={axis:t,keepDims:n};return Ps.runKernel("Prod",r,a)}});const nu=Js({rand_:function(e,t,n){const s=h(e);let r=null;if(null==n||"float32"===n)r=new Float32Array(s);else if("int32"===n)r=new Int32Array(s);else{if("bool"!==n)throw new Error("Unknown data type "+n);r=new Uint8Array(s)}for(let e=0;e<s;e++)r[e]=t();return Ps.makeTensor(r,e,n)}});"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self&&self;function su(e,t){return e(t={exports:{}},t.exports),t.exports}var ru=su((function(e){!function(e,t,n){function s(e){var t,n=this,s=(t=4022871197,function(e){e=e.toString();for(var n=0;n<e.length;n++){var s=.02519603282416938*(t+=e.charCodeAt(n));s-=t=s>>>0,t=(s*=t)>>>0,t+=4294967296*(s-=t)}return 2.3283064365386963e-10*(t>>>0)});n.next=function(){var e=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=e-(n.c=0|e)},n.c=1,n.s0=s(" "),n.s1=s(" "),n.s2=s(" "),n.s0-=s(e),n.s0<0&&(n.s0+=1),n.s1-=s(e),n.s1<0&&(n.s1+=1),n.s2-=s(e),n.s2<0&&(n.s2+=1),s=null}function r(e,t){return t.c=e.c,t.s0=e.s0,t.s1=e.s1,t.s2=e.s2,t}function a(e,t){var n=new s(e),a=t&&t.state,i=n.next;return i.int32=function(){return 4294967296*n.next()|0},i.double=function(){return i()+11102230246251565e-32*(2097152*i()|0)},i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.alea=a}(0,e,!1)})),au=su((function(e){!function(e,t,n){function s(e){var t=this,n="";t.x=0,t.y=0,t.z=0,t.w=0,t.next=function(){var e=t.x^t.x<<11;return t.x=t.y,t.y=t.z,t.z=t.w,t.w^=t.w>>>19^e^e>>>8},e===(0|e)?t.x=e:n+=e;for(var s=0;s<n.length+64;s++)t.x^=0|n.charCodeAt(s),t.next()}function r(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor128=a}(0,e,!1)})),iu=su((function(e){!function(e,t,n){function s(e){var t=this,n="";t.next=function(){var e=t.x^t.x>>>2;return t.x=t.y,t.y=t.z,t.z=t.w,t.w=t.v,(t.d=t.d+362437|0)+(t.v=t.v^t.v<<4^e^e<<1)|0},t.x=0,t.y=0,t.z=0,t.w=0,t.v=0,e===(0|e)?t.x=e:n+=e;for(var s=0;s<n.length+64;s++)t.x^=0|n.charCodeAt(s),s==n.length&&(t.d=t.x<<10^t.x>>>4),t.next()}function r(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t.v=e.v,t.d=e.d,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorwow=a}(0,e,!1)})),ou=su((function(e){!function(e,t,n){function s(e){var t=this;t.next=function(){var e,n,s=t.x,r=t.i;return e=s[r],n=(e^=e>>>7)^e<<24,n^=(e=s[r+1&7])^e>>>10,n^=(e=s[r+3&7])^e>>>3,n^=(e=s[r+4&7])^e<<7,e=s[r+7&7],n^=(e^=e<<13)^e<<9,s[r]=n,t.i=r+1&7,n},function(e,t){var n,s=[];if(t===(0|t))s[0]=t;else for(t=""+t,n=0;n<t.length;++n)s[7&n]=s[7&n]<<15^t.charCodeAt(n)+s[n+1&7]<<13;for(;s.length<8;)s.push(0);for(n=0;n<8&&0===s[n];++n);for(8==n?s[7]=-1:s[n],e.x=s,e.i=0,n=256;n>0;--n)e.next()}(t,e)}function r(e,t){return t.x=e.x.slice(),t.i=e.i,t}function a(e,t){null==e&&(e=+new Date);var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&(a.x&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorshift7=a}(0,e,!1)})),lu=su((function(e){!function(e,t,n){function s(e){var t=this;t.next=function(){var e,n,s=t.w,r=t.X,a=t.i;return t.w=s=s+1640531527|0,n=r[a+34&127],e=r[a=a+1&127],n^=n<<13,e^=e<<17,n^=n>>>15,e^=e>>>12,n=r[a]=n^e,t.i=a,n+(s^s>>>16)|0},function(e,t){var n,s,r,a,i,o=[],l=128;for(t===(0|t)?(s=t,t=null):(t+="\0",s=0,l=Math.max(l,t.length)),r=0,a=-32;a<l;++a)t&&(s^=t.charCodeAt((a+32)%t.length)),0===a&&(i=s),s^=s<<10,s^=s>>>15,s^=s<<4,s^=s>>>13,a>=0&&(i=i+1640531527|0,r=0==(n=o[127&a]^=s+i)?r+1:0);for(r>=128&&(o[127&(t&&t.length||0)]=-1),r=127,a=512;a>0;--a)s=o[r+34&127],n=o[r=r+1&127],s^=s<<13,n^=n<<17,s^=s>>>15,n^=n>>>12,o[r]=s^n;e.w=i,e.X=o,e.i=r}(t,e)}function r(e,t){return t.i=e.i,t.w=e.w,t.X=e.X.slice(),t}function a(e,t){null==e&&(e=+new Date);var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&(a.X&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor4096=a}(0,e,!1)})),uu=su((function(e){!function(e,t,n){function s(e){var t=this,n="";t.next=function(){var e=t.b,n=t.c,s=t.d,r=t.a;return e=e<<25^e>>>7^n,n=n-s|0,s=s<<24^s>>>8^r,r=r-e|0,t.b=e=e<<20^e>>>12^n,t.c=n=n-s|0,t.d=s<<16^n>>>16^r,t.a=r-e|0},t.a=0,t.b=0,t.c=-1640531527,t.d=1367130551,e===Math.floor(e)?(t.a=e/4294967296|0,t.b=0|e):n+=e;for(var s=0;s<n.length+20;s++)t.b^=0|n.charCodeAt(s),t.next()}function r(e,t){return t.a=e.a,t.b=e.b,t.c=e.c,t.d=e.d,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.tychei=a}(0,e,!1)})),cu=su((function(e){!function(t,n){var s,r=this,a=n.pow(256,6),i=n.pow(2,52),o=2*i;function l(e,l,d){var f=[],m=h(function e(t,n){var s,r=[],a=typeof t;if(n&&"object"==a)for(s in t)try{r.push(e(t[s],n-1))}catch(e){}return r.length?r:"string"==a?t:t+"\0"}((l=1==l?{entropy:!0}:l||{}).entropy?[e,p(t)]:null==e?function(){try{var e;return s&&(e=s.randomBytes)?e=e(256):(e=new Uint8Array(256),(r.crypto||r.msCrypto).getRandomValues(e)),p(e)}catch(e){var n=r.navigator,a=n&&n.plugins;return[+new Date,r,a,r.screen,p(t)]}}():e,3),f),g=new u(f),y=function(){for(var e=g.g(6),t=a,n=0;e<i;)e=256*(e+n),t*=256,n=g.g(1);for(;e>=o;)e/=2,t/=2,n>>>=1;return(e+n)/t};return y.int32=function(){return 0|g.g(4)},y.quick=function(){return g.g(4)/4294967296},y.double=y,h(p(g.S),t),(l.pass||d||function(e,t,s,r){return r&&(r.S&&c(r,g),e.state=function(){return c(g,{})}),s?(n.random=e,t):e})(y,m,"global"in l?l.global:this==n,l.state)}function u(e){var t,n=e.length,s=this,r=0,a=s.i=s.j=0,i=s.S=[];for(n||(e=[n++]);r<256;)i[r]=r++;for(r=0;r<256;r++)i[r]=i[a=255&a+e[r%n]+(t=i[r])],i[a]=t;(s.g=function(e){for(var t,n=0,r=s.i,a=s.j,i=s.S;e--;)t=i[r=255&r+1],n=256*n+i[255&(i[r]=i[a=255&a+t])+(i[a]=t)];return s.i=r,s.j=a,n})(256)}function c(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function h(e,t){for(var n,s=e+"",r=0;r<s.length;)t[255&r]=255&(n^=19*t[255&r])+s.charCodeAt(r++);return p(t)}function p(e){return String.fromCharCode.apply(0,e)}if(n.seedrandom=l,h(n.random(),t),e.exports){e.exports=l;try{s=require("crypto")}catch(e){}}else 0}([],Math)}));cu.alea=ru,cu.xor128=au,cu.xorwow=iu,cu.xorshift7=ou,cu.xor4096=lu,cu.tychei=uu;var hu=cu.alea;class pu{constructor(e,t,n,s,r){this.mean=e,this.stdDev=t,this.dtype=n,this.nextVal=NaN,this.truncated=s,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const a=r||Math.random();this.random=hu(a.toString())}nextValue(){if(!isNaN(this.nextVal)){const e=this.nextVal;return this.nextVal=NaN,e}let e,t,n=!1;for(;!n;){let s,r,a;do{s=2*this.random()-1,r=2*this.random()-1,a=s*s+r*r}while(a>=1||0===a);const i=Math.sqrt(-2*Math.log(a)/a);e=this.mean+this.stdDev*s*i,t=this.mean+this.stdDev*r*i,this.truncated&&!this.isValidTruncated(e)||(n=!0)}return this.truncated&&!this.isValidTruncated(t)||(this.nextVal=this.convertValue(t)),this.convertValue(e)}convertValue(e){return null==this.dtype||"float32"===this.dtype?e:Math.round(e)}isValidTruncated(e){return e<=this.upper&&e>=this.lower}}class du{constructor(e,t,n,s){this.alpha=e,this.beta=1/t,this.dtype=n;const r=s||Math.random();this.randu=hu(r.toString()),this.randn=new pu(0,1,n,!1,this.randu()),this.d=e<1?e+2/3:e-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let e,t,n,s,r,a;for(;;){do{s=this.randn.nextValue(),a=1+this.c*s}while(a<=0);if(a*=a*a,e=s*s,t=1-.331*e*e,n=.5*e+this.d*(1-a+Math.log(a)),r=this.randu(),r<t||Math.log(r)<n)break}return a=1/this.beta*this.d*a,this.alpha<1&&(a*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(a)}convertValue(e){return"float32"===this.dtype?e:Math.round(e)}}class fu{constructor(e=0,t=1,n,s){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=e,this.range=t-e,this.dtype=n,null==s&&(s=Math.random()),"number"==typeof s&&(s=s.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);this.random=hu(s)}convertValue(e){return this.canReturnFloat()?e:Math.round(e)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const mu=Js({randomGamma_:function(e,t,n=1,s="float32",r){if(null==n&&(n=1),null==s&&(s="float32"),"float32"!==s&&"int32"!==s)throw new Error("Unsupported data type "+s);const a=new du(t,n,s,r),i=Lr(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const gu=Js({randomNormal_:function(e,t=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error("Unsupported data type "+s);const a=new pu(t,n,s,!1,r),i=Lr(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const yu=Js({randomUniform_:function(e,t=0,n=1,s="float32",r){const a=Lr(e,s),i=new fu(t,n,null,r);for(let e=0;e<a.values.length;e++)a.values[e]=i.nextValue();return a.toTensor()}});function bu(e,t,n=1,s="float32"){if(0===n)throw new Error("Cannot have a step of zero");const r={start:e,stop:t,step:n,dtype:s};return Ps.runKernel("Range",{},r)}const xu=Js({real_:function(e){const t={input:Ks(e,"input","real")};return Ps.runKernel("Real",t)}});const wu=Js({reciprocal_:function(e){const t={x:Ks(e,"x","reciprocal")};return Ps.runKernel("Reciprocal",t)}});const ku=Js({relu_:function(e){const t={x:Ks(e,"x","relu")};return Ps.runKernel("Relu",t)}});const vu=Js({relu6_:function(e){const t={x:Ks(e,"x","relu6")};return Ps.runKernel("Relu6",t)}});const Nu=Js({reverse_:function(e,t){const n={x:Ks(e,"x","reverse")},s={dims:t};return Ps.runKernel("Reverse",n,s)}});const Iu=Js({reverse1d_:function(e){const t=Ks(e,"x","reverse");return o(1===t.rank,()=>`Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`),Nu(t,0)}});const Cu=Js({reverse2d_:function(e,t){const n=Ks(e,"x","reverse");return o(2===n.rank,()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`),Nu(n,t)}});const Su=Js({reverse3d_:function(e,t){const n=Ks(e,"x","reverse");return o(3===n.rank,()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`),Nu(n,t)}});const Tu=Js({reverse4d_:function(e,t){const n=Ks(e,"x","reverse");return o(4===n.rank,()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`),Nu(n,t)}});const Eu=Js({round_:function(e){const t={x:Ks(e,"x","round")};return Ps.runKernel("Round",t)}});const $u=Js({rsqrt_:function(e){const t={x:Ks(e,"x","rsqrt")};return Ps.runKernel("Rsqrt",t)}});function Au(e,t){if((C(e)&&"string"!==t||Array.isArray(e))&&"complex64"!==t)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===t&&C(e)&&!(e instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return Qs(e,[],[],t)}const Ru=Js({selu_:function(e){const t={x:Ks(e,"x","selu")};return Ps.runKernel("Selu",t)}});const Fu=Js({separableConv2d_:function(e,t,n,s,r,a=[1,1],i="NHWC"){const l=Ks(e,"x","separableConv2d"),u=Ks(t,"depthwiseFilter","separableConv2d"),c=Ks(n,"pointwiseFilter","separableConv2d");let h=l,p=!1;if(3===l.rank&&(p=!0,h=Wi(l,[1,l.shape[0],l.shape[1],l.shape[2]])),"NCHW"===i)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");o(4===h.rank,()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`),o(4===u.rank,()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${u.rank}.`),o(4===c.rank,()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${u.rank}.`),o(1===c.shape[0],()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${c.shape[0]}.`),o(1===c.shape[1],()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${c.shape[1]}.`);const d=u.shape[2],f=u.shape[3];o(c.shape[2]===d*f,()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${d*f}, but got ${c.shape[2]}.`);const m=ko(h,u,s,r,i,a),g=lo(m,c,1,"valid",i);return p?Wi(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const Du=async function(e,t){const n=Ks(e,"x","setdiff1d"),s=Ks(t,"y","setdiff1d");o(n.dtype===s.dtype,()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${s.dtype}).`),o(1===n.rank,()=>`x should be 1D tensor, but got x (${n.shape}).`),o(1===s.rank,()=>`y should be 1D tensor, but got y (${s.shape}).`);const r=await n.data(),a=await s.data(),i=new Set(a);let l=0;for(let e=0;e<r.length;e++)i.has(r[e])||l++;const u=new gs([l],n.dtype),c=new gs([l],"int32");for(let e=0,t=0;e<r.length;e++)i.has(r[e])||(u.values[t]=r[e],c.values[t]=e,t++);return[u.toTensor(),c.toTensor()]};const _u=Js({sign_:function(e){const t={x:Ks(e,"x","sign")};return Ps.runKernel("Sign",t)}});const Ou=Js({sin_:function(e){const t={x:Ks(e,"x","sin")};return Ps.runKernel(mn,t)}});const Mu=Js({sinh_:function(e){const t={x:Ks(e,"x","sinh")};return Ps.runKernel("Sinh",t)}});const Lu=Js({slice1d_:function(e,t,n){const s=Ks(e,"x","slice1d");return o(1===s.rank,()=>`slice1d expects a rank-1 tensor, but got a rank-${s.rank} tensor`),ji(s,[t],[n])}});const zu=Js({slice2d_:function(e,t,n){const s=Ks(e,"x","slice2d");return o(2===s.rank,()=>`slice2d expects a rank-2 tensor, but got a rank-${s.rank} tensor`),ji(s,t,n)}});const Bu=Js({slice3d_:function(e,t,n){const s=Ks(e,"x","slice3d");return o(3===s.rank,()=>`slice3d expects a rank-3 tensor, but got a rank-${s.rank} tensor`),ji(s,t,n)}});const Pu=Js({slice4d_:function(e,t,n){const s=Ks(e,"x","slice4d");return o(4===s.rank,()=>`slice4d expects a rank-4 tensor, but got a rank-${s.rank} tensor`),ji(s,t,n)}});const Wu=Js({softmax_:function(e,t=-1){const n=Ks(e,"logits","softmax","float32");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);const s={logits:n},r={dim:t};return Ps.runKernel("Softmax",s,r)}});const Vu=Js({fft_:function(e){o("complex64"===e.dtype,()=>`The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`);const t={input:e};return Ps.runKernel("FFT",t)}});const Uu=Js({ifft_:function(e){o("complex64"===e.dtype,()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`);const t={input:e};return Ps.runKernel("IFFT",t)}});const Gu=Js({irfft_:function(e){const t=e.shape[e.shape.length-1],n=e.size/t;let s;if(t<=2){const r=Wi(e,[n,t]);s=Uu(r)}else{const r=[n,2*(t-1)],a=Wi(xu(e),[n,t]),i=Wi(Go(e),[n,t]),o=Nu(ji(a,[0,1],[n,t-2]),1),l=fi(Nu(ji(i,[0,1],[n,t-2]),1),Au(-1)),u=Gi([a,o],1),c=Gi([i,l],1),h=Wi(Zs(u,c),[r[0],r[1]]);s=Uu(h)}if(s=xu(s),3===e.rank&&0!==e.shape[0]){const t=s,n=e.shape[0];s=Wi(s,[n,s.shape[0]/n,s.shape[1]]),t.dispose()}return s}});const Hu=Js({split_:function(e,t,n=0){const s={x:Ks(e,"x","split")},r={numOrSizeSplits:t,axis:n};return Ps.runKernel("SplitV",s,r)}});const ju=Js({rfft_:function(e,t){o("float32"===e.dtype,()=>"The dtype for rfft() must be real value but got "+e.dtype);let n=e.shape[e.shape.length-1];const s=e.size/n;let r;if(null!=t&&t<n){const s=e.shape.map(e=>0),a=e.shape.map(e=>e);a[e.shape.length-1]=t,r=ji(e,s,a),n=t}else if(null!=t&&t>n){const s=e.shape.map(e=>e);s[e.shape.length-1]=t-n,r=Gi([e,Vl(s)],e.shape.length-1),n=t}else r=e;const a=$o(r),i=Wi(Zs(r,a),[s,n]),l=Vu(i),u=Math.floor(n/2)+1,c=xu(l),h=Go(l),p=Hu(c,[u,n-u],c.shape.length-1),d=Hu(h,[u,n-u],h.shape.length-1),f=r.shape.slice();return f[r.shape.length-1]=u,Wi(Zs(p[0],d[0]),f)}});const qu=Js({sqrt_:function(e){const t={x:Ks(e,"x","sqrt")};return Ps.runKernel("Sqrt",t)}});const Ku=Js({squaredDifference_:function(e,t){let n=Ks(e,"a","squaredDifference"),s=Ks(t,"b","squaredDifference");[n,s]=Rs(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Ps.runKernel("SquaredDifference",r,{})}});const Xu=Js({squeeze_:function(e,t){const n=Ks(e,"x","squeeze");return Wi(n,x(n.shape,t).newShape)}});const Yu=Js({stack_:function(e,t=0){const n=Xs(e,"tensors","stack","string_or_numeric");o(n.length>=1,()=>"Pass at least one tensor to tf.stack"),n.length>0&&o(t<=n[0].rank,()=>"Axis must be <= rank of the tensor");const s=n,r={axis:t};return Ps.runKernel("Pack",s,r)}});const Ju=Js({step_:function(e,t=0){const n={x:Ks(e,"x","step")},s={alpha:t};return Ps.runKernel("Step",n,s)}});const Zu=Js({stridedSlice_:function(e,t,n,s,r=0,a=0,i=0,o=0,l=0){const u={x:Ks(e,"x","stridedSlice")},c={begin:t,end:n,strides:s,beginMask:r,endMask:a,ellipsisMask:i,newAxisMask:o,shrinkAxisMask:l};return Ps.runKernel("StridedSlice",u,c)}});const Qu=Js({tan_:function(e){const t={x:Ks(e,"x","tan")};return Ps.runKernel(An,t)}});function ec(e,t){u(e);const n=js(e,t);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return Qs(e,null,n,t)}function tc(e,t,n){if(u(e),null!=t&&2!==t.length)throw new Error("tensor2d() requires shape to have two numbers");const s=js(e,n);if(2!==s.length&&1!==s.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return Qs(e,t,s,n)}function nc(e,t,n){if(u(e),null!=t&&4!==t.length)throw new Error("tensor4d() requires shape to have four numbers");const s=js(e,n);if(4!==s.length&&1!==s.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return Qs(e,t,s,n)}function sc(e,t,n){if(u(e),null!=t&&5!==t.length)throw new Error("tensor5d() requires shape to have five numbers");const s=js(e,n);if(5!==s.length&&1!==s.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return Qs(e,t,s,n)}function rc(e,t,n){if(u(e),null!=t&&6!==t.length)throw new Error("tensor6d() requires shape to have six numbers");const s=js(e,n);if(6!==s.length&&1!==s.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return Qs(e,t=t||s,s,n)}const ac=Js({topk_:function(e,t=1,n=!0){const s=Ks(e,"x","topk");if(0===s.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const r=s.shape[s.shape.length-1];if(t>r)throw new Error(`'k' passed to topk() must be <= the last dimension (${r}) but got `+t);const a={x:s},i={k:t,sorted:n},[o,l]=Ps.runKernel("TopK",a,i);return{values:o,indices:l}}});const ic=Js({truncatedNormal_:function(e,t=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error("Unsupported data type $ { dtype }");const a=new pu(t,n,s,!0,r),i=Lr(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const oc=Js({unique_:function(e,t=0){const n=Ks(e,"x","unique","string_or_numeric");o(n.rank>0,()=>"The input tensor must be at least 1D");const s={x:n},r={axis:t},[a,i]=Ps.runKernel("Unique",s,r);return{values:a,indices:i}}});const lc=Js({unsortedSegmentSum_:function(e,t,n){const s=Ks(e,"x","unsortedSegmentSum"),r=Ks(t,"segmentIds","unsortedSegmentSum","int32");o(d(n),()=>"numSegments must be of dtype int");const a={x:s,segmentIds:r},i={numSegments:n};return Ps.runKernel("UnsortedSegmentSum",a,i)}});const uc=Js({unstack_:function(e,t=0){const n=Ks(e,"x","unstack","string_or_numeric");o(t>=-n.shape.length&&t<n.shape.length,()=>`Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`);const s={value:n},r={axis:t};return Ps.runKernel("Unpack",s,r)}});function cc(e,t=!0,n,s){return Ps.makeVariable(e,t,n,s)}function hc(e,t){const n=[];for(let e=0;e<t.length;e++)t[e]&&n.push(e);const s=Lr(e,"int32"),r=Lr([n.length,e.length],"int32");for(let t=0;t<n.length;t++){const a=s.indexToLoc(n[t]),i=t*e.length;r.values.set(a,i)}return r.toTensor()}const pc=async function(e){const t=Ks(e,"condition","whereAsync","bool"),n=await t.data(),s=hc(t.shape,n);return e!==t&&t.dispose(),s};const dc=async function(e,t,n){const s=Ks(e,"tensor","boolMask"),r=Ks(t,"mask","boolMask","bool"),a=null==n?0:n,i=r.rank,u=s.shape;o(i>0,()=>"mask cannot be scalar"),l(u.slice(a,a+i),r.shape,"mask's shape must match the first K dimensions of tensor's shape,");let c=1;for(let e=a;e<a+i;e++)c*=u[e];const h=u.slice(0,a).concat([c],u.slice(a+i)),p=Wi(s,h),d=Wi(r,[-1]),f=await pc(d),m=Xu(f,[1]),g=Wo(p,m,a);return e!==s&&s.dispose(),t!==r&&r.dispose(),m.dispose(),p.dispose(),d.dispose(),f.dispose(),g};const fc=Js({norm_:function(e,t="euclidean",n=null,s=!1){const r=function e(t,n,s=null){if(0===t.rank)return mi(t);if(1!==t.rank&&null===s)return e(Wi(t,[-1]),n,s);if(1===t.rank||"number"==typeof s||Array.isArray(s)&&1===s.length){if(1===n)return dl(mi(t),s);if(n===1/0)return hl(mi(t),s);if(n===-1/0)return Dl(mi(t),s);if("euclidean"===n||2===n)return qu(dl(Ql(mi(t),Au(2,"int32")),s));throw new Error("Error in norm: invalid ord value: "+n)}if(Array.isArray(s)&&2===s.length){if(1===n)return hl(dl(mi(t),s[0]),s[1]-1);if(n===1/0)return hl(dl(mi(t),s[1]),s[0]);if(n===-1/0)return Dl(dl(mi(t),s[1]),s[0]);if("fro"===n||"euclidean"===n)return qu(dl(Ll(t),s));throw new Error("Error in norm: invalid ord value: "+n)}throw new Error("Error in norm: invalid axis: "+s)}(e=Ks(e,"x","norm"),t,n);let a=r.shape;if(s){const t=b(n,e.shape);a=bl(r.shape,t)}return Wi(r,a)}});const mc=Js({movingAverage_:function(e,t,n,s,r=!0){const a=Ks(e,"v","movingAverage"),i=Ks(t,"x","movingAverage"),l=Ks(n,"decay","movingAverage");Fs(a,i),o(p(a.shape,i.shape),()=>"Shape mismatch in v and x");const u=Au(1),c=pl(u,l);let h=fi(pl(i,a),c);if(r){o(null!=s,()=>"When using zeroDebias: true, step is required.");const e=Ks(s,"step","movingAverage");h=di(h,pl(u,Ql(l,e)))}return hi(a,h)}});const gc=Js({scatterND_:function(e,t,n){const s=Ks(e,"indices","scatterND","int32"),r=Ks(t,"updates","scatterND");fa(r,s,n);const a={indices:s,updates:r},i={shape:n};return Ps.runKernel("ScatterNd",a,i)}});const yc=Js({sparseToDense_:function(e,t,n,s=0){const r=Ks(e,"sparseIndices","sparseToDense","int32"),a=Ks(t,"sparseValues","sparseToDense"),i=Ks(s,"defaultValue","sparseToDense",a.dtype);!function(e,t,n,s){if("int32"!==e.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);const r=e.rank>0?e.shape[0]:1,a=e.rank>1?e.shape[1]:1;if(n.length!==a)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${a}.`);const i=t.size;if(0!==t.rank&&(1!==t.rank||i!==r))throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${r}]`);if(t.dtype!==s.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(r,a,n,i);const o={sparseIndices:r,sparseValues:a,defaultValue:i},l={outputShape:n};return Ps.runKernel("SparseToDense",o,l)}});const bc=Js({gatherND_:function(e,t){const n=Ks(t,"indices","gatherND","int32"),s={params:Ks(e,"x","gatherND"),indices:n};return Ps.runKernel("GatherNd",s)}});const xc=Js({dropout_:function(e,t,n,s){const r=Ks(e,"x","dropout");if(o("float32"===r.dtype,()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${r.dtype} tensor instead.`),o(t>=0&&t<1,()=>`rate must be a float in the range [0, 1), but got ${t}.`),0===t)return e instanceof ws?r.clone():r;const a=function(e,t){if(null==t)return e.shape.slice();if(p(e.shape,t))return t;if(e.shape.length===t.length){const n=[];for(let s=0;s<e.shape.length;s++)null==t[s]&&null!=e.shape[s]?n.push(e.shape[s]):n.push(t[s]);return n}return t}(r,n),i=1-t,l=di(Po(hi(yu(a,0,1,"float32",s),i)),i);return fi(r,l)}});function wc(e){return Math.floor(Math.pow(2,Math.ceil(Math.log(e)/Math.log(2))))}function kc(e,t,n){const s=1-e%2,r=new Float32Array(e);for(let a=0;a<e;++a){const i=2*Math.PI*a/(e+s-1);r[a]=t-n*Math.cos(i)}return ec(r,"float32")}const vc=async function(e,t,n=1){const s=Ks(e,"predictions","inTopK"),r=Ks(t,"targets","inTopK");o(s.rank>1,()=>"inTopK() expects the predictions to be of rank 2 or higher, but got "+s.rank),o(s.rank-1===r.rank,()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${s.rank} and targets rank ${r.rank}`),l(s.shape.slice(0,s.shape.length-1),r.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const a=s.shape[s.shape.length-1];o(n>0&&n<=a,()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${a}), but got ${n}`);const i=await s.data(),u=await r.data(),[c,h]=[i.length/a,a],p=w("bool",c);for(let e=0;e<c;e++){const t=e*h,s=i.subarray(t,t+h),r=[];for(let e=0;e<s.length;e++)r.push({value:s[e],index:e});r.sort((e,t)=>t.value-e.value),p[e]=0;for(let t=0;t<n;t++)if(r[t].index===u[e]){p[e]=1;break}}return e!==s&&s.dispose(),t!==r&&r.dispose(),er(p,r.shape,"bool")};const Nc=Js({conv2DBackpropFilter_:function(e,t,n,s,r,a="NHWC",i){let l=e;3===e.rank&&(l=Wi(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let u=t;3===u.rank&&(u=Wi(t,[1,t.shape[0],t.shape[1],t.shape[2]])),o(4===l.rank,()=>"Error in conv2dDerFilter: input must be rank 4, but got shape "+l.shape+"."),o(4===u.rank,()=>"Error in conv2dDerFilter: dy must be rank 4, but got shape "+u.shape+"."),o(4===n.length,()=>"Error in conv2dDerFilter: filterShape must be length 4, but got "+n+".");const c="NHWC"===a?l.shape[3]:l.shape[1],h="NHWC"===a?u.shape[3]:u.shape[1];o(c===n[2],()=>`Error in conv2dDerFilter: depth of input ${c}) must match input depth in filter (${n[2]}.`),o(h===n[3],()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`),null!=i&&o(d(r),()=>`Error in conv2dDerFilter: pad must be an integer when using, dimRoundingMode ${i} but got pad ${r}.`);const p={x:l,dy:u},f={strides:s,pad:r,dataFormat:a,dimRoundingMode:i,filterShape:n};return Ps.runKernel("Conv2DBackpropFilter",p,f)}});function Ic(e,t,n){if(null==n||"linear"===n)return e;if("relu"===n)return fi(e,Ju(t));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function Cc(e,t){let n=t;const s=Co(e.shape,t.shape);return s.length>0&&(n=dl(n,s)),Wi(n,e.shape)}function Sc(e,t,n,s){if("linear"===t)return e;if("relu"===t)return ku(e);if("elu"===t)return Fo(e);if("relu6"===t)return vu(e);if("prelu"===t)return eu(e,n);if("leakyrelu"===t)return Ko(e,s);throw new Error(`Unknown fused activation ${t}.`)}const Tc=(e,t)=>!(e>0)||"linear"===t;const Ec=Js({fusedConv2d_:function({x:e,filter:t,strides:n,pad:s,dataFormat:r="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:l,activation:u="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(u=u||"linear",!1===Tc(Ps.state.gradientDepth,u)){let o=lo(e,t,n,s,r,a,i);return null!=l&&(o=hi(o,l)),Sc(o,u,c,h)}const p=Ks(e,"x","conv2d"),f=Ks(t,"filter","conv2d");let m=p,g=!1;3===p.rank&&(g=!0,m=Wi(p,[1,p.shape[0],p.shape[1],p.shape[2]])),o(4===m.rank,()=>"Error in fused conv2d: input must be rank 4, but got rank "+m.rank+"."),o(4===f.rank,()=>"Error in fused conv2d: filter must be rank 4, but got rank "+f.rank+"."),null!=i&&o(d(s),()=>`Error in fused conv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`),o(m.shape[3]===f.shape[2],()=>`Error in conv2d: depth of input (${m.shape[3]}) must match input depth for filter ${f.shape[2]}.`),o(Bi(n,a),()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`),o("NHWC"===r,()=>`Error in conv2d: got dataFormat of ${r} but only NHWC is currently supported.`);const y=Ri(m.shape,f.shape,n,a,s,i);let b,x;null!=l&&(b=Ks(l,"bias","fused conv2d"),[b]=Rs(b,p),So(y.outShape,b.shape)),null!=c&&(x=Ks(c,"prelu weights","fused conv2d"));const w=(e,t)=>{const[r,i,l,c]=t,h=Ic(e,l,u);o(zi(a),()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`);const p=[co(i.shape,h,r,n,s),Nc(i,h,r.shape,n,s)];if(null!=c){const e=Cc(c,h);p.push(e)}return p},k={x:m,filter:f,bias:b,preluActivationWeights:x},v={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i,activation:u,leakyreluAlpha:h};if(null==l){return il((e,t,n)=>{let s=Ps.runKernel("FusedConv2D",k,v);return n([t,e,s]),g&&(s=Wi(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}})(m,f)}return il((e,t,n,s)=>{let r=Ps.runKernel("FusedConv2D",k,v);return s([t,e,r,n]),g&&(r=Wi(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}})(m,f,b)}});const $c=Js({depthwiseConv2dNativeBackpropFilter_:function(e,t,n,s,r,a=[1,1],i){let o=e;3===e.rank&&(o=Wi(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=Wi(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={x:o,dy:l},c={strides:s,pad:r,dimRoundingMode:i,dilations:a,filterShape:n};return Ps.runKernel("DepthwiseConv2dNativeBackpropFilter",u,c)}});const Ac=Js({depthwiseConv2dNativeBackpropInput_:function(e,t,n,s,r,a=[1,1],i){let o=t,l=!1;3===t.rank&&(l=!0,o=Wi(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={dy:o,filter:n},c={strides:s,pad:r,dimRoundingMode:i,dilations:a,inputShape:e},h=Ps.runKernel("DepthwiseConv2dNativeBackpropInput",u,c);return l?Wi(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Rc=Js({fusedDepthwiseConv2d_:function({x:e,filter:t,strides:n,pad:s,dataFormat:r="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:l,activation:u="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(!1===Tc(Ps.state.gradientDepth,u)){let o=ko(e,t,n,s,r,a,i);return null!=l&&(o=hi(o,l)),Sc(o,u,c,h)}const p=Ks(e,"x","depthwiseConv2d"),f=Ks(t,"filter","depthwiseConv2d");let m=p,g=!1;3===p.rank&&(g=!0,m=Wi(p,[1,p.shape[0],p.shape[1],p.shape[2]])),o(4===m.rank,()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${m.rank}.`),o(4===f.rank,()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${f.rank}.`),o(m.shape[3]===f.shape[2],()=>`Error in fused depthwiseConv2d: number of input channels (${m.shape[3]}) must match the inChannels dimension in filter ${f.shape[2]}.`),null==a&&(a=[1,1]),o(Bi(n,a),()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`),null!=i&&o(d(s),()=>`Error in fused depthwiseConv2d: pad must be an integer when using dimRoundingMode ${i} but got pad ${s}.`);const y=Ri(m.shape,f.shape,n,a,s,i,!0);let b,x;null!=l&&(b=Ks(l,"bias","fused conv2d"),[b]=Rs(b,p),So(y.outShape,b.shape)),null!=c&&(x=Ks(c,"prelu weights","fused depthwiseConv2d"));const w=(e,t)=>{o(zi(a),()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${a}'`);const[r,l,c,h]=t,p=Ic(e,c,u),d=Ac(l.shape,p,r,n,s,a,i),f=$c(l,p,r.shape,n,s,a,i);if(null!=h){return[d,f,Cc(b,p)]}return[d,f]},k={x:m,filter:f,bias:b,preluActivationWeights:x},v={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i,activation:u,leakyreluAlpha:h};if(null==l){return il((e,t,n)=>{let s=Ps.runKernel("FusedDepthwiseConv2D",k,v);return n([t,e,s]),g&&(s=Wi(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}})(m,f)}return il((e,t,n,s)=>{let r=Ps.runKernel("FusedDepthwiseConv2D",k,v);return s([t,e,r,n]),g&&(r=Wi(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}})(m,f,b)}});const Fc=Js({fusedMatMul_:function({a:e,b:t,transposeA:n=!1,transposeB:s=!1,bias:r,activation:a="linear",preluActivationWeights:i,leakyreluAlpha:l}){if(!1===Tc(Ps.state.gradientDepth,a)){let o=na(e,t,n,s);return null!=r&&(o=hi(o,r)),Sc(o,a,i,l)}let u=Ks(e,"a","fused matMul"),c=Ks(t,"b","fused matMul");[u,c]=Rs(u,c);const d=n?u.shape[u.rank-2]:u.shape[u.rank-1],f=s?c.shape[c.rank-1]:c.shape[c.rank-2],m=n?u.shape[u.rank-1]:u.shape[u.rank-2],g=s?c.shape[c.rank-2]:c.shape[c.rank-1],y=u.shape.slice(0,-2),b=c.shape.slice(0,-2),x=h(y),w=h(b);o(u.rank>=2&&c.rank>=2&&u.rank===c.rank,()=>`Error in fused matMul: inputs must have the same rank of at least 2, got ranks ${u.rank} and ${c.rank}.`),o(p(y,b),()=>`Error in fused matMul: outer dimensions (${y}) and (${b}) of Tensors with shapes ${u.shape} and `+c.shape+" must match."),o(d===f,()=>`Error in fused matMul: inner shapes (${d}) and (${f}) of Tensors with shapes ${u.shape} and ${c.shape} and transposeA=${n} and transposeB=${s} must match.`);const k=u.shape.slice(0,-2).concat([m,g]),v=Wi(u,n?[x,d,m]:[x,m,d]),N=Wi(c,s?[w,g,f]:[w,f,g]);let I,C;null!=r&&(I=Ks(r,"bias","fused matMul"),[I]=Rs(I,u),So(k,I.shape)),null!=i&&(C=Ks(i,"prelu weights","fused matMul"));const S=(e,t)=>{const[i,o,l,u]=t,c=Ic(Wi(e,l.shape),l,a);let h,p;if(n||s?!n&&s?(h=na(c,o,!1,!1),p=na(c,i,!0,!1)):n&&!s?(h=na(o,c,!1,!0),p=na(i,c,!1,!1)):(h=na(o,c,!0,!0),p=na(c,i,!0,!0)):(h=na(c,o,!1,!0),p=na(i,c,!0,!1)),null!=r){return[h,p,Cc(u,c)]}return[h,p]},T={a:v,b:N,bias:I,preluActivationWeights:C},E={transposeA:n,transposeB:s,activation:a,leakyreluAlpha:l};if(null==r){return il((e,t,n)=>{const s=Ps.runKernel("_FusedMatMul",T,E);return n([e,t,s]),{value:Wi(s,k),gradFunc:S}})(v,N)}return il((e,t,n,s)=>{const r=Ps.runKernel("_FusedMatMul",T,E);return s([e,t,r,n]),{value:Wi(r,k),gradFunc:S}})(v,N,I)}});var Dc=Object.freeze({__proto__:null,conv2d:Ec,depthwiseConv2d:Rc,matMul:Fc});const _c=Js({hammingWindow_:function(e){return kc(e,.54,.46)}});const Oc=Js({hannWindow_:function(e){return kc(e,.5,.5)}});const Mc=Js({frame_:function(e,t,n,s=!1,r=0){let a=0;const i=[];for(;a+t<=e.size;)i.push(ji(e,a,t)),a+=n;if(s)for(;a<e.size;){const s=a+t-e.size,o=Gi([ji(e,a,t-s),Bo([s],r)]);i.push(o),a+=n}return 0===i.length?tc([],[0,t]):Wi(Gi(i),[i.length,t])}});const Lc=Js({stft_:function(e,t,n,s,r=Oc){null==s&&(s=wc(t));const a=Mc(e,t,n),i=fi(a,r(t)),o=[];for(let e=0;e<a.shape[0];e++)o.push(ju(ji(i,[e,0],[1,t]),s));return Gi(o)}});const zc=Js({cropAndResize_:function(e,t,n,s,r="bilinear",a=0){const i=Ks(e,"image","cropAndResize"),l=Ks(t,"boxes","cropAndResize","float32"),u=Ks(n,"boxInd","cropAndResize","int32"),c=l.shape[0];o(4===i.rank,()=>`Error in cropAndResize: image must be rank 4,but got rank ${i.rank}.`),o(2===l.rank&&4===l.shape[1],()=>`Error in cropAndResize: boxes must be have size [${c},4] but had shape ${l.shape}.`),o(1===u.rank&&u.shape[0]===c,()=>`Error in cropAndResize: boxInd must be have size [${c}] but had shape ${l.shape}.`),o(2===s.length,()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${s.length}.`),o(s[0]>=1&&s[1]>=1,()=>"cropSize must be atleast [1,1], but was "+s),o("bilinear"===r||"nearest"===r,()=>"method must be bilinear or nearest, but was "+r);const h={image:i,boxes:l,boxInd:u},p={method:r,extrapolationValue:a,cropSize:s};return Ps.runKernel("CropAndResize",h,p)}});const Bc=Js({flipLeftRight_:function(e){const t=Ks(e,"image","flipLeftRight","float32");o(4===t.rank,()=>`Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`);const n={image:t};return Ps.runKernel("FlipLeftRight",n,{})}});const Pc=Js({rotateWithOffset_:function(e,t,n=0,s=.5){const r=Ks(e,"image","rotateWithOffset","float32");o(4===r.rank,()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${r.rank}.`);const a={image:r},i={radians:t,fillValue:n,center:s};return Ps.runKernel("RotateWithOffset",a,i)}});function Wc(e,t,n,s,r,a){null==s&&(s=.5),null==r&&(r=Number.NEGATIVE_INFINITY),null==a&&(a=0);const i=e.shape[0];return n=Math.min(n,i),o(0<=s&&s<=1,()=>`iouThreshold must be in [0, 1], but was '${s}'`),o(2===e.rank,()=>`boxes must be a 2D tensor, but was of rank '${e.rank}'`),o(4===e.shape[1],()=>"boxes must have 4 columns, but 2nd dimension was "+e.shape[1]),o(1===t.rank,()=>"scores must be a 1D tensor"),o(t.shape[0]===i,()=>`scores has incompatible shape with boxes. Expected ${i}, but was `+t.shape[0]),o(0<=a&&a<=1,()=>`softNmsSigma must be in [0, 1], but was '${a}'`),{maxOutputSize:n,iouThreshold:s,scoreThreshold:r,softNmsSigma:a}}const Vc=Js({nonMaxSuppression_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY){const a=Ks(e,"boxes","nonMaxSuppression"),i=Ks(t,"scores","nonMaxSuppression"),o=Wc(a,i,n,s,r),l={maxOutputSize:n=o.maxOutputSize,iouThreshold:s=o.iouThreshold,scoreThreshold:r=o.scoreThreshold};return Ps.runKernel("NonMaxSuppressionV3",{boxes:a,scores:i},l)}});function Uc(e,t,n){const s=function(e,t,n){return function(e,t,n){let s=0,r=e.length,a=0,i=!1;for(;s<r;){a=s+(r-s>>>1);const o=n(t,e[a]);o>0?s=a+1:(r=a,i=!o)}return i?s:-s-1}(e,t,n||Gc)}(e,t,n),r=s<0?-(s+1):s;e.splice(r,0,t)}function Gc(e,t){return e>t?1:e<t?-1:0}function Hc(e,t,n,s,r){return Kc(e,t,n,s,r,0)}function jc(e,t,n,s,r,a){return Kc(e,t,n,s,r,0,!1,a,!0)}function qc(e,t,n,s,r,a){return Kc(e,t,n,s,r,a,!0)}function Kc(e,t,n,s,r,a,i=!1,o=!1,l=!1){const u=[];for(let e=0;e<t.length;e++)t[e]>r&&u.push({score:t[e],boxIndex:e,suppressBeginIndex:0});u.sort(Jc);const c=a>0?-.5/a:0,h=[],p=[];for(;h.length<n&&u.length>0;){const t=u.pop(),{score:n,boxIndex:a,suppressBeginIndex:i}=t;if(n<r)break;let o=!1;for(let n=h.length-1;n>=i;--n){const i=Xc(e,a,h[n]);if(i>=s){o=!0;break}if(t.score=t.score*Yc(s,c,i),t.score<=r)break}t.suppressBeginIndex=h.length,o||(t.score===n?(h.push(a),p.push(t.score)):t.score>r&&Uc(u,t,Jc))}const d=h.length,f=n-d;o&&f>0&&(h.push(...new Array(f).fill(0)),p.push(...new Array(f).fill(0)));const m={selectedIndices:h};return i&&(m.selectedScores=p),l&&(m.validOutputs=d),m}function Xc(e,t,n){const s=e.subarray(4*t,4*t+4),r=e.subarray(4*n,4*n+4),a=Math.min(s[0],s[2]),i=Math.min(s[1],s[3]),o=Math.max(s[0],s[2]),l=Math.max(s[1],s[3]),u=Math.min(r[0],r[2]),c=Math.min(r[1],r[3]),h=Math.max(r[0],r[2]),p=Math.max(r[1],r[3]),d=(o-a)*(l-i),f=(h-u)*(p-c);if(d<=0||f<=0)return 0;const m=Math.max(a,u),g=Math.max(i,c),y=Math.min(o,h),b=Math.min(l,p),x=Math.max(y-m,0)*Math.max(b-g,0);return x/(d+f-x)}function Yc(e,t,n){const s=Math.exp(t*n*n);return n<=e?s:0}function Jc(e,t){return e.score-t.score||e.score===t.score&&t.boxIndex-e.boxIndex}const Zc=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY){const a=Ks(e,"boxes","nonMaxSuppressionAsync"),i=Ks(t,"scores","nonMaxSuppressionAsync"),o=Wc(a,i,n,s,r);n=o.maxOutputSize,s=o.iouThreshold,r=o.scoreThreshold;const l=await Promise.all([a.data(),i.data()]),u=l[0],c=l[1],{selectedIndices:h}=Hc(u,c,n,s,r);return a!==e&&a.dispose(),i!==t&&i.dispose(),ec(h,"int32")};const Qc=Js({nonMaxSuppressionWithScore_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=0){const i=Ks(e,"boxes","nonMaxSuppression"),o=Ks(t,"scores","nonMaxSuppression"),l=Wc(i,o,n,s,r,a),u={boxes:i,scores:o},c={maxOutputSize:n=l.maxOutputSize,iouThreshold:s=l.iouThreshold,scoreThreshold:r=l.scoreThreshold,softNmsSigma:a=l.softNmsSigma},h=Ps.runKernel("NonMaxSuppressionV5",u,c);return{selectedIndices:h[0],selectedScores:h[1]}}});const eh=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=0){const i=Ks(e,"boxes","nonMaxSuppressionAsync"),o=Ks(t,"scores","nonMaxSuppressionAsync"),l=Wc(i,o,n,s,r,a);n=l.maxOutputSize,s=l.iouThreshold,r=l.scoreThreshold,a=l.softNmsSigma;const u=await Promise.all([i.data(),o.data()]),c=u[0],h=u[1],{selectedIndices:p,selectedScores:d}=qc(c,h,n,s,r,a);return i!==e&&i.dispose(),o!==t&&o.dispose(),{selectedIndices:ec(p,"int32"),selectedScores:ec(d)}};const th=Js({nonMaxSuppressionPadded_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=!1){const i=Ks(e,"boxes","nonMaxSuppression"),o=Ks(t,"scores","nonMaxSuppression"),l=Wc(i,o,n,s,r,null),u={boxes:i,scores:o},c={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:a},h=Ps.runKernel("NonMaxSuppressionV4",u,c);return{selectedIndices:h[0],validOutputs:h[1]}}});const nh=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=!1){const i=Ks(e,"boxes","nonMaxSuppressionAsync"),o=Ks(t,"scores","nonMaxSuppressionAsync"),l=Wc(i,o,n,s,r,null),u=l.maxOutputSize,c=l.iouThreshold,h=l.scoreThreshold,[p,d]=await Promise.all([i.data(),o.data()]),{selectedIndices:f,validOutputs:m}=jc(p,d,u,c,h,a);return i!==e&&i.dispose(),o!==t&&o.dispose(),{selectedIndices:ec(f,"int32"),validOutputs:Au(m,"int32")}};const sh=Js({resizeBilinear_:function(e,t,n=!1,s=!1){const r=Ks(e,"images","resizeBilinear");o(3===r.rank||4===r.rank,()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${r.rank}.`),o(2===t.length,()=>"Error in resizeBilinear: new shape must 2D, but got shape "+t+"."),o(!1===s||!1===n,()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false.");let a=r,i=!1;3===r.rank&&(i=!0,a=Wi(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const[]=t,l={images:a},u={alignCorners:n,halfPixelCenters:s,size:t},c=Ps.runKernel("ResizeBilinear",l,u);return i?Wi(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const rh=Js({resizeNearestNeighbor_:function(e,t,n=!1,s=!1){const r=Ks(e,"images","resizeNearestNeighbor");o(3===r.rank||4===r.rank,()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${r.rank}.`),o(2===t.length,()=>"Error in resizeNearestNeighbor: new shape must 2D, but got shape "+t+"."),o("float32"===r.dtype||"int32"===r.dtype,()=>"`images` must have `int32` or `float32` as dtype"),o(!1===s||!1===n,()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false.");let a=r,i=!1;3===r.rank&&(i=!0,a=Wi(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const[]=t,l={images:a},u={alignCorners:n,halfPixelCenters:s,size:t},c=Ps.runKernel("ResizeNearestNeighbor",l,u);return i?Wi(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const ah=Js({bandPart_:function(e,t,n){o(t%1==0,()=>`bandPart(): numLower must be an integer, got ${t}.`),o(n%1==0,()=>`bandPart(): numUpper must be an integer, got ${n}.`);const s=Ks(e,"a","bandPart");o(s.rank>=2,()=>`bandPart(): Rank must be at least 2, got ${s.rank}.`);const r=s.shape,[a,i]=s.shape.slice(-2);if(!(t<=a))throw new Error(`bandPart(): numLower (${t}) must not be greater than the number of rows (${a}).`);if(!(n<=i))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${i}).`);t<0&&(t=a),n<0&&(n=i);const l=Wi(bu(0,a,1,"int32"),[-1,1]),u=bu(0,i,1,"int32"),c=pl(l,u),h=Il(Yo(c,Au(+t,"int32")),Uo(c,Au(-n,"int32"))),p=Vl([a,i],s.dtype);return Wi(Yu(uc(Wi(s,[-1,a,i])).map(e=>Eo(h,e,p))),r)}});const ih=Js({gramSchmidt_:function(e){let t;if(Array.isArray(e)){t=!1,o(null!=e&&e.length>0,()=>"Gram-Schmidt process: input must not be null, undefined, or empty");const n=e[0].shape[0];for(let t=1;t<e.length;++t)o(e[t].shape[0]===n,()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[t].shape[0]} vs. ${n})`)}else t=!0,e=Hu(e,e.shape[0],0).map(e=>Xu(e,[0]));o(e.length<=e[0].shape[0],()=>`Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`);const n=[],s=e;for(let t=0;t<e.length;++t)n.push(Ps.tidy(()=>{let e=s[t];if(t>0)for(let s=0;s<t;++s){const t=fi(dl(fi(n[s],e)),n[s]);e=pl(e,t)}return di(e,fc(e,"euclidean"))}));return t?Yu(n,0):n}});function oh(e,t=!1){return Ps.tidy(()=>{o(2===e.shape.length,()=>`qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`);const n=e.shape[0],s=e.shape[1];let r=zo(n),a=Br(e);const i=tc([[1]],[1,1]);let l=Br(i);const u=n>=s?s:n;for(let e=0;e<u;++e){const t=a,o=l,u=r;[l,a,r]=Ps.tidy(()=>{const t=ji(a,[e,e],[n-e,1]),o=fc(t),u=ji(a,[e,e],[1,1]),c=Eo(Vo(u,0),tc([[-1]]),tc([[1]])),h=pl(u,fi(c,o)),p=di(t,h);l=1===p.shape[0]?Br(i):Gi([i,ji(p,[1,0],[p.shape[0]-1,p.shape[1]])],0);const d=ll(di(na(c,h),o)),f=ji(a,[e,0],[n-e,s]),m=fi(d,l),g=ra(l);if(0===e)a=pl(f,na(m,na(g,f)));else{const t=pl(f,na(m,na(g,f)));a=Gi([ji(a,[0,0],[e,s]),t],0)}const y=ra(m),b=ji(r,[0,e],[n,r.shape[1]-e]);if(0===e)r=pl(b,na(na(b,l),y));else{const t=pl(b,na(na(b,l),y));r=Gi([ji(r,[0,0],[n,e]),t],1)}return[l,a,r]}),Qa([t,o,u])}return!t&&n>s&&(r=ji(r,[0,0],[n,s]),a=ji(a,[0,0],[s,s])),[r,a]})}const lh=Js({qr_:function(e,t=!1){if(o(e.rank>=2,()=>"qr() requires input tensor to have a rank >= 2, but got rank "+e.rank),2===e.rank)return oh(e,t);{const n=e.shape.slice(0,e.shape.length-2).reduce((e,t)=>e*t),s=uc(Wi(e,[n,e.shape[e.shape.length-2],e.shape[e.shape.length-1]]),0),r=[],a=[];return s.forEach(e=>{const[n,s]=oh(e,t);r.push(n),a.push(s)}),[Wi(Yu(r,0),e.shape),Wi(Yu(a,0),e.shape)]}}});var uh;!function(e){e[e.NONE=0]="NONE",e[e.MEAN=1]="MEAN",e[e.SUM=2]="SUM",e[e.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS"}(uh||(uh={}));const ch=Js({computeWeightedLoss_:function(e,t,n=uh.SUM_BY_NONZERO_WEIGHTS){const s=Ks(e,"losses","computeWeightedLoss");let r=null;null!=t&&(r=Ks(t,"weights","computeWeightedLoss"));const a=null==r?s:fi(s,r);if(n===uh.NONE)return a;if(n===uh.SUM)return dl(a);if(n===uh.MEAN){if(null==r)return Fl(a);{const e=s.size/r.size,t=di(dl(a),dl(r));return e>1?di(t,Au(e)):t}}if(n===uh.SUM_BY_NONZERO_WEIGHTS){if(null==r)return di(dl(a),Au(s.size));{const e=fi(r,Ul(s.shape)),t=zr(dl(Wl(e,Au(0))),"float32");return di(dl(a),t)}}throw Error("Unknown reduction: "+n)}});const hh=Js({absoluteDifference_:function(e,t,n,s=uh.SUM_BY_NONZERO_WEIGHTS){const r=Ks(e,"labels","absoluteDifference"),a=Ks(t,"predictions","absoluteDifference");let i=null;null!=n&&(i=Ks(n,"weights","absoluteDifference")),l(r.shape,a.shape,"Error in absoluteDifference: ");const o=mi(pl(r,a));return ch(o,i,s)}});const ph=Js({cosineDistance_:function(e,t,n,s,r=uh.SUM_BY_NONZERO_WEIGHTS){const a=Ks(e,"labels","cosineDistance"),i=Ks(t,"predictions","cosineDistance");let o=null;null!=s&&(o=Ks(s,"weights","cosineDistance")),l(a.shape,i.shape,"Error in cosineDistance: ");const u=Au(1),c=pl(u,dl(fi(a,i),n,!0));return ch(c,o,r)}});const dh=Js({hingeLoss_:function(e,t,n,s=uh.SUM_BY_NONZERO_WEIGHTS){let r=Ks(e,"labels","hingeLoss");const a=Ks(t,"predictions","hingeLoss");let i=null;null!=n&&(i=Ks(n,"weights","hingeLoss")),l(r.shape,a.shape,"Error in hingeLoss: ");const o=Au(1);r=pl(fi(Au(2),r),o);const u=ku(pl(o,fi(r,a)));return ch(u,i,s)}});const fh=Js({huberLoss_:function(e,t,n,s=1,r=uh.SUM_BY_NONZERO_WEIGHTS){const a=Ks(e,"labels","huberLoss"),i=Ks(t,"predictions","huberLoss");let o=null;null!=n&&(o=Ks(n,"weights","huberLoss")),l(a.shape,i.shape,"Error in huberLoss: ");const u=Au(s),c=mi(pl(i,a)),h=_l(c,u),p=pl(c,h),d=hi(fi(Au(.5),Ll(h)),fi(u,p));return ch(d,o,r)}});const mh=Js({logLoss_:function(e,t,n,s=1e-7,r=uh.SUM_BY_NONZERO_WEIGHTS){const a=Ks(e,"labels","logLoss"),i=Ks(t,"predictions","logLoss");let o=null;null!=n&&(o=Ks(n,"weights","logLoss")),l(a.shape,i.shape,"Error in logLoss: ");const u=Au(1),c=Au(s),h=ll(fi(a,Qo(hi(i,c)))),p=fi(pl(u,a),Qo(hi(pl(u,i),c))),d=pl(h,p);return ch(d,o,r)}});const gh=Js({meanSquaredError_:function(e,t,n,s=uh.SUM_BY_NONZERO_WEIGHTS){const r=Ks(e,"labels","meanSquaredError"),a=Ks(t,"predictions","meanSquaredError");let i=null;null!=n&&(i=Ks(n,"weights","meanSquaredError")),l(r.shape,a.shape,"Error in meanSquaredError: ");const o=Ku(r,a);return ch(o,i,s)}});const yh=Js({sigmoidCrossEntropy_:function(e,t,n,s=0,r=uh.SUM_BY_NONZERO_WEIGHTS){let a=Ks(e,"multiClassLabels","sigmoidCrossEntropy");const i=Ks(t,"logits","sigmoidCrossEntropy");let o=null;if(null!=n&&(o=Ks(n,"weights","sigmoidCrossEntropy")),l(a.shape,i.shape,"Error in sigmoidCrossEntropy: "),s>0){const e=Au(s),t=Au(1),n=Au(.5);a=hi(fi(a,pl(t,e)),fi(n,e))}const u=function(e,t){const n=Ks(e,"labels","sigmoidCrossEntropyWithLogits"),s=Ks(t,"logits","sigmoidCrossEntropyWithLogits");l(n.shape,s.shape,"Error in sigmoidCrossEntropyWithLogits: ");const r=ku(s),a=fi(s,n),i=el(_o(ll(mi(s))));return hi(pl(r,a),i)}(a,i);return ch(u,o,r)}});const bh=Js({softmaxCrossEntropy_:function(e,t,n,s=0,r=uh.SUM_BY_NONZERO_WEIGHTS){let a=Ks(e,"onehotLabels","softmaxCrossEntropy");const i=Ks(t,"logits","softmaxCrossEntropy");let o=null;if(null!=n&&(o=Ks(n,"weights","softmaxCrossEntropy")),l(a.shape,i.shape,"Error in softmaxCrossEntropy: "),s>0){const e=Au(s),t=Au(1),n=Au(a.shape[1]);a=hi(fi(a,pl(t,e)),di(e,n))}const u=function(e,t,n=-1){if(-1===n&&(n=t.rank-1),n!==t.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was `+n);return il((e,t,s)=>{const r=Nl(t,[n],!0),a=pl(zr(t,"float32"),r);s([e,a]);const i=ll(fi(a,e));return{value:dl(i,[n]),gradFunc:(e,t)=>{const[s,r]=t,a=bl(e.shape,[n]);return[fi(Wi(e,a),pl(zr(s,"float32"),_o(r))),fi(Wi(e,a),pl(_o(r),zr(s,"float32")))]}}})(e,t)}(a,i);return ch(u,o,r)}}),xh={fft:Vu,ifft:Uu,rfft:ju,irfft:Gu},wh={hammingWindow:_c,hannWindow:Oc,frame:Mc,stft:Lc},kh={flipLeftRight:Bc,resizeNearestNeighbor:rh,resizeBilinear:sh,rotateWithOffset:Pc,cropAndResize:zc,nonMaxSuppression:Vc,nonMaxSuppressionAsync:Zc,nonMaxSuppressionWithScore:Qc,nonMaxSuppressionWithScoreAsync:eh,nonMaxSuppressionPadded:th,nonMaxSuppressionPaddedAsync:nh},vh={bandPart:ah,gramSchmidt:ih,qr:lh},Nh={absoluteDifference:hh,computeWeightedLoss:ch,cosineDistance:ph,hingeLoss:dh,huberLoss:fh,logLoss:mh,meanSquaredError:gh,sigmoidCrossEntropy:yh,softmaxCrossEntropy:bh};class Ih extends _a{minimize(e,t=!1,n){const{value:s,grads:r}=this.computeGradients(e,n);if(null!=n){const e=n.map(e=>({name:e.name,tensor:r[e.name]}));this.applyGradients(e)}else this.applyGradients(r);return Qa(r),t?s:(s.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(e,t){return al(e,t)}dispose(){null!=this.iterations_&&Qa(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:Au(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for this optimizer class "+this.getClassName())}async extractIterations(e){return this.iterations_=(await e[0].tensor.data())[0],e.slice(1)}}Object.defineProperty(Ih,Symbol.hasInstance,{value:e=>null!=e.minimize&&null!=e.computeGradients&&null!=e.applyGradients});class Ch extends Ih{constructor(e,t,n=null){super(),this.learningRate=e,this.rho=t,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=Ps.backend.epsilon())}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const s=Ps.registeredVariables[t];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:t+"/accum_grad",variable:Za(()=>$o(s).variable(!1))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:t+"/accum_var",variable:Za(()=>$o(s).variable(!1))});const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const a=this.accumulatedGrads[n].variable,i=this.accumulatedUpdates[n].variable;Za(()=>{const e=hi(fi(a,this.rho),fi(Ll(r),1-this.rho)),t=fi(di(qu(hi(i,this.epsilon)),qu(hi(a,this.epsilon))),r),n=hi(fi(i,this.rho),fi(Ll(t),1-this.rho));a.assign(e),i.assign(n);const o=hi(fi(t,-this.learningRate),s);s.assign(o)})}),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(Qa(this.accumulatedGrads.map(e=>e.variable)),Qa(this.accumulatedUpdates.map(e=>e.variable)))}async getWeights(){const e=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(e.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){const t=(e=await this.extractIterations(e)).length/2;this.accumulatedGrads=e.slice(0,t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})),this.accumulatedUpdates=e.slice(t,2*t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.rho,t.epsilon)}}Ch.className="Adadelta",Ma(Ch);class Sh extends Ih{constructor(e,t=.1){super(),this.learningRate=e,this.initialAccumulatorValue=t,this.accumulatedGrads=[]}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const s=Ps.registeredVariables[t];if(null==this.accumulatedGrads[n]){const e=!1;this.accumulatedGrads[n]={originalName:t+"/accumulator",variable:Za(()=>Bo(s.shape,this.initialAccumulatorValue).variable(e))}}const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const a=this.accumulatedGrads[n].variable;Za(()=>{const e=hi(a,Ll(r));a.assign(e);const t=hi(fi(di(r,qu(hi(e,Ps.backend.epsilon()))),-this.learningRate),s);s.assign(t)})}),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&Qa(this.accumulatedGrads.map(e=>e.variable))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){e=await this.extractIterations(e);this.accumulatedGrads=e.map(e=>({originalName:e.name,variable:e.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(e,t){return new e(t.learningRate,t.initialAccumulatorValue)}}Sh.className="Adagrad",Ma(Sh);class Th extends Ih{constructor(e,t,n,s=null){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=s,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],Za(()=>{this.accBeta1=Au(t).variable(),this.accBeta2=Au(n).variable()}),null==s&&(this.epsilon=Ps.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map(e=>e.name):Object.keys(e);Za(()=>{const n=pl(1,this.accBeta1),s=pl(1,this.accBeta2);t.forEach((t,r)=>{const a=Ps.registeredVariables[t];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:t+"/m",variable:Za(()=>$o(a).variable(!1))}),null==this.accumulatedSecondMoment[r]&&(this.accumulatedSecondMoment[r]={originalName:t+"/v",variable:Za(()=>$o(a).variable(!1))});const i=Array.isArray(e)?e[r].tensor:e[t];if(null==i)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedSecondMoment[r].variable,u=hi(fi(o,this.beta1),fi(i,1-this.beta1)),c=hi(fi(l,this.beta2),fi(Ll(i),1-this.beta2)),h=di(u,n),p=di(c,s);o.assign(u),l.assign(c);const d=hi(fi(di(h,hi(qu(p),this.epsilon)),-this.learningRate),a);a.assign(d)}),this.accBeta1.assign(fi(this.accBeta1,this.beta1)),this.accBeta2.assign(fi(this.accBeta2,this.beta2))}),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&Qa(this.accumulatedFirstMoment.map(e=>e.variable)),null!=this.accumulatedSecondMoment&&Qa(this.accumulatedSecondMoment.map(e=>e.variable))}async getWeights(){const e=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(e.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){e=await this.extractIterations(e),Za(()=>{this.accBeta1.assign(Ql(this.beta1,this.iterations_+1)),this.accBeta2.assign(Ql(this.beta2,this.iterations_+1))});const t=e.length/2;this.accumulatedFirstMoment=e.slice(0,t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})),this.accumulatedSecondMoment=e.slice(t,2*t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon)}}Th.className="Adam",Ma(Th);class Eh extends Ih{constructor(e,t,n,s=null,r=0){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=s,this.decay=r,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],Za(()=>{this.iteration=Au(0).variable(),this.accBeta1=Au(t).variable()}),null==s&&(this.epsilon=Ps.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map(e=>e.name):Object.keys(e);Za(()=>{const n=pl(1,this.accBeta1),s=di(-this.learningRate,hi(fi(this.iteration,this.decay),1));t.forEach((t,r)=>{const a=Ps.registeredVariables[t];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:t+"/m",variable:$o(a).variable(!1)}),null==this.accumulatedWeightedInfNorm[r]&&(this.accumulatedWeightedInfNorm[r]={originalName:t+"/v",variable:$o(a).variable(!1)});const i=Array.isArray(e)?e[r].tensor:e[t];if(null==i)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedWeightedInfNorm[r].variable,u=hi(fi(o,this.beta1),fi(i,1-this.beta1)),c=fi(l,this.beta2),h=mi(i),p=Rl(c,h);o.assign(u),l.assign(p);const d=hi(fi(di(s,n),di(u,hi(p,this.epsilon))),a);a.assign(d)}),this.iteration.assign(hi(this.iteration,1)),this.accBeta1.assign(fi(this.accBeta1,this.beta1))}),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&Qa(this.accumulatedFirstMoment.map(e=>e.variable)),null!=this.accumulatedWeightedInfNorm&&Qa(this.accumulatedWeightedInfNorm.map(e=>e.variable))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon,t.decay)}}Eh.className="Adamax",Ma(Eh);class $h extends Ih{constructor(e){super(),this.learningRate=e,this.setLearningRate(e)}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const r=Ps.registeredVariables[t];Za(()=>{const e=hi(fi(this.c,s),r);r.assign(e)})}),this.incrementIterations()}setLearningRate(e){this.learningRate=e,null!=this.c&&this.c.dispose(),this.c=ei(Au(-e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(e){if(0!==(e=await this.extractIterations(e)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(e,t){return new e(t.learningRate)}}$h.className="SGD",Ma($h);class Ah extends $h{constructor(e,t,n=!1){super(e),this.learningRate=e,this.momentum=t,this.useNesterov=n,this.accumulations=[],this.m=Au(this.momentum)}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const s=Ps.registeredVariables[t];if(null==this.accumulations[n]){const e=!1;this.accumulations[n]={originalName:t+"/momentum",variable:Za(()=>$o(s).variable(e))}}const r=this.accumulations[n].variable,a=Array.isArray(e)?e[n].tensor:e[t];null!=a&&Za(()=>{let e;const t=hi(fi(this.m,r),a);e=this.useNesterov?hi(fi(this.c,hi(a,fi(t,this.m))),s):hi(fi(this.c,t),s),r.assign(t),s.assign(e)})}),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&Qa(this.accumulations.map(e=>e.variable))}setMomentum(e){this.momentum=e}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){e=await this.extractIterations(e);this.accumulations=e.map(e=>({originalName:e.name,variable:e.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(e,t){return new e(t.learningRate,t.momentum,t.useNesterov)}}Ah.className="Momentum",Ma(Ah);class Rh extends Ih{constructor(e,t=.9,n=0,s=null,r=!1){if(super(),this.learningRate=e,this.decay=t,this.momentum=n,this.epsilon=s,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=r,null==s&&(this.epsilon=Ps.backend.epsilon()),null==e)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const s=Ps.registeredVariables[t];null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:t+"/rms",variable:Za(()=>$o(s).variable(!1))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:t+"/momentum",variable:Za(()=>$o(s).variable(!1))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:t+"/mg",variable:Za(()=>$o(s).variable(!1))});const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const a=this.accumulatedMeanSquares[n].variable,i=this.accumulatedMoments[n].variable;Za(()=>{const e=hi(fi(a,this.decay),fi(Ll(r),1-this.decay));if(this.centered){const t=this.accumulatedMeanGrads[n].variable,o=hi(fi(t,this.decay),fi(r,1-this.decay)),l=di(fi(r,this.learningRate),qu(pl(e,hi(Ll(o),this.epsilon)))),u=hi(fi(i,this.momentum),l);a.assign(e),t.assign(o),i.assign(u);const c=pl(s,u);s.assign(c)}else{const e=hi(fi(a,this.decay),fi(Ll(r),1-this.decay)),t=hi(fi(i,this.momentum),di(fi(r,this.learningRate),qu(hi(e,this.epsilon))));a.assign(e),i.assign(t);const n=pl(s,t);s.assign(n)}})}),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&Qa(this.accumulatedMeanSquares.map(e=>e.variable)),null!=this.accumulatedMeanGrads&&this.centered&&Qa(this.accumulatedMeanGrads.map(e=>e.variable)),null!=this.accumulatedMoments&&Qa(this.accumulatedMoments.map(e=>e.variable))}async getWeights(){const e=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&e.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(e.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){e=await this.extractIterations(e);const t=this.centered?e.length/3:e.length/2;this.accumulatedMeanSquares=e.slice(0,t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})),this.accumulatedMoments=e.slice(t,2*t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})),this.centered&&(this.accumulatedMeanGrads=e.slice(2*t,3*t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(e,t){return new e(t.learningRate,t.decay,t.momentum,t.epsilon,t.centered)}}Rh.className="RMSProp",Ma(Rh);class Fh{static sgd(e){return new $h(e)}static momentum(e,t,n=!1){return new Ah(e,t,n)}static rmsprop(e,t=.9,n=0,s=null,r=!1){return new Rh(e,t,n,s,r)}static adam(e=.001,t=.9,n=.999,s=null){return new Th(e,t,n,s)}static adadelta(e=.001,t=.95,n=null){return new Ch(e,t,n)}static adamax(e=.002,t=.9,n=.999,s=null,r=0){return new Eh(e,t,n,s,r)}static adagrad(e,t=.1){return new Sh(e,t)}}const Dh={sgd:Fh.sgd,momentum:Fh.momentum,adadelta:Fh.adadelta,adagrad:Fh.adagrad,rmsprop:Fh.rmsprop,adamax:Fh.adamax,adam:Fh.adam},_h="undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate?setImmediate:e=>e();function Oh(){return new Promise(e=>_h(()=>e()))}function Mh(e,t){const n=e[0].length;e.forEach((e,t)=>{o(e.length===n,()=>`Error in concat${n}D: rank of tensors[${t}] must be the same as the rank of the rest (${n})`)}),o(t>=0&&t<n,()=>`Error in concat${n}D: axis must be between 0 and ${n-1}.`);const s=e[0];e.forEach((e,r)=>{for(let a=0;a<n;a++)o(a===t||e[a]===s[a],()=>`Error in concat${n}D: Shape of tensors[${r}] (${e}) does not match the shape of the rest (${s}) along the non-concatenated axis ${r}.`)})}function Lh(e,t){const n=e[0].slice();for(let s=1;s<e.length;s++)n[t]+=e[s][t];return n}function zh(e){return e<=30?e:D(e,Math.floor(Math.sqrt(e)))}function Bh(e,t,n){return[n*("number"==typeof e?e:e[0]),t*("number"==typeof e?e:e[1])]}function Ph(e,t,n,s=!0){let r=[];if(s)r=r.concat(t.slice(0)),r.push(e[0]/n),r=r.concat(e.slice(1));else{r=r.concat(e[0]);const n=t.length;for(let s=0;s<n;++s)r=r.concat([e[s+1]/t[s],t[s]]);r=r.concat(e.slice(n+1))}return r}function Wh(e,t,n=!0){const s=[];if(n){s.push(t);for(let n=t+1;n<e;++n)n<=2*t?(s.push(n),s.push(n-(t+1))):s.push(n)}else{const n=[],r=[];for(let s=1;s<e;++s)s>=2*t+1||s%2==1?r.push(s):n.push(s);s.push(...n),s.push(0),s.push(...r)}return s}function Vh(e,t,n,s=!0){const r=[];s?r.push(e[0]/n):r.push(e[0]*n);for(let n=1;n<e.length;++n)n<=t.length?s?r.push(t[n-1]*e[n]):r.push(e[n]/t[n-1]):r.push(e[n]);return r}function Uh(e,t){const n=[0];for(let s=0;s<t;++s)n.push(e[s][0]);return n}function Gh(e,t,n){const s=e.slice(0,1);for(let r=0;r<n;++r)s.push(e[r+1]-t[r][0]-t[r][1]);return s}const Hh=1.0507009873554805;function jh(...e){G().getBool("IS_TEST")||console.warn(...e)}function qh(e,t){if(e.length!==t.length)throw new Error(`Cannot merge real and imag arrays of different lengths. real:${e.length}, imag: ${t.length}.`);const n=new Float32Array(2*e.length);for(let s=0;s<n.length;s+=2)n[s]=e[s/2],n[s+1]=t[s/2];return n}function Kh(e){const t=new Float32Array(e.length/2),n=new Float32Array(e.length/2);for(let s=0;s<e.length;s+=2)t[s/2]=e[s],n[s/2]=e[s+1];return{real:t,imag:n}}function Xh(e){const t=Math.ceil(e.length/4),n=new Float32Array(t),s=new Float32Array(t);for(let t=0;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],s[Math.floor(t/4)]=e[t+1];return{real:n,imag:s}}function Yh(e){const t=Math.floor(e.length/4),n=new Float32Array(t),s=new Float32Array(t);for(let t=2;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],s[Math.floor(t/4)]=e[t+1];return{real:n,imag:s}}function Jh(e,t){return{real:e[2*t],imag:e[2*t+1]}}function Zh(e,t,n,s){e[2*s]=t,e[2*s+1]=n}function Qh(e,t){const n=new Float32Array(e/2),s=new Float32Array(e/2);for(let r=0;r<Math.ceil(e/2);r++){const a=(t?2:-2)*Math.PI*(r/e);n[r]=Math.cos(a),s[r]=Math.sin(a)}return{real:n,imag:s}}function ep(e,t,n){const s=(n?2:-2)*Math.PI*(e/t);return{real:Math.cos(s),imag:Math.sin(s)}}function tp(e,t,n=0){let s=[];if("number"==typeof t)o(e.shape[n]%t==0,()=>"Number of splits must evenly divide the axis."),s=new Array(t).fill(e.shape[n]/t);else{o(t.reduce((e,t)=>(-1===t&&(e+=1),e),0)<=1,()=>"There should be only one negative value in split array.");const r=t.indexOf(-1);if(-1!==r){const s=t.reduce((e,t)=>t>0?e+t:e);t[r]=e.shape[n]-s}o(e.shape[n]===t.reduce((e,t)=>e+t),()=>"The sum of sizes must match the size of the axis dimension."),s=t}return s}function np(e,t){let n,s=!1;for(e<=30?(n=e,s=!0):n=D(e,Math.floor(Math.sqrt(e)));!s;)n>t||n===e?s=!0:n=D(e,n+1);return n}function sp(e,t,n){const s=[],r=e.length;for(let a=0;a<r;a++)a!==t?s.push(e[a]):s.push(n);return s}function rp(e,t,n,s){const r=t.shape.length,a=e.shape.length;if(0!==s&&(s<-r||s>r))throw new Error(`Expect batchDims in the range of [-${r}, ${r}], but got ${s}`);if(s<0&&(s+=r),s>a)throw new Error(`batchDims (${s}) must be less than rank(x) (\n    ${a}).`);if(n<s)throw new Error(`batchDims (${s}) must be less than or equal to axis (${n}).`);for(let n=0;n<s;++n)if(e.shape[n]!==t.shape[n])throw new Error(`x.shape[${n}]: ${e.shape[n]} should be equal to indices.shape[${n}]: ${t.shape[n]}.`);const i=e.shape[n],o=[];let l=1,u=1,c=1;for(let t=0;t<s;++t)o.push(e.shape[t]),l*=e.shape[t];for(let t=s;t<n;t++)o.push(e.shape[t]),u*=e.shape[t];for(let e=s;e<r;e++)o.push(t.shape[e]);for(let t=n+1;t<a;t++)o.push(e.shape[t]),c*=e.shape[t];return{batchSize:l,sliceSize:c,outerSize:u,dimSize:i,outputShape:o}}var ap=Object.freeze({__proto__:null,segOpComputeOptimalWindowSize:np,computeOutShape:sp,collectGatherOpShapeInfo:rp});function ip(e){try{return e.map(e=>os(e))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8, error: "+e)}}function op(e){return e.map(e=>is(e))}var lp=Object.freeze({__proto__:null,slice_util:Da,segment_util:ap,fromUint8ToStringArray:ip,fromStringArrayToUint8:op,upcastType:$s,axesAreInnerMostDims:ml,combineLocations:gl,computeOutAndReduceShapes:yl,expandShapeToKeepDim:bl,assertAxesAreInnerMostDims:xl,getAxesPermutation:wl,getUndoAxesPermutation:kl,getInnerMostAxes:vl,getBroadcastDims:Io,getReductionAxes:Co,assertAndGetBroadcastShape:So,assertParamsConsistent:Mh,computeOutShape:Lh,computeDilation2DInfo:Ei,computePool2DInfo:$i,computePool3DInfo:Ai,computeConv2DInfo:Ri,computeConv3DInfo:Fi,computeDefaultPad:Di,tupleValuesAreOne:zi,eitherStridesOrDilationsAreOne:Bi,convertConv2DDataFormat:Pi,getFusedDyActivation:Ic,getFusedBiasGradient:Cc,applyActivation:Sc,shouldFuse:Tc,PARALLELIZE_THRESHOLD:30,computeOptimalWindowSize:zh,getImageCenter:Bh,getReshaped:Ph,getPermuted:Wh,getReshapedPermuted:Vh,getSliceBeginCoords:Uh,getSliceSize:Gh,prepareAndValidate:ha,validateUpdateShape:da,validateInput:fa,calculateShapes:ma,SELU_SCALEALPHA:1.7580993408473768,SELU_SCALE:Hh,ERF_P:.3275911,ERF_A1:.254829592,ERF_A2:-.284496736,ERF_A3:1.421413741,ERF_A4:-1.453152027,ERF_A5:1.061405429,warn:jh,log:function(...e){G().getBool("IS_TEST")||console.log(...e)},mergeRealAndImagArrays:qh,splitRealAndImagArrays:Kh,complexWithEvenIndex:Xh,complexWithOddIndex:Yh,getComplexWithIndex:Jh,assignToTypedArray:Zh,exponents:Qh,exponent:ep,prepareSplitSize:tp}),up=Object.freeze({__proto__:null,nonMaxSuppressionV3Impl:Hc,nonMaxSuppressionV4Impl:jc,nonMaxSuppressionV5Impl:qc,whereImpl:hc});const cp={kernelName:"Abs",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,Ju(zr(n,"float32"),-1))}}},hp={kernelName:"Acos",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Ll(zr(n,"float32")),s=qu(pl(Au(1),t));return ll(di(e,s))}}}},pp={kernelName:"Acosh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=qu(pl(Ll(zr(n,"float32")),1));return di(e,t)}}}},dp={kernelName:Z,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{let t=e;const s=Co(n.shape,r);return s.length>0&&(t=dl(t,s)),Wi(t,n.shape)},b:()=>{let t=e;const n=Co(s.shape,r);return n.length>0&&(t=dl(t,n)),Wi(t,s.shape)}}}},fp={kernelName:"AddN",saveAllInputs:!0,gradFunc:(e,t)=>{const n={};return t.forEach((t,s)=>{n[s]=()=>e.clone()}),n}},mp={kernelName:"ArgMax",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>$o(n)}}},gp={kernelName:"ArgMin",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>$o(n)}}},yp={kernelName:"Asin",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>di(e,qu(pl(Au(1),Ll(zr(n,"float32")))))}}},bp={kernelName:"Asinh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=qu(hi(Au(1),Ll(zr(n,"float32"))));return di(e,t)}}}},xp={kernelName:"Atan2",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{const t=hi(Ll(n),Ll(s));let a=fi(e,di(s,t));const i=Co(n.shape,r);return i.length>0&&(a=dl(a,i)),Wi(a,n.shape)},b:()=>{const t=hi(Ll(n),Ll(s));let a=ll(fi(e,di(n,t)));const i=Co(s.shape,r);return i.length>0&&(a=dl(a,i)),Wi(a,s.shape)}}}},wp={kernelName:"Atan",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>di(e,hi(Ll(zr(n,"float32")),1))}}},kp={kernelName:"Atanh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>di(e,pl(Au(1),Ll(zr(n,"float32"))))}}};const vp=Js({avgPool3dGrad_:function(e,t,n,s,r,a){const i=Ks(e,"dy","avgPool3dGrad"),l=Ks(t,"input","avgPool3dGrad");let u=i,c=l,h=!1;4===l.rank&&(h=!0,u=Wi(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]]),c=Wi(l,[1,l.shape[0],l.shape[1],l.shape[2],l.shape[3]])),o(5===u.rank,()=>"Error in avgPool3dGrad: dy must be rank 5 but got rank "+u.rank+"."),o(5===c.rank,()=>"Error in avgPool3dGrad: input must be rank 5 but got rank "+c.rank+"."),null!=a&&o(d(r),()=>`Error in avgPool3dGrad: pad must be an integer when using, dimRoundingMode ${a} but got pad ${r}.`);const p={dy:u,input:c},f={filterSize:n,strides:s,pad:r,dimRoundingMode:a},m=Ps.runKernel("AvgPool3DGrad",p,f);return h?Wi(m,[m.shape[1],m.shape[2],m.shape[3],m.shape[4]]):m}}),Np={kernelName:"AvgPool3D",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{filterSize:r,strides:a,pad:i,dimRoundingMode:o}=n;return{x:()=>vp(e,s,r,a,i,o)}}};const Ip=Js({avgPoolGrad_:function(e,t,n,s,r){const a=Ks(e,"dy","avgPoolGrad"),i=Ks(t,"input","avgPoolGrad");o(i.rank===a.rank,()=>`Rank of input (${i.rank}) does not match rank of dy (${a.rank})`);let l=i,u=a,c=!1;3===i.rank&&(c=!0,l=Wi(i,[1,i.shape[0],i.shape[1],i.shape[2]]),u=Wi(a,[1,a.shape[0],a.shape[1],a.shape[2]])),o(4===u.rank,()=>"Error in avgPoolGrad: dy must be rank 4 but got rank "+u.rank+"."),o(4===l.rank,()=>"Error in avgPoolGrad: input must be rank 4 but got rank "+l.rank+".");const h={dy:u,input:l},p={filterSize:n,strides:s,pad:r},d=Ps.runKernel("AvgPoolGrad",h,p);return c?Wi(d,[d.shape[1],d.shape[2],d.shape[3]]):d}}),Cp={kernelName:"AvgPool",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{filterSize:r,strides:a,pad:i}=n;return{x:()=>Ip(e,s,r,a,i)}}},Sp={kernelName:"BatchMatMul",inputsToSave:["a","b"],gradFunc:(e,t,n)=>{const[s,r]=t,{transposeA:a,transposeB:i}=n;return a||i?!a&&i?{a:()=>na(e,r,!1,!1),b:()=>na(e,s,!0,!1)}:a&&!i?{a:()=>na(r,e,!1,!0),b:()=>na(s,e,!1,!1)}:{a:()=>na(r,e,!0,!0),b:()=>na(e,s,!0,!0)}:{a:()=>na(e,r,!1,!0),b:()=>na(s,e,!0,!1)}}},Tp={kernelName:"BatchToSpaceND",gradFunc:(e,t,n)=>{const{blockShape:s,crops:r}=n;return{x:()=>Jl(e,s,r)}}},Ep={kernelName:"BroadcastTo",gradFunc:(e,t,n)=>{const s=n,r=s.inputShape,a=s.shape,i=Array.from(a);for(let e=r.length-1;e>=0;e--)if(r[e]===a[e])i[e]=1;else if(1!==r[e])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${a}].`);const o=[];for(let e=0;e<i.length;e++)i[e]>1&&o.push(e);return{x:()=>dl(e,o,!0)}}},$p={kernelName:"Cast",gradFunc:e=>({x:()=>e.clone()})},Ap={kernelName:"Ceil",gradFunc:e=>({x:()=>$o(e)})},Rp={kernelName:"ClipByValue",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{clipValueMin:r,clipValueMax:a}=n;return{x:()=>Eo(Il(Uo(s,r),Yo(s,a)),e,$o(e))}}},Fp={kernelName:"ComplexAbs",inputsToSave:["x"],gradFunc:cp.gradFunc},Dp={kernelName:"Concat",saveAllInputs:!0,gradFunc:(e,t,n)=>{const s=t.map(e=>e.shape),{axis:r}=n,a=b(r,t[0].shape)[0],i=s.map(e=>e[a]);return Hu(e,i,a).map(e=>()=>e)}},_p={kernelName:"Conv2D",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,{dilations:a,strides:i,pad:l,dataFormat:u}=n;return o(zi(a),()=>`Error in gradient of conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`),{x:()=>co(s.shape,e,r,i,l,u),filter:()=>Nc(s,e,r.shape,i,l,u)}}},Op={kernelName:"Conv2DBackpropInput",inputsToSave:["dy","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,{strides:a,pad:i,dataFormat:o,dimRoundingMode:l}=n;return{dy:()=>lo(e,r,a,i,o,1,l),filter:()=>Nc(e,s,r.shape,a,i,o,l)}}};const Mp=Js({conv3DBackpropFilter_:function(e,t,n,s,r){let a=e;4===e.rank&&(a=Wi(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]]));let i=t;4===i.rank&&(i=Wi(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]])),o(5===a.rank,()=>"Error in conv3dDerFilter: input must be rank 5, but got shape "+a.shape+"."),o(5===i.rank,()=>"Error in conv3dDerFilter: dy must be rank 5, but got shape "+i.shape+"."),o(5===n.length,()=>"Error in conv3dDerFilter: filterShape must be length 5, but got "+n+"."),o(a.shape[4]===n[3],()=>`Error in conv3dDerFilter: depth of input ${a.shape[4]}) must match input depth in filter (${n[3]}.`),o(i.shape[4]===n[4],()=>`Error in conv3dDerFilter: depth of dy (${i.shape[4]}) must match output depth for filter (${n[4]}).`);const l={x:a,dy:i},u={strides:s,pad:r,filterShape:n};return Ps.runKernel("Conv3DBackpropFilterV2",l,u)}}),Lp={kernelName:"Conv3D",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const{dilations:s,strides:r,pad:a}=n;o(zi(s),()=>`Error in gradient of conv3D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${s}'`);const[i,l]=t;return{x:()=>fo(i.shape,e,l,r,a),filter:()=>Mp(i,e,l.shape,r,a)}}},zp={kernelName:$e,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(ll(Ou(zr(n,"float32"))),e)}}},Bp={kernelName:"Cosh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(Mu(zr(n,"float32")),e)}}},Pp={kernelName:"Cumsum",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{axis:r,exclusive:a,reverse:i}=n;return{x:()=>{const t=wl([r],s.rank);let n=bo(e,r,a,!i);return null!=t&&(n=ra(n,t)),n}}}},Wp={kernelName:"DepthwiseConv2dNative",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const{dilations:s,strides:r,pad:a,dimRoundingMode:i}=n,l=null==s?[1,1]:s;o(zi(l),()=>`Error in gradient of depthwiseConv2dNative: dilation rates greater than 1 are not yet supported. Got dilations '${l}'`);const[u,c]=t;return o(4===u.rank,()=>`Error in gradient of depthwiseConv2dNative: input must be rank 4, but got rank ${u.rank}.`),o(4===c.rank,()=>`Error in gradient of depthwiseConv2dNative: filter must be rank 4, but got rank ${c.rank}.`),o(u.shape[3]===c.shape[2],()=>`Error in gradient of depthwiseConv2d: number of input channels (${u.shape[3]}) must match the inChannels dimension in filter ${c.shape[2]}.`),o(Bi(r,l),()=>`Error in gradient of depthwiseConv2d: Either strides or dilations must be  1. Got strides ${r} and dilations '${l}'.`),null!=i&&o(d(a),()=>`Error in depthwiseConv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`),{x:()=>Ac(u.shape,e,c,r,a,s,i),filter:()=>$c(u,e,c.shape,r,a,s,i)}}},Vp={kernelName:"Dilation2D",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,a={x:s,filter:r,dy:e},i={x:s,filter:r,dy:e};return{x:()=>Ps.runKernel("Dilation2DBackpropInput",a,n),filter:()=>Ps.runKernel("Dilation2DBackpropFilter",i,n)}}},Up={kernelName:Ue,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t,s={dy:e,y:n};return{x:()=>Ps.runKernel("EluGrad",s)}}},Gp={kernelName:He,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t,s=fi(_o(ll(Ll(n))),2/Math.sqrt(Math.PI));return{x:()=>fi(e,s)}}},Hp={kernelName:qe,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,n)}}},jp={kernelName:"ExpandDims",inputsToSave:["input"],gradFunc:(e,t)=>{const[n]=t;return{input:()=>Wi(e,n.shape)}}},qp={kernelName:"Expm1",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,_o(n))}}},Kp={kernelName:"Floor",gradFunc:e=>({x:()=>$o(e)})},Xp={kernelName:"FloorDiv",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{const t=di(e,zr(s,"float32")),a=Co(n.shape,r);return a.length>0?Wi(dl(t,a),n.shape):t},b:()=>{let t=fi(e,zr(n,"float32"));const a=Co(s.shape,r);a.length>0&&(t=Wi(dl(t,a),s.shape));const i=Ll(s);return ll(di(t,zr(i,"float32")))}}}},Yp={kernelName:"FusedBatchNorm",inputsToSave:["x","mean","variance","scale"],gradFunc:(e,t,n)=>{const{varianceEpsilon:s}=n,[r,a,i,o]=t,l=null==o?Au(1):o,u=Co(a.shape,r.shape),c=[];if(1===a.rank){for(let e=0;e<r.shape.length-1;++e)c.push(r.shape[e]);c.push(1)}const h=pl(r,a),p=fi(e,l),d=$u(hi(i,Au(s))),f=fi(fi(fi(d,d),d),Au(-.5));return{x:()=>1===a.rank?Wi(fi(fi(e,Lo(Wi(d,[1,1,1,a.shape[0]]),c)),l),r.shape):Wi(fi(fi(e,d),l),r.shape),mean:()=>{let e=fi(fi(d,Au(-1)),p);return 1===a.rank&&(e=dl(e,u)),Wi(e,a.shape)},variance:()=>{let e=fi(fi(f,h),p);return 1===a.rank&&(e=dl(e,u)),Wi(e,a.shape)},scale:()=>{const t=fi(h,d);let n=fi(e,t);return 1===a.rank&&(n=dl(n,u)),Wi(n,a.shape)},offset:()=>{let t=e;return 1===a.rank&&(t=dl(t,u)),Wi(t,a.shape)}}}},Jp={kernelName:"GatherV2",inputsToSave:["x","indices"],gradFunc:(e,t,n)=>{const[s,r]=t,{axis:a}=n,i=b(a,s.shape)[0];return{x:()=>{const t=s.shape,n=r.size,o=t.slice(0,i),l=o.length,u=t.slice(a,t.length).slice(1),c=u.length,h=Zp(0,l),p=Zp(l+1,l+1+c),d=Qp([o,[n],u]),f=Wi(e,d),m=Wi(r,[n]),g=Qp([[l],h,p]),y=ra(f,g);let b=lc(y,m,s.shape[i]);const x=kl(g);return b=ra(b,x),b},indices:()=>r}}};function Zp(e,t){const n=[];for(let s=e;s<t;++s)n.push(s);return n}function Qp(e){const t=[];for(let n=0;n<e.length;++n)for(let s=0;s<e[n].length;++s)t.push(e[n][s]);return t}const ed={kernelName:"GreaterEqual",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>$o(n),b:()=>$o(s)}}},td={kernelName:"Identity",gradFunc:e=>({x:()=>zr(e,"float32")})},nd={kernelName:"IsFinite",gradFunc:e=>({x:()=>$o(e)})},sd={kernelName:"IsInf",gradFunc:e=>({x:()=>$o(e)})},rd={kernelName:"IsNan",gradFunc:e=>({x:()=>$o(e)})},ad={kernelName:"LeakyRelu",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{alpha:r}=n,a=Vo(s,0);return{x:()=>Eo(a,e,fi(e,r))}}},id={kernelName:"Log1p",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>di(e,hi(n,1))}}},od={kernelName:gt,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>di(e,zr(n,"float32"))}}},ld={kernelName:"LogSoftmax",inputsToSave:[],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s]=t,{axis:r}=n;return{logits:()=>{const t=_o(s);return pl(e,fi(dl(e,r,!0),t))}}}};const ud=Js({localResponseNormalizationBackprop_:function(e,t,n,s=5,r=1,a=1,i=.5){const o={x:e,y:t,dy:n},l={depthRadius:s,bias:r,alpha:a,beta:i};return Ps.runKernel("LRNGrad",o,l)}}),cd={kernelName:"LRN",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{depthRadius:a,bias:i,alpha:o,beta:l}=n;return{x:()=>ud(s,r,e,a,i,o,l)}}};function hd(e,t,n,s){return t.rank<n.rank&&(t=Wi(t,bl(t.shape,s))),e.rank<n.rank&&(e=Wi(e,bl(e.shape,s))),{x:()=>fi(e,zr(To(n,t),e.dtype))}}const pd={kernelName:"Max",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const s=n,{reductionIndices:r}=s,a=t[0],i=hd(e,t[1],a,b(r,a.shape));return{x:()=>i.x()}}},dd={kernelName:"Maximum",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>fi(e,zr(Uo(n,s),"float32")),b:()=>fi(e,zr(Xo(n,s),"float32"))}}};const fd=Js({maxPool3dGrad_:function(e,t,n,s,r,a,i){const l=Ks(e,"dy","maxPool3dGrad"),u=Ks(t,"input","maxPool3dGrad"),c=Ks(n,"output","maxPool3dGrad");let h=l,p=u,f=c,m=!1;4===u.rank&&(m=!0,h=Wi(l,[1,l.shape[0],l.shape[1],l.shape[2],l.shape[3]]),p=Wi(u,[1,u.shape[0],u.shape[1],u.shape[2],u.shape[3]]),f=Wi(c,[1,c.shape[0],c.shape[1],c.shape[2],c.shape[3]])),o(5===h.rank,()=>"Error in maxPool3dGrad: dy must be rank 5 but got rank "+h.rank+"."),o(5===p.rank,()=>"Error in maxPool3dGrad: input must be rank 5 but got rank "+p.rank+"."),o(5===f.rank,()=>"Error in maxPool3dGrad: output must be rank 5 but got rank "+f.rank+"."),null!=i&&o(d(a),()=>`Error in maxPool3dGrad: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`);const g={dy:h,input:p,output:f},y={filterSize:s,strides:r,pad:a,dimRoundingMode:i},b=Ps.runKernel("MaxPool3DGrad",g,y);return m?Wi(b,[b.shape[1],b.shape[2],b.shape[3],b.shape[4]]):b}}),md={kernelName:"MaxPool3D",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l}=n;return{x:()=>fd(e,s,r,a,i,o,l)}}};const gd=Js({maxPoolGrad_:function(e,t,n,s,r,a,i){const l=Ks(e,"dy","maxPoolGrad"),u=Ks(t,"input","maxPoolGrad"),c=Ks(n,"output","maxPoolGrad");o(u.rank===l.rank,()=>`Rank of input (${u.rank}) does not match rank of dy (${l.rank})`),o(4===l.rank,()=>"Error in maxPoolGrad: dy must be rank 4 but got rank "+l.rank+"."),o(4===u.rank,()=>"Error in maxPoolGrad: input must be rank 4 but got rank "+u.rank+"."),null!=i&&o(d(a),()=>`Error in maxPoolGrad: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`);const h={dy:l,input:u,output:c},p={filterSize:s,strides:r,pad:a,dimRoundingMode:i};return Ps.runKernel("MaxPoolGrad",h,p)}}),yd={kernelName:"PadV2",inputsToSave:["x"],gradFunc:(e,t,n)=>{const s=t[0],{paddings:r}=n,a=r.map(e=>e[0]);return{x:()=>ji(e,a,s.shape)}}},bd={kernelName:"SpaceToBatchND",gradFunc:(e,t,n)=>{const{blockShape:s,paddings:r}=n;return{x:()=>Xi(e,s,r)}}},xd={kernelName:"SplitV",gradFunc:(e,t,n)=>{const{axis:s}=n;return{x:()=>Gi(e,s)}}};const wd=[cp,hp,pp,dp,fp,mp,gp,yp,bp,xp,wp,kp,Np,Cp,Sp,Tp,Ep,$p,Ap,Rp,Fp,Dp,Op,_p,Lp,zp,Bp,Pp,Wp,Vp,{kernelName:"RealDiv",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{const t=di(e,zr(s,"float32")),a=Co(n.shape,r);return a.length>0?Wi(dl(t,a),n.shape):t},b:()=>{let t=fi(e,zr(n,"float32"));const a=Co(s.shape,r);a.length>0&&(t=Wi(dl(t,a),s.shape));const i=Ll(s);return ll(di(t,zr(i,"float32")))}}}},Up,Gp,Hp,jp,qp,Xp,Kp,Yp,Jp,ed,td,nd,sd,rd,ad,id,od,ld,cd,pd,pd,dd,md,{kernelName:"MaxPool",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{filterSize:a,strides:i,pad:o}=n;return{x:()=>gd(e,s,r,a,i,o)}}},{kernelName:"Mean",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{axis:r}=n,a=b(r,s.shape),i=h(yl(s.shape,a)[1]);return{x:()=>{const t=s.shape.slice();a.forEach(e=>{t[e]=1});const n=Wi(e,t);return di(fi(n,Ul(s.shape,"float32")),i)}}}},{kernelName:"Min",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const s=n,{axis:r}=s,[a,i]=t,o=hd(e,i,a,b(r,a.shape));return{x:()=>o.x()}}},{kernelName:"Minimum",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>fi(e,zr(Yo(n,s),"float32")),b:()=>fi(e,zr(Vo(n,s),"float32"))}}},{kernelName:"MirrorPad",inputsToSave:["x"],gradFunc:(e,t,n)=>{const s=t[0],{paddings:r}=n,a=r.map(e=>e[0]);return{x:()=>ji(e,a,s.shape)}}},{kernelName:Ot,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{const t=Co(n.shape,r);return t.length>0?Wi(dl(e,t),n.shape):e},b:()=>{const t=fi(e,ll(Po(di(n,s)))),a=Co(s.shape,r);return a.length>0?Wi(dl(t,a),s.shape):t}}}},{kernelName:"Multiply",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{const t=fi(e,zr(s,"float32")),a=Co(n.shape,r);return a.length>0?Wi(dl(t,a),n.shape):t},b:()=>{const t=fi(e,zr(n,"float32")),a=Co(s.shape,r);return a.length>0?Wi(dl(t,a),s.shape):t}}}},{kernelName:"Neg",gradFunc:e=>({x:()=>ll(e)})},{kernelName:"OneHot",inputsToSave:["indices"],gradFunc:(e,t)=>{const n=t[0];return{indices:()=>Vl(n.shape,"float32")}}},{kernelName:"OnesLike",gradFunc:e=>({x:()=>$o(e)})},{kernelName:"Pack",saveAllInputs:!0,gradFunc:(e,t,n)=>{const{axis:s}=n;return uc(e,s).map(e=>()=>e)}},yd,yd,{kernelName:Kt,inputsToSave:["a","b"],outputsToSave:[!0],gradFunc:(e,t)=>{const[n,s,r]=t,a=n,i=s,o=So(a.shape,i.shape);return{a:()=>{const t=zr(i,"float32");let n=fi(e,fi(t,Ql(a,pl(t,Au(1)))));const s=Co(a.shape,o);return s.length>0&&(n=dl(n,s)),Wi(n,a.shape)},b:()=>{const t=Vo(a,0),n=Eo(t,Qo(a),$o(a));let s=fi(e,fi(r,n));const l=Co(i.shape,o);return l.length>0&&(s=dl(s,l)),Wi(s,i.shape)}}}},{kernelName:"Prelu",inputsToSave:["x","alpha"],gradFunc:(e,t)=>{const[n,s]=t,r=Vo(n,0);return{x:()=>Eo(r,e,fi(e,s)),alpha:()=>{let t=Eo(r,$o(e),fi(e,n));const a=Co(s.shape,e.shape);return a.length>0&&(t=dl(t,a)),Wi(t,s.shape)}}}},{kernelName:"Reciprocal",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>di(e,ll(Ll(n)))}}},{kernelName:"Relu6",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t,s=fi(Yo(n,6),Ju(n));return{x:()=>fi(e,zr(s,"float32"))}}},{kernelName:"Relu",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,zr(Ju(n),"float32"))}}},{kernelName:"Reshape",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Wi(e,n.shape)}}},{kernelName:"ResizeBilinear",inputsToSave:["images"],gradFunc:(e,t,n)=>{const[s]=t,r={dy:e,images:s};return{images:()=>Ps.runKernel("ResizeBilinearGrad",r,n)}}},{kernelName:"ResizeNearestNeighbor",inputsToSave:["images"],gradFunc:(e,t,n)=>{const[s]=t,r={dy:e,images:s};return{images:()=>Ps.runKernel("ResizeNearestNeighborGrad",r,n)}}},{kernelName:"Reverse",gradFunc:(e,t,n)=>{const{dims:s}=n,r=b(s,e.shape);return{x:()=>Nu(e,r)}}},{kernelName:"Round",gradFunc:e=>({x:()=>$o(e)})},{kernelName:"Rsqrt",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ll(di(e,fi(Ql(n,1.5),2)))}}},{kernelName:"Select",inputsToSave:["condition"],gradFunc:(e,t)=>{const[n]=t;return{condition:()=>zr($o(n),"float32"),t:()=>fi(e,zr(n,e.dtype)),e:()=>fi(e,zr(Cl(n),e.dtype))}}},{kernelName:"Selu",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Vo(n,Au(0)),s=Au(1.7580993408473768),r=Au(Hh),a=fi(e,r),i=fi(fi(e,s),_o(zr(n,"float32")));return Eo(t,a,i)}}}},{kernelName:"Sigmoid",outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,fi(n,pl(Au(1),n)))}}},{kernelName:"Sign",gradFunc:e=>({x:()=>$o(e)})},{kernelName:mn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(go(zr(n,"float32")),e)}}},{kernelName:"Sinh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(yo(zr(n,"float32")),e)}}},{kernelName:"Slice",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{begin:r,size:a}=n,i=s.shape,[o,l]=Ra(s,r,a),u=[];for(let t=0;t<e.rank;t++)u.push([o[t],i[t]-o[t]-l[t]]);return{x:()=>jl(e,u)}}},{kernelName:"Softmax",outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s]=t,{dim:r}=n,a=fi(e,s);return{logits:()=>pl(a,fi(dl(a,[r],!0),s))}}},{kernelName:"Softplus",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,Hi(n))}}},bd,bd,xd,xd,{kernelName:"Sqrt",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>di(e,fi(qu(zr(n,"float32")),2))}}},{kernelName:"SquaredDifference",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=Au(2);return{a:()=>fi(e,fi(r,pl(n,s))),b:()=>fi(e,fi(r,pl(s,n)))}}},{kernelName:"Square",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,fi(zr(n,"float32"),2))}}},{kernelName:"Step",gradFunc:e=>({x:()=>$o(e)})},{kernelName:Tn,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{let t=e;const s=Co(n.shape,r);return s.length>0&&(t=dl(t,s)),Wi(t,n.shape)},b:()=>{let t=e;const n=Co(s.shape,r);return n.length>0&&(t=dl(t,n)),Wi(ll(t),s.shape)}}}},{kernelName:"Sum",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,r=s.shape.slice(),{axis:a}=n;b(a,s.shape).forEach(e=>{r[e]=1});const i=Wi(e,r),o=fi(i,Ul(s.shape,"float32"));return{x:()=>o}}},{kernelName:An,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>di(e,Ll(go(n)))}}},{kernelName:"Tanh",outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(pl(Au(1),Ll(n)),e)}}},{kernelName:"Tile",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{reps:r}=n;return{x:()=>{let t=$o(s);if(1===s.rank)for(let n=0;n<r[0];++n)t=hi(t,ji(e,[n*s.shape[0]],[s.shape[0]]));else if(2===s.rank)for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)t=hi(t,ji(e,[n*s.shape[0],a*s.shape[1]],[s.shape[0],s.shape[1]]));else if(3===s.rank)for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)for(let i=0;i<r[2];++i)t=hi(t,ji(e,[n*s.shape[0],a*s.shape[1],i*s.shape[2]],[s.shape[0],s.shape[1],s.shape[2]]));else{if(4!==s.rank)throw new Error("Gradient for tile operation is not implemented for rank-"+s.rank+" tensors yet.");for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)for(let i=0;i<r[2];++i)for(let o=0;o<r[3];++o)t=hi(t,ji(e,[n*s.shape[0],a*s.shape[1],i*s.shape[2],o*s.shape[3]],[s.shape[0],s.shape[1],s.shape[2],s.shape[3]]))}return t}}}},{kernelName:"Transpose",gradFunc:(e,t,n)=>{const s=n,{perm:r}=s,a=kl(r);return{x:()=>ra(e,a)}}},{kernelName:"Unpack",gradFunc:(e,t,n)=>{const s=n,{axis:r}=s;return{value:()=>Yu(e,r)}}},{kernelName:"UnsortedSegmentSum",inputsToSave:["segmentIds"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>function(e,t){const n=Rl(t,$o(t)),s=Wo(e,n);let r=Uo(t,Au(0,"int32"));const a=s.rank-r.rank;for(let e=0;e<a;++e)r=Oo(r,e+1);r=Il(r,Ul(s.shape,"bool"));const i=$o(s);return Eo(r,s,i)}(e,n)}}},{kernelName:"ZerosLike",gradFunc:e=>({x:()=>$o(e)})}];for(const e of wd)Jn(e);let kd;function vd(){return null==kd&&(kd=ui().epsilon()),kd}ks().prototype.abs=function(){return this.throwIfDisposed(),mi(this)},ks().prototype.acos=function(){return this.throwIfDisposed(),gi(this)},ks().prototype.acosh=function(){return this.throwIfDisposed(),yi(this)},ks().prototype.add=function(e){return this.throwIfDisposed(),hi(this,e)},ks().prototype.all=function(e,t){return this.throwIfDisposed(),xi(this,e,t)},ks().prototype.any=function(e,t){return this.throwIfDisposed(),wi(this,e,t)},ks().prototype.argMax=function(e){return this.throwIfDisposed(),ki(this,e)},ks().prototype.argMin=function(e){return this.throwIfDisposed(),vi(this,e)},ks().prototype.asScalar=function(){return this.throwIfDisposed(),o(1===this.size,()=>"The array must have only 1 element."),Wi(this,[])},ks().prototype.asType=function(e){return this.throwIfDisposed(),zr(this,e)},ks().prototype.as1D=function(){return this.throwIfDisposed(),Wi(this,[this.size])},ks().prototype.as2D=function(e,t){return this.throwIfDisposed(),Wi(this,[e,t])},ks().prototype.as3D=function(e,t,n){return this.throwIfDisposed(),Wi(this,[e,t,n])},ks().prototype.as4D=function(e,t,n,s){return this.throwIfDisposed(),Wi(this,[e,t,n,s])},ks().prototype.as5D=function(e,t,n,s,r){return this.throwIfDisposed(),Wi(this,[e,t,n,s,r])},ks().prototype.asin=function(){return this.throwIfDisposed(),Ni(this)},ks().prototype.asinh=function(){return this.throwIfDisposed(),Ii(this)},ks().prototype.atan=function(){return this.throwIfDisposed(),Ci(this)},ks().prototype.atan2=function(e){return this.throwIfDisposed(),Si(this,e)},ks().prototype.atanh=function(){return this.throwIfDisposed(),Ti(this)},ks().prototype.avgPool=function(e,t,n,s){return this.throwIfDisposed(),Vi(this,e,t,n,s)},ks().prototype.batchToSpaceND=function(e,t){return this.throwIfDisposed(),Xi(this,e,t)},ks().prototype.batchNorm=function(e,t,n,s,r){return this.throwIfDisposed(),Yi(this,e,t,n,s,r)},ks().prototype.broadcastTo=function(e){return this.throwIfDisposed(),to(this,e)},ks().prototype.cast=function(e){return this.throwIfDisposed(),zr(this,e)},ks().prototype.ceil=function(){return this.throwIfDisposed(),no(this)},ks().prototype.clipByValue=function(e,t){return this.throwIfDisposed(),so(this,e,t)},ks().prototype.concat=function(e,t){return this.throwIfDisposed(),e instanceof ws&&(e=[e]),Gi([this,...e],t)},ks().prototype.conv1d=function(e,t,n,s,r,a){return this.throwIfDisposed(),uo(this,e,t,n,s,r,a)},ks().prototype.conv2dTranspose=function(e,t,n,s,r){return this.throwIfDisposed(),ho(this,e,t,n,s,r)},ks().prototype.conv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),lo(this,e,t,n,s,r,a)},ks().prototype.cos=function(){return this.throwIfDisposed(),go(this)},ks().prototype.cosh=function(){return this.throwIfDisposed(),yo(this)},ks().prototype.cumsum=function(e,t,n){return this.throwIfDisposed(),bo(this,e,t,n)},ks().prototype.depthToSpace=function(e,t){return this.throwIfDisposed(),wo(this,e,t)},ks().prototype.depthwiseConv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),ko(this,e,t,n,s,r,a)},ks().prototype.dilation2d=function(e,t,n,s,r){return this.throwIfDisposed(),No(this,e,t,n,s,r)},ks().prototype.divNoNan=function(e){return this.throwIfDisposed(),Ao(this,e)},ks().prototype.div=function(e){return this.throwIfDisposed(),di(this,e)},ks().prototype.dot=function(e){return this.throwIfDisposed(),Ro(this,e)},ks().prototype.elu=function(){return this.throwIfDisposed(),Fo(this)},ks().prototype.equal=function(e){return this.throwIfDisposed(),To(this,e)},ks().prototype.erf=function(){return this.throwIfDisposed(),Do(this)},ks().prototype.exp=function(){return this.throwIfDisposed(),_o(this)},ks().prototype.expandDims=function(e){return this.throwIfDisposed(),Oo(this,e)},ks().prototype.expm1=function(){return this.throwIfDisposed(),Mo(this)},ks().prototype.fft=function(){return this.throwIfDisposed(),Vu(this)},ks().prototype.flatten=function(){return this.throwIfDisposed(),Wi(this,[this.size])},ks().prototype.floor=function(){return this.throwIfDisposed(),Po(this)},ks().prototype.floorDiv=function(e){return this.throwIfDisposed(),pi(this,e)},ks().prototype.gather=function(e,t){return this.throwIfDisposed(),Wo(this,e,t)},ks().prototype.greaterEqual=function(e){return this.throwIfDisposed(),Uo(this,e)},ks().prototype.greater=function(e){return this.throwIfDisposed(),Vo(this,e)},ks().prototype.ifft=function(){return this.throwIfDisposed(),Uu(this)},ks().prototype.irfft=function(){return this.throwIfDisposed(),Gu(this)},ks().prototype.isFinite=function(){return this.throwIfDisposed(),Ho(this)},ks().prototype.isInf=function(){return this.throwIfDisposed(),jo(this)},ks().prototype.isNaN=function(){return this.throwIfDisposed(),qo(this)},ks().prototype.leakyRelu=function(e){return this.throwIfDisposed(),Ko(this,e)},ks().prototype.lessEqual=function(e){return this.throwIfDisposed(),Yo(this,e)},ks().prototype.less=function(e){return this.throwIfDisposed(),Xo(this,e)},ks().prototype.localResponseNormalization=function(e,t,n,s){return this.throwIfDisposed(),Zo(this,e,t,n,s)},ks().prototype.logSigmoid=function(){return this.throwIfDisposed(),cl(this)},ks().prototype.logSoftmax=function(e){return this.throwIfDisposed(),fl(this,e)},ks().prototype.logSumExp=function(e,t){return this.throwIfDisposed(),Nl(this,e,t)},ks().prototype.log=function(){return this.throwIfDisposed(),Qo(this)},ks().prototype.log1p=function(){return this.throwIfDisposed(),el(this)},ks().prototype.logicalAnd=function(e){return this.throwIfDisposed(),Il(this,e)},ks().prototype.logicalNot=function(){return this.throwIfDisposed(),Cl(this)},ks().prototype.logicalOr=function(e){return this.throwIfDisposed(),Sl(this,e)},ks().prototype.logicalXor=function(e){return this.throwIfDisposed(),Tl(this,e)},ks().prototype.matMul=function(e,t,n){return this.throwIfDisposed(),na(this,e,t,n)},ks().prototype.maxPool=function(e,t,n,s){return this.throwIfDisposed(),El(this,e,t,n,s)},ks().prototype.max=function(e,t){return this.throwIfDisposed(),hl(this,e,t)},ks().prototype.maximum=function(e){return this.throwIfDisposed(),Rl(this,e)},ks().prototype.mean=function(e,t){return this.throwIfDisposed(),Fl(this,e,t)},ks().prototype.min=function(e,t){return this.throwIfDisposed(),Dl(this,e,t)},ks().prototype.minimum=function(e){return this.throwIfDisposed(),_l(this,e)},ks().prototype.mirrorPad=function(e,t){return this.throwIfDisposed(),Ol(this,e,t)},ks().prototype.mod=function(e){return this.throwIfDisposed(),Ml(this,e)},ks().prototype.mul=function(e){return this.throwIfDisposed(),fi(this,e)},ks().prototype.neg=function(){return this.throwIfDisposed(),ll(this)},ks().prototype.norm=function(e,t,n){return this.throwIfDisposed(),fc(this,e,t,n)},ks().prototype.notEqual=function(e){return this.throwIfDisposed(),Wl(this,e)},ks().prototype.oneHot=function(e,t=1,n=0){return this.throwIfDisposed(),sa(this,e,t,n)},ks().prototype.onesLike=function(){return this.throwIfDisposed(),Gl(this)},ks().prototype.pad=function(e,t){return this.throwIfDisposed(),jl(this,e,t)},ks().prototype.pool=function(e,t,n,s,r){return this.throwIfDisposed(),Zl(this,e,t,n,s,r)},ks().prototype.pow=function(e){return this.throwIfDisposed(),Ql(this,e)},ks().prototype.prelu=function(e){return this.throwIfDisposed(),eu(this,e)},ks().prototype.prod=function(e,t){return this.throwIfDisposed(),tu(this,e,t)},ks().prototype.reciprocal=function(){return this.throwIfDisposed(),wu(this)},ks().prototype.relu=function(){return this.throwIfDisposed(),ku(this)},ks().prototype.relu6=function(){return this.throwIfDisposed(),vu(this)},ks().prototype.reshapeAs=function(e){return this.throwIfDisposed(),Wi(this,e.shape)},ks().prototype.reshape=function(e){return this.throwIfDisposed(),Wi(this,e)},ks().prototype.resizeBilinear=function(e,t,n){return this.throwIfDisposed(),sh(this,e,t,n)},ks().prototype.resizeNearestNeighbor=function(e,t,n){return this.throwIfDisposed(),rh(this,e,t,n)},ks().prototype.reverse=function(e){return this.throwIfDisposed(),Nu(this,e)},ks().prototype.rfft=function(){return this.throwIfDisposed(),ju(this)},ks().prototype.round=function(){return this.throwIfDisposed(),Eu(this)},ks().prototype.rsqrt=function(){return this.throwIfDisposed(),$u(this)},ks().prototype.selu=function(){return this.throwIfDisposed(),Ru(this)},ks().prototype.separableConv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),Fu(this,e,t,n,s,r,a)},ks().prototype.sigmoid=function(){return this.throwIfDisposed(),Hi(this)},ks().prototype.sign=function(){return this.throwIfDisposed(),_u(this)},ks().prototype.sin=function(){return this.throwIfDisposed(),Ou(this)},ks().prototype.sinh=function(){return this.throwIfDisposed(),Mu(this)},ks().prototype.slice=function(e,t){return this.throwIfDisposed(),ji(this,e,t)},ks().prototype.softmax=function(e){return this.throwIfDisposed(),Wu(this,e)},ks().prototype.softplus=function(){return this.throwIfDisposed(),ul(this)},ks().prototype.spaceToBatchND=function(e,t){return this.throwIfDisposed(),Jl(this,e,t)},ks().prototype.split=function(e,t){return this.throwIfDisposed(),Hu(this,e,t)},ks().prototype.sqrt=function(){return this.throwIfDisposed(),qu(this)},ks().prototype.square=function(){return this.throwIfDisposed(),Ll(this)},ks().prototype.squaredDifference=function(e){return this.throwIfDisposed(),Ku(this,e)},ks().prototype.squeeze=function(e){return this.throwIfDisposed(),Xu(this,e)},ks().prototype.stack=function(e,t){this.throwIfDisposed();const n=e instanceof ws?[this,e]:[this,...e];return Yu(n,t)},ks().prototype.step=function(e){return this.throwIfDisposed(),Ju(this,e)},ks().prototype.stridedSlice=function(e,t,n,s,r,a,i,o){return this.throwIfDisposed(),Zu(this,e,t,n,s,r,a,i,o)},ks().prototype.sub=function(e){return this.throwIfDisposed(),pl(this,e)},ks().prototype.sum=function(e,t){return this.throwIfDisposed(),dl(this,e,t)},ks().prototype.tan=function(){return this.throwIfDisposed(),Qu(this)},ks().prototype.tanh=function(){return this.throwIfDisposed(),qi(this)},ks().prototype.tile=function(e){return this.throwIfDisposed(),Lo(this,e)},ks().prototype.toBool=function(){return this.throwIfDisposed(),zr(this,"bool")},ks().prototype.toFloat=function(){return this.throwIfDisposed(),zr(this,"float32")},ks().prototype.toInt=function(){return this.throwIfDisposed(),zr(this,"int32")},ks().prototype.topk=function(e,t){return this.throwIfDisposed(),ac(this,e,t)},ks().prototype.transpose=function(e){return this.throwIfDisposed(),ra(this,e)},ks().prototype.unique=function(e){return this.throwIfDisposed(),oc(this,e)},ks().prototype.unsortedSegmentSum=function(e,t){return this.throwIfDisposed(),lc(this,e,t)},ks().prototype.unstack=function(e){return this.throwIfDisposed(),uc(this,e)},ks().prototype.where=function(e,t){return this.throwIfDisposed(),Eo(e,this,t)},ks().prototype.zerosLike=function(){return this.throwIfDisposed(),$o(this)};class Nd extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Nd.prototype)}}class Id extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Id.prototype)}}class Cd extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Cd.prototype)}}class Sd extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Sd.prototype)}}class Td extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Td.prototype)}}Error;function Ed(e,t){if(Array.isArray(e)){let n=[];for(let s=0;s<t;s++)n=n.concat(e);return n}{const n=new Array(t);return n.fill(e),n}}function $d(e,t){if(!e)throw new Td(t)}function Ad(e,t){let n=0;for(const s of e)s===t&&n++;return n}function Rd(e){return 1===e.length?e[0]:e}function Fd(e){return Array.isArray(e)?e:[e]}function Dd(e){const t=e.replace(/(.)([A-Z][a-z0-9]+)/g,"$1_$2").replace(/([a-z])([A-Z])/g,"$1_$2").toLowerCase();return"_"!==t[0]?t:"private"+t}function _d(e){return e.length<=1||-1===e.indexOf("_")?e:e.replace(/[_]+(\w|$)/g,(e,t)=>t.toUpperCase())}let Od={};function Md(e){if(null==e)return null;const t={};return t.className=e.getClassName(),t.config=e.getConfig(),t}function Ld(e,t={},n={},s="object",r=!1){if("string"==typeof e){const r=e;let a;if(r in n)a=n[r];else if(r in Od)a=Od[r];else if(a=t[r],null==a)throw new Cd(`Unknown ${s}: ${e}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);return a}{const a=e;if(null==a.className||null==a.config)throw new Cd(s+": Improper config format: "+JSON.stringify(a)+".\n'className' and 'config' must set.");const i=a.className;let o,l;if(i in n?[o,l]=n[i]:i in Od?[o,l]=Od.className:i in t&&([o,l]=t[i]),null==o)throw new Cd(`Unknown ${s}: ${i}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);if(null!=l){const e={};for(const t of Object.keys(Od))e[t]=Od[t];for(const t of Object.keys(n))e[t]=n[t];a.config.customObjects=e;const t=Object.assign({},Od);for(const e of Object.keys(n))Od[e]=n[e];!function e(t){if(null!=t&&"object"==typeof t)if(Array.isArray(t))t.forEach(t=>e(t));else{const n=Object.keys(t);for(const s of n){const n=t[s];null!=n&&"object"==typeof n&&(Array.isArray(n)||"ndarray"!==n.type||"number"!=typeof n.value?e(n):t[s]=n.value)}}}(a.config);const s=l(o,a.config,n,r);return Od=Object.assign({},t),s}{const e=Object.assign({},Od);for(const e of Object.keys(n))Od[e]=n[e];const t=new o(a.config);return Od=Object.assign({},e),t}}}function zd(e,t){return-1*function(e,t){return e<t?-1:e>t?1:0}(e,t)}function Bd(e){if(null==e)return e;const t=[];for(const n of e)-1===t.indexOf(n)&&t.push(n);return t}function Pd(e){if(null==e)throw new Cd("Invalid value in obj: "+JSON.stringify(e));for(const t in e)if(e.hasOwnProperty(t))return!1;return!0}function Wd(e,t,n){if(null!=n&&e.indexOf(n)<0)throw new Cd(`${n} is not a valid ${t}.  Valid values are ${e} or null/undefined.`)}function Vd(e,t,n=0,s=1/0){return $d(n>=0),$d(s>=n),Array.isArray(e)&&e.length>=n&&e.length<=s&&e.every(e=>typeof e===t)}function Ud(e,t){Array.isArray(e)?(o(e.length>0,()=>t+" is unexpectedly an empty array."),e.forEach((e,n)=>Ud(e,`element ${n+1} of ${t}`))):o(Number.isInteger(e)&&e>0,()=>`Expected ${t} to be a positive integer, but got `+function e(t){return null===t?"null":Array.isArray(t)?"["+t.map(t=>e(t)).join(",")+"]":"string"==typeof t?`"${t}"`:""+t}(e)+".")}function Gd(e){return"relu"===e?"relu":"linear"===e?"linear":"elu"===e?"elu":null}function Hd(e,t){return Za(()=>qu(dl(fi(e,e),t,!0)))}class jd extends _a{getConfig(){return{}}}class qd extends jd{constructor(e){super(),this.defaultMaxValue=2,this.defaultAxis=0,this.maxValue=null!=e.maxValue?e.maxValue:this.defaultMaxValue,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return Za(()=>{const t=Hd(e,this.axis),n=so(t,0,this.maxValue);return fi(e,di(n,hi(vd(),t)))})}getConfig(){return{maxValue:this.maxValue,axis:this.axis}}}qd.className="MaxNorm",Ma(qd);class Kd extends jd{constructor(e){super(),this.defaultAxis=0,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return Za(()=>di(e,hi(vd(),Hd(e,this.axis))))}getConfig(){return{axis:this.axis}}}Kd.className="UnitNorm",Ma(Kd);class Xd extends jd{apply(e){return ku(e)}}Xd.className="NonNeg",Ma(Xd);class Yd extends jd{constructor(e){super(),this.defaultMinValue=0,this.defaultMaxValue=1,this.defaultRate=1,this.defaultAxis=0,this.minValue=null!=e.minValue?e.minValue:this.defaultMinValue,this.maxValue=null!=e.maxValue?e.maxValue:this.defaultMaxValue,this.rate=null!=e.rate?e.rate:this.defaultRate,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return Za(()=>{const t=Hd(e,this.axis),n=hi(fi(this.rate,so(t,this.minValue,this.maxValue)),fi(1-this.rate,t));return fi(e,di(n,hi(vd(),t)))})}getConfig(){return{minValue:this.minValue,maxValue:this.maxValue,rate:this.rate,axis:this.axis}}}Yd.className="MinMaxNorm",Ma(Yd);const Jd={maxNorm:"MaxNorm",minMaxNorm:"MinMaxNorm",nonNeg:"NonNeg",unitNorm:"UnitNorm"};function Zd(e){return Md(e)}function Qd(e,t={}){return Ld(e,Oa.getMap().classNameMap,t,"constraint")}function ef(e){if(null==e)return null;if("string"==typeof e){return Qd({className:e in Jd?Jd[e]:e,config:{}})}return e instanceof jd?e:Qd(e)}var tf=Object.freeze({__proto__:null,maxNorm:function(e){return new qd(e)},unitNorm:function(e){return new Kd(e)},nonNeg:function(){return new Xd},minMaxNorm:function(e){return new Yd(e)}});const nf=["channelsFirst","channelsLast"],sf=["nearest","bilinear"],rf=["valid","same","causal"],af=["max","avg"],of=["sum","mul","concat","ave"],lf=new Map;function uf(e){Wd(nf,"DataFormat",e)}function cf(e){Wd(rf,"PaddingMode",e)}function hf(e){Wd(af,"PoolMode",e)}const pf=[];function df(e,t){pf.push(e);try{const e=t();return pf.pop(),e}catch(e){throw pf.pop(),e}}function ff(e){if(!yf(e))throw new Error("Not a valid tensor name: '"+e+"'");return(0===pf.length?"":pf.join("/")+"/")+e}function mf(e){if(!yf(e))throw new Error("Not a valid tensor name: '"+e+"'");lf.has(e)||lf.set(e,0);const t=lf.get(e);if(lf.set(e,lf.get(e)+1),t>0){const n=`${e}_${t}`;return lf.set(n,1),n}return e}const gf=new RegExp(/^[A-Za-z0-9][-A-Za-z0-9\._\/]*$/);function yf(e){return!!e.match(gf)}function bf(e,t,n){null==t&&(t=0),null==n&&(n=e.length);let s=1;for(let r=t;r<n;++r)s*=e[r];return s}function xf(e){return ec(e=Array.isArray(e)?new Float32Array(e):e)}function wf(e){return Dl(xf(e)).dataSync()[0]}function kf(e){return hl(xf(e)).dataSync()[0]}function vf(e,t){if(t<e)throw new Cd(`end (${t}) < begin (${e}) is forbidden.`);const n=[];for(let s=e;s<t;++s)n.push(s);return n}function Nf(e,t){return e.asType(t)}function If(e,t=-1){const n=e.shape.slice();return t<0&&(t=n.length+t+1),n.splice(t,0,1),e.reshape(n)}function Cf(e,t,n){return Za(()=>{switch(e.rank){case 1:return Lu(e,t,n);case 2:return zu(e,[t,0],[n,e.shape[1]]);case 3:return Bu(e,[t,0,0],[n,e.shape[1],e.shape[2]]);case 4:return Pu(e,[t,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3]]);case 5:return ji(e,[t,0,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3],e.shape[4]]);case 6:return ji(e,[t,0,0,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3],e.shape[4],e.shape[5]]);default:throw new Cd("sliceAlongFirstAxis() received an unsupported tensor rank: "+e.rank)}})}function Sf(e,t,n){return Za(()=>{switch(e.rank){case 1:return Lu(e,t,n);case 2:return zu(e,[0,t],[e.shape[0],n]);case 3:return Bu(e,[0,0,t],[e.shape[0],e.shape[1],n]);case 4:return Pu(e,[0,0,0,t],[e.shape[0],e.shape[1],e.shape[2],n]);default:throw new Cd("sliceAlongLastAxis() received an unsupported tensor rank: "+e.rank)}})}function Tf(e,t,n,s){return Za(()=>{switch(e.rank){case 1:return Lu(e,t,n);case 2:switch(s){case 1:return Cf(e,t,n);case 2:return Sf(e,t,n);default:throw new Cd("The axis is not within the rank of the tensor "+s)}case 3:switch(s){case 1:return Cf(e,t,n);case 2:return Bu(e,[0,t,0],[e.shape[0],n,e.shape[2]]);case 3:return Sf(e,t,n);default:throw new Cd("The axis is not within the rank of the tensor "+s)}case 4:switch(s){case 1:return Cf(e,t,n);case 2:return Pu(e,[0,t,0,0],[e.shape[0],n,e.shape[2],e.shape[3]]);case 3:return Pu(e,[0,0,t,0],[e.shape[0],e.shape[1],n,e.shape[3]]);case 4:return Sf(e,t,n);default:throw new Cd("The axis is not within the rank of the tensor "+s)}default:throw new Cd("sliceAlongLastAxis() received an unsupported tensor rank: "+e.rank)}})}function Ef(e,t=-1){let n;return t<0&&(n=e[0].rank,t=0!==n?n:0),t===e[0].rank&&(t=-1),Gi(e,t)}function $f(e,t){switch(e.rank){case 1:return ro([e,t]);case 2:return ao([e,t],0);case 3:return io([e,t],0);case 4:return oo([e,t],0);default:throw new Cd("concatAlongFirstAxis() received an unsupported tensor rank: "+e.rank)}}function Af(e,t){if(Array.isArray(t)||(t=[t]),e.rank!==t.length)throw new Cd(`The length of input n (${t.length}) does not match the number of dimensions in input x (${e.rank})`);return Lo(e,t)}function Rf(e,t=0,n=1,s,r){return gu(e,t,n,s,r)}function Ff(e,t,n,s){if(e.rank<2||t.rank<2)throw new Sd(`dot requires both inputs to be rank >= 2 but got x shape = ${e.shape} and y shape = ${t.shape}`);if(t.rank>=3){if(e.shape.slice(-1)[0]!==t.shape.slice(-2)[0])throw new Sd(`If rank y >= 3, then the second last dim of y must equal the last dim of x but got x shape = ${e.shape} and  y shape = `+t.shape)}if(2===e.rank&&2===t.rank){return Fc({a:e,b:t,transposeA:!1,transposeB:!1,bias:s?Of(e.rank,s,"channelsLast"):null,activation:n})}{const r=e.shape.slice(),a=r.pop();e=e.reshape([-1,a]);const i=t.shape.slice(),o=i.pop(),l=i.pop(),u=[...i,o],c=Array.from({length:t.rank},(e,n)=>0===n?t.rank-2:n<=t.rank-2?n-1:n);t=t.transpose(c).reshape([l,-1]);const h=[...r,...u];return Fc({a:e,b:t,transposeA:!1,transposeB:!1,bias:s?Of(e.rank,s,"channelsLast"):null,activation:n}).reshape(h)}}function Df(e,t,n){return Za(()=>(t=Array.isArray(t)?ec(t,"int32"):t.toInt(),Wo(e,t,n)))}function _f(e){return fi(e,e)}function Of(e,t,n){const s=t.shape;if(1!==t.rank&&t.rank!==e)throw new Cd("Unexpected bias dimensions: "+t.rank+"; expected it to be 1 or "+e);if(5===e){if("channelsFirst"===n)return 1===s.length?t.reshape([1,s[0],1,1,1]):t.reshape([1,s[3],s[0],s[1],s[2]]);if("channelsLast"===n)return 1===s.length?t.reshape([1,1,1,1,s[0]]):t.reshape([1].concat(s))}else if(4===e){if("channelsFirst"===n)return 1===s.length?t.reshape([1,s[0],1,1]):t.reshape([1,s[2],s[0],s[1]]);if("channelsLast"===n)return 1===s.length?t.reshape([1,1,1,s[0]]):t.reshape([1].concat(s))}else if(3===e){if("channelsFirst"===n)return 1===s.length?t.reshape([1,s[0],1]):t.reshape([1,s[1],s[0]]);if("channelsLast"===n)return 1===s.length?t.reshape([1,1,s[0]]):t.reshape([1].concat(s))}else if(e<3)return t;throw new Cd("Unsupported input rank by biasAdd: "+t.rank)}function Mf(e,t,n){return Za(()=>(null==n&&(n="channelsLast"),uf(n),e.add(Of(e.rank,t,n))))}function Lf(e,t,n,s){return Za(()=>xc(e,t,n,s))}function zf(e,t,n=!1){return n?e():t()}const Bf=["fanIn","fanOut","fanAvg"],Pf=["normal","uniform","truncatedNormal"];class Wf extends _a{fromConfigUsesCustomObjects(){return!1}getConfig(){return{}}}class Vf extends Wf{apply(e,t){return Vl(e,t)}}Vf.className="Zeros",Ma(Vf);class Uf extends Wf{apply(e,t){return Ul(e,t)}}Uf.className="Ones",Ma(Uf);class Gf extends Wf{constructor(e){if(super(),"object"!=typeof e)throw new Cd("Expected argument of type ConstantConfig but got "+e);if(void 0===e.value)throw new Cd("config must have value set but got "+e);this.value=e.value}apply(e,t){return Za(()=>fi(Au(this.value),Ul(e,t)))}getConfig(){return{value:this.value}}}Gf.className="Constant",Ma(Gf);class Hf extends Wf{constructor(e){super(),this.DEFAULT_MINVAL=-.05,this.DEFAULT_MAXVAL=.05,this.minval=e.minval||this.DEFAULT_MINVAL,this.maxval=e.maxval||this.DEFAULT_MAXVAL,this.seed=e.seed}apply(e,t){return yu(e,this.minval,this.maxval,t)}getConfig(){return{minval:this.minval,maxval:this.maxval,seed:this.seed}}}Hf.className="RandomUniform",Ma(Hf);class jf extends Wf{constructor(e){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=e.mean||this.DEFAULT_MEAN,this.stddev=e.stddev||this.DEFAULT_STDDEV,this.seed=e.seed}apply(e,t){if("float32"!==(t=t||"float32")&&"int32"!==t)throw new Sd(`randomNormal does not support dType ${t}.`);return Rf(e,this.mean,this.stddev,t,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}jf.className="RandomNormal",Ma(jf);class qf extends Wf{constructor(e){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=e.mean||this.DEFAULT_MEAN,this.stddev=e.stddev||this.DEFAULT_STDDEV,this.seed=e.seed}apply(e,t){if("float32"!==(t=t||"float32")&&"int32"!==t)throw new Sd(`truncatedNormal does not support dType ${t}.`);return ic(e,this.mean,this.stddev,t,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}qf.className="TruncatedNormal",Ma(qf);class Kf extends Wf{constructor(e){super(),this.gain=null!=e.gain?e.gain:1}apply(e,t){return Za(()=>{if(2!==e.length||e[0]!==e[1])throw new Cd("Identity matrix initializer can only be used for 2D square matrices.");return fi(this.gain,zo(e[0]))})}getConfig(){return{gain:this.gain}}}Kf.className="Identity",Ma(Kf);class Xf extends Wf{constructor(e){if(super(),e.scale<0)throw new Cd("scale must be a positive float. Got: "+e.scale);var t;this.scale=null==e.scale?1:e.scale,this.mode=null==e.mode?"fanIn":e.mode,t=this.mode,Wd(Bf,"FanMode",t),this.distribution=null==e.distribution?"normal":e.distribution,function(e){Wd(Pf,"Distribution",e)}(this.distribution),this.seed=e.seed}apply(e,t){const n=function(e,t="channelsLast"){let n,s;if(uf(t),2===e.length)n=e[0],s=e[1];else if(-1!==[3,4,5].indexOf(e.length)){if("channelsFirst"===t){const t=bf(e,2);n=e[1]*t,s=e[0]*t}else if("channelsLast"===t){const t=bf(e,0,e.length-2);n=e[e.length-2]*t,s=e[e.length-1]*t}}else{const t=bf(e);n=Math.sqrt(t),s=Math.sqrt(t)}return[n,s]}(e),s=n[0],r=n[1];let a=this.scale;if("fanIn"===this.mode?a/=Math.max(1,s):"fanOut"===this.mode?a/=Math.max(1,r):a/=Math.max(1,(s+r)/2),"normal"===this.distribution){const n=Math.sqrt(a);if("float32"!==(t=t||"float32")&&"int32"!==t)throw new Sd(`${this.getClassName()} does not support dType ${t}.`);return ic(e,0,n,t,this.seed)}{const n=Math.sqrt(3*a);return yu(e,-n,n,t)}}getConfig(){return{scale:this.scale,mode:this.mode,distribution:this.distribution,seed:this.seed}}}Xf.className="VarianceScaling",Ma(Xf);class Yf extends Xf{constructor(e){super({scale:1,mode:"fanAvg",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return Xf.className}}Yf.className="GlorotUniform",Ma(Yf);class Jf extends Xf{constructor(e){super({scale:1,mode:"fanAvg",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return Xf.className}}Jf.className="GlorotNormal",Ma(Jf);class Zf extends Xf{constructor(e){super({scale:2,mode:"fanIn",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return Xf.className}}Zf.className="HeNormal",Ma(Zf);class Qf extends Xf{constructor(e){super({scale:2,mode:"fanIn",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return Xf.className}}Qf.className="HeUniform",Ma(Qf);class em extends Xf{constructor(e){super({scale:1,mode:"fanIn",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return Xf.className}}em.className="LeCunNormal",Ma(em);class tm extends Xf{constructor(e){super({scale:1,mode:"fanIn",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return Xf.className}}tm.className="LeCunNormal",Ma(tm);class nm extends Wf{constructor(e){if(super(),this.DEFAULT_GAIN=1,this.gain=null==e.gain?this.DEFAULT_GAIN:e.gain,this.seed=e.seed,null!=this.seed)throw new Sd("Random seed is not implemented for Orthogonal Initializer yet.")}apply(e,t){return Za(()=>{if(e.length<2)throw new Sd("Shape must be at least 2D.");e[0]*e[1]>2e3&&console.warn(`Orthogonal initializer is being called on a matrix with more than 2000 (${e[0]*e[1]}) elements: Slowness may result.`);const t=Rf(e[0]>e[1]?[e[1],e[0]]:e,0,1,"float32");let n=vh.gramSchmidt(t);return e[0]>e[1]&&(n=n.transpose()),fi(this.gain,n)})}getConfig(){return{gain:this.gain,seed:this.seed}}}nm.className="Orthogonal",Ma(nm);const sm={constant:"Constant",glorotNormal:"GlorotNormal",glorotUniform:"GlorotUniform",heNormal:"HeNormal",heUniform:"HeUniform",identity:"Identity",leCunNormal:"LeCunNormal",leCunUniform:"LeCunUniform",ones:"Ones",orthogonal:"Orthogonal",randomNormal:"RandomNormal",randomUniform:"RandomUniform",truncatedNormal:"TruncatedNormal",varianceScaling:"VarianceScaling",zeros:"Zeros"};function rm(e,t={}){return Ld(e,Oa.getMap().classNameMap,t,"initializer")}function am(e){return Md(e)}function im(e){if("string"==typeof e){const t=e in sm?sm[e]:e;if("GlorotNormal"===t)return new Jf;if("GlorotUniform"===t)return new Yf;if("HeNormal"===t)return new Zf;if("HeUniform"===t)return new Qf;if("LeCunNormal"===t)return new em;if("LeCunUniform"===t)return new tm;{const e={};return e.className=t,e.config={},rm(e)}}return e instanceof Wf?e:rm(e)}var om=Object.freeze({__proto__:null,zeros:function(){return new Vf},ones:function(){return new Uf},constant:function(e){return new Gf(e)},randomUniform:function(e){return new Hf(e)},randomNormal:function(e){return new jf(e)},truncatedNormal:function(e){return new qf(e)},identity:function(e){return new Kf(e)},varianceScaling:function(e){return new Xf(e)},glorotUniform:function(e){return new Yf(e)},glorotNormal:function(e){return new Jf(e)},heNormal:function(e){return new Zf(e)},heUniform:function(e){return new Qf(e)},leCunNormal:function(e){return new em(e)},leCunUniform:function(e){return new tm(e)},orthogonal:function(e){return new nm(e)}});let lm=0;function um(){return lm++}const cm={};function hm(e=""){return e in cm||(cm[e]=0),cm[e]+=1,e+cm[e].toString()}function pm(e){return Array.isArray(e)&&Array.isArray(e[0])}function dm(e){return 0===e.length?[]:Array.isArray(e[0])?e:[e]}function fm(e){let t;if(Array.isArray(e)){if(1!==e.length)throw new Cd("Expected Tensor length to be 1; got "+e.length);t=e[0]}else t=e;return t}function mm(e){if(Array.isArray(e)&&Array.isArray(e[0])){if(1===e.length)return(e=e)[0];throw new Cd("Expected exactly 1 Shape; got "+e.length)}return e}function gm(e){let t=0;for(const n of e)0===n.shape.length?t+=1:t+=n.shape.reduce((e,t)=>e*t);return t}class ym{constructor(e,t="float32",n="Variable",s=!0,r=null){this.dtype=null==t?"float32":t,this.shape=e.shape,this.id=um(),n=null==n?"Variable":n,this.originalName=ff(n),this.name=mf(this.originalName),this.trainable_=s,this.constraint=r,this.val=cc(e,this.trainable_,this.name,this.dtype)}read(){return this.assertNotDisposed(),this.val}write(e){return this.assertNotDisposed(),function(e,t){if(e.shape.toString()!==t.shape.toString())throw new Error("Shape mismatch: "+JSON.stringify(e.shape)+" vs. "+JSON.stringify(t.shape))}(this.val,e),this.val.id!==e.id&&(this.val.assign(e),null!=this.constraint&&this.val.assign(this.constraint.apply(this.val))),this}dispose(){this.assertNotDisposed(),this.val.dispose()}assertNotDisposed(){if(this.val.isDisposed)throw new Error(`LayersVariable ${this.name} is already disposed.`)}get trainable(){return this.trainable_}set trainable(e){this.trainable_=e,this.val.trainable=e}}function bm(e){return e.map(e=>e.read())}function xm(e){e.forEach(e=>{e[0].write(e[1])})}class wm{constructor(e){this.dtype=e.dtype,this.shape=e.shape,null!=e.shape?this.ndim=e.shape.length:this.ndim=e.ndim,this.maxNDim=e.maxNDim,this.minNDim=e.minNDim,this.axes=e.axes||{}}}class km{constructor(e,t,n,s,r,a,i){this.dtype=e,this.shape=t,this.sourceLayer=n,this.inputs=s,this.callArgs=r,this.outputTensorIndex=i,this.id=um(),null!=a&&(this.originalName=ff(a),this.name=mf(this.originalName)),this.rank=t.length}}let vm=0;class Nm{constructor(e,t){this.callArgs=t,this.id=vm++,this.outboundLayer=e.outboundLayer,this.inboundLayers=e.inboundLayers,this.nodeIndices=e.nodeIndices,this.tensorIndices=e.tensorIndices,this.inputTensors=e.inputTensors,this.outputTensors=e.outputTensors,this.inputMasks=e.inputMasks,this.outputMasks=e.outputMasks,this.inputShapes=e.inputShapes,this.outputShapes=e.outputShapes;for(const t of e.inboundLayers)null!=t&&t.outboundNodes.push(this);e.outboundLayer.inboundNodes.push(this)}getConfig(){const e=[];for(const t of this.inboundLayers)null!=t?e.push(t.name):e.push(null);return{outboundLayer:this.outboundLayer?this.outboundLayer.name:null,inboundLayers:e,nodeIndices:this.nodeIndices,tensorIndices:this.tensorIndices}}}let Im=0;class Cm extends _a{constructor(e={}){super(),this._callHook=null,this._addedWeightNames=[],this._stateful=!1,this.id=Im++,this.activityRegularizer=null,this.inputSpec=null,this.supportsMasking=!1,this._trainableWeights=[],this._nonTrainableWeights=[],this._losses=[],this._updates=[],this._built=!1,this.inboundNodes=[],this.outboundNodes=[];let t=e.name;if(!t){const e=this.getClassName();t=Dd(e)+"_"+hm(e)}if(this.name=t,this.trainable_=null==e.trainable||e.trainable,null!=e.inputShape||null!=e.batchInputShape){let t;if(null!=e.batchInputShape)t=e.batchInputShape;else if(null!=e.inputShape){let n=null;null!=e.batchSize&&(n=e.batchSize),t=[n].concat(e.inputShape)}this.batchInputShape=t;let n=e.dtype;null==n&&(n=e.inputDType),null==n&&(n="float32"),this.dtype=n}null!=e.weights?this.initialWeights=e.weights:this.initialWeights=null,this._refCount=null,this.fastWeightInitDuringBuild=!1}static nodeKey(e,t){return e.name+"_ib-"+t.toString()}getNodeAtIndex(e,t){if(0===this.inboundNodes.length)throw new Id(`The layer has never been called and thus has no defined ${t}.`);if(this.inboundNodes.length<=e)throw new Cd(`Asked to get ${t} at node ${e}, but the layer has only ${this.inboundNodes.length} inbound nodes.`);return this.inboundNodes[e]}getInputAt(e){return Rd(this.getNodeAtIndex(e,"input").inputTensors)}getOutputAt(e){return Rd(this.getNodeAtIndex(e,"output").outputTensors)}get input(){if(this.inboundNodes.length>1)throw new Nd("Layer "+this.name+' has multiple inbound nodes, hence the notion of "layer input" is ill-defined. Use `getInputAt(nodeIndex)` instead.');if(0===this.inboundNodes.length)throw new Nd("Layer "+this.name+" is not connected, no input to return.");return Rd(this.getNodeAtIndex(0,"input").inputTensors)}get output(){if(0===this.inboundNodes.length)throw new Nd("Layer "+this.name+" has no inbound nodes.");if(this.inboundNodes.length>1)throw new Nd("Layer "+this.name+' has multiple inbound nodes, hence the notion of "layer output" is ill-defined. Use `getOutputAt(nodeIndex)` instead.');return Rd(this.getNodeAtIndex(0,"output").outputTensors)}get losses(){return this._losses}calculateLosses(){return this.losses.map(e=>e())}get updates(){return this._updates}get built(){return this._built}set built(e){this._built=e}get trainable(){return this.trainable_}set trainable(e){this._trainableWeights.forEach(t=>t.trainable=e),this.trainable_=e}get trainableWeights(){return this.trainable_?this._trainableWeights.filter(e=>e.trainable):[]}set trainableWeights(e){this._trainableWeights=e}get nonTrainableWeights(){return this.trainable?this._trainableWeights.filter(e=>!e.trainable).concat(this._nonTrainableWeights):this._trainableWeights.concat(this._nonTrainableWeights)}set nonTrainableWeights(e){this._nonTrainableWeights=e}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}get stateful(){return this._stateful}resetStates(){if(!this.stateful)throw new Error("Cannot call the resetStates() method of a non-stateful Layer object.")}assertInputCompatibility(e){if(e=Fd(e),null==this.inputSpec||0===this.inputSpec.length)return;const t=Fd(this.inputSpec);if(e.length!==t.length)throw new Cd(`Layer ${this.name} expects ${t.length} inputs, but it received ${e.length} input tensors. Input received: `+e);for(let n=0;n<e.length;n++){const s=e[n],r=t[n];if(null==r)continue;const a=s.rank;if(null!=r.ndim&&a!==r.ndim)throw new Cd(`Input ${n} is incompatible with layer ${this.name}: expected ndim=${r.ndim}, found ndim=${a}`);if(null!=r.maxNDim&&a>r.maxNDim)throw new Cd(`Input ${n} is incompatible with layer ${this.name}: expected max_ndim=${r.maxNDim}, found ndim=${a}`);if(null!=r.minNDim&&a<r.minNDim)throw new Cd(`Input ${n} is incompatible with layer ${this.name}: expected min_ndim=${r.minNDim}, found ndim=${a}.`);if(null!=r.dtype&&s.dtype!==r.dtype)throw new Cd(`Input ${n} is incompatible with layer ${this.name} : expected dtype=${r.dtype}, found dtype=${s.dtype}.`);if(r.axes){const e=s.shape;for(const t in r.axes){const s=Number(t),a=r.axes[t],i=s>=0?e[s]:e[e.length+s];if(null!=a&&-1===[a,null].indexOf(i))throw new Cd(`Input ${n} is incompatible with layer ${this.name}: expected axis ${s} of input shape to have value ${a} but got shape ${e}.`)}}if(null!=r.shape)for(let e=0;e<r.shape.length;++e){const t=r.shape[e],a=s.shape[e];if(null!=t&&null!=a&&t!==a)throw new Cd(`Input ${n} is incompatible with layer ${this.name}: expected shape=${r.shape}, found shape=${s.shape}.`)}}}call(e,t){return e}invokeCallHook(e,t){null!=this._callHook&&this._callHook(e,t)}setCallHook(e){this._callHook=e}clearCallHook(){this._callHook=null}apply(e,t){t=t||{},this.assertNotDisposed();const n=Fd(e);let s=!0;for(const e of n)if(!(e instanceof km)){s=!1;break}let r=!0;for(const e of n)if(e instanceof km){r=!1;break}if(s===r)throw new Cd("Arguments to apply() must be all SymbolicTensors or all Tensors");return df(this.name,()=>{if(!this.built){this.assertInputCompatibility(e);const t=[];for(const n of Fd(e))t.push(n.shape);this.build(Rd(t)),this.built=!0,this.initialWeights&&this.setWeights(this.initialWeights),null===this._refCount&&r&&(this._refCount=1)}if(this.assertInputCompatibility(e),r){let s=this.call(e,t);const r=Fd(s),a=[];for(let e of r)-1!==n.indexOf(e)&&(e=e.clone()),a.push(e);if(s=Rd(a),null!=this.activityRegularizer)throw new Sd("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return s}{const n=function(e){e=Fd(e);const t=[];for(const n of e)t.push(n.shape);return Rd(t)}(e),s=this.computeOutputShape(n);let r;const a="float32";if(this.warnOnIncompatibleInputShape(Array.isArray(e)?n[0]:n),r=null!=s&&s.length>0&&Array.isArray(s[0])?s.map((n,s)=>new km(a,n,this,Fd(e),t,this.name,s)):new km(a,s,this,Fd(e),t,this.name),this.addInboundNode(e,r,null,null,n,s,t),this._refCount++,null!=this.activityRegularizer)throw new Sd("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return r}})}warnOnIncompatibleInputShape(e){if(null!=this.batchInputShape)if(e.length!==this.batchInputShape.length)console.warn("The rank of the input tensor provided (shape: "+JSON.stringify(e)+") does not match that of the "+`batchInputShape (${JSON.stringify(this.batchInputShape)}) of the layer `+this.name);else{let t=!1;this.batchInputShape.forEach((n,s)=>{null!=n&&null!=e[s]&&e[s]!==n&&(t=!0)}),t&&console.warn(`The shape of the input tensor (${JSON.stringify(e)}) does not match the expectation of layer ${this.name}: `+JSON.stringify(this.batchInputShape))}}get outputShape(){if(null==this.inboundNodes||0===this.inboundNodes.length)throw new Nd(`The layer ${this.name} has never been called and thus has no defined output shape.`);const e=[];for(const t of this.inboundNodes){const n=JSON.stringify(t.outputShapes);-1===e.indexOf(n)&&e.push(n)}if(1===e.length){const e=this.inboundNodes[0].outputShapes;return Array.isArray(e)&&Array.isArray(e[0])&&1===e.length?e[0]:e}throw new Nd(`The layer ${this.name} has multiple inbound nodes with different output shapes. Hence the notion of "output shape" is ill-defined for the layer.`)}countParams(){if(!this.built)throw new Id(`You tried to call countParams() on ${this.name}, but the layer is not built yet. Build it first by calling build(batchInputShape).`);return gm(this.weights)}build(e){this.built=!0}getWeights(e=!1){return bm(e?this.trainableWeights:this.weights)}setWeights(e){Za(()=>{const t=this.weights;if(t.length!==e.length)throw new Cd(`You called setWeights(weights) on layer "${this.name}" with a weight list of length ${e.length}, but the layer was expecting ${t.length} weights. Provided weights: ${e}...`);if(0===t.length)return;const n=[],s=bm(t);for(let r=0;r<s.length;++r){const a=s[r],i=t[r],o=e[r];if(!p(a.shape,o.shape))throw new Cd(`Layer weight shape ${a.shape} not compatible with provided weight shape `+o.shape);n.push([i,o])}xm(n)})}addWeight(e,t,n,s,r,a,i){if(-1!==this._addedWeightNames.indexOf(e))throw new Cd(`Duplicate weight name ${e} for layer ${this.name}`);this._addedWeightNames.push(e),null==n&&(n="float32"),this.fastWeightInitDuringBuild&&(s=im("zeros"));const o=s.apply(t,n),l=new ym(o,n,e,a,i);return o.dispose(),null!=r&&this.addLoss(()=>r.apply(l.read())),null==a&&(a=!0),a?this._trainableWeights.push(l):this._nonTrainableWeights.push(l),l}setFastWeightInitDuringBuild(e){this.fastWeightInitDuringBuild=e}addLoss(e){null==e||Array.isArray(e)&&0===e.length||(e=Fd(e),void 0!==this._losses&&null!==this._losses&&this.losses.push(...e))}computeOutputShape(e){return e}computeMask(e,t){if(!this.supportsMasking){if(null!=t){if(!Array.isArray(t))throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);t.forEach(e=>{if(null!=e)throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`)})}return null}return t}addInboundNode(e,t,n,s,r,a,i=null){const o=Fd(e);t=Fd(t),n=Fd(n),s=Fd(s),r=dm(r),a=dm(a);const l=[],u=[],c=[];for(const e of o)l.push(e.sourceLayer),u.push(e.nodeIndex),c.push(e.tensorIndex);new Nm({outboundLayer:this,inboundLayers:l,nodeIndices:u,tensorIndices:c,inputTensors:o,outputTensors:t,inputMasks:n,outputMasks:s,inputShapes:r,outputShapes:a},i);for(let e=0;e<t.length;e++)t[e].sourceLayer=this,t[e].nodeIndex=this.inboundNodes.length-1,t[e].tensorIndex=e}getConfig(){const e={name:this.name,trainable:this.trainable};return null!=this.batchInputShape&&(e.batchInputShape=this.batchInputShape),null!=this.dtype&&(e.dtype=this.dtype),e}disposeWeights(){return this.weights.forEach(e=>e.dispose()),this.weights.length}assertNotDisposed(){if(0===this._refCount)throw new Error(`Layer '${this.name}' is already disposed.`)}dispose(){if(!this.built)throw new Error(`Cannot dispose Layer ${this.name} because it has not been built yet.`);if(null===this._refCount)throw new Error(`Cannot dispose Layer ${this.name} because it has not been used yet.`);this.assertNotDisposed();let e=0;return 0==--this._refCount&&(e=this.disposeWeights()),{refCountAfterDispose:this._refCount,numDisposedVariables:e}}}class Sm extends Cm{constructor(e){if(super({dtype:e.dtype,name:null!=e.name?e.name:hm("input").toString()}),null==e.batchSize&&(e.batchSize=null),null==e.sparse&&(e.sparse=!1),this.trainable=!1,this.built=!0,this.sparse=e.sparse,null!=e.inputShape&&null!=e.batchInputShape)throw new Cd("Only provide the inputShape OR batchInputShape argument to inputLayer, not both at the same time.");let t=e.batchInputShape;if(null==t){if(null==e.inputShape)throw new Cd("An InputLayer should be passed either a `batchInputShape` or an `inputShape`.");t=[e.batchSize].concat(e.inputShape)}else if(null!=e.batchSize)throw new Cd("Cannot specify batchSize if batchInputShape is specified when creating an InputLayer.");const n=e.dtype||"float32";this.batchInputShape=t,this.dtype=n,this.inputSpec=[{shape:t}];const s=new km(this.dtype,this.batchInputShape,this,[],{},this.name);s.nodeIndex=0,s.tensorIndex=0,new Nm({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:[s],outputTensors:[s],inputMasks:[null],outputMasks:[null],inputShapes:[t],outputShapes:[t]})}apply(e,t){throw new Cd("Cannot pass any input to an InputLayer's apply() method. InputLayer name: "+this.name)}dispose(){return{refCountAfterDispose:this._refCount,numDisposedVariables:0}}getConfig(){return{batchInputShape:this.batchInputShape,dtype:this.dtype,sparse:this.sparse,name:this.name}}}function Tm(e){if(null==e.batchShape&&null==e.shape)throw new Error("Please provide to Input either a `shape` or a `batchShape` argument. Note that `shape` does not include the batch dimension.");if(null!=e.batchShape&&null!=e.shape)throw new Cd("Please provide either a `shape` or `batchShape` argument to Input, but not both.");let t=e.batchShape;null!=e.shape&&null==t&&(t=[null].concat(e.shape));let n=e.dtype;return null==n&&(n="float32"),new Sm({batchInputShape:t,name:e.name,dtype:n,sparse:e.sparse}).inboundNodes[0].outputTensors[0]}async function Em(e){if(null==e)return;const t=[],n=[],s=[];for(const r in e){const a=e[r];if("number"!=typeof a){const e=a;t.push(e.data()),n.push(r),s.push(e)}}if(t.length>0){const r=await Promise.all(t);for(let t=0;t<r.length;++t)e[n[t]]=r[t][0];Qa(s)}}function $m(e){if(null!=e)for(const t in e){const n=e[t];"number"!=typeof n&&n.dispose()}}var Am;Sm.className="InputLayer",Ma(Sm),function(e){e[e.SILENT=0]="SILENT",e[e.VERBOSE=1]="VERBOSE"}(Am||(Am={}));class Rm{constructor(){this.validationData=null}setParams(e){this.params=e}async onEpochBegin(e,t){}async onEpochEnd(e,t){}async onBatchBegin(e,t){}async onBatchEnd(e,t){}async onTrainBegin(e){}async onTrainEnd(e){}setModel(e){}}class Fm{constructor(e,t=10){null==e&&(e=[]),this.callbacks=e,this.queueLength=t}append(e){this.callbacks.push(e)}setParams(e){for(const t of this.callbacks)t.setParams(e)}setModel(e){for(const t of this.callbacks)t.setModel(e)}async onEpochBegin(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onEpochBegin(e,t)}async onEpochEnd(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onEpochEnd(e,t)}async onBatchBegin(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onBatchBegin(e,t)}async onBatchEnd(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onBatchEnd(e,t)}async onTrainBegin(e){null==e&&(e={});for(const t of this.callbacks)await t.onTrainBegin(e)}async onTrainEnd(e){null==e&&(e={});for(const t of this.callbacks)await t.onTrainEnd(e)}}class Dm extends Rm{constructor(){super()}async onEpochBegin(e){this.seen=0,this.totals={}}async onBatchEnd(e,t){null==t&&(t={});const n=null==t.size?0:t.size;this.seen+=n;for(const e in t){const s=t[e];if("number"==typeof s)this.totals.hasOwnProperty(e)||(this.totals[e]=0),this.totals[e]=this.totals[e]+s*n;else{let t;e in this.totals?t=this.totals[e]:this.totals[e]=0;const r=Za(()=>hi(this.totals[e],fi(s,n)));this.totals[e]=r,null!=t&&t.dispose()}}}async onEpochEnd(e,t){if(null!=t)for(const e of this.params.metrics)null!=this.totals[e]&&("number"==typeof this.totals[e]?t[e]=this.totals[e]/this.seen:Za(()=>{const n=fi(di(1,this.seen),this.totals[e]);t[e]=n,this.totals[e].dispose(),ei(t[e])}))}}class _m extends Rm{async onTrainBegin(e){this.epoch=[],this.history={}}async onEpochEnd(e,t){null==t&&(t={}),this.epoch.push(e);for(const e in t)null==this.history[e]&&(this.history[e]=[]),this.history[e].push(t[e])}async syncData(){const e=[],t=[],n=[];for(const s in this.history){const r=this.history[s];for(let a=0;a<r.length;++a)if("number"!=typeof r[a]){const i=r[a];e.push(i.data()),t.push(s),n.push(a)}}const s=await Promise.all(e);for(let e=0;e<s.length;++e){this.history[t[e]][n[e]].dispose(),this.history[t[e]][n[e]]=s[e][0]}}}class Om extends Rm{constructor(e,t){if(super(),this.currentEpoch=0,this.yieldEvery=t||"auto","auto"===this.yieldEvery&&(this.yieldEvery=125),"never"===this.yieldEvery&&null!=e.onYield)throw new Error("yieldEvery is `never` but you provided an `onYield` callback. Either change `yieldEvery` or remove the callback");A(this.yieldEvery)&&(this.maybeWait=function(e,t){let n,s=rs();return(...r)=>{const a=rs();return a-s<t||(s=a,n=e(...r)),n}}(this.maybeWait.bind(this),this.yieldEvery)),this.trainBegin=e.onTrainBegin,this.trainEnd=e.onTrainEnd,this.epochBegin=e.onEpochBegin,this.epochEnd=e.onEpochEnd,this.batchBegin=e.onBatchBegin,this.batchEnd=e.onBatchEnd,this.yield=e.onYield}async maybeWait(e,t,n){const s=[];null!=this.yield&&(await Em(n),s.push(this.yield(e,t,n))),s.push(Oh()),await Promise.all(s)}async onEpochBegin(e,t){this.currentEpoch=e,null!=this.epochBegin&&(await Em(t),await this.epochBegin(e,t))}async onEpochEnd(e,t){const n=[];null!=this.epochEnd&&(await Em(t),n.push(this.epochEnd(e,t))),"epoch"===this.yieldEvery&&n.push(Oh()),await Promise.all(n)}async onBatchBegin(e,t){null!=this.batchBegin&&(await Em(t),await this.batchBegin(e,t))}async onBatchEnd(e,t){const n=[];null!=this.batchEnd&&(await Em(t),n.push(this.batchEnd(e,t))),"batch"===this.yieldEvery?n.push(Oh()):A(this.yieldEvery)&&n.push(this.maybeWait(this.currentEpoch,e,t)),await Promise.all(n)}async onTrainBegin(e){null!=this.trainBegin&&(await Em(e),await this.trainBegin(e))}async onTrainEnd(e){null!=this.trainEnd&&(await Em(e),await this.trainEnd(e))}}function Mm(e,t){if(null==e&&(e={}),e instanceof Rm)return[e];if(Array.isArray(e)&&e[0]instanceof Rm)return e;return Fd(e).map(e=>new Om(e,t))}class Lm{constructor(){}static registerCallbackConstructor(e,t){o(e>=0&&Number.isInteger(e),()=>"Verbosity level is expected to be an integer >= 0, but got "+e),Lm.checkForDuplicate(t),null==Lm.constructors[e]&&(Lm.constructors[e]=[]),Lm.constructors[e].push(t)}static checkForDuplicate(e){for(const t in Lm.constructors){Lm.constructors[+t].forEach(t=>{if(t===e)throw new Cd("Duplicate callback constructor.")})}}static clear(){Lm.constructors={}}static createCallbacks(e){const t=[];for(const n in Lm.constructors){const s=+n;e>=s&&t.push(...Lm.constructors[s])}return t.map(e=>new e)}}function zm(e,t,n,s,r,a,i,o,l){const u=new _m,c=[new Dm,...Lm.createCallbacks(t)];null!=e&&c.push(...e),c.push(u);const h=new Fm(c);return h.setParams({epochs:n,initialEpoch:s,samples:r,steps:a,batchSize:i,verbose:t,doValidation:o,metrics:l}),{callbackList:h,history:u}}function Bm(e,t={},n=!1){return Ld(e,Oa.getMap().classNameMap,t,"layer",n)}function Pm(e,t){return Za(()=>{"float32"!==e.dtype&&(e=e.asType("float32"));const n=dl(_f(e),t,!0),s=Bo(n.shape,vd()),r=qu(Rl(n,s));return di(e,r)})}function Wm(e,t){return Za(()=>Fl(_f(pl(t,e)),-1))}function Vm(e,t){return Za(()=>Fl(mi(pl(t,e)),-1))}function Um(e,t){return Za(()=>{const n=pl(e,t),s=so(mi(e),vd(),Number.MAX_VALUE),r=mi(di(n,s));return fi(100,Fl(r,-1))})}function Gm(e,t){return Za(()=>{const n=so(t,vd(),Number.MAX_VALUE),s=Qo(hi(1,n)),r=so(e,vd(),Number.MAX_VALUE),a=Qo(hi(1,r));return Fl(_f(pl(s,a)),-1)})}function Hm(e,t,n=!1){return Za(()=>{if(n)t=Wu(t);else{const e=dl(t,t.shape.length-1,!0);t=di(t,e)}return t=so(t,vd(),1-vd()),ll(dl(fi(e.toFloat(),Qo(t)),t.shape.length-1))})}function jm(e,t,n=!1){return Za(()=>{const s=Po(function(e){const t=[bf(e.shape)];return e.reshape(t)}(e)).toInt(),r=(t=so(t,vd(),1-vd())).shape;return Hm(sa(s,r[r.length-1]).reshape(r),t,n)})}function qm(e,t){return Za(()=>{let n;return n=so(t,vd(),1-vd()),n=Qo(di(n,pl(1,n))),Fl(function(e,t){if(!p(e.shape,t.shape))throw new Cd(`logits and labels must have the same shape, but got shapes ${JSON.stringify(e.shape)} and ${JSON.stringify(t.shape)}`);return Za(()=>{const n=t.relu(),s=t.abs().neg();return n.sub(t.mul(e)).add(s.exp().log1p())})}(e,n),-1)})}function Km(e,t){return Za(()=>{const n=so(e,vd(),1),s=so(t,vd(),1);return dl(fi(e,Qo(di(n,s))),-1)})}function Xm(e,t){return Za(()=>{const n=Pm(e,-1),s=Pm(t,-1),r=fi(n,s);return ll(dl(r,-1))})}Lm.constructors={};const Ym={meanSquaredError:Wm,meanAbsoluteError:Vm,meanAbsolutePercentageError:Um,meanSquaredLogarithmicError:Gm,squaredHinge:function(e,t){return Za(()=>{const n=Rl(0,pl(1,fi(e,t)));return Fl(_f(n),-1)})},hinge:function(e,t){return Za(()=>{const n=Rl(0,pl(1,fi(e,t)));return Fl(n,-1)})},categoricalHinge:function(e,t){return Za(()=>{const n=dl(fi(e,t),-1),s=hl(fi(pl(1,e),t),-1);return Rl(0,hi(1,pl(s,n)))})},logcosh:function(e,t){return Za(()=>{const n=Math.log(2),s=pl(t,e),r=pl(hi(s,ul(fi(-2,s))),n);return Fl(r,-1)})},categoricalCrossentropy:Hm,sparseCategoricalCrossentropy:jm,binaryCrossentropy:qm,kullbackLeiblerDivergence:Km,poisson:function(e,t){return Za(()=>{const n=Qo(hi(vd(),t));return Fl(pl(t,fi(e,n)),-1)})},cosineProximity:Xm};function Jm(e){if("string"==typeof e){if(e in Ym)return Ym[e];let t="Unknown loss "+e;throw e.toLowerCase().includes("softmaxcrossentropy")&&(t=`Unknown loss ${e}. Use "categoricalCrossentropy" as the string name for tf.losses.softmaxCrossEntropy`),new Cd(t)}return e}function Zm(e,t){return Za(()=>{const n=fi(.5,Gl(t)),s=Nf(Vo(t,n),e.dtype);return Fl(To(e,s),-1)})}function Qm(e,t){return Za(()=>Nf(To(ki(e,-1),ki(t,-1)),"float32"))}function eg(e,t){return Za(()=>Il(e.equal(1),t.equal(1)).sum().cast("float32"))}function tg(e,t){return Za(()=>{const n=eg(e,t),s=function(e,t){return Za(()=>Il(e.equal(0),t.equal(1)).sum().cast("float32"))}(e,t),r=n.add(s);return Eo(Vo(r,0),n.div(r),0).cast("float32")})}function ng(e,t){return Za(()=>{const n=eg(e,t),s=function(e,t){return Za(()=>Il(e.equal(1),t.equal(0)).sum().cast("float32"))}(e,t),r=n.add(s);return Eo(Vo(r,0),n.div(r),0).cast("float32")})}function sg(e,t){return qm(e,t)}function rg(e,t){return e.rank===t.rank&&(e=e.squeeze([e.rank-1])),(t=t.argMax(-1)).dtype!==e.dtype&&(t=t.asType(e.dtype)),To(e,t).asType("float32")}const ag=Hm,ig=jm,og={binaryAccuracy:Zm,categoricalAccuracy:Qm,precision:tg,categoricalCrossentropy:ag,sparseCategoricalCrossentropy:ig,mse:Wm,MSE:Wm,mae:Vm,MAE:Vm,mape:Um,MAPE:Um,cosine:Xm};function lg(e){if("string"==typeof e&&e in og)return og[e];if("string"!=typeof e&&null!=e)return e;throw new Cd("Unknown metric "+e)}function ug(e){if($d(null!==e,"Unknown LossOrMetricFn "+e),"string"==typeof e)return e;{let t;for(const n of Object.keys(Ym))if(Ym[n]===e){t=n;break}if(void 0!==t)return t;for(const n of Object.keys(og))if(og[n]===e){t=n;break}return void 0!==t?t:e.name}}function cg(e,t,n=!1){if(null==e||"object"!=typeof e||Object.getPrototypeOf(e)!==Object.prototype||!function e(t){if(null===t)return!0;if("object"==typeof t){if(Object.getPrototypeOf(t)===Object.prototype){const n=Object.keys(t);for(const s of n){if("string"!=typeof s)return!1;if(!e(t[s]))return!1}return!0}if(Array.isArray(t)){for(const n of t)if(!e(n))return!1;return!0}return!1}{const e=typeof t;return"string"===e||"number"===e||"boolean"===e}}(e))throw new Error("User-defined metadata is expected to be a JSON object, but is not.");if(n){const n=JSON.stringify(e);n.length>1048576&&console.warn(`User-defined metadata of model "${t}" is too large in size (length=${n.length} when serialized). It is not recommended to store such large objects in user-defined metadata. Please make sure its serialized length is <= 1048576.`)}}function hg(e,t,n,s=console.log){const r=function(e){let t=!0;const n=[],s=[];for(const t in e.nodesByDepth)n.push(e.nodesByDepth[t]);for(const e of n){if(e.length>1||1===e.length&&e[0].inboundLayers.length>1){t=!1;break}s.push(...e)}if(t)for(const n of e.layers){let e=!1;for(const r of n.inboundNodes)if(-1!==s.indexOf(r)){if(e){t=!1;break}e=!0}if(!t)break}return t}(e),a=["Layer (type)","Output shape","Param #"];let i;if(r?(t=t||65,n=n||[.45,.85,1]):(t=t||98,n=n||[.33,.55,.67,1]),n[n.length-1]<=1&&(n=n.map(e=>Math.floor(t*e))),!r){a.push("Receives inputs"),i=[];for(const t in e.nodesByDepth)i.push(...e.nodesByDepth[t])}s("_".repeat(t)),pg(a,n,s),s("=".repeat(t));const o=e.layers;for(let e=0;e<o.length;++e)r?dg(o[e],n,s):fg(o[e],n,i,s),s((e===o.length-1?"=":"_").repeat(t));e.checkTrainableWeightsConsistency();const l=function(e){let t;t=null!=e.collectedTrainableWeights?gm(e.collectedTrainableWeights):gm(e.trainableWeights);return t}(e),u=gm(e.nonTrainableWeights);s("Total params: "+(l+u)),s("Trainable params: "+l),s("Non-trainable params: "+u),s("_".repeat(t))}function pg(e,t,n=console.log){let s="";for(let n=0;n<e.length;++n)n>0&&(s=s.slice(0,s.length-1)+" "),s+=e[n],s=s.slice(0,t[n]),s+=" ".repeat(t[n]-s.length);n(s)}function dg(e,t,n){let s;try{s=JSON.stringify(e.outputShape)}catch(e){s="multiple"}pg([`${e.name} (${e.getClassName()})`,s,e.countParams().toString()],t,n)}function fg(e,t,n,s){let r;try{r=JSON.stringify(e.outputShape)}catch(e){r="multiple"}const a=[];for(const t of e.inboundNodes)if(!(null!=n&&n.length>0&&-1===n.indexOf(t)))for(let e=0;e<t.inboundLayers.length;++e){const n=t.inboundLayers[e].name,s=t.nodeIndices[e],r=t.tensorIndices[e];a.push(`${n}[${s}][${r}]`)}const i=e.name,o=e.getClassName(),l=0===a.length?"":a[0];pg([`${i} (${o})`,r,e.countParams().toString(),l],t,s);for(let e=1;e<a.length;++e)pg(["","","",a[e]],t,s)}function mg(e,t,n){return("inboundNodes"===e||"outputLayers"===e||"inputLayers"===e)&&0===t&&"string"==typeof n}function gg(e,t){if(null===e)return null;if("string"==typeof e)return _d(e);if("number"==typeof e||"boolean"==typeof e)return e;if(e instanceof Array){const n=[],s=e.length;for(let r=0;r<s;++r){const s=e[r];mg(t,r,s)?n.push(s):n.push(gg(s,t))}return n}{const t={};for(const n of Object.keys(e)){const s=e[n];if("name"===n&&"string"==typeof s)t[n]=s;else{const e=_d(n);t[e]=gg(s,e)}}return t}}const yg="3.2.0";class bg{constructor(e){if(this.id2Value={},this.id2Mask={},this.name2Id={},e instanceof bg)for(const t in e.id2Value)this.id2Value[t]=e.id2Value[t],t in e.id2Mask&&(this.id2Mask[t]=e.id2Mask[t]);else{if(null==e)return;for(const t of e)this.add(t.key,t.value)}}add(e,t,n){if(null!=this.id2Value[e.id])throw new Cd(`Duplicate key: name=${e.name}, id=${e.id}`);return this.id2Value[e.id]=function(e,t){if(null==e.dtype||e.dtype===t.dtype)return t;try{return zr(t,e.dtype)}catch(n){throw new Cd(`The dtype of the feed (${t.dtype}) can not be cast to the dtype of the key '${e.name}' (${e.dtype}).`)}}(e,t),this.name2Id[e.name]=e.id,null!=n&&(this.id2Mask[e.id]=n),this}addFeed(e){this.add(e.key,e.value)}hasKey(e){return null!=this.id2Value[e.id]}names(){return Object.keys(this.name2Id)}getValue(e){if(e instanceof km){if(null==this.id2Value[e.id])throw new Cd("Nonexistent key: "+e.name);return this.id2Value[e.id]}{const t=this.name2Id[e];if(null==t)throw new Cd("Feed dict has no SymbolicTensor name: "+e);return this.id2Value[t]}}getMask(e){if(e instanceof km){if(null==this.id2Value[e.id])throw new Cd("Nonexistent key: "+e.name);return this.id2Mask[e.id]}{const t=this.name2Id[e];if(null==t)throw new Cd("Feed dict has no SymbolicTensor name: "+e);return this.id2Mask[t]}}disposeMasks(){null!=this.id2Mask&&Qa(this.id2Mask)}}const xg={},wg={};function kg(e,t,n,s){const r=null!=n&&n.training,a=Array.isArray(e),i=a?e:[e],l=i.map(e=>e.name),u=[],c=t.names();for(const e of l)-1!==c.indexOf(e)?u.push(t.getValue(e)):u.push(null);null!=s&&(s.maxNumTensors=-1/0,s.minNumTensors=1/0);const h=l.join(",")+"|"+t.names().join(",");let p,d;if(null==xg[h]){const e=function(e,t){o(null!=e&&e.length>0,()=>"Expected at least one fetch, got none");let n=[],s={};if(1===e.length){const r=Ng(e[0],t);n=r.sorted,s=r.recipientMap}else{const r=new Set;for(const a of e){const{sorted:e,recipientMap:i}=Ng(a,t);for(const t of e)r.has(t.name)||(n.push(t),r.add(t.name));for(const e in i)null==s[e]&&(s[e]=new Set),i[e].forEach(t=>s[e].add(t))}}return{sorted:n,recipientCounts:vg(s)}}(i,t);p=e.sorted,d=e.recipientCounts,xg[h]=p,wg[h]=d}p=xg[h],d={},r||Object.assign(d,wg[h]);const f=new bg(t);for(let e=0;e<p.length;++e){if(null!=s){const e=Ya().numTensors;e>s.maxNumTensors&&(s.maxNumTensors=e),e<s.minNumTensors&&(s.minNumTensors=e)}const a=p[e],i=a.sourceLayer;if(i instanceof Sm)continue;const o=[],c=[],h=[];let m=!1;for(const e of a.inputs){const n=f.getValue(e),s=f.getMask(e);o.push(n),c.push(s),null!=s&&(m=!0),r||(d[e.name]--,0!==d[e.name]||t.hasKey(e)||-1!==l.indexOf(e.name)||n.isDisposed||!0===e.sourceLayer.stateful||h.push(n))}m&&((n=n||{}).mask=c[0]);const g=Fd(i.apply(o,n));let y=null;i.supportsMasking&&(y=i.computeMask(o,c));const b=Ig(a),x=Array.isArray(b)?b:[b];for(let e=0;e<x.length;++e){f.hasKey(x[e])||f.add(x[e],g[e],Array.isArray(y)?y[0]:y);const t=l.indexOf(x[e].name);-1!==t&&(u[t]=g[e])}r||Qa(h)}return f.disposeMasks(),a?u:u[0]}function vg(e){const t={};for(const n in e)t[n]=e[n].size;return t}function Ng(e,t){const n=new Set,s=[],r={};for(const e of t.names())n.add(e);const a=[],i=[];for(a.push(e);a.length>0;){const e=a[a.length-1];if(n.has(e.name)){a.pop();continue}const t=i[i.length-1]===a.length-1;if(0===e.inputs.length||t)a.pop(),s.push(e),n.add(e.name),t&&i.pop();else{i.push(a.length-1);for(const t of e.inputs)null==r[t.name]&&(r[t.name]=new Set),r[t.name].add(e.name),n.has(t.name)||a.push(t)}}return{sorted:s,recipientMap:r}}function Ig(e){let t;if(1===e.sourceLayer.inboundNodes.length)t=e.sourceLayer.output;else{let n=null;for(let t=0;t<e.sourceLayer.inboundNodes.length;++t)for(const s of e.sourceLayer.inboundNodes[t].outputTensors)if(s.id===e.id){n=t;break}t=e.sourceLayer.getOutputAt(n)}return t}class Cg extends Cm{constructor(e){if(super({}),this.containerNodes=new Set,this.name=e.name,null==this.name){const e=this.getClassName().toLowerCase();this.name=hm(e)}if(this.supportsMasking=!1,this.trainable_=!0,Array.isArray(e.inputs)?this.inputs=e.inputs.slice():this.inputs=[e.inputs],Array.isArray(e.outputs)?this.outputs=e.outputs.slice():this.outputs=[e.outputs],Bd(this.inputs).length!==this.inputs.length)throw new Cd("The list of inputs passed to the model is redundant. All inputs should only appear once. Found: "+this.inputs.map(e=>e.name));Bd(this.outputs).length!==this.outputs.length&&console.warn("The list of outputs passed to the model is redundant. All outputs should only appear once. Found: "+this.outputs.map(e=>e.name)),this.inputLayers=[],this.inputLayersNodeIndices=[],this.inputLayersTensorIndices=[],this.outputLayers=[],this.outputLayersNodeIndices=[],this.outputLayersTensorIndices=[],this.layers=[],this.internalContainerRefs=[];for(const e of this.outputs){const t=e.sourceLayer,n=e.nodeIndex,s=e.tensorIndex;this.outputLayers.push(t),this.outputLayersNodeIndices.push(n),this.outputLayersTensorIndices.push(s)}for(const e of this.inputs){const t=e.sourceLayer,n=e.nodeIndex,s=e.tensorIndex;$d(0===n,"input layer has >1 nodes"),$d(0===s,"input layer has >1 tensors"),this.inputLayers.push(t),this.inputLayersNodeIndices.push(n),this.inputLayersTensorIndices.push(s)}this.inputNames=[],this.outputNames=[],this.feedInputShapes=[],this.feedInputNames=[],this.feedOutputNames=[];for(let t=0;t<this.inputLayers.length;t++){const n=this.inputLayers[t];if(!(n instanceof Sm))throw new TypeError(`Input layers to a LayersModel must be InputLayer objects. Received inputs: ${e.inputs}. Input ${t} (0-based) originates from layer type ${n.getClassName()}.`);this.inputNames.push(n.name),this.feedInputShapes.push(n.batchInputShape),this.feedInputNames.push(n.name)}for(const e of this.outputLayers)this.outputNames.push(e.name);this.internalInputShapes=this.inputs.map(e=>e.shape),this.internalOutputShapes=this.outputs.map(e=>e.shape);const t={},n={},s={},r={},a={},i=[],o=(e,t,n,s,r,l)=>{null!=s&&null!=r&&null!=l||(s=e.sourceLayer,r=e.nodeIndex,l=e.tensorIndex);const u=s.inboundNodes[r];if(-1!==n.indexOf(u))throw new Id(`The tensor ${e.name} at layer "${s.name}" is part of a cycle.`);if(-1!==t.indexOf(u))return;this.containerNodes.add(Cg.nodeKey(s,r)),s.id in a||(a[s.id]=Object.keys(a).length),-1===n.indexOf(u)&&n.push(u);const c=u.inboundLayers.length;for(let e=0;e<c;e++){const s=u.inputTensors[e],r=u.inboundLayers[e],a=u.nodeIndices[e],i=u.tensorIndices[e];o(s,t,n,r,a,i)}for(t.push(u);n.indexOf(u)>=0;)n.splice(n.indexOf(u),1);i.push(u)},l=[],u=[];for(const e of this.outputs)o(e,l,u);const c=i.slice().reverse();for(const e of c){n[e.id]=e,e.id in t||(t[e.id]=0);let a=t[e.id];const i=null==s[e.outboundLayer.id]?0:s[e.outboundLayer.id];a=Math.max(a,i),s[e.outboundLayer.id]=a,r[e.outboundLayer.id]=e.outboundLayer,t[e.id]=a;for(let s=0;s<e.inboundLayers.length;s++){const r=e.inboundLayers[s],i=e.nodeIndices[s],o=r.inboundNodes[i],l=null==t[o.id]?0:t[o.id];t[o.id]=Math.max(a+1,l),n[o.id]=o}}const h={};for(const e in t){const s=t[e];s in h||(h[s]=[]),h[s].push(n[e])}const p={};for(const e in s){const t=s[e];t in p||(p[t]=[]),p[t].push(r[e])}let d=Object.keys(p).map(e=>parseInt(e,10)).sort(zd);this.layers=[];for(const e of d){const t=p[e];t.sort((e,t)=>{const n=a[e.id],s=a[t.id];return n<s?-1:n>s?1:0});for(const e of t)e instanceof Cg&&this.internalContainerRefs.push(e),this.layers.push(e)}this.layersByDepth=p,d=Object.keys(h).map(e=>parseInt(e,10)).sort(zd);const f=this.inputs.slice(),m=[];for(const e of d)for(const t of h[e]){const e=t.outboundLayer;if(null!=e){for(const n of t.inputTensors)if(-1===f.indexOf(n))throw new Id("Graph disconnected: cannot obtain value for tensor "+n+` at layer "${e.name}". The following previous layers were accessed without issue: `+m);for(const e of t.outputTensors)f.push(e);m.push(e.name)}}this.nodesByDepth=h;const g=this.layers.map(e=>e.name);for(const e of g){const t=g.filter(t=>t===e).length;if(1!==t)throw new Id(`The name "${e}" is used ${t} times in the model. All layer names should be unique. Layer names: `+JSON.stringify(g))}this.outboundNodes=[],this.inboundNodes=[],new Nm({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:this.inputs.map(e=>null),outputMasks:this.outputs.map(e=>null),inputShapes:this.inputs.map(e=>e.shape),outputShapes:this.outputs.map(e=>e.shape)}),this.built=!0,this._refCount=1}assertNotDisposed(){if(0===this._refCount)throw new Error(`Container '${this.name}' is already disposed.`)}dispose(){this.assertNotDisposed();const e={refCountAfterDispose:null,numDisposedVariables:0};if(0==--this._refCount){for(const t of this.layers)e.numDisposedVariables+=t.dispose().numDisposedVariables;for(const t of this.internalContainerRefs)e.numDisposedVariables+=t.dispose().numDisposedVariables}return e.refCountAfterDispose=this._refCount,e}get trainable(){return this.trainable_}set trainable(e){this.layers.forEach(t=>{t._trainableWeights.forEach(t=>t.trainable=e)}),this.trainable_=e}get trainableWeights(){if(this._trainableWeights.length>0)throw new Cd("Container instance unexpectedly contains _trainableWeights.The trainable weights of a Container are a union of the trainable weights of its consituent Layers. Its own _trainableWeights must remain an empty Array.");if(!this.trainable)return[];let e=[];for(const t of this.layers)e=e.concat(t.trainableWeights);return e}get nonTrainableWeights(){const e=[];for(const t of this.layers)e.push(...t.nonTrainableWeights);if(!this.trainable){const t=[];for(const e of this.layers)t.push(...e.trainableWeights);return t.concat(e)}return e}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}loadWeights(e,t=!0){const n={};let s=0;for(const e of this.layers)for(const t of e.weights){if(null!=n[t.originalName])throw new Cd("Duplicate weight name: "+t.originalName);n[t.originalName]=t,s++}const r=[];for(const s in e){let a=s;if(null==n[s]){const e=s.split("/");a=e.slice(0,-2).concat([e[e.length-1]]).join("/")}if(null!=n[a])r.push([n[a],e[s]]);else if(t)throw new Cd("Provided weight data has no target variable: "+s);delete n[a]}if(t){const e=[];for(const t in n)e.push(t);if(e.length>0)throw new Cd(`${e.length} of ${s} weights are not set: `+e)}xm(r)}updatedConfig(){const e=this.getConfig(),t={};return t.className=this.getClassName(),t.config=e,t.kerasVersion="tfjs-layers 3.2.0",t.backend="TensorFlow.js",t}toJSON(e,t=!0){const n=function e(t,n){if(null==t)return null;if("string"==typeof t)return Dd(t);if("number"==typeof t||"boolean"==typeof t)return t;if(t instanceof Array){const s=[],r=t.length;for(let a=0;a<r;++a){const r=t[a];mg(n,a,r)?s.push(r):s.push(e(r,n))}return s}{const n={};for(const s of Object.keys(t)){const r=t[s],a=Dd(s);n[a]="name"!==s&&"className"!==s||"string"!=typeof r?e(r,s):r}return n}}(this.updatedConfig());return t?JSON.stringify(n):n}call(e,t){return Za(()=>{e=Fd(e);const n=new bg;for(let t=0;t<this.inputs.length;++t)n.add(this.inputs[t],e[t]);return kg(this.outputs,n,t)})}computeMask(e,t){return Za(()=>{let n;return e=Fd(e),n=null==t?Ed(null,e.length):Fd(t),this.runInternalGraph(e,n)[1]})}computeOutputShape(e){const t=dm(e);if(t.length!==this.inputLayers.length)throw new Cd(`Invalid inputShape argument ${e}: model has ${this.inputLayers.length} tensor inputs.`);const n={};for(let e=0;e<t.length;e++){const s=this.inputLayers[e],r=t[e];n[s.name+"_0_0"]=r}const s=Object.keys(this.nodesByDepth).map(e=>parseInt(e,10)).sort(zd);if(s.length>1)for(const e of s){const t=this.nodesByDepth[e];for(const e of t){const t=e.outboundLayer;if(-1!==this.inputLayers.map(e=>e.id).indexOf(t.id))continue;const s=[];for(let t=0;t<e.inboundLayers.length;t++){const r=e.inboundLayers[t],a=e.nodeIndices[t],i=e.tensorIndices[t],o=n[`${r.name}_${a}_${i}`];s.push(o)}const r=dm(t.computeOutputShape(Rd(s))),a=t.inboundNodes.indexOf(e);for(let e=0;e<r.length;e++){n[`${t.name}_${a}_${e}`]=r[e]}}}const r=[],a=[];for(let e=0;e<this.outputLayers.length;e++){const t=this.outputLayers[e],n=this.outputLayersNodeIndices[e],s=this.outputLayersTensorIndices[e],r=`${t.name}_${n}_${s}`;a.push(r)}for(let e=0;e<a.length;e++){const t=a[e];$d(t in n),r.push(n[t])}return Rd(r)}runInternalGraph(e,t){null==t&&(t=Ed(null,e.length));const n={};for(let s=0;s<this.inputs.length;++s){const r=this.inputs[s],a=e[s],i=t[s];n[r.id]=[a,i]}const s=Object.keys(this.nodesByDepth).map(e=>parseInt(e,10)).sort(zd);for(const e of s){const t=this.nodesByDepth[e];for(const e of t){const t=e.outboundLayer,s=e.inputTensors,r=e.outputTensors,a=new Array;for(const e of s)e.id in n&&a.push(n[e.id]);if(a.length===s.length){let s,i,o,l,u={};if(null!=e.callArgs&&(u=e.callArgs),1===a.length){const[e,n]=a[0];null==u.mask&&(u.mask=n),o=Fd(t.call(e,u)),l=Fd(t.computeMask(e,n)),s=[e],i=[n]}else s=a.map(e=>e[0]),i=a.map(e=>e[1]),null==u.mask&&(u.mask=i),o=Fd(t.call(s,u)),l=Fd(t.computeMask(s,i));if(t.activityRegularizer)throw new Sd("LayersModel invocation with concrete Tensor value(s) in the presence of activity regularizer(s) is not supported yet.");for(let e=0;e<r.length;++e){const t=r[e],s=o[e],a=l[e];n[t.id]=[s,a]}}}}const r=[],a=[],i=[];for(const e of this.outputs){$d(e.id in n,`Could not compute output ${e.name} : ${e.id}`);const[t,s]=n[e.id];i.push(t.shape),r.push(t),a.push(s)}return[r,a,i]}buildNodeConversionMap(e){const t={};let n;for(const e of this.layers){n=e instanceof Cg?1:0;for(let s=0;s<e.inboundNodes.length;s++){const r=Cg.nodeKey(e,s);this.containerNodes.has(r)&&(t[r]=n,n+=1)}}return t}getLayer(e,t){if(null!=t){if(this.layers.length<=t)throw new Cd(`Was asked to retrieve layer at index ${t}, but model only has ${this.layers.length} layer(s).`);return this.layers[t]}if(null==e)throw new Cd("Provide either a layer name or layer index");for(const t of this.layers)if(t.name===e)return t;throw new Cd("No such layer: "+e)}calculateLosses(){return Za(()=>{const e=[];for(const t of this.layers)for(let n=0;n<t.inboundNodes.length;++n){const s=Cg.nodeKey(t,n);this.containerNodes.has(s)&&e.push(...t.calculateLosses())}return e})}getConfig(){const e={name:this.name},t=this.buildNodeConversionMap(this.layers),n=[];for(const e of this.layers){const s=e.getClassName(),r=e.getConfig(),a=[];for(let n=0;n<e.inboundNodes.length;n++){const s=e.inboundNodes[n],r=Cg.nodeKey(e,n);let i={};if(this.containerNodes.has(r)){if(s.callArgs)try{JSON.stringify(s.callArgs),i=s.callArgs}catch(t){console.warn(`Layer ${e.name} was passed non-serializable keyword arguments: `+s.callArgs+". They will not be included in the serialized model (and thus will be missing at deserialization time)."),i={}}if(s.inboundLayers.length>0){const e=[];for(let n=0;n<s.inboundLayers.length;n++){const r=s.inboundLayers[n],a=s.nodeIndices[n],o=s.tensorIndices[n];let l=t[Cg.nodeKey(r,a)];null==l&&(l=0),e.push([r.name,l,o,i])}a.push(e)}}}const i={};i.name=e.name,i.className=s,i.config=r,i.inboundNodes=a,n.push(i)}e.layers=n;const s=[];for(let e=0;e<this.inputLayers.length;e++){const n=this.inputLayers[e],r=this.inputLayersNodeIndices[e],a=Cg.nodeKey(n,r);if(!this.containerNodes.has(a))continue;let i=t[a];null==i&&(i=0);const o=this.inputLayersTensorIndices[e];s.push([n.name,i,o])}e.inputLayers=s;const r=[];for(let e=0;e<this.outputLayers.length;e++){const n=this.outputLayers[e],s=this.outputLayersNodeIndices[e],a=Cg.nodeKey(n,s);if(!this.containerNodes.has(a))continue;let i=t[a];null==i&&(i=0);const o=this.outputLayersTensorIndices[e];r.push([n.name,i,o])}return e.outputLayers=r,e}static fromConfig(e,t,n={},s=!1){const r={},a={};function i(e,t){e.name in a?a[e.name].push(t):a[e.name]=[t]}function o(e,t){const n=[];let s;for(const a of t){const o=a[0],l=a[1],u=a[2];if(s=null==a[3]?{}:a[3],!(o in r))return void i(e,t);const c=r[o];if(c.inboundNodes.length<=l)return void i(e,t);const h=c.inboundNodes[l];n.push(h.outputTensors[u])}n.length>0&&e.apply(Rd(n),s)}function l(e){const n=e.name,a=Bm(e,null!=t.customObjects?t.customObjects:{});a.setFastWeightInitDuringBuild(s),r[n]=a,e.inboundNodes.forEach(e=>{if(!(e instanceof Array))throw new Cd("Corrupted configuration, expected array for nodeData: "+e);i(a,e)})}const u=t.name,c=t.layers;for(const e of c)l(e);for(;!Pd(a);)for(const e of c){const t=r[e.name];if(t.name in a){const e=a[t.name];delete a[t.name];for(const n of e)o(t,n)}}const h=[],p=[],d=t.inputLayers;for(const e of d){const t=e[0],n=e[1],s=e[2];$d(t in r);const a=r[t].inboundNodes[n].outputTensors;h.push(a[s])}const f=t.outputLayers;for(const e of f){const t=e[0],n=e[1],s=e[2];$d(t in r);const a=r[t].inboundNodes[n].outputTensors;p.push(a[s])}return new e({inputs:h,outputs:p,name:u})}get stateful(){if(this._stateful)throw new Cd("Container instance unexpectedly has _stateful = true. The statefulness of a Container is determined by the Layers it contains. Its _stateful property must remain the default false.");for(const e of this.layers)if(e.stateful)return!0;return!1}resetStates(){Za(()=>{this.layers.forEach(e=>{e.stateful&&e.resetStates()})})}}function Sg(e,t,n){const s=t.length;if(null==e||Array.isArray(e)&&0===e.length)return t.map(e=>null);if(1===s)return Array.isArray(e)&&1===e.length?e:"object"==typeof e&&t[0]in e?[e[t[0]]]:[e];if(Array.isArray(e)){if(e.length!==s)throw new Error(`Provided ${n} is an array of ${e.length} element(s), but the model has ${s} outputs. Make sure a set of weights is provided for each model output.`);return e}if("object"==typeof e&&Object.keys(e).length>0&&"object"==typeof e[Object.keys(e)[0]]){const n=[];return t.forEach(t=>{t in e?n.push(e[t]):n.push(null)}),n}throw new Error(`The model has multiple (${s}) outputs, so ${n} must be either an array with ${s} elements or an object with ${t} keys. Provided ${n} not understood: ${JSON.stringify(e)}`)}function Tg(e,t){return Sg(e,t,"classWeight")}async function Eg(e,t,n,s){if(null!=t||null!=s)throw new Error("Support sampleWeight is not implemented yet");if(null!=n){const t=Za(()=>{if(1===e.shape.length)return e.clone();if(2===e.shape.length){if(e.shape[1]>1){const t=1;return e.argMax(t)}if(1===e.shape[1])return e.reshape([e.shape[0]]);throw new Error(`Encountered unexpected last-dimension size (${e.shape[1]}) during handling of class weights. The size is expected to be >= 1.`)}throw new Error(`Unexpected rank of target (y) tensor (${e.rank}) during handling of class weights. The rank is expected to be 1 or 2.`)}),s=Array.from(await t.data());Qa(t);const r=[];return s.forEach(e=>{if(null==n[e])throw new Error(`classWeight must contain all classes in the training data. The class ${e} exists in the data but not in classWeight`);r.push(n[e])}),ec(r,"float32")}return null}function $g(e,t){return fi(e,t)}function Ag(e,t){let n,s;const r=t;n=r.xs,s=r.ys,o(null!=n&&null!=s,()=>"A Dataset iterator for fitDataset() is expected to generate objects of the form `{xs: xVal, ys: yVal}`, where the two values may be `tf.Tensor`, an array of Tensors, or a map of string to Tensor.  The provided Dataset instead generates "+t);const a=Rg("input",e.inputNames,n),i=Rg("output",e.outputNames,s),l=a[0].shape[0];o(a.length===e.inputs.length,()=>`LayersModel has ${e.inputs.length} inputs, but the dataset provides ${a.length} inputs.  (Expected input keys: `+JSON.stringify(e.inputNames)+")"),o(i.length===e.outputs.length,()=>`LayersModel has ${e.outputs.length} outputs, but the dataset provides ${i.length} outputs.  (Expected output keys: `+JSON.stringify(e.outputNames)+")");for(let t=0;t<a.length;t++)o(a[t].shape[0]===l,()=>`Batch size mismatch: input ${e.inputNames[t]} has ${a[t].shape[0]}; expected  ${l} based on input ${e.inputNames[0]}.`);for(let t=0;t<i.length;t++)o(i[t].shape[0]===l,()=>`Batch size mismatch: output ${e.outputNames[t]} has ${i[t].shape[0]}; expected  ${l} based on input ${e.inputNames[0]}.`);return{xs:a,ys:i}}function Rg(e,t,n){if(n instanceof ws)return[n];if(Array.isArray(n))return o(n.length===t.length,()=>`Received an array of ${n.length} Tensors, but expected ${t.length} to match the ${e} keys ${t}.`),n;{const s=[];for(const r of t){if(null==n[r])throw new Cd(`The feature data generated by the dataset lacks the required ${e} key '${r}'.`);s.push(n[r])}return s}}async function Fg(e,t,n){const s=null!=n.batchesPerEpoch;if(o(null!=e.optimizer,()=>"You must compile a model before training/testing. Use LayersModel.compile(modelCompileConfig)."),o(null!=n,()=>"For fitDataset(), the 2nd argument (config) is required, but it is not provided in this call."),o(null!=n.epochs&&n.epochs>0&&Number.isInteger(n.epochs),()=>"For fitDataset(), config.epochs is expected to be a positive integer, but got "+n.epochs),o(!s||n.batchesPerEpoch>0&&Number.isInteger(n.batchesPerEpoch),()=>"For fitDataset(), config.batchesPerEpoch is expected to be a positive integer if specified, but got "+n.batchesPerEpoch),o(null==n.validationSplit,()=>"`validationSplit` is not supported by `fitDataset()`. Use validationData instead."),e.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");e.isTraining=!0;try{const r=null!=n.validationData;let a,i;if(r)if(Dg(n.validationData))o(null==n.validationBatches||n.validationBatches>0&&Number.isInteger(n.validationBatches),()=>"For fitDataset() with dataset-based validation, config.validationBatches is expected not to be provided, or to be a positive integer, but got "+n.validationBatches);else{const e=function(e){if(3===e.length)throw new Sd("Validation with sample weights is not implemented yet.");return{xs:e[0],ys:e[1]}}(n.validationData);a=e.xs,i=e.ys}const l=e.makeTrainFunction(),u=e.getDedupedMetricsNames();let c;c=r?u.slice().concat(u.map(e=>"val_"+e)):u.slice();const h=Mm(n.callbacks,n.yieldEvery),p=null==n.verbose?1:n.verbose,{callbackList:d,history:f}=zm(h,p,n.epochs,null,null,function(e,t){let n=null;null!=t.batchesPerEpoch?n=t.batchesPerEpoch:Number.isFinite(e.size)&&(n=e.size);return n}(t,n),null,r,c);d.setModel(e),e.history=f,await d.onTrainBegin(),e.stopTraining_=!1;let m=null==n.initialEpoch?0:n.initialEpoch,g=await t.iterator();for(;m<n.epochs;){const o={};await d.onEpochBegin(m);let c=0,h=0;for(s||(g=await t.iterator());!s||c<n.batchesPerEpoch;){const t=await g.next();if(s&&t.done){console.warn("You provided `batchesPerEpoch` as "+n.batchesPerEpoch+", but your dataset iterator ran out of data after "+c+" batches; interrupting training. Make sure that your dataset can generate at least `batchesPerEpoch * epochs` batches (in this case, "+n.batchesPerEpoch*n.epochs+" batches). You may need to use the repeat() function when building your dataset.");break}if(null!=t.value){const{xs:s,ys:r}=Ag(e,t.value),a={};a.batch=h,a.size=s[0].shape[0],await d.onBatchBegin(h,a);const i=[];if(null!=n.classWeight){const t=Tg(n.classWeight,e.outputNames);for(let e=0;e<t.length;++e)i.push(await Eg(r[e],null,t[e]))}const o=s.concat(r).concat(i),p=l(o);Qa(o);for(let e=0;e<u.length;++e){const t=u[e],n=p[e];a[t]=n,ei(n)}await d.onBatchEnd(h,a),$m(a),h++,c++}if(s?c>=n.batchesPerEpoch:t.done){if(r){let t;t=Dg(n.validationData)?Fd(await e.evaluateDataset(n.validationData,{batches:n.validationBatches})):Fd(e.evaluate(a,i,{batchSize:null==n.validationBatchSize?32:n.validationBatchSize,verbose:0}));for(let n=0;n<e.metricsNames.length;++n)o["val_"+e.metricsNames[n]]=t[n]}break}if(e.stopTraining_)break}if(await d.onEpochEnd(m,o),m++,e.stopTraining_)break}return await d.onTrainEnd(),await e.history.syncData(),e.history}finally{e.isTraining=!1}}function Dg(e){return"function"==typeof e.iterator}function _g(e){o(e>0&&Number.isInteger(e),()=>"batchSize is required to be a positive integer, but got "+e)}function Og(e,t,n){return null==e?[null]:Array.isArray(e)?e.map(e=>Cf(e,t,n-t)):Cf(e,t,n-t)}function Mg(e,t){return Za(()=>null==e?null:Array.isArray(e)?e.map(e=>Mg(e,t)):Df(e,"int32"===t.dtype?t:t.toInt()))}function Lg(e,t){const n=[];let s=0,r=null;for(;s<e;)r=s+t,r>=e&&(r=e),n.push([s,r]),s=r;return n}async function zg(e,t,n,r={}){if(e.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");let a,i,o,l,u,c,h;e.isTraining=!0;try{const p=null==r.batchSize?32:r.batchSize;_g(p);const d=!1,f=await e.standardizeUserData(t,n,r.sampleWeight,r.classWeight,d,p);a=f[0],i=f[1],h=f[2];let m,g=!1;if(null!=r.validationData&&r.validationData.length>0){if(g=!0,2!==r.validationData.length)throw 3===r.validationData.length?new Sd("validationData including sample weights is not supported yet."):new Cd("When passing validation data, it must contain 2 (valX, valY) or 3 (valX, valY, valSampleWeight) items; "+r.validationData+" is invalid.");o=r.validationData[0],l=r.validationData[1];const t=!0,n=await e.standardizeUserData(o,l,null,null,t,p);u=n[0],c=n[1],m=u.concat(c)}else if(null!=r.validationSplit&&r.validationSplit>0&&r.validationSplit<1){g=!0;const e=Math.floor(a[0].shape[0]*(1-r.validationSplit)),t=a[0].shape[0];u=Og(a,e,t),a=Og(a,0,e),c=Og(i,e,t),i=Og(i,0,e),m=u.concat(c)}else null!=r.validationSteps&&(g=!0);const y=a.concat(i).concat(h);e.checkTrainableWeightsConsistency();const b=e.makeTrainFunction(),x=e.getDedupedMetricsNames();let w,k;g?(e.makeTestFunction(),w=e.testFunction,k=x.slice().concat(x.map(e=>"val_"+e))):(w=null,m=[],k=x.slice());const v=Mm(r.callbacks,r.yieldEvery);return await async function(e,t,n,r,a,i,o,l,u,c,h,p,d,f,m){null==a&&(a=32),null==i&&(i=1),null==h&&(h=!0),null==d&&(d=0);let g=!1;if(null!=u&&null!=c&&(g=!0),null!=m&&(g=!0,null==f))throw new Cd("Can only use `validationSteps` when doing step-wise training, i.e., `stepsPerEpoch` must be set.");const y=e.checkNumSamples(n,a,f,"steps_per_epoch");let b;null!=y&&(b=vf(0,y)),null==o&&(o=1);const{callbackList:x,history:w}=zm(l,o,i,d,y,f,a,g,p);x.setModel(e),e.history=w,await x.onTrainBegin(),e.stopTraining_=!1;for(let o=d;o<i;++o){await x.onEpochBegin(o);const i={};if(null!=f)throw new Sd("stepsPerEpoch mode is not implemented yet.");{if("batch"===h)throw new Sd("batch shuffling is not implemneted yet");h&&s(b);const o=ec(b),l=Lg(y,a);for(let s=0;s<l.length;++s){const h={};if(await x.onBatchBegin(s,h),Za(()=>{const p=l[s][0],d=l[s][1],f=Cf(o,p,d-p);h.batch=s,h.size=d-p;const m=Mg(n,f),y=t(m);for(let e=0;e<r.length;++e){const t=r[e],n=y[e];h[t]=n,ei(n)}if(s===l.length-1&&g){const t=e.testLoop(u,c,a);for(let e=0;e<r.length;++e){const n=r[e],s=t[e];ei(s),i["val_"+n]=s}}}),await x.onBatchEnd(s,h),$m(h),e.stopTraining_)break}o.dispose()}if(await x.onEpochEnd(o,i),e.stopTraining_)break}return await x.onTrainEnd(),await e.history.syncData(),e.history}(e,b,y,x,p,r.epochs,r.verbose,v,w,m,r.shuffle,k,r.initialEpoch,null,null)}finally{e.isTraining=!1,Pg(a,t),Pg(i,n),Pg(u,o),Pg(c,l),null!=h&&Qa(h)}}function Bg(e){const t=[];e instanceof ws&&(e=[e]);for(let n=0;n<e.length;++n){const s=e[n];if(1===s.rank)t.push(If(s,1));else{if(0===s.rank)throw new Error("Expected tensor to be at least 1D, but received a 0D tensor (scalar).");t.push(s)}}return t}function Pg(e,t){if(null==e)return;const n=[];if(t instanceof ws)n.push(t.id);else if(Array.isArray(t))t.forEach(e=>n.push(e.id));else if(null!=t)for(const e in t){const s=t[e];n.push(s.id)}const s=[];if(e instanceof ws)-1===n.indexOf(e.id)&&s.push(e);else if(Array.isArray(e))e.forEach(e=>{-1===n.indexOf(e.id)&&s.push(e)});else if(null!=e)for(const t in e){const r=e[t];-1===n.indexOf(r.id)&&s.push(r)}s.forEach(e=>{e.isDisposed||e.dispose()})}function Wg(e){return Array.isArray(e)}function Vg(e){return!function(e){return e instanceof ws}(e)&&!Wg(e)}function Ug(e,t,n,s=!0,r=""){if(null==t||0===t.length){if(null!=e){let t=!1;if(Wg(e)&&e.length>0)t=!0;else if(Vg(e)){for(const n in e)if(e.hasOwnProperty(n)){t=!0;break}}else t=!0;if(t)throw new Cd(`Error when checking model ${r} expected no data, but got `+e)}return[]}if(null==e)return t.map(e=>null);let a;if(Vg(e)){e=e,a=[];for(const n of t){if(null==e[n])throw new Cd(`No data provided for "${n}". Need data for each key in: `+t);a.push(e[n])}}else if(Wg(e)){if((e=e).length!==t.length)throw new Cd(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the model expected. Expected to see ${t.length} Tensor(s), but instead got the following list of Tensor(s): `+e);a=e}else{if(e=e,t.length>1)throw new Cd(`The model ${r} expects ${t.length} Tensor(s), but only received one Tensor. Found: Tensor with shape `+e.shape);a=[e]}if(a=Bg(a),null!=n)for(let e=0;e<t.length;++e){if(null==n[e])continue;const i=a[e];if(i.shape.length!==n[e].length)throw new Cd(`Error when checking ${r}: expected ${t[e]} to have ${n[e].length} dimension(s). but got array with shape `+i.shape);for(let a=0;a<n[e].length;++a){if(0===a&&!s)continue;const o=i.shape[a],l=n[e][a];if(null!=l&&l>=0&&o!==l)throw new Cd(`Error when checking ${r}: expected ${t[e]} to have shape [${n[e]}], but got array with shape [${i.shape}].`)}}return a}function Gg(e,t,n,s=!0,r=""){let a;if(Array.isArray(e)){if(e.length!==t.length)throw new Cd(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the the model expected. Expected to see ${t.length} Tensor(s), but instead got ${e.length} Tensors(s).`);a=e}else{if(t.length>1)throw new Cd(`The model expects ${t.length} ${r} Tensors, but only received one Tensor. Found: array with shape `+JSON.stringify(e.shape)+".");a=[e]}if(null!=n)for(let e=0;e<t.length;++e){if(null==n[e])continue;const i=a[e];if(i.shape.length!==n[e].length)throw new Cd(`Error when checking ${r}: expected ${t[e]} to have ${n[e].length} dimension(s), but got array with shape `+JSON.stringify(i.shape));for(let a=0;a<n[e].length;++a){if(0===a&&!s)continue;const o=i.shape[a],l=n[e][a];if(null!=l&&l!==o)throw new Cd(`Error when checking ${r}: expected ${t[e]} to have shape ${JSON.stringify(n[e])} but got array with shape ${JSON.stringify(i.shape)}.`)}}}class Hg extends Cg{constructor(e){super(e),this.isTraining=!1}summary(e,t,n=console.log){if(!this.built)throw new Cd("This model has never been called, thus its weights have not been created yet. So no summary can be displayed. Build the model first (e.g., by calling it on some test data).");hg(this,e,t,n)}compile(e){if(null==e.loss&&(e.loss=[]),this.loss=e.loss,"string"==typeof e.optimizer)this.optimizer_=function(e){const t={Adagrad:()=>Dh.adagrad(.01),Adadelta:()=>Dh.adadelta(1,.95,vd()),Adam:()=>Dh.adam(.001,.9,.999,vd()),Adamax:()=>Dh.adamax(.002,.9,.999,vd(),0),RMSProp:()=>Dh.rmsprop(.001,.9,0,vd()),SGD:()=>Dh.sgd(.01)};if(t.adagrad=t.Adagrad,t.adadelta=t.Adadelta,t.adam=t.Adam,t.adamax=t.Adamax,t.rmsprop=t.RMSProp,t.sgd=t.SGD,e in t)return t[e]();throw new Cd("Unknown Optimizer "+e)}(e.optimizer),this.isOptimizerOwned=!0;else{if(!(e.optimizer instanceof Ih))throw new Cd("User-defined optimizer must be an instance of tf.Optimizer.");this.optimizer_=e.optimizer,this.isOptimizerOwned=!1}let t=[];if(Array.isArray(e.loss)||"string"==typeof e.loss||"function"==typeof e.loss)if(Array.isArray(e.loss)){if(e.loss.length!==this.outputs.length)throw new Cd(`When passing an Array as loss, it should have one entry per model output. The model has ${this.outputs.length} output(s), but you passed loss=${e.loss}.`);const n=e.loss;t=n.map(e=>Jm(e))}else{const n=Jm(e.loss);this.outputs.forEach(e=>{t.push(n)})}else{e.loss=e.loss;for(const t in e.loss)if(-1===this.outputNames.indexOf(t))throw new Cd(`Unknown entry in loss dictionary: "${t}". Only expected the following keys: `+this.outputNames);for(const n of this.outputNames)null==e.loss[n]&&console.warn(`Output "${n}" is missing from loss dictionary. We assume this was done on purpose, and we will not be expecting data to be passed to ${n} during training`),t.push(Jm(e.loss[n]))}this.lossFunctions=t,this.feedOutputNames=[],this.feedOutputShapes=[],this.feedLossFns=[];for(let e=0;e<this.outputs.length;++e){const t=this.internalOutputShapes[e],n=this.outputNames[e];this.feedOutputNames.push(n),this.feedOutputShapes.push(t),this.feedLossFns.push(this.lossFunctions[e])}const n=[];this.metrics=e.metrics,this.metricsNames=["loss"],this.metricsTensors=[],df("loss",()=>{for(let e=0;e<this.outputs.length;++e){if(-1!==n.indexOf(e))continue;const t=this.lossFunctions[e];this.outputs.length>1&&(this.metricsTensors.push([t,e]),this.metricsNames.push(this.outputNames[e]+"_loss"))}});const s=function(e,t){if(null==e||Array.isArray(e)&&0===e.length)return t.map(e=>[]);let n;if("string"==typeof e||"function"==typeof e)n=[e];else{if(!Array.isArray(e)&&"object"!=typeof e)throw new TypeError("Type of metrics argument not understood. Expected an string,function, Array, or Object, found: "+e);n=e}if(Array.isArray(n))return t.map(e=>n);{const e=[];for(const s of t){let t=n.hasOwnProperty(s)?n[s]:[];Array.isArray(t)||(t=[t]),e.push(t)}return e}}(e.metrics,this.outputNames),r=(e,t,n)=>{this.outputNames.length>1&&(t=this.outputNames[e]+"_"+t),this.metricsNames.push(t),this.metricsTensors.push([n,e])};df("metric",()=>{for(let e=0;e<this.outputs.length;++e){if(-1!==n.indexOf(e))continue;(t=>{let n,s,a;for(const i of t){if("string"==typeof i&&-1!==["accuracy","acc","crossentropy","ce"].indexOf(i)){const t=this.internalOutputShapes[e];let r;1===t[t.length-1]||this.lossFunctions[e]===qm?-1!==["accuracy","acc"].indexOf(i)?s=Zm:-1!==["crossentropy","ce"].indexOf(i)&&(s=sg):this.lossFunctions[e]===jm?-1!==["accuracy","acc"].indexOf(i)?s=rg:-1!==["crossentropy","ce"].indexOf(i)&&(s=ig):-1!==["accuracy","acc"].indexOf(i)?s=Qm:-1!==["crossentropy","ce"].indexOf(i)&&(s=ag),-1!==["accuracy","acc"].indexOf(i)?r="acc":-1!==["crossentropy","ce"].indexOf(i)&&(r="ce"),a=s,n=""+r}else{const e=lg(i);a=e,n=""+ug(i)}let t;df(n,()=>{t=a}),r(e,n,t)}})(s[e])}}),this.collectedTrainableWeights=this.trainableWeights}checkTrainableWeightsConsistency(){null!=this.collectedTrainableWeights&&this.trainableWeights.length!==this.collectedTrainableWeights.length&&console.warn("Discrepancy between trainableweights and collected trainable weights. Did you set `model.trainable` without calling `model.compile()` afterwards?")}evaluate(e,t,n={}){const s=null==n.batchSize?32:n.batchSize;_g(s);const r=this.standardizeUserDataXY(e,t,!0,s);try{const a=r[0].concat(r[1]);this.makeTestFunction();const i=this.testFunction;return Rd(this.testLoop(i,a,s,n.verbose,n.steps))}finally{Pg(r[0],e),Pg(r[1],t)}}async evaluateDataset(e,t){return this.makeTestFunction(),async function(e,t,n){const s=null!=(n=n||{}).batches,r=e.testFunction;let a=[];if(n.verbose>0)throw new Sd("Verbose mode is not implemented yet.");o(!s||n.batches>0&&Number.isInteger(n.batches),()=>"Test loop expects `batches` to be a positive integer, but received "+JSON.stringify(n.batches));const i="function"==typeof t.next?t:await t.iterator();let l=0,u=0;for(;!s||u<n.batches;){const t=await i.next();if(a=Za(()=>{if(t.value){const{xs:n,ys:s}=Ag(e,t.value),i=n.concat(s),o=Za(()=>r(i));if(Qa(i),0===u)for(let e=0;e<o.length;++e)a.push(Au(0));const c=i[0].shape[0];for(let e=0;e<o.length;++e){const t=o[e],n=a[e];a[e]=Za(()=>hi(a[e],fi(c,t))),u>0&&Qa(n)}Qa(o),l+=c,++u}return a}),t.done){s&&console.warn(`Your dataset iterator ran out of data during evaluateDataset(). Interrupting evalution. Make sure that your dataset can generate at least \`batches\` batches (in this case, ${n.batches} batches). You may need to use the repeat() function when building your dataset.`);break}}for(let e=0;e<a.length;++e){const t=a[e];a[e]=di(a[e],l),Qa(t)}return Rd(a)}(this,e,t)}checkNumSamples(e,t,n,s="steps"){let r;if(null!=n){if(r=null,null!=t)throw new Cd(`If ${s} is set, batchSize must be null or undefined.Got batchSize = `+t)}else{if(null==e)throw new Cd("Either the input data should have a defined shape, or "+s+" shoud be specified.");r=Array.isArray(e)?e[0].shape[0]:e.shape[0]}return r}execute(e,t){if(Array.isArray(t)&&0===t.length)throw new Cd("`outputs` is an empty Array, which is not allowed.");const n=Array.isArray(t),s=n?t:[t],r=this.retrieveSymbolicTensors(s),a=new bg;if(e instanceof ws&&(e=[e]),Array.isArray(e)){if(e.length!==this.inputs.length)throw new Cd(`The number of inputs provided (${e.length}) does not match the number of inputs of this model (${this.inputs.length}).`);for(let t=0;t<this.inputs.length;++t)a.add(this.inputs[t],e[t])}else for(const t of this.inputs){const n=e[t.name];if(null==n)throw new Cd("No value is provided for the model's input "+t.name);a.add(t,n)}const i=kg(r,a);return n?i:i[0]}retrieveSymbolicTensors(e){const t=Ed(null,e.length);let n=e.length;for(const s of this.layers){const r=Array.isArray(s.output)?s.output:[s.output],a=r.map(e=>e.name);for(let s=0;s<e.length;++s){const i=a.indexOf(e[s]);if(-1!==i&&(t[s]=r[i],n--),0===n)break}if(0===n)break}if(n>0){const n=[];throw t.forEach((t,s)=>{null==t&&n.push(e[s])}),new Cd("Cannot find SymbolicTensors for output name(s): "+JSON.stringify(n))}return t}predictLoop(e,t=32,n=!1){return Za(()=>{const s=this.checkNumSamples(e);if(n)throw new Sd("Verbose predictLoop() is not implemented yet.");const r=Lg(s,t),a=this.outputs.map(e=>[]);for(let t=0;t<r.length;++t){Za(()=>{const n=r[t][0],s=r[t][1],a=Og(e,n,s),i=[];if(Array.isArray(a))for(let e=0;e<a.length;++e)i.push({key:this.inputs[e],value:a[e]});else i.push({key:this.inputs[0],value:a});const o=new bg(i);return kg(this.outputs,o)}).forEach((e,t)=>a[t].push(e))}return Rd(a.map(e=>Gi(e,0)))})}predict(e,t={}){const n=Bg(e);Gg(n,this.inputNames,this.feedInputShapes,!1);try{const s=null==t.batchSize?32:t.batchSize;return _g(s),this.predictLoop(n,s)}finally{Pg(n,e)}}predictOnBatch(e){Gg(e,this.inputNames,this.feedInputShapes,!0);const t=(Array.isArray(e)?e[0]:e).shape[0];return this.predictLoop(e,t)}standardizeUserDataXY(e,t,n=!0,s){if(null==this.optimizer_)throw new Id("You must compile a model before training/testing. Use LayersModel.compile(modelCompileArgs).");const r=[];for(let e=0;e<this.feedOutputShapes.length;++e){const t=this.feedOutputShapes[e];this.feedLossFns[e]===jm?r.push(t.slice(0,t.length-1).concat([1])):r.push(t)}if(function(e,t,n){const s=Bd(e.map(e=>e.shape[0]));s.sort();const r=Bd(t.map(e=>e.shape[0]));if(r.sort(),s.length>1)throw new Cd("All input Tensors (x) should have the same number of samples. Got array shapes: "+JSON.stringify(e.map(e=>e.shape)));if(r.length>1)throw new Cd("All target Tensors (y) should have the same number of samples. Got array shapes: "+JSON.stringify(t.map(e=>e.shape)));if(s.length>0&&r.length>0&&!p(s,r))throw new Cd(`Input Tensors should have the same number of samples as target Tensors. Found ${s[0]} input sample(s) and ${r[0]} target sample(s).`)}(e=Ug(e,this.feedInputNames,this.feedInputShapes,!1,"input"),t=Ug(t,this.feedOutputNames,r,!1,"target")),function(e,t,n){const s=[Wm,qm,Hm];for(let r=0;r<e.length;++r){const a=e[r],i=t[r],o=n[r];if(null!=i){if(i===Hm&&1===a.shape[a.shape.length-1])throw new Cd(`You are passing a target array of shape ${a.shape} while using a loss 'categorical_crossentropy'. 'categorical_crossentropy'expects targets to be binary matrices (1s and 0s) of shape [samples, classes].`);if(-1!==s.indexOf(i)){const e=a.shape.slice(1),t=o.slice(1);for(let n=0;n<e.length;++n){const s=e[n],r=t[n];if(null!=r&&s!==r)throw new Cd(`A target Tensor with shape ${a.shape} was passed for an output of shape ${o}, while using a loss function that expects targets to have the same shape as the output.`)}}}}}(t,this.feedLossFns,this.feedOutputShapes),this.stateful&&null!=s&&s>0&&e[0].shape[0]%s!=0)throw new Cd(`In a stateful network, you should only pass inputs with a number of samples that is divisible by the batch size ${s}. Found: ${e[0].shape[0]} sample(s).`);return[e,t]}async standardizeUserData(e,t,n,s,r=!0,a){const[i,o]=this.standardizeUserDataXY(e,t,r,a);if(null!=n)throw new Error("sample weight is not supported yet.");let l=null;if(null!=s){const e=Tg(s,this.outputNames);l=[];for(let t=0;t<e.length;++t)l.push(await Eg(o[t],null,e[t]))}return[i,o,l]}testLoop(e,t,n,s=0,r){return Za(()=>{const a=this.checkNumSamples(t,n,r,"steps"),i=[];if(s>0)throw new Sd("Verbose mode is not implemented yet.");if(null!=r)throw new Sd("steps mode in testLoop() is not implemented yet");{const s=Lg(a,n),r=ec(vf(0,a));for(let n=0;n<s.length;++n){const a=s[n][0],o=s[n][1],l=Cf(r,a,o-a),u=Mg(t,l),c=e(u);if(0===n)for(let e=0;e<c.length;++e)i.push(Au(0));for(let e=0;e<c.length;++e){const t=c[e];i[e]=hi(i[e],fi(o-a,t))}}for(let e=0;e<i.length;++e)i[e]=di(i[e],a)}return i})}getDedupedMetricsNames(){const e=this.metricsNames,t=[];for(let n=0;n<e.length;++n){const s=e[n];let r=s;if(Ad(e,s)>1){r+="_"+Ad(e.slice(0,n),s)}t.push(r)}return t}makeTrainFunction(){return e=>{const t=[],n=e.slice(0,this.inputs.length),s=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),r=e.slice(this.inputs.length+this.outputs.length,this.inputs.length+2*this.outputs.length),a=[],i=this.collectedTrainableWeights.map(e=>e.read());return[this.optimizer_.minimize(()=>{const e=[];for(let t=0;t<this.inputs.length;++t)e.push({key:this.inputs[t],value:n[t]});const i=new bg(e),o=kg(this.outputs,i,{training:!0});let l;for(let e=0;e<this.lossFunctions.length;++e){let n=(0,this.lossFunctions[e])(s[e],o[e]);null!=r[e]&&(n=$g(n,r[e]));const a=Fl(n);t.push(a),l=0===e?n:hi(l,n)}for(let e=0;e<this.metricsTensors.length;++e){let n;if(this.outputs.length>1&&e<this.outputs.length)n=t[e];else{const t=this.metricsTensors[e][0],r=this.metricsTensors[e][1];n=Fl(t(s[r],o[r]))}ei(n),a.push(n)}return l=Fl(l),this.calculateLosses().forEach(e=>{l=hi(l,e)}),l},!0,i)].concat(a)}}makeTestFunction(){this.testFunction=e=>Za(()=>{const t=[];let n;const s=e.slice(0,this.inputs.length),r=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),a=[];for(let e=0;e<this.inputs.length;++e)a.push({key:this.inputs[e],value:s[e]});const i=new bg(a),o=kg(this.outputs,i);for(let e=0;e<this.lossFunctions.length;++e){const s=this.lossFunctions[e],a=Fl(s(r[e],o[e]));n=0===e?a:hi(n,a),t.push(n)}for(let e=0;e<this.metricsTensors.length;++e){const n=this.metricsTensors[e][0],s=this.metricsTensors[e][1],a=Fl(n(r[s],o[s]));t.push(a)}return t})}async fit(e,t,n={}){return zg(this,e,t,n)}async fitDataset(e,t){return Fg(this,e,t)}async trainOnBatch(e,t){const n=await this.standardizeUserData(e,t),s=n[0],r=n[1],a=this.makeTrainFunction()(s.concat(r)),i=[];for(const e of a){const t=await e.data();i.push(t[0])}return Qa(a),Rd(i)}getNamedWeights(e){const t=[],n=null!=e&&e.trainableOnly,s=n?this.trainableWeights:this.weights,r=this.getWeights(n);for(let e=0;e<s.length;++e)n&&!s[e].trainable||t.push({name:s[e].originalName,tensor:r[e]});return t}set stopTraining(e){this.stopTraining_=e}get stopTraining(){return this.stopTraining_}get optimizer(){return this.optimizer_}set optimizer(e){this.optimizer_!==e&&(this.optimizer_=e,this.isOptimizerOwned=!1)}dispose(){const e=super.dispose();if(0===e.refCountAfterDispose&&null!=this.optimizer&&this.isOptimizerOwned){const t=Ya().numTensors;this.optimizer_.dispose(),e.numDisposedVariables+=t-Ya().numTensors}return e}getLossIdentifiers(){let e;if("string"==typeof this.loss)e=Dd(this.loss);else if(Array.isArray(this.loss)){for(const e of this.loss)if("string"!=typeof e)throw new Error("Serialization of non-string loss is not supported.");e=this.loss.map(e=>Dd(e))}else{const t=Object.keys(this.loss);e={};const n=this.loss;for(const s of t){if("string"!=typeof n[s])throw new Error("Serialization of non-string loss is not supported.");e[s]=Dd(n[s])}}return e}getMetricIdentifiers(){if("string"==typeof this.metrics||"function"==typeof this.metrics)return[Dd(ug(this.metrics))];if(Array.isArray(this.metrics))return this.metrics.map(e=>Dd(ug(e)));{const e={};for(const t in this.metrics)e[t]=Dd(ug(this.metrics[t]));return e}}getTrainingConfig(){return{loss:this.getLossIdentifiers(),metrics:this.getMetricIdentifiers(),optimizer_config:{class_name:this.optimizer.getClassName(),config:this.optimizer.getConfig()}}}loadTrainingConfig(e){if(null!=e.weighted_metrics)throw new Error("Loading weight_metrics is not supported yet.");if(null!=e.loss_weights)throw new Error("Loading loss_weights is not supported yet.");if(null!=e.sample_weight_mode)throw new Error("Loading sample_weight_mode is not supported yet.");const t=Bm(gg(e.optimizer_config));let n,s;if("string"==typeof e.loss)n=_d(e.loss);else if(Array.isArray(e.loss))n=e.loss.map(e=>_d(e));else if(null!=e.loss){n={};for(const t in e.loss)n[t]=_d(e.loss[t])}if(Array.isArray(e.metrics))s=e.metrics.map(e=>_d(e));else if(null!=e.metrics){s={};for(const t in e.metrics)s[t]=_d(e.metrics[t])}this.compile({loss:n,metrics:s,optimizer:t})}async save(e,t){if("string"==typeof e){const t=pr(e);if(0===t.length)throw new Cd(`Cannot find any save handlers for URL '${e}'`);if(t.length>1)throw new Cd(`Found more than one (${t.length}) save handlers for URL '${e}'`);e=t[0]}if(null==e.save)throw new Cd("LayersModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");const n=await nr(this.getNamedWeights(t)),s={modelTopology:this.toJSON(null,!1),format:"layers-model",generatedBy:"TensorFlow.js tfjs-layers v3.2.0",convertedBy:null};if(null!=t&&t.includeOptimizer&&null!=this.optimizer){s.trainingConfig=this.getTrainingConfig();const e="optimizer",{data:t,specs:r}=await nr(await this.optimizer.getWeights(),e);n.specs.push(...r),n.data=or([n.data,t])}if(null!=this.userDefinedMetadata){const e=!0;cg(this.userDefinedMetadata,this.name,e),s.userDefinedMetadata=this.userDefinedMetadata}return s.weightData=n.data,s.weightSpecs=n.specs,e.save(s)}setUserDefinedMetadata(e){cg(e,this.name),this.userDefinedMetadata=e}getUserDefinedMetadata(){return this.userDefinedMetadata}}Hg.className="Model",Ma(Hg);class jg extends Hg{}async function qg(e,t){if(null==t&&(t={}),"string"==typeof e){const n=dr(e,t);if(0===n.length)n.push(Zr(e,t));else if(n.length>1)throw new Cd(`Found more than one (${n.length}) load handlers for URL '${e}'`);e=n[0]}return async function(e,t,n){null==n&&(n={});if(null==e.load)throw new Cd("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const s=await e.load();let r=s.modelTopology;null!=r.model_config&&(r=r.model_config);const a=null==n.strict||n.strict,i=null!=s.weightData&&null!=s.weightSpecs&&a,o=Bm(gg(r),t,i),l=s.trainingConfig;null!=l&&o.loadTrainingConfig(l);null!=s.userDefinedMetadata&&o.setUserDefinedMetadata(s.userDefinedMetadata);if(null!=s.weightData){if(null==s.weightSpecs)throw new Cd("LayersModel artifacts contains weight data, but not weight specs. Therefore loading of weights cannot proceed.");const{modelWeights:e,optimizerWeights:t}=function(e,t){const n=sr(e,t),s={},r=[];return t.forEach(e=>{"optimizer"===e.group?r.push({name:e.name,tensor:n[e.name]}):s[e.name]=n[e.name]}),{modelWeights:s,optimizerWeights:r}}(s.weightData,s.weightSpecs);o.loadWeights(e,a),null!=o.optimizer&&t.length>0&&await o.optimizer.setWeights(t),Qa(e),Qa(t.map(e=>e.tensor))}return o}(e,void 0,t)}jg.className="Functional",Ma(jg);class Kg extends Hg{constructor(e){if(super({inputs:[],outputs:[]}),e=e||{},this.trainable=!0,this.built=!1,this.name=null!=e.name?e.name:hm("sequential_"),null!=e.layers)for(const t of e.layers)this.add(t)}checkShape(e){if(e.inboundNodes[0].outputTensors[0].shape.some(e=>e<0))throw new Cd("Negative dimension size caused by adding layer "+e.name+" with input shape ["+e.inboundNodes[0].inputTensors[0].shape+"]")}add(e){const t=e instanceof Kg||e instanceof Hg;let n;if(t){if(n=e,1!==n.outputs.length)throw new Cd("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");if(1!==n.inputs.length)throw new Cd("All layers in a Sequential model should have a single input tensor. For multi-input layers, use the functional API.")}if(0===this.outputs.length){if(0===e.inboundNodes.length){if(null==e.batchInputShape)throw new Cd("The first layer in a Sequential model must get an `inputShape` or `batchInputShape` argument.");const t=Tm({batchShape:e.batchInputShape,dtype:e.dtype,name:e.name+"_input"});e.apply(t)}if(t)this.outputs=n.outputs,this.inputs=n.inputs;else{if(1!==e.inboundNodes.length)throw new Cd(`A layer added to a Sequential model must not already be connected somewhere else. LayersModel received layer ${e.name} which has ${e.inboundNodes.length} pre-existing inbound connections.`);if(1!==e.inboundNodes[0].outputTensors.length)throw new Cd("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(e),this.outputs=[e.inboundNodes[0].outputTensors[0]],this.inputs=function e(t,n,s){if((null==n||null!=s&&s>0)&&(n=t.sourceLayer,s=t.nodeIndex),0===n.inboundNodes.length)return[t];{const t=n.inboundNodes[s];if(0===t.inboundLayers.length)return t.inputTensors;{const n=[];for(let s=0;s<t.inboundLayers.length;s++){const r=e(t.inputTensors[s],t.inboundLayers[s],t.nodeIndices[s]);for(const e of r)-1===n.indexOf(e)&&n.push(e)}return n}}}(this.outputs[0])}this.inboundNodes=[],new Nm({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:Ed(null,this.inputs.length),outputMasks:[null],inputShapes:this.inputs.map(e=>e.shape),outputShapes:this.outputs[0].shape})}else{const t=e.apply(this.outputs[0]);if(Array.isArray(t))throw new TypeError("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(e),this.outputs=[t],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}this.layers.push(e),this.built=!1}pop(){if(0===this.layers.length)throw new TypeError("There are no layers in the model.");if(this.layers.pop(),0===this.layers.length)this.outputs=[],this.inboundNodes=[],this.outboundNodes=[];else{const e=this.layers.length-1;this.layers[e].outboundNodes=[],this.outputs=[this.layers[e].output],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}}call(e,t){return null==this.model&&this.build(),this.model.call(e,t)}build(e){if(mm(e),0===this.inputs.length||0===this.outputs.length)throw new TypeError("Sequential model cannot be built: model is empty. Add some layers first.");this.model=new Hg({inputs:this.inputs,outputs:this.outputs[0],name:this.name+"_model"}),this.model.trainable=this.trainable,this.supportsMasking=this.model.supportsMasking,this.inputLayers=this.model.inputLayers,this.inputLayersNodeIndices=this.model.inputLayersNodeIndices,this.inputLayersTensorIndices=this.model.inputLayersTensorIndices,this.outputLayers=this.model.outputLayers,this.outputLayersNodeIndices=this.model.outputLayersNodeIndices,this.outputLayersTensorIndices=this.model.outputLayersTensorIndices,this.nodesByDepth=this.model.nodesByDepth,this.containerNodes=this.model.containerNodes,this.outputNames=this.model.outputNames,this.inputNames=this.model.inputNames,this.built=!0}countParams(){return this.built||this.build(),super.countParams()}summary(e,t,n=console.log){this.built||this.build(),super.summary(e,t,n)}setWeights(e){null==this.model&&this.build(),this.model.setWeights(e)}evaluate(e,t,n={}){if(!this.built)throw new Id("The model needs to be compiled before being used.");return this.model.evaluate(e,t,n)}async evaluateDataset(e,t){if(!this.built)throw new Id("The model needs to be compiled before being used.");return this.model.evaluateDataset(e,t)}predict(e,t={}){return null==this.model&&this.build(),this.model.predict(e,t)}predictOnBatch(e){return null==this.model&&this.build(),this.model.predictOnBatch(e)}compile(e){this.build(),this.model.compile(e),this.optimizer_=this.model.optimizer,this.isOptimizerOwned=this.model.isOptimizerOwned,this.loss=this.model.loss,this.metrics=this.model.metrics,this.metricsTensors=this.model.metricsTensors,this.metricsNames=this.model.metricsNames}get optimizer(){return null==this.model?void 0:this.model.optimizer}set optimizer(e){this.model.optimizer=e}async fit(e,t,n={}){if(!this.built)throw new Id("The model needs to be compiled before being used.");return this.model.fit(e,t,n)}async fitDataset(e,t){if(!this.built)throw new Id("The model needs to be compiled before being used.");return this.model.fitDataset(e,t)}async trainOnBatch(e,t){return this.model.trainOnBatch(e,t)}static fromConfig(e,t,n={},s=!1){let r,a={};if(t instanceof Array){if(null==t[0].className||"Merge"===t[0].className)throw new Cd("Legacy serialization format not supported yet.");r=t}else o(null!=t.layers,()=>"When the config data for a Sequential model is not an Array, it must be an Object that contains the 'layers' field."),r=t.layers,delete t.layers,a=t;const i=new e(a);if(!(i instanceof Kg))throw new Sd("Sequential.fromConfig called on non-Sequential input: "+i);for(const e of r){const t=Bm(e,void 0,s);s&&t.setFastWeightInitDuringBuild(!0),i.add(t)}return i}set stopTraining(e){if(null==this.model)throw new Cd("Cannot set the stopTraining property of a sequential model before it is compiled.");this.model.stopTraining=e}get stopTraining(){if(null==this.model)throw new Cd("Cannot get the stopTraining property of a sequential model before it is compiled.");return this.model.stopTraining}getConfig(){const e=[];for(const t of this.layers){const n={};n.className=t.getClassName(),n.config=t.getConfig(),e.push(n)}return{name:this.name,layers:e}}}function Xg(e){return new Hg(e)}function Yg(e){return new Kg(e)}function Jg(e,t){return null==t&&(t={}),qg(e,t)}function Zg(e){return Tm(e)}function Qg(e,t){Lm.registerCallbackConstructor(e,t)}Kg.className="Sequential",Ma(Kg);class ey extends _a{getConfig(){return{}}}class ty extends ey{apply(e,t=1){return function(e,t=1){if(1!==t)throw new Sd(`Support for alpha values other than 1 (${t}) is not implemented yet.`);return Fo(e)}(e,t)}}ty.className="elu",Ma(ty);class ny extends ey{apply(e){return Ru(e)}}ny.className="selu",Ma(ny);class sy extends ey{apply(e){return ku(e)}}sy.className="relu",Ma(sy);class ry extends ey{apply(e){return Za(()=>_l(6,ku(e)))}}ry.className="relu6",Ma(ry);class ay extends ey{apply(e){return e}}ay.className="linear",Ma(ay);class iy extends ey{apply(e){return Hi(e)}}iy.className="sigmoid",Ma(iy);class oy extends ey{apply(e){return function(e){return Za(()=>{const t=hi(.5,fi(.2,e));return so(t,0,1)})}(e)}}oy.className="hardSigmoid",Ma(oy);class ly extends ey{apply(e){return ul(e)}}ly.className="softplus",Ma(ly);class uy extends ey{apply(e){return function(e){return Za(()=>di(e,mi(e).add(1)))}(e)}}uy.className="softsign",Ma(uy);class cy extends ey{apply(e){return qi(e)}}cy.className="tanh",Ma(cy);class hy extends ey{apply(e,t=-1){return Wu(e,t)}}hy.className="softmax",Ma(hy);class py extends ey{apply(e,t=-1){return fl(e,t)}}py.className="logSoftmax",Ma(py);class dy extends ey{apply(e,t=1){return Za(()=>Hi(e.mul(t)).mul(e))}}function fy(e){return e.getClassName()}function my(e,t={}){return Ld(e,Oa.getMap().classNameMap,t,"activation")}function gy(e){if(null==e){const e={className:"linear",config:{}};return my(e)}if("string"==typeof e){const t={};return t.className=e,t.config={},my(t)}return e instanceof ey?e:my(e)}function yy(e){if(null!=e&&"object"!=typeof e)throw new Error("Argument to L1L2 regularizer's constructor is expected to be an object, but received: "+e)}dy.className="swish",Ma(dy);class by extends _a{}class xy extends by{constructor(e){super(),yy(e),this.l1=null==e||null==e.l1?.01:e.l1,this.l2=null==e||null==e.l2?.01:e.l2,this.hasL1=0!==this.l1,this.hasL2=0!==this.l2}apply(e){return Za(()=>{let t=Vl([1]);return this.hasL1&&(t=hi(t,dl(fi(this.l1,mi(e))))),this.hasL2&&(t=hi(t,dl(fi(this.l2,_f(e))))),t.asScalar()})}getConfig(){return{l1:this.l1,l2:this.l2}}static fromConfig(e,t){return new e({l1:t.l1,l2:t.l2})}}xy.className="L1L2",Ma(xy);const wy={l1l2:"L1L2"};function ky(e){return Md(e)}function vy(e,t={}){return Ld(e,Oa.getMap().classNameMap,t,"regularizer")}function Ny(e){if(null==e)return null;if("string"==typeof e){return vy({className:e in wy?wy[e]:e,config:{}})}return e instanceof by?e:vy(e)}class Iy extends Cm{constructor(e){super(null==e?{}:e),this.supportsMasking=!0,null!=e&&(this.maxValue=e.maxValue)}call(e,t){e=fm(e);let n=ku(e);return null!=this.maxValue&&(n=so(n,0,this.maxValue)),n}computeOutputShape(e){return e}getConfig(){const e={maxValue:this.maxValue},t=super.getConfig();return Object.assign(e,t),e}}Iy.className="ReLU",Ma(Iy);class Cy extends Cm{constructor(e){super(null==e?{}:e),this.DEFAULT_ALPHA=.3,null==e&&(e={}),this.alpha=null==e.alpha?this.DEFAULT_ALPHA:e.alpha}call(e,t){const n=fm(e);return Ko(n,this.alpha)}computeOutputShape(e){return e}getConfig(){const e={alpha:this.alpha},t=super.getConfig();return Object.assign(e,t),e}}Cy.className="LeakyReLU",Ma(Cy);class Sy extends Cm{constructor(e){if(super(null==e?{}:e),this.DEFAULT_ALPHA_INITIALIZER="zeros",null==e&&(e={}),this.supportsMasking=!0,this.alphaInitializer=im(e.alphaInitializer||this.DEFAULT_ALPHA_INITIALIZER),this.alphaRegularizer=Ny(e.alphaRegularizer),this.alphaConstraint=ef(e.alphaConstraint),null==e.sharedAxes)this.sharedAxes=null;else if(Array.isArray(e.sharedAxes))this.sharedAxes=e.sharedAxes;else{if("number"!=typeof e.sharedAxes)throw new Cd("Expected sharedAxes to be a number or an array of numbers, but got "+e.sharedAxes);this.sharedAxes=[e.sharedAxes]}}build(e){const t=(e=mm(e)).slice(1);if(null!=this.sharedAxes)for(const e of this.sharedAxes)t[e-1]=1;this.alpha=this.addWeight("alpha",t,"float32",this.alphaInitializer,this.alphaRegularizer,!0,this.alphaConstraint);const n={};if(null!=this.sharedAxes)for(let t=1;t<e.length;++t)n[t]=e[t];this.inputSpec=[new wm({ndim:e.length,axes:n})],this.built=!0}call(e,t){return e=fm(e),eu(e,this.alpha.read())}getConfig(){const e={alphaInitializer:am(this.alphaInitializer),alphaRegularizer:ky(this.alphaRegularizer),alphaConstraint:Zd(this.alphaConstraint),sharedAxes:this.sharedAxes},t=super.getConfig();return Object.assign(e,t),e}}Sy.className="PReLU",Ma(Sy);class Ty extends Cm{constructor(e){if(super(null==e?{}:e),this.DEFAULT_ALPHA=1,null==e&&(e={}),null!=e.alpha&&e.alpha!==this.DEFAULT_ALPHA)throw new Sd(`Non-default alpha value (${e.alpha}) is not supported by the ELU layer yet.`);this.alpha=null==e.alpha?this.DEFAULT_ALPHA:e.alpha}call(e,t){const n=fm(e);return Fo(n)}computeOutputShape(e){return e}getConfig(){const e={alpha:this.alpha},t=super.getConfig();return Object.assign(e,t),e}}Ty.className="ELU",Ma(Ty);class Ey extends Cm{constructor(e){super(null==e?{}:e),this.DEFAULT_THETA=1,null==e&&(e={}),this.theta=null==e.theta?this.DEFAULT_THETA:e.theta}call(e,t){const n=fm(e);return n.mul(Nf(n.greater(this.theta),"float32"))}computeOutputShape(e){return e}getConfig(){const e={theta:this.theta},t=super.getConfig();return Object.assign(e,t),e}}Ey.className="ThresholdedReLU",Ma(Ey);class $y extends Cm{constructor(e){super(null==e?{}:e),this.DEFAULT_AXIS=1,null==e&&(e={}),this.softmax=(new hy).apply,this.axis=null==e.axis?this.DEFAULT_AXIS:e.axis}call(e,t){const n=fm(e);return this.softmax(n,this.axis)}computeOutputShape(e){return e}getConfig(){const e={axis:this.axis},t=super.getConfig();return Object.assign(e,t),e}}function Ay(e,t,n){if("number"==typeof e)return Ed(e,t);if(e.length!==t)throw new Cd(`The ${n} argument must be an integer or tuple of ${t} integers. Received: ${e.length} elements.`);for(let r=0;r<t;++r){const a=e[r];if((s=a)!==parseInt(s.toString(),10))throw new Cd(`The ${n} argument must be an integer or tuple of ${t} integers. Received: ${JSON.stringify(e)} including a non-integer number `+a)}return e;var s}function Ry(e,t,n,s,r=1){if(null==e)return e;let a;return a="same"===n?e:e-(t+(t-1)*(r-1))+1,Math.floor((a+s-1)/s)}function Fy(e,t,n,s){if(null==e)return null;if("valid"===s)e=e*t+kf([n-t,0]);else{if("same"!==s)throw new Cd(`Unsupport padding mode: ${s}.`);e*=t}return e}function Dy(e,t){return Za(()=>(uf(t),"channelsFirst"===t?ra(e,[0,2,3,1]):e))}function _y(e,t){return Za(()=>(uf(t),"channelsFirst"===t?ra(e,[0,2,3,4,1]):e))}function Oy(e,t,n,s=1,r="valid",a,i=1){return Za(()=>{if(null==a&&(a="channelsLast"),uf(a),3!==e.shape.length)throw new Cd("The input of a conv1dWithBias operation should be 3, but is "+e.shape.length+" instead.");if(3!==t.shape.length)throw new Cd("The kernel for a conv1dWithBias operation should be 3, but is "+t.shape.length+" instead");if(null!=n&&1!==n.shape.length)throw new Cd("The bias for a conv1dWithBias operation should be 1, but is "+t.shape.length+" instead");if("channelsFirst"===a&&(e=ra(e,[0,2,1])),"causal"===r)throw new Sd("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");let o=uo(e,t,s,"same"===r?"same":"valid","NWC",i);return null!=n&&(o=Mf(o,n)),o})}function My(e,t,n,s=[1,1],r="valid",a,i,o=null){return Za(()=>{if(null==a&&(a="channelsLast"),uf(a),3!==e.rank&&4!==e.rank)throw new Cd(`conv2dWithBiasActivation expects input to be of rank 3 or 4, but received ${e.rank}.`);if(3!==t.rank&&4!==t.rank)throw new Cd(`conv2dWithBiasActivation expects kernel to be of rank 3 or 4, but received ${e.rank}.`);let l=Dy(e,a);if("causal"===r)throw new Sd("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");return l=Ec({x:l,filter:t,strides:s,pad:"same"===r?"same":"valid",dilations:i,dataFormat:"NHWC",bias:n,activation:o}),"channelsFirst"===a&&(l=ra(l,[0,3,1,2])),l})}function Ly(e,t,n,s=[1,1,1],r="valid",a,i){return Za(()=>{if(null==a&&(a="channelsLast"),uf(a),4!==e.rank&&5!==e.rank)throw new Cd("conv3dWithBias expects input to be of rank 4 or 5, but received "+e.rank+".");if(4!==t.rank&&5!==t.rank)throw new Cd("conv3dWithBias expects kernel to be of rank 4 or 5, but received "+e.rank+".");let o=_y(e,a);if("causal"===r)throw new Sd("The support for CAUSAL padding mode in conv3dWithBias is not implemented yet.");return o=po(o,t,s,"same"===r?"same":"valid","NDHWC",i),null!=n&&(o=Mf(o,n)),"channelsFirst"===a&&(o=ra(o,[0,4,1,2,3])),o})}$y.className="Softmax",Ma($y);class zy extends Cm{constructor(e,t){if(super(t),this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",zy.verifyArgs(t),this.rank=e,Ud(this.rank,"rank"),1!==this.rank&&2!==this.rank&&3!==this.rank)throw new Sd(`Convolution layer for rank other than 1, 2, or 3 (${this.rank}) is not implemented yet.`);if(this.kernelSize=Ay(t.kernelSize,e,"kernelSize"),this.strides=Ay(null==t.strides?1:t.strides,e,"strides"),this.padding=null==t.padding?"valid":t.padding,cf(this.padding),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,uf(this.dataFormat),this.activation=gy(t.activation),this.useBias=null==t.useBias||t.useBias,this.biasInitializer=im(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.biasConstraint=ef(t.biasConstraint),this.biasRegularizer=Ny(t.biasRegularizer),this.activityRegularizer=Ny(t.activityRegularizer),this.dilationRate=Ay(null==t.dilationRate?1:t.dilationRate,e,"dilationRate"),1===this.rank&&Array.isArray(this.dilationRate)&&1!==this.dilationRate.length)throw new Cd("dilationRate must be a number or an array of a single number for 1D convolution, but received "+JSON.stringify(this.dilationRate));if(2===this.rank){if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate];else if(2!==this.dilationRate.length)throw new Cd("dilationRate must be a number or array of two numbers for 2D convolution, but received "+JSON.stringify(this.dilationRate))}else if(3===this.rank)if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate,this.dilationRate];else if(3!==this.dilationRate.length)throw new Cd("dilationRate must be a number or array of three numbers for 3D convolution, but received "+JSON.stringify(this.dilationRate))}static verifyArgs(e){if($d("kernelSize"in e,"required key 'kernelSize' not in config"),"number"!=typeof e.kernelSize&&!Vd(e.kernelSize,"number",1,3))throw new Cd(`BaseConv expects config.kernelSize to be number or number[] with length 1, 2, or 3, but received ${JSON.stringify(e.kernelSize)}.`)}getConfig(){const e={kernelSize:this.kernelSize,strides:this.strides,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,activation:fy(this.activation),useBias:this.useBias,biasInitializer:am(this.biasInitializer),biasRegularizer:ky(this.biasRegularizer),activityRegularizer:ky(this.activityRegularizer),biasConstraint:Zd(this.biasConstraint)},t=super.getConfig();return Object.assign(e,t),e}}class By extends zy{constructor(e,t){super(e,t),this.kernel=null,By.verifyArgs(t),this.filters=t.filters,Ud(this.filters,"filters"),this.kernelInitializer=im(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.kernelConstraint=ef(t.kernelConstraint),this.kernelRegularizer=Ny(t.kernelRegularizer)}build(e){e=mm(e);const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new Cd("The channel dimension of the input should be defined. Found "+e[t]);const n=e[t],s=this.kernelSize.concat([n,this.filters]);this.kernel=this.addWeight("kernel",s,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[{ndim:this.rank+2,axes:{[t]:n}}],this.built=!0}call(e,t){return Za(()=>{let t;e=fm(e);const n=null==this.bias?null:this.bias.read(),s=Gd(this.activation.getClassName());if(null!=s&&2===this.rank)t=My(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate,s);else{if(1===this.rank)t=Oy(e,this.kernel.read(),n,this.strides[0],this.padding,this.dataFormat,this.dilationRate[0]);else if(2===this.rank)t=My(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate);else{if(3!==this.rank)throw new Sd("convolutions greater than 3D are not implemented yet.");t=Ly(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate)}null!=this.activation&&(t=this.activation.apply(t))}return t})}computeOutputShape(e){e=mm(e);const t=[],n="channelsLast"===this.dataFormat?e.slice(1,e.length-1):e.slice(2);for(let e=0;e<n.length;++e){const s=Ry(n[e],this.kernelSize[e],this.padding,this.strides[e],"number"==typeof this.dilationRate?this.dilationRate:this.dilationRate[e]);t.push(s)}let s=[e[0]];return"channelsLast"===this.dataFormat?(s=s.concat(t),s.push(this.filters)):(s.push(this.filters),s=s.concat(t)),s}getConfig(){const e={filters:this.filters,kernelInitializer:am(this.kernelInitializer),kernelRegularizer:ky(this.kernelRegularizer),kernelConstraint:Zd(this.kernelConstraint)},t=super.getConfig();return Object.assign(e,t),e}static verifyArgs(e){if(!("filters"in e)||"number"!=typeof e.filters||e.filters<1)throw new Cd("Convolution layer expected config.filters to be a 'number' > 0 but got "+JSON.stringify(e.filters))}}class Py extends By{constructor(e){super(2,e),Py.verifyArgs(e)}getConfig(){const e=super.getConfig();return delete e.rank,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&!Vd(e.kernelSize,"number",1,2))throw new Cd(`Conv2D expects config.kernelSize to be number or number[] with length 1 or 2, but received ${JSON.stringify(e.kernelSize)}.`)}}Py.className="Conv2D",Ma(Py);class Wy extends By{constructor(e){super(3,e),Wy.verifyArgs(e)}getConfig(){const e=super.getConfig();return delete e.rank,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&(!Array.isArray(e.kernelSize)||1!==e.kernelSize.length&&3!==e.kernelSize.length))throw new Cd(`Conv3D expects config.kernelSize to be number or [number, number, number], but received ${JSON.stringify(e.kernelSize)}.`)}}Wy.className="Conv3D",Ma(Wy);class Vy extends Py{constructor(e){if(super(e),this.inputSpec=[new wm({ndim:4})],"same"!==this.padding&&"valid"!==this.padding)throw new Cd("Conv2DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode "+this.padding)}build(e){if(4!==(e=mm(e)).length)throw new Cd("Input should have rank 4; Received input shape: "+JSON.stringify(e));const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new Cd("The channel dimension of the inputs should be defined. Found `None`.");const n=e[t],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new wm({ndim:4,axes:{[t]:n}})],this.built=!0}call(e,t){return Za(()=>{let t=fm(e);if(4!==t.shape.length)throw new Cd("Conv2DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-"+t.shape.length);const n=t.shape,s=n[0];let r,a;"channelsFirst"===this.dataFormat?(r=2,a=3):(r=1,a=2);const i=n[r],o=n[a],l=this.kernelSize[0],u=this.kernelSize[1],c=this.strides[0],h=this.strides[1],p=[s,Fy(i,c,l,this.padding),Fy(o,h,u,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(t=ra(t,[0,2,3,1]));let d=ho(t,this.kernel.read(),p,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(d=ra(d,[0,3,1,2])),null!=this.bias&&(d=Mf(d,this.bias.read(),this.dataFormat)),null!=this.activation&&(d=this.activation.apply(d)),d})}computeOutputShape(e){const t=(e=mm(e)).slice();let n,s,r;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3):(n=3,s=1,r=2);const a=this.kernelSize[0],i=this.kernelSize[1],o=this.strides[0],l=this.strides[1];return t[n]=this.filters,t[s]=Fy(t[s],o,a,this.padding),t[r]=Fy(t[r],l,i,this.padding),t}getConfig(){const e=super.getConfig();return delete e.dilationRate,e}}Vy.className="Conv2DTranspose",Ma(Vy);class Uy extends By{constructor(e,t){if(super(e,t),this.DEFAULT_DEPTHWISE_INITIALIZER="glorotUniform",this.DEFAULT_POINTWISE_INITIALIZER="glorotUniform",this.depthwiseKernel=null,this.pointwiseKernel=null,null==t.filters)throw new Cd("The `filters` configuration field is required by SeparableConv, but is unspecified.");if(null!=t.kernelInitializer||null!=t.kernelRegularizer||null!=t.kernelConstraint)throw new Cd("Fields kernelInitializer, kernelRegularizer and kernelConstraint are invalid for SeparableConv2D. Use depthwiseInitializer, depthwiseRegularizer, depthwiseConstraint, pointwiseInitializer, pointwiseRegularizer and pointwiseConstraint instead.");if(null!=t.padding&&"same"!==t.padding&&"valid"!==t.padding)throw new Cd(`SeparableConv${this.rank}D supports only padding modes: 'same' and 'valid', but received `+JSON.stringify(t.padding));this.depthMultiplier=null==t.depthMultiplier?1:t.depthMultiplier,this.depthwiseInitializer=im(t.depthwiseInitializer||this.DEFAULT_DEPTHWISE_INITIALIZER),this.depthwiseRegularizer=Ny(t.depthwiseRegularizer),this.depthwiseConstraint=ef(t.depthwiseConstraint),this.pointwiseInitializer=im(t.depthwiseInitializer||this.DEFAULT_POINTWISE_INITIALIZER),this.pointwiseRegularizer=Ny(t.pointwiseRegularizer),this.pointwiseConstraint=ef(t.pointwiseConstraint)}build(e){if((e=mm(e)).length<this.rank+2)throw new Cd(`Inputs to SeparableConv${this.rank}D should have rank `+(this.rank+2)+", but received input shape: "+JSON.stringify(e));const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t]||e[t]<0)throw new Cd("The channel dimension of the inputs should be defined, but found "+JSON.stringify(e[t]));const n=e[t],s=this.kernelSize.concat([n,this.depthMultiplier]),r=[];for(let e=0;e<this.rank;++e)r.push(1);r.push(n*this.depthMultiplier,this.filters);this.depthwiseKernel=this.addWeight("depthwise_kernel",s,"float32",this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.pointwiseKernel=this.addWeight("pointwise_kernel",r,"float32",this.pointwiseInitializer,this.pointwiseRegularizer,!0,this.pointwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.inputSpec=[new wm({ndim:this.rank+2,axes:{[t]:n}})],this.built=!0}call(e,t){return Za(()=>{let t;if(e=fm(e),1===this.rank)throw new Sd("1D separable convolution is not implemented yet.");return 2===this.rank&&("channelsFirst"===this.dataFormat&&(e=ra(e,[0,2,3,1])),t=Fu(e,this.depthwiseKernel.read(),this.pointwiseKernel.read(),this.strides,this.padding,this.dilationRate,"NHWC")),this.useBias&&(t=Mf(t,this.bias.read(),this.dataFormat)),null!=this.activation&&(t=this.activation.apply(t)),"channelsFirst"===this.dataFormat&&(t=ra(t,[0,3,1,2])),t})}getConfig(){const e=super.getConfig();return delete e.rank,delete e.kernelInitializer,delete e.kernelRegularizer,delete e.kernelConstraint,e.depthwiseInitializer=am(this.depthwiseInitializer),e.pointwiseInitializer=am(this.pointwiseInitializer),e.depthwiseRegularizer=ky(this.depthwiseRegularizer),e.pointwiseRegularizer=ky(this.pointwiseRegularizer),e.depthwiseConstraint=Zd(this.depthwiseConstraint),e.pointwiseConstraint=Zd(this.pointwiseConstraint),e}}Uy.className="SeparableConv";class Gy extends Uy{constructor(e){super(2,e)}}Gy.className="SeparableConv2D",Ma(Gy);class Hy extends By{constructor(e){super(1,e),Hy.verifyArgs(e),this.inputSpec=[{ndim:3}]}getConfig(){const e=super.getConfig();return delete e.rank,delete e.dataFormat,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&!Vd(e.kernelSize,"number",1,1))throw new Cd(`Conv1D expects config.kernelSize to be number or number[] with length 1, but received ${JSON.stringify(e.kernelSize)}.`)}}Hy.className="Conv1D",Ma(Hy);class jy extends Cm{constructor(e){super(e),"number"==typeof e.cropping?this.cropping=[[e.cropping,e.cropping],[e.cropping,e.cropping]]:"number"==typeof e.cropping[0]?this.cropping=[[e.cropping[0],e.cropping[0]],[e.cropping[1],e.cropping[1]]]:this.cropping=e.cropping,this.dataFormat=void 0===e.dataFormat?"channelsLast":e.dataFormat,this.inputSpec=[{ndim:4}]}computeOutputShape(e){return"channelsFirst"===this.dataFormat?[e[0],e[1],e[2]-this.cropping[0][0]-this.cropping[0][1],e[3]-this.cropping[1][0]-this.cropping[1][1]]:[e[0],e[1]-this.cropping[0][0]-this.cropping[0][1],e[2]-this.cropping[1][0]-this.cropping[1][1],e[3]]}call(e,t){return Za(()=>{if(e=fm(e),"channelsLast"===this.dataFormat){const t=Tf(e,this.cropping[0][0],e.shape[1]-this.cropping[0][0]-this.cropping[0][1],2);return Tf(t,this.cropping[1][0],e.shape[2]-this.cropping[1][1]-this.cropping[1][0],3)}{const t=Tf(e,this.cropping[0][0],e.shape[2]-this.cropping[0][0]-this.cropping[0][1],3);return Tf(t,this.cropping[1][0],e.shape[3]-this.cropping[1][1]-this.cropping[1][0],4)}})}getConfig(){const e={cropping:this.cropping,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}jy.className="Cropping2D",Ma(jy);class qy extends Cm{constructor(e){var t;super(e),this.DEFAULT_SIZE=[2,2],this.inputSpec=[{ndim:4}],this.size=null==e.size?this.DEFAULT_SIZE:e.size,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,uf(this.dataFormat),this.interpolation=null==e.interpolation?"nearest":e.interpolation,t=this.interpolation,Wd(sf,"InterpolationFormat",t)}computeOutputShape(e){if("channelsFirst"===this.dataFormat){const t=null==e[2]?null:this.size[0]*e[2],n=null==e[3]?null:this.size[1]*e[3];return[e[0],e[1],t,n]}{const t=null==e[1]?null:this.size[0]*e[1],n=null==e[2]?null:this.size[1]*e[2];return[e[0],t,n,e[3]]}}call(e,t){return Za(()=>{let t=fm(e);const n=t.shape;if("channelsFirst"===this.dataFormat){t=ra(t,[0,2,3,1]);const e=this.size[0]*n[2],s=this.size[1]*n[3],r="nearest"===this.interpolation?t.resizeNearestNeighbor([e,s]):t.resizeBilinear([e,s]);return ra(r,[0,3,1,2])}{const e=this.size[0]*n[1],s=this.size[1]*n[2];return"nearest"===this.interpolation?t.resizeNearestNeighbor([e,s]):t.resizeBilinear([e,s])}})}getConfig(){const e={size:this.size,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}qy.className="UpSampling2D",Ma(qy);class Ky extends zy{constructor(e){super(2,e),this.depthwiseKernel=null,this.depthMultiplier=null==e.depthMultiplier?1:e.depthMultiplier,this.depthwiseInitializer=im(e.depthwiseInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.depthwiseConstraint=ef(e.depthwiseConstraint),this.depthwiseRegularizer=Ny(e.depthwiseRegularizer)}build(e){if((e=mm(e)).length<4)throw new Cd(`Inputs to DepthwiseConv2D should have rank 4. Received input shape: ${JSON.stringify(e)}.`);const t="channelsFirst"===this.dataFormat?1:3;if(null==e[t]||e[t]<0)throw new Cd(`The channel dimension of the inputs to DepthwiseConv2D should be defined, but is not (${e[t]}).`);const n=e[t],s=[this.kernelSize[0],this.kernelSize[1],n,this.depthMultiplier];this.depthwiseKernel=this.addWeight("depthwise_kernel",s,null,this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[n*this.depthMultiplier],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return Za(()=>{let t=function(e,t,n=[1,1],s="valid",r,a){return Za(()=>{null==r&&(r="channelsLast"),uf(r);let i=Dy(e,r);if(4!==e.rank)throw new Cd("Input for depthwiseConv2d is required to be 4-D, but is instead "+e.rank+"-D");if(4!==t.rank)throw new Cd("depthwiseKernel is required to be 4-D, but is instead "+t.rank+"-D");return i=ko(i,t,n,"same"===s?"same":"valid","NHWC",a),"channelsFirst"===r&&(i=ra(i,[0,3,1,2])),i})}(e=fm(e),this.depthwiseKernel.read(),this.strides,this.padding,this.dataFormat,null);return this.useBias&&(t=Mf(t,this.bias.read(),this.dataFormat)),null!=this.activation&&(t=this.activation.apply(t)),t})}computeOutputShape(e){e=mm(e);const t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2],s="channelsFirst"===this.dataFormat?e[1]*this.depthMultiplier:e[3]*this.depthMultiplier,r=Ry(t,this.kernelSize[0],this.padding,this.strides[0]),a=Ry(n,this.kernelSize[1],this.padding,this.strides[1]);return"channelsFirst"===this.dataFormat?[e[0],s,r,a]:[e[0],r,a,s]}getConfig(){const e=super.getConfig();return e.depthMultiplier=this.depthMultiplier,e.depthwiseInitializer=am(this.depthwiseInitializer),e.depthwiseRegularizer=ky(this.depthwiseRegularizer),e.depthwiseConstraint=Zd(this.depthwiseRegularizer),e}}function Xy(e,t,n,s){if(Array.isArray(e)){if(null!=t||null!=n)throw new Cd("When inputs is an array, neither initialState or constants should be provided");null!=s&&(n=e.slice(e.length-s,e.length),e=e.slice(0,e.length-s)),e.length>1&&(t=e.slice(1,e.length)),e=e[0]}function r(e){return null==e||Array.isArray(e)?e:[e]}return{inputs:e,initialState:t=r(t),constants:n=r(n)}}function Yy(e,t,n,s=!1,r,a,i=!1,o=!1){return Za(()=>{const l=t.shape.length;if(l<3)throw new Cd(`Input should be at least 3D, but is ${l}D.`);const u=[1,0].concat(vf(2,l));if(t=ra(t,u),null!=a)throw new Sd("The rnn() functoin of the deeplearn.js backend does not support constants yet.");i&&console.warn("Backend rnn(): the unroll = true option is not applicable to the imperative deeplearn.js backend."),null!=r&&((r=r.asType("bool").asType("float32")).rank===l-1&&(r=Oo(r,-1)),r=ra(r,u)),s&&(t=Nu(t,0),null!=r&&(r=Nu(r,0)));const c=[];let h,p=n;const d=t.shape[0],f=uc(t);let m,g;null!=r&&(m=uc(r));for(let t=0;t<d;++t){const n=f[t],s=Za(()=>e(n,p));if(null==r)h=s[0],p=s[1];else{const e=Za(()=>{const e=m[t],n=Gl(e).sub(e);return{output:s[0].mul(e).add(p[0].mul(n)),newStates:p.map((t,r)=>s[1][r].mul(e).add(t.mul(n)))}});h=e.output,p=e.newStates}o&&c.push(h)}if(o){g=Yu(c,1)}return[h,g,p]})}Ky.className="DepthwiseConv2D",Ma(Ky);class Jy extends Cm{constructor(e){let t;if(super(e),null==e.cell)throw new Cd("cell property is missing for the constructor of RNN.");if(t=Array.isArray(e.cell)?new ab({cells:e.cell}):e.cell,null==t.stateSize)throw new Cd("The RNN cell should have an attribute `stateSize` (tuple of integers, one integer per RNN state).");this.cell=t,this.returnSequences=null!=e.returnSequences&&e.returnSequences,this.returnState=null!=e.returnState&&e.returnState,this.goBackwards=null!=e.goBackwards&&e.goBackwards,this._stateful=null!=e.stateful&&e.stateful,this.unroll=null!=e.unroll&&e.unroll,this.supportsMasking=!0,this.inputSpec=[new wm({ndim:3})],this.stateSpec=null,this.states_=null,this.numConstants=null,this.keptStates=[]}getStates(){if(null==this.states_){return vf(0,Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1).map(e=>null)}return this.states_}setStates(e){this.states_=e}computeOutputShape(e){pm(e)&&(e=e[0]),e=e;let t=this.cell.stateSize;Array.isArray(t)||(t=[t]);const n=t[0];let s;if(s=this.returnSequences?[e[0],e[1],n]:[e[0],n],this.returnState){const n=[];for(const s of t)n.push([e[0],s]);return[s].concat(n)}return s}computeMask(e,t){return Za(()=>{Array.isArray(t)&&(t=t[0]);const e=this.returnSequences?t:null;if(this.returnState){const t=this.states.map(e=>null);return[e].concat(t)}return e})}get states(){if(null==this.states_){const e=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1,t=[];for(let n=0;n<e;++n)t.push(null);return t}return this.states_}set states(e){this.states_=e}build(e){if(null!=this.numConstants)throw new Sd("Constants support is not implemented in RNN yet.");pm(e)&&(e=e[0]),e=e;const t=this.stateful?e[0]:null,n=e.slice(2);this.inputSpec[0]=new wm({shape:[t,null,...n]});const s=[e[0]].concat(e.slice(2));let r;if(this.cell.build(s),r=Array.isArray(this.cell.stateSize)?this.cell.stateSize:[this.cell.stateSize],null!=this.stateSpec){if(!p(this.stateSpec.map(e=>e.shape[e.shape.length-1]),r))throw new Cd(`An initialState was passed that is not compatible with cell.stateSize. Received stateSpec=${this.stateSpec}; However cell.stateSize is `+this.cell.stateSize)}else this.stateSpec=r.map(e=>new wm({shape:[null,e]}));this.stateful&&this.resetStates()}resetStates(e,t=!1){Za(()=>{if(!this.stateful)throw new Nd("Cannot call resetStates() on an RNN Layer that is not stateful.");const n=this.inputSpec[0].shape[0];if(null==n)throw new Cd("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.states_)Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(e=>Vl([n,e])):this.states_=[Vl([n,this.cell.stateSize])];else if(null==e)Qa(this.states_),null!=this.keptStates&&(Qa(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(e=>Vl([n,e])):this.states_[0]=Vl([n,this.cell.stateSize]);else{if(Array.isArray(e)||(e=[e]),e.length!==this.states_.length)throw new Cd(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${e.length} state value(s). Input received: `+e);!0===t?this.keptStates.push(this.states_.slice()):Qa(this.states_);for(let t=0;t<this.states_.length;++t){const s=e[t],r=Array.isArray(this.cell.stateSize)?this.cell.stateSize[t]:this.cell.stateSize,a=[n,r];if(!p(s.shape,a))throw new Cd(`State ${t} is incompatible with layer ${this.name}: expected shape=${a}, received shape=${s.shape}`);this.states_[t]=s}}this.states_=this.states_.map(e=>ei(e.clone()))})}apply(e,t){let n=null==t?null:t.initialState,s=null==t?null:t.constants;null==t&&(t={});const r=Xy(e,n,s,this.numConstants);e=r.inputs,n=r.initialState,s=r.constants;let a=[],i=[];if(null!=n){t.initialState=n,a=a.concat(n),this.stateSpec=[];for(const e of n)this.stateSpec.push(new wm({shape:e.shape}));i=i.concat(this.stateSpec)}if(null!=s&&(t.constants=s,a=a.concat(s),this.numConstants=s.length),a[0]instanceof km){const n=[e].concat(a),s=this.inputSpec.concat(i),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,t);return this.inputSpec=r,o}return super.apply(e,t)}call(e,t){return Za(()=>{const n=null==t?null:t.mask,s=null==t?null:t.training;let r=null==t?null:t.initialState;e=fm(e),null==r&&(r=this.stateful?this.states_:this.getInitialState(e));const a=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1;if(r.length!==a)throw new Cd(`RNN Layer has ${a} state(s) but was passed `+r.length+" initial state(s).");this.unroll&&console.warn("Ignoring unroll = true for RNN layer, due to imperative backend.");const i={training:s},o=Yy((e,t)=>{const n=this.cell.call([e].concat(t),i);return[n[0],n.slice(1)]},e,r,this.goBackwards,n,null,this.unroll,this.returnSequences),l=o[0],u=o[1],c=o[2];this.stateful&&this.resetStates(c,s);const h=this.returnSequences?u:l;return this.returnState?[h].concat(c):h})}getInitialState(e){return Za(()=>{let t=Vl(e.shape);return t=dl(t,[1,2]),t=If(t),Array.isArray(this.cell.stateSize)?this.cell.stateSize.map(e=>e>1?Af(t,[1,e]):t):this.cell.stateSize>1?[Af(t,[1,this.cell.stateSize])]:[t]})}get trainableWeights(){return this.trainable?this.cell.trainableWeights:[]}get nonTrainableWeights(){return this.trainable?this.cell.nonTrainableWeights:this.cell.weights}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.cell&&this.cell.setFastWeightInitDuringBuild(e)}getConfig(){const e=super.getConfig(),t={returnSequences:this.returnSequences,returnState:this.returnState,goBackwards:this.goBackwards,stateful:this.stateful,unroll:this.unroll};null!=this.numConstants&&(t.numConstants=this.numConstants);const n=this.cell.getConfig();return this.getClassName()===Jy.className&&(t.cell={className:this.cell.getClassName(),config:n}),Object.assign({},n,e,t)}static fromConfig(e,t,n={}){const s=Bm(t.cell,n);return new e(Object.assign(t,{cell:s}))}}Jy.className="RNN",Ma(Jy);class Zy extends Cm{}class Qy extends Zy{constructor(e){super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=e.units,Ud(this.units,"units"),this.activation=gy(null==e.activation?this.DEFAULT_ACTIVATION:e.activation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=im(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=im(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=im(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Ny(e.kernelRegularizer),this.recurrentRegularizer=Ny(e.recurrentRegularizer),this.biasRegularizer=Ny(e.biasRegularizer),this.kernelConstraint=ef(e.kernelConstraint),this.recurrentConstraint=ef(e.recurrentConstraint),this.biasConstraint=ef(e.biasConstraint),this.dropout=wf([1,kf([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=wf([1,kf([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){e=mm(e),this.kernel=this.addWeight("kernel",[e[e.length-1],this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return Za(()=>{if(2!==(e=e).length)throw new Cd(`SimpleRNNCell expects 2 input Tensors, got ${e.length}.`);let n=e[1];e=e[0];const s=null!=t.training&&t.training;let r;0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=ib({ones:()=>Gl(e),rate:this.dropout,training:s})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=ib({ones:()=>Gl(n),rate:this.recurrentDropout,training:s}));const a=this.dropoutMask,i=this.recurrentDropoutMask;r=Ff(null!=a?fi(e,a):e,this.kernel.read()),null!=this.bias&&(r=Mf(r,this.bias.read())),null!=i&&(n=fi(n,i));let o=hi(r,Ff(n,this.recurrentKernel.read()));return null!=this.activation&&(o=this.activation.apply(o)),[o,o]})}getConfig(){const e=super.getConfig(),t={units:this.units,activation:fy(this.activation),useBias:this.useBias,kernelInitializer:am(this.kernelInitializer),recurrentInitializer:am(this.recurrentInitializer),biasInitializer:am(this.biasInitializer),kernelRegularizer:ky(this.kernelRegularizer),recurrentRegularizer:ky(this.recurrentRegularizer),biasRegularizer:ky(this.biasRegularizer),activityRegularizer:ky(this.activityRegularizer),kernelConstraint:Zd(this.kernelConstraint),recurrentConstraint:Zd(this.recurrentConstraint),biasConstraint:Zd(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout};return Object.assign({},e,t)}}Qy.className="SimpleRNNCell",Ma(Qy);class eb extends Jy{constructor(e){e.cell=new Qy(e),super(e)}call(e,t){return Za(()=>{null!=this.cell.dropoutMask&&(Qa(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(Qa(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})})}static fromConfig(e,t){return new e(t)}}eb.className="SimpleRNN",Ma(eb);class tb extends Zy{constructor(e){if(super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",e.resetAfter)throw new Cd("GRUCell does not support reset_after parameter set to true.");this.units=e.units,Ud(this.units,"units"),this.activation=gy(void 0===e.activation?this.DEFAULT_ACTIVATION:e.activation),this.recurrentActivation=gy(void 0===e.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:e.recurrentActivation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=im(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=im(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=im(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Ny(e.kernelRegularizer),this.recurrentRegularizer=Ny(e.recurrentRegularizer),this.biasRegularizer=Ny(e.biasRegularizer),this.kernelConstraint=ef(e.kernelConstraint),this.recurrentConstraint=ef(e.recurrentConstraint),this.biasConstraint=ef(e.biasConstraint),this.dropout=wf([1,kf([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=wf([1,kf([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.implementation=e.implementation,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){const t=(e=mm(e))[e.length-1];this.kernel=this.addWeight("kernel",[t,3*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,3*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[3*this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return Za(()=>{if(2!==(e=e).length)throw new Cd("GRUCell expects 2 input Tensors (inputs, h, c), got "+e.length+".");const n=null!=t.training&&t.training;let s=e[1];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=ib({ones:()=>Gl(e),rate:this.dropout,training:n,count:3})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=ib({ones:()=>Gl(s),rate:this.recurrentDropout,training:n,count:3}));const r=this.dropoutMask,a=this.recurrentDropoutMask;let i,o,l;0<this.dropout&&this.dropout<1&&(e=fi(e,r[0]));let u=Ff(e,this.kernel.read());this.useBias&&(u=Mf(u,this.bias.read())),0<this.recurrentDropout&&this.recurrentDropout<1&&(s=fi(s,a[0]));const c=this.recurrentKernel.read(),[h,p]=Hu(c,[2*this.units,this.units],c.rank-1),d=Ff(s,h),[f,m,g]=Hu(u,3,u.rank-1),[y,b]=Hu(d,2,d.rank-1);i=this.recurrentActivation.apply(hi(f,y)),o=this.recurrentActivation.apply(hi(m,b));const x=Ff(fi(o,s),p);l=this.activation.apply(hi(g,x));const w=hi(fi(i,s),fi(hi(1,ll(i)),l));return[w,w]})}getConfig(){const e=super.getConfig(),t={units:this.units,activation:fy(this.activation),recurrentActivation:fy(this.recurrentActivation),useBias:this.useBias,kernelInitializer:am(this.kernelInitializer),recurrentInitializer:am(this.recurrentInitializer),biasInitializer:am(this.biasInitializer),kernelRegularizer:ky(this.kernelRegularizer),recurrentRegularizer:ky(this.recurrentRegularizer),biasRegularizer:ky(this.biasRegularizer),activityRegularizer:ky(this.activityRegularizer),kernelConstraint:Zd(this.kernelConstraint),recurrentConstraint:Zd(this.recurrentConstraint),biasConstraint:Zd(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation,resetAfter:!1};return Object.assign({},e,t)}}tb.className="GRUCell",Ma(tb);class nb extends Jy{constructor(e){0===e.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),e.cell=new tb(e),super(e)}call(e,t){return Za(()=>{null!=this.cell.dropoutMask&&(Qa(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(Qa(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})})}static fromConfig(e,t){return 0===t.implmentation&&(t.implementation=1),new e(t)}}nb.className="GRU",Ma(nb);class sb extends Zy{constructor(e){super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=e.units,Ud(this.units,"units"),this.activation=gy(void 0===e.activation?this.DEFAULT_ACTIVATION:e.activation),this.recurrentActivation=gy(void 0===e.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:e.recurrentActivation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=im(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=im(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=im(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.unitForgetBias=e.unitForgetBias,this.kernelRegularizer=Ny(e.kernelRegularizer),this.recurrentRegularizer=Ny(e.recurrentRegularizer),this.biasRegularizer=Ny(e.biasRegularizer),this.kernelConstraint=ef(e.kernelConstraint),this.recurrentConstraint=ef(e.recurrentConstraint),this.biasConstraint=ef(e.biasConstraint),this.dropout=wf([1,kf([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=wf([1,kf([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.implementation=e.implementation,this.stateSize=[this.units,this.units],this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){var t;const n=(e=mm(e))[e.length-1];let s;if(this.kernel=this.addWeight("kernel",[n,4*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,4*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){if(this.unitForgetBias){const e=this.biasInitializer,n=this.units;s=new((t=class extends Wf{apply(t,s){const r=e.apply([n]),a=(new Uf).apply([n]),i=e.apply([2*n]);return $f($f(r,a),i)}}).className="CustomInit",t)}else s=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.units],null,s,this.biasRegularizer,!0,this.biasConstraint)}else this.bias=null;this.built=!0}call(e,t){return Za(()=>{const n=null!=t.training&&t.training;if(3!==(e=e).length)throw new Cd("LSTMCell expects 3 input Tensors (inputs, h, c), got "+e.length+".");let s=e[1];const r=e[2];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=ib({ones:()=>Gl(e),rate:this.dropout,training:n,count:4})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=ib({ones:()=>Gl(s),rate:this.recurrentDropout,training:n,count:4}));const a=this.dropoutMask,i=this.recurrentDropoutMask;let o,l,u,c;0<this.dropout&&this.dropout<1&&(e=fi(e,a[0]));let h=Ff(e,this.kernel.read());0<this.recurrentDropout&&this.recurrentDropout<1&&(s=fi(s,i[0])),h=hi(h,Ff(s,this.recurrentKernel.read())),this.useBias&&(h=Mf(h,this.bias.read()));const[p,d,f,m]=Hu(h,4,h.rank-1);o=this.recurrentActivation.apply(p),l=this.recurrentActivation.apply(d),u=hi(fi(l,r),fi(o,this.activation.apply(f))),c=this.recurrentActivation.apply(m);const g=fi(c,this.activation.apply(u));return[g,g,u]})}getConfig(){const e=super.getConfig(),t={units:this.units,activation:fy(this.activation),recurrentActivation:fy(this.recurrentActivation),useBias:this.useBias,kernelInitializer:am(this.kernelInitializer),recurrentInitializer:am(this.recurrentInitializer),biasInitializer:am(this.biasInitializer),unitForgetBias:this.unitForgetBias,kernelRegularizer:ky(this.kernelRegularizer),recurrentRegularizer:ky(this.recurrentRegularizer),biasRegularizer:ky(this.biasRegularizer),activityRegularizer:ky(this.activityRegularizer),kernelConstraint:Zd(this.kernelConstraint),recurrentConstraint:Zd(this.recurrentConstraint),biasConstraint:Zd(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation};return Object.assign({},e,t)}}sb.className="LSTMCell",Ma(sb);class rb extends Jy{constructor(e){0===e.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),e.cell=new sb(e),super(e)}call(e,t){return Za(()=>{null!=this.cell.dropoutMask&&(Qa(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(Qa(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})})}static fromConfig(e,t){return 0===t.implmentation&&(t.implementation=1),new e(t)}}rb.className="LSTM",Ma(rb);class ab extends Zy{constructor(e){super(e),this.cells=e.cells}get stateSize(){const e=[];for(const t of this.cells.slice().reverse())Array.isArray(t.stateSize)?e.push(...t.stateSize):e.push(t.stateSize);return e}call(e,t){return Za(()=>{let n=(e=e).slice(1);const s=[];for(const e of this.cells.slice().reverse())Array.isArray(e.stateSize)?s.push(n.splice(0,e.stateSize.length)):s.push(n.splice(0,1));s.reverse();const r=[];let a;for(let i=0;i<this.cells.length;++i){const o=this.cells[i];n=s[i],a=0===i?[e[0]].concat(n):[a[0]].concat(n),a=o.call(a,t),r.push(a.slice(1))}n=[];for(const e of r.slice().reverse())n.push(...e);return[a[0]].concat(n)})}build(e){let t;pm(e)&&(e=e[0]),e=e,this.cells.forEach((n,s)=>{df("RNNCell_"+s,()=>{n.build(e),t=Array.isArray(n.stateSize)?n.stateSize[0]:n.stateSize,e=[e[0],t]})}),this.built=!0}getConfig(){const e=super.getConfig(),t={cells:this.cells.map(e=>({className:e.getClassName(),config:e.getConfig()}))};return Object.assign({},e,t)}static fromConfig(e,t,n={}){const s=[];for(const e of t.cells)s.push(Bm(e,n));return new e({cells:s})}get trainableWeights(){if(!this.trainable)return[];const e=[];for(const t of this.cells)e.push(...t.trainableWeights);return e}get nonTrainableWeights(){const e=[];for(const t of this.cells)e.push(...t.nonTrainableWeights);if(!this.trainable){const t=[];for(const e of this.cells)t.push(...e.trainableWeights);return t.concat(e)}return e}getWeights(){const e=[];for(const t of this.cells)e.push(...t.weights);return bm(e)}setWeights(e){const t=[];for(const n of this.cells){const s=n.weights.length,r=e.splice(s);for(let e=0;e<n.weights.length;++e)t.push([n.weights[e],r[e]])}xm(t)}}function ib(e){const{ones:t,rate:n,training:s=!1,count:r=1}=e,a=()=>Lf(t(),n),i=()=>zf(a,t,s);return!r||r<=1?ei(i().clone()):Array(r).fill(void 0).map(i).map(e=>ei(e.clone()))}ab.className="StackedRNNCells",Ma(ab);var ob=function(e,t){var n={};for(var s in e)Object.prototype.hasOwnProperty.call(e,s)&&t.indexOf(s)<0&&(n[s]=e[s]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var r=0;for(s=Object.getOwnPropertySymbols(e);r<s.length;r++)t.indexOf(s[r])<0&&Object.prototype.propertyIsEnumerable.call(e,s[r])&&(n[s[r]]=e[s[r]])}return n};class lb extends Jy{constructor(e){if(e.unroll)throw new Sd("Unrolling is not possible with convolutional RNNs.");if(Array.isArray(e.cell))throw new Sd("It is not possible at the moment to stack convolutional cells.");super(e),this.inputSpec=[new wm({ndim:5})]}call(e,t){return Za(()=>{if(null!=this.cell.dropoutMask&&(Qa(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(Qa(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null),t&&t.constants)throw new Cd("ConvRNN2D cell does not support constants");const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})})}computeOutputShape(e){let t=this.computeSingleOutputShape(e);return this.returnSequences||(t=[t[0],...t.slice(2)]),this.returnState&&(t=[t,...Array(2).fill([e[0],...t.slice(-3)])]),t}getInitialState(e){return Za(()=>{const{stateSize:t}=this.cell,n=e.shape,s=this.computeSingleOutputShape(n),r=Vl([s[0],...s.slice(2)]);return Array.isArray(t)?Array(t.length).fill(r):[r]})}resetStates(e,t=!1){Za(()=>{if(!this.stateful)throw new Nd("Cannot call resetStates() on an RNN Layer that is not stateful.");const n=this.inputSpec[0].shape,s=this.computeSingleOutputShape(n),r=[s[0],...s.slice(2)];if(null==n[0])throw new Cd("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.getStates())Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(()=>Vl(r)):this.states_=[Vl(r)];else if(null==e)Qa(this.states_),null!=this.keptStates&&(Qa(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(()=>Vl(r)):this.states_[0]=Vl(r);else{if(Array.isArray(e)||(e=[e]),e.length!==this.states_.length)throw new Cd(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${e.length} state value(s). Input received: `+e);t?this.keptStates.push(this.states_.slice()):Qa(this.states_);for(let t=0;t<this.states_.length;++t){const n=e[t],s=r;if(!p(n.shape,s))throw new Cd(`State ${t} is incompatible with layer ${this.name}: expected shape=${s}, received shape=${n.shape}`);this.states_[t]=n}}this.states_=this.states_.map(e=>ei(e.clone()))})}computeSingleOutputShape(e){const{dataFormat:t,filters:n,kernelSize:s,padding:r,strides:a,dilationRate:i}=this.cell,o="channelsFirst"===t,l=e[o?3:2],u=e[o?4:3],c=Ry(l,s[0],r,a[0],i[0]),h=Ry(u,s[1],r,a[1],i[1]);return[...e.slice(0,2),...o?[n,c,h]:[c,h,n]]}}lb.className="ConvRNN2D";class ub extends sb{constructor(e){const{filters:t,kernelSize:n,strides:s,padding:r,dataFormat:a,dilationRate:i}=e;super(Object.assign({},e,{units:t})),this.filters=t,Ud(this.filters,"filters"),this.kernelSize=Ay(n,2,"kernelSize"),this.kernelSize.forEach(e=>Ud(e,"kernelSize")),this.strides=Ay(s||1,2,"strides"),this.strides.forEach(e=>Ud(e,"strides")),this.padding=r||"valid",cf(this.padding),this.dataFormat=a||"channelsLast",uf(this.dataFormat),this.dilationRate=Ay(i||1,2,"dilationRate"),this.dilationRate.forEach(e=>Ud(e,"dilationRate"))}build(e){var t;e=mm(e);const n="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[n])throw new Cd("The channel dimension of the input should be defined. Found "+e[n]);const s=e[n],r=this.kernelSize.concat([s,4*this.filters]);this.kernel=this.addWeight("kernel",r,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint);const a=this.kernelSize.concat([this.filters,4*this.filters]);if(this.recurrentKernel=this.addWeight("recurrent_kernel",a,null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){let e;if(this.unitForgetBias){const n=this.biasInitializer,s=this.filters;e=new((t=class extends Wf{apply(e,t){return Ef([n.apply([s]),Ul([s]),n.apply([2*s])])}}).className="CustomInit",t)}else e=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.filters],null,e,this.biasRegularizer,!0,this.biasConstraint)}this.built=!0}call(e,t){return Za(()=>{if(3!==e.length)throw new Cd("ConvLSTM2DCell expects 3 input Tensors (inputs, h, c), got "+e.length+".");const n=t.training||!1,s=e[0],r=e[1],a=e[2];0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=ib({ones:()=>Gl(s),rate:this.dropout,training:n,count:4}));const i=this.dropoutMask,o=(e,t,n)=>t&&t[n]?fi(t[n],e):e;let l=o(s,i,0),u=o(s,i,1),c=o(s,i,2),h=o(s,i,3);0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=ib({ones:()=>Gl(r),rate:this.recurrentDropout,training:n,count:4}));const p=this.recurrentDropoutMask;let d=o(r,p,0),f=o(r,p,1),m=o(r,p,2),g=o(r,p,3);const[y,b,x,w]=Hu(this.kernel.read(),4,3),[k,v,N,I]=this.useBias?Hu(this.bias.read(),4):[null,null,null,null];l=this.inputConv(l,y,k,this.padding),u=this.inputConv(u,b,v,this.padding),c=this.inputConv(c,x,N,this.padding),h=this.inputConv(h,w,I,this.padding);const[C,S,T,E]=Hu(this.recurrentKernel.read(),4,3);d=this.recurrentConv(d,C),f=this.recurrentConv(f,S),m=this.recurrentConv(m,T),g=this.recurrentConv(g,E);const $=this.recurrentActivation.apply(hi(l,d)),A=this.recurrentActivation.apply(hi(u,f)),R=hi(fi(A,a),fi($,this.activation.apply(hi(c,m)))),F=fi(this.recurrentActivation.apply(hi(h,g)),this.activation.apply(R));return[F,F,R]})}getConfig(){const e=super.getConfig(),{units:t}=e,n=ob(e,["units"]),s={filters:this.filters,kernelSize:this.kernelSize,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,strides:this.strides};return Object.assign({},n,s)}inputConv(e,t,n,s){const r=lo(e,t,this.strides,s||"valid","channelsFirst"===this.dataFormat?"NCHW":"NHWC",this.dilationRate);return n?Mf(r,n,this.dataFormat):r}recurrentConv(e,t){return lo(e,t,1,"same","channelsFirst"===this.dataFormat?"NCHW":"NHWC")}}ub.className="ConvLSTM2DCell",Ma(ub);class cb extends lb{constructor(e){const t=new ub(e);super(Object.assign({},e,{cell:t}))}static fromConfig(e,t){return new e(t)}}cb.className="ConvLSTM2D",Ma(cb);class hb extends Cm{constructor(e){super(e),this.rate=Math.max(Math.min(e.rate,1),0),this.noiseShape=e.noiseShape,this.seed=e.seed,this.supportsMasking=!0}getNoiseShape(e){if(null==this.noiseShape)return this.noiseShape;const t=e.shape,n=[];for(let e=0;e<this.noiseShape.length;++e)n.push(null==this.noiseShape[e]?t[e]:this.noiseShape[e]);return n}call(e,t){return Za(()=>{this.invokeCallHook(e,t);const n=fm(e);if(0<this.rate&&this.rate<1){const e=null!=t.training&&t.training,s=this.getNoiseShape(n);return zf(()=>Lf(n,this.rate,s,this.seed),()=>n,e)}return e})}getConfig(){const e={rate:this.rate,noiseShape:this.noiseShape,seed:this.seed},t=super.getConfig();return Object.assign(e,t),e}dispose(){return super.dispose()}}hb.className="Dropout",Ma(hb);class pb extends hb{constructor(e){super(e),this.inputSpec=[{ndim:3}]}getNoiseShape(e){const t=e.shape;return[t[0],1,t[2]]}}pb.className="SpatialDropout1D",Ma(pb);class db extends Cm{constructor(e){if(super(e),this.activation=null,this.useBias=!0,this.kernel=null,this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",null==e.batchInputShape&&null==e.inputShape&&null!=e.inputDim){let t=null;null!=e.batchSize&&(t=e.batchSize),this.batchInputShape=[t,e.inputDim]}this.units=e.units,Ud(this.units,"units"),this.activation=gy(e.activation),null!=e.useBias&&(this.useBias=e.useBias),this.kernelInitializer=im(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.biasInitializer=im(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelConstraint=ef(e.kernelConstraint),this.biasConstraint=ef(e.biasConstraint),this.kernelRegularizer=Ny(e.kernelRegularizer),this.biasRegularizer=Ny(e.biasRegularizer),this.activityRegularizer=Ny(e.activityRegularizer),this.supportsMasking=!0,this.inputSpec=[{minNDim:2}]}build(e){const t=(e=mm(e))[e.length-1];null==this.kernel&&(this.kernel=this.addWeight("kernel",[t,this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint))),this.inputSpec=[{minNDim:2,axes:{[-1]:t}}],this.built=!0}computeOutputShape(e){const t=(e=mm(e)).slice();return t[t.length-1]=this.units,t}call(e,t){return Za(()=>{this.invokeCallHook(e,t);const n=fm(e),s=Gd(this.activation.getClassName());let r;return null!=s?r=Ff(n,this.kernel.read(),s,this.bias?this.bias.read():null):(r=Ff(n,this.kernel.read()),null!=this.bias&&(r=Mf(r,this.bias.read())),null!=this.activation&&(r=this.activation.apply(r))),r})}getConfig(){const e={units:this.units,activation:fy(this.activation),useBias:this.useBias,kernelInitializer:am(this.kernelInitializer),biasInitializer:am(this.biasInitializer),kernelRegularizer:ky(this.kernelRegularizer),biasRegularizer:ky(this.biasRegularizer),activityRegularizer:ky(this.activityRegularizer),kernelConstraint:Zd(this.kernelConstraint),biasConstraint:Zd(this.biasConstraint)},t=super.getConfig();return Object.assign(e,t),e}}db.className="Dense",Ma(db);class fb extends Cm{constructor(e){super(e=e||{}),this.inputSpec=[{minNDim:3}],this.dataFormat=e.dataFormat}computeOutputShape(e){e=mm(e);for(const t of e.slice(1))if(null==t)throw new Cd(`The shape of the input to "Flatten" is not fully defined (got ${e.slice(1)}). Make sure to pass a complete "input_shape" or "batch_input_shape" argument to the first layer in your model.`);return[e[0],bf(e,1)]}call(e,t){return Za(()=>{this.invokeCallHook(e,t);let n=fm(e);if("channelsFirst"===this.dataFormat&&n.rank>1){const e=[0];for(let t=2;t<n.rank;++t)e.push(t);e.push(1),n=n.transpose(e)}return function(e){if(e.rank<=1)throw new Cd(`batchFlatten requires a minimum rank of 2. Got rank: ${e.rank}.`);const t=[e.shape[0],bf(e.shape,1)];return e.reshape(t)}(n)})}getConfig(){const e={};null!=this.dataFormat&&(e.dataFormat=this.dataFormat);const t=super.getConfig();return Object.assign(e,t),e}}fb.className="Flatten",Ma(fb);class mb extends Cm{constructor(e){super(e),this.supportsMasking=!0,this.activation=gy(e.activation)}call(e,t){return Za(()=>{this.invokeCallHook(e,t);const n=fm(e);return this.activation.apply(n)})}getConfig(){const e={activation:fy(this.activation)},t=super.getConfig();return Object.assign(e,t),e}}mb.className="Activation",Ma(mb);class gb extends Cm{constructor(e){super(e),this.n=e.n,this.inputSpec=[{ndim:2}]}computeOutputShape(e){return[e[0],this.n,e[1]]}call(e,t){return Za(()=>{return e=fm(e),t=e,n=this.n,Za(()=>{if(2!==t.shape.length)throw new Cd(`repeat() expects a rank-2 tensor, but received a rank-${t.shape.length} tensor.`);return Af(If(t,1),[1,n,1])});var t,n})}getConfig(){const e={n:this.n},t=super.getConfig();return Object.assign(e,t),e}}gb.className="RepeatVector",Ma(gb);class yb extends Cm{constructor(e){super(e),this.targetShape=e.targetShape;for(let e=0;e<this.targetShape.length;++e)this.isUnknown(this.targetShape[e])&&(this.targetShape[e]=null)}isUnknown(e){return e<0||null==e}fixUnknownDimension(e,t){const n="Total size of new array must be unchanged.",s=t.slice();let r=1,a=null;for(let e=0;e<s.length;++e){const t=s[e];if(this.isUnknown(t)){if(null!==a)throw new Cd("Can only specifiy one unknown dimension.");a=e}else r*=t}const i=bf(e);if(null!==a){if(0===r||i%r!=0)throw new Cd(n);s[a]=i/r}else if(i!==r)throw new Cd(n);return s}computeOutputShape(e){let t=!1;for(let n=0;n<e.length;++n)if(this.isUnknown(e[n])){t=!0;break}return t?e.slice(0,1).concat(this.targetShape):e.slice(0,1).concat(this.fixUnknownDimension(e.slice(1),this.targetShape))}call(e,t){return Za(()=>{this.invokeCallHook(e,t);const n=fm(e),s=n.shape,r=s.slice(0,1).concat(this.fixUnknownDimension(s.slice(1),this.targetShape));return n.reshape(r)})}getConfig(){const e={targetShape:this.targetShape},t=super.getConfig();return Object.assign(e,t),e}}yb.className="Reshape",Ma(yb);class bb extends Cm{constructor(e){if(super(e),null==e.dims)throw new Error("Required configuration field `dims` is missing during Permute constructor call.");if(!Array.isArray(e.dims))throw new Error("Permute constructor requires `dims` to be an Array, but received "+e.dims+" instead.");const t=vf(1,e.dims.length+1);if(!p(e.dims.slice().sort(),t))throw new Error("Invalid permutation `dims`: "+JSON.stringify(e.dims)+" `dims` must contain consecutive integers starting from 1.");this.dims=e.dims,this.dimsIncludingBatch=[0].concat(this.dims),this.inputSpec=[new wm({ndim:this.dims.length+1})]}computeOutputShape(e){const t=(e=mm(e)).slice();return this.dims.forEach((n,s)=>{t[s+1]=e[n]}),t}call(e,t){return ra(fm(e),this.dimsIncludingBatch)}getConfig(){const e={dims:this.dims},t=super.getConfig();return Object.assign(e,t),e}}bb.className="Permute",Ma(bb);class xb extends Cm{constructor(e){super(null==e?{}:e),this.supportsMasking=!0,this.maskValue=null!=e?null==e.maskValue?0:e.maskValue:0}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={maskValue:this.maskValue};return Object.assign(t,e),t}computeMask(e,t){const n=fm(e);return wi(Wl(n,this.maskValue),-1)}call(e,t){return Za(()=>{this.invokeCallHook(e,t);const n=fm(e),s=wi(Wl(n,this.maskValue),-1,!0);return n.mul(s.asType(n.dtype))})}}xb.className="Masking",Ma(xb);class wb extends Cm{constructor(e){if(super(e),this.embeddings=null,this.DEFAULT_EMBEDDINGS_INITIALIZER="randomUniform",null==e.batchInputShape&&null==e.inputShape){let t=null;null!=e.batchSize&&(t=e.batchSize),null==e.inputLength?this.batchInputShape=[t,null]:this.batchInputShape=[t].concat(Fd(e.inputLength))}this.inputDim=e.inputDim,Ud(this.inputDim,"inputDim"),this.outputDim=e.outputDim,Ud(this.outputDim,"outputDim"),this.embeddingsInitializer=im(e.embeddingsInitializer||this.DEFAULT_EMBEDDINGS_INITIALIZER),this.embeddingsRegularizer=Ny(e.embeddingsRegularizer),this.activityRegularizer=Ny(e.activityRegularizer),this.embeddingsConstraint=ef(e.embeddingsConstraint),this.maskZero=e.maskZero,this.supportsMasking=e.maskZero,this.inputLength=e.inputLength}build(e){this.embeddings=this.addWeight("embeddings",[this.inputDim,this.outputDim],this.dtype,this.embeddingsInitializer,this.embeddingsRegularizer,!0,this.embeddingsConstraint),this.built=!0}warnOnIncompatibleInputShape(e){}computeMask(e,t){return Za(()=>this.maskZero?(e=fm(e),Wl(e,$o(e))):null)}computeOutputShape(e){if(e=mm(e),null==this.inputLength)return[...e,this.outputDim];const t=Fd(this.inputLength);if(t.length!==e.length-1)throw new Cd(`"inputLength" is ${this.inputLength}, but received input shape has shape `+e);{let n=0;for(let s=0;s<t.length;++s){const r=t[s],a=e[s+1];if(null!=r&&null!=a&&r!==a)throw new Cd(`"inputLength" is ${this.inputLength}, but received input shape has shape `+e);null==r&&(t[n]=a),n++}}return[e[0],...t,this.outputDim]}call(e,t){return Za(()=>{this.invokeCallHook(e,t);let n=fm(e);return"int32"!==n.dtype&&(n=Nf(n,"int32")),Df(this.embeddings.read(),n.as1D()).reshape(mm(this.computeOutputShape(n.shape)))})}getConfig(){const e={inputDim:this.inputDim,outputDim:this.outputDim,embeddingsInitializer:am(this.embeddingsInitializer),embeddingsRegularizer:ky(this.embeddingsRegularizer),activityRegularizer:ky(this.activityRegularizer),embeddingsConstraint:Zd(this.embeddingsConstraint),maskZero:this.maskZero,inputLength:this.inputLength},t=super.getConfig();return Object.assign(e,t),e}}wb.className="Embedding",Ma(wb);class kb extends Cm{constructor(e){super(e||{}),this.supportsMasking=!0}mergeFunction(e){throw new Sd}computeElementwiseOpOutputShape(e,t){if(null==e||null==t)return null;if(e.length<t.length)return this.computeElementwiseOpOutputShape(t,e);if(0===t.length)return e;const n=e.slice(0,e.length-t.length);for(let s=0;s<t.length;++s){const r=e[e.length-t.length+s],a=t[s];if(null==r||null==a||r<0||a<0)n.push(null);else if(1===r)n.push(a);else if(1===a)n.push(r);else{if(r!==a)throw new Cd("Operands could not be broadcast together with shapes "+JSON.stringify(e)+" "+JSON.stringify(t));n.push(r)}}return n}build(e){if(Array.isArray(e)&&!Array.isArray(e[0])&&(e=[mm(e)]),(e=e).length<2)throw new Cd(`A merge layer should be called on an Array of at least 2 inputs. Got ${e.length} input(s).`);let t=[];for(const n of e)null!=n&&null!==n[0]&&t.push(n[0]);if(t=Bd(t),t.length>1)throw new Cd(`Can not merge tensors with different batch sizes. Got tensors with shapes: ${JSON.stringify(e)}.`);let n=null==e[0]?null:e[0].slice(1);for(let t=1;t<e.length;++t){const s=null==e[t]?null:e[t].slice(1);n=this.computeElementwiseOpOutputShape(n,s)}const s=e.map(e=>e.length);-1===e.indexOf(null)&&1===Bd(s).length?this.reshapeRequired=!1:this.reshapeRequired=!0}call(e,t){return Za(()=>{if(e=e,this.reshapeRequired){const t=[],n=e.map(e=>e.rank);if(-1===n.indexOf(null)){const s=kf(n);for(let n of e){const e=n.rank;for(let t=0;t<s-e;++t)n=If(n,1);t.push(n)}return this.mergeFunction(t)}{let n=!1;for(const s of e){const e=s.rank;if(null==e){const e=s.shape,r=e[0],a=e.slice(1).concat([r]);let i=s.reshape([r].concat(bf(e.slice(1))));i=ra(i,[1,0]),i=i.reshape(a),t.push(i),n=!0}else if(e>1){const r=vf(1,e).concat([0]);t.push(ra(s,r)),n=!0}else t.push(s)}let s=this.mergeFunction(t);const r=s.rank;if(n)if(null==r){const e=s.shape,t=e[e.length-1],n=[t].concat(e.slice(0,e.length-1));s=ra(s.reshape([-1,t]),[1,0]).reshape(n)}else if(r>1){const e=[r-1].concat(vf(0,r-1));s=ra(s,e)}return s}}return this.mergeFunction(e)})}computeOutputShape(e){let t;t=null==(e=e)[0]?null:e[0].slice(1);for(let n=1;n<e.length;++n){const s=null==e[n]?null:e[n].slice(1);t=this.computeElementwiseOpOutputShape(t,s)}let n=[];for(const t of e)null!=t&&null!==t[0]&&n.push(t[0]);return n=Bd(n),t=1===n.length?n.concat(t):[null].concat(t),t}computeMask(e,t){return Za(()=>{if(null==t)return null;if(!Array.isArray(t))throw new Cd("`mask` should be an Array");if(!Array.isArray(e))throw new Cd("`inputs` should be an Array");if(t.length!==e.length)throw new Cd(`The Array 'inputs' and 'mask' are expected to have the same length, but have different lengths (${e.length} vs ${t.length})`);if(t.every(e=>null==e))return null;let n=(t=t.map(e=>null==e?e:Oo(e,0)))[0];for(let e=1;e<t.length-1;++e)n=Il(n,t[e]);return n})}}class vb extends kb{constructor(e){super(e)}mergeFunction(e){return Za(()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=hi(t,e[n]);return t})}}vb.className="Add",Ma(vb);class Nb extends kb{constructor(e){super(e)}mergeFunction(e){return Za(()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=fi(t,e[n]);return t})}}Nb.className="Multiply",Ma(Nb);class Ib extends kb{constructor(e){super(e)}mergeFunction(e){return Za(()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=hi(t,e[n]);return fi(1/e.length,t)})}}Ib.className="Average",Ma(Ib);class Cb extends kb{constructor(e){super(e)}mergeFunction(e){return Za(()=>{let t=e[0];for(let n=1;n<e.length;++n)t=Rl(t,e[n]);return t})}}Cb.className="Maximum",Ma(Cb);class Sb extends kb{constructor(e){super(e)}mergeFunction(e){return Za(()=>{let t=e[0];for(let n=1;n<e.length;++n)t=_l(t,e[n]);return t})}}Sb.className="Minimum",Ma(Sb);class Tb extends kb{constructor(e){super(e),this.DEFAULT_AXIS=-1,null==e&&(e={}),this.axis=null==e.axis?this.DEFAULT_AXIS:e.axis,this.supportsMasking=!0,this.reshapeRequired=!1}build(e){if(!Array.isArray(e)||!Array.isArray(e[0])||1===e.length)throw new Cd("A `Concatenate` layer should be called on a list of at least 2 inputs");e=e;let t=!0;for(const n of e)if(null!=n){t=!1;break}if(t)return;const n=[];for(let t=0;t<e.length;++t){const s=e[t].slice();s.splice(this.axis,1);let r=!1;for(const e of n)if(p(e,s)){r=!0;break}r||n.push(s)}if(n.length>1)throw new Cd("A `Concatenate` layer requires inputs with matching shapes except for the concat axis. Got input shapes: "+JSON.stringify(e))}mergeFunction(e){return Za(()=>Ef(e,this.axis))}computeOutputShape(e){if(!Array.isArray(e)||!Array.isArray(e[0]))throw new Cd("A `Concatenate` layer should be called on a list of inputs.");const t=e,n=t[0].slice(),s=this.axis<0?n.length+this.axis:this.axis;for(const e of t.slice(1)){if(null==n[s]||null==e[s]){n[s]=null;break}n[s]+=e[s]}return n}computeMask(e,t){if(null==t)return null;if(!Array.isArray(t))throw new Cd("`mask` should be an array for Concatenate");if(!Array.isArray(e))throw new Cd("`inputs` should be an array for Concatenate");if(t.length!==e.length)throw new Cd(`Mismatch in the length of mask (${t.length}) and the legnth of inputs (${e.length})`);return Za(()=>{let n=!0;if(t.forEach(e=>{null==e||(n=!1)}),n)return null;const s=[];for(let n=0;n<e.length;++n)null==t[n]?s.push(Gl(e[n]).asType("bool")):t[n].rank<e[n].rank?s.push(Oo(t[n],-1)):s.push(t[n]);const r=Gi(s,this.axis);return xi(r,-1,!1)})}getConfig(){const e={axis:this.axis},t=super.getConfig();return Object.assign(e,t),e}}function Eb(e,t){for(;e<0;)e+=t;return e}Tb.className="Concatenate",Ma(Tb);class $b extends kb{constructor(e){super(e),this.axes=e.axes,this.normalize=null!=e.normalize&&e.normalize,this.supportsMasking=!0,this.reshapeRequired=!1}build(e){o(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),()=>"A `Dot` layer should be called on a list of exactly 2 inputs.");const t=e[0],n=e[1];if(t.length>3||n.length>3)throw new Sd("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(t,n);if(t[s[0]]!==n[s[1]])throw new Cd(`Dimension incompatibility: ${t[s[0]]} !== ${n[s[1]]}`)}mergeFunction(e){if(2!==e.length)throw new Cd(`A \`Dot\` layer must be called on exactly 2 inputs, but received ${e.length} input(s).`);let t,n=e[0],s=e[1];return t=Array.isArray(this.axes)?this.axes.map((t,n)=>Eb(t,e[n].shape.length)):[Eb(this.axes,n.shape.length),Eb(this.axes,s.shape.length)],this.normalize&&(n=Pm(n,t[0]),s=Pm(s,t[1])),function(e,t,n){if(e.shape.length>3||t.shape.length>3)throw new Sd("batchDot is not implemented for tensors of 4D or higher rank yet");if(o(e.shape.length>=2,()=>"batchDot requires the rank of x to be >= 2, but got "+e.shape.length),o(e.shape.length>=2,()=>"batchDot requires the rank of y to be >= 2, but got "+t.shape.length),"number"==typeof n&&(n=[n,n]),"complex64"===e.dtype||"complex64"===t.dtype)throw new Sd("batchDot is not implemented for complex64-type Tensors yet.");const s=e.shape.length,r=t.shape.length;null==n&&(n=[s-1,r-2]);const a=n;return Za(()=>{let n,i;if(s>r){n=s-r;const e=[];for(let t=0;t<n;++t)e.push(1);t=t.reshape(t.shape.concat(e))}else if(r>s){n=r-s;const t=[];for(let e=0;e<n;++e)t.push(1);e=e.reshape(e.shape.concat(t))}else n=0;if(2===e.shape.length&&2===t.shape.length)i=a[0]===a[1]?e.mul(t).sum(a[0]):e.transpose([1,0]).mul(t).sum(a[1]);else{const n=a[0]!==e.shape.length-1,s=a[1]===t.shape.length-1;i=e.matMul(t,n,s)}if(n>0){let e;e=s>r?s+r-3:s-1;const t=[];for(let s=e;s<e+n;++s)t.push(s);i=i.squeeze(t)}return 1===i.shape.length&&(i=i.expandDims(1)),i})}(n,s,t)}interpretAxes(e,t){let n;return n=Array.isArray(this.axes)?this.axes:[Eb(this.axes,e.length),Eb(this.axes,t.length)],n}computeOutputShape(e){o(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),()=>"A `Dot` layer should be called on a list of exactly 2 inputs.");const t=e[0].slice(),n=e[1].slice();if(t.length>3||n.length>3)throw new Sd("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(t,n);t.splice(s[0],1),n.splice(s[1],1),n.splice(0,1);const r=t.concat(n);return 1===r.length&&r.push(1),r}computeMask(e,t){return null}getConfig(){const e={axes:this.axes,normalize:this.normalize},t=super.getConfig();return Object.assign(e,t),e}}$b.className="Dot",Ma($b);class Ab extends Cm{constructor(e){super(e),this.supportsMasking=!0,this.stddev=e.stddev}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={stddev:this.stddev};return Object.assign(t,e),t}call(e,t){return Za(()=>{this.invokeCallHook(e,t);const n=fm(e);return zf(()=>Rf(n.shape,0,this.stddev).add(n),()=>n,t.training||!1)})}}Ab.className="GaussianNoise",Ma(Ab);class Rb extends Cm{constructor(e){super(e),this.supportsMasking=!0,this.rate=e.rate}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={rate:this.rate};return Object.assign(t,e),t}call(e,t){return Za(()=>{this.invokeCallHook(e,t);const n=fm(e);if(this.rate>0&&this.rate<1){return zf(()=>{const e=Math.sqrt(this.rate/(1-this.rate));return n.mul(Rf(n.shape,1,e))},()=>n,t.training||!1)}return n})}}Rb.className="GaussianDropout",Ma(Rb);class Fb extends Cm{constructor(e){super(e),this.supportsMasking=!0,this.rate=e.rate,this.noiseShape=e.noiseShape}_getNoiseShape(e){return this.noiseShape||fm(e).shape}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={rate:this.rate};return Object.assign(t,e),t}call(e,t){return Za(()=>{if(this.rate<1&&this.rate>0){const n=this._getNoiseShape(e);return zf(()=>{const t=fm(e),s=-1.7580993408473766;let r=Uo(yu(n),this.rate);r=Nf(r,"float32");const a=((1-this.rate)*(1+this.rate*s**2))**-.5,i=-a*s*this.rate;return t.mul(r).add(r.add(-1).mul(s)).mul(a).add(i)},()=>fm(e),t.training||!1)}return e})}}function Db(e,t,n,s,r,a=.001){let i;if(2===e.rank)i=Ji(e,t,n,s,r,a);else if(3===e.rank)i=Zi(e,t,n,s,r,a);else{if(4!==e.rank)throw new Sd(`batchNormalization is not implemented for array of rank ${e.rank} yet`);i=Qi(e,t,n,s,r,a)}return i}function _b(e,t,n,s,r=.001){return p(s.slice().sort(),vf(0,e.rank-1))?function(e,t,n,s,r=.001){return Za(()=>{const a=zl(e,s),i=a.mean,o=a.variance;return[Db(e,i,o,n,t,r),i,o]})}(e,t,n,s,r):function(e,t,n,s,r=.001){return Za(()=>{const a=zl(e,s),i=a.mean,o=a.variance,l=[];for(const t of vf(0,e.rank))-1!==s.indexOf(t)?l.push(1):l.push(e.shape[t]);const u=i.reshape(l),c=o.reshape(l),h=null==t?null:t.reshape(l),p=null==n?null:n.reshape(l);return[Db(e,u,c,p,h,r),i,o]})}(e,t,n,s,r)}Fb.className="AlphaDropout",Ma(Fb);class Ob extends Cm{constructor(e){null==e&&(e={}),super(e),this.supportsMasking=!0,this.axis=null==e.axis?-1:e.axis,this.momentum=null==e.momentum?.99:e.momentum,this.epsilon=null==e.epsilon?.001:e.epsilon,this.center=null==e.center||e.center,this.scale=null==e.scale||e.scale,this.betaInitializer=im(e.betaInitializer||"zeros"),this.gammaInitializer=im(e.gammaInitializer||"ones"),this.movingMeanInitializer=im(e.movingMeanInitializer||"zeros"),this.movingVarianceInitializer=im(e.movingVarianceInitializer||"ones"),this.betaConstraint=ef(e.betaConstraint),this.gammaConstraint=ef(e.gammaConstraint),this.betaRegularizer=Ny(e.betaRegularizer),this.gammaRegularizer=Ny(e.gammaRegularizer)}build(e){e=mm(e);const t=this.axis>=0?this.axis:this.axis+e.length,n=e[t];if(null==n)throw new Cd(`Axis ${t} of input tensor should have a defined dimension but the layer received an input with shape `+JSON.stringify(e)+".");this.inputSpec=[new wm({ndim:e.length,axes:{[t]:n}})];const s=[n];this.scale&&(this.gamma=this.addWeight("gamma",s,null,this.gammaInitializer,this.gammaRegularizer,!0,this.gammaConstraint)),this.center&&(this.beta=this.addWeight("beta",s,null,this.betaInitializer,this.betaRegularizer,!0,this.betaConstraint)),this.movingMean=this.addWeight("moving_mean",s,null,this.movingMeanInitializer,null,!1),this.movingVariance=this.addWeight("moving_variance",s,null,this.movingVarianceInitializer,null,!1),this.built=!0}call(e,t){return Za(()=>{const n=null!=t.training&&t.training,s=fm(e),r=s.shape,a=r.length,i=vf(0,a),o=this.axis>=0?this.axis:this.axis+a;i.splice(o,1);const l=Ed(1,a);l[o]=r[o];const u=i.slice();u.sort();const c=!p(u,vf(0,a).slice(0,a-1));if(!n)return(()=>{if(c){const e=this.movingMean.read().reshape(l),t=this.movingVariance.read().reshape(l),n=this.center?this.beta.read().reshape(l):null,r=this.scale?this.gamma.read().reshape(l):null;return Db(s,e,t,n,r,this.epsilon)}return Db(s,this.movingMean.read(),this.movingVariance.read(),null==this.beta?null:this.beta.read(),null==this.gamma?null:this.gamma.read(),this.epsilon)})();const[h,d,f]=_b(s,this.gamma.read(),this.beta.read(),i,this.epsilon),m=(e,t,n)=>{Za(()=>{const s=1-n,r=e.read(),a=r.sub(t).mul(s);e.write(r.sub(a))})};return(()=>{m(this.movingMean,d,this.momentum),m(this.movingVariance,f,this.momentum)})(),h})}getConfig(){const e={axis:this.axis,momentum:this.momentum,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:am(this.betaInitializer),gammaInitializer:am(this.gammaInitializer),movingMeanInitializer:am(this.movingMeanInitializer),movingVarianceInitializer:am(this.movingVarianceInitializer),betaRegularizer:ky(this.betaRegularizer),gammaRegularizer:ky(this.gammaRegularizer),betaConstraint:Zd(this.betaConstraint),gammaConstraint:Zd(this.gammaConstraint)},t=super.getConfig();return Object.assign(e,t),e}}Ob.className="BatchNormalization",Ma(Ob);class Mb extends Cm{constructor(e){if(null==e&&(e={}),super(e),this.axis=null==e.axis?-1:e.axis,"number"==typeof this.axis){if(!Number.isInteger(this.axis))throw new Error("Expected axis to be an integer, but received "+this.axis)}else{if(!Array.isArray(this.axis))throw new Error("Expected axis to be an integer or an array of integers, but received "+JSON.stringify(this.axis));for(const e of this.axis)if(!Number.isInteger(e))throw new Error("Expected axis to be an array of integers, but received "+JSON.stringify(this.axis))}this.epsilon=null==e.epsilon?.001:e.epsilon,this.center=null==e.center||e.center,this.scale=null==e.scale||e.scale,this.betaInitializer=im(e.betaInitializer||"zeros"),this.gammaInitializer=im(e.gammaInitializer||"ones"),this.betaRegularizer=Ny(e.betaRegularizer),this.gammaRegularizer=Ny(e.gammaRegularizer),this.supportsMasking=!0}build(e){const t=(e=mm(e)).length;"number"==typeof this.axis&&(this.axis=[this.axis]);for(let e=0;e<this.axis.length;++e)this.axis[e]<0&&(this.axis[e]+=t);for(const e of this.axis)if(e<0||e>=t)throw new Error("Invalid axis: "+e);if(this.axis.length!==Bd(this.axis).length)throw new Error("Found duplicate axes in: "+this.axis);const n=this.axis.map(t=>e[t]);this.scale?this.gamma=this.addWeight("gamma",n,"float32",this.gammaInitializer,this.gammaRegularizer,!0):this.gamma=null,this.center?this.beta=this.addWeight("beta",n,"float32",this.betaInitializer,this.betaRegularizer,!0):this.beta=null,this.built=!0}call(e,t){const n=fm(e),s=n.shape,r=s.length;return Za(()=>{let{mean:e,variance:t}=zl(n,this.axis,!0);const a=Ed(1,r);for(const e of this.axis)a[e]=s[e];const i=e=>null!=e&&e.shape.length!==r&&this.axis!==[r-1]?e.reshape(a):e;let o=i(this.gamma.read()),l=i(this.beta.read());const u=[],c=[];for(let e=0;e<r;++e)-1!==this.axis.indexOf(e)?(u.push(s[e]),c.push(1)):(u.push(1),c.push(s[e]));return e=e.tile(u),t=t.tile(u),o=o.tile(c),l=l.tile(c),Db(n,e,t,l,o,this.epsilon)})}getConfig(){const e={axis:this.axis,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:am(this.betaInitializer),gammaInitializer:am(this.gammaInitializer),betaRegularizer:ky(this.betaRegularizer),gammaRegularizer:ky(this.gammaRegularizer)},t=super.getConfig();return Object.assign(e,t),e}}Mb.className="LayerNormalization",Ma(Mb);class Lb extends Cm{constructor(e){if(null==e&&(e={}),super(e),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,null==e.padding)this.padding=[[1,1],[1,1]];else if("number"==typeof e.padding)this.padding=[[e.padding,e.padding],[e.padding,e.padding]];else{if(e.padding=e.padding,2!==e.padding.length)throw new Cd(`ZeroPadding2D expects padding to be a length-2 array, but received a length-${e.padding.length} array.`);let t,n;if("number"==typeof e.padding[0])t=[e.padding[0],e.padding[0]],n=[e.padding[1],e.padding[1]];else{if(e.padding=e.padding,2!==e.padding[0].length)throw new Cd(`ZeroPadding2D expects height padding to be a length-2 array, but received a length-${e.padding[0].length} array.`);if(t=e.padding[0],2!==e.padding[1].length)throw new Cd(`ZeroPadding2D expects width padding to be a length-2 array, but received a length-${e.padding[1].length} array.`);n=e.padding[1]}this.padding=[t,n]}this.inputSpec=[new wm({ndim:4})]}computeOutputShape(e){let t,n;return e=mm(e),"channelsFirst"===this.dataFormat?(t=null!=e[2]&&e[2]>=0?e[2]+this.padding[0][0]+this.padding[0][1]:null,n=null!=e[3]&&e[3]>=0?e[3]+this.padding[1][0]+this.padding[1][1]:null,[e[0],e[1],t,n]):(t=null!=e[1]&&e[1]>=0?e[1]+this.padding[0][0]+this.padding[0][1]:null,n=null!=e[2]&&e[2]>=0?e[2]+this.padding[1][0]+this.padding[1][1]:null,[e[0],t,n,e[3]])}call(e,t){return Za(()=>{return t=fm(e),n=this.padding,s=this.dataFormat,Za(()=>{if(4!==t.rank)throw new Cd("temporalPadding expects input tensor to be 4-D, but received a "+t.rank+"-D tensor.");if(null==n&&(n=[[1,1],[1,1]]),2!==n.length||2!==n[0].length||2!==n[1].length)throw new Cd("spatial2dPadding expects `padding` to be an Array of two Arrays, each of which is an Array of two integers.");if(null==s&&(s="channelsLast"),"channelsLast"!==s&&"channelsFirst"!==s)throw new Cd(`Unknown data format: ${s}. Supported data formats are 'channelsLast' and 'channelsFirst.`);let e;return e="channelsFirst"===s?[[0,0],[0,0],n[0],n[1]]:[[0,0],n[0],n[1],[0,0]],jl(t,e)});var t,n,s})}getConfig(){const e={padding:this.padding,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}function zb(e,t,n,s,r,a){return Za(()=>{let i;uf(r),hf(a),cf(s),null==n&&(n=[1,1]),null==s&&(s="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),e=Dy(e,r);const o="same"===s?"same":"valid";return i="max"===a?El(e,t,n,o):Vi(e,t,n,o),"channelsFirst"===r&&(i=ra(i,[0,3,1,2])),i})}function Bb(e,t,n,s,r,a){return Za(()=>{let i;uf(r),hf(a),cf(s),null==n&&(n=[1,1,1]),null==s&&(s="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),e=_y(e,r);const o="same"===s?"same":"valid";return i="max"===a?$l(e,t,n,o):Ui(e,t,n,o),"channelsFirst"===r&&(i=ra(i,[0,4,1,2,3])),i})}Lb.className="ZeroPadding2D",Ma(Lb);class Pb extends Cm{constructor(e){if(null==e.poolSize&&(e.poolSize=2),super(e),"number"==typeof e.poolSize)this.poolSize=[e.poolSize];else{if(!Array.isArray(e.poolSize)||1!==e.poolSize.length||"number"!=typeof e.poolSize[0])throw new Cd("poolSize for 1D convolutional layer must be a number or an Array of a single number, but received "+JSON.stringify(e.poolSize));this.poolSize=e.poolSize}if(Ud(this.poolSize,"poolSize"),null==e.strides)this.strides=this.poolSize;else if("number"==typeof e.strides)this.strides=[e.strides];else{if(!Array.isArray(e.strides)||1!==e.strides.length||"number"!=typeof e.strides[0])throw new Cd("strides for 1D convolutional layer must be a number or an Array of a single number, but received "+JSON.stringify(e.strides));this.strides=e.strides}Ud(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,cf(this.padding),this.inputSpec=[new wm({ndim:3})]}computeOutputShape(e){const t=Ry((e=mm(e))[1],this.poolSize[0],this.padding,this.strides[0]);return[e[0],t,e[2]]}call(e,t){return Za(()=>{this.invokeCallHook(e,t),e=If(fm(e),2);const n=this.poolingFunction(fm(e),[this.poolSize[0],1],[this.strides[0],1],this.padding,"channelsLast");return Xu(n,[2])})}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides},t=super.getConfig();return Object.assign(e,t),e}}class Wb extends Pb{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return uf(r),cf(s),zb(e,t,n,s,r,"max")}}Wb.className="MaxPooling1D",Ma(Wb);class Vb extends Pb{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return uf(r),cf(s),zb(e,t,n,s,r,"avg")}}Vb.className="AveragePooling1D",Ma(Vb);class Ub extends Cm{constructor(e){if(null==e.poolSize&&(e.poolSize=[2,2]),super(e),this.poolSize=Array.isArray(e.poolSize)?e.poolSize:[e.poolSize,e.poolSize],null==e.strides)this.strides=this.poolSize;else if(Array.isArray(e.strides)){if(2!==e.strides.length)throw new Cd("If the strides property of a 2D pooling layer is an Array, it is expected to have a length of 2, but received length "+e.strides.length+".");this.strides=e.strides}else this.strides=[e.strides,e.strides];Ud(this.poolSize,"poolSize"),Ud(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,uf(this.dataFormat),cf(this.padding),this.inputSpec=[new wm({ndim:4})]}computeOutputShape(e){e=mm(e);let t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2];return t=Ry(t,this.poolSize[0],this.padding,this.strides[0]),n=Ry(n,this.poolSize[1],this.padding,this.strides[1]),"channelsFirst"===this.dataFormat?[e[0],e[1],t,n]:[e[0],t,n,e[3]]}call(e,t){return Za(()=>(this.invokeCallHook(e,t),this.poolingFunction(fm(e),this.poolSize,this.strides,this.padding,this.dataFormat)))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class Gb extends Ub{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return uf(r),cf(s),zb(e,t,n,s,r,"max")}}Gb.className="MaxPooling2D",Ma(Gb);class Hb extends Ub{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return uf(r),cf(s),zb(e,t,n,s,r,"avg")}}Hb.className="AveragePooling2D",Ma(Hb);class jb extends Cm{constructor(e){if(null==e.poolSize&&(e.poolSize=[2,2,2]),super(e),this.poolSize=Array.isArray(e.poolSize)?e.poolSize:[e.poolSize,e.poolSize,e.poolSize],null==e.strides)this.strides=this.poolSize;else if(Array.isArray(e.strides)){if(3!==e.strides.length)throw new Cd("If the strides property of a 3D pooling layer is an Array, it is expected to have a length of 3, but received length "+e.strides.length+".");this.strides=e.strides}else this.strides=[e.strides,e.strides,e.strides];Ud(this.poolSize,"poolSize"),Ud(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,uf(this.dataFormat),cf(this.padding),this.inputSpec=[new wm({ndim:5})]}computeOutputShape(e){e=mm(e);let t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2],s="channelsFirst"===this.dataFormat?e[4]:e[3];return t=Ry(t,this.poolSize[0],this.padding,this.strides[0]),n=Ry(n,this.poolSize[1],this.padding,this.strides[1]),s=Ry(s,this.poolSize[2],this.padding,this.strides[2]),"channelsFirst"===this.dataFormat?[e[0],e[1],t,n,s]:[e[0],t,n,s,e[4]]}call(e,t){return Za(()=>(this.invokeCallHook(e,t),this.poolingFunction(fm(e),this.poolSize,this.strides,this.padding,this.dataFormat)))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class qb extends jb{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return uf(r),cf(s),Bb(e,t,n,s,r,"max")}}qb.className="MaxPooling3D",Ma(qb);class Kb extends jb{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return uf(r),cf(s),Bb(e,t,n,s,r,"avg")}}Kb.className="AveragePooling3D",Ma(Kb);class Xb extends Cm{constructor(e){super(e),this.inputSpec=[new wm({ndim:3})]}computeOutputShape(e){return[e[0],e[2]]}call(e,t){throw new Sd}}class Yb extends Xb{constructor(e){super(e||{})}call(e,t){return Za(()=>{const t=fm(e);return Fl(t,1)})}}Yb.className="GlobalAveragePooling1D",Ma(Yb);class Jb extends Xb{constructor(e){super(e||{})}call(e,t){return Za(()=>{const t=fm(e);return hl(t,1)})}}Jb.className="GlobalMaxPooling1D",Ma(Jb);class Zb extends Cm{constructor(e){super(e),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,uf(this.dataFormat),this.inputSpec=[new wm({ndim:4})]}computeOutputShape(e){return e=e,"channelsLast"===this.dataFormat?[e[0],e[3]]:[e[0],e[1]]}call(e,t){throw new Sd}getConfig(){const e={dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class Qb extends Zb{call(e,t){return Za(()=>{const t=fm(e);return"channelsLast"===this.dataFormat?Fl(t,[1,2]):Fl(t,[2,3])})}}Qb.className="GlobalAveragePooling2D",Ma(Qb);class ex extends Zb{call(e,t){return Za(()=>{const t=fm(e);return"channelsLast"===this.dataFormat?hl(t,[1,2]):hl(t,[2,3])})}}ex.className="GlobalMaxPooling2D",Ma(ex);class tx extends Cm{constructor(e){super(e),this.layer=e.layer}build(e){this.built=!0}get trainable(){return null!=this.layer&&this.layer.trainable}set trainable(e){null!=this.layer&&(this.layer.trainable=e)}get trainableWeights(){return this.layer.trainableWeights}get nonTrainableWeights(){return this.layer.nonTrainableWeights}get updates(){return this.layer._updates}get losses(){return this.layer.losses}getWeights(){return this.layer.getWeights()}setWeights(e){this.layer.setWeights(e)}getConfig(){const e={layer:{className:this.layer.getClassName(),config:this.layer.getConfig()}},t=super.getConfig();return Object.assign(e,t),e}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.layer&&this.layer.setFastWeightInitDuringBuild(e)}static fromConfig(e,t,n={}){const s=Bm(t.layer,n);delete t.layer;const r={layer:s};return Object.assign(r,t),new e(r)}}class nx extends tx{constructor(e){super(e),this.supportsMasking=!0}build(e){if((e=mm(e)).length<3)throw new Cd("TimeDistributed layer expects an input shape >= 3D, but received input shape "+JSON.stringify(e));this.inputSpec=[{shape:e}];const t=[e[0]].concat(e.slice(2));this.layer.built||(this.layer.build(t),this.layer.built=!0),super.build(e)}computeOutputShape(e){const t=[(e=mm(e))[0]].concat(e.slice(2)),n=this.layer.computeOutputShape(t),s=e[1];return[n[0],s].concat(n.slice(1))}call(e,t){return Za(()=>Yy((e,n)=>[fm(this.layer.call(e,t)),[]],e=fm(e),[],!1,null,null,!1,!0)[1])}}nx.className="TimeDistributed",Ma(nx);class sx extends tx{constructor(e){super(e);const t=e.layer.getConfig(),n={};n.className=e.layer.getClassName(),n.config=t,this.forwardLayer=Bm(n),t.goBackwards=!0!==t.goBackwards;const s={};var r;if(s.className=e.layer.getClassName(),s.config=t,this.backwardLayer=Bm(s),this.forwardLayer.name="forward_"+this.forwardLayer.name,this.backwardLayer.name="backward_"+this.backwardLayer.name,this.mergeMode=void 0===e.mergeMode?"concat":e.mergeMode,r=this.mergeMode,Wd(of,"BidirectionalMergeMode",r),e.weights)throw new Sd("weights support is not implemented for Bidirectional layer yet.");this._stateful=e.layer.stateful,this.returnSequences=e.layer.returnSequences,this.returnState=e.layer.returnState,this.supportsMasking=!0,this._trainable=!0,this.inputSpec=e.layer.inputSpec,this.numConstants=null}get trainable(){return this._trainable}set trainable(e){this._trainable=e,null!=this.forwardLayer&&(this.forwardLayer.trainable=e),null!=this.backwardLayer&&(this.backwardLayer.trainable=e)}getWeights(){return this.forwardLayer.getWeights().concat(this.backwardLayer.getWeights())}setWeights(e){const t=e.length,n=Math.floor(t/2);this.forwardLayer.setWeights(e.slice(0,n)),this.backwardLayer.setWeights(e.slice(n))}computeOutputShape(e){let t,n,s,r=this.forwardLayer.computeOutputShape(e);return Array.isArray(r)&&Array.isArray(r[0])||(r=[r]),r=r,this.returnState?(s=r.slice(1),t=r[0]):t=r[0],t=t,"concat"===this.mergeMode?(t[t.length-1]*=2,n=[t]):n=null==this.mergeMode?[t,t.slice()]:[t],this.returnState?null==this.mergeMode?n.concat(s).concat(s.slice()):[t].concat(s).concat(s.slice()):Rd(n)}apply(e,t){let n=null==t?null:t.initialState,s=null==t?null:t.constants;null==t&&(t={});const r=Xy(e,n,s,this.numConstants);if(e=r.inputs,n=r.initialState,s=r.constants,Array.isArray(e)&&(n=e.slice(1),e=e[0]),(null==n||0===n.length)&&null==s)return super.apply(e,t);const a=[],i=[];if(null!=n){const e=n.length;if(e%2>0)throw new Cd("When passing `initialState` to a Bidrectional RNN, the state should be an Array containing the states of the underlying RNNs.");t.initialState=n,a.push(...n);const s=n.map(e=>new wm({shape:e.shape}));this.forwardLayer.stateSpec=s.slice(0,e/2),this.backwardLayer.stateSpec=s.slice(e/2),i.push(...s)}if(null!=s)throw new Sd("Support for constants in Bidirectional layers is not implemented yet.");const o=a[0]instanceof km;for(const e of a)if(e instanceof km!==o)throw new Cd("The initial state of a Bidirectional layer cannot be specified as a mix of symbolic and non-symbolic tensors");if(o){const n=[e].concat(a),s=this.inputSpec.concat(i),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,t);return this.inputSpec=r,o}return super.apply(e,t)}call(e,t){return Za(()=>{const n=t.initialState;let s,r,a,i;if(null==n)s=this.forwardLayer.call(e,t),r=this.backwardLayer.call(e,t);else{const a=n.slice(0,n.length/2),i=n.slice(n.length/2);s=this.forwardLayer.call(e,Object.assign(t,{initialState:a})),r=this.backwardLayer.call(e,Object.assign(t,{initialState:i}))}return this.returnState&&(Array.isArray(s)&&(a=s.slice(1).concat(r.slice(1))),s=s[0],r=r[0]),this.returnSequences&&(r=Nu(r,1)),"concat"===this.mergeMode?i=Ef([s,r]):"sum"===this.mergeMode?i=hi(s,r):"ave"===this.mergeMode?i=fi(.5,hi(s,r)):"mul"===this.mergeMode?i=fi(s,r):null==this.mergeMode&&(i=[s,r]),this.returnState?null==this.mergeMode?i.concat(a):[i].concat(a):i})}resetStates(e){this.forwardLayer.resetStates(),this.backwardLayer.resetStates()}build(e){df(this.forwardLayer.name,()=>{this.forwardLayer.build(e)}),df(this.backwardLayer.name,()=>{this.backwardLayer.build(e)}),this.built=!0}computeMask(e,t){let n;if(Array.isArray(t)&&(t=t[0]),n=this.returnSequences?null==this.mergeMode?[t,t]:t:null==this.mergeMode?[null,null]:null,this.returnState){const e=this.forwardLayer.states.map(e=>null);return Array.isArray(n)?n.concat(e).concat(e):[n].concat(e).concat(e)}return n}get trainableWeights(){return this.forwardLayer.trainableWeights.concat(this.backwardLayer.trainableWeights)}get nonTrainableWeights(){return this.forwardLayer.nonTrainableWeights.concat(this.backwardLayer.nonTrainableWeights)}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.forwardLayer&&this.forwardLayer.setFastWeightInitDuringBuild(e),null!=this.backwardLayer&&this.backwardLayer.setFastWeightInitDuringBuild(e)}getConfig(){const e={mergeMode:this.mergeMode},t=super.getConfig();return Object.assign(e,t),e}static fromConfig(e,t){const n=Bm(t.layer);if(delete t.layer,null!=t.numConstants)throw new Sd("Deserialization of a Bidirectional layer with numConstants present is not supported yet.");const s=t;return s.layer=n,new e(s)}}function rx(e){return new Vb(e)}function ax(e){return new Hb(e)}function ix(e){return new Kb(e)}function ox(e){return new Jb(e)}function lx(e){return new ex(e)}function ux(e){return new Wb(e)}function cx(e){return new Gb(e)}sx.className="Bidirectional",Ma(sx);const hx=ox,px=lx,dx=ux,fx=cx;var mx=Object.freeze({__proto__:null,inputLayer:function(e){return new Sm(e)},elu:function(e){return new Ty(e)},reLU:function(e){return new Iy(e)},leakyReLU:function(e){return new Cy(e)},prelu:function(e){return new Sy(e)},softmax:function(e){return new $y(e)},thresholdedReLU:function(e){return new Ey(e)},conv1d:function(e){return new Hy(e)},conv2d:function(e){return new Py(e)},conv2dTranspose:function(e){return new Vy(e)},conv3d:function(e){return new Wy(e)},separableConv2d:function(e){return new Gy(e)},cropping2D:function(e){return new jy(e)},upSampling2d:function(e){return new qy(e)},depthwiseConv2d:function(e){return new Ky(e)},activation:function(e){return new mb(e)},dense:function(e){return new db(e)},dropout:function(e){return new hb(e)},spatialDropout1d:function(e){return new pb(e)},flatten:function(e){return new fb(e)},repeatVector:function(e){return new gb(e)},reshape:function(e){return new yb(e)},permute:function(e){return new bb(e)},embedding:function(e){return new wb(e)},add:function(e){return new vb(e)},average:function(e){return new Ib(e)},concatenate:function(e){return new Tb(e)},maximum:function(e){return new Cb(e)},minimum:function(e){return new Sb(e)},multiply:function(e){return new Nb(e)},dot:function(e){return new $b(e)},batchNormalization:function(e){return new Ob(e)},layerNormalization:function(e){return new Mb(e)},zeroPadding2d:function(e){return new Lb(e)},averagePooling1d:rx,avgPool1d:function(e){return rx(e)},avgPooling1d:function(e){return rx(e)},averagePooling2d:ax,avgPool2d:function(e){return ax(e)},avgPooling2d:function(e){return ax(e)},averagePooling3d:ix,avgPool3d:function(e){return ix(e)},avgPooling3d:function(e){return ix(e)},globalAveragePooling1d:function(e){return new Yb(e)},globalAveragePooling2d:function(e){return new Qb(e)},globalMaxPooling1d:ox,globalMaxPooling2d:lx,maxPooling1d:ux,maxPooling2d:cx,maxPooling3d:function(e){return new qb(e)},gru:function(e){return new nb(e)},gruCell:function(e){return new tb(e)},lstm:function(e){return new rb(e)},lstmCell:function(e){return new sb(e)},simpleRNN:function(e){return new eb(e)},simpleRNNCell:function(e){return new Qy(e)},convLstm2d:function(e){return new cb(e)},convLstm2dCell:function(e){return new ub(e)},rnn:function(e){return new Jy(e)},stackedRNNCells:function(e){return new ab(e)},bidirectional:function(e){return new sx(e)},timeDistributed:function(e){return new nx(e)},globalMaxPool1d:hx,globalMaxPool2d:px,maxPool1d:dx,maxPool2d:fx,Layer:Cm,RNN:Jy,RNNCell:Zy,input:Zg,gaussianNoise:function(e){return new Ab(e)},gaussianDropout:function(e){return new Rb(e)},alphaDropout:function(e){return new Fb(e)},masking:function(e){return new xb(e)}});var gx=Object.freeze({__proto__:null,binaryAccuracy:function(e,t){return Zm(e,t)},binaryCrossentropy:function(e,t){return sg(e,t)},sparseCategoricalAccuracy:function(e,t){return rg(e,t)},categoricalAccuracy:function(e,t){return Qm(e,t)},categoricalCrossentropy:function(e,t){return ag(e,t)},precision:function(e,t){return tg(e,t)},recall:function(e,t){return ng(e,t)},cosineProximity:function(e,t){return Xm(e,t)},meanAbsoluteError:function(e,t){return Vm(e,t)},meanAbsolutePercentageError:function(e,t){return Um(e,t)},MAPE:function(e,t){return Um(e,t)},mape:function(e,t){return Um(e,t)},meanSquaredError:function(e,t){return Wm(e,t)},MSE:function(e,t){return Wm(e,t)},mse:function(e,t){return Wm(e,t)}}),yx=Object.freeze({__proto__:null,modelFromJSON:async function(e,t){"modelTopology"in e||(e={modelTopology:e});let n=(e=e).modelTopology;null!=n.model_config&&(n=n.model_config);const s=Bm(gg(n),t);if(null!=e.weightsManifest){const t=await jr(e.weightsManifest,e.pathPrefix,s.weights.map(e=>e.originalName)),n={};for(const e of s.weights)n[e.originalName]=t[e.originalName];s.loadWeights(n),Qa(t)}return s}});var bx=Object.freeze({__proto__:null,l1l2:function(e){return new xy(e)},l1:function(e){return yy(t=e),new xy({l1:null!=t?t.l1:null,l2:0});var t},l2:function(e){return yy(t=e),new xy({l2:null!=t?t.l2:null,l1:0});var t}});class xx extends Rm{constructor(){super(...arguments),this.model=null}setModel(e){if(!(e instanceof Hg))throw new Error("model must be a LayersModel, not some other Container");this.model=e}}function wx(e,t){return e<t}function kx(e,t){return e>t}class vx extends xx{constructor(e){if(super(),null==e&&(e={}),e.restoreBestWeights)throw new Sd("restoreBestWeights = True is not implemented in EarlyStopping yet.");this.monitor=e.monitor||"val_loss",this.minDelta=Math.abs(e.minDelta||0),this.patience=e.patience||0,this.verbose=e.verbose||0,this.mode=e.mode||"auto",this.baseline=e.baseline,-1===["auto","min","max"].indexOf(this.mode)&&(console.warn(`EarlyStopping mode '${this.mode}' is invalid. Falling back to mode 'auto'.`),this.mode="auto"),"min"===this.mode?this.monitorFunc=wx:"max"===this.mode||-1!==this.monitor.indexOf("acc")?this.monitorFunc=kx:this.monitorFunc=wx,this.monitorFunc===wx&&(this.minDelta*=-1)}async onTrainBegin(e){this.wait=0,this.stoppedEpoch=0,null!=this.baseline?this.best=this.baseline:this.best=this.monitorFunc===wx?1/0:-1/0}async onEpochEnd(e,t){await Em(t);const n=this.getMonitorValue(t);null!=n&&(this.monitorFunc(n-this.minDelta,this.best)?(this.best=n,this.wait=0):(this.wait++,this.wait>=this.patience&&(this.stoppedEpoch=e,this.model.stopTraining=!0)))}async onTrainEnd(e){this.stoppedEpoch>0&&this.verbose&&console.log(`Epoch ${this.stoppedEpoch}: early stopping.`)}getMonitorValue(e){null==e&&(e={});const t=e[this.monitor];return null==t&&console.warn(`Metric for EarlyStopping ${this.monitor} is not available. Available metrics are: `+Object.keys(e)),t}}const Nx={earlyStopping:function(e){return new vx(e)}};var Ix,Cx;!function(e){e[e.DT_INVALID=0]="DT_INVALID",e[e.DT_FLOAT=1]="DT_FLOAT",e[e.DT_DOUBLE=2]="DT_DOUBLE",e[e.DT_INT32=3]="DT_INT32",e[e.DT_UINT8=4]="DT_UINT8",e[e.DT_INT16=5]="DT_INT16",e[e.DT_INT8=6]="DT_INT8",e[e.DT_STRING=7]="DT_STRING",e[e.DT_COMPLEX64=8]="DT_COMPLEX64",e[e.DT_INT64=9]="DT_INT64",e[e.DT_BOOL=10]="DT_BOOL",e[e.DT_QINT8=11]="DT_QINT8",e[e.DT_QUINT8=12]="DT_QUINT8",e[e.DT_QINT32=13]="DT_QINT32",e[e.DT_BFLOAT16=14]="DT_BFLOAT16",e[e.DT_FLOAT_REF=101]="DT_FLOAT_REF",e[e.DT_DOUBLE_REF=102]="DT_DOUBLE_REF",e[e.DT_INT32_REF=103]="DT_INT32_REF",e[e.DT_UINT8_REF=104]="DT_UINT8_REF",e[e.DT_INT16_REF=105]="DT_INT16_REF",e[e.DT_INT8_REF=106]="DT_INT8_REF",e[e.DT_STRING_REF=107]="DT_STRING_REF",e[e.DT_COMPLEX64_REF=108]="DT_COMPLEX64_REF",e[e.DT_INT64_REF=109]="DT_INT64_REF",e[e.DT_BOOL_REF=110]="DT_BOOL_REF",e[e.DT_QINT8_REF=111]="DT_QINT8_REF",e[e.DT_QUINT8_REF=112]="DT_QUINT8_REF",e[e.DT_QINT32_REF=113]="DT_QINT32_REF",e[e.DT_BFLOAT16_REF=114]="DT_BFLOAT16_REF"}(Ix||(Ix={})),function(e){let t;!function(e){e[e.LEGACY=0]="LEGACY",e[e.V1=1]="V1",e[e.V2=2]="V2"}(t=e.CheckpointFormatVersion||(e.CheckpointFormatVersion={}))}(Cx||(Cx={}));const Sx={};function Tx(e,t){const n={tfOpName:e,category:"custom",inputs:[],attrs:[],customExecutor:t};Sx[e]=n}function Ex(e){return Sx[e]}function $x(e){delete Sx[e]}function Ax(e,t,n,s,r){const a=t.inputParams[e];if(a&&void 0!==a.inputIndexStart){const e=a.inputIndexStart,i=0===a.inputIndexEnd?void 0:void 0===a.inputIndexEnd?e+1:a.inputIndexEnd;if("tensor"===a.type)return Rx(t.inputNames[a.inputIndexStart],n,s,r);if("tensors"===a.type){return t.inputNames.slice(e,i).map(e=>Rx(e,n,s,r))}const o=Rx(t.inputNames.slice(e)[0],n,s,r),l=o.dataSync();return"number"===a.type?l[0]:O(o.shape,l)}const i=t.attrParams[e];return i&&i.value}function Rx(e,t,n,s){const[r,a]=_x(e);if(null!=s){const e=s.getHashTableHandleByName(r);if(null!=e)return e}const i=n.currentContextIds.find(e=>!!t[Dx(r,e)]);return void 0!==i?t[Dx(r,i)][a]:void 0}function Fx(e,t){const[n,s]=_x(e);return[Dx(n,t&&t.currentContextId),s]}function Dx(e,t){return t?`${e}-${t}`:e}function _x(e){const t=e.split(":");return 1===t.length?[e,0]:[t[0],Number(t[t.length-1])]}function Ox(e,t,n){let s=Ax("pad",e,t,n);if("explicit"===s){s=Ax("explicitPaddings",e,t,n);const r=[[0,0],[0,0],[0,0],[0,0]];for(let e=0;e<4;e++)r[e][0]=s[2*e],r[e][1]=s[2*e+1];return r}return s}function Mx(e){return e.kept?e:Br(e)}var Lx=Object.freeze({__proto__:null,json:[{tfOpName:"Add",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddV2",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddN",category:"arithmetic",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"BiasAdd",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"Sub",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"RealDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Div",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"DivNoNan",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mul",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Maximum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Minimum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Pow",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SquaredDifference",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorMod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var zx=Object.freeze({__proto__:null,json:[{tfOpName:"Abs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan2",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ceil",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ClipByValue",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"clipValueMin",type:"number"},{start:2,name:"clipValueMax",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Complex",category:"basic_math",inputs:[{start:0,name:"real",type:"tensor"},{start:1,name:"imag",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ComplexAbs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Elu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Exp",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Floor",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Imag",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Neg",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Real",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Prelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"alpha",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu6",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Selu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sigmoid",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Rsqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Square",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sign",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Round",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Expm1",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log1p",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Reciprocal",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Softplus",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Erf",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Prod",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axes",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LeakyRelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"alpha",name:"alpha",type:"number",defaultValue:.2},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Bx=Object.freeze({__proto__:null,json:[{tfOpName:"EmptyTensorList",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"maxNumElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"LoopCond",category:"control",inputs:[{start:0,name:"pred",type:"tensor"}]},{tfOpName:"Switch",category:"control",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"pred",type:"tensor"}]},{tfOpName:"Merge",category:"control",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"Enter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"frame_name",name:"frameName",type:"string"},{tfName:"is_constant",name:"isConstant",type:"bool"}]},{tfOpName:"Exit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NextIteration",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayV3",category:"control",inputs:[{start:0,name:"size",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"dynamic_size",name:"dynamicSize",type:"bool"},{tfName:"clear_after_read",name:"clearAfterRead",type:"bool"},{tfName:"identical_element_shapes",name:"identicalElementShapes",type:"bool"},{tfName:"tensor_array_name",name:"name",type:"string"}]},{tfOpName:"TensorArrayWriteV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayReadV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayGatherV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"}]},{tfOpName:"TensorArrayScatterV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArrayConcatV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape_except0",name:"elementShapeExcept0",type:"shape",notSupported:!0}]},{tfOpName:"TensorArraySplitV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"tensor",type:"tensor"},{start:2,name:"lengths",type:"number[]"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArraySizeV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}]},{tfOpName:"TensorArrayCloseV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"}]},{tfOpName:"StatelessIf",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"If",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"StatelessWhile",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"While",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"TensorListScatter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListScatterV2",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"},{start:3,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGather",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListSetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListReserve",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListFromTensor",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListStack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"},{tfName:"num_elements",name:"numElements",type:"dtype"}]},{tfOpName:"TensorListSplit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"},{start:2,name:"lengths",type:"number[]"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListConcat",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}],attrs:[{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPopBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPushBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]}]});var Px=Object.freeze({__proto__:null,json:[{tfOpName:"AvgPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[],notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPoolWithArgmax",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"include_batch_in_index",name:"includeBatchInIndex",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AvgPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Conv1D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"stride",name:"stride",type:"number"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NWC"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"dilation",name:"dilation",type:"number",defaultValue:1}]},{tfOpName:"Conv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"useCudnnOnGpu",name:"useCudnnOnGpu",type:"bool"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"_FusedConv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"use_cudnn_on_gpu",name:"useCudnnOnGpu",type:"bool",defaultValue:!0},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"leakyrelu_alpha",name:"leakyreluAlpha",type:"number"}]},{tfOpName:"Conv2DBackpropInput",category:"convolution",inputs:[{start:2,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:0,name:"outputShape",type:"number[]"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]",notSupported:!0}]},{tfOpName:"DepthwiseConv2d",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"DepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"FusedDepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]}]},{tfOpName:"Conv3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"Dilation2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"rates",name:"dilations",type:"number[]"},{tfName:"padding",name:"pad",type:"string"}]}]});var Wx=Object.freeze({__proto__:null,json:[{tfOpName:"Fill",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"},{start:1,name:"value",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"LinSpace",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"num",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"OneHot",category:"creation",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"depth",type:"number"},{start:2,name:"onValue",type:"number",defaultValue:1},{start:3,name:"offValue",type:"number",defaultValue:0}],attrs:[{tfName:"axis",name:"axis",type:"number",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ones",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"OnesLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"RandomUniform",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"minval",name:"minval",type:"number",defaultValue:0},{tfName:"maxval",name:"maxval",type:"number",defaultValue:1},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Range",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"step",type:"number",defaultValue:0}],attrs:[{tfName:"Tidx",name:"dtype",type:"dtype"}]},{tfOpName:"TruncatedNormal",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"means",name:"mean",type:"number",defaultValue:0},{tfName:"stddev",name:"stdDev",type:"number",defaultValue:1},{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Zeros",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"ZerosLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"Multinomial",category:"creation",inputs:[{start:0,name:"logits",type:"tensor"},{start:1,name:"numSamples",type:"number"}],attrs:[{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number"},{tfName:"T",name:"dtype",type:"dtype"},{tfName:"output_dtype",name:"output_dtype",type:"dtype"}]}]});var Vx=Object.freeze({__proto__:null,json:[{tfOpName:"NonMaxSuppressionV2",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV3",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV4",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"T_threshold",name:"threshold",type:"dtype",notSupported:!0},{tfName:"pad_to_max_output_size",name:"padToMaxOutputSize",type:"bool"}]},{tfOpName:"NonMaxSuppressionV5",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"},{start:5,name:"softNmsSigma",type:"number"}]},{tfOpName:"Where",category:"dynamic",inputs:[{start:0,name:"condition",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ListDiff",category:"dynamic",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Ux=Object.freeze({__proto__:null,json:[{tfOpName:"TopKV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"k",type:"number"}],attrs:[{tfName:"sorted",name:"sorted",type:"bool"}]},{tfOpName:"Unique",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"UniqueV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]}]});var Gx=Object.freeze({__proto__:null,json:[{tfOpName:"PlaceholderWithDefault",category:"graph",inputs:[{start:0,name:"default",type:"tensor"}],attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Placeholder",category:"graph",attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Const",category:"graph"},{tfOpName:"Identity",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IdentityN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Snapshot",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Rank",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Size",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Shape",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"ShapeN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Print",category:"graph",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"data",type:"tensors"}],attrs:[{tfName:"message",name:"message",type:"string"},{tfName:"first_n",name:"firstN",type:"number",notSupported:!0},{tfName:"summarize",name:"summarize",type:"number",defaultValue:3}]},{tfOpName:"NoOp",category:"graph",inputs:[]},{tfOpName:"StopGradient",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"FakeQuantWithMinMaxVars",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"min",name:"min",type:"number"},{tfName:"max",name:"max",type:"number"}]}]});var Hx=Object.freeze({__proto__:null,json:[{tfOpName:"HashTable",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"HashTableV2",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"LookupTableImport",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableImportV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFind",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFindV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]}]});var jx=Object.freeze({__proto__:null,json:[{tfOpName:"ResizeBilinear",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ResizeNearestNeighbor",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"CropAndResize",category:"image",inputs:[{start:0,name:"image",type:"tensor"},{start:1,name:"boxes",type:"tensor"},{start:2,name:"boxInd",type:"tensor"},{start:3,name:"cropSize",type:"number[]"}],attrs:[{tfName:"method",name:"method",type:"string"},{tfName:"extrapolation_value",name:"extrapolationValue",type:"number"}]}]});var qx=Object.freeze({__proto__:null,json:[{tfOpName:"Equal",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NotEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Greater",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"GreaterEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Less",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LessEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalAnd",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalNot",category:"logical",inputs:[{start:0,name:"a",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalOr",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Select",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SelectV2",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Kx=Object.freeze({__proto__:null,json:[{tfOpName:"_FusedMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMulV2",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Transpose",category:"matrices",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"perm",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Xx=Object.freeze({__proto__:null,json:[{tfOpName:"FusedBatchNorm",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV2",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV3",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"LRN",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"depth_radius",name:"radius",type:"number",defaultValue:5},{tfName:"bias",name:"bias",type:"number",defaultValue:1},{tfName:"alpha",name:"alpha",type:"number",defaultValue:1},{tfName:"beta",name:"beta",type:"number",defaultValue:.5}]},{tfOpName:"Softmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"LogSoftmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"SparseToDense",category:"normalization",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!0,notSupported:!0}]}]});var Yx=Object.freeze({__proto__:null,json:[{tfOpName:"Bincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}]},{tfOpName:"DenseBincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}],attrs:[{tfName:"binary_output",name:"binaryOutput",type:"bool"}]},{tfOpName:"Max",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Mean",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Min",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Sum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"All",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Any",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"ArgMax",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"ArgMin",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"Prod",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Cumsum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}],attrs:[{tfName:"exclusive",name:"exclusive",type:"bool"},{tfName:"reverse",name:"reverse",type:"bool"}]}]});var Jx=Object.freeze({__proto__:null,json:[{tfOpName:"ConcatV2",category:"slice_join",inputs:[{start:0,end:-1,name:"tensors",type:"tensors"},{start:-1,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"Concat",category:"slice_join",inputs:[{start:1,end:0,name:"tensors",type:"tensors"},{start:0,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"GatherV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"axis",type:"number",defaultValue:0}],attrs:[{tfName:"batch_dims",name:"batchDims",type:"number",defaultValue:0}]},{tfOpName:"Gather",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",notSupported:!0}]},{tfOpName:"Reverse",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"dims",type:"bool[]"}]},{tfOpName:"ReverseV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}]},{tfOpName:"Slice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"size",type:"number[]"}]},{tfOpName:"StridedSlice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"end",type:"number[]"},{start:3,name:"strides",type:"number[]"}],attrs:[{tfName:"begin_mask",name:"beginMask",type:"number",defaultValue:0},{tfName:"end_mask",name:"endMask",type:"number",defaultValue:0},{tfName:"new_axis_mask",name:"newAxisMask",type:"number",defaultValue:0},{tfName:"ellipsis_mask",name:"ellipsisMask",type:"number",defaultValue:0},{tfName:"shrink_axis_mask",name:"shrinkAxisMask",type:"number",defaultValue:0}]},{tfOpName:"Pack",category:"slice_join",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0}]},{tfOpName:"Unpack",category:"slice_join",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0},{tfName:"num",name:"num",type:"number",defaultValue:0,notSupported:!0}]},{tfOpName:"Tile",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"reps",type:"number[]"}]},{tfOpName:"Split",category:"slice_join",inputs:[{start:0,name:"axis",type:"number",defaultValue:0},{start:1,name:"x",type:"tensor"}],attrs:[{tfName:"num_split",name:"numOrSizeSplits",type:"number",defaultValue:1}]},{tfOpName:"SplitV",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"numOrSizeSplits",type:"number[]"},{start:2,name:"axis",type:"number",defaultValue:0}]},{tfOpName:"ScatterNd",category:"slice_join",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"values",type:"tensor"},{start:2,name:"shape",type:"number[]"}]},{tfOpName:"GatherNd",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}]},{tfOpName:"SparseToDense",category:"slice_join",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!1,notSupported:!0}]}]});var Zx=Object.freeze({__proto__:null,json:[{tfOpName:"FFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"RFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]},{tfOpName:"IRFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]}]});var Qx=Object.freeze({__proto__:null,json:[{tfOpName:"Cast",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"SrcT",name:"sdtype",type:"dtype",notSupported:!0},{tfName:"DstT",name:"dtype",type:"dtype"}]},{tfOpName:"ExpandDims",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"MirrorPad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"mode",name:"mode",type:"string"}]},{tfOpName:"Pad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"constant_value",name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"PadV2",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"},{start:2,name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"Reshape",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}]},{tfOpName:"Squeeze",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"axis",tfDeprecatedName:"squeeze_dims",name:"axis",type:"number[]"}]},{tfOpName:"SpaceToBatchND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"paddings",type:"number[]"}]},{tfOpName:"BatchToSpaceND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"crops",type:"number[]"}]},{tfOpName:"DepthToSpace",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"block_size",name:"blockSize",type:"number"},{tfName:"data_format",name:"dataFormat",type:"string"}]},{tfOpName:"BroadcastTo",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}],attrs:[]}]});class ew{static get Instance(){return this._instance||(this._instance=new this)}constructor(){const e=[].concat(...[Lx,zx,Bx,Px,Wx,Vx,Ux,qx,jx,Gx,Kx,Xx,Yx,Jx,Zx,Qx,Hx].map(e=>e.json));this.opMappers=e.reduce((e,t)=>(e[t.tfOpName]=t,e),{})}transformGraph(e,t={}){const n=e.node,s=[],r=[],a=[],i=n.reduce((e,t)=>(e[t.name]=this.mapNode(t),t.op.startsWith("Placeholder")?s.push(e[t.name]):"Const"===t.op?r.push(e[t.name]):null!=t.input&&0!==t.input.length||a.push(e[t.name]),e),{});let o=[];const l=[];let u={},c={};null!=t&&(u=this.mapSignatureEntries(t.inputs),c=this.mapSignatureEntries(t.outputs));const h=Object.keys(i);h.forEach(e=>{const t=i[e];t.inputNames.forEach(e=>{const[n]=Fx(e);t.inputs.push(i[n]),i[n].children.push(t)})}),0===Object.keys(c).length?h.forEach(e=>{const t=i[e];0===t.children.length&&l.push(t)}):Object.keys(c).forEach(e=>{const[t]=Fx(e),n=i[t];null!=n&&(n.signatureKey=c[e],l.push(n))}),Object.keys(u).length>0?Object.keys(u).forEach(e=>{const[t]=Fx(e),n=i[t];n&&(n.signatureKey=u[e],o.push(n))}):o=s;let p={};null!=e.library&&null!=e.library.function&&(p=e.library.function.reduce((e,t)=>(e[t.signature.name]=this.mapFunction(t),e),{}));const d={nodes:i,inputs:o,outputs:l,weights:r,placeholders:s,signature:t,functions:p};return a.length>0&&(d.initNodes=a),d}mapSignatureEntries(e){return Object.keys(e||{}).reduce((t,n)=>(t[e[n].name]=n,t),{})}mapNode(e){const t=Ex(e.op)||this.opMappers[e.op]||{};null==e.attr&&(e.attr={});const n={name:e.name,op:e.op,category:t.category,inputNames:(e.input||[]).map(e=>e.startsWith("^")?e.substr(1):e),inputs:[],children:[],inputParams:{},attrParams:{},rawAttrs:e.attr};return null!=t.inputs&&(n.inputParams=t.inputs.reduce((e,t)=>(e[t.name]={type:t.type,inputIndexStart:t.start,inputIndexEnd:t.end},e),{})),null!=t.attrs&&(n.attrParams=t.attrs.reduce((t,n)=>{const s=n.type;let r=void 0;switch(n.type){case"string":r=nw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=nw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"string[]":r=pw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=pw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number":r=rw(e.attr,n.tfName,n.defaultValue||0),void 0===r&&n.tfDeprecatedName&&(r=rw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number[]":r=hw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=hw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool":r=sw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=sw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool[]":r=fw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=fw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape":r=cw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=cw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape[]":r=dw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=dw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype":r=ow(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=ow(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype[]":r=lw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=lw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"func":r=iw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=iw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"tensor":case"tensors":break;default:throw new Error(`Unsupported param type: ${n.type} for op: ${e.op}`)}return t[n.name]={value:r,type:s},t},{})),n}mapFunction(e){const t=e.nodeDef,n=[];let s={};null!=t&&(s=t.reduce((e,t)=>(e[t.name]=this.mapNode(t),"Const"===t.op&&n.push(e[t.name]),e),{}));const r=[],a=[];e.signature.inputArg.forEach(e=>{const[t]=Fx(e.name),n={name:t,op:"Placeholder",inputs:[],inputNames:[],category:"graph",inputParams:{},attrParams:{dtype:{value:aw(e.type),type:"dtype"}},children:[]};n.signatureKey=e.name,r.push(n),s[t]=n}),Object.keys(s).forEach(e=>{const t=s[e];t.inputNames.forEach(e=>{const[n]=Fx(e);t.inputs.push(s[n]),s[n].children.push(t)})});const i=e.ret;e.signature.outputArg.forEach(e=>{const[t,n]=Fx(i[e.name]),r=s[t];null!=r&&(r.defaultOutput=n,a.push(r))});const o=this.mapArgsToSignature(e);return{nodes:s,inputs:r,outputs:a,weights:n,placeholders:[],signature:o}}mapArgsToSignature(e){return{methodName:e.signature.name,inputs:e.signature.inputArg.reduce((e,t)=>(e[t.name]=this.mapArgToTensorInfo(t),e),{}),outputs:e.signature.outputArg.reduce((t,n)=>(t[n.name]=this.mapArgToTensorInfo(n,e.ret),t),{})}}mapArgToTensorInfo(e,t){let n=e.name;return null!=t&&(n=t[n]),{name:n,dtype:e.type}}}function tw(e,t){const n=Array.isArray(e)?String.fromCharCode.apply(null,e):function(e){const t=G().global;if(void 0!==t.atob)return t.atob(e);if("undefined"!=typeof Buffer)return new Buffer(e,"base64").toString();throw new Error("Unable to decode base64 in this environment. Missing built-in atob() or Buffer()")}(e);return t?n:n.toLowerCase()}function nw(e,t,n,s=!1){const r=e[t];return null!=r?tw(r.s,s):n}function sw(e,t,n){const s=e[t];return s?s.b:n}function rw(e,t,n){const s=e[t]||{},r=null!=s.i?s.i:null!=s.f?s.f:n;return"number"==typeof r?r:parseInt(r,10)}function aw(e){switch("string"==typeof e&&(e=Ix[e]),e){case Ix.DT_FLOAT:return"float32";case Ix.DT_INT32:case Ix.DT_INT64:case Ix.DT_INT8:case Ix.DT_UINT8:return"int32";case Ix.DT_BOOL:return"bool";case Ix.DT_DOUBLE:return"float32";case Ix.DT_STRING:return"string";default:return null}}function iw(e,t,n){const s=e[t];return s&&s.func?s.func.name:n}function ow(e,t,n){const s=e[t];return s&&s.type?aw(s.type):n}function lw(e,t,n){const s=e[t];return s&&s.list&&s.list.type?s.list.type.map(e=>aw(e)):n}function uw(e){if(!e.unknownRank)return null!=e.dim?e.dim.map(e=>"number"==typeof e.size?e.size:parseInt(e.size,10)):[]}function cw(e,t,n){const s=e[t];return s&&s.shape?uw(s.shape):n}function hw(e,t,n){const s=e[t];return s?((s.list.f&&s.list.f.length?s.list.f:s.list.i)||[]).map(e=>"number"==typeof e?e:parseInt(e,10)):n}function pw(e,t,n,s=!1){const r=e[t];return r&&r.list&&r.list.s?r.list.s.map(e=>tw(e,s)):n}function dw(e,t,n){const s=e[t];return s&&s.list&&s.list.shape?s.list.shape.map(e=>uw(e)):n}function fw(e,t,n){const s=e[t];return s&&s.list&&s.list.b?s.list.b:n}class mw{constructor(e,t,n){this.node=e,this.tensorMap=t,this.context=n,this.inputs=[],this.attrs={},this.inputs=e.inputNames.map(e=>this.getInput(e)),null!=e.rawAttrs&&(this.attrs=Object.keys(e.rawAttrs).reduce((e,t)=>(e[t]=this.getAttr(t),e),{}))}getInput(e){return Rx(e,this.tensorMap,this.context)}getAttr(e,t){const n=this.node.rawAttrs[e];if(null!=n.tensor)return Rx(e,this.tensorMap,this.context);if(null!=n.i||null!=n.f)return rw(this.node.rawAttrs,e,t);if(null!=n.s)return nw(this.node.rawAttrs,e,t);if(null!=n.b)return sw(this.node.rawAttrs,e,t);if(null!=n.shape)return cw(this.node.rawAttrs,e,t);if(null!=n.type)return ow(this.node.rawAttrs,e,t);if(null!=n.list){if(null!=n.list.i||null!=n.list.f)return hw(this.node.rawAttrs,e,t);if(null!=n.list.s)return pw(this.node.rawAttrs,e,t);if(null!=n.list.shape)return dw(this.node.rawAttrs,e,t);if(null!=n.list.b)return fw(this.node.rawAttrs,e,t);if(null!=n.list.type)return lw(this.node.rawAttrs,e,t)}return t}}function gw(e,t,n=""){if("number"!=typeof e&&"number"!=typeof t){o(e.length===t.length,()=>n+` Shapes ${e} and ${t} must match`);for(let s=0;s<e.length;s++){const r=e[s],a=t[s];o(r<0||a<0||r===a,()=>n+` Shapes ${e} and ${t} must match`)}}}function yw(e){return"number"!=typeof e&&!e.some(e=>e<0)}function bw(e,t,n){let s=xw(e,n);const r=!yw(s);if(r&&0===t.length)throw new Error("Tried to calculate elements of an empty list with non-fully-defined elementShape: "+s);if(r&&t.forEach(e=>{s=xw(e.shape,s)}),!yw(s))throw new Error("Non-fully-defined elementShape: "+s);return s}function xw(e,t){if("number"==typeof e)return t;if("number"==typeof t)return e;if(e.length!==t.length)throw new Error(`Incompatible ranks during merge: ${e} vs. ${t}`);const n=[];for(let s=0;s<e.length;++s){const r=e[s],a=t[s];if(r>=0&&a>=0&&r!==a)throw new Error(`Incompatible shape during merge: ${e} vs. ${t}`);n[s]=r>=0?r:a}return n}class ww{constructor(e,t,n,s,r,a,i){this.name=e,this.dtype=t,this.maxSize=n,this.elementShape=s,this.identicalElementShapes=r,this.dynamicSize=a,this.clearAfterRead=i,this.tensors=[],this.closed_=!1,this.idTensor=Au(0),ei(this.idTensor)}get id(){return this.idTensor.id}get closed(){return this.closed_}clearAndClose(e){this.tensors.forEach(t=>{null!=e&&e.has(t.tensor.id)||t.tensor.dispose()}),this.tensors=[],this.closed_=!0,this.idTensor.dispose()}size(){return this.tensors.length}read(e){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||e>=this.size())throw new Error(`Tried to read from index ${e}, but array size is: ${this.size()}`);const t=this.tensors[e];if(t.cleared)throw new Error(`TensorArray ${this.name}: Could not read index ${e} twice because it was cleared after a previous read (perhaps try setting clear_after_read = false?).`);return this.clearAfterRead&&(t.cleared=!0),t.read=!0,t.tensor}readMany(e){return e.map(e=>this.read(e))}write(e,t){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||!this.dynamicSize&&e>=this.maxSize)throw new Error(`Tried to write to index ${e}, but array is not resizeable and size is: ${this.maxSize}`);const n=this.tensors[e]||{};if(t.dtype!==this.dtype)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e},\n          because the value dtype is ${t.dtype}, but TensorArray dtype is ${this.dtype}.`);if(0!==this.size()||null!=this.elementShape&&0!==this.elementShape.length||(this.elementShape=t.shape),gw(this.elementShape,t.shape,`TensorArray ${this.name}: Could not write to TensorArray index ${e}.`),n.read)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been read.`);if(n.written)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been written.`);n.tensor=t,ei(t),n.written=!0,this.tensors[e]=n}writeMany(e,t){if(e.length!==t.length)throw new Error(`TensorArray ${this.name}: could not write multiple tensors,because the index size: ${e.length} is not the same as tensors size: ${t.length}.`);e.forEach((e,n)=>this.write(e,t[n]))}gather(e,t){if(t&&t!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but gather requested dtype ${t}`);if(e)e=e.slice(0,this.size());else{e=[];for(let t=0;t<this.size();t++)e.push(t)}if(0===e.length)return er([],[0].concat(this.elementShape));const n=this.readMany(e);return gw(this.elementShape,n[0].shape,"TensorArray shape mismatch: "),Yu(n,0)}concat(e){if(e&&e!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but concat requested dtype ${e}`);if(0===this.size())return er([],[0].concat(this.elementShape));const t=[];for(let e=0;e<this.size();e++)t.push(e);const n=this.readMany(t);return gw(this.elementShape,n[0].shape,`TensorArray shape mismatch: tensor array shape (${this.elementShape}) vs first tensor shape (${n[0].shape})`),Gi(n,0)}scatter(e,t){if(t.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);if(e.length!==t.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${e.length} vs. ${t.shape[0]}`);const n=Math.max(...e);if(!this.dynamicSize&&n>=this.maxSize)throw new Error(`Max index must be < array size (${n}  vs. ${this.maxSize})`);this.writeMany(e,uc(t,0))}split(e,t){if(t.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);let n=0;const s=e.map(e=>(n+=e,n));if(n!==t.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${n}, and tensor's shape is: ${t.shape}`);if(!this.dynamicSize&&e.length!==this.maxSize)throw new Error(`TensorArray's size is not equal to the size of lengths (${this.maxSize} vs. ${e.length}), and the TensorArray is not marked as dynamically resizeable`);const r=0===n?0:t.size/n,a=[];Za(()=>{t=Wi(t,[1,n,r]);for(let n=0;n<e.length;++n){const i=[0,0===n?0:s[n-1],0],o=[1,e[n],r];a[n]=Wi(ji(t,i,o),this.elementShape)}return a});const i=[];for(let t=0;t<e.length;t++)i[t]=t;this.writeMany(i,a)}}class kw{constructor(e,t,n,s=-1){this.tensors=e,this.elementShape=t,this.elementDtype=n,null!=e&&e.forEach(e=>{if(n!==e.dtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${e.dtype}`);gw(t,e.shape,"TensorList shape mismatch: "),ei(e)}),this.idTensor=Au(0),this.maxNumElements=s,ei(this.idTensor)}get id(){return this.idTensor.id}copy(){return new kw([...this.tensors],this.elementShape,this.elementDtype)}clearAndClose(e){this.tensors.forEach(t=>{null!=e&&e.has(t.id)||t.dispose()}),this.tensors.length=0,this.idTensor.dispose()}size(){return this.tensors.length}stack(e,t,n=-1){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);if(-1!==n&&this.tensors.length!==n)throw new Error(`Operation expected a list with ${n} elements but got a list with ${this.tensors.length} elements.`);gw(e,this.elementShape,"TensorList shape mismatch: ");const s=bw(this.elementShape,this.tensors,e);return Za(()=>{const e=this.tensors.map(e=>Wi(e,s));return Yu(e,0)})}popBack(e,t){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);if(0===this.size())throw new Error("Trying to pop from an empty list.");const n=bw(this.elementShape,this.tensors,e),s=this.tensors.pop();return gw(s.shape,e,"TensorList shape mismatch: "),Wi(s,n)}pushBack(e){if(e.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${this.elementDtype}`);if(gw(e.shape,this.elementShape,"TensorList shape mismatch: "),this.maxNumElements===this.size())throw new Error("Trying to push element into a full list.");ei(e),this.tensors.push(e)}resize(e){if(e<0)throw new Error("TensorListResize expects size to be non-negative. Got: "+e);if(-1!==this.maxNumElements&&e>this.maxNumElements)throw new Error(`TensorListResize input size ${e} is greater maxNumElement ${this.maxNumElements}.`);this.tensors.length=e}getItem(e,t,n){if(n!==this.elementDtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${this.elementDtype}`);if(e<0||e>this.tensors.length)throw new Error(`Trying to access element ${e} in a list with ${this.tensors.length} elements.`);if(null==this.tensors[e])throw new Error(`element at index ${e} is null.`);gw(this.tensors[e].shape,t,"TensorList shape mismatch: ");const s=bw(this.elementShape,this.tensors,t);return Wi(this.tensors[e],s)}setItem(e,t){if(t.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t.dtype}, but list elements ${this.elementDtype}`);if(e<0||-1!==this.maxNumElements&&e>=this.maxNumElements)throw new Error(`Trying to set element ${e} in a list with max ${this.maxNumElements} elements.`);gw(this.elementShape,t.shape,"TensorList shape mismatch: "),ei(t),this.tensors[e]=t}gather(e,t,n){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);gw(this.elementShape,n,"TensorList shape mismatch: "),e=e.slice(0,this.size());const s=bw(this.elementShape,this.tensors,n);return 0===e.length?er([],[0].concat(s)):Za(()=>{const t=e.map(e=>Wi(this.tensors[e],s));return Yu(t,0)})}concat(e,t){if(e&&e!==this.elementDtype)throw new Error(`TensorList dtype is ${this.elementDtype} but concat requested dtype ${e}`);gw(this.elementShape,t,"TensorList shape mismatch: ");const n=bw(this.elementShape,this.tensors,t);return 0===this.size()?er([],[0].concat(n)):Za(()=>{const e=this.tensors.map(e=>Wi(e,n));return Gi(e,0)})}}const vw=async(e,t,n)=>{switch(e.op){case"If":case"StatelessIf":{const s=Ax("thenBranch",e,t,n),r=Ax("elseBranch",e,t,n),a=Ax("cond",e,t,n),i=Ax("args",e,t,n);return(await a.data())[0]?n.functionMap[s].executeFunctionAsync(i,n.tensorArrayMap,n.tensorListMap):n.functionMap[r].executeFunctionAsync(i,n.tensorArrayMap,n.tensorListMap)}case"While":case"StatelessWhile":{const s=Ax("body",e,t,n),r=Ax("cond",e,t,n),a=Ax("args",e,t,n),i=await n.functionMap[r].executeFunctionAsync(a,n.tensorArrayMap,n.tensorListMap),o=a.map(e=>e.id);let l=await i[0].data();i.forEach(e=>{e.kept||-1!==o.indexOf(e.id)||e.dispose()});let u=a;for(;l[0];){const e=u;u=await n.functionMap[s].executeFunctionAsync(u,n.tensorArrayMap,n.tensorListMap);const t=u.map(e=>e.id);e.forEach(e=>{e.kept||-1!==o.indexOf(e.id)||-1!==t.indexOf(e.id)||e.dispose()});const a=await n.functionMap[r].executeFunctionAsync(u,n.tensorArrayMap,n.tensorListMap);l=await a[0].data(),a.forEach(e=>{e.kept||-1!==o.indexOf(e.id)||-1!==t.indexOf(e.id)||e.dispose()})}return u}case"LoopCond":return[Mx(Ax("pred",e,t,n))];case"Switch":{const s=Ax("pred",e,t,n);let r=Ax("data",e,t,n);return r.kept||(r=Mx(r)),(await s.data())[0]?[void 0,r]:[r,void 0]}case"Merge":{const s=e.inputNames.find(e=>void 0!==Rx(e,t,n));if(s){return[Mx(Rx(s,t,n))]}return}case"Enter":{const s=Ax("frameName",e,t,n),r=Ax("tensor",e,t,n);return n.enterFrame(s),[Mx(r)]}case"Exit":{const s=Ax("tensor",e,t,n);return n.exitFrame(),[Mx(s)]}case"NextIteration":{const s=Ax("tensor",e,t,n);return n.nextIteration(),[Mx(s)]}case"TensorArrayV3":{const s=Ax("size",e,t,n),r=Ax("dtype",e,t,n),a=Ax("elementShape",e,t,n),i=Ax("dynamicSize",e,t,n),o=Ax("clearAfterRead",e,t,n),l=Ax("identicalElementShapes",e,t,n),u=Ax("name",e,t,n),c=new ww(u,r,s,a,l,i,o);return n.addTensorArray(c),[c.idTensor,Au(1)]}case"TensorArrayWriteV3":{const s=Ax("tensorArrayId",e,t,n),r=Ax("index",e,t,n),a=Ax("tensor",e,t,n),i=n.getTensorArray(s.id);return i.write(r,a),[i.idTensor]}case"TensorArrayReadV3":{const s=Ax("tensorArrayId",e,t,n),r=Ax("index",e,t,n);return[n.getTensorArray(s.id).read(r)]}case"TensorArrayGatherV3":{const s=Ax("tensorArrayId",e,t,n),r=Ax("indices",e,t,n),a=Ax("dtype",e,t,n);return[n.getTensorArray(s.id).gather(r,a)]}case"TensorArrayScatterV3":{const s=Ax("tensorArrayId",e,t,n),r=Ax("indices",e,t,n),a=Ax("tensor",e,t,n),i=n.getTensorArray(s.id);return i.scatter(r,a),[i.idTensor]}case"TensorArrayConcatV3":{const s=Ax("tensorArrayId",e,t,n),r=n.getTensorArray(s.id),a=Ax("dtype",e,t,n);return[r.concat(a)]}case"TensorArraySplitV3":{const s=Ax("tensorArrayId",e,t,n),r=Ax("tensor",e,t,n),a=Ax("lengths",e,t,n),i=n.getTensorArray(s.id);return i.split(a,r),[i.idTensor]}case"TensorArraySizeV3":{const s=Ax("tensorArrayId",e,t,n);return[Au(n.getTensorArray(s.id).size(),"int32")]}case"TensorArrayCloseV3":{const s=Ax("tensorArrayId",e,t,n),r=n.getTensorArray(s.id);return r.clearAndClose(),[r.idTensor]}case"TensorListSetItem":{const s=Ax("tensorListId",e,t,n),r=Ax("index",e,t,n),a=Ax("tensor",e,t,n),i=n.getTensorList(s.id);return i.setItem(r,a),[i.idTensor]}case"TensorListGetItem":{const s=Ax("tensorListId",e,t,n),r=Ax("index",e,t,n),a=Ax("elementShape",e,t,n),i=Ax("elementDType",e,t,n);return[n.getTensorList(s.id).getItem(r,a,i)]}case"TensorListScatterV2":case"TensorListScatter":{const s=Ax("indices",e,t,n),r=function(e,t,n,s){if(t.length!==e.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${t.length} vs. ${e.shape[0]}`);const r=Math.max(...t);if(null!=s&&-1!==s&&r>=s)throw new Error(`Max index must be < array size (${r}  vs. ${s})`);const a=new kw([],n,e.dtype,s),i=uc(e,0);return t.forEach((e,t)=>{a.setItem(e,i[t])}),a}(Ax("tensor",e,t,n),s,Ax("elementShape",e,t,n),Ax("numElements",e,t,n));return n.addTensorList(r),[r.idTensor]}case"TensorListReserve":case"EmptyTensorList":{const s=Ax("elementShape",e,t,n),r=Ax("elementDType",e,t,n);let a;a="TensorListReserve"===e.op?"numElements":"maxNumElements";const i=function(e,t,n){return new kw([],e,t,n)}(s,r,Ax(a,e,t,n));return n.addTensorList(i),[i.idTensor]}case"TensorListGather":{const s=Ax("tensorListId",e,t,n),r=Ax("indices",e,t,n),a=Ax("elementShape",e,t,n),i=Ax("elementDType",e,t,n);return[n.getTensorList(s.id).gather(r,i,a)]}case"TensorListStack":{const s=Ax("tensorListId",e,t,n),r=Ax("elementShape",e,t,n),a=Ax("elementDType",e,t,n),i=Ax("numElements",e,t,n);return[n.getTensorList(s.id).stack(r,a,i)]}case"TensorListFromTensor":{const s=function(e,t,n){const s=e.dtype;if(e.shape.length<1)throw new Error("Tensor must be at least a vector, but saw shape: "+e.shape);if(e.dtype!==n)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${n}`);gw(e.shape.slice(1),t,"TensorList shape mismatch: ");const r=uc(e);return new kw(r,t,s)}(Ax("tensor",e,t,n),Ax("elementShape",e,t,n),Ax("elementDType",e,t,n));return n.addTensorList(s),[s.idTensor]}case"TensorListConcat":{const s=Ax("tensorListId",e,t,n),r=n.getTensorList(s.id),a=Ax("dtype",e,t,n),i=Ax("elementShape",e,t,n);return[r.concat(a,i)]}case"TensorListPushBack":{const s=Ax("tensorListId",e,t,n),r=Ax("tensor",e,t,n),a=n.getTensorList(s.id);return a.pushBack(r),[a.idTensor]}case"TensorListPopBack":{const s=Ax("tensorListId",e,t,n),r=Ax("elementShape",e,t,n),a=Ax("elementDType",e,t,n);return[n.getTensorList(s.id).popBack(r,a)]}case"TensorListSplit":{const s=Ax("tensor",e,t,n),r=Ax("elementShape",e,t,n),a=function(e,t,n){let s=0;const r=t.map(e=>(s+=e,s));if(s!==e.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${s}, and tensor's shape is: ${e.shape}`);const a=xw(e.shape.slice(1),n),i=0===s?0:e.size/s,o=Za(()=>{const n=[];e=Wi(e,[1,s,i]);for(let s=0;s<t.length;++s){const o=[0,0===s?0:r[s-1],0],l=[1,t[s],i];n[s]=Wi(ji(e,o,l),a)}return e.dispose(),n}),l=new kw([],n,e.dtype,t.length);for(let e=0;e<o.length;e++)l.setItem(e,o[e]);return l}(s,Ax("lengths",e,t,n),r);return n.addTensorList(a),[a.idTensor]}default:throw TypeError(`Node type ${e.op} is not implemented`)}};function Nw(e,t,n){const[s,r]=Ax("fusedOps",e,t,n),a="biasadd"===s,i="prelu"===r,o="fusedbatchnorm"===s,l=Ax("numArgs",e,t,n);if(a){if(i&&2!==l)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!i&&1!==l)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd must have one extra argument: bias.")}if(o)throw new Error("FusedConv2d and DepthwiseConv2d with FusedBatchNorm is not supported.");const u=Ax("strides",e,t,n),c=Ox(e,t,n),h=Ax("dataFormat",e,t,n).toUpperCase(),p=Ax("dilations",e,t,n),[d,f]=Ax("args",e,t,n);return{stride:u,pad:c,dataFormat:h,dilations:p,biasArg:d,preluArg:f,activationFunc:r,leakyreluAlpha:Ax("leakyreluAlpha",e,t,n)}}function Iw(e,t,n){return{boxes:Ax("boxes",e,t,n),scores:Ax("scores",e,t,n),maxOutputSize:Ax("maxOutputSize",e,t,n),iouThreshold:Ax("iouThreshold",e,t,n),scoreThreshold:Ax("scoreThreshold",e,t,n),softNmsSigma:Ax("softNmsSigma",e,t,n)}}class Cw{constructor(e,t){this.keyDType=e,this.valueDType=t,this.handle=Au(0),this.tensorMap=new Map,ei(this.handle)}get id(){return this.handle.id}clearAndClose(){this.tensorMap.forEach(e=>e.dispose()),this.tensorMap.clear(),this.handle.dispose()}size(){return this.tensorMap.size}async import(e,t){this.checkKeyAndValueTensor(e,t);const n=await e.data();return this.tensorMap.forEach(e=>e.dispose()),this.tensorMap.clear(),Za(()=>{const e=uc(t),s=n.length,r=e.length;o(s===r,()=>`The number of elements doesn't match, keys has ${s} elements, the values has ${r} elements.`);for(let t=0;t<s;t++){const s=n[t],r=e[t];ei(r),this.tensorMap.set(s,r)}return this.handle})}async find(e,t){this.checkKeyAndValueTensor(e,t);const n=await e.data();return Za(()=>{const e=[];for(let s=0;s<n.length;s++){const r=n[s],a=this.findWithDefault(r,t);e.push(a)}return Yu(e)})}findWithDefault(e,t){const n=this.tensorMap.get(e);return null!=n?n:t}checkKeyAndValueTensor(e,t){if(e.dtype!==this.keyDType)throw new Error(`Expect key dtype ${this.keyDType}, but got `+e.dtype);if(t.dtype!==this.valueDType)throw new Error(`Expect value dtype ${this.valueDType}, but got `+t.dtype)}}function Sw(e,t,n,s){const r=((e,t,n)=>{switch(e.category){case"arithmetic":return Za(()=>((e,t,n)=>{switch(e.op){case"BiasAdd":case"AddV2":case"Add":return[hi(Ax("a",e,t,n),Ax("b",e,t,n))];case"AddN":return[bi(Ax("tensors",e,t,n))];case"FloorMod":case"Mod":return[Ml(Ax("a",e,t,n),Ax("b",e,t,n))];case"Mul":return[fi(Ax("a",e,t,n),Ax("b",e,t,n))];case"RealDiv":case"Div":return[di(Ax("a",e,t,n),Ax("b",e,t,n))];case"DivNoNan":return[Ao(Ax("a",e,t,n),Ax("b",e,t,n))];case"FloorDiv":return[pi(Ax("a",e,t,n),Ax("b",e,t,n))];case"Sub":return[pl(Ax("a",e,t,n),Ax("b",e,t,n))];case"Minimum":return[_l(Ax("a",e,t,n),Ax("b",e,t,n))];case"Maximum":return[Rl(Ax("a",e,t,n),Ax("b",e,t,n))];case"Pow":return[Ql(Ax("a",e,t,n),Ax("b",e,t,n))];case"SquaredDifference":return[Ku(Ax("a",e,t,n),Ax("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"basic_math":return Za(()=>((e,t,n)=>{switch(e.op){case"Abs":case"ComplexAbs":return[mi(Ax("x",e,t,n))];case"Acos":return[gi(Ax("x",e,t,n))];case"Acosh":return[yi(Ax("x",e,t,n))];case"Asin":return[Ni(Ax("x",e,t,n))];case"Asinh":return[Ii(Ax("x",e,t,n))];case"Atan":return[Ci(Ax("x",e,t,n))];case"Atan2":return[Si(Ax("x",e,t,n),Ax("y",e,t,n))];case"Atanh":return[Ti(Ax("x",e,t,n))];case"Ceil":return[no(Ax("x",e,t,n))];case"Complex":return[Zs(Ax("real",e,t,n),Ax("imag",e,t,n))];case"Cos":return[go(Ax("x",e,t,n))];case"Cosh":return[yo(Ax("x",e,t,n))];case"Elu":return[Fo(Ax("x",e,t,n))];case"Erf":return[Do(Ax("x",e,t,n))];case"Exp":return[_o(Ax("x",e,t,n))];case"Expm1":return[Mo(Ax("x",e,t,n))];case"Floor":return[Po(Ax("x",e,t,n))];case"Log":return[Qo(Ax("x",e,t,n))];case"Log1p":return[el(Ax("x",e,t,n))];case"Imag":return[Go(Ax("x",e,t,n))];case"Neg":return[ll(Ax("x",e,t,n))];case"Reciprocal":return[wu(Ax("x",e,t,n))];case"Real":return[xu(Ax("x",e,t,n))];case"Relu":return[ku(Ax("x",e,t,n))];case"Round":return[Eu(Ax("x",e,t,n))];case"Selu":return[Ru(Ax("x",e,t,n))];case"Sigmoid":return[Hi(Ax("x",e,t,n))];case"Sin":return[Ou(Ax("x",e,t,n))];case"Sign":return[_u(Ax("x",e,t,n))];case"Sinh":return[Mu(Ax("x",e,t,n))];case"Softplus":return[ul(Ax("x",e,t,n))];case"Sqrt":return[qu(Ax("x",e,t,n))];case"Square":return[Ll(Ax("x",e,t,n))];case"Tanh":return[qi(Ax("x",e,t,n))];case"Tan":return[Qu(Ax("x",e,t,n))];case"ClipByValue":return[so(Ax("x",e,t,n),Ax("clipValueMin",e,t,n),Ax("clipValueMax",e,t,n))];case"Relu6":return[vu(Ax("x",e,t,n))];case"Rsqrt":return[$u(Rx(e.inputNames[0],t,n))];case"Prod":return[tu(Ax("x",e,t,n),Ax("axes",e,t,n))];case"LeakyRelu":return[Ko(Ax("x",e,t,n),Ax("alpha",e,t,n))];case"Prelu":return[eu(Ax("x",e,t,n),Ax("alpha",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"control":return vw(e,t,n);case"convolution":return Za(()=>((e,t,n)=>{switch(e.op){case"Conv1D":{const s=Ax("stride",e,t,n),r=Ax("pad",e,t,n),a=Ax("dataFormat",e,t,n).toUpperCase(),i=Ax("dilation",e,t,n);return[uo(Ax("x",e,t,n),Ax("filter",e,t,n),s,r,a,i)]}case"Conv2D":{const s=Ax("strides",e,t,n),r=Ox(e,t,n),a=Ax("dataFormat",e,t,n).toUpperCase(),i=Ax("dilations",e,t,n);return[lo(Ax("x",e,t,n),Ax("filter",e,t,n),[s[1],s[2]],r,a,[i[1],i[2]])]}case"_FusedConv2D":{const{stride:s,pad:r,dataFormat:a,dilations:i,biasArg:o,preluArg:l,activationFunc:u,leakyreluAlpha:c}=Nw(e,t,n);return[Ec({x:Ax("x",e,t,n),filter:Ax("filter",e,t,n),strides:[s[1],s[2]],pad:r,dataFormat:a,dilations:[i[1],i[2]],bias:o,activation:u,preluActivationWeights:l,leakyreluAlpha:c})]}case"FusedDepthwiseConv2dNative":{const{stride:s,pad:r,dataFormat:a,dilations:i,biasArg:o,preluArg:l,activationFunc:u,leakyreluAlpha:c}=Nw(e,t,n);return[Rc({x:Ax("x",e,t,n),filter:Ax("filter",e,t,n),strides:[s[1],s[2]],pad:r,dataFormat:a,dilations:[i[1],i[2]],bias:o,activation:u,preluActivationWeights:l,leakyreluAlpha:c})]}case"Conv2DBackpropInput":case"Conv2dTranspose":{const s=Ax("outputShape",e,t,n),r=Ax("strides",e,t,n),a=Ox(e,t,n);return[ho(Ax("x",e,t,n),Ax("filter",e,t,n),s,[r[1],r[2]],a)]}case"DepthwiseConv2dNative":case"DepthwiseConv2d":{const s=Ax("strides",e,t,n),r=Ox(e,t,n),a=Ax("dilations",e,t,n),i=Ax("dataFormat",e,t,n).toUpperCase();return[ko(Ax("input",e,t,n),Ax("filter",e,t,n),[s[1],s[2]],r,i,[a[1],a[2]])]}case"Conv3D":{const s=Ax("strides",e,t,n),r=Ax("pad",e,t,n),a=Ax("dataFormat",e,t,n).toUpperCase(),i=Ax("dilations",e,t,n);return[po(Ax("x",e,t,n),Ax("filter",e,t,n),[s[1],s[2],s[3]],r,a,[i[1],i[2],i[3]])]}case"AvgPool":{const s=Ax("strides",e,t,n),r=Ax("pad",e,t,n),a=Ax("kernelSize",e,t,n);return[Vi(Ax("x",e,t,n),[a[1],a[2]],[s[1],s[2]],r)]}case"MaxPool":{const s=Ax("strides",e,t,n),r=Ax("pad",e,t,n),a=Ax("kernelSize",e,t,n);return[El(Ax("x",e,t,n),[a[1],a[2]],[s[1],s[2]],r)]}case"MaxPoolWithArgmax":{const s=Ax("strides",e,t,n),r=Ax("pad",e,t,n),a=Ax("kernelSize",e,t,n),i=Ax("includeBatchInIndex",e,t,n),{result:o,indexes:l}=Al(Ax("x",e,t,n),[a[1],a[2]],[s[1],s[2]],r,i);return[o,l]}case"AvgPool3D":{const s=Ax("strides",e,t,n),r=Ax("pad",e,t,n),a=Ax("kernelSize",e,t,n);return[Ui(Ax("x",e,t,n),[a[1],a[2],a[3]],[s[1],s[2],s[3]],r)]}case"MaxPool3D":{const s=Ax("strides",e,t,n),r=Ax("pad",e,t,n),a=Ax("kernelSize",e,t,n);return[$l(Ax("x",e,t,n),[a[1],a[2],a[3]],[s[1],s[2],s[3]],r)]}case"Dilation2D":{const s=Ax("strides",e,t,n),r=Ax("pad",e,t,n),a=Ax("dilations",e,t,n),i=s[1],o=s[2],l=a[1],u=a[2];return[No(Ax("x",e,t,n),Ax("filter",e,t,n),[i,o],r,[l,u],"NHWC")]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"creation":return Za(()=>((e,t,n)=>{switch(e.op){case"Fill":{const s=Ax("shape",e,t,n),r=Ax("dtype",e,t,n);return[Bo(s,Ax("value",e,t,n),r)]}case"LinSpace":return[Jo(Ax("start",e,t,n),Ax("stop",e,t,n),Ax("num",e,t,n))];case"Multinomial":{const s=Ax("logits",e,t,n),r=Ax("numSamples",e,t,n),a=Ax("seed",e,t,n);return[Pl(s,r,a)]}case"OneHot":{const s=Ax("indices",e,t,n),r=Ax("depth",e,t,n),a=Ax("onValue",e,t,n),i=Ax("offValue",e,t,n);return[sa(s,r,a,i)]}case"Ones":return[Ul(Ax("shape",e,t,n),Ax("dtype",e,t,n))];case"OnesLike":return[Gl(Ax("x",e,t,n))];case"RandomUniform":return[yu(Ax("shape",e,t,n),Ax("minval",e,t,n),Ax("maxval",e,t,n),Ax("dtype",e,t,n))];case"Range":return[bu(Ax("start",e,t,n),Ax("stop",e,t,n),Ax("step",e,t,n),Ax("dtype",e,t,n))];case"TruncatedNormal":{const s=Ax("shape",e,t,n),r=Ax("mean",e,t,n),a=Ax("stdDev",e,t,n),i=Ax("seed",e,t,n);return[ic(s,r,a,Ax("dtype",e,t,n),i)]}case"Zeros":return[Vl(Ax("shape",e,t,n),Ax("dtype",e,t,n))];case"ZerosLike":return[$o(Ax("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"dynamic":return(async(e,t,n)=>{switch(e.op){case"NonMaxSuppressionV5":{const{boxes:s,scores:r,maxOutputSize:a,iouThreshold:i,scoreThreshold:o,softNmsSigma:l}=Iw(e,t,n),u=await kh.nonMaxSuppressionWithScoreAsync(s,r,a,i,o,l);return[u.selectedIndices,u.selectedScores]}case"NonMaxSuppressionV4":{const{boxes:s,scores:r,maxOutputSize:a,iouThreshold:i,scoreThreshold:o}=Iw(e,t,n),l=Ax("padToMaxOutputSize",e,t,n),u=await kh.nonMaxSuppressionPaddedAsync(s,r,a,i,o,l);return[u.selectedIndices,u.validOutputs]}case"NonMaxSuppressionV3":case"NonMaxSuppressionV2":{const{boxes:s,scores:r,maxOutputSize:a,iouThreshold:i,scoreThreshold:o}=Iw(e,t,n);return[await kh.nonMaxSuppressionAsync(s,r,a,i,o)]}case"Where":{const s=zr(Ax("condition",e,t,n),"bool"),r=[await pc(s)];return s.dispose(),r}case"ListDiff":return Du(Ax("x",e,t,n),Ax("y",e,t,n));default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n);case"evaluation":return Za(()=>((e,t,n)=>{switch(e.op){case"TopKV2":{const s=Ax("x",e,t,n),r=Ax("k",e,t,n),a=Ax("sorted",e,t,n),i=ac(s,r,a);return[i.values,i.indices]}case"Unique":{const s=Ax("x",e,t,n),r=oc(s);return[r.values,r.indices]}case"UniqueV2":{const s=Ax("x",e,t,n),r=Ax("axis",e,t,n),a=oc(s,r);return[a.values,a.indices]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"image":return Za(()=>((e,t,n)=>{switch(e.op){case"ResizeBilinear":{const s=Ax("images",e,t,n),r=Ax("size",e,t,n),a=Ax("alignCorners",e,t,n),i=Ax("halfPixelCenters",e,t,n);return[kh.resizeBilinear(s,[r[0],r[1]],a,i)]}case"ResizeNearestNeighbor":{const s=Ax("images",e,t,n),r=Ax("size",e,t,n),a=Ax("alignCorners",e,t,n),i=Ax("halfPixelCenters",e,t,n);return[kh.resizeNearestNeighbor(s,[r[0],r[1]],a,i)]}case"CropAndResize":{const s=Ax("image",e,t,n),r=Ax("boxes",e,t,n),a=Ax("boxInd",e,t,n),i=Ax("cropSize",e,t,n),o=Ax("method",e,t,n),l=Ax("extrapolationValue",e,t,n);return[kh.cropAndResize(s,r,a,i,o,l)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"graph":return Za(()=>((e,t,n)=>{switch(e.op){case"Const":return t[e.name];case"PlaceholderWithDefault":const s=Ax("default",e,t,n);return[Rx(e.name,t,n)||s];case"Placeholder":return[Rx(e.name,t,n)];case"Identity":case"StopGradient":case"FakeQuantWithMinMaxVars":return[Mx(Ax("x",e,t,n))];case"IdentityN":return Ax("x",e,t,n).map(e=>Mx(e));case"Snapshot":return[Mx(Ax("x",e,t,n))];case"Shape":return[ec(Ax("x",e,t,n).shape,"int32")];case"ShapeN":return Ax("x",e,t,n).map(e=>ec(e.shape));case"Size":return[Au(Ax("x",e,t,n).size,"int32")];case"Rank":return[Au(Ax("x",e,t,n).rank,"int32")];case"NoOp":return[Au(1)];case"Print":const r=Ax("x",e,t,n),a=Ax("data",e,t,n),i=Ax("message",e,t,n),o=Ax("summarize",e,t,n);console.warn("The graph has a tf.print() operation,usually used for debugging, which slows down performance."),console.log(i);for(let e=0;e<a.length;e++)console.log(Array.prototype.slice.call(a[e].dataSync()).slice(0,o));return[r];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"logical":return Za(()=>((e,t,n)=>{switch(e.op){case"Equal":return[To(Ax("a",e,t,n),Ax("b",e,t,n))];case"NotEqual":return[Wl(Ax("a",e,t,n),Ax("b",e,t,n))];case"Greater":return[Vo(Ax("a",e,t,n),Ax("b",e,t,n))];case"GreaterEqual":return[Uo(Ax("a",e,t,n),Ax("b",e,t,n))];case"Less":return[Xo(Ax("a",e,t,n),Ax("b",e,t,n))];case"LessEqual":return[Yo(Ax("a",e,t,n),Ax("b",e,t,n))];case"LogicalAnd":return[Il(Ax("a",e,t,n),Ax("b",e,t,n))];case"LogicalNot":return[Cl(Ax("a",e,t,n))];case"LogicalOr":return[Sl(Ax("a",e,t,n),Ax("b",e,t,n))];case"Select":case"SelectV2":return[Eo(Ax("condition",e,t,n),Ax("a",e,t,n),Ax("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"matrices":return Za(()=>((e,t,n)=>{switch(e.op){case"BatchMatMul":case"BatchMatMulV2":case"MatMul":return[na(Ax("a",e,t,n),Ax("b",e,t,n),Ax("transposeA",e,t,n),Ax("transposeB",e,t,n))];case"Transpose":return[ra(Ax("x",e,t,n),Ax("perm",e,t,n))];case"_FusedMatMul":const[s,r]=Ax("fusedOps",e,t,n),a="biasadd"===s,i="prelu"===r,o=Ax("numArgs",e,t,n),l=Ax("leakyreluAlpha",e,t,n);if(a){if(i&&2!==o)throw new Error("Fused MatMul with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!i&&1!==o)throw new Error("Fused MatMul with BiasAdd must have one extra argument: bias.")}const[u,c]=Ax("args",e,t,n);return[Fc({a:Ax("a",e,t,n),b:Ax("b",e,t,n),transposeA:Ax("transposeA",e,t,n),transposeB:Ax("transposeB",e,t,n),bias:u,activation:r,preluActivationWeights:c,leakyreluAlpha:l})];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"normalization":return Za(()=>((e,t,n)=>{switch(e.op){case"FusedBatchNorm":case"FusedBatchNormV2":case"FusedBatchNormV3":return[Yi(Ax("x",e,t,n),Ax("mean",e,t,n),Ax("variance",e,t,n),Ax("offset",e,t,n),Ax("scale",e,t,n),Ax("epsilon",e,t,n))];case"LRN":return[Zo(Ax("x",e,t,n),Ax("radius",e,t,n),Ax("bias",e,t,n),Ax("alpha",e,t,n),Ax("beta",e,t,n))];case"Softmax":return[Wu(Ax("x",e,t,n))];case"LogSoftmax":return[fl(Ax("x",e,t,n))];case"SparseToDense":return[yc(Ax("sparseIndices",e,t,n),Ax("outputShape",e,t,n),Ax("sparseValues",e,t,n),Ax("defaultValue",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"reduction":return Za(()=>((e,t,n)=>{switch(e.op){case"Max":{const s=Ax("axis",e,t,n),r=Ax("keepDims",e,t,n);return[hl(Ax("x",e,t,n),s,r)]}case"Mean":{const s=Ax("axis",e,t,n),r=Ax("keepDims",e,t,n);return[Fl(Ax("x",e,t,n),s,r)]}case"Min":{const s=Ax("axis",e,t,n),r=Ax("keepDims",e,t,n);return[Dl(Ax("x",e,t,n),s,r)]}case"Sum":{const s=Ax("axis",e,t,n),r=Ax("keepDims",e,t,n);return[dl(Ax("x",e,t,n),s,r)]}case"All":{const s=Ax("axis",e,t,n),r=Ax("keepDims",e,t,n);return[xi(Ax("x",e,t,n),s,r)]}case"Any":{const s=Ax("axis",e,t,n),r=Ax("keepDims",e,t,n);return[wi(Ax("x",e,t,n),s,r)]}case"ArgMax":{const s=Ax("axis",e,t,n);return[ki(Ax("x",e,t,n),s)]}case"ArgMin":{const s=Ax("axis",e,t,n);return[vi(Ax("x",e,t,n),s)]}case"Prod":{const s=Ax("axis",e,t,n),r=Ax("keepDims",e,t,n);return[tu(Ax("x",e,t,n),s,r)]}case"Cumsum":{const s=Ax("axis",e,t,n),r=Ax("exclusive",e,t,n),a=Ax("reverse",e,t,n);return[bo(Ax("x",e,t,n),s,r,a)]}case"Bincount":const s=Ax("x",e,t,n),r=Ax("weights",e,t,n),a=Ax("size",e,t,n);return[eo(s,r,a)];case"DenseBincount":{const s=Ax("x",e,t,n),r=Ax("weights",e,t,n),a=Ax("size",e,t,n),i=Ax("binaryOutput",e,t,n);return[xo(s,r,a,i)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"slice_join":return Za(()=>((e,t,n)=>{switch(e.op){case"ConcatV2":case"Concat":{const s=Ax("n",e,t,n),r=Ax("axis",e,t,n);let a=Ax("tensors",e,t,n);return a=a.slice(0,s),[Gi(a,r)]}case"Gather":{const s=Ax("x",e,t,n),r=Ax("indices",e,t,n);return[Wo(s,zr(r,"int32"),0)]}case"GatherV2":{const s=Ax("axis",e,t,n),r=Ax("batchDims",e,t,n),a=Ax("x",e,t,n),i=Ax("indices",e,t,n);return[Wo(a,zr(i,"int32"),s,r)]}case"Reverse":{const s=Ax("dims",e,t,n),r=[];for(let e=0;e<s.length;e++)s[e]&&r.push(e);const a=Ax("x",e,t,n);return[Nu(a,r)]}case"ReverseV2":{const s=Ax("axis",e,t,n),r=Ax("x",e,t,n);return[Nu(r,s)]}case"Slice":{const s=Ax("begin",e,t,n),r=Ax("size",e,t,n);return[ji(Ax("x",e,t,n),s,r)]}case"StridedSlice":{const s=Ax("begin",e,t,n),r=Ax("end",e,t,n),a=Ax("strides",e,t,n),i=Ax("beginMask",e,t,n),o=Ax("endMask",e,t,n),l=Ax("ellipsisMask",e,t,n),u=Ax("newAxisMask",e,t,n),c=Ax("shrinkAxisMask",e,t,n),h=Ax("x",e,t,n);return[Zu(h,s,r,a,i,o,l,u,c)]}case"Pack":return Za(()=>{const s=Ax("axis",e,t,n),r=Ax("tensors",e,t,n),a=r[0].shape,i=Xu(r[0]).shape,o=r.map(e=>{const t=p(e.shape,a);if(!t&&!p(Xu(e).shape,i))throw new Error("the input tensors shape does not match");return t?e:Wi(e,a)});return[Yu(o,s)]});case"Unpack":{const s=Ax("axis",e,t,n),r=Ax("tensor",e,t,n);return uc(r,s)}case"Tile":{const s=Ax("reps",e,t,n);return[Lo(Ax("x",e,t,n),s)]}case"Split":case"SplitV":{const s=Ax("axis",e,t,n),r=Ax("numOrSizeSplits",e,t,n),a=Ax("x",e,t,n);return Hu(a,r,s)}case"ScatterNd":{const s=Ax("indices",e,t,n),r=Ax("values",e,t,n),a=Ax("shape",e,t,n);return[gc(s,r,a)]}case"GatherNd":{const s=Ax("x",e,t,n),r=Ax("indices",e,t,n);return[bc(s,r)]}case"SparseToDense":{const s=Ax("sparseIndices",e,t,n),r=Ax("outputShape",e,t,n),a=Ax("sparseValues",e,t,n),i=Ax("defaultValue",e,t,n);return[yc(s,a,r,a.dtype===i.dtype?i:zr(i,a.dtype))]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"spectral":return Za(()=>((e,t,n)=>{switch(e.op){case"FFT":return[Vu(Ax("x",e,t,n))];case"IFFT":return[Uu(Ax("x",e,t,n))];case"RFFT":return[ju(Ax("x",e,t,n))];case"IRFFT":return[Gu(Ax("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"transformation":return Za(()=>((e,t,n)=>{switch(e.op){case"Cast":return[zr(Ax("x",e,t,n),Ax("dtype",e,t,n))];case"ExpandDims":{const s=Ax("axis",e,t,n);return[Oo(Ax("x",e,t,n),s)]}case"Squeeze":{const s=Ax("axis",e,t,n);return[Xu(Ax("x",e,t,n),s)]}case"Reshape":return[Wi(Ax("x",e,t,n),Ax("shape",e,t,n))];case"MirrorPad":return[Ol(Ax("x",e,t,n),Ax("padding",e,t,n),Ax("mode",e,t,n))];case"PadV2":case"Pad":return[jl(Ax("x",e,t,n),Ax("padding",e,t,n),Ax("constantValue",e,t,n))];case"SpaceToBatchND":{const s=Ax("blockShape",e,t,n),r=Ax("paddings",e,t,n);return[Jl(Ax("x",e,t,n),s,r)]}case"BatchToSpaceND":{const s=Ax("blockShape",e,t,n),r=Ax("crops",e,t,n);return[Xi(Ax("x",e,t,n),s,r)]}case"DepthToSpace":{const s=Ax("blockSize",e,t,n),r=Ax("dataFormat",e,t,n).toUpperCase();return[wo(Ax("x",e,t,n),s,r)]}case"BroadcastTo":return[to(Ax("x",e,t,n),Ax("shape",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n));case"hash_table":return(async(e,t,n,s)=>{switch(e.op){case"HashTable":case"HashTableV2":{const r=Ax("keyDType",e,t,n),a=Ax("valueDType",e,t,n),i=new Cw(r,a);return s.addHashTable(e.name,i),[i.handle]}case"LookupTableImport":case"LookupTableImportV2":{const r=Ax("tableHandle",e,t,n,s),a=Ax("keys",e,t,n),i=Ax("values",e,t,n),o=s.getHashTableById(r.id);return[await o.import(a,i)]}case"LookupTableFind":case"LookupTableFindV2":{const r=Ax("tableHandle",e,t,n,s),a=Ax("keys",e,t,n),i=Ax("defaultValue",e,t,n),o=s.getHashTableById(r.id);return[await o.find(a,i)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n,s);case"custom":const r=Ex(e.op);if(r&&r.customExecutor)return r.customExecutor(new mw(e,t,n));throw TypeError(`Custom op ${e.op} is not registered.`);default:throw TypeError(`Unknown op '${e.op}'. File an issue at https://github.com/tensorflow/tfjs/issues so we can add it, or register a custom execution with tf.registerOp()`)}})(e,t,n);return V(r)?r.then(e=>[].concat(e)):[].concat(r)}class Tw{constructor(e={},t={},n={},s={}){this.weightMap=e,this.tensorArrayMap=t,this.tensorListMap=n,this.functionMap=s,this.rootContext={id:0,frameName:"",iterationId:0},this.contexts=[this.rootContext],this.lastId=0,this.generateCurrentContextIds()}newFrame(e,t){return{id:e,frameName:t,iterationId:0}}set currentContext(e){this.contexts!==e&&(this.contexts=e,this.generateCurrentContextIds())}get currentContext(){return this.contexts}get currentContextId(){return this._currentContextIds[0]}get currentContextIds(){return this._currentContextIds}generateCurrentContextIds(){const e=[];for(let t=0;t<this.contexts.length-1;t++){const n=this.contexts.slice(0,this.contexts.length-t);e.push(this.contextIdforContexts(n))}e.push(""),this._currentContextIds=e}contextIdforContexts(e){return e?e.map(e=>0===e.id&&0===e.iterationId?"":`${e.frameName}-${e.iterationId}`).join("/"):""}enterFrame(e){this.contexts&&(this.lastId++,this.contexts=this.contexts.slice(),this.contexts.push(this.newFrame(this.lastId,e)),this._currentContextIds.unshift(this.contextIdforContexts(this.contexts)))}exitFrame(){if(!(this.contexts&&this.contexts.length>1))throw new Error("Cannot exit frame, the context is empty");this.contexts=this.contexts.slice(),this.contexts.splice(-1),this.currentContextIds.shift()}nextIteration(){if(!(this.contexts&&this.contexts.length>0))throw new Error("Cannot increase frame iteration, the context is empty");{this.contexts=this.contexts.slice(),this.lastId++;const e=Object.assign({},this.contexts[this.contexts.length-1]);e.iterationId+=1,e.id=this.lastId,this.contexts.splice(-1,1,e),this._currentContextIds.splice(0,1,this.contextIdforContexts(this.contexts))}}getWeight(e){return this.weightMap[e]}addTensorArray(e){this.tensorArrayMap[e.id]=e}getTensorArray(e){return this.tensorArrayMap[e]}addTensorList(e){this.tensorListMap[e.id]=e}getTensorList(e){return this.tensorListMap[e]}dispose(e){for(const t in this.tensorArrayMap)this.tensorArrayMap[t].clearAndClose(e);for(const t in this.tensorListMap)this.tensorListMap[t].clearAndClose(e)}}function Ew(e,t,n,s){const r=new Set,a=[];let i=null,o=null;const l=new Set,u=Object.keys(e).map(e=>_x(e)[0]);let c=[];null!=s&&(c=s.map(e=>_x(e.name)[0]));const h=[...t];for(;h.length>0;){const e=h.pop();(Fw(e)||Dw(e)||_w(e))&&null==i&&(i=e,o=i.children.map(e=>e.name).filter(e=>r.has(e))),r.add(e.name),null==n[e.name]&&(-1===u.indexOf(e.name)&&-1===c.indexOf(e.name)&&(0!==e.inputs.length?e.inputs.forEach(e=>{l.has(e.name)||(l.add(e.name),h.push(e))}):a.push(e.name)))}return{inputs:e,outputs:t,usedNodes:r,missingInputs:a,dynamicNode:i,syncInputs:o}}const $w=["Switch","Merge","Enter","Exit","NextIteration","StatelessIf","StatelessWhile","if","While"],Aw=["NonMaxSuppressionV2","NonMaxSuppressionV3","NonMaxSuppressionV5","Where"],Rw=["HashTable","HashTableV2","LookupTableImport","LookupTableImportV2","LookupTableFind","LookupTableFindV2"];function Fw(e){return $w.indexOf(e.op)>=0}function Dw(e){return Aw.indexOf(e.op)>=0}function _w(e){return Rw.indexOf(e.op)>=0}class Ow{constructor(e,t){this.graph=e,this.parent=t,this.compiledMap=new Map,this._weightMap={},this.SEPERATOR=",",this._functions={},this._functionExecutorMap={},this._outputs=e.outputs,this._inputs=e.inputs,this._initNodes=e.initNodes,this._signature=e.signature,this._functions=e.functions,null!=e.functions&&Object.keys(e.functions).forEach(t=>{this._functionExecutorMap[t]=new Ow(e.functions[t],this)})}get weightIds(){return this.parent?this.parent.weightIds:this._weightIds}get functionExecutorMap(){return this.parent?this.parent.functionExecutorMap:this._functionExecutorMap}get weightMap(){return this.parent?this.parent.weightMap:this._weightMap}set weightMap(e){const t=Object.keys(e).map(t=>e[t].map(e=>e.id));this._weightIds=[].concat(...t),this._weightMap=e}set resourceManager(e){this._resourceManager=e}get inputs(){return this._inputs.map(e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0}))}get outputs(){return this._outputs.map(e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0}))}get inputNodes(){return this._inputs.map(e=>e.signatureKey||e.name)}get outputNodes(){return this._outputs.map(e=>{const t=e.signatureKey||e.name;return e.defaultOutput?`${t}:${e.defaultOutput}`:t})}get functions(){return Object.keys(this._functions).reduce((e,t)=>(e[t]=this._functions[t].signature,e),{})}getCompilationKey(e,t){const n=e.map(e=>e.name).sort(),s=t.map(e=>e.name).sort();return n.join(this.SEPERATOR)+"--"+s.join(this.SEPERATOR)}compile(e,t){const n=Ew(e,t,this.weightMap,this._initNodes),{missingInputs:s,dynamicNode:r,syncInputs:a}=n;if(null!=r)throw new Error(`This execution contains the node '${r.name}', which has the dynamic op '${r.op}'. Please use model.executeAsync() instead. Alternatively, to avoid the dynamic ops, specify the inputs [${a}]`);if(s.length>0){const n=t.map(e=>e.name),r=Object.keys(e);throw new Error(`Cannot compute the outputs [${n}] from the provided inputs [${r}]. Missing the following inputs: [${s}]`)}return function(e,t,n){const{usedNodes:s,inputs:r}=n,a=[],i=Object.keys(r).map(e=>_x(e)[0]).map(t=>e.nodes[t]),o=e.initNodes;i.forEach(e=>{s.has(e.name)&&a.push(e)}),e.weights.forEach(e=>{s.has(e.name)&&a.push(e)}),null!=o&&o.forEach(e=>{s.has(e.name)&&a.push(e)});const l=new Set,u=[];for(;a.length>0;){const e=a.pop();l.add(e.name),t[e.name]||u.push(e),e.children.forEach(e=>{!l.has(e.name)&&s.has(e.name)&&e.inputs.every(e=>l.has(e.name))&&a.push(e)})}return u}(this.graph,this.weightMap,n)}execute(e,t){e=this.mapInputs(e);const n=Object.keys(e).sort();this.checkInputs(e),this.checkInputShapeAndType(e),t=this.mapOutputs(t),this.checkOutputs(t);const s=n.map(e=>this.graph.nodes[_x(e)[0]]),r=t.map(e=>_x(e)[0]);let a=r.map(e=>this.graph.nodes[e]);0===a.length&&(a=this._outputs);const i=this.getCompilationKey(s,a);let o=this.compiledMap.get(i);null==o&&(o=this.compile(e,a),this.compiledMap.set(i,o));const l={},u={};return Za(()=>{const n=new Tw(this.weightMap,l,u,this.functionExecutorMap),s=Object.assign({},this.weightMap);Object.keys(e).forEach(t=>{const[n,r]=_x(t),a=[];a[r]=e[t],s[n]=a});const a=this.getFrozenTensorIds(s),i={};for(let e=0;e<o.length;e++){const t=o[e];if(!s[t.name]){const e=Sw(t,s,n,this._resourceManager);if(V(e))throw new Error(`The execution of the op '${t.op}' returned a promise. Please use model.executeAsync() instead.`);s[t.name]=e,this.checkTensorForDisposal(t.name,t,s,n,a,r,i)}}return null==this.parent&&n.dispose(a),t.map(e=>Rx(e,s,n))})}getFrozenTensorIds(e){const t=[].concat.apply([],Object.keys(e).map(t=>e[t]).map(e=>e.map(e=>e.id)));return new Set(t)}checkTensorForDisposal(e,t,n,s,r,a,i){"control"!==t.category&&-1===a.indexOf(e)&&(n[e].forEach(e=>{null!=e&&(i[e.id]=(i[e.id]||0)+t.children.length)}),t.inputs.forEach(e=>{if("control"!==e.category){const t=function(e,t,n){return t[Dx(e,n.currentContextId)]}(e.name,n,s);null!=t&&t.forEach(e=>{if(e&&!r.has(e.id)){const t=i[e.id];1===t?(e.dispose(),delete i[e.id]):null!=t&&i[e.id]--}})}}))}async executeAsync(e,t){return this._executeAsync(e,t)}async _executeAsync(e,t,n=!1,s={},r={}){n||(e=this.mapInputs(e),this.checkInputs(e),this.checkInputShapeAndType(e),t=this.mapOutputs(t),this.checkOutputs(t));const a=new Tw(this.weightMap,s,r,this.functionExecutorMap),i=await this.executeWithControlFlow(e,a,t,n),o=t.map(e=>Rx(e,i,a)),l=o.map(e=>e.id),u=Object.keys(e).map(t=>e[t].id),c=new Set([...l,...u,...this.weightIds]);return Object.keys(i).forEach(e=>{i[e].forEach(e=>{!e||e.isDisposed||c.has(e.id)||e.dispose()})}),null==this.parent&&a.dispose(c),o}async executeFunctionAsync(e,t,n){const s=e.reduce((e,t,n)=>(e[this.inputs[n].name]=t,e),{});return this._executeAsync(s,this.outputNodes,!0,t,n)}async executeWithControlFlow(e,t,n,s){const r=Object.keys(e),a=r.map(e=>this.graph.nodes[_x(e)[0]]),i=n.map(e=>_x(e)[0]);let o=i.map(e=>this.graph.nodes[e]);0===o.length&&(o=this._outputs);const{usedNodes:l,missingInputs:u,dynamicNode:c,syncInputs:h}=Ew(e,o,this.weightMap,this._initNodes),p=[...a,...this.graph.weights,...this._initNodes||[]].map(e=>({node:e,contexts:t.currentContext})),d=Object.assign({},this.weightMap);Object.keys(e).forEach(t=>{const[n,s]=_x(t),r=[];r[s]=e[t],d[n]=r});const f={},m=this.getFrozenTensorIds(d),g={};for(;p.length>0;){const e=this.processStack(a,p,t,d,g,m,i,f,l);await Promise.all(e)}null!=c||s||console.warn("This model execution did not contain any nodes with control flow or dynamic output shapes. You can use model.execute() instead.");const y=o.filter(e=>!Fw(e)&&!Rx(e.name,d,t)).map(e=>e.name);if(y.length>0){let e="";throw null!=c&&(e=`Alternatively, to avoid the dynamic ops, use model.execute() and specify the inputs [${h}]`),new Error(`Cannot compute the outputs [${y}] from the provided inputs [${r}]. Consider providing the following inputs: [${u}]. ${e}`)}return d}processStack(e,t,n,s,r,a,i,o,l){const u=[];for(;t.length>0;){const e=t.pop();n.currentContext=e.contexts;let c="";if("Enter"===e.node.op&&Ax("isConstant",e.node,s,n)&&([c]=Fx(e.node.name,n)),null==s[e.node.name]){const h=Sw(e.node,s,n,this._resourceManager);c||([c]=Fx(e.node.name,n));const p=n.currentContext;V(h)?u.push(h.then(u=>(s[c]=u,n.currentContext=p,this.checkTensorForDisposal(c,e.node,s,n,a,i,o),this.processChildNodes(e.node,t,n,s,r,l),u))):(s[c]=h,this.checkTensorForDisposal(c,e.node,s,n,a,i,o),this.processChildNodes(e.node,t,n,s,r,l))}else this.processChildNodes(e.node,t,n,s,r,l)}return u}processChildNodes(e,t,n,s,r,a){e.children.forEach(e=>{const[i]=Fx(e.name,n);!r[i]&&a.has(e.name)&&("Merge"===e.op?e.inputNames.some(e=>!!Rx(e,s,n))&&(r[i]=!0,t.push({contexts:n.currentContext,node:e})):e.inputNames.every(e=>!!Rx(e,s,n))&&(r[i]=!0,t.push({contexts:n.currentContext,node:e})))})}dispose(){Object.keys(this.weightMap).forEach(e=>this.weightMap[e].forEach(e=>e.dispose()))}checkInputShapeAndType(e){Object.keys(e).forEach(t=>{const n=e[t],[s]=_x(t),r=this.graph.nodes[s];if(r.attrParams.shape&&r.attrParams.shape.value){const e=r.attrParams.shape.value;o(e.length===n.shape.length&&n.shape.every((t,n)=>-1===e[n]||e[n]===t),()=>`The shape of dict['${r.name}'] provided in model.execute(dict) must be [${e}], but was [${n.shape}]`)}r.attrParams.dtype&&r.attrParams.dtype.value&&o(n.dtype===r.attrParams.dtype.value,()=>`The dtype of dict['${r.name}'] provided in model.execute(dict) must be ${r.attrParams.dtype.value}, but was ${n.dtype}`)})}mapInputs(e){const t={};for(const n in e)if(null!=this._signature&&null!=this._signature.inputs&&null!=this._signature.inputs[n]){t[this._signature.inputs[n].name]=e[n]}else t[n]=e[n];return t}checkInputs(e){const t=Object.keys(e).filter(e=>{const[t]=_x(e);return null==this.graph.nodes[t]});if(t.length>0)throw new Error(`The dict provided in model.execute(dict) has keys: [${t}] that are not part of graph`)}mapOutputs(e){return e.map(e=>{if(null!=this._signature&&null!=this._signature.outputs&&null!=this._signature.outputs[e]){return this._signature.outputs[e].name}return e},{})}checkOutputs(e){e.forEach(e=>{const[t]=_x(e);if(!this.graph.nodes[t])throw new Error(`The output '${e}' is not found in the graph`)})}}class Mw{constructor(e={},t={}){this.hashTableNameToHandle=e,this.hashTableMap=t}addHashTable(e,t){this.hashTableNameToHandle[e]=t.handle,this.hashTableMap[t.id]=t}getHashTableHandleByName(e){return this.hashTableNameToHandle[e]}getHashTableById(e){return this.hashTableMap[e]}dispose(){for(const e in this.hashTableMap)this.hashTableMap[e].clearAndClose(),delete this.hashTableMap[e];for(const e in this.hashTableNameToHandle)this.hashTableNameToHandle[e].dispose(),delete this.hashTableNameToHandle[e]}}class Lw{constructor(e,t={}){this.modelUrl=e,this.loadOptions=t,this.version="n/a",null==t&&(this.loadOptions={}),this.resourceManager=new Mw}get modelVersion(){return this.version}get inputNodes(){return this.executor.inputNodes}get outputNodes(){return this.executor.outputNodes}get inputs(){return this.executor.inputs}get outputs(){return this.executor.outputs}get weights(){return this.executor.weightMap}get metadata(){return this.artifacts.userDefinedMetadata}get modelSignature(){return this.signature}findIOHandler(){const e=this.modelUrl;if(null!=e.load)this.handler=e;else if(null!=this.loadOptions.requestInit)this.handler=Zr(e,this.loadOptions);else{const t=dr(e,this.loadOptions);if(0===t.length)t.push(Zr(e,this.loadOptions));else if(t.length>1)throw new Error(`Found more than one (${t.length}) load handlers for URL '${[e]}'`);this.handler=t[0]}}async load(){if(this.findIOHandler(),null==this.handler.load)throw new Error("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const e=await this.handler.load();return this.loadSync(e)}loadSync(e){this.artifacts=e;const t=this.artifacts.modelTopology;let n;n=null!=this.artifacts.userDefinedMetadata&&null!=this.artifacts.userDefinedMetadata.signature?this.artifacts.userDefinedMetadata.signature:this.artifacts.signature,this.signature=n,this.version=`${t.versions.producer}.${t.versions.minConsumer}`;const s=sr(this.artifacts.weightData,this.artifacts.weightSpecs);if(this.executor=new Ow(ew.Instance.transformGraph(t,this.signature)),this.executor.weightMap=this.convertTensorMapToTensorsMap(s),this.executor.resourceManager=this.resourceManager,null!=e.modelInitializer&&null!=e.modelInitializer.node){const t=ew.Instance.transformGraph(e.modelInitializer);this.initializer=new Ow(t),this.initializer.weightMap=this.executor.weightMap,this.initializer.resourceManager=this.resourceManager,this.initializer.executeAsync({},[])}return!0}async save(e,t){if("string"==typeof e){const t=pr(e);if(0===t.length)throw new Error(`Cannot find any save handlers for URL '${e}'`);if(t.length>1)throw new Error(`Found more than one (${t.length}) save handlers for URL '${e}'`);e=t[0]}if(null==e.save)throw new Error("GraphModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");return e.save(this.artifacts)}predict(e,t){return this.execute(e,this.outputNodes)}normalizeInputs(e){if(!(e instanceof ws||Array.isArray(e)))return e;if((e=Array.isArray(e)?e:[e]).length!==this.inputNodes.length)throw new Error(`Input tensor count mismatch,the graph model has ${this.inputNodes.length} placeholders, while there are ${e.length} input tensors.`);return this.inputNodes.reduce((t,n,s)=>(t[n]=e[s],t),{})}normalizeOutputs(e){return e=e||this.outputNodes,Array.isArray(e)?e:[e]}execute(e,t){e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=this.executor.execute(e,t);return n.length>1?n:n[0]}async executeAsync(e,t){e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=await this.executor.executeAsync(e,t);return n.length>1?n:n[0]}convertTensorMapToTensorsMap(e){return Object.keys(e).reduce((t,n)=>(t[n]=[e[n]],t),{})}dispose(){this.executor.dispose(),this.initializer&&this.initializer.dispose(),this.resourceManager.dispose()}}async function zw(e,t={}){if(null==e)throw new Error("modelUrl in loadGraphModel() cannot be null. Please provide a url or an IOHandler that loads the model");null==t&&(t={}),t.fromTFHub&&null==e.load&&(e.endsWith("/")||(e+="/"),e+="model.json?tfjs-format=file");const n=new Lw(e,t);return await n.load(),n}const Bw="3.2.0";function Pw(e,t,n=new Map,s=new Set){if(null==e)return null;if(s.has(e))throw new Error("Circular references are not supported.");if(n.has(e))return n.get(e);const r=t(e);if(r.recurse&&null!==r.value)throw new Error("A deep map function may not return both a value and recurse=true.");if(r.recurse){if(Gw(e)){const r=Array.isArray(e)?[]:{};s.add(e);for(const a in e){const i=Pw(e[a],t,n,s);r[a]=i}return s.delete(e),r}throw new Error("Can't recurse into non-iterable type: "+e)}return n.set(e,r.value),r.value}function Ww(e,t=Vw){return function e(t,n,s=new Set){const r=t[0];if(s.has(r))throw new Error("Circular references are not supported.");const a=n(t);if(a.recurse&&null!==a.value)throw new Error("A deep zip function may not return both a value and recurse=true.");if(a.recurse){if(Gw(r)){const a=Array.isArray(r)?[]:{};s.add(r);for(const i in r){const r=t.map(e=>e[i]),o=e(r,n,s);a[i]=o}return s.delete(r),a}throw new Error("Can't recurse into non-iterable type: "+r)}return a.value}(e,t)}function Vw(e){return null===e?null:Gw(e[0])?{value:null,recurse:!0}:{value:e,recurse:!1}}async function Uw(e,t){const n=new Map;Pw(e,t,n);for(const e of Array.from(n.keys())){const t=n.get(e);if(V(t)){const s=await t;n.set(e,s)}}return Pw(e,t,n)}function Gw(e){return null!=e&&!ArrayBuffer.isView(e)&&(Array.isArray(e)||"object"==typeof e&&!(e instanceof ws))}function Hw(e){return function(e,t){return Pw(e,t)}(e,jw)}function jw(e){return e instanceof ws?{value:e.clone(),recurse:!1}:Gw(e)?{value:null,recurse:!0}:{value:e,recurse:!1}}class qw{constructor(e){if(this.capacity=e,this.begin=0,this.end=0,null==e)throw new RangeError("Can't create a ring buffer of unknown capacity.");if(e<1)throw new RangeError("Can't create ring buffer of capacity < 1.");this.data=new Array(e),this.doubledCapacity=2*e}wrap(e){for(;e<0;)e+=this.doubledCapacity;return e%this.doubledCapacity}get(e){if(e<0)throw new RangeError("Can't get item at a negative index.");return this.data[e%this.capacity]}set(e,t){if(e<0)throw new RangeError("Can't set item at a negative index.");this.data[e%this.capacity]=t}length(){let e=this.end-this.begin;return e<0&&(e=this.doubledCapacity+e),e}isFull(){return this.length()===this.capacity}isEmpty(){return 0===this.length()}push(e){if(this.isFull())throw new RangeError("Ring buffer is full.");this.set(this.end,e),this.end=this.wrap(this.end+1)}pushAll(e){for(const t of e)this.push(t)}pop(){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");this.end=this.wrap(this.end-1);const e=this.get(this.end);return this.set(this.end,void 0),e}unshift(e){if(this.isFull())throw new RangeError("Ring buffer is full.");this.begin=this.wrap(this.begin-1),this.set(this.begin,e)}shift(){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");const e=this.get(this.begin);return this.set(this.begin,void 0),this.begin=this.wrap(this.begin+1),e}shuffleExcise(e){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");const t=this.wrap(this.begin+e),n=this.get(t);return this.set(t,this.pop()),n}}class Kw extends qw{constructor(){super(Kw.INITIAL_CAPACITY)}isFull(){return!1}push(e){super.isFull()&&this.expand(),super.push(e)}unshift(e){super.isFull()&&this.expand(),super.unshift(e)}expand(){const e=2*this.capacity,t=new Array(e),n=this.length();for(let e=0;e<n;e++)t[e]=this.get(this.wrap(this.begin+e));this.data=t,this.capacity=e,this.doubledCapacity=2*this.capacity,this.begin=0,this.end=n}}function Xw(e){return new Qw(e)}function Yw(e){return new ek(e)}function Jw(e,t){return new hk(e,t)}Kw.INITIAL_CAPACITY=32;class Zw{async toArray(){const e=[];let t=await this.next();for(;!t.done;)e.push(t.value),t=await this.next();return e}async toArrayForTest(){const e=this.prefetch(100),t=[];let n=await e.next();for(;!n.done;)t.push(n.value),n=await e.next();return t}async resolveFully(){let e=await this.next();for(;!e.done;)e=await this.next()}async resolveWhile(e){let t=await this.next(),n=e(t.value);for(;!t.done&&n;)t=await this.next(),n=e(t.value)}handleErrors(e){return new ok(this,e)}filter(e){return new ak(this,e)}map(e){return new ik(this,e)}mapAsync(e){return new lk(this,e)}serialMapAsync(e){return new lk(this,e).serial()}flatmap(e){return new ck(this,e)}async forEachAsync(e){return this.map(e).resolveFully()}async serialForEach(e){return this.serialMapAsync(e).resolveWhile(e=>!0===e)}rowMajorBatch(e,t=!0){return new rk(this,e,t)}columnMajorBatch(e,t=!0,n=Vw){return this.rowMajorBatch(e,t).map(e=>Ww(e,n))}concatenate(e,t){return new hk(Xw([this,e]),t)}take(e){return e<0||null==e?this:new sk(this,e)}skip(e){return e<0||null==e?this:new nk(this,e)}prefetch(e){return new fk(this,e)}shuffle(e,t){return new mk(this,e,t)}serial(){return new tk(this)}}class Qw extends Zw{constructor(e){super(),this.items=e,this.trav=0}summary(){return`Array of ${this.items.length} items`}async next(){if(this.trav>=this.items.length)return{value:null,done:!0};const e=this.items[this.trav];return this.trav++,{value:Hw(e),done:!1}}}class ek extends Zw{constructor(e){super(),this.nextFn=e}summary(){return"Function call"}async next(){try{return this.nextFn()}catch(e){throw e.message="Error thrown while iterating through a dataset: "+e.message,e}}}class tk extends Zw{constructor(e){super(),this.upstream=e,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> Serial"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){return this.upstream.next()}}class nk extends Zw{constructor(e,t){super(),this.upstream=e,this.maxCount=t,this.count=0,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> Skip"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){for(;this.count++<this.maxCount;){const e=await this.upstream.next();if(e.done)return e;Qa(e.value)}return this.upstream.next()}}class sk extends Zw{constructor(e,t){super(),this.upstream=e,this.maxCount=t,this.count=0}summary(){return this.upstream.summary()+" -> Take"}async next(){return this.count++>=this.maxCount?{value:null,done:!0}:this.upstream.next()}}class rk extends Zw{constructor(e,t,n=!0){super(),this.upstream=e,this.batchSize=t,this.enableSmallLastBatch=n,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> RowMajorBatch"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){const e=[];for(;e.length<this.batchSize;){const t=await this.upstream.next();if(t.done)return this.enableSmallLastBatch&&e.length>0?{value:e,done:!1}:{value:null,done:!0};e.push(t.value)}return{value:e,done:!1}}}class ak extends Zw{constructor(e,t){super(),this.upstream=e,this.predicate=t,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> Filter"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){for(;;){const e=await this.upstream.next();if(e.done||this.predicate(e.value))return e;Qa(e.value)}}}class ik extends Zw{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return this.upstream.summary()+" -> Map"}async next(){const e=await this.upstream.next();if(e.done)return{value:null,done:!0};const t=_s(e.value),n=this.transform(e.value),s=_s(n);for(const e of t)Ds(e,s)||e.dispose();return{value:n,done:!1}}}class ok extends Zw{constructor(e,t){super(),this.upstream=e,this.handler=t,this.count=0,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return this.upstream.summary()+" -> handleErrors"}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){for(;;)try{return await this.upstream.next()}catch(e){if(!this.handler(e))return{value:null,done:!0}}}}class lk extends Zw{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return this.upstream.summary()+" -> AsyncMap"}async next(){const e=await this.upstream.next();if(e.done)return{value:null,done:!0};const t=_s(e.value),n=await this.transform(e.value),s=_s(n);for(const e of t)Ds(e,s)||e.dispose();return{value:n,done:!1}}}class uk extends Zw{constructor(){super(),this.outputQueue=new Kw,this.lastRead=Promise.resolve({value:null,done:!1})}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}async serialNext(){for(;0===this.outputQueue.length();)if(!await this.pump())return{value:null,done:!0};return{value:this.outputQueue.shift(),done:!1}}}class ck extends uk{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return this.upstream.summary()+" -> Flatmap"}async pump(){const e=await this.upstream.next();if(e.done)return!1;const t=_s(e.value),n=this.transform(e.value),s=_s(n);this.outputQueue.pushAll(n);for(const e of t)Ds(e,s)||e.dispose();return!0}}class hk extends Zw{constructor(e,t){super(),this.baseErrorHandler=t,this.lastRead=null,this.iterator=null,this.moreIterators=e}summary(){return"TODO: fill in upstream of chained summaries -> Chained"}async next(){return this.lastRead=this.readFromChain(this.lastRead),this.lastRead}async readFromChain(e){if(await e,null==this.iterator){const e=await this.moreIterators.next();if(e.done)return{value:null,done:!0};this.iterator=e.value,null!=this.baseErrorHandler&&(this.iterator=this.iterator.handleErrors(this.baseErrorHandler))}const t=await this.iterator.next();return t.done?(this.iterator=null,this.readFromChain(e)):t}}var pk;!function(e){e[e.FAIL=0]="FAIL",e[e.SHORTEST=1]="SHORTEST",e[e.LONGEST=2]="LONGEST"}(pk||(pk={}));class dk extends Zw{constructor(e,t=pk.FAIL){super(),this.iterators=e,this.mismatchMode=t,this.count=0,this.currentPromise=null}summary(){return"{TODO: fill in upstream of zip summaries} -> Zip"}async nextState(e){await e;let t=0,n=0;const s=await Uw(this.iterators,(function(e){if(e instanceof Zw){return{value:e.next().then(e=>(t++,e.done&&n++,e.value)),recurse:!1}}return{value:null,recurse:!0}}));if(t===n)return{value:null,done:!0};if(n>0)switch(this.mismatchMode){case pk.FAIL:throw new Error(`Zipped streams should have the same length. Mismatched at element ${this.count}.`);case pk.SHORTEST:return{value:null,done:!0};case pk.LONGEST:}return this.count++,{value:s,done:!1}}async next(){return this.currentPromise=this.nextState(this.currentPromise),this.currentPromise}}class fk extends Zw{constructor(e,t){super(),this.upstream=e,this.bufferSize=t,this.buffer=new qw(t)}summary(){return this.upstream.summary()+" -> Prefetch"}refill(){for(;!this.buffer.isFull();){const e=this.upstream.next();this.buffer.push(e)}}next(){return this.refill(),this.buffer.shift()}}class mk extends fk{constructor(e,t,n){super(e,t),this.upstream=e,this.windowSize=t,this.upstreamExhausted=!1,this.random=hu(n||rs().toString()),this.lastRead=Promise.resolve({value:null,done:!1})}async next(){return this.lastRead=this.lastRead.then(()=>this.serialNext()),this.lastRead}randomInt(e){return Math.floor(this.random()*e)}chooseIndex(){return this.randomInt(this.buffer.length())}async serialNext(){for(this.upstreamExhausted||this.refill();!this.buffer.isEmpty();){const e=this.chooseIndex(),t=await this.buffer.shuffleExcise(e);if(!t.done)return this.refill(),t;this.upstreamExhausted=!0}return{value:null,done:!0}}}class gk{constructor(){this.size=null}batch(e,t=!0){const n=this;let s;return o(e>0,()=>"batchSize needs to be positive, but it is\n      "+e),s=this.size===1/0||null==this.size?this.size:t?Math.ceil(this.size/e):Math.floor(this.size/e),yk(async()=>(await n.iterator()).columnMajorBatch(e,t,bk),s)}concatenate(e){const t=this;let n;return n=this.size===1/0||e.size===1/0?1/0:null!=this.size&&null!=e.size?this.size+e.size:null,yk(async()=>(await t.iterator()).concatenate(await e.iterator()),n)}filter(e){const t=this;let n;return n=this.size===1/0?1/0:null,yk(async()=>(await t.iterator()).filter(t=>Za(()=>e(t))),n)}async forEachAsync(e){return(await this.iterator()).forEachAsync(e)}map(e){const t=this;return yk(async()=>(await t.iterator()).map(t=>Za(()=>e(t))),this.size)}mapAsync(e){const t=this;return yk(async()=>(await t.iterator()).mapAsync(e),this.size)}prefetch(e){if(null==e)throw new RangeError("`Dataset.prefetch()` requires bufferSize to be specified.");const t=this;return yk(async()=>(await t.iterator()).prefetch(e),this.size)}repeat(e){const t=this;let n;return n=null!=this.size&&e>0?this.size*e:0===e?0:null!=this.size&&(void 0===e||e<0)?1/0:null,yk(async()=>Jw(Yw(async()=>({value:await t.iterator(),done:!1})).take(e)),n)}skip(e){const t=this;let n;return n=null!=this.size&&e>=0&&this.size>=e?this.size-e:null!=this.size&&(this.size<e||void 0===e||e<0)?0:null,yk(async()=>(await t.iterator()).skip(e),n)}shuffle(e,t,n=!0){if(null==e||e<0)throw null==this.size?new RangeError("`Dataset.shuffle()` requires bufferSize to be specified."):new RangeError(`\`Dataset.shuffle()\` requires bufferSize to be specified.  If your data fits in main memory (for regular JS objects), and/or GPU memory (for \`tf.Tensor\`s), consider setting bufferSize to the dataset size (${this.size} elements)`);const s=this,r=hu(t||rs().toString());return yk(async()=>{let t=r.int32();return n&&(t+=r.int32()),(await s.iterator()).shuffle(e,t.toString())},this.size)}take(e){const t=this;let n;return n=null!=this.size&&this.size>e?e:null!=this.size&&this.size<=e?this.size:null,yk(async()=>(await t.iterator()).take(e),n)}async toArray(){if(this.size===1/0)throw new Error("Can not convert infinite data stream to array.");return(await this.iterator()).toArray()}async toArrayForTest(){if(this.size===1/0)throw new Error("Can not convert infinite data stream to array.");return(await this.iterator()).toArrayForTest()}}function yk(e,t=null){return new class extends gk{constructor(){super(...arguments),this.size=t}async iterator(){return e()}}}function bk(e){if(null===e)return null;const t=e[0];if(null==(n=t)||null===(s=n)||"object"!=typeof s&&"function"!=typeof s||Array.isArray(n)||"object"==typeof n&&n instanceof ws||C(n)){return{value:function(e){if(0===e.length)throw new Error("Can't make a batch of zero elements.");return e[0]instanceof ws?Yu(e):er(e)}(e),recurse:!1}}var n,s;return{value:null,recurse:!0}}gk.MAX_BUFFER_SIZE=1e4;class xk extends gk{constructor(e){super(),this.input=e}async iterator(){return(await this.input.iterator()).decodeUTF8().split("\n").map(e=>(e.endsWith("\r")&&(e=e.slice(0,-1)),e))}}const wk=Symbol("out"),kk=Symbol("field"),vk=Symbol("quote"),Nk=Symbol("quoteafterquote"),Ik=Symbol("quoteinquote");class Ck extends gk{constructor(e,t){super(),this.input=e,this.hasHeader=!0,this.fullColumnNames=null,this.columnNamesValidated=!1,this.columnConfigs=null,this.configuredColumnsOnly=!1,this.delimiter=",",this.delimWhitespace=!1,this.base=new xk(e),t||(t={}),this.hasHeader=!1!==t.hasHeader,this.fullColumnNames=t.columnNames,this.columnConfigs=t.columnConfigs,this.configuredColumnsOnly=t.configuredColumnsOnly,t.delimWhitespace?(o(null==t.delimiter,()=>"Delimiter should not be provided when delimWhitespace is true."),this.delimWhitespace=!0,this.delimiter=" "):this.delimiter=t.delimiter?t.delimiter:","}async columnNames(){return this.columnNamesValidated||await this.setColumnNames(),this.configuredColumnsOnly?Object.keys(this.columnConfigs):this.fullColumnNames}async setColumnNames(){const e=await this.maybeReadHeaderLine();if(!this.fullColumnNames&&!e)throw new Error("Column names must be provided if there is no header line.");this.fullColumnNames&&e&&o(e.length===this.fullColumnNames.length,()=>"The length of provided columnNames ("+this.fullColumnNames.length.toString()+") does not match the length of the header line read from file ("+e.length.toString()+")."),this.fullColumnNames||(this.fullColumnNames=e);const t=this.fullColumnNames.reduce((e,t)=>(e[t]=e[t]+1||1,e),{}),n=Object.keys(t).filter(e=>t[e]>1);if(o(0===n.length,()=>"Duplicate column names found: "+n.toString()),this.columnConfigs)for(const e of Object.keys(this.columnConfigs)){if(-1===this.fullColumnNames.indexOf(e))throw new Error('The key "'+e+'" provided in columnConfigs does not match any of the column names ('+this.fullColumnNames.toString()+").")}this.columnNamesValidated=!0}async maybeReadHeaderLine(){if(this.hasHeader){const e=await this.base.iterator(),t=await e.next();if(t.done)throw new Error("No data was found for CSV parsing.");const n=t.value;return this.parseRow(n,!1)}return null}async iterator(){this.columnNamesValidated||await this.setColumnNames();let e=await this.base.iterator();return this.hasHeader&&(e=e.skip(1)),e.map(e=>this.makeDataElement(e))}makeDataElement(e){const t=this.parseRow(e),n={},s={};for(let r=0;r<this.fullColumnNames.length;r++){const a=this.fullColumnNames[r],i=this.columnConfigs?this.columnConfigs[a]:null;if(!this.configuredColumnsOnly||i){const o=t[r];let l=null;if(""===o)if(i&&void 0!==i.default)l=i.default;else{if(i&&(i.required||i.isLabel))throw new Error(`Required column ${a} is empty in this line: ${e}`);l=void 0}else{const e=Number(o);if(isNaN(e))l=i&&"bool"===i.dtype?this.getBoolean(o):o;else if(i&&i.dtype)switch(i.dtype){case"float32":l=e;break;case"int32":l=Math.floor(e);break;case"bool":l=this.getBoolean(o);break;default:l=e}else l=e}i&&i.isLabel?s[a]=l:n[a]=l}}return 0===Object.keys(s).length?n:{xs:n,ys:s}}getBoolean(e){return"1"===e||"true"===e.toLowerCase()?1:0}parseRow(e,t=!0){const n=[];let s=0;const r=e.length;let a=wk;for(let t=0;t<r;t++)switch(a){case wk:switch(e.charAt(t)){case'"':s=t+1,a=vk;break;case this.delimiter:if(s=t+1," "===this.delimiter&&this.delimWhitespace)break;n.push(""),a=wk;break;default:a=kk,s=t}break;case kk:switch(e.charAt(t)){case this.delimiter:n.push(e.substring(s,t)),a=wk,s=t+1}break;case vk:switch(e.charAt(t)){case'"':a=Nk}break;case Nk:switch(e.charAt(t)){case this.delimiter:n.push(e.substring(s,t-1)),a=wk,s=t+1;break;case'"':a=vk;break;default:a=Ik}break;case Ik:switch(e.charAt(t)){case'"':a=vk}}if(a===Nk?n.push(e.substring(s,r-1)):n.push(e.substring(s)),t&&n.length!==this.fullColumnNames.length)throw new Error(`Invalid row in csv file. Should have ${this.fullColumnNames.length} elements in a row, but got ${n}`);return n}}class Sk extends Zw{constructor(e){super(),this.microphoneConfig=e,this.isClosed=!1,this.fftSize=e.fftSize||1024;const t=Math.log2(this.fftSize);if(this.fftSize<0||t<4||t>14||!Number.isInteger(t))throw new Error("Invalid fftSize: it must be a power of 2 between 2 to 4 and 2 to 14, but got "+this.fftSize);if(this.numFrames=e.numFramesPerSpectrogram||43,this.sampleRateHz=e.sampleRateHz,this.columnTruncateLength=e.columnTruncateLength||this.fftSize,this.audioTrackConstraints=e.audioTrackConstraints,this.smoothingTimeConstant=e.smoothingTimeConstant||0,this.includeSpectrogram=!1!==e.includeSpectrogram,this.includeWaveform=!0===e.includeWaveform,!this.includeSpectrogram&&!this.includeWaveform)throw new Error("Both includeSpectrogram and includeWaveform are false. At least one type of data should be returned.")}summary(){return"microphone"}static async create(e={}){if(G().get("IS_NODE"))throw new Error("microphone API is only supported in browser environment.");const t=new Sk(e);return await t.start(),t}async start(){try{this.stream=await navigator.mediaDevices.getUserMedia({audio:null==this.audioTrackConstraints||this.audioTrackConstraints,video:!1})}catch(e){throw new Error("Error thrown while initializing video stream: "+e.message)}if(!this.stream)throw new Error("Could not obtain audio from microphone.");const e=window.AudioContext||window.webkitAudioContext;if(this.audioContext=new e,this.sampleRateHz){if(this.audioContext.sampleRate!==this.sampleRateHz)throw new Error(`Mismatch in sampling rate: Expected: ${this.sampleRateHz}; Actual: `+this.audioContext.sampleRate)}else this.sampleRateHz=this.audioContext.sampleRate;const t=this.audioContext.createMediaStreamSource(this.stream);this.analyser=this.audioContext.createAnalyser(),this.analyser.fftSize=2*this.fftSize,this.analyser.smoothingTimeConstant=this.smoothingTimeConstant,t.connect(this.analyser),this.freqData=new Float32Array(this.fftSize),this.timeData=new Float32Array(this.fftSize)}async next(){if(this.isClosed)return{value:null,done:!0};let e,t;const n=await this.getAudioData();if(this.includeSpectrogram){const t=this.flattenQueue(n.freqDataQueue);e=this.getTensorFromAudioDataArray(t,[this.numFrames,this.columnTruncateLength,1])}if(this.includeWaveform){const e=this.flattenQueue(n.timeDataQueue);t=this.getTensorFromAudioDataArray(e,[this.numFrames*this.fftSize,1])}return{value:{spectrogram:e,waveform:t},done:!1}}async capture(){return(await this.next()).value}async getAudioData(){const e=[],t=[];let n=0;return new Promise(s=>{const r=setInterval(()=>{this.includeSpectrogram&&(this.analyser.getFloatFrequencyData(this.freqData),this.freqData[0]===-1/0&&s({freqDataQueue:e,timeDataQueue:t}),e.push(this.freqData.slice(0,this.columnTruncateLength))),this.includeWaveform&&(this.analyser.getFloatTimeDomainData(this.timeData),t.push(this.timeData.slice())),++n===this.numFrames&&(clearInterval(r),s({freqDataQueue:e,timeDataQueue:t}))},this.fftSize/this.sampleRateHz*1e3)})}stop(){this.isClosed||(this.isClosed=!0,this.analyser.disconnect(),this.audioContext.close(),null!=this.stream&&this.stream.getTracks().length>0&&this.stream.getTracks()[0].stop())}toArray(){throw new Error("Can not convert infinite audio stream to array.")}getSampleRate(){return this.sampleRateHz}flattenQueue(e){const t=e[0].length,n=new Float32Array(e.length*t);return e.forEach((e,s)=>n.set(e,s*t)),n}getTensorFromAudioDataArray(e,t){const n=new Float32Array(h(t));return n.set(e,n.length-e.length),er(n,t)}}class Tk extends Zw{constructor(e,t){if(super(),this.webcamVideoElement=e,this.webcamConfig=t,this.isClosed=!0,this.resize=!1,this.needToResize())if(this.resize=!0,this.cropSize=[this.webcamConfig.resizeHeight,this.webcamConfig.resizeWidth],this.cropBoxInd=ec([0],"int32"),this.webcamConfig.centerCrop){const e=1*this.webcamConfig.resizeWidth/this.webcamVideoElement.width,t=1*this.webcamConfig.resizeHeight/this.webcamVideoElement.height,n=(1-e)/2,s=(1-t)/2,r=n+e,a=t+s;this.cropBox=tc([s,n,a,r],[1,4])}else this.cropBox=tc([0,0,1,1],[1,4])}summary(){return"webcam"}static async create(e,t={}){if(G().get("IS_NODE"))throw new Error("tf.data.webcam is only supported in browser environment.");if(!e){if(e=document.createElement("video"),!t.resizeWidth||!t.resizeHeight)throw new Error("Please provide webcam video element, or resizeWidth and resizeHeight to create a hidden video element.");e.width=t.resizeWidth,e.height=t.resizeHeight}const n=new Tk(e,t);return await n.start(),n}async start(){this.webcamConfig.facingMode&&o("user"===this.webcamConfig.facingMode||"environment"===this.webcamConfig.facingMode,()=>`Invalid webcam facing mode: ${this.webcamConfig.facingMode}. Please provide 'user' or 'environment'`);try{this.stream=await navigator.mediaDevices.getUserMedia({video:{deviceId:this.webcamConfig.deviceId,facingMode:this.webcamConfig.facingMode?this.webcamConfig.facingMode:"user",width:this.webcamVideoElement.width,height:this.webcamVideoElement.height}})}catch(e){throw e.message="Error thrown while initializing video stream: "+e.message,e}if(!this.stream)throw new Error("Could not obtain video from webcam.");try{this.webcamVideoElement.srcObject=this.stream}catch(e){console.log(e),this.webcamVideoElement.src=window.URL.createObjectURL(this.stream)}return this.webcamVideoElement.play(),this.isClosed=!1,new Promise(e=>{this.webcamVideoElement.onloadedmetadata=()=>{e()}})}async next(){if(this.isClosed)return{value:null,done:!0};let e;try{e=ua(this.webcamVideoElement)}catch(e){throw new Error("Error thrown converting video to pixels: "+JSON.stringify(e))}if(!this.resize)return{value:e,done:!1};try{return{value:this.cropAndResizeFrame(e),done:!1}}catch(e){throw new Error("Error thrown cropping the video: "+e.message)}finally{e.dispose()}}needToResize(){return!(!this.webcamConfig.resizeWidth||!this.webcamConfig.resizeHeight||this.webcamVideoElement.width===this.webcamConfig.resizeWidth&&this.webcamVideoElement.height===this.webcamConfig.resizeHeight)}cropAndResizeFrame(e){return Za(()=>{const t=Oo(zr(e,"float32"),0);let n;n=kh.cropAndResize(t,this.cropBox,this.cropBoxInd,this.cropSize,"bilinear");const s=n.shape;return Wi(n,s.slice(1))})}async capture(){return(await this.next()).value}stop(){this.stream.getTracks().forEach(e=>e.stop());try{this.webcamVideoElement.srcObject=null}catch(e){console.log(e),this.webcamVideoElement.src=null}this.isClosed=!0}toArray(){throw new Error("Can not convert infinite video stream to array.")}}class Ek{}class $k extends Zw{split(e){return new Ak(this,e)}}class Ak extends $k{constructor(e,t){super(),this.upstream=e,this.impl=new Rk(e,t)}summary(){return this.impl.summary()}async next(){return this.impl.next()}}class Rk extends uk{constructor(e,t){super(),this.upstream=e,this.separator=t,this.carryover=""}summary(){return`${this.upstream.summary()} -> Split('${this.separator}')`}async pump(){const e=await this.upstream.next();if(e.done)return""!==this.carryover&&(this.outputQueue.push(this.carryover),this.carryover="",!0);const t=e.value.split(this.separator);t[0]=this.carryover+t[0];for(const e of t.slice(0,-1))this.outputQueue.push(e);return this.carryover=t[t.length-1],!0}}class Fk extends Zw{decodeUTF8(){return new Dk(this)}}class Dk extends $k{constructor(e){super(),this.upstream=e,this.impl=new _k(e)}summary(){return this.impl.summary()}async next(){return this.impl.next()}}class _k extends uk{constructor(e){if(super(),this.upstream=e,G().get("IS_BROWSER"))this.decoder=new TextDecoder("utf-8");else{const{StringDecoder:e}=require("string_decoder");this.decoder=new e("utf8")}}summary(){return this.upstream.summary()+" -> Utf8"}async pump(){const e=await this.upstream.next();let t,n;return!e.done&&(t=e.value,n=G().get("IS_BROWSER")?this.decoder.decode(t,{stream:!0}):this.decoder.write(Buffer.from(t.buffer)),this.outputQueue.push(n),!0)}}class Ok extends Fk{constructor(e,t={}){super(),this.file=e,this.options=t,o(e instanceof Uint8Array||!!G().get("IS_BROWSER")&&(e instanceof File||e instanceof Blob),()=>"FileChunkIterator only supports File, Blob and Uint8Array right now."),this.offset=t.offset||0,this.chunkSize=t.chunkSize||1048576}summary(){return"FileChunks "+this.file}async next(){if(this.offset>=(this.file instanceof Uint8Array?this.file.byteLength:this.file.size))return{value:null,done:!0};const e=new Promise((e,t)=>{const n=this.offset+this.chunkSize;if(this.file instanceof Uint8Array)e(new Uint8Array(this.file.slice(this.offset,n)));else{const s=new FileReader;s.onload=n=>{let r=s.result;if(r instanceof ArrayBuffer&&(r=new Uint8Array(r)),!(r instanceof Uint8Array))return t(new TypeError("FileReader returned unknown type."));e(r)},s.onabort=e=>t(new Error("Aborted")),s.onerror=e=>t(new Error(e.type));const r=this.file.slice(this.offset,n);s.readAsArrayBuffer(r)}this.offset=n});return{value:await e,done:!1}}}const Mk=e=>({method:e.method,headers:e.headers,body:e.body,mode:e.mode,credentials:e.credentials,cache:e.cache,redirect:e.redirect,referrer:e.referrer,integrity:e.integrity});function Lk(e){return"string"==typeof e&&"file://"===e.substr(0,7)}class zk extends Ek{constructor(e,t={}){super(),this.input=e,this.options=t}async iterator(){if(Lk(this.input)&&G().get("IS_NODE")){const e=require("fs");this.input=e.readFileSync(this.input.substr(7))}return new Ok(this.input,this.options)}}class Bk extends Ek{constructor(e,t={}){super(),this.url=e,this.fileOptions=t}async iterator(){return Lk(this.url)?new zk(this.url,this.fileOptions).iterator():async function(e,t={}){let n,s;"string"==typeof e?n=e:(n=e.url,s=Mk(e));const r=await as(n,s);if(r.ok){const e=new Uint8Array(await r.arrayBuffer());return new Ok(e,t)}throw new Error(r.statusText)}(this.url,this.fileOptions)}}var Pk=Object.freeze({__proto__:null,array:function(e){return yk(async()=>Xw(e),e.length)},Dataset:gk,zip:function(e){if(!Gw(e))throw new Error("The argument to zip() must be an object or array.");let t;if(Array.isArray(e))for(let n=0;n<e.length;n++)t=null==t?e[n].size:Math.min(t,e[n].size);else if(e instanceof Object)for(const n in e)t=null==t?e[n].size:Math.min(t,e[n].size);return yk(async()=>function(e,t=pk.FAIL){return new dk(e,t)}(await Uw(e,e=>{if(e instanceof gk)return{value:e.iterator(),recurse:!1};if(Gw(e))return{value:null,recurse:!0};throw new Error("Leaves of the structure passed to zip() must be Datasets, not primitives.")}),pk.SHORTEST),t)},CSVDataset:Ck,TextLineDataset:xk,csv:function(e,t={}){return new Ck(new Bk(e),t)},func:function(e){const t=Yw(e);return yk(async()=>t)},generator:function(e){return yk(async()=>{const t=await e();return Yw(()=>t.next())})},microphone:async function(e){return Sk.create(e)},webcam:async function(e,t){return Tk.create(e,t)},FileDataSource:zk,URLDataSource:Bk,version_data:"3.2.0"});function Wk(e,t){Array.isArray(e)||(e=[e]),e.forEach(e=>{null!=e&&o("complex64"!==e.dtype,()=>t+" does not support complex64 tensors in the CPU backend.")})}const Vk=hc;class Uk extends t{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new e(this,Xa())}nextDataId(){return Uk.nextDataId++}write(e,t,n){this.firstUse&&(this.firstUse=!1,G().get("IS_NODE")&&jh("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));const s={id:this.nextDataId()};return this.data.set(s,{values:e,dtype:n,refCount:1}),s}makeTensorInfo(e,t,n){let s;if("string"===t&&null!=n&&n.length>0&&E(n[0])){const r=n.map(e=>is(e));s=this.write(r,e,t)}else s=this.write(n,e,t);return{dataId:s,shape:e,dtype:t}}refCount(e){if(this.data.has(e)){return this.data.get(e).refCount}return 0}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,n,s,r){this.data.set(e,{values:t,dtype:s,refCount:r})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:t,complexTensorInfos:n}=this.data.get(e);if("complex64"===t){return qh(this.readSync(n.real.dataId),this.readSync(n.imag.dataId))}return this.data.get(e).values}bufferSync(e){const t=this.readSync(e.dataId);let n=t;if("string"===e.dtype)try{n=t.map(e=>os(e))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return Lr(e.shape,e.dtype,n)}makeOutput(e,t,n){const s=this.write(e,t,n);return Xa().makeTensorFromDataId(s,t,n,this)}disposeData(e,t=!1){if(this.data.has(e)){if(this.data.get(e).refCount--,!t&&this.data.get(e).refCount>0)return!1;const{complexTensorInfos:n}=this.data.get(e);null!=n&&(this.disposeData(n.real.dataId,!0),this.disposeData(n.imag.dataId,!0)),this.data.delete(e)}return!0}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}async time(e){const t=rs();return e(),{kernelMs:rs()-t}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}where(e){Wk([e],"where");const t=this.readSync(e.dataId);return Vk(e.shape,t)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}}function Gk(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t}Uk.nextDataId=0;const Hk={kernelName:"Abs",backendName:"cpu",kernelFunc:e=>{const{x:t}=e.inputs,n=e.backend;Wk(t,"abs");let s=new Float32Array(h(t.shape));return s=Gk(n.data.get(t.dataId).values),n.makeOutput(s,t.shape,"float32")}};function jk(e){return(t,n,s,r,a)=>{const i=So(t,n),o=i.length,l=_(i),u=w(a,h(i)),c=t.length,p=n.length,d=_(t),f=_(n),m=Io(t,i),g=Io(n,i);if(m.length+g.length===0)for(let t=0;t<u.length;++t)u[t]=e(s[t%s.length],r[t%r.length]);else for(let t=0;t<u.length;++t){const n=W(t,o,l),a=n.slice(-c);m.forEach(e=>a[e]=0);const i=P(a,c,d),h=n.slice(-p);g.forEach(e=>h[e]=0);const y=P(h,p,f);u[t]=e(s[i],r[y])}return[u,i]}}function qk(e){const{inputs:t,backend:n}=e,{real:s,imag:r}=t,a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,o=n.makeTensorInfo(s.shape,"complex64");return n.data.get(o.dataId).complexTensorInfos={real:n.makeTensorInfo(s.shape,"float32",a),imag:n.makeTensorInfo(r.shape,"float32",i)},o}const Kk={kernelName:"Complex",backendName:"cpu",kernelFunc:qk};function Xk(e,t,n="float32"){if("complex64"===n){return qk({inputs:{real:Xk(e,t,"float32"),imag:Xk(e,t,"float32")},backend:e})}const s=L(h(t),n);return e.makeTensorInfo(t,n,s)}function Yk(e){const{inputs:t,backend:n}=e,{x:s}=t;return n.incRef(s.dataId),{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}const Jk={kernelName:"Identity",backendName:"cpu",kernelFunc:Yk};function Zk(e){const{inputs:t,backend:n}=e,{input:s}=t,r=n.data.get(s.dataId).complexTensorInfos.real,a=n.data.get(r.dataId).values;return n.makeTensorInfo(r.shape,r.dtype,a)}const Qk={kernelName:"Real",backendName:"cpu",kernelFunc:Zk};function ev(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dtype:a}=s;if("complex64"===a){if("complex64"===r.dtype)return Yk({inputs:{x:r},backend:n});const e=Xk(n,r.shape,r.dtype),t=ev({inputs:{x:r},backend:n,attrs:{dtype:"float32"}}),s=qk({inputs:{real:t,imag:e},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),s}if("complex64"===r.dtype){const e=Zk({inputs:{input:r},backend:n}),t=ev({inputs:{x:e},backend:n,attrs:{dtype:a}});return n.disposeIntermediateTensorInfo(e),t}if(!I(r.dtype,a)){const e=Yk({inputs:{x:r},backend:n});return{dataId:e.dataId,shape:e.shape,dtype:a}}if("int32"===a){const e=n.data.get(r.dataId).values,t=Int32Array.from(e);return n.makeTensorInfo(r.shape,"int32",t)}if("bool"===a){const e=n.data.get(r.dataId).values,t=ss([0],r.dtype),[s,a]=jk((e,t)=>e!==t?1:0)(r.shape,[],e,t,"bool");return n.makeTensorInfo(a,"bool",s)}throw new Error(`Error in Cast: failed to cast ${r.dtype} to ${a}`)}const tv={kernelName:"Cast",backendName:"cpu",kernelFunc:ev};function nv(e,t,n,s){return null==n?({inputs:n,backend:r})=>{const{a:a,b:i}=n,o=r;Wk([a,i],e);const l=o.data.get(a.dataId).values,u=o.data.get(i.dataId).values,c=s||a.dtype,[h,p]=t(a.shape,i.shape,l,u,c);return o.makeTensorInfo(p,c,h)}:({inputs:e,backend:r})=>{const{a:a,b:i}=e,o=r;if("complex64"===a.dtype||"complex64"===i.dtype){const e=ev({inputs:{x:a},backend:o,attrs:{dtype:"complex64"}}),t=o.data.get(e.dataId),s=t.complexTensorInfos.real,r=t.complexTensorInfos.imag,l=o.data.get(s.dataId).values,u=o.data.get(r.dataId).values,c=ev({inputs:{x:i},backend:o,attrs:{dtype:"complex64"}}),h=o.data.get(c.dataId),p=h.complexTensorInfos.real,d=h.complexTensorInfos.imag,f=o.data.get(p.dataId).values,m=o.data.get(d.dataId).values,[g,y,b]=n(a.shape,i.shape,l,u,f,m),x=o.makeTensorInfo(b,"float32",g),w=o.makeTensorInfo(b,"float32",y),k=qk({inputs:{real:x,imag:w},backend:o});return o.disposeIntermediateTensorInfo(e),o.disposeIntermediateTensorInfo(c),o.disposeIntermediateTensorInfo(x),o.disposeIntermediateTensorInfo(w),k}{const e=o.data.get(a.dataId).values,n=o.data.get(i.dataId).values,r=s||a.dtype,[l,u]=t(a.shape,i.shape,e,n,r);return o.makeTensorInfo(u,r,l)}}}function sv(e){return(t,n,s,r,a,i)=>{const o=So(t,n),l=h(o),u=o.length,c=_(o),p=w("float32",l),d=w("float32",l),f=Io(t,o),m=Io(n,o),g=qh(s,r),y=qh(a,i),b=t.length,x=_(t),k=n.length,v=_(n);if(f.length+m.length===0)for(let t=0;t<p.length;t++){const n=t%g.length,s=t%y.length,r=e(g[2*n],g[2*n+1],y[2*s],y[2*s+1]);p[t]=r.real,d[t]=r.imag}else for(let t=0;t<p.length;t++){const n=W(t,u,c),s=n.slice(-b);f.forEach(e=>s[e]=0);const r=P(s,b,x),a=n.slice(-k);m.forEach(e=>a[e]=0);const i=P(a,k,v),o=e(g[2*r],g[2*r+1],y[2*i],y[2*i+1]);p[t]=o.real,d[t]=o.imag}return[p,d,o]}}const rv=jk((e,t)=>e+t),av=sv((e,t,n,s)=>({real:e+n,imag:t+s})),iv=nv(Z,rv,av),ov={kernelName:Z,backendName:"cpu",kernelFunc:iv};function lv(e,t,n,s,r){const a=h(s),i=L(r,n);for(let n=0;n<e.length;n++){const s=e[n];if(s<0)throw new Error("Input x must be non-negative!");s>=r||(i[s]+=a>0?t[n]:1)}return i}function uv(e,t,n,s=!1){const r=e.shape[0],a=e.shape[1],i=Lr([r,n],t.dtype);for(let o=0;o<r;o++)for(let r=0;r<a;r++){const a=e.get(o,r);if(a<0)throw new Error("Input x must be non-negative!");a>=n||(s?i.set(1,o,a):t.size>0?i.set(i.get(o,a)+t.get(o,r),o,a):i.set(i.get(o,a)+1,o,a))}return i}function cv(e){return(t,n,s)=>{const r=w(n,t.length);for(let n=0;n<t.length;++n)r[n]=e(t[n],s);return r}}function hv(e,t,n){return({inputs:s,attrs:r,backend:a})=>{const{x:i}=s;if(Wk(i,e),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const o=a,l=o.data.get(i.dataId).values,u=h(i.shape),c=n||i.dtype,p=k(c,u);for(let e=0;e<u;++e)p[e]=t(l[e],r);return o.makeTensorInfo(i.shape,c,p)}}function pv(e,t,n){return({inputs:s,attrs:r,backend:a})=>{const{x:i}=s;if(Wk(i,e),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const o=a,l=o.data.get(i.dataId).values,u=n||i.dtype,c=t(l,u,r);return o.makeTensorInfo(i.shape,u,c)}}const dv=cv(e=>Math.ceil(e)),fv={kernelName:"Ceil",backendName:"cpu",kernelFunc:pv("Ceil",dv)};function mv(e,t,n,s){const r=k(n,h(t));if(s&&"string"!==n){let t=0;e.forEach(e=>{const n=h(e.shape);r.set(e.vals,t),t+=n})}else{let s=0;e.forEach(e=>{const a="string"===n?ip(e.vals):e.vals;let i=0;for(let n=0;n<e.shape[0];++n){const o=n*t[1]+s;for(let t=0;t<e.shape[1];++t)r[o+t]=a[i++]}s+=e.shape[1]})}return r}const gv=cv(e=>Math.exp(e)),yv=pv(qe,gv),bv={kernelName:qe,backendName:"cpu",kernelFunc:yv},xv=cv(e=>Math.expm1(e)),wv={kernelName:"Expm1",backendName:"cpu",kernelFunc:pv("Expm1",xv)},kv=cv(e=>Math.floor(e)),vv={kernelName:"Floor",backendName:"cpu",kernelFunc:pv("Floor",kv)};function Nv(e,t,n){const s=Lr(n,e.dtype);for(let n=0;n<s.size;++n){const r=s.indexToLoc(n).slice(),a=r[0],i=r[2],o=t.locToIndex([a,i]);r[2]=t.values[o];const l=e.locToIndex(r);s.values[n]=e.values[l]}return s}const Iv=jk((e,t)=>e>t?1:0),Cv={kernelName:"Greater",backendName:"cpu",kernelFunc:nv("Greater",Iv,null,"bool")},Sv=jk((e,t)=>e<t?1:0),Tv={kernelName:"Less",backendName:"cpu",kernelFunc:nv("Less",Sv,null,"bool")};function Ev(e,t,n){const s=(t-e)/(n-1),r=L(n,"float32");r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+s;return r}const $v=cv(e=>Math.log(e)),Av=pv(gt,$v),Rv={kernelName:gt,backendName:"cpu",kernelFunc:Av};function Fv(e,t,n,s){const r=w(s,h(n));for(let n=0;n<r.length;++n){const s=n*t;let a=e[s];for(let n=0;n<t;++n){const t=e[s+n];t>a&&(a=t)}r[n]=a}return r}const Dv=jk((e,t)=>Math.max(e,t)),_v={kernelName:"Maximum",backendName:"cpu",kernelFunc:nv("Maximum",Dv)},Ov=jk((e,t)=>Math.min(e,t)),Mv={kernelName:"Minimum",backendName:"cpu",kernelFunc:nv("Minimum",Ov)},Lv=jk((e,t)=>e*t),zv=sv((e,t,n,s)=>({real:e*n-t*s,imag:e*s+t*n})),Bv=nv("Multiply",Lv,zv),Pv={kernelName:"Multiply",backendName:"cpu",kernelFunc:Bv};function Wv(e,t,n){const s=ns(-1,n);return Lv([],t,s,e,n)}const Vv={kernelName:"Neg",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;Wk(s,"neg");const r=n.data.get(s.dataId).values,[a,i]=Wv(r,s.shape,s.dtype);return n.makeTensorInfo(i,s.dtype,a)}},Uv=jk((e,t)=>e!==t?1:0),Gv={kernelName:"NotEqual",backendName:"cpu",kernelFunc:nv("NotEqual",Uv,null,"bool")};function Hv(e,t,n,s,r){const a=t.length,i=h(t),o=_(t),l=_(r),u=w(n,h(r));for(let t=0;t<i;++t){const n=W(t,a,o),r=new Array(n.length);for(let e=0;e<r.length;e++)r[e]=n[s[e]];u[P(r,a,l)]=e[t]}return u}function jv(e){const{inputs:t,attrs:n,backend:s}=e,{x:r}=t,{perm:a}=n;Wk(r,"transpose");const i=r.shape.length,o=new Array(i);for(let e=0;e<o.length;e++)o[e]=r.shape[a[e]];const l=Hv(s.data.get(r.dataId).values,r.shape,r.dtype,a,o);return{dataId:s.write(l,o,r.dtype),shape:o,dtype:r.dtype}}const qv={kernelName:"Transpose",backendName:"cpu",kernelFunc:jv};function Kv(e,t,n,s){const[r,a]=yl(e,s),i=$s(t,"int32"),o=L(h(r),i),l=h(a);for(let e=0;e<o.length;++e){const t=e*l;let s=1;for(let e=0;e<l;++e)s*=n[t+e];o[e]=s}return{outVals:o,outShape:r,outDtype:i}}const Xv={kernelName:"Prod",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;Wk(r,"prod");const o=r.shape.length,l=b(a,r.shape),u=wl(l,o);let c=l,h=r;const p=[];null!=u&&(h=jv({inputs:{x:r},backend:n,attrs:{perm:u}}),p.push(h),c=vl(c.length,o));const d=n.data.get(h.dataId).values,{outVals:f,outShape:m,outDtype:g}=Kv(h.shape,h.dtype,d,c);let y=m;return i&&(y=bl(m,l)),p.forEach(e=>n.disposeIntermediateTensorInfo(e)),n.makeTensorInfo(y,g,f)}};function Yv(e,t,n,s){if(e===t||e<t&&n<0||t<e&&n>1)return L(0,s);const r=L(Math.abs(Math.ceil((t-e)/n)),s);t<e&&1===n&&(n=-1),r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+n;return r}const Jv=cv(e=>1/Math.sqrt(e)),Zv={kernelName:"Rsqrt",backendName:"cpu",kernelFunc:pv("Rsqrt",Jv)};function Qv(e,t,n,s,r){const a=$a(s,t,n),i=h(n),o=_(s);if(a){const n=Aa(t,o);return"string"===r?e.slice(n,n+i):e.subarray(n,n+i)}const l=Lr(s,r,"string"===r?ip(e):e),u=Lr(n,r);for(let e=0;e<u.size;++e){const n=u.indexToLoc(e),s=n.map((e,n)=>e+t[n]);u.set(l.get(...s),...n)}return"string"===r?op(u.values):u.values}function eN(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,size:i}=s;Wk(r,"slice");const[o,l]=Ra(r,a,i);ya(r,o,l);const u=Qv(n.data.get(r.dataId).values,o,l,r.shape,r.dtype);return n.makeTensorInfo(l,r.dtype,u)}const tN={kernelName:"Slice",backendName:"cpu",kernelFunc:eN},nN=jk((e,t)=>{const n=e-t;return n*n}),sN={kernelName:"SquaredDifference",backendName:"cpu",kernelFunc:nv("SquaredDifference",nN)};function rN(e,t,n,s){const r=Lr(e,t.dtype);for(let e=0;e<r.size;e++){const a=r.indexToLoc(e),i=new Array(a.length);for(let e=0;e<i.length;e++)i[e]=a[e]*n[e]+s[e];r.set(t.get(...i),...a)}return r}const aN=jk((e,t)=>e-t),iN=sv((e,t,n,s)=>({real:e-n,imag:t-s})),oN=nv(Tn,aN,iN),lN={kernelName:Tn,backendName:"cpu",kernelFunc:oN};function uN(e,t){const n=new Array(e.rank);for(let s=0;s<n.length;s++)n[s]=e.shape[s]*t[s];const s=Lr(n,e.dtype);for(let t=0;t<s.values.length;++t){const n=s.indexToLoc(t),r=new Array(e.rank);for(let t=0;t<r.length;t++)r[t]=n[t]%e.shape[t];const a=e.locToIndex(r);s.values[t]=e.values[a]}return s}function cN(e,t,n,s,r){const a=t[t.length-1],[i,o]=[e.length/a,a],l=w(n,i*s),u=w("int32",i*s);for(let t=0;t<i;t++){const n=t*o,r=e.subarray(n,n+o),a=[];for(let e=0;e<r.length;e++)a.push({value:r[e],index:e});a.sort((e,t)=>t.value-e.value);const i=t*s,c=l.subarray(i,i+s),h=u.subarray(i,i+s);for(let e=0;e<s;e++)c[e]=a[e].value,h[e]=a[e].index}const c=t.slice();return c[c.length-1]=s,[Lr(c,n,l),Lr(c,"int32",u)]}function hN(e,t,n,s){const r=b(t,n)[0],a=[1,n[0],1];for(let e=0;e<r;e++)a[0]*=n[e];a[1]=n[r];for(let e=r+1;e<n.length;e++)a[2]*=n[e];const i={},o=new Int32Array(n[r]),l=new gs(a,s,e),u=[],c=1===a[0]&&1===a[2];for(let t=0;t<n[r];t++){let n;if(c)n=e[t].toString();else{const e=[];for(let n=0;n<a[0];n++)for(let s=0;s<a[2];s++)e.push(l.get(n,t,s));n=e.join(",")}if(void 0!==i[n])o[t]=i[n];else{const e=Object.keys(i).length;i[n]=e,o[t]=e,u.push(t)}}const h=a.slice();h[1]=Object.keys(i).length;const p=new gs(h,s);u.forEach((e,t)=>{for(let n=0;n<a[0];n++)for(let s=0;s<a[2];s++)p.set(l.get(n,e,s),n,t,s)});const d=n.slice();return d[r]=h[1],{outputValues:p.values,outputShape:d,indices:o}}var pN=Object.freeze({__proto__:null,simpleAbsImpl:Gk,addImpl:rv,bincountImpl:lv,bincountReduceImpl:uv,ceilImpl:dv,concatImpl:mv,expImpl:gv,expm1Impl:xv,floorImpl:kv,gatherV2Impl:Nv,greaterImpl:Iv,lessImpl:Sv,linSpaceImpl:Ev,logImpl:$v,maxImpl:Fv,maximumImpl:Dv,minimumImpl:Ov,multiplyImpl:Lv,negImpl:Wv,notEqualImpl:Uv,prodImpl:Kv,rangeImpl:Yv,rsqrtImpl:Jv,sliceImpl:Qv,squaredDifferenceImpl:nN,stridedSliceImpl:rN,subImpl:aN,tileImpl:uN,topKImpl:cN,transposeImpl:Hv,uniqueImpl:hN});li("cpu",()=>new Uk,1);const dN=hv(Ue,e=>e>=0?e:Math.exp(e)-1),fN={kernelName:Ue,backendName:"cpu",kernelFunc:dN};function mN(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{alpha:a}=s;Wk([r],"leakyRelu");const i=h(r.shape),o=n.data.get(r.dataId).values,l=w("float32",i);for(let e=0;e<o.length;e++)l[e]=o[e]<0?a*o[e]:o[e];return n.makeTensorInfo(r.shape,"float32",l)}const gN={kernelName:"LeakyRelu",backendName:"cpu",kernelFunc:mN},yN=jk((e,t)=>e<0?t*e:e);function bN(e){const{inputs:t,backend:n}=e,{x:s,alpha:r}=t;Wk([s,r],"prelu");const a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,[o,l]=yN(s.shape,r.shape,a,i,s.dtype);return n.makeTensorInfo(l,s.dtype,o)}const xN={kernelName:"Prelu",backendName:"cpu",kernelFunc:bN},wN=hv("Relu",e=>Math.max(0,e)),kN={kernelName:"Relu",backendName:"cpu",kernelFunc:wN},vN=hv("Relu6",e=>Math.min(Math.max(0,e),6)),NN={kernelName:"Relu6",backendName:"cpu",kernelFunc:vN};function IN(e,t,n,s,r){if("linear"===n)return Yk({inputs:{x:t},backend:e});if("relu"===n)return wN({inputs:{x:t},backend:e});if("elu"===n)return dN({inputs:{x:t},backend:e});if("relu6"===n)return vN({inputs:{x:t},backend:e});if("prelu"===n)return bN({inputs:{x:t,alpha:s},backend:e});if("leakyrelu"===n)return mN({inputs:{x:t},backend:e,attrs:{alpha:r}});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function CN(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{shape:a}=s,i=h(r.shape),l=y(a,i),u=h(l);o(i===u,()=>`The new shape (${l}) has ${u} elements and the old shape (${r.shape}) has ${i} elements. The new shape and old shape must have the same number of elements.`),n.incRef(r.dataId);const c=n.data.get(r.dataId);if(null!=c.complexTensorInfos){const e=c.complexTensorInfos.real,t=c.complexTensorInfos.imag;e.shape=l,t.shape=l}return{dataId:r.dataId,shape:l,dtype:r.dtype}}const SN={kernelName:"Reshape",backendName:"cpu",kernelFunc:CN};function TN(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a}=t,{transposeA:i,transposeB:l}=s;Wk([r,a],"matMul");const u=r.shape.length,c=a.shape.length,p=i?r.shape[u-2]:r.shape[u-1],d=l?a.shape[c-1]:a.shape[c-2],f=i?r.shape[u-1]:r.shape[u-2],m=l?a.shape[c-2]:a.shape[c-1],g=r.shape.slice(0,-2),y=a.shape.slice(0,-2),b=h(g),x=h(y);o(u>=2&&c>=2&&(b===x||1===b||1===x),()=>`Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of (${g}) and (${y}).`);const w=(b>x?r.shape.slice(0,-2):a.shape.slice(0,-2)).concat([f,m]);o(p===d,()=>`Error in matMul: inner shapes (${p}) and (${d}) of Tensors with shapes ${r.shape} and ${a.shape} and transposeA=${i} and transposeB=${l} must match.`);const k=l?[x,m,d]:[x,d,m],v=CN({inputs:{x:r},backend:n,attrs:{shape:i?[b,p,f]:[b,f,p]}}),N=CN({inputs:{x:a},backend:n,attrs:{shape:k}}),I=i?v.shape[1]:v.shape[2],C=i?v.shape[2]:v.shape[1],S=l?N.shape[1]:N.shape[2],T=Math.max(b,x),E=n.data.get(v.dataId).values,$=n.data.get(N.dataId).values,A=_(v.shape),R=_(N.shape),[F,D,O]=i?[A[0],1,A[1]]:[A[0],A[1],1],[M,L,z]=l?[1,R[1],R[0]]:[R[1],1,R[0]],B=C*S,P=Lr([T,C,S],v.dtype),W=P.values,V=n.blockSize;for(let e=0;e<T;e++)for(let t=0;t<C;t+=V)for(let n=0;n<S;n+=V)for(let s=0;s<I;s+=V){const r=Math.min(t+V,C),a=Math.min(n+V,S),i=Math.min(s+V,I);for(let o=t;o<r;o++)for(let t=n;t<a;t++){let n=0;for(let r=s;r<i;r++){const s=Math.min(e,b-1)*F,a=Math.min(e,x-1)*z;n+=E[s+o*D+r*O]*$[r*M+t*L+a]}W[e*B+(o*S+t)]+=n}}return n.disposeIntermediateTensorInfo(v),n.disposeIntermediateTensorInfo(N),n.makeTensorInfo(w,P.dtype,P.values)}const EN={kernelName:"BatchMatMul",backendName:"cpu",kernelFunc:TN};const $N={kernelName:"_FusedMatMul",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a,bias:i,preluActivationWeights:o}=t,{transposeA:l,transposeB:u,activation:c,leakyreluAlpha:h}=s;let p,d,f;const m=[];p=TN({inputs:{a:r,b:a},attrs:{transposeA:l,transposeB:u},backend:n}),i&&(d=iv({inputs:{a:p,b:i},backend:n}),m.push(p),p=d),c&&(f=IN(n,p,c,o,h),m.push(p),p=f);for(const e of m)n.disposeIntermediateTensorInfo(e);return p}},AN={kernelName:"Acos",backendName:"cpu",kernelFunc:hv("Acos",e=>Math.acos(e))},RN={kernelName:"Acosh",backendName:"cpu",kernelFunc:hv("Acosh",e=>Math.acosh(e))};const FN={kernelName:"AddN",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,s=t;Wk(t,"addN");const r=s.map(e=>n.data.get(e.dataId).values),a=Lr(s[0].shape,s[0].dtype),i=a.values;for(let e=0;e<s.length;e++){const t=r[e];for(let e=0;e<i.length;e++)i[e]+=t[e]}return n.makeTensorInfo(a.shape,a.dtype,a.values)}};const DN={kernelName:"All",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;Wk(r,"all");const o=b(a,r.shape);let l=o;const u=wl(l,r.shape.length);let c=r;null!=u&&(c=jv({inputs:{x:r},backend:n,attrs:{perm:u}}),l=vl(l.length,r.shape.length)),xl("all",l,c.shape.length);const[p,d]=yl(c.shape,l),f=h(d),m=L(h(p),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];n=n&&s}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(p,c.dtype,m);if(i){const e=CN({inputs:{x:y},backend:n,attrs:{shape:bl(p,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const _N={kernelName:"Any",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;Wk(r,"any");const o=b(a,r.shape);let l=o;const u=wl(l,r.shape.length);let c=r;null!=u&&(c=jv({inputs:{x:r},backend:n,attrs:{perm:u}}),l=vl(l.length,r.shape.length)),xl("any",l,c.shape.length);const[p,d]=yl(c.shape,l),f=h(d),m=L(h(p),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];n=n||s}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(p,c.dtype,m);if(i){const e=CN({inputs:{x:y},backend:n,attrs:{shape:bl(p,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const ON={kernelName:"ArgMax",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;Wk(r,"argMax");let i=b(a,r.shape);const o=wl(i,r.shape.length);let l=r;const u=[];null!=o&&(l=jv({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=vl(i.length,l.shape.length)),i=[i[0]],xl("argMax",i,l.shape.length);const[c,p]=yl(l.shape,i),d=L(h(c),"int32"),f=h(p),m=n.data.get(l.dataId).values;for(let e=0;e<d.length;++e){const t=e*f;let n=m[t],s=0;for(let e=0;e<f;++e){const r=m[t+e];r>n&&(n=r,s=e)}d[e]=s}return u.forEach(e=>n.disposeIntermediateTensorInfo(e)),n.makeTensorInfo(c,"int32",d)}};const MN={kernelName:"ArgMin",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;Wk(r,"argMin");let i=b(a,r.shape);const o=wl(i,r.shape.length);let l=r;const u=[];null!=o&&(l=jv({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=vl(i.length,l.shape.length)),i=[i[0]],xl("argMin",i,l.shape.length);const[c,p]=yl(l.shape,i),d=L(h(c),"int32"),f=h(p),m=n.data.get(l.dataId).values;for(let e=0;e<d.length;++e){const t=e*f;let n=m[t],s=0;for(let e=0;e<f;++e){const r=m[t+e];r<n&&(n=r,s=e)}d[e]=s}return u.forEach(e=>n.disposeIntermediateTensorInfo(e)),n.makeTensorInfo(c,"int32",d)}},LN={kernelName:"Asin",backendName:"cpu",kernelFunc:hv("Asin",e=>Math.asin(e))},zN={kernelName:"Asinh",backendName:"cpu",kernelFunc:hv("Asinh",e=>Math.asinh(e))},BN={kernelName:"Atan",backendName:"cpu",kernelFunc:hv("Atan",e=>Math.atan(e))},PN={kernelName:"Atan2",backendName:"cpu",kernelFunc:nv("Atan2",jk((e,t)=>Math.atan2(e,t)))},WN={kernelName:"Atanh",backendName:"cpu",kernelFunc:hv("Atanh",e=>Math.atanh(e))};function VN(e,t,n,s,r,a){const i=r.strideHeight,o=r.strideWidth,l=r.dilationHeight,u=r.dilationWidth,c=r.effectiveFilterHeight,h=r.effectiveFilterWidth,p=r.padInfo.top,d=r.padInfo.left,f="max"===a?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,m=Lr(r.outShape,n),g=m.values,y=r.outShape[1]*r.outShape[2]*r.outShape[3],b=r.outShape[2]*r.outShape[3],x=r.outShape[3];for(let t=0;t<r.batchSize;++t){const n=t*y,m=t*s[0];for(let t=0;t<r.inChannels;++t)for(let y=0;y<r.outHeight;++y){const w=y*i-p,k=Math.max(0,w),v=Math.min(r.inHeight,c+w),N=n+y*b;for(let n=0;n<r.outWidth;++n){const i=n*o-d,c=Math.max(0,i),p=Math.min(r.inWidth,h+i);let y=f,b=0,w=0;for(let n=k;n<v;n+=l){const r=m+n*s[1];for(let n=c;n<p;n+=u){const i=e[r+n*s[2]+t];"max"===a&&i>y?y=i:"avg"===a&&(b+=i,w++)}if(isNaN(y))break}g[N+n*x+t]="avg"===a?b/w:y}}}return m}function UN(e,t,n,s,r=!1,a=!1){const i=Lr(s.outShape,"int32"),o=s.strideHeight,l=s.strideWidth,u=s.dilationHeight,c=s.dilationWidth,h=s.effectiveFilterHeight,p=s.effectiveFilterWidth,d=s.padInfo.top,f=s.padInfo.left,m=Lr(t,n,e);for(let e=0;e<s.batchSize;++e)for(let t=0;t<s.inChannels;++t)for(let n=0;n<s.outHeight;++n){const g=n*o-d;let y=g;for(;y<0;)y+=u;const b=Math.min(s.inHeight,h+g);for(let o=0;o<s.outWidth;++o){const h=o*l-f;let d=h;for(;d<0;)d+=c;const x=Math.min(s.inWidth,p+h);let w=Number.NEGATIVE_INFINITY,k=-1;for(let n=y;n<b;n+=u){const i=n-g;for(let o=d;o<x;o+=c){const l=o-h,u=m.get(e,n,o,t);u>w&&(w=u,k=r?a?((e*s.inHeight+n)*s.inWidth+o)*s.inChannels+t:(n*s.inWidth+o)*s.inChannels+t:i*p+l)}}i.set(k,e,n,o,t)}}return i}function GN(e,t,n,s,r,a){const i=r.strideDepth,o=r.strideHeight,l=r.strideWidth,u=r.dilationDepth,c=r.dilationHeight,h=r.dilationWidth,p=r.effectiveFilterDepth,d=r.effectiveFilterHeight,f=r.effectiveFilterWidth,m=r.padInfo.front,g=r.padInfo.top,y=r.padInfo.left,b="max"===a?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,x=Lr(r.outShape,n),w=x.values,k=r.outShape[1]*r.outShape[2]*r.outShape[3]*r.outShape[4],v=r.outShape[2]*r.outShape[3]*r.outShape[4],N=r.outShape[3]*r.outShape[4],I=r.outShape[4];for(let t=0;t<r.batchSize;++t){const n=t*k,x=t*s[0];for(let t=0;t<r.inChannels;++t)for(let k=0;k<r.outDepth;++k){const C=k*i-m;let S=C;for(;S<0;)S+=u;const T=Math.min(r.inDepth,p+C),E=n+k*v;for(let n=0;n<r.outHeight;++n){const i=n*o-g;let p=i;for(;p<0;)p+=c;const m=Math.min(r.inHeight,d+i),k=E+n*N;for(let n=0;n<r.outWidth;++n){const i=n*l-y;let o=i;for(;o<0;)o+=h;const d=Math.min(r.inWidth,f+i),g=k+n*I;let v=b,N=0,C=0;for(let n=S;n<T;n+=u){const r=x+n*s[1];for(let n=p;n<m;n+=c){const i=r+n*s[2];for(let n=o;n<d;n+=h){const r=e[i+n*s[3]+t];if("max"===a&&r>v?v=r:"avg"===a&&(N+=r,C++),isNaN(v))break}if(isNaN(v))break}if(isNaN(v))break}w[g+t]="avg"===a?N/C:v}}}}return x}const HN={kernelName:"AvgPool",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;Wk(r,"avgPool");const{filterSize:a,strides:i,pad:l,dimRoundingMode:u}=s;o(Bi(i,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`);const c=$i(r.shape,a,i,1,l,u);let h;if(1===c.filterWidth&&1===c.filterHeight&&p(c.inShape,c.outShape))h=Yk({inputs:{x:r},backend:n});else{const e=n.data.get(r.dataId).values,t=_(r.shape),s=VN(e,r.shape,r.dtype,t,c,"avg");h=n.makeTensorInfo(c.outShape,r.dtype,s.values)}return h}};const jN={kernelName:"AvgPool3D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s;Wk(r,"avgPool3d");const c=Ai(r.shape,a,i,1,o,l,u),h=GN(n.data.get(r.dataId).values,r.shape,r.dtype,_(r.shape),c,"avg");return n.makeTensorInfo(h.shape,"float32",h.values)}};const qN={kernelName:"AvgPool3DGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,{filterSize:i,strides:o,pad:l,dimRoundingMode:u}=s;Wk([r,a],"avgPool3DGrad");const c=Ai(a.shape,i,o,1,l,u),h=c.strideDepth,p=c.strideHeight,d=c.strideWidth,f=c.filterDepth,m=c.filterHeight,g=c.filterWidth,y=c.dilationDepth,b=c.dilationHeight,x=c.dilationWidth,w=c.effectiveFilterDepth,k=c.effectiveFilterHeight,v=c.effectiveFilterWidth,N=w-1-c.padInfo.front,I=v-1-c.padInfo.left,C=k-1-c.padInfo.top,S=Lr(a.shape,"float32"),T=1/(f*m*g),E=n.bufferSync(r);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inDepth;++n)for(let s=0;s<c.inHeight;++s)for(let r=0;r<c.inWidth;++r){const a=n-N,i=s-C,o=r-I;let l=0;for(let n=0;n<w;n+=y){const s=(a+n)/h;if(!(s<0||s>=c.outDepth||Math.floor(s)!==s))for(let n=0;n<k;n+=b){const r=(i+n)/p;if(!(r<0||r>=c.outHeight||Math.floor(r)!==r))for(let n=0;n<v;n+=x){const a=(o+n)/d;a<0||a>=c.outWidth||Math.floor(a)!==a||(l+=E.get(e,s,r,a,t))}}}S.set(l*T,e,n,s,r,t)}return n.makeTensorInfo(S.shape,S.dtype,S.values)}};const KN={kernelName:"AvgPoolGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a;Wk([r,a],"avgPoolGrad");const{filterSize:o,strides:l,pad:u}=s,c=$i(i.shape,o,l,1,u),h=c.strideHeight,p=c.strideWidth,d=c.filterHeight,f=c.filterWidth,m=c.dilationHeight,g=c.dilationWidth,y=c.effectiveFilterHeight,b=c.effectiveFilterWidth,x=b-1-c.padInfo.left,w=y-1-c.padInfo.top,k=Lr(i.shape,"float32"),v=1/(d*f),N=n.data.get(r.dataId).values,I=Lr(r.shape,"float32",N);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inHeight;++n)for(let s=0;s<c.inWidth;++s){const r=n-w,a=s-x;let i=0;for(let n=0;n<y;n+=m){const s=(r+n)/h;if(!(s<0||s>=c.outHeight||Math.floor(s)!==s))for(let n=0;n<b;n+=g){const r=(a+n)/p;r<0||r>=c.outWidth||Math.floor(r)!==r||(i+=I.get(e,s,r,t))}}k.set(i*v,e,n,s,t)}return n.makeTensorInfo(k.shape,k.dtype,k.values)}};const XN={kernelName:"FusedBatchNorm",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,scale:a,offset:i,mean:l,variance:u}=t;o(l.shape.length===u.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),o(null==i||l.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),o(null==a||l.shape.length===a.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks."),Wk([r,l,u,a,i],"batchNorm");let{varianceEpsilon:c}=s;null==c&&(c=.001);const h=n.data.get(r.dataId).values,p=n.data.get(l.dataId).values,d=n.data.get(u.dataId).values,f=a?n.data.get(a.dataId).values:new Float32Array([1]),m=i?n.data.get(i.dataId).values:new Float32Array([0]),g=new Float32Array(h.length),y=m.length,b=f.length,x=d.length,w=p.length;let k=0,v=0,N=0,I=0;for(let e=0;e<h.length;++e)g[e]=m[k++]+(h[e]-p[v++])*f[N++]/Math.sqrt(d[I++]+c),k>=y&&(k=0),v>=w&&(v=0),N>=b&&(N=0),I>=x&&(I=0);return n.makeTensorInfo(r.shape,r.dtype,g)}};const YN={kernelName:"BatchToSpaceND",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,crops:i}=s;Wk([r],"batchToSpaceND");const o=a.reduce((e,t)=>e*t),l=Ph(r.shape,a,o),u=Wh(l.length,a.length),c=Vh(r.shape,a,o),h=Uh(i,a.length),p=Gh(c,i,a.length),d=CN({inputs:{x:r},backend:n,attrs:{shape:l}}),f=jv({inputs:{x:d},backend:n,attrs:{perm:u}}),m=CN({inputs:{x:f},backend:n,attrs:{shape:c}}),g=eN({inputs:{x:m},backend:n,attrs:{begin:h,size:p}});return n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}};const JN={kernelName:"Bincount",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i}=s,o=lv(n.data.get(r.dataId).values,n.data.get(a.dataId).values,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,o)}},ZN={kernelName:"ClipByValue",backendName:"cpu",kernelFunc:hv("ClipByValue",(e,t)=>{const n=t;return e>n.clipValueMax?n.clipValueMax:e<n.clipValueMin?n.clipValueMin:e})},QN={kernelName:"ComplexAbs",backendName:"cpu",kernelFunc:e=>{const{x:t}=e.inputs,n=e.backend,s=new Float32Array(h(t.shape)),r=n.data.get(t.dataId),a=r.complexTensorInfos.real,i=r.complexTensorInfos.imag,o=n.data.get(a.dataId).values,l=n.data.get(i.dataId).values;for(let e=0;e<o.length;e++){const t=o[e],n=l[e];s[e]=Math.hypot(t,n)}return n.makeOutput(s,t.shape,"float32")}};function eI(e){const{inputs:t,backend:n}=e,{input:s}=t,r=n.data.get(s.dataId).complexTensorInfos.imag,a=n.data.get(r.dataId).values;return n.makeTensorInfo(r.shape,r.dtype,a)}const tI={kernelName:"Imag",backendName:"cpu",kernelFunc:eI};function nI(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s,a=b(r,t[0].shape)[0];let i=Lh(t.map(e=>e.shape),a);if(0===h(i))return n.makeTensorInfo(i,t[0].dtype,[]);const o=t.filter(e=>h(e.shape)>0);if(1===o.length)return Yk({inputs:{x:o[0]},backend:n});if(Mh(o.map(e=>e.shape),a),"complex64"===o[0].dtype){const e=o.map(e=>Zk({inputs:{input:e},backend:n})),t=o.map(e=>eI({inputs:{input:e},backend:n})),s=nI({inputs:e,backend:n,attrs:{axis:a}}),r=nI({inputs:t,backend:n,attrs:{axis:a}}),i=qk({inputs:{real:s,imag:r},backend:n});return e.forEach(e=>n.disposeIntermediateTensorInfo(e)),t.forEach(e=>n.disposeIntermediateTensorInfo(e)),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),i}const l=o.map(e=>{const t=h(e.shape.slice(a));return CN({inputs:{x:e},backend:n,attrs:{shape:[-1,t]}})}),u=l.map(e=>({vals:n.data.get(e.dataId).values,shape:e.shape}));i=Lh(l.map(e=>e.shape),1);const c=1===l[0].shape[0],p=mv(u,i,t[0].dtype,c),d=Lh(o.map(e=>e.shape),a),f=n.makeTensorInfo(d,t[0].dtype,p);return l.forEach(e=>n.disposeIntermediateTensorInfo(e)),f}const sI={kernelName:"Concat",backendName:"cpu",kernelFunc:nI};function rI(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dataFormat:l,dilations:u,dimRoundingMode:c}=s;Wk([r,a],"conv2d");const h=Pi(l),p=Ri(r.shape,a.shape,i,u,o,c,!1,h),d=p.filterHeight,f=p.filterWidth,m=p.dilationHeight,g=p.dilationWidth,y=p.padInfo.left,b=p.padInfo.top,x="channelsLast"===p.dataFormat,w=new gs(p.outShape,r.dtype),k=_(r.shape),v=_(a.shape),N=k[0],I=x?k[1]:k[2],C=x?k[2]:1,S=x?1:k[1],T=w.strides[0],E=x?w.strides[1]:w.strides[2],$=x?w.strides[2]:1,A=x?1:w.strides[1],R=n.data.get(r.dataId).values,F=n.data.get(a.dataId).values,D=w.values;for(let e=0;e<p.batchSize;++e){const t=e*N,n=e*T;for(let e=0;e<p.outHeight;++e){const s=n+e*E,r=e*p.strideHeight-b;for(let e=0;e<d;++e){const n=r+e*m;if(n<0||n>=p.inHeight)continue;const a=e*v[0],i=t+n*I;for(let e=0;e<p.outWidth;++e){const t=s+e*$,n=e*p.strideWidth-y;for(let e=0;e<f;++e){const s=n+e*g;if(s<0||s>=p.inWidth)continue;const r=i+s*C;let o=a+e*v[1];for(let e=0;e<p.inChannels;++e){const n=R[r+e*S];for(let e=0;e<p.outChannels;++e)D[t+e*A]+=n*F[o+e];o+=p.outChannels}}}}}}return n.makeTensorInfo(w.shape,w.dtype,D)}const aI={kernelName:"Conv2D",backendName:"cpu",kernelFunc:rI};const iI={kernelName:"Conv2DBackpropFilter",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,dataFormat:l,dimRoundingMode:u,filterShape:c}=s;Wk([r,a],"conv2dBackpropFilter");const h=Pi(l),p=Ri(r.shape,c,i,1,o,u,!1,h),{strideHeight:d,strideWidth:f,filterHeight:m,filterWidth:g}=p,y="channelsLast"===p.dataFormat,b=new gs(p.filterShape,"float32"),x=p.padInfo.left,w=p.padInfo.top,k=n.data.get(r.dataId).values,v=n.data.get(a.dataId).values,N=new gs(r.shape,r.dtype,k),I=new gs(a.shape,a.dtype,v);for(let e=0;e<m;++e){const t=Math.max(0,Math.ceil((w-e)/d)),n=Math.min(p.outHeight,(p.inHeight+w-e)/d);for(let s=0;s<g;++s){const r=Math.max(0,Math.ceil((x-s)/f)),a=Math.min(p.outWidth,(p.inWidth+x-s)/f);for(let i=0;i<p.inChannels;++i)for(let o=0;o<p.outChannels;++o){let l=0;for(let u=0;u<p.batchSize;++u)for(let c=t;c<n;++c){const t=e+c*d-w;for(let e=r;e<a;++e){const n=s+e*f-x;l+=y?N.get(u,t,n,i)*I.get(u,c,e,o):N.get(u,i,t,n)*I.get(u,o,c,e)}}b.set(l,e,s,i,o)}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const oI={kernelName:"Conv2DBackpropInput",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{inputShape:i,strides:o,pad:l,dataFormat:u,dimRoundingMode:c}=s;Wk([r,a],"conv2dBackpropInput");const h=_(a.shape),p=_(r.shape);let d=Pi(u);const f=Ri(i,a.shape,o,1,l,c,!1,d),m=new gs(f.inShape,"float32"),g=m.values,y=n.data.get(r.dataId).values,b=n.data.get(a.dataId).values,[x,w,k]=h,{batchSize:v,filterHeight:N,filterWidth:I,inChannels:C,inHeight:S,inWidth:T,outChannels:E,outHeight:$,outWidth:A,strideHeight:R,strideWidth:F}=f;d=f.dataFormat;const D=N-1-f.padInfo.top,O=I-1-f.padInfo.left,M="channelsLast"===d,L=m.strides[0],z=M?m.strides[1]:m.strides[2],B=M?m.strides[2]:1,P=M?1:m.strides[1],W=p[0],V=M?p[1]:p[2],U=M?p[2]:1,G=M?1:p[1];for(let e=0;e<v;++e)for(let t=0;t<C;++t)for(let n=0;n<S;++n){const s=n-D,r=Math.max(0,Math.ceil(s/R)),a=Math.min($,(N+s)/R);for(let i=0;i<T;++i){const o=i-O,l=Math.max(0,Math.ceil(o/F)),u=Math.min(A,(I+o)/F);let c=0;for(let n=r;n<a;++n){const r=n*R-s;for(let s=l;s<u;++s){const a=W*e+V*n+U*s,i=x*(N-1-r)+w*(I-1-(s*F-o))+k*t;for(let e=0;e<E;++e){c+=y[a+G*e]*b[i+e]}}}g[L*e+z*n+B*i+P*t]=c}}return n.makeTensorInfo(m.shape,m.dtype,m.values)}};const lI={kernelName:"Conv3D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s;Wk([r,a],"conv3d");const u=Fi(r.shape,a.shape,i,l,o),{filterDepth:c,filterHeight:h,filterWidth:p,dilationDepth:d,dilationHeight:f,dilationWidth:m,padInfo:g}=u,y=g.front,b=g.left,x=g.top,w=new gs(u.outShape,r.dtype),k=n.data.get(r.dataId).values,v=n.data.get(a.dataId).values,N=w.values,I=_(r.shape),C=_(a.shape);for(let e=0;e<u.batchSize;++e){const t=e*I[0],n=e*w.strides[0];for(let e=0;e<u.outDepth;++e){const s=n+e*w.strides[1],r=e*u.strideDepth-y;for(let e=0;e<c;++e){const n=r+e*d;if(n<0||n>=u.inDepth)continue;const a=e*C[0],i=t+n*I[1];for(let e=0;e<u.outHeight;++e){const t=s+e*w.strides[2],n=e*u.strideHeight-x;for(let e=0;e<h;++e){const s=n+e*f;if(s<0||s>=u.inHeight)continue;const r=a+e*C[1],o=i+s*I[2];for(let e=0;e<u.outWidth;++e){const n=t+e*u.outChannels,s=e*u.strideWidth-b;for(let e=0;e<p;++e){const t=s+e*m;if(t<0||t>=u.inWidth)continue;const a=r+e*C[2],i=o+t*u.inChannels;let l=a;for(let e=0;e<u.inChannels;++e){const t=k[i+e];for(let e=0;e<u.outChannels;++e)N[n+e]+=t*v[l+e];l+=u.outChannels}}}}}}}}return n.makeTensorInfo(w.shape,w.dtype,w.values)}};const uI={kernelName:"Conv3DBackpropFilterV2",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,filterShape:l}=s;Wk([r,a],"conv3dBackpropFilterV2");const u=_(r.shape),c=_(a.shape),h=Fi(r.shape,l,i,1,o),p=h.strideDepth,d=h.strideHeight,f=h.strideWidth,m=h.filterDepth,g=h.filterHeight,y=h.filterWidth,b=new gs(h.filterShape,"float32"),x=b.values,[w,k,v,N]=b.strides,I=n.data.get(a.dataId).values,[C,S,T,E]=c,$=n.data.get(r.dataId).values,[A,R,F,D]=u,O=h.padInfo.front,M=h.padInfo.left,L=h.padInfo.top;for(let e=0;e<m;++e){const t=Math.max(0,Math.ceil((O-e)/p)),n=Math.min(h.outDepth,(h.inDepth+O-e)/p),s=e*w;for(let r=0;r<g;++r){const a=Math.max(0,Math.ceil((L-r)/d)),i=Math.min(h.outHeight,(h.inHeight+L-r)/d),o=r*k+s;for(let s=0;s<y;++s){const l=Math.max(0,Math.ceil((M-s)/f)),u=Math.min(h.outWidth,(h.inWidth+M-s)/f),c=s*v+o;for(let o=0;o<h.inChannels;++o){const m=o*N+c;for(let c=0;c<h.outChannels;++c){let g=0;for(let m=0;m<h.batchSize;++m){const h=m*A,y=m*C;for(let m=t;m<n;++m){const t=(e+m*p-O)*R+h,n=m*S+y;for(let e=a;e<i;++e){const a=(r+e*d-L)*F+t,i=e*T+n;for(let e=l;e<u;++e){const t=e*E+i;g+=$[(s+e*f-M)*D+a+o]*I[t+c]}}}}x[m+c]=g}}}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const cI={kernelName:"Conv3DBackpropInputV2",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{pad:i,strides:o,inputShape:l}=s;Wk([r],"conv3dBackpropInputV2");const u=_(r.shape),c=_(a.shape),h=Fi(l,a.shape,o,1,i),p=new gs(h.inShape,"float32"),d=p.values,[f,m,g,y]=p.strides,b=n.data.get(r.dataId).values,[x,w,k,v]=u,N=n.data.get(a.dataId).values,[I,C,S,T]=c,{batchSize:E,filterDepth:$,filterHeight:A,filterWidth:R,inChannels:F,inDepth:D,inHeight:O,inWidth:M,outChannels:L,outDepth:z,outHeight:B,outWidth:P,strideDepth:W,strideHeight:V,strideWidth:U}=h,G=$-1-h.padInfo.front,H=A-1-h.padInfo.top,j=R-1-h.padInfo.left;for(let e=0;e<E;++e)for(let t=0;t<F;++t)for(let n=0;n<D;++n){const s=n-G,r=Math.max(0,Math.ceil(s/W)),a=Math.min(z,($+s)/W);for(let i=0;i<O;++i){const o=i-H,l=Math.max(0,Math.ceil(o/V)),u=Math.min(B,(A+o)/V);for(let c=0;c<M;++c){const h=c-j,p=Math.max(0,Math.ceil(h/U)),E=Math.min(P,(R+h)/U);let F=0;for(let n=r;n<a;++n){const r=n*W-s;for(let s=l;s<u;++s){const a=s*V-o;for(let i=p;i<E;++i){const o=x*e+w*n+k*s+v*i,l=I*($-1-r)+C*(A-1-a)+S*(R-1-(i*U-h))+T*t;for(let e=0;e<L;++e){F+=b[o+e]*N[l+e]}}}}d[f*e+m*n+g*i+y*c+t]=F}}}return n.makeTensorInfo(p.shape,p.dtype,p.values)}},hI=hv($e,e=>Math.cos(e)),pI={kernelName:$e,backendName:"cpu",kernelFunc:hI},dI={kernelName:"Cosh",backendName:"cpu",kernelFunc:hv("Cosh",e=>Math.cosh(e))};const fI={kernelName:"CropAndResize",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{image:r,boxes:a,boxInd:i}=t,{cropSize:o,method:l,extrapolationValue:u}=s,[c,h,p,d]=r.shape,f=a.shape[0],[m,g]=o,y=Lr([f,m,g,d],"float32"),b=n.data.get(a.dataId).values,x=n.data.get(i.dataId).values,w=n.data.get(r.dataId).values,k=_(r.shape),v=_(y.shape);for(let e=0;e<f;e++){const t=4*e,n=b[t],s=b[t+1],r=b[t+2],a=b[t+3],i=x[e];if(i>=c)continue;const o=m>1?(r-n)*(h-1)/(m-1):0,f=g>1?(a-s)*(p-1)/(g-1):0;for(let t=0;t<m;t++){const c=m>1?n*(h-1)+t*o:.5*(n+r)*(h-1);if(c<0||c>h-1)for(let n=0;n<g;n++)for(let s=0;s<d;s++){const r=s+n*v[2]+t*v[1]+e*v[0];y.values[r]=u}else if("bilinear"===l){const n=Math.floor(c),r=Math.ceil(c),o=c-n;for(let l=0;l<g;l++){const c=g>1?s*(p-1)+l*f:.5*(s+a)*(p-1);if(c<0||c>p-1){for(let n=0;n<d;n++){const s=n+l*v[2]+t*v[1]+e*v[0];y.values[s]=u}continue}const h=Math.floor(c),m=Math.ceil(c),b=c-h;for(let s=0;s<d;s++){let a=s+h*k[2]+n*k[1]+i*k[0];const u=w[a];a=s+m*k[2]+n*k[1]+i*k[0];const c=w[a];a=s+h*k[2]+r*k[1]+i*k[0];const p=w[a];a=s+m*k[2]+r*k[1]+i*k[0];const d=u+(c-u)*b,f=p+(w[a]-p)*b;a=s+l*v[2]+t*v[1]+e*v[0],y.values[a]=d+(f-d)*o}}}else for(let n=0;n<g;++n){const r=g>1?s*(p-1)+n*f:.5*(s+a)*(p-1);if(r<0||r>p-1){for(let s=0;s<d;s++){const r=s+n*v[2]+t*v[1]+e*v[0];y.values[r]=u}continue}const o=Math.round(r),l=Math.round(c);for(let s=0;s<d;s++){const r=s+o*k[2]+l*k[1]+i*k[0],a=s+n*v[2]+t*v[1]+e*v[0];y.values[a]=w[r]}}}}return n.makeTensorInfo(y.shape,y.dtype,y.values)}};const mI={kernelName:"Cumsum",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s;Wk(r,"cumsum");const l=wl([a],r.shape.length);let u=r;null!=l&&(u=jv({inputs:{x:r},backend:n,attrs:{perm:l}}));const c=vl(1,r.shape.length)[0];if(c!==u.shape.length-1)throw new Error(`backend.cumsum in CPU expects an inner-most axis=${u.shape.length-1} but got axis=${c}`);const p=$s(u.dtype,"int32"),d=L(h(u.shape),p),f=n.data.get(u.dataId).values,m=u.shape[u.shape.length-1],g=o?(e,t)=>e+m-t-1:(e,t)=>e+t;for(let e=0;e<f.length;e+=m)for(let t=0;t<m;t++){const n=g(e,t);if(0===t)d[n]=i?0:f[n];else{const s=g(e,t-1);d[n]=i?f[s]+d[s]:f[n]+d[s]}}const y=n.makeTensorInfo(u.shape,p,d);if(null!=l){const e=jv({inputs:{x:y},backend:n,attrs:{perm:kl(l)}});return n.disposeIntermediateTensorInfo(y),n.disposeIntermediateTensorInfo(u),e}return y}};const gI={kernelName:"DenseBincount",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i,binaryOutput:o}=s;if(1===r.shape.length){const e=lv(n.data.get(r.dataId).values,n.data.get(a.dataId).values,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,e)}if(2===r.shape.length){const e=uv(n.bufferSync(r),n.bufferSync(a),i,o);return n.makeTensorInfo(e.shape,a.dtype,e.values)}throw new Error("Error in denseBincount: input must be at most rank 2, but got rank"+r.shape.length+".")}};const yI={kernelName:"DepthToSpace",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockSize:a,dataFormat:i}=s;o("NHWC"===i,()=>"Only NHWC dataFormat supported on CPU for depthToSpace. Got "+i),o(a>1,()=>"blockSize should be > 1 for depthToSpace, but was: "+a);const l=r.shape[0],u=r.shape[1],c=r.shape[2],h=r.shape[3],p=u*a,d=c*a,f=h/(a*a),m=n.data.get(r.dataId).values,g=new Float32Array(l*p*d*f);let y=0;for(let e=0;e<l;++e)for(let t=0;t<p;++t){const n=Math.floor(t/a),s=t%a;for(let t=0;t<d;++t){const r=Math.floor(t/a),i=(s*a+t%a)*f;for(let t=0;t<f;++t){const s=t+i+h*(r+c*(n+u*e));g[y++]=m[s]}}}return n.makeTensorInfo([l,p,d,f],r.dtype,g)}};function bI(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:l,dilations:u,dimRoundingMode:c}=s;Wk([r,a],"depthwiseConv2DNative");const h=_(r.shape),p=_(a.shape);let d=u;null==d&&(d=[1,1]),o(Bi(i,d),()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${i} and dilations '${d}'`);const f=Ri(r.shape,a.shape,i,d,l,c,!0),{filterHeight:m,filterWidth:g,dilationHeight:y,dilationWidth:b,padInfo:x}=f,w=x.left,k=x.top,v=f.outChannels/f.inChannels,N=new gs(f.outShape,r.dtype),I=n.data.get(r.dataId).values,C=n.data.get(a.dataId).values,S=N.values;for(let e=0;e<f.batchSize;++e){const t=e*h[0],n=e*N.strides[0];for(let e=0;e<f.outHeight;++e){const s=n+e*N.strides[1],r=e*f.strideHeight-w;for(let e=0;e<m;++e){const n=r+e*y;if(n<0||n>=f.inHeight)continue;const a=e*p[0],i=t+n*h[1];for(let e=0;e<f.outWidth;++e){const t=s+e*N.strides[2],n=e*f.strideWidth-k;for(let e=0;e<g;++e){const s=n+e*b;if(s<0||s>=f.inWidth)continue;const r=a+e*p[1],o=i+s*f.inChannels;let l=t,u=r;for(let e=0;e<f.inChannels;++e){const t=I[o+e];for(let e=0;e<v;++e)S[l+e]+=t*C[u+e];l+=v,u+=v}}}}}}return n.makeTensorInfo(N.shape,N.dtype,N.values)}const xI={kernelName:"DepthwiseConv2dNative",backendName:"cpu",kernelFunc:bI};const wI={kernelName:"DepthwiseConv2dNativeBackpropFilter",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,filterShape:c}=s;Wk([r,a],"depthwiseConv2dNativeBackpropFilter");const h=Ri(r.shape,c,i,o,l,u,!0),{strideHeight:p,strideWidth:d,filterHeight:f,filterWidth:m}=h,g=new gs(h.filterShape,"float32"),y=h.padInfo.left,b=h.padInfo.top,x=h.outChannels/h.inChannels,w=n.data.get(r.dataId).values,k=new gs(r.shape,r.dtype,w),v=n.data.get(a.dataId).values,N=new gs(a.shape,a.dtype,v);for(let e=0;e<f;++e){const t=Math.max(0,Math.ceil((b-e)/p)),n=Math.min(h.outHeight,(h.inHeight+b-e)/p);for(let s=0;s<m;++s){const r=Math.max(0,Math.ceil((y-s)/d)),a=Math.min(h.outWidth,(h.inWidth+y-s)/d);for(let i=0;i<h.outChannels;++i){const o=Math.trunc(i/x),l=i%x;let u=0;for(let l=0;l<h.batchSize;++l)for(let c=t;c<n;++c){const t=e+c*p-b;for(let e=r;e<a;++e){const n=s+e*d-y;u+=k.get(l,t,n,o)*N.get(l,c,e,i)}}g.set(u,e,s,o,l)}}}return n.makeTensorInfo(g.shape,g.dtype,g.values)}};const kI={kernelName:"DepthwiseConv2dNativeBackpropInput",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,inputShape:c}=s;Wk([r,a],"depthwiseConv2DNativeBackpropInput");const h=_(r.shape),p=_(a.shape),d=Ri(c,a.shape,i,o,l,u,!0),f=new gs(d.inShape,"float32"),m=f.values,[g,y,b]=f.strides,x=n.data.get(r.dataId).values,[w,k,v]=h,N=n.data.get(a.dataId).values,[I,C,S]=p,{batchSize:T,filterHeight:E,filterWidth:$,inChannels:A,inHeight:R,inWidth:F,outChannels:D,outHeight:O,outWidth:M,strideHeight:L,strideWidth:z}=d,B=E-1-d.padInfo.top,P=$-1-d.padInfo.left,W=D/A;for(let e=0;e<T;++e)for(let t=0;t<A;++t)for(let n=0;n<R;++n){const s=n-B,r=Math.max(0,Math.ceil(s/L)),a=Math.min(O,(E+s)/L);for(let i=0;i<F;++i){const o=i-P,l=Math.max(0,Math.ceil(o/z)),u=Math.min(M,($+o)/z);let c=0;for(let n=r;n<a;++n){const r=n*L-s;for(let s=l;s<u;++s){const a=w*e+k*n+v*s,i=I*(E-1-r)+C*($-1-(s*z-o))+S*t;for(let e=0;e<W;++e){c+=x[a+(t*W+e)]*N[i+e]}}}m[g*e+y*n+b*i+t]=c}}return n.makeTensorInfo(f.shape,f.dtype,f.values)}};const vI={kernelName:"Diag",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=h(s.shape),a=n.data.get(s.dataId).values,i=Lr([r,r],s.dtype),o=i.values;for(let e=0;e<a.length;e++)o[e*r+e]=a[e];const l=[...s.shape,...s.shape];return n.makeTensorInfo(l,i.dtype,i.values)}},NI={kernelName:"Dilation2D",backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r}=e,{strides:a,pad:i,dilations:o}=n,l=t,u=l.data.get(s.dataId).values,c=s.shape.length,p=l.data.get(r.dataId).values,d=r.shape.length,{batchSize:f,inHeight:m,inWidth:g,inChannels:y,outHeight:b,outWidth:x,padInfo:w,strideHeight:v,strideWidth:N,filterHeight:I,filterWidth:C,dilationHeight:S,dilationWidth:T,outShape:E}=Ei(s.shape,r.shape,a,i,"NHWC",o),$=h(E),A=E.length,R=k(s.dtype,$);for(let e=0;e<f;++e)for(let t=0;t<b;++t){const n=t*v-w.top;for(let a=0;a<x;++a){const i=a*N-w.left;for(let o=0;o<y;++o){let l=Number.MIN_SAFE_INTEGER;for(let t=0;t<I;++t){const a=n+t*S;if(a>=0&&a<m)for(let n=0;n<C;++n){const h=i+n*T;if(h>=0&&h<g){const i=P([e,a,h,o],c,_(s.shape)),f=P([t,n,o],d,_(r.shape)),m=u[i]+p[f];m>l&&(l=m)}}}R[P([e,t,a,o],A,_(E))]=l}}}return{dataId:l.write(ss(R,s.dtype),E,s.dtype),shape:E,dtype:s.dtype}}},II={kernelName:"Dilation2DBackpropFilter",backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r,dy:a}=e,{strides:i,pad:l,dilations:u}=n,c=t,h=O(s.shape,c.data.get(s.dataId).values),p=O(r.shape,c.data.get(r.dataId).values),{batchSize:d,inHeight:f,inWidth:m,inChannels:g,outHeight:y,outWidth:b,padInfo:x,strideHeight:w,strideWidth:k,filterHeight:v,filterWidth:N,dilationHeight:I,dilationWidth:C,outShape:S}=Ei(s.shape,r.shape,i,l,"NHWC",u);o(a.rank===S.length,()=>`Error in Dilation2DBackpropFilter, dy must have the same rank as output ${S.length}, but got `+a.rank);const T=O(S,c.data.get(a.dataId).values),E=z(r.shape,r.dtype);for(let e=0;e<d;++e)for(let t=0;t<y;++t){const n=t*w-x.top;for(let s=0;s<b;++s){const r=s*k-x.left;for(let a=0;a<g;++a){let i=Number.MIN_SAFE_INTEGER,o=0,l=0;for(let t=0;t<v;++t){const s=n+t*I;if(s>=0&&s<f)for(let n=0;n<N;++n){const u=r+n*C;if(u>=0&&u<m){const r=h[e][s][u][a]+p[t][n][a];r>i&&(i=r,o=t,l=n)}}}E[o][l][a]+=T[e][t][s][a]}}}return{dataId:c.write(ss(E,s.dtype),r.shape,r.dtype),shape:r.shape,dtype:r.dtype}}},CI={kernelName:"Dilation2DBackpropInput",backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r,dy:a}=e,{strides:i,pad:l,dilations:u}=n,c=t,h=O(s.shape,c.data.get(s.dataId).values),p=O(r.shape,c.data.get(r.dataId).values),{batchSize:d,inHeight:f,inWidth:m,inChannels:g,outHeight:y,outWidth:b,padInfo:x,strideHeight:w,strideWidth:k,filterHeight:v,filterWidth:N,dilationHeight:I,dilationWidth:C,outShape:S}=Ei(s.shape,r.shape,i,l,"NHWC",u);o(a.rank===S.length,()=>`Error in Dilation2DBackpropInput, dy must have the same rank as output ${S.length}, but got `+a.rank);const T=O(S,c.data.get(a.dataId).values),E=z(s.shape,s.dtype);for(let e=0;e<d;++e)for(let t=0;t<y;++t){const n=t*w-x.top;for(let s=0;s<b;++s){const r=s*k-x.left;for(let a=0;a<g;++a){let i=Number.MIN_SAFE_INTEGER,o=n<0?0:n,l=r<0?0:r;for(let t=0;t<v;++t){const s=n+t*I;if(s>=0&&s<f)for(let n=0;n<N;++n){const u=r+n*C;if(u>=0&&u<m){const r=h[e][s][u][a]+p[t][n][a];r>i&&(i=r,o=s,l=u)}}}E[e][o][l][a]+=T[e][t][s][a]}}}return{dataId:c.write(ss(E,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};const SI={kernelName:"EluGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{dy:s,y:r}=t;Wk([s,r],"eluGrad");const a=new Float32Array(h(r.shape)),i=n.data.get(r.dataId).values,o=n.data.get(s.dataId).values;for(let e=0;e<i.length;++e){const t=i[e];a[e]=t>=1?o[e]:o[e]*(t+1)}return n.makeTensorInfo(r.shape,"float32",a)}},TI=nv("Equal",jk((e,t)=>e===t?1:0),null,"bool"),EI={kernelName:"Equal",backendName:"cpu",kernelFunc:TI},$I=hv(He,e=>{const t=Math.sign(e),n=Math.abs(e),s=1/(1+.3275911*n);return t*(1-((((1.061405429*s-1.453152027)*s+1.421413741)*s-.284496736)*s+.254829592)*s*Math.exp(-n*n))}),AI={kernelName:He,backendName:"cpu",kernelFunc:$I};function RI(e){const{inputs:t,backend:n,attrs:s}=e,{input:r}=t,{dim:a}=s,i=r.shape.length,l=r.shape.slice();let u=a;return a<0&&(o(-(i+1)<=a,()=>`Axis must be in the interval [${-(i+1)}, ${i}]`),u=i+a+1),l.splice(u,0,1),CN({inputs:{x:r},backend:n,attrs:{shape:l}})}const FI={kernelName:"ExpandDims",backendName:"cpu",kernelFunc:RI},DI=nv("RealDiv",jk((e,t)=>e/t)),_I={kernelName:"RealDiv",backendName:"cpu",kernelFunc:DI};function OI(e,t,n){const s=e.shape,r=s[0],a=s[1],i=n.data.get(e.dataId),o=i.complexTensorInfos.real,l=i.complexTensorInfos.imag,u=[r,a],c=h(u),p=w("float32",c),d=w("float32",c);for(let e=0;e<r;e++){const s=eN({inputs:{x:o},backend:n,attrs:{begin:[e,0],size:[1,a]}}),r=eN({inputs:{x:l},backend:n,attrs:{begin:[e,0],size:[1,a]}}),i=qk({inputs:{real:s,imag:r},backend:n}),{real:u,imag:c}=MI(i,t,n),h=qh(u,c);for(let t=0;t<a;t++){const n=Jh(h,t);p[e*a+t]=n.real,d[e*a+t]=n.imag}n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(i)}const f=n.makeTensorInfo(u,"float32",p),m=n.makeTensorInfo(u,"float32",d),g=qk({inputs:{real:f,imag:m},backend:n});return n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}function MI(e,t,n){const s=h(e.shape),r=n.data.get(e.dataId),a=n.data.get(r.complexTensorInfos.real.dataId).values,i=n.data.get(r.complexTensorInfos.imag.dataId).values;if(0==((o=s)&o-1)){const r=function e(t,n,s,r,a){if(1===s)return{real:t,imag:n};const i=qh(t,n),o=s/2,l=Xh(i),u=l.real,c=l.imag,h=[u.length],p=a.makeTensorInfo(h,"float32",u),d=a.makeTensorInfo(h,"float32",c),f=qk({inputs:{real:p,imag:d},backend:a}),m=Yh(i),g=m.real,y=m.imag,b=[g.length],x=a.makeTensorInfo(b,"float32",g),w=a.makeTensorInfo(b,"float32",y),k=qk({inputs:{real:x,imag:w},backend:a}),v=e(u,c,o,r,a),N=v.real,I=v.imag,C=[N.length],S=a.makeTensorInfo(C,"float32",N),T=a.makeTensorInfo(C,"float32",I),E=qk({inputs:{real:S,imag:T},backend:a}),$=e(g,y,o,r,a),A=$.real,R=$.imag,F=[A.length],D=a.makeTensorInfo(F,"float32",A),_=a.makeTensorInfo(F,"float32",R),O=qk({inputs:{real:D,imag:_},backend:a}),M=Qh(s,r),L=[M.real.length],z=a.makeTensorInfo(L,"float32",M.real),B=a.makeTensorInfo(L,"float32",M.imag),P=qk({inputs:{real:z,imag:B},backend:a}),W=Bv({inputs:{a:P,b:O},backend:a}),V=iv({inputs:{a:E,b:W},backend:a}),U=oN({inputs:{a:E,b:W},backend:a}),G=Zk({inputs:{input:V},backend:a}),H=Zk({inputs:{input:U},backend:a}),j=eI({inputs:{input:V},backend:a}),q=eI({inputs:{input:U},backend:a}),K=nI({inputs:[G,H],backend:a,attrs:{axis:0}}),X=nI({inputs:[j,q],backend:a,attrs:{axis:0}}),Y=a.data.get(K.dataId).values,J=a.data.get(X.dataId).values;return a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(d),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(x),a.disposeIntermediateTensorInfo(w),a.disposeIntermediateTensorInfo(k),a.disposeIntermediateTensorInfo(S),a.disposeIntermediateTensorInfo(T),a.disposeIntermediateTensorInfo(E),a.disposeIntermediateTensorInfo(D),a.disposeIntermediateTensorInfo(_),a.disposeIntermediateTensorInfo(O),a.disposeIntermediateTensorInfo(z),a.disposeIntermediateTensorInfo(B),a.disposeIntermediateTensorInfo(P),a.disposeIntermediateTensorInfo(W),a.disposeIntermediateTensorInfo(V),a.disposeIntermediateTensorInfo(U),a.disposeIntermediateTensorInfo(G),a.disposeIntermediateTensorInfo(j),a.disposeIntermediateTensorInfo(H),a.disposeIntermediateTensorInfo(q),a.disposeIntermediateTensorInfo(K),a.disposeIntermediateTensorInfo(X),{real:Y,imag:J}}(a,i,s,t,n),o=[e.shape[0],e.shape[1]];if(t){const e=n.makeTensorInfo(o,"float32",r.real),t=n.makeTensorInfo(o,"float32",r.imag),a=n.makeTensorInfo([],"float32",ns(s,"float32")),i=Yk({inputs:{x:a},backend:n}),l=_I.kernelFunc({inputs:{a:e,b:a},backend:n}),u=_I.kernelFunc({inputs:{a:t,b:i},backend:n}),c=n.data.get(l.dataId).values,h=n.data.get(u.dataId).values;return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(a),n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(u),{real:c,imag:h}}return r}return Kh(function(e,t,n){const s=new Float32Array(2*t);for(let r=0;r<t;r++){let a=0,i=0;for(let s=0;s<t;s++){const o=ep(r*s,t,n),l=Jh(e,s);a+=l.real*o.real-l.imag*o.imag,i+=l.real*o.imag+l.imag*o.real}n&&(a/=t,i/=t),Zh(s,a,i,r)}return s}(qh(a,i),s,t));var o}const LI={kernelName:"FFT",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t,r=h(s.shape),a=s.shape[s.shape.length-1],i=CN({inputs:{x:s},backend:n,attrs:{shape:[r/a,a]}}),o=OI(i,!1,n),l=CN({inputs:{x:o},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),l}};function zI(e){const{backend:t,attrs:n}=e,{shape:s,value:r,dtype:a}=n,i=a||R(r),o=k(i,h(s));return function(e,t,n){e.fill(t)}(o,r),t.makeTensorInfo(s,i,o)}const BI={kernelName:"Fill",backendName:"cpu",kernelFunc:zI};const PI={kernelName:"FlipLeftRight",backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,r=n,a=w(s.dtype,h(s.shape)),[i,o,l,u]=s.shape,c=r.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*l*o*u;for(let e=0;e<o;e++){const n=e*(l*u);for(let s=0;s<l;s++){const r=s*u;for(let o=0;o<u;o++){const h=[i,e,s,o][2],p=Math.round(l-h),d=t+n+r+o;let f=c[d];if(p>=0&&p<l){f=c[t+n+p*u+o]}a[d]=f}}}}return{dataId:r.write(a,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},WI={kernelName:"FloorDiv",backendName:"cpu",kernelFunc:nv("FloorDiv",jk((e,t)=>Math.floor(e/t)),null,"int32")};const VI={kernelName:"FusedConv2D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s;let m=rI({inputs:{x:r,filter:a},backend:n,attrs:{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p}});if(i){const e=m;m=iv({inputs:{a:m,b:i},backend:n}),n.disposeIntermediateTensorInfo(e)}if(d){const e=m;m=IN(n,m,d,o,f),n.disposeIntermediateTensorInfo(e)}return m}};const UI={kernelName:"FusedDepthwiseConv2D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s;let m=bI({inputs:{x:r,filter:a},backend:n,attrs:{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p}});if(i){const e=m;m=iv({inputs:{a:m,b:i},backend:n}),n.disposeIntermediateTensorInfo(e)}if(d){const e=m;m=IN(n,m,d,o,f),n.disposeIntermediateTensorInfo(e)}return m}};const GI={kernelName:"GatherNd",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{params:s,indices:r}=t,a=h(s.shape),i=r.shape,o=i[i.length-1],[l,u,c,p]=ha(s,r);if(0===u)return n.makeTensorInfo(l,s.dtype,[]);const d=Lr([u,c],s.dtype),f=n.data.get(r.dataId).values,m=n.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=[];let n=0;for(let s=0;s<o;s++){const r=f[e*o+s];n+=r*p[s],t.push(r)}if(n<0||n>=a/c)throw new Error(`Invalid indices: ${t} does not index into ${s.shape}`);for(let t=0;t<c;t++)d.values[e*c+t]=m[n*c+t]}return n.makeTensorInfo(l,d.dtype,d.values)}};const HI={kernelName:"GatherV2",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,indices:a}=t,{axis:i,batchDims:o}=s;Wk([r,a],"gatherV2");let l=o;null==o&&(l=0);const u=h(a.shape),c=rp(r,a,b(i,r.shape)[0],l),p=CN({inputs:{x:r},backend:n,attrs:{shape:[c.batchSize,c.outerSize,c.dimSize,c.sliceSize]}}),d=CN({inputs:{x:a},backend:n,attrs:{shape:[c.batchSize,u/c.batchSize]}}),f=[c.batchSize,c.outerSize,u/c.batchSize,c.sliceSize],m=n.bufferSync(d),g=Nv(n.bufferSync(p),m,f);return n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(d),n.makeTensorInfo(c.outputShape,g.dtype,g.values)}},jI={kernelName:"GreaterEqual",backendName:"cpu",kernelFunc:nv("GreaterEqual",jk((e,t)=>e>=t?1:0),null,"bool")};const qI={kernelName:"IFFT",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t,r=h(s.shape),a=s.shape[s.shape.length-1],i=CN({inputs:{x:s},backend:n,attrs:{shape:[r/a,a]}}),o=OI(i,!0,n),l=CN({inputs:{x:o},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),l}},KI={kernelName:"IsFinite",backendName:"cpu",kernelFunc:hv("IsFinite",e=>Number.isFinite(e)?1:0,"bool")},XI={kernelName:"IsInf",backendName:"cpu",kernelFunc:hv("IsInf",e=>Math.abs(e)===1/0?1:0,"bool")},YI={kernelName:"IsNan",backendName:"cpu",kernelFunc:hv("IsNan",e=>Number.isNaN(e)?1:0,"bool")},JI={kernelName:"LessEqual",backendName:"cpu",kernelFunc:nv("LessEqual",jk((e,t)=>e<=t?1:0),null,"bool")};const ZI={kernelName:"LinSpace",backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,num:a}=n,i=Ev(s,r,a);return t.makeTensorInfo([i.length],"float32",i)}},QI={kernelName:"Log1p",backendName:"cpu",kernelFunc:hv("Log1p",e=>Math.log1p(e))},eC={kernelName:"LogicalAnd",backendName:"cpu",kernelFunc:nv("LogicalAnd",jk((e,t)=>e&&t),null,"bool")},tC={kernelName:"LogicalNot",backendName:"cpu",kernelFunc:hv("LogicalNot",e=>e?0:1,"bool")},nC={kernelName:"LogicalOr",backendName:"cpu",kernelFunc:nv("LogicalOr",jk((e,t)=>e||t),null,"bool")};const sC={kernelName:"LRN",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{depthRadius:a,bias:i,alpha:o,beta:l}=s;Wk(r,"LRN");const u=r.shape[3],c=u-1,p=n.data.get(r.dataId).values,d=h(r.shape),f=new Float32Array(d);function m(e){const t=e%u;let n=e-t+Math.max(0,t-a);const s=e-t+Math.min(t+a,c);let r=0;for(;n<=s;n++){const e=p[n];r+=e*e}return r}for(let e=0;e<d;e++){const t=m(e),n=p[e]*Math.pow(i+o*t,-l);f[e]=n}return n.makeTensorInfo(r.shape,r.dtype,f)}};const rC={kernelName:"LRNGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,y:a,dy:i}=t,{depthRadius:o,bias:l,alpha:u,beta:c}=s;Wk(i,"LRNGrad");const p=h(i.shape),d=i.shape[3],f=n.data.get(i.dataId).values,m=n.data.get(r.dataId).values,g=n.data.get(a.dataId).values,y=new Float32Array(p),b=p;for(let e=0;e<b;e++){const t=e%d,n=e-t+Math.max(0,t-o),s=e-t+Math.min(d,t+o+1);let r=0;for(let e=n;e<s;e++)r+=Math.pow(m[e],2);r=u*r+l;for(let t=n;t<s;t++){let n=-2*u*c*m[t]*g[e]/r;e===t&&(n+=Math.pow(r,-c)),n*=f[e],y[t]+=n}}return n.makeTensorInfo(i.shape,r.dtype,y)}};function aC(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reductionIndices:a,keepDims:i}=s,o=n;let l=r.shape;const u=l.length,c=b(a,l);let p=c;const d=wl(p,u);let f=o.data.get(r.dataId).values;if(null!=d){const e=new Array(u);for(let t=0;t<e.length;t++)e[t]=l[d[t]];f=Hv(f,l,r.dtype,d,e),p=vl(p.length,u),l=e}Wk(r,"max"),xl("max",p,u);const[m,g]=yl(l,p),y=Fv(f,h(g),m,r.dtype),x=o.write(y,m,r.dtype);let w=m;if(i){w=bl(m,c)}return{dataId:x,shape:w,dtype:r.dtype}}const iC={kernelName:"Max",backendName:"cpu",kernelFunc:aC};const oC={kernelName:"MaxPool",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;Wk(r,"maxPool");const{filterSize:a,strides:i,pad:l,dimRoundingMode:u}=s;o(Bi(i,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`);const c=$i(r.shape,a,i,1,l,u);let h;if(1===c.filterWidth&&1===c.filterHeight&&p(c.inShape,c.outShape))h=Yk({inputs:{x:r},backend:n});else{const e=n.data.get(r.dataId).values,t=_(r.shape),s=VN(e,r.shape,r.dtype,t,c,"max");h=n.makeTensorInfo(c.outShape,r.dtype,s.values)}return h}};const lC={kernelName:"MaxPool3D",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s;Wk(r,"maxPool3d");const c=Ai(r.shape,a,i,1,o,l,u),h=GN(n.data.get(r.dataId).values,r.shape,r.dtype,_(r.shape),c,"max");return n.makeTensorInfo(h.shape,"float32",h.values)}};const uC={kernelName:"MaxPool3DGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,{filterSize:i,strides:o,pad:l,dimRoundingMode:u}=s;Wk([r,a],"maxPool3DGrad");const c=Ai(a.shape,i,o,1,l,u),h=function(e,t){const n=Lr(t.outShape,"int32"),s=t.strideDepth,r=t.strideHeight,a=t.strideWidth,i=t.dilationDepth,o=t.dilationHeight,l=t.dilationWidth,u=t.effectiveFilterDepth,c=t.effectiveFilterHeight,h=t.effectiveFilterWidth,p=t.padInfo.front,d=t.padInfo.top,f=t.padInfo.left;for(let m=0;m<t.batchSize;++m)for(let g=0;g<t.inChannels;++g)for(let y=0;y<t.outDepth;++y){const b=y*s-p;let x=b;for(;x<0;)x+=i;const w=Math.min(t.inDepth,u+b);for(let s=0;s<t.outHeight;++s){const u=s*r-d;let p=u;for(;p<0;)p+=o;const k=Math.min(t.inHeight,c+u);for(let r=0;r<t.outWidth;++r){const d=r*a-f;let v=d;for(;v<0;)v+=l;const N=Math.min(t.inWidth,h+d);let I=Number.NEGATIVE_INFINITY,C=-1;for(let t=x;t<w;t+=i){const n=t-b;for(let s=p;s<k;s+=o){const r=s-u;for(let a=v;a<N;a+=l){const i=a-d,o=e.get(m,t,s,a,g);o>=I&&(I=o,C=n*c*h+r*c+i)}}}n.set(C,m,y,s,r,g)}}}return n}(n.bufferSync(a),c),p=c.strideDepth,d=c.strideHeight,f=c.strideWidth,m=c.dilationDepth,g=c.dilationHeight,y=c.dilationWidth,b=c.effectiveFilterDepth,x=c.effectiveFilterHeight,w=c.effectiveFilterWidth,k=b-1-c.padInfo.front,v=w-1-c.padInfo.left,N=x-1-c.padInfo.top,I=Lr(a.shape,"float32"),C=n.bufferSync(r);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inDepth;++n)for(let s=0;s<c.inHeight;++s)for(let r=0;r<c.inWidth;++r){const a=n-k,i=s-N,o=r-v;let l=0;for(let n=0;n<b;n+=m){const s=(a+n)/p;if(!(s<0||s>=c.outDepth||Math.floor(s)!==s))for(let r=0;r<x;r+=g){const a=(i+r)/d;if(!(a<0||a>=c.outHeight||Math.floor(a)!==a))for(let i=0;i<w;i+=y){const u=(o+i)/f;if(u<0||u>=c.outWidth||Math.floor(u)!==u)continue;const p=b*x*w-1-h.get(e,s,a,u,t)===n*x*w+r*w+i?1:0;0!==p&&(l+=C.get(e,s,a,u,t)*p)}}}I.set(l,e,n,s,r,t)}return n.makeTensorInfo(I.shape,I.dtype,I.values)}};const cC={kernelName:"MaxPoolGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a,output:i}=t,o=a;Wk([a,i],"maxPoolGrad");const{filterSize:l,strides:u,pad:c,dimRoundingMode:h}=s,p=$i(o.shape,l,u,1,c,h),d=n.data.get(o.dataId).values,f=Lr(p.outShape,o.dtype,UN(d,o.shape,o.dtype,p).values),m=p.strideHeight,g=p.strideWidth,y=p.dilationHeight,b=p.dilationWidth,x=p.effectiveFilterHeight,w=p.effectiveFilterWidth,k=w-1-p.padInfo.left,v=x-1-p.padInfo.top,N=Lr(o.shape,"float32"),I=n.data.get(r.dataId).values,C=Lr(r.shape,"float32",I);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inHeight;++n)for(let s=0;s<p.inWidth;++s){const r=n-v,a=s-k;let i=0;for(let n=0;n<x;n+=y){const s=(r+n)/m;if(!(s<0||s>=p.outHeight||Math.floor(s)!==s))for(let r=0;r<w;r+=b){const o=(a+r)/g;if(o<0||o>=p.outWidth||Math.floor(o)!==o)continue;const l=x*w-1-f.get(e,s,o,t)===n*w+r?1:0;0!==l&&(i+=C.get(e,s,o,t)*l)}}N.set(i,e,n,s,t)}return n.makeTensorInfo(N.shape,N.dtype,N.values)}};const hC={kernelName:"MaxPoolWithArgmax",backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{filterSize:r,strides:a,pad:i,includeBatchInIndex:o}=t,l=n;Wk(s,"MaxPoolWithArgmax");const u=l.data.get(s.dataId).values,c=$i(s.shape,r,a,[1,1],i),[h,p]=function(e,t,n,s,r){const a=VN(e,0,n,_(t),r,"max"),i=UN(e,t,n,r,!0,s);return[a.values,i.values]}(u,s.shape,s.dtype,o,c),d=l.write(h,c.outShape,s.dtype),f=l.write(p,c.outShape,s.dtype);return[{dataId:d,shape:c.outShape,dtype:s.dtype},{dataId:f,shape:c.outShape,dtype:"int32"}]}};function pC(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;let o;Wk(r,"sum"),o="bool"===r.dtype?ev({inputs:{x:r},backend:n,attrs:{dtype:"int32"}}):Yk({inputs:{x:r},backend:n});const l=o.shape.length,u=b(a,o.shape),c=wl(u,l);let p=u,d=o;null!=c&&(d=jv({inputs:{x:o},backend:n,attrs:{perm:c}}),p=vl(p.length,l)),xl("sum",p,d.shape.length);const[f,m]=yl(d.shape,p);let g=Xk(n,f,$s(d.dtype,"int32"));const y=h(m),x=n.data.get(g.dataId).values,w=n.data.get(d.dataId).values;for(let e=0;e<x.length;++e){const t=e*y;let n=0;for(let e=0;e<y;++e)n+=w[t+e];x[e]=n}if(i){const e=g;g=CN({inputs:{x:g},backend:n,attrs:{shape:bl(g.shape,u)}}),n.disposeIntermediateTensorInfo(e)}return n.disposeIntermediateTensorInfo(o),null!=c&&n.disposeIntermediateTensorInfo(d),g}const dC={kernelName:"Sum",backendName:"cpu",kernelFunc:pC};const fC={kernelName:"Mean",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=b(a,r.shape),l=h(yl(r.shape,o)[1]),u=[],c=n.makeTensorInfo([],"float32",new Float32Array([l]));u.push(c);const p=ev({inputs:{x:r},backend:n,attrs:{dtype:"float32"}});u.push(p);const d=DI({inputs:{a:p,b:c},backend:n});u.push(d);const f=pC({inputs:{x:d},backend:n,attrs:{axis:a,keepDims:i}});return u.forEach(e=>n.disposeIntermediateTensorInfo(e)),f}};const mC={kernelName:"Min",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;Wk(r,"min");const o=b(a,r.shape);let l=o;const u=wl(l,r.shape.length);let c=r;null!=u&&(c=jv({inputs:{x:r},backend:n,attrs:{perm:u}}),l=vl(l.length,r.shape.length)),xl("min",l,c.shape.length);const[p,d]=yl(c.shape,l),f=h(d),m=L(h(p),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];s<n&&(n=s)}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(p,c.dtype,m);if(i){const e=CN({inputs:{x:y},backend:n,attrs:{shape:bl(p,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const gC={kernelName:"MirrorPad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,mode:i}=s;Wk(r,"mirrorPad");const o=a.map((e,t)=>e[0]+r.shape[t]+e[1]),l=a.map(e=>e[0]),u=a.map((e,t)=>e[0]+r.shape[t]),c="reflect"===i?0:1,p=n.data.get(r.dataId).values,d=r.shape.length,f=_(r.shape),m=h(o),g=o.length,y=_(o),b=w(r.dtype,m);for(let e=0;e<m;e++){let t=W(e,g,y);for(let e=0;e<g;e++)t[e]<l[e]?t[e]=2*l[e]-t[e]-c:t[e]>=u[e]&&(t[e]=2*(u[e]-1)-t[e]+c);t=t.map((e,t)=>e-l[t]);const n=P(t,d,f);b[e]=p[n]}return{dataId:n.write(b,o,r.dtype),shape:o,dtype:r.dtype}}},yC=jk((e,t)=>{const n=e%t;return e<0&&t<0||e>=0&&t>=0?n:(n+t)%t}),bC=nv(Ot,yC),xC={kernelName:Ot,backendName:"cpu",kernelFunc:bC};function wC(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{dim:a}=s,i=r.shape.length;let o=a;if(-1===o&&(o=i-1),o!==i-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${i} and dim was ${o}`);const l=b([o],r.shape),u=aC({inputs:{x:r},backend:n,attrs:{reductionIndices:l,keepDims:!1}}),c=bl(u.shape,l),h=CN({inputs:{x:u},backend:n,attrs:{shape:c}}),p=oN({inputs:{a:r,b:h},backend:n}),d=yv({inputs:{x:p},backend:n}),f=pC({inputs:{x:d},backend:n,attrs:{axis:l,keepDims:!1}}),m=CN({inputs:{x:f},backend:n,attrs:{shape:c}}),g=DI({inputs:{a:d,b:m},backend:n});return n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}const kC={kernelName:"Softmax",backendName:"cpu",kernelFunc:wC};const vC={kernelName:"Multinomial",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{numSamples:a,seed:i,normalized:o}=s;Wk(r,"multinomial");const l=o?r:wC({inputs:{logits:r},backend:n,attrs:{dim:-1}}),u=l.shape[0],c=l.shape[1],p=n.data.get(l.dataId).values,d=[u,a],f=L(h(d),"int32");for(let e=0;e<u;++e){const t=e*c,n=new Float32Array(c-1);n[0]=p[t];for(let e=1;e<n.length;++e)n[e]=n[e-1]+p[t+e];const s=hu(i.toString()),r=e*a;for(let e=0;e<a;++e){const t=s();f[r+e]=n.length;for(let s=0;s<n.length;s++)if(t<n[s]){f[r+e]=s;break}}}return o||n.disposeIntermediateTensorInfo(l),n.makeTensorInfo(d,"int32",f)}},NC=Hc;const IC={kernelName:"NonMaxSuppressionV3",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=s;Wk(r,"NonMaxSuppression");const u=n.data.get(r.dataId).values,c=n.data.get(a.dataId).values,{selectedIndices:h}=NC(u,c,i,o,l);return n.makeTensorInfo([h.length],"int32",new Int32Array(h))}},CC=jc;const SC={kernelName:"NonMaxSuppressionV4",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,padToMaxOutputSize:u}=s;Wk(r,"NonMaxSuppressionPadded");const c=n.data.get(r.dataId).values,h=n.data.get(a.dataId).values,{selectedIndices:p,validOutputs:d}=CC(c,h,i,o,l,u);return[n.makeTensorInfo([p.length],"int32",new Int32Array(p)),n.makeTensorInfo([],"int32",new Int32Array([d]))]}},TC=qc;const EC={kernelName:"NonMaxSuppressionV5",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,softNmsSigma:u}=s;Wk(r,"NonMaxSuppressionWithScore");const c=n.data.get(r.dataId).values,h=n.data.get(a.dataId).values,p=i,d=o,f=l,m=u,{selectedIndices:g,selectedScores:y}=TC(c,h,p,d,f,m);return[n.makeTensorInfo([g.length],"int32",new Int32Array(g)),n.makeTensorInfo([y.length],"float32",new Float32Array(y))]}};const $C={kernelName:"OneHot",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r}=t,{depth:a,onValue:i,offValue:o}=s;Wk(r,"oneHot");const l=h(r.shape),u=new Float32Array(l*a);u.fill(o);const c=n.data.get(r.dataId).values;for(let e=0;e<l;++e)c[e]>=0&&c[e]<a&&(u[e*a+c[e]]=i);return n.makeTensorInfo([...r.shape,a],"int32",u)}};function AC(e){const{inputs:t,backend:n}=e,{x:s}=t;if("string"===s.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===s.dtype){const e=Zk({inputs:{input:s},backend:n}),t=AC({inputs:{x:e},backend:n}),r=eI({inputs:{input:s},backend:n}),a=AC({inputs:{x:r},backend:n}),i=qk({inputs:{real:t,imag:a},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(a),i}return zI({backend:n,attrs:{shape:s.shape,value:0,dtype:s.dtype}})}const RC={kernelName:"ZerosLike",backendName:"cpu",kernelFunc:AC};const FC={kernelName:"OnesLike",backendName:"cpu",kernelFunc:function e(t){const{inputs:n,backend:s}=t,{x:r}=n;if("string"===r.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===r.dtype){const t=Zk({inputs:{input:r},backend:s}),n=e({inputs:{x:t},backend:s}),a=eI({inputs:{input:r},backend:s}),i=AC({inputs:{x:a},backend:s}),o=qk({inputs:{real:n,imag:i},backend:s});return s.disposeIntermediateTensorInfo(t),s.disposeIntermediateTensorInfo(n),s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}return zI({backend:s,attrs:{shape:r.shape,value:1,dtype:r.dtype}})}};function DC(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s;if(1===t.length)return RI({inputs:{input:t[0]},backend:n,attrs:{dim:r}});const a=t[0].shape,i=t[0].dtype;t.forEach(e=>{l(a,e.shape,"All tensors passed to stack must have matching shapes"),o(i===e.dtype,()=>"All tensors passed to stack must have matching dtypes")});const u=[],c=nI({inputs:t.map(e=>{const t=RI({inputs:{input:e},backend:n,attrs:{dim:r}});return u.push(t),t}),backend:n,attrs:{axis:r}});return u.forEach(e=>n.disposeIntermediateTensorInfo(e)),c}const _C={kernelName:"Pack",backendName:"cpu",kernelFunc:DC};const OC={kernelName:"PadV2",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,constantValue:i}=s;Wk(r,"pad");const o=a.map((e,t)=>e[0]+r.shape[t]+e[1]),l=a.map(e=>e[0]),u=n.data.get(r.dataId).values,c=h(r.shape),p=r.shape.length,d=_(r.shape),f=h(o),m=o.length,g=_(o),y=w(r.dtype,f);0!==i&&y.fill(i);for(let e=0;e<c;e++){y[P(W(e,p,d).map((e,t)=>e+l[t]),m,g)]=u[e]}return{dataId:n.write(y,o,r.dtype),shape:o,dtype:r.dtype}}},MC=jk((e,t)=>Math.pow(e,t)),LC=nv(Kt,MC),zC={kernelName:Kt,backendName:"cpu",kernelFunc:LC};const BC={kernelName:"Range",backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,dtype:a,step:i}=n,o=Yv(s,r,i,a);return t.makeTensorInfo([o.length],a,o)}},PC={kernelName:"Reciprocal",backendName:"cpu",kernelFunc:hv("Reciprocal",e=>1/e)};const WC={kernelName:"ResizeBilinear",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s;Wk(r,"resizeBilinear");const l=_(r.shape),[u,c]=o,[p,d,f,m]=r.shape,g=n.data.get(r.dataId).values,y=new Float32Array(h([p,u,c,m])),b=[a&&u>1?d-1:d,a&&c>1?f-1:f],x=[a&&u>1?u-1:u,a&&c>1?c-1:c];let w=0;const k=b[0]/x[0],v=b[1]/x[1];for(let e=0;e<p;e++)for(let t=0;t<u;t++){let n;n=i?k*(t+.5)-.5:k*t;const s=Math.max(0,Math.floor(n)),r=n-s,a=Math.min(d-1,Math.ceil(n)),o=e*l[0]+s*l[1],u=e*l[0]+a*l[1];for(let e=0;e<c;e++){let t;t=i?v*(e+.5)-.5:v*e;const n=Math.max(0,Math.floor(t)),s=t-n,a=Math.min(f-1,Math.ceil(t)),c=o+n*l[2],h=u+n*l[2],p=o+a*l[2],d=u+a*l[2];for(let e=0;e<m;e++){const t=g[c+e],n=g[h+e],a=t+(g[p+e]-t)*s,i=a+(n+(g[d+e]-n)*s-a)*r;y[w++]=i}}}return n.makeTensorInfo([p,u,c,m],"float32",y)}};const VC={kernelName:"ResizeBilinearGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s;Wk([a,r],"resizeBilinearGrad");const o=_(r.shape),[l,u,c,h]=r.shape,[,p,d]=a.shape,f=new Float32Array(l*u*c*h),m=[i&&p>1?u-1:u,i&&d>1?c-1:c],g=[i&&p>1?p-1:p,i&&d>1?d-1:d],y=m[0]/g[0],b=m[1]/g[1],x=n.data.get(a.dataId).values;let w=0;for(let e=0;e<l;e++){const t=e*o[0];for(let e=0;e<p;e++){const n=e*y,s=Math.floor(n),r=Math.min(Math.ceil(n),u-1),a=t+s*o[1],i=t+r*o[1],l=n-s,p=1-l;for(let e=0;e<d;e++){const t=e*b,n=Math.floor(t),s=Math.min(Math.ceil(t),c-1),r=t-n,u=1-r,d=a+n*o[2],m=a+s*o[2],g=i+n*o[2],y=i+s*o[2],k=p*u,v=p*r,N=l*u,I=l*r;for(let e=0;e<h;e++){const t=x[w++];f[d+e]+=t*k,f[m+e]+=t*v,f[g+e]+=t*N,f[y+e]+=t*I}}}}return n.makeTensorInfo([l,c,u,h],"float32",f)}};const UC={kernelName:"ResizeNearestNeighbor",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s;Wk(r,"resizeNearestNeighbor");const l=_(r.shape),[u,c]=o,[h,p,d,f]=r.shape,m=n.data.get(r.dataId).values,g=new Float32Array(h*u*c*f),y=[a&&u>1?p-1:p,a&&c>1?d-1:d],b=[a&&u>1?u-1:u,a&&c>1?c-1:c],x=y[0]/b[0],w=y[1]/b[1];let k=0;for(let e=0;e<h;e++){const t=e*l[0];for(let e=0;e<u;e++){const n=i?x*(e+.5):x*e;let s=Math.min(p-1,a?Math.round(n):Math.floor(n));i&&(s=Math.max(0,s));const r=t+s*l[1];for(let e=0;e<c;e++){const t=i?w*(e+.5):w*e;let n=Math.min(d-1,a?Math.round(t):Math.floor(t));i&&(n=Math.max(0,n));const s=r+n*l[2];for(let e=0;e<f;e++){const t=m[s+e];g[k++]=t}}}}return n.makeTensorInfo([h,u,c,f],r.dtype,g)}};const GC={kernelName:"ResizeNearestNeighborGrad",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s;Wk([a,r],"resizeNearestNeighborGrad");const o=_(r.shape),l=_(a.shape),[u,c,h,p]=r.shape,[,d,f]=a.shape,m=new Float32Array(u*c*h*p),g=n.data.get(a.dataId).values,y=[i&&d>1?c-1:c,i&&f>1?h-1:h],b=[i&&d>1?d-1:d,i&&f>1?f-1:f],x=y[0]/b[0],w=y[1]/b[1],k=1/x,v=1/w,N=2*Math.ceil(k)+2,I=2*Math.ceil(v)+2;for(let e=0;e<u;e++){const t=e*o[0];for(let e=0;e<c;e++){const n=t+e*o[1],s=Math.floor(e*k),r=Math.floor(s-N/2);for(let s=0;s<h;s++){const a=n+s*o[2],u=Math.floor(s*v),y=Math.floor(u-I/2);for(let n=0;n<p;n++){let o=0;for(let a=0;a<N;a++){const u=a+r;if(u<0||u>=d)continue;const p=t+u*l[1],m=u*x;if(e===Math.min(c-1,i?Math.round(m):Math.floor(m)))for(let e=0;e<I;e++){const t=e+y;if(t<0||t>=f)continue;const r=p+t*l[2],a=t*w;s===Math.min(h-1,i?Math.round(a):Math.floor(a))&&(o+=g[r+n])}}m[a+n]=o}}}}return n.makeTensorInfo(r.shape,r.dtype,m)}};const HC={kernelName:"Reverse",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dims:a}=s;Wk(r,"reverse");const i=r.shape.length,o=b(a,r.shape);if(0===i)return Yk({inputs:{x:r},backend:n});const l=new gs(r.shape,r.dtype),u=n.bufferSync(r);for(let e=0;e<l.size;e++){const t=l.indexToLoc(e),n=t.slice();o.forEach(e=>n[e]=r.shape[e]-1-n[e]),l.set(u.get(...n),...t)}return n.makeTensorInfo(l.shape,l.dtype,l.values)}},jC={kernelName:"RotateWithOffset",backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,{radians:r,fillValue:a,center:i}=t,o=n,l=w(s.dtype,h(s.shape)),[u,c,p,d]=s.shape,[f,m]=Bh(i,c,p),g=Math.sin(r),y=Math.cos(r),b=o.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=e*p*c*d;for(let e=0;e<c;e++){const n=e*(p*d);for(let s=0;s<p;s++){const r=s*d;for(let i=0;i<d;i++){const o=[u,e,s,i],h=o[2],x=o[1];let w=(h-f)*y-(x-m)*g,k=(h-f)*g+(x-m)*y;w=Math.round(w+f),k=Math.round(k+m);let v=a;if("number"!=typeof a&&(v=3===i?255:a[i]),w>=0&&w<p&&k>=0&&k<c){v=b[t+k*(p*d)+w*d+i]}l[t+n+r+i]=v}}}}return{dataId:o.write(l,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},qC={kernelName:"Round",backendName:"cpu",kernelFunc:hv("Round",e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1})};function KC(e,t,n,s,r,a,i,o,l,u){const c=[s/r,r],h=e.values,p=t.values;if(0===s)return Lr(n,t.dtype);const d=Lr(c,t.dtype);d.values.fill(l);for(let e=0;e<a;e++){const a=[];let l=0;for(let t=0;t<i;t++){const n=h[e*i+t];a.push(n),l+=n*o[t]}if(l<0||l>=s/r)throw new Error(`Invalid indices: ${a} does not index into ${n}`);for(let n=0;n<r;n++)u?d.values[l*r+n]+=p[e*r+n]:d.values[l*r+n]=0===t.rank?p[0]:p[e*r+n]}return d}const XC={kernelName:"ScatterNd",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r,updates:a}=t,{shape:i}=s,{sliceRank:o,numUpdates:l,sliceSize:u,strides:c,outputSize:h}=ma(0,r,i),p=KC(n.bufferSync(r),n.bufferSync(a),i,h,u,l,o,c,0,!0);return n.makeTensorInfo(i,p.dtype,p.values)}};const YC={kernelName:"Select",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{condition:s,t:r,e:a}=t;Wk([s,r,a],"select");const i=s.shape.length,o=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,u=n.data.get(a.dataId).values,c=$s(r.dtype,a.dtype),p=L(h(r.shape),c);let d=0;const f=0===i||i>1||1===r.shape.length?1:h(r.shape.slice(1));for(let e=0;e<o.length;e++)for(let t=0;t<f;t++)1===o[e]?p[d++]=l[e]:p[d++]=u[e];return n.makeTensorInfo(r.shape,c,p)}},JC={kernelName:"Selu",backendName:"cpu",kernelFunc:hv("Selu",e=>e>=0?1.0507009873554805*e:1.7580993408473768*(Math.exp(e)-1))},ZC={kernelName:"Sigmoid",backendName:"cpu",kernelFunc:hv("Sigmoid",e=>1/(1+Math.exp(-e)))},QC={kernelName:"Sign",backendName:"cpu",kernelFunc:hv("Sign",e=>e<0?-1:e>0?1:0)},eS=hv(mn,e=>Math.sin(e)),tS={kernelName:mn,backendName:"cpu",kernelFunc:eS},nS={kernelName:"Sinh",backendName:"cpu",kernelFunc:hv("Sinh",e=>Math.sinh(e))},sS=Math.log(1.1920928955078125e-7)+2,rS={kernelName:"Softplus",backendName:"cpu",kernelFunc:hv("Softplus",e=>{const t=e>-sS,n=e<sS,s=Math.exp(e);let r;return r=n?s:t?e:Math.log(1+s),r})};const aS={kernelName:"SpaceToBatchND",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,paddings:i}=s;Wk([r],"spaceToBatchND");const o=h(a),l=[[0,0]];l.push(...i);for(let e=1+a.length;e<r.shape.length;++e)l.push([0,0]);const u=OC.kernelFunc({inputs:{x:r},backend:n,attrs:{paddings:l,constantValue:0}}),c=Ph(u.shape,a,o,!1),p=Wh(c.length,a.length,!1),d=Vh(u.shape,a,o,!1),f=CN({inputs:{x:u},backend:n,attrs:{shape:c}}),m=jv({inputs:{x:f},backend:n,attrs:{perm:p}}),g=CN({inputs:{x:m},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}};const iS={kernelName:"SparseToDense",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{sparseIndices:r,sparseValues:a,defaultValue:i}=t,{outputShape:o}=s,{sliceRank:l,numUpdates:u,sliceSize:c,strides:h,outputSize:p}=ma(0,r,o),d=KC(n.bufferSync(r),n.bufferSync(a),o,p,c,u,l,h,n.data.get(i.dataId).values[0],!1);return n.makeTensorInfo(o,d.dtype,d.values)}};const oS={kernelName:"SplitV",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{numOrSizeSplits:a,axis:i}=s,o=b(i,r.shape)[0],l=tp(r,a,o),u=new Array(r.shape.length).fill(0),c=r.shape.slice();return l.map(e=>{const t=[...c];t[o]=e;const s=eN({inputs:{x:r},backend:n,attrs:{begin:u,size:t}});return u[o]+=e,s})}},lS={kernelName:"Sqrt",backendName:"cpu",kernelFunc:hv("Sqrt",e=>Math.sqrt(e))},uS={kernelName:"Square",backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:n}=e,s=t;Wk(n,"square");const r=s.data.get(n.dataId).values,a=new Float32Array(r.length);for(let e=0;e<r.length;++e){const t=r[e];a[e]=t*t}return{dataId:s.write(a,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},cS={kernelName:"Step",backendName:"cpu",kernelFunc:hv("Step",(e,t)=>{const n=t;return isNaN(e)?NaN:e>0?1:n.alpha})};const hS={kernelName:"StridedSlice",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,end:i,strides:o,beginMask:l,endMask:u,ellipsisMask:c,newAxisMask:h,shrinkAxisMask:p}=s;Wk(r,"stridedSlice");const{nonStrided:d,$begin:f,$strides:m,size:g,newShape:y,outShape:b}=Fa(r.shape,a,i,o,l,u,c,h,p),x=CN({inputs:{x:r},backend:n,attrs:{shape:y}});let w;if(d){const e=eN({inputs:{x:x},backend:n,attrs:{begin:f,size:g}});w=CN({inputs:{x:e},backend:n,attrs:{shape:b}}),n.disposeIntermediateTensorInfo(e)}else if(b.some(e=>0===e))w=n.makeTensorInfo(b,r.dtype,[]);else{const e=rN(b,n.bufferSync(x),m,f);w=n.makeTensorInfo(e.shape,e.dtype,e.values)}const k=CN({inputs:{x:w},backend:n,attrs:{shape:b}});return n.disposeIntermediateTensorInfo(x),n.disposeIntermediateTensorInfo(w),k}},pS=hv(An,e=>Math.tan(e)),dS={kernelName:An,backendName:"cpu",kernelFunc:pS},fS=hv("Tanh",e=>Math.tanh(e));const mS=[$N,Hk,AN,RN,ov,FN,DN,_N,ON,MN,LN,zN,BN,PN,WN,HN,jN,qN,KN,EN,XN,YN,JN,tv,fv,ZN,Kk,QN,sI,iI,oI,aI,uI,cI,lI,pI,dI,fI,mI,gI,yI,xI,wI,kI,vI,NI,CI,II,_I,fN,SI,EI,AI,bv,FI,wv,LI,BI,PI,vv,WI,VI,UI,GI,HI,Cv,jI,Jk,qI,tI,KI,XI,YI,gN,Tv,JI,ZI,Rv,QI,eC,tC,nC,sC,rC,_v,oC,lC,uC,cC,hC,iC,fC,mC,Mv,gC,xC,vC,Pv,Vv,IC,SC,EC,Gv,$C,FC,_C,OC,zC,xN,Xv,BC,Qk,PC,kN,NN,SN,WC,VC,UC,GC,HC,jC,qC,Zv,XC,YC,JC,ZC,QC,tS,nS,tN,kC,rS,aS,iS,oS,lS,uS,sN,cS,hS,lN,dC,dS,{kernelName:"Tanh",backendName:"cpu",kernelFunc:fS},{kernelName:"Tile",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reps:a}=s;Wk(r,"tile");const i=uN(n.bufferSync(r),a);return n.makeTensorInfo(i.shape,i.dtype,i.values)}},{kernelName:"TopK",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{k:a,sorted:i}=s;Wk(r,"topk");const o=n.data.get(r.dataId).values,[l,u]=cN(o,r.shape,r.dtype,a);return[n.makeTensorInfo(l.shape,l.dtype,l.values),n.makeTensorInfo(u.shape,u.dtype,u.values)]}},qv,{kernelName:"Unique",backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{axis:r}=n,{x:a}=t;Wk(a,"unique");const i=s.data.get(a.dataId).values,{outputValues:o,outputShape:l,indices:u}=hN(i,r,a.shape,a.dtype);return[s.makeTensorInfo(l,a.dtype,o),s.makeTensorInfo([u.length],"int32",u)]}},{kernelName:"Unpack",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{value:r}=t;let{axis:a}=s;a<0&&(a+=r.shape.length);const i=r.shape.length,o=r.shape[a],l=new Array(i-1);let u=0;for(let e=0;e<i;e++)e!==a&&(l[u++]=r.shape[e]);const c=new Array(i).fill(0),h=r.shape.slice();h[a]=1;const p=new Array(o);for(let e=0;e<p.length;e++){c[a]=e;const t=eN({inputs:{x:r},backend:n,attrs:{begin:c,size:h}});p[e]=CN({inputs:{x:t},backend:n,attrs:{shape:l}}),n.disposeIntermediateTensorInfo(t)}return p}},{kernelName:"UnsortedSegmentSum",backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,segmentIds:a}=t,{numSegments:i}=s;Wk(r,"unsortedSegmentSum");const o=[],l=[],u=r.shape.length-a.shape.length;let c=a;for(let e=0;e<u;++e){const t=RI({inputs:{input:c},backend:n,attrs:{dim:e+1}});c=t,l.push(t)}for(let e=0;e<i;++e){const t=ns(e,"int32"),s=n.makeTensorInfo([],"int32",t),a=TI({inputs:{a:s,b:c},backend:n}),i=ev({inputs:{x:a},backend:n,attrs:{dtype:"float32"}}),u=Bv({inputs:{a:i,b:r},backend:n}),h=pC({inputs:{x:u},backend:n,attrs:{axis:0,keepDims:!1}});o.push(h),l.push(s),l.push(a),l.push(i),l.push(u),l.push(h)}const h=DC({inputs:o,backend:n,attrs:{axis:0}});return l.forEach(e=>n.disposeIntermediateTensorInfo(e)),h}},RC];for(const e of mS)Yn(e);const gS={},yS={alpha:!1,antialias:!1,premultipliedAlpha:!1,preserveDrawingBuffer:!1,depth:!1,stencil:!1,failIfMajorPerformanceCaveat:!0};function bS(e){if(!(e in gS)){const t=function(e){if(1!==e&&2!==e)throw new Error("Cannot get WebGL rendering context, WebGL is disabled.");const t=function(e){if("undefined"!=typeof OffscreenCanvas&&2===e)return new OffscreenCanvas(300,150);if("undefined"!=typeof document)return document.createElement("canvas");throw new Error("Cannot create a canvas in this context")}(e);if(t.addEventListener("webglcontextlost",t=>{t.preventDefault(),delete gS[e]},!1),1===e)return t.getContext("webgl",yS)||t.getContext("experimental-webgl",yS);return t.getContext("webgl2",yS)}(e);if(null===t)return console.log("Could not get context for WebGL version",e),null;gS[e]=t}const t=gS[e];return t.isContextLost()?(delete gS[e],bS(e)):(t.disable(t.DEPTH_TEST),t.disable(t.STENCIL_TEST),t.disable(t.BLEND),t.disable(t.DITHER),t.disable(t.POLYGON_OFFSET_FILL),t.disable(t.SAMPLE_COVERAGE),t.enable(t.SCISSOR_TEST),t.enable(t.CULL_FACE),t.cullFace(t.BACK),gS[e])}var xS,wS,kS;function vS(e,t){return[t,e]}function NS(e){const t=h(e);return f(Math.ceil(t/4))}function IS(e,t){return[Math.max(1,Math.ceil(t/2)),Math.max(1,Math.ceil(e/2))]}function CS(e,t){const n=e;let s,r,a,i,o,l,u,c,h,p;return 2===G().getNumber("WEBGL_VERSION")?(s=n.R32F,r=n.R16F,a=n.RGBA16F,i=n.RGBA32F,o=n.RED,u=4,c=1,h=n.HALF_FLOAT,p=n.FLOAT):(s=e.RGBA,r=e.RGBA,a=e.RGBA,i=n.RGBA,o=e.RGBA,u=4,c=4,h=null!=t?t.HALF_FLOAT_OES:null,p=e.FLOAT),l=e.RGBA,{internalFormatFloat:s,internalFormatHalfFloat:r,internalFormatPackedHalfFloat:a,internalFormatPackedFloat:i,textureFormatFloat:o,downloadTextureFormat:l,downloadUnpackNumChannels:u,defaultNumChannels:c,textureTypeHalfFloat:h,textureTypeFloat:p}}function SS(e,t){const n=t();return G().getBool("DEBUG")&&function(e){const t=e.getError();if(t!==e.NO_ERROR)throw new Error("WebGL Error: "+function(e,t){switch(t){case e.NO_ERROR:return"NO_ERROR";case e.INVALID_ENUM:return"INVALID_ENUM";case e.INVALID_VALUE:return"INVALID_VALUE";case e.INVALID_OPERATION:return"INVALID_OPERATION";case e.INVALID_FRAMEBUFFER_OPERATION:return"INVALID_FRAMEBUFFER_OPERATION";case e.OUT_OF_MEMORY:return"OUT_OF_MEMORY";case e.CONTEXT_LOST_WEBGL:return"CONTEXT_LOST_WEBGL";default:return"Unknown error code "+t}}(e,t))}(e),n}!function(e){e[e.DENSE=0]="DENSE",e[e.SHARED_BATCH=1]="SHARED_BATCH"}(xS||(xS={})),function(e){e[e.RENDER=0]="RENDER",e[e.UPLOAD=1]="UPLOAD",e[e.PIXELS=2]="PIXELS",e[e.DOWNLOAD=3]="DOWNLOAD"}(wS||(wS={})),function(e){e[e.UNPACKED_FLOAT16=0]="UNPACKED_FLOAT16",e[e.UNPACKED_FLOAT32=1]="UNPACKED_FLOAT32",e[e.PACKED_4X1_UNSIGNED_BYTE=2]="PACKED_4X1_UNSIGNED_BYTE",e[e.PACKED_2X2_FLOAT32=3]="PACKED_2X2_FLOAT32",e[e.PACKED_2X2_FLOAT16=4]="PACKED_2X2_FLOAT16"}(kS||(kS={}));function TS(e){return!!(G().getBool("WEBGL_RENDER_FLOAT32_ENABLED")||0===e||5.96e-8<Math.abs(e)&&Math.abs(e)<65504)}function ES(e,t){return LS(e,()=>e.getExtension(t),'Extension "'+t+'" not supported on this browser.')}function $S(e,t){const n=LS(e,()=>e.createShader(e.FRAGMENT_SHADER),"Unable to create fragment WebGLShader.");if(SS(e,()=>e.shaderSource(n,t)),SS(e,()=>e.compileShader(n)),!1===e.getShaderParameter(n,e.COMPILE_STATUS))throw function(e,t){const n=AS.exec(t);if(null==n)return console.log("Couldn't parse line number in error: "+t),void console.log(e);const s=+n[1],r=e.split("\n"),a=r.length.toString().length+2,i=r.map((e,t)=>m((t+1).toString(),a)+e);let o=0;for(let e=0;e<i.length;e++)o=Math.max(i[e].length,o);const l=i.slice(0,s-1),u=i.slice(s-1,s),c=i.slice(s);console.log(l.join("\n")),console.log(t.split("\n")[0]),console.log("%c "+m(u[0],o),"border:1px solid red; background-color:#e3d2d2; color:#a61717"),console.log(c.join("\n"))}(t,e.getShaderInfoLog(n)),new Error("Failed to compile fragment shader.");return n}const AS=/ERROR: [0-9]+:([0-9]+):/g;function RS(e,t){if(SS(e,()=>e.validateProgram(t)),!1===e.getProgramParameter(t,e.VALIDATE_STATUS))throw console.log(e.getProgramInfoLog(t)),new Error("Shader program validation failed.")}function FS(e,t,n,s,r,a,i){const o=e.getAttribLocation(t,n);return-1!==o&&(SS(e,()=>e.bindBuffer(e.ARRAY_BUFFER,s)),SS(e,()=>e.vertexAttribPointer(o,r,e.FLOAT,!1,a,i)),SS(e,()=>e.enableVertexAttribArray(o)),!0)}function DS(e,t,n,s){SS(e,()=>function(e,t,n){zS(e,n),SS(e,()=>e.activeTexture(e.TEXTURE0+n)),SS(e,()=>e.bindTexture(e.TEXTURE_2D,t))}(e,t,s)),SS(e,()=>e.uniform1i(n,s))}function _S(e,t,n){SS(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,n)),SS(e,()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0))}function OS(e,t){SS(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,t)),SS(e,()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,null,0))}function MS(e){const t=e.checkFramebufferStatus(e.FRAMEBUFFER);if(t!==e.FRAMEBUFFER_COMPLETE)throw new Error("Error binding framebuffer: "+function(e,t){switch(t){case e.FRAMEBUFFER_INCOMPLETE_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_DIMENSIONS:return"FRAMEBUFFER_INCOMPLETE_DIMENSIONS";case e.FRAMEBUFFER_UNSUPPORTED:return"FRAMEBUFFER_UNSUPPORTED";default:return"unknown error "+t}}(e,t))}function LS(e,t,n){const s=SS(e,()=>t());if(null==s)throw new Error(n);return s}function zS(e,t){const n=e.MAX_COMBINED_TEXTURE_IMAGE_UNITS-1,s=t+e.TEXTURE0;if(s<e.TEXTURE0||s>n){throw new Error(`textureUnit must be in ${`[gl.TEXTURE0, gl.TEXTURE${n}]`}.`)}}function BS(e,t=2){return h(e.slice(0,e.length-t))}function PS(e){if(0===e.length)throw Error("Cannot get rows and columns of an empty shape array.");return[e.length>1?e[e.length-2]:1,e[e.length-1]]}function WS(e){let t=[1,1,1];return 0===e.length||1===e.length&&1===e[0]||(t=[BS(e),...PS(e)]),t}function VS(e){return e%2==0}function US(e,t){if(p(e=e.slice(-2),t=t.slice(-2)))return!0;if(!e.length||!t.length)return!0;if(0===e[0]||0===e[1]||0===t[0]||0===t[1])return!0;if(e.length!==t.length){const n=e.slice(-1)[0],s=t.slice(-1)[0];if(n===s)return!0;if(VS(n)&&VS(s)&&(1===e[0]||1===t[0]))return!0}return e[1]===t[1]&&VS(e[0])&&VS(t[0])}let GS,HS;function jS(e,t){return null!=e.getExtension(t)}function qS(e){try{if(null!=bS(e))return!0}catch(e){return console.log("Error when getting WebGL context: ",e),!1}return!1}function KS(e){if(0===e)return!1;const t=bS(e);if(1!==e){if(jS(t,"EXT_color_buffer_float"))return XS(t);const e="EXT_color_buffer_half_float";if(jS(t,e)){const n=t.getExtension(e);return function(e,t){const n=CS(e,t),s=e.createTexture();e.bindTexture(e.TEXTURE_2D,s);e.texImage2D(e.TEXTURE_2D,0,n.internalFormatHalfFloat,1,1,0,n.textureFormatFloat,n.textureTypeHalfFloat,null);const r=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,r),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,s,0);const a=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(s),e.deleteFramebuffer(r),a}(t,n)}return!1}return!!jS(t,"OES_texture_float")&&(!!jS(t,"WEBGL_color_buffer_float")&&XS(t))}function XS(e){const t=CS(e),n=e.createTexture();e.bindTexture(e.TEXTURE_2D,n);e.texImage2D(e.TEXTURE_2D,0,t.internalFormatFloat,1,1,0,t.textureFormatFloat,t.textureTypeFloat,null);const s=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,s),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,n,0);const r=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(n),e.deleteFramebuffer(s),r}function YS(e,t){Array.isArray(e)||(e=[e]),e.forEach(e=>{null!=e&&o("complex64"!==e.dtype,()=>t+" does not support complex64 tensors in the WebGL backend.")})}const JS=G();function ZS(){let e,t,n,s,r,a,i,o,l,u;return 2===G().getNumber("WEBGL_VERSION")?(e="#version 300 es",t="in",n="out",s="in",r="texture",a="outputColor",i="out vec4 outputColor;",o="\n      bool isnan_custom(float val) {\n        return (val > 0.0 || val < 0.0) ? false : val != 0.0;\n      }\n\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan_custom(val.x),\n          isnan_custom(val.y), isnan_custom(val.z), isnan_custom(val.w));\n      }\n\n      #define isnan(value) isnan_custom(value)\n    ",l="",u="\n      #define round(value) newRound(value)\n      int newRound(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 newRound(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "):(e="",t="attribute",n="varying",s="varying",r="texture2D",a="gl_FragColor",i="",o="\n      #define isnan(value) isnan_custom(value)\n      bool isnan_custom(float val) {\n        return (val > 0. || val < 1. || val == 0.) ? false : true;\n      }\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan(val.x), isnan(val.y), isnan(val.z), isnan(val.w));\n      }\n    ",l="\n      uniform float INFINITY;\n\n      bool isinf(float val) {\n        return abs(val) == INFINITY;\n      }\n      bvec4 isinf(vec4 val) {\n        return equal(abs(val), vec4(INFINITY));\n      }\n    ",u="\n      int round(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 round(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "),{version:e,attribute:t,varyingVs:n,varyingFs:s,texture2D:r,output:a,defineOutput:i,defineSpecialNaN:o,defineSpecialInf:l,defineRound:u}}function QS(e,t,n="index"){const s=_(t);return s.map((t,r)=>`${`int ${e[r]} = ${n} / ${t}`}; ${r===s.length-1?`int ${e[r+1]} = ${n} - ${e[r]} * ${t}`:`index -= ${e[r]} * ${t}`};`).join("")}function eT(e){const t=_(e).map(e=>e.toString());return`\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * ${t[0]} + coords.y * ${t[1]} + coords.z;\n  }\n`}JS.registerFlag("HAS_WEBGL",()=>JS.getNumber("WEBGL_VERSION")>0),JS.registerFlag("WEBGL_VERSION",()=>qS(2)?2:qS(1)?1:0),JS.registerFlag("WEBGL_CHECK_NUMERICAL_PROBLEMS",()=>!1),JS.registerFlag("WEBGL_BUFFER_SUPPORTED",()=>2===JS.get("WEBGL_VERSION")),JS.registerFlag("WEBGL_CPU_FORWARD",()=>!0),JS.registerFlag("WEBGL_FORCE_F16_TEXTURES",()=>!1),JS.registerFlag("WEBGL_PACK",()=>JS.getBool("HAS_WEBGL")),JS.registerFlag("WEBGL_PACK_NORMALIZATION",()=>JS.getBool("WEBGL_PACK")),JS.registerFlag("WEBGL_PACK_CLIP",()=>JS.getBool("WEBGL_PACK")),JS.registerFlag("WEBGL_PACK_DEPTHWISECONV",()=>!1),JS.registerFlag("WEBGL_PACK_BINARY_OPERATIONS",()=>JS.getBool("WEBGL_PACK")),JS.registerFlag("WEBGL_PACK_UNARY_OPERATIONS",()=>JS.getBool("WEBGL_PACK")),JS.registerFlag("WEBGL_PACK_ARRAY_OPERATIONS",()=>JS.getBool("WEBGL_PACK")),JS.registerFlag("WEBGL_PACK_IMAGE_OPERATIONS",()=>JS.getBool("WEBGL_PACK")),JS.registerFlag("WEBGL_PACK_REDUCE",()=>JS.getBool("WEBGL_PACK")),JS.registerFlag("WEBGL_LAZILY_UNPACK",()=>JS.getBool("WEBGL_PACK")),JS.registerFlag("WEBGL_CONV_IM2COL",()=>JS.getBool("WEBGL_PACK")),JS.registerFlag("WEBGL_MAX_TEXTURE_SIZE",()=>function(e){if(null==GS){const t=bS(e);GS=t.getParameter(t.MAX_TEXTURE_SIZE)}return GS}(JS.getNumber("WEBGL_VERSION"))),JS.registerFlag("WEBGL_MAX_TEXTURES_IN_SHADER",()=>function(e){if(null==HS){const t=bS(e);HS=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS)}return Math.min(16,HS)}(JS.getNumber("WEBGL_VERSION"))),JS.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION",()=>{const e=JS.getNumber("WEBGL_VERSION");return 0===e?0:function(e){if(0===e)return 0;let t;const n=bS(e);return t=jS(n,"EXT_disjoint_timer_query_webgl2")&&2===e?2:jS(n,"EXT_disjoint_timer_query")?1:0,t}(e)}),JS.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE",()=>JS.getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0&&!Vs()),JS.registerFlag("WEBGL_RENDER_FLOAT32_CAPABLE",()=>function(e){if(0===e)return!1;const t=bS(e);if(1===e){if(!jS(t,"OES_texture_float"))return!1}else if(!jS(t,"EXT_color_buffer_float"))return!1;return XS(t)}(JS.getNumber("WEBGL_VERSION"))),JS.registerFlag("WEBGL_RENDER_FLOAT32_ENABLED",()=>!JS.getBool("WEBGL_FORCE_F16_TEXTURES")&&JS.getBool("WEBGL_RENDER_FLOAT32_CAPABLE")),JS.registerFlag("WEBGL_DOWNLOAD_FLOAT_ENABLED",()=>KS(JS.getNumber("WEBGL_VERSION"))),JS.registerFlag("WEBGL_FENCE_API_ENABLED",()=>{return 2===(e=JS.getNumber("WEBGL_VERSION"))&&null!=bS(e).fenceSync;var e}),JS.registerFlag("WEBGL_SIZE_UPLOAD_UNIFORM",()=>JS.getBool("WEBGL_RENDER_FLOAT32_ENABLED")?4:0),JS.registerFlag("WEBGL_DELETE_TEXTURE_THRESHOLD",()=>-1,e=>{if(e<0&&-1!==e)throw new Error(`WEBGL_DELETE_TEXTURE_THRESHOLD must be -1 (indicating never delete) or at least 0, but got ${e}.`)}),JS.registerFlag("WEBGL_FLUSH_THRESHOLD",()=>-1,e=>{if(e<0&&-1!==e)throw new Error(`WEBGL_FLUSH_THRESHOLD must be -1 (indicating never manual flush) or at least 0, but got ${e}.`)});const tT="\n  const float FLOAT_MAX = 1.70141184e38;\n  const float FLOAT_MIN = 1.17549435e-38;\n\n  lowp vec4 encode_float(highp float v) {\n    if (isnan(v)) {\n      return vec4(255, 255, 255, 255);\n    }\n\n    highp float av = abs(v);\n\n    if(av < FLOAT_MIN) {\n      return vec4(0.0, 0.0, 0.0, 0.0);\n    } else if(v > FLOAT_MAX) {\n      return vec4(0.0, 0.0, 128.0, 127.0) / 255.0;\n    } else if(v < -FLOAT_MAX) {\n      return vec4(0.0, 0.0,  128.0, 255.0) / 255.0;\n    }\n\n    highp vec4 c = vec4(0,0,0,0);\n\n    highp float e = floor(log2(av));\n    highp float m = exp2(fract(log2(av))) - 1.0;\n\n    c[2] = floor(128.0 * m);\n    m -= c[2] / 128.0;\n    c[1] = floor(32768.0 * m);\n    m -= c[1] / 32768.0;\n    c[0] = floor(8388608.0 * m);\n\n    highp float ebias = e + 127.0;\n    c[3] = floor(ebias / 2.0);\n    ebias -= c[3] * 2.0;\n    c[2] += floor(ebias) * 128.0;\n\n    c[3] += 128.0 * step(0.0, -v);\n\n    return c / 255.0;\n  }\n";class nT{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outPackingScheme=xS.DENSE;const t=NS(e),n=ZS();this.outputShape=e,this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${QS(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n          vec2(${t[0]}, ${t[1]}));\n        int index = 4 * (resTexRC.x * ${t[1]} + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getA(rc.x, rc.y, rc.z);\n        }\n\n        ${n.output} = result;\n      }\n    `}}class sT{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outPackingScheme=xS.DENSE;const t=NS(e),n=ZS();this.outputShape=e,this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${QS(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n          vec2(${t[0]}, ${t[1]}));\n        int index = 4 * (resTexRC.x * ${t[1]} + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getChannel(getA(rc.x, rc.y, rc.z), vec2(rc.y, rc.z));\n        }\n\n        ${n.output} = result;\n      }\n    `}}class rT{constructor(e){this.variableNames=["A"],this.outTexUsage=wS.DOWNLOAD;const t=ZS();this.outputShape=e,this.userCode=`\n      ${tT}\n\n      void main() {\n        float x = getAAtOutCoords();\n        ${t.output} = encode_float(x);\n      }\n    `}}class aT{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outTexUsage=wS.DOWNLOAD;const t=ZS();this.outputShape=e,this.userCode=`\n      ${tT}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n        float x = getChannel(getAAtOutCoords(), vec2(coords.y, coords.z));\n        ${t.output} = encode_float(x);\n      }\n    `}}class iT{constructor(e,t,n=!1){this.variableNames=["A"];const s=ZS(),[r,a]=t;this.outputShape=e;let i="result";n&&(i="floor(result * 255. + 0.5)"),this.userCode=`\n      ${eT(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        int flatIndex = getFlatIndex(coords);\n        int offset = imod(flatIndex, 4);\n\n        flatIndex = idiv(flatIndex, 4, 1.);\n\n        int r = flatIndex / ${a};\n        int c = imod(flatIndex, ${a});\n        vec2 uv = (vec2(c, r) + halfCR) / vec2(${a}.0, ${r}.0);\n        vec4 values = ${s.texture2D}(A, uv);\n\n        float result;\n\n        if(offset == 0) {\n          result = values[0];\n        } else if(offset == 1) {\n          result = values[1];\n        } else if(offset == 2) {\n          result = values[2];\n        } else {\n          result = values[3];\n        }\n\n        ${s.output} = vec4(${i}, 0., 0., 0.);\n      }\n    `}}class oT{constructor(e,t,n=!1){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const s=ZS(),[r,a]=t;this.outputShape=e;let i="",o="result";n&&(o="floor(result * 255. + 0.5)");for(let t=0;t<=1;t++)for(let n=0;n<=1;n++){const o=2*t+n;i+=`\n          localCoords = coords;\n          if(localCoords[2] + ${n} < ${e[2]}) {\n            localCoords[2] += ${n};\n            if(localCoords[1] + ${t} < ${e[1]}) {\n              localCoords[1] += ${t};\n\n              flatIndex = getFlatIndex(localCoords);\n              offset = imod(flatIndex, 4);\n\n              flatIndex = idiv(flatIndex, 4, 1.);\n\n              r = flatIndex / ${a};\n              c = imod(flatIndex, ${a});\n              uv = (vec2(c, r) + halfCR) / vec2(${a}.0, ${r}.0);\n              values = ${s.texture2D}(A, uv);\n\n              if(offset == 0) {\n                result[${o}] = values[0];\n              } else if(offset == 1) {\n                result[${o}] = values[1];\n              } else if(offset == 2) {\n                result[${o}] = values[2];\n              } else {\n                result[${o}] = values[3];\n              }\n            }\n          }\n        `}this.userCode=`\n      ${eT(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        vec4 result = vec4(0.);\n        int flatIndex, r, c, offset;\n        ivec3 localCoords;\n        vec2 uv;\n        vec4 values;\n\n        ${i}\n\n        ${s.output} = ${o};\n      }\n    `}}function lT(e){const t=ZS();return function(e,t){const n=LS(e,()=>e.createShader(e.VERTEX_SHADER),"Unable to create vertex WebGLShader.");if(SS(e,()=>e.shaderSource(n,t)),SS(e,()=>e.compileShader(n)),!1===e.getShaderParameter(n,e.COMPILE_STATUS))throw console.log(e.getShaderInfoLog(n)),new Error("Failed to compile vertex shader.");return n}(e,`${t.version}\n    precision highp float;\n    ${t.attribute} vec3 clipSpacePos;\n    ${t.attribute} vec2 uv;\n    ${t.varyingVs} vec2 resultUV;\n\n    void main() {\n      gl_Position = vec4(clipSpacePos, 1);\n      resultUV = uv;\n    }`)}function uT(e){return function(e,t){const n=LS(e,()=>e.createBuffer(),"Unable to create WebGLBuffer");return SS(e,()=>e.bindBuffer(e.ARRAY_BUFFER,n)),SS(e,()=>e.bufferData(e.ARRAY_BUFFER,t,e.STATIC_DRAW)),n}(e,new Float32Array([-1,1,0,0,1,-1,-1,0,0,0,1,1,0,1,1,1,-1,0,1,0]))}function cT(e){return function(e,t){const n=LS(e,()=>e.createBuffer(),"Unable to create WebGLBuffer");return SS(e,()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,n)),SS(e,()=>e.bufferData(e.ELEMENT_ARRAY_BUFFER,t,e.STATIC_DRAW)),n}(e,new Uint16Array([0,1,2,2,1,3]))}function hT(e,t,n,s,r,a){!function(e,t){const n=G().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(e<=0||t<=0){throw new Error("Requested texture size "+`[${e}x${t}]`+" is invalid.")}if(e>n||t>n){throw new Error("Requested texture size "+`[${e}x${t}]`+" greater than WebGL maximum on this browser / GPU "+`[${n}x${n}]`+".")}}(t,n);const i=function(e){return LS(e,()=>e.createTexture(),"Unable to create WebGLTexture.")}(e),o=e.TEXTURE_2D;return SS(e,()=>e.bindTexture(o,i)),SS(e,()=>e.texParameteri(o,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE)),SS(e,()=>e.texParameteri(o,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE)),SS(e,()=>e.texParameteri(o,e.TEXTURE_MIN_FILTER,e.NEAREST)),SS(e,()=>e.texParameteri(o,e.TEXTURE_MAG_FILTER,e.NEAREST)),SS(e,()=>e.texImage2D(o,0,s,t,n,0,r,a,null)),SS(e,()=>e.bindTexture(e.TEXTURE_2D,null)),i}function pT(e){return e.internalFormatFloat}function dT(e){return e.internalFormatHalfFloat}function fT(e){return e.downloadTextureFormat}function mT(e){return e.internalFormatPackedFloat}function gT(e){return e.internalFormatPackedHalfFloat}function yT(e,t,n,s,r,a,i,o){const l=e,u=new Float32Array(function(e,t){const[n,s]=IS(e,t);return n*s*4}(a,i));return l.bindBuffer(l.PIXEL_PACK_BUFFER,t),l.getBufferSubData(l.PIXEL_PACK_BUFFER,0,u),l.bindBuffer(l.PIXEL_PACK_BUFFER,null),u}class bT{constructor(e){this.outputTexture=null,this.program=null,this.disposed=!1,this.vertexAttrsAreBound=!1,this.itemsToPoll=[];const t=G().getNumber("WEBGL_VERSION");null!=e?(this.gl=e,function(e,t){gS[e]=t}(t,e)):this.gl=bS(t);let n="WEBGL_color_buffer_float";if(1===G().getNumber("WEBGL_VERSION")){const e="OES_texture_float",t="OES_texture_half_float";if(this.textureFloatExtension=ES(this.gl,e),jS(this.gl,t))this.textureHalfFloatExtension=ES(this.gl,t);else if(G().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support half float textures, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.");if(this.colorBufferFloatExtension=this.gl.getExtension(n),jS(this.gl,"EXT_color_buffer_half_float"))this.colorBufferHalfFloatExtension=ES(this.gl,"EXT_color_buffer_half_float");else if(G().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support color renderable half floats, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.")}else if(n="EXT_color_buffer_float",jS(this.gl,n))this.colorBufferFloatExtension=this.gl.getExtension(n);else{if(!jS(this.gl,"EXT_color_buffer_half_float"))throw new Error("GL context does not support color renderable floats");this.colorBufferHalfFloatExtension=this.gl.getExtension("EXT_color_buffer_half_float")}this.vertexBuffer=uT(this.gl),this.indexBuffer=cT(this.gl),this.framebuffer=function(e){return LS(e,()=>e.createFramebuffer(),"Unable to create WebGLFramebuffer.")}(this.gl),this.textureConfig=CS(this.gl,this.textureHalfFloatExtension)}get debug(){return G().getBool("DEBUG")}dispose(){if(this.disposed)return;null!=this.program&&console.warn("Disposing a GPGPUContext that still has a bound WebGLProgram. This is probably a resource leak, delete the program with GPGPUContext.deleteProgram before disposing."),null!=this.outputTexture&&console.warn("Disposing a GPGPUContext that still has a bound output matrix texture.  This is probably a resource leak, delete the output matrix texture with GPGPUContext.deleteMatrixTexture before disposing.");const e=this.gl;SS(e,()=>e.finish()),SS(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,null)),SS(e,()=>e.deleteFramebuffer(this.framebuffer)),SS(e,()=>e.bindBuffer(e.ARRAY_BUFFER,null)),SS(e,()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,null)),SS(e,()=>e.deleteBuffer(this.indexBuffer)),this.disposed=!0}createFloat32MatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=vS(t,n);return hT(e,r,a,pT(s),s.textureFormatFloat,e.FLOAT)}(this.gl,e,t,this.textureConfig)}createFloat16MatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=vS(t,n);return hT(e,r,a,dT(s),s.textureFormatFloat,s.textureTypeHalfFloat)}(this.gl,e,t,this.textureConfig)}createUnsignedBytesMatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=vS(t,n);return hT(e,r,a,fT(s),e.RGBA,e.UNSIGNED_BYTE)}(this.gl,e,t,this.textureConfig)}uploadPixelDataToTexture(e,t){this.throwIfDisposed(),function(e,t,n){SS(e,()=>e.bindTexture(e.TEXTURE_2D,t)),n.data instanceof Uint8Array?SS(e,()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,n.width,n.height,0,e.RGBA,e.UNSIGNED_BYTE,n.data)):SS(e,()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,n)),SS(e,()=>e.bindTexture(e.TEXTURE_2D,null))}(this.gl,e,t)}uploadDenseMatrixToTexture(e,t,n,s){this.throwIfDisposed(),function(e,t,n,s,r,a){let i,o,l;SS(e,()=>e.bindTexture(e.TEXTURE_2D,t)),r instanceof Uint8Array?(i=new Uint8Array(n*s*4),o=e.UNSIGNED_BYTE,l=e.RGBA):(i=new Float32Array(n*s*4),o=e.FLOAT,l=a.internalFormatPackedFloat),i.set(r),SS(e,()=>e.texImage2D(e.TEXTURE_2D,0,l,n,s,0,e.RGBA,o,i)),SS(e,()=>e.bindTexture(e.TEXTURE_2D,null))}(this.gl,e,t,n,s,this.textureConfig)}createFloat16PackedMatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=IS(t,n);return hT(e,r,a,gT(s),e.RGBA,s.textureTypeHalfFloat)}(this.gl,e,t,this.textureConfig)}createPackedMatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=IS(t,n);return hT(e,r,a,mT(s),e.RGBA,e.FLOAT)}(this.gl,e,t,this.textureConfig)}deleteMatrixTexture(e){this.throwIfDisposed(),this.outputTexture===e&&(OS(this.gl,this.framebuffer),this.outputTexture=null),SS(this.gl,()=>this.gl.deleteTexture(e))}downloadByteEncodedFloatMatrixFromOutputTexture(e,t,n){return this.downloadMatrixDriver(e,()=>function(e,t,n,s){const[r,a]=vS(t,n),i=new Uint8Array(t*n*4);return SS(e,()=>e.readPixels(0,0,r,a,s.downloadTextureFormat,e.UNSIGNED_BYTE,i)),new Float32Array(i.buffer)}(this.gl,t,n,this.textureConfig))}downloadPackedMatrixFromBuffer(e,t,n,s,r,a){return yT(this.gl,e,0,0,0,r,a,this.textureConfig)}downloadFloat32MatrixFromBuffer(e,t){return function(e,t,n){const s=e,r=new Float32Array(n);return s.bindBuffer(s.PIXEL_PACK_BUFFER,t),s.getBufferSubData(s.PIXEL_PACK_BUFFER,0,r),s.bindBuffer(s.PIXEL_PACK_BUFFER,null),r}(this.gl,e,t)}createBufferFromTexture(e,t,n){this.bindTextureToFrameBuffer(e);const s=function(e,t,n,s){const r=e.createBuffer();SS(e,()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,r));const a=16*t*n;return SS(e,()=>e.bufferData(e.PIXEL_PACK_BUFFER,a,e.STREAM_READ)),SS(e,()=>e.readPixels(0,0,n,t,e.RGBA,e.FLOAT,0)),SS(e,()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,null)),r}(this.gl,t,n,this.textureConfig);return this.unbindTextureToFrameBuffer(),s}createAndWaitForFence(){const e=this.createFence(this.gl);return this.pollFence(e)}createFence(e){let t,n;if(G().getBool("WEBGL_FENCE_API_ENABLED")){const s=e,r=s.fenceSync(s.SYNC_GPU_COMMANDS_COMPLETE,0);e.flush(),n=()=>{const e=s.clientWaitSync(r,0,0);return e===s.ALREADY_SIGNALED||e===s.CONDITION_SATISFIED},t=r}else G().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0?(t=this.beginQuery(),this.endQuery(),n=()=>this.isQueryAvailable(t,G().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))):n=()=>!0;return{query:t,isFencePassed:n}}downloadMatrixFromPackedTexture(e,t,n){return this.downloadMatrixDriver(e,()=>function(e,t,n){const s=new Float32Array(t*n*4);return SS(e,()=>e.readPixels(0,0,n,t,e.RGBA,e.FLOAT,s)),s}(this.gl,t,n))}createProgram(e){this.throwIfDisposed();const t=this.gl,n=$S(t,e),s=lT(t),r=function(e){return LS(e,()=>e.createProgram(),"Unable to create WebGLProgram.")}(t);return SS(t,()=>t.attachShader(r,s)),SS(t,()=>t.attachShader(r,n)),function(e,t){if(SS(e,()=>e.linkProgram(t)),!1===e.getProgramParameter(t,e.LINK_STATUS))throw console.log(e.getProgramInfoLog(t)),new Error("Failed to link vertex and fragment shaders.")}(t,r),this.debug&&RS(t,r),this.vertexAttrsAreBound||(this.setProgram(r),this.vertexAttrsAreBound=function(e,t,n){return SS(e,()=>e.bindBuffer(e.ARRAY_BUFFER,n)),FS(e,t,"clipSpacePos",n,3,20,0)&&FS(e,t,"uv",n,2,20,12)}(t,this.program,this.vertexBuffer)),r}deleteProgram(e){this.throwIfDisposed(),e===this.program&&(this.program=null),null!=e&&SS(this.gl,()=>this.gl.deleteProgram(e))}setProgram(e){this.throwIfDisposed(),this.program=e,null!=this.program&&this.debug&&RS(this.gl,this.program),SS(this.gl,()=>this.gl.useProgram(e))}getUniformLocation(e,t,n=!0){return this.throwIfDisposed(),n?function(e,t,n){return LS(e,()=>e.getUniformLocation(t,n),'uniform "'+n+'" not present in program.')}(this.gl,e,t):function(e,t,n){return e.getUniformLocation(t,n)}(this.gl,e,t)}getAttributeLocation(e,t){return this.throwIfDisposed(),SS(this.gl,()=>this.gl.getAttribLocation(e,t))}getUniformLocationNoThrow(e,t){return this.throwIfDisposed(),this.gl.getUniformLocation(e,t)}setInputMatrixTexture(e,t,n){this.throwIfDisposed(),this.throwIfNoProgram(),DS(this.gl,e,t,n)}setOutputMatrixTexture(e,t,n){this.setOutputMatrixTextureDriver(e,n,t)}setOutputPackedMatrixTexture(e,t,n){this.throwIfDisposed();const[s,r]=IS(t,n);this.setOutputMatrixTextureDriver(e,s,r)}setOutputMatrixWriteRegion(e,t,n,s){this.setOutputMatrixWriteRegionDriver(n,e,s,t)}setOutputPackedMatrixWriteRegion(e,t,n,s){throw new Error("setOutputPackedMatrixWriteRegion not implemented.")}debugValidate(){null!=this.program&&RS(this.gl,this.program),MS(this.gl)}executeProgram(){this.throwIfDisposed(),this.throwIfNoProgram();const e=this.gl;this.debug&&this.debugValidate(),SS(e,()=>e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0))}blockUntilAllProgramsCompleted(){this.throwIfDisposed(),SS(this.gl,()=>this.gl.finish())}getQueryTimerExtension(){return null==this.disjointQueryTimerExtension&&(this.disjointQueryTimerExtension=ES(this.gl,2===G().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")?"EXT_disjoint_timer_query_webgl2":"EXT_disjoint_timer_query")),this.disjointQueryTimerExtension}getQueryTimerExtensionWebGL2(){return this.getQueryTimerExtension()}getQueryTimerExtensionWebGL1(){return this.getQueryTimerExtension()}beginQuery(){if(2===G().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,t=this.getQueryTimerExtensionWebGL2(),n=e.createQuery();return e.beginQuery(t.TIME_ELAPSED_EXT,n),n}const e=this.getQueryTimerExtensionWebGL1(),t=e.createQueryEXT();return e.beginQueryEXT(e.TIME_ELAPSED_EXT,t),t}endQuery(){if(2===G().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,t=this.getQueryTimerExtensionWebGL2();return void e.endQuery(t.TIME_ELAPSED_EXT)}const e=this.getQueryTimerExtensionWebGL1();e.endQueryEXT(e.TIME_ELAPSED_EXT)}async waitForQueryAndGetTime(e){return await g(()=>this.disposed||this.isQueryAvailable(e,G().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))),this.getQueryTime(e,G().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))}getQueryTime(e,t){if(0===t)return null;if(2===t){const t=this.gl;return t.getQueryParameter(e,t.QUERY_RESULT)/1e6}{const t=this.getQueryTimerExtensionWebGL1();return t.getQueryObjectEXT(e,t.QUERY_RESULT_EXT)/1e6}}isQueryAvailable(e,t){if(0===t)return!0;if(2===t){const t=this.gl,n=this.getQueryTimerExtensionWebGL2(),s=t.getQueryParameter(e,t.QUERY_RESULT_AVAILABLE);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(n.GPU_DISJOINT_EXT)),s&&!this.disjoint}{const t=this.getQueryTimerExtensionWebGL1(),n=t.getQueryObjectEXT(e,t.QUERY_RESULT_AVAILABLE_EXT);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(t.GPU_DISJOINT_EXT)),n&&!this.disjoint}}pollFence(e){return new Promise(t=>{this.addItemToPoll(()=>e.isFencePassed(),()=>t())})}pollItems(){const e=function(e){let t=0;for(;t<e.length;++t){if(!e[t]())break}return t-1}(this.itemsToPoll.map(e=>e.isDoneFn));for(let t=0;t<=e;++t){const{resolveFn:e}=this.itemsToPoll[t];e()}this.itemsToPoll=this.itemsToPoll.slice(e+1)}addItemToPoll(e,t){this.itemsToPoll.push({isDoneFn:e,resolveFn:t}),this.itemsToPoll.length>1||g(()=>(this.pollItems(),0===this.itemsToPoll.length))}bindTextureToFrameBuffer(e){this.throwIfDisposed(),_S(this.gl,e,this.framebuffer),this.debug&&MS(this.gl)}unbindTextureToFrameBuffer(){null!=this.outputTexture?(_S(this.gl,this.outputTexture,this.framebuffer),this.debug&&MS(this.gl)):OS(this.gl,this.framebuffer)}downloadMatrixDriver(e,t){this.bindTextureToFrameBuffer(e);const n=t();return this.unbindTextureToFrameBuffer(),n}setOutputMatrixTextureDriver(e,t,n){this.throwIfDisposed();const s=this.gl;_S(s,e,this.framebuffer),this.debug&&MS(s),this.outputTexture=e,SS(s,()=>s.viewport(0,0,t,n)),SS(s,()=>s.scissor(0,0,t,n))}setOutputMatrixWriteRegionDriver(e,t,n,s){this.throwIfDisposed(),SS(this.gl,()=>this.gl.scissor(e,t,n,s))}throwIfDisposed(){if(this.disposed)throw new Error("Attempted to use disposed GPGPUContext.")}throwIfNoProgram(){if(null==this.program)throw new Error("No GPU program is currently set.")}}const{getBroadcastDims:xT}=lp;function wT(e,t,n,s){const r=[];e.forEach(e=>{const t=h(e.shapeInfo.logicalShape);e.shapeInfo.isUniform?r.push(`uniform float ${e.name}${t>1?`[${t}]`:""};`):(r.push(`uniform sampler2D ${e.name};`),r.push(`uniform int offset${e.name};`))});const a=r.join("\n"),i=e.map(e=>function(e,t,n=!1){let s="";s+=n?vT(e):kT(e);const r=e.shapeInfo.logicalShape,a=t.logicalShape;r.length<=a.length&&(s+=n?function(e,t){const n=e.name,s=n.charAt(0).toUpperCase()+n.slice(1),r="get"+s+"AtOutCoords",a=e.shapeInfo.logicalShape.length,i=t.logicalShape.length,o=xT(e.shapeInfo.logicalShape,t.logicalShape),l=AT(i),u=i-a;let c;const p=["x","y","z","w","u","v"];c=0===a?"":i<2&&o.length>=1?"coords = 0;":o.map(e=>`coords.${p[e+u]} = 0;`).join("\n");let d="";d=i<2&&a>0?"coords":e.shapeInfo.logicalShape.map((e,t)=>"coords."+p[t+u]).join(", ");let f="return outputValue;";const m=1===h(e.shapeInfo.logicalShape),g=1===h(t.logicalShape);if(1!==a||m||g){if(m&&!g)f=1===i?"\n        return vec4(outputValue.x, outputValue.x, 0., 0.);\n      ":"\n        return vec4(outputValue.x);\n      ";else if(o.length){const e=a-2,t=a-1;o.indexOf(e)>-1&&o.indexOf(t)>-1?f="return vec4(outputValue.x);":o.indexOf(e)>-1?f="return vec4(outputValue.x, outputValue.y, outputValue.x, outputValue.y);":o.indexOf(t)>-1&&(f="return vec4(outputValue.xx, outputValue.zz);")}}else f="\n      return vec4(outputValue.xy, outputValue.xy);\n    ";return`\n    vec4 ${r}() {\n      ${l} coords = getOutputCoords();\n      ${c}\n      vec4 outputValue = get${s}(${d});\n      ${f}\n    }\n  `}(e,t):function(e,t){const n=e.name,s=n.charAt(0).toUpperCase()+n.slice(1),r="get"+s+"AtOutCoords",a=t.texShape,i=e.shapeInfo.texShape,o=e.shapeInfo.logicalShape.length,l=t.logicalShape.length;if(!e.shapeInfo.isUniform&&o===l&&null==e.shapeInfo.flatOffset&&p(i,a))return`\n      float ${r}() {\n        return sampleTexture(${n}, resultUV);\n      }\n    `;const u=AT(l),c=xT(e.shapeInfo.logicalShape,t.logicalShape),h=l-o;let d;const f=["x","y","z","w","u","v"];d=0===o?"":l<2&&c.length>=1?"coords = 0;":c.map(e=>`coords.${f[e+h]} = 0;`).join("\n");let m="";m=l<2&&o>0?"coords":e.shapeInfo.logicalShape.map((e,t)=>"coords."+f[t+h]).join(", ");return`\n    float ${r}() {\n      ${u} coords = getOutputCoords();\n      ${d}\n      return get${s}(${m});\n    }\n  `}(e,t));return s}(e,t,s)).join("\n"),o=t.texShape,l=ZS(),u=function(e){return`\n    float sampleTexture(sampler2D textureSampler, vec2 uv) {\n      return ${e.texture2D}(textureSampler, uv).r;\n    }\n  `}(l);let c,d,f=function(e){return`${e.version}\n    precision highp float;\n    precision highp int;\n    precision highp sampler2D;\n    ${e.varyingFs} vec2 resultUV;\n    ${e.defineOutput}\n    const vec2 halfCR = vec2(0.5, 0.5);\n\n    struct ivec5\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n    };\n\n    struct ivec6\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n      int v;\n    };\n\n    uniform float NAN;\n    ${e.defineSpecialNaN}\n    ${e.defineSpecialInf}\n    ${e.defineRound}\n\n    int imod(int x, int y) {\n      return x - y * (x / y);\n    }\n\n    int idiv(int a, int b, float sign) {\n      int res = a / b;\n      int mod = imod(a, b);\n      if (sign < 0. && mod != 0) {\n        res -= 1;\n      }\n      return res;\n    }\n\n    //Based on the work of Dave Hoskins\n    //https://www.shadertoy.com/view/4djSRW\n    #define HASHSCALE1 443.8975\n    float random(float seed){\n      vec2 p = resultUV * seed;\n      vec3 p3  = fract(vec3(p.xyx) * HASHSCALE1);\n      p3 += dot(p3, p3.yzx + 19.19);\n      return fract((p3.x + p3.y) * p3.z);\n    }\n\n    ${NT}\n    ${IT}\n    ${CT}\n  `}(l);return t.isPacked?(c=function(e,t){switch(e.length){case 0:return TT();case 1:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(1===n[0])return`\n      int getOutputCoords() {\n        return 2 * int(resultUV.x * ${n[1]}.0);\n      }\n    `;if(1===n[1])return`\n      int getOutputCoords() {\n        return 2 * int(resultUV.y * ${n[0]}.0);\n      }\n    `;return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      return 2 * (resTexRC.x * ${n[1]} + resTexRC.y);\n    }\n  `}(0,t);case 2:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(p(e,t))return`\n      ivec2 getOutputCoords() {\n        return 2 * ivec2(resultUV.yx * vec2(${n[0]}, ${n[1]}));\n      }\n    `;const s=Math.ceil(e[1]/2);return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n      int r = 2 * (index / ${s});\n      int c = imod(index, ${s}) * 2;\n\n      return ivec2(r, c);\n    }\n  `}(e,t);case 3:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)],s=Math.ceil(e[2]/2),r=s*Math.ceil(e[1]/2);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      int b = index / ${r};\n      index -= b * ${r};\n\n      int r = 2 * (index / ${s});\n      int c = imod(index, ${s}) * 2;\n\n      return ivec3(b, r, c);\n    }\n  `}(e,t);default:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)],s=Math.ceil(e[e.length-1]/2),r=s*Math.ceil(e[e.length-2]/2);let a=r,i="",o="b, r, c";for(let t=2;t<e.length-1;t++)a*=e[e.length-t-1],i=`\n      int b${t} = index / ${a};\n      index -= b${t} * ${a};\n    `+i,o=`b${t}, `+o;return`\n    ivec${e.length} getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      ${i}\n\n      int b = index / ${r};\n      index -= b * ${r};\n\n      int r = 2 * (index / ${s});\n      int c = imod(index, ${s}) * 2;\n\n      return ivec${e.length}(${o});\n    }\n  `}(e,t)}}(t.logicalShape,o),d=function(e){return`\n    void setOutput(vec4 val) {\n      ${e.output} = val;\n    }\n  `}(l)):(c=function(e,t){switch(e.length){case 0:return TT();case 1:return function(e,t){if(1===t[0])return`\n      int getOutputCoords() {\n        return int(resultUV.x * ${t[1]}.0);\n      }\n    `;if(1===t[1])return`\n      int getOutputCoords() {\n        return int(resultUV.y * ${t[0]}.0);\n      }\n    `;return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      return resTexRC.x * ${t[1]} + resTexRC.y;\n    }\n  `}(0,t);case 2:return function(e,t){if(p(e,t))return`\n      ivec2 getOutputCoords() {\n        return ivec2(resultUV.yx * vec2(${t[0]}, ${t[1]}));\n      }\n    `;if(1===e[1])return`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(index, 0);\n      }\n    `;if(1===e[0])return`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(0, index);\n      }\n    `;return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      int r = index / ${e[1]};\n      int c = index - r * ${e[1]};\n      return ivec2(r, c);\n    }\n  `}(e,t);case 3:return function(e,t){const n=QS(["r","c","d"],e);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      ${n}\n      return ivec3(r, c, d);\n    }\n  `}(e,t);case 4:return function(e,t){const n=QS(["r","c","d","d2"],e);return`\n    ivec4 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      ${n}\n      return ivec4(r, c, d, d2);\n    }\n  `}(e,t);case 5:return function(e,t){const n=QS(["r","c","d","d2","d3"],e);return`\n    ivec5 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx * vec2(${t[0]},\n                             ${t[1]}));\n\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec5 outShape = ivec5(r, c, d, d2, d3);\n      return outShape;\n    }\n  `}(e,t);case 6:return function(e,t){const n=QS(["r","c","d","d2","d3","d4"],e);return`\n    ivec6 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec6 result = ivec6(r, c, d, d2, d3, d4);\n      return result;\n    }\n  `}(e,t);default:throw new Error(e.length+"-D output sampling is not yet supported")}}(t.logicalShape,o),d=function(e){return`\n    void setOutput(float val) {\n      ${e.output} = vec4(val, 0, 0, 0);\n    }\n  `}(l)),s&&(f+=ST),[f,u,d,a,c,i,n].join("\n")}function kT(e){const t=e.shapeInfo.logicalShape;switch(t.length){case 0:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1);if(e.shapeInfo.isUniform)return`float ${n}() {return ${t};}`;const[s,r]=e.shapeInfo.texShape;if(1===s&&1===r)return`\n      float ${n}() {\n        return sampleTexture(${t}, halfCR);\n      }\n    `;const[a,i]=e.shapeInfo.texShape,o=ET(t);return`\n    float ${n}() {\n      vec2 uv = uvFromFlat(${a}, ${i}, ${o});\n      return sampleTexture(${t}, uv);\n    }\n  `}(e);case 1:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1);if(e.shapeInfo.isUniform)return`\n      float ${n}(int index) {\n        ${$T(e)}\n      }\n    `;const s=e.shapeInfo.texShape,r=s[0],a=s[1];if(1===a&&1===r)return`\n      float ${n}(int index) {\n        return sampleTexture(${t}, halfCR);\n      }\n    `;const i=ET(t);if(1===a)return`\n      float ${n}(int index) {\n        vec2 uv = vec2(0.5, (float(index + ${i}) + 0.5) / ${r}.0);\n        return sampleTexture(${t}, uv);\n      }\n    `;if(1===r)return`\n      float ${n}(int index) {\n        vec2 uv = vec2((float(index + ${i}) + 0.5) / ${a}.0, 0.5);\n        return sampleTexture(${t}, uv);\n      }\n    `;return`\n    float ${n}(int index) {\n      vec2 uv = uvFromFlat(${r}, ${a}, index + ${i});\n      return sampleTexture(${t}, uv);\n    }\n  `}(e);case 2:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e.shapeInfo.texShape;if(null!=r&&p(t,r)){const e=r[0],t=r[1];return`\n    float ${s}(int row, int col) {\n      vec2 uv = (vec2(col, row) + halfCR) / vec2(${t}.0, ${e}.0);\n      return sampleTexture(${n}, uv);\n    }\n  `}const{newShape:a,keptDims:i}=x(t),o=a;if(o.length<t.length){const t=RT(e,o),n=["row","col"];return`\n      ${kT(t)}\n      float ${s}(int row, int col) {\n        return ${s}(${FT(n,i)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col) {\n        int index = round(dot(vec2(row, col), vec2(${t[1]}, 1)));\n        ${$T(e)}\n      }\n    `;const l=r[0],u=r[1],c=ET(n);if(1===u)return`\n    float ${s}(int row, int col) {\n      float index = dot(vec3(row, col, ${c}), vec3(${t[1]}, 1, 1));\n      vec2 uv = vec2(0.5, (index + 0.5) / ${l}.0);\n      return sampleTexture(${n}, uv);\n    }\n  `;if(1===l)return`\n    float ${s}(int row, int col) {\n      float index = dot(vec3(row, col, ${c}), vec3(${t[1]}, 1, 1));\n      vec2 uv = vec2((index + 0.5) / ${u}.0, 0.5);\n      return sampleTexture(${n}, uv);\n    }\n  `;return`\n  float ${s}(int row, int col) {\n    // Explicitly use integer operations as dot() only works on floats.\n    int index = row * ${t[1]} + col + ${c};\n    vec2 uv = uvFromFlat(${l}, ${u}, index);\n    return sampleTexture(${n}, uv);\n  }\n`}(e);case 3:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t[1]*t[2],a=t[2],{newShape:i,keptDims:o}=x(t),l=i;if(l.length<t.length){const t=RT(e,l),n=["row","col","depth"];return`\n        ${kT(t)}\n        float ${s}(int row, int col, int depth) {\n          return ${s}(${FT(n,o)});\n        }\n      `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth) {\n        int index = round(dot(vec3(row, col, depth),\n                          vec3(${r}, ${a}, 1)));\n        ${$T(e)}\n      }\n    `;const u=e.shapeInfo.texShape,c=u[0],h=u[1],p=e.shapeInfo.flatOffset;if(h===r&&null==p)return`\n        float ${s}(int row, int col, int depth) {\n          float texR = float(row);\n          float texC = dot(vec2(col, depth), vec2(${a}, 1));\n          vec2 uv = (vec2(texC, texR) + halfCR) /\n                     vec2(${h}.0, ${c}.0);\n          return sampleTexture(${n}, uv);\n        }\n      `;if(h===a&&null==p)return`\n    float ${s}(int row, int col, int depth) {\n      float texR = dot(vec2(row, col), vec2(${t[1]}, 1));\n      float texC = float(depth);\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${h}.0, ${c}.0);\n      return sampleTexture(${n}, uv);\n    }\n  `;const d=ET(n);return`\n      float ${s}(int row, int col, int depth) {\n        // Explicitly use integer operations as dot() only works on floats.\n        int index = row * ${r} + col * ${a} + depth + ${d};\n        vec2 uv = uvFromFlat(${c}, ${h}, index);\n        return sampleTexture(${n}, uv);\n      }\n  `}(e);case 4:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t[3],a=t[2]*r,i=t[1]*a,{newShape:o,keptDims:l}=x(t);if(o.length<t.length){const t=RT(e,o),n=["row","col","depth","depth2"];return`\n      ${kT(t)}\n      float ${s}(int row, int col, int depth, int depth2) {\n        return ${s}(${FT(n,l)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth, int depth2) {\n        int index = round(dot(vec4(row, col, depth, depth2),\n                          vec4(${i}, ${a}, ${r}, 1)));\n        ${$T(e)}\n      }\n    `;const u=e.shapeInfo.flatOffset,c=e.shapeInfo.texShape,h=c[0],p=c[1];if(p===i&&null==u)return`\n      float ${s}(int row, int col, int depth, int depth2) {\n        float texR = float(row);\n        float texC =\n            dot(vec3(col, depth, depth2),\n                vec3(${a}, ${r}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${p}.0, ${h}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(p===r&&null==u)return`\n      float ${s}(int row, int col, int depth, int depth2) {\n        float texR = dot(vec3(row, col, depth),\n                         vec3(${t[1]*t[2]}, ${t[2]}, 1));\n        float texC = float(depth2);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${p}.0, ${h}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const d=ET(n);return`\n    float ${s}(int row, int col, int depth, int depth2) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${i} + col * ${a} +\n          depth * ${r} + depth2;\n      vec2 uv = uvFromFlat(${h}, ${p}, index + ${d});\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);case 5:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t[4],a=t[3]*r,i=t[2]*a,o=t[1]*i,{newShape:l,keptDims:u}=x(t);if(l.length<t.length){const t=RT(e,l),n=["row","col","depth","depth2","depth3"];return`\n      ${kT(t)}\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        return ${s}(${FT(n,u)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        float index = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${o}, ${i}, ${a}, ${r})) +\n          depth3;\n        ${$T(e)}\n      }\n    `;const c=e.shapeInfo.flatOffset,h=e.shapeInfo.texShape,p=h[0],d=h[1];if(d===o&&null==c)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n                         vec4(${i}, ${a}, ${r}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${d}.0, ${p}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(d===r&&null==c)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        float texR = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]},\n               ${t[2]*t[3]}, ${t[3]}, 1));\n        int texC = depth3;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${d}.0, ${p}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const f=ET(n);return`\n    float ${s}(int row, int col, int depth, int depth2, int depth3) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${o} + col * ${i} + depth * ${a} +\n          depth2 * ${r} + depth3 + ${f};\n      vec2 uv = uvFromFlat(${p}, ${d}, index);\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);case 6:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),{newShape:r,keptDims:a}=x(t);if(r.length<t.length){const t=RT(e,r),n=["row","col","depth","depth2","depth3","depth4"];return`\n      ${kT(t)}\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        return ${s}(${FT(n,a)});\n      }\n    `}const i=t[5],o=t[4]*i,l=t[3]*o,u=t[2]*l,c=t[1]*u;if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n        int index = round(dot(\n          vec4(row, col, depth, depth2),\n          vec4(${c}, ${u}, ${l}, ${o})) +\n          dot(\n            vec2(depth3, depth4),\n            vec2(${i}, 1)));\n        ${$T(e)}\n      }\n    `;const h=e.shapeInfo.flatOffset,p=e.shapeInfo.texShape,d=p[0],f=p[1];if(f===c&&null==h)return`\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n          vec4(${u}, ${l}, ${o}, ${i})) +\n               float(depth4);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${f}.0, ${d}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(f===i&&null==h)return`\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        float texR = dot(vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]*t[4]},\n               ${t[2]*t[3]*t[4]},\n               ${t[3]*t[4]},\n               ${t[4]})) + float(depth3);\n        int texC = depth4;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${f}.0, ${d}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const m=ET(n);return`\n    float ${s}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${c} + col * ${u} + depth * ${l} +\n          depth2 * ${o} + depth3 * ${i} + depth4 + ${m};\n      vec2 uv = uvFromFlat(${d}, ${f}, index);\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);default:throw new Error(t.length+"-D input sampling is not yet supported")}}function vT(e){switch(e.shapeInfo.logicalShape.length){case 0:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1),s=ZS();return`\n    vec4 ${n}() {\n      return ${s.texture2D}(${t}, halfCR);\n    }\n  `}(e);case 1:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1),s=e.shapeInfo.texShape,r=[Math.ceil(s[0]/2),Math.ceil(s[1]/2)],a=ZS();return`\n    vec4 ${n}(int index) {\n      vec2 uv = packedUVfrom1D(\n        ${r[0]}, ${r[1]}, index);\n      return ${a.texture2D}(${t}, uv);\n    }\n  `}(e);case 2:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e.shapeInfo.texShape,a=r[0],i=r[1],o=ZS();if(null!=r&&p(t,r))return`\n      vec4 ${s}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${i}.0, ${a}.0);\n\n        return ${o.texture2D}(${n}, uv);\n      }\n    `;const l=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)],u=Math.ceil(t[1]/2);return`\n    vec4 ${s}(int row, int col) {\n      vec2 uv = packedUVfrom2D(${u}, ${l[0]}, ${l[1]}, row, col);\n      return ${o.texture2D}(${n}, uv);\n    }\n  `}(e);case 3:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e.shapeInfo.texShape,a=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)];if(1===t[0]){const n=t.slice(1),r=[1,2],a=RT(e,n),i=["b","row","col"];return`\n        ${vT(a)}\n        vec4 ${s}(int b, int row, int col) {\n          return ${s}(${FT(i,r)});\n        }\n      `}const i=a[0],o=a[1],l=Math.ceil(t[2]/2),u=l*Math.ceil(t[1]/2),c=ZS();return`\n    vec4 ${s}(int b, int row, int col) {\n      vec2 uv = packedUVfrom3D(\n        ${i}, ${o}, ${u}, ${l}, b, row, col);\n      return ${c.texture2D}(${n}, uv);\n    }\n  `}(e);default:return function(e){const t=e.shapeInfo.logicalShape,n=t.length,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=e.shapeInfo.texShape,i=[Math.ceil(a[0]/2),Math.ceil(a[1]/2)],o=i[0],l=i[1],u=Math.ceil(t[n-1]/2);let c=u*Math.ceil(t[n-2]/2),h="int b, int row, int col",p=`b * ${c} + (row / 2) * ${u} + (col / 2)`;for(let e=2;e<n-1;e++)h=`int b${e}, `+h,c*=t[n-e-1],p=`b${e} * ${c} + `+p;const d=ZS();return`\n    vec4 ${r}(${h}) {\n      int index = ${p};\n      int texR = index / ${l};\n      int texC = index - texR * ${l};\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${l}, ${o});\n      return ${d.texture2D}(${s}, uv);\n    }\n  `}(e)}}const NT="\nvec2 uvFromFlat(int texNumR, int texNumC, int index) {\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\nvec2 packedUVfrom1D(int texNumR, int texNumC, int index) {\n  int texelIndex = index / 2;\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",IT="\nvec2 packedUVfrom2D(int texelsInLogicalRow, int texNumR,\n  int texNumC, int row, int col) {\n  int texelIndex = (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",CT="\nvec2 packedUVfrom3D(int texNumR, int texNumC,\n    int texelsInBatch, int texelsInLogicalRow, int b,\n    int row, int col) {\n  int index = b * texelsInBatch + (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",ST="\n  float getChannel(vec4 frag, vec2 innerDims) {\n    vec2 modCoord = mod(innerDims, 2.);\n    return modCoord.x == 0. ?\n      (modCoord.y == 0. ? frag.r : frag.g) :\n      (modCoord.y == 0. ? frag.b : frag.a);\n  }\n  float getChannel(vec4 frag, int dim) {\n    float modCoord = mod(float(dim), 2.);\n    return modCoord == 0. ? frag.r : frag.g;\n  }\n";function TT(){return"\n    int getOutputCoords() {\n      return 0;\n    }\n  "}function ET(e){return"offset"+e}function $T(e){const t=e.name,n=h(e.shapeInfo.logicalShape);return n<2?`return ${t};`:`\n    for (int i = 0; i < ${n}; i++) {\n      if (i == index) {\n        return ${t}[i];\n      }\n    }\n  `}function AT(e){if(e<=1)return"int";if(2===e)return"ivec2";if(3===e)return"ivec3";if(4===e)return"ivec4";if(5===e)return"ivec5";if(6===e)return"ivec6";throw Error(`GPU for rank ${e} is not yet supported`)}function RT(e,t){const n=JSON.parse(JSON.stringify(e));return n.shapeInfo.logicalShape=t,n}function FT(e,t){return t.map(t=>e[t]).join(", ")}function DT(e,t){if(e.length!==t.length)throw Error(`Binary was compiled with ${e.length} inputs, but was executed with ${t.length} inputs`);e.forEach((e,n)=>{const s=e.logicalShape,r=t[n],a=r.shape;if(!p(s,a))throw Error(`Binary was compiled with different shapes than the current args. Shapes ${s} and ${a} must match`);if(e.isUniform&&r.isUniform)return;const i=e.texShape,o=r.isUniform?null:r.texData.texShape;if(!p(i,o))throw Error(`Binary was compiled with different texture shapes than the current args. Shape ${i} and ${o} must match`)})}const{addImpl:_T,bincountImpl:OT,bincountReduceImpl:MT,ceilImpl:LT,concatImpl:zT,expImpl:BT,expm1Impl:PT,floorImpl:WT,gatherV2Impl:VT,greaterImpl:UT,lessImpl:GT,linSpaceImpl:HT,logImpl:jT,maxImpl:qT,maximumImpl:KT,minimumImpl:XT,multiplyImpl:YT,negImpl:JT,prodImpl:ZT,rangeImpl:QT,rsqrtImpl:eE,simpleAbsImpl:tE,sliceImpl:nE,stridedSliceImpl:sE,subImpl:rE,tileImpl:aE,topKImpl:iE,transposeImpl:oE,uniqueImpl:lE}=pN;function uE(e,t){return["x","y","z","w","u","v"].slice(0,t).map(t=>`${e}.${t}`)}function cE(e,t){return 1===t?[e]:uE(e,t)}class hE{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outputShape=e;const t=e.length;if(0===t)this.userCode="\n        void main() {\n          setOutput(vec4(getA(), 0., 0., 0.));\n        }\n      ";else{const n=cE("rc",t),s=AT(t),r=function(e,t,n){if(1===e)return"rc > "+t[0];let s="";for(let r=e-2;r<e;r++)s+=`${n[r]} >= ${t[r]}`,r<e-1&&(s+="||");return s}(t,e,n),a=function(e,t,n,s){if(1===e)return"";const r=s.slice(-2);return`\n    int r = ${r[0]};\n    int c = ${r[1]};\n    int rp1 = r + 1;\n    int cp1 = c + 1;\n\n    bool cEdge = cp1 >= ${t};\n    bool rEdge = rp1 >= ${n};\n  `}(t,e[e.length-1],e[e.length-2],n),i=function(e,t){const n=e.length,s=function(e,t){const n=[];for(let s=0;s<=1;s++)for(let r=0;r<=1;r++){let a=`${0===s?"r":"rp1"}, ${0===r?"c":"cp1"}`;for(let n=2;n<e;n++)a=t[t.length-1-n]+","+a;n.push(a)}return n}(n,t);if(1===n)return`getA(rc),\n            rc + 1 >= ${e[0]} ? 0. : getA(rc + 1),\n            0, 0`;return`getA(${s[0]}),\n          cEdge ? 0. : getA(${s[1]}),\n          rEdge ? 0. : getA(${s[2]}),\n          rEdge || cEdge ? 0. : getA(${s[3]})`}(e,n);this.userCode=`\n        void main() {\n          ${s} rc = getOutputCoords();\n\n          if(${r}) {\n            setOutput(vec4(0));\n          } else {\n            ${a}\n\n            setOutput(vec4(${i}));\n          }\n        }\n      `}}}class pE{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e;let n="";for(let e=0;e<4;e++){let t="thisRC = rc;";e%2==1&&(t+="thisRC.z += 1;"),e>1&&(t+="thisRC.y += 1;"),n+=`\n        ${t}\n        ${e>0?"if(thisRC.y < rows && thisRC.z < cols){":""}\n          int flatIndex = getFlatIndex(thisRC);\n\n          ivec3 inputRC = inputCoordsFromReshapedOutCoords(flatIndex);\n          vec2 inputRCInnerDims = vec2(float(inputRC.y),float(inputRC.z));\n\n          result[${e}] =\n            getChannel(getA(inputRC.x, inputRC.y, inputRC.z), inputRCInnerDims);\n        ${e>0?"}":""}\n      `}var s;this.userCode=`\n      ${s=t,`\n    ivec3 inputCoordsFromReshapedOutCoords(int index) {\n      ${QS(["r","c","d"],s)}\n      return ivec3(r, c, d);\n    }\n  `}\n      ${eT(e)}\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n\n        vec4 result = vec4(0.);\n\n        ivec3 thisRC;\n        int rows = ${e[1]};\n        int cols = ${e[2]};\n\n        ${n}\n\n        setOutput(result);\n      }\n    `}}class dE{constructor(e){this.gpgpu=e,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0,this.freeTextures={},this.logEnabled=!1,this.usedTextures={}}acquireTexture(e,t,n){const s=mE(t,n),r=gE(e,s,n);r in this.freeTextures||(this.freeTextures[r]=[]),r in this.usedTextures||(this.usedTextures[r]=[]);const a=fE(e,s,this.gpgpu.gl,this.gpgpu.textureConfig,n);if(this.freeTextures[r].length>0){this.numFreeTextures--,this.numUsedTextures++,this._numBytesFree-=a,this.log();const e=this.freeTextures[r].shift();return this.usedTextures[r].push(e),e}let i;return s===kS.PACKED_2X2_FLOAT32?i=this.gpgpu.createPackedMatrixTexture(e[0],e[1]):s===kS.PACKED_2X2_FLOAT16?i=this.gpgpu.createFloat16PackedMatrixTexture(e[0],e[1]):s===kS.UNPACKED_FLOAT32?i=this.gpgpu.createFloat32MatrixTexture(e[0],e[1]):s===kS.UNPACKED_FLOAT16?i=this.gpgpu.createFloat16MatrixTexture(e[0],e[1]):s===kS.PACKED_4X1_UNSIGNED_BYTE&&(i=this.gpgpu.createUnsignedBytesMatrixTexture(e[0],e[1])),this.usedTextures[r].push(i),this.numUsedTextures++,this._numBytesAllocated+=a,this.log(),i}releaseTexture(e,t,n,s){if(null==this.freeTextures)return;const r=mE(n,s),a=gE(t,r,s);a in this.freeTextures||(this.freeTextures[a]=[]);const i=fE(t,r,this.gpgpu.gl,this.gpgpu.textureConfig,s),o=G().get("WEBGL_DELETE_TEXTURE_THRESHOLD");-1!==o&&this._numBytesAllocated>o?(this.gpgpu.deleteMatrixTexture(e),this._numBytesAllocated-=i):(this.freeTextures[a].push(e),this.numFreeTextures++,this._numBytesFree+=i),this.numUsedTextures--;const l=this.usedTextures[a],u=l.indexOf(e);if(u<0)throw new Error("Cannot release a texture that was never provided by this texture manager");l.splice(u,1),this.log()}log(){if(!this.logEnabled)return;const e=this.numFreeTextures+this.numUsedTextures;console.log("Free/Used",`${this.numFreeTextures} / ${this.numUsedTextures}`,`(${e})`);const t=this._numBytesFree/this._numBytesAllocated;console.log("Bytes allocated: "+this._numBytesAllocated),console.log(`Bytes unused: ${this._numBytesFree} (${Math.round(100*t)}%)`)}get numBytesAllocated(){return this._numBytesAllocated}get numBytesFree(){return this._numBytesFree}getNumUsedTextures(){return this.numUsedTextures}getNumFreeTextures(){return this.numFreeTextures}dispose(){if(null!=this.freeTextures){for(const e in this.freeTextures)this.freeTextures[e].forEach(e=>{this.gpgpu.deleteMatrixTexture(e)});for(const e in this.usedTextures)this.usedTextures[e].forEach(e=>{this.gpgpu.deleteMatrixTexture(e)});this.freeTextures=null,this.usedTextures=null,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0}}}function fE(e,t,n,s,r){const a=function(e,t){switch(e){case kS.PACKED_2X2_FLOAT32:return mT(t);case kS.PACKED_2X2_FLOAT16:return gT(t);case kS.UNPACKED_FLOAT32:return pT(t);case kS.UNPACKED_FLOAT16:return dT(t);case kS.PACKED_4X1_UNSIGNED_BYTE:return fT(t);default:throw new Error("Unknown physical texture type "+e)}}(t,s);let i;if(r){const[t,n]=IS(e[0],e[1]);i=t*n}else{const[t,n]=vS(e[0],e[1]);i=t*n}return i*function(e,t){const n=e;if(t===n.R32F)return 4;if(t===n.R16F)return 2;if(t===n.RGBA32F)return 16;if(t===e.RGBA)return 16;if(t===n.RGBA16F)return 8;throw new Error("Unknown internal format "+t)}(n,a)}function mE(e,t){if(e===wS.UPLOAD)return kS.PACKED_2X2_FLOAT32;if(e===wS.RENDER||null==e)return function(e){return G().getBool("WEBGL_RENDER_FLOAT32_ENABLED")?e?kS.PACKED_2X2_FLOAT32:kS.UNPACKED_FLOAT32:e?kS.PACKED_2X2_FLOAT16:kS.UNPACKED_FLOAT16}(t);if(e===wS.DOWNLOAD||e===wS.PIXELS)return kS.PACKED_4X1_UNSIGNED_BYTE;throw new Error("Unknown logical texture type "+e)}function gE(e,t,n){return`${e[0]}_${e[1]}_${t}_${n}`}class yE{constructor(e,t){this.variableNames=["A"],this.outputShape=e,this.userCode=`\n      float unaryOperation(float x) {\n        ${t}\n      }\n\n      void main() {\n        float x = getAAtOutCoords();\n        float y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}const bE="return abs(x);";const xE="return x;";class wE{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.userCode=`\n      vec4 unaryOperation(vec4 x) {\n        ${t}\n      }\n\n      void main() {\n        vec4 x = getAAtOutCoords();\n        vec4 y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}class kE{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outputShape=e;const t=e.length,n=cE("rc",t),s=AT(t),r=function(e,t){if(1===e)return"rc";let n="";for(let s=0;s<e;s++)n+=t[s],s<e-1&&(n+=",");return n}(t,n),a=n.slice(-2),i=t<=1?"rc":`vec2(${a.join(",")})`;this.userCode=`\n      void main() {\n        ${s} rc = getOutputCoords();\n        vec4 packedInput = getA(${r});\n\n        setOutput(getChannel(packedInput, ${i}));\n      }\n    `}}const vE=hc,NE={};class IE extends t{constructor(t){if(super(),this.pendingRead=new WeakMap,this.pendingDisposal=new WeakSet,this.dataRefCount=new WeakMap,this.numBytesInGPU=0,this.uploadWaitMs=0,this.downloadWaitMs=0,this.lastGlFlushTime=0,this.warnedAboutMemory=!1,this.warnedAboutCPUBackend=!1,this.pendingDeletes=0,this.disposed=!1,!G().getBool("HAS_WEBGL"))throw new Error("WebGL is not supported on this device");if(null==t){const e=bS(G().getNumber("WEBGL_VERSION"));this.binaryCache=((n=G().getNumber("WEBGL_VERSION"))in NE||(NE[n]={}),NE[n]),this.gpgpu=new bT(e),this.canvas=e.canvas,this.gpgpuCreatedLocally=!0}else this.gpgpu=t,this.binaryCache={},this.gpgpuCreatedLocally=!1,this.canvas=t.gl.canvas;var n;this.textureManager=new dE(this.gpgpu),this.numMBBeforeWarning=null==G().global.screen?1024:G().global.screen.height*G().global.screen.width*window.devicePixelRatio*600/1024/1024,this.texData=new e(this,Xa())}nextDataId(){return IE.nextDataId++}numDataIds(){return this.texData.numDataIds()+(this.cpuBackend?this.cpuBackend.numDataIds():0)-this.pendingDeletes}write(e,t,n){if((G().getBool("WEBGL_CHECK_NUMERICAL_PROBLEMS")||G().getBool("DEBUG"))&&this.checkNumericalProblems(e),"complex64"===n&&null!=e)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");const s={id:this.nextDataId()};return this.texData.set(s,{shape:t,dtype:n,values:e,usage:wS.UPLOAD,refCount:1}),s}refCount(e){if(this.texData.has(e)){return this.texData.get(e).refCount}return 0}incRef(e){this.texData.get(e).refCount++}decRef(e){if(this.texData.has(e)){this.texData.get(e).refCount--}}move(e,t,n,s,r){if(G().getBool("DEBUG")&&this.checkNumericalProblems(t),"complex64"===s)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");this.texData.set(e,{shape:n,dtype:s,values:t,usage:wS.UPLOAD,refCount:r})}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}readSync(e){const t=this.texData.get(e),{values:n,dtype:s,complexTensorInfos:r,slice:a,shape:i,isPacked:o}=t;if(null!=a){let t;t=o?new wE(i,xE):new yE(i,xE);const n=this.runWebGLProgram(t,[{dataId:e,shape:i,dtype:s}],s),r=this.readSync(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=n)return this.convertAndCacheOnCPU(e);if("string"===s)return n;const l=null!=this.activeTimers;let u,c;if(l&&(u=rs()),"complex64"===s){c=qh(this.readSync(r.real.dataId),this.readSync(r.imag.dataId))}else c=this.getValuesFromTexture(e);return l&&(this.downloadWaitMs+=rs()-u),this.convertAndCacheOnCPU(e,c)}async read(e){if(this.pendingRead.has(e)){const t=this.pendingRead.get(e);return new Promise(e=>t.push(e))}const t=this.texData.get(e),{values:n,shape:s,slice:r,dtype:a,complexTensorInfos:i,isPacked:o}=t;if(null!=r){let t;t=o?new wE(s,xE):new yE(s,xE);const n=this.runWebGLProgram(t,[{dataId:e,shape:s,dtype:a}],a),r=this.read(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=n)return this.convertAndCacheOnCPU(e);if(!G().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")&&2===G().getNumber("WEBGL_VERSION"))throw new Error("tensor.data() with WEBGL_DOWNLOAD_FLOAT_ENABLED=false and WEBGL_VERSION=2 not yet supported.");let l,u,c=null;if("complex64"!==a&&G().get("WEBGL_BUFFER_SUPPORTED")){l=this.decode(e);const t=this.texData.get(l.dataId);c=this.gpgpu.createBufferFromTexture(t.texture,...NS(s))}if(this.pendingRead.set(e,[]),"complex64"!==a&&await this.gpgpu.createAndWaitForFence(),"complex64"===a){const e=await Promise.all([this.read(i.real.dataId),this.read(i.imag.dataId)]);u=qh(e[0],e[1])}else if(null==c)u=this.getValuesFromTexture(e);else{const e=h(s);u=this.gpgpu.downloadFloat32MatrixFromBuffer(c,e)}null!=l&&this.disposeIntermediateTensorInfo(l);const p=this.convertAndCacheOnCPU(e,u),d=this.pendingRead.get(e);return this.pendingRead.delete(e),d.forEach(e=>e(p)),this.pendingDisposal.has(e)&&(this.pendingDisposal.delete(e),this.disposeData(e)&&Xa().removeDataId(e,this),this.pendingDeletes--),p}bufferSync(e){const t=this.readSync(e.dataId);let n=t;if("string"===e.dtype)try{n=t.map(e=>os(e))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return Lr(e.shape,e.dtype,n)}checkNumericalProblems(e){if(null!=e)for(let t=0;t<e.length;t++){const n=e[t];if(!TS(n)){if(G().getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))throw Error(`The value ${n} cannot be represented with your current settings. Consider enabling float32 rendering: 'tf.env().set('WEBGL_RENDER_FLOAT32_ENABLED', true);'`);throw Error(`The value ${n} cannot be represented on this device.`)}}}getValuesFromTexture(e){const{shape:t,dtype:n,isPacked:s}=this.texData.get(e),r=h(t);if(G().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")){const n=this.decode(e),s=this.texData.get(n.dataId),a=this.gpgpu.downloadMatrixFromPackedTexture(s.texture,...NS(t)).subarray(0,r);return this.disposeIntermediateTensorInfo(n),a}const a=G().getBool("WEBGL_PACK")&&!0===s,i=a?WS(t):t,o=a?new aT(i):new rT(i),l=this.runWebGLProgram(o,[{shape:i,dtype:n,dataId:e}],"float32"),u=this.texData.get(l.dataId),c=this.gpgpu.downloadByteEncodedFloatMatrixFromOutputTexture(u.texture,u.texShape[0],u.texShape[1]).subarray(0,r);return this.disposeIntermediateTensorInfo(l),c}timerAvailable(){return G().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0}async time(e){const t=this.activeTimers,n=[];let s=!1;null==this.programTimersStack?(this.programTimersStack=n,s=!0):this.activeTimers.push(n),this.activeTimers=n,e();const r=c(this.activeTimers.map(e=>e.query)).filter(e=>null!=e),a=c(this.activeTimers.map(e=>e.name)).filter(e=>null!=e);this.activeTimers=t,s&&(this.programTimersStack=null);const o={uploadWaitMs:this.uploadWaitMs,downloadWaitMs:this.downloadWaitMs,kernelMs:null,wallMs:null};if(G().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0){const e=await Promise.all(r);o.kernelMs=i(e),o.getExtraProfileInfo=()=>e.map((e,t)=>({name:a[t],ms:e})).map(e=>`${e.name}: ${e.ms}`).join(", ")}else o.kernelMs={error:"WebGL query timers are not supported in this environment."};return this.uploadWaitMs=0,this.downloadWaitMs=0,o}memory(){return{unreliable:!1,numBytesInGPU:this.numBytesInGPU,numBytesInGPUAllocated:this.textureManager.numBytesAllocated,numBytesInGPUFree:this.textureManager.numBytesFree}}startTimer(){return G().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?this.gpgpu.beginQuery():{startMs:rs(),endMs:null}}endTimer(e){return G().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?(this.gpgpu.endQuery(),e):(e.endMs=rs(),e)}async getQueryTime(e){if(G().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0)return this.gpgpu.waitForQueryAndGetTime(e);const t=e;return t.endMs-t.startMs}disposeData(e,t=!1){if(this.pendingDisposal.has(e))return!1;if(!this.texData.has(e))return!0;if(t?this.texData.get(e).refCount=0:this.texData.get(e).refCount--,!t&&this.texData.get(e).refCount>0)return!1;if(this.pendingRead.has(e))return this.pendingDisposal.add(e),this.pendingDeletes++,!1;this.releaseGPUData(e);const{complexTensorInfos:n}=this.texData.get(e);return null!=n&&(this.disposeData(n.real.dataId,t),this.disposeData(n.imag.dataId,t)),this.texData.delete(e),!0}releaseGPUData(e){const{texture:t,dtype:n,texShape:s,usage:r,isPacked:a,slice:i}=this.texData.get(e),o=i&&i.origDataId||e,l=this.dataRefCount.get(o);l>1?this.dataRefCount.set(o,l-1):(this.dataRefCount.delete(o),null!=t&&(this.numBytesInGPU-=this.computeBytes(s,n),this.textureManager.releaseTexture(t,s,r,a)));const u=this.texData.get(e);u.texture=null,u.texShape=null,u.isPacked=!1,u.slice=null}getTexture(e){return this.uploadToGPU(e),this.texData.get(e).texture}getDataInfo(e){return this.texData.get(e)}getCPUBackend(){return G().getBool("WEBGL_CPU_FORWARD")?(null==this.cpuBackend&&(this.cpuBackend=Xa().findBackend("cpu")),this.cpuBackend):null}shouldExecuteOnCPU(e,t=128){const n=this.getCPUBackend();return G().getBool("IS_TEST")||this.warnedAboutCPUBackend||null!=n||(console.warn("Your application contains ops that are small enough to be executed on the CPU backend, however the CPU backend cannot be found. Consider importing the CPU backend (@tensorflow/tfjs-backend-cpu) for better performance."),this.warnedAboutCPUBackend=!0),null!=n&&e.every(e=>null==this.texData.get(e.dataId).texture&&h(e.shape)<t)}getGPGPUContext(){return this.gpgpu}where(e){jh("tf.where() in webgl locks the UI thread. Call tf.whereAsync() instead");const t=e.dataSync();return vE(e.shape,t)}packedUnaryOp(e,t,n){const s=new wE(e.shape,t),r=this.compileAndRun(s,[e],n);return Xa().makeTensorFromDataId(r.dataId,r.shape,r.dtype)}abs(e){if(this.shouldExecuteOnCPU([e])&&"complex64"!==e.dtype){const t=tE(this.texData.get(e.dataId).values);return this.makeOutput(e.shape,e.dtype,t)}if(G().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,bE,e.dtype);const t=new yE(e.shape,bE),n=this.compileAndRun(t,[e]);return Xa().makeTensorFromDataId(n.dataId,n.shape,n.dtype)}makeTensorInfo(e,t,n){let s;if("string"===t&&null!=n&&n.length>0&&E(n[0])){const r=n.map(e=>is(e));s=this.write(r,e,t)}else s=this.write(n,e,t);return this.texData.get(s).usage=null,{dataId:s,shape:e,dtype:t}}makeOutput(e,t,n){const{dataId:s}=this.makeTensorInfo(e,t,n);return Xa().makeTensorFromDataId(s,e,t,this)}unpackTensor(e){const t=new kE(e.shape);return this.runWebGLProgram(t,[e],e.dtype)}packTensor(e){const t=new hE(e.shape);return this.runWebGLProgram(t,[e],e.dtype,null,!0)}packedReshape(e,t){const n=[BS(e.shape),...PS(e.shape)],s={dtype:e.dtype,shape:n,dataId:e.dataId},r=[BS(t),...PS(t)],a=new pE(r,n),i=this.runWebGLProgram(a,[s],e.dtype,null,!0);return{dataId:i.dataId,shape:t,dtype:i.dtype}}decode(e){const t=this.texData.get(e),{isPacked:n,shape:s,dtype:r}=t,a=WS(s);let i;i=n?new sT(a):new nT(a);return{dtype:r,shape:s,dataId:this.runWebGLProgram(i,[{shape:a,dtype:r,dataId:e}],r,null,!0).dataId}}runWebGLProgram(e,t,n,s,r=!1){const a=this.makeTensorInfo(e.outputShape,n),i=this.texData.get(a.dataId);if(e.packedOutput&&(i.isPacked=!0),e.outPackingScheme===xS.DENSE){const t=NS(e.outputShape);i.texShape=t.map(e=>2*e)}if(null!=e.outTexUsage&&(i.usage=e.outTexUsage),0===h(a.shape))return i.values=w(a.dtype,0),a;const o=[],l=t.map(t=>{if("complex64"===t.dtype)throw new Error("GPGPUProgram does not support complex64 input. For complex64 dtypes, please separate the program into real and imaginary parts.");let n=this.texData.get(t.dataId);if(null==n.texture){if(!e.packedInputs&&h(t.shape)<=G().getNumber("WEBGL_SIZE_UPLOAD_UNIFORM"))return{shape:t.shape,texData:null,isUniform:!0,uniformValues:n.values};e.packedInputs&&(n.isPacked=!0,n.shape=t.shape)}else if(!!n.isPacked!=!!e.packedInputs)t=n.isPacked?this.unpackTensor(t):this.packTensor(t),o.push(t),n=this.texData.get(t.dataId);else if(n.isPacked&&!US(n.shape,t.shape)){const e=t,s=t.shape;t.shape=n.shape,t=this.packedReshape(t,s),o.push(t),n=this.texData.get(t.dataId),e.shape=s}return this.uploadToGPU(t.dataId),{shape:t.shape,texData:n,isUniform:!1}});this.uploadToGPU(a.dataId);const u={shape:a.shape,texData:i,isUniform:!1},c=function(e,t,n){let s="";t.concat(n).forEach(e=>{const t=null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0,n=e.isUniform?"uniform":e.texData.texShape;s+=`${e.shape}_${n}_${t}`});const r=e.userCode;let a=e.constructor.name;return a+="_"+s+"_"+r,a}(e,l,u),p=this.getAndSaveBinary(c,()=>function(e,t,n,s){const r=t.userCode,a=n.map((e,n)=>{const s={logicalShape:e.shape,texShape:e.isUniform?null:e.texData.texShape,isUniform:e.isUniform,isPacked:!e.isUniform&&e.texData.isPacked,flatOffset:null};return null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0&&(s.flatOffset=e.texData.slice.flatOffset),{name:t.variableNames[n],shapeInfo:s}}),i=a.map(e=>e.shapeInfo),o={logicalShape:s.shape,texShape:s.texData.texShape,isUniform:!1,isPacked:s.texData.isPacked,flatOffset:null},l=wT(a,o,r,t.packedInputs),u=e.createProgram(l);let c=null;const h=e.getUniformLocation(u,"NAN",!1);1===G().getNumber("WEBGL_VERSION")&&(c=e.getUniformLocation(u,"INFINITY",!1));const p={};for(let n=0;n<t.variableNames.length;n++){const s=t.variableNames[n],r=!1;p[s]=e.getUniformLocation(u,s,r),p["offset"+s]=e.getUniformLocation(u,"offset"+s,r)}return{program:t,source:l,webGLProgram:u,uniformLocations:p,inShapeInfos:i,outShapeInfo:o,infLoc:c,nanLoc:h}}(this.gpgpu,e,l,u)),d=null!=this.activeTimers;let f;d&&(f=this.startTimer()),function(e,t,n,s,r){DT(t.inShapeInfos,n),DT([t.outShapeInfo],[s]);const a=s.texData.texture,i=s.texData.texShape;s.texData.isPacked?e.setOutputPackedMatrixTexture(a,i[0],i[1]):e.setOutputMatrixTexture(a,i[0],i[1]),e.setProgram(t.webGLProgram),1===G().getNumber("WEBGL_VERSION")&&null!==t.infLoc&&e.gl.uniform1f(t.infLoc,1/0),null!==t.nanLoc&&e.gl.uniform1f(t.nanLoc,NaN),n.forEach((n,s)=>{const r=t.program.variableNames[s],a=t.uniformLocations[r],i=t.uniformLocations["offset"+r];if(null!=a)if(n.isUniform)if(h(n.shape)<2)e.gl.uniform1f(a,n.uniformValues[0]);else{let t=n.uniformValues;t instanceof Float32Array||(t=new Float32Array(t)),e.gl.uniform1fv(a,t)}else null!=n.texData.slice&&null!=i&&e.gl.uniform1i(i,n.texData.slice.flatOffset),e.setInputMatrixTexture(n.texData.texture,a,s)}),null!=r&&r(e,t.webGLProgram),e.executeProgram()}(this.gpgpu,p,l,u,s),o.forEach(e=>this.disposeIntermediateTensorInfo(e)),d&&(f=this.endTimer(f),this.activeTimers.push({name:e.constructor.name,query:this.getQueryTime(f)}));const m=G().get("WEBGL_FLUSH_THRESHOLD");if(m>0){const e=rs();e-this.lastGlFlushTime>m&&(this.gpgpu.gl.flush(),this.lastGlFlushTime=e)}if(!G().getBool("WEBGL_LAZILY_UNPACK")&&i.isPacked&&!1===r){const e=this.unpackTensor(a);return this.disposeIntermediateTensorInfo(a),e}return a}compileAndRun(e,t,n,s,r=!1){return n=n||t[0].dtype,this.runWebGLProgram(e,t,n,s,r)}getAndSaveBinary(e,t){return e in this.binaryCache||(this.binaryCache[e]=t()),this.binaryCache[e]}getTextureManager(){return this.textureManager}dispose(){if(!this.disposed){if(!G().getBool("IS_TEST")){Object.keys(this.binaryCache).forEach(e=>{this.gpgpu.deleteProgram(this.binaryCache[e].webGLProgram),delete this.binaryCache[e]})}this.textureManager.dispose(),null!=this.canvas&&"undefined"!=typeof HTMLCanvasElement&&this.canvas instanceof HTMLCanvasElement?this.canvas.remove():this.canvas=null,this.gpgpuCreatedLocally&&(this.gpgpu.program=null,this.gpgpu.dispose()),this.disposed=!0}}floatPrecision(){return null==this.floatPrecisionValue&&(this.floatPrecisionValue=Za(()=>{if(!G().get("WEBGL_RENDER_FLOAT32_ENABLED")){const e=G().getBool("DEBUG");G().set("DEBUG",!1);const t=this.abs(Au(1e-8)).dataSync()[0];if(G().set("DEBUG",e),t>0)return 32}return 16})),this.floatPrecisionValue}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}uploadToGPU(e){const t=this.texData.get(e),{shape:n,dtype:s,values:r,texture:i,usage:o,isPacked:l}=t;if(null!=i)return;const u=null!=this.activeTimers;let c;u&&(c=rs());let p=t.texShape;if(null==p&&(p=function(e,t=!1){let n=G().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(t&&(n*=2,1===(e=e.map((t,n)=>n>=e.length-2?a(e[n]):e[n])).length&&(e=[2,e[0]])),2!==e.length){const t=x(e);e=t.newShape}let s=h(e);if(e.length<=1&&s<=n)return[1,s];if(2===e.length&&e[0]<=n&&e[1]<=n)return e;if(3===e.length&&e[0]*e[1]<=n&&e[2]<=n)return[e[0]*e[1],e[2]];if(3===e.length&&e[0]<=n&&e[1]*e[2]<=n)return[e[0],e[1]*e[2]];if(4===e.length&&e[0]*e[1]*e[2]<=n&&e[3]<=n)return[e[0]*e[1]*e[2],e[3]];if(4===e.length&&e[0]<=n&&e[1]*e[2]*e[3]<=n)return[e[0],e[1]*e[2]*e[3]];if(t){const t=BS(e);let n=2,r=2;return e.length&&([n,r]=PS(e)),s=t*(n/2)*(r/2),f(s).map(e=>2*e)}return f(s)}(n,l),t.texShape=p),null!=r){const e=WS(n);let a,i=p[1],o=p[0];const h=r instanceof Uint8Array;l?([i,o]=IS(p[0],p[1]),a=new oT(e,[o,i],h)):a=new iT(e,[o,i],h);const d=this.makeTensorInfo([o,i],s);this.texData.get(d.dataId).usage=h?wS.PIXELS:wS.UPLOAD,this.gpgpu.uploadDenseMatrixToTexture(this.getTexture(d.dataId),i,o,r);const f=!0,m=this.runWebGLProgram(a,[d],s,null,f),g=this.texData.get(m.dataId);t.texture=g.texture,t.texShape=g.texShape,t.isPacked=g.isPacked,t.usage=g.usage,this.disposeIntermediateTensorInfo(d),this.texData.delete(m.dataId),t.values=null,u&&(this.uploadWaitMs+=rs()-c)}else{const e=this.acquireTexture(p,o,s,l);t.texture=e}}convertAndCacheOnCPU(e,t){const n=this.texData.get(e),{dtype:s}=n;return this.releaseGPUData(e),null!=t&&(n.values=function(e,t){if("float32"===t||"complex64"===t)return e;if("int32"===t||"bool"===t){const n="int32"===t?new Int32Array(e.length):new Uint8Array(e.length);for(let t=0;t<n.length;++t)n[t]=Math.round(e[t]);return n}throw new Error("Unknown dtype "+t)}(t,s)),n.values}acquireTexture(e,t,n,s){if(this.numBytesInGPU+=this.computeBytes(e,n),!this.warnedAboutMemory&&this.numBytesInGPU>1024*this.numMBBeforeWarning*1024){const e=(this.numBytesInGPU/1024/1024).toFixed(2);this.warnedAboutMemory=!0,console.warn(`High memory usage in GPU: ${e} MB, most likely due to a memory leak`)}return this.textureManager.acquireTexture(e,t,s)}computeBytes(e,t){return e[0]*e[1]*S(t)}}IE.nextDataId=0;Us()&&li("webgl",()=>new IE,2);class CE{constructor(e,t,n){this.variableNames=["A","B"],this.outputShape=So(t,n),this.userCode=`\n      float binaryOperation(float a, float b) {\n        ${e}\n      }\n\n      void main() {\n        float a = getAAtOutCoords();\n        float b = getBAtOutCoords();\n        setOutput(binaryOperation(a, b));\n      }\n    `}}class SE{constructor(e,t,n,s=!1){this.variableNames=["A","B"],this.supportsBroadcasting=!0,this.packedInputs=!0,this.packedOutput=!0,this.outputShape=So(t,n);const r=this.outputShape.length;let a="";if(s)if(0===r||1===h(this.outputShape))a="\n          result.y = 0.;\n          result.z = 0.;\n          result.w = 0.;\n        ";else{if(a=`\n          ${AT(r)} coords = getOutputCoords();\n        `,1===r)a+=`\n            result.y = (coords + 1) >= ${this.outputShape[0]} ? 0. : result.y;\n            result.z = 0.;\n            result.w = 0.;\n          `;else{const e=cE("coords",r);a+=`\n            bool nextRowOutOfBounds =\n              (${e[r-2]} + 1) >= ${this.outputShape[r-2]};\n            bool nextColOutOfBounds =\n              (${e[r-1]} + 1) >= ${this.outputShape[r-1]};\n            result.y = nextColOutOfBounds ? 0. : result.y;\n            result.z = nextRowOutOfBounds ? 0. : result.z;\n            result.w = nextColOutOfBounds || nextRowOutOfBounds ? 0. : result.w;\n          `}}this.userCode=`\n      vec4 binaryOperation(vec4 a, vec4 b) {\n        ${e}\n      }\n\n      void main() {\n        vec4 a = getAAtOutCoords();\n        vec4 b = getBAtOutCoords();\n\n        vec4 result = binaryOperation(a, b);\n        ${a}\n\n        setOutput(result);\n      }\n    `}}function TE(e){const{inputs:t,backend:n}=e,{x:s}=t;return n.incRef(s.dataId),{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}const EE={kernelName:"Identity",backendName:"webgl",kernelFunc:TE};function $E(e){const{inputs:t,backend:n}=e,{real:s,imag:r}=t,a=n.makeTensorInfo(s.shape,"complex64"),i=n.texData.get(a.dataId),o=TE({inputs:{x:s},backend:n}),l=TE({inputs:{x:r},backend:n});return i.complexTensorInfos={real:o,imag:l},a}const AE={kernelName:"Complex",backendName:"webgl",kernelFunc:$E},RE="return (a < 0.) ? b * a : a;",FE="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const DE={kernelName:"LeakyRelu",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{alpha:a}=s,i=n.makeTensorInfo([],"float32",ns(a,"float32")),o=G().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new SE(FE,r.shape,i.shape):new CE(RE,r.shape,i.shape),l=n.runWebGLProgram(o,[r,i],r.dtype);return n.disposeIntermediateTensorInfo(i),l}},_E="return (a < 0.) ? b * a : a;",OE="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const ME={kernelName:"Prelu",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s,alpha:r}=t,a=G().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new SE(OE,s.shape,r.shape):new CE(_E,s.shape,r.shape);return n.runWebGLProgram(a,[s,r],s.dtype)}};function LE({opSnippet:e,packedOpSnippet:t,cpuKernelImpl:n,dtype:s}){return({inputs:r,backend:a})=>{const{x:i}=r,o=a,l=s||i.dtype;if(o.shouldExecuteOnCPU([i])&&null!=n){const e=o.texData.get(i.dataId),t=n(e.values,l);return o.makeTensorInfo(i.shape,l,t)}let u;return u=G().getBool("WEBGL_PACK_UNARY_OPERATIONS")&&null!=t?new wE(i.shape,t):new yE(i.shape,e),o.runWebGLProgram(u,[i],l)}}function zE({opSnippet:e,packedOpSnippet:t,checkOutOfBounds:n=!1,supportsComplex:s=!1,cpuKernelImpl:r,dtype:a}){return({inputs:i,backend:o})=>{const{a:l,b:u}=i,c=o;if(s&&"complex64"===l.dtype){const t=c.texData.get(l.dataId),n=c.texData.get(u.dataId),[s,r]=[[t.complexTensorInfos.real,n.complexTensorInfos.real],[t.complexTensorInfos.imag,n.complexTensorInfos.imag]].map(t=>{const[n,s]=t,r={dataId:n.dataId,dtype:n.dtype,shape:l.shape},a={dataId:s.dataId,dtype:s.dtype,shape:u.shape},i=new CE(e,l.shape,u.shape);return c.runWebGLProgram(i,[r,a],$s(n.dtype,s.dtype))}),a=$E({inputs:{real:s,imag:r},backend:c});return c.disposeIntermediateTensorInfo(s),c.disposeIntermediateTensorInfo(r),a}const h=a||$s(l.dtype,u.dtype);if(c.shouldExecuteOnCPU([l,u])&&null!=r){const e=c.texData.get(l.dataId),t=c.texData.get(u.dataId),[n,s]=r(l.shape,u.shape,e.values,t.values,h),a=c.makeTensorInfo(s,h);return c.texData.get(a.dataId).values=n,a}let p;return p=G().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&null!=t?new SE(t,l.shape,u.shape,n):new CE(e,l.shape,u.shape),c.runWebGLProgram(p,[l,u],h)}}function BE(e,t=!1){if("linear"===e)return"return x;";if("relu"===e)return t?"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n";if("elu"===e)return t?"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n":"return (x >= 0.0) ? x : (exp(x) - 1.0);";if("relu6"===e)return t?"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n";if("prelu"===e)return t?OE:_E;if("leakyrelu"===e)return t?FE:RE;throw new Error(`Activation ${e} has not been implemented for the WebGL backend.`)}class PE{constructor(e,t,n,s=!1,r=!1,a=!1,i=null,o=!1,l=!1){this.variableNames=["matrixA","matrixB"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=n;const u=s?e[1]:e[2],c=Math.ceil(u/2),h=s?"i * 2, rc.y":"rc.y, i * 2",p=r?"rc.z, i * 2":"i * 2, rc.z",d=s?["a.xxyy","a.zzww"]:["a.xxzz","a.yyww"],f=r?["b.xzxz","b.ywyw"]:["b.xyxy","b.zwzw"];let m="",g="";i&&(m=o?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${i}\n        }`:l?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${i}\n        }`:`vec4 activation(vec4 x) {\n          ${i}\n        }`,g="result = activation(result);");const y=a?"result += getBiasAtOutCoords();":"";a&&this.variableNames.push("bias"),o&&this.variableNames.push("preluActivationWeights"),l&&this.variableNames.push("leakyreluAlpha");let b="rc.x",x="rc.x";e[0]<t[0]?b=`int(min(float(rc.x), ${e[0]-1}.))`:t[0]<e[0]&&(x=`int(min(float(rc.x), ${t[0]-1}.))`),this.userCode=`\n      ${m}\n\n      const float sharedDimension = ${c}.0;\n\n      vec4 dot2x2ARowBCol(ivec3 rc) {\n        vec4 result = vec4(0);\n        for (int i = 0; i < ${c}; i++) {\n          int batchA = ${b};\n          int batchB = ${x};\n          vec4 a = getMatrixA(batchA, ${h});\n          vec4 b = getMatrixB(batchB, ${p});\n\n          // These swizzled products need to be separately added.\n          // See: https://github.com/tensorflow/tfjs/issues/1735\n          result += (${d[0]} * ${f[0]});\n          result += (${d[1]} * ${f[1]});\n        }\n        return result;\n      }\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n        vec4 result = dot2x2ARowBCol(rc);\n\n        ${y}\n\n        ${g}\n\n        setOutput(result);\n      }\n    `}}const WE="return areal * breal - aimag * bimag;",VE="return areal * bimag + aimag * breal;";class UE{constructor(e,t,n){this.variableNames=["AReal","AImag","BReal","BImag"],this.outputShape=So(t,n),this.userCode=`\n      float binaryOpComplex(\n          float areal, float aimag, float breal, float bimag) {\n        ${e}\n      }\n\n      void main() {\n        float areal = getARealAtOutCoords();\n        float aimag = getAImagAtOutCoords();\n        float breal = getBRealAtOutCoords();\n        float bimag = getBImagAtOutCoords();\n        setOutput(binaryOpComplex(areal, aimag, breal, bimag));\n      }\n    `}}const GE="return a * b;";function HE(e){const{inputs:t,backend:n}=e,{a:s,b:r}=t,a=$s(s.dtype,r.dtype);if("complex64"===s.dtype){const e=n.texData.get(s.dataId),t=n.texData.get(r.dataId),a=new UE(WE,s.shape,r.shape),i=new UE(VE,s.shape,r.shape),o=[{dataId:e.complexTensorInfos.real.dataId,dtype:e.complexTensorInfos.real.dtype,shape:s.shape},{dataId:e.complexTensorInfos.imag.dataId,dtype:e.complexTensorInfos.imag.dtype,shape:s.shape},{dataId:t.complexTensorInfos.real.dataId,dtype:t.complexTensorInfos.real.dtype,shape:r.shape},{dataId:t.complexTensorInfos.imag.dataId,dtype:t.complexTensorInfos.imag.dtype,shape:r.shape}],l=n.runWebGLProgram(a,o,"float32"),u=n.runWebGLProgram(i,o,"float32"),c=$E({inputs:{real:l,imag:u},backend:n});return n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(u),c}if(n.shouldExecuteOnCPU([s,r])){const e=n.texData.get(s.dataId),t=n.texData.get(r.dataId),[i,o]=YT(s.shape,r.shape,e.values,t.values,a),l=n.makeTensorInfo(o,a);return n.texData.get(l.dataId).values=i,l}let i;return i=G().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new SE(GE,s.shape,r.shape):new CE(GE,s.shape,r.shape),n.runWebGLProgram(i,[s,r],a)}const jE={kernelName:"Multiply",backendName:"webgl",kernelFunc:HE};function qE(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{shape:a}=s,i=n,l=h(r.shape),u=y(a,l),c=h(u);o(l===c,()=>`The new shape (${u}) has ${c} elements and the old shape (${r.shape}) has ${l} elements. The new shape and old shape must have the same number of elements.`);const p=i.texData.get(r.dataId);return!p.isPacked||US(r.shape,u)||null!==p.texture&&US(p.shape,u)?(i.incRef(r.dataId),{dataId:r.dataId,shape:u,dtype:r.dtype}):function(e,t,n){const s=[BS(e.shape),...PS(e.shape)],r={dtype:e.dtype,shape:s,dataId:e.dataId},a=[BS(t),...PS(t)],i=new pE(a,s),o=n.runWebGLProgram(i,[r],e.dtype,null,!0);return{dataId:o.dataId,shape:t,dtype:o.dtype}}(r,u,i)}const KE={kernelName:"Reshape",backendName:"webgl",kernelFunc:qE};class XE{constructor(e,t){this.variableNames=["x"];const{windowSize:n,batchSize:s,inSize:r,outSize:a}=e;this.outputShape=[s,a];const i=4*Math.floor(n/4),o=n%4;let l="sumValue += dot(values, ones);";if(null!=t){const e=1/t;l=`sumValue += dot(values * ${d(e)?e.toPrecision(2):e}, ones);`}let u="";r%n>0&&(u=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return 0.0;\n        }\n      `),this.userCode=`\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${u}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${i}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${l}\n        }\n\n        int inIdx = inOffset + ${i};\n        if (${1===o}) {\n          vec4 values = vec4(getValue(batch, inIdx), 0.0, 0.0, 0.0);\n\n          ${l}\n        } else if (${2===o}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1), 0.0, 0.0);\n\n          ${l}\n        } else if (${3===o}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2), 0.0);\n\n          ${l}\n        }\n        setOutput(sumValue);\n      }\n    `}}class YE{constructor(e,t){this.variableNames=["x"];const{windowSize:n,batchSize:s,inSize:r,outSize:a}=e;this.outputShape=[s,a];let i="0.0",o="";"prod"===t?i="1.0":"min"===t?(i="1.0 / 1e-20",o="min"):"max"===t&&(i="-1.0 / 1e-20",o="max");let l=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"sum"===t?l="sumValue":"prod"===t?l="prodValue":"all"===t?l="allValue":"any"===t&&(l="anyValue");const u=4*Math.floor(n/4),c=n%4;let h=`\n      if (${"sum"===t}) {\n        sumValue += dot(values, ones);\n      } else if (${"prod"===t}) {\n        vec2 tmp = vec2(values[0], values[1]) * vec2(values[2], values[3]);\n        prodValue *= tmp[0] * tmp[1];\n      } else {\n        minMaxValue = ${o}(values, minMaxValue);\n      }\n    `,p="vec4";"all"===t?(i="1.0",h="\n        bool reducedAllValue = all(values);\n        float floatedReducedAllValue = float(reducedAllValue);\n        allValue = float(allValue >= 1.0 && floatedReducedAllValue >= 1.0);\n      ",p="bvec4"):"any"===t&&(i="0.0",h="\n        bool reducedAnyValue = any(values);\n        float floatedReducedAnyValue = float(reducedAnyValue);\n        anyValue = float(anyValue >= 1.0 || floatedReducedAnyValue >= 1.0);\n      ",p="bvec4");let d="";r%n>0&&(d=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return initializationValue;\n        }\n      `),this.userCode=`\n      const float initializationValue = ${i};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${d}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        vec4 minMaxValue = vec4(${i});\n        float prodValue = 1.0;\n        float sumValue = 0.0;\n        float allValue = 1.0;\n        float anyValue = 0.0;\n\n        for (int i = 0; i < ${u}; i += 4) {\n          int inIdx = inOffset + i;\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${h}\n        }\n\n        int inIdx = inOffset + ${u};\n        if (${1===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          ${h}\n        } else if (${2===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          ${h}\n        } else if (${3===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          ${h}\n        }\n        setOutput(${l});\n      }\n    `}}function JE(e,t,n,s){const r=function(e){const t=[];for(;0===t.length||1!==t[t.length-1].outSize;){const n=t.length?t[t.length-1].outSize:e[1],s=zh(n);t.push({inSize:n,windowSize:s,outSize:Math.ceil(n/s)})}return t}(e.shape);let a=e;for(let i=0;i<r.length;i++){const{inSize:o,windowSize:l,outSize:u}=r[i];let c,h;c="mean"===n?0===i?new XE({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u},o):new XE({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u}):new YE({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u},n),h=a,a=s.runWebGLProgram(c,[a],t),h.dataId!==e.dataId&&s.disposeIntermediateTensorInfo(h)}return a}class ZE{constructor(e,t){this.variableNames=["A"];const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[t[s]];this.outputShape=n,this.rank=n.length;const s=AT(this.rank),r=function(e){const t=e.length;if(t>6)throw Error(`Transpose for rank ${t} is not yet supported`);const n=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u","resRC.v"],s=new Array(t);for(let t=0;t<e.length;t++)s[e[t]]=n[t];return s.join()}(t);this.userCode=`\n    void main() {\n      ${s} resRC = getOutputCoords();\n      setOutput(getA(${r}));\n    }\n    `}}class QE{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0;const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[t[s]];if(this.outputShape=n,this.rank=n.length,this.rank>6)throw Error(`Packed transpose for rank ${this.rank} is not yet supported.`);const s=AT(this.rank),r=uE("rc",this.rank),a=new Array(this.rank);for(let e=0;e<t.length;e++)a[t[e]]=r[e];const i=`vec2(${a.slice(-2).join()})`,o=`++${r[this.rank-1]} < ${n[this.rank-1]}`,l=`getChannel(getA(${a.join()}), ${i})`;this.userCode=`\n    void main() {\n      ${s} rc = getOutputCoords();\n      vec4 result = vec4(0.);\n      result[0] = ${l};\n      if(${o}) {\n        result[1] = ${l};\n      }\n      --${r[this.rank-1]};\n      if(++${r[this.rank-2]} < ${n[this.rank-2]}) {\n        result[2] = ${l};\n        if(${o}) {\n          result[3] = ${l};\n        }\n      }\n      setOutput(result);\n    }\n    `}}function e$(e,t,n){const s=G().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new QE(e.shape,t):new ZE(e.shape,t);return n.runWebGLProgram(s,[e],e.dtype)}function t$(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;return function(e,t,n,s){const r=t,a=e.shape.length,i=b(r,e.shape);let o=i;const l=wl(o,a),u=null!=l;let c=e;u&&(c=e$(e,l,s),o=vl(o.length,a)),xl("sum",o,a);const[p,d]=yl(c.shape,o);let f=p;n&&(f=bl(p,i));const m=h(d),g=qE({inputs:{x:c},attrs:{shape:[h(e.shape)/m,m]},backend:s}),y=JE(g,As(e.dtype),"sum",s),x=qE({inputs:{x:y},attrs:{shape:f},backend:s});return s.disposeIntermediateTensorInfo(g),s.disposeIntermediateTensorInfo(y),u&&s.disposeIntermediateTensorInfo(c),x}(r,a,i,n)}const n$={kernelName:"Sum",backendName:"webgl",kernelFunc:t$};function s$(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{perm:a}=s,i=n,o=r.shape.length,l=new Array(o);for(let e=0;e<l.length;e++)l[e]=r.shape[a[e]];let u;if(i.shouldExecuteOnCPU([r])){const e=i.texData.get(r.dataId).values,t=oE(e,r.shape,r.dtype,a,l);u=i.makeTensorInfo(l,r.dtype),i.texData.get(u.dataId).values=t}else u=e$(r,a,i);return u}const r$={kernelName:"Transpose",backendName:"webgl",kernelFunc:s$};function a$({a:e,b:t,transposeA:n,transposeB:s,backend:r,bias:a=null,preluActivationWeights:i=null,leakyreluAlpha:l=0,activation:u=null}){const c=e.shape.length,p=t.shape.length,d=n?e.shape[c-2]:e.shape[c-1],f=s?t.shape[p-1]:t.shape[p-2],m=n?e.shape[c-1]:e.shape[c-2],g=s?t.shape[p-2]:t.shape[p-1],y=e.shape.slice(0,-2),b=t.shape.slice(0,-2),x=h(y),w=h(b);o(c>=2&&p>=2&&(x===w||1===x||1===w),()=>`Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of (${y}) and (${b}).`);const k=(x>w?e.shape.slice(0,-2):t.shape.slice(0,-2)).concat([m,g]);o(d===f,()=>`Error in matMul: inner shapes (${d}) and (${f}) of Tensors with shapes ${e.shape} and ${t.shape} and transposeA=${n} and transposeB=${s} must match.`);const v=n?[x,d,m]:[x,m,d],N=s?[w,g,f]:[w,f,g],I=qE({inputs:{x:e},backend:r,attrs:{shape:v}}),C=qE({inputs:{x:t},backend:r,attrs:{shape:N}}),S=[I,C],T=Math.max(x,w),E=n?I.shape[1]:I.shape[2],$=null!=a,A=null!=i,R="leakyrelu"===u,F=null!=u?BE(u,!0):null;let D;if((1===m||1===g)&&E>1e3&&!1===($||A||R||null!=F)){let e=I,t=C;n&&(e=s$({inputs:{x:I},backend:r,attrs:{perm:[0,2,1]}}),S.push(e)),s&&(t=s$({inputs:{x:C},backend:r,attrs:{perm:[0,2,1]}}),S.push(t));const a=1===g;let i=e;1!==g&&(i=qE({inputs:{x:e},backend:r,attrs:{shape:[T,E,1]}}),S.push(i));const o=1===g?2:1;let l=t;a&&(l=qE({inputs:{x:t},backend:r,attrs:{shape:[T,1,E]}}),S.push(l));const u=HE({inputs:{a:i,b:l},backend:r});D=t$({inputs:{x:u},backend:r,attrs:{axis:o,keepDims:!0}}),S.push(u)}else{const o=$s(e.dtype,t.dtype),u=new PE(v,N,[T,m,g],n,s,$,F,A,R),c=[I,C];if(null!=a&&c.push(a),A&&c.push(i),R){const e=r.makeTensorInfo([],"float32",ns(l,"float32"));c.push(e),S.push(e)}D=r.runWebGLProgram(u,c,o)}const _=qE({inputs:{x:D},backend:r,attrs:{shape:k}});S.push(D);for(const e of S)r.disposeIntermediateTensorInfo(e);return _}const i$={kernelName:"_FusedMatMul",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a,bias:i,preluActivationWeights:o}=t,{transposeA:l,transposeB:u,activation:c,leakyreluAlpha:h}=s;return a$({a:r,b:a,transposeA:l,transposeB:u,backend:n,bias:i,preluActivationWeights:o,leakyreluAlpha:h,activation:c})}};const o$={kernelName:"Abs",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;if(n.shouldExecuteOnCPU([s])&&"complex64"!==s.dtype){const e=n.texData.get(s.dataId),t=tE(e.values);return n.makeTensorInfo(s.shape,s.dtype,t)}let r;return r=G().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new wE(s.shape,"return abs(x);"):new yE(s.shape,"return abs(x);"),n.runWebGLProgram(r,[s],s.dtype)}},l$={kernelName:"Acos",backendName:"webgl",kernelFunc:LE({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return acos(x);\n"})},u$={kernelName:"Acosh",backendName:"webgl",kernelFunc:LE({opSnippet:"if (isnan(x)) return x;\n  if (x < 1.0) return NAN;\nreturn log(x + sqrt(x * x - 1.0));"})},c$="return a + b;",h$=zE({opSnippet:c$,packedOpSnippet:c$,supportsComplex:!0,cpuKernelImpl:_T}),p$={kernelName:Z,backendName:"webgl",kernelFunc:h$};class d${constructor(e,t){this.outputShape=[],this.outputShape=e,this.variableNames=t.map((e,t)=>"T"+t);const n=[];this.variableNames.forEach(e=>{n.push(`float v${e} = get${e}AtOutCoords();`)});const s=this.variableNames.map(e=>"v"+e).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        float result = ${s};\n        setOutput(result);\n      }\n    `}}class f${constructor(e,t){this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.variableNames=t.map((e,t)=>"T"+t);const n=[];this.variableNames.forEach(e=>{n.push(`vec4 v${e} = get${e}AtOutCoords();`)});const s=this.variableNames.map(e=>"v"+e).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        vec4 result = ${s};\n        setOutput(result);\n      }\n    `}}const m$={kernelName:"AddN",backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s}=t,r=n;if(1===r.length)return TE({inputs:{x:r[0]},backend:s});if(r.length>G().get("WEBGL_MAX_TEXTURES_IN_SHADER")){const t=Math.floor(r.length/2),n=e({inputs:r.slice(0,t),backend:s}),a=e({inputs:r.slice(t),backend:s});return e({inputs:[n,a],backend:s})}const a=r.map(e=>e.dtype).reduce((e,t)=>$s(e,t)),i=r.map(e=>e.shape),o=G().getBool("WEBGL_PACK")?new f$(r[0].shape,i):new d$(r[0].shape,i);return s.runWebGLProgram(o,r,a)}};const g$={kernelName:"All",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=b(a,r.shape);let u=l;const c=wl(u,o);let p=r;null!=c&&(p=s$({inputs:{x:r},backend:n,attrs:{perm:c}}),u=vl(u.length,o)),xl("all",u,o);const[d,f]=yl(p.shape,u),m=qE({inputs:{x:p},backend:n,attrs:{shape:[-1,h(f)]}}),g=JE(m,m.dtype,"all",n);let y;if(i){y=qE({inputs:{x:g},backend:n,attrs:{shape:bl(d,l)}})}else y=qE({inputs:{x:g},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(p),y}};const y$={kernelName:"Any",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=b(a,r.shape);let u=l;const c=wl(u,o);let p=r;null!=c&&(p=s$({inputs:{x:r},backend:n,attrs:{perm:c}}),u=vl(u.length,o)),xl("any",u,o);const[d,f]=yl(p.shape,u),m=qE({inputs:{x:p},backend:n,attrs:{shape:[-1,h(f)]}}),g=JE(m,m.dtype,"any",n);let y;if(i){y=qE({inputs:{x:g},backend:n,attrs:{shape:bl(d,l)}})}else y=qE({inputs:{x:g},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(p),y}};class b${constructor(e,t,n){this.variableNames=["A"];const{windowSize:s,batchSize:r,outSize:a}=e;n||this.variableNames.push("bestIndicesA"),this.outputShape=[r,a];const i="max"===t?">":"<",o=n?"inOffset + i;":"round(getBestIndicesA(batch, inOffset + i));";this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${s};\n\n        int bestIndex = inOffset;\n        float bestValue = getA(batch, bestIndex);\n\n        for (int i = 0; i < ${s}; i++) {\n          int inIdx = ${o};\n          float candidate = getA(batch, inIdx);\n          if (candidate ${i} bestValue) {\n            bestValue = candidate;\n            bestIndex = inIdx;\n          }\n        }\n        setOutput(float(bestIndex));\n      }\n    `}}class x${constructor(e,t,n,s){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,o(e.length>2,()=>`Packed arg${n.charAt(0).toUpperCase()+n.slice(1)} supports only inputs with rank above 2.`);const r=e[e.length-1],a=Math.ceil(r/t);this.outputShape=e.slice(0,-1),a>1&&this.outputShape.push(a),s||this.variableNames.push("bestIndicesA");const i=this.outputShape,l=i.length,u=AT(l),c=cE("coords",l);let h,p;if(1===a){p=l+1;const e=AT(p);h=`\n        ${e} sourceLocR = ${e}(${c.join()}, 0);\n        ++${c[l-1]};\n        ${e} sourceLocG = ${e}(${c.join()}, 0);\n        ++${c[l-2]};\n        ${e} sourceLocA = ${e}(${c.join()}, 0);\n        --${c[l-1]};\n        ${e} sourceLocB = ${e}(${c.join()}, 0);\n        --${c[l-2]};`}else p=l,h=`\n        ${u} sourceLocR = coords;\n        ++${c[l-1]};\n        ${u} sourceLocG = coords;\n        ++${c[l-2]};\n        ${u} sourceLocA = coords;\n        --${c[l-1]};\n        ${u} sourceLocB = coords;\n        --${c[l-2]};`;const d=["x","y","z","w","u","v"].slice(0,p),f="."+d[p-1],m=d.map(e=>"int "+e),g=cE("sourceLocR",p-1).concat("inIdx.r"),y=cE("sourceLocG",p-1).concat("inIdx.g"),b=cE("sourceLocB",p-1).concat("inIdx.b"),x=cE("sourceLocA",p-1).concat("inIdx.a"),w="max"===n?"greaterThan":"lessThan",k=s?"":`\n          inIdx = round(vec4(getBestIndicesAChannel(${g.join()}),\n                             getBestIndicesAChannel(${y.join()}),\n                             getBestIndicesAChannel(${b.join()}),\n                             getBestIndicesAChannel(${x.join()})));`,v=`vec4(\n            getAChannel(${g.join()}),\n            hasNextCol ? getAChannel(${y.join()}) : 0.,\n            hasNextRow ? getAChannel(${b.join()}) : 0.,\n            hasNextRow && hasNextCol ? getAChannel(${x.join()}) : 0.)`,N=s?"":`\n      float getBestIndicesAChannel(${m.join()}) {\n        return getChannel(getBestIndicesA(${d.join()}),\n                                          vec2(${d.slice(-2).join()}));\n      }`;this.userCode=`\n      float getAChannel(${m.join()}) {\n        return getChannel(getA(${d.join()}),\n                               vec2(${d.slice(-2).join()}));\n      }\n      ${N}\n      void main() {\n        ${u} coords = getOutputCoords();\n        bool hasNextCol = ${c[l-1]} < ${i[l-1]-1};\n        bool hasNextRow = ${c[l-2]} < ${i[l-2]-1};\n        ${h}\n        ivec4 srcIdx = ivec4(sourceLocR${f}, sourceLocG${f},\n          sourceLocB${f}, sourceLocA${f}) * ${t};\n        ivec4 inIdx = srcIdx;\n        vec4 bestIndex = vec4(inIdx);\n        vec4 bestValue = ${v};\n\n        for (int i = 0; i < ${t}; i++) {\n          inIdx = srcIdx;\n          ${k}\n          vec4 candidate = ${v};\n          bvec4 nan = isnan(candidate);\n          bvec4 replace = bvec4(\n            vec4(${w}(candidate, bestValue)) * (vec4(1.0) - vec4(nan)));\n\n          bestValue = vec4(replace.x  ? candidate.x : bestValue.x,\n                           replace.y  ? candidate.y : bestValue.y,\n                           replace.z  ? candidate.z : bestValue.z,\n                           replace.w  ? candidate.w : bestValue.w);\n          bestIndex = mix(bestIndex, vec4(inIdx), vec4(replace));\n          srcIdx++;\n        }\n        setOutput(bestIndex);\n      }\n    `}}function w$(e,t,n,s){const r=[n];if(xl("arg"+s.charAt(0).toUpperCase()+s.slice(1),r,t.shape.length),!G().getBool("WEBGL_PACK_REDUCE")||t.shape.length<=2){const n=[],[a,i]=yl(t.shape,r),o=h(i),l=qE({inputs:{x:t},backend:e,attrs:{shape:[-1,o]}});n.push(l);const u=function e(t,n,s,r=null){let a=n.shape[0],i=n.shape[1];null!=r&&(a=r.shape[0],i=r.shape[1]);const o=zh(i),l={windowSize:o,inSize:i,batchSize:a,outSize:Math.ceil(i/o)},u=new b$(l,s,null==r),c=[n];null!=r&&c.push(r);const h=t.runWebGLProgram(u,c,"int32");if(1===h.shape[1])return h;const p=e(t,n,s,h);return t.disposeIntermediateTensorInfo(h),p}(e,l,s);n.push(u);const c=qE({inputs:{x:u},backend:e,attrs:{shape:a}});return n.forEach(t=>e.disposeIntermediateTensorInfo(t)),c}return function e(t,n,s,r=null){const a=null!=r?r.shape:n.shape,i=zh(a[a.length-1]),o=new x$(a,i,s,null==r),l=null==r?[n]:[n,r],u=t.runWebGLProgram(o,l,"int32");if(u.shape.length===n.shape.length){const r=e(t,n,s,u);return t.disposeIntermediateTensorInfo(u),r}return u}(e,t,s)}const k$={kernelName:"ArgMax",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;let i=b(a,r.shape);const o=wl(i,r.shape.length);let l=r;const u=[];null!=o&&(l=s$({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=vl(i.length,l.shape.length)),xl("argMax",[i[0]],l.shape.length);const c=w$(n,l,i[0],"max");return u.forEach(e=>n.disposeIntermediateTensorInfo(e)),c}};const v$={kernelName:"ArgMin",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;let i=b(a,r.shape);const o=wl(i,r.shape.length);let l=r;const u=[];null!=o&&(l=s$({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=vl(i.length,l.shape.length)),xl("argMin",[i[0]],l.shape.length);const c=w$(n,l,i[0],"min");return u.forEach(e=>n.disposeIntermediateTensorInfo(e)),c}},N$={kernelName:"Asin",backendName:"webgl",kernelFunc:LE({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return asin(x);\n"})},I$={kernelName:"Asinh",backendName:"webgl",kernelFunc:LE({opSnippet:"if (isnan(x)) return x;return log(x + sqrt(x * x + 1.0));"})},C$={kernelName:"Atan",backendName:"webgl",kernelFunc:LE({opSnippet:"if (isnan(x)) return x;\n  return atan(x);\n"})},S$={kernelName:"Atan2",backendName:"webgl",kernelFunc:zE({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return atan(a, b);\n",packedOpSnippet:"\n  vec4 result = atan(a, b);\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"})},T$={kernelName:"Atanh",backendName:"webgl",kernelFunc:LE({opSnippet:"if (isnan(x)) return x;\n  if ((x < -1.0) || (x > 1.0)) return NAN;\nreturn (log(1.0 + x) - log(1.0 - x)) / 2.0;"})};class E${constructor(e,t,n,s=!1,r=!1){if(this.variableNames=["x"],"avg"===t&&n)throw new Error("Cannot compute positions for average pool.");const a=e.filterWidth,i=e.strideHeight,o=e.strideWidth,l=e.dilationHeight,u=e.dilationWidth,c=e.effectiveFilterHeight,h=e.effectiveFilterWidth,p=e.padInfo.top,d=e.padInfo.left;this.outputShape=e.outShape;const f="avg"===t,m=`((batch  * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + d`,g=`(xR * ${e.inWidth} + xC) * ${e.inChannels} + d`;let y="0.0";if(f||(y="-1.0 / 1e-20"),n){const t=">=";return void(this.userCode=`\n        const ivec2 strides = ivec2(${i}, ${o});\n        const ivec2 pads = ivec2(${p}, ${d});\n\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int batch = coords[0];\n          int d = coords[3];\n\n          ivec2 xRCCorner = coords.yz * strides - pads;\n          int xRCorner = xRCCorner.x;\n          int xCCorner = xRCCorner.y;\n\n          // max/min x(?, ?, d) to get y(yR, yC, d).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n          float avgValue = 0.0;\n\n          for (int wR = 0; wR < ${c};\n              wR += ${l}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${h};\n                wC += ${u}) {\n              int xC = xCCorner + wC;\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float value = getX(batch, xR, xC, d);\n\n              // If a min / max value has already been found, use it. If not,\n              // use the current value.\n              float currMinMaxValue = mix(\n                  value, minMaxValue, minMaxValueFound);\n              if (value ${t} currMinMaxValue) {\n                minMaxValue = value;\n                minMaxValueFound = 1.0;\n                minMaxPosition = ${s?r?m:g:`wR * ${h} + wC`};\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let b=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===t&&(b="avgValue / count");const x=4*Math.floor(a/4),w=a%4,k=`\n      if (${f}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec2 strides = ivec2(${i}, ${o});\n      const ivec2 pads = ivec2(${p}, ${d});\n      const float initializationValue = ${y};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xR, int xC, int d) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xR, xC, d);\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d = coords[3];\n\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // max/min x(?, ?, d) to get y(yR, yC, d).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${y});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wR = 0; wR < ${c};\n            wR += ${l}) {\n          int xR = xRCorner + wR;\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${x}; wC += 4) {\n            int xC = xCCorner + wC * ${u};\n\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              getValue(batch, xR, xC + 2 * ${u}, d),\n              getValue(batch, xR, xC + 3 * ${u}, d)\n            );\n\n            ${k}\n          }\n\n          int xC = xCCorner + ${x};\n          if (${1===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              initializationValue,\n              initializationValue,\n              initializationValue\n            );\n\n            ${k}\n          } else if (${2===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              initializationValue,\n              initializationValue\n            );\n\n            ${k}\n          } else if (${3===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              getValue(batch, xR, xC + 2 * ${u}, d),\n              initializationValue\n            );\n\n            ${k}\n          }\n        }\n        setOutput(${b});\n      }\n    `}}class $${constructor(e,t,n,s=!1,r=!1){if(this.variableNames=["x"],"avg"===t&&n)throw new Error("Cannot compute positions for average pool.");const a=e.filterWidth,i=e.strideDepth,o=e.strideHeight,l=e.strideWidth,u=e.dilationDepth,c=e.dilationHeight,h=e.dilationWidth,p=e.effectiveFilterDepth,d=e.effectiveFilterHeight,f=e.effectiveFilterWidth,m=e.padInfo.front,g=e.padInfo.top,y=e.padInfo.left;this.outputShape=e.outShape;const b="avg"===t;let x="0.0";if(b||(x="-1.0 / 1e-20"),n){const t=">=";return void(this.userCode=`\n        const ivec3 strides =\n            ivec3(${i}, ${o}, ${l});\n        const ivec3 pads = ivec3(${m}, ${g}, ${y});\n\n        void main() {\n          ivec5 coords = getOutputCoords();\n          int batch = coords.x;\n          int ch = coords.u;\n\n          ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n          int xDCorner = xCorner.x;\n          int xRCorner = xCorner.y;\n          int xCCorner = xCorner.z;\n\n          // max/min x(?, ?, ?, ch) to get y(yD, yR, yC, ch).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n\n          for (int wD = 0; wD < ${p};\n              wD += ${u}) {\n            int xD = xDCorner + wD;\n\n            if (xD < 0 || xD >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int wR = 0; wR < ${d};\n                wR += ${c}) {\n              int xR = xRCorner + wR;\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int wC = 0; wC < ${f};\n                  wC += ${h}) {\n                int xC = xCCorner + wC;\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float value = getX(batch, xD, xR, xC, ch);\n\n                // If a min / max value has already been found, use it. If not,\n                // use the current value.\n                float currMinMaxValue = mix(\n                    value, minMaxValue, minMaxValueFound);\n                if (value ${t} currMinMaxValue) {\n                  minMaxValue = value;\n                  minMaxValueFound = 1.0;\n                  minMaxPosition = ${s?r?`(((batch * ${e.inDepth} + xD) * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`((xD * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`wD * ${d} * ${f} +\n                      wR * ${f} + wC`};\n                }\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let w=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===t&&(w="avgValue / count");const k=4*Math.floor(a/4),v=a%4,N=`\n      if (${b}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec3 strides =\n        ivec3(${i}, ${o}, ${l});\n      const ivec3 pads = ivec3(${m}, ${g}, ${y});\n      const float initializationValue = ${x};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xD, int xR, int xC, int ch) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xD, xR, xC, ch);\n      }\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xDCorner = xCorner.x;\n        int xRCorner = xCorner.y;\n        int xCCorner = xCorner.z;\n\n        // max/min x(?, ?, ?, d) to get y(yD, yR, yC, ch).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${x});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wD = 0; wD < ${p};\n            wD += ${u}) {\n          int xD = xDCorner + wD;\n\n          if (xD < 0 || xD >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${d};\n            wR += ${c}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${k}; wC += 4) {\n              int xC = xCCorner + wC * ${h};\n\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${h}, ch),\n                getValue(batch, xD, xR, xC + 3 * ${h}, ch)\n              );\n\n              ${N}\n            }\n\n            int xC = xCCorner + ${k};\n            if (${1===v}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                initializationValue,\n                initializationValue,\n                initializationValue\n              );\n\n              ${N}\n            } else if (${2===v}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                initializationValue,\n                initializationValue\n              );\n\n              ${N}\n            } else if (${3===v}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${h}, ch),\n                initializationValue\n              );\n\n              ${N}\n            }\n          }\n          setOutput(${w});\n        }\n      }\n    `}}const A$={kernelName:"AvgPool",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;YS(r,"avgPool");const{filterSize:a,strides:i,pad:l,dimRoundingMode:u}=s;o(Bi(i,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`);const c=$i(r.shape,a,i,1,l,u);if(1===c.filterWidth&&1===c.filterHeight&&p(c.inShape,c.outShape))return TE({inputs:{x:r},backend:n});const h=new E$(c,"avg",!1);return n.runWebGLProgram(h,[r],"float32")}};const R$={kernelName:"AvgPool3D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s,c=Ai(r.shape,a,i,[1,1,1],o,l,u),h=new $$(c,"avg",!1);return n.runWebGLProgram(h,[r],"float32")}};class F${constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a=e.dilationHeight,i=e.dilationWidth,o=e.effectiveFilterHeight,l=e.effectiveFilterWidth,u=o-1-e.padInfo.top,c=l-1-e.padInfo.left,h=1/(t*n);this.userCode=`\n      const ivec2 pads = ivec2(${u}, ${c});\n      const float avgMultiplier = float(${h});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${o};\n            wR += ${a}) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${l};\n            wC+= ${i}) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n\n            dotProd += dyValue * avgMultiplier;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class D${constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const t=e.filterDepth,n=e.filterHeight,s=e.filterWidth,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=e.dilationDepth,l=e.dilationHeight,u=e.dilationWidth,c=e.effectiveFilterDepth,h=e.effectiveFilterHeight,p=e.effectiveFilterWidth,d=c-1-e.padInfo.front,f=h-1-e.padInfo.top,m=p-1-e.padInfo.left,g=1/(t*n*s);this.userCode=`\n      const ivec3 pads = ivec3(${d}, ${f}, ${m});\n      const float avgMultiplier = float(${g});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, d) with pos mask(:, :, :, ch) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${c};\n            wD += ${o}) {\n          float dyD = float(dyDCorner + wD) / ${r}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${h};\n              wR += ${l}) {\n            float dyR = float(dyRCorner + wR) / ${a}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${p};\n                wC += ${u}) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n\n              dotProd += dyValue * avgMultiplier;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const _$={kernelName:"AvgPool3DGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a,{filterSize:o,strides:l,pad:u,dimRoundingMode:c}=s,h=Ai(i.shape,o,l,[1,1,1],u,c),p=new D$(h);return n.runWebGLProgram(p,[r],i.dtype)}};const O$={kernelName:"AvgPoolGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a;YS([r,a],"avgPoolGrad");const{filterSize:o,strides:l,pad:u}=s,c=$i(i.shape,o,l,1,u),h=new F$(c);return n.runWebGLProgram(h,[r],i.dtype)}};const M$={kernelName:"BatchMatMul",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a}=t,{transposeA:i,transposeB:o}=s;return a$({a:r,b:a,transposeA:i,transposeB:o,backend:n})}};class L${constructor(e,t,n,s,r,a){this.outputShape=[],this.variableNames=["x","mean","variance"],So(e,t),So(e,n);let i="0.0";null!=s&&(So(e,s),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let o="1.0";null!=r&&(So(e,r),this.variableNames.push("scale"),o="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        float x = getXAtOutCoords();\n        float mean = getMeanAtOutCoords();\n        float variance = getVarianceAtOutCoords();\n        float offset = ${i};\n        float scale = ${o};\n        float inv = scale * inversesqrt(variance + float(${a}));\n        setOutput(dot(vec3(x, -mean, offset), vec3(inv, inv, 1)));\n      }\n    `}}class z${constructor(e,t,n,s,r,a){this.packedInputs=!0,this.packedOutput=!0,this.variableNames=["x","mean","variance"],So(e,t),So(e,n);let i="vec4(0.0)";null!=s&&(So(e,s),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let o="vec4(1.0)";null!=r&&(So(e,r),this.variableNames.push("scale"),o="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        vec4 offset = ${i};\n        vec4 scale = ${o};\n\n        vec4 x = getXAtOutCoords();\n        vec4 mean = getMeanAtOutCoords();\n        vec4 variance = getVarianceAtOutCoords();\n\n        vec4 inv = scale * inversesqrt(variance + vec4(${a}));\n\n        setOutput((x - mean) * inv + offset);\n      }\n    `}}const B$={kernelName:"FusedBatchNorm",backendName:"webgl",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,mean:r,variance:a,offset:i,scale:l}=e;o(r.shape.length===a.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),o(null==i||r.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),o(null==l||r.shape.length===l.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks.");let{varianceEpsilon:u}=n;null==u&&(u=.001);const c=[s,r,a];let h=null;null!=i&&(h=i.shape,c.push(i));let p=null;null!=l&&(p=l.shape,c.push(l));const d=G().getBool("WEBGL_PACK_NORMALIZATION")?new z$(s.shape,r.shape,a.shape,h,p,u):new L$(s.shape,r.shape,a.shape,h,p,u);return t.runWebGLProgram(d,c,c[0].dtype)}};class P${constructor(e){this.variableNames=["source"],this.outputShape=e,this.rank=e.length;const t=AT(this.rank),n=`uniform int start[${this.rank}];`,s=function(e){if(1===e)return"sourceLoc";if(e<=6)return W$.slice(0,e).map(e=>"sourceLoc."+e).join(",");throw Error(`Slicing for rank ${e} is not yet supported`)}(this.rank);let r;r=`\n        ${t} sourceLoc;\n        ${t} coords = getOutputCoords();\n        ${e.map((e,t)=>`sourceLoc.${W$[t]} = start[${t}] + coords.${W$[t]};`).join("\n")}\n      `,this.userCode=`\n      ${n}\n      void main() {\n        ${r}\n        setOutput(getSource(${s}));\n      }\n    `}getCustomSetupFunc(e){if(e.length!==this.rank)throw Error(`The rank (${this.rank}) of the program must match the length of start (${e.length})`);return(t,n)=>{null==this.startLoc&&(this.startLoc=t.getUniformLocationNoThrow(n,"start"),null==this.startLoc)||t.gl.uniform1iv(this.startLoc,e)}}}const W$=["x","y","z","w","u","v"];class V${constructor(e){this.variableNames=["source"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.rank=e.length;const t=AT(this.rank),n=cE("coords",this.rank),s=cE("sourceLoc",this.rank),r=1===this.rank?"sourceLoc":`vec2(${s.slice(-2).join()})`,a=`getChannel(getSource(${s.join()}), ${r})`,i=`\n      result.x = ${a};\n      if (++${n[this.rank-1]} < ${e[this.rank-1]}) {\n        ++${s[this.rank-1]};\n        result.y = ${a};\n        --${s[this.rank-1]};\n      }\n    `,o=1===this.rank?"":`\n      --${n[this.rank-1]};\n      if (++${n[this.rank-2]} < ${e[this.rank-2]}) {\n        ++${s[this.rank-2]};\n        result.z = ${a};\n        if (++${n[this.rank-1]} < ${e[this.rank-1]}) {\n          ++${s[this.rank-1]};\n          result.w = ${a};\n        }\n      }\n    `,l=this.rank<=4?`sourceLoc = coords +\n            ${t}(${e.map((e,t)=>`start[${t}]`).join()});`:e.map((e,t)=>`${s[t]} = ${n[t]} + start[${t}];`).join("\n");this.userCode=`\n      uniform int start[${this.rank}];\n      void main() {\n        ${t} coords = getOutputCoords();\n        ${t} sourceLoc;\n        ${l}\n        vec4 result = vec4(0.);\n        ${i}\n        ${o}\n        setOutput(result);\n      }\n    `}getCustomSetupFunc(e){if(e.length!==this.rank)throw Error(`The rank (${this.rank}) of the program must match the length of start (${e.length})`);return(t,n)=>{null==this.startLoc&&(this.startLoc=t.getUniformLocationNoThrow(n,"start"),null==this.startLoc)||t.gl.uniform1iv(this.startLoc,e)}}}function U$(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,size:i}=s,[o,l]=Ra(r,a,i);if(ya(r,o,l),0===h(l))return n.makeTensorInfo(l,r.dtype,[]);if(n.shouldExecuteOnCPU([r])||"string"===r.dtype){const e=n.texData.get(r.dataId),t=nE(e.values,o,l,r.shape,r.dtype);return n.makeTensorInfo(l,r.dtype,t)}const{isPacked:u}=n.texData.get(r.dataId),c=$a(r.shape,o,l);if(u||!c){const e=G().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new V$(l):new P$(l),t=e.getCustomSetupFunc(o);return n.runWebGLProgram(e,[r],r.dtype,t)}return n.uploadToGPU(r.dataId),function(e,t,n,s){const r=s.texData.get(e.dataId),a=s.makeTensorInfo(n,e.dtype),i=s.texData.get(a.dataId);Object.assign(i,r),i.refCount=1,i.shape=n,i.dtype=e.dtype;let o=Aa(t,_(e.shape));r.slice&&(o+=r.slice.flatOffset),i.slice={flatOffset:o,origDataId:r.slice&&r.slice.origDataId||e.dataId};const l=s.dataRefCount.get(i.slice.origDataId)||1;return s.dataRefCount.set(i.slice.origDataId,l+1),a}(r,o,l,n)}const G$={kernelName:"Slice",backendName:"webgl",kernelFunc:U$},H$={kernelName:"BatchToSpaceND",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,crops:i}=s;o(r.shape.length<=4,()=>"batchToSpaceND for rank > 4 with a WebGL backend not implemented yet");const l=a.reduce((e,t)=>e*t),u=Ph(r.shape,a,l),c=Wh(u.length,a.length),h=Vh(r.shape,a,l),p=Uh(i,a.length),d=Gh(h,i,a.length),f=[],m=qE({inputs:{x:r},backend:n,attrs:{shape:u}}),g=s$({inputs:{x:m},backend:n,attrs:{perm:c}}),y=qE({inputs:{x:g},backend:n,attrs:{shape:h}}),b=U$({inputs:{x:y},backend:n,attrs:{begin:p,size:d}});return f.push(m),f.push(g),f.push(y),f.forEach(e=>n.disposeIntermediateTensorInfo(e)),b}};const j$={kernelName:"Bincount",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i}=s,o=n.readSync(r.dataId),l=n.readSync(a.dataId),u=OT(o,l,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,u)}},q$=zE({opSnippet:"return float(a != b);",dtype:"bool"}),K$={kernelName:"NotEqual",backendName:"webgl",kernelFunc:q$};function X$(e){const{inputs:t,backend:n}=e,{input:s}=t;return TE({inputs:{x:n.texData.get(s.dataId).complexTensorInfos.real},backend:n})}const Y$={kernelName:"Real",backendName:"webgl",kernelFunc:X$};const J$={kernelName:"Cast",backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s,attrs:r}=t,{x:a}=n,{dtype:i}=r;if("complex64"===i){if("complex64"===a.dtype)return TE({inputs:{x:a},backend:s});const t=Vl(a.shape),n=e({inputs:{x:a},backend:s,attrs:{dtype:"float32"}}),r=$E({inputs:{real:n,imag:t},backend:s});return t.dispose(),s.disposeIntermediateTensorInfo(n),r}if("complex64"===a.dtype){const t=X$({inputs:{input:a},backend:s}),n=e({inputs:{x:t},backend:s,attrs:{dtype:i}});return s.disposeIntermediateTensorInfo(t),n}if(!I(a.dtype,i)){const e=TE({inputs:{x:a},backend:s});return{dataId:e.dataId,shape:e.shape,dtype:i}}if("int32"===i)return function(e,t){const n=new yE(e.shape,"return float(int(x));"),s=t.runWebGLProgram(n,[e],"int32");return{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}(a,s);if("bool"===i){const e=s.makeTensorInfo([],"bool",w("bool",1)),t=q$({inputs:{a:a,b:e},backend:s});return s.disposeIntermediateTensorInfo(e),t}throw new Error(`Error in Cast: failed to cast ${a.dtype} to ${i}`)}},Z$="return ceil(x);",Q$={kernelName:"Ceil",backendName:"webgl",kernelFunc:LE({opSnippet:Z$,packedOpSnippet:Z$,cpuKernelImpl:LT})};class eA{constructor(e){this.variableNames=["A"],this.outputShape=e,this.userCode="\n      uniform float minVal;\n      uniform float maxVal;\n\n      void main() {\n        float value = getAAtOutCoords();\n        if (isnan(value)) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, minVal, maxVal));\n      }\n    "}getCustomSetupFunc(e,t){return(n,s)=>{null==this.minLoc&&(this.minLoc=n.getUniformLocationNoThrow(s,"minVal"),this.maxLoc=n.getUniformLocationNoThrow(s,"maxVal")),n.gl.uniform1f(this.minLoc,e),n.gl.uniform1f(this.maxLoc,t)}}}class tA{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.userCode="\n      uniform float minVal;\n      uniform float maxVal;\n\n      void main() {\n        vec4 value = getAAtOutCoords();\n\n        if (any(isnan(value))) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, vec4(minVal), vec4(maxVal)));\n      }\n    "}getCustomSetupFunc(e,t){return(n,s)=>{null==this.minLoc&&(this.minLoc=n.getUniformLocationNoThrow(s,"minVal"),this.maxLoc=n.getUniformLocationNoThrow(s,"maxVal")),n.gl.uniform1f(this.minLoc,e),n.gl.uniform1f(this.maxLoc,t)}}}const nA={kernelName:"ClipByValue",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{clipValueMin:a,clipValueMax:i}=s;let o;o=G().getBool("WEBGL_PACK_CLIP")?new tA(r.shape):new eA(r.shape);const l=o.getCustomSetupFunc(a,i);return n.runWebGLProgram(o,[r],r.dtype,l)}};class sA{constructor(e){this.variableNames=["real","imag"],this.outputShape=e,this.userCode="\n      void main() {\n        float re = abs(getRealAtOutCoords());\n        float im = abs(getImagAtOutCoords());\n        float mx = max(re, im);\n\n        // sadly the length function in glsl is not underflow-safe\n        // (at least not on Intel GPUs). So the safe solution is\n        // to ensure underflow-safety in all cases.\n        setOutput(\n          mx == 0.0 ? 0.0 : mx * length(vec2(1, min(re, im)/mx))\n        );\n      }\n    "}}function rA(e,t){return{dataId:t.dataId,dtype:t.dtype,shape:e.shape}}const aA={kernelName:"ComplexAbs",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=n.texData.get(s.dataId),a=new sA(s.shape),i=[rA(s,r.complexTensorInfos.real),rA(s,r.complexTensorInfos.imag)];return n.runWebGLProgram(a,i,i[0].dtype)}};class iA{constructor(e){this.outputShape=[],this.outputShape=Lh(e,1),this.variableNames=e.map((e,t)=>"T"+t);const t=new Array(e.length-1);t[0]=e[0][1];for(let n=1;n<t.length;n++)t[n]=t[n-1]+e[n][1];const n=[`if (yC < ${t[0]}) setOutput(getT0(yR, yC));`];for(let e=1;e<t.length;e++){const s=t[e-1];n.push(`else if (yC < ${t[e]}) setOutput(getT${e}(yR, yC-${s}));`)}const s=t.length,r=t[t.length-1];n.push(`else setOutput(getT${s}(yR, yC-${r}));`),this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int yR = coords.x;\n        int yC = coords.y;\n\n        ${n.join("\n        ")}\n      }\n    `}}class oA{constructor(e,t){this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[],this.outputShape=Lh(e,t);const n=this.outputShape,s=n.length,r=AT(s),a=cE("coords",s),i=["x","y","z","w","u","v"].slice(0,s);this.variableNames=e.map((e,t)=>"T"+t);const o=new Array(e.length-1);o[0]=e[0][t];for(let n=1;n<o.length;n++)o[n]=o[n-1]+e[n][t];const l=i[t],u=i.slice(-2),c=i.join();let h=`if (${l} < ${o[0]}) {\n        return getChannel(\n            getT0(${c}), vec2(${u.join()}));\n        }`;for(let e=1;e<o.length;e++){const t=o[e-1];h+=`\n        if (${l} < ${o[e]}  && ${l} >= ${o[e-1]}) {\n          return getChannel(\n            getT${e}(${lA(i,l,t)}),\n            vec2(${lA(u,l,t)}));\n        }`}const p=o.length,d=o[o.length-1];h+=`\n        return getChannel(\n          getT${p}(${lA(i,l,d)}),\n          vec2(${lA(u,l,d)}));`,this.userCode=`\n      float getValue(${i.map(e=>"int "+e)}) {\n        ${h}\n      }\n\n      void main() {\n        ${r} coords = getOutputCoords();\n        vec4 result = vec4(getValue(${a}), 0., 0., 0.);\n\n        ${a[s-1]} = ${a[s-1]} + 1;\n        if (${a[s-1]} < ${n[s-1]}) {\n          result.g = getValue(${a});\n        }\n\n        ${a[s-2]} = ${a[s-2]} + 1;\n        if (${a[s-2]} < ${n[s-2]}) {\n          result.a = getValue(${a});\n        }\n\n        ${a[s-1]} = ${a[s-1]} - 1;\n        if (${a[s-2]} < ${n[s-2]} &&\n            ${a[s-1]} < ${n[s-1]}) {\n          result.b = getValue(${a});\n        }\n        setOutput(result);\n      }\n    `}}function lA(e,t,n){const s=e.indexOf(t);return e.map((e,t)=>t===s?`${e} - ${n}`:e).join()}function uA(e){const{inputs:t,backend:n}=e,{input:s}=t;return TE({inputs:{x:n.texData.get(s.dataId).complexTensorInfos.imag},backend:n})}const cA={kernelName:"Imag",backendName:"webgl",kernelFunc:uA};function hA(e,t,n){const s=Lh(e.map(e=>e.shape),t);return{tensors2D:e.map(e=>qE({inputs:{x:e},attrs:{shape:[-1,h(e.shape.slice(t))]},backend:n})),outShape:s}}function pA(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s,a=b(r,t[0].shape)[0],i=Lh(t.map(e=>e.shape),a);if(0===h(i))return n.makeTensorInfo(i,t[0].dtype,[]);const o=t.filter(e=>h(e.shape)>0);return 1===o.length?TE({inputs:{x:o[0]},backend:n}):(Mh(o.map(e=>e.shape),a),function e(t,n,s){const r=t[0].dtype;if("complex64"===r){const r=t.map(e=>X$({inputs:{input:e},backend:s})),a=t.map(e=>uA({inputs:{input:e},backend:s})),i=e(r,n,s),o=e(a,n,s),l=$E({inputs:{real:i,imag:o},backend:s});return r.forEach(e=>s.disposeIntermediateTensorInfo(e)),a.forEach(e=>s.disposeIntermediateTensorInfo(e)),s.disposeIntermediateTensorInfo(i),s.disposeIntermediateTensorInfo(o),l}if("string"===r){const{tensors2D:e,outShape:a}=hA(t,n,s),i=e.map(e=>({vals:s.readSync(e.dataId),shape:e.shape})),o=1===e[0].shape[0],l=zT(i,a,r,o),u=Lh(t.map(e=>e.shape),n),c=s.makeTensorInfo(u,r,l);return e.forEach(e=>s.disposeIntermediateTensorInfo(e)),c}if(t.length>G().getNumber("WEBGL_MAX_TEXTURES_IN_SHADER")){const r=Math.floor(t.length/2),a=e(t.slice(0,r),n,s),i=e(t.slice(r),n,s),o=e([a,i],n,s);return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}if(G().getBool("WEBGL_PACK_ARRAY_OPERATIONS")&&t[0].shape.length>1){const e=new oA(t.map(e=>e.shape),n);return s.runWebGLProgram(e,t,r)}const{tensors2D:a,outShape:i}=hA(t,n,s),o=new iA(a.map(e=>e.shape)),l=s.runWebGLProgram(o,a,r);a.forEach(e=>s.disposeIntermediateTensorInfo(e));const u=qE({inputs:{x:l},attrs:{shape:i},backend:s});return s.disposeIntermediateTensorInfo(l),u}(o,a,n))}const dA={kernelName:"Concat",backendName:"webgl",kernelFunc:pA};class fA{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const a=e.padInfo.top,i=e.padInfo.left,o=e.strideHeight,l=e.strideWidth,u=e.dilationHeight,c=e.dilationWidth,h=e.filterHeight,p=e.filterWidth,d=4*Math.floor(e.inChannels/4),f=e.inChannels%4,m="channelsLast"===e.dataFormat,g=m?1:2,y=m?2:3,b=m?3:1;let x="",w="";n&&(x=s?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,w="result = activation(result);");const k=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${x}\n\n      const ivec2 strides = ivec2(${o}, ${l});\n      const ivec2 pads = ivec2(${a}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d2 = coords[${b}];\n\n        ivec2 xRCCorner =\n            ivec2(coords[${g}], coords[${y}]) * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, d2) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${h}; wR++) {\n          int xR = xRCorner + wR * ${u};\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${p}; wC++) {\n            int xC = xCCorner + wC * ${c};\n\n            if (xC < 0 || xC >= ${e.inWidth}) {\n              continue;\n            }\n\n            for (int d1 = 0; d1 < ${d}; d1 += 4) {\n              vec4 wValues = vec4(\n                getW(wR, wC, d1, d2),\n                getW(wR, wC, d1 + 1, d2),\n                getW(wR, wC, d1 + 2, d2),\n                getW(wR, wC, d1 + 3, d2)\n              );\n\n              if (${m}) {\n                vec4 xValues = vec4(\n                  getX(batch, xR, xC, d1),\n                  getX(batch, xR, xC, d1 + 1),\n                  getX(batch, xR, xC, d1 + 2),\n                  getX(batch, xR, xC, d1 + 3)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec4 xValues = vec4(\n                  getX(batch, d1, xR, xC),\n                  getX(batch, d1 + 1, xR, xC),\n                  getX(batch, d1 + 2, xR, xC),\n                  getX(batch, d1 + 3, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n\n            if (${1===f}) {\n\n              if (${m}) {\n                dotProd +=\n                    getX(batch, xR, xC, ${d}) *\n                    getW(wR, wC, ${d}, d2);\n              } else {\n                dotProd +=\n                    getX(batch, ${d}, xR, xC) *\n                    getW(wR, wC, ${d}, d2);\n              }\n\n            } else if (${2===f}) {\n              vec2 wValues = vec2(\n                getW(wR, wC, ${d}, d2),\n                getW(wR, wC, ${d} + 1, d2)\n              );\n\n              if (${m}) {\n                vec2 xValues = vec2(\n                  getX(batch, xR, xC, ${d}),\n                  getX(batch, xR, xC, ${d} + 1)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec2 xValues = vec2(\n                  getX(batch, ${d}, xR, xC),\n                  getX(batch, ${d} + 1, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            } else if (${3===f}) {\n              vec3 wValues = vec3(\n                getW(wR, wC, ${d}, d2),\n                getW(wR, wC, ${d} + 1, d2),\n                getW(wR, wC, ${d} + 2, d2)\n              );\n\n              if (${m}) {\n                vec3 xValues = vec3(\n                  getX(batch, xR, xC, ${d}),\n                  getX(batch, xR, xC, ${d} + 1),\n                  getX(batch, xR, xC, ${d} + 2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec3 xValues = vec3(\n                  getX(batch, ${d}, xR, xC),\n                  getX(batch, ${d} + 1, xR, xC),\n                  getX(batch, ${d} + 2, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            }\n          }\n        }\n\n        float result = dotProd;\n        ${k}\n        ${w}\n        setOutput(result);\n      }\n    `}}class mA{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const t=e.padInfo.front,n=e.padInfo.top,s=e.padInfo.left,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=e.dilationDepth,l=e.dilationHeight,u=e.dilationWidth,c=e.filterDepth,h=e.filterHeight,p=e.filterWidth,d=4*Math.floor(e.inChannels/4),f=e.inChannels%4;this.userCode=`\n      const ivec3 strides = ivec3(${r}, ${a}, ${i});\n      const ivec3 pads = ivec3(${t}, ${n}, ${s});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d2 = coords.u;\n\n        ivec3 xFRCCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xFCorner = xFRCCorner.x;\n        int xRCorner = xFRCCorner.y;\n        int xCCorner = xFRCCorner.z;\n\n        // Convolve x(?, ?, ?, d1) with w(:, :, :, d1, d2) to get\n        // y(yF, yR, yC, d2). ? = to be determined. : = across all\n        // values in that axis.\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${c}; wF++) {\n          int xF = xFCorner + wF * ${o};\n\n          if (xF < 0 || xF >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${h}; wR++) {\n            int xR = xRCorner + wR * ${l};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${p}; wC++) {\n              int xC = xCCorner + wC * ${u};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              for (int d1 = 0; d1 < ${d}; d1 += 4) {\n                vec4 xValues = vec4(\n                  getX(batch, xF, xR, xC, d1),\n                  getX(batch, xF, xR, xC, d1 + 1),\n                  getX(batch, xF, xR, xC, d1 + 2),\n                  getX(batch, xF, xR, xC, d1 + 3)\n                );\n                vec4 wValues = vec4(\n                  getW(wF, wR, wC, d1, d2),\n                  getW(wF, wR, wC, d1 + 1, d2),\n                  getW(wF, wR, wC, d1 + 2, d2),\n                  getW(wF, wR, wC, d1 + 3, d2)\n                );\n\n                dotProd += dot(xValues, wValues);\n              }\n\n              if (${1===f}) {\n                dotProd +=\n                  getX(batch, xF, xR, xC, ${d}) *\n                  getW(wF, wR, wC, ${d}, d2);\n              } else if (${2===f}) {\n                vec2 xValues = vec2(\n                  getX(batch, xF, xR, xC, ${d}),\n                  getX(batch, xF, xR, xC, ${d} + 1)\n                );\n                vec2 wValues = vec2(\n                  getW(wF, wR, wC, ${d}, d2),\n                  getW(wF, wR, wC, ${d} + 1, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else if (${3===f}) {\n                vec3 xValues = vec3(\n                  getX(batch, xF, xR, xC, ${d}),\n                  getX(batch, xF, xR, xC, ${d} + 1),\n                  getX(batch, xF, xR, xC, ${d} + 2)\n                );\n                vec3 wValues = vec3(\n                  getW(wF, wR, wC, ${d}, d2),\n                  getW(wF, wR, wC, ${d} + 1, d2),\n                  getW(wF, wR, wC, ${d} + 2, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class gA{constructor(e,t,n){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e;const{filterWidth:s,inChannels:r,strideWidth:a,strideHeight:i,padInfo:o,outWidth:l,dilationWidth:u,dilationHeight:c,dataFormat:h}=n,{left:p,top:d}=o,f=r*s,m=ZS(),g="channelsLast"===h,y=g?0:1,b=g?1:2;let x="";for(let n=0;n<=1;n++)for(let s=0;s<=1;s++)x+=`\n          blockIndex = rc.y + ${s};\n          pos = rc.x + ${n};\n\n          if(blockIndex < ${e[1]} && pos < ${e[0]}) {\n            offsetY = int(blockIndex / (${l})) * ${i} - ${d};\n            d0 = offsetY + ${c} * (pos / ${f});\n\n            if(d0 < ${t[y]} && d0 >= 0) {\n\n              offsetX = int(mod(float(blockIndex), ${l}.) * ${a}. - ${p}.);\n              d1 = offsetX + ${u} * (int(mod(float(pos), ${f}.) / ${r}.));\n\n              if(d1 < ${t[b]} && d1 >= 0) {\n\n                ch = int(mod(float(pos), ${r}.));\n\n                if (${g}) {\n                  innerDims = vec2(d1, ch);\n                  result[${2*n+s}] = getChannel(\n                    getA(d0, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                } else {\n                  innerDims = vec2(d0, d1);\n                  result[${2*n+s}] = getChannel(\n                    getA(ch, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                }\n              }\n            }\n          }\n        `;this.userCode=`\n      void main() {\n        ivec2 rc = getOutputCoords();\n\n        vec4 result = vec4(0);\n\n        int blockIndex, pos, offsetY, d0, offsetX, d1, ch;\n        vec2 innerDims;\n\n        ${x}\n\n        ${m.output} = result;\n      }\n    `}}function yA({x:e,filter:t,convInfo:n,backend:s,bias:r=null,preluActivationWeights:a=null,leakyreluAlpha:i=0,activation:l=null}){const u=e.shape,c=s.texData.get(e.dataId),h=n.inChannels,p=u[0]*u[1]*u[2],d=n.outChannels,f="channelsLast"===n.dataFormat;let m;const g=[],y=(1===p||1===d)&&h>1e3,b=u[2]%2!=0&&!!c.isPacked;if(!y&&G().getBool("WEBGL_LAZILY_UNPACK")&&G().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&b){const h=f?u[0]*u[1]*(u[2]+1):u[0]*u[2]*(u[3]+1),p={dataId:e.dataId,shape:[1,h,n.inChannels],dtype:e.dtype},d=c.shape;c.shape=c.shape.slice(),c.shape[c.shape.length-2]++,o(US(c.shape,p.shape),()=>`packed reshape ${c.shape} to ${p.shape} isn't free`);const y=qE({inputs:{x:t},backend:s,attrs:{shape:[1,n.inChannels,n.outChannels]}});g.push(y);const b=a$({a:p,b:y,backend:s,transposeA:!1,transposeB:!1,bias:r,activation:l,preluActivationWeights:a,leakyreluAlpha:i}),x=s.texData.get(b.dataId);o(x.isPacked,()=>"batchMatMul result is expected to be packed"),c.shape=d,x.shape=n.outShape,m=TE({inputs:{x:b},backend:s}),m.shape=n.outShape,g.push(b)}else{const o=qE({inputs:{x:e},backend:s,attrs:{shape:[1,f?u[0]*u[1]*u[2]:u[0]*u[2]*u[3],n.inChannels]}}),c=qE({inputs:{x:t},backend:s,attrs:{shape:[1,n.inChannels,n.outChannels]}}),h=a$({a:o,b:c,transposeA:!1,transposeB:!1,backend:s,bias:r,activation:l,preluActivationWeights:a,leakyreluAlpha:i});m=qE({inputs:{x:h},backend:s,attrs:{shape:n.outShape}}),g.push(o),g.push(c),g.push(h)}for(const e of g)s.disposeIntermediateTensorInfo(e);return m}function bA({x:e,filter:t,convInfo:n,backend:s,bias:r=null,preluActivationWeights:a=null,leakyreluAlpha:i=0,activation:o=null}){const{filterWidth:l,filterHeight:u,inChannels:c,outWidth:p,outHeight:d,dataFormat:f}=n,m="channelsLast"===f,g=l*u*c,y=d*p,b=[g,y],x=[],w=qE({inputs:{x:e},backend:s,attrs:{shape:e.shape.slice(1)}}),k=qE({inputs:{x:t},backend:s,attrs:{shape:[1,g,h(t.shape)/g]}});x.push(w),x.push(k);const v=new gA(b,w.shape,n),N=s.runWebGLProgram(v,[w],"float32"),I=qE({inputs:{x:N},backend:s,attrs:{shape:[1,b[0],b[1]]}});x.push(N),x.push(I);const C=null!=r,S=null!=a,T="leakyrelu"===o,E=o?BE(o,!0):null,$=new PE(I.shape,k.shape,[1,y,n.outChannels],!0,!1,C,E,S,T),A=[I,k];if(r&&A.push(r),S&&A.push(a),T){const e=s.makeTensorInfo([],"float32",ns(i,"float32"));A.push(e),x.push(e)}const R=s.runWebGLProgram($,A,"float32"),F=qE({inputs:{x:R},backend:s,attrs:{shape:m?[1,d,p,n.outChannels]:[1,n.outChannels,d,p]}});x.push(R);for(const e of x)s.disposeIntermediateTensorInfo(e);return F}const xA={kernelName:"Conv2D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dataFormat:l,dilations:u,dimRoundingMode:c}=s,h=Pi(l),p=Ri(r.shape,a.shape,i,u,o,c,!1,h);let d;if(1!==p.filterHeight||1!==p.filterWidth||1!==p.dilationHeight||1!==p.dilationWidth||1!==p.strideHeight||1!==p.strideWidth||"SAME"!==p.padInfo.type&&"VALID"!==p.padInfo.type)if(G().getBool("WEBGL_CONV_IM2COL")&&1===r.shape[0])d=bA({x:r,filter:a,convInfo:p,backend:n});else{const e=new fA(p);d=n.runWebGLProgram(e,[r,a],"float32")}else d=yA({x:r,filter:a,convInfo:p,backend:n});const f=qE({inputs:{x:d},backend:n,attrs:{shape:p.outShape}});return n.disposeIntermediateTensorInfo(d),f}};class wA{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideHeight,n=e.strideWidth,s=e.padInfo.top,r=e.padInfo.left,a="channelsLast"===e.dataFormat;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int d2 = coords.w;\n\n        // Convolve x(?, ?, d1) with dy(:, :, d2) to get dw(wR, wC, d1, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${t} - ${s};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${r};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              if (${a}) {\n                float dyValue = getDy(b, yR, yC, d2);\n                float xValue = getX(b, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              } else {\n                float dyValue = getDy(b, d2, yR, yC);\n                float xValue = getX(b, d1, xR, xC);\n                dotProd += (xValue * dyValue);\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class kA{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a="channelsLast"===e.dataFormat,i=t-1-e.padInfo.top,o=n-1-e.padInfo.left,l=a?1:2,u=a?2:3,c=a?3:1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${o});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[${c}];\n\n        ivec2 dyCorner = ivec2(coords[${l}], coords[${u}]) - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n\n              if (${a}) {\n                float xValue = getDy(batch, idyR, idyC, d2);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              } else {\n                float xValue = getDy(batch, d2, idyR, idyC);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class vA{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideDepth,n=e.strideHeight,s=e.strideWidth,r=e.padInfo.front,a=e.padInfo.top,i=e.padInfo.left;this.userCode=`\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int wF = coords.x;\n        int wR = coords.y;\n        int wC = coords.z;\n        int d1 = coords.w;\n        int d2 = coords.u;\n\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yF = 0; yF < ${e.outDepth}; yF++) {\n            int xF = wF + yF * ${t} - ${r};\n\n            if (xF < 0 || xF >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int yR = 0; yR < ${e.outHeight}; yR++) {\n              int xR = wR + yR * ${n} - ${a};\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int yC = 0; yC < ${e.outWidth}; yC++) {\n                int xC = wC + yC * ${s} - ${i};\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float dyValue = getDy(b, yF, yR, yC, d2);\n                float xValue = getX(b, xF, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class NA{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterDepth,n=e.filterHeight,s=e.filterWidth,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=t-1-e.padInfo.front,l=n-1-e.padInfo.top,u=s-1-e.padInfo.left;this.userCode=`\n      const ivec3 pads = ivec3(${o}, ${l}, ${u});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.u;\n\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyFCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${t}; wF++) {\n          float dyF = float(dyFCorner + wF) / ${r}.0;\n\n          if (dyF < 0.0 || dyF >= ${e.outDepth}.0 || fract(dyF) > 0.0) {\n            continue;\n          }\n          int idyF = int(dyF);\n\n          int wFPerm = ${t} - 1 - wF;\n\n          for (int wR = 0; wR < ${n}; wR++) {\n            float dyR = float(dyRCorner + wR) / ${a}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n              fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            int wRPerm = ${n} - 1 - wR;\n\n            for (int wC = 0; wC < ${s}; wC++) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              int wCPerm = ${s} - 1 - wC;\n\n              for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n                float xValue = getDy(batch, idyF, idyR, idyC, d2);\n                float wValue = getW(wFPerm, wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const IA={kernelName:"Conv2DBackpropFilter",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,dataFormat:l,dimRoundingMode:u,filterShape:c}=s,h=Pi(l),p=Ri(r.shape,c,i,1,o,u,!1,h),d=new wA(p);return n.runWebGLProgram(d,[r,a],"float32")}};const CA={kernelName:"Conv2DBackpropInput",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{inputShape:i,strides:o,pad:l,dataFormat:u,dimRoundingMode:c}=s,h=Pi(u),p=Ri(i,a.shape,o,1,l,c,!1,h),d=new kA(p);return n.runWebGLProgram(d,[r,a],"float32")}};const SA={kernelName:"Conv3D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s,u=Fi(r.shape,a.shape,i,l,o),c=new mA(u);return n.runWebGLProgram(c,[r,a],"float32")}};const TA={kernelName:"Conv3DBackpropFilterV2",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,filterShape:l}=s,u=Fi(r.shape,l,i,1,o),c=new vA(u);return n.runWebGLProgram(c,[r,a],"float32")}};const EA={kernelName:"Conv3DBackpropInputV2",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{pad:i,strides:o,inputShape:l}=s,u=Fi(l,a.shape,o,1,i),c=new NA(u);return n.runWebGLProgram(c,[r,a],"float32")}},$A=LE({opSnippet:"if (isnan(x)) return x;\n  return cos(x);\n"}),AA={kernelName:$e,backendName:"webgl",kernelFunc:$A},RA={kernelName:"Cosh",backendName:"webgl",kernelFunc:LE({opSnippet:"\n  float e2x = exp(-x);\n  return (e2x + 1.0 / e2x) / 2.0;\n"})};class FA{constructor(e,t,n,s,r){this.variableNames=["Image","Boxes","BoxInd"],this.outputShape=[];const[a,i,o,l]=e,[u]=t,[c,h]=n;this.outputShape=[u,c,h,l];const p="bilinear"===s?1:0,[d,f]=[i-1+".0",o-1+".0"],[m,g,y]=c>1?[""+(i-1)/(c-1),"(y2-y1) * height_ratio",`y1*${d} + float(y)*(height_scale)`]:["0.0","0.0","0.5 * (y1+y2) * "+d],[b,x,w]=h>1?[""+(o-1)/(h-1),"(x2-x1) * width_ratio",`x1*${f} + float(x)*(width_scale)`]:["0.0","0.0","0.5 * (x1+x2) * "+f];this.userCode=`\n      const float height_ratio = float(${m});\n      const float width_ratio = float(${b});\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int y = coords[1];\n        int x = coords[2];\n        int d = coords[3];\n\n        // get box vals\n        float y1 = getBoxes(b,0);\n        float x1 = getBoxes(b,1);\n        float y2 = getBoxes(b,2);\n        float x2 = getBoxes(b,3);\n\n        // get image in batch index\n        int bInd = round(getBoxInd(b));\n        if(bInd < 0 || bInd >= ${a}) {\n          return;\n        }\n\n        float height_scale = ${g};\n        float width_scale = ${x};\n\n        float in_y = ${y};\n        if( in_y < 0.0 || in_y > ${d} ) {\n          setOutput(float(${r}));\n          return;\n        }\n        float in_x = ${w};\n        if( in_x < 0.0 || in_x > ${f} ) {\n          setOutput(float(${r}));\n          return;\n        }\n\n        vec2 sourceFracIndexCR = vec2(in_x,in_y);\n        if(${p} == 1) {\n          // Compute the four integer indices.\n          ivec2 sourceFloorCR = ivec2(sourceFracIndexCR);\n          ivec2 sourceCeilCR = ivec2(ceil(sourceFracIndexCR));\n\n          float topLeft = getImage(b, sourceFloorCR.y, sourceFloorCR.x, d);\n          float bottomLeft = getImage(b, sourceCeilCR.y, sourceFloorCR.x, d);\n          float topRight = getImage(b, sourceFloorCR.y, sourceCeilCR.x, d);\n          float bottomRight = getImage(b, sourceCeilCR.y, sourceCeilCR.x, d);\n\n          vec2 fracCR = sourceFracIndexCR - vec2(sourceFloorCR);\n\n          float top = topLeft + (topRight - topLeft) * fracCR.x;\n          float bottom = bottomLeft + (bottomRight - bottomLeft) * fracCR.x;\n          float newValue = top + (bottom - top) * fracCR.y;\n          setOutput(newValue);\n        } else {\n          // Compute the coordinators of nearest neighbor point.\n          ivec2 sourceNearestCR = ivec2(floor(\n            sourceFracIndexCR + vec2(0.5,0.5)));\n          float newValue = getImage(b, sourceNearestCR.y, sourceNearestCR.x, d);\n          setOutput(newValue);\n        }\n      }\n    `}}const DA={kernelName:"CropAndResize",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{image:r,boxes:a,boxInd:i}=t,{cropSize:o,method:l,extrapolationValue:u}=s,c=new FA(r.shape,a.shape,o,l,u);return n.runWebGLProgram(c,[r,a,i],"float32")}};class _A{constructor(e,t,n){this.variableNames=["x"],this.outputShape=e;const s=e.length,r=t?"0.0":`getX(${OA(s,"coords")})`,a=e[e.length-1];let i="",o="";t?(i=n?"end != "+(a-1):"end != 0",o=n?"end + 1":"end - 1"):(i=n?"end + pow2 < "+a:"end >= pow2",o=n?"end + pow2":"end - pow2"),this.userCode=`\n      uniform float index;\n      void main() {\n        ${AT(s)} coords = getOutputCoords();\n        int end = ${MA(s,"coords")};\n        float val = ${r};\n        int pow2 = int(pow(2.0, index));\n        if (${i}) {\n          int idx = ${o};\n          ${MA(s,"coords")} = idx;\n          val += getX(${OA(s,"coords")});\n        }\n        setOutput(val);\n      }\n    `}getCustomSetupFunc(e){return(t,n)=>{null==this.index&&(this.index=t.getUniformLocation(n,"index")),t.gl.uniform1f(this.index,e)}}}function OA(e,t){if(1===e)return""+t;if(2===e)return`${t}.x, ${t}.y`;if(3===e)return`${t}.x, ${t}.y, ${t}.z`;if(4===e)return`${t}.x, ${t}.y, ${t}.z, ${t}.w`;throw Error(`Cumulative sum for rank ${e} is not yet supported`)}function MA(e,t){if(1===e)return""+t;if(2===e)return t+".y";if(3===e)return t+".z";if(4===e)return t+".w";throw Error(`Cumulative sum for rank ${e} is not yet supported`)}const LA={kernelName:"Cumsum",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s,l=r.shape.length,u=wl([a],l);let c=r;null!=u&&(c=s$({inputs:{x:r},backend:n,attrs:{perm:u}}));const h=vl(1,l)[0];if(h!==l-1)throw new Error(`WebGL cumsum shader expects an inner-most axis=${r.shape.length-1} but got axis=`+a);const p=c.shape[h];let d=TE({inputs:{x:c},backend:n});for(let e=0;e<=Math.ceil(Math.log2(p))-1;e++){const t=new _A(c.shape,!1,o),s=t.getCustomSetupFunc(e),r=d;d=n.runWebGLProgram(t,[d],d.dtype,s),n.disposeIntermediateTensorInfo(r)}if(i){const e=new _A(c.shape,i,o),t=d;d=n.runWebGLProgram(e,[d],d.dtype),n.disposeIntermediateTensorInfo(t)}if(null!=u){const e=s$({inputs:{x:d},backend:n,attrs:{perm:kl(u)}});return n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(c),e}return d}};const zA={kernelName:"DenseBincount",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i,binaryOutput:o}=s;if(1===r.shape.length){const e=n.readSync(r.dataId),t=n.readSync(a.dataId),s=OT(e,t,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,s)}if(2===r.shape.length){const e=n.bufferSync(r),t=n.bufferSync(a),s=MT(e,t,i,o);return n.makeTensorInfo(s.shape,a.dtype,s.values)}throw new Error("Error in denseBincount: input must be at most rank 2, but got rank"+r.shape.length+".")}};class BA{constructor(e,t,n){this.variableNames=["x"],this.outputShape=[],this.outputShape=e,this.blockSize=t,this.dataFormat=n,this.userCode=`\n    void main() {\n      ivec4 coords = getOutputCoords();\n      int b = coords[0];\n      int h = ${this.getHeightCoordString()};\n      int w = ${this.getWidthCoordString()};\n      int d = ${this.getDepthCoordString()};\n\n      int in_h = h / ${t};\n      int offset_h = imod(h, ${t});\n      int in_w = w / ${t};\n      int offset_w = imod(w, ${t});\n      int offset_d = (offset_h * ${t} + offset_w) *\n        ${this.getOutputDepthSize()};\n      int in_d = d + offset_d;\n\n      float result = ${this.getInputSamplingString()};\n      setOutput(result);\n    }\n  `}getHeightCoordString(){return"NHWC"===this.dataFormat?"coords[1]":"coords[2]"}getWidthCoordString(){return"NHWC"===this.dataFormat?"coords[2]":"coords[3]"}getDepthCoordString(){return"NHWC"===this.dataFormat?"coords[3]":"coords[1]"}getOutputDepthSize(){return"NHWC"===this.dataFormat?this.outputShape[3]:this.outputShape[1]}getInputSamplingString(){return"NHWC"===this.dataFormat?"getX(b, in_h, in_w, in_d)":"getX(b, in_d, in_h, in_w)"}}const PA={kernelName:"DepthToSpace",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockSize:a,dataFormat:i}=s;o(a>1,()=>"blockSize should be > 1 for depthToSpace, but was: "+a);const l=r.shape[0],u="NHWC"===i?r.shape[1]:r.shape[2],c="NHWC"===i?r.shape[2]:r.shape[3],h="NHWC"===i?r.shape[3]:r.shape[1],p=u*a,d=c*a,f=h/(a*a),m=new BA("NHWC"===i?[l,p,d,f]:[l,f,p,d],a,i);return n.runWebGLProgram(m,[r],r.dtype)}};class WA{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const a=e.inHeight,i=e.inWidth,o=e.padInfo.top,l=e.padInfo.left,u=e.strideHeight,c=e.strideWidth,h=e.dilationHeight,p=e.dilationWidth,d=e.filterHeight,f=e.filterWidth,m=e.outChannels/e.inChannels;let g="",y="";n&&(g=s?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,y="result = activation(result);");const b=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${g}\n\n      const ivec2 strides = ivec2(${u}, ${c});\n      const ivec2 pads = ivec2(${o}, ${l});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${m};\n        int q = d2 - d1 * ${m};\n\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, q) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        // TO DO(dsmilkov): Flatten the two for loops and vec4 the operations.\n        for (int wR = 0; wR < ${d}; wR++) {\n          int xR = xRCorner + wR * ${h};\n\n          if (xR < 0 || xR >= ${a}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${f}; wC++) {\n            int xC = xCCorner + wC * ${p};\n\n            if (xC < 0 || xC >= ${i}) {\n              continue;\n            }\n\n            float xVal = getX(batch, xR, xC, d1);\n            float wVal = getW(wR, wC, d1, q);\n            dotProd += xVal * wVal;\n          }\n        }\n\n        float result = dotProd;\n        ${b}\n        ${y}\n        setOutput(result);\n      }\n    `}}class VA{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e.outShape;const i=e.inHeight,o=e.inWidth,l=e.padInfo.top,u=e.padInfo.left,c=e.strideHeight,h=e.strideWidth,p=e.dilationHeight,d=e.dilationWidth,f=e.filterHeight,m=e.filterWidth,g=m;let y="int xR; int xC; int xCOffset;";for(let e=0;e<f;e++)for(let t=0;t<m;t++)y+=`\n          vec4 xTexelR${e}C${2*t} = vec4(0.);\n          vec4 wR${e}C${t} = vec4(0.);\n          vec4 xR${e}C${t} = vec4(0.);`;for(let e=0;e<f;e++)for(let t=0;t<g;t++){const n=2*t;if(y+=`\n          xR = xRCorner + ${e*p};\n          xC = xCCorner + ${n*d};\n        `,1===h){if(n<m&&(y+=u%2==1?`\n                xCOffset = xC + 1;\n                if(xR >= 0 && xR < ${i} && xCOffset >= 0 && xCOffset < ${o}) {\n                  xTexelR${e}C${n} = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if(xCOffset + 1 >= ${o}) {\n                    xTexelR${e}C${n}.zw = vec2(0.);\n                  }\n                } else {\n                  xTexelR${e}C${n} = vec4(0.);\n                }\n\n                xCOffset = xC + 1 - 2;\n                if(xR >= 0 && xR < ${i} && xCOffset >= 0 && xCOffset < ${o}) {\n                  vec4 previous = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if(xCOffset + 1 >= ${o}) {\n                    previous.zw = vec2(0.);\n                  }\n\n                  xR${e}C${n} = vec4(previous.zw, xTexelR${e}C${n}.xy);\n                } else {\n                  xR${e}C${n} = vec4(0, 0, xTexelR${e}C${n}.xy);\n                }\n              `:`\n                if(xR >= 0 && xR < ${i} && xC >= 0 && xC < ${o}) {\n                  xTexelR${e}C${n} = getX(batch, xR, xC, d1);\n                } else {\n                  xTexelR${e}C${n} = vec4(0.);\n                }\n\n                xR${e}C${n} = xTexelR${e}C${n};\n              `,n+1<m)){const t=u%2==0?a(d):d;d%2==0&&u%2==1||d%2!=0&&u%2!=1?(y+=`\n                  xCOffset = xC + ${u%2} + ${t};\n\n                  if(xR >= 0 && xR < ${i} &&\n                    xCOffset >= 0 && xCOffset < ${o}) {\n                    xTexelR${e}C${n+2} = getX(batch, xR, xCOffset, d1);\n                  }\n                `,d>1&&(y+=`\n                    xCOffset -= 2;\n                    if(xR >= 0 && xR < ${i} &&\n                      xCOffset >= 0 && xCOffset < ${o}) {\n                      xTexelR${e}C${n} = getX(batch, xR, xCOffset, d1);\n                    } else {\n                      xTexelR${e}C${n} = vec4(0.);\n                    }\n                  `),y+=`\n                  xR${e}C${n+1} = vec4(\n                    xTexelR${e}C${n}.zw, xTexelR${e}C${n+2}.xy);\n                `):y+=`\n                  xCOffset = xC + ${t};\n\n                  if(xR >= 0 && xR < ${i} &&\n                    xCOffset >= 0 && xCOffset < ${o}) {\n                    xTexelR${e}C${n+2} = getX(batch, xR, xCOffset, d1);\n                  }\n\n                  xR${e}C${n+1} = xTexelR${e}C${n+2};\n                `}}else n<m&&(y+=`\n              if(xR >= 0 && xR < ${i}) {\n            `,u%2==1?(y+=`\n                xCOffset = xC + 1 - ${h};\n                if(xCOffset >= 0 && xCOffset < ${o}) {\n                  xTexelR${e}C${n} = getX(batch, xR, xCOffset, d1);\n                } else {\n                  xTexelR${e}C${n} = vec4(0.);\n                }\n\n                if(xC + 1 >= 0 && xC + 1 < ${o}) {\n                  xTexelR${e}C${n+2} = getX(batch, xR, xC + 1, d1);\n                } else {\n                  xTexelR${e}C${n+2} = vec4(0.);\n                }\n\n                xR${e}C${n} = vec4(\n                  xTexelR${e}C${n}.zw, xTexelR${e}C${n+2}.zw);\n              `,n+1<m&&(y+=`\n                  vec4 final = vec4(0.);\n                  xCOffset = xC + 1 + ${h};\n                  if(xCOffset >= 0 && xCOffset < ${o}) {\n                    final = getX(batch, xR, xCOffset, d1);\n                  }\n                  xR${e}C${n+1} = vec4(xTexelR${e}C${n+2}.xy, final.xy);\n                `)):(y+=`\n                if(xC >= 0 && xC < ${o}) {\n                  xTexelR${e}C${n} = getX(batch, xR, xC, d1);\n                } else {\n                  xTexelR${e}C${n} = vec4(0.);\n                }\n\n                xCOffset = xC + ${h};\n                if(xCOffset >= 0 && xCOffset < ${o}) {\n                  xTexelR${e}C${n+2} = getX(batch, xR, xCOffset, d1);\n                } else {\n                  xTexelR${e}C${n+2} = vec4(0.);\n                }\n\n                xR${e}C${n} = vec4(\n                  xTexelR${e}C${n}.xy, xTexelR${e}C${n+2}.xy);\n              `,n+1<m&&(y+=`\n                  xR${e}C${n+1} = vec4(\n                    xTexelR${e}C${n}.zw, xTexelR${e}C${n+2}.zw);\n                `)),y+="}");n<m&&(y+=`\n            vec4 wTexelR${e}C${n} = getW(${e}, ${n}, d1, q);\n            wR${e}C${n} = vec4(wTexelR${e}C${n}.xz, wTexelR${e}C${n}.xz);\n          `,n+1<m&&(y+=`\n              vec4 wTexelR${e}C${n+1} = getW(${e}, ${n+1}, d1, q);\n              wR${e}C${n+1} =\n                vec4(wTexelR${e}C${n+1}.xz, wTexelR${e}C${n+1}.xz);`))}for(let e=0;e<f;e++)for(let t=0;t<m;t++)y+=`dotProd += xR${e}C${t} * wR${e}C${t};`;let b="",x="";n&&(b=s?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`vec4 activation(vec4 x) {\n          ${n}\n        }`,x="result = activation(result);");const w=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${b}\n\n      const ivec2 strides = ivec2(${c}, ${h});\n      const ivec2 pads = ivec2(${l}, ${u});\n\n      void main() {\n\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2;\n        int q = 0;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        vec4 dotProd = vec4(0.);\n\n        ${y}\n\n        vec4 result = dotProd;\n        ${w}\n        ${x}\n        setOutput(result);\n      }\n    `}}const UA={kernelName:"DepthwiseConv2dNative",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:l,dilations:u,dimRoundingMode:c}=s;let h=u;null==h&&(h=[1,1]),o(Bi(i,h),()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${i} and dilations '${h}'`);const p=Ri(r.shape,a.shape,i,h,l,c,!0);let d;return d=G().getBool("WEBGL_PACK_DEPTHWISECONV")&&p.strideWidth<=2&&p.outChannels/p.inChannels==1?new VA(p):new WA(p),n.runWebGLProgram(d,[r,a],"float32")}};class GA{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideHeight,n=e.strideWidth,s=e.padInfo.top,r=e.padInfo.left,a=e.outChannels/e.inChannels;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int dm = coords.w;\n        int d2 = d1 * ${a} + dm;\n\n        float dotProd = 0.0;\n\n        // TO DO: Vec4 over the batch size\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${t} - ${s};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${r};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float dyValue = getDy(b, yR, yC, d2);\n              float xValue = getX(b, xR, xC, d1);\n              dotProd += (xValue * dyValue);\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class HA{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a=t-1-e.padInfo.top,i=n-1-e.padInfo.left,o=e.outChannels/e.inChannels;this.userCode=`\n      const ivec2 pads = ivec2(${a}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[3];\n        ivec2 dyCorner = coords.yz - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        float dotProd = 0.0;\n\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            // TO DO: Vec4 over the channelMul\n            for (int dm = 0; dm < ${o}; dm++) {\n              int d2 = d1 * ${o} + dm;\n              float xValue = getDy(batch, idyR, idyC, d2);\n              float wValue = getW(wRPerm, wCPerm, d1, dm);\n              dotProd += xValue * wValue;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const jA={kernelName:"DepthwiseConv2dNativeBackpropFilter",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,filterShape:c}=s,h=Ri(r.shape,c,i,o,l,u,!0),p=new GA(h);return n.runWebGLProgram(p,[r,a],"float32")}};const qA={kernelName:"DepthwiseConv2dNativeBackpropInput",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,inputShape:c}=s,h=Ri(c,a.shape,i,o,l,u,!0),p=new HA(h);return n.runWebGLProgram(p,[r,a],"float32")}};class KA{constructor(e){this.variableNames=["X"],this.outputShape=[e,e],this.userCode="\n      void main() {\n          ivec2 coords = getOutputCoords();\n          float val = coords[0] == coords[1] ? getX(coords[0]) : 0.0;\n          setOutput(val);\n      }\n    "}}const XA={kernelName:"Diag",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=[...s.shape,...s.shape],a=h(s.shape),i=qE({inputs:{x:s},backend:n,attrs:{shape:[a]}}),o=new KA(a),l=n.runWebGLProgram(o,[i],i.dtype),u=qE({inputs:{x:l},backend:n,attrs:{shape:r}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(l),u}};class YA{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const{inHeight:t,inWidth:n,padInfo:s,strideHeight:r,strideWidth:a,filterHeight:i,filterWidth:o,dilationHeight:l,dilationWidth:u}=e,{top:c,left:h}=s;this.userCode=`\n      const ivec2 strides = ivec2(${r}, ${a});\n      const ivec2 pads = ivec2(${c}, ${h});\n      const float neg_infinity = -3.4e38;\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.w;\n        ivec2 outTopLeftCorner =\n            coords.yz * strides - pads;\n        int hBeg = outTopLeftCorner.x;\n        int wBeg = outTopLeftCorner.y;\n\n        float curVal = neg_infinity;\n        for (int h = 0; h < ${i}; h++) {\n          int hIn = hBeg + h * ${l};\n\n          if (hIn >= 0 && hIn < ${t}) {\n            for (int w = 0; w < ${o}; w++) {\n              int wIn = wBeg + w * ${u};\n\n              if (wIn >= 0 && wIn < ${n}) {\n                float xVal = getX(batch, hIn, wIn, d1);\n                float wVal = getW(h, w, d1);\n\n                float val = xVal + wVal;\n                if (val > curVal) {\n                  curVal = val;\n                }\n              }\n            }\n          }\n        }\n\n        float result = curVal;\n        setOutput(result);\n      }\n    `}}const JA={kernelName:"Dilation2D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s,u=Ei(r.shape,a.shape,i,o,"NHWC",l);let c;const h=new YA(u);c=n.runWebGLProgram(h,[r,a],"float32");const p=qE({inputs:{x:c},backend:n,attrs:{shape:u.outShape}});return n.disposeIntermediateTensorInfo(c),p}},ZA=LE({opSnippet:"return (x >= 0.0) ? x : (exp(x) - 1.0);",packedOpSnippet:"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n"}),QA={kernelName:Ue,backendName:"webgl",kernelFunc:ZA},eR={kernelName:"EluGrad",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n}=e,{dy:s,y:r}=t,a=G().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new SE("\n  vec4 bGTEZero = vec4(greaterThanEqual(b, vec4(0.)));\n  return (bGTEZero * a) + ((vec4(1.0) - bGTEZero) * (a * (b + vec4(1.0))));\n",s.shape,r.shape):new CE("return (b >= 1.0) ? a : a * (b + 1.0);",s.shape,r.shape);return n.runWebGLProgram(a,[s,r],s.dtype)}},tR={kernelName:"Equal",backendName:"webgl",kernelFunc:zE({opSnippet:"return float(a == b);",packedOpSnippet:"\n  return vec4(equal(a, b));\n",dtype:"bool"})},nR=LE({opSnippet:'\n  // Error function is calculated approximately with elementary function.\n  // See "Handbook of Mathematical Functions with Formulas,\n  // Graphs, and Mathematical Tables", Abramowitz and Stegun.\n  float p = 0.3275911;\n  float a1 = 0.254829592;\n  float a2 = -0.284496736;\n  float a3 = 1.421413741;\n  float a4 = -1.453152027;\n  float a5 = 1.061405429;\n\n  float sign = sign(x);\n  x = abs(x);\n  float t = 1.0 / (1.0 + p * x);\n  return sign * (1.0 - (((((a5*t + a4)*t) + a3)*t + a2)*t + a1)*t*exp(-x*x));\n'}),sR={kernelName:He,backendName:"webgl",kernelFunc:nR},rR="return exp(x);",aR=LE({opSnippet:rR,packedOpSnippet:rR,cpuKernelImpl:BT}),iR={kernelName:qe,backendName:"webgl",kernelFunc:aR};function oR(e){const{inputs:t,attrs:n,backend:s}=e,{dim:r}=n,{input:a}=t,i=a.shape.length,l=a.shape.slice();let u=r;return r<0&&(o(-(i+1)<=r,()=>`Axis must be in the interval [${-(i+1)}, ${i}]`),u=i+r+1),l.splice(u,0,1),qE({inputs:{x:a},backend:s,attrs:{shape:l}})}const lR={kernelName:"ExpandDims",backendName:"webgl",kernelFunc:oR},uR="return exp(x) - 1.0;",cR={kernelName:"Expm1",backendName:"webgl",kernelFunc:LE({opSnippet:uR,packedOpSnippet:uR,cpuKernelImpl:PT})};class hR{constructor(e,t,n){this.variableNames=["real","imag"];const s=t[1];this.outputShape=t;const r=n?"2.0 * "+Math.PI:"-2.0 * "+Math.PI,a=n?s+".0":"1.0";let i;if("real"===e)i="return real * expR - imag * expI;";else{if("imag"!==e)throw new Error(`FFT component must be either "real" or "imag", got ${e}.`);i="return real * expI + imag * expR;"}this.userCode=`\n      const float exponentMultiplier = ${r};\n\n      float unaryOpComplex(float real, float expR, float imag, float expI) {\n        ${i}\n      }\n\n      float mulMatDFT(int batch, int index) {\n        float indexRatio = float(index) / float(${s});\n        float exponentMultiplierTimesIndexRatio =\n            exponentMultiplier * indexRatio;\n\n        float result = 0.0;\n\n        for (int i = 0; i < ${s}; i++) {\n          // x = (-2|2 * PI / N) * index * i;\n          float x = exponentMultiplierTimesIndexRatio * float(i);\n          float expR = cos(x);\n          float expI = sin(x);\n          float real = getReal(batch, i);\n          float imag = getImag(batch, i);\n\n          result +=\n              unaryOpComplex(real, expR, imag, expI) / ${a};\n        }\n\n        return result;\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        setOutput(mulMatDFT(coords[0], coords[1]));\n      }\n    `}}function pR(e,t,n){const s=n.texData.get(e.dataId),r=h(e.shape),a=e.shape[e.shape.length-1],i=qE({inputs:{x:e},backend:n,attrs:{shape:[r/a,a]}}),o=i.shape,l=new hR("real",o,t),u=new hR("imag",o,t),c=[{dataId:s.complexTensorInfos.real.dataId,dtype:s.complexTensorInfos.real.dtype,shape:o},{dataId:s.complexTensorInfos.imag.dataId,dtype:s.complexTensorInfos.imag.dtype,shape:o}],p=n.runWebGLProgram(l,c,"float32"),d=n.runWebGLProgram(u,c,"float32"),f=$E({inputs:{real:p,imag:d},backend:n});n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(d);const m=qE({inputs:{x:f},backend:n,attrs:{shape:e.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(f),m}const dR={kernelName:"FFT",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t;return pR(s,!1,n)}};class fR{constructor(e,t){this.outputShape=[],this.variableNames=["x"],this.outputShape=e,this.userCode="\n      uniform float value;\n      void main() {\n        // Input can be obtained from uniform value.\n        setOutput(value);\n      }\n    "}getCustomSetupFunc(e){return(t,n)=>{null==this.valueLoc&&(this.valueLoc=t.getUniformLocationNoThrow(n,"value")),t.gl.uniform1f(this.valueLoc,e)}}}function mR(e){const{backend:t,attrs:n}=e,{shape:s,value:r}=n;let{dtype:a}=n;if(a=a||R(r),"string"===a){const e=k(a,h(s));return e.fill(r),t.makeTensorInfo(s,a,e)}{const e=new fR(s,r),n=e.getCustomSetupFunc(r);return t.runWebGLProgram(e,[],a,n)}}const gR={kernelName:"Fill",backendName:"webgl",kernelFunc:mR};class yR{constructor(e){this.variableNames=["Image"],this.outputShape=[];const t=e[2];this.outputShape=e,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n\n          int coordX = ${t} - x;\n          float outputValue;\n          if(coordX >= 0 && coordX < ${t}) {\n            outputValue = getImage(coords[0], coords[1], coordX, coords[3]);\n          } else {\n            outputValue = getImage(coords[0], coords[1], coords[2], coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const bR={kernelName:"FlipLeftRight",backendName:"webgl",kernelFunc:({inputs:e,backend:t})=>{const{image:n}=e,s=t,r=new yR(n.shape);return s.runWebGLProgram(r,[n],n.dtype)}},xR="return floor(x);",wR={kernelName:"Floor",backendName:"webgl",kernelFunc:LE({opSnippet:xR,packedOpSnippet:xR,cpuKernelImpl:WT})},kR={kernelName:"FloorDiv",backendName:"webgl",kernelFunc:zE({opSnippet:"\n  float s = sign(a) * sign(b);\n  int ia = round(a);\n  int ib = round(b);\n  if (ib != 0) {\n    // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n    return float(idiv(ia, ib, s));\n  } else {\n    return NAN;\n  }\n",packedOpSnippet:"\n  ivec4 ia = round(a);\n  ivec4 ib = round(b);\n  bvec4 cond = notEqual(ib, ivec4(0));\n  ivec4 result = ivec4(0);\n  vec4 s = sign(a) * sign(b);\n\n  // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n  if (cond[0]) {\n    result[0] = idiv(ia[0], ib[0], s[0]);\n  }\n  if (cond[1]) {\n    result[1] = idiv(ia[1], ib[1], s[1]);\n  }\n  if (cond[2]) {\n    result[2] = idiv(ia[2], ib[2], s[2]);\n  }\n  if (cond[3]) {\n    result[3] = idiv(ia[3], ib[3], s[3]);\n  }\n  return vec4(result);\n",dtype:"int32"})};class vR{constructor(e){this.variableNames=["A"];const t=ZS(),[n,s]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n        vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${s}.0, ${n}.0);\n\n        vec4 values = ${t.texture2D}(A, uv);\n        float value;\n        if (depth == 0) {\n          value = values.r;\n        } else if (depth == 1) {\n          value = values.g;\n        } else if (depth == 2) {\n          value = values.b;\n        } else if (depth == 3) {\n          value = values.a;\n        }\n\n        setOutput(floor(value * 255.0 + 0.5));\n      }\n    `}}class NR{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const t=ZS(),[n,s]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n\n        vec4 result = vec4(0.);\n\n        for(int row=0; row<=1; row++) {\n          for(int col=0; col<=1; col++) {\n            texC = coords[1] + row;\n            depth = coords[2] + col;\n\n            vec2 uv = (vec2(texC, texR) + halfCR) /\n                       vec2(${s}.0, ${n}.0);\n            vec4 values = ${t.texture2D}(A, uv);\n            float value;\n            if (depth == 0) {\n              value = values.r;\n            } else if (depth == 1) {\n              value = values.g;\n            } else if (depth == 2) {\n              value = values.b;\n            } else if (depth == 3) {\n              value = values.a;\n            }\n\n            result[row * 2 + col] = floor(value * 255.0 + 0.5);\n          }\n        }\n\n        ${t.output} = result;\n      }\n    `}}const IR={kernelName:"FromPixels",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e;let{pixels:r}=t;const{numChannels:a}=s,i="undefined"!=typeof HTMLVideoElement&&r instanceof HTMLVideoElement,o="undefined"!=typeof HTMLImageElement&&r instanceof HTMLImageElement,l="undefined"!=typeof ImageBitmap&&r instanceof ImageBitmap,[u,c]=i?[r.videoWidth,r.videoHeight]:[r.width,r.height],h=[c,u],p=[c,u,a];(o||i||l)&&(null==CR&&(CR=document.createElement("canvas").getContext("2d")),CR.canvas.width=u,CR.canvas.height=c,CR.drawImage(r,0,0,u,c),r=CR.canvas);const d=n.makeTensorInfo(h,"int32");n.texData.get(d.dataId).usage=wS.PIXELS,n.gpgpu.uploadPixelDataToTexture(n.getTexture(d.dataId),r);const f=G().getBool("WEBGL_PACK")?new NR(p):new vR(p),m=n.runWebGLProgram(f,[d],"int32");return n.disposeData(d.dataId),m}};let CR;const SR={kernelName:"FusedConv2D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s,m=Pi(c),g=Ri(r.shape,a.shape,l,h,u,p,!1,m);let y;const b=[];if(1!==g.filterHeight||1!==g.filterWidth||1!==g.dilationHeight||1!==g.dilationWidth||1!==g.strideHeight||1!==g.strideWidth||"SAME"!==g.padInfo.type&&"VALID"!==g.padInfo.type)if(G().getBool("WEBGL_CONV_IM2COL")&&1===r.shape[0])y=bA({x:r,filter:a,convInfo:g,backend:n,bias:i,activation:d,preluActivationWeights:o,leakyreluAlpha:f});else{const e=null!=i,t=null!=o,s="leakyrelu"===d,l=d?BE(d,!1):null,u=new fA(g,e,l,t,s),c=[r,a];if(i&&c.push(i),o&&c.push(o),s){const e=n.makeTensorInfo([],"float32",ns(f,"float32"));c.push(e),b.push(e)}y=n.runWebGLProgram(u,c,"float32")}else y=yA({x:r,filter:a,convInfo:g,backend:n,bias:i,activation:d,preluActivationWeights:o,leakyreluAlpha:f});const x=qE({inputs:{x:y},backend:n,attrs:{shape:g.outShape}});return b.push(y),b.forEach(e=>n.disposeIntermediateTensorInfo(e)),x}};const TR={kernelName:"FusedDepthwiseConv2D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:l}=t,{strides:u,pad:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s,m=[];let g=h;null==g&&(g=[1,1]),o(Bi(u,g),()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${u} and dilations '${g}'`);const y=Ri(r.shape,a.shape,u,g,c,p,!0),b=G().getBool("WEBGL_PACK_DEPTHWISECONV")&&y.strideWidth<=2&&y.outChannels/y.inChannels==1,x=d?BE(d,b):null,w=[r,a],k=null!=i,v=null!=l,N="leakyrelu"===d;if(k&&w.push(i),v&&w.push(l),N){const e=n.makeTensorInfo([],"float32",ns(f,"float32"));w.push(e),m.push(e)}let I;I=b?new VA(y,k,x,v,N):new WA(y,k,x,v,N);const C=n.runWebGLProgram(I,w,"float32");return m.forEach(e=>n.disposeIntermediateTensorInfo(e)),C}};class ER{constructor(e,t,n){this.sliceDim=e,this.strides=t,this.variableNames=["x","indices"],this.outputShape=n;const s=AT(t.length),r=AT(n.length),a=this.sliceDim>1?"strides[j]":"strides";this.userCode=`\n        ${s} strides = ${s}(${this.strides});\n         void main() {\n          ${r} coords = getOutputCoords();\n          int flattenIndex = 0;\n          for (int j = 0; j < ${this.sliceDim}; j++) {\n            int index = round(getIndices(coords[0], j));\n            flattenIndex += index * ${a};\n          }\n          setOutput(getX(flattenIndex, coords[1]));\n        }\n      `}}const $R={kernelName:"GatherNd",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{params:s,indices:r}=t,a=r.shape,i=a[a.length-1],[o,l,u,c]=ha(s,r),p=qE({inputs:{x:r},backend:n,attrs:{shape:[l,i]}}),d=qE({inputs:{x:s},backend:n,attrs:{shape:[h(s.shape)/u,u]}}),f=new ER(i,c,[l,u]),m=n.runWebGLProgram(f,[d,p],d.dtype),g=qE({inputs:{x:m},backend:n,attrs:{shape:o}});return n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(m),g}};class AR{constructor(e,t){this.variableNames=["A","indices"],this.outputShape=t,this.rank=t.length;const n=AT(this.rank),s=function(e,t){const n=["resRC.x","resRC.y","resRC.z","resRC.w"],s=[];for(let t=0;t<e.length;t++)2===t?s.push("int(getIndices(resRC.x, resRC.z))"):s.push(""+n[t]);return s.join()}(e);this.userCode=`\n      void main() {\n        ${n} resRC = getOutputCoords();\n        setOutput(getA(${s}));\n      }\n    `}}const RR={kernelName:"GatherV2",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,indices:a}=t,{axis:i,batchDims:o}=s,l=rp(r,a,b(i,r.shape)[0],o),u=h(a.shape),c=[],p=qE({inputs:{x:r},backend:n,attrs:{shape:[l.batchSize,l.outerSize,l.dimSize,l.sliceSize]}}),d=qE({inputs:{x:a},backend:n,attrs:{shape:[l.batchSize,u/l.batchSize]}});c.push(p),c.push(d);const f=[l.batchSize,l.outerSize,u/l.batchSize,l.sliceSize];if(n.shouldExecuteOnCPU([r,a])||"string"===r.dtype){const e=n.bufferSync(d),t=n.bufferSync(p),s=VT(t,e,f);return c.forEach(e=>n.disposeIntermediateTensorInfo(e)),n.makeTensorInfo(l.outputShape,s.dtype,s.values)}const m=new AR(p.shape,f),g=n.runWebGLProgram(m,[p,d],p.dtype);c.push(g);const y=qE({inputs:{x:g},backend:n,attrs:{shape:l.outputShape}});return c.forEach(e=>n.disposeIntermediateTensorInfo(e)),y}},FR={kernelName:"Greater",backendName:"webgl",kernelFunc:zE({opSnippet:"return float(a > b);",packedOpSnippet:"\n  return vec4(greaterThan(a, b));\n",cpuKernelImpl:UT,dtype:"bool"})},DR={kernelName:"GreaterEqual",backendName:"webgl",kernelFunc:zE({opSnippet:"return float(a >= b);",packedOpSnippet:"\n  return vec4(greaterThanEqual(a, b));\n",dtype:"bool"})};const _R={kernelName:"IFFT",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t;return pR(s,!0,n)}},OR={kernelName:"IsFinite",backendName:"webgl",kernelFunc:LE({opSnippet:"return float(!isnan(x) && !isinf(x));",dtype:"bool"})},MR={kernelName:"IsInf",backendName:"webgl",kernelFunc:LE({opSnippet:"return float(isinf(x));",dtype:"bool"})},LR={kernelName:"IsNan",backendName:"webgl",kernelFunc:LE({opSnippet:"return float(isnan(x));",dtype:"bool"})},zR={kernelName:"Less",backendName:"webgl",kernelFunc:zE({opSnippet:"return float(a < b);",packedOpSnippet:"\n  return vec4(lessThan(a, b));\n",cpuKernelImpl:GT,dtype:"bool"})},BR={kernelName:"LessEqual",backendName:"webgl",kernelFunc:zE({opSnippet:"return float(a <= b);",packedOpSnippet:"\n  return vec4(lessThanEqual(a, b));\n",dtype:"bool"})};const PR={kernelName:"LinSpace",backendName:"webgl",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,num:a}=n,i=HT(s,r,a);return t.makeTensorInfo([i.length],"float32",i)}},WR=LE({opSnippet:"if (x < 0.0) return NAN;\n  return log(x);",packedOpSnippet:"\n  vec4 result = log(x);\n  vec4 isNaN = vec4(lessThan(x, vec4(0.0)));\n  result.r = isNaN.r == 1.0 ? NAN : result.r;\n  result.g = isNaN.g == 1.0 ? NAN : result.g;\n  result.b = isNaN.b == 1.0 ? NAN : result.b;\n  result.a = isNaN.a == 1.0 ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:jT}),VR={kernelName:gt,backendName:"webgl",kernelFunc:WR},UR={kernelName:"Log1p",backendName:"webgl",kernelFunc:LE({opSnippet:"return log(1.0 + x);"})},GR={kernelName:"LogicalAnd",backendName:"webgl",kernelFunc:zE({opSnippet:"return float(a >= 1.0 && b >= 1.0);",packedOpSnippet:"\n  return vec4(\n    vec4(greaterThanEqual(a, vec4(1.0))) *\n    vec4(greaterThanEqual(b, vec4(1.0))));\n",dtype:"bool"})},HR={kernelName:"LogicalNot",backendName:"webgl",kernelFunc:LE({opSnippet:"return float(!(x >= 1.0));"})},jR={kernelName:"LogicalOr",backendName:"webgl",kernelFunc:zE({opSnippet:"return float(a >= 1.0 || b >= 1.0);",packedOpSnippet:"\n  return min(\n    vec4(greaterThanEqual(a, vec4(1.0))) +\n    vec4(greaterThanEqual(b, vec4(1.0))),\n    vec4(1.0));\n",dtype:"bool"})};class qR{constructor(e,t,n,s,r){this.variableNames=["x"],this.outputShape=[];const a=t,i=e[3]-1;let o;this.outputShape=e;const l=`float(${n}) + float(${s}) * sum`;o=.5===r?`inversesqrt(${l})`:1===r?`1.0/(${l})`:`exp(log(${l}) * float(-${r}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n        int d = coords[3];\n        float x = getX(b, r, c, d);\n        float sum = 0.0;\n        for (int j = -${a}; j <= ${a}; j++) {\n          int idx = d + j;\n          if (idx >= 0 && idx <=  ${i}) {\n            float z = getX(b, r, c, idx);\n            sum += z * z;\n          }\n        }\n        float val = x * ${o};\n        setOutput(val);\n      }\n    `}}class KR{constructor(e,t,n,s,r){this.variableNames=["x"],this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0;const a=t,i=e[3]-1;let o;this.outputShape=e;const l=`float(${n}) + float(${s}) * sum`;o=.5===r?`inversesqrt(${l})`:1===r?`1.0/(${l})`:`exp(log(${l}) * float(-${r}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords.x;\n        int r = coords.y;\n        int c = coords.z;\n        int d = coords.w;\n\n        bool hasNextCol = d < ${this.outputShape[3]};\n        bool hasNextRow = c < ${this.outputShape[2]};\n\n        vec4 sum = vec4(0.);\n        vec4 xFragAtOutputCoords = getX(b, r, c, d);\n\n        vec4 xAtOutputCoords = vec4(\n          getChannel(xFragAtOutputCoords, vec2(c, d)),\n          hasNextCol ?\n            getChannel(xFragAtOutputCoords, vec2(c, d + 1)) : 0.0,\n          hasNextRow ?\n            getChannel(xFragAtOutputCoords , vec2(c + 1, d)) : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getChannel(xFragAtOutputCoords, vec2(c + 1, d + 1)) : 0.0\n        );\n\n        int firstChannel = d - ${a};\n        vec2 cache = vec2(0.);\n        if(firstChannel >= 0){\n          vec4 firstChannelFrag = getX(b, r, c, firstChannel);\n          cache.x = getChannel(firstChannelFrag, vec2(c, firstChannel));\n            if(hasNextRow){\n              cache.y = getChannel(firstChannelFrag, vec2(c + 1, firstChannel));\n            }\n        }\n\n        ivec2 depth = ivec2(d, d + 1);\n        for (int j = - ${a}; j <= ${a}; j++) {\n          ivec2 idx = depth + j;\n          bvec2 aboveLowerBound = greaterThanEqual(idx, ivec2(0));\n          bvec2 belowUpperBound = lessThanEqual(idx, ivec2(${i}));\n\n          bool depthInRange = aboveLowerBound.x && belowUpperBound.x;\n          bool depthPlusOneInRange = aboveLowerBound.y && belowUpperBound.y;\n\n          if(depthInRange || depthPlusOneInRange){\n            vec4 z = vec4(0.);\n            vec4 xFragAtCurrentDepth;\n            z.xz = cache.xy;\n            if(depthPlusOneInRange && hasNextCol){\n              xFragAtCurrentDepth = idx.y != d ?\n                getX(b, r, c, idx.y) : xFragAtOutputCoords;\n              z.y = getChannel(xFragAtCurrentDepth, vec2(c, idx.y));\n              if(hasNextRow){\n                z.w = getChannel(xFragAtCurrentDepth, vec2(c + 1, idx.y));\n              }\n            }\n            cache.xy = z.yw;\n            sum += z * z;\n          }\n        }\n        vec4 result = xAtOutputCoords * ${o};\n        setOutput(result);\n      }\n    `}}const XR={kernelName:"LRN",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{depthRadius:a,bias:i,alpha:o,beta:l}=s,u=G().getBool("WEBGL_PACK_NORMALIZATION")?new KR(r.shape,a,i,o,l):new qR(r.shape,a,i,o,l);return n.runWebGLProgram(u,[r],r.dtype)}};class YR{constructor(e,t,n,s,r){this.variableNames=["inputImage","outputImage","dy"],this.outputShape=[],this.outputShape=e,this.depth=e[3],this.depthRadius=t,this.bias=n,this.alpha=s,this.beta=r,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n\n        float result = 0.0;\n        for (int d = 0; d < ${this.depth}; ++d) {\n          int depthBegin = int(max(0.0, float(d - ${t})));\n          int depthEnd = int(min(float(${this.depth}),\n              float(d + ${t} + 1)));\n\n          const int MIN_DEPTH_BEGIN = 0;\n          const int MAX_DEPTH_END = ${this.depth};\n\n          float norm = 0.0;\n          for (int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k) {\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd) {\n              norm += getInputImage(b, r, c, k) * getInputImage(b, r, c, k);\n            }\n            else {\n              break;\n            }\n          }\n\n          norm = float(${s}) * norm + float(${n});\n\n          for(int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k){\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd){\n              float dyi = -2.0 * float(${s})\n                * float(${r})\n                * getInputImage(b ,r ,c, k) * getOutputImage(b, r, c, d)\n                / norm;\n              if (k == d) {\n                dyi += pow(norm, -1.0 * ${r});\n              }\n              if (k == coords[3]) {\n                dyi *= getDy(b, r, c, d);\n                result += dyi;\n              }\n            }\n            else {\n              break;\n            }\n          }\n      }\n      setOutput(result);\n      }\n    `}}const JR={kernelName:"LRNGrad",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r,y:a,dy:i}=t,{depthRadius:o,bias:l,alpha:u,beta:c}=s,h=new YR(r.shape,o,l,u,c);return n.runWebGLProgram(h,[r,a,i],r.dtype)}};function ZR(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reductionIndices:a,keepDims:i}=s,o=r.shape.length,l=b(a,r.shape);let u=l;const c=wl(u,o),p=null!=c,d=n.shouldExecuteOnCPU([r]);let f=r;if(p){if(d){const e=n.texData.get(f.dataId).values,t=new Array(o);for(let e=0;e<t.length;e++)t[e]=r.shape[c[e]];const s=oE(e,r.shape,r.dtype,c,t);f=n.makeTensorInfo(t,r.dtype),n.texData.get(f.dataId).values=s}else f=e$(r,c,n);u=vl(u.length,o)}xl("max",u,o);const[m,g]=yl(f.shape,u);let y,x=m;if(i&&(x=bl(m,l)),d){const e=n.texData.get(f.dataId).values,t=qT(e,h(g),x,r.dtype);y=n.makeTensorInfo(x,r.dtype),n.texData.get(y.dataId).values=t}else y=function(e,t,n,s){const r=h(t),a=qE({inputs:{x:e},attrs:{shape:[h(e.shape)/r,r]},backend:s}),i=JE(a,e.dtype,"max",s),o=qE({inputs:{x:i},attrs:{shape:n},backend:s});return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}(f,g,x,n);return p&&n.disposeIntermediateTensorInfo(f),y}const QR={kernelName:"Max",backendName:"webgl",kernelFunc:ZR},eF={kernelName:"Maximum",backendName:"webgl",kernelFunc:zE({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return max(a, b);\n",packedOpSnippet:"\n  vec4 result = vec4(max(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:KT})};const tF={kernelName:"MaxPool",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;YS(r,"maxPool");const{filterSize:a,strides:i,pad:l,dimRoundingMode:u}=s;o(Bi(i,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`);const c=$i(r.shape,a,i,1,l,u);if(1===c.filterWidth&&1===c.filterHeight&&p(c.inShape,c.outShape))return TE({inputs:{x:r},backend:n});const h=new E$(c,"max",!1);return n.runWebGLProgram(h,[r],r.dtype)}};const nF={kernelName:"MaxPool3D",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dataFormat:l,dimRoundingMode:u}=s,c=Ai(r.shape,a,i,[1,1,1],o,u,l),h=new $$(c,"max",!1);return n.runWebGLProgram(h,[r],r.dtype)}};class sF{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const t=e.strideHeight,n=e.strideWidth,s=e.dilationHeight,r=e.effectiveFilterHeight,a=e.effectiveFilterWidth,i=r-1-e.padInfo.top,o=a-1-e.padInfo.left,l=r*a-1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${o});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${r};\n          wR += ${s}) {\n          float dyR = float(dyRCorner + wR) / ${t}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${a}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${n}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n            int maxPosValue = ${l} - int(getMaxPos(b, idyR, idyC, d));\n\n            // Get the current value, check it against the value from the\n            // position matrix.\n            int curPosValue = wR * ${a} + wC;\n            float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n            dotProd += dyValue * mask;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class rF{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const t=e.strideDepth,n=e.strideHeight,s=e.strideWidth,r=e.dilationDepth,a=e.dilationHeight,i=e.dilationWidth,o=e.effectiveFilterDepth,l=e.effectiveFilterHeight,u=e.effectiveFilterWidth,c=o-1-e.padInfo.front,h=l-1-e.padInfo.top,p=u-1-e.padInfo.left,d=o*l*u-1;this.userCode=`\n      const ivec3 pads = ivec3(${c}, ${h}, ${p});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, ch) with pos mask(:, :, :, d) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${o};\n           wD += ${r}) {\n          float dyD = float(dyDCorner + wD) / ${t}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${l};\n              wR += ${a}) {\n            float dyR = float(dyRCorner + wR) / ${n}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${u};\n                wC += ${i}) {\n              float dyC = float(dyCCorner + wC) / ${s}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n              int maxPosValue = ${d} -\n                  int(getMaxPos(batch, idyD, idyR, idyC, ch));\n\n              // Get the current value, check it against the value from the\n              // position matrix.\n              int curPosValue =\n                  wD * ${l} * ${u} +\n                  wR * ${u} + wC;\n              float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n              dotProd += dyValue * mask;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const aF={kernelName:"MaxPool3DGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a,{filterSize:o,strides:l,pad:u,dimRoundingMode:c}=s,h=Ai(i.shape,o,l,[1,1,1],u,c),p=new $$(h,"max",!0),d=n.runWebGLProgram(p,[i],i.dtype),f=new rF(h),m=n.runWebGLProgram(f,[r,d],i.dtype);return n.disposeIntermediateTensorInfo(d),m}};const iF={kernelName:"MaxPoolGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a,output:i}=t,o=a;YS([a,i],"maxPoolGrad");const{filterSize:l,strides:u,pad:c,dimRoundingMode:h}=s,p=$i(o.shape,l,u,1,c,h),d=new E$(p,"max",!0),f=n.runWebGLProgram(d,[o],o.dtype),m=new sF(p),g=n.runWebGLProgram(m,[r,f],o.dtype);return n.disposeIntermediateTensorInfo(f),g}};const oF={kernelName:"MaxPoolWithArgmax",backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{filterSize:r,strides:a,pad:i,includeBatchInIndex:l}=t,u=n;o(4===s.shape.length,()=>`Error in maxPool: input must be rank 4 but got rank ${s.shape.length}.`);const c=[1,1];o(Bi(a,c),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${a} and dilations '${c}'`);const h=$i(s.shape,r,a,c,i),[p,d]=function(e,t,n,s){let r=new E$(n,"max",!1);const a=s.runWebGLProgram(r,[e],"float32");return r=new E$(n,"max",!0,!0,t),[a,s.runWebGLProgram(r,[e],"float32")]}(s,l,h,u);return[p,d]}};const lF={kernelName:"Mean",backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{keepDims:r,axis:a}=t,i=n,o=s.shape.length,l=b(a,s.shape);let u=l;const c=wl(u,o),p=null!=c,d=i.shouldExecuteOnCPU([s]),f=[];let m=s;if(p){if(d){const e=i.texData.get(m.dataId).values,t=new Array(o);for(let e=0;e<t.length;e++)t[e]=s.shape[c[e]];const n=oE(e,s.shape,s.dtype,c,t);m=i.makeTensorInfo(t,s.dtype),i.texData.get(m.dataId).values=n}else m=e$(s,c,i);f.push(m),u=vl(u.length,o)}xl("sum",u,o);const[g,y]=yl(m.shape,u);let x=g;r&&(x=bl(g,l));const w=function(e,t,n,s){const r=h(t),a=qE({inputs:{x:e},attrs:{shape:[h(e.shape)/r,r]},backend:s}),i=JE(a,"float32","mean",s),o=qE({inputs:{x:i},attrs:{shape:n},backend:s});return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}(m,y,x,i);for(const e of f)i.disposeIntermediateTensorInfo(e);return w}};const uF={kernelName:"Min",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=b(a,r.shape);let u=l;const c=wl(u,o);let p=r;null!=c&&(p=s$({inputs:{x:r},backend:n,attrs:{perm:c}}),u=vl(u.length,r.shape.length)),xl("min",u,o);const[d,f]=yl(p.shape,u),m=qE({inputs:{x:p},backend:n,attrs:{shape:[-1,h(f)]}}),g=JE(m,m.dtype,"min",n);let y;if(i){y=qE({inputs:{x:g},backend:n,attrs:{shape:bl(d,l)}})}else y=qE({inputs:{x:g},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(p),y}},cF={kernelName:"Minimum",backendName:"webgl",kernelFunc:zE({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return min(a, b);\n",packedOpSnippet:"\n  vec4 result = vec4(min(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:XT})};class hF{constructor(e,t,n){this.variableNames=["x"],this.outputShape=t.map((t,n)=>t[0]+e[n]+t[1]);const s=e.length,r=AT(s),a=t.map(e=>e[0]).join(","),i=t.map((t,n)=>t[0]+e[n]).join(","),o=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,s),l="reflect"===n?0:1;this.userCode=1!==s?`\n      ${r} start = ${r}(${a});\n      ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outC = getOutputCoords();\n        for (int i = 0; i < ${s}; i++) {\n          if (outC[i] < start[i]) {\n            outC[i] = start[i] * 2 - outC[i] - ${l};\n          } else if(outC[i] >= end[i]) {\n            outC[i] = (end[i] - 1) * 2 - outC[i] + ${l};\n          }\n        }\n        ${r} coords = outC - start;\n        setOutput(getX(${o}));\n      }\n    `:`\n        int start = ${a};\n        int end = ${i};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start) {\n            outC = start * 2 - outC - ${l};\n          } else if(outC >= end) {\n            outC = (end - 1) * 2 - outC + ${l};\n          }\n          setOutput(getX(outC - start));\n        }\n      `}}class pF{constructor(e,t,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t.map((t,n)=>t[0]+e[n]+t[1]);const s=e.length,r=AT(s),a=t.map(e=>e[0]).join(","),i=t.map((t,n)=>t[0]+e[n]).join(","),o=cE("rc",s),l=cE("source",s),u=`${o[s-1]} < ${this.outputShape[s-1]}`,c=1===s?"source":`vec2(${l.slice(-2).join()})`,h="reflect"===n?0:1;let p="";if(1===s){const e=`\n        ${r} source = rc;\n        if (source < start) {\n          source = start * 2 - source - ${h};\n        } else if (source >= end) {\n          source = (end - 1) * 2 - source + ${h};\n        }\n        source -= start;\n      `;p=`\n        ${r} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${l.join()}), ${c});\n        ${o[s-1]} += 1;\n        if(${u}) {\n          ${e}\n          result[1] = getChannel(getX(${l.join()}), ${c});\n        }\n      `}else{const e=`\n        ${r} source = rc;\n        ${r} lt = ${r}(lessThan(source, start));\n        ${r} gte = ${r}(greaterThanEqual(source, end));\n        ${r} orig = 1 - (lt + gte);\n        source = orig * source +\n                lt * (start * 2 - source - ${h}) +\n                gte * ((end - 1) * 2 - source + ${h});\n        source -= start;\n      `;p=`\n        ${r} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${l.join()}), ${c});\n        ${o[s-1]} += 1;\n        if(${u}) {\n          ${e}\n          result[1] = getChannel(getX(${l.join()}), ${c});\n        }\n        rc = outputLoc;\n        ${o[s-2]} += 1;\n        if(${o[s-2]} < ${this.outputShape[s-2]}) {\n          ${e}\n          result[2] = getChannel(getX(${l.join()}), ${c});\n          ${o[s-1]} += 1;\n          if(${u}) {\n            ${e}\n            result[3] = getChannel(getX(${l.join()}), ${c});\n          }\n        }\n      `}this.userCode=`\n      const ${r} start = ${r}(${a});\n      const ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${p}\n        setOutput(result);\n      }\n    `}}const dF={kernelName:"MirrorPad",backendName:"webgl",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s}=e,{paddings:r,mode:a}=n,i=G().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new pF(s.shape,r,a):new hF(s.shape,r,a);return t.runWebGLProgram(i,[s],s.dtype)}},fF=zE({opSnippet:"if (b == 0.0) return NAN;\n  return mod(a, b);",packedOpSnippet:"\n  vec4 result = mod(a, b);\n  vec4 isNaN = vec4(equal(b, vec4(0.0)));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),mF={kernelName:Ot,backendName:"webgl",kernelFunc:fF};class gF{constructor(e,t,n){this.variableNames=["probs"],this.outputShape=[e,n],this.userCode=`\n      uniform float seed;\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n\n        float r = random(seed);\n        float cdf = 0.0;\n\n        for (int i = 0; i < ${t-1}; i++) {\n          cdf += getProbs(batch, i);\n\n          if (r < cdf) {\n            setOutput(float(i));\n            return;\n          }\n        }\n\n        // If no other event happened, last event happened.\n        setOutput(float(${t-1}));\n      }\n    `}getCustomSetupFunc(e){return(t,n)=>{null==this.seedLoc&&(this.seedLoc=t.getUniformLocation(n,"seed")),t.gl.uniform1f(this.seedLoc,e)}}}const yF=zE({opSnippet:"\nif (a == b) {\n  return 1.0;\n};\nreturn a / b;",packedOpSnippet:"\n  // vec4 one = vec4(equal(a, b));\n  // return one + (vec4(1.0) - one) * a / b;\n  vec4 result = a / b;\n  if(a.x == b.x) {\n    result.x = 1.;\n  }\n  if(a.y == b.y) {\n    result.y = 1.;\n  }\n  if(a.z == b.z) {\n    result.z = 1.;\n  }\n  if(a.w == b.w) {\n    result.w = 1.;\n  }\n\n  return result;\n",checkOutOfBounds:!0}),bF={kernelName:"RealDiv",backendName:"webgl",kernelFunc:yF},xF="return a - b;",wF=zE({opSnippet:xF,packedOpSnippet:xF,supportsComplex:!0,cpuKernelImpl:rE}),kF={kernelName:Tn,backendName:"webgl",kernelFunc:wF};function vF(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{dim:a}=s,i=b([a],r.shape),o=ZR({inputs:{x:r},backend:n,attrs:{reductionIndices:i,keepDims:!1}}),l=bl(o.shape,i),u=qE({inputs:{x:o},backend:n,attrs:{shape:l}}),c=wF({inputs:{a:r,b:u},backend:n}),h=aR({inputs:{x:c},backend:n}),p=t$({inputs:{x:h},backend:n,attrs:{axis:i,keepDims:!1}}),d=qE({inputs:{x:p},backend:n,attrs:{shape:l}}),f=yF({inputs:{a:h,b:d},backend:n});return n.disposeIntermediateTensorInfo(o),n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(c),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(d),f}const NF={kernelName:"Softmax",backendName:"webgl",kernelFunc:vF};const IF={kernelName:"Multinomial",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{numSamples:a,seed:i,normalized:o}=s,l=o?r:vF({inputs:{logits:r},backend:n,attrs:{dim:r.shape.length-1}}),u=l.shape[0],c=l.shape[1],h=new gF(u,c,a),p=h.getCustomSetupFunc(i),d=n.runWebGLProgram(h,[l],"int32",p);return o||n.disposeIntermediateTensorInfo(l),d}},CF="return -x;";const SF={kernelName:"Neg",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;if(n.shouldExecuteOnCPU([s])){const e=n.texData.get(s.dataId),[t,r]=JT(e.values,s.shape,s.dtype);return n.makeTensorInfo(r,s.dtype,t)}let r;return r=G().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new wE(s.shape,CF):new yE(s.shape,CF),n.runWebGLProgram(r,[s],s.dtype)}},TF=Hc;const EF={kernelName:"NonMaxSuppressionV3",backendName:"webgl",kernelFunc:function(e){jh("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=s,u=n.readSync(r.dataId),c=n.readSync(a.dataId),{selectedIndices:h}=TF(u,c,i,o,l);return n.makeTensorInfo([h.length],"int32",new Int32Array(h))}},$F=jc;const AF={kernelName:"NonMaxSuppressionV4",backendName:"webgl",kernelFunc:function(e){jh("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,padToMaxOutputSize:u}=s,c=n.readSync(r.dataId),h=n.readSync(a.dataId),{selectedIndices:p,validOutputs:d}=$F(c,h,i,o,l,u);return[n.makeTensorInfo([p.length],"int32",new Int32Array(p)),n.makeTensorInfo([],"int32",new Int32Array([d]))]}},RF=qc;const FF={kernelName:"NonMaxSuppressionV5",backendName:"webgl",kernelFunc:function(e){jh("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,softNmsSigma:u}=s,c=n.readSync(r.dataId),h=n.readSync(a.dataId),p=i,d=o,f=l,m=u,{selectedIndices:g,selectedScores:y}=RF(c,h,p,d,f,m);return[n.makeTensorInfo([g.length],"int32",new Int32Array(g)),n.makeTensorInfo([y.length],"float32",new Float32Array(y))]}};class DF{constructor(e,t,n,s){this.variableNames=["indices"],this.outputShape=[e,t],this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int index = round(getIndices(coords.x));\n        setOutput(mix(float(${s}), float(${n}),\n                      float(index == coords.y)));\n      }\n    `}}const _F={kernelName:"OneHot",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{indices:r}=t,{depth:a,onValue:i,offValue:o}=s,l=h(r.shape),u=new DF(l,a,i,o),c=qE({inputs:{x:r},backend:n,attrs:{shape:[l]}}),p=n.runWebGLProgram(u,[c],r.dtype);n.disposeIntermediateTensorInfo(c);const d=qE({inputs:{x:p},backend:n,attrs:{shape:[...r.shape,a]}});return n.disposeIntermediateTensorInfo(p),d}};function OF(e){const{inputs:t,backend:n}=e,{x:s}=t;if("complex64"===s.dtype){const e=X$({inputs:{input:s},backend:n}),t=OF({inputs:{x:e},backend:n}),r=uA({inputs:{input:s},backend:n}),a=OF({inputs:{x:r},backend:n}),i=$E({inputs:{real:t,imag:a},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(a),i}return mR({attrs:{shape:s.shape,dtype:s.dtype,value:"string"===s.dtype?"":0},backend:n})}const MF={kernelName:"ZerosLike",backendName:"webgl",kernelFunc:OF};const LF={kernelName:"OnesLike",backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s}=t,{x:r}=n;if("string"===r.dtype)throw new Error("onesLike is not supported under string dtype");if("complex64"===r.dtype){const t=X$({inputs:{input:r},backend:s}),n=e({inputs:{x:t},backend:s}),a=uA({inputs:{input:r},backend:s}),i=OF({inputs:{x:a},backend:s}),o=$E({inputs:{real:n,imag:i},backend:s});return s.disposeIntermediateTensorInfo(t),s.disposeIntermediateTensorInfo(n),s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}return mR({attrs:{shape:r.shape,dtype:r.dtype,value:1},backend:s})}};const zF={kernelName:"Pack",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s;if(1===t.length)return oR({inputs:{input:t[0]},backend:n,attrs:{dim:r}});const a=t[0].shape,i=t[0].dtype;t.forEach(e=>{l(a,e.shape,"All tensors passed to stack must have matching shapes"),o(i===e.dtype,()=>"All tensors passed to stack must have matching dtypes")});const u=[],c=pA({inputs:t.map(e=>{const t=oR({inputs:{input:e},backend:n,attrs:{dim:r}});return u.push(t),t}),backend:n,attrs:{axis:r}});return u.forEach(e=>n.disposeIntermediateTensorInfo(e)),c}};class BF{constructor(e,t,n){this.variableNames=["x"],this.outputShape=t.map((t,n)=>t[0]+e[n]+t[1]);const s=e.length,r=AT(s),a=t.map(e=>e[0]).join(","),i=t.map((t,n)=>t[0]+e[n]).join(","),o=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,s);this.userCode=1!==s?`\n      ${r} start = ${r}(${a});\n      ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outC = getOutputCoords();\n        if (any(lessThan(outC, start)) || any(greaterThanEqual(outC, end))) {\n          setOutput(float(${n}));\n        } else {\n          ${r} coords = outC - start;\n          setOutput(getX(${o}));\n        }\n      }\n    `:`\n        int start = ${a};\n        int end = ${i};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start || outC >= end) {\n            setOutput(float(${n}));\n          } else {\n            setOutput(getX(outC - start));\n          }\n        }\n      `}}class PF{constructor(e,t,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t.map((t,n)=>t[0]+e[n]+t[1]);const s=e.length,r=AT(s),a=t.map(e=>e[0]).join(","),i=t.map((t,n)=>t[0]+e[n]).join(","),o=cE("rc",s),l=cE("source",s),u=`${o[s-1]} < ${this.outputShape[s-1]}`,c=1===s?"source":`vec2(${l.slice(-2).join()})`,h=[r+" rc = outputLoc;",`${o[s-1]} += 1;\n       if(${u}) {\n      `,1===s?"":`}\n       rc = outputLoc;\n       ${o[s-2]} += 1;\n       if(${o[s-2]} < ${this.outputShape[s-2]}) {`,1===s?"":`  ${o[s-1]} += 1;\n         if(${u}) {`],p=1===s?"rc < start || rc >= end":"any(lessThan(rc, start)) || any(greaterThanEqual(rc, end))";let d="";for(let e=0,t=1===s?2:4;e<t;e++)d+=`\n        ${h[e]}\n        if (${p}) {\n          result[${e}] = float(${n});\n        } else {\n          ${r} source = rc - start;\n          result[${e}] = getChannel(getX(${l.join()}), ${c});\n        }\n      `;d+=1===s?"} ":"}}",this.userCode=`\n      const ${r} start = ${r}(${a});\n      const ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${d}\n        setOutput(result);\n      }\n    `}}const WF=e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,constantValue:i}=s,o=G().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new PF(r.shape,a,i):new BF(r.shape,a,i);return n.runWebGLProgram(o,[r],r.dtype)},VF={kernelName:"PadV2",backendName:"webgl",kernelFunc:WF},UF=zE({opSnippet:"\n  if(a < 0.0 && floor(b) < b){\n    return NAN;\n  }\n  if (b == 0.0) {\n    return 1.0;\n  }\n  return (round(mod(b, 2.0)) != 1) ?\n      pow(abs(a), b) : sign(a) * pow(abs(a), b);\n",packedOpSnippet:"\n  // isModRound1 has 1 for components with round(mod(b, 2.0)) == 1, 0 otherwise.\n  vec4 isModRound1 = vec4(equal(round(mod(b, 2.0)), ivec4(1)));\n  vec4 multiplier = sign(a) * isModRound1 + (vec4(1.0) - isModRound1);\n  vec4 result = multiplier * pow(abs(a), b);\n\n  // Ensure that a^0 = 1, including 0^0 = 1 as this correspond to TF and JS\n  bvec4 isExpZero = equal(b, vec4(0.0));\n  result.r = isExpZero.r ? 1.0 : result.r;\n  result.g = isExpZero.g ? 1.0 : result.g;\n  result.b = isExpZero.b ? 1.0 : result.b;\n  result.a = isExpZero.a ? 1.0 : result.a;\n\n  vec4 isNaN = vec4(lessThan(a, vec4(0.0))) * vec4(lessThan(floor(b), b));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),GF={kernelName:Kt,backendName:"webgl",kernelFunc:UF};const HF={kernelName:"Prod",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=[],u=b(a,r.shape);let c=u;const p=wl(c,o);let d,f=r;if(null!=p&&(f=s$({inputs:{x:r},backend:n,attrs:{perm:p}}),c=vl(c.length,o),l.push(f)),xl("prod",c,o),n.shouldExecuteOnCPU([f])){const e=n.texData.get(f.dataId).values,{outVals:t,outShape:s,outDtype:r}=ZT(f.shape,f.dtype,e,c);d=n.makeTensorInfo(s,r,t)}else{const[e,t]=yl(f.shape,c),s=h(t),a=qE({inputs:{x:f},backend:n,attrs:{shape:[-1,s]}}),i=JE(a,As(r.dtype),"prod",n);d=qE({inputs:{x:i},backend:n,attrs:{shape:e}}),l.push(a),l.push(i)}if(i){l.push(d);const e=bl(d.shape,u);d=qE({inputs:{x:d},backend:n,attrs:{shape:e}})}return l.forEach(e=>n.disposeIntermediateTensorInfo(e)),d}},jF=e=>{const{backend:t,attrs:n}=e,{start:s,stop:r,step:a,dtype:i}=n,o=QT(s,r,a,i);return t.makeTensorInfo([o.length],i,o)},qF={kernelName:"Range",backendName:"webgl",kernelFunc:jF},KF={kernelName:"Reciprocal",backendName:"webgl",kernelFunc:LE({opSnippet:"return 1.0 / x;"})},XF={kernelName:"Relu",backendName:"webgl",kernelFunc:LE({opSnippet:"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n",packedOpSnippet:"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"})},YF={kernelName:"Relu6",backendName:"webgl",kernelFunc:LE({opSnippet:"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n",packedOpSnippet:"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"})};class JF{constructor(e,t,n,s,r){this.variableNames=["A"],this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n];let h;h=r?"(vec2(yRC) + vec2(0.5)) * effectiveInputOverOutputRatioRC - vec2(0.5)":"vec2(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]});\n      const vec2 inputShapeRC = vec2(${i}.0, ${o}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = ${h};\n\n        // Compute the four integer indices.\n        ivec2 sourceFloorRC = ivec2(max(sourceFracIndexRC, vec2(0.0)));\n        ivec2 sourceCeilRC = ivec2(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        float topLeft = getA(b, sourceFloorRC.x, sourceFloorRC.y, d);\n        float bottomLeft = getA(b, sourceCeilRC.x, sourceFloorRC.y, d);\n        float topRight = getA(b, sourceFloorRC.x, sourceCeilRC.y, d);\n        float bottomRight = getA(b, sourceCeilRC.x, sourceCeilRC.y, d);\n\n        vec2 fracRC = sourceFracIndexRC - vec2(sourceFloorRC);\n\n        float top = topLeft + (topRight - topLeft) * fracRC.y;\n        float bottom = bottomLeft + (bottomRight - bottomLeft) * fracRC.y;\n        float newValue = top + (bottom - top) * fracRC.x;\n\n        setOutput(newValue);\n      }\n    `}}class ZF{constructor(e,t,n,s,r){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n];let h;h=r?"(vec3(yRC) + vec3(0.5)) * effectiveInputOverOutputRatioRC - vec3(0.5)":"vec3(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec3 effectiveInputOverOutputRatioRC = vec3(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]},\n          ${u[1]/c[1]});\n      const vec3 inputShapeRC = vec3(${i}.0, ${o}.0,\n                                     ${o}.0);\n\n      float getAValue(int b, int r, int c, int d) {\n        return getChannel(getA(b, r, c, d), vec2(c, d));\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        // Calculate values for next column in yRC.z.\n        ivec3 yRC = coords.yzz + ivec3(0, 0, 1);\n\n        // Fractional source index.\n        vec3 sourceFracIndexRC = ${h};\n\n        // Compute the four integer indices.\n        ivec3 sourceFloorRC = ivec3(max(sourceFracIndexRC, vec3(0.0)));\n        ivec3 sourceCeilRC = ivec3(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        // Should we calculate next column and row elements in 2x2 packed cell.\n        bool hasNextCol = d < ${l-1};\n        bool hasNextRow = coords.z < ${n-1};\n\n        // In parallel, construct four corners for all four components in\n        // packed 2x2 cell.\n        vec4 topLeft = vec4(\n          getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 bottomLeft = vec4(\n          getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 topRight = vec4(\n          getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec4 bottomRight = vec4(\n          getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec3 fracRC = sourceFracIndexRC - vec3(sourceFloorRC);\n\n        vec4 top = mix(topLeft, topRight, fracRC.yyzz);\n        vec4 bottom = mix(bottomLeft, bottomRight, fracRC.yyzz);\n        vec4 newValue = mix(top, bottom, fracRC.x);\n\n        setOutput(newValue);\n      }\n    `}}const QF={kernelName:"ResizeBilinear",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s,[l,u]=o,c=G().getBool("WEBGL_PACK_IMAGE_OPERATIONS")?new ZF(r.shape,l,u,a,i):new JF(r.shape,l,u,a,i);return n.runWebGLProgram(c,[r],"float32")}};class eD{constructor(e,t,n){this.variableNames=["dy"],this.outputShape=[],this.outputShape=t;const[,s,r]=t,[,a,i]=e,o=[n&&a>1?s-1:s,n&&i>1?r-1:r],l=[n&&a>1?a-1:a,n&&i>1?i-1:i],u=o[0]/l[0],c=o[1]/l[1],h=1/u,p=1/c,d=2*Math.ceil(h)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${u});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${h});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${d});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(startRLerp - float(winHeight / 2));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(startCLerp - float(winWidth / 2));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${a}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${i}) {\n              continue;\n            }\n\n            float dxR = float(dyR) * heightScale;\n            int topDxRIndex = int(floor(dxR));\n            int bottomDxRIndex = int(min(ceil(dxR), ${s-1}.0));\n            float dxRLerp = dxR - float(topDxRIndex);\n            float inverseDxRLerp = 1.0 - dxRLerp;\n\n            float dxC = float(dyC) * widthScale;\n            int leftDxCIndex = int(floor(dxC));\n            int rightDxCIndex = int(min(ceil(dxC), ${r-1}.0));\n            float dxCLerp = dxC - float(leftDxCIndex);\n            float inverseDxCLerp = 1.0 - dxCLerp;\n\n            if (r == topDxRIndex && c == leftDxCIndex) {\n              // topLeft\n              accumulator +=\n                getDy(b, dyR, dyC, d) * inverseDxRLerp * inverseDxCLerp;\n            }\n\n            if (r == topDxRIndex && c == rightDxCIndex) {\n              // topRight\n              accumulator += getDy(b, dyR, dyC, d) * inverseDxRLerp * dxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == leftDxCIndex) {\n              // bottomLeft\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * inverseDxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == rightDxCIndex) {\n              // bottomRight\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * dxCLerp;\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}const tD={kernelName:"ResizeBilinearGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s,o=new eD(a.shape,r.shape,i);return n.runWebGLProgram(o,[a],a.dtype)}};class nD{constructor(e,t,n,s,r){this.variableNames=["A"],this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n],h=s?"0.5":"0.0";let p;p=r?"max((vec2(yRC) + vec2(0.5)) * effectiveInputOverOutputRatioRC, vec2(0.0))":"vec2(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]});\n      const vec2 inputShapeRC = vec2(${i}.0, ${o}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = ${p};\n\n        // Compute the coordinators of nearest neighbor point.\n        ivec2 sourceNearestRC = ivec2(\n          min(inputShapeRC - 1.0, floor(sourceFracIndexRC + ${h})));\n        float newValue = getA(b, sourceNearestRC.x, sourceNearestRC.y, d);\n\n        setOutput(newValue);\n      }\n    `}}const sD={kernelName:"ResizeNearestNeighbor",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s,[l,u]=o,c=new nD(r.shape,l,u,a,i);return n.runWebGLProgram(c,[r],r.dtype)}};class rD{constructor(e,t,n){this.variableNames=["dy"],this.outputShape=[],this.outputShape=t;const[,s,r]=t,[,a,i]=e,o=[n&&a>1?s-1:s,n&&i>1?r-1:r],l=[n&&a>1?a-1:a,n&&i>1?i-1:i],u=o[0]/l[0],c=o[1]/l[1],h=1/u,p=1/c,d=2*Math.ceil(h)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${u});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${h});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${d});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(floor(startRLerp - float(winHeight / 2)));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(floor(startCLerp - float(winWidth / 2)));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${a}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${i}) {\n              continue;\n            }\n\n            float sourceFracRow =\n              float(${o[0]}) *\n                (float(dyR) / float(${l[0]}));\n\n            float sourceFracCol =\n                float(${o[1]}) *\n                  (float(dyC) / float(${l[1]}));\n\n            int sourceNearestRow = int(min(\n                float(int(${s}) - 1),\n                ${n} ? float(round(sourceFracRow)) :\n                                  float(floor(sourceFracRow))));\n\n            int sourceNearestCol = int(min(\n                float(int(${r}) - 1),\n                ${n} ? float(round(sourceFracCol)) :\n                                  float(floor(sourceFracCol))));\n\n            if (r == sourceNearestRow && c == sourceNearestCol) {\n              accumulator += getDy(b, dyR, dyC, d);\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}const aD={kernelName:"ResizeNearestNeighborGrad",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s,o=new rD(a.shape,r.shape,i);return n.runWebGLProgram(o,[a],a.dtype)}};class iD{constructor(e,t){this.variableNames=["x"];const n=e.length;if(n>4)throw new Error(`WebGL backend: Reverse of rank-${n} tensor is not yet supported`);if(this.outputShape=e,1===n)return void(this.userCode=`\n        void main() {\n          int coord = getOutputCoords();\n          setOutput(getX(${e[0]} - coord - 1));\n        }\n      `);const s=e.map((n,s)=>(n=>-1!==t.indexOf(n)&&1!==e[n]?`${e[n]} - coords[${n}] - 1`:`coords[${n}]`)(s)).join(","),r=AT(n);this.userCode=`\n      void main() {\n        ${r} coords = getOutputCoords();\n        setOutput(getX(${s}));\n      }\n    `}}class oD{constructor(e,t){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0;const n=e.length;if(n>4)throw new Error(`WebGL backend: Reverse of rank-${n} tensor is not yet supported`);this.outputShape=e;const s=cE("rc",n),r=`${s[n-1]} + 1 < ${this.outputShape[n-1]}`,a=`${s[n-2]} + 1 < ${this.outputShape[n-2]}`,i=AT(n);function o(n){const s=e.map((s,r)=>function(n,s){return-1!==t.indexOf(n)&&1!==e[n]?`${e[n]} - ${s[n]} - 1`:""+s[n]}(r,n));return`getChannel(getX(${s.join(",")}), vec2(${s.slice(-2).join(",")}))`}this.userCode=1===n?`\n        void main(){\n          int rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = getChannel(getX(${e[0]} - rc - 1),\n            ${e[0]} - rc - 1);\n          if(${r}){\n              result.g = getChannel(getX(${e[0]} - (rc  + 1) - 1),\n                ${e[0]} - (rc  + 1) - 1);\n          }\n          setOutput(result);\n        }\n      `:`\n        void main() {\n          ${i} rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = ${function(e){return o(e)}(s.slice())};\n          if(${r}){\n            result.g = ${function(e){return e[n-1]="("+e[n-1]+" + 1)",o(e)}(s.slice())};\n          }\n          if(${a}) {\n            result.b = ${function(e){return e[n-2]="("+e[n-2]+" + 1)",o(e)}(s.slice())};\n            if(${r}) {\n              result.a = ${function(e){return e[n-1]="("+e[n-1]+" + 1)",e[n-2]="("+e[n-2]+" + 1)",o(e)}(s.slice())};\n            }\n          }\n          setOutput(result);\n        }\n    `}}const lD={kernelName:"Reverse",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dims:a}=s,i=r.shape.length,o=b(a,r.shape);if(0===i)return TE({inputs:{x:r},backend:n});const l=G().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new oD(r.shape,o):new iD(r.shape,o);return n.runWebGLProgram(l,[r],r.dtype)}};class uD{constructor(e,t,n,s){this.variableNames=["Image"],this.outputShape=[];const r=e[1],a=e[2],i=Math.sin(t).toFixed(3),o=Math.cos(t).toFixed(3);this.outputShape=e;const[l,u]=Bh(s,r,a),c=l.toFixed(3),h=u.toFixed(3);let p="";p="number"==typeof n?`float outputValue = ${n.toFixed(2)};`:`\n        vec3 fill = vec3(${n.join(",")});\n        float outputValue = fill[coords[3]];`,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n          int y = coords[1];\n          float coordXFloat = (float(x) - ${c}) * ${o} - (float(y) - ${h}) * ${i};\n          float coordYFloat = (float(x) - ${c}) * ${i} + (float(y) - ${h}) * ${o};\n          int coordX = int(round(coordXFloat + ${c}));\n          int coordY = int(round(coordYFloat + ${h}));\n          ${p}\n          if(coordX >= 0 && coordX < ${a} && coordY >= 0 && coordY < ${r}) {\n            outputValue = getImage(coords[0], coordY, coordX, coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const cD={kernelName:"RotateWithOffset",backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,{radians:r,fillValue:a,center:i}=t,o=n,l=new uD(s.shape,r,a,i);return o.runWebGLProgram(l,[s],s.dtype)}},hD={kernelName:"Round",backendName:"webgl",kernelFunc:LE({opSnippet:"\n  // OpenGL ES does not support round function.\n  // The algorithm is based on banker's rounding.\n  float base = floor(x);\n  if ((x - base) < 0.5) {\n    return floor(x);\n  } else if ((x - base) > 0.5) {\n    return ceil(x);\n  } else {\n    if (mod(base, 2.0) == 0.0) {\n      return base;\n    } else {\n      return base + 1.0;\n    }\n  }\n"})},pD={kernelName:"Rsqrt",backendName:"webgl",kernelFunc:LE({opSnippet:"return inversesqrt(x);",cpuKernelImpl:eE})};class dD{constructor(e,t,n,s,r,a,i=!0){this.variableNames=["updates","indices","defaultValue"],this.outputShape=a;const o=AT(r.length),l=AT(a.length);let u="";1===n?u="i":2===n&&(u="i, j");const c=`getIndices(${u})`;let h="";1===s?h="i":2===s&&(h="i, coords[1]");const p=`getUpdates(${h})`,d=t>1?"strides[j]":"strides";this.userCode=`\n        ${o} strides = ${o}(${r});\n\n        void main() {\n          ${l} coords = getOutputCoords();\n          float sum = 0.0;\n          bool found = false;\n          for (int i = 0; i < ${e}; i++) {\n            int flattenedIndex = 0;\n            for (int j = 0; j < ${t}; j++) {\n              int index = round(${c});\n              flattenedIndex += index * ${d};\n            }\n            if (flattenedIndex == coords[0]) {\n              sum += ${p};\n              found = true;\n            }\n          }\n          setOutput(mix(getDefaultValue(), sum, float(found)));\n        }\n      `}}const fD={kernelName:"ScatterNd",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r,updates:a}=t,{shape:i}=s,{sliceRank:o,numUpdates:l,sliceSize:u,strides:c,outputSize:h}=ma(0,r,i),p=[h/u,u];if(0===h)return n.makeTensorInfo(i,r.dtype);const d=qE({inputs:{x:r},backend:n,attrs:{shape:[l,o]}}),f=qE({inputs:{x:a},backend:n,attrs:{shape:[l,u]}}),m=n.makeTensorInfo([],"float32",new Float32Array([0])),g=new dD(l,o,d.shape.length,f.shape.length,c,p),y=n.runWebGLProgram(g,[f,d,m],f.dtype),b=qE({inputs:{x:y},backend:n,attrs:{shape:i}});return n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(y),n.disposeIntermediateTensorInfo(m),b}};class mD{constructor(e,t,n){let s,r;if(this.variableNames=["c","a","b"],this.outputShape=t,n>4)throw Error(`Where for rank ${n} is not yet supported`);if(1===n)r="resRC",s="resRC";else{const n=["resRC.x","resRC.y","resRC.z","resRC.w"],a=[],i=[];for(let s=0;s<t.length;s++)i.push(""+n[s]),s<e&&a.push(""+n[s]);s=a.join(),r=i.join()}const a=AT(n);this.userCode=`\n      void main() {\n        ${a} resRC = getOutputCoords();\n        float cVal = getC(${s});\n        if (cVal >= 1.0) {\n          setOutput(getA(${r}));\n        } else {\n          setOutput(getB(${r}));\n        }\n      }\n    `}}const gD={kernelName:"Select",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{condition:s,t:r,e:a}=t,i=new mD(s.shape.length,r.shape,r.shape.length);return n.runWebGLProgram(i,[s,r,a],$s(r.dtype,a.dtype))}},yD={kernelName:"Selu",backendName:"webgl",kernelFunc:LE({opSnippet:`\n  // Stable and Attracting Fixed Point (0, 1) for Normalized Weights.\n  // see: https://arxiv.org/abs/1706.02515\n  float scaleAlpha = 1.7580993408473768;\n  float scale = ${Hh};\n  return (x >= 0.0) ? scale * x : scaleAlpha * (exp(x) - 1.0);\n`})},bD={kernelName:"Sigmoid",backendName:"webgl",kernelFunc:LE({opSnippet:"return 1.0 / (1.0 + exp(-1.0 * x));"})},xD={kernelName:"Sign",backendName:"webgl",kernelFunc:LE({opSnippet:"\n  if (isnan(x)) { return 0.0; }\n  return sign(x);\n"})},wD=LE({opSnippet:"if (isnan(x)) return x;\n  return sin(x);\n"}),kD={kernelName:mn,backendName:"webgl",kernelFunc:wD},vD={kernelName:"Sinh",backendName:"webgl",kernelFunc:LE({opSnippet:"\n  float e2x = exp(x);\n  return (e2x - 1.0 / e2x) / 2.0;\n"})},ND={kernelName:"Softplus",backendName:"webgl",kernelFunc:LE({opSnippet:"\n  float epsilon = 1.1920928955078125e-7;\n  float threshold = log(epsilon) + 2.0;\n\n  bool too_large = x > -threshold;\n  bool too_small = x < threshold;\n\n  float result;\n  float exp_x = exp(x);\n\n  if (too_large){\n    result = x;\n  }\n  else if (too_small){\n    result = exp_x;\n  }\n  else{\n    result = log(exp_x + 1.0);\n  }\n  return result;\n"})},ID={kernelName:"SpaceToBatchND",backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,paddings:i}=s;o(r.shape.length<=4,()=>"spaceToBatchND for rank > 4 with a WebGL backend not implemented yet");const l=a.reduce((e,t)=>e*t),u=[[0,0]];u.push(...i);for(let e=1+a.length;e<r.shape.length;++e)u.push([0,0]);const c=[],h=WF({inputs:{x:r},backend:n,attrs:{paddings:u,constantValue:0}}),p=Ph(h.shape,a,l,!1),d=Wh(p.length,a.length,!1),f=Vh(h.shape,a,l,!1),m=qE({inputs:{x:h},backend:n,attrs:{shape:p}}),g=s$({inputs:{x:m},backend:n,attrs:{perm:d}}),y=qE({inputs:{x:g},backend:n,attrs:{shape:f}});return c.push(h),c.push(m),c.push(g),c.forEach(e=>n.disposeIntermediateTensorInfo(e)),y}};const CD={kernelName:"SparseToDense",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{sparseIndices:r,sparseValues:a,defaultValue:i}=t,{outputShape:o}=s,{sliceRank:l,numUpdates:u,strides:c,outputSize:h}=ma(0,r,o),p=new dD(u,l,r.shape.length,a.shape.length,c,[h,1],!1),d=n.runWebGLProgram(p,[a,r,i],a.dtype),f=qE({inputs:{x:d},backend:n,attrs:{shape:o}});return n.disposeIntermediateTensorInfo(d),f}};const SD={kernelName:"SplitV",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{numOrSizeSplits:a,axis:i}=s,o=b(i,r.shape)[0],l=tp(r,a,o),u=r.shape.length,c=new Array(u).fill(0),h=r.shape.slice();return l.map(e=>{const t=[...h];t[o]=e;const s=U$({inputs:{x:r},backend:n,attrs:{begin:c,size:t}});return c[o]+=e,s})}},TD={kernelName:"Sqrt",backendName:"webgl",kernelFunc:LE({opSnippet:"return sqrt(x);"})},ED={kernelName:"Square",backendName:"webgl",kernelFunc:LE({opSnippet:"return x * x;"})},$D={kernelName:"SquaredDifference",backendName:"webgl",kernelFunc:zE({opSnippet:"return (a - b) * (a - b);",packedOpSnippet:"return (a - b) * (a - b);"})};const AD={kernelName:"Step",backendName:"webgl",kernelFunc:function({inputs:e,attrs:t,backend:n}){const{x:s}=e,r=`if (isnan(x)) return x;\n    return x > 0.0 ? 1.0 : float(${t.alpha});\n  `,a=new yE(s.shape,r);return n.runWebGLProgram(a,[s],s.dtype)}};class RD{constructor(e,t,n){this.variableNames=["x"],this.outputShape=n;const s=n.length,r=AT(n.length),a=AT(n.length);let i="";if(1===s)i="coords * strides + begin";else{let e=0;i=n.map((t,s)=>(e++,1===n.length?`coords * strides[${s}] + begin[${s}]`:`coords[${e-1}] * strides[${s}] + begin[${s}]`)).join(",")}this.userCode=`\n      ${r} begin = ${r}(${e});\n      ${r} strides = ${r}(${t});\n\n      void main() {\n        ${a} coords = getOutputCoords();\n        setOutput(getX(${i}));\n      }\n    `}}const FD={kernelName:"StridedSlice",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,end:i,strides:o,beginMask:l,endMask:u,ellipsisMask:c,newAxisMask:h,shrinkAxisMask:p}=s,{nonStrided:d,$begin:f,$strides:m,size:g,newShape:y,outShape:b}=Fa(r.shape,a,i,o,l,u,c,h,p),x=qE({inputs:{x:r},backend:n,attrs:{shape:y}});let w;if(d){const e=U$({inputs:{x:x},backend:n,attrs:{begin:f,size:g}});w=qE({inputs:{x:e},backend:n,attrs:{shape:b}}),n.disposeIntermediateTensorInfo(e)}else if(b.some(e=>0===e))w=n.makeTensorInfo(b,r.dtype,[]);else{if(n.shouldExecuteOnCPU([x])){const e=n.texData.get(x.dataId).values,t=Lr(x.shape,x.dtype,e),s=sE(b,t,m,f);w=n.makeTensorInfo(b,x.dtype,s.values)}else{const e=new RD(f,m,b);w=n.runWebGLProgram(e,[x],x.dtype)}}const k=qE({inputs:{x:w},backend:n,attrs:{shape:b}});return n.disposeIntermediateTensorInfo(x),n.disposeIntermediateTensorInfo(w),k}},DD=LE({opSnippet:"return tan(x);"}),_D={kernelName:An,backendName:"webgl",kernelFunc:DD},OD={kernelName:"Tanh",backendName:"webgl",kernelFunc:LE({opSnippet:"\n  float e2x = exp(-2.0 * abs(x));\n  return sign(x) * (1.0 - e2x) / (1.0 + e2x);\n"})};class MD{constructor(e,t){this.variableNames=["A"];const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[s]*t[s];this.outputShape=n,this.rank=n.length;const s=AT(this.rank),r=function(e){const t=e.length;if(t>5)throw Error(`Tile for rank ${t} is not yet supported`);if(1===t)return`imod(resRC, ${e[0]})`;const n=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u"],s=[];for(let t=0;t<e.length;t++)s.push(`imod(${n[t]}, ${e[t]})`);return s.join()}(e);this.userCode=`\n      void main() {\n        ${s} resRC = getOutputCoords();\n        setOutput(getA(${r}));\n      }\n    `}}function LD(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reps:a}=s;if("string"===r.dtype){const e=n.readSync(r.dataId).map(e=>os(e)),t=Lr(r.shape,r.dtype,e),s=aE(t,a);return n.makeTensorInfo(s.shape,s.dtype,s.values)}const i=new MD(r.shape,a);return n.runWebGLProgram(i,[r],r.dtype)}const zD={kernelName:"Tile",backendName:"webgl",kernelFunc:LD};const BD={kernelName:"TopK",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{k:a,sorted:i}=s,o=n.readSync(r.dataId),[l,u]=iE(o,r.shape,r.dtype,a,i);return[n.makeTensorInfo(l.shape,l.dtype,l.values),n.makeTensorInfo(u.shape,u.dtype,u.values)]}};const PD={kernelName:"Unique",backendName:"webgl",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{axis:r}=n,{x:a}=t;YS(a,"unique"),console.warn("WARNING: ","UI might be locked temporarily as data is being downloaded");const i=s.readSync(a.dataId),{outputValues:o,outputShape:l,indices:u}=lE(i,r,a.shape,a.dtype);return[s.makeTensorInfo(l,a.dtype,o),s.makeTensorInfo([u.length],"int32",u)]}};const WD={kernelName:"Unpack",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{value:r}=t;let{axis:a}=s;a<0&&(a+=r.shape.length);const i=r,o=i.shape.length,l=r.shape[a],u=new Array(o-1);let c=0;for(let e=0;e<o;e++)e!==a&&(u[c++]=i.shape[e]);const h=[],p=new Array(o).fill(0),d=i.shape.slice();d[a]=1;const f=new Array(l);for(let e=0;e<f.length;e++){p[a]=e;const t=U$({inputs:{x:i},backend:n,attrs:{begin:p,size:d}}),s=qE({inputs:{x:t},backend:n,attrs:{shape:u}});f[e]=s,h.push(t)}return h.forEach(e=>n.disposeIntermediateTensorInfo(e)),f}};class VD{constructor(e,t){this.variableNames=["x","segmentIds"];const n=e.windowSize,s=e.batchSize,r=e.inSize,a=e.numSegments,i=a*Math.ceil(r/n);this.outputShape=[s,i];const o=4*Math.floor(n/4),l=n%4,u="\n        sumValue += dot(values, segFilter);\n    ";let c="";r%n>0&&(c=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return initializationValue;\n        }\n      `);let h="";r%n>0&&(h=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return -1.0;\n        }\n      `),this.userCode=`\n      const float initializationValue = 0.0;\n\n      float getValue(int batch, int inIdx) {\n        ${c}\n        return getX(batch, inIdx);\n      }\n\n      float getSegmentIdAtIndex(int inIdx) {\n        ${h}\n        return getSegmentIds(inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = int(floor(float(outIdx) / float(\n          ${a})) * float(${n}));\n        int currentSeg = int(mod(float(outIdx), float(${a})));\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${o}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 3)) == currentSeg ? 1 : 0\n          );\n\n          ${u}\n        }\n\n        int inIdx = inOffset + ${o};\n        if (${1===l}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          int inIdxSeg = int(getSegmentIdAtIndex(inIdx));\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            0,\n            0,\n            0\n          );\n\n          ${u}\n        } else if (${2===l}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n              0,\n              0\n          );\n\n          ${u}\n        } else if (${3===l}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            0\n          );\n\n          ${u}\n        }\n        setOutput(sumValue);\n      }\n    `}}const UD=[XR,JR,i$,o$,l$,u$,p$,m$,g$,y$,k$,v$,N$,I$,S$,C$,T$,R$,A$,_$,O$,M$,B$,H$,j$,J$,Q$,nA,aA,AE,dA,IA,CA,xA,TA,EA,SA,AA,RA,DA,LA,zA,PA,jA,qA,UA,XA,JA,QA,eR,tR,sR,iR,lR,cR,dR,gR,bR,wR,kR,IR,SR,TR,$R,RR,FR,DR,EE,_R,cA,OR,MR,LR,DE,zR,BR,PR,UR,VR,GR,HR,jR,QR,nF,tF,aF,iF,oF,eF,lF,uF,cF,dF,mF,IF,jE,SF,EF,AF,FF,K$,_F,LF,zF,VF,GF,ME,HF,qF,Y$,bF,KF,YF,XF,KE,QF,tD,sD,aD,lD,cD,hD,pD,fD,gD,yD,bD,xD,kD,vD,G$,NF,ND,ID,CD,SD,TD,ED,$D,AD,FD,kF,n$,_D,OD,zD,BD,r$,PD,WD,{kernelName:"UnsortedSegmentSum",backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,segmentIds:a}=t,{numSegments:i}=s,o=r.shape.length,l=[];let u=0;const c=wl([u],o);let p=r;null!=c&&(p=s$({inputs:{x:r},backend:n,attrs:{perm:c}}),l.push(p),u=vl(1,o)[0]);const d=sp(p.shape,u,i),f=h([p.shape[u]]),m=qE({inputs:{x:p},backend:n,attrs:{shape:[-1,f]}});l.push(m);const g=As(r.dtype),y=(e,t,s,r,a)=>{const i=e.shape[0],o=e.shape[1],u=np(o,a),c=new VD({windowSize:u,inSize:o,batchSize:i,numSegments:a},t),h=n.compileAndRun(c,[e,s],r);if(l.push(h),h.shape[1]===a)return h;const p=jF({backend:n,attrs:{start:0,stop:a,step:1,dtype:"float32"}}),d=LD({inputs:{x:p},backend:n,attrs:{reps:[o/u]}});return l.push(p),l.push(d),y(h,t,d,r,a)},b=qE({inputs:{x:y(m,"unsortedSegmentSum",a,g,i)},backend:n,attrs:{shape:d}});let x=b;if(null!=c){l.push(b);const e=kl(c);x=s$({inputs:{x:x},backend:n,attrs:{perm:e}})}return l.forEach(e=>n.disposeIntermediateTensorInfo(e)),x}},MF];for(const e of UD)Yn(e);const GD={"tfjs-core":"3.2.0","tfjs-backend-cpu":"3.2.0","tfjs-backend-webgl":"3.2.0","tfjs-data":"3.2.0","tfjs-layers":"3.2.0","tfjs-converter":"3.2.0",tfjs:"3.2.0"};export{X as Abs,Y as Acos,J as Acosh,Ch as AdadeltaOptimizer,Sh as AdagradOptimizer,Th as AdamOptimizer,Eh as AdamaxOptimizer,Z as Add,Q as AddN,ee as All,te as Any,ne as ArgMax,se as ArgMin,re as Asin,ae as Asinh,ie as Atan,le as Atan2,oe as Atanh,ue as AvgPool,he as AvgPool3D,pe as AvgPool3DGrad,ce as AvgPoolGrad,de as BatchMatMul,fe as BatchToSpaceND,me as Bincount,ge as BroadcastTo,xx as Callback,Fm as CallbackList,ye as Cast,be as Ceil,xe as ClipByValue,we as Complex,ke as ComplexAbs,ve as Concat,Ne as Conv2D,Ie as Conv2DBackpropFilter,Ce as Conv2DBackpropInput,Se as Conv3D,Te as Conv3DBackpropFilterV2,Ee as Conv3DBackpropInputV2,$e as Cos,Ae as Cosh,Fe as CropAndResize,Re as Cumsum,Om as CustomCallback,e as DataStorage,De as DenseBincount,_e as DepthToSpace,Oe as DepthwiseConv2dNative,Me as DepthwiseConv2dNativeBackpropFilter,Le as DepthwiseConv2dNativeBackpropInput,ze as Diag,Be as Dilation2D,We as Dilation2DBackpropFilter,Pe as Dilation2DBackpropInput,j as ENV,vx as EarlyStopping,Ue as Elu,Ge as EluGrad,U as Environment,je as Equal,He as Erf,qe as Exp,Ke as ExpandDims,Xe as Expm1,Ye as FFT,Je as Fill,Ze as FlipLeftRight,Qe as Floor,et as FloorDiv,Pn as FromPixels,tt as FusedBatchNorm,Un as FusedConv2D,Gn as FusedDepthwiseConv2D,st as GatherNd,nt as GatherV2,Lw as GraphModel,rt as Greater,at as GreaterEqual,_m as History,ot as IFFT,it as Identity,lt as Imag,wm as InputSpec,ut as IsFinite,ct as IsInf,ht as IsNan,t as KernelBackend,vt as LRN,Nt as LRNGrad,ym as LayerVariable,Hg as LayersModel,pt as LeakyRelu,dt as Less,ft as LessEqual,mt as LinSpace,gt as Log,yt as Log1p,kt as LogSoftmax,bt as LogicalAnd,xt as LogicalNot,wt as LogicalOr,It as Max,St as MaxPool,Et as MaxPool3D,$t as MaxPool3DGrad,Tt as MaxPoolGrad,At as MaxPoolWithArgmax,Ct as Maximum,Rt as Mean,Ft as Min,Dt as Minimum,_t as MirrorPad,Ot as Mod,Ah as MomentumOptimizer,Mt as Multinomial,Lt as Multiply,zt as Neg,Pt as NonMaxSuppressionV3,Wt as NonMaxSuppressionV4,Vt as NonMaxSuppressionV5,Bt as NotEqual,Ys as OP_SCOPE_SUFFIX,Gt as OneHot,Ut as OnesLike,Ih as Optimizer,Ht as Pack,jt as PadV2,qt as Pool,Kt as Pow,Xt as Prelu,Yt as Prod,Rh as RMSPropOptimizer,Jy as RNN,Jt as Range,Ns as Rank,Zt as Real,Ve as RealDiv,Qt as Reciprocal,uh as Reduction,en as Relu,on as Relu6,tn as Reshape,rn as ResizeBilinear,an as ResizeBilinearGrad,nn as ResizeNearestNeighbor,sn as ResizeNearestNeighborGrad,ln as Reverse,Wn as RotateWithOffset,un as Round,cn as Rsqrt,$h as SGDOptimizer,hn as ScatterNd,pn as Select,dn as Selu,Kg as Sequential,bn as Sigmoid,yn as Sign,mn as Sin,gn as Sinh,fn as Slice,In as Softmax,xn as Softplus,vn as SpaceToBatchND,En as SparseToDense,Nn as SplitV,wn as Sqrt,Sn as Square,Cn as SquaredDifference,Bn as Step,$n as StridedSlice,Tn as Sub,kn as Sum,km as SymbolicTensor,An as Tan,Rn as Tanh,ws as Tensor,gs as TensorBuffer,Fn as Tile,Dn as TopK,_n as Transpose,On as Unique,Mn as Unpack,Ln as UnsortedSegmentSum,vs as Variable,zn as ZerosLike,Vn as _FusedMatMul,mi as abs,gi as acos,yi as acosh,hi as add,bi as addN,xi as all,wi as any,ki as argMax,vi as argMin,Ni as asin,Ii as asinh,Ci as atan,Si as atan2,Ti as atanh,Vi as avgPool,Ui as avgPool3d,ui as backend,lp as backend_util,Ki as basicLSTMCell,Yi as batchNorm,Ji as batchNorm2d,Zi as batchNorm3d,Qi as batchNorm4d,Xi as batchToSpaceND,eo as bincount,dc as booleanMaskAsync,to as broadcastTo,ca as browser,Lr as buffer,Nx as callbacks,zr as cast,no as ceil,so as clipByValue,Br as clone,Zs as complex,Gi as concat,ro as concat1d,ao as concat2d,io as concat3d,oo as concat4d,tf as constraints,uo as conv1d,lo as conv2d,ho as conv2dTranspose,po as conv3d,mo as conv3dTranspose,es as copyRegisteredKernels,go as cos,yo as cosh,kc as cosineWindow,bo as cumsum,il as customGrad,Pk as data,xo as denseBincount,qa as deprecationWarn,wo as depthToSpace,ko as depthwiseConv2d,$x as deregisterOp,Gs as device_util,vo as diag,No as dilation2d,ja as disableDeprecationWarnings,Qa as dispose,Ka as disposeVariables,di as div,Ao as divNoNan,Ro as dot,xc as dropout,Fo as elu,Ha as enableDebugMode,Ga as enableProdMode,wc as enclosingPowerOfTwo,Xa as engine,G as env,To as equal,Do as erf,_o as exp,Oo as expandDims,Mo as expm1,zo as eye,Vu as fft,Bo as fill,ii as findBackend,oi as findBackendFactory,Po as floor,pi as floorDiv,Dc as fused,Wo as gather,bc as gatherND,pa as gather_util,ri as getBackend,Kn as getGradient,qn as getKernel,Xn as getKernelsForBackend,tl as grad,nl as grads,Vo as greater,Uo as greaterEqual,Uu as ifft,Go as imag,kh as image,vc as inTopKAsync,om as initializers,Zg as input,ta as io,Gu as irfft,Ho as isFinite,jo as isInf,qo as isNaN,ei as keep,up as kernel_impls,mx as layers,Ko as leakyRelu,Xo as less,Yo as lessEqual,vh as linalg,Jo as linspace,zw as loadGraphModel,Jg as loadLayersModel,Zo as localResponseNormalization,Qo as log,el as log1p,cl as logSigmoid,fl as logSoftmax,Nl as logSumExp,Il as logicalAnd,Cl as logicalNot,Sl as logicalOr,Tl as logicalXor,Nh as losses,na as matMul,ia as math,hl as max,El as maxPool,$l as maxPool3d,Al as maxPoolWithArgmax,Rl as maximum,Fl as mean,Ya as memory,gx as metrics,Dl as min,_l as minimum,Ol as mirrorPad,Ml as mod,Xg as model,yx as models,zl as moments,mc as movingAverage,fi as mul,Bl as multiRNNCell,Pl as multinomial,ll as neg,Oh as nextFrame,fc as norm,Wl as notEqual,sa as oneHot,Ul as ones,Gl as onesLike,Js as op,Hl as outerProduct,jl as pad,ql as pad1d,Kl as pad2d,Xl as pad3d,Yl as pad4d,Zl as pool,Ql as pow,eu as prelu,Pr as print,tu as prod,Ja as profile,nu as rand,mu as randomGamma,gu as randomNormal,yu as randomUniform,bu as range,si as ready,xu as real,wu as reciprocal,li as registerBackend,Qg as registerCallbackConstructor,Jn as registerGradient,Yn as registerKernel,Tx as registerOp,bx as regularizers,ku as relu,vu as relu6,ai as removeBackend,Wi as reshape,Nu as reverse,Iu as reverse1d,Cu as reverse2d,Su as reverse3d,Tu as reverse4d,ju as rfft,Eu as round,$u as rsqrt,Au as scalar,gc as scatterND,ga as scatter_util,Ru as selu,Fu as separableConv2d,Yg as sequential,La as serialization,ni as setBackend,ci as setPlatform,Du as setdiff1dAsync,Hi as sigmoid,_u as sign,wh as signal,Ou as sin,Mu as sinh,ji as slice,Lu as slice1d,zu as slice2d,Bu as slice3d,Pu as slice4d,Da as slice_util,Wu as softmax,ul as softplus,Jl as spaceToBatchND,yc as sparseToDense,xh as spectral,Hu as split,qu as sqrt,Ll as square,Ku as squaredDifference,Xu as squeeze,Yu as stack,Ju as step,Zu as stridedSlice,pl as sub,dl as sum,As as sumOutType,Qu as tan,qi as tanh,er as tensor,ec as tensor1d,tc as tensor2d,oa as tensor3d,nc as tensor4d,sc as tensor5d,rc as tensor6d,Os as tensor_util,Va as test_util,Za as tidy,Lo as tile,ti as time,ac as topk,Dh as train,ra as transpose,ic as truncatedNormal,oc as unique,Qn as unregisterGradient,Zn as unregisterKernel,lc as unsortedSegmentSum,uc as unstack,$s as upcastType,ls as util,sl as valueAndGrad,rl as valueAndGrads,cc as variable,al as variableGrads,GD as version,Bw as version_converter,Ua as version_core,yg as version_layers,Eo as where,pc as whereAsync,Vl as zeros,$o as zerosLike};
//# sourceMappingURL=tf.fesm.min.js.map
