/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e=e||self).tf=e.tf||{})}(this,(function(e){"use strict";class t{constructor(e,t){this.backend=e,this.dataMover=t,this.data=new WeakMap,this.dataIdsCount=0}get(e){return this.data.has(e)||this.dataMover.moveData(this.backend,e),this.data.get(e)}set(e,t){this.dataIdsCount++,this.data.set(e,t)}has(e){return this.data.has(e)}delete(e){return this.dataIdsCount--,this.data.delete(e)}numDataIds(){return this.dataIdsCount}}class n{refCount(e){return s("refCount")}incRef(e){return s("incRef")}timerAvailable(){return!0}time(e){return s("time")}read(e){return s("read")}readSync(e){return s("readSync")}numDataIds(){return s("numDataIds")}disposeData(e,t){return s("disposeData")}write(e,t,n){return s("write")}move(e,t,n,r,a){return s("move")}memory(){return s("memory")}floatPrecision(){return s("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return s("dispose")}}function s(e){throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function r(e){let t=e.length,n=0,s=0;for(;t>0;)s=Math.random()*t|0,t--,n=e[t],e[t]=e[s],e[s]=n}function a(e,t,n){return Math.max(e,Math.min(t,n))}function i(e){return e%2==0?e:e+1}function o(e){let t=0;for(let n=0;n<e.length;n++)t+=e[n];return t}function l(e,t){if(!e)throw new Error("string"==typeof t?t:t())}function u(e,t,n=""){l(d(e,t),(()=>n+` Shapes ${e} and ${t} must match`))}function c(e){l(null!=e,(()=>"The input to the tensor constructor must be a non-null value."))}function h(e,t=[],n=!1){if(null==t&&(t=[]),Array.isArray(e)||C(e)&&!n)for(let s=0;s<e.length;++s)h(e[s],t,n);else t.push(e);return t}function p(e){if(0===e.length)return 1;let t=e[0];for(let n=1;n<e.length;n++)t*=e[n];return t}function d(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function f(e){return e%1==0}function m(e){const t=Math.ceil(Math.sqrt(e));return[t,Math.ceil(e/t)]}function g(e,t){return t<=e.length?e:e+" ".repeat(t-e.length)}function y(e,t=(e=>0),n){return new Promise(((s,r)=>{let a=0;const i=()=>{if(e())return void s();a++;const o=t(a);null!=n&&a>=n?r():setTimeout(i,o)};i()}))}function b(e,t){let n=1,s=-1;for(let t=0;t<e.length;++t)if(e[t]>=0)n*=e[t];else if(-1===e[t]){if(-1!==s)throw Error(`Shapes can only have 1 implicit size. Found -1 at dim ${s} and dim ${t}`);s=t}else if(e[t]<0)throw Error(`Shapes can not be < 0. Found ${e[t]} at dim ${t}`);if(-1===s){if(t>0&&t!==n)throw Error(`Size(${t}) must match the product of shape ${e}`);return e}if(0===n)throw Error(`Cannot infer the missing size in [${e}] when there are 0 elements`);if(t%n!=0)throw Error(`The implicit shape can't be a fractional number. Got ${t} / ${n}`);const r=e.slice();return r[s]=t/n,r}function x(e,t){const n=t.length;return l((e=null==e?t.map(((e,t)=>t)):[].concat(e)).every((e=>e>=-n&&e<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${e}`)),l(e.every((e=>f(e))),(()=>`All values in axis param must be integers but got axis ${e}`)),e.map((e=>e<0?n+e:e))}function w(e,t){const n=[],s=[],r=null!=t&&Array.isArray(t)&&0===t.length,a=null==t||r?null:x(t,e).sort();let i=0;for(let t=0;t<e.length;++t){if(null!=a){if(a[i]===t&&1!==e[t])throw new Error(`Can't squeeze axis ${t} since its dim '${e[t]}' is not 1`);(null==a[i]||a[i]>t)&&1===e[t]&&(n.push(e[t]),s.push(t)),a[i]<=t&&i++}1!==e[t]&&(n.push(e[t]),s.push(t))}return{newShape:n,keptDims:s}}function k(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else{if("bool"!==e)throw new Error(`Unknown data type ${e}`);n=new Uint8Array(t)}return n}function v(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else if("bool"===e)n=new Uint8Array(t);else{if("string"!==e)throw new Error(`Unknown data type ${e}`);n=new Array(t)}return n}function N(e,t){for(let n=0;n<e.length;n++){const s=e[n];if(isNaN(s)||!isFinite(s))throw Error(`A tensor of type ${t} being uploaded contains ${s}.`)}}function I(e){return"bool"===e||"complex64"===e||"float32"===e||"int32"===e||"string"===e}function $(e,t){return"complex64"!==t&&(("float32"!==t||"complex64"===e)&&(("int32"!==t||"float32"===e||"complex64"===e)&&("bool"!==t||"bool"!==e)))}function C(e){return e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array}function S(e){if("float32"===e||"int32"===e)return 4;if("complex64"===e)return 8;if("bool"===e)return 1;throw new Error(`Unknown dtype ${e}`)}function T(e){if(null==e)return 0;let t=0;return e.forEach((e=>t+=e.length)),t}function E(e){return"string"==typeof e||e instanceof String}function A(e){return"boolean"==typeof e}function R(e){return"number"==typeof e}function F(e){return Array.isArray(e)?F(e[0]):e instanceof Float32Array?"float32":e instanceof Int32Array||e instanceof Uint8Array?"int32":R(e)?"float32":E(e)?"string":A(e)?"bool":"float32"}function D(e){return!!(e&&e.constructor&&e.call&&e.apply)}function _(e,t){for(let n=t;n<e;++n)if(e%n==0)return n;return e}function O(e){const t=e.length;if(t<2)return[];const n=new Array(t-1);n[t-2]=e[t-1];for(let s=t-3;s>=0;--s)n[s]=n[s+1]*e[s+1];return n}function M(e,t,n,s=!1){const r=new Array;if(1===t.length){const a=t[0]*(s?2:1);for(let t=0;t<a;t++)r[t]=n[e+t]}else{const a=t[0],i=t.slice(1),o=i.reduce(((e,t)=>e*t))*(s?2:1);for(let t=0;t<a;t++)r[t]=M(e+t*o,i,n,s)}return r}function L(e,t,n=!1){if(0===e.length)return t[0];const s=e.reduce(((e,t)=>e*t))*(n?2:1);if(0===s)return[];if(s!==t.length)throw new Error(`[${e}] does not match the input size ${t.length}${n?" for a complex tensor":""}.`);return M(0,e,t,n)}function z(e,t){const n=B(e,t);for(let e=0;e<n.length;e++)n[e]=1;return n}function B(e,t){if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t)return new Uint8Array(e);throw new Error(`Unknown data type ${t}`)}function P(e,t){const n=e.reduce(((e,t)=>e*t),1);if(null==t||"float32"===t)return L(e,new Float32Array(n));if("int32"===t)return L(e,new Int32Array(n));if("bool"===t)return L(e,new Uint8Array(n));throw new Error(`Unknown data type ${t}`)}function W(e){e.forEach((t=>{l(Number.isInteger(t)&&t>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${e}].`))}))}function V(e,t,n){if(0===t)return 0;if(1===t)return e[0];let s=e[e.length-1];for(let t=0;t<e.length-1;++t)s+=n[t]*e[t];return s}function U(e,t,n){if(0===t)return[];if(1===t)return[e];const s=new Array(t);for(let t=0;t<s.length-1;++t)s[t]=Math.floor(e/n[t]),e-=s[t]*n[t];return s[s.length-1]=e,s}function G(e){return e&&e.then&&"function"==typeof e.then}const H="tfjsflags";class j{constructor(e){this.global=e,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=q,this.populateURLFlags()}setPlatform(e,t){null!=this.platform&&console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${t}.`),this.platformName=e,this.platform=t}registerFlag(e,t,n){if(this.flagRegistry[e]={evaluationFn:t,setHook:n},null!=this.urlFlags[e]){const t=this.urlFlags[e];console.warn(`Setting feature override from URL ${e}: ${t}.`),this.set(e,t)}}async getAsync(e){return e in this.flags||(this.flags[e]=await this.evaluateFlag(e)),this.flags[e]}get(e){if(e in this.flags)return this.flags[e];const t=this.evaluateFlag(e);if(G(t))throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[e]=t,this.flags[e]}getNumber(e){return this.get(e)}getBool(e){return this.get(e)}getFlags(){return this.flags}get features(){return this.flags}set(e,t){if(null==this.flagRegistry[e])throw new Error(`Cannot set flag ${e} as it has not been registered.`);this.flags[e]=t,null!=this.flagRegistry[e].setHook&&this.flagRegistry[e].setHook(t)}evaluateFlag(e){if(null==this.flagRegistry[e])throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);return this.flagRegistry[e].evaluationFn()}setFlags(e){this.flags=Object.assign({},e)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if(void 0===this.global||void 0===this.global.location||void 0===this.global.location.search)return;const e=this.getQueryParams(this.global.location.search);if(H in e){e.tfjsflags.split(",").forEach((e=>{const[t,n]=e.split(":");this.urlFlags[t]=function(e,t){if("true"===(t=t.toLowerCase())||"false"===t)return"true"===t;if(""+ +t===t)return+t;throw new Error(`Could not parse value flag value ${t} for flag ${e}.`)}(t,n)}))}}}function q(e){const t={};return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((e,...n)=>(function(e,t,n){e[decodeURIComponent(t)]=decodeURIComponent(n||"")}(t,n[0],n[1]),n.join("=")))),t}function K(){return e.ENV}let X;function Y(){if(null==X){let e;if("undefined"!=typeof window)e=window;else if("undefined"!=typeof global)e=global;else if("undefined"!=typeof process)e=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");e=self}X=e}return X}function J(e,t){const n=function(){const e=Y();return null==e._tfGlobals&&(e._tfGlobals=new Map),e._tfGlobals}();if(n.has(e))return n.get(e);{const s=t();return n.set(e,s),n.get(e)}}e.ENV=null;const Z="Abs",Q="Acos",ee="Acosh",te="Add",ne="AddN",se="All",re="Any",ae="ArgMax",ie="ArgMin",oe="Asin",le="Asinh",ue="Atan",ce="Atanh",he="Atan2",pe="AvgPool",de="AvgPoolGrad",fe="AvgPool3D",me="AvgPool3DGrad",ge="BatchMatMul",ye="BatchToSpaceND",be="Bincount",xe="BroadcastTo",we="Cast",ke="Ceil",ve="ClipByValue",Ne="Complex",Ie="ComplexAbs",$e="Concat",Ce="Conv2D",Se="Conv2DBackpropFilter",Te="Conv2DBackpropInput",Ee="Conv3D",Ae="Conv3DBackpropFilterV2",Re="Conv3DBackpropInputV2",Fe="Cos",De="Cosh",_e="Cumsum",Oe="CropAndResize",Me="DenseBincount",Le="DepthToSpace",ze="DepthwiseConv2dNative",Be="DepthwiseConv2dNativeBackpropFilter",Pe="DepthwiseConv2dNativeBackpropInput",We="Diag",Ve="Dilation2D",Ue="Dilation2DBackpropInput",Ge="Dilation2DBackpropFilter",He="RealDiv",je="Einsum",qe="Elu",Ke="EluGrad",Xe="Erf",Ye="Equal",Je="Exp",Ze="ExpandDims",Qe="Expm1",et="FFT",tt="Fill",nt="FlipLeftRight",st="Floor",rt="FloorDiv",at="FusedBatchNorm",it="GatherV2",ot="GatherNd",lt="Greater",ut="GreaterEqual",ct="Identity",ht="IFFT",pt="Imag",dt="IsFinite",ft="IsInf",mt="IsNan",gt="LeakyRelu",yt="Less",bt="LessEqual",xt="LinSpace",wt="Log",kt="Log1p",vt="LogicalAnd",Nt="LogicalNot",It="LogicalOr",$t="LogSoftmax",Ct="LRN",St="LRNGrad",Tt="Max",Et="Maximum",At="MaxPool",Rt="MaxPoolGrad",Ft="MaxPool3D",Dt="MaxPool3DGrad",_t="MaxPoolWithArgmax",Ot="Mean",Mt="Min",Lt="Minimum",zt="MirrorPad",Bt="Mod",Pt="Multinomial",Wt="Multiply",Vt="Neg",Ut="NotEqual",Gt="NonMaxSuppressionV3",Ht="NonMaxSuppressionV4",jt="NonMaxSuppressionV5",qt="OnesLike",Kt="OneHot",Xt="Pack",Yt="PadV2",Jt="Pow",Zt="Prelu",Qt="Prod",en="Range",tn="Real",nn="Reciprocal",sn="Relu",rn="Reshape",an="ResizeNearestNeighbor",on="ResizeNearestNeighborGrad",ln="ResizeBilinear",un="ResizeBilinearGrad",cn="Relu6",hn="Reverse",pn="Round",dn="Rsqrt",fn="ScatterNd",mn="Select",gn="Selu",yn="Slice",bn="Sin",xn="Sinh",wn="Sign",kn="Sigmoid",vn="Softplus",Nn="Sqrt",In="Sum",$n="SpaceToBatchND",Cn="SplitV",Sn="Softmax",Tn="SparseFillEmptyRows",En="SparseReshape",An="SparseToDense",Rn="SquaredDifference",Fn="Square",Dn="StridedSlice",_n="Sub",On="Tan",Mn="Tanh",Ln="Tile",zn="TopK",Bn="Transform",Pn="Transpose",Wn="Unique",Vn="Unpack",Un="UnsortedSegmentSum",Gn="ZerosLike",Hn="Step",jn="FromPixels",qn="RotateWithOffset",Kn="_FusedMatMul",Xn="FusedConv2D",Yn="FusedDepthwiseConv2D",Jn=J("kernelRegistry",(()=>new Map)),Zn=J("gradRegistry",(()=>new Map));function Qn(e,t){const n=rs(e,t);return Jn.get(n)}function es(e){return Zn.get(e)}function ts(e){const t=Jn.entries(),n=[];for(;;){const{done:s,value:r}=t.next();if(s)break;const[a,i]=r,[o]=a.split("_");o===e&&n.push(i)}return n}function ns(e){const{kernelName:t,backendName:n}=e,s=rs(t,n);Jn.has(s)&&console.warn(`The kernel '${t}' for backend '${n}' is already registered`),Jn.set(s,e)}function ss(e){const{kernelName:t}=e;Zn.has(t)&&K().getBool("DEBUG")&&console.warn(`Overriding the gradient for '${t}'`),Zn.set(t,e)}function rs(e,t){return`${t}_${e}`}function as(e,t){return"string"===t?us(e):is([e],t)}function is(e,t){if("string"===t)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(e)&&(e=h(e)),K().getBool("DEBUG")&&N(e,t),function(e,t){return e instanceof Float32Array&&"float32"===t||e instanceof Int32Array&&"int32"===t||e instanceof Uint8Array&&"bool"===t}(e,t))return e;if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t){const t=new Uint8Array(e.length);for(let n=0;n<t.length;++n)0!==Math.round(e[n])&&(t[n]=1);return t}throw new Error(`Unknown data type ${t}`)}function os(){return K().platform.now()}function ls(e,t){return K().platform.fetch(e,t)}function us(e,t="utf-8"){return t=t||"utf-8",K().platform.encode(e,t)}function cs(e,t="utf-8"){return t=t||"utf-8",K().platform.decode(e,t)}var hs=Object.freeze({__proto__:null,createScalarValue:as,toTypedArray:is,now:os,fetch:ls,encodeString:us,decodeString:cs,shuffle:r,shuffleCombo:function(e,t){if(e.length!==t.length)throw new Error(`Array sizes must match to be shuffled together First array length was ${e.length}Second array length was ${t.length}`);let n,s,r=e.length,a=0;for(;r>0;)a=Math.random()*r|0,r--,n=e[r],s=t[r],e[r]=e[a],t[r]=t[a],e[a]=n,t[a]=s},clamp:a,nearestLargerEven:i,sum:o,randUniform:function(e,t){const n=Math.random();return t*n+(1-n)*e},distSquared:function(e,t){let n=0;for(let s=0;s<e.length;s++){const r=Number(e[s])-Number(t[s]);n+=r*r}return n},assert:l,assertShapesMatch:u,assertNonNull:c,flatten:h,sizeFromShape:p,isScalarShape:function(e){return 0===e.length},arraysEqual:d,isInt:f,tanh:function(e){if(null!=Math.tanh)return Math.tanh(e);if(e===1/0)return 1;if(e===-1/0)return-1;{const t=Math.exp(2*e);return(t-1)/(t+1)}},sizeToSquarishShape:m,createShuffledIndices:function(e){const t=new Uint32Array(e);for(let n=0;n<e;++n)t[n]=n;return r(t),t},rightPad:g,repeatedTry:y,inferFromImplicitShape:b,parseAxisParam:x,squeezeShape:w,getTypedArrayFromDType:k,getArrayFromDType:v,checkConversionForErrors:N,isValidDtype:I,hasEncodingLoss:$,isTypedArray:C,bytesPerElement:S,bytesFromStringArray:T,isString:E,isBoolean:A,isNumber:R,inferDtype:F,isFunction:D,nearestDivisor:_,computeStrides:O,toNestedArray:L,makeOnesTypedArray:z,makeZerosTypedArray:B,makeZerosNestedTypedArray:P,assertNonNegativeIntegerDimensions:W,locToIndex:V,indexToLoc:U,isPromise:G});class ps{constructor(e,t){this.backendTimer=e,this.logger=t,null==t&&(this.logger=new fs)}profileKernel(e,t,n){let s;const r=()=>{s=n()};let a;const i=os();if(this.backendTimer.timerAvailable())a=this.backendTimer.time(r);else{r();for(const e of s)e.dataSync();a=Promise.resolve({kernelMs:os()-i})}if(K().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let t=0;t<s.length;t++){const n=s[t];n.data().then((t=>{ds(t,n.dtype,e)}))}return{kernelName:e,outputs:s,inputs:t,timeMs:a.then((e=>e.kernelMs)),extraInfo:a.then((e=>null!=e.getExtraProfileInfo?e.getExtraProfileInfo():""))}}logKernelProfile(e){const{kernelName:t,outputs:n,timeMs:s,inputs:r,extraInfo:a}=e;n.forEach((e=>{Promise.all([e.data(),s,a]).then((n=>{this.logger.logKernelProfile(t,e,n[0],n[1],r,n[2])}))}))}}function ds(e,t,n){if("float32"!==t)return!1;for(let t=0;t<e.length;t++){const s=e[t];if(isNaN(s)||!isFinite(s))return console.warn(`Found ${s} in the result of '${n}'`),!0}return!1}class fs{logKernelProfile(e,t,n,s,r,a){const i="number"==typeof s?g(`${s}ms`,9):s.error,o=g(e,25),l=t.rank,u=t.size,c=g(t.shape.toString(),14);let h="";for(const e in r){const n=r[e];if(null!=n){const s=n.shape||t.shape,r=s.length;h+=`${e}: ${r}D ${r>0?s:""} `}}console.log(`%c${o}\t%c${i}\t%c${l}D ${c}\t%c${u}\t%c${h}\t%c${a}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function ms(e,t,n,s){const r=O(t),a=function(e,t,n,s){const r=p(t),a=s[s.length-1],i=new Array(a).fill(0),o=t.length,l="complex64"===n?xs(e):e;if(o>1)for(let e=0;e<r/a;e++){const t=e*a;for(let e=0;e<a;e++)i[e]=Math.max(i[e],gs(l[t+e],0,n).length)}return i}(e,t,n,r),i=t.length,o=bs(e,t,n,r,a),l=["Tensor"];return s&&(l.push(`  dtype: ${n}`),l.push(`  rank: ${i}`),l.push(`  shape: [${t}]`),l.push("  values:")),l.push(o.map((e=>"    "+e)).join("\n")),l.join("\n")}function gs(e,t,n){let s;return s=Array.isArray(e)?`${parseFloat(e[0].toFixed(7))} + ${parseFloat(e[1].toFixed(7))}j`:E(e)?`'${e}'`:"bool"===n?ys(e):parseFloat(e.toFixed(7)).toString(),g(s,t)}function ys(e){return 0===e?"false":"true"}function bs(e,t,n,s,r,a=!0){const i="complex64"===n?2:1,o=t[0],l=t.length;if(0===l){if("complex64"===n){return[gs(xs(e)[0],0,n)]}return"bool"===n?[ys(e[0])]:[e[0].toString()]}if(1===l){if(o>20){const t=3*i;let s=Array.from(e.slice(0,t)),a=Array.from(e.slice((o-3)*i,o*i));return"complex64"===n&&(s=xs(s),a=xs(a)),["["+s.map(((e,t)=>gs(e,r[t],n))).join(", ")+", ..., "+a.map(((e,t)=>gs(e,r[o-3+t],n))).join(", ")+"]"]}return["["+("complex64"===n?xs(e):Array.from(e)).map(((e,t)=>gs(e,r[t],n))).join(", ")+"]"]}const u=t.slice(1),c=s.slice(1),h=s[0]*i,p=[];if(o>20){for(let t=0;t<3;t++){const s=t*h,a=s+h;p.push(...bs(e.slice(s,a),u,n,c,r,!1))}p.push("...");for(let t=o-3;t<o;t++){const s=t*h,a=s+h;p.push(...bs(e.slice(s,a),u,n,c,r,t===o-1))}}else for(let t=0;t<o;t++){const s=t*h,a=s+h;p.push(...bs(e.slice(s,a),u,n,c,r,t===o-1))}const d=2===l?",":"";p[0]="["+p[0]+d;for(let e=1;e<p.length-1;e++)p[e]=" "+p[e]+d;let f=",\n";for(let e=2;e<l;e++)f+="\n";return p[p.length-1]=" "+p[p.length-1]+"]"+(a?"":f),p}function xs(e){const t=[];for(let n=0;n<e.length;n+=2)t.push([e[n],e[n+1]]);return t}class ws{constructor(e,t,n){if(this.dtype=t,this.shape=e.slice(),this.size=p(e),null!=n){const e=n.length;l(e===this.size,(()=>`Length of values '${e}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===t)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||v(t,this.size),this.strides=O(e)}set(e,...t){0===t.length&&(t=[0]),l(t.length===this.rank,(()=>`The number of provided coordinates (${t.length}) must match the rank (${this.rank})`));const n=this.locToIndex(t);this.values[n]=e}get(...e){0===e.length&&(e=[0]);let t=0;for(const n of e){if(n<0||n>=this.shape[t]){const t=`Requested out of range element at ${e}.   Buffer shape=${this.shape}`;throw new Error(t)}t++}let n=e[e.length-1];for(let t=0;t<e.length-1;++t)n+=this.strides[t]*e[t];return this.values[n]}locToIndex(e){if(0===this.rank)return 0;if(1===this.rank)return e[0];let t=e[e.length-1];for(let n=0;n<e.length-1;++n)t+=this.strides[n]*e[n];return t}indexToLoc(e){if(0===this.rank)return[];if(1===this.rank)return[e];const t=new Array(this.shape.length);for(let n=0;n<t.length-1;++n)t[n]=Math.floor(e/this.strides[n]),e-=t[n]*this.strides[n];return t[t.length-1]=e,t}get rank(){return this.shape.length}toTensor(){return ks().makeTensor(this.values,this.shape,this.dtype)}}let ks=null,vs=null,Ns=null;class Is{constructor(e,t,n,s){this.kept=!1,this.isDisposedInternal=!1,this.shape=e.slice(),this.dtype=t||"float32",this.size=p(e),this.strides=O(e),this.dataId=n,this.id=s,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const e=await this.data();return vs.buffer(this.shape,this.dtype,e)}bufferSync(){return vs.buffer(this.shape,this.dtype,this.dataSync())}async array(){const e=await this.data();return L(this.shape,e,"complex64"===this.dtype)}arraySync(){return L(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const e=ks().read(this.dataId);if("string"===this.dtype){const t=await e;try{return t.map((e=>cs(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return e}dataSync(){this.throwIfDisposed();const e=ks().readSync(this.dataId);if("string"===this.dtype)try{return e.map((e=>cs(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return e}async bytes(){this.throwIfDisposed();const e=await ks().read(this.dataId);return"string"===this.dtype?e:new Uint8Array(e.buffer)}dispose(){this.isDisposed||(ks().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(e=!1){return vs.print(this,e)}clone(){return this.throwIfDisposed(),vs.clone(this)}toString(e=!1){return ms(this.dataSync(),this.shape,this.dtype,e)}cast(e){return this.throwIfDisposed(),vs.cast(this,e)}variable(e=!0,t,n){return this.throwIfDisposed(),ks().makeVariable(this,e,t,n)}}function $s(){return J("Tensor",(()=>Is))}Object.defineProperty(Is,Symbol.hasInstance,{value:e=>!!e&&null!=e.data&&null!=e.dataSync&&null!=e.throwIfDisposed}),$s();class Cs extends Is{constructor(e,t,n,s){super(e.shape,e.dtype,e.dataId,s),this.trainable=t,this.name=n}assign(e){if(e.dtype!==this.dtype)throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);if(!d(e.shape,this.shape))throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);ks().disposeTensor(this),this.dataId=e.dataId,ks().incRef(this,null)}dispose(){ks().disposeVariable(this),this.isDisposedInternal=!0}}var Ss,Ts,Es,As,Rs;Object.defineProperty(Cs,Symbol.hasInstance,{value:e=>e instanceof Is&&null!=e.assign&&e.assign instanceof Function}),(Ss=e.Rank||(e.Rank={})).R0="R0",Ss.R1="R1",Ss.R2="R2",Ss.R3="R3",Ss.R4="R4",Ss.R5="R5",Ss.R6="R6",function(e){e.float32="float32",e.int32="int32",e.bool="int32",e.complex64="complex64"}(Ts||(Ts={})),function(e){e.float32="float32",e.int32="int32",e.bool="bool",e.complex64="complex64"}(Es||(Es={})),function(e){e.float32="float32",e.int32="float32",e.bool="float32",e.complex64="complex64"}(As||(As={})),function(e){e.float32="complex64",e.int32="complex64",e.bool="complex64",e.complex64="complex64"}(Rs||(Rs={}));const Fs={float32:As,int32:Ts,bool:Es,complex64:Rs};function Ds(e,t){if("string"===e||"string"===t){if("string"===e&&"string"===t)return"string";throw new Error(`Can not upcast ${e} with ${t}`)}return Fs[e][t]}function _s(e){return Ds(e,"int32")}function Os(e,t){if(e.dtype===t.dtype)return[e,t];const n=Ds(e.dtype,t.dtype);return[e.cast(n),t.cast(n)]}function Ms(e,t){l(e.dtype===t.dtype,(()=>`The dtypes of the first(${e.dtype}) and second(${t.dtype}) input must match`))}function Ls(e,t){return t.some((t=>t.id===e.id))}function zs(e){const t=[];return Bs(e,t,new Set),t}function Bs(e,t,n){if(null==e)return;if(e instanceof Is)return void t.push(e);if(s=e,!Array.isArray(s)&&"object"!=typeof s)return;var s;const r=e;for(const e in r){const s=r[e];n.has(s)||(n.add(s),Bs(s,t,n))}}var Ps=Object.freeze({__proto__:null,makeTypesMatch:Os,assertTypesMatch:Ms,isTensorInList:Ls,getTensorsInContainer:zs});function Ws(e){return null!=e.kernelName}class Vs{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((e=>e.name))))}}}dispose(){for(const e in this.registeredVariables)this.registeredVariables[e].dispose()}}class Us{constructor(e){this.ENV=e,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new Vs}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:e,asyncInit:t}=this.initializeBackendsAndReturnBest();if(t)throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(e)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(e){if(!(e in this.registry)){if(!(e in this.registryFactory))return null;{const{asyncInit:t}=this.initializeBackend(e);if(t)return null}}return this.registry[e]}findBackendFactory(e){return e in this.registryFactory?this.registryFactory[e].factory:null}registerBackend(e,t,n=1){return e in this.registryFactory?(console.warn(`${e} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[e]={factory:t,priority:n},!0)}async setBackend(e){if(null==this.registryFactory[e])throw new Error(`Backend name '${e}' not found in registry`);if(this.backendName=e,null==this.registry[e]){this.backendInstance=null;const{success:t,asyncInit:n}=this.initializeBackend(e);if(!(n?await t:t))return!1}return this.backendInstance=this.registry[e],this.setupRegisteredKernels(),this.profiler=new ps(this.backendInstance),!0}setupRegisteredKernels(){ts(this.backendName).forEach((e=>{null!=e.setupFunc&&e.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(e){ts(e).forEach((t=>{null!=t.disposeFunc&&t.disposeFunc(this.registry[e])}))}initializeBackend(e){const t=this.registryFactory[e];if(null==t)throw new Error(`Cannot initialize backend ${e}, no registration found.`);try{const s=t.factory();if(!s||s instanceof n||"function"!=typeof s.then)return this.registry[e]=s,{success:!0,asyncInit:!1};{const t=++this.pendingBackendInitId,n=s.then((n=>!(t<this.pendingBackendInitId)&&(this.registry[e]=n,this.pendingBackendInit=null,!0))).catch((n=>(t<this.pendingBackendInitId||(this.pendingBackendInit=null,console.warn(`Initialization of backend ${e} failed`),console.warn(n.stack||n.message)),!1)));return this.pendingBackendInit=n,{success:n,asyncInit:!0}}}catch(t){return console.warn(`Initialization of backend ${e} failed`),console.warn(t.stack||t.message),{success:!1,asyncInit:!1}}}removeBackend(e){if(!(e in this.registryFactory))throw new Error(`${e} backend not found in registry`);this.backendName===e&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,e in this.registry&&(this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e]),delete this.registryFactory[e],this.backendName===e&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((e,t)=>this.registryFactory[t].priority-this.registryFactory[e].priority))}initializeBackendsAndReturnBest(){const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t],{success:s,asyncInit:r}=this.initializeBackend(n);if(r||s)return{name:n,asyncInit:r}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(e,t){const n=this.state.tensorInfo.get(t),s=n.backend,r=this.readSync(t),a=s.refCount(t);s.disposeData(t,!0),n.backend=e,e.move(t,r,n.shape,n.dtype,a),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(e,t){let n,s=null;if(null==t){if("function"!=typeof e)throw new Error("Please provide a function to tidy()");t=e}else{if("string"!=typeof e&&!(e instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof t)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");s=e}return this.scopedRun((()=>this.startScope(s)),(()=>this.endScope(n)),(()=>(n=t(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(e,t,n){e();try{const e=n();return t(),e}catch(e){throw t(),e}}nextTensorId(){return Us.nextTensorId++}nextVariableId(){return Us.nextVariableId++}clone(e){const t=Hs.runKernel(ct,{x:e}),n={x:e};return this.addTapeNode(this.state.activeScope.name,n,[t],(e=>({x:()=>{const t={x:e},n={dtype:"float32"};return Hs.runKernel(we,t,n)}})),[],{}),t}runKernel(e,t,n){if(!(null!=Qn(e,this.backendName)))throw new Error(`Kernel '${e}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:e,inputs:t,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(e,t,n){const s=this.backend.numDataIds();let r=0;n.forEach((e=>{r+="complex64"===e.dtype?3:1}));const a=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],i=s-t-r-a;if(i>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${i} data ids) after running '${e}'`)}runKernelFunc(e){let t,n=[];const s=this.isTapeOn(),r=this.state.numBytes,a=this.state.numTensors;let i,o;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const u=Ws(e)?e.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(Ws(e)){const{kernelName:t,inputs:r,attrs:a}=e;null==this.backendName&&this.backend;const u=Qn(t,this.backendName);l(null!=u,(()=>`Cannot find registered kernel '${t}' for backend '${this.backendName}'`)),i=()=>{const e=this.backend.numDataIds();o=u.kernelFunc({inputs:r,attrs:a,backend:this.backend});const i=Array.isArray(o)?o:[o];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(t,e,i);const l=i.map((e=>{if(null!=e.rank)return e;const{dataId:t,shape:n,dtype:s}=e;return this.makeTensorFromDataId(t,n,s)}));if(s){const e=this.getTensorsForGradient(t,r,l);n=this.saveTensorsForBackwardMode(e)}return l}}else{const{forwardFunc:t}=e,r=e=>{s&&(n=e.map((e=>this.keep(this.clone(e)))))};i=()=>{const e=this.backend.numDataIds();o=this.tidy((()=>t(this.backend,r)));const n=Array.isArray(o)?o:[o];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(u,e,n),n}}const{inputs:c,attrs:h}=e,p=Ws(e)?null:e.backwardsFunc;let d;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(d=this.profiler.profileKernel(u,c,(()=>i())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(d),t=d.outputs):t=i()})),s&&this.addTapeNode(u,c,t,p,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:u,bytesAdded:this.state.numBytes-r,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-a,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(c).map((e=>null!=c[e]?c[e].shape:null)),outputShapes:t.map((e=>e.shape)),kernelTimeMs:d.timeMs,extraInfo:d.extraInfo}),Array.isArray(o)?t:t[0]}saveTensorsForBackwardMode(e){return e.map((e=>this.keep(this.clone(e))))}getTensorsForGradient(e,t,n){const s=es(e);if(null!=s){const e=s.inputsToSave||[],r=s.outputsToSave||[];let a;s.saveAllInputs?(l(Array.isArray(t),(()=>"saveAllInputs is true, expected inputs to be an array.")),a=Object.keys(t).map((e=>t[e]))):a=e.map((e=>t[e]));const i=n.filter(((e,t)=>r[t]));return a.concat(i)}return[]}makeTensor(e,t,n,s){if(null==e)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",s=s||this.backend;let r=e;"string"===n&&E(e[0])&&(r=e.map((e=>us(e))));const a=s.write(r,t,n),i=new Is(t,n,a,this.nextTensorId());if(this.trackTensor(i,s),"string"===n){const e=this.state.tensorInfo.get(a),t=T(r);this.state.numBytes+=t-e.bytes,e.bytes=t}return i}makeTensorFromDataId(e,t,n,s){const r=new Is(t,n=n||"float32",e,this.nextTensorId());return this.trackTensor(r,s),r}makeVariable(e,t=!0,n,s){n=n||this.nextVariableId().toString(),null!=s&&s!==e.dtype&&(e=e.cast(s));const r=new Cs(e,t,n,this.nextTensorId());if(null!=this.state.registeredVariables[r.name])throw new Error(`Variable with name ${r.name} was already registered`);return this.state.registeredVariables[r.name]=r,this.incRef(r,this.backend),r}trackTensor(e,t){this.state.numTensors++,"string"===e.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==e.dtype&&"string"!==e.dtype&&(n=e.size*S(e.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(e.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(e.dataId,{backend:t||this.backend,dtype:e.dtype,shape:e.shape,bytes:n})),e instanceof Cs||this.track(e)}incRef(e,t){this.trackTensor(e,t),this.backend.incRef(e.dataId)}removeDataId(e,t){this.state.tensorInfo.has(e)&&this.state.tensorInfo.get(e).backend===t&&(this.state.tensorInfo.delete(e),this.state.numDataBuffers--)}disposeTensor(e){if(!this.state.tensorInfo.has(e.dataId))return;const t=this.state.tensorInfo.get(e.dataId);if(this.state.numTensors--,"string"===e.dtype&&(this.state.numStringTensors--,this.state.numBytes-=t.bytes),"complex64"!==e.dtype&&"string"!==e.dtype){const t=e.size*S(e.dtype);this.state.numBytes-=t}t.backend.disposeData(e.dataId)&&this.removeDataId(e.dataId,t.backend)}disposeVariables(){for(const e in this.state.registeredVariables){const t=this.state.registeredVariables[e];this.disposeVariable(t)}}disposeVariable(e){this.disposeTensor(e),null!=this.state.registeredVariables[e.name]&&delete this.state.registeredVariables[e.name]}memory(){const e=this.backend.memory();return e.numTensors=this.state.numTensors,e.numDataBuffers=this.state.numDataBuffers,e.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(e.unreliable=!0,null==e.reasons&&(e.reasons=[]),e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),e}async profile(e){this.state.profiling=!0;const t=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await e(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((e=>e.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-t,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const e of this.state.activeProfile.kernels)e.kernelTimeMs=await e.kernelTimeMs,e.extraInfo=await e.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(e,t,n,s,r,a){const i={id:this.state.nextTapeNodeId++,kernelName:e,inputs:t,outputs:n,saved:r},o=es(e);null!=o&&(s=o.gradFunc),null!=s&&(i.gradient=e=>(e=e.map(((e,t)=>{if(null==e){const e=n[t],s=B(e.size,e.dtype);return this.makeTensor(s,e.shape,e.dtype)}return e})),s(e.length>1?e:e[0],r,a))),this.state.activeTape.push(i)}keep(e){return e.kept=!0,e}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(e){const t={track:[],name:"unnamed scope",id:this.state.nextScopeId++};e&&(t.name=e),this.state.scopeStack.push(t),this.state.activeScope=t}endScope(e){const t=zs(e),n=new Set(t.map((e=>e.id)));for(let e=0;e<this.state.activeScope.track.length;e++){const t=this.state.activeScope.track[e];t.kept||n.has(t.id)||t.dispose()}const s=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],t.forEach((e=>{e.kept||e.scopeId!==s.id||this.track(e)}))}gradients(e,t,n,s=!1){if(l(t.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const r=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",e)));l(r instanceof Is,(()=>"The result y returned by f() must be a tensor."));const a=function(e,t,n){const s={},r={};for(let e=0;e<t.length;e++)s[t[e].id]=!0;for(let n=0;n<e.length;n++){const a=e[n],i=a.inputs;for(const e in i){const n=i[e];let o=!1;for(let e=0;e<t.length;e++)if(s[n.id]){a.outputs.forEach((e=>s[e.id]=!0)),o=!0,r[a.id]=!0;break}if(o)break}}const a={};a[n.id]=!0;const i={};for(let t=e.length-1;t>=0;t--){const n=e[t],s=n.inputs;for(let e=0;e<n.outputs.length;e++)if(a[n.outputs[e].id]){for(const e in s)a[s[e].id]=!0,i[n.id]=!0;break}}const o=[];for(let t=0;t<e.length;t++){const n=e[t];if(r[n.id]&&i[n.id]){const e={};for(const t in n.inputs){const r=n.inputs[t];s[r.id]&&(e[t]=r)}const t=Object.assign({},n);t.inputs=e,t.outputs=n.outputs,o.push(t)}}return o}(this.state.activeTape,t,r);if(!s&&0===a.length&&t.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const e={};e[r.id]=null==n?function(e){const t=z(p(e),"float32");return Hs.makeTensor(t,e,"float32")}(r.shape):n,function(e,t,n,s){for(let r=t.length-1;r>=0;r--){const a=t[r],i=[];if(a.outputs.forEach((t=>{const n=e[t.id];null!=n?i.push(n):i.push(null)})),null==a.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${a.kernelName}.`);const o=a.gradient(i);for(const t in a.inputs){if(!(t in o))throw new Error(`Cannot backprop through input ${t}. Available gradients found: ${Object.keys(o)}.`);const r=n((()=>o[t]()));if("float32"!==r.dtype)throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input ${t} must have 'float32' dtype, but has '${r.dtype}'`);const i=a.inputs[t];if(!d(r.shape,i.shape))throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input '${t}' has shape '${r.shape}', which does not match the shape of the input '${i.shape}'`);if(null==e[i.id])e[i.id]=r;else{const t=e[i.id];e[i.id]=s(t,r),t.dispose()}}}}(e,a,(e=>this.tidy(e)),js);const s=t.map((t=>e[t.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((e=>{for(const t of e.saved)t.dispose()})),this.state.activeTape=null),{value:r,grads:s}}))}customGrad(e){return l(D(e),(()=>"The f passed in customGrad(f) must be a function.")),(...t)=>{let n;l(t.every((e=>e instanceof Is)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const s={};t.forEach(((e,t)=>{s[t]=e}));return this.runKernelFunc({forwardFunc:(s,r)=>(n=e(...t,r),l(n.value instanceof Is,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),l(D(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(e,s)=>{const r=n.gradFunc(e,s),a=Array.isArray(r)?r:[r];l(a.length===t.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),l(a.every((e=>e instanceof Is)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const i={};return a.forEach(((e,t)=>{i[t]=()=>e})),i},inputs:s})}}readSync(e){return this.state.tensorInfo.get(e).backend.readSync(e)}read(e){return this.state.tensorInfo.get(e).backend.read(e)}async time(e){const t=os(),n=await this.backend.time(e);return n.wallMs=os()-t,n}track(e){return null!=this.state.activeScope&&(e.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(e)),e}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new Vs;for(const e in this.registry)this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}function Gs(){const t=Y();if(null==t._tfengine){const e=new j(t);t._tfengine=new Us(e)}var n;return n=t._tfengine.ENV,e.ENV=n,ks=()=>t._tfengine,t._tfengine}Us.nextTensorId=0,Us.nextVariableId=0;const Hs=Gs();function js(e,t){const n={a:e,b:t};return Hs.runKernel(te,n)}function qs(e){if(e||"undefined"!=typeof navigator&&null!=navigator){if(e||(e=navigator),"ReactNative"===e.product)return!0;const t=e.userAgent||e.vendor||window.opera;return/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(t)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(t.substr(0,4))}return!1}function Ks(){return"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope}var Xs=Object.freeze({__proto__:null,isMobile:qs,isBrowser:Ks});const Ys=K();function Js(e,t){let n=e;if(C(e))return"string"===t?[]:[e.length];if(!Array.isArray(e))return[];const s=[];for(;Array.isArray(n)||C(n)&&"string"!==t;)s.push(n.length),n=n[0];return Array.isArray(e)&&K().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&Zs(e,s,[]),s}function Zs(e,t,n){if(n=n||[],!Array.isArray(e)&&!C(e))return void l(0===t.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${t[0]} elements`));l(t.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${e.length} elements`)),l(e.length===t[0],(()=>`Element arr[${n.join("][")}] should have ${t[0]} elements, but has ${e.length} elements`));const s=t.slice(1);for(let t=0;t<e.length;++t)Zs(e[t],s,n.concat(t))}function Qs(e,t,n,s){if("string_or_numeric"!==e){if(null==e)throw new Error("Expected dtype cannot be null.");if("numeric"!==e&&e!==t||"numeric"===e&&"string"===t)throw new Error(`Argument '${n}' passed to '${s}' must be ${e} tensor, but got ${t} tensor`)}}function er(e,t,n,s="numeric"){if(e instanceof Is)return Qs(s,e.dtype,t,n),e;let r=F(e);if("string"!==r&&["bool","int32","float32"].indexOf(s)>=0&&(r=s),Qs(s,r,t,n),null==e||!C(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e){const s=null==e?"null":e.constructor.name;throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${s}'`)}const a=Js(e,r);C(e)||Array.isArray(e)||(e=[e]);const i="string"!==r?is(e,r):h(e,[],!0);return Hs.makeTensor(i,a,r)}function tr(e,t,n,s="numeric"){if(!Array.isArray(e))throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return e.map(((e,r)=>er(e,`${t}[${r}]`,n,s)))}Ys.registerFlag("DEBUG",(()=>!1),(e=>{e&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")})),Ys.registerFlag("IS_BROWSER",(()=>Ks())),Ys.registerFlag("IS_NODE",(()=>"undefined"!=typeof process&&void 0!==process.versions&&void 0!==process.versions.node)),Ys.registerFlag("IS_CHROME",(()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor))),Ys.registerFlag("PROD",(()=>!1)),Ys.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",(()=>Ys.getBool("DEBUG"))),Ys.registerFlag("DEPRECATION_WARNINGS_ENABLED",(()=>!0)),Ys.registerFlag("IS_TEST",(()=>!1)),Ys.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",(()=>!0)),Ys.registerFlag("WRAP_TO_IMAGEBITMAP",(()=>!1));const nr="__op";function sr(e){const t=Object.keys(e);if(1!==t.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${t.length} keys.`);let n=t[0];const s=e[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+=nr;const r=(...e)=>{Hs.startScope(n);try{const t=s(...e);return G(t)&&console.error("Cannot return a Promise inside of tidy."),Hs.endScope(t),t}catch(e){throw Hs.endScope(null),e}};return Object.defineProperty(r,"name",{value:n,configurable:!0}),r}const rr=sr({complex_:function(e,t){const n=er(e,"real","complex"),s=er(t,"imag","complex");u(n.shape,s.shape,`real and imag shapes, ${n.shape} and ${s.shape}, must match in call to tf.complex().`);const r={real:n,imag:s};return Hs.runKernel(Ne,r)}});function ar(e,t,n,s){if(null==s&&(s=F(e)),"complex64"===s)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!C(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=t){W(t);const e=p(t),s=p(n);l(e===s,(()=>`Based on the provided shape, [${t}], the tensor should have ${e} values but has ${s}`));for(let e=0;e<n.length;++e){const s=n[e],r=e!==n.length-1||s!==p(t.slice(e));l(n[e]===t[e]||!r,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `))}}return C(e)||Array.isArray(e)||(e=[e]),t=t||n,e="string"!==s?is(e,s):h(e,[],!0),Hs.makeTensor(e,t,s)}function ir(e,t,n){return ar(e,t,Js(e,n),n)}const or={float32:4,float16:2,int32:4,uint16:2,uint8:1,bool:1,complex64:8};async function lr(e,t){const n=[],s=[],r=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);for(let a=0;a<r.length;++a){const i=r[a],o=Array.isArray(e)?e[a].tensor:e[i];if("float32"!==o.dtype&&"int32"!==o.dtype&&"bool"!==o.dtype&&"string"!==o.dtype&&"complex64"!==o.dtype)throw new Error(`Unsupported dtype in weight '${i}': ${o.dtype}`);const l={name:i,shape:o.shape,dtype:o.dtype};if("string"===o.dtype){const e=new Promise((async e=>{const t=await o.bytes(),n=t.reduce(((e,t)=>e+t.length),0)+4*t.length,s=new Uint8Array(n);let r=0;for(let e=0;e<t.length;e++){const n=t[e],a=new Uint8Array(new Uint32Array([n.length]).buffer);s.set(a,r),r+=4,s.set(n,r),r+=n.length}e(s)}));s.push(e)}else s.push(o.data());null!=t&&(l.group=t),n.push(l)}return{data:cr(await Promise.all(s)),specs:n}}function ur(e,t){const n={};let s,r=0;for(const a of t){const t=a.name,i=a.dtype,o=a.shape,l=p(o);let u;if("quantization"in a){const n=a.quantization;if("uint8"===n.dtype||"uint16"===n.dtype){if(!("min"in n)||!("scale"in n))throw new Error(`Weight ${a.name} with quantization ${n.dtype} doesn't have corresponding metadata min and scale.`)}else{if("float16"!==n.dtype)throw new Error(`Weight ${a.name} has unknown quantization dtype ${n.dtype}. Supported quantization dtypes are: 'uint8', 'uint16', and 'float16'.`);if("float32"!==i)throw new Error(`Weight ${a.name} is quantized with ${n.dtype} which only supports weights of type float32 not ${i}.`)}const o=or[n.dtype],c=e.slice(r,r+l*o),h="uint8"===n.dtype?new Uint8Array(c):new Uint16Array(c);if("float32"===i)if("uint8"===n.dtype||"uint16"===n.dtype){u=new Float32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=t*n.scale+n.min}}else{if("float16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type float32.`);void 0===s&&(s=gr()),u=s(h)}else{if("int32"!==i)throw new Error(`Unsupported dtype in weight '${t}': ${i}`);if("uint8"!==n.dtype&&"uint16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type int32.`);u=new Int32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=Math.round(t*n.scale+n.min)}}r+=l*o}else if("string"===i){const t=p(a.shape);u=[];for(let n=0;n<t;n++){const t=new Uint32Array(e.slice(r,r+4))[0];r+=4;const n=new Uint8Array(e.slice(r,r+t));u.push(n),r+=t}}else{const s=or[i],a=e.slice(r,r+l*s);if("float32"===i)u=new Float32Array(a);else if("int32"===i)u=new Int32Array(a);else if("bool"===i)u=new Uint8Array(a);else{if("complex64"!==i)throw new Error(`Unsupported dtype in weight '${t}': ${i}`);{u=new Float32Array(a);const e=new Float32Array(u.length/2),s=new Float32Array(u.length/2);for(let t=0;t<e.length;t++)e[t]=u[2*t],s[t]=u[2*t+1];const r=ir(e,o,"float32"),i=ir(s,o,"float32");n[t]=rr(r,i),r.dispose(),i.dispose()}}r+=l*s}"complex64"!==i&&(n[t]=ir(u,o,i))}return n}function cr(e){if(null===e)throw new Error(`Invalid input value: ${JSON.stringify(e)}`);let t=0;const n=[];e.forEach((e=>{if(t+=e.byteLength,n.push(e.byteLength===e.buffer.byteLength?e:new e.constructor(e)),!(e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array))throw new Error(`Unsupported TypedArray subtype: ${e.constructor.name}`)}));const s=new Uint8Array(t);let r=0;return n.forEach((e=>{s.set(new Uint8Array(e.buffer),r),r+=e.byteLength})),s.buffer}const hr="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function pr(e){return hr?Buffer.byteLength(e):new Blob([e]).size}function dr(e){if(1===e.length)return e[0];let t=0;e.forEach((e=>{t+=e.byteLength}));const n=new Uint8Array(t);let s=0;return e.forEach((e=>{n.set(new Uint8Array(e),s),s+=e.byteLength})),n.buffer}function fr(e){for(e=e.trim();e.endsWith("/");)e=e.slice(0,e.length-1);const t=e.split("/");return t[t.length-1]}function mr(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==e.modelTopology?0:pr(JSON.stringify(e.modelTopology)),weightSpecsBytes:null==e.weightSpecs?0:pr(JSON.stringify(e.weightSpecs)),weightDataBytes:null==e.weightData?0:e.weightData.byteLength}}function gr(){const e=function(){const e=e=>{let t=e<<13,n=0;for(;0==(8388608&t);)n-=8388608,t<<=1;return t&=-8388609,n+=947912704,t|n},t=new Uint32Array(2048);t[0]=0;for(let n=1;n<1024;n++)t[n]=e(n);for(let e=1024;e<2048;e++)t[e]=939524096+(e-1024<<13);return t}(),t=function(){const e=new Uint32Array(64);e[0]=0,e[31]=1199570944,e[32]=2147483648,e[63]=3347054592;for(let t=1;t<31;t++)e[t]=t<<23;for(let t=33;t<63;t++)e[t]=2147483648+(t-32<<23);return e}(),n=function(){const e=new Uint32Array(64);for(let t=0;t<64;t++)e[t]=1024;return e[0]=e[32]=0,e}();return s=>{const r=new ArrayBuffer(4*s.length),a=new Uint32Array(r);for(let r=0;r<s.length;r++){const i=s[r],o=e[n[i>>10]+(1023&i)]+t[i>>10];a[r]=o}return new Float32Array(r)}}class yr{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==yr.instance&&(yr.instance=new yr),yr.instance}static registerSaveRouter(e){yr.getInstance().saveRouters.push(e)}static registerLoadRouter(e){yr.getInstance().loadRouters.push(e)}static getSaveHandlers(e){return yr.getHandlers(e,"save")}static getLoadHandlers(e,t){return yr.getHandlers(e,"load",t)}static getHandlers(e,t,n){const s=[];return("load"===t?yr.getInstance().loadRouters:yr.getInstance().saveRouters).forEach((t=>{const r=t(e,n);null!==r&&s.push(r)})),s}}const br=e=>yr.getSaveHandlers(e),xr=(e,t)=>yr.getLoadHandlers(e,t),wr="tensorflowjs",kr="models_store",vr="model_info_store";function Nr(){if(!K().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const e="undefined"==typeof window?self:window,t=e.indexedDB||e.mozIndexedDB||e.webkitIndexedDB||e.msIndexedDB||e.shimIndexedDB;if(null==t)throw new Error("The current browser does not appear to support IndexedDB.");return t}function Ir(e){const t=e.result;t.createObjectStore(kr,{keyPath:"modelPath"}),t.createObjectStore(vr,{keyPath:"modelPath"})}class $r{constructor(e){if(this.indexedDB=Nr(),null==e||!e)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=e}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,e)}async load(){return this.databaseAction(this.modelPath)}databaseAction(e,t){return new Promise(((e,n)=>{const s=this.indexedDB.open(wr,1);s.onupgradeneeded=()=>Ir(s),s.onsuccess=()=>{const r=s.result;if(null==t){const t=r.transaction(kr,"readonly"),s=t.objectStore(kr).get(this.modelPath);s.onsuccess=()=>{if(null==s.result)return r.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));e(s.result.modelArtifacts)},s.onerror=e=>(r.close(),n(s.error)),t.oncomplete=()=>r.close()}else{const s=mr(t),a=r.transaction(vr,"readwrite");let i=a.objectStore(vr);const o=i.put({modelPath:this.modelPath,modelArtifactsInfo:s});let l;o.onsuccess=()=>{l=r.transaction(kr,"readwrite");const o=l.objectStore(kr).put({modelPath:this.modelPath,modelArtifacts:t,modelArtifactsInfo:s});o.onsuccess=()=>e({modelArtifactsInfo:s}),o.onerror=e=>{i=a.objectStore(vr);const t=i.delete(this.modelPath);t.onsuccess=()=>(r.close(),n(o.error)),t.onerror=e=>(r.close(),n(o.error))}},o.onerror=e=>(r.close(),n(o.error)),a.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}}},s.onerror=e=>n(s.error)}))}}$r.URL_SCHEME="indexeddb://";const Cr=e=>{return K().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith($r.URL_SCHEME)?(t=e.slice($r.URL_SCHEME.length),new $r(t)):null;var t};yr.registerSaveRouter(Cr),yr.registerLoadRouter(Cr);class Sr{constructor(){this.indexedDB=Nr()}async listModels(){return new Promise(((e,t)=>{const n=this.indexedDB.open(wr,1);n.onupgradeneeded=()=>Ir(n),n.onsuccess=()=>{const s=n.result,r=s.transaction(vr,"readonly"),a=r.objectStore(vr).getAll();a.onsuccess=()=>{const t={};for(const e of a.result)t[e.modelPath]=e.modelArtifactsInfo;e(t)},a.onerror=e=>(s.close(),t(a.error)),r.oncomplete=()=>s.close()},n.onerror=e=>t(n.error)}))}async removeModel(e){var t;return e=(t=e).startsWith($r.URL_SCHEME)?t.slice($r.URL_SCHEME.length):t,new Promise(((t,n)=>{const s=this.indexedDB.open(wr,1);s.onupgradeneeded=()=>Ir(s),s.onsuccess=()=>{const r=s.result,a=r.transaction(vr,"readwrite"),i=a.objectStore(vr),o=i.get(e);let l;o.onsuccess=()=>{if(null==o.result)return r.close(),n(new Error(`Cannot find model with path '${e}' in IndexedDB.`));{const s=i.delete(e),a=()=>{l=r.transaction(kr,"readwrite");const s=l.objectStore(kr).delete(e);s.onsuccess=()=>t(o.result.modelArtifactsInfo),s.onerror=e=>n(o.error)};s.onsuccess=a,s.onerror=e=>(a(),r.close(),n(o.error))}},o.onerror=e=>(r.close(),n(o.error)),a.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}},s.onerror=e=>n(s.error)}))}}const Tr="/",Er="tensorflowjs_models",Ar="info",Rr="model_topology",Fr="weight_specs",Dr="weight_data",_r="model_metadata";function Or(e){return{info:[Er,e,Ar].join(Tr),topology:[Er,e,Rr].join(Tr),weightSpecs:[Er,e,Fr].join(Tr),weightData:[Er,e,Dr].join(Tr),modelMetadata:[Er,e,_r].join(Tr)}}function Mr(e){const t=e.split(Tr);if(t.length<3)throw new Error(`Invalid key format: ${e}`);return t.slice(1,t.length-1).join(Tr)}class Lr{constructor(e){if(!K().getBool("IS_BROWSER")||"undefined"==typeof window||void 0===window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==e||!e)throw new Error("For local storage, modelPath must not be null, undefined or empty.");this.modelPath=e,this.keys=Or(this.modelPath)}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const t=JSON.stringify(e.modelTopology),n=JSON.stringify(e.weightSpecs),s=mr(e);try{this.LS.setItem(this.keys.info,JSON.stringify(s)),this.LS.setItem(this.keys.topology,t),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(e){if(hr)return Buffer.from(e).toString("base64");const t=new Uint8Array(e);let n="";for(let e=0,s=t.length;e<s;e++)n+=String.fromCharCode(t[e]);return btoa(n)}(e.weightData));const r={format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy};return null!=e.signature&&(r.signature=e.signature),null!=e.userDefinedMetadata&&(r.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(r.modelInitializer=e.modelInitializer),this.LS.setItem(this.keys.modelMetadata,JSON.stringify(r)),{modelArtifactsInfo:s}}catch(e){throw this.LS.removeItem(this.keys.info),this.LS.removeItem(this.keys.topology),this.LS.removeItem(this.keys.weightSpecs),this.LS.removeItem(this.keys.weightData),this.LS.removeItem(this.keys.modelMetadata),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${s.modelTopologyBytes}, weightSpecsBytes=${s.weightSpecsBytes}, weightDataBytes=${s.weightDataBytes}.`)}}}async load(){const e=JSON.parse(this.LS.getItem(this.keys.info));if(null==e)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==e.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const t={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);t.modelTopology=n;const s=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==s)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);t.weightSpecs=s;const r=this.LS.getItem(this.keys.modelMetadata);if(null!=r){const e=JSON.parse(r);t.format=e.format,t.generatedBy=e.generatedBy,t.convertedBy=e.convertedBy,null!=e.signature&&(t.signature=e.signature),null!=e.userDefinedMetadata&&(t.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(t.modelInitializer=e.modelInitializer)}const a=this.LS.getItem(this.keys.weightData);if(null==a)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return t.weightData=function(e){if(hr){const t=Buffer.from(e,"base64");return t.buffer.slice(t.byteOffset,t.byteOffset+t.byteLength)}const t=atob(e),n=new Uint8Array(t.length);for(let e=0;e<t.length;++e)n.set([t.charCodeAt(e)],e);return n.buffer}(a),t}}Lr.URL_SCHEME="localstorage://";const zr=e=>{return K().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Lr.URL_SCHEME)?(t=e.slice(Lr.URL_SCHEME.length),new Lr(t)):null;var t};yr.registerSaveRouter(zr),yr.registerLoadRouter(zr);class Br{constructor(){l(K().getBool("IS_BROWSER"),(()=>"Current environment is not a web browser")),l("undefined"==typeof window||void 0!==window.localStorage,(()=>"Current browser does not appear to support localStorage")),this.LS=window.localStorage}async listModels(){const e={},t=Er+Tr,n=Tr+Ar;for(let s=0;s<this.LS.length;++s){const r=this.LS.key(s);if(r.startsWith(t)&&r.endsWith(n)){e[Mr(r)]=JSON.parse(this.LS.getItem(r))}}return e}async removeModel(e){var t;const n=Or(e=(t=e).startsWith(Lr.URL_SCHEME)?t.slice(Lr.URL_SCHEME.length):t);if(null==this.LS.getItem(n.info))throw new Error(`Cannot find model at path '${e}'`);const s=JSON.parse(this.LS.getItem(n.info));return this.LS.removeItem(n.info),this.LS.removeItem(n.topology),this.LS.removeItem(n.weightSpecs),this.LS.removeItem(n.weightData),s}}const Pr="://";class Wr{constructor(){this.managers={}}static getInstance(){return null==Wr.instance&&(Wr.instance=new Wr),Wr.instance}static registerManager(e,t){l(null!=e,(()=>"scheme must not be undefined or null.")),e.endsWith(Pr)&&(e=e.slice(0,e.indexOf(Pr))),l(e.length>0,(()=>"scheme must not be an empty string."));const n=Wr.getInstance();l(null==n.managers[e],(()=>`A model store manager is already registered for scheme '${e}'.`)),n.managers[e]=t}static getManager(e){const t=this.getInstance().managers[e];if(null==t)throw new Error(`Cannot find model manager for scheme '${e}'`);return t}static getSchemes(){return Object.keys(this.getInstance().managers)}}function Vr(e){if(-1===e.indexOf(Pr))throw new Error(`The url string provided does not contain a scheme. Supported schemes are: ${Wr.getSchemes().join(",")}`);return{scheme:e.split(Pr)[0],path:e.split(Pr)[1]}}async function Ur(e,t,n=!1){l(e!==t,(()=>`Old path and new path are the same: '${e}'`));const s=yr.getLoadHandlers(e);l(s.length>0,(()=>`Copying failed because no load handler is found for source URL ${e}.`)),l(s.length<2,(()=>`Copying failed because more than one (${s.length}) load handlers for source URL ${e}.`));const r=s[0],a=yr.getSaveHandlers(t);l(a.length>0,(()=>`Copying failed because no save handler is found for destination URL ${t}.`)),l(a.length<2,(()=>`Copying failed because more than one (${s.length}) save handlers for destination URL ${t}.`));const i=a[0],o=Vr(e).scheme,u=Vr(e).path,c=o===Vr(e).scheme,h=await r.load();n&&c&&await Wr.getManager(o).removeModel(u);const p=await i.save(h);return n&&!c&&await Wr.getManager(o).removeModel(u),p.modelArtifactsInfo}class Gr{fetch(e,t){return fetch(e,t)}now(){return performance.now()}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Browser's encoder only supports utf-8, but got ${t}`);return null==this.textEncoder&&(this.textEncoder=new TextEncoder),this.textEncoder.encode(e)}decode(e,t){return new TextDecoder(t).decode(e)}}if(K().get("IS_BROWSER")){K().setPlatform("browser",new Gr);try{Wr.registerManager(Lr.URL_SCHEME,new Br)}catch(e){}try{Wr.registerManager($r.URL_SCHEME,new Sr)}catch(e){}}const Hr=()=>require("node-fetch");let jr;class qr{constructor(){this.util=require("util"),this.textEncoder=new this.util.TextEncoder}fetch(e,t){return null!=K().global.fetch?K().global.fetch(e,t):(null==jr&&(jr=Hr()),jr(e,t))}now(){const e=process.hrtime();return 1e3*e[0]+e[1]/1e6}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Node built-in encoder only supports utf-8, but got ${t}`);return this.textEncoder.encode(e)}decode(e,t){return 0===e.length?"":new this.util.TextDecoder(t).decode(e)}}function Kr(e,t="float32",n){return t=t||"float32",W(e),new ws(e,t,n)}K().get("IS_NODE")&&K().setPlatform("node",new qr);const Xr=sr({cast_:function(e,t){const n=er(e,"x","cast");if(!I(t))throw new Error(`Failed to cast to unknown dtype ${t}`);if("string"===t&&"string"!==n.dtype||"string"!==t&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const s={x:n},r={dtype:t};return Hs.runKernel(we,s,r)}});const Yr=sr({clone_:function(e){const t={x:er(e,"x","clone","string_or_numeric")};return Hs.runKernel(ct,t)}});function Jr(e,t=!1){console.log(e.toString(t))}Gs();vs={buffer:Kr,cast:Xr,clone:Yr,print:Jr};function Zr(e){return new Promise((e=>setTimeout(e))).then(e)}class Qr{constructor(e){if(!K().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");e.startsWith(Qr.URL_SCHEME)&&(e=e.slice(Qr.URL_SCHEME.length)),null!=e&&0!==e.length||(e="model"),this.modelTopologyFileName=e+".json",this.weightDataFileName=e+".weights.bin"}async save(e){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const t=window.URL.createObjectURL(new Blob([e.weightData],{type:"application/octet-stream"}));if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=[{paths:["./"+this.weightDataFileName],weights:e.weightSpecs}],s={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:n};null!=e.signature&&(s.signature=e.signature),null!=e.userDefinedMetadata&&(s.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(s.modelInitializer=e.modelInitializer);const r=window.URL.createObjectURL(new Blob([JSON.stringify(s)],{type:"application/json"})),a=null==this.jsonAnchor?document.createElement("a"):this.jsonAnchor;if(a.download=this.modelTopologyFileName,a.href=r,await Zr((()=>a.dispatchEvent(new MouseEvent("click")))),null!=e.weightData){const e=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;e.download=this.weightDataFileName,e.href=t,await Zr((()=>e.dispatchEvent(new MouseEvent("click"))))}return{modelArtifactsInfo:mr(e)}}}}Qr.URL_SCHEME="downloads://";class ea{constructor(e){if(null==e||e.length<1)throw new Error(`When calling browserFiles, at least 1 file is required, but received ${e}`);this.files=e}async load(){const e=this.files[0],t=this.files.slice(1);return new Promise(((n,s)=>{const r=new FileReader;r.onload=r=>{const a=JSON.parse(r.target.result),i=a.modelTopology;if(null==i)return void s(new Error(`modelTopology field is missing from file ${e.name}`));0===t.length&&n({modelTopology:i});const o=a.weightsManifest;if(null==o)return void s(new Error(`weightManifest field is missing from file ${e.name}`));let l;try{l=this.checkManifestAndWeightFiles(o,t)}catch(e){return void s(e)}const u=[],c=[],h=[];o.forEach((e=>{e.paths.forEach((e=>{c.push(e),h.push(null)})),u.push(...e.weights)})),o.forEach((e=>{e.paths.forEach((e=>{const t=new FileReader;t.onload=t=>{const s=t.target.result,r=c.indexOf(e);if(h[r]=s,-1===h.indexOf(null)){const e={modelTopology:i,weightSpecs:u,weightData:dr(h),format:a.format,generatedBy:a.generatedBy,convertedBy:a.convertedBy};null!=a.signature&&(e.signature=a.signature),null!=a.userDefinedMetadata&&(e.userDefinedMetadata=a.userDefinedMetadata),null!=a.modelInitializer&&(e.modelInitializer=a.modelInitializer),n(e)}},t.onerror=t=>s(`Failed to weights data from file of path '${e}'.`),t.readAsArrayBuffer(l[e])}))}))},r.onerror=t=>s(`Failed to read model topology and weights manifest JSON from file '${e.name}'. BrowserFiles supports loading Keras-style tf.Model artifacts only.`),r.readAsText(e)}))}checkManifestAndWeightFiles(e,t){const n=[],s=t.map((e=>fr(e.name))),r={};for(const a of e)a.paths.forEach((e=>{const a=fr(e);if(-1!==n.indexOf(a))throw new Error(`Duplicate file basename found in weights manifest: '${a}'`);if(n.push(a),-1===s.indexOf(a))throw new Error(`Weight file with basename '${a}' is not provided.`);r[e]=t[s.indexOf(a)]}));if(n.length!==t.length)throw new Error(`Mismatch in the number of files in weights manifest (${n.length}) and the number of weight files provided (${t.length}).`);return r}}function ta(e,t,n,s){!function(e){l(null!=e&&Array.isArray(e)&&e.length>0,(()=>"promises must be a none empty array"))}(e),function(e,t){l(e>=0&&e<=1,(()=>`Progress fraction must be in range [0, 1], but got startFraction ${e}`)),l(t>=0&&t<=1,(()=>`Progress fraction must be in range [0, 1], but got endFraction ${t}`)),l(t>=e,(()=>`startFraction must be no more than endFraction, but got startFraction ${e} and endFraction ${t}`))}(n=null==n?0:n,s=null==s?1:s);let r=0;return Promise.all(e.map((a=>(a.then((a=>{const i=n+ ++r/e.length*(s-n);return t(i),a})),a))))}async function na(e,t){null==t&&(t={});const n=null==t.fetchFunc?K().platform.fetch:t.fetchFunc,s=e.map((e=>n(e,t.requestInit,{isBinary:!0}))),r=(null==t.onProgress?await Promise.all(s):await ta(s,t.onProgress,0,.5)).map((e=>e.arrayBuffer()));return null==t.onProgress?await Promise.all(r):await ta(r,t.onProgress,.5,1)}async function sa(e,t="",n,s){return ra((e=>na(e,{requestInit:s})))(e,t,n)}function ra(e){return async(t,n="",s)=>{const r=t.map((()=>!1)),a={},i=null!=s?s.map((()=>!1)):[],o=[];if(t.forEach(((e,t)=>{let n=0;e.weights.forEach((e=>{const l="quantization"in e?e.quantization.dtype:e.dtype,u=or[l]*p(e.shape),c=()=>{r[t]=!0,null==a[t]&&(a[t]=[]),a[t].push({manifestEntry:e,groupOffset:n,sizeBytes:u})};null!=s?s.forEach(((t,n)=>{t===e.name&&(c(),i[n]=!0)})):c(),o.push(e.name),n+=u}))})),!i.every((e=>e))){const e=s.filter(((e,t)=>!i[t]));throw new Error(`Could not find weights in manifest with names: ${e.join(", ")}. \nManifest JSON has weights with names: ${o.join(", ")}.`)}const l=r.reduce(((e,t,n)=>(t&&e.push(n),e)),[]),u=[];l.forEach((e=>{t[e].paths.forEach((e=>{const t=n+(n.endsWith("/")?"":"/")+e;u.push(t)}))}));const c=await e(u),h={};let d=0;return l.forEach((e=>{const n=t[e].paths.length;let s=0;for(let e=0;e<n;e++)s+=c[d+e].byteLength;const r=new ArrayBuffer(s),i=new Uint8Array(r);let o=0;for(let e=0;e<n;e++){const t=new Uint8Array(c[d+e]);i.set(t,o),o+=t.byteLength}a[e].forEach((e=>{const t=ur(r.slice(e.groupOffset,e.groupOffset+e.sizeBytes),[e.manifestEntry]);for(const e in t)h[e]=t[e]})),d+=n})),h}}yr.registerSaveRouter((e=>K().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Qr.URL_SCHEME)?function(e="model"){return new Qr(e)}(e.slice(Qr.URL_SCHEME.length)):null));class aa{constructor(e,t){if(this.DEFAULT_METHOD="POST",null==t&&(t={}),this.weightPathPrefix=t.weightPathPrefix,this.onProgress=t.onProgress,this.weightUrlConverter=t.weightUrlConverter,null!=t.fetchFunc?(l("function"==typeof t.fetchFunc,(()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)")),this.fetch=t.fetchFunc):this.fetch=K().platform.fetch,l(null!=e&&e.length>0,(()=>"URL path for http must not be null, undefined or empty.")),Array.isArray(e)&&l(2===e.length,(()=>`URL paths for http must have a length of 2, (actual length is ${e.length}).`)),this.path=e,null!=t.requestInit&&null!=t.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=t.requestInit||{}}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const t=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);t.body=new FormData;const n=[{paths:["./model.weights.bin"],weights:e.weightSpecs}],s={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:n};null!=e.signature&&(s.signature=e.signature),null!=e.userDefinedMetadata&&(s.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(s.modelInitializer=e.modelInitializer),t.body.append("model.json",new Blob([JSON.stringify(s)],{type:"application/json"}),"model.json"),null!=e.weightData&&t.body.append("model.weights.bin",new Blob([e.weightData],{type:"application/octet-stream"}),"model.weights.bin");const r=await this.fetch(this.path,t);if(r.ok)return{modelArtifactsInfo:mr(e),responses:[r]};throw new Error(`BrowserHTTPRequest.save() failed due to HTTP response status ${r.status}.`)}async load(){const e=await this.fetch(this.path,this.requestInit);if(!e.ok)throw new Error(`Request to ${this.path} failed with status code ${e.status}. Please verify this URL points to the model JSON of the model to load.`);let t;try{t=await e.json()}catch(e){let t=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?t+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":t+=" Please make sure the server is serving valid JSON for this request.",new Error(t)}const n=t.modelTopology,s=t.weightsManifest,r=t.generatedBy,a=t.convertedBy,i=t.format,o=t.signature,l=t.userDefinedMetadata;if(null==n&&null==s)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);let u,c;if(null!=s){const e=await this.loadWeights(s);[u,c]=e}const h={modelTopology:n,weightSpecs:u,weightData:c,generatedBy:r,convertedBy:a,format:i};null!=o&&(h.signature=o),null!=l&&(h.userDefinedMetadata=l);const p=t.modelInitializer;return p&&(h.modelInitializer=p),h}async loadWeights(e){const t=Array.isArray(this.path)?this.path[1]:this.path,[n,s]=function(e){const t=e.lastIndexOf("/"),n=e.lastIndexOf("?"),s=e.substring(0,t),r=n>t?e.substring(n):"";return[s+"/",r]}(t),r=this.weightPathPrefix||n,a=[];for(const t of e)a.push(...t.weights);const i=[],o=[];for(const t of e)for(const e of t.paths)null!=this.weightUrlConverter?o.push(this.weightUrlConverter(e)):i.push(r+e+s);this.weightUrlConverter&&i.push(...await Promise.all(o));return[a,dr(await na(i,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress}))]}}function ia(e){return null!=e.match(aa.URL_SCHEME_REGEX)}aa.URL_SCHEME_REGEX=/^https?:\/\//;const oa=(e,t)=>{if("undefined"==typeof fetch&&(null==t||null==t.fetchFunc))return null;{let n=!0;if(n=Array.isArray(e)?e.every((e=>ia(e))):ia(e),n)return la(e,t)}return null};function la(e,t){return new aa(e,t)}function ua(e,t){return la(e,t)}yr.registerSaveRouter(oa),yr.registerLoadRouter(oa);class ca{constructor(e){this.modelArtifacts=e}async load(){return this.modelArtifacts}}class ha{constructor(e){this.saveHandler=e}async save(e){return this.saveHandler(e)}}var pa=Object.freeze({__proto__:null,browserFiles:function(e){return new ea(e)},browserHTTPRequest:ua,concatenateArrayBuffers:dr,decodeWeights:ur,encodeWeights:lr,fromMemory:function(e,t,n,s){if(1===arguments.length){return null!=e.modelTopology||null!=e.weightSpecs?new ca(e):(console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new ca({modelTopology:e}))}return console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new ca({modelTopology:e,weightSpecs:t,weightData:n,trainingConfig:s})},getLoadHandlers:xr,getModelArtifactsInfoForJSON:mr,getSaveHandlers:br,http:la,isHTTPScheme:ia,loadWeights:sa,registerLoadRouter:e=>yr.registerLoadRouter(e),registerSaveRouter:e=>yr.registerSaveRouter(e),weightsLoaderFactory:ra,withSaveHandler:function(e){return new ha(e)},copyModel:async function(e,t){return Ur(e,t,!1)},listModels:async function(){const e=Wr.getSchemes(),t={};for(const n of e){const e=await Wr.getManager(n).listModels();for(const s in e){t[n+Pr+s]=e[s]}}return t},moveModel:async function(e,t){return Ur(e,t,!0)},removeModel:async function(e){const t=Vr(e);return Wr.getManager(t.scheme).removeModel(t.path)}});const da=sr({matMul_:function(e,t,n=!1,s=!1){let r=er(e,"a","matMul"),a=er(t,"b","matMul");[r,a]=Os(r,a);const i={a:r,b:a},o={transposeA:n,transposeB:s};return Hs.runKernel(ge,i,o)}});const fa=sr({oneHot_:function(e,t,n=1,s=0){if(t<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${t}`);const r={indices:er(e,"indices","oneHot","int32")},a={depth:t,onValue:n,offValue:s};return Hs.runKernel(Kt,r,a)}});const ma=sr({transpose_:function(e,t){const n=er(e,"x","transpose");if(null==t&&(t=n.shape.map(((e,t)=>t)).reverse()),l(n.rank===t.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of perm ${t}.`)),t.forEach((e=>{l(e>=0&&e<n.rank,(()=>"All entries in 'perm' must be between 0 and "+(n.rank-1)+` but got ${t}`))})),n.rank<=1)return n.clone();const s={x:n},r={perm:t};return Hs.runKernel(Pn,s,r)}});const ga=sr({confusionMatrix_:function(e,t,n){const s=er(e,"labels","confusionMatrix"),r=er(t,"predictions","confusionMatrix");l(null==n||n>0&&Number.isInteger(n),(()=>`If provided, numClasses must be a positive integer, but got ${n}`)),l(1===s.rank,(()=>`Expected the rank of labels to be 1, but got ${s.rank}`)),l(1===r.rank,(()=>`Expected the rank of predictions to be 1, but got ${r.rank}`)),l(s.shape[0]===r.shape[0],(()=>`Mismatch in the number of examples: ${s.shape[0]} vs. ${r.shape[0]}. Labels and predictions should have the same number of elements.`)),l(n>0&&Number.isInteger(n),(()=>`numClasses is required to be a positive integer, but got ${n}`));const a=fa(Xr(s,"int32"),n),i=fa(Xr(r,"int32"),n),o=ma(a),u=da(o,i);return Xr(u,"int32")}});var ya=Object.freeze({__proto__:null,confusionMatrix:ga});function ba(e,t,n){if(c(e),null!=t&&3!==t.length)throw new Error("tensor3d() requires shape to have three numbers");const s=Js(e,n);if(3!==s.length&&1!==s.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return ar(e,t,s,n)}let xa;function wa(e,t=3){if(t>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==e)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,s=!1,r=!1,a=!1,i=!1,o=!1;if(e.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&e instanceof ImageData)s=!0;else if("undefined"!=typeof HTMLVideoElement&&e instanceof HTMLVideoElement)r=!0;else if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement)a=!0;else if(null!=e.getContext)i=!0;else{if(!("undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap))throw new Error(`pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was ${e.constructor.name}`);o=!0}if(r){const t=2;if(r&&e.readyState<t)throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.")}if(null!=Qn(jn,Hs.backendName)){const n={pixels:e},s={numChannels:t};return Hs.runKernel(jn,n,s)}const[l,u]=r?[e.videoWidth,e.videoHeight]:[e.width,e.height];let c,h;if(i?c=e.getContext("2d").getImageData(0,0,l,u).data:s||n?c=e.data:(a||r||o)&&(null==xa&&(xa=document.createElement("canvas").getContext("2d")),xa.canvas.width=l,xa.canvas.height=u,xa.drawImage(e,0,0,l,u),c=xa.getImageData(0,0,l,u).data),4===t)h=new Int32Array(c);else{const e=l*u;h=new Int32Array(e*t);for(let n=0;n<e;n++)for(let e=0;e<t;++e)h[n*t+e]=c[4*n+e]}return ba(h,[u,l,t],"int32")}function ka(e){return"undefined"!=typeof window&&"undefined"!=typeof ImageBitmap&&window.hasOwnProperty("createImageBitmap")&&!(e instanceof ImageBitmap)&&function(e){return null!=e&&0!==e.width&&0!==e.height}(e)&&!function(e){return null!=e&&e.data instanceof Uint8Array}(e)}const va=sr({fromPixels_:wa});var Na=Object.freeze({__proto__:null,fromPixelsAsync:async function(e,t=3){let n=null;if(K().getBool("WRAP_TO_IMAGEBITMAP")&&ka(e)){let t;try{t=await createImageBitmap(e,{premultiplyAlpha:"none"})}catch(e){t=null}n=null!=t&&t.width===e.width&&t.height===e.height?t:e}else n=e;return wa(n,t)},toPixels:async function(e,t){let n=er(e,"img","toPixels");if(!(e instanceof Is)){const e=n;n=Xr(e,"int32"),e.dispose()}if(2!==n.rank&&3!==n.rank)throw new Error(`toPixels only supports rank 2 or 3 tensors, got rank ${n.rank}.`);const[s,r]=n.shape.slice(0,2),a=2===n.rank?1:n.shape[2];if(a>4||2===a)throw new Error(`toPixels only supports depth of size 1, 3 or 4 but got ${a}`);if("float32"!==n.dtype&&"int32"!==n.dtype)throw new Error(`Unsupported type for toPixels: ${n.dtype}. Please use float32 or int32 tensors.`);const i=await n.data(),o="float32"===n.dtype?255:1,l=new Uint8ClampedArray(r*s*4);for(let e=0;e<s*r;++e){const t=[0,0,0,255];for(let s=0;s<a;s++){const r=i[e*a+s];if("float32"===n.dtype){if(r<0||r>1)throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${r}.`)}else if("int32"===n.dtype&&(r<0||r>255))throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${r}.`);1===a?(t[0]=r*o,t[1]=r*o,t[2]=r*o):t[s]=r*o}const s=4*e;l[s+0]=Math.round(t[0]),l[s+1]=Math.round(t[1]),l[s+2]=Math.round(t[2]),l[s+3]=Math.round(t[3])}if(null!=t){t.width=r,t.height=s;const e=t.getContext("2d"),n=new ImageData(l,r,s);e.putImageData(n,0,0)}return n!==e&&n.dispose(),l},fromPixels:va});function Ia(e,t){const n=e.shape.length,s=t.shape.length;if(n<1)throw new Error(`tf.gatherND() expects the input to be rank 1 or higher, but the rank was ${n}.`);if(s<1)throw new Error(`tf.gatherND() expects the indices to be rank 1 or higher, but the rank was ${s}.`);if("int32"!==t.dtype)throw new Error(`tf.gatherND() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.shape[s-1]>n)throw new Error(`index innermost dimension length must be <= tensor rank; saw: ${t.shape[s-1]} vs. ${n}`);if(0===p(e.shape))throw new Error(`Requested more than 0 entries, but input is empty. Input shape: ${e.shape}.`);const r=t.shape,a=r[r.length-1];let i=1;for(let e=0;e<r.length-1;++e)i*=r[e];const o=e.shape,l=r.slice();l.pop();let u=1;for(let e=a;e<n;++e)u*=o[e],l.push(o[e]);const c=[...O(e.shape).map((e=>e/u)),1].slice(0,a);return[l,i,u,c]}var $a=Object.freeze({__proto__:null,prepareAndValidate:Ia});function Ca(e,t,n){const s=t.rank>1?t.shape[t.rank-1]:1,r=t.rank>1?t.rank-1:1,a=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${t.shape}, shape: ${e}, sliceDim: ${s}, and batchDim: ${r}.`;if(n.rank<r)throw new Error(a+` update.rank < ${r}. `);if(e.length<s+(n.rank-r))throw new Error(a+` Output shape length < ${s+(n.rank-r)}`);if(n.rank!==r+e.length-s)throw new Error(a+" update.rank != "+(r+e.length-s));for(let e=0;e<r;++e)if(n.shape[e]!==t.shape[e])throw new Error(a+` updates.shape[${e}] (${n.shape[e]}) != indices.shape[${e}] (${t.shape[e]}).`);for(let t=0;t<n.rank-r;++t)if(n.shape[t+r]!==e[t+s])throw new Error(a+` updates.shape[${t+r}] (${n.shape[t+r]}) != shape[${t+r}] (${e[t+r]})`)}function Sa(e,t,n){if(t.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==t.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${t.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===t.size)throw new Error(`Indices specified for empty output. indices shape: ${t.shape}`);if(0===e.size)throw new Error(`Updates specified for empty output. updates shape: ${e.shape}`)}Ca(n,t,e)}function Ta(e,t,n){const s=t.shape.length,r=s>1?t.shape[s-1]:1,a=n.length;let i=1;for(let e=r;e<a;++e)i*=n[e];const o=r<1?1:r;return{sliceRank:r,numUpdates:p(t.shape)/o,sliceSize:i,strides:[...O(n.slice(0,r)),1],outputSize:p(n)}}var Ea=Object.freeze({__proto__:null,validateUpdateShape:Ca,validateInput:Sa,calculateShapes:Ta});function Aa(e,t,n){const s=e.shape.length;l(s===t.length,(()=>`Error in slice${s}D: Length of begin ${t} must match the rank of the array (${s}).`)),l(s===n.length,(()=>`Error in slice${s}D: Length of size ${n} must match the rank of the array (${s}).`));for(let r=0;r<s;++r)l(t[r]+n[r]<=e.shape[r],(()=>`Error in slice${s}D: begin[${r}] + size[${r}] (${t[r]+n[r]}) would overflow input.shape[${r}] (${e.shape[r]})`))}function Ra(e){const t=[];let n=0;for(;e>0;)1&e&&t.push(n),e/=2,n++;return t}function Fa(e,t,n){const s=[];for(let r=0;r<e.length;r++)s[r]=Math.ceil((t[r]-e[r])/n[r]);return s}function Da(e,t,n,s){const r=[...e];for(let e=r.length;e<s.length;e++)r.push(1);for(let e=0;e<n;e++)0===e?r[t]=1:(r.splice(t,0,1),r.pop());return r}function _a(e,t,n){return n<=e?n:n-(t-1)}function Oa(e,t){const n=[];for(let s=0;s<e;s++)n.push(t+s);return n}function Ma(e,t,n,s,r,a,i,o,l){const u=e.length;let c=new Array(u),h=new Array(u),p=new Array(u);if(t.length&&n>0){const l=t[0],u=n+1;c=La(i,l,u,s,e),h=za(o,l,u,r,e),p=Da(a,l,u,e)}else for(let t=0;t<u;t++)c[t]=Pa(i,s,a,e,t,l),h[t]=Wa(o,r,a,e,t,l),p[t]=Ba(a,t,l);return{begin:c,end:h,strides:p}}function La(e,t,n,s,r){const a=[...r],i=Oa(n,t);for(let r=0;r<a.length;r++)if(i.indexOf(r)>-1)a[r]=0;else{const i=_a(t,n,r);let o=s[i];e&1<<i&&(o=0),a[r]=o}return a}function za(e,t,n,s,r){const i=[...r],o=Oa(n,t);for(let r=0;r<i.length;r++)if(o.indexOf(r)>-1)i[r]=Number.MAX_SAFE_INTEGER;else{const a=_a(t,n,r);let o=s[a];e&1<<a&&(o=Number.MAX_SAFE_INTEGER),i[r]=o}for(let e=0;e<i.length;e++){const t=r[e];i[e]<0&&(i[e]+=t),i[e]=a(0,i[e],r[e])}return i}function Ba(e,t,n){let s=e[t];return(n&1<<t||null==s)&&(s=1),s}function Pa(e,t,n,s,r,i){let o=t[r];const l=n[r]||1;(e&1<<r||i&1<<r||null==o)&&(o=l>0?Number.MIN_SAFE_INTEGER:Number.MAX_SAFE_INTEGER);const u=s[r];return o<0&&(o+=u),o=a(0,o,u-1),o}function Wa(e,t,n,s,r,i){let o=t[r];const l=n[r]||1;(e&1<<r||i&1<<r||null==o)&&(o=l>0?Number.MAX_SAFE_INTEGER:Number.MIN_SAFE_INTEGER);const u=s[r];return o<0&&(o+=u),o=l>0?a(0,o,u):a(-1,o,u-1),o}function Va(e,t,n){let s=n.length;for(let e=0;e<n.length;e++)if(n[e]>1){s=e;break}for(let r=s+1;r<n.length;r++)if(t[r]>0||n[r]!==e[r])return!1;return!0}function Ua(e,t){let n=e.length>0?e[e.length-1]:1;for(let s=0;s<e.length-1;s++)n+=e[s]*t[s];return n}function Ga(e,t,n){let s;const r=e.shape.length;let a;return s="number"==typeof t?[t,...new Array(r-1).fill(0)]:t.length<r?t.concat(new Array(r-t.length).fill(0)):t.slice(),s.forEach((e=>{l(-1!==e,(()=>"slice() does not support negative begin indexing."))})),a=null==n?new Array(r).fill(-1):"number"==typeof n?[n,...new Array(r-1).fill(-1)]:n.length<r?n.concat(new Array(r-n.length).fill(-1)):n,a=a.map(((t,n)=>t>=0?t:(l(-1===t,(()=>`Negative size values should be exactly -1 but got ${t} for the slice() size at index ${n}.`)),e.shape[n]-s[n]))),[s,a]}function Ha(e,t,n,s,r,a,i,o,l){let u=t.slice(),c=n.slice(),h=s;null==s&&(h=new Array(u.length));const p=Ra(i);if(p.length>1)throw new Error("Multiple ellipses in slice is not allowed.");if(0!==i&&0!==o)throw new Error("Using both ellipsisMask and newAxisMask is not yet supported.");if(0!==i&&0!==l)throw new Error("Using both ellipsisMask and shrinkAxisMask is not yet supported.");const d=e.length-u.length,f=Ra(o),m=e.slice();f.forEach((e=>{u[e]=0,c[e]=1,m.splice(e,0,1)}));const{begin:g,end:y,strides:b}=Ma(m,p,d,u,c,h,r,a,i);u=g,c=y,h=b;const x=Ra(l);x.forEach((e=>{c[e]=u[e]+1,h[e]=1}));const w=Fa(u,c,h),k=w.filter(((e,t)=>-1===x.indexOf(t)));return{nonStrided:h.every((e=>1===e)),$begin:u,$end:c,$strides:h,size:w,newShape:m,outShape:k}}var ja=Object.freeze({__proto__:null,assertParamsValid:Aa,maskToAxes:Ra,computeOutShape:Fa,stridesWithElidedDims:Da,getNormalizedAxes:Ma,startIndicesWithElidedDims:La,stopIndicesWithElidedDims:za,stridesForAxis:Ba,startForAxis:Pa,stopForAxis:Wa,isSliceContinous:Va,computeFlatOffset:Ua,parseSliceParams:Ga,sliceInfo:Ha});class qa{getClassName(){return this.constructor.className}static fromConfig(e,t){return new e(t)}}class Ka{constructor(){this.classNameMap={}}static getMap(){return null==Ka.instance&&(Ka.instance=new Ka),Ka.instance}static register(e){Ka.getMap().classNameMap[e.className]=[e,e.fromConfig]}}function Xa(e){l(null!=e.className,(()=>"Class being registered does not have the static className property defined.")),l("string"==typeof e.className,(()=>"className is required to be a string, but got type "+typeof e.className)),l(e.className.length>0,(()=>"Class being registered has an empty-string as its className, which is disallowed.")),Ka.register(e)}var Ya=Object.freeze({__proto__:null,Serializable:qa,SerializationMap:Ka,registerClass:Xa});function Ja(){return 32===Hs.backend.floatPrecision()?.001:.1}function Za(e,t,n){let s=!0;if((C(e)||C(t))&&(s=!1),C(e)&&C(t)&&(s=!0),s){const n=e.constructor.name,s=t.constructor.name;if(n!==s)throw new Error(`Arrays are of different type. Actual: ${n}. Expected: ${s}`)}if(Array.isArray(e)&&Array.isArray(t)){const n=Js(e),s=Js(t);if(!d(n,s))throw new Error(`Arrays have different shapes. Actual: [${n}]. Expected: [${s}]`)}const r=C(e)?e:h(e),a=C(t)?t:h(t);if(r.length!==a.length)throw new Error(`Arrays have different lengths actual: ${r.length} vs expected: ${a.length}.\nActual:   ${r}.\nExpected: ${a}.`);for(let e=0;e<a.length;++e){const t=r[e],s=a[e];if(!n(t,s))throw new Error(`Arrays differ: actual[${e}] = ${t}, expected[${e}] = ${s}.\nActual:   ${r}.\nExpected: ${a}.`)}}function Qa(e,t,n){if(null==n&&(n=Ja()),!ei(e,t,n))throw new Error(`Numbers differ: actual === ${e}, expected === ${t}`)}function ei(e,t,n){return!isFinite(e)&&!isFinite(t)||!(isNaN(e)||isNaN(t)||Math.abs(e-t)>n)}var ti=Object.freeze({__proto__:null,TEST_EPSILON_FLOAT16:.1,expectArraysClose:function(e,t,n){return null==n&&(n=Ja()),Za(e,t,((e,t)=>ei(e,t,n)))},testEpsilon:Ja,expectPromiseToFail:function(e,t){e().then((()=>t.fail()),(()=>t()))},expectArraysEqual:function(e,t){const n="string"==typeof t||"number"==typeof t||"boolean"==typeof t?[t]:t;return E(e)||E(e[0])||E(t)||E(t[0])?Za(e,n,((e,t)=>e==t)):Za(e,t,((e,t)=>ei(e,t,0)))},expectNumbersClose:Qa,expectValuesInRange:function(e,t,n){for(let s=0;s<e.length;s++)if(e[s]<t||e[s]>n)throw new Error(`Value out of range:${e[s]} low: ${t}, high: ${n}`)},expectArrayBuffersEqual:function(e,t){expect(new Float32Array(e)).toEqual(new Float32Array(t))},encodeStrings:function e(t){for(let n=0;n<t.length;n++){const s=t[n];Array.isArray(s)?e(s):t[n]=us(s)}return t}});const ni="3.6.0";function si(e){K().getBool("DEPRECATION_WARNINGS_ENABLED")&&console.warn(e+" You can disable deprecation warnings with tf.disableDeprecationWarnings().")}function ri(){return Hs}function ai(){return Hs.memory()}function ii(e,t){return Hs.tidy(e,t)}function oi(e){zs(e).forEach((e=>e.dispose()))}function li(e){return Hs.keep(e)}function ui(e){return Hs.setBackend(e)}function ci(e,t,n=1){return Hs.registerBackend(e,t,n)}function hi(){return Hs.backend}Ns=si;const pi=sr({add_:function(e,t){let n=er(e,"a","add"),s=er(t,"b","add");[n,s]=Os(n,s);const r={a:n,b:s};return Hs.runKernel(te,r)}});const di=sr({floorDiv_:function(e,t){let n=er(e,"a","floorDiv"),s=er(t,"b","floorDiv");[n,s]=Os(n,s);const r={a:n,b:s};return Hs.runKernel(rt,r)}});const fi=sr({div_:function(e,t){let n=er(e,"a","div"),s=er(t,"b","div");if([n,s]=Os(n,s),"int32"===n.dtype&&"int32"===s.dtype)return di(n,s);const r={a:n,b:s};return Hs.runKernel(He,r,{})}});const mi=sr({mul_:function(e,t){let n=er(e,"a","mul"),s=er(t,"b","mul");[n,s]=Os(n,s);const r={a:n,b:s};return Hs.runKernel(Wt,r)}});const gi=sr({abs_:function(e){const t=er(e,"x","abs");if("complex64"===t.dtype){const e={x:t};return Hs.runKernel(Ie,e)}{const e={x:t};return Hs.runKernel(Z,e)}}});const yi=sr({acos_:function(e){const t={x:er(e,"x","acos")};return Hs.runKernel(Q,t)}});const bi=sr({acosh_:function(e){const t={x:er(e,"x","acosh")};return Hs.runKernel(ee,t)}});const xi=sr({addN_:function(e){l(Array.isArray(e),(()=>"The argument passed to tf.addN() must be a list of tensors")),l(e.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${e.length}`));const t=e.map(((e,t)=>er(e,`tensors${t}`,"addN"))),n=t[0];t.forEach((e=>{if(e.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),t.forEach((e=>{if(!d(e.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const s=t;return Hs.runKernel(ne,s)}});const wi=sr({all_:function(e,t=null,n=!1){const s={x:er(e,"x","all","bool")},r={axis:t,keepDims:n};return Hs.runKernel(se,s,r)}});const ki=sr({any_:function(e,t=null,n=!1){const s={x:er(e,"x","any","bool")},r={axis:t,keepDims:n};return Hs.runKernel(re,s,r)}});const vi=sr({argMax_:function(e,t=0){const n={x:er(e,"x","argMax")},s={axis:t};return Hs.runKernel(ae,n,s)}});const Ni=sr({argMin_:function(e,t=0){const n={x:er(e,"x","argMin")},s={axis:t};return Hs.runKernel(ie,n,s)}});const Ii=sr({asin_:function(e){const t={x:er(e,"x","asin")};return Hs.runKernel(oe,t)}});const $i=sr({asinh_:function(e){const t={x:er(e,"x","asinh")};return Hs.runKernel(le,t)}});const Ci=sr({atan_:function(e){const t={x:er(e,"x","atan")};return Hs.runKernel(ue,t)}});const Si=sr({atan2_:function(e,t){let n=er(e,"a","atan2"),s=er(t,"b","atan2");[n,s]=Os(n,s);const r={a:n,b:s};return Hs.runKernel(he,r)}});const Ti=sr({atanh_:function(e){const t={x:er(e,"x","atanh")};return Hs.runKernel(ce,t)}});function Ei(e,t,n,s,r="NHWC",a){return Fi(e,[...t,e[3]],n,a,s,null,null,Wi(r))}function Ai(e,t,n,s,r,a,i="channelsLast"){const[o,l]=Oi(t);let u;if("channelsLast"===i)u=[o,l,e[3],e[3]];else{if("channelsFirst"!==i)throw new Error(`Unknown dataFormat ${i}`);u=[o,l,e[1],e[1]]}return Fi(e,u,n,s,r,a,!1,i)}function Ri(e,t,n,s,r,a,i="NDHWC"){const[o,l,u]=Mi(t);let c,h;if("NDHWC"===i)h="channelsLast",c=[o,l,u,e[4],e[4]];else{if("NCDHW"!==i)throw new Error(`Unknown dataFormat ${i}`);h="channelsFirst",c=[o,l,u,e[1],e[1]]}return Di(e,c,n,s,r,!1,h,a)}function Fi(e,t,n,s,r,a,i=!1,o="channelsLast"){let[l,u,c,h]=[-1,-1,-1,-1];if("channelsLast"===o)[l,u,c,h]=e;else{if("channelsFirst"!==o)throw new Error(`Unknown dataFormat ${o}`);[l,h,u,c]=e}const[p,d,,f]=t,[m,g]=Oi(n),[y,b]=Oi(s),x=Li(p,y),w=Li(d,b),{padInfo:k,outHeight:v,outWidth:N}=function(e,t,n,s,r,a,i,o,l){let u,c,h;if("number"==typeof e){u={top:e,bottom:e,left:e,right:e,type:0===e?"VALID":"NUMBER"};const r=function(e,t,n,s,r){null==s&&(s=_i(e,t,n));const a=e[0],i=e[1],o=zi((a-t+2*s)/n+1,r),l=zi((i-t+2*s)/n+1,r);return[o,l]}([t,n],a,s,e,o);c=r[0],h=r[1]}else if("same"===e){c=Math.ceil(t/s),h=Math.ceil(n/r);const e=Math.max(0,(c-1)*s+a-t),o=Math.max(0,(h-1)*r+i-n),l=Math.floor(e/2),p=e-l,d=Math.floor(o/2);u={top:l,bottom:p,left:d,right:o-d,type:"SAME"}}else if("valid"===e)u={top:0,bottom:0,left:0,right:0,type:"VALID"},c=Math.ceil((t-a+1)/s),h=Math.ceil((n-i+1)/r);else{if("object"!=typeof e)throw Error(`Unknown padding parameter: ${e}`);{const p="channelsLast"===l?e[1][0]:e[2][0],d="channelsLast"===l?e[1][1]:e[2][1],f="channelsLast"===l?e[2][0]:e[3][0],m="channelsLast"===l?e[2][1]:e[3][1];u={top:p,bottom:d,left:f,right:m,type:0===p&&0===d&&0===f&&0===m?"VALID":"EXPLICIT"},c=zi((t-a+p+d)/s+1,o),h=zi((n-i+f+m)/r+1,o)}}return{padInfo:u,outHeight:c,outWidth:h}}(r,u,c,m,g,x,w,a,o),I=i?f*h:f;let $;return"channelsFirst"===o?$=[l,I,v,N]:"channelsLast"===o&&($=[l,v,N,I]),{batchSize:l,dataFormat:o,inHeight:u,inWidth:c,inChannels:h,outHeight:v,outWidth:N,outChannels:I,padInfo:k,strideHeight:m,strideWidth:g,filterHeight:p,filterWidth:d,effectiveFilterHeight:x,effectiveFilterWidth:w,dilationHeight:y,dilationWidth:b,inShape:e,outShape:$,filterShape:t}}function Di(e,t,n,s,r,a=!1,i="channelsLast",o){let[l,u,c,h,p]=[-1,-1,-1,-1,-1];if("channelsLast"===i)[l,u,c,h,p]=e;else{if("channelsFirst"!==i)throw new Error(`Unknown dataFormat ${i}`);[l,p,u,c,h]=e}const[d,f,m,,g]=t,[y,b,x]=Mi(n),[w,k,v]=Mi(s),N=Li(d,w),I=Li(f,k),$=Li(m,v),{padInfo:C,outDepth:S,outHeight:T,outWidth:E}=function(e,t,n,s,r,a,i,o,l,u,c){let h,p,d,f;if("number"==typeof e){h={top:e,bottom:e,left:e,right:e,front:e,back:e,type:0===e?"VALID":"NUMBER"};const a=function(e,t,n,s,r,a){null==r&&(r=_i(e,t,s));const i=e[0],o=e[1],l=e[2],u=zi((i-t+2*r)/s+1,a),c=zi((o-t+2*r)/s+1,a),h=zi((l-t+2*r)/s+1,a);return[u,c,h,n]}([t,n,s,1],o,1,r,e,c);p=a[0],d=a[1],f=a[2]}else if("same"===e){p=Math.ceil(t/r),d=Math.ceil(n/a),f=Math.ceil(s/i);const e=(p-1)*r+o-t,c=(d-1)*a+l-n,m=(f-1)*i+u-s,g=Math.floor(e/2),y=e-g,b=Math.floor(c/2),x=c-b,w=Math.floor(m/2);h={top:b,bottom:x,left:w,right:m-w,front:g,back:y,type:"SAME"}}else{if("valid"!==e)throw Error(`Unknown padding parameter: ${e}`);h={top:0,bottom:0,left:0,right:0,front:0,back:0,type:"VALID"},p=Math.ceil((t-o+1)/r),d=Math.ceil((n-l+1)/a),f=Math.ceil((s-u+1)/i)}return{padInfo:h,outDepth:p,outHeight:d,outWidth:f}}(r,u,c,h,y,b,x,N,I,$,o),A=a?g*p:g;let R;return"channelsFirst"===i?R=[l,A,S,T,E]:"channelsLast"===i&&(R=[l,S,T,E,A]),{batchSize:l,dataFormat:i,inDepth:u,inHeight:c,inWidth:h,inChannels:p,outDepth:S,outHeight:T,outWidth:E,outChannels:A,padInfo:C,strideDepth:y,strideHeight:b,strideWidth:x,filterDepth:d,filterHeight:f,filterWidth:m,effectiveFilterDepth:N,effectiveFilterHeight:I,effectiveFilterWidth:$,dilationDepth:w,dilationHeight:k,dilationWidth:v,inShape:e,outShape:R,filterShape:t}}function _i(e,t,n,s=1){const r=Li(t,s);return Math.floor((e[0]*(n-1)-n+r)/2)}function Oi(e){return"number"==typeof e?[e,e,e]:2===e.length?[e[0],e[1],1]:e}function Mi(e){return"number"==typeof e?[e,e,e]:e}function Li(e,t){return t<=1?e:e+(e-1)*(t-1)}function zi(e,t){if(!t)return Math.trunc(e);switch(t){case"round":return Math.round(e);case"ceil":return Math.ceil(e);case"floor":return Math.floor(e);default:throw new Error(`Unknown roundingMode ${t}`)}}function Bi(e){const[t,n,s]=Oi(e);return 1===t&&1===n&&1===s}function Pi(e,t){return Bi(e)||Bi(t)}function Wi(e){if("NHWC"===e)return"channelsLast";if("NCHW"===e)return"channelsFirst";throw new Error(`Unknown dataFormat ${e}`)}const Vi=sr({reshape_:function(e,t){const n={x:er(e,"x","reshape","string_or_numeric")},s={shape:t};return Hs.runKernel(rn,n,s)}});const Ui=sr({avgPool_:function(e,t,n,s,r){const a=er(e,"x","avgPool","float32");l(Pi(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let i=a,o=!1;3===a.rank&&(o=!0,i=Vi(a,[1,a.shape[0],a.shape[1],a.shape[2]])),l(4===i.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${i.rank}.`)),null!=r&&l(f(s),(()=>`Error in avgPool: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`));const u={x:i},c={filterSize:t,strides:n,pad:s,dimRoundingMode:r};let h=Hs.runKernel(pe,u,c);return h=Xr(h,a.dtype),o?Vi(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Gi=sr({avgPool3d_:function(e,t,n,s,r,a="NDHWC"){const i=er(e,"x","avgPool3d","float32");let o=i,u=!1;4===i.rank&&(u=!0,o=Vi(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),l(5===o.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${o.rank}.`)),l("NDHWC"===a,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${a}`)),null!=r&&l(f(s),(()=>`Error in avgPool3d: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`));const c={x:o},h={filterSize:t,strides:n,pad:s,dimRoundingMode:r,dataFormat:a};let p=Hs.runKernel(fe,c,h);return p=Xr(p,o.dtype),u?Vi(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const Hi=sr({concat_:function(e,t=0){l(e.length>=1,(()=>"Pass at least one tensor to concat"));const n=tr(e,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((e=>{if("complex64"!==e.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${e.dtype}. `)})),1===n.length)return Yr(n[0]);const s=n,r={axis:t};return Hs.runKernel($e,s,r)}});const ji=sr({sigmoid_:function(e){const t={x:er(e,"x","sigmoid")};return Hs.runKernel(kn,t)}});const qi=sr({slice_:function(e,t,n){const s=er(e,"x","slice","string_or_numeric");if(0===s.rank)throw new Error("Slicing scalar is not possible");const r={x:s},a={begin:t,size:n};return Hs.runKernel(yn,r,a)}});const Ki=sr({tanh_:function(e){const t={x:er(e,"x","tanh")};return Hs.runKernel(Mn,t)}});const Xi=sr({basicLSTMCell_:function(e,t,n,s,r,a){const i=er(e,"forgetBias","basicLSTMCell"),o=er(t,"lstmKernel","basicLSTMCell"),l=er(n,"lstmBias","basicLSTMCell"),u=er(s,"data","basicLSTMCell"),c=er(r,"c","basicLSTMCell"),h=er(a,"h","basicLSTMCell"),p=Hi([u,h],1),d=da(p,o),f=pi(d,l),m=f.shape[0],g=f.shape[1]/4,y=[m,g],b=qi(f,[0,0],y),x=qi(f,[0,g],y),w=qi(f,[0,2*g],y),k=qi(f,[0,3*g],y),v=pi(mi(ji(b),Ki(x)),mi(c,ji(pi(i,w))));return[v,mi(Ki(v),ji(k))]}});const Yi=sr({batchToSpaceND_:function(e,t,n){const s=er(e,"x","batchToSpaceND"),r=t.reduce(((e,t)=>e*t));l(s.rank>=1+t.length,(()=>`input rank is ${s.rank} but should be > than blockShape.length ${t.length}`)),l(n.length===t.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`)),l(s.shape[0]%r==0,(()=>`input tensor batch is ${s.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${r}`));const a={x:s},i={blockShape:t,crops:n};return Hs.runKernel(ye,a,i)}});const Ji=sr({batchNorm_:function(e,t,n,s,r,a){null==a&&(a=.001);const i=er(e,"x","batchNorm"),o=er(t,"mean","batchNorm"),u=er(n,"variance","batchNorm");let c,h;null!=r&&(c=er(r,"scale","batchNorm")),null!=s&&(h=er(s,"offset","batchNorm")),l(o.rank===u.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),l(null==h||o.rank===h.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),l(null==c||o.rank===c.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const p={x:function(e){let t;return t=0===e.rank||1===e.rank?Vi(e,[1,1,1,e.size]):2===e.rank?Vi(e,[1,1,e.shape[0],e.shape[1]]):3===e.rank?Vi(e,[1,e.shape[0],e.shape[1],e.shape[2]]):e,t}(i),scale:c,offset:h,mean:o,variance:u},d={varianceEpsilon:a},f=Hs.runKernel(at,p,d);return Vi(f,i.shape)}});const Zi=sr({batchNorm2d_:function(e,t,n,s,r,a){const i=er(e,"x","batchNorm"),o=er(t,"mean","batchNorm"),u=er(n,"variance","batchNorm");let c,h;return null!=r&&(c=er(r,"scale","batchNorm")),null!=s&&(h=er(s,"offset","batchNorm")),l(2===i.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${i.rank}.`)),l(2===o.rank||1===o.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${o.rank}.`)),l(2===u.rank||1===u.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${u.rank}.`)),null!=c&&l(2===c.rank||1===c.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${c.rank}.`)),null!=h&&l(2===h.rank||1===h.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`)),Ji(i,o,u,h,c,a)}});const Qi=sr({batchNorm3d_:function(e,t,n,s,r,a){const i=er(e,"x","batchNorm"),o=er(t,"mean","batchNorm"),u=er(n,"variance","batchNorm");let c,h;return null!=r&&(c=er(r,"scale","batchNorm")),null!=s&&(h=er(s,"offset","batchNorm")),l(3===i.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${i.rank}.`)),l(3===o.rank||1===o.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${o.rank}.`)),l(3===u.rank||1===u.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${u.rank}.`)),null!=c&&l(3===c.rank||1===c.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${c.rank}.`)),null!=h&&l(3===h.rank||1===h.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`)),Ji(i,o,u,h,c,a)}});const eo=sr({batchNorm4d_:function(e,t,n,s,r,a){const i=er(e,"x","batchNorm"),o=er(t,"mean","batchNorm"),u=er(n,"variance","batchNorm");let c,h;return null!=r&&(c=er(r,"scale","batchNorm")),null!=s&&(h=er(s,"offset","batchNorm")),l(4===i.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${i.rank}.`)),l(4===o.rank||1===o.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${o.rank}.`)),l(4===u.rank||1===u.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${u.rank}.`)),null!=c&&l(4===c.rank||1===c.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${c.rank}.`)),null!=h&&l(4===h.rank||1===h.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`)),Ji(i,o,u,h,c,a)}});const to=sr({bincount_:function(e,t,n){const s=er(e,"x","bincount"),r=er(t,"weights","bincount");l("int32"===s.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${s.dtype}`)),l(n>=0,(()=>`size must be non-negative, but got ${n}.`)),l(r.size===s.size||0===r.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${s.shape}, weights shape: ${r.shape}.`));const a={x:s,weights:r},i={size:n};return Hs.runKernel(be,a,i)}});const no=sr({broadcastTo_:function(e,t){let n=er(e,"broadcastTo","x");const s=n.shape;if(t.some((e=>!(e>0)||e%1!=0)))throw new Error(`broadcastTo(): Invalid broadcast shape [${t}].`);if(t.length<n.rank)throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);if(t.length>n.rank){const e=n.shape.slice();for(;e.length<t.length;)e.unshift(1);n=Vi(n,e)}const r=n.shape,a=Array.from(t);for(let e=t.length-1;e>=0;e--)if(r[e]===t[e])a[e]=1;else if(1!==n.shape[e])throw new Error(`broadcastTo(): [${s}] cannot be broadcast to [${t}].`);if(0===a.map(((e,t)=>e>1?t:-1)).filter((e=>e>=0)).length)return Yr(n);const i={x:n},o={reps:a};return Hs.runKernel(Ln,i,o)}});const so=sr({ceil_:function(e){const t={x:er(e,"x","ceil")};return Hs.runKernel(ke,t)}});const ro=sr({clipByValue_:function(e,t,n){const s=er(e,"x","clipByValue");l(t<=n,(()=>`Error in clip: min (${t}) must be less than or equal to max (${n}).`));const r={x:s},a={clipValueMin:t,clipValueMax:n};return Hs.runKernel(ve,r,a)}});const ao=sr({concat1d_:function(e){return Hi(e,0)}});const io=sr({concat2d_:function(e,t){return Hi(e,t)}});const oo=sr({concat3d_:function(e,t){return Hi(e,t)}});const lo=sr({concat4d_:function(e,t){return Hi(e,t)}});const uo=sr({conv2d_:function(e,t,n,s,r="NHWC",a=[1,1],i){const o=er(e,"x","conv2d"),u=er(t,"filter","conv2d");let c=o,h=!1;3===o.rank&&(h=!0,c=Vi(o,[1,o.shape[0],o.shape[1],o.shape[2]])),l(4===c.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${c.rank}.`)),l(4===u.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${u.rank}.`)),null!=i&&l(f(s),(()=>`Error in conv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`));const p="NHWC"===r?c.shape[3]:c.shape[1];l(p===u.shape[2],(()=>`Error in conv2d: depth of input (${p}) must match input depth for filter ${u.shape[2]}.`)),l(Pi(n,a),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`));const d={x:c,filter:u},m={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i},g=Hs.runKernel(Ce,d,m);return h?Vi(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const co=sr({conv1d_:function(e,t,n,s,r="NWC",a=1,i){const o=er(e,"x","conv1d"),u=er(t,"filter","conv1d");let c=o,h=!1;2===o.rank&&(h=!0,c=Vi(o,[1,o.shape[0],o.shape[1]])),l(3===c.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${c.rank}.`)),l(3===u.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${u.rank}.`)),null!=i&&l(f(s),(()=>`Error in conv1d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`)),l(c.shape[2]===u.shape[1],(()=>`Error in conv1d: depth of input (${c.shape[2]}) must match input depth for filter ${u.shape[1]}.`)),l(Pi(n,a),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${a}'`)),l("NWC"===r,(()=>`Error in conv1d: got dataFormat of ${r} but only NWC is currently supported.`));const p=Vi(u,[1,u.shape[0],u.shape[1],u.shape[2]]),d=Vi(c,[c.shape[0],1,c.shape[1],c.shape[2]]),m=uo(d,p,[1,n],s,"NHWC",[1,a],i);return Vi(m,h?[m.shape[2],m.shape[3]]:[m.shape[0],m.shape[2],m.shape[3]])}});const ho=sr({conv2DBackpropInput_:function(e,t,n,s,r,a="NHWC",i){l(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let o=e,u=t,c=!1;3===t.rank&&(c=!0,u=Vi(t,[1,t.shape[0],t.shape[1],t.shape[2]]),o=[1,e[0],e[1],e[2]]),l(4===o.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${o.length}.`)),l(4===u.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${u.rank}`)),l(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const h="NHWC"===a?o[3]:o[1],p="NHWC"===a?u.shape[3]:u.shape[1];l(h===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`)),l(p===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${p}) must match output depth for filter ${n.shape[3]}.`)),null!=i&&l(f(r),(()=>`Error in conv2dDerInput: pad must be an integer when using, dimRoundingMode ${i} but got pad ${r}.`));const d={dy:u,filter:n},m={strides:s,pad:r,dataFormat:a,dimRoundingMode:i,inputShape:o},g=Hs.runKernel(Te,d,m);return c?Vi(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const po=sr({conv2dTranspose_:function(e,t,n,s,r,a){const i=er(e,"x","conv2dTranspose"),o=er(t,"filter","conv2dTranspose");return ho(n,i,o,s,r,"NHWC",a)}});const fo=sr({conv3d_:function(e,t,n,s,r="NDHWC",a=[1,1,1]){const i=er(e,"x","conv3d"),o=er(t,"filter","conv3d");let u=i,c=!1;4===i.rank&&(c=!0,u=Vi(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),l(5===u.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${u.rank}.`)),l(5===o.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${o.rank}.`)),l(u.shape[4]===o.shape[3],(()=>`Error in conv3d: depth of input (${u.shape[4]}) must match input depth for filter ${o.shape[3]}.`)),l(Pi(n,a),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`)),l("NDHWC"===r,(()=>`Error in conv3d: got dataFormat of ${r} but only NDHWC is currently supported.`));const h={x:u,filter:o},p={strides:n,pad:s,dataFormat:r,dilations:a},d=Hs.runKernel(Ee,h,p);return c?Vi(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const mo=sr({conv3DBackpropInput_:function(e,t,n,s,r){l(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let a=e,i=t,o=!1;4===t.rank&&(o=!0,i=Vi(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]),a=[1,e[0],e[1],e[2],e[3]]);const u=a[4],c=i.shape[4];l(5===a.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${a.length}.`)),l(5===i.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${i.rank}`)),l(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),l(u===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${u}) must match input depth for filter ${n.shape[3]}.`)),l(c===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[4]}.`));const h={dy:i,filter:n},p={pad:r,strides:s,inputShape:a},d=Hs.runKernel(Re,h,p);return o?Vi(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const go=sr({conv3dTranspose_:function(e,t,n,s,r){const a=er(e,"x","conv3dTranspose"),i=er(t,"filter","conv3dTranspose");return mo(n,a,i,s,r)}});const yo=sr({cos_:function(e){const t={x:er(e,"x","cos")};return Hs.runKernel(Fe,t)}});const bo=sr({cosh_:function(e){const t={x:er(e,"x","cosh")};return Hs.runKernel(De,t)}});const xo=sr({cumsum_:function(e,t=0,n=!1,s=!1){const r={x:er(e,"x","cumsum")},a={axis:t,exclusive:n,reverse:s};return Hs.runKernel(_e,r,a)}});const wo=sr({denseBincount_:function(e,t,n,s=!1){const r=er(e,"x","denseBincount"),a=er(t,"weights","denseBincount");l("int32"===r.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${r.dtype}`)),l(r.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${r.rank}.`)),l(n>=0,(()=>`size must be non-negative, but got ${n}.`)),l(a.size===r.size||0===a.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${r.shape}, weights shape: ${a.shape}.`));const i={x:r,weights:a},o={size:n,binaryOutput:s};return Hs.runKernel(Me,i,o)}});const ko=sr({depthToSpace_:function(e,t,n="NHWC"){const s=er(e,"x","depthToSpace"),r="NHWC"===n?s.shape[1]:s.shape[2],a="NHWC"===n?s.shape[2]:s.shape[3],i="NHWC"===n?s.shape[3]:s.shape[1];l(r*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${r} and ${t}  for depthToSpace with input shape\n    ${s.shape}`)),l(a*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${a} and ${t} for depthToSpace with input shape\n        ${s.shape}`)),l(i%(t*t)==0,(()=>`Dimension size must be evenly divisible by ${t*t} but is ${i} for depthToSpace with input shape ${s.shape}`));const o={x:s},u={blockSize:t,dataFormat:n};return Hs.runKernel(Le,o,u)}});const vo=sr({depthwiseConv2d_:function(e,t,n,s,r="NHWC",a=[1,1],i){const o=er(e,"x","depthwiseConv2d"),u=er(t,"filter","depthwiseConv2d");let c=o,h=!1;3===o.rank&&(h=!0,c=Vi(o,[1,o.shape[0],o.shape[1],o.shape[2]])),l(4===c.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${c.rank}.`)),l(4===u.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${u.rank}.`)),l(c.shape[3]===u.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${c.shape[3]}) must match the inChannels dimension in filter ${u.shape[2]}.`)),null!=i&&l(f(s),(()=>`Error in depthwiseConv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`));const p={x:c,filter:u},d={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i},m=Hs.runKernel(ze,p,d);return h?Vi(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const No=sr({diag_:function(e){const t={x:er(e,"x","diag")};return Hs.runKernel(We,t)}});const Io=sr({dilation2d_:function(e,t,n,s,r=[1,1],a="NHWC"){const i=er(e,"x","dilation2d"),o=er(t,"filter","dilation2d");l(3===i.rank||4===i.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${i.rank}.`)),l(3===o.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${o.rank}.`)),l("NHWC"===a,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${a}`));let u=i,c=!1;3===i.rank&&(u=Vi(i,[1,i.shape[0],i.shape[1],i.shape[2]]),c=!0);const h={x:u,filter:o},p={strides:n,pad:s,dilations:r},d=Hs.runKernel(Ve,h,p);return c?Vi(d,[d.shape[1],d.shape[2],d.shape[3]]):d}});function $o(e,t){const n=e.length,s=[];for(let r=0;r<n;r++){const a=n-1-r,i=e[a]||1;(t[t.length-1-r]||1)>1&&1===i&&s.unshift(a)}return s}function Co(e,t){const n=[];for(let s=0;s<t.length;s++){const r=e[e.length-s-1],a=t.length-s-1,i=t[a];(null==r||1===r&&i>1)&&n.unshift(a)}return n}function So(e,t){const n=[],s=Math.max(e.length,t.length);for(let r=0;r<s;r++){let s=e[e.length-r-1];null==s&&(s=1);let a=t[t.length-r-1];if(null==a&&(a=1),1===s)n.unshift(a);else if(1===a)n.unshift(s);else{if(s!==a){throw Error(`Operands could not be broadcast together with shapes ${e} and ${t}.`)}n.unshift(s)}}return n}const To=sr({equal_:function(e,t){let n=er(e,"a","equal"),s=er(t,"b","equal");[n,s]=Os(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Hs.runKernel(Ye,r)}});const Eo=sr({where_:function(e,t,n){const s=er(t,"a","where"),r=er(n,"b","where"),a=er(e,"condition","where","bool"),i=So(So(a.shape,s.shape),r.shape),o={condition:no(a,i),t:no(s,i),e:no(r,i)};return Hs.runKernel(mn,o)}});const Ao=sr({zerosLike_:function(e){const t={x:er(e,"x","zerosLike")};return Hs.runKernel(Gn,t)}});const Ro=sr({divNoNan_:function(e,t){let n=er(e,"a","div"),s=er(t,"b","div");[n,s]=Os(n,s);const r=fi(n,s),a=Ao(r),i=To(s,a);return Eo(i,a,r)}});const Fo=sr({dot_:function(e,t){const n=er(e,"t1","dot"),s=er(t,"t2","dot");l(!(1!==n.rank&&2!==n.rank||1!==s.rank&&2!==s.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${s.rank}.`));const r=1===n.rank?n.size:n.shape[1],a=1===s.rank?s.size:s.shape[0];if(l(r===a,(()=>`Error in dot: inner dimensions of inputs must match, but got ${r} and ${a}.`)),1===n.rank&&1===s.rank){const e=Vi(n,[1,-1]),t=Vi(s,[-1,1]),r=da(e,t);return Vi(r,[])}if(1===n.rank&&2===s.rank){const e=Vi(n,[1,-1]),t=Vi(s,[s.shape[0],s.shape[1]]),r=da(e,t);return Vi(r,[r.size])}if(2===n.rank&&1===s.rank){const e=Vi(s,[-1,1]),t=da(n,e);return Vi(t,[t.size])}{const e=Vi(s,[s.shape[0],s.shape[1]]);return da(n,e)}}});const Do=sr({einsum_:function(e,...t){const n=t.map(((e,t)=>er(e,`tensors${t}`,"einsum"))),s={equation:e};return Hs.runKernel(je,n,s)}});const _o=sr({elu_:function(e){const t={x:er(e,"x","elu")};return Hs.runKernel(qe,t)}});const Oo=sr({erf_:function(e){let t=er(e,"x","erf");l("int32"===t.dtype||"float32"===t.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===t.dtype&&(t=Xr(t,"float32"));const n={x:t};return Hs.runKernel(Xe,n)}});const Mo=sr({exp_:function(e){const t={x:er(e,"x","exp")};return Hs.runKernel(Je,t)}});const Lo=sr({expandDims_:function(e,t=0){const n=er(e,"x","expandDims","string_or_numeric");l(t<=n.rank,(()=>"Axis must be <= rank of the tensor"));const s={input:n},r={dim:t};return Hs.runKernel(Ze,s,r)}});const zo=sr({expm1_:function(e){const t={x:er(e,"x","expm1")};return Hs.runKernel(Qe,t)}});const Bo=sr({tile_:function(e,t){const n=er(e,"x","tile","string_or_numeric");l(n.rank===t.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`));const s={x:n},r={reps:t};return Hs.runKernel(Ln,s,r)}});const Po=sr({eye_:function(e,t,n,s="float32"){null==t&&(t=e);const r=Kr([e,t],s),a=e<=t?e:t;for(let e=0;e<a;++e)r.set(1,e,e);const i=Vi(r.toTensor(),[e,t]);if(null==n)return i;if(1===n.length)return Bo(Lo(i,0),[n[0],1,1]);if(2===n.length)return Bo(Lo(Lo(i,0),0),[n[0],n[1],1,1]);if(3===n.length)return Bo(Lo(Lo(Lo(i,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function Wo(e,t,n){const s={shape:e,value:t,dtype:n};return Hs.runKernel(tt,{},s)}const Vo=sr({floor_:function(e){const t={x:er(e,"x","floor")};return Hs.runKernel(st,t)}});const Uo=sr({gather_:function(e,t,n=0,s=0){const r={x:er(e,"x","gather"),indices:er(t,"indices","gather","int32")},a={axis:n,batchDims:s};return Hs.runKernel(it,r,a)}});const Go=sr({greater_:function(e,t){let n=er(e,"a","greater"),s=er(t,"b","greater");[n,s]=Os(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Hs.runKernel(lt,r)}});const Ho=sr({greaterEqual_:function(e,t){let n=er(e,"a","greaterEqual"),s=er(t,"b","greaterEqual");[n,s]=Os(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Hs.runKernel(ut,r)}});const jo=sr({imag_:function(e){const t={input:er(e,"input","imag")};return Hs.runKernel(pt,t)}});const qo=sr({isFinite_:function(e){const t={x:er(e,"x","isFinite")};return Hs.runKernel(dt,t)}});const Ko=sr({isInf_:function(e){const t={x:er(e,"x","isInf")};return Hs.runKernel(ft,t)}});const Xo=sr({isNaN_:function(e){const t={x:er(e,"x","isNaN")};return Hs.runKernel(mt,t)}});const Yo=sr({leakyRelu_:function(e,t=.2){const n={x:er(e,"x","leakyRelu")},s={alpha:t};return Hs.runKernel(gt,n,s)}});const Jo=sr({less_:function(e,t){let n=er(e,"a","less"),s=er(t,"b","less");[n,s]=Os(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Hs.runKernel(yt,r)}});const Zo=sr({lessEqual_:function(e,t){let n=er(e,"a","lessEqual"),s=er(t,"b","lessEqual");[n,s]=Os(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Hs.runKernel(bt,r)}});function Qo(e,t,n){if(n<=0)throw new Error("The number of values should be positive.");const s={start:e,stop:t,num:n};return Hs.runKernel(xt,{},s)}const el=sr({localResponseNormalization_:function(e,t=5,n=1,s=1,r=.5){const a=er(e,"x","localResponseNormalization");l(4===a.rank||3===a.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${a.rank}.`)),l(f(t),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`));let i=a,o=!1;3===a.rank&&(o=!0,i=Vi(a,[1,a.shape[0],a.shape[1],a.shape[2]]));const u={x:i},c={depthRadius:t,bias:n,alpha:s,beta:r},h=Hs.runKernel(Ct,u,c);return o?Vi(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const tl=sr({log_:function(e){const t={x:er(e,"x","log")};return Hs.runKernel(wt,t)}});const nl=sr({log1p_:function(e){const t={x:er(e,"x","log1p")};return Hs.runKernel(kt,t)}});function sl(e,t){l(D(e),(()=>"The f passed in variableGrads(f) must be a function")),l(null==t||Array.isArray(t)&&t.every((e=>e instanceof Cs)),(()=>"The varList passed in variableGrads(f, varList) must be an array of variables"));const n=null!=t;if(!n){t=[];for(const e in Hs.registeredVariables)t.push(Hs.registeredVariables[e])}const s=n?t.filter((e=>!e.trainable)):null,r=t.length;l((t=t.filter((e=>e.trainable))).length>0,(()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${r} variables is trainable.`));const{value:a,grads:i}=Hs.gradients(e,t,null,!0);l(i.some((e=>null!=e)),(()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize().")),l(0===a.rank,(()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${a.rank} tensor`));const o={};return t.forEach(((e,t)=>{null!=i[t]&&(o[e.name]=i[t])})),null!=s&&s.forEach((e=>o[e.name]=null)),{value:a,grads:o}}function rl(e){return Hs.customGrad(e)}function al(e){if(e.filter((e=>null==e)).length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that\n    the f you passed encloses all operations that lead from x to y.")}const il=sr({neg_:function(e){const t={x:er(e,"x","neg")};return Hs.runKernel(Vt,t)}});const ol=sr({softplus_:function(e){const t={x:er(e,"x","softplus")};return Hs.runKernel(vn,t)}});const ll=sr({logSigmoid_:function(e){const t=er(e,"x","logSigmoid");return rl((e=>({value:il(ol(il(e))),gradFunc:t=>mi(t,ji(il(e)))})))(t)}});const ul=sr({max_:function(e,t=null,n=!1){const s={x:er(e,"x","max")},r={reductionIndices:t,keepDims:n};return Hs.runKernel(Tt,s,r)}});const cl=sr({sub_:function(e,t){let n=er(e,"a","sub"),s=er(t,"b","sub");[n,s]=Os(n,s);const r={a:n,b:s};return Hs.runKernel(_n,r)}});const hl=sr({sum_:function(e,t=null,n=!1){let s=er(e,"x","sum");"bool"===s.dtype&&(s=Xr(s,"int32"));const r={x:s},a={axis:t,keepDims:n};return Hs.runKernel(In,r,a)}});const pl=sr({logSoftmax_:function(e,t=-1){const n=er(e,"logits","logSoftmax");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);return rl(((e,n)=>{const s=ul(e,t,!0),r=cl(e,s),a=cl(Xr(r,"float32"),tl(hl(Mo(r),t,!0)));n([a]);return{value:a,gradFunc:(e,n)=>{const[s]=n,r=Mo(s);return cl(e,mi(hl(e,t,!0),r))}}}))(n)}});function dl(e,t){for(let n=0;n<e.length;++n)if(e[e.length-n-1]!==t-1-n)return!1;return!0}function fl(e,t,n){const s=e.length+t.length,r=[];let a=0,i=0;for(let o=0;o<s;o++)-1===n.indexOf(o)?r.push(e[a++]):r.push(t[i++]);return r}function ml(e,t){const n=[],s=e.length;for(let r=0;r<s;r++)-1===t.indexOf(r)&&n.push(e[r]);return[n,t.map((t=>e[t]))]}function gl(e,t){return fl(e,t.map((e=>1)),t)}function yl(e,t,n){l(dl(t,n),(()=>`${e} supports only inner-most axes for now. Got axes ${t} and rank-${n} input.`))}function bl(e,t){if(dl(e,t))return null;const n=[];for(let s=0;s<t;++s)-1===e.indexOf(s)&&n.push(s);return e.forEach((e=>n.push(e))),n}function xl(e){return e.map(((e,t)=>[t,e])).sort(((e,t)=>e[1]-t[1])).map((e=>e[0]))}function wl(e,t){const n=[];for(let s=t-e;s<t;++s)n.push(s);return n}const kl=sr({logSumExp_:function(e,t=null,n=!1){const s=er(e,"x","logSumExp"),r=x(t,s.shape),a=ul(s,r,!0),i=cl(s,a),o=Mo(i),l=hl(o,r),u=tl(l),c=pi(Vi(a,u.shape),u);if(n){const e=gl(c.shape,r);return Vi(c,e)}return c}});const vl=sr({logicalAnd_:function(e,t){const n=er(e,"a","logicalAnd","bool"),s=er(t,"b","logicalAnd","bool");So(n.shape,s.shape);const r={a:n,b:s};return Hs.runKernel(vt,r)}});const Nl=sr({logicalNot_:function(e){const t={x:er(e,"x","logicalNot","bool")};return Hs.runKernel(Nt,t)}});const Il=sr({logicalOr_:function(e,t){const n=er(e,"a","logicalOr","bool"),s=er(t,"b","logicalOr","bool");So(n.shape,s.shape);const r={a:n,b:s};return Hs.runKernel(It,r)}});const $l=sr({logicalXor_:function(e,t){const n=er(e,"a","logicalXor","bool"),s=er(t,"b","logicalXor","bool");return So(n.shape,s.shape),vl(Il(e,t),Nl(vl(e,t)))}});const Cl=sr({maxPool_:function(e,t,n,s,r){const a=er(e,"x","maxPool");let i=a,o=!1;3===a.rank&&(o=!0,i=Vi(a,[1,a.shape[0],a.shape[1],a.shape[2]])),l(4===i.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${i.rank}.`)),l(Pi(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),null!=r&&l(f(s),(()=>`Error in maxPool: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`));const u={x:i},c={filterSize:t,strides:n,pad:s,dimRoundingMode:r},h=Hs.runKernel(At,u,c);return o?Vi(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Sl=sr({maxPool3d_:function(e,t=[1,1,1],n,s,r,a="NDHWC"){const i=er(e,"x","maxPool3d");let o=i,u=!1;4===i.rank&&(u=!0,o=Vi(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),l(5===o.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${o.rank}.`)),l("NDHWC"===a,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${a}`)),null!=r&&l(f(s),(()=>`Error in maxPool3d: pad must be an integer when using, dimRoundingMode ${r} but got pad ${s}.`));const c={x:o},h={filterSize:t,strides:n,pad:s,dimRoundingMode:r,dataFormat:a},p=Hs.runKernel(Ft,c,h);return u?Vi(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const Tl=sr({maxPoolWithArgmax_:function(e,t,n,s,r=!1){const a={x:er(e,"x","maxPoolWithArgmax")},i={filterSize:t,strides:n,pad:s,includeBatchInIndex:r},o=Hs.runKernel(_t,a,i);return{result:o[0],indexes:o[1]}}});const El=sr({maximum_:function(e,t){let n=er(e,"a","maximum"),s=er(t,"b","maximum");[n,s]=Os(n,s),"bool"===n.dtype&&(n=Xr(n,"int32"),s=Xr(s,"int32")),So(n.shape,s.shape);const r={a:n,b:s};return Hs.runKernel(Et,r)}});const Al=sr({mean_:function(e,t=null,n=!1){const s={x:er(e,"x","mean")},r={axis:t,keepDims:n};return Hs.runKernel(Ot,s,r)}});function Rl(e,t="float32"){if("complex64"===t){const t=Rl(e,"float32"),n=Rl(e,"float32");return rr(t,n)}const n=B(p(e),t);return Hs.makeTensor(n,e,t)}function Fl(e,t="float32"){if("complex64"===t){const t=Fl(e,"float32"),n=Rl(e,"float32");return rr(t,n)}const n=z(p(e),t);return Hs.makeTensor(n,e,t)}const Dl=sr({min_:function(e,t=null,n=!1){const s={x:er(e,"x","min")},r={axis:t,keepDims:n};return Hs.runKernel(Mt,s,r)}});const _l=sr({minimum_:function(e,t){let n=er(e,"a","minimum"),s=er(t,"b","minimum");[n,s]=Os(n,s),"bool"===n.dtype&&(n=Xr(n,"int32"),s=Xr(s,"int32")),So(n.shape,s.shape);const r={a:n,b:s};return Hs.runKernel(Lt,r)}});const Ol=sr({mirrorPad_:function(e,t,n){l("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const s=er(e,"x","mirrorPad");if(0===s.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");l(t.length===s.rank,(()=>`Padding doesn't match input. Must be ${s.rank}. Got ${t.length}.`));const r="reflect"===n?1:0;for(let e=0;e<s.rank;e++)l(2===t[e].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),l(t[e][0]>=0&&t[e][0]<=s.shape[e]-r&&t[e][1]>=0&&t[e][1]<=s.shape[e]-r,(()=>`Padding in dimension ${e} cannot be greater than or equal to ${s.shape[e]-r} or less than 0 for input of shape ${s.shape}`));const a={paddings:t,mode:n},i={x:s};return Hs.runKernel(zt,i,a)}});const Ml=sr({mod_:function(e,t){let n=er(e,"a","mod"),s=er(t,"b","mod");[n,s]=Os(n,s);const r={a:n,b:s};return Hs.runKernel(Bt,r)}});const Ll=sr({square_:function(e){const t=er(e,"x","square");return Hs.runKernel("Square",{x:t},{})}});const zl=sr({moments_:function(e,t=null,n=!1){const s=x(t,(e=er(e,"x","moments")).shape),r=Al(e,s,n);let a=r.shape;n||(a=gl(r.shape,s));const i=Ll(cl(Xr(e,"float32"),Vi(r,a)));return{mean:r,variance:Al(i,s,n)}}});const Bl=sr({multiRNNCell_:function(e,t,n,s){const r=er(t,"data","multiRNNCell"),a=tr(n,"c","multiRNNCell"),i=tr(s,"h","multiRNNCell");let o=r;const l=[];for(let t=0;t<e.length;t++){const n=e[t](o,a[t],i[t]);l.push(n[0]),l.push(n[1]),o=n[1]}const u=[],c=[];for(let e=0;e<l.length;e+=2)u.push(l[e]),c.push(l[e+1]);return[u,c]}});const Pl=sr({multinomial_:function(e,t,n,s=!1){const r=er(e,"logits","multinomial"),a=r.size,i=r.rank;if(a<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${a}.`);if(i>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${i}`);n=n||Math.random();const o={logits:1===i?Vi(r,[1,-1]):r},l={numSamples:t,seed:n,normalized:s},u=Hs.runKernel(Pt,o,l);return 1===i?Vi(u,[u.size]):u}});const Wl=sr({notEqual_:function(e,t){let n=er(e,"a","notEqual"),s=er(t,"b","notEqual");[n,s]=Os(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Hs.runKernel(Ut,r)}});const Vl=sr({onesLike_:function(e){const t={x:er(e,"x","onesLike")};return Hs.runKernel(qt,t)}});const Ul=sr({outerProduct_:function(e,t){const n=er(e,"v1","outerProduct"),s=er(t,"v2","outerProduct");l(1===n.rank&&1===s.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${s.rank}.`));const r=Vi(n,[-1,1]),a=Vi(s,[1,-1]);return da(r,a)}});const Gl=sr({pad_:function(e,t,n=0){const s=er(e,"x","pad");if(0===s.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const r={paddings:t,constantValue:n},a={x:s};return Hs.runKernel(Yt,a,r)}});const Hl=sr({pad1d_:function(e,t,n=0){return l(2===t.length,(()=>"Invalid number of paddings. Must be length of 2.")),Gl(e,[t],n)}});const jl=sr({pad2d_:function(e,t,n=0){return l(2===t.length&&2===t[0].length&&2===t[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Gl(e,t,n)}});const ql=sr({pad3d_:function(e,t,n=0){return l(3===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Gl(e,t,n)}});const Kl=sr({pad4d_:function(e,t,n=0){return l(4===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length&&2===t[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Gl(e,t,n)}});const Xl=sr({spaceToBatchND_:function(e,t,n){const s=er(e,"x","spaceToBatchND");l(s.rank>=1+t.length,(()=>`input rank ${s.rank} should be > than [blockShape] ${t.length}`)),l(n.length===t.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`)),l(s.shape.reduce(((e,s,r)=>r>0&&r<=t.length?e&&(s+n[r-1][0]+n[r-1][1])%t[r-1]==0:e),!0),(()=>`input spatial dimensions ${s.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`));const r={x:s},a={blockShape:t,paddings:n};return Hs.runKernel($n,r,a)}});const Yl=sr({pool_:function(e,t,n,s,r,a){null==r&&(r=[1,1]),null==a&&(a=1),0===s&&(s="valid");const i=er(e,"x","maxPool");let o=i,u=!1;3===i.rank&&(u=!0,o=Vi(i,[1,i.shape[0],i.shape[1],i.shape[2]])),l(Pi(a,r),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${a} and dilations '${r}'`));const c=Ai(o.shape,t,a,r,s),h=[c.dilationHeight,c.dilationWidth];let p;p="same"===s?function(e,t){const n=e.map(((e,n)=>e+(e-1)*(t[n]-1))).map((e=>e-1)),s=n.map((e=>Math.floor(e/2))),r=n.map(((e,t)=>e-s[t]));return n.map(((e,t)=>[s[t],r[t]]))}([c.filterHeight,c.filterWidth],h):[[0,0],[0,0]];const d=1===h[0]&&1===h[1],[f,m]=function(e,t,n){const s=n.map((e=>e[0])),r=n.map((e=>e[1])),a=e.concat(s,r),i=t.map(((e,t)=>(e-a[t]%e)%e)),o=r.map(((e,t)=>e+i[t])),l=t.map(((e,t)=>[s[t],o[t]])),u=t.map(((e,t)=>[0,i[t]]));return[l,u]}([c.inHeight,c.inWidth],h,p),g=d?s:"valid",y=d?o:Xl(o,h,f),b=("avg"===n?()=>Ui(y,t,a,g):()=>Cl(y,t,a,g))(),x=d?b:Yi(b,h,m);return u?Vi(x,[x.shape[1],x.shape[2],x.shape[3]]):x}});const Jl=sr({pow_:function(e,t){let n=er(e,"base","pow"),s=er(t,"exp","pow");[n,s]=Os(n,s);const r={a:n,b:s};return Hs.runKernel(Jt,r)}});const Zl=sr({prelu_:function(e,t){const n={x:er(e,"x","prelu"),alpha:er(t,"alpha","prelu")};return Hs.runKernel(Zt,n)}});const Ql=sr({prod_:function(e,t=null,n=!1){let s=er(e,"x","prod");"bool"===s.dtype&&(s=Xr(s,"int32"));const r={x:s},a={axis:t,keepDims:n};return Hs.runKernel(Qt,r,a)}});const eu=sr({rand_:function(e,t,n){const s=p(e);let r=null;if(null==n||"float32"===n)r=new Float32Array(s);else if("int32"===n)r=new Int32Array(s);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);r=new Uint8Array(s)}for(let e=0;e<s;e++)r[e]=t();return Hs.makeTensor(r,e,n)}});"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self&&self;function tu(e,t){return e(t={exports:{}},t.exports),t.exports}var nu=tu((function(e){!function(e,t,n){function s(e){var t,n=this,s=(t=4022871197,function(e){e=e.toString();for(var n=0;n<e.length;n++){var s=.02519603282416938*(t+=e.charCodeAt(n));s-=t=s>>>0,t=(s*=t)>>>0,t+=4294967296*(s-=t)}return 2.3283064365386963e-10*(t>>>0)});n.next=function(){var e=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=e-(n.c=0|e)},n.c=1,n.s0=s(" "),n.s1=s(" "),n.s2=s(" "),n.s0-=s(e),n.s0<0&&(n.s0+=1),n.s1-=s(e),n.s1<0&&(n.s1+=1),n.s2-=s(e),n.s2<0&&(n.s2+=1),s=null}function r(e,t){return t.c=e.c,t.s0=e.s0,t.s1=e.s1,t.s2=e.s2,t}function a(e,t){var n=new s(e),a=t&&t.state,i=n.next;return i.int32=function(){return 4294967296*n.next()|0},i.double=function(){return i()+11102230246251565e-32*(2097152*i()|0)},i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.alea=a}(0,e,!1)})),su=tu((function(e){!function(e,t,n){function s(e){var t=this,n="";t.x=0,t.y=0,t.z=0,t.w=0,t.next=function(){var e=t.x^t.x<<11;return t.x=t.y,t.y=t.z,t.z=t.w,t.w^=t.w>>>19^e^e>>>8},e===(0|e)?t.x=e:n+=e;for(var s=0;s<n.length+64;s++)t.x^=0|n.charCodeAt(s),t.next()}function r(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor128=a}(0,e,!1)})),ru=tu((function(e){!function(e,t,n){function s(e){var t=this,n="";t.next=function(){var e=t.x^t.x>>>2;return t.x=t.y,t.y=t.z,t.z=t.w,t.w=t.v,(t.d=t.d+362437|0)+(t.v=t.v^t.v<<4^e^e<<1)|0},t.x=0,t.y=0,t.z=0,t.w=0,t.v=0,e===(0|e)?t.x=e:n+=e;for(var s=0;s<n.length+64;s++)t.x^=0|n.charCodeAt(s),s==n.length&&(t.d=t.x<<10^t.x>>>4),t.next()}function r(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t.v=e.v,t.d=e.d,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorwow=a}(0,e,!1)})),au=tu((function(e){!function(e,t,n){function s(e){var t=this;t.next=function(){var e,n,s=t.x,r=t.i;return e=s[r],n=(e^=e>>>7)^e<<24,n^=(e=s[r+1&7])^e>>>10,n^=(e=s[r+3&7])^e>>>3,n^=(e=s[r+4&7])^e<<7,e=s[r+7&7],n^=(e^=e<<13)^e<<9,s[r]=n,t.i=r+1&7,n},function(e,t){var n,s=[];if(t===(0|t))s[0]=t;else for(t=""+t,n=0;n<t.length;++n)s[7&n]=s[7&n]<<15^t.charCodeAt(n)+s[n+1&7]<<13;for(;s.length<8;)s.push(0);for(n=0;n<8&&0===s[n];++n);for(8==n?s[7]=-1:s[n],e.x=s,e.i=0,n=256;n>0;--n)e.next()}(t,e)}function r(e,t){return t.x=e.x.slice(),t.i=e.i,t}function a(e,t){null==e&&(e=+new Date);var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&(a.x&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorshift7=a}(0,e,!1)})),iu=tu((function(e){!function(e,t,n){function s(e){var t=this;t.next=function(){var e,n,s=t.w,r=t.X,a=t.i;return t.w=s=s+1640531527|0,n=r[a+34&127],e=r[a=a+1&127],n^=n<<13,e^=e<<17,n^=n>>>15,e^=e>>>12,n=r[a]=n^e,t.i=a,n+(s^s>>>16)|0},function(e,t){var n,s,r,a,i,o=[],l=128;for(t===(0|t)?(s=t,t=null):(t+="\0",s=0,l=Math.max(l,t.length)),r=0,a=-32;a<l;++a)t&&(s^=t.charCodeAt((a+32)%t.length)),0===a&&(i=s),s^=s<<10,s^=s>>>15,s^=s<<4,s^=s>>>13,a>=0&&(i=i+1640531527|0,r=0==(n=o[127&a]^=s+i)?r+1:0);for(r>=128&&(o[127&(t&&t.length||0)]=-1),r=127,a=512;a>0;--a)s=o[r+34&127],n=o[r=r+1&127],s^=s<<13,n^=n<<17,s^=s>>>15,n^=n>>>12,o[r]=s^n;e.w=i,e.X=o,e.i=r}(t,e)}function r(e,t){return t.i=e.i,t.w=e.w,t.X=e.X.slice(),t}function a(e,t){null==e&&(e=+new Date);var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&(a.X&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor4096=a}(0,e,!1)})),ou=tu((function(e){!function(e,t,n){function s(e){var t=this,n="";t.next=function(){var e=t.b,n=t.c,s=t.d,r=t.a;return e=e<<25^e>>>7^n,n=n-s|0,s=s<<24^s>>>8^r,r=r-e|0,t.b=e=e<<20^e>>>12^n,t.c=n=n-s|0,t.d=s<<16^n>>>16^r,t.a=r-e|0},t.a=0,t.b=0,t.c=-1640531527,t.d=1367130551,e===Math.floor(e)?(t.a=e/4294967296|0,t.b=0|e):n+=e;for(var s=0;s<n.length+20;s++)t.b^=0|n.charCodeAt(s),t.next()}function r(e,t){return t.a=e.a,t.b=e.b,t.c=e.c,t.d=e.d,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.tychei=a}(0,e,!1)})),lu=tu((function(e){!function(t,n){var s,r=this,a=256,i=n.pow(a,6),o=n.pow(2,52),l=2*o,u=255;function c(e,u,c){var g=[],y=f(d((u=1==u?{entropy:!0}:u||{}).entropy?[e,m(t)]:null==e?function(){try{var e;return s&&(e=s.randomBytes)?e=e(a):(e=new Uint8Array(a),(r.crypto||r.msCrypto).getRandomValues(e)),m(e)}catch(e){var n=r.navigator,i=n&&n.plugins;return[+new Date,r,i,r.screen,m(t)]}}():e,3),g),b=new h(g),x=function(){for(var e=b.g(6),t=i,n=0;e<o;)e=(e+n)*a,t*=a,n=b.g(1);for(;e>=l;)e/=2,t/=2,n>>>=1;return(e+n)/t};return x.int32=function(){return 0|b.g(4)},x.quick=function(){return b.g(4)/4294967296},x.double=x,f(m(b.S),t),(u.pass||c||function(e,t,s,r){return r&&(r.S&&p(r,b),e.state=function(){return p(b,{})}),s?(n.random=e,t):e})(x,y,"global"in u?u.global:this==n,u.state)}function h(e){var t,n=e.length,s=this,r=0,i=s.i=s.j=0,o=s.S=[];for(n||(e=[n++]);r<a;)o[r]=r++;for(r=0;r<a;r++)o[r]=o[i=u&i+e[r%n]+(t=o[r])],o[i]=t;(s.g=function(e){for(var t,n=0,r=s.i,i=s.j,o=s.S;e--;)t=o[r=u&r+1],n=n*a+o[u&(o[r]=o[i=u&i+t])+(o[i]=t)];return s.i=r,s.j=i,n})(a)}function p(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function d(e,t){var n,s=[],r=typeof e;if(t&&"object"==r)for(n in e)try{s.push(d(e[n],t-1))}catch(e){}return s.length?s:"string"==r?e:e+"\0"}function f(e,t){for(var n,s=e+"",r=0;r<s.length;)t[u&r]=u&(n^=19*t[u&r])+s.charCodeAt(r++);return m(t)}function m(e){return String.fromCharCode.apply(0,e)}if(n.seedrandom=c,f(n.random(),t),e.exports){e.exports=c;try{s=require("crypto")}catch(e){}}else 0}([],Math)}));lu.alea=nu,lu.xor128=su,lu.xorwow=ru,lu.xorshift7=au,lu.xor4096=iu,lu.tychei=ou;var uu=lu.alea;class cu{constructor(e,t,n,s,r){this.mean=e,this.stdDev=t,this.dtype=n,this.nextVal=NaN,this.truncated=s,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const a=r||Math.random();this.random=uu(a.toString())}nextValue(){if(!isNaN(this.nextVal)){const e=this.nextVal;return this.nextVal=NaN,e}let e,t,n=!1;for(;!n;){let s,r,a;do{s=2*this.random()-1,r=2*this.random()-1,a=s*s+r*r}while(a>=1||0===a);const i=Math.sqrt(-2*Math.log(a)/a);e=this.mean+this.stdDev*s*i,t=this.mean+this.stdDev*r*i,this.truncated&&!this.isValidTruncated(e)||(n=!0)}return this.truncated&&!this.isValidTruncated(t)||(this.nextVal=this.convertValue(t)),this.convertValue(e)}convertValue(e){return null==this.dtype||"float32"===this.dtype?e:Math.round(e)}isValidTruncated(e){return e<=this.upper&&e>=this.lower}}class hu{constructor(e,t,n,s){this.alpha=e,this.beta=1/t,this.dtype=n;const r=s||Math.random();this.randu=uu(r.toString()),this.randn=new cu(0,1,n,!1,this.randu()),this.d=e<1?e+2/3:e-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let e,t,n,s,r,a;for(;;){do{s=this.randn.nextValue(),a=1+this.c*s}while(a<=0);if(a*=a*a,e=s*s,t=1-.331*e*e,n=.5*e+this.d*(1-a+Math.log(a)),r=this.randu(),r<t||Math.log(r)<n)break}return a=1/this.beta*this.d*a,this.alpha<1&&(a*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(a)}convertValue(e){return"float32"===this.dtype?e:Math.round(e)}}class pu{constructor(e=0,t=1,n,s){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=e,this.range=t-e,this.dtype=n,null==s&&(s=Math.random()),"number"==typeof s&&(s=s.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);this.random=uu(s)}convertValue(e){return this.canReturnFloat()?e:Math.round(e)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const du=sr({randomGamma_:function(e,t,n=1,s="float32",r){if(null==n&&(n=1),null==s&&(s="float32"),"float32"!==s&&"int32"!==s)throw new Error(`Unsupported data type ${s}`);const a=new hu(t,n,s,r),i=Kr(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const fu=sr({randomNormal_:function(e,t=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error(`Unsupported data type ${s}`);const a=new cu(t,n,s,!1,r),i=Kr(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const mu=sr({randomUniform_:function(e,t=0,n=1,s="float32",r){const a=Kr(e,s),i=new pu(t,n,null,r);for(let e=0;e<a.values.length;e++)a.values[e]=i.nextValue();return a.toTensor()}});function gu(e,t,n=1,s="float32"){if(0===n)throw new Error("Cannot have a step of zero");const r={start:e,stop:t,step:n,dtype:s};return Hs.runKernel(en,{},r)}const yu=sr({real_:function(e){const t={input:er(e,"input","real")};return Hs.runKernel(tn,t)}});const bu=sr({reciprocal_:function(e){const t={x:er(e,"x","reciprocal")};return Hs.runKernel(nn,t)}});const xu=sr({relu_:function(e){const t={x:er(e,"x","relu")};return Hs.runKernel(sn,t)}});const wu=sr({relu6_:function(e){const t={x:er(e,"x","relu6")};return Hs.runKernel(cn,t)}});const ku=sr({reverse_:function(e,t){const n={x:er(e,"x","reverse")},s={dims:t};return Hs.runKernel(hn,n,s)}});const vu=sr({reverse1d_:function(e){const t=er(e,"x","reverse");return l(1===t.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`)),ku(t,0)}});const Nu=sr({reverse2d_:function(e,t){const n=er(e,"x","reverse");return l(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),ku(n,t)}});const Iu=sr({reverse3d_:function(e,t){const n=er(e,"x","reverse");return l(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),ku(n,t)}});const $u=sr({reverse4d_:function(e,t){const n=er(e,"x","reverse");return l(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),ku(n,t)}});const Cu=sr({round_:function(e){const t={x:er(e,"x","round")};return Hs.runKernel(pn,t)}});const Su=sr({rsqrt_:function(e){const t={x:er(e,"x","rsqrt")};return Hs.runKernel(dn,t)}});function Tu(e,t){if((C(e)&&"string"!==t||Array.isArray(e))&&"complex64"!==t)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===t&&C(e)&&!(e instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return ar(e,[],[],t)}const Eu=sr({selu_:function(e){const t={x:er(e,"x","selu")};return Hs.runKernel(gn,t)}});const Au=sr({separableConv2d_:function(e,t,n,s,r,a=[1,1],i="NHWC"){const o=er(e,"x","separableConv2d"),u=er(t,"depthwiseFilter","separableConv2d"),c=er(n,"pointwiseFilter","separableConv2d");let h=o,p=!1;if(3===o.rank&&(p=!0,h=Vi(o,[1,o.shape[0],o.shape[1],o.shape[2]])),"NCHW"===i)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");l(4===h.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`)),l(4===u.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${u.rank}.`)),l(4===c.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${u.rank}.`)),l(1===c.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${c.shape[0]}.`)),l(1===c.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${c.shape[1]}.`));const d=u.shape[2],f=u.shape[3];l(c.shape[2]===d*f,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${d*f}, but got ${c.shape[2]}.`));const m=vo(h,u,s,r,i,a),g=uo(m,c,1,"valid",i);return p?Vi(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const Ru=async function(e,t){const n=er(e,"x","setdiff1d"),s=er(t,"y","setdiff1d");l(n.dtype===s.dtype,(()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${s.dtype}).`)),l(1===n.rank,(()=>`x should be 1D tensor, but got x (${n.shape}).`)),l(1===s.rank,(()=>`y should be 1D tensor, but got y (${s.shape}).`));const r=await n.data(),a=await s.data(),i=new Set(a);let o=0;for(let e=0;e<r.length;e++)i.has(r[e])||o++;const u=new ws([o],n.dtype),c=new ws([o],"int32");for(let e=0,t=0;e<r.length;e++)i.has(r[e])||(u.values[t]=r[e],c.values[t]=e,t++);return[u.toTensor(),c.toTensor()]};const Fu=sr({sign_:function(e){const t={x:er(e,"x","sign")};return Hs.runKernel(wn,t)}});const Du=sr({sin_:function(e){const t={x:er(e,"x","sin")};return Hs.runKernel(bn,t)}});const _u=sr({sinh_:function(e){const t={x:er(e,"x","sinh")};return Hs.runKernel(xn,t)}});const Ou=sr({slice1d_:function(e,t,n){const s=er(e,"x","slice1d");return l(1===s.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${s.rank} tensor`)),qi(s,[t],[n])}});const Mu=sr({slice2d_:function(e,t,n){const s=er(e,"x","slice2d");return l(2===s.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${s.rank} tensor`)),qi(s,t,n)}});const Lu=sr({slice3d_:function(e,t,n){const s=er(e,"x","slice3d");return l(3===s.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${s.rank} tensor`)),qi(s,t,n)}});const zu=sr({slice4d_:function(e,t,n){const s=er(e,"x","slice4d");return l(4===s.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${s.rank} tensor`)),qi(s,t,n)}});const Bu=sr({softmax_:function(e,t=-1){const n=er(e,"logits","softmax","float32");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);const s={logits:n},r={dim:t};return Hs.runKernel(Sn,s,r)}});const Pu=sr({fft_:function(e){l("complex64"===e.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`));const t={input:e};return Hs.runKernel(et,t)}});const Wu=sr({ifft_:function(e){l("complex64"===e.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`));const t={input:e};return Hs.runKernel(ht,t)}});const Vu=sr({irfft_:function(e){const t=e.shape[e.shape.length-1],n=e.size/t;let s;if(t<=2){const r=Vi(e,[n,t]);s=Wu(r)}else{const r=[n,2*(t-1)],a=Vi(yu(e),[n,t]),i=Vi(jo(e),[n,t]),o=ku(qi(a,[0,1],[n,t-2]),1),l=mi(ku(qi(i,[0,1],[n,t-2]),1),Tu(-1)),u=Hi([a,o],1),c=Hi([i,l],1),h=Vi(rr(u,c),[r[0],r[1]]);s=Wu(h)}if(s=yu(s),3===e.rank&&0!==e.shape[0]){const t=s,n=e.shape[0];s=Vi(s,[n,s.shape[0]/n,s.shape[1]]),t.dispose()}return s}});const Uu=sr({split_:function(e,t,n=0){const s={x:er(e,"x","split")},r={numOrSizeSplits:t,axis:n};return Hs.runKernel(Cn,s,r)}});const Gu=sr({rfft_:function(e,t){l("float32"===e.dtype,(()=>`The dtype for rfft() must be real value but got ${e.dtype}`));let n=e.shape[e.shape.length-1];const s=e.size/n;let r;if(null!=t&&t<n){const s=e.shape.map((e=>0)),a=e.shape.map((e=>e));a[e.shape.length-1]=t,r=qi(e,s,a),n=t}else if(null!=t&&t>n){const s=e.shape.map((e=>e));s[e.shape.length-1]=t-n,r=Hi([e,Rl(s)],e.shape.length-1),n=t}else r=e;const a=Ao(r),i=Vi(rr(r,a),[s,n]),o=Pu(i),u=Math.floor(n/2)+1,c=yu(o),h=jo(o),p=Uu(c,[u,n-u],c.shape.length-1),d=Uu(h,[u,n-u],h.shape.length-1),f=r.shape.slice();return f[r.shape.length-1]=u,Vi(rr(p[0],d[0]),f)}});const Hu=sr({sqrt_:function(e){const t={x:er(e,"x","sqrt")};return Hs.runKernel(Nn,t)}});const ju=sr({squaredDifference_:function(e,t){let n=er(e,"a","squaredDifference"),s=er(t,"b","squaredDifference");[n,s]=Os(n,s),So(n.shape,s.shape);const r={a:n,b:s};return Hs.runKernel(Rn,r,{})}});const qu=sr({squeeze_:function(e,t){const n=er(e,"x","squeeze");return Vi(n,w(n.shape,t).newShape)}});const Ku=sr({stack_:function(e,t=0){const n=tr(e,"tensors","stack","string_or_numeric");l(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&l(t<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const s=n,r={axis:t};return Hs.runKernel(Xt,s,r)}});const Xu=sr({step_:function(e,t=0){const n={x:er(e,"x","step")},s={alpha:t};return Hs.runKernel(Hn,n,s)}});const Yu=sr({stridedSlice_:function(e,t,n,s,r=0,a=0,i=0,o=0,l=0){const u={x:er(e,"x","stridedSlice")},c={begin:t,end:n,strides:s,beginMask:r,endMask:a,ellipsisMask:i,newAxisMask:o,shrinkAxisMask:l};return Hs.runKernel(Dn,u,c)}});const Ju=sr({tan_:function(e){const t={x:er(e,"x","tan")};return Hs.runKernel(On,t)}});function Zu(e,t){c(e);const n=Js(e,t);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return ar(e,null,n,t)}function Qu(e,t,n){if(c(e),null!=t&&2!==t.length)throw new Error("tensor2d() requires shape to have two numbers");const s=Js(e,n);if(2!==s.length&&1!==s.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return ar(e,t,s,n)}const ec=sr({topk_:function(e,t=1,n=!0){const s=er(e,"x","topk");if(0===s.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const r=s.shape[s.shape.length-1];if(t>r)throw new Error(`'k' passed to topk() must be <= the last dimension (${r}) but got ${t}`);const a={x:s},i={k:t,sorted:n},[o,l]=Hs.runKernel(zn,a,i);return{values:o,indices:l}}});const tc=sr({truncatedNormal_:function(e,t=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error("Unsupported data type $ { dtype }");const a=new cu(t,n,s,!0,r),i=Kr(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const nc=sr({unique_:function(e,t=0){const n=er(e,"x","unique","string_or_numeric");l(n.rank>0,(()=>"The input tensor must be at least 1D"));const s={x:n},r={axis:t},[a,i]=Hs.runKernel(Wn,s,r);return{values:a,indices:i}}});const sc=sr({unsortedSegmentSum_:function(e,t,n){const s=er(e,"x","unsortedSegmentSum"),r=er(t,"segmentIds","unsortedSegmentSum","int32");l(f(n),(()=>"numSegments must be of dtype int"));const a={x:s,segmentIds:r},i={numSegments:n};return Hs.runKernel(Un,a,i)}});const rc=sr({unstack_:function(e,t=0){const n=er(e,"x","unstack","string_or_numeric");l(t>=-n.shape.length&&t<n.shape.length,(()=>`Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`));const s={value:n},r={axis:t};return Hs.runKernel(Vn,s,r)}});function ac(e,t=!0,n,s){return Hs.makeVariable(e,t,n,s)}function ic(e,t){const n=[];for(let e=0;e<t.length;e++)t[e]&&n.push(e);const s=Kr(e,"int32"),r=Kr([n.length,e.length],"int32");for(let t=0;t<n.length;t++){const a=s.indexToLoc(n[t]),i=t*e.length;r.values.set(a,i)}return r.toTensor()}const oc=async function(e){const t=er(e,"condition","whereAsync","bool"),n=await t.data(),s=ic(t.shape,n);return e!==t&&t.dispose(),s};const lc=async function(e,t,n){const s=er(e,"tensor","boolMask"),r=er(t,"mask","boolMask","bool"),a=null==n?0:n,i=r.rank,o=s.shape;l(i>0,(()=>"mask cannot be scalar")),u(o.slice(a,a+i),r.shape,"mask's shape must match the first K dimensions of tensor's shape,");let c=1;for(let e=a;e<a+i;e++)c*=o[e];const h=o.slice(0,a).concat([c],o.slice(a+i)),p=Vi(s,h),d=Vi(r,[-1]),f=await oc(d),m=qu(f,[1]),g=Uo(p,m,a);return e!==s&&s.dispose(),t!==r&&r.dispose(),m.dispose(),p.dispose(),d.dispose(),f.dispose(),g};function uc(e,t,n=null){if(0===e.rank)return gi(e);if(1!==e.rank&&null===n)return uc(Vi(e,[-1]),t,n);if(1===e.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===t)return hl(gi(e),n);if(t===1/0)return ul(gi(e),n);if(t===-1/0)return Dl(gi(e),n);if("euclidean"===t||2===t)return Hu(hl(Jl(gi(e),Tu(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}if(Array.isArray(n)&&2===n.length){if(1===t)return ul(hl(gi(e),n[0]),n[1]-1);if(t===1/0)return ul(hl(gi(e),n[1]),n[0]);if(t===-1/0)return Dl(hl(gi(e),n[1]),n[0]);if("fro"===t||"euclidean"===t)return Hu(hl(Ll(e),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const cc=sr({norm_:function(e,t="euclidean",n=null,s=!1){const r=uc(e=er(e,"x","norm"),t,n);let a=r.shape;if(s){const t=x(n,e.shape);a=gl(r.shape,t)}return Vi(r,a)}});const hc=sr({movingAverage_:function(e,t,n,s,r=!0){const a=er(e,"v","movingAverage"),i=er(t,"x","movingAverage"),o=er(n,"decay","movingAverage");Ms(a,i),l(d(a.shape,i.shape),(()=>"Shape mismatch in v and x"));const u=Tu(1),c=cl(u,o);let h=mi(cl(i,a),c);if(r){l(null!=s,(()=>"When using zeroDebias: true, step is required."));const e=er(s,"step","movingAverage");h=fi(h,cl(u,Jl(o,e)))}return pi(a,h)}});const pc=sr({scatterND_:function(e,t,n){const s=er(e,"indices","scatterND","int32"),r=er(t,"updates","scatterND");Sa(r,s,n);const a={indices:s,updates:r},i={shape:n};return Hs.runKernel(fn,a,i)}});const dc=sr({sparseToDense_:function(e,t,n,s=0){const r=er(e,"sparseIndices","sparseToDense","int32"),a=er(t,"sparseValues","sparseToDense"),i=er(s,"defaultValue","sparseToDense",a.dtype);!function(e,t,n,s){if("int32"!==e.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);const r=e.rank>0?e.shape[0]:1,a=e.rank>1?e.shape[1]:1;if(n.length!==a)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${a}.`);const i=t.size;if(0!==t.rank&&(1!==t.rank||i!==r))throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${r}]`);if(t.dtype!==s.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(r,a,n,i);const o={sparseIndices:r,sparseValues:a,defaultValue:i},l={outputShape:n};return Hs.runKernel(An,o,l)}});const fc=sr({gatherND_:function(e,t){const n=er(t,"indices","gatherND","int32"),s={params:er(e,"x","gatherND"),indices:n};return Hs.runKernel(ot,s)}});const mc=sr({dropout_:function(e,t,n,s){const r=er(e,"x","dropout");if(l("float32"===r.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${r.dtype} tensor instead.`)),l(t>=0&&t<1,(()=>`rate must be a float in the range [0, 1), but got ${t}.`)),0===t)return e instanceof Is?r.clone():r;const a=function(e,t){if(null==t)return e.shape.slice();if(d(e.shape,t))return t;if(e.shape.length===t.length){const n=[];for(let s=0;s<e.shape.length;s++)null==t[s]&&null!=e.shape[s]?n.push(e.shape[s]):n.push(t[s]);return n}return t}(r,n),i=1-t,o=fi(Vo(pi(mu(a,0,1,"float32",s),i)),i);return mi(r,o)}});function gc(e){return Math.floor(Math.pow(2,Math.ceil(Math.log(e)/Math.log(2))))}function yc(e,t,n){const s=1-e%2,r=new Float32Array(e);for(let a=0;a<e;++a){const i=2*Math.PI*a/(e+s-1);r[a]=t-n*Math.cos(i)}return Zu(r,"float32")}const bc=async function(e,t,n=1){const s=er(e,"predictions","inTopK"),r=er(t,"targets","inTopK");l(s.rank>1,(()=>`inTopK() expects the predictions to be of rank 2 or higher, but got ${s.rank}`)),l(s.rank-1===r.rank,(()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${s.rank} and targets rank ${r.rank}`)),u(s.shape.slice(0,s.shape.length-1),r.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const a=s.shape[s.shape.length-1];l(n>0&&n<=a,(()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${a}), but got ${n}`));const i=await s.data(),o=await r.data(),[c,h]=[i.length/a,a],p=k("bool",c);for(let e=0;e<c;e++){const t=e*h,s=i.subarray(t,t+h),r=[];for(let e=0;e<s.length;e++)r.push({value:s[e],index:e});r.sort(((e,t)=>t.value-e.value)),p[e]=0;for(let t=0;t<n;t++)if(r[t].index===o[e]){p[e]=1;break}}return e!==s&&s.dispose(),t!==r&&r.dispose(),ir(p,r.shape,"bool")};const xc=sr({conv2DBackpropFilter_:function(e,t,n,s,r,a="NHWC",i){let o=e;3===e.rank&&(o=Vi(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let u=t;3===u.rank&&(u=Vi(t,[1,t.shape[0],t.shape[1],t.shape[2]])),l(4===o.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${o.shape}.`)),l(4===u.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${u.shape}.`)),l(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const c="NHWC"===a?o.shape[3]:o.shape[1],h="NHWC"===a?u.shape[3]:u.shape[1];l(c===n[2],(()=>`Error in conv2dDerFilter: depth of input ${c}) must match input depth in filter (${n[2]}.`)),l(h===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`)),null!=i&&l(f(r),(()=>`Error in conv2dDerFilter: pad must be an integer when using, dimRoundingMode ${i} but got pad ${r}.`));const p={x:o,dy:u},d={strides:s,pad:r,dataFormat:a,dimRoundingMode:i,filterShape:n};return Hs.runKernel(Se,p,d)}});function wc(e,t,n){if(null==n||"linear"===n)return e;if("relu"===n)return mi(e,Xu(t));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function kc(e,t){let n=t;const s=Co(e.shape,t.shape);return s.length>0&&(n=hl(n,s)),Vi(n,e.shape)}function vc(e,t,n,s){if("linear"===t)return e;if("relu"===t)return xu(e);if("elu"===t)return _o(e);if("relu6"===t)return wu(e);if("prelu"===t)return Zl(e,n);if("leakyrelu"===t)return Yo(e,s);if("sigmoid"===t)return ji(e);throw new Error(`Unknown fused activation ${t}.`)}const Nc=(e,t)=>!(e>0)||"linear"===t;const Ic=sr({fusedConv2d_:function({x:e,filter:t,strides:n,pad:s,dataFormat:r="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:o,activation:u="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(u=u||"linear",!1===Nc(Hs.state.gradientDepth,u)){let l=uo(e,t,n,s,r,a,i);return null!=o&&(l=pi(l,o)),vc(l,u,c,h)}const p=er(e,"x","conv2d"),d=er(t,"filter","conv2d");let m=p,g=!1;3===p.rank&&(g=!0,m=Vi(p,[1,p.shape[0],p.shape[1],p.shape[2]])),l(4===m.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${m.rank}.`)),l(4===d.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${d.rank}.`)),null!=i&&l(f(s),(()=>`Error in fused conv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${s}.`)),l(m.shape[3]===d.shape[2],(()=>`Error in conv2d: depth of input (${m.shape[3]}) must match input depth for filter ${d.shape[2]}.`)),l(Pi(n,a),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`)),l("NHWC"===r,(()=>`Error in conv2d: got dataFormat of ${r} but only NHWC is currently supported.`));const y=Fi(m.shape,d.shape,n,a,s,i);let b,x;null!=o&&(b=er(o,"bias","fused conv2d"),[b]=Os(b,p),So(y.outShape,b.shape)),null!=c&&(x=er(c,"prelu weights","fused conv2d"));const w=(e,t)=>{const[r,i,o,c]=t,h=wc(e,o,u);l(Bi(a),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`));const p=[ho(i.shape,h,r,n,s),xc(i,h,r.shape,n,s)];if(null!=c){const e=kc(c,h);p.push(e)}return p},k={x:m,filter:d,bias:b,preluActivationWeights:x},v={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i,activation:u,leakyreluAlpha:h};if(null==o){return rl(((e,t,n)=>{let s=Hs.runKernel(Xn,k,v);return n([t,e,s]),g&&(s=Vi(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}))(m,d)}return rl(((e,t,n,s)=>{let r=Hs.runKernel(Xn,k,v);return s([t,e,r,n]),g&&(r=Vi(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}))(m,d,b)}});const $c=sr({depthwiseConv2dNativeBackpropFilter_:function(e,t,n,s,r,a=[1,1],i){let o=e;3===e.rank&&(o=Vi(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=Vi(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={x:o,dy:l},c={strides:s,pad:r,dimRoundingMode:i,dilations:a,filterShape:n};return Hs.runKernel(Be,u,c)}});const Cc=sr({depthwiseConv2dNativeBackpropInput_:function(e,t,n,s,r,a=[1,1],i){let o=t,l=!1;3===t.rank&&(l=!0,o=Vi(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={dy:o,filter:n},c={strides:s,pad:r,dimRoundingMode:i,dilations:a,inputShape:e},h=Hs.runKernel(Pe,u,c);return l?Vi(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Sc=sr({fusedDepthwiseConv2d_:function({x:e,filter:t,strides:n,pad:s,dataFormat:r="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:o,activation:u="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(!1===Nc(Hs.state.gradientDepth,u)){let l=vo(e,t,n,s,r,a,i);return null!=o&&(l=pi(l,o)),vc(l,u,c,h)}const p=er(e,"x","depthwiseConv2d"),d=er(t,"filter","depthwiseConv2d");let m=p,g=!1;3===p.rank&&(g=!0,m=Vi(p,[1,p.shape[0],p.shape[1],p.shape[2]])),l(4===m.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${m.rank}.`)),l(4===d.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${d.rank}.`)),l(m.shape[3]===d.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${m.shape[3]}) must match the inChannels dimension in filter ${d.shape[2]}.`)),null==a&&(a=[1,1]),l(Pi(n,a),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`)),null!=i&&l(f(s),(()=>`Error in fused depthwiseConv2d: pad must be an integer when using dimRoundingMode ${i} but got pad ${s}.`));const y=Fi(m.shape,d.shape,n,a,s,i,!0);let b,x;null!=o&&(b=er(o,"bias","fused conv2d"),[b]=Os(b,p),So(y.outShape,b.shape)),null!=c&&(x=er(c,"prelu weights","fused depthwiseConv2d"));const w=(e,t)=>{l(Bi(a),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${a}'`));const[r,o,c,h]=t,p=wc(e,c,u),d=Cc(o.shape,p,r,n,s,a,i),f=$c(o,p,r.shape,n,s,a,i);if(null!=h){return[d,f,kc(b,p)]}return[d,f]},k={x:m,filter:d,bias:b,preluActivationWeights:x},v={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i,activation:u,leakyreluAlpha:h};if(null==o){return rl(((e,t,n)=>{let s=Hs.runKernel(Yn,k,v);return n([t,e,s]),g&&(s=Vi(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}))(m,d)}return rl(((e,t,n,s)=>{let r=Hs.runKernel(Yn,k,v);return s([t,e,r,n]),g&&(r=Vi(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}))(m,d,b)}});const Tc=sr({fusedMatMul_:function({a:e,b:t,transposeA:n=!1,transposeB:s=!1,bias:r,activation:a="linear",preluActivationWeights:i,leakyreluAlpha:o}){if(!1===Nc(Hs.state.gradientDepth,a)){let l=da(e,t,n,s);return null!=r&&(l=pi(l,r)),vc(l,a,i,o)}let u=er(e,"a","fused matMul"),c=er(t,"b","fused matMul");[u,c]=Os(u,c);const h=n?u.shape[u.rank-2]:u.shape[u.rank-1],f=s?c.shape[c.rank-1]:c.shape[c.rank-2],m=n?u.shape[u.rank-1]:u.shape[u.rank-2],g=s?c.shape[c.rank-2]:c.shape[c.rank-1],y=u.shape.slice(0,-2),b=c.shape.slice(0,-2),x=p(y),w=p(b);l(u.rank>=2&&c.rank>=2&&u.rank===c.rank,(()=>`Error in fused matMul: inputs must have the same rank of at least 2, got ranks ${u.rank} and ${c.rank}.`)),l(d(y,b),(()=>`Error in fused matMul: outer dimensions (${y}) and (${b}) of Tensors with shapes ${u.shape} and ${c.shape} must match.`)),l(h===f,(()=>`Error in fused matMul: inner shapes (${h}) and (${f}) of Tensors with shapes ${u.shape} and ${c.shape} and transposeA=${n} and transposeB=${s} must match.`));const k=u.shape.slice(0,-2).concat([m,g]),v=Vi(u,n?[x,h,m]:[x,m,h]),N=Vi(c,s?[w,g,f]:[w,f,g]);let I,$;null!=r&&(I=er(r,"bias","fused matMul"),[I]=Os(I,u),So(k,I.shape)),null!=i&&($=er(i,"prelu weights","fused matMul"));const C=(e,t)=>{const[i,o,l,u]=t,c=wc(Vi(e,l.shape),l,a);let h,p;if(n||s?!n&&s?(h=da(c,o,!1,!1),p=da(c,i,!0,!1)):n&&!s?(h=da(o,c,!1,!0),p=da(i,c,!1,!1)):(h=da(o,c,!0,!0),p=da(c,i,!0,!0)):(h=da(c,o,!1,!0),p=da(i,c,!0,!1)),null!=r){return[h,p,kc(u,c)]}return[h,p]},S={a:v,b:N,bias:I,preluActivationWeights:$},T={transposeA:n,transposeB:s,activation:a,leakyreluAlpha:o};if(null==r){return rl(((e,t,n)=>{const s=Hs.runKernel(Kn,S,T);return n([e,t,s]),{value:Vi(s,k),gradFunc:C}}))(v,N)}return rl(((e,t,n,s)=>{const r=Hs.runKernel(Kn,S,T);return s([e,t,r,n]),{value:Vi(r,k),gradFunc:C}}))(v,N,I)}});var Ec=Object.freeze({__proto__:null,conv2d:Ic,depthwiseConv2d:Sc,matMul:Tc});const Ac=sr({hammingWindow_:function(e){return yc(e,.54,.46)}});const Rc=sr({hannWindow_:function(e){return yc(e,.5,.5)}});const Fc=sr({frame_:function(e,t,n,s=!1,r=0){let a=0;const i=[];for(;a+t<=e.size;)i.push(qi(e,a,t)),a+=n;if(s)for(;a<e.size;){const s=a+t-e.size,o=Hi([qi(e,a,t-s),Wo([s],r)]);i.push(o),a+=n}return 0===i.length?Qu([],[0,t]):Vi(Hi(i),[i.length,t])}});const Dc=sr({stft_:function(e,t,n,s,r=Rc){null==s&&(s=gc(t));const a=Fc(e,t,n),i=mi(a,r(t));return Gu(i,s)}});const _c=sr({cropAndResize_:function(e,t,n,s,r="bilinear",a=0){const i=er(e,"image","cropAndResize"),o=er(t,"boxes","cropAndResize","float32"),u=er(n,"boxInd","cropAndResize","int32"),c=o.shape[0];l(4===i.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${i.rank}.`)),l(2===o.rank&&4===o.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${c},4] but had shape ${o.shape}.`)),l(1===u.rank&&u.shape[0]===c,(()=>`Error in cropAndResize: boxInd must be have size [${c}] but had shape ${o.shape}.`)),l(2===s.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${s.length}.`)),l(s[0]>=1&&s[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${s}`)),l("bilinear"===r||"nearest"===r,(()=>`method must be bilinear or nearest, but was ${r}`));const h={image:i,boxes:o,boxInd:u},p={method:r,extrapolationValue:a,cropSize:s};return Hs.runKernel(Oe,h,p)}});const Oc=sr({flipLeftRight_:function(e){const t=er(e,"image","flipLeftRight","float32");l(4===t.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`));const n={image:t};return Hs.runKernel(nt,n,{})}});const Mc=sr({rotateWithOffset_:function(e,t,n=0,s=.5){const r=er(e,"image","rotateWithOffset","float32");l(4===r.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${r.rank}.`));const a={image:r},i={radians:t,fillValue:n,center:s};return Hs.runKernel(qn,a,i)}});function Lc(e,t,n,s,r,a){null==s&&(s=.5),null==r&&(r=Number.NEGATIVE_INFINITY),null==a&&(a=0);const i=e.shape[0];return n=Math.min(n,i),l(0<=s&&s<=1,(()=>`iouThreshold must be in [0, 1], but was '${s}'`)),l(2===e.rank,(()=>`boxes must be a 2D tensor, but was of rank '${e.rank}'`)),l(4===e.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${e.shape[1]}`)),l(1===t.rank,(()=>"scores must be a 1D tensor")),l(t.shape[0]===i,(()=>`scores has incompatible shape with boxes. Expected ${i}, but was ${t.shape[0]}`)),l(0<=a&&a<=1,(()=>`softNmsSigma must be in [0, 1], but was '${a}'`)),{maxOutputSize:n,iouThreshold:s,scoreThreshold:r,softNmsSigma:a}}const zc=sr({nonMaxSuppression_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY){const a=er(e,"boxes","nonMaxSuppression"),i=er(t,"scores","nonMaxSuppression"),o=Lc(a,i,n,s,r),l={maxOutputSize:n=o.maxOutputSize,iouThreshold:s=o.iouThreshold,scoreThreshold:r=o.scoreThreshold};return Hs.runKernel(Gt,{boxes:a,scores:i},l)}});function Bc(e,t,n){const s=function(e,t,n){return function(e,t,n){let s=0,r=e.length,a=0,i=!1;for(;s<r;){a=s+(r-s>>>1);const o=n(t,e[a]);o>0?s=a+1:(r=a,i=!o)}return i?s:-s-1}(e,t,n||Pc)}(e,t,n),r=s<0?-(s+1):s;e.splice(r,0,t)}function Pc(e,t){return e>t?1:e<t?-1:0}function Wc(e,t,n,s,r){return Gc(e,t,n,s,r,0)}function Vc(e,t,n,s,r,a){return Gc(e,t,n,s,r,0,!1,a,!0)}function Uc(e,t,n,s,r,a){return Gc(e,t,n,s,r,a,!0)}function Gc(e,t,n,s,r,a,i=!1,o=!1,l=!1){const u=[];for(let e=0;e<t.length;e++)t[e]>r&&u.push({score:t[e],boxIndex:e,suppressBeginIndex:0});u.sort(qc);const c=a>0?-.5/a:0,h=[],p=[];for(;h.length<n&&u.length>0;){const t=u.pop(),{score:n,boxIndex:a,suppressBeginIndex:i}=t;if(n<r)break;let o=!1;for(let n=h.length-1;n>=i;--n){const i=Hc(e,a,h[n]);if(i>=s){o=!0;break}if(t.score=t.score*jc(s,c,i),t.score<=r)break}t.suppressBeginIndex=h.length,o||(t.score===n?(h.push(a),p.push(t.score)):t.score>r&&Bc(u,t,qc))}const d=h.length,f=n-d;o&&f>0&&(h.push(...new Array(f).fill(0)),p.push(...new Array(f).fill(0)));const m={selectedIndices:h};return i&&(m.selectedScores=p),l&&(m.validOutputs=d),m}function Hc(e,t,n){const s=e.subarray(4*t,4*t+4),r=e.subarray(4*n,4*n+4),a=Math.min(s[0],s[2]),i=Math.min(s[1],s[3]),o=Math.max(s[0],s[2]),l=Math.max(s[1],s[3]),u=Math.min(r[0],r[2]),c=Math.min(r[1],r[3]),h=Math.max(r[0],r[2]),p=Math.max(r[1],r[3]),d=(o-a)*(l-i),f=(h-u)*(p-c);if(d<=0||f<=0)return 0;const m=Math.max(a,u),g=Math.max(i,c),y=Math.min(o,h),b=Math.min(l,p),x=Math.max(y-m,0)*Math.max(b-g,0);return x/(d+f-x)}function jc(e,t,n){const s=Math.exp(t*n*n);return n<=e?s:0}function qc(e,t){return e.score-t.score||e.score===t.score&&t.boxIndex-e.boxIndex}const Kc=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY){const a=er(e,"boxes","nonMaxSuppressionAsync"),i=er(t,"scores","nonMaxSuppressionAsync"),o=Lc(a,i,n,s,r);n=o.maxOutputSize,s=o.iouThreshold,r=o.scoreThreshold;const l=await Promise.all([a.data(),i.data()]),u=l[0],c=l[1],{selectedIndices:h}=Wc(u,c,n,s,r);return a!==e&&a.dispose(),i!==t&&i.dispose(),Zu(h,"int32")};const Xc=sr({nonMaxSuppressionWithScore_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=0){const i=er(e,"boxes","nonMaxSuppression"),o=er(t,"scores","nonMaxSuppression"),l=Lc(i,o,n,s,r,a),u={boxes:i,scores:o},c={maxOutputSize:n=l.maxOutputSize,iouThreshold:s=l.iouThreshold,scoreThreshold:r=l.scoreThreshold,softNmsSigma:a=l.softNmsSigma},h=Hs.runKernel(jt,u,c);return{selectedIndices:h[0],selectedScores:h[1]}}});const Yc=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=0){const i=er(e,"boxes","nonMaxSuppressionAsync"),o=er(t,"scores","nonMaxSuppressionAsync"),l=Lc(i,o,n,s,r,a);n=l.maxOutputSize,s=l.iouThreshold,r=l.scoreThreshold,a=l.softNmsSigma;const u=await Promise.all([i.data(),o.data()]),c=u[0],h=u[1],{selectedIndices:p,selectedScores:d}=Uc(c,h,n,s,r,a);return i!==e&&i.dispose(),o!==t&&o.dispose(),{selectedIndices:Zu(p,"int32"),selectedScores:Zu(d)}};const Jc=sr({nonMaxSuppressionPadded_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=!1){const i=er(e,"boxes","nonMaxSuppression"),o=er(t,"scores","nonMaxSuppression"),l=Lc(i,o,n,s,r,null),u={boxes:i,scores:o},c={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:a},h=Hs.runKernel(Ht,u,c);return{selectedIndices:h[0],validOutputs:h[1]}}});const Zc=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=!1){const i=er(e,"boxes","nonMaxSuppressionAsync"),o=er(t,"scores","nonMaxSuppressionAsync"),l=Lc(i,o,n,s,r,null),u=l.maxOutputSize,c=l.iouThreshold,h=l.scoreThreshold,[p,d]=await Promise.all([i.data(),o.data()]),{selectedIndices:f,validOutputs:m}=Vc(p,d,u,c,h,a);return i!==e&&i.dispose(),o!==t&&o.dispose(),{selectedIndices:Zu(f,"int32"),validOutputs:Tu(m,"int32")}};const Qc=sr({resizeBilinear_:function(e,t,n=!1,s=!1){const r=er(e,"images","resizeBilinear");l(3===r.rank||4===r.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${r.rank}.`)),l(2===t.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${t}.`)),l(!1===s||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let a=r,i=!1;3===r.rank&&(i=!0,a=Vi(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const[]=t,o={images:a},u={alignCorners:n,halfPixelCenters:s,size:t},c=Hs.runKernel(ln,o,u);return i?Vi(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const eh=sr({resizeNearestNeighbor_:function(e,t,n=!1,s=!1){const r=er(e,"images","resizeNearestNeighbor");l(3===r.rank||4===r.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${r.rank}.`)),l(2===t.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${t}.`)),l("float32"===r.dtype||"int32"===r.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),l(!1===s||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let a=r,i=!1;3===r.rank&&(i=!0,a=Vi(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const[]=t,o={images:a},u={alignCorners:n,halfPixelCenters:s,size:t},c=Hs.runKernel(an,o,u);return i?Vi(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const th=sr({threshold_:function(e,t="binary",n=!1,s=.5){const r=er(e,"image","threshold"),a=r.shape[0]*r.shape[1];let i,o,u,c,h=mi(Zu([s]),255);if(l(3===r.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${r.rank}.`)),l(3===r.shape[2]||1===r.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${r.shape[2]}.`)),l("int32"===r.dtype||"float32"===r.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${r.dtype}.`)),l("otsu"===t||"binary"===t,(()=>`Method must be binary or otsu, but was ${t}`)),3===r.shape[2]){[i,o,u]=Uu(r,[1,1,1],-1);const e=mi(i,.2989),t=mi(o,.587),n=mi(u,.114);c=pi(pi(e,t),n)}else c=e;if("otsu"===t){h=function(e,t){let n,s,r,a,i,o,l=Zu([-1]),u=Zu([0]),c=Zu([0]);for(let h=0;h<e.size-1;h++){n=qi(e,0,h+1),s=qi(e,h+1),i=fi(hl(n),t),o=fi(hl(s),t);const p=hl(mi(n,gu(0,n.size)));r=fi(p,hl(n));const d=Wo(s.shape,n.size),f=pi(gu(0,s.size),d),m=mi(s,f);a=fi(hl(m),hl(s));const g=cl(r,a),y=cl(r,a),b=mi(i,o);c=mi(mi(b,g),y);const x=Go(c,u);u=Eo(x,c,u),l=Eo(x,Zu([h]),l)}return l}(to(Xr(Cu(c),"int32"),ir([]),256),a)}const p=n?Zo(c,h):Go(c,h);return Xr(mi(p,255),"int32")}});const nh=sr({transform_:function(e,t,n="nearest",s="constant",r=0,a){const i=er(e,"image","transform","float32"),o=er(t,"transforms","transform","float32");l(4===i.rank,(()=>`Error in transform: image must be rank 4,but got rank ${i.rank}.`)),l(2===o.rank&&(o.shape[0]===i.shape[0]||1===o.shape[0])&&8===o.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),l(null==a||2===a.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${a}.`));const u={image:i,transforms:o},c={interpolation:n,fillMode:s,fillValue:r,outputShape:a};return Hs.runKernel(Bn,u,c)}});const sh=sr({bandPart_:function(e,t,n){l(t%1==0,(()=>`bandPart(): numLower must be an integer, got ${t}.`)),l(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`));const s=er(e,"a","bandPart");l(s.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${s.rank}.`));const r=s.shape,[a,i]=s.shape.slice(-2);if(!(t<=a))throw new Error(`bandPart(): numLower (${t}) must not be greater than the number of rows (${a}).`);if(!(n<=i))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${i}).`);t<0&&(t=a),n<0&&(n=i);const o=Vi(gu(0,a,1,"int32"),[-1,1]),u=gu(0,i,1,"int32"),c=cl(o,u),h=vl(Zo(c,Tu(+t,"int32")),Ho(c,Tu(-n,"int32"))),p=Rl([a,i],s.dtype);return Vi(Ku(rc(Vi(s,[-1,a,i])).map((e=>Eo(h,e,p)))),r)}});const rh=sr({gramSchmidt_:function(e){let t;if(Array.isArray(e)){t=!1,l(null!=e&&e.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=e[0].shape[0];for(let t=1;t<e.length;++t)l(e[t].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[t].shape[0]} vs. ${n})`))}else t=!0,e=Uu(e,e.shape[0],0).map((e=>qu(e,[0])));l(e.length<=e[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`));const n=[],s=e;for(let t=0;t<e.length;++t)n.push(Hs.tidy((()=>{let e=s[t];if(t>0)for(let s=0;s<t;++s){const t=mi(hl(mi(n[s],e)),n[s]);e=cl(e,t)}return fi(e,cc(e,"euclidean"))})));return t?Ku(n,0):n}});function ah(e,t=!1){return Hs.tidy((()=>{l(2===e.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`));const n=e.shape[0],s=e.shape[1];let r=Po(n),a=Yr(e);const i=Qu([[1]],[1,1]);let o=Yr(i);const u=n>=s?s:n;for(let e=0;e<u;++e){const t=a,l=o,u=r;[o,a,r]=Hs.tidy((()=>{const t=qi(a,[e,e],[n-e,1]),l=cc(t),u=qi(a,[e,e],[1,1]),c=Eo(Go(u,0),Qu([[-1]]),Qu([[1]])),h=cl(u,mi(c,l)),p=fi(t,h);o=1===p.shape[0]?Yr(i):Hi([i,qi(p,[1,0],[p.shape[0]-1,p.shape[1]])],0);const d=il(fi(da(c,h),l)),f=qi(a,[e,0],[n-e,s]),m=mi(d,o),g=ma(o);if(0===e)a=cl(f,da(m,da(g,f)));else{const t=cl(f,da(m,da(g,f)));a=Hi([qi(a,[0,0],[e,s]),t],0)}const y=ma(m),b=qi(r,[0,e],[n,r.shape[1]-e]);if(0===e)r=cl(b,da(da(b,o),y));else{const t=cl(b,da(da(b,o),y));r=Hi([qi(r,[0,0],[n,e]),t],1)}return[o,a,r]})),oi([t,l,u])}return!t&&n>s&&(r=qi(r,[0,0],[n,s]),a=qi(a,[0,0],[s,s])),[r,a]}))}const ih=sr({qr_:function(e,t=!1){if(l(e.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${e.rank}`)),2===e.rank)return ah(e,t);{const n=e.shape.slice(0,e.shape.length-2).reduce(((e,t)=>e*t)),s=rc(Vi(e,[n,e.shape[e.shape.length-2],e.shape[e.shape.length-1]]),0),r=[],a=[];s.forEach((e=>{const[n,s]=ah(e,t);r.push(n),a.push(s)}));return[Vi(Ku(r,0),e.shape),Vi(Ku(a,0),e.shape)]}}});var oh;(oh=e.Reduction||(e.Reduction={}))[oh.NONE=0]="NONE",oh[oh.MEAN=1]="MEAN",oh[oh.SUM=2]="SUM",oh[oh.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS";const lh=sr({computeWeightedLoss_:function(t,n,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const r=er(t,"losses","computeWeightedLoss");let a=null;null!=n&&(a=er(n,"weights","computeWeightedLoss"));const i=null==a?r:mi(r,a);if(s===e.Reduction.NONE)return i;if(s===e.Reduction.SUM)return hl(i);if(s===e.Reduction.MEAN){if(null==a)return Al(i);{const e=r.size/a.size,t=fi(hl(i),hl(a));return e>1?fi(t,Tu(e)):t}}if(s===e.Reduction.SUM_BY_NONZERO_WEIGHTS){if(null==a)return fi(hl(i),Tu(r.size));{const e=mi(a,Fl(r.shape)),t=Xr(hl(Wl(e,Tu(0))),"float32");return fi(hl(i),t)}}throw Error(`Unknown reduction: ${s}`)}});const uh=sr({absoluteDifference_:function(t,n,s,r=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=er(t,"labels","absoluteDifference"),i=er(n,"predictions","absoluteDifference");let o=null;null!=s&&(o=er(s,"weights","absoluteDifference")),u(a.shape,i.shape,"Error in absoluteDifference: ");const l=gi(cl(a,i));return lh(l,o,r)}});const ch=sr({cosineDistance_:function(t,n,s,r,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=er(t,"labels","cosineDistance"),o=er(n,"predictions","cosineDistance");let l=null;null!=r&&(l=er(r,"weights","cosineDistance")),u(i.shape,o.shape,"Error in cosineDistance: ");const c=Tu(1),h=cl(c,hl(mi(i,o),s,!0));return lh(h,l,a)}});const hh=sr({hingeLoss_:function(t,n,s,r=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let a=er(t,"labels","hingeLoss");const i=er(n,"predictions","hingeLoss");let o=null;null!=s&&(o=er(s,"weights","hingeLoss")),u(a.shape,i.shape,"Error in hingeLoss: ");const l=Tu(1);a=cl(mi(Tu(2),a),l);const c=xu(cl(l,mi(a,i)));return lh(c,o,r)}});const ph=sr({huberLoss_:function(t,n,s,r=1,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=er(t,"labels","huberLoss"),o=er(n,"predictions","huberLoss");let l=null;null!=s&&(l=er(s,"weights","huberLoss")),u(i.shape,o.shape,"Error in huberLoss: ");const c=Tu(r),h=gi(cl(o,i)),p=_l(h,c),d=cl(h,p),f=pi(mi(Tu(.5),Ll(p)),mi(c,d));return lh(f,l,a)}});const dh=sr({logLoss_:function(t,n,s,r=1e-7,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=er(t,"labels","logLoss"),o=er(n,"predictions","logLoss");let l=null;null!=s&&(l=er(s,"weights","logLoss")),u(i.shape,o.shape,"Error in logLoss: ");const c=Tu(1),h=Tu(r),p=il(mi(i,tl(pi(o,h)))),d=mi(cl(c,i),tl(pi(cl(c,o),h))),f=cl(p,d);return lh(f,l,a)}});const fh=sr({meanSquaredError_:function(t,n,s,r=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=er(t,"labels","meanSquaredError"),i=er(n,"predictions","meanSquaredError");let o=null;null!=s&&(o=er(s,"weights","meanSquaredError")),u(a.shape,i.shape,"Error in meanSquaredError: ");const l=ju(a,i);return lh(l,o,r)}});const mh=sr({sigmoidCrossEntropy_:function(t,n,s,r=0,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let i=er(t,"multiClassLabels","sigmoidCrossEntropy");const o=er(n,"logits","sigmoidCrossEntropy");let l=null;if(null!=s&&(l=er(s,"weights","sigmoidCrossEntropy")),u(i.shape,o.shape,"Error in sigmoidCrossEntropy: "),r>0){const e=Tu(r),t=Tu(1),n=Tu(.5);i=pi(mi(i,cl(t,e)),mi(n,e))}const c=function(e,t){const n=er(e,"labels","sigmoidCrossEntropyWithLogits"),s=er(t,"logits","sigmoidCrossEntropyWithLogits");u(n.shape,s.shape,"Error in sigmoidCrossEntropyWithLogits: ");const r=xu(s),a=mi(s,n),i=nl(Mo(il(gi(s))));return pi(cl(r,a),i)}(i,o);return lh(c,l,a)}});const gh=sr({softmaxCrossEntropy_:function(t,n,s,r=0,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let i=er(t,"onehotLabels","softmaxCrossEntropy");const o=er(n,"logits","softmaxCrossEntropy");let l=null;if(null!=s&&(l=er(s,"weights","softmaxCrossEntropy")),u(i.shape,o.shape,"Error in softmaxCrossEntropy: "),r>0){const e=Tu(r),t=Tu(1),n=Tu(i.shape[1]);i=pi(mi(i,cl(t,e)),fi(e,n))}const c=function(e,t,n=-1){if(-1===n&&(n=t.rank-1),n!==t.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was ${n}`);return rl(((e,t,s)=>{const r=kl(t,[n],!0),a=cl(Xr(t,"float32"),r);s([e,a]);const i=il(mi(a,e));return{value:hl(i,[n]),gradFunc:(e,t)=>{const[s,r]=t,a=gl(e.shape,[n]);return[mi(Vi(e,a),cl(Xr(s,"float32"),Mo(r))),mi(Vi(e,a),cl(Mo(r),Xr(s,"float32")))]}}}))(e,t)}(i,o);return lh(c,l,a)}});const yh=sr({sparseFillEmptyRows_:function(e,t,n,s){const r=er(e,"indices","sparseFillEmptyRows"),a=er(t,"values","sparseFillEmptyRows"),i=er(n,"denseShape","sparseFillEmptyRows"),o=er(s,"defaultValue","sparseFillEmptyRows",a.dtype);if(2!==r.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==a.rank)throw new Error(`Values should be Tensor1D but received shape ${a.shape}`);if(1!==i.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${i.shape}`);if(0!==o.rank)throw new Error(`Default value should be a scalar but received shape ${o.shape}`);const l={indices:r,values:a,denseShape:i,defaultValue:o},u=Hs.runKernel(Tn,l);return{outputIndices:u[0],outputValues:u[1],emptyRowIndicator:u[2],reverseIndexMap:u[3]}}});const bh=sr({sparseReshape_:function(e,t,n){const s=er(e,"inputIndices","sparseReshape"),r=er(t,"inputShape","sparseReshape"),a=er(n,"newShape","sparseReshape");if(2!==s.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==r.rank)throw new Error(`Input shape should be Tensor1D but received shape ${r.shape}`);if(1!==a.rank)throw new Error(`New shape should be Tensor1D but received shape ${a.shape}`);const i={inputIndices:s,inputShape:r,newShape:a},o=Hs.runKernel(En,i);return{outputIndices:o[0],outputShape:o[1]}}}),xh={fft:Pu,ifft:Wu,rfft:Gu,irfft:Vu},wh={hammingWindow:Ac,hannWindow:Rc,frame:Fc,stft:Dc},kh={flipLeftRight:Oc,resizeNearestNeighbor:eh,resizeBilinear:Qc,rotateWithOffset:Mc,cropAndResize:_c,nonMaxSuppression:zc,nonMaxSuppressionAsync:Kc,nonMaxSuppressionWithScore:Xc,nonMaxSuppressionWithScoreAsync:Yc,nonMaxSuppressionPadded:Jc,nonMaxSuppressionPaddedAsync:Zc,threshold:th,transform:nh},vh={bandPart:sh,gramSchmidt:rh,qr:ih},Nh={absoluteDifference:uh,computeWeightedLoss:lh,cosineDistance:ch,hingeLoss:hh,huberLoss:ph,logLoss:dh,meanSquaredError:fh,sigmoidCrossEntropy:mh,softmaxCrossEntropy:gh},Ih={sparseFillEmptyRows:yh,sparseReshape:bh};class $h extends qa{minimize(e,t=!1,n){const{value:s,grads:r}=this.computeGradients(e,n);if(null!=n){const e=n.map((e=>({name:e.name,tensor:r[e.name]})));this.applyGradients(e)}else this.applyGradients(r);return oi(r),t?s:(s.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(e,t){return sl(e,t)}dispose(){null!=this.iterations_&&oi(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:Tu(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(e){throw new Error(`setWeights() is not implemented for this optimizer class ${this.getClassName()}`)}async extractIterations(e){return this.iterations_=(await e[0].tensor.data())[0],e.slice(1)}}Object.defineProperty($h,Symbol.hasInstance,{value:e=>null!=e.minimize&&null!=e.computeGradients&&null!=e.applyGradients});class Ch extends $h{constructor(e,t,n=null){super(),this.learningRate=e,this.rho=t,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=Hs.backend.epsilon())}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=Hs.registeredVariables[t];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:`${t}/accum_grad`,variable:ii((()=>Ao(s).variable(false)))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:`${t}/accum_var`,variable:ii((()=>Ao(s).variable(false)))});const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const a=this.accumulatedGrads[n].variable,i=this.accumulatedUpdates[n].variable;ii((()=>{const e=pi(mi(a,this.rho),mi(Ll(r),1-this.rho)),t=mi(fi(Hu(pi(i,this.epsilon)),Hu(pi(a,this.epsilon))),r),n=pi(mi(i,this.rho),mi(Ll(t),1-this.rho));a.assign(e),i.assign(n);const o=pi(mi(t,-this.learningRate),s);s.assign(o)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(oi(this.accumulatedGrads.map((e=>e.variable))),oi(this.accumulatedUpdates.map((e=>e.variable))))}async getWeights(){const e=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){const t=(e=await this.extractIterations(e)).length/2;this.accumulatedGrads=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedUpdates=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.rho,t.epsilon)}}Ch.className="Adadelta",Xa(Ch);class Sh extends $h{constructor(e,t=.1){super(),this.learningRate=e,this.initialAccumulatorValue=t,this.accumulatedGrads=[]}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=Hs.registeredVariables[t];if(null==this.accumulatedGrads[n]){const e=!1;this.accumulatedGrads[n]={originalName:`${t}/accumulator`,variable:ii((()=>Wo(s.shape,this.initialAccumulatorValue).variable(e)))}}const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const a=this.accumulatedGrads[n].variable;ii((()=>{const e=pi(a,Ll(r));a.assign(e);const t=pi(mi(fi(r,Hu(pi(e,Hs.backend.epsilon()))),-this.learningRate),s);s.assign(t)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&oi(this.accumulatedGrads.map((e=>e.variable)))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulatedGrads=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(e,t){return new e(t.learningRate,t.initialAccumulatorValue)}}Sh.className="Adagrad",Xa(Sh);class Th extends $h{constructor(e,t,n,s=null){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=s,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],ii((()=>{this.accBeta1=Tu(t).variable(),this.accBeta2=Tu(n).variable()})),null==s&&(this.epsilon=Hs.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);ii((()=>{const n=cl(1,this.accBeta1),s=cl(1,this.accBeta2);t.forEach(((t,r)=>{const a=Hs.registeredVariables[t];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${t}/m`,variable:ii((()=>Ao(a).variable(false)))}),null==this.accumulatedSecondMoment[r]&&(this.accumulatedSecondMoment[r]={originalName:`${t}/v`,variable:ii((()=>Ao(a).variable(false)))});const i=Array.isArray(e)?e[r].tensor:e[t];if(null==i)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedSecondMoment[r].variable,u=pi(mi(o,this.beta1),mi(i,1-this.beta1)),c=pi(mi(l,this.beta2),mi(Ll(i),1-this.beta2)),h=fi(u,n),p=fi(c,s);o.assign(u),l.assign(c);const d=pi(mi(fi(h,pi(Hu(p),this.epsilon)),-this.learningRate),a);a.assign(d)})),this.accBeta1.assign(mi(this.accBeta1,this.beta1)),this.accBeta2.assign(mi(this.accBeta2,this.beta2))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&oi(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedSecondMoment&&oi(this.accumulatedSecondMoment.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e),ii((()=>{this.accBeta1.assign(Jl(this.beta1,this.iterations_+1)),this.accBeta2.assign(Jl(this.beta2,this.iterations_+1))}));const t=e.length/2;this.accumulatedFirstMoment=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedSecondMoment=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon)}}Th.className="Adam",Xa(Th);class Eh extends $h{constructor(e,t,n,s=null,r=0){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=s,this.decay=r,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],ii((()=>{this.iteration=Tu(0).variable(),this.accBeta1=Tu(t).variable()})),null==s&&(this.epsilon=Hs.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);ii((()=>{const n=cl(1,this.accBeta1),s=fi(-this.learningRate,pi(mi(this.iteration,this.decay),1));t.forEach(((t,r)=>{const a=Hs.registeredVariables[t];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${t}/m`,variable:Ao(a).variable(false)}),null==this.accumulatedWeightedInfNorm[r]&&(this.accumulatedWeightedInfNorm[r]={originalName:`${t}/v`,variable:Ao(a).variable(false)});const i=Array.isArray(e)?e[r].tensor:e[t];if(null==i)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedWeightedInfNorm[r].variable,u=pi(mi(o,this.beta1),mi(i,1-this.beta1)),c=mi(l,this.beta2),h=gi(i),p=El(c,h);o.assign(u),l.assign(p);const d=pi(mi(fi(s,n),fi(u,pi(p,this.epsilon))),a);a.assign(d)})),this.iteration.assign(pi(this.iteration,1)),this.accBeta1.assign(mi(this.accBeta1,this.beta1))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&oi(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedWeightedInfNorm&&oi(this.accumulatedWeightedInfNorm.map((e=>e.variable)))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon,t.decay)}}Eh.className="Adamax",Xa(Eh);class Ah extends $h{constructor(e){super(),this.learningRate=e,this.setLearningRate(e)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const r=Hs.registeredVariables[t];ii((()=>{const e=pi(mi(this.c,s),r);r.assign(e)}))})),this.incrementIterations()}setLearningRate(e){this.learningRate=e,null!=this.c&&this.c.dispose(),this.c=li(Tu(-e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(e){if(0!==(e=await this.extractIterations(e)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(e,t){return new e(t.learningRate)}}Ah.className="SGD",Xa(Ah);class Rh extends Ah{constructor(e,t,n=!1){super(e),this.learningRate=e,this.momentum=t,this.useNesterov=n,this.accumulations=[],this.m=Tu(this.momentum)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=Hs.registeredVariables[t];if(null==this.accumulations[n]){const e=!1;this.accumulations[n]={originalName:`${t}/momentum`,variable:ii((()=>Ao(s).variable(e)))}}const r=this.accumulations[n].variable,a=Array.isArray(e)?e[n].tensor:e[t];null!=a&&ii((()=>{let e;const t=pi(mi(this.m,r),a);e=this.useNesterov?pi(mi(this.c,pi(a,mi(t,this.m))),s):pi(mi(this.c,t),s),r.assign(t),s.assign(e)}))})),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&oi(this.accumulations.map((e=>e.variable)))}setMomentum(e){this.momentum=e}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulations=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(e,t){return new e(t.learningRate,t.momentum,t.useNesterov)}}Rh.className="Momentum",Xa(Rh);class Fh extends $h{constructor(e,t=.9,n=0,s=null,r=!1){if(super(),this.learningRate=e,this.decay=t,this.momentum=n,this.epsilon=s,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=r,null==s&&(this.epsilon=Hs.backend.epsilon()),null==e)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=Hs.registeredVariables[t],r=!1;null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:`${t}/rms`,variable:ii((()=>Ao(s).variable(r)))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:`${t}/momentum`,variable:ii((()=>Ao(s).variable(r)))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:`${t}/mg`,variable:ii((()=>Ao(s).variable(r)))});const a=Array.isArray(e)?e[n].tensor:e[t];if(null==a)return;const i=this.accumulatedMeanSquares[n].variable,o=this.accumulatedMoments[n].variable;ii((()=>{const e=pi(mi(i,this.decay),mi(Ll(a),1-this.decay));if(this.centered){const t=this.accumulatedMeanGrads[n].variable,r=pi(mi(t,this.decay),mi(a,1-this.decay)),l=fi(mi(a,this.learningRate),Hu(cl(e,pi(Ll(r),this.epsilon)))),u=pi(mi(o,this.momentum),l);i.assign(e),t.assign(r),o.assign(u);const c=cl(s,u);s.assign(c)}else{const e=pi(mi(i,this.decay),mi(Ll(a),1-this.decay)),t=pi(mi(o,this.momentum),fi(mi(a,this.learningRate),Hu(pi(e,this.epsilon))));i.assign(e),o.assign(t);const n=cl(s,t);s.assign(n)}}))})),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&oi(this.accumulatedMeanSquares.map((e=>e.variable))),null!=this.accumulatedMeanGrads&&this.centered&&oi(this.accumulatedMeanGrads.map((e=>e.variable))),null!=this.accumulatedMoments&&oi(this.accumulatedMoments.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&e.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);const t=this.centered?e.length/3:e.length/2,n=!1;this.accumulatedMeanSquares=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.accumulatedMoments=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.centered&&(this.accumulatedMeanGrads=e.slice(2*t,3*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(e,t){return new e(t.learningRate,t.decay,t.momentum,t.epsilon,t.centered)}}Fh.className="RMSProp",Xa(Fh);class Dh{static sgd(e){return new Ah(e)}static momentum(e,t,n=!1){return new Rh(e,t,n)}static rmsprop(e,t=.9,n=0,s=null,r=!1){return new Fh(e,t,n,s,r)}static adam(e=.001,t=.9,n=.999,s=null){return new Th(e,t,n,s)}static adadelta(e=.001,t=.95,n=null){return new Ch(e,t,n)}static adamax(e=.002,t=.9,n=.999,s=null,r=0){return new Eh(e,t,n,s,r)}static adagrad(e,t=.1){return new Sh(e,t)}}const _h={sgd:Dh.sgd,momentum:Dh.momentum,adadelta:Dh.adadelta,adagrad:Dh.adagrad,rmsprop:Dh.rmsprop,adamax:Dh.adamax,adam:Dh.adam},Oh="undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate?setImmediate:e=>e();function Mh(){return new Promise((e=>Oh((()=>e()))))}function Lh(e,t){const n=e[0].length;e.forEach(((e,t)=>{l(e.length===n,(()=>`Error in concat${n}D: rank of tensors[${t}] must be the same as the rank of the rest (${n})`))})),l(t>=0&&t<n,(()=>`Error in concat${n}D: axis must be between 0 and ${n-1}.`));const s=e[0];e.forEach(((e,r)=>{for(let a=0;a<n;a++)l(a===t||e[a]===s[a],(()=>`Error in concat${n}D: Shape of tensors[${r}] (${e}) does not match the shape of the rest (${s}) along the non-concatenated axis ${r}.`))}))}function zh(e,t){const n=e[0].slice();for(let s=1;s<e.length;s++)n[t]+=e[s][t];return n}function Bh(e){return e<=30?e:_(e,Math.floor(Math.sqrt(e)))}function Ph(e,t,n){return[n*("number"==typeof e?e:e[0]),t*("number"==typeof e?e:e[1])]}function Wh(e,t,n,s=!0){let r=[];if(s)r=r.concat(t.slice(0)),r.push(e[0]/n),r=r.concat(e.slice(1));else{r=r.concat(e[0]);const n=t.length;for(let s=0;s<n;++s)r=r.concat([e[s+1]/t[s],t[s]]);r=r.concat(e.slice(n+1))}return r}function Vh(e,t,n=!0){const s=[];if(n){s.push(t);for(let n=t+1;n<e;++n)n<=2*t?(s.push(n),s.push(n-(t+1))):s.push(n)}else{const n=[],r=[];for(let s=1;s<e;++s)s>=2*t+1||s%2==1?r.push(s):n.push(s);s.push(...n),s.push(0),s.push(...r)}return s}function Uh(e,t,n,s=!0){const r=[];s?r.push(e[0]/n):r.push(e[0]*n);for(let n=1;n<e.length;++n)n<=t.length?s?r.push(t[n-1]*e[n]):r.push(e[n]/t[n-1]):r.push(e[n]);return r}function Gh(e,t){const n=[0];for(let s=0;s<t;++s)n.push(e[s][0]);return n}function Hh(e,t,n){const s=e.slice(0,1);for(let r=0;r<n;++r)s.push(e[r+1]-t[r][0]-t[r][1]);return s}const jh=1.7580993408473768,qh=1.0507009873554805,Kh=.3275911,Xh=.254829592,Yh=-.284496736,Jh=1.421413741,Zh=-1.453152027,Qh=1.061405429;function ep(...e){K().getBool("IS_TEST")||console.warn(...e)}function tp(e,t){if(e.length!==t.length)throw new Error(`Cannot merge real and imag arrays of different lengths. real:${e.length}, imag: ${t.length}.`);const n=new Float32Array(2*e.length);for(let s=0;s<n.length;s+=2)n[s]=e[s/2],n[s+1]=t[s/2];return n}function np(e){const t=new Float32Array(e.length/2),n=new Float32Array(e.length/2);for(let s=0;s<e.length;s+=2)t[s/2]=e[s],n[s/2]=e[s+1];return{real:t,imag:n}}function sp(e){const t=Math.ceil(e.length/4),n=new Float32Array(t),s=new Float32Array(t);for(let t=0;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],s[Math.floor(t/4)]=e[t+1];return{real:n,imag:s}}function rp(e){const t=Math.floor(e.length/4),n=new Float32Array(t),s=new Float32Array(t);for(let t=2;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],s[Math.floor(t/4)]=e[t+1];return{real:n,imag:s}}function ap(e,t){return{real:e[2*t],imag:e[2*t+1]}}function ip(e,t,n,s){e[2*s]=t,e[2*s+1]=n}function op(e,t){const n=new Float32Array(e/2),s=new Float32Array(e/2);for(let r=0;r<Math.ceil(e/2);r++){const a=(t?2:-2)*Math.PI*(r/e);n[r]=Math.cos(a),s[r]=Math.sin(a)}return{real:n,imag:s}}function lp(e,t,n){const s=(n?2:-2)*Math.PI*(e/t);return{real:Math.cos(s),imag:Math.sin(s)}}const up="->",cp=/->/g;function hp(e,t){const n=((e=e.replace(/\s/g,"")).length-e.replace(cp,"").length)/up.length;if(n<1)throw new Error("Equations without an arrow are not supported.");if(n>1)throw new Error('Equation must contain exactly one arrow ("->").');const[s,r]=e.split(up);l(-1===s.indexOf("..."),(()=>'The ellipsis notation ("...") is not supported yet.'));const a=s.split(","),i=a.length;if(t!==i)throw new Error(`Expected ${i} input tensors, received ${t}`);if(i>2)throw new Error("Support for more than 2 input tensors is not implemented yet.");const o=[];for(let e=0;e<r.length;++e){const t=r[e];if(!a.some((e=>-1!==e.indexOf(t))))throw new Error(`Output subscripts contain the label ${t} not present in the input subscripts.`);-1===o.indexOf(t)&&o.push(t)}for(let e=0;e<s.length;++e){const t=s[e];-1===o.indexOf(t)&&","!==t&&o.push(t)}const u=new Array(a.length);for(let e=0;e<i;++e){if(new Set(a[e].split("")).size!==a[e].length)throw new Error(`Found duplicate axes in input component ${a[e]}. Support for duplicate axes in input is not implemented yet.`);u[e]=[];for(let t=0;t<a[e].length;++t)u[e].push(o.indexOf(a[e][t]))}const c=o.length,h=[];for(let e=r.length;e<c;++e)h.push(e);return{allDims:o,summedDims:h,idDims:u}}function pp(e,t){let n=new Array(e);n.fill(-1);for(let e=0;e<t.length;++e)n[t[e]]=e;const s=[];for(let t=0;t<e;++t)-1===n[t]&&s.push(t);return n=n.filter((e=>-1!==e)),{permutationIndices:n,expandDims:s}}function dp(e,t,n){const s=new Array(e);for(let e=0;e<n.length;++e){const r=n[e].shape;for(let n=0;n<t[e].length;++n)void 0===s[t[e][n]]?s[t[e][n]]=r[n]:l(s[t[e][n]]===r[n],(()=>`Expected dimension ${s[t[e][n]]} at axis ${n} of input shaped ${JSON.stringify(r)}, but got dimension ${r[n]}`))}}function fp(e,t){const n=e,s=[];let r=0;0===e.length&&n.push(-1),r=e.length+1;for(let e=0;e<r;++e)s.push([]);const a=[];for(let e=0;e<n.length;++e){const r=gp(t,n[e]);for(const t of r)-1===a.indexOf(t)&&(s[e].push(t),a.push(t))}return{path:n,steps:s}}function mp(e){return e.every(((e,t)=>e===t))}function gp(e,t){const n=[];for(let s=0;s<e.length;++s)0!==e[s].length&&-1===e[s].indexOf(t)&&-1!==t||n.push(s);return n}function yp(e,t,n=0){let s=[];if("number"==typeof t)l(e.shape[n]%t==0,(()=>"Number of splits must evenly divide the axis.")),s=new Array(t).fill(e.shape[n]/t);else{l(t.reduce(((e,t)=>(-1===t&&(e+=1),e)),0)<=1,(()=>"There should be only one negative value in split array."));const r=t.indexOf(-1);if(-1!==r){const s=t.reduce(((e,t)=>t>0?e+t:e));t[r]=e.shape[n]-s}l(e.shape[n]===t.reduce(((e,t)=>e+t)),(()=>"The sum of sizes must match the size of the axis dimension.")),s=t}return s}function bp(e,t){let n,s=!1;for(e<=30?(n=e,s=!0):n=_(e,Math.floor(Math.sqrt(e)));!s;)n>t||n===e?s=!0:n=_(e,n+1);return n}function xp(e,t,n){const s=[],r=e.length;for(let a=0;a<r;a++)a!==t?s.push(e[a]):s.push(n);return s}function wp(e,t,n,s){const r=t.shape.length,a=e.shape.length;if(0!==s&&(s<-r||s>r))throw new Error(`Expect batchDims in the range of [-${r}, ${r}], but got ${s}`);if(s<0&&(s+=r),s>a)throw new Error(`batchDims (${s}) must be less than rank(x) (\n    ${a}).`);if(n<s)throw new Error(`batchDims (${s}) must be less than or equal to axis (${n}).`);for(let n=0;n<s;++n)if(e.shape[n]!==t.shape[n])throw new Error(`x.shape[${n}]: ${e.shape[n]} should be equal to indices.shape[${n}]: ${t.shape[n]}.`);const i=e.shape[n],o=[];let l=1,u=1,c=1;for(let t=0;t<s;++t)o.push(e.shape[t]),l*=e.shape[t];for(let t=s;t<n;t++)o.push(e.shape[t]),u*=e.shape[t];for(let e=s;e<r;e++)o.push(t.shape[e]);for(let t=n+1;t<a;t++)o.push(e.shape[t]),c*=e.shape[t];return{batchSize:l,sliceSize:c,outerSize:u,dimSize:i,outputShape:o}}var kp=Object.freeze({__proto__:null,segOpComputeOptimalWindowSize:bp,computeOutShape:xp,collectGatherOpShapeInfo:wp});function vp(e){try{return e.map((e=>cs(e)))}catch(e){throw new Error(`Failed to decode encoded string bytes into utf-8, error: ${e}`)}}function Np(e){return e.map((e=>us(e)))}var Ip=Object.freeze({__proto__:null,slice_util:ja,segment_util:kp,fromUint8ToStringArray:vp,fromStringArrayToUint8:Np,upcastType:Ds,axesAreInnerMostDims:dl,combineLocations:fl,computeOutAndReduceShapes:ml,expandShapeToKeepDim:gl,assertAxesAreInnerMostDims:yl,getAxesPermutation:bl,getUndoAxesPermutation:xl,getInnerMostAxes:wl,getBroadcastDims:$o,getReductionAxes:Co,assertAndGetBroadcastShape:So,assertParamsConsistent:Lh,computeOutShape:zh,computeDilation2DInfo:Ei,computePool2DInfo:Ai,computePool3DInfo:Ri,computeConv2DInfo:Fi,computeConv3DInfo:Di,computeDefaultPad:_i,tupleValuesAreOne:Bi,eitherStridesOrDilationsAreOne:Pi,convertConv2DDataFormat:Wi,getFusedDyActivation:wc,getFusedBiasGradient:kc,applyActivation:vc,shouldFuse:Nc,PARALLELIZE_THRESHOLD:30,computeOptimalWindowSize:Bh,getImageCenter:Ph,getReshaped:Wh,getPermuted:Vh,getReshapedPermuted:Uh,getSliceBeginCoords:Gh,getSliceSize:Hh,prepareAndValidate:Ia,validateUpdateShape:Ca,validateInput:Sa,calculateShapes:Ta,SELU_SCALEALPHA:jh,SELU_SCALE:qh,ERF_P:Kh,ERF_A1:Xh,ERF_A2:Yh,ERF_A3:Jh,ERF_A4:Zh,ERF_A5:Qh,warn:ep,log:function(...e){K().getBool("IS_TEST")||console.log(...e)},mergeRealAndImagArrays:tp,splitRealAndImagArrays:np,complexWithEvenIndex:sp,complexWithOddIndex:rp,getComplexWithIndex:ap,assignToTypedArray:ip,exponents:op,exponent:lp,decodeEinsumEquation:hp,getEinsumPermutation:pp,checkEinsumDimSizes:dp,getEinsumComputePath:fp,isIdentityPermutation:mp,prepareSplitSize:yp}),$p=Object.freeze({__proto__:null,nonMaxSuppressionV3Impl:Wc,nonMaxSuppressionV4Impl:Vc,nonMaxSuppressionV5Impl:Uc,whereImpl:ic});const Cp={kernelName:Z,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>mi(e,Xu(Xr(n,"float32"),-1))}}},Sp={kernelName:Q,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Ll(Xr(n,"float32")),s=Hu(cl(Tu(1),t));return il(fi(e,s))}}}},Tp={kernelName:ee,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Hu(cl(Ll(Xr(n,"float32")),1));return fi(e,t)}}}},Ep={kernelName:te,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{let t=e;const s=Co(n.shape,r);return s.length>0&&(t=hl(t,s)),Vi(t,n.shape)},b:()=>{let t=e;const n=Co(s.shape,r);return n.length>0&&(t=hl(t,n)),Vi(t,s.shape)}}}},Ap={kernelName:ne,saveAllInputs:!0,gradFunc:(e,t)=>{const n={};return t.forEach(((t,s)=>{n[s]=()=>e.clone()})),n}},Rp={kernelName:ae,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Ao(n)}}},Fp={kernelName:ie,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Ao(n)}}},Dp={kernelName:oe,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,Hu(cl(Tu(1),Ll(Xr(n,"float32")))))}}},_p={kernelName:le,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Hu(pi(Tu(1),Ll(Xr(n,"float32"))));return fi(e,t)}}}},Op={kernelName:he,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{const t=pi(Ll(n),Ll(s));let a=mi(e,fi(s,t));const i=Co(n.shape,r);return i.length>0&&(a=hl(a,i)),Vi(a,n.shape)},b:()=>{const t=pi(Ll(n),Ll(s));let a=il(mi(e,fi(n,t)));const i=Co(s.shape,r);return i.length>0&&(a=hl(a,i)),Vi(a,s.shape)}}}},Mp={kernelName:ue,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,pi(Ll(Xr(n,"float32")),1))}}},Lp={kernelName:ce,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,cl(Tu(1),Ll(Xr(n,"float32"))))}}};const zp=sr({avgPool3dGrad_:function(e,t,n,s,r,a){const i=er(e,"dy","avgPool3dGrad"),o=er(t,"input","avgPool3dGrad");let u=i,c=o,h=!1;4===o.rank&&(h=!0,u=Vi(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]]),c=Vi(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),l(5===u.rank,(()=>`Error in avgPool3dGrad: dy must be rank 5 but got rank ${u.rank}.`)),l(5===c.rank,(()=>`Error in avgPool3dGrad: input must be rank 5 but got rank ${c.rank}.`)),null!=a&&l(f(r),(()=>`Error in avgPool3dGrad: pad must be an integer when using, dimRoundingMode ${a} but got pad ${r}.`));const p={dy:u,input:c},d={filterSize:n,strides:s,pad:r,dimRoundingMode:a},m=Hs.runKernel(me,p,d);return h?Vi(m,[m.shape[1],m.shape[2],m.shape[3],m.shape[4]]):m}}),Bp={kernelName:fe,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{filterSize:r,strides:a,pad:i,dimRoundingMode:o}=n;return{x:()=>zp(e,s,r,a,i,o)}}};const Pp=sr({avgPoolGrad_:function(e,t,n,s,r){const a=er(e,"dy","avgPoolGrad"),i=er(t,"input","avgPoolGrad");l(i.rank===a.rank,(()=>`Rank of input (${i.rank}) does not match rank of dy (${a.rank})`));let o=i,u=a,c=!1;3===i.rank&&(c=!0,o=Vi(i,[1,i.shape[0],i.shape[1],i.shape[2]]),u=Vi(a,[1,a.shape[0],a.shape[1],a.shape[2]])),l(4===u.rank,(()=>`Error in avgPoolGrad: dy must be rank 4 but got rank ${u.rank}.`)),l(4===o.rank,(()=>`Error in avgPoolGrad: input must be rank 4 but got rank ${o.rank}.`));const h={dy:u,input:o},p={filterSize:n,strides:s,pad:r},d=Hs.runKernel(de,h,p);return c?Vi(d,[d.shape[1],d.shape[2],d.shape[3]]):d}}),Wp={kernelName:pe,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{filterSize:r,strides:a,pad:i}=n;return{x:()=>Pp(e,s,r,a,i)}}},Vp={kernelName:ge,inputsToSave:["a","b"],gradFunc:(e,t,n)=>{const[s,r]=t,{transposeA:a,transposeB:i}=n;return a||i?!a&&i?{a:()=>da(e,r,!1,!1),b:()=>da(e,s,!0,!1)}:a&&!i?{a:()=>da(r,e,!1,!0),b:()=>da(s,e,!1,!1)}:{a:()=>da(r,e,!0,!0),b:()=>da(e,s,!0,!0)}:{a:()=>da(e,r,!1,!0),b:()=>da(s,e,!0,!1)}}},Up={kernelName:ye,gradFunc:(e,t,n)=>{const{blockShape:s,crops:r}=n;return{x:()=>Xl(e,s,r)}}},Gp={kernelName:xe,gradFunc:(e,t,n)=>{const s=n,r=s.inputShape,a=s.shape,i=Array.from(a);for(let e=r.length-1;e>=0;e--)if(r[e]===a[e])i[e]=1;else if(1!==r[e])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${a}].`);const o=[];for(let e=0;e<i.length;e++)i[e]>1&&o.push(e);return{x:()=>hl(e,o,!0)}}},Hp={kernelName:we,gradFunc:e=>({x:()=>e.clone()})},jp={kernelName:ke,gradFunc:e=>({x:()=>Ao(e)})},qp={kernelName:ve,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{clipValueMin:r,clipValueMax:a}=n;return{x:()=>Eo(vl(Ho(s,r),Zo(s,a)),e,Ao(e))}}},Kp={kernelName:Ie,inputsToSave:["x"],gradFunc:Cp.gradFunc},Xp={kernelName:$e,saveAllInputs:!0,gradFunc:(e,t,n)=>{const s=t.map((e=>e.shape)),{axis:r}=n,a=x(r,t[0].shape)[0],i=s.map((e=>e[a]));return Uu(e,i,a).map((e=>()=>e))}},Yp={kernelName:Ce,inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,{dilations:a,strides:i,pad:o,dataFormat:u}=n;return l(Bi(a),(()=>`Error in gradient of conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`)),{x:()=>ho(s.shape,e,r,i,o,u),filter:()=>xc(s,e,r.shape,i,o,u)}}},Jp={kernelName:Te,inputsToSave:["dy","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,{strides:a,pad:i,dataFormat:o,dimRoundingMode:l}=n;return{dy:()=>uo(e,r,a,i,o,1,l),filter:()=>xc(e,s,r.shape,a,i,o,l)}}};const Zp=sr({conv3DBackpropFilter_:function(e,t,n,s,r){let a=e;4===e.rank&&(a=Vi(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]]));let i=t;4===i.rank&&(i=Vi(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]])),l(5===a.rank,(()=>`Error in conv3dDerFilter: input must be rank 5, but got shape ${a.shape}.`)),l(5===i.rank,(()=>`Error in conv3dDerFilter: dy must be rank 5, but got shape ${i.shape}.`)),l(5===n.length,(()=>`Error in conv3dDerFilter: filterShape must be length 5, but got ${n}.`)),l(a.shape[4]===n[3],(()=>`Error in conv3dDerFilter: depth of input ${a.shape[4]}) must match input depth in filter (${n[3]}.`)),l(i.shape[4]===n[4],(()=>`Error in conv3dDerFilter: depth of dy (${i.shape[4]}) must match output depth for filter (${n[4]}).`));const o={x:a,dy:i},u={strides:s,pad:r,filterShape:n};return Hs.runKernel(Ae,o,u)}}),Qp={kernelName:Ee,inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const{dilations:s,strides:r,pad:a}=n;l(Bi(s),(()=>`Error in gradient of conv3D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${s}'`));const[i,o]=t;return{x:()=>mo(i.shape,e,o,r,a),filter:()=>Zp(i,e,o.shape,r,a)}}},ed={kernelName:Fe,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>mi(il(Du(Xr(n,"float32"))),e)}}},td={kernelName:De,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>mi(_u(Xr(n,"float32")),e)}}},nd={kernelName:_e,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{axis:r,exclusive:a,reverse:i}=n;return{x:()=>{const t=bl([r],s.rank);let n=xo(e,r,a,!i);return null!=t&&(n=ma(n,t)),n}}}},sd={kernelName:ze,inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const{dilations:s,strides:r,pad:a,dimRoundingMode:i}=n,o=null==s?[1,1]:s;l(Bi(o),(()=>`Error in gradient of depthwiseConv2dNative: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`));const[u,c]=t;return l(4===u.rank,(()=>`Error in gradient of depthwiseConv2dNative: input must be rank 4, but got rank ${u.rank}.`)),l(4===c.rank,(()=>`Error in gradient of depthwiseConv2dNative: filter must be rank 4, but got rank ${c.rank}.`)),l(u.shape[3]===c.shape[2],(()=>`Error in gradient of depthwiseConv2d: number of input channels (${u.shape[3]}) must match the inChannels dimension in filter ${c.shape[2]}.`)),l(Pi(r,o),(()=>`Error in gradient of depthwiseConv2d: Either strides or dilations must be  1. Got strides ${r} and dilations '${o}'.`)),null!=i&&l(f(a),(()=>`Error in depthwiseConv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`)),{x:()=>Cc(u.shape,e,c,r,a,s,i),filter:()=>$c(u,e,c.shape,r,a,s,i)}}},rd={kernelName:Ve,inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,a={x:s,filter:r,dy:e},i={x:s,filter:r,dy:e};return{x:()=>Hs.runKernel(Ue,a,n),filter:()=>Hs.runKernel(Ge,i,n)}}},ad={kernelName:qe,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t,s={dy:e,y:n};return{x:()=>Hs.runKernel(Ke,s)}}},id={kernelName:Xe,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t,s=mi(Mo(il(Ll(n))),2/Math.sqrt(Math.PI));return{x:()=>mi(e,s)}}},od={kernelName:Je,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>mi(e,n)}}},ld={kernelName:Ze,inputsToSave:["input"],gradFunc:(e,t)=>{const[n]=t;return{input:()=>Vi(e,n.shape)}}},ud={kernelName:Qe,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>mi(e,Mo(n))}}},cd={kernelName:st,gradFunc:e=>({x:()=>Ao(e)})},hd={kernelName:rt,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{const t=fi(e,Xr(s,"float32")),a=Co(n.shape,r);return a.length>0?Vi(hl(t,a),n.shape):t},b:()=>{let t=mi(e,Xr(n,"float32"));const a=Co(s.shape,r);a.length>0&&(t=Vi(hl(t,a),s.shape));const i=Ll(s);return il(fi(t,Xr(i,"float32")))}}}},pd={kernelName:at,inputsToSave:["x","mean","variance","scale"],gradFunc:(e,t,n)=>{const{varianceEpsilon:s}=n,[r,a,i,o]=t,l=null==o?Tu(1):o,u=Co(a.shape,r.shape),c=[];if(1===a.rank){for(let e=0;e<r.shape.length-1;++e)c.push(r.shape[e]);c.push(1)}const h=cl(r,a),p=mi(e,l),d=Su(pi(i,Tu(s))),f=mi(mi(mi(d,d),d),Tu(-.5));return{x:()=>1===a.rank?Vi(mi(mi(e,Bo(Vi(d,[1,1,1,a.shape[0]]),c)),l),r.shape):Vi(mi(mi(e,d),l),r.shape),mean:()=>{let e=mi(mi(d,Tu(-1)),p);return 1===a.rank&&(e=hl(e,u)),Vi(e,a.shape)},variance:()=>{let e=mi(mi(f,h),p);return 1===a.rank&&(e=hl(e,u)),Vi(e,a.shape)},scale:()=>{const t=mi(h,d);let n=mi(e,t);return 1===a.rank&&(n=hl(n,u)),Vi(n,a.shape)},offset:()=>{let t=e;return 1===a.rank&&(t=hl(t,u)),Vi(t,a.shape)}}}},dd={kernelName:it,inputsToSave:["x","indices"],gradFunc:(e,t,n)=>{const[s,r]=t,{axis:a}=n,i=x(a,s.shape)[0];return{x:()=>{const t=s.shape,n=r.size,o=t.slice(0,i),l=o.length,u=t.slice(a,t.length).slice(1),c=u.length,h=fd(0,l),p=fd(l+1,l+1+c),d=md([o,[n],u]),f=Vi(e,d),m=Vi(r,[n]),g=md([[l],h,p]),y=ma(f,g);let b=sc(y,m,s.shape[i]);const x=xl(g);return b=ma(b,x),b},indices:()=>r}}};function fd(e,t){const n=[];for(let s=e;s<t;++s)n.push(s);return n}function md(e){const t=[];for(let n=0;n<e.length;++n)for(let s=0;s<e[n].length;++s)t.push(e[n][s]);return t}const gd={kernelName:ut,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>Ao(n),b:()=>Ao(s)}}},yd={kernelName:ct,gradFunc:e=>({x:()=>Xr(e,"float32")})},bd={kernelName:dt,gradFunc:e=>({x:()=>Ao(e)})},xd={kernelName:ft,gradFunc:e=>({x:()=>Ao(e)})},wd={kernelName:mt,gradFunc:e=>({x:()=>Ao(e)})},kd={kernelName:gt,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{alpha:r}=n,a=Go(s,0);return{x:()=>Eo(a,e,mi(e,r))}}},vd={kernelName:kt,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,pi(n,1))}}},Nd={kernelName:wt,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,Xr(n,"float32"))}}},Id={kernelName:$t,inputsToSave:[],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s]=t,{axis:r}=n;return{logits:()=>{const t=Mo(s);return cl(e,mi(hl(e,r,!0),t))}}}};const $d=sr({localResponseNormalizationBackprop_:function(e,t,n,s=5,r=1,a=1,i=.5){const o={x:e,y:t,dy:n},l={depthRadius:s,bias:r,alpha:a,beta:i};return Hs.runKernel(St,o,l)}}),Cd={kernelName:Ct,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{depthRadius:a,bias:i,alpha:o,beta:l}=n;return{x:()=>$d(s,r,e,a,i,o,l)}}};function Sd(e,t,n,s){return t.rank<n.rank&&(t=Vi(t,gl(t.shape,s))),e.rank<n.rank&&(e=Vi(e,gl(e.shape,s))),{x:()=>mi(e,Xr(To(n,t),e.dtype))}}const Td={kernelName:Tt,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const s=n,{reductionIndices:r}=s,a=t[0],i=Sd(e,t[1],a,x(r,a.shape));return{x:()=>i.x()}}},Ed={kernelName:Et,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>mi(e,Xr(Ho(n,s),"float32")),b:()=>mi(e,Xr(Jo(n,s),"float32"))}}};const Ad=sr({maxPool3dGrad_:function(e,t,n,s,r,a,i){const o=er(e,"dy","maxPool3dGrad"),u=er(t,"input","maxPool3dGrad"),c=er(n,"output","maxPool3dGrad");let h=o,p=u,d=c,m=!1;4===u.rank&&(m=!0,h=Vi(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]]),p=Vi(u,[1,u.shape[0],u.shape[1],u.shape[2],u.shape[3]]),d=Vi(c,[1,c.shape[0],c.shape[1],c.shape[2],c.shape[3]])),l(5===h.rank,(()=>`Error in maxPool3dGrad: dy must be rank 5 but got rank ${h.rank}.`)),l(5===p.rank,(()=>`Error in maxPool3dGrad: input must be rank 5 but got rank ${p.rank}.`)),l(5===d.rank,(()=>`Error in maxPool3dGrad: output must be rank 5 but got rank ${d.rank}.`)),null!=i&&l(f(a),(()=>`Error in maxPool3dGrad: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`));const g={dy:h,input:p,output:d},y={filterSize:s,strides:r,pad:a,dimRoundingMode:i},b=Hs.runKernel(Dt,g,y);return m?Vi(b,[b.shape[1],b.shape[2],b.shape[3],b.shape[4]]):b}}),Rd={kernelName:Ft,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l}=n;return{x:()=>Ad(e,s,r,a,i,o,l)}}};const Fd=sr({maxPoolGrad_:function(e,t,n,s,r,a,i){const o=er(e,"dy","maxPoolGrad"),u=er(t,"input","maxPoolGrad"),c=er(n,"output","maxPoolGrad");l(u.rank===o.rank,(()=>`Rank of input (${u.rank}) does not match rank of dy (${o.rank})`)),l(4===o.rank,(()=>`Error in maxPoolGrad: dy must be rank 4 but got rank ${o.rank}.`)),l(4===u.rank,(()=>`Error in maxPoolGrad: input must be rank 4 but got rank ${u.rank}.`)),null!=i&&l(f(a),(()=>`Error in maxPoolGrad: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`));const h={dy:o,input:u,output:c},p={filterSize:s,strides:r,pad:a,dimRoundingMode:i};return Hs.runKernel(Rt,h,p)}}),Dd={kernelName:Yt,inputsToSave:["x"],gradFunc:(e,t,n)=>{const s=t[0],{paddings:r}=n,a=r.map((e=>e[0]));return{x:()=>qi(e,a,s.shape)}}},_d={kernelName:$n,gradFunc:(e,t,n)=>{const{blockShape:s,paddings:r}=n;return{x:()=>Yi(e,s,r)}}},Od={kernelName:Cn,gradFunc:(e,t,n)=>{const{axis:s}=n;return{x:()=>Hi(e,s)}}};const Md=[Cp,Sp,Tp,Ep,Ap,Rp,Fp,Dp,_p,Op,Mp,Lp,Bp,Wp,Vp,Up,Gp,Hp,jp,qp,Kp,Xp,Jp,Yp,Qp,ed,td,nd,sd,rd,{kernelName:He,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{const t=fi(e,Xr(s,"float32")),a=Co(n.shape,r);return a.length>0?Vi(hl(t,a),n.shape):t},b:()=>{let t=mi(e,Xr(n,"float32"));const a=Co(s.shape,r);a.length>0&&(t=Vi(hl(t,a),s.shape));const i=Ll(s);return il(fi(t,Xr(i,"float32")))}}}},ad,id,od,ld,ud,hd,cd,pd,dd,gd,yd,bd,xd,wd,kd,vd,Nd,Id,Cd,Td,Td,Ed,Rd,{kernelName:At,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{filterSize:a,strides:i,pad:o}=n;return{x:()=>Fd(e,s,r,a,i,o)}}},{kernelName:Ot,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{axis:r}=n,a=x(r,s.shape),i=p(ml(s.shape,a)[1]);return{x:()=>{const t=s.shape.slice();a.forEach((e=>{t[e]=1}));const n=Vi(e,t);return fi(mi(n,Fl(s.shape,"float32")),i)}}}},{kernelName:Mt,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const s=n,{axis:r}=s,[a,i]=t,o=Sd(e,i,a,x(r,a.shape));return{x:()=>o.x()}}},{kernelName:Lt,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>mi(e,Xr(Zo(n,s),"float32")),b:()=>mi(e,Xr(Go(n,s),"float32"))}}},{kernelName:zt,inputsToSave:["x"],gradFunc:(e,t,n)=>{const s=t[0],{paddings:r}=n,a=r.map((e=>e[0]));return{x:()=>qi(e,a,s.shape)}}},{kernelName:Bt,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{const t=Co(n.shape,r);return t.length>0?Vi(hl(e,t),n.shape):e},b:()=>{const t=mi(e,il(Vo(fi(n,s)))),a=Co(s.shape,r);return a.length>0?Vi(hl(t,a),s.shape):t}}}},{kernelName:Wt,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{const t=mi(e,Xr(s,"float32")),a=Co(n.shape,r);return a.length>0?Vi(hl(t,a),n.shape):t},b:()=>{const t=mi(e,Xr(n,"float32")),a=Co(s.shape,r);return a.length>0?Vi(hl(t,a),s.shape):t}}}},{kernelName:Vt,gradFunc:e=>({x:()=>il(e)})},{kernelName:Kt,inputsToSave:["indices"],gradFunc:(e,t)=>{const n=t[0];return{indices:()=>Rl(n.shape,"float32")}}},{kernelName:qt,gradFunc:e=>({x:()=>Ao(e)})},{kernelName:Xt,saveAllInputs:!0,gradFunc:(e,t,n)=>{const{axis:s}=n;return rc(e,s).map((e=>()=>e))}},Dd,Dd,{kernelName:Jt,inputsToSave:["a","b"],outputsToSave:[!0],gradFunc:(e,t)=>{const[n,s,r]=t,a=n,i=s,o=So(a.shape,i.shape);return{a:()=>{const t=Xr(i,"float32");let n=mi(e,mi(t,Jl(a,cl(t,Tu(1)))));const s=Co(a.shape,o);return s.length>0&&(n=hl(n,s)),Vi(n,a.shape)},b:()=>{const t=Go(a,0),n=Eo(t,tl(a),Ao(a));let s=mi(e,mi(r,n));const l=Co(i.shape,o);return l.length>0&&(s=hl(s,l)),Vi(s,i.shape)}}}},{kernelName:Zt,inputsToSave:["x","alpha"],gradFunc:(e,t)=>{const[n,s]=t,r=Go(n,0);return{x:()=>Eo(r,e,mi(e,s)),alpha:()=>{let t=Eo(r,Ao(e),mi(e,n));const a=Co(s.shape,e.shape);return a.length>0&&(t=hl(t,a)),Vi(t,s.shape)}}}},{kernelName:nn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,il(Ll(n)))}}},{kernelName:cn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t,s=mi(Zo(n,6),Xu(n));return{x:()=>mi(e,Xr(s,"float32"))}}},{kernelName:sn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>mi(e,Xr(Xu(n),"float32"))}}},{kernelName:rn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Vi(e,n.shape)}}},{kernelName:ln,inputsToSave:["images"],gradFunc:(e,t,n)=>{const[s]=t,r={dy:e,images:s};return{images:()=>Hs.runKernel(un,r,n)}}},{kernelName:an,inputsToSave:["images"],gradFunc:(e,t,n)=>{const[s]=t,r={dy:e,images:s};return{images:()=>Hs.runKernel(on,r,n)}}},{kernelName:hn,gradFunc:(e,t,n)=>{const{dims:s}=n,r=x(s,e.shape);return{x:()=>ku(e,r)}}},{kernelName:pn,gradFunc:e=>({x:()=>Ao(e)})},{kernelName:dn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>il(fi(e,mi(Jl(n,1.5),2)))}}},{kernelName:mn,inputsToSave:["condition"],gradFunc:(e,t)=>{const[n]=t;return{condition:()=>Xr(Ao(n),"float32"),t:()=>mi(e,Xr(n,e.dtype)),e:()=>mi(e,Xr(Nl(n),e.dtype))}}},{kernelName:gn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Go(n,Tu(0)),s=Tu(jh),r=Tu(qh),a=mi(e,r),i=mi(mi(e,s),Mo(Xr(n,"float32")));return Eo(t,a,i)}}}},{kernelName:kn,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>mi(e,mi(n,cl(Tu(1),n)))}}},{kernelName:wn,gradFunc:e=>({x:()=>Ao(e)})},{kernelName:bn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>mi(yo(Xr(n,"float32")),e)}}},{kernelName:xn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>mi(bo(Xr(n,"float32")),e)}}},{kernelName:yn,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{begin:r,size:a}=n,i=s.shape,[o,l]=Ga(s,r,a),u=[];for(let t=0;t<e.rank;t++)u.push([o[t],i[t]-o[t]-l[t]]);return{x:()=>Gl(e,u)}}},{kernelName:Sn,outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s]=t,{dim:r}=n,a=mi(e,s);return{logits:()=>cl(a,mi(hl(a,[r],true),s))}}},{kernelName:vn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>mi(e,ji(n))}}},_d,_d,Od,Od,{kernelName:Nn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,mi(Hu(Xr(n,"float32")),2))}}},{kernelName:Rn,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=Tu(2);return{a:()=>mi(e,mi(r,cl(n,s))),b:()=>mi(e,mi(r,cl(s,n)))}}},{kernelName:Fn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>mi(e,mi(Xr(n,"float32"),2))}}},{kernelName:Hn,gradFunc:e=>({x:()=>Ao(e)})},{kernelName:_n,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=So(n.shape,s.shape);return{a:()=>{let t=e;const s=Co(n.shape,r);return s.length>0&&(t=hl(t,s)),Vi(t,n.shape)},b:()=>{let t=e;const n=Co(s.shape,r);return n.length>0&&(t=hl(t,n)),Vi(il(t),s.shape)}}}},{kernelName:In,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,r=s.shape.slice(),{axis:a}=n;x(a,s.shape).forEach((e=>{r[e]=1}));const i=Vi(e,r),o=mi(i,Fl(s.shape,"float32"));return{x:()=>o}}},{kernelName:On,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>fi(e,Ll(yo(n)))}}},{kernelName:Mn,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>mi(cl(Tu(1),Ll(n)),e)}}},{kernelName:Ln,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{reps:r}=n;return{x:()=>{let t=Ao(s);if(1===s.rank)for(let n=0;n<r[0];++n)t=pi(t,qi(e,[n*s.shape[0]],[s.shape[0]]));else if(2===s.rank)for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)t=pi(t,qi(e,[n*s.shape[0],a*s.shape[1]],[s.shape[0],s.shape[1]]));else if(3===s.rank)for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)for(let i=0;i<r[2];++i)t=pi(t,qi(e,[n*s.shape[0],a*s.shape[1],i*s.shape[2]],[s.shape[0],s.shape[1],s.shape[2]]));else{if(4!==s.rank)throw new Error(`Gradient for tile operation is not implemented for rank-${s.rank} tensors yet.`);for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)for(let i=0;i<r[2];++i)for(let o=0;o<r[3];++o)t=pi(t,qi(e,[n*s.shape[0],a*s.shape[1],i*s.shape[2],o*s.shape[3]],[s.shape[0],s.shape[1],s.shape[2],s.shape[3]]))}return t}}}},{kernelName:Pn,gradFunc:(e,t,n)=>{const s=n,{perm:r}=s,a=xl(r);return{x:()=>ma(e,a)}}},{kernelName:Vn,gradFunc:(e,t,n)=>{const s=n,{axis:r}=s;return{value:()=>Ku(e,r)}}},{kernelName:Un,inputsToSave:["segmentIds"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>function(e,t){const n=El(t,Ao(t)),s=Uo(e,n);let r=Ho(t,Tu(0,"int32"));const a=s.rank-r.rank;for(let e=0;e<a;++e)r=Lo(r,e+1);r=vl(r,Fl(s.shape,"bool"));const i=Ao(s);return Eo(r,s,i)}(e,n)}}},{kernelName:Gn,gradFunc:e=>({x:()=>Ao(e)})}];for(const e of Md)ss(e);let Ld;function zd(){return null==Ld&&(Ld=hi().epsilon()),Ld}$s().prototype.abs=function(){return this.throwIfDisposed(),gi(this)},$s().prototype.acos=function(){return this.throwIfDisposed(),yi(this)},$s().prototype.acosh=function(){return this.throwIfDisposed(),bi(this)},$s().prototype.add=function(e){return this.throwIfDisposed(),pi(this,e)},$s().prototype.all=function(e,t){return this.throwIfDisposed(),wi(this,e,t)},$s().prototype.any=function(e,t){return this.throwIfDisposed(),ki(this,e,t)},$s().prototype.argMax=function(e){return this.throwIfDisposed(),vi(this,e)},$s().prototype.argMin=function(e){return this.throwIfDisposed(),Ni(this,e)},$s().prototype.asScalar=function(){return this.throwIfDisposed(),l(1===this.size,(()=>"The array must have only 1 element.")),Vi(this,[])},$s().prototype.asType=function(e){return this.throwIfDisposed(),Xr(this,e)},$s().prototype.as1D=function(){return this.throwIfDisposed(),Vi(this,[this.size])},$s().prototype.as2D=function(e,t){return this.throwIfDisposed(),Vi(this,[e,t])},$s().prototype.as3D=function(e,t,n){return this.throwIfDisposed(),Vi(this,[e,t,n])},$s().prototype.as4D=function(e,t,n,s){return this.throwIfDisposed(),Vi(this,[e,t,n,s])},$s().prototype.as5D=function(e,t,n,s,r){return this.throwIfDisposed(),Vi(this,[e,t,n,s,r])},$s().prototype.asin=function(){return this.throwIfDisposed(),Ii(this)},$s().prototype.asinh=function(){return this.throwIfDisposed(),$i(this)},$s().prototype.atan=function(){return this.throwIfDisposed(),Ci(this)},$s().prototype.atan2=function(e){return this.throwIfDisposed(),Si(this,e)},$s().prototype.atanh=function(){return this.throwIfDisposed(),Ti(this)},$s().prototype.avgPool=function(e,t,n,s){return this.throwIfDisposed(),Ui(this,e,t,n,s)},$s().prototype.batchToSpaceND=function(e,t){return this.throwIfDisposed(),Yi(this,e,t)},$s().prototype.batchNorm=function(e,t,n,s,r){return this.throwIfDisposed(),Ji(this,e,t,n,s,r)},$s().prototype.broadcastTo=function(e){return this.throwIfDisposed(),no(this,e)},$s().prototype.cast=function(e){return this.throwIfDisposed(),Xr(this,e)},$s().prototype.ceil=function(){return this.throwIfDisposed(),so(this)},$s().prototype.clipByValue=function(e,t){return this.throwIfDisposed(),ro(this,e,t)},$s().prototype.concat=function(e,t){return this.throwIfDisposed(),e instanceof Is&&(e=[e]),Hi([this,...e],t)},$s().prototype.conv1d=function(e,t,n,s,r,a){return this.throwIfDisposed(),co(this,e,t,n,s,r,a)},$s().prototype.conv2dTranspose=function(e,t,n,s,r){return this.throwIfDisposed(),po(this,e,t,n,s,r)},$s().prototype.conv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),uo(this,e,t,n,s,r,a)},$s().prototype.cos=function(){return this.throwIfDisposed(),yo(this)},$s().prototype.cosh=function(){return this.throwIfDisposed(),bo(this)},$s().prototype.cumsum=function(e,t,n){return this.throwIfDisposed(),xo(this,e,t,n)},$s().prototype.depthToSpace=function(e,t){return this.throwIfDisposed(),ko(this,e,t)},$s().prototype.depthwiseConv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),vo(this,e,t,n,s,r,a)},$s().prototype.dilation2d=function(e,t,n,s,r){return this.throwIfDisposed(),Io(this,e,t,n,s,r)},$s().prototype.divNoNan=function(e){return this.throwIfDisposed(),Ro(this,e)},$s().prototype.div=function(e){return this.throwIfDisposed(),fi(this,e)},$s().prototype.dot=function(e){return this.throwIfDisposed(),Fo(this,e)},$s().prototype.elu=function(){return this.throwIfDisposed(),_o(this)},$s().prototype.equal=function(e){return this.throwIfDisposed(),To(this,e)},$s().prototype.erf=function(){return this.throwIfDisposed(),Oo(this)},$s().prototype.exp=function(){return this.throwIfDisposed(),Mo(this)},$s().prototype.expandDims=function(e){return this.throwIfDisposed(),Lo(this,e)},$s().prototype.expm1=function(){return this.throwIfDisposed(),zo(this)},$s().prototype.fft=function(){return this.throwIfDisposed(),Pu(this)},$s().prototype.flatten=function(){return this.throwIfDisposed(),Vi(this,[this.size])},$s().prototype.floor=function(){return this.throwIfDisposed(),Vo(this)},$s().prototype.floorDiv=function(e){return this.throwIfDisposed(),di(this,e)},$s().prototype.gather=function(e,t){return this.throwIfDisposed(),Uo(this,e,t)},$s().prototype.greaterEqual=function(e){return this.throwIfDisposed(),Ho(this,e)},$s().prototype.greater=function(e){return this.throwIfDisposed(),Go(this,e)},$s().prototype.ifft=function(){return this.throwIfDisposed(),Wu(this)},$s().prototype.irfft=function(){return this.throwIfDisposed(),Vu(this)},$s().prototype.isFinite=function(){return this.throwIfDisposed(),qo(this)},$s().prototype.isInf=function(){return this.throwIfDisposed(),Ko(this)},$s().prototype.isNaN=function(){return this.throwIfDisposed(),Xo(this)},$s().prototype.leakyRelu=function(e){return this.throwIfDisposed(),Yo(this,e)},$s().prototype.lessEqual=function(e){return this.throwIfDisposed(),Zo(this,e)},$s().prototype.less=function(e){return this.throwIfDisposed(),Jo(this,e)},$s().prototype.localResponseNormalization=function(e,t,n,s){return this.throwIfDisposed(),el(this,e,t,n,s)},$s().prototype.logSigmoid=function(){return this.throwIfDisposed(),ll(this)},$s().prototype.logSoftmax=function(e){return this.throwIfDisposed(),pl(this,e)},$s().prototype.logSumExp=function(e,t){return this.throwIfDisposed(),kl(this,e,t)},$s().prototype.log=function(){return this.throwIfDisposed(),tl(this)},$s().prototype.log1p=function(){return this.throwIfDisposed(),nl(this)},$s().prototype.logicalAnd=function(e){return this.throwIfDisposed(),vl(this,e)},$s().prototype.logicalNot=function(){return this.throwIfDisposed(),Nl(this)},$s().prototype.logicalOr=function(e){return this.throwIfDisposed(),Il(this,e)},$s().prototype.logicalXor=function(e){return this.throwIfDisposed(),$l(this,e)},$s().prototype.matMul=function(e,t,n){return this.throwIfDisposed(),da(this,e,t,n)},$s().prototype.maxPool=function(e,t,n,s){return this.throwIfDisposed(),Cl(this,e,t,n,s)},$s().prototype.max=function(e,t){return this.throwIfDisposed(),ul(this,e,t)},$s().prototype.maximum=function(e){return this.throwIfDisposed(),El(this,e)},$s().prototype.mean=function(e,t){return this.throwIfDisposed(),Al(this,e,t)},$s().prototype.min=function(e,t){return this.throwIfDisposed(),Dl(this,e,t)},$s().prototype.minimum=function(e){return this.throwIfDisposed(),_l(this,e)},$s().prototype.mirrorPad=function(e,t){return this.throwIfDisposed(),Ol(this,e,t)},$s().prototype.mod=function(e){return this.throwIfDisposed(),Ml(this,e)},$s().prototype.mul=function(e){return this.throwIfDisposed(),mi(this,e)},$s().prototype.neg=function(){return this.throwIfDisposed(),il(this)},$s().prototype.norm=function(e,t,n){return this.throwIfDisposed(),cc(this,e,t,n)},$s().prototype.notEqual=function(e){return this.throwIfDisposed(),Wl(this,e)},$s().prototype.oneHot=function(e,t=1,n=0){return this.throwIfDisposed(),fa(this,e,t,n)},$s().prototype.onesLike=function(){return this.throwIfDisposed(),Vl(this)},$s().prototype.pad=function(e,t){return this.throwIfDisposed(),Gl(this,e,t)},$s().prototype.pool=function(e,t,n,s,r){return this.throwIfDisposed(),Yl(this,e,t,n,s,r)},$s().prototype.pow=function(e){return this.throwIfDisposed(),Jl(this,e)},$s().prototype.prelu=function(e){return this.throwIfDisposed(),Zl(this,e)},$s().prototype.prod=function(e,t){return this.throwIfDisposed(),Ql(this,e,t)},$s().prototype.reciprocal=function(){return this.throwIfDisposed(),bu(this)},$s().prototype.relu=function(){return this.throwIfDisposed(),xu(this)},$s().prototype.relu6=function(){return this.throwIfDisposed(),wu(this)},$s().prototype.reshapeAs=function(e){return this.throwIfDisposed(),Vi(this,e.shape)},$s().prototype.reshape=function(e){return this.throwIfDisposed(),Vi(this,e)},$s().prototype.resizeBilinear=function(e,t,n){return this.throwIfDisposed(),Qc(this,e,t,n)},$s().prototype.resizeNearestNeighbor=function(e,t,n){return this.throwIfDisposed(),eh(this,e,t,n)},$s().prototype.reverse=function(e){return this.throwIfDisposed(),ku(this,e)},$s().prototype.rfft=function(){return this.throwIfDisposed(),Gu(this)},$s().prototype.round=function(){return this.throwIfDisposed(),Cu(this)},$s().prototype.rsqrt=function(){return this.throwIfDisposed(),Su(this)},$s().prototype.selu=function(){return this.throwIfDisposed(),Eu(this)},$s().prototype.separableConv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),Au(this,e,t,n,s,r,a)},$s().prototype.sigmoid=function(){return this.throwIfDisposed(),ji(this)},$s().prototype.sign=function(){return this.throwIfDisposed(),Fu(this)},$s().prototype.sin=function(){return this.throwIfDisposed(),Du(this)},$s().prototype.sinh=function(){return this.throwIfDisposed(),_u(this)},$s().prototype.slice=function(e,t){return this.throwIfDisposed(),qi(this,e,t)},$s().prototype.softmax=function(e){return this.throwIfDisposed(),Bu(this,e)},$s().prototype.softplus=function(){return this.throwIfDisposed(),ol(this)},$s().prototype.spaceToBatchND=function(e,t){return this.throwIfDisposed(),Xl(this,e,t)},$s().prototype.split=function(e,t){return this.throwIfDisposed(),Uu(this,e,t)},$s().prototype.sqrt=function(){return this.throwIfDisposed(),Hu(this)},$s().prototype.square=function(){return this.throwIfDisposed(),Ll(this)},$s().prototype.squaredDifference=function(e){return this.throwIfDisposed(),ju(this,e)},$s().prototype.squeeze=function(e){return this.throwIfDisposed(),qu(this,e)},$s().prototype.stack=function(e,t){this.throwIfDisposed();const n=e instanceof Is?[this,e]:[this,...e];return Ku(n,t)},$s().prototype.step=function(e){return this.throwIfDisposed(),Xu(this,e)},$s().prototype.stridedSlice=function(e,t,n,s,r,a,i,o){return this.throwIfDisposed(),Yu(this,e,t,n,s,r,a,i,o)},$s().prototype.sub=function(e){return this.throwIfDisposed(),cl(this,e)},$s().prototype.sum=function(e,t){return this.throwIfDisposed(),hl(this,e,t)},$s().prototype.tan=function(){return this.throwIfDisposed(),Ju(this)},$s().prototype.tanh=function(){return this.throwIfDisposed(),Ki(this)},$s().prototype.tile=function(e){return this.throwIfDisposed(),Bo(this,e)},$s().prototype.toBool=function(){return this.throwIfDisposed(),Xr(this,"bool")},$s().prototype.toFloat=function(){return this.throwIfDisposed(),Xr(this,"float32")},$s().prototype.toInt=function(){return this.throwIfDisposed(),Xr(this,"int32")},$s().prototype.topk=function(e,t){return this.throwIfDisposed(),ec(this,e,t)},$s().prototype.transpose=function(e){return this.throwIfDisposed(),ma(this,e)},$s().prototype.unique=function(e){return this.throwIfDisposed(),nc(this,e)},$s().prototype.unsortedSegmentSum=function(e,t){return this.throwIfDisposed(),sc(this,e,t)},$s().prototype.unstack=function(e){return this.throwIfDisposed(),rc(this,e)},$s().prototype.where=function(e,t){return this.throwIfDisposed(),Eo(e,this,t)},$s().prototype.zerosLike=function(){return this.throwIfDisposed(),Ao(this)};class Bd extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Bd.prototype)}}class Pd extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Pd.prototype)}}class Wd extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Wd.prototype)}}class Vd extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Vd.prototype)}}class Ud extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Ud.prototype)}}Error;function Gd(e,t){if(Array.isArray(e)){let n=[];for(let s=0;s<t;s++)n=n.concat(e);return n}{const n=new Array(t);return n.fill(e),n}}function Hd(e,t){if(!e)throw new Ud(t)}function jd(e,t){let n=0;for(const s of e)s===t&&n++;return n}function qd(e){return 1===e.length?e[0]:e}function Kd(e){return Array.isArray(e)?e:[e]}function Xd(e){const t=e.replace(/(.)([A-Z][a-z0-9]+)/g,"$1_$2").replace(/([a-z])([A-Z])/g,"$1_$2").toLowerCase();return"_"!==t[0]?t:"private"+t}function Yd(e){return e.length<=1||-1===e.indexOf("_")?e:e.replace(/[_]+(\w|$)/g,((e,t)=>t.toUpperCase()))}let Jd={};function Zd(e){if(null==e)return null;const t={};return t.className=e.getClassName(),t.config=e.getConfig(),t}function Qd(e){if(null!=e&&"object"==typeof e)if(Array.isArray(e))e.forEach((e=>Qd(e)));else{const t=Object.keys(e);for(const n of t){const t=e[n];null!=t&&"object"==typeof t&&(Array.isArray(t)||"ndarray"!==t.type||"number"!=typeof t.value?Qd(t):e[n]=t.value)}}}function ef(e,t={},n={},s="object",r=!1){if("string"==typeof e){const r=e;let a;if(r in n)a=n[r];else if(r in Jd)a=Jd[r];else if(a=t[r],null==a)throw new Wd(`Unknown ${s}: ${e}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);return a}{const a=e;if(null==a.className||null==a.config)throw new Wd(`${s}: Improper config format: ${JSON.stringify(a)}.\n'className' and 'config' must set.`);const i=a.className;let o,l;if(i in n?[o,l]=n[i]:i in Jd?[o,l]=Jd.className:i in t&&([o,l]=t[i]),null==o)throw new Wd(`Unknown ${s}: ${i}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);if(null!=l){const e={};for(const t of Object.keys(Jd))e[t]=Jd[t];for(const t of Object.keys(n))e[t]=n[t];a.config.customObjects=e;const t=Object.assign({},Jd);for(const e of Object.keys(n))Jd[e]=n[e];Qd(a.config);const s=l(o,a.config,n,r);return Jd=Object.assign({},t),s}{const e=Object.assign({},Jd);for(const e of Object.keys(n))Jd[e]=n[e];const t=new o(a.config);return Jd=Object.assign({},e),t}}}function tf(e,t){return-1*function(e,t){return e<t?-1:e>t?1:0}(e,t)}function nf(e){if(null==e)return e;const t=[];for(const n of e)-1===t.indexOf(n)&&t.push(n);return t}function sf(e){if(null==e)throw new Wd(`Invalid value in obj: ${JSON.stringify(e)}`);for(const t in e)if(e.hasOwnProperty(t))return!1;return!0}function rf(e,t,n){if(null!=n&&e.indexOf(n)<0)throw new Wd(`${n} is not a valid ${t}.  Valid values are ${e} or null/undefined.`)}function af(e,t,n=0,s=1/0){return Hd(n>=0),Hd(s>=n),Array.isArray(e)&&e.length>=n&&e.length<=s&&e.every((e=>typeof e===t))}function of(e,t){Array.isArray(e)?(l(e.length>0,(()=>`${t} is unexpectedly an empty array.`)),e.forEach(((e,n)=>of(e,`element ${n+1} of ${t}`)))):l(Number.isInteger(e)&&e>0,(()=>`Expected ${t} to be a positive integer, but got ${lf(e)}.`))}function lf(e){return null===e?"null":Array.isArray(e)?"["+e.map((e=>lf(e))).join(",")+"]":"string"==typeof e?`"${e}"`:`${e}`}function uf(e){return"relu"===e?"relu":"linear"===e?"linear":"elu"===e?"elu":null}function cf(e,t){return ii((()=>Hu(hl(mi(e,e),t,!0))))}class hf extends qa{getConfig(){return{}}}class pf extends hf{constructor(e){super(),this.defaultMaxValue=2,this.defaultAxis=0,this.maxValue=null!=e.maxValue?e.maxValue:this.defaultMaxValue,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return ii((()=>{const t=cf(e,this.axis),n=ro(t,0,this.maxValue);return mi(e,fi(n,pi(zd(),t)))}))}getConfig(){return{maxValue:this.maxValue,axis:this.axis}}}pf.className="MaxNorm",Xa(pf);class df extends hf{constructor(e){super(),this.defaultAxis=0,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return ii((()=>fi(e,pi(zd(),cf(e,this.axis)))))}getConfig(){return{axis:this.axis}}}df.className="UnitNorm",Xa(df);class ff extends hf{apply(e){return xu(e)}}ff.className="NonNeg",Xa(ff);class mf extends hf{constructor(e){super(),this.defaultMinValue=0,this.defaultMaxValue=1,this.defaultRate=1,this.defaultAxis=0,this.minValue=null!=e.minValue?e.minValue:this.defaultMinValue,this.maxValue=null!=e.maxValue?e.maxValue:this.defaultMaxValue,this.rate=null!=e.rate?e.rate:this.defaultRate,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return ii((()=>{const t=cf(e,this.axis),n=pi(mi(this.rate,ro(t,this.minValue,this.maxValue)),mi(1-this.rate,t));return mi(e,fi(n,pi(zd(),t)))}))}getConfig(){return{minValue:this.minValue,maxValue:this.maxValue,rate:this.rate,axis:this.axis}}}mf.className="MinMaxNorm",Xa(mf);const gf={maxNorm:"MaxNorm",minMaxNorm:"MinMaxNorm",nonNeg:"NonNeg",unitNorm:"UnitNorm"};function yf(e){return Zd(e)}function bf(e,t={}){return ef(e,Ka.getMap().classNameMap,t,"constraint")}function xf(e){if(null==e)return null;if("string"==typeof e){return bf({className:e in gf?gf[e]:e,config:{}})}return e instanceof hf?e:bf(e)}var wf=Object.freeze({__proto__:null,maxNorm:function(e){return new pf(e)},unitNorm:function(e){return new df(e)},nonNeg:function(){return new ff},minMaxNorm:function(e){return new mf(e)}});const kf=["channelsFirst","channelsLast"],vf=["nearest","bilinear"],Nf=["valid","same","causal"],If=["max","avg"],$f=["sum","mul","concat","ave"],Cf=new Map;function Sf(e){rf(kf,"DataFormat",e)}function Tf(e){rf(Nf,"PaddingMode",e)}function Ef(e){rf(If,"PoolMode",e)}const Af=[];function Rf(e,t){Af.push(e);try{const e=t();return Af.pop(),e}catch(e){throw Af.pop(),e}}function Ff(e){if(!Of(e))throw new Error("Not a valid tensor name: '"+e+"'");return(0===Af.length?"":Af.join("/")+"/")+e}function Df(e){if(!Of(e))throw new Error("Not a valid tensor name: '"+e+"'");Cf.has(e)||Cf.set(e,0);const t=Cf.get(e);if(Cf.set(e,Cf.get(e)+1),t>0){const n=`${e}_${t}`;return Cf.set(n,1),n}return e}const _f=new RegExp(/^[A-Za-z0-9][-A-Za-z0-9\._\/]*$/);function Of(e){return!!e.match(_f)}function Mf(e,t,n){null==t&&(t=0),null==n&&(n=e.length);let s=1;for(let r=t;r<n;++r)s*=e[r];return s}function Lf(e){return Zu(e=Array.isArray(e)?new Float32Array(e):e)}function zf(e){return Dl(Lf(e)).dataSync()[0]}function Bf(e){return ul(Lf(e)).dataSync()[0]}function Pf(e,t){if(t<e)throw new Wd(`end (${t}) < begin (${e}) is forbidden.`);const n=[];for(let s=e;s<t;++s)n.push(s);return n}function Wf(e,t){return e.asType(t)}function Vf(e,t=-1){const n=e.shape.slice();return t<0&&(t=n.length+t+1),n.splice(t,0,1),e.reshape(n)}function Uf(e,t,n){return ii((()=>{switch(e.rank){case 1:return Ou(e,t,n);case 2:return Mu(e,[t,0],[n,e.shape[1]]);case 3:return Lu(e,[t,0,0],[n,e.shape[1],e.shape[2]]);case 4:return zu(e,[t,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3]]);case 5:return qi(e,[t,0,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3],e.shape[4]]);case 6:return qi(e,[t,0,0,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3],e.shape[4],e.shape[5]]);default:throw new Wd(`sliceAlongFirstAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function Gf(e,t,n){return ii((()=>{switch(e.rank){case 1:return Ou(e,t,n);case 2:return Mu(e,[0,t],[e.shape[0],n]);case 3:return Lu(e,[0,0,t],[e.shape[0],e.shape[1],n]);case 4:return zu(e,[0,0,0,t],[e.shape[0],e.shape[1],e.shape[2],n]);default:throw new Wd(`sliceAlongLastAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function Hf(e,t,n,s){return ii((()=>{switch(e.rank){case 1:return Ou(e,t,n);case 2:switch(s){case 1:return Uf(e,t,n);case 2:return Gf(e,t,n);default:throw new Wd(`The axis is not within the rank of the tensor ${s}`)}case 3:switch(s){case 1:return Uf(e,t,n);case 2:return Lu(e,[0,t,0],[e.shape[0],n,e.shape[2]]);case 3:return Gf(e,t,n);default:throw new Wd(`The axis is not within the rank of the tensor ${s}`)}case 4:switch(s){case 1:return Uf(e,t,n);case 2:return zu(e,[0,t,0,0],[e.shape[0],n,e.shape[2],e.shape[3]]);case 3:return zu(e,[0,0,t,0],[e.shape[0],e.shape[1],n,e.shape[3]]);case 4:return Gf(e,t,n);default:throw new Wd(`The axis is not within the rank of the tensor ${s}`)}default:throw new Wd(`sliceAlongLastAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function jf(e,t=-1){let n;return t<0&&(n=e[0].rank,t=0!==n?n:0),t===e[0].rank&&(t=-1),Hi(e,t)}function qf(e,t){switch(e.rank){case 1:return ao([e,t]);case 2:return io([e,t],0);case 3:return oo([e,t],0);case 4:return lo([e,t],0);default:throw new Wd(`concatAlongFirstAxis() received an unsupported tensor rank: ${e.rank}`)}}function Kf(e,t){if(Array.isArray(t)||(t=[t]),e.rank!==t.length)throw new Wd(`The length of input n (${t.length}) does not match the number of dimensions in input x (${e.rank})`);return Bo(e,t)}function Xf(e,t=0,n=1,s,r){return fu(e,t,n,s,r)}function Yf(e,t,n,s){if(e.rank<2||t.rank<2)throw new Vd(`dot requires both inputs to be rank >= 2 but got x shape = ${e.shape} and y shape = ${t.shape}`);if(t.rank>=3){if(e.shape.slice(-1)[0]!==t.shape.slice(-2)[0])throw new Vd(`If rank y >= 3, then the second last dim of y must equal the last dim of x but got x shape = ${e.shape} and  y shape = ${t.shape}`)}if(2===e.rank&&2===t.rank){return Tc({a:e,b:t,transposeA:!1,transposeB:!1,bias:s?Qf(e.rank,s,"channelsLast"):null,activation:n})}{const r=e.shape.slice(),a=r.pop();e=e.reshape([-1,a]);const i=t.shape.slice(),o=i.pop(),l=i.pop(),u=[...i,o],c=Array.from({length:t.rank},((e,n)=>0===n?t.rank-2:n<=t.rank-2?n-1:n));t=t.transpose(c).reshape([l,-1]);const h=[...r,...u];return Tc({a:e,b:t,transposeA:!1,transposeB:!1,bias:s?Qf(e.rank,s,"channelsLast"):null,activation:n}).reshape(h)}}function Jf(e,t,n){return ii((()=>(t=Array.isArray(t)?Zu(t,"int32"):t.toInt(),Uo(e,t,n))))}function Zf(e){return mi(e,e)}function Qf(e,t,n){const s=t.shape;if(1!==t.rank&&t.rank!==e)throw new Wd(`Unexpected bias dimensions: ${t.rank}; expected it to be 1 or ${e}`);if(5===e){if("channelsFirst"===n)return 1===s.length?t.reshape([1,s[0],1,1,1]):t.reshape([1,s[3],s[0],s[1],s[2]]);if("channelsLast"===n)return 1===s.length?t.reshape([1,1,1,1,s[0]]):t.reshape([1].concat(s))}else if(4===e){if("channelsFirst"===n)return 1===s.length?t.reshape([1,s[0],1,1]):t.reshape([1,s[2],s[0],s[1]]);if("channelsLast"===n)return 1===s.length?t.reshape([1,1,1,s[0]]):t.reshape([1].concat(s))}else if(3===e){if("channelsFirst"===n)return 1===s.length?t.reshape([1,s[0],1]):t.reshape([1,s[1],s[0]]);if("channelsLast"===n)return 1===s.length?t.reshape([1,1,s[0]]):t.reshape([1].concat(s))}else if(e<3)return t;throw new Wd(`Unsupported input rank by biasAdd: ${t.rank}`)}function em(e,t,n){return ii((()=>(null==n&&(n="channelsLast"),Sf(n),e.add(Qf(e.rank,t,n)))))}function tm(e,t,n,s){return ii((()=>mc(e,t,n,s)))}function nm(e,t,n=!1){return n?e():t()}const sm=["fanIn","fanOut","fanAvg"],rm=["normal","uniform","truncatedNormal"];class am extends qa{fromConfigUsesCustomObjects(){return!1}getConfig(){return{}}}class im extends am{apply(e,t){return Rl(e,t)}}im.className="Zeros",Xa(im);class om extends am{apply(e,t){return Fl(e,t)}}om.className="Ones",Xa(om);class lm extends am{constructor(e){if(super(),"object"!=typeof e)throw new Wd(`Expected argument of type ConstantConfig but got ${e}`);if(void 0===e.value)throw new Wd(`config must have value set but got ${e}`);this.value=e.value}apply(e,t){return ii((()=>mi(Tu(this.value),Fl(e,t))))}getConfig(){return{value:this.value}}}lm.className="Constant",Xa(lm);class um extends am{constructor(e){super(),this.DEFAULT_MINVAL=-.05,this.DEFAULT_MAXVAL=.05,this.minval=e.minval||this.DEFAULT_MINVAL,this.maxval=e.maxval||this.DEFAULT_MAXVAL,this.seed=e.seed}apply(e,t){return mu(e,this.minval,this.maxval,t)}getConfig(){return{minval:this.minval,maxval:this.maxval,seed:this.seed}}}um.className="RandomUniform",Xa(um);class cm extends am{constructor(e){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=e.mean||this.DEFAULT_MEAN,this.stddev=e.stddev||this.DEFAULT_STDDEV,this.seed=e.seed}apply(e,t){if("float32"!==(t=t||"float32")&&"int32"!==t)throw new Vd(`randomNormal does not support dType ${t}.`);return Xf(e,this.mean,this.stddev,t,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}cm.className="RandomNormal",Xa(cm);class hm extends am{constructor(e){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=e.mean||this.DEFAULT_MEAN,this.stddev=e.stddev||this.DEFAULT_STDDEV,this.seed=e.seed}apply(e,t){if("float32"!==(t=t||"float32")&&"int32"!==t)throw new Vd(`truncatedNormal does not support dType ${t}.`);return tc(e,this.mean,this.stddev,t,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}hm.className="TruncatedNormal",Xa(hm);class pm extends am{constructor(e){super(),this.gain=null!=e.gain?e.gain:1}apply(e,t){return ii((()=>{if(2!==e.length||e[0]!==e[1])throw new Wd("Identity matrix initializer can only be used for 2D square matrices.");return mi(this.gain,Po(e[0]))}))}getConfig(){return{gain:this.gain}}}pm.className="Identity",Xa(pm);class dm extends am{constructor(e){if(super(),e.scale<0)throw new Wd(`scale must be a positive float. Got: ${e.scale}`);var t;this.scale=null==e.scale?1:e.scale,this.mode=null==e.mode?"fanIn":e.mode,t=this.mode,rf(sm,"FanMode",t),this.distribution=null==e.distribution?"normal":e.distribution,function(e){rf(rm,"Distribution",e)}(this.distribution),this.seed=e.seed}apply(e,t){const n=function(e,t="channelsLast"){let n,s;if(Sf(t),2===e.length)n=e[0],s=e[1];else if(-1!==[3,4,5].indexOf(e.length)){if("channelsFirst"===t){const t=Mf(e,2);n=e[1]*t,s=e[0]*t}else if("channelsLast"===t){const t=Mf(e,0,e.length-2);n=e[e.length-2]*t,s=e[e.length-1]*t}}else{const t=Mf(e);n=Math.sqrt(t),s=Math.sqrt(t)}return[n,s]}(e),s=n[0],r=n[1];let a=this.scale;if("fanIn"===this.mode?a/=Math.max(1,s):"fanOut"===this.mode?a/=Math.max(1,r):a/=Math.max(1,(s+r)/2),"normal"===this.distribution){const n=Math.sqrt(a);if("float32"!==(t=t||"float32")&&"int32"!==t)throw new Vd(`${this.getClassName()} does not support dType ${t}.`);return tc(e,0,n,t,this.seed)}{const n=Math.sqrt(3*a);return mu(e,-n,n,t)}}getConfig(){return{scale:this.scale,mode:this.mode,distribution:this.distribution,seed:this.seed}}}dm.className="VarianceScaling",Xa(dm);class fm extends dm{constructor(e){super({scale:1,mode:"fanAvg",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return dm.className}}fm.className="GlorotUniform",Xa(fm);class mm extends dm{constructor(e){super({scale:1,mode:"fanAvg",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return dm.className}}mm.className="GlorotNormal",Xa(mm);class gm extends dm{constructor(e){super({scale:2,mode:"fanIn",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return dm.className}}gm.className="HeNormal",Xa(gm);class ym extends dm{constructor(e){super({scale:2,mode:"fanIn",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return dm.className}}ym.className="HeUniform",Xa(ym);class bm extends dm{constructor(e){super({scale:1,mode:"fanIn",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return dm.className}}bm.className="LeCunNormal",Xa(bm);class xm extends dm{constructor(e){super({scale:1,mode:"fanIn",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return dm.className}}xm.className="LeCunNormal",Xa(xm);class wm extends am{constructor(e){if(super(),this.DEFAULT_GAIN=1,this.gain=null==e.gain?this.DEFAULT_GAIN:e.gain,this.seed=e.seed,null!=this.seed)throw new Vd("Random seed is not implemented for Orthogonal Initializer yet.")}apply(e,t){return ii((()=>{if(e.length<2)throw new Vd("Shape must be at least 2D.");e[0]*e[1]>2e3&&console.warn(`Orthogonal initializer is being called on a matrix with more than 2000 (${e[0]*e[1]}) elements: Slowness may result.`);const t=Xf(e[0]>e[1]?[e[1],e[0]]:e,0,1,"float32");let n=vh.gramSchmidt(t);return e[0]>e[1]&&(n=n.transpose()),mi(this.gain,n)}))}getConfig(){return{gain:this.gain,seed:this.seed}}}wm.className="Orthogonal",Xa(wm);const km={constant:"Constant",glorotNormal:"GlorotNormal",glorotUniform:"GlorotUniform",heNormal:"HeNormal",heUniform:"HeUniform",identity:"Identity",leCunNormal:"LeCunNormal",leCunUniform:"LeCunUniform",ones:"Ones",orthogonal:"Orthogonal",randomNormal:"RandomNormal",randomUniform:"RandomUniform",truncatedNormal:"TruncatedNormal",varianceScaling:"VarianceScaling",zeros:"Zeros"};function vm(e,t={}){return ef(e,Ka.getMap().classNameMap,t,"initializer")}function Nm(e){return Zd(e)}function Im(e){if("string"==typeof e){const t=e in km?km[e]:e;if("GlorotNormal"===t)return new mm;if("GlorotUniform"===t)return new fm;if("HeNormal"===t)return new gm;if("HeUniform"===t)return new ym;if("LeCunNormal"===t)return new bm;if("LeCunUniform"===t)return new xm;{const e={};return e.className=t,e.config={},vm(e)}}return e instanceof am?e:vm(e)}var $m=Object.freeze({__proto__:null,zeros:function(){return new im},ones:function(){return new om},constant:function(e){return new lm(e)},randomUniform:function(e){return new um(e)},randomNormal:function(e){return new cm(e)},truncatedNormal:function(e){return new hm(e)},identity:function(e){return new pm(e)},varianceScaling:function(e){return new dm(e)},glorotUniform:function(e){return new fm(e)},glorotNormal:function(e){return new mm(e)},heNormal:function(e){return new gm(e)},heUniform:function(e){return new ym(e)},leCunNormal:function(e){return new bm(e)},leCunUniform:function(e){return new xm(e)},orthogonal:function(e){return new wm(e)}});let Cm=0;function Sm(){return Cm++}const Tm={};function Em(e=""){return e in Tm||(Tm[e]=0),Tm[e]+=1,e+Tm[e].toString()}function Am(e){return Array.isArray(e)&&Array.isArray(e[0])}function Rm(e){return 0===e.length?[]:Array.isArray(e[0])?e:[e]}function Fm(e){let t;if(Array.isArray(e)){if(1!==e.length)throw new Wd(`Expected Tensor length to be 1; got ${e.length}`);t=e[0]}else t=e;return t}function Dm(e){if(Array.isArray(e)&&Array.isArray(e[0])){if(1===e.length)return(e=e)[0];throw new Wd(`Expected exactly 1 Shape; got ${e.length}`)}return e}function _m(e){let t=0;for(const n of e)0===n.shape.length?t+=1:t+=n.shape.reduce(((e,t)=>e*t));return t}const Om="Variable";class Mm{constructor(e,t="float32",n="Variable",s=!0,r=null){this.dtype=null==t?"float32":t,this.shape=e.shape,this.id=Sm(),n=null==n?Om:n,this.originalName=Ff(n),this.name=Df(this.originalName),this.trainable_=s,this.constraint=r,this.val=ac(e,this.trainable_,this.name,this.dtype)}read(){return this.assertNotDisposed(),this.val}write(e){return this.assertNotDisposed(),function(e,t){if(e.shape.toString()!==t.shape.toString())throw new Error("Shape mismatch: "+JSON.stringify(e.shape)+" vs. "+JSON.stringify(t.shape))}(this.val,e),this.val.id!==e.id&&(this.val.assign(e),null!=this.constraint&&this.val.assign(this.constraint.apply(this.val))),this}dispose(){this.assertNotDisposed(),this.val.dispose()}assertNotDisposed(){if(this.val.isDisposed)throw new Error(`LayersVariable ${this.name} is already disposed.`)}get trainable(){return this.trainable_}set trainable(e){this.trainable_=e,this.val.trainable=e}}function Lm(e){return e.map((e=>e.read()))}function zm(e){e.forEach((e=>{e[0].write(e[1])}))}class Bm{constructor(e){this.dtype=e.dtype,this.shape=e.shape,null!=e.shape?this.ndim=e.shape.length:this.ndim=e.ndim,this.maxNDim=e.maxNDim,this.minNDim=e.minNDim,this.axes=e.axes||{}}}class Pm{constructor(e,t,n,s,r,a,i){this.dtype=e,this.shape=t,this.sourceLayer=n,this.inputs=s,this.callArgs=r,this.outputTensorIndex=i,this.id=Sm(),null!=a&&(this.originalName=Ff(a),this.name=Df(this.originalName)),this.rank=t.length}}let Wm=0;class Vm{constructor(e,t){this.callArgs=t,this.id=Wm++,this.outboundLayer=e.outboundLayer,this.inboundLayers=e.inboundLayers,this.nodeIndices=e.nodeIndices,this.tensorIndices=e.tensorIndices,this.inputTensors=e.inputTensors,this.outputTensors=e.outputTensors,this.inputMasks=e.inputMasks,this.outputMasks=e.outputMasks,this.inputShapes=e.inputShapes,this.outputShapes=e.outputShapes;for(const t of e.inboundLayers)null!=t&&t.outboundNodes.push(this);e.outboundLayer.inboundNodes.push(this)}getConfig(){const e=[];for(const t of this.inboundLayers)null!=t?e.push(t.name):e.push(null);return{outboundLayer:this.outboundLayer?this.outboundLayer.name:null,inboundLayers:e,nodeIndices:this.nodeIndices,tensorIndices:this.tensorIndices}}}let Um=0;class Gm extends qa{constructor(e={}){super(),this._callHook=null,this._addedWeightNames=[],this._stateful=!1,this.id=Um++,this.activityRegularizer=null,this.inputSpec=null,this.supportsMasking=!1,this._trainableWeights=[],this._nonTrainableWeights=[],this._losses=[],this._updates=[],this._built=!1,this.inboundNodes=[],this.outboundNodes=[];let t=e.name;if(!t){const e=this.getClassName();t=Xd(e)+"_"+Em(e)}if(this.name=t,this.trainable_=null==e.trainable||e.trainable,null!=e.inputShape||null!=e.batchInputShape){let t;if(null!=e.batchInputShape)t=e.batchInputShape;else if(null!=e.inputShape){let n=null;null!=e.batchSize&&(n=e.batchSize),t=[n].concat(e.inputShape)}this.batchInputShape=t;let n=e.dtype;null==n&&(n=e.inputDType),null==n&&(n="float32"),this.dtype=n}null!=e.weights?this.initialWeights=e.weights:this.initialWeights=null,this._refCount=null,this.fastWeightInitDuringBuild=!1}static nodeKey(e,t){return e.name+"_ib-"+t.toString()}getNodeAtIndex(e,t){if(0===this.inboundNodes.length)throw new Pd(`The layer has never been called and thus has no defined ${t}.`);if(this.inboundNodes.length<=e)throw new Wd(`Asked to get ${t} at node ${e}, but the layer has only ${this.inboundNodes.length} inbound nodes.`);return this.inboundNodes[e]}getInputAt(e){return qd(this.getNodeAtIndex(e,"input").inputTensors)}getOutputAt(e){return qd(this.getNodeAtIndex(e,"output").outputTensors)}get input(){if(this.inboundNodes.length>1)throw new Bd(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer input" is ill-defined. Use \`getInputAt(nodeIndex)\` instead.`);if(0===this.inboundNodes.length)throw new Bd(`Layer ${this.name} is not connected, no input to return.`);return qd(this.getNodeAtIndex(0,"input").inputTensors)}get output(){if(0===this.inboundNodes.length)throw new Bd(`Layer ${this.name} has no inbound nodes.`);if(this.inboundNodes.length>1)throw new Bd(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer output" is ill-defined. Use \`getOutputAt(nodeIndex)\` instead.`);return qd(this.getNodeAtIndex(0,"output").outputTensors)}get losses(){return this._losses}calculateLosses(){return this.losses.map((e=>e()))}get updates(){return this._updates}get built(){return this._built}set built(e){this._built=e}get trainable(){return this.trainable_}set trainable(e){this._trainableWeights.forEach((t=>t.trainable=e)),this.trainable_=e}get trainableWeights(){return this.trainable_?this._trainableWeights.filter((e=>e.trainable)):[]}set trainableWeights(e){this._trainableWeights=e}get nonTrainableWeights(){return this.trainable?this._trainableWeights.filter((e=>!e.trainable)).concat(this._nonTrainableWeights):this._trainableWeights.concat(this._nonTrainableWeights)}set nonTrainableWeights(e){this._nonTrainableWeights=e}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}get stateful(){return this._stateful}resetStates(){if(!this.stateful)throw new Error("Cannot call the resetStates() method of a non-stateful Layer object.")}assertInputCompatibility(e){if(e=Kd(e),null==this.inputSpec||0===this.inputSpec.length)return;const t=Kd(this.inputSpec);if(e.length!==t.length)throw new Wd(`Layer ${this.name} expects ${t.length} inputs, but it received ${e.length} input tensors. Input received: ${e}`);for(let n=0;n<e.length;n++){const s=e[n],r=t[n];if(null==r)continue;const a=s.rank;if(null!=r.ndim&&a!==r.ndim)throw new Wd(`Input ${n} is incompatible with layer ${this.name}: expected ndim=${r.ndim}, found ndim=${a}`);if(null!=r.maxNDim&&a>r.maxNDim)throw new Wd(`Input ${n} is incompatible with layer ${this.name}: expected max_ndim=${r.maxNDim}, found ndim=${a}`);if(null!=r.minNDim&&a<r.minNDim)throw new Wd(`Input ${n} is incompatible with layer ${this.name}: expected min_ndim=${r.minNDim}, found ndim=${a}.`);if(null!=r.dtype&&s.dtype!==r.dtype)throw new Wd(`Input ${n} is incompatible with layer ${this.name} : expected dtype=${r.dtype}, found dtype=${s.dtype}.`);if(r.axes){const e=s.shape;for(const t in r.axes){const s=Number(t),a=r.axes[t],i=s>=0?e[s]:e[e.length+s];if(null!=a&&-1===[a,null].indexOf(i))throw new Wd(`Input ${n} is incompatible with layer ${this.name}: expected axis ${s} of input shape to have value ${a} but got shape ${e}.`)}}if(null!=r.shape)for(let e=0;e<r.shape.length;++e){const t=r.shape[e],a=s.shape[e];if(null!=t&&null!=a&&t!==a)throw new Wd(`Input ${n} is incompatible with layer ${this.name}: expected shape=${r.shape}, found shape=${s.shape}.`)}}}call(e,t){return e}invokeCallHook(e,t){null!=this._callHook&&this._callHook(e,t)}setCallHook(e){this._callHook=e}clearCallHook(){this._callHook=null}apply(e,t){t=t||{},this.assertNotDisposed();const n=Kd(e);let s=!0;for(const e of n)if(!(e instanceof Pm)){s=!1;break}let r=!0;for(const e of n)if(e instanceof Pm){r=!1;break}if(s===r)throw new Wd("Arguments to apply() must be all SymbolicTensors or all Tensors");return Rf(this.name,(()=>{if(!this.built){this.assertInputCompatibility(e);const t=[];for(const n of Kd(e))t.push(n.shape);this.build(qd(t)),this.built=!0,this.initialWeights&&this.setWeights(this.initialWeights),null===this._refCount&&r&&(this._refCount=1)}if(this.assertInputCompatibility(e),r){let s=this.call(e,t);const r=Kd(s),a=[];for(let e of r)-1!==n.indexOf(e)&&(e=e.clone()),a.push(e);if(s=qd(a),null!=this.activityRegularizer)throw new Vd("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return s}{const n=function(e){e=Kd(e);const t=[];for(const n of e)t.push(n.shape);return qd(t)}(e),s=this.computeOutputShape(n);let r;const a="float32";if(this.warnOnIncompatibleInputShape(Array.isArray(e)?n[0]:n),r=null!=s&&s.length>0&&Array.isArray(s[0])?s.map(((n,s)=>new Pm(a,n,this,Kd(e),t,this.name,s))):new Pm(a,s,this,Kd(e),t,this.name),this.addInboundNode(e,r,null,null,n,s,t),this._refCount++,null!=this.activityRegularizer)throw new Vd("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return r}}))}warnOnIncompatibleInputShape(e){if(null!=this.batchInputShape)if(e.length!==this.batchInputShape.length)console.warn(`The rank of the input tensor provided (shape: ${JSON.stringify(e)}) does not match that of the batchInputShape (${JSON.stringify(this.batchInputShape)}) of the layer ${this.name}`);else{let t=!1;this.batchInputShape.forEach(((n,s)=>{null!=n&&null!=e[s]&&e[s]!==n&&(t=!0)})),t&&console.warn(`The shape of the input tensor (${JSON.stringify(e)}) does not match the expectation of layer ${this.name}: ${JSON.stringify(this.batchInputShape)}`)}}get outputShape(){if(null==this.inboundNodes||0===this.inboundNodes.length)throw new Bd(`The layer ${this.name} has never been called and thus has no defined output shape.`);const e=[];for(const t of this.inboundNodes){const n=JSON.stringify(t.outputShapes);-1===e.indexOf(n)&&e.push(n)}if(1===e.length){const e=this.inboundNodes[0].outputShapes;return Array.isArray(e)&&Array.isArray(e[0])&&1===e.length?e[0]:e}throw new Bd(`The layer ${this.name} has multiple inbound nodes with different output shapes. Hence the notion of "output shape" is ill-defined for the layer.`)}countParams(){if(!this.built)throw new Pd(`You tried to call countParams() on ${this.name}, but the layer is not built yet. Build it first by calling build(batchInputShape).`);return _m(this.weights)}build(e){this.built=!0}getWeights(e=!1){return Lm(e?this.trainableWeights:this.weights)}setWeights(e){ii((()=>{const t=this.weights;if(t.length!==e.length)throw new Wd(`You called setWeights(weights) on layer "${this.name}" with a weight list of length ${e.length}, but the layer was expecting ${t.length} weights. Provided weights: ${e}...`);if(0===t.length)return;const n=[],s=Lm(t);for(let r=0;r<s.length;++r){const a=s[r],i=t[r],o=e[r];if(!d(a.shape,o.shape))throw new Wd(`Layer weight shape ${a.shape} not compatible with provided weight shape ${o.shape}`);n.push([i,o])}zm(n)}))}addWeight(e,t,n,s,r,a,i){if(-1!==this._addedWeightNames.indexOf(e))throw new Wd(`Duplicate weight name ${e} for layer ${this.name}`);this._addedWeightNames.push(e),null==n&&(n="float32"),this.fastWeightInitDuringBuild&&(s=Im("zeros"));const o=s.apply(t,n),l=new Mm(o,n,e,a,i);return o.dispose(),null!=r&&this.addLoss((()=>r.apply(l.read()))),null==a&&(a=!0),a?this._trainableWeights.push(l):this._nonTrainableWeights.push(l),l}setFastWeightInitDuringBuild(e){this.fastWeightInitDuringBuild=e}addLoss(e){null==e||Array.isArray(e)&&0===e.length||(e=Kd(e),void 0!==this._losses&&null!==this._losses&&this.losses.push(...e))}computeOutputShape(e){return e}computeMask(e,t){if(!this.supportsMasking){if(null!=t){if(!Array.isArray(t))throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);t.forEach((e=>{if(null!=e)throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`)}))}return null}return t}addInboundNode(e,t,n,s,r,a,i=null){const o=Kd(e);t=Kd(t),n=Kd(n),s=Kd(s),r=Rm(r),a=Rm(a);const l=[],u=[],c=[];for(const e of o)l.push(e.sourceLayer),u.push(e.nodeIndex),c.push(e.tensorIndex);new Vm({outboundLayer:this,inboundLayers:l,nodeIndices:u,tensorIndices:c,inputTensors:o,outputTensors:t,inputMasks:n,outputMasks:s,inputShapes:r,outputShapes:a},i);for(let e=0;e<t.length;e++)t[e].sourceLayer=this,t[e].nodeIndex=this.inboundNodes.length-1,t[e].tensorIndex=e}getConfig(){const e={name:this.name,trainable:this.trainable};return null!=this.batchInputShape&&(e.batchInputShape=this.batchInputShape),null!=this.dtype&&(e.dtype=this.dtype),e}disposeWeights(){return this.weights.forEach((e=>e.dispose())),this.weights.length}assertNotDisposed(){if(0===this._refCount)throw new Error(`Layer '${this.name}' is already disposed.`)}dispose(){if(!this.built)throw new Error(`Cannot dispose Layer ${this.name} because it has not been built yet.`);if(null===this._refCount)throw new Error(`Cannot dispose Layer ${this.name} because it has not been used yet.`);this.assertNotDisposed();let e=0;return 0==--this._refCount&&(e=this.disposeWeights()),{refCountAfterDispose:this._refCount,numDisposedVariables:e}}}function Hm(e,t,n){if((null==t||null!=n&&n>0)&&(t=e.sourceLayer,n=e.nodeIndex),0===t.inboundNodes.length)return[e];{const e=t.inboundNodes[n];if(0===e.inboundLayers.length)return e.inputTensors;{const t=[];for(let n=0;n<e.inboundLayers.length;n++){const s=Hm(e.inputTensors[n],e.inboundLayers[n],e.nodeIndices[n]);for(const e of s)-1===t.indexOf(e)&&t.push(e)}return t}}}class jm extends Gm{constructor(e){if(super({dtype:e.dtype,name:null!=e.name?e.name:Em("input").toString()}),null==e.batchSize&&(e.batchSize=null),null==e.sparse&&(e.sparse=!1),this.trainable=!1,this.built=!0,this.sparse=e.sparse,null!=e.inputShape&&null!=e.batchInputShape)throw new Wd("Only provide the inputShape OR batchInputShape argument to inputLayer, not both at the same time.");let t=e.batchInputShape;if(null==t){if(null==e.inputShape)throw new Wd("An InputLayer should be passed either a `batchInputShape` or an `inputShape`.");t=[e.batchSize].concat(e.inputShape)}else if(null!=e.batchSize)throw new Wd("Cannot specify batchSize if batchInputShape is specified when creating an InputLayer.");const n=e.dtype||"float32";this.batchInputShape=t,this.dtype=n,this.inputSpec=[{shape:t}];const s=new Pm(this.dtype,this.batchInputShape,this,[],{},this.name);s.nodeIndex=0,s.tensorIndex=0,new Vm({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:[s],outputTensors:[s],inputMasks:[null],outputMasks:[null],inputShapes:[t],outputShapes:[t]})}apply(e,t){throw new Wd(`Cannot pass any input to an InputLayer's apply() method. InputLayer name: ${this.name}`)}dispose(){return{refCountAfterDispose:this._refCount,numDisposedVariables:0}}getConfig(){return{batchInputShape:this.batchInputShape,dtype:this.dtype,sparse:this.sparse,name:this.name}}}function qm(e){if(null==e.batchShape&&null==e.shape)throw new Error("Please provide to Input either a `shape` or a `batchShape` argument. Note that `shape` does not include the batch dimension.");if(null!=e.batchShape&&null!=e.shape)throw new Wd("Please provide either a `shape` or `batchShape` argument to Input, but not both.");let t=e.batchShape;null!=e.shape&&null==t&&(t=[null].concat(e.shape));let n=e.dtype;null==n&&(n="float32");return new jm({batchInputShape:t,name:e.name,dtype:n,sparse:e.sparse}).inboundNodes[0].outputTensors[0]}async function Km(e){if(null==e)return;const t=[],n=[],s=[];for(const r in e){const a=e[r];if("number"!=typeof a){const e=a;t.push(e.data()),n.push(r),s.push(e)}}if(t.length>0){const r=await Promise.all(t);for(let t=0;t<r.length;++t)e[n[t]]=r[t][0];oi(s)}}function Xm(e){if(null!=e)for(const t in e){const n=e[t];"number"!=typeof n&&n.dispose()}}var Ym;jm.className="InputLayer",Xa(jm),function(e){e[e.SILENT=0]="SILENT",e[e.VERBOSE=1]="VERBOSE"}(Ym||(Ym={}));class Jm{constructor(){this.validationData=null}setParams(e){this.params=e}async onEpochBegin(e,t){}async onEpochEnd(e,t){}async onBatchBegin(e,t){}async onBatchEnd(e,t){}async onTrainBegin(e){}async onTrainEnd(e){}setModel(e){}}class Zm{constructor(e,t=10){null==e&&(e=[]),this.callbacks=e,this.queueLength=t}append(e){this.callbacks.push(e)}setParams(e){for(const t of this.callbacks)t.setParams(e)}setModel(e){for(const t of this.callbacks)t.setModel(e)}async onEpochBegin(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onEpochBegin(e,t)}async onEpochEnd(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onEpochEnd(e,t)}async onBatchBegin(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onBatchBegin(e,t)}async onBatchEnd(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onBatchEnd(e,t)}async onTrainBegin(e){null==e&&(e={});for(const t of this.callbacks)await t.onTrainBegin(e)}async onTrainEnd(e){null==e&&(e={});for(const t of this.callbacks)await t.onTrainEnd(e)}}class Qm extends Jm{constructor(){super()}async onEpochBegin(e){this.seen=0,this.totals={}}async onBatchEnd(e,t){null==t&&(t={});const n=null==t.size?0:t.size;this.seen+=n;for(const e in t){const s=t[e];if("number"==typeof s)this.totals.hasOwnProperty(e)||(this.totals[e]=0),this.totals[e]=this.totals[e]+s*n;else{let t;e in this.totals?t=this.totals[e]:this.totals[e]=0;const r=ii((()=>pi(this.totals[e],mi(s,n))));this.totals[e]=r,null!=t&&t.dispose()}}}async onEpochEnd(e,t){if(null!=t)for(const e of this.params.metrics)null!=this.totals[e]&&("number"==typeof this.totals[e]?t[e]=this.totals[e]/this.seen:ii((()=>{const n=mi(fi(1,this.seen),this.totals[e]);t[e]=n,this.totals[e].dispose(),li(t[e])})))}}class eg extends Jm{async onTrainBegin(e){this.epoch=[],this.history={}}async onEpochEnd(e,t){null==t&&(t={}),this.epoch.push(e);for(const e in t)null==this.history[e]&&(this.history[e]=[]),this.history[e].push(t[e])}async syncData(){const e=[],t=[],n=[];for(const s in this.history){const r=this.history[s];for(let a=0;a<r.length;++a)if("number"!=typeof r[a]){const i=r[a];e.push(i.data()),t.push(s),n.push(a)}}const s=await Promise.all(e);for(let e=0;e<s.length;++e){this.history[t[e]][n[e]].dispose(),this.history[t[e]][n[e]]=s[e][0]}}}class tg extends Jm{constructor(e,t){if(super(),this.currentEpoch=0,this.yieldEvery=t||"auto","auto"===this.yieldEvery&&(this.yieldEvery=125),"never"===this.yieldEvery&&null!=e.onYield)throw new Error("yieldEvery is `never` but you provided an `onYield` callback. Either change `yieldEvery` or remove the callback");R(this.yieldEvery)&&(this.maybeWait=function(e,t){let n,s=os();return(...r)=>{const a=os();return a-s<t||(s=a,n=e(...r)),n}}(this.maybeWait.bind(this),this.yieldEvery)),this.trainBegin=e.onTrainBegin,this.trainEnd=e.onTrainEnd,this.epochBegin=e.onEpochBegin,this.epochEnd=e.onEpochEnd,this.batchBegin=e.onBatchBegin,this.batchEnd=e.onBatchEnd,this.yield=e.onYield}async maybeWait(e,t,n){const s=[];null!=this.yield&&(await Km(n),s.push(this.yield(e,t,n))),s.push(Mh()),await Promise.all(s)}async onEpochBegin(e,t){this.currentEpoch=e,null!=this.epochBegin&&(await Km(t),await this.epochBegin(e,t))}async onEpochEnd(e,t){const n=[];null!=this.epochEnd&&(await Km(t),n.push(this.epochEnd(e,t))),"epoch"===this.yieldEvery&&n.push(Mh()),await Promise.all(n)}async onBatchBegin(e,t){null!=this.batchBegin&&(await Km(t),await this.batchBegin(e,t))}async onBatchEnd(e,t){const n=[];null!=this.batchEnd&&(await Km(t),n.push(this.batchEnd(e,t))),"batch"===this.yieldEvery?n.push(Mh()):R(this.yieldEvery)&&n.push(this.maybeWait(this.currentEpoch,e,t)),await Promise.all(n)}async onTrainBegin(e){null!=this.trainBegin&&(await Km(e),await this.trainBegin(e))}async onTrainEnd(e){null!=this.trainEnd&&(await Km(e),await this.trainEnd(e))}}function ng(e,t){if(null==e&&(e={}),e instanceof Jm)return[e];if(Array.isArray(e)&&e[0]instanceof Jm)return e;return Kd(e).map((e=>new tg(e,t)))}class sg{constructor(){}static registerCallbackConstructor(e,t){l(e>=0&&Number.isInteger(e),(()=>`Verbosity level is expected to be an integer >= 0, but got ${e}`)),sg.checkForDuplicate(t),null==sg.constructors[e]&&(sg.constructors[e]=[]),sg.constructors[e].push(t)}static checkForDuplicate(e){for(const t in sg.constructors){sg.constructors[+t].forEach((t=>{if(t===e)throw new Wd("Duplicate callback constructor.")}))}}static clear(){sg.constructors={}}static createCallbacks(e){const t=[];for(const n in sg.constructors){const s=+n;e>=s&&t.push(...sg.constructors[s])}return t.map((e=>new e))}}function rg(e,t,n,s,r,a,i,o,l){const u=new eg,c=[new Qm,...sg.createCallbacks(t)];null!=e&&c.push(...e),c.push(u);const h=new Zm(c);return h.setParams({epochs:n,initialEpoch:s,samples:r,steps:a,batchSize:i,verbose:t,doValidation:o,metrics:l}),{callbackList:h,history:u}}function ag(e,t={},n=!1){return ef(e,Ka.getMap().classNameMap,t,"layer",n)}function ig(e,t){return ii((()=>{"float32"!==e.dtype&&(e=e.asType("float32"));const n=hl(Zf(e),t,!0),s=Wo(n.shape,zd()),r=Hu(El(n,s));return fi(e,r)}))}function og(e,t){return ii((()=>Al(Zf(cl(t,e)),-1)))}function lg(e,t){return ii((()=>Al(gi(cl(t,e)),-1)))}function ug(e,t){return ii((()=>{const n=cl(e,t),s=ro(gi(e),zd(),Number.MAX_VALUE),r=gi(fi(n,s));return mi(100,Al(r,-1))}))}function cg(e,t){return ii((()=>{const n=ro(t,zd(),Number.MAX_VALUE),s=tl(pi(1,n)),r=ro(e,zd(),Number.MAX_VALUE),a=tl(pi(1,r));return Al(Zf(cl(s,a)),-1)}))}function hg(e,t,n=!1){return ii((()=>{if(n)t=Bu(t);else{const e=hl(t,t.shape.length-1,!0);t=fi(t,e)}return t=ro(t,zd(),1-zd()),il(hl(mi(e.toFloat(),tl(t)),t.shape.length-1))}))}function pg(e,t,n=!1){return ii((()=>{const s=Vo(function(e){const t=[Mf(e.shape)];return e.reshape(t)}(e)).toInt(),r=(t=ro(t,zd(),1-zd())).shape;return hg(fa(s,r[r.length-1]).reshape(r),t,n)}))}function dg(e,t){return ii((()=>{let n;return n=ro(t,zd(),1-zd()),n=tl(fi(n,cl(1,n))),Al(function(e,t){if(!d(e.shape,t.shape))throw new Wd(`logits and labels must have the same shape, but got shapes ${JSON.stringify(e.shape)} and ${JSON.stringify(t.shape)}`);return ii((()=>{const n=t.relu(),s=t.abs().neg();return n.sub(t.mul(e)).add(s.exp().log1p())}))}(e,n),-1)}))}function fg(e,t){return ii((()=>{const n=ro(e,zd(),1),s=ro(t,zd(),1);return hl(mi(e,tl(fi(n,s))),-1)}))}function mg(e,t){return ii((()=>{const n=ig(e,-1),s=ig(t,-1),r=mi(n,s);return il(hl(r,-1))}))}sg.constructors={};const gg={meanSquaredError:og,meanAbsoluteError:lg,meanAbsolutePercentageError:ug,meanSquaredLogarithmicError:cg,squaredHinge:function(e,t){return ii((()=>{const n=El(0,cl(1,mi(e,t)));return Al(Zf(n),-1)}))},hinge:function(e,t){return ii((()=>{const n=El(0,cl(1,mi(e,t)));return Al(n,-1)}))},categoricalHinge:function(e,t){return ii((()=>{const n=hl(mi(e,t),-1),s=ul(mi(cl(1,e),t),-1);return El(0,pi(1,cl(s,n)))}))},logcosh:function(e,t){return ii((()=>{const n=Math.log(2),s=cl(t,e),r=cl(pi(s,ol(mi(-2,s))),n);return Al(r,-1)}))},categoricalCrossentropy:hg,sparseCategoricalCrossentropy:pg,binaryCrossentropy:dg,kullbackLeiblerDivergence:fg,poisson:function(e,t){return ii((()=>{const n=tl(pi(zd(),t));return Al(cl(t,mi(e,n)),-1)}))},cosineProximity:mg};function yg(e){if("string"==typeof e){if(e in gg)return gg[e];let t=`Unknown loss ${e}`;throw e.toLowerCase().includes("softmaxcrossentropy")&&(t=`Unknown loss ${e}. Use "categoricalCrossentropy" as the string name for tf.losses.softmaxCrossEntropy`),new Wd(t)}return e}function bg(e,t){return ii((()=>{const n=mi(.5,Vl(t)),s=Wf(Go(t,n),e.dtype);return Al(To(e,s),-1)}))}function xg(e,t){return ii((()=>Wf(To(vi(e,-1),vi(t,-1)),"float32")))}function wg(e,t){return ii((()=>vl(e.equal(1),t.equal(1)).sum().cast("float32")))}function kg(e,t){return ii((()=>{const n=wg(e,t),s=function(e,t){return ii((()=>vl(e.equal(0),t.equal(1)).sum().cast("float32")))}(e,t),r=n.add(s);return Eo(Go(r,0),n.div(r),0).cast("float32")}))}function vg(e,t){return ii((()=>{const n=wg(e,t),s=function(e,t){return ii((()=>vl(e.equal(1),t.equal(0)).sum().cast("float32")))}(e,t),r=n.add(s);return Eo(Go(r,0),n.div(r),0).cast("float32")}))}function Ng(e,t){return dg(e,t)}function Ig(e,t){return e.rank===t.rank&&(e=e.squeeze([e.rank-1])),(t=t.argMax(-1)).dtype!==e.dtype&&(t=t.asType(e.dtype)),To(e,t).asType("float32")}const $g=hg,Cg=pg,Sg={binaryAccuracy:bg,categoricalAccuracy:xg,precision:kg,categoricalCrossentropy:$g,sparseCategoricalCrossentropy:Cg,mse:og,MSE:og,mae:lg,MAE:lg,mape:ug,MAPE:ug,cosine:mg};function Tg(e){if("string"==typeof e&&e in Sg)return Sg[e];if("string"!=typeof e&&null!=e)return e;throw new Wd(`Unknown metric ${e}`)}function Eg(e){if(Hd(null!==e,`Unknown LossOrMetricFn ${e}`),"string"==typeof e)return e;{let t;for(const n of Object.keys(gg))if(gg[n]===e){t=n;break}if(void 0!==t)return t;for(const n of Object.keys(Sg))if(Sg[n]===e){t=n;break}return void 0!==t?t:e.name}}const Ag=1048576;function Rg(e,t,n=!1){if(null==e||"object"!=typeof e||Object.getPrototypeOf(e)!==Object.prototype||!Fg(e))throw new Error("User-defined metadata is expected to be a JSON object, but is not.");if(n){const n=JSON.stringify(e);n.length>Ag&&console.warn(`User-defined metadata of model "${t}" is too large in size (length=${n.length} when serialized). It is not recommended to store such large objects in user-defined metadata. Please make sure its serialized length is <= 1048576.`)}}function Fg(e){if(null===e)return!0;if("object"==typeof e){if(Object.getPrototypeOf(e)===Object.prototype){const t=Object.keys(e);for(const n of t){if("string"!=typeof n)return!1;if(!Fg(e[n]))return!1}return!0}if(Array.isArray(e)){for(const t of e)if(!Fg(t))return!1;return!0}return!1}{const t=typeof e;return"string"===t||"number"===t||"boolean"===t}}function Dg(e,t,n,s=console.log){const r=function(e){let t=!0;const n=[],s=[];for(const t in e.nodesByDepth)n.push(e.nodesByDepth[t]);for(const e of n){if(e.length>1||1===e.length&&e[0].inboundLayers.length>1){t=!1;break}s.push(...e)}if(t)for(const n of e.layers){let e=!1;for(const r of n.inboundNodes)if(-1!==s.indexOf(r)){if(e){t=!1;break}e=!0}if(!t)break}return t}(e),a=["Layer (type)","Output shape","Param #"];let i;if(r?(t=t||65,n=n||[.45,.85,1]):(t=t||98,n=n||[.33,.55,.67,1]),n[n.length-1]<=1&&(n=n.map((e=>Math.floor(t*e)))),!r){a.push("Receives inputs"),i=[];for(const t in e.nodesByDepth)i.push(...e.nodesByDepth[t])}s("_".repeat(t)),_g(a,n,s),s("=".repeat(t));const o=e.layers;for(let e=0;e<o.length;++e)r?Og(o[e],n,s):Mg(o[e],n,i,s),s((e===o.length-1?"=":"_").repeat(t));e.checkTrainableWeightsConsistency();const l=function(e){let t;t=null!=e.collectedTrainableWeights?_m(e.collectedTrainableWeights):_m(e.trainableWeights);return t}(e),u=_m(e.nonTrainableWeights);s(`Total params: ${l+u}`),s(`Trainable params: ${l}`),s(`Non-trainable params: ${u}`),s("_".repeat(t))}function _g(e,t,n=console.log){let s="";for(let n=0;n<e.length;++n)n>0&&(s=s.slice(0,s.length-1)+" "),s+=e[n],s=s.slice(0,t[n]),s+=" ".repeat(t[n]-s.length);n(s)}function Og(e,t,n){let s;try{s=JSON.stringify(e.outputShape)}catch(e){s="multiple"}_g([`${e.name} (${e.getClassName()})`,s,e.countParams().toString()],t,n)}function Mg(e,t,n,s){let r;try{r=JSON.stringify(e.outputShape)}catch(e){r="multiple"}const a=[];for(const t of e.inboundNodes)if(!(null!=n&&n.length>0&&-1===n.indexOf(t)))for(let e=0;e<t.inboundLayers.length;++e){const n=t.inboundLayers[e].name,s=t.nodeIndices[e],r=t.tensorIndices[e];a.push(`${n}[${s}][${r}]`)}const i=e.name,o=e.getClassName(),l=0===a.length?"":a[0];_g([`${i} (${o})`,r,e.countParams().toString(),l],t,s);for(let e=1;e<a.length;++e)_g(["","","",a[e]],t,s)}function Lg(e,t,n){return("inboundNodes"===e||"outputLayers"===e||"inputLayers"===e)&&0===t&&"string"==typeof n}function zg(e,t){if(null===e)return null;if("string"==typeof e)return Yd(e);if("number"==typeof e||"boolean"==typeof e)return e;if(e instanceof Array){const n=[],s=e.length;for(let r=0;r<s;++r){const s=e[r];Lg(t,r,s)?n.push(s):n.push(zg(s,t))}return n}{const t={};for(const n of Object.keys(e)){const s=e[n];if("name"===n&&"string"==typeof s)t[n]=s;else{const e=Yd(n);t[e]=zg(s,e)}}return t}}function Bg(e,t){if(null==e)return null;if("string"==typeof e)return Xd(e);if("number"==typeof e||"boolean"==typeof e)return e;if(e instanceof Array){const n=[],s=e.length;for(let r=0;r<s;++r){const s=e[r];Lg(t,r,s)?n.push(s):n.push(Bg(s,t))}return n}{const t={};for(const n of Object.keys(e)){const s=e[n],r=Xd(n);t[r]="name"!==n&&"className"!==n||"string"!=typeof s?Bg(s,n):s}return t}}const Pg="3.6.0";class Wg{constructor(e){if(this.id2Value={},this.id2Mask={},this.name2Id={},e instanceof Wg)for(const t in e.id2Value)this.id2Value[t]=e.id2Value[t],t in e.id2Mask&&(this.id2Mask[t]=e.id2Mask[t]);else{if(null==e)return;for(const t of e)this.add(t.key,t.value)}}add(e,t,n){if(null!=this.id2Value[e.id])throw new Wd(`Duplicate key: name=${e.name}, id=${e.id}`);return this.id2Value[e.id]=function(e,t){if(null==e.dtype||e.dtype===t.dtype)return t;try{return Xr(t,e.dtype)}catch(n){throw new Wd(`The dtype of the feed (${t.dtype}) can not be cast to the dtype of the key '${e.name}' (${e.dtype}).`)}}(e,t),this.name2Id[e.name]=e.id,null!=n&&(this.id2Mask[e.id]=n),this}addFeed(e){this.add(e.key,e.value)}hasKey(e){return null!=this.id2Value[e.id]}names(){return Object.keys(this.name2Id)}getValue(e){if(e instanceof Pm){if(null==this.id2Value[e.id])throw new Wd(`Nonexistent key: ${e.name}`);return this.id2Value[e.id]}{const t=this.name2Id[e];if(null==t)throw new Wd(`Feed dict has no SymbolicTensor name: ${e}`);return this.id2Value[t]}}getMask(e){if(e instanceof Pm){if(null==this.id2Value[e.id])throw new Wd(`Nonexistent key: ${e.name}`);return this.id2Mask[e.id]}{const t=this.name2Id[e];if(null==t)throw new Wd(`Feed dict has no SymbolicTensor name: ${e}`);return this.id2Mask[t]}}disposeMasks(){null!=this.id2Mask&&oi(this.id2Mask)}}const Vg={},Ug={};function Gg(e,t,n,s){const r=null!=n&&n.training,a=Array.isArray(e),i=a?e:[e],o=i.map((e=>e.name)),u=[],c=t.names();for(const e of o)-1!==c.indexOf(e)?u.push(t.getValue(e)):u.push(null);null!=s&&(s.maxNumTensors=-1/0,s.minNumTensors=1/0);const h=o.join(",")+"|"+t.names().join(",");let p,d;if(null==Vg[h]){const e=function(e,t){l(null!=e&&e.length>0,(()=>"Expected at least one fetch, got none"));let n=[],s={};if(1===e.length){const r=jg(e[0],t);n=r.sorted,s=r.recipientMap}else{const r=new Set;for(const a of e){const{sorted:e,recipientMap:i}=jg(a,t);for(const t of e)r.has(t.name)||(n.push(t),r.add(t.name));for(const e in i)null==s[e]&&(s[e]=new Set),i[e].forEach((t=>s[e].add(t)))}}return{sorted:n,recipientCounts:Hg(s)}}(i,t);p=e.sorted,d=e.recipientCounts,Vg[h]=p,Ug[h]=d}p=Vg[h],d={},r||Object.assign(d,Ug[h]);const f=new Wg(t);for(let e=0;e<p.length;++e){if(null!=s){const e=ai().numTensors;e>s.maxNumTensors&&(s.maxNumTensors=e),e<s.minNumTensors&&(s.minNumTensors=e)}const a=p[e],i=a.sourceLayer;if(i instanceof jm)continue;const l=[],c=[],h=[];let m=!1;for(const e of a.inputs){const n=f.getValue(e),s=f.getMask(e);l.push(n),c.push(s),null!=s&&(m=!0),r||(d[e.name]--,0!==d[e.name]||t.hasKey(e)||-1!==o.indexOf(e.name)||n.isDisposed||!0===e.sourceLayer.stateful||h.push(n))}m&&((n=n||{}).mask=c[0]);const g=Kd(i.apply(l,n));let y=null;i.supportsMasking&&(y=i.computeMask(l,c));const b=qg(a),x=Array.isArray(b)?b:[b];for(let e=0;e<x.length;++e){f.hasKey(x[e])||f.add(x[e],g[e],Array.isArray(y)?y[0]:y);const t=o.indexOf(x[e].name);-1!==t&&(u[t]=g[e])}r||oi(h)}return f.disposeMasks(),a?u:u[0]}function Hg(e){const t={};for(const n in e)t[n]=e[n].size;return t}function jg(e,t){const n=new Set,s=[],r={};for(const e of t.names())n.add(e);const a=[],i=[];for(a.push(e);a.length>0;){const e=a[a.length-1];if(n.has(e.name)){a.pop();continue}const t=i[i.length-1]===a.length-1;if(0===e.inputs.length||t)a.pop(),s.push(e),n.add(e.name),t&&i.pop();else{i.push(a.length-1);for(const t of e.inputs)null==r[t.name]&&(r[t.name]=new Set),r[t.name].add(e.name),n.has(t.name)||a.push(t)}}return{sorted:s,recipientMap:r}}function qg(e){let t;if(1===e.sourceLayer.inboundNodes.length)t=e.sourceLayer.output;else{let n=null;for(let t=0;t<e.sourceLayer.inboundNodes.length;++t)for(const s of e.sourceLayer.inboundNodes[t].outputTensors)if(s.id===e.id){n=t;break}t=e.sourceLayer.getOutputAt(n)}return t}class Kg extends Gm{constructor(e){if(super({}),this.containerNodes=new Set,this.name=e.name,null==this.name){const e=this.getClassName().toLowerCase();this.name=Em(e)}if(this.supportsMasking=!1,this.trainable_=!0,Array.isArray(e.inputs)?this.inputs=e.inputs.slice():this.inputs=[e.inputs],Array.isArray(e.outputs)?this.outputs=e.outputs.slice():this.outputs=[e.outputs],nf(this.inputs).length!==this.inputs.length)throw new Wd(`The list of inputs passed to the model is redundant. All inputs should only appear once. Found: ${this.inputs.map((e=>e.name))}`);nf(this.outputs).length!==this.outputs.length&&console.warn(`The list of outputs passed to the model is redundant. All outputs should only appear once. Found: ${this.outputs.map((e=>e.name))}`),this.inputLayers=[],this.inputLayersNodeIndices=[],this.inputLayersTensorIndices=[],this.outputLayers=[],this.outputLayersNodeIndices=[],this.outputLayersTensorIndices=[],this.layers=[],this.internalContainerRefs=[];for(const e of this.outputs){const t=e.sourceLayer,n=e.nodeIndex,s=e.tensorIndex;this.outputLayers.push(t),this.outputLayersNodeIndices.push(n),this.outputLayersTensorIndices.push(s)}for(const e of this.inputs){const t=e.sourceLayer,n=e.nodeIndex,s=e.tensorIndex;Hd(0===n,"input layer has >1 nodes"),Hd(0===s,"input layer has >1 tensors"),this.inputLayers.push(t),this.inputLayersNodeIndices.push(n),this.inputLayersTensorIndices.push(s)}this.inputNames=[],this.outputNames=[],this.feedInputShapes=[],this.feedInputNames=[],this.feedOutputNames=[];for(let t=0;t<this.inputLayers.length;t++){const n=this.inputLayers[t];if(!(n instanceof jm))throw new TypeError(`Input layers to a LayersModel must be InputLayer objects. Received inputs: ${e.inputs}. Input ${t} (0-based) originates from layer type ${n.getClassName()}.`);this.inputNames.push(n.name),this.feedInputShapes.push(n.batchInputShape),this.feedInputNames.push(n.name)}for(const e of this.outputLayers)this.outputNames.push(e.name);this.internalInputShapes=this.inputs.map((e=>e.shape)),this.internalOutputShapes=this.outputs.map((e=>e.shape));const t={},n={},s={},r={},a={},i=[],o=(e,t,n,s,r,l)=>{null!=s&&null!=r&&null!=l||(s=e.sourceLayer,r=e.nodeIndex,l=e.tensorIndex);const u=s.inboundNodes[r];if(-1!==n.indexOf(u))throw new Pd(`The tensor ${e.name} at layer "${s.name}" is part of a cycle.`);if(-1!==t.indexOf(u))return;this.containerNodes.add(Kg.nodeKey(s,r)),s.id in a||(a[s.id]=Object.keys(a).length),-1===n.indexOf(u)&&n.push(u);const c=u.inboundLayers.length;for(let e=0;e<c;e++){const s=u.inputTensors[e],r=u.inboundLayers[e],a=u.nodeIndices[e],i=u.tensorIndices[e];o(s,t,n,r,a,i)}for(t.push(u);n.indexOf(u)>=0;)n.splice(n.indexOf(u),1);i.push(u)},l=[],u=[];for(const e of this.outputs)o(e,l,u);const c=i.slice().reverse();for(const e of c){n[e.id]=e,e.id in t||(t[e.id]=0);let a=t[e.id];const i=null==s[e.outboundLayer.id]?0:s[e.outboundLayer.id];a=Math.max(a,i),s[e.outboundLayer.id]=a,r[e.outboundLayer.id]=e.outboundLayer,t[e.id]=a;for(let s=0;s<e.inboundLayers.length;s++){const r=e.inboundLayers[s],i=e.nodeIndices[s],o=r.inboundNodes[i],l=null==t[o.id]?0:t[o.id];t[o.id]=Math.max(a+1,l),n[o.id]=o}}const h={};for(const e in t){const s=t[e];s in h||(h[s]=[]),h[s].push(n[e])}const p={};for(const e in s){const t=s[e];t in p||(p[t]=[]),p[t].push(r[e])}let d=Object.keys(p).map((e=>parseInt(e,10))).sort(tf);this.layers=[];for(const e of d){const t=p[e];t.sort(((e,t)=>{const n=a[e.id],s=a[t.id];return n<s?-1:n>s?1:0}));for(const e of t)e instanceof Kg&&this.internalContainerRefs.push(e),this.layers.push(e)}this.layersByDepth=p,d=Object.keys(h).map((e=>parseInt(e,10))).sort(tf);const f=this.inputs.slice(),m=[];for(const e of d)for(const t of h[e]){const e=t.outboundLayer;if(null!=e){for(const n of t.inputTensors)if(-1===f.indexOf(n))throw new Pd(`Graph disconnected: cannot obtain value for tensor ${n} at layer "${e.name}". The following previous layers were accessed without issue: ${m}`);for(const e of t.outputTensors)f.push(e);m.push(e.name)}}this.nodesByDepth=h;const g=this.layers.map((e=>e.name));for(const e of g){const t=g.filter((t=>t===e)).length;if(1!==t)throw new Pd(`The name "${e}" is used ${t} times in the model. All layer names should be unique. Layer names: `+JSON.stringify(g))}this.outboundNodes=[],this.inboundNodes=[],new Vm({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:this.inputs.map((e=>null)),outputMasks:this.outputs.map((e=>null)),inputShapes:this.inputs.map((e=>e.shape)),outputShapes:this.outputs.map((e=>e.shape))}),this.built=!0,this._refCount=1}assertNotDisposed(){if(0===this._refCount)throw new Error(`Container '${this.name}' is already disposed.`)}dispose(){this.assertNotDisposed();const e={refCountAfterDispose:null,numDisposedVariables:0};if(0==--this._refCount){for(const t of this.layers)e.numDisposedVariables+=t.dispose().numDisposedVariables;for(const t of this.internalContainerRefs)e.numDisposedVariables+=t.dispose().numDisposedVariables}return e.refCountAfterDispose=this._refCount,e}get trainable(){return this.trainable_}set trainable(e){this.layers.forEach((t=>{t._trainableWeights.forEach((t=>t.trainable=e))})),this.trainable_=e}get trainableWeights(){if(this._trainableWeights.length>0)throw new Wd("Container instance unexpectedly contains _trainableWeights.The trainable weights of a Container are a union of the trainable weights of its consituent Layers. Its own _trainableWeights must remain an empty Array.");if(!this.trainable)return[];let e=[];for(const t of this.layers)e=e.concat(t.trainableWeights);return e}get nonTrainableWeights(){const e=[];for(const t of this.layers)e.push(...t.nonTrainableWeights);if(!this.trainable){const t=[];for(const e of this.layers)t.push(...e.trainableWeights);return t.concat(e)}return e}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}loadWeights(e,t=!0){const n={};let s=0;for(const e of this.layers)for(const t of e.weights){if(null!=n[t.originalName])throw new Wd(`Duplicate weight name: ${t.originalName}`);n[t.originalName]=t,s++}const r=[];for(const s in e){let a=s;if(null==n[s]){const e=s.split("/");a=e.slice(0,-2).concat([e[e.length-1]]).join("/")}if(null!=n[a])r.push([n[a],e[s]]);else if(t)throw new Wd(`Provided weight data has no target variable: ${s}`);delete n[a]}if(t){const e=[];for(const t in n)e.push(t);if(e.length>0)throw new Wd(`${e.length} of ${s} weights are not set: ${e}`)}zm(r)}updatedConfig(){const e=this.getConfig(),t={};return t.className=this.getClassName(),t.config=e,t.kerasVersion="tfjs-layers 3.6.0",t.backend="TensorFlow.js",t}toJSON(e,t=!0){const n=Bg(this.updatedConfig());return t?JSON.stringify(n):n}call(e,t){return ii((()=>{e=Kd(e);const n=new Wg;for(let t=0;t<this.inputs.length;++t)n.add(this.inputs[t],e[t]);return Gg(this.outputs,n,t)}))}computeMask(e,t){return ii((()=>{let n;return e=Kd(e),n=null==t?Gd(null,e.length):Kd(t),this.runInternalGraph(e,n)[1]}))}computeOutputShape(e){const t=Rm(e);if(t.length!==this.inputLayers.length)throw new Wd(`Invalid inputShape argument ${e}: model has ${this.inputLayers.length} tensor inputs.`);const n={};for(let e=0;e<t.length;e++){const s=this.inputLayers[e],r=t[e];n[s.name+"_0_0"]=r}const s=Object.keys(this.nodesByDepth).map((e=>parseInt(e,10))).sort(tf);if(s.length>1)for(const e of s){const t=this.nodesByDepth[e];for(const e of t){const t=e.outboundLayer;if(-1!==this.inputLayers.map((e=>e.id)).indexOf(t.id))continue;const s=[];for(let t=0;t<e.inboundLayers.length;t++){const r=e.inboundLayers[t],a=e.nodeIndices[t],i=e.tensorIndices[t],o=n[`${r.name}_${a}_${i}`];s.push(o)}const r=Rm(t.computeOutputShape(qd(s))),a=t.inboundNodes.indexOf(e);for(let e=0;e<r.length;e++){n[`${t.name}_${a}_${e}`]=r[e]}}}const r=[],a=[];for(let e=0;e<this.outputLayers.length;e++){const t=this.outputLayers[e],n=this.outputLayersNodeIndices[e],s=this.outputLayersTensorIndices[e],r=`${t.name}_${n}_${s}`;a.push(r)}for(let e=0;e<a.length;e++){const t=a[e];Hd(t in n),r.push(n[t])}return qd(r)}runInternalGraph(e,t){null==t&&(t=Gd(null,e.length));const n={};for(let s=0;s<this.inputs.length;++s){const r=this.inputs[s],a=e[s],i=t[s];n[r.id]=[a,i]}const s=Object.keys(this.nodesByDepth).map((e=>parseInt(e,10))).sort(tf);for(const e of s){const t=this.nodesByDepth[e];for(const e of t){const t=e.outboundLayer,s=e.inputTensors,r=e.outputTensors,a=new Array;for(const e of s)e.id in n&&a.push(n[e.id]);if(a.length===s.length){let s,i,o,l,u={};if(null!=e.callArgs&&(u=e.callArgs),1===a.length){const[e,n]=a[0];null==u.mask&&(u.mask=n),o=Kd(t.call(e,u)),l=Kd(t.computeMask(e,n)),s=[e],i=[n]}else s=a.map((e=>e[0])),i=a.map((e=>e[1])),null==u.mask&&(u.mask=i),o=Kd(t.call(s,u)),l=Kd(t.computeMask(s,i));if(t.activityRegularizer)throw new Vd("LayersModel invocation with concrete Tensor value(s) in the presence of activity regularizer(s) is not supported yet.");for(let e=0;e<r.length;++e){const t=r[e],s=o[e],a=l[e];n[t.id]=[s,a]}}}}const r=[],a=[],i=[];for(const e of this.outputs){Hd(e.id in n,`Could not compute output ${e.name} : ${e.id}`);const[t,s]=n[e.id];i.push(t.shape),r.push(t),a.push(s)}return[r,a,i]}buildNodeConversionMap(e){const t={};let n;for(const e of this.layers){n=e instanceof Kg?1:0;for(let s=0;s<e.inboundNodes.length;s++){const r=Kg.nodeKey(e,s);this.containerNodes.has(r)&&(t[r]=n,n+=1)}}return t}getLayer(e,t){if(null!=t){if(this.layers.length<=t)throw new Wd(`Was asked to retrieve layer at index ${t}, but model only has ${this.layers.length} layer(s).`);return this.layers[t]}if(null==e)throw new Wd("Provide either a layer name or layer index");for(const t of this.layers)if(t.name===e)return t;throw new Wd(`No such layer: ${e}`)}calculateLosses(){return ii((()=>{const e=[];for(const t of this.layers)for(let n=0;n<t.inboundNodes.length;++n){const s=Kg.nodeKey(t,n);this.containerNodes.has(s)&&e.push(...t.calculateLosses())}return e}))}getConfig(){const e={name:this.name},t=this.buildNodeConversionMap(this.layers),n=[];for(const e of this.layers){const s=e.getClassName(),r=e.getConfig(),a=[];for(let n=0;n<e.inboundNodes.length;n++){const s=e.inboundNodes[n],r=Kg.nodeKey(e,n);let i={};if(this.containerNodes.has(r)){if(s.callArgs)try{JSON.stringify(s.callArgs),i=s.callArgs}catch(t){console.warn(`Layer ${e.name} was passed non-serializable keyword arguments: ${s.callArgs}. They will not be included in the serialized model (and thus will be missing at deserialization time).`),i={}}if(s.inboundLayers.length>0){const e=[];for(let n=0;n<s.inboundLayers.length;n++){const r=s.inboundLayers[n],a=s.nodeIndices[n],o=s.tensorIndices[n];let l=t[Kg.nodeKey(r,a)];null==l&&(l=0),e.push([r.name,l,o,i])}a.push(e)}}}const i={};i.name=e.name,i.className=s,i.config=r,i.inboundNodes=a,n.push(i)}e.layers=n;const s=[];for(let e=0;e<this.inputLayers.length;e++){const n=this.inputLayers[e],r=this.inputLayersNodeIndices[e],a=Kg.nodeKey(n,r);if(!this.containerNodes.has(a))continue;let i=t[a];null==i&&(i=0);const o=this.inputLayersTensorIndices[e];s.push([n.name,i,o])}e.inputLayers=s;const r=[];for(let e=0;e<this.outputLayers.length;e++){const n=this.outputLayers[e],s=this.outputLayersNodeIndices[e],a=Kg.nodeKey(n,s);if(!this.containerNodes.has(a))continue;let i=t[a];null==i&&(i=0);const o=this.outputLayersTensorIndices[e];r.push([n.name,i,o])}return e.outputLayers=r,e}static fromConfig(e,t,n={},s=!1){const r={},a={};function i(e,t){e.name in a?a[e.name].push(t):a[e.name]=[t]}function o(e,t){const n=[];let s;for(const a of t){const o=a[0],l=a[1],u=a[2];if(s=null==a[3]?{}:a[3],!(o in r))return void i(e,t);const c=r[o];if(c.inboundNodes.length<=l)return void i(e,t);const h=c.inboundNodes[l];n.push(h.outputTensors[u])}n.length>0&&e.apply(qd(n),s)}function l(e){const n=e.name,a=ag(e,null!=t.customObjects?t.customObjects:{});a.setFastWeightInitDuringBuild(s),r[n]=a;e.inboundNodes.forEach((e=>{if(!(e instanceof Array))throw new Wd(`Corrupted configuration, expected array for nodeData: ${e}`);i(a,e)}))}const u=t.name,c=t.layers;for(const e of c)l(e);for(;!sf(a);)for(const e of c){const t=r[e.name];if(t.name in a){const e=a[t.name];delete a[t.name];for(const n of e)o(t,n)}}const h=[],p=[],d=t.inputLayers;for(const e of d){const t=e[0],n=e[1],s=e[2];Hd(t in r);const a=r[t].inboundNodes[n].outputTensors;h.push(a[s])}const f=t.outputLayers;for(const e of f){const t=e[0],n=e[1],s=e[2];Hd(t in r);const a=r[t].inboundNodes[n].outputTensors;p.push(a[s])}return new e({inputs:h,outputs:p,name:u})}get stateful(){if(this._stateful)throw new Wd("Container instance unexpectedly has _stateful = true. The statefulness of a Container is determined by the Layers it contains. Its _stateful property must remain the default false.");for(const e of this.layers)if(e.stateful)return!0;return!1}resetStates(){ii((()=>{this.layers.forEach((e=>{e.stateful&&e.resetStates()}))}))}}function Xg(e,t,n){const s=t.length;if(null==e||Array.isArray(e)&&0===e.length)return t.map((e=>null));if(1===s)return Array.isArray(e)&&1===e.length?e:"object"==typeof e&&t[0]in e?[e[t[0]]]:[e];if(Array.isArray(e)){if(e.length!==s)throw new Error(`Provided ${n} is an array of ${e.length} element(s), but the model has ${s} outputs. Make sure a set of weights is provided for each model output.`);return e}if("object"==typeof e&&Object.keys(e).length>0&&"object"==typeof e[Object.keys(e)[0]]){const n=[];return t.forEach((t=>{t in e?n.push(e[t]):n.push(null)})),n}throw new Error(`The model has multiple (${s}) outputs, so ${n} must be either an array with ${s} elements or an object with ${t} keys. Provided ${n} not understood: ${JSON.stringify(e)}`)}function Yg(e,t){return Xg(e,t,"classWeight")}async function Jg(e,t,n,s){if(null!=t||null!=s)throw new Error("Support sampleWeight is not implemented yet");if(null!=n){const t=ii((()=>{if(1===e.shape.length)return e.clone();if(2===e.shape.length){if(e.shape[1]>1){const t=1;return e.argMax(t)}if(1===e.shape[1])return e.reshape([e.shape[0]]);throw new Error(`Encountered unexpected last-dimension size (${e.shape[1]}) during handling of class weights. The size is expected to be >= 1.`)}throw new Error(`Unexpected rank of target (y) tensor (${e.rank}) during handling of class weights. The rank is expected to be 1 or 2.`)})),s=Array.from(await t.data());oi(t);const r=[];return s.forEach((e=>{if(null==n[e])throw new Error(`classWeight must contain all classes in the training data. The class ${e} exists in the data but not in classWeight`);r.push(n[e])})),Zu(r,"float32")}return null}function Zg(e,t){return mi(e,t)}function Qg(e,t){let n,s;const r=t;n=r.xs,s=r.ys,l(null!=n&&null!=s,(()=>`A Dataset iterator for fitDataset() is expected to generate objects of the form \`{xs: xVal, ys: yVal}\`, where the two values may be \`tf.Tensor\`, an array of Tensors, or a map of string to Tensor.  The provided Dataset instead generates ${t}`));const a=ey("input",e.inputNames,n),i=ey("output",e.outputNames,s),o=a[0].shape[0];l(a.length===e.inputs.length,(()=>`LayersModel has ${e.inputs.length} inputs, but the dataset provides ${a.length} inputs.  (Expected input keys: ${JSON.stringify(e.inputNames)})`)),l(i.length===e.outputs.length,(()=>`LayersModel has ${e.outputs.length} outputs, but the dataset provides ${i.length} outputs.  (Expected output keys: ${JSON.stringify(e.outputNames)})`));for(let t=0;t<a.length;t++)l(a[t].shape[0]===o,(()=>`Batch size mismatch: input ${e.inputNames[t]} has ${a[t].shape[0]}; expected  ${o} based on input ${e.inputNames[0]}.`));for(let t=0;t<i.length;t++)l(i[t].shape[0]===o,(()=>`Batch size mismatch: output ${e.outputNames[t]} has ${i[t].shape[0]}; expected  ${o} based on input ${e.inputNames[0]}.`));return{xs:a,ys:i}}function ey(e,t,n){if(n instanceof Is)return[n];if(Array.isArray(n))return l(n.length===t.length,(()=>`Received an array of ${n.length} Tensors, but expected ${t.length} to match the ${e} keys ${t}.`)),n;{const s=[];for(const r of t){if(null==n[r])throw new Wd(`The feature data generated by the dataset lacks the required ${e} key '${r}'.`);s.push(n[r])}return s}}async function ty(e,t,n){const s=null!=n.batchesPerEpoch;if(l(null!=e.optimizer,(()=>"You must compile a model before training/testing. Use LayersModel.compile(modelCompileConfig).")),l(null!=n,(()=>"For fitDataset(), the 2nd argument (config) is required, but it is not provided in this call.")),l(null!=n.epochs&&n.epochs>0&&Number.isInteger(n.epochs),(()=>`For fitDataset(), config.epochs is expected to be a positive integer, but got ${n.epochs}`)),l(!s||n.batchesPerEpoch>0&&Number.isInteger(n.batchesPerEpoch),(()=>`For fitDataset(), config.batchesPerEpoch is expected to be a positive integer if specified, but got ${n.batchesPerEpoch}`)),l(null==n.validationSplit,(()=>"`validationSplit` is not supported by `fitDataset()`. Use validationData instead.")),e.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");e.isTraining=!0;try{const r=null!=n.validationData;let a,i;if(r)if(ny(n.validationData))l(null==n.validationBatches||n.validationBatches>0&&Number.isInteger(n.validationBatches),(()=>`For fitDataset() with dataset-based validation, config.validationBatches is expected not to be provided, or to be a positive integer, but got ${n.validationBatches}`));else{const e=function(e){if(3===e.length)throw new Vd("Validation with sample weights is not implemented yet.");return{xs:e[0],ys:e[1]}}(n.validationData);a=e.xs,i=e.ys}const o=e.makeTrainFunction(),u=e.getDedupedMetricsNames();let c;c=r?u.slice().concat(u.map((e=>"val_"+e))):u.slice();const h=ng(n.callbacks,n.yieldEvery),p=null==n.verbose?1:n.verbose,{callbackList:d,history:f}=rg(h,p,n.epochs,null,null,function(e,t){let n=null;null!=t.batchesPerEpoch?n=t.batchesPerEpoch:Number.isFinite(e.size)&&(n=e.size);return n}(t,n),null,r,c);d.setModel(e),e.history=f,await d.onTrainBegin(),e.stopTraining_=!1;let m=null==n.initialEpoch?0:n.initialEpoch,g=await t.iterator();for(;m<n.epochs;){const l={};await d.onEpochBegin(m);let c=0,h=0;for(s||(g=await t.iterator());!s||c<n.batchesPerEpoch;){const t=await g.next();if(s&&t.done){console.warn(`You provided \`batchesPerEpoch\` as ${n.batchesPerEpoch}, but your dataset iterator ran out of data after ${c} batches; interrupting training. Make sure that your dataset can generate at least \`batchesPerEpoch * epochs\` batches (in this case, `+n.batchesPerEpoch*n.epochs+" batches). You may need to use the repeat() function when building your dataset.");break}if(null!=t.value){const{xs:s,ys:r}=Qg(e,t.value),a={};a.batch=h,a.size=s[0].shape[0],await d.onBatchBegin(h,a);const i=[];if(null!=n.classWeight){const t=Yg(n.classWeight,e.outputNames);for(let e=0;e<t.length;++e)i.push(await Jg(r[e],null,t[e]))}const l=s.concat(r).concat(i),p=o(l);oi(l);for(let e=0;e<u.length;++e){const t=u[e],n=p[e];a[t]=n,li(n)}await d.onBatchEnd(h,a),Xm(a),h++,c++}if(s?c>=n.batchesPerEpoch:t.done){if(r){let t;t=ny(n.validationData)?Kd(await e.evaluateDataset(n.validationData,{batches:n.validationBatches})):Kd(e.evaluate(a,i,{batchSize:null==n.validationBatchSize?32:n.validationBatchSize,verbose:0}));for(let n=0;n<e.metricsNames.length;++n)l[`val_${e.metricsNames[n]}`]=t[n]}break}if(e.stopTraining_)break}if(await d.onEpochEnd(m,l),m++,e.stopTraining_)break}return await d.onTrainEnd(),await e.history.syncData(),e.history}finally{e.isTraining=!1}}function ny(e){return"function"==typeof e.iterator}function sy(e){l(e>0&&Number.isInteger(e),(()=>`batchSize is required to be a positive integer, but got ${e}`))}function ry(e,t,n){return null==e?[null]:Array.isArray(e)?e.map((e=>Uf(e,t,n-t))):Uf(e,t,n-t)}function ay(e,t){return ii((()=>null==e?null:Array.isArray(e)?e.map((e=>ay(e,t))):Jf(e,"int32"===t.dtype?t:t.toInt())))}function iy(e,t){const n=[];let s=0,r=null;for(;s<e;)r=s+t,r>=e&&(r=e),n.push([s,r]),s=r;return n}async function oy(e,t,n,s={}){if(e.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");let a,i,o,l,u,c,h;e.isTraining=!0;try{const p=null==s.batchSize?32:s.batchSize;sy(p);const d=!1,f=await e.standardizeUserData(t,n,s.sampleWeight,s.classWeight,d,p);a=f[0],i=f[1],h=f[2];let m,g=!1;if(null!=s.validationData&&s.validationData.length>0){if(g=!0,2!==s.validationData.length)throw 3===s.validationData.length?new Vd("validationData including sample weights is not supported yet."):new Wd(`When passing validation data, it must contain 2 (valX, valY) or 3 (valX, valY, valSampleWeight) items; ${s.validationData} is invalid.`);o=s.validationData[0],l=s.validationData[1];const t=!0,n=await e.standardizeUserData(o,l,null,null,t,p);u=n[0],c=n[1],m=u.concat(c)}else if(null!=s.validationSplit&&s.validationSplit>0&&s.validationSplit<1){g=!0;const e=Math.floor(a[0].shape[0]*(1-s.validationSplit)),t=a[0].shape[0];u=ry(a,e,t),a=ry(a,0,e),c=ry(i,e,t),i=ry(i,0,e),m=u.concat(c)}else null!=s.validationSteps&&(g=!0);const y=a.concat(i).concat(h);e.checkTrainableWeightsConsistency();const b=e.makeTrainFunction(),x=e.getDedupedMetricsNames();let w,k;g?(e.makeTestFunction(),w=e.testFunction,k=x.slice().concat(x.map((e=>"val_"+e)))):(w=null,m=[],k=x.slice());const v=ng(s.callbacks,s.yieldEvery);return await async function(e,t,n,s,a,i,o,l,u,c,h,p,d,f,m){null==a&&(a=32),null==i&&(i=1),null==h&&(h=!0),null==d&&(d=0);let g=!1;if(null!=u&&null!=c&&(g=!0),null!=m&&(g=!0,null==f))throw new Wd("Can only use `validationSteps` when doing step-wise training, i.e., `stepsPerEpoch` must be set.");const y=e.checkNumSamples(n,a,f,"steps_per_epoch");let b;null!=y&&(b=Pf(0,y)),null==o&&(o=1);const{callbackList:x,history:w}=rg(l,o,i,d,y,f,a,g,p);x.setModel(e),e.history=w,await x.onTrainBegin(),e.stopTraining_=!1;for(let o=d;o<i;++o){await x.onEpochBegin(o);const i={};if(null!=f)throw new Vd("stepsPerEpoch mode is not implemented yet.");{if("batch"===h)throw new Vd("batch shuffling is not implemneted yet");h&&r(b);const o=Zu(b),l=iy(y,a);for(let r=0;r<l.length;++r){const h={};if(await x.onBatchBegin(r,h),ii((()=>{const p=l[r][0],d=l[r][1],f=Uf(o,p,d-p);h.batch=r,h.size=d-p;const m=ay(n,f),y=t(m);for(let e=0;e<s.length;++e){const t=s[e],n=y[e];h[t]=n,li(n)}if(r===l.length-1&&g){const t=e.testLoop(u,c,a);for(let e=0;e<s.length;++e){const n=s[e],r=t[e];li(r),i["val_"+n]=r}}})),await x.onBatchEnd(r,h),Xm(h),e.stopTraining_)break}o.dispose()}if(await x.onEpochEnd(o,i),e.stopTraining_)break}return await x.onTrainEnd(),await e.history.syncData(),e.history}(e,b,y,x,p,s.epochs,s.verbose,v,w,m,s.shuffle,k,s.initialEpoch,null,null)}finally{e.isTraining=!1,uy(a,t),uy(i,n),uy(u,o),uy(c,l),null!=h&&oi(h)}}function ly(e){const t=[];e instanceof Is&&(e=[e]);for(let n=0;n<e.length;++n){const s=e[n];if(1===s.rank)t.push(Vf(s,1));else{if(0===s.rank)throw new Error("Expected tensor to be at least 1D, but received a 0D tensor (scalar).");t.push(s)}}return t}function uy(e,t){if(null==e)return;const n=[];if(t instanceof Is)n.push(t.id);else if(Array.isArray(t))t.forEach((e=>n.push(e.id)));else if(null!=t)for(const e in t){const s=t[e];n.push(s.id)}const s=[];if(e instanceof Is)-1===n.indexOf(e.id)&&s.push(e);else if(Array.isArray(e))e.forEach((e=>{-1===n.indexOf(e.id)&&s.push(e)}));else if(null!=e)for(const t in e){const r=e[t];-1===n.indexOf(r.id)&&s.push(r)}s.forEach((e=>{e.isDisposed||e.dispose()}))}function cy(e){return Array.isArray(e)}function hy(e){return!function(e){return e instanceof Is}(e)&&!cy(e)}function py(e,t,n,s=!0,r=""){if(null==t||0===t.length){if(null!=e){let t=!1;if(cy(e)&&e.length>0)t=!0;else if(hy(e)){for(const n in e)if(e.hasOwnProperty(n)){t=!0;break}}else t=!0;if(t)throw new Wd(`Error when checking model ${r} expected no data, but got ${e}`)}return[]}if(null==e)return t.map((e=>null));let a;if(hy(e)){e=e,a=[];for(const n of t){if(null==e[n])throw new Wd(`No data provided for "${n}". Need data for each key in: ${t}`);a.push(e[n])}}else if(cy(e)){if((e=e).length!==t.length)throw new Wd(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the model expected. Expected to see ${t.length} Tensor(s), but instead got the following list of Tensor(s): ${e}`);a=e}else{if(e=e,t.length>1)throw new Wd(`The model ${r} expects ${t.length} Tensor(s), but only received one Tensor. Found: Tensor with shape ${e.shape}`);a=[e]}if(a=ly(a),null!=n)for(let e=0;e<t.length;++e){if(null==n[e])continue;const i=a[e];if(i.shape.length!==n[e].length)throw new Wd(`Error when checking ${r}: expected ${t[e]} to have ${n[e].length} dimension(s). but got array with shape ${i.shape}`);for(let a=0;a<n[e].length;++a){if(0===a&&!s)continue;const o=i.shape[a],l=n[e][a];if(null!=l&&l>=0&&o!==l)throw new Wd(`Error when checking ${r}: expected ${t[e]} to have shape [${n[e]}], but got array with shape [${i.shape}].`)}}return a}function dy(e,t,n,s=!0,r=""){let a;if(Array.isArray(e)){if(e.length!==t.length)throw new Wd(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the the model expected. Expected to see ${t.length} Tensor(s), but instead got ${e.length} Tensors(s).`);a=e}else{if(t.length>1)throw new Wd(`The model expects ${t.length} ${r} Tensors, but only received one Tensor. Found: array with shape ${JSON.stringify(e.shape)}.`);a=[e]}if(null!=n)for(let e=0;e<t.length;++e){if(null==n[e])continue;const i=a[e];if(i.shape.length!==n[e].length)throw new Wd(`Error when checking ${r}: expected ${t[e]} to have ${n[e].length} dimension(s), but got array with shape ${JSON.stringify(i.shape)}`);for(let a=0;a<n[e].length;++a){if(0===a&&!s)continue;const o=i.shape[a],l=n[e][a];if(null!=l&&l!==o)throw new Wd(`Error when checking ${r}: expected ${t[e]} to have shape ${JSON.stringify(n[e])} but got array with shape ${JSON.stringify(i.shape)}.`)}}}class fy extends Kg{constructor(e){super(e),this.isTraining=!1}summary(e,t,n=console.log){if(!this.built)throw new Wd("This model has never been called, thus its weights have not been created yet. So no summary can be displayed. Build the model first (e.g., by calling it on some test data).");Dg(this,e,t,n)}compile(e){if(null==e.loss&&(e.loss=[]),this.loss=e.loss,"string"==typeof e.optimizer)this.optimizer_=function(e){const t={Adagrad:()=>_h.adagrad(.01),Adadelta:()=>_h.adadelta(1,.95,zd()),Adam:()=>_h.adam(.001,.9,.999,zd()),Adamax:()=>_h.adamax(.002,.9,.999,zd(),0),RMSProp:()=>_h.rmsprop(.001,.9,0,zd()),SGD:()=>_h.sgd(.01)};if(t.adagrad=t.Adagrad,t.adadelta=t.Adadelta,t.adam=t.Adam,t.adamax=t.Adamax,t.rmsprop=t.RMSProp,t.sgd=t.SGD,e in t)return t[e]();throw new Wd(`Unknown Optimizer ${e}`)}(e.optimizer),this.isOptimizerOwned=!0;else{if(!(e.optimizer instanceof $h))throw new Wd("User-defined optimizer must be an instance of tf.Optimizer.");this.optimizer_=e.optimizer,this.isOptimizerOwned=!1}let t=[];if(Array.isArray(e.loss)||"string"==typeof e.loss||"function"==typeof e.loss)if(Array.isArray(e.loss)){if(e.loss.length!==this.outputs.length)throw new Wd(`When passing an Array as loss, it should have one entry per model output. The model has ${this.outputs.length} output(s), but you passed loss=${e.loss}.`);const n=e.loss;t=n.map((e=>yg(e)))}else{const n=yg(e.loss);this.outputs.forEach((e=>{t.push(n)}))}else{e.loss=e.loss;for(const t in e.loss)if(-1===this.outputNames.indexOf(t))throw new Wd(`Unknown entry in loss dictionary: "${t}". Only expected the following keys: ${this.outputNames}`);for(const n of this.outputNames)null==e.loss[n]&&console.warn(`Output "${n}" is missing from loss dictionary. We assume this was done on purpose, and we will not be expecting data to be passed to ${n} during training`),t.push(yg(e.loss[n]))}this.lossFunctions=t,this.feedOutputNames=[],this.feedOutputShapes=[],this.feedLossFns=[];for(let e=0;e<this.outputs.length;++e){const t=this.internalOutputShapes[e],n=this.outputNames[e];this.feedOutputNames.push(n),this.feedOutputShapes.push(t),this.feedLossFns.push(this.lossFunctions[e])}const n=[];this.metrics=e.metrics,this.metricsNames=["loss"],this.metricsTensors=[],Rf("loss",(()=>{for(let e=0;e<this.outputs.length;++e){if(-1!==n.indexOf(e))continue;const t=this.lossFunctions[e];this.outputs.length>1&&(this.metricsTensors.push([t,e]),this.metricsNames.push(this.outputNames[e]+"_loss"))}}));const s=function(e,t){if(null==e||Array.isArray(e)&&0===e.length)return t.map((e=>[]));let n;if("string"==typeof e||"function"==typeof e)n=[e];else{if(!Array.isArray(e)&&"object"!=typeof e)throw new TypeError(`Type of metrics argument not understood. Expected an string,function, Array, or Object, found: ${e}`);n=e}if(Array.isArray(n))return t.map((e=>n));{const e=[];for(const s of t){let t=n.hasOwnProperty(s)?n[s]:[];Array.isArray(t)||(t=[t]),e.push(t)}return e}}(e.metrics,this.outputNames),r=(e,t,n)=>{this.outputNames.length>1&&(t=this.outputNames[e]+"_"+t),this.metricsNames.push(t),this.metricsTensors.push([n,e])};Rf("metric",(()=>{for(let e=0;e<this.outputs.length;++e){if(-1!==n.indexOf(e))continue;(t=>{let n,s,a;for(const i of t){if("string"==typeof i&&-1!==["accuracy","acc","crossentropy","ce"].indexOf(i)){const t=this.internalOutputShapes[e];let r;1===t[t.length-1]||this.lossFunctions[e]===dg?-1!==["accuracy","acc"].indexOf(i)?s=bg:-1!==["crossentropy","ce"].indexOf(i)&&(s=Ng):this.lossFunctions[e]===pg?-1!==["accuracy","acc"].indexOf(i)?s=Ig:-1!==["crossentropy","ce"].indexOf(i)&&(s=Cg):-1!==["accuracy","acc"].indexOf(i)?s=xg:-1!==["crossentropy","ce"].indexOf(i)&&(s=$g),-1!==["accuracy","acc"].indexOf(i)?r="acc":-1!==["crossentropy","ce"].indexOf(i)&&(r="ce"),a=s,n=""+r}else{const e=Tg(i);a=e,n=""+Eg(i)}let t;Rf(n,(()=>{t=a})),r(e,n,t)}})(s[e])}})),this.collectedTrainableWeights=this.trainableWeights}checkTrainableWeightsConsistency(){null!=this.collectedTrainableWeights&&this.trainableWeights.length!==this.collectedTrainableWeights.length&&console.warn("Discrepancy between trainableweights and collected trainable weights. Did you set `model.trainable` without calling `model.compile()` afterwards?")}evaluate(e,t,n={}){const s=null==n.batchSize?32:n.batchSize;sy(s);const r=this.standardizeUserDataXY(e,t,!0,s);try{const a=r[0].concat(r[1]);this.makeTestFunction();const i=this.testFunction;return qd(this.testLoop(i,a,s,n.verbose,n.steps))}finally{uy(r[0],e),uy(r[1],t)}}async evaluateDataset(e,t){return this.makeTestFunction(),async function(e,t,n){const s=null!=(n=n||{}).batches,r=e.testFunction;let a=[];if(n.verbose>0)throw new Vd("Verbose mode is not implemented yet.");l(!s||n.batches>0&&Number.isInteger(n.batches),(()=>`Test loop expects \`batches\` to be a positive integer, but received ${JSON.stringify(n.batches)}`));const i="function"==typeof t.next?t:await t.iterator();let o=0,u=0;for(;!s||u<n.batches;){const t=await i.next();if(a=ii((()=>{if(t.value){const{xs:n,ys:s}=Qg(e,t.value),i=n.concat(s),l=ii((()=>r(i)));if(oi(i),0===u)for(let e=0;e<l.length;++e)a.push(Tu(0));const c=i[0].shape[0];for(let e=0;e<l.length;++e){const t=l[e],n=a[e];a[e]=ii((()=>pi(a[e],mi(c,t)))),u>0&&oi(n)}oi(l),o+=c,++u}return a})),t.done){s&&console.warn(`Your dataset iterator ran out of data during evaluateDataset(). Interrupting evalution. Make sure that your dataset can generate at least \`batches\` batches (in this case, ${n.batches} batches). You may need to use the repeat() function when building your dataset.`);break}}for(let e=0;e<a.length;++e){const t=a[e];a[e]=fi(a[e],o),oi(t)}return qd(a)}(this,e,t)}checkNumSamples(e,t,n,s="steps"){let r;if(null!=n){if(r=null,null!=t)throw new Wd(`If ${s} is set, batchSize must be null or undefined.Got batchSize = ${t}`)}else{if(null==e)throw new Wd(`Either the input data should have a defined shape, or ${s} shoud be specified.`);r=Array.isArray(e)?e[0].shape[0]:e.shape[0]}return r}execute(e,t){if(Array.isArray(t)&&0===t.length)throw new Wd("`outputs` is an empty Array, which is not allowed.");const n=Array.isArray(t),s=n?t:[t],r=this.retrieveSymbolicTensors(s),a=new Wg;if(e instanceof Is&&(e=[e]),Array.isArray(e)){if(e.length!==this.inputs.length)throw new Wd(`The number of inputs provided (${e.length}) does not match the number of inputs of this model (${this.inputs.length}).`);for(let t=0;t<this.inputs.length;++t)a.add(this.inputs[t],e[t])}else for(const t of this.inputs){const n=e[t.name];if(null==n)throw new Wd(`No value is provided for the model's input ${t.name}`);a.add(t,n)}const i=Gg(r,a);return n?i:i[0]}retrieveSymbolicTensors(e){const t=Gd(null,e.length);let n=e.length;for(const s of this.layers){const r=Array.isArray(s.output)?s.output:[s.output],a=r.map((e=>e.name));for(let s=0;s<e.length;++s){const i=a.indexOf(e[s]);if(-1!==i&&(t[s]=r[i],n--),0===n)break}if(0===n)break}if(n>0){const n=[];throw t.forEach(((t,s)=>{null==t&&n.push(e[s])})),new Wd(`Cannot find SymbolicTensors for output name(s): ${JSON.stringify(n)}`)}return t}predictLoop(e,t=32,n=!1){return ii((()=>{const s=this.checkNumSamples(e);if(n)throw new Vd("Verbose predictLoop() is not implemented yet.");const r=iy(s,t),a=this.outputs.map((e=>[]));for(let t=0;t<r.length;++t){ii((()=>{const n=r[t][0],s=r[t][1],a=ry(e,n,s),i=[];if(Array.isArray(a))for(let e=0;e<a.length;++e)i.push({key:this.inputs[e],value:a[e]});else i.push({key:this.inputs[0],value:a});const o=new Wg(i);return Gg(this.outputs,o)})).forEach(((e,t)=>a[t].push(e)))}return qd(a.map((e=>Hi(e,0))))}))}predict(e,t={}){const n=ly(e);dy(n,this.inputNames,this.feedInputShapes,!1);try{const s=null==t.batchSize?32:t.batchSize;return sy(s),this.predictLoop(n,s)}finally{uy(n,e)}}predictOnBatch(e){dy(e,this.inputNames,this.feedInputShapes,!0);const t=(Array.isArray(e)?e[0]:e).shape[0];return this.predictLoop(e,t)}standardizeUserDataXY(e,t,n=!0,s){if(null==this.optimizer_)throw new Pd("You must compile a model before training/testing. Use LayersModel.compile(modelCompileArgs).");const r=[];for(let e=0;e<this.feedOutputShapes.length;++e){const t=this.feedOutputShapes[e];this.feedLossFns[e]===pg?r.push(t.slice(0,t.length-1).concat([1])):r.push(t)}if(function(e,t,n){const s=nf(e.map((e=>e.shape[0])));s.sort();const r=nf(t.map((e=>e.shape[0])));if(r.sort(),s.length>1)throw new Wd(`All input Tensors (x) should have the same number of samples. Got array shapes: ${JSON.stringify(e.map((e=>e.shape)))}`);if(r.length>1)throw new Wd(`All target Tensors (y) should have the same number of samples. Got array shapes: ${JSON.stringify(t.map((e=>e.shape)))}`);if(s.length>0&&r.length>0&&!d(s,r))throw new Wd(`Input Tensors should have the same number of samples as target Tensors. Found ${s[0]} input sample(s) and ${r[0]} target sample(s).`)}(e=py(e,this.feedInputNames,this.feedInputShapes,!1,"input"),t=py(t,this.feedOutputNames,r,!1,"target")),function(e,t,n){const s=[og,dg,hg];for(let r=0;r<e.length;++r){const a=e[r],i=t[r],o=n[r];if(null!=i){if(i===hg&&1===a.shape[a.shape.length-1])throw new Wd(`You are passing a target array of shape ${a.shape} while using a loss 'categorical_crossentropy'. 'categorical_crossentropy'expects targets to be binary matrices (1s and 0s) of shape [samples, classes].`);if(-1!==s.indexOf(i)){const e=a.shape.slice(1),t=o.slice(1);for(let n=0;n<e.length;++n){const s=e[n],r=t[n];if(null!=r&&s!==r)throw new Wd(`A target Tensor with shape ${a.shape} was passed for an output of shape ${o}, while using a loss function that expects targets to have the same shape as the output.`)}}}}}(t,this.feedLossFns,this.feedOutputShapes),this.stateful&&null!=s&&s>0&&e[0].shape[0]%s!=0)throw new Wd(`In a stateful network, you should only pass inputs with a number of samples that is divisible by the batch size ${s}. Found: ${e[0].shape[0]} sample(s).`);return[e,t]}async standardizeUserData(e,t,n,s,r=!0,a){const[i,o]=this.standardizeUserDataXY(e,t,r,a);if(null!=n)throw new Error("sample weight is not supported yet.");let l=null;if(null!=s){const e=Yg(s,this.outputNames);l=[];for(let t=0;t<e.length;++t)l.push(await Jg(o[t],null,e[t]))}return[i,o,l]}testLoop(e,t,n,s=0,r){return ii((()=>{const a=this.checkNumSamples(t,n,r,"steps"),i=[];if(s>0)throw new Vd("Verbose mode is not implemented yet.");if(null!=r)throw new Vd("steps mode in testLoop() is not implemented yet");{const s=iy(a,n),r=Zu(Pf(0,a));for(let n=0;n<s.length;++n){const a=s[n][0],o=s[n][1],l=Uf(r,a,o-a),u=ay(t,l),c=e(u);if(0===n)for(let e=0;e<c.length;++e)i.push(Tu(0));for(let e=0;e<c.length;++e){const t=c[e];i[e]=pi(i[e],mi(o-a,t))}}for(let e=0;e<i.length;++e)i[e]=fi(i[e],a)}return i}))}getDedupedMetricsNames(){const e=this.metricsNames,t=[];for(let n=0;n<e.length;++n){const s=e[n];let r=s;if(jd(e,s)>1){r+=`_${jd(e.slice(0,n),s)}`}t.push(r)}return t}makeTrainFunction(){return e=>{const t=[],n=e.slice(0,this.inputs.length),s=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),r=e.slice(this.inputs.length+this.outputs.length,this.inputs.length+2*this.outputs.length),a=[],i=this.collectedTrainableWeights.map((e=>e.read()));return[this.optimizer_.minimize((()=>{const e=[];for(let t=0;t<this.inputs.length;++t)e.push({key:this.inputs[t],value:n[t]});const i=new Wg(e),o=Gg(this.outputs,i,{training:!0});let l;for(let e=0;e<this.lossFunctions.length;++e){let n=(0,this.lossFunctions[e])(s[e],o[e]);null!=r[e]&&(n=Zg(n,r[e]));const a=Al(n);t.push(a),l=0===e?n:pi(l,n)}for(let e=0;e<this.metricsTensors.length;++e){let n;if(this.outputs.length>1&&e<this.outputs.length)n=t[e];else{const t=this.metricsTensors[e][0],r=this.metricsTensors[e][1];n=Al(t(s[r],o[r]))}li(n),a.push(n)}return l=Al(l),this.calculateLosses().forEach((e=>{l=pi(l,e)})),l}),!0,i)].concat(a)}}makeTestFunction(){this.testFunction=e=>ii((()=>{const t=[];let n;const s=e.slice(0,this.inputs.length),r=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),a=[];for(let e=0;e<this.inputs.length;++e)a.push({key:this.inputs[e],value:s[e]});const i=new Wg(a),o=Gg(this.outputs,i);for(let e=0;e<this.lossFunctions.length;++e){const s=this.lossFunctions[e],a=Al(s(r[e],o[e]));n=0===e?a:pi(n,a),t.push(n)}for(let e=0;e<this.metricsTensors.length;++e){const n=this.metricsTensors[e][0],s=this.metricsTensors[e][1],a=Al(n(r[s],o[s]));t.push(a)}return t}))}async fit(e,t,n={}){return oy(this,e,t,n)}async fitDataset(e,t){return ty(this,e,t)}async trainOnBatch(e,t){const n=await this.standardizeUserData(e,t),s=n[0],r=n[1],a=this.makeTrainFunction()(s.concat(r)),i=[];for(const e of a){const t=await e.data();i.push(t[0])}return oi(a),qd(i)}getNamedWeights(e){const t=[],n=null!=e&&e.trainableOnly,s=n?this.trainableWeights:this.weights,r=this.getWeights(n);for(let e=0;e<s.length;++e)n&&!s[e].trainable||t.push({name:s[e].originalName,tensor:r[e]});return t}set stopTraining(e){this.stopTraining_=e}get stopTraining(){return this.stopTraining_}get optimizer(){return this.optimizer_}set optimizer(e){this.optimizer_!==e&&(this.optimizer_=e,this.isOptimizerOwned=!1)}dispose(){const e=super.dispose();if(0===e.refCountAfterDispose&&null!=this.optimizer&&this.isOptimizerOwned){const t=ai().numTensors;this.optimizer_.dispose(),e.numDisposedVariables+=t-ai().numTensors}return e}getLossIdentifiers(){let e;if("string"==typeof this.loss)e=Xd(this.loss);else if(Array.isArray(this.loss)){for(const e of this.loss)if("string"!=typeof e)throw new Error("Serialization of non-string loss is not supported.");e=this.loss.map((e=>Xd(e)))}else{const t=Object.keys(this.loss);e={};const n=this.loss;for(const s of t){if("string"!=typeof n[s])throw new Error("Serialization of non-string loss is not supported.");e[s]=Xd(n[s])}}return e}getMetricIdentifiers(){if("string"==typeof this.metrics||"function"==typeof this.metrics)return[Xd(Eg(this.metrics))];if(Array.isArray(this.metrics))return this.metrics.map((e=>Xd(Eg(e))));{const e={};for(const t in this.metrics)e[t]=Xd(Eg(this.metrics[t]));return e}}getTrainingConfig(){return{loss:this.getLossIdentifiers(),metrics:this.getMetricIdentifiers(),optimizer_config:{class_name:this.optimizer.getClassName(),config:this.optimizer.getConfig()}}}loadTrainingConfig(e){if(null!=e.weighted_metrics)throw new Error("Loading weight_metrics is not supported yet.");if(null!=e.loss_weights)throw new Error("Loading loss_weights is not supported yet.");if(null!=e.sample_weight_mode)throw new Error("Loading sample_weight_mode is not supported yet.");const t=ag(zg(e.optimizer_config));let n,s;if("string"==typeof e.loss)n=Yd(e.loss);else if(Array.isArray(e.loss))n=e.loss.map((e=>Yd(e)));else if(null!=e.loss){n={};for(const t in e.loss)n[t]=Yd(e.loss[t])}if(Array.isArray(e.metrics))s=e.metrics.map((e=>Yd(e)));else if(null!=e.metrics){s={};for(const t in e.metrics)s[t]=Yd(e.metrics[t])}this.compile({loss:n,metrics:s,optimizer:t})}async save(e,t){if("string"==typeof e){const t=br(e);if(0===t.length)throw new Wd(`Cannot find any save handlers for URL '${e}'`);if(t.length>1)throw new Wd(`Found more than one (${t.length}) save handlers for URL '${e}'`);e=t[0]}if(null==e.save)throw new Wd("LayersModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");const n=await lr(this.getNamedWeights(t)),s={modelTopology:this.toJSON(null,!1),format:"layers-model",generatedBy:"TensorFlow.js tfjs-layers v3.6.0",convertedBy:null};if(null!=t&&t.includeOptimizer&&null!=this.optimizer){s.trainingConfig=this.getTrainingConfig();const e="optimizer",{data:t,specs:r}=await lr(await this.optimizer.getWeights(),e);n.specs.push(...r),n.data=dr([n.data,t])}if(null!=this.userDefinedMetadata){const e=!0;Rg(this.userDefinedMetadata,this.name,e),s.userDefinedMetadata=this.userDefinedMetadata}return s.weightData=n.data,s.weightSpecs=n.specs,e.save(s)}setUserDefinedMetadata(e){Rg(e,this.name),this.userDefinedMetadata=e}getUserDefinedMetadata(){return this.userDefinedMetadata}}fy.className="Model",Xa(fy);class my extends fy{}async function gy(e,t){if(null==t&&(t={}),"string"==typeof e){const n=xr(e,t);if(0===n.length)n.push(ua(e,t));else if(n.length>1)throw new Wd(`Found more than one (${n.length}) load handlers for URL '${e}'`);e=n[0]}return async function(e,t,n){null==n&&(n={});if(null==e.load)throw new Wd("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const s=await e.load();let r=s.modelTopology;null!=r.model_config&&(r=r.model_config);const a=null==n.strict||n.strict,i=null!=s.weightData&&null!=s.weightSpecs&&a,o=ag(zg(r),t,i),l=s.trainingConfig;null!=l&&o.loadTrainingConfig(l);null!=s.userDefinedMetadata&&o.setUserDefinedMetadata(s.userDefinedMetadata);if(null!=s.weightData){if(null==s.weightSpecs)throw new Wd("LayersModel artifacts contains weight data, but not weight specs. Therefore loading of weights cannot proceed.");const{modelWeights:e,optimizerWeights:t}=function(e,t){const n=ur(e,t),s={},r=[];return t.forEach((e=>{"optimizer"===e.group?r.push({name:e.name,tensor:n[e.name]}):s[e.name]=n[e.name]})),{modelWeights:s,optimizerWeights:r}}(s.weightData,s.weightSpecs);o.loadWeights(e,a),null!=o.optimizer&&t.length>0&&await o.optimizer.setWeights(t),oi(e),oi(t.map((e=>e.tensor)))}return o}(e,void 0,t)}my.className="Functional",Xa(my);class yy extends fy{constructor(e){if(super({inputs:[],outputs:[]}),e=e||{},this.trainable=!0,this.built=!1,this.name=null!=e.name?e.name:Em("sequential_"),null!=e.layers)for(const t of e.layers)this.add(t)}checkShape(e){if(e.inboundNodes[0].outputTensors[0].shape.some((e=>e<0)))throw new Wd(`Negative dimension size caused by adding layer ${e.name} with input shape [${e.inboundNodes[0].inputTensors[0].shape}]`)}add(e){const t=e instanceof yy||e instanceof fy;let n;if(t){if(n=e,1!==n.outputs.length)throw new Wd("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");if(1!==n.inputs.length)throw new Wd("All layers in a Sequential model should have a single input tensor. For multi-input layers, use the functional API.")}if(0===this.outputs.length){if(0===e.inboundNodes.length){if(null==e.batchInputShape)throw new Wd("The first layer in a Sequential model must get an `inputShape` or `batchInputShape` argument.");const t=qm({batchShape:e.batchInputShape,dtype:e.dtype,name:e.name+"_input"});e.apply(t)}if(t)this.outputs=n.outputs,this.inputs=n.inputs;else{if(1!==e.inboundNodes.length)throw new Wd(`A layer added to a Sequential model must not already be connected somewhere else. LayersModel received layer ${e.name} which has ${e.inboundNodes.length} pre-existing inbound connections.`);if(1!==e.inboundNodes[0].outputTensors.length)throw new Wd("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(e),this.outputs=[e.inboundNodes[0].outputTensors[0]],this.inputs=Hm(this.outputs[0])}this.inboundNodes=[],new Vm({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:Gd(null,this.inputs.length),outputMasks:[null],inputShapes:this.inputs.map((e=>e.shape)),outputShapes:this.outputs[0].shape})}else{const t=e.apply(this.outputs[0]);if(Array.isArray(t))throw new TypeError("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(e),this.outputs=[t],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}this.layers.push(e),this.built=!1}pop(){if(0===this.layers.length)throw new TypeError("There are no layers in the model.");if(this.layers.pop(),0===this.layers.length)this.outputs=[],this.inboundNodes=[],this.outboundNodes=[];else{const e=this.layers.length-1;this.layers[e].outboundNodes=[],this.outputs=[this.layers[e].output],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}}call(e,t){return null==this.model&&this.build(),this.model.call(e,t)}build(e){if(Dm(e),0===this.inputs.length||0===this.outputs.length)throw new TypeError("Sequential model cannot be built: model is empty. Add some layers first.");this.model=new fy({inputs:this.inputs,outputs:this.outputs[0],name:this.name+"_model"}),this.model.trainable=this.trainable,this.supportsMasking=this.model.supportsMasking,this.inputLayers=this.model.inputLayers,this.inputLayersNodeIndices=this.model.inputLayersNodeIndices,this.inputLayersTensorIndices=this.model.inputLayersTensorIndices,this.outputLayers=this.model.outputLayers,this.outputLayersNodeIndices=this.model.outputLayersNodeIndices,this.outputLayersTensorIndices=this.model.outputLayersTensorIndices,this.nodesByDepth=this.model.nodesByDepth,this.containerNodes=this.model.containerNodes,this.outputNames=this.model.outputNames,this.inputNames=this.model.inputNames,this.built=!0}countParams(){return this.built||this.build(),super.countParams()}summary(e,t,n=console.log){this.built||this.build(),super.summary(e,t,n)}setWeights(e){null==this.model&&this.build(),this.model.setWeights(e)}evaluate(e,t,n={}){if(!this.built)throw new Pd("The model needs to be compiled before being used.");return this.model.evaluate(e,t,n)}async evaluateDataset(e,t){if(!this.built)throw new Pd("The model needs to be compiled before being used.");return this.model.evaluateDataset(e,t)}predict(e,t={}){return null==this.model&&this.build(),this.model.predict(e,t)}predictOnBatch(e){return null==this.model&&this.build(),this.model.predictOnBatch(e)}compile(e){this.build(),this.model.compile(e),this.optimizer_=this.model.optimizer,this.isOptimizerOwned=this.model.isOptimizerOwned,this.loss=this.model.loss,this.metrics=this.model.metrics,this.metricsTensors=this.model.metricsTensors,this.metricsNames=this.model.metricsNames}get optimizer(){return null==this.model?void 0:this.model.optimizer}set optimizer(e){this.model.optimizer=e}async fit(e,t,n={}){if(!this.built)throw new Pd("The model needs to be compiled before being used.");return this.model.fit(e,t,n)}async fitDataset(e,t){if(!this.built)throw new Pd("The model needs to be compiled before being used.");return this.model.fitDataset(e,t)}async trainOnBatch(e,t){return this.model.trainOnBatch(e,t)}static fromConfig(e,t,n={},s=!1){let r,a={};if(t instanceof Array){if(null==t[0].className||"Merge"===t[0].className)throw new Wd("Legacy serialization format not supported yet.");r=t}else l(null!=t.layers,(()=>"When the config data for a Sequential model is not an Array, it must be an Object that contains the 'layers' field.")),r=t.layers,delete t.layers,a=t;const i=new e(a);if(!(i instanceof yy))throw new Vd(`Sequential.fromConfig called on non-Sequential input: ${i}`);for(const e of r){const t=ag(e,void 0,s);s&&t.setFastWeightInitDuringBuild(!0),i.add(t)}return i}set stopTraining(e){if(null==this.model)throw new Wd("Cannot set the stopTraining property of a sequential model before it is compiled.");this.model.stopTraining=e}get stopTraining(){if(null==this.model)throw new Wd("Cannot get the stopTraining property of a sequential model before it is compiled.");return this.model.stopTraining}getConfig(){const e=[];for(const t of this.layers){const n={};n.className=t.getClassName(),n.config=t.getConfig(),e.push(n)}return{name:this.name,layers:e}}}function by(e){return qm(e)}yy.className="Sequential",Xa(yy);class xy extends qa{getConfig(){return{}}}class wy extends xy{apply(e,t=1){return function(e,t=1){if(1!==t)throw new Vd(`Support for alpha values other than 1 (${t}) is not implemented yet.`);return _o(e)}(e,t)}}wy.className="elu",Xa(wy);class ky extends xy{apply(e){return Eu(e)}}ky.className="selu",Xa(ky);class vy extends xy{apply(e){return xu(e)}}vy.className="relu",Xa(vy);class Ny extends xy{apply(e){return ii((()=>_l(6,xu(e))))}}Ny.className="relu6",Xa(Ny);class Iy extends xy{apply(e){return e}}Iy.className="linear",Xa(Iy);class $y extends xy{apply(e){return ji(e)}}$y.className="sigmoid",Xa($y);class Cy extends xy{apply(e){return function(e){return ii((()=>{const t=pi(.5,mi(.2,e));return ro(t,0,1)}))}(e)}}Cy.className="hardSigmoid",Xa(Cy);class Sy extends xy{apply(e){return ol(e)}}Sy.className="softplus",Xa(Sy);class Ty extends xy{apply(e){return function(e){return ii((()=>fi(e,gi(e).add(1))))}(e)}}Ty.className="softsign",Xa(Ty);class Ey extends xy{apply(e){return Ki(e)}}Ey.className="tanh",Xa(Ey);class Ay extends xy{apply(e,t=-1){return Bu(e,t)}}Ay.className="softmax",Xa(Ay);class Ry extends xy{apply(e,t=-1){return pl(e,t)}}Ry.className="logSoftmax",Xa(Ry);class Fy extends xy{apply(e,t=1){return ii((()=>ji(e.mul(t)).mul(e)))}}Fy.className="swish",Xa(Fy);class Dy extends xy{apply(e){return ii((()=>mi(e,Ki(ol(e)))))}}function _y(e){return e.getClassName()}function Oy(e,t={}){return ef(e,Ka.getMap().classNameMap,t,"activation")}function My(e){if(null==e){const e={className:"linear",config:{}};return Oy(e)}if("string"==typeof e){const t={};return t.className=e,t.config={},Oy(t)}return e instanceof xy?e:Oy(e)}function Ly(e){if(null!=e&&"object"!=typeof e)throw new Error(`Argument to L1L2 regularizer's constructor is expected to be an object, but received: ${e}`)}Dy.className="mish",Xa(Dy);class zy extends qa{}class By extends zy{constructor(e){super(),Ly(e),this.l1=null==e||null==e.l1?.01:e.l1,this.l2=null==e||null==e.l2?.01:e.l2,this.hasL1=0!==this.l1,this.hasL2=0!==this.l2}apply(e){return ii((()=>{let t=Rl([1]);return this.hasL1&&(t=pi(t,hl(mi(this.l1,gi(e))))),this.hasL2&&(t=pi(t,hl(mi(this.l2,Zf(e))))),t.asScalar()}))}getConfig(){return{l1:this.l1,l2:this.l2}}static fromConfig(e,t){return new e({l1:t.l1,l2:t.l2})}}By.className="L1L2",Xa(By);const Py={l1l2:"L1L2"};function Wy(e){return Zd(e)}function Vy(e,t={}){return ef(e,Ka.getMap().classNameMap,t,"regularizer")}function Uy(e){if(null==e)return null;if("string"==typeof e){return Vy({className:e in Py?Py[e]:e,config:{}})}return e instanceof zy?e:Vy(e)}class Gy extends Gm{constructor(e){super(null==e?{}:e),this.supportsMasking=!0,null!=e&&(this.maxValue=e.maxValue)}call(e,t){e=Fm(e);let n=xu(e);return null!=this.maxValue&&(n=ro(n,0,this.maxValue)),n}computeOutputShape(e){return e}getConfig(){const e={maxValue:this.maxValue},t=super.getConfig();return Object.assign(e,t),e}}Gy.className="ReLU",Xa(Gy);class Hy extends Gm{constructor(e){super(null==e?{}:e),this.DEFAULT_ALPHA=.3,null==e&&(e={}),this.alpha=null==e.alpha?this.DEFAULT_ALPHA:e.alpha}call(e,t){const n=Fm(e);return Yo(n,this.alpha)}computeOutputShape(e){return e}getConfig(){const e={alpha:this.alpha},t=super.getConfig();return Object.assign(e,t),e}}Hy.className="LeakyReLU",Xa(Hy);class jy extends Gm{constructor(e){if(super(null==e?{}:e),this.DEFAULT_ALPHA_INITIALIZER="zeros",null==e&&(e={}),this.supportsMasking=!0,this.alphaInitializer=Im(e.alphaInitializer||this.DEFAULT_ALPHA_INITIALIZER),this.alphaRegularizer=Uy(e.alphaRegularizer),this.alphaConstraint=xf(e.alphaConstraint),null==e.sharedAxes)this.sharedAxes=null;else if(Array.isArray(e.sharedAxes))this.sharedAxes=e.sharedAxes;else{if("number"!=typeof e.sharedAxes)throw new Wd(`Expected sharedAxes to be a number or an array of numbers, but got ${e.sharedAxes}`);this.sharedAxes=[e.sharedAxes]}}build(e){const t=(e=Dm(e)).slice(1);if(null!=this.sharedAxes)for(const e of this.sharedAxes)t[e-1]=1;this.alpha=this.addWeight("alpha",t,"float32",this.alphaInitializer,this.alphaRegularizer,!0,this.alphaConstraint);const n={};if(null!=this.sharedAxes)for(let t=1;t<e.length;++t)n[t]=e[t];this.inputSpec=[new Bm({ndim:e.length,axes:n})],this.built=!0}call(e,t){return e=Fm(e),Zl(e,this.alpha.read())}getConfig(){const e={alphaInitializer:Nm(this.alphaInitializer),alphaRegularizer:Wy(this.alphaRegularizer),alphaConstraint:yf(this.alphaConstraint),sharedAxes:this.sharedAxes},t=super.getConfig();return Object.assign(e,t),e}}jy.className="PReLU",Xa(jy);class qy extends Gm{constructor(e){if(super(null==e?{}:e),this.DEFAULT_ALPHA=1,null==e&&(e={}),null!=e.alpha&&e.alpha!==this.DEFAULT_ALPHA)throw new Vd(`Non-default alpha value (${e.alpha}) is not supported by the ELU layer yet.`);this.alpha=null==e.alpha?this.DEFAULT_ALPHA:e.alpha}call(e,t){const n=Fm(e);return _o(n)}computeOutputShape(e){return e}getConfig(){const e={alpha:this.alpha},t=super.getConfig();return Object.assign(e,t),e}}qy.className="ELU",Xa(qy);class Ky extends Gm{constructor(e){super(null==e?{}:e),this.DEFAULT_THETA=1,null==e&&(e={}),this.theta=null==e.theta?this.DEFAULT_THETA:e.theta}call(e,t){const n=Fm(e);return n.mul(Wf(n.greater(this.theta),"float32"))}computeOutputShape(e){return e}getConfig(){const e={theta:this.theta},t=super.getConfig();return Object.assign(e,t),e}}Ky.className="ThresholdedReLU",Xa(Ky);class Xy extends Gm{constructor(e){super(null==e?{}:e),this.DEFAULT_AXIS=1,null==e&&(e={}),this.softmax=(new Ay).apply,this.axis=null==e.axis?this.DEFAULT_AXIS:e.axis}call(e,t){const n=Fm(e);return this.softmax(n,this.axis)}computeOutputShape(e){return e}getConfig(){const e={axis:this.axis},t=super.getConfig();return Object.assign(e,t),e}}function Yy(e,t,n){if("number"==typeof e)return Gd(e,t);if(e.length!==t)throw new Wd(`The ${n} argument must be an integer or tuple of ${t} integers. Received: ${e.length} elements.`);for(let r=0;r<t;++r){const a=e[r];if((s=a)!==parseInt(s.toString(),10))throw new Wd(`The ${n} argument must be an integer or tuple of ${t} integers. Received: ${JSON.stringify(e)} including a non-integer number ${a}`)}return e;var s}function Jy(e,t,n,s,r=1){if(null==e)return e;let a;return a="same"===n?e:e-(t+(t-1)*(r-1))+1,Math.floor((a+s-1)/s)}function Zy(e,t,n,s){if(null==e)return null;if("valid"===s)e=e*t+Bf([n-t,0]);else{if("same"!==s)throw new Wd(`Unsupport padding mode: ${s}.`);e*=t}return e}function Qy(e,t){return ii((()=>(Sf(t),"channelsFirst"===t?ma(e,[0,2,3,1]):e)))}function eb(e,t){return ii((()=>(Sf(t),"channelsFirst"===t?ma(e,[0,2,3,4,1]):e)))}function tb(e,t,n,s=1,r="valid",a,i=1){return ii((()=>{if(null==a&&(a="channelsLast"),Sf(a),3!==e.shape.length)throw new Wd(`The input of a conv1dWithBias operation should be 3, but is ${e.shape.length} instead.`);if(3!==t.shape.length)throw new Wd(`The kernel for a conv1dWithBias operation should be 3, but is ${t.shape.length} instead`);if(null!=n&&1!==n.shape.length)throw new Wd(`The bias for a conv1dWithBias operation should be 1, but is ${t.shape.length} instead`);if("channelsFirst"===a&&(e=ma(e,[0,2,1])),"causal"===r)throw new Vd("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");let o=co(e,t,s,"same"===r?"same":"valid","NWC",i);return null!=n&&(o=em(o,n)),o}))}function nb(e,t,n,s=[1,1],r="valid",a,i,o=null){return ii((()=>{if(null==a&&(a="channelsLast"),Sf(a),3!==e.rank&&4!==e.rank)throw new Wd(`conv2dWithBiasActivation expects input to be of rank 3 or 4, but received ${e.rank}.`);if(3!==t.rank&&4!==t.rank)throw new Wd(`conv2dWithBiasActivation expects kernel to be of rank 3 or 4, but received ${e.rank}.`);let l=Qy(e,a);if("causal"===r)throw new Vd("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");return l=Ic({x:l,filter:t,strides:s,pad:"same"===r?"same":"valid",dilations:i,dataFormat:"NHWC",bias:n,activation:o}),"channelsFirst"===a&&(l=ma(l,[0,3,1,2])),l}))}function sb(e,t,n,s=[1,1,1],r="valid",a,i){return ii((()=>{if(null==a&&(a="channelsLast"),Sf(a),4!==e.rank&&5!==e.rank)throw new Wd(`conv3dWithBias expects input to be of rank 4 or 5, but received ${e.rank}.`);if(4!==t.rank&&5!==t.rank)throw new Wd(`conv3dWithBias expects kernel to be of rank 4 or 5, but received ${e.rank}.`);let o=eb(e,a);if("causal"===r)throw new Vd("The support for CAUSAL padding mode in conv3dWithBias is not implemented yet.");return o=fo(o,t,s,"same"===r?"same":"valid","NDHWC",i),null!=n&&(o=em(o,n)),"channelsFirst"===a&&(o=ma(o,[0,4,1,2,3])),o}))}Xy.className="Softmax",Xa(Xy);class rb extends Gm{constructor(e,t){if(super(t),this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",rb.verifyArgs(t),this.rank=e,of(this.rank,"rank"),1!==this.rank&&2!==this.rank&&3!==this.rank)throw new Vd(`Convolution layer for rank other than 1, 2, or 3 (${this.rank}) is not implemented yet.`);if(this.kernelSize=Yy(t.kernelSize,e,"kernelSize"),this.strides=Yy(null==t.strides?1:t.strides,e,"strides"),this.padding=null==t.padding?"valid":t.padding,Tf(this.padding),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,Sf(this.dataFormat),this.activation=My(t.activation),this.useBias=null==t.useBias||t.useBias,this.biasInitializer=Im(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.biasConstraint=xf(t.biasConstraint),this.biasRegularizer=Uy(t.biasRegularizer),this.activityRegularizer=Uy(t.activityRegularizer),this.dilationRate=Yy(null==t.dilationRate?1:t.dilationRate,e,"dilationRate"),1===this.rank&&Array.isArray(this.dilationRate)&&1!==this.dilationRate.length)throw new Wd(`dilationRate must be a number or an array of a single number for 1D convolution, but received ${JSON.stringify(this.dilationRate)}`);if(2===this.rank){if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate];else if(2!==this.dilationRate.length)throw new Wd(`dilationRate must be a number or array of two numbers for 2D convolution, but received ${JSON.stringify(this.dilationRate)}`)}else if(3===this.rank)if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate,this.dilationRate];else if(3!==this.dilationRate.length)throw new Wd(`dilationRate must be a number or array of three numbers for 3D convolution, but received ${JSON.stringify(this.dilationRate)}`)}static verifyArgs(e){if(Hd("kernelSize"in e,"required key 'kernelSize' not in config"),"number"!=typeof e.kernelSize&&!af(e.kernelSize,"number",1,3))throw new Wd(`BaseConv expects config.kernelSize to be number or number[] with length 1, 2, or 3, but received ${JSON.stringify(e.kernelSize)}.`)}getConfig(){const e={kernelSize:this.kernelSize,strides:this.strides,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,activation:_y(this.activation),useBias:this.useBias,biasInitializer:Nm(this.biasInitializer),biasRegularizer:Wy(this.biasRegularizer),activityRegularizer:Wy(this.activityRegularizer),biasConstraint:yf(this.biasConstraint)},t=super.getConfig();return Object.assign(e,t),e}}class ab extends rb{constructor(e,t){super(e,t),this.kernel=null,ab.verifyArgs(t),this.filters=t.filters,of(this.filters,"filters"),this.kernelInitializer=Im(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.kernelConstraint=xf(t.kernelConstraint),this.kernelRegularizer=Uy(t.kernelRegularizer)}build(e){e=Dm(e);const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new Wd(`The channel dimension of the input should be defined. Found ${e[t]}`);const n=e[t],s=this.kernelSize.concat([n,this.filters]);this.kernel=this.addWeight("kernel",s,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[{ndim:this.rank+2,axes:{[t]:n}}],this.built=!0}call(e,t){return ii((()=>{let t;e=Fm(e);const n=null==this.bias?null:this.bias.read(),s=uf(this.activation.getClassName());if(null!=s&&2===this.rank)t=nb(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate,s);else{if(1===this.rank)t=tb(e,this.kernel.read(),n,this.strides[0],this.padding,this.dataFormat,this.dilationRate[0]);else if(2===this.rank)t=nb(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate);else{if(3!==this.rank)throw new Vd("convolutions greater than 3D are not implemented yet.");t=sb(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate)}null!=this.activation&&(t=this.activation.apply(t))}return t}))}computeOutputShape(e){e=Dm(e);const t=[],n="channelsLast"===this.dataFormat?e.slice(1,e.length-1):e.slice(2);for(let e=0;e<n.length;++e){const s=Jy(n[e],this.kernelSize[e],this.padding,this.strides[e],"number"==typeof this.dilationRate?this.dilationRate:this.dilationRate[e]);t.push(s)}let s=[e[0]];return"channelsLast"===this.dataFormat?(s=s.concat(t),s.push(this.filters)):(s.push(this.filters),s=s.concat(t)),s}getConfig(){const e={filters:this.filters,kernelInitializer:Nm(this.kernelInitializer),kernelRegularizer:Wy(this.kernelRegularizer),kernelConstraint:yf(this.kernelConstraint)},t=super.getConfig();return Object.assign(e,t),e}static verifyArgs(e){if(!("filters"in e)||"number"!=typeof e.filters||e.filters<1)throw new Wd(`Convolution layer expected config.filters to be a 'number' > 0 but got ${JSON.stringify(e.filters)}`)}}class ib extends ab{constructor(e){super(2,e),ib.verifyArgs(e)}getConfig(){const e=super.getConfig();return delete e.rank,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&!af(e.kernelSize,"number",1,2))throw new Wd(`Conv2D expects config.kernelSize to be number or number[] with length 1 or 2, but received ${JSON.stringify(e.kernelSize)}.`)}}ib.className="Conv2D",Xa(ib);class ob extends ab{constructor(e){super(3,e),ob.verifyArgs(e)}getConfig(){const e=super.getConfig();return delete e.rank,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&(!Array.isArray(e.kernelSize)||1!==e.kernelSize.length&&3!==e.kernelSize.length))throw new Wd(`Conv3D expects config.kernelSize to be number or [number, number, number], but received ${JSON.stringify(e.kernelSize)}.`)}}ob.className="Conv3D",Xa(ob);class lb extends ib{constructor(e){if(super(e),this.inputSpec=[new Bm({ndim:4})],"same"!==this.padding&&"valid"!==this.padding)throw new Wd(`Conv2DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(e){if(4!==(e=Dm(e)).length)throw new Wd("Input should have rank 4; Received input shape: "+JSON.stringify(e));const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new Wd("The channel dimension of the inputs should be defined. Found `None`.");const n=e[t],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new Bm({ndim:4,axes:{[t]:n}})],this.built=!0}call(e,t){return ii((()=>{let t=Fm(e);if(4!==t.shape.length)throw new Wd(`Conv2DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${t.shape.length}`);const n=t.shape,s=n[0];let r,a;"channelsFirst"===this.dataFormat?(r=2,a=3):(r=1,a=2);const i=n[r],o=n[a],l=this.kernelSize[0],u=this.kernelSize[1],c=this.strides[0],h=this.strides[1],p=[s,Zy(i,c,l,this.padding),Zy(o,h,u,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(t=ma(t,[0,2,3,1]));let d=po(t,this.kernel.read(),p,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(d=ma(d,[0,3,1,2])),null!=this.bias&&(d=em(d,this.bias.read(),this.dataFormat)),null!=this.activation&&(d=this.activation.apply(d)),d}))}computeOutputShape(e){const t=(e=Dm(e)).slice();let n,s,r;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3):(n=3,s=1,r=2);const a=this.kernelSize[0],i=this.kernelSize[1],o=this.strides[0],l=this.strides[1];return t[n]=this.filters,t[s]=Zy(t[s],o,a,this.padding),t[r]=Zy(t[r],l,i,this.padding),t}getConfig(){const e=super.getConfig();return delete e.dilationRate,e}}lb.className="Conv2DTranspose",Xa(lb);class ub extends ob{constructor(e){if(super(e),this.inputSpec=[new Bm({ndim:5})],"same"!==this.padding&&"valid"!==this.padding)throw new Wd(`Conv3DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(e){if(5!==(e=Dm(e)).length)throw new Wd("Input should have rank 5; Received input shape: "+JSON.stringify(e));const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new Wd("The channel dimension of the inputs should be defined. Found `None`.");const n=e[t],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new Bm({ndim:5,axes:{[t]:n}})],this.built=!0}call(e,t){return ii((()=>{let t=Fm(e);if(5!==t.shape.length)throw new Wd(`Conv3DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${t.shape.length}`);const n=t.shape,s=n[0];let r,a,i;"channelsFirst"===this.dataFormat?(i=2,r=3,a=4):(i=1,r=2,a=3);const o=n[i],l=n[r],u=n[a],c=this.kernelSize[0],h=this.kernelSize[1],p=this.kernelSize[2],d=this.strides[0],f=this.strides[1],m=this.strides[2],g=[s,Zy(o,d,c,this.padding),Zy(l,f,h,this.padding),Zy(u,m,p,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(t=ma(t,[0,2,3,4,1]));let y=go(t,this.kernel.read(),g,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(y=ma(y,[0,4,1,2,3])),null!==this.bias&&(y=em(y,this.bias.read(),this.dataFormat)),null!==this.activation&&(y=this.activation.apply(y)),y}))}computeOutputShape(e){const t=(e=Dm(e)).slice();let n,s,r,a;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3,a=4):(n=4,s=1,r=2,a=3);const i=this.kernelSize[0],o=this.kernelSize[1],l=this.kernelSize[2],u=this.strides[0],c=this.strides[1],h=this.strides[2];return t[n]=this.filters,t[s]=Zy(t[s],u,i,this.padding),t[r]=Zy(t[r],c,o,this.padding),t[a]=Zy(t[a],h,l,this.padding),t}getConfig(){const e=super.getConfig();return delete e.dilationRate,e}}ub.className="Conv3DTranspose",Xa(ub);class cb extends ab{constructor(e,t){if(super(e,t),this.DEFAULT_DEPTHWISE_INITIALIZER="glorotUniform",this.DEFAULT_POINTWISE_INITIALIZER="glorotUniform",this.depthwiseKernel=null,this.pointwiseKernel=null,null==t.filters)throw new Wd("The `filters` configuration field is required by SeparableConv, but is unspecified.");if(null!=t.kernelInitializer||null!=t.kernelRegularizer||null!=t.kernelConstraint)throw new Wd("Fields kernelInitializer, kernelRegularizer and kernelConstraint are invalid for SeparableConv2D. Use depthwiseInitializer, depthwiseRegularizer, depthwiseConstraint, pointwiseInitializer, pointwiseRegularizer and pointwiseConstraint instead.");if(null!=t.padding&&"same"!==t.padding&&"valid"!==t.padding)throw new Wd(`SeparableConv${this.rank}D supports only padding modes: 'same' and 'valid', but received ${JSON.stringify(t.padding)}`);this.depthMultiplier=null==t.depthMultiplier?1:t.depthMultiplier,this.depthwiseInitializer=Im(t.depthwiseInitializer||this.DEFAULT_DEPTHWISE_INITIALIZER),this.depthwiseRegularizer=Uy(t.depthwiseRegularizer),this.depthwiseConstraint=xf(t.depthwiseConstraint),this.pointwiseInitializer=Im(t.depthwiseInitializer||this.DEFAULT_POINTWISE_INITIALIZER),this.pointwiseRegularizer=Uy(t.pointwiseRegularizer),this.pointwiseConstraint=xf(t.pointwiseConstraint)}build(e){if((e=Dm(e)).length<this.rank+2)throw new Wd(`Inputs to SeparableConv${this.rank}D should have rank ${this.rank+2}, but received input shape: ${JSON.stringify(e)}`);const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t]||e[t]<0)throw new Wd(`The channel dimension of the inputs should be defined, but found ${JSON.stringify(e[t])}`);const n=e[t],s=this.kernelSize.concat([n,this.depthMultiplier]),r=[];for(let e=0;e<this.rank;++e)r.push(1);r.push(n*this.depthMultiplier,this.filters);const a=!0;this.depthwiseKernel=this.addWeight("depthwise_kernel",s,"float32",this.depthwiseInitializer,this.depthwiseRegularizer,a,this.depthwiseConstraint),this.pointwiseKernel=this.addWeight("pointwise_kernel",r,"float32",this.pointwiseInitializer,this.pointwiseRegularizer,a,this.pointwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,a,this.biasConstraint):this.bias=null,this.inputSpec=[new Bm({ndim:this.rank+2,axes:{[t]:n}})],this.built=!0}call(e,t){return ii((()=>{let t;if(e=Fm(e),1===this.rank)throw new Vd("1D separable convolution is not implemented yet.");return 2===this.rank&&("channelsFirst"===this.dataFormat&&(e=ma(e,[0,2,3,1])),t=Au(e,this.depthwiseKernel.read(),this.pointwiseKernel.read(),this.strides,this.padding,this.dilationRate,"NHWC")),this.useBias&&(t=em(t,this.bias.read(),this.dataFormat)),null!=this.activation&&(t=this.activation.apply(t)),"channelsFirst"===this.dataFormat&&(t=ma(t,[0,3,1,2])),t}))}getConfig(){const e=super.getConfig();return delete e.rank,delete e.kernelInitializer,delete e.kernelRegularizer,delete e.kernelConstraint,e.depthwiseInitializer=Nm(this.depthwiseInitializer),e.pointwiseInitializer=Nm(this.pointwiseInitializer),e.depthwiseRegularizer=Wy(this.depthwiseRegularizer),e.pointwiseRegularizer=Wy(this.pointwiseRegularizer),e.depthwiseConstraint=yf(this.depthwiseConstraint),e.pointwiseConstraint=yf(this.pointwiseConstraint),e}}cb.className="SeparableConv";class hb extends cb{constructor(e){super(2,e)}}hb.className="SeparableConv2D",Xa(hb);class pb extends ab{constructor(e){super(1,e),pb.verifyArgs(e),this.inputSpec=[{ndim:3}]}getConfig(){const e=super.getConfig();return delete e.rank,delete e.dataFormat,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&!af(e.kernelSize,"number",1,1))throw new Wd(`Conv1D expects config.kernelSize to be number or number[] with length 1, but received ${JSON.stringify(e.kernelSize)}.`)}}pb.className="Conv1D",Xa(pb);class db extends Gm{constructor(e){super(e),"number"==typeof e.cropping?this.cropping=[[e.cropping,e.cropping],[e.cropping,e.cropping]]:"number"==typeof e.cropping[0]?this.cropping=[[e.cropping[0],e.cropping[0]],[e.cropping[1],e.cropping[1]]]:this.cropping=e.cropping,this.dataFormat=void 0===e.dataFormat?"channelsLast":e.dataFormat,this.inputSpec=[{ndim:4}]}computeOutputShape(e){return"channelsFirst"===this.dataFormat?[e[0],e[1],e[2]-this.cropping[0][0]-this.cropping[0][1],e[3]-this.cropping[1][0]-this.cropping[1][1]]:[e[0],e[1]-this.cropping[0][0]-this.cropping[0][1],e[2]-this.cropping[1][0]-this.cropping[1][1],e[3]]}call(e,t){return ii((()=>{if(e=Fm(e),"channelsLast"===this.dataFormat){const t=Hf(e,this.cropping[0][0],e.shape[1]-this.cropping[0][0]-this.cropping[0][1],2);return Hf(t,this.cropping[1][0],e.shape[2]-this.cropping[1][1]-this.cropping[1][0],3)}{const t=Hf(e,this.cropping[0][0],e.shape[2]-this.cropping[0][0]-this.cropping[0][1],3);return Hf(t,this.cropping[1][0],e.shape[3]-this.cropping[1][1]-this.cropping[1][0],4)}}))}getConfig(){const e={cropping:this.cropping,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}db.className="Cropping2D",Xa(db);class fb extends Gm{constructor(e){var t;super(e),this.DEFAULT_SIZE=[2,2],this.inputSpec=[{ndim:4}],this.size=null==e.size?this.DEFAULT_SIZE:e.size,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,Sf(this.dataFormat),this.interpolation=null==e.interpolation?"nearest":e.interpolation,t=this.interpolation,rf(vf,"InterpolationFormat",t)}computeOutputShape(e){if("channelsFirst"===this.dataFormat){const t=null==e[2]?null:this.size[0]*e[2],n=null==e[3]?null:this.size[1]*e[3];return[e[0],e[1],t,n]}{const t=null==e[1]?null:this.size[0]*e[1],n=null==e[2]?null:this.size[1]*e[2];return[e[0],t,n,e[3]]}}call(e,t){return ii((()=>{let t=Fm(e);const n=t.shape;if("channelsFirst"===this.dataFormat){t=ma(t,[0,2,3,1]);const e=this.size[0]*n[2],s=this.size[1]*n[3],r="nearest"===this.interpolation?t.resizeNearestNeighbor([e,s]):t.resizeBilinear([e,s]);return ma(r,[0,3,1,2])}{const e=this.size[0]*n[1],s=this.size[1]*n[2];return"nearest"===this.interpolation?t.resizeNearestNeighbor([e,s]):t.resizeBilinear([e,s])}}))}getConfig(){const e={size:this.size,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}fb.className="UpSampling2D",Xa(fb);class mb extends rb{constructor(e){super(2,e),this.depthwiseKernel=null,this.depthMultiplier=null==e.depthMultiplier?1:e.depthMultiplier,this.depthwiseInitializer=Im(e.depthwiseInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.depthwiseConstraint=xf(e.depthwiseConstraint),this.depthwiseRegularizer=Uy(e.depthwiseRegularizer)}build(e){if((e=Dm(e)).length<4)throw new Wd(`Inputs to DepthwiseConv2D should have rank 4. Received input shape: ${JSON.stringify(e)}.`);const t="channelsFirst"===this.dataFormat?1:3;if(null==e[t]||e[t]<0)throw new Wd(`The channel dimension of the inputs to DepthwiseConv2D should be defined, but is not (${e[t]}).`);const n=e[t],s=[this.kernelSize[0],this.kernelSize[1],n,this.depthMultiplier];this.depthwiseKernel=this.addWeight("depthwise_kernel",s,null,this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[n*this.depthMultiplier],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return ii((()=>{let t=function(e,t,n=[1,1],s="valid",r,a){return ii((()=>{null==r&&(r="channelsLast"),Sf(r);let i=Qy(e,r);if(4!==e.rank)throw new Wd(`Input for depthwiseConv2d is required to be 4-D, but is instead ${e.rank}-D`);if(4!==t.rank)throw new Wd(`depthwiseKernel is required to be 4-D, but is instead ${t.rank}-D`);return i=vo(i,t,n,"same"===s?"same":"valid","NHWC",a),"channelsFirst"===r&&(i=ma(i,[0,3,1,2])),i}))}(e=Fm(e),this.depthwiseKernel.read(),this.strides,this.padding,this.dataFormat,null);return this.useBias&&(t=em(t,this.bias.read(),this.dataFormat)),null!=this.activation&&(t=this.activation.apply(t)),t}))}computeOutputShape(e){e=Dm(e);const t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2],s="channelsFirst"===this.dataFormat?e[1]*this.depthMultiplier:e[3]*this.depthMultiplier,r=Jy(t,this.kernelSize[0],this.padding,this.strides[0]),a=Jy(n,this.kernelSize[1],this.padding,this.strides[1]);return"channelsFirst"===this.dataFormat?[e[0],s,r,a]:[e[0],r,a,s]}getConfig(){const e=super.getConfig();return e.depthMultiplier=this.depthMultiplier,e.depthwiseInitializer=Nm(this.depthwiseInitializer),e.depthwiseRegularizer=Wy(this.depthwiseRegularizer),e.depthwiseConstraint=yf(this.depthwiseRegularizer),e}}function gb(e,t,n,s){if(Array.isArray(e)){if(null!=t||null!=n)throw new Wd("When inputs is an array, neither initialState or constants should be provided");null!=s&&(n=e.slice(e.length-s,e.length),e=e.slice(0,e.length-s)),e.length>1&&(t=e.slice(1,e.length)),e=e[0]}function r(e){return null==e||Array.isArray(e)?e:[e]}return{inputs:e,initialState:t=r(t),constants:n=r(n)}}function yb(e,t,n,s=!1,r,a,i=!1,o=!1){return ii((()=>{const l=t.shape.length;if(l<3)throw new Wd(`Input should be at least 3D, but is ${l}D.`);const u=[1,0].concat(Pf(2,l));if(t=ma(t,u),null!=a)throw new Vd("The rnn() functoin of the deeplearn.js backend does not support constants yet.");i&&console.warn("Backend rnn(): the unroll = true option is not applicable to the imperative deeplearn.js backend."),null!=r&&((r=r.asType("bool").asType("float32")).rank===l-1&&(r=Lo(r,-1)),r=ma(r,u)),s&&(t=ku(t,0),null!=r&&(r=ku(r,0)));const c=[];let h,p=n;const d=t.shape[0],f=rc(t);let m,g;null!=r&&(m=rc(r));for(let t=0;t<d;++t){const n=f[t],s=ii((()=>e(n,p)));if(null==r)h=s[0],p=s[1];else{const e=ii((()=>{const e=m[t],n=Vl(e).sub(e);return{output:s[0].mul(e).add(p[0].mul(n)),newStates:p.map(((t,r)=>s[1][r].mul(e).add(t.mul(n))))}}));h=e.output,p=e.newStates}o&&c.push(h)}if(o){g=Ku(c,1)}return[h,g,p]}))}mb.className="DepthwiseConv2D",Xa(mb);class bb extends Gm{constructor(e){let t;if(super(e),null==e.cell)throw new Wd("cell property is missing for the constructor of RNN.");if(t=Array.isArray(e.cell)?new Cb({cells:e.cell}):e.cell,null==t.stateSize)throw new Wd("The RNN cell should have an attribute `stateSize` (tuple of integers, one integer per RNN state).");this.cell=t,this.returnSequences=null!=e.returnSequences&&e.returnSequences,this.returnState=null!=e.returnState&&e.returnState,this.goBackwards=null!=e.goBackwards&&e.goBackwards,this._stateful=null!=e.stateful&&e.stateful,this.unroll=null!=e.unroll&&e.unroll,this.supportsMasking=!0,this.inputSpec=[new Bm({ndim:3})],this.stateSpec=null,this.states_=null,this.numConstants=null,this.keptStates=[]}getStates(){if(null==this.states_){return Pf(0,Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1).map((e=>null))}return this.states_}setStates(e){this.states_=e}computeOutputShape(e){Am(e)&&(e=e[0]),e=e;let t=this.cell.stateSize;Array.isArray(t)||(t=[t]);const n=t[0];let s;if(s=this.returnSequences?[e[0],e[1],n]:[e[0],n],this.returnState){const n=[];for(const s of t)n.push([e[0],s]);return[s].concat(n)}return s}computeMask(e,t){return ii((()=>{Array.isArray(t)&&(t=t[0]);const e=this.returnSequences?t:null;if(this.returnState){const t=this.states.map((e=>null));return[e].concat(t)}return e}))}get states(){if(null==this.states_){const e=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1,t=[];for(let n=0;n<e;++n)t.push(null);return t}return this.states_}set states(e){this.states_=e}build(e){if(null!=this.numConstants)throw new Vd("Constants support is not implemented in RNN yet.");Am(e)&&(e=e[0]),e=e;const t=this.stateful?e[0]:null,n=e.slice(2);this.inputSpec[0]=new Bm({shape:[t,null,...n]});const s=[e[0]].concat(e.slice(2));let r;if(this.cell.build(s),r=Array.isArray(this.cell.stateSize)?this.cell.stateSize:[this.cell.stateSize],null!=this.stateSpec){if(!d(this.stateSpec.map((e=>e.shape[e.shape.length-1])),r))throw new Wd(`An initialState was passed that is not compatible with cell.stateSize. Received stateSpec=${this.stateSpec}; However cell.stateSize is ${this.cell.stateSize}`)}else this.stateSpec=r.map((e=>new Bm({shape:[null,e]})));this.stateful&&this.resetStates()}resetStates(e,t=!1){ii((()=>{if(!this.stateful)throw new Bd("Cannot call resetStates() on an RNN Layer that is not stateful.");const n=this.inputSpec[0].shape[0];if(null==n)throw new Wd("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.states_)Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((e=>Rl([n,e]))):this.states_=[Rl([n,this.cell.stateSize])];else if(null==e)oi(this.states_),null!=this.keptStates&&(oi(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((e=>Rl([n,e]))):this.states_[0]=Rl([n,this.cell.stateSize]);else{if(Array.isArray(e)||(e=[e]),e.length!==this.states_.length)throw new Wd(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${e.length} state value(s). Input received: ${e}`);!0===t?this.keptStates.push(this.states_.slice()):oi(this.states_);for(let t=0;t<this.states_.length;++t){const s=e[t],r=Array.isArray(this.cell.stateSize)?this.cell.stateSize[t]:this.cell.stateSize,a=[n,r];if(!d(s.shape,a))throw new Wd(`State ${t} is incompatible with layer ${this.name}: expected shape=${a}, received shape=${s.shape}`);this.states_[t]=s}}this.states_=this.states_.map((e=>li(e.clone())))}))}apply(e,t){let n=null==t?null:t.initialState,s=null==t?null:t.constants;null==t&&(t={});const r=gb(e,n,s,this.numConstants);e=r.inputs,n=r.initialState,s=r.constants;let a=[],i=[];if(null!=n){t.initialState=n,a=a.concat(n),this.stateSpec=[];for(const e of n)this.stateSpec.push(new Bm({shape:e.shape}));i=i.concat(this.stateSpec)}null!=s&&(t.constants=s,a=a.concat(s),this.numConstants=s.length);if(a[0]instanceof Pm){const n=[e].concat(a),s=this.inputSpec.concat(i),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,t);return this.inputSpec=r,o}return super.apply(e,t)}call(e,t){return ii((()=>{const n=null==t?null:t.mask,s=null==t?null:t.training;let r=null==t?null:t.initialState;e=Fm(e),null==r&&(r=this.stateful?this.states_:this.getInitialState(e));const a=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1;if(r.length!==a)throw new Wd(`RNN Layer has ${a} state(s) but was passed ${r.length} initial state(s).`);this.unroll&&console.warn("Ignoring unroll = true for RNN layer, due to imperative backend.");const i={training:s},o=yb(((e,t)=>{const n=this.cell.call([e].concat(t),i);return[n[0],n.slice(1)]}),e,r,this.goBackwards,n,null,this.unroll,this.returnSequences),l=o[0],u=o[1],c=o[2];this.stateful&&this.resetStates(c,s);const h=this.returnSequences?u:l;return this.returnState?[h].concat(c):h}))}getInitialState(e){return ii((()=>{let t=Rl(e.shape);return t=hl(t,[1,2]),t=Vf(t),Array.isArray(this.cell.stateSize)?this.cell.stateSize.map((e=>e>1?Kf(t,[1,e]):t)):this.cell.stateSize>1?[Kf(t,[1,this.cell.stateSize])]:[t]}))}get trainableWeights(){return this.trainable?this.cell.trainableWeights:[]}get nonTrainableWeights(){return this.trainable?this.cell.nonTrainableWeights:this.cell.weights}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.cell&&this.cell.setFastWeightInitDuringBuild(e)}getConfig(){const e=super.getConfig(),t={returnSequences:this.returnSequences,returnState:this.returnState,goBackwards:this.goBackwards,stateful:this.stateful,unroll:this.unroll};null!=this.numConstants&&(t.numConstants=this.numConstants);const n=this.cell.getConfig();return this.getClassName()===bb.className&&(t.cell={className:this.cell.getClassName(),config:n}),Object.assign({},n,e,t)}static fromConfig(e,t,n={}){const s=ag(t.cell,n);return new e(Object.assign(t,{cell:s}))}}bb.className="RNN",Xa(bb);class xb extends Gm{}class wb extends xb{constructor(e){super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=e.units,of(this.units,"units"),this.activation=My(null==e.activation?this.DEFAULT_ACTIVATION:e.activation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=Im(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Im(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Im(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Uy(e.kernelRegularizer),this.recurrentRegularizer=Uy(e.recurrentRegularizer),this.biasRegularizer=Uy(e.biasRegularizer),this.kernelConstraint=xf(e.kernelConstraint),this.recurrentConstraint=xf(e.recurrentConstraint),this.biasConstraint=xf(e.biasConstraint),this.dropout=zf([1,Bf([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=zf([1,Bf([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){e=Dm(e),this.kernel=this.addWeight("kernel",[e[e.length-1],this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return ii((()=>{if(2!==(e=e).length)throw new Wd(`SimpleRNNCell expects 2 input Tensors, got ${e.length}.`);let n=e[1];e=e[0];const s=null!=t.training&&t.training;let r;0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Sb({ones:()=>Vl(e),rate:this.dropout,training:s})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Sb({ones:()=>Vl(n),rate:this.recurrentDropout,training:s}));const a=this.dropoutMask,i=this.recurrentDropoutMask;r=Yf(null!=a?mi(e,a):e,this.kernel.read()),null!=this.bias&&(r=em(r,this.bias.read())),null!=i&&(n=mi(n,i));let o=pi(r,Yf(n,this.recurrentKernel.read()));return null!=this.activation&&(o=this.activation.apply(o)),[o,o]}))}getConfig(){const e=super.getConfig(),t={units:this.units,activation:_y(this.activation),useBias:this.useBias,kernelInitializer:Nm(this.kernelInitializer),recurrentInitializer:Nm(this.recurrentInitializer),biasInitializer:Nm(this.biasInitializer),kernelRegularizer:Wy(this.kernelRegularizer),recurrentRegularizer:Wy(this.recurrentRegularizer),biasRegularizer:Wy(this.biasRegularizer),activityRegularizer:Wy(this.activityRegularizer),kernelConstraint:yf(this.kernelConstraint),recurrentConstraint:yf(this.recurrentConstraint),biasConstraint:yf(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout};return Object.assign({},e,t)}}wb.className="SimpleRNNCell",Xa(wb);class kb extends bb{constructor(e){e.cell=new wb(e),super(e)}call(e,t){return ii((()=>{null!=this.cell.dropoutMask&&(oi(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(oi(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})}))}static fromConfig(e,t){return new e(t)}}kb.className="SimpleRNN",Xa(kb);class vb extends xb{constructor(e){if(super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",e.resetAfter)throw new Wd("GRUCell does not support reset_after parameter set to true.");this.units=e.units,of(this.units,"units"),this.activation=My(void 0===e.activation?this.DEFAULT_ACTIVATION:e.activation),this.recurrentActivation=My(void 0===e.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:e.recurrentActivation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=Im(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Im(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Im(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Uy(e.kernelRegularizer),this.recurrentRegularizer=Uy(e.recurrentRegularizer),this.biasRegularizer=Uy(e.biasRegularizer),this.kernelConstraint=xf(e.kernelConstraint),this.recurrentConstraint=xf(e.recurrentConstraint),this.biasConstraint=xf(e.biasConstraint),this.dropout=zf([1,Bf([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=zf([1,Bf([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.implementation=e.implementation,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){const t=(e=Dm(e))[e.length-1];this.kernel=this.addWeight("kernel",[t,3*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,3*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[3*this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return ii((()=>{if(2!==(e=e).length)throw new Wd(`GRUCell expects 2 input Tensors (inputs, h, c), got ${e.length}.`);const n=null!=t.training&&t.training;let s=e[1];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Sb({ones:()=>Vl(e),rate:this.dropout,training:n,count:3})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Sb({ones:()=>Vl(s),rate:this.recurrentDropout,training:n,count:3}));const r=this.dropoutMask,a=this.recurrentDropoutMask;let i,o,l;0<this.dropout&&this.dropout<1&&(e=mi(e,r[0]));let u=Yf(e,this.kernel.read());this.useBias&&(u=em(u,this.bias.read())),0<this.recurrentDropout&&this.recurrentDropout<1&&(s=mi(s,a[0]));const c=this.recurrentKernel.read(),[h,p]=Uu(c,[2*this.units,this.units],c.rank-1),d=Yf(s,h),[f,m,g]=Uu(u,3,u.rank-1),[y,b]=Uu(d,2,d.rank-1);i=this.recurrentActivation.apply(pi(f,y)),o=this.recurrentActivation.apply(pi(m,b));const x=Yf(mi(o,s),p);l=this.activation.apply(pi(g,x));const w=pi(mi(i,s),mi(pi(1,il(i)),l));return[w,w]}))}getConfig(){const e=super.getConfig(),t={units:this.units,activation:_y(this.activation),recurrentActivation:_y(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Nm(this.kernelInitializer),recurrentInitializer:Nm(this.recurrentInitializer),biasInitializer:Nm(this.biasInitializer),kernelRegularizer:Wy(this.kernelRegularizer),recurrentRegularizer:Wy(this.recurrentRegularizer),biasRegularizer:Wy(this.biasRegularizer),activityRegularizer:Wy(this.activityRegularizer),kernelConstraint:yf(this.kernelConstraint),recurrentConstraint:yf(this.recurrentConstraint),biasConstraint:yf(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation,resetAfter:!1};return Object.assign({},e,t)}}vb.className="GRUCell",Xa(vb);class Nb extends bb{constructor(e){0===e.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),e.cell=new vb(e),super(e)}call(e,t){return ii((()=>{null!=this.cell.dropoutMask&&(oi(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(oi(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})}))}static fromConfig(e,t){return 0===t.implmentation&&(t.implementation=1),new e(t)}}Nb.className="GRU",Xa(Nb);class Ib extends xb{constructor(e){super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=e.units,of(this.units,"units"),this.activation=My(void 0===e.activation?this.DEFAULT_ACTIVATION:e.activation),this.recurrentActivation=My(void 0===e.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:e.recurrentActivation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=Im(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Im(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Im(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.unitForgetBias=e.unitForgetBias,this.kernelRegularizer=Uy(e.kernelRegularizer),this.recurrentRegularizer=Uy(e.recurrentRegularizer),this.biasRegularizer=Uy(e.biasRegularizer),this.kernelConstraint=xf(e.kernelConstraint),this.recurrentConstraint=xf(e.recurrentConstraint),this.biasConstraint=xf(e.biasConstraint),this.dropout=zf([1,Bf([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=zf([1,Bf([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.implementation=e.implementation,this.stateSize=[this.units,this.units],this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){var t;const n=(e=Dm(e))[e.length-1];let s;if(this.kernel=this.addWeight("kernel",[n,4*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,4*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){if(this.unitForgetBias){const e=this.biasInitializer,n=this.units;s=new((t=class extends am{apply(t,s){const r=e.apply([n]),a=(new om).apply([n]),i=e.apply([2*n]);return qf(qf(r,a),i)}}).className="CustomInit",t)}else s=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.units],null,s,this.biasRegularizer,!0,this.biasConstraint)}else this.bias=null;this.built=!0}call(e,t){return ii((()=>{const n=null!=t.training&&t.training;if(3!==(e=e).length)throw new Wd(`LSTMCell expects 3 input Tensors (inputs, h, c), got ${e.length}.`);let s=e[1];const r=e[2];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Sb({ones:()=>Vl(e),rate:this.dropout,training:n,count:4})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Sb({ones:()=>Vl(s),rate:this.recurrentDropout,training:n,count:4}));const a=this.dropoutMask,i=this.recurrentDropoutMask;let o,l,u,c;0<this.dropout&&this.dropout<1&&(e=mi(e,a[0]));let h=Yf(e,this.kernel.read());0<this.recurrentDropout&&this.recurrentDropout<1&&(s=mi(s,i[0])),h=pi(h,Yf(s,this.recurrentKernel.read())),this.useBias&&(h=em(h,this.bias.read()));const[p,d,f,m]=Uu(h,4,h.rank-1);o=this.recurrentActivation.apply(p),l=this.recurrentActivation.apply(d),u=pi(mi(l,r),mi(o,this.activation.apply(f))),c=this.recurrentActivation.apply(m);const g=mi(c,this.activation.apply(u));return[g,g,u]}))}getConfig(){const e=super.getConfig(),t={units:this.units,activation:_y(this.activation),recurrentActivation:_y(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Nm(this.kernelInitializer),recurrentInitializer:Nm(this.recurrentInitializer),biasInitializer:Nm(this.biasInitializer),unitForgetBias:this.unitForgetBias,kernelRegularizer:Wy(this.kernelRegularizer),recurrentRegularizer:Wy(this.recurrentRegularizer),biasRegularizer:Wy(this.biasRegularizer),activityRegularizer:Wy(this.activityRegularizer),kernelConstraint:yf(this.kernelConstraint),recurrentConstraint:yf(this.recurrentConstraint),biasConstraint:yf(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation};return Object.assign({},e,t)}}Ib.className="LSTMCell",Xa(Ib);class $b extends bb{constructor(e){0===e.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),e.cell=new Ib(e),super(e)}call(e,t){return ii((()=>{null!=this.cell.dropoutMask&&(oi(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(oi(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})}))}static fromConfig(e,t){return 0===t.implmentation&&(t.implementation=1),new e(t)}}$b.className="LSTM",Xa($b);class Cb extends xb{constructor(e){super(e),this.cells=e.cells}get stateSize(){const e=[];for(const t of this.cells.slice().reverse())Array.isArray(t.stateSize)?e.push(...t.stateSize):e.push(t.stateSize);return e}call(e,t){return ii((()=>{let n=(e=e).slice(1);const s=[];for(const e of this.cells.slice().reverse())Array.isArray(e.stateSize)?s.push(n.splice(0,e.stateSize.length)):s.push(n.splice(0,1));s.reverse();const r=[];let a;for(let i=0;i<this.cells.length;++i){const o=this.cells[i];n=s[i],a=0===i?[e[0]].concat(n):[a[0]].concat(n),a=o.call(a,t),r.push(a.slice(1))}n=[];for(const e of r.slice().reverse())n.push(...e);return[a[0]].concat(n)}))}build(e){let t;Am(e)&&(e=e[0]),e=e,this.cells.forEach(((n,s)=>{Rf(`RNNCell_${s}`,(()=>{n.build(e),t=Array.isArray(n.stateSize)?n.stateSize[0]:n.stateSize,e=[e[0],t]}))})),this.built=!0}getConfig(){const e=super.getConfig(),t={cells:this.cells.map((e=>({className:e.getClassName(),config:e.getConfig()})))};return Object.assign({},e,t)}static fromConfig(e,t,n={}){const s=[];for(const e of t.cells)s.push(ag(e,n));return new e({cells:s})}get trainableWeights(){if(!this.trainable)return[];const e=[];for(const t of this.cells)e.push(...t.trainableWeights);return e}get nonTrainableWeights(){const e=[];for(const t of this.cells)e.push(...t.nonTrainableWeights);if(!this.trainable){const t=[];for(const e of this.cells)t.push(...e.trainableWeights);return t.concat(e)}return e}getWeights(){const e=[];for(const t of this.cells)e.push(...t.weights);return Lm(e)}setWeights(e){const t=[];for(const n of this.cells){const s=n.weights.length,r=e.splice(s);for(let e=0;e<n.weights.length;++e)t.push([n.weights[e],r[e]])}zm(t)}}function Sb(e){const{ones:t,rate:n,training:s=!1,count:r=1}=e,a=()=>tm(t(),n),i=()=>nm(a,t,s);if(!r||r<=1)return li(i().clone());return Array(r).fill(void 0).map(i).map((e=>li(e.clone())))}Cb.className="StackedRNNCells",Xa(Cb);var Tb=function(e,t){var n={};for(var s in e)Object.prototype.hasOwnProperty.call(e,s)&&t.indexOf(s)<0&&(n[s]=e[s]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var r=0;for(s=Object.getOwnPropertySymbols(e);r<s.length;r++)t.indexOf(s[r])<0&&Object.prototype.propertyIsEnumerable.call(e,s[r])&&(n[s[r]]=e[s[r]])}return n};class Eb extends bb{constructor(e){if(e.unroll)throw new Vd("Unrolling is not possible with convolutional RNNs.");if(Array.isArray(e.cell))throw new Vd("It is not possible at the moment to stack convolutional cells.");super(e),this.inputSpec=[new Bm({ndim:5})]}call(e,t){return ii((()=>{if(null!=this.cell.dropoutMask&&(oi(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(oi(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null),t&&t.constants)throw new Wd("ConvRNN2D cell does not support constants");const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})}))}computeOutputShape(e){let t=this.computeSingleOutputShape(e);return this.returnSequences||(t=[t[0],...t.slice(2)]),this.returnState&&(t=[t,...Array(2).fill([e[0],...t.slice(-3)])]),t}getInitialState(e){return ii((()=>{const{stateSize:t}=this.cell,n=e.shape,s=this.computeSingleOutputShape(n),r=Rl([s[0],...s.slice(2)]);return Array.isArray(t)?Array(t.length).fill(r):[r]}))}resetStates(e,t=!1){ii((()=>{if(!this.stateful)throw new Bd("Cannot call resetStates() on an RNN Layer that is not stateful.");const n=this.inputSpec[0].shape,s=this.computeSingleOutputShape(n),r=[s[0],...s.slice(2)];if(null==n[0])throw new Wd("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.getStates())Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>Rl(r))):this.states_=[Rl(r)];else if(null==e)oi(this.states_),null!=this.keptStates&&(oi(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>Rl(r))):this.states_[0]=Rl(r);else{if(Array.isArray(e)||(e=[e]),e.length!==this.states_.length)throw new Wd(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${e.length} state value(s). Input received: ${e}`);t?this.keptStates.push(this.states_.slice()):oi(this.states_);for(let t=0;t<this.states_.length;++t){const n=e[t],s=r;if(!d(n.shape,s))throw new Wd(`State ${t} is incompatible with layer ${this.name}: expected shape=${s}, received shape=${n.shape}`);this.states_[t]=n}}this.states_=this.states_.map((e=>li(e.clone())))}))}computeSingleOutputShape(e){const{dataFormat:t,filters:n,kernelSize:s,padding:r,strides:a,dilationRate:i}=this.cell,o="channelsFirst"===t,l=e[o?3:2],u=e[o?4:3],c=Jy(l,s[0],r,a[0],i[0]),h=Jy(u,s[1],r,a[1],i[1]);return[...e.slice(0,2),...o?[n,c,h]:[c,h,n]]}}Eb.className="ConvRNN2D";class Ab extends Ib{constructor(e){const{filters:t,kernelSize:n,strides:s,padding:r,dataFormat:a,dilationRate:i}=e;super(Object.assign({},e,{units:t})),this.filters=t,of(this.filters,"filters"),this.kernelSize=Yy(n,2,"kernelSize"),this.kernelSize.forEach((e=>of(e,"kernelSize"))),this.strides=Yy(s||1,2,"strides"),this.strides.forEach((e=>of(e,"strides"))),this.padding=r||"valid",Tf(this.padding),this.dataFormat=a||"channelsLast",Sf(this.dataFormat),this.dilationRate=Yy(i||1,2,"dilationRate"),this.dilationRate.forEach((e=>of(e,"dilationRate")))}build(e){var t;e=Dm(e);const n="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[n])throw new Wd(`The channel dimension of the input should be defined. Found ${e[n]}`);const s=e[n],r=this.kernelSize.concat([s,4*this.filters]);this.kernel=this.addWeight("kernel",r,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint);const a=this.kernelSize.concat([this.filters,4*this.filters]);if(this.recurrentKernel=this.addWeight("recurrent_kernel",a,null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){let e;if(this.unitForgetBias){const n=this.biasInitializer,s=this.filters;e=new((t=class extends am{apply(e,t){return jf([n.apply([s]),Fl([s]),n.apply([2*s])])}}).className="CustomInit",t)}else e=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.filters],null,e,this.biasRegularizer,!0,this.biasConstraint)}this.built=!0}call(e,t){return ii((()=>{if(3!==e.length)throw new Wd(`ConvLSTM2DCell expects 3 input Tensors (inputs, h, c), got ${e.length}.`);const n=t.training||!1,s=e[0],r=e[1],a=e[2];0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Sb({ones:()=>Vl(s),rate:this.dropout,training:n,count:4}));const i=this.dropoutMask,o=(e,t,n)=>t&&t[n]?mi(t[n],e):e;let l=o(s,i,0),u=o(s,i,1),c=o(s,i,2),h=o(s,i,3);0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Sb({ones:()=>Vl(r),rate:this.recurrentDropout,training:n,count:4}));const p=this.recurrentDropoutMask;let d=o(r,p,0),f=o(r,p,1),m=o(r,p,2),g=o(r,p,3);const[y,b,x,w]=Uu(this.kernel.read(),4,3),[k,v,N,I]=this.useBias?Uu(this.bias.read(),4):[null,null,null,null];l=this.inputConv(l,y,k,this.padding),u=this.inputConv(u,b,v,this.padding),c=this.inputConv(c,x,N,this.padding),h=this.inputConv(h,w,I,this.padding);const[$,C,S,T]=Uu(this.recurrentKernel.read(),4,3);d=this.recurrentConv(d,$),f=this.recurrentConv(f,C),m=this.recurrentConv(m,S),g=this.recurrentConv(g,T);const E=this.recurrentActivation.apply(pi(l,d)),A=this.recurrentActivation.apply(pi(u,f)),R=pi(mi(A,a),mi(E,this.activation.apply(pi(c,m)))),F=mi(this.recurrentActivation.apply(pi(h,g)),this.activation.apply(R));return[F,F,R]}))}getConfig(){const e=super.getConfig(),{units:t}=e,n=Tb(e,["units"]),s={filters:this.filters,kernelSize:this.kernelSize,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,strides:this.strides};return Object.assign({},n,s)}inputConv(e,t,n,s){const r=uo(e,t,this.strides,s||"valid","channelsFirst"===this.dataFormat?"NCHW":"NHWC",this.dilationRate);return n?em(r,n,this.dataFormat):r}recurrentConv(e,t){return uo(e,t,1,"same","channelsFirst"===this.dataFormat?"NCHW":"NHWC")}}Ab.className="ConvLSTM2DCell",Xa(Ab);class Rb extends Eb{constructor(e){const t=new Ab(e);super(Object.assign({},e,{cell:t}))}static fromConfig(e,t){return new e(t)}}Rb.className="ConvLSTM2D",Xa(Rb);class Fb extends Gm{constructor(e){super(e),this.rate=Math.max(Math.min(e.rate,1),0),this.noiseShape=e.noiseShape,this.seed=e.seed,this.supportsMasking=!0}getNoiseShape(e){if(null==this.noiseShape)return this.noiseShape;const t=e.shape,n=[];for(let e=0;e<this.noiseShape.length;++e)n.push(null==this.noiseShape[e]?t[e]:this.noiseShape[e]);return n}call(e,t){return ii((()=>{this.invokeCallHook(e,t);const n=Fm(e);if(0<this.rate&&this.rate<1){const e=null!=t.training&&t.training,s=this.getNoiseShape(n);return nm((()=>tm(n,this.rate,s,this.seed)),(()=>n),e)}return e}))}getConfig(){const e={rate:this.rate,noiseShape:this.noiseShape,seed:this.seed},t=super.getConfig();return Object.assign(e,t),e}dispose(){return super.dispose()}}Fb.className="Dropout",Xa(Fb);class Db extends Fb{constructor(e){super(e),this.inputSpec=[{ndim:3}]}getNoiseShape(e){const t=e.shape;return[t[0],1,t[2]]}}Db.className="SpatialDropout1D",Xa(Db);class _b extends Gm{constructor(e){if(super(e),this.activation=null,this.useBias=!0,this.kernel=null,this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",null==e.batchInputShape&&null==e.inputShape&&null!=e.inputDim){let t=null;null!=e.batchSize&&(t=e.batchSize),this.batchInputShape=[t,e.inputDim]}this.units=e.units,of(this.units,"units"),this.activation=My(e.activation),null!=e.useBias&&(this.useBias=e.useBias),this.kernelInitializer=Im(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.biasInitializer=Im(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelConstraint=xf(e.kernelConstraint),this.biasConstraint=xf(e.biasConstraint),this.kernelRegularizer=Uy(e.kernelRegularizer),this.biasRegularizer=Uy(e.biasRegularizer),this.activityRegularizer=Uy(e.activityRegularizer),this.supportsMasking=!0,this.inputSpec=[{minNDim:2}]}build(e){const t=(e=Dm(e))[e.length-1];null==this.kernel&&(this.kernel=this.addWeight("kernel",[t,this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint))),this.inputSpec=[{minNDim:2,axes:{[-1]:t}}],this.built=!0}computeOutputShape(e){const t=(e=Dm(e)).slice();return t[t.length-1]=this.units,t}call(e,t){return ii((()=>{this.invokeCallHook(e,t);const n=Fm(e),s=uf(this.activation.getClassName());let r;return null!=s?r=Yf(n,this.kernel.read(),s,this.bias?this.bias.read():null):(r=Yf(n,this.kernel.read()),null!=this.bias&&(r=em(r,this.bias.read())),null!=this.activation&&(r=this.activation.apply(r))),r}))}getConfig(){const e={units:this.units,activation:_y(this.activation),useBias:this.useBias,kernelInitializer:Nm(this.kernelInitializer),biasInitializer:Nm(this.biasInitializer),kernelRegularizer:Wy(this.kernelRegularizer),biasRegularizer:Wy(this.biasRegularizer),activityRegularizer:Wy(this.activityRegularizer),kernelConstraint:yf(this.kernelConstraint),biasConstraint:yf(this.biasConstraint)},t=super.getConfig();return Object.assign(e,t),e}}_b.className="Dense",Xa(_b);class Ob extends Gm{constructor(e){super(e=e||{}),this.inputSpec=[{minNDim:3}],this.dataFormat=e.dataFormat}computeOutputShape(e){e=Dm(e);for(const t of e.slice(1))if(null==t)throw new Wd(`The shape of the input to "Flatten" is not fully defined (got ${e.slice(1)}). Make sure to pass a complete "input_shape" or "batch_input_shape" argument to the first layer in your model.`);return[e[0],Mf(e,1)]}call(e,t){return ii((()=>{this.invokeCallHook(e,t);let n=Fm(e);if("channelsFirst"===this.dataFormat&&n.rank>1){const e=[0];for(let t=2;t<n.rank;++t)e.push(t);e.push(1),n=n.transpose(e)}return function(e){if(e.rank<=1)throw new Wd(`batchFlatten requires a minimum rank of 2. Got rank: ${e.rank}.`);const t=[e.shape[0],Mf(e.shape,1)];return e.reshape(t)}(n)}))}getConfig(){const e={};null!=this.dataFormat&&(e.dataFormat=this.dataFormat);const t=super.getConfig();return Object.assign(e,t),e}}Ob.className="Flatten",Xa(Ob);class Mb extends Gm{constructor(e){super(e),this.supportsMasking=!0,this.activation=My(e.activation)}call(e,t){return ii((()=>{this.invokeCallHook(e,t);const n=Fm(e);return this.activation.apply(n)}))}getConfig(){const e={activation:_y(this.activation)},t=super.getConfig();return Object.assign(e,t),e}}Mb.className="Activation",Xa(Mb);class Lb extends Gm{constructor(e){super(e),this.n=e.n,this.inputSpec=[{ndim:2}]}computeOutputShape(e){return[e[0],this.n,e[1]]}call(e,t){return ii((()=>{return e=Fm(e),t=e,n=this.n,ii((()=>{if(2!==t.shape.length)throw new Wd(`repeat() expects a rank-2 tensor, but received a rank-${t.shape.length} tensor.`);return Kf(Vf(t,1),[1,n,1])}));var t,n}))}getConfig(){const e={n:this.n},t=super.getConfig();return Object.assign(e,t),e}}Lb.className="RepeatVector",Xa(Lb);class zb extends Gm{constructor(e){super(e),this.targetShape=e.targetShape;for(let e=0;e<this.targetShape.length;++e)this.isUnknown(this.targetShape[e])&&(this.targetShape[e]=null)}isUnknown(e){return e<0||null==e}fixUnknownDimension(e,t){const n="Total size of new array must be unchanged.",s=t.slice();let r=1,a=null;for(let e=0;e<s.length;++e){const t=s[e];if(this.isUnknown(t)){if(null!==a)throw new Wd("Can only specifiy one unknown dimension.");a=e}else r*=t}const i=Mf(e);if(null!==a){if(0===r||i%r!=0)throw new Wd(n);s[a]=i/r}else if(i!==r)throw new Wd(n);return s}computeOutputShape(e){let t=!1;for(let n=0;n<e.length;++n)if(this.isUnknown(e[n])){t=!0;break}return t?e.slice(0,1).concat(this.targetShape):e.slice(0,1).concat(this.fixUnknownDimension(e.slice(1),this.targetShape))}call(e,t){return ii((()=>{this.invokeCallHook(e,t);const n=Fm(e),s=n.shape,r=s.slice(0,1).concat(this.fixUnknownDimension(s.slice(1),this.targetShape));return n.reshape(r)}))}getConfig(){const e={targetShape:this.targetShape},t=super.getConfig();return Object.assign(e,t),e}}zb.className="Reshape",Xa(zb);class Bb extends Gm{constructor(e){if(super(e),null==e.dims)throw new Error("Required configuration field `dims` is missing during Permute constructor call.");if(!Array.isArray(e.dims))throw new Error(`Permute constructor requires \`dims\` to be an Array, but received ${e.dims} instead.`);const t=Pf(1,e.dims.length+1);if(!d(e.dims.slice().sort(),t))throw new Error("Invalid permutation `dims`: "+JSON.stringify(e.dims)+" `dims` must contain consecutive integers starting from 1.");this.dims=e.dims,this.dimsIncludingBatch=[0].concat(this.dims),this.inputSpec=[new Bm({ndim:this.dims.length+1})]}computeOutputShape(e){const t=(e=Dm(e)).slice();return this.dims.forEach(((n,s)=>{t[s+1]=e[n]})),t}call(e,t){return ma(Fm(e),this.dimsIncludingBatch)}getConfig(){const e={dims:this.dims},t=super.getConfig();return Object.assign(e,t),e}}Bb.className="Permute",Xa(Bb);class Pb extends Gm{constructor(e){super(null==e?{}:e),this.supportsMasking=!0,this.maskValue=null!=e?null==e.maskValue?0:e.maskValue:0}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={maskValue:this.maskValue};return Object.assign(t,e),t}computeMask(e,t){const n=Fm(e);return ki(Wl(n,this.maskValue),-1)}call(e,t){return ii((()=>{this.invokeCallHook(e,t);const n=Fm(e),s=ki(Wl(n,this.maskValue),-1,!0);return n.mul(s.asType(n.dtype))}))}}Pb.className="Masking",Xa(Pb);class Wb extends Gm{constructor(e){if(super(e),this.embeddings=null,this.DEFAULT_EMBEDDINGS_INITIALIZER="randomUniform",null==e.batchInputShape&&null==e.inputShape){let t=null;null!=e.batchSize&&(t=e.batchSize),null==e.inputLength?this.batchInputShape=[t,null]:this.batchInputShape=[t].concat(Kd(e.inputLength))}this.inputDim=e.inputDim,of(this.inputDim,"inputDim"),this.outputDim=e.outputDim,of(this.outputDim,"outputDim"),this.embeddingsInitializer=Im(e.embeddingsInitializer||this.DEFAULT_EMBEDDINGS_INITIALIZER),this.embeddingsRegularizer=Uy(e.embeddingsRegularizer),this.activityRegularizer=Uy(e.activityRegularizer),this.embeddingsConstraint=xf(e.embeddingsConstraint),this.maskZero=e.maskZero,this.supportsMasking=e.maskZero,this.inputLength=e.inputLength}build(e){this.embeddings=this.addWeight("embeddings",[this.inputDim,this.outputDim],this.dtype,this.embeddingsInitializer,this.embeddingsRegularizer,!0,this.embeddingsConstraint),this.built=!0}warnOnIncompatibleInputShape(e){}computeMask(e,t){return ii((()=>this.maskZero?(e=Fm(e),Wl(e,Ao(e))):null))}computeOutputShape(e){if(e=Dm(e),null==this.inputLength)return[...e,this.outputDim];const t=Kd(this.inputLength);if(t.length!==e.length-1)throw new Wd(`"inputLength" is ${this.inputLength}, but received input shape has shape ${e}`);{let n=0;for(let s=0;s<t.length;++s){const r=t[s],a=e[s+1];if(null!=r&&null!=a&&r!==a)throw new Wd(`"inputLength" is ${this.inputLength}, but received input shape has shape ${e}`);null==r&&(t[n]=a),n++}}return[e[0],...t,this.outputDim]}call(e,t){return ii((()=>{this.invokeCallHook(e,t);let n=Fm(e);"int32"!==n.dtype&&(n=Wf(n,"int32"));return Jf(this.embeddings.read(),n.as1D()).reshape(Dm(this.computeOutputShape(n.shape)))}))}getConfig(){const e={inputDim:this.inputDim,outputDim:this.outputDim,embeddingsInitializer:Nm(this.embeddingsInitializer),embeddingsRegularizer:Wy(this.embeddingsRegularizer),activityRegularizer:Wy(this.activityRegularizer),embeddingsConstraint:yf(this.embeddingsConstraint),maskZero:this.maskZero,inputLength:this.inputLength},t=super.getConfig();return Object.assign(e,t),e}}Wb.className="Embedding",Xa(Wb);class Vb extends Gm{constructor(e){super(e||{}),this.supportsMasking=!0}mergeFunction(e){throw new Vd}computeElementwiseOpOutputShape(e,t){if(null==e||null==t)return null;if(e.length<t.length)return this.computeElementwiseOpOutputShape(t,e);if(0===t.length)return e;const n=e.slice(0,e.length-t.length);for(let s=0;s<t.length;++s){const r=e[e.length-t.length+s],a=t[s];if(null==r||null==a||r<0||a<0)n.push(null);else if(1===r)n.push(a);else if(1===a)n.push(r);else{if(r!==a)throw new Wd("Operands could not be broadcast together with shapes "+JSON.stringify(e)+" "+JSON.stringify(t));n.push(r)}}return n}build(e){if(Array.isArray(e)&&!Array.isArray(e[0])&&(e=[Dm(e)]),(e=e).length<2)throw new Wd(`A merge layer should be called on an Array of at least 2 inputs. Got ${e.length} input(s).`);let t=[];for(const n of e)null!=n&&null!==n[0]&&t.push(n[0]);if(t=nf(t),t.length>1)throw new Wd(`Can not merge tensors with different batch sizes. Got tensors with shapes: ${JSON.stringify(e)}.`);let n=null==e[0]?null:e[0].slice(1);for(let t=1;t<e.length;++t){const s=null==e[t]?null:e[t].slice(1);n=this.computeElementwiseOpOutputShape(n,s)}const s=e.map((e=>e.length));-1===e.indexOf(null)&&1===nf(s).length?this.reshapeRequired=!1:this.reshapeRequired=!0}call(e,t){return ii((()=>{if(e=e,this.reshapeRequired){const t=[],n=e.map((e=>e.rank));if(-1===n.indexOf(null)){const s=Bf(n);for(let n of e){const e=n.rank;for(let t=0;t<s-e;++t)n=Vf(n,1);t.push(n)}return this.mergeFunction(t)}{let n=!1;for(const s of e){const e=s.rank;if(null==e){const e=s.shape,r=e[0],a=e.slice(1).concat([r]);let i=s.reshape([r].concat(Mf(e.slice(1))));i=ma(i,[1,0]),i=i.reshape(a),t.push(i),n=!0}else if(e>1){const r=Pf(1,e).concat([0]);t.push(ma(s,r)),n=!0}else t.push(s)}let s=this.mergeFunction(t);const r=s.rank;if(n)if(null==r){const e=s.shape,t=e[e.length-1],n=[t].concat(e.slice(0,e.length-1));s=ma(s.reshape([-1,t]),[1,0]).reshape(n)}else if(r>1){const e=[r-1].concat(Pf(0,r-1));s=ma(s,e)}return s}}return this.mergeFunction(e)}))}computeOutputShape(e){let t;t=null==(e=e)[0]?null:e[0].slice(1);for(let n=1;n<e.length;++n){const s=null==e[n]?null:e[n].slice(1);t=this.computeElementwiseOpOutputShape(t,s)}let n=[];for(const t of e)null!=t&&null!==t[0]&&n.push(t[0]);return n=nf(n),t=1===n.length?n.concat(t):[null].concat(t),t}computeMask(e,t){return ii((()=>{if(null==t)return null;if(!Array.isArray(t))throw new Wd("`mask` should be an Array");if(!Array.isArray(e))throw new Wd("`inputs` should be an Array");if(t.length!==e.length)throw new Wd(`The Array 'inputs' and 'mask' are expected to have the same length, but have different lengths (${e.length} vs ${t.length})`);if(t.every((e=>null==e)))return null;let n=(t=t.map((e=>null==e?e:Lo(e,0))))[0];for(let e=1;e<t.length-1;++e)n=vl(n,t[e]);return n}))}}class Ub extends Vb{constructor(e){super(e)}mergeFunction(e){return ii((()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=pi(t,e[n]);return t}))}}Ub.className="Add",Xa(Ub);class Gb extends Vb{constructor(e){super(e)}mergeFunction(e){return ii((()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=mi(t,e[n]);return t}))}}Gb.className="Multiply",Xa(Gb);class Hb extends Vb{constructor(e){super(e)}mergeFunction(e){return ii((()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=pi(t,e[n]);return mi(1/e.length,t)}))}}Hb.className="Average",Xa(Hb);class jb extends Vb{constructor(e){super(e)}mergeFunction(e){return ii((()=>{let t=e[0];for(let n=1;n<e.length;++n)t=El(t,e[n]);return t}))}}jb.className="Maximum",Xa(jb);class qb extends Vb{constructor(e){super(e)}mergeFunction(e){return ii((()=>{let t=e[0];for(let n=1;n<e.length;++n)t=_l(t,e[n]);return t}))}}qb.className="Minimum",Xa(qb);class Kb extends Vb{constructor(e){super(e),this.DEFAULT_AXIS=-1,null==e&&(e={}),this.axis=null==e.axis?this.DEFAULT_AXIS:e.axis,this.supportsMasking=!0,this.reshapeRequired=!1}build(e){if(!Array.isArray(e)||!Array.isArray(e[0])||1===e.length)throw new Wd("A `Concatenate` layer should be called on a list of at least 2 inputs");e=e;let t=!0;for(const n of e)if(null!=n){t=!1;break}if(t)return;const n=[];for(let t=0;t<e.length;++t){const s=e[t].slice();s.splice(this.axis,1);let r=!1;for(const e of n)if(d(e,s)){r=!0;break}r||n.push(s)}if(n.length>1)throw new Wd("A `Concatenate` layer requires inputs with matching shapes except for the concat axis. Got input shapes: "+JSON.stringify(e))}mergeFunction(e){return ii((()=>jf(e,this.axis)))}computeOutputShape(e){if(!Array.isArray(e)||!Array.isArray(e[0]))throw new Wd("A `Concatenate` layer should be called on a list of inputs.");const t=e,n=t[0].slice(),s=this.axis<0?n.length+this.axis:this.axis;for(const e of t.slice(1)){if(null==n[s]||null==e[s]){n[s]=null;break}n[s]+=e[s]}return n}computeMask(e,t){if(null==t)return null;if(!Array.isArray(t))throw new Wd("`mask` should be an array for Concatenate");if(!Array.isArray(e))throw new Wd("`inputs` should be an array for Concatenate");if(t.length!==e.length)throw new Wd(`Mismatch in the length of mask (${t.length}) and the legnth of inputs (${e.length})`);return ii((()=>{let n=!0;if(t.forEach((e=>{null==e||(n=!1)})),n)return null;const s=[];for(let n=0;n<e.length;++n)null==t[n]?s.push(Vl(e[n]).asType("bool")):t[n].rank<e[n].rank?s.push(Lo(t[n],-1)):s.push(t[n]);const r=Hi(s,this.axis);return wi(r,-1,!1)}))}getConfig(){const e={axis:this.axis},t=super.getConfig();return Object.assign(e,t),e}}function Xb(e,t){for(;e<0;)e+=t;return e}Kb.className="Concatenate",Xa(Kb);class Yb extends Vb{constructor(e){super(e),this.axes=e.axes,this.normalize=null!=e.normalize&&e.normalize,this.supportsMasking=!0,this.reshapeRequired=!1}build(e){l(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const t=e[0],n=e[1];if(t.length>3||n.length>3)throw new Vd("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(t,n);if(t[s[0]]!==n[s[1]])throw new Wd(`Dimension incompatibility: ${t[s[0]]} !== ${n[s[1]]}`)}mergeFunction(e){if(2!==e.length)throw new Wd(`A \`Dot\` layer must be called on exactly 2 inputs, but received ${e.length} input(s).`);let t,n=e[0],s=e[1];return t=Array.isArray(this.axes)?this.axes.map(((t,n)=>Xb(t,e[n].shape.length))):[Xb(this.axes,n.shape.length),Xb(this.axes,s.shape.length)],this.normalize&&(n=ig(n,t[0]),s=ig(s,t[1])),function(e,t,n){if(e.shape.length>3||t.shape.length>3)throw new Vd("batchDot is not implemented for tensors of 4D or higher rank yet");if(l(e.shape.length>=2,(()=>`batchDot requires the rank of x to be >= 2, but got ${e.shape.length}`)),l(e.shape.length>=2,(()=>`batchDot requires the rank of y to be >= 2, but got ${t.shape.length}`)),"number"==typeof n&&(n=[n,n]),"complex64"===e.dtype||"complex64"===t.dtype)throw new Vd("batchDot is not implemented for complex64-type Tensors yet.");const s=e.shape.length,r=t.shape.length;null==n&&(n=[s-1,r-2]);const a=n;return ii((()=>{let n,i;if(s>r){n=s-r;const e=[];for(let t=0;t<n;++t)e.push(1);t=t.reshape(t.shape.concat(e))}else if(r>s){n=r-s;const t=[];for(let e=0;e<n;++e)t.push(1);e=e.reshape(e.shape.concat(t))}else n=0;if(2===e.shape.length&&2===t.shape.length)i=a[0]===a[1]?e.mul(t).sum(a[0]):e.transpose([1,0]).mul(t).sum(a[1]);else{const n=a[0]!==e.shape.length-1,s=a[1]===t.shape.length-1;i=e.matMul(t,n,s)}if(n>0){let e;e=s>r?s+r-3:s-1;const t=[];for(let s=e;s<e+n;++s)t.push(s);i=i.squeeze(t)}return 1===i.shape.length&&(i=i.expandDims(1)),i}))}(n,s,t)}interpretAxes(e,t){let n;return n=Array.isArray(this.axes)?this.axes:[Xb(this.axes,e.length),Xb(this.axes,t.length)],n}computeOutputShape(e){l(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const t=e[0].slice(),n=e[1].slice();if(t.length>3||n.length>3)throw new Vd("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(t,n);t.splice(s[0],1),n.splice(s[1],1),n.splice(0,1);const r=t.concat(n);return 1===r.length&&r.push(1),r}computeMask(e,t){return null}getConfig(){const e={axes:this.axes,normalize:this.normalize},t=super.getConfig();return Object.assign(e,t),e}}Yb.className="Dot",Xa(Yb);class Jb extends Gm{constructor(e){super(e),this.supportsMasking=!0,this.stddev=e.stddev}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={stddev:this.stddev};return Object.assign(t,e),t}call(e,t){return ii((()=>{this.invokeCallHook(e,t);const n=Fm(e);return nm((()=>Xf(n.shape,0,this.stddev).add(n)),(()=>n),t.training||!1)}))}}Jb.className="GaussianNoise",Xa(Jb);class Zb extends Gm{constructor(e){super(e),this.supportsMasking=!0,this.rate=e.rate}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={rate:this.rate};return Object.assign(t,e),t}call(e,t){return ii((()=>{this.invokeCallHook(e,t);const n=Fm(e);if(this.rate>0&&this.rate<1){return nm((()=>{const e=Math.sqrt(this.rate/(1-this.rate));return n.mul(Xf(n.shape,1,e))}),(()=>n),t.training||!1)}return n}))}}Zb.className="GaussianDropout",Xa(Zb);class Qb extends Gm{constructor(e){super(e),this.supportsMasking=!0,this.rate=e.rate,this.noiseShape=e.noiseShape}_getNoiseShape(e){return this.noiseShape||Fm(e).shape}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={rate:this.rate};return Object.assign(t,e),t}call(e,t){return ii((()=>{if(this.rate<1&&this.rate>0){const n=this._getNoiseShape(e);return nm((()=>{const t=Fm(e),s=-1.7580993408473766;let r=Ho(mu(n),this.rate);r=Wf(r,"float32");const a=((1-this.rate)*(1+this.rate*s**2))**-.5,i=-a*s*this.rate;return t.mul(r).add(r.add(-1).mul(s)).mul(a).add(i)}),(()=>Fm(e)),t.training||!1)}return e}))}}function ex(e,t,n,s,r,a=.001){let i;if(2===e.rank)i=Zi(e,t,n,s,r,a);else if(3===e.rank)i=Qi(e,t,n,s,r,a);else{if(4!==e.rank)throw new Vd(`batchNormalization is not implemented for array of rank ${e.rank} yet`);i=eo(e,t,n,s,r,a)}return i}function tx(e,t,n,s,r=.001){return d(s.slice().sort(),Pf(0,e.rank-1))?function(e,t,n,s,r=.001){return ii((()=>{const a=zl(e,s),i=a.mean,o=a.variance;return[ex(e,i,o,n,t,r),i,o]}))}(e,t,n,s,r):function(e,t,n,s,r=.001){return ii((()=>{const a=zl(e,s),i=a.mean,o=a.variance,l=[];for(const t of Pf(0,e.rank))-1!==s.indexOf(t)?l.push(1):l.push(e.shape[t]);const u=i.reshape(l),c=o.reshape(l),h=null==t?null:t.reshape(l),p=null==n?null:n.reshape(l);return[ex(e,u,c,p,h,r),i,o]}))}(e,t,n,s,r)}Qb.className="AlphaDropout",Xa(Qb);class nx extends Gm{constructor(e){null==e&&(e={}),super(e),this.supportsMasking=!0,this.axis=null==e.axis?-1:e.axis,this.momentum=null==e.momentum?.99:e.momentum,this.epsilon=null==e.epsilon?.001:e.epsilon,this.center=null==e.center||e.center,this.scale=null==e.scale||e.scale,this.betaInitializer=Im(e.betaInitializer||"zeros"),this.gammaInitializer=Im(e.gammaInitializer||"ones"),this.movingMeanInitializer=Im(e.movingMeanInitializer||"zeros"),this.movingVarianceInitializer=Im(e.movingVarianceInitializer||"ones"),this.betaConstraint=xf(e.betaConstraint),this.gammaConstraint=xf(e.gammaConstraint),this.betaRegularizer=Uy(e.betaRegularizer),this.gammaRegularizer=Uy(e.gammaRegularizer)}build(e){e=Dm(e);const t=this.axis>=0?this.axis:this.axis+e.length,n=e[t];if(null==n)throw new Wd(`Axis ${t} of input tensor should have a defined dimension but the layer received an input with shape ${JSON.stringify(e)}.`);this.inputSpec=[new Bm({ndim:e.length,axes:{[t]:n}})];const s=[n];this.scale&&(this.gamma=this.addWeight("gamma",s,null,this.gammaInitializer,this.gammaRegularizer,!0,this.gammaConstraint)),this.center&&(this.beta=this.addWeight("beta",s,null,this.betaInitializer,this.betaRegularizer,!0,this.betaConstraint)),this.movingMean=this.addWeight("moving_mean",s,null,this.movingMeanInitializer,null,!1),this.movingVariance=this.addWeight("moving_variance",s,null,this.movingVarianceInitializer,null,!1),this.built=!0}call(e,t){return ii((()=>{const n=null!=t.training&&t.training,s=Fm(e),r=s.shape,a=r.length,i=Pf(0,a),o=this.axis>=0?this.axis:this.axis+a;i.splice(o,1);const l=Gd(1,a);l[o]=r[o];const u=i.slice();u.sort();const c=!d(u,Pf(0,a).slice(0,a-1));if(!n)return(()=>{if(c){const e=this.movingMean.read().reshape(l),t=this.movingVariance.read().reshape(l),n=this.center?this.beta.read().reshape(l):null,r=this.scale?this.gamma.read().reshape(l):null;return ex(s,e,t,n,r,this.epsilon)}return ex(s,this.movingMean.read(),this.movingVariance.read(),null==this.beta?null:this.beta.read(),null==this.gamma?null:this.gamma.read(),this.epsilon)})();const[h,p,f]=tx(s,this.gamma.read(),this.beta.read(),i,this.epsilon),m=(e,t,n)=>{ii((()=>{const s=1-n,r=e.read(),a=r.sub(t).mul(s);e.write(r.sub(a))}))};return(()=>{m(this.movingMean,p,this.momentum),m(this.movingVariance,f,this.momentum)})(),h}))}getConfig(){const e={axis:this.axis,momentum:this.momentum,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Nm(this.betaInitializer),gammaInitializer:Nm(this.gammaInitializer),movingMeanInitializer:Nm(this.movingMeanInitializer),movingVarianceInitializer:Nm(this.movingVarianceInitializer),betaRegularizer:Wy(this.betaRegularizer),gammaRegularizer:Wy(this.gammaRegularizer),betaConstraint:yf(this.betaConstraint),gammaConstraint:yf(this.gammaConstraint)},t=super.getConfig();return Object.assign(e,t),e}}nx.className="BatchNormalization",Xa(nx);class sx extends Gm{constructor(e){if(null==e&&(e={}),super(e),this.axis=null==e.axis?-1:e.axis,"number"==typeof this.axis){if(!Number.isInteger(this.axis))throw new Error(`Expected axis to be an integer, but received ${this.axis}`)}else{if(!Array.isArray(this.axis))throw new Error(`Expected axis to be an integer or an array of integers, but received ${JSON.stringify(this.axis)}`);for(const e of this.axis)if(!Number.isInteger(e))throw new Error(`Expected axis to be an array of integers, but received ${JSON.stringify(this.axis)}`)}this.epsilon=null==e.epsilon?.001:e.epsilon,this.center=null==e.center||e.center,this.scale=null==e.scale||e.scale,this.betaInitializer=Im(e.betaInitializer||"zeros"),this.gammaInitializer=Im(e.gammaInitializer||"ones"),this.betaRegularizer=Uy(e.betaRegularizer),this.gammaRegularizer=Uy(e.gammaRegularizer),this.supportsMasking=!0}build(e){const t=(e=Dm(e)).length;"number"==typeof this.axis&&(this.axis=[this.axis]);for(let e=0;e<this.axis.length;++e)this.axis[e]<0&&(this.axis[e]+=t);for(const e of this.axis)if(e<0||e>=t)throw new Error(`Invalid axis: ${e}`);if(this.axis.length!==nf(this.axis).length)throw new Error(`Found duplicate axes in: ${this.axis}`);const n=this.axis.map((t=>e[t]));this.scale?this.gamma=this.addWeight("gamma",n,"float32",this.gammaInitializer,this.gammaRegularizer,true):this.gamma=null,this.center?this.beta=this.addWeight("beta",n,"float32",this.betaInitializer,this.betaRegularizer,true):this.beta=null,this.built=!0}call(e,t){const n=Fm(e),s=n.shape,r=s.length;return ii((()=>{let{mean:e,variance:t}=zl(n,this.axis,!0);const a=Gd(1,r);for(const e of this.axis)a[e]=s[e];const i=e=>null!=e&&e.shape.length!==r&&this.axis!==[r-1]?e.reshape(a):e;let o=i(this.gamma.read()),l=i(this.beta.read());const u=[],c=[];for(let e=0;e<r;++e)-1!==this.axis.indexOf(e)?(u.push(s[e]),c.push(1)):(u.push(1),c.push(s[e]));return e=e.tile(u),t=t.tile(u),o=o.tile(c),l=l.tile(c),ex(n,e,t,l,o,this.epsilon)}))}getConfig(){const e={axis:this.axis,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Nm(this.betaInitializer),gammaInitializer:Nm(this.gammaInitializer),betaRegularizer:Wy(this.betaRegularizer),gammaRegularizer:Wy(this.gammaRegularizer)},t=super.getConfig();return Object.assign(e,t),e}}sx.className="LayerNormalization",Xa(sx);class rx extends Gm{constructor(e){if(null==e&&(e={}),super(e),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,null==e.padding)this.padding=[[1,1],[1,1]];else if("number"==typeof e.padding)this.padding=[[e.padding,e.padding],[e.padding,e.padding]];else{if(e.padding=e.padding,2!==e.padding.length)throw new Wd(`ZeroPadding2D expects padding to be a length-2 array, but received a length-${e.padding.length} array.`);let t,n;if("number"==typeof e.padding[0])t=[e.padding[0],e.padding[0]],n=[e.padding[1],e.padding[1]];else{if(e.padding=e.padding,2!==e.padding[0].length)throw new Wd(`ZeroPadding2D expects height padding to be a length-2 array, but received a length-${e.padding[0].length} array.`);if(t=e.padding[0],2!==e.padding[1].length)throw new Wd(`ZeroPadding2D expects width padding to be a length-2 array, but received a length-${e.padding[1].length} array.`);n=e.padding[1]}this.padding=[t,n]}this.inputSpec=[new Bm({ndim:4})]}computeOutputShape(e){let t,n;return e=Dm(e),"channelsFirst"===this.dataFormat?(t=null!=e[2]&&e[2]>=0?e[2]+this.padding[0][0]+this.padding[0][1]:null,n=null!=e[3]&&e[3]>=0?e[3]+this.padding[1][0]+this.padding[1][1]:null,[e[0],e[1],t,n]):(t=null!=e[1]&&e[1]>=0?e[1]+this.padding[0][0]+this.padding[0][1]:null,n=null!=e[2]&&e[2]>=0?e[2]+this.padding[1][0]+this.padding[1][1]:null,[e[0],t,n,e[3]])}call(e,t){return ii((()=>{return t=Fm(e),n=this.padding,s=this.dataFormat,ii((()=>{if(4!==t.rank)throw new Wd(`temporalPadding expects input tensor to be 4-D, but received a ${t.rank}-D tensor.`);if(null==n&&(n=[[1,1],[1,1]]),2!==n.length||2!==n[0].length||2!==n[1].length)throw new Wd("spatial2dPadding expects `padding` to be an Array of two Arrays, each of which is an Array of two integers.");if(null==s&&(s="channelsLast"),"channelsLast"!==s&&"channelsFirst"!==s)throw new Wd(`Unknown data format: ${s}. Supported data formats are 'channelsLast' and 'channelsFirst.`);let e;return e="channelsFirst"===s?[[0,0],[0,0],n[0],n[1]]:[[0,0],n[0],n[1],[0,0]],Gl(t,e)}));var t,n,s}))}getConfig(){const e={padding:this.padding,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}function ax(e,t,n,s,r,a){return ii((()=>{let i;Sf(r),Ef(a),Tf(s),null==n&&(n=[1,1]),null==s&&(s="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),e=Qy(e,r);const o="same"===s?"same":"valid";return i="max"===a?Cl(e,t,n,o):Ui(e,t,n,o),"channelsFirst"===r&&(i=ma(i,[0,3,1,2])),i}))}function ix(e,t,n,s,r,a){return ii((()=>{let i;Sf(r),Ef(a),Tf(s),null==n&&(n=[1,1,1]),null==s&&(s="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),e=eb(e,r);const o="same"===s?"same":"valid";return i="max"===a?Sl(e,t,n,o):Gi(e,t,n,o),"channelsFirst"===r&&(i=ma(i,[0,4,1,2,3])),i}))}rx.className="ZeroPadding2D",Xa(rx);class ox extends Gm{constructor(e){if(null==e.poolSize&&(e.poolSize=2),super(e),"number"==typeof e.poolSize)this.poolSize=[e.poolSize];else{if(!Array.isArray(e.poolSize)||1!==e.poolSize.length||"number"!=typeof e.poolSize[0])throw new Wd(`poolSize for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(e.poolSize)}`);this.poolSize=e.poolSize}if(of(this.poolSize,"poolSize"),null==e.strides)this.strides=this.poolSize;else if("number"==typeof e.strides)this.strides=[e.strides];else{if(!Array.isArray(e.strides)||1!==e.strides.length||"number"!=typeof e.strides[0])throw new Wd(`strides for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(e.strides)}`);this.strides=e.strides}of(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,Tf(this.padding),this.inputSpec=[new Bm({ndim:3})]}computeOutputShape(e){const t=Jy((e=Dm(e))[1],this.poolSize[0],this.padding,this.strides[0]);return[e[0],t,e[2]]}call(e,t){return ii((()=>{this.invokeCallHook(e,t),e=Vf(Fm(e),2);const n=this.poolingFunction(Fm(e),[this.poolSize[0],1],[this.strides[0],1],this.padding,"channelsLast");return qu(n,[2])}))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides},t=super.getConfig();return Object.assign(e,t),e}}class lx extends ox{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return Sf(r),Tf(s),ax(e,t,n,s,r,"max")}}lx.className="MaxPooling1D",Xa(lx);class ux extends ox{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return Sf(r),Tf(s),ax(e,t,n,s,r,"avg")}}ux.className="AveragePooling1D",Xa(ux);class cx extends Gm{constructor(e){if(null==e.poolSize&&(e.poolSize=[2,2]),super(e),this.poolSize=Array.isArray(e.poolSize)?e.poolSize:[e.poolSize,e.poolSize],null==e.strides)this.strides=this.poolSize;else if(Array.isArray(e.strides)){if(2!==e.strides.length)throw new Wd(`If the strides property of a 2D pooling layer is an Array, it is expected to have a length of 2, but received length ${e.strides.length}.`);this.strides=e.strides}else this.strides=[e.strides,e.strides];of(this.poolSize,"poolSize"),of(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,Sf(this.dataFormat),Tf(this.padding),this.inputSpec=[new Bm({ndim:4})]}computeOutputShape(e){e=Dm(e);let t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2];return t=Jy(t,this.poolSize[0],this.padding,this.strides[0]),n=Jy(n,this.poolSize[1],this.padding,this.strides[1]),"channelsFirst"===this.dataFormat?[e[0],e[1],t,n]:[e[0],t,n,e[3]]}call(e,t){return ii((()=>(this.invokeCallHook(e,t),this.poolingFunction(Fm(e),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class hx extends cx{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return Sf(r),Tf(s),ax(e,t,n,s,r,"max")}}hx.className="MaxPooling2D",Xa(hx);class px extends cx{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return Sf(r),Tf(s),ax(e,t,n,s,r,"avg")}}px.className="AveragePooling2D",Xa(px);class dx extends Gm{constructor(e){if(null==e.poolSize&&(e.poolSize=[2,2,2]),super(e),this.poolSize=Array.isArray(e.poolSize)?e.poolSize:[e.poolSize,e.poolSize,e.poolSize],null==e.strides)this.strides=this.poolSize;else if(Array.isArray(e.strides)){if(3!==e.strides.length)throw new Wd(`If the strides property of a 3D pooling layer is an Array, it is expected to have a length of 3, but received length ${e.strides.length}.`);this.strides=e.strides}else this.strides=[e.strides,e.strides,e.strides];of(this.poolSize,"poolSize"),of(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,Sf(this.dataFormat),Tf(this.padding),this.inputSpec=[new Bm({ndim:5})]}computeOutputShape(e){e=Dm(e);let t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2],s="channelsFirst"===this.dataFormat?e[4]:e[3];return t=Jy(t,this.poolSize[0],this.padding,this.strides[0]),n=Jy(n,this.poolSize[1],this.padding,this.strides[1]),s=Jy(s,this.poolSize[2],this.padding,this.strides[2]),"channelsFirst"===this.dataFormat?[e[0],e[1],t,n,s]:[e[0],t,n,s,e[4]]}call(e,t){return ii((()=>(this.invokeCallHook(e,t),this.poolingFunction(Fm(e),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class fx extends dx{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return Sf(r),Tf(s),ix(e,t,n,s,r,"max")}}fx.className="MaxPooling3D",Xa(fx);class mx extends dx{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return Sf(r),Tf(s),ix(e,t,n,s,r,"avg")}}mx.className="AveragePooling3D",Xa(mx);class gx extends Gm{constructor(e){super(e),this.inputSpec=[new Bm({ndim:3})]}computeOutputShape(e){return[e[0],e[2]]}call(e,t){throw new Vd}}class yx extends gx{constructor(e){super(e||{})}call(e,t){return ii((()=>{const t=Fm(e);return Al(t,1)}))}}yx.className="GlobalAveragePooling1D",Xa(yx);class bx extends gx{constructor(e){super(e||{})}call(e,t){return ii((()=>{const t=Fm(e);return ul(t,1)}))}}bx.className="GlobalMaxPooling1D",Xa(bx);class xx extends Gm{constructor(e){super(e),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,Sf(this.dataFormat),this.inputSpec=[new Bm({ndim:4})]}computeOutputShape(e){return e=e,"channelsLast"===this.dataFormat?[e[0],e[3]]:[e[0],e[1]]}call(e,t){throw new Vd}getConfig(){const e={dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class wx extends xx{call(e,t){return ii((()=>{const t=Fm(e);return"channelsLast"===this.dataFormat?Al(t,[1,2]):Al(t,[2,3])}))}}wx.className="GlobalAveragePooling2D",Xa(wx);class kx extends xx{call(e,t){return ii((()=>{const t=Fm(e);return"channelsLast"===this.dataFormat?ul(t,[1,2]):ul(t,[2,3])}))}}kx.className="GlobalMaxPooling2D",Xa(kx);class vx extends Gm{constructor(e){super(e),this.layer=e.layer}build(e){this.built=!0}get trainable(){return null!=this.layer&&this.layer.trainable}set trainable(e){null!=this.layer&&(this.layer.trainable=e)}get trainableWeights(){return this.layer.trainableWeights}get nonTrainableWeights(){return this.layer.nonTrainableWeights}get updates(){return this.layer._updates}get losses(){return this.layer.losses}getWeights(){return this.layer.getWeights()}setWeights(e){this.layer.setWeights(e)}getConfig(){const e={layer:{className:this.layer.getClassName(),config:this.layer.getConfig()}},t=super.getConfig();return Object.assign(e,t),e}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.layer&&this.layer.setFastWeightInitDuringBuild(e)}static fromConfig(e,t,n={}){const s=ag(t.layer,n);delete t.layer;const r={layer:s};return Object.assign(r,t),new e(r)}}class Nx extends vx{constructor(e){super(e),this.supportsMasking=!0}build(e){if((e=Dm(e)).length<3)throw new Wd(`TimeDistributed layer expects an input shape >= 3D, but received input shape ${JSON.stringify(e)}`);this.inputSpec=[{shape:e}];const t=[e[0]].concat(e.slice(2));this.layer.built||(this.layer.build(t),this.layer.built=!0),super.build(e)}computeOutputShape(e){const t=[(e=Dm(e))[0]].concat(e.slice(2)),n=this.layer.computeOutputShape(t),s=e[1];return[n[0],s].concat(n.slice(1))}call(e,t){return ii((()=>yb(((e,n)=>[Fm(this.layer.call(e,t)),[]]),e=Fm(e),[],!1,null,null,!1,!0)[1]))}}Nx.className="TimeDistributed",Xa(Nx);class Ix extends vx{constructor(e){super(e);const t=e.layer.getConfig(),n={};n.className=e.layer.getClassName(),n.config=t,this.forwardLayer=ag(n),t.goBackwards=!0!==t.goBackwards;const s={};var r;if(s.className=e.layer.getClassName(),s.config=t,this.backwardLayer=ag(s),this.forwardLayer.name="forward_"+this.forwardLayer.name,this.backwardLayer.name="backward_"+this.backwardLayer.name,this.mergeMode=void 0===e.mergeMode?"concat":e.mergeMode,r=this.mergeMode,rf($f,"BidirectionalMergeMode",r),e.weights)throw new Vd("weights support is not implemented for Bidirectional layer yet.");this._stateful=e.layer.stateful,this.returnSequences=e.layer.returnSequences,this.returnState=e.layer.returnState,this.supportsMasking=!0,this._trainable=!0,this.inputSpec=e.layer.inputSpec,this.numConstants=null}get trainable(){return this._trainable}set trainable(e){this._trainable=e,null!=this.forwardLayer&&(this.forwardLayer.trainable=e),null!=this.backwardLayer&&(this.backwardLayer.trainable=e)}getWeights(){return this.forwardLayer.getWeights().concat(this.backwardLayer.getWeights())}setWeights(e){const t=e.length,n=Math.floor(t/2);this.forwardLayer.setWeights(e.slice(0,n)),this.backwardLayer.setWeights(e.slice(n))}computeOutputShape(e){let t,n,s,r=this.forwardLayer.computeOutputShape(e);return Array.isArray(r)&&Array.isArray(r[0])||(r=[r]),r=r,this.returnState?(s=r.slice(1),t=r[0]):t=r[0],t=t,"concat"===this.mergeMode?(t[t.length-1]*=2,n=[t]):n=null==this.mergeMode?[t,t.slice()]:[t],this.returnState?null==this.mergeMode?n.concat(s).concat(s.slice()):[t].concat(s).concat(s.slice()):qd(n)}apply(e,t){let n=null==t?null:t.initialState,s=null==t?null:t.constants;null==t&&(t={});const r=gb(e,n,s,this.numConstants);if(e=r.inputs,n=r.initialState,s=r.constants,Array.isArray(e)&&(n=e.slice(1),e=e[0]),(null==n||0===n.length)&&null==s)return super.apply(e,t);const a=[],i=[];if(null!=n){const e=n.length;if(e%2>0)throw new Wd("When passing `initialState` to a Bidrectional RNN, the state should be an Array containing the states of the underlying RNNs.");t.initialState=n,a.push(...n);const s=n.map((e=>new Bm({shape:e.shape})));this.forwardLayer.stateSpec=s.slice(0,e/2),this.backwardLayer.stateSpec=s.slice(e/2),i.push(...s)}if(null!=s)throw new Vd("Support for constants in Bidirectional layers is not implemented yet.");const o=a[0]instanceof Pm;for(const e of a)if(e instanceof Pm!==o)throw new Wd("The initial state of a Bidirectional layer cannot be specified as a mix of symbolic and non-symbolic tensors");if(o){const n=[e].concat(a),s=this.inputSpec.concat(i),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,t);return this.inputSpec=r,o}return super.apply(e,t)}call(e,t){return ii((()=>{const n=t.initialState;let s,r,a,i;if(null==n)s=this.forwardLayer.call(e,t),r=this.backwardLayer.call(e,t);else{const a=n.slice(0,n.length/2),i=n.slice(n.length/2);s=this.forwardLayer.call(e,Object.assign(t,{initialState:a})),r=this.backwardLayer.call(e,Object.assign(t,{initialState:i}))}return this.returnState&&(Array.isArray(s)&&(a=s.slice(1).concat(r.slice(1))),s=s[0],r=r[0]),this.returnSequences&&(r=ku(r,1)),"concat"===this.mergeMode?i=jf([s,r]):"sum"===this.mergeMode?i=pi(s,r):"ave"===this.mergeMode?i=mi(.5,pi(s,r)):"mul"===this.mergeMode?i=mi(s,r):null==this.mergeMode&&(i=[s,r]),this.returnState?null==this.mergeMode?i.concat(a):[i].concat(a):i}))}resetStates(e){this.forwardLayer.resetStates(),this.backwardLayer.resetStates()}build(e){Rf(this.forwardLayer.name,(()=>{this.forwardLayer.build(e)})),Rf(this.backwardLayer.name,(()=>{this.backwardLayer.build(e)})),this.built=!0}computeMask(e,t){let n;if(Array.isArray(t)&&(t=t[0]),n=this.returnSequences?null==this.mergeMode?[t,t]:t:null==this.mergeMode?[null,null]:null,this.returnState){const e=this.forwardLayer.states.map((e=>null));return Array.isArray(n)?n.concat(e).concat(e):[n].concat(e).concat(e)}return n}get trainableWeights(){return this.forwardLayer.trainableWeights.concat(this.backwardLayer.trainableWeights)}get nonTrainableWeights(){return this.forwardLayer.nonTrainableWeights.concat(this.backwardLayer.nonTrainableWeights)}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.forwardLayer&&this.forwardLayer.setFastWeightInitDuringBuild(e),null!=this.backwardLayer&&this.backwardLayer.setFastWeightInitDuringBuild(e)}getConfig(){const e={mergeMode:this.mergeMode},t=super.getConfig();return Object.assign(e,t),e}static fromConfig(e,t){const n=ag(t.layer);if(delete t.layer,null!=t.numConstants)throw new Vd("Deserialization of a Bidirectional layer with numConstants present is not supported yet.");const s=t;return s.layer=n,new e(s)}}function $x(e){return new ux(e)}function Cx(e){return new px(e)}function Sx(e){return new mx(e)}function Tx(e){return new bx(e)}function Ex(e){return new kx(e)}function Ax(e){return new lx(e)}function Rx(e){return new hx(e)}Ix.className="Bidirectional",Xa(Ix);const Fx=Tx,Dx=Ex,_x=Ax,Ox=Rx;var Mx=Object.freeze({__proto__:null,inputLayer:function(e){return new jm(e)},elu:function(e){return new qy(e)},reLU:function(e){return new Gy(e)},leakyReLU:function(e){return new Hy(e)},prelu:function(e){return new jy(e)},softmax:function(e){return new Xy(e)},thresholdedReLU:function(e){return new Ky(e)},conv1d:function(e){return new pb(e)},conv2d:function(e){return new ib(e)},conv2dTranspose:function(e){return new lb(e)},conv3d:function(e){return new ob(e)},conv3dTranspose:function(e){return new ub(e)},separableConv2d:function(e){return new hb(e)},cropping2D:function(e){return new db(e)},upSampling2d:function(e){return new fb(e)},depthwiseConv2d:function(e){return new mb(e)},activation:function(e){return new Mb(e)},dense:function(e){return new _b(e)},dropout:function(e){return new Fb(e)},spatialDropout1d:function(e){return new Db(e)},flatten:function(e){return new Ob(e)},repeatVector:function(e){return new Lb(e)},reshape:function(e){return new zb(e)},permute:function(e){return new Bb(e)},embedding:function(e){return new Wb(e)},add:function(e){return new Ub(e)},average:function(e){return new Hb(e)},concatenate:function(e){return new Kb(e)},maximum:function(e){return new jb(e)},minimum:function(e){return new qb(e)},multiply:function(e){return new Gb(e)},dot:function(e){return new Yb(e)},batchNormalization:function(e){return new nx(e)},layerNormalization:function(e){return new sx(e)},zeroPadding2d:function(e){return new rx(e)},averagePooling1d:$x,avgPool1d:function(e){return $x(e)},avgPooling1d:function(e){return $x(e)},averagePooling2d:Cx,avgPool2d:function(e){return Cx(e)},avgPooling2d:function(e){return Cx(e)},averagePooling3d:Sx,avgPool3d:function(e){return Sx(e)},avgPooling3d:function(e){return Sx(e)},globalAveragePooling1d:function(e){return new yx(e)},globalAveragePooling2d:function(e){return new wx(e)},globalMaxPooling1d:Tx,globalMaxPooling2d:Ex,maxPooling1d:Ax,maxPooling2d:Rx,maxPooling3d:function(e){return new fx(e)},gru:function(e){return new Nb(e)},gruCell:function(e){return new vb(e)},lstm:function(e){return new $b(e)},lstmCell:function(e){return new Ib(e)},simpleRNN:function(e){return new kb(e)},simpleRNNCell:function(e){return new wb(e)},convLstm2d:function(e){return new Rb(e)},convLstm2dCell:function(e){return new Ab(e)},rnn:function(e){return new bb(e)},stackedRNNCells:function(e){return new Cb(e)},bidirectional:function(e){return new Ix(e)},timeDistributed:function(e){return new Nx(e)},globalMaxPool1d:Fx,globalMaxPool2d:Dx,maxPool1d:_x,maxPool2d:Ox,Layer:Gm,RNN:bb,RNNCell:xb,input:by,gaussianNoise:function(e){return new Jb(e)},gaussianDropout:function(e){return new Zb(e)},alphaDropout:function(e){return new Qb(e)},masking:function(e){return new Pb(e)}});var Lx=Object.freeze({__proto__:null,binaryAccuracy:function(e,t){return bg(e,t)},binaryCrossentropy:function(e,t){return Ng(e,t)},sparseCategoricalAccuracy:function(e,t){return Ig(e,t)},categoricalAccuracy:function(e,t){return xg(e,t)},categoricalCrossentropy:function(e,t){return $g(e,t)},precision:function(e,t){return kg(e,t)},recall:function(e,t){return vg(e,t)},cosineProximity:function(e,t){return mg(e,t)},meanAbsoluteError:function(e,t){return lg(e,t)},meanAbsolutePercentageError:function(e,t){return ug(e,t)},MAPE:function(e,t){return ug(e,t)},mape:function(e,t){return ug(e,t)},meanSquaredError:function(e,t){return og(e,t)},MSE:function(e,t){return og(e,t)},mse:function(e,t){return og(e,t)}}),zx=Object.freeze({__proto__:null,modelFromJSON:async function(e,t){"modelTopology"in e||(e={modelTopology:e});let n=(e=e).modelTopology;null!=n.model_config&&(n=n.model_config);const s=ag(zg(n),t);if(null!=e.weightsManifest){const t=await sa(e.weightsManifest,e.pathPrefix,s.weights.map((e=>e.originalName))),n={};for(const e of s.weights)n[e.originalName]=t[e.originalName];s.loadWeights(n),oi(t)}return s}});var Bx=Object.freeze({__proto__:null,l1l2:function(e){return new By(e)},l1:function(e){return Ly(t=e),new By({l1:null!=t?t.l1:null,l2:0});var t},l2:function(e){return Ly(t=e),new By({l2:null!=t?t.l2:null,l1:0});var t}});class Px extends Jm{constructor(){super(...arguments),this.model=null}setModel(e){if(!(e instanceof fy))throw new Error("model must be a LayersModel, not some other Container");this.model=e}}function Wx(e,t){return e<t}function Vx(e,t){return e>t}class Ux extends Px{constructor(e){if(super(),null==e&&(e={}),e.restoreBestWeights)throw new Vd("restoreBestWeights = True is not implemented in EarlyStopping yet.");this.monitor=e.monitor||"val_loss",this.minDelta=Math.abs(e.minDelta||0),this.patience=e.patience||0,this.verbose=e.verbose||0,this.mode=e.mode||"auto",this.baseline=e.baseline,-1===["auto","min","max"].indexOf(this.mode)&&(console.warn(`EarlyStopping mode '${this.mode}' is invalid. Falling back to mode 'auto'.`),this.mode="auto"),"min"===this.mode?this.monitorFunc=Wx:"max"===this.mode||-1!==this.monitor.indexOf("acc")?this.monitorFunc=Vx:this.monitorFunc=Wx,this.monitorFunc===Wx&&(this.minDelta*=-1)}async onTrainBegin(e){this.wait=0,this.stoppedEpoch=0,null!=this.baseline?this.best=this.baseline:this.best=this.monitorFunc===Wx?1/0:-1/0}async onEpochEnd(e,t){await Km(t);const n=this.getMonitorValue(t);null!=n&&(this.monitorFunc(n-this.minDelta,this.best)?(this.best=n,this.wait=0):(this.wait++,this.wait>=this.patience&&(this.stoppedEpoch=e,this.model.stopTraining=!0)))}async onTrainEnd(e){this.stoppedEpoch>0&&this.verbose&&console.log(`Epoch ${this.stoppedEpoch}: early stopping.`)}getMonitorValue(e){null==e&&(e={});const t=e[this.monitor];return null==t&&console.warn(`Metric for EarlyStopping ${this.monitor} is not available. Available metrics are: ${Object.keys(e)}`),t}}const Gx={earlyStopping:function(e){return new Ux(e)}};var Hx,jx;!function(e){e[e.DT_INVALID=0]="DT_INVALID",e[e.DT_FLOAT=1]="DT_FLOAT",e[e.DT_DOUBLE=2]="DT_DOUBLE",e[e.DT_INT32=3]="DT_INT32",e[e.DT_UINT8=4]="DT_UINT8",e[e.DT_INT16=5]="DT_INT16",e[e.DT_INT8=6]="DT_INT8",e[e.DT_STRING=7]="DT_STRING",e[e.DT_COMPLEX64=8]="DT_COMPLEX64",e[e.DT_INT64=9]="DT_INT64",e[e.DT_BOOL=10]="DT_BOOL",e[e.DT_QINT8=11]="DT_QINT8",e[e.DT_QUINT8=12]="DT_QUINT8",e[e.DT_QINT32=13]="DT_QINT32",e[e.DT_BFLOAT16=14]="DT_BFLOAT16",e[e.DT_FLOAT_REF=101]="DT_FLOAT_REF",e[e.DT_DOUBLE_REF=102]="DT_DOUBLE_REF",e[e.DT_INT32_REF=103]="DT_INT32_REF",e[e.DT_UINT8_REF=104]="DT_UINT8_REF",e[e.DT_INT16_REF=105]="DT_INT16_REF",e[e.DT_INT8_REF=106]="DT_INT8_REF",e[e.DT_STRING_REF=107]="DT_STRING_REF",e[e.DT_COMPLEX64_REF=108]="DT_COMPLEX64_REF",e[e.DT_INT64_REF=109]="DT_INT64_REF",e[e.DT_BOOL_REF=110]="DT_BOOL_REF",e[e.DT_QINT8_REF=111]="DT_QINT8_REF",e[e.DT_QUINT8_REF=112]="DT_QUINT8_REF",e[e.DT_QINT32_REF=113]="DT_QINT32_REF",e[e.DT_BFLOAT16_REF=114]="DT_BFLOAT16_REF"}(Hx||(Hx={})),function(e){let t;!function(e){e[e.LEGACY=0]="LEGACY",e[e.V1=1]="V1",e[e.V2=2]="V2"}(t=e.CheckpointFormatVersion||(e.CheckpointFormatVersion={}))}(jx||(jx={}));const qx={};function Kx(e){return qx[e]}function Xx(e,t,n,s,r){const a=t.inputParams[e];if(a&&void 0!==a.inputIndexStart){const e=a.inputIndexStart,i=0===a.inputIndexEnd?void 0:void 0===a.inputIndexEnd?e+1:a.inputIndexEnd;if("tensor"===a.type)return Yx(t.inputNames[a.inputIndexStart],n,s,r);if("tensors"===a.type){return t.inputNames.slice(e,i).map((e=>Yx(e,n,s,r)))}const o=Yx(t.inputNames.slice(e)[0],n,s,r),l=o.dataSync();return"number"===a.type?l[0]:L(o.shape,l)}const i=t.attrParams[e];return i&&i.value}function Yx(e,t,n,s){const[r,a]=Qx(e);if(null!=s){const e=s.getHashTableHandleByName(r);if(null!=e)return e}const i=n.currentContextIds.find((e=>!!t[Zx(r,e)]));return void 0!==i?t[Zx(r,i)][a]:void 0}function Jx(e,t){const[n,s]=Qx(e);return[Zx(n,t&&t.currentContextId),s]}function Zx(e,t){return t?`${e}-${t}`:e}function Qx(e){const t=e.split(":");if(1===t.length)return[e,0];return[t[0],Number(t[t.length-1])]}function ew(e,t,n){let s=Xx("pad",e,t,n);if("explicit"===s){s=Xx("explicitPaddings",e,t,n);const r=[[0,0],[0,0],[0,0],[0,0]];for(let e=0;e<4;e++)r[e][0]=s[2*e],r[e][1]=s[2*e+1];return r}return s}function tw(e){return e.kept?e:Yr(e)}var nw=Object.freeze({__proto__:null,json:[{tfOpName:"Add",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddV2",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddN",category:"arithmetic",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"BiasAdd",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"Sub",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"RealDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Div",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"DivNoNan",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mul",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Maximum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Minimum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Pow",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SquaredDifference",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorMod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var sw=Object.freeze({__proto__:null,json:[{tfOpName:"Abs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan2",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ceil",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ClipByValue",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"clipValueMin",type:"number"},{start:2,name:"clipValueMax",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Complex",category:"basic_math",inputs:[{start:0,name:"real",type:"tensor"},{start:1,name:"imag",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ComplexAbs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Elu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Exp",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Floor",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Imag",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Neg",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Real",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Prelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"alpha",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu6",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Selu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sigmoid",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Rsqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Square",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sign",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Round",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Expm1",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log1p",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Reciprocal",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Softplus",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Erf",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Prod",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axes",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LeakyRelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"alpha",name:"alpha",type:"number",defaultValue:.2},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"IsNan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var rw=Object.freeze({__proto__:null,json:[{tfOpName:"EmptyTensorList",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"maxNumElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"LoopCond",category:"control",inputs:[{start:0,name:"pred",type:"tensor"}]},{tfOpName:"Switch",category:"control",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"pred",type:"tensor"}]},{tfOpName:"Merge",category:"control",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"Enter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"frame_name",name:"frameName",type:"string"},{tfName:"is_constant",name:"isConstant",type:"bool"}]},{tfOpName:"Exit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NextIteration",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayV3",category:"control",inputs:[{start:0,name:"size",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"dynamic_size",name:"dynamicSize",type:"bool"},{tfName:"clear_after_read",name:"clearAfterRead",type:"bool"},{tfName:"identical_element_shapes",name:"identicalElementShapes",type:"bool"},{tfName:"tensor_array_name",name:"name",type:"string"}]},{tfOpName:"TensorArrayWriteV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayReadV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayGatherV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"}]},{tfOpName:"TensorArrayScatterV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArrayConcatV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape_except0",name:"elementShapeExcept0",type:"shape",notSupported:!0}]},{tfOpName:"TensorArraySplitV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"tensor",type:"tensor"},{start:2,name:"lengths",type:"number[]"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArraySizeV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}]},{tfOpName:"TensorArrayCloseV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"}]},{tfOpName:"StatelessIf",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"If",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"StatelessWhile",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"While",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"TensorListScatter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListScatterV2",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"},{start:3,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGather",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListSetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListReserve",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListFromTensor",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListStack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"},{tfName:"num_elements",name:"numElements",type:"dtype"}]},{tfOpName:"TensorListSplit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"},{start:2,name:"lengths",type:"number[]"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListConcat",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}],attrs:[{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPopBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPushBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]}]});var aw=Object.freeze({__proto__:null,json:[{tfOpName:"AvgPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[],notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPoolWithArgmax",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"include_batch_in_index",name:"includeBatchInIndex",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AvgPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Conv1D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"stride",name:"stride",type:"number"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NWC"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"dilation",name:"dilation",type:"number",defaultValue:1}]},{tfOpName:"Conv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"useCudnnOnGpu",name:"useCudnnOnGpu",type:"bool"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"_FusedConv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"use_cudnn_on_gpu",name:"useCudnnOnGpu",type:"bool",defaultValue:!0},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"leakyrelu_alpha",name:"leakyreluAlpha",type:"number"}]},{tfOpName:"Conv2DBackpropInput",category:"convolution",inputs:[{start:2,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:0,name:"outputShape",type:"number[]"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]",notSupported:!0}]},{tfOpName:"DepthwiseConv2d",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"DepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"FusedDepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]}]},{tfOpName:"Conv3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"Dilation2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"rates",name:"dilations",type:"number[]"},{tfName:"padding",name:"pad",type:"string"}]}]});var iw=Object.freeze({__proto__:null,json:[{tfOpName:"Fill",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"},{start:1,name:"value",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"LinSpace",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"num",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"OneHot",category:"creation",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"depth",type:"number"},{start:2,name:"onValue",type:"number",defaultValue:1},{start:3,name:"offValue",type:"number",defaultValue:0}],attrs:[{tfName:"axis",name:"axis",type:"number",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ones",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"OnesLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"RandomUniform",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"minval",name:"minval",type:"number",defaultValue:0},{tfName:"maxval",name:"maxval",type:"number",defaultValue:1},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Range",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"step",type:"number",defaultValue:0}],attrs:[{tfName:"Tidx",name:"dtype",type:"dtype"}]},{tfOpName:"TruncatedNormal",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"means",name:"mean",type:"number",defaultValue:0},{tfName:"stddev",name:"stdDev",type:"number",defaultValue:1},{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Zeros",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"ZerosLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"Multinomial",category:"creation",inputs:[{start:0,name:"logits",type:"tensor"},{start:1,name:"numSamples",type:"number"}],attrs:[{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number"},{tfName:"T",name:"dtype",type:"dtype"},{tfName:"output_dtype",name:"output_dtype",type:"dtype"}]}]});var ow=Object.freeze({__proto__:null,json:[{tfOpName:"NonMaxSuppressionV2",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV3",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV4",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"T_threshold",name:"threshold",type:"dtype",notSupported:!0},{tfName:"pad_to_max_output_size",name:"padToMaxOutputSize",type:"bool"}]},{tfOpName:"NonMaxSuppressionV5",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"},{start:5,name:"softNmsSigma",type:"number"}]},{tfOpName:"Where",category:"dynamic",inputs:[{start:0,name:"condition",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ListDiff",category:"dynamic",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var lw=Object.freeze({__proto__:null,json:[{tfOpName:"TopKV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"k",type:"number"}],attrs:[{tfName:"sorted",name:"sorted",type:"bool"}]},{tfOpName:"Unique",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"UniqueV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]}]});var uw=Object.freeze({__proto__:null,json:[{tfOpName:"PlaceholderWithDefault",category:"graph",inputs:[{start:0,name:"default",type:"tensor"}],attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Placeholder",category:"graph",attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Const",category:"graph"},{tfOpName:"Identity",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IdentityN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Snapshot",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Rank",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Size",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Shape",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"ShapeN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Print",category:"graph",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"data",type:"tensors"}],attrs:[{tfName:"message",name:"message",type:"string"},{tfName:"first_n",name:"firstN",type:"number",notSupported:!0},{tfName:"summarize",name:"summarize",type:"number",defaultValue:3}]},{tfOpName:"NoOp",category:"graph",inputs:[]},{tfOpName:"StopGradient",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"FakeQuantWithMinMaxVars",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"min",name:"min",type:"number"},{tfName:"max",name:"max",type:"number"}]}]});var cw=Object.freeze({__proto__:null,json:[{tfOpName:"HashTable",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"HashTableV2",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"LookupTableImport",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableImportV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFind",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFindV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableSize",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"}]},{tfOpName:"LookupTableSizeV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"}]}]});var hw=Object.freeze({__proto__:null,json:[{tfOpName:"ResizeBilinear",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ResizeNearestNeighbor",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"CropAndResize",category:"image",inputs:[{start:0,name:"image",type:"tensor"},{start:1,name:"boxes",type:"tensor"},{start:2,name:"boxInd",type:"tensor"},{start:3,name:"cropSize",type:"number[]"}],attrs:[{tfName:"method",name:"method",type:"string"},{tfName:"extrapolation_value",name:"extrapolationValue",type:"number"}]}]});var pw=Object.freeze({__proto__:null,json:[{tfOpName:"Equal",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NotEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Greater",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"GreaterEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Less",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LessEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalAnd",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalNot",category:"logical",inputs:[{start:0,name:"a",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalOr",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Select",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SelectV2",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var dw=Object.freeze({__proto__:null,json:[{tfOpName:"_FusedMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMulV2",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Transpose",category:"matrices",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"perm",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Einsum",category:"matrices",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"equation",name:"equation",type:"string"},{tfName:"N",name:"n",type:"number",defaultValue:2},{tfName:"T",name:"dtype",type:"dtype"}]}]});var fw=Object.freeze({__proto__:null,json:[{tfOpName:"FusedBatchNorm",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV2",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV3",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"LRN",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"depth_radius",name:"radius",type:"number",defaultValue:5},{tfName:"bias",name:"bias",type:"number",defaultValue:1},{tfName:"alpha",name:"alpha",type:"number",defaultValue:1},{tfName:"beta",name:"beta",type:"number",defaultValue:.5}]},{tfOpName:"Softmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"LogSoftmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"SparseToDense",category:"normalization",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!0,notSupported:!0}]}]});var mw=Object.freeze({__proto__:null,json:[{tfOpName:"Bincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}]},{tfOpName:"DenseBincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}],attrs:[{tfName:"binary_output",name:"binaryOutput",type:"bool"}]},{tfOpName:"Max",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Mean",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Min",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Sum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"All",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Any",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"ArgMax",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"ArgMin",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"Prod",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Cumsum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}],attrs:[{tfName:"exclusive",name:"exclusive",type:"bool"},{tfName:"reverse",name:"reverse",type:"bool"}]}]});var gw=Object.freeze({__proto__:null,json:[{tfOpName:"ConcatV2",category:"slice_join",inputs:[{start:0,end:-1,name:"tensors",type:"tensors"},{start:-1,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"Concat",category:"slice_join",inputs:[{start:1,end:0,name:"tensors",type:"tensors"},{start:0,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"GatherV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"axis",type:"number",defaultValue:0}],attrs:[{tfName:"batch_dims",name:"batchDims",type:"number",defaultValue:0}]},{tfOpName:"Gather",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",notSupported:!0}]},{tfOpName:"Reverse",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"dims",type:"bool[]"}]},{tfOpName:"ReverseV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}]},{tfOpName:"Slice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"size",type:"number[]"}]},{tfOpName:"StridedSlice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"end",type:"number[]"},{start:3,name:"strides",type:"number[]"}],attrs:[{tfName:"begin_mask",name:"beginMask",type:"number",defaultValue:0},{tfName:"end_mask",name:"endMask",type:"number",defaultValue:0},{tfName:"new_axis_mask",name:"newAxisMask",type:"number",defaultValue:0},{tfName:"ellipsis_mask",name:"ellipsisMask",type:"number",defaultValue:0},{tfName:"shrink_axis_mask",name:"shrinkAxisMask",type:"number",defaultValue:0}]},{tfOpName:"Pack",category:"slice_join",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0}]},{tfOpName:"Unpack",category:"slice_join",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0},{tfName:"num",name:"num",type:"number",defaultValue:0,notSupported:!0}]},{tfOpName:"Tile",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"reps",type:"number[]"}]},{tfOpName:"Split",category:"slice_join",inputs:[{start:0,name:"axis",type:"number",defaultValue:0},{start:1,name:"x",type:"tensor"}],attrs:[{tfName:"num_split",name:"numOrSizeSplits",type:"number",defaultValue:1}]},{tfOpName:"SplitV",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"numOrSizeSplits",type:"number[]"},{start:2,name:"axis",type:"number",defaultValue:0}]},{tfOpName:"ScatterNd",category:"slice_join",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"values",type:"tensor"},{start:2,name:"shape",type:"number[]"}]},{tfOpName:"GatherNd",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}]},{tfOpName:"SparseToDense",category:"slice_join",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!1,notSupported:!0}]}]});var yw=Object.freeze({__proto__:null,json:[{tfOpName:"FFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"RFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]},{tfOpName:"IRFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]}]});var bw=Object.freeze({__proto__:null,json:[{tfOpName:"Cast",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"SrcT",name:"sdtype",type:"dtype",notSupported:!0},{tfName:"DstT",name:"dtype",type:"dtype"}]},{tfOpName:"ExpandDims",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"MirrorPad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"mode",name:"mode",type:"string"}]},{tfOpName:"Pad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"constant_value",name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"PadV2",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"},{start:2,name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"Reshape",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}]},{tfOpName:"Squeeze",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"axis",tfDeprecatedName:"squeeze_dims",name:"axis",type:"number[]"}]},{tfOpName:"SpaceToBatchND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"paddings",type:"number[]"}]},{tfOpName:"BatchToSpaceND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"crops",type:"number[]"}]},{tfOpName:"DepthToSpace",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"block_size",name:"blockSize",type:"number"},{tfName:"data_format",name:"dataFormat",type:"string"}]},{tfOpName:"BroadcastTo",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}],attrs:[]}]});class xw{static get Instance(){return this._instance||(this._instance=new this)}constructor(){const e=[].concat(...[nw,sw,rw,aw,iw,ow,lw,pw,hw,uw,dw,fw,mw,gw,yw,bw,cw].map((e=>e.json)));this.opMappers=e.reduce(((e,t)=>(e[t.tfOpName]=t,e)),{})}transformGraph(e,t={}){const n=e.node,s=[],r=[],a=[],i=n.reduce(((e,t)=>(e[t.name]=this.mapNode(t),t.op.startsWith("Placeholder")?s.push(e[t.name]):"Const"===t.op?r.push(e[t.name]):null!=t.input&&0!==t.input.length||a.push(e[t.name]),e)),{});let o=[];const l=[];let u={},c={};null!=t&&(u=this.mapSignatureEntries(t.inputs),c=this.mapSignatureEntries(t.outputs));const h=Object.keys(i);h.forEach((e=>{const t=i[e];t.inputNames.forEach((e=>{const[n]=Jx(e);t.inputs.push(i[n]),i[n].children.push(t)}))})),0===Object.keys(c).length?h.forEach((e=>{const t=i[e];0===t.children.length&&l.push(t)})):Object.keys(c).forEach((e=>{const[t]=Jx(e),n=i[t];null!=n&&(n.signatureKey=c[e],l.push(n))})),Object.keys(u).length>0?Object.keys(u).forEach((e=>{const[t]=Jx(e),n=i[t];n&&(n.signatureKey=u[e],o.push(n))})):o=s;let p={};null!=e.library&&null!=e.library.function&&(p=e.library.function.reduce(((e,t)=>(e[t.signature.name]=this.mapFunction(t),e)),{}));const d={nodes:i,inputs:o,outputs:l,weights:r,placeholders:s,signature:t,functions:p};return a.length>0&&(d.initNodes=a),d}mapSignatureEntries(e){return Object.keys(e||{}).reduce(((t,n)=>(t[e[n].name]=n,t)),{})}mapNode(e){const t=Kx(e.op)||this.opMappers[e.op]||{};null==e.attr&&(e.attr={});const n={name:e.name,op:e.op,category:t.category,inputNames:(e.input||[]).map((e=>e.startsWith("^")?e.substr(1):e)),inputs:[],children:[],inputParams:{},attrParams:{},rawAttrs:e.attr};return null!=t.inputs&&(n.inputParams=t.inputs.reduce(((e,t)=>(e[t.name]={type:t.type,inputIndexStart:t.start,inputIndexEnd:t.end},e)),{})),null!=t.attrs&&(n.attrParams=t.attrs.reduce(((t,n)=>{const s=n.type;let r;switch(n.type){case"string":r=kw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=kw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"string[]":r=Rw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Rw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number":r=Nw(e.attr,n.tfName,n.defaultValue||0),void 0===r&&n.tfDeprecatedName&&(r=Nw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number[]":r=Aw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Aw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool":r=vw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=vw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool[]":r=Dw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Dw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape":r=Ew(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Ew(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape[]":r=Fw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Fw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype":r=Cw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Cw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype[]":r=Sw(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=Sw(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"func":r=$w(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=$w(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"tensor":case"tensors":break;default:throw new Error(`Unsupported param type: ${n.type} for op: ${e.op}`)}return t[n.name]={value:r,type:s},t}),{})),n}mapFunction(e){const t=e.nodeDef,n=[];let s={};null!=t&&(s=t.reduce(((e,t)=>(e[t.name]=this.mapNode(t),"Const"===t.op&&n.push(e[t.name]),e)),{}));const r=[],a=[];e.signature.inputArg.forEach((e=>{const[t]=Jx(e.name),n={name:t,op:"Placeholder",inputs:[],inputNames:[],category:"graph",inputParams:{},attrParams:{dtype:{value:Iw(e.type),type:"dtype"}},children:[]};n.signatureKey=e.name,r.push(n),s[t]=n}));Object.keys(s).forEach((e=>{const t=s[e];t.inputNames.forEach((e=>{const[n]=Jx(e);t.inputs.push(s[n]),s[n].children.push(t)}))}));const i=e.ret;e.signature.outputArg.forEach((e=>{const[t,n]=Jx(i[e.name]),r=s[t];null!=r&&(r.defaultOutput=n,a.push(r))}));const o=this.mapArgsToSignature(e);return{nodes:s,inputs:r,outputs:a,weights:n,placeholders:[],signature:o}}mapArgsToSignature(e){return{methodName:e.signature.name,inputs:e.signature.inputArg.reduce(((e,t)=>(e[t.name]=this.mapArgToTensorInfo(t),e)),{}),outputs:e.signature.outputArg.reduce(((t,n)=>(t[n.name]=this.mapArgToTensorInfo(n,e.ret),t)),{})}}mapArgToTensorInfo(e,t){let n=e.name;return null!=t&&(n=t[n]),{name:n,dtype:e.type}}}function ww(e,t){const n=Array.isArray(e)?String.fromCharCode.apply(null,e):function(e){const t=K().global;if(void 0!==t.atob)return t.atob(e);if("undefined"!=typeof Buffer)return new Buffer(e,"base64").toString();throw new Error("Unable to decode base64 in this environment. Missing built-in atob() or Buffer()")}(e);return t?n:n.toLowerCase()}function kw(e,t,n,s=!1){const r=e[t];return null!=r?ww(r.s,s):n}function vw(e,t,n){const s=e[t];return s?s.b:n}function Nw(e,t,n){const s=e[t]||{},r=null!=s.i?s.i:null!=s.f?s.f:n;return"number"==typeof r?r:parseInt(r,10)}function Iw(e){switch("string"==typeof e&&(e=Hx[e]),e){case Hx.DT_FLOAT:return"float32";case Hx.DT_INT32:case Hx.DT_INT64:case Hx.DT_INT8:case Hx.DT_UINT8:return"int32";case Hx.DT_BOOL:return"bool";case Hx.DT_DOUBLE:return"float32";case Hx.DT_STRING:return"string";default:return null}}function $w(e,t,n){const s=e[t];return s&&s.func?s.func.name:n}function Cw(e,t,n){const s=e[t];return s&&s.type?Iw(s.type):n}function Sw(e,t,n){const s=e[t];return s&&s.list&&s.list.type?s.list.type.map((e=>Iw(e))):n}function Tw(e){if(!e.unknownRank)return null!=e.dim?e.dim.map((e=>"number"==typeof e.size?e.size:parseInt(e.size,10))):[]}function Ew(e,t,n){const s=e[t];return s&&s.shape?Tw(s.shape):n}function Aw(e,t,n){const s=e[t];return s?((s.list.f&&s.list.f.length?s.list.f:s.list.i)||[]).map((e=>"number"==typeof e?e:parseInt(e,10))):n}function Rw(e,t,n,s=!1){const r=e[t];return r&&r.list&&r.list.s?r.list.s.map((e=>ww(e,s))):n}function Fw(e,t,n){const s=e[t];return s&&s.list&&s.list.shape?s.list.shape.map((e=>Tw(e))):n}function Dw(e,t,n){const s=e[t];return s&&s.list&&s.list.b?s.list.b:n}class _w{constructor(e,t,n){this.node=e,this.tensorMap=t,this.context=n,this.inputs=[],this.attrs={},this.inputs=e.inputNames.map((e=>this.getInput(e))),null!=e.rawAttrs&&(this.attrs=Object.keys(e.rawAttrs).reduce(((e,t)=>(e[t]=this.getAttr(t),e)),{}))}getInput(e){return Yx(e,this.tensorMap,this.context)}getAttr(e,t){const n=this.node.rawAttrs[e];if(null!=n.tensor)return Yx(e,this.tensorMap,this.context);if(null!=n.i||null!=n.f)return Nw(this.node.rawAttrs,e,t);if(null!=n.s)return kw(this.node.rawAttrs,e,t);if(null!=n.b)return vw(this.node.rawAttrs,e,t);if(null!=n.shape)return Ew(this.node.rawAttrs,e,t);if(null!=n.type)return Cw(this.node.rawAttrs,e,t);if(null!=n.list){if(null!=n.list.i||null!=n.list.f)return Aw(this.node.rawAttrs,e,t);if(null!=n.list.s)return Rw(this.node.rawAttrs,e,t);if(null!=n.list.shape)return Fw(this.node.rawAttrs,e,t);if(null!=n.list.b)return Dw(this.node.rawAttrs,e,t);if(null!=n.list.type)return Sw(this.node.rawAttrs,e,t)}return t}}function Ow(e,t,n=""){if("number"!=typeof e&&"number"!=typeof t){l(e.length===t.length,(()=>n+` Shapes ${e} and ${t} must match`));for(let s=0;s<e.length;s++){const r=e[s],a=t[s];l(r<0||a<0||r===a,(()=>n+` Shapes ${e} and ${t} must match`))}}}function Mw(e){return"number"!=typeof e&&!e.some((e=>e<0))}function Lw(e,t,n){let s=zw(e,n);const r=!Mw(s);if(r&&0===t.length)throw new Error(`Tried to calculate elements of an empty list with non-fully-defined elementShape: ${s}`);if(r&&t.forEach((e=>{s=zw(e.shape,s)})),!Mw(s))throw new Error(`Non-fully-defined elementShape: ${s}`);return s}function zw(e,t){if("number"==typeof e)return t;if("number"==typeof t)return e;if(e.length!==t.length)throw new Error(`Incompatible ranks during merge: ${e} vs. ${t}`);const n=[];for(let s=0;s<e.length;++s){const r=e[s],a=t[s];if(r>=0&&a>=0&&r!==a)throw new Error(`Incompatible shape during merge: ${e} vs. ${t}`);n[s]=r>=0?r:a}return n}class Bw{constructor(e,t,n,s,r,a,i){this.name=e,this.dtype=t,this.maxSize=n,this.elementShape=s,this.identicalElementShapes=r,this.dynamicSize=a,this.clearAfterRead=i,this.tensors=[],this.closed_=!1,this.idTensor=Tu(0),li(this.idTensor)}get id(){return this.idTensor.id}get closed(){return this.closed_}clearAndClose(e){this.tensors.forEach((t=>{null!=e&&e.has(t.tensor.id)||t.tensor.dispose()})),this.tensors=[],this.closed_=!0,this.idTensor.dispose()}size(){return this.tensors.length}read(e){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||e>=this.size())throw new Error(`Tried to read from index ${e}, but array size is: ${this.size()}`);const t=this.tensors[e];if(t.cleared)throw new Error(`TensorArray ${this.name}: Could not read index ${e} twice because it was cleared after a previous read (perhaps try setting clear_after_read = false?).`);return this.clearAfterRead&&(t.cleared=!0),t.read=!0,t.tensor}readMany(e){return e.map((e=>this.read(e)))}write(e,t){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||!this.dynamicSize&&e>=this.maxSize)throw new Error(`Tried to write to index ${e}, but array is not resizeable and size is: ${this.maxSize}`);const n=this.tensors[e]||{};if(t.dtype!==this.dtype)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e},\n          because the value dtype is ${t.dtype}, but TensorArray dtype is ${this.dtype}.`);if(0!==this.size()||null!=this.elementShape&&0!==this.elementShape.length||(this.elementShape=t.shape),Ow(this.elementShape,t.shape,`TensorArray ${this.name}: Could not write to TensorArray index ${e}.`),n.read)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been read.`);if(n.written)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been written.`);n.tensor=t,li(t),n.written=!0,this.tensors[e]=n}writeMany(e,t){if(e.length!==t.length)throw new Error(`TensorArray ${this.name}: could not write multiple tensors,because the index size: ${e.length} is not the same as tensors size: ${t.length}.`);e.forEach(((e,n)=>this.write(e,t[n])))}gather(e,t){if(t&&t!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but gather requested dtype ${t}`);if(e)e=e.slice(0,this.size());else{e=[];for(let t=0;t<this.size();t++)e.push(t)}if(0===e.length)return ir([],[0].concat(this.elementShape));const n=this.readMany(e);return Ow(this.elementShape,n[0].shape,"TensorArray shape mismatch: "),Ku(n,0)}concat(e){if(e&&e!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but concat requested dtype ${e}`);if(0===this.size())return ir([],[0].concat(this.elementShape));const t=[];for(let e=0;e<this.size();e++)t.push(e);const n=this.readMany(t);return Ow(this.elementShape,n[0].shape,`TensorArray shape mismatch: tensor array shape (${this.elementShape}) vs first tensor shape (${n[0].shape})`),Hi(n,0)}scatter(e,t){if(t.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);if(e.length!==t.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${e.length} vs. ${t.shape[0]}`);const n=Math.max(...e);if(!this.dynamicSize&&n>=this.maxSize)throw new Error(`Max index must be < array size (${n}  vs. ${this.maxSize})`);this.writeMany(e,rc(t,0))}split(e,t){if(t.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);let n=0;const s=e.map((e=>(n+=e,n)));if(n!==t.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${n}, and tensor's shape is: ${t.shape}`);if(!this.dynamicSize&&e.length!==this.maxSize)throw new Error(`TensorArray's size is not equal to the size of lengths (${this.maxSize} vs. ${e.length}), and the TensorArray is not marked as dynamically resizeable`);const r=0===n?0:t.size/n,a=[];ii((()=>{t=Vi(t,[1,n,r]);for(let n=0;n<e.length;++n){const i=[0,0===n?0:s[n-1],0],o=[1,e[n],r];a[n]=Vi(qi(t,i,o),this.elementShape)}return a}));const i=[];for(let t=0;t<e.length;t++)i[t]=t;this.writeMany(i,a)}}class Pw{constructor(e,t,n,s=-1){this.tensors=e,this.elementShape=t,this.elementDtype=n,null!=e&&e.forEach((e=>{if(n!==e.dtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${e.dtype}`);Ow(t,e.shape,"TensorList shape mismatch: "),li(e)})),this.idTensor=Tu(0),this.maxNumElements=s,li(this.idTensor)}get id(){return this.idTensor.id}copy(){return new Pw([...this.tensors],this.elementShape,this.elementDtype)}clearAndClose(e){this.tensors.forEach((t=>{null!=e&&e.has(t.id)||t.dispose()})),this.tensors.length=0,this.idTensor.dispose()}size(){return this.tensors.length}stack(e,t,n=-1){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);if(-1!==n&&this.tensors.length!==n)throw new Error(`Operation expected a list with ${n} elements but got a list with ${this.tensors.length} elements.`);Ow(e,this.elementShape,"TensorList shape mismatch: ");const s=Lw(this.elementShape,this.tensors,e);return ii((()=>{const e=this.tensors.map((e=>Vi(e,s)));return Ku(e,0)}))}popBack(e,t){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);if(0===this.size())throw new Error("Trying to pop from an empty list.");const n=Lw(this.elementShape,this.tensors,e),s=this.tensors.pop();return Ow(s.shape,e,"TensorList shape mismatch: "),Vi(s,n)}pushBack(e){if(e.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${this.elementDtype}`);if(Ow(e.shape,this.elementShape,"TensorList shape mismatch: "),this.maxNumElements===this.size())throw new Error("Trying to push element into a full list.");li(e),this.tensors.push(e)}resize(e){if(e<0)throw new Error(`TensorListResize expects size to be non-negative. Got: ${e}`);if(-1!==this.maxNumElements&&e>this.maxNumElements)throw new Error(`TensorListResize input size ${e} is greater maxNumElement ${this.maxNumElements}.`);this.tensors.length=e}getItem(e,t,n){if(n!==this.elementDtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${this.elementDtype}`);if(e<0||e>this.tensors.length)throw new Error(`Trying to access element ${e} in a list with ${this.tensors.length} elements.`);if(null==this.tensors[e])throw new Error(`element at index ${e} is null.`);Ow(this.tensors[e].shape,t,"TensorList shape mismatch: ");const s=Lw(this.elementShape,this.tensors,t);return Vi(this.tensors[e],s)}setItem(e,t){if(t.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t.dtype}, but list elements ${this.elementDtype}`);if(e<0||-1!==this.maxNumElements&&e>=this.maxNumElements)throw new Error(`Trying to set element ${e} in a list with max ${this.maxNumElements} elements.`);Ow(this.elementShape,t.shape,"TensorList shape mismatch: "),li(t),this.tensors[e]=t}gather(e,t,n){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);Ow(this.elementShape,n,"TensorList shape mismatch: "),e=e.slice(0,this.size());const s=Lw(this.elementShape,this.tensors,n);return 0===e.length?ir([],[0].concat(s)):ii((()=>{const t=e.map((e=>Vi(this.tensors[e],s)));return Ku(t,0)}))}concat(e,t){if(e&&e!==this.elementDtype)throw new Error(`TensorList dtype is ${this.elementDtype} but concat requested dtype ${e}`);Ow(this.elementShape,t,"TensorList shape mismatch: ");const n=Lw(this.elementShape,this.tensors,t);return 0===this.size()?ir([],[0].concat(n)):ii((()=>{const e=this.tensors.map((e=>Vi(e,n)));return Hi(e,0)}))}}const Ww=async(e,t,n)=>{switch(e.op){case"If":case"StatelessIf":{const s=Xx("thenBranch",e,t,n),r=Xx("elseBranch",e,t,n),a=Xx("cond",e,t,n),i=Xx("args",e,t,n);return(await a.data())[0]?n.functionMap[s].executeFunctionAsync(i,n.tensorArrayMap,n.tensorListMap):n.functionMap[r].executeFunctionAsync(i,n.tensorArrayMap,n.tensorListMap)}case"While":case"StatelessWhile":{const s=Xx("body",e,t,n),r=Xx("cond",e,t,n),a=Xx("args",e,t,n),i=await n.functionMap[r].executeFunctionAsync(a,n.tensorArrayMap,n.tensorListMap),o=a.map((e=>e.id));let l=await i[0].data();i.forEach((e=>{e.kept||-1!==o.indexOf(e.id)||e.dispose()}));let u=a;for(;l[0];){const e=u;u=await n.functionMap[s].executeFunctionAsync(u,n.tensorArrayMap,n.tensorListMap);const t=u.map((e=>e.id));e.forEach((e=>{e.kept||-1!==o.indexOf(e.id)||-1!==t.indexOf(e.id)||e.dispose()}));const a=await n.functionMap[r].executeFunctionAsync(u,n.tensorArrayMap,n.tensorListMap);l=await a[0].data(),a.forEach((e=>{e.kept||-1!==o.indexOf(e.id)||-1!==t.indexOf(e.id)||e.dispose()}))}return u}case"LoopCond":return[tw(Xx("pred",e,t,n))];case"Switch":{const s=Xx("pred",e,t,n);let r=Xx("data",e,t,n);return r.kept||(r=tw(r)),(await s.data())[0]?[void 0,r]:[r,void 0]}case"Merge":{const s=e.inputNames.find((e=>void 0!==Yx(e,t,n)));if(s){return[tw(Yx(s,t,n))]}return}case"Enter":{const s=Xx("frameName",e,t,n),r=Xx("tensor",e,t,n);return n.enterFrame(s),[tw(r)]}case"Exit":{const s=Xx("tensor",e,t,n);return n.exitFrame(),[tw(s)]}case"NextIteration":{const s=Xx("tensor",e,t,n);return n.nextIteration(),[tw(s)]}case"TensorArrayV3":{const s=Xx("size",e,t,n),r=Xx("dtype",e,t,n),a=Xx("elementShape",e,t,n),i=Xx("dynamicSize",e,t,n),o=Xx("clearAfterRead",e,t,n),l=Xx("identicalElementShapes",e,t,n),u=Xx("name",e,t,n),c=new Bw(u,r,s,a,l,i,o);return n.addTensorArray(c),[c.idTensor,Tu(1)]}case"TensorArrayWriteV3":{const s=Xx("tensorArrayId",e,t,n),r=Xx("index",e,t,n),a=Xx("tensor",e,t,n),i=n.getTensorArray(s.id);return i.write(r,a),[i.idTensor]}case"TensorArrayReadV3":{const s=Xx("tensorArrayId",e,t,n),r=Xx("index",e,t,n);return[n.getTensorArray(s.id).read(r)]}case"TensorArrayGatherV3":{const s=Xx("tensorArrayId",e,t,n),r=Xx("indices",e,t,n),a=Xx("dtype",e,t,n);return[n.getTensorArray(s.id).gather(r,a)]}case"TensorArrayScatterV3":{const s=Xx("tensorArrayId",e,t,n),r=Xx("indices",e,t,n),a=Xx("tensor",e,t,n),i=n.getTensorArray(s.id);return i.scatter(r,a),[i.idTensor]}case"TensorArrayConcatV3":{const s=Xx("tensorArrayId",e,t,n),r=n.getTensorArray(s.id),a=Xx("dtype",e,t,n);return[r.concat(a)]}case"TensorArraySplitV3":{const s=Xx("tensorArrayId",e,t,n),r=Xx("tensor",e,t,n),a=Xx("lengths",e,t,n),i=n.getTensorArray(s.id);return i.split(a,r),[i.idTensor]}case"TensorArraySizeV3":{const s=Xx("tensorArrayId",e,t,n);return[Tu(n.getTensorArray(s.id).size(),"int32")]}case"TensorArrayCloseV3":{const s=Xx("tensorArrayId",e,t,n),r=n.getTensorArray(s.id);return r.clearAndClose(),[r.idTensor]}case"TensorListSetItem":{const s=Xx("tensorListId",e,t,n),r=Xx("index",e,t,n),a=Xx("tensor",e,t,n),i=n.getTensorList(s.id);return i.setItem(r,a),[i.idTensor]}case"TensorListGetItem":{const s=Xx("tensorListId",e,t,n),r=Xx("index",e,t,n),a=Xx("elementShape",e,t,n),i=Xx("elementDType",e,t,n);return[n.getTensorList(s.id).getItem(r,a,i)]}case"TensorListScatterV2":case"TensorListScatter":{const s=Xx("indices",e,t,n),r=function(e,t,n,s){if(t.length!==e.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${t.length} vs. ${e.shape[0]}`);const r=Math.max(...t);if(null!=s&&-1!==s&&r>=s)throw new Error(`Max index must be < array size (${r}  vs. ${s})`);const a=new Pw([],n,e.dtype,s),i=rc(e,0);return t.forEach(((e,t)=>{a.setItem(e,i[t])})),a}(Xx("tensor",e,t,n),s,Xx("elementShape",e,t,n),Xx("numElements",e,t,n));return n.addTensorList(r),[r.idTensor]}case"TensorListReserve":case"EmptyTensorList":{const s=Xx("elementShape",e,t,n),r=Xx("elementDType",e,t,n);let a;a="TensorListReserve"===e.op?"numElements":"maxNumElements";const i=function(e,t,n){return new Pw([],e,t,n)}(s,r,Xx(a,e,t,n));return n.addTensorList(i),[i.idTensor]}case"TensorListGather":{const s=Xx("tensorListId",e,t,n),r=Xx("indices",e,t,n),a=Xx("elementShape",e,t,n),i=Xx("elementDType",e,t,n);return[n.getTensorList(s.id).gather(r,i,a)]}case"TensorListStack":{const s=Xx("tensorListId",e,t,n),r=Xx("elementShape",e,t,n),a=Xx("elementDType",e,t,n),i=Xx("numElements",e,t,n);return[n.getTensorList(s.id).stack(r,a,i)]}case"TensorListFromTensor":{const s=function(e,t,n){const s=e.dtype;if(e.shape.length<1)throw new Error(`Tensor must be at least a vector, but saw shape: ${e.shape}`);if(e.dtype!==n)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${n}`);Ow(e.shape.slice(1),t,"TensorList shape mismatch: ");const r=rc(e);return new Pw(r,t,s)}(Xx("tensor",e,t,n),Xx("elementShape",e,t,n),Xx("elementDType",e,t,n));return n.addTensorList(s),[s.idTensor]}case"TensorListConcat":{const s=Xx("tensorListId",e,t,n),r=n.getTensorList(s.id),a=Xx("dtype",e,t,n),i=Xx("elementShape",e,t,n);return[r.concat(a,i)]}case"TensorListPushBack":{const s=Xx("tensorListId",e,t,n),r=Xx("tensor",e,t,n),a=n.getTensorList(s.id);return a.pushBack(r),[a.idTensor]}case"TensorListPopBack":{const s=Xx("tensorListId",e,t,n),r=Xx("elementShape",e,t,n),a=Xx("elementDType",e,t,n);return[n.getTensorList(s.id).popBack(r,a)]}case"TensorListSplit":{const s=Xx("tensor",e,t,n),r=Xx("elementShape",e,t,n),a=function(e,t,n){let s=0;const r=t.map((e=>(s+=e,s)));if(s!==e.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${s}, and tensor's shape is: ${e.shape}`);const a=zw(e.shape.slice(1),n),i=0===s?0:e.size/s,o=ii((()=>{const n=[];e=Vi(e,[1,s,i]);for(let s=0;s<t.length;++s){const o=[0,0===s?0:r[s-1],0],l=[1,t[s],i];n[s]=Vi(qi(e,o,l),a)}return e.dispose(),n})),l=new Pw([],n,e.dtype,t.length);for(let e=0;e<o.length;e++)l.setItem(e,o[e]);return l}(s,Xx("lengths",e,t,n),r);return n.addTensorList(a),[a.idTensor]}default:throw TypeError(`Node type ${e.op} is not implemented`)}};function Vw(e,t,n){const[s,r]=Xx("fusedOps",e,t,n),a="biasadd"===s,i="prelu"===r,o="fusedbatchnorm"===s,l=Xx("numArgs",e,t,n);if(a){if(i&&2!==l)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!i&&1!==l)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd must have one extra argument: bias.")}if(o)throw new Error("FusedConv2d and DepthwiseConv2d with FusedBatchNorm is not supported");const u=Xx("strides",e,t,n),c=ew(e,t,n),h=Xx("dataFormat",e,t,n).toUpperCase(),p=Xx("dilations",e,t,n),[d,f]=Xx("args",e,t,n);return{stride:u,pad:c,dataFormat:h,dilations:p,biasArg:d,preluArg:f,activationFunc:r,leakyreluAlpha:Xx("leakyreluAlpha",e,t,n)}}function Uw(e,t,n){return{boxes:Xx("boxes",e,t,n),scores:Xx("scores",e,t,n),maxOutputSize:Xx("maxOutputSize",e,t,n),iouThreshold:Xx("iouThreshold",e,t,n),scoreThreshold:Xx("scoreThreshold",e,t,n),softNmsSigma:Xx("softNmsSigma",e,t,n)}}class Gw{constructor(e,t){this.keyDType=e,this.valueDType=t,this.handle=Tu(0),this.tensorMap=new Map,li(this.handle)}get id(){return this.handle.id}clearAndClose(){this.tensorMap.forEach((e=>e.dispose())),this.tensorMap.clear(),this.handle.dispose()}size(){return this.tensorMap.size}tensorSize(){return Tu(this.size(),"int32")}async import(e,t){this.checkKeyAndValueTensor(e,t);const n=await e.data();return this.tensorMap.forEach((e=>e.dispose())),this.tensorMap.clear(),ii((()=>{const e=rc(t),s=n.length,r=e.length;l(s===r,(()=>`The number of elements doesn't match, keys has ${s} elements, the values has ${r} elements.`));for(let t=0;t<s;t++){const s=n[t],r=e[t];li(r),this.tensorMap.set(s,r)}return this.handle}))}async find(e,t){this.checkKeyAndValueTensor(e,t);const n=await e.data();return ii((()=>{const e=[];for(let s=0;s<n.length;s++){const r=n[s],a=this.findWithDefault(r,t);e.push(a)}return Ku(e)}))}findWithDefault(e,t){const n=this.tensorMap.get(e);return null!=n?n:t}checkKeyAndValueTensor(e,t){if(e.dtype!==this.keyDType)throw new Error(`Expect key dtype ${this.keyDType}, but got ${e.dtype}`);if(t.dtype!==this.valueDType)throw new Error(`Expect value dtype ${this.valueDType}, but got ${t.dtype}`)}}function Hw(e,t,n,s){const r=((e,t,n)=>{switch(e.category){case"arithmetic":return ii((()=>((e,t,n)=>{switch(e.op){case"BiasAdd":case"AddV2":case"Add":return[pi(Xx("a",e,t,n),Xx("b",e,t,n))];case"AddN":return[xi(Xx("tensors",e,t,n))];case"FloorMod":case"Mod":return[Ml(Xx("a",e,t,n),Xx("b",e,t,n))];case"Mul":return[mi(Xx("a",e,t,n),Xx("b",e,t,n))];case"RealDiv":case"Div":return[fi(Xx("a",e,t,n),Xx("b",e,t,n))];case"DivNoNan":return[Ro(Xx("a",e,t,n),Xx("b",e,t,n))];case"FloorDiv":return[di(Xx("a",e,t,n),Xx("b",e,t,n))];case"Sub":return[cl(Xx("a",e,t,n),Xx("b",e,t,n))];case"Minimum":return[_l(Xx("a",e,t,n),Xx("b",e,t,n))];case"Maximum":return[El(Xx("a",e,t,n),Xx("b",e,t,n))];case"Pow":return[Jl(Xx("a",e,t,n),Xx("b",e,t,n))];case"SquaredDifference":return[ju(Xx("a",e,t,n),Xx("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"basic_math":return ii((()=>((e,t,n)=>{switch(e.op){case"Abs":case"ComplexAbs":return[gi(Xx("x",e,t,n))];case"Acos":return[yi(Xx("x",e,t,n))];case"Acosh":return[bi(Xx("x",e,t,n))];case"Asin":return[Ii(Xx("x",e,t,n))];case"Asinh":return[$i(Xx("x",e,t,n))];case"Atan":return[Ci(Xx("x",e,t,n))];case"Atan2":return[Si(Xx("x",e,t,n),Xx("y",e,t,n))];case"Atanh":return[Ti(Xx("x",e,t,n))];case"Ceil":return[so(Xx("x",e,t,n))];case"Complex":return[rr(Xx("real",e,t,n),Xx("imag",e,t,n))];case"Cos":return[yo(Xx("x",e,t,n))];case"Cosh":return[bo(Xx("x",e,t,n))];case"Elu":return[_o(Xx("x",e,t,n))];case"Erf":return[Oo(Xx("x",e,t,n))];case"Exp":return[Mo(Xx("x",e,t,n))];case"Expm1":return[zo(Xx("x",e,t,n))];case"Floor":return[Vo(Xx("x",e,t,n))];case"Log":return[tl(Xx("x",e,t,n))];case"Log1p":return[nl(Xx("x",e,t,n))];case"Imag":return[jo(Xx("x",e,t,n))];case"Neg":return[il(Xx("x",e,t,n))];case"Reciprocal":return[bu(Xx("x",e,t,n))];case"Real":return[yu(Xx("x",e,t,n))];case"Relu":return[xu(Xx("x",e,t,n))];case"Round":return[Cu(Xx("x",e,t,n))];case"Selu":return[Eu(Xx("x",e,t,n))];case"Sigmoid":return[ji(Xx("x",e,t,n))];case"Sin":return[Du(Xx("x",e,t,n))];case"Sign":return[Fu(Xx("x",e,t,n))];case"Sinh":return[_u(Xx("x",e,t,n))];case"Softplus":return[ol(Xx("x",e,t,n))];case"Sqrt":return[Hu(Xx("x",e,t,n))];case"Square":return[Ll(Xx("x",e,t,n))];case"Tanh":return[Ki(Xx("x",e,t,n))];case"Tan":return[Ju(Xx("x",e,t,n))];case"ClipByValue":return[ro(Xx("x",e,t,n),Xx("clipValueMin",e,t,n),Xx("clipValueMax",e,t,n))];case"Relu6":return[wu(Xx("x",e,t,n))];case"Rsqrt":return[Su(Yx(e.inputNames[0],t,n))];case"Prod":return[Ql(Xx("x",e,t,n),Xx("axes",e,t,n))];case"LeakyRelu":return[Yo(Xx("x",e,t,n),Xx("alpha",e,t,n))];case"Prelu":return[Zl(Xx("x",e,t,n),Xx("alpha",e,t,n))];case"IsNan":return[Xo(Yx(e.inputNames[0],t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"control":return Ww(e,t,n);case"convolution":return ii((()=>((e,t,n)=>{switch(e.op){case"Conv1D":{const s=Xx("stride",e,t,n),r=Xx("pad",e,t,n),a=Xx("dataFormat",e,t,n).toUpperCase(),i=Xx("dilation",e,t,n);return[co(Xx("x",e,t,n),Xx("filter",e,t,n),s,r,a,i)]}case"Conv2D":{const s=Xx("strides",e,t,n),r=ew(e,t,n),a=Xx("dataFormat",e,t,n).toUpperCase(),i=Xx("dilations",e,t,n);return[uo(Xx("x",e,t,n),Xx("filter",e,t,n),[s[1],s[2]],r,a,[i[1],i[2]])]}case"_FusedConv2D":{const{stride:s,pad:r,dataFormat:a,dilations:i,biasArg:o,preluArg:l,activationFunc:u,leakyreluAlpha:c}=Vw(e,t,n);return[Ic({x:Xx("x",e,t,n),filter:Xx("filter",e,t,n),strides:[s[1],s[2]],pad:r,dataFormat:a,dilations:[i[1],i[2]],bias:o,activation:u,preluActivationWeights:l,leakyreluAlpha:c})]}case"FusedDepthwiseConv2dNative":{const{stride:s,pad:r,dataFormat:a,dilations:i,biasArg:o,preluArg:l,activationFunc:u,leakyreluAlpha:c}=Vw(e,t,n);return[Sc({x:Xx("x",e,t,n),filter:Xx("filter",e,t,n),strides:[s[1],s[2]],pad:r,dataFormat:a,dilations:[i[1],i[2]],bias:o,activation:u,preluActivationWeights:l,leakyreluAlpha:c})]}case"Conv2DBackpropInput":case"Conv2dTranspose":{const s=Xx("outputShape",e,t,n),r=Xx("strides",e,t,n),a=ew(e,t,n);return[po(Xx("x",e,t,n),Xx("filter",e,t,n),s,[r[1],r[2]],a)]}case"DepthwiseConv2dNative":case"DepthwiseConv2d":{const s=Xx("strides",e,t,n),r=ew(e,t,n),a=Xx("dilations",e,t,n),i=Xx("dataFormat",e,t,n).toUpperCase();return[vo(Xx("input",e,t,n),Xx("filter",e,t,n),[s[1],s[2]],r,i,[a[1],a[2]])]}case"Conv3D":{const s=Xx("strides",e,t,n),r=Xx("pad",e,t,n),a=Xx("dataFormat",e,t,n).toUpperCase(),i=Xx("dilations",e,t,n);return[fo(Xx("x",e,t,n),Xx("filter",e,t,n),[s[1],s[2],s[3]],r,a,[i[1],i[2],i[3]])]}case"AvgPool":{const s=Xx("strides",e,t,n),r=Xx("pad",e,t,n),a=Xx("kernelSize",e,t,n);return[Ui(Xx("x",e,t,n),[a[1],a[2]],[s[1],s[2]],r)]}case"MaxPool":{const s=Xx("strides",e,t,n),r=Xx("pad",e,t,n),a=Xx("kernelSize",e,t,n);return[Cl(Xx("x",e,t,n),[a[1],a[2]],[s[1],s[2]],r)]}case"MaxPoolWithArgmax":{const s=Xx("strides",e,t,n),r=Xx("pad",e,t,n),a=Xx("kernelSize",e,t,n),i=Xx("includeBatchInIndex",e,t,n),{result:o,indexes:l}=Tl(Xx("x",e,t,n),[a[1],a[2]],[s[1],s[2]],r,i);return[o,l]}case"AvgPool3D":{const s=Xx("strides",e,t,n),r=Xx("pad",e,t,n),a=Xx("kernelSize",e,t,n);return[Gi(Xx("x",e,t,n),[a[1],a[2],a[3]],[s[1],s[2],s[3]],r)]}case"MaxPool3D":{const s=Xx("strides",e,t,n),r=Xx("pad",e,t,n),a=Xx("kernelSize",e,t,n);return[Sl(Xx("x",e,t,n),[a[1],a[2],a[3]],[s[1],s[2],s[3]],r)]}case"Dilation2D":{const s=Xx("strides",e,t,n),r=Xx("pad",e,t,n),a=Xx("dilations",e,t,n),i=s[1],o=s[2],l=a[1],u=a[2];return[Io(Xx("x",e,t,n),Xx("filter",e,t,n),[i,o],r,[l,u],"NHWC")]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"creation":return ii((()=>((e,t,n)=>{switch(e.op){case"Fill":{const s=Xx("shape",e,t,n),r=Xx("dtype",e,t,n);return[Wo(s,Xx("value",e,t,n),r)]}case"LinSpace":return[Qo(Xx("start",e,t,n),Xx("stop",e,t,n),Xx("num",e,t,n))];case"Multinomial":{const s=Xx("logits",e,t,n),r=Xx("numSamples",e,t,n),a=Xx("seed",e,t,n);return[Pl(s,r,a)]}case"OneHot":{const s=Xx("indices",e,t,n),r=Xx("depth",e,t,n),a=Xx("onValue",e,t,n),i=Xx("offValue",e,t,n);return[fa(s,r,a,i)]}case"Ones":return[Fl(Xx("shape",e,t,n),Xx("dtype",e,t,n))];case"OnesLike":return[Vl(Xx("x",e,t,n))];case"RandomUniform":return[mu(Xx("shape",e,t,n),Xx("minval",e,t,n),Xx("maxval",e,t,n),Xx("dtype",e,t,n))];case"Range":return[gu(Xx("start",e,t,n),Xx("stop",e,t,n),Xx("step",e,t,n),Xx("dtype",e,t,n))];case"TruncatedNormal":{const s=Xx("shape",e,t,n),r=Xx("mean",e,t,n),a=Xx("stdDev",e,t,n),i=Xx("seed",e,t,n);return[tc(s,r,a,Xx("dtype",e,t,n),i)]}case"Zeros":return[Rl(Xx("shape",e,t,n),Xx("dtype",e,t,n))];case"ZerosLike":return[Ao(Xx("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"dynamic":return(async(e,t,n)=>{switch(e.op){case"NonMaxSuppressionV5":{const{boxes:s,scores:r,maxOutputSize:a,iouThreshold:i,scoreThreshold:o,softNmsSigma:l}=Uw(e,t,n),u=await kh.nonMaxSuppressionWithScoreAsync(s,r,a,i,o,l);return[u.selectedIndices,u.selectedScores]}case"NonMaxSuppressionV4":{const{boxes:s,scores:r,maxOutputSize:a,iouThreshold:i,scoreThreshold:o}=Uw(e,t,n),l=Xx("padToMaxOutputSize",e,t,n),u=await kh.nonMaxSuppressionPaddedAsync(s,r,a,i,o,l);return[u.selectedIndices,u.validOutputs]}case"NonMaxSuppressionV3":case"NonMaxSuppressionV2":{const{boxes:s,scores:r,maxOutputSize:a,iouThreshold:i,scoreThreshold:o}=Uw(e,t,n);return[await kh.nonMaxSuppressionAsync(s,r,a,i,o)]}case"Where":{const s=Xr(Xx("condition",e,t,n),"bool"),r=[await oc(s)];return s.dispose(),r}case"ListDiff":return Ru(Xx("x",e,t,n),Xx("y",e,t,n));default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n);case"evaluation":return ii((()=>((e,t,n)=>{switch(e.op){case"TopKV2":{const s=Xx("x",e,t,n),r=Xx("k",e,t,n),a=Xx("sorted",e,t,n),i=ec(s,r,a);return[i.values,i.indices]}case"Unique":{const s=Xx("x",e,t,n),r=nc(s);return[r.values,r.indices]}case"UniqueV2":{const s=Xx("x",e,t,n),r=Xx("axis",e,t,n),a=nc(s,r);return[a.values,a.indices]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"image":return ii((()=>((e,t,n)=>{switch(e.op){case"ResizeBilinear":{const s=Xx("images",e,t,n),r=Xx("size",e,t,n),a=Xx("alignCorners",e,t,n),i=Xx("halfPixelCenters",e,t,n);return[kh.resizeBilinear(s,[r[0],r[1]],a,i)]}case"ResizeNearestNeighbor":{const s=Xx("images",e,t,n),r=Xx("size",e,t,n),a=Xx("alignCorners",e,t,n),i=Xx("halfPixelCenters",e,t,n);return[kh.resizeNearestNeighbor(s,[r[0],r[1]],a,i)]}case"CropAndResize":{const s=Xx("image",e,t,n),r=Xx("boxes",e,t,n),a=Xx("boxInd",e,t,n),i=Xx("cropSize",e,t,n),o=Xx("method",e,t,n),l=Xx("extrapolationValue",e,t,n);return[kh.cropAndResize(s,r,a,i,o,l)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"graph":return ii((()=>((e,t,n)=>{switch(e.op){case"Const":return t[e.name];case"PlaceholderWithDefault":const s=Xx("default",e,t,n);return[Yx(e.name,t,n)||s];case"Placeholder":return[Yx(e.name,t,n)];case"Identity":case"StopGradient":case"FakeQuantWithMinMaxVars":return[tw(Xx("x",e,t,n))];case"IdentityN":return Xx("x",e,t,n).map((e=>tw(e)));case"Snapshot":return[tw(Xx("x",e,t,n))];case"Shape":return[Zu(Xx("x",e,t,n).shape,"int32")];case"ShapeN":return Xx("x",e,t,n).map((e=>Zu(e.shape)));case"Size":return[Tu(Xx("x",e,t,n).size,"int32")];case"Rank":return[Tu(Xx("x",e,t,n).rank,"int32")];case"NoOp":return[Tu(1)];case"Print":const r=Xx("x",e,t,n),a=Xx("data",e,t,n),i=Xx("message",e,t,n),o=Xx("summarize",e,t,n);console.warn("The graph has a tf.print() operation,usually used for debugging, which slows down performance."),console.log(i);for(let e=0;e<a.length;e++)console.log(Array.prototype.slice.call(a[e].dataSync()).slice(0,o));return[r];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"logical":return ii((()=>((e,t,n)=>{switch(e.op){case"Equal":return[To(Xx("a",e,t,n),Xx("b",e,t,n))];case"NotEqual":return[Wl(Xx("a",e,t,n),Xx("b",e,t,n))];case"Greater":return[Go(Xx("a",e,t,n),Xx("b",e,t,n))];case"GreaterEqual":return[Ho(Xx("a",e,t,n),Xx("b",e,t,n))];case"Less":return[Jo(Xx("a",e,t,n),Xx("b",e,t,n))];case"LessEqual":return[Zo(Xx("a",e,t,n),Xx("b",e,t,n))];case"LogicalAnd":return[vl(Xx("a",e,t,n),Xx("b",e,t,n))];case"LogicalNot":return[Nl(Xx("a",e,t,n))];case"LogicalOr":return[Il(Xx("a",e,t,n),Xx("b",e,t,n))];case"Select":case"SelectV2":return[Eo(Xx("condition",e,t,n),Xx("a",e,t,n),Xx("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"matrices":return ii((()=>((e,t,n)=>{switch(e.op){case"BatchMatMul":case"BatchMatMulV2":case"MatMul":return[da(Xx("a",e,t,n),Xx("b",e,t,n),Xx("transposeA",e,t,n),Xx("transposeB",e,t,n))];case"Einsum":return[Do(Xx("equation",e,t,n),...Xx("tensors",e,t,n))];case"Transpose":return[ma(Xx("x",e,t,n),Xx("perm",e,t,n))];case"_FusedMatMul":const[s,r]=Xx("fusedOps",e,t,n),a="biasadd"===s,i="prelu"===r,o=Xx("numArgs",e,t,n),l=Xx("leakyreluAlpha",e,t,n);if(a){if(i&&2!==o)throw new Error("Fused MatMul with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!i&&1!==o)throw new Error("Fused MatMul with BiasAdd must have one extra argument: bias.")}const[u,c]=Xx("args",e,t,n);return[Tc({a:Xx("a",e,t,n),b:Xx("b",e,t,n),transposeA:Xx("transposeA",e,t,n),transposeB:Xx("transposeB",e,t,n),bias:u,activation:r,preluActivationWeights:c,leakyreluAlpha:l})];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"normalization":return ii((()=>((e,t,n)=>{switch(e.op){case"FusedBatchNorm":case"FusedBatchNormV2":case"FusedBatchNormV3":return[Ji(Xx("x",e,t,n),Xx("mean",e,t,n),Xx("variance",e,t,n),Xx("offset",e,t,n),Xx("scale",e,t,n),Xx("epsilon",e,t,n))];case"LRN":return[el(Xx("x",e,t,n),Xx("radius",e,t,n),Xx("bias",e,t,n),Xx("alpha",e,t,n),Xx("beta",e,t,n))];case"Softmax":return[Bu(Xx("x",e,t,n))];case"LogSoftmax":return[pl(Xx("x",e,t,n))];case"SparseToDense":return[dc(Xx("sparseIndices",e,t,n),Xx("outputShape",e,t,n),Xx("sparseValues",e,t,n),Xx("defaultValue",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"reduction":return ii((()=>((e,t,n)=>{switch(e.op){case"Max":{const s=Xx("axis",e,t,n),r=Xx("keepDims",e,t,n);return[ul(Xx("x",e,t,n),s,r)]}case"Mean":{const s=Xx("axis",e,t,n),r=Xx("keepDims",e,t,n);return[Al(Xx("x",e,t,n),s,r)]}case"Min":{const s=Xx("axis",e,t,n),r=Xx("keepDims",e,t,n);return[Dl(Xx("x",e,t,n),s,r)]}case"Sum":{const s=Xx("axis",e,t,n),r=Xx("keepDims",e,t,n);return[hl(Xx("x",e,t,n),s,r)]}case"All":{const s=Xx("axis",e,t,n),r=Xx("keepDims",e,t,n);return[wi(Xx("x",e,t,n),s,r)]}case"Any":{const s=Xx("axis",e,t,n),r=Xx("keepDims",e,t,n);return[ki(Xx("x",e,t,n),s,r)]}case"ArgMax":{const s=Xx("axis",e,t,n);return[vi(Xx("x",e,t,n),s)]}case"ArgMin":{const s=Xx("axis",e,t,n);return[Ni(Xx("x",e,t,n),s)]}case"Prod":{const s=Xx("axis",e,t,n),r=Xx("keepDims",e,t,n);return[Ql(Xx("x",e,t,n),s,r)]}case"Cumsum":{const s=Xx("axis",e,t,n),r=Xx("exclusive",e,t,n),a=Xx("reverse",e,t,n);return[xo(Xx("x",e,t,n),s,r,a)]}case"Bincount":const s=Xx("x",e,t,n),r=Xx("weights",e,t,n),a=Xx("size",e,t,n);return[to(s,r,a)];case"DenseBincount":{const s=Xx("x",e,t,n),r=Xx("weights",e,t,n),a=Xx("size",e,t,n),i=Xx("binaryOutput",e,t,n);return[wo(s,r,a,i)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"slice_join":return ii((()=>((e,t,n)=>{switch(e.op){case"ConcatV2":case"Concat":{const s=Xx("n",e,t,n),r=Xx("axis",e,t,n);let a=Xx("tensors",e,t,n);return a=a.slice(0,s),[Hi(a,r)]}case"Gather":{const s=Xx("x",e,t,n),r=Xx("indices",e,t,n);return[Uo(s,Xr(r,"int32"),0)]}case"GatherV2":{const s=Xx("axis",e,t,n),r=Xx("batchDims",e,t,n),a=Xx("x",e,t,n),i=Xx("indices",e,t,n);return[Uo(a,Xr(i,"int32"),s,r)]}case"Reverse":{const s=Xx("dims",e,t,n),r=[];for(let e=0;e<s.length;e++)s[e]&&r.push(e);const a=Xx("x",e,t,n);return[ku(a,r)]}case"ReverseV2":{const s=Xx("axis",e,t,n),r=Xx("x",e,t,n);return[ku(r,s)]}case"Slice":{const s=Xx("begin",e,t,n),r=Xx("size",e,t,n);return[qi(Xx("x",e,t,n),s,r)]}case"StridedSlice":{const s=Xx("begin",e,t,n),r=Xx("end",e,t,n),a=Xx("strides",e,t,n),i=Xx("beginMask",e,t,n),o=Xx("endMask",e,t,n),l=Xx("ellipsisMask",e,t,n),u=Xx("newAxisMask",e,t,n),c=Xx("shrinkAxisMask",e,t,n),h=Xx("x",e,t,n);return[Yu(h,s,r,a,i,o,l,u,c)]}case"Pack":return ii((()=>{const s=Xx("axis",e,t,n),r=Xx("tensors",e,t,n),a=r[0].shape,i=qu(r[0]).shape,o=r.map((e=>{const t=d(e.shape,a);if(!t&&!d(qu(e).shape,i))throw new Error("the input tensors shape does not match");return t?e:Vi(e,a)}));return[Ku(o,s)]}));case"Unpack":{const s=Xx("axis",e,t,n),r=Xx("tensor",e,t,n);return rc(r,s)}case"Tile":{const s=Xx("reps",e,t,n);return[Bo(Xx("x",e,t,n),s)]}case"Split":case"SplitV":{const s=Xx("axis",e,t,n),r=Xx("numOrSizeSplits",e,t,n),a=Xx("x",e,t,n);return Uu(a,r,s)}case"ScatterNd":{const s=Xx("indices",e,t,n),r=Xx("values",e,t,n),a=Xx("shape",e,t,n);return[pc(s,r,a)]}case"GatherNd":{const s=Xx("x",e,t,n),r=Xx("indices",e,t,n);return[fc(s,r)]}case"SparseToDense":{const s=Xx("sparseIndices",e,t,n),r=Xx("outputShape",e,t,n),a=Xx("sparseValues",e,t,n),i=Xx("defaultValue",e,t,n);return[dc(s,a,r,a.dtype===i.dtype?i:Xr(i,a.dtype))]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"sparse":return ii((()=>((e,t,n)=>{switch(e.op){case"SparseReshape":{const{outputIndices:s,outputShape:r}=Ih.sparseReshape(Xx("inputIndices",e,t,n),Xx("inputShape",e,t,n),Xx("newShape",e,t,n));return[s,r]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"spectral":return ii((()=>((e,t,n)=>{switch(e.op){case"FFT":return[Pu(Xx("x",e,t,n))];case"IFFT":return[Wu(Xx("x",e,t,n))];case"RFFT":return[Gu(Xx("x",e,t,n))];case"IRFFT":return[Vu(Xx("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"transformation":return ii((()=>((e,t,n)=>{switch(e.op){case"Cast":return[Xr(Xx("x",e,t,n),Xx("dtype",e,t,n))];case"ExpandDims":{const s=Xx("axis",e,t,n);return[Lo(Xx("x",e,t,n),s)]}case"Squeeze":{const s=Xx("axis",e,t,n);return[qu(Xx("x",e,t,n),s)]}case"Reshape":return[Vi(Xx("x",e,t,n),Xx("shape",e,t,n))];case"MirrorPad":return[Ol(Xx("x",e,t,n),Xx("padding",e,t,n),Xx("mode",e,t,n))];case"PadV2":case"Pad":return[Gl(Xx("x",e,t,n),Xx("padding",e,t,n),Xx("constantValue",e,t,n))];case"SpaceToBatchND":{const s=Xx("blockShape",e,t,n),r=Xx("paddings",e,t,n);return[Xl(Xx("x",e,t,n),s,r)]}case"BatchToSpaceND":{const s=Xx("blockShape",e,t,n),r=Xx("crops",e,t,n);return[Yi(Xx("x",e,t,n),s,r)]}case"DepthToSpace":{const s=Xx("blockSize",e,t,n),r=Xx("dataFormat",e,t,n).toUpperCase();return[ko(Xx("x",e,t,n),s,r)]}case"BroadcastTo":return[no(Xx("x",e,t,n),Xx("shape",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"hash_table":return(async(e,t,n,s)=>{switch(e.op){case"HashTable":case"HashTableV2":{const r=Xx("keyDType",e,t,n),a=Xx("valueDType",e,t,n),i=new Gw(r,a);return s.addHashTable(e.name,i),[i.handle]}case"LookupTableImport":case"LookupTableImportV2":{const r=Xx("tableHandle",e,t,n,s),a=Xx("keys",e,t,n),i=Xx("values",e,t,n),o=s.getHashTableById(r.id);return[await o.import(a,i)]}case"LookupTableFind":case"LookupTableFindV2":{const r=Xx("tableHandle",e,t,n,s),a=Xx("keys",e,t,n),i=Xx("defaultValue",e,t,n),o=s.getHashTableById(r.id);return[await o.find(a,i)]}case"LookupTableSize":case"LookupTableSizeV2":{const r=Xx("tableHandle",e,t,n,s);return[s.getHashTableById(r.id).tensorSize()]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n,s);case"custom":const r=Kx(e.op);if(r&&r.customExecutor)return r.customExecutor(new _w(e,t,n));throw TypeError(`Custom op ${e.op} is not registered.`);default:throw TypeError(`Unknown op '${e.op}'. File an issue at https://github.com/tensorflow/tfjs/issues so we can add it, or register a custom execution with tf.registerOp()`)}})(e,t,n);return G(r)?r.then((e=>[].concat(e))):[].concat(r)}class jw{constructor(e={},t={},n={},s={}){this.weightMap=e,this.tensorArrayMap=t,this.tensorListMap=n,this.functionMap=s,this.rootContext={id:0,frameName:"",iterationId:0},this.contexts=[this.rootContext],this.lastId=0,this.generateCurrentContextIds()}newFrame(e,t){return{id:e,frameName:t,iterationId:0}}set currentContext(e){this.contexts!==e&&(this.contexts=e,this.generateCurrentContextIds())}get currentContext(){return this.contexts}get currentContextId(){return this._currentContextIds[0]}get currentContextIds(){return this._currentContextIds}generateCurrentContextIds(){const e=[];for(let t=0;t<this.contexts.length-1;t++){const n=this.contexts.slice(0,this.contexts.length-t);e.push(this.contextIdforContexts(n))}e.push(""),this._currentContextIds=e}contextIdforContexts(e){return e?e.map((e=>0===e.id&&0===e.iterationId?"":`${e.frameName}-${e.iterationId}`)).join("/"):""}enterFrame(e){this.contexts&&(this.lastId++,this.contexts=this.contexts.slice(),this.contexts.push(this.newFrame(this.lastId,e)),this._currentContextIds.unshift(this.contextIdforContexts(this.contexts)))}exitFrame(){if(!(this.contexts&&this.contexts.length>1))throw new Error("Cannot exit frame, the context is empty");this.contexts=this.contexts.slice(),this.contexts.splice(-1),this.currentContextIds.shift()}nextIteration(){if(!(this.contexts&&this.contexts.length>0))throw new Error("Cannot increase frame iteration, the context is empty");{this.contexts=this.contexts.slice(),this.lastId++;const e=Object.assign({},this.contexts[this.contexts.length-1]);e.iterationId+=1,e.id=this.lastId,this.contexts.splice(-1,1,e),this._currentContextIds.splice(0,1,this.contextIdforContexts(this.contexts))}}getWeight(e){return this.weightMap[e]}addTensorArray(e){this.tensorArrayMap[e.id]=e}getTensorArray(e){return this.tensorArrayMap[e]}addTensorList(e){this.tensorListMap[e.id]=e}getTensorList(e){return this.tensorListMap[e]}dispose(e){for(const t in this.tensorArrayMap)this.tensorArrayMap[t].clearAndClose(e);for(const t in this.tensorListMap)this.tensorListMap[t].clearAndClose(e)}}function qw(e,t,n,s){const r=new Set,a=[];let i=null,o=null;const l=new Set,u=Object.keys(e).map((e=>Qx(e)[0]));let c=[];null!=s&&(c=s.map((e=>Qx(e.name)[0])));const h=[...t];for(;h.length>0;){const e=h.pop();(Jw(e)||Zw(e)||Qw(e))&&null==i&&(i=e,o=i.children.map((e=>e.name)).filter((e=>r.has(e)))),r.add(e.name),null==n[e.name]&&(-1===u.indexOf(e.name)&&-1===c.indexOf(e.name)&&(0!==e.inputs.length?e.inputs.forEach((e=>{l.has(e.name)||(l.add(e.name),h.push(e))})):a.push(e.name)))}return{inputs:e,outputs:t,usedNodes:r,missingInputs:a,dynamicNode:i,syncInputs:o}}const Kw=["Switch","Merge","Enter","Exit","NextIteration","StatelessIf","StatelessWhile","if","While"],Xw=["NonMaxSuppressionV2","NonMaxSuppressionV3","NonMaxSuppressionV5","Where"],Yw=["HashTable","HashTableV2","LookupTableImport","LookupTableImportV2","LookupTableFind","LookupTableFindV2","LookupTableSize","LookupTableSizeV2"];function Jw(e){return Kw.indexOf(e.op)>=0}function Zw(e){return Xw.indexOf(e.op)>=0}function Qw(e){return Yw.indexOf(e.op)>=0}class ek{constructor(e,t){this.graph=e,this.parent=t,this.compiledMap=new Map,this._weightMap={},this.SEPERATOR=",",this._functions={},this._functionExecutorMap={},this._outputs=e.outputs,this._inputs=e.inputs,this._initNodes=e.initNodes,this._signature=e.signature,this._functions=e.functions,null!=e.functions&&Object.keys(e.functions).forEach((t=>{this._functionExecutorMap[t]=new ek(e.functions[t],this)}))}get weightIds(){return this.parent?this.parent.weightIds:this._weightIds}get functionExecutorMap(){return this.parent?this.parent.functionExecutorMap:this._functionExecutorMap}get weightMap(){return this.parent?this.parent.weightMap:this._weightMap}set weightMap(e){const t=Object.keys(e).map((t=>e[t].map((e=>e.id))));this._weightIds=[].concat(...t),this._weightMap=e}set resourceManager(e){this._resourceManager=e}get inputs(){return this._inputs.map((e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0})))}get outputs(){return this._outputs.map((e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0})))}get inputNodes(){return this._inputs.map((e=>e.signatureKey||e.name))}get outputNodes(){return this._outputs.map((e=>{const t=e.signatureKey||e.name;return e.defaultOutput?`${t}:${e.defaultOutput}`:t}))}get functions(){return Object.keys(this._functions).reduce(((e,t)=>(e[t]=this._functions[t].signature,e)),{})}getCompilationKey(e,t){const n=e.map((e=>e.name)).sort(),s=t.map((e=>e.name)).sort();return n.join(this.SEPERATOR)+"--"+s.join(this.SEPERATOR)}compile(e,t){const n=qw(e,t,this.weightMap,this._initNodes),{missingInputs:s,dynamicNode:r,syncInputs:a}=n;if(null!=r)throw new Error(`This execution contains the node '${r.name}', which has the dynamic op '${r.op}'. Please use model.executeAsync() instead. Alternatively, to avoid the dynamic ops, specify the inputs [${a}]`);if(s.length>0){const n=t.map((e=>e.name)),r=Object.keys(e);throw new Error(`Cannot compute the outputs [${n}] from the provided inputs [${r}]. Missing the following inputs: [${s}]`)}return function(e,t,n){const{usedNodes:s,inputs:r}=n,a=[],i=Object.keys(r).map((e=>Qx(e)[0])).map((t=>e.nodes[t])),o=e.initNodes;i.forEach((e=>{s.has(e.name)&&a.push(e)})),e.weights.forEach((e=>{s.has(e.name)&&a.push(e)})),null!=o&&o.forEach((e=>{s.has(e.name)&&a.push(e)}));const l=new Set,u=[];for(;a.length>0;){const e=a.pop();l.add(e.name),t[e.name]||u.push(e),e.children.forEach((e=>{!l.has(e.name)&&s.has(e.name)&&e.inputs.every((e=>l.has(e.name)))&&a.push(e)}))}return u}(this.graph,this.weightMap,n)}execute(e,t){e=this.mapInputs(e);const n=Object.keys(e).sort();this.checkInputs(e),this.checkInputShapeAndType(e),t=this.mapOutputs(t),this.checkOutputs(t);const s=n.map((e=>this.graph.nodes[Qx(e)[0]])),r=t.map((e=>Qx(e)[0]));let a=r.map((e=>this.graph.nodes[e]));0===a.length&&(a=this._outputs);const i=this.getCompilationKey(s,a);let o=this.compiledMap.get(i);null==o&&(o=this.compile(e,a),this.compiledMap.set(i,o));const l={},u={};return ii((()=>{const n=new jw(this.weightMap,l,u,this.functionExecutorMap),s=Object.assign({},this.weightMap);Object.keys(e).forEach((t=>{const[n,r]=Qx(t),a=[];a[r]=e[t],s[n]=a}));const a=this.getFrozenTensorIds(s),i={};for(let e=0;e<o.length;e++){const t=o[e];if(!s[t.name]){const e=Hw(t,s,n,this._resourceManager);if(G(e))throw new Error(`The execution of the op '${t.op}' returned a promise. Please use model.executeAsync() instead.`);s[t.name]=e,this.checkTensorForDisposal(t.name,t,s,n,a,r,i)}}return null==this.parent&&n.dispose(a),t.map((e=>Yx(e,s,n)))}))}getFrozenTensorIds(e){const t=[].concat.apply([],Object.keys(e).map((t=>e[t])).map((e=>e.map((e=>e.id)))));return new Set(t)}checkTensorForDisposal(e,t,n,s,r,a,i){"control"!==t.category&&-1===a.indexOf(e)&&(n[e].forEach((e=>{null!=e&&(i[e.id]=(i[e.id]||0)+t.children.length)})),t.inputs.forEach((e=>{if("control"!==e.category){const t=function(e,t,n){return t[Zx(e,n.currentContextId)]}(e.name,n,s);null!=t&&t.forEach((e=>{if(e&&!e.kept&&!r.has(e.id)){const t=i[e.id];1===t?(e.dispose(),delete i[e.id]):null!=t&&i[e.id]--}}))}})))}async executeAsync(e,t){return this._executeAsync(e,t)}async _executeAsync(e,t,n=!1,s={},r={}){n||(e=this.mapInputs(e),this.checkInputs(e),this.checkInputShapeAndType(e),t=this.mapOutputs(t),this.checkOutputs(t));const a=new jw(this.weightMap,s,r,this.functionExecutorMap),i=await this.executeWithControlFlow(e,a,t,n),o=t.map((e=>Yx(e,i,a))),l=o.map((e=>e.id)),u=Object.keys(e).map((t=>e[t].id)),c=new Set([...l,...u,...this.weightIds]);return Object.keys(i).forEach((e=>{i[e].forEach((e=>{!e||e.kept||e.isDisposed||c.has(e.id)||e.dispose()}))})),null==this.parent&&a.dispose(c),o}async executeFunctionAsync(e,t,n){const s=e.reduce(((e,t,n)=>(e[this.inputs[n].name]=t,e)),{});return this._executeAsync(s,this.outputNodes,!0,t,n)}async executeWithControlFlow(e,t,n,s){const r=Object.keys(e),a=r.map((e=>this.graph.nodes[Qx(e)[0]])),i=n.map((e=>Qx(e)[0]));let o=i.map((e=>this.graph.nodes[e]));0===o.length&&(o=this._outputs);const{usedNodes:l,missingInputs:u,dynamicNode:c,syncInputs:h}=qw(e,o,this.weightMap,this._initNodes),p=[...a,...this.graph.weights,...this._initNodes||[]].map((e=>({node:e,contexts:t.currentContext}))),d=Object.assign({},this.weightMap);Object.keys(e).forEach((t=>{const[n,s]=Qx(t),r=[];r[s]=e[t],d[n]=r}));const f={},m=this.getFrozenTensorIds(d),g={};for(;p.length>0;){const e=this.processStack(a,p,t,d,g,m,i,f,l);await Promise.all(e)}null!=c||s||console.warn("This model execution did not contain any nodes with control flow or dynamic output shapes. You can use model.execute() instead.");const y=o.filter((e=>!Jw(e)&&!Yx(e.name,d,t))).map((e=>e.name));if(y.length>0){let e="";throw null!=c&&(e=`Alternatively, to avoid the dynamic ops, use model.execute() and specify the inputs [${h}]`),new Error(`Cannot compute the outputs [${y}] from the provided inputs [${r}]. Consider providing the following inputs: [${u}]. ${e}`)}return d}processStack(e,t,n,s,r,a,i,o,l){const u=[];for(;t.length>0;){const e=t.pop();n.currentContext=e.contexts;let c="";if("Enter"===e.node.op&&Xx("isConstant",e.node,s,n)&&([c]=Jx(e.node.name,n)),null==s[e.node.name]){const h=Hw(e.node,s,n,this._resourceManager);c||([c]=Jx(e.node.name,n));const p=n.currentContext;G(h)?u.push(h.then((u=>(s[c]=u,n.currentContext=p,this.checkTensorForDisposal(c,e.node,s,n,a,i,o),this.processChildNodes(e.node,t,n,s,r,l),u)))):(s[c]=h,this.checkTensorForDisposal(c,e.node,s,n,a,i,o),this.processChildNodes(e.node,t,n,s,r,l))}else this.processChildNodes(e.node,t,n,s,r,l)}return u}processChildNodes(e,t,n,s,r,a){e.children.forEach((e=>{const[i]=Jx(e.name,n);!r[i]&&a.has(e.name)&&("Merge"===e.op?e.inputNames.some((e=>!!Yx(e,s,n)))&&(r[i]=!0,t.push({contexts:n.currentContext,node:e})):e.inputNames.every((e=>!!Yx(e,s,n)))&&(r[i]=!0,t.push({contexts:n.currentContext,node:e})))}))}dispose(){Object.keys(this.weightMap).forEach((e=>this.weightMap[e].forEach((e=>e.dispose()))))}checkInputShapeAndType(e){Object.keys(e).forEach((t=>{const n=e[t],[s]=Qx(t),r=this.graph.nodes[s];if(r.attrParams.shape&&r.attrParams.shape.value){const e=r.attrParams.shape.value;l(e.length===n.shape.length&&n.shape.every(((t,n)=>-1===e[n]||e[n]===t)),(()=>`The shape of dict['${r.name}'] provided in model.execute(dict) must be [${e}], but was [${n.shape}]`))}r.attrParams.dtype&&r.attrParams.dtype.value&&l(n.dtype===r.attrParams.dtype.value,(()=>`The dtype of dict['${r.name}'] provided in model.execute(dict) must be ${r.attrParams.dtype.value}, but was ${n.dtype}`))}))}mapInputs(e){const t={};for(const n in e)if(null!=this._signature&&null!=this._signature.inputs&&null!=this._signature.inputs[n]){t[this._signature.inputs[n].name]=e[n]}else t[n]=e[n];return t}checkInputs(e){const t=Object.keys(e).filter((e=>{const[t]=Qx(e);return null==this.graph.nodes[t]}));if(t.length>0)throw new Error(`The dict provided in model.execute(dict) has keys: [${t}] that are not part of graph`)}mapOutputs(e){return e.map((e=>{if(null!=this._signature&&null!=this._signature.outputs&&null!=this._signature.outputs[e]){return this._signature.outputs[e].name}return e}),{})}checkOutputs(e){e.forEach((e=>{const[t]=Qx(e);if(!this.graph.nodes[t])throw new Error(`The output '${e}' is not found in the graph`)}))}}class tk{constructor(e={},t={}){this.hashTableNameToHandle=e,this.hashTableMap=t}addHashTable(e,t){this.hashTableNameToHandle[e]=t.handle,this.hashTableMap[t.id]=t}getHashTableHandleByName(e){return this.hashTableNameToHandle[e]}getHashTableById(e){return this.hashTableMap[e]}dispose(){for(const e in this.hashTableMap)this.hashTableMap[e].clearAndClose(),delete this.hashTableMap[e];for(const e in this.hashTableNameToHandle)this.hashTableNameToHandle[e].dispose(),delete this.hashTableNameToHandle[e]}}class nk{constructor(e,t={}){this.modelUrl=e,this.loadOptions=t,this.version="n/a",null==t&&(this.loadOptions={}),this.resourceManager=new tk}get modelVersion(){return this.version}get inputNodes(){return this.executor.inputNodes}get outputNodes(){return this.executor.outputNodes}get inputs(){return this.executor.inputs}get outputs(){return this.executor.outputs}get weights(){return this.executor.weightMap}get metadata(){return this.artifacts.userDefinedMetadata}get modelSignature(){return this.signature}findIOHandler(){const e=this.modelUrl;if(null!=e.load)this.handler=e;else if(null!=this.loadOptions.requestInit)this.handler=ua(e,this.loadOptions);else{const t=xr(e,this.loadOptions);if(0===t.length)t.push(ua(e,this.loadOptions));else if(t.length>1)throw new Error(`Found more than one (${t.length}) load handlers for URL '${[e]}'`);this.handler=t[0]}}async load(){if(this.findIOHandler(),null==this.handler.load)throw new Error("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const e=await this.handler.load();return this.loadSync(e)}loadSync(e){this.artifacts=e;const t=this.artifacts.modelTopology;let n;n=null!=this.artifacts.userDefinedMetadata&&null!=this.artifacts.userDefinedMetadata.signature?this.artifacts.userDefinedMetadata.signature:this.artifacts.signature,this.signature=n,this.version=`${t.versions.producer}.${t.versions.minConsumer}`;const s=ur(this.artifacts.weightData,this.artifacts.weightSpecs);if(this.executor=new ek(xw.Instance.transformGraph(t,this.signature)),this.executor.weightMap=this.convertTensorMapToTensorsMap(s),this.executor.resourceManager=this.resourceManager,null!=e.modelInitializer&&null!=e.modelInitializer.node){const t=xw.Instance.transformGraph(e.modelInitializer);this.initializer=new ek(t),this.initializer.weightMap=this.executor.weightMap,this.initializer.resourceManager=this.resourceManager,this.initializer.executeAsync({},[])}return!0}async save(e,t){if("string"==typeof e){const t=br(e);if(0===t.length)throw new Error(`Cannot find any save handlers for URL '${e}'`);if(t.length>1)throw new Error(`Found more than one (${t.length}) save handlers for URL '${e}'`);e=t[0]}if(null==e.save)throw new Error("GraphModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");return e.save(this.artifacts)}predict(e,t){return this.execute(e,this.outputNodes)}normalizeInputs(e){if(!(e instanceof Is||Array.isArray(e)))return e;if((e=Array.isArray(e)?e:[e]).length!==this.inputNodes.length)throw new Error(`Input tensor count mismatch,the graph model has ${this.inputNodes.length} placeholders, while there are ${e.length} input tensors.`);return this.inputNodes.reduce(((t,n,s)=>(t[n]=e[s],t)),{})}normalizeOutputs(e){return e=e||this.outputNodes,Array.isArray(e)?e:[e]}execute(e,t){e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=this.executor.execute(e,t);return n.length>1?n:n[0]}async executeAsync(e,t){e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=await this.executor.executeAsync(e,t);return n.length>1?n:n[0]}convertTensorMapToTensorsMap(e){return Object.keys(e).reduce(((t,n)=>(t[n]=[e[n]],t)),{})}dispose(){this.executor.dispose(),this.initializer&&this.initializer.dispose(),this.resourceManager.dispose()}}const sk="3.6.0";function rk(e,t,n=new Map,s=new Set){if(null==e)return null;if(s.has(e))throw new Error("Circular references are not supported.");if(n.has(e))return n.get(e);const r=t(e);if(r.recurse&&null!==r.value)throw new Error("A deep map function may not return both a value and recurse=true.");if(r.recurse){if(uk(e)){const r=Array.isArray(e)?[]:{};s.add(e);for(const a in e){const i=rk(e[a],t,n,s);r[a]=i}return s.delete(e),r}throw new Error(`Can't recurse into non-iterable type: ${e}`)}return n.set(e,r.value),r.value}function ak(e,t=ok){return ik(e,t)}function ik(e,t,n=new Set){const s=e[0];if(n.has(s))throw new Error("Circular references are not supported.");const r=t(e);if(r.recurse&&null!==r.value)throw new Error("A deep zip function may not return both a value and recurse=true.");if(r.recurse){if(uk(s)){const r=Array.isArray(s)?[]:{};n.add(s);for(const a in s){const s=ik(e.map((e=>e[a])),t,n);r[a]=s}return n.delete(s),r}throw new Error(`Can't recurse into non-iterable type: ${s}`)}return r.value}function ok(e){return null===e?null:uk(e[0])?{value:null,recurse:!0}:{value:e,recurse:!1}}async function lk(e,t){const n=new Map;rk(e,t,n);for(const e of Array.from(n.keys())){const t=n.get(e);if(G(t)){const s=await t;n.set(e,s)}}return rk(e,t,n)}function uk(e){return null!=e&&!ArrayBuffer.isView(e)&&(Array.isArray(e)||"object"==typeof e&&!(e instanceof Is))}function ck(e){return function(e,t){return rk(e,t)}(e,hk)}function hk(e){return e instanceof Is?{value:e.clone(),recurse:!1}:uk(e)?{value:null,recurse:!0}:{value:e,recurse:!1}}class pk{constructor(e){if(this.capacity=e,this.begin=0,this.end=0,null==e)throw new RangeError("Can't create a ring buffer of unknown capacity.");if(e<1)throw new RangeError("Can't create ring buffer of capacity < 1.");this.data=new Array(e),this.doubledCapacity=2*e}wrap(e){for(;e<0;)e+=this.doubledCapacity;return e%this.doubledCapacity}get(e){if(e<0)throw new RangeError("Can't get item at a negative index.");return this.data[e%this.capacity]}set(e,t){if(e<0)throw new RangeError("Can't set item at a negative index.");this.data[e%this.capacity]=t}length(){let e=this.end-this.begin;return e<0&&(e=this.doubledCapacity+e),e}isFull(){return this.length()===this.capacity}isEmpty(){return 0===this.length()}push(e){if(this.isFull())throw new RangeError("Ring buffer is full.");this.set(this.end,e),this.end=this.wrap(this.end+1)}pushAll(e){for(const t of e)this.push(t)}pop(){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");this.end=this.wrap(this.end-1);const e=this.get(this.end);return this.set(this.end,void 0),e}unshift(e){if(this.isFull())throw new RangeError("Ring buffer is full.");this.begin=this.wrap(this.begin-1),this.set(this.begin,e)}shift(){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");const e=this.get(this.begin);return this.set(this.begin,void 0),this.begin=this.wrap(this.begin+1),e}shuffleExcise(e){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");const t=this.wrap(this.begin+e),n=this.get(t);return this.set(t,this.pop()),n}}class dk extends pk{constructor(){super(dk.INITIAL_CAPACITY)}isFull(){return!1}push(e){super.isFull()&&this.expand(),super.push(e)}unshift(e){super.isFull()&&this.expand(),super.unshift(e)}expand(){const e=2*this.capacity,t=new Array(e),n=this.length();for(let e=0;e<n;e++)t[e]=this.get(this.wrap(this.begin+e));this.data=t,this.capacity=e,this.doubledCapacity=2*this.capacity,this.begin=0,this.end=n}}function fk(e){return new bk(e)}function mk(e){return new xk(e)}function gk(e,t){return new Ak(e,t)}dk.INITIAL_CAPACITY=32;class yk{async toArray(){const e=[];let t=await this.next();for(;!t.done;)e.push(t.value),t=await this.next();return e}async toArrayForTest(){const e=this.prefetch(100),t=[];let n=await e.next();for(;!n.done;)t.push(n.value),n=await e.next();return t}async resolveFully(){let e=await this.next();for(;!e.done;)e=await this.next()}async resolveWhile(e){let t=await this.next(),n=e(t.value);for(;!t.done&&n;)t=await this.next(),n=e(t.value)}handleErrors(e){return new Ck(this,e)}filter(e){return new Ik(this,e)}map(e){return new $k(this,e)}mapAsync(e){return new Sk(this,e)}serialMapAsync(e){return new Sk(this,e).serial()}flatmap(e){return new Ek(this,e)}async forEachAsync(e){return this.map(e).resolveFully()}async serialForEach(e){return this.serialMapAsync(e).resolveWhile((e=>!0===e))}rowMajorBatch(e,t=!0){return new Nk(this,e,t)}columnMajorBatch(e,t=!0,n=ok){return this.rowMajorBatch(e,t).map((e=>ak(e,n)))}concatenate(e,t){return new Ak(fk([this,e]),t)}take(e){return e<0||null==e?this:new vk(this,e)}skip(e){return e<0||null==e?this:new kk(this,e)}prefetch(e){return new Dk(this,e)}shuffle(e,t){return new _k(this,e,t)}serial(){return new wk(this)}}class bk extends yk{constructor(e){super(),this.items=e,this.trav=0}summary(){return`Array of ${this.items.length} items`}async next(){if(this.trav>=this.items.length)return{value:null,done:!0};const e=this.items[this.trav];return this.trav++,{value:ck(e),done:!1}}}class xk extends yk{constructor(e){super(),this.nextFn=e}summary(){return"Function call"}async next(){try{return this.nextFn()}catch(e){throw e.message=`Error thrown while iterating through a dataset: ${e.message}`,e}}}class wk extends yk{constructor(e){super(),this.upstream=e,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> Serial`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){return this.upstream.next()}}class kk extends yk{constructor(e,t){super(),this.upstream=e,this.maxCount=t,this.count=0,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> Skip`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){for(;this.count++<this.maxCount;){const e=await this.upstream.next();if(e.done)return e;oi(e.value)}return this.upstream.next()}}class vk extends yk{constructor(e,t){super(),this.upstream=e,this.maxCount=t,this.count=0}summary(){return`${this.upstream.summary()} -> Take`}async next(){return this.count++>=this.maxCount?{value:null,done:!0}:this.upstream.next()}}class Nk extends yk{constructor(e,t,n=!0){super(),this.upstream=e,this.batchSize=t,this.enableSmallLastBatch=n,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> RowMajorBatch`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){const e=[];for(;e.length<this.batchSize;){const t=await this.upstream.next();if(t.done)return this.enableSmallLastBatch&&e.length>0?{value:e,done:!1}:{value:null,done:!0};e.push(t.value)}return{value:e,done:!1}}}class Ik extends yk{constructor(e,t){super(),this.upstream=e,this.predicate=t,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> Filter`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){for(;;){const e=await this.upstream.next();if(e.done||this.predicate(e.value))return e;oi(e.value)}}}class $k extends yk{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return`${this.upstream.summary()} -> Map`}async next(){const e=await this.upstream.next();if(e.done)return{value:null,done:!0};const t=zs(e.value),n=this.transform(e.value),s=zs(n);for(const e of t)Ls(e,s)||e.dispose();return{value:n,done:!1}}}class Ck extends yk{constructor(e,t){super(),this.upstream=e,this.handler=t,this.count=0,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> handleErrors`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){for(;;)try{return await this.upstream.next()}catch(e){if(!this.handler(e))return{value:null,done:!0}}}}class Sk extends yk{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return`${this.upstream.summary()} -> AsyncMap`}async next(){const e=await this.upstream.next();if(e.done)return{value:null,done:!0};const t=zs(e.value),n=await this.transform(e.value),s=zs(n);for(const e of t)Ls(e,s)||e.dispose();return{value:n,done:!1}}}class Tk extends yk{constructor(){super(),this.outputQueue=new dk,this.lastRead=Promise.resolve({value:null,done:!1})}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){for(;0===this.outputQueue.length();)if(!await this.pump())return{value:null,done:!0};return{value:this.outputQueue.shift(),done:!1}}}class Ek extends Tk{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return`${this.upstream.summary()} -> Flatmap`}async pump(){const e=await this.upstream.next();if(e.done)return!1;const t=zs(e.value),n=this.transform(e.value),s=zs(n);this.outputQueue.pushAll(n);for(const e of t)Ls(e,s)||e.dispose();return!0}}class Ak extends yk{constructor(e,t){super(),this.baseErrorHandler=t,this.lastRead=null,this.iterator=null,this.moreIterators=e}summary(){return"TODO: fill in upstream of chained summaries -> Chained"}async next(){return this.lastRead=this.readFromChain(this.lastRead),this.lastRead}async readFromChain(e){if(await e,null==this.iterator){const e=await this.moreIterators.next();if(e.done)return{value:null,done:!0};this.iterator=e.value,null!=this.baseErrorHandler&&(this.iterator=this.iterator.handleErrors(this.baseErrorHandler))}const t=await this.iterator.next();return t.done?(this.iterator=null,this.readFromChain(e)):t}}var Rk;!function(e){e[e.FAIL=0]="FAIL",e[e.SHORTEST=1]="SHORTEST",e[e.LONGEST=2]="LONGEST"}(Rk||(Rk={}));class Fk extends yk{constructor(e,t=Rk.FAIL){super(),this.iterators=e,this.mismatchMode=t,this.count=0,this.currentPromise=null}summary(){return"{TODO: fill in upstream of zip summaries} -> Zip"}async nextState(e){await e;let t=0,n=0;const s=await lk(this.iterators,(function(e){if(e instanceof yk){return{value:e.next().then((e=>(t++,e.done&&n++,e.value))),recurse:!1}}return{value:null,recurse:!0}}));if(t===n)return{value:null,done:!0};if(n>0)switch(this.mismatchMode){case Rk.FAIL:throw new Error(`Zipped streams should have the same length. Mismatched at element ${this.count}.`);case Rk.SHORTEST:return{value:null,done:!0};case Rk.LONGEST:}return this.count++,{value:s,done:!1}}async next(){return this.currentPromise=this.nextState(this.currentPromise),this.currentPromise}}class Dk extends yk{constructor(e,t){super(),this.upstream=e,this.bufferSize=t,this.buffer=new pk(t)}summary(){return`${this.upstream.summary()} -> Prefetch`}refill(){for(;!this.buffer.isFull();){const e=this.upstream.next();this.buffer.push(e)}}next(){return this.refill(),this.buffer.shift()}}class _k extends Dk{constructor(e,t,n){super(e,t),this.upstream=e,this.windowSize=t,this.upstreamExhausted=!1,this.random=uu(n||os().toString()),this.lastRead=Promise.resolve({value:null,done:!1})}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}randomInt(e){return Math.floor(this.random()*e)}chooseIndex(){return this.randomInt(this.buffer.length())}async serialNext(){for(this.upstreamExhausted||this.refill();!this.buffer.isEmpty();){const e=this.chooseIndex(),t=await this.buffer.shuffleExcise(e);if(!t.done)return this.refill(),t;this.upstreamExhausted=!0}return{value:null,done:!0}}}class Ok{constructor(){this.size=null}batch(e,t=!0){const n=this;let s;return l(e>0,(()=>`batchSize needs to be positive, but it is\n      ${e}`)),s=this.size===1/0||null==this.size?this.size:t?Math.ceil(this.size/e):Math.floor(this.size/e),Mk((async()=>(await n.iterator()).columnMajorBatch(e,t,Lk)),s)}concatenate(e){const t=this;let n;return n=this.size===1/0||e.size===1/0?1/0:null!=this.size&&null!=e.size?this.size+e.size:null,Mk((async()=>(await t.iterator()).concatenate(await e.iterator())),n)}filter(e){const t=this;let n;return n=this.size===1/0?1/0:null,Mk((async()=>(await t.iterator()).filter((t=>ii((()=>e(t)))))),n)}async forEachAsync(e){return(await this.iterator()).forEachAsync(e)}map(e){const t=this;return Mk((async()=>(await t.iterator()).map((t=>ii((()=>e(t)))))),this.size)}mapAsync(e){const t=this;return Mk((async()=>(await t.iterator()).mapAsync(e)),this.size)}prefetch(e){if(null==e)throw new RangeError("`Dataset.prefetch()` requires bufferSize to be specified.");const t=this;return Mk((async()=>(await t.iterator()).prefetch(e)),this.size)}repeat(e){const t=this;let n;return n=null!=this.size&&e>0?this.size*e:0===e?0:null!=this.size&&(void 0===e||e<0)?1/0:null,Mk((async()=>gk(mk((async()=>({value:await t.iterator(),done:!1}))).take(e))),n)}skip(e){const t=this;let n;return n=null!=this.size&&e>=0&&this.size>=e?this.size-e:null!=this.size&&(this.size<e||void 0===e||e<0)?0:null,Mk((async()=>(await t.iterator()).skip(e)),n)}shuffle(e,t,n=!0){if(null==e||e<0)throw null==this.size?new RangeError("`Dataset.shuffle()` requires bufferSize to be specified."):new RangeError(`\`Dataset.shuffle()\` requires bufferSize to be specified.  If your data fits in main memory (for regular JS objects), and/or GPU memory (for \`tf.Tensor\`s), consider setting bufferSize to the dataset size (${this.size} elements)`);const s=this,r=uu(t||os().toString());return Mk((async()=>{let t=r.int32();return n&&(t+=r.int32()),(await s.iterator()).shuffle(e,t.toString())}),this.size)}take(e){const t=this;let n;return n=null!=this.size&&this.size>e?e:null!=this.size&&this.size<=e?this.size:null,Mk((async()=>(await t.iterator()).take(e)),n)}async toArray(){if(this.size===1/0)throw new Error("Can not convert infinite data stream to array.");return(await this.iterator()).toArray()}async toArrayForTest(){if(this.size===1/0)throw new Error("Can not convert infinite data stream to array.");return(await this.iterator()).toArrayForTest()}}function Mk(e,t=null){return new class extends Ok{constructor(){super(...arguments),this.size=t}async iterator(){return e()}}}function Lk(e){if(null===e)return null;const t=e[0];if(null==(n=t)||null===(s=n)||"object"!=typeof s&&"function"!=typeof s||Array.isArray(n)||"object"==typeof n&&n instanceof Is||C(n)){return{value:function(e){if(0===e.length)throw new Error("Can't make a batch of zero elements.");return e[0]instanceof Is?Ku(e):ir(e)}(e),recurse:!1}}var n,s;return{value:null,recurse:!0}}Ok.MAX_BUFFER_SIZE=1e4;class zk extends Ok{constructor(e){super(),this.input=e}async iterator(){return(await this.input.iterator()).decodeUTF8().split("\n").map((e=>(e.endsWith("\r")&&(e=e.slice(0,-1)),e)))}}const Bk='"',Pk=Symbol("out"),Wk=Symbol("field"),Vk=Symbol("quote"),Uk=Symbol("quoteafterquote"),Gk=Symbol("quoteinquote");class Hk extends Ok{constructor(e,t){super(),this.input=e,this.hasHeader=!0,this.fullColumnNames=null,this.columnNamesValidated=!1,this.columnConfigs=null,this.configuredColumnsOnly=!1,this.delimiter=",",this.delimWhitespace=!1,this.base=new zk(e),t||(t={}),this.hasHeader=!1!==t.hasHeader,this.fullColumnNames=t.columnNames,this.columnConfigs=t.columnConfigs,this.configuredColumnsOnly=t.configuredColumnsOnly,t.delimWhitespace?(l(null==t.delimiter,(()=>"Delimiter should not be provided when delimWhitespace is true.")),this.delimWhitespace=!0,this.delimiter=" "):this.delimiter=t.delimiter?t.delimiter:","}async columnNames(){return this.columnNamesValidated||await this.setColumnNames(),this.configuredColumnsOnly?Object.keys(this.columnConfigs):this.fullColumnNames}async setColumnNames(){const e=await this.maybeReadHeaderLine();if(!this.fullColumnNames&&!e)throw new Error("Column names must be provided if there is no header line.");this.fullColumnNames&&e&&l(e.length===this.fullColumnNames.length,(()=>"The length of provided columnNames ("+this.fullColumnNames.length.toString()+") does not match the length of the header line read from file ("+e.length.toString()+").")),this.fullColumnNames||(this.fullColumnNames=e);const t=this.fullColumnNames.reduce(((e,t)=>(e[t]=e[t]+1||1,e)),{}),n=Object.keys(t).filter((e=>t[e]>1));if(l(0===n.length,(()=>"Duplicate column names found: "+n.toString())),this.columnConfigs)for(const e of Object.keys(this.columnConfigs)){if(-1===this.fullColumnNames.indexOf(e))throw new Error('The key "'+e+'" provided in columnConfigs does not match any of the column names ('+this.fullColumnNames.toString()+").")}this.columnNamesValidated=!0}async maybeReadHeaderLine(){if(this.hasHeader){const e=await this.base.iterator(),t=await e.next();if(t.done)throw new Error("No data was found for CSV parsing.");const n=t.value;return this.parseRow(n,!1)}return null}async iterator(){this.columnNamesValidated||await this.setColumnNames();let e=await this.base.iterator();return this.hasHeader&&(e=e.skip(1)),e.map((e=>this.makeDataElement(e)))}makeDataElement(e){const t=this.parseRow(e),n={},s={};for(let r=0;r<this.fullColumnNames.length;r++){const a=this.fullColumnNames[r],i=this.columnConfigs?this.columnConfigs[a]:null;if(!this.configuredColumnsOnly||i){const o=t[r];let l=null;if(""===o)if(i&&void 0!==i.default)l=i.default;else{if(i&&(i.required||i.isLabel))throw new Error(`Required column ${a} is empty in this line: ${e}`);l=void 0}else{const e=Number(o);if(isNaN(e))l=i&&"bool"===i.dtype?this.getBoolean(o):o;else if(i&&i.dtype)switch(i.dtype){case"float32":l=e;break;case"int32":l=Math.floor(e);break;case"bool":l=this.getBoolean(o);break;default:l=e}else l=e}i&&i.isLabel?s[a]=l:n[a]=l}}return 0===Object.keys(s).length?n:{xs:n,ys:s}}getBoolean(e){return"1"===e||"true"===e.toLowerCase()?1:0}parseRow(e,t=!0){const n=[];let s=0;const r=e.length;let a=Pk;for(let t=0;t<r;t++)switch(a){case Pk:switch(e.charAt(t)){case Bk:s=t+1,a=Vk;break;case this.delimiter:if(s=t+1," "===this.delimiter&&this.delimWhitespace)break;n.push(""),a=Pk;break;default:a=Wk,s=t}break;case Wk:switch(e.charAt(t)){case this.delimiter:n.push(e.substring(s,t)),a=Pk,s=t+1}break;case Vk:switch(e.charAt(t)){case Bk:a=Uk}break;case Uk:switch(e.charAt(t)){case this.delimiter:n.push(e.substring(s,t-1)),a=Pk,s=t+1;break;case Bk:a=Vk;break;default:a=Gk}break;case Gk:switch(e.charAt(t)){case Bk:a=Vk}}if(a===Uk?n.push(e.substring(s,r-1)):n.push(e.substring(s)),t&&n.length!==this.fullColumnNames.length)throw new Error(`Invalid row in csv file. Should have ${this.fullColumnNames.length} elements in a row, but got ${n}`);return n}}class jk extends yk{constructor(e){super(),this.microphoneConfig=e,this.isClosed=!1,this.fftSize=e.fftSize||1024;const t=Math.log2(this.fftSize);if(this.fftSize<0||t<4||t>14||!Number.isInteger(t))throw new Error(`Invalid fftSize: it must be a power of 2 between 2 to 4 and 2 to 14, but got ${this.fftSize}`);if(this.numFrames=e.numFramesPerSpectrogram||43,this.sampleRateHz=e.sampleRateHz,this.columnTruncateLength=e.columnTruncateLength||this.fftSize,this.audioTrackConstraints=e.audioTrackConstraints,this.smoothingTimeConstant=e.smoothingTimeConstant||0,this.includeSpectrogram=!1!==e.includeSpectrogram,this.includeWaveform=!0===e.includeWaveform,!this.includeSpectrogram&&!this.includeWaveform)throw new Error("Both includeSpectrogram and includeWaveform are false. At least one type of data should be returned.")}summary(){return"microphone"}static async create(e={}){if(K().get("IS_NODE"))throw new Error("microphone API is only supported in browser environment.");const t=new jk(e);return await t.start(),t}async start(){try{this.stream=await navigator.mediaDevices.getUserMedia({audio:null==this.audioTrackConstraints||this.audioTrackConstraints,video:!1})}catch(e){throw new Error(`Error thrown while initializing video stream: ${e.message}`)}if(!this.stream)throw new Error("Could not obtain audio from microphone.");const e=window.AudioContext||window.webkitAudioContext;if(this.audioContext=new e,this.sampleRateHz){if(this.audioContext.sampleRate!==this.sampleRateHz)throw new Error(`Mismatch in sampling rate: Expected: ${this.sampleRateHz}; Actual: ${this.audioContext.sampleRate}`)}else this.sampleRateHz=this.audioContext.sampleRate;const t=this.audioContext.createMediaStreamSource(this.stream);this.analyser=this.audioContext.createAnalyser(),this.analyser.fftSize=2*this.fftSize,this.analyser.smoothingTimeConstant=this.smoothingTimeConstant,t.connect(this.analyser),this.freqData=new Float32Array(this.fftSize),this.timeData=new Float32Array(this.fftSize)}async next(){if(this.isClosed)return{value:null,done:!0};let e,t;const n=await this.getAudioData();if(this.includeSpectrogram){const t=this.flattenQueue(n.freqDataQueue);e=this.getTensorFromAudioDataArray(t,[this.numFrames,this.columnTruncateLength,1])}if(this.includeWaveform){const e=this.flattenQueue(n.timeDataQueue);t=this.getTensorFromAudioDataArray(e,[this.numFrames*this.fftSize,1])}return{value:{spectrogram:e,waveform:t},done:!1}}async capture(){return(await this.next()).value}async getAudioData(){const e=[],t=[];let n=0;return new Promise((s=>{const r=setInterval((()=>{this.includeSpectrogram&&(this.analyser.getFloatFrequencyData(this.freqData),this.freqData[0]===-1/0&&s({freqDataQueue:e,timeDataQueue:t}),e.push(this.freqData.slice(0,this.columnTruncateLength))),this.includeWaveform&&(this.analyser.getFloatTimeDomainData(this.timeData),t.push(this.timeData.slice())),++n===this.numFrames&&(clearInterval(r),s({freqDataQueue:e,timeDataQueue:t}))}),this.fftSize/this.sampleRateHz*1e3)}))}stop(){this.isClosed||(this.isClosed=!0,this.analyser.disconnect(),this.audioContext.close(),null!=this.stream&&this.stream.getTracks().length>0&&this.stream.getTracks()[0].stop())}toArray(){throw new Error("Can not convert infinite audio stream to array.")}getSampleRate(){return this.sampleRateHz}flattenQueue(e){const t=e[0].length,n=new Float32Array(e.length*t);return e.forEach(((e,s)=>n.set(e,s*t))),n}getTensorFromAudioDataArray(e,t){const n=new Float32Array(p(t));return n.set(e,n.length-e.length),ir(n,t)}}class qk extends yk{constructor(e,t){if(super(),this.webcamVideoElement=e,this.webcamConfig=t,this.isClosed=!0,this.resize=!1,this.needToResize())if(this.resize=!0,this.cropSize=[this.webcamConfig.resizeHeight,this.webcamConfig.resizeWidth],this.cropBoxInd=Zu([0],"int32"),this.webcamConfig.centerCrop){const e=1*this.webcamConfig.resizeWidth/this.webcamVideoElement.width,t=1*this.webcamConfig.resizeHeight/this.webcamVideoElement.height,n=(1-e)/2,s=(1-t)/2,r=n+e,a=t+s;this.cropBox=Qu([s,n,a,r],[1,4])}else this.cropBox=Qu([0,0,1,1],[1,4])}summary(){return"webcam"}static async create(e,t={}){if(K().get("IS_NODE"))throw new Error("tf.data.webcam is only supported in browser environment.");if(!e){if(e=document.createElement("video"),!t.resizeWidth||!t.resizeHeight)throw new Error("Please provide webcam video element, or resizeWidth and resizeHeight to create a hidden video element.");e.width=t.resizeWidth,e.height=t.resizeHeight}const n=new qk(e,t);return await n.start(),n}async start(){this.webcamConfig.facingMode&&l("user"===this.webcamConfig.facingMode||"environment"===this.webcamConfig.facingMode,(()=>`Invalid webcam facing mode: ${this.webcamConfig.facingMode}. Please provide 'user' or 'environment'`));try{this.stream=await navigator.mediaDevices.getUserMedia({video:{deviceId:this.webcamConfig.deviceId,facingMode:this.webcamConfig.facingMode?this.webcamConfig.facingMode:"user",width:this.webcamVideoElement.width,height:this.webcamVideoElement.height}})}catch(e){throw e.message=`Error thrown while initializing video stream: ${e.message}`,e}if(!this.stream)throw new Error("Could not obtain video from webcam.");try{this.webcamVideoElement.srcObject=this.stream}catch(e){console.log(e),this.webcamVideoElement.src=window.URL.createObjectURL(this.stream)}return this.webcamVideoElement.play(),this.isClosed=!1,new Promise((e=>{this.webcamVideoElement.onloadedmetadata=()=>{e()}}))}async next(){if(this.isClosed)return{value:null,done:!0};let e;try{e=va(this.webcamVideoElement)}catch(e){throw new Error(`Error thrown converting video to pixels: ${JSON.stringify(e)}`)}if(!this.resize)return{value:e,done:!1};try{return{value:this.cropAndResizeFrame(e),done:!1}}catch(e){throw new Error(`Error thrown cropping the video: ${e.message}`)}finally{e.dispose()}}needToResize(){return!(!this.webcamConfig.resizeWidth||!this.webcamConfig.resizeHeight||this.webcamVideoElement.width===this.webcamConfig.resizeWidth&&this.webcamVideoElement.height===this.webcamConfig.resizeHeight)}cropAndResizeFrame(e){return ii((()=>{const t=Lo(Xr(e,"float32"),0);let n;n=kh.cropAndResize(t,this.cropBox,this.cropBoxInd,this.cropSize,"bilinear");const s=n.shape;return Vi(n,s.slice(1))}))}async capture(){return(await this.next()).value}stop(){this.stream.getTracks().forEach((e=>e.stop()));try{this.webcamVideoElement.srcObject=null}catch(e){console.log(e),this.webcamVideoElement.src=null}this.isClosed=!0}toArray(){throw new Error("Can not convert infinite video stream to array.")}}class Kk{}class Xk extends yk{split(e){return new Yk(this,e)}}class Yk extends Xk{constructor(e,t){super(),this.upstream=e,this.impl=new Jk(e,t)}summary(){return this.impl.summary()}async next(){return this.impl.next()}}class Jk extends Tk{constructor(e,t){super(),this.upstream=e,this.separator=t,this.carryover=""}summary(){return`${this.upstream.summary()} -> Split('${this.separator}')`}async pump(){const e=await this.upstream.next();if(e.done)return""!==this.carryover&&(this.outputQueue.push(this.carryover),this.carryover="",!0);const t=e.value.split(this.separator);t[0]=this.carryover+t[0];for(const e of t.slice(0,-1))this.outputQueue.push(e);return this.carryover=t[t.length-1],!0}}class Zk extends yk{decodeUTF8(){return new Qk(this)}}class Qk extends Xk{constructor(e){super(),this.upstream=e,this.impl=new ev(e)}summary(){return this.impl.summary()}async next(){return this.impl.next()}}class ev extends Tk{constructor(e){if(super(),this.upstream=e,K().get("IS_BROWSER"))this.decoder=new TextDecoder("utf-8");else{const{StringDecoder:e}=require("string_decoder");this.decoder=new e("utf8")}}summary(){return`${this.upstream.summary()} -> Utf8`}async pump(){const e=await this.upstream.next();let t,n;return!e.done&&(t=e.value,n=K().get("IS_BROWSER")?this.decoder.decode(t,{stream:!0}):this.decoder.write(Buffer.from(t.buffer)),this.outputQueue.push(n),!0)}}class tv extends Zk{constructor(e,t={}){super(),this.file=e,this.options=t,l(e instanceof Uint8Array||!!K().get("IS_BROWSER")&&(e instanceof File||e instanceof Blob),(()=>"FileChunkIterator only supports File, Blob and Uint8Array right now.")),this.offset=t.offset||0,this.chunkSize=t.chunkSize||1048576}summary(){return`FileChunks ${this.file}`}async next(){if(this.offset>=(this.file instanceof Uint8Array?this.file.byteLength:this.file.size))return{value:null,done:!0};const e=new Promise(((e,t)=>{const n=this.offset+this.chunkSize;if(this.file instanceof Uint8Array)e(new Uint8Array(this.file.slice(this.offset,n)));else{const s=new FileReader;s.onload=n=>{let r=s.result;if(r instanceof ArrayBuffer&&(r=new Uint8Array(r)),!(r instanceof Uint8Array))return t(new TypeError("FileReader returned unknown type."));e(r)},s.onabort=e=>t(new Error("Aborted")),s.onerror=e=>t(new Error(e.type));const r=this.file.slice(this.offset,n);s.readAsArrayBuffer(r)}this.offset=n}));return{value:await e,done:!1}}}const nv=e=>({method:e.method,headers:e.headers,body:e.body,mode:e.mode,credentials:e.credentials,cache:e.cache,redirect:e.redirect,referrer:e.referrer,integrity:e.integrity});function sv(e){return"string"==typeof e&&"file://"===e.substr(0,7)}class rv extends Kk{constructor(e,t={}){super(),this.input=e,this.options=t}async iterator(){if(sv(this.input)&&K().get("IS_NODE")){const e=require("fs");this.input=e.readFileSync(this.input.substr(7))}return new tv(this.input,this.options)}}class av extends Kk{constructor(e,t={}){super(),this.url=e,this.fileOptions=t}async iterator(){return sv(this.url)?new rv(this.url,this.fileOptions).iterator():async function(e,t={}){let n,s;"string"==typeof e?n=e:(n=e.url,s=nv(e));const r=await ls(n,s);if(r.ok){const e=new Uint8Array(await r.arrayBuffer());return new tv(e,t)}throw new Error(r.statusText)}(this.url,this.fileOptions)}}const iv="3.6.0";var ov=Object.freeze({__proto__:null,array:function(e){return Mk((async()=>fk(e)),e.length)},Dataset:Ok,zip:function(e){if(!uk(e))throw new Error("The argument to zip() must be an object or array.");let t;if(Array.isArray(e))for(let n=0;n<e.length;n++)t=null==t?e[n].size:Math.min(t,e[n].size);else if(e instanceof Object)for(const n in e)t=null==t?e[n].size:Math.min(t,e[n].size);return Mk((async()=>function(e,t=Rk.FAIL){return new Fk(e,t)}(await lk(e,(e=>{if(e instanceof Ok)return{value:e.iterator(),recurse:!1};if(uk(e))return{value:null,recurse:!0};throw new Error("Leaves of the structure passed to zip() must be Datasets, not primitives.")})),Rk.SHORTEST)),t)},CSVDataset:Hk,TextLineDataset:zk,csv:function(e,t={}){return new Hk(new av(e),t)},func:function(e){const t=mk(e);return Mk((async()=>t))},generator:function(e){return Mk((async()=>{const t=await e();return mk((()=>t.next()))}))},microphone:async function(e){return jk.create(e)},webcam:async function(e,t){return qk.create(e,t)},FileDataSource:rv,URLDataSource:av,version_data:iv});function lv(e,t){Array.isArray(e)||(e=[e]),e.forEach((e=>{null!=e&&l("complex64"!==e.dtype,(()=>`${t} does not support complex64 tensors in the CPU backend.`))}))}const uv=ic;class cv extends n{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new t(this,ri())}nextDataId(){return cv.nextDataId++}write(e,t,n){this.firstUse&&(this.firstUse=!1,K().get("IS_NODE")&&ep("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));const s={id:this.nextDataId()};return this.data.set(s,{values:e,dtype:n,refCount:1}),s}makeTensorInfo(e,t,n){let s;if("string"===t&&null!=n&&n.length>0&&E(n[0])){const r=n.map((e=>us(e)));s=this.write(r,e,t)}else s=this.write(n,e,t);return{dataId:s,shape:e,dtype:t}}refCount(e){if(this.data.has(e)){return this.data.get(e).refCount}return 0}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,n,s,r){this.data.set(e,{values:t,dtype:s,refCount:r})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:t,complexTensorInfos:n}=this.data.get(e);if("complex64"===t){return tp(this.readSync(n.real.dataId),this.readSync(n.imag.dataId))}return this.data.get(e).values}bufferSync(e){const t=this.readSync(e.dataId);let n=t;if("string"===e.dtype)try{n=t.map((e=>cs(e)))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return Kr(e.shape,e.dtype,n)}makeOutput(e,t,n){const s=this.write(e,t,n);return ri().makeTensorFromDataId(s,t,n,this)}disposeData(e,t=!1){if(this.data.has(e)){if(this.data.get(e).refCount--,!t&&this.data.get(e).refCount>0)return!1;const{complexTensorInfos:n}=this.data.get(e);null!=n&&(this.disposeData(n.real.dataId,!0),this.disposeData(n.imag.dataId,!0)),this.data.delete(e)}return!0}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}async time(e){const t=os();e();return{kernelMs:os()-t}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}where(e){lv([e],"where");const t=this.readSync(e.dataId);return uv(e.shape,t)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}}function hv(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t}cv.nextDataId=0;const pv={kernelName:Z,backendName:"cpu",kernelFunc:e=>{const{x:t}=e.inputs,n=e.backend;lv(t,"abs");let s=new Float32Array(p(t.shape));return s=hv(n.data.get(t.dataId).values),n.makeOutput(s,t.shape,"float32")}};function dv(e){return(t,n,s,r,a)=>{const i=So(t,n),o=i.length,l=O(i),u=k(a,p(i)),c=t.length,h=n.length,d=O(t),f=O(n),m=$o(t,i),g=$o(n,i);if(m.length+g.length===0)for(let t=0;t<u.length;++t)u[t]=e(s[t%s.length],r[t%r.length]);else for(let t=0;t<u.length;++t){const n=U(t,o,l),a=n.slice(-c);m.forEach((e=>a[e]=0));const i=V(a,c,d),p=n.slice(-h);g.forEach((e=>p[e]=0));const y=V(p,h,f);u[t]=e(s[i],r[y])}return[u,i]}}function fv(e){const{inputs:t,backend:n}=e,{real:s,imag:r}=t,a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,o=n.makeTensorInfo(s.shape,"complex64");return n.data.get(o.dataId).complexTensorInfos={real:n.makeTensorInfo(s.shape,"float32",a),imag:n.makeTensorInfo(r.shape,"float32",i)},o}const mv={kernelName:Ne,backendName:"cpu",kernelFunc:fv};function gv(e,t,n="float32"){if("complex64"===n){return fv({inputs:{real:gv(e,t,"float32"),imag:gv(e,t,"float32")},backend:e})}const s=B(p(t),n);return e.makeTensorInfo(t,n,s)}function yv(e){const{inputs:t,backend:n}=e,{x:s}=t;return n.incRef(s.dataId),{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}const bv={kernelName:ct,backendName:"cpu",kernelFunc:yv};function xv(e){const{inputs:t,backend:n}=e,{input:s}=t,r=n.data.get(s.dataId).complexTensorInfos.real,a=n.data.get(r.dataId).values;return n.makeTensorInfo(r.shape,r.dtype,a)}const wv={kernelName:tn,backendName:"cpu",kernelFunc:xv};function kv(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dtype:a}=s;if("complex64"===a){if("complex64"===r.dtype)return yv({inputs:{x:r},backend:n});const e=gv(n,r.shape,r.dtype),t=kv({inputs:{x:r},backend:n,attrs:{dtype:"float32"}}),s=fv({inputs:{real:t,imag:e},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),s}if("complex64"===r.dtype){const e=xv({inputs:{input:r},backend:n}),t=kv({inputs:{x:e},backend:n,attrs:{dtype:a}});return n.disposeIntermediateTensorInfo(e),t}if(!$(r.dtype,a)){const e=yv({inputs:{x:r},backend:n});return{dataId:e.dataId,shape:e.shape,dtype:a}}if("int32"===a){const e=n.data.get(r.dataId).values,t=Int32Array.from(e);return n.makeTensorInfo(r.shape,"int32",t)}if("bool"===a){const e=n.data.get(r.dataId).values,t=is([0],r.dtype),[s,a]=dv(((e,t)=>e!==t?1:0))(r.shape,[],e,t,"bool");return n.makeTensorInfo(a,"bool",s)}throw new Error(`Error in Cast: failed to cast ${r.dtype} to ${a}`)}const vv={kernelName:we,backendName:"cpu",kernelFunc:kv};function Nv(e,t,n,s){return null==n?({inputs:n,backend:r})=>{const{a:a,b:i}=n,o=r;lv([a,i],e);const l=o.data.get(a.dataId).values,u=o.data.get(i.dataId).values,c=s||a.dtype,[h,p]=t(a.shape,i.shape,l,u,c);return o.makeTensorInfo(p,c,h)}:({inputs:e,backend:r})=>{const{a:a,b:i}=e,o=r;if("complex64"===a.dtype||"complex64"===i.dtype){const e=kv({inputs:{x:a},backend:o,attrs:{dtype:"complex64"}}),t=o.data.get(e.dataId),s=t.complexTensorInfos.real,r=t.complexTensorInfos.imag,l=o.data.get(s.dataId).values,u=o.data.get(r.dataId).values,c=kv({inputs:{x:i},backend:o,attrs:{dtype:"complex64"}}),h=o.data.get(c.dataId),p=h.complexTensorInfos.real,d=h.complexTensorInfos.imag,f=o.data.get(p.dataId).values,m=o.data.get(d.dataId).values,[g,y,b]=n(a.shape,i.shape,l,u,f,m),x=o.makeTensorInfo(b,"float32",g),w=o.makeTensorInfo(b,"float32",y),k=fv({inputs:{real:x,imag:w},backend:o});return o.disposeIntermediateTensorInfo(e),o.disposeIntermediateTensorInfo(c),o.disposeIntermediateTensorInfo(x),o.disposeIntermediateTensorInfo(w),k}{const e=o.data.get(a.dataId).values,n=o.data.get(i.dataId).values,r=s||a.dtype,[l,u]=t(a.shape,i.shape,e,n,r);return o.makeTensorInfo(u,r,l)}}}function Iv(e){return(t,n,s,r,a,i)=>{const o=So(t,n),l=p(o),u=o.length,c=O(o),h=k("float32",l),d=k("float32",l),f=$o(t,o),m=$o(n,o),g=tp(s,r),y=tp(a,i),b=t.length,x=O(t),w=n.length,v=O(n);if(f.length+m.length===0)for(let t=0;t<h.length;t++){const n=t%g.length,s=t%y.length,r=e(g[2*n],g[2*n+1],y[2*s],y[2*s+1]);h[t]=r.real,d[t]=r.imag}else for(let t=0;t<h.length;t++){const n=U(t,u,c),s=n.slice(-b);f.forEach((e=>s[e]=0));const r=V(s,b,x),a=n.slice(-w);m.forEach((e=>a[e]=0));const i=V(a,w,v),o=e(g[2*r],g[2*r+1],y[2*i],y[2*i+1]);h[t]=o.real,d[t]=o.imag}return[h,d,o]}}const $v=dv(((e,t)=>e+t)),Cv=Iv(((e,t,n,s)=>({real:e+n,imag:t+s}))),Sv=Nv(te,$v,Cv),Tv={kernelName:te,backendName:"cpu",kernelFunc:Sv};function Ev(e,t,n,s,r){const a=p(s),i=B(r,n);for(let n=0;n<e.length;n++){const s=e[n];if(s<0)throw new Error("Input x must be non-negative!");s>=r||(i[s]+=a>0?t[n]:1)}return i}function Av(e,t,n,s=!1){const r=e.shape[0],a=e.shape[1],i=Kr([r,n],t.dtype);for(let o=0;o<r;o++)for(let r=0;r<a;r++){const a=e.get(o,r);if(a<0)throw new Error("Input x must be non-negative!");a>=n||(s?i.set(1,o,a):t.size>0?i.set(i.get(o,a)+t.get(o,r),o,a):i.set(i.get(o,a)+1,o,a))}return i}function Rv(e){return(t,n,s)=>{const r=k(n,t.length);for(let n=0;n<t.length;++n)r[n]=e(t[n],s);return r}}function Fv(e,t,n){return({inputs:s,attrs:r,backend:a})=>{const{x:i}=s;if(lv(i,e),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const o=a,l=o.data.get(i.dataId).values,u=p(i.shape),c=n||i.dtype,h=v(c,u);for(let e=0;e<u;++e)h[e]=t(l[e],r);return o.makeTensorInfo(i.shape,c,h)}}function Dv(e,t,n){return({inputs:s,attrs:r,backend:a})=>{const{x:i}=s;if(lv(i,e),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const o=a,l=o.data.get(i.dataId).values,u=n||i.dtype,c=t(l,u,r);return o.makeTensorInfo(i.shape,u,c)}}const _v=Rv((e=>Math.ceil(e))),Ov=Dv(ke,_v),Mv={kernelName:ke,backendName:"cpu",kernelFunc:Ov};function Lv(e,t,n,s){const r=v(n,p(t));if(s&&"string"!==n){let t=0;e.forEach((e=>{const n=p(e.shape);r.set(e.vals,t),t+=n}))}else{let s=0;e.forEach((e=>{const a="string"===n?vp(e.vals):e.vals;let i=0;for(let n=0;n<e.shape[0];++n){const o=n*t[1]+s;for(let t=0;t<e.shape[1];++t)r[o+t]=a[i++]}s+=e.shape[1]}))}return r}const zv=Rv((e=>Math.exp(e))),Bv=Dv(Je,zv),Pv={kernelName:Je,backendName:"cpu",kernelFunc:Bv},Wv=Rv((e=>Math.expm1(e))),Vv=Dv(Qe,Wv),Uv={kernelName:Qe,backendName:"cpu",kernelFunc:Vv},Gv=Rv((e=>Math.floor(e))),Hv=Dv(st,Gv),jv={kernelName:st,backendName:"cpu",kernelFunc:Hv};function qv(e,t,n){const s=Kr(n,e.dtype);for(let n=0;n<s.size;++n){const r=s.indexToLoc(n).slice(),a=r[0],i=r[2],o=t.locToIndex([a,i]);r[2]=t.values[o];const l=e.locToIndex(r);s.values[n]=e.values[l]}return s}const Kv=dv(((e,t)=>e>t?1:0)),Xv=Nv(lt,Kv,null,"bool"),Yv={kernelName:lt,backendName:"cpu",kernelFunc:Xv},Jv=dv(((e,t)=>e<t?1:0)),Zv=Nv(yt,Jv,null,"bool"),Qv={kernelName:yt,backendName:"cpu",kernelFunc:Zv};function eN(e,t,n){const s=(t-e)/(n-1),r=B(n,"float32");r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+s;return r}const tN=Rv((e=>Math.log(e))),nN=Dv(wt,tN),sN={kernelName:wt,backendName:"cpu",kernelFunc:nN};function rN(e,t,n,s){const r=k(s,p(n));for(let n=0;n<r.length;++n){const s=n*t;let a=e[s];for(let n=0;n<t;++n){const t=e[s+n];t>a&&(a=t)}r[n]=a}return r}const aN=dv(((e,t)=>Math.max(e,t))),iN=Nv(Et,aN),oN={kernelName:Et,backendName:"cpu",kernelFunc:iN},lN=dv(((e,t)=>Math.min(e,t))),uN=Nv(Lt,lN),cN={kernelName:Lt,backendName:"cpu",kernelFunc:uN},hN=dv(((e,t)=>e*t)),pN=Iv(((e,t,n,s)=>({real:e*n-t*s,imag:e*s+t*n}))),dN=Nv(Wt,hN,pN),fN={kernelName:Wt,backendName:"cpu",kernelFunc:dN};function mN(e,t,n){const s=as(-1,n);return hN([],t,s,e,n)}const gN={kernelName:Vt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;lv(s,"neg");const r=n.data.get(s.dataId).values,[a,i]=mN(r,s.shape,s.dtype);return n.makeTensorInfo(i,s.dtype,a)}},yN=dv(((e,t)=>e!==t?1:0)),bN=Nv(Ut,yN,null,"bool"),xN={kernelName:Ut,backendName:"cpu",kernelFunc:bN};function wN(e,t,n,s,r){const a=t.length,i=p(t),o=O(t),l=O(r),u=k(n,p(r));for(let t=0;t<i;++t){const n=U(t,a,o),r=new Array(n.length);for(let e=0;e<r.length;e++)r[e]=n[s[e]];u[V(r,a,l)]=e[t]}return u}function kN(e){const{inputs:t,attrs:n,backend:s}=e,{x:r}=t,{perm:a}=n;lv(r,"transpose");const i=r.shape.length,o=new Array(i);for(let e=0;e<o.length;e++)o[e]=r.shape[a[e]];const l=wN(s.data.get(r.dataId).values,r.shape,r.dtype,a,o);return{dataId:s.write(l,o,r.dtype),shape:o,dtype:r.dtype}}const vN={kernelName:Pn,backendName:"cpu",kernelFunc:kN};function NN(e,t,n,s){const[r,a]=ml(e,s),i=Ds(t,"int32"),o=B(p(r),i),l=p(a);for(let e=0;e<o.length;++e){const t=e*l;let s=1;for(let e=0;e<l;++e)s*=n[t+e];o[e]=s}return{outVals:o,outShape:r,outDtype:i}}const IN={kernelName:Qt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;lv(r,"prod");const o=r.shape.length,l=x(a,r.shape),u=bl(l,o);let c=l,h=r;const p=[];null!=u&&(h=kN({inputs:{x:r},backend:n,attrs:{perm:u}}),p.push(h),c=wl(c.length,o));const d=n.data.get(h.dataId).values,{outVals:f,outShape:m,outDtype:g}=NN(h.shape,h.dtype,d,c);let y=m;return i&&(y=gl(m,l)),p.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.makeTensorInfo(y,g,f)}};function $N(e,t,n,s){if(e===t||e<t&&n<0||t<e&&n>1)return B(0,s);const r=B(Math.abs(Math.ceil((t-e)/n)),s);t<e&&1===n&&(n=-1),r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+n;return r}const CN=Rv((e=>1/Math.sqrt(e))),SN=Dv(dn,CN),TN={kernelName:dn,backendName:"cpu",kernelFunc:SN};function EN(e,t,n,s,r){const a=Va(s,t,n),i=p(n),o=O(s);if(a){const n=Ua(t,o);return"string"===r?e.slice(n,n+i):e.subarray(n,n+i)}const l=Kr(s,r,"string"===r?vp(e):e),u=Kr(n,r);for(let e=0;e<u.size;++e){const n=u.indexToLoc(e),s=n.map(((e,n)=>e+t[n]));u.set(l.get(...s),...n)}return"string"===r?Np(u.values):u.values}function AN(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,size:i}=s;lv(r,"slice");const[o,l]=Ga(r,a,i);Aa(r,o,l);const u=EN(n.data.get(r.dataId).values,o,l,r.shape,r.dtype);return n.makeTensorInfo(l,r.dtype,u)}const RN={kernelName:yn,backendName:"cpu",kernelFunc:AN};function FN(e,t,n,s,r,a,i){const o=t[0],l=a[0],u=new Array(l),c=new Array(o),h=t[1];if(0===l){if(0!==o)throw new Error(`Received SparseTensor with denseShape[0] = 0 but\n         indices.shape[0] = ${o}`);return[v(n,0),[0,h],v(r,0),u,c]}let p=!0,d=0;const f=new Array(l).fill(0);for(let t=0;t<o;++t){const n=e[t*h];if(n<0)throw new Error(`indices(${t}, 0) is invalid: ${n} < 0`);if(n>=l)throw new Error(`indices(${t}, 0) is invalid: ${n} >= ${l}`);++f[n],p=p&&n>=d,d=n}let m=!0;for(let e=0;e<l;++e){const t=0===f[e];u[e]=t,m=m&&!t,f[e]=Math.max(f[e],1),e>0&&(f[e]+=f[e-1])}if(m&&p){const t=e,n=s;for(let e=0;e<o;++e)c[e]=e;return[t,[o,h],n,u,c]}{const t=f[l-1],a=v(n,t*h),p=v(r,t),d=new Array(l).fill(0);for(let t=0;t<o;++t){const n=e[t*h],r=d[n],i=(0===n?0:f[n-1])+r;d[n]++;for(let n=0;n<h;++n)a[i*h+n]=e[t*h+n];p[i]=s[t],c[t]=i}for(let e=0;e<l;++e){if(0===d[e]){const t=0===e?0:f[e-1];a[t*h+0]=e;for(let e=1;e<h;++e)a[t*h+e]=0;p[t]=i}}return[a,[o,h],p,u,c]}}function DN(e,t,n,s,r){const a=p(s),i=t[0],o=r.length,l=[];let u=1,c=-1;for(let e=0;e<o;++e){const t=r[e];if(-1===t){if(-1!==c)throw new Error(`only one output dimension may be -1, not both ${c} and ${e}`);c=e,l.push(1)}else{if(t<0)throw new Error(`size ${e} must be non-negative, not ${t}`);u*=t,l.push(t)}}if(-1!==c){if(u<=0)throw new Error("reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero");const e=Math.trunc(a/u);if(u*e!==a)throw new Error(`Input to reshape is a SparseTensor with ${a}\n          dense values, but the requested shape requires a multiple of ${u}. inputShape=${s} outputShape= ${l}`);l[c]=e}const h=p(l);if(h!==a)throw new Error(`Input to reshape is a tensor with ${a} dense values, but the requested shape has ${h}. inputShape=${s} outputShape=${l}`);const d=s.length,f=[];if(d>0){f[d-1]=1;for(let e=d-2;e>=0;--e)f[e]=f[e+1]*s[e+1]}const m=[];if(o>0){m[o-1]=1;for(let e=o-2;e>=0;--e)m[e]=m[e+1]*l[e+1]}const g=v(n,i*o);for(let t=0;t<i;++t){let n=0;for(let s=0;s<d;++s)n+=e[t*d+s]*f[s];for(let e=0;e<o;++e)g[t*o+e]=Math.trunc(n/m[e]),n%=m[e]}return[g,[i,o],l]}const _N=dv(((e,t)=>{const n=e-t;return n*n})),ON=Nv(Rn,_N),MN={kernelName:Rn,backendName:"cpu",kernelFunc:ON};function LN(e,t,n,s){const r=Kr(e,t.dtype);for(let e=0;e<r.size;e++){const a=r.indexToLoc(e),i=new Array(a.length);for(let e=0;e<i.length;e++)i[e]=a[e]*n[e]+s[e];r.set(t.get(...i),...a)}return r}const zN=dv(((e,t)=>e-t)),BN=Iv(((e,t,n,s)=>({real:e-n,imag:t-s}))),PN=Nv(_n,zN,BN),WN={kernelName:_n,backendName:"cpu",kernelFunc:PN};function VN(e,t){const n=new Array(e.rank);for(let s=0;s<n.length;s++)n[s]=e.shape[s]*t[s];const s=Kr(n,e.dtype);for(let t=0;t<s.values.length;++t){const n=s.indexToLoc(t),r=new Array(e.rank);for(let t=0;t<r.length;t++)r[t]=n[t]%e.shape[t];const a=e.locToIndex(r);s.values[t]=e.values[a]}return s}function UN(e,t,n,s,r){const a=t[t.length-1],[i,o]=[e.length/a,a],l=k(n,i*s),u=k("int32",i*s);for(let t=0;t<i;t++){const n=t*o,r=e.subarray(n,n+o),a=[];for(let e=0;e<r.length;e++)a.push({value:r[e],index:e});a.sort(((e,t)=>t.value-e.value));const i=t*s,c=l.subarray(i,i+s),h=u.subarray(i,i+s);for(let e=0;e<s;e++)c[e]=a[e].value,h[e]=a[e].index}const c=t.slice();return c[c.length-1]=s,[Kr(c,n,l),Kr(c,"int32",u)]}function GN(e,t,n,s){const r=x(t,n)[0],a=[1,n[0],1];for(let e=0;e<r;e++)a[0]*=n[e];a[1]=n[r];for(let e=r+1;e<n.length;e++)a[2]*=n[e];const i={},o=new Int32Array(n[r]),l=new ws(a,s,e),u=[],c=1===a[0]&&1===a[2];for(let t=0;t<n[r];t++){let n;if(c)n=e[t].toString();else{const e=[];for(let n=0;n<a[0];n++)for(let s=0;s<a[2];s++)e.push(l.get(n,t,s));n=e.join(",")}if(void 0!==i[n])o[t]=i[n];else{const e=Object.keys(i).length;i[n]=e,o[t]=e,u.push(t)}}const h=a.slice();h[1]=Object.keys(i).length;const p=new ws(h,s);u.forEach(((e,t)=>{for(let n=0;n<a[0];n++)for(let s=0;s<a[2];s++)p.set(l.get(n,e,s),n,t,s)}));const d=n.slice();return d[r]=h[1],{outputValues:p.values,outputShape:d,indices:o}}var HN=Object.freeze({__proto__:null,simpleAbsImpl:hv,addImpl:$v,bincountImpl:Ev,bincountReduceImpl:Av,ceilImpl:_v,concatImpl:Lv,expImpl:zv,expm1Impl:Wv,floorImpl:Gv,gatherV2Impl:qv,greaterImpl:Kv,lessImpl:Jv,linSpaceImpl:eN,logImpl:tN,maxImpl:rN,maximumImpl:aN,minimumImpl:lN,multiplyImpl:hN,negImpl:mN,notEqualImpl:yN,prodImpl:NN,rangeImpl:$N,rsqrtImpl:CN,sliceImpl:EN,sparseFillEmptyRowsImpl:FN,sparseReshapeImpl:DN,squaredDifferenceImpl:_N,stridedSliceImpl:LN,subImpl:zN,tileImpl:VN,topKImpl:UN,transposeImpl:wN,uniqueImpl:GN});ci("cpu",(()=>new cv),1);const jN=Fv(qe,(e=>e>=0?e:Math.exp(e)-1)),qN={kernelName:qe,backendName:"cpu",kernelFunc:jN};function KN(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{alpha:a}=s;lv([r],"leakyRelu");const i=p(r.shape),o=n.data.get(r.dataId).values,l=k("float32",i);for(let e=0;e<o.length;e++)l[e]=o[e]<0?a*o[e]:o[e];return n.makeTensorInfo(r.shape,"float32",l)}const XN={kernelName:gt,backendName:"cpu",kernelFunc:KN},YN=dv(((e,t)=>e<0?t*e:e));function JN(e){const{inputs:t,backend:n}=e,{x:s,alpha:r}=t;lv([s,r],"prelu");const a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,[o,l]=YN(s.shape,r.shape,a,i,s.dtype);return n.makeTensorInfo(l,s.dtype,o)}const ZN={kernelName:Zt,backendName:"cpu",kernelFunc:JN},QN=Fv(sn,(e=>Math.max(0,e))),eI={kernelName:sn,backendName:"cpu",kernelFunc:QN},tI=Fv(cn,(e=>Math.min(Math.max(0,e),6))),nI={kernelName:cn,backendName:"cpu",kernelFunc:tI},sI=Fv(kn,(e=>1/(1+Math.exp(-e)))),rI={kernelName:kn,backendName:"cpu",kernelFunc:sI};function aI(e,t,n,s,r){if("linear"===n)return yv({inputs:{x:t},backend:e});if("relu"===n)return QN({inputs:{x:t},backend:e});if("elu"===n)return jN({inputs:{x:t},backend:e});if("relu6"===n)return tI({inputs:{x:t},backend:e});if("prelu"===n)return JN({inputs:{x:t,alpha:s},backend:e});if("leakyrelu"===n)return KN({inputs:{x:t},backend:e,attrs:{alpha:r}});if("sigmoid"===n)return sI({inputs:{x:t},backend:e});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function iI(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{shape:a}=s,i=p(r.shape),o=b(a,i),u=p(o);l(i===u,(()=>`The new shape (${o}) has ${u} elements and the old shape (${r.shape}) has ${i} elements. The new shape and old shape must have the same number of elements.`)),n.incRef(r.dataId);const c=n.data.get(r.dataId);if(null!=c.complexTensorInfos){const e=c.complexTensorInfos.real,t=c.complexTensorInfos.imag;e.shape=o,t.shape=o}return{dataId:r.dataId,shape:o,dtype:r.dtype}}const oI={kernelName:rn,backendName:"cpu",kernelFunc:iI};function lI(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a}=t,{transposeA:i,transposeB:o}=s;lv([r,a],"matMul");const u=r.shape.length,c=a.shape.length,h=i?r.shape[u-2]:r.shape[u-1],d=o?a.shape[c-1]:a.shape[c-2],f=i?r.shape[u-1]:r.shape[u-2],m=o?a.shape[c-2]:a.shape[c-1],g=r.shape.slice(0,-2),y=a.shape.slice(0,-2),b=p(g),x=p(y);l(u>=2&&c>=2&&(b===x||1===b||1===x),(()=>`Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of (${g}) and (${y}).`));const w=(b>x?r.shape.slice(0,-2):a.shape.slice(0,-2)).concat([f,m]);l(h===d,(()=>`Error in matMul: inner shapes (${h}) and (${d}) of Tensors with shapes ${r.shape} and ${a.shape} and transposeA=${i} and transposeB=${o} must match.`));const k=o?[x,m,d]:[x,d,m],v=iI({inputs:{x:r},backend:n,attrs:{shape:i?[b,h,f]:[b,f,h]}}),N=iI({inputs:{x:a},backend:n,attrs:{shape:k}}),I=i?v.shape[1]:v.shape[2],$=i?v.shape[2]:v.shape[1],C=o?N.shape[1]:N.shape[2],S=Math.max(b,x),T=n.data.get(v.dataId).values,E=n.data.get(N.dataId).values,A=O(v.shape),R=O(N.shape),[F,D,_]=i?[A[0],1,A[1]]:[A[0],A[1],1],[M,L,z]=o?[1,R[1],R[0]]:[R[1],1,R[0]],B=$*C,P=Kr([S,$,C],v.dtype),W=P.values,V=n.blockSize;for(let e=0;e<S;e++)for(let t=0;t<$;t+=V)for(let n=0;n<C;n+=V)for(let s=0;s<I;s+=V){const r=Math.min(t+V,$),a=Math.min(n+V,C),i=Math.min(s+V,I);for(let o=t;o<r;o++)for(let t=n;t<a;t++){let n=0;for(let r=s;r<i;r++){const s=Math.min(e,b-1)*F,a=Math.min(e,x-1)*z;n+=T[s+o*D+r*_]*E[r*M+t*L+a]}W[e*B+(o*C+t)]+=n}}return n.disposeIntermediateTensorInfo(v),n.disposeIntermediateTensorInfo(N),n.makeTensorInfo(w,P.dtype,P.values)}const uI={kernelName:ge,backendName:"cpu",kernelFunc:lI};const cI={kernelName:Kn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a,bias:i,preluActivationWeights:o}=t,{transposeA:l,transposeB:u,activation:c,leakyreluAlpha:h}=s;let p,d,f;const m=[];p=lI({inputs:{a:r,b:a},attrs:{transposeA:l,transposeB:u},backend:n}),i&&(d=Sv({inputs:{a:p,b:i},backend:n}),m.push(p),p=d),c&&(f=aI(n,p,c,o,h),m.push(p),p=f);for(const e of m)n.disposeIntermediateTensorInfo(e);return p}},hI=Fv(Q,(e=>Math.acos(e))),pI={kernelName:Q,backendName:"cpu",kernelFunc:hI},dI=Fv(ee,(e=>Math.acosh(e))),fI={kernelName:ee,backendName:"cpu",kernelFunc:dI};const mI={kernelName:ne,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,s=t;lv(t,"addN");const r=s.map((e=>n.data.get(e.dataId).values)),a=Kr(s[0].shape,s[0].dtype),i=a.values;for(let e=0;e<s.length;e++){const t=r[e];for(let e=0;e<i.length;e++)i[e]+=t[e]}return n.makeTensorInfo(a.shape,a.dtype,a.values)}};const gI={kernelName:se,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;lv(r,"all");const o=x(a,r.shape);let l=o;const u=bl(l,r.shape.length);let c=r;null!=u&&(c=kN({inputs:{x:r},backend:n,attrs:{perm:u}}),l=wl(l.length,r.shape.length)),yl("all",l,c.shape.length);const[h,d]=ml(c.shape,l),f=p(d),m=B(p(h),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];n=n&&s}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(h,c.dtype,m);if(i){const e=iI({inputs:{x:y},backend:n,attrs:{shape:gl(h,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const yI={kernelName:re,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;lv(r,"any");const o=x(a,r.shape);let l=o;const u=bl(l,r.shape.length);let c=r;null!=u&&(c=kN({inputs:{x:r},backend:n,attrs:{perm:u}}),l=wl(l.length,r.shape.length)),yl("any",l,c.shape.length);const[h,d]=ml(c.shape,l),f=p(d),m=B(p(h),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];n=n||s}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(h,c.dtype,m);if(i){const e=iI({inputs:{x:y},backend:n,attrs:{shape:gl(h,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const bI={kernelName:ae,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;lv(r,"argMax");let i=x(a,r.shape);const o=bl(i,r.shape.length);let l=r;const u=[];null!=o&&(l=kN({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=wl(i.length,l.shape.length)),i=[i[0]],yl("argMax",i,l.shape.length);const[c,h]=ml(l.shape,i),d=B(p(c),"int32"),f=p(h),m=n.data.get(l.dataId).values;for(let e=0;e<d.length;++e){const t=e*f;let n=m[t],s=0;for(let e=0;e<f;++e){const r=m[t+e];r>n&&(n=r,s=e)}d[e]=s}return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.makeTensorInfo(c,"int32",d)}};const xI={kernelName:ie,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;lv(r,"argMin");let i=x(a,r.shape);const o=bl(i,r.shape.length);let l=r;const u=[];null!=o&&(l=kN({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=wl(i.length,l.shape.length)),i=[i[0]],yl("argMin",i,l.shape.length);const[c,h]=ml(l.shape,i),d=B(p(c),"int32"),f=p(h),m=n.data.get(l.dataId).values;for(let e=0;e<d.length;++e){const t=e*f;let n=m[t],s=0;for(let e=0;e<f;++e){const r=m[t+e];r<n&&(n=r,s=e)}d[e]=s}return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.makeTensorInfo(c,"int32",d)}},wI=Fv(oe,(e=>Math.asin(e))),kI={kernelName:oe,backendName:"cpu",kernelFunc:wI},vI=Fv(le,(e=>Math.asinh(e))),NI={kernelName:le,backendName:"cpu",kernelFunc:vI},II=Fv(ue,(e=>Math.atan(e))),$I={kernelName:ue,backendName:"cpu",kernelFunc:II},CI=dv(((e,t)=>Math.atan2(e,t))),SI=Nv(he,CI),TI={kernelName:he,backendName:"cpu",kernelFunc:SI},EI=Fv(ce,(e=>Math.atanh(e))),AI={kernelName:ce,backendName:"cpu",kernelFunc:EI};function RI(e,t,n,s,r,a){const i=r.strideHeight,o=r.strideWidth,l=r.dilationHeight,u=r.dilationWidth,c=r.effectiveFilterHeight,h=r.effectiveFilterWidth,p=r.padInfo.top,d=r.padInfo.left,f="max"===a?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,m=Kr(r.outShape,n),g=m.values,y=r.outShape[1]*r.outShape[2]*r.outShape[3],b=r.outShape[2]*r.outShape[3],x=r.outShape[3];for(let t=0;t<r.batchSize;++t){const n=t*y,m=t*s[0];for(let t=0;t<r.inChannels;++t)for(let y=0;y<r.outHeight;++y){const w=y*i-p,k=Math.max(0,w),v=Math.min(r.inHeight,c+w),N=n+y*b;for(let n=0;n<r.outWidth;++n){const i=n*o-d,c=Math.max(0,i),p=Math.min(r.inWidth,h+i);let y=f,b=0,w=0;for(let n=k;n<v;n+=l){const r=m+n*s[1];for(let n=c;n<p;n+=u){const i=e[r+n*s[2]+t];"max"===a&&i>y?y=i:"avg"===a&&(b+=i,w++)}if(isNaN(y))break}g[N+n*x+t]="avg"===a?b/w:y}}}return m}function FI(e,t,n,s,r=!1,a=!1){const i=Kr(s.outShape,"int32"),o=s.strideHeight,l=s.strideWidth,u=s.dilationHeight,c=s.dilationWidth,h=s.effectiveFilterHeight,p=s.effectiveFilterWidth,d=s.padInfo.top,f=s.padInfo.left,m=Kr(t,n,e);for(let e=0;e<s.batchSize;++e)for(let t=0;t<s.inChannels;++t)for(let n=0;n<s.outHeight;++n){const g=n*o-d;let y=g;for(;y<0;)y+=u;const b=Math.min(s.inHeight,h+g);for(let o=0;o<s.outWidth;++o){const h=o*l-f;let d=h;for(;d<0;)d+=c;const x=Math.min(s.inWidth,p+h);let w=Number.NEGATIVE_INFINITY,k=-1;for(let n=y;n<b;n+=u){const i=n-g;for(let o=d;o<x;o+=c){const l=o-h,u=m.get(e,n,o,t);u>w&&(w=u,k=r?a?((e*s.inHeight+n)*s.inWidth+o)*s.inChannels+t:(n*s.inWidth+o)*s.inChannels+t:i*p+l)}}i.set(k,e,n,o,t)}}return i}function DI(e,t,n,s,r,a){const i=r.strideDepth,o=r.strideHeight,l=r.strideWidth,u=r.dilationDepth,c=r.dilationHeight,h=r.dilationWidth,p=r.effectiveFilterDepth,d=r.effectiveFilterHeight,f=r.effectiveFilterWidth,m=r.padInfo.front,g=r.padInfo.top,y=r.padInfo.left,b="max"===a?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,x=Kr(r.outShape,n),w=x.values,k=r.outShape[1]*r.outShape[2]*r.outShape[3]*r.outShape[4],v=r.outShape[2]*r.outShape[3]*r.outShape[4],N=r.outShape[3]*r.outShape[4],I=r.outShape[4];for(let t=0;t<r.batchSize;++t){const n=t*k,x=t*s[0];for(let t=0;t<r.inChannels;++t)for(let k=0;k<r.outDepth;++k){const $=k*i-m;let C=$;for(;C<0;)C+=u;const S=Math.min(r.inDepth,p+$),T=n+k*v;for(let n=0;n<r.outHeight;++n){const i=n*o-g;let p=i;for(;p<0;)p+=c;const m=Math.min(r.inHeight,d+i),k=T+n*N;for(let n=0;n<r.outWidth;++n){const i=n*l-y;let o=i;for(;o<0;)o+=h;const d=Math.min(r.inWidth,f+i),g=k+n*I;let v=b,N=0,$=0;for(let n=C;n<S;n+=u){const r=x+n*s[1];for(let n=p;n<m;n+=c){const i=r+n*s[2];for(let n=o;n<d;n+=h){const r=e[i+n*s[3]+t];if("max"===a&&r>v?v=r:"avg"===a&&(N+=r,$++),isNaN(v))break}if(isNaN(v))break}if(isNaN(v))break}w[g+t]="avg"===a?N/$:v}}}}return x}const _I={kernelName:pe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;lv(r,"avgPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:u}=s;l(Pi(i,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`));const c=Ai(r.shape,a,i,1,o,u);let h;if(1===c.filterWidth&&1===c.filterHeight&&d(c.inShape,c.outShape))h=yv({inputs:{x:r},backend:n});else{const e=n.data.get(r.dataId).values,t=O(r.shape),s=RI(e,r.shape,r.dtype,t,c,"avg");h=n.makeTensorInfo(c.outShape,r.dtype,s.values)}return h}};const OI={kernelName:fe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s;lv(r,"avgPool3d");const c=Ri(r.shape,a,i,1,o,l,u),h=DI(n.data.get(r.dataId).values,r.shape,r.dtype,O(r.shape),c,"avg");return n.makeTensorInfo(h.shape,"float32",h.values)}};const MI={kernelName:me,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,{filterSize:i,strides:o,pad:l,dimRoundingMode:u}=s;lv([r,a],"avgPool3DGrad");const c=Ri(a.shape,i,o,1,l,u),h=c.strideDepth,p=c.strideHeight,d=c.strideWidth,f=c.filterDepth,m=c.filterHeight,g=c.filterWidth,y=c.dilationDepth,b=c.dilationHeight,x=c.dilationWidth,w=c.effectiveFilterDepth,k=c.effectiveFilterHeight,v=c.effectiveFilterWidth,N=w-1-c.padInfo.front,I=v-1-c.padInfo.left,$=k-1-c.padInfo.top,C=Kr(a.shape,"float32"),S=1/(f*m*g),T=n.bufferSync(r);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inDepth;++n)for(let s=0;s<c.inHeight;++s)for(let r=0;r<c.inWidth;++r){const a=n-N,i=s-$,o=r-I;let l=0;for(let n=0;n<w;n+=y){const s=(a+n)/h;if(!(s<0||s>=c.outDepth||Math.floor(s)!==s))for(let n=0;n<k;n+=b){const r=(i+n)/p;if(!(r<0||r>=c.outHeight||Math.floor(r)!==r))for(let n=0;n<v;n+=x){const a=(o+n)/d;if(a<0||a>=c.outWidth||Math.floor(a)!==a)continue;l+=T.get(e,s,r,a,t)}}}C.set(l*S,e,n,s,r,t)}return n.makeTensorInfo(C.shape,C.dtype,C.values)}};const LI={kernelName:de,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a;lv([r,a],"avgPoolGrad");const{filterSize:o,strides:l,pad:u}=s,c=Ai(i.shape,o,l,1,u),h=c.strideHeight,p=c.strideWidth,d=c.filterHeight,f=c.filterWidth,m=c.dilationHeight,g=c.dilationWidth,y=c.effectiveFilterHeight,b=c.effectiveFilterWidth,x=b-1-c.padInfo.left,w=y-1-c.padInfo.top,k=Kr(i.shape,"float32"),v=1/(d*f),N=n.data.get(r.dataId).values,I=Kr(r.shape,"float32",N);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inHeight;++n)for(let s=0;s<c.inWidth;++s){const r=n-w,a=s-x;let i=0;for(let n=0;n<y;n+=m){const s=(r+n)/h;if(!(s<0||s>=c.outHeight||Math.floor(s)!==s))for(let n=0;n<b;n+=g){const r=(a+n)/p;if(r<0||r>=c.outWidth||Math.floor(r)!==r)continue;i+=I.get(e,s,r,t)}}k.set(i*v,e,n,s,t)}return n.makeTensorInfo(k.shape,k.dtype,k.values)}};const zI={kernelName:at,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,scale:a,offset:i,mean:o,variance:u}=t;l(o.shape.length===u.shape.length,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),l(null==i||o.shape.length===i.shape.length,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),l(null==a||o.shape.length===a.shape.length,(()=>"Batch normalization gradient requires mean and scale to have equal ranks.")),lv([r,o,u,a,i],"batchNorm");let{varianceEpsilon:c}=s;null==c&&(c=.001);const h=n.data.get(r.dataId).values,p=n.data.get(o.dataId).values,d=n.data.get(u.dataId).values,f=a?n.data.get(a.dataId).values:new Float32Array([1]),m=i?n.data.get(i.dataId).values:new Float32Array([0]),g=new Float32Array(h.length),y=m.length,b=f.length,x=d.length,w=p.length;let k=0,v=0,N=0,I=0;for(let e=0;e<h.length;++e)g[e]=m[k++]+(h[e]-p[v++])*f[N++]/Math.sqrt(d[I++]+c),k>=y&&(k=0),v>=w&&(v=0),N>=b&&(N=0),I>=x&&(I=0);return n.makeTensorInfo(r.shape,r.dtype,g)}};const BI={kernelName:ye,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,crops:i}=s;lv([r],"batchToSpaceND");const o=a.reduce(((e,t)=>e*t)),l=Wh(r.shape,a,o),u=Vh(l.length,a.length),c=Uh(r.shape,a,o),h=Gh(i,a.length),p=Hh(c,i,a.length),d=iI({inputs:{x:r},backend:n,attrs:{shape:l}}),f=kN({inputs:{x:d},backend:n,attrs:{perm:u}}),m=iI({inputs:{x:f},backend:n,attrs:{shape:c}}),g=AN({inputs:{x:m},backend:n,attrs:{begin:h,size:p}});return n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}};const PI={kernelName:be,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i}=s,o=Ev(n.data.get(r.dataId).values,n.data.get(a.dataId).values,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,o)}},WI=Fv(ve,((e,t)=>{const n=t;return e>n.clipValueMax?n.clipValueMax:e<n.clipValueMin?n.clipValueMin:e})),VI={kernelName:ve,backendName:"cpu",kernelFunc:WI},UI={kernelName:Ie,backendName:"cpu",kernelFunc:e=>{const{x:t}=e.inputs,n=e.backend,s=new Float32Array(p(t.shape)),r=n.data.get(t.dataId),a=r.complexTensorInfos.real,i=r.complexTensorInfos.imag,o=n.data.get(a.dataId).values,l=n.data.get(i.dataId).values;for(let e=0;e<o.length;e++){const t=o[e],n=l[e];s[e]=Math.hypot(t,n)}return n.makeOutput(s,t.shape,"float32")}};function GI(e){const{inputs:t,backend:n}=e,{input:s}=t,r=n.data.get(s.dataId).complexTensorInfos.imag,a=n.data.get(r.dataId).values;return n.makeTensorInfo(r.shape,r.dtype,a)}const HI={kernelName:pt,backendName:"cpu",kernelFunc:GI};function jI(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s,a=x(r,t[0].shape)[0];let i=zh(t.map((e=>e.shape)),a);if(0===p(i))return n.makeTensorInfo(i,t[0].dtype,[]);const o=t.filter((e=>p(e.shape)>0));if(1===o.length)return yv({inputs:{x:o[0]},backend:n});if(Lh(o.map((e=>e.shape)),a),"complex64"===o[0].dtype){const e=o.map((e=>xv({inputs:{input:e},backend:n}))),t=o.map((e=>GI({inputs:{input:e},backend:n}))),s=jI({inputs:e,backend:n,attrs:{axis:a}}),r=jI({inputs:t,backend:n,attrs:{axis:a}}),i=fv({inputs:{real:s,imag:r},backend:n});return e.forEach((e=>n.disposeIntermediateTensorInfo(e))),t.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),i}const l=o.map((e=>{const t=p(e.shape.slice(a));return iI({inputs:{x:e},backend:n,attrs:{shape:[-1,t]}})})),u=l.map((e=>({vals:n.data.get(e.dataId).values,shape:e.shape})));i=zh(l.map((e=>e.shape)),1);const c=1===l[0].shape[0],h=Lv(u,i,t[0].dtype,c),d=zh(o.map((e=>e.shape)),a),f=n.makeTensorInfo(d,t[0].dtype,h);return l.forEach((e=>n.disposeIntermediateTensorInfo(e))),f}const qI={kernelName:$e,backendName:"cpu",kernelFunc:jI};function KI(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dataFormat:l,dilations:u,dimRoundingMode:c}=s;lv([r,a],"conv2d");const h=Wi(l),p=Fi(r.shape,a.shape,i,u,o,c,!1,h),d=p.filterHeight,f=p.filterWidth,m=p.dilationHeight,g=p.dilationWidth,y=p.padInfo.left,b=p.padInfo.top,x="channelsLast"===p.dataFormat,w=new ws(p.outShape,r.dtype),k=O(r.shape),v=O(a.shape),N=k[0],I=x?k[1]:k[2],$=x?k[2]:1,C=x?1:k[1],S=w.strides[0],T=x?w.strides[1]:w.strides[2],E=x?w.strides[2]:1,A=x?1:w.strides[1],R=n.data.get(r.dataId).values,F=n.data.get(a.dataId).values,D=w.values;for(let e=0;e<p.batchSize;++e){const t=e*N,n=e*S;for(let e=0;e<p.outHeight;++e){const s=n+e*T,r=e*p.strideHeight-b;for(let e=0;e<d;++e){const n=r+e*m;if(n<0||n>=p.inHeight)continue;const a=e*v[0],i=t+n*I;for(let e=0;e<p.outWidth;++e){const t=s+e*E,n=e*p.strideWidth-y;for(let e=0;e<f;++e){const s=n+e*g;if(s<0||s>=p.inWidth)continue;const r=i+s*$;let o=a+e*v[1];for(let e=0;e<p.inChannels;++e){const n=R[r+e*C];for(let e=0;e<p.outChannels;++e)D[t+e*A]+=n*F[o+e];o+=p.outChannels}}}}}}return n.makeTensorInfo(w.shape,w.dtype,D)}const XI={kernelName:Ce,backendName:"cpu",kernelFunc:KI};const YI={kernelName:Se,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,dataFormat:l,dimRoundingMode:u,filterShape:c}=s;lv([r,a],"conv2dBackpropFilter");const h=Wi(l),p=Fi(r.shape,c,i,1,o,u,!1,h),{strideHeight:d,strideWidth:f,filterHeight:m,filterWidth:g}=p,y="channelsLast"===p.dataFormat,b=new ws(p.filterShape,"float32"),x=p.padInfo.left,w=p.padInfo.top,k=n.data.get(r.dataId).values,v=n.data.get(a.dataId).values,N=new ws(r.shape,r.dtype,k),I=new ws(a.shape,a.dtype,v);for(let e=0;e<m;++e){const t=Math.max(0,Math.ceil((w-e)/d)),n=Math.min(p.outHeight,(p.inHeight+w-e)/d);for(let s=0;s<g;++s){const r=Math.max(0,Math.ceil((x-s)/f)),a=Math.min(p.outWidth,(p.inWidth+x-s)/f);for(let i=0;i<p.inChannels;++i)for(let o=0;o<p.outChannels;++o){let l=0;for(let u=0;u<p.batchSize;++u)for(let c=t;c<n;++c){const t=e+c*d-w;for(let e=r;e<a;++e){const n=s+e*f-x;l+=y?N.get(u,t,n,i)*I.get(u,c,e,o):N.get(u,i,t,n)*I.get(u,o,c,e)}}b.set(l,e,s,i,o)}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const JI={kernelName:Te,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{inputShape:i,strides:o,pad:l,dataFormat:u,dimRoundingMode:c}=s;lv([r,a],"conv2dBackpropInput");const h=O(a.shape),p=O(r.shape);let d=Wi(u);const f=Fi(i,a.shape,o,1,l,c,!1,d),m=new ws(f.inShape,"float32"),g=m.values,y=n.data.get(r.dataId).values,b=n.data.get(a.dataId).values,[x,w,k]=h,{batchSize:v,filterHeight:N,filterWidth:I,inChannels:$,inHeight:C,inWidth:S,outChannels:T,outHeight:E,outWidth:A,strideHeight:R,strideWidth:F}=f;d=f.dataFormat;const D=N-1-f.padInfo.top,_=I-1-f.padInfo.left,M="channelsLast"===d,L=m.strides[0],z=M?m.strides[1]:m.strides[2],B=M?m.strides[2]:1,P=M?1:m.strides[1],W=p[0],V=M?p[1]:p[2],U=M?p[2]:1,G=M?1:p[1];for(let e=0;e<v;++e)for(let t=0;t<$;++t)for(let n=0;n<C;++n){const s=n-D,r=Math.max(0,Math.ceil(s/R)),a=Math.min(E,(N+s)/R);for(let i=0;i<S;++i){const o=i-_,l=Math.max(0,Math.ceil(o/F)),u=Math.min(A,(I+o)/F);let c=0;for(let n=r;n<a;++n){const r=n*R-s;for(let s=l;s<u;++s){const a=W*e+V*n+U*s,i=x*(N-1-r)+w*(I-1-(s*F-o))+k*t;for(let e=0;e<T;++e){c+=y[a+G*e]*b[i+e]}}}g[L*e+z*n+B*i+P*t]=c}}return n.makeTensorInfo(m.shape,m.dtype,m.values)}};const ZI={kernelName:Ee,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s;lv([r,a],"conv3d");const u=Di(r.shape,a.shape,i,l,o),{filterDepth:c,filterHeight:h,filterWidth:p,dilationDepth:d,dilationHeight:f,dilationWidth:m,padInfo:g}=u,y=g.front,b=g.left,x=g.top,w=new ws(u.outShape,r.dtype),k=n.data.get(r.dataId).values,v=n.data.get(a.dataId).values,N=w.values,I=O(r.shape),$=O(a.shape);for(let e=0;e<u.batchSize;++e){const t=e*I[0],n=e*w.strides[0];for(let e=0;e<u.outDepth;++e){const s=n+e*w.strides[1],r=e*u.strideDepth-y;for(let e=0;e<c;++e){const n=r+e*d;if(n<0||n>=u.inDepth)continue;const a=e*$[0],i=t+n*I[1];for(let e=0;e<u.outHeight;++e){const t=s+e*w.strides[2],n=e*u.strideHeight-x;for(let e=0;e<h;++e){const s=n+e*f;if(s<0||s>=u.inHeight)continue;const r=a+e*$[1],o=i+s*I[2];for(let e=0;e<u.outWidth;++e){const n=t+e*u.outChannels,s=e*u.strideWidth-b;for(let e=0;e<p;++e){const t=s+e*m;if(t<0||t>=u.inWidth)continue;const a=r+e*$[2],i=o+t*u.inChannels;let l=a;for(let e=0;e<u.inChannels;++e){const t=k[i+e];for(let e=0;e<u.outChannels;++e)N[n+e]+=t*v[l+e];l+=u.outChannels}}}}}}}}return n.makeTensorInfo(w.shape,w.dtype,w.values)}};const QI={kernelName:Ae,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,filterShape:l}=s;lv([r,a],"conv3dBackpropFilterV2");const u=O(r.shape),c=O(a.shape),h=Di(r.shape,l,i,1,o),p=h.strideDepth,d=h.strideHeight,f=h.strideWidth,m=h.filterDepth,g=h.filterHeight,y=h.filterWidth,b=new ws(h.filterShape,"float32"),x=b.values,[w,k,v,N]=b.strides,I=n.data.get(a.dataId).values,[$,C,S,T]=c,E=n.data.get(r.dataId).values,[A,R,F,D]=u,_=h.padInfo.front,M=h.padInfo.left,L=h.padInfo.top;for(let e=0;e<m;++e){const t=Math.max(0,Math.ceil((_-e)/p)),n=Math.min(h.outDepth,(h.inDepth+_-e)/p),s=e*w;for(let r=0;r<g;++r){const a=Math.max(0,Math.ceil((L-r)/d)),i=Math.min(h.outHeight,(h.inHeight+L-r)/d),o=r*k+s;for(let s=0;s<y;++s){const l=Math.max(0,Math.ceil((M-s)/f)),u=Math.min(h.outWidth,(h.inWidth+M-s)/f),c=s*v+o;for(let o=0;o<h.inChannels;++o){const m=o*N+c;for(let c=0;c<h.outChannels;++c){let g=0;for(let m=0;m<h.batchSize;++m){const h=m*A,y=m*$;for(let m=t;m<n;++m){const t=(e+m*p-_)*R+h,n=m*C+y;for(let e=a;e<i;++e){const a=(r+e*d-L)*F+t,i=e*S+n;for(let e=l;e<u;++e){const t=e*T+i;g+=E[(s+e*f-M)*D+a+o]*I[t+c]}}}}x[m+c]=g}}}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const e$={kernelName:Re,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{pad:i,strides:o,inputShape:l}=s;lv([r],"conv3dBackpropInputV2");const u=O(r.shape),c=O(a.shape),h=Di(l,a.shape,o,1,i),p=new ws(h.inShape,"float32"),d=p.values,[f,m,g,y]=p.strides,b=n.data.get(r.dataId).values,[x,w,k,v]=u,N=n.data.get(a.dataId).values,[I,$,C,S]=c,{batchSize:T,filterDepth:E,filterHeight:A,filterWidth:R,inChannels:F,inDepth:D,inHeight:_,inWidth:M,outChannels:L,outDepth:z,outHeight:B,outWidth:P,strideDepth:W,strideHeight:V,strideWidth:U}=h,G=E-1-h.padInfo.front,H=A-1-h.padInfo.top,j=R-1-h.padInfo.left;for(let e=0;e<T;++e)for(let t=0;t<F;++t)for(let n=0;n<D;++n){const s=n-G,r=Math.max(0,Math.ceil(s/W)),a=Math.min(z,(E+s)/W);for(let i=0;i<_;++i){const o=i-H,l=Math.max(0,Math.ceil(o/V)),u=Math.min(B,(A+o)/V);for(let c=0;c<M;++c){const h=c-j,p=Math.max(0,Math.ceil(h/U)),T=Math.min(P,(R+h)/U);let F=0;for(let n=r;n<a;++n){const r=n*W-s;for(let s=l;s<u;++s){const a=s*V-o;for(let i=p;i<T;++i){const o=x*e+w*n+k*s+v*i,l=I*(E-1-r)+$*(A-1-a)+C*(R-1-(i*U-h))+S*t;for(let e=0;e<L;++e){F+=b[o+e]*N[l+e]}}}}d[f*e+m*n+g*i+y*c+t]=F}}}return n.makeTensorInfo(p.shape,p.dtype,p.values)}},t$=Fv(Fe,(e=>Math.cos(e))),n$={kernelName:Fe,backendName:"cpu",kernelFunc:t$},s$=Fv(De,(e=>Math.cosh(e))),r$={kernelName:De,backendName:"cpu",kernelFunc:s$};const a$={kernelName:Oe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{image:r,boxes:a,boxInd:i}=t,{cropSize:o,method:l,extrapolationValue:u}=s,[c,h,p,d]=r.shape,f=a.shape[0],[m,g]=o,y=Kr([f,m,g,d],"float32"),b=n.data.get(a.dataId).values,x=n.data.get(i.dataId).values,w=n.data.get(r.dataId).values,k=O(r.shape),v=O(y.shape);for(let e=0;e<f;e++){const t=4*e,n=b[t],s=b[t+1],r=b[t+2],a=b[t+3],i=x[e];if(i>=c)continue;const o=m>1?(r-n)*(h-1)/(m-1):0,f=g>1?(a-s)*(p-1)/(g-1):0;for(let t=0;t<m;t++){const c=m>1?n*(h-1)+t*o:.5*(n+r)*(h-1);if(c<0||c>h-1)for(let n=0;n<g;n++)for(let s=0;s<d;s++){const r=s+n*v[2]+t*v[1]+e*v[0];y.values[r]=u}else if("bilinear"===l){const n=Math.floor(c),r=Math.ceil(c),o=c-n;for(let l=0;l<g;l++){const c=g>1?s*(p-1)+l*f:.5*(s+a)*(p-1);if(c<0||c>p-1){for(let n=0;n<d;n++){const s=n+l*v[2]+t*v[1]+e*v[0];y.values[s]=u}continue}const h=Math.floor(c),m=Math.ceil(c),b=c-h;for(let s=0;s<d;s++){let a=s+h*k[2]+n*k[1]+i*k[0];const u=w[a];a=s+m*k[2]+n*k[1]+i*k[0];const c=w[a];a=s+h*k[2]+r*k[1]+i*k[0];const p=w[a];a=s+m*k[2]+r*k[1]+i*k[0];const d=u+(c-u)*b,f=p+(w[a]-p)*b;a=s+l*v[2]+t*v[1]+e*v[0],y.values[a]=d+(f-d)*o}}}else for(let n=0;n<g;++n){const r=g>1?s*(p-1)+n*f:.5*(s+a)*(p-1);if(r<0||r>p-1){for(let s=0;s<d;s++){const r=s+n*v[2]+t*v[1]+e*v[0];y.values[r]=u}continue}const o=Math.round(r),l=Math.round(c);for(let s=0;s<d;s++){const r=s+o*k[2]+l*k[1]+i*k[0],a=s+n*v[2]+t*v[1]+e*v[0];y.values[a]=w[r]}}}}return n.makeTensorInfo(y.shape,y.dtype,y.values)}};const i$={kernelName:_e,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s;lv(r,"cumsum");const l=bl([a],r.shape.length);let u=r;null!=l&&(u=kN({inputs:{x:r},backend:n,attrs:{perm:l}}));const c=wl(1,r.shape.length)[0];if(c!==u.shape.length-1)throw new Error(`backend.cumsum in CPU expects an inner-most axis=${u.shape.length-1} but got axis=${c}`);const h=Ds(u.dtype,"int32"),d=B(p(u.shape),h),f=n.data.get(u.dataId).values,m=u.shape[u.shape.length-1],g=o?(e,t)=>e+m-t-1:(e,t)=>e+t;for(let e=0;e<f.length;e+=m)for(let t=0;t<m;t++){const n=g(e,t);if(0===t)d[n]=i?0:f[n];else{const s=g(e,t-1);d[n]=i?f[s]+d[s]:f[n]+d[s]}}const y=n.makeTensorInfo(u.shape,h,d);if(null!=l){const e=kN({inputs:{x:y},backend:n,attrs:{perm:xl(l)}});return n.disposeIntermediateTensorInfo(y),n.disposeIntermediateTensorInfo(u),e}return y}};const o$={kernelName:Me,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i,binaryOutput:o}=s;if(1===r.shape.length){const e=Ev(n.data.get(r.dataId).values,n.data.get(a.dataId).values,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,e)}if(2===r.shape.length){const e=Av(n.bufferSync(r),n.bufferSync(a),i,o);return n.makeTensorInfo(e.shape,a.dtype,e.values)}throw new Error(`Error in denseBincount: input must be at most rank 2, but got rank${r.shape.length}.`)}};const l$={kernelName:Le,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockSize:a,dataFormat:i}=s;l("NHWC"===i,(()=>`Only NHWC dataFormat supported on CPU for depthToSpace. Got ${i}`)),l(a>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${a}`));const o=r.shape[0],u=r.shape[1],c=r.shape[2],h=r.shape[3],p=u*a,d=c*a,f=h/(a*a),m=n.data.get(r.dataId).values,g=new Float32Array(o*p*d*f);let y=0;for(let e=0;e<o;++e)for(let t=0;t<p;++t){const n=Math.floor(t/a),s=t%a;for(let t=0;t<d;++t){const r=Math.floor(t/a),i=(s*a+t%a)*f;for(let t=0;t<f;++t){const s=t+i+h*(r+c*(n+u*e));g[y++]=m[s]}}}return n.makeTensorInfo([o,p,d,f],r.dtype,g)}};function u$(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:u,dimRoundingMode:c}=s;lv([r,a],"depthwiseConv2DNative");const h=O(r.shape),p=O(a.shape);let d=u;null==d&&(d=[1,1]),l(Pi(i,d),(()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${i} and dilations '${d}'`));const f=Fi(r.shape,a.shape,i,d,o,c,!0),{filterHeight:m,filterWidth:g,dilationHeight:y,dilationWidth:b,padInfo:x}=f,w=x.left,k=x.top,v=f.outChannels/f.inChannels,N=new ws(f.outShape,r.dtype),I=n.data.get(r.dataId).values,$=n.data.get(a.dataId).values,C=N.values;for(let e=0;e<f.batchSize;++e){const t=e*h[0],n=e*N.strides[0];for(let e=0;e<f.outHeight;++e){const s=n+e*N.strides[1],r=e*f.strideHeight-k;for(let e=0;e<m;++e){const n=r+e*y;if(n<0||n>=f.inHeight)continue;const a=e*p[0],i=t+n*h[1];for(let e=0;e<f.outWidth;++e){const t=s+e*N.strides[2],n=e*f.strideWidth-w;for(let e=0;e<g;++e){const s=n+e*b;if(s<0||s>=f.inWidth)continue;const r=a+e*p[1],o=i+s*f.inChannels;let l=t,u=r;for(let e=0;e<f.inChannels;++e){const t=I[o+e];for(let e=0;e<v;++e)C[l+e]+=t*$[u+e];l+=v,u+=v}}}}}}return n.makeTensorInfo(N.shape,N.dtype,N.values)}const c$={kernelName:ze,backendName:"cpu",kernelFunc:u$};const h$={kernelName:Be,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,filterShape:c}=s;lv([r,a],"depthwiseConv2dNativeBackpropFilter");const h=Fi(r.shape,c,i,o,l,u,!0),{strideHeight:p,strideWidth:d,filterHeight:f,filterWidth:m}=h,g=new ws(h.filterShape,"float32"),y=h.padInfo.left,b=h.padInfo.top,x=h.outChannels/h.inChannels,w=n.data.get(r.dataId).values,k=new ws(r.shape,r.dtype,w),v=n.data.get(a.dataId).values,N=new ws(a.shape,a.dtype,v);for(let e=0;e<f;++e){const t=Math.max(0,Math.ceil((b-e)/p)),n=Math.min(h.outHeight,(h.inHeight+b-e)/p);for(let s=0;s<m;++s){const r=Math.max(0,Math.ceil((y-s)/d)),a=Math.min(h.outWidth,(h.inWidth+y-s)/d);for(let i=0;i<h.outChannels;++i){const o=Math.trunc(i/x),l=i%x;let u=0;for(let l=0;l<h.batchSize;++l)for(let c=t;c<n;++c){const t=e+c*p-b;for(let e=r;e<a;++e){const n=s+e*d-y;u+=k.get(l,t,n,o)*N.get(l,c,e,i)}}g.set(u,e,s,o,l)}}}return n.makeTensorInfo(g.shape,g.dtype,g.values)}};const p$={kernelName:Pe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,inputShape:c}=s;lv([r,a],"depthwiseConv2DNativeBackpropInput");const h=O(r.shape),p=O(a.shape),d=Fi(c,a.shape,i,o,l,u,!0),f=new ws(d.inShape,"float32"),m=f.values,[g,y,b]=f.strides,x=n.data.get(r.dataId).values,[w,k,v]=h,N=n.data.get(a.dataId).values,[I,$,C]=p,{batchSize:S,filterHeight:T,filterWidth:E,inChannels:A,inHeight:R,inWidth:F,outChannels:D,outHeight:_,outWidth:M,strideHeight:L,strideWidth:z}=d,B=T-1-d.padInfo.top,P=E-1-d.padInfo.left,W=D/A;for(let e=0;e<S;++e)for(let t=0;t<A;++t)for(let n=0;n<R;++n){const s=n-B,r=Math.max(0,Math.ceil(s/L)),a=Math.min(_,(T+s)/L);for(let i=0;i<F;++i){const o=i-P,l=Math.max(0,Math.ceil(o/z)),u=Math.min(M,(E+o)/z);let c=0;for(let n=r;n<a;++n){const r=n*L-s;for(let s=l;s<u;++s){const a=w*e+k*n+v*s,i=I*(T-1-r)+$*(E-1-(s*z-o))+C*t;for(let e=0;e<W;++e){c+=x[a+(t*W+e)]*N[i+e]}}}m[g*e+y*n+b*i+t]=c}}return n.makeTensorInfo(f.shape,f.dtype,f.values)}};const d$={kernelName:We,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=p(s.shape),a=n.data.get(s.dataId).values,i=Kr([r,r],s.dtype),o=i.values;for(let e=0;e<a.length;e++)o[e*r+e]=a[e];const l=[...s.shape,...s.shape];return n.makeTensorInfo(l,i.dtype,i.values)}},f$={kernelName:Ve,backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r}=e,{strides:a,pad:i,dilations:o}=n,l=t,u=l.data.get(s.dataId).values,c=s.shape.length,h=l.data.get(r.dataId).values,d=r.shape.length,{batchSize:f,inHeight:m,inWidth:g,inChannels:y,outHeight:b,outWidth:x,padInfo:w,strideHeight:k,strideWidth:N,filterHeight:I,filterWidth:$,dilationHeight:C,dilationWidth:S,outShape:T}=Ei(s.shape,r.shape,a,i,"NHWC",o),E=p(T),A=T.length,R=v(s.dtype,E);for(let e=0;e<f;++e)for(let t=0;t<b;++t){const n=t*k-w.top;for(let a=0;a<x;++a){const i=a*N-w.left;for(let o=0;o<y;++o){let l=Number.MIN_SAFE_INTEGER;for(let t=0;t<I;++t){const a=n+t*C;if(a>=0&&a<m)for(let n=0;n<$;++n){const p=i+n*S;if(p>=0&&p<g){const i=V([e,a,p,o],c,O(s.shape)),f=V([t,n,o],d,O(r.shape)),m=u[i]+h[f];m>l&&(l=m)}}}R[V([e,t,a,o],A,O(T))]=l}}}return{dataId:l.write(is(R,s.dtype),T,s.dtype),shape:T,dtype:s.dtype}}},m$={kernelName:Ge,backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r,dy:a}=e,{strides:i,pad:o,dilations:u}=n,c=t,h=L(s.shape,c.data.get(s.dataId).values),p=L(r.shape,c.data.get(r.dataId).values),{batchSize:d,inHeight:f,inWidth:m,inChannels:g,outHeight:y,outWidth:b,padInfo:x,strideHeight:w,strideWidth:k,filterHeight:v,filterWidth:N,dilationHeight:I,dilationWidth:$,outShape:C}=Ei(s.shape,r.shape,i,o,"NHWC",u);l(a.rank===C.length,(()=>`Error in Dilation2DBackpropFilter, dy must have the same rank as output ${C.length}, but got ${a.rank}`));const S=L(C,c.data.get(a.dataId).values),T=P(r.shape,r.dtype);for(let e=0;e<d;++e)for(let t=0;t<y;++t){const n=t*w-x.top;for(let s=0;s<b;++s){const r=s*k-x.left;for(let a=0;a<g;++a){let i=Number.MIN_SAFE_INTEGER,o=0,l=0;for(let t=0;t<v;++t){const s=n+t*I;if(s>=0&&s<f)for(let n=0;n<N;++n){const u=r+n*$;if(u>=0&&u<m){const r=h[e][s][u][a]+p[t][n][a];r>i&&(i=r,o=t,l=n)}}}T[o][l][a]+=S[e][t][s][a]}}}return{dataId:c.write(is(T,s.dtype),r.shape,r.dtype),shape:r.shape,dtype:r.dtype}}},g$={kernelName:Ue,backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r,dy:a}=e,{strides:i,pad:o,dilations:u}=n,c=t,h=L(s.shape,c.data.get(s.dataId).values),p=L(r.shape,c.data.get(r.dataId).values),{batchSize:d,inHeight:f,inWidth:m,inChannels:g,outHeight:y,outWidth:b,padInfo:x,strideHeight:w,strideWidth:k,filterHeight:v,filterWidth:N,dilationHeight:I,dilationWidth:$,outShape:C}=Ei(s.shape,r.shape,i,o,"NHWC",u);l(a.rank===C.length,(()=>`Error in Dilation2DBackpropInput, dy must have the same rank as output ${C.length}, but got ${a.rank}`));const S=L(C,c.data.get(a.dataId).values),T=P(s.shape,s.dtype);for(let e=0;e<d;++e)for(let t=0;t<y;++t){const n=t*w-x.top;for(let s=0;s<b;++s){const r=s*k-x.left;for(let a=0;a<g;++a){let i=Number.MIN_SAFE_INTEGER,o=n<0?0:n,l=r<0?0:r;for(let t=0;t<v;++t){const s=n+t*I;if(s>=0&&s<f)for(let n=0;n<N;++n){const u=r+n*$;if(u>=0&&u<m){const r=h[e][s][u][a]+p[t][n][a];r>i&&(i=r,o=s,l=u)}}}T[e][o][l][a]+=S[e][t][s][a]}}}return{dataId:c.write(is(T,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};function y$(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;let o;lv(r,"sum"),o="bool"===r.dtype?kv({inputs:{x:r},backend:n,attrs:{dtype:"int32"}}):yv({inputs:{x:r},backend:n});const l=o.shape.length,u=x(a,o.shape),c=bl(u,l);let h=u,d=o;null!=c&&(d=kN({inputs:{x:o},backend:n,attrs:{perm:c}}),h=wl(h.length,l)),yl("sum",h,d.shape.length);const[f,m]=ml(d.shape,h);let g=gv(n,f,Ds(d.dtype,"int32"));const y=p(m),b=n.data.get(g.dataId).values,w=n.data.get(d.dataId).values;for(let e=0;e<b.length;++e){const t=e*y;let n=0;for(let e=0;e<y;++e)n+=w[t+e];b[e]=n}if(i){const e=g;g=iI({inputs:{x:g},backend:n,attrs:{shape:gl(g.shape,u)}}),n.disposeIntermediateTensorInfo(e)}return n.disposeIntermediateTensorInfo(o),null!=c&&n.disposeIntermediateTensorInfo(d),g}const b$={kernelName:In,backendName:"cpu",kernelFunc:y$};const x$={kernelName:je,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{equation:r}=s,a=t,{allDims:i,summedDims:o,idDims:l}=hp(r,a.length);dp(i.length,l,a);const{path:u,steps:c}=fp(o,l),h=c.length;let p=null,f=i.length;const m=[];for(let e=0;e<h;++e){for(const t of c[e]){const{permutationIndices:e,expandDims:s}=pp(f,l[t]);let r;mp(e)?r=a[t]:(r=kN({inputs:{x:a[t]},backend:n,attrs:{perm:e}}),m.push(r));const i=r.shape.slice();for(let e=0;e<s.length;++e)i.splice(s[e],0,1);d(r.shape,i)||(r=iI({inputs:{x:r},backend:n,attrs:{shape:i}}),m.push(r)),null===p?p=r:(p=dN({inputs:{a:r,b:p},backend:n}),m.push(p))}e<h-1&&(u[e]>=0&&(p=y$({inputs:{x:p},backend:n,attrs:{axis:u[e]-(i.length-f),keepDims:!1}}),m.push(p)),f--)}for(const e of m)e!==p&&n.disposeIntermediateTensorInfo(e);return p}};const w$={kernelName:Ke,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{dy:s,y:r}=t;lv([s,r],"eluGrad");const a=new Float32Array(p(r.shape)),i=n.data.get(r.dataId).values,o=n.data.get(s.dataId).values;for(let e=0;e<i.length;++e){const t=i[e];a[e]=t>=1?o[e]:o[e]*(t+1)}return n.makeTensorInfo(r.shape,"float32",a)}},k$=dv(((e,t)=>e===t?1:0)),v$=Nv(Ye,k$,null,"bool"),N$={kernelName:Ye,backendName:"cpu",kernelFunc:v$},I$=Fv(Xe,(e=>{const t=Math.sign(e),n=Math.abs(e),s=1/(1+.3275911*n);return t*(1-((((1.061405429*s-1.453152027)*s+1.421413741)*s-.284496736)*s+.254829592)*s*Math.exp(-n*n))})),$$={kernelName:Xe,backendName:"cpu",kernelFunc:I$};function C$(e){const{inputs:t,backend:n,attrs:s}=e,{input:r}=t,{dim:a}=s,i=r.shape.length,o=r.shape.slice();let u=a;return a<0&&(l(-(i+1)<=a,(()=>`Axis must be in the interval [${-(i+1)}, ${i}]`)),u=i+a+1),o.splice(u,0,1),iI({inputs:{x:r},backend:n,attrs:{shape:o}})}const S$={kernelName:Ze,backendName:"cpu",kernelFunc:C$},T$=dv(((e,t)=>e/t)),E$=Nv(He,T$),A$={kernelName:He,backendName:"cpu",kernelFunc:E$};function R$(e,t,n){const s=e.shape,r=s[0],a=s[1],i=n.data.get(e.dataId),o=i.complexTensorInfos.real,l=i.complexTensorInfos.imag,u=[r,a],c=p(u),h=k("float32",c),d=k("float32",c);for(let e=0;e<r;e++){const s=AN({inputs:{x:o},backend:n,attrs:{begin:[e,0],size:[1,a]}}),r=AN({inputs:{x:l},backend:n,attrs:{begin:[e,0],size:[1,a]}}),i=fv({inputs:{real:s,imag:r},backend:n}),{real:u,imag:c}=F$(i,t,n),p=tp(u,c);for(let t=0;t<a;t++){const n=ap(p,t);h[e*a+t]=n.real,d[e*a+t]=n.imag}n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(i)}const f=n.makeTensorInfo(u,"float32",h),m=n.makeTensorInfo(u,"float32",d),g=fv({inputs:{real:f,imag:m},backend:n});return n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}function F$(e,t,n){const s=p(e.shape),r=n.data.get(e.dataId),a=n.data.get(r.complexTensorInfos.real.dataId).values,i=n.data.get(r.complexTensorInfos.imag.dataId).values;if(0==((o=s)&o-1)){const r=D$(a,i,s,t,n),o=[e.shape[0],e.shape[1]];if(t){const e=n.makeTensorInfo(o,"float32",r.real),t=n.makeTensorInfo(o,"float32",r.imag),a=n.makeTensorInfo([],"float32",as(s,"float32")),i=yv({inputs:{x:a},backend:n}),l=A$.kernelFunc({inputs:{a:e,b:a},backend:n}),u=A$.kernelFunc({inputs:{a:t,b:i},backend:n}),c=n.data.get(l.dataId).values,h=n.data.get(u.dataId).values;return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(a),n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(u),{real:c,imag:h}}return r}return np(function(e,t,n){const s=new Float32Array(2*t);for(let r=0;r<t;r++){let a=0,i=0;for(let s=0;s<t;s++){const o=lp(r*s,t,n),l=ap(e,s);a+=l.real*o.real-l.imag*o.imag,i+=l.real*o.imag+l.imag*o.real}n&&(a/=t,i/=t),ip(s,a,i,r)}return s}(tp(a,i),s,t));var o}function D$(e,t,n,s,r){if(1===n)return{real:e,imag:t};const a=tp(e,t),i=n/2,o=sp(a),l=o.real,u=o.imag,c=[l.length],h=r.makeTensorInfo(c,"float32",l),p=r.makeTensorInfo(c,"float32",u),d=fv({inputs:{real:h,imag:p},backend:r}),f=rp(a),m=f.real,g=f.imag,y=[m.length],b=r.makeTensorInfo(y,"float32",m),x=r.makeTensorInfo(y,"float32",g),w=fv({inputs:{real:b,imag:x},backend:r}),k=D$(l,u,i,s,r),v=k.real,N=k.imag,I=[v.length],$=r.makeTensorInfo(I,"float32",v),C=r.makeTensorInfo(I,"float32",N),S=fv({inputs:{real:$,imag:C},backend:r}),T=D$(m,g,i,s,r),E=T.real,A=T.imag,R=[E.length],F=r.makeTensorInfo(R,"float32",E),D=r.makeTensorInfo(R,"float32",A),_=fv({inputs:{real:F,imag:D},backend:r}),O=op(n,s),M=[O.real.length],L=r.makeTensorInfo(M,"float32",O.real),z=r.makeTensorInfo(M,"float32",O.imag),B=fv({inputs:{real:L,imag:z},backend:r}),P=dN({inputs:{a:B,b:_},backend:r}),W=Sv({inputs:{a:S,b:P},backend:r}),V=PN({inputs:{a:S,b:P},backend:r}),U=xv({inputs:{input:W},backend:r}),G=xv({inputs:{input:V},backend:r}),H=GI({inputs:{input:W},backend:r}),j=GI({inputs:{input:V},backend:r}),q=jI({inputs:[U,G],backend:r,attrs:{axis:0}}),K=jI({inputs:[H,j],backend:r,attrs:{axis:0}}),X=r.data.get(q.dataId).values,Y=r.data.get(K.dataId).values;return r.disposeIntermediateTensorInfo(h),r.disposeIntermediateTensorInfo(p),r.disposeIntermediateTensorInfo(d),r.disposeIntermediateTensorInfo(b),r.disposeIntermediateTensorInfo(x),r.disposeIntermediateTensorInfo(w),r.disposeIntermediateTensorInfo($),r.disposeIntermediateTensorInfo(C),r.disposeIntermediateTensorInfo(S),r.disposeIntermediateTensorInfo(F),r.disposeIntermediateTensorInfo(D),r.disposeIntermediateTensorInfo(_),r.disposeIntermediateTensorInfo(L),r.disposeIntermediateTensorInfo(z),r.disposeIntermediateTensorInfo(B),r.disposeIntermediateTensorInfo(P),r.disposeIntermediateTensorInfo(W),r.disposeIntermediateTensorInfo(V),r.disposeIntermediateTensorInfo(U),r.disposeIntermediateTensorInfo(H),r.disposeIntermediateTensorInfo(G),r.disposeIntermediateTensorInfo(j),r.disposeIntermediateTensorInfo(q),r.disposeIntermediateTensorInfo(K),{real:X,imag:Y}}const _$={kernelName:et,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t,r=p(s.shape),a=s.shape[s.shape.length-1],i=iI({inputs:{x:s},backend:n,attrs:{shape:[r/a,a]}}),o=R$(i,!1,n),l=iI({inputs:{x:o},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),l}};function O$(e){const{backend:t,attrs:n}=e,{shape:s,value:r,dtype:a}=n,i=a||F(r),o=v(i,p(s));return function(e,t,n){e.fill(t)}(o,r),t.makeTensorInfo(s,i,o)}const M$={kernelName:tt,backendName:"cpu",kernelFunc:O$};const L$={kernelName:nt,backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,r=n,a=k(s.dtype,p(s.shape)),[i,o,l,u]=s.shape,c=r.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*l*o*u;for(let e=0;e<o;e++){const n=e*(l*u);for(let s=0;s<l;s++){const r=s*u;for(let o=0;o<u;o++){const h=[i,e,s,o][2],p=Math.round(l-h),d=t+n+r+o;let f=c[d];if(p>=0&&p<l){f=c[t+n+p*u+o]}a[d]=f}}}}return{dataId:r.write(a,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},z$=dv(((e,t)=>Math.floor(e/t))),B$=Nv(rt,z$,null,"int32"),P$={kernelName:rt,backendName:"cpu",kernelFunc:B$};const W$={kernelName:Xn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s;let m=KI({inputs:{x:r,filter:a},backend:n,attrs:{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p}});if(i){const e=m;m=Sv({inputs:{a:m,b:i},backend:n}),n.disposeIntermediateTensorInfo(e)}if(d){const e=m;m=aI(n,m,d,o,f),n.disposeIntermediateTensorInfo(e)}return m}};const V$={kernelName:Yn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s;let m=u$({inputs:{x:r,filter:a},backend:n,attrs:{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p}});if(i){const e=m;m=Sv({inputs:{a:m,b:i},backend:n}),n.disposeIntermediateTensorInfo(e)}if(d){const e=m;m=aI(n,m,d,o,f),n.disposeIntermediateTensorInfo(e)}return m}};const U$={kernelName:ot,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{params:s,indices:r}=t,a=p(s.shape),i=r.shape,o=i[i.length-1],[l,u,c,h]=Ia(s,r);if(0===u)return n.makeTensorInfo(l,s.dtype,[]);const d=Kr([u,c],s.dtype),f=n.data.get(r.dataId).values,m=n.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=[];let n=0;for(let s=0;s<o;s++){const r=f[e*o+s];n+=r*h[s],t.push(r)}if(n<0||n>=a/c)throw new Error(`Invalid indices: ${t} does not index into ${s.shape}`);for(let t=0;t<c;t++)d.values[e*c+t]=m[n*c+t]}return n.makeTensorInfo(l,d.dtype,d.values)}};const G$={kernelName:it,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,indices:a}=t,{axis:i,batchDims:o}=s;lv([r,a],"gatherV2");let l=o;null==o&&(l=0);const u=p(a.shape),c=wp(r,a,x(i,r.shape)[0],l),h=iI({inputs:{x:r},backend:n,attrs:{shape:[c.batchSize,c.outerSize,c.dimSize,c.sliceSize]}}),d=iI({inputs:{x:a},backend:n,attrs:{shape:[c.batchSize,u/c.batchSize]}}),f=[c.batchSize,c.outerSize,u/c.batchSize,c.sliceSize],m=n.bufferSync(d),g=qv(n.bufferSync(h),m,f);return n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(d),n.makeTensorInfo(c.outputShape,g.dtype,g.values)}},H$=dv(((e,t)=>e>=t?1:0)),j$=Nv(ut,H$,null,"bool"),q$={kernelName:ut,backendName:"cpu",kernelFunc:j$};const K$={kernelName:ht,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t,r=p(s.shape),a=s.shape[s.shape.length-1],i=iI({inputs:{x:s},backend:n,attrs:{shape:[r/a,a]}}),o=R$(i,!0,n),l=iI({inputs:{x:o},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),l}},X$=Fv(dt,(e=>Number.isFinite(e)?1:0),"bool"),Y$={kernelName:dt,backendName:"cpu",kernelFunc:X$},J$=Fv(ft,(e=>Math.abs(e)===1/0?1:0),"bool"),Z$={kernelName:ft,backendName:"cpu",kernelFunc:J$},Q$=Fv(mt,(e=>Number.isNaN(e)?1:0),"bool"),eC={kernelName:mt,backendName:"cpu",kernelFunc:Q$},tC=dv(((e,t)=>e<=t?1:0)),nC=Nv(bt,tC,null,"bool"),sC={kernelName:bt,backendName:"cpu",kernelFunc:nC};const rC={kernelName:xt,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,num:a}=n,i=eN(s,r,a);return t.makeTensorInfo([i.length],"float32",i)}},aC=Fv(kt,(e=>Math.log1p(e))),iC={kernelName:kt,backendName:"cpu",kernelFunc:aC},oC=dv(((e,t)=>e&&t)),lC=Nv(vt,oC,null,"bool"),uC={kernelName:vt,backendName:"cpu",kernelFunc:lC},cC=Fv(Nt,(e=>e?0:1),"bool"),hC={kernelName:Nt,backendName:"cpu",kernelFunc:cC},pC=dv(((e,t)=>e||t)),dC=Nv(It,pC,null,"bool"),fC={kernelName:It,backendName:"cpu",kernelFunc:dC};const mC={kernelName:Ct,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{depthRadius:a,bias:i,alpha:o,beta:l}=s;lv(r,"LRN");const u=r.shape[3],c=u-1,h=n.data.get(r.dataId).values,d=p(r.shape),f=new Float32Array(d);function m(e){const t=e%u;let n=e-t+Math.max(0,t-a);const s=e-t+Math.min(t+a,c);let r=0;for(;n<=s;n++){const e=h[n];r+=e*e}return r}for(let e=0;e<d;e++){const t=m(e),n=h[e]*Math.pow(i+o*t,-l);f[e]=n}return n.makeTensorInfo(r.shape,r.dtype,f)}};const gC={kernelName:St,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,y:a,dy:i}=t,{depthRadius:o,bias:l,alpha:u,beta:c}=s;lv(i,"LRNGrad");const h=p(i.shape),d=i.shape[3],f=n.data.get(i.dataId).values,m=n.data.get(r.dataId).values,g=n.data.get(a.dataId).values,y=new Float32Array(h),b=h;for(let e=0;e<b;e++){const t=e%d,n=e-t+Math.max(0,t-o),s=e-t+Math.min(d,t+o+1);let r=0;for(let e=n;e<s;e++)r+=Math.pow(m[e],2);r=u*r+l;for(let t=n;t<s;t++){let n=-2*u*c*m[t]*g[e]/r;e===t&&(n+=Math.pow(r,-c)),n*=f[e],y[t]+=n}}return n.makeTensorInfo(i.shape,r.dtype,y)}};function yC(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reductionIndices:a,keepDims:i}=s,o=n;let l=r.shape;const u=l.length,c=x(a,l);let h=c;const d=bl(h,u);let f=o.data.get(r.dataId).values;if(null!=d){const e=new Array(u);for(let t=0;t<e.length;t++)e[t]=l[d[t]];f=wN(f,l,r.dtype,d,e),h=wl(h.length,u),l=e}lv(r,"max"),yl("max",h,u);const[m,g]=ml(l,h),y=rN(f,p(g),m,r.dtype),b=o.write(y,m,r.dtype);let w=m;if(i){w=gl(m,c)}return{dataId:b,shape:w,dtype:r.dtype}}const bC={kernelName:Tt,backendName:"cpu",kernelFunc:yC};const xC={kernelName:At,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;lv(r,"maxPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:u}=s;l(Pi(i,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`));const c=Ai(r.shape,a,i,1,o,u);let h;if(1===c.filterWidth&&1===c.filterHeight&&d(c.inShape,c.outShape))h=yv({inputs:{x:r},backend:n});else{const e=n.data.get(r.dataId).values,t=O(r.shape),s=RI(e,r.shape,r.dtype,t,c,"max");h=n.makeTensorInfo(c.outShape,r.dtype,s.values)}return h}};const wC={kernelName:Ft,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s;lv(r,"maxPool3d");const c=Ri(r.shape,a,i,1,o,l,u),h=DI(n.data.get(r.dataId).values,r.shape,r.dtype,O(r.shape),c,"max");return n.makeTensorInfo(h.shape,"float32",h.values)}};const kC={kernelName:Dt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,{filterSize:i,strides:o,pad:l,dimRoundingMode:u}=s;lv([r,a],"maxPool3DGrad");const c=Ri(a.shape,i,o,1,l,u),h=function(e,t){const n=Kr(t.outShape,"int32"),s=t.strideDepth,r=t.strideHeight,a=t.strideWidth,i=t.dilationDepth,o=t.dilationHeight,l=t.dilationWidth,u=t.effectiveFilterDepth,c=t.effectiveFilterHeight,h=t.effectiveFilterWidth,p=t.padInfo.front,d=t.padInfo.top,f=t.padInfo.left;for(let m=0;m<t.batchSize;++m)for(let g=0;g<t.inChannels;++g)for(let y=0;y<t.outDepth;++y){const b=y*s-p;let x=b;for(;x<0;)x+=i;const w=Math.min(t.inDepth,u+b);for(let s=0;s<t.outHeight;++s){const u=s*r-d;let p=u;for(;p<0;)p+=o;const k=Math.min(t.inHeight,c+u);for(let r=0;r<t.outWidth;++r){const d=r*a-f;let v=d;for(;v<0;)v+=l;const N=Math.min(t.inWidth,h+d);let I=Number.NEGATIVE_INFINITY,$=-1;for(let t=x;t<w;t+=i){const n=t-b;for(let s=p;s<k;s+=o){const r=s-u;for(let a=v;a<N;a+=l){const i=a-d,o=e.get(m,t,s,a,g);o>=I&&(I=o,$=n*c*h+r*c+i)}}}n.set($,m,y,s,r,g)}}}return n}(n.bufferSync(a),c),p=c.strideDepth,d=c.strideHeight,f=c.strideWidth,m=c.dilationDepth,g=c.dilationHeight,y=c.dilationWidth,b=c.effectiveFilterDepth,x=c.effectiveFilterHeight,w=c.effectiveFilterWidth,k=b-1-c.padInfo.front,v=w-1-c.padInfo.left,N=x-1-c.padInfo.top,I=Kr(a.shape,"float32"),$=n.bufferSync(r);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inDepth;++n)for(let s=0;s<c.inHeight;++s)for(let r=0;r<c.inWidth;++r){const a=n-k,i=s-N,o=r-v;let l=0;for(let n=0;n<b;n+=m){const s=(a+n)/p;if(!(s<0||s>=c.outDepth||Math.floor(s)!==s))for(let r=0;r<x;r+=g){const a=(i+r)/d;if(!(a<0||a>=c.outHeight||Math.floor(a)!==a))for(let i=0;i<w;i+=y){const u=(o+i)/f;if(u<0||u>=c.outWidth||Math.floor(u)!==u)continue;const p=b*x*w-1-h.get(e,s,a,u,t)===n*x*w+r*w+i?1:0;if(0===p)continue;l+=$.get(e,s,a,u,t)*p}}}I.set(l,e,n,s,r,t)}return n.makeTensorInfo(I.shape,I.dtype,I.values)}};const vC={kernelName:Rt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a,output:i}=t,o=a;lv([a,i],"maxPoolGrad");const{filterSize:l,strides:u,pad:c,dimRoundingMode:h}=s,p=Ai(o.shape,l,u,1,c,h),d=n.data.get(o.dataId).values,f=Kr(p.outShape,o.dtype,FI(d,o.shape,o.dtype,p).values),m=p.strideHeight,g=p.strideWidth,y=p.dilationHeight,b=p.dilationWidth,x=p.effectiveFilterHeight,w=p.effectiveFilterWidth,k=w-1-p.padInfo.left,v=x-1-p.padInfo.top,N=Kr(o.shape,"float32"),I=n.data.get(r.dataId).values,$=Kr(r.shape,"float32",I);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inHeight;++n)for(let s=0;s<p.inWidth;++s){const r=n-v,a=s-k;let i=0;for(let n=0;n<x;n+=y){const s=(r+n)/m;if(!(s<0||s>=p.outHeight||Math.floor(s)!==s))for(let r=0;r<w;r+=b){const o=(a+r)/g;if(o<0||o>=p.outWidth||Math.floor(o)!==o)continue;const l=x*w-1-f.get(e,s,o,t)===n*w+r?1:0;if(0===l)continue;i+=$.get(e,s,o,t)*l}}N.set(i,e,n,s,t)}return n.makeTensorInfo(N.shape,N.dtype,N.values)}};const NC={kernelName:_t,backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{filterSize:r,strides:a,pad:i,includeBatchInIndex:o}=t,l=n;lv(s,"MaxPoolWithArgmax");const u=l.data.get(s.dataId).values,c=Ai(s.shape,r,a,[1,1],i),[h,p]=function(e,t,n,s,r){const a=RI(e,0,n,O(t),r,"max"),i=FI(e,t,n,r,!0,s);return[a.values,i.values]}(u,s.shape,s.dtype,o,c),d=l.write(h,c.outShape,s.dtype),f=l.write(p,c.outShape,s.dtype);return[{dataId:d,shape:c.outShape,dtype:s.dtype},{dataId:f,shape:c.outShape,dtype:"int32"}]}};const IC={kernelName:Ot,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=x(a,r.shape),l=p(ml(r.shape,o)[1]),u=[],c=n.makeTensorInfo([],"float32",new Float32Array([l]));u.push(c);const h=kv({inputs:{x:r},backend:n,attrs:{dtype:"float32"}});u.push(h);const d=E$({inputs:{a:h,b:c},backend:n});u.push(d);const f=y$({inputs:{x:d},backend:n,attrs:{axis:a,keepDims:i}});return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),f}};const $C={kernelName:Mt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;lv(r,"min");const o=x(a,r.shape);let l=o;const u=bl(l,r.shape.length);let c=r;null!=u&&(c=kN({inputs:{x:r},backend:n,attrs:{perm:u}}),l=wl(l.length,r.shape.length)),yl("min",l,c.shape.length);const[h,d]=ml(c.shape,l),f=p(d),m=B(p(h),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];s<n&&(n=s)}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(h,c.dtype,m);if(i){const e=iI({inputs:{x:y},backend:n,attrs:{shape:gl(h,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const CC={kernelName:zt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,mode:i}=s;lv(r,"mirrorPad");const o=a.map(((e,t)=>e[0]+r.shape[t]+e[1])),l=a.map((e=>e[0])),u=a.map(((e,t)=>e[0]+r.shape[t])),c="reflect"===i?0:1,h=n.data.get(r.dataId).values,d=r.shape.length,f=O(r.shape),m=p(o),g=o.length,y=O(o),b=k(r.dtype,m);for(let e=0;e<m;e++){let t=U(e,g,y);for(let e=0;e<g;e++)t[e]<l[e]?t[e]=2*l[e]-t[e]-c:t[e]>=u[e]&&(t[e]=2*(u[e]-1)-t[e]+c);t=t.map(((e,t)=>e-l[t]));const n=V(t,d,f);b[e]=h[n]}return{dataId:n.write(b,o,r.dtype),shape:o,dtype:r.dtype}}},SC=dv(((e,t)=>{const n=e%t;return e<0&&t<0||e>=0&&t>=0?n:(n+t)%t})),TC=Nv(Bt,SC),EC={kernelName:Bt,backendName:"cpu",kernelFunc:TC};function AC(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{dim:a}=s,i=r.shape.length;let o=a;if(-1===o&&(o=i-1),o!==i-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${i} and dim was ${o}`);const l=x([o],r.shape),u=yC({inputs:{x:r},backend:n,attrs:{reductionIndices:l,keepDims:!1}}),c=gl(u.shape,l),h=iI({inputs:{x:u},backend:n,attrs:{shape:c}}),p=PN({inputs:{a:r,b:h},backend:n}),d=Bv({inputs:{x:p},backend:n}),f=y$({inputs:{x:d},backend:n,attrs:{axis:l,keepDims:!1}}),m=iI({inputs:{x:f},backend:n,attrs:{shape:c}}),g=E$({inputs:{a:d,b:m},backend:n});return n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}const RC={kernelName:Sn,backendName:"cpu",kernelFunc:AC};const FC={kernelName:Pt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{numSamples:a,seed:i,normalized:o}=s;lv(r,"multinomial");const l=o?r:AC({inputs:{logits:r},backend:n,attrs:{dim:-1}}),u=l.shape[0],c=l.shape[1],h=n.data.get(l.dataId).values,d=[u,a],f=B(p(d),"int32");for(let e=0;e<u;++e){const t=e*c,n=new Float32Array(c-1);n[0]=h[t];for(let e=1;e<n.length;++e)n[e]=n[e-1]+h[t+e];const s=uu(i.toString()),r=e*a;for(let e=0;e<a;++e){const t=s();f[r+e]=n.length;for(let s=0;s<n.length;s++)if(t<n[s]){f[r+e]=s;break}}}return o||n.disposeIntermediateTensorInfo(l),n.makeTensorInfo(d,"int32",f)}},DC=Wc;const _C={kernelName:Gt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=s;lv(r,"NonMaxSuppression");const u=n.data.get(r.dataId).values,c=n.data.get(a.dataId).values,{selectedIndices:h}=DC(u,c,i,o,l);return n.makeTensorInfo([h.length],"int32",new Int32Array(h))}},OC=Vc;const MC={kernelName:Ht,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,padToMaxOutputSize:u}=s;lv(r,"NonMaxSuppressionPadded");const c=n.data.get(r.dataId).values,h=n.data.get(a.dataId).values,{selectedIndices:p,validOutputs:d}=OC(c,h,i,o,l,u);return[n.makeTensorInfo([p.length],"int32",new Int32Array(p)),n.makeTensorInfo([],"int32",new Int32Array([d]))]}},LC=Uc;const zC={kernelName:jt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,softNmsSigma:u}=s;lv(r,"NonMaxSuppressionWithScore");const c=n.data.get(r.dataId).values,h=n.data.get(a.dataId).values,p=i,d=o,f=l,m=u,{selectedIndices:g,selectedScores:y}=LC(c,h,p,d,f,m);return[n.makeTensorInfo([g.length],"int32",new Int32Array(g)),n.makeTensorInfo([y.length],"float32",new Float32Array(y))]}};const BC={kernelName:Kt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r}=t,{depth:a,onValue:i,offValue:o}=s;lv(r,"oneHot");const l=p(r.shape),u=new Float32Array(l*a);u.fill(o);const c=n.data.get(r.dataId).values;for(let e=0;e<l;++e)c[e]>=0&&c[e]<a&&(u[e*a+c[e]]=i);return n.makeTensorInfo([...r.shape,a],"int32",u)}};function PC(e){const{inputs:t,backend:n}=e,{x:s}=t;if("string"===s.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===s.dtype){const e=xv({inputs:{input:s},backend:n}),t=PC({inputs:{x:e},backend:n}),r=GI({inputs:{input:s},backend:n}),a=PC({inputs:{x:r},backend:n}),i=fv({inputs:{real:t,imag:a},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(a),i}return O$({backend:n,attrs:{shape:s.shape,value:0,dtype:s.dtype}})}const WC={kernelName:Gn,backendName:"cpu",kernelFunc:PC};const VC={kernelName:qt,backendName:"cpu",kernelFunc:function e(t){const{inputs:n,backend:s}=t,{x:r}=n;if("string"===r.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===r.dtype){const t=xv({inputs:{input:r},backend:s}),n=e({inputs:{x:t},backend:s}),a=GI({inputs:{input:r},backend:s}),i=PC({inputs:{x:a},backend:s}),o=fv({inputs:{real:n,imag:i},backend:s});return s.disposeIntermediateTensorInfo(t),s.disposeIntermediateTensorInfo(n),s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}return O$({backend:s,attrs:{shape:r.shape,value:1,dtype:r.dtype}})}};function UC(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s;if(1===t.length)return C$({inputs:{input:t[0]},backend:n,attrs:{dim:r}});const a=t[0].shape,i=t[0].dtype;t.forEach((e=>{u(a,e.shape,"All tensors passed to stack must have matching shapes"),l(i===e.dtype,(()=>"All tensors passed to stack must have matching dtypes"))}));const o=[],c=jI({inputs:t.map((e=>{const t=C$({inputs:{input:e},backend:n,attrs:{dim:r}});return o.push(t),t})),backend:n,attrs:{axis:r}});return o.forEach((e=>n.disposeIntermediateTensorInfo(e))),c}const GC={kernelName:Xt,backendName:"cpu",kernelFunc:UC};const HC={kernelName:Yt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,constantValue:i}=s;lv(r,"pad");const o=a.map(((e,t)=>e[0]+r.shape[t]+e[1])),l=a.map((e=>e[0])),u=n.data.get(r.dataId).values,c=p(r.shape),h=r.shape.length,d=O(r.shape),f=p(o),m=o.length,g=O(o),y=k(r.dtype,f);0!==i&&y.fill(i);for(let e=0;e<c;e++){y[V(U(e,h,d).map(((e,t)=>e+l[t])),m,g)]=u[e]}return{dataId:n.write(y,o,r.dtype),shape:o,dtype:r.dtype}}},jC=dv(((e,t)=>Math.pow(e,t))),qC=Nv(Jt,jC),KC={kernelName:Jt,backendName:"cpu",kernelFunc:qC};const XC={kernelName:en,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,dtype:a,step:i}=n,o=$N(s,r,i,a);return t.makeTensorInfo([o.length],a,o)}},YC=Fv(nn,(e=>1/e)),JC={kernelName:nn,backendName:"cpu",kernelFunc:YC};const ZC={kernelName:ln,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s;lv(r,"resizeBilinear");const l=O(r.shape),[u,c]=o,[h,d,f,m]=r.shape,g=n.data.get(r.dataId).values,y=new Float32Array(p([h,u,c,m])),b=[a&&u>1?d-1:d,a&&c>1?f-1:f],x=[a&&u>1?u-1:u,a&&c>1?c-1:c];let w=0;const k=b[0]/x[0],v=b[1]/x[1];for(let e=0;e<h;e++)for(let t=0;t<u;t++){let n;n=i?k*(t+.5)-.5:k*t;const s=Math.max(0,Math.floor(n)),r=n-s,a=Math.min(d-1,Math.ceil(n)),o=e*l[0]+s*l[1],u=e*l[0]+a*l[1];for(let e=0;e<c;e++){let t;t=i?v*(e+.5)-.5:v*e;const n=Math.max(0,Math.floor(t)),s=t-n,a=Math.min(f-1,Math.ceil(t)),c=o+n*l[2],h=u+n*l[2],p=o+a*l[2],d=u+a*l[2];for(let e=0;e<m;e++){const t=g[c+e],n=g[h+e],a=t+(g[p+e]-t)*s,i=a+(n+(g[d+e]-n)*s-a)*r;y[w++]=i}}}return n.makeTensorInfo([h,u,c,m],"float32",y)}};const QC={kernelName:un,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s;lv([a,r],"resizeBilinearGrad");const o=O(r.shape),[l,u,c,h]=r.shape,[,p,d]=a.shape,f=new Float32Array(l*u*c*h),m=[i&&p>1?u-1:u,i&&d>1?c-1:c],g=[i&&p>1?p-1:p,i&&d>1?d-1:d],y=m[0]/g[0],b=m[1]/g[1],x=n.data.get(a.dataId).values;let w=0;for(let e=0;e<l;e++){const t=e*o[0];for(let e=0;e<p;e++){const n=e*y,s=Math.floor(n),r=Math.min(Math.ceil(n),u-1),a=t+s*o[1],i=t+r*o[1],l=n-s,p=1-l;for(let e=0;e<d;e++){const t=e*b,n=Math.floor(t),s=Math.min(Math.ceil(t),c-1),r=t-n,u=1-r,d=a+n*o[2],m=a+s*o[2],g=i+n*o[2],y=i+s*o[2],k=p*u,v=p*r,N=l*u,I=l*r;for(let e=0;e<h;e++){const t=x[w++];f[d+e]+=t*k,f[m+e]+=t*v,f[g+e]+=t*N,f[y+e]+=t*I}}}}return n.makeTensorInfo([l,c,u,h],"float32",f)}};const eS={kernelName:an,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s;lv(r,"resizeNearestNeighbor");const l=O(r.shape),[u,c]=o,[h,p,d,f]=r.shape,m=n.data.get(r.dataId).values,g=new Float32Array(h*u*c*f),y=[a&&u>1?p-1:p,a&&c>1?d-1:d],b=[a&&u>1?u-1:u,a&&c>1?c-1:c],x=y[0]/b[0],w=y[1]/b[1];let k=0;for(let e=0;e<h;e++){const t=e*l[0];for(let e=0;e<u;e++){const n=i?x*(e+.5):x*e;let s=Math.min(p-1,a?Math.round(n):Math.floor(n));i&&(s=Math.max(0,s));const r=t+s*l[1];for(let e=0;e<c;e++){const t=i?w*(e+.5):w*e;let n=Math.min(d-1,a?Math.round(t):Math.floor(t));i&&(n=Math.max(0,n));const s=r+n*l[2];for(let e=0;e<f;e++){const t=m[s+e];g[k++]=t}}}}return n.makeTensorInfo([h,u,c,f],r.dtype,g)}};const tS={kernelName:on,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s;lv([a,r],"resizeNearestNeighborGrad");const o=O(r.shape),l=O(a.shape),[u,c,h,p]=r.shape,[,d,f]=a.shape,m=new Float32Array(u*c*h*p),g=n.data.get(a.dataId).values,y=[i&&d>1?c-1:c,i&&f>1?h-1:h],b=[i&&d>1?d-1:d,i&&f>1?f-1:f],x=y[0]/b[0],w=y[1]/b[1],k=1/x,v=1/w,N=2*Math.ceil(k)+2,I=2*Math.ceil(v)+2;for(let e=0;e<u;e++){const t=e*o[0];for(let e=0;e<c;e++){const n=t+e*o[1],s=Math.floor(e*k),r=Math.floor(s-N/2);for(let s=0;s<h;s++){const a=n+s*o[2],u=Math.floor(s*v),y=Math.floor(u-I/2);for(let n=0;n<p;n++){let o=0;for(let a=0;a<N;a++){const u=a+r;if(u<0||u>=d)continue;const p=t+u*l[1],m=u*x;if(e===Math.min(c-1,i?Math.round(m):Math.floor(m)))for(let e=0;e<I;e++){const t=e+y;if(t<0||t>=f)continue;const r=p+t*l[2],a=t*w;s===Math.min(h-1,i?Math.round(a):Math.floor(a))&&(o+=g[r+n])}}m[a+n]=o}}}}return n.makeTensorInfo(r.shape,r.dtype,m)}};const nS={kernelName:hn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dims:a}=s;lv(r,"reverse");const i=r.shape.length,o=x(a,r.shape);if(0===i)return yv({inputs:{x:r},backend:n});const l=new ws(r.shape,r.dtype),u=n.bufferSync(r);for(let e=0;e<l.size;e++){const t=l.indexToLoc(e),n=t.slice();o.forEach((e=>n[e]=r.shape[e]-1-n[e])),l.set(u.get(...n),...t)}return n.makeTensorInfo(l.shape,l.dtype,l.values)}},sS={kernelName:qn,backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,{radians:r,fillValue:a,center:i}=t,o=n,l=k(s.dtype,p(s.shape)),[u,c,h,d]=s.shape,[f,m]=Ph(i,c,h),g=Math.sin(r),y=Math.cos(r),b=o.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=e*h*c*d;for(let e=0;e<c;e++){const n=e*(h*d);for(let s=0;s<h;s++){const r=s*d;for(let i=0;i<d;i++){const o=[u,e,s,i],p=o[2],x=o[1];let w=(p-f)*y-(x-m)*g,k=(p-f)*g+(x-m)*y;w=Math.round(w+f),k=Math.round(k+m);let v=a;if("number"!=typeof a&&(v=3===i?255:a[i]),w>=0&&w<h&&k>=0&&k<c){v=b[t+k*(h*d)+w*d+i]}l[t+n+r+i]=v}}}}return{dataId:o.write(l,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},rS=Fv(pn,(e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1})),aS={kernelName:pn,backendName:"cpu",kernelFunc:rS};function iS(e,t,n,s,r,a,i,o,l,u){const c=[s/r,r],h=e.values,p=t.values;if(0===s)return Kr(n,t.dtype);const d=Kr(c,t.dtype);d.values.fill(l);for(let e=0;e<a;e++){const a=[];let l=0;for(let t=0;t<i;t++){const n=h[e*i+t];a.push(n),l+=n*o[t]}if(l<0||l>=s/r)throw new Error(`Invalid indices: ${a} does not index into ${n}`);for(let n=0;n<r;n++)u?d.values[l*r+n]+=p[e*r+n]:d.values[l*r+n]=0===t.rank?p[0]:p[e*r+n]}return d}const oS={kernelName:fn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r,updates:a}=t,{shape:i}=s,{sliceRank:o,numUpdates:l,sliceSize:u,strides:c,outputSize:h}=Ta(0,r,i),p=iS(n.bufferSync(r),n.bufferSync(a),i,h,u,l,o,c,0,!0);return n.makeTensorInfo(i,p.dtype,p.values)}};const lS={kernelName:mn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{condition:s,t:r,e:a}=t;lv([s,r,a],"select");const i=s.shape.length,o=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,u=n.data.get(a.dataId).values,c=Ds(r.dtype,a.dtype),h=B(p(r.shape),c);let d=0;const f=0===i||i>1||1===r.shape.length?1:p(r.shape.slice(1));for(let e=0;e<o.length;e++)for(let t=0;t<f;t++)1===o[e]?h[d++]=l[e]:h[d++]=u[e];return n.makeTensorInfo(r.shape,c,h)}},uS=Fv(gn,(e=>e>=0?1.0507009873554805*e:1.7580993408473768*(Math.exp(e)-1))),cS={kernelName:gn,backendName:"cpu",kernelFunc:uS},hS=Fv(wn,(e=>e<0?-1:e>0?1:0)),pS={kernelName:wn,backendName:"cpu",kernelFunc:hS},dS=Fv(bn,(e=>Math.sin(e))),fS={kernelName:bn,backendName:"cpu",kernelFunc:dS},mS=Fv(xn,(e=>Math.sinh(e))),gS={kernelName:xn,backendName:"cpu",kernelFunc:mS},yS=Math.log(1.1920928955078125e-7)+2,bS=Fv(vn,(e=>{const t=e>-yS,n=e<yS,s=Math.exp(e);let r;return r=n?s:t?e:Math.log(1+s),r})),xS={kernelName:vn,backendName:"cpu",kernelFunc:bS};const wS={kernelName:$n,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,paddings:i}=s;lv([r],"spaceToBatchND");const o=p(a),l=[[0,0]];l.push(...i);for(let e=1+a.length;e<r.shape.length;++e)l.push([0,0]);const u=HC.kernelFunc({inputs:{x:r},backend:n,attrs:{paddings:l,constantValue:0}}),c=Wh(u.shape,a,o,!1),h=Vh(c.length,a.length,!1),d=Uh(u.shape,a,o,!1),f=iI({inputs:{x:u},backend:n,attrs:{shape:c}}),m=kN({inputs:{x:f},backend:n,attrs:{perm:h}}),g=iI({inputs:{x:m},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}};const kS={kernelName:Tn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{indices:s,values:r,denseShape:a,defaultValue:i}=t;if(1!==a.shape.length)throw new Error(`Dense shape must be a vector, saw:\n        ${a.shape}`);if(2!==s.shape.length)throw new Error(`Indices must be a matrix, saw:\n        ${s.shape}`);if(1!==r.shape.length)throw new Error(`Values must be a vector, saw:\n        ${r.shape}`);if(0!==i.shape.length)throw new Error(`Default value must be a scalar, saw:\n        ${i.shape}`);const o=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,u=n.data.get(a.dataId).values,c=n.data.get(i.dataId).values[0],[h,p,d,f,m]=FN(o,s.shape,s.dtype,l,r.dtype,u,c);return[n.makeTensorInfo(p,s.dtype,h),n.makeTensorInfo([p[0]],r.dtype,d),n.makeTensorInfo([f.length],"bool",new Uint8Array(f.map((e=>Number(e))))),n.makeTensorInfo([m.length],s.dtype,new Int32Array(m))]}};const vS={kernelName:En,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{inputIndices:s,inputShape:r,newShape:a}=t;if(2!==s.shape.length)throw new Error(`Input indices should be a matrix but received shape\n        ${s.shape}`);if(1!==r.shape.length)throw new Error(`Input shape should be a vector but received shape\n        ${r.shape}`);if(1!==a.shape.length)throw new Error(`Target shape should be a vector but received shape ${a.shape}`);const i=Array.from(n.data.get(r.dataId).values),o=n.data.get(s.dataId).values,l=Array.from(n.data.get(a.dataId).values),[u,c,h]=DN(o,s.shape,s.dtype,i,l);return[n.makeTensorInfo(c,s.dtype,u),n.makeTensorInfo([h.length],a.dtype,new Int32Array(h))]}};const NS={kernelName:An,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{sparseIndices:r,sparseValues:a,defaultValue:i}=t,{outputShape:o}=s,{sliceRank:l,numUpdates:u,sliceSize:c,strides:h,outputSize:p}=Ta(0,r,o),d=iS(n.bufferSync(r),n.bufferSync(a),o,p,c,u,l,h,n.data.get(i.dataId).values[0],!1);return n.makeTensorInfo(o,d.dtype,d.values)}};const IS={kernelName:Cn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{numOrSizeSplits:a,axis:i}=s,o=x(i,r.shape)[0],l=yp(r,a,o),u=new Array(r.shape.length).fill(0),c=r.shape.slice();return l.map((e=>{const t=[...c];t[o]=e;const s=AN({inputs:{x:r},backend:n,attrs:{begin:u,size:t}});return u[o]+=e,s}))}},$S=Fv(Nn,(e=>Math.sqrt(e))),CS={kernelName:Nn,backendName:"cpu",kernelFunc:$S},SS={kernelName:Fn,backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:n}=e,s=t;lv(n,"square");const r=s.data.get(n.dataId).values,a=new Float32Array(r.length);for(let e=0;e<r.length;++e){const t=r[e];a[e]=t*t}return{dataId:s.write(a,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},TS=Fv(Hn,((e,t)=>{const n=t;return isNaN(e)?NaN:e>0?1:n.alpha})),ES={kernelName:Hn,backendName:"cpu",kernelFunc:TS};const AS={kernelName:Dn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,end:i,strides:o,beginMask:l,endMask:u,ellipsisMask:c,newAxisMask:h,shrinkAxisMask:p}=s;lv(r,"stridedSlice");const{nonStrided:d,$begin:f,$strides:m,size:g,newShape:y,outShape:b}=Ha(r.shape,a,i,o,l,u,c,h,p),x=iI({inputs:{x:r},backend:n,attrs:{shape:y}});let w;if(d){const e=AN({inputs:{x:x},backend:n,attrs:{begin:f,size:g}});w=iI({inputs:{x:e},backend:n,attrs:{shape:b}}),n.disposeIntermediateTensorInfo(e)}else if(b.some((e=>0===e)))w=n.makeTensorInfo(b,r.dtype,[]);else{const e=LN(b,n.bufferSync(x),m,f);w=n.makeTensorInfo(e.shape,e.dtype,e.values)}const k=iI({inputs:{x:w},backend:n,attrs:{shape:b}});return n.disposeIntermediateTensorInfo(x),n.disposeIntermediateTensorInfo(w),k}},RS=Fv(On,(e=>Math.tan(e))),FS={kernelName:On,backendName:"cpu",kernelFunc:RS},DS=Fv(Mn,(e=>Math.tanh(e)));function _S(e,t,n){switch(n){case"reflect":return function(e,t){let n=e;if(n<0)if(t<=1)n=0;else{const e=2*t;n<e&&(n=e*Math.trunc(-n/e)+n),n=n<-t?n+e:-n-1}else if(n>t-1)if(t<=1)n=0;else{const e=2*t;n-=e*Math.trunc(n/e),n>=t&&(n=e-n-1)}return a(0,n,t-1)}(e,t);case"wrap":return function(e,t){let n=e;if(n<0)if(t<=1)n=0;else{const e=t-1;n+=t*(Math.trunc(-n/e)+1)}else if(n>t-1)if(t<=1)n=0;else{const e=t-1;n-=t*Math.trunc(n/e)}return a(0,n,t-1)}(e,t);case"nearest":return function(e,t){return a(0,e,t-1)}(e,t);case"constant":default:return function(e,t){return e}(e)}}function OS(e,t,n,s,r,a,i,o,l,u,c){return 0<=o&&o<t&&0<=l&&l<n?e[i*s+o*r+l*a+u]:c}function MS(e,t,n,s,r,a,i,o,l,u,c){return OS(e,t,n,s,r,a,i,Math.round(o),Math.round(l),u,c)}function LS(e,t,n,s,r,a,i,o,l,u,c){const h=Math.floor(o),p=Math.floor(l),d=h+1,f=p+1;return(d-o)*((f-l)*OS(e,t,n,s,r,a,i,h,p,u,c)+(l-p)*OS(e,t,n,s,r,a,i,h,f,u,c))+(o-h)*((f-l)*OS(e,t,n,s,r,a,i,d,p,u,c)+(l-p)*OS(e,t,n,s,r,a,i,d,f,u,c))}const zS=[cI,pv,pI,fI,Tv,mI,gI,yI,bI,xI,kI,NI,$I,TI,AI,_I,OI,MI,LI,uI,zI,BI,PI,vv,Mv,VI,mv,UI,qI,YI,JI,XI,QI,e$,ZI,n$,r$,a$,i$,o$,l$,c$,h$,p$,d$,f$,g$,m$,A$,x$,qN,w$,N$,$$,Pv,S$,Uv,_$,M$,L$,jv,P$,W$,V$,U$,G$,Yv,q$,bv,K$,HI,Y$,Z$,eC,XN,Qv,sC,rC,sN,iC,uC,hC,fC,mC,gC,oN,xC,wC,kC,vC,NC,bC,IC,$C,cN,CC,EC,FC,fN,gN,_C,MC,zC,xN,BC,VC,GC,HC,KC,ZN,IN,XC,wv,JC,eI,nI,oI,ZC,QC,eS,tS,nS,sS,aS,TN,oS,lS,cS,rI,pS,fS,gS,RN,RC,xS,wS,kS,vS,NS,IS,CS,SS,MN,ES,AS,WN,b$,FS,{kernelName:Mn,backendName:"cpu",kernelFunc:DS},{kernelName:Ln,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reps:a}=s;lv(r,"tile");const i=VN(n.bufferSync(r),a);return n.makeTensorInfo(i.shape,i.dtype,i.values)}},{kernelName:zn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{k:a,sorted:i}=s;lv(r,"topk");const o=n.data.get(r.dataId).values,[l,u]=UN(o,r.shape,r.dtype,a);return[n.makeTensorInfo(l.shape,l.dtype,l.values),n.makeTensorInfo(u.shape,u.dtype,u.values)]}},vN,{kernelName:Bn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{image:r,transforms:a}=t,{interpolation:i,fillMode:o,fillValue:l,outputShape:u}=n,[c,h,d,f]=r.shape,[m,g]=null!=u?u:[h,d],y=[c,m,g,f],b=O(r.shape),x=b[0],w=b[1],v=b[2],N=k(r.dtype,p(y));N.fill(l);const I=s.data.get(r.dataId).values,$=s.data.get(a.dataId).values;for(let e=0;e<c;++e){const t=1===a.shape[0]?$:$.subarray(8*e,8*e+8);for(let n=0;n<m;++n)for(let s=0;s<g;++s)for(let r=0;r<f;++r){let a;const u=t[6]*s+t[7]*n+1;if(0===u)continue;const c=(t[0]*s+t[1]*n+t[2])/u,p=(t[3]*s+t[4]*n+t[5])/u,f=_S(c,d,o),m=_S(p,h,o);switch(i){case"nearest":a=MS(I,h,d,x,w,v,e,m,f,r,l);break;case"bilinear":a=LS(I,h,d,x,w,v,e,m,f,r,l);break;default:throw new Error(`Error in Transform: Expect 'nearest' or 'bilinear', but got ${i}`)}N[e*x+n*w+s*v+r]=a}return s.makeTensorInfo(y,r.dtype,N)}return{dataId:s.write(N,y,r.dtype),shape:r.shape,dtype:r.dtype}}},{kernelName:Wn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{axis:r}=n,{x:a}=t;lv(a,"unique");const i=s.data.get(a.dataId).values,{outputValues:o,outputShape:l,indices:u}=GN(i,r,a.shape,a.dtype);return[s.makeTensorInfo(l,a.dtype,o),s.makeTensorInfo([u.length],"int32",u)]}},{kernelName:Vn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{value:r}=t;let{axis:a}=s;a<0&&(a+=r.shape.length);const i=r.shape.length,o=r.shape[a],l=new Array(i-1);let u=0;for(let e=0;e<i;e++)e!==a&&(l[u++]=r.shape[e]);const c=new Array(i).fill(0),h=r.shape.slice();h[a]=1;const p=new Array(o);for(let e=0;e<p.length;e++){c[a]=e;const t=AN({inputs:{x:r},backend:n,attrs:{begin:c,size:h}});p[e]=iI({inputs:{x:t},backend:n,attrs:{shape:l}}),n.disposeIntermediateTensorInfo(t)}return p}},{kernelName:Un,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,segmentIds:a}=t,{numSegments:i}=s;lv(r,"unsortedSegmentSum");const o=[],l=[],u=r.shape.length-a.shape.length;let c=a;for(let e=0;e<u;++e){const t=C$({inputs:{input:c},backend:n,attrs:{dim:e+1}});c=t,l.push(t)}for(let e=0;e<i;++e){const t=as(e,"int32"),s=n.makeTensorInfo([],"int32",t),a=v$({inputs:{a:s,b:c},backend:n}),i=kv({inputs:{x:a},backend:n,attrs:{dtype:"float32"}}),u=dN({inputs:{a:i,b:r},backend:n}),h=y$({inputs:{x:u},backend:n,attrs:{axis:0,keepDims:!1}});o.push(h),l.push(s),l.push(a),l.push(i),l.push(u),l.push(h)}const h=UC({inputs:o,backend:n,attrs:{axis:0}});return l.forEach((e=>n.disposeIntermediateTensorInfo(e))),h}},WC];for(const e of zS)ns(e);const BS={},PS={alpha:!1,antialias:!1,premultipliedAlpha:!1,preserveDrawingBuffer:!1,depth:!1,stencil:!1,failIfMajorPerformanceCaveat:!0};function WS(e){if(!(e in BS)){const t=function(e){if(1!==e&&2!==e)throw new Error("Cannot get WebGL rendering context, WebGL is disabled.");const t=function(e){if("undefined"!=typeof OffscreenCanvas&&2===e)return new OffscreenCanvas(300,150);if("undefined"!=typeof document)return document.createElement("canvas");throw new Error("Cannot create a canvas in this context")}(e);if(t.addEventListener("webglcontextlost",(t=>{t.preventDefault(),delete BS[e]}),!1),1===e)return t.getContext("webgl",PS)||t.getContext("experimental-webgl",PS);return t.getContext("webgl2",PS)}(e);if(null===t)return console.log("Could not get context for WebGL version",e),null;BS[e]=t}const t=BS[e];return t.isContextLost()?(delete BS[e],WS(e)):(t.disable(t.DEPTH_TEST),t.disable(t.STENCIL_TEST),t.disable(t.BLEND),t.disable(t.DITHER),t.disable(t.POLYGON_OFFSET_FILL),t.disable(t.SAMPLE_COVERAGE),t.enable(t.SCISSOR_TEST),t.enable(t.CULL_FACE),t.cullFace(t.BACK),BS[e])}var VS,US,GS;function HS(e,t){return[t,e]}function jS(e){const t=p(e);return m(Math.ceil(t/4))}function qS(e,t){return[Math.max(1,Math.ceil(t/2)),Math.max(1,Math.ceil(e/2))]}function KS(e,t){const n=e;let s,r,a,i,o,l,u,c,h,p;return 2===K().getNumber("WEBGL_VERSION")?(s=n.R32F,r=n.R16F,a=n.RGBA16F,i=n.RGBA32F,o=n.RED,u=4,c=1,h=n.HALF_FLOAT,p=n.FLOAT):(s=e.RGBA,r=e.RGBA,a=e.RGBA,i=n.RGBA,o=e.RGBA,u=4,c=4,h=null!=t?t.HALF_FLOAT_OES:null,p=e.FLOAT),l=e.RGBA,{internalFormatFloat:s,internalFormatHalfFloat:r,internalFormatPackedHalfFloat:a,internalFormatPackedFloat:i,textureFormatFloat:o,downloadTextureFormat:l,downloadUnpackNumChannels:u,defaultNumChannels:c,textureTypeHalfFloat:h,textureTypeFloat:p}}function XS(e,t){const n=t();return K().getBool("DEBUG")&&function(e){const t=e.getError();if(t!==e.NO_ERROR)throw new Error("WebGL Error: "+function(e,t){switch(t){case e.NO_ERROR:return"NO_ERROR";case e.INVALID_ENUM:return"INVALID_ENUM";case e.INVALID_VALUE:return"INVALID_VALUE";case e.INVALID_OPERATION:return"INVALID_OPERATION";case e.INVALID_FRAMEBUFFER_OPERATION:return"INVALID_FRAMEBUFFER_OPERATION";case e.OUT_OF_MEMORY:return"OUT_OF_MEMORY";case e.CONTEXT_LOST_WEBGL:return"CONTEXT_LOST_WEBGL";default:return`Unknown error code ${t}`}}(e,t))}(e),n}!function(e){e[e.DENSE=0]="DENSE",e[e.SHARED_BATCH=1]="SHARED_BATCH"}(VS||(VS={})),function(e){e[e.RENDER=0]="RENDER",e[e.UPLOAD=1]="UPLOAD",e[e.PIXELS=2]="PIXELS",e[e.DOWNLOAD=3]="DOWNLOAD"}(US||(US={})),function(e){e[e.UNPACKED_FLOAT16=0]="UNPACKED_FLOAT16",e[e.UNPACKED_FLOAT32=1]="UNPACKED_FLOAT32",e[e.PACKED_4X1_UNSIGNED_BYTE=2]="PACKED_4X1_UNSIGNED_BYTE",e[e.PACKED_2X2_FLOAT32=3]="PACKED_2X2_FLOAT32",e[e.PACKED_2X2_FLOAT16=4]="PACKED_2X2_FLOAT16"}(GS||(GS={}));function YS(e){return!!(K().getBool("WEBGL_RENDER_FLOAT32_ENABLED")||0===e||5.96e-8<Math.abs(e)&&Math.abs(e)<65504)}function JS(e,t){return iT(e,(()=>e.getExtension(t)),'Extension "'+t+'" not supported on this browser.')}function ZS(e,t){const n=iT(e,(()=>e.createShader(e.FRAGMENT_SHADER)),"Unable to create fragment WebGLShader.");if(XS(e,(()=>e.shaderSource(n,t))),XS(e,(()=>e.compileShader(n))),!1===e.getShaderParameter(n,e.COMPILE_STATUS))throw function(e,t){const n=QS.exec(t);if(null==n)return console.log(`Couldn't parse line number in error: ${t}`),void console.log(e);const s=+n[1],r=e.split("\n"),a=r.length.toString().length+2,i=r.map(((e,t)=>g((t+1).toString(),a)+e));let o=0;for(let e=0;e<i.length;e++)o=Math.max(i[e].length,o);const l=i.slice(0,s-1),u=i.slice(s-1,s),c=i.slice(s);console.log(l.join("\n")),console.log(t.split("\n")[0]),console.log(`%c ${g(u[0],o)}`,"border:1px solid red; background-color:#e3d2d2; color:#a61717"),console.log(c.join("\n"))}(t,e.getShaderInfoLog(n)),new Error("Failed to compile fragment shader.");return n}const QS=/ERROR: [0-9]+:([0-9]+):/g;function eT(e,t){if(XS(e,(()=>e.validateProgram(t))),!1===e.getProgramParameter(t,e.VALIDATE_STATUS))throw console.log(e.getProgramInfoLog(t)),new Error("Shader program validation failed.")}function tT(e,t,n,s,r,a,i){const o=e.getAttribLocation(t,n);return-1!==o&&(XS(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,s))),XS(e,(()=>e.vertexAttribPointer(o,r,e.FLOAT,!1,a,i))),XS(e,(()=>e.enableVertexAttribArray(o))),!0)}function nT(e,t,n,s){XS(e,(()=>function(e,t,n){oT(e,n),XS(e,(()=>e.activeTexture(e.TEXTURE0+n))),XS(e,(()=>e.bindTexture(e.TEXTURE_2D,t)))}(e,t,s))),XS(e,(()=>e.uniform1i(n,s)))}function sT(e,t,n){XS(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,n))),XS(e,(()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0)))}function rT(e,t){XS(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,t))),XS(e,(()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,null,0)))}function aT(e){const t=e.checkFramebufferStatus(e.FRAMEBUFFER);if(t!==e.FRAMEBUFFER_COMPLETE)throw new Error("Error binding framebuffer: "+function(e,t){switch(t){case e.FRAMEBUFFER_INCOMPLETE_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_DIMENSIONS:return"FRAMEBUFFER_INCOMPLETE_DIMENSIONS";case e.FRAMEBUFFER_UNSUPPORTED:return"FRAMEBUFFER_UNSUPPORTED";default:return`unknown error ${t}`}}(e,t))}function iT(e,t,n){const s=XS(e,(()=>t()));if(null==s)throw new Error(n);return s}function oT(e,t){const n=e.MAX_COMBINED_TEXTURE_IMAGE_UNITS-1,s=t+e.TEXTURE0;if(s<e.TEXTURE0||s>n){throw new Error(`textureUnit must be in ${`[gl.TEXTURE0, gl.TEXTURE${n}]`}.`)}}function lT(e,t=2){return p(e.slice(0,e.length-t))}function uT(e){if(0===e.length)throw Error("Cannot get rows and columns of an empty shape array.");return[e.length>1?e[e.length-2]:1,e[e.length-1]]}function cT(e){let t=[1,1,1];return 0===e.length||1===e.length&&1===e[0]||(t=[lT(e),...uT(e)]),t}function hT(e){return e%2==0}function pT(e,t){if(d(e=e.slice(-2),t=t.slice(-2)))return!0;if(!e.length||!t.length)return!0;if(0===e[0]||0===e[1]||0===t[0]||0===t[1])return!0;if(e.length!==t.length){const n=e.slice(-1)[0],s=t.slice(-1)[0];if(n===s)return!0;if(hT(n)&&hT(s)&&(1===e[0]||1===t[0]))return!0}return e[1]===t[1]&&hT(e[0])&&hT(t[0])}let dT,fT;function mT(e,t){return null!=e.getExtension(t)}function gT(e){try{if(null!=WS(e))return!0}catch(e){return console.log("Error when getting WebGL context: ",e),!1}return!1}function yT(e){if(0===e)return!1;const t=WS(e);if(1!==e){if(mT(t,"EXT_color_buffer_float"))return bT(t);const e="EXT_color_buffer_half_float";if(mT(t,e)){const n=t.getExtension(e);return function(e,t){const n=KS(e,t),s=e.createTexture();e.bindTexture(e.TEXTURE_2D,s);const r=1,a=1;e.texImage2D(e.TEXTURE_2D,0,n.internalFormatHalfFloat,r,a,0,n.textureFormatFloat,n.textureTypeHalfFloat,null);const i=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,i),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,s,0);const o=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(s),e.deleteFramebuffer(i),o}(t,n)}return!1}if(!mT(t,"OES_texture_float"))return!1;if(!mT(t,"WEBGL_color_buffer_float"))return!1;return bT(t)}function bT(e){const t=KS(e),n=e.createTexture();e.bindTexture(e.TEXTURE_2D,n);e.texImage2D(e.TEXTURE_2D,0,t.internalFormatFloat,1,1,0,t.textureFormatFloat,t.textureTypeFloat,null);const s=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,s),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,n,0);const r=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(n),e.deleteFramebuffer(s),r}function xT(e,t){Array.isArray(e)||(e=[e]),e.forEach((e=>{null!=e&&l("complex64"!==e.dtype,(()=>`${t} does not support complex64 tensors in the WebGL backend.`))}))}const wT=K();function kT(){let e,t,n,s,r,a,i,o,l,u;return 2===K().getNumber("WEBGL_VERSION")?(e="#version 300 es",t="in",n="out",s="in",r="texture",a="outputColor",i="out vec4 outputColor;",o="\n      bool isnan_custom(float val) {\n        return (val > 0.0 || val < 0.0) ? false : val != 0.0;\n      }\n\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan_custom(val.x),\n          isnan_custom(val.y), isnan_custom(val.z), isnan_custom(val.w));\n      }\n\n      #define isnan(value) isnan_custom(value)\n    ",l="",u="\n      #define round(value) newRound(value)\n      int newRound(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 newRound(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "):(e="",t="attribute",n="varying",s="varying",r="texture2D",a="gl_FragColor",i="",o="\n      #define isnan(value) isnan_custom(value)\n      bool isnan_custom(float val) {\n        return (val > 0. || val < 1. || val == 0.) ? false : true;\n      }\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan(val.x), isnan(val.y), isnan(val.z), isnan(val.w));\n      }\n    ",l="\n      uniform float INFINITY;\n\n      bool isinf(float val) {\n        return abs(val) == INFINITY;\n      }\n      bvec4 isinf(vec4 val) {\n        return equal(abs(val), vec4(INFINITY));\n      }\n    ",u="\n      int round(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 round(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "),{version:e,attribute:t,varyingVs:n,varyingFs:s,texture2D:r,output:a,defineOutput:i,defineSpecialNaN:o,defineSpecialInf:l,defineRound:u}}function vT(e,t,n="index"){const s=O(t);return s.map(((t,r)=>`${`int ${e[r]} = ${n} / ${t}`}; ${r===s.length-1?`int ${e[r+1]} = ${n} - ${e[r]} * ${t}`:`index -= ${e[r]} * ${t}`};`)).join("")}function NT(e){const t=O(e).map((e=>e.toString()));return`\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * ${t[0]} + coords.y * ${t[1]} + coords.z;\n  }\n`}wT.registerFlag("HAS_WEBGL",(()=>wT.getNumber("WEBGL_VERSION")>0)),wT.registerFlag("WEBGL_VERSION",(()=>gT(2)?2:gT(1)?1:0)),wT.registerFlag("WEBGL_CHECK_NUMERICAL_PROBLEMS",(()=>!1)),wT.registerFlag("WEBGL_BUFFER_SUPPORTED",(()=>2===wT.get("WEBGL_VERSION"))),wT.registerFlag("WEBGL_CPU_FORWARD",(()=>!0)),wT.registerFlag("WEBGL_FORCE_F16_TEXTURES",(()=>!1)),wT.registerFlag("WEBGL_PACK",(()=>wT.getBool("HAS_WEBGL"))),wT.registerFlag("WEBGL_PACK_NORMALIZATION",(()=>wT.getBool("WEBGL_PACK"))),wT.registerFlag("WEBGL_PACK_CLIP",(()=>wT.getBool("WEBGL_PACK"))),wT.registerFlag("WEBGL_PACK_DEPTHWISECONV",(()=>wT.getBool("WEBGL_PACK"))),wT.registerFlag("WEBGL_PACK_BINARY_OPERATIONS",(()=>wT.getBool("WEBGL_PACK"))),wT.registerFlag("WEBGL_PACK_UNARY_OPERATIONS",(()=>wT.getBool("WEBGL_PACK"))),wT.registerFlag("WEBGL_PACK_ARRAY_OPERATIONS",(()=>wT.getBool("WEBGL_PACK"))),wT.registerFlag("WEBGL_PACK_IMAGE_OPERATIONS",(()=>wT.getBool("WEBGL_PACK"))),wT.registerFlag("WEBGL_PACK_REDUCE",(()=>wT.getBool("WEBGL_PACK"))),wT.registerFlag("WEBGL_LAZILY_UNPACK",(()=>wT.getBool("WEBGL_PACK"))),wT.registerFlag("WEBGL_CONV_IM2COL",(()=>wT.getBool("WEBGL_PACK"))),wT.registerFlag("WEBGL_MAX_TEXTURE_SIZE",(()=>function(e){if(null==dT){const t=WS(e);dT=t.getParameter(t.MAX_TEXTURE_SIZE)}return dT}(wT.getNumber("WEBGL_VERSION")))),wT.registerFlag("WEBGL_MAX_TEXTURES_IN_SHADER",(()=>function(e){if(null==fT){const t=WS(e);fT=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS)}return Math.min(16,fT)}(wT.getNumber("WEBGL_VERSION")))),wT.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION",(()=>{const e=wT.getNumber("WEBGL_VERSION");return 0===e?0:function(e){if(0===e)return 0;let t;const n=WS(e);return t=mT(n,"EXT_disjoint_timer_query_webgl2")&&2===e?2:mT(n,"EXT_disjoint_timer_query")?1:0,t}(e)})),wT.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE",(()=>wT.getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0&&!qs())),wT.registerFlag("WEBGL_RENDER_FLOAT32_CAPABLE",(()=>function(e){if(0===e)return!1;const t=WS(e);if(1===e){if(!mT(t,"OES_texture_float"))return!1}else if(!mT(t,"EXT_color_buffer_float"))return!1;return bT(t)}(wT.getNumber("WEBGL_VERSION")))),wT.registerFlag("WEBGL_RENDER_FLOAT32_ENABLED",(()=>!wT.getBool("WEBGL_FORCE_F16_TEXTURES")&&wT.getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))),wT.registerFlag("WEBGL_DOWNLOAD_FLOAT_ENABLED",(()=>yT(wT.getNumber("WEBGL_VERSION")))),wT.registerFlag("WEBGL_FENCE_API_ENABLED",(()=>{return 2===(e=wT.getNumber("WEBGL_VERSION"))&&null!=WS(e).fenceSync;var e})),wT.registerFlag("WEBGL_SIZE_UPLOAD_UNIFORM",(()=>wT.getBool("WEBGL_RENDER_FLOAT32_ENABLED")?4:0)),wT.registerFlag("WEBGL_DELETE_TEXTURE_THRESHOLD",(()=>-1),(e=>{if(e<0&&-1!==e)throw new Error(`WEBGL_DELETE_TEXTURE_THRESHOLD must be -1 (indicating never delete) or at least 0, but got ${e}.`)})),wT.registerFlag("WEBGL_FLUSH_THRESHOLD",(()=>qs()&&wT.getBool("IS_CHROME")?1:-1),(e=>{if(e<0&&-1!==e)throw new Error(`WEBGL_FLUSH_THRESHOLD must be -1 (indicating never manual flush) or at least 0, but got ${e}.`)}));const IT="\n  const float FLOAT_MAX = 1.70141184e38;\n  const float FLOAT_MIN = 1.17549435e-38;\n\n  lowp vec4 encode_float(highp float v) {\n    if (isnan(v)) {\n      return vec4(255, 255, 255, 255);\n    }\n\n    highp float av = abs(v);\n\n    if(av < FLOAT_MIN) {\n      return vec4(0.0, 0.0, 0.0, 0.0);\n    } else if(v > FLOAT_MAX) {\n      return vec4(0.0, 0.0, 128.0, 127.0) / 255.0;\n    } else if(v < -FLOAT_MAX) {\n      return vec4(0.0, 0.0,  128.0, 255.0) / 255.0;\n    }\n\n    highp vec4 c = vec4(0,0,0,0);\n\n    highp float e = floor(log2(av));\n    highp float m = exp2(fract(log2(av))) - 1.0;\n\n    c[2] = floor(128.0 * m);\n    m -= c[2] / 128.0;\n    c[1] = floor(32768.0 * m);\n    m -= c[1] / 32768.0;\n    c[0] = floor(8388608.0 * m);\n\n    highp float ebias = e + 127.0;\n    c[3] = floor(ebias / 2.0);\n    ebias -= c[3] * 2.0;\n    c[2] += floor(ebias) * 128.0;\n\n    c[3] += 128.0 * step(0.0, -v);\n\n    return c / 255.0;\n  }\n";class $T{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outPackingScheme=VS.DENSE;const t=jS(e),n=kT();this.outputShape=e,this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${vT(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n          vec2(${t[0]}, ${t[1]}));\n        int index = 4 * (resTexRC.x * ${t[1]} + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getA(rc.x, rc.y, rc.z);\n        }\n\n        ${n.output} = result;\n      }\n    `}}class CT{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outPackingScheme=VS.DENSE;const t=jS(e),n=kT();this.outputShape=e,this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${vT(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n          vec2(${t[0]}, ${t[1]}));\n        int index = 4 * (resTexRC.x * ${t[1]} + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getChannel(getA(rc.x, rc.y, rc.z), vec2(rc.y, rc.z));\n        }\n\n        ${n.output} = result;\n      }\n    `}}class ST{constructor(e){this.variableNames=["A"],this.outTexUsage=US.DOWNLOAD;const t=kT();this.outputShape=e,this.userCode=`\n      ${IT}\n\n      void main() {\n        float x = getAAtOutCoords();\n        ${t.output} = encode_float(x);\n      }\n    `}}class TT{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outTexUsage=US.DOWNLOAD;const t=kT();this.outputShape=e,this.userCode=`\n      ${IT}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n        float x = getChannel(getAAtOutCoords(), vec2(coords.y, coords.z));\n        ${t.output} = encode_float(x);\n      }\n    `}}class ET{constructor(e,t,n=!1){this.variableNames=["A"];const s=kT(),[r,a]=t;this.outputShape=e;let i="result";n&&(i="floor(result * 255. + 0.5)"),this.userCode=`\n      ${NT(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        int flatIndex = getFlatIndex(coords);\n        int offset = imod(flatIndex, 4);\n\n        flatIndex = idiv(flatIndex, 4, 1.);\n\n        int r = flatIndex / ${a};\n        int c = imod(flatIndex, ${a});\n        vec2 uv = (vec2(c, r) + halfCR) / vec2(${a}.0, ${r}.0);\n        vec4 values = ${s.texture2D}(A, uv);\n\n        float result;\n\n        if(offset == 0) {\n          result = values[0];\n        } else if(offset == 1) {\n          result = values[1];\n        } else if(offset == 2) {\n          result = values[2];\n        } else {\n          result = values[3];\n        }\n\n        ${s.output} = vec4(${i}, 0., 0., 0.);\n      }\n    `}}class AT{constructor(e,t,n=!1){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const s=kT(),[r,a]=t;this.outputShape=e;let i="",o="result";n&&(o="floor(result * 255. + 0.5)");for(let t=0;t<=1;t++)for(let n=0;n<=1;n++){const o=2*t+n;i+=`\n          localCoords = coords;\n          if(localCoords[2] + ${n} < ${e[2]}) {\n            localCoords[2] += ${n};\n            if(localCoords[1] + ${t} < ${e[1]}) {\n              localCoords[1] += ${t};\n\n              flatIndex = getFlatIndex(localCoords);\n              offset = imod(flatIndex, 4);\n\n              flatIndex = idiv(flatIndex, 4, 1.);\n\n              r = flatIndex / ${a};\n              c = imod(flatIndex, ${a});\n              uv = (vec2(c, r) + halfCR) / vec2(${a}.0, ${r}.0);\n              values = ${s.texture2D}(A, uv);\n\n              if(offset == 0) {\n                result[${o}] = values[0];\n              } else if(offset == 1) {\n                result[${o}] = values[1];\n              } else if(offset == 2) {\n                result[${o}] = values[2];\n              } else {\n                result[${o}] = values[3];\n              }\n            }\n          }\n        `}this.userCode=`\n      ${NT(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        vec4 result = vec4(0.);\n        int flatIndex, r, c, offset;\n        ivec3 localCoords;\n        vec2 uv;\n        vec4 values;\n\n        ${i}\n\n        ${s.output} = ${o};\n      }\n    `}}function RT(e){const t=kT();return function(e,t){const n=iT(e,(()=>e.createShader(e.VERTEX_SHADER)),"Unable to create vertex WebGLShader.");if(XS(e,(()=>e.shaderSource(n,t))),XS(e,(()=>e.compileShader(n))),!1===e.getShaderParameter(n,e.COMPILE_STATUS))throw console.log(e.getShaderInfoLog(n)),new Error("Failed to compile vertex shader.");return n}(e,`${t.version}\n    precision highp float;\n    ${t.attribute} vec3 clipSpacePos;\n    ${t.attribute} vec2 uv;\n    ${t.varyingVs} vec2 resultUV;\n\n    void main() {\n      gl_Position = vec4(clipSpacePos, 1);\n      resultUV = uv;\n    }`)}function FT(e){return function(e,t){const n=iT(e,(()=>e.createBuffer()),"Unable to create WebGLBuffer");return XS(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,n))),XS(e,(()=>e.bufferData(e.ARRAY_BUFFER,t,e.STATIC_DRAW))),n}(e,new Float32Array([-1,1,0,0,1,-1,-1,0,0,0,1,1,0,1,1,1,-1,0,1,0]))}function DT(e){return function(e,t){const n=iT(e,(()=>e.createBuffer()),"Unable to create WebGLBuffer");return XS(e,(()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,n))),XS(e,(()=>e.bufferData(e.ELEMENT_ARRAY_BUFFER,t,e.STATIC_DRAW))),n}(e,new Uint16Array([0,1,2,2,1,3]))}function _T(e,t,n,s,r,a){!function(e,t){const n=K().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(e<=0||t<=0)throw new Error(`Requested texture size [${e}x${t}] is invalid.`);if(e>n||t>n)throw new Error(`Requested texture size [${e}x${t}] greater than WebGL maximum on this browser / GPU [${n}x${n}].`)}(t,n);const i=function(e){return iT(e,(()=>e.createTexture()),"Unable to create WebGLTexture.")}(e),o=e.TEXTURE_2D;return XS(e,(()=>e.bindTexture(o,i))),XS(e,(()=>e.texParameteri(o,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE))),XS(e,(()=>e.texParameteri(o,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE))),XS(e,(()=>e.texParameteri(o,e.TEXTURE_MIN_FILTER,e.NEAREST))),XS(e,(()=>e.texParameteri(o,e.TEXTURE_MAG_FILTER,e.NEAREST))),XS(e,(()=>e.texImage2D(o,0,s,t,n,0,r,a,null))),XS(e,(()=>e.bindTexture(e.TEXTURE_2D,null))),i}function OT(e){return e.internalFormatFloat}function MT(e){return e.internalFormatHalfFloat}function LT(e){return e.downloadTextureFormat}function zT(e){return e.internalFormatPackedFloat}function BT(e){return e.internalFormatPackedHalfFloat}function PT(e,t,n,s,r,a,i,o){const l=e,u=new Float32Array(function(e,t){const[n,s]=qS(e,t);return n*s*4}(a,i));return l.bindBuffer(l.PIXEL_PACK_BUFFER,t),l.getBufferSubData(l.PIXEL_PACK_BUFFER,0,u),l.bindBuffer(l.PIXEL_PACK_BUFFER,null),u}class WT{constructor(e){this.outputTexture=null,this.program=null,this.disposed=!1,this.vertexAttrsAreBound=!1,this.itemsToPoll=[];const t=K().getNumber("WEBGL_VERSION");null!=e?(this.gl=e,function(e,t){BS[e]=t}(t,e)):this.gl=WS(t);let n="WEBGL_color_buffer_float";const s="EXT_color_buffer_half_float";if(1===K().getNumber("WEBGL_VERSION")){const e="OES_texture_float",t="OES_texture_half_float";if(this.textureFloatExtension=JS(this.gl,e),mT(this.gl,t))this.textureHalfFloatExtension=JS(this.gl,t);else if(K().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support half float textures, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.");if(this.colorBufferFloatExtension=this.gl.getExtension(n),mT(this.gl,s))this.colorBufferHalfFloatExtension=JS(this.gl,s);else if(K().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support color renderable half floats, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.")}else if(n="EXT_color_buffer_float",mT(this.gl,n))this.colorBufferFloatExtension=this.gl.getExtension(n);else{if(!mT(this.gl,s))throw new Error("GL context does not support color renderable floats");this.colorBufferHalfFloatExtension=this.gl.getExtension(s)}this.vertexBuffer=FT(this.gl),this.indexBuffer=DT(this.gl),this.framebuffer=function(e){return iT(e,(()=>e.createFramebuffer()),"Unable to create WebGLFramebuffer.")}(this.gl),this.textureConfig=KS(this.gl,this.textureHalfFloatExtension)}get debug(){return K().getBool("DEBUG")}dispose(){if(this.disposed)return;null!=this.program&&console.warn("Disposing a GPGPUContext that still has a bound WebGLProgram. This is probably a resource leak, delete the program with GPGPUContext.deleteProgram before disposing."),null!=this.outputTexture&&console.warn("Disposing a GPGPUContext that still has a bound output matrix texture.  This is probably a resource leak, delete the output matrix texture with GPGPUContext.deleteMatrixTexture before disposing.");const e=this.gl;XS(e,(()=>e.finish())),XS(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,null))),XS(e,(()=>e.deleteFramebuffer(this.framebuffer))),XS(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,null))),XS(e,(()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,null))),XS(e,(()=>e.deleteBuffer(this.indexBuffer))),this.disposed=!0}createFloat32MatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=HS(t,n);return _T(e,r,a,OT(s),s.textureFormatFloat,e.FLOAT)}(this.gl,e,t,this.textureConfig)}createFloat16MatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=HS(t,n);return _T(e,r,a,MT(s),s.textureFormatFloat,s.textureTypeHalfFloat)}(this.gl,e,t,this.textureConfig)}createUnsignedBytesMatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=HS(t,n);return _T(e,r,a,LT(s),e.RGBA,e.UNSIGNED_BYTE)}(this.gl,e,t,this.textureConfig)}uploadPixelDataToTexture(e,t){this.throwIfDisposed(),function(e,t,n){XS(e,(()=>e.bindTexture(e.TEXTURE_2D,t))),n.data instanceof Uint8Array?XS(e,(()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,n.width,n.height,0,e.RGBA,e.UNSIGNED_BYTE,n.data))):XS(e,(()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,n))),XS(e,(()=>e.bindTexture(e.TEXTURE_2D,null)))}(this.gl,e,t)}uploadDenseMatrixToTexture(e,t,n,s){this.throwIfDisposed(),function(e,t,n,s,r,a){let i,o,l;XS(e,(()=>e.bindTexture(e.TEXTURE_2D,t))),r instanceof Uint8Array?(i=new Uint8Array(n*s*4),o=e.UNSIGNED_BYTE,l=e.RGBA):(i=new Float32Array(n*s*4),o=e.FLOAT,l=a.internalFormatPackedFloat),i.set(r),XS(e,(()=>e.texImage2D(e.TEXTURE_2D,0,l,n,s,0,e.RGBA,o,i))),XS(e,(()=>e.bindTexture(e.TEXTURE_2D,null)))}(this.gl,e,t,n,s,this.textureConfig)}createFloat16PackedMatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=qS(t,n);return _T(e,r,a,BT(s),e.RGBA,s.textureTypeHalfFloat)}(this.gl,e,t,this.textureConfig)}createPackedMatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=qS(t,n);return _T(e,r,a,zT(s),e.RGBA,e.FLOAT)}(this.gl,e,t,this.textureConfig)}deleteMatrixTexture(e){this.throwIfDisposed(),this.outputTexture===e&&(rT(this.gl,this.framebuffer),this.outputTexture=null),XS(this.gl,(()=>this.gl.deleteTexture(e)))}downloadByteEncodedFloatMatrixFromOutputTexture(e,t,n){return this.downloadMatrixDriver(e,(()=>function(e,t,n,s){const[r,a]=HS(t,n),i=new Uint8Array(t*n*4);return XS(e,(()=>e.readPixels(0,0,r,a,s.downloadTextureFormat,e.UNSIGNED_BYTE,i))),new Float32Array(i.buffer)}(this.gl,t,n,this.textureConfig)))}downloadPackedMatrixFromBuffer(e,t,n,s,r,a){return PT(this.gl,e,0,0,0,r,a,this.textureConfig)}downloadFloat32MatrixFromBuffer(e,t){return function(e,t,n){const s=e,r=new Float32Array(n);return s.bindBuffer(s.PIXEL_PACK_BUFFER,t),s.getBufferSubData(s.PIXEL_PACK_BUFFER,0,r),s.bindBuffer(s.PIXEL_PACK_BUFFER,null),r}(this.gl,e,t)}createBufferFromTexture(e,t,n){this.bindTextureToFrameBuffer(e);const s=function(e,t,n,s){const r=e.createBuffer();XS(e,(()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,r)));const a=16*t*n;return XS(e,(()=>e.bufferData(e.PIXEL_PACK_BUFFER,a,e.STREAM_READ))),XS(e,(()=>e.readPixels(0,0,n,t,e.RGBA,e.FLOAT,0))),XS(e,(()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,null))),r}(this.gl,t,n,this.textureConfig);return this.unbindTextureToFrameBuffer(),s}createAndWaitForFence(){const e=this.createFence(this.gl);return this.pollFence(e)}createFence(e){let t,n;if(K().getBool("WEBGL_FENCE_API_ENABLED")){const s=e,r=s.fenceSync(s.SYNC_GPU_COMMANDS_COMPLETE,0);e.flush(),n=()=>{const e=s.clientWaitSync(r,0,0);return e===s.ALREADY_SIGNALED||e===s.CONDITION_SATISFIED},t=r}else K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0?(t=this.beginQuery(),this.endQuery(),n=()=>this.isQueryAvailable(t,K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))):n=()=>!0;return{query:t,isFencePassed:n}}downloadMatrixFromPackedTexture(e,t,n){return this.downloadMatrixDriver(e,(()=>function(e,t,n){const s=new Float32Array(t*n*4);return XS(e,(()=>e.readPixels(0,0,n,t,e.RGBA,e.FLOAT,s))),s}(this.gl,t,n)))}createProgram(e){this.throwIfDisposed();const t=this.gl,n=ZS(t,e);null==this.vertexShader&&(this.vertexShader=RT(t));const s=function(e){return iT(e,(()=>e.createProgram()),"Unable to create WebGLProgram.")}(t);return XS(t,(()=>t.attachShader(s,this.vertexShader))),XS(t,(()=>t.attachShader(s,n))),function(e,t){if(XS(e,(()=>e.linkProgram(t))),!1===e.getProgramParameter(t,e.LINK_STATUS))throw console.log(e.getProgramInfoLog(t)),new Error("Failed to link vertex and fragment shaders.")}(t,s),this.debug&&eT(t,s),this.vertexAttrsAreBound||(this.setProgram(s),this.vertexAttrsAreBound=function(e,t,n){return XS(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,n))),tT(e,t,"clipSpacePos",n,3,20,0)&&tT(e,t,"uv",n,2,20,12)}(t,this.program,this.vertexBuffer)),s}deleteProgram(e){this.throwIfDisposed(),e===this.program&&(this.program=null),null!=e&&XS(this.gl,(()=>this.gl.deleteProgram(e)))}setProgram(e){this.throwIfDisposed(),this.program=e,null!=this.program&&this.debug&&eT(this.gl,this.program),XS(this.gl,(()=>this.gl.useProgram(e)))}getUniformLocation(e,t,n=!0){return this.throwIfDisposed(),n?function(e,t,n){return iT(e,(()=>e.getUniformLocation(t,n)),'uniform "'+n+'" not present in program.')}(this.gl,e,t):function(e,t,n){return e.getUniformLocation(t,n)}(this.gl,e,t)}getAttributeLocation(e,t){return this.throwIfDisposed(),XS(this.gl,(()=>this.gl.getAttribLocation(e,t)))}getUniformLocationNoThrow(e,t){return this.throwIfDisposed(),this.gl.getUniformLocation(e,t)}setInputMatrixTexture(e,t,n){this.throwIfDisposed(),this.throwIfNoProgram(),nT(this.gl,e,t,n)}setOutputMatrixTexture(e,t,n){this.setOutputMatrixTextureDriver(e,n,t)}setOutputPackedMatrixTexture(e,t,n){this.throwIfDisposed();const[s,r]=qS(t,n);this.setOutputMatrixTextureDriver(e,s,r)}setOutputMatrixWriteRegion(e,t,n,s){this.setOutputMatrixWriteRegionDriver(n,e,s,t)}setOutputPackedMatrixWriteRegion(e,t,n,s){throw new Error("setOutputPackedMatrixWriteRegion not implemented.")}debugValidate(){null!=this.program&&eT(this.gl,this.program),aT(this.gl)}executeProgram(){this.throwIfDisposed(),this.throwIfNoProgram();const e=this.gl;this.debug&&this.debugValidate(),XS(e,(()=>e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0)))}blockUntilAllProgramsCompleted(){this.throwIfDisposed(),XS(this.gl,(()=>this.gl.finish()))}getQueryTimerExtension(){return null==this.disjointQueryTimerExtension&&(this.disjointQueryTimerExtension=JS(this.gl,2===K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")?"EXT_disjoint_timer_query_webgl2":"EXT_disjoint_timer_query")),this.disjointQueryTimerExtension}getQueryTimerExtensionWebGL2(){return this.getQueryTimerExtension()}getQueryTimerExtensionWebGL1(){return this.getQueryTimerExtension()}beginQuery(){if(2===K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,t=this.getQueryTimerExtensionWebGL2(),n=e.createQuery();return e.beginQuery(t.TIME_ELAPSED_EXT,n),n}const e=this.getQueryTimerExtensionWebGL1(),t=e.createQueryEXT();return e.beginQueryEXT(e.TIME_ELAPSED_EXT,t),t}endQuery(){if(2===K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,t=this.getQueryTimerExtensionWebGL2();return void e.endQuery(t.TIME_ELAPSED_EXT)}const e=this.getQueryTimerExtensionWebGL1();e.endQueryEXT(e.TIME_ELAPSED_EXT)}async waitForQueryAndGetTime(e){return await y((()=>this.disposed||this.isQueryAvailable(e,K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")))),this.getQueryTime(e,K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))}getQueryTime(e,t){if(0===t)return null;if(2===t){const t=this.gl;return t.getQueryParameter(e,t.QUERY_RESULT)/1e6}{const t=this.getQueryTimerExtensionWebGL1();return t.getQueryObjectEXT(e,t.QUERY_RESULT_EXT)/1e6}}isQueryAvailable(e,t){if(0===t)return!0;if(2===t){const t=this.gl,n=this.getQueryTimerExtensionWebGL2(),s=t.getQueryParameter(e,t.QUERY_RESULT_AVAILABLE);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(n.GPU_DISJOINT_EXT)),s&&!this.disjoint}{const t=this.getQueryTimerExtensionWebGL1(),n=t.getQueryObjectEXT(e,t.QUERY_RESULT_AVAILABLE_EXT);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(t.GPU_DISJOINT_EXT)),n&&!this.disjoint}}pollFence(e){return new Promise((t=>{this.addItemToPoll((()=>e.isFencePassed()),(()=>t()))}))}pollItems(){const e=function(e){let t=0;for(;t<e.length;++t){if(!e[t]())break}return t-1}(this.itemsToPoll.map((e=>e.isDoneFn)));for(let t=0;t<=e;++t){const{resolveFn:e}=this.itemsToPoll[t];e()}this.itemsToPoll=this.itemsToPoll.slice(e+1)}addItemToPoll(e,t){this.itemsToPoll.push({isDoneFn:e,resolveFn:t}),this.itemsToPoll.length>1||y((()=>(this.pollItems(),0===this.itemsToPoll.length)))}bindTextureToFrameBuffer(e){this.throwIfDisposed(),sT(this.gl,e,this.framebuffer),this.debug&&aT(this.gl)}unbindTextureToFrameBuffer(){null!=this.outputTexture?(sT(this.gl,this.outputTexture,this.framebuffer),this.debug&&aT(this.gl)):rT(this.gl,this.framebuffer)}downloadMatrixDriver(e,t){this.bindTextureToFrameBuffer(e);const n=t();return this.unbindTextureToFrameBuffer(),n}setOutputMatrixTextureDriver(e,t,n){this.throwIfDisposed();const s=this.gl;sT(s,e,this.framebuffer),this.debug&&aT(s),this.outputTexture=e,XS(s,(()=>s.viewport(0,0,t,n))),XS(s,(()=>s.scissor(0,0,t,n)))}setOutputMatrixWriteRegionDriver(e,t,n,s){this.throwIfDisposed(),XS(this.gl,(()=>this.gl.scissor(e,t,n,s)))}throwIfDisposed(){if(this.disposed)throw new Error("Attempted to use disposed GPGPUContext.")}throwIfNoProgram(){if(null==this.program)throw new Error("No GPU program is currently set.")}}const{getBroadcastDims:VT}=Ip;function UT(e,t,n,s){const r=[];e.forEach((e=>{const t=p(e.shapeInfo.logicalShape);e.shapeInfo.isUniform?r.push(`uniform float ${e.name}${t>1?`[${t}]`:""};`):(r.push(`uniform sampler2D ${e.name};`),r.push(`uniform int offset${e.name};`))}));const a=r.join("\n"),i=e.map((e=>function(e,t,n=!1){let s="";s+=n?HT(e):GT(e);const r=e.shapeInfo.logicalShape,a=t.logicalShape;r.length<=a.length&&(s+=n?function(e,t){const n=e.name,s=n.charAt(0).toUpperCase()+n.slice(1),r="get"+s+"AtOutCoords",a=e.shapeInfo.logicalShape.length,i=t.logicalShape.length,o=VT(e.shapeInfo.logicalShape,t.logicalShape),l=QT(i),u=i-a;let c;const h=["x","y","z","w","u","v"];c=0===a?"":i<2&&o.length>=1?"coords = 0;":o.map((e=>`coords.${h[e+u]} = 0;`)).join("\n");let d="";d=i<2&&a>0?"coords":e.shapeInfo.logicalShape.map(((e,t)=>`coords.${h[t+u]}`)).join(", ");let f="return outputValue;";const m=1===p(e.shapeInfo.logicalShape),g=1===p(t.logicalShape);if(1!==a||m||g){if(m&&!g)f=1===i?"\n        return vec4(outputValue.x, outputValue.x, 0., 0.);\n      ":"\n        return vec4(outputValue.x);\n      ";else if(o.length){const e=a-2,t=a-1;o.indexOf(e)>-1&&o.indexOf(t)>-1?f="return vec4(outputValue.x);":o.indexOf(e)>-1?f="return vec4(outputValue.x, outputValue.y, outputValue.x, outputValue.y);":o.indexOf(t)>-1&&(f="return vec4(outputValue.xx, outputValue.zz);")}}else f="\n      return vec4(outputValue.xy, outputValue.xy);\n    ";return`\n    vec4 ${r}() {\n      ${l} coords = getOutputCoords();\n      ${c}\n      vec4 outputValue = get${s}(${d});\n      ${f}\n    }\n  `}(e,t):function(e,t){const n=e.name,s=n.charAt(0).toUpperCase()+n.slice(1),r="get"+s+"AtOutCoords",a=t.texShape,i=e.shapeInfo.texShape,o=e.shapeInfo.logicalShape.length,l=t.logicalShape.length;if(!e.shapeInfo.isUniform&&o===l&&null==e.shapeInfo.flatOffset&&d(i,a))return`\n      float ${r}() {\n        return sampleTexture(${n}, resultUV);\n      }\n    `;const u=QT(l),c=VT(e.shapeInfo.logicalShape,t.logicalShape),h=l-o;let p;const f=["x","y","z","w","u","v"];p=0===o?"":l<2&&c.length>=1?"coords = 0;":c.map((e=>`coords.${f[e+h]} = 0;`)).join("\n");let m="";m=l<2&&o>0?"coords":e.shapeInfo.logicalShape.map(((e,t)=>`coords.${f[t+h]}`)).join(", ");return`\n    float ${r}() {\n      ${u} coords = getOutputCoords();\n      ${p}\n      return get${s}(${m});\n    }\n  `}(e,t));return s}(e,t,s))).join("\n"),o=t.texShape,l=kT(),u=function(e){return`\n    float sampleTexture(sampler2D textureSampler, vec2 uv) {\n      return ${e.texture2D}(textureSampler, uv).r;\n    }\n  `}(l);let c,h,f=function(e){return`${e.version}\n    precision highp float;\n    precision highp int;\n    precision highp sampler2D;\n    ${e.varyingFs} vec2 resultUV;\n    ${e.defineOutput}\n    const vec2 halfCR = vec2(0.5, 0.5);\n\n    struct ivec5\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n    };\n\n    struct ivec6\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n      int v;\n    };\n\n    uniform float NAN;\n    ${e.defineSpecialNaN}\n    ${e.defineSpecialInf}\n    ${e.defineRound}\n\n    int imod(int x, int y) {\n      return x - y * (x / y);\n    }\n\n    int idiv(int a, int b, float sign) {\n      int res = a / b;\n      int mod = imod(a, b);\n      if (sign < 0. && mod != 0) {\n        res -= 1;\n      }\n      return res;\n    }\n\n    //Based on the work of Dave Hoskins\n    //https://www.shadertoy.com/view/4djSRW\n    #define HASHSCALE1 443.8975\n    float random(float seed){\n      vec2 p = resultUV * seed;\n      vec3 p3  = fract(vec3(p.xyx) * HASHSCALE1);\n      p3 += dot(p3, p3.yzx + 19.19);\n      return fract((p3.x + p3.y) * p3.z);\n    }\n\n    ${jT}\n    ${qT}\n    ${KT}\n  `}(l);t.isPacked?(c=function(e,t){switch(e.length){case 0:return YT();case 1:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(1===n[0])return`\n      int getOutputCoords() {\n        return 2 * int(resultUV.x * ${n[1]}.0);\n      }\n    `;if(1===n[1])return`\n      int getOutputCoords() {\n        return 2 * int(resultUV.y * ${n[0]}.0);\n      }\n    `;return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      return 2 * (resTexRC.x * ${n[1]} + resTexRC.y);\n    }\n  `}(0,t);case 2:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(d(e,t))return`\n      ivec2 getOutputCoords() {\n        return 2 * ivec2(resultUV.yx * vec2(${n[0]}, ${n[1]}));\n      }\n    `;const s=Math.ceil(e[1]/2);return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n      int r = 2 * (index / ${s});\n      int c = imod(index, ${s}) * 2;\n\n      return ivec2(r, c);\n    }\n  `}(e,t);case 3:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)],s=Math.ceil(e[2]/2),r=s*Math.ceil(e[1]/2);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      int b = index / ${r};\n      index -= b * ${r};\n\n      int r = 2 * (index / ${s});\n      int c = imod(index, ${s}) * 2;\n\n      return ivec3(b, r, c);\n    }\n  `}(e,t);default:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)],s=Math.ceil(e[e.length-1]/2),r=s*Math.ceil(e[e.length-2]/2);let a=r,i="",o="b, r, c";for(let t=2;t<e.length-1;t++)a*=e[e.length-t-1],i=`\n      int b${t} = index / ${a};\n      index -= b${t} * ${a};\n    `+i,o=`b${t}, `+o;return`\n    ivec${e.length} getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      ${i}\n\n      int b = index / ${r};\n      index -= b * ${r};\n\n      int r = 2 * (index / ${s});\n      int c = imod(index, ${s}) * 2;\n\n      return ivec${e.length}(${o});\n    }\n  `}(e,t)}}(t.logicalShape,o),h=function(e){return`\n    void setOutput(vec4 val) {\n      ${e.output} = val;\n    }\n  `}(l)):(c=function(e,t){switch(e.length){case 0:return YT();case 1:return function(e,t){if(1===t[0])return`\n      int getOutputCoords() {\n        return int(resultUV.x * ${t[1]}.0);\n      }\n    `;if(1===t[1])return`\n      int getOutputCoords() {\n        return int(resultUV.y * ${t[0]}.0);\n      }\n    `;return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      return resTexRC.x * ${t[1]} + resTexRC.y;\n    }\n  `}(0,t);case 2:return function(e,t){if(d(e,t))return`\n      ivec2 getOutputCoords() {\n        return ivec2(resultUV.yx * vec2(${t[0]}, ${t[1]}));\n      }\n    `;if(1===e[1])return`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(index, 0);\n      }\n    `;if(1===e[0])return`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(0, index);\n      }\n    `;return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      int r = index / ${e[1]};\n      int c = index - r * ${e[1]};\n      return ivec2(r, c);\n    }\n  `}(e,t);case 3:return function(e,t){const n=vT(["r","c","d"],e);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      ${n}\n      return ivec3(r, c, d);\n    }\n  `}(e,t);case 4:return function(e,t){const n=vT(["r","c","d","d2"],e);return`\n    ivec4 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      ${n}\n      return ivec4(r, c, d, d2);\n    }\n  `}(e,t);case 5:return function(e,t){const n=vT(["r","c","d","d2","d3"],e);return`\n    ivec5 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx * vec2(${t[0]},\n                             ${t[1]}));\n\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec5 outShape = ivec5(r, c, d, d2, d3);\n      return outShape;\n    }\n  `}(e,t);case 6:return function(e,t){const n=vT(["r","c","d","d2","d3","d4"],e);return`\n    ivec6 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec6 result = ivec6(r, c, d, d2, d3, d4);\n      return result;\n    }\n  `}(e,t);default:throw new Error(`${e.length}-D output sampling is not yet supported`)}}(t.logicalShape,o),h=function(e){return`\n    void setOutput(float val) {\n      ${e.output} = vec4(val, 0, 0, 0);\n    }\n  `}(l)),s&&(f+=XT);return[f,u,h,a,c,i,n].join("\n")}function GT(e){const t=e.shapeInfo.logicalShape;switch(t.length){case 0:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1);if(e.shapeInfo.isUniform)return`float ${n}() {return ${t};}`;const[s,r]=e.shapeInfo.texShape;if(1===s&&1===r)return`\n      float ${n}() {\n        return sampleTexture(${t}, halfCR);\n      }\n    `;const[a,i]=e.shapeInfo.texShape,o=JT(t);return`\n    float ${n}() {\n      vec2 uv = uvFromFlat(${a}, ${i}, ${o});\n      return sampleTexture(${t}, uv);\n    }\n  `}(e);case 1:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1);if(e.shapeInfo.isUniform)return`\n      float ${n}(int index) {\n        ${ZT(e)}\n      }\n    `;const s=e.shapeInfo.texShape,r=s[0],a=s[1];if(1===a&&1===r)return`\n      float ${n}(int index) {\n        return sampleTexture(${t}, halfCR);\n      }\n    `;const i=JT(t);if(1===a)return`\n      float ${n}(int index) {\n        vec2 uv = vec2(0.5, (float(index + ${i}) + 0.5) / ${r}.0);\n        return sampleTexture(${t}, uv);\n      }\n    `;if(1===r)return`\n      float ${n}(int index) {\n        vec2 uv = vec2((float(index + ${i}) + 0.5) / ${a}.0, 0.5);\n        return sampleTexture(${t}, uv);\n      }\n    `;return`\n    float ${n}(int index) {\n      vec2 uv = uvFromFlat(${r}, ${a}, index + ${i});\n      return sampleTexture(${t}, uv);\n    }\n  `}(e);case 2:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e.shapeInfo.texShape;if(null!=r&&d(t,r)){const e=r[0];return`\n    float ${s}(int row, int col) {\n      vec2 uv = (vec2(col, row) + halfCR) / vec2(${r[1]}.0, ${e}.0);\n      return sampleTexture(${n}, uv);\n    }\n  `}const{newShape:a,keptDims:i}=w(t),o=a;if(o.length<t.length){const t=["row","col"];return`\n      ${GT(eE(e,o))}\n      float ${s}(int row, int col) {\n        return ${s}(${tE(t,i)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col) {\n        int index = round(dot(vec2(row, col), vec2(${t[1]}, 1)));\n        ${ZT(e)}\n      }\n    `;const l=r[0],u=r[1],c=JT(n);if(1===u)return`\n    float ${s}(int row, int col) {\n      float index = dot(vec3(row, col, ${c}), vec3(${t[1]}, 1, 1));\n      vec2 uv = vec2(0.5, (index + 0.5) / ${l}.0);\n      return sampleTexture(${n}, uv);\n    }\n  `;if(1===l)return`\n    float ${s}(int row, int col) {\n      float index = dot(vec3(row, col, ${c}), vec3(${t[1]}, 1, 1));\n      vec2 uv = vec2((index + 0.5) / ${u}.0, 0.5);\n      return sampleTexture(${n}, uv);\n    }\n  `;return`\n  float ${s}(int row, int col) {\n    // Explicitly use integer operations as dot() only works on floats.\n    int index = row * ${t[1]} + col + ${c};\n    vec2 uv = uvFromFlat(${l}, ${u}, index);\n    return sampleTexture(${n}, uv);\n  }\n`}(e);case 3:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t[1]*t[2],a=t[2],{newShape:i,keptDims:o}=w(t),l=i;if(l.length<t.length){const t=["row","col","depth"];return`\n        ${GT(eE(e,l))}\n        float ${s}(int row, int col, int depth) {\n          return ${s}(${tE(t,o)});\n        }\n      `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth) {\n        int index = round(dot(vec3(row, col, depth),\n                          vec3(${r}, ${a}, 1)));\n        ${ZT(e)}\n      }\n    `;const u=e.shapeInfo.texShape,c=u[0],h=u[1],p=e.shapeInfo.flatOffset;if(h===r&&null==p)return`\n        float ${s}(int row, int col, int depth) {\n          float texR = float(row);\n          float texC = dot(vec2(col, depth), vec2(${a}, 1));\n          vec2 uv = (vec2(texC, texR) + halfCR) /\n                     vec2(${h}.0, ${c}.0);\n          return sampleTexture(${n}, uv);\n        }\n      `;if(h===a&&null==p)return`\n    float ${s}(int row, int col, int depth) {\n      float texR = dot(vec2(row, col), vec2(${t[1]}, 1));\n      float texC = float(depth);\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${h}.0, ${c}.0);\n      return sampleTexture(${n}, uv);\n    }\n  `;const d=JT(n);return`\n      float ${s}(int row, int col, int depth) {\n        // Explicitly use integer operations as dot() only works on floats.\n        int index = row * ${r} + col * ${a} + depth + ${d};\n        vec2 uv = uvFromFlat(${c}, ${h}, index);\n        return sampleTexture(${n}, uv);\n      }\n  `}(e);case 4:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t[3],a=t[2]*r,i=t[1]*a,{newShape:o,keptDims:l}=w(t);if(o.length<t.length){const t=["row","col","depth","depth2"];return`\n      ${GT(eE(e,o))}\n      float ${s}(int row, int col, int depth, int depth2) {\n        return ${s}(${tE(t,l)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth, int depth2) {\n        int index = round(dot(vec4(row, col, depth, depth2),\n                          vec4(${i}, ${a}, ${r}, 1)));\n        ${ZT(e)}\n      }\n    `;const u=e.shapeInfo.flatOffset,c=e.shapeInfo.texShape,h=c[0],p=c[1];if(p===i&&null==u)return`\n      float ${s}(int row, int col, int depth, int depth2) {\n        float texR = float(row);\n        float texC =\n            dot(vec3(col, depth, depth2),\n                vec3(${a}, ${r}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${p}.0, ${h}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(p===r&&null==u)return`\n      float ${s}(int row, int col, int depth, int depth2) {\n        float texR = dot(vec3(row, col, depth),\n                         vec3(${t[1]*t[2]}, ${t[2]}, 1));\n        float texC = float(depth2);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${p}.0, ${h}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const d=JT(n);return`\n    float ${s}(int row, int col, int depth, int depth2) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${i} + col * ${a} +\n          depth * ${r} + depth2;\n      vec2 uv = uvFromFlat(${h}, ${p}, index + ${d});\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);case 5:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t[4],a=t[3]*r,i=t[2]*a,o=t[1]*i,{newShape:l,keptDims:u}=w(t);if(l.length<t.length){const t=["row","col","depth","depth2","depth3"];return`\n      ${GT(eE(e,l))}\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        return ${s}(${tE(t,u)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        float index = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${o}, ${i}, ${a}, ${r})) +\n          depth3;\n        ${ZT(e)}\n      }\n    `;const c=e.shapeInfo.flatOffset,h=e.shapeInfo.texShape,p=h[0],d=h[1];if(d===o&&null==c)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n                         vec4(${i}, ${a}, ${r}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${d}.0, ${p}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(d===r&&null==c)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        float texR = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]},\n               ${t[2]*t[3]}, ${t[3]}, 1));\n        int texC = depth3;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${d}.0, ${p}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const f=JT(n);return`\n    float ${s}(int row, int col, int depth, int depth2, int depth3) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${o} + col * ${i} + depth * ${a} +\n          depth2 * ${r} + depth3 + ${f};\n      vec2 uv = uvFromFlat(${p}, ${d}, index);\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);case 6:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),{newShape:r,keptDims:a}=w(t);if(r.length<t.length){const t=["row","col","depth","depth2","depth3","depth4"];return`\n      ${GT(eE(e,r))}\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        return ${s}(${tE(t,a)});\n      }\n    `}const i=t[5],o=t[4]*i,l=t[3]*o,u=t[2]*l,c=t[1]*u;if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n        int index = round(dot(\n          vec4(row, col, depth, depth2),\n          vec4(${c}, ${u}, ${l}, ${o})) +\n          dot(\n            vec2(depth3, depth4),\n            vec2(${i}, 1)));\n        ${ZT(e)}\n      }\n    `;const h=e.shapeInfo.flatOffset,p=e.shapeInfo.texShape,d=p[0],f=p[1];if(f===c&&null==h)return`\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n          vec4(${u}, ${l}, ${o}, ${i})) +\n               float(depth4);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${f}.0, ${d}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(f===i&&null==h)return`\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        float texR = dot(vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]*t[4]},\n               ${t[2]*t[3]*t[4]},\n               ${t[3]*t[4]},\n               ${t[4]})) + float(depth3);\n        int texC = depth4;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${f}.0, ${d}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const m=JT(n);return`\n    float ${s}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${c} + col * ${u} + depth * ${l} +\n          depth2 * ${o} + depth3 * ${i} + depth4 + ${m};\n      vec2 uv = uvFromFlat(${d}, ${f}, index);\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);default:throw new Error(`${t.length}-D input sampling is not yet supported`)}}function HT(e){switch(e.shapeInfo.logicalShape.length){case 0:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1),s=kT();return`\n    vec4 ${n}() {\n      return ${s.texture2D}(${t}, halfCR);\n    }\n  `}(e);case 1:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1),s=e.shapeInfo.texShape,r=[Math.ceil(s[0]/2),Math.ceil(s[1]/2)],a=kT();return`\n    vec4 ${n}(int index) {\n      vec2 uv = packedUVfrom1D(\n        ${r[0]}, ${r[1]}, index);\n      return ${a.texture2D}(${t}, uv);\n    }\n  `}(e);case 2:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e.shapeInfo.texShape,a=r[0],i=r[1],o=kT();if(null!=r&&d(t,r))return`\n      vec4 ${s}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${i}.0, ${a}.0);\n\n        return ${o.texture2D}(${n}, uv);\n      }\n    `;const l=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)],u=Math.ceil(t[1]/2);return`\n    vec4 ${s}(int row, int col) {\n      vec2 uv = packedUVfrom2D(${u}, ${l[0]}, ${l[1]}, row, col);\n      return ${o.texture2D}(${n}, uv);\n    }\n  `}(e);case 3:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e.shapeInfo.texShape,a=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)];if(1===t[0]){const n=[1,2],r=["b","row","col"];return`\n        ${HT(eE(e,t.slice(1)))}\n        vec4 ${s}(int b, int row, int col) {\n          return ${s}(${tE(r,n)});\n        }\n      `}const i=a[0],o=a[1],l=Math.ceil(t[2]/2),u=l*Math.ceil(t[1]/2),c=kT();return`\n    vec4 ${s}(int b, int row, int col) {\n      vec2 uv = packedUVfrom3D(\n        ${i}, ${o}, ${u}, ${l}, b, row, col);\n      return ${c.texture2D}(${n}, uv);\n    }\n  `}(e);default:return function(e){const t=e.shapeInfo.logicalShape,n=t.length,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=e.shapeInfo.texShape,i=[Math.ceil(a[0]/2),Math.ceil(a[1]/2)],o=i[0],l=i[1],u=Math.ceil(t[n-1]/2);let c=u*Math.ceil(t[n-2]/2),h="int b, int row, int col",p=`b * ${c} + (row / 2) * ${u} + (col / 2)`;for(let e=2;e<n-1;e++)h=`int b${e}, `+h,c*=t[n-e-1],p=`b${e} * ${c} + `+p;const d=kT();return`\n    vec4 ${r}(${h}) {\n      int index = ${p};\n      int texR = index / ${l};\n      int texC = index - texR * ${l};\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${l}, ${o});\n      return ${d.texture2D}(${s}, uv);\n    }\n  `}(e)}}const jT="\nvec2 uvFromFlat(int texNumR, int texNumC, int index) {\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\nvec2 packedUVfrom1D(int texNumR, int texNumC, int index) {\n  int texelIndex = index / 2;\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",qT="\nvec2 packedUVfrom2D(int texelsInLogicalRow, int texNumR,\n  int texNumC, int row, int col) {\n  int texelIndex = (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",KT="\nvec2 packedUVfrom3D(int texNumR, int texNumC,\n    int texelsInBatch, int texelsInLogicalRow, int b,\n    int row, int col) {\n  int index = b * texelsInBatch + (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",XT="\n  float getChannel(vec4 frag, vec2 innerDims) {\n    vec2 modCoord = mod(innerDims, 2.);\n    return modCoord.x == 0. ?\n      (modCoord.y == 0. ? frag.r : frag.g) :\n      (modCoord.y == 0. ? frag.b : frag.a);\n  }\n  float getChannel(vec4 frag, int dim) {\n    float modCoord = mod(float(dim), 2.);\n    return modCoord == 0. ? frag.r : frag.g;\n  }\n";function YT(){return"\n    int getOutputCoords() {\n      return 0;\n    }\n  "}function JT(e){return`offset${e}`}function ZT(e){const t=e.name,n=p(e.shapeInfo.logicalShape);return n<2?`return ${t};`:`\n    for (int i = 0; i < ${n}; i++) {\n      if (i == index) {\n        return ${t}[i];\n      }\n    }\n  `}function QT(e){if(e<=1)return"int";if(2===e)return"ivec2";if(3===e)return"ivec3";if(4===e)return"ivec4";if(5===e)return"ivec5";if(6===e)return"ivec6";throw Error(`GPU for rank ${e} is not yet supported`)}function eE(e,t){const n=JSON.parse(JSON.stringify(e));return n.shapeInfo.logicalShape=t,n}function tE(e,t){return t.map((t=>e[t])).join(", ")}function nE(e,t){if(e.length!==t.length)throw Error(`Binary was compiled with ${e.length} inputs, but was executed with ${t.length} inputs`);e.forEach(((e,n)=>{const s=e.logicalShape,r=t[n],a=r.shape;if(!d(s,a))throw Error(`Binary was compiled with different shapes than the current args. Shapes ${s} and ${a} must match`);if(e.isUniform&&r.isUniform)return;const i=e.texShape,o=r.isUniform?null:r.texData.texShape;if(!d(i,o))throw Error(`Binary was compiled with different texture shapes than the current args. Shape ${i} and ${o} must match`)}))}const{addImpl:sE,bincountImpl:rE,bincountReduceImpl:aE,ceilImpl:iE,concatImpl:oE,expImpl:lE,expm1Impl:uE,floorImpl:cE,gatherV2Impl:hE,greaterImpl:pE,lessImpl:dE,linSpaceImpl:fE,logImpl:mE,maxImpl:gE,maximumImpl:yE,minimumImpl:bE,multiplyImpl:xE,negImpl:wE,prodImpl:kE,rangeImpl:vE,rsqrtImpl:NE,simpleAbsImpl:IE,sliceImpl:$E,sparseFillEmptyRowsImpl:CE,sparseReshapeImpl:SE,stridedSliceImpl:TE,subImpl:EE,tileImpl:AE,topKImpl:RE,transposeImpl:FE,uniqueImpl:DE}=HN;function _E(e,t){return["x","y","z","w","u","v"].slice(0,t).map((t=>`${e}.${t}`))}function OE(e,t){return 1===t?[e]:_E(e,t)}class ME{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outputShape=e;const t=e.length;if(0===t)this.userCode="\n        void main() {\n          setOutput(vec4(getA(), 0., 0., 0.));\n        }\n      ";else{const n=OE("rc",t),s=QT(t),r=function(e,t,n){if(1===e)return`rc > ${t[0]}`;let s="";for(let r=e-2;r<e;r++)s+=`${n[r]} >= ${t[r]}`,r<e-1&&(s+="||");return s}(t,e,n),a=function(e,t,n,s){if(1===e)return"";const r=s.slice(-2);return`\n    int r = ${r[0]};\n    int c = ${r[1]};\n    int rp1 = r + 1;\n    int cp1 = c + 1;\n\n    bool cEdge = cp1 >= ${t};\n    bool rEdge = rp1 >= ${n};\n  `}(t,e[e.length-1],e[e.length-2],n),i=function(e,t){const n=e.length,s=function(e,t){const n=[];for(let s=0;s<=1;s++)for(let r=0;r<=1;r++){let a=`${0===s?"r":"rp1"}, ${0===r?"c":"cp1"}`;for(let n=2;n<e;n++)a=`${t[t.length-1-n]},`+a;n.push(a)}return n}(n,t);if(1===n)return`getA(rc),\n            rc + 1 >= ${e[0]} ? 0. : getA(rc + 1),\n            0, 0`;return`getA(${s[0]}),\n          cEdge ? 0. : getA(${s[1]}),\n          rEdge ? 0. : getA(${s[2]}),\n          rEdge || cEdge ? 0. : getA(${s[3]})`}(e,n);this.userCode=`\n        void main() {\n          ${s} rc = getOutputCoords();\n\n          if(${r}) {\n            setOutput(vec4(0));\n          } else {\n            ${a}\n\n            setOutput(vec4(${i}));\n          }\n        }\n      `}}}class LE{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e;let n="";for(let e=0;e<4;e++){let t="thisRC = rc;";e%2==1&&(t+="thisRC.z += 1;"),e>1&&(t+="thisRC.y += 1;"),n+=`\n        ${t}\n        ${e>0?"if(thisRC.y < rows && thisRC.z < cols){":""}\n          int flatIndex = getFlatIndex(thisRC);\n\n          ivec3 inputRC = inputCoordsFromReshapedOutCoords(flatIndex);\n          vec2 inputRCInnerDims = vec2(float(inputRC.y),float(inputRC.z));\n\n          result[${e}] =\n            getChannel(getA(inputRC.x, inputRC.y, inputRC.z), inputRCInnerDims);\n        ${e>0?"}":""}\n      `}var s;this.userCode=`\n      ${s=t,`\n    ivec3 inputCoordsFromReshapedOutCoords(int index) {\n      ${vT(["r","c","d"],s)}\n      return ivec3(r, c, d);\n    }\n  `}\n      ${NT(e)}\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n\n        vec4 result = vec4(0.);\n\n        ivec3 thisRC;\n        int rows = ${e[1]};\n        int cols = ${e[2]};\n\n        ${n}\n\n        setOutput(result);\n      }\n    `}}class zE{constructor(e){this.gpgpu=e,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0,this.freeTextures={},this.logEnabled=!1,this.usedTextures={}}acquireTexture(e,t,n){const s=PE(t,n),r=WE(e,s,n);r in this.freeTextures||(this.freeTextures[r]=[]),r in this.usedTextures||(this.usedTextures[r]=[]);const a=BE(e,s,this.gpgpu.gl,this.gpgpu.textureConfig,n);if(this.freeTextures[r].length>0){this.numFreeTextures--,this.numUsedTextures++,this._numBytesFree-=a,this.log();const e=this.freeTextures[r].shift();return this.usedTextures[r].push(e),e}let i;return s===GS.PACKED_2X2_FLOAT32?i=this.gpgpu.createPackedMatrixTexture(e[0],e[1]):s===GS.PACKED_2X2_FLOAT16?i=this.gpgpu.createFloat16PackedMatrixTexture(e[0],e[1]):s===GS.UNPACKED_FLOAT32?i=this.gpgpu.createFloat32MatrixTexture(e[0],e[1]):s===GS.UNPACKED_FLOAT16?i=this.gpgpu.createFloat16MatrixTexture(e[0],e[1]):s===GS.PACKED_4X1_UNSIGNED_BYTE&&(i=this.gpgpu.createUnsignedBytesMatrixTexture(e[0],e[1])),this.usedTextures[r].push(i),this.numUsedTextures++,this._numBytesAllocated+=a,this.log(),i}releaseTexture(e,t,n,s){if(null==this.freeTextures)return;const r=PE(n,s),a=WE(t,r,s);a in this.freeTextures||(this.freeTextures[a]=[]);const i=BE(t,r,this.gpgpu.gl,this.gpgpu.textureConfig,s),o=K().get("WEBGL_DELETE_TEXTURE_THRESHOLD");-1!==o&&this._numBytesAllocated>o?(this.gpgpu.deleteMatrixTexture(e),this._numBytesAllocated-=i):(this.freeTextures[a].push(e),this.numFreeTextures++,this._numBytesFree+=i),this.numUsedTextures--;const l=this.usedTextures[a],u=l.indexOf(e);if(u<0)throw new Error("Cannot release a texture that was never provided by this texture manager");l.splice(u,1),this.log()}log(){if(!this.logEnabled)return;const e=this.numFreeTextures+this.numUsedTextures;console.log("Free/Used",`${this.numFreeTextures} / ${this.numUsedTextures}`,`(${e})`);const t=this._numBytesFree/this._numBytesAllocated;console.log(`Bytes allocated: ${this._numBytesAllocated}`),console.log(`Bytes unused: ${this._numBytesFree} (${Math.round(100*t)}%)`)}get numBytesAllocated(){return this._numBytesAllocated}get numBytesFree(){return this._numBytesFree}getNumUsedTextures(){return this.numUsedTextures}getNumFreeTextures(){return this.numFreeTextures}dispose(){if(null!=this.freeTextures){for(const e in this.freeTextures)this.freeTextures[e].forEach((e=>{this.gpgpu.deleteMatrixTexture(e)}));for(const e in this.usedTextures)this.usedTextures[e].forEach((e=>{this.gpgpu.deleteMatrixTexture(e)}));this.freeTextures=null,this.usedTextures=null,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0}}}function BE(e,t,n,s,r){const a=function(e,t){switch(e){case GS.PACKED_2X2_FLOAT32:return zT(t);case GS.PACKED_2X2_FLOAT16:return BT(t);case GS.UNPACKED_FLOAT32:return OT(t);case GS.UNPACKED_FLOAT16:return MT(t);case GS.PACKED_4X1_UNSIGNED_BYTE:return LT(t);default:throw new Error(`Unknown physical texture type ${e}`)}}(t,s);let i;if(r){const[t,n]=qS(e[0],e[1]);i=t*n}else{const[t,n]=HS(e[0],e[1]);i=t*n}return i*function(e,t){const n=e;if(t===n.R32F)return 4;if(t===n.R16F)return 2;if(t===n.RGBA32F)return 16;if(t===e.RGBA)return 16;if(t===n.RGBA16F)return 8;throw new Error(`Unknown internal format ${t}`)}(n,a)}function PE(e,t){if(e===US.UPLOAD)return GS.PACKED_2X2_FLOAT32;if(e===US.RENDER||null==e)return function(e){return K().getBool("WEBGL_RENDER_FLOAT32_ENABLED")?e?GS.PACKED_2X2_FLOAT32:GS.UNPACKED_FLOAT32:e?GS.PACKED_2X2_FLOAT16:GS.UNPACKED_FLOAT16}(t);if(e===US.DOWNLOAD||e===US.PIXELS)return GS.PACKED_4X1_UNSIGNED_BYTE;throw new Error(`Unknown logical texture type ${e}`)}function WE(e,t,n){return`${e[0]}_${e[1]}_${t}_${n}`}class VE{constructor(e,t){this.variableNames=["A"],this.outputShape=e,this.userCode=`\n      float unaryOperation(float x) {\n        ${t}\n      }\n\n      void main() {\n        float x = getAAtOutCoords();\n        float y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}const UE="return abs(x);";const GE="return x;";class HE{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.userCode=`\n      vec4 unaryOperation(vec4 x) {\n        ${t}\n      }\n\n      void main() {\n        vec4 x = getAAtOutCoords();\n        vec4 y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}class jE{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outputShape=e;const t=e.length,n=OE("rc",t),s=QT(t),r=function(e,t){if(1===e)return"rc";let n="";for(let s=0;s<e;s++)n+=t[s],s<e-1&&(n+=",");return n}(t,n),a=n.slice(-2),i=t<=1?"rc":`vec2(${a.join(",")})`;this.userCode=`\n      void main() {\n        ${s} rc = getOutputCoords();\n        vec4 packedInput = getA(${r});\n\n        setOutput(getChannel(packedInput, ${i}));\n      }\n    `}}const qE=ic,KE={};class XE extends n{constructor(e){if(super(),this.pendingRead=new WeakMap,this.pendingDisposal=new WeakSet,this.dataRefCount=new WeakMap,this.numBytesInGPU=0,this.uploadWaitMs=0,this.downloadWaitMs=0,this.lastGlFlushTime=0,this.warnedAboutMemory=!1,this.pendingDeletes=0,this.disposed=!1,!K().getBool("HAS_WEBGL"))throw new Error("WebGL is not supported on this device");if(null==e){const e=WS(K().getNumber("WEBGL_VERSION"));this.binaryCache=((n=K().getNumber("WEBGL_VERSION"))in KE||(KE[n]={}),KE[n]),this.gpgpu=new WT(e),this.canvas=e.canvas,this.gpgpuCreatedLocally=!0}else this.gpgpu=e,this.binaryCache={},this.gpgpuCreatedLocally=!1,this.canvas=e.gl.canvas;var n;this.textureManager=new zE(this.gpgpu),this.numMBBeforeWarning=null==K().global.screen?1024:K().global.screen.height*K().global.screen.width*window.devicePixelRatio*600/1024/1024,this.texData=new t(this,ri())}nextDataId(){return XE.nextDataId++}numDataIds(){return this.texData.numDataIds()-this.pendingDeletes}write(e,t,n){if((K().getBool("WEBGL_CHECK_NUMERICAL_PROBLEMS")||K().getBool("DEBUG"))&&this.checkNumericalProblems(e),"complex64"===n&&null!=e)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");const s={id:this.nextDataId()};return this.texData.set(s,{shape:t,dtype:n,values:e,usage:US.UPLOAD,refCount:1}),s}refCount(e){if(this.texData.has(e)){return this.texData.get(e).refCount}return 0}incRef(e){this.texData.get(e).refCount++}decRef(e){if(this.texData.has(e)){this.texData.get(e).refCount--}}move(e,t,n,s,r){if(K().getBool("DEBUG")&&this.checkNumericalProblems(t),"complex64"===s)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");this.texData.set(e,{shape:n,dtype:s,values:t,usage:US.UPLOAD,refCount:r})}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}readSync(e){const t=this.texData.get(e),{values:n,dtype:s,complexTensorInfos:r,slice:a,shape:i,isPacked:o}=t;if(null!=a){let t;t=o?new HE(i,GE):new VE(i,GE);const n=this.runWebGLProgram(t,[{dataId:e,shape:i,dtype:s}],s),r=this.readSync(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=n)return this.convertAndCacheOnCPU(e);if("string"===s)return n;const l=null!=this.activeTimers;let u,c;if(l&&(u=os()),"complex64"===s){c=tp(this.readSync(r.real.dataId),this.readSync(r.imag.dataId))}else c=this.getValuesFromTexture(e);return l&&(this.downloadWaitMs+=os()-u),this.convertAndCacheOnCPU(e,c)}async read(e){if(this.pendingRead.has(e)){const t=this.pendingRead.get(e);return new Promise((e=>t.push(e)))}const t=this.texData.get(e),{values:n,shape:s,slice:r,dtype:a,complexTensorInfos:i,isPacked:o}=t;if(null!=r){let t;t=o?new HE(s,GE):new VE(s,GE);const n=this.runWebGLProgram(t,[{dataId:e,shape:s,dtype:a}],a),r=this.read(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=n)return this.convertAndCacheOnCPU(e);if(!K().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")&&2===K().getNumber("WEBGL_VERSION"))throw new Error("tensor.data() with WEBGL_DOWNLOAD_FLOAT_ENABLED=false and WEBGL_VERSION=2 not yet supported.");let l,u,c=null;if("complex64"!==a&&K().get("WEBGL_BUFFER_SUPPORTED")){l=this.decode(e);const t=this.texData.get(l.dataId);c=this.gpgpu.createBufferFromTexture(t.texture,...jS(s))}if(this.pendingRead.set(e,[]),"complex64"!==a&&await this.gpgpu.createAndWaitForFence(),"complex64"===a){const e=await Promise.all([this.read(i.real.dataId),this.read(i.imag.dataId)]);u=tp(e[0],e[1])}else if(null==c)u=this.getValuesFromTexture(e);else{const e=p(s);u=this.gpgpu.downloadFloat32MatrixFromBuffer(c,e)}null!=l&&this.disposeIntermediateTensorInfo(l);const h=this.convertAndCacheOnCPU(e,u),d=this.pendingRead.get(e);return this.pendingRead.delete(e),d.forEach((e=>e(h))),this.pendingDisposal.has(e)&&(this.pendingDisposal.delete(e),this.disposeData(e)&&ri().removeDataId(e,this),this.pendingDeletes--),h}bufferSync(e){const t=this.readSync(e.dataId);let n=t;if("string"===e.dtype)try{n=t.map((e=>cs(e)))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return Kr(e.shape,e.dtype,n)}checkNumericalProblems(e){if(null!=e)for(let t=0;t<e.length;t++){const n=e[t];if(!YS(n)){if(K().getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))throw Error(`The value ${n} cannot be represented with your current settings. Consider enabling float32 rendering: 'tf.env().set('WEBGL_RENDER_FLOAT32_ENABLED', true);'`);throw Error(`The value ${n} cannot be represented on this device.`)}}}getValuesFromTexture(e){const{shape:t,dtype:n,isPacked:s}=this.texData.get(e),r=p(t);if(K().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")){const n=this.decode(e),s=this.texData.get(n.dataId),a=this.gpgpu.downloadMatrixFromPackedTexture(s.texture,...jS(t)).subarray(0,r);return this.disposeIntermediateTensorInfo(n),a}const a=K().getBool("WEBGL_PACK")&&!0===s,i=a?cT(t):t,o=a?new TT(i):new ST(i),l=this.runWebGLProgram(o,[{shape:i,dtype:n,dataId:e}],"float32"),u=this.texData.get(l.dataId),c=this.gpgpu.downloadByteEncodedFloatMatrixFromOutputTexture(u.texture,u.texShape[0],u.texShape[1]).subarray(0,r);return this.disposeIntermediateTensorInfo(l),c}timerAvailable(){return K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0}async time(e){const t=this.activeTimers,n=[];let s=!1;null==this.programTimersStack?(this.programTimersStack=n,s=!0):this.activeTimers.push(n),this.activeTimers=n,e();const r=h(this.activeTimers.map((e=>e.query))).filter((e=>null!=e)),a=h(this.activeTimers.map((e=>e.name))).filter((e=>null!=e));this.activeTimers=t,s&&(this.programTimersStack=null);const i={uploadWaitMs:this.uploadWaitMs,downloadWaitMs:this.downloadWaitMs,kernelMs:null,wallMs:null};if(K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0){const e=await Promise.all(r);i.kernelMs=o(e),i.getExtraProfileInfo=()=>e.map(((e,t)=>({name:a[t],ms:e}))).map((e=>`${e.name}: ${e.ms}`)).join(", ")}else i.kernelMs={error:"WebGL query timers are not supported in this environment."};return this.uploadWaitMs=0,this.downloadWaitMs=0,i}memory(){return{unreliable:!1,numBytesInGPU:this.numBytesInGPU,numBytesInGPUAllocated:this.textureManager.numBytesAllocated,numBytesInGPUFree:this.textureManager.numBytesFree}}startTimer(){return K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?this.gpgpu.beginQuery():{startMs:os(),endMs:null}}endTimer(e){return K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?(this.gpgpu.endQuery(),e):(e.endMs=os(),e)}async getQueryTime(e){if(K().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0)return this.gpgpu.waitForQueryAndGetTime(e);const t=e;return t.endMs-t.startMs}disposeData(e,t=!1){if(this.pendingDisposal.has(e))return!1;if(!this.texData.has(e))return!0;if(t?this.texData.get(e).refCount=0:this.texData.get(e).refCount--,!t&&this.texData.get(e).refCount>0)return!1;if(this.pendingRead.has(e))return this.pendingDisposal.add(e),this.pendingDeletes++,!1;this.releaseGPUData(e);const{complexTensorInfos:n}=this.texData.get(e);return null!=n&&(this.disposeData(n.real.dataId,t),this.disposeData(n.imag.dataId,t)),this.texData.delete(e),!0}releaseGPUData(e){const{texture:t,dtype:n,texShape:s,usage:r,isPacked:a,slice:i}=this.texData.get(e),o=i&&i.origDataId||e,l=this.dataRefCount.get(o);l>1?this.dataRefCount.set(o,l-1):(this.dataRefCount.delete(o),null!=t&&(this.numBytesInGPU-=this.computeBytes(s,n),this.textureManager.releaseTexture(t,s,r,a)));const u=this.texData.get(e);u.texture=null,u.texShape=null,u.isPacked=!1,u.slice=null}getTexture(e){return this.uploadToGPU(e),this.texData.get(e).texture}getDataInfo(e){return this.texData.get(e)}shouldExecuteOnCPU(e,t=128){return K().getBool("WEBGL_CPU_FORWARD")&&e.every((e=>null==this.texData.get(e.dataId).texture&&p(e.shape)<t))}getGPGPUContext(){return this.gpgpu}where(e){ep("tf.where() in webgl locks the UI thread. Call tf.whereAsync() instead");const t=e.dataSync();return qE(e.shape,t)}packedUnaryOp(e,t,n){const s=new HE(e.shape,t),r=this.compileAndRun(s,[e],n);return ri().makeTensorFromDataId(r.dataId,r.shape,r.dtype)}abs(e){if(this.shouldExecuteOnCPU([e])&&"complex64"!==e.dtype){const t=IE(this.texData.get(e.dataId).values);return this.makeOutput(e.shape,e.dtype,t)}if(K().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,UE,e.dtype);const t=new VE(e.shape,UE),n=this.compileAndRun(t,[e]);return ri().makeTensorFromDataId(n.dataId,n.shape,n.dtype)}makeTensorInfo(e,t,n){let s;if("string"===t&&null!=n&&n.length>0&&E(n[0])){const r=n.map((e=>us(e)));s=this.write(r,e,t)}else s=this.write(n,e,t);return this.texData.get(s).usage=null,{dataId:s,shape:e,dtype:t}}makeOutput(e,t,n){const{dataId:s}=this.makeTensorInfo(e,t,n);return ri().makeTensorFromDataId(s,e,t,this)}unpackTensor(e){const t=new jE(e.shape);return this.runWebGLProgram(t,[e],e.dtype)}packTensor(e){const t=new ME(e.shape);return this.runWebGLProgram(t,[e],e.dtype,null,!0)}packedReshape(e,t){const n=[lT(e.shape),...uT(e.shape)],s={dtype:e.dtype,shape:n,dataId:e.dataId},r=[lT(t),...uT(t)],a=new LE(r,n),i=this.runWebGLProgram(a,[s],e.dtype,null,!0);return{dataId:i.dataId,shape:t,dtype:i.dtype}}decode(e){const t=this.texData.get(e),{isPacked:n,shape:s,dtype:r}=t,a=cT(s);let i;i=n?new CT(a):new $T(a);return{dtype:r,shape:s,dataId:this.runWebGLProgram(i,[{shape:a,dtype:r,dataId:e}],r,null,!0).dataId}}runWebGLProgram(e,t,n,s,r=!1){const a=this.makeTensorInfo(e.outputShape,n),i=this.texData.get(a.dataId);if(e.packedOutput&&(i.isPacked=!0),e.outPackingScheme===VS.DENSE){const t=jS(e.outputShape);i.texShape=t.map((e=>2*e))}if(null!=e.outTexUsage&&(i.usage=e.outTexUsage),0===p(a.shape))return i.values=k(a.dtype,0),a;const o=[],l=t.map((t=>{if("complex64"===t.dtype)throw new Error("GPGPUProgram does not support complex64 input. For complex64 dtypes, please separate the program into real and imaginary parts.");let n=this.texData.get(t.dataId);if(null==n.texture){if(!e.packedInputs&&p(t.shape)<=K().getNumber("WEBGL_SIZE_UPLOAD_UNIFORM"))return{shape:t.shape,texData:null,isUniform:!0,uniformValues:n.values};e.packedInputs&&(n.isPacked=!0,n.shape=t.shape)}else if(!!n.isPacked!=!!e.packedInputs)t=n.isPacked?this.unpackTensor(t):this.packTensor(t),o.push(t),n=this.texData.get(t.dataId);else if(n.isPacked&&!pT(n.shape,t.shape)){const e=t,s=t.shape;t.shape=n.shape,t=this.packedReshape(t,s),o.push(t),n=this.texData.get(t.dataId),e.shape=s}return this.uploadToGPU(t.dataId),{shape:t.shape,texData:n,isUniform:!1}}));this.uploadToGPU(a.dataId);const u={shape:a.shape,texData:i,isUniform:!1},c=function(e,t,n){let s="";t.concat(n).forEach((e=>{const t=null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0,n=e.isUniform?"uniform":e.texData.texShape;s+=`${e.shape}_${n}_${t}`}));const r=e.userCode;let a=e.constructor.name;return a+="_"+s+"_"+r,a}(e,l,u),h=this.getAndSaveBinary(c,(()=>function(e,t,n,s){const r=t.userCode,a=n.map(((e,n)=>{const s={logicalShape:e.shape,texShape:e.isUniform?null:e.texData.texShape,isUniform:e.isUniform,isPacked:!e.isUniform&&e.texData.isPacked,flatOffset:null};return null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0&&(s.flatOffset=e.texData.slice.flatOffset),{name:t.variableNames[n],shapeInfo:s}})),i=a.map((e=>e.shapeInfo)),o={logicalShape:s.shape,texShape:s.texData.texShape,isUniform:!1,isPacked:s.texData.isPacked,flatOffset:null},l=UT(a,o,r,t.packedInputs),u=e.createProgram(l);let c=null;const h=e.getUniformLocation(u,"NAN",!1);1===K().getNumber("WEBGL_VERSION")&&(c=e.getUniformLocation(u,"INFINITY",!1));const p={};for(let n=0;n<t.variableNames.length;n++){const s=t.variableNames[n],r=!1;p[s]=e.getUniformLocation(u,s,r),p[`offset${s}`]=e.getUniformLocation(u,`offset${s}`,r)}return{program:t,source:l,webGLProgram:u,uniformLocations:p,inShapeInfos:i,outShapeInfo:o,infLoc:c,nanLoc:h}}(this.gpgpu,e,l,u))),d=null!=this.activeTimers;let f;d&&(f=this.startTimer()),function(e,t,n,s,r){nE(t.inShapeInfos,n),nE([t.outShapeInfo],[s]);const a=s.texData.texture,i=s.texData.texShape;s.texData.isPacked?e.setOutputPackedMatrixTexture(a,i[0],i[1]):e.setOutputMatrixTexture(a,i[0],i[1]),e.setProgram(t.webGLProgram),1===K().getNumber("WEBGL_VERSION")&&null!==t.infLoc&&e.gl.uniform1f(t.infLoc,1/0),null!==t.nanLoc&&e.gl.uniform1f(t.nanLoc,NaN),n.forEach(((n,s)=>{const r=t.program.variableNames[s],a=t.uniformLocations[r],i=t.uniformLocations[`offset${r}`];if(null!=a)if(n.isUniform)if(p(n.shape)<2)e.gl.uniform1f(a,n.uniformValues[0]);else{let t=n.uniformValues;t instanceof Float32Array||(t=new Float32Array(t)),e.gl.uniform1fv(a,t)}else null!=n.texData.slice&&null!=i&&e.gl.uniform1i(i,n.texData.slice.flatOffset),e.setInputMatrixTexture(n.texData.texture,a,s)})),null!=r&&r(e,t.webGLProgram),e.executeProgram()}(this.gpgpu,h,l,u,s),o.forEach((e=>this.disposeIntermediateTensorInfo(e))),d&&(f=this.endTimer(f),this.activeTimers.push({name:e.constructor.name,query:this.getQueryTime(f)}));const m=K().get("WEBGL_FLUSH_THRESHOLD");if(m>0){const e=os();e-this.lastGlFlushTime>m&&(this.gpgpu.gl.flush(),this.lastGlFlushTime=e)}if(!K().getBool("WEBGL_LAZILY_UNPACK")&&i.isPacked&&!1===r){const e=this.unpackTensor(a);return this.disposeIntermediateTensorInfo(a),e}return a}compileAndRun(e,t,n,s,r=!1){n=n||t[0].dtype;return this.runWebGLProgram(e,t,n,s,r)}getAndSaveBinary(e,t){return e in this.binaryCache||(this.binaryCache[e]=t()),this.binaryCache[e]}getTextureManager(){return this.textureManager}dispose(){if(!this.disposed){if(!K().getBool("IS_TEST")){Object.keys(this.binaryCache).forEach((e=>{this.gpgpu.deleteProgram(this.binaryCache[e].webGLProgram),delete this.binaryCache[e]}))}this.textureManager.dispose(),null!=this.canvas&&"undefined"!=typeof HTMLCanvasElement&&this.canvas instanceof HTMLCanvasElement?this.canvas.remove():this.canvas=null,this.gpgpuCreatedLocally&&(this.gpgpu.program=null,this.gpgpu.dispose()),this.disposed=!0}}floatPrecision(){return null==this.floatPrecisionValue&&(this.floatPrecisionValue=ii((()=>{if(!K().get("WEBGL_RENDER_FLOAT32_ENABLED")){const e=K().getBool("DEBUG");K().set("DEBUG",!1);const t=this.abs(Tu(1e-8)).dataSync()[0];if(K().set("DEBUG",e),t>0)return 32}return 16}))),this.floatPrecisionValue}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}uploadToGPU(e){const t=this.texData.get(e),{shape:n,dtype:s,values:r,texture:a,usage:o,isPacked:l}=t;if(null!=a)return;const u=null!=this.activeTimers;let c;u&&(c=os());let h=t.texShape;if(null==h&&(h=function(e,t=!1){let n=K().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(t&&(n*=2,1===(e=e.map(((t,n)=>n>=e.length-2?i(e[n]):e[n]))).length&&(e=[2,e[0]])),2!==e.length){const t=w(e);e=t.newShape}let s=p(e);if(e.length<=1&&s<=n)return[1,s];if(2===e.length&&e[0]<=n&&e[1]<=n)return e;if(3===e.length&&e[0]*e[1]<=n&&e[2]<=n)return[e[0]*e[1],e[2]];if(3===e.length&&e[0]<=n&&e[1]*e[2]<=n)return[e[0],e[1]*e[2]];if(4===e.length&&e[0]*e[1]*e[2]<=n&&e[3]<=n)return[e[0]*e[1]*e[2],e[3]];if(4===e.length&&e[0]<=n&&e[1]*e[2]*e[3]<=n)return[e[0],e[1]*e[2]*e[3]];if(t){const t=lT(e);let n=2,r=2;return e.length&&([n,r]=uT(e)),s=t*(n/2)*(r/2),m(s).map((e=>2*e))}return m(s)}(n,l),t.texShape=h),null!=r){const e=cT(n);let a,i=h[1],o=h[0];const p=r instanceof Uint8Array;l?([i,o]=qS(h[0],h[1]),a=new AT(e,[o,i],p)):a=new ET(e,[o,i],p);const d=this.makeTensorInfo([o,i],s);this.texData.get(d.dataId).usage=p?US.PIXELS:US.UPLOAD,this.gpgpu.uploadDenseMatrixToTexture(this.getTexture(d.dataId),i,o,r);const f=!0,m=this.runWebGLProgram(a,[d],s,null,f),g=this.texData.get(m.dataId);t.texture=g.texture,t.texShape=g.texShape,t.isPacked=g.isPacked,t.usage=g.usage,this.disposeIntermediateTensorInfo(d),this.texData.delete(m.dataId),t.values=null,u&&(this.uploadWaitMs+=os()-c)}else{const e=this.acquireTexture(h,o,s,l);t.texture=e}}convertAndCacheOnCPU(e,t){const n=this.texData.get(e),{dtype:s}=n;return this.releaseGPUData(e),null!=t&&(n.values=function(e,t){if("float32"===t||"complex64"===t)return e;if("int32"===t||"bool"===t){const n="int32"===t?new Int32Array(e.length):new Uint8Array(e.length);for(let t=0;t<n.length;++t)n[t]=Math.round(e[t]);return n}throw new Error(`Unknown dtype ${t}`)}(t,s)),n.values}acquireTexture(e,t,n,s){if(this.numBytesInGPU+=this.computeBytes(e,n),!this.warnedAboutMemory&&this.numBytesInGPU>1024*this.numMBBeforeWarning*1024){const e=(this.numBytesInGPU/1024/1024).toFixed(2);this.warnedAboutMemory=!0,console.warn(`High memory usage in GPU: ${e} MB, most likely due to a memory leak`)}return this.textureManager.acquireTexture(e,t,s)}computeBytes(e,t){return e[0]*e[1]*S(t)}}XE.nextDataId=0;Ks()&&ci("webgl",(()=>new XE),2);class YE{constructor(e,t,n){this.variableNames=["A","B"],this.outputShape=So(t,n),this.userCode=`\n      float binaryOperation(float a, float b) {\n        ${e}\n      }\n\n      void main() {\n        float a = getAAtOutCoords();\n        float b = getBAtOutCoords();\n        setOutput(binaryOperation(a, b));\n      }\n    `}}class JE{constructor(e,t,n,s=!1){this.variableNames=["A","B"],this.supportsBroadcasting=!0,this.packedInputs=!0,this.packedOutput=!0,this.outputShape=So(t,n);const r=this.outputShape.length;let a="";if(s)if(0===r||1===p(this.outputShape))a="\n          result.y = 0.;\n          result.z = 0.;\n          result.w = 0.;\n        ";else{if(a=`\n          ${QT(r)} coords = getOutputCoords();\n        `,1===r)a+=`\n            result.y = (coords + 1) >= ${this.outputShape[0]} ? 0. : result.y;\n            result.z = 0.;\n            result.w = 0.;\n          `;else{const e=OE("coords",r);a+=`\n            bool nextRowOutOfBounds =\n              (${e[r-2]} + 1) >= ${this.outputShape[r-2]};\n            bool nextColOutOfBounds =\n              (${e[r-1]} + 1) >= ${this.outputShape[r-1]};\n            result.y = nextColOutOfBounds ? 0. : result.y;\n            result.z = nextRowOutOfBounds ? 0. : result.z;\n            result.w = nextColOutOfBounds || nextRowOutOfBounds ? 0. : result.w;\n          `}}this.userCode=`\n      vec4 binaryOperation(vec4 a, vec4 b) {\n        ${e}\n      }\n\n      void main() {\n        vec4 a = getAAtOutCoords();\n        vec4 b = getBAtOutCoords();\n\n        vec4 result = binaryOperation(a, b);\n        ${a}\n\n        setOutput(result);\n      }\n    `}}function ZE(e){const{inputs:t,backend:n}=e,{x:s}=t;return n.incRef(s.dataId),{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}const QE={kernelName:ct,backendName:"webgl",kernelFunc:ZE};function eA(e){const{inputs:t,backend:n}=e,{real:s,imag:r}=t,a=n.makeTensorInfo(s.shape,"complex64"),i=n.texData.get(a.dataId),o=ZE({inputs:{x:s},backend:n}),l=ZE({inputs:{x:r},backend:n});return i.complexTensorInfos={real:o,imag:l},a}const tA={kernelName:Ne,backendName:"webgl",kernelFunc:eA},nA="return (a < 0.) ? b * a : a;",sA="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const rA={kernelName:gt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{alpha:a}=s,i=n.makeTensorInfo([],"float32",as(a,"float32")),o=K().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new JE(sA,r.shape,i.shape):new YE(nA,r.shape,i.shape),l=n.runWebGLProgram(o,[r,i],r.dtype);return n.disposeIntermediateTensorInfo(i),l}},aA="return (a < 0.) ? b * a : a;",iA="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const oA={kernelName:Zt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s,alpha:r}=t,a=K().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new JE(iA,s.shape,r.shape):new YE(aA,s.shape,r.shape);return n.runWebGLProgram(a,[s,r],s.dtype)}};function lA({opSnippet:e,packedOpSnippet:t,cpuKernelImpl:n,dtype:s}){return({inputs:r,backend:a})=>{const{x:i}=r,o=a,l=s||i.dtype;if(o.shouldExecuteOnCPU([i])&&null!=n){const e=o.texData.get(i.dataId),t=n(e.values,l);return o.makeTensorInfo(i.shape,l,t)}let u;return u=K().getBool("WEBGL_PACK_UNARY_OPERATIONS")&&null!=t?new HE(i.shape,t):new VE(i.shape,e),o.runWebGLProgram(u,[i],l)}}function uA({opSnippet:e,packedOpSnippet:t,checkOutOfBounds:n=!1,supportsComplex:s=!1,cpuKernelImpl:r,dtype:a}){return({inputs:i,backend:o})=>{const{a:l,b:u}=i,c=o;if(s&&"complex64"===l.dtype){const t=c.texData.get(l.dataId),n=c.texData.get(u.dataId),[s,r]=[[t.complexTensorInfos.real,n.complexTensorInfos.real],[t.complexTensorInfos.imag,n.complexTensorInfos.imag]].map((t=>{const[n,s]=t,r={dataId:n.dataId,dtype:n.dtype,shape:l.shape},a={dataId:s.dataId,dtype:s.dtype,shape:u.shape},i=new YE(e,l.shape,u.shape);return c.runWebGLProgram(i,[r,a],Ds(n.dtype,s.dtype))})),a=eA({inputs:{real:s,imag:r},backend:c});return c.disposeIntermediateTensorInfo(s),c.disposeIntermediateTensorInfo(r),a}const h=a||Ds(l.dtype,u.dtype);if(c.shouldExecuteOnCPU([l,u])&&null!=r){const e=c.texData.get(l.dataId),t=c.texData.get(u.dataId),[n,s]=r(l.shape,u.shape,e.values,t.values,h),a=c.makeTensorInfo(s,h);return c.texData.get(a.dataId).values=n,a}let p;return p=K().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&null!=t?new JE(t,l.shape,u.shape,n):new YE(e,l.shape,u.shape),c.runWebGLProgram(p,[l,u],h)}}function cA(e,t=!1){if("linear"===e)return"return x;";if("relu"===e)return t?"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n";if("elu"===e)return t?"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n":"return (x >= 0.0) ? x : (exp(x) - 1.0);";if("relu6"===e)return t?"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n";if("prelu"===e)return t?iA:aA;if("leakyrelu"===e)return t?sA:nA;if("sigmoid"===e)return"return 1.0 / (1.0 + exp(-1.0 * x));";throw new Error(`Activation ${e} has not been implemented for the WebGL backend.`)}class hA{constructor(e,t,n,s=!1,r=!1,a=!1,i=null,o=!1,l=!1){this.variableNames=["matrixA","matrixB"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=n;const u=s?e[1]:e[2],c=Math.ceil(u/2),h=s?"i * 2, rc.y":"rc.y, i * 2",p=r?"rc.z, i * 2":"i * 2, rc.z",d=s?["a.xxyy","a.zzww"]:["a.xxzz","a.yyww"],f=r?["b.xzxz","b.ywyw"]:["b.xyxy","b.zwzw"];let m="",g="";i&&(m=o?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${i}\n        }`:l?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${i}\n        }`:`vec4 activation(vec4 x) {\n          ${i}\n        }`,g="result = activation(result);");const y=a?"result += getBiasAtOutCoords();":"";a&&this.variableNames.push("bias"),o&&this.variableNames.push("preluActivationWeights"),l&&this.variableNames.push("leakyreluAlpha");let b="rc.x",x="rc.x";e[0]<t[0]?b=`int(min(float(rc.x), ${e[0]-1}.))`:t[0]<e[0]&&(x=`int(min(float(rc.x), ${t[0]-1}.))`),this.userCode=`\n      ${m}\n\n      const float sharedDimension = ${c}.0;\n\n      vec4 dot2x2ARowBCol(ivec3 rc) {\n        vec4 result = vec4(0);\n        for (int i = 0; i < ${c}; i++) {\n          int batchA = ${b};\n          int batchB = ${x};\n          vec4 a = getMatrixA(batchA, ${h});\n          vec4 b = getMatrixB(batchB, ${p});\n\n          // These swizzled products need to be separately added.\n          // See: https://github.com/tensorflow/tfjs/issues/1735\n          result += (${d[0]} * ${f[0]});\n          result += (${d[1]} * ${f[1]});\n        }\n        return result;\n      }\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n        vec4 result = dot2x2ARowBCol(rc);\n\n        ${y}\n\n        ${g}\n\n        setOutput(result);\n      }\n    `}}const pA="return areal * breal - aimag * bimag;",dA="return areal * bimag + aimag * breal;";class fA{constructor(e,t,n){this.variableNames=["AReal","AImag","BReal","BImag"],this.outputShape=So(t,n),this.userCode=`\n      float binaryOpComplex(\n          float areal, float aimag, float breal, float bimag) {\n        ${e}\n      }\n\n      void main() {\n        float areal = getARealAtOutCoords();\n        float aimag = getAImagAtOutCoords();\n        float breal = getBRealAtOutCoords();\n        float bimag = getBImagAtOutCoords();\n        setOutput(binaryOpComplex(areal, aimag, breal, bimag));\n      }\n    `}}const mA="return a * b;";function gA(e){const{inputs:t,backend:n}=e,{a:s,b:r}=t,a=Ds(s.dtype,r.dtype);if("complex64"===s.dtype){const e=n.texData.get(s.dataId),t=n.texData.get(r.dataId),a=new fA(pA,s.shape,r.shape),i=new fA(dA,s.shape,r.shape),o=[{dataId:e.complexTensorInfos.real.dataId,dtype:e.complexTensorInfos.real.dtype,shape:s.shape},{dataId:e.complexTensorInfos.imag.dataId,dtype:e.complexTensorInfos.imag.dtype,shape:s.shape},{dataId:t.complexTensorInfos.real.dataId,dtype:t.complexTensorInfos.real.dtype,shape:r.shape},{dataId:t.complexTensorInfos.imag.dataId,dtype:t.complexTensorInfos.imag.dtype,shape:r.shape}],l=n.runWebGLProgram(a,o,"float32"),u=n.runWebGLProgram(i,o,"float32"),c=eA({inputs:{real:l,imag:u},backend:n});return n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(u),c}if(n.shouldExecuteOnCPU([s,r])){const e=n.texData.get(s.dataId),t=n.texData.get(r.dataId),[i,o]=xE(s.shape,r.shape,e.values,t.values,a),l=n.makeTensorInfo(o,a);return n.texData.get(l.dataId).values=i,l}let i;return i=K().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new JE(mA,s.shape,r.shape):new YE(mA,s.shape,r.shape),n.runWebGLProgram(i,[s,r],a)}const yA={kernelName:Wt,backendName:"webgl",kernelFunc:gA};function bA(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{shape:a}=s,i=n,o=p(r.shape),u=b(a,o),c=p(u);l(o===c,(()=>`The new shape (${u}) has ${c} elements and the old shape (${r.shape}) has ${o} elements. The new shape and old shape must have the same number of elements.`));const h=i.texData.get(r.dataId);return!h.isPacked||pT(r.shape,u)||null!==h.texture&&pT(h.shape,u)?(i.incRef(r.dataId),{dataId:r.dataId,shape:u,dtype:r.dtype}):function(e,t,n){const s=[lT(e.shape),...uT(e.shape)],r={dtype:e.dtype,shape:s,dataId:e.dataId},a=[lT(t),...uT(t)],i=new LE(a,s),o=n.runWebGLProgram(i,[r],e.dtype,null,!0);return{dataId:o.dataId,shape:t,dtype:o.dtype}}(r,u,i)}const xA={kernelName:rn,backendName:"webgl",kernelFunc:bA};class wA{constructor(e,t){this.variableNames=["x"];const{windowSize:n,batchSize:s,inSize:r,outSize:a}=e;this.outputShape=[s,a];const i=4*Math.floor(n/4),o=n%4;let l="sumValue += dot(values, ones);";if(null!=t){const e=1/t;l=`sumValue += dot(values * ${f(e)?e.toPrecision(2):e}, ones);`}let u="";r%n>0&&(u=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return 0.0;\n        }\n      `),this.userCode=`\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${u}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${i}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${l}\n        }\n\n        int inIdx = inOffset + ${i};\n        if (${1===o}) {\n          vec4 values = vec4(getValue(batch, inIdx), 0.0, 0.0, 0.0);\n\n          ${l}\n        } else if (${2===o}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1), 0.0, 0.0);\n\n          ${l}\n        } else if (${3===o}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2), 0.0);\n\n          ${l}\n        }\n        setOutput(sumValue);\n      }\n    `}}class kA{constructor(e,t){this.variableNames=["x"];const{windowSize:n,batchSize:s,inSize:r,outSize:a}=e;this.outputShape=[s,a];let i="0.0",o="";"prod"===t?i="1.0":"min"===t?(i="1.0 / 1e-20",o="min"):"max"===t&&(i="-1.0 / 1e-20",o="max");let l=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"sum"===t?l="sumValue":"prod"===t?l="prodValue":"all"===t?l="allValue":"any"===t&&(l="anyValue");const u=4*Math.floor(n/4),c=n%4;let h=`\n      if (${"sum"===t}) {\n        sumValue += dot(values, ones);\n      } else if (${"prod"===t}) {\n        vec2 tmp = vec2(values[0], values[1]) * vec2(values[2], values[3]);\n        prodValue *= tmp[0] * tmp[1];\n      } else {\n        minMaxValue = ${o}(values, minMaxValue);\n      }\n    `,p="vec4";"all"===t?(i="1.0",h="\n        bool reducedAllValue = all(values);\n        float floatedReducedAllValue = float(reducedAllValue);\n        allValue = float(allValue >= 1.0 && floatedReducedAllValue >= 1.0);\n      ",p="bvec4"):"any"===t&&(i="0.0",h="\n        bool reducedAnyValue = any(values);\n        float floatedReducedAnyValue = float(reducedAnyValue);\n        anyValue = float(anyValue >= 1.0 || floatedReducedAnyValue >= 1.0);\n      ",p="bvec4");let d="";r%n>0&&(d=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return initializationValue;\n        }\n      `),this.userCode=`\n      const float initializationValue = ${i};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${d}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        vec4 minMaxValue = vec4(${i});\n        float prodValue = 1.0;\n        float sumValue = 0.0;\n        float allValue = 1.0;\n        float anyValue = 0.0;\n\n        for (int i = 0; i < ${u}; i += 4) {\n          int inIdx = inOffset + i;\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${h}\n        }\n\n        int inIdx = inOffset + ${u};\n        if (${1===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          ${h}\n        } else if (${2===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          ${h}\n        } else if (${3===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          ${h}\n        }\n        setOutput(${l});\n      }\n    `}}function vA(e,t,n,s){const r=function(e){const t=[];for(;0===t.length||1!==t[t.length-1].outSize;){const n=t.length?t[t.length-1].outSize:e[1],s=Bh(n);t.push({inSize:n,windowSize:s,outSize:Math.ceil(n/s)})}return t}(e.shape);let a=e;for(let i=0;i<r.length;i++){const{inSize:o,windowSize:l,outSize:u}=r[i];let c,h;c="mean"===n?0===i?new wA({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u},o):new wA({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u}):new kA({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u},n),h=a,a=s.runWebGLProgram(c,[a],t),h.dataId!==e.dataId&&s.disposeIntermediateTensorInfo(h)}return a}class NA{constructor(e,t){this.variableNames=["A"];const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[t[s]];this.outputShape=n,this.rank=n.length;const s=QT(this.rank),r=function(e){const t=e.length;if(t>6)throw Error(`Transpose for rank ${t} is not yet supported`);const n=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u","resRC.v"],s=new Array(t);for(let t=0;t<e.length;t++)s[e[t]]=n[t];return s.join()}(t);this.userCode=`\n    void main() {\n      ${s} resRC = getOutputCoords();\n      setOutput(getA(${r}));\n    }\n    `}}class IA{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0;const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[t[s]];if(this.outputShape=n,this.rank=n.length,this.rank>6)throw Error(`Packed transpose for rank ${this.rank} is not yet supported.`);const s=QT(this.rank),r=_E("rc",this.rank),a=new Array(this.rank);for(let e=0;e<t.length;e++)a[t[e]]=r[e];const i=`vec2(${a.slice(-2).join()})`,o=`++${r[this.rank-1]} < ${n[this.rank-1]}`,l=`getChannel(getA(${a.join()}), ${i})`;this.userCode=`\n    void main() {\n      ${s} rc = getOutputCoords();\n      vec4 result = vec4(0.);\n      result[0] = ${l};\n      if(${o}) {\n        result[1] = ${l};\n      }\n      --${r[this.rank-1]};\n      if(++${r[this.rank-2]} < ${n[this.rank-2]}) {\n        result[2] = ${l};\n        if(${o}) {\n          result[3] = ${l};\n        }\n      }\n      setOutput(result);\n    }\n    `}}function $A(e,t,n){const s=K().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new IA(e.shape,t):new NA(e.shape,t);return n.runWebGLProgram(s,[e],e.dtype)}function CA(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;return function(e,t,n,s){const r=t,a=e.shape.length,i=x(r,e.shape);let o=i;const l=bl(o,a),u=null!=l;let c=e;u&&(c=$A(e,l,s),o=wl(o.length,a)),yl("sum",o,a);const[h,d]=ml(c.shape,o);let f=h;n&&(f=gl(h,i));const m=p(d),g=bA({inputs:{x:c},attrs:{shape:[p(e.shape)/m,m]},backend:s}),y=vA(g,_s(e.dtype),"sum",s),b=bA({inputs:{x:y},attrs:{shape:f},backend:s});return s.disposeIntermediateTensorInfo(g),s.disposeIntermediateTensorInfo(y),u&&s.disposeIntermediateTensorInfo(c),b}(r,a,i,n)}const SA={kernelName:In,backendName:"webgl",kernelFunc:CA};function TA(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{perm:a}=s,i=n,o=r.shape.length,l=new Array(o);for(let e=0;e<l.length;e++)l[e]=r.shape[a[e]];let u;if(i.shouldExecuteOnCPU([r])){const e=i.texData.get(r.dataId).values,t=FE(e,r.shape,r.dtype,a,l);u=i.makeTensorInfo(l,r.dtype);i.texData.get(u.dataId).values=t}else u=$A(r,a,i);return u}const EA={kernelName:Pn,backendName:"webgl",kernelFunc:TA};function AA({a:e,b:t,transposeA:n,transposeB:s,backend:r,bias:a=null,preluActivationWeights:i=null,leakyreluAlpha:o=0,activation:u=null}){const c=e.shape.length,h=t.shape.length,d=n?e.shape[c-2]:e.shape[c-1],f=s?t.shape[h-1]:t.shape[h-2],m=n?e.shape[c-1]:e.shape[c-2],g=s?t.shape[h-2]:t.shape[h-1],y=e.shape.slice(0,-2),b=t.shape.slice(0,-2),x=p(y),w=p(b);l(c>=2&&h>=2&&(x===w||1===x||1===w),(()=>`Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of (${y}) and (${b}).`));const k=(x>w?e.shape.slice(0,-2):t.shape.slice(0,-2)).concat([m,g]);l(d===f,(()=>`Error in matMul: inner shapes (${d}) and (${f}) of Tensors with shapes ${e.shape} and ${t.shape} and transposeA=${n} and transposeB=${s} must match.`));const v=n?[x,d,m]:[x,m,d],N=s?[w,g,f]:[w,f,g],I=bA({inputs:{x:e},backend:r,attrs:{shape:v}}),$=bA({inputs:{x:t},backend:r,attrs:{shape:N}}),C=[I,$],S=Math.max(x,w),T=n?I.shape[1]:I.shape[2],E=null!=a,A=null!=i,R="leakyrelu"===u,F=null!=u?cA(u,!0):null;let D;if((1===m||1===g)&&T>1e3&&!1===(E||A||R||null!=F)){let e=I,t=$;n&&(e=TA({inputs:{x:I},backend:r,attrs:{perm:[0,2,1]}}),C.push(e)),s&&(t=TA({inputs:{x:$},backend:r,attrs:{perm:[0,2,1]}}),C.push(t));const a=1===g;let i=e;1!==g&&(i=bA({inputs:{x:e},backend:r,attrs:{shape:[S,T,1]}}),C.push(i));const o=1===g?2:1;let l=t;a&&(l=bA({inputs:{x:t},backend:r,attrs:{shape:[S,1,T]}}),C.push(l));const u=gA({inputs:{a:i,b:l},backend:r});D=CA({inputs:{x:u},backend:r,attrs:{axis:o,keepDims:!0}}),C.push(u)}else{const l=Ds(e.dtype,t.dtype),u=new hA(v,N,[S,m,g],n,s,E,F,A,R),c=[I,$];if(null!=a&&c.push(a),A&&c.push(i),R){const e=r.makeTensorInfo([],"float32",as(o,"float32"));c.push(e),C.push(e)}D=r.runWebGLProgram(u,c,l)}const _=bA({inputs:{x:D},backend:r,attrs:{shape:k}});C.push(D);for(const e of C)r.disposeIntermediateTensorInfo(e);return _}const RA={kernelName:Kn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a,bias:i,preluActivationWeights:o}=t,{transposeA:l,transposeB:u,activation:c,leakyreluAlpha:h}=s;return AA({a:r,b:a,transposeA:l,transposeB:u,backend:n,bias:i,preluActivationWeights:o,leakyreluAlpha:h,activation:c})}},FA="return abs(x);";const DA={kernelName:Z,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;if(n.shouldExecuteOnCPU([s])&&"complex64"!==s.dtype){const e=n.texData.get(s.dataId),t=IE(e.values);return n.makeTensorInfo(s.shape,s.dtype,t)}let r;return r=K().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new HE(s.shape,FA):new VE(s.shape,FA),n.runWebGLProgram(r,[s],s.dtype)}},_A=lA({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return acos(x);\n"}),OA={kernelName:Q,backendName:"webgl",kernelFunc:_A},MA=lA({opSnippet:"if (isnan(x)) return x;\n  if (x < 1.0) return NAN;\nreturn log(x + sqrt(x * x - 1.0));"}),LA={kernelName:ee,backendName:"webgl",kernelFunc:MA},zA="return a + b;",BA=uA({opSnippet:zA,packedOpSnippet:zA,supportsComplex:!0,cpuKernelImpl:sE}),PA={kernelName:te,backendName:"webgl",kernelFunc:BA};class WA{constructor(e,t){this.outputShape=[],this.outputShape=e,this.variableNames=t.map(((e,t)=>`T${t}`));const n=[];this.variableNames.forEach((e=>{n.push(`float v${e} = get${e}AtOutCoords();`)}));const s=this.variableNames.map((e=>`v${e}`)).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        float result = ${s};\n        setOutput(result);\n      }\n    `}}class VA{constructor(e,t){this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.variableNames=t.map(((e,t)=>`T${t}`));const n=[];this.variableNames.forEach((e=>{n.push(`vec4 v${e} = get${e}AtOutCoords();`)}));const s=this.variableNames.map((e=>`v${e}`)).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        vec4 result = ${s};\n        setOutput(result);\n      }\n    `}}const UA={kernelName:ne,backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s}=t,r=n;if(1===r.length)return ZE({inputs:{x:r[0]},backend:s});if(r.length>K().get("WEBGL_MAX_TEXTURES_IN_SHADER")){const t=Math.floor(r.length/2),n=e({inputs:r.slice(0,t),backend:s}),a=e({inputs:r.slice(t),backend:s});return e({inputs:[n,a],backend:s})}const a=r.map((e=>e.dtype)).reduce(((e,t)=>Ds(e,t))),i=r.map((e=>e.shape)),o=K().getBool("WEBGL_PACK")?new VA(r[0].shape,i):new WA(r[0].shape,i);return s.runWebGLProgram(o,r,a)}};const GA={kernelName:se,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=x(a,r.shape);let u=l;const c=bl(u,o);let h=r;null!=c&&(h=TA({inputs:{x:r},backend:n,attrs:{perm:c}}),u=wl(u.length,o)),yl("all",u,o);const[d,f]=ml(h.shape,u),m=bA({inputs:{x:h},backend:n,attrs:{shape:[-1,p(f)]}}),g=vA(m,m.dtype,"all",n);let y;if(i){y=bA({inputs:{x:g},backend:n,attrs:{shape:gl(d,l)}})}else y=bA({inputs:{x:g},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(h),y}};const HA={kernelName:re,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=x(a,r.shape);let u=l;const c=bl(u,o);let h=r;null!=c&&(h=TA({inputs:{x:r},backend:n,attrs:{perm:c}}),u=wl(u.length,o)),yl("any",u,o);const[d,f]=ml(h.shape,u),m=bA({inputs:{x:h},backend:n,attrs:{shape:[-1,p(f)]}}),g=vA(m,m.dtype,"any",n);let y;if(i){y=bA({inputs:{x:g},backend:n,attrs:{shape:gl(d,l)}})}else y=bA({inputs:{x:g},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(h),y}};class jA{constructor(e,t,n){this.variableNames=["A"];const{windowSize:s,batchSize:r,outSize:a}=e;n||this.variableNames.push("bestIndicesA"),this.outputShape=[r,a];const i="max"===t?">":"<",o=n?"inOffset + i;":"round(getBestIndicesA(batch, inOffset + i));";this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${s};\n\n        int bestIndex = inOffset;\n        float bestValue = getA(batch, bestIndex);\n\n        for (int i = 0; i < ${s}; i++) {\n          int inIdx = ${o};\n          float candidate = getA(batch, inIdx);\n          if (candidate ${i} bestValue) {\n            bestValue = candidate;\n            bestIndex = inIdx;\n          }\n        }\n        setOutput(float(bestIndex));\n      }\n    `}}class qA{constructor(e,t,n,s){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,l(e.length>2,(()=>`Packed arg${n.charAt(0).toUpperCase()+n.slice(1)} supports only inputs with rank above 2.`));const r=e[e.length-1],a=Math.ceil(r/t);this.outputShape=e.slice(0,-1),a>1&&this.outputShape.push(a),s||this.variableNames.push("bestIndicesA");const i=this.outputShape,o=i.length,u=QT(o),c=OE("coords",o);let h,p;if(1===a){p=o+1;const e=QT(p);h=`\n        ${e} sourceLocR = ${e}(${c.join()}, 0);\n        ++${c[o-1]};\n        ${e} sourceLocG = ${e}(${c.join()}, 0);\n        ++${c[o-2]};\n        ${e} sourceLocA = ${e}(${c.join()}, 0);\n        --${c[o-1]};\n        ${e} sourceLocB = ${e}(${c.join()}, 0);\n        --${c[o-2]};`}else p=o,h=`\n        ${u} sourceLocR = coords;\n        ++${c[o-1]};\n        ${u} sourceLocG = coords;\n        ++${c[o-2]};\n        ${u} sourceLocA = coords;\n        --${c[o-1]};\n        ${u} sourceLocB = coords;\n        --${c[o-2]};`;const d=["x","y","z","w","u","v"].slice(0,p),f="."+d[p-1],m=d.map((e=>"int "+e)),g=OE("sourceLocR",p-1).concat("inIdx.r"),y=OE("sourceLocG",p-1).concat("inIdx.g"),b=OE("sourceLocB",p-1).concat("inIdx.b"),x=OE("sourceLocA",p-1).concat("inIdx.a"),w="max"===n?"greaterThan":"lessThan",k=s?"":`\n          inIdx = round(vec4(getBestIndicesAChannel(${g.join()}),\n                             getBestIndicesAChannel(${y.join()}),\n                             getBestIndicesAChannel(${b.join()}),\n                             getBestIndicesAChannel(${x.join()})));`,v=`vec4(\n            getAChannel(${g.join()}),\n            hasNextCol ? getAChannel(${y.join()}) : 0.,\n            hasNextRow ? getAChannel(${b.join()}) : 0.,\n            hasNextRow && hasNextCol ? getAChannel(${x.join()}) : 0.)`,N=s?"":`\n      float getBestIndicesAChannel(${m.join()}) {\n        return getChannel(getBestIndicesA(${d.join()}),\n                                          vec2(${d.slice(-2).join()}));\n      }`;this.userCode=`\n      float getAChannel(${m.join()}) {\n        return getChannel(getA(${d.join()}),\n                               vec2(${d.slice(-2).join()}));\n      }\n      ${N}\n      void main() {\n        ${u} coords = getOutputCoords();\n        bool hasNextCol = ${c[o-1]} < ${i[o-1]-1};\n        bool hasNextRow = ${c[o-2]} < ${i[o-2]-1};\n        ${h}\n        ivec4 srcIdx = ivec4(sourceLocR${f}, sourceLocG${f},\n          sourceLocB${f}, sourceLocA${f}) * ${t};\n        ivec4 inIdx = srcIdx;\n        vec4 bestIndex = vec4(inIdx);\n        vec4 bestValue = ${v};\n\n        for (int i = 0; i < ${t}; i++) {\n          inIdx = srcIdx;\n          ${k}\n          vec4 candidate = ${v};\n          bvec4 nan = isnan(candidate);\n          bvec4 replace = bvec4(\n            vec4(${w}(candidate, bestValue)) * (vec4(1.0) - vec4(nan)));\n\n          bestValue = vec4(replace.x  ? candidate.x : bestValue.x,\n                           replace.y  ? candidate.y : bestValue.y,\n                           replace.z  ? candidate.z : bestValue.z,\n                           replace.w  ? candidate.w : bestValue.w);\n          bestIndex = mix(bestIndex, vec4(inIdx), vec4(replace));\n          srcIdx++;\n        }\n        setOutput(bestIndex);\n      }\n    `}}function KA(e,t,n,s=null){let r=t.shape[0],a=t.shape[1];null!=s&&(r=s.shape[0],a=s.shape[1]);const i=Bh(a),o={windowSize:i,inSize:a,batchSize:r,outSize:Math.ceil(a/i)},l=new jA(o,n,null==s),u=[t];null!=s&&u.push(s);const c=e.runWebGLProgram(l,u,"int32");if(1===c.shape[1])return c;const h=KA(e,t,n,c);return e.disposeIntermediateTensorInfo(c),h}function XA(e,t,n,s=null){const r=null!=s?s.shape:t.shape,a=Bh(r[r.length-1]),i=new qA(r,a,n,null==s),o=null==s?[t]:[t,s],l=e.runWebGLProgram(i,o,"int32");if(l.shape.length===t.shape.length){const s=XA(e,t,n,l);return e.disposeIntermediateTensorInfo(l),s}return l}function YA(e,t,n,s){const r=[n];if(yl("arg"+s.charAt(0).toUpperCase()+s.slice(1),r,t.shape.length),!K().getBool("WEBGL_PACK_REDUCE")||t.shape.length<=2){const n=[],[a,i]=ml(t.shape,r),o=p(i),l=bA({inputs:{x:t},backend:e,attrs:{shape:[-1,o]}});n.push(l);const u=KA(e,l,s);n.push(u);const c=bA({inputs:{x:u},backend:e,attrs:{shape:a}});return n.forEach((t=>e.disposeIntermediateTensorInfo(t))),c}return XA(e,t,s)}const JA={kernelName:ae,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;let i=x(a,r.shape);const o=bl(i,r.shape.length);let l=r;const u=[];null!=o&&(l=TA({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=wl(i.length,l.shape.length)),yl("argMax",[i[0]],l.shape.length);const c=YA(n,l,i[0],"max");return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),c}};const ZA={kernelName:ie,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;let i=x(a,r.shape);const o=bl(i,r.shape.length);let l=r;const u=[];null!=o&&(l=TA({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=wl(i.length,l.shape.length)),yl("argMin",[i[0]],l.shape.length);const c=YA(n,l,i[0],"min");return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),c}},QA=lA({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return asin(x);\n"}),eR={kernelName:oe,backendName:"webgl",kernelFunc:QA},tR=lA({opSnippet:"if (isnan(x)) return x;return log(x + sqrt(x * x + 1.0));"}),nR={kernelName:le,backendName:"webgl",kernelFunc:tR},sR=lA({opSnippet:"if (isnan(x)) return x;\n  return atan(x);\n"}),rR={kernelName:ue,backendName:"webgl",kernelFunc:sR},aR=uA({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return atan(a, b);\n",packedOpSnippet:"\n  vec4 result = atan(a, b);\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),iR={kernelName:he,backendName:"webgl",kernelFunc:aR},oR=lA({opSnippet:"if (isnan(x)) return x;\n  if ((x < -1.0) || (x > 1.0)) return NAN;\nreturn (log(1.0 + x) - log(1.0 - x)) / 2.0;"}),lR={kernelName:ce,backendName:"webgl",kernelFunc:oR};class uR{constructor(e,t,n,s=!1,r=!1){if(this.variableNames=["x"],"avg"===t&&n)throw new Error("Cannot compute positions for average pool.");const a=e.filterWidth,i=e.strideHeight,o=e.strideWidth,l=e.dilationHeight,u=e.dilationWidth,c=e.effectiveFilterHeight,h=e.effectiveFilterWidth,p=e.padInfo.top,d=e.padInfo.left;this.outputShape=e.outShape;const f="avg"===t,m=`((batch  * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + d`,g=`(xR * ${e.inWidth} + xC) * ${e.inChannels} + d`;let y="0.0";if(f||(y="-1.0 / 1e-20"),n){const t=">=";return void(this.userCode=`\n        const ivec2 strides = ivec2(${i}, ${o});\n        const ivec2 pads = ivec2(${p}, ${d});\n\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int batch = coords[0];\n          int d = coords[3];\n\n          ivec2 xRCCorner = coords.yz * strides - pads;\n          int xRCorner = xRCCorner.x;\n          int xCCorner = xRCCorner.y;\n\n          // max/min x(?, ?, d) to get y(yR, yC, d).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n          float avgValue = 0.0;\n\n          for (int wR = 0; wR < ${c};\n              wR += ${l}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${h};\n                wC += ${u}) {\n              int xC = xCCorner + wC;\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float value = getX(batch, xR, xC, d);\n\n              // If a min / max value has already been found, use it. If not,\n              // use the current value.\n              float currMinMaxValue = mix(\n                  value, minMaxValue, minMaxValueFound);\n              if (value ${t} currMinMaxValue) {\n                minMaxValue = value;\n                minMaxValueFound = 1.0;\n                minMaxPosition = ${s?r?m:g:`wR * ${h} + wC`};\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let b=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===t&&(b="avgValue / count");const x=4*Math.floor(a/4),w=a%4,k=`\n      if (${f}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec2 strides = ivec2(${i}, ${o});\n      const ivec2 pads = ivec2(${p}, ${d});\n      const float initializationValue = ${y};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xR, int xC, int d) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xR, xC, d);\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d = coords[3];\n\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // max/min x(?, ?, d) to get y(yR, yC, d).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${y});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wR = 0; wR < ${c};\n            wR += ${l}) {\n          int xR = xRCorner + wR;\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${x}; wC += 4) {\n            int xC = xCCorner + wC * ${u};\n\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              getValue(batch, xR, xC + 2 * ${u}, d),\n              getValue(batch, xR, xC + 3 * ${u}, d)\n            );\n\n            ${k}\n          }\n\n          int xC = xCCorner + ${x};\n          if (${1===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              initializationValue,\n              initializationValue,\n              initializationValue\n            );\n\n            ${k}\n          } else if (${2===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              initializationValue,\n              initializationValue\n            );\n\n            ${k}\n          } else if (${3===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              getValue(batch, xR, xC + 2 * ${u}, d),\n              initializationValue\n            );\n\n            ${k}\n          }\n        }\n        setOutput(${b});\n      }\n    `}}class cR{constructor(e,t,n,s=!1,r=!1){if(this.variableNames=["x"],"avg"===t&&n)throw new Error("Cannot compute positions for average pool.");const a=e.filterWidth,i=e.strideDepth,o=e.strideHeight,l=e.strideWidth,u=e.dilationDepth,c=e.dilationHeight,h=e.dilationWidth,p=e.effectiveFilterDepth,d=e.effectiveFilterHeight,f=e.effectiveFilterWidth,m=e.padInfo.front,g=e.padInfo.top,y=e.padInfo.left;this.outputShape=e.outShape;const b="avg"===t;let x="0.0";if(b||(x="-1.0 / 1e-20"),n){const t=">=";return void(this.userCode=`\n        const ivec3 strides =\n            ivec3(${i}, ${o}, ${l});\n        const ivec3 pads = ivec3(${m}, ${g}, ${y});\n\n        void main() {\n          ivec5 coords = getOutputCoords();\n          int batch = coords.x;\n          int ch = coords.u;\n\n          ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n          int xDCorner = xCorner.x;\n          int xRCorner = xCorner.y;\n          int xCCorner = xCorner.z;\n\n          // max/min x(?, ?, ?, ch) to get y(yD, yR, yC, ch).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n\n          for (int wD = 0; wD < ${p};\n              wD += ${u}) {\n            int xD = xDCorner + wD;\n\n            if (xD < 0 || xD >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int wR = 0; wR < ${d};\n                wR += ${c}) {\n              int xR = xRCorner + wR;\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int wC = 0; wC < ${f};\n                  wC += ${h}) {\n                int xC = xCCorner + wC;\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float value = getX(batch, xD, xR, xC, ch);\n\n                // If a min / max value has already been found, use it. If not,\n                // use the current value.\n                float currMinMaxValue = mix(\n                    value, minMaxValue, minMaxValueFound);\n                if (value ${t} currMinMaxValue) {\n                  minMaxValue = value;\n                  minMaxValueFound = 1.0;\n                  minMaxPosition = ${s?r?`(((batch * ${e.inDepth} + xD) * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`((xD * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`wD * ${d} * ${f} +\n                      wR * ${f} + wC`};\n                }\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let w=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===t&&(w="avgValue / count");const k=4*Math.floor(a/4),v=a%4,N=`\n      if (${b}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec3 strides =\n        ivec3(${i}, ${o}, ${l});\n      const ivec3 pads = ivec3(${m}, ${g}, ${y});\n      const float initializationValue = ${x};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xD, int xR, int xC, int ch) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xD, xR, xC, ch);\n      }\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xDCorner = xCorner.x;\n        int xRCorner = xCorner.y;\n        int xCCorner = xCorner.z;\n\n        // max/min x(?, ?, ?, d) to get y(yD, yR, yC, ch).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${x});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wD = 0; wD < ${p};\n            wD += ${u}) {\n          int xD = xDCorner + wD;\n\n          if (xD < 0 || xD >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${d};\n            wR += ${c}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${k}; wC += 4) {\n              int xC = xCCorner + wC * ${h};\n\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${h}, ch),\n                getValue(batch, xD, xR, xC + 3 * ${h}, ch)\n              );\n\n              ${N}\n            }\n\n            int xC = xCCorner + ${k};\n            if (${1===v}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                initializationValue,\n                initializationValue,\n                initializationValue\n              );\n\n              ${N}\n            } else if (${2===v}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                initializationValue,\n                initializationValue\n              );\n\n              ${N}\n            } else if (${3===v}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${h}, ch),\n                initializationValue\n              );\n\n              ${N}\n            }\n          }\n          setOutput(${w});\n        }\n      }\n    `}}const hR={kernelName:pe,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;xT(r,"avgPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:u}=s;l(Pi(i,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`));const c=Ai(r.shape,a,i,1,o,u);if(1===c.filterWidth&&1===c.filterHeight&&d(c.inShape,c.outShape))return ZE({inputs:{x:r},backend:n});const h=new uR(c,"avg",!1);return n.runWebGLProgram(h,[r],"float32")}};const pR={kernelName:fe,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s,c=Ri(r.shape,a,i,[1,1,1],o,l,u),h=new cR(c,"avg",!1);return n.runWebGLProgram(h,[r],"float32")}};class dR{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a=e.dilationHeight,i=e.dilationWidth,o=e.effectiveFilterHeight,l=e.effectiveFilterWidth,u=o-1-e.padInfo.top,c=l-1-e.padInfo.left,h=1/(t*n);this.userCode=`\n      const ivec2 pads = ivec2(${u}, ${c});\n      const float avgMultiplier = float(${h});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${o};\n            wR += ${a}) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${l};\n            wC+= ${i}) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n\n            dotProd += dyValue * avgMultiplier;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class fR{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const t=e.filterDepth,n=e.filterHeight,s=e.filterWidth,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=e.dilationDepth,l=e.dilationHeight,u=e.dilationWidth,c=e.effectiveFilterDepth,h=e.effectiveFilterHeight,p=e.effectiveFilterWidth,d=c-1-e.padInfo.front,f=h-1-e.padInfo.top,m=p-1-e.padInfo.left,g=1/(t*n*s);this.userCode=`\n      const ivec3 pads = ivec3(${d}, ${f}, ${m});\n      const float avgMultiplier = float(${g});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, d) with pos mask(:, :, :, ch) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${c};\n            wD += ${o}) {\n          float dyD = float(dyDCorner + wD) / ${r}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${h};\n              wR += ${l}) {\n            float dyR = float(dyRCorner + wR) / ${a}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${p};\n                wC += ${u}) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n\n              dotProd += dyValue * avgMultiplier;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const mR={kernelName:me,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a,{filterSize:o,strides:l,pad:u,dimRoundingMode:c}=s,h=Ri(i.shape,o,l,[1,1,1],u,c),p=new fR(h);return n.runWebGLProgram(p,[r],i.dtype)}};const gR={kernelName:de,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a;xT([r,a],"avgPoolGrad");const{filterSize:o,strides:l,pad:u}=s,c=Ai(i.shape,o,l,1,u),h=new dR(c);return n.runWebGLProgram(h,[r],i.dtype)}};const yR={kernelName:ge,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a}=t,{transposeA:i,transposeB:o}=s;return AA({a:r,b:a,transposeA:i,transposeB:o,backend:n})}};class bR{constructor(e,t,n,s,r,a){this.outputShape=[],this.variableNames=["x","mean","variance"],So(e,t),So(e,n);let i="0.0";null!=s&&(So(e,s),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let o="1.0";null!=r&&(So(e,r),this.variableNames.push("scale"),o="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        float x = getXAtOutCoords();\n        float mean = getMeanAtOutCoords();\n        float variance = getVarianceAtOutCoords();\n        float offset = ${i};\n        float scale = ${o};\n        float inv = scale * inversesqrt(variance + float(${a}));\n        setOutput(dot(vec3(x, -mean, offset), vec3(inv, inv, 1)));\n      }\n    `}}class xR{constructor(e,t,n,s,r,a){this.packedInputs=!0,this.packedOutput=!0,this.variableNames=["x","mean","variance"],So(e,t),So(e,n);let i="vec4(0.0)";null!=s&&(So(e,s),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let o="vec4(1.0)";null!=r&&(So(e,r),this.variableNames.push("scale"),o="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        vec4 offset = ${i};\n        vec4 scale = ${o};\n\n        vec4 x = getXAtOutCoords();\n        vec4 mean = getMeanAtOutCoords();\n        vec4 variance = getVarianceAtOutCoords();\n\n        vec4 inv = scale * inversesqrt(variance + vec4(${a}));\n\n        setOutput((x - mean) * inv + offset);\n      }\n    `}}const wR={kernelName:at,backendName:"webgl",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,mean:r,variance:a,offset:i,scale:o}=e;l(r.shape.length===a.shape.length,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),l(null==i||r.shape.length===i.shape.length,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),l(null==o||r.shape.length===o.shape.length,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));let{varianceEpsilon:u}=n;null==u&&(u=.001);const c=[s,r,a];let h=null;null!=i&&(h=i.shape,c.push(i));let p=null;null!=o&&(p=o.shape,c.push(o));const d=K().getBool("WEBGL_PACK_NORMALIZATION")?new xR(s.shape,r.shape,a.shape,h,p,u):new bR(s.shape,r.shape,a.shape,h,p,u);return t.runWebGLProgram(d,c,c[0].dtype)}};class kR{constructor(e){this.variableNames=["source"],this.outputShape=e,this.rank=e.length;const t=QT(this.rank),n=`uniform int start[${this.rank}];`,s=function(e){if(1===e)return"sourceLoc";if(e<=6)return vR.slice(0,e).map((e=>"sourceLoc."+e)).join(",");throw Error(`Slicing for rank ${e} is not yet supported`)}(this.rank);let r;r=`\n        ${t} sourceLoc;\n        ${t} coords = getOutputCoords();\n        ${e.map(((e,t)=>`sourceLoc.${vR[t]} = start[${t}] + coords.${vR[t]};`)).join("\n")}\n      `,this.userCode=`\n      ${n}\n      void main() {\n        ${r}\n        setOutput(getSource(${s}));\n      }\n    `}getCustomSetupFunc(e){if(e.length!==this.rank)throw Error(`The rank (${this.rank}) of the program must match the length of start (${e.length})`);return(t,n)=>{null==this.startLoc&&(this.startLoc=t.getUniformLocationNoThrow(n,"start"),null==this.startLoc)||t.gl.uniform1iv(this.startLoc,e)}}}const vR=["x","y","z","w","u","v"];class NR{constructor(e){this.variableNames=["source"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.rank=e.length;const t=QT(this.rank),n=OE("coords",this.rank),s=OE("sourceLoc",this.rank),r=1===this.rank?"sourceLoc":`vec2(${s.slice(-2).join()})`,a=`getChannel(getSource(${s.join()}), ${r})`,i=`\n      result.x = ${a};\n      if (++${n[this.rank-1]} < ${e[this.rank-1]}) {\n        ++${s[this.rank-1]};\n        result.y = ${a};\n        --${s[this.rank-1]};\n      }\n    `,o=1===this.rank?"":`\n      --${n[this.rank-1]};\n      if (++${n[this.rank-2]} < ${e[this.rank-2]}) {\n        ++${s[this.rank-2]};\n        result.z = ${a};\n        if (++${n[this.rank-1]} < ${e[this.rank-1]}) {\n          ++${s[this.rank-1]};\n          result.w = ${a};\n        }\n      }\n    `,l=this.rank<=4?`sourceLoc = coords +\n            ${t}(${e.map(((e,t)=>`start[${t}]`)).join()});`:e.map(((e,t)=>`${s[t]} = ${n[t]} + start[${t}];`)).join("\n");this.userCode=`\n      uniform int start[${this.rank}];\n      void main() {\n        ${t} coords = getOutputCoords();\n        ${t} sourceLoc;\n        ${l}\n        vec4 result = vec4(0.);\n        ${i}\n        ${o}\n        setOutput(result);\n      }\n    `}getCustomSetupFunc(e){if(e.length!==this.rank)throw Error(`The rank (${this.rank}) of the program must match the length of start (${e.length})`);return(t,n)=>{null==this.startLoc&&(this.startLoc=t.getUniformLocationNoThrow(n,"start"),null==this.startLoc)||t.gl.uniform1iv(this.startLoc,e)}}}function IR(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,size:i}=s,[o,l]=Ga(r,a,i);if(Aa(r,o,l),0===p(l))return n.makeTensorInfo(l,r.dtype,[]);if(n.shouldExecuteOnCPU([r])||"string"===r.dtype){const e=n.texData.get(r.dataId),t=$E(e.values,o,l,r.shape,r.dtype);return n.makeTensorInfo(l,r.dtype,t)}const{isPacked:u}=n.texData.get(r.dataId),c=Va(r.shape,o,l);if(u||!c){const e=K().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new NR(l):new kR(l),t=e.getCustomSetupFunc(o);return n.runWebGLProgram(e,[r],r.dtype,t)}return n.uploadToGPU(r.dataId),function(e,t,n,s){const r=s.texData.get(e.dataId),a=s.makeTensorInfo(n,e.dtype),i=s.texData.get(a.dataId);Object.assign(i,r),i.refCount=1,i.shape=n,i.dtype=e.dtype;let o=Ua(t,O(e.shape));r.slice&&(o+=r.slice.flatOffset),i.slice={flatOffset:o,origDataId:r.slice&&r.slice.origDataId||e.dataId};const l=s.dataRefCount.get(i.slice.origDataId)||1;return s.dataRefCount.set(i.slice.origDataId,l+1),a}(r,o,l,n)}const $R={kernelName:yn,backendName:"webgl",kernelFunc:IR},CR={kernelName:ye,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,crops:i}=s;l(r.shape.length<=4,(()=>"batchToSpaceND for rank > 4 with a WebGL backend not implemented yet"));const o=a.reduce(((e,t)=>e*t)),u=Wh(r.shape,a,o),c=Vh(u.length,a.length),h=Uh(r.shape,a,o),p=Gh(i,a.length),d=Hh(h,i,a.length),f=[],m=bA({inputs:{x:r},backend:n,attrs:{shape:u}}),g=TA({inputs:{x:m},backend:n,attrs:{perm:c}}),y=bA({inputs:{x:g},backend:n,attrs:{shape:h}}),b=IR({inputs:{x:y},backend:n,attrs:{begin:p,size:d}});return f.push(m),f.push(g),f.push(y),f.forEach((e=>n.disposeIntermediateTensorInfo(e))),b}};const SR={kernelName:be,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i}=s,o=n.readSync(r.dataId),l=n.readSync(a.dataId),u=rE(o,l,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,u)}},TR=uA({opSnippet:"return float(a != b);",dtype:"bool"}),ER={kernelName:Ut,backendName:"webgl",kernelFunc:TR};function AR(e){const{inputs:t,backend:n}=e,{input:s}=t;return ZE({inputs:{x:n.texData.get(s.dataId).complexTensorInfos.real},backend:n})}const RR={kernelName:tn,backendName:"webgl",kernelFunc:AR};const FR={kernelName:we,backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s,attrs:r}=t,{x:a}=n,{dtype:i}=r;if("complex64"===i){if("complex64"===a.dtype)return ZE({inputs:{x:a},backend:s});const t=Rl(a.shape),n=e({inputs:{x:a},backend:s,attrs:{dtype:"float32"}}),r=eA({inputs:{real:n,imag:t},backend:s});return t.dispose(),s.disposeIntermediateTensorInfo(n),r}if("complex64"===a.dtype){const t=AR({inputs:{input:a},backend:s}),n=e({inputs:{x:t},backend:s,attrs:{dtype:i}});return s.disposeIntermediateTensorInfo(t),n}if(!$(a.dtype,i)){const e=ZE({inputs:{x:a},backend:s});return{dataId:e.dataId,shape:e.shape,dtype:i}}if("int32"===i)return function(e,t){const n=new VE(e.shape,"return float(int(x));"),s=t.runWebGLProgram(n,[e],"int32");return{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}(a,s);if("bool"===i){const e=s.makeTensorInfo([],"bool",k("bool",1)),t=TR({inputs:{a:a,b:e},backend:s});return s.disposeIntermediateTensorInfo(e),t}throw new Error(`Error in Cast: failed to cast ${a.dtype} to ${i}`)}},DR="return ceil(x);",_R=lA({opSnippet:DR,packedOpSnippet:DR,cpuKernelImpl:iE}),OR={kernelName:ke,backendName:"webgl",kernelFunc:_R};class MR{constructor(e){this.variableNames=["A"],this.outputShape=e,this.userCode="\n      uniform float minVal;\n      uniform float maxVal;\n\n      void main() {\n        float value = getAAtOutCoords();\n        if (isnan(value)) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, minVal, maxVal));\n      }\n    "}getCustomSetupFunc(e,t){return(n,s)=>{null==this.minLoc&&(this.minLoc=n.getUniformLocationNoThrow(s,"minVal"),this.maxLoc=n.getUniformLocationNoThrow(s,"maxVal")),n.gl.uniform1f(this.minLoc,e),n.gl.uniform1f(this.maxLoc,t)}}}class LR{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.userCode="\n      uniform float minVal;\n      uniform float maxVal;\n\n      void main() {\n        vec4 value = getAAtOutCoords();\n\n        if (any(isnan(value))) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, vec4(minVal), vec4(maxVal)));\n      }\n    "}getCustomSetupFunc(e,t){return(n,s)=>{null==this.minLoc&&(this.minLoc=n.getUniformLocationNoThrow(s,"minVal"),this.maxLoc=n.getUniformLocationNoThrow(s,"maxVal")),n.gl.uniform1f(this.minLoc,e),n.gl.uniform1f(this.maxLoc,t)}}}const zR={kernelName:ve,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{clipValueMin:a,clipValueMax:i}=s;let o;o=K().getBool("WEBGL_PACK_CLIP")?new LR(r.shape):new MR(r.shape);const l=o.getCustomSetupFunc(a,i);return n.runWebGLProgram(o,[r],r.dtype,l)}};class BR{constructor(e){this.variableNames=["real","imag"],this.outputShape=e,this.userCode="\n      void main() {\n        float re = abs(getRealAtOutCoords());\n        float im = abs(getImagAtOutCoords());\n        float mx = max(re, im);\n\n        // sadly the length function in glsl is not underflow-safe\n        // (at least not on Intel GPUs). So the safe solution is\n        // to ensure underflow-safety in all cases.\n        setOutput(\n          mx == 0.0 ? 0.0 : mx * length(vec2(1, min(re, im)/mx))\n        );\n      }\n    "}}function PR(e,t){return{dataId:t.dataId,dtype:t.dtype,shape:e.shape}}const WR={kernelName:Ie,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=n.texData.get(s.dataId),a=new BR(s.shape),i=[PR(s,r.complexTensorInfos.real),PR(s,r.complexTensorInfos.imag)];return n.runWebGLProgram(a,i,i[0].dtype)}};class VR{constructor(e){this.outputShape=[],this.outputShape=zh(e,1),this.variableNames=e.map(((e,t)=>`T${t}`));const t=new Array(e.length-1);t[0]=e[0][1];for(let n=1;n<t.length;n++)t[n]=t[n-1]+e[n][1];const n=[`if (yC < ${t[0]}) setOutput(getT0(yR, yC));`];for(let e=1;e<t.length;e++){const s=t[e-1];n.push(`else if (yC < ${t[e]}) setOutput(getT${e}(yR, yC-${s}));`)}const s=t.length,r=t[t.length-1];n.push(`else setOutput(getT${s}(yR, yC-${r}));`),this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int yR = coords.x;\n        int yC = coords.y;\n\n        ${n.join("\n        ")}\n      }\n    `}}class UR{constructor(e,t){this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[],this.outputShape=zh(e,t);const n=this.outputShape,s=n.length,r=QT(s),a=OE("coords",s),i=["x","y","z","w","u","v"].slice(0,s);this.variableNames=e.map(((e,t)=>`T${t}`));const o=new Array(e.length-1);o[0]=e[0][t];for(let n=1;n<o.length;n++)o[n]=o[n-1]+e[n][t];const l=i[t],u=i.slice(-2),c=i.join();let h=`if (${l} < ${o[0]}) {\n        return getChannel(\n            getT0(${c}), vec2(${u.join()}));\n        }`;for(let e=1;e<o.length;e++){const t=o[e-1];h+=`\n        if (${l} < ${o[e]}  && ${l} >= ${o[e-1]}) {\n          return getChannel(\n            getT${e}(${GR(i,l,t)}),\n            vec2(${GR(u,l,t)}));\n        }`}const p=o.length,d=o[o.length-1];h+=`\n        return getChannel(\n          getT${p}(${GR(i,l,d)}),\n          vec2(${GR(u,l,d)}));`,this.userCode=`\n      float getValue(${i.map((e=>"int "+e))}) {\n        ${h}\n      }\n\n      void main() {\n        ${r} coords = getOutputCoords();\n        vec4 result = vec4(getValue(${a}), 0., 0., 0.);\n\n        ${a[s-1]} = ${a[s-1]} + 1;\n        if (${a[s-1]} < ${n[s-1]}) {\n          result.g = getValue(${a});\n        }\n\n        ${a[s-2]} = ${a[s-2]} + 1;\n        if (${a[s-2]} < ${n[s-2]}) {\n          result.a = getValue(${a});\n        }\n\n        ${a[s-1]} = ${a[s-1]} - 1;\n        if (${a[s-2]} < ${n[s-2]} &&\n            ${a[s-1]} < ${n[s-1]}) {\n          result.b = getValue(${a});\n        }\n        setOutput(result);\n      }\n    `}}function GR(e,t,n){const s=e.indexOf(t);return e.map(((e,t)=>t===s?`${e} - ${n}`:e)).join()}function HR(e){const{inputs:t,backend:n}=e,{input:s}=t;return ZE({inputs:{x:n.texData.get(s.dataId).complexTensorInfos.imag},backend:n})}const jR={kernelName:pt,backendName:"webgl",kernelFunc:HR};function qR(e,t,n){const s=e[0].dtype;if("complex64"===s){const s=e.map((e=>AR({inputs:{input:e},backend:n}))),r=e.map((e=>HR({inputs:{input:e},backend:n}))),a=qR(s,t,n),i=qR(r,t,n),o=eA({inputs:{real:a,imag:i},backend:n});return s.forEach((e=>n.disposeIntermediateTensorInfo(e))),r.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.disposeIntermediateTensorInfo(a),n.disposeIntermediateTensorInfo(i),o}let r=n.shouldExecuteOnCPU(e);if("string"===s&&(r=!0),r){const r=e.map((e=>{const s=p(e.shape.slice(t));return bA({inputs:{x:e},backend:n,attrs:{shape:[-1,s]}})})),a=r.map((e=>({vals:n.readSync(e.dataId),shape:e.shape}))),i=zh(r.map((e=>e.shape)),1),o=1===r[0].shape[0],l=oE(a,i,s,o),u=zh(e.map((e=>e.shape)),t),c=n.makeTensorInfo(u,s,l);return r.forEach((e=>n.disposeIntermediateTensorInfo(e))),c}if(e.length>K().getNumber("WEBGL_MAX_TEXTURES_IN_SHADER")){const s=Math.floor(e.length/2),r=qR(e.slice(0,s),t,n),a=qR(e.slice(s),t,n),i=qR([r,a],t,n);return n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(a),i}if(K().getBool("WEBGL_PACK_ARRAY_OPERATIONS")&&e[0].shape.length>1){const r=new UR(e.map((e=>e.shape)),t);return n.runWebGLProgram(r,e,s)}const{tensors2D:a,outShape:i}=function(e,t,n){const s=zh(e.map((e=>e.shape)),t);return{tensors2D:e.map((e=>bA({inputs:{x:e},attrs:{shape:[-1,p(e.shape.slice(t))]},backend:n}))),outShape:s}}(e,t,n),o=new VR(a.map((e=>e.shape))),l=n.runWebGLProgram(o,a,s);a.forEach((e=>n.disposeIntermediateTensorInfo(e)));const u=bA({inputs:{x:l},attrs:{shape:i},backend:n});return n.disposeIntermediateTensorInfo(l),u}function KR(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s,a=x(r,t[0].shape)[0],i=zh(t.map((e=>e.shape)),a);if(0===p(i))return n.makeTensorInfo(i,t[0].dtype,[]);const o=t.filter((e=>p(e.shape)>0));if(1===o.length)return ZE({inputs:{x:o[0]},backend:n});return Lh(o.map((e=>e.shape)),a),qR(o,a,n)}const XR={kernelName:$e,backendName:"webgl",kernelFunc:KR};class YR{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const a=e.padInfo.top,i=e.padInfo.left,o=e.strideHeight,l=e.strideWidth,u=e.dilationHeight,c=e.dilationWidth,h=e.filterHeight,p=e.filterWidth,d=4*Math.floor(e.inChannels/4),f=e.inChannels%4,m="channelsLast"===e.dataFormat,g=m?1:2,y=m?2:3,b=m?3:1;let x="",w="";n&&(x=s?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,w="result = activation(result);");const k=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${x}\n\n      const ivec2 strides = ivec2(${o}, ${l});\n      const ivec2 pads = ivec2(${a}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d2 = coords[${b}];\n\n        ivec2 xRCCorner =\n            ivec2(coords[${g}], coords[${y}]) * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, d2) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${h}; wR++) {\n          int xR = xRCorner + wR * ${u};\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${p}; wC++) {\n            int xC = xCCorner + wC * ${c};\n\n            if (xC < 0 || xC >= ${e.inWidth}) {\n              continue;\n            }\n\n            for (int d1 = 0; d1 < ${d}; d1 += 4) {\n              vec4 wValues = vec4(\n                getW(wR, wC, d1, d2),\n                getW(wR, wC, d1 + 1, d2),\n                getW(wR, wC, d1 + 2, d2),\n                getW(wR, wC, d1 + 3, d2)\n              );\n\n              if (${m}) {\n                vec4 xValues = vec4(\n                  getX(batch, xR, xC, d1),\n                  getX(batch, xR, xC, d1 + 1),\n                  getX(batch, xR, xC, d1 + 2),\n                  getX(batch, xR, xC, d1 + 3)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec4 xValues = vec4(\n                  getX(batch, d1, xR, xC),\n                  getX(batch, d1 + 1, xR, xC),\n                  getX(batch, d1 + 2, xR, xC),\n                  getX(batch, d1 + 3, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n\n            if (${1===f}) {\n\n              if (${m}) {\n                dotProd +=\n                    getX(batch, xR, xC, ${d}) *\n                    getW(wR, wC, ${d}, d2);\n              } else {\n                dotProd +=\n                    getX(batch, ${d}, xR, xC) *\n                    getW(wR, wC, ${d}, d2);\n              }\n\n            } else if (${2===f}) {\n              vec2 wValues = vec2(\n                getW(wR, wC, ${d}, d2),\n                getW(wR, wC, ${d} + 1, d2)\n              );\n\n              if (${m}) {\n                vec2 xValues = vec2(\n                  getX(batch, xR, xC, ${d}),\n                  getX(batch, xR, xC, ${d} + 1)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec2 xValues = vec2(\n                  getX(batch, ${d}, xR, xC),\n                  getX(batch, ${d} + 1, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            } else if (${3===f}) {\n              vec3 wValues = vec3(\n                getW(wR, wC, ${d}, d2),\n                getW(wR, wC, ${d} + 1, d2),\n                getW(wR, wC, ${d} + 2, d2)\n              );\n\n              if (${m}) {\n                vec3 xValues = vec3(\n                  getX(batch, xR, xC, ${d}),\n                  getX(batch, xR, xC, ${d} + 1),\n                  getX(batch, xR, xC, ${d} + 2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec3 xValues = vec3(\n                  getX(batch, ${d}, xR, xC),\n                  getX(batch, ${d} + 1, xR, xC),\n                  getX(batch, ${d} + 2, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            }\n          }\n        }\n\n        float result = dotProd;\n        ${k}\n        ${w}\n        setOutput(result);\n      }\n    `}}class JR{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const t=e.padInfo.front,n=e.padInfo.top,s=e.padInfo.left,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=e.dilationDepth,l=e.dilationHeight,u=e.dilationWidth,c=e.filterDepth,h=e.filterHeight,p=e.filterWidth,d=4*Math.floor(e.inChannels/4),f=e.inChannels%4;this.userCode=`\n      const ivec3 strides = ivec3(${r}, ${a}, ${i});\n      const ivec3 pads = ivec3(${t}, ${n}, ${s});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d2 = coords.u;\n\n        ivec3 xFRCCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xFCorner = xFRCCorner.x;\n        int xRCorner = xFRCCorner.y;\n        int xCCorner = xFRCCorner.z;\n\n        // Convolve x(?, ?, ?, d1) with w(:, :, :, d1, d2) to get\n        // y(yF, yR, yC, d2). ? = to be determined. : = across all\n        // values in that axis.\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${c}; wF++) {\n          int xF = xFCorner + wF * ${o};\n\n          if (xF < 0 || xF >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${h}; wR++) {\n            int xR = xRCorner + wR * ${l};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${p}; wC++) {\n              int xC = xCCorner + wC * ${u};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              for (int d1 = 0; d1 < ${d}; d1 += 4) {\n                vec4 xValues = vec4(\n                  getX(batch, xF, xR, xC, d1),\n                  getX(batch, xF, xR, xC, d1 + 1),\n                  getX(batch, xF, xR, xC, d1 + 2),\n                  getX(batch, xF, xR, xC, d1 + 3)\n                );\n                vec4 wValues = vec4(\n                  getW(wF, wR, wC, d1, d2),\n                  getW(wF, wR, wC, d1 + 1, d2),\n                  getW(wF, wR, wC, d1 + 2, d2),\n                  getW(wF, wR, wC, d1 + 3, d2)\n                );\n\n                dotProd += dot(xValues, wValues);\n              }\n\n              if (${1===f}) {\n                dotProd +=\n                  getX(batch, xF, xR, xC, ${d}) *\n                  getW(wF, wR, wC, ${d}, d2);\n              } else if (${2===f}) {\n                vec2 xValues = vec2(\n                  getX(batch, xF, xR, xC, ${d}),\n                  getX(batch, xF, xR, xC, ${d} + 1)\n                );\n                vec2 wValues = vec2(\n                  getW(wF, wR, wC, ${d}, d2),\n                  getW(wF, wR, wC, ${d} + 1, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else if (${3===f}) {\n                vec3 xValues = vec3(\n                  getX(batch, xF, xR, xC, ${d}),\n                  getX(batch, xF, xR, xC, ${d} + 1),\n                  getX(batch, xF, xR, xC, ${d} + 2)\n                );\n                vec3 wValues = vec3(\n                  getW(wF, wR, wC, ${d}, d2),\n                  getW(wF, wR, wC, ${d} + 1, d2),\n                  getW(wF, wR, wC, ${d} + 2, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class ZR{constructor(e,t,n){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e;const{filterWidth:s,inChannels:r,strideWidth:a,strideHeight:i,padInfo:o,outWidth:l,dilationWidth:u,dilationHeight:c,dataFormat:h}=n,{left:p,top:d}=o,f=r*s,m=kT(),g="channelsLast"===h,y=g?0:1,b=g?1:2;let x="";for(let n=0;n<=1;n++)for(let s=0;s<=1;s++)x+=`\n          blockIndex = rc.y + ${s};\n          pos = rc.x + ${n};\n\n          if(blockIndex < ${e[1]} && pos < ${e[0]}) {\n            offsetY = int(blockIndex / (${l})) * ${i} - ${d};\n            d0 = offsetY + ${c} * (pos / ${f});\n\n            if(d0 < ${t[y]} && d0 >= 0) {\n\n              offsetX = int(mod(float(blockIndex), ${l}.) * ${a}. - ${p}.);\n              d1 = offsetX + ${u} * (int(mod(float(pos), ${f}.) / ${r}.));\n\n              if(d1 < ${t[b]} && d1 >= 0) {\n\n                ch = int(mod(float(pos), ${r}.));\n\n                if (${g}) {\n                  innerDims = vec2(d1, ch);\n                  result[${2*n+s}] = getChannel(\n                    getA(d0, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                } else {\n                  innerDims = vec2(d0, d1);\n                  result[${2*n+s}] = getChannel(\n                    getA(ch, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                }\n              }\n            }\n          }\n        `;this.userCode=`\n      void main() {\n        ivec2 rc = getOutputCoords();\n\n        vec4 result = vec4(0);\n\n        int blockIndex, pos, offsetY, d0, offsetX, d1, ch;\n        vec2 innerDims;\n\n        ${x}\n\n        ${m.output} = result;\n      }\n    `}}function QR({x:e,filter:t,convInfo:n,backend:s,bias:r=null,preluActivationWeights:a=null,leakyreluAlpha:i=0,activation:o=null}){const u=e.shape,c=s.texData.get(e.dataId),h=n.inChannels,p=u[0]*u[1]*u[2],d=n.outChannels,f="channelsLast"===n.dataFormat;let m;const g=[],y=(1===p||1===d)&&h>1e3,b=u[2]%2!=0&&!!c.isPacked;if(!y&&K().getBool("WEBGL_LAZILY_UNPACK")&&K().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&b){const h=f?u[0]*u[1]*(u[2]+1):u[0]*u[2]*(u[3]+1),p={dataId:e.dataId,shape:[1,h,n.inChannels],dtype:e.dtype},d=c.shape;c.shape=c.shape.slice(),c.shape[c.shape.length-2]++,l(pT(c.shape,p.shape),(()=>`packed reshape ${c.shape} to ${p.shape} isn't free`));const y=bA({inputs:{x:t},backend:s,attrs:{shape:[1,n.inChannels,n.outChannels]}});g.push(y);const b=AA({a:p,b:y,backend:s,transposeA:false,transposeB:false,bias:r,activation:o,preluActivationWeights:a,leakyreluAlpha:i}),x=s.texData.get(b.dataId);l(x.isPacked,(()=>"batchMatMul result is expected to be packed")),c.shape=d,x.shape=n.outShape,m=ZE({inputs:{x:b},backend:s}),m.shape=n.outShape,g.push(b)}else{const l=bA({inputs:{x:e},backend:s,attrs:{shape:[1,f?u[0]*u[1]*u[2]:u[0]*u[2]*u[3],n.inChannels]}}),c=bA({inputs:{x:t},backend:s,attrs:{shape:[1,n.inChannels,n.outChannels]}}),h=AA({a:l,b:c,transposeA:false,transposeB:false,backend:s,bias:r,activation:o,preluActivationWeights:a,leakyreluAlpha:i});m=bA({inputs:{x:h},backend:s,attrs:{shape:n.outShape}}),g.push(l),g.push(c),g.push(h)}for(const e of g)s.disposeIntermediateTensorInfo(e);return m}function eF({x:e,filter:t,convInfo:n,backend:s,bias:r=null,preluActivationWeights:a=null,leakyreluAlpha:i=0,activation:o=null}){const{filterWidth:l,filterHeight:u,inChannels:c,outWidth:h,outHeight:d,dataFormat:f}=n,m="channelsLast"===f,g=l*u*c,y=d*h,b=[g,y],x=[],w=bA({inputs:{x:e},backend:s,attrs:{shape:e.shape.slice(1)}}),k=bA({inputs:{x:t},backend:s,attrs:{shape:[1,g,p(t.shape)/g]}});x.push(w),x.push(k);const v=new ZR(b,w.shape,n),N=s.runWebGLProgram(v,[w],"float32"),I=bA({inputs:{x:N},backend:s,attrs:{shape:[1,b[0],b[1]]}});x.push(N),x.push(I);const $=null!=r,C=null!=a,S="leakyrelu"===o,T=o?cA(o,!0):null,E=new hA(I.shape,k.shape,[1,y,n.outChannels],!0,!1,$,T,C,S),A=[I,k];if(r&&A.push(r),C&&A.push(a),S){const e=s.makeTensorInfo([],"float32",as(i,"float32"));A.push(e),x.push(e)}const R=s.runWebGLProgram(E,A,"float32"),F=bA({inputs:{x:R},backend:s,attrs:{shape:m?[1,d,h,n.outChannels]:[1,n.outChannels,d,h]}});x.push(R);for(const e of x)s.disposeIntermediateTensorInfo(e);return F}const tF={kernelName:Ce,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dataFormat:l,dilations:u,dimRoundingMode:c}=s,h=Wi(l),p=Fi(r.shape,a.shape,i,u,o,c,!1,h);let d;if(1!==p.filterHeight||1!==p.filterWidth||1!==p.dilationHeight||1!==p.dilationWidth||1!==p.strideHeight||1!==p.strideWidth||"SAME"!==p.padInfo.type&&"VALID"!==p.padInfo.type)if(K().getBool("WEBGL_CONV_IM2COL")&&1===r.shape[0])d=eF({x:r,filter:a,convInfo:p,backend:n});else{const e=new YR(p);d=n.runWebGLProgram(e,[r,a],"float32")}else d=QR({x:r,filter:a,convInfo:p,backend:n});const f=bA({inputs:{x:d},backend:n,attrs:{shape:p.outShape}});return n.disposeIntermediateTensorInfo(d),f}};class nF{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideHeight,n=e.strideWidth,s=e.padInfo.top,r=e.padInfo.left,a="channelsLast"===e.dataFormat;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int d2 = coords.w;\n\n        // Convolve x(?, ?, d1) with dy(:, :, d2) to get dw(wR, wC, d1, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${t} - ${s};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${r};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              if (${a}) {\n                float dyValue = getDy(b, yR, yC, d2);\n                float xValue = getX(b, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              } else {\n                float dyValue = getDy(b, d2, yR, yC);\n                float xValue = getX(b, d1, xR, xC);\n                dotProd += (xValue * dyValue);\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class sF{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a="channelsLast"===e.dataFormat,i=t-1-e.padInfo.top,o=n-1-e.padInfo.left,l=a?1:2,u=a?2:3,c=a?3:1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${o});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[${c}];\n\n        ivec2 dyCorner = ivec2(coords[${l}], coords[${u}]) - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n\n              if (${a}) {\n                float xValue = getDy(batch, idyR, idyC, d2);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              } else {\n                float xValue = getDy(batch, d2, idyR, idyC);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class rF{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideDepth,n=e.strideHeight,s=e.strideWidth,r=e.padInfo.front,a=e.padInfo.top,i=e.padInfo.left;this.userCode=`\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int wF = coords.x;\n        int wR = coords.y;\n        int wC = coords.z;\n        int d1 = coords.w;\n        int d2 = coords.u;\n\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yF = 0; yF < ${e.outDepth}; yF++) {\n            int xF = wF + yF * ${t} - ${r};\n\n            if (xF < 0 || xF >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int yR = 0; yR < ${e.outHeight}; yR++) {\n              int xR = wR + yR * ${n} - ${a};\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int yC = 0; yC < ${e.outWidth}; yC++) {\n                int xC = wC + yC * ${s} - ${i};\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float dyValue = getDy(b, yF, yR, yC, d2);\n                float xValue = getX(b, xF, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class aF{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterDepth,n=e.filterHeight,s=e.filterWidth,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=t-1-e.padInfo.front,l=n-1-e.padInfo.top,u=s-1-e.padInfo.left;this.userCode=`\n      const ivec3 pads = ivec3(${o}, ${l}, ${u});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.u;\n\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyFCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${t}; wF++) {\n          float dyF = float(dyFCorner + wF) / ${r}.0;\n\n          if (dyF < 0.0 || dyF >= ${e.outDepth}.0 || fract(dyF) > 0.0) {\n            continue;\n          }\n          int idyF = int(dyF);\n\n          int wFPerm = ${t} - 1 - wF;\n\n          for (int wR = 0; wR < ${n}; wR++) {\n            float dyR = float(dyRCorner + wR) / ${a}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n              fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            int wRPerm = ${n} - 1 - wR;\n\n            for (int wC = 0; wC < ${s}; wC++) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              int wCPerm = ${s} - 1 - wC;\n\n              for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n                float xValue = getDy(batch, idyF, idyR, idyC, d2);\n                float wValue = getW(wFPerm, wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const iF={kernelName:Se,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,dataFormat:l,dimRoundingMode:u,filterShape:c}=s,h=Wi(l),p=Fi(r.shape,c,i,1,o,u,!1,h),d=new nF(p);return n.runWebGLProgram(d,[r,a],"float32")}};const oF={kernelName:Te,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{inputShape:i,strides:o,pad:l,dataFormat:u,dimRoundingMode:c}=s,h=Wi(u),p=Fi(i,a.shape,o,1,l,c,!1,h),d=new sF(p);return n.runWebGLProgram(d,[r,a],"float32")}};const lF={kernelName:Ee,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s,u=Di(r.shape,a.shape,i,l,o),c=new JR(u);return n.runWebGLProgram(c,[r,a],"float32")}};const uF={kernelName:Ae,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,filterShape:l}=s,u=Di(r.shape,l,i,1,o),c=new rF(u);return n.runWebGLProgram(c,[r,a],"float32")}};const cF={kernelName:Re,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{pad:i,strides:o,inputShape:l}=s,u=Di(l,a.shape,o,1,i),c=new aF(u);return n.runWebGLProgram(c,[r,a],"float32")}},hF=lA({opSnippet:"if (isnan(x)) return x;\n  return cos(x);\n"}),pF={kernelName:Fe,backendName:"webgl",kernelFunc:hF},dF=lA({opSnippet:"\n  float e2x = exp(-x);\n  return (e2x + 1.0 / e2x) / 2.0;\n"}),fF={kernelName:De,backendName:"webgl",kernelFunc:dF};class mF{constructor(e,t,n,s,r){this.variableNames=["Image","Boxes","BoxInd"],this.outputShape=[];const[a,i,o,l]=e,[u]=t,[c,h]=n;this.outputShape=[u,c,h,l];const p="bilinear"===s?1:0,[d,f]=[i-1+".0",o-1+".0"],[m,g,y]=c>1?[""+(i-1)/(c-1),"(y2-y1) * height_ratio",`y1*${d} + float(y)*(height_scale)`]:["0.0","0.0",`0.5 * (y1+y2) * ${d}`],[b,x,w]=h>1?[""+(o-1)/(h-1),"(x2-x1) * width_ratio",`x1*${f} + float(x)*(width_scale)`]:["0.0","0.0",`0.5 * (x1+x2) * ${f}`];this.userCode=`\n      const float height_ratio = float(${m});\n      const float width_ratio = float(${b});\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int y = coords[1];\n        int x = coords[2];\n        int d = coords[3];\n\n        // get box vals\n        float y1 = getBoxes(b,0);\n        float x1 = getBoxes(b,1);\n        float y2 = getBoxes(b,2);\n        float x2 = getBoxes(b,3);\n\n        // get image in batch index\n        int bInd = round(getBoxInd(b));\n        if(bInd < 0 || bInd >= ${a}) {\n          return;\n        }\n\n        float height_scale = ${g};\n        float width_scale = ${x};\n\n        float in_y = ${y};\n        if( in_y < 0.0 || in_y > ${d} ) {\n          setOutput(float(${r}));\n          return;\n        }\n        float in_x = ${w};\n        if( in_x < 0.0 || in_x > ${f} ) {\n          setOutput(float(${r}));\n          return;\n        }\n\n        vec2 sourceFracIndexCR = vec2(in_x,in_y);\n        if(${p} == 1) {\n          // Compute the four integer indices.\n          ivec2 sourceFloorCR = ivec2(sourceFracIndexCR);\n          ivec2 sourceCeilCR = ivec2(ceil(sourceFracIndexCR));\n\n          float topLeft = getImage(b, sourceFloorCR.y, sourceFloorCR.x, d);\n          float bottomLeft = getImage(b, sourceCeilCR.y, sourceFloorCR.x, d);\n          float topRight = getImage(b, sourceFloorCR.y, sourceCeilCR.x, d);\n          float bottomRight = getImage(b, sourceCeilCR.y, sourceCeilCR.x, d);\n\n          vec2 fracCR = sourceFracIndexCR - vec2(sourceFloorCR);\n\n          float top = topLeft + (topRight - topLeft) * fracCR.x;\n          float bottom = bottomLeft + (bottomRight - bottomLeft) * fracCR.x;\n          float newValue = top + (bottom - top) * fracCR.y;\n          setOutput(newValue);\n        } else {\n          // Compute the coordinators of nearest neighbor point.\n          ivec2 sourceNearestCR = ivec2(floor(\n            sourceFracIndexCR + vec2(0.5,0.5)));\n          float newValue = getImage(b, sourceNearestCR.y, sourceNearestCR.x, d);\n          setOutput(newValue);\n        }\n      }\n    `}}const gF={kernelName:Oe,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{image:r,boxes:a,boxInd:i}=t,{cropSize:o,method:l,extrapolationValue:u}=s,c=new mF(r.shape,a.shape,o,l,u);return n.runWebGLProgram(c,[r,a,i],"float32")}};class yF{constructor(e,t,n){this.variableNames=["x"],this.outputShape=e;const s=e.length,r=t?"0.0":`getX(${bF(s,"coords")})`,a=e[e.length-1];let i="",o="";t?(i=n?"end != "+(a-1):"end != 0",o=n?"end + 1":"end - 1"):(i=n?`end + pow2 < ${a}`:"end >= pow2",o=n?"end + pow2":"end - pow2"),this.userCode=`\n      uniform float index;\n      void main() {\n        ${QT(s)} coords = getOutputCoords();\n        int end = ${xF(s,"coords")};\n        float val = ${r};\n        int pow2 = int(pow(2.0, index));\n        if (${i}) {\n          int idx = ${o};\n          ${xF(s,"coords")} = idx;\n          val += getX(${bF(s,"coords")});\n        }\n        setOutput(val);\n      }\n    `}getCustomSetupFunc(e){return(t,n)=>{null==this.index&&(this.index=t.getUniformLocation(n,"index")),t.gl.uniform1f(this.index,e)}}}function bF(e,t){if(1===e)return`${t}`;if(2===e)return`${t}.x, ${t}.y`;if(3===e)return`${t}.x, ${t}.y, ${t}.z`;if(4===e)return`${t}.x, ${t}.y, ${t}.z, ${t}.w`;throw Error(`Cumulative sum for rank ${e} is not yet supported`)}function xF(e,t){if(1===e)return`${t}`;if(2===e)return`${t}.y`;if(3===e)return`${t}.z`;if(4===e)return`${t}.w`;throw Error(`Cumulative sum for rank ${e} is not yet supported`)}const wF={kernelName:_e,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s,l=r.shape.length,u=bl([a],l);let c=r;null!=u&&(c=TA({inputs:{x:r},backend:n,attrs:{perm:u}}));const h=wl(1,l)[0];if(h!==l-1)throw new Error(`WebGL cumsum shader expects an inner-most axis=${r.shape.length-1} but got axis=${a}`);const p=c.shape[h];let d=ZE({inputs:{x:c},backend:n});for(let e=0;e<=Math.ceil(Math.log2(p))-1;e++){const t=new yF(c.shape,!1,o),s=t.getCustomSetupFunc(e),r=d;d=n.runWebGLProgram(t,[d],d.dtype,s),n.disposeIntermediateTensorInfo(r)}if(i){const e=new yF(c.shape,i,o),t=d;d=n.runWebGLProgram(e,[d],d.dtype),n.disposeIntermediateTensorInfo(t)}if(null!=u){const e=TA({inputs:{x:d},backend:n,attrs:{perm:xl(u)}});return n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(c),e}return d}};const kF={kernelName:Me,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i,binaryOutput:o}=s;if(1===r.shape.length){const e=n.readSync(r.dataId),t=n.readSync(a.dataId),s=rE(e,t,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,s)}if(2===r.shape.length){const e=n.bufferSync(r),t=n.bufferSync(a),s=aE(e,t,i,o);return n.makeTensorInfo(s.shape,a.dtype,s.values)}throw new Error(`Error in denseBincount: input must be at most rank 2, but got rank${r.shape.length}.`)}};class vF{constructor(e,t,n){this.variableNames=["x"],this.outputShape=[],this.outputShape=e,this.blockSize=t,this.dataFormat=n,this.userCode=`\n    void main() {\n      ivec4 coords = getOutputCoords();\n      int b = coords[0];\n      int h = ${this.getHeightCoordString()};\n      int w = ${this.getWidthCoordString()};\n      int d = ${this.getDepthCoordString()};\n\n      int in_h = h / ${t};\n      int offset_h = imod(h, ${t});\n      int in_w = w / ${t};\n      int offset_w = imod(w, ${t});\n      int offset_d = (offset_h * ${t} + offset_w) *\n        ${this.getOutputDepthSize()};\n      int in_d = d + offset_d;\n\n      float result = ${this.getInputSamplingString()};\n      setOutput(result);\n    }\n  `}getHeightCoordString(){return"NHWC"===this.dataFormat?"coords[1]":"coords[2]"}getWidthCoordString(){return"NHWC"===this.dataFormat?"coords[2]":"coords[3]"}getDepthCoordString(){return"NHWC"===this.dataFormat?"coords[3]":"coords[1]"}getOutputDepthSize(){return"NHWC"===this.dataFormat?this.outputShape[3]:this.outputShape[1]}getInputSamplingString(){return"NHWC"===this.dataFormat?"getX(b, in_h, in_w, in_d)":"getX(b, in_d, in_h, in_w)"}}const NF={kernelName:Le,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockSize:a,dataFormat:i}=s;l(a>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${a}`));const o=r.shape[0],u="NHWC"===i?r.shape[1]:r.shape[2],c="NHWC"===i?r.shape[2]:r.shape[3],h="NHWC"===i?r.shape[3]:r.shape[1],p=u*a,d=c*a,f=h/(a*a),m=new vF("NHWC"===i?[o,p,d,f]:[o,f,p,d],a,i);return n.runWebGLProgram(m,[r],r.dtype)}};class IF{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const a=e.inHeight,i=e.inWidth,o=e.padInfo.top,l=e.padInfo.left,u=e.strideHeight,c=e.strideWidth,h=e.dilationHeight,p=e.dilationWidth,d=e.filterHeight,f=e.filterWidth,m=e.outChannels/e.inChannels;let g="",y="";n&&(g=s?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,y="result = activation(result);");const b=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${g}\n\n      const ivec2 strides = ivec2(${u}, ${c});\n      const ivec2 pads = ivec2(${o}, ${l});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${m};\n        int q = d2 - d1 * ${m};\n\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, q) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        // TO DO(dsmilkov): Flatten the two for loops and vec4 the operations.\n        for (int wR = 0; wR < ${d}; wR++) {\n          int xR = xRCorner + wR * ${h};\n\n          if (xR < 0 || xR >= ${a}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${f}; wC++) {\n            int xC = xCCorner + wC * ${p};\n\n            if (xC < 0 || xC >= ${i}) {\n              continue;\n            }\n\n            float xVal = getX(batch, xR, xC, d1);\n            float wVal = getW(wR, wC, d1, q);\n            dotProd += xVal * wVal;\n          }\n        }\n\n        float result = dotProd;\n        ${b}\n        ${y}\n        setOutput(result);\n      }\n    `}}class $F{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e.outShape;const a=e.outChannels/e.inChannels,o=e.inHeight,l=e.inWidth,u=e.padInfo.top,c=e.padInfo.left,h=e.strideHeight,p=e.strideWidth,d=e.dilationHeight,f=e.dilationWidth,m=e.filterHeight,g=e.filterWidth,y=g;let b="\n      int xR; int xC; int xCOffset;\n      vec4 wTexel; vec4 previous; vec4 final;";for(let e=0;e<g;e++)b+=`\n          vec4 xTexelC${2*e};\n          int xTexelC${2*e}Ready;\n          vec4 xC${e};`;for(let e=0;e<m;e++){for(let e=0;e<g;e++)b+=`\n          xTexelC${2*e} = vec4(0.0);\n          xTexelC${2*e}Ready = 0;\n          xC${e} = vec4(0.0);`;b+=`\n        xR = xRCorner + ${e*d};\n        if (xR >=0 && xR < ${o}) {\n      `;for(let t=0;t<(y+1)/2;t++){const n=2*t,s=n*f;if(b+=`\n          xC = xCCorner + ${s};\n          `,1===p){if(n<g&&(c%2==1?(b+=`\n                xCOffset = xC + 1;\n                if (xCOffset >= 0 && xCOffset < ${l} && xTexelC${s}Ready == 0) {\n                  xTexelC${s} = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if (xCOffset + 1 >= ${l}) {\n                    xTexelC${s}.zw = vec2(0.0);\n                  }\n                  xTexelC${s}Ready = 1;\n                }\n              `,b+=1===f&&s>0?`\n                xC${n} = vec4(xTexelC${s-2}.zw, xTexelC${s}.xy);\n                `:`\n                  xCOffset = xC + 1 - 2;\n\n                  if (xCOffset >= 0 && xCOffset < ${l}) {\n                    previous = getX(batch, xR, xCOffset, d1);\n\n                    // Need to manually clear unused channels in case\n                    // we're reading from recycled texture.\n                    if (xCOffset + 1 >= ${l}) {\n                      previous.zw = vec2(0.0);\n                    }\n\n                    xC${n} = vec4(previous.zw, xTexelC${s}.xy);\n                  } else {\n                    xC${n} = vec4(0.0, 0.0, xTexelC${s}.xy);\n                  }\n                  `):b+=`\n                if (xC >= 0 && xC < ${l} && xTexelC${s}Ready == 0) {\n                  xTexelC${s} = getX(batch, xR, xC, d1);\n                  if (xC + 1 >= ${l}) {\n                    xTexelC${s}.zw = vec2(0.0);\n                  }\n                  xTexelC${s}Ready = 1;\n                }\n\n                xC${n} = xTexelC${s};\n                `,s+1<g)){const e=c%2==0?i(f):f;f%2==0&&c%2==1||f%2!=0&&c%2!=1?(b+=`\n                  xCOffset = xC + ${c%2} + ${e};\n\n                  if (xCOffset >= 0 && xCOffset < ${l} && xTexelC${s+2}Ready == 0) {\n                    xTexelC${s+2} = getX(batch, xR, xCOffset, d1);\n\n                    // Need to manually clear unused channels in case\n                    // we're reading from recycled texture.\n                    if (xCOffset + 1 >= ${l}) {\n                      xTexelC${s+2}.zw = vec2(0.0);\n                    }\n                    xTexelC${s+2}Ready = 1;\n                  }\n                  `,f>1&&(b+=`\n                    xCOffset -= 2;\n                    if (xCOffset >= 0 && xCOffset < ${l} && xTexelC${s}Ready == 0) {\n                      xTexelC${s} = getX(batch, xR, xCOffset, d1);\n                      xTexelC${s}Ready = 1;\n                    }\n                    `),b+=`\n                  xC${n+1} = vec4(xTexelC${s}.zw, xTexelC${s+2}.xy);\n                  `):b+=1===e?`\n                    xC${n+1} = xTexelC${s};\n                    `:`\n                    xCOffset = xC + ${e};\n\n                    if (xCOffset >= 0 && xCOffset < ${l} && xTexelC${s+2}Ready == 0) {\n                      xTexelC${s+2} = getX(batch, xR, xCOffset, d1);\n                      if (xCOffset + 1 >= ${l}) {\n                        xTexelC${s+2}.zw = vec2(0.0);\n                      }\n                      xTexelC${s+2}Ready = 1;\n                    }\n\n                    xC${n+1} = xTexelC${s+2};\n                    `}}else s<g&&(c%2==1?(b+=`\n                xCOffset = xC + 1 - ${p};\n                if(xCOffset >= 0 && xCOffset < ${l} && xTexelC${s}Ready == 0) {\n                  xTexelC${s} = getX(batch, xR, xCOffset, d1);\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if (xCOffset + 1 >= ${l}) {\n                    xTexelC${s}.zw = vec2(0.0);\n                  }\n                  xTexelC${s}Ready = 1;\n                }\n\n                if(xC + 1 >= 0 && xC + 1 < ${l} && xTexelC${s+2}Ready == 0) {\n                  xTexelC${s+2} = getX(batch, xR, xC + 1, d1);\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if (xC + 2 >= ${l}) {\n                    xTexelC${s+2}.zw = vec2(0.0);\n                  }\n                  xTexelC${s+2}Ready = 1;\n                }\n\n                xC${n} = vec4(xTexelC${s}.zw, xTexelC${s+2}.zw);\n              `,s+1<g&&(b+=`\n                  final = vec4(0.0);\n                  xCOffset = xC + 1 + ${p};\n                  if(xCOffset >= 0 && xCOffset < ${l}) {\n                    final = getX(batch, xR, xCOffset, d1);\n                  }\n                  xC${n+1} = vec4(xTexelC${s+2}.xy, final.xy);\n                `)):(b+=`\n                if(xC >= 0 && xC < ${l} && xTexelC${s}Ready == 0) {\n                  xTexelC${s} = getX(batch, xR, xC, d1);\n                  if (xC + 1 >= ${l}) {\n                    xTexelC${s}.zw = vec2(0.0);\n                  }\n                  xTexelC${s}Ready = 1;\n                }\n\n                xCOffset = xC + ${p};\n                if(xCOffset >= 0 && xCOffset < ${l} && xTexelC${s+2}Ready == 0) {\n                  xTexelC${s+2} = getX(batch, xR, xCOffset, d1);\n                  if (xCOffset + 1 >= ${l}) {\n                    xTexelC${s+2}.zw = vec2(0.);\n                  }\n                  xTexelC${s+2}Ready = 1;\n                }\n\n                xC${n} = vec4(\n                  xTexelC${s}.xy, xTexelC${s+2}.xy);\n              `,s+1<g&&(b+=`\n                  xC${n+1} = vec4(xTexelC${s}.zw, xTexelC${s+2}.zw);\n                `)));n<g&&(b+=`\n            wTexel = getW(${e}, ${s}, d1, q);\n            dotProd += xC${n} * vec4(wTexel.xz, wTexel.xz);\n          `,s+1<g&&(b+=`\n              wTexel = getW(${e}, ${s+1}, d1, q);\n              dotProd += xC${n+1} * vec4(wTexel.xz, wTexel.xz);\n            `))}b+="\n        }\n      "}let x="",w="";n&&(x=s?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`vec4 activation(vec4 x) {\n          ${n}\n        }`,w="result = activation(result);");const k=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${x}\n\n      const ivec2 strides = ivec2(${h}, ${p});\n      const ivec2 pads = ivec2(${u}, ${c});\n\n      void main() {\n\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${a};\n        int q = d2 - d1 * ${a};\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        //intialize dotProd with a small epsilon seems to reduce GPU accuracy loss.\n        vec4 dotProd = vec4(0.000000000000001);\n\n        ${b}\n\n        vec4 result = dotProd - vec4(0.000000000000001);\n        ${k}\n        ${w}\n        setOutput(result);\n      }\n    `}}const CF={kernelName:ze,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:u,dimRoundingMode:c}=s;let h=u;null==h&&(h=[1,1]),l(Pi(i,h),(()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${i} and dilations '${h}'`));const p=Fi(r.shape,a.shape,i,h,o,c,!0);let d;return d=K().getBool("WEBGL_PACK_DEPTHWISECONV")&&p.strideWidth<=2&&p.outChannels/p.inChannels==1?new $F(p):new IF(p),n.runWebGLProgram(d,[r,a],"float32")}};class SF{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideHeight,n=e.strideWidth,s=e.padInfo.top,r=e.padInfo.left,a=e.outChannels/e.inChannels;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int dm = coords.w;\n        int d2 = d1 * ${a} + dm;\n\n        float dotProd = 0.0;\n\n        // TO DO: Vec4 over the batch size\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${t} - ${s};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${r};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float dyValue = getDy(b, yR, yC, d2);\n              float xValue = getX(b, xR, xC, d1);\n              dotProd += (xValue * dyValue);\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class TF{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a=t-1-e.padInfo.top,i=n-1-e.padInfo.left,o=e.outChannels/e.inChannels;this.userCode=`\n      const ivec2 pads = ivec2(${a}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[3];\n        ivec2 dyCorner = coords.yz - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        float dotProd = 0.0;\n\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            // TO DO: Vec4 over the channelMul\n            for (int dm = 0; dm < ${o}; dm++) {\n              int d2 = d1 * ${o} + dm;\n              float xValue = getDy(batch, idyR, idyC, d2);\n              float wValue = getW(wRPerm, wCPerm, d1, dm);\n              dotProd += xValue * wValue;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const EF={kernelName:Be,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,filterShape:c}=s,h=Fi(r.shape,c,i,o,l,u,!0),p=new SF(h);return n.runWebGLProgram(p,[r,a],"float32")}};const AF={kernelName:Pe,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,inputShape:c}=s,h=Fi(c,a.shape,i,o,l,u,!0),p=new TF(h);return n.runWebGLProgram(p,[r,a],"float32")}};class RF{constructor(e){this.variableNames=["X"],this.outputShape=[e,e],this.userCode="\n      void main() {\n          ivec2 coords = getOutputCoords();\n          float val = coords[0] == coords[1] ? getX(coords[0]) : 0.0;\n          setOutput(val);\n      }\n    "}}const FF={kernelName:We,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=[...s.shape,...s.shape],a=p(s.shape),i=bA({inputs:{x:s},backend:n,attrs:{shape:[a]}}),o=new RF(a),l=n.runWebGLProgram(o,[i],i.dtype),u=bA({inputs:{x:l},backend:n,attrs:{shape:r}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(l),u}};class DF{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const{inHeight:t,inWidth:n,padInfo:s,strideHeight:r,strideWidth:a,filterHeight:i,filterWidth:o,dilationHeight:l,dilationWidth:u}=e,{top:c,left:h}=s;this.userCode=`\n      const ivec2 strides = ivec2(${r}, ${a});\n      const ivec2 pads = ivec2(${c}, ${h});\n      const float neg_infinity = -3.4e38;\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.w;\n        ivec2 outTopLeftCorner =\n            coords.yz * strides - pads;\n        int hBeg = outTopLeftCorner.x;\n        int wBeg = outTopLeftCorner.y;\n\n        float curVal = neg_infinity;\n        for (int h = 0; h < ${i}; h++) {\n          int hIn = hBeg + h * ${l};\n\n          if (hIn >= 0 && hIn < ${t}) {\n            for (int w = 0; w < ${o}; w++) {\n              int wIn = wBeg + w * ${u};\n\n              if (wIn >= 0 && wIn < ${n}) {\n                float xVal = getX(batch, hIn, wIn, d1);\n                float wVal = getW(h, w, d1);\n\n                float val = xVal + wVal;\n                if (val > curVal) {\n                  curVal = val;\n                }\n              }\n            }\n          }\n        }\n\n        float result = curVal;\n        setOutput(result);\n      }\n    `}}const _F={kernelName:Ve,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s,u=Ei(r.shape,a.shape,i,o,"NHWC",l);let c;const h=new DF(u);c=n.runWebGLProgram(h,[r,a],"float32");const p=bA({inputs:{x:c},backend:n,attrs:{shape:u.outShape}});return n.disposeIntermediateTensorInfo(c),p}};const OF={kernelName:je,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{equation:r}=s,a=t,{allDims:i,summedDims:o,idDims:l}=hp(r,a.length);dp(i.length,l,a);const{path:u,steps:c}=fp(o,l),h=c.length;let p=null,f=i.length;const m=[];for(let e=0;e<h;++e){for(const t of c[e]){const{permutationIndices:e,expandDims:s}=pp(f,l[t]);let r;mp(e)?r=a[t]:(r=TA({inputs:{x:a[t]},backend:n,attrs:{perm:e}}),m.push(r));const i=r.shape.slice();for(let e=0;e<s.length;++e)i.splice(s[e],0,1);d(r.shape,i)||(r=bA({inputs:{x:r},backend:n,attrs:{shape:i}}),m.push(r)),null===p?p=r:(p=gA({inputs:{a:r,b:p},backend:n}),m.push(p))}e<h-1&&(u[e]>=0&&(p=CA({inputs:{x:p},backend:n,attrs:{axis:u[e]-(i.length-f),keepDims:!1}}),m.push(p)),f--)}for(const e of m)e!==p&&n.disposeIntermediateTensorInfo(e);return p}},MF=lA({opSnippet:"return (x >= 0.0) ? x : (exp(x) - 1.0);",packedOpSnippet:"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n"}),LF={kernelName:qe,backendName:"webgl",kernelFunc:MF},zF={kernelName:Ke,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n}=e,{dy:s,y:r}=t,a=K().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new JE("\n  vec4 bGTEZero = vec4(greaterThanEqual(b, vec4(0.)));\n  return (bGTEZero * a) + ((vec4(1.0) - bGTEZero) * (a * (b + vec4(1.0))));\n",s.shape,r.shape):new YE("return (b >= 1.0) ? a : a * (b + 1.0);",s.shape,r.shape);return n.runWebGLProgram(a,[s,r],s.dtype)}},BF=uA({opSnippet:"return float(a == b);",packedOpSnippet:"\n  return vec4(equal(a, b));\n",dtype:"bool"}),PF={kernelName:Ye,backendName:"webgl",kernelFunc:BF},WF=lA({opSnippet:`\n  // Error function is calculated approximately with elementary function.\n  // See "Handbook of Mathematical Functions with Formulas,\n  // Graphs, and Mathematical Tables", Abramowitz and Stegun.\n  float p = ${Kh};\n  float a1 = ${Xh};\n  float a2 = ${Yh};\n  float a3 = ${Jh};\n  float a4 = ${Zh};\n  float a5 = ${Qh};\n\n  float sign = sign(x);\n  x = abs(x);\n  float t = 1.0 / (1.0 + p * x);\n  return sign * (1.0 - (((((a5*t + a4)*t) + a3)*t + a2)*t + a1)*t*exp(-x*x));\n`}),VF={kernelName:Xe,backendName:"webgl",kernelFunc:WF},UF="return exp(x);",GF=lA({opSnippet:UF,packedOpSnippet:UF,cpuKernelImpl:lE}),HF={kernelName:Je,backendName:"webgl",kernelFunc:GF};function jF(e){const{inputs:t,attrs:n,backend:s}=e,{dim:r}=n,{input:a}=t,i=a.shape.length,o=a.shape.slice();let u=r;return r<0&&(l(-(i+1)<=r,(()=>`Axis must be in the interval [${-(i+1)}, ${i}]`)),u=i+r+1),o.splice(u,0,1),bA({inputs:{x:a},backend:s,attrs:{shape:o}})}const qF={kernelName:Ze,backendName:"webgl",kernelFunc:jF},KF="return exp(x) - 1.0;",XF=lA({opSnippet:KF,packedOpSnippet:KF,cpuKernelImpl:uE}),YF={kernelName:Qe,backendName:"webgl",kernelFunc:XF};class JF{constructor(e,t,n){this.variableNames=["real","imag"];const s=t[1];this.outputShape=t;const r=n?`2.0 * ${Math.PI}`:`-2.0 * ${Math.PI}`,a=n?`${s}.0`:"1.0";let i;if("real"===e)i="return real * expR - imag * expI;";else{if("imag"!==e)throw new Error(`FFT component must be either "real" or "imag", got ${e}.`);i="return real * expI + imag * expR;"}this.userCode=`\n      const float exponentMultiplier = ${r};\n\n      float unaryOpComplex(float real, float expR, float imag, float expI) {\n        ${i}\n      }\n\n      float mulMatDFT(int batch, int index) {\n        float indexRatio = float(index) / float(${s});\n        float exponentMultiplierTimesIndexRatio =\n            exponentMultiplier * indexRatio;\n\n        float result = 0.0;\n\n        for (int i = 0; i < ${s}; i++) {\n          // x = (-2|2 * PI / N) * index * i;\n          float x = exponentMultiplierTimesIndexRatio * float(i);\n          float expR = cos(x);\n          float expI = sin(x);\n          float real = getReal(batch, i);\n          float imag = getImag(batch, i);\n\n          result +=\n              unaryOpComplex(real, expR, imag, expI) / ${a};\n        }\n\n        return result;\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        setOutput(mulMatDFT(coords[0], coords[1]));\n      }\n    `}}function ZF(e,t,n){const s=n.texData.get(e.dataId),r=p(e.shape),a=e.shape[e.shape.length-1],i=bA({inputs:{x:e},backend:n,attrs:{shape:[r/a,a]}}),o=i.shape,l=new JF("real",o,t),u=new JF("imag",o,t),c=[{dataId:s.complexTensorInfos.real.dataId,dtype:s.complexTensorInfos.real.dtype,shape:o},{dataId:s.complexTensorInfos.imag.dataId,dtype:s.complexTensorInfos.imag.dtype,shape:o}],h=n.runWebGLProgram(l,c,"float32"),d=n.runWebGLProgram(u,c,"float32"),f=eA({inputs:{real:h,imag:d},backend:n});n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(d);const m=bA({inputs:{x:f},backend:n,attrs:{shape:e.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(f),m}const QF={kernelName:et,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t;return ZF(s,!1,n)}};class eD{constructor(e,t){this.outputShape=[],this.variableNames=["x"],this.outputShape=e,this.userCode="\n      uniform float value;\n      void main() {\n        // Input can be obtained from uniform value.\n        setOutput(value);\n      }\n    "}getCustomSetupFunc(e){return(t,n)=>{null==this.valueLoc&&(this.valueLoc=t.getUniformLocationNoThrow(n,"value")),t.gl.uniform1f(this.valueLoc,e)}}}function tD(e){const{backend:t,attrs:n}=e,{shape:s,value:r}=n;let{dtype:a}=n;if(a=a||F(r),"string"===a){const e=v(a,p(s));return e.fill(r),t.makeTensorInfo(s,a,e)}{const e=new eD(s,r),n=e.getCustomSetupFunc(r);return t.runWebGLProgram(e,[],a,n)}}const nD={kernelName:tt,backendName:"webgl",kernelFunc:tD};class sD{constructor(e){this.variableNames=["Image"],this.outputShape=[];const t=e[2];this.outputShape=e,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n\n          int coordX = ${t} - x;\n          float outputValue;\n          if(coordX >= 0 && coordX < ${t}) {\n            outputValue = getImage(coords[0], coords[1], coordX, coords[3]);\n          } else {\n            outputValue = getImage(coords[0], coords[1], coords[2], coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const rD={kernelName:nt,backendName:"webgl",kernelFunc:({inputs:e,backend:t})=>{const{image:n}=e,s=t,r=new sD(n.shape);return s.runWebGLProgram(r,[n],n.dtype)}},aD="return floor(x);",iD=lA({opSnippet:aD,packedOpSnippet:aD,cpuKernelImpl:cE}),oD={kernelName:st,backendName:"webgl",kernelFunc:iD},lD=uA({opSnippet:"\n  float s = sign(a) * sign(b);\n  int ia = round(a);\n  int ib = round(b);\n  if (ib != 0) {\n    // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n    return float(idiv(ia, ib, s));\n  } else {\n    return NAN;\n  }\n",packedOpSnippet:"\n  ivec4 ia = round(a);\n  ivec4 ib = round(b);\n  bvec4 cond = notEqual(ib, ivec4(0));\n  ivec4 result = ivec4(0);\n  vec4 s = sign(a) * sign(b);\n\n  // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n  if (cond[0]) {\n    result[0] = idiv(ia[0], ib[0], s[0]);\n  }\n  if (cond[1]) {\n    result[1] = idiv(ia[1], ib[1], s[1]);\n  }\n  if (cond[2]) {\n    result[2] = idiv(ia[2], ib[2], s[2]);\n  }\n  if (cond[3]) {\n    result[3] = idiv(ia[3], ib[3], s[3]);\n  }\n  return vec4(result);\n",dtype:"int32"}),uD={kernelName:rt,backendName:"webgl",kernelFunc:lD};class cD{constructor(e){this.variableNames=["A"];const t=kT(),[n,s]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n        vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${s}.0, ${n}.0);\n\n        vec4 values = ${t.texture2D}(A, uv);\n        float value;\n        if (depth == 0) {\n          value = values.r;\n        } else if (depth == 1) {\n          value = values.g;\n        } else if (depth == 2) {\n          value = values.b;\n        } else if (depth == 3) {\n          value = values.a;\n        }\n\n        setOutput(floor(value * 255.0 + 0.5));\n      }\n    `}}class hD{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const t=kT(),[n,s]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n\n        vec4 result = vec4(0.);\n\n        for(int row=0; row<=1; row++) {\n          for(int col=0; col<=1; col++) {\n            texC = coords[1] + row;\n            depth = coords[2] + col;\n\n            vec2 uv = (vec2(texC, texR) + halfCR) /\n                       vec2(${s}.0, ${n}.0);\n            vec4 values = ${t.texture2D}(A, uv);\n            float value;\n            if (depth == 0) {\n              value = values.r;\n            } else if (depth == 1) {\n              value = values.g;\n            } else if (depth == 2) {\n              value = values.b;\n            } else if (depth == 3) {\n              value = values.a;\n            }\n\n            result[row * 2 + col] = floor(value * 255.0 + 0.5);\n          }\n        }\n\n        ${t.output} = result;\n      }\n    `}}const pD={kernelName:jn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e;let{pixels:r}=t;const{numChannels:a}=s,i="undefined"!=typeof HTMLVideoElement&&r instanceof HTMLVideoElement,o="undefined"!=typeof HTMLImageElement&&r instanceof HTMLImageElement,[l,u]=i?[r.videoWidth,r.videoHeight]:[r.width,r.height],c=[u,l],h=[u,l,a];(o||i)&&(null==dD&&(dD=document.createElement("canvas").getContext("2d")),dD.canvas.width=l,dD.canvas.height=u,dD.drawImage(r,0,0,l,u),r=dD.canvas);const p=n.makeTensorInfo(c,"int32");n.texData.get(p.dataId).usage=US.PIXELS,n.gpgpu.uploadPixelDataToTexture(n.getTexture(p.dataId),r);const d=K().getBool("WEBGL_PACK")?new hD(h):new cD(h),f=n.runWebGLProgram(d,[p],"int32");return n.disposeData(p.dataId),f}};let dD;const fD={kernelName:Xn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s,m=Wi(c),g=Fi(r.shape,a.shape,l,h,u,p,!1,m);let y;const b=[];if(1!==g.filterHeight||1!==g.filterWidth||1!==g.dilationHeight||1!==g.dilationWidth||1!==g.strideHeight||1!==g.strideWidth||"SAME"!==g.padInfo.type&&"VALID"!==g.padInfo.type)if(K().getBool("WEBGL_CONV_IM2COL")&&1===r.shape[0])y=eF({x:r,filter:a,convInfo:g,backend:n,bias:i,activation:d,preluActivationWeights:o,leakyreluAlpha:f});else{const e=null!=i,t=null!=o,s="leakyrelu"===d,l=d?cA(d,!1):null,u=new YR(g,e,l,t,s),c=[r,a];if(i&&c.push(i),o&&c.push(o),s){const e=n.makeTensorInfo([],"float32",as(f,"float32"));c.push(e),b.push(e)}y=n.runWebGLProgram(u,c,"float32")}else y=QR({x:r,filter:a,convInfo:g,backend:n,bias:i,activation:d,preluActivationWeights:o,leakyreluAlpha:f});const x=bA({inputs:{x:y},backend:n,attrs:{shape:g.outShape}});return b.push(y),b.forEach((e=>n.disposeIntermediateTensorInfo(e))),x}};const mD={kernelName:Yn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:u,pad:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s,m=[];let g=h;null==g&&(g=[1,1]),l(Pi(u,g),(()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${u} and dilations '${g}'`));const y=Fi(r.shape,a.shape,u,g,c,p,!0),b=K().getBool("WEBGL_PACK_DEPTHWISECONV")&&y.strideWidth<=2&&y.outChannels/y.inChannels==1,x=d?cA(d,b):null,w=[r,a],k=null!=i,v=null!=o,N="leakyrelu"===d;if(k&&w.push(i),v&&w.push(o),N){const e=n.makeTensorInfo([],"float32",as(f,"float32"));w.push(e),m.push(e)}let I;I=b?new $F(y,k,x,v,N):new IF(y,k,x,v,N);const $=n.runWebGLProgram(I,w,"float32");return m.forEach((e=>n.disposeIntermediateTensorInfo(e))),$}};class gD{constructor(e,t,n){this.sliceDim=e,this.strides=t,this.variableNames=["x","indices"],this.outputShape=n;const s=QT(t.length),r=QT(n.length),a=this.sliceDim>1?"strides[j]":"strides";this.userCode=`\n        ${s} strides = ${s}(${this.strides});\n         void main() {\n          ${r} coords = getOutputCoords();\n          int flattenIndex = 0;\n          for (int j = 0; j < ${this.sliceDim}; j++) {\n            int index = round(getIndices(coords[0], j));\n            flattenIndex += index * ${a};\n          }\n          setOutput(getX(flattenIndex, coords[1]));\n        }\n      `}}const yD={kernelName:ot,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{params:s,indices:r}=t,a=r.shape,i=a[a.length-1],[o,l,u,c]=Ia(s,r),h=bA({inputs:{x:r},backend:n,attrs:{shape:[l,i]}}),d=bA({inputs:{x:s},backend:n,attrs:{shape:[p(s.shape)/u,u]}}),f=new gD(i,c,[l,u]),m=n.runWebGLProgram(f,[d,h],d.dtype),g=bA({inputs:{x:m},backend:n,attrs:{shape:o}});return n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(m),g}};class bD{constructor(e,t){this.variableNames=["A","indices"],this.outputShape=t,this.rank=t.length;const n=QT(this.rank),s=function(e,t){const n=["resRC.x","resRC.y","resRC.z","resRC.w"],s=[];for(let t=0;t<e.length;t++)2===t?s.push("int(getIndices(resRC.x, resRC.z))"):s.push(`${n[t]}`);return s.join()}(e);this.userCode=`\n      void main() {\n        ${n} resRC = getOutputCoords();\n        setOutput(getA(${s}));\n      }\n    `}}const xD={kernelName:it,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,indices:a}=t,{axis:i,batchDims:o}=s,l=wp(r,a,x(i,r.shape)[0],o),u=p(a.shape),c=[],h=bA({inputs:{x:r},backend:n,attrs:{shape:[l.batchSize,l.outerSize,l.dimSize,l.sliceSize]}}),d=bA({inputs:{x:a},backend:n,attrs:{shape:[l.batchSize,u/l.batchSize]}});c.push(h),c.push(d);const f=[l.batchSize,l.outerSize,u/l.batchSize,l.sliceSize];if(n.shouldExecuteOnCPU([r,a])||"string"===r.dtype){const e=n.bufferSync(d),t=n.bufferSync(h),s=hE(t,e,f);return c.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.makeTensorInfo(l.outputShape,s.dtype,s.values)}const m=new bD(h.shape,f),g=n.runWebGLProgram(m,[h,d],h.dtype);c.push(g);const y=bA({inputs:{x:g},backend:n,attrs:{shape:l.outputShape}});return c.forEach((e=>n.disposeIntermediateTensorInfo(e))),y}},wD=uA({opSnippet:"return float(a > b);",packedOpSnippet:"\n  return vec4(greaterThan(a, b));\n",cpuKernelImpl:pE,dtype:"bool"}),kD={kernelName:lt,backendName:"webgl",kernelFunc:wD},vD=uA({opSnippet:"return float(a >= b);",packedOpSnippet:"\n  return vec4(greaterThanEqual(a, b));\n",dtype:"bool"}),ND={kernelName:ut,backendName:"webgl",kernelFunc:vD};const ID={kernelName:ht,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t;return ZF(s,!0,n)}},$D=lA({opSnippet:"return float(!isnan(x) && !isinf(x));",dtype:"bool"}),CD={kernelName:dt,backendName:"webgl",kernelFunc:$D},SD=lA({opSnippet:"return float(isinf(x));",dtype:"bool"}),TD={kernelName:ft,backendName:"webgl",kernelFunc:SD},ED=lA({opSnippet:"return float(isnan(x));",dtype:"bool"}),AD={kernelName:mt,backendName:"webgl",kernelFunc:ED},RD=uA({opSnippet:"return float(a < b);",packedOpSnippet:"\n  return vec4(lessThan(a, b));\n",cpuKernelImpl:dE,dtype:"bool"}),FD={kernelName:yt,backendName:"webgl",kernelFunc:RD},DD=uA({opSnippet:"return float(a <= b);",packedOpSnippet:"\n  return vec4(lessThanEqual(a, b));\n",dtype:"bool"}),_D={kernelName:bt,backendName:"webgl",kernelFunc:DD};const OD={kernelName:xt,backendName:"webgl",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,num:a}=n,i=fE(s,r,a);return t.makeTensorInfo([i.length],"float32",i)}},MD=lA({opSnippet:"if (x < 0.0) return NAN;\n  return log(x);",packedOpSnippet:"\n  vec4 result = log(x);\n  vec4 isNaN = vec4(lessThan(x, vec4(0.0)));\n  result.r = isNaN.r == 1.0 ? NAN : result.r;\n  result.g = isNaN.g == 1.0 ? NAN : result.g;\n  result.b = isNaN.b == 1.0 ? NAN : result.b;\n  result.a = isNaN.a == 1.0 ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:mE}),LD={kernelName:wt,backendName:"webgl",kernelFunc:MD},zD=lA({opSnippet:"return log(1.0 + x);"}),BD={kernelName:kt,backendName:"webgl",kernelFunc:zD},PD=uA({opSnippet:"return float(a >= 1.0 && b >= 1.0);",packedOpSnippet:"\n  return vec4(\n    vec4(greaterThanEqual(a, vec4(1.0))) *\n    vec4(greaterThanEqual(b, vec4(1.0))));\n",dtype:"bool"}),WD={kernelName:vt,backendName:"webgl",kernelFunc:PD},VD=lA({opSnippet:"return float(!(x >= 1.0));"}),UD={kernelName:Nt,backendName:"webgl",kernelFunc:VD},GD=uA({opSnippet:"return float(a >= 1.0 || b >= 1.0);",packedOpSnippet:"\n  return min(\n    vec4(greaterThanEqual(a, vec4(1.0))) +\n    vec4(greaterThanEqual(b, vec4(1.0))),\n    vec4(1.0));\n",dtype:"bool"}),HD={kernelName:It,backendName:"webgl",kernelFunc:GD};class jD{constructor(e,t,n,s,r){this.variableNames=["x"],this.outputShape=[];const a=t,i=e[3]-1;let o;this.outputShape=e;const l=`float(${n}) + float(${s}) * sum`;o=.5===r?`inversesqrt(${l})`:1===r?`1.0/(${l})`:`exp(log(${l}) * float(-${r}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n        int d = coords[3];\n        float x = getX(b, r, c, d);\n        float sum = 0.0;\n        for (int j = -${a}; j <= ${a}; j++) {\n          int idx = d + j;\n          if (idx >= 0 && idx <=  ${i}) {\n            float z = getX(b, r, c, idx);\n            sum += z * z;\n          }\n        }\n        float val = x * ${o};\n        setOutput(val);\n      }\n    `}}class qD{constructor(e,t,n,s,r){this.variableNames=["x"],this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0;const a=t,i=e[3]-1;let o;this.outputShape=e;const l=`float(${n}) + float(${s}) * sum`;o=.5===r?`inversesqrt(${l})`:1===r?`1.0/(${l})`:`exp(log(${l}) * float(-${r}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords.x;\n        int r = coords.y;\n        int c = coords.z;\n        int d = coords.w;\n\n        bool hasNextCol = d < ${this.outputShape[3]};\n        bool hasNextRow = c < ${this.outputShape[2]};\n\n        vec4 sum = vec4(0.);\n        vec4 xFragAtOutputCoords = getX(b, r, c, d);\n\n        vec4 xAtOutputCoords = vec4(\n          getChannel(xFragAtOutputCoords, vec2(c, d)),\n          hasNextCol ?\n            getChannel(xFragAtOutputCoords, vec2(c, d + 1)) : 0.0,\n          hasNextRow ?\n            getChannel(xFragAtOutputCoords , vec2(c + 1, d)) : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getChannel(xFragAtOutputCoords, vec2(c + 1, d + 1)) : 0.0\n        );\n\n        int firstChannel = d - ${a};\n        vec2 cache = vec2(0.);\n        if(firstChannel >= 0){\n          vec4 firstChannelFrag = getX(b, r, c, firstChannel);\n          cache.x = getChannel(firstChannelFrag, vec2(c, firstChannel));\n            if(hasNextRow){\n              cache.y = getChannel(firstChannelFrag, vec2(c + 1, firstChannel));\n            }\n        }\n\n        ivec2 depth = ivec2(d, d + 1);\n        for (int j = - ${a}; j <= ${a}; j++) {\n          ivec2 idx = depth + j;\n          bvec2 aboveLowerBound = greaterThanEqual(idx, ivec2(0));\n          bvec2 belowUpperBound = lessThanEqual(idx, ivec2(${i}));\n\n          bool depthInRange = aboveLowerBound.x && belowUpperBound.x;\n          bool depthPlusOneInRange = aboveLowerBound.y && belowUpperBound.y;\n\n          if(depthInRange || depthPlusOneInRange){\n            vec4 z = vec4(0.);\n            vec4 xFragAtCurrentDepth;\n            z.xz = cache.xy;\n            if(depthPlusOneInRange && hasNextCol){\n              xFragAtCurrentDepth = idx.y != d ?\n                getX(b, r, c, idx.y) : xFragAtOutputCoords;\n              z.y = getChannel(xFragAtCurrentDepth, vec2(c, idx.y));\n              if(hasNextRow){\n                z.w = getChannel(xFragAtCurrentDepth, vec2(c + 1, idx.y));\n              }\n            }\n            cache.xy = z.yw;\n            sum += z * z;\n          }\n        }\n        vec4 result = xAtOutputCoords * ${o};\n        setOutput(result);\n      }\n    `}}const KD={kernelName:Ct,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{depthRadius:a,bias:i,alpha:o,beta:l}=s,u=K().getBool("WEBGL_PACK_NORMALIZATION")?new qD(r.shape,a,i,o,l):new jD(r.shape,a,i,o,l);return n.runWebGLProgram(u,[r],r.dtype)}};class XD{constructor(e,t,n,s,r){this.variableNames=["inputImage","outputImage","dy"],this.outputShape=[],this.outputShape=e,this.depth=e[3],this.depthRadius=t,this.bias=n,this.alpha=s,this.beta=r,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n\n        float result = 0.0;\n        for (int d = 0; d < ${this.depth}; ++d) {\n          int depthBegin = int(max(0.0, float(d - ${t})));\n          int depthEnd = int(min(float(${this.depth}),\n              float(d + ${t} + 1)));\n\n          const int MIN_DEPTH_BEGIN = 0;\n          const int MAX_DEPTH_END = ${this.depth};\n\n          float norm = 0.0;\n          for (int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k) {\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd) {\n              norm += getInputImage(b, r, c, k) * getInputImage(b, r, c, k);\n            }\n            else {\n              break;\n            }\n          }\n\n          norm = float(${s}) * norm + float(${n});\n\n          for(int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k){\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd){\n              float dyi = -2.0 * float(${s})\n                * float(${r})\n                * getInputImage(b ,r ,c, k) * getOutputImage(b, r, c, d)\n                / norm;\n              if (k == d) {\n                dyi += pow(norm, -1.0 * ${r});\n              }\n              if (k == coords[3]) {\n                dyi *= getDy(b, r, c, d);\n                result += dyi;\n              }\n            }\n            else {\n              break;\n            }\n          }\n      }\n      setOutput(result);\n      }\n    `}}const YD={kernelName:St,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r,y:a,dy:i}=t,{depthRadius:o,bias:l,alpha:u,beta:c}=s,h=new XD(r.shape,o,l,u,c);return n.runWebGLProgram(h,[r,a,i],r.dtype)}};function JD(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reductionIndices:a,keepDims:i}=s,o=r.shape.length,l=x(a,r.shape);let u=l;const c=bl(u,o),h=null!=c,d=n.shouldExecuteOnCPU([r]);let f=r;if(h){if(d){const e=n.texData.get(f.dataId).values,t=new Array(o);for(let e=0;e<t.length;e++)t[e]=r.shape[c[e]];const s=FE(e,r.shape,r.dtype,c,t);f=n.makeTensorInfo(t,r.dtype);n.texData.get(f.dataId).values=s}else f=$A(r,c,n);u=wl(u.length,o)}yl("max",u,o);const[m,g]=ml(f.shape,u);let y,b=m;if(i&&(b=gl(m,l)),d){const e=n.texData.get(f.dataId).values,t=gE(e,p(g),b,r.dtype);y=n.makeTensorInfo(b,r.dtype);n.texData.get(y.dataId).values=t}else y=function(e,t,n,s){const r=p(t),a=bA({inputs:{x:e},attrs:{shape:[p(e.shape)/r,r]},backend:s}),i=vA(a,e.dtype,"max",s),o=bA({inputs:{x:i},attrs:{shape:n},backend:s});return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}(f,g,b,n);return h&&n.disposeIntermediateTensorInfo(f),y}const ZD={kernelName:Tt,backendName:"webgl",kernelFunc:JD},QD=uA({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return max(a, b);\n",packedOpSnippet:"\n  vec4 result = vec4(max(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:yE}),e_={kernelName:Et,backendName:"webgl",kernelFunc:QD};const t_={kernelName:At,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;xT(r,"maxPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:u}=s;l(Pi(i,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`));const c=Ai(r.shape,a,i,1,o,u);if(1===c.filterWidth&&1===c.filterHeight&&d(c.inShape,c.outShape))return ZE({inputs:{x:r},backend:n});const h=new uR(c,"max",!1);return n.runWebGLProgram(h,[r],r.dtype)}};const n_={kernelName:Ft,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dataFormat:l,dimRoundingMode:u}=s,c=Ri(r.shape,a,i,[1,1,1],o,u,l),h=new cR(c,"max",!1);return n.runWebGLProgram(h,[r],r.dtype)}};class s_{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const t=e.strideHeight,n=e.strideWidth,s=e.dilationHeight,r=e.effectiveFilterHeight,a=e.effectiveFilterWidth,i=r-1-e.padInfo.top,o=a-1-e.padInfo.left,l=r*a-1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${o});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${r};\n          wR += ${s}) {\n          float dyR = float(dyRCorner + wR) / ${t}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${a}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${n}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n            int maxPosValue = ${l} - int(getMaxPos(b, idyR, idyC, d));\n\n            // Get the current value, check it against the value from the\n            // position matrix.\n            int curPosValue = wR * ${a} + wC;\n            float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n            dotProd += dyValue * mask;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class r_{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const t=e.strideDepth,n=e.strideHeight,s=e.strideWidth,r=e.dilationDepth,a=e.dilationHeight,i=e.dilationWidth,o=e.effectiveFilterDepth,l=e.effectiveFilterHeight,u=e.effectiveFilterWidth,c=o-1-e.padInfo.front,h=l-1-e.padInfo.top,p=u-1-e.padInfo.left,d=o*l*u-1;this.userCode=`\n      const ivec3 pads = ivec3(${c}, ${h}, ${p});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, ch) with pos mask(:, :, :, d) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${o};\n           wD += ${r}) {\n          float dyD = float(dyDCorner + wD) / ${t}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${l};\n              wR += ${a}) {\n            float dyR = float(dyRCorner + wR) / ${n}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${u};\n                wC += ${i}) {\n              float dyC = float(dyCCorner + wC) / ${s}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n              int maxPosValue = ${d} -\n                  int(getMaxPos(batch, idyD, idyR, idyC, ch));\n\n              // Get the current value, check it against the value from the\n              // position matrix.\n              int curPosValue =\n                  wD * ${l} * ${u} +\n                  wR * ${u} + wC;\n              float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n              dotProd += dyValue * mask;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const a_={kernelName:Dt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a,{filterSize:o,strides:l,pad:u,dimRoundingMode:c}=s,h=Ri(i.shape,o,l,[1,1,1],u,c),p=new cR(h,"max",!0),d=n.runWebGLProgram(p,[i],i.dtype),f=new r_(h),m=n.runWebGLProgram(f,[r,d],i.dtype);return n.disposeIntermediateTensorInfo(d),m}};const i_={kernelName:Rt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a,output:i}=t,o=a;xT([a,i],"maxPoolGrad");const{filterSize:l,strides:u,pad:c,dimRoundingMode:h}=s,p=Ai(o.shape,l,u,1,c,h),d=new uR(p,"max",!0),f=n.runWebGLProgram(d,[o],o.dtype),m=new s_(p),g=n.runWebGLProgram(m,[r,f],o.dtype);return n.disposeIntermediateTensorInfo(f),g}};const o_={kernelName:_t,backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{filterSize:r,strides:a,pad:i,includeBatchInIndex:o}=t,u=n;l(4===s.shape.length,(()=>`Error in maxPool: input must be rank 4 but got rank ${s.shape.length}.`));const c=[1,1];l(Pi(a,c),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${a} and dilations '${c}'`));const h=Ai(s.shape,r,a,c,i),[p,d]=function(e,t,n,s){let r=new uR(n,"max",!1);const a=s.runWebGLProgram(r,[e],"float32");return r=new uR(n,"max",!0,!0,t),[a,s.runWebGLProgram(r,[e],"float32")]}(s,o,h,u);return[p,d]}};const l_={kernelName:Ot,backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{keepDims:r,axis:a}=t,i=n,o=s.shape.length,l=x(a,s.shape);let u=l;const c=bl(u,o),h=null!=c,d=i.shouldExecuteOnCPU([s]),f=[];let m=s;if(h){if(d){const e=i.texData.get(m.dataId).values,t=new Array(o);for(let e=0;e<t.length;e++)t[e]=s.shape[c[e]];const n=FE(e,s.shape,s.dtype,c,t);m=i.makeTensorInfo(t,s.dtype);i.texData.get(m.dataId).values=n}else m=$A(s,c,i);f.push(m),u=wl(u.length,o)}yl("sum",u,o);const[g,y]=ml(m.shape,u);let b=g;r&&(b=gl(g,l));const w=function(e,t,n,s){const r=p(t),a=bA({inputs:{x:e},attrs:{shape:[p(e.shape)/r,r]},backend:s}),i=vA(a,"float32","mean",s),o=bA({inputs:{x:i},attrs:{shape:n},backend:s});return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}(m,y,b,i);for(const e of f)i.disposeIntermediateTensorInfo(e);return w}};const u_={kernelName:Mt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=x(a,r.shape);let u=l;const c=bl(u,o);let h=r;null!=c&&(h=TA({inputs:{x:r},backend:n,attrs:{perm:c}}),u=wl(u.length,r.shape.length)),yl("min",u,o);const[d,f]=ml(h.shape,u),m=bA({inputs:{x:h},backend:n,attrs:{shape:[-1,p(f)]}}),g=vA(m,m.dtype,"min",n);let y;if(i){y=bA({inputs:{x:g},backend:n,attrs:{shape:gl(d,l)}})}else y=bA({inputs:{x:g},backend:n,attrs:{shape:d}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(h),y}},c_=uA({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return min(a, b);\n",packedOpSnippet:"\n  vec4 result = vec4(min(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:bE}),h_={kernelName:Lt,backendName:"webgl",kernelFunc:c_};class p_{constructor(e,t,n){this.variableNames=["x"],this.outputShape=t.map(((t,n)=>t[0]+e[n]+t[1]));const s=e.length,r=QT(s),a=t.map((e=>e[0])).join(","),i=t.map(((t,n)=>t[0]+e[n])).join(","),o=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,s),l="reflect"===n?0:1;this.userCode=1!==s?`\n      ${r} start = ${r}(${a});\n      ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outC = getOutputCoords();\n        for (int i = 0; i < ${s}; i++) {\n          if (outC[i] < start[i]) {\n            outC[i] = start[i] * 2 - outC[i] - ${l};\n          } else if(outC[i] >= end[i]) {\n            outC[i] = (end[i] - 1) * 2 - outC[i] + ${l};\n          }\n        }\n        ${r} coords = outC - start;\n        setOutput(getX(${o}));\n      }\n    `:`\n        int start = ${a};\n        int end = ${i};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start) {\n            outC = start * 2 - outC - ${l};\n          } else if(outC >= end) {\n            outC = (end - 1) * 2 - outC + ${l};\n          }\n          setOutput(getX(outC - start));\n        }\n      `}}class d_{constructor(e,t,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t.map(((t,n)=>t[0]+e[n]+t[1]));const s=e.length,r=QT(s),a=t.map((e=>e[0])).join(","),i=t.map(((t,n)=>t[0]+e[n])).join(","),o=OE("rc",s),l=OE("source",s),u=`${o[s-1]} < ${this.outputShape[s-1]}`,c=1===s?"source":`vec2(${l.slice(-2).join()})`,h="reflect"===n?0:1;let p="";if(1===s){const e=`\n        ${r} source = rc;\n        if (source < start) {\n          source = start * 2 - source - ${h};\n        } else if (source >= end) {\n          source = (end - 1) * 2 - source + ${h};\n        }\n        source -= start;\n      `;p=`\n        ${r} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${l.join()}), ${c});\n        ${o[s-1]} += 1;\n        if(${u}) {\n          ${e}\n          result[1] = getChannel(getX(${l.join()}), ${c});\n        }\n      `}else{const e=`\n        ${r} source = rc;\n        ${r} lt = ${r}(lessThan(source, start));\n        ${r} gte = ${r}(greaterThanEqual(source, end));\n        ${r} orig = 1 - (lt + gte);\n        source = orig * source +\n                lt * (start * 2 - source - ${h}) +\n                gte * ((end - 1) * 2 - source + ${h});\n        source -= start;\n      `;p=`\n        ${r} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${l.join()}), ${c});\n        ${o[s-1]} += 1;\n        if(${u}) {\n          ${e}\n          result[1] = getChannel(getX(${l.join()}), ${c});\n        }\n        rc = outputLoc;\n        ${o[s-2]} += 1;\n        if(${o[s-2]} < ${this.outputShape[s-2]}) {\n          ${e}\n          result[2] = getChannel(getX(${l.join()}), ${c});\n          ${o[s-1]} += 1;\n          if(${u}) {\n            ${e}\n            result[3] = getChannel(getX(${l.join()}), ${c});\n          }\n        }\n      `}this.userCode=`\n      const ${r} start = ${r}(${a});\n      const ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${p}\n        setOutput(result);\n      }\n    `}}const f_={kernelName:zt,backendName:"webgl",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s}=e,{paddings:r,mode:a}=n,i=K().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new d_(s.shape,r,a):new p_(s.shape,r,a);return t.runWebGLProgram(i,[s],s.dtype)}},m_=uA({opSnippet:"if (b == 0.0) return NAN;\n  return mod(a, b);",packedOpSnippet:"\n  vec4 result = mod(a, b);\n  vec4 isNaN = vec4(equal(b, vec4(0.0)));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),g_={kernelName:Bt,backendName:"webgl",kernelFunc:m_};class y_{constructor(e,t,n){this.variableNames=["probs"],this.outputShape=[e,n],this.userCode=`\n      uniform float seed;\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n\n        float r = random(seed);\n        float cdf = 0.0;\n\n        for (int i = 0; i < ${t-1}; i++) {\n          cdf += getProbs(batch, i);\n\n          if (r < cdf) {\n            setOutput(float(i));\n            return;\n          }\n        }\n\n        // If no other event happened, last event happened.\n        setOutput(float(${t-1}));\n      }\n    `}getCustomSetupFunc(e){return(t,n)=>{null==this.seedLoc&&(this.seedLoc=t.getUniformLocation(n,"seed")),t.gl.uniform1f(this.seedLoc,e)}}}const b_=uA({opSnippet:"\nif (a == b) {\n  return 1.0;\n};\nreturn a / b;",packedOpSnippet:"\n  // vec4 one = vec4(equal(a, b));\n  // return one + (vec4(1.0) - one) * a / b;\n  vec4 result = a / b;\n  if(a.x == b.x) {\n    result.x = 1.;\n  }\n  if(a.y == b.y) {\n    result.y = 1.;\n  }\n  if(a.z == b.z) {\n    result.z = 1.;\n  }\n  if(a.w == b.w) {\n    result.w = 1.;\n  }\n\n  return result;\n",checkOutOfBounds:!0}),x_={kernelName:He,backendName:"webgl",kernelFunc:b_},w_="return a - b;",k_=uA({opSnippet:w_,packedOpSnippet:w_,supportsComplex:!0,cpuKernelImpl:EE}),v_={kernelName:_n,backendName:"webgl",kernelFunc:k_};function N_(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{dim:a}=s,i=x([a],r.shape),o=JD({inputs:{x:r},backend:n,attrs:{reductionIndices:i,keepDims:!1}}),l=gl(o.shape,i),u=bA({inputs:{x:o},backend:n,attrs:{shape:l}}),c=k_({inputs:{a:r,b:u},backend:n}),h=GF({inputs:{x:c},backend:n}),p=CA({inputs:{x:h},backend:n,attrs:{axis:i,keepDims:!1}}),d=bA({inputs:{x:p},backend:n,attrs:{shape:l}}),f=b_({inputs:{a:h,b:d},backend:n});return n.disposeIntermediateTensorInfo(o),n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(c),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(d),f}const I_={kernelName:Sn,backendName:"webgl",kernelFunc:N_};const $_={kernelName:Pt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{numSamples:a,seed:i,normalized:o}=s,l=o?r:N_({inputs:{logits:r},backend:n,attrs:{dim:r.shape.length-1}}),u=l.shape[0],c=l.shape[1],h=new y_(u,c,a),p=h.getCustomSetupFunc(i),d=n.runWebGLProgram(h,[l],"int32",p);return o||n.disposeIntermediateTensorInfo(l),d}},C_="return -x;";const S_={kernelName:Vt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;if(n.shouldExecuteOnCPU([s])){const e=n.texData.get(s.dataId),[t,r]=wE(e.values,s.shape,s.dtype);return n.makeTensorInfo(r,s.dtype,t)}let r;return r=K().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new HE(s.shape,C_):new VE(s.shape,C_),n.runWebGLProgram(r,[s],s.dtype)}},T_=Wc;const E_={kernelName:Gt,backendName:"webgl",kernelFunc:function(e){ep("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=s,u=n.readSync(r.dataId),c=n.readSync(a.dataId),{selectedIndices:h}=T_(u,c,i,o,l);return n.makeTensorInfo([h.length],"int32",new Int32Array(h))}},A_=Vc;const R_={kernelName:Ht,backendName:"webgl",kernelFunc:function(e){ep("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,padToMaxOutputSize:u}=s,c=n.readSync(r.dataId),h=n.readSync(a.dataId),{selectedIndices:p,validOutputs:d}=A_(c,h,i,o,l,u);return[n.makeTensorInfo([p.length],"int32",new Int32Array(p)),n.makeTensorInfo([],"int32",new Int32Array([d]))]}},F_=Uc;const D_={kernelName:jt,backendName:"webgl",kernelFunc:function(e){ep("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,softNmsSigma:u}=s,c=n.readSync(r.dataId),h=n.readSync(a.dataId),p=i,d=o,f=l,m=u,{selectedIndices:g,selectedScores:y}=F_(c,h,p,d,f,m);return[n.makeTensorInfo([g.length],"int32",new Int32Array(g)),n.makeTensorInfo([y.length],"float32",new Float32Array(y))]}};class __{constructor(e,t,n,s){this.variableNames=["indices"],this.outputShape=[e,t],this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int index = round(getIndices(coords.x));\n        setOutput(mix(float(${s}), float(${n}),\n                      float(index == coords.y)));\n      }\n    `}}const O_={kernelName:Kt,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{indices:r}=t,{depth:a,onValue:i,offValue:o}=s,l=p(r.shape),u=new __(l,a,i,o),c=bA({inputs:{x:r},backend:n,attrs:{shape:[l]}}),h=n.runWebGLProgram(u,[c],r.dtype);n.disposeIntermediateTensorInfo(c);const d=bA({inputs:{x:h},backend:n,attrs:{shape:[...r.shape,a]}});return n.disposeIntermediateTensorInfo(h),d}};function M_(e){const{inputs:t,backend:n}=e,{x:s}=t;if("complex64"===s.dtype){const e=AR({inputs:{input:s},backend:n}),t=M_({inputs:{x:e},backend:n}),r=HR({inputs:{input:s},backend:n}),a=M_({inputs:{x:r},backend:n}),i=eA({inputs:{real:t,imag:a},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(a),i}return tD({attrs:{shape:s.shape,dtype:s.dtype,value:"string"===s.dtype?"":0},backend:n})}const L_={kernelName:Gn,backendName:"webgl",kernelFunc:M_};const z_={kernelName:qt,backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s}=t,{x:r}=n;if("string"===r.dtype)throw new Error("onesLike is not supported under string dtype");if("complex64"===r.dtype){const t=AR({inputs:{input:r},backend:s}),n=e({inputs:{x:t},backend:s}),a=HR({inputs:{input:r},backend:s}),i=M_({inputs:{x:a},backend:s}),o=eA({inputs:{real:n,imag:i},backend:s});return s.disposeIntermediateTensorInfo(t),s.disposeIntermediateTensorInfo(n),s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}return tD({attrs:{shape:r.shape,dtype:r.dtype,value:1},backend:s})}};const B_={kernelName:Xt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s;if(1===t.length)return jF({inputs:{input:t[0]},backend:n,attrs:{dim:r}});const a=t[0].shape,i=t[0].dtype;t.forEach((e=>{u(a,e.shape,"All tensors passed to stack must have matching shapes"),l(i===e.dtype,(()=>"All tensors passed to stack must have matching dtypes"))}));const o=[],c=KR({inputs:t.map((e=>{const t=jF({inputs:{input:e},backend:n,attrs:{dim:r}});return o.push(t),t})),backend:n,attrs:{axis:r}});return o.forEach((e=>n.disposeIntermediateTensorInfo(e))),c}};class P_{constructor(e,t,n){this.variableNames=["x"],this.outputShape=t.map(((t,n)=>t[0]+e[n]+t[1]));const s=e.length,r=QT(s),a=t.map((e=>e[0])).join(","),i=t.map(((t,n)=>t[0]+e[n])).join(","),o=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,s);this.userCode=1!==s?`\n      ${r} start = ${r}(${a});\n      ${r} end = ${r}(${i});\n      uniform float value;\n\n      void main() {\n        ${r} outC = getOutputCoords();\n        if (any(lessThan(outC, start)) || any(greaterThanEqual(outC, end))) {\n          setOutput(value);\n        } else {\n          ${r} coords = outC - start;\n          setOutput(getX(${o}));\n        }\n      }\n    `:`\n        int start = ${a};\n        int end = ${i};\n        uniform float value;\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start || outC >= end) {\n            setOutput(value);\n          } else {\n            setOutput(getX(outC - start));\n          }\n        }\n      `}getCustomSetupFunc(e){return(t,n)=>{null==this.valueLoc&&(this.valueLoc=t.getUniformLocationNoThrow(n,"value")),t.gl.uniform1f(this.valueLoc,e)}}}class W_{constructor(e,t,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t.map(((t,n)=>t[0]+e[n]+t[1]));const s=e.length,r=QT(s),a=t.map((e=>e[0])).join(","),i=t.map(((t,n)=>t[0]+e[n])).join(","),o=OE("rc",s),l=OE("source",s),u=`${o[s-1]} < ${this.outputShape[s-1]}`,c=1===s?"source":`vec2(${l.slice(-2).join()})`,h=[`${r} rc = outputLoc;`,`${o[s-1]} += 1;\n       if(${u}) {\n      `,1===s?"":`}\n       rc = outputLoc;\n       ${o[s-2]} += 1;\n       if(${o[s-2]} < ${this.outputShape[s-2]}) {`,1===s?"":`  ${o[s-1]} += 1;\n         if(${u}) {`],p=1===s?"rc < start || rc >= end":"any(lessThan(rc, start)) || any(greaterThanEqual(rc, end))";let d="";for(let e=0,t=1===s?2:4;e<t;e++)d+=`\n        ${h[e]}\n        if (${p}) {\n          result[${e}] = float(value);\n        } else {\n          ${r} source = rc - start;\n          result[${e}] = getChannel(getX(${l.join()}), ${c});\n        }\n      `;d+=1===s?"} ":"}}",this.userCode=`\n      const ${r} start = ${r}(${a});\n      const ${r} end = ${r}(${i});\n      uniform float value;\n\n      void main() {\n        ${r} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${d}\n        setOutput(result);\n      }\n    `}getCustomSetupFunc(e){return(t,n)=>{null==this.valueLoc&&(this.valueLoc=t.getUniformLocationNoThrow(n,"value")),t.gl.uniform1f(this.valueLoc,e)}}}const V_=e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,constantValue:i}=s,o=K().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new W_(r.shape,a,i):new P_(r.shape,a,i),l=o.getCustomSetupFunc(i);return n.runWebGLProgram(o,[r],r.dtype,l)},U_={kernelName:Yt,backendName:"webgl",kernelFunc:V_},G_=uA({opSnippet:"\n  if(a < 0.0 && floor(b) < b){\n    return NAN;\n  }\n  if (b == 0.0) {\n    return 1.0;\n  }\n  return (round(mod(b, 2.0)) != 1) ?\n      pow(abs(a), b) : sign(a) * pow(abs(a), b);\n",packedOpSnippet:"\n  // isModRound1 has 1 for components with round(mod(b, 2.0)) == 1, 0 otherwise.\n  vec4 isModRound1 = vec4(equal(round(mod(b, 2.0)), ivec4(1)));\n  vec4 multiplier = sign(a) * isModRound1 + (vec4(1.0) - isModRound1);\n  vec4 result = multiplier * pow(abs(a), b);\n\n  // Ensure that a^0 = 1, including 0^0 = 1 as this correspond to TF and JS\n  bvec4 isExpZero = equal(b, vec4(0.0));\n  result.r = isExpZero.r ? 1.0 : result.r;\n  result.g = isExpZero.g ? 1.0 : result.g;\n  result.b = isExpZero.b ? 1.0 : result.b;\n  result.a = isExpZero.a ? 1.0 : result.a;\n\n  vec4 isNaN = vec4(lessThan(a, vec4(0.0))) * vec4(lessThan(floor(b), b));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),H_={kernelName:Jt,backendName:"webgl",kernelFunc:G_};const j_={kernelName:Qt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=[],u=x(a,r.shape);let c=u;const h=bl(c,o);let d,f=r;if(null!=h&&(f=TA({inputs:{x:r},backend:n,attrs:{perm:h}}),c=wl(c.length,o),l.push(f)),yl("prod",c,o),n.shouldExecuteOnCPU([f])){const e=n.texData.get(f.dataId).values,{outVals:t,outShape:s,outDtype:r}=kE(f.shape,f.dtype,e,c);d=n.makeTensorInfo(s,r,t)}else{const[e,t]=ml(f.shape,c),s=p(t),a=bA({inputs:{x:f},backend:n,attrs:{shape:[-1,s]}}),i=vA(a,_s(r.dtype),"prod",n);d=bA({inputs:{x:i},backend:n,attrs:{shape:e}}),l.push(a),l.push(i)}if(i){l.push(d);const e=gl(d.shape,u);d=bA({inputs:{x:d},backend:n,attrs:{shape:e}})}return l.forEach((e=>n.disposeIntermediateTensorInfo(e))),d}},q_=e=>{const{backend:t,attrs:n}=e,{start:s,stop:r,step:a,dtype:i}=n,o=vE(s,r,a,i);return t.makeTensorInfo([o.length],i,o)},K_={kernelName:en,backendName:"webgl",kernelFunc:q_},X_=lA({opSnippet:"return 1.0 / x;"}),Y_={kernelName:nn,backendName:"webgl",kernelFunc:X_},J_=lA({opSnippet:"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n",packedOpSnippet:"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"}),Z_={kernelName:sn,backendName:"webgl",kernelFunc:J_},Q_=lA({opSnippet:"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n",packedOpSnippet:"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"}),eO={kernelName:cn,backendName:"webgl",kernelFunc:Q_};class tO{constructor(e,t,n,s,r){this.variableNames=["A"],this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n];let h;h=r?"(vec2(yRC) + vec2(0.5)) * effectiveInputOverOutputRatioRC - vec2(0.5)":"vec2(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]});\n      const vec2 inputShapeRC = vec2(${i}.0, ${o}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = ${h};\n\n        // Compute the four integer indices.\n        ivec2 sourceFloorRC = ivec2(max(sourceFracIndexRC, vec2(0.0)));\n        ivec2 sourceCeilRC = ivec2(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        float topLeft = getA(b, sourceFloorRC.x, sourceFloorRC.y, d);\n        float bottomLeft = getA(b, sourceCeilRC.x, sourceFloorRC.y, d);\n        float topRight = getA(b, sourceFloorRC.x, sourceCeilRC.y, d);\n        float bottomRight = getA(b, sourceCeilRC.x, sourceCeilRC.y, d);\n\n        vec2 fracRC = sourceFracIndexRC - vec2(sourceFloorRC);\n\n        float top = topLeft + (topRight - topLeft) * fracRC.y;\n        float bottom = bottomLeft + (bottomRight - bottomLeft) * fracRC.y;\n        float newValue = top + (bottom - top) * fracRC.x;\n\n        setOutput(newValue);\n      }\n    `}}class nO{constructor(e,t,n,s,r){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n];let h;h=r?"(vec3(yRC) + vec3(0.5)) * effectiveInputOverOutputRatioRC - vec3(0.5)":"vec3(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec3 effectiveInputOverOutputRatioRC = vec3(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]},\n          ${u[1]/c[1]});\n      const vec3 inputShapeRC = vec3(${i}.0, ${o}.0,\n                                     ${o}.0);\n\n      float getAValue(int b, int r, int c, int d) {\n        return getChannel(getA(b, r, c, d), vec2(c, d));\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        // Calculate values for next column in yRC.z.\n        ivec3 yRC = coords.yzz + ivec3(0, 0, 1);\n\n        // Fractional source index.\n        vec3 sourceFracIndexRC = ${h};\n\n        // Compute the four integer indices.\n        ivec3 sourceFloorRC = ivec3(max(sourceFracIndexRC, vec3(0.0)));\n        ivec3 sourceCeilRC = ivec3(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        // Should we calculate next column and row elements in 2x2 packed cell.\n        bool hasNextCol = d < ${l-1};\n        bool hasNextRow = coords.z < ${n-1};\n\n        // In parallel, construct four corners for all four components in\n        // packed 2x2 cell.\n        vec4 topLeft = vec4(\n          getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 bottomLeft = vec4(\n          getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 topRight = vec4(\n          getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec4 bottomRight = vec4(\n          getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec3 fracRC = sourceFracIndexRC - vec3(sourceFloorRC);\n\n        vec4 top = mix(topLeft, topRight, fracRC.yyzz);\n        vec4 bottom = mix(bottomLeft, bottomRight, fracRC.yyzz);\n        vec4 newValue = mix(top, bottom, fracRC.x);\n\n        setOutput(newValue);\n      }\n    `}}const sO={kernelName:ln,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s,[l,u]=o,c=K().getBool("WEBGL_PACK_IMAGE_OPERATIONS")?new nO(r.shape,l,u,a,i):new tO(r.shape,l,u,a,i);return n.runWebGLProgram(c,[r],"float32")}};class rO{constructor(e,t,n){this.variableNames=["dy"],this.outputShape=[],this.outputShape=t;const[,s,r]=t,[,a,i]=e,o=[n&&a>1?s-1:s,n&&i>1?r-1:r],l=[n&&a>1?a-1:a,n&&i>1?i-1:i],u=o[0]/l[0],c=o[1]/l[1],h=1/u,p=1/c,d=2*Math.ceil(h)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${u});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${h});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${d});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(startRLerp - float(winHeight / 2));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(startCLerp - float(winWidth / 2));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${a}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${i}) {\n              continue;\n            }\n\n            float dxR = float(dyR) * heightScale;\n            int topDxRIndex = int(floor(dxR));\n            int bottomDxRIndex = int(min(ceil(dxR), ${s-1}.0));\n            float dxRLerp = dxR - float(topDxRIndex);\n            float inverseDxRLerp = 1.0 - dxRLerp;\n\n            float dxC = float(dyC) * widthScale;\n            int leftDxCIndex = int(floor(dxC));\n            int rightDxCIndex = int(min(ceil(dxC), ${r-1}.0));\n            float dxCLerp = dxC - float(leftDxCIndex);\n            float inverseDxCLerp = 1.0 - dxCLerp;\n\n            if (r == topDxRIndex && c == leftDxCIndex) {\n              // topLeft\n              accumulator +=\n                getDy(b, dyR, dyC, d) * inverseDxRLerp * inverseDxCLerp;\n            }\n\n            if (r == topDxRIndex && c == rightDxCIndex) {\n              // topRight\n              accumulator += getDy(b, dyR, dyC, d) * inverseDxRLerp * dxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == leftDxCIndex) {\n              // bottomLeft\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * inverseDxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == rightDxCIndex) {\n              // bottomRight\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * dxCLerp;\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}const aO={kernelName:un,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s,o=new rO(a.shape,r.shape,i);return n.runWebGLProgram(o,[a],a.dtype)}};class iO{constructor(e,t,n,s,r){this.variableNames=["A"],this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n],h=s?"0.5":"0.0";let p;p=r?"max((vec2(yRC) + vec2(0.5)) * effectiveInputOverOutputRatioRC, vec2(0.0))":"vec2(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]});\n      const vec2 inputShapeRC = vec2(${i}.0, ${o}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = ${p};\n\n        // Compute the coordinators of nearest neighbor point.\n        ivec2 sourceNearestRC = ivec2(\n          min(inputShapeRC - 1.0, floor(sourceFracIndexRC + ${h})));\n        float newValue = getA(b, sourceNearestRC.x, sourceNearestRC.y, d);\n\n        setOutput(newValue);\n      }\n    `}}class oO{constructor(e,t,n,s,r){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n],h=s?"0.5":"0.0";let p;p=r?"max((vec3(yRC) + vec3(0.5)) * effectiveInputOverOutputRatioRC, vec3(0.0))":"vec3(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec3 effectiveInputOverOutputRatioRC = vec3(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]},\n          ${u[1]/c[1]});\n      const vec3 inputShapeRC = vec3(${i}.0, ${o}.0,\n                                     ${o}.0);\n\n      float getAValue(int b, int r, int c, int d) {\n        return getChannel(getA(b, r, c, d), vec2(c, d));\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        // Calculate values for next column in yRC.z.\n        ivec3 yRC = coords.yzz + ivec3(0, 0, 1);\n\n        // Fractional source index.\n        vec3 sourceFracIndexRC = ${p};\n\n        // Compute the coordinators of nearest neighbor point.\n        ivec3 sourceNearestRC = ivec3(\n          min(inputShapeRC - 1.0, floor(sourceFracIndexRC + ${h})));\n\n        // Should we calculate next column and row elements in 2x2 packed cell.\n        bool hasNextCol = d < ${l-1};\n        bool hasNextRow = coords.z < ${n-1};\n\n        vec4 newValue = vec4(\n          getAValue(b, sourceNearestRC.x, sourceNearestRC.y, d),\n          hasNextCol ? getAValue(b, sourceNearestRC.x, sourceNearestRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceNearestRC.x, sourceNearestRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceNearestRC.x, sourceNearestRC.z, d + 1) : 0.0);\n\n        setOutput(newValue);\n      }\n    `}}const lO={kernelName:an,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s,[l,u]=o,c=K().getBool("WEBGL_PACK_IMAGE_OPERATIONS")?new oO(r.shape,l,u,a,i):new iO(r.shape,l,u,a,i);return n.runWebGLProgram(c,[r],r.dtype)}};class uO{constructor(e,t,n){this.variableNames=["dy"],this.outputShape=[],this.outputShape=t;const[,s,r]=t,[,a,i]=e,o=[n&&a>1?s-1:s,n&&i>1?r-1:r],l=[n&&a>1?a-1:a,n&&i>1?i-1:i],u=o[0]/l[0],c=o[1]/l[1],h=1/u,p=1/c,d=2*Math.ceil(h)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${u});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${h});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${d});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(floor(startRLerp - float(winHeight / 2)));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(floor(startCLerp - float(winWidth / 2)));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${a}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${i}) {\n              continue;\n            }\n\n            float sourceFracRow =\n              float(${o[0]}) *\n                (float(dyR) / float(${l[0]}));\n\n            float sourceFracCol =\n                float(${o[1]}) *\n                  (float(dyC) / float(${l[1]}));\n\n            int sourceNearestRow = int(min(\n                float(int(${s}) - 1),\n                ${n} ? float(round(sourceFracRow)) :\n                                  float(floor(sourceFracRow))));\n\n            int sourceNearestCol = int(min(\n                float(int(${r}) - 1),\n                ${n} ? float(round(sourceFracCol)) :\n                                  float(floor(sourceFracCol))));\n\n            if (r == sourceNearestRow && c == sourceNearestCol) {\n              accumulator += getDy(b, dyR, dyC, d);\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}const cO={kernelName:on,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s,o=new uO(a.shape,r.shape,i);return n.runWebGLProgram(o,[a],a.dtype)}};class hO{constructor(e,t){this.variableNames=["x"];const n=e.length;if(n>4)throw new Error(`WebGL backend: Reverse of rank-${n} tensor is not yet supported`);if(this.outputShape=e,1===n)return void(this.userCode=`\n        void main() {\n          int coord = getOutputCoords();\n          setOutput(getX(${e[0]} - coord - 1));\n        }\n      `);const s=e.map(((n,s)=>(n=>-1!==t.indexOf(n)&&1!==e[n]?`${e[n]} - coords[${n}] - 1`:`coords[${n}]`)(s))).join(","),r=QT(n);this.userCode=`\n      void main() {\n        ${r} coords = getOutputCoords();\n        setOutput(getX(${s}));\n      }\n    `}}class pO{constructor(e,t){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0;const n=e.length;if(n>4)throw new Error(`WebGL backend: Reverse of rank-${n} tensor is not yet supported`);this.outputShape=e;const s=OE("rc",n),r=`${s[n-1]} + 1 < ${this.outputShape[n-1]}`,a=`${s[n-2]} + 1 < ${this.outputShape[n-2]}`,i=QT(n);function o(n){const s=e.map(((s,r)=>function(n,s){return-1!==t.indexOf(n)&&1!==e[n]?`${e[n]} - ${s[n]} - 1`:`${s[n]}`}(r,n)));return`getChannel(getX(${s.join(",")}), vec2(${s.slice(-2).join(",")}))`}this.userCode=1===n?`\n        void main(){\n          int rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = getChannel(getX(${e[0]} - rc - 1),\n            ${e[0]} - rc - 1);\n          if(${r}){\n              result.g = getChannel(getX(${e[0]} - (rc  + 1) - 1),\n                ${e[0]} - (rc  + 1) - 1);\n          }\n          setOutput(result);\n        }\n      `:`\n        void main() {\n          ${i} rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = ${function(e){return o(e)}(s.slice())};\n          if(${r}){\n            result.g = ${function(e){return e[n-1]="("+e[n-1]+" + 1)",o(e)}(s.slice())};\n          }\n          if(${a}) {\n            result.b = ${function(e){return e[n-2]="("+e[n-2]+" + 1)",o(e)}(s.slice())};\n            if(${r}) {\n              result.a = ${function(e){return e[n-1]="("+e[n-1]+" + 1)",e[n-2]="("+e[n-2]+" + 1)",o(e)}(s.slice())};\n            }\n          }\n          setOutput(result);\n        }\n    `}}const dO={kernelName:hn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dims:a}=s,i=r.shape.length,o=x(a,r.shape);if(0===i)return ZE({inputs:{x:r},backend:n});const l=K().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new pO(r.shape,o):new hO(r.shape,o);return n.runWebGLProgram(l,[r],r.dtype)}};class fO{constructor(e,t){this.variableNames=["Image"],this.outputShape=[];const n=e[1],s=e[2];this.outputShape=e;let r="";r="number"==typeof t?`float outputValue = ${t.toFixed(2)};`:`\n        vec3 fill = vec3(${t.join(",")});\n        float outputValue = fill[coords[3]];`,this.userCode=`\n        uniform vec4 params;\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n          int y = coords[1];\n          float coordXFloat = (float(x) - params[0]) * params[3] -\n            (float(y) - params[1]) * params[2];\n          float coordYFloat = (float(x) - params[0]) * params[2] +\n            (float(y) - params[1]) * params[3];\n          int coordX = int(round(coordXFloat + params[0]));\n          int coordY = int(round(coordYFloat + params[1]));\n          ${r}\n          if(coordX >= 0 && coordX < ${s} && coordY >= 0 && coordY < ${n}) {\n            outputValue = getImage(coords[0], coordY, coordX, coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}getCustomSetupFunc(e,t,n,s){return(r,a)=>{null==this.paramsLoc&&(this.paramsLoc=r.getUniformLocationNoThrow(a,"params")),r.gl.uniform4f(this.paramsLoc,e,t,n,s)}}}const mO={kernelName:qn,backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,{radians:r,fillValue:a,center:i}=t,o=n,l=new fO(s.shape,a),[u,c]=Ph(i,s.shape[1],s.shape[2]),h=l.getCustomSetupFunc(u,c,Math.sin(r),Math.cos(r));return o.runWebGLProgram(l,[s],s.dtype,h)}},gO=lA({opSnippet:"\n  // OpenGL ES does not support round function.\n  // The algorithm is based on banker's rounding.\n  float base = floor(x);\n  if ((x - base) < 0.5) {\n    return floor(x);\n  } else if ((x - base) > 0.5) {\n    return ceil(x);\n  } else {\n    if (mod(base, 2.0) == 0.0) {\n      return base;\n    } else {\n      return base + 1.0;\n    }\n  }\n"}),yO={kernelName:pn,backendName:"webgl",kernelFunc:gO},bO=lA({opSnippet:"return inversesqrt(x);",cpuKernelImpl:NE}),xO={kernelName:dn,backendName:"webgl",kernelFunc:bO};class wO{constructor(e,t,n,s,r,a,i=!0){this.variableNames=["updates","indices","defaultValue"],this.outputShape=a;const o=QT(r.length),l=QT(a.length);let u="";1===n?u="i":2===n&&(u="i, j");const c=`getIndices(${u})`;let h="";1===s?h="i":2===s&&(h="i, coords[1]");const p=`getUpdates(${h})`,d=t>1?"strides[j]":"strides";this.userCode=`\n        ${o} strides = ${o}(${r});\n\n        void main() {\n          ${l} coords = getOutputCoords();\n          float sum = 0.0;\n          bool found = false;\n          for (int i = 0; i < ${e}; i++) {\n            int flattenedIndex = 0;\n            for (int j = 0; j < ${t}; j++) {\n              int index = round(${c});\n              flattenedIndex += index * ${d};\n            }\n            if (flattenedIndex == coords[0]) {\n              sum += ${p};\n              found = true;\n            }\n          }\n          setOutput(mix(getDefaultValue(), sum, float(found)));\n        }\n      `}}const kO={kernelName:fn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r,updates:a}=t,{shape:i}=s,{sliceRank:o,numUpdates:l,sliceSize:u,strides:c,outputSize:h}=Ta(0,r,i),p=[h/u,u];if(0===h)return n.makeTensorInfo(i,r.dtype);const d=bA({inputs:{x:r},backend:n,attrs:{shape:[l,o]}}),f=bA({inputs:{x:a},backend:n,attrs:{shape:[l,u]}}),m=n.makeTensorInfo([],"float32",new Float32Array([0])),g=new wO(l,o,d.shape.length,f.shape.length,c,p),y=n.runWebGLProgram(g,[f,d,m],f.dtype),b=bA({inputs:{x:y},backend:n,attrs:{shape:i}});return n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(y),n.disposeIntermediateTensorInfo(m),b}};class vO{constructor(e,t,n){let s,r;if(this.variableNames=["c","a","b"],this.outputShape=t,n>4)throw Error(`Where for rank ${n} is not yet supported`);if(1===n)r="resRC",s="resRC";else{const n=["resRC.x","resRC.y","resRC.z","resRC.w"],a=[],i=[];for(let s=0;s<t.length;s++)i.push(`${n[s]}`),s<e&&a.push(`${n[s]}`);s=a.join(),r=i.join()}const a=QT(n);this.userCode=`\n      void main() {\n        ${a} resRC = getOutputCoords();\n        float cVal = getC(${s});\n        if (cVal >= 1.0) {\n          setOutput(getA(${r}));\n        } else {\n          setOutput(getB(${r}));\n        }\n      }\n    `}}const NO={kernelName:mn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{condition:s,t:r,e:a}=t,i=new vO(s.shape.length,r.shape,r.shape.length);return n.runWebGLProgram(i,[s,r,a],Ds(r.dtype,a.dtype))}},IO=lA({opSnippet:`\n  // Stable and Attracting Fixed Point (0, 1) for Normalized Weights.\n  // see: https://arxiv.org/abs/1706.02515\n  float scaleAlpha = 1.7580993408473768;\n  float scale = ${qh};\n  return (x >= 0.0) ? scale * x : scaleAlpha * (exp(x) - 1.0);\n`}),$O={kernelName:gn,backendName:"webgl",kernelFunc:IO},CO=lA({opSnippet:"return 1.0 / (1.0 + exp(-1.0 * x));"}),SO={kernelName:kn,backendName:"webgl",kernelFunc:CO},TO=lA({opSnippet:"\n  if (isnan(x)) { return 0.0; }\n  return sign(x);\n"}),EO={kernelName:wn,backendName:"webgl",kernelFunc:TO},AO=lA({opSnippet:"if (isnan(x)) return x;\n  return sin(x);\n"}),RO={kernelName:bn,backendName:"webgl",kernelFunc:AO},FO=lA({opSnippet:"\n  float e2x = exp(x);\n  return (e2x - 1.0 / e2x) / 2.0;\n"}),DO={kernelName:xn,backendName:"webgl",kernelFunc:FO},_O=lA({opSnippet:"\n  float epsilon = 1.1920928955078125e-7;\n  float threshold = log(epsilon) + 2.0;\n\n  bool too_large = x > -threshold;\n  bool too_small = x < threshold;\n\n  float result;\n  float exp_x = exp(x);\n\n  if (too_large){\n    result = x;\n  }\n  else if (too_small){\n    result = exp_x;\n  }\n  else{\n    result = log(exp_x + 1.0);\n  }\n  return result;\n"}),OO={kernelName:vn,backendName:"webgl",kernelFunc:_O},MO={kernelName:$n,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,paddings:i}=s;l(r.shape.length<=4,(()=>"spaceToBatchND for rank > 4 with a WebGL backend not implemented yet"));const o=a.reduce(((e,t)=>e*t)),u=[[0,0]];u.push(...i);for(let e=1+a.length;e<r.shape.length;++e)u.push([0,0]);const c=[],h=V_({inputs:{x:r},backend:n,attrs:{paddings:u,constantValue:0}}),p=Wh(h.shape,a,o,!1),d=Vh(p.length,a.length,!1),f=Uh(h.shape,a,o,!1),m=bA({inputs:{x:h},backend:n,attrs:{shape:p}}),g=TA({inputs:{x:m},backend:n,attrs:{perm:d}}),y=bA({inputs:{x:g},backend:n,attrs:{shape:f}});return c.push(h),c.push(m),c.push(g),c.forEach((e=>n.disposeIntermediateTensorInfo(e))),y}};const LO={kernelName:Tn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{indices:s,values:r,denseShape:a,defaultValue:i}=t;if(1!==a.shape.length)throw new Error(`Dense shape must be a vector, saw:\n         ${a.shape}`);if(2!==s.shape.length)throw new Error(`Indices must be a matrix, saw:\n         ${s.shape}`);if(1!==r.shape.length)throw new Error(`Values must be a vector, saw:\n         ${r.shape}`);if(0!==i.shape.length)throw new Error(`Default value must be a scalar, saw:\n        ${i.shape}`);const o=n.readSync(s.dataId),l=n.readSync(r.dataId),u=n.readSync(a.dataId),c=n.readSync(i.dataId)[0],[h,p,d,f,m]=CE(o,s.shape,s.dtype,l,r.dtype,u,c);return[n.makeTensorInfo(p,s.dtype,h),n.makeTensorInfo([p[0]],r.dtype,d),n.makeTensorInfo([f.length],"bool",new Uint8Array(f.map((e=>Number(e))))),n.makeTensorInfo([m.length],s.dtype,new Int32Array(m))]}};const zO={kernelName:En,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{inputIndices:s,inputShape:r,newShape:a}=t;if(2!==s.shape.length)throw new Error(`Input indices should be a matrix but received shape ${s.shape}`);if(1!==r.shape.length)throw new Error(`Input shape should be a vector but received shape ${r.shape}`);if(1!==a.shape.length)throw new Error(`Target shape should be a vector but received shape ${a.shape}`);const i=Array.from(n.readSync(r.dataId)),o=n.readSync(s.dataId),l=Array.from(n.readSync(a.dataId)),[u,c,h]=SE(o,s.shape,s.dtype,i,l);return[n.makeTensorInfo(c,s.dtype,u),n.makeTensorInfo([h.length],a.dtype,new Int32Array(h))]}};const BO={kernelName:An,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{sparseIndices:r,sparseValues:a,defaultValue:i}=t,{outputShape:o}=s,{sliceRank:l,numUpdates:u,strides:c,outputSize:h}=Ta(0,r,o),p=new wO(u,l,r.shape.length,a.shape.length,c,[h,1],!1),d=n.runWebGLProgram(p,[a,r,i],a.dtype),f=bA({inputs:{x:d},backend:n,attrs:{shape:o}});return n.disposeIntermediateTensorInfo(d),f}};const PO={kernelName:Cn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{numOrSizeSplits:a,axis:i}=s,o=x(i,r.shape)[0],l=yp(r,a,o),u=r.shape.length,c=new Array(u).fill(0),h=r.shape.slice();return l.map((e=>{const t=[...h];t[o]=e;const s=IR({inputs:{x:r},backend:n,attrs:{begin:c,size:t}});return c[o]+=e,s}))}},WO=lA({opSnippet:"return sqrt(x);"}),VO={kernelName:Nn,backendName:"webgl",kernelFunc:WO},UO={kernelName:Fn,backendName:"webgl",kernelFunc:lA({opSnippet:"return x * x;"})},GO="return (a - b) * (a - b);",HO=uA({opSnippet:GO,packedOpSnippet:GO}),jO={kernelName:Rn,backendName:"webgl",kernelFunc:HO};const qO={kernelName:Hn,backendName:"webgl",kernelFunc:function({inputs:e,attrs:t,backend:n}){const{x:s}=e,r=`if (isnan(x)) return x;\n    return x > 0.0 ? 1.0 : float(${t.alpha});\n  `,a=new VE(s.shape,r);return n.runWebGLProgram(a,[s],s.dtype)}};class KO{constructor(e,t,n){this.variableNames=["x"],this.outputShape=n;const s=n.length,r=QT(n.length),a=QT(n.length);let i="";if(1===s)i="coords * strides + begin";else{let e=0;i=n.map(((t,s)=>(e++,1===n.length?`coords * strides[${s}] + begin[${s}]`:`coords[${e-1}] * strides[${s}] + begin[${s}]`))).join(",")}this.userCode=`\n      ${r} begin = ${r}(${e});\n      ${r} strides = ${r}(${t});\n\n      void main() {\n        ${a} coords = getOutputCoords();\n        setOutput(getX(${i}));\n      }\n    `}}const XO={kernelName:Dn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,end:i,strides:o,beginMask:l,endMask:u,ellipsisMask:c,newAxisMask:h,shrinkAxisMask:p}=s,{nonStrided:d,$begin:f,$strides:m,size:g,newShape:y,outShape:b}=Ha(r.shape,a,i,o,l,u,c,h,p),x=bA({inputs:{x:r},backend:n,attrs:{shape:y}});let w;if(d){const e=IR({inputs:{x:x},backend:n,attrs:{begin:f,size:g}});w=bA({inputs:{x:e},backend:n,attrs:{shape:b}}),n.disposeIntermediateTensorInfo(e)}else if(b.some((e=>0===e)))w=n.makeTensorInfo(b,r.dtype,[]);else{if(n.shouldExecuteOnCPU([x])){const e=n.texData.get(x.dataId).values,t=Kr(x.shape,x.dtype,e),s=TE(b,t,m,f);w=n.makeTensorInfo(b,x.dtype,s.values)}else{const e=new KO(f,m,b);w=n.runWebGLProgram(e,[x],x.dtype)}}const k=bA({inputs:{x:w},backend:n,attrs:{shape:b}});return n.disposeIntermediateTensorInfo(x),n.disposeIntermediateTensorInfo(w),k}},YO=lA({opSnippet:"return tan(x);"}),JO={kernelName:On,backendName:"webgl",kernelFunc:YO},ZO=lA({opSnippet:"\n  float e2x = exp(-2.0 * abs(x));\n  return sign(x) * (1.0 - e2x) / (1.0 + e2x);\n"}),QO={kernelName:Mn,backendName:"webgl",kernelFunc:ZO};class eM{constructor(e,t){this.variableNames=["A"];const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[s]*t[s];this.outputShape=n,this.rank=n.length;const s=QT(this.rank),r=function(e){const t=e.length;if(t>5)throw Error(`Tile for rank ${t} is not yet supported`);if(1===t)return`imod(resRC, ${e[0]})`;const n=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u"],s=[];for(let t=0;t<e.length;t++)s.push(`imod(${n[t]}, ${e[t]})`);return s.join()}(e);this.userCode=`\n      void main() {\n        ${s} resRC = getOutputCoords();\n        setOutput(getA(${r}));\n      }\n    `}}function tM(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reps:a}=s;if("string"===r.dtype||r.shape.length>5){const e=n.readSync(r.dataId),t="string"===r.dtype?e.map((e=>cs(e))):e,s=Kr(r.shape,r.dtype,t),i=AE(s,a);return n.makeTensorInfo(i.shape,i.dtype,i.values)}const i=new eM(r.shape,a);return n.runWebGLProgram(i,[r],r.dtype)}const nM={kernelName:Ln,backendName:"webgl",kernelFunc:tM};const sM={kernelName:zn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{k:a,sorted:i}=s,o=n.readSync(r.dataId),[l,u]=RE(o,r.shape,r.dtype,a,i);return[n.makeTensorInfo(l.shape,l.dtype,l.values),n.makeTensorInfo(u.shape,u.dtype,u.values)]}};class rM{constructor(e,t,n,s,r,a){this.variableNames=["Image","Transforms"],this.outputShape=a;const i="nearest"===n?1:2;let o;switch(s){case"constant":o=1;break;case"reflect":o=2;break;case"wrap":o=3;break;case"nearest":o=4;break;default:o=1}this.userCode=`\n            float mapCoord(float outCoord, float len) {\n              float inCoord = outCoord;\n              if(${o} == 2) {\n                if (inCoord < 0.0) {\n                  if (len <= 1.0) {\n                    inCoord = 0.0;\n                  } else {\n                    float sz2 = 2.0 * len;\n                    if (inCoord < sz2) {\n                      inCoord = sz2 * float(int(float(-inCoord / sz2))) +\n                      inCoord;\n                    }\n                    inCoord = inCoord < -len ? inCoord + sz2 : -inCoord - 1.0;\n                  }\n                } else if (inCoord > len - 1.0) {\n                  if (len <= 1.0) {\n                    inCoord = 0.0;\n                  } else {\n                    float sz2 = 2.0 * len;\n                    inCoord -= sz2 * float(int(float(inCoord / sz2)));\n                    if (inCoord >= len) {\n                      inCoord = sz2 - inCoord - 1.0;\n                    }\n                  }\n                }\n                return clamp(inCoord, 0.0, len - 1.0);\n              } else if (${o} == 3) {\n                if (inCoord < 0.0) {\n                  if (len <= 1.0) {\n                    inCoord = 0.0;\n                  } else {\n                    float sz = len - 1.0;\n                    inCoord += len * (float(int(float(-inCoord / sz))) + 1.0);\n                  }\n                } else if (inCoord > len - 1.0) {\n                  if (len <= 1.0) {\n                    inCoord = 0.0;\n                  } else {\n                    float sz = len - 1.0;\n                    inCoord -= len * float(int(float(inCoord / sz)));\n                  }\n                }\n                return clamp(inCoord, 0.0, len - 1.0);\n              } else if (${o} == 4) {\n                return clamp(outCoord, 0.0, len - 1.0);\n              } else {\n                return outCoord;\n              }\n            }\n\n            float readWithFillValue(int batch, int coordY, int coordX,\n              int channel) {\n              float outputValue;\n              if (0 <= coordY && coordY < ${e} && 0 <= coordX && coordX < ${t}) {\n                  outputValue = getImage(batch, coordY, coordX, channel);\n              } else {\n                outputValue = float(${r});\n              }\n              return outputValue;\n            }\n\n            void main() {\n              ivec4 coords = getOutputCoords();\n              float outputValue;\n              int batch = coords[0];\n              int x = coords[2];\n              int y = coords[1];\n              int channel = coords[3];\n              float xf = float(x);\n              float yf = float(y);\n              float a1 = getTransforms(batch, 0);\n              float a2 = getTransforms(batch, 1);\n              float a3 = getTransforms(batch, 2);\n              float b1 = getTransforms(batch, 3);\n              float b2 = getTransforms(batch, 4);\n              float b3 = getTransforms(batch, 5);\n              float c1 = getTransforms(batch, 6);\n              float c2 = getTransforms(batch, 7);\n              float projection = c1 * xf + c2 * yf + 1.0;\n              if (projection == 0.0) {\n                outputValue = float(${r});\n              } else {\n                float inX = (a1 * xf + a2 * yf + a3) / projection;\n                float inY = (b1 * xf + b2 * yf + b3) / projection;\n                float mapX = mapCoord(inX, float(${t}));\n                float mapY = mapCoord(inY, float(${e}));\n\n                if (${i} == 1) {\n                  int coordY = int(round(mapY));\n                  int coordX = int(round(mapX));\n                  outputValue = readWithFillValue(batch, coordY, coordX,\n                    channel);\n                } else {\n                  float yFloor = floor(mapY);\n                  float xFloor = floor(mapX);\n                  float yCeil = yFloor + 1.0;\n                  float xCeil = xFloor + 1.0;\n                  float valueYFloor = (xCeil - mapX) *\n                  readWithFillValue(batch, int(yFloor), int(xFloor), channel) +\n                  (mapX - xFloor) *\n                  readWithFillValue(batch, int(yFloor), int(xCeil), channel);\n                  float valueYCeil = (xCeil - mapX) *\n                  readWithFillValue(batch, int(yCeil), int(xFloor), channel) +\n                  (mapX - xFloor) *\n                  readWithFillValue(batch, int(yCeil), int(xCeil), channel);\n                  outputValue = (yCeil - mapY) * valueYFloor +\n                  (mapY - yFloor) * valueYCeil;\n                }\n              }\n              setOutput(outputValue);\n            }\n        `}}const aM={kernelName:Bn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{image:r,transforms:a}=t,{interpolation:i,fillMode:o,fillValue:l,outputShape:u}=s,[c,h,p,d]=r.shape,[f,m]=null!=u?u:[h,p],g=new rM(h,p,i,o,l,[c,f,m,d]);return n.runWebGLProgram(g,[r,a],"float32")}};const iM={kernelName:Wn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{axis:r}=n,{x:a}=t;xT(a,"unique"),console.warn("WARNING: ","UI might be locked temporarily as data is being downloaded");const i=s.readSync(a.dataId),{outputValues:o,outputShape:l,indices:u}=DE(i,r,a.shape,a.dtype);return[s.makeTensorInfo(l,a.dtype,o),s.makeTensorInfo([u.length],"int32",u)]}};const oM={kernelName:Vn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{value:r}=t;let{axis:a}=s;a<0&&(a+=r.shape.length);const i=r,o=i.shape.length,l=r.shape[a],u=new Array(o-1);let c=0;for(let e=0;e<o;e++)e!==a&&(u[c++]=i.shape[e]);const h=[],p=new Array(o).fill(0),d=i.shape.slice();d[a]=1;const f=new Array(l);for(let e=0;e<f.length;e++){p[a]=e;const t=IR({inputs:{x:i},backend:n,attrs:{begin:p,size:d}}),s=bA({inputs:{x:t},backend:n,attrs:{shape:u}});f[e]=s,h.push(t)}return h.forEach((e=>n.disposeIntermediateTensorInfo(e))),f}};class lM{constructor(e,t){this.variableNames=["x","segmentIds"];const n=e.windowSize,s=e.batchSize,r=e.inSize,a=e.numSegments,i=a*Math.ceil(r/n);this.outputShape=[s,i];const o=4*Math.floor(n/4),l=n%4,u="\n        sumValue += dot(values, segFilter);\n    ";let c="";r%n>0&&(c=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return initializationValue;\n        }\n      `);let h="";r%n>0&&(h=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return -1.0;\n        }\n      `),this.userCode=`\n      const float initializationValue = 0.0;\n\n      float getValue(int batch, int inIdx) {\n        ${c}\n        return getX(batch, inIdx);\n      }\n\n      float getSegmentIdAtIndex(int inIdx) {\n        ${h}\n        return getSegmentIds(inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = int(floor(float(outIdx) / float(\n          ${a})) * float(${n}));\n        int currentSeg = int(mod(float(outIdx), float(${a})));\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${o}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 3)) == currentSeg ? 1 : 0\n          );\n\n          ${u}\n        }\n\n        int inIdx = inOffset + ${o};\n        if (${1===l}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          int inIdxSeg = int(getSegmentIdAtIndex(inIdx));\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            0,\n            0,\n            0\n          );\n\n          ${u}\n        } else if (${2===l}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n              0,\n              0\n          );\n\n          ${u}\n        } else if (${3===l}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            0\n          );\n\n          ${u}\n        }\n        setOutput(sumValue);\n      }\n    `}}const uM=[KD,YD,RA,DA,OA,LA,PA,UA,GA,HA,JA,ZA,eR,nR,iR,rR,lR,pR,hR,mR,gR,yR,wR,CR,SR,FR,OR,zR,WR,tA,XR,iF,oF,tF,uF,cF,lF,pF,fF,gF,wF,kF,NF,EF,AF,CF,FF,_F,OF,LF,zF,PF,VF,HF,qF,YF,QF,nD,rD,oD,uD,pD,fD,mD,yD,xD,kD,ND,QE,ID,jR,CD,TD,AD,rA,FD,_D,OD,BD,LD,WD,UD,HD,ZD,n_,t_,a_,i_,o_,e_,l_,u_,h_,f_,g_,$_,yA,S_,E_,R_,D_,ER,O_,z_,B_,U_,H_,oA,j_,K_,RR,x_,Y_,eO,Z_,xA,sO,aO,lO,cO,dO,mO,yO,xO,kO,NO,$O,SO,EO,RO,DO,$R,I_,OO,MO,LO,zO,BO,PO,VO,UO,jO,qO,XO,v_,SA,JO,QO,nM,sM,aM,EA,iM,oM,{kernelName:Un,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,segmentIds:a}=t,{numSegments:i}=s,o=r.shape.length,l=[];let u=0;const c=bl([u],o);let h=r;null!=c&&(h=TA({inputs:{x:r},backend:n,attrs:{perm:c}}),l.push(h),u=wl(1,o)[0]);const d=xp(h.shape,u,i),f=p([h.shape[u]]),m=bA({inputs:{x:h},backend:n,attrs:{shape:[-1,f]}});l.push(m);const g=_s(r.dtype),y=(e,t,s,r,a)=>{const i=e.shape[0],o=e.shape[1],u=bp(o,a),c=new lM({windowSize:u,inSize:o,batchSize:i,numSegments:a},t),h=n.compileAndRun(c,[e,s],r);if(l.push(h),h.shape[1]===a)return h;const p=q_({backend:n,attrs:{start:0,stop:a,step:1,dtype:"float32"}}),d=tM({inputs:{x:p},backend:n,attrs:{reps:[o/u]}});l.push(p),l.push(d);return y(h,t,d,r,a)},b=bA({inputs:{x:y(m,"unsortedSegmentSum",a,g,i)},backend:n,attrs:{shape:d}});let x=b;if(null!=c){l.push(b);const e=xl(c);x=TA({inputs:{x:x},backend:n,attrs:{perm:e}})}return l.forEach((e=>n.disposeIntermediateTensorInfo(e))),x}},L_];for(const e of uM)ns(e);const cM={"tfjs-core":ni,"tfjs-backend-cpu":"3.6.0","tfjs-backend-webgl":"3.6.0","tfjs-data":iv,"tfjs-layers":Pg,"tfjs-converter":sk,tfjs:"3.6.0"};e.Abs=Z,e.Acos=Q,e.Acosh=ee,e.AdadeltaOptimizer=Ch,e.AdagradOptimizer=Sh,e.AdamOptimizer=Th,e.AdamaxOptimizer=Eh,e.Add=te,e.AddN=ne,e.All=se,e.Any=re,e.ArgMax=ae,e.ArgMin=ie,e.Asin=oe,e.Asinh=le,e.Atan=ue,e.Atan2=he,e.Atanh=ce,e.AvgPool=pe,e.AvgPool3D=fe,e.AvgPool3DGrad=me,e.AvgPoolGrad=de,e.BatchMatMul=ge,e.BatchToSpaceND=ye,e.Bincount=be,e.BroadcastTo=xe,e.Callback=Px,e.CallbackList=Zm,e.Cast=we,e.Ceil=ke,e.ClipByValue=ve,e.Complex=Ne,e.ComplexAbs=Ie,e.Concat=$e,e.Conv2D=Ce,e.Conv2DBackpropFilter=Se,e.Conv2DBackpropInput=Te,e.Conv3D=Ee,e.Conv3DBackpropFilterV2=Ae,e.Conv3DBackpropInputV2=Re,e.Cos=Fe,e.Cosh=De,e.CropAndResize=Oe,e.Cumsum=_e,e.CustomCallback=tg,e.DataStorage=t,e.DenseBincount=Me,e.DepthToSpace=Le,e.DepthwiseConv2dNative=ze,e.DepthwiseConv2dNativeBackpropFilter=Be,e.DepthwiseConv2dNativeBackpropInput=Pe,e.Diag=We,e.Dilation2D=Ve,e.Dilation2DBackpropFilter=Ge,e.Dilation2DBackpropInput=Ue,e.EarlyStopping=Ux,e.Einsum=je,e.Elu=qe,e.EluGrad=Ke,e.Environment=j,e.Equal=Ye,e.Erf=Xe,e.Exp=Je,e.ExpandDims=Ze,e.Expm1=Qe,e.FFT=et,e.Fill=tt,e.FlipLeftRight=nt,e.Floor=st,e.FloorDiv=rt,e.FromPixels=jn,e.FusedBatchNorm=at,e.FusedConv2D=Xn,e.FusedDepthwiseConv2D=Yn,e.GatherNd=ot,e.GatherV2=it,e.GraphModel=nk,e.Greater=lt,e.GreaterEqual=ut,e.History=eg,e.IFFT=ht,e.Identity=ct,e.Imag=pt,e.InputSpec=Bm,e.IsFinite=dt,e.IsInf=ft,e.IsNan=mt,e.KernelBackend=n,e.LRN=Ct,e.LRNGrad=St,e.LayerVariable=Mm,e.LayersModel=fy,e.LeakyRelu=gt,e.Less=yt,e.LessEqual=bt,e.LinSpace=xt,e.Log=wt,e.Log1p=kt,e.LogSoftmax=$t,e.LogicalAnd=vt,e.LogicalNot=Nt,e.LogicalOr=It,e.Max=Tt,e.MaxPool=At,e.MaxPool3D=Ft,e.MaxPool3DGrad=Dt,e.MaxPoolGrad=Rt,e.MaxPoolWithArgmax=_t,e.Maximum=Et,e.Mean=Ot,e.Min=Mt,e.Minimum=Lt,e.MirrorPad=zt,e.Mod=Bt,e.MomentumOptimizer=Rh,e.Multinomial=Pt,e.Multiply=Wt,e.Neg=Vt,e.NonMaxSuppressionV3=Gt,e.NonMaxSuppressionV4=Ht,e.NonMaxSuppressionV5=jt,e.NotEqual=Ut,e.OP_SCOPE_SUFFIX=nr,e.OneHot=Kt,e.OnesLike=qt,e.Optimizer=$h,e.Pack=Xt,e.PadV2=Yt,e.Pool="Pool",e.Pow=Jt,e.Prelu=Zt,e.Prod=Qt,e.RMSPropOptimizer=Fh,e.RNN=bb,e.Range=en,e.Real=tn,e.RealDiv=He,e.Reciprocal=nn,e.Relu=sn,e.Relu6=cn,e.Reshape=rn,e.ResizeBilinear=ln,e.ResizeBilinearGrad=un,e.ResizeNearestNeighbor=an,e.ResizeNearestNeighborGrad=on,e.Reverse=hn,e.RotateWithOffset=qn,e.Round=pn,e.Rsqrt=dn,e.SGDOptimizer=Ah,e.ScatterNd=fn,e.Select=mn,e.Selu=gn,e.Sequential=yy,e.Sigmoid=kn,e.Sign=wn,e.Sin=bn,e.Sinh=xn,e.Slice=yn,e.Softmax=Sn,e.Softplus=vn,e.SpaceToBatchND=$n,e.SparseFillEmptyRows=Tn,e.SparseReshape=En,e.SparseToDense=An,e.SplitV=Cn,e.Sqrt=Nn,e.Square=Fn,e.SquaredDifference=Rn,e.Step=Hn,e.StridedSlice=Dn,e.Sub=_n,e.Sum=In,e.SymbolicTensor=Pm,e.Tan=On,e.Tanh=Mn,e.Tensor=Is,e.TensorBuffer=ws,e.Tile=Ln,e.TopK=zn,e.Transform=Bn,e.Transpose=Pn,e.Unique=Wn,e.Unpack=Vn,e.UnsortedSegmentSum=Un,e.Variable=Cs,e.ZerosLike=Gn,e._FusedMatMul=Kn,e.abs=gi,e.acos=yi,e.acosh=bi,e.add=pi,e.addN=xi,e.all=wi,e.any=ki,e.argMax=vi,e.argMin=Ni,e.asin=Ii,e.asinh=$i,e.atan=Ci,e.atan2=Si,e.atanh=Ti,e.avgPool=Ui,e.avgPool3d=Gi,e.backend=hi,e.backend_util=Ip,e.basicLSTMCell=Xi,e.batchNorm=Ji,e.batchNorm2d=Zi,e.batchNorm3d=Qi,e.batchNorm4d=eo,e.batchToSpaceND=Yi,e.bincount=to,e.booleanMaskAsync=lc,e.broadcastTo=no,e.browser=Na,e.buffer=Kr,e.callbacks=Gx,e.cast=Xr,e.ceil=so,e.clipByValue=ro,e.clone=Yr,e.complex=rr,e.concat=Hi,e.concat1d=ao,e.concat2d=io,e.concat3d=oo,e.concat4d=lo,e.constraints=wf,e.conv1d=co,e.conv2d=uo,e.conv2dTranspose=po,e.conv3d=fo,e.conv3dTranspose=go,e.copyRegisteredKernels=function(e,t){ts(e).forEach((e=>{ns(Object.assign({},e,{backendName:t}))}))},e.cos=yo,e.cosh=bo,e.cosineWindow=yc,e.cumsum=xo,e.customGrad=rl,e.data=ov,e.denseBincount=wo,e.deprecationWarn=si,e.depthToSpace=ko,e.depthwiseConv2d=vo,e.deregisterOp=function(e){delete qx[e]},e.device_util=Xs,e.diag=No,e.dilation2d=Io,e.disableDeprecationWarnings=function(){K().set("DEPRECATION_WARNINGS_ENABLED",!1),console.warn("TensorFlow.js deprecation warnings have been disabled.")},e.dispose=oi,e.disposeVariables=function(){Hs.disposeVariables()},e.div=fi,e.divNoNan=Ro,e.dot=Fo,e.dropout=mc,e.einsum=Do,e.elu=_o,e.enableDebugMode=function(){K().set("DEBUG",!0)},e.enableProdMode=function(){K().set("PROD",!0)},e.enclosingPowerOfTwo=gc,e.engine=ri,e.env=K,e.equal=To,e.erf=Oo,e.exp=Mo,e.expandDims=Lo,e.expm1=zo,e.eye=Po,e.fft=Pu,e.fill=Wo,e.findBackend=function(e){return Hs.findBackend(e)},e.findBackendFactory=function(e){return Hs.findBackendFactory(e)},e.floor=Vo,e.floorDiv=di,e.fused=Ec,e.gather=Uo,e.gatherND=fc,e.gather_util=$a,e.getBackend=function(){return Hs.backendName},e.getGradient=es,e.getKernel=Qn,e.getKernelsForBackend=ts,e.grad=function(e){return l(D(e),(()=>"The f passed in grad(f) must be a function")),(t,n)=>{const s=er(t,"x","tf.grad","string_or_numeric"),r=null!=n?er(n,"dy","tf.grad"):null;return Hs.tidy((()=>{const{value:t,grads:n}=Hs.gradients((()=>e(s)),[s],r);return null!=r&&u(t.shape,r.shape,"The shape of dy passed in grad(f)(x, dy) must match the shape returned by f(x)"),al(n),n[0]}))}},e.grads=function(e){return l(D(e),(()=>"The f passed in grads(f) must be a function")),(t,n)=>{l(Array.isArray(t),(()=>"The args passed in grads(f)(args) must be an array of `Tensor`s or `TensorLike`s"));const s=tr(t,"args","tf.grads","string_or_numeric"),r=null!=n?er(n,"dy","tf.grads"):null;return Hs.tidy((()=>{const{value:t,grads:n}=Hs.gradients((()=>e(...s)),s,r);return null!=r&&u(t.shape,r.shape,"The shape of dy passed in grads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),al(n),n}))}},e.greater=Go,e.greaterEqual=Ho,e.ifft=Wu,e.imag=jo,e.image=kh,e.inTopKAsync=bc,e.initializers=$m,e.input=by,e.io=pa,e.irfft=Vu,e.isFinite=qo,e.isInf=Ko,e.isNaN=Xo,e.keep=li,e.kernel_impls=$p,e.layers=Mx,e.leakyRelu=Yo,e.less=Jo,e.lessEqual=Zo,e.linalg=vh,e.linspace=Qo,e.loadGraphModel=async function(e,t={}){if(null==e)throw new Error("modelUrl in loadGraphModel() cannot be null. Please provide a url or an IOHandler that loads the model");null==t&&(t={}),t.fromTFHub&&null==e.load&&(e.endsWith("/")||(e+="/"),e=`${e}model.json?tfjs-format=file`);const n=new nk(e,t);return await n.load(),n},e.loadLayersModel=function(e,t){return null==t&&(t={}),gy(e,t)},e.localResponseNormalization=el,e.log=tl,e.log1p=nl,e.logSigmoid=ll,e.logSoftmax=pl,e.logSumExp=kl,e.logicalAnd=vl,e.logicalNot=Nl,e.logicalOr=Il,e.logicalXor=$l,e.losses=Nh,e.matMul=da,e.math=ya,e.max=ul,e.maxPool=Cl,e.maxPool3d=Sl,e.maxPoolWithArgmax=Tl,e.maximum=El,e.mean=Al,e.memory=ai,e.meshgrid=function(e,t,{indexing:n="xy"}={}){if("xy"!==n&&"ij"!==n)throw new TypeError(`${n} is not a valid third argument to meshgrid`);if(void 0===e)return[];let s=er(e,"x","meshgrid",e instanceof Is?e.dtype:"float32");if(void 0===t)return[s];let r=er(t,"y","meshgrid",t instanceof Is?t.dtype:"float32");const a=p(s.shape),i=p(r.shape);return"xy"===n?(s=Vi(s,[1,-1]),r=Vi(r,[-1,1]),[da(Fl([i,1],s.dtype),s),da(r,Fl([1,a],r.dtype))]):(s=Vi(s,[-1,1]),r=Vi(r,[1,-1]),[da(s,Fl([1,i],s.dtype)),da(Fl([a,1],r.dtype),r)])},e.metrics=Lx,e.min=Dl,e.minimum=_l,e.mirrorPad=Ol,e.mod=Ml,e.model=function(e){return new fy(e)},e.models=zx,e.moments=zl,e.movingAverage=hc,e.mul=mi,e.multiRNNCell=Bl,e.multinomial=Pl,e.neg=il,e.nextFrame=Mh,e.norm=cc,e.notEqual=Wl,e.oneHot=fa,e.ones=Fl,e.onesLike=Vl,e.op=sr,e.outerProduct=Ul,e.pad=Gl,e.pad1d=Hl,e.pad2d=jl,e.pad3d=ql,e.pad4d=Kl,e.pool=Yl,e.pow=Jl,e.prelu=Zl,e.print=Jr,e.prod=Ql,e.profile=function(e){return Hs.profile(e)},e.rand=eu,e.randomGamma=du,e.randomNormal=fu,e.randomUniform=mu,e.range=gu,e.ready=function(){return Hs.ready()},e.real=yu,e.reciprocal=bu,e.registerBackend=ci,e.registerCallbackConstructor=function(e,t){sg.registerCallbackConstructor(e,t)},e.registerGradient=ss,e.registerKernel=ns,e.registerOp=function(e,t){const n={tfOpName:e,category:"custom",inputs:[],attrs:[],customExecutor:t};qx[e]=n},e.regularizers=Bx,e.relu=xu,e.relu6=wu,e.removeBackend=function(e){Hs.removeBackend(e)},e.reshape=Vi,e.reverse=ku,e.reverse1d=vu,e.reverse2d=Nu,e.reverse3d=Iu,e.reverse4d=$u,e.rfft=Gu,e.round=Cu,e.rsqrt=Su,e.scalar=Tu,e.scatterND=pc,e.scatter_util=Ea,e.selu=Eu,e.separableConv2d=Au,e.sequential=function(e){return new yy(e)},e.serialization=Ya,e.setBackend=ui,e.setPlatform=function(e,t){K().setPlatform(e,t)},e.setdiff1dAsync=Ru,e.sigmoid=ji,e.sign=Fu,e.signal=wh,e.sin=Du,e.sinh=_u,e.slice=qi,e.slice1d=Ou,e.slice2d=Mu,e.slice3d=Lu,e.slice4d=zu,e.slice_util=ja,e.softmax=Bu,e.softplus=ol,e.spaceToBatchND=Xl,e.sparse=Ih,e.sparseToDense=dc,e.spectral=xh,e.split=Uu,e.sqrt=Hu,e.square=Ll,e.squaredDifference=ju,e.squeeze=qu,e.stack=Ku,e.step=Xu,e.stridedSlice=Yu,e.sub=cl,e.sum=hl,e.sumOutType=_s,e.tan=Ju,e.tanh=Ki,e.tensor=ir,e.tensor1d=Zu,e.tensor2d=Qu,e.tensor3d=ba,e.tensor4d=function(e,t,n){if(c(e),null!=t&&4!==t.length)throw new Error("tensor4d() requires shape to have four numbers");const s=Js(e,n);if(4!==s.length&&1!==s.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return ar(e,t,s,n)},e.tensor5d=function(e,t,n){if(c(e),null!=t&&5!==t.length)throw new Error("tensor5d() requires shape to have five numbers");const s=Js(e,n);if(5!==s.length&&1!==s.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return ar(e,t,s,n)},e.tensor6d=function(e,t,n){if(c(e),null!=t&&6!==t.length)throw new Error("tensor6d() requires shape to have six numbers");const s=Js(e,n);if(6!==s.length&&1!==s.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return ar(e,t=t||s,s,n)},e.tensor_util=Ps,e.test_util=ti,e.tidy=ii,e.tile=Bo,e.time=function(e){return Hs.time(e)},e.topk=ec,e.train=_h,e.transpose=ma,e.truncatedNormal=tc,e.unique=nc,e.unregisterGradient=function(e){if(!Zn.has(e))throw new Error(`The gradient '${e}' for backend is not registered`);Zn.delete(e)},e.unregisterKernel=function(e,t){const n=rs(e,t);if(!Jn.has(n))throw new Error(`The kernel '${e}' for backend '${t}' is not registered`);Jn.delete(n)},e.unsortedSegmentSum=sc,e.unstack=rc,e.upcastType=Ds,e.util=hs,e.valueAndGrad=function(e){return l(D(e),(()=>"The f passed in valueAndGrad(f) must be a function")),(t,n)=>{l(t instanceof Is,(()=>"The x passed in valueAndGrad(f)(x) must be a tensor")),l(null==n||n instanceof Is,(()=>"The dy passed in valueAndGrad(f)(x, dy) must be a tensor"));const{grads:s,value:r}=Hs.gradients((()=>e(t)),[t],n);return al(s),{grad:s[0],value:r}}},e.valueAndGrads=function(e){return l(D(e),(()=>"The f passed in valueAndGrads(f) must be a function")),(t,n)=>{l(Array.isArray(t)&&t.every((e=>e instanceof Is)),(()=>"The args passed in valueAndGrads(f)(args) must be array of tensors")),l(null==n||n instanceof Is,(()=>"The dy passed in valueAndGrads(f)(args, dy) must be a tensor"));const s=Hs.gradients((()=>e(...t)),t,n);return null!=n&&u(s.value.shape,n.shape,"The shape of dy passed in valueAndGrads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),al(s.grads),s}},e.variable=ac,e.variableGrads=sl,e.version=cM,e.version_converter=sk,e.version_core=ni,e.version_layers=Pg,e.where=Eo,e.whereAsync=oc,e.zeros=Rl,e.zerosLike=Ao,Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf.es2017.min.js.map
