(function (root, factory) {

  if(typeof module === 'object' && typeof module.exports === 'object') {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like enviroments that support module.exports,
    // like Node.
    exports = module.exports = factory();
  }else if(typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(factory);
  } else {
    root.GeoJSON = factory();
  }

  if(typeof jasmine === "object") {
    root.GeoJSON = factory();
  }

}(this, function(){
  var exports = {
    points : [
      {
        "type": "Point",
        "coordinates": [112, 0]
      },
      {
        "type": "Point",
        "coordinates": [-105.01621,39.57422]
      },
      {
        "type": "Point",
        "coordinates": [100, 0]
      }
    ],
    multiPoints : [
      {
        "type": "MultiPoint",
        "coordinates": [ [100, 0],[45, -122] ]
      },
      {
        "type": "MultiPoint",
        "coordinates": [ [-105.01621,39.57422],[-80.6665134,35.0539943] ]
      }
    ],
    lineStrings : [
      {
        "type": "LineString",
        "coordinates": [ [100, 0],[45, -122], [-60, 45] ]
      },
      {
        "type": "LineString",
        "coordinates": [ [-100, 40], [-105, 45], [-110, 55] ]
      },
      {
        "type": "LineString",
        "coordinates": [ [-105, 40], [-110, 45], [-115, 55] ]
      },
      {
        "type": "LineString",
        "coordinates": [ [-101.744384765625,39.32155002466662],[-101.5521240234375,39.330048552942415],[-101.40380859375,39.330048552942415],[-101.33239746093749,39.364032338047984],[-101.041259765625,39.36827914916011],[-100.975341796875,39.30454987014581],[-100.9149169921875,39.24501680713314],[-100.843505859375,39.16414104768742],[-100.8050537109375,39.104488809440475],[-100.491943359375,39.10022600175347],[-100.43701171875,39.095962936305476],[-100.338134765625,39.095962936305476],[-100.1953125,39.027718840211605],[-100.008544921875,39.01064750994083],[-99.86572265625,39.00211029922512],[-99.6844482421875,38.97222194853654],[-99.51416015625,38.929502416386605],[-99.38232421875,38.92095542046727],[-99.3218994140625,38.89530825492018],[-99.1131591796875,38.86965182408357],[-99.0802001953125,38.85682013474361],[-98.82202148437499,38.85682013474361],[-98.44848632812499,38.84826438869913],[-98.20678710937499,38.84826438869913],[-98.02001953125,38.8782049970615],[-97.635498046875,38.87392853923629] ]
      }
    ],
    multiLineStrings : [
      {
        "type": "MultiLineString",
        "coordinates": [
          [ [41.83,71.01],[56.95,33.75] ],
          [ [21.79,36.56],[47.83,71.01] ]
        ]
      },
      {
        "type": "MultiLineString",
        "coordinates": [
          [ [-105.0214433670044,39.57805759162015],[-105.02150774002075,39.57780951131517],[-105.02157211303711,39.57749527498758],[-105.02157211303711,39.57716449836683],[-105.02157211303711,39.57703218727656],[-105.02152919769287,39.57678410330158] ],
          [ [-105.01989841461182,39.574997872470774],[-105.01959800720215,39.57489863607502],[-105.01906156539916,39.57478286010041] ],
          [ [-105.01717329025269,39.5744024519653],[-105.01698017120361,39.574385912433804],[-105.0166368484497,39.574385912433804],[-105.01650810241699,39.5744024519653],[-105.0159502029419,39.574270135602866] ],
          [ [-105.0142765045166,39.57397242286402],[-105.01412630081175,39.57403858136094],[-105.0138258934021,39.57417089816531],[-105.01331090927124,39.57445207053608] ]
        ]
      }
    ],
    polygons : [
      {
        "type": "Polygon",
        "coordinates": [
          [ [41.83,71.01],[56.95,33.75],[21.79,36.56],[41.83,71.01] ]
        ]
      },
      {
        "type": "Polygon",
        "coordinates": [
          [ [-84.32281494140625,34.9895035675793],[-84.29122924804688,35.21981940793435],[-84.24041748046875,35.25459097465022],[-84.22531127929688,35.266925688950074],[-84.20745849609375,35.26580442886754],[-84.19921875,35.24674063355999],[-84.16213989257812,35.24113278166642],[-84.12368774414062,35.24898366572645],[-84.09072875976562,35.24898366572645],[-84.08798217773438,35.264683153268116],[-84.04266357421875,35.27701633139884],[-84.03030395507812,35.291589484566124],[-84.0234375,35.306160014550784],[-84.03305053710936,35.32745068492882],[-84.03579711914062,35.34313496028189],[-84.03579711914062,35.348735749472546],[-84.01657104492188,35.35545618392078],[-84.01107788085938,35.37337460834958],[-84.00970458984374,35.39128905521763],[-84.01931762695312,35.41479572901859],[-84.00283813476562,35.429344044107154],[-83.93692016601562,35.47409160773029],[-83.91220092773438,35.47632833265728],[-83.88885498046875,35.504282143299655],[-83.88473510742186,35.516578738902936],[-83.8751220703125,35.52104976129943],[-83.85314941406249,35.52104976129943],[-83.82843017578125,35.52104976129943],[-83.8092041015625,35.53446133418443],[-83.80233764648438,35.54116627999813],[-83.76800537109374,35.56239491058853],[-83.7432861328125,35.56239491058853],[-83.71994018554688,35.56239491058853],[-83.67050170898438,35.569097520776054],[-83.6334228515625,35.570214567965984],[-83.61007690429688,35.576916524038616],[-83.59634399414061,35.574682600980914],[-83.5894775390625,35.55904339525896],[-83.55239868164062,35.56574628576276],[-83.49746704101562,35.563512051219696],[-83.47000122070312,35.586968406786475],[-83.4466552734375,35.60818490437746],[-83.37936401367188,35.63609277863135],[-83.35739135742188,35.65618041632016],[-83.32305908203124,35.66622234103479],[-83.3148193359375,35.65394870599763],[-83.29971313476561,35.660643649881614],[-83.28598022460938,35.67180064238771],[-83.26126098632811,35.6907639509368],[-83.25714111328125,35.69968630125201],[-83.25576782226562,35.715298012125295],[-83.23516845703125,35.72310272092263],[-83.19808959960936,35.72756221127198],[-83.16238403320312,35.753199435570316],[-83.15826416015625,35.76322914549896],[-83.10333251953125,35.76991491635478],[-83.08685302734375,35.7843988251953],[-83.0511474609375,35.787740890986576],[-83.01681518554688,35.78328477203738],[-83.001708984375,35.77882840327371],[-82.96737670898438,35.793310688351724],[-82.94540405273438,35.820040281161],[-82.9193115234375,35.85121343450061],[-82.9083251953125,35.86902116501695],[-82.90557861328125,35.87792352995116],[-82.91244506835938,35.92353244718235],[-82.88360595703125,35.94688293218141],[-82.85614013671875,35.951329861522666],[-82.8424072265625,35.94243575255426],[-82.825927734375,35.92464453144099],[-82.80670166015625,35.927980690382704],[-82.80532836914062,35.94243575255426],[-82.77923583984375,35.97356075349624],[-82.78060913085938,35.99245209055831],[-82.76138305664062,36.00356252895066],[-82.69546508789062,36.04465753921525],[-82.64465332031249,36.060201412392914],[-82.61306762695312,36.060201412392914],[-82.60620117187499,36.033552893400376],[-82.60620117187499,35.991340960635405],[-82.60620117187499,35.97911749857497],[-82.5787353515625,35.96133453736691],[-82.5677490234375,35.951329861522666],[-82.53067016601562,35.97244935753683],[-82.46475219726562,36.006895355244666],[-82.41668701171875,36.070192281208456],[-82.37960815429686,36.10126686921446],[-82.35488891601562,36.117908916563685],[-82.34115600585936,36.113471382052175],[-82.29583740234375,36.13343831245866],[-82.26287841796874,36.13565654678543],[-82.23403930664062,36.13565654678543],[-82.2216796875,36.154509006695],[-82.20382690429688,36.15561783381855],[-82.19009399414062,36.144528857027744],[-82.15438842773438,36.15007354140755],[-82.14065551757812,36.134547437460064],[-82.1337890625,36.116799556445024],[-82.12142944335938,36.10570509327921],[-82.08984375,36.10792411128649],[-82.05276489257811,36.12678323326429],[-82.03628540039062,36.12900165569652],[-81.91268920898438,36.29409768373033],[-81.89071655273438,36.30959215409138],[-81.86325073242188,36.33504067209607],[-81.83029174804688,36.34499652561904],[-81.80145263671875,36.35605709240176],[-81.77947998046874,36.34610265300638],[-81.76162719726562,36.33835943134047],[-81.73690795898438,36.33835943134047],[-81.71905517578125,36.33835943134047],[-81.70669555664062,36.33504067209607],[-81.70669555664062,36.342784223707234],[-81.72317504882812,36.357163062654365],[-81.73278808593749,36.379279167407965],[-81.73690795898438,36.40028364332352],[-81.73690795898438,36.41354670392876],[-81.72454833984374,36.423492513472326],[-81.71768188476562,36.445589751779174],[-81.69845581054688,36.47541104282962],[-81.69845581054688,36.51073994146672],[-81.705322265625,36.53060536411363],[-81.69158935546875,36.55929085774001],[-81.68060302734375,36.56480607840351],[-81.68197631835938,36.58686302344181],[-81.04202270507812,36.56370306576917],[-80.74264526367186,36.561496993252575],[-79.89120483398438,36.54053616262899],[-78.68408203124999,36.53943280355122],[-77.88345336914062,36.54053616262899],[-76.91665649414062,36.54163950596125],[-76.91665649414062,36.55046568575947],[-76.31103515625,36.551568887374],[-75.79605102539062,36.54936246839778],[-75.6298828125,36.07574221562703],[-75.4925537109375,35.82226734114509],[-75.3936767578125,35.639441068973916],[-75.41015624999999,35.43829554739668],[-75.43212890625,35.263561862152095],[-75.487060546875,35.18727767598896],[-75.5914306640625,35.17380831799959],[-75.9210205078125,35.04798673426734],[-76.17919921875,34.867904962568744],[-76.41540527343749,34.62868797377061],[-76.4593505859375,34.57442951865274],[-76.53076171875,34.53371242139567],[-76.5911865234375,34.551811369170494],[-76.651611328125,34.615126683462194],[-76.761474609375,34.63320791137959],[-77.069091796875,34.59704151614417],[-77.376708984375,34.45674800347809],[-77.5909423828125,34.3207552752374],[-77.8326416015625,33.97980872872457],[-77.9150390625,33.80197351806589],[-77.9754638671875,33.73804486328907],[-78.11279296875,33.8521697014074],[-78.2830810546875,33.8521697014074],[-78.4808349609375,33.815666308702774],[-79.6728515625,34.8047829195724],[-80.782470703125,34.836349990763864],[-80.782470703125,34.91746688928252],[-80.9307861328125,35.092945313732635],[-81.0516357421875,35.02999636902566],[-81.0516357421875,35.05248370662468],[-81.0516357421875,35.137879119634185],[-82.3150634765625,35.19625600786368],[-82.3590087890625,35.19625600786368],[-82.40295410156249,35.22318504970181],[-82.4688720703125,35.16931803601131],[-82.6885986328125,35.1154153142536],[-82.781982421875,35.06147690849717],[-83.1060791015625,35.003003395276714],[-83.616943359375,34.99850370014629],[-84.05639648437499,34.985003130171066],[-84.22119140625,34.985003130171066],[-84.32281494140625,34.9895035675793] ],
          [ [-75.69030761718749,35.74205383068037], [-75.5914306640625,35.74205383068037], [-75.5419921875,35.585851593232356], [-75.56396484375,35.32633026307483], [-75.69030761718749,35.285984736065735], [-75.970458984375,35.16482750605027], [-76.2066650390625,34.994003757575776], [-76.300048828125,35.02999636902566], [-76.409912109375,35.07946034047981], [-76.5252685546875,35.10642805736423], [-76.4208984375,35.25907654252574], [-76.3385009765625,35.294952147406576], [-76.0858154296875,35.29943548054543], [-75.948486328125,35.44277092585766], [-75.8660888671875,35.53669637839501], [-75.772705078125,35.567980458012094], [-75.706787109375,35.634976650677295], [-75.706787109375,35.74205383068037], [-75.69030761718749,35.74205383068037] ]
        ]
      },
      {
        "type": "Polygon",
        "coordinates": [
          [ [100.0, 0.0],[101.0, 0.0],[101.0, 1.0],[100.0, 1.0],[100.0, 0.0] ],
          [ [100.2, 0.2],[100.8, 0.2],[100.8, 0.8],[100.2, 0.8],[100.2, 0.2] ]
        ]
      }
    ],
    multiPolygons : [
      {
        "type": "MultiPolygon",
        "coordinates": [
          [
            [ [102.0, 2.0], [103.0, 2.0], [103.0, 3.0], [102.0, 3.0], [102.0, 2.0] ]
          ],
          [
            [ [100.0, 0.0], [101.0, 0.0], [101.0, 1.0], [100.0, 1.0], [100.0, 0.0] ]
          ]
        ]
      },
      {
        "type": "MultiPolygon",
        "coordinates": [
          [
            [ [-84.32281494140625,34.9895035675793],[-84.29122924804688,35.21981940793435],[-84.24041748046875,35.25459097465022],[-84.22531127929688,35.266925688950074],[-84.20745849609375,35.26580442886754],[-84.19921875,35.24674063355999],[-84.16213989257812,35.24113278166642],[-84.12368774414062,35.24898366572645],[-84.09072875976562,35.24898366572645],[-84.08798217773438,35.264683153268116],[-84.04266357421875,35.27701633139884],[-84.03030395507812,35.291589484566124],[-84.0234375,35.306160014550784],[-84.03305053710936,35.32745068492882],[-84.03579711914062,35.34313496028189],[-84.03579711914062,35.348735749472546],[-84.01657104492188,35.35545618392078],[-84.01107788085938,35.37337460834958],[-84.00970458984374,35.39128905521763],[-84.01931762695312,35.41479572901859],[-84.00283813476562,35.429344044107154],[-83.93692016601562,35.47409160773029],[-83.91220092773438,35.47632833265728],[-83.88885498046875,35.504282143299655],[-83.88473510742186,35.516578738902936],[-83.8751220703125,35.52104976129943],[-83.85314941406249,35.52104976129943],[-83.82843017578125,35.52104976129943],[-83.8092041015625,35.53446133418443],[-83.80233764648438,35.54116627999813],[-83.76800537109374,35.56239491058853],[-83.7432861328125,35.56239491058853],[-83.71994018554688,35.56239491058853],[-83.67050170898438,35.569097520776054],[-83.6334228515625,35.570214567965984],[-83.61007690429688,35.576916524038616],[-83.59634399414061,35.574682600980914],[-83.5894775390625,35.55904339525896],[-83.55239868164062,35.56574628576276],[-83.49746704101562,35.563512051219696],[-83.47000122070312,35.586968406786475],[-83.4466552734375,35.60818490437746],[-83.37936401367188,35.63609277863135],[-83.35739135742188,35.65618041632016],[-83.32305908203124,35.66622234103479],[-83.3148193359375,35.65394870599763],[-83.29971313476561,35.660643649881614],[-83.28598022460938,35.67180064238771],[-83.26126098632811,35.6907639509368],[-83.25714111328125,35.69968630125201],[-83.25576782226562,35.715298012125295],[-83.23516845703125,35.72310272092263],[-83.19808959960936,35.72756221127198],[-83.16238403320312,35.753199435570316],[-83.15826416015625,35.76322914549896],[-83.10333251953125,35.76991491635478],[-83.08685302734375,35.7843988251953],[-83.0511474609375,35.787740890986576],[-83.01681518554688,35.78328477203738],[-83.001708984375,35.77882840327371],[-82.96737670898438,35.793310688351724],[-82.94540405273438,35.820040281161],[-82.9193115234375,35.85121343450061],[-82.9083251953125,35.86902116501695],[-82.90557861328125,35.87792352995116],[-82.91244506835938,35.92353244718235],[-82.88360595703125,35.94688293218141],[-82.85614013671875,35.951329861522666],[-82.8424072265625,35.94243575255426],[-82.825927734375,35.92464453144099],[-82.80670166015625,35.927980690382704],[-82.80532836914062,35.94243575255426],[-82.77923583984375,35.97356075349624],[-82.78060913085938,35.99245209055831],[-82.76138305664062,36.00356252895066],[-82.69546508789062,36.04465753921525],[-82.64465332031249,36.060201412392914],[-82.61306762695312,36.060201412392914],[-82.60620117187499,36.033552893400376],[-82.60620117187499,35.991340960635405],[-82.60620117187499,35.97911749857497],[-82.5787353515625,35.96133453736691],[-82.5677490234375,35.951329861522666],[-82.53067016601562,35.97244935753683],[-82.46475219726562,36.006895355244666],[-82.41668701171875,36.070192281208456],[-82.37960815429686,36.10126686921446],[-82.35488891601562,36.117908916563685],[-82.34115600585936,36.113471382052175],[-82.29583740234375,36.13343831245866],[-82.26287841796874,36.13565654678543],[-82.23403930664062,36.13565654678543],[-82.2216796875,36.154509006695],[-82.20382690429688,36.15561783381855],[-82.19009399414062,36.144528857027744],[-82.15438842773438,36.15007354140755],[-82.14065551757812,36.134547437460064],[-82.1337890625,36.116799556445024],[-82.12142944335938,36.10570509327921],[-82.08984375,36.10792411128649],[-82.05276489257811,36.12678323326429],[-82.03628540039062,36.12900165569652],[-81.91268920898438,36.29409768373033],[-81.89071655273438,36.30959215409138],[-81.86325073242188,36.33504067209607],[-81.83029174804688,36.34499652561904],[-81.80145263671875,36.35605709240176],[-81.77947998046874,36.34610265300638],[-81.76162719726562,36.33835943134047],[-81.73690795898438,36.33835943134047],[-81.71905517578125,36.33835943134047],[-81.70669555664062,36.33504067209607],[-81.70669555664062,36.342784223707234],[-81.72317504882812,36.357163062654365],[-81.73278808593749,36.379279167407965],[-81.73690795898438,36.40028364332352],[-81.73690795898438,36.41354670392876],[-81.72454833984374,36.423492513472326],[-81.71768188476562,36.445589751779174],[-81.69845581054688,36.47541104282962],[-81.69845581054688,36.51073994146672],[-81.705322265625,36.53060536411363],[-81.69158935546875,36.55929085774001],[-81.68060302734375,36.56480607840351],[-81.68197631835938,36.58686302344181],[-81.04202270507812,36.56370306576917],[-80.74264526367186,36.561496993252575],[-79.89120483398438,36.54053616262899],[-78.68408203124999,36.53943280355122],[-77.88345336914062,36.54053616262899],[-76.91665649414062,36.54163950596125],[-76.91665649414062,36.55046568575947],[-76.31103515625,36.551568887374],[-75.79605102539062,36.54936246839778],[-75.6298828125,36.07574221562703],[-75.4925537109375,35.82226734114509],[-75.3936767578125,35.639441068973916],[-75.41015624999999,35.43829554739668],[-75.43212890625,35.263561862152095],[-75.487060546875,35.18727767598896],[-75.5914306640625,35.17380831799959],[-75.9210205078125,35.04798673426734],[-76.17919921875,34.867904962568744],[-76.41540527343749,34.62868797377061],[-76.4593505859375,34.57442951865274],[-76.53076171875,34.53371242139567],[-76.5911865234375,34.551811369170494],[-76.651611328125,34.615126683462194],[-76.761474609375,34.63320791137959],[-77.069091796875,34.59704151614417],[-77.376708984375,34.45674800347809],[-77.5909423828125,34.3207552752374],[-77.8326416015625,33.97980872872457],[-77.9150390625,33.80197351806589],[-77.9754638671875,33.73804486328907],[-78.11279296875,33.8521697014074],[-78.2830810546875,33.8521697014074],[-78.4808349609375,33.815666308702774],[-79.6728515625,34.8047829195724],[-80.782470703125,34.836349990763864],[-80.782470703125,34.91746688928252],[-80.9307861328125,35.092945313732635],[-81.0516357421875,35.02999636902566],[-81.0516357421875,35.05248370662468],[-81.0516357421875,35.137879119634185],[-82.3150634765625,35.19625600786368],[-82.3590087890625,35.19625600786368],[-82.40295410156249,35.22318504970181],[-82.4688720703125,35.16931803601131],[-82.6885986328125,35.1154153142536],[-82.781982421875,35.06147690849717],[-83.1060791015625,35.003003395276714],[-83.616943359375,34.99850370014629],[-84.05639648437499,34.985003130171066],[-84.22119140625,34.985003130171066],[-84.32281494140625,34.9895035675793] ],
            [ [-75.69030761718749,35.74205383068037],[-75.5914306640625,35.74205383068037],[-75.5419921875,35.585851593232356],[-75.56396484375,35.32633026307483],[-75.69030761718749,35.285984736065735],[-75.970458984375,35.16482750605027],[-76.2066650390625,34.994003757575776],[-76.300048828125,35.02999636902566],[-76.409912109375,35.07946034047981],[-76.5252685546875,35.10642805736423],[-76.4208984375,35.25907654252574],[-76.3385009765625,35.294952147406576],[-76.0858154296875,35.29943548054543],[-75.948486328125,35.44277092585766],[-75.8660888671875,35.53669637839501],[-75.772705078125,35.567980458012094],[-75.706787109375,35.634976650677295],[-75.706787109375,35.74205383068037],[-75.69030761718749,35.74205383068037] ]
          ],
          [
            [ [-109.0283203125,36.98500309285596],[-109.0283203125,40.97989806962013],[-102.06298828125,40.97989806962013],[-102.06298828125,37.00255267215955],[-109.0283203125,36.98500309285596] ]
          ]
        ]
      },
      {
        "type": "MultiPolygon",
        "coordinates": [
          [
            [[102.0, 2.0],[103.0, 2.0],[103.0, 3.0],[102.0, 3.0],[102.0, 2.0]]
          ],
          [
            [[100.0, 0.0],[101.0, 0.0],[101.0, 1.0],[100.0, 1.0],[100.0, 0.0]],
            [[100.2, 0.2],[100.8, 0.2],[100.8, 0.8],[100.2, 0.8],[100.2, 0.2]]
          ]
        ]
      }
    ],
    features : [
      {
        "type": "Feature",
        "geometry":  {
          "type": "Polygon",
          "coordinates": [
            [ [41.83,71.01],[56.95,33.75],[21.79,36.56],[41.83,71.01] ]
          ]
        },
        "id": "foo",
        "properties": {
          "bar": "baz"
        }
      },
      {
        "type": "Feature",
        "id": "stadium",
        "properties": {
          "name": "Coors Field",
          "amenity": "Baseball Stadium",
          "popupContent": "This is where the Rockies play!"
        },
        "geometry": {
            "type": "Point",
            "coordinates": [-104.99404, 39.75621]
        }
      },
      {
        "type": "Feature",
        "geometry": {
          "type": "Polygon",
          "coordinates": [
            [ [-80.72487831115721,35.26545403190955],[-80.72135925292969,35.26727607954368],[-80.71517944335938,35.26769654625573],[-80.7125186920166,35.27035945142482],[-80.70857048034668,35.268257165144064],[-80.70479393005371,35.268397319259996],[-80.70324897766113,35.26503355355979],[-80.71088790893555,35.2553619492954],[-80.71681022644043,35.2553619492954],[-80.7150936126709,35.26054831539319],[-80.71869850158691,35.26026797976481],[-80.72032928466797,35.26061839914875],[-80.72264671325684,35.26033806376283],[-80.72487831115721,35.26545403190955] ]
          ]
        },
        "properties": {
          "name": "Plaza Road Park"
        }
      }
    ],
    featureCollections : [
      {
        "type": "FeatureCollection",
        "features": [{
          "type": "Feature",
          "id": "foo",
          "properties": {
            "foo": "bar"
          },
          "geometry":  {
            "type": "Polygon",
            "coordinates": [
              [ [41.83,71.01],[56.95,33.75],[21.79,36.56],[41.83,71.01] ]
            ]
          }
        }],
        "properties": {
          "bar": "baz"
        }
      },
      {
        "type": "FeatureCollection",
        "features": [{
          "type": "Feature",
          "properties": {"party": "Republican"},
          "geometry": {
            "type": "Polygon",
            "coordinates": [
              [ [-104.05, 48.99],[-97.22,  48.98],[-96.58,  45.94],[-104.03, 45.94],[-104.05, 48.99] ]
            ]
          }
        },{
          "type": "Feature",
          "properties": {"party": "Democrat"},
          "geometry": {
            "type": "Polygon",
            "coordinates": [
              [ [-109.05, 41.00],[-102.06, 40.99],[-102.03, 36.99],[-109.04, 36.99],[-109.05, 41.00] ]
            ]
          }
        }]
      },
      {
      "type": "FeatureCollection",
        "features": [
          {
            "type": "Feature",
            "geometry": {
              "type": "Point",
              "coordinates": [-80.87088507656375,35.21515162500578]
            },
            "properties": {
              "name": "ABBOTT NEIGHBORHOOD PARK",
              "address": "1300  SPRUCE ST"
            }
          },
          {
            "type": "Feature",
            "geometry": {
              "type": "Point",
              "coordinates": [-80.83775386582222,35.24980190252168]
            },
            "properties": {
              "name": "DOUBLE OAKS CENTER",
              "address": "1326 WOODWARD AV"
            }
          },
          {
            "type": "Feature",
            "geometry": {
              "type": "Point",
              "coordinates": [-80.83827000459532,35.25674709224663]
            },
            "properties": {
              "name": "DOUBLE OAKS NEIGHBORHOOD PARK",
              "address": "2605  DOUBLE OAKS RD"
            }
          },
          {
            "type": "Feature",
            "geometry": {
              "type": "Point",
              "coordinates": [-80.83697759172735,35.25751734669229]
            },
            "properties": {
              "name": "DOUBLE OAKS POOL",
              "address": "1200 NEWLAND RD"
            }
          },
          {
            "type": "Feature",
            "geometry": {
              "type": "Point",
              "coordinates": [-80.81647652154736,35.40148708491418]
            },
            "properties": {
              "name": "DAVID B. WAYMER FLYING REGIONAL PARK",
              "address": "15401 HOLBROOKS RD"
            }
          },
          {
            "type": "Feature",
            "geometry": {
              "type": "Point",
              "coordinates": [-80.83556459443902,35.39917224760999]
            },
            "properties": {
              "name": "DAVID B. WAYMER COMMUNITY PARK",
              "address": "302 HOLBROOKS RD"
            }
          },
          {
            "type": "Feature",
            "geometry": {
              "type": "Polygon",
              "coordinates": [
                [ [-80.72487831115721,35.26545403190955],[-80.72135925292969,35.26727607954368],[-80.71517944335938,35.26769654625573],[-80.7125186920166,35.27035945142482],[-80.70857048034668,35.268257165144064],[-80.70479393005371,35.268397319259996],[-80.70324897766113,35.26503355355979],[-80.71088790893555,35.2553619492954],[-80.71681022644043,35.2553619492954],[-80.7150936126709,35.26054831539319],[-80.71869850158691,35.26026797976481],[-80.72032928466797,35.26061839914875],[-80.72264671325684,35.26033806376283],[-80.72487831115721,35.26545403190955] ]
              ]
            },
            "properties": {
              "name": "Plaza Road Park"
            }
          }
        ]
      },
      {
        "type": "FeatureCollection",
        "features": [{
          "type": "Feature",
          "geometry": {
            "type": "Point",
            "coordinates": [102.0, 0.5]
          },
          "properties": {
            "prop0": "value0"
          }
        }, {
          "type": "Feature",
          "geometry": {
            "type": "LineString",
            "coordinates": [
              [102.0, 0.0],
              [103.0, 1.0],
              [104.0, 0.0],
              [105.0, 1.0]
            ]
          },
          "properties": {
            "prop0": "value0",
            "prop1": 0.0
          }
        }, {
          "type": "Feature",
          "geometry": {
            "type": "Polygon",
            "coordinates": [
              [
                [100.0, 0.0],
                [101.0, 0.0],
                [101.0, 1.0],
                [100.0, 1.0],
                [100.0, 0.0]
              ]
            ]
          },
          "properties": {
            "prop0": "value0",
            "prop1": {
              "this": "that"
            }
          }
        }]
      }
    ],
    geometryCollections : [
      {
        "type": "GeometryCollection",
        "geometries": [{
          "type": "Polygon",
          "coordinates": [
            [ [41.8359375,71.015625],[56.953125,33.75],[21.796875,36.5625],[41.8359375,71.015625] ]
          ]
          },{
            "type": "MultiPoint",
            "coordinates": [ [100, 0],[45, -122] ]
          }
        ]
      },
      {
        "type": "GeometryCollection",
        "geometries": [
          {
            "type": "Point",
            "coordinates": [-80.66080570220947,35.04939206472683]
          },
          {
            "type": "Polygon",
            "coordinates": [
              [ [-80.66458225250244,35.04496519190309],[-80.66344499588013,35.04603679820616],[-80.66258668899536,35.045580049697556],[-80.66387414932251,35.044280059194946],[-80.66458225250244,35.04496519190309] ]
            ]
          },
          {
            "type": "LineString",
            "coordinates": [ [-80.66237211227417,35.05950973022538],[-80.66269397735596,35.0592638296087],[-80.66284418106079,35.05893010615862],[-80.66308021545409,35.05833291342246],[-80.66359519958496,35.057753281001425],[-80.66387414932251,35.05740198662245],[-80.66441059112549,35.05703312589789],[-80.66486120223999,35.056787217822475],[-80.66541910171509,35.05650617911516],[-80.66563367843628,35.05631296444281],[-80.66601991653441,35.055891403570705],[-80.66619157791138,35.05545227534804],[-80.66619157791138,35.05517123204622],[-80.66625595092773,35.05489018777713],[-80.6662130355835,35.054222703761525],[-80.6662130355835,35.05392409072499],[-80.66595554351807,35.05290528508858],[-80.66569805145262,35.052044560077285],[-80.66550493240356,35.0514824490509],[-80.665762424469,35.05048117920187],[-80.66617012023926,35.04972582715769],[-80.66651344299316,35.049286665781096],[-80.66692113876343,35.0485313026898],[-80.66700696945189,35.048215102112344],[-80.66707134246826,35.04777593261294],[-80.66704988479614,35.04738946150025],[-80.66696405410767,35.04698542156371],[-80.66681385040283,35.046353007216055],[-80.66659927368164,35.04596652937105],[-80.66640615463257,35.04561518428889],[-80.6659984588623,35.045193568195565],[-80.66552639007568,35.044877354697526],[-80.6649899482727,35.04454357245502],[-80.66449642181396,35.04417465365292],[-80.66385269165039,35.04387600387859],[-80.66303730010986,35.043717894732545] ]
          }
        ]
      }
    ]
  };

  return exports;

}));