function Layers() {

	this.mask = 1 | 0;

}

Object.assign( Layers.prototype, {

	set: function ( channel ) {

		this.mask = 1 << channel | 0;

	},

	enable: function ( channel ) {

		this.mask |= 1 << channel | 0;

	},

	enableAll: function () {

		this.mask = 0xffffffff | 0;

	},

	toggle: function ( channel ) {

		this.mask ^= 1 << channel | 0;

	},

	disable: function ( channel ) {

		this.mask &= ~ ( 1 << channel | 0 );

	},

	disableAll: function () {

		this.mask = 0;

	},

	test: function ( layers ) {

		return ( this.mask & layers.mask ) !== 0;

	}

} );


export { Layers };
