
// This is ammo.js, a port of Bullet Physics to JavaScript. zlib licensed.
var AmmoLib = function(Module) {
  Module = Module || {};

var Module;if(!Module)Module=(typeof AmmoLib!=="undefined"?AmmoLib:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_IS_SHELL=false;if(Module["ENVIRONMENT"]){if(Module["ENVIRONMENT"]==="WEB"){ENVIRONMENT_IS_WEB=true}else if(Module["ENVIRONMENT"]==="WORKER"){ENVIRONMENT_IS_WORKER=true}else if(Module["ENVIRONMENT"]==="NODE"){ENVIRONMENT_IS_NODE=true}else if(Module["ENVIRONMENT"]==="SHELL"){ENVIRONMENT_IS_SHELL=true}else{throw new Error("The provided Module['ENVIRONMENT'] value is not valid. It must be one of: WEB|WORKER|NODE|SHELL.")}}else{ENVIRONMENT_IS_WEB=typeof window==="object";ENVIRONMENT_IS_WORKER=typeof importScripts==="function";ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER}if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=console.log;if(!Module["printErr"])Module["printErr"]=console.warn;var nodeFS;var nodePath;Module["read"]=function read(filename,binary){if(!nodeFS)nodeFS=require("fs");if(!nodePath)nodePath=require("path");filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};Module["readAsync"]=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.warn(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){abort("NO_DYNAMIC_EXECUTION=1 was set, cannot eval")}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=undefined;var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){DYNAMICTOP=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};var ABORT=false;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}function getCFunc(ident){var func=Module["_"+ident];if(!func){abort("NO_DYNAMIC_EXECUTION=1 was set, cannot eval")}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};cwrap=function cwrap(ident,returnType,argTypes){return(function(){return ccall(ident,returnType,argTypes,arguments)})}}))();function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}var ALLOC_NORMAL=0;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[typeof _malloc==="function"?_malloc:Runtime.staticAlloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){return func}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}Runtime.warnOnce("warning: build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling");return func}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}var PAGE_SIZE=4096;function alignMemoryPage(x){if(x%4096>0){x+=4096-x%4096}return x}var HEAP;var buffer;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBufferViews(){Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer)}var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which adjusts the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function enlargeMemory(){abortOnCannotGrowMemory()}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||67108864;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){TOTAL_MEMORY=totalMemory}if(Module["buffer"]){buffer=Module["buffer"]}else{buffer=new ArrayBuffer(TOTAL_MEMORY)}updateGlobalBufferViews();HEAP32[0]=255;if(HEAPU8[0]!==255||HEAPU8[3]!==0)throw"Typed arrays 2 must be run on a little-endian system";Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}function addOnPreMain(cb){__ATMAIN__.unshift(cb)}function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;Module["preloadedImages"]={};Module["preloadedAudios"]={};var ASM_CONSTS=[(function($0,$1,$2,$3,$4,$5,$6,$7){{var self=Module["getCache"](Module["ConcreteContactResultCallback"])[$0];if(!self.hasOwnProperty("addSingleResult"))throw"a JSImplementation must implement all functions, you forgot ConcreteContactResultCallback::addSingleResult.";return self["addSingleResult"]($1,$2,$3,$4,$5,$6,$7)}})];function _emscripten_asm_const_diiiiiiii(code,a0,a1,a2,a3,a4,a5,a6,a7){return ASM_CONSTS[code](a0,a1,a2,a3,a4,a5,a6,a7)}STATIC_BASE=8;STATICTOP=STATIC_BASE+26272;__ATINIT__.push({func:(function(){__GLOBAL__sub_I_btQuickprof_cpp()})});allocate([88,37,0,0,220,37,0,0,128,37,0,0,7,38,0,0,8,0,0,0,0,0,0,0,88,37,0,0,57,38,0,0,88,37,0,0,78,38,0,0,128,37,0,0,94,38,0,0,40,0,0,0,0,0,0,0,88,37,0,0,117,38,0,0,128,37,0,0,145,38,0,0,64,0,0,0,0,0,0,0,88,37,0,0,167,38,0,0,128,37,0,0,207,38,0,0,88,0,0,0,0,0,0,0,88,37,0,0,254,38,0,0,128,37,0,0,42,39,0,0,112,0,0,0,0,0,0,0,128,37,0,0,114,40,0,0,152,0,0,0,0,0,0,0,88,37,0,0,140,40,0,0,128,37,0,0,159,40,0,0,0,4,0,0,0,0,0,0,128,37,0,0,203,40,0,0,192,0,0,0,0,0,0,0,88,37,0,0,248,40,0,0,128,37,0,0,25,41,0,0,192,0,0,0,0,0,0,0,128,37,0,0,71,41,0,0,192,0,0,0,0,0,0,0,128,37,0,0,123,41,0,0,192,0,0,0,0,0,0,0,128,37,0,0,182,41,0,0,176,3,0,0,0,0,0,0,128,37,0,0,136,42,0,0,24,1,0,0,0,0,0,0,88,37,0,0,168,42,0,0,88,37,0,0,187,42,0,0,128,37,0,0,208,42,0,0,32,1,0,0,0,0,0,0,128,37,0,0,230,42,0,0,48,8,0,0,0,0,0,0,128,37,0,0,60,43,0,0,24,1,0,0,0,0,0,0,128,37,0,0,95,43,0,0,104,1,0,0,0,0,0,0,128,37,0,0,129,43,0,0,24,1,0,0,0,0,0,0,128,37,0,0,162,43,0,0,176,7,0,0,0,0,0,0,128,37,0,0,230,43,0,0,104,1,0,0,0,0,0,0,128,37,0,0,8,44,0,0,24,1,0,0,0,0,0,0,128,37,0,0,42,44,0,0,184,1,0,0,0,0,0,0,88,37,0,0,74,44,0,0,128,37,0,0,97,44,0,0,184,1,0,0,0,0,0,0,128,37,0,0,135,44,0,0,208,7,0,0,0,0,0,0,128,37,0,0,164,44,0,0,208,7,0,0,0,0,0,0,88,37,0,0,68,45,0,0,128,37,0,0,97,45,0,0,120,7,0,0,0,0,0,0,128,37,0,0,124,45,0,0,96,2,0,0,0,0,0,0,128,37,0,0,159,45,0,0,40,2,0,0,0,0,0,0,128,37,0,0,185,45,0,0,56,2,0,0,0,0,0,0,88,37,0,0,211,45,0,0,128,37,0,0,37,46,0,0,184,1,0,0,0,0,0,0,128,37,0,0,68,46,0,0,176,3,0,0,0,0,0,0,128,37,0,0,103,46,0,0,112,2,0,0,0,0,0,0,128,37,0,0,129,46,0,0,40,5,0,0,0,0,0,0,128,37,0,0,36,47,0,0,16,0,0,0,0,0,0,0,128,37,0,0,53,48,0,0,160,2,0,0,0,0,0,0,88,37,0,0,83,48,0,0,128,37,0,0,129,48,0,0,184,2,0,0,0,0,0,0,188,37,0,0,155,48,0,0,0,0,0,0,1,0,0,0,208,2,0,0,2,4,0,0,88,37,0,0,175,48,0,0,128,37,0,0,219,48,0,0,168,2,0,0,0,0,0,0,128,37,0,0,29,49,0,0,184,2,0,0,0,0,0,0,128,37,0,0,115,49,0,0,184,2,0,0,0,0,0,0,128,37,0,0,159,49,0,0,184,2,0,0,0,0,0,0,128,37,0,0,209,49,0,0,184,2,0,0,0,0,0,0,128,37,0,0,0,50,0,0,56,3,0,0,0,0,0,0,88,37,0,0,38,50,0,0,128,37,0,0,133,50,0,0,80,3,0,0,0,0,0,0,88,37,0,0,152,50,0,0,128,37,0,0,172,50,0,0,32,0,0,0,0,0,0,0,128,37,0,0,200,50,0,0,120,3,0,0,0,0,0,0,128,37,0,0,233,50,0,0,80,3,0,0,0,0,0,0,128,37,0,0,10,51,0,0,16,0,0,0,0,0,0,0,128,37,0,0,56,51,0,0,168,3,0,0,0,0,0,0,88,37,0,0,81,51,0,0,88,37,0,0,96,51,0,0,128,37,0,0,143,51,0,0,176,3,0,0,0,0,0,0,128,37,0,0,159,51,0,0,184,3,0,0,0,0,0,0,128,37,0,0,186,51,0,0,136,9,0,0,0,0,0,0,128,37,0,0,210,51,0,0,248,3,0,0,0,0,0,0,88,37,0,0,236,51,0,0,128,37,0,0,0,52,0,0,16,4,0,0,0,0,0,0,88,37,0,0,34,52,0,0,128,37,0,0,61,52,0,0,192,0,0,0,0,0,0,0,128,37,0,0,111,52,0,0,192,0,0,0,0,0,0,0,128,37,0,0,168,52,0,0,192,0,0,0,0,0,0,0,128,37,0,0,213,52,0,0,192,0,0,0,0,0,0,0,128,37,0,0,10,53,0,0,192,0,0,0,0,0,0,0,128,37,0,0,62,53,0,0,192,0,0,0,0,0,0,0,128,37,0,0,95,53,0,0,192,0,0,0,0,0,0,0,128,37,0,0,144,53,0,0,192,0,0,0,0,0,0,0,128,37,0,0,195,53,0,0,192,0,0,0,0,0,0,0,128,37,0,0,238,53,0,0,192,0,0,0,0,0,0,0,88,37,0,0,30,54,0,0,128,37,0,0,101,54,0,0,184,1,0,0,0,0,0,0,128,37,0,0,135,54,0,0,56,10,0,0,0,0,0,0,128,37,0,0,171,54,0,0,208,7,0,0,0,0,0,0,128,37,0,0,198,54,0,0,208,7,0,0,0,0,0,0,128,37,0,0,100,55,0,0,56,10,0,0,0,0,0,0,128,37,0,0,129,55,0,0,32,5,0,0,0,0,0,0,88,37,0,0,148,55,0,0,88,37,0,0,196,55,0,0,188,37,0,0,189,56,0,0,0,0,0,0,2,0,0,0,208,7,0,0,2,0,0,0,216,7,0,0,2,4,0,0,128,37,0,0,209,56,0,0,40,2,0,0,0,0,0,0,128,37,0,0,231,56,0,0,152,9,0,0,0,0,0,0,128,37,0,0,122,57,0,0,152,9,0,0,0,0,0,0,128,37,0,0,15,58,0,0,24,1,0,0,0,0,0,0,128,37,0,0,141,58,0,0,88,0,0,0,0,0,0,0,128,37,0,0,78,59,0,0,168,9,0,0,0,0,0,0,128,37,0,0,253,59,0,0,168,9,0,0,0,0,0,0,128,37,0,0,194,60,0,0,8,0,0,0,0,0,0,0,128,37,0,0,111,61,0,0,40,2,0,0,0,0,0,0,128,37,0,0,135,61,0,0,56,2,0,0,0,0,0,0,128,37,0,0,161,61,0,0,16,5,0,0,0,0,0,0,128,37,0,0,187,61,0,0,56,10,0,0,0,0,0,0,128,37,0,0,224,61,0,0,192,0,0,0,0,0,0,0,128,37,0,0,8,62,0,0,56,10,0,0,0,0,0,0,128,37,0,0,34,62,0,0,32,5,0,0,0,0,0,0,128,37,0,0,167,62,0,0,32,5,0,0,0,0,0,0,128,37,0,0,52,63,0,0,16,5,0,0,0,0,0,0,128,37,0,0,79,63,0,0,56,10,0,0,0,0,0,0,128,37,0,0,110,63,0,0,24,1,0,0,0,0,0,0,128,37,0,0,135,63,0,0,56,10,0,0,0,0,0,0,128,37,0,0,174,63,0,0,24,1,0,0,0,0,0,0,128,37,0,0,207,63,0,0,152,7,0,0,0,0,0,0,128,37,0,0,23,64,0,0,176,7,0,0,0,0,0,0,128,37,0,0,58,64,0,0,176,6,0,0,0,0,0,0,128,37,0,0,79,64,0,0,176,6,0,0,0,0,0,0,128,37,0,0,100,64,0,0,176,7,0,0,0,0,0,0,128,37,0,0,123,64,0,0,56,7,0,0,0,0,0,0,128,37,0,0,188,64,0,0,16,7,0,0,0,0,0,0,88,37,0,0,42,65,0,0,128,37,0,0,66,65,0,0,16,7,0,0,0,0,0,0,128,37,0,0,170,65,0,0,16,7,0,0,0,0,0,0,128,37,0,0,27,66,0,0,48,8,0,0,0,0,0,0,128,37,0,0,62,66,0,0,216,7,0,0,0,0,0,0,128,37,0,0,164,66,0,0,208,7,0,0,0,0,0,0,128,37,0,0,188,66,0,0,48,8,0,0,0,0,0,0,128,37,0,0,244,66,0,0,176,7,0,0,0,0,0,0,128,37,0,0,14,67,0,0,120,7,0,0,0,0,0,0,88,37,0,0,51,67,0,0,128,37,0,0,91,67,0,0,152,7,0,0,0,0,0,0,128,37,0,0,107,67,0,0,160,7,0,0,0,0,0,0,128,37,0,0,131,67,0,0,136,7,0,0,0,0,0,0,88,37,0,0,180,67,0,0,88,37,0,0,201,67,0,0,128,37,0,0,235,67,0,0,176,7,0,0,0,0,0,0,128,37,0,0,28,68,0,0,224,7,0,0,0,0,0,0,128,37,0,0,55,68,0,0,224,7,0,0,0,0,0,0,128,37,0,0,82,68,0,0,136,7,0,0,0,0,0,0,128,37,0,0,124,68,0,0,216,7,0,0,0,0,0,0,128,37,0,0,153,68,0,0,152,7,0,0,0,0,0,0,128,37,0,0,170,68,0,0,120,7,0,0,0,0,0,0,128,37,0,0,187,68,0,0,144,9,0,0,0,0,0,0,128,37,0,0,204,68,0,0,216,7,0,0,0,0,0,0,128,37,0,0,48,69,0,0,216,7,0,0,0,0,0,0,128,37,0,0,139,69,0,0,48,8,0,0,0,0,0,0,128,37,0,0,179,69,0,0,176,7,0,0,0,0,0,0,128,37,0,0,227,69,0,0,144,8,0,0,0,0,0,0,128,37,0,0,0,70,0,0,144,8,0,0,0,0,0,0,128,37,0,0,29,70,0,0,152,10,0,0,0,0,0,0,128,37,0,0,46,70,0,0,224,8,0,0,0,0,0,0,88,37,0,0,72,70,0,0,128,37,0,0,96,70,0,0,248,8,0,0,0,0,0,0,128,37,0,0,114,70,0,0,64,0,0,0,0,0,0,0,128,37,0,0,139,70,0,0,208,8,0,0,0,0,0,0,128,37,0,0,154,70,0,0,248,8,0,0,0,0,0,0,128,37,0,0,185,70,0,0,248,3,0,0,0,0,0,0,128,37,0,0,58,71,0,0,248,3,0,0,0,0,0,0,128,37,0,0,168,71,0,0,224,8,0,0,0,0,0,0,128,37,0,0,187,71,0,0,24,1,0,0,0,0,0,0,128,37,0,0,208,71,0,0,24,1,0,0,0,0,0,0,128,37,0,0,230,71,0,0,24,1,0,0,0,0,0,0,88,37,0,0,253,71,0,0,88,37,0,0,12,72,0,0,128,37,0,0,120,72,0,0,208,7,0,0,0,0,0,0,128,37,0,0,148,72,0,0,208,7,0,0,0,0,0,0,128,37,0,0,179,72,0,0,200,9,0,0,0,0,0,0,88,37,0,0,215,72,0,0,128,37,0,0,248,72,0,0,32,5,0,0,0,0,0,0,128,37,0,0,163,73,0,0,200,9,0,0,0,0,0,0,128,37,0,0,196,73,0,0,168,3,0,0,0,0,0,0,128,37,0,0,214,73,0,0,32,5,0,0,0,0,0,0,128,37,0,0,233,73,0,0,168,3,0,0,0,0,0,0,128,37,0,0,7,74,0,0,48,10,0,0,0,0,0,0,88,37,0,0,27,74,0,0,128,37,0,0,66,74,0,0,184,1,0,0,0,0,0,0,128,37,0,0,99,74,0,0,184,1,0,0,0,0,0,0,128,37,0,0,118,74,0,0,56,10,0,0,0,0,0,0,128,37,0,0,153,74,0,0,48,10,0,0,0,0,0,0,128,37,0,0,172,74,0,0,48,10,0,0,0,0,0,0,88,37,0,0,197,74,0,0,88,37,0,0,223,74,0,0,128,37,0,0,244,74,0,0,168,10,0,0,0,0,0,0,88,37,0,0,17,75,0,0,88,37,0,0,74,86,0,0,128,37,0,0,40,86,0,0,216,10,0,0,0,0,0,0,128,37,0,0,213,85,0,0,184,10,0,0,0,0,0,0,128,37,0,0,250,85,0,0,232,10,0,0,0,0,0,0,88,37,0,0,27,86,0,0,128,37,0,0,16,87,0,0,176,10,0,0,0,0,0,0,128,37,0,0,80,87,0,0,216,10,0,0,0,0,0,0,128,37,0,0,44,87,0,0,0,11,0,0,0,0,0,0,128,37,0,0,114,87,0,0,184,10,0,0,0,0,0,0,0,0,0,0,16,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,48,0,0,0,3,0,0,0,4,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,72,0,0,0,5,0,0,0,6,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,96,0,0,0,7,0,0,0,8,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,120,0,0,0,9,0,0,0,10,0,0,0,3,0,0,0,1,0,0,0,0,0,0,0,136,0,0,0,11,0,0,0,12,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,2,0,0,0,13,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,3,0,0,0,5,0,0,0,4,0,0,0,5,0,0,0,0,0,0,0,160,0,0,0,14,0,0,0,15,0,0,0,5,0,0,0,6,0,0,0,2,0,0,0,7,0,0,0,0,0,0,0,176,0,0,0,16,0,0,0,17,0,0,0,2,0,0,0,0,0,0,0,200,0,0,0,16,0,0,0,18,0,0,0,3,0,0,0,0,0,0,0,216,0,0,0,16,0,0,0,19,0,0,0,4,0,0,0,0,0,0,0,232,0,0,0,16,0,0,0,20,0,0,0,5,0,0,0,0,0,0,0,248,0,0,0,4,0,0,0,21,0,0,0,22,0,0,0,6,0,0,0,8,0,0,0,3,0,0,0,7,0,0,0,6,0,0,0,0,0,0,0,8,1,0,0,23,0,0,0,24,0,0,0,7,0,0,0,8,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,40,1,0,0,25,0,0,0,26,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,9,0,0,0,0,0,0,0,56,1,0,0,27,0,0,0,28,0,0,0,1,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,9,0,0,0,10,0,0,0,2,0,0,0,11,0,0,0,10,0,0,0,4,0,0,0,2,0,0,0,12,0,0,0,4,0,0,0,11,0,0,0,2,0,0,0,0,0,0,0,72,1,0,0,23,0,0,0,29,0,0,0,7,0,0,0,12,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,88,1,0,0,23,0,0,0,30,0,0,0,7,0,0,0,13,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,120,1,0,0,31,0,0,0,32,0,0,0,3,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,14,0,0,0,13,0,0,0,3,0,0,0,14,0,0,0,10,0,0,0,5,0,0,0,3,0,0,0,15,0,0,0,5,0,0,0,11,0,0,0,9,0,0,0,10,0,0,0,1,0,0,0,4,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,17,0,0,0,0,0,0,0,136,1,0,0,23,0,0,0,33,0,0,0,12,0,0,0,15,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,152,1,0,0,23,0,0,0,34,0,0,0,13,0,0,0,15,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,168,1,0,0,35,0,0,0,36,0,0,0,2,0,0,0,1,0,0,0,16,0,0,0,0,0,0,0,192,1,0,0,37,0,0,0,38,0,0,0,3,0,0,0,2,0,0,0,17,0,0,0,0,0,0,0,208,1,0,0,39,0,0,0,40,0,0,0,6,0,0,0,0,0,0,0,224,1,0,0,41,0,0,0,42,0,0,0,7,0,0,0,0,0,0,0,240,1,0,0,6,0,0,0,18,0,0,0,14,0,0,0,43,0,0,0,44,0,0,0,0,0,0,0,248,1,0,0,45,0,0,0,46,0,0,0,8,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,14,0,0,0,13,0,0,0,4,0,0,0,18,0,0,0,10,0,0,0,7,0,0,0,4,0,0,0,15,0,0,0,5,0,0,0,11,0,0,0,15,0,0,0,16,0,0,0,1,0,0,0,9,0,0,0,5,0,0,0,19,0,0,0,17,0,0,0,7,0,0,0,20,0,0,0,21,0,0,0,10,0,0,0,18,0,0,0,22,0,0,0,11,0,0,0,1,0,0,0,12,0,0,0,0,0,0,0,8,2,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,19,0,0,0,23,0,0,0,51,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,20,0,0,0,52,0,0,0,21,0,0,0,1,0,0,0,19,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,53,0,0,0,27,0,0,0,16,0,0,0,28,0,0,0,29,0,0,0,24,0,0,0,25,0,0,0,8,0,0,0,9,0,0,0,26,0,0,0,54,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,8,0,0,0,9,0,0,0,55,0,0,0,34,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,56,0,0,0,35,0,0,0,13,0,0,0,0,0,0,0,24,2,0,0,57,0,0,0,58,0,0,0,10,0,0,0,0,0,0,0,64,2,0,0,59,0,0,0,60,0,0,0,4,0,0,0,3,0,0,0,36,0,0,0,0,0,0,0,80,2,0,0,11,0,0,0,61,0,0,0,62,0,0,0,37,0,0,0,27,0,0,0,6,0,0,0,38,0,0,0,0,0,0,0,96,2,0,0,63,0,0,0,64,0,0,0,49,0,0,0,50,0,0,0,19,0,0,0,23,0,0,0,65,0,0,0,13,0,0,0,17,0,0,0,15,0,0,0,39,0,0,0,52,0,0,0,40,0,0,0,1,0,0,0,19,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,53,0,0,0,27,0,0,0,16,0,0,0,28,0,0,0,29,0,0,0,24,0,0,0,25,0,0,0,8,0,0,0,9,0,0,0,28,0,0,0,54,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,14,0,0,0,9,0,0,0,55,0,0,0,34,0,0,0,10,0,0,0,15,0,0,0,12,0,0,0,56,0,0,0,35,0,0,0,13,0,0,0,0,0,0,0,128,2,0,0,66,0,0,0,67,0,0,0,12,0,0,0,3,0,0,0,0,0,0,0,144,2,0,0,68,0,0,0,69,0,0,0,1,0,0,0,0,0,0,0,168,2,0,0,70,0,0,0,71,0,0,0,72,0,0,0,1,0,0,0,41,0,0,0,42,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,29,0,0,0,7,0,0,0,73,0,0,0,0,0,0,0,184,2,0,0,70,0,0,0,74,0,0,0,75,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,30,0,0,0,8,0,0,0,0,0,0,0,216,2,0,0,70,0,0,0,76,0,0,0,72,0,0,0,1,0,0,0,41,0,0,0,43,0,0,0,1,0,0,0,1,0,0,0,4,0,0,0,31,0,0,0,9,0,0,0,73,0,0,0,20,0,0,0,0,0,0,0,232,2,0,0,70,0,0,0,77,0,0,0,78,0,0,0,1,0,0,0,44,0,0,0,45,0,0,0,1,0,0,0,2,0,0,0,5,0,0,0,32,0,0,0,10,0,0,0,0,0,0,0,248,2,0,0,70,0,0,0,79,0,0,0,75,0,0,0,1,0,0,0,46,0,0,0,47,0,0,0,1,0,0,0,3,0,0,0,6,0,0,0,33,0,0,0,11,0,0,0,0,0,0,0,8,3,0,0,70,0,0,0,80,0,0,0,81,0,0,0,1,0,0,0,48,0,0,0,49,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,34,0,0,0,12,0,0,0,21,0,0,0,0,0,0,0,24,3,0,0,70,0,0,0,82,0,0,0,83,0,0,0,1,0,0,0,50,0,0,0,51,0,0,0,1,0,0,0,5,0,0,0,8,0,0,0,35,0,0,0,13,0,0,0,0,0,0,0,40,3,0,0,84,0,0,0,85,0,0,0,22,0,0,0,1,0,0,0,23,0,0,0,86,0,0,0,36,0,0,0,18,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,64,3,0,0,87,0,0,0,88,0,0,0,2,0,0,0,52,0,0,0,16,0,0,0,17,0,0,0,19,0,0,0,0,0,0,0,88,3,0,0,89,0,0,0,90,0,0,0,6,0,0,0,0,0,0,0,104,3,0,0,91,0,0,0,92,0,0,0,3,0,0,0,53,0,0,0,54,0,0,0,4,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,5,0,0,0,37,0,0,0,93,0,0,0,38,0,0,0,58,0,0,0,0,0,0,0,136,3,0,0,66,0,0,0,94,0,0,0,1,0,0,0,9,0,0,0,0,0,0,0,152,3,0,0,95,0,0,0,96,0,0,0,1,0,0,0,10,215,163,60,1,0,0,0,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,176,3,0,0,4,0,0,0,97,0,0,0,98,0,0,0,37,0,0,0,39,0,0,0,14,0,0,0,7,0,0,0,0,0,0,0,184,3,0,0,4,0,0,0,99,0,0,0,100,0,0,0,37,0,0,0,39,0,0,0,14,0,0,0,7,0,0,0,24,0,0,0,20,0,0,0,0,0,0,0,200,3,0,0,4,0,0,0,101,0,0,0,102,0,0,0,37,0,0,0,39,0,0,0,14,0,0,0,7,0,0,0,25,0,0,0,21,0,0,0,0,0,0,0,216,3,0,0,103,0,0,0,104,0,0,0,7,0,0,0,15,0,0,0,59,0,0,0,60,0,0,0,16,0,0,0,17,0,0,0,22,0,0,0,40,0,0,0,13,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,14,0,0,0,61,0,0,0,0,0,0,0,232,3,0,0,105,0,0,0,106,0,0,0,15,0,0,0,0,0,0,0,0,4,0,0,107,0,0,0,108,0,0,0,5,0,0,0,6,0,0,0,18,0,0,0,7,0,0,0,0,0,0,0,24,4,0,0,16,0,0,0,109,0,0,0,8,0,0,0,0,0,0,0,40,4,0,0,16,0,0,0,110,0,0,0,9,0,0,0,0,0,0,0,56,4,0,0,16,0,0,0,111,0,0,0,10,0,0,0,0,0,0,0,72,4,0,0,16,0,0,0,112,0,0,0,11,0,0,0,0,0,0,0,88,4,0,0,16,0,0,0,113,0,0,0,12,0,0,0,0,0,0,0,104,4,0,0,16,0,0,0,114,0,0,0,13,0,0,0,0,0,0,0,120,4,0,0,16,0,0,0,115,0,0,0,14,0,0,0,0,0,0,0,136,4,0,0,16,0,0,0,116,0,0,0,15,0,0,0,0,0,0,0,152,4,0,0,16,0,0,0,117,0,0,0,16,0,0,0,0,0,0,0,168,4,0,0,16,0,0,0,118,0,0,0,17,0,0,0,0,0,0,0,184,4,0,0,119,0,0,0,120,0,0,0,26,0,0,0,62,0,0,0,0,0,0,0,192,4,0,0,121,0,0,0,122,0,0,0,5,0,0,0,4,0,0,0,63,0,0,0,0,0,0,0,208,4,0,0,123,0,0,0,124,0,0,0,6,0,0,0,5,0,0,0,64,0,0,0,0,0,0,0,224,4,0,0,125,0,0,0,126,0,0,0,23,0,0,0,0,0,0,0,240,4,0,0,41,0,0,0,127,0,0,0,24,0,0,0,0,0,0,0,0,5,0,0,128,0,0,0,129,0,0,0,7,0,0,0,6,0,0,0,65,0,0,0,0,0,0,0,16,5,0,0,130,0,0,0,131,0,0,0,27,0,0,0,28,0,0,0,3,0,0,0,0,0,0,0,40,5,0,0,132,0,0,0,133,0,0,0,49,0,0,0,50,0,0,0,19,0,0,0,23,0,0,0,134,0,0,0,13,0,0,0,17,0,0,0,25,0,0,0,66,0,0,0,52,0,0,0,67,0,0,0,0,0,0,0,48,5,0,0,135,0,0,0,136,0,0,0,26,0,0,0,27,0,0,0,252,255,255,255,48,5,0,0,137,0,0,0,138,0,0,0,28,0,0,0,0,0,0,0,80,5,0,0,57,0,0,0,139,0,0,0,16,0,0,0,0,0,0,0,96,5,0,0,41,0,0,0,140,0,0,0,29,0,0,0,1,0,0,0,0,0,0,0,112,5,0,0,41,0,0,0,141,0,0,0,29,0,0,0,2,0,0,0,0,0,0,0,128,5,0,0,23,0,0,0,142,0,0,0,7,0,0,0,68,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,144,5,0,0,143,0,0,0,144,0,0,0,17,0,0,0,10,0,0,0,0,0,0,0,160,5,0,0,41,0,0,0,145,0,0,0,30,0,0,0,1,0,0,0,0,0,0,0,176,5,0,0,41,0,0,0,146,0,0,0,30,0,0,0,2,0,0,0,0,0,0,0,192,5,0,0,66,0,0,0,147,0,0,0,18,0,0,0,11,0,0,0,0,0,0,0,208,5,0,0,57,0,0,0,148,0,0,0,19,0,0,0,0,0,0,0,224,5,0,0,57,0,0,0,149,0,0,0,20,0,0,0,0,0,0,0,240,5,0,0,130,0,0,0,150,0,0,0,27,0,0,0,28,0,0,0,4,0,0,0,0,0,0,0,0,6,0,0,151,0,0,0,152,0,0,0,8,0,0,0,7,0,0,0,69,0,0,0,0,0,0,0,16,6,0,0,153,0,0,0,154,0,0,0,18,0,0,0,0,0,0,0,32,6,0,0,155,0,0,0,156,0,0,0,9,0,0,0,8,0,0,0,70,0,0,0,0,0,0,0,48,6,0,0,130,0,0,0,157,0,0,0,29,0,0,0,30,0,0,0,5,0,0,0,0,0,0,0,64,6,0,0,130,0,0,0,158,0,0,0,31,0,0,0,32,0,0,0,6,0,0,0,0,0,0,0,80,6,0,0,130,0,0,0,159,0,0,0,27,0,0,0,28,0,0,0,7,0,0,0,0,0,0,0,96,6,0,0,160,0,0,0,161,0,0,0,10,0,0,0,9,0,0,0,71,0,0,0,0,0,0,0,112,6,0,0,23,0,0,0,162,0,0,0,7,0,0,0,72,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,128,6,0,0,163,0,0,0,164,0,0,0,11,0,0,0,10,0,0,0,73,0,0,0,0,0,0,0,144,6,0,0,23,0,0,0,165,0,0,0,33,0,0,0,15,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,160,6,0,0,166,0,0,0,167,0,0,0,31,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,74,0,0,0,44,0,0,0,5,0,0,0,45,0,0,0,10,0,0,0,18,0,0,0,5,0,0,0,46,0,0,0,19,0,0,0,11,0,0,0,75,0,0,0,168,0,0,0,0,0,0,0,176,6,0,0,31,0,0,0,169,0,0,0,32,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,76,0,0,0,13,0,0,0,6,0,0,0,47,0,0,0,77,0,0,0,7,0,0,0,4,0,0,0,48,0,0,0,20,0,0,0,11,0,0,0,34,0,0,0,35,0,0,0,1,0,0,0,33,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,0,0,0,0,192,6,0,0,31,0,0,0,170,0,0,0,32,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,76,0,0,0,13,0,0,0,6,0,0,0,49,0,0,0,78,0,0,0,7,0,0,0,4,0,0,0,48,0,0,0,20,0,0,0,11,0,0,0,34,0,0,0,35,0,0,0,1,0,0,0,33,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,0,0,0,0,208,6,0,0,31,0,0,0,171,0,0,0,32,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,76,0,0,0,13,0,0,0,6,0,0,0,50,0,0,0,79,0,0,0,7,0,0,0,4,0,0,0,48,0,0,0,20,0,0,0,11,0,0,0,34,0,0,0,35,0,0,0,1,0,0,0,33,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,0,0,0,0,224,6,0,0,31,0,0,0,172,0,0,0,34,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,14,0,0,0,13,0,0,0,7,0,0,0,51,0,0,0,10,0,0,0,19,0,0,0,6,0,0,0,15,0,0,0,5,0,0,0,11,0,0,0,36,0,0,0,37,0,0,0,1,0,0,0,35,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,0,0,0,0,240,6,0,0,173,0,0,0,174,0,0,0,36,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,80,0,0,0,52,0,0,0,8,0,0,0,53,0,0,0,10,0,0,0,4,0,0,0,2,0,0,0,54,0,0,0,21,0,0,0,11,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,81,0,0,0,82,0,0,0,0,0,0,0,0,7,0,0,175,0,0,0,176,0,0,0,40,0,0,0,0,0,0,0,24,7,0,0,175,0,0,0,177,0,0,0,41,0,0,0,0,0,0,0,40,7,0,0,175,0,0,0,178,0,0,0,42,0,0,0,0,0,0,0,56,7,0,0,179,0,0,0,180,0,0,0,36,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,83,0,0,0,52,0,0,0,8,0,0,0,55,0,0,0,10,0,0,0,4,0,0,0,2,0,0,0,12,0,0,0,4,0,0,0,11,0,0,0,38,0,0,0,38,0,0,0,39,0,0,0,0,0,0,0,72,7,0,0,181,0,0,0,182,0,0,0,39,0,0,0,0,0,0,0,88,7,0,0,41,0,0,0,183,0,0,0,40,0,0,0,0,0,0,0,104,7,0,0,184,0,0,0,185,0,0,0,41,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,84,0,0,0,56,0,0,0,9,0,0,0,57,0,0,0,10,0,0,0,4,0,0,0,2,0,0,0,58,0,0,0,22,0,0,0,11,0,0,0,42,0,0,0,0,0,0,0,120,7,0,0,45,0,0,0,186,0,0,0,32,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,14,0,0,0,13,0,0,0,10,0,0,0,1,0,0,0,10,0,0,0,7,0,0,0,4,0,0,0,15,0,0,0,5,0,0,0,11,0,0,0,15,0,0,0,43,0,0,0,1,0,0,0,43,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,7,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,192,7,0,0,187,0,0,0,188,0,0,0,44,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,85,0,0,0,13,0,0,0,10,0,0,0,59,0,0,0,10,0,0,0,7,0,0,0,4,0,0,0,60,0,0,0,23,0,0,0,11,0,0,0,44,0,0,0,45,0,0,0,1,0,0,0,45,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,7,0,0,0,61,0,0,0,62,0,0,0,46,0,0,0,46,0,0,0,63,0,0,0,47,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,224,7,0,0,31,0,0,0,189,0,0,0,48,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,86,0,0,0,13,0,0,0,11,0,0,0,64,0,0,0,87,0,0,0,20,0,0,0,4,0,0,0,65,0,0,0,24,0,0,0,11,0,0,0,15,0,0,0,47,0,0,0,1,0,0,0,49,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,0,0,0,0,240,7,0,0,31,0,0,0,190,0,0,0,48,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,86,0,0,0,13,0,0,0,11,0,0,0,66,0,0,0,87,0,0,0,20,0,0,0,4,0,0,0,65,0,0,0,24,0,0,0,11,0,0,0,15,0,0,0,47,0,0,0,1,0,0,0,49,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,0,0,0,0,0,8,0,0,31,0,0,0,191,0,0,0,48,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,86,0,0,0,13,0,0,0,11,0,0,0,67,0,0,0,87,0,0,0,20,0,0,0,4,0,0,0,65,0,0,0,24,0,0,0,11,0,0,0,15,0,0,0,47,0,0,0,1,0,0,0,49,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,0,0,0,0,16,8,0,0,45,0,0,0,192,0,0,0,44,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,88,0,0,0,68,0,0,0,10,0,0,0,69,0,0,0,10,0,0,0,7,0,0,0,4,0,0,0,15,0,0,0,5,0,0,0,11,0,0,0,48,0,0,0,49,0,0,0,1,0,0,0,50,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,7,0,0,0,70,0,0,0,71,0,0,0,51,0,0,0,50,0,0,0,72,0,0,0,52,0,0,0,3,0,0,0,0,0,0,0,32,8,0,0,181,0,0,0,193,0,0,0,53,0,0,0,0,0,0,0,64,8,0,0,45,0,0,0,194,0,0,0,54,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,89,0,0,0,13,0,0,0,12,0,0,0,73,0,0,0,10,0,0,0,21,0,0,0,4,0,0,0,15,0,0,0,5,0,0,0,11,0,0,0,51,0,0,0,52,0,0,0,1,0,0,0,55,0,0,0,5,0,0,0,74,0,0,0,53,0,0,0,7,0,0,0,75,0,0,0,76,0,0,0,56,0,0,0,54,0,0,0,77,0,0,0,57,0,0,0,4,0,0,0,55,0,0,0,0,0,0,0,80,8,0,0,195,0,0,0,196,0,0,0,19,0,0,0,78,0,0,0,25,0,0,0,90,0,0,0,91,0,0,0,20,0,0,0,0,0,0,0,96,8,0,0,181,0,0,0,197,0,0,0,58,0,0,0,0,0,0,0,112,8,0,0,181,0,0,0,198,0,0,0,59,0,0,0,0,0,0,0,128,8,0,0,199,0,0,0,200,0,0,0,60,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,92,0,0,0,79,0,0,0,13,0,0,0,80,0,0,0,10,0,0,0,4,0,0,0,2,0,0,0,12,0,0,0,4,0,0,0,11,0,0,0,61,0,0,0,12,0,0,0,0,0,0,0,144,8,0,0,31,0,0,0,201,0,0,0,62,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,93,0,0,0,13,0,0,0,14,0,0,0,81,0,0,0,94,0,0,0,22,0,0,0,4,0,0,0,82,0,0,0,26,0,0,0,11,0,0,0,56,0,0,0,57,0,0,0,1,0,0,0,63,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,7,0,0,0,0,0,0,0,160,8,0,0,31,0,0,0,202,0,0,0,62,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,93,0,0,0,13,0,0,0,14,0,0,0,83,0,0,0,94,0,0,0,22,0,0,0,4,0,0,0,82,0,0,0,26,0,0,0,11,0,0,0,56,0,0,0,58,0,0,0,1,0,0,0,64,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,8,0,0,0,0,0,0,0,176,8,0,0,31,0,0,0,203,0,0,0,62,0,0,0,8,0,0,0,1,0,0,0,1,0,0,0,93,0,0,0,13,0,0,0,14,0,0,0,84,0,0,0,94,0,0,0,22,0,0,0,4,0,0,0,82,0,0,0,26,0,0,0,11,0,0,0,56,0,0,0,59,0,0,0,1,0,0,0,65,0,0,0,5,0,0,0,16,0,0,0,11,0,0,0,9,0,0,0,0,0,0,0,192,8,0,0,204,0,0,0,205,0,0,0,66,0,0,0,1,0,0,0,2,0,0,0,95,0,0,0,96,0,0,0,85,0,0,0,97,0,0,0,98,0,0,0,86,0,0,0,60,0,0,0,61,0,0,0,87,0,0,0,27,0,0,0,0,0,0,0,208,8,0,0,206,0,0,0,207,0,0,0,1,0,0,0,62,0,0,0,12,0,0,0,67,0,0,0,2,0,0,0,68,0,0,0,99,0,0,0,88,0,0,0,89,0,0,0,63,0,0,0,100,0,0,0,208,0,0,0,0,0,0,0,232,8,0,0,209,0,0,0,210,0,0,0,28,0,0,0,21,0,0,0,64,0,0,0,90,0,0,0,91,0,0,0,92,0,0,0,65,0,0,0,93,0,0,0,66,0,0,0,101,0,0,0,67,0,0,0,29,0,0,0,94,0,0,0,102,0,0,0,103,0,0,0,0,0,0,0,8,9,0,0,206,0,0,0,211,0,0,0,1,0,0,0,62,0,0,0,12,0,0,0,67,0,0,0,2,0,0,0,68,0,0,0,99,0,0,0,88,0,0,0,89,0,0,0,63,0,0,0,100,0,0,0,208,0,0,0,0,0,0,0,24,9,0,0,212,0,0,0,213,0,0,0,30,0,0,0,22,0,0,0,68,0,0,0,95,0,0,0,96,0,0,0,97,0,0,0,69,0,0,0,98,0,0,0,70,0,0,0,104,0,0,0,71,0,0,0,31,0,0,0,99,0,0,0,105,0,0,0,106,0,0,0,0,0,0,0,40,9,0,0,105,0,0,0,214,0,0,0,21,0,0,0,0,0,0,0,56,9,0,0,105,0,0,0,215,0,0,0,22,0,0,0,0,0,0,0,72,9,0,0,216,0,0,0,217,0,0,0,2,0,0,0,72,0,0,0,13,0,0,0,69,0,0,0,3,0,0,0,70,0,0,0,107,0,0,0,100,0,0,0,101,0,0,0,73,0,0,0,108,0,0,0,218,0,0,0,0,0,0,0,88,9,0,0,23,0,0,0,219,0,0,0,74,0,0,0,109,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,104,9,0,0,23,0,0,0,220,0,0,0,7,0,0,0,110,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,120,9,0,0,23,0,0,0,221,0,0,0,7,0,0,0,111,0,0,0,1,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,144,9,0,0,222,0,0,0,223,0,0,0,19,0,0,0,78,0,0,0,25,0,0,0,90,0,0,0,91,0,0,0,0,0,0,0,168,9,0,0,41,0,0,0,224,0,0,0,30,0,0,0,1,0,0,0,0,0,0,0,184,9,0,0,225,0,0,0,226,0,0,0,1,0,0,0,0,0,0,0,208,9,0,0,130,0,0,0,227,0,0,0,75,0,0,0,76,0,0,0,8,0,0,0,0,0,0,0,224,9,0,0,225,0,0,0,228,0,0,0,2,0,0,0,0,0,0,0,240,9,0,0,95,0,0,0,229,0,0,0,2,0,0,0,0,0,0,0,0,10,0,0,130,0,0,0,230,0,0,0,77,0,0,0,78,0,0,0,9,0,0,0,0,0,0,0,16,10,0,0,95,0,0,0,231,0,0,0,3,0,0,0,0,0,0,0,32,10,0,0,232,0,0,0,233,0,0,0,14,0,0,0,0,0,0,0,72,10,0,0,234,0,0,0,235,0,0,0,15,0,0,0,11,0,0,0,112,0,0,0,0,0,0,0,88,10,0,0,236,0,0,0,237,0,0,0,16,0,0,0,12,0,0,0,113,0,0,0,0,0,0,0,104,10,0,0,232,0,0,0,238,0,0,0,17,0,0,0,0,0,0,0,120,10,0,0,232,0,0,0,239,0,0,0,18,0,0,0,0,0,0,0,136,10,0,0,240,0,0,0,241,0,0,0,32,0,0,0,33,0,0,0,102,0,0,0,0,0,0,0,144,10,0,0,242,0,0,0,243,0,0,0,0,0,0,0,152,10,0,0,244,0,0,0,245,0,0,0,66,0,0,0,1,0,0,0,2,0,0,0,95,0,0,0,96,0,0,0,85,0,0,0,114,0,0,0,115,0,0,0,86,0,0,0,60,0,0,0,61,0,0,0,87,0,0,0,27,0,0,0,96,100,0,0,255,255,255,255,5,0,0,0,0,0,0,0,0,0,0,0,103,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,0,0,0,35,0,0,0,157,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,184,10,0,0,246,0,0,0,247,0,0,0,248,0,0,0,249,0,0,0,36,0,0,0,4,0,0,0,19,0,0,0,71,0,0,0,0,0,0,0,200,10,0,0,246,0,0,0,250,0,0,0,248,0,0,0,249,0,0,0,36,0,0,0,5,0,0,0,20,0,0,0,72,0,0,0,0,0,0,0,240,10,0,0,251,0,0,0,252,0,0,0,104,0,0,0,0,0,0,0,32,11,0,0,246,0,0,0,253,0,0,0,248,0,0,0,249,0,0,0,36,0,0,0,6,0,0,0,21,0,0,0,73,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,55,67,108,111,115,101,115,116,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,49,56,98,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,49,51,98,116,77,111,116,105,111,110,83,116,97,116,101,0,50,48,98,116,68,101,102,97,117,108,116,77,111,116,105,111,110,83,116,97,116,101,0,50,53,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,108,108,98,97,99,107,0,49,57,98,116,71,104,111,115,116,80,97,105,114,67,97,108,108,98,97,99,107,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,52,67,108,111,115,101,115,116,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,50,57,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,123,32,118,97,114,32,115,101,108,102,32,61,32,77,111,100,117,108,101,91,39,103,101,116,67,97,99,104,101,39,93,40,77,111,100,117,108,101,91,39,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,39,93,41,91,36,48,93,59,32,105,102,32,40,33,115,101,108,102,46,104,97,115,79,119,110,80,114,111,112,101,114,116,121,40,39,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,39,41,41,32,116,104,114,111,119,32,39,97,32,74,83,73,109,112,108,101,109,101,110,116,97,116,105,111,110,32,109,117,115,116,32,105,109,112,108,101,109,101,110,116,32,97,108,108,32,102,117,110,99,116,105,111,110,115,44,32,121,111,117,32,102,111,114,103,111,116,32],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,58,58,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,46,39,59,32,114,101,116,117,114,110,32,115,101,108,102,91,39,97,100,100,83,105,110,103,108,101,82,101,115,117,108,116,39,93,40,36,49,44,36,50,44,36,51,44,36,52,44,36,53,44,36,54,44,36,55,41,59,32,125,0,50,51,98,116,68,101,102,97,117,108,116,83,111,102,116,66,111,100,121,83,111,108,118,101,114,0,49,54,98,116,83,111,102,116,66,111,100,121,83,111,108,118,101,114,0,52,49,98,116,83,111,102,116,66,111,100,121,82,105,103,105,100,66,111,100,121,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,78,50,56,98,116,83,111,102,116,83,111,102,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,51,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,67,114,101,97,116,101,70,117,110,99,0,78,50,57,98,116,83,111,102,116,82,105,103,105,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,53,98,116,83,111,102,116,66,111,100,121,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,53,98,116,83,111,102,116,66,111,100,121,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,49,48,98,116,83,111,102,116,66,111,100,121,0,83,111,102,116,66,111,100,121,77,97,116,101,114,105,97,108,68,97,116,97,0,83,111,102,116,66,111,100,121,78,111,100,101,68,97,116,97,0,83,111,102,116,66,111,100,121,76,105,110,107,68,97,116,97,0,83,111,102,116,66,111,100,121,70,97,99,101,68,97,116,97,0,83,111,102,116,66,111,100,121,84,101,116,114,97,68,97,116,97,0,83,111,102,116,82,105,103,105,100,65,110,99,104,111,114,68,97,116,97,0,102,108,111,97,116,0,83,111,102,116,66,111,100,121,80,111,115,101,68,97,116,97,0,83,111,102,116,66,111,100,121,67,108,117,115,116,101,114,68,97,116,97,0,105,110,116,0,98,116,83,111,102,116,66,111,100,121,74,111,105,110,116,68,97,116,97,0,98,116,83,111,102,116,66,111,100,121,70,108,111,97,116,68,97,116,97,0,78,49,48,98,116,83,111,102,116,66,111,100,121,49,53,82,97,121,70,114,111,109,84,111,67,97,115,116,101,114,69,0,78,54,98,116,68,98,118,116,56,73,67,111,108,108,105,100,101,69,0,78,49,48,98,116,83,111,102,116,66,111,100,121,53,74,111,105,110,116,69,0,78,49,48,98,116,83,111,102,116,66,111,100,121,54,67,74,111,105,110,116,69,0,50,52,98,116,83,111,102,116,66,111,100,121,67,111,108,108,105,115,105,111,110,83,104,97,112,101,0,83,111,102,116,66,111,100,121,0,85,112,100,97,116,101,67,108,117,115,116,101,114,115,0,83,111,102,116,66,111,100,121,32,97,112,112,108,121,70,111,114,99,101,115,0,65,112,112,108,121,67,108,117,115,116,101,114,115,0,78,49,53,98,116,83,111,102,116,67,111,108,108,105,100,101,114,115,49,51,67,111,108,108,105,100,101,83,68,70,95,82,83,69,0,78,49,53,98,116,83,111,102,116,67,111,108,108,105,100,101,114,115,49,50,67,111,108,108,105,100,101,67,76,95,82,83,69,0,78,49,53,98,116,83,111,102,116,67,111,108,108,105,100,101,114,115,49,49,67,108,117,115,116,101,114,66,97,115,101,69,0,50,55,98,116,83,111,102,116,67,108,117,115,116,101,114,67,111,108,108,105,115,105,111,110,83,104,97,112,101,0,83,79,70,84,67,76,85,83,84,69,82,0,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,68,97,116,97,0,78,49,53,98,116,83,111,102,116,67,111,108,108,105,100,101,114,115,49,50,67,111,108,108,105,100,101,67,76,95,83,83,69,0,78,49,53,98,116,83,111,102,116,67,111,108,108,105,100,101,114,115,49,50,67,111,108,108,105,100,101,86,70,95,83,83,69,0,50,57,98,116,83,111,102,116,82,105,103,105,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,51,53,98,116,83,111,102,116,66,111,100,121,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,54,98,116,83,111,102,116,66,111,100,121,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,90,78,51,53,98,116,83,111,102,116,66,111,100,121,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,50,49,99,97,108,99,117,108,97,116,101,84,105,109,101,79,102,73,109,112,97,99,116,69,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,83,49,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,51,49,76,111,99,97,108,84,114,105,97,110,103,108,101,83,112,104,101,114,101,67,97,115,116,67,97,108,108,98,97,99,107,0,78,49,50,98,116,67,111,110,118,101,120,67,97,115,116,49,48,67,97,115,116,82,101,115,117,108,116,69,0,49,53,98,116,84,114,105,97,110,103,108,101,83,104,97,112,101,0,84,114,105,97,110,103,108,101,0,50,52,98,116,83,111,102,116,82,105,103,105,100,68,121,110,97,109,105,99,115,87,111,114,108,100,0,114,97,121,84,101,115,116,0,50,51,98,116,83,111,102,116,83,105,110,103,108,101,82,97,121,67,97,108,108,98,97,99,107,0,50,51,98,116,66,114,111,97,100,112,104,97,115,101,82,97,121,67,97,108,108,98,97,99,107,0,50,52,98,116,66,114,111,97,100,112,104,97,115,101,65,97,98,98,67,97,108,108,98,97,99,107,0,112,114,101,100,105,99,116,85,110,99,111,110,115,116,114,97,105,110,116,77,111,116,105,111,110,83,111,102,116,66,111,100,121,0,115,111,108,118,101,83,111,102,116,67,111,110,115,116,114,97,105,110,116,115,0,50,56,98,116,83,111,102,116,83,111,102,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,49,49,98,116,82,105,103,105,100,66,111,100,121,0,98,116,82,105,103,105,100,66,111,100,121,70,108,111,97,116,68,97,116,97,0,50,51,98,116,68,105,115,99,114,101,116,101,68,121,110,97,109,105,99,115,87,111,114,108,100,0,49,53,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,0,100,101,98,117,103,68,114,97,119,87,111,114,108,100,0,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,70,108,111,97,116,68,97,116,97,0,115,116,101,112,83,105,109,117,108,97,116,105,111,110,0,115,121,110,99,104,114,111,110,105,122,101,77,111,116,105,111,110,83,116,97,116,101,115,0,112,114,101,100,105,99,116,85,110,99,111,110,115,116,114,97,105,110,116,77,111,116,105,111,110,0,105,110,116,101,103,114,97,116,101,84,114,97,110,115,102,111,114,109,115,0,67,67,68,32,109,111,116,105,111,110,32,99,108,97,109,112,105,110,103,0,51,52,98,116,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,97,112,112,108,121,32,115,112,101,99,117,108,97,116,105,118,101,32,99,111,110,116,97,99,116,32,114,101,115,116,105,116,117,116,105,111,110,0,99,97,108,99,117,108,97,116,101,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,115,0,115,111,108,118,101,67,111,110,115,116,114,97,105,110,116,115,0,117,112,100,97,116,101,65,99,116,105,118,97,116,105,111,110,83,116,97,116,101,0,105,110,116,101,114,110,97,108,83,105,110,103,108,101,83,116,101,112,83,105,109,117,108,97,116,105,111,110,0,99,114,101,97,116,101,80,114,101,100,105,99,116,105,118,101,67,111,110,116,97,99,116,115,0,114,101,108,101,97,115,101,32,112,114,101,100,105,99,116,105,118,101,32,99,111,110,116,97,99,116,32,109,97,110,105,102,111,108,100,115,0,112,114,101,100,105,99,116,105,118,101,32,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,117,112,100,97,116,101,65,99,116,105,111,110,115,0,50,55,73,110,112,108,97,99,101,83,111,108,118,101,114,73,115,108,97,110,100,67,97,108,108,98,97,99,107,0,78,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,49,52,73,115,108,97,110,100,67,97,108,108,98,97,99,107,69,0,50,51,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,0,49,55,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,0,49,51,98,116,84,121,112,101,100,79,98,106,101,99,116,0,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,50,57,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,67,111,110,115,116,114,97,105,110,116,0,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,50,51,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,0,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,49,56,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,0,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,50,49,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,0,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,49,55,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,0,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,51,53,98,116,83,101,113,117,101,110,116,105,97,108,73,109,112,117,108,115,101,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,49,56,98,116,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,115,111,108,118,101,71,114,111,117,112,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,83,101,116,117,112,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,73,116,101,114,97,116,105,111,110,115,0,49,54,98,116,82,97,121,99,97,115,116,86,101,104,105,99,108,101,0,49,55,98,116,65,99,116,105,111,110,73,110,116,101,114,102,97,99,101,0,50,53,98,116,68,101,102,97,117,108,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,51,48,98,116,75,105,110,101,109,97,116,105,99,67,104,97,114,97,99,116,101,114,67,111,110,116,114,111,108,108,101,114,0,51,48,98,116,67,104,97,114,97,99,116,101,114,67,111,110,116,114,111,108,108,101,114,73,110,116,101,114,102,97,99,101,0,52,51,98,116,75,105,110,101,109,97,116,105,99,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,50,50,98,116,83,117,98,115,105,109,112,108,101,120,67,111,110,118,101,120,67,97,115,116,0,49,50,98,116,67,111,110,118,101,120,67,97,115,116,0,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,0,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,70,108,111,97,116,68,97,116,97,0,49,51,98,116,71,104,111,115,116,79,98,106,101,99,116,0,50,52,98,116,80,97,105,114,67,97,99,104,105,110,103,71,104,111,115,116,79,98,106,101,99,116,0,50,49,98,116,67,111,108,108,105,115,105,111,110,68,105,115,112,97,116,99,104,101,114,0,50,51,98,116,67,111,108,108,105,115,105,111,110,80,97,105,114,67,97,108,108,98,97,99,107,0,49,55,98,116,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,51,49,98,116,68,101,102,97,117,108,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,50,52,98,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,78,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,0,105,115,108,97,110,100,85,110,105,111,110,70,105,110,100,65,110,100,81,117,105,99,107,83,111,114,116,0,112,114,111,99,101,115,115,73,115,108,97,110,100,115,0,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,52,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,90,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,50,49,99,97,108,99,117,108,97,116,101,84,105,109,101,79,102,73,109,112,97,99,116,69,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,83,49,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,51,49,76,111,99,97,108,84,114,105,97,110,103,108,101,83,112,104,101,114,101,67,97,115,116,67,97,108,108,98,97,99,107,0,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,78,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,54,82,101,115,117,108,116,69,0,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,0,117,112,100,97,116,101,65,97,98,98,115,0,1,79,118,101,114,102,108,111,119,32,105,110,32,65,65,66,66,44,32,111,98,106,101,99,116,32,114,101,109,111,118,101,100,32,102,114,111,109,32,115,105,109,117,108,97,116,105,111,110,0,73,102,32,121,111,117,32,99,97,110,32,114,101,112,114,111,100,117,99,101,32,116,104,105,115,44,32,112,108,101,97,115,101,32,101,109,97,105,108,32,98,117,103,115,64,99,111,110,116,105,110,117,111,117,115,112,104,121,115,105,99,115,46,99,111,109,10,0,80,108,101,97,115,101,32,105,110,99,108,117,100,101,32,97,98,111,118,101,32,105,110,102,111,114,109,97,116,105,111,110,44,32,121,111,117,114,32,80,108,97,116,102,111,114,109,44,32,118,101,114,115,105,111,110,32,111,102,32,79,83,46,10,0,84,104,97,110,107,115,46,10,0,99,97,108,99,117,108,97,116,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,0,49,55,68,101,98,117,103,68,114,97,119,99,97,108,108,98,97,99,107,0,49,57,98,116,83,105,110,103,108,101,82,97,121,67,97,108,108,98,97,99,107,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,57,82,97,121,84,101,115,116,101,114,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,114,97,121,84,101,115,116,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,49,53,76,111,99,97,108,73,110,102,111,65,100,100,101,114,50,0,112,101,114,102,111,114,109,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,105,111,110,0,100,105,115,112,97,116,99,104,65,108,108,67,111,108,108,105,115,105,111,110,80,97,105,114,115,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,99,111,110,118,101,120,83,119,101,101,112,67,111,109,112,111,117,110,100,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,53,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,73,110,116,101,114,110,97,108,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,49,52,76,111,99,97,108,73,110,102,111,65,100,100,101,114,0,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,50,49,98,116,83,105,110,103,108,101,83,119,101,101,112,67,97,108,108,98,97,99,107,0,50,51,98,116,83,105,110,103,108,101,67,111,110,116,97,99,116,67,97,108,108,98,97,99,107,0,50,51,98,116,66,114,105,100,103,101,100,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,49,51,98,116,68,117,109,109,121,82,101,115,117,108,116,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,75,50,52,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,87,114,97,112,112,101,114,83,50,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,50,49,98,116,87,105,116,104,111,117,116,77,97,114,103,105,110,82,101,115,117,108,116,0,50,52,98,116,80,101,114,116,117,114,98,101,100,67,111,110,116,97,99,116,82,101,115,117,108,116,0,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,50,50,98,116,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,51,54,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,51,48,98,116,67,111,109,112,111,117,110,100,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,49,53,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,0,67,111,109,112,111,117,110,100,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,67,104,105,108,100,68,97,116,97,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,68,97,116,97,0,49,49,98,116,67,111,110,101,83,104,97,112,101,0,67,111,110,101,0,98,116,67,111,110,101,83,104,97,112,101,68,97,116,97,0,49,50,98,116,67,111,110,101,83,104,97,112,101,90,0,67,111,110,101,90,0,49,50,98,116,67,111,110,101,83,104,97,112,101,88,0,67,111,110,101,88,0,49,51,98,116,83,112,104,101,114,101,83,104,97,112,101,0,83,80,72,69,82,69,0,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,66,86,72,84,82,73,65,78,71,76,69,77,69,83,72,0,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,68,97,116,97,0,90,78,75,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,50,49,98,116,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,52,112,101,114,102,111,114,109,82,97,121,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,55,112,101,114,102,111,114,109,67,111,110,118,101,120,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,83,52,95,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,84,82,73,65,78,71,76,69,77,69,83,72,0,90,78,75,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,49,54,70,105,108,116,101,114,101,100,67,97,108,108,98,97,99,107,0,50,49,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,49,56,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,0,83,84,65,84,73,67,80,76,65,78,69,0,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,68,97,116,97,0,50,51,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,83,104,97,112,101,0,51,52,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,65,97,98,98,67,97,99,104,105,110,103,83,104,97,112,101,0,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,0,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,68,97,116,97,0,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,0,50,49,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,0,49,55,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,0,67,111,110,118,101,120,0,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,68,97,116,97,0,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,51,49,98,116,73,110,116,101,114,110,97,108,84,114,105,97,110,103,108,101,73,110,100,101,120,67,97,108,108,98,97,99,107,0,49,52,98,116,67,97,112,115,117,108,101,83,104,97,112,101,0,67,97,112,115,117,108,101,83,104,97,112,101,0,98,116,67,97,112,115,117,108,101,83,104,97,112,101,68,97,116,97,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,88,0,67,97,112,115,117,108,101,88,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,90,0,67,97,112,115,117,108,101,90,0,50,53,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,67,111,110,118,101,120,84,114,105,109,101,115,104,0,50,54,76,111,99,97,108,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,49,52,98,116,67,111,110,99,97,118,101,83,104,97,112,101,0,49,48,98,116,66,111,120,83,104,97,112,101,0,66,111,120,0,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,57,81,117,97,110,116,105,122,101,100,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,48,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,50,53,98,116,72,101,105,103,104,116,102,105,101,108,100,84,101,114,114,97,105,110,83,104,97,112,101,0,72,69,73,71,72,84,70,73,69,76,68,0,49,53,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,0,67,121,108,105,110,100,101,114,89,0,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,68,97,116,97,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,88,0,67,121,108,105,110,100,101,114,88,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,90,0,67,121,108,105,110,100,101,114,90,0,49,52,98,116,84,114,105,97,110,103,108,101,77,101,115,104,0,50,48,98,116,65,120,105,115,83,119,101,101,112,51,73,110,116,101,114,110,97,108,73,116,69,0,50,49,98,116,66,114,111,97,100,112,104,97,115,101,73,110,116,101,114,102,97,99,101,0,49,53,98,116,78,117,108,108,80,97,105,114,67,97,99,104,101,0,50,50,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,49,50,98,116,65,120,105,115,83,119,101,101,112,51,0,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,51,55,114,101,109,111,118,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,67,111,110,116,97,105,110,105,110,103,80,114,111,120,121,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,56,82,101,109,111,118,101,80,97,105,114,67,97,108,108,98,97,99,107,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,49,57,99,108,101,97,110,80,114,111,120,121,70,114,111,109,80,97,105,114,115,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,55,67,108,101,97,110,80,97,105,114,67,97,108,108,98,97,99,107,0,49,54,98,116,68,98,118,116,66,114,111,97,100,112,104,97,115,101,0,49,56,98,116,68,98,118,116,84,114,101,101,67,111,108,108,105,100,101,114,0,49,57,66,114,111,97,100,112,104,97,115,101,82,97,121,84,101,115,116,101,114,0,50,48,66,114,111,97,100,112,104,97,115,101,65,97,98,98,84,101,115,116,101,114,0,49,50,98,116,68,105,115,112,97,116,99,104,101,114,0,49,52,98,116,81,117,97,110,116,105,122,101,100,66,118,104,0,98,116,79,112,116,105,109,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,98,116,66,118,104,83,117,98,116,114,101,101,73,110,102,111,68,97,116,97,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,70,108,111,97,116,68,97,116,97,0,50,53,98,116,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,50,56,98,116,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,51,48,98,116,67,111,110,118,101,120,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,90,78,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,49,50,99,97,108,99,80,101,110,68,101,112,116,104,69,82,50,50,98,116,86,111,114,111,110,111,105,83,105,109,112,108,101,120,83,111,108,118,101,114,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,83,52,95,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,55,95,82,57,98,116,86,101,99,116,111,114,51,83,57,95,83,57,95,80,49,50,98,116,73,68,101,98,117,103,68,114,97,119,69,50,48,98,116,73,110,116,101,114,109,101,100,105,97,116,101,82,101,115,117,108,116,0,51,48,98,116,71,106,107,69,112,97,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,49,53,98,116,71,106,107,67,111,110,118,101,120,67,97,115,116,0,49,54,98,116,80,111,105,110,116,67,111,108,108,101,99,116,111,114,0,50,55,98,116,67,111,110,116,105,110,117,111,117,115,67,111,110,118,101,120,67,111,108,108,105,115,105,111,110,0,49,55,98,116,71,106,107,80,97,105,114,68,101,116,101,99,116,111,114,0,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,0,51,48,98,116,65,99,116,105,118,97,116,105,110,103,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,0,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,49,54,98,116,66,111,120,66,111,120,68,101,116,101,99,116,111,114,0,50,50,83,112,104,101,114,101,84,114,105,97,110,103,108,101,68,101,116,101,99,116,111,114,0,50,51,98,116,72,97,115,104,101,100,83,105,109,112,108,101,80,97,105,114,67,97,99,104,101,0,49,56,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,0,50,54,98,116,84,114,105,97,110,103,108,101,73,110,100,101,120,86,101,114,116,101,120,65,114,114,97,121,0,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,0,98,116,73,110,116,73,110,100,101,120,68,97,116,97,0,98,116,83,104,111,114,116,73,110,116,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,98,116,67,104,97,114,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,98,116,86,101,99,116,111,114,51,70,108,111,97,116,68,97,116,97,0,98,116,86,101,99,116,111,114,51,68,111,117,98,108,101,68,97,116,97,0,98,116,77,101,115,104,80,97,114,116,68,97,116,97,0,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,68,97,116,97,0,82,111,111,116,0,17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+10240);allocate([115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,83,116,57,116,121,112,101,95,105,110,102,111,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,83,116,57,101,120,99,101,112,116,105,111,110,0,117,110,99,97,117,103,104,116,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,116,101,114,109,105,110,97,116,105,110,103,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,83,116,57,98,97,100,95,97,108,108,111,99,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+20480);var tempDoublePtr=STATICTOP;STATICTOP+=16;Module["_i64Subtract"]=_i64Subtract;function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 85:return totalMemory/PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr+" - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch."}Module["_memset"]=_memset;function ___gxx_personality_v0(){}Module["_bitshift64Shl"]=_bitshift64Shl;function _abort(){Module["abort"]()}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Runtime.dynCall("v",func);_pthread_once.seen[ptr]=1}var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}Module["_i64Add"]=_i64Add;var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}var _llvm_pow_f32=Math_pow;function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function ___cxa_allocate_exception(size){return _malloc(size)}Module["_bitshift64Ashr"]=_bitshift64Ashr;Module["_bitshift64Lshr"]=_bitshift64Lshr;function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function _pthread_cleanup_push(routine,arg){__ATEXIT__.push((function(){Runtime.dynCall("vi",routine,[arg])}));_pthread_cleanup_push.level=__ATEXIT__.length}function ___cxa_guard_acquire(variable){if(!HEAP8[variable>>0]){HEAP8[variable>>0]=1;return 1}return 0}function _pthread_cleanup_pop(){assert(_pthread_cleanup_push.level==__ATEXIT__.length,"cannot pop if something else added meanwhile!");__ATEXIT__.pop();_pthread_cleanup_push.level=__ATEXIT__.length}function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;var SYSCALLS={varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0){var success=self.alloc(bytes);if(!success)return-1>>>0}return ret}Module["_memmove"]=_memmove;function _gettimeofday(ptr){var now=Date.now();HEAP32[ptr>>2]=now/1e3|0;HEAP32[ptr+4>>2]=now%1e3*1e3|0;return 0}var _llvm_fabs_f32=Math_abs;Module["_llvm_bswap_i32"]=_llvm_bswap_i32;function _llvm_trap(){abort("trap!")}function ___cxa_guard_release(){}function _pthread_self(){return 0}function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;assert(offset_high===0);FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.get(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();var ret=0;if(!___syscall146.buffer){___syscall146.buffers=[null,[],[]];___syscall146.printChar=(function(stream,curr){var buffer=___syscall146.buffers[stream];assert(buffer);if(curr===0||curr===10){(stream===1?Module["print"]:Module["printErr"])(UTF8ArrayToString(buffer,0));buffer.length=0}else{buffer.push(curr)}})}for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];for(var j=0;j<len;j++){___syscall146.printChar(stream,HEAPU8[ptr+j])}ret+=len}return ret}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}__ATEXIT__.push((function(){var fflush=Module["_fflush"];if(fflush)fflush(0);var printChar=___syscall146.printChar;if(!printChar)return;var buffers=___syscall146.buffers;if(buffers[1].length)printChar(1,10);if(buffers[2].length)printChar(2,10)}));STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vid(index,a1,a2){try{Module["dynCall_vid"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiidii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_iiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidi(index,a1,a2,a3,a4){try{Module["dynCall_viidi"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viddiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viddiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidii(index,a1,a2,a3,a4){try{Module["dynCall_vidii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidi(index,a1,a2,a3){try{Module["dynCall_vidi"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_diiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiddddiid(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){try{Module["dynCall_viiiiddddiid"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vidd(index,a1,a2,a3){try{Module["dynCall_vidd"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiid(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiid"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiid(index,a1,a2,a3){try{return Module["dynCall_iiid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_di(index,a1){try{return Module["dynCall_di"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiidii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_diiidii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viidii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diii(index,a1,a2,a3){try{return Module["dynCall_diii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{return Module["dynCall_diiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiid(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiid"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_diiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_did(index,a1,a2){try{return Module["dynCall_did"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiidddddidi(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12){try{Module["dynCall_viiiidddddidi"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diidii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_diidii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diiii(index,a1,a2,a3,a4){try{return Module["dynCall_diiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9){try{return Module["dynCall_iiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiid(index,a1,a2,a3,a4){try{Module["dynCall_viiid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viid(index,a1,a2,a3){try{Module["dynCall_viid"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iidid(index,a1,a2,a3,a4){try{return Module["dynCall_iidid"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_viiiii":invoke_viiiii,"invoke_vid":invoke_vid,"invoke_vi":invoke_vi,"invoke_viiidii":invoke_viiidii,"invoke_vii":invoke_vii,"invoke_iiiiiiiiiii":invoke_iiiiiiiiiii,"invoke_ii":invoke_ii,"invoke_viidi":invoke_viidi,"invoke_viddiii":invoke_viddiii,"invoke_vidii":invoke_vidii,"invoke_iiiii":invoke_iiiii,"invoke_vidi":invoke_vidi,"invoke_diiiiiiii":invoke_diiiiiiii,"invoke_viiiiddddiid":invoke_viiiiddddiid,"invoke_diiiii":invoke_diiiii,"invoke_vidd":invoke_vidd,"invoke_iiii":invoke_iiii,"invoke_viiiiid":invoke_viiiiid,"invoke_viiiiii":invoke_viiiiii,"invoke_iiid":invoke_iiid,"invoke_di":invoke_di,"invoke_iiiiiii":invoke_iiiiiii,"invoke_diiidii":invoke_diiidii,"invoke_viidii":invoke_viidii,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiiiiiii":invoke_viiiiiiiii,"invoke_viiiiiiiiii":invoke_viiiiiiiiii,"invoke_iii":invoke_iii,"invoke_diii":invoke_diii,"invoke_diiiiiiiiii":invoke_diiiiiiiiii,"invoke_viiiid":invoke_viiiid,"invoke_diiiiiiiii":invoke_diiiiiiiii,"invoke_did":invoke_did,"invoke_viiiidddddidi":invoke_viiiidddddidi,"invoke_diidii":invoke_diidii,"invoke_diiii":invoke_diiii,"invoke_iiiiiiiiii":invoke_iiiiiiiiii,"invoke_viiid":invoke_viiid,"invoke_viii":invoke_viii,"invoke_v":invoke_v,"invoke_viid":invoke_viid,"invoke_iidid":invoke_iidid,"invoke_viiii":invoke_viiii,"_pthread_cleanup_pop":_pthread_cleanup_pop,"_abort":_abort,"___cxa_guard_acquire":___cxa_guard_acquire,"___gxx_personality_v0":___gxx_personality_v0,"___cxa_allocate_exception":___cxa_allocate_exception,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"___cxa_guard_release":___cxa_guard_release,"___setErrNo":___setErrNo,"_sbrk":_sbrk,"_llvm_pow_f32":_llvm_pow_f32,"___cxa_begin_catch":___cxa_begin_catch,"_emscripten_memcpy_big":_emscripten_memcpy_big,"___resumeException":___resumeException,"___cxa_find_matching_catch":___cxa_find_matching_catch,"_sysconf":_sysconf,"_pthread_getspecific":_pthread_getspecific,"_pthread_self":_pthread_self,"_llvm_fabs_f32":_llvm_fabs_f32,"_pthread_once":_pthread_once,"_llvm_trap":_llvm_trap,"_pthread_key_create":_pthread_key_create,"_emscripten_asm_const_diiiiiiii":_emscripten_asm_const_diiiiiiii,"_pthread_setspecific":_pthread_setspecific,"___cxa_throw":___cxa_throw,"___syscall6":___syscall6,"_pthread_cleanup_push":_pthread_cleanup_push,"_time":_time,"_gettimeofday":_gettimeofday,"___syscall140":___syscall140,"___cxa_pure_virtual":___cxa_pure_virtual,"___syscall146":___syscall146,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=0;var o=0;var p=0;var q=0;var r=global.NaN,s=global.Infinity;var t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;var C=0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=global.Math.floor;var N=global.Math.abs;var O=global.Math.sqrt;var P=global.Math.pow;var Q=global.Math.cos;var R=global.Math.sin;var S=global.Math.tan;var T=global.Math.acos;var U=global.Math.asin;var V=global.Math.atan;var W=global.Math.atan2;var X=global.Math.exp;var Y=global.Math.log;var Z=global.Math.ceil;var _=global.Math.imul;var $=global.Math.min;var aa=global.Math.clz32;var ba=env.abort;var ca=env.assert;var da=env.invoke_viiiii;var ea=env.invoke_vid;var fa=env.invoke_vi;var ga=env.invoke_viiidii;var ha=env.invoke_vii;var ia=env.invoke_iiiiiiiiiii;var ja=env.invoke_ii;var ka=env.invoke_viidi;var la=env.invoke_viddiii;var ma=env.invoke_vidii;var na=env.invoke_iiiii;var oa=env.invoke_vidi;var pa=env.invoke_diiiiiiii;var qa=env.invoke_viiiiddddiid;var ra=env.invoke_diiiii;var sa=env.invoke_vidd;var ta=env.invoke_iiii;var ua=env.invoke_viiiiid;var va=env.invoke_viiiiii;var wa=env.invoke_iiid;var xa=env.invoke_di;var ya=env.invoke_iiiiiii;var za=env.invoke_diiidii;var Aa=env.invoke_viidii;var Ba=env.invoke_viiiiiii;var Ca=env.invoke_viiiiiiiii;var Da=env.invoke_viiiiiiiiii;var Ea=env.invoke_iii;var Fa=env.invoke_diii;var Ga=env.invoke_diiiiiiiiii;var Ha=env.invoke_viiiid;var Ia=env.invoke_diiiiiiiii;var Ja=env.invoke_did;var Ka=env.invoke_viiiidddddidi;var La=env.invoke_diidii;var Ma=env.invoke_diiii;var Na=env.invoke_iiiiiiiiii;var Oa=env.invoke_viiid;var Pa=env.invoke_viii;var Qa=env.invoke_v;var Ra=env.invoke_viid;var Sa=env.invoke_iidid;var Ta=env.invoke_viiii;var Ua=env._pthread_cleanup_pop;var Va=env._abort;var Wa=env.___cxa_guard_acquire;var Xa=env.___gxx_personality_v0;var Ya=env.___cxa_allocate_exception;var Za=env.__ZSt18uncaught_exceptionv;var _a=env.___cxa_guard_release;var $a=env.___setErrNo;var ab=env._sbrk;var bb=env._llvm_pow_f32;var cb=env.___cxa_begin_catch;var db=env._emscripten_memcpy_big;var eb=env.___resumeException;var fb=env.___cxa_find_matching_catch;var gb=env._sysconf;var hb=env._pthread_getspecific;var ib=env._pthread_self;var jb=env._llvm_fabs_f32;var kb=env._pthread_once;var lb=env._llvm_trap;var mb=env._pthread_key_create;var nb=env._emscripten_asm_const_diiiiiiii;var ob=env._pthread_setspecific;var pb=env.___cxa_throw;var qb=env.___syscall6;var rb=env._pthread_cleanup_push;var sb=env._time;var tb=env._gettimeofday;var ub=env.___syscall140;var vb=env.___cxa_pure_virtual;var wb=env.___syscall146;var xb=0;
// EMSCRIPTEN_START_FUNCS
function Df(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,l=0,m=0,n=0.0,o=0,p=0.0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;d=i;i=i+176|0;q=c[a+68>>2]|0;c[d+128>>2]=q;o=c[a+84>>2]|0;c[d+128+4>>2]=o;m=c[a+100>>2]|0;c[d+128+8>>2]=m;g[d+128+12>>2]=0.0;l=d+128+16|0;t=c[a+72>>2]|0;c[l>>2]=t;s=c[a+88>>2]|0;c[d+128+20>>2]=s;r=c[a+104>>2]|0;c[d+128+24>>2]=r;g[d+128+28>>2]=0.0;j=d+128+32|0;w=c[a+76>>2]|0;c[j>>2]=w;v=c[a+92>>2]|0;c[d+128+36>>2]=v;u=c[a+108>>2]|0;c[d+128+40>>2]=u;g[d+128+44>>2]=0.0;p=-+g[a+116>>2];n=-+g[a+120>>2];h=-+g[a+124>>2];e=(c[k>>2]=w,+g[k>>2])*p;e=e+(c[k>>2]=v,+g[k>>2])*n;e=e+(c[k>>2]=u,+g[k>>2])*h;f=(c[k>>2]=t,+g[k>>2])*p;f=f+(c[k>>2]=s,+g[k>>2])*n;f=f+(c[k>>2]=r,+g[k>>2])*h;p=(c[k>>2]=q,+g[k>>2])*p;n=p+(c[k>>2]=o,+g[k>>2])*n;h=n+(c[k>>2]=m,+g[k>>2])*h;c[d>>2]=c[d+128>>2];c[d+4>>2]=c[d+128+4>>2];c[d+8>>2]=c[d+128+8>>2];c[d+12>>2]=c[d+128+12>>2];c[d+16>>2]=c[l>>2];c[d+16+4>>2]=c[l+4>>2];c[d+16+8>>2]=c[l+8>>2];c[d+16+12>>2]=c[l+12>>2];c[d+32>>2]=c[j>>2];c[d+32+4>>2]=c[j+4>>2];c[d+32+8>>2]=c[j+8>>2];c[d+32+12>>2]=c[j+12>>2];g[d+48>>2]=h;g[d+52>>2]=f;g[d+56>>2]=e;g[d+60>>2]=0.0;dh(d+64|0,d,a+4|0);c[b>>2]=c[d+64>>2];c[b+4>>2]=c[d+64+4>>2];c[b+8>>2]=c[d+64+8>>2];c[b+12>>2]=c[d+64+12>>2];c[b+16>>2]=c[d+64+16>>2];c[b+16+4>>2]=c[d+64+16+4>>2];c[b+16+8>>2]=c[d+64+16+8>>2];c[b+16+12>>2]=c[d+64+16+12>>2];c[b+32>>2]=c[d+64+32>>2];c[b+32+4>>2]=c[d+64+32+4>>2];c[b+32+8>>2]=c[d+64+32+8>>2];c[b+32+12>>2]=c[d+64+32+12>>2];c[b+48>>2]=c[d+64+48>>2];c[b+48+4>>2]=c[d+64+48+4>>2];c[b+48+8>>2]=c[d+64+48+8>>2];c[b+48+12>>2]=c[d+64+48+12>>2];i=d;return}function Ef(a,e,f){a=a|0;e=e|0;f=f|0;var h=0.0,i=0.0,j=0.0,k=0;si(a,e,f)|0;c[e+52>>2]=c[a+552>>2];c[e+56>>2]=c[a+556>>2];c[e+60>>2]=c[a+560>>2];c[e+64>>2]=c[a+564>>2];c[e+68>>2]=c[a+568>>2];c[e+72>>2]=c[a+572>>2];c[e+76>>2]=c[a+576>>2];c[e+80>>2]=c[a+580>>2];c[e+84>>2]=c[a+584>>2];c[e+88>>2]=c[a+588>>2];c[e+92>>2]=c[a+592>>2];c[e+96>>2]=c[a+596>>2];c[e+100>>2]=c[a+600>>2];c[e+104>>2]=c[a+604>>2];c[e+108>>2]=c[a+608>>2];c[e+112>>2]=c[a+612>>2];c[e+116>>2]=c[a+616>>2];c[e+120>>2]=c[a+620>>2];c[e+124>>2]=c[a+624>>2];c[e+128>>2]=c[a+628>>2];c[e+132>>2]=c[a+632>>2];c[e+136>>2]=c[a+636>>2];c[e+140>>2]=c[a+640>>2];c[e+144>>2]=c[a+644>>2];c[e+148>>2]=c[a+648>>2];c[e+152>>2]=c[a+652>>2];c[e+156>>2]=c[a+656>>2];c[e+160>>2]=c[a+660>>2];c[e+164>>2]=c[a+664>>2];c[e+168>>2]=c[a+668>>2];c[e+172>>2]=c[a+672>>2];c[e+176>>2]=c[a+676>>2];f=b[a+736>>1]|0;c[e+184>>2]=f&255;c[e+188>>2]=(f&65535)>>>8&65535;c[e+196>>2]=c[a+684>>2];c[e+192>>2]=c[a+680>>2];c[e+180>>2]=d[a+740>>0];i=+g[a+688>>2];j=+g[a+692>>2];h=+eh(i-j,6.2831854820251465);if(!(h<-3.1415927410125732)){if(h>3.1415927410125732)h=h+-6.2831854820251465}else h=h+6.2831854820251465;g[e+200>>2]=h;h=+eh(i+j,6.2831854820251465);if(h<-3.1415927410125732){j=h+6.2831854820251465;f=e+204|0;g[f>>2]=j;f=a+696|0;f=c[f>>2]|0;k=e+208|0;c[k>>2]=f;k=a+700|0;k=c[k>>2]|0;f=e+212|0;c[f>>2]=k;f=a+704|0;f=c[f>>2]|0;a=e+216|0;c[a>>2]=f;return 12773}if(!(h>3.1415927410125732)){j=h;k=e+204|0;g[k>>2]=j;k=a+696|0;k=c[k>>2]|0;f=e+208|0;c[f>>2]=k;f=a+700|0;f=c[f>>2]|0;k=e+212|0;c[k>>2]=f;a=a+704|0;a=c[a>>2]|0;k=e+216|0;c[k>>2]=a;return 12773}j=h+-6.2831854820251465;k=e+204|0;g[k>>2]=j;k=a+696|0;k=c[k>>2]|0;f=e+208|0;c[f>>2]=k;f=a+700|0;f=c[f>>2]|0;k=e+212|0;c[k>>2]=f;a=a+704|0;a=c[a>>2]|0;k=e+216|0;c[k>>2]=a;return 12773}function Ff(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;i=c[b+4>>2]|0;if((i|0)==(c[b+8>>2]|0)?(h=i|0?i<<1:1,(i|0)<(h|0)):0){if(!h){e=0;f=i}else{c[6435]=(c[6435]|0)+1;e=yc((h*244|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[b+4>>2]|0}if((f|0)>0){g=0;do{k=e+(g*244|0)|0;j=c[b+12>>2]|0;l=j+(g*244|0)|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=e+(g*244|0)+16|0;l=j+(g*244|0)+16|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=e+(g*244|0)+32|0;l=j+(g*244|0)+32|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];k=e+(g*244|0)+48|0;l=j+(g*244|0)+48|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];_m(e+(g*244|0)+64|0,j+(g*244|0)+64|0,180)|0;g=g+1|0}while((g|0)!=(f|0))}f=c[b+12>>2]|0;if(f|0){if(a[b+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=e;c[b+8>>2]=h;e=c[b+4>>2]|0}else e=i;c[b+4>>2]=e+1;l=c[b+12>>2]|0;c[l+(i*244|0)>>2]=c[d>>2];c[l+(i*244|0)+4>>2]=c[d+4>>2];c[l+(i*244|0)+8>>2]=c[d+8>>2];c[l+(i*244|0)+12>>2]=c[d+12>>2];c[l+(i*244|0)+16>>2]=c[d+16>>2];c[l+(i*244|0)+16+4>>2]=c[d+16+4>>2];c[l+(i*244|0)+16+8>>2]=c[d+16+8>>2];c[l+(i*244|0)+16+12>>2]=c[d+16+12>>2];c[l+(i*244|0)+32>>2]=c[d+32>>2];c[l+(i*244|0)+32+4>>2]=c[d+32+4>>2];c[l+(i*244|0)+32+8>>2]=c[d+32+8>>2];c[l+(i*244|0)+32+12>>2]=c[d+32+12>>2];c[l+(i*244|0)+48>>2]=c[d+48>>2];c[l+(i*244|0)+48+4>>2]=c[d+48+4>>2];c[l+(i*244|0)+48+8>>2]=c[d+48+8>>2];c[l+(i*244|0)+48+12>>2]=c[d+48+12>>2];_m(l+(i*244|0)+64|0,d+64|0,180)|0;return (c[b+12>>2]|0)+(i*244|0)|0}function Gf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0;l=i;i=i+64|0;n=+g[a+20>>2];u=+g[a+40>>2];p=+g[a+24>>2];s=+g[a+36>>2];t=+g[a+32>>2];m=+g[a+16>>2];k=+g[a>>2];j=+g[a+4>>2];q=+g[a+8>>2];h=1.0/((n*u-p*s)*k+j*(p*t-u*m)+(s*m-n*t)*q);z=+g[b>>2];y=+g[b+4>>2];A=+g[b+8>>2];x=+g[b+16>>2];w=+g[b+20>>2];v=+g[b+24>>2];r=+g[b+32>>2];o=+g[b+36>>2];f=+g[b+40>>2];g[l+16>>2]=A*(s*m-n*t)*h+(z*(n*u-p*s)*h+y*(p*t-u*m)*h);g[l+16+4>>2]=A*(t*j-s*k)*h+(z*(s*q-u*j)*h+y*(u*k-t*q)*h);g[l+16+8>>2]=A*(n*k-m*j)*h+(z*(p*j-n*q)*h+y*(m*q-p*k)*h);g[l+16+12>>2]=0.0;g[l+16+16>>2]=(n*u-p*s)*h*x+(p*t-u*m)*h*w+(s*m-n*t)*h*v;g[l+16+20>>2]=(s*q-u*j)*h*x+(u*k-t*q)*h*w+(t*j-s*k)*h*v;g[l+16+24>>2]=(p*j-n*q)*h*x+(m*q-p*k)*h*w+(n*k-m*j)*h*v;g[l+16+28>>2]=0.0;g[l+16+32>>2]=(n*u-p*s)*h*r+(p*t-u*m)*h*o+(s*m-n*t)*h*f;g[l+16+36>>2]=(s*q-u*j)*h*r+(u*k-t*q)*h*o+(t*j-s*k)*h*f;g[l+16+40>>2]=(p*j-n*q)*h*r+(m*q-p*k)*h*o+(n*k-m*j)*h*f;g[l+16+44>>2]=0.0;Wg(l+16|0,l);f=+g[l>>2];h=+g[l+4>>2];j=+g[l+8>>2];m=+g[l+12>>2];k=1.0/+O(+(f*f+h*h+j*j+m*m));g[l>>2]=f*k;g[l+4>>2]=h*k;g[l+8>>2]=j*k;g[l+12>>2]=m*k;m=m*k<-1.0?-1.0:m*k;g[e>>2]=+T(+(m>1.0?1.0:m))*2.0;g[d>>2]=f*k;g[d+4>>2]=h*k;g[d+8>>2]=j*k;g[d+12>>2]=0.0;if(f*k*f*k+h*k*h*k+j*k*j*k<1.4210854715202004e-14){c[d>>2]=1065353216;c[d+4>>2]=0;c[d+8>>2]=0;g[d+12>>2]=0.0;i=l;return}else{A=1.0/+O(+(f*k*f*k+h*k*h*k+j*k*j*k));g[d>>2]=f*k*A;g[d+4>>2]=A*h*k;g[d+8>>2]=A*j*k;i=l;return}}function Hf(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;i=c[b+12>>2]|0;j=c[b+36>>2]|0;if((i|0)<=(j|0))return;if((i|0)>=(j|0)){do if((c[b+40>>2]|0)<(i|0)){if(!i){d=0;e=j}else{c[6435]=(c[6435]|0)+1;d=yc((i<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+36>>2]|0}f=c[b+44>>2]|0;if((e|0)<=0){if(!f){a[b+48>>0]=1;c[b+44>>2]=d;c[b+40>>2]=i;break}}else{g=0;do{c[d+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}if(a[b+48>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}a[b+48>>0]=1;c[b+44>>2]=d;c[b+40>>2]=i}else d=c[b+44>>2]|0;while(0);Qn(d+(j<<2)|0,0,i-j<<2|0)|0}c[b+36>>2]=i;h=c[b+56>>2]|0;if((i|0)>(h|0)){do if((c[b+60>>2]|0)<(i|0)){if(!i){d=0;e=h}else{c[6435]=(c[6435]|0)+1;d=yc((i<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+56>>2]|0}f=c[b+64>>2]|0;if((e|0)<=0){if(!f){a[b+68>>0]=1;c[b+64>>2]=d;c[b+60>>2]=i;break}}else{g=0;do{c[d+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}if(a[b+68>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}a[b+68>>0]=1;c[b+64>>2]=d;c[b+60>>2]=i}else d=c[b+64>>2]|0;while(0);Qn(d+(h<<2)|0,0,i-h<<2|0)|0}c[b+56>>2]=i;if((i|0)>0){Qn(c[b+44>>2]|0,-1,i<<2|0)|0;Qn(c[b+64>>2]|0,-1,i<<2|0)|0}if((j|0)<=0)return;d=c[b+16>>2]|0;e=c[b+44>>2]|0;f=c[b+64>>2]|0;g=0;do{i=c[(c[d+(g<<4)+4>>2]|0)+12>>2]<<16|c[(c[d+(g<<4)>>2]|0)+12>>2];i=(i+~(i<<15)>>10^i+~(i<<15))*9|0;i=e+((((i>>6^i)+~((i>>6^i)<<11)>>16^(i>>6^i)+~((i>>6^i)<<11))&(c[b+12>>2]|0)+-1)<<2)|0;c[f+(g<<2)>>2]=c[i>>2];c[i>>2]=g;g=g+1|0}while((g|0)!=(j|0));return}function If(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((c[b+8>>2]|0)>=(d|0))return;if((d|0)!=0?(c[6435]=(c[6435]|0)+1,e=yc((d*36|3)+16|0)|0,(e|0)!=0):0){c[(e+4+15&-16)+-4>>2]=e;o=e+4+15&-16}else o=0;i=c[b+4>>2]|0;if((i|0)>0){m=0;do{j=o+(m*36|0)|0;k=c[b+12>>2]|0;a[j+16>>0]=1;c[j+12>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;l=c[k+(m*36|0)+4>>2]|0;if((l|0)>0){c[6435]=(c[6435]|0)+1;e=yc((l<<2|3)+16|0)|0;if(!e)h=0;else{c[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}g=c[j+4>>2]|0;f=c[j+12>>2]|0;if((g|0)<=0)if(!f){a[j+16>>0]=1;c[j+12>>2]=h;c[j+8>>2]=l;Qn(h|0,0,l<<2|0)|0}else n=14;else{e=0;do{c[h+(e<<2)>>2]=c[f+(e<<2)>>2];e=e+1|0}while((e|0)!=(g|0));n=14}if((n|0)==14){n=0;if(a[j+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}a[j+16>>0]=1;c[j+12>>2]=h;c[j+8>>2]=l;Qn(h|0,0,l<<2|0)|0}e=c[j+12>>2]|0;c[j+4>>2]=l;f=c[k+(m*36|0)+12>>2]|0;g=0;do{c[e+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(l|0))}else c[j+4>>2]=l;l=k+(m*36|0)+20|0;c[j+20>>2]=c[l>>2];c[j+20+4>>2]=c[l+4>>2];c[j+20+8>>2]=c[l+8>>2];c[j+20+12>>2]=c[l+12>>2];m=m+1|0}while((m|0)!=(i|0));e=c[b+4>>2]|0;if((e|0)>0){k=0;do{g=c[b+12>>2]|0;h=g+(k*36|0)+4|0;i=g+(k*36|0)+12|0;j=c[i>>2]|0;f=g+(k*36|0)+16|0;if(j|0){if(a[f>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[i>>2]=0}a[f>>0]=1;c[i>>2]=0;c[h>>2]=0;c[g+(k*36|0)+8>>2]=0;k=k+1|0}while((k|0)!=(e|0))}}e=c[b+12>>2]|0;if(e|0){if(a[b+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=o;c[b+8>>2]=d;return}function Jf(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;c[b+4>>2]=4;c[b>>2]=4432;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=d;Il();c[b+32>>2]=23268;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=4704;c[b+552>>2]=c[e>>2];c[b+552+4>>2]=c[e+4>>2];c[b+552+8>>2]=c[e+8>>2];c[b+552+12>>2]=c[e+12>>2];c[b+568>>2]=c[e+16>>2];c[b+568+4>>2]=c[e+16+4>>2];c[b+568+8>>2]=c[e+16+8>>2];c[b+568+12>>2]=c[e+16+12>>2];c[b+584>>2]=c[e+32>>2];c[b+584+4>>2]=c[e+32+4>>2];c[b+584+8>>2]=c[e+32+8>>2];c[b+584+12>>2]=c[e+32+12>>2];c[b+600>>2]=c[e+48>>2];c[b+600+4>>2]=c[e+48+4>>2];c[b+600+8>>2]=c[e+48+8>>2];c[b+600+12>>2]=c[e+48+12>>2];c[b+616>>2]=c[e>>2];c[b+616+4>>2]=c[e+4>>2];c[b+616+8>>2]=c[e+8>>2];c[b+616+12>>2]=c[e+12>>2];c[b+632>>2]=c[e+16>>2];c[b+632+4>>2]=c[e+16+4>>2];c[b+632+8>>2]=c[e+16+8>>2];c[b+632+12>>2]=c[e+16+12>>2];c[b+648>>2]=c[e+32>>2];c[b+648+4>>2]=c[e+32+4>>2];c[b+648+8>>2]=c[e+32+8>>2];c[b+648+12>>2]=c[e+32+12>>2];c[b+664>>2]=c[e+48>>2];c[b+664+4>>2]=c[e+48+4>>2];c[b+664+8>>2]=c[e+48+8>>2];c[b+664+12>>2]=c[e+48+12>>2];g[b+688>>2]=0.0;g[b+692>>2]=-1.0;g[b+696>>2]=.8999999761581421;g[b+700>>2]=.30000001192092896;g[b+704>>2]=1.0;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;a[b+736>>0]=0;a[b+737>>0]=0;a[b+738>>0]=0;a[b+739>>0]=1;a[b+740>>0]=f&1;c[b+748>>2]=0;e=c[b+28>>2]|0;l=+g[b+600>>2];k=+g[b+604>>2];j=+g[b+608>>2];i=l*+g[e+20>>2]+k*+g[e+24>>2]+j*+g[e+28>>2]+ +g[e+56>>2];h=l*+g[e+36>>2]+k*+g[e+40>>2]+j*+g[e+44>>2]+ +g[e+60>>2];g[b+664>>2]=l*+g[e+4>>2]+k*+g[e+8>>2]+j*+g[e+12>>2]+ +g[e+52>>2];g[b+668>>2]=i;g[b+672>>2]=h;g[b+676>>2]=0.0;g[b+732>>2]=f?-1.0:1.0;return}function Kf(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;i=c[b+12>>2]|0;j=c[b+32>>2]|0;if((i|0)<=(j|0))return;if((i|0)>=(j|0)){do if((c[b+36>>2]|0)<(i|0)){if(!i){d=0;e=j}else{c[6435]=(c[6435]|0)+1;d=yc((i<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+32>>2]|0}f=c[b+40>>2]|0;if((e|0)<=0){if(!f){a[b+44>>0]=1;c[b+40>>2]=d;c[b+36>>2]=i;break}}else{g=0;do{c[d+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}if(a[b+44>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}a[b+44>>0]=1;c[b+40>>2]=d;c[b+36>>2]=i}else d=c[b+40>>2]|0;while(0);Qn(d+(j<<2)|0,0,i-j<<2|0)|0}c[b+32>>2]=i;h=c[b+52>>2]|0;if((i|0)>(h|0)){do if((c[b+56>>2]|0)<(i|0)){if(!i){d=0;e=h}else{c[6435]=(c[6435]|0)+1;d=yc((i<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+52>>2]|0}f=c[b+60>>2]|0;if((e|0)<=0){if(!f){a[b+64>>0]=1;c[b+60>>2]=d;c[b+56>>2]=i;break}}else{g=0;do{c[d+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(e|0))}if(a[b+64>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}a[b+64>>0]=1;c[b+60>>2]=d;c[b+56>>2]=i}else d=c[b+60>>2]|0;while(0);Qn(d+(h<<2)|0,0,i-h<<2|0)|0}c[b+52>>2]=i;if((i|0)>0){Qn(c[b+40>>2]|0,-1,i<<2|0)|0;Qn(c[b+60>>2]|0,-1,i<<2|0)|0}if((j|0)<=0)return;d=c[b+16>>2]|0;e=c[b+40>>2]|0;f=c[b+60>>2]|0;g=0;do{i=c[d+(g*12|0)+4>>2]<<16|c[d+(g*12|0)>>2];i=(i+~(i<<15)>>10^i+~(i<<15))*9|0;i=e+((((i>>6^i)+~((i>>6^i)<<11)>>16^(i>>6^i)+~((i>>6^i)<<11))&(c[b+12>>2]|0)+-1)<<2)|0;c[f+(g<<2)>>2]=c[i>>2];c[i>>2]=g;g=g+1|0}while((g|0)!=(j|0));return}function Lf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e=Zb[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;g=Zb[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=g;if(g|0)Cb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+20>>2]=c[a+72>>2];e=c[a+16>>2]|0;c[b+16>>2]=e;c[b+12>>2]=0;if(!e)return 16387;g=Ob[c[(c[d>>2]|0)+16>>2]&63](d,76,e)|0;e=c[g+8>>2]|0;c[b+12>>2]=Zb[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;if((c[b+16>>2]|0)>0){f=0;while(1){h=c[a+24>>2]|0;c[e+72>>2]=c[h+(f*80|0)+72>>2];c[e+64>>2]=Zb[c[(c[d>>2]|0)+28>>2]&31](d,c[h+(f*80|0)+64>>2]|0)|0;if(!(Zb[c[(c[d>>2]|0)+24>>2]&31](d,c[(c[a+24>>2]|0)+(f*80|0)+64>>2]|0)|0)){h=c[(c[d>>2]|0)+16>>2]|0;i=c[(c[a+24>>2]|0)+(f*80|0)+64>>2]|0;i=Eb[c[(c[i>>2]|0)+52>>2]&127](i)|0;i=Ob[h&63](d,i,1)|0;h=c[(c[a+24>>2]|0)+(f*80|0)+64>>2]|0;h=Ob[c[(c[h>>2]|0)+56>>2]&63](h,c[i+8>>2]|0,d)|0;yb[c[(c[d>>2]|0)+20>>2]&31](d,i,h,1346455635,c[(c[a+24>>2]|0)+(f*80|0)+64>>2]|0)}i=c[a+24>>2]|0;c[e+68>>2]=c[i+(f*80|0)+68>>2];c[e>>2]=c[i+(f*80|0)>>2];c[e+4>>2]=c[i+(f*80|0)+4>>2];c[e+8>>2]=c[i+(f*80|0)+8>>2];c[e+12>>2]=c[i+(f*80|0)+12>>2];c[e+16>>2]=c[i+(f*80|0)+16>>2];c[e+20>>2]=c[i+(f*80|0)+20>>2];c[e+24>>2]=c[i+(f*80|0)+24>>2];c[e+28>>2]=c[i+(f*80|0)+28>>2];c[e+32>>2]=c[i+(f*80|0)+32>>2];c[e+36>>2]=c[i+(f*80|0)+36>>2];c[e+40>>2]=c[i+(f*80|0)+40>>2];c[e+44>>2]=c[i+(f*80|0)+44>>2];c[e+48>>2]=c[i+(f*80|0)+48>>2];c[e+52>>2]=c[i+(f*80|0)+52>>2];c[e+56>>2]=c[i+(f*80|0)+56>>2];c[e+60>>2]=c[i+(f*80|0)+60>>2];f=f+1|0;if((f|0)>=(c[b+16>>2]|0)){e=d;break}else e=e+76|0}}else e=d;yb[c[(c[e>>2]|0)+20>>2]&31](d,g,16362,1497453121,c[g+8>>2]|0);return 16387}function Mf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0;f=i;i=i+256|0;c[f+32>>2]=5736;l=f+32+36|0;c[l>>2]=c[b>>2];c[l+4>>2]=c[b+4>>2];c[l+8>>2]=c[b+8>>2];c[l+12>>2]=c[b+12>>2];m=f+32+52|0;c[m>>2]=c[d>>2];c[m+4>>2]=c[d+4>>2];c[m+8>>2]=c[d+8>>2];c[m+12>>2]=c[d+12>>2];c[f+32+212>>2]=a;c[f+32+216>>2]=e;c[f+32+68>>2]=1065353216;c[f+32+72>>2]=0;c[f+32+72+4>>2]=0;c[f+32+72+8>>2]=0;c[f+32+72+12>>2]=0;c[f+32+88>>2]=1065353216;c[f+32+92>>2]=0;c[f+32+92+4>>2]=0;c[f+32+92+8>>2]=0;c[f+32+92+12>>2]=0;c[f+32+108>>2]=1065353216;c[f+32+112>>2]=0;c[f+32+116>>2]=c[l>>2];c[f+32+116+4>>2]=c[l+4>>2];c[f+32+116+8>>2]=c[l+8>>2];c[f+32+116+12>>2]=c[l+12>>2];c[f+32+132>>2]=1065353216;c[f+32+136>>2]=0;c[f+32+136+4>>2]=0;c[f+32+136+8>>2]=0;c[f+32+136+12>>2]=0;c[f+32+152>>2]=1065353216;c[f+32+156>>2]=0;c[f+32+156+4>>2]=0;c[f+32+156+8>>2]=0;c[f+32+156+12>>2]=0;c[f+32+172>>2]=1065353216;c[f+32+176>>2]=0;c[f+32+180>>2]=c[d>>2];c[f+32+180+4>>2]=c[d+4>>2];c[f+32+180+8>>2]=c[d+8>>2];c[f+32+180+12>>2]=c[d+12>>2];n=+g[d>>2]-+g[b>>2];k=+g[d+4>>2]-+g[b+4>>2];j=+g[d+8>>2]-+g[b+8>>2];h=1.0/+O(+(n*n+k*k+j*j));q=n*h==0.0?999999984306749440.0:1.0/(n*h);g[f+32+4>>2]=q;p=k*h==0.0?999999984306749440.0:1.0/(k*h);g[f+32+8>>2]=p;o=j*h==0.0?999999984306749440.0:1.0/(j*h);g[f+32+12>>2]=o;c[f+32+20>>2]=q<0.0&1;c[f+32+24>>2]=p<0.0&1;c[f+32+28>>2]=o<0.0&1;g[f+32+32>>2]=n*h*(+g[m>>2]-+g[l>>2])+k*h*(+g[f+32+56>>2]-+g[f+32+40>>2])+j*h*(+g[f+32+60>>2]-+g[f+32+44>>2]);a=c[a+68>>2]|0;e=c[(c[a>>2]|0)+24>>2]|0;c[f+16>>2]=0;c[f+16+4>>2]=0;c[f+16+8>>2]=0;c[f+16+12>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;Qb[e&7](a,b,d,f+32|0,f+16|0,f);i=f;return}function Nf(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0;q=i;i=i+80|0;g[q+16+60>>2]=0.0;g[q+16+8>>2]=0.0;g[q+16+12>>2]=.10000000149011612;g[q+16+16>>2]=300.0;g[q+16>>2]=1.0;g[q+16+4>>2]=-1.0;g[q+16+28>>2]=0.0;g[q+16+32>>2]=.20000000298023224;g[q+16+36>>2]=0.0;g[q+16+40>>2]=0.0;g[q+16+20>>2]=1.0;g[q+16+24>>2]=.5;c[q+16+56>>2]=0;g[q+16+48>>2]=0.0;a[q+16+44>>0]=0;p=0;do{n=c[b+856+(p<<2)>>2]|0;o=a[b+788+p>>0]|0;if(!((n|0)==0&o<<24>>24==0)){g[q+16+40>>2]=0.0;c[q+16+56>>2]=n;c[q+16+52>>2]=c[b+840+(p<<2)>>2];c[q+16+48>>2]=c[b+824+(p<<2)>>2];c[q+16+20>>2]=c[b+732>>2];a[q+16+44>>0]=o;c[q+16+4>>2]=c[b+696+(p<<2)>>2];c[q+16+24>>2]=c[b+728>>2];c[q+16>>2]=c[b+680+(p<<2)>>2];g[q+16+16>>2]=0.0;c[q+16+12>>2]=c[b+808+(p<<2)>>2];c[q+16+8>>2]=c[b+792+(p<<2)>>2];c[q>>2]=c[b+1064+(p<<2)>>2];c[q+4>>2]=c[b+1080+(p<<2)>>2];c[q+8>>2]=c[b+1096+(p<<2)>>2];g[q+12>>2]=0.0;o=c[b+1304>>2]>>p*3;if(!(o&1))n=c[d+32>>2]|0;else n=b+740+(p<<2)|0;c[q+16+28>>2]=c[n>>2];if(!(o&2))n=c[d+32>>2]|0;else n=b+772+(p<<2)|0;c[q+16+36>>2]=c[n>>2];c[q+16+32>>2]=c[((o&4|0)==0?d+4|0:b+756+(p<<2)|0)>>2];if(!(a[b+1301>>0]|0))n=Dd(b,q+16|0,f,h,j,k,l,m,d,e,q,0,0)|0;else{o=p+1|0;if(!(c[b+868+(((o|0)==3?0:o)<<6)+56>>2]|0))n=1;else n=(c[b+868+(((p+2|0)%3|0)<<6)+56>>2]|0)==0&1;n=Dd(b,q+16|0,f,h,j,k,l,m,d,e,q,0,n)|0}e=n+e|0}p=p+1|0}while((p|0)!=3);i=q;return e|0}function Of(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;h=i;i=i+128|0;if(!b){i=h;return}if(c[b+40>>2]|0){Of(a,c[b+36>>2]|0,d+1|0,e,f);Of(a,c[b+40>>2]|0,d+1|0,e,f)}if((d|0)<0){i=h;return}m=+g[b>>2];r=+g[b+16>>2];k=+g[b+4>>2];q=+g[b+20>>2];j=+g[b+8>>2];p=+g[b+24>>2];l=(m+r)*.5-(r-m)*.5;n=(k+q)*.5-(q-k)*.5;o=(j+p)*.5-(p-j)*.5;m=(m+r)*.5+(r-m)*.5;k=(k+q)*.5+(q-k)*.5;j=(j+p)*.5+(p-j)*.5;b=(c[b+40>>2]|0)==0?f:e;g[h>>2]=l;g[h+4>>2]=n;g[h+8>>2]=o;g[h+12>>2]=0.0;g[h+16>>2]=m;g[h+20>>2]=n;g[h+24>>2]=o;g[h+28>>2]=0.0;g[h+32>>2]=m;g[h+36>>2]=k;g[h+40>>2]=o;g[h+44>>2]=0.0;g[h+48>>2]=l;g[h+52>>2]=k;g[h+56>>2]=o;g[h+60>>2]=0.0;g[h+64>>2]=l;g[h+68>>2]=n;g[h+72>>2]=j;g[h+76>>2]=0.0;g[h+80>>2]=m;g[h+84>>2]=n;g[h+88>>2]=j;g[h+92>>2]=0.0;g[h+96>>2]=m;g[h+100>>2]=k;g[h+104>>2]=j;g[h+108>>2]=0.0;g[h+112>>2]=l;g[h+116>>2]=k;g[h+120>>2]=j;g[h+124>>2]=0.0;mc[c[(c[a>>2]|0)+8>>2]&127](a,h,h+16|0,b);mc[c[(c[a>>2]|0)+8>>2]&127](a,h+16|0,h+32|0,b);mc[c[(c[a>>2]|0)+8>>2]&127](a,h+32|0,h+48|0,b);mc[c[(c[a>>2]|0)+8>>2]&127](a,h+48|0,h,b);mc[c[(c[a>>2]|0)+8>>2]&127](a,h+64|0,h+80|0,b);mc[c[(c[a>>2]|0)+8>>2]&127](a,h+80|0,h+96|0,b);mc[c[(c[a>>2]|0)+8>>2]&127](a,h+96|0,h+112|0,b);mc[c[(c[a>>2]|0)+8>>2]&127](a,h+112|0,h+64|0,b);mc[c[(c[a>>2]|0)+8>>2]&127](a,h,h+64|0,b);mc[c[(c[a>>2]|0)+8>>2]&127](a,h+16|0,h+80|0,b);mc[c[(c[a>>2]|0)+8>>2]&127](a,h+32|0,h+96|0,b);mc[c[(c[a>>2]|0)+8>>2]&127](a,h+48|0,h+112|0,b);i=h;return}function Pf(a,b,c,d,e,f,h,i){a=a|0;b=+b;c=+c;d=+d;e=e|0;f=+f;h=+h;i=+i;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;z=+g[e>>2];y=+g[e+16>>2];x=+g[e+32>>2];w=+g[e+4>>2];v=+g[e+20>>2];u=+g[e+36>>2];t=+g[e+8>>2];s=+g[e+24>>2];r=+g[e+40>>2];j=d-((z*0.0+y*-i+x*h)*0.0+(w*0.0+v*-i+u*h)*i+(t*0.0+s*-i+r*h)*-h)+c;o=0.0-((z*0.0+y*-i+x*h)*-i+(w*0.0+v*-i+u*h)*0.0+(t*0.0+s*-i+r*h)*f)+0.0;l=0.0-((z*0.0+y*-i+x*h)*h+(w*0.0+v*-i+u*h)*-f+(t*0.0+s*-i+r*h)*0.0)+0.0;m=0.0-((z*i+y*0.0+x*-f)*0.0+(w*i+v*0.0+u*-f)*i+(t*i+s*0.0+r*-f)*-h)+0.0;n=d-((z*i+y*0.0+x*-f)*-i+(w*i+v*0.0+u*-f)*0.0+(t*i+s*0.0+r*-f)*f)+c;k=0.0-((z*i+y*0.0+x*-f)*h+(w*i+v*0.0+u*-f)*-f+(t*i+s*0.0+r*-f)*0.0)+0.0;p=0.0-((z*-h+y*f+x*0.0)*0.0+(w*-h+v*f+u*0.0)*i+(t*-h+s*f+r*0.0)*-h)+0.0;q=0.0-((z*-h+y*f+x*0.0)*-i+(w*-h+v*f+u*0.0)*0.0+(t*-h+s*f+r*0.0)*f)+0.0;h=d-((z*-h+y*f+x*0.0)*h+(w*-h+v*f+u*0.0)*-f+(t*-h+s*f+r*0.0)*0.0)+c;i=1.0/(l*(q*m-n*p)+(j*(n*h-k*q)+o*(k*p-h*m)));g[a>>2]=(q*m-n*p)*i*0.0+(1.0/b*(n*h-k*q)*i+(k*p-h*m)*i*0.0);g[a+4>>2]=(p*o-q*j)*i*0.0+(1.0/b*(q*l-h*o)*i+(h*j-p*l)*i*0.0);g[a+8>>2]=(n*j-m*o)*i*0.0+(1.0/b*(k*o-n*l)*i+(m*l-k*j)*i*0.0);g[a+12>>2]=0.0;g[a+16>>2]=(q*m-n*p)*i*0.0+((n*h-k*q)*i*0.0+1.0/b*(k*p-h*m)*i);g[a+20>>2]=(p*o-q*j)*i*0.0+((q*l-h*o)*i*0.0+1.0/b*(h*j-p*l)*i);g[a+24>>2]=(n*j-m*o)*i*0.0+((k*o-n*l)*i*0.0+1.0/b*(m*l-k*j)*i);g[a+28>>2]=0.0;g[a+32>>2]=1.0/b*(q*m-n*p)*i+((n*h-k*q)*i*0.0+(k*p-h*m)*i*0.0);g[a+36>>2]=1.0/b*(p*o-q*j)*i+((q*l-h*o)*i*0.0+(h*j-p*l)*i*0.0);g[a+40>>2]=1.0/b*(n*j-m*o)*i+((k*o-n*l)*i*0.0+(m*l-k*j)*i*0.0);g[a+44>>2]=0.0;return}function Qf(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0;r=i;i=i+96|0;m=r;n=m+96|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(n|0));if(!j)q=c[c[b+880>>2]>>2]|0;else q=j;j=c[b+772>>2]|0;if((j|0)==(c[b+776>>2]|0)?(p=j|0?j<<1:1,(j|0)<(p|0)):0){if(!p)o=0;else{c[6435]=(c[6435]|0)+1;j=yc((p*104|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}o=j;j=c[b+772>>2]|0}if((j|0)>0){k=0;do{m=o+(k*104|0)|0;l=(c[b+780>>2]|0)+(k*104|0)|0;n=m+104|0;do{c[m>>2]=c[l>>2];m=m+4|0;l=l+4|0}while((m|0)<(n|0));k=k+1|0}while((k|0)!=(j|0))}j=c[b+780>>2]|0;if(j|0){if(a[b+784>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[b+780>>2]=0}a[b+784>>0]=1;c[b+780>>2]=o;c[b+776>>2]=p;j=c[b+772>>2]|0}m=c[b+780>>2]|0;c[m+(j*104|0)>>2]=0;c[m+(j*104|0)+4>>2]=q;m=m+(j*104|0)+8|0;l=r;n=m+96|0;do{c[m>>2]=c[l>>2];m=m+4|0;l=l+4|0}while((m|0)<(n|0));q=c[b+772>>2]|0;c[b+772>>2]=q+1;p=c[b+780>>2]|0;l=c[b+720>>2]|0;c[p+(q*104|0)+8>>2]=l+(d*104|0);o=c[b+720>>2]|0;c[p+(q*104|0)+12>>2]=o+(e*104|0);m=c[b+720>>2]|0;c[p+(q*104|0)+16>>2]=m+(f*104|0);n=c[b+720>>2]|0;c[p+(q*104|0)+20>>2]=n+(h*104|0);z=+g[l+(d*104|0)+8>>2];w=+g[l+(d*104|0)+12>>2];A=+g[l+(d*104|0)+16>>2];t=+g[m+(f*104|0)+8>>2]-z;y=+g[m+(f*104|0)+12>>2]-w;v=+g[m+(f*104|0)+16>>2]-A;u=+g[n+(h*104|0)+8>>2]-z;x=+g[n+(h*104|0)+12>>2]-w;s=+g[n+(h*104|0)+16>>2]-A;g[p+(q*104|0)+24>>2]=(+g[o+(e*104|0)+16>>2]-A)*(t*x-y*u)+((+g[o+(e*104|0)+8>>2]-z)*(y*s-v*x)+(+g[o+(e*104|0)+12>>2]-w)*(v*u-t*s));a[b+924>>0]=1;i=r;return}function Rf(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0;q=i;i=i+48|0;p=c[b+720>>2]|0;a:do if(h?(l=c[b+732>>2]|0,(l|0)>0):0){j=c[b+740>>2]|0;k=0;while(1){h=c[j+(k*52|0)+8>>2]|0;if((h|0)==(p+(d*104|0)|0)?(c[j+(k*52|0)+12>>2]|0)==(p+(e*104|0)|0):0){h=25;break}if((h|0)==(p+(e*104|0)|0)?(c[j+(k*52|0)+12>>2]|0)==(p+(d*104|0)|0):0){h=25;break}k=k+1|0;if((k|0)>=(l|0))break a}if((h|0)==25){i=q;return}}while(0);l=q;m=l+44|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(m|0));if(!f)n=c[c[b+880>>2]>>2]|0;else n=f;h=c[b+732>>2]|0;if((h|0)==(c[b+736>>2]|0)?(o=h|0?h<<1:1,(h|0)<(o|0)):0){if(!o)f=0;else{c[6435]=(c[6435]|0)+1;h=yc((o*52|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}f=h;h=c[b+732>>2]|0}if((h|0)>0){j=0;do{l=f+(j*52|0)|0;k=(c[b+740>>2]|0)+(j*52|0)|0;m=l+52|0;do{c[l>>2]=c[k>>2];l=l+4|0;k=k+4|0}while((l|0)<(m|0));j=j+1|0}while((j|0)!=(h|0))}h=c[b+740>>2]|0;if(h|0){if(a[b+744>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[b+740>>2]=0}a[b+744>>0]=1;c[b+740>>2]=f;c[b+736>>2]=o;h=c[b+732>>2]|0}l=c[b+740>>2]|0;c[l+(h*52|0)>>2]=0;c[l+(h*52|0)+4>>2]=n;l=l+(h*52|0)+8|0;k=q;m=l+44|0;do{c[l>>2]=c[k>>2];l=l+4|0;k=k+4|0}while((l|0)<(m|0));o=c[b+732>>2]|0;c[b+732>>2]=o+1;n=c[b+740>>2]|0;c[n+(o*52|0)+8>>2]=p+(d*104|0);c[n+(o*52|0)+12>>2]=p+(e*104|0);t=+g[p+(d*104|0)+8>>2]-+g[p+(e*104|0)+8>>2];s=+g[p+(d*104|0)+12>>2]-+g[p+(e*104|0)+12>>2];r=+g[p+(d*104|0)+16>>2]-+g[p+(e*104|0)+16>>2];g[n+(o*52|0)+16>>2]=+O(+(t*t+s*s+r*r));a[b+924>>0]=1;i=q;return}function Sf(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0;f=i;i=i+784|0;c[f+712>>2]=1065353216;c[f+712+4>>2]=0;c[f+712+4+4>>2]=0;c[f+712+4+8>>2]=0;c[f+712+4+12>>2]=0;c[f+712+20>>2]=1065353216;c[f+712+24>>2]=0;c[f+712+24+4>>2]=0;c[f+712+24+8>>2]=0;c[f+712+24+12>>2]=0;c[f+712+40>>2]=1065353216;e=f+712+44|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[f+536>>2]=3708;c[f+536+168>>2]=0;g[f+536+172>>2]=0.0;c[f+536+164>>2]=c[b+200>>2];e=c[b+196>>2]|0;c[f+480+8>>2]=0;c[f+480+12>>2]=1065353216;c[f+480+16>>2]=1065353216;c[f+480+20>>2]=1065353216;g[f+480+24>>2]=0.0;c[f+480>>2]=6672;c[f+480+4>>2]=8;c[f+480+28>>2]=e;c[f+480+44>>2]=e;c[f+376+8>>2]=0;c[f+376+12>>2]=1065353216;c[f+376+16>>2]=1065353216;c[f+376+20>>2]=1065353216;g[f+376+24>>2]=0.0;g[f+376+44>>2]=.03999999910593033;c[f+376+52>>2]=0;c[f+376>>2]=3736;c[f+376+4>>2]=1;c[f+376+56>>2]=c[d>>2];c[f+376+56+4>>2]=c[d+4>>2];c[f+376+56+8>>2]=c[d+8>>2];c[f+376+56+12>>2]=c[d+12>>2];c[f+376+72>>2]=c[d+16>>2];c[f+376+72+4>>2]=c[d+16+4>>2];c[f+376+72+8>>2]=c[d+16+8>>2];c[f+376+72+12>>2]=c[d+16+12>>2];c[f+376+88>>2]=c[d+32>>2];c[f+376+88+4>>2]=c[d+32+4>>2];c[f+376+88+8>>2]=c[d+32+8>>2];c[f+376+88+12>>2]=c[d+32+12>>2];g[f+16+308>>2]=9.999999747378752e-05;a[f+16+332>>0]=0;c[f>>2]=4960;c[f+4>>2]=f+16;c[f+8>>2]=f+480;c[f+12>>2]=f+376;if(od(f,b+4|0,b+68|0,f+712|0,f+712|0,f+536|0)|0?(h=+g[f+536+164>>2],+g[b+200>>2]>h):0)g[b+200>>2]=h;c[f+376>>2]=7124;e=c[f+376+52>>2]|0;if(!e){i=f;return}Ab[c[c[e>>2]>>2]&255](e);e=c[f+376+52>>2]|0;if(!e){i=f;return}c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);i=f;return}function Tf(d,e,f,g,h,j,k,l,m){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0;o=i;i=i+48|0;c[6435]=(c[6435]|0)+1;g=yc(83)|0;if(!g)n=0;else{c[(g+4+15&-16)+-4>>2]=g;n=g+4+15&-16}c[n>>2]=h;b[n+4>>1]=j;b[n+6>>1]=k;j=n+16|0;c[j>>2]=c[e>>2];c[j+4>>2]=c[e+4>>2];c[j+8>>2]=c[e+8>>2];c[j+12>>2]=c[e+12>>2];j=n+32|0;c[j>>2]=c[f>>2];c[j+4>>2]=c[f+4>>2];c[j+8>>2]=c[f+8>>2];c[j+12>>2]=c[f+12>>2];c[n+8>>2]=0;j=n+56|0;c[j>>2]=0;k=n+52|0;c[k>>2]=0;c[o+16>>2]=c[e>>2];c[o+16+4>>2]=c[e+4>>2];c[o+16+8>>2]=c[e+8>>2];c[o+16+12>>2]=c[e+12>>2];c[o+16+16>>2]=c[f>>2];c[o+16+16+4>>2]=c[f+4>>2];c[o+16+16+8>>2]=c[f+8>>2];c[o+16+16+12>>2]=c[f+12>>2];c[n+60>>2]=c[d+144>>2];g=(c[d+188>>2]|0)+1|0;c[d+188>>2]=g;c[n+12>>2]=g;g=c[d+8>>2]|0;if(!g){c[6435]=(c[6435]|0)+1;g=yc(63)|0;if(!g)g=0;else{c[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}l=g;m=l+44|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(m|0))}else c[d+8>>2]=0;c[g+32>>2]=0;c[g+36>>2]=n;c[g+40>>2]=0;c[g>>2]=c[o+16>>2];c[g+4>>2]=c[o+16+4>>2];c[g+8>>2]=c[o+16+8>>2];c[g+12>>2]=c[o+16+12>>2];c[g+16>>2]=c[o+16+16>>2];c[g+20>>2]=c[o+16+20>>2];c[g+24>>2]=c[o+16+24>>2];c[g+28>>2]=c[o+16+28>>2];lf(d+4|0,c[d+4>>2]|0,g);c[d+16>>2]=(c[d+16>>2]|0)+1;c[n+48>>2]=g;l=d+124+(c[d+144>>2]<<2)|0;c[k>>2]=0;c[j>>2]=c[l>>2];g=c[l>>2]|0;if(g|0)c[g+52>>2]=n;c[l>>2]=n;if(a[d+193>>0]|0){i=o;return n|0}c[o>>2]=8904;c[o+4>>2]=d;c[o+8>>2]=n;bg(c[d+4>>2]|0,o+16|0,o);bg(c[d+64>>2]|0,o+16|0,o);i=o;return n|0}function Uf(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;f=i;i=i+608|0;p=+g[d+116>>2]-+g[d+52>>2];o=+g[d+120>>2]-+g[d+56>>2];n=+g[d+124>>2]-+g[d+60>>2];j=+g[e+116>>2]-+g[e+52>>2];k=+g[e+120>>2]-+g[e+56>>2];l=+g[e+124>>2]-+g[e+60>>2];m=+g[d+252>>2];if(p*p+o*o+n*n<m*m?(p=+g[e+252>>2],j*j+k*k+l*l<p*p):0){p=1.0;i=f;return +p}b=c[d+192>>2]|0;h=c[e+248>>2]|0;c[f+552+8>>2]=0;c[f+552+12>>2]=1065353216;c[f+552+16>>2]=1065353216;c[f+552+20>>2]=1065353216;g[f+552+24>>2]=0.0;c[f+552>>2]=6672;c[f+552+4>>2]=8;c[f+552+28>>2]=h;c[f+552+44>>2]=h;c[f+376>>2]=3708;g[f+376+164>>2]=999999984306749440.0;c[f+376+168>>2]=0;g[f+376+172>>2]=0.0;g[f+16+308>>2]=9.999999747378752e-05;a[f+16+332>>0]=0;c[f>>2]=9140;c[f+4>>2]=f+16;c[f+8>>2]=b;c[f+12>>2]=f+552;if(Ed(f,d+4|0,d+68|0,e+4|0,e+68|0,f+376|0)|0){j=+g[f+376+164>>2];if(+g[d+244>>2]>j)g[d+244>>2]=j;if(+g[e+244>>2]>j)g[e+244>>2]=j;if(j<1.0)k=j;else k=1.0}else k=1.0;b=c[e+192>>2]|0;h=c[d+248>>2]|0;c[f+552+8>>2]=0;c[f+552+12>>2]=1065353216;c[f+552+16>>2]=1065353216;c[f+552+20>>2]=1065353216;g[f+552+24>>2]=0.0;c[f+552>>2]=6672;c[f+552+4>>2]=8;c[f+552+28>>2]=h;c[f+552+44>>2]=h;c[f+376>>2]=3708;g[f+376+164>>2]=999999984306749440.0;c[f+376+168>>2]=0;g[f+376+172>>2]=0.0;g[f+16+308>>2]=9.999999747378752e-05;a[f+16+332>>0]=0;c[f>>2]=9140;c[f+4>>2]=f+16;c[f+8>>2]=f+552;c[f+12>>2]=b;if(Ed(f,d+4|0,d+68|0,e+4|0,e+68|0,f+376|0)|0){j=+g[f+376+164>>2];if(+g[d+244>>2]>j)g[d+244>>2]=j;if(+g[e+244>>2]>j)g[e+244>>2]=j;if(!(k>j))j=k}else j=k;p=j;i=f;return +p}function Vf(a,d){a=a|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0;e=i;i=i+128|0;G=c[(c[a+8>>2]|0)+24>>2]|0;h=c[G+(d*80|0)+64>>2]|0;f=c[a+12>>2]|0;x=+g[G+(d*80|0)>>2];D=+g[f>>2];w=+g[G+(d*80|0)+16>>2];C=+g[f+4>>2];v=+g[G+(d*80|0)+32>>2];B=+g[f+8>>2];u=+g[G+(d*80|0)+4>>2];t=+g[G+(d*80|0)+20>>2];s=+g[G+(d*80|0)+36>>2];r=+g[G+(d*80|0)+8>>2];p=+g[G+(d*80|0)+24>>2];n=+g[G+(d*80|0)+40>>2];A=+g[f+16>>2];z=+g[f+20>>2];y=+g[f+24>>2];q=+g[f+32>>2];o=+g[f+36>>2];m=+g[f+40>>2];F=+g[G+(d*80|0)+48>>2];E=+g[G+(d*80|0)+52>>2];j=+g[G+(d*80|0)+56>>2];l=+g[f+48>>2]+(D*F+C*E+B*j);k=A*F+z*E+y*j+ +g[f+52>>2];j=q*F+o*E+m*j+ +g[f+56>>2];g[e+56>>2]=x*D+w*C+v*B;g[e+56+4>>2]=D*u+C*t+B*s;g[e+56+8>>2]=D*r+C*p+B*n;g[e+56+12>>2]=0.0;g[e+56+16>>2]=x*A+w*z+v*y;g[e+56+20>>2]=u*A+t*z+s*y;g[e+56+24>>2]=r*A+p*z+n*y;g[e+56+28>>2]=0.0;g[e+56+32>>2]=x*q+w*o+v*m;g[e+56+36>>2]=u*q+t*o+s*m;g[e+56+40>>2]=r*q+p*o+n*m;g[e+56+44>>2]=0.0;g[e+56+48>>2]=l;g[e+56+52>>2]=k;g[e+56+56>>2]=j;g[e+56+60>>2]=0.0;f=c[a+4>>2]|0;c[e+32>>2]=0;c[e+32+4>>2]=h;c[e+32+8>>2]=f;c[e+32+12>>2]=e+56;c[e+32+16>>2]=-1;c[e+32+20>>2]=d;f=c[a+24>>2]|0;g[e+4>>2]=1.0;c[e+8>>2]=0;b[e+12>>1]=1;b[e+14>>1]=-1;c[e+16>>2]=0;c[e>>2]=5840;c[e+20>>2]=f;c[e+24>>2]=d;c[e+4>>2]=c[f+4>>2];c[e+16>>2]=c[f+16>>2];bd(c[a+16>>2]|0,c[a+20>>2]|0,e+32|0,e);i=e;return}function Wf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;j=i;i=i+96|0;f=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);h=0;do{q=j+80+(h<<2)|0;c[j+80>>2]=0;c[j+80+4>>2]=0;c[j+80+8>>2]=0;c[j+80+12>>2]=0;g[q>>2]=1.0;k=c[(c[a>>2]|0)+64>>2]|0;l=+g[j+80>>2];m=+g[j+80+4>>2];n=+g[j+80+8>>2];o=l*+g[b+4>>2]+m*+g[b+20>>2]+n*+g[b+36>>2];p=l*+g[b+8>>2]+m*+g[b+24>>2]+n*+g[b+40>>2];g[j+32>>2]=+g[b>>2]*l+ +g[b+16>>2]*m+ +g[b+32>>2]*n;g[j+32+4>>2]=o;g[j+32+8>>2]=p;g[j+32+12>>2]=0.0;ic[k&127](j+64|0,a,j+32|0);p=+g[j+64>>2];o=+g[j+64+4>>2];n=+g[j+64+8>>2];m=p*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];l=p*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];g[j+48>>2]=p*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];g[j+48+4>>2]=m;g[j+48+8>>2]=l;g[j+48+12>>2]=0.0;k=j+48+(h<<2)|0;g[e+(h<<2)>>2]=f+ +g[k>>2];g[q>>2]=-1.0;q=c[(c[a>>2]|0)+64>>2]|0;l=+g[j+80>>2];m=+g[j+80+4>>2];n=+g[j+80+8>>2];o=l*+g[b+4>>2]+m*+g[b+20>>2]+n*+g[b+36>>2];p=l*+g[b+8>>2]+m*+g[b+24>>2]+n*+g[b+40>>2];g[j>>2]=+g[b>>2]*l+ +g[b+16>>2]*m+ +g[b+32>>2]*n;g[j+4>>2]=o;g[j+8>>2]=p;g[j+12>>2]=0.0;ic[q&127](j+16|0,a,j);p=+g[j+16>>2];o=+g[j+16+4>>2];n=+g[j+16+8>>2];m=p*+g[b+16>>2]+o*+g[b+20>>2]+n*+g[b+24>>2]+ +g[b+52>>2];l=p*+g[b+32>>2]+o*+g[b+36>>2]+n*+g[b+40>>2]+ +g[b+56>>2];g[j+48>>2]=p*+g[b>>2]+o*+g[b+4>>2]+n*+g[b+8>>2]+ +g[b+48>>2];g[j+48+4>>2]=m;g[j+48+8>>2]=l;g[j+48+12>>2]=0.0;g[d+(h<<2)>>2]=+g[k>>2]-f;h=h+1|0}while((h|0)!=3);i=j;return}function Xf(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=i;i=i+160|0;j=c[b+12>>2]|0;if(!j){i=l;return}m=(a[b+16>>0]|0)!=0;n=m?e:d;e=m?d:e;p=c[n+4>>2]|0;o=c[e+4>>2]|0;c[h+4>>2]=j;d=c[j+752>>2]|0;c[l+136>>2]=9304;c[l+136+4>>2]=p;c[l+136+8>>2]=o;c[l+136+12>>2]=d;g[l+128>>2]=999999984306749440.0;d=c[n+12>>2]|0;c[l>>2]=c[d>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];c[l+16>>2]=c[d+16>>2];c[l+16+4>>2]=c[d+16+4>>2];c[l+16+8>>2]=c[d+16+8>>2];c[l+16+12>>2]=c[d+16+12>>2];c[l+32>>2]=c[d+32>>2];c[l+32+4>>2]=c[d+32+4>>2];c[l+32+8>>2]=c[d+32+8>>2];c[l+32+12>>2]=c[d+32+12>>2];c[l+48>>2]=c[d+48>>2];c[l+48+4>>2]=c[d+48+4>>2];c[l+48+8>>2]=c[d+48+8>>2];c[l+48+12>>2]=c[d+48+12>>2];e=c[e+12>>2]|0;c[l+64>>2]=c[e>>2];c[l+64+4>>2]=c[e+4>>2];c[l+64+8>>2]=c[e+8>>2];c[l+64+12>>2]=c[e+12>>2];c[l+80>>2]=c[e+16>>2];c[l+80+4>>2]=c[e+16+4>>2];c[l+80+8>>2]=c[e+16+8>>2];c[l+80+12>>2]=c[e+16+12>>2];c[l+96>>2]=c[e+32>>2];c[l+96+4>>2]=c[e+32+4>>2];c[l+96+8>>2]=c[e+32+8>>2];c[l+96+12>>2]=c[e+32+12>>2];c[l+112>>2]=c[e+48>>2];c[l+112+4>>2]=c[e+48+4>>2];c[l+112+8>>2]=c[e+48+8>>2];c[l+112+12>>2]=c[e+48+12>>2];$d(l+136|0,l,h,c[f+20>>2]|0,m);do if(a[b+8>>0]|0?(k=c[h+4>>2]|0,c[k+748>>2]|0):0){d=c[k+740>>2]|0;e=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((d|0)==(e|0)){ef(k,d+4|0,j+4|0);break}else{ef(k,j+4|0,e+4|0);break}}while(0);i=l;return}function Yf(d,e,f){d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0;c[d+4>>2]=1065353216;c[d+8>>2]=1065353216;c[d+12>>2]=1065353216;g[d+16>>2]=0.0;a[d+36>>0]=1;c[d+32>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[d+48>>2]=0;c[d>>2]=8452;a[d+100>>0]=1;c[d+96>>2]=0;c[d+88>>2]=0;c[d+92>>2]=0;a[d+120>>0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;a[d+140>>0]=1;c[d+136>>2]=0;c[d+128>>2]=0;c[d+132>>2]=0;a[d+160>>0]=1;c[d+156>>2]=0;c[d+148>>2]=0;c[d+152>>2]=0;a[d+164>>0]=e&1;a[d+165>>0]=f&1;g[d+168>>2]=0.0;c[6435]=(c[6435]|0)+1;e=yc(51)|0;if(!e)h=0;else{c[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}e=c[d+24>>2]|0;if((e|0)>0){f=0;do{i=h+(f<<5)|0;j=(c[d+32>>2]|0)+(f<<5)|0;c[i>>2]=c[j>>2];c[i+4>>2]=c[j+4>>2];c[i+8>>2]=c[j+8>>2];c[i+12>>2]=c[j+12>>2];c[i+16>>2]=c[j+16>>2];c[i+20>>2]=c[j+20>>2];c[i+24>>2]=c[j+24>>2];c[i+28>>2]=c[j+28>>2];f=f+1|0}while((f|0)!=(e|0))}e=c[d+32>>2]|0;if(e|0){if(a[d+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[d+32>>2]=0}a[d+36>>0]=1;c[d+32>>2]=h;c[d+28>>2]=1;e=c[d+24>>2]|0;c[h+(e<<5)>>2]=0;c[h+(e<<5)+4>>2]=0;c[h+(e<<5)+8>>2]=12;c[h+(e<<5)+12>>2]=0;c[h+(e<<5)+16>>2]=0;c[h+(e<<5)+20>>2]=16;c[h+(e<<5)+24>>2]=2;c[h+(e<<5)+28>>2]=0;c[d+24>>2]=(c[d+24>>2]|0)+1;e=b[d+164>>1]|0;if(!((e&255)<<24>>24)){f=c[d+32>>2]|0;c[f>>2]=(c[d+148>>2]|0)/3|0;c[f+4>>2]=0;c[f+24>>2]=3;c[f+8>>2]=6}else{f=c[d+32>>2]|0;c[f>>2]=(c[d+128>>2]|0)/3|0;c[f+4>>2]=0;c[f+24>>2]=2;c[f+8>>2]=12}if((e&65535)<256){i=12;d=(c[d+108>>2]|0)/3|0;j=f+12|0;c[j>>2]=d;j=f+16|0;c[j>>2]=0;j=f+20|0;c[j>>2]=i;return}else{i=16;d=c[d+88>>2]|0;j=f+12|0;c[j>>2]=d;j=f+16|0;c[j>>2]=0;j=f+20|0;c[j>>2]=i;return}}function Zf(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;q=i;i=i+48|0;if((f|0)==(d|0)|((d|0)==(e|0)|(e|0)==(f|0))){i=q;return}l=q;m=l+36|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(m|0));if(!h)p=c[c[b+880>>2]>>2]|0;else p=h;h=c[b+752>>2]|0;if((h|0)==(c[b+756>>2]|0)?(o=h|0?h<<1:1,(h|0)<(o|0)):0){if(!o)n=0;else{c[6435]=(c[6435]|0)+1;h=yc((o*44|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}n=h;h=c[b+752>>2]|0}if((h|0)>0){j=0;do{l=n+(j*44|0)|0;k=(c[b+760>>2]|0)+(j*44|0)|0;m=l+44|0;do{c[l>>2]=c[k>>2];l=l+4|0;k=k+4|0}while((l|0)<(m|0));j=j+1|0}while((j|0)!=(h|0))}h=c[b+760>>2]|0;if(h|0){if(a[b+764>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[b+760>>2]=0}a[b+764>>0]=1;c[b+760>>2]=n;c[b+756>>2]=o;h=c[b+752>>2]|0}l=c[b+760>>2]|0;c[l+(h*44|0)>>2]=0;c[l+(h*44|0)+4>>2]=p;l=l+(h*44|0)+8|0;k=q;m=l+36|0;do{c[l>>2]=c[k>>2];l=l+4|0;k=k+4|0}while((l|0)<(m|0));p=c[b+752>>2]|0;c[b+752>>2]=p+1;o=c[b+760>>2]|0;l=c[b+720>>2]|0;c[o+(p*44|0)+8>>2]=l+(d*104|0);m=c[b+720>>2]|0;c[o+(p*44|0)+12>>2]=m+(e*104|0);n=c[b+720>>2]|0;c[o+(p*44|0)+16>>2]=n+(f*104|0);t=+g[l+(d*104|0)+8>>2];v=+g[l+(d*104|0)+12>>2];r=+g[l+(d*104|0)+16>>2];s=+g[m+(e*104|0)+8>>2]-t;w=+g[m+(e*104|0)+12>>2]-v;u=+g[m+(e*104|0)+16>>2]-r;t=+g[n+(f*104|0)+8>>2]-t;v=+g[n+(f*104|0)+12>>2]-v;r=+g[n+(f*104|0)+16>>2]-r;g[o+(p*44|0)+36>>2]=+O(+((s*v-w*t)*(s*v-w*t)+((w*r-u*v)*(w*r-u*v)+(u*t-s*r)*(u*t-s*r))));a[b+924>>0]=1;i=q;return}function _f(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0;m=i;i=i+16|0;li(12187);e=c[b+232>>2]|0;if((e|0)>0){l=(a[26260]|0)==0;k=0;do{j=c[(c[b+240>>2]|0)+(k<<2)>>2]|0;a:do if(j){f=c[j+216>>2]|0;b:do switch(f|0){case 4:case 2:{if((f|0)==4)break a;break}default:{q=+g[j+312>>2];p=+g[j+316>>2];o=+g[j+320>>2];n=+g[j+472>>2];if(q*q+p*p+o*o<n*n?(n=+g[j+328>>2],o=+g[j+332>>2],p=+g[j+336>>2],q=+g[j+476>>2],n*n+o*o+p*p<q*q):0){g[j+220>>2]=+g[j+220>>2]+d;break b}g[j+220>>2]=0.0;if((f&-2|0)!=4){c[j+216>>2]=0;f=0}}}while(0);h=f&-2;do if(l){if((h|0)!=2?!(+g[j+220>>2]>2.0):0)break;if(c[j+204>>2]&3|0){if((h|0)==4)break a;c[j+216>>2]=2;break a}if((f|0)==1){if((h|0)==4)break a;c[j+216>>2]=3;break a}else{if((f|0)!=2)break a;e=(c[j+260>>2]|0)+2|0;c[j+328>>2]=0;c[j+328+4>>2]=0;c[j+328+8>>2]=0;c[j+328+12>>2]=0;c[j+260>>2]=e;c[j+312>>2]=0;c[j+312+4>>2]=0;c[j+312+8>>2]=0;c[j+312+12>>2]=0;e=c[b+232>>2]|0;break a}}while(0);if((h|0)!=4)c[j+216>>2]=1}while(0);k=k+1|0}while((k|0)<(e|0))}e=c[2357]|0;b=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=b;if(b|0){i=m;return}do if(c[e+4>>2]|0){tb(m|0,0)|0;b=c[6434]|0;g[e+8>>2]=+g[e+8>>2]+ +(((c[m+4>>2]|0)-(c[b+4>>2]|0)+(((c[m>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[e+16>>2]|0)){e=c[2357]|0;break}else{i=m;return}}while(0);c[2357]=c[e+20>>2];i=m;return}function $f(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0;H=i;i=i+32|0;k=+g[b+16>>2];f=+g[b>>2];l=+g[b+20>>2];h=+g[b+4>>2];n=+g[b+24>>2];j=+g[b+8>>2];r=+g[b+32>>2];v=+g[b+36>>2];w=+g[b+40>>2];B=(l-h)*(w-j)-(n-j)*(v-h);C=(n-j)*(r-f)-(k-f)*(w-j);D=(k-f)*(v-h)-(l-h)*(r-f);g[H+16>>2]=B;g[H+16+4>>2]=C;g[H+16+8>>2]=D;g[H+16+12>>2]=0.0;o=+g[a+4>>2];s=+g[a+8>>2];x=+g[a+12>>2];E=B*o+C*s+D*x-(f*B+h*C+j*D);p=+g[a+20>>2];t=+g[a+24>>2];y=+g[a+28>>2];if(E*(B*p+C*t+D*y-(f*B+h*C+j*D))>=0.0){i=H;return}F=c[a+36>>2]|0;if(E<=0.0&(F&1|0)!=0){i=H;return}G=E/(E-(B*p+C*t+D*y-(f*B+h*C+j*D)));if(!(G<+g[a+40>>2])){i=H;return}A=(B*B+C*C+D*D)*-9.999999747378752e-05;z=f-(p*G+o*(1.0-G));u=h-(t*G+s*(1.0-G));q=j-(y*G+x*(1.0-G));m=k-(p*G+o*(1.0-G));l=l-(t*G+s*(1.0-G));k=n-(y*G+x*(1.0-G));if(!(D*(z*l-u*m)+(B*(u*k-q*l)+C*(q*m-z*k))>=A)){i=H;return}j=r-(p*G+o*(1.0-G));h=v-(t*G+s*(1.0-G));f=w-(y*G+x*(1.0-G));if(!(D*(m*h-l*j)+(B*(l*f-k*h)+C*(k*j-m*f))>=A)){i=H;return}if(!(D*(u*j-z*h)+(B*(q*h-u*f)+C*(z*f-q*j))>=A)){i=H;return}f=1.0/+O(+(B*B+C*C+D*D));g[H+16>>2]=B*f;g[H+16+4>>2]=C*f;g[H+16+8>>2]=D*f;b=c[(c[a>>2]|0)+12>>2]|0;if(E<=0.0&(F&2|0)==0){g[H>>2]=-(B*f);g[H+4>>2]=-(C*f);g[H+8>>2]=-(D*f);g[H+12>>2]=0.0;g[a+40>>2]=+ec[b&3](a,H,G,d,e);i=H;return}else{g[a+40>>2]=+ec[b&3](a,H+16|0,G,d,e);i=H;return}}function ag(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;l=i;i=i+144|0;j=c[b+12>>2]|0;if(!j){i=l;return}n=c[d+4>>2]|0;m=c[e+4>>2]|0;c[h+4>>2]=j;g[l+12+128>>2]=999999984306749440.0;d=c[d+12>>2]|0;c[l+12>>2]=c[d>>2];c[l+12+4>>2]=c[d+4>>2];c[l+12+8>>2]=c[d+8>>2];c[l+12+12>>2]=c[d+12>>2];c[l+12+16>>2]=c[d+16>>2];c[l+12+16+4>>2]=c[d+16+4>>2];c[l+12+16+8>>2]=c[d+16+8>>2];c[l+12+16+12>>2]=c[d+16+12>>2];c[l+12+32>>2]=c[d+32>>2];c[l+12+32+4>>2]=c[d+32+4>>2];c[l+12+32+8>>2]=c[d+32+8>>2];c[l+12+32+12>>2]=c[d+32+12>>2];c[l+12+48>>2]=c[d+48>>2];c[l+12+48+4>>2]=c[d+48+4>>2];c[l+12+48+8>>2]=c[d+48+8>>2];c[l+12+48+12>>2]=c[d+48+12>>2];e=c[e+12>>2]|0;c[l+12+64>>2]=c[e>>2];c[l+12+64+4>>2]=c[e+4>>2];c[l+12+64+8>>2]=c[e+8>>2];c[l+12+64+12>>2]=c[e+12>>2];c[l+12+80>>2]=c[e+16>>2];c[l+12+80+4>>2]=c[e+16+4>>2];c[l+12+80+8>>2]=c[e+16+8>>2];c[l+12+80+12>>2]=c[e+16+12>>2];c[l+12+96>>2]=c[e+32>>2];c[l+12+96+4>>2]=c[e+32+4>>2];c[l+12+96+8>>2]=c[e+32+8>>2];c[l+12+96+12>>2]=c[e+32+12>>2];c[l+12+112>>2]=c[e+48>>2];c[l+12+112+4>>2]=c[e+48+4>>2];c[l+12+112+8>>2]=c[e+48+8>>2];c[l+12+112+12>>2]=c[e+48+12>>2];c[l>>2]=9284;c[l+4>>2]=n;c[l+8>>2]=m;xc(l,l+12|0,h,c[f+20>>2]|0,0);do if(a[b+8>>0]|0?(k=c[h+4>>2]|0,c[k+748>>2]|0):0){d=c[k+740>>2]|0;e=c[(c[h+8>>2]|0)+8>>2]|0;j=c[(c[h+12>>2]|0)+8>>2]|0;if((d|0)==(e|0)){ef(k,d+4|0,j+4|0);break}else{ef(k,j+4|0,e+4|0);break}}while(0);i=l;return}function bg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0,s=0.0,t=0;if(!a)return;n=+g[b>>2];o=+g[b+4>>2];q=+g[b+8>>2];s=+g[b+16>>2];m=+g[b+20>>2];l=+g[b+24>>2];c[6435]=(c[6435]|0)+1;b=yc(275)|0;c[(b+4+15&-16)+-4>>2]=b;c[(b+4+15&-16)>>2]=a;k=1;a=64;b=b+4+15&-16;while(1){e=k+-1|0;i=c[b+(e<<2)>>2]|0;do if(((((+g[i>>2]<=s?+g[i+16>>2]>=n:0)?+g[i+4>>2]<=m:0)?+g[i+20>>2]>=o:0)?+g[i+8>>2]<=l:0)?+g[i+24>>2]>=q:0){if(!(c[i+40>>2]|0)){Cb[c[(c[d>>2]|0)+12>>2]&127](d,i);break}j=c[i+36>>2]|0;do if((e|0)==(a|0)?(p=a|0?a<<1:1,(k|0)<=(p|0)):0){if((p|0)!=0?(c[6435]=(c[6435]|0)+1,r=yc((p<<2|3)+16|0)|0,(r|0)!=0):0){c[(r+4+15&-16)+-4>>2]=r;h=r+4+15&-16}else h=0;if((k|0)<=1){if(!b){a=p;b=h;break}}else{f=0;do{c[h+(f<<2)>>2]=c[b+(f<<2)>>2];f=f+1|0}while((f|0)!=(a|0))}c[6436]=(c[6436]|0)+1;hd(c[b+-4>>2]|0);a=p;b=h}while(0);c[b+(e<<2)>>2]=j;h=c[i+40>>2]|0;do if((k|0)==(a|0)){a=k|0?k<<1:1;if((k|0)<(a|0)){if((a|0)!=0?(c[6435]=(c[6435]|0)+1,t=yc((a<<2|3)+16|0)|0,(t|0)!=0):0){c[(t+4+15&-16)+-4>>2]=t;f=t+4+15&-16}else f=0;if((k|0)<=0){if(!b){b=f;break}}else{e=0;do{c[f+(e<<2)>>2]=c[b+(e<<2)>>2];e=e+1|0}while((e|0)!=(k|0))}c[6436]=(c[6436]|0)+1;hd(c[b+-4>>2]|0);b=f}else a=k}while(0);c[b+(k<<2)>>2]=h;e=k+1|0}while(0);if((e|0)>0)k=e;else break}if(!b)return;c[6436]=(c[6436]|0)+1;hd(c[b+-4>>2]|0);return}function cg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;if((c[b+104>>2]|0)>0){l=0;do{h=c[(c[b+4>>2]|0)+684>>2]|0;i=(c[b+112>>2]|0)+(l<<3)+4|0;d=c[i>>2]|0;if((c[h+60>>2]|0)>0){k=0;do{j=(c[h+68>>2]|0)+(k<<2)|0;e=c[j>>2]|0;a:do if(e|0){f=0;do{g=f+280|0;b:do if(!f)while(1){f=e;e=c[e+280>>2]|0;if((c[f+276>>2]|0)!=(d|0))break b;c[j>>2]=e;hd(f);if(!e)break a}else while(1){f=e;e=c[e+280>>2]|0;if((c[f+276>>2]|0)!=(d|0))break b;c[g>>2]=e;hd(f);if(!e)break a}while(0)}while((e|0)!=0)}while(0);k=k+1|0}while((k|0)<(c[h+60>>2]|0));d=c[i>>2]|0}if(d|0)Ab[c[(c[d>>2]|0)+4>>2]&255](d);l=l+1|0}while((l|0)<(c[b+104>>2]|0))}d=c[b+72>>2]|0;if(d|0){if(a[b+76>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+72>>2]=0}a[b+76>>0]=1;c[b+72>>2]=0;c[b+64>>2]=0;c[b+68>>2]=0;d=c[b+92>>2]|0;if(d|0){if(a[b+96>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+92>>2]=0}a[b+96>>0]=1;c[b+92>>2]=0;c[b+84>>2]=0;c[b+88>>2]=0;d=c[b+112>>2]|0;if(d|0){if(a[b+116>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+112>>2]=0}a[b+116>>0]=1;c[b+112>>2]=0;c[b+104>>2]=0;c[b+108>>2]=0;d=c[b+132>>2]|0;if(!d){a[b+136>>0]=1;c[b+132>>2]=0;c[b+124>>2]=0;b=b+128|0;c[b>>2]=0;return}if(a[b+136>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+132>>2]=0;a[b+136>>0]=1;c[b+132>>2]=0;c[b+124>>2]=0;b=b+128|0;c[b>>2]=0;return}function dg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=c[a+56>>2]|0;if(!e){e=c[a+52>>2]|0;if(!e){c[6435]=(c[6435]|0)+1;e=yc(31)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[a+60>>2]|0;c[e+4>>2]=f;g=e+8|0;c[g>>2]=0;c[6435]=(c[6435]|0)+1;f=yc((f*24|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[e>>2]=f;c[g>>2]=c[a+48>>2];c[a+48>>2]=e}else c[a+52>>2]=c[e+8>>2];h=c[e+4>>2]|0;e=c[e>>2]|0;if((h|0)>0){f=0;g=e;do{f=f+1|0;i=g;g=g+24|0;c[i>>2]=(f|0)<(h|0)?g:0}while((f|0)!=(h|0));i=e}else i=e}else i=e;c[a+56>>2]=c[i>>2];c[i>>2]=0;c[i+4>>2]=0;c[i+8>>2]=0;c[i+12>>2]=0;c[i+16>>2]=0;c[i+20>>2]=0;e=c[a+56>>2]|0;if(!e){e=c[a+52>>2]|0;if(!e){c[6435]=(c[6435]|0)+1;e=yc(31)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[a+60>>2]|0;c[e+4>>2]=f;g=e+8|0;c[g>>2]=0;c[6435]=(c[6435]|0)+1;f=yc((f*24|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[e>>2]=f;c[g>>2]=c[a+48>>2];c[a+48>>2]=e}else c[a+52>>2]=c[e+8>>2];h=c[e+4>>2]|0;e=c[e>>2]|0;if((h|0)>0){f=0;g=e;do{f=f+1|0;j=g;g=g+24|0;c[j>>2]=(f|0)<(h|0)?g:0}while((f|0)!=(h|0))}}c[a+56>>2]=c[e>>2];c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[i+8>>2]=e;c[e+8>>2]=i;j=c[a+100>>2]|0;c[i+20>>2]=j;c[e+20>>2]=j;c[i+12>>2]=d;c[e+12>>2]=b;c[i+16>>2]=0;c[e+16>>2]=0;e=c[a+116>>2]|0;c[a+116>>2]=e+1;if((e|0)<(c[a+120>>2]|0))return i|0;c[a+120>>2]=e+1;return i|0}function eg(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0;b=c[a+752>>2]|0;if((b|0)>0){d=c[a+760>>2]|0;e=0;do{o=c[d+(e*44|0)+8>>2]|0;f=c[d+(e*44|0)+12>>2]|0;h=c[d+(e*44|0)+16>>2]|0;k=+g[o+8>>2];m=+g[o+12>>2];i=+g[o+16>>2];j=+g[f+8>>2]-k;n=+g[f+12>>2]-m;l=+g[f+16>>2]-i;k=+g[h+8>>2]-k;m=+g[h+12>>2]-m;i=+g[h+16>>2]-i;g[d+(e*44|0)+36>>2]=+O(+((j*m-n*k)*(j*m-n*k)+((n*i-l*m)*(n*i-l*m)+(l*k-j*i)*(l*k-j*i))));e=e+1|0}while((e|0)!=(b|0))}d=c[a+712>>2]|0;if((d|0)>0){c[6435]=(c[6435]|0)+1;b=yc((d<<2|3)+16|0)|0;if(!b)f=0;else{c[(b+4+15&-16)+-4>>2]=b;f=b+4+15&-16}Qn(f|0,0,d<<2|0)|0;d=c[a+712>>2]|0;if((d|0)>0){b=c[a+720>>2]|0;e=0;do{g[b+(e*104|0)+92>>2]=0.0;e=e+1|0}while((e|0)!=(d|0));h=f}else h=f}else h=0;f=c[a+752>>2]|0;if((f|0)>0){b=c[a+760>>2]|0;d=c[a+720>>2]|0;e=0;do{n=+N(+(+g[b+(e*44|0)+36>>2]));o=c[b+(e*44|0)+8>>2]|0;p=h+(((o-d|0)/104|0)<<2)|0;c[p>>2]=(c[p>>2]|0)+1;g[o+92>>2]=n+ +g[o+92>>2];o=c[b+(e*44|0)+12>>2]|0;p=h+(((o-d|0)/104|0)<<2)|0;c[p>>2]=(c[p>>2]|0)+1;g[o+92>>2]=n+ +g[o+92>>2];o=c[b+(e*44|0)+16>>2]|0;p=h+(((o-d|0)/104|0)<<2)|0;c[p>>2]=(c[p>>2]|0)+1;g[o+92>>2]=n+ +g[o+92>>2];e=e+1|0}while((e|0)!=(f|0));d=c[a+712>>2]|0}if((d|0)<=0){if(!h)return}else{e=0;do{b=c[h+(e<<2)>>2]|0;if((b|0)>0){p=(c[a+720>>2]|0)+(e*104|0)+92|0;g[p>>2]=+g[p>>2]/+(b|0)}else g[(c[a+720>>2]|0)+(e*104|0)+92>>2]=0.0;e=e+1|0}while((e|0)!=(d|0))}c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0);return}function fg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;l=i;i=i+16|0;j=c[b+28>>2]|0;k=c[b+32>>2]|0;if(!(a[b+1301>>0]|0)){h=0;e=Nf(b,d,0,j+4|0,k+4|0,j+312|0,k+312|0,j+328|0,k+328|0)|0;do{f=b+868+(h<<6)|0;if(!((c[b+868+(h<<6)+56>>2]|0)==0?(a[b+868+(h<<6)+44>>0]|0)==0:0)){g=b+1208+(h<<4)|0;c[l>>2]=c[g>>2];c[l+4>>2]=c[g+4>>2];c[l+8>>2]=c[g+8>>2];c[l+12>>2]=c[g+12>>2];g=c[b+1304>>2]>>(h*3|0)+9;if(!(g&1))c[b+868+(h<<6)+28>>2]=c[c[d+32>>2]>>2];if(!(g&2))c[b+868+(h<<6)+36>>2]=c[c[d+32>>2]>>2];if(!(g&4))c[b+868+(h<<6)+32>>2]=c[d+4>>2];e=(Dd(b,f,j+4|0,k+4|0,j+312|0,k+312|0,j+328|0,k+328|0,d,e,l,1,0)|0)+e|0}h=h+1|0}while((h|0)!=3);i=l;return}h=0;e=0;do{f=b+868+(h<<6)|0;if(!((c[b+868+(h<<6)+56>>2]|0)==0?(a[b+868+(h<<6)+44>>0]|0)==0:0)){g=b+1208+(h<<4)|0;c[l>>2]=c[g>>2];c[l+4>>2]=c[g+4>>2];c[l+8>>2]=c[g+8>>2];c[l+12>>2]=c[g+12>>2];g=c[b+1304>>2]>>(h*3|0)+9;if(!(g&1))c[b+868+(h<<6)+28>>2]=c[c[d+32>>2]>>2];if(!(g&2))c[b+868+(h<<6)+36>>2]=c[c[d+32>>2]>>2];if(!(g&4))c[b+868+(h<<6)+32>>2]=c[d+4>>2];e=(Dd(b,f,j+4|0,k+4|0,j+312|0,k+312|0,j+328|0,k+328|0,d,e,l,1,0)|0)+e|0}h=h+1|0}while((h|0)!=3);Nf(b,d,e,j+4|0,k+4|0,j+312|0,k+312|0,j+328|0,k+328|0)|0;i=l;return}function gg(b){b=b|0;var d=0,e=0,f=0,h=0.0,i=0.0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,u=0.0,v=0.0;d=c[b+988>>2]|0;if(d|0)xn(b+988|0,d);d=c[b+992>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+992>>2]=0;c[b+996>>2]=-1;d=c[b+1020>>2]|0;if(d|0){if(a[b+1024>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+1020>>2]=0}a[b+1024>>0]=1;c[b+1020>>2]=0;c[b+1012>>2]=0;c[b+1016>>2]=0;c[b+1004>>2]=0;if((c[b+752>>2]|0)<=0)return;r=0;do{j=c[b+760>>2]|0;k=j+(r*44|0)|0;e=c[j+(r*44|0)+8>>2]|0;f=c[j+(r*44|0)+12>>2]|0;d=c[j+(r*44|0)+16>>2]|0;o=+g[e+8>>2];p=+g[e+12>>2];q=+g[e+16>>2];i=+g[e+20>>2];v=+g[f+8>>2];l=v<o?v:o;s=+g[f+12>>2];m=s<p?s:p;t=+g[f+16>>2];n=t<q?t:q;u=+g[f+20>>2];h=u<i?u:i;o=o<v?v:o;p=p<s?s:p;q=q<t?t:q;i=i<u?u:i;u=+g[d+8>>2];l=u<l?u:l;t=+g[d+12>>2];m=t<m?t:m;s=+g[d+16>>2];n=s<n?s:n;v=+g[d+20>>2];h=v<h?v:h;i=i<v?v:i;o=(o<u?u:o)+0.0;p=(p<t?t:p)+0.0;q=(q<s?s:q)+0.0;d=c[b+992>>2]|0;if(!d){c[6435]=(c[6435]|0)+1;d=yc(63)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=d;f=e+44|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(f|0))}else c[b+992>>2]=0;c[d+32>>2]=0;c[d+36>>2]=k;c[d+40>>2]=0;g[d>>2]=l;g[d+4>>2]=m;g[d+8>>2]=n;g[d+12>>2]=h;g[d+16>>2]=o;g[d+20>>2]=p;g[d+24>>2]=q;g[d+28>>2]=i;lf(b+988|0,c[b+988>>2]|0,d);c[b+1e3>>2]=(c[b+1e3>>2]|0)+1;c[j+(r*44|0)+40>>2]=d;r=r+1|0}while((r|0)<(c[b+752>>2]|0));return}function hg(b){b=b|0;var d=0,e=0.0,f=0,h=0,j=0.0,k=0.0,l=0;l=i;i=i+64|0;li(11978);a:do if(!(a[b+274>>0]|0)){d=c[b+232>>2]|0;if((d|0)>0){h=0;while(1){f=c[(c[b+240>>2]|0)+(h<<2)>>2]|0;switch(c[f+216>>2]|0){case 2:case 5:break;default:if((c[f+480>>2]|0)!=0?(c[f+204>>2]&3|0)==0:0){if((a[b+300>>0]|0)!=0?(k=+g[b+268>>2],k!=0.0):0)e=+g[b+264>>2]-k;else e=+g[b+264>>2]*+g[f+244>>2];Zg(f+68|0,+g[f+132>>2],+g[f+136>>2],+g[f+140>>2],f+148|0,e,l);d=c[f+480>>2]|0;Cb[c[(c[d>>2]|0)+12>>2]&127](d,l);d=c[b+232>>2]|0}}h=h+1|0;if((h|0)>=(d|0))break a}}}else{d=c[b+8>>2]|0;if((d|0)>0){h=0;do{f=c[(c[b+16>>2]|0)+(h<<2)>>2]|0;if((!((f|0)==0?1:(c[f+236>>2]&2|0)==0)?(c[f+480>>2]|0)!=0:0)?(c[f+204>>2]&3|0)==0:0){if((a[b+300>>0]|0)!=0?(j=+g[b+268>>2],j!=0.0):0)e=+g[b+264>>2]-j;else e=+g[b+264>>2]*+g[f+244>>2];Zg(f+68|0,+g[f+132>>2],+g[f+136>>2],+g[f+140>>2],f+148|0,e,l);d=c[f+480>>2]|0;Cb[c[(c[d>>2]|0)+12>>2]&127](d,l);d=c[b+8>>2]|0}h=h+1|0}while((h|0)<(d|0))}}while(0);d=c[2357]|0;b=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=b;if(b|0){i=l;return}do if(c[d+4>>2]|0){tb(l|0,0)|0;b=c[6434]|0;g[d+8>>2]=+g[d+8>>2]+ +(((c[l+4>>2]|0)-(c[b+4>>2]|0)+(((c[l>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[d+16>>2]|0)){d=c[2357]|0;break}else{i=l;return}}while(0);c[2357]=c[d+20>>2];i=l;return}function ig(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;if((b|0)<0)b=c[a+12>>2]|0;d=c[a>>2]|0;if(!((b|0)>0&(d|0)!=0)){i=n;return}while(1){e=d+40|0;if(c[e>>2]|0){m=0;while(1){l=(c[a+16>>2]|0)>>>m&1;f=d+32|0;g=c[f>>2]|0;if(g>>>0>d>>>0){h=(c[g+40>>2]|0)==(d|0)&1;j=c[g+36+((h^1)<<2)>>2]|0;k=c[g+32>>2]|0;if(!k)c[a>>2]=d;else c[k+36+(((c[k+40>>2]|0)==(g|0)&1)<<2)>>2]=d;c[j+32>>2]=d;c[g+32>>2]=d;c[f>>2]=k;k=d+36|0;c[g+36>>2]=c[k>>2];c[g+40>>2]=c[e>>2];c[(c[k>>2]|0)+32>>2]=g;c[(c[e>>2]|0)+32>>2]=g;c[d+36+(h<<2)>>2]=g;c[d+36+((h^1)<<2)>>2]=j;c[n>>2]=c[g>>2];c[n+4>>2]=c[g+4>>2];c[n+8>>2]=c[g+8>>2];c[n+12>>2]=c[g+12>>2];c[n+16>>2]=c[g+16>>2];c[n+20>>2]=c[g+20>>2];c[n+24>>2]=c[g+24>>2];c[n+28>>2]=c[g+28>>2];c[g>>2]=c[d>>2];c[g+4>>2]=c[d+4>>2];c[g+8>>2]=c[d+8>>2];c[g+12>>2]=c[d+12>>2];c[g+16>>2]=c[d+16>>2];c[g+20>>2]=c[d+20>>2];c[g+24>>2]=c[d+24>>2];c[g+28>>2]=c[d+28>>2];c[d>>2]=c[n>>2];c[d+4>>2]=c[n+4>>2];c[d+8>>2]=c[n+8>>2];c[d+12>>2]=c[n+12>>2];c[d+16>>2]=c[n+16>>2];c[d+20>>2]=c[n+20>>2];c[d+24>>2]=c[n+24>>2];c[d+28>>2]=c[n+28>>2];d=g}d=c[d+36+(l<<2)>>2]|0;e=d+40|0;if(!(c[e>>2]|0))break;else m=m+1&31}}if(!(hh(a,d)|0))e=0;else e=c[a>>2]|0;lf(a,e,d);c[a+16>>2]=(c[a+16>>2]|0)+1;b=b+-1|0;if(!b)break;d=c[a>>2]|0}i=n;return}function jg(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;j=i;i=i+32|0;d=a[b+8>>0]|0?d:e;if(((c[(c[d+4>>2]|0)+4>>2]|0)+-21|0)>>>0>=9){i=j;return}e=c[(c[d+8>>2]|0)+192>>2]|0;y=+Sb[c[(c[e>>2]|0)+48>>2]&15](e);c[b+64>>2]=f;g[b+68>>2]=y+.05999999865889549;c[b+56>>2]=h;h=c[b+16>>2]|0;ic[c[(c[h>>2]|0)+28>>2]&127](h,j+16|0,j);y=+g[j>>2];x=+g[j+16>>2];w=+g[j+4>>2];v=+g[j+16+4>>2];u=+g[j+8>>2];t=+g[j+16+8>>2];h=c[d+12>>2]|0;B=+g[h>>2];o=+g[h+16>>2];C=+g[h+32>>2];z=+g[h+4>>2];m=+g[h+20>>2];A=+g[h+36>>2];q=+g[h+8>>2];k=+g[h+24>>2];r=+g[h+40>>2];D=-+g[h+48>>2];s=-+g[h+52>>2];l=-+g[h+56>>2];p=(y+x)*.5*B+(w+v)*.5*o+(u+t)*.5*C+(B*D+o*s+C*l);n=(y+x)*.5*z+(w+v)*.5*m+(u+t)*.5*A+(z*D+m*s+A*l);l=(y+x)*.5*q+(w+v)*.5*k+(u+t)*.5*r+(q*D+k*s+r*l);s=+g[b+68>>2];o=((y-x)*.5+s)*+N(+(B+o*0.0+C*0.0))+((w-v)*.5+s)*+N(+(B*0.0+o+C*0.0))+((u-t)*.5+s)*+N(+(C+(B*0.0+o*0.0)));m=((y-x)*.5+s)*+N(+(z+m*0.0+A*0.0))+((w-v)*.5+s)*+N(+(z*0.0+m+A*0.0))+((u-t)*.5+s)*+N(+(A+(z*0.0+m*0.0)));k=((y-x)*.5+s)*+N(+(q+k*0.0+r*0.0))+((w-v)*.5+s)*+N(+(q*0.0+k+r*0.0))+((u-t)*.5+s)*+N(+(r+(q*0.0+k*0.0)));g[b+24>>2]=p-o;g[b+28>>2]=n-m;g[b+32>>2]=l-k;g[b+36>>2]=0.0;g[b+40>>2]=p+o;g[b+44>>2]=n+m;g[b+48>>2]=l+k;g[b+52>>2]=0.0;mc[c[(c[e>>2]|0)+64>>2]&127](e,b+12|0,b+24|0,b+40|0);i=j;return}function kg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0;l=i;i=i+16|0;c[b+8>>2]=0;c[b+12>>2]=1065353216;c[b+16>>2]=1065353216;c[b+20>>2]=1065353216;g[b+24>>2]=0.0;g[b+44>>2]=.03999999910593033;c[b+52>>2]=0;c[b+56>>2]=1065353216;c[b+60>>2]=1065353216;c[b+64>>2]=1065353216;g[b+68>>2]=0.0;c[b+72>>2]=-1082130432;c[b+76>>2]=-1082130432;c[b+80>>2]=-1082130432;g[b+84>>2]=0.0;a[b+88>>0]=0;c[b>>2]=7256;a[b+108>>0]=1;c[b+104>>2]=0;c[b+96>>2]=0;c[b+100>>2]=0;c[b+4>>2]=4;if((e|0)<=0){c[b+96>>2]=e;vj(b);i=l;return}c[6435]=(c[6435]|0)+1;h=yc((e<<4|3)+16|0)|0;if(!h)k=0;else{c[(h+4+15&-16)+-4>>2]=h;k=h+4+15&-16}h=c[b+96>>2]|0;if((h|0)>0){j=0;do{m=k+(j<<4)|0;n=(c[b+104>>2]|0)+(j<<4)|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];j=j+1|0}while((j|0)!=(h|0))}h=c[b+104>>2]|0;if(h|0){if(a[b+108>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=k;c[b+100>>2]=e;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];if((e|0)!=1){h=1;do{n=(c[b+104>>2]|0)+(h<<4)|0;c[n>>2]=c[l>>2];c[n+4>>2]=c[l+4>>2];c[n+8>>2]=c[l+8>>2];c[n+12>>2]=c[l+12>>2];h=h+1|0}while((h|0)!=(e|0))}c[b+96>>2]=e;j=0;h=d;while(1){n=c[b+104>>2]|0;d=c[h+4>>2]|0;m=c[h+8>>2]|0;c[n+(j<<4)>>2]=c[h>>2];c[n+(j<<4)+4>>2]=d;c[n+(j<<4)+8>>2]=m;g[n+(j<<4)+12>>2]=0.0;j=j+1|0;if((j|0)==(e|0))break;else h=h+f|0}vj(b);i=l;return}function lg(b){b=b|0;var d=0;c[b>>2]=4756;d=c[b+176>>2]|0;if(d|0){if(a[b+180>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+176>>2]=0}a[b+180>>0]=1;c[b+176>>2]=0;c[b+168>>2]=0;c[b+172>>2]=0;d=c[b+156>>2]|0;if(d|0){if(a[b+160>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;d=c[b+136>>2]|0;if(d|0){if(a[b+140>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+116>>2]|0;if(d|0){if(a[b+120>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;d=c[b+96>>2]|0;if(d|0){if(a[b+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;d=c[b+76>>2]|0;if(d|0){if(a[b+80>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;d=c[b+56>>2]|0;if(d|0){if(a[b+60>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d|0){if(a[b+40>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function mg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0.0;x=i;i=i+48|0;t=+g[e>>2];u=+g[d>>2];v=+g[e+4>>2];w=+g[d+4>>2];s=+g[e+8>>2];h=+g[d+8>>2];j=+O(+((t-u)*.5*(t-u)*.5+(v-w)*.5*(v-w)*.5+(s-h)*.5*(s-h)*.5));k=+g[a+56>>2];d=+N(+k)>.7071067690849304;l=+g[a+52>>2];if(d){r=1.0/+O(+(k*k+l*l));y=+g[a+48>>2];f=y*-(k*r);m=y;n=0.0;o=-(k*r);p=l*r;q=(k*k+l*l)*r;r=-(y*l*r)}else{q=+g[a+48>>2];r=1.0/+O(+(q*q+l*l));f=(q*q+l*l)*r;m=q;n=-(l*r);o=q*r;p=0.0;q=-(k*q*r);r=k*-(l*r)}y=(t+u)*.5*m+(v+w)*.5*l+(s+h)*.5*k-+g[a+64>>2];m=(t+u)*.5-m*y;n=j*n;o=j*o;u=j*p;q=j*q;r=j*r;t=j*f;g[x>>2]=q+(n+m);g[x+4>>2]=r+(o+((v+w)*.5-l*y));g[x+8>>2]=t+(u+((s+h)*.5-k*y));g[x+12>>2]=0.0;g[x+16>>2]=n+m-q;g[x+20>>2]=o+((v+w)*.5-l*y)-r;g[x+24>>2]=u+((s+h)*.5-k*y)-t;g[x+28>>2]=0.0;g[x+32>>2]=m-n-q;g[x+36>>2]=(v+w)*.5-l*y-o-r;g[x+40>>2]=(s+h)*.5-k*y-u-t;g[x+44>>2]=0.0;mc[c[(c[b>>2]|0)+8>>2]&127](b,x,0,0);g[x>>2]=m-n-q;g[x+4>>2]=(v+w)*.5-l*y-o-r;g[x+8>>2]=(s+h)*.5-k*y-u-t;g[x+12>>2]=0.0;g[x+16>>2]=q+(m-n);g[x+20>>2]=r+((v+w)*.5-l*y-o);g[x+24>>2]=t+((s+h)*.5-k*y-u);g[x+28>>2]=0.0;g[x+32>>2]=q+(n+m);g[x+36>>2]=r+(o+((v+w)*.5-l*y));g[x+40>>2]=t+(u+((s+h)*.5-k*y));g[x+44>>2]=0.0;mc[c[(c[b>>2]|0)+8>>2]&127](b,x,0,1);i=x;return}function ng(a,b,e){a=a|0;b=b|0;e=e|0;mf(a,b,e)|0;c[b+256>>2]=c[a+264>>2];c[b+260>>2]=c[a+268>>2];c[b+264>>2]=c[a+272>>2];c[b+268>>2]=c[a+276>>2];c[b+272>>2]=c[a+280>>2];c[b+276>>2]=c[a+284>>2];c[b+280>>2]=c[a+288>>2];c[b+284>>2]=c[a+292>>2];c[b+288>>2]=c[a+296>>2];c[b+292>>2]=c[a+300>>2];c[b+296>>2]=c[a+304>>2];c[b+300>>2]=c[a+308>>2];c[b+304>>2]=c[a+312>>2];c[b+308>>2]=c[a+316>>2];c[b+312>>2]=c[a+320>>2];c[b+316>>2]=c[a+324>>2];c[b+320>>2]=c[a+328>>2];c[b+324>>2]=c[a+332>>2];c[b+328>>2]=c[a+336>>2];c[b+332>>2]=c[a+340>>2];c[b+448>>2]=c[a+344>>2];c[b+336>>2]=c[a+544>>2];c[b+340>>2]=c[a+548>>2];c[b+344>>2]=c[a+552>>2];c[b+348>>2]=c[a+556>>2];c[b+352>>2]=c[a+348>>2];c[b+356>>2]=c[a+352>>2];c[b+360>>2]=c[a+356>>2];c[b+364>>2]=c[a+360>>2];c[b+368>>2]=c[a+364>>2];c[b+372>>2]=c[a+368>>2];c[b+376>>2]=c[a+372>>2];c[b+380>>2]=c[a+376>>2];c[b+384>>2]=c[a+380>>2];c[b+388>>2]=c[a+384>>2];c[b+392>>2]=c[a+388>>2];c[b+396>>2]=c[a+392>>2];c[b+400>>2]=c[a+396>>2];c[b+404>>2]=c[a+400>>2];c[b+408>>2]=c[a+404>>2];c[b+412>>2]=c[a+408>>2];c[b+416>>2]=c[a+412>>2];c[b+420>>2]=c[a+416>>2];c[b+424>>2]=c[a+420>>2];c[b+428>>2]=c[a+424>>2];c[b+432>>2]=c[a+428>>2];c[b+436>>2]=c[a+432>>2];c[b+440>>2]=c[a+436>>2];c[b+444>>2]=c[a+440>>2];c[b+452>>2]=c[a+444>>2];c[b+456>>2]=c[a+448>>2];c[b+484>>2]=d[a+452>>0];c[b+460>>2]=c[a+456>>2];c[b+464>>2]=c[a+460>>2];c[b+468>>2]=c[a+464>>2];c[b+472>>2]=c[a+468>>2];c[b+476>>2]=c[a+472>>2];c[b+480>>2]=c[a+476>>2];return 11858}function og(b,d,e,f,h){b=b|0;d=+d;e=e|0;f=f|0;h=h|0;var j=0;j=i;i=i+144|0;c[b+164>>2]=1065353216;c[b+168>>2]=1065353216;c[b+172>>2]=1065353216;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749440.0;c[b+188>>2]=0;c[b+188+4>>2]=0;c[b+188+8>>2]=0;c[b+188+12>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+236>>2]=1;c[b+240>>2]=0;g[b+244>>2]=1.0;c[b+248>>2]=0;c[b+248+4>>2]=0;c[b+248+8>>2]=0;c[b+248+12>>2]=0;c[b+4>>2]=1065353216;c[b+8>>2]=0;c[b+8+4>>2]=0;c[b+8+8>>2]=0;c[b+8+12>>2]=0;c[b+24>>2]=1065353216;c[b+28>>2]=0;c[b+28+4>>2]=0;c[b+28+8>>2]=0;c[b+28+12>>2]=0;c[b+44>>2]=1065353216;c[b+48>>2]=0;c[b+48+4>>2]=0;c[b+48+8>>2]=0;c[b+48+12>>2]=0;c[b+48+16>>2]=0;c[b>>2]=4108;a[b+500>>0]=1;c[b+496>>2]=0;c[b+488>>2]=0;c[b+492>>2]=0;g[j>>2]=d;c[j+4>>2]=e;c[j+72>>2]=f;c[j+76>>2]=c[h>>2];c[j+76+4>>2]=c[h+4>>2];c[j+76+8>>2]=c[h+8>>2];c[j+76+12>>2]=c[h+12>>2];g[j+92>>2]=0.0;g[j+96>>2]=0.0;g[j+100>>2]=.5;g[j+104>>2]=0.0;g[j+108>>2]=0.0;g[j+112>>2]=.800000011920929;g[j+116>>2]=1.0;a[j+120>>0]=0;g[j+124>>2]=.004999999888241291;g[j+128>>2]=.009999999776482582;g[j+132>>2]=.009999999776482582;g[j+136>>2]=.009999999776482582;c[j+8>>2]=1065353216;c[j+12>>2]=0;c[j+12+4>>2]=0;c[j+12+8>>2]=0;c[j+12+12>>2]=0;c[j+28>>2]=1065353216;c[j+32>>2]=0;c[j+32+4>>2]=0;c[j+32+8>>2]=0;c[j+32+12>>2]=0;c[j+48>>2]=1065353216;c[j+52>>2]=0;c[j+52+4>>2]=0;c[j+52+8>>2]=0;c[j+52+12>>2]=0;c[j+52+16>>2]=0;Od(b,j);i=j;return}function pg(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0;c[6435]=(c[6435]|0)+1;e=yc(627)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e+4>>2]=5;c[e>>2]=4432;c[e+8>>2]=-1;c[e+12>>2]=-1;g[e+16>>2]=3402823466385288598117041.0e14;a[e+20>>0]=1;a[e+21>>0]=0;c[e+24>>2]=-1;c[e+28>>2]=b;Il();c[e+32>>2]=23268;g[e+36>>2]=0.0;g[e+40>>2]=.30000001192092896;c[e+44>>2]=0;c[e>>2]=4648;h=e+300|0;c[h>>2]=c[d>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];c[h+12>>2]=c[d+12>>2];f=e+316|0;c[f>>2]=c[d+16>>2];c[f+4>>2]=c[d+16+4>>2];c[f+8>>2]=c[d+16+8>>2];c[f+12>>2]=c[d+16+12>>2];b=e+332|0;c[b>>2]=c[d+32>>2];c[b+4>>2]=c[d+32+4>>2];c[b+8>>2]=c[d+32+8>>2];c[b+12>>2]=c[d+32+12>>2];i=e+348|0;c[i>>2]=c[d+48>>2];c[i+4>>2]=c[d+48+4>>2];c[i+8>>2]=c[d+48+8>>2];c[i+12>>2]=c[d+48+12>>2];d=e+364|0;a[e+527>>0]=0;c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];d=e+380|0;c[d>>2]=c[f>>2];c[d+4>>2]=c[f+4>>2];c[d+8>>2]=c[f+8>>2];c[d+12>>2]=c[f+12>>2];d=e+396|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];d=e+412|0;a[e+524>>0]=0;a[e+525>>0]=0;a[e+526>>0]=0;a[e+552>>0]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;g[e+572>>2]=-1.0;g[e+444>>2]=999999984306749440.0;g[e+448>>2]=999999984306749440.0;g[e+452>>2]=999999984306749440.0;g[e+428>>2]=1.0;g[e+432>>2]=.30000001192092896;g[e+436>>2]=1.0;g[e+440>>2]=.009999999776482582;g[e+456>>2]=.05000000074505806;c[e+592>>2]=0;g[e+596>>2]=0.0;g[e+600>>2]=.699999988079071;g[e+604>>2]=0.0;return e|0}function qg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;Zd(b,d);c[b>>2]=3068;c[6435]=(c[6435]|0)+1;e=yc(27)|0;i=e+4+15&-16;c[i+-4>>2]=e;a[i+4>>0]=0;c[(e+4+15&-16)>>2]=3100;c[b+92>>2]=i;c[6435]=(c[6435]|0)+1;i=yc(27)|0;e=i+4+15&-16;c[e+-4>>2]=i;a[e+4>>0]=0;c[(i+4+15&-16)>>2]=3120;c[b+96>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e>>2]=3120;c[b+100>>2]=e;a[e+4>>0]=1;c[6435]=(c[6435]|0)+1;i=yc(27)|0;e=i+4+15&-16;c[e+-4>>2]=i;a[e+4>>0]=0;c[(i+4+15&-16)>>2]=3140;c[b+104>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e>>2]=3160;c[b+108>>2]=e;a[e+4>>0]=1;if(!(a[b+20>>0]|0))return;e=c[b+16>>2]|0;if(!e)return;if((c[e>>2]|0)>=156)return;f=c[e+16>>2]|0;if(f){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0);e=c[b+16>>2]|0;if(!e)i=b+16|0;else{f=b+16|0;g=11}}else{f=b+16|0;g=11}if((g|0)==11){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);i=f}c[6435]=(c[6435]|0)+1;e=yc(39)|0;if(!e)h=0;else{c[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}e=c[d+12>>2]|0;c[h>>2]=156;f=h+4|0;c[f>>2]=e;c[6435]=(c[6435]|0)+1;e=yc((e*156|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[h+16>>2]=e;c[h+12>>2]=e;f=c[f>>2]|0;c[h+8>>2]=f;if(f+-1|0){b=c[h>>2]|0;g=f+-1|0;d=e;do{j=d;d=d+b|0;c[j>>2]=d;g=g+-1|0}while((g|0)!=0);e=e+(_(b,f+-1|0)|0)|0}c[e>>2]=0;c[i>>2]=h;return}function rg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;c[6435]=(c[6435]|0)+1;h=yc(627)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h+4>>2]=5;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=4648;d=h+300|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=h+316|0;c[d>>2]=c[e+16>>2];c[d+4>>2]=c[e+16+4>>2];c[d+8>>2]=c[e+16+8>>2];c[d+12>>2]=c[e+16+12>>2];d=h+332|0;c[d>>2]=c[e+32>>2];c[d+4>>2]=c[e+32+4>>2];c[d+8>>2]=c[e+32+8>>2];c[d+12>>2]=c[e+32+12>>2];d=h+348|0;c[d>>2]=c[e+48>>2];c[d+4>>2]=c[e+48+4>>2];c[d+8>>2]=c[e+48+8>>2];c[d+12>>2]=c[e+48+12>>2];e=h+364|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=h+380|0;c[e>>2]=c[f+16>>2];c[e+4>>2]=c[f+16+4>>2];c[e+8>>2]=c[f+16+8>>2];c[e+12>>2]=c[f+16+12>>2];e=h+396|0;c[e>>2]=c[f+32>>2];c[e+4>>2]=c[f+32+4>>2];c[e+8>>2]=c[f+32+8>>2];c[e+12>>2]=c[f+32+12>>2];e=h+412|0;c[e>>2]=c[f+48>>2];c[e+4>>2]=c[f+48+4>>2];c[e+8>>2]=c[f+48+8>>2];c[e+12>>2]=c[f+48+12>>2];a[h+552>>0]=0;c[h+524>>2]=0;g[h+572>>2]=-1.0;g[h+444>>2]=999999984306749440.0;g[h+448>>2]=999999984306749440.0;g[h+452>>2]=999999984306749440.0;g[h+428>>2]=1.0;g[h+432>>2]=.30000001192092896;g[h+436>>2]=1.0;g[h+440>>2]=.009999999776482582;g[h+456>>2]=.05000000074505806;c[h+592>>2]=0;g[h+596>>2]=0.0;g[h+600>>2]=.699999988079071;g[h+604>>2]=0.0;return h|0}function sg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=c[d>>2]|0;l=Zb[c[(c[l>>2]|0)+56>>2]&31](l,48)|0;c[l+4>>2]=c[d>>2];c[l>>2]=6228;a[l+28>>0]=1;c[l+24>>2]=0;c[l+16>>2]=0;c[l+20>>2]=0;c[l+32>>2]=c[d+4>>2];a[l+36>>0]=0;c[6435]=(c[6435]|0)+1;b=yc(87)|0;if(!b)k=0;else{c[(b+4+15&-16)+-4>>2]=b;k=b+4+15&-16}c[k>>2]=9324;h=k+20|0;a[h>>0]=1;i=k+16|0;c[i>>2]=0;d=k+8|0;c[d>>2]=0;j=k+12|0;c[j>>2]=0;a[k+24>>0]=0;a[k+44>>0]=1;c[k+40>>2]=0;c[k+32>>2]=0;c[k+36>>2]=0;a[k+64>>0]=1;c[k+60>>2]=0;c[k+52>>2]=0;c[k+56>>2]=0;c[6435]=(c[6435]|0)+1;b=yc(43)|0;if(!b)g=0;else{c[(b+4+15&-16)+-4>>2]=b;g=b+4+15&-16}b=c[d>>2]|0;if((b|0)>0){d=0;do{m=g+(d*12|0)|0;n=(c[i>>2]|0)+(d*12|0)|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];d=d+1|0}while((d|0)!=(b|0))}b=c[i>>2]|0;if(!b){a[h>>0]=1;c[i>>2]=g;c[j>>2]=2;Kf(k);n=l+8|0;c[n>>2]=k;n=e+4|0;n=c[n>>2]|0;n=n+68|0;n=c[n>>2]|0;m=l+40|0;c[m>>2]=n;m=f+4|0;m=c[m>>2]|0;m=m+68|0;m=c[m>>2]|0;n=l+44|0;c[n>>2]=m;return l|0}if(a[h>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[b+-4>>2]|0)}c[i>>2]=0;a[h>>0]=1;c[i>>2]=g;c[j>>2]=2;Kf(k);n=l+8|0;c[n>>2]=k;n=e+4|0;n=c[n>>2]|0;n=n+68|0;n=c[n>>2]|0;m=l+40|0;c[m>>2]=n;m=f+4|0;m=c[m>>2]|0;m=m+68|0;m=c[m>>2]|0;n=l+44|0;c[n>>2]=m;return l|0}function tg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;Ab[c[(c[b>>2]|0)+32>>2]&255](b);d=Ob[c[(c[b>>2]|0)+16>>2]&63](b,104,1)|0;e=c[d+8>>2]|0;f=e;g=f+104|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));c[e+88>>2]=c[a+248>>2];c[e+92>>2]=c[a+252>>2];c[e+96>>2]=c[a+256>>2];c[e+100>>2]=c[a+260>>2];c[e>>2]=c[a+92>>2];c[e+4>>2]=c[a+96>>2];c[e+8>>2]=c[a+100>>2];c[e+12>>2]=c[a+104>>2];c[e+16>>2]=c[a+108>>2];c[e+20>>2]=c[a+116>>2];c[e+24>>2]=c[a+120>>2];c[e+28>>2]=c[a+124>>2];c[e+32>>2]=c[a+128>>2];c[e+36>>2]=c[a+132>>2];c[e+40>>2]=c[a+140>>2];c[e+44>>2]=c[a+144>>2];c[e+48>>2]=c[a+148>>2];c[e+52>>2]=c[a+152>>2];c[e+56>>2]=c[a+168>>2];c[e+60>>2]=c[a+172>>2];c[e+64>>2]=c[a+112>>2];c[e+68>>2]=c[a+156>>2];c[e+72>>2]=c[a+160>>2];c[e+76>>2]=c[a+164>>2];c[e+80>>2]=c[a+136>>2];yb[c[(c[b>>2]|0)+20>>2]&31](b,d,11938,1145853764,e);d=c[a+8>>2]|0;if((d|0)<=0){mj(a,b);td(a,b);a=c[b>>2]|0;a=a+36|0;a=c[a>>2]|0;Ab[a&255](b);return}f=0;do{e=c[(c[a+16>>2]|0)+(f<<2)>>2]|0;if(c[e+236>>2]&8){g=Eb[c[(c[e>>2]|0)+16>>2]&127](e)|0;g=Ob[c[(c[b>>2]|0)+16>>2]&63](b,g,1)|0;d=Ob[c[(c[e>>2]|0)+20>>2]&63](e,c[g+8>>2]|0,b)|0;yb[c[(c[b>>2]|0)+20>>2]&31](b,g,d,1497645651,e);d=c[a+8>>2]|0}f=f+1|0}while((f|0)<(d|0));mj(a,b);td(a,b);a=c[b>>2]|0;a=a+36|0;a=c[a>>2]|0;Ab[a&255](b);return}function ug(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0;h=i;i=i+32|0;d=c[a+8>>2]|0;if((d|0)<=0){i=h;return}f=0;do{e=c[(c[a+16>>2]|0)+(f<<2)>>2]|0;if((!((e|0)==0?1:(c[e+236>>2]&2|0)==0)?(c[e+216>>2]|0)!=2:0)?!(b==0.0?1:(c[e+204>>2]&2|0)==0):0){d=c[e+480>>2]|0;if(!d)d=e+4|0;else{Cb[c[(c[d>>2]|0)+8>>2]&127](d,e+4|0);d=e+4|0}k=1.0/b*(+g[e+56>>2]-+g[e+120>>2]);l=1.0/b*(+g[e+60>>2]-+g[e+124>>2]);g[e+312>>2]=1.0/b*(+g[e+52>>2]-+g[e+116>>2]);g[e+316>>2]=k;g[e+320>>2]=l;g[e+324>>2]=0.0;Gf(e+68|0,d,h+8|0,h);l=+g[h>>2];k=1.0/b*l*+g[h+8+4>>2];j=1.0/b*l*+g[h+8+8>>2];g[e+328>>2]=1.0/b*+g[h+8>>2]*l;g[e+332>>2]=k;g[e+336>>2]=j;g[e+340>>2]=0.0;c[e+132>>2]=c[e+312>>2];c[e+132+4>>2]=c[e+312+4>>2];c[e+132+8>>2]=c[e+312+8>>2];c[e+132+12>>2]=c[e+312+12>>2];c[e+148>>2]=c[e+328>>2];c[e+148+4>>2]=c[e+328+4>>2];c[e+148+8>>2]=c[e+328+8>>2];c[e+148+12>>2]=c[e+328+12>>2];c[e+68>>2]=c[d>>2];c[e+68+4>>2]=c[d+4>>2];c[e+68+8>>2]=c[d+8>>2];c[e+68+12>>2]=c[d+12>>2];c[e+84>>2]=c[e+20>>2];c[e+84+4>>2]=c[e+20+4>>2];c[e+84+8>>2]=c[e+20+8>>2];c[e+84+12>>2]=c[e+20+12>>2];c[e+100>>2]=c[e+36>>2];c[e+100+4>>2]=c[e+36+4>>2];c[e+100+8>>2]=c[e+36+8>>2];c[e+100+12>>2]=c[e+36+12>>2];c[e+116>>2]=c[e+52>>2];c[e+116+4>>2]=c[e+52+4>>2];c[e+116+8>>2]=c[e+52+8>>2];c[e+116+12>>2]=c[e+52+12>>2];d=c[a+8>>2]|0}f=f+1|0}while((f|0)<(d|0));i=h;return}function vg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[6421]=(c[6421]|0)+1;g=((d<<16|b)+~((d<<16|b)<<15)>>10^(d<<16|b)+~((d<<16|b)<<15))*9|0;l=c[a+40>>2]|0;g=l+(((c[a+12>>2]|0)+-1&((g>>6^g)+~((g>>6^g)<<11)>>16^(g>>6^g)+~((g>>6^g)<<11)))<<2)|0;f=c[g>>2]|0;if((f|0)==-1){n=0;return n|0}m=c[a+16>>2]|0;e=f;while(1){k=m+(e*12|0)|0;if((c[k>>2]|0)==(b|0)?(c[m+(e*12|0)+4>>2]|0)==(d|0):0)break;e=c[(c[a+60>>2]|0)+(e<<2)>>2]|0;if((e|0)==-1){e=0;n=21;break}}if((n|0)==21)return e|0;if(!k){n=0;return n|0}j=c[m+(e*12|0)+8>>2]|0;i=(e*12|0)/12|0;b=c[a+60>>2]|0;if((f|0)!=(i|0)){while(1){d=b+(f<<2)|0;e=c[d>>2]|0;if((e|0)==(i|0))break;else f=e}e=c[b+(i<<2)>>2]|0;if((f|0)==-1)n=11;else c[d>>2]=e}else{e=c[b+(f<<2)>>2]|0;n=11}if((n|0)==11)c[g>>2]=e;g=(c[a+8>>2]|0)+-1|0;if((g|0)==(i|0)){c[a+8>>2]=i;n=j;return n|0}h=c[m+(g*12|0)+4>>2]<<16|c[m+(g*12|0)>>2];h=(h+~(h<<15)>>10^h+~(h<<15))*9|0;h=((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11))&(c[a+12>>2]|0)+-1;e=c[l+(h<<2)>>2]|0;b=c[a+60>>2]|0;if((e|0)!=(g|0)){f=e;while(1){d=b+(f<<2)|0;e=c[d>>2]|0;if((e|0)==(g|0))break;else f=e}e=c[b+(g<<2)>>2]|0;if((f|0)==-1)n=19;else c[d>>2]=e}else{e=c[b+(g<<2)>>2]|0;n=19}if((n|0)==19)c[l+(h<<2)>>2]=e;c[k>>2]=c[m+(g*12|0)>>2];c[k+4>>2]=c[m+(g*12|0)+4>>2];c[k+8>>2]=c[m+(g*12|0)+8>>2];n=(c[a+40>>2]|0)+(h<<2)|0;c[(c[a+60>>2]|0)+(i<<2)>>2]=c[n>>2];c[n>>2]=i;c[a+8>>2]=(c[a+8>>2]|0)+-1;n=j;return n|0}function wg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=c[b+236>>2]|0;if((b|0)==0|(d|0)!=8){if(!((b|0)==0|(d&2|0)==0)){Cb[c[(c[a>>2]|0)+92>>2]&127](a,b);return}d=c[b+188>>2]|0;if(d|0){h=c[a+68>>2]|0;h=Eb[c[(c[h>>2]|0)+36>>2]&127](h)|0;ic[c[(c[h>>2]|0)+40>>2]&127](h,d,c[a+24>>2]|0);h=c[a+68>>2]|0;ic[c[(c[h>>2]|0)+12>>2]&127](h,d,c[a+24>>2]|0);c[b+188>>2]=0}d=c[a+8>>2]|0;if((d|0)<=0)return;e=c[a+16>>2]|0;h=0;while(1){f=e+(h<<2)|0;if((c[f>>2]|0)==(b|0))break;g=h+1|0;if((g|0)<(d|0))h=g;else{i=26;break}}if((i|0)==26)return;if((h|0)>=(d|0))return;c[f>>2]=c[e+(d+-1<<2)>>2];c[(c[a+16>>2]|0)+(d+-1<<2)>>2]=b;c[a+8>>2]=d+-1;return}f=c[a+328>>2]|0;a:do if((f|0)>0){g=c[a+336>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0))break a}if((d|0)<(f|0)){c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+336>>2]|0)+(f+-1<<2)>>2]=b;c[a+328>>2]=f+-1}}while(0);d=c[b+188>>2]|0;if(d|0){h=c[a+68>>2]|0;h=Eb[c[(c[h>>2]|0)+36>>2]&127](h)|0;ic[c[(c[h>>2]|0)+40>>2]&127](h,d,c[a+24>>2]|0);h=c[a+68>>2]|0;ic[c[(c[h>>2]|0)+12>>2]&127](h,d,c[a+24>>2]|0);c[b+188>>2]=0}d=c[a+8>>2]|0;if((d|0)<=0)return;e=c[a+16>>2]|0;h=0;while(1){f=e+(h<<2)|0;if((c[f>>2]|0)==(b|0))break;g=h+1|0;if((g|0)<(d|0))h=g;else{i=26;break}}if((i|0)==26)return;if((h|0)>=(d|0))return;c[f>>2]=c[e+(d+-1<<2)>>2];c[(c[a+16>>2]|0)+(d+-1<<2)>>2]=b;c[a+8>>2]=d+-1;return}function xg(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0;c[6435]=(c[6435]|0)+1;i=yc(783)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}c[i+4>>2]=4;c[i+8>>2]=-1;c[i+12>>2]=-1;g[i+16>>2]=3402823466385288598117041.0e14;a[i+20>>0]=1;a[i+21>>0]=0;c[i+24>>2]=-1;c[i+28>>2]=b;c[i+32>>2]=d;g[i+36>>2]=0.0;g[i+40>>2]=.30000001192092896;c[i+44>>2]=0;c[i>>2]=4704;d=i+552|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=i+568|0;c[d>>2]=c[e+16>>2];c[d+4>>2]=c[e+16+4>>2];c[d+8>>2]=c[e+16+8>>2];c[d+12>>2]=c[e+16+12>>2];d=i+584|0;c[d>>2]=c[e+32>>2];c[d+4>>2]=c[e+32+4>>2];c[d+8>>2]=c[e+32+8>>2];c[d+12>>2]=c[e+32+12>>2];d=i+600|0;c[d>>2]=c[e+48>>2];c[d+4>>2]=c[e+48+4>>2];c[d+8>>2]=c[e+48+8>>2];c[d+12>>2]=c[e+48+12>>2];e=i+616|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=i+632|0;c[e>>2]=c[f+16>>2];c[e+4>>2]=c[f+16+4>>2];c[e+8>>2]=c[f+16+8>>2];c[e+12>>2]=c[f+16+12>>2];e=i+648|0;c[e>>2]=c[f+32>>2];c[e+4>>2]=c[f+32+4>>2];c[e+8>>2]=c[f+32+8>>2];c[e+12>>2]=c[f+32+12>>2];e=i+664|0;c[e>>2]=c[f+48>>2];c[e+4>>2]=c[f+48+4>>2];c[e+8>>2]=c[f+48+8>>2];c[e+12>>2]=c[f+48+12>>2];g[i+688>>2]=0.0;g[i+692>>2]=-1.0;g[i+696>>2]=.8999999761581421;g[i+700>>2]=.30000001192092896;g[i+704>>2]=1.0;g[i+708>>2]=0.0;g[i+712>>2]=0.0;a[i+716>>0]=0;a[i+736>>0]=0;a[i+737>>0]=0;a[i+738>>0]=0;a[i+739>>0]=1;a[i+740>>0]=h&1;c[i+748>>2]=0;g[i+732>>2]=h?-1.0:1.0;return i|0}function yg(a,b,d){a=a|0;b=+b;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0;h=i;i=i+16|0;d=+g[a+336>>2]*b;b=+g[a+452>>2];e=c[a+792>>2]|0;if((e|0)<=0){i=h;return}f=0;do{t=c[a+800>>2]|0;k=t+(f*96|0)+20|0;w=c[k>>2]|0;o=c[t+(f*96|0)>>2]|0;z=+g[t+(f*96|0)+4>>2];y=+g[t+(f*96|0)+8>>2];x=+g[t+(f*96|0)+12>>2];j=t+(f*96|0)+76|0;v=+g[w+332>>2];q=+g[t+(f*96|0)+84>>2];A=+g[w+336>>2];m=+g[t+(f*96|0)+80>>2];l=+g[j>>2];n=+g[w+328>>2];s=+g[o+8>>2];r=+g[o+12>>2];p=+g[o+16>>2];u=d*(z*+g[w+4>>2]+y*+g[w+8>>2]+x*+g[w+12>>2]+ +g[w+52>>2]-s)+(b*(v*q-A*m+ +g[w+312>>2])-(s-+g[o+24>>2]));q=d*(z*+g[w+20>>2]+y*+g[w+24>>2]+x*+g[w+28>>2]+ +g[w+56>>2]-r)+(b*(+g[w+316>>2]+(A*l-q*n))-(r-+g[o+28>>2]));l=d*(z*+g[w+36>>2]+y*+g[w+40>>2]+x*+g[w+44>>2]+ +g[w+60>>2]-p)+(b*(m*n-v*l+ +g[w+320>>2])-(p-+g[o+32>>2]));v=+g[t+(f*96|0)+24>>2];n=(u*+g[t+(f*96|0)+28>>2]+q*+g[t+(f*96|0)+32>>2]+ +g[t+(f*96|0)+36>>2]*l)*v;m=(u*+g[t+(f*96|0)+44>>2]+q*+g[t+(f*96|0)+48>>2]+l*+g[t+(f*96|0)+52>>2])*v;l=v*(u*+g[t+(f*96|0)+60>>2]+q*+g[t+(f*96|0)+64>>2]+l*+g[t+(f*96|0)+68>>2]);q=+g[t+(f*96|0)+92>>2];g[o+8>>2]=s+n*q;g[o+12>>2]=q*m+r;g[o+16>>2]=q*l+p;k=c[k>>2]|0;g[h>>2]=-n;g[h+4>>2]=-m;g[h+8>>2]=-l;g[h+12>>2]=0.0;gj(k,h,j);f=f+1|0}while((f|0)!=(e|0));i=h;return}function zg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;h=+g[d+100>>2];k=+g[d+16>>2];i=+g[d+20>>2];j=+g[d+24>>2];e=+g[d+108>>2];e=+g[d+112>>2]-h*+g[d+116>>2]-(k*+g[a+64>>2]+i*+g[a+68>>2]+j*+g[a+72>>2]+(+g[d>>2]*+g[a+80>>2]+ +g[d+4>>2]*+g[a+84>>2]+ +g[d+8>>2]*+g[a+88>>2]))*e-e*(+g[d+48>>2]*+g[b+64>>2]+ +g[d+52>>2]*+g[b+68>>2]+ +g[d+56>>2]*+g[b+72>>2]+(+g[d+32>>2]*+g[b+80>>2]+ +g[d+36>>2]*+g[b+84>>2]+ +g[d+40>>2]*+g[b+88>>2]));f=+g[d+120>>2];do if(!(h+e<f)){f=+g[d+124>>2];if(h+e>f){g[d+100>>2]=f;e=f-h;break}else{g[d+100>>2]=h+e;break}}else{g[d+100>>2]=f;e=f-h}while(0);if(c[a+240>>2]|0){i=e*i*+g[a+132>>2]*+g[a+116>>2];j=e*j*+g[a+136>>2]*+g[a+120>>2];g[a+64>>2]=+g[a+112>>2]*e*k*+g[a+128>>2]+ +g[a+64>>2];g[a+68>>2]=i+ +g[a+68>>2];g[a+72>>2]=j+ +g[a+72>>2];j=e*+g[a+100>>2]*+g[d+68>>2];k=e*+g[a+104>>2]*+g[d+72>>2];g[a+80>>2]=e*+g[a+96>>2]*+g[d+64>>2]+ +g[a+80>>2];g[a+84>>2]=j+ +g[a+84>>2];g[a+88>>2]=k+ +g[a+88>>2]}if(!(c[b+240>>2]|0))return;k=e*+g[d+52>>2]*+g[b+132>>2]*+g[b+116>>2];j=e*+g[d+56>>2]*+g[b+136>>2]*+g[b+120>>2];g[b+64>>2]=+g[b+112>>2]*e*+g[d+48>>2]*+g[b+128>>2]+ +g[b+64>>2];g[b+68>>2]=k+ +g[b+68>>2];g[b+72>>2]=j+ +g[b+72>>2];j=e*+g[b+100>>2]*+g[d+84>>2];k=e*+g[b+104>>2]*+g[d+88>>2];g[b+80>>2]=e*+g[b+96>>2]*+g[d+80>>2]+ +g[b+80>>2];g[b+84>>2]=j+ +g[b+84>>2];g[b+88>>2]=k+ +g[b+88>>2];return}function Ag(a,b){a=a|0;b=b|0;var d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;p=i;i=i+32|0;o=c[a+92>>2]|0;if(!(Eb[c[(c[o>>2]|0)+56>>2]&127](o)|0)){i=p;return}o=c[a+92>>2]|0;o=Eb[c[(c[o>>2]|0)+28>>2]&127](o)|0;d=c[o+4>>2]|0;if((d|0)>1){Vd(o,0,d+-1|0);d=c[o+4>>2]|0}d=d-(c[a+104>>2]|0)|0;c[p+16>>2]=0;c[p+16+4>>2]=0;c[p+16+8>>2]=0;c[p+16+12>>2]=0;yi(o,d,p+16|0);c[a+104>>2]=0;d=c[o+4>>2]|0;if((d|0)>0){f=0;l=0;m=0;h=0;while(1){k=c[o+12>>2]|0;j=k+(l<<4)|0;q=m;m=c[j>>2]|0;k=k+(l<<4)+4|0;g=c[k>>2]|0;if(!((m|0)==(q|0)&(g|0)==(h|0))){q=m+54|0;h=m+48|0;if(!((((((e[q>>1]|0)>=(e[g+48>>1]|0)?(e[g+54>>1]|0)>=(e[h>>1]|0):0)?(e[q+2>>1]|0)>=(e[g+48+2>>1]|0):0)?(e[g+54+2>>1]|0)>=(e[h+2>>1]|0):0)?(e[q+4>>1]|0)>=(e[g+52>>1]|0):0)?(e[g+54+4>>1]|0)>=(e[m+52>>1]|0):0))n=13}else{g=h;n=13}if((n|0)==13){n=0;f=c[a+92>>2]|0;ic[c[(c[f>>2]|0)+32>>2]&127](f,j,b);c[j>>2]=0;c[k>>2]=0;f=(c[a+104>>2]|0)+1|0;c[a+104>>2]=f;c[6163]=(c[6163]|0)+-1;d=c[o+4>>2]|0}l=l+1|0;if((l|0)>=(d|0))break;else h=g}if((d|0)>1){Vd(o,0,d+-1|0);f=c[a+104>>2]|0;d=c[o+4>>2]|0}}else f=0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0;yi(o,d-f|0,p);c[a+104>>2]=0;i=p;return}function Bg(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,i=0,j=0.0,k=0,l=0,m=0.0,n=0.0,o=0,p=0.0;b=c[a+712>>2]|0;if((b|0)>0){d=0;do{l=(c[a+720>>2]|0)+(d*104|0)+72|0;d=d+1|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0}while((d|0)!=(b|0))}b=c[a+752>>2]|0;if((b|0)>0){d=0;do{o=c[a+760>>2]|0;k=c[o+(d*44|0)+12>>2]|0;i=c[o+(d*44|0)+8>>2]|0;j=+g[i+8>>2];e=+g[k+8>>2]-j;f=+g[i+12>>2];h=+g[k+12>>2]-f;m=+g[i+16>>2];n=+g[k+16>>2]-m;l=c[o+(d*44|0)+16>>2]|0;j=+g[l+8>>2]-j;f=+g[l+12>>2]-f;m=+g[l+16>>2]-m;p=1.0/+O(+((e*f-h*j)*(e*f-h*j)+((h*m-n*f)*(h*m-n*f)+(n*j-e*m)*(n*j-e*m))));g[o+(d*44|0)+20>>2]=p*(h*m-n*f);g[o+(d*44|0)+24>>2]=p*(n*j-e*m);g[o+(d*44|0)+28>>2]=(e*f-h*j)*p;c[o+(d*44|0)+32>>2]=0;g[i+72>>2]=h*m-n*f+ +g[i+72>>2];g[i+76>>2]=n*j-e*m+ +g[i+76>>2];g[i+80>>2]=e*f-h*j+ +g[i+80>>2];g[k+72>>2]=h*m-n*f+ +g[k+72>>2];g[k+76>>2]=n*j-e*m+ +g[k+76>>2];g[k+80>>2]=e*f-h*j+ +g[k+80>>2];g[l+72>>2]=h*m-n*f+ +g[l+72>>2];g[l+76>>2]=n*j-e*m+ +g[l+76>>2];g[l+80>>2]=e*f-h*j+ +g[l+80>>2];d=d+1|0}while((d|0)!=(b|0))}l=c[a+712>>2]|0;if((l|0)<=0)return;a=c[a+720>>2]|0;k=0;do{i=a+(k*104|0)+72|0;j=+g[i>>2];b=a+(k*104|0)+76|0;e=+g[b>>2];d=a+(k*104|0)+80|0;f=+g[d>>2];h=+O(+(j*j+e*e+f*f));if(h>1.1920928955078125e-07){g[i>>2]=j*(1.0/h);g[b>>2]=1.0/h*e;g[d>>2]=1.0/h*f}k=k+1|0}while((k|0)!=(l|0));return}function Cg(b,d,e,f){b=b|0;d=+d;e=e|0;f=+f;var h=0,j=0.0,k=0,l=0;l=i;i=i+16|0;tb(c[6434]|0,0)|0;Vq(25696);c[6425]=(c[6425]|0)+1;k=c[6428]|0;c[6428]=k+1;if(!k){tb(l|0,0)|0;k=c[6434]|0;c[6427]=(c[l+4>>2]|0)-(c[k+4>>2]|0)+(((c[l>>2]|0)-(c[k>>2]|0)|0)*1e6|0)}c[6433]=0;tb(l|0,0)|0;li(11963);if(e){g[b+268>>2]=f;j=+g[b+264>>2]+d;g[b+264>>2]=j;if(!(j>=f)){d=f;k=0}else{g[b+264>>2]=j-+(~~(j/f)|0)*f;d=f;k=~~(j/f)}}else{g[b+264>>2]=a[b+300>>0]|0?0.0:d;g[b+268>>2]=0.0;k=!(+N(+d)<1.1920928955078125e-07)&1;e=k}if(Eb[c[(c[b>>2]|0)+20>>2]&127](b)|0){h=Eb[c[(c[b>>2]|0)+20>>2]&127](b)|0;a[26260]=(Eb[c[(c[h>>2]|0)+48>>2]&127](h)|0)>>>4&1}if(k){e=(k|0)>(e|0)?e:k;zb[c[(c[b>>2]|0)+164>>2]&31](b,d*+(e|0));Ab[c[(c[b>>2]|0)+168>>2]&255](b);if((e|0)>0){h=0;do{zb[c[(c[b>>2]|0)+160>>2]&31](b,d);Ab[c[(c[b>>2]|0)+80>>2]&255](b);h=h+1|0}while((h|0)<(e|0));e=b}else e=b}else{Ab[c[(c[b>>2]|0)+80>>2]&255](b);e=b}Ab[c[(c[e>>2]|0)+120>>2]&255](b);c[6433]=(c[6433]|0)+1;e=c[2357]|0;b=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=b;if(b|0){i=l;return k|0}do if(c[e+4>>2]|0){tb(l|0,0)|0;b=c[6434]|0;g[e+8>>2]=+g[e+8>>2]+ +(((c[l+4>>2]|0)-(c[b+4>>2]|0)+(((c[l>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[e+16>>2]|0)){e=c[2357]|0;break}else{i=l;return k|0}}while(0);c[2357]=c[e+20>>2];i=l;return k|0}function Dg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;c[6435]=(c[6435]|0)+1;h=yc(783)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h+4>>2]=4;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3402823466385288598117041.0e14;a[h+20>>0]=1;a[h+21>>0]=0;c[h+24>>2]=-1;c[h+28>>2]=b;c[h+32>>2]=d;g[h+36>>2]=0.0;g[h+40>>2]=.30000001192092896;c[h+44>>2]=0;c[h>>2]=4704;d=h+552|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=h+568|0;c[d>>2]=c[e+16>>2];c[d+4>>2]=c[e+16+4>>2];c[d+8>>2]=c[e+16+8>>2];c[d+12>>2]=c[e+16+12>>2];d=h+584|0;c[d>>2]=c[e+32>>2];c[d+4>>2]=c[e+32+4>>2];c[d+8>>2]=c[e+32+8>>2];c[d+12>>2]=c[e+32+12>>2];d=h+600|0;c[d>>2]=c[e+48>>2];c[d+4>>2]=c[e+48+4>>2];c[d+8>>2]=c[e+48+8>>2];c[d+12>>2]=c[e+48+12>>2];e=h+616|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=h+632|0;c[e>>2]=c[f+16>>2];c[e+4>>2]=c[f+16+4>>2];c[e+8>>2]=c[f+16+8>>2];c[e+12>>2]=c[f+16+12>>2];e=h+648|0;c[e>>2]=c[f+32>>2];c[e+4>>2]=c[f+32+4>>2];c[e+8>>2]=c[f+32+8>>2];c[e+12>>2]=c[f+32+12>>2];e=h+664|0;c[e>>2]=c[f+48>>2];c[e+4>>2]=c[f+48+4>>2];c[e+8>>2]=c[f+48+8>>2];c[e+12>>2]=c[f+48+12>>2];g[h+688>>2]=0.0;g[h+692>>2]=-1.0;g[h+696>>2]=.8999999761581421;g[h+700>>2]=.30000001192092896;g[h+704>>2]=1.0;g[h+708>>2]=0.0;g[h+712>>2]=0.0;a[h+716>>0]=0;a[h+736>>0]=0;a[h+737>>0]=0;a[h+738>>0]=0;a[h+739>>0]=1;a[h+740>>0]=0;c[h+748>>2]=0;g[h+732>>2]=1.0;return h|0}function Eg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0.0;m=i;i=i+672|0;c[m+568+8>>2]=0;c[m+568+12>>2]=1065353216;c[m+568+16>>2]=1065353216;c[m+568+20>>2]=1065353216;g[m+568+24>>2]=0.0;c[m+568+52>>2]=0;c[m+568>>2]=3736;c[m+568+4>>2]=1;c[m+568+56>>2]=c[d>>2];c[m+568+56+4>>2]=c[d+4>>2];c[m+568+56+8>>2]=c[d+8>>2];c[m+568+56+12>>2]=c[d+12>>2];c[m+568+72>>2]=c[d+16>>2];c[m+568+72+4>>2]=c[d+16+4>>2];c[m+568+72+8>>2]=c[d+16+8>>2];c[m+568+72+12>>2]=c[d+16+12>>2];c[m+568+88>>2]=c[d+32>>2];c[m+568+88+4>>2]=c[d+32+4>>2];c[m+568+88+8>>2]=c[d+32+8>>2];c[m+568+88+12>>2]=c[d+32+12>>2];c[m+568+44>>2]=c[b+204>>2];g[m+208+308>>2]=9.999999747378752e-05;a[m+208+332>>0]=0;c[m+200>>2]=9120;d=c[b+4>>2]|0;c[m+176>>2]=9188;c[m+176+4>>2]=m+208;c[m+176+8>>2]=m+200;c[m+176+12>>2]=d;c[m+176+16>>2]=m+568;c[m+176+20>>2]=0;c[m>>2]=3708;c[m+168>>2]=0;g[m+164>>2]=1.0;c[m+172>>2]=c[b+208>>2];if((Xd(m+176|0,b+8|0,b+72|0,b+136|0,b+136|0,m)|0?(h=+g[m+132>>2],j=+g[m+136>>2],k=+g[m+140>>2],h*h+j*j+k*k>9.999999747378752e-05):0)?(l=+g[m+164>>2],l<+g[b+200>>2]):0){n=1.0/+O(+(h*h+j*j+k*k));g[m+132>>2]=h*n;g[m+136>>2]=j*n;g[m+140>>2]=k*n;+Ub[c[(c[b>>2]|0)+12>>2]&3](b,m+132|0,m+148|0,l,e,f)}c[m+568>>2]=7124;e=c[m+568+52>>2]|0;if(!e){i=m;return}Ab[c[c[e>>2]>>2]&255](e);e=c[m+568+52>>2]|0;if(!e){i=m;return}c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);i=m;return}function Fg(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0;q=i;i=i+32|0;p=c[a+12>>2]|0;if(!p){i=q;return}c[f+4>>2]=p;a=c[b+4>>2]|0;r=c[d+4>>2]|0;b=c[b+12>>2]|0;e=c[d+12>>2]|0;h=+g[b+48>>2]-+g[e+48>>2];j=+g[b+52>>2]-+g[e+52>>2];l=+g[b+56>>2]-+g[e+56>>2];m=+O(+(h*h+j*j+l*l));n=+g[r+28>>2]*+g[r+12>>2];o=+g[a+28>>2]*+g[a+12>>2]+n;if(m>o){if(!(c[p+748>>2]|0)){i=q;return}a=c[p+740>>2]|0;b=c[(c[f+8>>2]|0)+8>>2]|0;e=c[(c[f+12>>2]|0)+8>>2]|0;if((a|0)==(b|0)){ef(p,a+4|0,e+4|0);i=q;return}else{ef(p,e+4|0,b+4|0);i=q;return}}c[q+16>>2]=1065353216;c[q+16+4>>2]=0;c[q+16+8>>2]=0;g[q+16+12>>2]=0.0;if(m>1.1920928955078125e-07){g[q+16>>2]=h*(1.0/m);g[q+16+4>>2]=j*(1.0/m);g[q+16+8>>2]=l*(1.0/m);g[q+16+12>>2]=0.0;k=h*(1.0/m);j=j*(1.0/m);h=l*(1.0/m)}else{k=1.0;j=0.0;h=0.0}j=n*j+ +g[e+52>>2];l=n*h+ +g[e+56>>2];g[q>>2]=n*k+ +g[e+48>>2];g[q+4>>2]=j;g[q+8>>2]=l;g[q+12>>2]=0.0;hc[c[(c[f>>2]|0)+16>>2]&15](f,q+16|0,q,m-o);a=c[f+4>>2]|0;do if(c[a+748>>2]|0){b=c[a+740>>2]|0;d=c[(c[f+8>>2]|0)+8>>2]|0;e=c[(c[f+12>>2]|0)+8>>2]|0;if((b|0)==(d|0)){ef(a,b+4|0,e+4|0);break}else{ef(a,e+4|0,d+4|0);break}}while(0);i=q;return}function Gg(a,b){a=a|0;b=b|0;var d=0,e=0;c[6435]=(c[6435]|0)+1;d=yc(219)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d>>2]=2896;e=d+4|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];e=d+20|0;c[e>>2]=c[a+16>>2];c[e+4>>2]=c[a+16+4>>2];c[e+8>>2]=c[a+16+8>>2];c[e+12>>2]=c[a+16+12>>2];e=d+36|0;c[e>>2]=c[a+32>>2];c[e+4>>2]=c[a+32+4>>2];c[e+8>>2]=c[a+32+8>>2];c[e+12>>2]=c[a+32+12>>2];e=d+52|0;c[e>>2]=c[a+48>>2];c[e+4>>2]=c[a+48+4>>2];c[e+8>>2]=c[a+48+8>>2];c[e+12>>2]=c[a+48+12>>2];e=d+68|0;c[e>>2]=c[b>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];e=d+84|0;c[e>>2]=c[b+16>>2];c[e+4>>2]=c[b+16+4>>2];c[e+8>>2]=c[b+16+8>>2];c[e+12>>2]=c[b+16+12>>2];e=d+100|0;c[e>>2]=c[b+32>>2];c[e+4>>2]=c[b+32+4>>2];c[e+8>>2]=c[b+32+8>>2];c[e+12>>2]=c[b+32+12>>2];e=d+116|0;c[e>>2]=c[b+48>>2];c[e+4>>2]=c[b+48+4>>2];c[e+8>>2]=c[b+48+8>>2];c[e+12>>2]=c[b+48+12>>2];b=d+132|0;c[b>>2]=c[a>>2];c[b+4>>2]=c[a+4>>2];c[b+8>>2]=c[a+8>>2];c[b+12>>2]=c[a+12>>2];b=d+148|0;c[b>>2]=c[a+16>>2];c[b+4>>2]=c[a+16+4>>2];c[b+8>>2]=c[a+16+8>>2];c[b+12>>2]=c[a+16+12>>2];b=d+164|0;c[b>>2]=c[a+32>>2];c[b+4>>2]=c[a+32+4>>2];c[b+8>>2]=c[a+32+8>>2];c[b+12>>2]=c[a+32+12>>2];b=d+180|0;c[b>>2]=c[a+48>>2];c[b+4>>2]=c[a+48+4>>2];c[b+8>>2]=c[a+48+8>>2];c[b+12>>2]=c[a+48+12>>2];c[d+196>>2]=0;return d|0}function Hg(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;if(!(a[d+164>>0]|0)){f=c[d+148>>2]|0;if((f|0)==(c[d+152>>2]|0)?(k=f|0?f<<1:1,(f|0)<(k|0)):0){if(!k)i=0;else{c[6435]=(c[6435]|0)+1;f=yc((k<<1)+19|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}i=f;f=c[d+148>>2]|0}h=c[d+156>>2]|0;if((f|0)<=0)if(!h)f=d+160|0;else g=27;else{g=0;do{b[i+(g<<1)>>1]=b[h+(g<<1)>>1]|0;g=g+1|0}while((g|0)!=(f|0));g=27}if((g|0)==27){if(a[d+160>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[d+156>>2]=0;f=d+160|0}a[f>>0]=1;c[d+156>>2]=i;c[d+152>>2]=k;f=c[d+148>>2]|0}k=c[d+156>>2]|0;b[k+(f<<1)>>1]=e;c[d+148>>2]=f+1;c[(c[d+32>>2]|0)+4>>2]=k;return}else{f=c[d+128>>2]|0;if((f|0)==(c[d+132>>2]|0)?(j=f|0?f<<1:1,(f|0)<(j|0)):0){if(!j)i=0;else{c[6435]=(c[6435]|0)+1;f=yc((j<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}i=f;f=c[d+128>>2]|0}h=c[d+136>>2]|0;if((f|0)<=0)if(!h)f=d+140|0;else g=12;else{g=0;do{c[i+(g<<2)>>2]=c[h+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0));g=12}if((g|0)==12){if(a[d+140>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[d+136>>2]=0;f=d+140|0}a[f>>0]=1;c[d+136>>2]=i;c[d+132>>2]=j;f=c[d+128>>2]|0}k=c[d+136>>2]|0;c[k+(f<<2)>>2]=e;c[d+128>>2]=(c[d+128>>2]|0)+1;c[(c[d+32>>2]|0)+4>>2]=k;return}}function Ig(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;e=+g[d+128>>2];if(!(e!=0.0))return;c[5971]=(c[5971]|0)+1;k=+g[d+96>>2];f=+g[d+16>>2];h=+g[d+20>>2];i=+g[d+24>>2];j=+g[d+108>>2];j=e-k*+g[d+116>>2]-(f*+g[a+144>>2]+h*+g[a+148>>2]+i*+g[a+152>>2]+(+g[d>>2]*+g[a+160>>2]+ +g[d+4>>2]*+g[a+164>>2]+ +g[d+8>>2]*+g[a+168>>2]))*j-j*(+g[d+48>>2]*+g[b+144>>2]+ +g[d+52>>2]*+g[b+148>>2]+ +g[d+56>>2]*+g[b+152>>2]+(+g[d+32>>2]*+g[b+160>>2]+ +g[d+36>>2]*+g[b+164>>2]+ +g[d+40>>2]*+g[b+168>>2]));l=+g[d+120>>2];e=k+j<l?l-k:j;g[d+96>>2]=k+j<l?l:k+j;if(c[a+240>>2]|0){l=e*h*+g[a+132>>2]*+g[a+116>>2];k=e*i*+g[a+136>>2]*+g[a+120>>2];g[a+144>>2]=+g[a+112>>2]*e*f*+g[a+128>>2]+ +g[a+144>>2];g[a+148>>2]=l+ +g[a+148>>2];g[a+152>>2]=k+ +g[a+152>>2];k=e*+g[a+100>>2]*+g[d+68>>2];l=e*+g[a+104>>2]*+g[d+72>>2];g[a+160>>2]=e*+g[a+96>>2]*+g[d+64>>2]+ +g[a+160>>2];g[a+164>>2]=k+ +g[a+164>>2];g[a+168>>2]=l+ +g[a+168>>2]}if(!(c[b+240>>2]|0))return;l=e*+g[d+52>>2]*+g[b+132>>2]*+g[b+116>>2];k=e*+g[d+56>>2]*+g[b+136>>2]*+g[b+120>>2];g[b+144>>2]=+g[b+112>>2]*e*+g[d+48>>2]*+g[b+128>>2]+ +g[b+144>>2];g[b+148>>2]=l+ +g[b+148>>2];g[b+152>>2]=k+ +g[b+152>>2];k=e*+g[b+100>>2]*+g[d+84>>2];l=e*+g[b+104>>2]*+g[d+88>>2];g[b+160>>2]=e*+g[b+96>>2]*+g[d+80>>2]+ +g[b+160>>2];g[b+164>>2]=k+ +g[b+164>>2];g[b+168>>2]=l+ +g[b+168>>2];return}function Jg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=Zb[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;g=Zb[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=g;if(g|0)Cb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];g=c[a+48>>2]|0;Ob[c[(c[g>>2]|0)+56>>2]&63](g,b+12|0,d)|0;c[b+52>>2]=c[a+12>>2];do if((c[a+52>>2]|0)!=0?((Eb[c[(c[d>>2]|0)+52>>2]&127](d)|0)&1|0)==0:0){e=Zb[c[(c[d>>2]|0)+24>>2]&31](d,c[a+52>>2]|0)|0;if(!e){c[b+40>>2]=Zb[c[(c[d>>2]|0)+28>>2]&31](d,c[a+52>>2]|0)|0;c[b+44>>2]=0;e=c[a+52>>2]|0;e=Eb[c[(c[e>>2]|0)+12>>2]&127](e)|0;e=Ob[c[(c[d>>2]|0)+16>>2]&63](d,e,1)|0;g=c[a+52>>2]|0;g=Ob[c[(c[g>>2]|0)+16>>2]&63](g,c[e+8>>2]|0,d)|0;yb[c[(c[d>>2]|0)+20>>2]&31](d,e,g,1213612625,c[a+52>>2]|0);break}else{c[b+40>>2]=e;c[b+44>>2]=0;break}}else f=8;while(0);if((f|0)==8){c[b+40>>2]=0;c[b+44>>2]=0}if(c[a+56>>2]|0?((Eb[c[(c[d>>2]|0)+52>>2]&127](d)|0)&2|0)==0:0){e=Zb[c[(c[d>>2]|0)+24>>2]&31](d,c[a+56>>2]|0)|0;if(!e){c[b+48>>2]=Zb[c[(c[d>>2]|0)+28>>2]&31](d,c[a+56>>2]|0)|0;b=c[a+56>>2]|0;b=Eb[c[(c[b>>2]|0)+8>>2]&127](b)|0;b=Ob[c[(c[d>>2]|0)+16>>2]&63](d,b,1)|0;g=c[a+56>>2]|0;g=Ob[c[(c[g>>2]|0)+12>>2]&63](g,c[b+8>>2]|0,d)|0;yb[c[(c[d>>2]|0)+20>>2]&31](d,b,g,1346456916,c[a+56>>2]|0);return 16548}else{c[b+48>>2]=e;return 16548}}c[b+48>>2]=0;return 16548}function Kg(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[6422]=(c[6422]|0)+1;k=((e<<16|d)+~((e<<16|d)<<15)>>10^(e<<16|d)+~((e<<16|d)<<15))*9|0;k=(k>>6^k)+~((k>>6^k)<<11)>>16^(k>>6^k)+~((k>>6^k)<<11);l=c[b+12>>2]|0;f=c[(c[b+40>>2]|0)+((l+-1&k)<<2)>>2]|0;a:do if((f|0)!=-1){h=c[b+16>>2]|0;while(1){g=h+(f*12|0)|0;if((c[g>>2]|0)==(d|0)?(c[h+(f*12|0)+4>>2]|0)==(e|0):0)break;f=c[(c[b+60>>2]|0)+(f<<2)>>2]|0;if((f|0)==-1)break a}if(g|0){b=g;return b|0}}while(0);j=c[b+8>>2]|0;if((j|0)==(l|0)){h=l|0?l<<1:1;if((l|0)<(h|0)){if(!h){f=0;g=l}else{c[6435]=(c[6435]|0)+1;f=yc((h*12|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}g=c[b+8>>2]|0}if((g|0)>0){i=0;do{m=f+(i*12|0)|0;n=(c[b+16>>2]|0)+(i*12|0)|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];i=i+1|0}while((i|0)!=(g|0))}g=c[b+16>>2]|0;if(g|0){if(a[b+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=h;f=c[b+8>>2]|0}else{f=l;h=l}}else{f=j;h=l}c[b+8>>2]=f+1;g=c[b+16>>2]|0;if((l|0)<(h|0)){Kf(b);f=(c[b+12>>2]|0)+-1&k}else f=l+-1&k;c[g+(j*12|0)>>2]=d;c[g+(j*12|0)+4>>2]=e;c[g+(j*12|0)+8>>2]=0;n=(c[b+40>>2]|0)+(f<<2)|0;c[(c[b+60>>2]|0)+(j<<2)>>2]=c[n>>2];c[n>>2]=j;n=g+(j*12|0)|0;return n|0}function Lg(a){a=a|0;var b=0,d=0,e=0;c[6435]=(c[6435]|0)+1;b=yc(219)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}ml();c[b>>2]=2896;d=b+52|0;e=b+4|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];e=b+20|0;c[e>>2]=c[a+16>>2];c[e+4>>2]=c[a+16+4>>2];c[e+8>>2]=c[a+16+8>>2];c[e+12>>2]=c[a+16+12>>2];e=b+36|0;c[e>>2]=c[a+32>>2];c[e+4>>2]=c[a+32+4>>2];c[e+8>>2]=c[a+32+8>>2];c[e+12>>2]=c[a+32+12>>2];c[d>>2]=c[a+48>>2];c[d+4>>2]=c[a+48+4>>2];c[d+8>>2]=c[a+48+8>>2];c[d+12>>2]=c[a+48+12>>2];d=b+116|0;e=b+68|0;c[e>>2]=c[5710];c[e+4>>2]=c[5711];c[e+8>>2]=c[5712];c[e+12>>2]=c[5713];e=b+84|0;c[e>>2]=c[5714];c[e+4>>2]=c[5715];c[e+8>>2]=c[5716];c[e+12>>2]=c[5717];e=b+100|0;c[e>>2]=c[5718];c[e+4>>2]=c[5719];c[e+8>>2]=c[5720];c[e+12>>2]=c[5721];c[d>>2]=c[5722];c[d+4>>2]=c[5723];c[d+8>>2]=c[5724];c[d+12>>2]=c[5725];d=b+180|0;e=b+132|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];e=b+148|0;c[e>>2]=c[a+16>>2];c[e+4>>2]=c[a+16+4>>2];c[e+8>>2]=c[a+16+8>>2];c[e+12>>2]=c[a+16+12>>2];e=b+164|0;c[e>>2]=c[a+32>>2];c[e+4>>2]=c[a+32+4>>2];c[e+8>>2]=c[a+32+8>>2];c[e+12>>2]=c[a+32+12>>2];c[d>>2]=c[a+48>>2];c[d+4>>2]=c[a+48+4>>2];c[d+8>>2]=c[a+48+8>>2];c[d+12>>2]=c[a+48+12>>2];c[b+196>>2]=0;return b|0}function Mg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;k=+g[d+100>>2];h=+g[d+16>>2];e=+g[d+20>>2];f=+g[d+24>>2];j=+g[d+108>>2];j=+g[d+112>>2]-k*+g[d+116>>2]-(h*+g[a+64>>2]+e*+g[a+68>>2]+f*+g[a+72>>2]+(+g[d>>2]*+g[a+80>>2]+ +g[d+4>>2]*+g[a+84>>2]+ +g[d+8>>2]*+g[a+88>>2]))*j-j*(+g[d+48>>2]*+g[b+64>>2]+ +g[d+52>>2]*+g[b+68>>2]+ +g[d+56>>2]*+g[b+72>>2]+(+g[d+32>>2]*+g[b+80>>2]+ +g[d+36>>2]*+g[b+84>>2]+ +g[d+40>>2]*+g[b+88>>2]));l=+g[d+120>>2];i=k+j<l?l-k:j;g[d+100>>2]=k+j<l?l:k+j;if(c[a+240>>2]|0){l=i*e*+g[a+132>>2]*+g[a+116>>2];k=i*f*+g[a+136>>2]*+g[a+120>>2];g[a+64>>2]=+g[a+112>>2]*i*h*+g[a+128>>2]+ +g[a+64>>2];g[a+68>>2]=l+ +g[a+68>>2];g[a+72>>2]=k+ +g[a+72>>2];k=i*+g[a+100>>2]*+g[d+68>>2];l=i*+g[a+104>>2]*+g[d+72>>2];g[a+80>>2]=i*+g[a+96>>2]*+g[d+64>>2]+ +g[a+80>>2];g[a+84>>2]=k+ +g[a+84>>2];g[a+88>>2]=l+ +g[a+88>>2]}if(!(c[b+240>>2]|0))return;l=i*+g[d+52>>2]*+g[b+132>>2]*+g[b+116>>2];k=i*+g[d+56>>2]*+g[b+136>>2]*+g[b+120>>2];g[b+64>>2]=+g[b+112>>2]*i*+g[d+48>>2]*+g[b+128>>2]+ +g[b+64>>2];g[b+68>>2]=l+ +g[b+68>>2];g[b+72>>2]=k+ +g[b+72>>2];k=i*+g[b+100>>2]*+g[d+84>>2];l=i*+g[b+104>>2]*+g[d+88>>2];g[b+80>>2]=i*+g[b+96>>2]*+g[d+80>>2]+ +g[b+80>>2];g[b+84>>2]=k+ +g[b+84>>2];g[b+88>>2]=l+ +g[b+88>>2];return}function Ng(b,d,e,f,h,i,j,k,l){b=b|0;d=d|0;e=e|0;f=+f;h=+h;i=+i;j=j|0;k=k|0;l=l|0;var m=0,n=0.0,o=0.0,p=0.0;c[6435]=(c[6435]|0)+1;m=yc(143)|0;if(!m)m=0;else{c[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}c[m+8>>2]=0;g[m+12>>2]=0.0;c[m>>2]=8060;c[m+4>>2]=24;c[m+64>>2]=b;c[m+68>>2]=d;g[m+72>>2]=h;g[m+76>>2]=i;g[m+80>>2]=+(b+-1|0);g[m+84>>2]=+(d+-1|0);g[m+88>>2]=f;c[m+92>>2]=e;c[m+96>>2]=k;a[m+100>>0]=l&1;a[m+101>>0]=0;a[m+102>>0]=0;c[m+104>>2]=j;c[m+108>>2]=1065353216;c[m+112>>2]=1065353216;c[m+116>>2]=1065353216;g[m+120>>2]=0.0;switch(j|0){case 0:{g[m+16>>2]=h;c[m+20>>2]=0;c[m+24>>2]=0;g[m+28>>2]=0.0;g[m+32>>2]=i;g[m+36>>2]=+(b+-1|0);g[m+40>>2]=+(d+-1|0);g[m+44>>2]=0.0;o=i;p=h;f=+(b+-1|0);n=0.0;i=+(d+-1|0);h=0.0;break}case 1:{c[m+16>>2]=0;g[m+20>>2]=h;c[m+24>>2]=0;g[m+28>>2]=0.0;g[m+32>>2]=+(b+-1|0);g[m+36>>2]=i;g[m+40>>2]=+(d+-1|0);g[m+44>>2]=0.0;o=+(b+-1|0);p=0.0;f=i;n=h;i=+(d+-1|0);h=0.0;break}case 2:{c[m+16>>2]=0;c[m+20>>2]=0;g[m+24>>2]=h;g[m+28>>2]=0.0;g[m+32>>2]=+(b+-1|0);g[m+36>>2]=+(d+-1|0);g[m+40>>2]=i;g[m+44>>2]=0.0;o=+(b+-1|0);p=0.0;f=+(d+-1|0);n=0.0;break}default:{o=+g[m+32>>2];p=+g[m+16>>2];f=+g[m+36>>2];n=+g[m+20>>2];i=+g[m+40>>2];h=+g[m+24>>2]}}g[m+48>>2]=(p+o)*.5;g[m+52>>2]=(n+f)*.5;g[m+56>>2]=(h+i)*.5;g[m+60>>2]=0.0;return m|0}function Og(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0;if(a[b+1308>>0]|0){c[d>>2]=0;c[d+4>>2]=0;return}sd(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);c[d>>2]=0;c[d+4>>2]=6;if((c[b+856>>2]|0)==0?(a[b+788>>0]|0)==0:0){e=0;f=6}else{c[d>>2]=1;c[d+4>>2]=5;e=1;f=5}if(!((c[b+860>>2]|0)==0?(a[b+789>>0]|0)==0:0)){e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f}if((c[b+864>>2]|0)==0?(a[b+790>>0]|0)==0:0)l=0;else{e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f;l=0}do{i=+g[b+868+(l<<6)>>2];j=+g[b+868+(l<<6)+4>>2];k=+ik(+g[b+1192+(l<<2)>>2],i,j);g[b+868+(l<<6)+52>>2]=k;do if(!(i>j)){if(i>k){c[b+868+(l<<6)+56>>2]=1;h=b+868+(l<<6)+48|0;g[h>>2]=k-i;if(k-i>3.1415927410125732){g[h>>2]=k-i+-6.2831854820251465;h=21;break}if(!(k-i<-3.1415927410125732)){h=21;break}g[h>>2]=k-i+6.2831854820251465;h=21;break}h=b+868+(l<<6)+56|0;if(!(j<k)){c[h>>2]=0;h=20;break}c[h>>2]=2;h=b+868+(l<<6)+48|0;g[h>>2]=k-j;if(k-j>3.1415927410125732){g[h>>2]=k-j+-6.2831854820251465;h=21;break}if(k-j<-3.1415927410125732){g[h>>2]=k-j+6.2831854820251465;h=21}else h=21}else{c[b+868+(l<<6)+56>>2]=0;h=20}while(0);if((h|0)==20){h=0;if(a[b+868+(l<<6)+44>>0]|0)h=21}if((h|0)==21){e=e+1|0;c[d>>2]=e;f=f+-1|0;c[d+4>>2]=f}l=l+1|0}while((l|0)!=3);return}function Pg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;l=i;i=i+96|0;g=c[b+8>>2]|0;if((g|0)==(c[b+12>>2]|0)?(k=g|0?g<<1:1,(g|0)<(k|0)):0){if(!k)j=0;else{c[6435]=(c[6435]|0)+1;g=yc((k<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}j=g;g=c[b+8>>2]|0}if((g|0)>0){h=0;do{c[j+(h<<2)>>2]=c[(c[b+16>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0))}h=c[b+16>>2]|0;if(h){if(a[b+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0);g=c[b+8>>2]|0}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=j;c[b+12>>2]=k}c[(c[b+16>>2]|0)+(g<<2)>>2]=d;c[b+8>>2]=g+1;c[l+32>>2]=c[d+4>>2];c[l+32+4>>2]=c[d+4+4>>2];c[l+32+8>>2]=c[d+4+8>>2];c[l+32+12>>2]=c[d+4+12>>2];c[l+32+16>>2]=c[d+20>>2];c[l+32+16+4>>2]=c[d+20+4>>2];c[l+32+16+8>>2]=c[d+20+8>>2];c[l+32+16+12>>2]=c[d+20+12>>2];c[l+32+32>>2]=c[d+36>>2];c[l+32+32+4>>2]=c[d+36+4>>2];c[l+32+32+8>>2]=c[d+36+8>>2];c[l+32+32+12>>2]=c[d+36+12>>2];c[l+32+48>>2]=c[d+52>>2];c[l+32+48+4>>2]=c[d+52+4>>2];c[l+32+48+8>>2]=c[d+52+8>>2];c[l+32+48+12>>2]=c[d+52+12>>2];k=c[d+192>>2]|0;mc[c[(c[k>>2]|0)+8>>2]&127](k,l+32|0,l+16|0,l);k=c[b+68>>2]|0;c[d+188>>2]=gc[c[(c[k>>2]|0)+8>>2]&3](k,l+16|0,l,c[(c[d+192>>2]|0)+4>>2]|0,d,e,f,c[b+24>>2]|0,0)|0;i=l;return}function Qg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0,x=0,y=0;x=i;i=i+16|0;f=c[a+52>>2]|0;w=+g[a+28+(((f+2|0)%3|0)<<2)>>2];if((e|0)<=0){i=x;return}h=0;while(1){c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;c[x+(f<<2)>>2]=c[a+28+(f<<2)>>2];f=b+(h<<4)|0;u=b+(h<<4)+4|0;v=b+(h<<4)+8|0;j=w*+g[f>>2]+ +g[x>>2];k=w*+g[u>>2]+ +g[x+4>>2];l=w*+g[v>>2]+ +g[x+8>>2];m=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);n=+g[f>>2];o=+g[u>>2];p=+g[v>>2];if(n*(j-m*n)+o*(k-m*o)+p*(l-m*p)>-999999984306749440.0){g[d+(h<<4)>>2]=j-m*n;g[d+(h<<4)+4>>2]=k-m*o;g[d+(h<<4)+8>>2]=l-m*p;g[d+(h<<4)+12>>2]=0.0;q=+g[f>>2];s=+g[u>>2];t=+g[v>>2];r=n*(j-m*n)+o*(k-m*o)+p*(l-m*p)}else{q=n;s=o;t=p;r=-999999984306749440.0}c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[x+12>>2]=0;y=c[a+52>>2]|0;g[x+(y<<2)>>2]=-+g[a+28+(y<<2)>>2];p=w*q+ +g[x>>2];o=w*s+ +g[x+4>>2];m=w*t+ +g[x+8>>2];n=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);l=+g[f>>2];k=+g[u>>2];j=+g[v>>2];if(l*(p-n*l)+k*(o-n*k)+j*(m-n*j)>r){g[d+(h<<4)>>2]=p-n*l;g[d+(h<<4)+4>>2]=o-n*k;g[d+(h<<4)+8>>2]=m-n*j;g[d+(h<<4)+12>>2]=0.0}h=h+1|0;if((h|0)==(e|0))break;f=c[a+52>>2]|0}i=x;return}function Rg(a,b,d,e,f,h,i,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=+j;k=k|0;l=+l;var m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;c[a>>2]=c[h>>2];c[a+4>>2]=c[h+4>>2];c[a+8>>2]=c[h+8>>2];c[a+12>>2]=c[h+12>>2];s=+g[e+4>>2];v=+g[a+8>>2];w=+g[e+8>>2];p=+g[a+4>>2];m=+g[a>>2];r=+g[e>>2];u=(s*v-w*p)*+g[b>>2]+ +g[b+4>>2]*(w*m-v*r)+(p*r-s*m)*+g[b+8>>2];t=(s*v-w*p)*+g[b+16>>2]+(w*m-v*r)*+g[b+20>>2]+(p*r-s*m)*+g[b+24>>2];s=(s*v-w*p)*+g[b+32>>2]+(w*m-v*r)*+g[b+36>>2]+(p*r-s*m)*+g[b+40>>2];g[a+16>>2]=u;g[a+20>>2]=t;g[a+24>>2]=s;g[a+28>>2]=0.0;r=+g[f+4>>2];w=+g[f+8>>2];n=+g[f>>2];q=+g[d>>2]*(r*-v-w*-p)+ +g[d+4>>2]*(w*-m-n*-v)+(n*-p-r*-m)*+g[d+8>>2];o=(r*-v-w*-p)*+g[d+16>>2]+(w*-m-n*-v)*+g[d+20>>2]+(n*-p-r*-m)*+g[d+24>>2];m=(r*-v-w*-p)*+g[d+32>>2]+(w*-m-n*-v)*+g[d+36>>2]+(n*-p-r*-m)*+g[d+40>>2];g[a+32>>2]=q;g[a+36>>2]=o;g[a+40>>2]=m;g[a+44>>2]=0.0;u=+g[i>>2]*u;t=+g[i+4>>2]*t;s=+g[i+8>>2]*s;g[a+48>>2]=u;g[a+52>>2]=t;g[a+56>>2]=s;g[a+60>>2]=0.0;r=+g[k>>2]*q;p=+g[k+4>>2]*o;n=+g[k+8>>2]*m;g[a+64>>2]=r;g[a+68>>2]=p;g[a+72>>2]=n;g[a+76>>2]=0.0;g[a+80>>2]=u*+g[a+16>>2]+t*+g[a+20>>2]+s*+g[a+24>>2]+j+l+(r*q+p*o+n*m);return}function Sg(b){b=b|0;var d=0,e=0,f=0;c[b>>2]=4144;if(a[b+272>>0]|0?(d=c[b+204>>2]|0,Ab[c[c[d>>2]>>2]&255](d),d=c[b+204>>2]|0,d|0):0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+196>>2]|0;if(d|0?(Ab[c[c[d>>2]>>2]&255](d),e=c[b+196>>2]|0,e|0):0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}if(a[b+273>>0]|0?(f=c[b+200>>2]|0,Ab[c[c[f>>2]>>2]&255](f),f=c[b+200>>2]|0,f|0):0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}d=c[b+316>>2]|0;if(d|0){if(a[b+320>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+316>>2]=0}a[b+320>>0]=1;c[b+316>>2]=0;c[b+308>>2]=0;c[b+312>>2]=0;d=c[b+288>>2]|0;if(d|0){if(a[b+292>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+288>>2]=0}a[b+292>>0]=1;c[b+288>>2]=0;c[b+280>>2]=0;c[b+284>>2]=0;d=c[b+240>>2]|0;if(d|0){if(a[b+244>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=0;c[b+232>>2]=0;c[b+236>>2]=0;d=c[b+220>>2]|0;if(d|0){if(a[b+224>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+220>>2]=0}a[b+224>>0]=1;c[b+220>>2]=0;c[b+212>>2]=0;c[b+216>>2]=0;d=c[b+188>>2]|0;if(!d){a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;f=b+184|0;c[f>>2]=0;_j(b);return}if(a[b+192>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+188>>2]=0;a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;f=b+184|0;c[f>>2]=0;_j(b);return}function Tg(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;h=i;i=i+64|0;a[d+84>>0]=0;c[h>>2]=c[b+4>>2];c[h+4>>2]=c[b+4+4>>2];c[h+8>>2]=c[b+4+8>>2];c[h+12>>2]=c[b+4+12>>2];c[h+16>>2]=c[b+20>>2];c[h+16+4>>2]=c[b+20+4>>2];c[h+16+8>>2]=c[b+20+8>>2];c[h+16+12>>2]=c[b+20+12>>2];c[h+32>>2]=c[b+36>>2];c[h+32+4>>2]=c[b+36+4>>2];c[h+32+8>>2]=c[b+36+8>>2];c[h+32+12>>2]=c[b+36+12>>2];c[h+48>>2]=c[b+52>>2];c[h+48+4>>2]=c[b+52+4>>2];c[h+48+8>>2]=c[b+52+8>>2];c[h+48+12>>2]=c[b+52+12>>2];if(e?(f=c[b+480>>2]|0,f|0):0)Cb[c[(c[f>>2]|0)+8>>2]&127](f,h);w=+g[d+156>>2];u=+g[h>>2];v=+g[d+160>>2];t=+g[h+4>>2];o=+g[d+164>>2];s=+g[h+8>>2];r=+g[h+16>>2];q=+g[h+20>>2];p=+g[h+24>>2];n=+g[h+32>>2];l=+g[h+36>>2];j=+g[h+40>>2];m=w*r+v*q+o*p+ +g[h+52>>2];k=w*n+v*l+o*j+ +g[h+56>>2];g[d+36>>2]=w*u+v*t+o*s+ +g[h+48>>2];g[d+40>>2]=m;g[d+44>>2]=k;g[d+48>>2]=0.0;k=+g[d+172>>2];m=+g[d+176>>2];o=+g[d+180>>2];g[d+52>>2]=u*k+t*m+s*o;g[d+56>>2]=k*r+m*q+o*p;g[d+60>>2]=k*n+m*l+o*j;g[d+64>>2]=0.0;o=+g[d+188>>2];m=+g[d+192>>2];k=+g[d+196>>2];g[d+68>>2]=u*o+t*m+s*k;g[d+72>>2]=o*r+m*q+k*p;g[d+76>>2]=o*n+m*l+k*j;g[d+80>>2]=0.0;i=h;return}function Ug(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0.0;a:do if(b>>>0<=20)do switch(b|0){case 9:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=b;break a}case 10:{b=(c[d>>2]|0)+(4-1)&~(4-1);e=c[b>>2]|0;c[d>>2]=b+4;c[a>>2]=e;c[a+4>>2]=((e|0)<0)<<31>>31;break a}case 11:{b=(c[d>>2]|0)+(4-1)&~(4-1);e=c[b>>2]|0;c[d>>2]=b+4;c[a>>2]=e;c[a+4>>2]=0;break a}case 12:{f=(c[d>>2]|0)+(8-1)&~(8-1);b=c[f>>2]|0;e=c[f+4>>2]|0;c[d>>2]=f+8;c[a>>2]=b;c[a+4>>2]=e;break a}case 13:{e=(c[d>>2]|0)+(4-1)&~(4-1);f=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=(f&65535)<<16>>16;c[a+4>>2]=(((f&65535)<<16>>16|0)<0)<<31>>31;break a}case 14:{e=(c[d>>2]|0)+(4-1)&~(4-1);f=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=f&65535;c[a+4>>2]=0;break a}case 15:{e=(c[d>>2]|0)+(4-1)&~(4-1);f=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=(f&255)<<24>>24;c[a+4>>2]=(((f&255)<<24>>24|0)<0)<<31>>31;break a}case 16:{e=(c[d>>2]|0)+(4-1)&~(4-1);f=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=f&255;c[a+4>>2]=0;break a}case 17:{f=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[f>>3];c[d>>2]=f+8;h[a>>3]=g;break a}case 18:{f=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[f>>3];c[d>>2]=f+8;h[a>>3]=g;break a}default:break a}while(0);while(0);return}function Vg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0;w=i;i=i+2048|0;if((e|0)>0)f=0;else{i=w;return}do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));t=0;do{if((Eb[c[(c[a>>2]|0)+96>>2]&127](a)|0)>0){r=b+(t<<4)|0;s=b+(t<<4)+4|0;o=b+(t<<4)+8|0;p=d+(t<<4)+12|0;q=d+(t<<4)|0;u=0;do{if(((Eb[c[(c[a>>2]|0)+96>>2]&127](a)|0)-u|0)<128){f=(Eb[c[(c[a>>2]|0)+96>>2]&127](a)|0)-u|0;if((f|0)>0)v=10;else{j=-3402823466385288598117041.0e14;f=-1}}else{f=128;v=10}if((v|0)==10){v=0;h=0;do{ic[c[(c[a>>2]|0)+108>>2]&127](a,h,w+(h<<4)|0);h=h+1|0}while((h|0)!=(f|0));k=+g[r>>2];l=+g[s>>2];m=+g[o>>2];n=0;j=-3402823466385288598117041.0e14;h=-1;do{x=k*+g[w+(n<<4)>>2]+l*+g[w+(n<<4)+4>>2]+m*+g[w+(n<<4)+8>>2];y=x>j;h=y?n:h;j=y?x:j;n=n+1|0}while((n|0)!=(f|0));f=h}if(j>+g[p>>2]){y=w+(f<<4)|0;c[q>>2]=c[y>>2];c[q+4>>2]=c[y+4>>2];c[q+8>>2]=c[y+8>>2];c[q+12>>2]=c[y+12>>2];g[p>>2]=j}u=u+128|0}while((u|0)<(Eb[c[(c[a>>2]|0)+96>>2]&127](a)|0))}t=t+1|0}while((t|0)!=(e|0));i=w;return}function Wg(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0,j=0,l=0,m=0,n=0.0;h=i;i=i+16|0;d=+g[a>>2];e=+g[a+20>>2];f=+g[a+40>>2];if(d+e+f>0.0){f=+O(+(d+e+f+1.0));g[h+12>>2]=f*.5;n=(+g[a+36>>2]-+g[a+24>>2])*(.5/f);g[h>>2]=n;d=(+g[a+8>>2]-+g[a+32>>2])*(.5/f);g[h+4>>2]=d;e=(+g[a+16>>2]-+g[a+4>>2])*(.5/f);g[h+8>>2]=e;a=(g[k>>2]=n,c[k>>2]|0);m=(g[k>>2]=d,c[k>>2]|0);l=(g[k>>2]=e,c[k>>2]|0);j=(g[k>>2]=f*.5,c[k>>2]|0);c[b>>2]=a;a=b+4|0;c[a>>2]=m;a=b+8|0;c[a>>2]=l;a=b+12|0;c[a>>2]=j;i=h;return}else{m=d<e?(e<f?2:1):d<f?2:0;n=+O(+(+g[a+(m<<4)+(m<<2)>>2]-+g[a+((((m+1|0)>>>0)%3|0)<<4)+((((m+1|0)>>>0)%3|0)<<2)>>2]-+g[a+((((m+2|0)>>>0)%3|0)<<4)+((((m+2|0)>>>0)%3|0)<<2)>>2]+1.0));g[h+(m<<2)>>2]=n*.5;g[h+12>>2]=(+g[a+((((m+2|0)>>>0)%3|0)<<4)+((((m+1|0)>>>0)%3|0)<<2)>>2]-+g[a+((((m+1|0)>>>0)%3|0)<<4)+((((m+2|0)>>>0)%3|0)<<2)>>2])*(.5/n);g[h+((((m+1|0)>>>0)%3|0)<<2)>>2]=(+g[a+((((m+1|0)>>>0)%3|0)<<4)+(m<<2)>>2]+ +g[a+(m<<4)+((((m+1|0)>>>0)%3|0)<<2)>>2])*(.5/n);g[h+((((m+2|0)>>>0)%3|0)<<2)>>2]=(+g[a+((((m+2|0)>>>0)%3|0)<<4)+(m<<2)>>2]+ +g[a+(m<<4)+((((m+2|0)>>>0)%3|0)<<2)>>2])*(.5/n);m=c[h>>2]|0;a=c[h+4>>2]|0;j=c[h+8>>2]|0;l=c[h+12>>2]|0;c[b>>2]=m;m=b+4|0;c[m>>2]=a;m=b+8|0;c[m>>2]=j;m=b+12|0;c[m>>2]=l;i=h;return}}function Xg(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+48|0;e=(c[a+48>>2]|0)+4|0;c[e>>2]=c[b>>2];c[e+4>>2]=c[b+4>>2];c[e+8>>2]=c[b+8>>2];c[e+12>>2]=c[b+12>>2];c[d+32>>2]=0;c[d+32+4>>2]=0;c[d+32+8>>2]=0;c[d+32+12>>2]=0;g[d+32>>2]=1.0;ic[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+32>>2]=+g[d+16>>2]+ +g[a+12>>2];g[d+32>>2]=-1.0;ic[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d>>2];c[d+16+4>>2]=c[d+4>>2];c[d+16+8>>2]=c[d+8>>2];c[d+16+12>>2]=c[d+12>>2];g[a+16>>2]=+g[d+16>>2]-+g[a+12>>2];c[d+32>>2]=0;c[d+32+4>>2]=0;c[d+32+8>>2]=0;c[d+32+12>>2]=0;g[d+32+4>>2]=1.0;ic[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+36>>2]=+g[d+16+4>>2]+ +g[a+12>>2];g[d+32+4>>2]=-1.0;ic[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d>>2];c[d+16+4>>2]=c[d+4>>2];c[d+16+8>>2]=c[d+8>>2];c[d+16+12>>2]=c[d+12>>2];g[a+20>>2]=+g[d+16+4>>2]-+g[a+12>>2];c[d+32>>2]=0;c[d+32+4>>2]=0;c[d+32+8>>2]=0;c[d+32+12>>2]=0;g[d+32+8>>2]=1.0;ic[c[(c[a>>2]|0)+68>>2]&127](d+16|0,a,d+32|0);g[a+40>>2]=+g[d+16+8>>2]+ +g[a+12>>2];g[d+32+8>>2]=-1.0;ic[c[(c[a>>2]|0)+68>>2]&127](d,a,d+32|0);c[d+16>>2]=c[d>>2];c[d+16+4>>2]=c[d+4>>2];c[d+16+8>>2]=c[d+8>>2];c[d+16+12>>2]=c[d+12>>2];g[a+24>>2]=+g[d+16+8>>2]-+g[a+12>>2];i=d;return}function Yg(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0;r=i;i=i+16|0;g[e>>2]=3402823466385288598117041.0e14;g[f>>2]=-3402823466385288598117041.0e14;n=c[a+96>>2]|0;if((n|0)>0){q=0;do{t=c[a+104>>2]|0;s=+g[t+(q<<4)>>2]*+g[a+12>>2];p=+g[t+(q<<4)+4>>2]*+g[a+16>>2];o=+g[t+(q<<4)+8>>2]*+g[a+20>>2];l=s*+g[b>>2]+p*+g[b+4>>2]+o*+g[b+8>>2]+ +g[b+48>>2];m=s*+g[b+16>>2]+p*+g[b+20>>2]+o*+g[b+24>>2]+ +g[b+52>>2];o=s*+g[b+32>>2]+p*+g[b+36>>2]+o*+g[b+40>>2]+ +g[b+56>>2];p=l*+g[d>>2]+m*+g[d+4>>2]+o*+g[d+8>>2];if(p<+g[e>>2]){g[e>>2]=p;g[h>>2]=l;g[h+4>>2]=m;g[h+8>>2]=o;g[h+12>>2]=0.0}if(p>+g[f>>2]){g[f>>2]=p;g[j>>2]=l;g[j+4>>2]=m;g[j+8>>2]=o;g[j+12>>2]=0.0}q=q+1|0}while((q|0)!=(n|0));s=+g[f>>2];m=s;n=(g[k>>2]=s,c[k>>2]|0)}else{m=-3402823466385288598117041.0e14;n=-8388609}l=+g[e>>2];if(!(l>m)){i=r;return}c[e>>2]=n;g[f>>2]=l;c[r>>2]=c[h>>2];c[r+4>>2]=c[h+4>>2];c[r+8>>2]=c[h+8>>2];c[r+12>>2]=c[h+12>>2];c[h>>2]=c[j>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[j>>2]=c[r>>2];c[j+4>>2]=c[r+4>>2];c[j+8>>2]=c[r+8>>2];c[j+12>>2]=c[r+12>>2];i=r;return}function Zg(a,b,c,d,e,f,h){a=a|0;b=+b;c=+c;d=+d;e=e|0;f=+f;h=h|0;var j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;l=i;i=i+16|0;k=c*f+ +g[a+52>>2];j=d*f+ +g[a+56>>2];g[h+48>>2]=b*f+ +g[a+48>>2];g[h+52>>2]=k;g[h+56>>2]=j;g[h+60>>2]=0.0;j=+g[e>>2];k=+g[e+4>>2];c=+g[e+8>>2];d=+O(+(j*j+k*k+c*c));d=d*f>.7853981852531433?.7853981852531433/f:d;if(d<1.0000000474974513e-03)b=f*.5-d*f*f*f*.02083333395421505*d;else b=+R(+(d*.5*f))/d;o=j*b;n=k*b;j=c*b;q=+Q(+(d*f*.5));Wg(a,l);b=+g[l>>2];p=+g[l+12>>2];c=+g[l+8>>2];f=+g[l+4>>2];r=1.0/+O(+((q*p-o*b-n*f-j*c)*(q*p-o*b-n*f-j*c)+((j*p+q*c+o*f-n*b)*(j*p+q*c+o*f-n*b)+((q*b+o*p+n*c-j*f)*(q*b+o*p+n*c-j*f)+(j*b+(n*p+q*f)-o*c)*(j*b+(n*p+q*f)-o*c)))));d=(q*b+o*p+n*c-j*f)*r;k=r*(j*b+(n*p+q*f)-o*c);m=r*(j*p+q*c+o*f-n*b);c=r*(q*p-o*b-n*f-j*c);j=d*(2.0/(c*c+(m*m+(d*d+k*k))));f=k*(2.0/(c*c+(m*m+(d*d+k*k))));b=m*(2.0/(c*c+(m*m+(d*d+k*k))));g[h>>2]=1.0-(k*f+m*b);g[h+4>>2]=d*f-c*b;g[h+8>>2]=d*b+c*f;g[h+12>>2]=0.0;g[h+16>>2]=d*f+c*b;g[h+20>>2]=1.0-(d*j+m*b);g[h+24>>2]=k*b-c*j;g[h+28>>2]=0.0;g[h+32>>2]=d*b-c*f;g[h+36>>2]=k*b+c*j;g[h+40>>2]=1.0-(d*j+k*f);g[h+44>>2]=0.0;i=l;return}function _g(b,d,e){b=b|0;d=+d;e=e|0;var f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;f=c[b+8>>2]|0;if(f|0?(c[f+204>>2]&3|0)==0:0){if((c[f+216>>2]&-2|0)!=4)c[f+216>>2]=1;g[f+220>>2]=0.0}f=c[b+12>>2]|0;if(f|0?(c[f+204>>2]&3|0)==0:0){if((c[f+216>>2]&-2|0)!=4)c[f+216>>2]=1;g[f+220>>2]=0.0}f=c[b+20>>2]|0;if(f|0?(c[f+204>>2]&3|0)==0:0){if((c[f+216>>2]&-2|0)!=4)c[f+216>>2]=1;g[f+220>>2]=0.0}f=c[b+24>>2]|0;if(f|0?(c[f+204>>2]&3|0)==0:0){if((c[f+216>>2]&-2|0)!=4)c[f+216>>2]=1;g[f+220>>2]=0.0}f=c[b+156>>2]|0;c[b+156>>2]=f+1;a[b+152>>0]=(f|0)>=(c[b+160>>2]|0)&1;if(f|0){c[b+72>>2]=0;c[b+72+4>>2]=0;c[b+72+8>>2]=0;c[b+72+12>>2]=0;c[b+72+16>>2]=0;c[b+72+20>>2]=0;c[b+72+24>>2]=0;c[b+72+28>>2]=0;return}j=+g[b+64>>2];i=1.0/d*+g[b+72>>2]*j;h=1.0/d*j*+g[b+76>>2];d=1.0/d*j*+g[b+80>>2];g[b+72>>2]=i;g[b+76>>2]=h;g[b+80>>2]=d;g[b+84>>2]=0.0;j=+g[b+68>>2];if(j>0.0){l=j*i*+g[b+120>>2]+j*h*+g[b+124>>2]+j*d*+g[b+128>>2];k=j*i*+g[b+136>>2]+j*h*+g[b+140>>2]+j*d*+g[b+144>>2];g[b+88>>2]=j*i*+g[b+104>>2]+j*h*+g[b+108>>2]+j*d*+g[b+112>>2];g[b+92>>2]=l;g[b+96>>2]=k;g[b+100>>2]=0.0;g[b+72>>2]=(1.0-j)*i;g[b+76>>2]=(1.0-j)*h;g[b+80>>2]=(1.0-j)*d;i=(1.0-j)*i;h=(1.0-j)*h;d=(1.0-j)*d}g[b+72>>2]=1.0/+(e|0)*i;g[b+76>>2]=1.0/+(e|0)*h;g[b+80>>2]=1.0/+(e|0)*d;return}function $g(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;while(1){k=c[a+12>>2]|0;l=c[k+(((b+d|0)/2|0)<<2)>>2]|0;e=b;f=d;while(1){j=c[(c[l+740>>2]|0)+208>>2]|0;if((j|0)>-1)while(1){h=c[k+(e<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((g|0)<(j|0))e=e+1|0;else break}else{i=c[(c[l+744>>2]|0)+208>>2]|0;while(1){h=c[k+(e<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((g|0)<(i|0))e=e+1|0;else break}}if((j|0)>-1)while(1){h=c[k+(f<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((j|0)<(g|0))f=f+-1|0;else break}else{i=c[(c[l+744>>2]|0)+208>>2]|0;while(1){h=c[k+(f<<2)>>2]|0;g=c[(c[h+740>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+744>>2]|0)+208>>2]|0;if((i|0)<(g|0))f=f+-1|0;else break}}if((e|0)<=(f|0)){i=k+(e<<2)|0;j=c[i>>2]|0;c[i>>2]=c[k+(f<<2)>>2];c[(c[a+12>>2]|0)+(f<<2)>>2]=j;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;k=c[a+12>>2]|0}if((f|0)>(b|0))$g(a,b,f);if((e|0)<(d|0))b=e;else break}return}function ah(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0;k=i;i=i+64|0;n=+g[d>>2];o=+g[d+4>>2];m=+g[d+8>>2];p=n*+g[b+4>>2]+o*+g[b+20>>2]+m*+g[b+36>>2];q=n*+g[b+8>>2]+o*+g[b+24>>2]+m*+g[b+40>>2];g[k+48>>2]=+g[b>>2]*n+ +g[b+16>>2]*o+ +g[b+32>>2]*m;g[k+48+4>>2]=p;g[k+48+8>>2]=q;g[k+48+12>>2]=0.0;ic[c[(c[a>>2]|0)+64>>2]&127](k+32|0,a,k+48|0);q=+g[k+32>>2];p=+g[k+32+4>>2];m=+g[k+32+8>>2];o=q*+g[b>>2]+p*+g[b+4>>2]+m*+g[b+8>>2]+ +g[b+48>>2];n=q*+g[b+16>>2]+p*+g[b+20>>2]+m*+g[b+24>>2]+ +g[b+52>>2];m=q*+g[b+32>>2]+p*+g[b+36>>2]+m*+g[b+40>>2]+ +g[b+56>>2];r=c[(c[a>>2]|0)+64>>2]|0;p=-+g[k+48+4>>2];q=-+g[k+48+8>>2];g[k>>2]=-+g[k+48>>2];g[k+4>>2]=p;g[k+8>>2]=q;g[k+12>>2]=0.0;ic[r&127](k+16|0,a,k);q=+g[k+16>>2];p=+g[k+16+4>>2];h=+g[k+16+8>>2];l=q*+g[b>>2]+p*+g[b+4>>2]+h*+g[b+8>>2]+ +g[b+48>>2];j=q*+g[b+16>>2]+p*+g[b+20>>2]+h*+g[b+24>>2]+ +g[b+52>>2];h=q*+g[b+32>>2]+p*+g[b+36>>2]+h*+g[b+40>>2]+ +g[b+56>>2];g[e>>2]=o*+g[d>>2]+n*+g[d+4>>2]+m*+g[d+8>>2];h=l*+g[d>>2]+j*+g[d+4>>2]+h*+g[d+8>>2];g[f>>2]=h;j=+g[e>>2];if(!(j>h)){i=k;return}g[e>>2]=h;g[f>>2]=j;i=k;return}function bh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;while(1){k=c[a+12>>2]|0;l=c[k+(((b+d|0)/2|0)<<2)>>2]|0;e=b;f=d;while(1){j=c[(c[l+28>>2]|0)+208>>2]|0;if((j|0)>-1)while(1){h=c[k+(e<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((g|0)<(j|0))e=e+1|0;else break}else{i=c[(c[l+32>>2]|0)+208>>2]|0;while(1){h=c[k+(e<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((g|0)<(i|0))e=e+1|0;else break}}if((j|0)>-1)while(1){h=c[k+(f<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((j|0)<(g|0))f=f+-1|0;else break}else{i=c[(c[l+32>>2]|0)+208>>2]|0;while(1){h=c[k+(f<<2)>>2]|0;g=c[(c[h+28>>2]|0)+208>>2]|0;if((g|0)<=-1)g=c[(c[h+32>>2]|0)+208>>2]|0;if((i|0)<(g|0))f=f+-1|0;else break}}if((e|0)<=(f|0)){i=k+(e<<2)|0;j=c[i>>2]|0;c[i>>2]=c[k+(f<<2)>>2];c[(c[a+12>>2]|0)+(f<<2)>>2]=j;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;k=c[a+12>>2]|0}if((f|0)>(b|0))bh(a,b,f);if((e|0)<(d|0))b=e;else break}return}function ch(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+16|0;h=c[a+12>>2]|0;j=c[h+(((d+b|0)/2|0)<<4)>>2]|0;k=c[h+(((d+b|0)/2|0)<<4)+4>>2]|0;l=c[h+(((d+b|0)/2|0)<<4)+8>>2]|0;e=b;f=d;while(1){g=e;while(1){e=c[h+(g<<4)+4>>2]|0;if((e|0)>=(k|0)){if((e|0)!=(k|0))break;e=c[h+(g<<4)>>2]|0;if((e|0)>=(j|0)){if((e|0)!=(j|0))break;if((c[h+(g<<4)+8>>2]|0)>=(l|0))break}}g=g+1|0}while(1){e=c[h+(f<<4)+4>>2]|0;if((k|0)>=(e|0)){if((k|0)!=(e|0))break;e=c[h+(f<<4)>>2]|0;if((j|0)>=(e|0)){if((j|0)!=(e|0))break;if((l|0)>=(c[h+(f<<4)+8>>2]|0))break}}f=f+-1|0}if((g|0)>(f|0))e=g;else{e=h+(g<<4)|0;c[m>>2]=c[e>>2];c[m+4>>2]=c[e+4>>2];c[m+8>>2]=c[e+8>>2];c[m+12>>2]=c[e+12>>2];h=h+(f<<4)|0;c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];e=(c[a+12>>2]|0)+(f<<4)|0;c[e>>2]=c[m>>2];c[e+4>>2]=c[m+4>>2];c[e+8>>2]=c[m+8>>2];c[e+12>>2]=c[m+12>>2];e=g+1|0;f=f+-1|0}if((e|0)>(f|0))break;h=c[a+12>>2]|0}if((f|0)>(b|0))ch(a,b,f);if((e|0)>=(d|0)){i=m;return}ch(a,e,d);i=m;return}function dh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0;e=i;i=i+48|0;y=+g[d>>2];n=+g[b>>2];x=+g[d+16>>2];l=+g[b+4>>2];w=+g[d+32>>2];j=+g[b+8>>2];v=+g[d+4>>2];u=+g[d+20>>2];t=+g[d+36>>2];k=+g[d+8>>2];m=+g[d+24>>2];o=+g[d+40>>2];q=+g[b+16>>2];p=+g[b+20>>2];h=+g[b+24>>2];s=+g[b+32>>2];r=+g[b+36>>2];f=+g[b+40>>2];g[e>>2]=y*n+x*l+w*j;g[e+4>>2]=v*n+u*l+t*j;g[e+8>>2]=k*n+m*l+o*j;g[e+12>>2]=0.0;g[e+16>>2]=y*q+x*p+w*h;g[e+20>>2]=v*q+u*p+t*h;g[e+24>>2]=k*q+m*p+o*h;g[e+28>>2]=0.0;g[e+32>>2]=y*s+x*r+w*f;g[e+36>>2]=v*s+u*r+t*f;g[e+40>>2]=k*s+m*r+o*f;g[e+44>>2]=0.0;o=+g[d+48>>2];m=+g[d+52>>2];k=+g[d+56>>2];f=o*s+m*r+k*f+ +g[b+56>>2];h=o*q+m*p+k*h+ +g[b+52>>2];j=o*n+m*l+k*j+ +g[b+48>>2];c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];c[a+16>>2]=c[e+16>>2];c[a+16+4>>2]=c[e+16+4>>2];c[a+16+8>>2]=c[e+16+8>>2];c[a+16+12>>2]=c[e+16+12>>2];c[a+32>>2]=c[e+32>>2];c[a+32+4>>2]=c[e+32+4>>2];c[a+32+8>>2]=c[e+32+8>>2];c[a+32+12>>2]=c[e+32+12>>2];g[a+48>>2]=j;g[a+52>>2]=h;g[a+56>>2]=f;g[a+60>>2]=0.0;i=e;return}function eh(a,b){a=+a;b=+b;var d=0,e=0,f=0,h=0,i=0,j=0,l=0,m=0,n=0,o=0.0;m=(g[k>>2]=a,c[k>>2]|0);i=(g[k>>2]=b,c[k>>2]|0);a:do if((i<<1|0)!=0?(o=+N(+b),!((g[k>>2]=o,c[k>>2]|0)>>>0>2139095040|(m>>>23&255|0)==255)):0){if(m<<1>>>0<=i<<1>>>0)return +((m<<1|0)==(i<<1|0)?a*0.0:a);if(!(m>>>23&255)){if((m<<9|0)>-1){d=0;e=m<<9;do{d=d+-1|0;e=e<<1}while((e|0)>-1);e=d}else e=0;d=e;f=m<<1-e}else{d=m>>>23&255;f=m&8388607|8388608}if(!(i>>>23&255)){if((i<<9|0)>-1){e=0;h=i<<9;do{e=e+-1|0;h=h<<1}while((h|0)>-1)}else e=0;j=e;l=i<<1-e}else{j=i>>>23&255;l=i&8388607|8388608}h=f-l|0;b:do if((d|0)>(j|0)){i=(h|0)>-1;e=h;while(1){if(i){if((f|0)==(l|0))break}else e=f;f=e<<1;d=d+-1|0;h=f-l|0;if((d|0)>(j|0)){i=(h|0)>-1;e=h}else{e=h;h=(h|0)>-1;break b}}b=a*0.0;break a}else{e=h;h=(h|0)>-1}while(0);if(h){if((f|0)==(l|0)){b=a*0.0;break}}else e=f;if(e>>>0<8388608)do{e=e<<1;d=d+-1|0}while(e>>>0<8388608);if((d|0)>0)d=e+-8388608|d<<23;else d=e>>>(1-d|0);b=(c[k>>2]=d|m&-2147483648,+g[k>>2])}else n=3;while(0);if((n|0)==3)b=a*b/(a*b);return +b}function fh(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0,m=0,n=0,o=0.0,p=0.0,q=0;n=i;i=i+16|0;if((f|0)>-3&(f+3|0)>-1){if((f+3|0)!=0?(c[6435]=(c[6435]|0)+1,h=yc((f+3<<4|3)+16|0)|0,(h|0)!=0):0){c[(h+4+15&-16)+-4>>2]=h;a=h+4+15&-16}else a=0;h=0;do{m=a+(h<<4)|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];h=h+1|0}while((h|0)!=(f+3|0));m=a}else m=0;if((f|0)>-3){h=m;l=0;while(1){if(!l)j=0.0;else{a=l;k=.5;j=0.0;while(1){j=(a&1|0)==0?j:j+k;a=a>>1;if(!a)break;else k=k*.5}}k=j*2.0+-1.0;o=(+(l<<1|0)*3.1415927410125732+3.1415927410125732)/+(f+3|0);p=+O(+(1.0-k*k));j=p*+R(+o);g[h>>2]=p*+Q(+o);g[h+4>>2]=j;g[h+8>>2]=k;g[h+12>>2]=0.0;l=l+1|0;if((l|0)==(f+3|0))break;else h=h+16|0}a=0;do{q=m+(a<<4)|0;h=m+(a<<4)+4|0;l=m+(a<<4)+8|0;o=+g[h>>2]*+g[e+4>>2]+ +g[d+4>>2];p=+g[l>>2]*+g[e+8>>2]+ +g[d+8>>2];g[q>>2]=+g[q>>2]*+g[e>>2]+ +g[d>>2];g[h>>2]=o;g[l>>2]=p;g[m+(a<<4)+12>>2]=0.0;a=a+1|0}while((a|0)<(f+3|0))}a=rc(b,m,f+3|0,1)|0;if(!m){i=n;return a|0}c[6436]=(c[6436]|0)+1;hd(c[m+-4>>2]|0);i=n;return a|0}function gh(a,b,d,e,f,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0.0,m=0.0,n=0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0;r=i;i=i+16|0;g[e>>2]=3402823466385288598117041.0e14;g[f>>2]=-3402823466385288598117041.0e14;n=c[a+8>>2]|0;if((n|0)>0){q=0;do{t=c[a+16>>2]|0;s=+g[t+(q<<4)>>2];p=+g[t+(q<<4)+4>>2];o=+g[t+(q<<4)+8>>2];l=s*+g[b>>2]+p*+g[b+4>>2]+o*+g[b+8>>2]+ +g[b+48>>2];m=s*+g[b+16>>2]+p*+g[b+20>>2]+o*+g[b+24>>2]+ +g[b+52>>2];o=s*+g[b+32>>2]+p*+g[b+36>>2]+o*+g[b+40>>2]+ +g[b+56>>2];p=l*+g[d>>2]+m*+g[d+4>>2]+o*+g[d+8>>2];if(p<+g[e>>2]){g[e>>2]=p;g[h>>2]=l;g[h+4>>2]=m;g[h+8>>2]=o;g[h+12>>2]=0.0}if(p>+g[f>>2]){g[f>>2]=p;g[j>>2]=l;g[j+4>>2]=m;g[j+8>>2]=o;g[j+12>>2]=0.0}q=q+1|0}while((q|0)!=(n|0));s=+g[f>>2];m=s;n=(g[k>>2]=s,c[k>>2]|0)}else{m=-3402823466385288598117041.0e14;n=-8388609}l=+g[e>>2];if(!(l>m)){i=r;return}c[e>>2]=n;g[f>>2]=l;c[r>>2]=c[h>>2];c[r+4>>2]=c[h+4>>2];c[r+8>>2]=c[h+8>>2];c[r+12>>2]=c[h+12>>2];c[h>>2]=c[j>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];c[j>>2]=c[r>>2];c[j+4>>2]=c[r+4>>2];c[j+8>>2]=c[r+8>>2];c[j+12>>2]=c[r+12>>2];i=r;return}function hh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0;if((c[a>>2]|0)==(b|0)){c[a>>2]=0;a=0;return a|0}e=c[b+32>>2]|0;d=c[e+32>>2]|0;b=c[e+36+(((c[e+40>>2]|0)!=(b|0)&1)<<2)>>2]|0;if(!d){c[a>>2]=b;c[b+32>>2]=0;d=c[a+4>>2]|0;if(!d)d=b;else{c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0);d=c[a>>2]|0}c[a+4>>2]=e;a=d;return a|0}c[d+36+(((c[d+40>>2]|0)==(e|0)&1)<<2)>>2]=b;c[b+32>>2]=d;b=c[a+4>>2]|0;if(b|0){c[6436]=(c[6436]|0)+1;hd(c[b+-4>>2]|0)}c[a+4>>2]=e;do{s=+g[d>>2];x=d+4|0;q=+g[x>>2];v=d+8|0;o=+g[v>>2];y=d+16|0;m=+g[y>>2];w=d+20|0;i=+g[w>>2];e=d+24|0;k=+g[e>>2];u=c[d+36>>2]|0;b=c[d+40>>2]|0;t=+g[u>>2];r=+g[b>>2];r=t<r?t:r;g[d>>2]=r;t=+g[u+16>>2];l=+g[b+16>>2];l=t>l?t:l;g[y>>2]=l;t=+g[u+4>>2];p=+g[b+4>>2];p=t<p?t:p;g[x>>2]=p;t=+g[u+20>>2];h=+g[b+20>>2];h=t>h?t:h;g[w>>2]=h;t=+g[u+8>>2];n=+g[b+8>>2];n=t<n?t:n;g[v>>2]=n;t=+g[u+24>>2];j=+g[b+24>>2];j=t>j?t:j;g[e>>2]=j;if(!(s!=r|q!=p|o!=n|m!=l)?!(k!=j|i!=h):0){f=14;break}d=c[d+32>>2]|0}while((d|0)!=0);if((f|0)==14)return d|0;y=c[a>>2]|0;return y|0}function ih(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,i=0,j=0;i=c[a+28>>2]|0;e=0.0;f=0.0;h=0.0;j=0;a:while(1){switch(j|0){case 0:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+84>>2]+ +g[a+68>>2];h=+g[a+88>>2]+ +g[a+72>>2];break}case 1:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+84>>2]+ +g[a+68>>2];h=+g[a+72>>2]-+g[a+88>>2];break}case 2:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+68>>2]-+g[a+84>>2];h=+g[a+88>>2]+ +g[a+72>>2];break}case 3:{e=+g[a+80>>2]+ +g[a+64>>2];f=+g[a+68>>2]-+g[a+84>>2];h=+g[a+72>>2]-+g[a+88>>2];break}case 4:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+84>>2]+ +g[a+68>>2];h=+g[a+88>>2]+ +g[a+72>>2];break}case 5:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+84>>2]+ +g[a+68>>2];h=+g[a+72>>2]-+g[a+88>>2];break}case 6:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+68>>2]-+g[a+84>>2];h=+g[a+88>>2]+ +g[a+72>>2];break}case 7:{e=+g[a+64>>2]-+g[a+80>>2];f=+g[a+68>>2]-+g[a+84>>2];h=+g[a+72>>2]-+g[a+88>>2];break}default:{}}if((i|0)>0){b=c[a+36>>2]|0;d=0;do{if(+g[b+(d*36|0)+32>>2]+(e*+g[b+(d*36|0)+20>>2]+f*+g[b+(d*36|0)+24>>2]+h*+g[b+(d*36|0)+28>>2])>0.0){b=0;d=16;break a}d=d+1|0}while((d|0)<(i|0))}j=j+1|0;if((j|0)>=8){b=1;d=16;break}}if((d|0)==16)return b|0;return 0}function jh(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var h=0,i=0.0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;o=+g[d>>2];if(+g[b>>2]<=o){i=+g[d+4>>2];if((((+g[b+4>>2]<=i?+g[b+8>>2]<=+g[d+8>>2]:0)?+g[b+16>>2]>=+g[d+16>>2]:0)?+g[b+20>>2]>=+g[d+20>>2]:0)?+g[b+24>>2]>=+g[d+24>>2]:0){d=0;return d|0}else h=d+4|0}else{h=d+4|0;i=+g[d+4>>2]}g[d>>2]=o-f;m=i-f;g[h>>2]=m;p=+g[d+8>>2]-f;g[d+8>>2]=p;i=+g[d+16>>2]+f;g[d+16>>2]=i;n=+g[d+20>>2]+f;g[d+20>>2]=n;q=+g[d+24>>2]+f;g[d+24>>2]=q;l=+g[e>>2];if(l>0.0)g[d+16>>2]=l+i;else g[d>>2]=l+(o-f);i=+g[e+4>>2];if(i>0.0)g[d+20>>2]=i+n;else g[h>>2]=i+m;i=+g[e+8>>2];if(i>0.0)g[d+24>>2]=i+q;else g[d+8>>2]=i+p;h=hh(a,b)|0;a:do if(h){j=c[a+8>>2]|0;if((j|0)<=-1){h=c[a>>2]|0;break}if((j|0)>0){k=0;while(1){e=c[h+32>>2]|0;k=k+1|0;if(!e)break a;if((k|0)>=(j|0)){h=e;break}else h=e}}}else h=0;while(0);c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[b+16>>2]=c[d+16>>2];c[b+20>>2]=c[d+20>>2];c[b+24>>2]=c[d+24>>2];c[b+28>>2]=c[d+28>>2];lf(a,h,b);d=1;return d|0}function kh(a,d,e){a=a|0;d=d|0;e=e|0;si(a,d,e)|0;c[d+52>>2]=c[a+48>>2];c[d+56>>2]=c[a+52>>2];c[d+60>>2]=c[a+56>>2];c[d+64>>2]=c[a+60>>2];c[d+68>>2]=c[a+64>>2];c[d+72>>2]=c[a+68>>2];c[d+76>>2]=c[a+72>>2];c[d+80>>2]=c[a+76>>2];c[d+84>>2]=c[a+80>>2];c[d+88>>2]=c[a+84>>2];c[d+92>>2]=c[a+88>>2];c[d+96>>2]=c[a+92>>2];c[d+100>>2]=c[a+96>>2];c[d+104>>2]=c[a+100>>2];c[d+108>>2]=c[a+104>>2];c[d+112>>2]=c[a+108>>2];c[d+116>>2]=c[a+112>>2];c[d+120>>2]=c[a+116>>2];c[d+124>>2]=c[a+120>>2];c[d+128>>2]=c[a+124>>2];c[d+132>>2]=c[a+128>>2];c[d+136>>2]=c[a+132>>2];c[d+140>>2]=c[a+136>>2];c[d+144>>2]=c[a+140>>2];c[d+148>>2]=c[a+144>>2];c[d+152>>2]=c[a+148>>2];c[d+156>>2]=c[a+152>>2];c[d+160>>2]=c[a+156>>2];c[d+164>>2]=c[a+160>>2];c[d+168>>2]=c[a+164>>2];c[d+172>>2]=c[a+168>>2];c[d+176>>2]=c[a+172>>2];c[d+228>>2]=c[a+868>>2];c[d+212>>2]=c[a+872>>2];c[d+196>>2]=c[a+680>>2];c[d+180>>2]=c[a+696>>2];c[d+232>>2]=c[a+932>>2];c[d+216>>2]=c[a+936>>2];c[d+200>>2]=c[a+684>>2];c[d+184>>2]=c[a+700>>2];c[d+236>>2]=c[a+996>>2];c[d+220>>2]=c[a+1e3>>2];c[d+204>>2]=c[a+688>>2];c[d+188>>2]=c[a+704>>2];a=b[a+1300>>1]|0;c[d+244>>2]=a&255;c[d+248>>2]=(a&65535)>>>8&65535;return 12479}function lh(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;h=(a[b+28>>0]|0)!=0;l=h?e:d;h=h?d:e;j=c[l+4>>2]|0;k=c[j+16>>2]|0;g=c[b+12>>2]|0;if((g|0)<(k|0)){if((c[b+16>>2]|0)<(k|0)){if(!k){d=0;e=g}else{c[6435]=(c[6435]|0)+1;d=yc((k<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+12>>2]|0}if((e|0)>0){f=0;do{c[d+(f<<2)>>2]=c[(c[b+20>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}e=c[b+20>>2]|0;if(e|0){if(a[b+24>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=d;c[b+16>>2]=k;e=b+20|0}else e=b+20|0;d=g;do{c[(c[e>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=(k|0))}c[b+12>>2]=k;if((k|0)<=0){i=m;return}d=0;do{if(!(c[j+64>>2]|0)){e=c[(c[j+24>>2]|0)+(d*80|0)+64>>2]|0;f=c[l+8>>2]|0;g=c[l+12>>2]|0;c[m>>2]=l;c[m+4>>2]=e;c[m+8>>2]=f;c[m+12>>2]=g;c[m+16>>2]=-1;c[m+20>>2]=d;g=c[b+4>>2]|0;g=Ib[c[(c[g>>2]|0)+8>>2]&31](g,m,h,c[b+32>>2]|0)|0;c[(c[b+20>>2]|0)+(d<<2)>>2]=g}else c[(c[b+20>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=(k|0));i=m;return}function mh(){var a=0,b=0,d=0;c[6435]=(c[6435]|0)+1;a=yc(219)|0;if(!a)a=0;else{c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}ml();ml();c[a>>2]=2896;b=a+52|0;d=a+4|0;c[d>>2]=c[5710];c[d+4>>2]=c[5711];c[d+8>>2]=c[5712];c[d+12>>2]=c[5713];d=a+20|0;c[d>>2]=c[5714];c[d+4>>2]=c[5715];c[d+8>>2]=c[5716];c[d+12>>2]=c[5717];d=a+36|0;c[d>>2]=c[5718];c[d+4>>2]=c[5719];c[d+8>>2]=c[5720];c[d+12>>2]=c[5721];c[b>>2]=c[5722];c[b+4>>2]=c[5723];c[b+8>>2]=c[5724];c[b+12>>2]=c[5725];b=a+116|0;d=a+68|0;c[d>>2]=c[5710];c[d+4>>2]=c[5711];c[d+8>>2]=c[5712];c[d+12>>2]=c[5713];d=a+84|0;c[d>>2]=c[5714];c[d+4>>2]=c[5715];c[d+8>>2]=c[5716];c[d+12>>2]=c[5717];d=a+100|0;c[d>>2]=c[5718];c[d+4>>2]=c[5719];c[d+8>>2]=c[5720];c[d+12>>2]=c[5721];c[b>>2]=c[5722];c[b+4>>2]=c[5723];c[b+8>>2]=c[5724];c[b+12>>2]=c[5725];b=a+180|0;d=a+132|0;c[d>>2]=c[5710];c[d+4>>2]=c[5711];c[d+8>>2]=c[5712];c[d+12>>2]=c[5713];d=a+148|0;c[d>>2]=c[5714];c[d+4>>2]=c[5715];c[d+8>>2]=c[5716];c[d+12>>2]=c[5717];d=a+164|0;c[d>>2]=c[5718];c[d+4>>2]=c[5719];c[d+8>>2]=c[5720];c[d+12>>2]=c[5721];c[b>>2]=c[5722];c[b+4>>2]=c[5723];c[b+8>>2]=c[5724];c[b+12>>2]=c[5725];c[a+196>>2]=0;return a|0}function nh(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=c[b+32>>2]|0;if(!d)f=0;else f=c[b+40>>2]|0;i=c[b+52>>2]|0;if(!i)g=0;else g=c[b+60>>2]|0;e=c[b+72>>2]|0;if(!e)h=0;else h=c[b+80>>2]|0;j=c[b+8>>2]|0;+$b[c[(c[j>>2]|0)+12>>2]&3](j,f,d,g,i,h,e,c[b+4>>2]|0,c[b+20>>2]|0,c[b+24>>2]|0);d=c[b+32>>2]|0;if((d|0)<0){if((c[b+36>>2]|0)<0){e=c[b+40>>2]|0;if(e|0){if(a[b+44>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+36>>2]=0}do{c[(c[b+40>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0)}c[b+32>>2]=0;d=c[b+52>>2]|0;if((d|0)<0){if((c[b+56>>2]|0)<0){e=c[b+60>>2]|0;if(e|0){if(a[b+64>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+56>>2]=0}do{c[(c[b+60>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0)}c[b+52>>2]=0;d=c[b+72>>2]|0;if((d|0)>=0){c[b+72>>2]=0;return}if((c[b+76>>2]|0)<0){e=c[b+80>>2]|0;if(e|0){if(a[b+84>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=0;c[b+76>>2]=0}do{c[(c[b+80>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=0);c[b+72>>2]=0;return}function oh(b,d,e){b=b|0;d=+d;e=e|0;var f=0.0,h=0,i=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;j=c[b+712>>2]|0;if(e){if((j|0)>0){e=c[b+720>>2]|0;h=0;do{g[e+(h*104|0)+88>>2]=0.0;h=h+1|0}while((h|0)!=(j|0))}e=c[b+752>>2]|0;if((e|0)>0){h=c[b+760>>2]|0;i=0;do{m=c[h+(i*44|0)+8>>2]|0;l=c[h+(i*44|0)+12>>2]|0;k=c[h+(i*44|0)+16>>2]|0;o=+g[m+8>>2];q=+g[m+12>>2];f=+g[m+16>>2];n=+g[l+8>>2]-o;r=+g[l+12>>2]-q;p=+g[l+16>>2]-f;o=+g[k+8>>2]-o;q=+g[k+12>>2]-q;f=+g[k+16>>2]-f;f=+O(+((n*q-r*o)*(n*q-r*o)+((r*f-p*q)*(r*f-p*q)+(p*o-n*f)*(p*o-n*f))));g[m+88>>2]=f+ +g[m+88>>2];g[l+88>>2]=f+ +g[l+88>>2];g[k+88>>2]=f+ +g[k+88>>2];i=i+1|0}while((i|0)!=(e|0))}if((j|0)<=0){m=b+924|0;a[m>>0]=1;return}e=c[b+720>>2]|0;h=0;do{m=e+(h*104|0)+88|0;g[m>>2]=1.0/+g[m>>2];h=h+1|0}while((h|0)!=(j|0))}if((j|0)<=0){m=b+924|0;a[m>>0]=1;return}i=c[b+720>>2]|0;e=0;f=0.0;do{r=+g[i+(e*104|0)+88>>2];f=f+(r>0.0?1.0/r:0.0);e=e+1|0}while((e|0)!=(j|0));f=1.0/f*d;e=c[b+712>>2]|0;h=0;do{m=i+(h*104|0)+88|0;g[m>>2]=+g[m>>2]/f;h=h+1|0}while((h|0)<(e|0));m=b+924|0;a[m>>0]=1;return}function ph(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;c[6435]=(c[6435]|0)+1;d=yc(39)|0;if(!d)i=0;else{c[(d+4+15&-16)+-4>>2]=d;i=d+4+15&-16}g=i;c[i>>2]=0;c[i+4>>2]=0;c[i+8>>2]=0;c[i+12>>2]=0;c[i+16>>2]=0;if((c[b+872>>2]|0)>0){h=c[c[b+880>>2]>>2]|0;c[i>>2]=c[h>>2];c[i+4>>2]=c[h+4>>2];c[i+8>>2]=c[h+8>>2];c[i+12>>2]=c[h+12>>2];c[i+16>>2]=c[h+16>>2]}else{c[i>>2]=0;c[i+4>>2]=0;c[i+8>>2]=0;c[i+12>>2]=0;c[i+16>>2]=0}e=c[b+872>>2]|0;if((e|0)!=(c[b+876>>2]|0)){h=e;f=b+880|0;f=c[f>>2]|0;f=f+(h<<2)|0;c[f>>2]=g;h=h+1|0;c[b+872>>2]=h;return i|0}h=e|0?e<<1:1;if((e|0)>=(h|0)){h=e;f=b+880|0;f=c[f>>2]|0;f=f+(h<<2)|0;c[f>>2]=g;h=h+1|0;c[b+872>>2]=h;return i|0}if(!h)d=0;else{c[6435]=(c[6435]|0)+1;d=yc((h<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+872>>2]|0}if((e|0)>0){f=0;do{c[d+(f<<2)>>2]=c[(c[b+880>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}f=c[b+880>>2]|0;if(f){if(a[b+884>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0);e=c[b+872>>2]|0}c[b+880>>2]=0}a[b+884>>0]=1;c[b+880>>2]=d;c[b+876>>2]=h;h=e;f=b+880|0;f=c[f>>2]|0;f=f+(h<<2)|0;c[f>>2]=g;h=h+1|0;c[b+872>>2]=h;return i|0}function qh(b,d,e,f,h,i){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0;c[6435]=(c[6435]|0)+1;b=yc((h+2|0)>>>0>268435455?18:(h+2<<4|3)+16|0)|0;if(!b)m=0;else{c[(b+4+15&-16)+-4>>2]=b;m=b+4+15&-16}j=(h+2|0)>>>0>1073741823?-1:h+2<<2;j=(j|0)==0?1:j;while(1){k=yc(j)|0;if(k|0)break;b=c[6564]|0;c[6564]=b+0;if(!b){l=7;break}jc[b&3]()}if((l|0)==7){h=Ya(4)|0;c[h>>2]=9640;pb(h|0,2800,251)}if((h|0)>-2){b=0;do{q=+(b|0)/+(h+1|0);p=+g[e>>2];o=+g[e+4>>2];o=o+q*(+g[f+4>>2]-o);n=+g[e+8>>2];n=n+q*(+g[f+8>>2]-n);g[m+(b<<4)>>2]=p+q*(+g[f>>2]-p);g[m+(b<<4)+4>>2]=o;g[m+(b<<4)+8>>2]=n;g[m+(b<<4)+12>>2]=0.0;g[k+(b<<2)>>2]=1.0;b=b+1|0}while((b|0)<(h+2|0))}c[6435]=(c[6435]|0)+1;b=yc(1271)|0;if(!b)j=0;else{c[(b+4+15&-16)+-4>>2]=b;j=b+4+15&-16}Kc(j,d,h+2|0,m,k);if(i&1|0){g[(c[j+720>>2]|0)+88>>2]=0.0;a[j+924>>0]=1}if(i&2|0){g[(c[j+720>>2]|0)+((h+1|0)*104|0)+88>>2]=0.0;a[j+924>>0]=1}if(m|0){c[6436]=(c[6436]|0)+1;hd(c[m+-4>>2]|0)}hd(k);if((h+2|0)>1)b=1;else return j|0;do{Rf(j,b+-1|0,b,0,0);b=b+1|0}while((b|0)!=(h+2|0));return j|0}function rh(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0,l=0,m=0.0,n=0,o=0,p=0.0,q=0.0;mc[c[(c[a>>2]|0)+8>>2]&127](a,b,f,h);l=c[h>>2]|0;o=c[h+4>>2]|0;i=c[h+8>>2]|0;n=c[f>>2]|0;j=c[f+4>>2]|0;b=c[f+8>>2]|0;m=+g[d>>2];p=+g[d+4>>2];q=+g[d+8>>2];if(m>0.0)l=(g[k>>2]=(c[k>>2]=l,+g[k>>2])+m,c[k>>2]|0);else n=(g[k>>2]=(c[k>>2]=n,+g[k>>2])+m,c[k>>2]|0);if(p>0.0)d=(g[k>>2]=(c[k>>2]=o,+g[k>>2])+p,c[k>>2]|0);else{d=o;j=(g[k>>2]=(c[k>>2]=j,+g[k>>2])+p,c[k>>2]|0)}if(q>0.0)i=(g[k>>2]=(c[k>>2]=i,+g[k>>2])+q,c[k>>2]|0);else b=(g[k>>2]=(c[k>>2]=b,+g[k>>2])+q,c[k>>2]|0);m=+g[e>>2];p=+g[e+4>>2];q=+g[e+8>>2];q=+O(+(m*m+p*p+q*q));q=q*+Sb[c[(c[a>>2]|0)+16>>2]&15](a);c[f>>2]=n;c[f+4>>2]=j;c[f+8>>2]=b;g[f+12>>2]=0.0;c[h>>2]=l;c[h+4>>2]=d;c[h+8>>2]=i;g[h+12>>2]=0.0;g[f>>2]=+g[f>>2]-q;g[f+4>>2]=+g[f+4>>2]-q;g[f+8>>2]=+g[f+8>>2]-q;g[h>>2]=q+ +g[h>>2];g[h+4>>2]=q+ +g[h+4>>2];g[h+8>>2]=q+ +g[h+8>>2];return}function sh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+112|0;m=c[d+4>>2]|0;k=n;l=k+100|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(l|0));h=c[b+712>>2]|0;a:do if((h|0)>(m|0))e=b+720|0;else{if((h|0)<(m|0)?(c[b+716>>2]|0)<(m|0):0){if((m|0)!=0?(c[6435]=(c[6435]|0)+1,e=yc((m*104|3)+16|0)|0,(e|0)!=0):0){c[(e+4+15&-16)+-4>>2]=e;g=e+4+15&-16}else g=0;e=c[b+712>>2]|0;f=0;while(1){if((f|0)>=(e|0))break;k=g+(f*104|0)|0;j=(c[b+720>>2]|0)+(f*104|0)|0;l=k+104|0;do{c[k>>2]=c[j>>2];k=k+4|0;j=j+4|0}while((k|0)<(l|0));f=f+1|0}e=c[b+720>>2]|0;if(e|0){if(!((a[b+724>>0]&1)==0|(e|0)==0)){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[b+720>>2]=0}a[b+724>>0]=1;c[b+720>>2]=g;c[b+716>>2]=m}e=h;while(1){if((e|0)>=(m|0)){e=b+720|0;break a}k=c[b+720>>2]|0;c[k+(e*104|0)>>2]=0;k=k+(e*104|0)+4|0;j=n;l=k+100|0;do{c[k>>2]=c[j>>2];k=k+4|0;j=j+4|0}while((k|0)<(l|0));e=e+1|0}}while(0);c[b+712>>2]=m;e=c[e>>2]|0;f=0;while(1){if((f|0)>=(m|0))break;k=e+(f*104|0)|0;j=(c[d+12>>2]|0)+(f*104|0)|0;l=k+104|0;do{c[k>>2]=c[j>>2];k=k+4|0;j=j+4|0}while((k|0)<(l|0));f=f+1|0}i=n;return}function th(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=c[b+4>>2]|0;if((e|0)==(c[b+8>>2]|0)){If(b,e|0?e<<1:1);e=c[b+4>>2]|0}j=(c[b+12>>2]|0)+(e*36|0)|0;a[j+16>>0]=1;c[j+12>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;k=c[d+4>>2]|0;if((k|0)<=0){c[j+4>>2]=k;k=j+20|0;d=d+20|0;c[k>>2]=c[d>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];d=c[b+4>>2]|0;d=d+1|0;c[b+4>>2]=d;return}c[6435]=(c[6435]|0)+1;e=yc((k<<2|3)+16|0)|0;if(!e)h=0;else{c[(e+4+15&-16)+-4>>2]=e;h=e+4+15&-16}g=c[j+4>>2]|0;f=c[j+12>>2]|0;if((g|0)<=0)if(!f){a[j+16>>0]=1;c[j+12>>2]=h;c[j+8>>2]=k;Qn(h|0,0,k<<2|0)|0}else i=11;else{e=0;do{c[h+(e<<2)>>2]=c[f+(e<<2)>>2];e=e+1|0}while((e|0)!=(g|0));i=11}if((i|0)==11){if(a[j+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}a[j+16>>0]=1;c[j+12>>2]=h;c[j+8>>2]=k;Qn(h|0,0,k<<2|0)|0}e=c[j+12>>2]|0;c[j+4>>2]=k;f=c[d+12>>2]|0;g=0;do{c[e+(g<<2)>>2]=c[f+(g<<2)>>2];g=g+1|0}while((g|0)!=(k|0));k=j+20|0;d=d+20|0;c[k>>2]=c[d>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];d=c[b+4>>2]|0;d=d+1|0;c[b+4>>2]=d;return}function uh(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;i=c[a+68+(d<<2)>>2]|0;h=b[i+((f&65535)<<2)+-4>>1]|0;if((e[i+((f&65535)<<2)>>1]|0)>=(h&65535))return;k=c[a+60>>2]|0;l=k+((e[i+((f&65535)<<2)+2>>1]|0)<<6)+54+(d<<1)|0;j=i+((f&65535)<<2)|0;f=i+((f&65535)<<2)+-4|0;while(1){i=e[j+-2>>1]|0;if(!(h&1)){h=e[j+2>>1]|0;if(((((e[k+(h<<6)+54+((1<<d&3)<<1)>>1]|0)>=(e[k+(i<<6)+48+((1<<d&3)<<1)>>1]|0)?(e[k+(i<<6)+54+((1<<d&3)<<1)>>1]|0)>=(e[k+(h<<6)+48+((1<<d&3)<<1)>>1]|0):0)?(e[k+(h<<6)+54+((1<<(1<<d&3)&3)<<1)>>1]|0)>=(e[k+(i<<6)+48+((1<<(1<<d&3)&3)<<1)>>1]|0):0)?(e[k+(i<<6)+54+((1<<(1<<d&3)&3)<<1)>>1]|0)>=(e[k+(h<<6)+48+((1<<(1<<d&3)&3)<<1)>>1]|0):0)?(o=c[a+92>>2]|0,m=k+(h<<6)|0,n=k+(i<<6)|0,Ib[c[(c[o>>2]|0)+12>>2]&31](o,m,n,g)|0,o=c[a+96>>2]|0,o|0):0)Ib[c[(c[o>>2]|0)+12>>2]&31](o,m,n,g)|0;k=k+(i<<6)+48+(d<<1)|0;b[k>>1]=(b[k>>1]|0)+1<<16>>16}else{k=k+(i<<6)+54+(d<<1)|0;b[k>>1]=(b[k>>1]|0)+1<<16>>16}b[l>>1]=(b[l>>1]|0)+-1<<16>>16;i=e[j>>1]|e[j+2>>1]<<16;h=e[f>>1]|e[f+2>>1]<<16;b[j>>1]=h;b[j+2>>1]=h>>>16;b[f>>1]=i;b[f+2>>1]=i>>>16;i=j+-4|0;f=f+-4|0;h=b[f>>1]|0;if((e[i>>1]|0)>=(h&65535))break;k=c[a+60>>2]|0;j=i}return}function vh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;k=i;i=i+48|0;g=c[a+28>>2]|0;c[k+32>>2]=g;g=(c[a+20>>2]|0)-g|0;c[k+32+4>>2]=g;c[k+32+8>>2]=b;c[k+32+12>>2]=d;j=k+32|0;f=2;g=g+d|0;while(1){if(!0){c[k+16>>2]=c[a+60>>2];c[k+16+4>>2]=j;c[k+16+8>>2]=f;b=wb(146,k+16|0)|0;if(b>>>0>4294963200){if(!0)e=25748;else e=c[(ib()|0)+64>>2]|0;c[e>>2]=0-b;b=-1}}else{rb(254,a|0);c[k>>2]=c[a+60>>2];c[k+4>>2]=j;c[k+8>>2]=f;b=wb(146,k|0)|0;if(b>>>0>4294963200){if(!0)e=25748;else e=c[(ib()|0)+64>>2]|0;c[e>>2]=0-b;b=-1}Ua(0)}if((g|0)==(b|0)){b=13;break}if((b|0)<0){b=15;break}g=g-b|0;e=c[j+4>>2]|0;if(b>>>0<=e>>>0)if((f|0)==2){c[a+28>>2]=(c[a+28>>2]|0)+b;h=e;e=j;f=2}else{h=e;e=j}else{h=c[a+44>>2]|0;c[a+28>>2]=h;c[a+20>>2]=h;h=c[j+12>>2]|0;b=b-e|0;e=j+8|0;f=f+-1|0}c[e>>2]=(c[e>>2]|0)+b;c[e+4>>2]=h-b;j=e}if((b|0)==13){j=c[a+44>>2]|0;c[a+16>>2]=j+(c[a+48>>2]|0);c[a+28>>2]=j;c[a+20>>2]=j}else if((b|0)==15){c[a+16>>2]=0;c[a+28>>2]=0;c[a+20>>2]=0;c[a>>2]=c[a>>2]|32;if((f|0)==2)d=0;else d=d-(c[j+4>>2]|0)|0}i=k;return d|0}function wh(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=c[a+68+(d<<2)>>2]|0;m=c[a+60>>2]|0;n=e[h+((f&65535)<<2)+2>>1]|0;g=b[h+((f&65535)<<2)+-4>>1]|0;if((e[h+((f&65535)<<2)>>1]|0)>=(g&65535))return;j=m;i=h+((f&65535)<<2)|0;f=h+((f&65535)<<2)+-4|0;while(1){h=e[i+-2>>1]|0;if(!(g&1)){j=j+(h<<6)+48+(d<<1)|0;b[j>>1]=(b[j>>1]|0)+1<<16>>16}else{if(((((e[m+(n<<6)+54+((1<<d&3)<<1)>>1]|0)>=(e[j+(h<<6)+48+((1<<d&3)<<1)>>1]|0)?(e[j+(h<<6)+54+((1<<d&3)<<1)>>1]|0)>=(e[m+(n<<6)+48+((1<<d&3)<<1)>>1]|0):0)?(e[m+(n<<6)+54+((1<<(1<<d&3)&3)<<1)>>1]|0)>=(e[j+(h<<6)+48+((1<<(1<<d&3)&3)<<1)>>1]|0):0)?(e[j+(h<<6)+54+((1<<(1<<d&3)&3)<<1)>>1]|0)>=(e[m+(n<<6)+48+((1<<(1<<d&3)&3)<<1)>>1]|0):0)?(l=c[a+92>>2]|0,k=j+(h<<6)|0,Ob[c[(c[l>>2]|0)+8>>2]&63](l,m+(n<<6)|0,k)|0,l=c[a+96>>2]|0,l|0):0)Ob[c[(c[l>>2]|0)+8>>2]&63](l,m+(n<<6)|0,k)|0;j=j+(h<<6)+54+(d<<1)|0;b[j>>1]=(b[j>>1]|0)+1<<16>>16}b[m+(n<<6)+48+(d<<1)>>1]=(b[m+(n<<6)+48+(d<<1)>>1]|0)+-1<<16>>16;h=e[i>>1]|e[i+2>>1]<<16;g=e[f>>1]|e[f+2>>1]<<16;b[i>>1]=g;b[i+2>>1]=g>>>16;b[f>>1]=h;b[f+2>>1]=h>>>16;h=i+-4|0;f=f+-4|0;g=b[f>>1]|0;if((e[h>>1]|0)>=(g&65535))break;j=c[a+60>>2]|0;i=h}return}function xh(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0.0,o=0.0;m=i;i=i+80|0;o=+g[h+52>>2]-+g[f+52>>2];n=+g[h+56>>2]-+g[f+56>>2];g[m+56>>2]=+g[h+48>>2]-+g[f+48>>2];g[m+56+4>>2]=o;g[m+56+8>>2]=n;g[m+56+12>>2]=0.0;if(Pc(d,f,e,h,m+56|0,m,1)|0){c[k>>2]=c[m+4>>2];c[k+4>>2]=c[m+4+4>>2];c[k+8>>2]=c[m+4+8>>2];c[k+12>>2]=c[m+4+12>>2];c[l>>2]=c[m+20>>2];c[l+4>>2]=c[m+20+4>>2];c[l+8>>2]=c[m+20+8>>2];c[l+12>>2]=c[m+20+12>>2];c[j>>2]=c[m+36>>2];c[j+4>>2]=c[m+36+4>>2];c[j+8>>2]=c[m+36+8>>2];c[j+12>>2]=c[m+36+12>>2];l=1;i=m;return l|0}if(!(Jd(d,f,e,h,m+56|0,m)|0)){l=0;i=m;return l|0}c[k>>2]=c[m+4>>2];c[k+4>>2]=c[m+4+4>>2];c[k+8>>2]=c[m+4+8>>2];c[k+12>>2]=c[m+4+12>>2];c[l>>2]=c[m+20>>2];c[l+4>>2]=c[m+20+4>>2];c[l+8>>2]=c[m+20+8>>2];c[l+12>>2]=c[m+20+12>>2];c[j>>2]=c[m+36>>2];c[j+4>>2]=c[m+36+4>>2];c[j+8>>2]=c[m+36+8>>2];c[j+12>>2]=c[m+36+12>>2];l=0;i=m;return l|0}function yh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0,l=0,m=0.0,n=0.0,o=0,p=0,q=0.0,r=0;p=i;i=i+2048|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];h=+g[d+4>>2];f=+g[d+8>>2];if(e*e+h*h+f*f<9.999999747378752e-05){n=1.0;m=0.0;h=0.0}else{q=1.0/+O(+(e*e+h*h+f*f));n=e*q;m=f*q;h=h*q}if((Eb[c[(c[b>>2]|0)+96>>2]&127](b)|0)<=0){i=p;return}l=0;f=-999999984306749440.0;while(1){if(((Eb[c[(c[b>>2]|0)+96>>2]&127](b)|0)-l|0)<128){d=(Eb[c[(c[b>>2]|0)+96>>2]&127](b)|0)-l|0;if((d|0)>0)o=8;else{e=-3402823466385288598117041.0e14;d=-1}}else{d=128;o=8}if((o|0)==8){o=0;j=0;do{ic[c[(c[b>>2]|0)+108>>2]&127](b,j,p+(j<<4)|0);j=j+1|0}while((j|0)!=(d|0));k=0;e=-3402823466385288598117041.0e14;j=-1;do{q=n*+g[p+(k<<4)>>2]+h*+g[p+(k<<4)+4>>2]+m*+g[p+(k<<4)+8>>2];r=q>e;j=r?k:j;e=r?q:e;k=k+1|0}while((k|0)!=(d|0));d=j}if(e>f){r=p+(d<<4)|0;c[a>>2]=c[r>>2];c[a+4>>2]=c[r+4>>2];c[a+8>>2]=c[r+8>>2];c[a+12>>2]=c[r+12>>2]}else e=f;l=l+128|0;if((l|0)>=(Eb[c[(c[b>>2]|0)+96>>2]&127](b)|0))break;else f=e}i=p;return}function zh(b,e,f,h,i,j){b=b|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;var k=0;if((d[h+55>>0]|0|0)==(e|0)){h=0;return h|0}k=c[4976+(i<<2)>>2]|0;if(+g[h>>2]*+g[f+16>>2]+ +g[h+4>>2]*+g[f+20>>2]+ +g[h+8>>2]*+g[f+24>>2]-+g[h+16>>2]<-9.999999747378752e-06){k=nf(b,c[h+20+(k<<2)>>2]|0,c[h+20+(i<<2)>>2]|0,f,0)|0;if(!k){h=0;return h|0}a[k+52>>0]=i;c[k+32>>2]=h;a[h+52+i>>0]=0;c[h+32+(i<<2)>>2]=k;i=c[j>>2]|0;if(!i)c[j+4>>2]=k;else{a[i+53>>0]=2;c[i+36>>2]=k;a[k+54>>0]=1;c[k+40>>2]=i}c[j>>2]=k;c[j+8>>2]=(c[j+8>>2]|0)+1;h=1;return h|0}i=c[4988+(i<<2)>>2]|0;a[h+55>>0]=e;if(!(zh(b,e,f,c[h+32+(k<<2)>>2]|0,d[h+52+k>>0]|0,j)|0)){h=0;return h|0}if(!(zh(b,e,f,c[h+32+(i<<2)>>2]|0,d[h+52+i>>0]|0,j)|0)){h=0;return h|0}i=c[h+48>>2]|0;if(i|0)c[i+44>>2]=c[h+44>>2];i=c[h+44>>2]|0;if(i|0)c[i+48>>2]=c[h+48>>2];if((c[b+9280>>2]|0)==(h|0))c[b+9280>>2]=c[h+48>>2];c[b+9284>>2]=(c[b+9284>>2]|0)+-1;c[h+44>>2]=0;c[h+48>>2]=c[b+9288>>2];i=c[b+9288>>2]|0;if(i|0)c[i+44>>2]=h;c[b+9288>>2]=h;c[b+9292>>2]=(c[b+9292>>2]|0)+1;h=1;return h|0}function Ah(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0,j=0,k=0.0,l=0.0;e=c[d+204>>2]|0;if((e&3|0)==0?(c[d+504>>2]&1|0)==0:0){h=+g[d+344>>2];if(h!=0.0){l=1.0/h*+g[b+252>>2];k=1.0/h*+g[b+256>>2];g[d+364>>2]=1.0/h*+g[b+248>>2];g[d+368>>2]=l;g[d+372>>2]=k;g[d+376>>2]=0.0}c[d+380>>2]=c[b+248>>2];c[d+380+4>>2]=c[b+248+4>>2];c[d+380+8>>2]=c[b+248+8>>2];c[d+380+12>>2]=c[b+248+12>>2]}if(!(c[d+192>>2]|0))return;if(e&1){if((c[d+216>>2]&-2|0)!=4)c[d+216>>2]=2}else{f=c[b+232>>2]|0;if((f|0)==(c[b+236>>2]|0)?(j=f|0?f<<1:1,(f|0)<(j|0)):0){if(!j)e=0;else{c[6435]=(c[6435]|0)+1;e=yc((j<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[b+232>>2]|0}if((f|0)>0){i=0;do{c[e+(i<<2)>>2]=c[(c[b+240>>2]|0)+(i<<2)>>2];i=i+1|0}while((i|0)!=(f|0))}i=c[b+240>>2]|0;if(i){if(a[b+244>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[i+-4>>2]|0);f=c[b+232>>2]|0}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=e;c[b+236>>2]=j;e=c[d+204>>2]|0}c[(c[b+240>>2]|0)+(f<<2)>>2]=d;c[b+232>>2]=f+1}j=(e&3|0)==0;mc[c[(c[b>>2]|0)+36>>2]&127](b,d,j?1:2,j?-1:-3);return}function Bh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0,k=0,l=0,m=0.0,n=0.0;h=c[d+204>>2]|0;if((h&3|0)==0?(c[d+504>>2]&1|0)==0:0){i=+g[d+344>>2];if(i!=0.0){n=1.0/i*+g[b+252>>2];m=1.0/i*+g[b+256>>2];g[d+364>>2]=1.0/i*+g[b+248>>2];g[d+368>>2]=n;g[d+372>>2]=m;g[d+376>>2]=0.0}c[d+380>>2]=c[b+248>>2];c[d+380+4>>2]=c[b+248+4>>2];c[d+380+8>>2]=c[b+248+8>>2];c[d+380+12>>2]=c[b+248+12>>2]}if(!(c[d+192>>2]|0))return;if(h&1){if((c[d+216>>2]&-2|0)!=4)c[d+216>>2]=2}else{h=c[b+232>>2]|0;if((h|0)==(c[b+236>>2]|0)?(l=h|0?h<<1:1,(h|0)<(l|0)):0){if(!l)k=0;else{c[6435]=(c[6435]|0)+1;h=yc((l<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}k=h;h=c[b+232>>2]|0}if((h|0)>0){j=0;do{c[k+(j<<2)>>2]=c[(c[b+240>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[b+240>>2]|0;if(j){if(a[b+244>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0);h=c[b+232>>2]|0}c[b+240>>2]=0}a[b+244>>0]=1;c[b+240>>2]=k;c[b+236>>2]=l}c[(c[b+240>>2]|0)+(h<<2)>>2]=d;c[b+232>>2]=h+1}mc[c[(c[b>>2]|0)+36>>2]&127](b,d,e,f);return}function Ch(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;o=(+g[a+32>>2]-+g[a+16>>2])*.5;l=(+g[a+36>>2]-+g[a+20>>2])*.5;i=(+g[a+40>>2]-+g[a+24>>2])*.5;n=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);k=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);i=i+ +Sb[c[(c[a>>2]|0)+48>>2]&15](a);B=(+g[a+32>>2]+ +g[a+16>>2])*.5;z=(+g[a+36>>2]+ +g[a+20>>2])*.5;x=(+g[a+40>>2]+ +g[a+24>>2])*.5;F=+g[b>>2];w=+N(+F);E=+g[b+4>>2];v=+N(+E);t=+g[b+8>>2];u=+N(+t);D=+g[b+16>>2];s=+N(+D);C=+g[b+20>>2];r=+N(+C);p=+g[b+24>>2];q=+N(+p);A=+g[b+32>>2];m=+N(+A);y=+g[b+36>>2];j=+N(+y);f=+g[b+40>>2];h=+N(+f);t=B*F+z*E+x*t+ +g[b+48>>2];p=B*D+z*C+x*p+ +g[b+52>>2];f=B*A+z*y+x*f+ +g[b+56>>2];g[d>>2]=t-((o+n)*w+(l+k)*v+i*u);g[d+4>>2]=p-((o+n)*s+(l+k)*r+i*q);g[d+8>>2]=f-((o+n)*m+(l+k)*j+i*h);g[d+12>>2]=0.0;g[e>>2]=(o+n)*w+(l+k)*v+i*u+t;g[e+4>>2]=(o+n)*s+(l+k)*r+i*q+p;g[e+8>>2]=(o+n)*m+(l+k)*j+i*h+f;g[e+12>>2]=0.0;return}function Dh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0;H=+g[a+48>>2];z=+g[a+32>>2];G=+g[a+52>>2];x=+g[a+36>>2];E=+g[a+56>>2];v=+g[a+40>>2];F=(c[a+16>>2]|0)==0;m=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);k=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);i=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);m=(F?0.0:(H-z)*.5)+m;k=(F?0.0:(G-x)*.5)+k;i=(F?0.0:(E-v)*.5)+i;D=+g[b>>2];u=+N(+D);C=+g[b+4>>2];t=+N(+C);r=+g[b+8>>2];s=+N(+r);B=+g[b+16>>2];q=+N(+B);A=+g[b+20>>2];p=+N(+A);n=+g[b+24>>2];o=+N(+n);y=+g[b+32>>2];l=+N(+y);w=+g[b+36>>2];j=+N(+w);f=+g[b+40>>2];h=+N(+f);z=F?0.0:(H+z)*.5;x=F?0.0:(G+x)*.5;v=F?0.0:(E+v)*.5;r=z*D+x*C+v*r+ +g[b+48>>2];n=z*B+x*A+v*n+ +g[b+52>>2];f=z*y+x*w+v*f+ +g[b+56>>2];g[d>>2]=r-(m*u+k*t+i*s);g[d+4>>2]=n-(m*q+k*p+i*o);g[d+8>>2]=f-(m*l+k*j+i*h);g[d+12>>2]=0.0;g[e>>2]=m*u+k*t+i*s+r;g[e+4>>2]=m*q+k*p+i*o+n;g[e+8>>2]=m*l+k*j+i*h+f;g[e+12>>2]=0.0;return}function Eh(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0,l=0.0,m=0.0;if(a[b+48>>0]|0){c[d>>2]=0;c[d+4>>2]=0;return}c[d>>2]=4;c[d+4>>2]=2;kd(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);g[b+1088>>2]=0.0;a[b+297>>0]=0;f=+g[b+192>>2];h=+g[b+196>>2];do if(f<=h){m=+g[b+892>>2];l=+g[b+908>>2];i=+g[b+924>>2];i=+ik(+W(+(+g[b+832>>2]*m+ +g[b+848>>2]*l+ +g[b+864>>2]*i),+(+g[b+828>>2]*m+ +g[b+844>>2]*l+ +g[b+860>>2]*i)),f,h);g[b+1084>>2]=i;if(i<f){g[b+1088>>2]=i-f;a[b+297>>0]=1;j=1;break}if(i>h){g[b+1088>>2]=i-h;a[b+297>>0]=1;j=1}else j=0}else j=0;while(0);a[b+296>>0]=0;e=c[b+1032>>2]|0;c[b+1080>>2]=e;f=+g[b+184>>2];h=+g[b+188>>2];i=(c[k>>2]=e,+g[k>>2]);do if(f<=h){if(i>h){g[b+1032>>2]=i-h;a[b+296>>0]=1;e=14;break}if(i<f){g[b+1032>>2]=i-f;a[b+296>>0]=1;e=14}else e=13}else e=13;while(0);if((e|0)==13?(g[b+1032>>2]=0.0,a[b+1096>>0]|0):0)e=14;if((e|0)==14){c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+-1}if(j<<24>>24==0?(a[b+1112>>0]|0)==0:0)return;c[d>>2]=(c[d>>2]|0)+1;c[d+4>>2]=(c[d+4>>2]|0)+-1;return}function Fh(a){a=a|0;var b=0,d=0.0,e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0,p=0.0;c[6435]=(c[6435]|0)+1;b=yc(75)|0;if(!b)i=0;else{c[(b+4+15&-16)+-4>>2]=b;i=b+4+15&-16}c[i+8>>2]=0;e=i+12|0;c[e>>2]=1065353216;f=i+16|0;c[f>>2]=1065353216;h=i+20|0;c[h>>2]=1065353216;g[i+24>>2]=0.0;b=i+44|0;g[b>>2]=.03999999910593033;c[i+52>>2]=0;c[i>>2]=7844;c[i+4>>2]=0;k=+g[a>>2];j=+g[a+4>>2];d=+g[a+8>>2];d=+g[a+((k<j?(k<d?0:2):j<d?1:2)<<2)>>2]*.10000000149011612;if(d<.03999999910593033){p=+xz(i);n=+Sb[c[(c[i>>2]|0)+48>>2]&15](i);k=+Sb[c[(c[i>>2]|0)+48>>2]&15](i);o=i+28|0;p=p+ +g[o>>2];m=i+32|0;n=n+ +g[m>>2];l=i+36|0;k=k+ +g[l>>2];g[b>>2]=d;d=+Sb[c[(c[i>>2]|0)+48>>2]&15](i);j=+Sb[c[(c[i>>2]|0)+48>>2]&15](i);k=k-+Sb[c[(c[i>>2]|0)+48>>2]&15](i);g[o>>2]=p-d;g[m>>2]=n-j;g[l>>2]=k;g[i+40>>2]=0.0;b=c[i>>2]|0}else b=7844;k=+Sb[c[b+48>>2]&15](i);n=+Sb[c[(c[i>>2]|0)+48>>2]&15](i);p=+Sb[c[(c[i>>2]|0)+48>>2]&15](i);n=+g[a+4>>2]*+g[f>>2]-n;p=+g[a+8>>2]*+g[h>>2]-p;g[i+28>>2]=+g[a>>2]*+g[e>>2]-k;g[i+32>>2]=n;g[i+36>>2]=p;g[i+40>>2]=0.0;return i|0}function Gh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;f=c[a+212>>2]|0;a:do if((f|0)>0){g=c[a+220>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0))break a}if((d|0)<(f|0)){c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+220>>2]|0)+(f+-1<<2)>>2]=b;c[a+212>>2]=f+-1}}while(0);a=c[b+28>>2]|0;d=c[a+488>>2]|0;b:do if((d|0)>0){g=c[a+496>>2]|0;e=0;while(1){f=g+(e<<2)|0;if((c[f>>2]|0)==(b|0))break;e=e+1|0;if((e|0)>=(d|0))break b}if((e|0)<(d|0)){c[f>>2]=c[g+(d+-1<<2)>>2];c[(c[a+496>>2]|0)+(d+-1<<2)>>2]=b;c[a+488>>2]=d+-1;d=d+-1|0}}while(0);c[a+256>>2]=(d|0)>0&1;a=c[b+32>>2]|0;d=c[a+488>>2]|0;if((d|0)<=0){b=d;b=(b|0)>0;b=b&1;h=a+256|0;c[h>>2]=b;return}g=c[a+496>>2]|0;e=0;while(1){f=g+(e<<2)|0;if((c[f>>2]|0)==(b|0))break;e=e+1|0;if((e|0)>=(d|0)){h=19;break}}if((h|0)==19){b=(d|0)>0;b=b&1;h=a+256|0;c[h>>2]=b;return}if((e|0)>=(d|0)){b=d;b=(b|0)>0;b=b&1;h=a+256|0;c[h>>2]=b;return}c[f>>2]=c[g+(d+-1<<2)>>2];c[(c[a+496>>2]|0)+(d+-1<<2)>>2]=b;c[a+488>>2]=d+-1;b=d+-1|0;b=(b|0)>0;b=b&1;h=a+256|0;c[h>>2]=b;return}function Hh(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0;j=Eb[c[(c[b>>2]|0)+28>>2]&127](b)|0;i=+g[j>>2]-+g[d>>2];h=+g[j+4>>2]-+g[d+4>>2];f=+g[j+8>>2]-+g[d+8>>2];if(!(i*i+h*h+f*f>1.1920928955078125e-07))return;Xg(b,d);if((a[b+61>>0]|0)!=0?(e=c[b+52>>2]|0,Ab[c[c[e>>2]>>2]&255](e),e=c[b+52>>2]|0,(e|0)!=0):0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);d=b+52|0}else d=b+52|0;c[6435]=(c[6435]|0)+1;e=yc(191)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e+52>>2]=282;a[e+60>>0]=0;a[e+80>>0]=1;c[e+76>>2]=0;c[e+68>>2]=0;c[e+72>>2]=0;a[e+100>>0]=1;c[e+96>>2]=0;c[e+88>>2]=0;c[e+92>>2]=0;a[e+120>>0]=1;c[e+116>>2]=0;c[e+108>>2]=0;c[e+112>>2]=0;a[e+140>>0]=1;c[e+136>>2]=0;c[e+128>>2]=0;c[e+132>>2]=0;c[e+144>>2]=0;a[e+164>>0]=1;c[e+160>>2]=0;c[e+152>>2]=0;c[e+156>>2]=0;c[e+168>>2]=0;c[e+4>>2]=-8388609;c[e+8>>2]=-8388609;c[e+12>>2]=-8388609;g[e+16>>2]=0.0;c[e+20>>2]=2139095039;c[e+24>>2]=2139095039;c[e+28>>2]=2139095039;g[e+32>>2]=0.0;c[e>>2]=7980;c[d>>2]=e;pd(e,c[b+48>>2]|0,(a[b+60>>0]|0)!=0,b+16|0,b+32|0);a[b+61>>0]=1;return}function Ih(b,d){b=b|0;d=d|0;var e=0.0,f=0.0;if(a[b+1309>>0]|0){e=(+g[b+1256>>2]-+g[b+1316>>2])*+g[b+1340>>2];g[b+792>>2]=e*(+g[d>>2]*+g[b+1364>>2]/+(c[d+48>>2]|0));e=+N(+e);g[b+808>>2]=e/+g[d>>2]}if(a[b+1310>>0]|0){e=(+g[b+1260>>2]-+g[b+1320>>2])*+g[b+1344>>2];g[b+796>>2]=e*(+g[d>>2]*+g[b+1368>>2]/+(c[d+48>>2]|0));e=+N(+e);g[b+812>>2]=e/+g[d>>2]}if(a[b+1311>>0]|0){e=(+g[b+1264>>2]-+g[b+1324>>2])*+g[b+1348>>2];g[b+800>>2]=e*(+g[d>>2]*+g[b+1372>>2]/+(c[d+48>>2]|0));e=+N(+e);g[b+816>>2]=e/+g[d>>2]}if(a[b+1312>>0]|0){f=-((+g[b+1192>>2]-+g[b+1328>>2])*+g[b+1352>>2]);e=+g[d>>2];g[b+876>>2]=e*+g[b+1376>>2]/+(c[d+48>>2]|0)*f;g[b+880>>2]=+N(+f)/e}if(a[b+1313>>0]|0){e=-((+g[b+1196>>2]-+g[b+1332>>2])*+g[b+1356>>2]);f=+g[d>>2];g[b+940>>2]=f*+g[b+1380>>2]/+(c[d+48>>2]|0)*e;g[b+944>>2]=+N(+e)/f}if(!(a[b+1314>>0]|0)){fg(b,d);return}e=-((+g[b+1200>>2]-+g[b+1336>>2])*+g[b+1360>>2]);f=+g[d>>2];g[b+1004>>2]=f*+g[b+1384>>2]/+(c[d+48>>2]|0)*e;g[b+1008>>2]=+N(+e)/f;fg(b,d);return}function Jh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0;e=i;i=i+160|0;c[e+136>>2]=0;c[e+136+4>>2]=0;c[e+136+8>>2]=0;c[e+136+12>>2]=0;c[e+136+16>>2]=0;c[e+32>>2]=7028;f=e+32+4|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[e+32+20>>2]=1065353216;c[e+32+24>>2]=0;c[e+32+24+4>>2]=0;c[e+32+24+8>>2]=0;c[e+32+24+12>>2]=0;c[e+32+40>>2]=1065353216;c[e+32+44>>2]=0;c[e+32+44+4>>2]=0;c[e+32+44+8>>2]=0;c[e+32+44+12>>2]=0;c[e+32+60>>2]=1065353216;c[e+32+64>>2]=0;c[e+32+68>>2]=c[e+136+4>>2];c[e+32+68+4>>2]=c[e+136+4+4>>2];c[e+32+68+8>>2]=c[e+136+4+8>>2];c[e+32+68+12>>2]=c[e+136+4+12>>2];g[e+32+84>>2]=-999999984306749440.0;k=+g[d>>2];j=+g[d+4>>2];h=+g[d+8>>2];g[e+32+88>>2]=k+j*0.0+h*0.0;g[e+32+92>>2]=k*0.0+j+h*0.0;g[e+32+96>>2]=k*0.0+j*0.0+h;g[e+32+100>>2]=0.0;c[e+16>>2]=1566444395;c[e+16+4>>2]=1566444395;c[e+16+8>>2]=1566444395;g[e+16+12>>2]=0.0;d=c[(c[b>>2]|0)+64>>2]|0;g[e>>2]=-999999984306749440.0;g[e+4>>2]=-999999984306749440.0;g[e+8>>2]=-999999984306749440.0;g[e+12>>2]=0.0;mc[d&127](b,e+32|0,e,e+16|0);c[a>>2]=c[f>>2];c[a+4>>2]=c[f+4>>2];c[a+8>>2]=c[f+8>>2];c[a+12>>2]=c[f+12>>2];i=e;return}function Kh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;q=i;i=i+16|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];f=+g[d+4>>2];h=+g[d+8>>2];if(e*e+f*f+h*h<9.999999747378752e-05){p=1.0;o=0.0;n=0.0}else{n=1.0/+O(+(e*e+f*f+h*h));p=e*n;o=f*n;n=h*n}d=c[b+52>>2]|0;m=+g[b+28+(((d+2|0)%3|0)<<2)>>2];c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;c[q+(d<<2)>>2]=c[b+28+(d<<2)>>2];k=p*m;l=o*m;m=n*m;e=k+ +g[q>>2];f=l+ +g[q+4>>2];j=m+ +g[q+8>>2];h=+Sb[c[(c[b>>2]|0)+48>>2]&15](b);e=e-p*h;f=f-o*h;h=j-n*h;j=n*h+(p*e+o*f);if(j>-999999984306749440.0){g[a>>2]=e;g[a+4>>2]=f;g[a+8>>2]=h;g[a+12>>2]=0.0}else j=-999999984306749440.0;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0;d=c[b+52>>2]|0;g[q+(d<<2)>>2]=-+g[b+28+(d<<2)>>2];e=k+ +g[q>>2];f=l+ +g[q+4>>2];m=m+ +g[q+8>>2];h=+Sb[c[(c[b>>2]|0)+48>>2]&15](b);e=e-p*h;f=f-o*h;h=m-n*h;if(!(n*h+(p*e+o*f)>j)){i=q;return}g[a>>2]=e;g[a+4>>2]=f;g[a+8>>2]=h;g[a+12>>2]=0.0;i=q;return}function Lh(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;h=+h;j=+j;k=+k;l=+l;m=+m;var n=0;n=i;i=i+128|0;c[n+80>>2]=c[a+4>>2];c[n+80+4>>2]=c[a+20>>2];c[n+80+8>>2]=c[a+36>>2];g[n+80+12>>2]=0.0;c[n+80+16>>2]=c[a+8>>2];c[n+80+20>>2]=c[a+24>>2];c[n+80+24>>2]=c[a+40>>2];g[n+80+28>>2]=0.0;c[n+80+32>>2]=c[a+12>>2];c[n+80+36>>2]=c[a+28>>2];c[n+80+40>>2]=c[a+44>>2];g[n+80+44>>2]=0.0;c[n+32>>2]=c[b+4>>2];c[n+32+4>>2]=c[b+20>>2];c[n+32+8>>2]=c[b+36>>2];g[n+32+12>>2]=0.0;c[n+32+16>>2]=c[b+8>>2];c[n+32+20>>2]=c[b+24>>2];c[n+32+24>>2]=c[b+40>>2];g[n+32+28>>2]=0.0;c[n+32+32>>2]=c[b+12>>2];c[n+32+36>>2]=c[b+28>>2];c[n+32+40>>2]=c[b+44>>2];g[n+32+44>>2]=0.0;h=h-+g[a+56>>2];j=j-+g[a+60>>2];g[n+16>>2]=f-+g[a+52>>2];g[n+16+4>>2]=h;g[n+16+8>>2]=j;g[n+16+12>>2]=0.0;l=l-+g[b+56>>2];m=m-+g[b+60>>2];g[n>>2]=k-+g[b+52>>2];g[n+4>>2]=l;g[n+8>>2]=m;g[n+12>>2]=0.0;Rg(d,n+80|0,n+32|0,n+16|0,n,e,a+396|0,+g[a+344>>2],b+396|0,+g[b+344>>2]);i=n;return}function Mh(a,b,c,d,e,f,h,i,j,k,l,m,n,o){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;h=+h;i=+i;j=+j;k=+k;l=+l;m=+m;n=+n;o=+o;var p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0;s=(j-f)*(n-h)-(k-h)*(m-f);q=(k-h)*(l-e)-(i-e)*(n-h);r=(i-e)*(m-f)-(j-f)*(l-e);if(+N(+(r*d+(s*b+q*c)))<1.1920928955078125e-07){d=-1.0;return +d}t=+g[a>>2];v=+g[a+4>>2];u=+g[a+8>>2];p=-(s*t+q*v+r*u-(r*h+(s*e+q*f)))/(r*d+(s*b+q*c));if(((p>1.1920928955078125e-06&p<o?r*((j-(v+p*c))*(e-(t+p*b))-(f-(v+p*c))*(i-(t+p*b)))+(s*((f-(v+p*c))*(k-(u+p*d))-(h-(u+p*d))*(j-(v+p*c)))+q*((h-(u+p*d))*(i-(t+p*b))-(k-(u+p*d))*(e-(t+p*b))))>-1.1920928955078125e-06:0)?r*((m-(v+p*c))*(i-(t+p*b))-(j-(v+p*c))*(l-(t+p*b)))+(s*((j-(v+p*c))*(n-(u+p*d))-(k-(u+p*d))*(m-(v+p*c)))+q*((k-(u+p*d))*(l-(t+p*b))-(n-(u+p*d))*(i-(t+p*b))))>-1.1920928955078125e-06:0)?r*((f-(v+p*c))*(l-(t+p*b))-(m-(v+p*c))*(e-(t+p*b)))+(s*((m-(v+p*c))*(h-(u+p*d))-(n-(u+p*d))*(f-(v+p*c)))+q*((n-(u+p*d))*(e-(t+p*b))-(h-(u+p*d))*(l-(t+p*b))))>-1.1920928955078125e-06:0){v=p;return +v}v=-1.0;return +v}function Nh(a,b,d,e,f){a=a|0;b=+b;d=+d;e=+e;f=f|0;var h=0,j=0,k=0,l=0,m=0.0,n=0.0;k=i;i=i+48|0;m=1.0/+O(+(b*b+d*d+e*e));g[f>>2]=m*b;g[f+4>>2]=m*d;g[f+8>>2]=m*e;g[f+12>>2]=0.0;h=c[a+120>>2]|0;l=c[a+124>>2]|0;j=(c[a>>2]|0)+(l>>1)|0;if(l&1)h=c[(c[j>>2]|0)+h>>2]|0;ic[h&127](k,j,f);b=-+g[f>>2];d=-+g[f+4>>2];e=-+g[f+8>>2];h=c[a+120>>2]|0;l=c[a+124>>2]|0;j=(c[a+4>>2]|0)+(l>>1)|0;if(l&1)h=c[(c[j>>2]|0)+h>>2]|0;m=+g[a+24>>2]*b+ +g[a+28>>2]*d+ +g[a+32>>2]*e;n=+g[a+40>>2]*b+ +g[a+44>>2]*d+ +g[a+48>>2]*e;g[k+16>>2]=+g[a+8>>2]*b+ +g[a+12>>2]*d+ +g[a+16>>2]*e;g[k+16+4>>2]=m;g[k+16+8>>2]=n;g[k+16+12>>2]=0.0;ic[h&127](k+32|0,j,k+16|0);n=+g[k+32>>2];b=+g[k+32+4>>2];d=+g[k+32+8>>2];e=+g[k+4>>2]-(n*+g[a+72>>2]+b*+g[a+76>>2]+d*+g[a+80>>2]+ +g[a+108>>2]);m=+g[k+8>>2]-(n*+g[a+88>>2]+b*+g[a+92>>2]+d*+g[a+96>>2]+ +g[a+112>>2]);g[f+16>>2]=+g[k>>2]-(n*+g[a+56>>2]+b*+g[a+60>>2]+d*+g[a+64>>2]+ +g[a+104>>2]);g[f+20>>2]=e;g[f+24>>2]=m;g[f+28>>2]=0.0;i=k;return}function Oh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if(a[b+165>>0]|0){if((c[b+92>>2]|0)>=(d|0))return;if((d|0)!=0?(c[6435]=(c[6435]|0)+1,e=yc((d<<4|3)+16|0)|0,(e|0)!=0):0){c[(e+4+15&-16)+-4>>2]=e;g=e+4+15&-16}else g=0;e=c[b+88>>2]|0;if((e|0)>0){f=0;do{i=g+(f<<4)|0;h=(c[b+96>>2]|0)+(f<<4)|0;c[i>>2]=c[h>>2];c[i+4>>2]=c[h+4>>2];c[i+8>>2]=c[h+8>>2];c[i+12>>2]=c[h+12>>2];f=f+1|0}while((f|0)!=(e|0))}e=c[b+96>>2]|0;if(e|0){if(a[b+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=g;c[b+92>>2]=d;return}if((c[b+112>>2]|0)>=(d|0))return;if((d|0)!=0?(c[6435]=(c[6435]|0)+1,f=yc((d<<2|3)+16|0)|0,(f|0)!=0):0){c[(f+4+15&-16)+-4>>2]=f;h=f+4+15&-16}else h=0;f=c[b+108>>2]|0;g=c[b+116>>2]|0;if((f|0)<=0)if(!g)e=b+120|0;else i=21;else{e=0;do{c[h+(e<<2)>>2]=c[g+(e<<2)>>2];e=e+1|0}while((e|0)!=(f|0));i=21}if((i|0)==21){if(a[b+120>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0)}c[b+116>>2]=0;e=b+120|0}a[e>>0]=1;c[b+116>>2]=h;c[b+112>>2]=d;return}function Ph(){var b=0,d=0,e=0;c[6435]=(c[6435]|0)+1;b=yc(307)|0;if(!b)d=0;else{c[(b+4+15&-16)+-4>>2]=b;d=b+4+15&-16}c[d+164>>2]=1065353216;c[d+168>>2]=1065353216;c[d+172>>2]=1065353216;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749440.0;b=d+188|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[d+204>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;g[d+232>>2]=0.0;c[d+240>>2]=0;g[d+244>>2]=1.0;b=d+248|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[d+4>>2]=1065353216;b=d+8|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[d+24>>2]=1065353216;b=d+28|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[d+44>>2]=1065353216;b=d+48|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+16>>2]=0;a[d+280>>0]=1;c[d+276>>2]=0;c[d+268>>2]=0;c[d+272>>2]=0;c[d+236>>2]=4;c[d>>2]=5088;c[6435]=(c[6435]|0)+1;b=yc(95)|0;if(!b){e=0;Ri(e);b=d+284|0;c[b>>2]=e;return d|0}c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16;Ri(b);e=d+284|0;c[e>>2]=b;return d|0}function Qh(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;if(!(c[i+44>>2]|0))return;b=c[i+20>>2]|0;if(!(c[i+64>>2]&256)){if((b|0)<=0)return;j=0;do{g=c[a+28>>2]|0;if((g|0)>0){b=0;do{f=c[(c[a+116>>2]|0)+(b<<2)>>2]|0;h=c[a+36>>2]|0;d=c[a+16>>2]|0;Ig(d+((c[h+(f*152|0)+144>>2]|0)*244|0)|0,d+((c[h+(f*152|0)+148>>2]|0)*244|0)|0,h+(f*152|0)|0);b=b+1|0}while((b|0)!=(g|0));b=c[i+20>>2]|0}j=j+1|0}while((j|0)<(b|0));return}else{if((b|0)<=0)return;j=0;do{g=c[a+28>>2]|0;if((g|0)>0){b=0;do{f=c[(c[a+116>>2]|0)+(b<<2)>>2]|0;h=c[a+36>>2]|0;d=c[a+16>>2]|0;Ig(d+((c[h+(f*152|0)+144>>2]|0)*244|0)|0,d+((c[h+(f*152|0)+148>>2]|0)*244|0)|0,h+(f*152|0)|0);b=b+1|0}while((b|0)!=(g|0));b=c[i+20>>2]|0}j=j+1|0}while((j|0)<(b|0));return}}function Rh(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;if(!(a[d+164>>0]|0)){if((c[d+152>>2]|0)>=(e|0))return;if((e|0)!=0?(c[6435]=(c[6435]|0)+1,g=yc((e<<1)+19|0)|0,(g|0)!=0):0){c[(g+4+15&-16)+-4>>2]=g;i=g+4+15&-16}else i=0;g=c[d+148>>2]|0;h=c[d+156>>2]|0;if((g|0)<=0)if(!h)f=d+160|0;else j=22;else{f=0;do{b[i+(f<<1)>>1]=b[h+(f<<1)>>1]|0;f=f+1|0}while((f|0)!=(g|0));j=22}if((j|0)==22){if(a[d+160>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[d+156>>2]=0;f=d+160|0}a[f>>0]=1;c[d+156>>2]=i;c[d+152>>2]=e;return}else{if((c[d+132>>2]|0)>=(e|0))return;if((e|0)!=0?(c[6435]=(c[6435]|0)+1,f=yc((e<<2|3)+16|0)|0,(f|0)!=0):0){c[(f+4+15&-16)+-4>>2]=f;i=f+4+15&-16}else i=0;g=c[d+128>>2]|0;h=c[d+136>>2]|0;if((g|0)<=0)if(!h)f=d+140|0;else j=10;else{f=0;do{c[i+(f<<2)>>2]=c[h+(f<<2)>>2];f=f+1|0}while((f|0)!=(g|0));j=10}if((j|0)==10){if(a[d+140>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[d+136>>2]=0;f=d+140|0}a[f>>0]=1;c[d+136>>2]=i;c[d+132>>2]=e;return}}function Sh(a,b,d){a=a|0;b=b|0;d=d|0;si(a,b,d)|0;c[b+52>>2]=c[a+300>>2];c[b+56>>2]=c[a+304>>2];c[b+60>>2]=c[a+308>>2];c[b+64>>2]=c[a+312>>2];c[b+68>>2]=c[a+316>>2];c[b+72>>2]=c[a+320>>2];c[b+76>>2]=c[a+324>>2];c[b+80>>2]=c[a+328>>2];c[b+84>>2]=c[a+332>>2];c[b+88>>2]=c[a+336>>2];c[b+92>>2]=c[a+340>>2];c[b+96>>2]=c[a+344>>2];c[b+100>>2]=c[a+348>>2];c[b+104>>2]=c[a+352>>2];c[b+108>>2]=c[a+356>>2];c[b+112>>2]=c[a+360>>2];c[b+116>>2]=c[a+364>>2];c[b+120>>2]=c[a+368>>2];c[b+124>>2]=c[a+372>>2];c[b+128>>2]=c[a+376>>2];c[b+132>>2]=c[a+380>>2];c[b+136>>2]=c[a+384>>2];c[b+140>>2]=c[a+388>>2];c[b+144>>2]=c[a+392>>2];c[b+148>>2]=c[a+396>>2];c[b+152>>2]=c[a+400>>2];c[b+156>>2]=c[a+404>>2];c[b+160>>2]=c[a+408>>2];c[b+164>>2]=c[a+412>>2];c[b+168>>2]=c[a+416>>2];c[b+172>>2]=c[a+420>>2];c[b+176>>2]=c[a+424>>2];c[b+180>>2]=c[a+444>>2];c[b+184>>2]=c[a+448>>2];c[b+188>>2]=c[a+452>>2];c[b+192>>2]=c[a+428>>2];c[b+196>>2]=c[a+432>>2];c[b+200>>2]=c[a+436>>2];c[b+204>>2]=c[a+440>>2];return 12727}function Th(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0.0,h=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;k=i;i=i+32|0;n=+g[a+56>>2];r=+g[a+72>>2]-n;m=+g[a+60>>2];p=+g[a+76>>2]-m;l=+g[a+64>>2];s=+g[a+80>>2]-l;o=+g[a+88>>2]-n;q=+g[a+92>>2]-m;h=+g[a+96>>2]-l;j=1.0/+O(+((r*q-p*o)*(r*q-p*o)+((p*h-s*q)*(p*h-s*q)+(s*o-r*h)*(s*o-r*h))));f=j*(p*h-s*q);h=j*(s*o-r*h);j=(r*q-p*o)*j;l=j*+g[b+8>>2]+(+g[b>>2]*f+ +g[b+4>>2]*h)-(f*n+h*m+j*l);if(!(l>=-d)|!(l<=d)){a=0;i=k;return a|0}e=0;while(1){mc[c[(c[a>>2]|0)+104>>2]&127](a,e,k+16|0,k);n=+g[k+16>>2];s=+g[k>>2]-n;p=+g[k+16+4>>2];o=+g[k+4>>2]-p;m=+g[k+16+8>>2];r=+g[k+8>>2]-m;q=1.0/+O(+((h*s-f*o)*(h*s-f*o)+((j*o-h*r)*(j*o-h*r)+(f*r-j*s)*(f*r-j*s))));e=e+1|0;if((h*s-f*o)*q*+g[b+8>>2]+(+g[b>>2]*q*(j*o-h*r)+ +g[b+4>>2]*q*(f*r-j*s))-(m*(h*s-f*o)*q+(n*q*(j*o-h*r)+p*q*(f*r-j*s)))<-d){e=0;b=5;break}if((e|0)>=3){e=1;b=5;break}}if((b|0)==5){i=k;return e|0}return 0}function Uh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0;c[6435]=(c[6435]|0)+1;h=yc(55)|0;if(!h)j=0;else{c[(h+4+15&-16)+-4>>2]=h;j=h+4+15&-16}c[j>>2]=d;c[j+4>>2]=e;c[j+8>>2]=f;c[j+12>>2]=-1;c[j+16>>2]=-1;c[j+20>>2]=-1;c[j+28>>2]=-1;g[j+32>>2]=0.0;f=j;d=c[b+4>>2]|0;c[j+24>>2]=d;if((d|0)!=(c[b+8>>2]|0)){i=d;e=b+12|0;e=c[e>>2]|0;e=e+(i<<2)|0;c[e>>2]=f;i=i+1|0;c[b+4>>2]=i;return j|0}i=d|0?d<<1:1;if((d|0)>=(i|0)){i=d;e=b+12|0;e=c[e>>2]|0;e=e+(i<<2)|0;c[e>>2]=f;i=i+1|0;c[b+4>>2]=i;return j|0}if(!i)h=0;else{c[6435]=(c[6435]|0)+1;h=yc((i<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}d=c[b+4>>2]|0}if((d|0)>0){e=0;do{c[h+(e<<2)>>2]=c[(c[b+12>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(d|0))}e=c[b+12>>2]|0;if(e){if(a[b+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);d=c[b+4>>2]|0}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=h;c[b+8>>2]=i;i=d;e=b+12|0;e=c[e>>2]|0;e=e+(i<<2)|0;c[e>>2]=f;i=i+1|0;c[b+4>>2]=i;return j|0}function Vh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;o=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);u=+g[a+72>>2];t=+g[a+56>>2];r=+g[a+76>>2];q=+g[a+60>>2];n=+g[a+80>>2];m=+g[a+64>>2];E=+g[b>>2];y=+N(+E);D=+g[b+4>>2];x=+N(+D);k=+g[b+8>>2];l=+N(+k);C=+g[b+16>>2];w=+N(+C);B=+g[b+20>>2];v=+N(+B);i=+g[b+24>>2];j=+N(+i);A=+g[b+32>>2];s=+N(+A);z=+g[b+36>>2];p=+N(+z);f=+g[b+40>>2];h=+N(+f);k=(u+t)*.5*E+(r+q)*.5*D+(n+m)*.5*k+ +g[b+48>>2];i=(u+t)*.5*C+(r+q)*.5*B+(n+m)*.5*i+ +g[b+52>>2];f=(u+t)*.5*A+(r+q)*.5*z+(n+m)*.5*f+ +g[b+56>>2];l=(o+(u-t)*.5)*y+(o+(r-q)*.5)*x+(o+(n-m)*.5)*l;j=(o+(u-t)*.5)*w+(o+(r-q)*.5)*v+(o+(n-m)*.5)*j;h=(o+(u-t)*.5)*s+(o+(r-q)*.5)*p+(o+(n-m)*.5)*h;g[d>>2]=k-l;g[d+4>>2]=i-j;g[d+8>>2]=f-h;g[d+12>>2]=0.0;g[e>>2]=l+k;g[e+4>>2]=j+i;g[e+8>>2]=h+f;g[e+12>>2]=0.0;return}function Wh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0;f=i;i=i+16|0;y=c[a+52>>2]|0;z=c[a+28+(((y+2|0)%3|0)<<2)>>2]|0;c[f>>2]=z;c[f+4>>2]=z;c[f+8>>2]=z;g[f+12>>2]=0.0;g[f+(y<<2)>>2]=(c[k>>2]=z,+g[k>>2])+ +g[a+28+(y<<2)>>2];l=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);o=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);l=l+ +g[f>>2];g[f>>2]=l;h=h+ +g[f+4>>2];g[f+4>>2]=h;o=o+ +g[f+8>>2];v=+N(+(+g[b>>2]));u=+N(+(+g[b+4>>2]));w=+N(+(+g[b+8>>2]));r=+N(+(+g[b+16>>2]));q=+N(+(+g[b+20>>2]));s=+N(+(+g[b+24>>2]));m=+N(+(+g[b+32>>2]));j=+N(+(+g[b+36>>2]));n=+N(+(+g[b+40>>2]));x=+g[b+48>>2];t=+g[b+52>>2];p=+g[b+56>>2];g[d>>2]=x-(o*w+(v*l+u*h));g[d+4>>2]=t-(o*s+(r*l+q*h));g[d+8>>2]=p-(o*n+(m*l+j*h));g[d+12>>2]=0.0;g[e>>2]=x+(o*w+(v*l+u*h));g[e+4>>2]=t+(o*s+(r*l+q*h));g[e+8>>2]=p+(o*n+(m*l+j*h));g[e+12>>2]=0.0;i=f;return}function Xh(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;if(a[d+32>>0]&1){f=c[b+4>>2]|0;if(f|0)gj(f,d,e);f=c[b>>2]|0;if(f|0){n=+g[d>>2];l=+g[f+128>>2];m=+g[d+4>>2];k=+g[d+8>>2];h=+g[e+4>>2];p=+g[e+8>>2];o=+g[e>>2];j=+g[f+180>>2]*(k*h-m*p)+ +g[f+184>>2]*(n*p-k*o)+(m*o-n*h)*+g[f+188>>2];i=(k*h-m*p)*+g[f+196>>2]+(n*p-k*o)*+g[f+200>>2]+(m*o-n*h)*+g[f+204>>2];h=(k*h-m*p)*+g[f+212>>2]+(n*p-k*o)*+g[f+216>>2]+(m*o-n*h)*+g[f+220>>2];g[f+244>>2]=n*l+ +g[f+244>>2];g[f+248>>2]=l*m+ +g[f+248>>2];g[f+252>>2]=l*k+ +g[f+252>>2];g[f+316>>2]=n*l+ +g[f+316>>2];g[f+320>>2]=l*m+ +g[f+320>>2];g[f+324>>2]=l*k+ +g[f+324>>2];g[f+260>>2]=j+ +g[f+260>>2];g[f+264>>2]=i+ +g[f+264>>2];g[f+268>>2]=h+ +g[f+268>>2];g[f+332>>2]=j+ +g[f+332>>2];g[f+336>>2]=i+ +g[f+336>>2];g[f+340>>2]=h+ +g[f+340>>2];c[f+308>>2]=(c[f+308>>2]|0)+1}}if(!(a[d+32>>0]&2))return;jj(b,d+16|0,e);return}function Yh(a){a=a|0;var b=0,d=0,e=0,f=0;d=i;i=i+16|0;li(15122);Ab[c[(c[a>>2]|0)+8>>2]&255](a);Ab[c[(c[a>>2]|0)+12>>2]&255](a);b=c[a+24>>2]|0;li(15156);if(b|0){f=c[(c[b>>2]|0)+32>>2]|0;e=c[a+68>>2]|0;e=Eb[c[(c[e>>2]|0)+36>>2]&127](e)|0;mc[f&127](b,e,a+28|0,c[a+24>>2]|0)}a=c[2357]|0;f=(c[a+16>>2]|0)+-1|0;c[a+16>>2]=f;do if(!f){if(c[a+4>>2]|0){tb(d|0,0)|0;b=c[6434]|0;g[a+8>>2]=+g[a+8>>2]+ +(((c[d+4>>2]|0)-(c[b+4>>2]|0)+(((c[d>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0)/1.0e3;b=c[2357]|0;if(c[a+16>>2]|0)break}else b=a;b=c[b+20>>2]|0;c[2357]=b}else b=a;while(0);a=b+16|0;f=(c[a>>2]|0)+-1|0;c[a>>2]=f;if(f|0){i=d;return}do if(c[b+4>>2]|0){tb(d|0,0)|0;e=c[6434]|0;f=b+8|0;g[f>>2]=+g[f>>2]+ +(((c[d+4>>2]|0)-(c[e+4>>2]|0)+(((c[d>>2]|0)-(c[e>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[a>>2]|0)){b=c[2357]|0;break}else{i=d;return}}while(0);c[2357]=c[b+20>>2];i=d;return}function Zh(b,d){b=b|0;d=d|0;var e=0;c[b>>2]=8840;a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=-1;c[b+16>>2]=0;c[b+20>>2]=0;a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;c[b+64>>2]=0;c[b+68>>2]=0;c[b+72>>2]=-1;c[b+76>>2]=0;c[b+80>>2]=0;a[b+193>>0]=0;a[b+194>>0]=1;a[b+192>>0]=(d|0)!=0^1;g[b+140>>2]=0.0;c[b+144>>2]=0;c[b+164>>2]=0;c[b+148>>2]=1;c[b+152>>2]=0;c[b+156>>2]=10;c[b+160>>2]=1;c[b+168>>2]=0;c[b+172>>2]=0;g[b+176>>2]=0.0;if(d|0){e=d;d=b+136|0;c[d>>2]=e;d=b+188|0;c[d>>2]=0;d=b+180|0;c[d>>2]=0;d=b+184|0;c[d>>2]=0;b=b+124|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;return}c[6435]=(c[6435]|0)+1;d=yc(95)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}Ri(d);e=b+136|0;c[e>>2]=d;e=b+188|0;c[e>>2]=0;e=b+180|0;c[e>>2]=0;e=b+184|0;c[e>>2]=0;e=b+124|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;return}function _h(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0,j=0.0,k=0.0;i=c[b>>2]|0;if((i|0)==(c[a+80>>2]|0)){k=1.0;return +k}if(c[i+204>>2]&4|0){k=1.0;return +k}h=+g[b+8>>2];f=+g[b+12>>2];e=+g[b+16>>2];if(d){j=h;k=f}else{j=+g[i+4>>2]*h+ +g[i+8>>2]*f+ +g[i+12>>2]*e;k=h*+g[i+20>>2]+f*+g[i+24>>2]+e*+g[i+28>>2];e=h*+g[i+36>>2]+f*+g[i+40>>2]+e*+g[i+44>>2]}if(j*+g[a+84>>2]+k*+g[a+88>>2]+e*+g[a+92>>2]<+g[a+100>>2]){k=1.0;return +k}c[a+4>>2]=c[b+40>>2];c[a+76>>2]=i;if(d){c[a+44>>2]=c[b+8>>2];c[a+44+4>>2]=c[b+8+4>>2];c[a+44+8>>2]=c[b+8+8>>2];c[a+44+12>>2]=c[b+8+12>>2]}else{e=+g[b+8>>2];f=+g[b+12>>2];h=+g[b+16>>2];j=e*+g[i+20>>2]+f*+g[i+24>>2]+h*+g[i+28>>2];k=e*+g[i+36>>2]+f*+g[i+40>>2]+h*+g[i+44>>2];g[a+44>>2]=+g[i+4>>2]*e+ +g[i+8>>2]*f+ +g[i+12>>2]*h;g[a+48>>2]=j;g[a+52>>2]=k;g[a+56>>2]=0.0}c[a+60>>2]=c[b+24>>2];c[a+60+4>>2]=c[b+24+4>>2];c[a+60+8>>2]=c[b+24+8>>2];c[a+60+12>>2]=c[b+24+12>>2];k=+g[b+40>>2];return +k}function $h(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=c[b+16>>2]|0;if(d|0){if(a[b+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;d=c[b+40>>2]|0;if(d|0){if(a[b+44>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=0;c[b+32>>2]=0;c[b+36>>2]=0;d=c[b+60>>2]|0;if(d|0){if(a[b+64>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=0;c[b+52>>2]=0;c[b+56>>2]=0;if((c[b+12>>2]|0)>=2){Kf(b);return}c[6435]=(c[6435]|0)+1;d=yc(43)|0;if(!d)f=0;else{c[(d+4+15&-16)+-4>>2]=d;f=d+4+15&-16}d=c[b+8>>2]|0;if((d|0)>0){e=0;do{g=f+(e*12|0)|0;h=(c[b+16>>2]|0)+(e*12|0)|0;c[g>>2]=c[h>>2];c[g+4>>2]=c[h+4>>2];c[g+8>>2]=c[h+8>>2];e=e+1|0}while((e|0)!=(d|0))}d=c[b+16>>2]|0;if(d|0){if(a[b+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=2;Kf(b);return}function ai(a,b,e){a=a|0;b=b|0;e=e|0;si(a,b,e)|0;c[b+52>>2]=c[a+52>>2];c[b+56>>2]=c[a+56>>2];c[b+60>>2]=c[a+60>>2];c[b+64>>2]=c[a+64>>2];c[b+68>>2]=c[a+68>>2];c[b+72>>2]=c[a+72>>2];c[b+76>>2]=c[a+76>>2];c[b+80>>2]=c[a+80>>2];c[b+84>>2]=c[a+84>>2];c[b+88>>2]=c[a+88>>2];c[b+92>>2]=c[a+92>>2];c[b+96>>2]=c[a+96>>2];c[b+100>>2]=c[a+100>>2];c[b+104>>2]=c[a+104>>2];c[b+108>>2]=c[a+108>>2];c[b+112>>2]=c[a+112>>2];c[b+116>>2]=c[a+116>>2];c[b+120>>2]=c[a+120>>2];c[b+124>>2]=c[a+124>>2];c[b+128>>2]=c[a+128>>2];c[b+132>>2]=c[a+132>>2];c[b+136>>2]=c[a+136>>2];c[b+140>>2]=c[a+140>>2];c[b+144>>2]=c[a+144>>2];c[b+148>>2]=c[a+148>>2];c[b+152>>2]=c[a+152>>2];c[b+156>>2]=c[a+156>>2];c[b+160>>2]=c[a+160>>2];c[b+164>>2]=c[a+164>>2];c[b+168>>2]=c[a+168>>2];c[b+172>>2]=c[a+172>>2];c[b+176>>2]=c[a+176>>2];c[b+180>>2]=c[a+188>>2];c[b+184>>2]=c[a+184>>2];c[b+188>>2]=c[a+196>>2];c[b+192>>2]=c[a+192>>2];c[b+196>>2]=d[a+180>>0];c[b+200>>2]=d[a+49>>0];return 12680}function bi(a,b){a=a|0;b=b|0;var d=0,e=0,f=0.0;e=i;i=i+32|0;d=c[b+388>>2]|0;switch(c[a+388>>2]&48&d|0){case 32:{if((a|0)==(b|0)&(d&64|0)==0){i=e;return}g[e+4>>2]=1.0;c[e+8>>2]=0;c[e+8+4>>2]=0;c[e+8+8>>2]=0;c[e+8+12>>2]=0;c[e>>2]=3540;c[e+8>>2]=c[a+456>>2];d=c[a+192>>2]|0;f=+Sb[c[(c[d>>2]|0)+48>>2]&15](d);d=c[b+192>>2]|0;g[e+12>>2]=f+ +Sb[c[(c[d>>2]|0)+48>>2]&15](d);c[e+16>>2]=c[(+g[a+316>>2]<+g[b+316>>2]?a+316|0:b+316|0)>>2];c[e+24>>2]=a;c[e+28>>2]=b;We(c[a+1048>>2]|0,c[b+1048>>2]|0,e);i=e;return}case 16:{if((a|0)==(b|0)){i=e;return}c[e>>2]=3576;d=c[a+192>>2]|0;f=+Sb[c[(c[d>>2]|0)+48>>2]&15](d);d=c[b+192>>2]|0;g[e+12>>2]=f+ +Sb[c[(c[d>>2]|0)+48>>2]&15](d);c[e+4>>2]=a;c[e+8>>2]=b;We(c[a+928>>2]|0,c[b+988>>2]|0,e);c[e+4>>2]=b;c[e+8>>2]=a;We(c[b+928>>2]|0,c[a+988>>2]|0,e);i=e;return}default:{i=e;return}}}function ci(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0;h=i;i=i+96|0;g[h+4>>2]=1.0;c[h+8>>2]=0;b[h+12>>1]=1;b[h+14>>1]=-1;c[h+16>>2]=0;c[h>>2]=2948;c[h+20>>2]=c[d>>2];c[h+20+4>>2]=c[d+4>>2];c[h+20+8>>2]=c[d+8>>2];c[h+20+12>>2]=c[d+12>>2];c[h+36>>2]=c[e>>2];c[h+36+4>>2]=c[e+4>>2];c[h+36+8>>2]=c[e+8>>2];c[h+36+12>>2]=c[e+12>>2];a=c[a+4>>2]|0;mc[c[(c[a>>2]|0)+32>>2]&127](a,d,e,h);d=c[h+8>>2]|0;if(!d){f=0;i=h;return f|0}if(!(c[d+236>>2]&2)){f=0;i=h;return f|0}if(c[d+204>>2]&4|0){f=0;i=h;return f|0}c[f>>2]=c[h+68>>2];c[f+4>>2]=c[h+68+4>>2];c[f+8>>2]=c[h+68+8>>2];c[f+12>>2]=c[h+68+12>>2];c[f+16>>2]=c[h+52>>2];c[f+16+4>>2]=c[h+52+4>>2];c[f+16+8>>2]=c[h+52+8>>2];c[f+16+12>>2]=c[h+52+12>>2];m=+g[f+16>>2];l=+g[f+20>>2];k=+g[f+24>>2];j=1.0/+O(+(m*m+l*l+k*k));g[f+16>>2]=m*j;g[f+20>>2]=l*j;g[f+24>>2]=k*j;c[f+32>>2]=c[h+4>>2];f=d;i=h;return f|0}function di(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e=b+288|0;f=d;g=e+104|0;do{c[e>>2]=c[f>>2];e=e+4|0;f=f+4|0}while((e|0)<(g|0));i=c[d+108>>2]|0;e=c[b+396>>2]|0;a:do if((e|0)>(i|0))e=b+404|0;else{if((e|0)<(i|0)?(c[b+400>>2]|0)<(i|0):0){if((i|0)!=0?(c[6435]=(c[6435]|0)+1,h=yc((i<<2|3)+16|0)|0,(h|0)!=0):0){c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}else h=0;f=c[b+396>>2]|0;g=0;while(1){if((g|0)>=(f|0))break;c[h+(g<<2)>>2]=c[(c[b+404>>2]|0)+(g<<2)>>2];g=g+1|0}f=c[b+404>>2]|0;if(f|0){if(!((a[b+408>>0]&1)==0|(f|0)==0)){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+404>>2]=0}a[b+408>>0]=1;c[b+404>>2]=h;c[b+400>>2]=i}while(1){if((e|0)>=(i|0)){e=b+404|0;break a}c[(c[b+404>>2]|0)+(e<<2)>>2]=0;e=e+1|0}}while(0);c[b+396>>2]=i;e=c[e>>2]|0;f=0;while(1){if((f|0)>=(i|0))break;c[e+(f<<2)>>2]=c[(c[d+116>>2]|0)+(f<<2)>>2];f=f+1|0}Yi(b+412|0,d+124|0);Yi(b+432|0,d+144|0);return}function ei(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;Ab[c[(c[b>>2]|0)+32>>2]&255](b);d=Ob[c[(c[b>>2]|0)+16>>2]&63](b,104,1)|0;e=c[d+8>>2]|0;f=e;g=f+104|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));c[e+88>>2]=c[a+248>>2];c[e+92>>2]=c[a+252>>2];c[e+96>>2]=c[a+256>>2];c[e+100>>2]=c[a+260>>2];c[e>>2]=c[a+92>>2];c[e+4>>2]=c[a+96>>2];c[e+8>>2]=c[a+100>>2];c[e+12>>2]=c[a+104>>2];c[e+16>>2]=c[a+108>>2];c[e+20>>2]=c[a+116>>2];c[e+24>>2]=c[a+120>>2];c[e+28>>2]=c[a+124>>2];c[e+32>>2]=c[a+128>>2];c[e+36>>2]=c[a+132>>2];c[e+40>>2]=c[a+140>>2];c[e+44>>2]=c[a+144>>2];c[e+48>>2]=c[a+148>>2];c[e+52>>2]=c[a+152>>2];c[e+56>>2]=c[a+168>>2];c[e+60>>2]=c[a+172>>2];c[e+64>>2]=c[a+112>>2];c[e+68>>2]=c[a+156>>2];c[e+72>>2]=c[a+160>>2];c[e+76>>2]=c[a+164>>2];c[e+80>>2]=c[a+136>>2];yb[c[(c[b>>2]|0)+20>>2]&31](b,d,11938,1145853764,e);mj(a,b);td(a,b);Ab[c[(c[b>>2]|0)+36>>2]&255](b);return}function fi(b,d){b=b|0;d=d|0;if((c[b+16>>2]|0)!=(0-(c[b+76>>2]|0)|0))return;d=c[b+4>>2]|0;if(d|0)xn(b+4|0,d);d=c[b+8>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+8>>2]=0;c[b+12>>2]=-1;d=c[b+36>>2]|0;if(d|0){if(a[b+40>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;c[b+20>>2]=0;d=c[b+64>>2]|0;if(d|0)xn(b+64|0,d);d=c[b+68>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+68>>2]=0;c[b+72>>2]=-1;d=c[b+96>>2]|0;if(d|0){if(a[b+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;c[b+80>>2]=0;a[b+193>>0]=0;a[b+194>>0]=1;c[b+144>>2]=0;c[b+164>>2]=0;c[b+148>>2]=1;c[b+152>>2]=0;c[b+156>>2]=10;c[b+160>>2]=1;c[b+124>>2]=0;c[b+124+4>>2]=0;c[b+124+8>>2]=0;c[b+168>>2]=0;c[b+168+4>>2]=0;c[b+168+8>>2]=0;c[b+168+12>>2]=0;c[b+168+16>>2]=0;c[b+168+20>>2]=0;return}function gi(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,k=0.0;j=i;i=i+32|0;c[j+16>>2]=c[d>>2];c[j+16+4>>2]=c[d+4>>2];c[j+16+8>>2]=c[d+8>>2];c[j+16+12>>2]=c[d+12>>2];e=+g[j+16>>2];h=+g[j+16+4>>2];f=+g[j+16+8>>2];if(e*e+h*h+f*f<1.4210854715202004e-14){c[j+16>>2]=-1082130432;c[j+16+4>>2]=-1082130432;c[j+16+8>>2]=-1082130432;g[j+16+12>>2]=0.0;e=-1.0;h=-1.0;f=-1.0}k=1.0/+O(+(e*e+h*h+f*f));g[j+16>>2]=e*k;g[j+16+4>>2]=h*k;g[j+16+8>>2]=f*k;Gd(j,b,j+16|0);switch(c[b+4>>2]|0){case 8:{e=+g[b+28>>2]*+g[b+12>>2];break}case 0:{e=+g[b+44>>2];break}case 1:{e=+g[b+44>>2];break}case 13:{e=+g[b+44>>2];break}case 11:{e=+g[b+44>>2];break}case 10:{e=+g[b+44>>2];break}case 4:case 5:{e=+g[b+44>>2];break}default:e=+Sb[c[(c[b>>2]|0)+48>>2]&15](b)}h=e*+g[j+16+4>>2]+ +g[j+4>>2];k=e*+g[j+16+8>>2]+ +g[j+8>>2];g[a>>2]=e*+g[j+16>>2]+ +g[j>>2];g[a+4>>2]=h;g[a+8>>2]=k;g[a+12>>2]=0.0;i=j;return}function hi(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0.0,h=0.0,i=0.0,j=0.0;c[a+4>>2]=35;c[a+8>>2]=0;c[a+12>>2]=1065353216;c[a+16>>2]=1065353216;c[a+20>>2]=1065353216;g[a+24>>2]=0.0;g[a+44>>2]=.03999999910593033;c[a>>2]=8140;c[a+52>>2]=1;h=+g[b>>2];f=+g[b+4>>2];d=+g[b+8>>2];d=+g[b+((h<f?(h<d?0:2):f<d?1:2)<<2)>>2]*.10000000149011612;if(d<.03999999910593033){j=+xz(a);i=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);j=j+ +g[a+28>>2];i=i+ +g[a+32>>2];h=h+ +g[a+36>>2];g[a+44>>2]=d;d=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);h=h-+Sb[c[(c[a>>2]|0)+48>>2]&15](a);g[a+28>>2]=j-d;g[a+32>>2]=i-f;g[a+36>>2]=h;g[a+40>>2]=0.0;e=c[a>>2]|0}else e=8140;h=+Sb[c[e+48>>2]&15](a);i=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);j=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);i=+g[b+4>>2]*+g[a+16>>2]-i;j=+g[b+8>>2]*+g[a+20>>2]-j;g[a+28>>2]=+g[b>>2]*+g[a+12>>2]-h;g[a+32>>2]=i;g[a+36>>2]=j;g[a+40>>2]=0.0;c[a+4>>2]=13;return}function ii(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,j=0,l=0,m=0,n=0,o=0.0;m=i;i=i+80|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;e=+g[d>>2];f=+g[d+4>>2];h=+g[d+8>>2];if(e*e+f*f+h*h<9.999999747378752e-05){l=1065353216;j=0;e=0.0;d=0}else{o=1.0/+O(+(e*e+f*f+h*h));l=(g[k>>2]=e*o,c[k>>2]|0);n=(g[k>>2]=f*o,c[k>>2]|0);j=(g[k>>2]=h*o,c[k>>2]|0);e=+g[d+12>>2];d=n}c[m+32>>2]=7824;n=m+32+4|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;g[m+32+20>>2]=-999999984306749440.0;c[m+32+24>>2]=l;c[m+32+28>>2]=d;c[m+32+32>>2]=j;g[m+32+36>>2]=e;c[m+16>>2]=1566444395;c[m+16+4>>2]=1566444395;c[m+16+8>>2]=1566444395;g[m+16+12>>2]=0.0;b=c[b+92>>2]|0;l=c[(c[b>>2]|0)+8>>2]|0;g[m>>2]=-999999984306749440.0;g[m+4>>2]=-999999984306749440.0;g[m+8>>2]=-999999984306749440.0;g[m+12>>2]=0.0;mc[l&127](b,m+32|0,m,m+16|0);c[a>>2]=c[n>>2];c[a+4>>2]=c[n+4>>2];c[a+8>>2]=c[n+8>>2];c[a+12>>2]=c[n+12>>2];i=m;return}function ji(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,i=0,j=0.0,k=0.0,l=0,m=0.0;e=+g[b+60>>2]*.5;l=c[b+68>>2]|0;h=+g[d>>2];j=+g[d+4>>2];k=+g[d+8>>2];k=+O(+(h*h+j*j+k*k));f=c[b+64>>2]|0;do if(!(+g[d+(l<<2)>>2]>k*+g[b+52>>2])){h=+g[d+(f<<2)>>2];i=c[b+72>>2]|0;j=+g[d+(i<<2)>>2];k=+O(+(h*h+j*j));if(k>1.1920928955078125e-07){k=+g[b+56>>2]/k;g[a+(f<<2)>>2]=h*k;g[a+(l<<2)>>2]=-e;g[a+(i<<2)>>2]=j*k;break}else{g[a+(f<<2)>>2]=0.0;g[a+(l<<2)>>2]=-e;g[a+(i<<2)>>2]=0.0;break}}else{g[a+(f<<2)>>2]=0.0;g[a+(l<<2)>>2]=e;g[a+(c[b+72>>2]<<2)>>2]=0.0}while(0);if(!(+Sb[c[(c[b>>2]|0)+48>>2]&15](b)!=0.0))return;h=+g[d>>2];j=+g[d+4>>2];k=+g[d+8>>2];m=h*h+j*j+k*k<1.4210854715202004e-14?-1.0:h;e=h*h+j*j+k*k<1.4210854715202004e-14?-1.0:j;k=h*h+j*j+k*k<1.4210854715202004e-14?-1.0:k;j=1.0/+O(+(k*k+(m*m+e*e)));h=+Sb[c[(c[b>>2]|0)+48>>2]&15](b);g[a>>2]=+g[a>>2]+h*j*m;g[a+4>>2]=h*j*e+ +g[a+4>>2];g[a+8>>2]=h*j*k+ +g[a+8>>2];return}function ki(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=Zb[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;g=Zb[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b>>2]=g;if(g|0)Cb[c[(c[d>>2]|0)+48>>2]&127](d,e);c[b+4>>2]=c[a+4>>2];c[b+28>>2]=c[a+28>>2];c[b+32>>2]=c[a+32>>2];c[b+36>>2]=c[a+36>>2];c[b+40>>2]=c[a+40>>2];c[b+12>>2]=c[a+12>>2];c[b+16>>2]=c[a+16>>2];c[b+20>>2]=c[a+20>>2];c[b+24>>2]=c[a+24>>2];c[b+44>>2]=c[a+44>>2];f=c[a+96>>2]|0;c[b+60>>2]=f;if(!f){c[b+52>>2]=0;c[b+56>>2]=0;return 17310}c[b+52>>2]=Zb[c[(c[d>>2]|0)+28>>2]&31](d,c[a+104>>2]|0)|0;c[b+56>>2]=0;g=Ob[c[(c[d>>2]|0)+16>>2]&63](d,16,f)|0;if((f|0)>0){e=c[a+104>>2]|0;b=0;a=c[g+8>>2]|0;while(1){c[a>>2]=c[e+(b<<4)>>2];c[a+4>>2]=c[e+(b<<4)+4>>2];c[a+8>>2]=c[e+(b<<4)+8>>2];c[a+12>>2]=c[e+(b<<4)+12>>2];b=b+1|0;if((b|0)==(f|0))break;else a=a+16|0}}else e=c[a+104>>2]|0;yb[c[(c[d>>2]|0)+20>>2]&31](d,g,19308,1497453121,e);return 17310}function li(a){a=a|0;var b=0,d=0,e=0,f=0;f=i;i=i+16|0;d=c[2357]|0;if((c[d>>2]|0)==(a|0))b=d;else{b=c[d+24>>2]|0;a:do if(!b)e=5;else while(1){if((c[b>>2]|0)==(a|0))break a;b=c[b+28>>2]|0;if(!b){e=5;break}}while(0);do if((e|0)==5){while(1){b=yc(36)|0;if(b|0){e=9;break}b=c[6564]|0;c[6564]=b+0;if(!b){e=8;break}jc[b&3]();e=5}if((e|0)==8){f=Ya(4)|0;c[f>>2]=9640;pb(f|0,2800,251)}else if((e|0)==9){c[b>>2]=a;c[b+4>>2]=0;c[b+4+4>>2]=0;c[b+4+8>>2]=0;c[b+4+12>>2]=0;c[b+20>>2]=d;c[b+24>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;Vq(b);c[b+28>>2]=c[d+24>>2];c[d+24>>2]=b;break}}while(0);c[2357]=b}a=b+4|0;c[a>>2]=(c[a>>2]|0)+1;a=b+16|0;e=c[a>>2]|0;c[a>>2]=e+1;if(e|0){i=f;return}tb(f|0,0)|0;e=c[6434]|0;c[b+12>>2]=(c[f+4>>2]|0)-(c[e+4>>2]|0)+(((c[f>>2]|0)-(c[e>>2]|0)|0)*1e6|0);i=f;return}function mi(a,b,d){a=a|0;b=b|0;d=d|0;c[a+300>>2]=c[b>>2];c[a+300+4>>2]=c[b+4>>2];c[a+300+8>>2]=c[b+8>>2];c[a+300+12>>2]=c[b+12>>2];c[a+316>>2]=c[b+16>>2];c[a+316+4>>2]=c[b+16+4>>2];c[a+316+8>>2]=c[b+16+8>>2];c[a+316+12>>2]=c[b+16+12>>2];c[a+332>>2]=c[b+32>>2];c[a+332+4>>2]=c[b+32+4>>2];c[a+332+8>>2]=c[b+32+8>>2];c[a+332+12>>2]=c[b+32+12>>2];c[a+348>>2]=c[b+48>>2];c[a+348+4>>2]=c[b+48+4>>2];c[a+348+8>>2]=c[b+48+8>>2];c[a+348+12>>2]=c[b+48+12>>2];c[a+364>>2]=c[d>>2];c[a+364+4>>2]=c[d+4>>2];c[a+364+8>>2]=c[d+8>>2];c[a+364+12>>2]=c[d+12>>2];c[a+380>>2]=c[d+16>>2];c[a+380+4>>2]=c[d+16+4>>2];c[a+380+8>>2]=c[d+16+8>>2];c[a+380+12>>2]=c[d+16+12>>2];c[a+396>>2]=c[d+32>>2];c[a+396+4>>2]=c[d+32+4>>2];c[a+396+8>>2]=c[d+32+8>>2];c[a+396+12>>2]=c[d+32+12>>2];c[a+412>>2]=c[d+48>>2];c[a+412+4>>2]=c[d+48+4>>2];c[a+412+8>>2]=c[d+48+8>>2];c[a+412+12>>2]=c[d+48+12>>2];Ab[c[(c[a>>2]|0)+8>>2]&255](a);return}function ni(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0.0;m=c[a+4>>2]|0;a=c[a+64>>2]|0;do if(!m)if(!a){e=0.0;n=0.0;j=0.0;l=0.0;h=0.0;k=0.0;i=0.0;f=0.0}else{e=+g[a>>2];n=+g[a+12>>2];j=+g[a+16>>2];l=+g[a+20>>2];h=+g[a+24>>2];k=+g[a+28>>2];i=+g[a+4>>2];f=+g[a+8>>2]}else{e=+g[m>>2];if(!a){n=+g[m+12>>2];j=+g[m+16>>2];l=+g[m+20>>2];h=+g[m+24>>2];k=+g[m+28>>2];i=+g[m+4>>2];f=+g[m+8>>2];break}k=+g[a>>2];e=e<k?e:k;k=+g[m+16>>2];j=+g[a+16>>2];j=k>j?k:j;k=+g[m+4>>2];i=+g[a+4>>2];i=k<i?k:i;k=+g[m+20>>2];l=+g[a+20>>2];l=k>l?k:l;k=+g[m+8>>2];f=+g[a+8>>2];f=k<f?k:f;k=+g[m+24>>2];h=+g[a+24>>2];if(k>h){n=0.0;h=k;k=0.0}else{n=0.0;k=0.0}}while(0);g[b>>2]=e;g[b+4>>2]=i;g[b+8>>2]=f;g[b+12>>2]=n;g[d>>2]=j;g[d+4>>2]=l;g[d+8>>2]=h;g[d+12>>2]=k;return}function oi(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;c=i;i=i+48|0;Wg(a+364|0,c+16|0);h=-+g[c+16>>2];e=-+g[c+16+4>>2];m=-+g[c+16+8>>2];l=+g[c+16+12>>2];f=+g[b>>2];n=+g[b+12>>2];k=+g[b+8>>2];j=+g[b+4>>2];Wg(a+300|0,c);p=+g[c>>2];q=+g[c+12>>2];d=+g[c+8>>2];o=+g[c+4>>2];g[c+32>>2]=p*(l*n-f*h-j*e-k*m)+(l*f+n*h+k*e-j*m)*q+(f*m+(n*e+l*j)-k*h)*d-(n*m+l*k+j*h-f*e)*o;g[c+32+4>>2]=p*(n*m+l*k+j*h-f*e)+(q*(f*m+(n*e+l*j)-k*h)+(l*n-f*h-j*e-k*m)*o)-(l*f+n*h+k*e-j*m)*d;g[c+32+8>>2]=q*(n*m+l*k+j*h-f*e)+(l*n-f*h-j*e-k*m)*d+(l*f+n*h+k*e-j*m)*o-p*(f*m+(n*e+l*j)-k*h);g[c+32+12>>2]=(l*n-f*h-j*e-k*m)*q-p*(l*f+n*h+k*e-j*m)-(f*m+(n*e+l*j)-k*h)*o-(n*m+l*k+j*h-f*e)*d;Yd(a,c+32|0);i=c;return}function pi(b){b=b|0;var d=0;d=c[b>>2]|0;if(d|0)xn(b,d);d=c[b+4>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+4>>2]=0;c[b+8>>2]=-1;d=c[b+32>>2]|0;if(d|0){if(a[b+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;c[b+16>>2]=0;d=c[b+52>>2]|0;if(!d){a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}if(!(a[b+56>>0]|0)){a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0);d=c[b+32>>2]|0;a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;if(!d){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}if(a[b+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+32>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;return}function qi(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;if(!e)e=c[b+188>>2]|0;j=c[d>>2]|0;f=c[b+268>>2]|0;a:do if((f|0)>0){h=c[b+276>>2]|0;g=0;while(1){if((c[h+(g<<2)>>2]|0)==(j|0))break;g=g+1|0;if((g|0)>=(f|0))break a}if((g|0)!=(f|0))return}while(0);if((f|0)==(c[b+272>>2]|0)?(i=f|0?f<<1:1,(f|0)<(i|0)):0){if(!i)h=0;else{c[6435]=(c[6435]|0)+1;f=yc((i<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}h=f;f=c[b+268>>2]|0}if((f|0)>0){g=0;do{c[h+(g<<2)>>2]=c[(c[b+276>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[b+276>>2]|0;if(g){if(a[b+280>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0);f=c[b+268>>2]|0}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=h;c[b+272>>2]=i}c[(c[b+276>>2]|0)+(f<<2)>>2]=j;c[b+268>>2]=f+1;b=c[b+284>>2]|0;Ob[c[(c[b>>2]|0)+8>>2]&63](b,e,d)|0;return}function ri(b){b=b|0;var d=0;if((a[22496]|0)==0?Wa(22496)|0:0){if((a[22456]|0)==0?Wa(22456)|0:0){if((a[22464]|0)==0?Wa(22464)|0:0){c[5698]=1065353216;c[5699]=0;c[5700]=0;c[5701]=0;c[5702]=0;c[5703]=1065353216;c[5704]=0;c[5705]=0;c[5706]=0;c[5707]=0;c[5708]=1065353216;g[5709]=0.0;_a(22464)}c[5710]=c[5698];c[5711]=c[5699];c[5712]=c[5700];c[5713]=c[5701];c[5714]=c[5702];c[5715]=c[5703];c[5716]=c[5704];c[5717]=c[5705];c[5718]=c[5706];c[5719]=c[5707];c[5720]=c[5708];c[5721]=c[5709];c[5722]=0;c[5723]=0;c[5724]=0;c[5725]=0;_a(22456)}c[5755]=c[5710];c[5756]=c[5711];c[5757]=c[5712];c[5758]=c[5713];c[5759]=c[5714];c[5760]=c[5715];c[5761]=c[5716];c[5762]=c[5717];c[5763]=c[5718];c[5764]=c[5719];c[5765]=c[5720];c[5766]=c[5721];c[5767]=c[5722];c[5768]=c[5723];c[5769]=c[5724];c[5770]=c[5725];_a(22496)}d=c[b+8>>2]|0;if(!d){b=c[b>>2]|0;return ((b|0)==0?23020:b+60|0)|0}else return d+4|0;return 0}function si(a,b,e){a=a|0;b=b|0;e=e|0;var f=0,g=0;c[b>>2]=Zb[c[(c[e>>2]|0)+28>>2]&31](e,c[a+28>>2]|0)|0;c[b+4>>2]=Zb[c[(c[e>>2]|0)+28>>2]&31](e,c[a+32>>2]|0)|0;f=Zb[c[(c[e>>2]|0)+40>>2]&31](e,a)|0;g=Zb[c[(c[e>>2]|0)+28>>2]&31](e,f)|0;c[b+8>>2]=g;if(g|0)Cb[c[(c[e>>2]|0)+48>>2]&127](e,f);c[b+12>>2]=c[a+4>>2];c[b+24>>2]=d[a+21>>0];c[b+40>>2]=c[a+24>>2];c[b+44>>2]=c[a+16>>2];c[b+48>>2]=d[a+20>>0];c[b+20>>2]=c[a+12>>2];c[b+16>>2]=c[a+8>>2];c[b+28>>2]=c[a+36>>2];c[b+32>>2]=c[a+40>>2];c[b+36>>2]=0;f=c[a+28>>2]|0;if((c[f+488>>2]|0)>0){e=0;do{if((c[(c[f+496>>2]|0)+(e<<2)>>2]|0)==(a|0)){c[b+36>>2]=1;f=c[a+28>>2]|0}e=e+1|0}while((e|0)<(c[f+488>>2]|0))}f=c[a+32>>2]|0;if((c[f+488>>2]|0)>0)e=0;else return 12632;do{if((c[(c[f+496>>2]|0)+(e<<2)>>2]|0)==(a|0)){c[b+36>>2]=1;f=c[a+32>>2]|0}e=e+1|0}while((e|0)<(c[f+488>>2]|0));return 12632}function ti(b,d,e,f){b=+b;d=d|0;e=e|0;f=f|0;var h=0,i=0;while(1){h=yc(140)|0;if(h|0){i=6;break}h=c[6564]|0;c[6564]=h+0;if(!h){i=5;break}jc[h&3]()}if((i|0)==5){f=Ya(4)|0;c[f>>2]=9640;pb(f|0,2800,251)}else if((i|0)==6){g[h>>2]=b;c[h+4>>2]=d;c[h+72>>2]=e;c[h+76>>2]=c[f>>2];c[h+76+4>>2]=c[f+4>>2];c[h+76+8>>2]=c[f+8>>2];c[h+76+12>>2]=c[f+12>>2];g[h+92>>2]=0.0;g[h+96>>2]=0.0;g[h+100>>2]=.5;g[h+104>>2]=0.0;g[h+108>>2]=0.0;g[h+112>>2]=.800000011920929;g[h+116>>2]=1.0;a[h+120>>0]=0;g[h+124>>2]=.004999999888241291;g[h+128>>2]=.009999999776482582;g[h+132>>2]=.009999999776482582;g[h+136>>2]=.009999999776482582;c[h+8>>2]=1065353216;c[h+12>>2]=0;c[h+12+4>>2]=0;c[h+12+8>>2]=0;c[h+12+12>>2]=0;c[h+28>>2]=1065353216;c[h+32>>2]=0;c[h+32+4>>2]=0;c[h+32+8>>2]=0;c[h+32+12>>2]=0;c[h+48>>2]=1065353216;c[h+52>>2]=0;c[h+52+4>>2]=0;c[h+52+8>>2]=0;c[h+52+12>>2]=0;c[h+52+16>>2]=0;return h|0}return 0}function ui(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;if(Eb[c[(c[d>>2]|0)+16>>2]&127](d)|0)return;j=c[b+712>>2]|0;i=Eb[c[(c[d>>2]|0)+36>>2]&127](d)|0;if(Eb[c[(c[d>>2]|0)+8>>2]&127](d)|0?(f=Eb[c[(c[d>>2]|0)+20>>2]&127](d)|0,h=Eb[c[(c[d>>2]|0)+24>>2]&127](d)|0,(j|0)>0):0){e=c[b+720>>2]|0;g=0;a=i+(f<<2)|0;while(1){k=c[e+(g*104|0)+12>>2]|0;f=c[e+(g*104|0)+16>>2]|0;c[a>>2]=c[e+(g*104|0)+8>>2];c[a+4>>2]=k;c[a+8>>2]=f;g=g+1|0;if((g|0)==(j|0))break;else a=a+(h<<2)|0}}if(!(Eb[c[(c[d>>2]|0)+12>>2]&127](d)|0))return;a=Eb[c[(c[d>>2]|0)+28>>2]&127](d)|0;g=Eb[c[(c[d>>2]|0)+32>>2]&127](d)|0;if((j|0)<=0)return;f=c[b+720>>2]|0;a=i+(a<<2)|0;e=0;while(1){b=c[f+(e*104|0)+76>>2]|0;k=c[f+(e*104|0)+80>>2]|0;c[a>>2]=c[f+(e*104|0)+72>>2];c[a+4>>2]=b;c[a+8>>2]=k;e=e+1|0;if((e|0)==(j|0))break;else a=a+(g<<2)|0}return}function vi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0.0,l=0,m=0.0,n=0.0,o=0,p=0,q=0;q=i;i=i+16|0;if((e|0)<=0){i=q;return}p=0;do{o=d+(p<<4)|0;f=+g[a+60>>2]*.5;h=c[a+68>>2]|0;k=+g[b+(p<<4)>>2];m=+g[b+(p<<4)+4>>2];n=+g[b+(p<<4)+8>>2];n=+O(+(k*k+m*m+n*n));j=c[a+64>>2]|0;do if(!(+g[b+(p<<4)+(h<<2)>>2]>n*+g[a+52>>2])){k=+g[b+(p<<4)+(j<<2)>>2];l=c[a+72>>2]|0;m=+g[b+(p<<4)+(l<<2)>>2];n=+O(+(k*k+m*m));if(n>1.1920928955078125e-07){n=+g[a+56>>2]/n;g[q+(j<<2)>>2]=k*n;g[q+(h<<2)>>2]=-f;g[q+(l<<2)>>2]=m*n;break}else{g[q+(j<<2)>>2]=0.0;g[q+(h<<2)>>2]=-f;g[q+(l<<2)>>2]=0.0;break}}else{g[q+(j<<2)>>2]=0.0;g[q+(h<<2)>>2]=f;g[q+(c[a+72>>2]<<2)>>2]=0.0}while(0);c[o>>2]=c[q>>2];c[o+4>>2]=c[q+4>>2];c[o+8>>2]=c[q+8>>2];c[o+12>>2]=c[q+12>>2];p=p+1|0}while((p|0)!=(e|0));i=q;return}function wi(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;c[b>>2]=9352;d=c[b+56>>2]|0;if(d|0){if(a[b+60>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;e=c[b+28>>2]|0;if((e|0)>0){j=0;do{f=c[b+36>>2]|0;g=f+(j*36|0)+4|0;h=f+(j*36|0)+12|0;i=c[h>>2]|0;d=f+(j*36|0)+16|0;if(i|0){if(a[d>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[i+-4>>2]|0)}c[h>>2]=0}a[d>>0]=1;c[h>>2]=0;c[g>>2]=0;c[f+(j*36|0)+8>>2]=0;j=j+1|0}while((j|0)!=(e|0))}d=c[b+36>>2]|0;if(d|0){if(a[b+40>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function xi(b){b=b|0;var d=0;c[b>>2]=8452;d=c[b+156>>2]|0;if(d|0){if(a[b+160>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+156>>2]=0}a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;d=c[b+136>>2]|0;if(d|0){if(a[b+140>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+116>>2]|0;if(d|0){if(a[b+120>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;d=c[b+96>>2]|0;if(d|0){if(a[b+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;c[b>>2]=9368;d=c[b+32>>2]|0;if(!d){a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;b=b+28|0;c[b>>2]=0;return}if(a[b+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+32>>2]=0;a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;b=b+28|0;c[b>>2]=0;return}function yi(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;i=c[b+4>>2]|0;if((i|0)>=(d|0)){c[b+4>>2]=d;return}if((c[b+8>>2]|0)<(d|0)){if(!d){f=0;g=i}else{c[6435]=(c[6435]|0)+1;f=yc((d<<4|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}g=c[b+4>>2]|0}if((g|0)>0){h=0;do{j=c[b+12>>2]|0;c[f+(h<<4)>>2]=c[j+(h<<4)>>2];c[f+(h<<4)+4>>2]=c[j+(h<<4)+4>>2];c[f+(h<<4)+8>>2]=c[j+(h<<4)+8>>2];c[f+(h<<4)+12>>2]=c[j+(h<<4)+12>>2];h=h+1|0}while((h|0)!=(g|0))}g=c[b+12>>2]|0;if(g|0){if(a[b+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=f;c[b+8>>2]=d;g=b+12|0}else g=b+12|0;f=i;do{j=c[g>>2]|0;c[j+(f<<4)>>2]=c[e>>2];c[j+(f<<4)+4>>2]=c[e+4>>2];c[j+(f<<4)+8>>2]=c[e+8>>2];c[j+(f<<4)+12>>2]=c[e+12>>2];f=f+1|0}while((f|0)!=(d|0));c[b+4>>2]=d;return}function zi(b){b=b|0;var d=0,e=0;c[6435]=(c[6435]|0)+1;d=yc(635)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+164>>2]=1065353216;c[d+168>>2]=1065353216;c[d+172>>2]=1065353216;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749440.0;e=d+188|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[d+204>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;g[d+232>>2]=0.0;c[d+236>>2]=1;c[d+240>>2]=0;g[d+244>>2]=1.0;e=d+248|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[d+4>>2]=1065353216;e=d+8|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[d+24>>2]=1065353216;e=d+28|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[d+44>>2]=1065353216;e=d+48|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[d>>2]=4108;a[d+500>>0]=1;c[d+496>>2]=0;c[d+488>>2]=0;c[d+492>>2]=0;Od(d,b);return d|0}function Ai(b){b=b|0;var d=0;c[b>>2]=9012;d=c[b+160>>2]|0;if(d|0){if(a[b+164>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+160>>2]=0}a[b+164>>0]=1;c[b+160>>2]=0;c[b+152>>2]=0;c[b+156>>2]=0;d=c[b+136>>2]|0;if(d|0){if(a[b+140>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+136>>2]=0}a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;d=c[b+116>>2]|0;if(d|0){if(a[b+120>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+116>>2]=0}a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;d=c[b+96>>2]|0;if(d|0){if(a[b+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;d=c[b+76>>2]|0;if(!d){a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;b=b+72|0;c[b>>2]=0;return}if(a[b+80>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+76>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;b=b+72|0;c[b>>2]=0;return}function Bi(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(c[d+28>>2]|0)!=1:0)c[d+28>>2]=f}else{if((b|0)!=(c[d>>2]|0)){b=c[b+8>>2]|0;yb[c[(c[b>>2]|0)+24>>2]&31](b,d,e,f,g);break}if((c[d+16>>2]|0)!=(e|0)?(c[d+20>>2]|0)!=(e|0):0){c[d+32>>2]=f;if((c[d+44>>2]|0)==4)break;a[d+52>>0]=0;a[d+53>>0]=0;b=c[b+8>>2]|0;Qb[c[(c[b>>2]|0)+20>>2]&7](b,d,e,e,1,g);if(a[d+53>>0]|0)if(!(a[d+52>>0]|0)){f=1;b=13}else b=17;else{f=0;b=13}do if((b|0)==13){c[d+20>>2]=e;c[d+40>>2]=(c[d+40>>2]|0)+1;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(f){b=17;break}else{f=4;break}}if(f)b=17;else f=4}while(0);if((b|0)==17)f=3;c[d+44>>2]=f;break}if((f|0)==1)c[d+32>>2]=1}while(0);return}function Ci(b){b=b|0;var d=0;c[b>>2]=4816;d=c[b+144>>2]|0;if(d|0){if(a[b+148>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+144>>2]=0}a[b+148>>0]=1;c[b+144>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;d=c[b+76>>2]|0;if(d|0){if(a[b+80>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;d=c[b+56>>2]|0;if(d|0){if(a[b+60>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;d=c[b+36>>2]|0;if(d|0){if(a[b+40>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}if(a[b+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;b=b+12|0;c[b>>2]=0;return}function Di(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;o=(+g[a+32>>2]-+g[a+16>>2])*+g[a+108>>2]*.5;m=(+g[a+36>>2]-+g[a+20>>2])*+g[a+112>>2]*.5;k=(+g[a+40>>2]-+g[a+24>>2])*+g[a+116>>2]*.5;t=+N(+(+g[b>>2]));s=+N(+(+g[b+4>>2]));r=+N(+(+g[b+8>>2]));n=+N(+(+g[b+16>>2]));l=+N(+(+g[b+20>>2]));j=+N(+(+g[b+24>>2]));w=+N(+(+g[b+32>>2]));v=+N(+(+g[b+36>>2]));f=+N(+(+g[b+40>>2]));u=+g[b+48>>2];p=+g[b+52>>2];h=+g[b+56>>2];q=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);i=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);f=o*w+m*v+k*f+ +Sb[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=u-(o*t+m*s+k*r+q);g[d+4>>2]=p-(o*n+m*l+k*j+i);g[d+8>>2]=h-f;g[d+12>>2]=0.0;g[e>>2]=u+(o*t+m*s+k*r+q);g[e+4>>2]=p+(o*n+m*l+k*j+i);g[e+8>>2]=h+f;g[e+12>>2]=0.0;return}function Ei(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0;c[6435]=(c[6435]|0)+1;e=yc(379)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e+4>>2]=3;c[e>>2]=4432;c[e+8>>2]=-1;c[e+12>>2]=-1;g[e+16>>2]=3402823466385288598117041.0e14;a[e+20>>0]=1;a[e+21>>0]=0;c[e+24>>2]=-1;c[e+28>>2]=b;Il();c[e+32>>2]=23268;g[e+36>>2]=0.0;g[e+40>>2]=.30000001192092896;c[e+44>>2]=0;c[e>>2]=4544;l=e+300|0;c[l>>2]=c[d>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];k=+g[d>>2];j=+g[d+4>>2];i=+g[d+8>>2];h=k*+g[b+20>>2]+j*+g[b+24>>2]+i*+g[b+28>>2]+ +g[b+56>>2];f=k*+g[b+36>>2]+j*+g[b+40>>2]+i*+g[b+44>>2]+ +g[b+60>>2];g[e+316>>2]=k*+g[b+4>>2]+j*+g[b+8>>2]+i*+g[b+12>>2]+ +g[b+52>>2];g[e+320>>2]=h;g[e+324>>2]=f;g[e+328>>2]=0.0;c[e+332>>2]=0;a[e+344>>0]=0;g[e+348>>2]=.30000001192092896;g[e+352>>2]=1.0;g[e+356>>2]=0.0;return e|0}function Fi(b,d,e){b=+b;d=d|0;e=e|0;var f=0,h=0;while(1){f=yc(140)|0;if(f|0){h=6;break}f=c[6564]|0;c[6564]=f+0;if(!f){h=5;break}jc[f&3]()}if((h|0)==5){e=Ya(4)|0;c[e>>2]=9640;pb(e|0,2800,251)}else if((h|0)==6){g[f>>2]=b;c[f+4>>2]=d;c[f+72>>2]=e;c[f+76>>2]=0;c[f+76+4>>2]=0;c[f+76+8>>2]=0;c[f+76+12>>2]=0;c[f+76+16>>2]=0;c[f+76+20>>2]=0;g[f+100>>2]=.5;g[f+104>>2]=0.0;g[f+108>>2]=0.0;g[f+112>>2]=.800000011920929;g[f+116>>2]=1.0;a[f+120>>0]=0;g[f+124>>2]=.004999999888241291;g[f+128>>2]=.009999999776482582;g[f+132>>2]=.009999999776482582;g[f+136>>2]=.009999999776482582;c[f+8>>2]=1065353216;c[f+12>>2]=0;c[f+12+4>>2]=0;c[f+12+8>>2]=0;c[f+12+12>>2]=0;c[f+28>>2]=1065353216;c[f+32>>2]=0;c[f+32+4>>2]=0;c[f+32+8>>2]=0;c[f+32+12>>2]=0;c[f+48>>2]=1065353216;c[f+52>>2]=0;c[f+52+4>>2]=0;c[f+52+8>>2]=0;c[f+52+12>>2]=0;c[f+52+16>>2]=0;return f|0}return 0}function Gi(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;e=c[b>>2]|0;if((e|0)==(c[a+80>>2]|0)){f=1.0;return +f}if(c[e+204>>2]&4|0){f=1.0;return +f}if((+g[a+28>>2]-+g[a+12>>2])*+g[b+8>>2]+(+g[a+32>>2]-+g[a+16>>2])*+g[b+12>>2]+(+g[a+36>>2]-+g[a+20>>2])*+g[b+16>>2]>=-+g[a+84>>2]){f=1.0;return +f}c[a+4>>2]=c[b+40>>2];c[a+76>>2]=e;if(d){c[a+44>>2]=c[b+8>>2];c[a+44+4>>2]=c[b+8+4>>2];c[a+44+8>>2]=c[b+8+8>>2];c[a+44+12>>2]=c[b+8+12>>2]}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=k*+g[e+20>>2]+j*+g[e+24>>2]+i*+g[e+28>>2];f=k*+g[e+36>>2]+j*+g[e+40>>2]+i*+g[e+44>>2];g[a+44>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+48>>2]=h;g[a+52>>2]=f;g[a+56>>2]=0.0}c[a+60>>2]=c[b+24>>2];c[a+60+4>>2]=c[b+24+4>>2];c[a+60+8>>2]=c[b+24+8>>2];c[a+60+12>>2]=c[b+24+12>>2];k=+g[b+40>>2];return +k}function Hi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0;j=i;i=i+80|0;if((e|0)>0)f=0;else{i=j;return}do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));f=j+32+4|0;h=0;do{k=b+(h<<4)|0;c[j+32>>2]=7824;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;g[j+32+20>>2]=-999999984306749440.0;c[j+32+24>>2]=c[k>>2];c[j+32+24+4>>2]=c[k+4>>2];c[j+32+24+8>>2]=c[k+8>>2];c[j+32+24+12>>2]=c[k+12>>2];c[j+16>>2]=1566444395;c[j+16+4>>2]=1566444395;c[j+16+8>>2]=1566444395;g[j+16+12>>2]=0.0;k=c[a+92>>2]|0;l=c[(c[k>>2]|0)+8>>2]|0;g[j>>2]=-999999984306749440.0;g[j+4>>2]=-999999984306749440.0;g[j+8>>2]=-999999984306749440.0;g[j+12>>2]=0.0;mc[l&127](k,j+32|0,j,j+16|0);k=d+(h<<4)|0;c[k>>2]=c[f>>2];c[k+4>>2]=c[f+4>>2];c[k+8>>2]=c[f+8>>2];c[k+12>>2]=c[f+12>>2];h=h+1|0}while((h|0)<(e|0));i=j;return}function Ii(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;f=c[b+96>>2]|0;if((f|0)==(c[b+100>>2]|0)?(i=f|0?f<<1:1,(f|0)<(i|0)):0){if(!i)h=0;else{c[6435]=(c[6435]|0)+1;f=yc((i<<4|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}h=f;f=c[b+96>>2]|0}if((f|0)>0){g=0;do{j=h+(g<<4)|0;k=(c[b+104>>2]|0)+(g<<4)|0;c[j>>2]=c[k>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];g=g+1|0}while((g|0)!=(f|0))}f=c[b+104>>2]|0;if(f|0){if(a[b+108>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+104>>2]=0}a[b+108>>0]=1;c[b+104>>2]=h;c[b+100>>2]=i;f=c[b+96>>2]|0}k=(c[b+104>>2]|0)+(f<<4)|0;c[k>>2]=c[d>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];c[b+96>>2]=(c[b+96>>2]|0)+1;if(!e)return;vj(b);return}function Ji(b){b=b|0;var d=0,e=0,f=0,h=0;c[b+32>>2]=262144;h=c[b+4>>2]|0;if((h|0)<2383){if((c[b+8>>2]|0)<2383){c[6435]=(c[6435]|0)+1;d=yc(9551)|0;if(!d)f=0;else{c[(d+4+15&-16)+-4>>2]=d;f=d+4+15&-16}d=c[b+4>>2]|0;if((d|0)>0){e=0;do{c[f+(e<<2)>>2]=c[(c[b+12>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(d|0))}d=c[b+12>>2]|0;if(d|0){if(a[b+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=f;c[b+8>>2]=2383;e=b+12|0}else e=b+12|0;d=h;do{c[(c[e>>2]|0)+(d<<2)>>2]=0;d=d+1|0}while((d|0)!=2383)}c[b+4>>2]=2383;e=0;do{h=(c[b+12>>2]|0)+(e<<2)|0;d=c[h>>2]|0;c[h>>2]=0;if(d|0)do{h=d;d=c[d+280>>2]|0;hd(h)}while((d|0)!=0);e=e+1|0}while((e|0)!=2383);g[b+20>>2]=.25;c[b+24>>2]=0;c[b+28>>2]=0;c[b+36>>2]=1;c[b+40>>2]=1;return}function Ki(){var b=0,d=0;c[6435]=(c[6435]|0)+1;b=yc(303)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}c[b+164>>2]=1065353216;c[b+168>>2]=1065353216;c[b+172>>2]=1065353216;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749440.0;d=b+188|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+240>>2]=0;g[b+244>>2]=1.0;d=b+248|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+4>>2]=1065353216;d=b+8|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+24>>2]=1065353216;d=b+28|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[b+44>>2]=1065353216;d=b+48|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[b>>2]=5044;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;c[b+236>>2]=4;return b|0}function Li(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0.0,r=0,s=0.0,t=0;if((e|0)>0)f=0;else return;do{g[d+(f<<4)+12>>2]=-999999984306749440.0;f=f+1|0}while((f|0)!=(e|0));p=0;do{h=+g[a+12>>2];i=+g[b+(p<<4)>>2]*h;j=+g[a+16>>2];k=+g[b+(p<<4)+4>>2]*j;l=+g[a+20>>2];m=+g[b+(p<<4)+8>>2]*l;f=c[a+96>>2]|0;if((f|0)>0){n=c[a+104>>2]|0;o=0;q=-3402823466385288598117041.0e14;r=-1;do{s=i*+g[n+(o<<4)>>2]+k*+g[n+(o<<4)+4>>2]+m*+g[n+(o<<4)+8>>2];t=s>q;r=t?o:r;q=t?s:q;o=o+1|0}while((o|0)!=(f|0));m=+g[n+(r<<4)+4>>2]*j;s=+g[n+(r<<4)+8>>2]*l;g[d+(p<<4)>>2]=+g[n+(r<<4)>>2]*h;g[d+(p<<4)+4>>2]=m;g[d+(p<<4)+8>>2]=s;g[d+(p<<4)+12>>2]=q}else g[d+(p<<4)+12>>2]=-999999984306749440.0;p=p+1|0}while((p|0)!=(e|0));return}function Mi(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+96|0;b=c[b>>2]|0;if((b|0)==(c[a+4>>2]|0)){i=d;return 1}e=c[a+12>>2]|0;if(!(Zb[c[(c[e>>2]|0)+8>>2]&31](e,c[b+188>>2]|0)|0)){i=d;return 1}e=c[a+4>>2]|0;f=c[e+192>>2]|0;c[d+64>>2]=0;c[d+64+4>>2]=f;c[d+64+8>>2]=e;c[d+64+12>>2]=e+4;c[d+64+16>>2]=-1;c[d+64+20>>2]=-1;e=c[b+192>>2]|0;c[d+40>>2]=0;c[d+40+4>>2]=e;c[d+40+8>>2]=b;c[d+40+12>>2]=b+4;c[d+40+16>>2]=-1;c[d+40+20>>2]=-1;b=c[(c[a+8>>2]|0)+24>>2]|0;b=Ib[c[(c[b>>2]|0)+8>>2]&31](b,d+64|0,d+40|0,0)|0;if(b|0){f=c[a+12>>2]|0;c[d+4>>2]=0;c[d+8>>2]=d+64;c[d+12>>2]=d+40;c[d>>2]=5976;c[d+32>>2]=f;yb[c[(c[b>>2]|0)+8>>2]&31](b,d+64|0,d+40|0,(c[a+8>>2]|0)+28|0,d);Ab[c[c[b>>2]>>2]&255](b);f=c[(c[a+8>>2]|0)+24>>2]|0;Cb[c[(c[f>>2]|0)+60>>2]&127](f,b)}i=d;return 1}function Ni(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0,j=0,k=0,l=0;l=i;i=i+80|0;h=c[c[a>>2]>>2]|0;j=c[c[a+4>>2]>>2]|0;if(!(Ob[c[(c[b>>2]|0)+24>>2]&63](b,h,j)|0)){i=l;return}f=c[h+192>>2]|0;c[l+56>>2]=0;c[l+56+4>>2]=f;c[l+56+8>>2]=h;c[l+56+12>>2]=h+4;c[l+56+16>>2]=-1;c[l+56+20>>2]=-1;f=c[j+192>>2]|0;c[l+32>>2]=0;c[l+32+4>>2]=f;c[l+32+8>>2]=j;c[l+32+12>>2]=j+4;c[l+32+16>>2]=-1;c[l+32+20>>2]=-1;f=c[a+8>>2]|0;if(!f){f=Ib[c[(c[b>>2]|0)+8>>2]&31](b,l+56|0,l+32|0,0)|0;c[a+8>>2]=f;if(f|0)k=4}else k=4;if((k|0)==4){c[l>>2]=5604;c[l+4>>2]=0;c[l+8>>2]=l+56;c[l+12>>2]=l+32;if((c[d+8>>2]|0)!=1){e=+Mb[c[(c[f>>2]|0)+12>>2]&15](f,h,j,d,l);if(+g[d+12>>2]>e)g[d+12>>2]=e}else yb[c[(c[f>>2]|0)+8>>2]&31](f,l+56|0,l+32|0,d,l)}i=l;return}function Oi(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;i=c[d+4>>2]|0;f=c[b+24>>2]|0;if((f|0)<(i|0)){if((c[b+28>>2]|0)<(i|0)){if(!i){e=0;g=f}else{c[6435]=(c[6435]|0)+1;e=yc((i<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g=c[b+24>>2]|0}if((g|0)>0){h=0;do{c[e+(h<<2)>>2]=c[(c[b+32>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0))}g=c[b+32>>2]|0;if(g|0){if(a[b+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=e;c[b+28>>2]=i;e=b+32|0}else e=b+32|0;do{c[(c[e>>2]|0)+(f<<2)>>2]=0;f=f+1|0}while((f|0)!=(i|0))}else e=b+32|0;c[b+24>>2]=i;e=c[e>>2]|0;if((i|0)<=0)return;f=0;do{c[e+(f<<2)>>2]=c[(c[d+12>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(i|0));return}function Pi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+488>>2]|0;a:do if((e|0)>0){g=c[b+496>>2]|0;f=0;while(1){if((c[g+(f<<2)>>2]|0)==(d|0))break;f=f+1|0;if((f|0)>=(e|0))break a}if((f|0)!=(e|0)){b=b+256|0;c[b>>2]=1;return}}while(0);if((e|0)==(c[b+492>>2]|0)?(h=e|0?e<<1:1,(e|0)<(h|0)):0){if(!h)g=0;else{c[6435]=(c[6435]|0)+1;e=yc((h<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g=e;e=c[b+488>>2]|0}if((e|0)>0){f=0;do{c[g+(f<<2)>>2]=c[(c[b+496>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}f=c[b+496>>2]|0;if(f){if(a[b+500>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0);e=c[b+488>>2]|0}c[b+496>>2]=0}a[b+500>>0]=1;c[b+496>>2]=g;c[b+492>>2]=h}c[(c[b+496>>2]|0)+(e<<2)>>2]=d;c[b+488>>2]=e+1;b=b+256|0;c[b>>2]=1;return}function Qi(a,b,c,d,e,f,h,i,j,k,l){a=a|0;b=b|0;c=+c;d=+d;e=+e;f=+f;h=+h;i=+i;j=j|0;k=k|0;l=+l;var m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;x=+g[a>>2]*f+ +g[a+16>>2]*h+ +g[a+32>>2]*i;v=+g[a+4>>2]*f+ +g[a+20>>2]*h+ +g[a+36>>2]*i;t=+g[a+8>>2]*f+ +g[a+24>>2]*h+ +g[a+40>>2]*i;s=+g[b>>2]*f+ +g[b+16>>2]*h+ +g[b+32>>2]*i;q=+g[b+4>>2]*f+ +g[b+20>>2]*h+ +g[b+36>>2]*i;o=+g[b+8>>2]*f+ +g[b+24>>2]*h+ +g[b+40>>2]*i;w=+g[j+80>>2];u=+g[j+84>>2];p=+g[j+88>>2];r=+g[k+80>>2];m=+g[k+84>>2];n=+g[k+88>>2];p=x*(x<0.0?-w:w)+v*(v<0.0?-u:u)+t*(t<0.0?-p:p);n=s*(s<0.0?-r:r)+q*(q<0.0?-m:m)+o*(o<0.0?-n:n);o=+g[j+96>>2];m=+g[k+96>>2];m=(p>o?p:o)+(n>m?n:m);return !((c*f+d*h+e*i+m<m-(c*f+d*h+e*i)?c*f+d*h+e*i+m:m-(c*f+d*h+e*i))>l)|0}function Ri(b){b=b|0;var d=0,e=0,f=0,g=0;c[b>>2]=8724;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+24>>2]=0;a[b+28>>0]=0;a[b+48>>0]=1;c[b+44>>2]=0;c[b+36>>2]=0;c[b+40>>2]=0;a[b+68>>0]=1;c[b+64>>2]=0;c[b+56>>2]=0;c[b+60>>2]=0;c[b+72>>2]=0;c[6435]=(c[6435]|0)+1;d=yc(51)|0;if(!d)f=0;else{c[(d+4+15&-16)+-4>>2]=d;f=d+4+15&-16}d=c[b+8>>2]|0;if((d|0)>0){e=0;do{g=c[b+16>>2]|0;c[f+(e<<4)>>2]=c[g+(e<<4)>>2];c[f+(e<<4)+4>>2]=c[g+(e<<4)+4>>2];c[f+(e<<4)+8>>2]=c[g+(e<<4)+8>>2];c[f+(e<<4)+12>>2]=c[g+(e<<4)+12>>2];e=e+1|0}while((e|0)!=(d|0))}d=c[b+16>>2]|0;if(!d){a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=2;Hf(b);return}if(a[b+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+16>>2]=0;a[b+20>>0]=1;c[b+16>>2]=f;c[b+12>>2]=2;Hf(b);return}function Si(a,b,d){a=a|0;b=b|0;d=d|0;do if(!((b|0)==32&(d|0)==32)){if((b|0)==32){if((d|0)<20){b=a+96|0;break}if((d+-21|0)>>>0<9){b=a+104|0;break}}else{if((b|0)<20&(d|0)==32){b=a+100|0;break}if((b+-21|0)>>>0<9&(d|0)==32){b=a+108|0;break}if((b|0)==8&(d|0)==8){b=a+60|0;break}if((b|0)==8&(d|0)==1){b=a+76|0;break}if((b|0)==1&(d|0)==8){b=a+80|0;break}}if(!(d|b)){b=a+72|0;break}if((b|0)<20&(d|0)==28){b=a+88|0;break}if((b|0)==28&(d|0)<20){b=a+84|0;break}if((b|0)<20){if((d|0)<20){b=a+32|0;break}if((d+-21|0)>>>0<9){b=a+36|0;break}}else{if((d|0)<20&(b+-21|0)>>>0<9){b=a+40|0;break}if((b|0)==31)if((d|0)==31){b=a+48|0;break}else{b=a+44|0;break}}if((d|0)==31){b=a+52|0;break}else{b=a+56|0;break}}else b=a+92|0;while(0);return c[b>>2]|0}function Ti(a,b,d,e,f,h,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0;o=i;i=i+16|0;li(12899);Xb[c[(c[a>>2]|0)+32>>2]&1](a,b,d,e,f,h,j,k,l);n=c[a+184>>2]|0;m=c[k+20>>2]|0;m=(n|0)>(m|0)?n:m;if((m|0)>0){n=0;do{+$b[c[(c[a>>2]|0)+40>>2]&3](a,n,b,d,e,f,h,j,k,l);n=n+1|0}while((n|0)<(m|0))}m=c[2357]|0;a=(c[m+16>>2]|0)+-1|0;c[m+16>>2]=a;if(a|0){i=o;return 0.0}do if(c[m+4>>2]|0){tb(o|0,0)|0;a=c[6434]|0;g[m+8>>2]=+g[m+8>>2]+ +(((c[o+4>>2]|0)-(c[a+4>>2]|0)+(((c[o>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[m+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[m+16>>2]|0)){m=c[2357]|0;break}else{i=o;return 0.0}}while(0);c[2357]=c[m+20>>2];i=o;return 0.0}function Ui(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;g=c[d>>2]|0;d=c[b+268>>2]|0;a:do if((d|0)>0){f=c[b+276>>2]|0;e=0;while(1){if((c[f+(e<<2)>>2]|0)==(g|0))break;e=e+1|0;if((e|0)>=(d|0))break a}if((e|0)!=(d|0))return}while(0);if((d|0)==(c[b+272>>2]|0)?(h=d|0?d<<1:1,(d|0)<(h|0)):0){if(!h)f=0;else{c[6435]=(c[6435]|0)+1;d=yc((h<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f=d;d=c[b+268>>2]|0}if((d|0)>0){e=0;do{c[f+(e<<2)>>2]=c[(c[b+276>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(d|0))}e=c[b+276>>2]|0;if(e){if(a[b+280>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);d=c[b+268>>2]|0}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=f;c[b+272>>2]=h}c[(c[b+276>>2]|0)+(d<<2)>>2]=g;c[b+268>>2]=d+1;return}function Vi(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;f=c[a+232>>2]|0;a:do if((f|0)>0){g=c[a+240>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0))break a}if((d|0)<(f|0)){c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+240>>2]|0)+(f+-1<<2)>>2]=b;c[a+232>>2]=f+-1}}while(0);d=c[b+188>>2]|0;if(d|0){g=c[a+68>>2]|0;g=Eb[c[(c[g>>2]|0)+36>>2]&127](g)|0;ic[c[(c[g>>2]|0)+40>>2]&127](g,d,c[a+24>>2]|0);g=c[a+68>>2]|0;ic[c[(c[g>>2]|0)+12>>2]&127](g,d,c[a+24>>2]|0);c[b+188>>2]=0}f=c[a+8>>2]|0;if((f|0)<=0)return;g=c[a+16>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0)){h=15;break}}if((h|0)==15)return;if((d|0)>=(f|0))return;c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+16>>2]|0)+(f+-1<<2)>>2]=b;c[a+8>>2]=f+-1;return}function Wi(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;f=c[a+328>>2]|0;a:do if((f|0)>0){g=c[a+336>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0))break a}if((d|0)<(f|0)){c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+336>>2]|0)+(f+-1<<2)>>2]=b;c[a+328>>2]=f+-1}}while(0);d=c[b+188>>2]|0;if(d|0){g=c[a+68>>2]|0;g=Eb[c[(c[g>>2]|0)+36>>2]&127](g)|0;ic[c[(c[g>>2]|0)+40>>2]&127](g,d,c[a+24>>2]|0);g=c[a+68>>2]|0;ic[c[(c[g>>2]|0)+12>>2]&127](g,d,c[a+24>>2]|0);c[b+188>>2]=0}f=c[a+8>>2]|0;if((f|0)<=0)return;g=c[a+16>>2]|0;d=0;while(1){e=g+(d<<2)|0;if((c[e>>2]|0)==(b|0))break;d=d+1|0;if((d|0)>=(f|0)){h=15;break}}if((h|0)==15)return;if((d|0)>=(f|0))return;c[e>>2]=c[g+(f+-1<<2)>>2];c[(c[a+16>>2]|0)+(f+-1<<2)>>2]=b;c[a+8>>2]=f+-1;return}function Xi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;i=c[d+4>>2]|0;e=c[b+872>>2]|0;a:do if((e|0)>(i|0))e=b+880|0;else{if((e|0)<(i|0)?(c[b+876>>2]|0)<(i|0):0){if((i|0)!=0?(c[6435]=(c[6435]|0)+1,f=yc((i<<2|3)+16|0)|0,(f|0)!=0):0){c[(f+4+15&-16)+-4>>2]=f;h=f+4+15&-16}else h=0;f=c[b+872>>2]|0;g=0;while(1){if((g|0)>=(f|0))break;c[h+(g<<2)>>2]=c[(c[b+880>>2]|0)+(g<<2)>>2];g=g+1|0}f=c[b+880>>2]|0;if(f|0){if(!((a[b+884>>0]&1)==0|(f|0)==0)){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+880>>2]=0}a[b+884>>0]=1;c[b+880>>2]=h;c[b+876>>2]=i}while(1){if((e|0)>=(i|0)){e=b+880|0;break a}c[(c[b+880>>2]|0)+(e<<2)>>2]=0;e=e+1|0}}while(0);c[b+872>>2]=i;e=c[e>>2]|0;f=0;while(1){if((f|0)>=(i|0))break;c[e+(f<<2)>>2]=c[(c[d+12>>2]|0)+(f<<2)>>2];f=f+1|0}return}function Yi(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;i=c[d+4>>2]|0;e=c[b+4>>2]|0;a:do if((e|0)>(i|0))e=b+12|0;else{if((e|0)<(i|0)?(c[b+8>>2]|0)<(i|0):0){if((i|0)!=0?(c[6435]=(c[6435]|0)+1,f=yc((i<<2|3)+16|0)|0,(f|0)!=0):0){c[(f+4+15&-16)+-4>>2]=f;h=f+4+15&-16}else h=0;f=c[b+4>>2]|0;g=0;while(1){if((g|0)>=(f|0))break;c[h+(g<<2)>>2]=c[(c[b+12>>2]|0)+(g<<2)>>2];g=g+1|0}f=c[b+12>>2]|0;if(f|0){if(!((a[b+16>>0]&1)==0|(f|0)==0)){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=h;c[b+8>>2]=i}while(1){if((e|0)>=(i|0)){e=b+12|0;break a}c[(c[b+12>>2]|0)+(e<<2)>>2]=0;e=e+1|0}}while(0);c[b+4>>2]=i;e=c[e>>2]|0;f=0;while(1){if((f|0)>=(i|0))break;c[e+(f<<2)>>2]=c[(c[d+12>>2]|0)+(f<<2)>>2];f=f+1|0}return}function Zi(b){b=b|0;var d=0,e=0;d=c[b+92>>2]|0;if(d|0){if(a[b+96>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+92>>2]=0}a[b+96>>0]=1;c[b+92>>2]=0;c[b+84>>2]=0;c[b+88>>2]=0;d=c[b+64>>2]|0;if(d|0)do{c[b+64>>2]=c[d+8>>2];e=c[d>>2]|0;if(e|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0);d=c[b+64>>2]|0}while((d|0)!=0);d=c[b+48>>2]|0;if(d|0)do{c[b+48>>2]=c[d+8>>2];e=c[d>>2]|0;if(e|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0);d=c[b+48>>2]|0}while((d|0)!=0);d=c[b+32>>2]|0;if(!d)return;do{c[b+32>>2]=c[d+8>>2];e=c[d>>2]|0;if(e|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0);d=c[b+32>>2]|0}while((d|0)!=0);return}function _i(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;h=c[d>>2]|0;h=Zb[c[(c[h>>2]|0)+56>>2]&31](h,28)|0;j=(a[b+4>>0]|0)==0;i=c[b+8>>2]|0;g=c[b+12>>2]|0;b=c[d>>2]|0;c[h+4>>2]=b;c[h>>2]=5480;a[h+8>>0]=0;c[h+12>>2]=0;if(j){a[h+16>>0]=0;c[h+20>>2]=i;c[h+24>>2]=g;if(!(Ob[c[(c[b>>2]|0)+24>>2]&63](b,c[e+8>>2]|0,c[f+8>>2]|0)|0))return h|0;j=c[h+4>>2]|0;c[h+12>>2]=Ob[c[(c[j>>2]|0)+12>>2]&63](j,c[e+8>>2]|0,c[f+8>>2]|0)|0;a[h+8>>0]=1;return h|0}else{a[h+16>>0]=1;c[h+20>>2]=i;c[h+24>>2]=g;if(!(Ob[c[(c[b>>2]|0)+24>>2]&63](b,c[f+8>>2]|0,c[e+8>>2]|0)|0))return h|0;j=c[h+4>>2]|0;c[h+12>>2]=Ob[c[(c[j>>2]|0)+12>>2]&63](j,c[f+8>>2]|0,c[e+8>>2]|0)|0;a[h+8>>0]=1;return h|0}return 0}function $i(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;c[a+4>>2]=c[b+40>>2];e=c[b>>2]|0;c[a+76>>2]=e;if(d){c[a+44>>2]=c[b+8>>2];c[a+44+4>>2]=c[b+8+4>>2];c[a+44+8>>2]=c[b+8+8>>2];c[a+44+12>>2]=c[b+8+12>>2];a=a+60|0;d=b+24|0;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];f=+g[b+40>>2];return +f}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=+g[e+20>>2]*k+ +g[e+24>>2]*j+ +g[e+28>>2]*i;f=+g[e+36>>2]*k+ +g[e+40>>2]*j+ +g[e+44>>2]*i;g[a+44>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+48>>2]=h;g[a+52>>2]=f;g[a+56>>2]=0.0;a=a+60|0;d=b+24|0;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];f=+g[b+40>>2];return +f}return 0.0}function aj(){var b=0,d=0;c[6435]=(c[6435]|0)+1;b=yc(791)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}c[b>>2]=1025;c[b+116>>2]=0;a[b+120>>0]=0;d=b+124|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+300>>2]=0;a[b+304>>0]=0;d=b+308|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+484>>2]=0;a[b+488>>0]=0;d=b+492|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+668>>2]=0;a[b+672>>0]=0;d=b+676|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;c[b+740>>2]=0;c[b+744>>2]=0;c[b+748>>2]=0;c[b+768>>2]=0;return b|0}function bj(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0,m=0;f=i;i=i+48|0;if((c[b+136>>2]|0)<=0){i=f;return}e=0;do{m=c[b+144>>2]|0;c[f+32>>2]=(a[m+(e*284|0)+84>>0]|0)==0?1065353216:0;c[f+32+4>>2]=0;c[f+32+8>>2]=1065353216;g[f+32+12>>2]=0.0;l=m+(e*284|0)+140|0;c[f+16>>2]=c[l>>2];c[f+16+4>>2]=c[l+4>>2];c[f+16+8>>2]=c[l+8>>2];c[f+16+12>>2]=c[l+12>>2];l=c[b+120>>2]|0;h=c[(c[d>>2]|0)+8>>2]|0;k=+g[m+(e*284|0)+108+(l<<2)>>2]+ +g[f+16+4>>2];j=+g[m+(e*284|0)+124+(l<<2)>>2]+ +g[f+16+8>>2];g[f>>2]=+g[m+(e*284|0)+92+(l<<2)>>2]+ +g[f+16>>2];g[f+4>>2]=k;g[f+8>>2]=j;g[f+12>>2]=0.0;mc[h&127](d,f+16|0,f,f+32|0);mc[c[(c[d>>2]|0)+8>>2]&127](d,f+16|0,(c[b+144>>2]|0)+(e*284|0)+16|0,f+32|0);e=e+1|0}while((e|0)<(c[b+136>>2]|0));i=f;return}function cj(d,e,f,g,h,i){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0;if((d|0)==(c[e+8>>2]|0))zl(e,f,g,h);else{l=b[e+52>>1]|0;j=c[d+12>>2]|0;a[e+52>>0]=0;a[e+53>>0]=0;On(d+16|0,e,f,g,h,i);a:do if((j|0)>1){m=d+24|0;do{if(a[e+54>>0]|0)break a;k=b[e+52>>1]|0;if(!((k&255)<<24>>24)){if((k&65535)>=256?(c[d+8>>2]&1|0)==0:0)break a}else{if((c[e+24>>2]|0)==1)break a;if(!(c[d+8>>2]&2))break a}a[e+52>>0]=0;a[e+53>>0]=0;On(m,e,f,g,h,i);m=m+8|0}while(m>>>0<(d+16+(j<<3)|0)>>>0)}while(0);a[e+52>>0]=l;a[e+53>>0]=(l&65535)>>>8}return}function dj(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;switch(b|0){case 2:{if((e|0)<1){g[a+232>>2]=d;c[a+300>>2]=c[a+300>>2]|512;return}if((e|0)<3){g[a+264>>2]=d;c[a+300>>2]=c[a+300>>2]|32;return}if((e|0)==3){g[a+248>>2]=d;c[a+300>>2]=c[a+300>>2]|2048;return}if((e|0)>=6)return;g[a+280>>2]=d;c[a+300>>2]=c[a+300>>2]|128;return}case 3:{if((e|0)<1){g[a+212>>2]=d;c[a+300>>2]=c[a+300>>2]|1;return}if((e|0)!=3)return;g[a+228>>2]=d;c[a+300>>2]=c[a+300>>2]|4;return}case 4:{if((e|0)<1){g[a+244>>2]=d;c[a+300>>2]=c[a+300>>2]|256;return}if((e|0)<3){g[a+276>>2]=d;c[a+300>>2]=c[a+300>>2]|16;return}if((e|0)==3){g[a+260>>2]=d;c[a+300>>2]=c[a+300>>2]|1024;return}if((e|0)>=6)return;g[a+292>>2]=d;c[a+300>>2]=c[a+300>>2]|64;return}default:return}}function ej(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;f=i;i=i+240|0;c[f+80>>2]=d;d=f+96|0;e=d+40|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(e|0));c[f+136>>2]=c[f+80>>2];if((Bc(0,b,f+136|0,f,f+96|0)|0)>=0){d=c[2359]|0;if((a[9510]|0)<1)c[2359]=d&-33;if(!(c[2371]|0)){e=c[2370]|0;c[2370]=f+152;c[2366]=f+152;c[2364]=f+152;c[2371]=80;c[2363]=f+152+80;Bc(9436,b,f+136|0,f,f+96|0)|0;if(e|0){Ob[c[9472>>2]&63](9436,0,0)|0;c[2370]=e;c[2371]=0;c[2363]=0;c[2366]=0;c[2364]=0}}else Bc(9436,b,f+136|0,f,f+96|0)|0;c[2359]=c[2359]|d&32}d=(a[9511]|0)==10;do if((c[2378]|0)<0){if(!d?(g=c[2364]|0,g>>>0<(c[2363]|0)>>>0):0){c[2364]=g+1;a[g>>0]=10;break}om(9436,10)|0}else{if(!d?(h=c[2364]|0,h>>>0<(c[2363]|0)>>>0):0){c[2364]=h+1;a[h>>0]=10;break}om(9436,10)|0}while(0);Va()}function fj(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0;e=i;i=i+96|0;c[e+32>>2]=1065353216;c[e+32+4>>2]=0;c[e+32+4+4>>2]=0;c[e+32+4+8>>2]=0;c[e+32+4+12>>2]=0;c[e+32+20>>2]=1065353216;c[e+32+24>>2]=0;c[e+32+24+4>>2]=0;c[e+32+24+8>>2]=0;c[e+32+24+12>>2]=0;c[e+32+40>>2]=1065353216;l=e+32+44|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;mc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);j=(+g[e>>2]-+g[e+16>>2])*.5;h=(+g[e+4>>2]-+g[e+16+4>>2])*.5;k=(+g[e+8>>2]-+g[e+16+8>>2])*.5;f=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);g[d>>2]=b*.0833333283662796*((h+f)*2.0*(h+f)*2.0+(k+f)*2.0*(k+f)*2.0);g[d+4>>2]=b*.0833333283662796*((j+f)*2.0*(j+f)*2.0+(k+f)*2.0*(k+f)*2.0);g[d+8>>2]=b*.0833333283662796*((j+f)*2.0*(j+f)*2.0+(h+f)*2.0*(h+f)*2.0);g[d+12>>2]=0.0;i=e;return}function gj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;d=+g[a+344>>2];if(!(d!=0.0))return;f=+g[a+348>>2];i=+g[a+352>>2];k=+g[a+356>>2];l=+g[b+4>>2]*i*d;h=+g[b+8>>2]*k*d;g[a+312>>2]=+g[a+312>>2]+ +g[b>>2]*f*d;g[a+316>>2]=+g[a+316>>2]+l;g[a+320>>2]=+g[a+320>>2]+h;f=+g[b>>2]*f;i=+g[b+4>>2]*i;k=+g[b+8>>2]*k;h=+g[c+4>>2];l=+g[c+8>>2];j=+g[c>>2];e=(+g[a+280>>2]*(h*k-l*i)+ +g[a+284>>2]*(l*f-j*k)+ +g[a+288>>2]*(j*i-h*f))*+g[a+548>>2];d=(+g[a+296>>2]*(h*k-l*i)+ +g[a+300>>2]*(l*f-j*k)+ +g[a+304>>2]*(j*i-h*f))*+g[a+552>>2];g[a+328>>2]=+g[a+328>>2]+(+g[a+264>>2]*(h*k-l*i)+ +g[a+268>>2]*(l*f-j*k)+ +g[a+272>>2]*(j*i-h*f))*+g[a+544>>2];g[a+332>>2]=+g[a+332>>2]+e;g[a+336>>2]=+g[a+336>>2]+d;return}function hj(a,b,d,e,f,h,j,k,l,m){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0;n=i;i=i+16|0;li(12859);+bc[c[(c[a>>2]|0)+44>>2]&3](a,b,d,e,f,h,j,k,l);+bc[c[(c[a>>2]|0)+48>>2]&3](a,b,d,e,f,h,j,k,l);+fc[c[(c[a>>2]|0)+36>>2]&1](a,b,d,k);m=c[2357]|0;a=(c[m+16>>2]|0)+-1|0;c[m+16>>2]=a;if(a|0){i=n;return 0.0}do if(c[m+4>>2]|0){tb(n|0,0)|0;a=c[6434]|0;g[m+8>>2]=+g[m+8>>2]+ +(((c[n+4>>2]|0)-(c[a+4>>2]|0)+(((c[n>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[m+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[m+16>>2]|0)){m=c[2357]|0;break}else{i=n;return 0.0}}while(0);c[2357]=c[m+20>>2];i=n;return 0.0}function ij(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=c[b+212>>2]|0;if((f|0)==(c[b+216>>2]|0)?(i=f|0?f<<1:1,(f|0)<(i|0)):0){if(!i)h=0;else{c[6435]=(c[6435]|0)+1;f=yc((i<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}h=f;f=c[b+212>>2]|0}if((f|0)>0){g=0;do{c[h+(g<<2)>>2]=c[(c[b+220>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[b+220>>2]|0;if(g){if(a[b+224>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0);f=c[b+212>>2]|0}c[b+220>>2]=0}a[b+224>>0]=1;c[b+220>>2]=h;c[b+216>>2]=i}c[(c[b+220>>2]|0)+(f<<2)>>2]=d;c[b+212>>2]=f+1;if(!e)return;Pi(c[d+28>>2]|0,d);Pi(c[d+32>>2]|0,d);return}function jj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;e=c[a+4>>2]|0;if(e|0)gj(e,b,d);e=c[a>>2]|0;if(!e)return;m=+g[b>>2];k=+g[e+128>>2];l=+g[b+4>>2];j=+g[b+8>>2];f=+g[d+4>>2];o=+g[d+8>>2];n=+g[d>>2];i=+g[e+180>>2]*(j*f-l*o)+ +g[e+184>>2]*(m*o-j*n)+(l*n-m*f)*+g[e+188>>2];h=(j*f-l*o)*+g[e+196>>2]+(m*o-j*n)*+g[e+200>>2]+(l*n-m*f)*+g[e+204>>2];f=(j*f-l*o)*+g[e+212>>2]+(m*o-j*n)*+g[e+216>>2]+(l*n-m*f)*+g[e+220>>2];g[e+276>>2]=m*k+ +g[e+276>>2];g[e+280>>2]=k*l+ +g[e+280>>2];g[e+284>>2]=k*j+ +g[e+284>>2];g[e+292>>2]=i+ +g[e+292>>2];g[e+296>>2]=h+ +g[e+296>>2];g[e+300>>2]=f+ +g[e+300>>2];c[e+312>>2]=(c[e+312>>2]|0)+1;return}function kj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;v=+g[a+552>>2];u=+g[a+568>>2];t=+g[a+584>>2];s=+g[b>>2];r=+g[b+4>>2];q=+g[b+8>>2];o=+g[b+16>>2];n=+g[b+20>>2];m=+g[b+24>>2];k=+g[b+32>>2];i=+g[b+36>>2];f=+g[b+40>>2];j=+g[a+556>>2];h=+g[a+572>>2];e=+g[a+588>>2];x=+g[a+620>>2];w=+g[a+636>>2];d=+g[a+652>>2];p=x*+g[c>>2]+w*+g[c+4>>2]+d*+g[c+8>>2];l=x*+g[c+16>>2]+w*+g[c+20>>2]+d*+g[c+24>>2];d=x*+g[c+32>>2]+w*+g[c+36>>2]+d*+g[c+40>>2];d=+W(+((v*s+u*r+t*q)*p+(v*o+u*n+t*m)*l+(v*k+u*i+t*f)*d),+((s*j+r*h+q*e)*p+(o*j+n*h+m*e)*l+(k*j+i*h+f*e)*d));return +(d*+g[a+732>>2])}function lj(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;a:do if((e|0)!=0&(b&3|0)!=0){f=e;while(1){if((a[b>>0]|0)==(d&255)<<24>>24)break a;b=b+1|0;e=f+-1|0;if((e|0)!=0&(b&3|0)!=0)f=e;else{f=e;e=(e|0)!=0;g=5;break}}}else{f=e;e=(e|0)!=0;g=5}while(0);b:do if((g|0)==5)if(e){if((a[b>>0]|0)!=(d&255)<<24>>24){e=_(d&255,16843009)|0;c:do if(f>>>0>3)while(1){h=c[b>>2]^e;if((h&-2139062144^-2139062144)&h+-16843009|0)break;b=b+4|0;f=f+-4|0;if(f>>>0<=3){g=11;break c}}else g=11;while(0);if((g|0)==11)if(!f){f=0;break}while(1){if((a[b>>0]|0)==(d&255)<<24>>24)break b;b=b+1|0;f=f+-1|0;if(!f){f=0;break}}}}else f=0;while(0);return (f|0?b:0)|0}function mj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=c[a+8>>2]|0;if((d|0)>0){f=0;do{e=c[(c[a+16>>2]|0)+(f<<2)>>2]|0;if(c[e+236>>2]&2){g=Eb[c[(c[e>>2]|0)+16>>2]&127](e)|0;g=Ob[c[(c[b>>2]|0)+16>>2]&63](b,g,1)|0;d=Ob[c[(c[e>>2]|0)+20>>2]&63](e,c[g+8>>2]|0,b)|0;yb[c[(c[b>>2]|0)+20>>2]&31](b,g,d,1497645650,e);d=c[a+8>>2]|0}f=f+1|0}while((f|0)<(d|0))}if((c[a+212>>2]|0)<=0)return;d=0;do{g=c[(c[a+220>>2]|0)+(d<<2)>>2]|0;e=Eb[c[(c[g>>2]|0)+36>>2]&127](g)|0;e=Ob[c[(c[b>>2]|0)+16>>2]&63](b,e,1)|0;f=Ob[c[(c[g>>2]|0)+40>>2]&63](g,c[e+8>>2]|0,b)|0;yb[c[(c[b>>2]|0)+20>>2]&31](b,e,f,1397641027,g);d=d+1|0}while((d|0)<(c[a+212>>2]|0));return}function nj(a){a=a|0;var b=0.0,d=0,e=0,f=0,h=0;e=i;i=i+32|0;c[a+32>>2]=1566444395;c[a+36>>2]=1566444395;c[a+40>>2]=1566444395;g[a+44>>2]=0.0;c[a+48>>2]=-581039253;c[a+52>>2]=-581039253;c[a+56>>2]=-581039253;g[a+60>>2]=0.0;if((c[a+16>>2]|0)<=0){i=e;return}d=0;do{f=c[a+24>>2]|0;h=c[f+(d*80|0)+64>>2]|0;mc[c[(c[h>>2]|0)+8>>2]&127](h,f+(d*80|0)|0,e+16|0,e);b=+g[e+16>>2];if(+g[a+32>>2]>b)g[a+32>>2]=b;b=+g[e>>2];if(+g[a+48>>2]<b)g[a+48>>2]=b;b=+g[e+16+4>>2];if(+g[a+36>>2]>b)g[a+36>>2]=b;b=+g[e+4>>2];if(+g[a+52>>2]<b)g[a+52>>2]=b;b=+g[e+16+8>>2];if(+g[a+40>>2]>b)g[a+40>>2]=b;b=+g[e+8>>2];if(+g[a+56>>2]<b)g[a+56>>2]=b;d=d+1|0}while((d|0)<(c[a+16>>2]|0));i=e;return}function oj(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0;e=i;i=i+96|0;j=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);c[e+32>>2]=1065353216;c[e+32+4>>2]=0;c[e+32+4+4>>2]=0;c[e+32+4+8>>2]=0;c[e+32+4+12>>2]=0;c[e+32+20>>2]=1065353216;c[e+32+24>>2]=0;c[e+32+24+4>>2]=0;c[e+32+24+8>>2]=0;c[e+32+24+12>>2]=0;c[e+32+40>>2]=1065353216;k=e+32+44|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;mc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);h=(j+(+g[e>>2]-+g[e+16>>2])*.5)*2.0;f=(j+(+g[e+4>>2]-+g[e+16+4>>2])*.5)*2.0;j=(j+(+g[e+8>>2]-+g[e+16+8>>2])*.5)*2.0;g[d>>2]=b*.0833333283662796*(f*f+j*j);g[d+4>>2]=b*.0833333283662796*(h*h+j*j);g[d+8>>2]=b*.0833333283662796*(h*h+f*f);g[d+12>>2]=0.0;i=e;return}function pj(b){b=b|0;var d=0;d=c[b+72>>2]|0;if(d|0){if(a[b+76>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+72>>2]=0}a[b+76>>0]=1;c[b+72>>2]=0;c[b+64>>2]=0;c[b+68>>2]=0;d=c[b+52>>2]|0;if(d|0){if(a[b+56>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;d=c[b+32>>2]|0;if(d|0){if(a[b+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;d=c[b+12>>2]|0;if(!d){a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;b=b+8|0;c[b>>2]=0;return}if(a[b+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+12>>2]=0;a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;b=b+8|0;c[b>>2]=0;return}function qj(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0.0,i=0.0,j=0.0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;e=c[a+732>>2]|0;if((e|0)<=0)return;a=c[a+740>>2]|0;d=0;do{n=c[a+(d*52|0)+8>>2]|0;f=c[a+(d*52|0)+12>>2]|0;s=+g[n+40>>2];q=+g[n+44>>2];i=+g[n+48>>2];k=a+(d*52|0)+36|0;r=+g[k>>2];m=a+(d*52|0)+40|0;p=+g[m>>2];l=a+(d*52|0)+44|0;o=+g[l>>2];j=-(+g[a+(d*52|0)+32>>2]*((s-+g[f+40>>2])*r+(q-+g[f+44>>2])*p+(i-+g[f+48>>2])*o)*b);h=+g[n+88>>2]*j;g[n+40>>2]=s+r*h;g[n+44>>2]=q+p*h;g[n+48>>2]=o*h+i;j=+g[f+88>>2]*j;i=j*+g[m>>2];h=j*+g[l>>2];g[f+40>>2]=+g[f+40>>2]-+g[k>>2]*j;g[f+44>>2]=+g[f+44>>2]-i;g[f+48>>2]=+g[f+48>>2]-h;d=d+1|0}while((d|0)!=(e|0));return}function rj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+12>>2]|0;if(!e)return;if(!(a[b+8>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=f|0?f<<1:1,(f|0)<(h|0)):0){if(!h)e=0;else{c[6435]=(c[6435]|0)+1;e=yc((h<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[d+4>>2]|0}if((f|0)>0){g=0;do{c[e+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=e;c[d+8>>2]=h;e=c[b+12>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function sj(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;g=c[b+328>>2]|0;if((g|0)==(c[b+332>>2]|0)?(j=g|0?g<<1:1,(g|0)<(j|0)):0){if(!j)i=0;else{c[6435]=(c[6435]|0)+1;g=yc((j<<2|3)+16|0)|0;if(!g)g=0;else{c[(g+4+15&-16)+-4>>2]=g;g=g+4+15&-16}i=g;g=c[b+328>>2]|0}if((g|0)>0){h=0;do{c[i+(h<<2)>>2]=c[(c[b+336>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(g|0))}h=c[b+336>>2]|0;if(h){if(a[b+340>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0);g=c[b+328>>2]|0}c[b+336>>2]=0}a[b+340>>0]=1;c[b+336>>2]=i;c[b+332>>2]=j}c[(c[b+336>>2]|0)+(g<<2)>>2]=d;c[b+328>>2]=g+1;c[d+284>>2]=c[b+452>>2];Pg(b,d,e,f);return}function tj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+20>>2]|0;if(!e)return;if(!(a[b+16>>0]|0))return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=f|0?f<<1:1,(f|0)<(h|0)):0){if(!h)e=0;else{c[6435]=(c[6435]|0)+1;e=yc((h<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[d+4>>2]|0}if((f|0)>0){g=0;do{c[e+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=e;c[d+8>>2]=h;e=c[b+20>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function uj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;j=+g[a+24>>2];k=+g[a+28>>2];i=+g[a+32>>2];f=j*+g[b>>2]+k*+g[b+4>>2]+i*+g[b+8>>2];h=+g[a+20>>2];if(f>h){g[a+20>>2]=f;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2]}else f=h;h=j*+g[b+16>>2]+k*+g[b+20>>2]+i*+g[b+24>>2];if(h>f){g[a+20>>2]=h;c[a+4>>2]=c[b+16>>2];c[a+4+4>>2]=c[b+16+4>>2];c[a+4+8>>2]=c[b+16+8>>2];c[a+4+12>>2]=c[b+16+12>>2]}else h=f;f=j*+g[b+32>>2]+k*+g[b+36>>2]+i*+g[b+40>>2];if(!(f>h))return;g[a+20>>2]=f;c[a+4>>2]=c[b+32>>2];c[a+4+4>>2]=c[b+32+4>>2];c[a+4+8>>2]=c[b+32+8>>2];c[a+4+12>>2]=c[b+32+12>>2];return}function vj(b){b=b|0;var d=0,e=0,f=0,h=0.0;e=i;i=i+96|0;a[b+88>>0]=1;if((a[22568]|0)==0?Wa(22568)|0:0){c[6139]=1065353216;c[6140]=0;c[6141]=0;c[6142]=0;c[6143]=0;c[6144]=1065353216;c[6145]=0;c[6146]=0;c[6147]=0;c[6148]=0;c[6149]=1065353216;g[6150]=0.0;c[6151]=-1082130432;c[6152]=0;c[6153]=0;c[6154]=0;c[6155]=0;c[6156]=-1082130432;c[6157]=0;c[6158]=0;c[6159]=0;c[6160]=0;c[6161]=-1082130432;g[6162]=0.0;_a(22568)}d=e;f=d+96|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));mc[c[(c[b>>2]|0)+76>>2]&127](b,24556,e,6);h=+g[b+44>>2];g[b+72>>2]=+g[e>>2]+h;g[b+56>>2]=+g[e+48>>2]-h;g[b+76>>2]=+g[e+20>>2]+h;g[b+60>>2]=+g[e+68>>2]-h;g[b+80>>2]=+g[e+40>>2]+h;g[b+64>>2]=+g[e+88>>2]-h;i=e;return}function wj(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0;j=i;i=i+64|0;h=c[d>>2]|0;g=d+(c[h+-8>>2]|0)|0;h=c[h+-4>>2]|0;c[j>>2]=e;c[j+4>>2]=d;c[j+8>>2]=2776;d=j+12|0;f=d+40|0;do{c[d>>2]=0;d=d+4|0}while((d|0)<(f|0));b[j+12+40>>1]=0;a[j+12+42>>0]=0;a:do if((h|0)==(e|0)){c[j+48>>2]=1;Qb[c[(c[e>>2]|0)+20>>2]&7](e,j,g,g,1,0);d=(c[j+24>>2]|0)==1?g:0}else{yb[c[(c[h>>2]|0)+24>>2]&31](h,j,g,1,0);switch(c[j+36>>2]|0){case 0:{d=((c[j+40>>2]|0)==1?(c[j+28>>2]|0)==1:0)&(c[j+32>>2]|0)==1?c[j+20>>2]|0:0;break a}case 1:break;default:{d=0;break a}}if((c[j+24>>2]|0)!=1?!(((c[j+40>>2]|0)==0?(c[j+28>>2]|0)==1:0)&(c[j+32>>2]|0)==1):0){d=0;break}d=c[j+16>>2]|0}while(0);i=j;return d|0}function xj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;j=+g[a+88>>2];k=+g[a+92>>2];i=+g[a+96>>2];f=j*+g[b>>2]+k*+g[b+4>>2]+i*+g[b+8>>2];h=+g[a+84>>2];if(f>h){g[a+84>>2]=f;c[a+4>>2]=c[b>>2];c[a+4+4>>2]=c[b+4>>2];c[a+4+8>>2]=c[b+8>>2];c[a+4+12>>2]=c[b+12>>2]}else f=h;h=j*+g[b+16>>2]+k*+g[b+20>>2]+i*+g[b+24>>2];if(h>f){g[a+84>>2]=h;c[a+4>>2]=c[b+16>>2];c[a+4+4>>2]=c[b+16+4>>2];c[a+4+8>>2]=c[b+16+8>>2];c[a+4+12>>2]=c[b+16+12>>2]}else h=f;f=j*+g[b+32>>2]+k*+g[b+36>>2]+i*+g[b+40>>2];if(!(f>h))return;g[a+84>>2]=f;c[a+4>>2]=c[b+32>>2];c[a+4+4>>2]=c[b+32+4>>2];c[a+4+8>>2]=c[b+32+8>>2];c[a+4+12>>2]=c[b+32+12>>2];return}function yj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;while(1){j=c[a+12>>2]|0;k=c[j+(((b+d|0)/2|0)<<3)>>2]|0;e=b;f=d;while(1){while(1){h=e+1|0;if((c[j+(e<<3)>>2]|0)<(k|0))e=h;else{i=f;break}}while(1){g=j+(i<<3)|0;f=i+-1|0;if((k|0)<(c[g>>2]|0))i=f;else break}if((e|0)>(i|0))f=i;else{e=j+(e<<3)|0;l=c[e>>2]|0;j=c[e+4>>2]|0;m=c[g+4>>2]|0;c[e>>2]=c[g>>2];c[e+4>>2]=m;e=(c[a+12>>2]|0)+(i<<3)|0;c[e>>2]=l;c[e+4>>2]=j;e=h}if((e|0)>(f|0))break;j=c[a+12>>2]|0}if((f|0)>(b|0))yj(a,b,f);if((e|0)<(d|0))b=e;else break}return}function zj(a,b,e){a=a|0;b=b|0;e=e|0;kh(a,b,e)|0;c[b+276>>2]=c[a+1316>>2];c[b+324>>2]=c[a+1364>>2];c[b+252>>2]=d[a+1309>>0];c[b+300>>2]=c[a+1340>>2];c[b+280>>2]=c[a+1320>>2];c[b+328>>2]=c[a+1368>>2];c[b+256>>2]=d[a+1310>>0];c[b+304>>2]=c[a+1344>>2];c[b+284>>2]=c[a+1324>>2];c[b+332>>2]=c[a+1372>>2];c[b+260>>2]=d[a+1311>>0];c[b+308>>2]=c[a+1348>>2];c[b+288>>2]=c[a+1328>>2];c[b+336>>2]=c[a+1376>>2];c[b+264>>2]=d[a+1312>>0];c[b+312>>2]=c[a+1352>>2];c[b+292>>2]=c[a+1332>>2];c[b+340>>2]=c[a+1380>>2];c[b+268>>2]=d[a+1313>>0];c[b+316>>2]=c[a+1356>>2];c[b+296>>2]=c[a+1336>>2];c[b+344>>2]=c[a+1384>>2];c[b+272>>2]=d[a+1314>>0];c[b+320>>2]=c[a+1360>>2];return 12539}function Aj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;i=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);m=i+ +g[a+28>>2];k=i+ +g[a+32>>2];i=i+ +g[a+36>>2];u=+N(+(+g[b>>2]));t=+N(+(+g[b+4>>2]));s=+N(+(+g[b+8>>2]));q=+N(+(+g[b+16>>2]));p=+N(+(+g[b+20>>2]));o=+N(+(+g[b+24>>2]));l=+N(+(+g[b+32>>2]));j=+N(+(+g[b+36>>2]));h=+N(+(+g[b+40>>2]));r=+g[b+48>>2];n=+g[b+52>>2];f=+g[b+56>>2];g[d>>2]=r-(m*u+k*t+i*s);g[d+4>>2]=n-(m*q+k*p+i*o);g[d+8>>2]=f-(m*l+k*j+i*h);g[d+12>>2]=0.0;g[e>>2]=m*u+k*t+i*s+r;g[e+4>>2]=m*q+k*p+i*o+n;g[e+8>>2]=m*l+k*j+i*h+f;g[e+12>>2]=0.0;return}function Bj(a,c,d,e,f,h){a=a|0;c=c|0;d=+d;e=+e;f=+f;h=h|0;var i=0,j=0;d=(d-+g[a+8>>2])*+g[a+40>>2];e=(e-+g[a+12>>2])*+g[a+44>>2];f=(f-+g[a+16>>2])*+g[a+48>>2];do if(!(d<=0.0)){i=b[a+6>>1]|0;j=b[a+4>>1]|0;if(!(d>=+(i&65535))){i=j&(~~d&65535)&65535|h;break}else{i=j&i&65535|h;break}}else i=h;while(0);b[c>>1]=i;do if(!(e<=0.0)){i=b[a+6>>1]|0;j=b[a+4>>1]|0;if(!(e>=+(i&65535))){i=j&(~~e&65535)&65535|h;break}else{i=j&i&65535|h;break}}else i=h;while(0);b[c+2>>1]=i;if(f<=0.0){h=h&65535;c=c+4|0;b[c>>1]=h;return}j=b[a+6>>1]|0;i=b[a+4>>1]|0;if(!(f>=+(j&65535))){h=i&(~~f&65535)&65535|h;h=h&65535;c=c+4|0;b[c>>1]=h;return}else{h=i&j&65535|h;h=h&65535;c=c+4|0;b[c>>1]=h;return}}function Cj(b){b=b|0;var d=0;c[b>>2]=8520;if(c[b+108>>2]|0){d=c[b+112>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+112>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+108>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+108>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}}d=c[b+88>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+84>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+80>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+60>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}if(!(a[b+100>>0]|0))return;d=c[b+92>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+92>>2]|0;if(!d)return;c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0);return}function Dj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[b+76>>2]|0;if(!e)return;f=c[d+4>>2]|0;if((f|0)==(c[d+8>>2]|0)?(h=f|0?f<<1:1,(f|0)<(h|0)):0){if(!h)e=0;else{c[6435]=(c[6435]|0)+1;e=yc((h<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[d+4>>2]|0}if((f|0)>0){g=0;do{c[e+(g<<2)>>2]=c[(c[d+12>>2]|0)+(g<<2)>>2];g=g+1|0}while((g|0)!=(f|0))}g=c[d+12>>2]|0;if(g){if(a[d+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0);f=c[d+4>>2]|0}c[d+12>>2]=0}a[d+16>>0]=1;c[d+12>>2]=e;c[d+8>>2]=h;e=c[b+76>>2]|0}c[(c[d+12>>2]|0)+(f<<2)>>2]=e;c[d+4>>2]=f+1;return}function Ej(a,b,d,e){a=a|0;b=b|0;d=+d;e=+e;var f=0,h=0.0,i=0.0,j=0.0,l=0,m=0.0,n=0.0,o=0.0;j=+Q(+d);i=+R(+d);f=c[b+444>>2]|0;l=+N(+j)>1.1920928955078125e-07;d=(c[k>>2]=f,+g[k>>2]);if(l){m=+g[b+448>>2];m=+O(+((i*i/(j*j)+1.0)/(1.0/(m*m)+i*i/(j*j)/(d*d))));d=i*i;h=j*j;f=(g[k>>2]=m,c[k>>2]|0)}else{d=i*i;h=j*j}m=+O(+(h+0.0+d));n=(c[k>>2]=f,+g[k>>2])*.5;m=+R(+n)/m;n=+Q(+n);o=n*e+j*m*0.0-i*m*-0.0;h=n*0.0-i*m*e-m*0.0*0.0;d=n*0.0+m*0.0*0.0-j*m*e;e=-(m*0.0*e)-j*m*0.0-i*m*-0.0;g[a>>2]=i*m*h+(n*o+e*-(m*0.0))-d*-(j*m);g[a+4>>2]=d*-(m*0.0)+(n*h+e*-(j*m))-i*m*o;g[a+8>>2]=o*-(j*m)+(i*m*e+n*d)-h*-(m*0.0);g[a+12>>2]=0.0;return}function Fj(a,d,f,h){a=a|0;d=d|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0,m=0;i=c[a+108>>2]|0;if(i|0){mc[c[(c[i>>2]|0)+28>>2]&127](i,d,f,h);return}i=b[a+56>>1]|0;if((i&65535)<<1>>>0<=1)return;k=1;m=1;do{j=c[a+68>>2]|0;if(b[j+(k<<2)>>1]&1){l=c[a+60>>2]|0;k=e[j+(k<<2)+2>>1]|0;if(!(+g[d>>2]>+g[l+(k<<6)+32>>2])?!(+g[f>>2]<+g[l+(k<<6)+16>>2]):0)j=1;else j=0;if(!(!(+g[d+8>>2]>+g[l+(k<<6)+40>>2])?!(+g[f+8>>2]<+g[l+(k<<6)+24>>2]):0))j=0;if(!(+g[d+4>>2]>+g[l+(k<<6)+36>>2])?!(+g[f+4>>2]<+g[l+(k<<6)+20>>2]|j^1):0){Zb[c[(c[h>>2]|0)+8>>2]&31](h,l+(k<<6)|0)|0;i=b[a+56>>1]|0}}m=m+1<<16>>16;k=m&65535}while(k>>>0<((i&65535)<<1|1)>>>0);return}function Gj(a,b,d){a=a|0;b=+b;d=+d;var e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0;f=c[a+732>>2]|0;if((f|0)<=0)return;a=c[a+740>>2]|0;e=0;do{d=+g[a+(e*52|0)+24>>2];if(d>0.0?(p=c[a+(e*52|0)+8>>2]|0,h=c[a+(e*52|0)+12>>2]|0,i=+g[p+8>>2],j=+g[h+8>>2]-i,k=+g[p+12>>2],l=+g[h+12>>2]-k,m=+g[p+16>>2],n=+g[h+16>>2]-m,o=+g[a+(e*52|0)+28>>2],o+(j*j+l*l+n*n)>1.1920928955078125e-07):0){d=(o-(j*j+l*l+n*n))/(d*(o+(j*j+l*l+n*n)))*b;q=d*+g[p+88>>2];g[p+8>>2]=i-j*q;g[p+12>>2]=k-l*q;g[p+16>>2]=m-n*q;d=d*+g[h+88>>2];g[h+8>>2]=+g[h+8>>2]+j*d;g[h+12>>2]=l*d+ +g[h+12>>2];g[h+16>>2]=n*d+ +g[h+16>>2]}e=e+1|0}while((e|0)!=(f|0));return}function Hj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0;e=i;i=i+96|0;c[e+32>>2]=1065353216;c[e+32+4>>2]=0;c[e+32+4+4>>2]=0;c[e+32+4+8>>2]=0;c[e+32+4+12>>2]=0;c[e+32+20>>2]=1065353216;c[e+32+24>>2]=0;c[e+32+24+4>>2]=0;c[e+32+24+8>>2]=0;c[e+32+24+12>>2]=0;c[e+32+40>>2]=1065353216;n=e+32+44|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;mc[c[(c[a>>2]|0)+8>>2]&127](a,e+32|0,e+16|0,e);l=+g[e>>2];m=+g[e+16>>2];j=+g[e+4>>2];k=+g[e+16+4>>2];f=+g[e+8>>2];h=+g[e+16+8>>2];g[d>>2]=+O(+((l-m)*(l-m)+(j-k)*(j-k)+(f-h)*(f-h)))*.5;g[b>>2]=(m+l)*.5;g[b+4>>2]=(k+j)*.5;g[b+8>>2]=(h+f)*.5;g[b+12>>2]=0.0;i=e;return}function Ij(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;c[a+4>>2]=c[b+24>>2];e=c[b>>2]|0;c[a+8>>2]=e;if(d){c[a+52>>2]=c[b+8>>2];c[a+52+4>>2]=c[b+8+4>>2];c[a+52+8>>2]=c[b+8+8>>2];c[a+52+12>>2]=c[b+8+12>>2]}else{k=+g[b+8>>2];j=+g[b+12>>2];i=+g[b+16>>2];h=+g[e+20>>2]*k+ +g[e+24>>2]*j+ +g[e+28>>2]*i;f=+g[e+36>>2]*k+ +g[e+40>>2]*j+ +g[e+44>>2]*i;g[a+52>>2]=+g[e+4>>2]*k+ +g[e+8>>2]*j+ +g[e+12>>2]*i;g[a+56>>2]=h;g[a+60>>2]=f;g[a+64>>2]=0.0}k=+g[b+24>>2];g[a+68>>2]=(1.0-k)*+g[a+20>>2]+ +g[a+36>>2]*k;g[a+72>>2]=(1.0-k)*+g[a+24>>2]+ +g[a+40>>2]*k;g[a+76>>2]=(1.0-k)*+g[a+28>>2]+ +g[a+44>>2]*k;return +(+g[b+24>>2])}function Jj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0;f=+g[b>>2];h=+g[b+16>>2];j=f<h?f:h;i=+g[b+32>>2];if((j<i?j:i)>+g[a+24>>2])return;k=f>h?b:b+16|0;if(+g[(+g[k>>2]>i?k:b+32|0)>>2]<+g[a+8>>2])return;f=+g[b+8>>2];h=+g[b+24>>2];j=f<h?f:h;i=+g[b+40>>2];if((j<i?j:i)>+g[a+32>>2])return;k=f>h?b+8|0:b+24|0;if(+g[(+g[k>>2]>i?k:b+40|0)>>2]<+g[a+16>>2])return;f=+g[b+4>>2];h=+g[b+20>>2];j=f<h?f:h;i=+g[b+36>>2];if((j<i?j:i)>+g[a+28>>2])return;k=f>h?b+4|0:b+20|0;if(+g[(+g[k>>2]>i?k:b+36|0)>>2]<+g[a+12>>2])return;k=c[a+4>>2]|0;mc[c[(c[k>>2]|0)+8>>2]&127](k,b,d,e);return}function Kj(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0;h=i;i=i+16|0;g[b+32>>2]=f;c[b+8>>2]=c[d>>2];c[b+8+4>>2]=c[d+4>>2];c[b+8+8>>2]=c[d+8>>2];c[b+8+12>>2]=c[d+12>>2];j=+g[b+28>>2];l=+g[e+4>>2]-j*+g[d+4>>2];k=+g[e+8>>2]-j*+g[d+8>>2];g[h>>2]=+g[e>>2]-+g[d>>2]*j;g[h+4>>2]=l;g[h+8>>2]=k;g[h+12>>2]=0.0;f=+g[b+24>>2]+j+f;g[b+32>>2]=f;if(!(f<0.0)){b=b+4|0;b=c[b>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;hc[e&15](b,d,h,f);i=h;return}a[b+36>>0]=1;b=b+4|0;b=c[b>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;hc[e&15](b,d,h,f);i=h;return}function Lj(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=6228;d=c[b+8>>2]|0;e=c[d+8>>2]|0;if((e|0)>0){g=0;do{f=c[(c[d+16>>2]|0)+(g*12|0)+8>>2]|0;if(f|0){Ab[c[c[f>>2]>>2]&255](f);h=c[b+4>>2]|0;Cb[c[(c[h>>2]|0)+60>>2]&127](h,f)}g=g+1|0}while((g|0)!=(e|0));d=c[b+8>>2]|0}$h(d);d=c[b+8>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+8>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+24>>2]|0;if(!d){a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;h=b+20|0;c[h>>2]=0;return}if(a[b+28>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+24>>2]=0;a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;h=b+20|0;c[h>>2]=0;return}function Mj(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0;d=i;i=i+64|0;c[d+4>>2]=0;c[d+4+4>>2]=0;c[d+24>>2]=0;c[d+24+4>>2]=0;c[d+44>>2]=0;c[d+44+4>>2]=0;c[d+44+8>>2]=0;c[d+44+12>>2]=0;c[d+44+16>>2]=0;j=+g[b>>2];f=+g[b+4>>2];m=+g[b+8>>2];k=+g[b+12>>2];h=j*(2.0/(j*j+f*f+m*m+k*k));e=f*(2.0/(j*j+f*f+m*m+k*k));l=m*(2.0/(j*j+f*f+m*m+k*k));g[d>>2]=1.0-(f*e+m*l);g[d+4>>2]=j*e-k*l;g[d+8>>2]=j*l+k*e;g[d+12>>2]=0.0;g[d+16>>2]=j*e+k*l;g[d+20>>2]=1.0-(j*h+m*l);g[d+24>>2]=f*l-k*h;g[d+28>>2]=0.0;g[d+32>>2]=j*l-k*e;g[d+36>>2]=f*l+k*h;g[d+40>>2]=1.0-(j*h+f*e);g[d+44>>2]=0.0;Pd(a,d);i=d;return}function Nj(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;while(1){b=yc(152)|0;if(b|0){f=6;break}b=c[6564]|0;c[6564]=b+0;if(!b){f=5;break}jc[b&3]()}if((f|0)==5){e=Ya(4)|0;c[e>>2]=9640;pb(e|0,2800,251)}else if((f|0)==6){c[b>>2]=4816;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;c[b+100>>2]=e;g[b+104>>2]=0.0;a[b+148>>0]=1;c[b+144>>2]=0;c[b+136>>2]=0;c[b+140>>2]=0;c[b+116>>2]=d;c[b+120>>2]=0;c[b+124>>2]=2;c[b+128>>2]=1;g[b+112>>2]=0.0;g[b+108>>2]=0.0;return b|0}return 0}function Oj(){var b=0;c[6435]=(c[6435]|0)+1;b=yc(215)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}c[b>>2]=4756;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;a[b+40>>0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60>>0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;a[b+80>>0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;a[b+100>>0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;a[b+120>>0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;a[b+140>>0]=1;c[b+136>>2]=0;c[b+128>>2]=0;c[b+132>>2]=0;a[b+160>>0]=1;c[b+156>>2]=0;c[b+148>>2]=0;c[b+152>>2]=0;a[b+180>>0]=1;c[b+176>>2]=0;c[b+168>>2]=0;c[b+172>>2]=0;c[b+192>>2]=0;return b|0}function Pj(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if((c[d+60>>2]|0)==2){f=c[d+48>>2]|0;hh(b+64|0,f)|0;g=c[b+68>>2]|0;if(g|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0)}c[b+68>>2]=f;c[b+76>>2]=(c[b+76>>2]|0)+-1}else{f=c[d+48>>2]|0;hh(b+4|0,f)|0;g=c[b+8>>2]|0;if(g|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0)}c[b+8>>2]=f;c[b+16>>2]=(c[b+16>>2]|0)+-1}f=c[d+52>>2]|0;g=c[d+56>>2]|0;if(!f)c[b+124+(c[d+60>>2]<<2)>>2]=g;else c[f+56>>2]=g;f=c[d+56>>2]|0;if(f|0)c[f+52>>2]=c[d+52>>2];g=c[b+136>>2]|0;ic[c[(c[g>>2]|0)+16>>2]&127](g,d,e);c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0);a[b+194>>0]=1;return}function Qj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+96|0;g=c[b+192>>2]|0;c[f+64>>2]=0;c[f+64+4>>2]=g;c[f+64+8>>2]=b;c[f+64+12>>2]=b+4;c[f+64+16>>2]=-1;c[f+64+20>>2]=-1;b=c[d+192>>2]|0;c[f+40>>2]=0;c[f+40+4>>2]=b;c[f+40+8>>2]=d;c[f+40+12>>2]=d+4;c[f+40+16>>2]=-1;c[f+40+20>>2]=-1;b=c[a+24>>2]|0;b=Ib[c[(c[b>>2]|0)+8>>2]&31](b,f+64|0,f+40|0,0)|0;if(!b){i=f;return}c[f+4>>2]=0;c[f+8>>2]=f+64;c[f+12>>2]=f+40;c[f>>2]=5976;c[f+32>>2]=e;yb[c[(c[b>>2]|0)+8>>2]&31](b,f+64|0,f+40|0,a+28|0,f);Ab[c[c[b>>2]>>2]&255](b);g=c[a+24>>2]|0;Cb[c[(c[g>>2]|0)+60>>2]&127](g,b);i=f;return}function Rj(a,b,d){a=a|0;b=+b;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;e=+g[a+28>>2];i=+g[a+32>>2];h=+g[a+36>>2];j=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);f=+Sb[c[(c[a>>2]|0)+48>>2]&15](a);h=+Sb[c[(c[a>>2]|0)+48>>2]&15](a)+h;switch(c[a+52>>2]|0){case 0:{j=b*.25*(f+i)*(f+i)+b/12.0*(j+e)*(j+e)*4.0;g[d>>2]=b*.5*(f+i)*(f+i);g[d+4>>2]=j;g[d+8>>2]=j;g[d+12>>2]=0.0;return}case 2:{g[d>>2]=b*.25*(j+e)*(j+e)+b/12.0*h*h*4.0;g[d+4>>2]=b*.25*(j+e)*(j+e)+b/12.0*h*h*4.0;g[d+8>>2]=b*.5*(j+e)*(j+e);g[d+12>>2]=0.0;return}default:{i=b*.25*(j+e)*(j+e)+b/12.0*(f+i)*(f+i)*4.0;g[d>>2]=i;g[d+4>>2]=b*.5*(j+e)*(j+e);g[d+8>>2]=i;g[d+12>>2]=0.0;return}}}function Sj(b,d){b=b|0;d=d|0;c[b+8>>2]=0;c[b>>2]=6292;a[b+28>>0]=1;c[b+24>>2]=0;c[b+16>>2]=0;c[b+20>>2]=0;c[b+32>>2]=1566444395;c[b+36>>2]=1566444395;c[b+40>>2]=1566444395;g[b+44>>2]=0.0;c[b+48>>2]=-581039253;c[b+52>>2]=-581039253;c[b+56>>2]=-581039253;g[b+60>>2]=0.0;c[b+64>>2]=0;c[b+68>>2]=1;g[b+72>>2]=0.0;c[b+76>>2]=1065353216;c[b+80>>2]=1065353216;c[b+84>>2]=1065353216;g[b+88>>2]=0.0;c[b+4>>2]=31;if(!d)return;c[6435]=(c[6435]|0)+1;d=yc(79)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}a[d+36>>0]=1;c[d+32>>2]=0;c[d+24>>2]=0;c[d+28>>2]=0;a[d+56>>0]=1;c[d+52>>2]=0;c[d+44>>2]=0;c[d+48>>2]=0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=-1;c[d+12>>2]=0;c[d+16>>2]=0;c[b+64>>2]=d;return}function Tj(a){a=a|0;var b=0;c[a>>2]=3068;b=c[a+92>>2]|0;Ab[c[c[b>>2]>>2]&255](b);b=c[a+92>>2]|0;if(b|0){c[6436]=(c[6436]|0)+1;hd(c[b+-4>>2]|0)}b=c[a+96>>2]|0;Ab[c[c[b>>2]>>2]&255](b);b=c[a+96>>2]|0;if(b|0){c[6436]=(c[6436]|0)+1;hd(c[b+-4>>2]|0)}b=c[a+100>>2]|0;Ab[c[c[b>>2]>>2]&255](b);b=c[a+100>>2]|0;if(b|0){c[6436]=(c[6436]|0)+1;hd(c[b+-4>>2]|0)}b=c[a+104>>2]|0;Ab[c[c[b>>2]>>2]&255](b);b=c[a+104>>2]|0;if(b|0){c[6436]=(c[6436]|0)+1;hd(c[b+-4>>2]|0)}b=c[a+108>>2]|0;Ab[c[c[b>>2]>>2]&255](b);b=c[a+108>>2]|0;if(!b){kf(a);return}c[6436]=(c[6436]|0)+1;hd(c[b+-4>>2]|0);kf(a);return}function Uj(b,d,e,f){b=b|0;d=d|0;e=+e;f=f|0;var h=0,i=0;c[6435]=(c[6435]|0)+1;h=yc(203)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[h>>2]=4872;i=h+60|0;a[h+144>>0]=1;c[h+140>>2]=0;c[h+132>>2]=0;c[h+136>>2]=0;c[h+176>>2]=f;g[h+56>>2]=.019999999552965164;c[i>>2]=0;c[i+4>>2]=0;c[i+8>>2]=0;c[i+12>>2]=0;a[h+170>>0]=1;c[h+8>>2]=b;g[h+52>>2]=e;g[h+48>>2]=0.0;c[h+12>>2]=d;a[h+171>>0]=1;g[h+172>>2]=0.0;g[h+16>>2]=0.0;g[h+20>>2]=0.0;g[h+44>>2]=29.399999618530273;g[h+24>>2]=55.0;g[h+28>>2]=10.0;a[h+168>>0]=0;a[h+169>>0]=0;a[h+180>>0]=1;g[h+36>>2]=.7853981852531433;g[h+40>>2]=.7071067690849304;g[h+108>>2]=0.0;a[h+181>>0]=0;a[h+182>>0]=0;return h|0}function Vj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0;m=c[b+52>>2]|0;l=c[m+32>>2]|0;b=c[l>>2]|0;m=c[m+24>>2]|0;if((m|0)<=1){m=b;m=m+8|0;c[a>>2]=c[m>>2];c[a+4>>2]=c[m+4>>2];c[a+8>>2]=c[m+8>>2];c[a+12>>2]=c[m+12>>2];return}j=+g[d>>2];k=+g[d+4>>2];i=+g[d+8>>2];f=j*+g[b+8>>2]+k*+g[b+12>>2]+i*+g[b+16>>2];d=1;h=0;while(1){b=c[l+(d<<2)>>2]|0;e=j*+g[b+8>>2]+k*+g[b+12>>2]+i*+g[b+16>>2];b=e>f;h=b?d:h;d=d+1|0;if((d|0)==(m|0))break;else f=b?e:f}m=c[l+(h<<2)>>2]|0;m=m+8|0;c[a>>2]=c[m>>2];c[a+4>>2]=c[m+4>>2];c[a+8>>2]=c[m+8>>2];c[a+12>>2]=c[m+12>>2];return}
function Ld(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0,M=0,N=0,O=0;h=i;i=i+256|0;if(!(c[b+16>>2]|0)){K=c[b+12>>2]|0;b=c[b+20>>2]|0;n=+g[d>>2];q=+g[d+4>>2];u=+g[d+8>>2];k=+g[d+16>>2];r=+g[d+20>>2];j=+g[d+24>>2];m=+g[d+32>>2];s=+g[d+36>>2];l=+g[d+40>>2];F=+g[d+48>>2];E=+g[d+52>>2];D=+g[d+56>>2];J=+g[e>>2];I=+g[e+16>>2];y=+g[e+32>>2];H=+g[e+4>>2];G=+g[e+20>>2];w=+g[e+36>>2];v=+g[e+8>>2];z=+g[e+24>>2];x=+g[e+40>>2];C=-+g[e+48>>2];B=-+g[e+52>>2];p=-+g[e+56>>2];d=c[(c[K>>2]|0)+64>>2]|0;A=-+g[b+48>>2];t=-+g[b+52>>2];o=-+g[b+56>>2];g[h+16>>2]=(n*J+k*I+m*y)*A+(n*H+k*G+m*w)*t+(n*v+k*z+m*x)*o;g[h+16+4>>2]=(q*J+r*I+s*y)*A+(q*H+r*G+s*w)*t+(q*v+r*z+s*x)*o;g[h+16+8>>2]=(u*J+j*I+l*y)*A+(u*H+j*G+l*w)*t+(u*v+j*z+l*x)*o;g[h+16+12>>2]=0.0;ic[d&127](h+168|0,K,h+16|0);o=+g[h+168>>2];t=+g[h+168+4>>2];A=+g[h+168+8>>2];y=F*J+E*I+D*y+(J*C+I*B+y*p)+((n*J+k*I+m*y)*o+(q*J+r*I+s*y)*t+(u*J+j*I+l*y)*A);w=F*H+E*G+D*w+(H*C+G*B+w*p)+((n*H+k*G+m*w)*o+(q*H+r*G+s*w)*t+(u*H+j*G+l*w)*A);A=F*v+E*z+D*x+(v*C+z*B+x*p)+((n*v+k*z+m*x)*o+(q*v+r*z+s*x)*t+(u*v+j*z+l*x)*A);x=+g[b+48>>2];l=+g[b+52>>2];z=+g[b+56>>2];j=z*A+(x*y+l*w)-+g[b+64>>2];v=+g[e>>2];u=+g[e+4>>2];t=+g[e+8>>2];s=+g[e+16>>2];r=+g[e+20>>2];q=+g[e+24>>2];o=+g[e+32>>2];m=+g[e+36>>2];k=+g[e+40>>2];n=(y-x*j)*s+(w-l*j)*r+(A-z*j)*q+ +g[e+52>>2];p=(y-x*j)*o+(w-l*j)*m+(A-z*j)*k+ +g[e+56>>2];g[h+32>>2]=t*(A-z*j)+(v*(y-x*j)+u*(w-l*j))+ +g[e+48>>2];g[h+32+4>>2]=n;g[h+32+8>>2]=p;g[h+32+12>>2]=0.0;p=+g[b+48>>2];n=+g[b+52>>2];l=+g[b+56>>2];g[h>>2]=v*p+u*n+t*l;g[h+4>>2]=p*s+n*r+l*q;g[h+8>>2]=p*o+n*m+l*k;g[h+12>>2]=0.0;hc[c[(c[f>>2]|0)+16>>2]&15](f,h,h+32|0,j);i=h;return}else{N=c[b+4>>2]|0;a[N+312>>0]=0;c[N>>2]=0;a[N+356>>0]=1;c[N+292>>2]=1566444395;c[N+296>>2]=1566444395;c[N+300>>2]=1566444395;g[N+304>>2]=0.0;c[N+336>>2]=0;c[N+336+4>>2]=0;c[N+336+8>>2]=0;c[N+336+12>>2]=0;a[N+336+16>>0]=0;a[N+332>>0]=a[N+332>>0]&-16;N=c[b+12>>2]|0;M=c[b+16>>2]|0;L=c[N+4>>2]|0;K=c[M+4>>2]|0;I=+Sb[c[(c[N>>2]|0)+48>>2]&15](N);O=c[b+16>>2]|0;J=+Sb[c[(c[O>>2]|0)+48>>2]&15](O);O=c[b+4>>2]|0;b=c[b+8>>2]|0;c[h+168>>2]=9208;c[h+168+4>>2]=0;c[h+168+8>>2]=1065353216;c[h+168+12>>2]=0;g[h+168+16>>2]=0.0;c[h+168+20>>2]=b;c[h+168+24>>2]=O;c[h+168+28>>2]=N;c[h+168+32>>2]=M;c[h+168+36>>2]=L;c[h+168+40>>2]=K;g[h+168+44>>2]=I;g[h+168+48>>2]=J;a[h+168+52>>0]=0;c[h+168+60>>2]=-1;c[h+168+72>>2]=1;c[h+168+76>>2]=1;g[h+32+128>>2]=999999984306749440.0;c[h+32>>2]=c[d>>2];c[h+32+4>>2]=c[d+4>>2];c[h+32+8>>2]=c[d+8>>2];c[h+32+12>>2]=c[d+12>>2];c[h+32+16>>2]=c[d+16>>2];c[h+32+16+4>>2]=c[d+16+4>>2];c[h+32+16+8>>2]=c[d+16+8>>2];c[h+32+16+12>>2]=c[d+16+12>>2];c[h+32+32>>2]=c[d+32>>2];c[h+32+32+4>>2]=c[d+32+4>>2];c[h+32+32+8>>2]=c[d+32+8>>2];c[h+32+32+12>>2]=c[d+32+12>>2];c[h+32+48>>2]=c[d+48>>2];c[h+32+48+4>>2]=c[d+48+4>>2];c[h+32+48+8>>2]=c[d+48+8>>2];c[h+32+48+12>>2]=c[d+48+12>>2];c[h+32+64>>2]=c[e>>2];c[h+32+64+4>>2]=c[e+4>>2];c[h+32+64+8>>2]=c[e+8>>2];c[h+32+64+12>>2]=c[e+12>>2];c[h+32+80>>2]=c[e+16>>2];c[h+32+80+4>>2]=c[e+16+4>>2];c[h+32+80+8>>2]=c[e+16+8>>2];c[h+32+80+12>>2]=c[e+16+12>>2];c[h+32+96>>2]=c[e+32>>2];c[h+32+96+4>>2]=c[e+32+4>>2];c[h+32+96+8>>2]=c[e+32+8>>2];c[h+32+96+12>>2]=c[e+32+12>>2];c[h+32+112>>2]=c[e+48>>2];c[h+32+112+4>>2]=c[e+48+4>>2];c[h+32+112+8>>2]=c[e+48+8>>2];c[h+32+112+12>>2]=c[e+48+12>>2];Vc(h+168|0,h+32|0,f,0,0);i=h;return}}function Md(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+32|0;g=Eb[c[(c[d>>2]|0)+28>>2]&127](d)|0;c[e+20>>2]=g;c[e>>2]=0;if(!g){s=d+4|0;f=e+4|0;s=c[s>>2]|0;c[f>>2]=s;f=d+8|0;f=c[f>>2]|0;s=e+8|0;c[s>>2]=f;s=d+12|0;s=c[s>>2]|0;f=e+12|0;c[f>>2]=s;f=d+16|0;f=c[f>>2]|0;d=e+16|0;c[d>>2]=f;i=t;return 19362}s=Ob[c[(c[f>>2]|0)+16>>2]&63](f,32,g)|0;g=c[s+8>>2]|0;c[e>>2]=Zb[c[(c[f>>2]|0)+28>>2]&31](f,g)|0;r=Eb[c[(c[d>>2]|0)+28>>2]&127](d)|0;a:do if((r|0)>0){q=0;while(1){Yb[c[(c[d>>2]|0)+16>>2]&3](d,t+28|0,t+4|0,t+16|0,t+8|0,t+24|0,t+20|0,t,t+12|0,q);c[g+24>>2]=c[t>>2];c[g+28>>2]=c[t+4>>2];k=g+12|0;m=g+16|0;p=g+4|0;c[g>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[g+16>>2]=0;c[g+20>>2]=0;switch(c[t+12>>2]|0){case 2:{j=c[t>>2]|0;if(j|0){j=Ob[c[(c[f>>2]|0)+16>>2]&63](f,4,j*3|0)|0;k=c[j+8>>2]|0;c[g+8>>2]=Zb[c[(c[f>>2]|0)+28>>2]&31](f,k)|0;if((c[t>>2]|0)>0){l=c[t+24>>2]|0;m=0;do{n=l+(_(c[t+20>>2]|0,m)|0)|0;o=m*3|0;c[k+(o<<2)>>2]=c[n>>2];c[k+(o+1<<2)>>2]=c[n+4>>2];c[k+(o+2<<2)>>2]=c[n+8>>2];m=m+1|0}while((m|0)<(c[t>>2]|0))}yb[c[(c[f>>2]|0)+20>>2]&31](f,j,19243,1497453121,c[j+8>>2]|0)}break}case 3:{j=c[t>>2]|0;if(j|0){n=Ob[c[(c[f>>2]|0)+16>>2]&63](f,8,j)|0;o=c[n+8>>2]|0;c[k>>2]=Zb[c[(c[f>>2]|0)+28>>2]&31](f,o)|0;j=c[t>>2]|0;if((j|0)>0){k=c[t+24>>2]|0;l=c[t+20>>2]|0;m=0;do{u=k+(_(l,m)|0)|0;b[o+(m<<3)>>1]=b[u>>1]|0;b[o+(m<<3)+2>>1]=b[u+2>>1]|0;b[o+(m<<3)+4>>1]=b[u+4>>1]|0;m=m+1|0}while((m|0)!=(j|0))}yb[c[(c[f>>2]|0)+20>>2]&31](f,n,19258,1497453121,c[n+8>>2]|0)}break}case 5:{j=c[t>>2]|0;if(j|0){k=Ob[c[(c[f>>2]|0)+16>>2]&63](f,4,j)|0;l=c[k+8>>2]|0;c[m>>2]=Zb[c[(c[f>>2]|0)+28>>2]&31](f,l)|0;if((c[t>>2]|0)>0){j=0;do{u=(c[t+24>>2]|0)+(_(c[t+20>>2]|0,j)|0)|0;a[l+(j<<2)>>0]=a[u>>0]|0;a[l+(j<<2)+1>>0]=a[u+1>>0]|0;a[l+(j<<2)+2>>0]=a[u+2>>0]|0;j=j+1|0}while((j|0)<(c[t>>2]|0))}yb[c[(c[f>>2]|0)+20>>2]&31](f,k,19285,1497453121,c[k+8>>2]|0)}break}default:{}}switch(c[t+16>>2]|0){case 0:{j=c[t+4>>2]|0;if(j|0){j=Ob[c[(c[f>>2]|0)+16>>2]&63](f,16,j)|0;k=c[j+8>>2]|0;c[g>>2]=Zb[c[(c[f>>2]|0)+28>>2]&31](f,k)|0;l=c[t+4>>2]|0;if((l|0)>0){m=c[t+28>>2]|0;n=c[t+8>>2]|0;o=0;do{u=m+(_(n,o)|0)|0;c[k+(o<<4)>>2]=c[u>>2];c[k+(o<<4)+4>>2]=c[u+4>>2];c[k+(o<<4)+8>>2]=c[u+8>>2];o=o+1|0}while((o|0)!=(l|0))}yb[c[(c[f>>2]|0)+20>>2]&31](f,j,19308,1497453121,c[j+8>>2]|0)}break}case 1:{j=c[t+4>>2]|0;if(j|0){n=Ob[c[(c[f>>2]|0)+16>>2]&63](f,32,j)|0;o=c[n+8>>2]|0;c[p>>2]=Zb[c[(c[f>>2]|0)+28>>2]&31](f,o)|0;j=c[t+4>>2]|0;if((j|0)>0){k=c[t+28>>2]|0;l=c[t+8>>2]|0;m=0;do{u=k+(_(l,m)|0)|0;h[o+(m<<5)>>3]=+h[u>>3];h[o+(m<<5)+8>>3]=+h[u+8>>3];h[o+(m<<5)+16>>3]=+h[u+16>>3];m=m+1|0}while((m|0)!=(j|0))}yb[c[(c[f>>2]|0)+20>>2]&31](f,n,19327,1497453121,c[n+8>>2]|0)}break}default:{}}Cb[c[(c[d>>2]|0)+24>>2]&127](d,q);q=q+1|0;if((q|0)==(r|0)){g=f;break a}else g=g+32|0}}else g=f;while(0);yb[c[(c[g>>2]|0)+20>>2]&31](f,s,19347,1497453121,c[s+8>>2]|0);f=d+4|0;u=e+4|0;f=c[f>>2]|0;c[u>>2]=f;u=d+8|0;u=c[u>>2]|0;f=e+8|0;c[f>>2]=u;f=d+12|0;f=c[f>>2]|0;u=e+12|0;c[u>>2]=f;d=d+16|0;d=c[d>>2]|0;u=e+16|0;c[u>>2]=d;i=t;return 19362}function Nd(b,d,e,f,h,i){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;var j=0,l=0,m=0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0,D=0;D=c[b+88>>2]|0;if((D|0)==(c[b+92>>2]|0)?(o=D|0?D<<1:1,(D|0)<(o|0)):0){if(!o){j=0;l=D}else{c[6435]=(c[6435]|0)+1;j=yc((o*152|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}l=c[b+88>>2]|0}if((l|0)>0){m=0;do{_m(j+(m*152|0)|0,(c[b+96>>2]|0)+(m*152|0)|0,152)|0;m=m+1|0}while((m|0)!=(l|0))}l=c[b+96>>2]|0;if(l|0){if(a[b+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[l+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=j;c[b+92>>2]=o;j=c[b+88>>2]|0}else j=D;c[b+88>>2]=j+1;C=c[b+96>>2]|0;c[C+(D*152|0)+140>>2]=h;c[C+(D*152|0)+16>>2]=0;c[C+(D*152|0)+16+4>>2]=0;c[C+(D*152|0)+16+8>>2]=0;c[C+(D*152|0)+16+12>>2]=0;g[C+(D*152|0)+48>>2]=-0.0;g[C+(D*152|0)+52>>2]=-0.0;g[C+(D*152|0)+56>>2]=-0.0;g[C+(D*152|0)+60>>2]=0.0;b=c[b+16>>2]|0;o=c[b+(e*244|0)+240>>2]|0;B=c[b+(f*244|0)+240>>2]|0;c[C+(D*152|0)+144>>2]=e;c[C+(D*152|0)+148>>2]=f;h=c[i+88>>2]|0;c[C+(D*152|0)+104>>2]=h;c[C+(D*152|0)+132>>2]=0;g[C+(D*152|0)+100>>2]=0.0;g[C+(D*152|0)+96>>2]=0.0;x=-+g[d>>2];y=-+g[d+4>>2];z=-+g[d+8>>2];g[C+(D*152|0)>>2]=x;g[C+(D*152|0)+4>>2]=y;g[C+(D*152|0)+8>>2]=z;g[C+(D*152|0)+12>>2]=0.0;A=(c[k>>2]=h,+g[k>>2]);if(o|0){j=(g[k>>2]=(+g[o+264>>2]*x+ +g[o+268>>2]*y+ +g[o+272>>2]*z)*+g[o+544>>2],c[k>>2]|0);l=(g[k>>2]=(+g[o+280>>2]*x+ +g[o+284>>2]*y+ +g[o+288>>2]*z)*+g[o+548>>2],c[k>>2]|0);m=(g[k>>2]=(+g[o+296>>2]*x+ +g[o+300>>2]*y+ +g[o+304>>2]*z)*+g[o+552>>2],c[k>>2]|0)}else{j=0;l=0;m=0}c[C+(D*152|0)+64>>2]=j;c[C+(D*152|0)+68>>2]=l;c[C+(D*152|0)+72>>2]=m;g[C+(D*152|0)+76>>2]=0.0;u=+g[d>>2];v=+g[d+4>>2];w=+g[d+8>>2];d=c[d+12>>2]|0;g[C+(D*152|0)+32>>2]=u;g[C+(D*152|0)+36>>2]=v;g[C+(D*152|0)+40>>2]=w;c[C+(D*152|0)+44>>2]=d;if(B|0){j=(g[k>>2]=(u*+g[B+264>>2]+v*+g[B+268>>2]+w*+g[B+272>>2])*+g[B+544>>2],c[k>>2]|0);l=(g[k>>2]=(u*+g[B+280>>2]+v*+g[B+284>>2]+w*+g[B+288>>2])*+g[B+548>>2],c[k>>2]|0);m=(g[k>>2]=(u*+g[B+296>>2]+v*+g[B+300>>2]+w*+g[B+304>>2])*+g[B+552>>2],c[k>>2]|0)}else{j=0;l=0;m=0}c[C+(D*152|0)+80>>2]=j;c[C+(D*152|0)+84>>2]=l;c[C+(D*152|0)+88>>2]=m;g[C+(D*152|0)+92>>2]=0.0;if(o|0){n=+g[o+264>>2]*x+ +g[o+268>>2]*y+ +g[o+272>>2]*z;p=+g[o+280>>2]*x+ +g[o+284>>2]*y+ +g[o+288>>2]*z;q=+g[o+296>>2]*x+ +g[o+300>>2]*y+ +g[o+304>>2]*z}else{n=0.0;p=0.0;q=0.0}if(B|0){r=+g[B+264>>2]*u+ +g[B+268>>2]*v+ +g[B+272>>2]*w;s=u*+g[B+280>>2]+v*+g[B+284>>2]+w*+g[B+288>>2];t=u*+g[B+296>>2]+v*+g[B+300>>2]+w*+g[B+304>>2]}else{r=0.0;s=0.0;t=0.0}s=1.0/(n*x+p*y+q*z+0.0+(r*u+s*v+t*w));g[C+(D*152|0)+108>>2]=s;if(o|0){p=+g[b+(e*244|0)+192>>2];q=+g[b+(e*244|0)+196>>2];r=+g[b+(e*244|0)+200>>2];n=(+g[b+(e*244|0)+176>>2]+ +g[b+(e*244|0)+208>>2])*0.0+(+g[b+(e*244|0)+180>>2]+ +g[b+(e*244|0)+212>>2])*0.0+(+g[b+(e*244|0)+184>>2]+ +g[b+(e*244|0)+216>>2])*0.0}else{p=0.0;q=0.0;r=0.0;n=0.0}n=n+(p*x+q*y+r*z);if(!B){t=0.0;x=0.0;z=0.0;y=-0.0;u=t*u;x=x*v;x=u+x;z=z*w;z=x+z;z=y+z;z=n+z;z=0.0-z;z=s*z;f=C+(D*152|0)+112|0;g[f>>2]=z;f=C+(D*152|0)+116|0;g[f>>2]=0.0;A=-A;f=C+(D*152|0)+120|0;g[f>>2]=A;f=C+(D*152|0)+124|0;c[f>>2]=h;return}t=+g[b+(f*244|0)+192>>2];x=+g[b+(f*244|0)+196>>2];z=+g[b+(f*244|0)+200>>2];y=(+g[b+(f*244|0)+176>>2]+ +g[b+(f*244|0)+208>>2])*-0.0+(+g[b+(f*244|0)+180>>2]+ +g[b+(f*244|0)+212>>2])*-0.0+(+g[b+(f*244|0)+184>>2]+ +g[b+(f*244|0)+216>>2])*-0.0;u=t*u;x=x*v;x=u+x;z=z*w;z=x+z;z=y+z;z=n+z;z=0.0-z;z=s*z;f=C+(D*152|0)+112|0;g[f>>2]=z;f=C+(D*152|0)+116|0;g[f>>2]=0.0;A=-A;f=C+(D*152|0)+120|0;g[f>>2]=A;f=C+(D*152|0)+124|0;c[f>>2]=h;return}function Od(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0,j=0,l=0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;n=i;i=i+32|0;c[b+236>>2]=2;c[b+312>>2]=0;c[b+312+4>>2]=0;c[b+312+8>>2]=0;c[b+312+12>>2]=0;c[b+312+16>>2]=0;c[b+312+20>>2]=0;c[b+312+24>>2]=0;c[b+312+28>>2]=0;c[b+544>>2]=1065353216;c[b+548>>2]=1065353216;c[b+552>>2]=1065353216;g[b+556>>2]=0.0;c[b+348>>2]=1065353216;c[b+352>>2]=1065353216;c[b+356>>2]=1065353216;e=b+360|0;h=e+36|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));c[b+412>>2]=0;c[b+412+4>>2]=0;c[b+412+8>>2]=0;c[b+412+12>>2]=0;c[b+412+16>>2]=0;c[b+412+20>>2]=0;c[b+412+24>>2]=0;c[b+412+28>>2]=0;f=+g[d+92>>2];m=+g[d+96>>2];g[n+20>>2]=f;g[n+16>>2]=m;g[n+12>>2]=0.0;g[n+8>>2]=1.0;c[b+444>>2]=c[(f<0.0?n+12|0:f>1.0?n+8|0:n+20|0)>>2];g[n+4>>2]=0.0;g[n>>2]=1.0;c[b+448>>2]=c[(m<0.0?n+4|0:m>1.0?n:n+16|0)>>2];c[b+472>>2]=c[d+112>>2];c[b+476>>2]=c[d+116>>2];e=c[d+4>>2]|0;c[b+480>>2]=e;c[b+608>>2]=0;c[b+612>>2]=0;a[b+452>>0]=a[d+120>>0]|0;c[b+456>>2]=c[d+124>>2];c[b+460>>2]=c[d+128>>2];c[b+464>>2]=c[d+132>>2];c[b+468>>2]=c[d+136>>2];if(!e){c[b+4>>2]=c[d+8>>2];c[b+4+4>>2]=c[d+8+4>>2];c[b+4+8>>2]=c[d+8+8>>2];c[b+4+12>>2]=c[d+8+12>>2];c[b+20>>2]=c[d+24>>2];c[b+20+4>>2]=c[d+24+4>>2];c[b+20+8>>2]=c[d+24+8>>2];c[b+20+12>>2]=c[d+24+12>>2];c[b+36>>2]=c[d+40>>2];c[b+36+4>>2]=c[d+40+4>>2];c[b+36+8>>2]=c[d+40+8>>2];c[b+36+12>>2]=c[d+40+12>>2];c[b+52>>2]=c[d+56>>2];c[b+52+4>>2]=c[d+56+4>>2];c[b+52+8>>2]=c[d+56+8>>2];c[b+52+12>>2]=c[d+56+12>>2];e=b+4|0;h=b+20|0;j=b+36|0;l=b+52|0}else{Cb[c[(c[e>>2]|0)+8>>2]&127](e,b+4|0);e=b+4|0;h=b+20|0;j=b+36|0;l=b+52|0}c[b+68>>2]=c[e>>2];c[b+68+4>>2]=c[e+4>>2];c[b+68+8>>2]=c[e+8>>2];c[b+68+12>>2]=c[e+12>>2];c[b+84>>2]=c[h>>2];c[b+84+4>>2]=c[h+4>>2];c[b+84+8>>2]=c[h+8>>2];c[b+84+12>>2]=c[h+12>>2];c[b+100>>2]=c[j>>2];c[b+100+4>>2]=c[j+4>>2];c[b+100+8>>2]=c[j+8>>2];c[b+100+12>>2]=c[j+12>>2];c[b+116>>2]=c[l>>2];c[b+116+4>>2]=c[l+4>>2];c[b+116+8>>2]=c[l+8>>2];c[b+116+12>>2]=c[l+12>>2];c[b+132>>2]=0;c[b+132+4>>2]=0;c[b+132+8>>2]=0;c[b+132+12>>2]=0;c[b+132+16>>2]=0;c[b+132+20>>2]=0;c[b+132+24>>2]=0;c[b+132+28>>2]=0;c[b+224>>2]=c[d+100>>2];c[b+232>>2]=c[d+104>>2];c[b+228>>2]=c[d+108>>2];Cb[c[(c[b>>2]|0)+12>>2]&127](b,c[d+72>>2]|0);e=c[5815]|0;c[5815]=e+1;c[b+508>>2]=e;f=+g[d>>2];e=c[b+204>>2]|0;if(f==0.0){c[b+204>>2]=e|1;m=0.0}else{c[b+204>>2]=e&-2;m=1.0/f}g[b+344>>2]=m;p=f*+g[b+384>>2];o=f*+g[b+388>>2];g[b+364>>2]=f*+g[b+380>>2];g[b+368>>2]=p;g[b+372>>2]=o;g[b+376>>2]=0.0;f=+g[d+76>>2];h=f!=0.0?(g[k>>2]=1.0/f,c[k>>2]|0):0;f=+g[d+80>>2];e=f!=0.0?(g[k>>2]=1.0/f,c[k>>2]|0):0;f=+g[d+84>>2];d=f!=0.0?(g[k>>2]=1.0/f,c[k>>2]|0):0;c[b+396>>2]=h;c[b+400>>2]=e;c[b+404>>2]=d;g[b+408>>2]=0.0;r=m*+g[b+352>>2];x=m*+g[b+356>>2];g[b+560>>2]=m*+g[b+348>>2];g[b+564>>2]=r;g[b+568>>2]=x;g[b+572>>2]=0.0;x=+g[b+4>>2];r=(c[k>>2]=h,+g[k>>2]);w=+g[b+8>>2];f=(c[k>>2]=e,+g[k>>2]);v=+g[b+12>>2];o=(c[k>>2]=d,+g[k>>2]);u=+g[b+20>>2];t=+g[b+24>>2];s=+g[b+28>>2];q=+g[b+36>>2];p=+g[b+40>>2];m=+g[b+44>>2];g[b+264>>2]=x*x*r+w*w*f+v*v*o;g[b+268>>2]=x*r*u+w*f*t+v*o*s;g[b+272>>2]=x*r*q+w*f*p+v*o*m;g[b+276>>2]=0.0;g[b+280>>2]=x*r*u+w*f*t+v*o*s;g[b+284>>2]=u*r*u+t*f*t+s*o*s;g[b+288>>2]=r*u*q+f*t*p+o*s*m;g[b+292>>2]=0.0;g[b+296>>2]=x*r*q+w*f*p+v*o*m;g[b+300>>2]=u*r*q+t*f*p+s*o*m;g[b+304>>2]=q*r*q+p*f*p+m*o*m;g[b+308>>2]=0.0;c[b+504>>2]=0;c[b+512>>2]=0;c[b+512+4>>2]=0;c[b+512+8>>2]=0;c[b+512+12>>2]=0;c[b+512+16>>2]=0;c[b+512+20>>2]=0;c[b+512+24>>2]=0;c[b+512+28>>2]=0;m=+g[b+344>>2];o=m*+g[b+352>>2];p=m*+g[b+356>>2];g[b+560>>2]=+g[b+348>>2]*m;g[b+564>>2]=o;g[b+568>>2]=p;e=b+572|0;h=e+36|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));i=n;return}function Pd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;n=c[a+192>>2]|0;m=+Sb[c[(c[n>>2]|0)+48>>2]&15](n);n=c[a+712>>2]|0;if((n|0)>0){o=0;do{l=c[a+720>>2]|0;f=l+(o*104|0)+8|0;q=+g[f>>2];h=l+(o*104|0)+12|0;p=+g[h>>2];d=l+(o*104|0)+16|0;k=+g[d>>2];i=q*+g[b>>2]+p*+g[b+4>>2]+k*+g[b+8>>2]+ +g[b+48>>2];j=q*+g[b+16>>2]+p*+g[b+20>>2]+k*+g[b+24>>2]+ +g[b+52>>2];k=q*+g[b+32>>2]+p*+g[b+36>>2]+k*+g[b+40>>2]+ +g[b+56>>2];g[f>>2]=i;g[h>>2]=j;g[d>>2]=k;g[l+(o*104|0)+20>>2]=0.0;d=l+(o*104|0)+24|0;p=+g[d>>2];h=l+(o*104|0)+28|0;q=+g[h>>2];f=l+(o*104|0)+32|0;r=+g[f>>2];s=p*+g[b+16>>2]+q*+g[b+20>>2]+r*+g[b+24>>2]+ +g[b+52>>2];t=p*+g[b+32>>2]+q*+g[b+36>>2]+r*+g[b+40>>2]+ +g[b+56>>2];g[d>>2]=p*+g[b>>2]+q*+g[b+4>>2]+r*+g[b+8>>2]+ +g[b+48>>2];g[h>>2]=s;g[f>>2]=t;g[l+(o*104|0)+36>>2]=0.0;f=l+(o*104|0)+72|0;t=+g[f>>2];h=l+(o*104|0)+76|0;s=+g[h>>2];d=l+(o*104|0)+80|0;r=+g[d>>2];q=t*+g[b+16>>2]+s*+g[b+20>>2]+r*+g[b+24>>2];p=t*+g[b+32>>2]+s*+g[b+36>>2]+r*+g[b+40>>2];g[f>>2]=+g[b>>2]*t+ +g[b+4>>2]*s+ +g[b+8>>2]*r;g[h>>2]=q;g[d>>2]=p;g[l+(o*104|0)+84>>2]=0.0;l=c[l+(o*104|0)+96>>2]|0;d=hh(a+928|0,l)|0;a:do if(d){f=c[a+936>>2]|0;if((f|0)<=-1){d=c[a+928>>2]|0;break}if((f|0)>0){h=0;while(1){e=c[d+32>>2]|0;h=h+1|0;if(!e)break a;if((h|0)>=(f|0)){d=e;break}else d=e}}}else d=0;while(0);g[l>>2]=i-m;g[l+4>>2]=j-m;g[l+8>>2]=k-m;g[l+12>>2]=0.0;g[l+16>>2]=m+i;g[l+20>>2]=m+j;g[l+24>>2]=m+k;g[l+28>>2]=0.0;lf(a+928|0,d,l);o=o+1|0}while((o|0)!=(n|0))}Bg(a);d=c[a+928>>2]|0;if(d){o=c[a+192>>2]|0;r=+Sb[c[(c[o>>2]|0)+48>>2]&15](o);t=+g[d+4>>2]-r;s=+g[d+8>>2]-r;g[a+892>>2]=+g[d>>2]-r;g[a+896>>2]=t;g[a+900>>2]=s;g[a+904>>2]=0.0;s=r+ +g[d+20>>2];t=r+ +g[d+24>>2];g[a+908>>2]=r+ +g[d+16>>2];g[a+912>>2]=s;g[a+916>>2]=t;g[a+920>>2]=0.0;d=c[a+188>>2]|0;if(d|0){o=c[a+684>>2]|0;n=c[o+32>>2]|0;yb[c[(c[n>>2]|0)+16>>2]&31](n,d,a+892|0,a+908|0,c[o+36>>2]|0)}}else{c[a+892>>2]=0;c[a+892+4>>2]=0;c[a+892+8>>2]=0;c[a+892+12>>2]=0;c[a+892+16>>2]=0;c[a+892+20>>2]=0;c[a+892+24>>2]=0;c[a+892+28>>2]=0}f=c[a+732>>2]|0;if((f|0)<=0){eg(a);o=a+1148|0;c[o>>2]=c[b>>2];c[o+4>>2]=c[b+4>>2];c[o+8>>2]=c[b+8>>2];c[o+12>>2]=c[b+12>>2];o=a+1164|0;n=b+16|0;c[o>>2]=c[n>>2];c[o+4>>2]=c[n+4>>2];c[o+8>>2]=c[n+8>>2];c[o+12>>2]=c[n+12>>2];o=a+1180|0;n=b+32|0;c[o>>2]=c[n>>2];c[o+4>>2]=c[n+4>>2];c[o+8>>2]=c[n+8>>2];c[o+12>>2]=c[n+12>>2];a=a+1196|0;b=b+48|0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];return}d=c[a+740>>2]|0;e=0;do{n=c[d+(e*52|0)+8>>2]|0;o=c[d+(e*52|0)+12>>2]|0;r=+g[n+8>>2]-+g[o+8>>2];s=+g[n+12>>2]-+g[o+12>>2];t=+g[n+16>>2]-+g[o+16>>2];t=+O(+(r*r+s*s+t*t));g[d+(e*52|0)+16>>2]=t;g[d+(e*52|0)+28>>2]=t*t;e=e+1|0}while((e|0)!=(f|0));d=c[a+740>>2]|0;e=0;do{g[d+(e*52|0)+24>>2]=(+g[(c[d+(e*52|0)+8>>2]|0)+88>>2]+ +g[(c[d+(e*52|0)+12>>2]|0)+88>>2])/+g[(c[d+(e*52|0)+4>>2]|0)+4>>2];e=e+1|0}while((e|0)!=(f|0));eg(a);o=a+1148|0;c[o>>2]=c[b>>2];c[o+4>>2]=c[b+4>>2];c[o+8>>2]=c[b+8>>2];c[o+12>>2]=c[b+12>>2];o=a+1164|0;n=b+16|0;c[o>>2]=c[n>>2];c[o+4>>2]=c[n+4>>2];c[o+8>>2]=c[n+8>>2];c[o+12>>2]=c[n+12>>2];o=a+1180|0;n=b+32|0;c[o>>2]=c[n>>2];c[o+4>>2]=c[n+4>>2];c[o+8>>2]=c[n+8>>2];c[o+12>>2]=c[n+12>>2];a=a+1196|0;b=b+48|0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];return}function Qd(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0.0,h=0,j=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0,H=0,I=0;F=i;i=i+96|0;d=c[a+216>>2]|0;if(+g[d+4>>2]==0.0){E=0;i=F;return E|0}E=c[b>>2]|0;if(!(Zb[c[(c[d>>2]|0)+8>>2]&31](d,c[E+188>>2]|0)|0)){E=1;i=F;return E|0}b=c[E+192>>2]|0;D=c[a+216>>2]|0;if((c[b+4>>2]|0)!=32){c[F+32>>2]=0;c[F+32+4>>2]=b;c[F+32+8>>2]=E;c[F+32+12>>2]=E+4;c[F+32+16>>2]=-1;c[F+32+20>>2]=-1;bd(a+68|0,a+132|0,F+32|0,D);E=1;i=F;return E|0}if((E|0)==0?1:(c[E+236>>2]|0)!=8){E=1;i=F;return E|0}if(c[E+752>>2]|0?(c[E+988>>2]|0)==0:0)gg(E);A=+g[a+180>>2]-+g[a+116>>2];B=+g[a+184>>2]-+g[a+120>>2];C=+g[a+188>>2]-+g[a+124>>2];b=c[E+988>>2]|0;if(!b){q=c[E+752>>2]|0;if((q|0)>0){p=c[E+760>>2]|0;f=1.0;d=0;r=0;b=-1;l=1065353216;h=0;do{I=c[p+(r*44|0)+8>>2]|0;H=c[p+(r*44|0)+12>>2]|0;G=c[p+(r*44|0)+16>>2]|0;e=+Mh(a+116|0,A,B,C,+g[I+8>>2],+g[I+12>>2],+g[I+16>>2],+g[H+8>>2],+g[H+12>>2],+g[H+16>>2],+g[G+8>>2],+g[G+12>>2],+g[G+16>>2],f);if(e>0.0){f=e;d=d+1|0;b=r;l=(g[k>>2]=e,c[k>>2]|0);h=3}r=r+1|0}while((r|0)!=(q|0))}else{d=0;b=-1;l=1065353216;h=0}}else{c[F+32>>2]=3220;c[F+32+4>>2]=c[a+116>>2];c[F+32+4+4>>2]=c[a+116+4>>2];c[F+32+4+8>>2]=c[a+116+8>>2];c[F+32+4+12>>2]=c[a+116+12>>2];g[F+32+36>>2]=A;g[F+32+40>>2]=B;g[F+32+44>>2]=C;g[F+32+48>>2]=0.0;c[F+32+20>>2]=c[a+180>>2];c[F+32+20+4>>2]=c[a+180+4>>2];c[F+32+20+8>>2]=c[a+180+8>>2];c[F+32+20+12>>2]=c[a+180+12>>2];c[F+32+52>>2]=1065353216;c[F+32+56>>2]=0;c[F+32+60>>2]=0;ff(b,a+116|0,a+180|0,F+32|0);b=c[F+32+56>>2]|0;if(!b){d=0;b=-1;l=1065353216;h=0}else{d=1;b=(b-(c[E+760>>2]|0)|0)/44|0;l=c[F+32+52>>2]|0;h=3}}r=c[E+772>>2]|0;if((r|0)>0){q=c[E+780>>2]|0;f=(c[k>>2]=l,+g[k>>2]);p=0;do{I=c[q+(p*104|0)+8>>2]|0;x=+g[I+8>>2];y=+g[I+12>>2];z=+g[I+16>>2];I=c[q+(p*104|0)+12>>2]|0;o=+g[I+8>>2];s=+g[I+12>>2];t=+g[I+16>>2];I=c[q+(p*104|0)+16>>2]|0;u=+g[I+8>>2];v=+g[I+12>>2];w=+g[I+16>>2];e=+Mh(a+116|0,A,B,C,x,y,z,o,s,t,u,v,w,f);if(e>0.0){f=e;d=d+1|0;b=p;l=(g[k>>2]=e,c[k>>2]|0);h=4}I=c[q+(p*104|0)+20>>2]|0;j=+g[I+8>>2];m=+g[I+12>>2];n=+g[I+16>>2];e=+Mh(a+116|0,A,B,C,x,y,z,o,s,t,j,m,n,f);if(e>0.0){f=e;d=d+1|0;b=p;l=(g[k>>2]=e,c[k>>2]|0);h=4}e=+Mh(a+116|0,A,B,C,o,s,t,u,v,w,j,m,n,f);if(e>0.0){f=e;d=d+1|0;b=p;l=(g[k>>2]=e,c[k>>2]|0);h=4}e=+Mh(a+116|0,A,B,C,x,y,z,u,v,w,j,m,n,f);if(e>0.0){f=e;d=d+1|0;b=p;l=(g[k>>2]=e,c[k>>2]|0);h=4}p=p+1|0}while((p|0)!=(r|0))}if(!d){I=1;i=F;return I|0}if(!((c[k>>2]=l,+g[k>>2])<=+g[D+4>>2])){I=1;i=F;return I|0}c[F+32>>2]=0;c[F+32+4>>2]=b;m=+g[a+180>>2]-+g[a+116>>2];n=+g[a+184>>2]-+g[a+120>>2];o=+g[a+188>>2]-+g[a+124>>2];e=1.0/+O(+(m*m+n*n+o*o));if((h|0)==3){d=c[E+748+12>>2]|0;e=+g[d+(b*44|0)+20>>2];j=+g[d+(b*44|0)+24>>2];f=+g[d+(b*44|0)+28>>2];if(m*e+n*j+o*f>0.0){m=-e;j=-j;f=-f;e=0.0}else{m=e;e=+g[d+(b*44|0)+32>>2]}}else{m=-(m*e);j=-(n*e);f=-(o*e);e=0.0}c[F>>2]=E;c[F+4>>2]=F+32;g[F+8>>2]=m;g[F+12>>2]=j;g[F+16>>2]=f;g[F+20>>2]=e;c[F+24>>2]=l;+_b[c[(c[D>>2]|0)+12>>2]&15](D,F,1);I=1;i=F;return I|0}function Rd(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0;m=i;i=i+400|0;f=c[d+36>>2]|0;d=c[e+36>>2]|0;e=c[b+24>>2]|0;if(((e|0)==(c[b+28>>2]|0)?c[e+1132>>2]|0:0)?(k=(_(c[d+380>>2]|0,c[e+1112>>2]|0)|0)+(c[f+380>>2]|0)|0,a[(c[e+1140>>2]|0)+k>>0]|0):0){c[5802]=(c[5802]|0)+1;i=m;return}c[m+344+4>>2]=35;c[m+344+8>>2]=0;c[m+344+12>>2]=1065353216;c[m+344+16>>2]=1065353216;c[m+344+20>>2]=1065353216;g[m+344+24>>2]=0.0;c[m+344>>2]=3436;c[m+344+52>>2]=f;g[m+344+44>>2]=0.0;c[m+288+4>>2]=35;c[m+288+8>>2]=0;c[m+288+12>>2]=1065353216;c[m+288+16>>2]=1065353216;c[m+288+20>>2]=1065353216;g[m+288+24>>2]=0.0;c[m+288>>2]=3436;c[m+288+52>>2]=d;g[m+288+44>>2]=0.0;if((a[22456]|0)==0?Wa(22456)|0:0){if((a[22464]|0)==0?Wa(22464)|0:0){c[5698]=1065353216;c[5699]=0;c[5700]=0;c[5701]=0;c[5702]=0;c[5703]=1065353216;c[5704]=0;c[5705]=0;c[5706]=0;c[5707]=0;c[5708]=1065353216;g[5709]=0.0;_a(22464)}c[5710]=c[5698];c[5711]=c[5699];c[5712]=c[5700];c[5713]=c[5701];c[5714]=c[5702];c[5715]=c[5703];c[5716]=c[5704];c[5717]=c[5705];c[5718]=c[5706];c[5719]=c[5707];c[5720]=c[5708];c[5721]=c[5709];c[5722]=0;c[5723]=0;c[5724]=0;c[5725]=0;_a(22456)}if((a[22456]|0)==0?Wa(22456)|0:0){if((a[22464]|0)==0?Wa(22464)|0:0){c[5698]=1065353216;c[5699]=0;c[5700]=0;c[5701]=0;c[5702]=0;c[5703]=1065353216;c[5704]=0;c[5705]=0;c[5706]=0;c[5707]=0;c[5708]=1065353216;g[5709]=0.0;_a(22464)}c[5710]=c[5698];c[5711]=c[5699];c[5712]=c[5700];c[5713]=c[5701];c[5714]=c[5702];c[5715]=c[5703];c[5716]=c[5704];c[5717]=c[5705];c[5718]=c[5706];c[5719]=c[5707];c[5720]=c[5708];c[5721]=c[5709];c[5722]=0;c[5723]=0;c[5724]=0;c[5725]=0;_a(22456)}o=+g[f+232>>2]-+g[d+232>>2];n=+g[f+236>>2]-+g[d+236>>2];g[m>>2]=+g[f+228>>2]-+g[d+228>>2];g[m+4>>2]=o;g[m+8>>2]=n;g[m+12>>2]=0.0;if(!(!(Jd(m+344|0,22840,m+288|0,22840,m,m+232|0)|0)?!(Pc(m+344|0,22840,m+288|0,22840,m,m+232|0,0)|0):0))h=18;if((h|0)==18?(k=m+16+4|0,a[m+16+152>>0]=0,c[k>>2]=0,c[k+4>>2]=0,c[k+8>>2]=0,c[k+12>>2]=0,c[k+16>>2]=0,c[k+20>>2]=0,c[m+16>>2]=3256,jd(b,m+232|0,f,0,0,d,0,0,m+16|0)|0):0){c[6435]=(c[6435]|0)+1;d=yc(235)|0;if(!d)k=0;else{c[(d+4+15&-16)+-4>>2]=d;k=d+4+15&-16}d=k+152|0;Qn(k|0,0,156)|0;c[k>>2]=3256;e=k+4|0;f=m+16+4|0;h=e+100|0;do{c[e>>2]=c[f>>2];e=e+4|0;f=f+4|0}while((e|0)<(h|0));e=k+104|0;c[e>>2]=c[m+16+104>>2];c[e+4>>2]=c[m+16+104+4>>2];c[e+8>>2]=c[m+16+104+8>>2];c[e+12>>2]=c[m+16+104+12>>2];e=k+120|0;c[e>>2]=c[m+16+120>>2];c[e+4>>2]=c[m+16+120+4>>2];c[e+8>>2]=c[m+16+120+8>>2];c[e+12>>2]=c[m+16+120+12>>2];e=k+136|0;c[e>>2]=c[m+16+136>>2];c[e+4>>2]=c[m+16+136+4>>2];c[e+8>>2]=c[m+16+136+8>>2];c[e+12>>2]=c[m+16+136+12>>2];a[d>>0]=a[m+16+152>>0]|0;e=k+156|0;f=m+16+156|0;h=e+60|0;do{c[e>>2]=c[f>>2];e=e+4|0;f=f+4|0}while((e|0)<(h|0));h=c[b+24>>2]|0;j=k;d=c[h+852>>2]|0;if((d|0)==(c[h+856>>2]|0)?(l=d|0?d<<1:1,(d|0)<(l|0)):0){if(!l)f=0;else{c[6435]=(c[6435]|0)+1;d=yc((l<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f=d;d=c[h+852>>2]|0}if((d|0)>0){e=0;do{c[f+(e<<2)>>2]=c[(c[h+860>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(d|0))}e=c[h+860>>2]|0;if(e){if(a[h+864>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);d=c[h+852>>2]|0}c[h+860>>2]=0}a[h+864>>0]=1;c[h+860>>2]=f;c[h+856>>2]=l}c[(c[h+860>>2]|0)+(d<<2)>>2]=j;c[h+852>>2]=d+1;j=c[b+24>>2]|0;l=c[b+28>>2]|0;n=+g[j+348>>2];o=+g[l+348>>2];b=k+64|0;g[b>>2]=+g[b>>2]*(n>o?n:o);b=k+68|0;g[b>>2]=+g[b>>2]*(+g[j+360>>2]+ +g[l+360>>2])*.5}i=m;return}function Sd(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0.0,q=0.0,r=0.0;if(a[b+165>>0]|0){f=c[b+88>>2]|0;a:do if((f|0)>0&e){h=c[b+96>>2]|0;m=+g[d>>2];j=+g[d+4>>2];k=+g[d+8>>2];l=+g[b+168>>2];e=0;while(1){r=+g[h+(e<<4)>>2]-m;q=+g[h+(e<<4)+4>>2]-j;p=+g[h+(e<<4)+8>>2]-k;if(r*r+q*q+p*p<=l)break;e=e+1|0;if((e|0)>=(f|0))break a}return e|0}while(0);o=(c[b+32>>2]|0)+12|0;c[o>>2]=(c[o>>2]|0)+1;if((f|0)==(c[b+92>>2]|0)?(i=f|0?f<<1:1,(f|0)<(i|0)):0){if(!i)e=0;else{c[6435]=(c[6435]|0)+1;e=yc((i<<4|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[b+88>>2]|0}if((f|0)>0){h=0;do{o=e+(h<<4)|0;n=(c[b+96>>2]|0)+(h<<4)|0;c[o>>2]=c[n>>2];c[o+4>>2]=c[n+4>>2];c[o+8>>2]=c[n+8>>2];c[o+12>>2]=c[n+12>>2];h=h+1|0}while((h|0)!=(f|0))}f=c[b+96>>2]|0;if(f|0){if(a[b+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=e;c[b+92>>2]=i;e=c[b+88>>2]|0}else e=f;o=(c[b+96>>2]|0)+(e<<4)|0;c[o>>2]=c[d>>2];c[o+4>>2]=c[d+4>>2];c[o+8>>2]=c[d+8>>2];c[o+12>>2]=c[d+12>>2];d=c[b+88>>2]|0;c[b+88>>2]=d+1;c[(c[b+32>>2]|0)+16>>2]=c[b+96>>2];return d|0}h=c[b+108>>2]|0;b:do if((h|0)>0&e){e=c[b+116>>2]|0;j=+g[d>>2];k=+g[d+4>>2];l=+g[d+8>>2];m=+g[b+168>>2];i=0;while(1){p=+g[e+(i<<2)>>2]-j;q=+g[e+(i+1<<2)>>2]-k;r=+g[e+(i+2<<2)>>2]-l;f=i+3|0;if(p*p+q*q+r*r<=m)break;if((f|0)<(h|0))i=f;else break b}d=(i|0)/3|0;return d|0}while(0);e=c[b+112>>2]|0;if((h|0)==(e|0)){n=h|0?h<<1:1;if((h|0)<(n|0)){if(!n)e=0;else{c[6435]=(c[6435]|0)+1;e=yc((n<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=c[b+108>>2]|0}i=c[b+116>>2]|0;if((h|0)<=0)if(!i)f=b+120|0;else o=34;else{f=0;do{c[e+(f<<2)>>2]=c[i+(f<<2)>>2];f=f+1|0}while((f|0)!=(h|0));o=34}if((o|0)==34){if(a[b+120>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[i+-4>>2]|0)}c[b+116>>2]=0;f=b+120|0}a[f>>0]=1;c[b+116>>2]=e;c[b+112>>2]=n;f=c[b+108>>2]|0;h=n}else f=h}else{f=h;h=e}c[(c[b+116>>2]|0)+(f<<2)>>2]=c[d>>2];e=f+1|0;c[b+108>>2]=e;if((e|0)==(h|0)){n=h|0?h<<1:1;if((h|0)<(n|0)){if(!n)e=0;else{c[6435]=(c[6435]|0)+1;e=yc((n<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=c[b+108>>2]|0}i=c[b+116>>2]|0;if((h|0)<=0)if(!i)f=b+120|0;else o=48;else{f=0;do{c[e+(f<<2)>>2]=c[i+(f<<2)>>2];f=f+1|0}while((f|0)!=(h|0));o=48}if((o|0)==48){if(a[b+120>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[i+-4>>2]|0)}c[b+116>>2]=0;f=b+120|0}a[f>>0]=1;c[b+116>>2]=e;c[b+112>>2]=n;e=c[b+108>>2]|0;h=n}else e=h}c[(c[b+116>>2]|0)+(e<<2)>>2]=c[d+4>>2];e=e+1|0;c[b+108>>2]=e;if((e|0)==(h|0)){n=h|0?h<<1:1;if((h|0)<(n|0)){if(!n)e=0;else{c[6435]=(c[6435]|0)+1;e=yc((n<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=c[b+108>>2]|0}i=c[b+116>>2]|0;if((h|0)<=0)if(!i)f=b+120|0;else o=62;else{f=0;do{c[e+(f<<2)>>2]=c[i+(f<<2)>>2];f=f+1|0}while((f|0)!=(h|0));o=62}if((o|0)==62){if(a[b+120>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[i+-4>>2]|0)}c[b+116>>2]=0;f=b+120|0}a[f>>0]=1;c[b+116>>2]=e;c[b+112>>2]=n;e=c[b+108>>2]|0}else e=h}o=c[b+116>>2]|0;c[o+(e<<2)>>2]=c[d+8>>2];d=e+1|0;c[b+108>>2]=d;b=c[b+32>>2]|0;c[b+12>>2]=(c[b+12>>2]|0)+1;c[b+16>>2]=o;d=((d|0)/3|0)+-1|0;return d|0}function Td(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0;k=i;i=i+16|0;if(!(a[b+1308>>0]|0)){i=k;return}g[b+928>>2]=0.0;g[b+992>>2]=0.0;g[b+1056>>2]=0.0;c[b+712>>2]=0;c[b+712+4>>2]=0;c[b+712+8>>2]=0;c[b+712+12>>2]=0;sd(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);Ab[c[(c[b>>2]|0)+44>>2]&255](b);e=+g[b+1284>>2];f=+g[b+1288>>2];h=+g[b+1292>>2];if(+g[b+696>>2]>=+g[b+680>>2]){l=(a[b+1300>>0]|0)==0;j=c[(l?b+1160|0:b+1096|0)>>2]|0;d=c[(l?b+1144|0:b+1080|0)>>2]|0;c[k>>2]=c[(l?b+1128|0:b+1064|0)>>2];c[k+4>>2]=d;c[k+8>>2]=j;g[k+12>>2]=0.0;Lh(c[b+28>>2]|0,c[b+32>>2]|0,b+176|0,k,e,f,h,e,f,h)}if(+g[b+700>>2]>=+g[b+684>>2]){d=(a[b+1300>>0]|0)==0;l=c[(d?b+1164|0:b+1100|0)>>2]|0;j=c[(d?b+1148|0:b+1084|0)>>2]|0;c[k>>2]=c[(d?b+1132|0:b+1068|0)>>2];c[k+4>>2]=j;c[k+8>>2]=l;g[k+12>>2]=0.0;Lh(c[b+28>>2]|0,c[b+32>>2]|0,b+260|0,k,e,f,h,e,f,h)}if(+g[b+704>>2]>=+g[b+688>>2]){d=(a[b+1300>>0]|0)==0;l=c[(d?b+1168|0:b+1104|0)>>2]|0;j=c[(d?b+1152|0:b+1088|0)>>2]|0;c[k>>2]=c[(d?b+1136|0:b+1072|0)>>2];c[k+4>>2]=j;c[k+8>>2]=l;g[k+12>>2]=0.0;Lh(c[b+28>>2]|0,c[b+32>>2]|0,b+344|0,k,e,f,h,e,f,h)}j=0;do{e=+g[b+868+(j<<6)>>2];f=+g[b+868+(j<<6)+4>>2];h=+ik(+g[b+1192+(j<<2)>>2],e,f);g[b+868+(j<<6)+52>>2]=h;do if(!(e>f)){if(e>h){c[b+868+(j<<6)+56>>2]=1;d=b+868+(j<<6)+48|0;g[d>>2]=h-e;if(h-e>3.1415927410125732){g[d>>2]=h-e+-6.2831854820251465;d=19;break}if(!(h-e<-3.1415927410125732)){d=19;break}g[d>>2]=h-e+6.2831854820251465;d=19;break}d=b+868+(j<<6)+56|0;if(!(f<h)){c[d>>2]=0;d=18;break}c[d>>2]=2;d=b+868+(j<<6)+48|0;g[d>>2]=h-f;if(h-f>3.1415927410125732){g[d>>2]=h-f+-6.2831854820251465;d=19;break}if(h-f<-3.1415927410125732){g[d>>2]=h-f+6.2831854820251465;d=19}else d=19}else{c[b+868+(j<<6)+56>>2]=0;d=18}while(0);if((d|0)==18?(d=0,a[b+868+(j<<6)+44>>0]|0):0)d=19;if((d|0)==19){K=b+1208+(j<<4)|0;c[k>>2]=c[K>>2];c[k+4>>2]=c[K+4>>2];c[k+8>>2]=c[K+8>>2];c[k+12>>2]=c[K+12>>2];K=b+428+(j*84|0)|0;d=c[b+28>>2]|0;J=+g[d+4>>2];I=+g[d+20>>2];H=+g[d+36>>2];F=+g[d+8>>2];E=+g[d+24>>2];D=+g[d+40>>2];B=+g[d+12>>2];A=+g[d+28>>2];z=+g[d+44>>2];l=c[b+32>>2]|0;x=+g[l+4>>2];w=+g[l+20>>2];v=+g[l+36>>2];t=+g[l+8>>2];s=+g[l+24>>2];r=+g[l+40>>2];p=+g[l+12>>2];n=+g[l+28>>2];e=+g[l+44>>2];c[K>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;o=+g[k>>2];m=+g[k+4>>2];f=+g[k+8>>2];g[b+428+(j*84|0)+16>>2]=J*o+I*m+H*f;g[b+428+(j*84|0)+20>>2]=F*o+E*m+D*f;g[b+428+(j*84|0)+24>>2]=B*o+A*m+z*f;g[b+428+(j*84|0)+28>>2]=0.0;g[b+428+(j*84|0)+32>>2]=x*-o+w*-m+v*-f;g[b+428+(j*84|0)+36>>2]=t*-o+s*-m+r*-f;g[b+428+(j*84|0)+40>>2]=p*-o+n*-m+e*-f;g[b+428+(j*84|0)+44>>2]=0.0;G=(J*o+I*m+H*f)*+g[d+396>>2];C=(F*o+E*m+D*f)*+g[d+400>>2];y=(B*o+A*m+z*f)*+g[d+404>>2];g[b+428+(j*84|0)+48>>2]=G;g[b+428+(j*84|0)+52>>2]=C;g[b+428+(j*84|0)+56>>2]=y;g[b+428+(j*84|0)+60>>2]=0.0;u=(x*-o+w*-m+v*-f)*+g[l+396>>2];q=(t*-o+s*-m+r*-f)*+g[l+400>>2];h=(p*-o+n*-m+e*-f)*+g[l+404>>2];g[b+428+(j*84|0)+64>>2]=u;g[b+428+(j*84|0)+68>>2]=q;g[b+428+(j*84|0)+72>>2]=h;g[b+428+(j*84|0)+76>>2]=0.0;g[b+428+(j*84|0)+80>>2]=(J*o+I*m+H*f)*G+(F*o+E*m+D*f)*C+(B*o+A*m+z*f)*y+((x*-o+w*-m+v*-f)*u+(t*-o+s*-m+r*-f)*q+(p*-o+n*-m+e*-f)*h)}j=j+1|0}while((j|0)!=3);i=k;return}function Ud(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0,q=0,r=0,s=0;p=i;i=i+128|0;c[b+68>>2]=(c[b+68>>2]|0)+1;c[p>>2]=c[d>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];c[p+12>>2]=c[d+12>>2];c[p+16>>2]=c[d+16>>2];c[p+16+4>>2]=c[d+16+4>>2];c[p+16+8>>2]=c[d+16+8>>2];c[p+16+12>>2]=c[d+16+12>>2];c[p+32>>2]=c[d+32>>2];c[p+32+4>>2]=c[d+32+4>>2];c[p+32+8>>2]=c[d+32+8>>2];c[p+32+12>>2]=c[d+32+12>>2];c[p+48>>2]=c[d+48>>2];c[p+48+4>>2]=c[d+48+4>>2];c[p+48+8>>2]=c[d+48+8>>2];c[p+48+12>>2]=c[d+48+12>>2];n=c[e+4>>2]|0;o=+Sb[c[(c[e>>2]|0)+48>>2]&15](e);mc[c[(c[e>>2]|0)+8>>2]&127](e,d,p+112|0,p+96|0);f=+g[p+112>>2];if(+g[b+32>>2]>f)g[b+32>>2]=f;f=+g[p+96>>2];if(+g[b+48>>2]<f)g[b+48>>2]=f;f=+g[p+112+4>>2];if(+g[b+36>>2]>f)g[b+36>>2]=f;f=+g[p+96+4>>2];if(+g[b+52>>2]<f)g[b+52>>2]=f;f=+g[p+112+8>>2];if(+g[b+40>>2]>f)g[b+40>>2]=f;f=+g[p+96+8>>2];if(+g[b+56>>2]<f)g[b+56>>2]=f;l=c[b+64>>2]|0;if(!l){l=b+16|0;k=0}else{c[p+64>>2]=c[p+112>>2];c[p+64+4>>2]=c[p+112+4>>2];c[p+64+8>>2]=c[p+112+8>>2];c[p+64+12>>2]=c[p+112+12>>2];c[p+64+16>>2]=c[p+96>>2];c[p+64+16+4>>2]=c[p+96+4>>2];c[p+64+16+8>>2]=c[p+96+8>>2];c[p+64+16+12>>2]=c[p+96+12>>2];k=c[b+16>>2]|0;d=c[l+4>>2]|0;if(!d){c[6435]=(c[6435]|0)+1;d=yc(63)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}h=d;j=h+44|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(j|0))}else c[l+4>>2]=0;c[d+32>>2]=0;c[d+36>>2]=k;c[d+40>>2]=0;c[d>>2]=c[p+64>>2];c[d+4>>2]=c[p+64+4>>2];c[d+8>>2]=c[p+64+8>>2];c[d+12>>2]=c[p+64+12>>2];c[d+16>>2]=c[p+64+16>>2];c[d+20>>2]=c[p+64+20>>2];c[d+24>>2]=c[p+64+24>>2];c[d+28>>2]=c[p+64+28>>2];lf(l,c[l>>2]|0,d);c[l+12>>2]=(c[l+12>>2]|0)+1;l=b+16|0;k=d}d=c[l>>2]|0;if((d|0)==(c[b+20>>2]|0)?(m=d|0?d<<1:1,(d|0)<(m|0)):0){if(!m)j=0;else{c[6435]=(c[6435]|0)+1;d=yc((m*80|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}j=d;d=c[l>>2]|0}if((d|0)>0){h=0;do{q=j+(h*80|0)|0;r=c[b+24>>2]|0;s=r+(h*80|0)|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=j+(h*80|0)+16|0;s=r+(h*80|0)+16|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=j+(h*80|0)+32|0;s=r+(h*80|0)+32|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=j+(h*80|0)+48|0;s=r+(h*80|0)+48|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];q=j+(h*80|0)+64|0;r=r+(h*80|0)+64|0;c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];h=h+1|0}while((h|0)!=(d|0))}d=c[b+24>>2]|0;if(d|0){if(a[b+28>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+24>>2]=0}a[b+28>>0]=1;c[b+24>>2]=j;c[b+20>>2]=m;d=c[l>>2]|0}s=c[b+24>>2]|0;r=s+(d*80|0)|0;c[r>>2]=c[p>>2];c[r+4>>2]=c[p+4>>2];c[r+8>>2]=c[p+8>>2];c[r+12>>2]=c[p+12>>2];r=s+(d*80|0)+16|0;c[r>>2]=c[p+16>>2];c[r+4>>2]=c[p+16+4>>2];c[r+8>>2]=c[p+16+8>>2];c[r+12>>2]=c[p+16+12>>2];r=s+(d*80|0)+32|0;c[r>>2]=c[p+32>>2];c[r+4>>2]=c[p+32+4>>2];c[r+8>>2]=c[p+32+8>>2];c[r+12>>2]=c[p+32+12>>2];r=s+(d*80|0)+48|0;c[r>>2]=c[p+48>>2];c[r+4>>2]=c[p+48+4>>2];c[r+8>>2]=c[p+48+8>>2];c[r+12>>2]=c[p+48+12>>2];s=s+(d*80|0)+64|0;c[s>>2]=e;c[s+4>>2]=n;g[s+8>>2]=o;c[s+12>>2]=k;c[l>>2]=(c[l>>2]|0)+1;i=p;return}function Vd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;while(1){p=(b+d|0)/2|0;m=c[a+12>>2]|0;n=c[m+(p<<4)>>2]|0;o=c[m+(p<<4)+4>>2]|0;p=c[m+(p<<4)+8>>2]|0;e=b;f=d;while(1){a:do if(!n)while(1){j=c[m+(e<<4)>>2]|0;if(!j)g=-1;else g=c[j+12>>2]|0;k=c[m+(e<<4)+4>>2]|0;if(!k)h=-1;else h=c[k+12>>2]|0;if(!o)i=-1;else i=c[o+12>>2]|0;do if((g|0)<=-1){g=(h|0)>(i|0);if(g|(j|0)==0^1)if((j|0)==0&g)break;else break a;if((k|0)!=(o|0))break a;if((c[m+(e<<4)+8>>2]|0)>>>0<=p>>>0)break a}while(0);e=e+1|0}else{l=c[n+12>>2]|0;if(!o)while(1){i=c[m+(e<<4)>>2]|0;if(!i)g=-1;else g=c[i+12>>2]|0;j=c[m+(e<<4)+4>>2]|0;if(!j)h=-1;else h=c[j+12>>2]|0;do if((g|0)<=(l|0)){g=(h|0)>-1;if(g|(i|0)==(n|0)^1)if((i|0)==(n|0)&g)break;else break a;if(j|0)break a;if((c[m+(e<<4)+8>>2]|0)>>>0<=p>>>0)break a}while(0);e=e+1|0}k=c[o+12>>2]|0;while(1){i=c[m+(e<<4)>>2]|0;if(!i)g=-1;else g=c[i+12>>2]|0;j=c[m+(e<<4)+4>>2]|0;if(!j)h=-1;else h=c[j+12>>2]|0;do if((g|0)<=(l|0)){g=(h|0)>(k|0);if(g|(i|0)==(n|0)^1)if((i|0)==(n|0)&g)break;else break a;if((j|0)!=(o|0))break a;if((c[m+(e<<4)+8>>2]|0)>>>0<=p>>>0)break a}while(0);e=e+1|0}}while(0);b:do if(!n)while(1){j=c[m+(f<<4)>>2]|0;if(!j)g=-1;else g=c[j+12>>2]|0;if(!o)h=-1;else h=c[o+12>>2]|0;k=c[m+(f<<4)+4>>2]|0;if(!k)i=-1;else i=c[k+12>>2]|0;do if((g|0)>=-1){g=(h|0)>(i|0);if(g|(j|0)==0^1)if((j|0)==0&g)break;else break b;if((o|0)!=(k|0))break b;if(p>>>0<=(c[m+(f<<4)+8>>2]|0)>>>0)break b}while(0);f=f+-1|0}else{l=c[n+12>>2]|0;if(!o)while(1){i=c[m+(f<<4)>>2]|0;if(!i)g=-1;else g=c[i+12>>2]|0;j=c[m+(f<<4)+4>>2]|0;if(!j)h=-1;else h=c[j+12>>2]|0;do if((l|0)<=(g|0)){g=(h|0)<-1;if(g|(n|0)==(i|0)^1)if((n|0)==(i|0)&g)break;else break b;if(j|0)break b;if(p>>>0<=(c[m+(f<<4)+8>>2]|0)>>>0)break b}while(0);f=f+-1|0}k=c[o+12>>2]|0;while(1){i=c[m+(f<<4)>>2]|0;if(!i)g=-1;else g=c[i+12>>2]|0;j=c[m+(f<<4)+4>>2]|0;if(!j)h=-1;else h=c[j+12>>2]|0;do if((l|0)<=(g|0)){g=(k|0)>(h|0);if(g|(n|0)==(i|0)^1)if((n|0)==(i|0)&g)break;else break b;if((o|0)!=(j|0))break b;if(p>>>0<=(c[m+(f<<4)+8>>2]|0)>>>0)break b}while(0);f=f+-1|0}}while(0);if((e|0)<=(f|0)){h=m+(e<<4)|0;i=c[h>>2]|0;j=c[m+(e<<4)+4>>2]|0;k=c[m+(e<<4)+8>>2]|0;l=c[m+(e<<4)+12>>2]|0;m=m+(f<<4)|0;c[h>>2]=c[m>>2];c[h+4>>2]=c[m+4>>2];c[h+8>>2]=c[m+8>>2];c[h+12>>2]=c[m+12>>2];m=c[a+12>>2]|0;c[m+(f<<4)>>2]=i;c[m+(f<<4)+4>>2]=j;c[m+(f<<4)+8>>2]=k;c[m+(f<<4)+12>>2]=l;e=e+1|0;f=f+-1|0}if((e|0)>(f|0))break;m=c[a+12>>2]|0}if((f|0)>(b|0))Vd(a,b,f);if((e|0)<(d|0))b=e;else break}return}function Wd(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0,B=0,C=0,D=0,E=0;D=i;i=i+16|0;li(11054);C=c[a+712>>2]|0;if((C|0)>0){c[6435]=(c[6435]|0)+1;d=yc((C<<4|3)+16|0)|0;if(!d)h=0;else{c[(d+4+15&-16)+-4>>2]=d;h=d+4+15&-16}d=0;do{B=h+(d<<4)|0;d=d+1|0;c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;c[B+12>>2]=0}while((d|0)!=(C|0));f=c[a+712>>2]|0;if((f|0)>0){c[6435]=(c[6435]|0)+1;d=yc((f<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}Qn(d|0,0,f<<2|0)|0;B=h;A=d}else{B=h;A=0}}else{B=0;A=0}s=c[a+1112>>2]|0;if(b){if((s|0)>0){h=c[a+1120>>2]|0;j=0;do{d=c[h+(j<<2)>>2]|0;f=c[d+312>>2]|0;if(f|0){g[d+276>>2]=1.0/+(f|0)*+g[d+276>>2];g[d+280>>2]=1.0/+(f|0)*+g[d+280>>2];g[d+284>>2]=1.0/+(f|0)*+g[d+284>>2];g[d+292>>2]=+g[d+292>>2]*(1.0/+(f|0));g[d+296>>2]=1.0/+(f|0)*+g[d+296>>2];g[d+300>>2]=1.0/+(f|0)*+g[d+300>>2]}j=j+1|0}while((j|0)!=(s|0));j=13}}else j=13;if((j|0)==13?(s|0)>0:0){l=c[a+1120>>2]|0;if(b){b=0;do{d=c[l+(b<<2)>>2]|0;if((c[d+312>>2]|0)>0?(y=+g[a+452>>2],t=+g[d+276>>2]*y,u=y*+g[d+280>>2],v=y*+g[d+284>>2],w=y*+g[d+292>>2],x=y*+g[d+296>>2],y=y*+g[d+300>>2],z=c[d+24>>2]|0,(z|0)>0):0){f=c[d+32>>2]|0;h=c[a+720>>2]|0;j=c[d+12>>2]|0;k=0;do{r=c[f+(k<<2)>>2]|0;q=+g[j+(k<<2)>>2];p=+g[r+8>>2]-+g[d+228>>2];o=+g[r+12>>2]-+g[d+232>>2];n=+g[r+16>>2]-+g[d+236>>2];E=B+(((r-h|0)/104|0)<<4)|0;g[E>>2]=+g[E>>2]+q*(t+(x*n-y*o));E=B+(((r-h|0)/104|0)<<4)+4|0;g[E>>2]=+g[E>>2]+q*(u+(y*p-w*n));E=B+(((r-h|0)/104|0)<<4)+8|0;g[E>>2]=q*(v+(w*o-x*p))+ +g[E>>2];r=A+(((r-h|0)/104|0)<<2)|0;g[r>>2]=q+ +g[r>>2];k=k+1|0}while((k|0)!=(z|0))}b=b+1|0}while((b|0)!=(s|0))}else{b=0;do{d=c[l+(b<<2)>>2]|0;if((c[d+308>>2]|0)>0?(q=+g[a+452>>2],e=+g[d+244>>2]*q,m=q*+g[d+248>>2],n=q*+g[d+252>>2],o=q*+g[d+260>>2],p=q*+g[d+264>>2],q=q*+g[d+268>>2],r=c[d+24>>2]|0,(r|0)>0):0){f=c[d+32>>2]|0;h=c[a+720>>2]|0;j=c[d+12>>2]|0;k=0;do{E=c[f+(k<<2)>>2]|0;y=+g[j+(k<<2)>>2];x=+g[E+8>>2]-+g[d+228>>2];w=+g[E+12>>2]-+g[d+232>>2];v=+g[E+16>>2]-+g[d+236>>2];z=B+(((E-h|0)/104|0)<<4)|0;g[z>>2]=+g[z>>2]+y*(e+(p*v-q*w));z=B+(((E-h|0)/104|0)<<4)+4|0;g[z>>2]=+g[z>>2]+y*(m+(q*x-o*v));z=B+(((E-h|0)/104|0)<<4)+8|0;g[z>>2]=y*(n+(o*w-p*x))+ +g[z>>2];E=A+(((E-h|0)/104|0)<<2)|0;g[E>>2]=y+ +g[E>>2];k=k+1|0}while((k|0)!=(r|0))}b=b+1|0}while((b|0)!=(s|0))}}if((C|0)>0){d=0;do{e=+g[A+(d<<2)>>2];if(e>0.0){E=c[a+720>>2]|0;x=1.0/e*+g[B+(d<<4)+4>>2];y=1.0/e*+g[B+(d<<4)+8>>2];z=E+(d*104|0)+8|0;g[z>>2]=1.0/e*+g[B+(d<<4)>>2]+ +g[z>>2];z=E+(d*104|0)+12|0;g[z>>2]=x+ +g[z>>2];E=E+(d*104|0)+16|0;g[E>>2]=y+ +g[E>>2]}d=d+1|0}while((d|0)!=(C|0))}if(A|0){c[6436]=(c[6436]|0)+1;hd(c[A+-4>>2]|0)}if(B|0){c[6436]=(c[6436]|0)+1;hd(c[B+-4>>2]|0)}d=c[2357]|0;E=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=E;if(E|0){i=D;return}do if(c[d+4>>2]|0){tb(D|0,0)|0;E=c[6434]|0;g[d+8>>2]=+g[d+8>>2]+ +(((c[D+4>>2]|0)-(c[E+4>>2]|0)+(((c[D>>2]|0)-(c[E>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[d+16>>2]|0)){d=c[2357]|0;break}else{i=D;return}}while(0);c[2357]=c[d+20>>2];i=D;return}function Xd(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0,m=0.0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0;C=i;i=i+304|0;B=+g[e+48>>2]-+g[d+48>>2];z=+g[e+52>>2]-+g[d+52>>2];A=+g[e+56>>2]-+g[d+56>>2];Gf(d,e,C+288|0,C+240|0);v=+g[C+240>>2];t=+g[C+288>>2]*v;u=v*+g[C+288+4>>2];v=v*+g[C+288+8>>2];g[C+208>>2]=t;g[C+208+4>>2]=u;g[C+208+8>>2]=v;g[C+208+12>>2]=0.0;w=+g[h+48>>2]-+g[f+48>>2];x=+g[h+52>>2]-+g[f+52>>2];y=+g[h+56>>2]-+g[f+56>>2];Gf(f,h,C+288|0,C+240|0);r=+g[C+240>>2];p=+g[C+288>>2]*r;q=r*+g[C+288+4>>2];r=r*+g[C+288+8>>2];g[C+192>>2]=p;g[C+192+4>>2]=q;g[C+192+8>>2]=r;g[C+192+12>>2]=0.0;e=c[b+12>>2]|0;s=+Sb[c[(c[e>>2]|0)+16>>2]&15](e);e=c[b+16>>2]|0;if(!e)m=0.0;else m=+Sb[c[(c[e>>2]|0)+16>>2]&15](e);s=s*+O(+(t*t+u*u+v*v))+m*+O(+(p*p+q*q+r*r));if(s+ +O(+((w-B)*(w-B)+(x-z)*(x-z)+(y-A)*(y-A)))==0.0){j=0;i=C;return j|0}c[C+240>>2]=9160;g[C+240+36>>2]=999999984306749440.0;a[C+240+40>>0]=0;Ld(b,d,f,C+240|0);h=(a[C+240+40>>0]|0)==0;c[C+288>>2]=c[C+240+20>>2];c[C+288+4>>2]=c[C+240+20+4>>2];c[C+288+8>>2]=c[C+240+20+8>>2];c[C+288+12>>2]=c[C+240+20+12>>2];a:do if(!h?(o=c[C+240+4>>2]|0,l=c[C+240+8>>2]|0,n=c[C+240+12>>2]|0,v=(w-B)*(c[k>>2]=o,+g[k>>2]),v=v+(x-z)*(c[k>>2]=l,+g[k>>2]),!(s+(v+(y-A)*(c[k>>2]=n,+g[k>>2]))<=1.1920928955078125e-07)):0){m=+g[C+240+16>>2];p=+g[C+240+36>>2]+ +g[j+172>>2];b:do if(p>1.0000000474974513e-03){q=p;r=0.0;h=0;while(1){e=c[j+168>>2]|0;if(e|0){D=c[(c[e>>2]|0)+20>>2]|0;c[C+224>>2]=1065353216;c[C+224+4>>2]=1065353216;c[C+224+8>>2]=1065353216;g[C+224+12>>2]=0.0;Fb[D&7](e,C+288|0,.20000000298023224,C+224|0)}m=(w-B)*(c[k>>2]=o,+g[k>>2]);m=m+(x-z)*(c[k>>2]=l,+g[k>>2]);m=s+(m+(y-A)*(c[k>>2]=n,+g[k>>2]));if(m<=1.1920928955078125e-07){l=0;break a}p=r+q/m;if(!(!(p<=r)&(!(p<0.0)&!(p>1.0)))){l=0;break a}Zg(d,B,z,A,C+208|0,p,C+112|0);Zg(f,w,x,y,C+192|0,p,C+48|0);l=c[j+168>>2]|0;if(l|0){D=c[(c[l>>2]|0)+20>>2]|0;c[C+176>>2]=1065353216;c[C+176+4>>2]=0;c[C+176+8>>2]=0;g[C+176+12>>2]=0.0;Fb[D&7](l,C+112+48|0,.20000000298023224,C+176|0)}zb[c[c[j>>2]>>2]&31](j,p);c[C>>2]=9160;g[C+36>>2]=999999984306749440.0;a[C+40>>0]=0;Ld(b,C+112|0,C+48|0,C);if(!(a[C+40>>0]|0)){l=15;break}m=+g[C+36>>2];q=+g[j+172>>2];c[C+288>>2]=c[C+20>>2];c[C+288+4>>2]=c[C+20+4>>2];c[C+288+8>>2]=c[C+20+8>>2];c[C+288+12>>2]=c[C+20+12>>2];e=h+1|0;if((h|0)>63){l=16;break}n=c[C+12>>2]|0;l=c[C+8>>2]|0;o=c[C+4>>2]|0;q=m+q;if(!(q>1.0000000474974513e-03)){m=+g[C+16>>2];break b}else{r=p;h=e}}if((l|0)==15)ic[c[(c[j>>2]|0)+8>>2]&127](j,-1,h);else if((l|0)==16)ic[c[(c[j>>2]|0)+8>>2]&127](j,-2,e);l=0;break a}else p=0.0;while(0);g[j+164>>2]=p;c[j+132>>2]=o;c[j+136>>2]=l;c[j+140>>2]=n;g[j+144>>2]=m;c[j+148>>2]=c[C+288>>2];c[j+148+4>>2]=c[C+288+4>>2];c[j+148+8>>2]=c[C+288+8>>2];c[j+148+12>>2]=c[C+288+12>>2];l=1}else l=0;while(0);D=l;i=C;return D|0}function Yd(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0,i=0,j=0.0,l=0.0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0,x=0.0,y=0,z=0.0,A=0.0,B=0.0;c[a+556>>2]=c[b>>2];c[a+556+4>>2]=c[b+4>>2];c[a+556+8>>2]=c[b+8>>2];c[a+556+12>>2]=c[b+12>>2];q=+g[a+568>>2];r=+g[a+560>>2];s=+g[a+564>>2];p=+g[a+556>>2];d=-p-r*0.0-s*0.0;e=(s+q*0.0-p*0.0)*-s+(q*(q+r*0.0-s*0.0)+d*-p)-(q*0.0+p*0.0-r)*-r;f=(q*0.0+p*0.0-r)*-p+(q*(s+q*0.0-p*0.0)+d*-r)-(q+r*0.0-s*0.0)*-s;d=(q+r*0.0-s*0.0)*-r+(d*-s+q*(q*0.0+p*0.0-r))-(s+q*0.0-p*0.0)*-p;if(d*0.0+(f*0.0+e)<-.9999998807907104){j=-0.0;l=1.0;d=0.0;e=0.0}else{B=+O(+((d*0.0+(f*0.0+e)+1.0)*2.0));j=(d*0.0-f*0.0)*(1.0/B);l=(e*0.0-d)*(1.0/B);d=(f-e*0.0)*(1.0/B);e=B*.5}z=1.0/+O(+(e*e+(j*j+l*l+d*d)));j=j*z;n=(g[k>>2]=j,c[k>>2]|0);w=l*z;t=d*z;v=(g[k>>2]=t,c[k>>2]|0);d=e*z;u=(g[k>>2]=d,c[k>>2]|0);e=1.0/+O(+((d*q-p*-j-r*-w-s*-t)*(d*q-p*-j-r*-w-s*-t)+((q*-t+d*s+r*-j-p*-w)*(q*-t+d*s+r*-j-p*-w)+((p*d+q*-j+s*-w-r*-t)*(p*d+q*-j+s*-w-r*-t)+(p*-t+(q*-w+d*r)-s*-j)*(p*-t+(q*-w+d*r)-s*-j)))));z=(p*d+q*-j+s*-w-r*-t)*e;i=(g[k>>2]=z,c[k>>2]|0);A=e*(p*-t+(q*-w+d*r)-s*-j);b=(g[k>>2]=A,c[k>>2]|0);B=e*(q*-t+d*s+r*-j-p*-w);h=(g[k>>2]=B,c[k>>2]|0);p=e*(d*q-p*-j-r*-w-s*-t);e=+g[a+444>>2];m=(g[k>>2]=e,c[k>>2]|0);if(e>=.05000000074505806?(x=+g[a+448>>2],x>=.05000000074505806):0){d=d<-1.0?-1.0:d;d=+T(+(d>1.0?1.0:d))*2.0;if(d>1.1920928955078125e-07){f=1.0/+O(+(t*t+(j*j+w*w)));if(+N(+(w*f))>1.1920928955078125e-07){x=+O(+((t*f*t*f/(w*f*w*f)+1.0)/(1.0/(x*x)+t*f*t*f/(w*f*w*f)/(e*e))));j=j*f;l=w*f;f=t*f;m=(g[k>>2]=x,c[k>>2]|0)}else{j=j*f;l=w*f;f=t*f}}else{j=0.0;l=0.0;f=0.0;m=0}if(+N(+d)>1.1920928955078125e-07){e=(c[k>>2]=m,+g[k>>2]);if(!(d>e)){if(d<-e)d=-e}else d=e;x=d*.5;w=+R(+x)/+O(+(j*j+l*l+f*f));x=+Q(+x);y=(g[k>>2]=j*w,c[k>>2]|0);v=(g[k>>2]=f*w,c[k>>2]|0);w=l*w;u=(g[k>>2]=x,c[k>>2]|0)}else y=n}else y=n;d=+g[a+452>>2];if(d>=.05000000074505806){e=p<-1.0?-1.0:p;e=+T(+(e>1.0?1.0:e))*2.0;if(e>3.1415927410125732){o=(g[k>>2]=-z,c[k>>2]|0);n=(g[k>>2]=-A,c[k>>2]|0);e=-p<-1.0?-1.0:-p;m=(g[k>>2]=-B,c[k>>2]|0);e=+T(+(e>1.0?1.0:e))*2.0}else{o=i;n=b;m=h}f=(c[k>>2]=o,+g[k>>2]);j=(c[k>>2]=n,+g[k>>2]);l=(c[k>>2]=m,+g[k>>2]);if(e>1.1920928955078125e-07){B=1.0/+O(+(f*f+j*j+l*l));o=(g[k>>2]=f*B,c[k>>2]|0);n=(g[k>>2]=j*B,c[k>>2]|0);m=(g[k>>2]=l*B,c[k>>2]|0)}if(+N(+e)>1.1920928955078125e-07){if(!(e>d))if(e<-d)d=-d;else d=e;x=(c[k>>2]=o,+g[k>>2]);z=(c[k>>2]=n,+g[k>>2]);A=(c[k>>2]=m,+g[k>>2]);d=d*.5;B=+R(+d)/+O(+(A*A+(z*z+x*x)));d=+Q(+d);i=(g[k>>2]=x*B,c[k>>2]|0);b=(g[k>>2]=z*B,c[k>>2]|0);h=(g[k>>2]=A*B,c[k>>2]|0)}else d=p}else d=p;s=(c[k>>2]=u,+g[k>>2]);x=(c[k>>2]=i,+g[k>>2]);t=(c[k>>2]=y,+g[k>>2]);B=(c[k>>2]=h,+g[k>>2]);A=(c[k>>2]=v,+g[k>>2]);z=(c[k>>2]=b,+g[k>>2]);g[a+556>>2]=w*B+(s*x+t*d)-A*z;g[a+560>>2]=A*x+(s*z+w*d)-t*B;g[a+564>>2]=t*z+(s*B+A*d)-w*x;g[a+568>>2]=s*d-t*x-w*z-A*B;return}function Zd(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0;c[b>>2]=5224;c[6435]=(c[6435]|0)+1;e=yc(379)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}g[e+308>>2]=9.999999747378752e-05;f=e+332|0;a[f>>0]=a[f>>0]&-16;c[b+24>>2]=e;f=(c[d+20>>2]|0)==0;c[6435]=(c[6435]|0)+1;e=yc(23)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}if(f){c[e>>2]=9072;c[b+28>>2]=e;f=b+28|0}else{c[e>>2]=9120;c[b+28>>2]=e;f=b+28|0}c[6435]=(c[6435]|0)+1;e=yc(43)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}k=c[b+24>>2]|0;l=c[f>>2]|0;a[e+4>>0]=0;c[e>>2]=6032;c[e+16>>2]=0;c[e+20>>2]=3;c[e+12>>2]=k;c[e+8>>2]=l;c[b+32>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5256;c[b+36>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5276;c[b+40>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5296;c[b+44>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5316;c[b+48>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5336;c[b+52>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5356;c[b+56>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5376;c[b+60>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5396;c[b+76>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e>>2]=5396;c[b+80>>2]=e;a[e+4>>0]=1;c[6435]=(c[6435]|0)+1;e=yc(27)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5416;c[b+72>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(35)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}a[e+4>>0]=0;c[e>>2]=5436;c[e+8>>2]=1;c[e+12>>2]=0;c[b+88>>2]=e;c[6435]=(c[6435]|0)+1;e=yc(35)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e>>2]=5436;c[e+8>>2]=1;c[e+12>>2]=0;c[b+84>>2]=e;a[e+4>>0]=1;l=c[d+16>>2]|0;l=(l|0)>80?l:80;e=c[d>>2]|0;if(!e){a[b+12>>0]=1;c[6435]=(c[6435]|0)+1;e=yc(39)|0;if(!e)k=0;else{c[(e+4+15&-16)+-4>>2]=e;k=e+4+15&-16}e=c[d+8>>2]|0;c[k>>2]=772;f=k+4|0;c[f>>2]=e;c[6435]=(c[6435]|0)+1;e=yc((e*772|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[k+16>>2]=e;c[k+12>>2]=e;f=c[f>>2]|0;c[k+8>>2]=f;if(f+-1|0){h=c[k>>2]|0;i=f+-1|0;j=e;do{m=j;j=j+h|0;c[m>>2]=j;i=i+-1|0}while((i|0)!=0);e=e+(_(h,f+-1|0)|0)|0}c[e>>2]=0;c[b+8>>2]=k}else{a[b+12>>0]=0;c[b+8>>2]=e}e=c[d+4>>2]|0;if(e|0){a[b+20>>0]=0;c[b+16>>2]=e;return}a[b+20>>0]=1;c[6435]=(c[6435]|0)+1;e=yc(39)|0;if(!e)k=0;else{c[(e+4+15&-16)+-4>>2]=e;k=e+4+15&-16}e=c[d+12>>2]|0;c[k>>2]=l;f=k+4|0;c[f>>2]=e;e=_(e,l)|0;c[6435]=(c[6435]|0)+1;e=yc(e+19|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[k+16>>2]=e;c[k+12>>2]=e;f=c[f>>2]|0;c[k+8>>2]=f;if(f+-1|0){h=c[k>>2]|0;i=f+-1|0;j=e;do{m=j;j=j+h|0;c[m>>2]=j;i=i+-1|0}while((i|0)!=0);e=e+(_(h,f+-1|0)|0)|0}c[e>>2]=0;c[b+16>>2]=k;return}function _d(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0;D=i;i=i+80|0;B=+g[e+4>>2];C=+g[e+20>>2];o=+g[e+36>>2];p=+g[e+8>>2];q=+g[e+24>>2];r=+g[e+40>>2];s=+g[e+12>>2];t=+g[e+28>>2];u=+g[e+44>>2];v=-+g[e+52>>2];w=-+g[e+56>>2];x=-+g[e+60>>2];l=c[b+720>>2]|0;y=+g[l+(d*104|0)+8>>2];z=+g[l+(d*104|0)+12>>2];A=+g[l+(d*104|0)+16>>2];a:do if(f){f=c[b+268>>2]|0;b:do if((f|0)>0){k=c[b+276>>2]|0;j=0;while(1){if((c[k+(j<<2)>>2]|0)==(e|0))break;j=j+1|0;if((j|0)>=(f|0))break b}if((j|0)!=(f|0)){f=l;break a}}while(0);if((f|0)==(c[b+272>>2]|0)?(m=f|0?f<<1:1,(f|0)<(m|0)):0){if(!m)k=0;else{c[6435]=(c[6435]|0)+1;f=yc((m<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}k=f;f=c[b+268>>2]|0}if((f|0)>0){j=0;do{c[k+(j<<2)>>2]=c[(c[b+276>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(f|0))}j=c[b+276>>2]|0;if(j){if(a[b+280>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0);f=c[b+268>>2]|0}c[b+276>>2]=0}a[b+280>>0]=1;c[b+276>>2]=k;c[b+272>>2]=m}c[(c[b+276>>2]|0)+(f<<2)>>2]=e;c[b+268>>2]=f+1;f=c[b+720>>2]|0}else f=l;while(0);l=f+(d*104|0)|0;f=f+(d*104|0)+100|0;a[f>>0]=a[f>>0]|1;f=c[b+792>>2]|0;if((f|0)==(c[b+796>>2]|0)?(n=f|0?f<<1:1,(f|0)<(n|0)):0){if(!n)k=0;else{c[6435]=(c[6435]|0)+1;f=yc(n*96|19)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}k=f;f=c[b+792>>2]|0}if((f|0)>0){j=0;do{d=k+(j*96|0)|0;m=c[b+800>>2]|0;E=m+(j*96|0)|0;c[d>>2]=c[E>>2];c[d+4>>2]=c[E+4>>2];c[d+8>>2]=c[E+8>>2];c[d+12>>2]=c[E+12>>2];c[d+16>>2]=c[E+16>>2];c[d+20>>2]=c[E+20>>2];c[d+24>>2]=c[E+24>>2];d=k+(j*96|0)+28|0;E=m+(j*96|0)+28|0;c[d>>2]=c[E>>2];c[d+4>>2]=c[E+4>>2];c[d+8>>2]=c[E+8>>2];c[d+12>>2]=c[E+12>>2];d=k+(j*96|0)+44|0;E=m+(j*96|0)+44|0;c[d>>2]=c[E>>2];c[d+4>>2]=c[E+4>>2];c[d+8>>2]=c[E+8>>2];c[d+12>>2]=c[E+12>>2];d=k+(j*96|0)+60|0;E=m+(j*96|0)+60|0;c[d>>2]=c[E>>2];c[d+4>>2]=c[E+4>>2];c[d+8>>2]=c[E+8>>2];c[d+12>>2]=c[E+12>>2];d=k+(j*96|0)+76|0;m=m+(j*96|0)+76|0;c[d>>2]=c[m>>2];c[d+4>>2]=c[m+4>>2];c[d+8>>2]=c[m+8>>2];c[d+12>>2]=c[m+12>>2];c[d+16>>2]=c[m+16>>2];j=j+1|0}while((j|0)!=(f|0))}f=c[b+800>>2]|0;if(f|0){if(a[b+804>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+800>>2]=0}a[b+804>>0]=1;c[b+800>>2]=k;c[b+796>>2]=n;f=c[b+792>>2]|0}E=c[b+800>>2]|0;c[E+(f*96|0)>>2]=l;g[E+(f*96|0)+4>>2]=B*v+C*w+o*x+(B*y+C*z+o*A);g[E+(f*96|0)+8>>2]=p*v+q*w+r*x+(p*y+q*z+r*A);g[E+(f*96|0)+12>>2]=s*v+t*w+u*x+(s*y+t*z+u*A);g[E+(f*96|0)+16>>2]=0.0;c[E+(f*96|0)+20>>2]=e;g[E+(f*96|0)+24>>2]=h;e=E+(f*96|0)+28|0;c[e>>2]=c[D+56>>2];c[e+4>>2]=c[D+56+4>>2];c[e+8>>2]=c[D+56+8>>2];c[e+12>>2]=c[D+56+12>>2];e=E+(f*96|0)+44|0;c[e>>2]=c[D+40>>2];c[e+4>>2]=c[D+40+4>>2];c[e+8>>2]=c[D+40+8>>2];c[e+12>>2]=c[D+40+12>>2];e=E+(f*96|0)+60|0;c[e>>2]=c[D+24>>2];c[e+4>>2]=c[D+24+4>>2];c[e+8>>2]=c[D+24+8>>2];c[e+12>>2]=c[D+24+12>>2];E=E+(f*96|0)+76|0;c[E>>2]=c[D>>2];c[E+4>>2]=c[D+4>>2];c[E+8>>2]=c[D+8>>2];c[E+12>>2]=c[D+12>>2];c[E+16>>2]=c[D+16>>2];c[b+792>>2]=(c[b+792>>2]|0)+1;i=D;return}function $d(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0;E=i;i=i+64|0;A=+g[b+48>>2]-+g[b+112>>2];h=+g[b+52>>2]-+g[b+116>>2];D=+g[b+56>>2]-+g[b+120>>2];B=A*+g[b+64>>2]+h*+g[b+80>>2]+D*+g[b+96>>2];C=A*+g[b+68>>2]+h*+g[b+84>>2]+D*+g[b+100>>2];D=A*+g[b+72>>2]+h*+g[b+88>>2]+D*+g[b+104>>2];e=c[a+8>>2]|0;z=c[a+4>>2]|0;h=+g[z+28>>2]*+g[z+12>>2];A=h+ +g[a+12>>2];p=+g[e+72>>2];q=+g[e+56>>2];r=+g[e+76>>2];s=+g[e+60>>2];t=+g[e+80>>2];u=+g[e+64>>2];v=+g[e+88>>2];w=+g[e+92>>2];x=+g[e+96>>2];k=(r-s)*(x-u)-(t-u)*(w-s);m=(t-u)*(v-q)-(p-q)*(x-u);o=(p-q)*(w-s)-(r-s)*(v-q);n=1.0/+O(+(o*o+(k*k+m*m)));j=(B-q)*n*k+(C-s)*n*m+n*o*(D-u);if(j<0.0){y=-j;l=-(n*k);j=-(n*m);k=-(n*o)}else{y=j;l=n*k;j=n*m;k=n*o}if(!(y<A)){i=E;return}o=(D-u)*((p-q)*j-(r-s)*l)+((B-q)*((r-s)*k-(t-u)*j)+(C-s)*((t-u)*l-(p-q)*k));t=(D-t)*((v-p)*j-(w-r)*l)+((B-p)*((w-r)*k-(x-t)*j)+(C-r)*((x-t)*l-(v-p)*k));x=(D-x)*((q-v)*j-(s-w)*l)+((B-v)*((s-w)*k-(u-x)*j)+(C-w)*((u-x)*l-(q-v)*k));if(!(x>0.0&(o>0.0&t>0.0))?!(x<=0.0&(o<=0.0&t<=0.0)):0){if((Eb[c[(c[e>>2]|0)+100>>2]&127](e)|0)<=0){i=E;return}s=0.0;r=0.0;q=0.0;e=0;z=0;do{F=c[a+8>>2]|0;mc[c[(c[F>>2]|0)+104>>2]&127](F,z,E+48|0,E+32|0);m=+g[E+48>>2];w=+g[E+48+4>>2];u=+g[E+48+8>>2];n=+g[E+32>>2]-m;x=+g[E+32+4>>2]-w;v=+g[E+32+8>>2]-u;do if((B-m)*n+(C-w)*x+(D-u)*v>0.0)if((B-m)*n+(C-w)*x+(D-u)*v<n*n+x*x+v*v){y=((B-m)*n+(C-w)*x+(D-u)*v)/(n*n+x*x+v*v);o=B-m-n*y;p=C-w-x*y;t=D-u-v*y;break}else{o=B-m-n;p=C-w-x;t=D-u-v;y=1.0;break}else{o=B-m;p=C-w;t=D-u;y=0.0}while(0);if(o*o+p*p+t*t<A*A){s=m+n*y;r=u+v*y;q=w+x*y;e=1}z=z+1|0;F=c[a+8>>2]|0}while((z|0)<(Eb[c[(c[F>>2]|0)+100>>2]&127](F)|0));if(!(e&1)){i=E;return}else p=A*A}else{p=A*A;s=B-y*l;r=D-y*k;q=C-y*j}n=B-s;o=C-q;m=D-r;if(!(n*n+o*o+m*m<p)){i=E;return}if(n*n+o*o+m*m>1.1920928955078125e-07){j=+O(+(n*n+o*o+m*m));h=h-j;l=n*(1.0/j);k=m*(1.0/j);j=o*(1.0/j)}h=-h;if(f){x=+g[b+64>>2];y=+g[b+68>>2];A=+g[b+72>>2];B=x*l+y*j+A*k;o=+g[b+80>>2];p=+g[b+84>>2];t=+g[b+88>>2];C=l*o+j*p+k*t;u=+g[b+96>>2];v=+g[b+100>>2];w=+g[b+104>>2];D=l*u+j*v+k*w;g[E+48>>2]=-B;g[E+48+4>>2]=-C;g[E+48+8>>2]=-D;g[E+48+12>>2]=0.0;C=s*o+q*p+r*t+ +g[b+116>>2]+C*h;D=s*u+q*v+r*w+ +g[b+120>>2]+D*h;g[E+32>>2]=s*x+q*y+r*A+ +g[b+112>>2]+B*h;g[E+32+4>>2]=C;g[E+32+8>>2]=D;g[E+32+12>>2]=0.0;hc[c[(c[d>>2]|0)+16>>2]&15](d,E+48|0,E+32|0,h);i=E;return}else{F=c[(c[d>>2]|0)+16>>2]|0;y=+g[b+64>>2];A=+g[b+68>>2];B=+g[b+72>>2];u=+g[b+80>>2];v=+g[b+84>>2];C=+g[b+88>>2];w=+g[b+96>>2];x=+g[b+100>>2];D=+g[b+104>>2];g[E+16>>2]=y*l+A*j+B*k;g[E+16+4>>2]=l*u+j*v+k*C;g[E+16+8>>2]=l*w+j*x+k*D;g[E+16+12>>2]=0.0;C=s*u+q*v+r*C+ +g[b+116>>2];D=s*w+q*x+r*D+ +g[b+120>>2];g[E>>2]=s*y+q*A+r*B+ +g[b+112>>2];g[E+4>>2]=C;g[E+8>>2]=D;g[E+12>>2]=0.0;hc[F&15](d,E+16|0,E,h);i=E;return}}function ae(b){b=b|0;var d=0.0,e=0,f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0;r=i;i=i+80|0;if((Eb[c[(c[b>>2]|0)+20>>2]&127](b)|0?(q=Eb[c[(c[b>>2]|0)+20>>2]&127](b)|0,(Eb[c[(c[q>>2]|0)+48>>2]&127](q)|0)&8|0):0)?(e=c[b+24>>2]|0,e=Eb[c[(c[e>>2]|0)+36>>2]&127](e)|0,c[r+64>>2]=1065353216,c[r+64+4>>2]=1065353216,c[r+64+8>>2]=0,g[r+64+12>>2]=0.0,(e|0)>0):0){j=0;do{f=c[b+24>>2]|0;f=Zb[c[(c[f>>2]|0)+40>>2]&31](f,j)|0;h=c[f+748>>2]|0;if((h|0)>0){k=0;do{q=Eb[c[(c[b>>2]|0)+20>>2]&127](b)|0;Bb[c[(c[q>>2]|0)+32>>2]&0](q,f+4+(k*184|0)+32|0,f+4+(k*184|0)+64|0,+g[f+4+(k*184|0)+80>>2],c[f+4+(k*184|0)+148>>2]|0,r+64|0);k=k+1|0}while((k|0)!=(h|0))}j=j+1|0}while((j|0)!=(e|0))}if(!(Eb[c[(c[b>>2]|0)+20>>2]&127](b)|0)){i=r;return}q=Eb[c[(c[b>>2]|0)+20>>2]&127](b)|0;if(!((Eb[c[(c[q>>2]|0)+48>>2]&127](q)|0)&3)){i=r;return}if((c[b+8>>2]|0)<=0){i=r;return}h=r+64+4|0;j=r+64+8|0;k=r+64+12|0;q=0;do{f=c[(c[b+16>>2]|0)+(q<<2)>>2]|0;if(!(c[f+204>>2]&32)){if(Eb[c[(c[b>>2]|0)+20>>2]&127](b)|0?(e=Eb[c[(c[b>>2]|0)+20>>2]&127](b)|0,(Eb[c[(c[e>>2]|0)+48>>2]&127](e)|0)&1|0):0){c[r+64>>2]=1065353216;c[h>>2]=1065353216;c[j>>2]=1065353216;g[k>>2]=0.0;switch(c[f+216>>2]|0){case 1:{c[r+64>>2]=1065353216;c[h>>2]=1065353216;c[j>>2]=1065353216;g[k>>2]=0.0;break}case 2:{c[r+64>>2]=0;c[h>>2]=1065353216;c[j>>2]=0;g[k>>2]=0.0;break}case 3:{c[r+64>>2]=0;c[h>>2]=1065353216;c[j>>2]=1065353216;g[k>>2]=0.0;break}case 4:{c[r+64>>2]=1065353216;c[h>>2]=0;c[j>>2]=0;g[k>>2]=0.0;break}case 5:{c[r+64>>2]=1065353216;c[h>>2]=1065353216;c[j>>2]=0;g[k>>2]=0.0;break}default:{c[r+64>>2]=1065353216;c[h>>2]=0;c[j>>2]=0;g[k>>2]=0.0}}mc[c[(c[b>>2]|0)+28>>2]&127](b,f+4|0,c[f+192>>2]|0,r+64|0)}e=c[b+72>>2]|0;if(e|0?(Eb[c[(c[e>>2]|0)+48>>2]&127](e)|0)&2|0:0){c[r+32>>2]=1065353216;c[r+32+4>>2]=0;c[r+32+8>>2]=0;g[r+32+12>>2]=0.0;e=c[f+192>>2]|0;mc[c[(c[e>>2]|0)+8>>2]&127](e,f+4|0,r+64|0,r+48|0);g[r+64>>2]=+g[r+64>>2]+-.019999999552965164;g[r+64+4>>2]=+g[r+64+4>>2]+-.019999999552965164;g[r+64+8>>2]=+g[r+64+8>>2]+-.019999999552965164;g[r+48>>2]=+g[r+48>>2]+.019999999552965164;g[r+48+4>>2]=+g[r+48+4>>2]+.019999999552965164;g[r+48+8>>2]=+g[r+48+8>>2]+.019999999552965164;do if((a[b+44>>0]|0?(c[f+236>>2]|0)==2:0)?(c[f+204>>2]&3|0)==0:0){e=c[f+192>>2]|0;mc[c[(c[e>>2]|0)+8>>2]&127](e,f+68|0,r+16|0,r);d=+g[r+16>>2]+-.019999999552965164;g[r+16>>2]=d;l=+g[r+16+4>>2]+-.019999999552965164;g[r+16+4>>2]=l;m=+g[r+16+8>>2]+-.019999999552965164;g[r+16+8>>2]=m;n=+g[r>>2]+.019999999552965164;g[r>>2]=n;o=+g[r+4>>2]+.019999999552965164;g[r+4>>2]=o;p=+g[r+8>>2]+.019999999552965164;g[r+8>>2]=p;if(d<+g[r+64>>2])g[r+64>>2]=d;if(l<+g[r+64+4>>2])g[r+64+4>>2]=l;if(m<+g[r+64+8>>2])g[r+64+8>>2]=m;d=+g[r+16+12>>2];if(d<+g[r+64+12>>2])g[r+64+12>>2]=d;if(+g[r+48>>2]<n)g[r+48>>2]=n;if(+g[r+48+4>>2]<o)g[r+48+4>>2]=o;if(+g[r+48+8>>2]<p)g[r+48+8>>2]=p;d=+g[r+12>>2];if(!(+g[r+48+12>>2]<d))break;g[r+48+12>>2]=d}while(0);f=c[b+72>>2]|0;mc[c[(c[f>>2]|0)+52>>2]&127](f,r+64|0,r+48|0,r+32|0)}}q=q+1|0}while((q|0)<(c[b+8>>2]|0));i=r;return}function be(b,d,e,f,h,i,j,k,l,m,n){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0.0,s=0.0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0;if((j|0)<2|(k|0)<2){n=0;return n|0}y=_(k,j)|0;c[6435]=(c[6435]|0)+1;b=yc(y>>>0>268435455?18:(y<<4|3)+16|0)|0;if(!b)t=0;else{c[(b+4+15&-16)+-4>>2]=b;t=b+4+15&-16}o=y>>>0>1073741823?-1:y<<2;o=(o|0)==0?1:o;while(1){q=yc(o)|0;if(q|0)break;b=c[6564]|0;c[6564]=b+0;if(!b){p=8;break}jc[b&3]()}if((p|0)==8){n=Ya(4)|0;c[n>>2]=9640;pb(n|0,2800,251)}if((k|0)>0?(j|0)>0:0){p=0;do{z=+(p|0)/+(k+-1|0);r=+g[e>>2];r=r+z*(+g[h>>2]-r);s=+g[e+4>>2];s=s+z*(+g[h+4>>2]-s);u=+g[e+8>>2];u=u+z*(+g[h+8>>2]-u);v=+g[f>>2];w=+g[f+4>>2];x=+g[f+8>>2];b=_(p,j)|0;v=v+z*(+g[i>>2]-v)-r;w=w+z*(+g[i+4>>2]-w)-s;x=x+z*(+g[i+8>>2]-x)-u;o=0;do{z=+(o|0)/+(j+-1|0);A=o+b|0;g[t+(A<<4)>>2]=r+v*z;g[t+(A<<4)+4>>2]=s+w*z;g[t+(A<<4)+8>>2]=u+x*z;g[t+(A<<4)+12>>2]=0.0;g[q+(A<<2)>>2]=1.0;o=o+1|0}while((o|0)!=(j|0));p=p+1|0}while((p|0)!=(k|0))}c[6435]=(c[6435]|0)+1;b=yc(1271)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}Kc(b,d,y,t,q);if(l&1|0){g[(c[b+720>>2]|0)+88>>2]=0.0;a[b+924>>0]=1}if(l&2|0){g[(c[b+720>>2]|0)+((j+-1|0)*104|0)+88>>2]=0.0;a[b+924>>0]=1}if(l&4|0){A=_(k+-1|0,j)|0;g[(c[b+720>>2]|0)+(A*104|0)+88>>2]=0.0;a[b+924>>0]=1}if(l&8|0){A=j+-1+(_(k+-1|0,j)|0)|0;g[(c[b+720>>2]|0)+(A*104|0)+88>>2]=0.0;a[b+924>>0]=1}if(l&16|0){g[(c[b+720>>2]|0)+(((j+-1|0)/2|0)*104|0)+88>>2]=0.0;a[b+924>>0]=1}if(l&32|0){A=_((k+-1|0)/2|0,j)|0;g[(c[b+720>>2]|0)+(A*104|0)+88>>2]=0.0;a[b+924>>0]=1}if(l&64|0){A=j+-1+(_((k+-1|0)/2|0,j)|0)|0;g[(c[b+720>>2]|0)+(A*104|0)+88>>2]=0.0;a[b+924>>0]=1}if(l&128|0){A=(_(k+-1|0,j)|0)+((j+-1|0)/2|0)|0;g[(c[b+720>>2]|0)+(A*104|0)+88>>2]=0.0;a[b+924>>0]=1}if(l&256|0){A=(_((k+-1|0)/2|0,j)|0)+((j+-1|0)/2|0)|0;g[(c[b+720>>2]|0)+(A*104|0)+88>>2]=0.0;a[b+924>>0]=1}if(t|0){c[6436]=(c[6436]|0)+1;hd(c[t+-4>>2]|0)}hd(q);if((k|0)<=0){A=b;return A|0}y=j+-1|0;d=0;o=0;while(1){p=d;d=d+1|0;a:do if((j|0)>0){t=_(p,j)|0;i=_(d,j)|0;s=1.0/+(k+-1|0)*+(k+-1-p|0);r=1.0/+(k+-1|0)*+(k+-2-p|0);if((d|0)<(k|0)){f=0;h=o}else{if((j|0)>1){q=1;p=0}else break;while(1){Rf(b,p+t|0,q+t|0,0,0);p=q+1|0;if((p|0)==(j|0))break a;else{A=q;q=p;p=A}}}while(1){p=f+1|0;q=f+t|0;e=f+i|0;if((f|0)==(j+-1|0))break;Rf(b,q,p+t|0,0,0);Rf(b,q,e,0,0);Zf(b,q,e,p+i|0,0);if(!n)Zf(b,p+i|0,p+t|0,q,0);else{z=1.0/+(j+-1|0)*+(f|0);g[n+(h<<2)>>2]=z;g[n+(h+1<<2)>>2]=s;g[n+(h+2<<2)>>2]=z;g[n+(h+3<<2)>>2]=r;x=1.0/+(j+-1|0)*+(p|0);g[n+(h+4<<2)>>2]=x;g[n+(h+5<<2)>>2]=r;Zf(b,p+i|0,p+t|0,q,0);g[n+(h+6<<2)>>2]=x;g[n+(h+7<<2)>>2]=r;g[n+(h+8<<2)>>2]=x;g[n+(h+9<<2)>>2]=s;g[n+(h+10<<2)>>2]=z;g[n+(h+11<<2)>>2]=s}if(m)Rf(b,q,p+i|0,0,0);f=p;h=h+12|0}Rf(b,y,e,0,0);o=(j*12|0)+-12+o|0}while(0);if((d|0)==(k|0))break;else y=y+j|0}return b|0}function ce(b,d,e,f,h,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;i=i+288|0;c[w+208>>2]=c[d>>2];c[w+208+4>>2]=c[d+4>>2];c[w+208+8>>2]=c[d+8>>2];c[w+208+12>>2]=c[d+12>>2];o=w+208+16|0;c[o>>2]=c[e>>2];c[o+4>>2]=c[e+4>>2];c[o+8>>2]=c[e+8>>2];c[o+12>>2]=c[e+12>>2];e=w+208+32|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];r=c[k>>2]|0;t=c[k+4>>2]|0;u=c[k+8>>2]|0;v=c[k+16>>2]|0;q=c[k+12>>2]|0;p=c[k+20>>2]|0;c[w>>2]=c[w+208>>2];c[w+4>>2]=c[w+208+4>>2];c[w+8>>2]=c[w+208+8>>2];c[w+12>>2]=c[w+208+12>>2];c[w+16>>2]=c[o>>2];c[w+16+4>>2]=c[o+4>>2];c[w+16+8>>2]=c[o+8>>2];c[w+16+12>>2]=c[o+12>>2];c[w+32>>2]=c[e>>2];c[w+32+4>>2]=c[e+4>>2];c[w+32+8>>2]=c[e+8>>2];c[w+32+12>>2]=c[e+12>>2];e=c[b+136>>2]|0;if((e|0)==(c[b+140>>2]|0)?(s=e|0?e<<1:1,(e|0)<(s|0)):0){if(!s)d=0;else{c[6435]=(c[6435]|0)+1;d=yc((s*284|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}e=c[b+136>>2]|0}if((e|0)>0){k=0;do{f=c[b+144>>2]|0;m=d+(k*284|0)|0;n=f+(k*284|0)|0;o=m+92|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));m=d+(k*284|0)+92|0;n=f+(k*284|0)+92|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=d+(k*284|0)+108|0;n=f+(k*284|0)+108|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=d+(k*284|0)+124|0;n=f+(k*284|0)+124|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=d+(k*284|0)+140|0;n=f+(k*284|0)+140|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];m=d+(k*284|0)+156|0;n=f+(k*284|0)+156|0;o=m+128|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));k=k+1|0}while((k|0)!=(e|0))}e=c[b+144>>2]|0;if(e|0){if(a[b+148>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[b+144>>2]=0}a[b+148>>0]=1;c[b+144>>2]=d;c[b+140>>2]=s;e=c[b+136>>2]|0}d=c[b+144>>2]|0;m=d+(e*284|0)|0;n=w+48|0;o=m+92|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));m=d+(e*284|0)+92|0;c[m>>2]=c[w+192>>2];c[m+4>>2]=c[w+192+4>>2];c[m+8>>2]=c[w+192+8>>2];c[m+12>>2]=c[w+192+12>>2];m=d+(e*284|0)+108|0;c[m>>2]=c[w+176>>2];c[m+4>>2]=c[w+176+4>>2];c[m+8>>2]=c[w+176+8>>2];c[m+12>>2]=c[w+176+12>>2];m=d+(e*284|0)+124|0;c[m>>2]=c[w+160>>2];c[m+4>>2]=c[w+160+4>>2];c[m+8>>2]=c[w+160+8>>2];c[m+12>>2]=c[w+160+12>>2];m=d+(e*284|0)+140|0;c[m>>2]=c[w+144>>2];c[m+4>>2]=c[w+144+4>>2];c[m+8>>2]=c[w+144+8>>2];c[m+12>>2]=c[w+144+12>>2];d=d+(e*284|0)+156|0;m=d;n=w;o=m+48|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));g[d+48>>2]=h;c[d+52>>2]=q;g[d+56>>2]=j;c[d+60>>2]=r;c[d+64>>2]=t;c[d+68>>2]=u;c[d+72>>2]=v;g[d+76>>2]=0.0;g[d+80>>2]=0.0;g[d+84>>2]=0.0;g[d+88>>2]=.10000000149011612;c[d+92>>2]=p;g[d+96>>2]=0.0;g[d+100>>2]=0.0;a[d+104>>0]=l&1;m=d+105|0;n=w+256|0;o=m+23|0;do{a[m>>0]=a[n>>0]|0;m=m+1|0;n=n+1|0}while((m|0)<(o|0));l=c[b+136>>2]|0;c[b+136>>2]=l+1;l=(c[b+144>>2]|0)+(l*284|0)|0;Tg(c[b+116>>2]|0,l,0);Ae(c[b+116>>2]|0,c[b+144>>2]|0,(c[b+136>>2]|0)+-1|0,0);i=w;return l|0}function de(a,d,f,h,j){a=a|0;d=d|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;I=i;i=i+16|0;c[d+16>>2]=c[f>>2];c[d+16+4>>2]=c[f+4>>2];c[d+16+8>>2]=c[f+8>>2];c[d+16+12>>2]=c[f+12>>2];c[d+32>>2]=c[h>>2];c[d+32+4>>2]=c[h+4>>2];c[d+32+8>>2]=c[h+8>>2];c[d+32+12>>2]=c[h+12>>2];D=c[a+60>>2]|0;E=c[d+12>>2]&65535;Bj(a,I+6|0,+g[f>>2],+g[f+4>>2],+g[f+8>>2],0);Bj(a,I,+g[h>>2],+g[h+4>>2],+g[h+8>>2],1);H=0;do{t=b[D+(E<<6)+48+(H<<1)>>1]|0;w=b[D+(E<<6)+54+(H<<1)>>1]|0;q=b[I+6+(H<<1)>>1]|0;l=a+68+(H<<2)|0;s=c[l>>2]|0;m=(q&65535)-(e[s+((t&65535)<<2)>>1]|0)|0;r=b[I+(H<<1)>>1]|0;y=(r&65535)-(e[s+((w&65535)<<2)>>1]|0)|0;b[s+((t&65535)<<2)>>1]=q;b[s+((w&65535)<<2)>>1]=r;if((m|0)<0)wh(a,H,t);a:do if((y|0)>0?(z=c[l>>2]|0,A=c[a+60>>2]|0,B=e[z+((w&65535)<<2)+2>>1]|0,C=b[z+((w&65535)<<2)+6>>1]|0,C<<16>>16):0){n=1<<H&3;o=A+(B<<6)+54+(H<<1)|0;k=C;r=z+((w&65535)<<2)|0;do{s=r;r=r+4|0;p=b[r>>1]|0;if((e[s>>1]|0)<(p&65535))break a;q=c[a+60>>2]|0;k=k&65535;if(!(p&1)){if(((((e[A+(B<<6)+54+(n<<1)>>1]|0)>=(e[q+(k<<6)+48+(n<<1)>>1]|0)?(e[q+(k<<6)+54+(n<<1)>>1]|0)>=(e[A+(B<<6)+48+(n<<1)>>1]|0):0)?(e[A+(B<<6)+54+((1<<n&3)<<1)>>1]|0)>=(e[q+(k<<6)+48+((1<<n&3)<<1)>>1]|0):0)?(e[q+(k<<6)+54+((1<<n&3)<<1)>>1]|0)>=(e[A+(B<<6)+48+((1<<n&3)<<1)>>1]|0):0)?(G=c[a+92>>2]|0,F=q+((e[s+2>>1]|0)<<6)|0,Ob[c[(c[G>>2]|0)+8>>2]&63](G,F,q+(k<<6)|0)|0,G=c[a+96>>2]|0,G|0):0)Ob[c[(c[G>>2]|0)+8>>2]&63](G,F,q+(k<<6)|0)|0;q=q+(k<<6)+48+(H<<1)|0;b[q>>1]=(b[q>>1]|0)+-1<<16>>16}else{q=q+(k<<6)+54+(H<<1)|0;b[q>>1]=(b[q>>1]|0)+-1<<16>>16}b[o>>1]=(b[o>>1]|0)+1<<16>>16;k=e[s>>1]|e[s+2>>1]<<16;q=e[r>>1]|e[r+2>>1]<<16;b[s>>1]=q;b[s+2>>1]=q>>>16;b[r>>1]=k;b[r+2>>1]=k>>>16;k=b[s+10>>1]|0}while(k<<16>>16!=0)}while(0);b:do if((m|0)>0?(u=c[l>>2]|0,v=b[u+((t&65535)<<2)+6>>1]|0,v<<16>>16):0){p=(c[a+60>>2]|0)+((e[u+((t&65535)<<2)+2>>1]|0)<<6)+48+(H<<1)|0;q=1<<H&3;l=v;n=u+((t&65535)<<2)|0;do{o=n;n=n+4|0;k=b[n>>1]|0;if((e[o>>1]|0)<(k&65535))break b;m=c[a+60>>2]|0;l=l&65535;if(!(k&1)){t=m+(l<<6)+48+(H<<1)|0;b[t>>1]=(b[t>>1]|0)+-1<<16>>16}else{k=e[o+2>>1]|0;if(((((e[m+(k<<6)+54+(q<<1)>>1]|0)>=(e[m+(l<<6)+48+(q<<1)>>1]|0)?(e[m+(l<<6)+54+(q<<1)>>1]|0)>=(e[m+(k<<6)+48+(q<<1)>>1]|0):0)?(e[m+(k<<6)+54+((1<<q&3)<<1)>>1]|0)>=(e[m+(l<<6)+48+((1<<q&3)<<1)>>1]|0):0)?(e[m+(l<<6)+54+((1<<q&3)<<1)>>1]|0)>=(e[m+(k<<6)+48+((1<<q&3)<<1)>>1]|0):0)?(x=c[a+92>>2]|0,Ib[c[(c[x>>2]|0)+12>>2]&31](x,m+(k<<6)|0,m+(l<<6)|0,j)|0,x=c[a+96>>2]|0,x|0):0)Ib[c[(c[x>>2]|0)+12>>2]&31](x,m+(k<<6)|0,m+(l<<6)|0,j)|0;t=m+(l<<6)+54+(H<<1)|0;b[t>>1]=(b[t>>1]|0)+-1<<16>>16}b[p>>1]=(b[p>>1]|0)+1<<16>>16;l=e[o>>1]|e[o+2>>1]<<16;t=e[n>>1]|e[n+2>>1]<<16;b[o>>1]=t;b[o+2>>1]=t>>>16;b[n>>1]=l;b[n+2>>1]=l>>>16;l=b[o+10>>1]|0}while(l<<16>>16!=0)}while(0);if((y|0)<0)uh(a,H,w,j);H=H+1|0}while((H|0)!=3);k=c[a+108>>2]|0;if(!k){i=I;return}yb[c[(c[k>>2]|0)+16>>2]&31](k,c[d+60>>2]|0,f,h,j);i=I;return}function ee(b,d,e){b=b|0;d=+d;e=+e;var f=0,h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0.0,v=0.0;s=i;i=i+144|0;f=c[b+8>>2]|0;if(!f){f=c[b+4>>2]|0;if(!f){d=0.0;k=0.0;n=0.0;o=0.0;l=0.0;m=0.0}else{r=+g[f+336>>2];n=+g[b+172>>2];o=+g[f+340>>2];p=+g[b+168>>2];m=+g[b+164>>2];q=+g[f+332>>2];d=r*n-o*p;k=+g[f+316>>2];n=o*m-n*q;o=+g[f+320>>2];l=+g[f+324>>2];m=p*q-r*m}}else{r=+g[f+332>>2];n=+g[b+172>>2];o=+g[f+336>>2];p=+g[b+168>>2];m=+g[b+164>>2];q=+g[f+328>>2];d=r*n-o*p;k=+g[f+312>>2];n=o*m-n*q;o=+g[f+316>>2];l=+g[f+320>>2];m=p*q-r*m}p=k+d;r=o+n;q=l+m;f=c[b+20>>2]|0;if(!f){f=c[b+16>>2]|0;if(!f){d=0.0;k=0.0;n=0.0;o=0.0;l=0.0;m=0.0}else{t=+g[f+336>>2];n=+g[b+188>>2];o=+g[f+340>>2];v=+g[b+184>>2];m=+g[b+180>>2];u=+g[f+332>>2];d=t*n-o*v;k=+g[f+316>>2];n=o*m-n*u;o=+g[f+320>>2];l=+g[f+324>>2];m=v*u-t*m}}else{v=+g[f+332>>2];n=+g[b+188>>2];o=+g[f+336>>2];t=+g[b+184>>2];m=+g[b+180>>2];u=+g[f+328>>2];d=v*n-o*t;k=+g[f+312>>2];n=o*m-n*u;o=+g[f+316>>2];l=+g[f+320>>2];m=t*u-v*m}p=p-(k+d);n=r-(o+n);d=q-(l+m);k=+g[b+196>>2];l=+g[b+200>>2];m=+g[b+204>>2];a[s+108+32>>0]=1;c[s+108+16>>2]=0;c[s+108+16+4>>2]=0;c[s+108+16+8>>2]=0;c[s+108+16+12>>2]=0;c[s+108>>2]=c[b+72>>2];c[s+108+4>>2]=c[b+72+4>>2];c[s+108+8>>2]=c[b+72+8>>2];c[s+108+12>>2]=c[b+72+12>>2];if(k*p+n*l+d*m<0.0){t=+g[b+212>>2];u=+g[s+108>>2]+((k*p+n*l+d*m)*k+(p-(k*p+n*l+d*m)*k)*t);g[s+108>>2]=u;v=(k*p+n*l+d*m)*l+t*(n-(k*p+n*l+d*m)*l)+ +g[s+108+4>>2];g[s+108+4>>2]=v;l=(k*p+n*l+d*m)*m+t*(d-(k*p+n*l+d*m)*m)+ +g[s+108+8>>2];g[s+108+8>>2]=l;f=s+108+4|0;h=s+108+8|0;j=s+108|0;d=u;k=v}else{f=s+108+4|0;h=s+108+8|0;j=s+108|0;d=+g[s+108>>2];k=+g[s+108+4>>2];l=+g[s+108+8>>2]}m=(+g[b+104>>2]*d+ +g[b+108>>2]*k+ +g[b+112>>2]*l)*e;n=(d*+g[b+120>>2]+k*+g[b+124>>2]+l*+g[b+128>>2])*e;d=(d*+g[b+136>>2]+k*+g[b+140>>2]+l*+g[b+144>>2])*e;g[j>>2]=m;g[f>>2]=n;g[h>>2]=d;g[s+108+12>>2]=0.0;f=c[b+4>>2]|0;if((f|0)!=(c[b+16>>2]|0)){f=s;h=s+108|0;j=f+36|0;do{c[f>>2]=c[h>>2];f=f+4|0;h=h+4|0}while((f|0)<(j|0));v=-+g[s+4>>2];u=-+g[s+8>>2];g[s>>2]=-+g[s>>2];g[s+4>>2]=v;g[s+8>>2]=u;g[s+12>>2]=0.0;u=-+g[s+20>>2];v=-+g[s+24>>2];g[s+16>>2]=-+g[s+16>>2];g[s+20>>2]=u;g[s+24>>2]=v;g[s+28>>2]=0.0;Xh(b+4|0,s,b+164|0);Xh(b+16|0,s+108|0,b+180|0);i=s;return}if(!(m==m&n==n&(d==d&0.0==0.0))){i=s;return}v=+O(+(m*m+n*n+d*d));if(v<+g[f+368>>2]){i=s;return}h=c[s+108+32>>2]|0;v=+g[f+372>>2];g[s+72+12>>2]=0.0;g[s+72+28>>2]=0.0;c[s+72+32>>2]=h;g[s+72>>2]=-(m*v);g[s+72+4>>2]=-(n*v);g[s+72+8>>2]=-(d*v);g[s+72+16>>2]=v*-0.0;g[s+72+20>>2]=v*-0.0;g[s+72+24>>2]=v*-0.0;Xh(b+4|0,s+72|0,b+164|0);d=+g[(c[b+4>>2]|0)+372>>2];f=s+36|0;h=s+108|0;j=f+36|0;do{c[f>>2]=c[h>>2];f=f+4|0;h=h+4|0}while((f|0)<(j|0));g[s+36>>2]=d*+g[s+36>>2];g[s+36+4>>2]=d*+g[s+36+4>>2];g[s+36+8>>2]=d*+g[s+36+8>>2];g[s+36+16>>2]=d*+g[s+36+16>>2];g[s+36+20>>2]=d*+g[s+36+20>>2];g[s+36+24>>2]=d*+g[s+36+24>>2];Xh(b+16|0,s+36|0,b+180|0);i=s;return}function fe(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0,A=0,B=0.0,C=0.0,D=0,E=0;A=i;i=i+192|0;x=c[b+4>>2]|0;if(+g[x+752>>2]<f){i=A;return}z=c[x+740>>2]|0;w=(c[b+8>>2]|0)+8|0;y=c[w>>2]|0;l=+g[e>>2];n=+g[d>>2]*f+l;h=+g[e+4>>2];o=+g[d+4>>2]*f+h;j=+g[e+8>>2];r=+g[d+8>>2]*f+j;v=(c[b+12>>2]|0)+8|0;p=c[v>>2]|0;m=+g[p+52>>2];if((z|0)!=(y|0)){k=o-+g[p+56>>2];u=r-+g[p+60>>2];B=l-+g[y+52>>2];l=h-+g[y+56>>2];h=j-+g[y+60>>2];s=(n-m)*+g[p+4>>2]+k*+g[p+20>>2]+u*+g[p+36>>2];t=(n-m)*+g[p+8>>2]+k*+g[p+24>>2]+u*+g[p+40>>2];u=(n-m)*+g[p+12>>2]+k*+g[p+28>>2]+u*+g[p+44>>2];j=B*+g[y+4>>2]+l*+g[y+20>>2]+h*+g[y+36>>2];k=B*+g[y+8>>2]+l*+g[y+24>>2]+h*+g[y+40>>2];h=B*+g[y+12>>2]+l*+g[y+28>>2]+h*+g[y+44>>2]}else{C=n-+g[z+52>>2];k=o-+g[z+56>>2];u=r-+g[z+60>>2];B=h-+g[p+56>>2];h=j-+g[p+60>>2];s=C*+g[z+4>>2]+k*+g[z+20>>2]+u*+g[z+36>>2];t=C*+g[z+8>>2]+k*+g[z+24>>2]+u*+g[z+40>>2];u=C*+g[z+12>>2]+k*+g[z+28>>2]+u*+g[z+44>>2];j=(l-m)*+g[p+4>>2]+B*+g[p+20>>2]+h*+g[p+36>>2];k=(l-m)*+g[p+8>>2]+B*+g[p+24>>2]+h*+g[p+40>>2];h=(l-m)*+g[p+12>>2]+B*+g[p+28>>2]+h*+g[p+44>>2]}g[A>>2]=s;g[A+4>>2]=t;g[A+8>>2]=u;g[A+12>>2]=0.0;g[A+16>>2]=j;g[A+20>>2]=k;g[A+24>>2]=h;g[A+28>>2]=0.0;c[A+64>>2]=c[d>>2];c[A+64+4>>2]=c[d+4>>2];c[A+64+8>>2]=c[d+8>>2];c[A+64+12>>2]=c[d+12>>2];g[A+80>>2]=f;g[A+84>>2]=0.0;g[A+88>>2]=0.0;g[A+92>>2]=0.0;c[A+112>>2]=0;a[A+116>>0]=0;c[A+120>>2]=0;c[A+120+4>>2]=0;c[A+120+8>>2]=0;c[A+120+12>>2]=0;c[A+120+16>>2]=0;c[A+120+20>>2]=0;c[A+120+24>>2]=0;c[A+120+28>>2]=0;g[A+48>>2]=n;g[A+52>>2]=o;g[A+56>>2]=r;g[A+60>>2]=0.0;c[A+32>>2]=c[e>>2];c[A+32+4>>2]=c[e+4>>2];c[A+32+8>>2]=c[e+8>>2];c[A+32+12>>2]=c[e+12>>2];h=+g[x+752>>2];e=c[x+748>>2]|0;if((e|0)>0){q=0;p=-1;l=h*h;while(1){h=+g[x+4+(q*184|0)>>2]-s;j=+g[x+4+(q*184|0)+4>>2]-t;k=+g[x+4+(q*184|0)+8>>2]-u;d=h*h+j*j+k*k<l;p=d?q:p;q=q+1|0;if((q|0)==(e|0))break;else l=d?h*h+j*j+k*k:l}}else p=-1;q=c[w>>2]|0;w=c[v>>2]|0;h=+g[q+224>>2]*+g[w+224>>2];h=h<-10.0?-10.0:h;g[A+84>>2]=h>10.0?10.0:h;g[A+92>>2]=+g[q+228>>2]*+g[w+228>>2];h=+g[q+232>>2]*+g[w+232>>2];h=h<-10.0?-10.0:h;g[A+88>>2]=h>10.0?10.0:h;h=+g[A+72>>2];w=+N(+h)>.7071067690849304;l=+g[A+68>>2];if(w){C=1.0/+O(+(h*h+l*l));n=+g[A+64>>2];m=-(C*l*n);n=n*-(C*h);o=-(C*h);j=(h*h+l*l)*C;k=0.0;h=C*l}else{j=+g[A+64>>2];k=1.0/+O(+(j*j+l*l));m=h*-(l*k);n=(j*j+l*l)*k;o=k*j;j=-(k*j*h);k=-(l*k);h=0.0}g[A+152>>2]=k;g[A+156>>2]=o;g[A+160>>2]=h;g[A+168>>2]=j;g[A+172>>2]=m;g[A+176>>2]=n;v=c[b+20>>2]|0;q=c[b+16>>2]|0;w=c[b+28>>2]|0;b=c[b+24>>2]|0;c[A+96>>2]=(z|0)!=(y|0)?v:q;c[A+100>>2]=(z|0)!=(y|0)?q:v;c[A+104>>2]=(z|0)!=(y|0)?w:b;c[A+108>>2]=(z|0)!=(y|0)?b:w;if((p|0)>-1){b=x+4+(p*184|0)+148|0;z=c[b>>2]|0;e=x+4+(p*184|0)+120|0;d=c[e>>2]|0;v=x+4+(p*184|0)+124|0;q=c[v>>2]|0;y=x+4+(p*184|0)+128|0;w=c[y>>2]|0;D=x+4+(p*184|0)+112|0;E=c[D>>2]|0;_m(x+4+(p*184|0)|0,A|0,184)|0;c[D>>2]=E;c[e>>2]=d;c[v>>2]=q;c[y>>2]=w;c[b>>2]=z}else _e(x,A)|0;i=A;return}function ge(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((h|0)<0){o=c[b+8>>2]|0;+$b[c[(c[o>>2]|0)+12>>2]&3](o,d,e,f,g,c[b+12>>2]|0,c[b+16>>2]|0,c[b+4>>2]|0,c[b+20>>2]|0,c[b+24>>2]|0);return}n=c[b+16>>2]|0;a:do if((n|0)>0){m=c[b+12>>2]|0;i=0;while(1){l=m+(i<<2)|0;k=c[l>>2]|0;j=c[(c[k+28>>2]|0)+208>>2]|0;if((j|0)<=-1)j=c[(c[k+32>>2]|0)+208>>2]|0;if((j|0)==(h|0)){o=l;break a}i=i+1|0;if((i|0)>=(n|0)){o=0;break}}}else{i=0;o=0}while(0);if((i|0)<(n|0)){m=c[b+12>>2]|0;j=0;do{l=c[m+(i<<2)>>2]|0;k=c[(c[l+28>>2]|0)+208>>2]|0;if((k|0)<=-1)k=c[(c[l+32>>2]|0)+208>>2]|0;j=((k|0)==(h|0)&1)+j|0;i=i+1|0}while((i|0)!=(n|0));h=j}else h=0;i=c[b+4>>2]|0;if((c[i+72>>2]|0)<2){n=c[b+8>>2]|0;+$b[c[(c[n>>2]|0)+12>>2]&3](n,d,e,f,g,o,h,i,c[b+20>>2]|0,c[b+24>>2]|0);return}if((e|0)>0){i=c[b+32>>2]|0;j=c[b+36>>2]|0;n=0;do{m=d+(n<<2)|0;if((i|0)==(j|0)){l=j|0?j<<1:1;if((j|0)<(l|0)){if(!l)i=0;else{c[6435]=(c[6435]|0)+1;i=yc((l<<2|3)+16|0)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}j=c[b+32>>2]|0}if((j|0)>0){k=0;do{c[i+(k<<2)>>2]=c[(c[b+40>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(j|0))}k=c[b+40>>2]|0;if(k){if(a[b+44>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[k+-4>>2]|0);j=c[b+32>>2]|0}c[b+40>>2]=0}a[b+44>>0]=1;c[b+40>>2]=i;c[b+36>>2]=l;i=j;j=l}else i=j}c[(c[b+40>>2]|0)+(i<<2)>>2]=c[m>>2];i=i+1|0;c[b+32>>2]=i;n=n+1|0}while((n|0)!=(e|0))}if((g|0)>0){i=c[b+52>>2]|0;j=c[b+56>>2]|0;n=0;do{m=f+(n<<2)|0;if((i|0)==(j|0)){l=j|0?j<<1:1;if((j|0)<(l|0)){if(!l)i=0;else{c[6435]=(c[6435]|0)+1;i=yc((l<<2|3)+16|0)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}j=c[b+52>>2]|0}if((j|0)>0){k=0;do{c[i+(k<<2)>>2]=c[(c[b+60>>2]|0)+(k<<2)>>2];k=k+1|0}while((k|0)!=(j|0))}k=c[b+60>>2]|0;if(k){if(a[b+64>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[k+-4>>2]|0);j=c[b+52>>2]|0}c[b+60>>2]=0}a[b+64>>0]=1;c[b+60>>2]=i;c[b+56>>2]=l;i=j;j=l}else i=j}c[(c[b+60>>2]|0)+(i<<2)>>2]=c[m>>2];i=i+1|0;c[b+52>>2]=i;n=n+1|0}while((n|0)!=(g|0))}if((h|0)>0){i=c[b+72>>2]|0;j=c[b+76>>2]|0;n=0;do{m=o+(n<<2)|0;if((i|0)==(j|0)){l=j|0?j<<1:1;if((j|0)<(l|0)){if(!l){k=0;i=j}else{c[6435]=(c[6435]|0)+1;i=yc((l<<2|3)+16|0)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}k=i;i=c[b+72>>2]|0}if((i|0)>0){j=0;do{c[k+(j<<2)>>2]=c[(c[b+80>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(i|0))}j=c[b+80>>2]|0;if(j){if(a[b+84>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0);i=c[b+72>>2]|0}c[b+80>>2]=0}a[b+84>>0]=1;c[b+80>>2]=k;c[b+76>>2]=l;j=l}else i=j}c[(c[b+80>>2]|0)+(i<<2)>>2]=c[m>>2];i=i+1|0;c[b+72>>2]=i;n=n+1|0}while((n|0)!=(h|0))}else i=c[b+72>>2]|0;if(((c[b+52>>2]|0)+i|0)<=(c[(c[b+4>>2]|0)+72>>2]|0))return;nh(b);return}function he(d,e,f,h,j){d=d|0;e=e|0;f=+f;h=+h;j=+j;var k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;q=i;i=i+240|0;o=+g[d+96>>2]+h;p=+g[d+100>>2]+j;g[d+112>>2]=+g[d+92>>2]+f;g[d+116>>2]=o;g[d+120>>2]=p;g[d+124>>2]=0.0;c[q+168>>2]=1065353216;c[q+168+4>>2]=0;c[q+168+4+4>>2]=0;c[q+168+4+8>>2]=0;c[q+168+4+12>>2]=0;c[q+168+20>>2]=1065353216;c[q+168+24>>2]=0;c[q+168+24+4>>2]=0;c[q+168+24+8>>2]=0;c[q+168+24+12>>2]=0;c[q+168+40>>2]=1065353216;k=q+168+44|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[q+104>>2]=1065353216;c[q+104+4>>2]=0;c[q+104+4+4>>2]=0;c[q+104+4+8>>2]=0;c[q+104+4+12>>2]=0;c[q+104+20>>2]=1065353216;c[q+104+24>>2]=0;c[q+104+24+4>>2]=0;c[q+104+24+8>>2]=0;c[q+104+24+12>>2]=0;c[q+104+40>>2]=1065353216;k=q+104+44|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;p=1.0;k=10;while(1){if((k|0)<=0){k=14;break}k=k+-1|0;c[q+168+48>>2]=c[d+92>>2];c[q+168+48+4>>2]=c[d+92+4>>2];c[q+168+48+8>>2]=c[d+92+8>>2];c[q+168+48+12>>2]=c[d+92+12>>2];c[q+104+48>>2]=c[d+112>>2];c[q+104+48+4>>2]=c[d+112+4>>2];c[q+104+48+8>>2]=c[d+112+8>>2];c[q+104+48+12>>2]=c[d+112+12>>2];n=+g[d+92>>2]-+g[d+112>>2];o=+g[d+96>>2]-+g[d+116>>2];f=+g[d+100>>2]-+g[d+120>>2];r=c[d+8>>2]|0;g[q+4>>2]=1.0;b[q+8>>1]=1;b[q+10>>1]=-1;c[q+76>>2]=0;c[q+12>>2]=0;c[q+12+4>>2]=0;c[q+12+8>>2]=0;c[q+12+12>>2]=0;c[q+12+16>>2]=0;c[q+12+20>>2]=0;c[q+12+24>>2]=0;c[q+12+28>>2]=0;c[q>>2]=4936;c[q+80>>2]=r;g[q+84>>2]=n;g[q+88>>2]=o;g[q+92>>2]=f;g[q+96>>2]=0.0;g[q+100>>2]=0.0;r=c[(c[r+188>>2]|0)+4>>2]|0;b[q+8>>1]=r;b[q+10>>1]=r>>>16;r=c[d+12>>2]|0;f=+Sb[c[(c[r>>2]|0)+48>>2]&15](r);r=c[d+12>>2]|0;zb[c[(c[r>>2]|0)+44>>2]&31](r,f+ +g[d+56>>2]);if(!(a[d+170>>0]|0))Kd(e,c[d+12>>2]|0,q+168|0,q+104|0,q,+g[e+56>>2]);else wd(c[d+8>>2]|0,c[d+12>>2]|0,q+168|0,q+104|0,q,+g[e+56>>2]);r=c[d+12>>2]|0;zb[c[(c[r>>2]|0)+44>>2]&31](r,f);o=+g[q+4>>2];p=p-o;if(o<1.0){h=+g[d+112>>2];m=+g[d+92>>2];j=+g[d+116>>2];n=+g[d+96>>2];l=+g[d+120>>2];o=+g[d+100>>2];f=+O(+((h-m)*(h-m)+(j-n)*(j-n)+(l-o)*(l-o)));if(f>1.1920928955078125e-07){v=+g[q+44>>2];t=+g[q+48>>2];x=+g[q+52>>2];w=((h-m)*(1.0/f)*v+(j-n)*(1.0/f)*t+(l-o)*(1.0/f)*x)*2.0;u=(h-m)*(1.0/f)-v*w;s=(j-n)*(1.0/f)-t*w;w=(l-o)*(1.0/f)-x*w;l=1.0/+O(+(w*w+(u*u+s*s)));c[d+112>>2]=c[d+92>>2];c[d+112+4>>2]=c[d+92+4>>2];c[d+112+8>>2]=c[d+92+8>>2];c[d+112+12>>2]=c[d+92+12>>2];h=f*(l*u-v*(x*l*w+(v*l*u+t*l*s)))+ +g[d+112>>2];g[d+112>>2]=h;j=f*(l*s-t*(x*l*w+(v*l*u+t*l*s)))+ +g[d+116>>2];g[d+116>>2]=j;l=f*(l*w-x*(x*l*w+(v*l*u+t*l*s)))+ +g[d+120>>2];g[d+120>>2]=l;f=j}else f=j;j=h-m;h=f-n;f=l-o;if(!(j*j+h*h+f*f>1.1920928955078125e-07)){k=11;break}x=1.0/+O(+(j*j+h*h+f*f));if(+g[d+76>>2]*j*x+h*x*+g[d+80>>2]+f*x*+g[d+84>>2]<=0.0){k=11;break}}else{c[d+92>>2]=c[d+112>>2];c[d+92+4>>2]=c[d+112+4>>2];c[d+92+8>>2]=c[d+112+8>>2];c[d+92+12>>2]=c[d+112+12>>2]}if(!(p>.009999999776482582)){k=14;break}}if((k|0)==11){i=q;return}else if((k|0)==14){i=q;return}}function ie(d,f,h,j){d=d|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0;w=i;i=i+80|0;v=c[d+48>>2]|0;c[w>>2]=6864;c[w+4>>2]=v;c[w+8>>2]=f;v=c[d+52>>2]|0;if(!(a[v+60>>0]|0)){f=c[v+56>>2]|0;if((f|0)>0){d=f;m=0;p=c[v+96>>2]|0;f=0;while(1){f=f+1|0;if(!(+g[h>>2]>+g[p+16>>2])?!(+g[j>>2]<+g[p>>2]):0)k=1;else k=0;if(!(!(+g[h+8>>2]>+g[p+24>>2])?!(+g[j+8>>2]<+g[p+8>>2]):0))k=0;if(!(+g[h+4>>2]>+g[p+20>>2])?!(+g[j+4>>2]<+g[p+4>>2]):0){l=c[p+32>>2]|0;if(k&(l|0)==-1){ic[c[(c[w>>2]|0)+8>>2]&127](w,c[p+36>>2]|0,c[p+40>>2]|0);d=c[v+56>>2]|0;o=43}else{n=(l|0)==-1;o=42}}else{l=c[p+32>>2]|0;k=0;n=(l|0)==-1;o=42}if((o|0)==42){o=0;if(n|k)o=43;else{m=l+m|0;k=p+(l<<6)|0}}if((o|0)==43){m=m+1|0;k=p+64|0}if((m|0)<(d|0))p=k;else break}}else f=0;if((c[6167]|0)>=(f|0)){i=w;return}c[6167]=f;i=w;return}D=+g[h>>2];H=+g[h+4>>2];z=+g[h+8>>2];G=+g[v+4>>2];D=D<G?G:D;y=+g[v+8>>2];H=H<y?y:H;C=+g[v+12>>2];z=z<C?C:z;I=+g[v+20>>2];A=+g[v+24>>2];E=+g[v+28>>2];F=+g[v+36>>2];x=+g[v+40>>2];B=+g[v+44>>2];u=~~(((I<D?I:D)-G)*F)&65534;b[w+66>>1]=u;s=~~(((E<z?E:z)-C)*B)&65534;t=~~(((A<H?A:H)-y)*x)&65534;b[w+66+2>>1]=t;b[w+66+4>>1]=s;H=+g[j>>2];z=+g[j+4>>2];D=+g[j+8>>2];H=H<G?G:H;z=z<y?y:z;D=D<C?C:D;r=(~~(((I<H?I:H)-G)*F+1.0)&65535|1)&65535;b[w+60>>1]=r;j=(~~(((E<D?E:D)-C)*B+1.0)&65535|1)&65535;q=(~~(((A<z?A:z)-y)*x+1.0)&65535|1)&65535;b[w+60+2>>1]=q;b[w+60+4>>1]=j;switch(c[v+144>>2]|0){case 0:{o=c[v+56>>2]|0;if((o|0)>0){d=0;k=c[v+136>>2]|0;f=0;do{f=f+1|0;l=((r&65535)>=(e[k>>1]|0)?(u&65535)<=(e[k+6>>1]|0):0)&(s&65535)<=(e[k+10>>1]|0)&(j&65535)>=(e[k+4>>1]|0)&(t&65535)<=(e[k+8>>1]|0)&(q&65535)>=(e[k+2>>1]|0);m=k+12|0;n=c[m>>2]|0;if((n|0)>-1&l)ic[c[(c[w>>2]|0)+8>>2]&127](w,n>>21,n&2097151);if(l|(n|0)>-1){d=d+1|0;k=k+16|0}else{v=c[m>>2]|0;d=d-v|0;k=k+(0-v<<4)|0}}while((d|0)<(o|0))}else f=0;if((c[6167]|0)<(f|0))c[6167]=f;break}case 1:{if((c[v+152>>2]|0)>0){h=0;do{f=c[v+160>>2]|0;if(((r&65535)>=(e[f+(h<<5)>>1]|0)?(u&65535)<=(e[f+(h<<5)+6>>1]|0):0)&(s&65535)<=(e[f+(h<<5)+10>>1]|0)&(j&65535)>=(e[f+(h<<5)+4>>1]|0)&(t&65535)<=(e[f+(h<<5)+8>>1]|0)&(q&65535)>=(e[f+(h<<5)+2>>1]|0)){p=c[f+(h<<5)+12>>2]|0;o=c[f+(h<<5)+16>>2]|0;if((o|0)>0){d=p;k=(c[v+136>>2]|0)+(p<<4)|0;f=0;do{f=f+1|0;l=((r&65535)>=(e[k>>1]|0)?(u&65535)<=(e[k+6>>1]|0):0)&(s&65535)<=(e[k+10>>1]|0)&(j&65535)>=(e[k+4>>1]|0)&(t&65535)<=(e[k+8>>1]|0)&(q&65535)>=(e[k+2>>1]|0);m=k+12|0;n=c[m>>2]|0;if((n|0)>-1&l)ic[c[(c[w>>2]|0)+8>>2]&127](w,n>>21,n&2097151);if(l|(n|0)>-1){d=d+1|0;k=k+16|0}else{n=c[m>>2]|0;d=d-n|0;k=k+(0-n<<4)|0}}while((d|0)<(o+p|0))}else f=0;if((c[6167]|0)<(f|0))c[6167]=f}h=h+1|0}while((h|0)<(c[v+152>>2]|0))}break}case 2:{Lk(c[v+136>>2]|0,w,w+66|0,w+60|0);break}default:{}}i=w;return}function je(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;a[b+20>>0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;c[b+24>>2]=d;g[b+28>>2]=0.0;c[b+32>>2]=0;c[b+36>>2]=1;g[b+40>>2]=1.0;a[b+44>>0]=1;c[b+48>>2]=0;a[b+52>>0]=0;a[b+53>>0]=1;a[b+54>>0]=1;g[b+56>>2]=.03999999910593033;a[b+60>>0]=0;g[b+64>>2]=0.0;c[b+68>>2]=e;c[b+72>>2]=0;a[b+76>>0]=1;c[b+80>>2]=0;c[b+84>>2]=0;c[b+88>>2]=0;g[b+92>>2]=.6000000238418579;g[b+96>>2]=1.0;g[b+100>>2]=.30000001192092896;g[b+104>>2]=.01666666753590107;g[b+108>>2]=0.0;g[b+116>>2]=20.0;c[b+112>>2]=10;g[b+124>>2]=.20000000298023224;g[b+128>>2]=.800000011920929;g[b+132>>2]=0.0;g[b+120>>2]=1.0;c[b+136>>2]=1;g[b+140>>2]=-.03999999910593033;g[b+144>>2]=.10000000149011612;g[b+148>>2]=0.0;g[b+152>>2]=.8500000238418579;c[b+156>>2]=260;c[b+160>>2]=2;c[b+164>>2]=128;g[b+168>>2]=100.0;g[b+172>>2]=1000000015047466219876688.0e6;c[b>>2]=4144;a[b+192>>0]=1;c[b+188>>2]=0;c[b+180>>2]=0;c[b+184>>2]=0;c[b+196>>2]=0;c[b+200>>2]=f;a[b+224>>0]=1;c[b+220>>2]=0;c[b+212>>2]=0;c[b+216>>2]=0;a[b+244>>0]=1;c[b+240>>2]=0;c[b+232>>2]=0;c[b+236>>2]=0;c[b+248>>2]=0;c[b+252>>2]=-1054867456;a[b+274>>0]=0;a[b+275>>0]=0;c[b+256>>2]=0;c[b+256+4>>2]=0;c[b+256+8>>2]=0;c[b+256+12>>2]=0;a[b+292>>0]=1;c[b+288>>2]=0;c[b+280>>2]=0;c[b+284>>2]=0;c[b+296>>2]=0;a[b+300>>0]=1;a[b+320>>0]=1;c[b+316>>2]=0;c[b+308>>2]=0;c[b+312>>2]=0;if(!f){c[6435]=(c[6435]|0)+1;f=yc(215)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[f>>2]=4756;a[f+20>>0]=1;c[f+16>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[f+40>>0]=1;c[f+36>>2]=0;c[f+28>>2]=0;c[f+32>>2]=0;a[f+60>>0]=1;c[f+56>>2]=0;c[f+48>>2]=0;c[f+52>>2]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;a[f+160>>0]=1;c[f+156>>2]=0;c[f+148>>2]=0;c[f+152>>2]=0;a[f+180>>0]=1;c[f+176>>2]=0;c[f+168>>2]=0;c[f+172>>2]=0;c[f+192>>2]=0;c[b+200>>2]=f;a[b+273>>0]=1}else a[b+273>>0]=0;c[6435]=(c[6435]|0)+1;f=yc(87)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[f>>2]=5456;a[f+20>>0]=1;c[f+16>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[f+40>>0]=1;c[f+36>>2]=0;c[f+28>>2]=0;c[f+32>>2]=0;a[f+60>>0]=1;c[f+56>>2]=0;c[f+48>>2]=0;c[f+52>>2]=0;a[f+64>>0]=1;c[b+204>>2]=f;a[b+272>>0]=1;c[6435]=(c[6435]|0)+1;f=yc(107)|0;if(!f){e=0;h=c[b+200>>2]|0;c[e>>2]=4356;f=e+4|0;c[f>>2]=0;f=e+8|0;c[f>>2]=h;f=e+12|0;c[f>>2]=0;f=e+16|0;c[f>>2]=0;f=e+20|0;c[f>>2]=0;f=e+24|0;c[f>>2]=d;d=e+44|0;a[d>>0]=1;d=e+40|0;c[d>>2]=0;d=e+32|0;c[d>>2]=0;d=e+36|0;c[d>>2]=0;d=e+64|0;a[d>>0]=1;d=e+60|0;c[d>>2]=0;d=e+52|0;c[d>>2]=0;d=e+56|0;c[d>>2]=0;d=e+84|0;a[d>>0]=1;d=e+80|0;c[d>>2]=0;d=e+72|0;c[d>>2]=0;d=e+76|0;c[d>>2]=0;c[b+196>>2]=e;return}c[(f+4+15&-16)+-4>>2]=f;h=f+4+15&-16;f=c[b+200>>2]|0;c[h>>2]=4356;e=h+4|0;c[e>>2]=0;e=h+8|0;c[e>>2]=f;e=h+12|0;c[e>>2]=0;e=h+16|0;c[e>>2]=0;e=h+20|0;c[e>>2]=0;e=h+24|0;c[e>>2]=d;d=h+44|0;a[d>>0]=1;d=h+40|0;c[d>>2]=0;d=h+32|0;c[d>>2]=0;d=h+36|0;c[d>>2]=0;d=h+64|0;a[d>>0]=1;d=h+60|0;c[d>>2]=0;d=h+52|0;c[d>>2]=0;d=h+56|0;c[d>>2]=0;d=h+84|0;a[d>>0]=1;d=h+80|0;c[d>>2]=0;d=h+72|0;c[d>>2]=0;d=h+76|0;c[d>>2]=0;c[b+196>>2]=h;return}function ke(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0,k=0.0,l=0,m=0,n=0.0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0,w=0.0;u=i;i=i+96|0;s=c[b+12>>2]|0;mc[c[(c[s>>2]|0)+8>>2]&127](s,(c[b+8>>2]|0)+4|0,u+80|0,u+64|0);s=c[d+68>>2]|0;yb[c[(c[s>>2]|0)+16>>2]&31](s,c[(c[b+8>>2]|0)+188>>2]|0,u+80|0,u+64|0,c[d+24>>2]|0);s=c[d+24>>2]|0;mc[c[(c[s>>2]|0)+32>>2]&127](s,c[(c[b+8>>2]|0)+284>>2]|0,d+28|0,s);s=c[b+8>>2]|0;c[b+92>>2]=c[s+52>>2];c[b+92+4>>2]=c[s+52+4>>2];c[b+92+8>>2]=c[s+52+8>>2];c[b+92+12>>2]=c[s+52+12>>2];s=c[s+284>>2]|0;if((Eb[c[(c[s>>2]|0)+36>>2]&127](s)|0)>0){s=0;h=0.0;d=0;do{e=c[b+132>>2]|0;if((e|0)<0){if((c[b+136>>2]|0)<0){f=c[b+140>>2]|0;if(f|0){if(a[b+144>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+140>>2]=0}a[b+144>>0]=1;c[b+140>>2]=0;c[b+136>>2]=0}do{c[(c[b+140>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[b+132>>2]=0;e=c[(c[b+8>>2]|0)+284>>2]|0;e=c[(Eb[c[(c[e>>2]|0)+28>>2]&127](e)|0)+12>>2]|0;r=c[c[e+(s<<4)>>2]>>2]|0;f=c[c[e+(s<<4)+4>>2]>>2]|0;if(!((r|0)!=0?(c[r+204>>2]&4|0)!=0:0))t=14;do if((t|0)==14){t=0;if(f|0?c[f+204>>2]&4|0:0)break;e=c[e+(s<<4)+8>>2]|0;if(e|0)Cb[c[(c[e>>2]|0)+16>>2]&127](e,b+128|0);q=c[b+132>>2]|0;if((q|0)>0){o=c[b+140>>2]|0;p=c[b+8>>2]|0;r=0;do{m=c[o+(r<<2)>>2]|0;n=(c[m+740>>2]|0)==(p|0)?-1.0:1.0;e=c[m+748>>2]|0;if((e|0)>0){l=0;do{k=+g[m+4+(l*184|0)+80>>2];if(k<0.0){j=m+4+(l*184|0)+64|0;if(k<h){d=m+4+(l*184|0)+68|0;v=n*+g[d>>2];f=m+4+(l*184|0)+72|0;h=n*+g[f>>2];g[b+152>>2]=n*+g[j>>2];g[b+156>>2]=v;g[b+160>>2]=h;g[b+164>>2]=0.0;e=c[m+748>>2]|0;h=k}else{d=m+4+(l*184|0)+68|0;f=m+4+(l*184|0)+72|0}w=k*n*+g[d>>2]*.20000000298023224;v=k*n*+g[f>>2]*.20000000298023224;g[b+92>>2]=k*n*+g[j>>2]*.20000000298023224+ +g[b+92>>2];g[b+96>>2]=w+ +g[b+96>>2];g[b+100>>2]=v+ +g[b+100>>2];d=1}l=l+1|0}while((l|0)<(e|0))}r=r+1|0}while((r|0)!=(q|0))}}while(0);s=s+1|0;r=c[(c[b+8>>2]|0)+284>>2]|0}while((s|0)<(Eb[c[(c[r>>2]|0)+36>>2]&127](r)|0))}else d=0;t=c[b+8>>2]|0;c[u>>2]=c[t+4>>2];c[u+4>>2]=c[t+4+4>>2];c[u+8>>2]=c[t+4+8>>2];c[u+12>>2]=c[t+4+12>>2];c[u+16>>2]=c[t+20>>2];c[u+16+4>>2]=c[t+20+4>>2];c[u+16+8>>2]=c[t+20+8>>2];c[u+16+12>>2]=c[t+20+12>>2];c[u+32>>2]=c[t+36>>2];c[u+32+4>>2]=c[t+36+4>>2];c[u+32+8>>2]=c[t+36+8>>2];c[u+32+12>>2]=c[t+36+12>>2];c[u+48>>2]=c[b+92>>2];c[u+48+4>>2]=c[b+92+4>>2];c[u+48+8>>2]=c[b+92+8>>2];c[u+48+12>>2]=c[b+92+12>>2];c[t+260>>2]=(c[t+260>>2]|0)+1;c[t+4>>2]=c[u>>2];c[t+4+4>>2]=c[u+4>>2];c[t+4+8>>2]=c[u+8>>2];c[t+4+12>>2]=c[u+12>>2];c[t+20>>2]=c[u+16>>2];c[t+20+4>>2]=c[u+16+4>>2];c[t+20+8>>2]=c[u+16+8>>2];c[t+20+12>>2]=c[u+16+12>>2];c[t+36>>2]=c[u+32>>2];c[t+36+4>>2]=c[u+32+4>>2];c[t+36+8>>2]=c[u+32+8>>2];c[t+36+12>>2]=c[u+32+12>>2];c[t+52>>2]=c[u+48>>2];c[t+52+4>>2]=c[u+48+4>>2];c[t+52+8>>2]=c[u+48+8>>2];c[t+52+12>>2]=c[u+48+12>>2];i=u;return d|0}function le(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0,u=0.0;s=i;i=i+48|0;c[s+16>>2]=c[e>>2];c[s+16+4>>2]=c[e+4>>2];c[s+16+8>>2]=c[e+8>>2];c[s+16+12>>2]=c[e+12>>2];c[s+16+16>>2]=c[f>>2];c[s+16+16+4>>2]=c[f+4>>2];c[s+16+16+8>>2]=c[f+8>>2];c[s+16+16+12>>2]=c[f+12>>2];do if((c[d+60>>2]|0)==2){h=c[d+48>>2]|0;hh(b+64|0,h)|0;j=c[b+68>>2]|0;if(j|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[b+68>>2]=h;c[b+76>>2]=(c[b+76>>2]|0)+-1;h=c[b+8>>2]|0;if(!h){c[6435]=(c[6435]|0)+1;h=yc(63)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}j=h;k=j+44|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(k|0))}else c[b+8>>2]=0;c[h+32>>2]=0;c[h+36>>2]=d;c[h+40>>2]=0;c[h>>2]=c[s+16>>2];c[h+4>>2]=c[s+16+4>>2];c[h+8>>2]=c[s+16+8>>2];c[h+12>>2]=c[s+16+12>>2];c[h+16>>2]=c[s+16+16>>2];c[h+20>>2]=c[s+16+20>>2];c[h+24>>2]=c[s+16+24>>2];c[h+28>>2]=c[s+16+28>>2];lf(b+4|0,c[b+4>>2]|0,h);c[b+16>>2]=(c[b+16>>2]|0)+1;c[d+48>>2]=h;k=1}else{c[b+168>>2]=(c[b+168>>2]|0)+1;r=c[d+48>>2]|0;if(((((+g[r>>2]<=+g[s+16+16>>2]?+g[r+16>>2]>=+g[s+16>>2]:0)?+g[r+4>>2]<=+g[s+16+20>>2]:0)?+g[r+20>>2]>=+g[s+16+4>>2]:0)?+g[r+8>>2]<=+g[s+16+24>>2]:0)?+g[r+24>>2]>=+g[s+16+8>>2]:0){l=+g[d+16>>2];t=+g[e>>2]-l;m=+g[d+20>>2];o=+g[e+4>>2]-m;n=+g[d+24>>2];p=+g[e+8>>2]-n;u=+g[b+140>>2];l=(+g[d+32>>2]-l)*.5*u;m=(+g[d+36>>2]-m)*.5*u;n=u*(+g[d+40>>2]-n)*.5;g[s>>2]=l;g[s+4>>2]=m;g[s+8>>2]=n;g[s+12>>2]=0.0;if(t<0.0)g[s>>2]=-l;if(o<0.0)g[s+4>>2]=-m;if(p<0.0)g[s+8>>2]=-n;if(jh(b+4|0,r,s+16|0,s,.05000000074505806)|0){c[b+172>>2]=(c[b+172>>2]|0)+1;h=1}else h=0;k=h;break}h=hh(b+4|0,r)|0;a:do if(h){k=c[b+12>>2]|0;if((k|0)<=-1){h=c[b+4>>2]|0;break}if((k|0)>0){q=0;while(1){j=c[h+32>>2]|0;q=q+1|0;if(!j)break a;if((q|0)>=(k|0)){h=j;break}else h=j}}}else h=0;while(0);c[r>>2]=c[s+16>>2];c[r+4>>2]=c[s+16+4>>2];c[r+8>>2]=c[s+16+8>>2];c[r+12>>2]=c[s+16+12>>2];c[r+16>>2]=c[s+16+16>>2];c[r+20>>2]=c[s+16+20>>2];c[r+24>>2]=c[s+16+24>>2];c[r+28>>2]=c[s+16+28>>2];lf(b+4|0,h,r);c[b+172>>2]=(c[b+172>>2]|0)+1;k=1}while(0);h=c[d+52>>2]|0;j=c[d+56>>2]|0;if(!h)c[b+124+(c[d+60>>2]<<2)>>2]=j;else c[h+56>>2]=j;h=c[d+56>>2]|0;if(h|0)c[h+52>>2]=c[d+52>>2];c[d+16>>2]=c[e>>2];c[d+16+4>>2]=c[e+4>>2];c[d+16+8>>2]=c[e+8>>2];c[d+16+12>>2]=c[e+12>>2];c[d+32>>2]=c[f>>2];c[d+32+4>>2]=c[f+4>>2];c[d+32+8>>2]=c[f+8>>2];c[d+32+12>>2]=c[f+12>>2];h=c[b+144>>2]|0;c[d+60>>2]=h;c[d+52>>2]=0;c[d+56>>2]=c[b+124+(h<<2)>>2];j=c[b+124+(h<<2)>>2]|0;if(j|0)c[j+52>>2]=d;c[b+124+(h<<2)>>2]=d;if(!k){i=s;return}a[b+194>>0]=1;if(a[b+193>>0]|0){i=s;return}c[s>>2]=8904;c[s+4>>2]=b;we(b+64|0,c[b+64>>2]|0,c[d+48>>2]|0,s);we(b+4|0,c[b+4>>2]|0,c[d+48>>2]|0,s);i=s;return}function me(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+352|0;e=c[d+36>>2]|0;c[m+288+4>>2]=35;c[m+288+8>>2]=0;c[m+288+12>>2]=1065353216;c[m+288+16>>2]=1065353216;c[m+288+20>>2]=1065353216;g[m+288+24>>2]=0.0;c[m+288>>2]=3436;c[m+288+52>>2]=e;g[m+288+44>>2]=0.0;k=c[b+28>>2]|0;d=c[k+4>>2]|0;if(c[(c[k+8>>2]|0)+204>>2]&3|0?a[e+376>>0]|0:0){i=m;return}if((a[22456]|0)==0?Wa(22456)|0:0){if((a[22464]|0)==0?Wa(22464)|0:0){c[5698]=1065353216;c[5699]=0;c[5700]=0;c[5701]=0;c[5702]=0;c[5703]=1065353216;c[5704]=0;c[5705]=0;c[5706]=0;c[5707]=0;c[5708]=1065353216;g[5709]=0.0;_a(22464)}c[5710]=c[5698];c[5711]=c[5699];c[5712]=c[5700];c[5713]=c[5701];c[5714]=c[5702];c[5715]=c[5703];c[5716]=c[5704];c[5717]=c[5705];c[5718]=c[5706];c[5719]=c[5707];c[5720]=c[5708];c[5721]=c[5709];c[5722]=0;c[5723]=0;c[5724]=0;c[5725]=0;_a(22456)}f=c[(c[b+28>>2]|0)+12>>2]|0;c[m>>2]=1065353216;c[m+4>>2]=0;c[m+8>>2]=0;g[m+12>>2]=0.0;if(!(!(Jd(m+288|0,22840,d,f,m,m+232|0)|0)?!(Pc(m+288|0,22840,d,f,m,m+232|0,0)|0):0)){k=m+16+4|0;a[m+16+152>>0]=0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[m+16>>2]=3256;k=c[(c[b+28>>2]|0)+8>>2]|0;do if(jd(b,m+232|0,e,0,0,0,(c[k+236>>2]&2|0)==0?0:k,k,m+16|0)|0){c[6435]=(c[6435]|0)+1;d=yc(235)|0;if(!d)k=0;else{c[(d+4+15&-16)+-4>>2]=d;k=d+4+15&-16}d=k+152|0;Qn(k|0,0,156)|0;c[k>>2]=3256;e=k+4|0;f=m+16+4|0;h=e+100|0;do{c[e>>2]=c[f>>2];e=e+4|0;f=f+4|0}while((e|0)<(h|0));e=k+104|0;c[e>>2]=c[m+16+104>>2];c[e+4>>2]=c[m+16+104+4>>2];c[e+8>>2]=c[m+16+104+8>>2];c[e+12>>2]=c[m+16+104+12>>2];e=k+120|0;c[e>>2]=c[m+16+120>>2];c[e+4>>2]=c[m+16+120+4>>2];c[e+8>>2]=c[m+16+120+8>>2];c[e+12>>2]=c[m+16+120+12>>2];e=k+136|0;c[e>>2]=c[m+16+136>>2];c[e+4>>2]=c[m+16+136+4>>2];c[e+8>>2]=c[m+16+136+8>>2];c[e+12>>2]=c[m+16+136+12>>2];a[d>>0]=a[m+16+152>>0]|0;e=k+156|0;f=m+16+156|0;h=e+60|0;do{c[e>>2]=c[f>>2];e=e+4|0;f=f+4|0}while((e|0)<(h|0));h=c[b+24>>2]|0;j=k;d=c[h+852>>2]|0;if((d|0)==(c[h+856>>2]|0)?(l=d|0?d<<1:1,(d|0)<(l|0)):0){if(!l)f=0;else{c[6435]=(c[6435]|0)+1;d=yc((l<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}f=d;d=c[h+852>>2]|0}if((d|0)>0){e=0;do{c[f+(e<<2)>>2]=c[(c[h+860>>2]|0)+(e<<2)>>2];e=e+1|0}while((e|0)!=(d|0))}e=c[h+860>>2]|0;if(e){if(a[h+864>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);d=c[h+852>>2]|0}c[h+860>>2]=0}a[h+864>>0]=1;c[h+860>>2]=f;c[h+856>>2]=l}c[(c[h+860>>2]|0)+(d<<2)>>2]=j;c[h+852>>2]=d+1;d=c[b+24>>2]|0;if(!(c[(c[(c[b+28>>2]|0)+8>>2]|0)+204>>2]&3)){b=k+64|0;g[b>>2]=+g[d+340>>2]*+g[b>>2];b=k+68|0;g[b>>2]=+g[d+352>>2]*+g[b>>2];break}else{b=k+64|0;g[b>>2]=+g[d+344>>2]*+g[b>>2];b=k+68|0;g[b>>2]=+g[d+356>>2]*+g[b>>2];break}}while(0)}i=m;return}function ne(b,d,e,f,h,i,j,l){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;l=l|0;var m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;c[b+4>>2]=4;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=d;c[b+32>>2]=e;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=4704;g[b+688>>2]=0.0;g[b+692>>2]=-1.0;g[b+696>>2]=.8999999761581421;g[b+700>>2]=.30000001192092896;g[b+704>>2]=1.0;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;a[b+736>>0]=0;a[b+737>>0]=0;a[b+738>>0]=0;a[b+739>>0]=1;a[b+740>>0]=l&1;c[b+748>>2]=0;c[b+600>>2]=c[f>>2];c[b+600+4>>2]=c[f+4>>2];c[b+600+8>>2]=c[f+8>>2];c[b+600+12>>2]=c[f+12>>2];m=+g[d+4>>2];n=+g[d+20>>2];o=+g[d+36>>2];p=+g[i>>2];q=+g[i+4>>2];r=+g[i+8>>2];do if(!(m*p+n*q+o*r>=.9999998807907104))if(!(m*p+n*q+o*r<=-.9999998807907104)){e=(g[k>>2]=o*q-n*r,c[k>>2]|0);f=(g[k>>2]=m*r-o*p,c[k>>2]|0);l=(g[k>>2]=n*p-m*q,c[k>>2]|0);u=(g[k>>2]=r*(m*r-o*p)-q*(n*p-m*q),c[k>>2]|0);v=(g[k>>2]=p*(n*p-m*q)-r*(o*q-n*r),c[k>>2]|0);t=(g[k>>2]=q*(o*q-n*r)-p*(m*r-o*p),c[k>>2]|0);break}else{u=c[d+12>>2]|0;v=c[d+28>>2]|0;t=c[d+44>>2]|0;e=c[d+8>>2]|0;l=c[d+40>>2]|0;f=c[d+24>>2]|0;break}else{u=(g[k>>2]=-+g[d+12>>2],c[k>>2]|0);v=(g[k>>2]=-+g[d+28>>2],c[k>>2]|0);t=(g[k>>2]=-+g[d+44>>2],c[k>>2]|0);e=c[d+8>>2]|0;l=c[d+40>>2]|0;f=c[d+24>>2]|0}while(0);c[b+552>>2]=u;c[b+556>>2]=e;c[b+560>>2]=c[i>>2];g[b+564>>2]=0.0;c[b+568>>2]=v;c[b+572>>2]=f;c[b+576>>2]=c[i+4>>2];g[b+580>>2]=0.0;c[b+584>>2]=t;c[b+588>>2]=l;c[b+592>>2]=c[i+8>>2];g[b+596>>2]=0.0;o=+g[i+4>>2];q=+g[j+8>>2];m=+g[i+8>>2];r=+g[j+4>>2];s=+g[j>>2];n=+g[i>>2];do if(q*m+(o*r+s*n)<-.9999998807907104)if(+N(+m)>.7071067690849304){n=1.0/+O(+(o*o+m*m));e=0;p=0.0;m=-(m*n);f=(g[k>>2]=o*n,c[k>>2]|0);break}else{m=1.0/+O(+(o*o+n*n));e=(g[k>>2]=-(o*m),c[k>>2]|0);p=0.0;m=n*m;f=0;break}else{w=+O(+((q*m+(o*r+s*n)+1.0)*2.0));e=(g[k>>2]=(o*q-m*r)*(1.0/w),c[k>>2]|0);p=w*.5;m=(m*s-q*n)*(1.0/w);f=(g[k>>2]=(r*n-o*s)*(1.0/w),c[k>>2]|0)}while(0);o=(c[k>>2]=u,+g[k>>2]);A=(c[k>>2]=t,+g[k>>2]);z=(c[k>>2]=f,+g[k>>2]);w=(c[k>>2]=v,+g[k>>2]);B=o*p+A*m-w*z;n=(c[k>>2]=e,+g[k>>2]);x=w*p+o*z-A*n;y=A*p+w*n-o*m;A=-(o*n)-w*m-A*z;m=-m;w=x*-z+(p*B+A*-n)-y*m;o=y*-n+(p*x+A*m)-B*-z;p=B*m+(A*-z+p*y)-x*-n;c[b+664>>2]=c[h>>2];c[b+664+4>>2]=c[h+4>>2];c[b+664+8>>2]=c[h+8>>2];c[b+664+12>>2]=c[h+12>>2];g[b+616>>2]=w;g[b+620>>2]=r*p-q*o;c[b+624>>2]=c[j>>2];g[b+628>>2]=0.0;g[b+632>>2]=o;g[b+636>>2]=q*w-s*p;c[b+640>>2]=c[j+4>>2];g[b+644>>2]=0.0;g[b+648>>2]=p;g[b+652>>2]=s*o-r*w;c[b+656>>2]=c[j+8>>2];g[b+660>>2]=0.0;g[b+732>>2]=a[b+740>>0]|0?-1.0:1.0;return}function oe(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0;p=i;i=i+144|0;if((c[a+16>>2]|0)<=0){o=a+76|0;c[o>>2]=c[b>>2];c[o+4>>2]=c[b+4>>2];c[o+8>>2]=c[b+8>>2];c[o+12>>2]=c[b+12>>2];b=c[a>>2]|0;b=b+68|0;b=c[b>>2]|0;Ab[b&255](a);i=p;return}j=p+16+16|0;k=p+16+32|0;l=p+16+48|0;o=0;do{n=c[a+24>>2]|0;m=n+(o*80|0)|0;c[p+16>>2]=c[m>>2];c[p+16+4>>2]=c[m+4>>2];c[p+16+8>>2]=c[m+8>>2];c[p+16+12>>2]=c[m+12>>2];m=n+(o*80|0)+16|0;c[j>>2]=c[m>>2];c[j+4>>2]=c[m+4>>2];c[j+8>>2]=c[m+8>>2];c[j+12>>2]=c[m+12>>2];m=n+(o*80|0)+32|0;c[k>>2]=c[m>>2];c[k+4>>2]=c[m+4>>2];c[k+8>>2]=c[m+8>>2];c[k+12>>2]=c[m+12>>2];m=n+(o*80|0)+48|0;c[l>>2]=c[m>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];n=c[n+(o*80|0)+64>>2]|0;n=Eb[c[(c[n>>2]|0)+28>>2]&127](n)|0;c[p>>2]=c[n>>2];c[p+4>>2]=c[n+4>>2];c[p+8>>2]=c[n+8>>2];q=+g[p+4>>2]*+g[b+4>>2]/+g[a+80>>2];r=+g[p+8>>2]*+g[b+8>>2]/+g[a+84>>2];g[p>>2]=+g[p>>2]*+g[b>>2]/+g[a+76>>2];g[p+4>>2]=q;g[p+8>>2]=r;g[p+12>>2]=0.0;n=c[(c[a+24>>2]|0)+(o*80|0)+64>>2]|0;Cb[c[(c[n>>2]|0)+24>>2]&127](n,p);r=+g[p+16+52>>2]*+g[b+4>>2]/+g[a+80>>2];q=+g[p+16+56>>2]*+g[b+8>>2]/+g[a+84>>2];g[p+16+48>>2]=+g[l>>2]*+g[b>>2]/+g[a+76>>2];g[p+16+52>>2]=r;g[p+16+56>>2]=q;g[p+16+60>>2]=0.0;n=c[a+24>>2]|0;m=n+(o*80|0)|0;c[m>>2]=c[p+16>>2];c[m+4>>2]=c[p+16+4>>2];c[m+8>>2]=c[p+16+8>>2];c[m+12>>2]=c[p+16+12>>2];m=n+(o*80|0)+16|0;c[m>>2]=c[j>>2];c[m+4>>2]=c[j+4>>2];c[m+8>>2]=c[j+8>>2];c[m+12>>2]=c[j+12>>2];m=n+(o*80|0)+32|0;c[m>>2]=c[k>>2];c[m+4>>2]=c[k+4>>2];c[m+8>>2]=c[k+8>>2];c[m+12>>2]=c[k+12>>2];n=n+(o*80|0)+48|0;c[n>>2]=c[l>>2];c[n+4>>2]=c[l+4>>2];c[n+8>>2]=c[l+8>>2];c[n+12>>2]=c[l+12>>2];if(c[a+64>>2]|0){m=c[(c[a+24>>2]|0)+(o*80|0)+64>>2]|0;mc[c[(c[m>>2]|0)+8>>2]&127](m,p+16|0,p+128|0,p+112|0);c[p+80>>2]=c[p+128>>2];c[p+80+4>>2]=c[p+128+4>>2];c[p+80+8>>2]=c[p+128+8>>2];c[p+80+12>>2]=c[p+128+12>>2];c[p+80+16>>2]=c[p+112>>2];c[p+80+16+4>>2]=c[p+112+4>>2];c[p+80+16+8>>2]=c[p+112+8>>2];c[p+80+16+12>>2]=c[p+112+12>>2];m=c[a+64>>2]|0;n=c[(c[a+24>>2]|0)+(o*80|0)+76>>2]|0;d=hh(m,n)|0;a:do if(d){f=c[m+8>>2]|0;if((f|0)<=-1){d=c[m>>2]|0;break}if((f|0)>0){h=0;while(1){e=c[d+32>>2]|0;h=h+1|0;if(!e)break a;if((h|0)>=(f|0)){d=e;break}else d=e}}}else d=0;while(0);c[n>>2]=c[p+80>>2];c[n+4>>2]=c[p+80+4>>2];c[n+8>>2]=c[p+80+8>>2];c[n+12>>2]=c[p+80+12>>2];c[n+16>>2]=c[p+80+16>>2];c[n+20>>2]=c[p+80+20>>2];c[n+24>>2]=c[p+80+24>>2];c[n+28>>2]=c[p+80+28>>2];lf(m,d,n)}o=o+1|0}while((o|0)<(c[a+16>>2]|0));o=a+76|0;c[o>>2]=c[b>>2];c[o+4>>2]=c[b+4>>2];c[o+8>>2]=c[b+8>>2];c[o+12>>2]=c[b+12>>2];b=c[a>>2]|0;b=b+68|0;b=c[b>>2]|0;Ab[b&255](a);i=p;return}function pe(d,f,h,i,j,k){d=d|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0.0,m=0.0,n=0.0;c[d>>2]=8520;b[d+4>>1]=-2;b[d+6>>1]=-1;c[d+92>>2]=j;c[d+96>>2]=0;a[d+100>>0]=0;c[d+104>>2]=0;c[d+108>>2]=0;if(!j){c[6435]=(c[6435]|0)+1;j=yc(95)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}Ri(j);c[d+92>>2]=j;a[d+100>>0]=1}if(!k){c[6435]=(c[6435]|0)+1;j=yc(43)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}c[j>>2]=0;c[j+4>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[j+16>>2]=0;c[j+20>>2]=0;c[j>>2]=8584;a[j+20>>0]=1;c[j+16>>2]=0;c[j+8>>2]=0;c[j+12>>2]=0;c[d+112>>2]=j;c[6435]=(c[6435]|0)+1;j=yc(215)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}Zh(j,c[d+112>>2]|0);c[d+108>>2]=j;a[j+193>>0]=1}c[d+8>>2]=c[f>>2];c[d+8+4>>2]=c[f+4>>2];c[d+8+8>>2]=c[f+8>>2];c[d+8+12>>2]=c[f+12>>2];c[d+24>>2]=c[h>>2];c[d+24+4>>2]=c[h+4>>2];c[d+24+8>>2]=c[h+8>>2];c[d+24+12>>2]=c[h+12>>2];n=+(e[d+6>>1]|0);m=n/(+g[d+28>>2]-+g[d+12>>2]);l=n/(+g[d+32>>2]-+g[d+16>>2]);g[d+40>>2]=n/(+g[d+24>>2]-+g[d+8>>2]);g[d+44>>2]=m;g[d+48>>2]=l;g[d+52>>2]=0.0;f=(i&65535)+1&65535;c[6435]=(c[6435]|0)+1;j=yc(f<<6|19)|0;if(!j)h=0;else{c[(j+4+15&-16)+-4>>2]=j;h=j+4+15&-16}if(f|0){j=h+(f<<6)|0;k=h;do{c[k>>2]=0;c[k+8>>2]=0;k=k+64|0}while((k|0)!=(j|0))}c[d+60>>2]=h;b[d+58>>1]=(i&65535)+1;b[d+56>>1]=0;b[d+64>>1]=1;if(f>>>0>1){j=1;k=1;do{b[h+(j<<6)+48>>1]=j+1;k=k+1<<16>>16;j=k&65535}while(j>>>0<f>>>0)}b[h+(f+-1<<6)+48>>1]=0;c[6435]=(c[6435]|0)+1;j=yc((f<<3|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}c[d+80>>2]=j;c[d+68>>2]=j;c[6435]=(c[6435]|0)+1;j=yc((f<<3|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}c[d+84>>2]=j;c[d+72>>2]=j;c[6435]=(c[6435]|0)+1;j=yc((f<<3|3)+16|0)|0;if(!j){h=0;i=d+88|0;c[i>>2]=h;i=d+76|0;c[i>>2]=h;h=c[d+60>>2]|0;c[h>>2]=0;f=h+48|0;b[f>>1]=0;f=h+54|0;b[f>>1]=1;f=c[d+68>>2]|0;b[f>>1]=0;k=f+2|0;b[k>>1]=0;k=b[d+6>>1]|0;j=f+4|0;b[j>>1]=k;f=f+6|0;b[f>>1]=0;f=h+50|0;b[f>>1]=0;f=h+56|0;b[f>>1]=1;f=c[d+72>>2]|0;b[f>>1]=0;j=f+2|0;b[j>>1]=0;j=b[d+6>>1]|0;k=f+4|0;b[k>>1]=j;f=f+6|0;b[f>>1]=0;f=h+52|0;b[f>>1]=0;h=h+58|0;b[h>>1]=1;i=c[i>>2]|0;b[i>>1]=0;h=i+2|0;b[h>>1]=0;h=b[d+6>>1]|0;f=i+4|0;b[f>>1]=h;i=i+6|0;b[i>>1]=0;c[d>>2]=8660;return}c[(j+4+15&-16)+-4>>2]=j;h=j+4+15&-16;i=d+88|0;c[i>>2]=h;i=d+76|0;c[i>>2]=h;h=c[d+60>>2]|0;c[h>>2]=0;f=h+48|0;b[f>>1]=0;f=h+54|0;b[f>>1]=1;f=c[d+68>>2]|0;b[f>>1]=0;k=f+2|0;b[k>>1]=0;k=b[d+6>>1]|0;j=f+4|0;b[j>>1]=k;f=f+6|0;b[f>>1]=0;f=h+50|0;b[f>>1]=0;f=h+56|0;b[f>>1]=1;f=c[d+72>>2]|0;b[f>>1]=0;j=f+2|0;b[j>>1]=0;j=b[d+6>>1]|0;k=f+4|0;b[k>>1]=j;f=f+6|0;b[f>>1]=0;f=h+52|0;b[f>>1]=0;h=h+58|0;b[h>>1]=1;i=c[i>>2]|0;b[i>>1]=0;h=i+2|0;b[h>>1]=0;h=b[d+6>>1]|0;f=i+4|0;b[f>>1]=h;i=i+6|0;b[i>>1]=0;c[d>>2]=8660;return}function qe(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;Il();c[b+4>>2]=6;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=23268;c[b+32>>2]=d;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=4376;c[b+112>>2]=c[e>>2];c[b+112+4>>2]=c[e+4>>2];c[b+112+8>>2]=c[e+8>>2];c[b+112+12>>2]=c[e+12>>2];c[b+128>>2]=c[e+16>>2];c[b+128+4>>2]=c[e+16+4>>2];c[b+128+8>>2]=c[e+16+8>>2];c[b+128+12>>2]=c[e+16+12>>2];c[b+144>>2]=c[e+32>>2];c[b+144+4>>2]=c[e+32+4>>2];c[b+144+8>>2]=c[e+32+8>>2];c[b+144+12>>2]=c[e+32+12>>2];c[b+160>>2]=c[e+48>>2];c[b+160+4>>2]=c[e+48+4>>2];c[b+160+8>>2]=c[e+48+8>>2];c[b+160+12>>2]=c[e+48+12>>2];e=b+680|0;h=e+48|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(h|0));c[b+740>>2]=0;c[b+740+4>>2]=0;c[b+740+8>>2]=0;c[b+740+12>>2]=0;c[b+756>>2]=1045220557;c[b+760>>2]=1045220557;c[b+764>>2]=1045220557;c[b+768>>2]=0;c[b+768+4>>2]=0;c[b+768+8>>2]=0;c[b+768+12>>2]=0;c[b+768+16>>2]=0;g[b+728>>2]=.699999988079071;g[b+732>>2]=1.0;g[b+736>>2]=.5;a[b+788>>0]=0;g[b+792>>2]=0.0;g[b+808>>2]=0.0;a[b+789>>0]=0;g[b+796>>2]=0.0;g[b+812>>2]=0.0;a[b+790>>0]=0;g[b+800>>2]=0.0;g[b+816>>2]=0.0;g[b+928>>2]=0.0;g[b+876>>2]=0.0;g[b+880>>2]=.10000000149011612;g[b+884>>2]=300.0;g[b+868>>2]=1.0;g[b+872>>2]=-1.0;g[b+896>>2]=0.0;g[b+900>>2]=.20000000298023224;g[b+904>>2]=0.0;g[b+908>>2]=0.0;g[b+888>>2]=1.0;g[b+892>>2]=.5;c[b+924>>2]=0;g[b+916>>2]=0.0;a[b+912>>0]=0;g[b+992>>2]=0.0;g[b+940>>2]=0.0;g[b+944>>2]=.10000000149011612;g[b+948>>2]=300.0;g[b+932>>2]=1.0;g[b+936>>2]=-1.0;g[b+960>>2]=0.0;g[b+964>>2]=.20000000298023224;g[b+968>>2]=0.0;g[b+972>>2]=0.0;g[b+952>>2]=1.0;g[b+956>>2]=.5;c[b+988>>2]=0;g[b+980>>2]=0.0;a[b+976>>0]=0;g[b+1056>>2]=0.0;g[b+1004>>2]=0.0;g[b+1008>>2]=.10000000149011612;g[b+1012>>2]=300.0;g[b+996>>2]=1.0;g[b+1e3>>2]=-1.0;g[b+1024>>2]=0.0;g[b+1028>>2]=.20000000298023224;g[b+1032>>2]=0.0;g[b+1036>>2]=0.0;g[b+1016>>2]=1.0;g[b+1020>>2]=.5;c[b+1052>>2]=0;g[b+1044>>2]=0.0;a[b+1040>>0]=0;a[b+1300>>0]=f&1;a[b+1301>>0]=1;c[b+1304>>2]=0;a[b+1308>>0]=0;w=+g[b+112>>2];C=+g[d+4>>2];v=+g[b+128>>2];B=+g[d+8>>2];u=+g[b+144>>2];A=+g[d+12>>2];t=+g[b+116>>2];s=+g[b+132>>2];r=+g[b+148>>2];q=+g[b+120>>2];o=+g[b+136>>2];m=+g[b+152>>2];z=+g[d+20>>2];y=+g[d+24>>2];x=+g[d+28>>2];p=+g[d+36>>2];n=+g[d+40>>2];l=+g[d+44>>2];E=+g[b+160>>2];D=+g[b+164>>2];i=+g[b+168>>2];k=+g[d+52>>2]+(C*E+B*D+A*i);j=z*E+y*D+x*i+ +g[d+56>>2];i=p*E+n*D+l*i+ +g[d+60>>2];g[b+48>>2]=w*C+v*B+u*A;g[b+52>>2]=C*t+B*s+A*r;g[b+56>>2]=C*q+B*o+A*m;g[b+60>>2]=0.0;g[b+64>>2]=w*z+v*y+u*x;g[b+68>>2]=t*z+s*y+r*x;g[b+72>>2]=q*z+o*y+m*x;g[b+76>>2]=0.0;g[b+80>>2]=w*p+v*n+u*l;g[b+84>>2]=t*p+s*n+r*l;g[b+88>>2]=q*p+o*n+m*l;g[b+92>>2]=0.0;g[b+96>>2]=k;g[b+100>>2]=j;g[b+104>>2]=i;g[b+108>>2]=0.0;sd(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);return}function re(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0,X=0.0,Y=0.0;W=i;i=i+240|0;f=(a[b+8>>0]|0)!=0;h=f?e:d;f=f?d:e;S=+g[h+116>>2]-+g[h+52>>2];T=+g[h+120>>2]-+g[h+56>>2];U=+g[h+124>>2]-+g[h+60>>2];V=+g[h+252>>2];if(S*S+T*T+U*U<V*V){X=1.0;i=W;return +X}F=+g[f+4>>2];G=+g[f+20>>2];H=+g[f+36>>2];I=+g[f+8>>2];J=+g[f+24>>2];K=+g[f+40>>2];L=+g[f+12>>2];M=+g[f+28>>2];N=+g[f+44>>2];k=-+g[f+52>>2];l=-+g[f+56>>2];m=-+g[f+60>>2];O=+g[h+4>>2];P=+g[h+20>>2];Q=+g[h+36>>2];R=+g[h+8>>2];S=+g[h+24>>2];T=+g[h+40>>2];U=+g[h+12>>2];V=+g[h+28>>2];p=+g[h+44>>2];u=+g[h+52>>2];t=+g[h+56>>2];s=+g[h+60>>2];q=F*k+G*l+H*m+(F*u+G*t+H*s);r=I*k+J*l+K*m+(I*u+J*t+K*s);s=L*k+M*l+N*m+(L*u+M*t+N*s);t=+g[h+68>>2];u=+g[h+84>>2];v=+g[h+100>>2];w=+g[h+72>>2];x=+g[h+88>>2];y=+g[h+104>>2];z=+g[h+76>>2];A=+g[h+92>>2];B=+g[h+108>>2];n=+g[h+116>>2];o=+g[h+120>>2];E=+g[h+124>>2];C=F*k+G*l+H*m+(F*n+G*o+H*E);D=I*k+J*l+K*m+(I*n+J*o+K*E);E=L*k+M*l+N*m+(L*n+M*o+N*E);f=c[f+192>>2]|0;if(((c[f+4>>2]|0)+-21|0)>>>0>=9){X=1.0;i=W;return +X}g[W+224>>2]=q;g[W+224+4>>2]=r;g[W+224+8>>2]=s;g[W+224+12>>2]=0.0;if(C<q){g[W+224>>2]=C;j=C}else j=q;if(D<r){g[W+224+4>>2]=D;k=D}else k=r;if(E<s){g[W+224+8>>2]=E;l=E}else l=s;g[W+208>>2]=q;g[W+208+4>>2]=r;g[W+208+8>>2]=s;g[W+208+12>>2]=0.0;if(q<C){g[W+208>>2]=C;m=C}else m=q;if(r<D){g[W+208+4>>2]=D;n=D}else n=r;if(s<E){g[W+208+8>>2]=E;o=E}else o=s;Y=+g[h+248>>2];g[W+224>>2]=j-Y;g[W+224+4>>2]=k-Y;g[W+224+8>>2]=l-Y;g[W+208>>2]=Y+m;g[W+208+4>>2]=Y+n;g[W+208+8>>2]=Y+o;c[W>>2]=3688;g[W+4>>2]=F*O+G*P+H*Q;g[W+8>>2]=F*R+G*S+H*T;g[W+12>>2]=F*U+G*V+H*p;g[W+16>>2]=0.0;g[W+20>>2]=I*O+J*P+K*Q;g[W+24>>2]=I*R+J*S+K*T;g[W+28>>2]=I*U+J*V+K*p;g[W+32>>2]=0.0;g[W+36>>2]=L*O+M*P+N*Q;g[W+40>>2]=L*R+M*S+N*T;g[W+44>>2]=L*U+M*V+N*p;g[W+48>>2]=0.0;g[W+52>>2]=q;g[W+56>>2]=r;g[W+60>>2]=s;g[W+64>>2]=0.0;g[W+68>>2]=F*t+G*u+H*v;g[W+72>>2]=F*w+G*x+H*y;g[W+76>>2]=F*z+G*A+H*B;g[W+80>>2]=0.0;g[W+84>>2]=I*t+J*u+K*v;g[W+88>>2]=I*w+J*x+K*y;g[W+92>>2]=I*z+J*A+K*B;g[W+96>>2]=0.0;g[W+100>>2]=L*t+M*u+N*v;g[W+104>>2]=L*w+M*x+N*y;g[W+108>>2]=L*z+M*A+N*B;g[W+112>>2]=0.0;g[W+116>>2]=C;g[W+120>>2]=D;g[W+124>>2]=E;g[W+128>>2]=0.0;g[W+196>>2]=Y;c[W+200>>2]=c[h+244>>2];if(f|0?(mc[c[(c[f>>2]|0)+64>>2]&127](f,W,W+224|0,W+208|0),X=+g[W+200>>2],X<+g[h+244>>2]):0){g[h+244>>2]=X;Y=X;i=W;return +Y}Y=1.0;i=W;return +Y}function se(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0,X=0.0,Y=0.0;W=i;i=i+240|0;f=(a[b+8>>0]|0)!=0;h=f?e:d;f=f?d:e;S=+g[h+116>>2]-+g[h+52>>2];T=+g[h+120>>2]-+g[h+56>>2];U=+g[h+124>>2]-+g[h+60>>2];V=+g[h+252>>2];if(S*S+T*T+U*U<V*V){X=1.0;i=W;return +X}F=+g[f+4>>2];G=+g[f+20>>2];H=+g[f+36>>2];I=+g[f+8>>2];J=+g[f+24>>2];K=+g[f+40>>2];L=+g[f+12>>2];M=+g[f+28>>2];N=+g[f+44>>2];k=-+g[f+52>>2];l=-+g[f+56>>2];m=-+g[f+60>>2];O=+g[h+4>>2];P=+g[h+20>>2];Q=+g[h+36>>2];R=+g[h+8>>2];S=+g[h+24>>2];T=+g[h+40>>2];U=+g[h+12>>2];V=+g[h+28>>2];p=+g[h+44>>2];u=+g[h+52>>2];t=+g[h+56>>2];s=+g[h+60>>2];q=F*k+G*l+H*m+(F*u+G*t+H*s);r=I*k+J*l+K*m+(I*u+J*t+K*s);s=L*k+M*l+N*m+(L*u+M*t+N*s);t=+g[h+68>>2];u=+g[h+84>>2];v=+g[h+100>>2];w=+g[h+72>>2];x=+g[h+88>>2];y=+g[h+104>>2];z=+g[h+76>>2];A=+g[h+92>>2];B=+g[h+108>>2];n=+g[h+116>>2];o=+g[h+120>>2];E=+g[h+124>>2];C=F*k+G*l+H*m+(F*n+G*o+H*E);D=I*k+J*l+K*m+(I*n+J*o+K*E);E=L*k+M*l+N*m+(L*n+M*o+N*E);f=c[f+192>>2]|0;if(((c[f+4>>2]|0)+-21|0)>>>0>=9){X=1.0;i=W;return +X}g[W+224>>2]=q;g[W+224+4>>2]=r;g[W+224+8>>2]=s;g[W+224+12>>2]=0.0;if(C<q){g[W+224>>2]=C;j=C}else j=q;if(D<r){g[W+224+4>>2]=D;k=D}else k=r;if(E<s){g[W+224+8>>2]=E;l=E}else l=s;g[W+208>>2]=q;g[W+208+4>>2]=r;g[W+208+8>>2]=s;g[W+208+12>>2]=0.0;if(q<C){g[W+208>>2]=C;m=C}else m=q;if(r<D){g[W+208+4>>2]=D;n=D}else n=r;if(s<E){g[W+208+8>>2]=E;o=E}else o=s;Y=+g[h+248>>2];g[W+224>>2]=j-Y;g[W+224+4>>2]=k-Y;g[W+224+8>>2]=l-Y;g[W+208>>2]=Y+m;g[W+208+4>>2]=Y+n;g[W+208+8>>2]=Y+o;c[W>>2]=5556;g[W+4>>2]=F*O+G*P+H*Q;g[W+8>>2]=F*R+G*S+H*T;g[W+12>>2]=F*U+G*V+H*p;g[W+16>>2]=0.0;g[W+20>>2]=I*O+J*P+K*Q;g[W+24>>2]=I*R+J*S+K*T;g[W+28>>2]=I*U+J*V+K*p;g[W+32>>2]=0.0;g[W+36>>2]=L*O+M*P+N*Q;g[W+40>>2]=L*R+M*S+N*T;g[W+44>>2]=L*U+M*V+N*p;g[W+48>>2]=0.0;g[W+52>>2]=q;g[W+56>>2]=r;g[W+60>>2]=s;g[W+64>>2]=0.0;g[W+68>>2]=F*t+G*u+H*v;g[W+72>>2]=F*w+G*x+H*y;g[W+76>>2]=F*z+G*A+H*B;g[W+80>>2]=0.0;g[W+84>>2]=I*t+J*u+K*v;g[W+88>>2]=I*w+J*x+K*y;g[W+92>>2]=I*z+J*A+K*B;g[W+96>>2]=0.0;g[W+100>>2]=L*t+M*u+N*v;g[W+104>>2]=L*w+M*x+N*y;g[W+108>>2]=L*z+M*A+N*B;g[W+112>>2]=0.0;g[W+116>>2]=C;g[W+120>>2]=D;g[W+124>>2]=E;g[W+128>>2]=0.0;g[W+196>>2]=Y;c[W+200>>2]=c[h+244>>2];if(f|0?(mc[c[(c[f>>2]|0)+64>>2]&127](f,W,W+224|0,W+208|0),X=+g[W+200>>2],X<+g[h+244>>2]):0){g[h+244>>2]=X;Y=X;i=W;return +Y}Y=1.0;i=W;return +Y}function te(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=0;do{k=m;m=m+1|0;l=(m|0)==3;j=c[b+((l?0:m)<<2)>>2]|0;k=c[b+(((k+2|0)%3|0)<<2)>>2]|0;e=c[d>>2]|0;f=c[d+4>>2]|0;do if((e|0)==(k|0)&(f|0)==(j|0)){e=2;n=3}else{if(!((e|0)==(j|0)&(f|0)==(k|0))){g=c[d+8>>2]|0;if((f|0)==(k|0)&(g|0)==(j|0)){e=0;n=3;break}if(!((f|0)==(j|0)&(g|0)==(k|0))){if(!((g|0)!=(k|0)|(e|0)==(j|0)^1)){e=1;n=3;break}if((g|0)!=(j|0)|(e|0)==(k|0)^1){e=9432;break}else e=1}else e=0}else e=2;e=d+12+(e<<2)|0}while(0);if((n|0)==3){n=0;e=d+12+(e<<2)|0}i=c[e>>2]|0;e=c[b>>2]|0;f=c[b+4>>2]|0;do if((e|0)==(j|0)&(f|0)==(k|0)){e=2;n=11}else{if(!((e|0)==(k|0)&(f|0)==(j|0))){g=c[b+8>>2]|0;if((f|0)==(j|0)&(g|0)==(k|0)){e=0;n=11;break}if(!((f|0)==(k|0)&(g|0)==(j|0))){if(!((g|0)!=(j|0)|(e|0)==(k|0)^1)){e=1;n=11;break}if((g|0)!=(k|0)|(e|0)==(j|0)^1){e=9432;break}else e=1}else e=0}else e=2;e=b+12+(e<<2)|0}while(0);if((n|0)==11){n=0;e=b+12+(e<<2)|0}h=c[a+(c[e>>2]<<2)>>2]|0;e=c[h>>2]|0;f=c[h+4>>2]|0;do if((e|0)==(k|0)&(f|0)==(j|0)){e=2;n=19}else{if(!((e|0)==(j|0)&(f|0)==(k|0))){g=c[h+8>>2]|0;if((f|0)==(k|0)&(g|0)==(j|0)){e=0;n=19;break}if(!((f|0)==(j|0)&(g|0)==(k|0))){if(!((g|0)!=(k|0)|(e|0)==(j|0)^1)){e=1;n=19;break}if((g|0)!=(j|0)|(e|0)==(k|0)^1){e=9432;break}else e=1}else e=0}else e=2;e=h+12+(e<<2)|0}while(0);if((n|0)==19){n=0;e=h+12+(e<<2)|0}c[e>>2]=i;e=c[b>>2]|0;f=c[b+4>>2]|0;do if((e|0)==(j|0)&(f|0)==(k|0)){e=2;n=27}else{if(!((e|0)==(k|0)&(f|0)==(j|0))){g=c[b+8>>2]|0;if((f|0)==(j|0)&(g|0)==(k|0)){e=0;n=27;break}if(!((f|0)==(k|0)&(g|0)==(j|0))){if(!((g|0)!=(j|0)|(e|0)==(k|0)^1)){e=1;n=27;break}if((g|0)!=(k|0)|(e|0)==(j|0)^1){e=9432;break}else e=1}else e=0}else e=2;e=b+12+(e<<2)|0}while(0);if((n|0)==27){n=0;e=b+12+(e<<2)|0}i=c[e>>2]|0;e=c[d>>2]|0;f=c[d+4>>2]|0;do if((e|0)==(k|0)&(f|0)==(j|0)){e=2;n=35}else{if(!((e|0)==(j|0)&(f|0)==(k|0))){g=c[d+8>>2]|0;if((f|0)==(k|0)&(g|0)==(j|0)){e=0;n=35;break}if(!((f|0)==(j|0)&(g|0)==(k|0))){if(!((g|0)!=(k|0)|(e|0)==(j|0)^1)){e=1;n=35;break}if((g|0)!=(j|0)|(e|0)==(k|0)^1){e=9432;break}else e=1}else e=0}else e=2;e=d+12+(e<<2)|0}while(0);if((n|0)==35){n=0;e=d+12+(e<<2)|0}h=c[a+(c[e>>2]<<2)>>2]|0;e=c[h>>2]|0;f=c[h+4>>2]|0;do if((e|0)==(j|0)&(f|0)==(k|0)){e=2;n=43}else{if(!((e|0)==(k|0)&(f|0)==(j|0))){g=c[h+8>>2]|0;if((f|0)==(j|0)&(g|0)==(k|0)){e=0;n=43;break}if(!((f|0)==(k|0)&(g|0)==(j|0))){if(!((g|0)!=(j|0)|(e|0)==(k|0)^1)){e=1;n=43;break}if((g|0)!=(k|0)|(e|0)==(j|0)^1){e=9432;break}else e=1}else e=0}else e=2;e=h+12+(e<<2)|0}while(0);if((n|0)==43){n=0;e=h+12+(e<<2)|0}c[e>>2]=i}while(!l);return}function ue(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=c[b>>2]|0;m=c[b+4>>2]|0;i=c[b+8>>2]|0;n=c[a+4>>2]|0;p=Uh(a,d,m,i)|0;c[p+12>>2]=c[b+12>>2];c[p+16>>2]=n+1;c[p+20>>2]=n+2;h=c[(c[a+12>>2]|0)+(c[b+12>>2]<<2)>>2]|0;e=c[h>>2]|0;f=c[h+4>>2]|0;do if((e|0)==(m|0)&(f|0)==(i|0)){e=2;o=2}else{if(!((e|0)==(i|0)&(f|0)==(m|0))){g=c[h+8>>2]|0;if((f|0)==(m|0)&(g|0)==(i|0)){e=0;o=2;break}if(!((f|0)==(i|0)&(g|0)==(m|0))){if(!((g|0)!=(m|0)|(e|0)==(i|0)^1)){e=1;o=2;break}if((g|0)!=(i|0)|(e|0)==(m|0)^1){e=9432;break}else e=1}else e=0}else e=2;e=h+12+(e<<2)|0}while(0);if((o|0)==2)e=h+12+(e<<2)|0;c[e>>2]=n;k=Uh(a,d,i,l)|0;c[k+12>>2]=c[b+12+4>>2];c[k+16>>2]=n+2;c[k+20>>2]=n;h=c[(c[a+12>>2]|0)+(c[b+12+4>>2]<<2)>>2]|0;e=c[h>>2]|0;f=c[h+4>>2]|0;do if((e|0)==(i|0)&(f|0)==(l|0)){e=2;o=10}else{if(!((e|0)==(l|0)&(f|0)==(i|0))){g=c[h+8>>2]|0;if((f|0)==(i|0)&(g|0)==(l|0)){e=0;o=10;break}if(!((f|0)==(l|0)&(g|0)==(i|0))){if(!((g|0)!=(i|0)|(e|0)==(l|0)^1)){e=1;o=10;break}if((g|0)!=(l|0)|(e|0)==(i|0)^1){e=9432;break}else e=1}else e=0}else e=2;e=h+12+(e<<2)|0}while(0);if((o|0)==10)e=h+12+(e<<2)|0;c[e>>2]=n+1;j=Uh(a,d,l,m)|0;c[j+12>>2]=c[b+12+8>>2];c[j+16>>2]=n;c[j+20>>2]=n+1;e=c[a+12>>2]|0;i=c[e+(c[b+12+8>>2]<<2)>>2]|0;f=c[i>>2]|0;g=c[i+4>>2]|0;do if((f|0)==(l|0)&(g|0)==(m|0)){f=2;o=18}else{if(!((f|0)==(m|0)&(g|0)==(l|0))){h=c[i+8>>2]|0;if((g|0)==(l|0)&(h|0)==(m|0)){f=0;o=18;break}if(!((g|0)==(m|0)&(h|0)==(l|0))){if(!((h|0)!=(l|0)|(f|0)==(m|0)^1)){f=1;o=18;break}if((h|0)!=(m|0)|(f|0)==(l|0)^1){f=9432;break}else f=1}else f=0}else f=2;f=i+12+(f<<2)|0}while(0);if((o|0)==18)f=i+12+(f<<2)|0;c[f>>2]=n+2;f=c[e+(c[p+12>>2]<<2)>>2]|0;if(!(((c[f>>2]|0)!=(d|0)?(c[f+4>>2]|0)!=(d|0):0)?(c[f+8>>2]|0)!=(d|0):0)){te(c[a+12>>2]|0,p,f);c[(c[a+12>>2]|0)+(c[p+24>>2]<<2)>>2]=0;c[6436]=(c[6436]|0)+1;hd(c[p+-4>>2]|0);c[(c[a+12>>2]|0)+(c[f+24>>2]<<2)>>2]=0;if(f|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}e=c[a+12>>2]|0}f=c[e+(c[k+12>>2]<<2)>>2]|0;if(!(((c[f>>2]|0)!=(d|0)?(c[f+4>>2]|0)!=(d|0):0)?(c[f+8>>2]|0)!=(d|0):0)){te(c[a+12>>2]|0,k,f);c[(c[a+12>>2]|0)+(c[k+24>>2]<<2)>>2]=0;c[6436]=(c[6436]|0)+1;hd(c[k+-4>>2]|0);c[(c[a+12>>2]|0)+(c[f+24>>2]<<2)>>2]=0;if(f|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}e=c[a+12>>2]|0}f=c[e+(c[j+12>>2]<<2)>>2]|0;if(!(((c[f>>2]|0)!=(d|0)?(c[f+4>>2]|0)!=(d|0):0)?(c[f+8>>2]|0)!=(d|0):0)){te(c[a+12>>2]|0,j,f);c[(c[a+12>>2]|0)+(c[j+24>>2]<<2)>>2]=0;c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0);c[(c[a+12>>2]|0)+(c[f+24>>2]<<2)>>2]=0;if(f|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}e=c[a+12>>2]|0}c[e+(c[b+24>>2]<<2)>>2]=0;if(!b)return;c[6436]=(c[6436]|0)+1;hd(c[b+-4>>2]|0);return}function ve(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0;v=i;i=i+176|0;if(!(a[b+527>>0]|0)){i=v;return}g[b+36>>2]=0.0;g[b+520>>2]=0.0;g[b+516>>2]=0.0;c[b+576>>2]=0;c[b+576+4>>2]=0;c[b+576+8>>2]=0;c[b+576+12>>2]=0;if(!(a[b+524>>0]|0)){d=c[b+28>>2]|0;k=+g[b+348>>2];l=+g[b+352>>2];r=+g[b+356>>2];t=k*+g[d+20>>2]+l*+g[d+24>>2]+r*+g[d+28>>2]+ +g[d+56>>2];j=c[b+32>>2]|0;m=+g[b+412>>2];n=+g[b+416>>2];s=+g[b+420>>2];o=+g[j+52>>2];e=+g[j+56>>2];u=m*+g[j+20>>2]+n*+g[j+24>>2]+s*+g[j+28>>2]+e;p=m*+g[j+36>>2]+n*+g[j+40>>2]+s*+g[j+44>>2]+ +g[j+60>>2];q=k*+g[d+4>>2]+l*+g[d+8>>2]+r*+g[d+12>>2]+ +g[d+52>>2];r=k*+g[d+36>>2]+l*+g[d+40>>2]+r*+g[d+44>>2]+ +g[d+60>>2];s=m*+g[j+4>>2]+n*+g[j+8>>2]+s*+g[j+12>>2]+o;if((s-q)*(s-q)+(u-t)*(u-t)+(p-r)*(p-r)>1.1920928955078125e-07){h=1.0/+O(+((s-q)*(s-q)+(u-t)*(u-t)+(p-r)*(p-r)));g[v+128>>2]=(s-q)*h;g[v+128+4>>2]=(u-t)*h;g[v+128+8>>2]=(p-r)*h;c[v+128+12>>2]=0;k=(p-r)*h;f=(u-t)*h;h=(s-q)*h}else{c[v+128>>2]=1065353216;c[v+128+4>>2]=0;c[v+128+8>>2]=0;g[v+128+12>>2]=0.0;k=0.0;f=0.0;h=1.0}if(+N(+k)>.7071067690849304){x=k*k+f*f;w=1.0/+O(+x);m=-(w*k);k=w*f;n=-(k*h);l=h*m;f=x*w;h=k;k=0.0}else{m=h*h+f*f;l=1.0/+O(+m);x=-(f*l);f=l*h;n=k*x;l=m*l;m=f;f=-(f*k);h=0.0;k=x}g[v+128+16>>2]=k;g[v+128+20>>2]=m;g[v+128+24>>2]=h;g[v+128+32>>2]=f;g[v+128+36>>2]=n;g[v+128+40>>2]=l;f=o;d=0;while(1){y=c[b+28>>2]|0;c[v+80>>2]=c[y+4>>2];c[v+80+4>>2]=c[y+20>>2];c[v+80+8>>2]=c[y+36>>2];g[v+80+12>>2]=0.0;c[v+80+16>>2]=c[y+8>>2];c[v+80+20>>2]=c[y+24>>2];c[v+80+24>>2]=c[y+40>>2];g[v+80+28>>2]=0.0;c[v+80+32>>2]=c[y+12>>2];c[v+80+36>>2]=c[y+28>>2];c[v+80+40>>2]=c[y+44>>2];g[v+80+44>>2]=0.0;c[v+32>>2]=c[j+4>>2];c[v+32+4>>2]=c[j+20>>2];c[v+32+8>>2]=c[j+36>>2];g[v+32+12>>2]=0.0;c[v+32+16>>2]=c[j+8>>2];c[v+32+20>>2]=c[j+24>>2];c[v+32+24>>2]=c[j+40>>2];g[v+32+28>>2]=0.0;c[v+32+32>>2]=c[j+12>>2];c[v+32+36>>2]=c[j+28>>2];c[v+32+40>>2]=c[j+44>>2];g[v+32+44>>2]=0.0;w=t-+g[y+56>>2];x=r-+g[y+60>>2];g[v+16>>2]=q-+g[y+52>>2];g[v+16+4>>2]=w;g[v+16+8>>2]=x;g[v+16+12>>2]=0.0;x=p-+g[j+60>>2];g[v>>2]=s-f;g[v+4>>2]=u-e;g[v+8>>2]=x;g[v+12>>2]=0.0;y=c[b+28>>2]|0;j=c[b+32>>2]|0;Rg(b+48+(d*84|0)|0,v+80|0,v+32|0,v+16|0,v,v+128+(d<<4)|0,y+396|0,+g[y+344>>2],j+396|0,+g[j+344>>2]);d=d+1|0;if((d|0)==3)break;y=c[b+32>>2]|0;j=y;f=+g[y+52>>2];e=+g[y+56>>2]}d=b+32|0}else d=b+32|0;j=c[b+28>>2]|0;y=c[d>>2]|0;Fc(b,j+4|0,y+4|0,j+264|0,y+264|0);i=v;return}function we(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;if(!((d|0)!=0&(e|0)!=0))return;if((c[b+24>>2]|0)<128?(c[b+28>>2]|0)<128:0){c[6435]=(c[6435]|0)+1;h=yc(1043)|0;if(!h)j=0;else{c[(h+4+15&-16)+-4>>2]=h;j=h+4+15&-16}h=c[b+24>>2]|0;if((h|0)>0){i=0;do{l=(c[b+32>>2]|0)+(i<<3)|0;m=c[l+4>>2]|0;n=j+(i<<3)|0;c[n>>2]=c[l>>2];c[n+4>>2]=m;i=i+1|0}while((i|0)!=(h|0))}h=c[b+32>>2]|0;if(h|0){if(a[b+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=j;c[b+28>>2]=128}c[b+24>>2]=128;n=c[b+32>>2]|0;c[n>>2]=d;c[n+4>>2]=e;n=1;j=124;while(1){h=n+-1|0;i=c[b+32>>2]|0;l=c[i+(h<<3)>>2]|0;m=c[i+(h<<3)+4>>2]|0;if((h|0)>(j|0)){e=c[b+24>>2]|0;if((e|0)<(e<<1|0)?(c[b+28>>2]|0)<(e<<1|0):0){if(e){c[6435]=(c[6435]|0)+1;i=yc((e<<4|3)+16|0)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}j=c[b+24>>2]|0;if((j|0)>0){d=0;do{p=(c[b+32>>2]|0)+(d<<3)|0;o=c[p+4>>2]|0;k=i+(d<<3)|0;c[k>>2]=c[p>>2];c[k+4>>2]=o;d=d+1|0}while((d|0)!=(j|0))}}else i=0;j=c[b+32>>2]|0;if(j|0){if(a[b+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=i;c[b+28>>2]=e<<1}c[b+24>>2]=e<<1;j=(e<<1)+-4|0}do if((l|0)==(m|0)){if(c[l+40>>2]|0){p=c[l+36>>2]|0;c[i+(h<<3)>>2]=p;c[i+(h<<3)+4>>2]=p;h=n+1|0;p=c[b+32>>2]|0;o=c[l+40>>2]|0;c[p+(n<<3)>>2]=o;c[p+(n<<3)+4>>2]=o;p=c[b+32>>2]|0;o=c[l+40>>2]|0;c[p+(h<<3)>>2]=c[l+36>>2];c[p+(h<<3)+4>>2]=o;h=n+2|0}}else if(((((+g[l>>2]<=+g[m+16>>2]?+g[l+16>>2]>=+g[m>>2]:0)?+g[l+4>>2]<=+g[m+20>>2]:0)?+g[l+20>>2]>=+g[m+4>>2]:0)?+g[l+8>>2]<=+g[m+24>>2]:0)?+g[l+24>>2]>=+g[m+8>>2]:0){d=(c[m+40>>2]|0)!=0;if(!(c[l+40>>2]|0))if(d){p=c[m+36>>2]|0;c[i+(h<<3)>>2]=l;c[i+(h<<3)+4>>2]=p;h=c[b+32>>2]|0;p=c[m+40>>2]|0;c[h+(n<<3)>>2]=l;c[h+(n<<3)+4>>2]=p;h=n+1|0;break}else{ic[c[(c[f>>2]|0)+8>>2]&127](f,l,m);break}else{e=i+(h<<3)|0;k=c[l+36>>2]|0;if(d){p=c[m+36>>2]|0;c[e>>2]=k;c[i+(h<<3)+4>>2]=p;p=n+1|0;h=c[b+32>>2]|0;o=c[m+36>>2]|0;c[h+(n<<3)>>2]=c[l+40>>2];c[h+(n<<3)+4>>2]=o;h=n+2|0;o=c[b+32>>2]|0;k=c[m+40>>2]|0;c[o+(p<<3)>>2]=c[l+36>>2];c[o+(p<<3)+4>>2]=k;p=c[b+32>>2]|0;o=c[m+40>>2]|0;c[p+(h<<3)>>2]=c[l+40>>2];c[p+(h<<3)+4>>2]=o;h=n+3|0;break}else{c[e>>2]=k;c[i+(h<<3)+4>>2]=m;h=c[b+32>>2]|0;c[h+(n<<3)>>2]=c[l+40>>2];c[h+(n<<3)+4>>2]=m;h=n+1|0;break}}}while(0);if(!h)break;else n=h}return}function xe(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;g=i;i=i+80|0;c[a+68>>2]=(c[a+68>>2]|0)+1;e=c[a+64>>2]|0;if(e|0){f=c[(c[a+24>>2]|0)+(b*80|0)+76>>2]|0;hh(e,f)|0;d=c[e+4>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[e+4>>2]=f;c[e+12>>2]=(c[e+12>>2]|0)+-1}f=(c[a+16>>2]|0)+-1|0;e=c[a+24>>2]|0;c[g>>2]=c[e+(b*80|0)>>2];c[g+4>>2]=c[e+(b*80|0)+4>>2];c[g+8>>2]=c[e+(b*80|0)+8>>2];c[g+12>>2]=c[e+(b*80|0)+12>>2];c[g+16>>2]=c[e+(b*80|0)+16>>2];c[g+16+4>>2]=c[e+(b*80|0)+16+4>>2];c[g+16+8>>2]=c[e+(b*80|0)+16+8>>2];c[g+16+12>>2]=c[e+(b*80|0)+16+12>>2];c[g+32>>2]=c[e+(b*80|0)+32>>2];c[g+32+4>>2]=c[e+(b*80|0)+32+4>>2];c[g+32+8>>2]=c[e+(b*80|0)+32+8>>2];c[g+32+12>>2]=c[e+(b*80|0)+32+12>>2];c[g+48>>2]=c[e+(b*80|0)+48>>2];c[g+48+4>>2]=c[e+(b*80|0)+48+4>>2];c[g+48+8>>2]=c[e+(b*80|0)+48+8>>2];c[g+48+12>>2]=c[e+(b*80|0)+48+12>>2];c[g+64>>2]=c[e+(b*80|0)+64>>2];c[g+64+4>>2]=c[e+(b*80|0)+64+4>>2];c[g+64+8>>2]=c[e+(b*80|0)+64+8>>2];c[g+64+12>>2]=c[e+(b*80|0)+64+12>>2];c[e+(b*80|0)>>2]=c[e+(f*80|0)>>2];c[e+(b*80|0)+4>>2]=c[e+(f*80|0)+4>>2];c[e+(b*80|0)+8>>2]=c[e+(f*80|0)+8>>2];c[e+(b*80|0)+12>>2]=c[e+(f*80|0)+12>>2];c[e+(b*80|0)+16>>2]=c[e+(f*80|0)+16>>2];c[e+(b*80|0)+16+4>>2]=c[e+(f*80|0)+16+4>>2];c[e+(b*80|0)+16+8>>2]=c[e+(f*80|0)+16+8>>2];c[e+(b*80|0)+16+12>>2]=c[e+(f*80|0)+16+12>>2];c[e+(b*80|0)+32>>2]=c[e+(f*80|0)+32>>2];c[e+(b*80|0)+32+4>>2]=c[e+(f*80|0)+32+4>>2];c[e+(b*80|0)+32+8>>2]=c[e+(f*80|0)+32+8>>2];c[e+(b*80|0)+32+12>>2]=c[e+(f*80|0)+32+12>>2];c[e+(b*80|0)+48>>2]=c[e+(f*80|0)+48>>2];c[e+(b*80|0)+48+4>>2]=c[e+(f*80|0)+48+4>>2];c[e+(b*80|0)+48+8>>2]=c[e+(f*80|0)+48+8>>2];c[e+(b*80|0)+48+12>>2]=c[e+(f*80|0)+48+12>>2];c[e+(b*80|0)+64>>2]=c[e+(f*80|0)+64>>2];c[e+(b*80|0)+64+4>>2]=c[e+(f*80|0)+64+4>>2];c[e+(b*80|0)+64+8>>2]=c[e+(f*80|0)+64+8>>2];c[e+(b*80|0)+64+12>>2]=c[e+(f*80|0)+64+12>>2];e=c[a+24>>2]|0;c[e+(f*80|0)>>2]=c[g>>2];c[e+(f*80|0)+4>>2]=c[g+4>>2];c[e+(f*80|0)+8>>2]=c[g+8>>2];c[e+(f*80|0)+12>>2]=c[g+12>>2];c[e+(f*80|0)+16>>2]=c[g+16>>2];c[e+(f*80|0)+16+4>>2]=c[g+16+4>>2];c[e+(f*80|0)+16+8>>2]=c[g+16+8>>2];c[e+(f*80|0)+16+12>>2]=c[g+16+12>>2];c[e+(f*80|0)+32>>2]=c[g+32>>2];c[e+(f*80|0)+32+4>>2]=c[g+32+4>>2];c[e+(f*80|0)+32+8>>2]=c[g+32+8>>2];c[e+(f*80|0)+32+12>>2]=c[g+32+12>>2];c[e+(f*80|0)+48>>2]=c[g+48>>2];c[e+(f*80|0)+48+4>>2]=c[g+48+4>>2];c[e+(f*80|0)+48+8>>2]=c[g+48+8>>2];c[e+(f*80|0)+48+12>>2]=c[g+48+12>>2];c[e+(f*80|0)+64>>2]=c[g+64>>2];c[e+(f*80|0)+64+4>>2]=c[g+64+4>>2];c[e+(f*80|0)+64+8>>2]=c[g+64+8>>2];c[e+(f*80|0)+64+12>>2]=c[g+64+12>>2];if(!(c[a+64>>2]|0)){b=c[a+16>>2]|0;b=b+-1|0;c[a+16>>2]=b;i=g;return}c[(c[(c[a+24>>2]|0)+(b*80|0)+76>>2]|0)+36>>2]=b;b=c[a+16>>2]|0;b=b+-1|0;c[a+16>>2]=b;i=g;return}function ye(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+80|0;if((h|0)>0){k=0;b=0;do{r=c[f+(k<<2)>>2]|0;b=(r|0)>(b|0)?r:b;k=k+1|0}while((k|0)<(h*3|0))}else b=0;p=b+1|0;l=_(p,p)|0;if(!l)r=0;else{c[6435]=(c[6435]|0)+1;k=yc(l+19|0)|0;if(!k)k=0;else{c[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}Qn(k|0,0,l|0)|0;r=k}if((b|0)>-1){if((p|0)!=0?(c[6435]=(c[6435]|0)+1,m=yc((p<<4|3)+16|0)|0,(m|0)!=0):0){c[(m+4+15&-16)+-4>>2]=m;l=m+4+15&-16}else l=0;b=0;do{q=l+(b<<4)|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];b=b+1|0}while((b|0)!=(p|0));b=0;k=0;while(1){o=c[e+(b+1<<2)>>2]|0;q=c[e+(b+2<<2)>>2]|0;c[l+(k<<4)>>2]=c[e+(b<<2)>>2];c[l+(k<<4)+4>>2]=o;c[l+(k<<4)+8>>2]=q;g[l+(k<<4)+12>>2]=0.0;b=b+3|0;if((b|0)>=(p*3|0))break;else k=k+1|0}}else l=0;c[6435]=(c[6435]|0)+1;b=yc(1271)|0;if(!b)q=0;else{c[(b+4+15&-16)+-4>>2]=b;q=b+4+15&-16}Kc(q,d,p,l,0);if((h|0)>0){o=0;do{e=c[f+(o<<2)>>2]|0;d=c[f+(o+1<<2)>>2]|0;n=c[f+(o+2<<2)>>2]|0;k=_(e,p)|0;b=r+(k+n)|0;if(!(a[b>>0]|0)){a[b>>0]=1;a[r+(e+(_(n,p)|0))>>0]=1;Rf(q,n,e,0,0)}m=_(d,p)|0;b=r+(m+e)|0;if(!(a[b>>0]|0)){a[b>>0]=1;a[r+(d+k)>>0]=1;Rf(q,e,d,0,0)}b=r+((_(n,p)|0)+d)|0;if(!(a[b>>0]|0)){a[b>>0]=1;a[r+(n+m)>>0]=1;Rf(q,d,n,0,0)}Zf(q,e,d,n,0);o=o+3|0}while((o|0)<(h*3|0))}if(j){k=c[q+732>>2]|0;if((k|0)>0){m=q+740|0;n=0;b=243703;do{e=c[m>>2]|0;d=e+(n*52|0)|0;b=(_(b,1664525)|0)+1013904223|0;o=s+16|0;p=d;f=o+52|0;do{c[o>>2]=c[p>>2];o=o+4|0;p=p+4|0}while((o|0)<(f|0));o=d;p=e+(((b>>>0)%(k>>>0)|0)*52|0)|0;f=o+52|0;do{c[o>>2]=c[p>>2];o=o+4|0;p=p+4|0}while((o|0)<(f|0));o=e+(((b>>>0)%(k>>>0)|0)*52|0)|0;p=s+16|0;f=o+52|0;do{c[o>>2]=c[p>>2];o=o+4|0;p=p+4|0}while((o|0)<(f|0));n=n+1|0}while((n|0)!=(k|0))}else b=243703;d=c[q+752>>2]|0;if((d|0)>0){e=q+760|0;n=0;do{m=c[e>>2]|0;k=m+(n*44|0)|0;b=(_(b,1664525)|0)+1013904223|0;m=m+(((b>>>0)%(d>>>0)|0)*44|0)|0;o=s+16|0;p=k;f=o+44|0;do{c[o>>2]=c[p>>2];o=o+4|0;p=p+4|0}while((o|0)<(f|0));o=k;p=m;f=o+44|0;do{c[o>>2]=c[p>>2];o=o+4|0;p=p+4|0}while((o|0)<(f|0));o=m;p=s+16|0;f=o+44|0;do{c[o>>2]=c[p>>2];o=o+4|0;p=p+4|0}while((o|0)<(f|0));n=n+1|0}while((n|0)!=(d|0))}}if(l|0){c[6436]=(c[6436]|0)+1;hd(c[l+-4>>2]|0)}if(!r){i=s;return q|0}c[6436]=(c[6436]|0)+1;hd(c[r+-4>>2]|0);i=s;return q|0}function ze(a,d,f,h,j,k,l,m,n){a=a|0;d=d|0;f=f|0;h=+h;j=+j;k=+k;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0.0,I=0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0,U=0.0,V=0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0;V=i;i=i+32|0;H=+g[f>>2];Q=+g[f+4>>2];S=+g[f+8>>2];J=1.0/+O(+((h-H)*(h-H)+(j-Q)*(j-Q)+(k-S)*(k-S)));N=(h-H)*J==0.0?999999984306749440.0:1.0/((h-H)*J);P=(j-Q)*J==0.0?999999984306749440.0:1.0/((j-Q)*J);R=(k-S)*J==0.0?999999984306749440.0:1.0/((k-S)*J);ea=(H>h?h:H)+ +g[l>>2];ca=(Q>j?j:Q)+ +g[l+4>>2];da=(S>k?k:S)+ +g[l+8>>2];aa=(H<h?h:H)+ +g[m>>2];t=(Q<j?j:Q)+ +g[m+4>>2];Y=(S<k?k:S)+ +g[m+8>>2];$=+g[a+4>>2];ea=ea<$?$:ea;u=+g[a+8>>2];ca=ca<u?u:ca;X=+g[a+12>>2];da=da<X?X:da;ba=+g[a+20>>2];s=+g[a+24>>2];Z=+g[a+28>>2];_=+g[a+36>>2];v=+g[a+40>>2];W=+g[a+44>>2];T=~~(((ba<ea?ba:ea)-$)*_)&65534;E=~~(((Z<da?Z:da)-X)*W)&65534;G=~~(((s<ca?s:ca)-u)*v)&65534;aa=aa<$?$:aa;t=t<u?u:t;Y=Y<X?X:Y;I=(~~(((ba<aa?ba:aa)-$)*_+1.0)&65535|1)&65535;D=(~~(((Z<Y?Z:Y)-X)*W+1.0)&65535|1)&65535;F=(~~(((s<t?s:t)-u)*v+1.0)&65535|1)&65535;if((n|0)>0){p=0;q=c[a+136>>2]|0;o=0;do{o=o+1|0;r=q+6|0;w=b[q>>1]|0;x=q+10|0;y=b[q+4>>1]|0;z=q+8|0;A=b[q+2>>1]|0;B=q+12|0;C=(c[B>>2]|0)>-1;do if(((I&65535)>=(w&65535)?(T&65535)<=(e[r>>1]|0):0)&(E&65535)<=(e[x>>1]|0)&(D&65535)>=(y&65535)&(G&65535)<=(e[z>>1]|0)&(F&65535)>=(A&65535)){aa=+g[a+36>>2];ca=+g[a+40>>2];ea=+g[a+44>>2];ba=+g[a+4>>2];da=+g[a+8>>2];u=+g[a+12>>2];g[V+12>>2]=0.0;v=+(e[r>>1]|0)/aa+ba;s=+(e[z>>1]|0)/ca+da;t=+(e[x>>1]|0)/ea+u;g[V+28>>2]=0.0;g[V>>2]=+(w&65535)/aa+ba-+g[m>>2];g[V+4>>2]=+(A&65535)/ca+da-+g[m+4>>2];g[V+8>>2]=+(y&65535)/ea+u-+g[m+8>>2];g[V+16>>2]=v-+g[l>>2];g[V+20>>2]=s-+g[l+4>>2];g[V+24>>2]=t-+g[l+8>>2];t=+g[f>>2];s=N*(+g[V+((N<0.0&1)<<4)>>2]-t);t=N*(+g[V+((N<0.0^1)<<4)>>2]-t);v=+g[f+4>>2];u=P*(+g[V+((P<0.0&1)<<4)+4>>2]-v);v=P*(+g[V+((P<0.0^1)<<4)+4>>2]-v);if(!(u>t|s>v)?(K=u>s?u:s,U=v<t?v:t,M=+g[f+8>>2],L=R*(+g[V+((R<0.0&1)<<4)+8>>2]-M),M=R*(+g[V+((R<0.0^1)<<4)+8>>2]-M),!(L>U|K>M)):0){r=(M<U?M:U)>0.0?(L>K?L:K)<(k-S)*(k-S)*J+((h-H)*(h-H)*J+(j-Q)*(j-Q)*J):0;if(!(C&r)){w=9;break}w=c[B>>2]|0;ic[c[(c[d>>2]|0)+8>>2]&127](d,w>>21,w&2097151);w=10;break}r=0;w=9}else{r=0;w=9}while(0);if((w|0)==9){w=0;if(C|r)w=10;else{C=c[B>>2]|0;p=p-C|0;q=q+(0-C<<4)|0}}if((w|0)==10){p=p+1|0;q=q+16|0}}while((p|0)<(n|0))}else o=0;if((c[6167]|0)>=(o|0)){i=V;return}c[6167]=o;i=V;return}function Ae(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;Tg(a,b+(c*284|0)|0,d);m=+g[b+(c*284|0)+52>>2];h=+g[b+(c*284|0)+56>>2];q=+g[b+(c*284|0)+60>>2];G=+g[b+(c*284|0)+76>>2];x=+g[b+(c*284|0)+72>>2];z=+g[b+(c*284|0)+68>>2];w=1.0/+O(+((x*-m-z*-h)*(x*-m-z*-h)+((G*-h-x*-q)*(G*-h-x*-q)+(z*-q-G*-m)*(z*-q-G*-m))));v=(G*-h-x*-q)*w;u=w*(z*-q-G*-m);w=w*(x*-m-z*-h);e=+g[b+(c*284|0)+232>>2]*.5;k=+R(+e)/+O(+(m*m+h*h+q*q));e=+Q(+e);l=2.0/(e*e+(k*-q*k*-q+(k*-m*k*-m+k*-h*k*-h)));E=1.0-(k*-h*k*-h*l+k*-q*k*-q*l);D=k*-m*k*-h*l-e*k*-q*l;F=k*-m*k*-q*l+e*k*-h*l;B=k*-m*k*-h*l+e*k*-q*l;A=1.0-(k*-m*k*-m*l+k*-q*k*-q*l);C=k*-h*k*-q*l-e*k*-m*l;j=k*-m*k*-q*l-e*k*-h*l;e=k*-h*k*-q*l+e*k*-m*l;l=1.0-(k*-m*k*-m*l+k*-h*k*-h*l);k=+g[b+(c*284|0)+236>>2]*-.5;y=+R(+k)/+O(+(G*G+(x*x+z*z)));k=+Q(+k);r=2.0/(k*k+(G*y*G*y+(z*y*z*y+x*y*x*y)));n=1.0-(x*y*x*y*r+G*y*G*y*r);i=z*y*x*y*r-k*G*y*r;t=z*y*G*y*r+k*x*y*r;o=z*y*x*y*r+k*G*y*r;f=1.0-(z*y*z*y*r+G*y*G*y*r);s=x*y*G*y*r-k*z*y*r;p=z*y*G*y*r-k*x*y*r;k=x*y*G*y*r+k*z*y*r;r=1.0-(z*y*z*y*r+x*y*x*y*r);y=+g[b+(c*284|0)+68>>2];x=+g[b+(c*284|0)+72>>2];z=+g[b+(c*284|0)+76>>2];g[b+(c*284|0)+92>>2]=z*(E*t+D*s+F*r)+(y*(F*p+(D*o+E*n))+x*(F*k+(E*i+D*f)));g[b+(c*284|0)+96>>2]=w*(E*t+D*s+F*r)+(v*(F*p+(D*o+E*n))+u*(F*k+(E*i+D*f)));g[b+(c*284|0)+100>>2]=(E*t+D*s+F*r)*-q+((F*p+(D*o+E*n))*-m+(F*k+(E*i+D*f))*-h);g[b+(c*284|0)+104>>2]=0.0;g[b+(c*284|0)+108>>2]=z*(B*t+A*s+C*r)+(y*(C*p+(A*o+B*n))+x*(C*k+(B*i+A*f)));g[b+(c*284|0)+112>>2]=w*(B*t+A*s+C*r)+(v*(C*p+(A*o+B*n))+u*(C*k+(B*i+A*f)));g[b+(c*284|0)+116>>2]=(B*t+A*s+C*r)*-q+((C*p+(A*o+B*n))*-m+(C*k+(B*i+A*f))*-h);g[b+(c*284|0)+120>>2]=0.0;g[b+(c*284|0)+124>>2]=z*(j*t+e*s+l*r)+(y*(l*p+(e*o+j*n))+x*(l*k+(j*i+e*f)));g[b+(c*284|0)+128>>2]=w*(j*t+e*s+l*r)+(v*(l*p+(e*o+j*n))+u*(l*k+(j*i+e*f)));g[b+(c*284|0)+132>>2]=(j*t+e*s+l*r)*-q+((l*p+(e*o+j*n))*-m+(l*k+(j*i+e*f))*-h);g[b+(c*284|0)+136>>2]=0.0;h=+g[b+(c*284|0)+32>>2];f=h*+g[b+(c*284|0)+56>>2]+ +g[b+(c*284|0)+40>>2];e=h*+g[b+(c*284|0)+60>>2]+ +g[b+(c*284|0)+44>>2];g[b+(c*284|0)+140>>2]=+g[b+(c*284|0)+52>>2]*h+ +g[b+(c*284|0)+36>>2];g[b+(c*284|0)+144>>2]=f;g[b+(c*284|0)+148>>2]=e;g[b+(c*284|0)+152>>2]=0.0;return}function Be(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=+j;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0.0;D=i;i=i+32|0;if(!d){i=D;return}q=c[b+44>>2]|0;if((q|0)<128){if((c[b+48>>2]|0)<128){c[6435]=(c[6435]|0)+1;n=yc(531)|0;if(!n)p=0;else{c[(n+4+15&-16)+-4>>2]=n;p=n+4+15&-16}n=c[b+44>>2]|0;if((n|0)>0){o=0;do{c[p+(o<<2)>>2]=c[(c[b+52>>2]|0)+(o<<2)>>2];o=o+1|0}while((o|0)!=(n|0))}n=c[b+52>>2]|0;if(n|0){if(a[b+56>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[n+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=p;c[b+48>>2]=128;o=b+52|0}else o=b+52|0;n=q;do{c[(c[o>>2]|0)+(n<<2)>>2]=0;n=n+1|0}while((n|0)!=128);y=b+48|0}else{o=b+52|0;y=b+48|0}c[b+44>>2]=128;c[c[o>>2]>>2]=d;x=1;n=126;while(1){p=x+-1|0;q=c[o>>2]|0;w=c[q+(p<<2)>>2]|0;t=+g[w+4>>2]-+g[l+4>>2];r=+g[w+8>>2]-+g[l+8>>2];g[D>>2]=+g[w>>2]-+g[l>>2];g[D+4>>2]=t;g[D+8>>2]=r;g[D+12>>2]=0.0;r=+g[w+20>>2]-+g[k+4>>2];t=+g[w+24>>2]-+g[k+8>>2];g[D+16>>2]=+g[w+16>>2]-+g[k>>2];g[D+20>>2]=r;g[D+24>>2]=t;g[D+28>>2]=0.0;v=c[h>>2]|0;t=+g[e>>2];r=+g[f>>2];s=(+g[D+(v<<4)>>2]-t)*r;t=r*(+g[D+(1-v<<4)>>2]-t);v=c[h+4>>2]|0;r=+g[e+4>>2];E=+g[f+4>>2];u=(+g[D+(v<<4)+4>>2]-r)*E;r=E*(+g[D+(1-v<<4)+4>>2]-r);do if((!(u>t|s>r)?(z=u>s?u:s,C=r<t?r:t,v=c[h+8>>2]|0,B=+g[e+8>>2],E=+g[f+8>>2],A=(+g[D+(v<<4)+8>>2]-B)*E,B=E*(+g[D+(1-v<<4)+8>>2]-B),!(A>C|z>B)):0)?((B<C?B:C)>0.0?(A>z?A:z)<j:0):0){if(!(c[w+40>>2]|0)){Cb[c[(c[m>>2]|0)+12>>2]&127](m,w);break}if((p|0)>(n|0)){v=c[b+44>>2]|0;if((v|0)<(v<<1|0)){if((c[y>>2]|0)<(v<<1|0)){if(v){c[6435]=(c[6435]|0)+1;n=yc((v<<3|3)+16|0)|0;if(!n)n=0;else{c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}q=c[b+44>>2]|0;if((q|0)>0){d=0;do{c[n+(d<<2)>>2]=c[(c[o>>2]|0)+(d<<2)>>2];d=d+1|0}while((d|0)!=(q|0))}}else n=0;q=c[o>>2]|0;if(q|0){if(a[b+56>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[q+-4>>2]|0)}c[o>>2]=0}a[b+56>>0]=1;c[o>>2]=n;c[y>>2]=v<<1;q=v}else{n=q;q=v}do{c[n+(q<<2)>>2]=0;q=q+1|0;n=c[o>>2]|0}while((q|0)!=(v<<1|0))}else n=q;c[b+44>>2]=v<<1;q=n;n=(v<<1)+-2|0}c[q+(p<<2)>>2]=c[w+36>>2];c[(c[o>>2]|0)+(x<<2)>>2]=c[w+40>>2];p=x+1|0}while(0);if(!p)break;else x=p}i=D;return}function Ce(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0,D=0,E=0.0;D=i;i=i+32|0;q=+g[d>>2];j=(g[k>>2]=q,c[k>>2]|0);t=q<999999984306749440.0?j:1566444395;p=+g[d+4>>2];m=(g[k>>2]=p,c[k>>2]|0);u=p<999999984306749440.0?m:1566444395;E=+g[d+8>>2];o=(g[k>>2]=E,c[k>>2]|0);w=E<999999984306749440.0?o:1566444395;s=+g[d+12>>2];y=s<0.0?s:0.0;j=q>-999999984306749440.0?j:-581039253;m=p>-999999984306749440.0?m:-581039253;o=E>-999999984306749440.0?o:-581039253;s=s>0.0?s:0.0;E=+g[d+16>>2];B=E<(c[k>>2]=t,+g[k>>2]);h=(g[k>>2]=E,c[k>>2]|0);t=B?h:t;p=+g[d+20>>2];B=p<(c[k>>2]=u,+g[k>>2]);l=(g[k>>2]=p,c[k>>2]|0);u=B?l:u;q=+g[d+24>>2];B=q<(c[k>>2]=w,+g[k>>2]);n=(g[k>>2]=q,c[k>>2]|0);w=B?n:w;r=+g[d+28>>2];y=r<y?r:y;x=(c[k>>2]=j,+g[k>>2])<E?h:j;v=(c[k>>2]=m,+g[k>>2])<p?l:m;m=(c[k>>2]=o,+g[k>>2])<q?n:o;s=s<r?r:s;E=+g[d+32>>2];B=E<(c[k>>2]=t,+g[k>>2]);h=(g[k>>2]=E,c[k>>2]|0);B=B?h:t;q=+g[d+36>>2];A=q<(c[k>>2]=u,+g[k>>2]);j=(g[k>>2]=q,c[k>>2]|0);A=A?j:u;r=+g[d+40>>2];z=r<(c[k>>2]=w,+g[k>>2]);l=(g[k>>2]=r,c[k>>2]|0);z=z?l:w;p=+g[d+44>>2];y=p<y?p:y;w=(c[k>>2]=x,+g[k>>2])<E?h:x;v=(c[k>>2]=v,+g[k>>2])<q?j:v;u=(c[k>>2]=m,+g[k>>2])<r?l:m;p=s<p?p:s;t=c[b+4>>2]|0;h=c[t+4>>2]|0;if((h|0)==(c[t+8>>2]|0)?(C=h|0?h<<1:1,(h|0)<(C|0)):0){if(!C)o=0;else{c[6435]=(c[6435]|0)+1;h=yc(C<<6|19)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}o=h;h=c[t+4>>2]|0}if((h|0)>0){j=0;do{l=o+(j<<6)|0;m=(c[t+12>>2]|0)+(j<<6)|0;n=l+64|0;do{c[l>>2]=c[m>>2];l=l+4|0;m=m+4|0}while((l|0)<(n|0));j=j+1|0}while((j|0)!=(h|0))}h=c[t+12>>2]|0;if(h|0){if(a[t+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[t+12>>2]=0}a[t+16>>0]=1;c[t+12>>2]=o;c[t+8>>2]=C;h=c[t+4>>2]|0}C=c[t+12>>2]|0;c[C+(h<<6)>>2]=B;c[C+(h<<6)+4>>2]=A;c[C+(h<<6)+8>>2]=z;g[C+(h<<6)+12>>2]=y;c[C+(h<<6)+16>>2]=w;c[C+(h<<6)+20>>2]=v;c[C+(h<<6)+24>>2]=u;g[C+(h<<6)+28>>2]=p;c[C+(h<<6)+32>>2]=-1;c[C+(h<<6)+36>>2]=e;c[C+(h<<6)+40>>2]=f;f=C+(h<<6)+44|0;c[f>>2]=c[D>>2];c[f+4>>2]=c[D+4>>2];c[f+8>>2]=c[D+8>>2];c[f+12>>2]=c[D+12>>2];c[f+16>>2]=c[D+16>>2];c[t+4>>2]=(c[t+4>>2]|0)+1;i=D;return}function De(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0;o=i;i=i+16|0;l=+g[d>>2];m=+g[d+4>>2];n=+g[d+8>>2];j=+g[e>>2];k=+g[e+4>>2];h=+g[e+8>>2];if(!(a[b+228>>0]|0)){z=+g[b+100>>2];w=+g[b+116>>2];C=+g[b+132>>2];y=+g[b+104>>2];u=+g[b+120>>2];B=+g[b+136>>2];x=+g[b+108>>2];s=+g[b+124>>2];A=+g[b+140>>2];F=-+g[b+148>>2];E=-+g[b+152>>2];D=-+g[b+156>>2];J=+g[b+164>>2];I=+g[b+168>>2];r=+g[b+172>>2];H=+g[b+180>>2];G=+g[b+184>>2];q=+g[b+188>>2];v=+g[b+196>>2];t=+g[b+200>>2];p=+g[b+204>>2];r=h*(C*J+B*I+A*r)+(j*(z*J+y*I+x*r)+k*(w*J+u*I+s*r))+(J*(z*F+w*E+C*D)+(y*F+u*E+B*D)*I+(x*F+s*E+A*D)*r+ +g[b+212>>2]);q=h*(C*H+B*G+A*q)+(j*(z*H+y*G+x*q)+k*(w*H+u*G+s*q))+((z*F+w*E+C*D)*H+(y*F+u*E+B*D)*G+(x*F+s*E+A*D)*q+ +g[b+216>>2]);p=(z*F+w*E+C*D)*v+(y*F+u*E+B*D)*t+(x*F+s*E+A*D)*p+ +g[b+220>>2]+(h*(C*v+B*t+A*p)+(j*(z*v+y*t+x*p)+k*(w*v+u*t+s*p)));g[o>>2]=r;g[o+4>>2]=q;g[o+8>>2]=p;f=(l*f+j-r)*+g[d>>2]+(m*f+k-q)*+g[d+4>>2]+(n*f+h-p)*+g[d+8>>2];e=o+12|0;g[e>>2]=0.0;b=b+32|0;b=c[b>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;hc[e&15](b,d,o,f);i=o;return}else{z=+g[b+36>>2];C=+g[b+52>>2];w=+g[b+68>>2];A=+g[b+40>>2];E=+g[b+56>>2];x=+g[b+72>>2];B=+g[b+44>>2];G=+g[b+60>>2];y=+g[b+76>>2];t=-+g[b+84>>2];u=-+g[b+88>>2];v=-+g[b+92>>2];p=+g[b+164>>2];q=+g[b+168>>2];H=+g[b+172>>2];r=+g[b+180>>2];s=+g[b+184>>2];I=+g[b+188>>2];D=+g[b+196>>2];F=+g[b+200>>2];J=+g[b+204>>2];H=(n*f+h)*(w*p+x*q+y*H)+((l*f+j)*(z*p+A*q+B*H)+(m*f+k)*(C*p+E*q+G*H))+(p*(z*t+C*u+w*v)+(A*t+E*u+x*v)*q+(B*t+G*u+y*v)*H+ +g[b+212>>2]);I=(n*f+h)*(w*r+x*s+y*I)+((l*f+j)*(z*r+A*s+B*I)+(m*f+k)*(C*r+E*s+G*I))+((z*t+C*u+w*v)*r+(A*t+E*u+x*v)*s+(B*t+G*u+y*v)*I+ +g[b+216>>2]);J=(z*t+C*u+w*v)*D+(A*t+E*u+x*v)*F+(B*t+G*u+y*v)*J+ +g[b+220>>2]+((n*f+h)*(w*D+x*F+y*J)+((l*f+j)*(z*D+A*F+B*J)+(m*f+k)*(C*D+E*F+G*J)));g[o>>2]=H+l*(l*(H-j)+m*(I-k)+n*(J-h));g[o+4>>2]=I+m*(l*(H-j)+m*(I-k)+n*(J-h));g[o+8>>2]=J+n*(l*(H-j)+m*(I-k)+n*(J-h));J=l*(H-j)+m*(I-k)+n*(J-h);e=o+12|0;g[e>>2]=0.0;b=b+32|0;b=c[b>>2]|0;e=c[b>>2]|0;e=e+16|0;e=c[e>>2]|0;hc[e&15](b,d,o,J);i=o;return}}function Ee(b,d,e,f,h,i,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0;if((j|0)<2|(k|0)<2){m=0;return m|0}r=_(k,j)|0;c[6435]=(c[6435]|0)+1;b=yc(r>>>0>268435455?18:(r<<4|3)+16|0)|0;if(!b)q=0;else{c[(b+4+15&-16)+-4>>2]=b;q=b+4+15&-16}n=r>>>0>1073741823?-1:r<<2;n=(n|0)==0?1:n;while(1){p=yc(n)|0;if(p|0)break;b=c[6564]|0;c[6564]=b+0;if(!b){o=8;break}jc[b&3]()}if((o|0)==8){m=Ya(4)|0;c[m>>2]=9640;pb(m|0,2800,251)}if((k|0)>0?(j|0)>0:0){o=0;do{y=+(o|0)/+(k+-1|0);s=+g[e>>2];s=s+y*(+g[h>>2]-s);t=+g[e+4>>2];t=t+y*(+g[h+4>>2]-t);u=+g[e+8>>2];u=u+y*(+g[h+8>>2]-u);v=+g[f>>2];w=+g[f+4>>2];x=+g[f+8>>2];b=_(o,j)|0;v=v+y*(+g[i>>2]-v)-s;w=w+y*(+g[i+4>>2]-w)-t;x=x+y*(+g[i+8>>2]-x)-u;n=0;do{y=+(n|0)/+(j+-1|0);z=n+b|0;g[q+(z<<4)>>2]=s+v*y;g[q+(z<<4)+4>>2]=t+w*y;g[q+(z<<4)+8>>2]=u+x*y;g[q+(z<<4)+12>>2]=0.0;g[p+(z<<2)>>2]=1.0;n=n+1|0}while((n|0)!=(j|0));o=o+1|0}while((o|0)!=(k|0))}c[6435]=(c[6435]|0)+1;b=yc(1271)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}Kc(b,d,r,q,p);if(l&1|0){g[(c[b+720>>2]|0)+88>>2]=0.0;a[b+924>>0]=1}if(l&2|0){g[(c[b+720>>2]|0)+((j+-1|0)*104|0)+88>>2]=0.0;a[b+924>>0]=1}if(l&4|0){z=_(k+-1|0,j)|0;g[(c[b+720>>2]|0)+(z*104|0)+88>>2]=0.0;a[b+924>>0]=1}if(l&8|0){z=j+-1+(_(k+-1|0,j)|0)|0;g[(c[b+720>>2]|0)+(z*104|0)+88>>2]=0.0;a[b+924>>0]=1}if(q|0){c[6436]=(c[6436]|0)+1;hd(c[q+-4>>2]|0)}hd(p);if((k|0)<=0){z=b;return z|0}q=0;while(1){a:do if((j|0)>0){r=_(q,j)|0;n=q+1|0;o=_(n,j)|0;if((n|0)<(k|0))h=0;else{o=0;while(1){p=o;o=o+1|0;if((o|0)<(j|0))Rf(b,p+r|0,o+r|0,0,0);if((o|0)==(j|0))break a}}do{p=h+r|0;i=h;h=h+1|0;do if((h|0)<(j|0)){e=h+r|0;Rf(b,p,e,0,0);Rf(b,p,i+o|0,0,0);if(!(i+q&1)){Zf(b,i+o|0,p,e,0);Zf(b,i+o|0,e,h+o|0,0);if(!m)break;Rf(b,e,i+o|0,0,0);break}else{f=h+o|0;Zf(b,p,e,f,0);Zf(b,p,f,i+o|0,0);if(!m)break;Rf(b,p,f,0,0);break}}else Rf(b,p,i+o|0,0,0);while(0)}while((h|0)!=(j|0))}else n=q+1|0;while(0);if((n|0)==(k|0))break;else q=n}return b|0}function Fe(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+16|0;o=c[b+452>>2]|0;ic[c[(c[o>>2]|0)+16>>2]&127](o,b+324|0,0);o=c[b+452>>2]|0;Eb[c[(c[o>>2]|0)+12>>2]&127](o)|0;ad(b,d);li(11792);o=c[b+328>>2]|0;if((o|0)>0){e=c[b+336>>2]|0;f=0;l=0;do{n=c[(c[e+(f<<2)>>2]|0)+384>>2]|0;l=(l|0)>(n|0)?l:n;f=f+1|0}while((f|0)!=(o|0));f=0;while(1){e=c[e+(f<<2)>>2]|0;if((c[e+852>>2]|0)>0){h=0;do{n=c[(c[e+860>>2]|0)+(h<<2)>>2]|0;Jb[c[(c[n>>2]|0)+8>>2]&15](n,+g[e+452>>2],l);h=h+1|0}while((h|0)<(c[e+852>>2]|0))}f=f+1|0;if((f|0)==(o|0))break;e=c[b+336>>2]|0}if((l|0)>0){j=0;do{k=0;do{e=c[(c[b+336>>2]|0)+(k<<2)>>2]|0;f=c[e+852>>2]|0;if((f|0)>0){h=0;do{n=c[(c[e+860>>2]|0)+(h<<2)>>2]|0;Nb[c[(c[n>>2]|0)+12>>2]&7](n,+g[e+452>>2],1.0);h=h+1|0}while((h|0)!=(f|0))}k=k+1|0}while((k|0)!=(o|0));j=j+1|0}while((j|0)!=(l|0));n=0}else n=0;do{m=c[(c[b+336>>2]|0)+(n<<2)>>2]|0;if((c[m+852>>2]|0)>0){h=0;do{e=c[(c[m+860>>2]|0)+(h<<2)>>2]|0;zb[c[(c[e>>2]|0)+16>>2]&31](e,+g[m+452>>2]);e=c[m+860>>2]|0;f=c[e+(h<<2)>>2]|0;a:do if(a[f+152>>0]|0){if(!f)l=e;else{c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0);l=c[m+860>>2]|0}e=h+-1|0;f=c[m+852>>2]|0;if((f|0)>0){k=c[l+(h<<2)>>2]|0;h=0;while(1){j=l+(h<<2)|0;if((c[j>>2]|0)==(k|0))break;h=h+1|0;if((h|0)>=(f|0))break a}if((h|0)<(f|0)){c[j>>2]=c[l+(f+-1<<2)>>2];c[(c[m+860>>2]|0)+(f+-1<<2)>>2]=k;c[m+852>>2]=f+-1;f=f+-1|0}}}else{f=c[m+852>>2]|0;e=h}while(0);h=e+1|0}while((h|0)<(f|0))}n=n+1|0}while((n|0)!=(o|0))}e=c[b+452>>2]|0;zb[c[(c[e>>2]|0)+28>>2]&31](e,+g[e+12>>2]*d);e=c[2357]|0;o=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=o;do if(!o){if(c[e+4>>2]|0){tb(p|0,0)|0;o=c[6434]|0;g[e+8>>2]=+g[e+8>>2]+ +(((c[p+4>>2]|0)-(c[o+4>>2]|0)+(((c[p>>2]|0)-(c[o>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3;if(c[e+16>>2]|0)break;e=c[2357]|0}c[2357]=c[e+20>>2]}while(0);if((c[b+328>>2]|0)<=0){b=c[b+452>>2]|0;o=c[b>>2]|0;o=o+32|0;o=c[o>>2]|0;Ab[o&255](b);i=p;return}e=0;do{o=c[(c[b+336>>2]|0)+(e<<2)>>2]|0;bi(o,o);e=e+1|0}while((e|0)<(c[b+328>>2]|0));b=c[b+452>>2]|0;o=c[b>>2]|0;o=o+32|0;o=c[o>>2]|0;Ab[o&255](b);i=p;return}function Ge(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+64|0;li(14295);d=c[b+8>>2]|0;if((d|0)>0){o=0;do{n=c[(c[b+16>>2]|0)+(o<<2)>>2]|0;if(!(a[b+76>>0]|0))switch(c[n+216>>2]|0){case 2:case 5:break;default:q=11}else q=11;if((q|0)==11){q=0;d=c[n+192>>2]|0;mc[c[(c[d>>2]|0)+8>>2]&127](d,n+4|0,r+48|0,r+32|0);e=+g[r+48>>2]+-.019999999552965164;g[r+48>>2]=e;f=+g[r+48+4>>2]+-.019999999552965164;g[r+48+4>>2]=f;h=+g[r+48+8>>2]+-.019999999552965164;g[r+48+8>>2]=h;j=+g[r+32>>2]+.019999999552965164;g[r+32>>2]=j;k=+g[r+32+4>>2]+.019999999552965164;g[r+32+4>>2]=k;l=+g[r+32+8>>2]+.019999999552965164;g[r+32+8>>2]=l;if(((a[b+44>>0]|0)!=0?(c[n+236>>2]|0)==2:0)?(c[n+204>>2]&3|0)==0:0){d=c[n+192>>2]|0;mc[c[(c[d>>2]|0)+8>>2]&127](d,n+68|0,r+16|0,r);f=+g[r+16>>2]+-.019999999552965164;g[r+16>>2]=f;h=+g[r+16+4>>2]+-.019999999552965164;g[r+16+4>>2]=h;j=+g[r+16+8>>2]+-.019999999552965164;g[r+16+8>>2]=j;k=+g[r>>2]+.019999999552965164;g[r>>2]=k;l=+g[r+4>>2]+.019999999552965164;g[r+4>>2]=l;m=+g[r+8>>2]+.019999999552965164;g[r+8>>2]=m;e=+g[r+48>>2];if(f<e){g[r+48>>2]=f;e=f}f=+g[r+48+4>>2];if(h<f){g[r+48+4>>2]=h;f=h}h=+g[r+48+8>>2];if(j<h){g[r+48+8>>2]=j;h=j}j=+g[r+16+12>>2];if(j<+g[r+48+12>>2])g[r+48+12>>2]=j;j=+g[r+32>>2];if(j<k){g[r+32>>2]=k;j=k}k=+g[r+32+4>>2];if(k<l){g[r+32+4>>2]=l;k=l}l=+g[r+32+8>>2];if(l<m){g[r+32+8>>2]=m;l=m}m=+g[r+12>>2];if(+g[r+32+12>>2]<m)g[r+32+12>>2]=m}d=c[b+68>>2]|0;if((c[n+204>>2]&1|0)==0?(j=j-e,k=k-f,m=l-h,!(j*j+k*k+m*m<999999995904.0)):0){if((c[n+216>>2]&-2|0)!=4)c[n+216>>2]=5;if(a[14307]|0?(p=c[b+72>>2]|0,p|0):0){a[14307]=0;Cb[c[(c[p>>2]|0)+36>>2]&127](p,14308);n=c[b+72>>2]|0;Cb[c[(c[n>>2]|0)+36>>2]&127](n,14357);n=c[b+72>>2]|0;Cb[c[(c[n>>2]|0)+36>>2]&127](n,14425);n=c[b+72>>2]|0;Cb[c[(c[n>>2]|0)+36>>2]&127](n,14490)}}else yb[c[(c[d>>2]|0)+16>>2]&31](d,c[n+188>>2]|0,r+48|0,r+32|0,c[b+24>>2]|0);d=c[b+8>>2]|0}o=o+1|0}while((o|0)<(d|0))}d=c[2357]|0;q=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=q;if(q|0){i=r;return}do if(c[d+4>>2]|0){tb(r+48|0,0)|0;q=c[6434]|0;g[d+8>>2]=+g[d+8>>2]+ +(((c[r+48+4>>2]|0)-(c[q+4>>2]|0)+(((c[r+48>>2]|0)-(c[q>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[d+16>>2]|0)){d=c[2357]|0;break}else{i=r;return}}while(0);c[2357]=c[d+20>>2];i=r;return}function He(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0,j=0,k=0.0;a=i;i=i+192|0;switch(c[b+388>>2]&15|0){case 1:{c[a+160>>2]=3364;h=c[d+8>>2]|0;h=(c[h+236>>2]&2|0)==0?0:h;j=c[d+12>>2]|0;k=+g[j+48>>2];e=+g[j+52>>2];f=+g[j+56>>2];f=+O(+((k-k)*(k-k)+(e-e)*(e-e)+(f-f)*(f-f)));j=c[b+192>>2]|0;e=+Sb[c[(c[j>>2]|0)+48>>2]&15](j);j=c[d+4>>2]|0;mc[c[(c[j>>2]|0)+8>>2]&127](j,c[d+12>>2]|0,a+144|0,a+128|0);c[a+32>>2]=c[a+144>>2];c[a+32+4>>2]=c[a+144+4>>2];c[a+32+8>>2]=c[a+144+8>>2];c[a+32+12>>2]=c[a+144+12>>2];c[a+32+16>>2]=c[a+128>>2];c[a+32+16+4>>2]=c[a+128+4>>2];c[a+32+16+8>>2]=c[a+128+8>>2];c[a+32+16+12>>2]=c[a+128+12>>2];c[a+96>>2]=c[a+32>>2];c[a+96+4>>2]=c[a+32+4>>2];c[a+96+8>>2]=c[a+32+8>>2];c[a+96+12>>2]=c[a+32+12>>2];c[a+96+16>>2]=c[a+32+16>>2];c[a+96+20>>2]=c[a+32+20>>2];c[a+96+24>>2]=c[a+32+24>>2];c[a+96+28>>2]=c[a+32+28>>2];g[a+96>>2]=+g[a+96>>2]-e;g[a+96+4>>2]=+g[a+96+4>>2]-e;g[a+96+8>>2]=+g[a+96+8>>2]-e;g[a+96+16>>2]=e+ +g[a+96+16>>2];g[a+96+20>>2]=e+ +g[a+96+20>>2];g[a+96+24>>2]=e+ +g[a+96+24>>2];c[a+160+4>>2]=b;c[a+160+8>>2]=d;c[a+160+12>>2]=h;g[a+160+16>>2]=f+e;g[a+160+20>>2]=e;bg(c[b+928>>2]|0,a+96|0,a+160|0);i=a;return}case 2:{g[a+4>>2]=1.0;c[a+8>>2]=0;c[a+8+4>>2]=0;c[a+8+8>>2]=0;c[a+8+12>>2]=0;c[a>>2]=3400;c[a+24>>2]=b;c[a+28>>2]=d;c[a+8>>2]=c[b+456>>2];j=c[d+4>>2]|0;k=+Sb[c[(c[j>>2]|0)+48>>2]&15](j);j=c[b+192>>2]|0;k=k+ +Sb[c[(c[j>>2]|0)+48>>2]&15](j);g[a+12>>2]=k;f=+g[(c[d+8>>2]|0)+224>>2];g[a+160>>2]=f;c[a+16>>2]=c[(+g[b+316>>2]<f?b+316|0:a+160|0)>>2];j=c[d+4>>2]|0;mc[c[(c[j>>2]|0)+8>>2]&127](j,c[d+12>>2]|0,a+144|0,a+128|0);c[a+64>>2]=c[a+144>>2];c[a+64+4>>2]=c[a+144+4>>2];c[a+64+8>>2]=c[a+144+8>>2];c[a+64+12>>2]=c[a+144+12>>2];c[a+64+16>>2]=c[a+128>>2];c[a+64+16+4>>2]=c[a+128+4>>2];c[a+64+16+8>>2]=c[a+128+8>>2];c[a+64+16+12>>2]=c[a+128+12>>2];c[a+96>>2]=c[a+64>>2];c[a+96+4>>2]=c[a+64+4>>2];c[a+96+8>>2]=c[a+64+8>>2];c[a+96+12>>2]=c[a+64+12>>2];c[a+96+16>>2]=c[a+64+16>>2];c[a+96+20>>2]=c[a+64+20>>2];c[a+96+24>>2]=c[a+64+24>>2];c[a+96+28>>2]=c[a+64+28>>2];g[a+96>>2]=+g[a+96>>2]-k;g[a+96+4>>2]=+g[a+96+4>>2]-k;g[a+96+8>>2]=+g[a+96+8>>2]-k;g[a+96+16>>2]=k+ +g[a+96+16>>2];g[a+96+20>>2]=k+ +g[a+96+20>>2];g[a+96+24>>2]=k+ +g[a+96+24>>2];bg(c[b+1048>>2]|0,a+96|0,a);i=a;return}default:{i=a;return}}}function Ie(a,b,d){a=a|0;b=b|0;d=d|0;var f=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+80|0;o=c[a+4>>2]|0;Yb[c[(c[o>>2]|0)+16>>2]&3](o,r+28|0,r+24|0,r+20|0,r+16|0,r+12|0,r+8|0,r+4|0,r,b);o=(c[r+12>>2]|0)+(_(c[r+8>>2]|0,d)|0)|0;q=c[a+4>>2]|0;p=(c[r+20>>2]|0)==0;n=c[r+28>>2]|0;if((c[r>>2]|0)==3){m=c[r+16>>2]|0;l=n+(_(m,e[o+4>>1]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32+32>>2]=f;g[r+32+36>>2]=k;g[r+32+40>>2]=j;g[r+32+44>>2]=0.0;l=n+(_(m,e[o+2>>1]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32+16>>2]=f;g[r+32+20>>2]=k;g[r+32+24>>2]=j;g[r+32+28>>2]=0.0;l=n+(_(m,e[o>>1]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32>>2]=f;g[r+32+4>>2]=k;g[r+32+8>>2]=j;g[r+32+12>>2]=0.0;q=a+8|0;q=c[q>>2]|0;p=c[q>>2]|0;p=p+8|0;p=c[p>>2]|0;mc[p&127](q,r+32|0,b,d);a=c[a+4>>2]|0;d=c[a>>2]|0;d=d+24|0;d=c[d>>2]|0;Cb[d&127](a,b);i=r;return}else{m=c[r+16>>2]|0;l=n+(_(m,c[o+8>>2]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32+32>>2]=f;g[r+32+36>>2]=k;g[r+32+40>>2]=j;g[r+32+44>>2]=0.0;l=n+(_(m,c[o+4>>2]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32+16>>2]=f;g[r+32+20>>2]=k;g[r+32+24>>2]=j;g[r+32+28>>2]=0.0;l=n+(_(m,c[o>>2]|0)|0)|0;if(p){j=+g[l+8>>2]*+g[q+12>>2];k=+g[l+4>>2]*+g[q+8>>2];f=+g[l>>2]*+g[q+4>>2]}else{j=+h[l+16>>3]*+g[q+12>>2];k=+h[l+8>>3]*+g[q+8>>2];f=+h[l>>3]*+g[q+4>>2]}g[r+32>>2]=f;g[r+32+4>>2]=k;g[r+32+8>>2]=j;g[r+32+12>>2]=0.0;q=a+8|0;q=c[q>>2]|0;p=c[q>>2]|0;p=p+8|0;p=c[p>>2]|0;mc[p&127](q,r+32|0,b,d);a=c[a+4>>2]|0;d=c[a>>2]|0;d=d+24|0;d=c[d>>2]|0;Cb[d&127](a,b);i=r;return}}function Je(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0,J=0;c[6435]=(c[6435]|0)+1;f=yc(1147)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}Il();c[f+4>>2]=7;c[f+8>>2]=-1;c[f+12>>2]=-1;g[f+16>>2]=3402823466385288598117041.0e14;a[f+20>>0]=1;a[f+21>>0]=0;c[f+24>>2]=-1;i=f+28|0;c[i>>2]=23268;h=f+32|0;c[h>>2]=b;g[f+36>>2]=0.0;g[f+40>>2]=.30000001192092896;c[f+44>>2]=0;c[f>>2]=4596;a[f+48>>0]=0;J=f+116|0;c[J>>2]=c[d>>2];c[J+4>>2]=c[d+4>>2];c[J+8>>2]=c[d+8>>2];c[J+12>>2]=c[d+12>>2];I=f+132|0;c[I>>2]=c[d+16>>2];c[I+4>>2]=c[d+16+4>>2];c[I+8>>2]=c[d+16+8>>2];c[I+12>>2]=c[d+16+12>>2];H=f+148|0;c[H>>2]=c[d+32>>2];c[H+4>>2]=c[d+32+4>>2];c[H+8>>2]=c[d+32+8>>2];c[H+12>>2]=c[d+32+12>>2];G=f+164|0;c[G>>2]=c[d+48>>2];c[G+4>>2]=c[d+48+4>>2];c[G+8>>2]=c[d+48+8>>2];c[G+12>>2]=c[d+48+12>>2];a[f+180>>0]=e&1;x=+g[J>>2];D=+g[b+4>>2];w=+g[I>>2];C=+g[b+8>>2];v=+g[H>>2];B=+g[b+12>>2];u=+g[f+120>>2];t=+g[f+136>>2];s=+g[f+152>>2];r=+g[f+124>>2];p=+g[f+140>>2];n=+g[f+156>>2];A=+g[b+20>>2];z=+g[b+24>>2];y=+g[b+28>>2];q=+g[b+36>>2];o=+g[b+40>>2];m=+g[b+44>>2];F=+g[G>>2];E=+g[f+168>>2];j=+g[f+172>>2];l=+g[b+52>>2]+(D*F+C*E+B*j);k=A*F+z*E+y*j+ +g[b+56>>2];j=q*F+o*E+m*j+ +g[b+60>>2];g[f+52>>2]=x*D+w*C+v*B;g[f+56>>2]=D*u+C*t+B*s;g[f+60>>2]=D*r+C*p+B*n;g[f+64>>2]=0.0;g[f+68>>2]=x*A+w*z+v*y;g[f+72>>2]=u*A+t*z+s*y;g[f+76>>2]=r*A+p*z+n*y;g[f+80>>2]=0.0;g[f+84>>2]=x*q+w*o+v*m;g[f+88>>2]=u*q+t*o+s*m;g[f+92>>2]=r*q+p*o+n*m;g[f+96>>2]=0.0;g[f+100>>2]=l;g[f+104>>2]=k;g[f+108>>2]=j;g[f+112>>2]=0.0;g[f+184>>2]=1.0;g[f+188>>2]=-1.0;g[f+192>>2]=0.0;g[f+196>>2]=0.0;g[f+200>>2]=1.0;g[f+204>>2]=.699999988079071;g[f+208>>2]=0.0;g[f+212>>2]=0.0;g[f+216>>2]=1.0;g[f+220>>2]=.699999988079071;g[f+224>>2]=0.0;g[f+228>>2]=0.0;g[f+264>>2]=1.0;g[f+268>>2]=.699999988079071;g[f+272>>2]=1.0;g[f+276>>2]=0.0;g[f+280>>2]=1.0;g[f+284>>2]=.699999988079071;g[f+288>>2]=1.0;g[f+292>>2]=0.0;g[f+232>>2]=1.0;g[f+236>>2]=.699999988079071;g[f+240>>2]=1.0;g[f+244>>2]=0.0;g[f+248>>2]=1.0;g[f+252>>2]=.699999988079071;g[f+256>>2]=1.0;g[f+260>>2]=0.0;a[f+1096>>0]=0;e=f+1100|0;g[f+1116>>2]=0.0;g[f+1120>>2]=0.0;g[f+1124>>2]=0.0;c[f+300>>2]=0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;a[e+12>>0]=0;a[f+49>>0]=1;kd(f,(c[i>>2]|0)+4|0,(c[h>>2]|0)+4|0);return f|0}function Ke(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0,I=0.0;d=i;i=i+96|0;l=+g[b>>2];s=+g[a+28>>2];B=+g[b+4>>2];D=+g[a+32>>2];m=+g[b+8>>2];n=+g[a+36>>2];o=+g[a+44>>2];p=+g[a+48>>2];q=+g[a+52>>2];r=+g[a+60>>2];t=+g[a+64>>2];u=+g[a+68>>2];v=+g[a+76>>2];w=+g[a+80>>2];x=+g[a+84>>2];g[d+80>>2]=l*s+B*D+m*n+v;g[d+80+4>>2]=l*o+B*p+m*q+w;g[d+80+8>>2]=l*r+B*t+m*u+x;g[d+80+12>>2]=0.0;y=+g[b+16>>2];z=+g[b+20>>2];A=+g[b+24>>2];g[d+64>>2]=y*s+z*D+A*n+v;g[d+64+4>>2]=y*o+z*p+A*q+w;g[d+64+8>>2]=y*r+z*t+A*u+x;g[d+64+12>>2]=0.0;C=+g[b+32>>2];E=+g[b+36>>2];k=+g[b+40>>2];g[d+48>>2]=C*s+E*D+k*n+v;g[d+48+4>>2]=C*o+E*p+k*q+w;g[d+48+8>>2]=C*r+E*t+k*u+x;g[d+48+12>>2]=0.0;f=(l*s+B*D+m*n+v+(y*s+z*D+A*n+v)+(C*s+E*D+k*n+v))*.3333333432674408;h=(l*o+B*p+m*q+w+(y*o+z*p+A*q+w)+(C*o+E*p+k*q+w))*.3333333432674408;j=(l*r+B*t+m*u+x+(y*r+z*t+A*u+x)+(C*r+E*t+k*u+x))*.3333333432674408;g[d+32>>2]=f;g[d+32+4>>2]=h;g[d+32+8>>2]=j;g[d+32+12>>2]=0.0;b=c[a+8>>2]|0;if(!((Eb[c[(c[b>>2]|0)+48>>2]&127](b)|0)&16384)){e=c[a+8>>2]|0;F=c[e>>2]|0;F=F+8|0;F=c[F>>2]|0;b=a+12|0;mc[F&127](e,d+80|0,d+64|0,b);e=c[a+8>>2]|0;F=c[e>>2]|0;F=F+8|0;F=c[F>>2]|0;mc[F&127](e,d+64|0,d+48|0,b);a=c[a+8>>2]|0;e=c[a>>2]|0;e=e+8|0;e=c[e>>2]|0;mc[e&127](a,d+48|0,d+80|0,b);i=d;return}I=+g[d+80>>2];H=y*o+z*p+A*q+w-(l*o+B*p+m*q+w);G=y*r+z*t+A*u+x-(l*r+B*t+m*u+x);w=C*o+E*p+k*q+w-(l*o+B*p+m*q+w);x=C*r+E*t+k*u+x-(l*r+B*t+m*u+x);B=G*(C*s+E*D+k*n+v-I)-(y*s+z*D+A*n+v-I)*x;E=(y*s+z*D+A*n+v-I)*w-H*(C*s+E*D+k*n+v-I);D=1.0/+O(+(E*E+((H*x-G*w)*(H*x-G*w)+B*B)));c[d+16>>2]=1065353216;c[d+16+4>>2]=1065353216;c[d+16+8>>2]=0;g[d+16+12>>2]=0.0;b=c[a+8>>2]|0;e=c[(c[b>>2]|0)+8>>2]|0;g[d>>2]=D*(H*x-G*w)+f;g[d+4>>2]=D*B+h;g[d+8>>2]=D*E+j;g[d+12>>2]=0.0;mc[e&127](b,d+32|0,d,d+16|0);b=c[a+8>>2]|0;e=c[b>>2]|0;e=e+8|0;e=c[e>>2]|0;F=a+12|0;mc[e&127](b,d+80|0,d+64|0,F);b=c[a+8>>2]|0;e=c[b>>2]|0;e=e+8|0;e=c[e>>2]|0;mc[e&127](b,d+64|0,d+48|0,F);a=c[a+8>>2]|0;b=c[a>>2]|0;b=b+8|0;b=c[b>>2]|0;mc[b&127](a,d+48|0,d+80|0,F);i=d;return}function Le(b,d,e,f,h,i){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;c[b+4>>2]=6;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3402823466385288598117041.0e14;a[b+20>>0]=1;a[b+21>>0]=0;c[b+24>>2]=-1;c[b+28>>2]=d;c[b+32>>2]=e;g[b+36>>2]=0.0;g[b+40>>2]=.30000001192092896;c[b+44>>2]=0;c[b>>2]=4376;c[b+48>>2]=c[f>>2];c[b+48+4>>2]=c[f+4>>2];c[b+48+8>>2]=c[f+8>>2];c[b+48+12>>2]=c[f+12>>2];c[b+64>>2]=c[f+16>>2];c[b+64+4>>2]=c[f+16+4>>2];c[b+64+8>>2]=c[f+16+8>>2];c[b+64+12>>2]=c[f+16+12>>2];c[b+80>>2]=c[f+32>>2];c[b+80+4>>2]=c[f+32+4>>2];c[b+80+8>>2]=c[f+32+8>>2];c[b+80+12>>2]=c[f+32+12>>2];c[b+96>>2]=c[f+48>>2];c[b+96+4>>2]=c[f+48+4>>2];c[b+96+8>>2]=c[f+48+8>>2];c[b+96+12>>2]=c[f+48+12>>2];c[b+112>>2]=c[h>>2];c[b+112+4>>2]=c[h+4>>2];c[b+112+8>>2]=c[h+8>>2];c[b+112+12>>2]=c[h+12>>2];c[b+128>>2]=c[h+16>>2];c[b+128+4>>2]=c[h+16+4>>2];c[b+128+8>>2]=c[h+16+8>>2];c[b+128+12>>2]=c[h+16+12>>2];c[b+144>>2]=c[h+32>>2];c[b+144+4>>2]=c[h+32+4>>2];c[b+144+8>>2]=c[h+32+8>>2];c[b+144+12>>2]=c[h+32+12>>2];c[b+160>>2]=c[h+48>>2];c[b+160+4>>2]=c[h+48+4>>2];c[b+160+8>>2]=c[h+48+8>>2];c[b+160+12>>2]=c[h+48+12>>2];f=b+680|0;h=f+48|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(h|0));c[b+740>>2]=0;c[b+740+4>>2]=0;c[b+740+8>>2]=0;c[b+740+12>>2]=0;c[b+756>>2]=1045220557;c[b+760>>2]=1045220557;c[b+764>>2]=1045220557;c[b+768>>2]=0;c[b+768+4>>2]=0;c[b+768+8>>2]=0;c[b+768+12>>2]=0;c[b+768+16>>2]=0;g[b+728>>2]=.699999988079071;g[b+732>>2]=1.0;g[b+736>>2]=.5;a[b+788>>0]=0;g[b+792>>2]=0.0;g[b+808>>2]=0.0;a[b+789>>0]=0;g[b+796>>2]=0.0;g[b+812>>2]=0.0;a[b+790>>0]=0;g[b+800>>2]=0.0;g[b+816>>2]=0.0;g[b+928>>2]=0.0;g[b+876>>2]=0.0;g[b+880>>2]=.10000000149011612;g[b+884>>2]=300.0;g[b+868>>2]=1.0;g[b+872>>2]=-1.0;g[b+896>>2]=0.0;g[b+900>>2]=.20000000298023224;g[b+904>>2]=0.0;g[b+908>>2]=0.0;g[b+888>>2]=1.0;g[b+892>>2]=.5;c[b+924>>2]=0;g[b+916>>2]=0.0;a[b+912>>0]=0;g[b+992>>2]=0.0;g[b+940>>2]=0.0;g[b+944>>2]=.10000000149011612;g[b+948>>2]=300.0;g[b+932>>2]=1.0;g[b+936>>2]=-1.0;g[b+960>>2]=0.0;g[b+964>>2]=.20000000298023224;g[b+968>>2]=0.0;g[b+972>>2]=0.0;g[b+952>>2]=1.0;g[b+956>>2]=.5;c[b+988>>2]=0;g[b+980>>2]=0.0;a[b+976>>0]=0;g[b+1056>>2]=0.0;g[b+1004>>2]=0.0;g[b+1008>>2]=.10000000149011612;g[b+1012>>2]=300.0;g[b+996>>2]=1.0;g[b+1e3>>2]=-1.0;g[b+1024>>2]=0.0;g[b+1028>>2]=.20000000298023224;g[b+1032>>2]=0.0;g[b+1036>>2]=0.0;g[b+1016>>2]=1.0;g[b+1020>>2]=.5;c[b+1052>>2]=0;g[b+1044>>2]=0.0;a[b+1040>>0]=0;a[b+1300>>0]=i&1;a[b+1301>>0]=1;c[b+1304>>2]=0;a[b+1308>>0]=0;sd(b,(c[b+28>>2]|0)+4|0,(c[b+32>>2]|0)+4|0);return}function Me(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0,m=0;if(!b)b=0;else b=(c[b+236>>2]&2|0)==0?0:b;c[a+64>>2]=0;c[a+64+4>>2]=0;c[a+64+8>>2]=0;c[a+64+12>>2]=0;c[a+64+16>>2]=0;c[a+64+20>>2]=0;c[a+64+24>>2]=0;c[a+64+28>>2]=0;c[a+144>>2]=0;c[a+144+4>>2]=0;c[a+144+8>>2]=0;c[a+144+12>>2]=0;c[a+144+16>>2]=0;c[a+144+20>>2]=0;c[a+144+24>>2]=0;c[a+144+28>>2]=0;if(!b){c[a>>2]=1065353216;c[a+4>>2]=0;c[a+4+4>>2]=0;c[a+4+8>>2]=0;c[a+4+12>>2]=0;c[a+20>>2]=1065353216;c[a+24>>2]=0;c[a+24+4>>2]=0;c[a+24+8>>2]=0;c[a+24+12>>2]=0;c[a+40>>2]=1065353216;c[a+44>>2]=0;c[a+44+4>>2]=0;c[a+44+8>>2]=0;c[a+44+12>>2]=0;c[a+44+16>>2]=0;c[a+240>>2]=0;c[a+128>>2]=0;c[a+128+4>>2]=0;c[a+128+8>>2]=0;c[a+128+12>>2]=0;c[a+96>>2]=1065353216;c[a+100>>2]=1065353216;c[a+104>>2]=1065353216;g[a+108>>2]=0.0;c[a+112>>2]=1065353216;c[a+116>>2]=1065353216;c[a+120>>2]=1065353216;g[a+124>>2]=0.0;b=a+176|0;e=b+60|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(e|0));a=a+236|0;g[a>>2]=0.0;return}else{e=b+4|0;c[a>>2]=c[e>>2];c[a+4>>2]=c[e+4>>2];c[a+8>>2]=c[e+8>>2];c[a+12>>2]=c[e+12>>2];e=b+20|0;c[a+16>>2]=c[e>>2];c[a+16+4>>2]=c[e+4>>2];c[a+16+8>>2]=c[e+8>>2];c[a+16+12>>2]=c[e+12>>2];e=b+36|0;c[a+32>>2]=c[e>>2];c[a+32+4>>2]=c[e+4>>2];c[a+32+8>>2]=c[e+8>>2];c[a+32+12>>2]=c[e+12>>2];e=b+52|0;c[a+48>>2]=c[e>>2];c[a+48+4>>2]=c[e+4>>2];c[a+48+8>>2]=c[e+8>>2];c[a+48+12>>2]=c[e+12>>2];e=b+344|0;k=+g[e>>2];l=b+348|0;j=k*+g[b+352>>2];i=k*+g[b+356>>2];g[a+128>>2]=k*+g[l>>2];g[a+132>>2]=j;g[a+136>>2]=i;g[a+140>>2]=0.0;c[a+240>>2]=b;m=b+544|0;c[a+96>>2]=c[m>>2];c[a+96+4>>2]=c[m+4>>2];c[a+96+8>>2]=c[m+8>>2];c[a+96+12>>2]=c[m+12>>2];c[a+112>>2]=c[l>>2];c[a+112+4>>2]=c[l+4>>2];c[a+112+8>>2]=c[l+8>>2];c[a+112+12>>2]=c[l+12>>2];l=b+312|0;c[a+176>>2]=c[l>>2];c[a+176+4>>2]=c[l+4>>2];c[a+176+8>>2]=c[l+8>>2];c[a+176+12>>2]=c[l+12>>2];l=b+328|0;c[a+192>>2]=c[l>>2];c[a+192+4>>2]=c[l+4>>2];c[a+192+8>>2]=c[l+8>>2];c[a+192+12>>2]=c[l+12>>2];i=+g[e>>2];j=i*+g[b+416>>2]*d;k=i*+g[b+420>>2]*d;g[a+208>>2]=i*+g[b+412>>2]*d;g[a+212>>2]=j;g[a+216>>2]=k;g[a+220>>2]=0.0;k=+g[b+428>>2];j=+g[b+432>>2];i=+g[b+436>>2];h=(k*+g[b+268>>2]+j*+g[b+284>>2]+i*+g[b+300>>2])*d;f=(k*+g[b+272>>2]+j*+g[b+288>>2]+i*+g[b+304>>2])*d;g[a+224>>2]=(+g[b+264>>2]*k+ +g[b+280>>2]*j+ +g[b+296>>2]*i)*d;g[a+228>>2]=h;g[a+232>>2]=f;a=a+236|0;g[a>>2]=0.0;return}}function Ne(a,e,f){a=a|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;c[e+16>>2]=c[a+20>>2];c[e+20>>2]=c[a+24>>2];c[e+24>>2]=c[a+28>>2];c[e+28>>2]=c[a+32>>2];c[e>>2]=c[a+4>>2];c[e+4>>2]=c[a+8>>2];c[e+8>>2]=c[a+12>>2];c[e+12>>2]=c[a+16>>2];c[e+32>>2]=c[a+36>>2];c[e+36>>2]=c[a+40>>2];c[e+40>>2]=c[a+44>>2];c[e+44>>2]=c[a+48>>2];c[e+48>>2]=c[a+56>>2];c[e+52>>2]=d[a+60>>0];k=c[a+88>>2]|0;c[e+56>>2]=k;if(k){k=Zb[c[(c[f>>2]|0)+28>>2]&31](f,c[a+96>>2]|0)|0;c[e+64>>2]=k;if(k|0){h=c[a+88>>2]|0;k=Ob[c[(c[f>>2]|0)+16>>2]&63](f,48,h)|0;if((h|0)>0){g=c[a+96>>2]|0;i=0;j=c[k+8>>2]|0;while(1){c[j+16>>2]=c[g+(i<<6)+16>>2];c[j+20>>2]=c[g+(i<<6)+20>>2];c[j+24>>2]=c[g+(i<<6)+24>>2];c[j+28>>2]=c[g+(i<<6)+28>>2];c[j>>2]=c[g+(i<<6)>>2];c[j+4>>2]=c[g+(i<<6)+4>>2];c[j+8>>2]=c[g+(i<<6)+8>>2];c[j+12>>2]=c[g+(i<<6)+12>>2];c[j+32>>2]=c[g+(i<<6)+32>>2];c[j+36>>2]=c[g+(i<<6)+36>>2];c[j+40>>2]=c[g+(i<<6)+40>>2];i=i+1|0;if((i|0)==(h|0))break;else j=j+48|0}}else g=c[a+96>>2]|0;yb[c[(c[f>>2]|0)+20>>2]&31](f,k,18461,1497453121,g)}}else c[e+64>>2]=0;k=c[a+128>>2]|0;c[e+60>>2]=k;if(k){k=Zb[c[(c[f>>2]|0)+28>>2]&31](f,c[a+136>>2]|0)|0;c[e+68>>2]=k;if(k|0){h=c[a+128>>2]|0;k=Ob[c[(c[f>>2]|0)+16>>2]&63](f,16,h)|0;if((h|0)>0){g=c[a+136>>2]|0;i=0;j=c[k+8>>2]|0;while(1){c[j+12>>2]=c[g+(i<<4)+12>>2];b[j+6>>1]=b[g+(i<<4)+6>>1]|0;b[j+8>>1]=b[g+(i<<4)+8>>1]|0;b[j+10>>1]=b[g+(i<<4)+10>>1]|0;b[j>>1]=b[g+(i<<4)>>1]|0;b[j+2>>1]=b[g+(i<<4)+2>>1]|0;b[j+4>>1]=b[g+(i<<4)+4>>1]|0;i=i+1|0;if((i|0)==(h|0))break;else j=j+16|0}}else g=c[a+136>>2]|0;yb[c[(c[f>>2]|0)+20>>2]&31](f,k,18484,1497453121,g)}}else c[e+68>>2]=0;c[e+76>>2]=c[a+144>>2];k=c[a+152>>2]|0;c[e+80>>2]=k;if(!k){c[e+72>>2]=0;return 18528}k=Zb[c[(c[f>>2]|0)+28>>2]&31](f,c[a+160>>2]|0)|0;c[e+72>>2]=k;if(!k)return 18528;j=c[a+152>>2]|0;k=Ob[c[(c[f>>2]|0)+16>>2]&63](f,20,j)|0;if((j|0)>0){g=c[a+160>>2]|0;h=0;i=c[k+8>>2]|0;while(1){b[i+14>>1]=b[g+(h<<5)+6>>1]|0;b[i+16>>1]=b[g+(h<<5)+8>>1]|0;b[i+18>>1]=b[g+(h<<5)+10>>1]|0;b[i+8>>1]=b[g+(h<<5)>>1]|0;b[i+10>>1]=b[g+(h<<5)+2>>1]|0;b[i+12>>1]=b[g+(h<<5)+4>>1]|0;c[i>>2]=c[g+(h<<5)+12>>2];c[i+4>>2]=c[g+(h<<5)+16>>2];h=h+1|0;if((h|0)==(j|0))break;else i=i+20|0}}else g=c[a+160>>2]|0;yb[c[(c[f>>2]|0)+20>>2]&31](f,k,18507,1497453121,g);return 18528}function Oe(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0;L=i;i=i+64|0;c[L+48>>2]=a;c[L+48+4>>2]=b;c[L+48+8>>2]=d;C=+g[a>>2];F=+g[b>>2];J=+g[a+4>>2];K=+g[b+4>>2];z=+g[a+8>>2];A=+g[b+8>>2];g[L>>2]=C-F;g[L+4>>2]=J-K;g[L+8>>2]=z-A;g[L+12>>2]=0.0;B=+g[d>>2];D=+g[d+4>>2];E=+g[d+8>>2];g[L+16>>2]=F-B;g[L+20>>2]=K-D;g[L+24>>2]=A-E;g[L+28>>2]=0.0;g[L+32>>2]=B-C;g[L+36>>2]=D-J;g[L+40>>2]=E-z;g[L+44>>2]=0.0;G=(J-K)*(A-E)-(z-A)*(K-D);H=(z-A)*(F-B)-(A-E)*(C-F);I=(K-D)*(C-F)-(J-K)*(F-B);if(I*I+(G*G+H*H)>0.0){o=J-K;p=z-A;q=C-F;v=C;w=J;x=z;m=0;y=-1.0;n=0;h=0;j=0}else{K=-1.0;i=L;return +K}while(1){if(v*(I*o-H*p)+w*(G*p-I*q)+(H*q-G*o)*x>0.0){u=c[4976+(m<<2)>>2]|0;M=c[L+48+(u<<2)>>2]|0;l=+g[M>>2];p=l-v;q=+g[M+4>>2];r=q-w;s=+g[M+8>>2];t=s-x;do if(p*p+r*r+t*t>0.0){o=-(v*p+w*r+x*t)/(p*p+r*r+t*t);if(o>=1.0){l=l*l+q*q+s*s;n=2;h=0;j=1065353216;break}if(!(o<=0.0)){j=(g[k>>2]=o,c[k>>2]|0);v=v+p*o;l=w+r*o;x=x+t*o;l=x*x+(v*v+l*l);n=3;h=(g[k>>2]=1.0-o,c[k>>2]|0);break}else{l=v*v+w*w+x*x;n=1;h=1065353216;j=0;break}}else l=-1.0;while(0);if(y<0.0|l<y){c[f>>2]=(n&1|0?1<<m:0)+(n&2|0?1<<u:0);c[e+(m<<2)>>2]=h;c[e+(u<<2)>>2]=j;g[e+(c[4976+(u<<2)>>2]<<2)>>2]=0.0}else l=y}else l=y;m=m+1|0;if((m|0)==3)break;M=c[L+48+(m<<2)>>2]|0;o=+g[L+(m<<4)+4>>2];p=+g[L+(m<<4)+8>>2];q=+g[L+(m<<4)>>2];v=+g[M>>2];w=+g[M+4>>2];x=+g[M+8>>2];y=l}if(!(l<0.0)){K=l;i=L;return +K}x=+O(+(I*I+(G*G+H*H)));y=(G*+g[a>>2]+H*+g[a+4>>2]+I*+g[a+8>>2])/(I*I+(G*G+H*H));c[f>>2]=7;v=+g[b>>2]-G*y;t=+g[b+4>>2]-H*y;w=+g[b+8>>2]-I*y;K=+O(+((t*(F-B)-v*(K-D))*(t*(F-B)-v*(K-D))+(((K-D)*w-t*(A-E))*((K-D)*w-t*(A-E))+(v*(A-E)-w*(F-B))*(v*(A-E)-w*(F-B)))))/x;g[e>>2]=K;A=+g[d>>2]-G*y;w=+g[d+4>>2]-H*y;F=+g[d+8>>2]-I*y;J=+O(+((w*(B-C)-A*(D-J))*(w*(B-C)-A*(D-J))+(((D-J)*F-w*(E-z))*((D-J)*F-w*(E-z))+(A*(E-z)-F*(B-C))*(A*(E-z)-F*(B-C)))))/x;g[e+4>>2]=J;g[e+8>>2]=1.0-(J+K);K=I*y*I*y+(G*y*G*y+H*y*H*y);i=L;return +K}function Pe(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;d=i;i=i+144|0;g[a+36>>2]=0.0;c[d+128>>2]=0;c[d+128+4>>2]=0;c[d+128+8>>2]=0;c[d+128+12>>2]=0;b=0;do{e=d+128+(b<<2)|0;g[e>>2]=1.0;A=c[a+28>>2]|0;I=c[A+4>>2]|0;c[d+80>>2]=I;F=c[A+20>>2]|0;c[d+80+4>>2]=F;C=c[A+36>>2]|0;c[d+80+8>>2]=C;g[d+80+12>>2]=0.0;H=c[A+8>>2]|0;c[d+80+16>>2]=H;E=c[A+24>>2]|0;c[d+80+20>>2]=E;B=c[A+40>>2]|0;c[d+80+24>>2]=B;g[d+80+28>>2]=0.0;G=c[A+12>>2]|0;c[d+80+32>>2]=G;D=c[A+28>>2]|0;c[d+80+36>>2]=D;z=c[A+44>>2]|0;c[d+80+40>>2]=z;g[d+80+44>>2]=0.0;f=c[a+32>>2]|0;y=c[f+4>>2]|0;c[d+32>>2]=y;v=c[f+20>>2]|0;c[d+32+4>>2]=v;s=c[f+36>>2]|0;c[d+32+8>>2]=s;g[d+32+12>>2]=0.0;x=c[f+8>>2]|0;c[d+32+16>>2]=x;u=c[f+24>>2]|0;c[d+32+20>>2]=u;r=c[f+40>>2]|0;c[d+32+24>>2]=r;g[d+32+28>>2]=0.0;w=c[f+12>>2]|0;c[d+32+32>>2]=w;t=c[f+28>>2]|0;c[d+32+36>>2]=t;h=c[f+44>>2]|0;c[d+32+40>>2]=h;g[d+32+44>>2]=0.0;p=+g[a+300>>2];m=p*(c[k>>2]=I,+g[k>>2]);j=+g[a+304>>2];m=m+j*(c[k>>2]=H,+g[k>>2]);l=+g[a+308>>2];m=m+l*(c[k>>2]=G,+g[k>>2]);q=p*(c[k>>2]=F,+g[k>>2]);q=q+j*(c[k>>2]=E,+g[k>>2]);q=q+l*(c[k>>2]=D,+g[k>>2]);p=p*(c[k>>2]=C,+g[k>>2]);j=p+j*(c[k>>2]=B,+g[k>>2]);p=+g[A+52>>2];o=+g[A+56>>2];n=+g[A+60>>2];n=j+l*(c[k>>2]=z,+g[k>>2])+n-n;g[d+16>>2]=m+p-p;g[d+16+4>>2]=q+o-o;g[d+16+8>>2]=n;g[d+16+12>>2]=0.0;n=+g[a+316>>2];o=n*(c[k>>2]=y,+g[k>>2]);q=+g[a+320>>2];o=o+q*(c[k>>2]=x,+g[k>>2]);p=+g[a+324>>2];o=o+p*(c[k>>2]=w,+g[k>>2]);m=n*(c[k>>2]=v,+g[k>>2]);m=m+q*(c[k>>2]=u,+g[k>>2]);m=m+p*(c[k>>2]=t,+g[k>>2]);n=n*(c[k>>2]=s,+g[k>>2]);q=n+q*(c[k>>2]=r,+g[k>>2]);n=+g[f+52>>2];l=+g[f+56>>2];j=+g[f+60>>2];j=q+p*(c[k>>2]=h,+g[k>>2])+j-j;g[d>>2]=o+n-n;g[d+4>>2]=m+l-l;g[d+8>>2]=j;g[d+12>>2]=0.0;h=c[a+28>>2]|0;f=c[a+32>>2]|0;Rg(a+48+(b*84|0)|0,d+80|0,d+32|0,d+16|0,d,d+128|0,h+396|0,+g[h+344>>2],f+396|0,+g[f+344>>2]);g[e>>2]=0.0;b=b+1|0}while((b|0)!=3);i=d;return}function Qe(a,b,d,e,f,h){a=a|0;b=b|0;d=+d;e=+e;f=+f;h=h|0;var i=0,j=0,k=0.0,l=0.0,m=0,n=0.0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0,y=0.0,z=0.0,A=0,B=0,C=0.0;a:while(1){B=c[h+12>>2]|0;if((b|0)>0){j=0;i=-1;do{do if(c[B+(j<<2)>>2]|0){if((i|0)!=-1?!(+g[a+(j<<4)>>2]*d+ +g[a+(j<<4)+4>>2]*e+ +g[a+(j<<4)+8>>2]*f>+g[a+(i<<4)>>2]*d+ +g[a+(i<<4)+4>>2]*e+ +g[a+(i<<4)+8>>2]*f):0)break;i=j}while(0);j=j+1|0}while((j|0)!=(b|0))}else i=-1;A=B+(i<<2)|0;if((c[A>>2]|0)==3){j=37;break}k=+O(+((e-f*0.0)*(e-f*0.0)+(f*0.0-d)*(f*0.0-d)+(d*0.0-e*0.0)*(d*0.0-e*0.0)));l=+O(+((d-e*0.0)*(d-e*0.0)+((e*0.0-f)*(e*0.0-f)+(f*0.0-d*0.0)*(f*0.0-d*0.0))));if(k>l){y=(e-f*0.0)*(1.0/k);z=(d*0.0-e*0.0)*(1.0/k);w=(f*0.0-d)*(1.0/k)}else{y=(e*0.0-f)*(1.0/l);z=(d-e*0.0)*(1.0/l);w=(f*0.0-d*0.0)*(1.0/l)}r=w*f-z*e;s=z*d-y*f;t=y*e-w*d;u=(i|0)==-1;j=-1;x=0;while(1){v=+(x|0);q=+R(+(v*.01745329238474369));n=+Q(+(v*.01745329238474369));k=(y*q+r*n)*.02500000037252903+d;l=(w*q+s*n)*.02500000037252903+e;n=(z*q+t*n)*.02500000037252903+f;if((b|0)>0){o=0;m=-1;do{do if(c[B+(o<<2)>>2]|0){if((m|0)!=-1?!(k*+g[a+(o<<4)>>2]+l*+g[a+(o<<4)+4>>2]+n*+g[a+(o<<4)+8>>2]>k*+g[a+(m<<4)>>2]+l*+g[a+(m<<4)+4>>2]+n*+g[a+(m<<4)+8>>2]):0)break;m=o}while(0);o=o+1|0}while((o|0)!=(b|0))}else m=-1;if((j|0)==(i|0)&(m|0)==(i|0)){j=20;break a}b:do if(!((j|0)==-1|(j|0)==(m|0))?v+-40.0<=v:0){if((b|0)>0)q=v+-40.0;else{k=v+-40.0;while(1){if((j|0)==(i|0)&u){i=-1;j=33;break a}k=k+5.0;if(!(k<=v))break b;else j=-1}}while(1){n=q*.01745329238474369;C=+R(+n);n=+Q(+n);k=(y*C+r*n)*.02500000037252903+d;l=(w*C+s*n)*.02500000037252903+e;n=(z*C+t*n)*.02500000037252903+f;p=0;o=-1;do{do if(c[B+(p<<2)>>2]|0){if((o|0)!=-1?!(k*+g[a+(p<<4)>>2]+l*+g[a+(p<<4)+4>>2]+n*+g[a+(p<<4)+8>>2]>k*+g[a+(o<<4)>>2]+l*+g[a+(o<<4)+4>>2]+n*+g[a+(o<<4)+8>>2]):0)break;o=p}while(0);p=p+1|0}while((p|0)!=(b|0));if((j|0)==(i|0)&(o|0)==(i|0)){j=33;break a}q=q+5.0;if(!(q<=v))break;else j=o}}while(0);x=x+45|0;if((x|0)>360)break;else j=m}c[A>>2]=0}if((j|0)==20){c[A>>2]=3;B=i;return B|0}else if((j|0)==33){c[B+(i<<2)>>2]=3;B=i;return B|0}else if((j|0)==37)return i|0;return 0}function Re(a,b,d,e,f,h,j,k){a=a|0;b=b|0;d=d|0;e=+e;f=+f;h=+h;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0;V=i;i=i+32|0;G=+g[d>>2];I=+g[d+4>>2];T=+g[d+8>>2];t=+g[j>>2];u=+g[j+4>>2];w=+g[j+8>>2];p=+g[k>>2];r=+g[k+4>>2];s=+g[k+8>>2];H=1.0/+O(+((e-G)*(e-G)+(f-I)*(f-I)+(h-T)*(h-T)));J=(e-G)*H==0.0?999999984306749440.0:1.0/((e-G)*H);K=(f-I)*H==0.0?999999984306749440.0:1.0/((f-I)*H);L=(h-T)*H==0.0?999999984306749440.0:1.0/((h-T)*H);M=(G>e?e:G)+t;N=(I>f?f:I)+u;P=(T>h?h:T)+w;Q=(G<e?e:G)+p;R=(I<f?f:I)+r;S=(T<h?h:T)+s;m=c[a+56>>2]|0;a:do if((m|0)>0){x=0;y=c[a+96>>2]|0;l=0;while(1){l=l+1|0;c[V>>2]=c[y>>2];c[V+4>>2]=c[y+4>>2];c[V+8>>2]=c[y+8>>2];c[V+12>>2]=c[y+12>>2];v=y+16|0;c[V+16>>2]=c[v>>2];c[V+16+4>>2]=c[v+4>>2];c[V+16+8>>2]=c[v+8>>2];c[V+16+12>>2]=c[v+12>>2];g[V>>2]=+g[V>>2]-p;g[V+4>>2]=+g[V+4>>2]-r;g[V+8>>2]=+g[V+8>>2]-s;g[V+16>>2]=+g[V+16>>2]-t;g[V+20>>2]=+g[V+20>>2]-u;g[V+24>>2]=+g[V+24>>2]-w;if(!(M>+g[v>>2])?!(Q<+g[y>>2]):0)n=1;else n=0;if(!(!(P>+g[y+24>>2])?!(S<+g[y+8>>2]):0))n=0;if(((!(N>+g[y+20>>2])?!(R<+g[y+4>>2]|n^1):0)?(A=+g[d>>2],z=J*(+g[V+((J<0.0&1)<<4)>>2]-A),A=J*(+g[V+((J<0.0^1)<<4)>>2]-A),C=+g[d+4>>2],B=K*(+g[V+((K<0.0&1)<<4)+4>>2]-C),C=K*(+g[V+((K<0.0^1)<<4)+4>>2]-C),!(B>A|z>C)):0)?(D=B>z?B:z,U=C<A?C:A,F=+g[d+8>>2],E=L*(+g[V+((L<0.0&1)<<4)+8>>2]-F),F=L*(+g[V+((L<0.0^1)<<4)+8>>2]-F),!(E>U|D>F)):0){n=(F<U?F:U)>0.0?(E>D?E:D)<(h-T)*(h-T)*H+((e-G)*(e-G)*H+(f-I)*(f-I)*H):0;o=c[y+32>>2]|0;if(n&(o|0)==-1){ic[c[(c[b>>2]|0)+8>>2]&127](b,c[y+36>>2]|0,c[y+40>>2]|0);m=c[a+56>>2]|0;v=17}else{q=(o|0)==-1;v=16}}else{o=c[y+32>>2]|0;n=0;q=(o|0)==-1;v=16}if((v|0)==16){v=0;if(q|n)v=17;else{q=o+x|0;n=y+(o<<6)|0}}if((v|0)==17){q=x+1|0;n=y+64|0}if((q|0)>=(m|0))break a;p=+g[k>>2];r=+g[k+4>>2];s=+g[k+8>>2];t=+g[j>>2];u=+g[j+4>>2];w=+g[j+8>>2];x=q;y=n}}else l=0;while(0);if((c[6167]|0)>=(l|0)){i=V;return}c[6167]=l;i=V;return}function Se(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;if(!(c[a+204>>2]&2)){c[a+68>>2]=c[b>>2];c[a+68+4>>2]=c[b+4>>2];c[a+68+8>>2]=c[b+8>>2];c[a+68+12>>2]=c[b+12>>2];c[a+84>>2]=c[b+16>>2];c[a+84+4>>2]=c[b+16+4>>2];c[a+84+8>>2]=c[b+16+8>>2];c[a+84+12>>2]=c[b+16+12>>2];c[a+100>>2]=c[b+32>>2];c[a+100+4>>2]=c[b+32+4>>2];c[a+100+8>>2]=c[b+32+8>>2];c[a+100+12>>2]=c[b+32+12>>2];c[a+116>>2]=c[b+48>>2];c[a+116+4>>2]=c[b+48+4>>2];c[a+116+8>>2]=c[b+48+8>>2];c[a+116+12>>2]=c[b+48+12>>2];d=a+20|0;e=b+16|0;f=a+36|0;h=b+32|0;i=a+52|0;j=b+48|0;k=a+4|0}else{c[a+68>>2]=c[a+4>>2];c[a+68+4>>2]=c[a+4+4>>2];c[a+68+8>>2]=c[a+4+8>>2];c[a+68+12>>2]=c[a+4+12>>2];c[a+84>>2]=c[a+20>>2];c[a+84+4>>2]=c[a+20+4>>2];c[a+84+8>>2]=c[a+20+8>>2];c[a+84+12>>2]=c[a+20+12>>2];c[a+100>>2]=c[a+36>>2];c[a+100+4>>2]=c[a+36+4>>2];c[a+100+8>>2]=c[a+36+8>>2];c[a+100+12>>2]=c[a+36+12>>2];c[a+116>>2]=c[a+52>>2];c[a+116+4>>2]=c[a+52+4>>2];c[a+116+8>>2]=c[a+52+8>>2];c[a+116+12>>2]=c[a+52+12>>2];d=a+20|0;e=b+16|0;f=a+36|0;h=b+32|0;i=a+52|0;j=b+48|0;k=a+4|0}c[a+132>>2]=c[a+312>>2];c[a+132+4>>2]=c[a+312+4>>2];c[a+132+8>>2]=c[a+312+8>>2];c[a+132+12>>2]=c[a+312+12>>2];c[a+148>>2]=c[a+328>>2];c[a+148+4>>2]=c[a+328+4>>2];c[a+148+8>>2]=c[a+328+8>>2];c[a+148+12>>2]=c[a+328+12>>2];c[k>>2]=c[b>>2];c[k+4>>2]=c[b+4>>2];c[k+8>>2]=c[b+8>>2];c[k+12>>2]=c[b+12>>2];c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];c[i>>2]=c[j>>2];c[i+4>>2]=c[j+4>>2];c[i+8>>2]=c[j+8>>2];c[i+12>>2]=c[j+12>>2];w=+g[a+4>>2];q=+g[a+396>>2];v=+g[a+8>>2];o=+g[a+400>>2];u=+g[a+12>>2];m=+g[a+404>>2];t=+g[a+20>>2];s=+g[a+24>>2];r=+g[a+28>>2];p=+g[a+36>>2];n=+g[a+40>>2];l=+g[a+44>>2];g[a+264>>2]=w*w*q+v*v*o+u*u*m;g[a+268>>2]=w*q*t+v*o*s+u*m*r;g[a+272>>2]=w*q*p+v*o*n+u*m*l;g[a+276>>2]=0.0;g[a+280>>2]=w*q*t+v*o*s+u*m*r;g[a+284>>2]=t*q*t+s*o*s+r*m*r;g[a+288>>2]=q*t*p+o*s*n+m*r*l;g[a+292>>2]=0.0;g[a+296>>2]=w*q*p+v*o*n+u*m*l;g[a+300>>2]=t*q*p+s*o*n+r*m*l;g[a+304>>2]=p*q*p+n*o*n+l*m*l;g[a+308>>2]=0.0;return}function Te(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;h=i;i=i+160|0;e=c[a+4>>2]|0;f=c[e+12>>2]|0;D=+g[f>>2];C=+g[f+4>>2];B=+g[f+8>>2];A=+g[f+16>>2];z=+g[f+20>>2];y=+g[f+24>>2];r=+g[f+32>>2];p=+g[f+36>>2];n=+g[f+40>>2];e=c[(c[e+4>>2]|0)+24>>2]|0;x=+g[e+(d*80|0)>>2];w=+g[e+(d*80|0)+16>>2];v=+g[e+(d*80|0)+32>>2];u=+g[e+(d*80|0)+4>>2];t=+g[e+(d*80|0)+20>>2];s=+g[e+(d*80|0)+36>>2];q=+g[e+(d*80|0)+8>>2];o=+g[e+(d*80|0)+24>>2];m=+g[e+(d*80|0)+40>>2];F=+g[e+(d*80|0)+48>>2];E=+g[e+(d*80|0)+52>>2];j=+g[e+(d*80|0)+56>>2];l=+g[f+48>>2]+(D*F+C*E+B*j);k=+g[f+52>>2]+(A*F+z*E+y*j);j=+g[f+56>>2]+(r*F+p*E+n*j);g[h+88>>2]=D*x+C*w+B*v;g[h+88+4>>2]=D*u+C*t+B*s;g[h+88+8>>2]=D*q+C*o+B*m;g[h+88+12>>2]=0.0;g[h+88+16>>2]=A*x+z*w+y*v;g[h+88+20>>2]=A*u+z*t+y*s;g[h+88+24>>2]=A*q+z*o+y*m;g[h+88+28>>2]=0.0;g[h+88+32>>2]=r*x+p*w+n*v;g[h+88+36>>2]=r*u+p*t+n*s;g[h+88+40>>2]=r*q+p*o+n*m;g[h+88+44>>2]=0.0;g[h+88+48>>2]=l;g[h+88+52>>2]=k;g[h+88+56>>2]=j;g[h+88+60>>2]=0.0;mc[c[(c[b>>2]|0)+8>>2]&127](b,h+88|0,h+72|0,h+56|0);f=c[a+8>>2]|0;e=c[f+4>>2]|0;mc[c[(c[e>>2]|0)+8>>2]&127](e,c[f+12>>2]|0,h+40|0,h+24|0);if(!(+g[h+72>>2]>+g[h+24>>2])?!(+g[h+56>>2]<+g[h+40>>2]):0)e=1;else e=0;if(!(!(+g[h+72+8>>2]>+g[h+24+8>>2])?!(+g[h+56+8>>2]<+g[h+40+8>>2]):0))e=0;if(+g[h+72+4>>2]>+g[h+24+4>>2]){i=h;return}if(+g[h+56+4>>2]<+g[h+40+4>>2]|e^1){i=h;return}e=c[a+4>>2]|0;f=c[e+8>>2]|0;c[h>>2]=e;c[h+4>>2]=b;c[h+8>>2]=f;c[h+12>>2]=h+88;c[h+16>>2]=-1;c[h+20>>2]=d;if(!(c[(c[a+24>>2]|0)+(d<<2)>>2]|0)){e=c[a+12>>2]|0;e=Ib[c[(c[e>>2]|0)+8>>2]&31](e,h,c[a+8>>2]|0,c[a+28>>2]|0)|0;c[(c[a+24>>2]|0)+(d<<2)>>2]=e;e=c[a+4>>2]|0}f=c[a+20>>2]|0;b=c[f+8>>2]|0;if((c[b+8>>2]|0)==(c[e+8>>2]|0)){c[f+8>>2]=h;ic[c[(c[f>>2]|0)+8>>2]&127](f,-1,d)}else{b=c[f+12>>2]|0;c[f+12>>2]=h;ic[c[(c[f>>2]|0)+12>>2]&127](f,-1,d)}e=c[(c[a+24>>2]|0)+(d<<2)>>2]|0;yb[c[(c[e>>2]|0)+8>>2]&31](e,h,c[a+8>>2]|0,c[a+16>>2]|0,c[a+20>>2]|0);e=c[a+20>>2]|0;if((c[(c[e+8>>2]|0)+8>>2]|0)==(c[(c[a+4>>2]|0)+8>>2]|0))c[e+8>>2]=b;else c[e+12>>2]=b;i=h;return}function Ue(){if(a[22576]|0)return;if(!(Wa(22576)|0))return;c[6168]=0;c[6169]=-2147483648;c[6170]=-1082130432;g[6171]=0.0;c[6172]=1060716128;c[6173]=-1090087446;c[6174]=-1092290076;g[6175]=0.0;c[6176]=-1098022214;c[6177]=-1084636126;c[6178]=-1092290076;g[6179]=0.0;c[6180]=-1083901670;c[6181]=-2147483648;c[6182]=-1092290177;g[6183]=0.0;c[6184]=-1098022214;c[6185]=1062847522;c[6186]=-1092290043;g[6187]=0.0;c[6188]=1060716128;c[6189]=1057396202;c[6190]=-1092290076;g[6191]=0.0;c[6192]=1049461434;c[6193]=-1084636126;c[6194]=1055193605;g[6195]=0.0;c[6196]=-1086767520;c[6197]=-1090087446;c[6198]=1055193572;g[6199]=0.0;c[6200]=-1086767520;c[6201]=1057396202;c[6202]=1055193572;g[6203]=0.0;c[6204]=1049461434;c[6205]=1062847522;c[6206]=1055193572;g[6207]=0.0;c[6208]=1063581978;c[6209]=0;c[6210]=1055193471;g[6211]=0.0;c[6212]=-2147483648;c[6213]=0;c[6214]=1065353216;g[6215]=0.0;c[6216]=1054458864;c[6217]=-1096927567;c[6218]=-1084636042;g[6219]=0.0;c[6220]=-1104782626;c[6221]=-1090519208;c[6222]=-1084636042;g[6223]=0.0;c[6224]=1049007812;c[6225]=-1085334679;c[6226]=-1090087228;g[6227]=0.0;c[6228]=1054458864;c[6229]=1050556081;c[6230]=-1084636042;g[6231]=0.0;c[6232]=1062847505;c[6233]=-2147483648;c[6234]=-1090087262;g[6235]=0.0;c[6236]=-1090087362;c[6237]=-2147483648;c[6238]=-1084636076;g[6239]=0.0;c[6240]=-1087361736;c[6241]=-1090519141;c[6242]=-1090087262;g[6243]=0.0;c[6244]=-1104782626;c[6245]=1056964440;c[6246]=-1084636042;g[6247]=0.0;c[6248]=-1087361736;c[6249]=1056964507;c[6250]=-1090087262;g[6251]=0.0;c[6252]=1049007812;c[6253]=1062148969;c[6254]=-1090087228;g[6255]=0.0;c[6256]=1064532105;c[6257]=1050556148;c[6258]=0;g[6259]=0.0;c[6260]=1064532105;c[6261]=-1096927500;c[6262]=0;g[6263]=0.0;c[6264]=1058437413;c[6265]=-1085334595;c[6266]=0;g[6267]=0.0;c[6268]=0;c[6269]=-1082130432;c[6270]=0;g[6271]=0.0;c[6272]=-1089046235;c[6273]=-1085334595;c[6274]=0;g[6275]=0.0;c[6276]=-1082951543;c[6277]=-1096927500;c[6278]=-2147483648;g[6279]=0.0;c[6280]=-1082951543;c[6281]=1050556148;c[6282]=-2147483648;g[6283]=0.0;c[6284]=-1089046235;c[6285]=1062149053;c[6286]=-2147483648;g[6287]=0.0;c[6288]=-2147483648;c[6289]=1065353216;c[6290]=-2147483648;g[6291]=0.0;c[6292]=1058437413;c[6293]=1062149053;c[6294]=-2147483648;g[6295]=0.0;c[6296]=1060121912;c[6297]=-1090519141;c[6298]=1057396386;g[6299]=0.0;c[6300]=-1098475836;c[6301]=-1085334679;c[6302]=1057396420;g[6303]=0.0;c[6304]=-1084636143;c[6305]=0;c[6306]=1057396386;g[6307]=0.0;c[6308]=-1098475836;c[6309]=1062148969;c[6310]=1057396420;g[6311]=0.0;c[6312]=1060121912;c[6313]=1056964507;c[6314]=1057396386;g[6315]=0.0;c[6316]=1057396286;c[6317]=0;c[6318]=1062847572;g[6319]=0.0;c[6320]=1042701022;c[6321]=-1090519208;c[6322]=1062847606;g[6323]=0.0;c[6324]=-1093024784;c[6325]=-1096927567;c[6326]=1062847606;g[6327]=0.0;c[6328]=-1093024784;c[6329]=1050556081;c[6330]=1062847606;g[6331]=0.0;c[6332]=1042701022;c[6333]=1056964440;c[6334]=1062847606;g[6335]=0.0;_a(22576);return}function Ve(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;u=a[h+16>>0]&-16;a[h+16>>0]=u;w=+g[e>>2];x=+g[d>>2];y=+g[e+4>>2];z=+g[d+4>>2];q=+g[e+8>>2];r=+g[d+8>>2];s=+g[f>>2];t=+g[f+4>>2];v=+g[f+8>>2];m=+g[b>>2];n=+g[b+4>>2];i=+g[b+8>>2];o=(w-x)*(m-x)+(y-z)*(n-z)+(q-r)*(i-r);p=(s-x)*(m-x)+(t-z)*(n-z)+(v-r)*(i-r);if(o<=0.0&p<=0.0){c[h>>2]=c[d>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];c[h+12>>2]=c[d+12>>2];a[h+16>>0]=u|1;g[h+20>>2]=1.0;g[h+24>>2]=0.0;g[h+28>>2]=0.0;g[h+32>>2]=0.0;return}k=(w-x)*(m-w)+(y-z)*(n-y)+(q-r)*(i-q);l=(s-x)*(m-w)+(t-z)*(n-y)+(v-r)*(i-q);if(!(!(k>=0.0)|!(l<=k))){c[h>>2]=c[e>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];a[h+16>>0]=u|2;g[h+20>>2]=0.0;g[h+24>>2]=1.0;g[h+28>>2]=0.0;g[h+32>>2]=0.0;return}if(k<=0.0&(o>=0.0?o*l-k*p<=0.0:0)){g[h>>2]=x+(w-x)*(o/(o-k));g[h+4>>2]=z+(y-z)*(o/(o-k));g[h+8>>2]=r+(q-r)*(o/(o-k));g[h+12>>2]=0.0;a[h+16>>0]=u|3;g[h+20>>2]=1.0-o/(o-k);g[h+24>>2]=o/(o-k);g[h+28>>2]=0.0;g[h+32>>2]=0.0;return}j=(w-x)*(m-s)+(y-z)*(n-t)+(q-r)*(i-v);i=(s-x)*(m-s)+(t-z)*(n-t)+(v-r)*(i-v);if(!(!(i>=0.0)|!(j<=i))){c[h>>2]=c[f>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];a[h+16>>0]=u|4;g[h+20>>2]=0.0;g[h+24>>2]=0.0;g[h+28>>2]=1.0;g[h+32>>2]=0.0;return}if(i<=0.0&(p>=0.0?j*p-o*i<=0.0:0)){g[h>>2]=x+(s-x)*(p/(p-i));g[h+4>>2]=z+(t-z)*(p/(p-i));g[h+8>>2]=r+(v-r)*(p/(p-i));g[h+12>>2]=0.0;a[h+16>>0]=u|5;g[h+20>>2]=1.0-p/(p-i);g[h+24>>2]=0.0;g[h+28>>2]=p/(p-i);g[h+32>>2]=0.0;return}if((k*i-j*l<=0.0?l-k>=0.0:0)?j-i>=0.0:0){z=(l-k)/(l-k+(j-i));g[h>>2]=w+(s-w)*z;g[h+4>>2]=y+(t-y)*z;g[h+8>>2]=q+(v-q)*z;g[h+12>>2]=0.0;a[h+16>>0]=u|6;g[h+20>>2]=0.0;g[h+24>>2]=1.0-z;g[h+28>>2]=z;g[h+32>>2]=0.0;return}m=1.0/(o*l-k*p+(k*i-j*l+(j*p-o*i)));n=(j*p-o*i)*m;p=(o*l-k*p)*m;g[h>>2]=(s-x)*p+((w-x)*n+x);g[h+4>>2]=(t-z)*p+((y-z)*n+z);g[h+8>>2]=(v-r)*p+((q-r)*n+r);g[h+12>>2]=0.0;a[h+16>>0]=u|7;g[h+20>>2]=1.0-n-p;g[h+24>>2]=n;g[h+28>>2]=p;g[h+32>>2]=0.0;return}function We(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;if(!((a|0)!=0&(b|0)!=0))return;c[6435]=(c[6435]|0)+1;e=yc(1043)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}c[e>>2]=a;c[e+4>>2]=b;n=1;b=128;h=128;i=e;f=124;while(1){e=n+-1|0;l=c[i+(e<<3)>>2]|0;m=c[i+(e<<3)+4>>2]|0;if((e|0)>(f|0)){f=h<<1;do if((h|0)<(f|0)&(b|0)<(f|0)){if(h){c[6435]=(c[6435]|0)+1;a=yc((h<<4|3)+16|0)|0;if(!a)a=0;else{c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}if((h|0)>0){b=0;do{p=i+(b<<3)|0;j=c[p+4>>2]|0;k=a+(b<<3)|0;c[k>>2]=c[p>>2];c[k+4>>2]=j;b=b+1|0}while((b|0)!=(h|0))}else o=12}else{a=0;o=12}if((o|0)==12){o=0;if(!i){b=f;break}}c[6436]=(c[6436]|0)+1;hd(c[i+-4>>2]|0);b=f}else a=i;while(0);k=f;j=f+-4|0}else{k=h;a=i;j=f}do if((l|0)==(m|0)){if(c[l+40>>2]|0){p=c[l+36>>2]|0;c[a+(e<<3)>>2]=p;c[a+(e<<3)+4>>2]=p;e=n+1|0;p=c[l+40>>2]|0;c[a+(n<<3)>>2]=p;c[a+(n<<3)+4>>2]=p;p=c[l+40>>2]|0;c[a+(e<<3)>>2]=c[l+36>>2];c[a+(e<<3)+4>>2]=p;e=n+2|0}}else if(((((+g[l>>2]<=+g[m+16>>2]?+g[l+16>>2]>=+g[m>>2]:0)?+g[l+4>>2]<=+g[m+20>>2]:0)?+g[l+20>>2]>=+g[m+4>>2]:0)?+g[l+8>>2]<=+g[m+24>>2]:0)?+g[l+24>>2]>=+g[m+8>>2]:0){f=(c[m+40>>2]|0)!=0;if(!(c[l+40>>2]|0))if(f){p=c[m+36>>2]|0;c[a+(e<<3)>>2]=l;c[a+(e<<3)+4>>2]=p;e=c[m+40>>2]|0;c[a+(n<<3)>>2]=l;c[a+(n<<3)+4>>2]=e;e=n+1|0;break}else{ic[c[(c[d>>2]|0)+8>>2]&127](d,l,m);break}else{h=a+(e<<3)|0;i=c[l+36>>2]|0;if(f){p=c[m+36>>2]|0;c[h>>2]=i;c[a+(e<<3)+4>>2]=p;p=n+1|0;e=c[m+36>>2]|0;c[a+(n<<3)>>2]=c[l+40>>2];c[a+(n<<3)+4>>2]=e;e=n+2|0;i=c[m+40>>2]|0;c[a+(p<<3)>>2]=c[l+36>>2];c[a+(p<<3)+4>>2]=i;p=c[m+40>>2]|0;c[a+(e<<3)>>2]=c[l+40>>2];c[a+(e<<3)+4>>2]=p;e=n+3|0;break}else{c[h>>2]=i;c[a+(e<<3)+4>>2]=m;c[a+(n<<3)>>2]=c[l+40>>2];c[a+(n<<3)+4>>2]=m;e=n+1|0;break}}}while(0);if(!e)break;else{n=e;h=k;i=a;f=j}}if(!a)return;c[6436]=(c[6436]|0)+1;hd(c[a+-4>>2]|0);return}function Xe(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0,o=0;n=c[a+192>>2]|0;m=+Sb[c[(c[n>>2]|0)+48>>2]&15](n);n=c[a+712>>2]|0;if((n|0)>0){o=0;do{l=c[a+720>>2]|0;d=l+(o*104|0)+8|0;i=+g[b>>2]*+g[d>>2];g[d>>2]=i;d=l+(o*104|0)+12|0;j=+g[b+4>>2]*+g[d>>2];g[d>>2]=j;d=l+(o*104|0)+16|0;k=+g[b+8>>2]*+g[d>>2];g[d>>2]=k;d=l+(o*104|0)+24|0;g[d>>2]=+g[b>>2]*+g[d>>2];d=l+(o*104|0)+28|0;g[d>>2]=+g[b+4>>2]*+g[d>>2];d=l+(o*104|0)+32|0;g[d>>2]=+g[b+8>>2]*+g[d>>2];l=c[l+(o*104|0)+96>>2]|0;d=hh(a+928|0,l)|0;a:do if(d){f=c[a+936>>2]|0;if((f|0)<=-1){d=c[a+928>>2]|0;break}if((f|0)>0){h=0;while(1){e=c[d+32>>2]|0;h=h+1|0;if(!e)break a;if((h|0)>=(f|0)){d=e;break}else d=e}}}else d=0;while(0);g[l>>2]=i-m;g[l+4>>2]=j-m;g[l+8>>2]=k-m;g[l+12>>2]=0.0;g[l+16>>2]=m+i;g[l+20>>2]=m+j;g[l+24>>2]=m+k;g[l+28>>2]=0.0;lf(a+928|0,d,l);o=o+1|0}while((o|0)!=(n|0))}Bg(a);d=c[a+928>>2]|0;if(d){o=c[a+192>>2]|0;j=+Sb[c[(c[o>>2]|0)+48>>2]&15](o);m=+g[d+4>>2]-j;k=+g[d+8>>2]-j;g[a+892>>2]=+g[d>>2]-j;g[a+896>>2]=m;g[a+900>>2]=k;g[a+904>>2]=0.0;k=j+ +g[d+20>>2];m=j+ +g[d+24>>2];g[a+908>>2]=j+ +g[d+16>>2];g[a+912>>2]=k;g[a+916>>2]=m;g[a+920>>2]=0.0;d=c[a+188>>2]|0;if(d|0){o=c[a+684>>2]|0;b=c[o+32>>2]|0;yb[c[(c[b>>2]|0)+16>>2]&31](b,d,a+892|0,a+908|0,c[o+36>>2]|0)}}else{c[a+892>>2]=0;c[a+892+4>>2]=0;c[a+892+8>>2]=0;c[a+892+12>>2]=0;c[a+892+16>>2]=0;c[a+892+20>>2]=0;c[a+892+24>>2]=0;c[a+892+28>>2]=0}f=c[a+732>>2]|0;if((f|0)<=0){eg(a);return}d=c[a+740>>2]|0;e=0;do{b=c[d+(e*52|0)+8>>2]|0;o=c[d+(e*52|0)+12>>2]|0;j=+g[b+8>>2]-+g[o+8>>2];k=+g[b+12>>2]-+g[o+12>>2];m=+g[b+16>>2]-+g[o+16>>2];m=+O(+(j*j+k*k+m*m));g[d+(e*52|0)+16>>2]=m;g[d+(e*52|0)+28>>2]=m*m;e=e+1|0}while((e|0)!=(f|0));d=c[a+740>>2]|0;e=0;do{g[d+(e*52|0)+24>>2]=(+g[(c[d+(e*52|0)+8>>2]|0)+88>>2]+ +g[(c[d+(e*52|0)+12>>2]|0)+88>>2])/+g[(c[d+(e*52|0)+4>>2]|0)+4>>2];e=e+1|0}while((e|0)!=(f|0));eg(a);return}function Ye(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0,x=0.0,y=0,z=0;w=i;i=i+192|0;u=c[(c[b+4>>2]|0)+740>>2]|0;v=c[(c[b+8>>2]|0)+8>>2]|0;o=+g[e>>2];r=+g[d>>2]*f+o;h=+g[e+4>>2];s=+g[d+4>>2]*f+h;j=+g[e+8>>2];t=+g[d+8>>2]*f+j;p=c[(c[b+12>>2]|0)+8>>2]|0;q=+g[p+52>>2];if((u|0)!=(v|0)){m=s-+g[p+56>>2];l=t-+g[p+60>>2];x=o-+g[v+52>>2];o=h-+g[v+56>>2];h=j-+g[v+60>>2];j=(r-q)*+g[p+4>>2]+m*+g[p+20>>2]+l*+g[p+36>>2];k=(r-q)*+g[p+8>>2]+m*+g[p+24>>2]+l*+g[p+40>>2];l=(r-q)*+g[p+12>>2]+m*+g[p+28>>2]+l*+g[p+44>>2];m=x*+g[v+4>>2]+o*+g[v+20>>2]+h*+g[v+36>>2];n=x*+g[v+8>>2]+o*+g[v+24>>2]+h*+g[v+40>>2];h=x*+g[v+12>>2]+o*+g[v+28>>2]+h*+g[v+44>>2]}else{n=r-+g[u+52>>2];m=s-+g[u+56>>2];l=t-+g[u+60>>2];x=h-+g[p+56>>2];h=j-+g[p+60>>2];j=n*+g[u+4>>2]+m*+g[u+20>>2]+l*+g[u+36>>2];k=n*+g[u+8>>2]+m*+g[u+24>>2]+l*+g[u+40>>2];l=n*+g[u+12>>2]+m*+g[u+28>>2]+l*+g[u+44>>2];m=(o-q)*+g[p+4>>2]+x*+g[p+20>>2]+h*+g[p+36>>2];n=(o-q)*+g[p+8>>2]+x*+g[p+24>>2]+h*+g[p+40>>2];h=(o-q)*+g[p+12>>2]+x*+g[p+28>>2]+h*+g[p+44>>2]}g[w>>2]=j;g[w+4>>2]=k;g[w+8>>2]=l;g[w+12>>2]=0.0;g[w+16>>2]=m;g[w+20>>2]=n;g[w+24>>2]=h;g[w+28>>2]=0.0;c[w+64>>2]=c[d>>2];c[w+64+4>>2]=c[d+4>>2];c[w+64+8>>2]=c[d+8>>2];c[w+64+12>>2]=c[d+12>>2];g[w+80>>2]=f;g[w+84>>2]=0.0;g[w+88>>2]=0.0;g[w+92>>2]=0.0;c[w+112>>2]=0;a[w+116>>0]=0;c[w+120>>2]=0;c[w+120+4>>2]=0;c[w+120+8>>2]=0;c[w+120+12>>2]=0;c[w+120+16>>2]=0;c[w+120+20>>2]=0;c[w+120+24>>2]=0;c[w+120+28>>2]=0;g[w+48>>2]=r;g[w+52>>2]=s;g[w+56>>2]=t;g[w+60>>2]=0.0;c[w+32>>2]=c[e>>2];c[w+32+4>>2]=c[e+4>>2];c[w+32+8>>2]=c[e+8>>2];c[w+32+12>>2]=c[e+12>>2];d=c[b+20>>2]|0;p=c[b+16>>2]|0;e=c[b+28>>2]|0;z=c[b+24>>2]|0;y=(u|0)!=(v|0)?d:p;d=(u|0)!=(v|0)?p:d;p=(u|0)!=(v|0)?e:z;e=(u|0)!=(v|0)?z:e;c[w+96>>2]=y;c[w+100>>2]=d;c[w+104>>2]=p;c[w+108>>2]=e;z=c[b+32>>2]|0;+Kb[c[(c[z>>2]|0)+12>>2]&1](z,w,c[((u|0)!=(v|0)?b+12|0:b+8|0)>>2]|0,y,p,c[((u|0)!=(v|0)?b+8|0:b+12|0)>>2]|0,d,e);i=w;return}function Ze(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0;h=i;i=i+48|0;c[b+8>>2]=0;g[b+12>>2]=0.0;c[b>>2]=6924;c[b+48>>2]=d;c[b+4>>2]=21;if(Eb[c[(c[d>>2]|0)+40>>2]&127](d)|0)ic[c[(c[d>>2]|0)+48>>2]&127](d,b+16|0,b+32|0);else{c[h+32>>2]=0;c[h+32+4>>2]=0;c[h+32+8>>2]=0;c[h+32+12>>2]=0;g[h+32>>2]=1.0;ic[c[(c[b>>2]|0)+68>>2]&127](h+16|0,b,h+32|0);g[b+32>>2]=+g[h+16>>2]+ +g[b+12>>2];g[h+32>>2]=-1.0;ic[c[(c[b>>2]|0)+68>>2]&127](h,b,h+32|0);c[h+16>>2]=c[h>>2];c[h+16+4>>2]=c[h+4>>2];c[h+16+8>>2]=c[h+8>>2];c[h+16+12>>2]=c[h+12>>2];g[b+16>>2]=+g[h+16>>2]-+g[b+12>>2];c[h+32>>2]=0;c[h+32+4>>2]=0;c[h+32+8>>2]=0;c[h+32+12>>2]=0;g[h+32+4>>2]=1.0;ic[c[(c[b>>2]|0)+68>>2]&127](h+16|0,b,h+32|0);g[b+36>>2]=+g[h+16+4>>2]+ +g[b+12>>2];g[h+32+4>>2]=-1.0;ic[c[(c[b>>2]|0)+68>>2]&127](h,b,h+32|0);c[h+16>>2]=c[h>>2];c[h+16+4>>2]=c[h+4>>2];c[h+16+8>>2]=c[h+8>>2];c[h+16+12>>2]=c[h+12>>2];g[b+20>>2]=+g[h+16+4>>2]-+g[b+12>>2];c[h+32>>2]=0;c[h+32+4>>2]=0;c[h+32+8>>2]=0;c[h+32+12>>2]=0;g[h+32+8>>2]=1.0;ic[c[(c[b>>2]|0)+68>>2]&127](h+16|0,b,h+32|0);g[b+40>>2]=+g[h+16+8>>2]+ +g[b+12>>2];g[h+32+8>>2]=-1.0;ic[c[(c[b>>2]|0)+68>>2]&127](h,b,h+32|0);c[h+16>>2]=c[h>>2];c[h+16+4>>2]=c[h+4>>2];c[h+16+8>>2]=c[h+8>>2];c[h+16+12>>2]=c[h+12>>2];g[b+24>>2]=+g[h+16+8>>2]-+g[b+12>>2]}c[b>>2]=6772;c[b+52>>2]=0;c[b+56>>2]=0;a[b+60>>0]=e&1;a[b+61>>0]=0;c[b+4>>2]=21;if(!f){i=h;return}c[6435]=(c[6435]|0)+1;f=yc(191)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}c[f+52>>2]=282;a[f+60>>0]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;c[f+144>>2]=0;a[f+164>>0]=1;c[f+160>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+168>>2]=0;c[f+4>>2]=-8388609;c[f+8>>2]=-8388609;c[f+12>>2]=-8388609;g[f+16>>2]=0.0;c[f+20>>2]=2139095039;c[f+24>>2]=2139095039;c[f+28>>2]=2139095039;g[f+32>>2]=0.0;c[f>>2]=7980;c[b+52>>2]=f;pd(f,c[b+48>>2]|0,(a[b+60>>0]|0)!=0,b+16|0,b+32|0);a[b+61>>0]=1;i=h;return}function _e(a,b){a=a|0;b=b|0;var d=0,e=0.0,f=0,h=0,i=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;d=c[a+748>>2]|0;if((d|0)!=4){c[a+748>>2]=d+1;x=d;w=(x|0)<0;x=w?0:x;a=a+4+(x*184|0)|0;_m(a|0,b|0,184)|0;return x|0}y=+g[b+80>>2];v=+g[a+84>>2];u=v<y?v:y;t=+g[a+268>>2];s=t<u?t:u;r=+g[a+452>>2];w=+g[a+636>>2]<(r<s?r:s);d=w?3:r<s?2:t<u?1:(v<y^1)<<31>>31;y=+g[b>>2];if(d){e=+g[a+188>>2];i=+g[b+4>>2];l=+g[a+192>>2];m=+g[b+8>>2];n=+g[a+196>>2];p=+g[a+556>>2];s=+g[a+372>>2];q=+g[a+560>>2];r=+g[a+376>>2];v=+g[a+564>>2];j=+g[a+380>>2];h=(g[k>>2]=((y-e)*(q-r)-(i-l)*(p-s))*((y-e)*(q-r)-(i-l)*(p-s))+(((i-l)*(v-j)-(m-n)*(q-r))*((i-l)*(v-j)-(m-n)*(q-r))+((m-n)*(p-s)-(y-e)*(v-j))*((m-n)*(p-s)-(y-e)*(v-j))),c[k>>2]|0);if((d|0)==1){o=+g[a+12>>2];t=p;u=q;p=+g[a+4>>2];q=+g[a+8>>2];f=0;x=7}else{t=p;u=q;x=6}}else{e=+g[a+188>>2];l=+g[a+192>>2];n=+g[a+196>>2];i=+g[b+4>>2];m=+g[b+8>>2];s=+g[a+372>>2];t=+g[a+556>>2];r=+g[a+376>>2];u=+g[a+560>>2];j=+g[a+380>>2];v=+g[a+564>>2];h=0;x=6}if((x|0)==6){p=+g[a+4>>2];q=+g[a+8>>2];D=i-q;o=+g[a+12>>2];B=m-o;A=t-s;C=u-r;z=v-j;f=(g[k>>2]=((y-p)*C-D*A)*((y-p)*C-D*A)+((D*z-B*C)*(D*z-B*C)+(B*A-(y-p)*z)*(B*A-(y-p)*z)),c[k>>2]|0);if((d|0)==2){d=0;x=8}else x=7}if((x|0)==7){C=y-p;E=i-q;A=m-o;B=t-e;z=u-l;D=v-n;d=(g[k>>2]=(C*z-E*B)*(C*z-E*B)+((E*D-A*z)*(E*D-A*z)+(A*B-C*D)*(A*B-C*D)),c[k>>2]|0);if(w)e=0.0;else x=8}if((x|0)==8){E=y-p;A=i-q;C=m-o;D=s-e;B=r-l;e=j-n;e=(E*B-A*D)*(E*B-A*D)+((A*e-C*B)*(A*e-C*B)+(C*D-E*e)*(C*D-E*e))}E=+N(+(c[k>>2]=h,+g[k>>2]));C=+N(+(c[k>>2]=f,+g[k>>2]));A=+N(+(c[k>>2]=d,+g[k>>2]));z=+N(+e);D=E>-999999984306749440.0?E:-999999984306749440.0;B=C>D?C:D;x=z>(A>B?A:B)?3:A>B?2:C>D?1:(E>-999999984306749440.0^1)<<31>>31;w=(x|0)<0;x=w?0:x;a=a+4+(x*184|0)|0;_m(a|0,b|0,184)|0;return x|0}function $e(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;if(!b)if(!e){if(f|0){c[f>>2]=(a>>>0)%(d>>>0);c[f+4>>2]=0}e=0;f=(a>>>0)/(d>>>0)>>>0;return (C=e,f)|0}else{if(!f){e=0;f=0;return (C=e,f)|0}c[f>>2]=a|0;c[f+4>>2]=b&0;e=0;f=0;return (C=e,f)|0}do if(d){if(e|0){h=(aa(e|0)|0)-(aa(b|0)|0)|0;if(h>>>0<=31){n=h+1|0;i=a>>>((h+1|0)>>>0)&h-31>>31|b<<31-h;m=b>>>((h+1|0)>>>0)&h-31>>31;g=0;h=a<<31-h;break}if(!f){e=0;f=0;return (C=e,f)|0}c[f>>2]=a|0;c[f+4>>2]=b|b&0;e=0;f=0;return (C=e,f)|0}if(d-1&d|0){h=(aa(d|0)|0)+33-(aa(b|0)|0)|0;n=h;i=32-h-1>>31&b>>>((h-32|0)>>>0)|(b<<32-h|a>>>(h>>>0))&h-32>>31;m=h-32>>31&b>>>(h>>>0);g=a<<64-h&32-h>>31;h=(b<<64-h|a>>>((h-32|0)>>>0))&32-h>>31|a<<32-h&h-33>>31;break}if(f|0){c[f>>2]=d-1&a;c[f+4>>2]=0}if((d|0)==1){e=b|b&0;f=a|0|0;return (C=e,f)|0}else{f=Sp(d|0)|0;e=b>>>(f>>>0)|0;f=b<<32-f|a>>>(f>>>0)|0;return (C=e,f)|0}}else{if(!e){if(f|0){c[f>>2]=(b>>>0)%(d>>>0);c[f+4>>2]=0}e=0;f=(b>>>0)/(d>>>0)>>>0;return (C=e,f)|0}if(!a){if(f|0){c[f>>2]=0;c[f+4>>2]=(b>>>0)%(e>>>0)}d=0;f=(b>>>0)/(e>>>0)>>>0;return (C=d,f)|0}if(!(e-1&e)){if(f|0){c[f>>2]=a|0;c[f+4>>2]=e-1&b|b&0}d=0;f=b>>>((Sp(e|0)|0)>>>0);return (C=d,f)|0}h=(aa(e|0)|0)-(aa(b|0)|0)|0;if(h>>>0<=30){n=h+1|0;i=b<<31-h|a>>>((h+1|0)>>>0);m=b>>>((h+1|0)>>>0);g=0;h=a<<31-h;break}if(!f){e=0;f=0;return (C=e,f)|0}c[f>>2]=a|0;c[f+4>>2]=b|b&0;e=0;f=0;return (C=e,f)|0}while(0);if(!n){j=h;b=m;a=0;h=0}else{k=Kt(d|0|0,e|e&0|0,-1,-1)|0;l=C;j=h;b=m;a=n;h=0;do{p=j;j=g>>>31|j<<1;g=h|g<<1;p=i<<1|p>>>31|0;o=i>>>31|b<<1|0;Is(k|0,l|0,p|0,o|0)|0;n=C;m=n>>31|((n|0)<0?-1:0)<<1;h=m&1;i=Is(p|0,o|0,m&(d|0)|0,(((n|0)<0?-1:0)>>31|((n|0)<0?-1:0)<<1)&(e|e&0)|0)|0;b=C;a=a-1|0}while((a|0)!=0);a=0}if(f|0){c[f>>2]=i;c[f+4>>2]=b}o=(g|0)>>>31|j<<1|(0<<1|g>>>31)&0|a;p=(g<<1|0>>>31)&-2|h;return (C=o,p)|0}function af(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;l=i;i=i+128|0;a=c[a+16>>2]|0;n=+g[a+892>>2];x=+g[a+896>>2];v=+g[a+900>>2];w=+g[a+908>>2];f=+g[a+912>>2];j=+g[a+916>>2];z=+g[b>>2];m=+g[b+4>>2];p=v*+g[b+8>>2];q=+g[b+16>>2];r=+g[b+20>>2];t=v*+g[b+24>>2];u=+g[b+32>>2];o=+g[b+36>>2];s=+g[b+40>>2];y=+g[b+48>>2];k=+g[b+52>>2];h=+g[b+56>>2];g[l>>2]=n*z+x*m+p+y;g[l+4>>2]=n*q+x*r+t+k;g[l+8>>2]=n*u+x*o+v*s+h;g[l+12>>2]=0.0;g[l+16>>2]=w*z+x*m+p+y;g[l+20>>2]=w*q+x*r+t+k;g[l+24>>2]=w*u+x*o+v*s+h;g[l+28>>2]=0.0;g[l+32>>2]=w*z+f*m+p+y;g[l+36>>2]=w*q+f*r+t+k;g[l+40>>2]=w*u+f*o+v*s+h;g[l+44>>2]=0.0;g[l+48>>2]=n*z+f*m+p+y;g[l+52>>2]=n*q+f*r+t+k;g[l+56>>2]=n*u+f*o+v*s+h;g[l+60>>2]=0.0;v=+g[b>>2];u=+g[b+4>>2];t=j*+g[b+8>>2];r=+g[b+16>>2];q=+g[b+20>>2];p=j*+g[b+24>>2];m=+g[b+32>>2];g[l+64>>2]=n*v+x*u+t+y;g[l+68>>2]=n*r+x*q+p+k;g[l+72>>2]=n*m+x*o+j*s+h;g[l+76>>2]=0.0;h=+g[b+36>>2];j=j*+g[b+40>>2];s=+g[b+48>>2];o=+g[b+52>>2];k=+g[b+56>>2];g[l+80>>2]=w*v+x*u+t+s;g[l+84>>2]=w*r+x*q+p+o;g[l+88>>2]=w*m+x*h+j+k;g[l+92>>2]=0.0;g[l+96>>2]=w*v+f*u+t+s;g[l+100>>2]=w*r+f*q+p+o;g[l+104>>2]=w*m+f*h+j+k;g[l+108>>2]=0.0;g[l+112>>2]=n*v+f*u+t+s;g[l+116>>2]=n*r+f*q+p+o;g[l+120>>2]=n*m+f*h+j+k;g[l+124>>2]=0.0;c[e>>2]=c[l>>2];c[e+4>>2]=c[l+4>>2];c[e+8>>2]=c[l+8>>2];c[e+12>>2]=c[l+12>>2];c[d>>2]=c[l>>2];c[d+4>>2]=c[l+4>>2];c[d+8>>2]=c[l+8>>2];c[d+12>>2]=c[l+12>>2];b=1;do{f=+g[l+(b<<4)>>2];if(f<+g[d>>2])g[d>>2]=f;h=+g[l+(b<<4)+4>>2];if(h<+g[d+4>>2])g[d+4>>2]=h;j=+g[l+(b<<4)+8>>2];if(j<+g[d+8>>2])g[d+8>>2]=j;k=+g[l+(b<<4)+12>>2];if(k<+g[d+12>>2])g[d+12>>2]=k;if(+g[e>>2]<f)g[e>>2]=f;if(+g[e+4>>2]<h)g[e+4>>2]=h;if(+g[e+8>>2]<j)g[e+8>>2]=j;if(+g[e+12>>2]<k)g[e+12>>2]=k;b=b+1|0}while((b|0)!=8);i=l;return}function bf(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+16|0;li(12143);l=c[b+204>>2]|0;ic[c[(c[l>>2]|0)+8>>2]&127](l,b,c[b+24>>2]|0);l=c[b+308>>2]|0;if((l|0)>0){k=c[b+316>>2]|0;m=0;do{e=c[k+(m<<2)>>2]|0;d=c[e+740>>2]|0;e=c[e+744>>2]|0;if((d|0?(e|0?(c[d+204>>2]&3|0)==0:0):0)?(c[e+204>>2]&3|0)==0:0){h=c[d+208>>2]|0;d=c[e+208>>2]|0;j=c[(c[b+204>>2]|0)+16>>2]|0;e=c[j+(h<<3)>>2]|0;if((e|0)!=(h|0)){f=j+(h<<3)|0;do{h=j+(e<<3)|0;c[f>>2]=c[h>>2];h=c[h>>2]|0;f=j+(h<<3)|0;e=c[f>>2]|0}while((h|0)!=(e|0))}e=c[j+(d<<3)>>2]|0;if((e|0)!=(d|0)){f=j+(d<<3)|0;do{d=j+(e<<3)|0;c[f>>2]=c[d>>2];d=c[d>>2]|0;f=j+(d<<3)|0;e=c[f>>2]|0}while((d|0)!=(e|0))}if((h|0)!=(d|0)){c[j+(h<<3)>>2]=d;f=j+(d<<3)+4|0;c[f>>2]=(c[f>>2]|0)+(c[j+(h<<3)+4>>2]|0)}}m=m+1|0}while((m|0)!=(l|0))}l=c[b+212>>2]|0;if((l|0)>0){k=c[b+220>>2]|0;m=0;do{d=c[k+(m<<2)>>2]|0;if((a[d+20>>0]|0?(n=c[d+28>>2]|0,(c[n+204>>2]&3|0)==0):0)?(o=c[d+32>>2]|0,(c[o+204>>2]&3|0)==0):0){f=c[n+208>>2]|0;d=c[o+208>>2]|0;j=c[(c[b+204>>2]|0)+16>>2]|0;e=c[j+(f<<3)>>2]|0;if((e|0)==(f|0))h=f;else{f=j+(f<<3)|0;do{h=j+(e<<3)|0;c[f>>2]=c[h>>2];h=c[h>>2]|0;f=j+(h<<3)|0;e=c[f>>2]|0}while((h|0)!=(e|0))}e=c[j+(d<<3)>>2]|0;if((e|0)!=(d|0)){f=j+(d<<3)|0;do{d=j+(e<<3)|0;c[f>>2]=c[d>>2];d=c[d>>2]|0;f=j+(d<<3)|0;e=c[f>>2]|0}while((d|0)!=(e|0))}if((h|0)!=(d|0)){c[j+(h<<3)>>2]=d;f=j+(d<<3)+4|0;c[f>>2]=(c[f>>2]|0)+(c[j+(h<<3)+4>>2]|0)}}m=m+1|0}while((m|0)!=(l|0))}d=c[b+204>>2]|0;Cb[c[(c[d>>2]|0)+12>>2]&127](d,b);d=c[2357]|0;b=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=b;if(b|0){i=p;return}do if(c[d+4>>2]|0){tb(p|0,0)|0;b=c[6434]|0;g[d+8>>2]=+g[d+8>>2]+ +(((c[p+4>>2]|0)-(c[b+4>>2]|0)+(((c[p>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[d+16>>2]|0)){d=c[2357]|0;break}else{i=p;return}}while(0);c[2357]=c[d+20>>2];i=p;return}function cf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0,p=0.0,q=0;o=i;i=i+128|0;h=+g[b>>2];j=+g[b+16>>2];p=h<j?h:j;k=+g[b+32>>2];if((p<k?p:k)>+g[a+28>>2]){i=o;return}m=h>j?b:b+16|0;if(+g[(+g[m>>2]>k?m:b+32|0)>>2]<+g[a+12>>2]){i=o;return}h=+g[b+8>>2];j=+g[b+24>>2];p=h<j?h:j;k=+g[b+40>>2];if((p<k?p:k)>+g[a+36>>2]){i=o;return}m=h>j?b+8|0:b+24|0;if(+g[(+g[m>>2]>k?m:b+40|0)>>2]<+g[a+20>>2]){i=o;return}h=+g[b+4>>2];j=+g[b+20>>2];p=h<j?h:j;k=+g[b+36>>2];if((p<k?p:k)>+g[a+32>>2]){i=o;return}m=h>j?b+4|0:b+20|0;if(+g[(+g[m>>2]>k?m:b+36|0)>>2]<+g[a+16>>2]){i=o;return}m=c[a+48>>2]|0;f=c[a+4>>2]|0;if((c[(c[f+4>>2]|0)+4>>2]|0)>=20){i=o;return}c[o+24+8>>2]=0;c[o+24+12>>2]=1065353216;c[o+24+16>>2]=1065353216;c[o+24+20>>2]=1065353216;g[o+24+24>>2]=0.0;c[o+24+52>>2]=0;c[o+24>>2]=3736;c[o+24+4>>2]=1;c[o+24+56>>2]=c[b>>2];c[o+24+56+4>>2]=c[b+4>>2];c[o+24+56+8>>2]=c[b+8>>2];c[o+24+56+12>>2]=c[b+12>>2];c[o+24+72>>2]=c[b+16>>2];c[o+24+72+4>>2]=c[b+16+4>>2];c[o+24+72+8>>2]=c[b+16+8>>2];c[o+24+72+12>>2]=c[b+16+12>>2];c[o+24+88>>2]=c[b+32>>2];c[o+24+88+4>>2]=c[b+32+4>>2];c[o+24+88+8>>2]=c[b+32+8>>2];c[o+24+88+12>>2]=c[b+32+12>>2];c[o+24+44>>2]=c[a+56>>2];q=c[a+8>>2]|0;b=c[q+8>>2]|0;l=c[q+12>>2]|0;c[o>>2]=q;c[o+4>>2]=o+24;c[o+8>>2]=b;c[o+12>>2]=l;c[o+16>>2]=d;c[o+20>>2]=e;l=Ib[c[(c[m>>2]|0)+8>>2]&31](m,f,o,c[a+64>>2]|0)|0;f=c[a+44>>2]|0;b=c[f+8>>2]|0;if((c[b+8>>2]|0)==(c[(c[a+8>>2]|0)+8>>2]|0)){c[f+8>>2]=o;ic[c[(c[f>>2]|0)+8>>2]&127](f,d,e)}else{b=c[f+12>>2]|0;c[f+12>>2]=o;ic[c[(c[f>>2]|0)+12>>2]&127](f,d,e)}yb[c[(c[l>>2]|0)+8>>2]&31](l,c[a+4>>2]|0,o,c[a+52>>2]|0,c[a+44>>2]|0);f=c[a+44>>2]|0;if((c[(c[f+8>>2]|0)+8>>2]|0)==(c[(c[a+8>>2]|0)+8>>2]|0))c[f+8>>2]=b;else c[f+12>>2]=b;Ab[c[c[l>>2]>>2]&255](l);Cb[c[(c[m>>2]|0)+60>>2]&127](m,l);c[o+24>>2]=7124;f=c[o+24+52>>2]|0;if(f|0?(Ab[c[c[f>>2]>>2]&255](f),n=c[o+24+52>>2]|0,n|0):0){c[6436]=(c[6436]|0)+1;hd(c[n+-4>>2]|0)}i=o;return}function df(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;k=i;i=i+64|0;l=(a[b+8>>0]|0)!=0;j=l?e:d;d=l?d:e;e=c[d+4>>2]|0;if(((c[e+4>>2]|0)+-21|0)>>>0>=9){i=k;return}if((c[(c[j+4>>2]|0)+4>>2]|0)>=20){i=k;return}m=+Sb[c[(c[e>>2]|0)+48>>2]&15](e);c[h+4>>2]=c[b+76>>2];c[b+16>>2]=j;c[b+20>>2]=d;c[b+64>>2]=f;g[b+68>>2]=m;c[b+56>>2]=h;l=c[d+12>>2]|0;B=+g[l>>2];A=+g[l+16>>2];z=+g[l+32>>2];y=+g[l+4>>2];x=+g[l+20>>2];w=+g[l+36>>2];s=+g[l+8>>2];q=+g[l+24>>2];o=+g[l+40>>2];v=-+g[l+48>>2];u=-+g[l+52>>2];t=-+g[l+56>>2];l=c[j+12>>2]|0;K=+g[l>>2];J=+g[l+16>>2];I=+g[l+32>>2];H=+g[l+4>>2];G=+g[l+20>>2];F=+g[l+36>>2];E=+g[l+8>>2];D=+g[l+24>>2];C=+g[l+40>>2];r=+g[l+48>>2];p=+g[l+52>>2];n=+g[l+56>>2];g[k>>2]=B*K+A*J+z*I;g[k+4>>2]=B*H+A*G+z*F;g[k+8>>2]=B*E+A*D+z*C;g[k+12>>2]=0.0;g[k+16>>2]=y*K+x*J+w*I;g[k+20>>2]=y*H+x*G+w*F;g[k+24>>2]=y*E+x*D+w*C;g[k+28>>2]=0.0;g[k+32>>2]=s*K+q*J+o*I;g[k+36>>2]=s*H+q*G+o*F;g[k+40>>2]=s*E+q*D+o*C;g[k+44>>2]=0.0;g[k+48>>2]=B*v+A*u+z*t+(B*r+A*p+z*n);g[k+52>>2]=y*v+x*u+w*t+(y*r+x*p+w*n);g[k+56>>2]=s*v+q*u+o*t+(s*r+q*p+o*n);g[k+60>>2]=0.0;l=c[(c[b+16>>2]|0)+4>>2]|0;mc[c[(c[l>>2]|0)+8>>2]&127](l,k,b+24|0,b+40|0);g[b+40>>2]=+g[b+40>>2]+m;g[b+44>>2]=+g[b+44>>2]+m;g[b+48>>2]=+g[b+48>>2]+m;g[b+24>>2]=+g[b+24>>2]-m;g[b+28>>2]=+g[b+28>>2]-m;g[b+32>>2]=+g[b+32>>2]-m;l=c[b+76>>2]|0;f=c[d+8>>2]|0;c[l+740>>2]=c[j+8>>2];c[l+744>>2]=f;mc[c[(c[e>>2]|0)+64>>2]&127](e,b+12|0,b+24|0,b+40|0);e=c[h+4>>2]|0;do if(c[e+748>>2]|0){j=c[e+740>>2]|0;f=c[(c[h+8>>2]|0)+8>>2]|0;d=c[(c[h+12>>2]|0)+8>>2]|0;if((j|0)==(f|0)){ef(e,j+4|0,d+4|0);break}else{ef(e,d+4|0,f+4|0);break}}while(0);c[b+16>>2]=0;c[b+20>>2]=0;i=k;return}function ef(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;f=c[b+748>>2]|0;if((f|0)<=0)return;do{k=f;f=f+-1|0;p=+g[b+4+(f*184|0)>>2];q=+g[b+4+(f*184|0)+4>>2];h=+g[b+4+(f*184|0)+8>>2];o=p*+g[d>>2]+q*+g[d+4>>2]+h*+g[d+8>>2]+ +g[d+48>>2];m=p*+g[d+16>>2]+q*+g[d+20>>2]+h*+g[d+24>>2]+ +g[d+52>>2];h=p*+g[d+32>>2]+q*+g[d+36>>2]+h*+g[d+40>>2]+ +g[d+56>>2];g[b+4+(f*184|0)+48>>2]=o;g[b+4+(f*184|0)+52>>2]=m;g[b+4+(f*184|0)+56>>2]=h;g[b+4+(f*184|0)+60>>2]=0.0;q=+g[b+4+(f*184|0)+16>>2];p=+g[b+4+(f*184|0)+20>>2];i=+g[b+4+(f*184|0)+24>>2];n=q*+g[e>>2]+p*+g[e+4>>2]+i*+g[e+8>>2]+ +g[e+48>>2];l=q*+g[e+16>>2]+p*+g[e+20>>2]+i*+g[e+24>>2]+ +g[e+52>>2];i=q*+g[e+32>>2]+p*+g[e+36>>2]+i*+g[e+40>>2]+ +g[e+56>>2];g[b+4+(f*184|0)+32>>2]=n;g[b+4+(f*184|0)+36>>2]=l;g[b+4+(f*184|0)+40>>2]=i;g[b+4+(f*184|0)+44>>2]=0.0;g[b+4+(f*184|0)+80>>2]=(o-n)*+g[b+4+(f*184|0)+64>>2]+(m-l)*+g[b+4+(f*184|0)+68>>2]+(h-i)*+g[b+4+(f*184|0)+72>>2];j=b+4+(f*184|0)+148|0;c[j>>2]=(c[j>>2]|0)+1}while((k|0)>1);f=c[b+748>>2]|0;if((f|0)<=0)return;e=f;j=f;while(1){k=j;j=j+-1|0;d=b+4+(j*184|0)|0;h=+g[b+4+(j*184|0)+80>>2];i=+g[b+752>>2];if(h<=i){o=+g[b+4+(j*184|0)+32>>2]-(+g[b+4+(j*184|0)+48>>2]-+g[b+4+(j*184|0)+64>>2]*h);p=+g[b+4+(j*184|0)+36>>2]-(+g[b+4+(j*184|0)+52>>2]-h*+g[b+4+(j*184|0)+68>>2]);q=+g[b+4+(j*184|0)+40>>2]-(+g[b+4+(j*184|0)+56>>2]-h*+g[b+4+(j*184|0)+72>>2]);if(o*o+p*p+q*q>i*i){f=e+-1|0;if((f|0)==(j|0))f=e;else{_m(d|0,b+4+(f*184|0)|0,184)|0;c[b+4+(f*184|0)+112>>2]=0;g[b+4+(f*184|0)+120>>2]=0.0;a[b+4+(f*184|0)+116>>0]=0;g[b+4+(f*184|0)+124>>2]=0.0;g[b+4+(f*184|0)+128>>2]=0.0;c[b+4+(f*184|0)+148>>2]=0;f=c[b+748>>2]|0}f=f+-1|0;c[b+748>>2]=f}else f=e}else{f=e+-1|0;if((f|0)==(j|0))f=e;else{_m(d|0,b+4+(f*184|0)|0,184)|0;c[b+4+(f*184|0)+112>>2]=0;g[b+4+(f*184|0)+120>>2]=0.0;a[b+4+(f*184|0)+116>>0]=0;g[b+4+(f*184|0)+124>>2]=0.0;g[b+4+(f*184|0)+128>>2]=0.0;c[b+4+(f*184|0)+148>>2]=0;f=c[b+748>>2]|0}f=f+-1|0;c[b+748>>2]=f}if((k|0)<=1)break;else e=f}return}function ff(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0;D=i;i=i+32|0;if(!a){i=D;return}w=+g[d>>2]-+g[b>>2];x=+g[d+4>>2]-+g[b+4>>2];r=+g[d+8>>2]-+g[b+8>>2];s=1.0/+O(+(w*w+x*x+r*r));t=w*s==0.0?999999984306749440.0:1.0/(w*s);u=x*s==0.0?999999984306749440.0:1.0/(x*s);v=r*s==0.0?999999984306749440.0:1.0/(r*s);c[6435]=(c[6435]|0)+1;d=yc(531)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}Qn(d|0,0,512)|0;c[d>>2]=a;q=1;a=128;m=128;f=126;while(1){n=q+-1|0;p=c[d+(n<<2)>>2]|0;c[D>>2]=c[p>>2];c[D+4>>2]=c[p+4>>2];c[D+8>>2]=c[p+8>>2];c[D+12>>2]=c[p+12>>2];c[D+16>>2]=c[p+16>>2];c[D+16+4>>2]=c[p+16+4>>2];c[D+16+8>>2]=c[p+16+8>>2];c[D+16+12>>2]=c[p+16+12>>2];j=+g[b>>2];h=t*(+g[D+((t<0.0&1)<<4)>>2]-j);j=t*(+g[D+((t<0.0^1)<<4)>>2]-j);l=+g[b+4>>2];k=u*(+g[D+((u<0.0&1)<<4)+4>>2]-l);l=u*(+g[D+((u<0.0^1)<<4)+4>>2]-l);do if((!(k>j|h>l)?(y=k>h?k:h,B=l<j?l:j,A=+g[b+8>>2],z=v*(+g[D+((v<0.0&1)<<4)+8>>2]-A),A=v*(+g[D+((v<0.0^1)<<4)+8>>2]-A),!(z>B|y>A)):0)?((A<B?A:B)>0.0?(z>y?z:y)<w*s*w+x*s*x+r*s*r:0):0){if(!(c[p+40>>2]|0)){Cb[c[(c[e>>2]|0)+12>>2]&127](e,p);break}if((n|0)>(f|0)){o=m<<1;if((m|0)<(o|0)){do if((a|0)<(o|0)){if(m){c[6435]=(c[6435]|0)+1;a=yc((m<<3|3)+16|0)|0;if(!a)a=0;else{c[(a+4+15&-16)+-4>>2]=a;a=a+4+15&-16}if((m|0)>0){f=0;do{c[a+(f<<2)>>2]=c[d+(f<<2)>>2];f=f+1|0}while((f|0)!=(m|0))}else C=17}else{a=0;C=17}if((C|0)==17){C=0;if(!d){f=o;d=a;break}}c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0);f=o;d=a}else f=a;while(0);Qn(d+(m<<2)|0,0,m<<2|0)|0;a=f}m=o;f=o+-2|0}c[d+(n<<2)>>2]=c[p+36>>2];c[d+(q<<2)>>2]=c[p+40>>2];n=q+1|0}while(0);if(!n)break;else q=n}if(!d){i=D;return}c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0);i=D;return}function gf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0.0,j=0.0,k=0.0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0;f=i;i=i+256|0;li(11671);c[f+32>>2]=4060;l=f+32+36|0;c[l>>2]=c[b>>2];c[l+4>>2]=c[b+4>>2];c[l+8>>2]=c[b+8>>2];c[l+12>>2]=c[b+12>>2];m=f+32+52|0;c[m>>2]=c[d>>2];c[m+4>>2]=c[d+4>>2];c[m+8>>2]=c[d+8>>2];c[m+12>>2]=c[d+12>>2];c[f+32+212>>2]=a;c[f+32+216>>2]=e;c[f+32+68>>2]=1065353216;c[f+32+72>>2]=0;c[f+32+72+4>>2]=0;c[f+32+72+8>>2]=0;c[f+32+72+12>>2]=0;c[f+32+88>>2]=1065353216;c[f+32+92>>2]=0;c[f+32+92+4>>2]=0;c[f+32+92+8>>2]=0;c[f+32+92+12>>2]=0;c[f+32+108>>2]=1065353216;c[f+32+112>>2]=0;c[f+32+116>>2]=c[l>>2];c[f+32+116+4>>2]=c[l+4>>2];c[f+32+116+8>>2]=c[l+8>>2];c[f+32+116+12>>2]=c[l+12>>2];c[f+32+132>>2]=1065353216;c[f+32+136>>2]=0;c[f+32+136+4>>2]=0;c[f+32+136+8>>2]=0;c[f+32+136+12>>2]=0;c[f+32+152>>2]=1065353216;c[f+32+156>>2]=0;c[f+32+156+4>>2]=0;c[f+32+156+8>>2]=0;c[f+32+156+12>>2]=0;c[f+32+172>>2]=1065353216;c[f+32+176>>2]=0;c[f+32+180>>2]=c[d>>2];c[f+32+180+4>>2]=c[d+4>>2];c[f+32+180+8>>2]=c[d+8>>2];c[f+32+180+12>>2]=c[d+12>>2];n=+g[d>>2]-+g[b>>2];k=+g[d+4>>2]-+g[b+4>>2];j=+g[d+8>>2]-+g[b+8>>2];h=1.0/+O(+(n*n+k*k+j*j));q=n*h==0.0?1000000015047466219876688.0e6:1.0/(n*h);g[f+32+4>>2]=q;p=k*h==0.0?1000000015047466219876688.0e6:1.0/(k*h);g[f+32+8>>2]=p;o=j*h==0.0?1000000015047466219876688.0e6:1.0/(j*h);g[f+32+12>>2]=o;c[f+32+20>>2]=q<0.0&1;c[f+32+24>>2]=p<0.0&1;c[f+32+28>>2]=o<0.0&1;g[f+32+32>>2]=n*h*(+g[m>>2]-+g[l>>2])+k*h*(+g[f+32+56>>2]-+g[f+32+40>>2])+j*h*(+g[f+32+60>>2]-+g[f+32+44>>2]);a=c[a+68>>2]|0;e=c[(c[a>>2]|0)+24>>2]|0;c[f+16>>2]=0;c[f+16+4>>2]=0;c[f+16+8>>2]=0;c[f+16+12>>2]=0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;Qb[e&7](a,b,d,f+32|0,f+16|0,f);b=c[2357]|0;a=(c[b+16>>2]|0)+-1|0;c[b+16>>2]=a;if(a|0){i=f;return}do if(c[b+4>>2]|0){tb(f+32|0,0)|0;m=c[6434]|0;g[b+8>>2]=+g[b+8>>2]+ +(((c[f+32+4>>2]|0)-(c[m+4>>2]|0)+(((c[f+32>>2]|0)-(c[m>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[b+16>>2]|0)){b=c[2357]|0;break}else{i=f;return}}while(0);c[2357]=c[b+20>>2];i=f;return}function hf(b,d){b=b|0;d=+d;var e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0;s=i;i=i+16|0;li(12002);e=c[b+232>>2]|0;if((e|0)>0){r=0;do{q=c[(c[b+240>>2]|0)+(r<<2)>>2]|0;if(!(c[q+204>>2]&3)){n=+g[q+444>>2];f=+P(+(1.0-n),+d);j=f*+g[q+312>>2];g[q+312>>2]=j;h=f*+g[q+316>>2];g[q+316>>2]=h;f=f*+g[q+320>>2];g[q+320>>2]=f;p=+g[q+448>>2];m=+P(+(1.0-p),+d);k=m*+g[q+328>>2];g[q+328>>2]=k;l=m*+g[q+332>>2];g[q+332>>2]=l;m=m*+g[q+336>>2];g[q+336>>2]=m;do if(a[q+452>>0]|0){if(m*m+(k*k+l*l)<+g[q+464>>2]?j*j+h*h+f*f<+g[q+460>>2]:0){t=+g[q+456>>2];g[q+328>>2]=k*t;g[q+332>>2]=t*l;g[q+336>>2]=t*m;g[q+312>>2]=t*j;g[q+316>>2]=t*h;g[q+320>>2]=t*f;f=t*f;o=k*t;l=t*l;m=t*m;j=t*j;h=t*h}else o=k;k=+O(+(j*j+h*h+f*f));do if(k<n)if(k>.004999999888241291){j=j-j*(1.0/k)*.004999999888241291;g[q+312>>2]=j;h=h-h*(1.0/k)*.004999999888241291;g[q+316>>2]=h;f=f-f*(1.0/k)*.004999999888241291;g[q+320>>2]=f;break}else{c[q+312>>2]=0;c[q+312+4>>2]=0;c[q+312+8>>2]=0;c[q+312+12>>2]=0;j=0.0;h=0.0;f=0.0;break}while(0);k=+O(+(o*o+l*l+m*m));if(k<p)if(k>.004999999888241291){g[q+328>>2]=o-o*(1.0/k)*.004999999888241291;g[q+332>>2]=l-l*(1.0/k)*.004999999888241291;g[q+336>>2]=m-m*(1.0/k)*.004999999888241291;break}else{c[q+328>>2]=0;c[q+328+4>>2]=0;c[q+328+8>>2]=0;c[q+328+12>>2]=0;break}}while(0);Zg(q+4|0,j,h,f,q+328|0,d,q+68|0);e=c[b+232>>2]|0}r=r+1|0}while((r|0)<(e|0))}e=c[2357]|0;b=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=b;if(b|0){i=s;return}do if(c[e+4>>2]|0){tb(s|0,0)|0;b=c[6434]|0;g[e+8>>2]=+g[e+8>>2]+ +(((c[s+4>>2]|0)-(c[b+4>>2]|0)+(((c[s>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[e+16>>2]|0)){e=c[2357]|0;break}else{i=s;return}}while(0);c[2357]=c[e+20>>2];i=s;return}function jf(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=c[a+108>>2]|0;if(g|0)ic[c[(c[g>>2]|0)+12>>2]&127](g,c[d+60>>2]|0,f);q=c[d+12>>2]|0;p=c[a+60>>2]|0;o=c[a+92>>2]|0;if(!(Eb[c[(c[o>>2]|0)+56>>2]&127](o)|0)){o=c[a+92>>2]|0;ic[c[(c[o>>2]|0)+16>>2]&127](o,p+((q&65535)<<6)|0,f)}m=e[a+56>>1]|0;g=c[a+60>>2]|0;b[g+54>>1]=(e[g+54>>1]|0)+65534;b[g+56>>1]=(e[g+56>>1]|0)+65534;b[g+58>>1]=(e[g+58>>1]|0)+65534;g=b[a+6>>1]|0;o=0;do{l=a+68+(o<<2)|0;n=c[l>>2]|0;f=e[p+((q&65535)<<6)+54+(o<<1)>>1]|0;b[n+(f<<2)>>1]=g;d=b[n+(f<<2)+6>>1]|0;if(!(d<<16>>16))f=n;else{k=(c[a+60>>2]|0)+((e[n+(f<<2)+2>>1]|0)<<6)+54+(o<<1)|0;i=n+(f<<2)|0;while(1){j=i;i=i+4|0;h=b[i>>1]|0;if((g&65535)<(h&65535))break;f=c[a+60>>2]|0;g=d&65535;if(!(h&1)){h=f+(g<<6)+48+(o<<1)|0;b[h>>1]=(b[h>>1]|0)+-1<<16>>16}else{h=f+(g<<6)+54+(o<<1)|0;b[h>>1]=(b[h>>1]|0)+-1<<16>>16}b[k>>1]=(b[k>>1]|0)+1<<16>>16;g=e[j>>1]|e[j+2>>1]<<16;d=e[i>>1]|e[i+2>>1]<<16;b[j>>1]=d;b[j+2>>1]=d>>>16;b[i>>1]=g;b[i+2>>1]=g>>>16;d=b[j+10>>1]|0;if(!(d<<16>>16))break;else g=g&65535}g=b[a+6>>1]|0;f=c[l>>2]|0}d=e[p+((q&65535)<<6)+48+(o<<1)>>1]|0;b[n+(d<<2)>>1]=g;i=f+(d<<2)|0;h=b[i+6>>1]|0;if(h<<16>>16){k=(c[a+60>>2]|0)+((e[f+(d<<2)+2>>1]|0)<<6)+48+(o<<1)|0;g=b[i>>1]|0;while(1){j=i;i=i+4|0;f=b[i>>1]|0;if((g&65535)<(f&65535))break;d=c[a+60>>2]|0;g=h&65535;if(!(f&1)){l=d+(g<<6)+48+(o<<1)|0;b[l>>1]=(b[l>>1]|0)+-1<<16>>16}else{l=d+(g<<6)+54+(o<<1)|0;b[l>>1]=(b[l>>1]|0)+-1<<16>>16}b[k>>1]=(b[k>>1]|0)+1<<16>>16;g=e[j>>1]|e[j+2>>1]<<16;h=e[i>>1]|e[i+2>>1]<<16;b[j>>1]=h;b[j+2>>1]=h>>>16;b[i>>1]=g;b[i+2>>1]=g>>>16;h=b[j+10>>1]|0;if(!(h<<16>>16))break;else g=g&65535}g=b[a+6>>1]|0}b[n+((m<<1)+-1<<2)+2>>1]=0;b[n+((m<<1)+-1<<2)>>1]=g;o=o+1|0}while((o|0)!=3);b[(c[a+60>>2]|0)+((q&65535)<<6)+48>>1]=b[a+64>>1]|0;b[a+64>>1]=q;b[a+56>>1]=(b[a+56>>1]|0)+-1<<16>>16;return}function kf(b){b=b|0;var d=0,e=0;c[b>>2]=5224;if(a[b+20>>0]|0){d=c[b+16>>2]|0;e=c[d+16>>2]|0;if(e){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);d=c[b+16>>2]|0}if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}}if(a[b+12>>0]|0){d=c[b+8>>2]|0;e=c[d+16>>2]|0;if(e){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);d=c[b+8>>2]|0}if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}}d=c[b+32>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+32>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+36>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+36>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+40>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+40>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+44>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+44>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+48>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+48>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+52>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+52>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+56>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+56>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+60>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+60>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+76>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+76>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+80>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+80>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+72>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+72>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+88>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+88>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+84>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+84>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+24>>2]|0;if(d|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}d=c[b+28>>2]|0;Ab[c[c[d>>2]>>2]&255](d);d=c[b+28>>2]|0;if(!d)return;c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0);return}function lf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0.0;if(!(c[a>>2]|0)){c[a>>2]=d;c[d+32>>2]=0;return}e=c[b+40>>2]|0;if(!e)o=b;else{k=+g[d>>2]+ +g[d+16>>2];i=+g[d+4>>2]+ +g[d+20>>2];j=+g[d+8>>2]+ +g[d+24>>2];do{p=c[b+36>>2]|0;n=+N(+(k-(+g[p>>2]+ +g[p+16>>2])))+ +N(+(i-(+g[p+4>>2]+ +g[p+20>>2])))+ +N(+(j-(+g[p+8>>2]+ +g[p+24>>2])));b=c[b+36+((!(n<+N(+(k-(+g[e>>2]+ +g[e+16>>2])))+ +N(+(i-(+g[e+4>>2]+ +g[e+20>>2])))+ +N(+(j-(+g[e+8>>2]+ +g[e+24>>2]))))&1)<<2)>>2]|0;e=c[b+40>>2]|0}while((e|0)!=0);o=b}p=o+32|0;e=c[p>>2]|0;b=c[a+4>>2]|0;if(!b){c[6435]=(c[6435]|0)+1;b=yc(63)|0;if(!b)b=0;else{c[(b+4+15&-16)+-4>>2]=b;b=b+4+15&-16}f=b;h=f+44|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(h|0))}else c[a+4>>2]=0;c[b+32>>2]=e;c[b+36>>2]=0;f=b+40|0;c[f>>2]=0;q=+g[d>>2];n=+g[o>>2];n=q<n?q:n;g[b>>2]=n;q=+g[d+16>>2];k=+g[o+16>>2];k=q>k?q:k;g[b+16>>2]=k;q=+g[d+4>>2];m=+g[o+4>>2];m=q<m?q:m;g[b+4>>2]=m;q=+g[d+20>>2];j=+g[o+20>>2];j=q>j?q:j;g[b+20>>2]=j;q=+g[d+8>>2];l=+g[o+8>>2];l=q<l?q:l;g[b+8>>2]=l;q=+g[d+24>>2];i=+g[o+24>>2];i=q>i?q:i;g[b+24>>2]=i;if(!e){c[b+36>>2]=o;c[p>>2]=b;c[f>>2]=d;c[d+32>>2]=b;c[a>>2]=b;return}c[e+36+(((c[(c[p>>2]|0)+40>>2]|0)==(o|0)&1)<<2)>>2]=b;c[b+36>>2]=o;c[p>>2]=b;c[f>>2]=d;c[d+32>>2]=b;while(1){b=e+4|0;if(((((+g[e>>2]<=n?+g[b>>2]<=m:0)?+g[e+8>>2]<=l:0)?+g[e+16>>2]>=k:0)?+g[e+20>>2]>=j:0)?+g[e+24>>2]>=i:0){b=21;break}d=c[e+36>>2]|0;a=c[e+40>>2]|0;q=+g[d>>2];n=+g[a>>2];n=q<n?q:n;g[e>>2]=n;q=+g[d+16>>2];k=+g[a+16>>2];k=q>k?q:k;g[e+16>>2]=k;q=+g[d+4>>2];m=+g[a+4>>2];m=q<m?q:m;g[b>>2]=m;q=+g[d+20>>2];j=+g[a+20>>2];j=q>j?q:j;g[e+20>>2]=j;q=+g[d+8>>2];l=+g[a+8>>2];l=q<l?q:l;g[e+8>>2]=l;q=+g[d+24>>2];i=+g[a+24>>2];i=q>i?q:i;g[e+24>>2]=i;e=c[e+32>>2]|0;if(!e){b=21;break}}if((b|0)==21)return}function mf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;c[b+16>>2]=c[a+4>>2];c[b+20>>2]=c[a+8>>2];c[b+24>>2]=c[a+12>>2];c[b+28>>2]=c[a+16>>2];c[b+32>>2]=c[a+20>>2];c[b+36>>2]=c[a+24>>2];c[b+40>>2]=c[a+28>>2];c[b+44>>2]=c[a+32>>2];c[b+48>>2]=c[a+36>>2];c[b+52>>2]=c[a+40>>2];c[b+56>>2]=c[a+44>>2];c[b+60>>2]=c[a+48>>2];c[b+64>>2]=c[a+52>>2];c[b+68>>2]=c[a+56>>2];c[b+72>>2]=c[a+60>>2];c[b+76>>2]=c[a+64>>2];c[b+80>>2]=c[a+68>>2];c[b+84>>2]=c[a+72>>2];c[b+88>>2]=c[a+76>>2];c[b+92>>2]=c[a+80>>2];c[b+96>>2]=c[a+84>>2];c[b+100>>2]=c[a+88>>2];c[b+104>>2]=c[a+92>>2];c[b+108>>2]=c[a+96>>2];c[b+112>>2]=c[a+100>>2];c[b+116>>2]=c[a+104>>2];c[b+120>>2]=c[a+108>>2];c[b+124>>2]=c[a+112>>2];c[b+128>>2]=c[a+116>>2];c[b+132>>2]=c[a+120>>2];c[b+136>>2]=c[a+124>>2];c[b+140>>2]=c[a+128>>2];c[b+144>>2]=c[a+132>>2];c[b+148>>2]=c[a+136>>2];c[b+152>>2]=c[a+140>>2];c[b+156>>2]=c[a+144>>2];c[b+160>>2]=c[a+148>>2];c[b+164>>2]=c[a+152>>2];c[b+168>>2]=c[a+156>>2];c[b+172>>2]=c[a+160>>2];c[b+176>>2]=c[a+164>>2];c[b+180>>2]=c[a+168>>2];c[b+184>>2]=c[a+172>>2];c[b+188>>2]=c[a+176>>2];c[b+224>>2]=c[a+180>>2];c[b+192>>2]=c[a+184>>2];c[b>>2]=0;c[b+4>>2]=Zb[c[(c[d>>2]|0)+28>>2]&31](d,c[a+192>>2]|0)|0;c[b+8>>2]=0;c[b+228>>2]=c[a+204>>2];c[b+232>>2]=c[a+208>>2];c[b+236>>2]=c[a+212>>2];c[b+240>>2]=c[a+216>>2];c[b+196>>2]=c[a+220>>2];c[b+200>>2]=c[a+224>>2];c[b+204>>2]=c[a+232>>2];c[b+208>>2]=c[a+228>>2];c[b+244>>2]=c[a+236>>2];e=Zb[c[(c[d>>2]|0)+40>>2]&31](d,a)|0;f=Zb[c[(c[d>>2]|0)+28>>2]&31](d,e)|0;c[b+12>>2]=f;if(!f){d=a+244|0;d=c[d>>2]|0;f=b+212|0;c[f>>2]=d;f=a+248|0;f=c[f>>2]|0;d=b+216|0;c[d>>2]=f;d=a+252|0;d=c[d>>2]|0;f=b+220|0;c[f>>2]=d;a=a+256|0;a=c[a>>2]|0;f=b+248|0;c[f>>2]=a;return 13172}Cb[c[(c[d>>2]|0)+48>>2]&127](d,e);d=a+244|0;d=c[d>>2]|0;f=b+212|0;c[f>>2]=d;f=a+248|0;f=c[f>>2]|0;d=b+216|0;c[d>>2]=f;d=a+252|0;d=c[d>>2]|0;f=b+220|0;c[f>>2]=d;a=a+256|0;a=c[a>>2]|0;f=b+248|0;c[f>>2]=a;return 13172}function nf(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;q=c[b+9288>>2]|0;if(!q){c[b>>2]=5;b=0;return b|0}i=c[q+48>>2]|0;if(i|0)c[i+44>>2]=c[q+44>>2];i=c[q+44>>2]|0;if(i|0)c[i+48>>2]=c[q+48>>2];if((c[b+9288>>2]|0)==(q|0))c[b+9288>>2]=c[q+48>>2];c[b+9292>>2]=(c[b+9292>>2]|0)+-1;c[q+44>>2]=0;c[q+48>>2]=c[b+9280>>2];i=c[b+9280>>2]|0;if(i|0)c[i+44>>2]=q;c[b+9280>>2]=q;c[b+9284>>2]=(c[b+9284>>2]|0)+1;a[q+55>>0]=0;c[q+20>>2]=d;c[q+24>>2]=e;c[q+28>>2]=f;m=+g[d+16>>2];j=+g[e+16>>2]-m;n=+g[d+20>>2];k=+g[e+20>>2]-n;o=+g[d+24>>2];l=+g[e+24>>2]-o;m=+g[f+16>>2]-m;n=+g[f+20>>2]-n;o=+g[f+24>>2]-o;g[q>>2]=k*o-l*n;g[q+4>>2]=l*m-j*o;g[q+8>>2]=j*n-k*m;g[q+12>>2]=0.0;p=+O(+((k*o-l*n)*(k*o-l*n)+(l*m-j*o)*(l*m-j*o)+(j*n-k*m)*(j*n-k*m)));do if(p>9.999999747378752e-05){if((!($k(k*o-l*n,l*m-j*o,j*n-k*m,+g[d+16>>2],+g[d+20>>2],+g[d+24>>2],+g[e+16>>2],+g[e+20>>2],+g[e+24>>2],q+16|0)|0)?!($k(+g[q>>2],+g[q+4>>2],+g[q+8>>2],+g[e+16>>2],+g[e+20>>2],+g[e+24>>2],+g[f+16>>2],+g[f+20>>2],+g[f+24>>2],q+16|0)|0):0)?!($k(+g[q>>2],+g[q+4>>2],+g[q+8>>2],+g[f+16>>2],+g[f+20>>2],+g[f+24>>2],+g[d+16>>2],+g[d+20>>2],+g[d+24>>2],q+16|0)|0):0)g[q+16>>2]=(+g[d+16>>2]*+g[q>>2]+ +g[d+20>>2]*+g[q+4>>2]+ +g[d+24>>2]*+g[q+8>>2])/p;g[q>>2]=1.0/p*+g[q>>2];g[q+4>>2]=1.0/p*+g[q+4>>2];g[q+8>>2]=1.0/p*+g[q+8>>2];if(h){b=q;return b|0}if(!(+g[q+16>>2]>=-9.999999747378752e-06)){c[b>>2]=3;break}else{b=q;return b|0}}else c[b>>2]=2;while(0);i=c[q+48>>2]|0;if(i|0)c[i+44>>2]=c[q+44>>2];i=c[q+44>>2]|0;if(i|0)c[i+48>>2]=c[q+48>>2];if((c[b+9280>>2]|0)==(q|0))c[b+9280>>2]=c[q+48>>2];c[b+9284>>2]=(c[b+9284>>2]|0)+-1;c[q+44>>2]=0;c[q+48>>2]=c[b+9288>>2];i=c[b+9288>>2]|0;if(i|0)c[i+44>>2]=q;c[b+9288>>2]=q;c[b+9292>>2]=(c[b+9292>>2]|0)+1;b=0;return b|0}function of(a,b,f){a=a|0;b=b|0;f=f|0;var j=0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;t=i;i=i+32|0;o=c[a+4>>2]|0;Yb[c[(c[o>>2]|0)+16>>2]&3](o,t+28|0,t+24|0,t+20|0,t+16|0,t+12|0,t+8|0,t+4|0,t,b);o=(c[t+12>>2]|0)+(_(c[t+8>>2]|0,f)|0)|0;s=c[a+4>>2]|0;n=c[t>>2]|0;switch(n|0){case 3:{j=e[o+4>>1]|0;break}case 2:{j=c[o+8>>2]|0;break}default:j=d[o+2>>0]|0}r=(c[t+20>>2]|0)==0;p=c[t+28>>2]|0;q=c[t+16>>2]|0;j=p+(_(q,j)|0)|0;if(r){l=+g[j+8>>2]*+g[s+12>>2];m=+g[j+4>>2]*+g[s+8>>2];k=+g[j>>2]*+g[s+4>>2]}else{l=+h[j+16>>3]*+g[s+12>>2];m=+h[j+8>>3]*+g[s+8>>2];k=+h[j>>3]*+g[s+4>>2]}g[a+44>>2]=k;g[a+48>>2]=m;g[a+52>>2]=l;g[a+56>>2]=0.0;switch(n|0){case 3:{j=e[o+2>>1]|0;break}case 2:{j=c[o+4>>2]|0;break}default:j=d[o+1>>0]|0}j=p+(_(q,j)|0)|0;if(r){l=+g[j+8>>2]*+g[s+12>>2];m=+g[j+4>>2]*+g[s+8>>2];k=+g[j>>2]*+g[s+4>>2]}else{l=+h[j+16>>3]*+g[s+12>>2];m=+h[j+8>>3]*+g[s+8>>2];k=+h[j>>3]*+g[s+4>>2]}g[a+28>>2]=k;g[a+32>>2]=m;g[a+36>>2]=l;g[a+40>>2]=0.0;switch(n|0){case 3:{j=e[o>>1]|0;break}case 2:{j=c[o>>2]|0;break}default:j=d[o>>0]|0}j=p+(_(q,j)|0)|0;if(r){m=+g[j+8>>2]*+g[s+12>>2];l=+g[j+4>>2]*+g[s+8>>2];k=+g[j>>2]*+g[s+4>>2];r=a+12|0;g[r>>2]=k;r=a+16|0;g[r>>2]=l;r=a+20|0;g[r>>2]=m;r=a+24|0;g[r>>2]=0.0;r=a+8|0;r=c[r>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;s=a+12|0;mc[q&127](r,s,b,f);a=c[a+4>>2]|0;f=c[a>>2]|0;f=f+24|0;f=c[f>>2]|0;Cb[f&127](a,b);i=t;return}else{m=+h[j+16>>3]*+g[s+12>>2];l=+h[j+8>>3]*+g[s+8>>2];k=+h[j>>3]*+g[s+4>>2];r=a+12|0;g[r>>2]=k;r=a+16|0;g[r>>2]=l;r=a+20|0;g[r>>2]=m;r=a+24|0;g[r>>2]=0.0;r=a+8|0;r=c[r>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;s=a+12|0;mc[q&127](r,s,b,f);a=c[a+4>>2]|0;f=c[a>>2]|0;f=f+24|0;f=c[f>>2]|0;Cb[f&127](a,b);i=t;return}}function pf(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;c[6435]=(c[6435]|0)+1;f=yc(479)|0;if(!f)s=0;else{c[(f+4+15&-16)+-4>>2]=f;s=f+4+15&-16}je(s,b,d,e);c[s>>2]=3872;a[s+340>>0]=1;c[s+336>>2]=0;c[s+328>>2]=0;c[s+332>>2]=0;k=s+352|0;g[k>>2]=1.2000000476837158;l=s+356|0;g[l>>2]=0.0;m=s+360|0;g[m>>2]=0.0;g[s+364>>2]=1.0e3;n=s+368|0;o=s+396|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[o>>2]=-1054867456;p=s+400|0;c[p>>2]=0;q=s+404|0;g[q>>2]=0.0;a[s+424>>0]=1;r=s+420|0;c[r>>2]=0;j=s+412|0;c[j>>2]=0;c[s+416>>2]=0;e=s+452|0;c[e>>2]=h;i=s+456|0;a[i>>0]=0;if(!h){c[6435]=(c[6435]|0)+1;f=yc(59)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}g[f+12>>2]=1.0;c[f+8>>2]=0;c[f+4>>2]=5;c[f>>2]=2996;a[f+36>>0]=1;c[f+32>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;a[f+16>>0]=1;c[e>>2]=f;a[i>>0]=1}c[s+344>>2]=4302;a[s+348>>0]=1;a[s+349>>0]=0;a[s+350>>0]=0;c[s+384>>2]=d;c[s+388>>2]=b;h=s+408|0;Ji(h);e=c[j>>2]|0;if((e|0)>0)i=0;else{r=s+428|0;g[r>>2]=.25;r=s+432|0;c[r>>2]=0;r=s+436|0;c[r>>2]=0;r=s+444|0;c[r>>2]=1;r=s+448|0;c[r>>2]=1;g[k>>2]=1.2000000476837158;g[l>>2]=0.0;g[m>>2]=0.0;r=s+392|0;c[r>>2]=0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[o>>2]=-1054867456;c[p>>2]=0;g[q>>2]=0.0;Ji(h);return s|0}do{d=(c[r>>2]|0)+(i<<2)|0;f=c[d>>2]|0;c[d>>2]=0;if(f|0)do{d=f;f=c[f+280>>2]|0;hd(d)}while((f|0)!=0);i=i+1|0}while((i|0)!=(e|0));r=s+428|0;g[r>>2]=.25;r=s+432|0;c[r>>2]=0;r=s+436|0;c[r>>2]=0;r=s+444|0;c[r>>2]=1;r=s+448|0;c[r>>2]=1;g[k>>2]=1.2000000476837158;g[l>>2]=0.0;g[m>>2]=0.0;r=s+392|0;c[r>>2]=0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[o>>2]=-1054867456;c[p>>2]=0;g[q>>2]=0.0;Ji(h);return s|0}function qf(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0,h=0,i=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;j=c[a+28>>2]|0;k=c[a+32>>2]|0;f=c[b+8>>2]|0;g[f>>2]=1.0;h=c[b+24>>2]|0;g[f+(h+1<<2)>>2]=1.0;g[f+((h<<1)+2<<2)>>2]=1.0;l=+g[a+300>>2];q=+g[a+304>>2];e=+g[a+308>>2];o=+g[j+4>>2]*l+ +g[j+8>>2]*q+ +g[j+12>>2]*e;m=l*+g[j+20>>2]+q*+g[j+24>>2]+e*+g[j+28>>2];e=l*+g[j+36>>2]+q*+g[j+40>>2]+e*+g[j+44>>2];f=c[b+12>>2]|0;c[f>>2]=0;g[f+4>>2]=e;g[f+8>>2]=-m;g[f+12>>2]=0.0;g[f+(h<<2)>>2]=-e;c[f+(h<<2)+4>>2]=0;g[f+(h<<2)+8>>2]=o;g[f+(h<<2)+12>>2]=0.0;g[f+(h<<1<<2)>>2]=m;g[f+(h<<1<<2)+4>>2]=-o;c[f+(h<<1<<2)+8>>2]=0;g[f+(h<<1<<2)+12>>2]=0.0;f=c[b+16>>2]|0;g[f>>2]=-1.0;g[f+(h+1<<2)>>2]=-1.0;g[f+((h<<1)+2<<2)>>2]=-1.0;q=+g[a+316>>2];l=+g[a+320>>2];d=+g[a+324>>2];p=+g[k+4>>2]*q+ +g[k+8>>2]*l+ +g[k+12>>2]*d;n=q*+g[k+20>>2]+l*+g[k+24>>2]+d*+g[k+28>>2];d=q*+g[k+36>>2]+l*+g[k+40>>2]+d*+g[k+44>>2];h=c[b+20>>2]|0;f=c[b+24>>2]|0;c[h>>2]=0;g[h+4>>2]=-d;g[h+8>>2]=n;g[h+12>>2]=0.0;g[h+(f<<2)>>2]=d;c[h+(f<<2)+4>>2]=0;g[h+(f<<2)+8>>2]=-p;g[h+(f<<2)+12>>2]=0.0;g[h+(f<<1<<2)>>2]=-n;g[h+(f<<1<<2)+4>>2]=p;c[h+(f<<1<<2)+8>>2]=0;g[h+(f<<1<<2)+12>>2]=0.0;f=c[a+332>>2]|0;l=+g[((f&1|0)==0?b+4|0:a+336|0)>>2]*+g[b>>2];h=c[b+24>>2]|0;i=c[b+28>>2]|0;g[i>>2]=l*(p+ +g[k+52>>2]-o-+g[j+52>>2]);g[i+(h<<2)>>2]=l*(n+ +g[k+56>>2]-m-+g[j+56>>2]);g[i+(h<<1<<2)>>2]=l*(d+ +g[k+60>>2]-e-+g[j+60>>2]);if(f&2|0){k=c[b+24>>2]|0;j=c[b+32>>2]|0;c[j>>2]=c[a+340>>2];c[j+(k<<2)>>2]=c[a+340>>2];c[j+(k<<1<<2)>>2]=c[a+340>>2]}e=+g[a+356>>2];if(e>0.0){g[c[b+36>>2]>>2]=-e;g[c[b+40>>2]>>2]=e;d=+g[a+356>>2]}else d=e;if(d>0.0){k=c[b+24>>2]|0;g[(c[b+36>>2]|0)+(k<<2)>>2]=-e;g[(c[b+40>>2]|0)+(k<<2)>>2]=e;d=+g[a+356>>2]}if(!(d>0.0)){j=a+352|0;j=c[j>>2]|0;k=b+52|0;c[k>>2]=j;return}j=c[b+24>>2]<<1;g[(c[b+36>>2]|0)+(j<<2)>>2]=-e;g[(c[b+40>>2]|0)+(j<<2)>>2]=e;j=a+352|0;j=c[j>>2]|0;k=b+52|0;c[k>>2]=j;return}function rf(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0,l=0,m=0;f=c[d+8>>2]|0;if((f|0)>0){h=c[d+16>>2]|0;j=0;e=0;do{i=c[h+(j<<2)>>2]|0;if(!(c[i+204>>2]&3)){c[i+208>>2]=e;e=e+1|0}c[i+212>>2]=-1;g[i+244>>2]=1.0;j=j+1|0}while((j|0)!=(f|0));j=e}else j=0;i=c[b+8>>2]|0;if((i|0)<(j|0)){if((c[b+12>>2]|0)<(j|0)){if(!j){e=0;f=i}else{c[6435]=(c[6435]|0)+1;e=yc((j<<3|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[b+8>>2]|0}if((f|0)>0){h=0;do{m=(c[b+16>>2]|0)+(h<<3)|0;k=c[m+4>>2]|0;l=e+(h<<3)|0;c[l>>2]=c[m>>2];c[l+4>>2]=k;h=h+1|0}while((h|0)!=(f|0))}f=c[b+16>>2]|0;if(f|0){if(a[b+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=e;c[b+12>>2]=j;f=b+16|0}else f=b+16|0;e=i;do{m=(c[f>>2]|0)+(e<<3)|0;c[m>>2]=0;c[m+4>>2]=0;e=e+1|0}while((e|0)!=(j|0))}c[b+8>>2]=j;if((j|0)>0){e=c[b+16>>2]|0;f=0;do{c[e+(f<<3)>>2]=f;c[e+(f<<3)+4>>2]=1;f=f+1|0}while((f|0)!=(j|0))}e=c[d+68>>2]|0;e=Eb[c[(c[e>>2]|0)+36>>2]&127](e)|0;l=Eb[c[(c[e>>2]|0)+36>>2]&127](e)|0;if(!l)return;d=Eb[c[(c[e>>2]|0)+20>>2]&127](e)|0;if((l|0)<=0)return;k=0;do{e=c[c[d+(k<<4)>>2]>>2]|0;f=c[c[d+(k<<4)+4>>2]>>2]|0;if((e|0?(f|0?(c[e+204>>2]&7|0)==0:0):0)?(c[f+204>>2]&7|0)==0:0){i=c[e+208>>2]|0;e=c[f+208>>2]|0;j=c[b+16>>2]|0;f=c[j+(i<<3)>>2]|0;if((f|0)!=(i|0)){h=j+(i<<3)|0;do{i=j+(f<<3)|0;c[h>>2]=c[i>>2];i=c[i>>2]|0;h=j+(i<<3)|0;f=c[h>>2]|0}while((i|0)!=(f|0))}f=c[j+(e<<3)>>2]|0;if((f|0)!=(e|0)){h=j+(e<<3)|0;do{e=j+(f<<3)|0;c[h>>2]=c[e>>2];e=c[e>>2]|0;h=j+(e<<3)|0;f=c[h>>2]|0}while((e|0)!=(f|0))}if((i|0)!=(e|0)){c[j+(i<<3)>>2]=e;m=j+(e<<3)+4|0;c[m>>2]=(c[m>>2]|0)+(c[j+(i<<3)+4>>2]|0)}}k=k+1|0}while((k|0)!=(l|0));return}function sf(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0;a:do if((b|0)==(c[d+8>>2]|0)){if((c[d+4>>2]|0)==(e|0)?(c[d+28>>2]|0)!=1:0)c[d+28>>2]=f}else{if((b|0)!=(c[d>>2]|0)){i=c[b+12>>2]|0;$n(b+16|0,d,e,f,g);if((i|0)<=1)break;h=c[b+8>>2]|0;if((h&2|0)==0?(c[d+36>>2]|0)!=1:0){if(!(h&1)){h=b+24|0;while(1){if(a[d+54>>0]|0)break a;if((c[d+36>>2]|0)==1)break a;$n(h,d,e,f,g);h=h+8|0;if(h>>>0>=(b+16+(i<<3)|0)>>>0)break a}}h=b+24|0;while(1){if(a[d+54>>0]|0)break a;if((c[d+36>>2]|0)==1?(c[d+24>>2]|0)==1:0)break a;$n(h,d,e,f,g);h=h+8|0;if(h>>>0>=(b+16+(i<<3)|0)>>>0)break a}}h=b+24|0;while(1){if(a[d+54>>0]|0)break a;$n(h,d,e,f,g);h=h+8|0;if(h>>>0>=(b+16+(i<<3)|0)>>>0)break a}}if((c[d+16>>2]|0)!=(e|0)?(c[d+20>>2]|0)!=(e|0):0){c[d+32>>2]=f;if((c[d+44>>2]|0)==4)break;f=b+16+(c[b+12>>2]<<3)|0;k=0;h=0;j=b+16|0;b:while(1){if(j>>>0>=f>>>0){i=20;break}a[d+52>>0]=0;a[d+53>>0]=0;On(j,d,e,e,1,g);if(a[d+54>>0]|0){i=20;break}do if(a[d+53>>0]|0){if(!(a[d+52>>0]|0))if(!(c[b+8>>2]&1)){h=1;i=20;break b}else{i=k;h=1;break}if((c[d+24>>2]|0)==1){i=25;break b}if(!(c[b+8>>2]&2)){i=25;break b}else{i=1;h=1}}else i=k;while(0);k=i;j=j+8|0}do if((i|0)==20){if((!k?(c[d+20>>2]=e,c[d+40>>2]=(c[d+40>>2]|0)+1,(c[d+36>>2]|0)==1):0)?(c[d+24>>2]|0)==2:0){a[d+54>>0]=1;if(h){i=25;break}else{h=4;break}}if(h)i=25;else h=4}while(0);if((i|0)==25)h=3;c[d+44>>2]=h;break}if((f|0)==1)c[d+32>>2]=1}while(0);return}function tf(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0;c[6435]=(c[6435]|0)+1;i=yc(1147)|0;if(!i)i=0;else{c[(i+4+15&-16)+-4>>2]=i;i=i+4+15&-16}c[i+4>>2]=7;c[i+8>>2]=-1;c[i+12>>2]=-1;g[i+16>>2]=3402823466385288598117041.0e14;a[i+20>>0]=1;a[i+21>>0]=0;c[i+24>>2]=-1;j=i+28|0;c[j>>2]=b;b=i+32|0;c[b>>2]=d;g[i+36>>2]=0.0;g[i+40>>2]=.30000001192092896;c[i+44>>2]=0;c[i>>2]=4596;a[i+48>>0]=0;d=i+52|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=i+68|0;c[d>>2]=c[e+16>>2];c[d+4>>2]=c[e+16+4>>2];c[d+8>>2]=c[e+16+8>>2];c[d+12>>2]=c[e+16+12>>2];d=i+84|0;c[d>>2]=c[e+32>>2];c[d+4>>2]=c[e+32+4>>2];c[d+8>>2]=c[e+32+8>>2];c[d+12>>2]=c[e+32+12>>2];d=i+100|0;c[d>>2]=c[e+48>>2];c[d+4>>2]=c[e+48+4>>2];c[d+8>>2]=c[e+48+8>>2];c[d+12>>2]=c[e+48+12>>2];e=i+116|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=i+132|0;c[e>>2]=c[f+16>>2];c[e+4>>2]=c[f+16+4>>2];c[e+8>>2]=c[f+16+8>>2];c[e+12>>2]=c[f+16+12>>2];e=i+148|0;c[e>>2]=c[f+32>>2];c[e+4>>2]=c[f+32+4>>2];c[e+8>>2]=c[f+32+8>>2];c[e+12>>2]=c[f+32+12>>2];e=i+164|0;c[e>>2]=c[f+48>>2];c[e+4>>2]=c[f+48+4>>2];c[e+8>>2]=c[f+48+8>>2];c[e+12>>2]=c[f+48+12>>2];a[i+180>>0]=h&1;g[i+184>>2]=1.0;g[i+188>>2]=-1.0;g[i+192>>2]=0.0;g[i+196>>2]=0.0;g[i+200>>2]=1.0;g[i+204>>2]=.699999988079071;g[i+208>>2]=0.0;g[i+212>>2]=0.0;g[i+216>>2]=1.0;g[i+220>>2]=.699999988079071;g[i+224>>2]=0.0;g[i+228>>2]=0.0;g[i+264>>2]=1.0;g[i+268>>2]=.699999988079071;g[i+272>>2]=1.0;g[i+276>>2]=0.0;g[i+280>>2]=1.0;g[i+284>>2]=.699999988079071;g[i+288>>2]=1.0;g[i+292>>2]=0.0;g[i+232>>2]=1.0;g[i+236>>2]=.699999988079071;g[i+240>>2]=1.0;g[i+244>>2]=0.0;g[i+248>>2]=1.0;g[i+252>>2]=.699999988079071;g[i+256>>2]=1.0;g[i+260>>2]=0.0;a[i+1096>>0]=0;h=i+1100|0;g[i+1116>>2]=0.0;g[i+1120>>2]=0.0;g[i+1124>>2]=0.0;c[i+300>>2]=0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;a[h+12>>0]=0;a[i+49>>0]=1;kd(i,(c[j>>2]|0)+4|0,(c[b>>2]|0)+4|0);return i|0}function uf(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[6165]=(c[6165]|0)+1;g=c[d+24>>2]|0;if(!g){g=c[e+4>>2]|0;if(!((b[f+6>>1]&(g&65535))<<16>>16)){d=0;return d|0}if(!((b[f+4>>1]&(g>>>16&65535))<<16>>16)){d=0;return d|0}}else if(!(Ob[c[(c[g>>2]|0)+8>>2]&63](g,e,f)|0)){d=0;return d|0}l=(c[e+12>>2]|0)>(c[f+12>>2]|0);m=l?f:e;h=c[m+12>>2]|0;l=l?e:f;e=c[l+12>>2]|0;j=((e<<16|h)+~((e<<16|h)<<15)>>10^(e<<16|h)+~((e<<16|h)<<15))*9|0;j=(j>>6^j)+~((j>>6^j)<<11)>>16^(j>>6^j)+~((j>>6^j)<<11);k=c[d+12>>2]|0;g=c[(c[d+44>>2]|0)+((j&k+-1)<<2)>>2]|0;a:do if((g|0)!=-1){f=c[d+16>>2]|0;while(1){if((c[(c[f+(g<<4)>>2]|0)+12>>2]|0)==(h|0)?(c[(c[f+(g<<4)+4>>2]|0)+12>>2]|0)==(e|0):0)break;g=c[(c[d+64>>2]|0)+(g<<2)>>2]|0;if((g|0)==-1)break a}g=f+(g<<4)|0;if(g|0){d=g;return d|0}}while(0);i=c[d+8>>2]|0;if((i|0)==(k|0)){g=k|0?k<<1:1;if((k|0)<(g|0)){if(!g){e=0;f=k}else{c[6435]=(c[6435]|0)+1;e=yc((g<<4|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[d+8>>2]|0}if((f|0)>0){h=0;do{n=c[d+16>>2]|0;c[e+(h<<4)>>2]=c[n+(h<<4)>>2];c[e+(h<<4)+4>>2]=c[n+(h<<4)+4>>2];c[e+(h<<4)+8>>2]=c[n+(h<<4)+8>>2];c[e+(h<<4)+12>>2]=c[n+(h<<4)+12>>2];h=h+1|0}while((h|0)!=(f|0))}h=c[d+16>>2]|0;if(h){if(a[d+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0);f=c[d+8>>2]|0}c[d+16>>2]=0}a[d+20>>0]=1;c[d+16>>2]=e;c[d+12>>2]=g}else{f=k;g=k}}else{f=i;g=k}c[d+8>>2]=f+1;f=c[d+16>>2]|0;e=c[d+72>>2]|0;if(e){Ob[c[(c[e>>2]|0)+8>>2]&63](e,m,l)|0;g=c[d+12>>2]|0}if((k|0)<(g|0)){Hf(d);g=(c[d+12>>2]|0)+-1&j}else g=j&k+-1;n=(c[m+12>>2]|0)<(c[l+12>>2]|0);c[f+(i<<4)>>2]=n?m:l;c[f+(i<<4)+4>>2]=n?l:m;c[f+(i<<4)+8>>2]=0;c[f+(i<<4)+8+4>>2]=0;n=(c[d+44>>2]|0)+(g<<2)|0;c[(c[d+64>>2]|0)+(i<<2)>>2]=c[n>>2];c[n>>2]=i;n=f+(i<<4)|0;return n|0}function vf(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;u=+g[b>>2];t=+g[b+4>>2];s=+g[b+8>>2];r=1.0/+O(+(u*u+t*t+s*s));y=+g[d>>2];x=+g[d+4>>2];w=+g[d+8>>2];v=1.0/+O(+(y*y+x*x+w*w));B=s*r*x*v-t*r*w*v;A=u*r*w*v-s*r*y*v;z=t*r*y*v-u*r*x*v;d=c[a+28>>2]|0;e=+g[d+4>>2];h=+g[d+20>>2];j=+g[d+36>>2];f=+g[d+8>>2];i=+g[d+24>>2];k=+g[d+40>>2];l=+g[d+12>>2];n=+g[d+28>>2];p=+g[d+44>>2];m=-+g[d+52>>2];o=-+g[d+56>>2];q=-+g[d+60>>2];g[a+48>>2]=z*j+(e*B+h*A);g[a+52>>2]=e*y*v+x*v*h+w*v*j;g[a+56>>2]=u*r*e+t*r*h+s*r*j;g[a+60>>2]=0.0;g[a+64>>2]=B*f+A*i+z*k;g[a+68>>2]=y*v*f+x*v*i+w*v*k;g[a+72>>2]=u*r*f+t*r*i+s*r*k;g[a+76>>2]=0.0;g[a+80>>2]=B*l+A*n+z*p;g[a+84>>2]=y*v*l+x*v*n+w*v*p;g[a+88>>2]=u*r*l+t*r*n+s*r*p;g[a+92>>2]=0.0;g[a+96>>2]=e*0.0+h*0.0+j*0.0+(e*m+h*o+j*q);g[a+100>>2]=f*0.0+i*0.0+k*0.0+(f*m+i*o+k*q);g[a+104>>2]=l*0.0+n*0.0+p*0.0+(l*m+n*o+p*q);g[a+108>>2]=0.0;d=c[a+32>>2]|0;q=+g[d+4>>2];p=+g[d+20>>2];o=+g[d+36>>2];n=+g[d+8>>2];m=+g[d+24>>2];l=+g[d+40>>2];k=+g[d+12>>2];i=+g[d+28>>2];f=+g[d+44>>2];j=-+g[d+52>>2];h=-+g[d+56>>2];e=-+g[d+60>>2];g[a+112>>2]=B*q+A*p+z*o;g[a+116>>2]=y*v*q+x*v*p+w*v*o;g[a+120>>2]=u*r*q+t*r*p+s*r*o;g[a+124>>2]=0.0;g[a+128>>2]=B*n+A*m+z*l;g[a+132>>2]=y*v*n+x*v*m+w*v*l;g[a+136>>2]=u*r*n+t*r*m+s*r*l;g[a+140>>2]=0.0;g[a+144>>2]=B*k+A*i+z*f;g[a+148>>2]=y*v*k+x*v*i+w*v*f;g[a+152>>2]=u*r*k+t*r*i+s*r*f;g[a+156>>2]=0.0;g[a+160>>2]=q*0.0+p*0.0+o*0.0+(q*j+p*h+o*e);g[a+164>>2]=n*0.0+m*0.0+l*0.0+(n*j+m*h+l*e);g[a+168>>2]=k*0.0+i*0.0+f*0.0+(k*j+i*h+f*e);g[a+172>>2]=0.0;sd(a,(c[a+28>>2]|0)+4|0,(c[a+32>>2]|0)+4|0);return}function wf(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0.0,l=0,m=0,n=0,o=0.0;n=i;i=i+16|0;c[6138]=(c[6138]|0)+1;if(!(c[b+4>>2]&2))f=4972;else{f=c[d+192>>2]|0;o=+cc[c[(c[f>>2]|0)+20>>2]&1](f,.019999999552965164);g[n+4>>2]=o;f=c[e+192>>2]|0;k=+cc[c[(c[f>>2]|0)+20>>2]&1](f,.019999999552965164);g[n>>2]=k;f=o<k?n+4|0:n}j=c[f>>2]|0;o=+g[d+184>>2];k=+g[e+184>>2];k=o<k?o:k;f=c[b+68>>2]|0;h=c[f+8>>2]|0;if(!h){if(c[b+4>>2]&4|0){b=0;i=n;return b|0}c[6435]=(c[6435]|0)+1;f=yc(791)|0;if(!f)l=0;else{c[(f+4+15&-16)+-4>>2]=f;l=f+4+15&-16}}else{l=c[f+12>>2]|0;c[f+12>>2]=c[l>>2];c[f+8>>2]=h+-1}c[l>>2]=1025;c[l+116>>2]=0;a[l+120>>0]=0;f=l+124|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[l+300>>2]=0;a[l+304>>0]=0;f=l+308|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[l+484>>2]=0;a[l+488>>0]=0;f=l+492|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[l+668>>2]=0;a[l+672>>0]=0;f=l+676|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;c[l+740>>2]=d;c[l+744>>2]=e;c[l+748>>2]=0;c[l+752>>2]=j;g[l+756>>2]=k;d=l;f=c[b+12>>2]|0;c[l+768>>2]=f;if((f|0)==(c[b+16>>2]|0)?(m=f|0?f<<1:1,(f|0)<(m|0)):0){if(!m)j=0;else{c[6435]=(c[6435]|0)+1;f=yc((m<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}j=f;f=c[b+12>>2]|0}if((f|0)>0){h=0;do{c[j+(h<<2)>>2]=c[(c[b+20>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}h=c[b+20>>2]|0;if(h){if(a[b+24>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0);f=c[b+12>>2]|0}c[b+20>>2]=0}a[b+24>>0]=1;c[b+20>>2]=j;c[b+16>>2]=m}c[(c[b+20>>2]|0)+(f<<2)>>2]=d;c[b+12>>2]=f+1;b=l;i=n;return b|0}function xf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0,x=0;w=i;i=i+32|0;s=c[a+12>>2]|0;t=+g[s+(((e+d|0)/2|0)*24|0)>>2];u=+g[s+(((e+d|0)/2|0)*24|0)+4>>2];v=+g[s+(((e+d|0)/2|0)*24|0)+8>>2];q=+g[s+(((e+d|0)/2|0)*24|0)+16>>2];r=c[s+(((e+d|0)/2|0)*24|0)+20>>2]|0;f=d;h=e;while(1){m=+g[b>>2];n=+g[b+4>>2];o=+g[b+8>>2];p=(t-m)*(t-m)+(u-n)*(u-n)+(v-o)*(v-o);a:while(1){j=+g[s+(f*24|0)+16>>2];do if(j!=q){if(!(j<q))break a}else{j=+g[s+(f*24|0)>>2]-m;k=+g[s+(f*24|0)+4>>2]-n;l=+g[s+(f*24|0)+8>>2]-o;if(j*j+k*k+l*l!=p)if(j*j+k*k+l*l<p)break;else break a;else if((c[s+(f*24|0)+20>>2]|0)<(r|0))break;else break a}while(0);f=f+1|0}b:while(1){j=+g[s+(h*24|0)+16>>2];do if(q!=j){if(!(q<j))break b}else{j=+g[s+(h*24|0)>>2]-m;k=+g[s+(h*24|0)+4>>2]-n;l=+g[s+(h*24|0)+8>>2]-o;if(p!=j*j+k*k+l*l)if(p<j*j+k*k+l*l)break;else break b;else if((r|0)<(c[s+(h*24|0)+20>>2]|0))break;else break b}while(0);h=h+-1|0}if((f|0)<=(h|0)){x=s+(f*24|0)|0;c[w>>2]=c[x>>2];c[w+4>>2]=c[x+4>>2];c[w+8>>2]=c[x+8>>2];c[w+12>>2]=c[x+12>>2];c[w+16>>2]=c[x+16>>2];c[w+20>>2]=c[x+20>>2];s=s+(h*24|0)|0;c[x>>2]=c[s>>2];c[x+4>>2]=c[s+4>>2];c[x+8>>2]=c[s+8>>2];c[x+12>>2]=c[s+12>>2];c[x+16>>2]=c[s+16>>2];c[x+20>>2]=c[s+20>>2];s=(c[a+12>>2]|0)+(h*24|0)|0;c[s>>2]=c[w>>2];c[s+4>>2]=c[w+4>>2];c[s+8>>2]=c[w+8>>2];c[s+12>>2]=c[w+12>>2];c[s+16>>2]=c[w+16>>2];c[s+20>>2]=c[w+20>>2];f=f+1|0;h=h+-1|0}if((f|0)>(h|0))break;s=c[a+12>>2]|0}if((h|0)>(d|0))xf(a,b,d,h);if((f|0)>=(e|0)){i=w;return}xf(a,b,f,e);i=w;return}function yf(a,b,d){a=a|0;b=+b;d=+d;var e=0.0,f=0,h=0,i=0,j=0,l=0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0,y=0,z=0;z=c[a+832>>2]|0;if((z|0)<=0)return;n=c[a+840>>2]|0;y=0;do{u=c[n+(y*56|0)>>2]|0;x=c[n+(y*56|0)+4>>2]|0;a=c[x+8>>2]|0;f=c[x+12>>2]|0;h=c[x+16>>2]|0;i=n+(y*56|0)+8|0;v=+g[i>>2];j=n+(y*56|0)+12|0;t=+g[j>>2];l=n+(y*56|0)+16|0;s=+g[l>>2];b=+g[a+8>>2]*v+ +g[f+8>>2]*t+ +g[h+8>>2]*s;d=+g[a+12>>2]*v+ +g[f+12>>2]*t+ +g[h+12>>2]*s;e=+g[a+16>>2]*v+ +g[f+16>>2]*t+ +g[h+16>>2]*s;m=+g[u+8>>2];o=+g[u+12>>2];p=+g[u+16>>2];q=m-+g[u+24>>2]-(b-(v*+g[a+24>>2]+t*+g[f+24>>2]+s*+g[h+24>>2]));r=o-+g[u+28>>2]-(d-(v*+g[a+28>>2]+t*+g[f+28>>2]+s*+g[h+28>>2]));s=p-+g[u+32>>2]-(e-(v*+g[a+32>>2]+t*+g[f+32>>2]+s*+g[h+32>>2]));t=+g[n+(y*56|0)+24>>2];v=+g[n+(y*56|0)+28>>2];w=+g[n+(y*56|0)+32>>2];if(q*t+r*v+s*w<0.0){e=+g[n+(y*56|0)+40>>2]-(m*t+o*v+p*w-(b*t+d*v+e*w));a=(g[k>>2]=t*e+0.0,c[k>>2]|0);f=(g[k>>2]=v*e+0.0,c[k>>2]|0);h=(g[k>>2]=w*e+0.0,c[k>>2]|0)}else{a=0;f=0;h=0}b=+g[n+(y*56|0)+44>>2];d=(c[k>>2]=a,+g[k>>2])-b*(q-t*(q*t+r*v+s*w));e=(c[k>>2]=f,+g[k>>2])-b*(r-v*(q*t+r*v+s*w));v=(c[k>>2]=h,+g[k>>2])-b*(s-w*(q*t+r*v+s*w));w=+g[n+(y*56|0)+48>>2];g[u+8>>2]=m+w*d;g[u+12>>2]=o+w*e;g[u+16>>2]=w*v+p;h=c[x+8>>2]|0;u=n+(y*56|0)+52|0;w=+g[u>>2]*+g[i>>2];g[h+8>>2]=+g[h+8>>2]-d*w;g[h+12>>2]=+g[h+12>>2]-e*w;g[h+16>>2]=+g[h+16>>2]-v*w;i=c[x+12>>2]|0;w=+g[u>>2]*+g[j>>2];g[i+8>>2]=+g[i+8>>2]-d*w;g[i+12>>2]=+g[i+12>>2]-e*w;g[i+16>>2]=+g[i+16>>2]-v*w;x=c[x+16>>2]|0;w=+g[u>>2]*+g[l>>2];g[x+8>>2]=+g[x+8>>2]-d*w;g[x+12>>2]=+g[x+12>>2]-e*w;g[x+16>>2]=+g[x+16>>2]-v*w;y=y+1|0}while((y|0)!=(z|0));return}function zf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;c[6164]=(c[6164]|0)+1;j=(c[b+12>>2]|0)>(c[d+12>>2]|0);l=j?d:b;h=c[l+12>>2]|0;j=j?b:d;f=c[j+12>>2]|0;i=((f<<16|h)+~((f<<16|h)<<15)>>10^(f<<16|h)+~((f<<16|h)<<15))*9|0;i=((i>>6^i)+~((i>>6^i)<<11)>>16^(i>>6^i)+~((i>>6^i)<<11))&(c[a+12>>2]|0)+-1;b=c[(c[a+44>>2]|0)+(i<<2)>>2]|0;if((b|0)==-1){o=0;return o|0}g=c[a+16>>2]|0;d=b;while(1){if((c[(c[g+(d<<4)>>2]|0)+12>>2]|0)==(h|0)?(c[(c[g+(d<<4)+4>>2]|0)+12>>2]|0)==(f|0):0)break;b=c[(c[a+64>>2]|0)+(d<<2)>>2]|0;if((b|0)==-1){b=0;o=24;break}else d=b}if((o|0)==24)return b|0;b=g+(d<<4)|0;if(!b){o=0;return o|0}ic[c[(c[a>>2]|0)+32>>2]&127](a,b,e);n=c[g+(d<<4)+12>>2]|0;m=b-(c[a+16>>2]|0)>>4;h=(c[a+44>>2]|0)+(i<<2)|0;b=c[h>>2]|0;d=c[a+64>>2]|0;if((b|0)!=(m|0)){g=b;while(1){f=d+(g<<2)|0;b=c[f>>2]|0;if((b|0)==(m|0))break;else g=b}b=c[d+(m<<2)>>2]|0;if((g|0)==-1)o=12;else c[f>>2]=b}else{b=c[d+(m<<2)>>2]|0;o=12}if((o|0)==12)c[h>>2]=b;k=(c[a+8>>2]|0)+-1|0;b=c[a+72>>2]|0;if(b|0)Ib[c[(c[b>>2]|0)+12>>2]&31](b,l,j,e)|0;if((k|0)==(m|0)){c[a+8>>2]=(c[a+8>>2]|0)+-1;o=n;return o|0}j=c[a+16>>2]|0;h=c[(c[j+(k<<4)+4>>2]|0)+12>>2]<<16|c[(c[j+(k<<4)>>2]|0)+12>>2];h=(h+~(h<<15)>>10^h+~(h<<15))*9|0;h=((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11))&(c[a+12>>2]|0)+-1;i=(c[a+44>>2]|0)+(h<<2)|0;b=c[i>>2]|0;d=c[a+64>>2]|0;if((b|0)!=(k|0)){g=b;while(1){f=d+(g<<2)|0;b=c[f>>2]|0;if((b|0)==(k|0))break;else g=b}b=c[d+(k<<2)>>2]|0;if((g|0)==-1)o=22;else c[f>>2]=b}else{b=c[d+(k<<2)>>2]|0;o=22}if((o|0)==22)c[i>>2]=b;c[j+(m<<4)>>2]=c[j+(k<<4)>>2];c[j+(m<<4)+4>>2]=c[j+(k<<4)+4>>2];c[j+(m<<4)+8>>2]=c[j+(k<<4)+8>>2];c[j+(m<<4)+12>>2]=c[j+(k<<4)+12>>2];o=(c[a+44>>2]|0)+(h<<2)|0;c[(c[a+64>>2]|0)+(m<<2)>>2]=c[o>>2];c[o>>2]=m;c[a+8>>2]=(c[a+8>>2]|0)+-1;o=n;return o|0}function Af(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0.0,v=0,w=0.0,x=0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0;z=(a[b+28>>0]|0)!=0;C=z?e:d;z=z?d:e;A=c[b+12>>2]|0;if((A|0)<=0){w=1.0;return +w}y=(c[C+192>>2]|0)+24|0;j=+g[C+4>>2];t=+g[C+8>>2];u=+g[C+12>>2];v=c[C+16>>2]|0;w=+g[C+20>>2];k=+g[C+24>>2];l=+g[C+28>>2];d=c[C+32>>2]|0;m=+g[C+36>>2];n=+g[C+40>>2];o=+g[C+44>>2];e=c[C+48>>2]|0;p=+g[C+52>>2];q=+g[C+56>>2];r=+g[C+60>>2];s=c[C+64>>2]|0;x=c[C+260>>2]|0;i=1.0;B=0;do{E=c[y>>2]|0;P=+g[E+(B*80|0)>>2];O=+g[E+(B*80|0)+16>>2];N=+g[E+(B*80|0)+32>>2];M=+g[E+(B*80|0)+4>>2];L=+g[E+(B*80|0)+20>>2];K=+g[E+(B*80|0)+36>>2];J=+g[E+(B*80|0)+8>>2];I=+g[E+(B*80|0)+24>>2];H=+g[E+(B*80|0)+40>>2];G=+g[E+(B*80|0)+48>>2];F=+g[E+(B*80|0)+52>>2];D=+g[E+(B*80|0)+56>>2];c[C+260>>2]=x+1;g[C+4>>2]=j*P+t*O+u*N;g[C+8>>2]=j*M+t*L+u*K;g[C+12>>2]=j*J+t*I+u*H;g[C+16>>2]=0.0;g[C+20>>2]=w*P+k*O+l*N;g[C+24>>2]=w*M+k*L+l*K;g[C+28>>2]=w*J+k*I+l*H;g[C+32>>2]=0.0;g[C+36>>2]=m*P+n*O+o*N;g[C+40>>2]=m*M+n*L+o*K;g[C+44>>2]=m*J+n*I+o*H;g[C+48>>2]=0.0;g[C+52>>2]=p+(j*G+t*F+u*D);g[C+56>>2]=q+(w*G+k*F+l*D);g[C+60>>2]=r+(m*G+n*F+o*D);g[C+64>>2]=0.0;E=c[(c[b+20>>2]|0)+(B<<2)>>2]|0;D=+Mb[c[(c[E>>2]|0)+12>>2]&15](E,C,z,f,h);i=D<i?D:i;x=(c[C+260>>2]|0)+1|0;c[C+260>>2]=x;g[C+4>>2]=j;g[C+8>>2]=t;g[C+12>>2]=u;c[C+16>>2]=v;g[C+20>>2]=w;g[C+24>>2]=k;g[C+28>>2]=l;c[C+32>>2]=d;g[C+36>>2]=m;g[C+40>>2]=n;g[C+44>>2]=o;c[C+48>>2]=e;g[C+52>>2]=p;g[C+56>>2]=q;g[C+60>>2]=r;c[C+64>>2]=s;B=B+1|0}while((B|0)!=(A|0));return +i}function Bf(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+32|0;a[p+16>>0]=1;c[p+12>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;e=c[b+8>>2]|0;if((e|0)>0){g=0;h=0;f=0;n=0;while(1){l=c[b+16>>2]|0;m=l+(n<<4)|0;if((g|0)==(f|0)){k=f|0?f<<1:1;if((f|0)<(k|0)){if(k){c[6435]=(c[6435]|0)+1;e=yc((k<<4|3)+16|0)|0;if(!e){j=0;f=g}else{c[(e+4+15&-16)+-4>>2]=e;j=e+4+15&-16;f=g}}else j=0;if((f|0)>0){e=0;do{h=c[p+12>>2]|0;c[j+(e<<4)>>2]=c[h+(e<<4)>>2];c[j+(e<<4)+4>>2]=c[h+(e<<4)+4>>2];c[j+(e<<4)+8>>2]=c[h+(e<<4)+8>>2];c[j+(e<<4)+12>>2]=c[h+(e<<4)+12>>2];e=e+1|0}while((e|0)!=(f|0))}e=c[p+12>>2]|0;if(!e)g=f;else{c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);c[p+12>>2]=0}a[p+16>>0]=1;c[p+12>>2]=j;c[p+8>>2]=k;e=c[b+8>>2]|0;h=g}else{k=f;j=h;h=f}}else{k=f;j=h;h=g}c[j+(h<<4)>>2]=c[m>>2];c[j+(h<<4)+4>>2]=c[l+(n<<4)+4>>2];c[j+(h<<4)+8>>2]=c[l+(n<<4)+8>>2];c[j+(h<<4)+12>>2]=c[l+(n<<4)+12>>2];g=h+1|0;n=n+1|0;if((n|0)>=(e|0))break;else{h=j;f=k}}c[p+4>>2]=g;if((h|0)>-1){e=c[p+12>>2]|0;f=0;while(1){Ib[c[(c[b>>2]|0)+12>>2]&31](b,c[e+(f<<4)>>2]|0,c[e+(f<<4)+4>>2]|0,d)|0;if((f|0)<(h|0))f=f+1|0;else break}}}else g=0;if((c[b+56>>2]|0)>0){e=c[b+64>>2]|0;f=0;do{c[e+(f<<2)>>2]=-1;f=f+1|0}while((f|0)<(c[b+56>>2]|0))}if((g|0)<=1)if((g|0)>0)o=24;else e=c[p+12>>2]|0;else{Vd(p,0,g+-1|0);o=24}if((o|0)==24){e=c[p+12>>2]|0;f=0;do{Ob[c[(c[b>>2]|0)+8>>2]&63](b,c[e+(f<<4)>>2]|0,c[e+(f<<4)+4>>2]|0)|0;f=f+1|0}while((f|0)<(g|0))}if(!e){i=p;return}c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);c[p+12>>2]=0;i=p;return}function Cf(a,b,d){a=a|0;b=+b;d=+d;var e=0,f=0,h=0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0,A=0.0,B=0.0,C=0.0,D=0.0;z=i;i=i+16|0;q=+g[a+452>>2];x=c[a+192>>2]|0;v=+Sb[c[(c[x>>2]|0)+48>>2]&15](x);x=c[a+812>>2]|0;if((x|0)<=0){i=z;return}y=0;do{r=c[a+820>>2]|0;p=c[r+(y*104|0)>>2]|0;p=(c[p+236>>2]&2|0)==0?0:p;if(p|0){u=+g[p+332>>2];n=+g[r+(y*104|0)+84>>2];m=+g[p+336>>2];o=+g[r+(y*104|0)+80>>2];w=+g[r+(y*104|0)+76>>2];t=+g[p+328>>2];e=(g[k>>2]=q*(u*n-m*o+ +g[p+312>>2]),c[k>>2]|0);f=(g[k>>2]=q*(+g[p+316>>2]+(m*w-n*t)),c[k>>2]|0);h=(g[k>>2]=q*(o*t-u*w+ +g[p+320>>2]),c[k>>2]|0)}else{e=0;f=0;h=0}s=c[r+(y*104|0)+24>>2]|0;t=+g[s+8>>2];u=+g[s+12>>2];w=+g[s+16>>2];o=t-+g[s+24>>2]-(c[k>>2]=e,+g[k>>2]);n=u-+g[s+28>>2]-(c[k>>2]=f,+g[k>>2]);d=w-+g[s+32>>2]-(c[k>>2]=h,+g[k>>2]);j=+g[r+(y*104|0)+4>>2];l=+g[r+(y*104|0)+8>>2];m=+g[r+(y*104|0)+12>>2];if(o*j+n*l+d*m<=1.1920928955078125e-07?(C=t*j+u*l+w*m+ +g[r+(y*104|0)+20>>2],D=+g[r+(y*104|0)+96>>2],C=(C<v?C:v)*+g[r+(y*104|0)+100>>2],B=(o-(o-j*(o*j+n*l+d*m))*D+j*C)*b,A=(n-(n-l*(o*j+n*l+d*m))*D+C*l)*b,o=(d-(d-m*(o*j+n*l+d*m))*D+C*m)*b,l=+g[r+(y*104|0)+28>>2]*B+ +g[r+(y*104|0)+32>>2]*A+ +g[r+(y*104|0)+36>>2]*o,m=B*+g[r+(y*104|0)+44>>2]+A*+g[r+(y*104|0)+48>>2]+o*+g[r+(y*104|0)+52>>2],o=B*+g[r+(y*104|0)+60>>2]+A*+g[r+(y*104|0)+64>>2]+o*+g[r+(y*104|0)+68>>2],g[z>>2]=l,g[z+4>>2]=m,g[z+8>>2]=o,g[z+12>>2]=0.0,n=+g[r+(y*104|0)+92>>2],g[s+8>>2]=t-l*n,g[s+12>>2]=u-n*m,g[s+16>>2]=w-n*o,p|0):0)gj(p,z,r+(y*104|0)+76|0);y=y+1|0}while((y|0)!=(x|0));i=z;return}
function Sc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0;s=i;i=i+240|0;n=c[b+48>>2]|0;k=c[b+52>>2]|0;if((k|0?(h=c[k+20>>2]|0,h|0):0)?(Eb[c[(c[h>>2]|0)+48>>2]&127](h)|0)&1|0:0){c[s+144>>2]=1065353216;c[s+144+4>>2]=1065353216;c[s+144+8>>2]=0;g[s+144+12>>2]=0.0;l=c[b+8>>2]|0;r=c[(c[b+52>>2]|0)+20>>2]|0;q=c[(c[r>>2]|0)+8>>2]|0;t=+g[d>>2];u=+g[d+4>>2];v=+g[d+8>>2];w=t*+g[l+20>>2]+u*+g[l+24>>2]+v*+g[l+28>>2]+ +g[l+56>>2];x=t*+g[l+36>>2]+u*+g[l+40>>2]+v*+g[l+44>>2]+ +g[l+60>>2];g[s+128>>2]=t*+g[l+4>>2]+u*+g[l+8>>2]+v*+g[l+12>>2]+ +g[l+52>>2];g[s+128+4>>2]=w;g[s+128+8>>2]=x;g[s+128+12>>2]=0.0;x=+g[d+16>>2];w=+g[d+20>>2];v=+g[d+24>>2];u=x*+g[l+20>>2]+w*+g[l+24>>2]+v*+g[l+28>>2]+ +g[l+56>>2];t=x*+g[l+36>>2]+w*+g[l+40>>2]+v*+g[l+44>>2]+ +g[l+60>>2];g[s+88>>2]=x*+g[l+4>>2]+w*+g[l+8>>2]+v*+g[l+12>>2]+ +g[l+52>>2];g[s+88+4>>2]=u;g[s+88+8>>2]=t;g[s+88+12>>2]=0.0;mc[q&127](r,s+128|0,s+88|0,s+144|0);r=c[(c[b+52>>2]|0)+20>>2]|0;q=c[(c[r>>2]|0)+8>>2]|0;t=+g[d+16>>2];u=+g[d+20>>2];v=+g[d+24>>2];w=t*+g[l+20>>2]+u*+g[l+24>>2]+v*+g[l+28>>2]+ +g[l+56>>2];x=t*+g[l+36>>2]+u*+g[l+40>>2]+v*+g[l+44>>2]+ +g[l+60>>2];g[s+72>>2]=t*+g[l+4>>2]+u*+g[l+8>>2]+v*+g[l+12>>2]+ +g[l+52>>2];g[s+72+4>>2]=w;g[s+72+8>>2]=x;g[s+72+12>>2]=0.0;x=+g[d+32>>2];w=+g[d+36>>2];v=+g[d+40>>2];u=x*+g[l+20>>2]+w*+g[l+24>>2]+v*+g[l+28>>2]+ +g[l+56>>2];t=x*+g[l+36>>2]+w*+g[l+40>>2]+v*+g[l+44>>2]+ +g[l+60>>2];g[s+56>>2]=x*+g[l+4>>2]+w*+g[l+8>>2]+v*+g[l+12>>2]+ +g[l+52>>2];g[s+56+4>>2]=u;g[s+56+8>>2]=t;g[s+56+12>>2]=0.0;mc[q&127](r,s+72|0,s+56|0,s+144|0);r=c[(c[b+52>>2]|0)+20>>2]|0;q=c[(c[r>>2]|0)+8>>2]|0;t=+g[d+32>>2];u=+g[d+36>>2];v=+g[d+40>>2];w=t*+g[l+20>>2]+u*+g[l+24>>2]+v*+g[l+28>>2]+ +g[l+56>>2];x=t*+g[l+36>>2]+u*+g[l+40>>2]+v*+g[l+44>>2]+ +g[l+60>>2];g[s+16>>2]=t*+g[l+4>>2]+u*+g[l+8>>2]+v*+g[l+12>>2]+ +g[l+52>>2];g[s+16+4>>2]=w;g[s+16+8>>2]=x;g[s+16+12>>2]=0.0;x=+g[d>>2];w=+g[d+4>>2];v=+g[d+8>>2];u=x*+g[l+20>>2]+w*+g[l+24>>2]+v*+g[l+28>>2]+ +g[l+56>>2];t=x*+g[l+36>>2]+w*+g[l+40>>2]+v*+g[l+44>>2]+ +g[l+60>>2];g[s>>2]=x*+g[l+4>>2]+w*+g[l+8>>2]+v*+g[l+12>>2]+ +g[l+52>>2];g[s+4>>2]=u;g[s+8>>2]=t;g[s+12>>2]=0.0;mc[q&127](r,s+16|0,s,s+144|0)}h=((e<<21|f)+~(f<<15)>>10^(e<<21|f)+~(f<<15))*9|0;h=(c[b+108>>2]|0)+-1&((h>>6^h)+~((h>>6^h)<<11)>>16^(h>>6^h)+~((h>>6^h)<<11));a:do if(h>>>0<(c[b+64>>2]|0)>>>0?(m=c[(c[b+72>>2]|0)+(h<<2)>>2]|0,(m|0)!=-1):0){l=c[b+132>>2]|0;k=m;while(1){if((e<<21|f|0)==(c[l+(k<<2)>>2]|0))break;h=c[(c[b+92>>2]|0)+(k<<2)>>2]|0;if((h|0)==-1)break a;else k=h}h=c[b+112>>2]|0;if(h+(k<<3)|0){q=c[h+(k<<3)+4>>2]|0;r=c[b+8>>2]|0;c[q+8>>2]=c[(c[r+192>>2]|0)+8>>2];p=c[b+4>>2]|0;o=c[p+192>>2]|0;c[s+144>>2]=0;c[s+144+4>>2]=o;c[s+144+8>>2]=p;c[s+144+12>>2]=p+4;c[s+144+16>>2]=-1;c[s+144+20>>2]=-1;c[s+104>>2]=0;c[s+104+4>>2]=q;c[s+104+8>>2]=r;c[s+104+12>>2]=r+4;c[s+104+16>>2]=e;c[s+104+20>>2]=f;r=Ib[c[(c[n>>2]|0)+8>>2]&31](n,s+144|0,s+104|0,0)|0;yb[c[(c[r>>2]|0)+8>>2]&31](r,s+144|0,s+104|0,c[b+52>>2]|0,c[b+44>>2]|0);Ab[c[c[r>>2]>>2]&255](r);Cb[c[(c[n>>2]|0)+60>>2]&127](n,r);i=s;return}}while(0);C=+g[d+16>>2];F=+g[d>>2];B=+g[d+20>>2];E=+g[d+4>>2];A=+g[d+24>>2];D=+g[d+8>>2];z=+g[d+32>>2];t=+g[d+36>>2];v=+g[d+40>>2];y=(B-E)*(v-D)-(A-D)*(t-E);u=(A-D)*(z-F)-(C-F)*(v-D);x=(C-F)*(t-E)-(B-E)*(z-F);w=1.0/+O(+(x*x+(y*y+u*u)));g[s+144>>2]=F+w*y*.05999999865889549;g[s+144+4>>2]=E+w*u*.05999999865889549;g[s+144+8>>2]=w*x*.05999999865889549+D;g[s+144+12>>2]=0.0;g[s+144+16>>2]=w*y*.05999999865889549+C;g[s+144+20>>2]=w*u*.05999999865889549+B;g[s+144+24>>2]=w*x*.05999999865889549+A;g[s+144+28>>2]=0.0;g[s+144+32>>2]=w*y*.05999999865889549+z;g[s+144+36>>2]=w*u*.05999999865889549+t;g[s+144+40>>2]=w*x*.05999999865889549+v;g[s+144+44>>2]=0.0;g[s+144+48>>2]=F-w*y*.05999999865889549;g[s+144+52>>2]=E-w*u*.05999999865889549;g[s+144+56>>2]=D-w*x*.05999999865889549;g[s+144+60>>2]=0.0;g[s+144+64>>2]=C-w*y*.05999999865889549;g[s+144+68>>2]=B-w*u*.05999999865889549;g[s+144+72>>2]=A-w*x*.05999999865889549;g[s+144+76>>2]=0.0;g[s+144+80>>2]=z-w*y*.05999999865889549;g[s+144+84>>2]=t-w*u*.05999999865889549;g[s+144+88>>2]=v-w*x*.05999999865889549;g[s+144+92>>2]=0.0;c[6435]=(c[6435]|0)+1;h=yc(131)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}kg(h,s+144|0,6,16);r=c[b+8>>2]|0;c[h+8>>2]=c[(c[r+192>>2]|0)+8>>2];q=c[b+4>>2]|0;d=c[q+192>>2]|0;c[s+104>>2]=0;c[s+104+4>>2]=d;c[s+104+8>>2]=q;c[s+104+12>>2]=q+4;c[s+104+16>>2]=-1;c[s+104+20>>2]=-1;c[s+32>>2]=0;c[s+32+4>>2]=h;c[s+32+8>>2]=r;c[s+32+12>>2]=r+4;c[s+32+16>>2]=e;c[s+32+20>>2]=f;r=Ib[c[(c[n>>2]|0)+8>>2]&31](n,s+104|0,s+32|0,0)|0;yb[c[(c[r>>2]|0)+8>>2]&31](r,s+104|0,s+32|0,c[b+52>>2]|0,c[b+44>>2]|0);Ab[c[c[r>>2]>>2]&255](r);Cb[c[(c[n>>2]|0)+60>>2]&127](n,r);r=((e<<21|f)+~(f<<15)>>10^(e<<21|f)+~(f<<15))*9|0;r=(r>>6^r)+~((r>>6^r)<<11)>>16^(r>>6^r)+~((r>>6^r)<<11);n=c[b+108>>2]|0;b:do if((r&n+-1)>>>0<(c[b+64>>2]|0)>>>0?(j=c[(c[b+72>>2]|0)+((r&n+-1)<<2)>>2]|0,(j|0)!=-1):0){k=c[b+132>>2]|0;while(1){if((e<<21|f|0)==(c[k+(j<<2)>>2]|0))break;j=c[(c[b+92>>2]|0)+(j<<2)>>2]|0;if((j|0)==-1){o=20;break b}}b=c[b+112>>2]|0;c[b+(j<<3)>>2]=e<<21|f;c[b+(j<<3)+4>>2]=h}else o=20;while(0);if((o|0)==20){q=c[b+104>>2]|0;if((q|0)==(n|0)){m=n|0?n<<1:1;if((n|0)<(m|0)){if(!m){j=0;k=n}else{c[6435]=(c[6435]|0)+1;j=yc((m<<3|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}k=c[b+104>>2]|0}if((k|0)>0){l=0;do{H=(c[b+112>>2]|0)+(l<<3)|0;G=c[H+4>>2]|0;d=j+(l<<3)|0;c[d>>2]=c[H>>2];c[d+4>>2]=G;l=l+1|0}while((l|0)!=(k|0))}k=c[b+112>>2]|0;if(k|0){if(a[b+116>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[k+-4>>2]|0)}c[b+112>>2]=0}a[b+116>>0]=1;c[b+112>>2]=j;c[b+108>>2]=m;j=c[b+104>>2]|0}else j=n}else j=q;H=c[b+112>>2]|0;c[H+(j<<3)>>2]=e<<21|f;c[H+(j<<3)+4>>2]=h;c[b+104>>2]=(c[b+104>>2]|0)+1;h=c[b+124>>2]|0;if((h|0)==(c[b+128>>2]|0)?(p=h|0?h<<1:1,(h|0)<(p|0)):0){if(!p)l=0;else{c[6435]=(c[6435]|0)+1;h=yc((p<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}l=h;h=c[b+124>>2]|0}k=c[b+132>>2]|0;if((h|0)<=0)if(!k)h=b+136|0;else o=43;else{j=0;do{c[l+(j<<2)>>2]=c[k+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0));o=43}if((o|0)==43){if(a[b+136>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[k+-4>>2]|0)}c[b+132>>2]=0;h=b+136|0}a[h>>0]=1;c[b+132>>2]=l;c[b+128>>2]=p;h=c[b+124>>2]|0}c[(c[b+132>>2]|0)+(h<<2)>>2]=e<<21|f;c[b+124>>2]=(c[b+124>>2]|0)+1;d=c[b+108>>2]|0;if((n|0)<(d|0)){n=c[b+64>>2]|0;if((d|0)>(n|0)){if((d|0)>=(n|0)){do if((c[b+68>>2]|0)<(d|0)){if(!d){h=0;j=n}else{c[6435]=(c[6435]|0)+1;h=yc((d<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}j=c[b+64>>2]|0}k=c[b+72>>2]|0;if((j|0)<=0){if(!k){a[b+76>>0]=1;c[b+72>>2]=h;c[b+68>>2]=d;break}}else{l=0;do{c[h+(l<<2)>>2]=c[k+(l<<2)>>2];l=l+1|0}while((l|0)!=(j|0))}if(a[b+76>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[k+-4>>2]|0)}a[b+76>>0]=1;c[b+72>>2]=h;c[b+68>>2]=d}else h=c[b+72>>2]|0;while(0);Qn(h+(n<<2)|0,0,d-n<<2|0)|0}c[b+64>>2]=d;m=c[b+84>>2]|0;if((d|0)>(m|0)){do if((c[b+88>>2]|0)<(d|0)){if(!d){h=0;j=m}else{c[6435]=(c[6435]|0)+1;h=yc((d<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}j=c[b+84>>2]|0}k=c[b+92>>2]|0;if((j|0)<=0){if(!k){a[b+96>>0]=1;c[b+92>>2]=h;c[b+88>>2]=d;break}}else{l=0;do{c[h+(l<<2)>>2]=c[k+(l<<2)>>2];l=l+1|0}while((l|0)!=(j|0))}if(a[b+96>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[k+-4>>2]|0)}a[b+96>>0]=1;c[b+92>>2]=h;c[b+88>>2]=d}else h=c[b+92>>2]|0;while(0);Qn(h+(m<<2)|0,0,d-m<<2|0)|0}c[b+84>>2]=d;if((d|0)>0){Qn(c[b+72>>2]|0,-1,d<<2|0)|0;Qn(c[b+92>>2]|0,-1,d<<2|0)|0}if((n|0)>0){h=c[b+132>>2]|0;j=c[b+72>>2]|0;k=c[b+92>>2]|0;l=0;do{H=c[h+(l<<2)>>2]|0;H=(H+~(H<<15)>>10^H+~(H<<15))*9|0;H=j+((((H>>6^H)+~((H>>6^H)<<11)>>16^(H>>6^H)+~((H>>6^H)<<11))&(c[b+108>>2]|0)+-1)<<2)|0;c[k+(l<<2)>>2]=c[H>>2];c[H>>2]=l;l=l+1|0}while((l|0)!=(n|0))}}h=r&(c[b+108>>2]|0)+-1}else h=r&n+-1;H=(c[b+72>>2]|0)+(h<<2)|0;c[(c[b+92>>2]|0)+(q<<2)>>2]=c[H>>2];c[H>>2]=q}i=s;return}function Tc(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;v=i;i=i+16|0;li(12170);k=c[b+212>>2]|0;j=c[b+180>>2]|0;if((j|0)<(k|0)){if((c[b+184>>2]|0)<(k|0)){if(!k){e=0;f=j}else{c[6435]=(c[6435]|0)+1;e=yc((k<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[b+180>>2]|0}if((f|0)>0){h=0;do{c[e+(h<<2)>>2]=c[(c[b+188>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}f=c[b+188>>2]|0;if(f|0){if(a[b+192>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+188>>2]=0}a[b+192>>0]=1;c[b+188>>2]=e;c[b+184>>2]=k;f=b+188|0}else f=b+188|0;e=j;do{c[(c[f>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=(k|0))}else f=b+188|0;c[b+180>>2]=k;e=0;while(1){if((e|0)>=(Eb[c[(c[b>>2]|0)+104>>2]&127](b)|0))break;c[(c[f>>2]|0)+(e<<2)>>2]=c[(c[b+220>>2]|0)+(e<<2)>>2];e=e+1|0}e=c[b+180>>2]|0;if((e|0)>1)bh(b+176|0,0,e+-1|0);if(!(Eb[c[(c[b>>2]|0)+104>>2]&127](b)|0))e=0;else e=c[f>>2]|0;h=c[b+196>>2]|0;t=c[b+180>>2]|0;u=Eb[c[(c[b>>2]|0)+20>>2]&127](b)|0;c[h+4>>2]=d;c[h+12>>2]=e;c[h+16>>2]=t;c[h+20>>2]=u;e=c[h+32>>2]|0;if((e|0)<0){if((c[h+36>>2]|0)<0){f=c[h+40>>2]|0;if(f|0){if(a[h+44>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[h+40>>2]=0}a[h+44>>0]=1;c[h+40>>2]=0;c[h+36>>2]=0}do{c[(c[h+40>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[h+32>>2]=0;e=c[h+52>>2]|0;if((e|0)<0){if((c[h+56>>2]|0)<0){f=c[h+60>>2]|0;if(f|0){if(a[h+64>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[h+60>>2]=0}a[h+64>>0]=1;c[h+60>>2]=0;c[h+56>>2]=0}do{c[(c[h+60>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[h+52>>2]=0;e=c[h+72>>2]|0;if((e|0)<0){if((c[h+76>>2]|0)<0){f=c[h+80>>2]|0;if(f|0){if(a[h+84>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[h+80>>2]=0}a[h+84>>0]=1;c[h+80>>2]=0;c[h+76>>2]=0}do{c[(c[h+80>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[h+72>>2]=0;u=c[b+200>>2]|0;e=c[(c[u>>2]|0)+8>>2]|0;s=c[b+8>>2]|0;t=c[b+24>>2]|0;t=Eb[c[(c[t>>2]|0)+36>>2]&127](t)|0;ic[e&127](u,s,t);t=c[b+204>>2]|0;s=c[b+24>>2]|0;u=c[b+196>>2]|0;li(13882);e=c[t+28>>2]|0;if((e|0)<0){if((c[t+32>>2]|0)<0){f=c[t+36>>2]|0;if(f|0){if(a[t+40>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[t+36>>2]=0}a[t+40>>0]=1;c[t+36>>2]=0;c[t+32>>2]=0}do{c[(c[t+36>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[t+28>>2]=0;j=c[t+8>>2]|0;if((j|0)>0){k=c[t+16>>2]|0;m=0;do{l=k+(m<<3)|0;e=c[l>>2]|0;if((e|0)==(m|0))e=m;else{f=e;h=l;do{e=k+(f<<3)|0;c[h>>2]=c[e>>2];e=c[e>>2]|0;h=k+(e<<3)|0;f=c[h>>2]|0}while((e|0)!=(f|0))}c[l>>2]=e;m=m+1|0}while((m|0)!=(j|0));if((j|0)>1){yj(t+4|0,0,j+-1|0);j=c[t+8>>2]|0}if((j|0)>0){m=c[t+16>>2]|0;f=0;while(1){n=c[m+(f<<3)>>2]|0;q=f;while(1){p=q+1|0;if((p|0)>=(j|0)){l=0;break}if((c[m+(p<<3)>>2]|0)==(n|0))q=p;else{l=1;break}}a:do if((f|0)<=(q|0)){o=c[b+16>>2]|0;e=1;k=f;while(1){h=c[o+(c[m+(k<<3)+4>>2]<<2)>>2]|0;if((c[h+208>>2]|0)==(n|0)){h=c[h+216>>2]|0;e=(h|0)!=4&(e&(h|0)!=1)}if((k|0)<(q|0))k=k+1|0;else break}if(e){e=m;while(1){e=c[o+(c[e+(f<<3)+4>>2]<<2)>>2]|0;if((c[e+208>>2]|0)==(n|0)?(c[e+216>>2]&-2|0)!=4:0)c[e+216>>2]=2;if((f|0)>=(q|0))break a;e=c[t+16>>2]|0;f=f+1|0}}else{e=m;while(1){e=c[o+(c[e+(f<<3)+4>>2]<<2)>>2]|0;if((c[e+208>>2]|0)==(n|0)?(c[e+216>>2]|0)==2:0){c[e+216>>2]=3;g[e+220>>2]=0.0}if((f|0)>=(q|0))break a;e=c[t+16>>2]|0;f=f+1|0}}}while(0);if(l)f=p;else break}}}j=Eb[c[(c[s>>2]|0)+36>>2]&127](s)|0;if((j|0)>0){l=0;do{k=Zb[c[(c[s>>2]|0)+40>>2]&31](s,l)|0;f=c[k+740>>2]|0;h=c[k+744>>2]|0;if((f|0)!=0?(c[f+216>>2]|0)!=2:0)e=92;else e=90;if(((e|0)==90?(e=0,h|0):0)?(c[h+216>>2]|0)!=2:0)e=92;if((e|0)==92){e=c[f+204>>2]|0;if((e&2|0?((e&4|0)==0?(c[f+216>>2]|0)!=2:0):0)?(c[h+204>>2]&3|0)==0:0){if((c[h+216>>2]&-2|0)!=4)c[h+216>>2]=1;g[h+220>>2]=0.0}q=c[h+204>>2]|0;if(q&2|0?((q&4|e&3|0)==0?(c[h+216>>2]|0)!=2:0):0){if((c[f+216>>2]&-2|0)!=4)c[f+216>>2]=1;g[f+220>>2]=0.0}if(a[t+64>>0]|0?Ob[c[(c[s>>2]|0)+28>>2]&63](s,f,h)|0:0){e=c[t+28>>2]|0;if((e|0)==(c[t+32>>2]|0)?(r=e|0?e<<1:1,(e|0)<(r|0)):0){if(!r)h=0;else{c[6435]=(c[6435]|0)+1;e=yc((r<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=e;e=c[t+28>>2]|0}if((e|0)>0){f=0;do{c[h+(f<<2)>>2]=c[(c[t+36>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(e|0))}f=c[t+36>>2]|0;if(f){if(a[t+40>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0);e=c[t+28>>2]|0}c[t+36>>2]=0}a[t+40>>0]=1;c[t+36>>2]=h;c[t+32>>2]=r}c[(c[t+36>>2]|0)+(e<<2)>>2]=k;c[t+28>>2]=e+1}}l=l+1|0}while((l|0)<(j|0))}e=c[2357]|0;r=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=r;do if(!r){if(c[e+4>>2]|0){tb(v|0,0)|0;r=c[6434]|0;g[e+8>>2]=+g[e+8>>2]+ +(((c[v+4>>2]|0)-(c[r+4>>2]|0)+(((c[v>>2]|0)-(c[r>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3;if(c[e+16>>2]|0)break;e=c[2357]|0}c[2357]=c[e+20>>2]}while(0);r=c[t+8>>2]|0;li(13910);if(a[t+64>>0]|0){p=c[t+28>>2]|0;if((p|0)>1)$g(t+24|0,0,p+-1|0);if((r|0)>0){n=1;f=0;q=0;while(1){e=c[t+16>>2]|0;o=c[e+(f<<3)>>2]|0;b:do if((f|0)<(r|0)){k=c[t+48>>2]|0;h=c[t+52>>2]|0;m=1;while(1){l=c[(c[b+16>>2]|0)+(c[e+(f<<3)+4>>2]<<2)>>2]|0;do if((k|0)==(h|0)){k=h|0?h<<1:1;if((h|0)>=(k|0)){e=h;break}if(!k)e=0;else{c[6435]=(c[6435]|0)+1;e=yc((k<<2|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}h=c[t+48>>2]|0}if((h|0)>0){j=0;do{c[e+(j<<2)>>2]=c[(c[t+56>>2]|0)+(j<<2)>>2];j=j+1|0}while((j|0)!=(h|0))}j=c[t+56>>2]|0;if(j){if(a[t+60>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0);h=c[t+48>>2]|0}c[t+56>>2]=0}a[t+60>>0]=1;c[t+56>>2]=e;c[t+52>>2]=k;e=h;h=k}else e=k;while(0);c[(c[t+56>>2]|0)+(e<<2)>>2]=l;k=e+1|0;c[t+48>>2]=k;j=c[l+216>>2]|0;j=m&((j|0)==2|(j|0)==5);f=f+1|0;if((f|0)>=(r|0)){m=f;break b}e=c[t+16>>2]|0;if((c[e+(f<<3)>>2]|0)!=(o|0)){m=f;break}else m=j}}else{m=f;j=1}while(0);if((q|0)<(p|0)){l=c[t+36>>2]|0;e=l+(q<<2)|0;h=c[e>>2]|0;f=c[(c[h+740>>2]|0)+208>>2]|0;if((f|0)<=-1)f=c[(c[h+744>>2]|0)+208>>2]|0;if((f|0)==(o|0)){k=q;do{k=k+1|0;if((k|0)>=(p|0))break;h=c[l+(k<<2)>>2]|0;f=c[(c[h+740>>2]|0)+208>>2]|0;if((f|0)<=-1)f=c[(c[h+744>>2]|0)+208>>2]|0}while((o|0)==(f|0));h=k;f=k-q|0}else{h=n;f=0;e=0}}else{h=n;f=0;e=0}if(!j)Qb[c[(c[u>>2]|0)+8>>2]&7](u,c[t+56>>2]|0,c[t+48>>2]|0,e,f,o);q=(f|0)==0?q:h;e=c[t+48>>2]|0;if((e|0)<0){if((c[t+52>>2]|0)<0){f=c[t+56>>2]|0;if(f|0){if(a[t+60>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[t+56>>2]=0}a[t+60>>0]=1;c[t+56>>2]=0;c[t+52>>2]=0}do{c[(c[t+56>>2]|0)+(e<<2)>>2]=0;e=e+1|0}while((e|0)!=0)}c[t+48>>2]=0;if((m|0)>=(r|0))break;else{n=h;f=m}}}}else{r=Eb[c[(c[s>>2]|0)+44>>2]&127](s)|0;t=Eb[c[(c[s>>2]|0)+36>>2]&127](s)|0;Qb[c[(c[u>>2]|0)+8>>2]&7](u,c[b+16>>2]|0,c[b+8>>2]|0,r,t,-1)}e=c[2357]|0;u=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=u;do if(!u){if(c[e+4>>2]|0){tb(v|0,0)|0;u=c[6434]|0;g[e+8>>2]=+g[e+8>>2]+ +(((c[v+4>>2]|0)-(c[u+4>>2]|0)+(((c[v>>2]|0)-(c[u>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3;if(c[e+16>>2]|0)break;e=c[2357]|0}c[2357]=c[e+20>>2]}while(0);nh(c[b+196>>2]|0);e=c[b+200>>2]|0;ic[c[(c[e>>2]|0)+16>>2]&127](e,d,c[b+72>>2]|0);e=c[2357]|0;b=(c[e+16>>2]|0)+-1|0;c[e+16>>2]=b;if(b|0){i=v;return}do if(c[e+4>>2]|0){tb(v|0,0)|0;b=c[6434]|0;g[e+8>>2]=+g[e+8>>2]+ +(((c[v+4>>2]|0)-(c[b+4>>2]|0)+(((c[v>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[e+16>>2]|0)){e=c[2357]|0;break}else{i=v;return}}while(0);c[2357]=c[e+20>>2];i=v;return}function Uc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,j=0.0,l=0.0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0,v=0.0,w=0,x=0,y=0.0,z=0,A=0,B=0.0,C=0.0,D=0.0,E=0.0,F=0;A=i;i=i+176|0;c[a+348>>2]=a+220;c[a+352>>2]=a+252;c[a+356>>2]=a+284;c[a+360>>2]=a+316;c[a+364>>2]=4;c[a+368>>2]=0;c[a+376>>2]=0;x=c[b+4>>2]|0;c[a>>2]=c[b>>2];c[a+4>>2]=x;c[a+8>>2]=c[b+8>>2];c[a+8+4>>2]=c[b+8+4>>2];c[a+8+8>>2]=c[b+8+8>>2];c[a+8+12>>2]=c[b+8+12>>2];c[a+24>>2]=c[b+24>>2];c[a+24+4>>2]=c[b+24+4>>2];c[a+24+8>>2]=c[b+24+8>>2];c[a+24+12>>2]=c[b+24+12>>2];c[a+40>>2]=c[b+40>>2];c[a+40+4>>2]=c[b+40+4>>2];c[a+40+8>>2]=c[b+40+8>>2];c[a+40+12>>2]=c[b+40+12>>2];c[a+56>>2]=c[b+56>>2];c[a+56+4>>2]=c[b+56+4>>2];c[a+56+8>>2]=c[b+56+8>>2];c[a+56+12>>2]=c[b+56+12>>2];c[a+72>>2]=c[b+72>>2];c[a+72+4>>2]=c[b+72+4>>2];c[a+72+8>>2]=c[b+72+8>>2];c[a+72+12>>2]=c[b+72+12>>2];c[a+88>>2]=c[b+88>>2];c[a+88+4>>2]=c[b+88+4>>2];c[a+88+8>>2]=c[b+88+8>>2];c[a+88+12>>2]=c[b+88+12>>2];c[a+104>>2]=c[b+104>>2];c[a+104+4>>2]=c[b+104+4>>2];c[a+104+8>>2]=c[b+104+8>>2];c[a+104+12>>2]=c[b+104+12>>2];x=c[b+124>>2]|0;c[a+120>>2]=c[b+120>>2];c[a+124>>2]=x;g[a+144>>2]=0.0;c[a+180>>2]=0;c[a+128>>2]=c[d>>2];c[a+128+4>>2]=c[d+4>>2];c[a+128+8>>2]=c[d+8>>2];c[a+128+12>>2]=c[d+12>>2];e=+g[a+128>>2];h=+g[a+132>>2];j=+g[a+136>>2];if(e*e+h*h+j*j>0.0){d=(g[k>>2]=-e,c[k>>2]|0);b=(g[k>>2]=-h,c[k>>2]|0);f=(g[k>>2]=-j,c[k>>2]|0)}else{d=1065353216;b=0;f=0}g[a+164>>2]=0.0;c[a+364>>2]=3;c[a+148>>2]=a+316;c[a+180>>2]=1;t=(c[k>>2]=d,+g[k>>2]);v=(c[k>>2]=b,+g[k>>2]);Nh(a,t,v,(c[k>>2]=f,+g[k>>2]),a+316|0);g[a+164>>2]=1.0;w=(c[a+148>>2]|0)+16|0;c[a+128>>2]=c[w>>2];c[a+128+4>>2]=c[w+4>>2];c[a+128+8>>2]=c[w+8>>2];c[a+128+12>>2]=c[w+12>>2];c[A+24+48>>2]=c[w>>2];c[A+24+48+4>>2]=c[w+4>>2];c[A+24+48+8>>2]=c[w+8>>2];c[A+24+48+12>>2]=c[w+12>>2];c[A+24+32>>2]=c[w>>2];c[A+24+32+4>>2]=c[w+4>>2];c[A+24+32+8>>2]=c[w+8>>2];c[A+24+32+12>>2]=c[w+12>>2];c[A+24+16>>2]=c[w>>2];c[A+24+16+4>>2]=c[w+4>>2];c[A+24+16+8>>2]=c[w+8>>2];c[A+24+16+12>>2]=c[w+12>>2];c[A+24>>2]=c[w>>2];c[A+24+4>>2]=c[w+4>>2];c[A+24+8>>2]=c[w+8>>2];c[A+24+12>>2]=c[w+12>>2];v=0.0;w=0;x=0;e=e*e+h*h+j*j;a:do{u=c[a+368>>2]|0;l=+g[a+128>>2];h=+g[a+132>>2];j=+g[a+136>>2];o=+O(+(l*l+h*h+j*j));if(o<9.999999747378752e-05){z=5;break}g[a+148+(u*36|0)+16+(c[a+148+(u*36|0)+32>>2]<<2)>>2]=0.0;d=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=d;c[a+148+(u*36|0)+(c[a+148+(u*36|0)+32>>2]<<2)>>2]=c[a+348+(d<<2)>>2];d=c[a+148+(u*36|0)+32>>2]|0;c[a+148+(u*36|0)+32>>2]=d+1;Nh(a,-l,-h,-j,c[a+148+(u*36|0)+(d<<2)>>2]|0);d=c[a+148+(u*36|0)+32>>2]|0;b=c[a+148+(u*36|0)+(d+-1<<2)>>2]|0;h=+g[b+16>>2];j=+g[b+20>>2];l=+g[b+24>>2];q=h-+g[A+24>>2];r=j-+g[A+24+4>>2];t=l-+g[A+24+8>>2];if(q*q+r*r+t*t<9.999999747378752e-05){z=8;break}q=h-+g[A+24+16>>2];r=j-+g[A+24+20>>2];t=l-+g[A+24+24>>2];if(q*q+r*r+t*t<9.999999747378752e-05){z=8;break}q=h-+g[A+24+32>>2];r=j-+g[A+24+36>>2];t=l-+g[A+24+40>>2];if(q*q+r*r+t*t<9.999999747378752e-05){z=8;break}q=h-+g[A+24+48>>2];r=j-+g[A+24+52>>2];t=l-+g[A+24+56>>2];if(q*q+r*r+t*t<9.999999747378752e-05){z=8;break}w=w+1&3;s=A+24+(w<<4)|0;c[s>>2]=c[b+16>>2];c[s+4>>2]=c[b+16+4>>2];c[s+8>>2]=c[b+16+8>>2];c[s+12>>2]=c[b+16+12>>2];t=(+g[a+128>>2]*h+ +g[a+132>>2]*j+ +g[a+136>>2]*l)/o;v=t>v?t:v;if(o-v-o*9.999999747378752e-05<=0.0){z=9;break}c[A>>2]=0;b:do switch(d|0){case 2:{s=c[a+148+(u*36|0)>>2]|0;n=c[a+148+(u*36|0)+4>>2]|0;e=+g[n+16>>2];h=+g[s+16>>2];j=+g[n+20>>2];l=+g[s+20>>2];o=+g[n+24>>2];p=+g[s+24>>2];if(!((e-h)*(e-h)+(j-l)*(j-l)+(o-p)*(o-p)>0.0)){z=39;break a}q=-(h*(e-h)+l*(j-l)+p*(o-p))/((e-h)*(e-h)+(j-l)*(j-l)+(o-p)*(o-p));if(q>=1.0){g[A+8>>2]=0.0;g[A+8+4>>2]=1.0;c[A>>2]=2;e=e*e+j*j+o*o;break b}if(!(q<=0.0)){g[A+8+4>>2]=q;g[A+8>>2]=1.0-q;c[A>>2]=3;e=((e-h)*q+h)*((e-h)*q+h)+((j-l)*q+l)*((j-l)*q+l)+((o-p)*q+p)*((o-p)*q+p);break b}else{g[A+8>>2]=1.0;g[A+8+4>>2]=0.0;c[A>>2]=1;e=h*h+l*l+p*p;break b}}case 3:{e=+Oe((c[a+148+(u*36|0)>>2]|0)+16|0,(c[a+148+(u*36|0)+4>>2]|0)+16|0,(c[a+148+(u*36|0)+8>>2]|0)+16|0,A+8|0,A);break}case 4:{f=c[a+148+(u*36|0)>>2]|0;m=c[a+148+(u*36|0)+4>>2]|0;n=c[a+148+(u*36|0)+8>>2]|0;s=c[a+148+(u*36|0)+12>>2]|0;c[A+152>>2]=f+16;c[A+152+4>>2]=m+16;c[A+152+8>>2]=n+16;c[A+152+12>>2]=s+16;j=+g[f+16>>2];l=+g[s+16>>2];e=+g[f+20>>2];o=+g[s+20>>2];h=+g[f+24>>2];p=+g[s+24>>2];g[A+104>>2]=j-l;g[A+104+4>>2]=e-o;g[A+104+8>>2]=h-p;g[A+104+12>>2]=0.0;B=+g[m+16>>2];D=+g[m+20>>2];r=+g[m+24>>2];g[A+104+16>>2]=B-l;g[A+104+20>>2]=D-o;g[A+104+24>>2]=r-p;g[A+104+28>>2]=0.0;q=+g[n+16>>2];E=+g[n+20>>2];C=+g[n+24>>2];g[A+104+32>>2]=q-l;g[A+104+36>>2]=E-o;g[A+104+40>>2]=C-p;g[A+104+44>>2]=0.0;t=(e-o)*(r-p)*(q-l)+(h-p)*(B-l)*(E-o)-(E-o)*(r-p)*(j-l)-(e-o)*(B-l)*(C-p)+(C-p)*(j-l)*(D-o)-(q-l)*(h-p)*(D-o);if(t!=t|0.0!=0.0|t==0.0|!(t*(h*((B-q)*(e-D)-(D-E)*(j-B))+(j*((D-E)*(h-r)-(r-C)*(e-D))+e*((r-C)*(j-B)-(B-q)*(h-r))))<=0.0))e=-1.0;else{c[A+92>>2]=0;c[A+92+4>>2]=0;c[A+92+8>>2]=0;c[A+88>>2]=0;r=e-o;q=h-p;h=j-l;d=0;e=-1.0;while(1){b=c[4976+(d<<2)>>2]|0;C=+g[A+104+(b<<4)+8>>2];D=+g[A+104+(b<<4)+4>>2];E=+g[A+104+(b<<4)>>2];if(t*((r*C-q*D)*l+o*(q*E-C*h)+(D*h-r*E)*p)>0.0?(y=+Oe(c[A+152+(d<<2)>>2]|0,c[A+152+(b<<2)>>2]|0,s+16|0,A+92|0,A+88|0),e<0.0|y<e):0){F=c[A+88>>2]|0;c[A>>2]=(F&2|0?1<<b:0)+(F<<1&8)+(F&1|0?1<<d:0);c[A+8+(d<<2)>>2]=c[A+92>>2];c[A+8+(b<<2)>>2]=c[A+92+4>>2];g[A+8+(c[4976+(b<<2)>>2]<<2)>>2]=0.0;c[A+8+12>>2]=c[A+92+8>>2];e=y}d=d+1|0;if((d|0)==3)break;r=+g[A+104+(d<<4)+4>>2];q=+g[A+104+(d<<4)+8>>2];h=+g[A+104+(d<<4)>>2];l=+g[s+16>>2];o=+g[s+20>>2];p=+g[s+24>>2]}if(e<0.0){c[A>>2]=15;l=+g[n+20>>2];E=+g[m+24>>2];D=+g[s+16>>2];h=+g[n+24>>2];C=+g[m+16>>2];o=+g[s+20>>2];j=+g[n+16>>2];B=+g[s+24>>2];q=+g[m+20>>2];g[A+8>>2]=(l*E*D+h*C*o-o*E*j-l*C*B+B*j*q-D*h*q)/t;e=+g[f+20>>2];p=+g[f+24>>2];r=+g[f+16>>2];g[A+8+4>>2]=(e*h*D+p*j*o-o*h*r-e*j*B+B*r*l-D*p*l)/t;g[A+8+8>>2]=(q*p*D+E*r*o-o*p*C-q*r*B+B*C*e-D*E*e)/t;g[A+8+12>>2]=1.0-((l*E*D+h*C*o-o*E*j-l*C*B+B*j*q-D*h*q)/t+(e*h*D+p*j*o-o*h*r-e*j*B+B*r*l-D*p*l)/t+(q*p*D+E*r*o-o*p*C-q*r*B+B*C*e-D*E*e)/t);e=0.0}}break}default:{}}while(0);if(!(e>=0.0)){z=39;break}c[a+148+((1-u|0)*36|0)+32>>2]=0;c[a+128>>2]=0;c[a+128+4>>2]=0;c[a+128+8>>2]=0;c[a+128+12>>2]=0;c[a+368>>2]=1-u;d=c[a+148+(u*36|0)+32>>2]|0;b=c[A>>2]|0;if(d|0){n=0;do{f=a+148+(u*36|0)+(n<<2)|0;m=c[f>>2]|0;if(!(b&1<<n)){F=c[a+364>>2]|0;c[a+364>>2]=F+1;c[a+348+(F<<2)>>2]=m}else{c[a+148+((1-u|0)*36|0)+(c[a+148+((1-u|0)*36|0)+32>>2]<<2)>>2]=m;s=c[A+8+(n<<2)>>2]|0;F=c[a+148+((1-u|0)*36|0)+32>>2]|0;c[a+148+((1-u|0)*36|0)+32>>2]=F+1;c[a+148+((1-u|0)*36|0)+16+(F<<2)>>2]=s;F=c[f>>2]|0;C=(c[k>>2]=s,+g[k>>2]);D=C*+g[F+20>>2];E=C*+g[F+24>>2];g[a+128>>2]=+g[F+16>>2]*C+ +g[a+128>>2];g[a+132>>2]=D+ +g[a+132>>2];g[a+136>>2]=E+ +g[a+136>>2]}n=n+1|0}while((n|0)!=(d|0))}if((b|0)==15)c[a+376>>2]=1;x=x+1|0;if(x>>>0>=128){z=38;break}}while(!(c[a+376>>2]|0));if((z|0)==5)c[a+376>>2]=1;else if((z|0)==8){F=c[a+368>>2]|0;z=(c[a+148+(F*36|0)+32>>2]|0)+-1|0;c[a+148+(F*36|0)+32>>2]=z;z=c[a+148+(F*36|0)+(z<<2)>>2]|0;F=c[a+364>>2]|0;c[a+364>>2]=F+1;c[a+348+(F<<2)>>2]=z}else if((z|0)==9){F=c[a+368>>2]|0;z=(c[a+148+(F*36|0)+32>>2]|0)+-1|0;c[a+148+(F*36|0)+32>>2]=z;z=c[a+148+(F*36|0)+(z<<2)>>2]|0;F=c[a+364>>2]|0;c[a+364>>2]=F+1;c[a+348+(F<<2)>>2]=z}else if((z|0)==38)c[a+376>>2]=2;else if((z|0)==39){F=c[a+368>>2]|0;z=(c[a+148+(F*36|0)+32>>2]|0)+-1|0;c[a+148+(F*36|0)+32>>2]=z;z=c[a+148+(F*36|0)+(z<<2)>>2]|0;F=c[a+364>>2]|0;c[a+364>>2]=F+1;c[a+348+(F<<2)>>2]=z}c[a+372>>2]=a+148+((c[a+368>>2]|0)*36|0);d=c[a+376>>2]|0;switch(d|0){case 0:{C=+g[a+128>>2];D=+g[a+132>>2];E=+g[a+136>>2];g[a+144>>2]=+O(+(C*C+D*D+E*E));i=A;return d|0}case 1:{g[a+144>>2]=0.0;i=A;return d|0}default:{i=A;return d|0}}return 0}function Vc(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0,I=0,J=0.0,K=0.0,L=0.0,M=0.0,N=0,P=0,Q=0.0,R=0.0,S=0.0,T=0;P=i;i=i+224|0;g[b+56>>2]=0.0;I=P+208+4|0;N=P+208+8|0;c[P+208>>2]=0;c[P+208+4>>2]=0;c[P+208+8>>2]=0;c[P+208+12>>2]=0;c[P+144>>2]=c[d>>2];c[P+144+4>>2]=c[d+4>>2];c[P+144+8>>2]=c[d+8>>2];c[P+144+12>>2]=c[d+12>>2];c[P+144+16>>2]=c[d+16>>2];c[P+144+16+4>>2]=c[d+16+4>>2];c[P+144+16+8>>2]=c[d+16+8>>2];c[P+144+16+12>>2]=c[d+16+12>>2];c[P+144+32>>2]=c[d+32>>2];c[P+144+32+4>>2]=c[d+32+4>>2];c[P+144+32+8>>2]=c[d+32+8>>2];c[P+144+32+12>>2]=c[d+32+12>>2];A=P+144+48|0;c[A>>2]=c[d+48>>2];c[A+4>>2]=c[d+48+4>>2];c[A+8>>2]=c[d+48+8>>2];c[A+12>>2]=c[d+48+12>>2];c[P+80>>2]=c[d+64>>2];c[P+80+4>>2]=c[d+64+4>>2];c[P+80+8>>2]=c[d+64+8>>2];c[P+80+12>>2]=c[d+64+12>>2];c[P+80+16>>2]=c[d+80>>2];c[P+80+16+4>>2]=c[d+80+4>>2];c[P+80+16+8>>2]=c[d+80+8>>2];c[P+80+16+12>>2]=c[d+80+12>>2];c[P+80+32>>2]=c[d+96>>2];c[P+80+32+4>>2]=c[d+96+4>>2];c[P+80+32+8>>2]=c[d+96+8>>2];c[P+80+32+12>>2]=c[d+96+12>>2];B=P+80+48|0;c[B>>2]=c[d+112>>2];c[B+4>>2]=c[d+112+4>>2];c[B+8>>2]=c[d+112+8>>2];c[B+12>>2]=c[d+112+12>>2];G=+g[A>>2];H=+g[B>>2];J=+g[P+144+52>>2];K=+g[P+80+52>>2];L=+g[P+144+56>>2];M=+g[P+80+56>>2];g[A>>2]=G-(G+H)*.5;g[P+144+52>>2]=J-(J+K)*.5;g[P+144+56>>2]=L-(L+M)*.5;g[B>>2]=H-(G+H)*.5;g[P+80+52>>2]=K-(J+K)*.5;g[P+80+56>>2]=M-(L+M)*.5;if(((c[(c[b+28>>2]|0)+4>>2]|0)+-17|0)>>>0<2)A=((c[(c[b+32>>2]|0)+4>>2]|0)+-17|0)>>>0<2;else A=0;v=+g[b+44>>2];u=+g[b+48>>2];c[6420]=(c[6420]|0)+1;B=a[b+52>>0]|0;c[b+64>>2]=0;c[b+4>>2]=0;c[b+8>>2]=1065353216;c[b+12>>2]=0;g[b+16>>2]=0.0;c[b+68>>2]=0;c[b+60>>2]=-1;p=c[b+24>>2]|0;a[p+312>>0]=0;c[p>>2]=0;a[p+356>>0]=1;c[p+292>>2]=1566444395;c[p+296>>2]=1566444395;c[p+300>>2]=1566444395;g[p+304>>2]=0.0;c[p+336>>2]=0;c[p+336+4>>2]=0;c[p+336+8>>2]=0;c[p+336+12>>2]=0;a[p+336+16>>0]=0;a[p+332>>0]=a[p+332>>0]&-16;p=0;q=999999984306749440.0;do{o=+g[b+4>>2];n=+g[b+8>>2];k=+g[b+12>>2];l=+g[d+4>>2]*-o+ +g[d+20>>2]*-n+ +g[d+36>>2]*-k;m=+g[d+8>>2]*-o+ +g[d+24>>2]*-n+ +g[d+40>>2]*-k;g[P+64>>2]=+g[d>>2]*-o+ +g[d+16>>2]*-n+ +g[d+32>>2]*-k;g[P+64+4>>2]=l;g[P+64+8>>2]=m;g[P+64+12>>2]=0.0;m=o*+g[d+68>>2]+n*+g[d+84>>2]+k*+g[d+100>>2];l=o*+g[d+72>>2]+n*+g[d+88>>2]+k*+g[d+104>>2];g[P+48>>2]=+g[d+64>>2]*o+ +g[d+80>>2]*n+ +g[d+96>>2]*k;g[P+48+4>>2]=m;g[P+48+8>>2]=l;g[P+48+12>>2]=0.0;Gd(P+32|0,c[b+28>>2]|0,P+64|0);Gd(P+16|0,c[b+32>>2]|0,P+48|0);l=+g[P+32>>2];m=+g[P+32+4>>2];k=+g[P+32+8>>2];n=l*+g[P+144>>2]+m*+g[P+144+4>>2]+k*+g[P+144+8>>2]+ +g[P+144+48>>2];o=l*+g[P+144+16>>2]+m*+g[P+144+20>>2]+k*+g[P+144+24>>2]+ +g[P+144+52>>2];k=l*+g[P+144+32>>2]+m*+g[P+144+36>>2]+k*+g[P+144+40>>2]+ +g[P+144+56>>2];m=+g[P+16>>2];l=+g[P+16+4>>2];t=+g[P+16+8>>2];r=m*+g[P+80>>2]+l*+g[P+80+4>>2]+t*+g[P+80+8>>2]+ +g[P+80+48>>2];s=m*+g[P+80+16>>2]+l*+g[P+80+20>>2]+t*+g[P+80+24>>2]+ +g[P+80+52>>2];t=m*+g[P+80+32>>2]+l*+g[P+80+36>>2]+t*+g[P+80+40>>2]+ +g[P+80+56>>2];l=A?0.0:t;m=A?0.0:k;t=(A?0.0:k)-(A?0.0:t);k=+g[b+4>>2]*(n-r)+ +g[b+8>>2]*(o-s)+ +g[b+12>>2]*t;if(k>0.0?k*k>q*+g[d+128>>2]:0){c[b+68>>2]=10;h=0;p=1}else T=7;do if((T|0)==7){T=0;y=c[b+24>>2]|0;z=c[y>>2]|0;if((z|0)>0){j=+g[y+308>>2];x=0;h=0;do{C=n-r-+g[y+4+(h<<4)>>2];D=o-s-+g[y+4+(h<<4)+4>>2];E=t-+g[y+4+(h<<4)+8>>2];x=x|C*C+D*D+E*E<=j;h=h+1|0}while((h|0)!=(z|0))}else x=0;if((+g[y+304>>2]==0.0?t==+g[y+300>>2]:0)?o-s==+g[y+296>>2]:0)h=n-r==+g[y+292>>2];else h=0;if(x|h){c[b+68>>2]=1;h=0;p=1;break}j=q-k;if(j<=q*9.999999974752427e-07){c[b+68>>2]=!(j<=0.0)?11:2;h=0;p=1;break}g[y+292>>2]=n-r;g[y+296>>2]=o-s;g[y+300>>2]=t;g[y+304>>2]=0.0;a[y+356>>0]=1;g[y+4+(z<<4)>>2]=n-r;g[y+4+(z<<4)+4>>2]=o-s;g[y+4+(z<<4)+8>>2]=t;g[y+4+(z<<4)+12>>2]=0.0;h=c[y>>2]|0;g[y+84+(h<<4)>>2]=n;g[y+84+(h<<4)+4>>2]=o;g[y+84+(h<<4)+8>>2]=m;g[y+84+(h<<4)+12>>2]=0.0;h=c[y>>2]|0;g[y+164+(h<<4)>>2]=r;g[y+164+(h<<4)+4>>2]=s;g[y+164+(h<<4)+8>>2]=l;g[y+164+(h<<4)+12>>2]=0.0;c[y>>2]=(c[y>>2]|0)+1;h=c[b+24>>2]|0;z=Ec(h)|0;j=+g[h+276>>2];k=+g[h+280>>2];l=+g[h+284>>2];h=c[h+288>>2]|0;if(!z){c[b+68>>2]=3;h=0;p=1;break}if(j*j+k*k+l*l<9.999999974752427e-07){g[b+4>>2]=j;g[b+8>>2]=k;g[b+12>>2]=l;c[b+16>>2]=h;c[b+68>>2]=6;h=0;p=1;break}if(q-(j*j+k*k+l*l)<=q*1.1920928955078125e-07){c[b+68>>2]=12;h=0;p=1;q=j*j+k*k+l*l;break}g[b+4>>2]=j;g[b+8>>2]=k;g[b+12>>2]=l;c[b+16>>2]=h;z=c[b+64>>2]|0;c[b+64>>2]=z+1;if((z|0)<=1e3)if((c[c[b+24>>2]>>2]|0)==4){c[b+68>>2]=13;h=0;q=j*j+k*k+l*l}else{h=1;q=j*j+k*k+l*l}else{h=0;q=j*j+k*k+l*l}}while(0)}while(h);u=B<<24>>24==0?u:0.0;t=(B<<24>>24==0?v:0.0)+u;do if(p){B=c[b+24>>2]|0;Ec(B)|0;j=+g[B+260>>2];l=+g[B+264>>2];n=+g[B+268>>2];c[P+208>>2]=c[b+4>>2];c[P+208+4>>2]=c[b+4+4>>2];c[P+208+8>>2]=c[b+4+8>>2];c[P+208+12>>2]=c[b+4+12>>2];k=+g[b+4>>2];m=+g[b+8>>2];o=+g[b+12>>2];if(k*k+m*m+o*o<.0001)c[b+68>>2]=5;if(k*k+m*m+o*o>1.4210854715202004e-14){E=1.0/+O(+(k*k+m*m+o*o));g[P+208>>2]=E*+g[P+208>>2];g[I>>2]=E*+g[I>>2];g[N>>2]=E*+g[N>>2];w=u/+O(+q);c[b+60>>2]=1;E=1.0/E-t;x=1;D=w*k+j;C=w*m+l;n=w*o+n;break}else{c[b+60>>2]=2;E=0.0;x=0;D=j;C=l;break}}else{E=0.0;x=0;D=0.0;C=0.0;n=0.0}while(0);if(((c[b+72>>2]|0)!=0?(c[b+20>>2]|0)!=0:0)?(c[b+68>>2]|0)!=0:0)h=t+E<.01;else h=0;p=x^1;do if(h|p?(F=c[b+20>>2]|0,(F|0)!=0):0){c[6419]=(c[6419]|0)+1;c[b+4>>2]=0;c[b+4+4>>2]=0;c[b+4+8>>2]=0;c[b+4+12>>2]=0;if(Db[c[(c[F>>2]|0)+8>>2]&3](F,c[b+24>>2]|0,c[b+28>>2]|0,c[b+32>>2]|0,P+144|0,P+80|0,b+4|0,P+64|0,P+48|0,f)|0){l=+g[P+48>>2];o=+g[P+64>>2];k=+g[P+48+4>>2];q=+g[P+64+4>>2];j=+g[P+48+8>>2];r=+g[P+64+8>>2];if(!((l-o)*(l-o)+(k-q)*(k-q)+(j-r)*(j-r)<=1.4210854715202004e-14)){m=(l-o)*(l-o)+(k-q)*(k-q)+(j-r)*(j-r);t=l-o;u=j-r;v=0.0;w=k-q}else{t=+g[b+4>>2];w=+g[b+8>>2];u=+g[b+12>>2];m=t*t+w*w+u*u;v=+g[b+16>>2]}if(m>1.4210854715202004e-14){s=1.0/+O(+m);m=-+O(+((o-l)*(o-l)+(q-k)*(q-k)+(r-j)*(r-j)));if(E>m|p){g[P+208>>2]=t*s;g[I>>2]=w*s;g[N>>2]=u*s;g[P+208+12>>2]=v;c[b+60>>2]=3;break}else h=8}else h=9;c[b+60>>2]=h;if(x){m=E;l=D;k=C;j=n;break}i=P;return}else{k=+g[b+4>>2];o=+g[b+8>>2];r=+g[b+12>>2];if(!(k*k+o*o+r*r>0.0)){if(x){m=E;l=D;k=C;j=n;break}i=P;return}l=+g[P+48>>2];v=+g[P+64>>2]-l;q=+g[P+48+4>>2];w=+g[P+64+4>>2]-q;s=+g[P+48+8>>2];j=+g[P+64+8>>2]-s;j=+O(+(v*v+w*w+j*j))-t;if(j<E|p){c[P+208>>2]=c[b+4>>2];c[P+208+4>>2]=c[b+4+4>>2];c[P+208+8>>2]=c[b+4+8>>2];c[P+208+12>>2]=c[b+4+12>>2];C=+g[P+208>>2];D=+g[I>>2];E=+g[N>>2];m=1.0/+O(+(C*C+D*D+E*E));g[P+208>>2]=C*m;g[I>>2]=D*m;g[N>>2]=E*m;c[b+60>>2]=6;m=j;l=u*k+l;k=u*o+q;j=u*r+s;break}c[b+60>>2]=5;if(x){m=E;l=D;k=C;j=n;break}i=P;return}}else T=52;while(0);if((T|0)==52)if(x){m=E;l=D;k=C;j=n}else{i=P;return}if(!(m<0.0)?!(m*m<+g[d+128>>2]):0){i=P;return}if(c[b+76>>2]|0?(T=c[b+28>>2]|0,mc[c[(c[T>>2]|0)+8>>2]&127](T,P+144|0,P+64|0,P+48|0),C=(+g[P+48>>2]+ +g[P+64>>2])*.5,D=(+g[P+48+4>>2]+ +g[P+64+4>>2])*.5,E=(+g[P+48+8>>2]+ +g[P+64+8>>2])*.5,T=c[b+32>>2]|0,mc[c[(c[T>>2]|0)+8>>2]&127](T,P+80|0,P+64|0,P+48|0),Q=+g[P+208>>2],R=+g[I>>2],S=+g[N>>2],(C-(+g[P+64>>2]+ +g[P+48>>2])*.5)*Q+(D-(+g[P+64+4>>2]+ +g[P+48+4>>2])*.5)*R+(E-(+g[P+64+8>>2]+ +g[P+48+8>>2])*.5)*S<0.0):0){g[P+208>>2]=-Q;g[I>>2]=-R;g[N>>2]=-S}c[b+4>>2]=c[P+208>>2];c[b+4+4>>2]=c[P+208+4>>2];c[b+4+8>>2]=c[P+208+8>>2];c[b+4+12>>2]=c[P+208+12>>2];g[b+56>>2]=m;T=c[(c[e>>2]|0)+16>>2]|0;g[P>>2]=(G+H)*.5+l;g[P+4>>2]=(J+K)*.5+k;g[P+8>>2]=(L+M)*.5+j;g[P+12>>2]=0.0;hc[T&15](e,P+208|0,P,m);i=P;return}function Wc(b,d,e,f,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;var l=0,m=0,n=0.0,o=0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0,ba=0;X=i;i=i+64|0;a[X+32+16>>0]=1;W=X+32+12|0;c[W>>2]=0;c[X+32+4>>2]=0;c[X+32+8>>2]=0;q=c[f+4>>2]|0;if((q|0)>0){c[6435]=(c[6435]|0)+1;l=yc((q<<4|3)+16|0)|0;if(!l)o=0;else{c[(l+4+15&-16)+-4>>2]=l;o=l+4+15&-16}l=c[X+32+4>>2]|0;if((l|0)>0){m=0;do{V=o+(m<<4)|0;U=(c[W>>2]|0)+(m<<4)|0;c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];m=m+1|0}while((m|0)!=(l|0))}l=c[W>>2]|0;if(l|0){if(a[X+32+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[l+-4>>2]|0)}c[W>>2]=0}a[X+32+16>>0]=1;c[W>>2]=o;c[X+32+8>>2]=q}l=c[d+28>>2]|0;if((l|0)>0){U=c[d+36>>2]|0;A=+g[e>>2];B=+g[e+4>>2];E=+g[e+8>>2];F=+g[e+16>>2];G=+g[e+20>>2];s=+g[e+24>>2];r=+g[e+32>>2];p=+g[e+36>>2];n=+g[e+40>>2];t=+g[b>>2];u=+g[b+4>>2];v=+g[b+8>>2];V=-1;z=3402823466385288598117041.0e14;o=0;while(1){w=+g[U+(o*36|0)+20>>2];x=+g[U+(o*36|0)+24>>2];y=+g[U+(o*36|0)+28>>2];m=(w*A+x*B+y*E)*t+(w*F+x*G+y*s)*u+(w*r+x*p+y*n)*v<z;V=m?o:V;o=o+1|0;if((o|0)==(l|0))break;else z=m?(w*A+x*B+y*E)*t+(w*F+x*G+y*s)*u+(w*r+x*p+y*n)*v:z}if((V|0)>=0){L=c[U+(V*36|0)+4>>2]|0;if((L|0)>0){M=U+(V*36|0)+12|0;N=U+(V*36|0)+20|0;O=U+(V*36|0)+24|0;P=U+(V*36|0)+28|0;t=A;x=B;w=E;v=F;u=G;K=0;J=f;f=X+32|0;while(1){I=c[M>>2]|0;l=c[I+(K<<2)>>2]|0;H=c[d+16>>2]|0;K=K+1|0;I=c[I+(((K|0)==(L|0)?0:K)<<2)>>2]|0;Z=+g[H+(l<<4)>>2];_=Z-+g[H+(I<<4)>>2];Y=+g[H+(l<<4)+4>>2];$=Y-+g[H+(I<<4)+4>>2];y=+g[H+(l<<4)+8>>2];B=y-+g[H+(I<<4)+8>>2];z=_*t+$*x+B*w;A=_*v+$*u+B*s;B=_*r+$*p+B*n;$=+g[N>>2];_=+g[O>>2];G=+g[P>>2];E=t*$+x*_+w*G;F=v*$+u*_+s*G;G=r*$+p*_+n*G;u=(Z*t+Y*x+y*w+ +g[e+48>>2])*-(A*G-B*F)+(Z*v+Y*u+y*s+ +g[e+52>>2])*-(B*E-z*G)+(Z*r+Y*p+y*n+ +g[e+56>>2])*-(z*F-A*E);I=J;H=f;l=c[I+4>>2]|0;if((l|0)>=2){o=c[I+12>>2]|0;p=+g[o+(l+-1<<4)>>2];r=+g[o+(l+-1<<4)+4>>2];s=+g[o+(l+-1<<4)+8>>2];n=p*-(A*G-B*F)+r*-(B*E-z*G)+s*-(z*F-A*E)-u;D=0;while(1){v=+g[o+(D<<4)>>2];w=+g[o+(D<<4)+4>>2];x=+g[o+(D<<4)+8>>2];C=c[o+(D<<4)+12>>2]|0;y=v*-(A*G-B*F)+w*-(B*E-z*G)+x*-(z*F-A*E)-u;do if(n<0.0)if(y<0.0){m=c[H+4>>2]|0;if((m|0)==(c[H+8>>2]|0)?(Q=m|0?m<<1:1,(m|0)<(Q|0)):0){if(!Q)q=0;else{c[6435]=(c[6435]|0)+1;m=yc((Q<<4|3)+16|0)|0;if(!m)m=0;else{c[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}q=m;m=c[H+4>>2]|0}if((m|0)>0){o=0;do{aa=q+(o<<4)|0;ba=(c[H+12>>2]|0)+(o<<4)|0;c[aa>>2]=c[ba>>2];c[aa+4>>2]=c[ba+4>>2];c[aa+8>>2]=c[ba+8>>2];c[aa+12>>2]=c[ba+12>>2];o=o+1|0}while((o|0)!=(m|0))}m=c[H+12>>2]|0;if(m|0){if(a[H+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[m+-4>>2]|0)}c[H+12>>2]=0}a[H+16>>0]=1;c[H+12>>2]=q;c[H+8>>2]=Q;m=c[H+4>>2]|0}ba=c[H+12>>2]|0;g[ba+(m<<4)>>2]=v;g[ba+(m<<4)+4>>2]=w;g[ba+(m<<4)+8>>2]=x;c[ba+(m<<4)+12>>2]=C;c[H+4>>2]=(c[H+4>>2]|0)+1;break}else{n=n/(n-y);t=p+(v-p)*n;p=r+(w-r)*n;n=s+(x-s)*n;m=c[H+4>>2]|0;if((m|0)==(c[H+8>>2]|0)?(R=m|0?m<<1:1,(m|0)<(R|0)):0){if(!R)q=0;else{c[6435]=(c[6435]|0)+1;m=yc((R<<4|3)+16|0)|0;if(!m)m=0;else{c[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}q=m;m=c[H+4>>2]|0}if((m|0)>0){o=0;do{ba=q+(o<<4)|0;aa=(c[H+12>>2]|0)+(o<<4)|0;c[ba>>2]=c[aa>>2];c[ba+4>>2]=c[aa+4>>2];c[ba+8>>2]=c[aa+8>>2];c[ba+12>>2]=c[aa+12>>2];o=o+1|0}while((o|0)!=(m|0))}m=c[H+12>>2]|0;if(m|0){if(a[H+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[m+-4>>2]|0)}c[H+12>>2]=0}a[H+16>>0]=1;c[H+12>>2]=q;c[H+8>>2]=R;m=c[H+4>>2]|0}ba=c[H+12>>2]|0;g[ba+(m<<4)>>2]=t;g[ba+(m<<4)+4>>2]=p;g[ba+(m<<4)+8>>2]=n;g[ba+(m<<4)+12>>2]=0.0;c[H+4>>2]=(c[H+4>>2]|0)+1;break}else if(y<0.0){n=n/(n-y);t=p+(v-p)*n;p=r+(w-r)*n;n=s+(x-s)*n;m=c[H+4>>2]|0;if((m|0)==(c[H+8>>2]|0)?(S=m|0?m<<1:1,(m|0)<(S|0)):0){if(!S)q=0;else{c[6435]=(c[6435]|0)+1;m=yc((S<<4|3)+16|0)|0;if(!m)m=0;else{c[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}q=m;m=c[H+4>>2]|0}if((m|0)>0){o=0;do{ba=q+(o<<4)|0;aa=(c[H+12>>2]|0)+(o<<4)|0;c[ba>>2]=c[aa>>2];c[ba+4>>2]=c[aa+4>>2];c[ba+8>>2]=c[aa+8>>2];c[ba+12>>2]=c[aa+12>>2];o=o+1|0}while((o|0)!=(m|0))}m=c[H+12>>2]|0;if(m|0){if(a[H+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[m+-4>>2]|0)}c[H+12>>2]=0}a[H+16>>0]=1;c[H+12>>2]=q;c[H+8>>2]=S;m=c[H+4>>2]|0}ba=c[H+12>>2]|0;g[ba+(m<<4)>>2]=t;g[ba+(m<<4)+4>>2]=p;g[ba+(m<<4)+8>>2]=n;g[ba+(m<<4)+12>>2]=0.0;m=(c[H+4>>2]|0)+1|0;c[H+4>>2]=m;if((m|0)==(c[H+8>>2]|0)?(T=m|0?m<<1:1,(m|0)<(T|0)):0){if(!T)q=0;else{c[6435]=(c[6435]|0)+1;m=yc((T<<4|3)+16|0)|0;if(!m)m=0;else{c[(m+4+15&-16)+-4>>2]=m;m=m+4+15&-16}q=m;m=c[H+4>>2]|0}if((m|0)>0){o=0;do{ba=q+(o<<4)|0;aa=(c[H+12>>2]|0)+(o<<4)|0;c[ba>>2]=c[aa>>2];c[ba+4>>2]=c[aa+4>>2];c[ba+8>>2]=c[aa+8>>2];c[ba+12>>2]=c[aa+12>>2];o=o+1|0}while((o|0)!=(m|0))}m=c[H+12>>2]|0;if(m|0){if(a[H+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[m+-4>>2]|0)}c[H+12>>2]=0}a[H+16>>0]=1;c[H+12>>2]=q;c[H+8>>2]=T;m=c[H+4>>2]|0}ba=c[H+12>>2]|0;g[ba+(m<<4)>>2]=v;g[ba+(m<<4)+4>>2]=w;g[ba+(m<<4)+8>>2]=x;c[ba+(m<<4)+12>>2]=C;c[H+4>>2]=(c[H+4>>2]|0)+1}while(0);m=D+1|0;if((m|0)==(l|0))break;o=c[I+12>>2]|0;n=y;p=v;s=x;r=w;D=m}l=c[I+4>>2]|0}if((l|0)<0){if((c[I+8>>2]|0)<0){m=c[I+12>>2]|0;if(m|0){if(a[I+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[m+-4>>2]|0)}c[I+12>>2]=0}a[I+16>>0]=1;c[I+12>>2]=0;c[I+8>>2]=0}do{ba=(c[I+12>>2]|0)+(l<<4)|0;c[ba>>2]=c[X>>2];c[ba+4>>2]=c[X+4>>2];c[ba+8>>2]=c[X+8>>2];c[ba+12>>2]=c[X+12>>2];l=l+1|0}while((l|0)!=0)}c[I+4>>2]=0;t=+g[e>>2];x=+g[e+4>>2];w=+g[e+8>>2];v=+g[e+16>>2];u=+g[e+20>>2];s=+g[e+24>>2];r=+g[e+32>>2];p=+g[e+36>>2];n=+g[e+40>>2];if((K|0)>=(L|0)){o=N;m=O;l=P;C=e+48|0;D=e+52|0;q=e+56|0;break}else{ba=f;f=J;J=ba}}}else{o=U+(V*36|0)+20|0;m=U+(V*36|0)+24|0;l=U+(V*36|0)+28|0;C=e+48|0;D=e+52|0;q=e+56|0;t=A;x=B;w=E;v=F;u=G}Z=+g[o>>2];_=+g[m>>2];$=+g[l>>2];t=Z*t+_*x+$*w;s=Z*v+_*u+$*s;r=Z*r+_*p+$*n;p=+g[U+(V*36|0)+32>>2]-(t*+g[C>>2]+s*+g[D>>2]+r*+g[q>>2]);l=c[f+4>>2]|0;if((l|0)>0){o=0;do{m=c[f+12>>2]|0;n=p+(t*+g[m+(o<<4)>>2]+s*+g[m+(o<<4)+4>>2]+r*+g[m+(o<<4)+8>>2]);n=n<=h?h:n;if(n<=j){l=m+(o<<4)|0;c[X+16>>2]=c[l>>2];c[X+16+4>>2]=c[l+4>>2];c[X+16+8>>2]=c[l+8>>2];c[X+16+12>>2]=c[l+12>>2];hc[c[(c[k>>2]|0)+16>>2]&15](k,b,X+16|0,n);l=c[f+4>>2]|0}o=o+1|0}while((o|0)<(l|0))}}}l=c[W>>2]|0;if(!l){i=X;return}if(a[X+32+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[l+-4>>2]|0)}c[W>>2]=0;i=X;return}function Xc(b){b=b|0;var d=0.0,e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0;w=i;i=i+176|0;if(!(a[b+738>>0]|0)){i=w;return}g[b+36>>2]=0.0;g[b+744>>2]=0.0;if(!(a[b+736>>0]|0)){e=c[b+28>>2]|0;l=+g[b+600>>2];m=+g[b+604>>2];r=+g[b+608>>2];t=l*+g[e+20>>2]+m*+g[e+24>>2]+r*+g[e+28>>2]+ +g[e+56>>2];f=c[b+32>>2]|0;n=+g[b+664>>2];o=+g[b+668>>2];s=+g[b+672>>2];p=+g[f+52>>2];d=+g[f+56>>2];u=n*+g[f+20>>2]+o*+g[f+24>>2]+s*+g[f+28>>2]+d;v=n*+g[f+36>>2]+o*+g[f+40>>2]+s*+g[f+44>>2]+ +g[f+60>>2];q=l*+g[e+4>>2]+m*+g[e+8>>2]+r*+g[e+12>>2]+ +g[e+52>>2];r=l*+g[e+36>>2]+m*+g[e+40>>2]+r*+g[e+44>>2]+ +g[e+60>>2];s=n*+g[f+4>>2]+o*+g[f+8>>2]+s*+g[f+12>>2]+p;if((s-q)*(s-q)+(u-t)*(u-t)+(v-r)*(v-r)>1.1920928955078125e-07){j=1.0/+O(+((s-q)*(s-q)+(u-t)*(u-t)+(v-r)*(v-r)));g[w+128>>2]=(s-q)*j;g[w+128+4>>2]=(u-t)*j;g[w+128+8>>2]=(v-r)*j;c[w+128+12>>2]=0;n=(v-r)*j;h=(u-t)*j;j=(s-q)*j}else{c[w+128>>2]=1065353216;c[w+128+4>>2]=0;c[w+128+8>>2]=0;g[w+128+12>>2]=0.0;n=0.0;h=0.0;j=1.0}if(+N(+n)>.7071067690849304){y=n*n+h*h;x=1.0/+O(+y);l=-(x*n);n=x*h;o=-(n*j);k=j*l;m=0.0;h=y*x;j=n}else{l=j*j+h*h;k=1.0/+O(+l);m=-(h*k);h=k*j;o=n*m;k=l*k;l=h;h=-(h*n);j=0.0}g[w+128+16>>2]=m;g[w+128+20>>2]=l;g[w+128+24>>2]=j;g[w+128+32>>2]=h;g[w+128+36>>2]=o;g[w+128+40>>2]=k;h=p;e=0;while(1){z=c[b+28>>2]|0;c[w+80>>2]=c[z+4>>2];c[w+80+4>>2]=c[z+20>>2];c[w+80+8>>2]=c[z+36>>2];g[w+80+12>>2]=0.0;c[w+80+16>>2]=c[z+8>>2];c[w+80+20>>2]=c[z+24>>2];c[w+80+24>>2]=c[z+40>>2];g[w+80+28>>2]=0.0;c[w+80+32>>2]=c[z+12>>2];c[w+80+36>>2]=c[z+28>>2];c[w+80+40>>2]=c[z+44>>2];g[w+80+44>>2]=0.0;c[w+32>>2]=c[f+4>>2];c[w+32+4>>2]=c[f+20>>2];c[w+32+8>>2]=c[f+36>>2];g[w+32+12>>2]=0.0;c[w+32+16>>2]=c[f+8>>2];c[w+32+20>>2]=c[f+24>>2];c[w+32+24>>2]=c[f+40>>2];g[w+32+28>>2]=0.0;c[w+32+32>>2]=c[f+12>>2];c[w+32+36>>2]=c[f+28>>2];c[w+32+40>>2]=c[f+44>>2];g[w+32+44>>2]=0.0;x=t-+g[z+56>>2];y=r-+g[z+60>>2];g[w+16>>2]=q-+g[z+52>>2];g[w+16+4>>2]=x;g[w+16+8>>2]=y;g[w+16+12>>2]=0.0;y=v-+g[f+60>>2];g[w>>2]=s-h;g[w+4>>2]=u-d;g[w+8>>2]=y;g[w+12>>2]=0.0;z=c[b+28>>2]|0;f=c[b+32>>2]|0;Rg(b+48+(e*84|0)|0,w+80|0,w+32|0,w+16|0,w,w+128+(e<<4)|0,z+396|0,+g[z+344>>2],f+396|0,+g[f+344>>2]);e=e+1|0;if((e|0)==3)break;z=c[b+32>>2]|0;f=z;h=+g[z+52>>2];d=+g[z+56>>2]}}h=+g[b+560>>2];j=+g[b+576>>2];k=+g[b+592>>2];if(+N(+k)>.7071067690849304){p=1.0/+O(+(k*k+j*j));d=h*-(k*p);l=0.0;m=j*p;n=-(k*p);o=(k*k+j*j)*p;p=-(h*j*p)}else{p=1.0/+O(+(h*h+j*j));d=(h*h+j*j)*p;l=-(j*p);m=0.0;n=h*p;o=-(k*h*p);p=k*-(j*p)}f=c[b+28>>2]|0;I=+g[f+4>>2];H=+g[f+8>>2];u=+g[f+12>>2];R=l*I+n*H+m*u;G=+g[f+20>>2];F=+g[f+24>>2];x=+g[f+28>>2];T=l*G+n*F+m*x;E=+g[f+36>>2];s=+g[f+40>>2];C=+g[f+44>>2];W=l*E+n*s+m*C;B=o*I+p*H+d*u;K=o*G+p*F+d*x;L=o*E+p*s+d*C;e=c[b+32>>2]|0;A=+g[e+4>>2];l=+g[e+20>>2];m=+g[e+36>>2];q=+g[e+8>>2];r=+g[e+24>>2];v=+g[e+40>>2];P=+g[e+12>>2];S=+g[e+28>>2];V=+g[e+44>>2];c[b+300>>2]=0;c[b+300+4>>2]=0;c[b+300+8>>2]=0;c[b+300+12>>2]=0;g[b+316>>2]=R*I+T*G+W*E;g[b+320>>2]=R*H+T*F+W*s;g[b+324>>2]=R*u+T*x+W*C;g[b+328>>2]=0.0;g[b+332>>2]=A*-R+l*-T+m*-W;g[b+336>>2]=q*-R+r*-T+v*-W;g[b+340>>2]=P*-R+S*-T+V*-W;g[b+344>>2]=0.0;D=(R*I+T*G+W*E)*+g[f+396>>2];J=(R*H+T*F+W*s)*+g[f+400>>2];d=(R*u+T*x+W*C)*+g[f+404>>2];g[b+348>>2]=D;g[b+352>>2]=J;g[b+356>>2]=d;g[b+360>>2]=0.0;p=(A*-R+l*-T+m*-W)*+g[e+396>>2];y=(q*-R+r*-T+v*-W)*+g[e+400>>2];X=(P*-R+S*-T+V*-W)*+g[e+404>>2];g[b+364>>2]=p;g[b+368>>2]=y;g[b+372>>2]=X;g[b+376>>2]=0.0;g[b+380>>2]=(R*I+T*G+W*E)*D+(R*H+T*F+W*s)*J+(R*u+T*x+W*C)*d+((A*-R+l*-T+m*-W)*p+(q*-R+r*-T+v*-W)*y+(P*-R+S*-T+V*-W)*X);e=c[b+28>>2]|0;X=+g[e+4>>2];W=+g[e+20>>2];V=+g[e+36>>2];T=+g[e+8>>2];S=+g[e+24>>2];R=+g[e+40>>2];P=+g[e+12>>2];y=+g[e+28>>2];v=+g[e+44>>2];f=c[b+32>>2]|0;r=+g[f+4>>2];q=+g[f+20>>2];p=+g[f+36>>2];m=+g[f+8>>2];l=+g[f+24>>2];A=+g[f+40>>2];d=+g[f+12>>2];J=+g[f+28>>2];D=+g[f+44>>2];c[b+384>>2]=0;c[b+384+4>>2]=0;c[b+384+8>>2]=0;c[b+384+12>>2]=0;g[b+400>>2]=B*X+K*W+L*V;g[b+404>>2]=B*T+K*S+L*R;g[b+408>>2]=B*P+K*y+L*v;g[b+412>>2]=0.0;g[b+416>>2]=r*-B+q*-K+p*-L;g[b+420>>2]=m*-B+l*-K+A*-L;g[b+424>>2]=d*-B+J*-K+D*-L;g[b+428>>2]=0.0;U=(B*X+K*W+L*V)*+g[e+396>>2];Q=(B*T+K*S+L*R)*+g[e+400>>2];t=(B*P+K*y+L*v)*+g[e+404>>2];g[b+432>>2]=U;g[b+436>>2]=Q;g[b+440>>2]=t;g[b+444>>2]=0.0;n=(r*-B+q*-K+p*-L)*+g[f+396>>2];o=(m*-B+l*-K+A*-L)*+g[f+400>>2];M=(d*-B+J*-K+D*-L)*+g[f+404>>2];g[b+448>>2]=n;g[b+452>>2]=o;g[b+456>>2]=M;g[b+460>>2]=0.0;g[b+464>>2]=(B*X+K*W+L*V)*U+(B*T+K*S+L*R)*Q+(B*P+K*y+L*v)*t+((r*-B+q*-K+p*-L)*n+(m*-B+l*-K+A*-L)*o+(d*-B+J*-K+D*-L)*M);f=c[b+28>>2]|0;M=+g[f+4>>2];L=+g[f+20>>2];D=+g[f+36>>2];K=+g[f+8>>2];J=+g[f+24>>2];B=+g[f+40>>2];d=+g[f+12>>2];o=+g[f+28>>2];A=+g[f+44>>2];e=c[b+32>>2]|0;l=+g[e+4>>2];m=+g[e+20>>2];n=+g[e+36>>2];p=+g[e+8>>2];q=+g[e+24>>2];r=+g[e+40>>2];t=+g[e+12>>2];v=+g[e+28>>2];y=+g[e+44>>2];c[b+468>>2]=0;c[b+468+4>>2]=0;c[b+468+8>>2]=0;c[b+468+12>>2]=0;D=(I*h+H*j+u*k)*M+(G*h+F*j+x*k)*L+(E*h+s*j+C*k)*D;B=(I*h+H*j+u*k)*K+(G*h+F*j+x*k)*J+(E*h+s*j+C*k)*B;A=(I*h+H*j+u*k)*d+(G*h+F*j+x*k)*o+(E*h+s*j+C*k)*A;g[b+484>>2]=D;g[b+488>>2]=B;g[b+492>>2]=A;g[b+496>>2]=0.0;u=-(I*h+H*j+u*k);x=-(G*h+F*j+x*k);h=-(E*h+s*j+C*k);g[b+500>>2]=l*u+m*x+n*h;g[b+504>>2]=p*u+q*x+r*h;g[b+508>>2]=t*u+v*x+y*h;g[b+512>>2]=0.0;C=D*+g[f+396>>2];j=B*+g[f+400>>2];k=A*+g[f+404>>2];g[b+516>>2]=C;g[b+520>>2]=j;g[b+524>>2]=k;g[b+528>>2]=0.0;o=(l*u+m*x+n*h)*+g[e+396>>2];s=(p*u+q*x+r*h)*+g[e+400>>2];d=(t*u+v*x+y*h)*+g[e+404>>2];g[b+532>>2]=o;g[b+536>>2]=s;g[b+540>>2]=d;g[b+544>>2]=0.0;g[b+548>>2]=D*C+B*j+A*k+((l*u+m*x+n*h)*o+(p*u+q*x+r*h)*s+(t*u+v*x+y*h)*d);g[b+724>>2]=0.0;e=c[b+28>>2]|0;f=c[b+32>>2]|0;d=+kj(b,e+4|0,f+4|0);g[b+728>>2]=d;g[b+708>>2]=0.0;g[b+712>>2]=0.0;a[b+716>>0]=0;h=+g[b+692>>2];do if(h>=0.0){d=+eh(d-+g[b+688>>2],6.2831854820251465);if(!(d<-3.1415927410125732)){if(d>3.1415927410125732)d=d+-6.2831854820251465}else d=d+6.2831854820251465;if(d<-h){a[b+716>>0]=1;g[b+708>>2]=-(d+h);g[b+712>>2]=1.0;break}if(d>h){a[b+716>>0]=1;g[b+708>>2]=h-d;g[b+712>>2]=-1.0}}while(0);T=+g[b+560>>2];U=+g[b+576>>2];X=+g[b+592>>2];V=T*+g[e+4>>2]+U*+g[e+8>>2]+X*+g[e+12>>2];W=T*+g[e+20>>2]+U*+g[e+24>>2]+X*+g[e+28>>2];X=T*+g[e+36>>2]+U*+g[e+40>>2]+X*+g[e+44>>2];g[b+720>>2]=1.0/(V*(V*+g[e+264>>2]+W*+g[e+280>>2]+X*+g[e+296>>2])+W*(V*+g[e+268>>2]+W*+g[e+284>>2]+X*+g[e+300>>2])+X*(V*+g[e+272>>2]+W*+g[e+288>>2]+X*+g[e+304>>2])+(V*(V*+g[f+264>>2]+W*+g[f+280>>2]+X*+g[f+296>>2])+W*(V*+g[f+268>>2]+W*+g[f+284>>2]+X*+g[f+300>>2])+X*(V*+g[f+272>>2]+W*+g[f+288>>2]+X*+g[f+304>>2])));i=w;return}function Yc(b,d,e,f,h,j,l,m,n,o){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0.0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;B=i;i=i+4224|0;if(((c[e+4>>2]|0)+-17|0)>>>0<2)A=((c[f+4>>2]|0)+-17|0)>>>0<2;else A=0;b=0;do{Ue();t=+g[24672+(b<<4)>>2];u=+g[24672+(b<<4)+4>>2];v=+g[24672+(b<<4)+8>>2];y=+g[h+4>>2]*-t+ +g[h+20>>2]*-u+ +g[h+36>>2]*-v;w=+g[h+8>>2]*-t+ +g[h+24>>2]*-u+ +g[h+40>>2]*-v;g[B+1248+(b<<4)>>2]=+g[h>>2]*-t+ +g[h+16>>2]*-u+ +g[h+32>>2]*-v;g[B+1248+(b<<4)+4>>2]=y;g[B+1248+(b<<4)+8>>2]=w;g[B+1248+(b<<4)+12>>2]=0.0;w=t*+g[j+4>>2]+u*+g[j+20>>2]+v*+g[j+36>>2];y=t*+g[j+8>>2]+u*+g[j+24>>2]+v*+g[j+40>>2];g[B+256+(b<<4)>>2]=t*+g[j>>2]+u*+g[j+16>>2]+v*+g[j+32>>2];g[B+256+(b<<4)+4>>2]=w;g[B+256+(b<<4)+8>>2]=y;g[B+256+(b<<4)+12>>2]=0.0;b=b+1|0}while((b|0)!=42);b=Eb[c[(c[e>>2]|0)+84>>2]&127](e)|0;if((b|0)>0){q=0;r=42;while(1){ic[c[(c[e>>2]|0)+88>>2]&127](e,q,B+176|0);w=+g[B+176>>2];y=+g[B+176+4>>2];v=+g[B+176+8>>2];u=w*+g[h+16>>2]+y*+g[h+20>>2]+v*+g[h+24>>2];t=w*+g[h+32>>2]+y*+g[h+36>>2]+v*+g[h+40>>2];g[B+176>>2]=+g[h>>2]*w+ +g[h+4>>2]*y+ +g[h+8>>2]*v;g[B+176+4>>2]=u;g[B+176+8>>2]=t;g[B+176+12>>2]=0.0;Ue();z=24672+(r<<4)|0;c[z>>2]=c[B+176>>2];c[z+4>>2]=c[B+176+4>>2];c[z+8>>2]=c[B+176+8>>2];c[z+12>>2]=c[B+176+12>>2];t=+g[B+176>>2];u=+g[B+176+4>>2];v=+g[B+176+8>>2];y=+g[h+4>>2]*-t+ +g[h+20>>2]*-u+ +g[h+36>>2]*-v;w=+g[h+8>>2]*-t+ +g[h+24>>2]*-u+ +g[h+40>>2]*-v;g[B+1248+(r<<4)>>2]=+g[h>>2]*-t+ +g[h+16>>2]*-u+ +g[h+32>>2]*-v;g[B+1248+(r<<4)+4>>2]=y;g[B+1248+(r<<4)+8>>2]=w;g[B+1248+(r<<4)+12>>2]=0.0;w=t*+g[j+4>>2]+u*+g[j+20>>2]+v*+g[j+36>>2];y=t*+g[j+8>>2]+u*+g[j+24>>2]+v*+g[j+40>>2];g[B+256+(r<<4)>>2]=+g[j>>2]*t+ +g[j+16>>2]*u+ +g[j+32>>2]*v;g[B+256+(r<<4)+4>>2]=w;g[B+256+(r<<4)+8>>2]=y;g[B+256+(r<<4)+12>>2]=0.0;q=q+1|0;if((q|0)==(b|0))break;else r=r+1|0}r=b+42|0}else r=42;b=Eb[c[(c[f>>2]|0)+84>>2]&127](f)|0;if((b|0)>0){q=0;s=r;while(1){ic[c[(c[f>>2]|0)+88>>2]&127](f,q,B+176|0);w=+g[B+176>>2];y=+g[B+176+4>>2];v=+g[B+176+8>>2];u=w*+g[j+16>>2]+y*+g[j+20>>2]+v*+g[j+24>>2];t=w*+g[j+32>>2]+y*+g[j+36>>2]+v*+g[j+40>>2];g[B+176>>2]=+g[j>>2]*w+ +g[j+4>>2]*y+ +g[j+8>>2]*v;g[B+176+4>>2]=u;g[B+176+8>>2]=t;g[B+176+12>>2]=0.0;Ue();z=24672+(s<<4)|0;c[z>>2]=c[B+176>>2];c[z+4>>2]=c[B+176+4>>2];c[z+8>>2]=c[B+176+8>>2];c[z+12>>2]=c[B+176+12>>2];t=+g[B+176>>2];u=+g[B+176+4>>2];v=+g[B+176+8>>2];y=+g[h+4>>2]*-t+ +g[h+20>>2]*-u+ +g[h+36>>2]*-v;w=+g[h+8>>2]*-t+ +g[h+24>>2]*-u+ +g[h+40>>2]*-v;g[B+1248+(s<<4)>>2]=+g[h>>2]*-t+ +g[h+16>>2]*-u+ +g[h+32>>2]*-v;g[B+1248+(s<<4)+4>>2]=y;g[B+1248+(s<<4)+8>>2]=w;g[B+1248+(s<<4)+12>>2]=0.0;w=t*+g[j+4>>2]+u*+g[j+20>>2]+v*+g[j+36>>2];y=t*+g[j+8>>2]+u*+g[j+24>>2]+v*+g[j+40>>2];g[B+256+(s<<4)>>2]=+g[j>>2]*t+ +g[j+16>>2]*u+ +g[j+32>>2]*v;g[B+256+(s<<4)+4>>2]=w;g[B+256+(s<<4)+8>>2]=y;g[B+256+(s<<4)+12>>2]=0.0;q=q+1|0;if((q|0)==(b|0))break;else s=s+1|0}r=b+r|0}mc[c[(c[e>>2]|0)+76>>2]&127](e,B+1248|0,B+3232|0,r);mc[c[(c[f>>2]|0)+76>>2]&127](f,B+256|0,B+2240|0,r);if((r|0)>0){z=0;b=0;q=0;s=0;w=0.0;u=999999984306749440.0;while(1){Ue();p=+g[24672+(z<<4)>>2];t=+g[24672+(z<<4)+4>>2];y=+g[24672+(z<<4)+12>>2];v=A?0.0:+g[24672+(z<<4)+8>>2];if(p*p+t*t+v*v>.01?(D=+g[B+3232+(z<<4)>>2],C=+g[B+3232+(z<<4)+4>>2],x=+g[B+3232+(z<<4)+8>>2],G=+g[B+2240+(z<<4)>>2],F=+g[B+2240+(z<<4)+4>>2],E=+g[B+2240+(z<<4)+8>>2],x=p*(G*+g[j>>2]+F*+g[j+4>>2]+E*+g[j+8>>2]+ +g[j+48>>2]-(D*+g[h>>2]+C*+g[h+4>>2]+x*+g[h+8>>2]+ +g[h+48>>2]))+t*(G*+g[j+16>>2]+F*+g[j+20>>2]+E*+g[j+24>>2]+ +g[j+52>>2]-(D*+g[h+16>>2]+C*+g[h+20>>2]+x*+g[h+24>>2]+ +g[h+52>>2]))+v*((A?0.0:G*+g[j+32>>2]+F*+g[j+36>>2]+E*+g[j+40>>2]+ +g[j+56>>2])-(A?0.0:D*+g[h+32>>2]+C*+g[h+36>>2]+x*+g[h+40>>2]+ +g[h+56>>2])),x<u):0){b=(g[k>>2]=p,c[k>>2]|0);q=(g[k>>2]=t,c[k>>2]|0);s=(g[k>>2]=v,c[k>>2]|0);u=x}else y=w;z=z+1|0;if((z|0)==(r|0)){z=b;r=s;break}else w=y}}else{z=0;q=0;r=0;y=0.0;u=999999984306749440.0}switch(c[e+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+Sb[c[(c[e>>2]|0)+48>>2]&15](e)}v=(c[k>>2]=z,+g[k>>2]);w=(c[k>>2]=q,+g[k>>2]);x=(c[k>>2]=r,+g[k>>2]);switch(c[f+4>>2]|0){case 4:case 5:case 10:case 11:case 13:case 1:case 0:case 8:break;default:+Sb[c[(c[f>>2]|0)+48>>2]&15](f)}if(u<0.0){l=0;i=B;return l|0}switch(c[e+4>>2]|0){case 8:{p=+g[e+28>>2]*+g[e+12>>2];break}case 0:{p=+g[e+44>>2];break}case 1:{p=+g[e+44>>2];break}case 13:{p=+g[e+44>>2];break}case 11:{p=+g[e+44>>2];break}case 10:{p=+g[e+44>>2];break}case 4:case 5:{p=+g[e+44>>2];break}default:p=+Sb[c[(c[e>>2]|0)+48>>2]&15](e)}b=c[f+4>>2]|0;switch(b|0){case 8:{t=+g[f+28>>2]*+g[f+12>>2];b=8;break}case 0:{t=+g[f+44>>2];b=0;break}case 1:{t=+g[f+44>>2];b=1;break}case 13:{t=+g[f+44>>2];b=13;break}case 11:{t=+g[f+44>>2];b=11;break}case 10:{t=+g[f+44>>2];b=10;break}case 4:case 5:{t=+g[f+44>>2];break}default:{t=+Sb[c[(c[f>>2]|0)+48>>2]&15](f);b=c[f+4>>2]|0}}p=u+(p+t+.5);c[B+176>>2]=9208;c[B+176+4>>2]=0;c[B+176+8>>2]=1065353216;c[B+176+12>>2]=0;g[B+176+16>>2]=0.0;c[B+176+20>>2]=0;c[B+176+24>>2]=d;c[B+176+28>>2]=e;c[B+176+32>>2]=f;c[B+176+36>>2]=c[e+4>>2];c[B+176+40>>2]=b;g[B+176+44>>2]=+Sb[c[(c[e>>2]|0)+48>>2]&15](e);g[B+176+48>>2]=+Sb[c[(c[f>>2]|0)+48>>2]&15](f);a[B+176+52>>0]=0;c[B+176+60>>2]=-1;c[B+176+72>>2]=1;c[B+176+76>>2]=1;E=v*p+ +g[h+48>>2];F=w*p+ +g[h+52>>2];G=x*p+ +g[h+56>>2];c[B+44>>2]=c[h>>2];c[B+44+4>>2]=c[h+4>>2];c[B+44+8>>2]=c[h+8>>2];c[B+44+12>>2]=c[h+12>>2];c[B+44+16>>2]=c[h+16>>2];c[B+44+16+4>>2]=c[h+16+4>>2];c[B+44+16+8>>2]=c[h+16+8>>2];c[B+44+16+12>>2]=c[h+16+12>>2];c[B+44+32>>2]=c[h+32>>2];c[B+44+32+4>>2]=c[h+32+4>>2];c[B+44+32+8>>2]=c[h+32+8>>2];c[B+44+32+12>>2]=c[h+32+12>>2];g[B+44+48>>2]=E;g[B+44+52>>2]=F;g[B+44+56>>2]=G;g[B+44+60>>2]=0.0;c[B+44+64>>2]=c[j>>2];c[B+44+64+4>>2]=c[j+4>>2];c[B+44+64+8>>2]=c[j+8>>2];c[B+44+64+12>>2]=c[j+12>>2];c[B+44+80>>2]=c[j+16>>2];c[B+44+80+4>>2]=c[j+16+4>>2];c[B+44+80+8>>2]=c[j+16+8>>2];c[B+44+80+12>>2]=c[j+16+12>>2];c[B+44+96>>2]=c[j+32>>2];c[B+44+96+4>>2]=c[j+32+4>>2];c[B+44+96+8>>2]=c[j+32+8>>2];c[B+44+96+12>>2]=c[j+32+12>>2];c[B+44+112>>2]=c[j+48>>2];c[B+44+112+4>>2]=c[j+48+4>>2];c[B+44+112+8>>2]=c[j+48+8>>2];c[B+44+112+12>>2]=c[j+48+12>>2];g[B+44+128>>2]=999999984306749440.0;c[B>>2]=9092;a[B+40>>0]=0;g[B+176+4>>2]=-v;g[B+176+8>>2]=-w;g[B+176+12>>2]=-x;g[B+176+16>>2]=0.0;Vc(B+176|0,B+44|0,B,o,0);p=p-+g[B+36>>2];b=a[B+40>>0]|0;if(b<<24>>24){F=+g[B+24>>2]-w*p;G=+g[B+28>>2]-x*p;g[m>>2]=+g[B+20>>2]-v*p;g[m+4>>2]=F;g[m+8>>2]=G;g[m+12>>2]=0.0;c[n>>2]=c[B+20>>2];c[n+4>>2]=c[B+20+4>>2];c[n+8>>2]=c[B+20+8>>2];c[n+12>>2]=c[B+20+12>>2];c[l>>2]=z;c[l+4>>2]=q;c[l+8>>2]=r;g[l+12>>2]=y}l=b<<24>>24!=0;i=B;return l|0}function Zc(d,f,h,i){d=d|0;f=f|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0;c[d+168>>2]=c[d+152>>2];c[f>>2]=9012;c[f+52>>2]=282;a[f+60>>0]=0;a[f+80>>0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;a[f+100>>0]=1;c[f+96>>2]=0;c[f+88>>2]=0;c[f+92>>2]=0;a[f+120>>0]=1;c[f+116>>2]=0;c[f+108>>2]=0;c[f+112>>2]=0;a[f+140>>0]=1;c[f+136>>2]=0;c[f+128>>2]=0;c[f+132>>2]=0;c[f+144>>2]=0;a[f+164>>0]=1;c[f+160>>2]=0;c[f+152>>2]=0;c[f+156>>2]=0;c[f+168>>2]=0;c[f+4>>2]=-8388609;c[f+8>>2]=-8388609;c[f+12>>2]=-8388609;g[f+16>>2]=0.0;c[f+20>>2]=2139095039;c[f+24>>2]=2139095039;c[f+28>>2]=2139095039;g[f+32>>2]=0.0;h=c[d+56>>2]|0;if(i){c[f+56>>2]=ow(h|0)|0;a[f+4>>0]=a[d+4+3>>0]|0;a[f+5>>0]=a[d+4+2>>0]|0;a[f+6>>0]=a[d+4+1>>0]|0;a[f+7>>0]=a[d+4>>0]|0;a[f+8>>0]=a[d+8+3>>0]|0;a[f+9>>0]=a[d+8+2>>0]|0;a[f+10>>0]=a[d+8+1>>0]|0;a[f+11>>0]=a[d+8>>0]|0;a[f+12>>0]=a[d+12+3>>0]|0;a[f+13>>0]=a[d+12+2>>0]|0;a[f+14>>0]=a[d+12+1>>0]|0;a[f+15>>0]=a[d+12>>0]|0;a[f+16>>0]=a[d+16+3>>0]|0;a[f+17>>0]=a[d+16+2>>0]|0;a[f+18>>0]=a[d+16+1>>0]|0;a[f+19>>0]=a[d+16>>0]|0;a[f+20>>0]=a[d+20+3>>0]|0;a[f+21>>0]=a[d+20+2>>0]|0;a[f+22>>0]=a[d+20+1>>0]|0;a[f+23>>0]=a[d+20>>0]|0;a[f+24>>0]=a[d+24+3>>0]|0;a[f+25>>0]=a[d+24+2>>0]|0;a[f+26>>0]=a[d+24+1>>0]|0;a[f+27>>0]=a[d+24>>0]|0;a[f+28>>0]=a[d+28+3>>0]|0;a[f+29>>0]=a[d+28+2>>0]|0;a[f+30>>0]=a[d+28+1>>0]|0;a[f+31>>0]=a[d+28>>0]|0;a[f+32>>0]=a[d+32+3>>0]|0;a[f+33>>0]=a[d+32+2>>0]|0;a[f+34>>0]=a[d+32+1>>0]|0;a[f+35>>0]=a[d+32>>0]|0;a[f+36>>0]=a[d+36+3>>0]|0;a[f+37>>0]=a[d+36+2>>0]|0;a[f+38>>0]=a[d+36+1>>0]|0;a[f+39>>0]=a[d+36>>0]|0;a[f+40>>0]=a[d+40+3>>0]|0;a[f+41>>0]=a[d+40+2>>0]|0;a[f+42>>0]=a[d+40+1>>0]|0;a[f+43>>0]=a[d+40>>0]|0;a[f+44>>0]=a[d+44+3>>0]|0;a[f+45>>0]=a[d+44+2>>0]|0;a[f+46>>0]=a[d+44+1>>0]|0;a[f+47>>0]=a[d+44>>0]|0;a[f+48>>0]=a[d+48+3>>0]|0;a[f+49>>0]=a[d+48+2>>0]|0;a[f+50>>0]=a[d+48+1>>0]|0;a[f+51>>0]=a[d+48>>0]|0;c[f+144>>2]=ow(c[d+144>>2]|0)|0;h=ow(c[d+168>>2]|0)|0}else{c[f+56>>2]=h;c[f+4>>2]=c[d+4>>2];c[f+4+4>>2]=c[d+4+4>>2];c[f+4+8>>2]=c[d+4+8>>2];c[f+4+12>>2]=c[d+4+12>>2];c[f+20>>2]=c[d+20>>2];c[f+20+4>>2]=c[d+20+4>>2];c[f+20+8>>2]=c[d+20+8>>2];c[f+20+12>>2]=c[d+20+12>>2];c[f+36>>2]=c[d+36>>2];c[f+36+4>>2]=c[d+36+4>>2];c[f+36+8>>2]=c[d+36+8>>2];c[f+36+12>>2]=c[d+36+12>>2];c[f+144>>2]=c[d+144>>2];h=c[d+168>>2]|0}c[f+168>>2]=h;a[f+60>>0]=a[d+60>>0]|0;l=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){h=c[f+96>>2]|0;if(h|0){if(a[f+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[f+96>>2]=0}c[f+88>>2]=0;c[f+88+4>>2]=0;c[f+88+8>>2]=0;a[f+88+12>>0]=0;c[f+96>>2]=f+172;c[f+88>>2]=l;c[f+92>>2]=l;if(i)if((l|0)>0){j=c[d+96>>2]|0;h=f+172|0;k=0;do{m=j+(k<<6)|0;o=h+(k<<6)|0;a[o>>0]=a[m+3>>0]|0;a[o+1>>0]=a[m+2>>0]|0;a[o+2>>0]=a[m+1>>0]|0;a[o+3>>0]=a[m>>0]|0;o=j+(k<<6)+4|0;m=h+(k<<6)+4|0;a[m>>0]=a[o+3>>0]|0;a[m+1>>0]=a[o+2>>0]|0;a[m+2>>0]=a[o+1>>0]|0;a[m+3>>0]=a[o>>0]|0;m=j+(k<<6)+8|0;o=h+(k<<6)+8|0;a[o>>0]=a[m+3>>0]|0;a[o+1>>0]=a[m+2>>0]|0;a[o+2>>0]=a[m+1>>0]|0;a[o+3>>0]=a[m>>0]|0;o=j+(k<<6)+12|0;h=h+(k<<6)+12|0;a[h>>0]=a[o+3>>0]|0;a[h+1>>0]=a[o+2>>0]|0;a[h+2>>0]=a[o+1>>0]|0;a[h+3>>0]=a[o>>0]|0;h=c[d+96>>2]|0;o=h+(k<<6)+16|0;m=c[f+96>>2]|0;n=m+(k<<6)+16|0;a[n>>0]=a[o+3>>0]|0;a[n+1>>0]=a[o+2>>0]|0;a[n+2>>0]=a[o+1>>0]|0;a[n+3>>0]=a[o>>0]|0;n=h+(k<<6)+20|0;o=m+(k<<6)+20|0;a[o>>0]=a[n+3>>0]|0;a[o+1>>0]=a[n+2>>0]|0;a[o+2>>0]=a[n+1>>0]|0;a[o+3>>0]=a[n>>0]|0;o=h+(k<<6)+24|0;n=m+(k<<6)+24|0;a[n>>0]=a[o+3>>0]|0;a[n+1>>0]=a[o+2>>0]|0;a[n+2>>0]=a[o+1>>0]|0;a[n+3>>0]=a[o>>0]|0;h=h+(k<<6)+28|0;m=m+(k<<6)+28|0;a[m>>0]=a[h+3>>0]|0;a[m+1>>0]=a[h+2>>0]|0;a[m+2>>0]=a[h+1>>0]|0;a[m+3>>0]=a[h>>0]|0;j=c[d+96>>2]|0;m=ow(c[j+(k<<6)+32>>2]|0)|0;h=c[f+96>>2]|0;c[h+(k<<6)+32>>2]=m;c[h+(k<<6)+36>>2]=ow(c[j+(k<<6)+36>>2]|0)|0;c[h+(k<<6)+40>>2]=ow(c[j+(k<<6)+40>>2]|0)|0;k=k+1|0}while((k|0)!=(l|0))}else h=f+172|0;else if((l|0)>0){h=f+172|0;j=c[d+96>>2]|0;k=0;do{h=h+(k<<6)|0;o=j+(k<<6)|0;c[h>>2]=c[o>>2];c[h+4>>2]=c[o+4>>2];c[h+8>>2]=c[o+8>>2];c[h+12>>2]=c[o+12>>2];h=(c[f+96>>2]|0)+(k<<6)+16|0;o=(c[d+96>>2]|0)+(k<<6)+16|0;c[h>>2]=c[o>>2];c[h+4>>2]=c[o+4>>2];c[h+8>>2]=c[o+8>>2];c[h+12>>2]=c[o+12>>2];j=c[d+96>>2]|0;h=c[f+96>>2]|0;c[h+(k<<6)+32>>2]=c[j+(k<<6)+32>>2];c[h+(k<<6)+36>>2]=c[j+(k<<6)+36>>2];c[h+(k<<6)+40>>2]=c[j+(k<<6)+40>>2];k=k+1|0}while((k|0)!=(l|0))}else h=f+172|0;if(h|0){if(a[f+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[f+96>>2]=0}c[f+88>>2]=0;c[f+88+4>>2]=0;c[f+88+8>>2]=0;a[f+88+12>>0]=0;h=l<<6}else{h=c[f+136>>2]|0;if(h|0){if(a[f+140>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[f+136>>2]=0}c[f+128>>2]=0;c[f+128+4>>2]=0;c[f+128+8>>2]=0;a[f+128+12>>0]=0;c[f+136>>2]=f+172;c[f+128>>2]=l;c[f+132>>2]=l;if(i){if((l|0)>0){h=c[d+136>>2]|0;j=0;do{o=e[h+(j<<4)>>1]|0;b[f+172+(j<<4)>>1]=o>>>8|o<<8;o=e[h+(j<<4)+2>>1]|0;b[f+172+(j<<4)+2>>1]=o>>>8|o<<8;o=e[h+(j<<4)+4>>1]|0;b[f+172+(j<<4)+4>>1]=o>>>8|o<<8;o=e[h+(j<<4)+6>>1]|0;b[f+172+(j<<4)+6>>1]=o>>>8|o<<8;o=e[h+(j<<4)+8>>1]|0;b[f+172+(j<<4)+8>>1]=o>>>8|o<<8;o=e[h+(j<<4)+10>>1]|0;b[f+172+(j<<4)+10>>1]=o>>>8|o<<8;c[f+172+(j<<4)+12>>2]=ow(c[h+(j<<4)+12>>2]|0)|0;j=j+1|0}while((j|0)!=(l|0))}}else if((l|0)>0){h=c[d+136>>2]|0;j=0;do{b[f+172+(j<<4)>>1]=b[h+(j<<4)>>1]|0;b[f+172+(j<<4)+2>>1]=b[h+(j<<4)+2>>1]|0;b[f+172+(j<<4)+4>>1]=b[h+(j<<4)+4>>1]|0;b[f+172+(j<<4)+6>>1]=b[h+(j<<4)+6>>1]|0;b[f+172+(j<<4)+8>>1]=b[h+(j<<4)+8>>1]|0;b[f+172+(j<<4)+10>>1]=b[h+(j<<4)+10>>1]|0;c[f+172+(j<<4)+12>>2]=c[h+(j<<4)+12>>2];j=j+1|0}while((j|0)!=(l|0))}if(c[f+136>>2]|0)c[f+136>>2]=0;c[f+128>>2]=0;c[f+128+4>>2]=0;c[f+128+8>>2]=0;a[f+128+12>>0]=0;h=l<<4}l=f+172+h|0;h=c[d+168>>2]|0;j=c[f+160>>2]|0;if(j|0){if(a[f+164>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[f+160>>2]=0}c[f+152>>2]=0;c[f+152+4>>2]=0;c[f+152+8>>2]=0;a[f+152+12>>0]=0;c[f+160>>2]=l;c[f+152>>2]=h;c[f+156>>2]=h;k=c[d+168>>2]|0;if(i){if((k|0)>0){h=c[d+160>>2]|0;j=0;do{o=e[h+(j<<5)>>1]|0;b[l+(j<<5)>>1]=o>>>8|o<<8;o=e[h+(j<<5)+2>>1]|0;b[l+(j<<5)+2>>1]=o>>>8|o<<8;o=e[h+(j<<5)+4>>1]|0;b[l+(j<<5)+4>>1]=o>>>8|o<<8;o=e[h+(j<<5)+6>>1]|0;b[l+(j<<5)+6>>1]=o>>>8|o<<8;o=e[h+(j<<5)+8>>1]|0;b[l+(j<<5)+8>>1]=o>>>8|o<<8;o=e[h+(j<<5)+10>>1]|0;b[l+(j<<5)+10>>1]=o>>>8|o<<8;c[l+(j<<5)+12>>2]=ow(c[h+(j<<5)+12>>2]|0)|0;c[l+(j<<5)+16>>2]=ow(c[h+(j<<5)+16>>2]|0)|0;j=j+1|0}while((j|0)!=(k|0))}}else if((k|0)>0){h=c[d+160>>2]|0;j=0;do{b[l+(j<<5)>>1]=b[h+(j<<5)>>1]|0;b[l+(j<<5)+2>>1]=b[h+(j<<5)+2>>1]|0;b[l+(j<<5)+4>>1]=b[h+(j<<5)+4>>1]|0;b[l+(j<<5)+6>>1]=b[h+(j<<5)+6>>1]|0;b[l+(j<<5)+8>>1]=b[h+(j<<5)+8>>1]|0;b[l+(j<<5)+10>>1]=b[h+(j<<5)+10>>1]|0;c[l+(j<<5)+12>>2]=c[h+(j<<5)+12>>2];c[l+(j<<5)+16>>2]=c[h+(j<<5)+16>>2];c[l+(j<<5)+20>>2]=0;c[l+(j<<5)+24>>2]=0;c[l+(j<<5)+28>>2]=0;j=j+1|0}while((j|0)<(c[d+168>>2]|0))}if(!(c[f+160>>2]|0)){c[f>>2]=0;c[f+152>>2]=0;c[f+152+4>>2]=0;c[f+152+8>>2]=0;a[f+152+12>>0]=0;return 1}c[f+160>>2]=0;c[f>>2]=0;c[f+152>>2]=0;c[f+152+4>>2]=0;c[f+152+8>>2]=0;a[f+152+12>>0]=0;return 1}function _c(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0,L=0,M=0.0,P=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0;I=i;i=i+96|0;if(!(c[b+12>>2]|0)){i=I;return}f=(a[b+16>>0]|0)!=0;L=f?e:d;f=f?d:e;j=c[L+4>>2]|0;k=c[f+4>>2]|0;L=c[L+12>>2]|0;aa=+g[L>>2];$=+g[L+16>>2];_=+g[L+32>>2];Z=+g[L+4>>2];Y=+g[L+20>>2];o=+g[L+36>>2];l=+g[L+8>>2];r=+g[L+24>>2];y=+g[L+40>>2];T=+g[L+48>>2];S=+g[L+52>>2];P=+g[L+56>>2];K=c[f+12>>2]|0;X=+g[K>>2];W=+g[K+16>>2];p=+g[K+32>>2];V=+g[K+4>>2];U=+g[K+20>>2];q=+g[K+36>>2];x=+g[K+8>>2];v=+g[K+24>>2];t=+g[K+40>>2];M=-+g[K+48>>2];E=-+g[K+52>>2];F=-+g[K+56>>2];G=+g[L>>2];H=+g[L+16>>2];D=+g[L+32>>2];B=+g[L+4>>2];A=+g[L+20>>2];z=+g[L+36>>2];w=+g[L+8>>2];u=+g[L+24>>2];s=+g[L+40>>2];L=c[(c[j>>2]|0)+64>>2]|0;n=-+g[k+48>>2];m=-+g[k+52>>2];C=-+g[k+56>>2];g[I>>2]=(aa*X+$*W+_*p)*n+(aa*V+$*U+_*q)*m+(aa*x+$*v+_*t)*C;g[I+4>>2]=(Z*X+Y*W+o*p)*n+(Z*V+Y*U+o*q)*m+(Z*x+Y*v+o*t)*C;g[I+8>>2]=(l*X+r*W+y*p)*n+(l*V+r*U+y*q)*m+(l*x+r*v+y*t)*C;g[I+12>>2]=0.0;ic[L&127](I+16|0,j,I);C=+g[I+16>>2];y=+g[I+16+4>>2];r=+g[I+16+8>>2];l=+g[k+48>>2];m=+g[k+52>>2];n=+g[k+56>>2];o=n*(T*x+S*v+P*t+(x*M+v*E+t*F)+((x*G+v*H+t*D)*C+(x*B+v*A+t*z)*y+(x*w+v*u+t*s)*r))+(l*(T*X+S*W+P*p+(X*M+W*E+p*F)+((X*G+W*H+p*D)*C+(X*B+W*A+p*z)*y+(X*w+W*u+p*s)*r))+m*(T*V+S*U+P*q+(V*M+U*E+q*F)+((V*G+U*H+q*D)*C+(V*B+U*A+q*z)*y+(V*w+U*u+q*s)*r)))-+g[k+64>>2];p=T*X+S*W+P*p+(X*M+W*E+p*F)+((X*G+W*H+p*D)*C+(X*B+W*A+p*z)*y+(X*w+W*u+p*s)*r)-l*o;q=T*V+S*U+P*q+(V*M+U*E+q*F)+((V*G+U*H+q*D)*C+(V*B+U*A+q*z)*y+(V*w+U*u+q*s)*r)-m*o;r=T*x+S*v+P*t+(x*M+v*E+t*F)+((x*G+v*H+t*D)*C+(x*B+v*A+t*z)*y+(x*w+v*u+t*s)*r)-n*o;L=c[f+12>>2]|0;s=+g[L>>2];t=+g[L+4>>2];u=+g[L+8>>2];v=+g[L+16>>2];w=+g[L+20>>2];x=+g[L+24>>2];y=+g[L+32>>2];z=+g[L+36>>2];A=+g[L+40>>2];B=+g[L+48>>2];C=+g[L+52>>2];D=+g[L+56>>2];L=c[b+12>>2]|0;K=o<+g[L+752>>2];c[h+4>>2]=L;if(K){L=c[f+12>>2]|0;$=l*+g[L+16>>2]+m*+g[L+20>>2]+n*+g[L+24>>2];aa=l*+g[L+32>>2]+m*+g[L+36>>2]+n*+g[L+40>>2];g[I+80>>2]=+g[L>>2]*l+ +g[L+4>>2]*m+ +g[L+8>>2]*n;g[I+80+4>>2]=$;g[I+80+8>>2]=aa;g[I+80+12>>2]=0.0;g[I+64>>2]=u*r+(s*p+t*q)+B;g[I+64+4>>2]=p*v+q*w+r*x+C;g[I+64+8>>2]=p*y+q*z+r*A+D;g[I+64+12>>2]=0.0;hc[c[(c[h>>2]|0)+16>>2]&15](h,I+80|0,I+64|0,o)}if((c[j+4>>2]|0)<7?(c[(c[h+4>>2]|0)+748>>2]|0)<(c[b+24>>2]|0):0){l=+g[k+56>>2];if(+N(+l)>.7071067690849304){n=+g[k+52>>2];aa=1.0/+O(+(l*l+n*n));m=0.0;n=n*aa;l=-(l*aa)}else{aa=+g[k+48>>2];m=+g[k+52>>2];l=1.0/+O(+(aa*aa+m*m));m=-(m*l);n=0.0;l=aa*l}F=.019999999552965164/+Sb[c[(c[j>>2]|0)+16>>2]&15](j);F=(F>.39269909262657166?.39269909262657166:F)*.5;E=+R(+F)/+O(+(m*m+l*l+n*n));H=m*E;G=l*E;E=n*E;F=+Q(+F);f=c[b+20>>2]|0;if((f|0)>0){j=0;do{v=+g[k+48>>2];aa=+g[k+52>>2];B=+g[k+56>>2];z=+(j|0)*(6.2831854820251465/+(f|0))*.5;$=+R(+z)/+O(+(v*v+aa*aa+B*B));z=+Q(+z);A=E*-(aa*$)+(H*z+F*-(v*$))-G*-(B*$);x=H*-(B*$)+(G*z+F*-(aa*$))-E*-(v*$);da=G*-(v*$)+(E*z+F*-(B*$))-H*-(aa*$);D=F*z-H*-(v*$)-G*-(aa*$)-E*-(B*$);ia=B*$*x+(v*$*D+z*A)-aa*$*da;ha=v*$*da+(z*x+aa*$*D)-B*$*A;la=aa*$*A+(B*$*D+z*da)-v*$*x;da=z*D-v*$*A-aa*$*x-B*$*da;f=(a[b+16>>0]|0)!=0;ba=f?e:d;f=f?d:e;L=c[ba+4>>2]|0;K=c[f+4>>2]|0;ba=c[ba+12>>2]|0;$=+g[ba>>2];B=+g[ba+4>>2];x=+g[ba+8>>2];aa=+g[ba+16>>2];A=+g[ba+20>>2];v=+g[ba+24>>2];D=+g[ba+32>>2];z=+g[ba+36>>2];t=+g[ba+40>>2];V=+g[ba+48>>2];W=+g[ba+52>>2];X=+g[ba+56>>2];ba=c[f+12>>2]|0;P=+g[ba>>2];S=+g[ba+16>>2];p=+g[ba+32>>2];T=+g[ba+4>>2];U=+g[ba+20>>2];q=+g[ba+36>>2];w=+g[ba+8>>2];u=+g[ba+24>>2];s=+g[ba+40>>2];Y=-+g[ba+48>>2];Z=-+g[ba+52>>2];_=-+g[ba+56>>2];ga=ia*(2.0/(ia*ia+ha*ha+la*la+da*da));n=ha*(2.0/(ia*ia+ha*ha+la*la+da*da));ca=la*(2.0/(ia*ia+ha*ha+la*la+da*da));na=x*(ia*ca-da*n)+(B*(ia*n+da*ca)+$*(1.0-(ha*n+la*ca)));ka=x*(ha*ca+da*ga)+($*(ia*n-da*ca)+B*(1.0-(ia*ga+la*ca)));l=$*(ia*ca+da*n)+B*(ha*ca-da*ga)+x*(1.0-(ia*ga+ha*n));ma=v*(ia*ca-da*n)+(A*(ia*n+da*ca)+aa*(1.0-(ha*n+la*ca)));ja=v*(ha*ca+da*ga)+(aa*(ia*n-da*ca)+A*(1.0-(ia*ga+la*ca)));y=aa*(ia*ca+da*n)+A*(ha*ca-da*ga)+v*(1.0-(ia*ga+ha*n));oa=t*(ia*ca-da*n)+(z*(ia*n+da*ca)+D*(1.0-(ha*n+la*ca)));la=t*(ha*ca+da*ga)+(D*(ia*n-da*ca)+z*(1.0-(ia*ga+la*ca)));n=D*(ia*ca+da*n)+z*(ha*ca-da*ga)+t*(1.0-(ia*ga+ha*n));ha=+g[ba>>2];ga=+g[ba+16>>2];ia=+g[ba+32>>2];da=+g[ba+4>>2];ca=+g[ba+20>>2];ea=+g[ba+36>>2];m=+g[ba+8>>2];r=+g[ba+24>>2];o=+g[ba+40>>2];ba=c[(c[L>>2]|0)+64>>2]|0;fa=-+g[K+48>>2];M=-+g[K+52>>2];C=-+g[K+56>>2];g[I+64>>2]=(ia*oa+(ha*na+ga*ma))*fa+(ea*oa+(da*na+ca*ma))*M+(o*oa+(m*na+r*ma))*C;g[I+64+4>>2]=(ia*la+(ha*ka+ga*ja))*fa+(ea*la+(da*ka+ca*ja))*M+(o*la+(m*ka+r*ja))*C;g[I+64+8>>2]=(ia*n+(ha*l+ga*y))*fa+(ea*n+(da*l+ca*y))*M+(o*n+(m*l+r*y))*C;g[I+64+12>>2]=0.0;ic[ba&127](I+80|0,L,I+64|0);C=+g[I+80>>2];y=+g[I+80+4>>2];r=+g[I+80+8>>2];l=+g[K+48>>2];m=+g[K+52>>2];n=+g[K+56>>2];o=n*(V*w+W*u+X*s+(w*Y+u*Z+s*_)+(($*w+aa*u+D*s)*C+(B*w+A*u+z*s)*y+(x*w+v*u+t*s)*r))+(l*(V*P+W*S+X*p+(P*Y+S*Z+p*_)+(($*P+aa*S+D*p)*C+(B*P+A*S+z*p)*y+(x*P+v*S+t*p)*r))+m*(V*T+W*U+X*q+(T*Y+U*Z+q*_)+(($*T+aa*U+D*q)*C+(B*T+A*U+z*q)*y+(x*T+v*U+t*q)*r)))-+g[K+64>>2];p=V*P+W*S+X*p+(P*Y+S*Z+p*_)+(($*P+aa*S+D*p)*C+(B*P+A*S+z*p)*y+(x*P+v*S+t*p)*r)-l*o;q=V*T+W*U+X*q+(T*Y+U*Z+q*_)+(($*T+aa*U+D*q)*C+(B*T+A*U+z*q)*y+(x*T+v*U+t*q)*r)-m*o;r=V*w+W*u+X*s+(w*Y+u*Z+s*_)+(($*w+aa*u+D*s)*C+(B*w+A*u+z*s)*y+(x*w+v*u+t*s)*r)-n*o;K=c[f+12>>2]|0;s=+g[K>>2];t=+g[K+4>>2];u=+g[K+8>>2];v=+g[K+16>>2];w=+g[K+20>>2];x=+g[K+24>>2];y=+g[K+32>>2];z=+g[K+36>>2];A=+g[K+40>>2];B=+g[K+48>>2];C=+g[K+52>>2];D=+g[K+56>>2];K=c[b+12>>2]|0;L=o<+g[K+752>>2];c[h+4>>2]=K;if(L){ba=c[f+12>>2]|0;na=l*+g[ba+16>>2]+m*+g[ba+20>>2]+n*+g[ba+24>>2];oa=l*+g[ba+32>>2]+m*+g[ba+36>>2]+n*+g[ba+40>>2];g[I+48>>2]=+g[ba>>2]*l+ +g[ba+4>>2]*m+ +g[ba+8>>2]*n;g[I+48+4>>2]=na;g[I+48+8>>2]=oa;g[I+48+12>>2]=0.0;g[I+32>>2]=u*r+(s*p+t*q)+B;g[I+32+4>>2]=p*v+q*w+r*x+C;g[I+32+8>>2]=p*y+q*z+r*A+D;g[I+32+12>>2]=0.0;hc[c[(c[h>>2]|0)+16>>2]&15](h,I+48|0,I+32|0,o)}j=j+1|0;f=c[b+20>>2]|0}while((j|0)<(f|0))}}do if((a[b+8>>0]|0?c[(c[b+12>>2]|0)+748>>2]|0:0)?(J=c[h+4>>2]|0,c[J+748>>2]|0):0){j=c[J+740>>2]|0;k=c[(c[h+8>>2]|0)+8>>2]|0;f=c[(c[h+12>>2]|0)+8>>2]|0;if((j|0)==(k|0)){ef(J,j+4|0,f+4|0);break}else{ef(J,f+4|0,k+4|0);break}}while(0);i=I;return}function $c(b){b=b|0;var d=0,e=0.0,f=0.0,h=0.0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0,H=0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0;H=i;i=i+192|0;li(11018);d=c[b+1112>>2]|0;if((d|0)>0){G=0;do{F=c[(c[b+1120>>2]|0)+(G<<2)>>2]|0;E=c[F+24>>2]|0;if(E){j=H+144|0;k=j+48|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(k|0));g[H+144>>2]=9.999999747378752e-05;g[H+144+20>>2]=1.9999999494757503e-04;g[H+144+40>>2]=2.9999998514540493e-04;if((E|0)>0){d=c[F+32>>2]|0;j=c[F+12>>2]|0;f=0.0;h=0.0;e=0.0;k=0;do{D=c[d+(k<<2)>>2]|0;C=+g[j+(k<<2)>>2];f=f+ +g[D+8>>2]*C;e=e+C*+g[D+12>>2];h=h+C*+g[D+16>>2];k=k+1|0}while((k|0)!=(E|0))}else{f=0.0;h=0.0;e=0.0}r=+g[F+128>>2];t=f*r;s=e*r;r=h*r;g[F+228>>2]=t;g[F+232>>2]=s;g[F+236>>2]=r;g[F+240>>2]=0.0;if((E|0)>0){d=c[F+32>>2]|0;j=c[F+52>>2]|0;e=9.999999747378752e-05;f=+g[H+144+4>>2];h=+g[H+144+8>>2];l=+g[H+144+16>>2];m=1.9999999494757503e-04;n=+g[H+144+24>>2];o=0.0;p=0.0;q=2.9999998514540493e-04;k=0;while(1){D=c[d+(k<<2)>>2]|0;x=+g[D+8>>2]-t;y=+g[D+12>>2]-s;B=+g[D+16>>2]-r;z=+g[j+(k<<4)>>2];A=+g[j+(k<<4)+4>>2];C=+g[j+(k<<4)+8>>2];e=x*z+e;f=x*A+f;h=x*C+h;l=y*z+l;m=y*A+m;n=y*C+n;o=B*z+o;p=B*A+p;q=B*C+q;if((k|0)==(E+-1|0))break;k=k+1|0}g[H+144>>2]=e;g[H+144+4>>2]=f;g[H+144+8>>2]=h;g[H+144+16>>2]=l;g[H+144+20>>2]=m;g[H+144+24>>2]=n;g[H+144+32>>2]=o;g[H+144+36>>2]=p;g[H+144+40>>2]=q}if((a[22520]|0)==0?Wa(22520)|0:0){g[5787]=9.999999747378752e-05;c[5788]=16;_a(22520)}md(H+144|0,H+96|0,H+48|0);c[F+108>>2]=c[F+228>>2];c[F+108+4>>2]=c[F+228+4>>2];c[F+108+8>>2]=c[F+228+8>>2];c[F+108+12>>2]=c[F+228+12>>2];c[F+60>>2]=c[H+96>>2];c[F+60+4>>2]=c[H+96+4>>2];c[F+60+8>>2]=c[H+96+8>>2];c[F+60+12>>2]=c[H+96+12>>2];c[F+76>>2]=c[H+96+16>>2];c[F+76+4>>2]=c[H+96+16+4>>2];c[F+76+8>>2]=c[H+96+16+8>>2];c[F+76+12>>2]=c[H+96+16+12>>2];c[F+92>>2]=c[H+96+32>>2];c[F+92+4>>2]=c[H+96+32+4>>2];c[F+92+8>>2]=c[H+96+32+8>>2];c[F+92+12>>2]=c[H+96+32+12>>2];m=+g[F+132>>2];K=+g[F+60>>2];n=+g[F+148>>2];J=+g[F+64>>2];o=+g[F+164>>2];A=+g[F+68>>2];p=+g[F+136>>2];q=+g[F+152>>2];r=+g[F+168>>2];s=+g[F+140>>2];t=+g[F+156>>2];C=+g[F+172>>2];I=+g[F+76>>2];e=+g[F+80>>2];B=+g[F+84>>2];l=+g[F+92>>2];h=+g[F+96>>2];f=+g[F+100>>2];u=(m*K+n*J+o*A)*K+(K*p+J*q+A*r)*J+(K*s+J*t+A*C)*A;v=(m*K+n*J+o*A)*I+(K*p+J*q+A*r)*e+(K*s+J*t+A*C)*B;w=(m*K+n*J+o*A)*l+(K*p+J*q+A*r)*h+(K*s+J*t+A*C)*f;x=(m*I+n*e+o*B)*K+(p*I+q*e+r*B)*J+(s*I+t*e+C*B)*A;y=(m*I+n*e+o*B)*I+(p*I+q*e+r*B)*e+(s*I+t*e+C*B)*B;z=(m*I+n*e+o*B)*l+(p*I+q*e+r*B)*h+(s*I+t*e+C*B)*f;A=K*(m*l+n*h+o*f)+(p*l+q*h+r*f)*J+(s*l+t*h+C*f)*A;B=I*(m*l+n*h+o*f)+(p*l+q*h+r*f)*e+(s*l+t*h+C*f)*B;C=(m*l+n*h+o*f)*l+(p*l+q*h+r*f)*h+(s*l+t*h+C*f)*f;g[F+180>>2]=u;g[F+184>>2]=v;g[F+188>>2]=w;g[F+192>>2]=0.0;g[F+196>>2]=x;g[F+200>>2]=y;g[F+204>>2]=z;g[F+208>>2]=0.0;g[F+212>>2]=A;g[F+216>>2]=B;g[F+220>>2]=C;g[F+224>>2]=0.0;c[F+316>>2]=0;c[F+316+4>>2]=0;c[F+316+8>>2]=0;c[F+316+12>>2]=0;c[F+316+16>>2]=0;c[F+316+20>>2]=0;c[F+316+24>>2]=0;c[F+316+28>>2]=0;if((E|0)>0){d=c[F+32>>2]|0;j=c[F+12>>2]|0;r=+g[F+228>>2];s=+g[F+232>>2];t=+g[F+236>>2];q=0.0;p=0.0;o=0.0;n=0.0;m=0.0;e=0.0;k=0;do{D=c[d+(k<<2)>>2]|0;M=+g[j+(k<<2)>>2];J=+g[D+40>>2]*M;L=M*+g[D+44>>2];M=M*+g[D+48>>2];q=J+q;g[F+316>>2]=q;p=L+p;g[F+320>>2]=p;o=M+o;g[F+324>>2]=o;I=+g[D+8>>2]-r;K=+g[D+12>>2]-s;N=+g[D+16>>2]-t;n=n+(M*K-L*N);g[F+332>>2]=n;m=J*N-M*I+m;g[F+336>>2]=m;e=L*I-J*K+e;g[F+340>>2]=e;k=k+1|0}while((k|0)!=(E|0));d=F+332|0;D=F+316|0}else{d=F+332|0;D=F+316|0;q=0.0;p=0.0;o=0.0;n=0.0;m=0.0;e=0.0}M=+g[F+128>>2];N=1.0-+g[F+356>>2];g[F+316>>2]=q*M*N;g[F+320>>2]=M*p*N;g[F+324>>2]=M*o*N;g[F+328>>2]=0.0;N=1.0-+g[F+360>>2];g[d>>2]=(u*n+v*m+w*e)*N;g[F+336>>2]=(n*x+m*y+e*z)*N;g[F+340>>2]=N*(n*A+m*B+e*C);g[F+344>>2]=0.0;j=F+244|0;k=j+72|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(k|0));e=+g[F+364>>2];a:do if(e>0.0?(c[F+24>>2]|0)>0:0){d=0;while(1){k=c[(c[F+32>>2]|0)+(d<<2)>>2]|0;j=c[F+52>>2]|0;I=+g[j+(d<<4)>>2];J=+g[j+(d<<4)+4>>2];K=+g[j+(d<<4)+8>>2];L=+g[k+8>>2];M=+g[k+12>>2];N=+g[k+16>>2];M=M+e*(I*+g[F+76>>2]+J*+g[F+80>>2]+K*+g[F+84>>2]+ +g[F+112>>2]-M);N=N+e*(I*l+J*h+K*f+ +g[F+116>>2]-N);g[k+8>>2]=L+e*(I*+g[F+60>>2]+J*+g[F+64>>2]+K*+g[F+68>>2]+ +g[F+108>>2]-L);g[k+12>>2]=M;g[k+16>>2]=N;g[k+20>>2]=0.0;d=d+1|0;if((d|0)>=(c[F+24>>2]|0))break a;l=+g[F+92>>2];h=+g[F+96>>2];f=+g[F+100>>2];e=+g[F+364>>2]}}while(0);if(a[F+377>>0]|0){d=c[F+32>>2]|0;k=c[d>>2]|0;e=+g[k+8>>2];q=+g[k+12>>2];r=+g[k+16>>2];f=+g[k+20>>2];if((E|0)>1){j=1;o=e;p=r;n=f;m=q;l=e;h=f;f=q;e=r;do{k=c[d+(j<<2)>>2]|0;K=+g[k+8>>2];o=K<o?K:o;L=+g[k+12>>2];m=L<m?L:m;M=+g[k+16>>2];p=M<p?M:p;N=+g[k+20>>2];n=N<n?N:n;l=l<K?K:l;f=f<L?L:f;e=e<M?M:e;h=h<N?N:h;j=j+1|0}while((j|0)!=(E|0))}else{o=e;p=r;n=f;m=q;l=e;h=f;f=q;e=r}g[H>>2]=o;g[H+4>>2]=m;g[H+8>>2]=p;g[H+12>>2]=n;g[H+16>>2]=l;g[H+20>>2]=f;g[H+24>>2]=e;g[H+28>>2]=h;d=c[F+348>>2]|0;if(!d){d=c[b+1052>>2]|0;if(!d){c[6435]=(c[6435]|0)+1;d=yc(63)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}j=d;k=j+44|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(k|0))}else c[b+1052>>2]=0;c[d+32>>2]=0;c[d+36>>2]=F;c[d+40>>2]=0;c[d>>2]=c[H>>2];c[d+4>>2]=c[H+4>>2];c[d+8>>2]=c[H+8>>2];c[d+12>>2]=c[H+12>>2];c[d+16>>2]=c[H+16>>2];c[d+20>>2]=c[H+20>>2];c[d+24>>2]=c[H+24>>2];c[d+28>>2]=c[H+28>>2];lf(b+1048|0,c[b+1048>>2]|0,d);c[b+1060>>2]=(c[b+1060>>2]|0)+1;c[F+348>>2]=d}else{L=+g[b+452>>2];M=L*+g[F+320>>2]*3.0;N=L*+g[F+324>>2]*3.0;g[H+32>>2]=+g[D>>2]*L*3.0;g[H+32+4>>2]=M;g[H+32+8>>2]=N;g[H+32+12>>2]=0.0;jh(b+1048|0,d,H,H+32|0,+g[b+464>>2])|0}}d=c[b+1112>>2]|0}G=G+1|0}while((G|0)<(d|0))}d=c[2357]|0;b=(c[d+16>>2]|0)+-1|0;c[d+16>>2]=b;if(b|0){i=H;return}do if(c[d+4>>2]|0){tb(H+144|0,0)|0;b=c[6434]|0;g[d+8>>2]=+g[d+8>>2]+ +(((c[H+144+4>>2]|0)-(c[b+4>>2]|0)+(((c[H+144>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[d+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[d+16>>2]|0)){d=c[2357]|0;break}else{i=H;return}}while(0);c[2357]=c[d+20>>2];i=H;return}function ad(d,e){d=d|0;e=+e;var f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0;B=i;i=i+464|0;li(12209);f=c[d+84>>2]|0;if(f|0)zb[f&31](d,e);zb[c[(c[d>>2]|0)+140>>2]&31](d,e);g[d+28>>2]=e;c[d+32>>2]=0;c[d+48>>2]=Eb[c[(c[d>>2]|0)+20>>2]&127](d)|0;li(12238);li(12263);f=c[d+316>>2]|0;if((c[d+308>>2]|0)>0){h=0;do{s=c[d+24>>2]|0;Cb[c[(c[s>>2]|0)+16>>2]&127](s,c[f+(h<<2)>>2]|0);h=h+1|0;f=c[d+316>>2]|0}while((h|0)<(c[d+308>>2]|0))}if(f|0){if(a[d+320>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[d+316>>2]=0}a[d+320>>0]=1;c[d+316>>2]=0;c[d+308>>2]=0;c[d+312>>2]=0;f=c[2357]|0;s=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=s;do if(!s){if(c[f+4>>2]|0){tb(B+368|0,0)|0;s=c[6434]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[B+368+4>>2]|0)-(c[s+4>>2]|0)+(((c[B+368>>2]|0)-(c[s>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(c[f+16>>2]|0)break;f=c[2357]|0}c[2357]=c[f+20>>2]}while(0);a:do if((c[d+232>>2]|0)>0){q=B+304+48|0;r=B+368+44|0;s=0;while(1){k=c[(c[d+240>>2]|0)+(s<<2)>>2]|0;g[k+244>>2]=1.0;b:do switch(c[k+216>>2]|0){case 2:case 5:break;default:if(((c[k+204>>2]&3|0)==0?(Zg(k+4|0,+g[k+312>>2],+g[k+316>>2],+g[k+320>>2],k+328|0,e,B+304|0),t=+g[q>>2],u=t-+g[k+52>>2],v=+g[B+304+52>>2],w=v-+g[k+56>>2],x=+g[B+304+56>>2],y=x-+g[k+60>>2],a[d+44>>0]|0):0)?(o=+g[k+252>>2],o*o!=0.0?o*o<u*u+w*w+y*y:0):0){li(12300);if((c[(c[k+192>>2]|0)+4>>2]|0)<20?(c[5816]=(c[5816]|0)+1,j=c[d+68>>2]|0,j=Eb[c[(c[j>>2]|0)+36>>2]&127](j)|0,p=c[d+24>>2]|0,g[B+368+4>>2]=1.0,b[B+368+8>>1]=1,b[B+368+10>>1]=-1,c[B+368>>2]=2872,c[B+368+12>>2]=c[k+52>>2],c[B+368+12+4>>2]=c[k+52+4>>2],c[B+368+12+8>>2]=c[k+52+8>>2],c[B+368+12+12>>2]=c[k+52+12>>2],c[B+368+28>>2]=c[q>>2],c[B+368+28+4>>2]=c[q+4>>2],c[B+368+28+8>>2]=c[q+8>>2],c[B+368+28+12>>2]=c[q+12>>2],c[B+368+76>>2]=0,c[B+368>>2]=4332,c[B+368+80>>2]=k,c[B+368+88>>2]=j,c[B+368+92>>2]=p,p=c[k+248>>2]|0,c[B+248+8>>2]=0,c[B+248+12>>2]=1065353216,c[B+248+16>>2]=1065353216,c[B+248+20>>2]=1065353216,g[B+248+24>>2]=0.0,c[B+248>>2]=6672,c[B+248+4>>2]=8,c[B+248+28>>2]=p,c[B+248+44>>2]=p,c[B+368+84>>2]=c[d+56>>2],p=c[(c[k+188>>2]|0)+4>>2]|0,b[B+368+8>>1]=p,b[B+368+10>>1]=p>>>16,c[B+184+48>>2]=c[q>>2],c[B+184+48+4>>2]=c[q+4>>2],c[B+184+48+8>>2]=c[q+8>>2],c[B+184+48+12>>2]=c[q+12>>2],c[B+184>>2]=c[k+4>>2],c[B+184+4>>2]=c[k+4+4>>2],c[B+184+8>>2]=c[k+4+8>>2],c[B+184+12>>2]=c[k+4+12>>2],c[B+184+16>>2]=c[k+20>>2],c[B+184+16+4>>2]=c[k+20+4>>2],c[B+184+16+8>>2]=c[k+20+8>>2],c[B+184+16+12>>2]=c[k+20+12>>2],c[B+184+32>>2]=c[k+36>>2],c[B+184+32+4>>2]=c[k+36+4>>2],c[B+184+32+8>>2]=c[k+36+8>>2],c[B+184+32+12>>2]=c[k+36+12>>2],Kd(d,B+248|0,k+4|0,B+184|0,B+368|0,0.0),z=+g[B+368+4>>2],z<1.0):0){l=z*(t-+g[k+52>>2]);m=z*(v-+g[k+56>>2]);n=z*(x-+g[k+60>>2]);o=-(m*+g[B+368+48>>2])-l*+g[r>>2]-n*+g[B+368+52>>2];p=c[d+24>>2]|0;p=Ob[c[(c[p>>2]|0)+12>>2]&63](p,k,c[B+368+76>>2]|0)|0;f=c[d+308>>2]|0;if((f|0)==(c[d+312>>2]|0)?(A=f|0?f<<1:1,(f|0)<(A|0)):0){if(!A)j=0;else{c[6435]=(c[6435]|0)+1;f=yc((A<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}j=f;f=c[d+308>>2]|0}if((f|0)>0){h=0;do{c[j+(h<<2)>>2]=c[(c[d+316>>2]|0)+(h<<2)>>2];h=h+1|0}while((h|0)!=(f|0))}h=c[d+316>>2]|0;if(h){if(a[d+320>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0);f=c[d+308>>2]|0}c[d+316>>2]=0}a[d+320>>0]=1;c[d+316>>2]=j;c[d+312>>2]=A}c[(c[d+316>>2]|0)+(f<<2)>>2]=p;c[d+308>>2]=f+1;l=l+ +g[k+52>>2];m=m+ +g[k+56>>2];n=n+ +g[k+60>>2];j=c[B+368+76>>2]|0;N=+g[j+4>>2];M=+g[j+20>>2];L=+g[j+36>>2];K=+g[j+8>>2];J=+g[j+24>>2];I=+g[j+40>>2];H=+g[j+12>>2];F=+g[j+28>>2];D=+g[j+44>>2];G=-+g[j+52>>2];E=-+g[j+56>>2];C=-+g[j+60>>2];c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;c[B+12>>2]=0;g[B+16>>2]=l*N+m*M+n*L+(N*G+M*E+L*C);g[B+20>>2]=l*K+m*J+n*I+(K*G+J*E+I*C);g[B+24>>2]=l*H+m*F+n*D+(H*G+F*E+D*C);g[B+28>>2]=0.0;c[B+64>>2]=c[r>>2];c[B+64+4>>2]=c[r+4>>2];c[B+64+8>>2]=c[r+8>>2];c[B+64+12>>2]=c[r+12>>2];g[B+80>>2]=o;g[B+84>>2]=0.0;g[B+88>>2]=0.0;g[B+92>>2]=0.0;c[B+112>>2]=0;a[B+116>>0]=0;c[B+120>>2]=0;c[B+120+4>>2]=0;c[B+120+8>>2]=0;c[B+120+12>>2]=0;c[B+120+16>>2]=0;c[B+120+20>>2]=0;c[B+120+24>>2]=0;c[B+120+28>>2]=0;j=_e(p,B)|0;g[p+4+(j*184|0)+92>>2]=0.0;o=+g[k+224>>2]*+g[(c[B+368+76>>2]|0)+224>>2];o=o<-10.0?-10.0:o;g[p+4+(j*184|0)+84>>2]=o>10.0?10.0:o;c[p+4+(j*184|0)+48>>2]=c[k+52>>2];c[p+4+(j*184|0)+48+4>>2]=c[k+52+4>>2];c[p+4+(j*184|0)+48+8>>2]=c[k+52+8>>2];c[p+4+(j*184|0)+48+12>>2]=c[k+52+12>>2];g[p+4+(j*184|0)+32>>2]=l;g[p+4+(j*184|0)+36>>2]=m;g[p+4+(j*184|0)+40>>2]=n;g[p+4+(j*184|0)+44>>2]=0.0}f=c[2357]|0;p=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=p;if(!p){if(c[f+4>>2]|0){tb(B+368|0,0)|0;p=c[6434]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[B+368+4>>2]|0)-(c[p+4>>2]|0)+(((c[B+368>>2]|0)-(c[p>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(c[f+16>>2]|0)break b;f=c[2357]|0}c[2357]=c[f+20>>2]}}}while(0);s=s+1|0;if((s|0)>=(c[d+232>>2]|0))break a}}while(0);f=c[2357]|0;A=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=A;do if(!A){if(c[f+4>>2]|0){tb(B+368|0,0)|0;A=c[6434]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[B+368+4>>2]|0)-(c[A+4>>2]|0)+(((c[B+368>>2]|0)-(c[A>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(c[f+16>>2]|0)break;f=c[2357]|0}c[2357]=c[f+20>>2]}while(0);Ab[c[(c[d>>2]|0)+44>>2]&255](d);Ab[c[(c[d>>2]|0)+148>>2]&255](d);g[d+104>>2]=e;Cb[c[(c[d>>2]|0)+152>>2]&127](d,d+92|0);zb[c[(c[d>>2]|0)+144>>2]&31](d,e);li(12327);if((c[d+280>>2]|0)>0){f=0;do{A=c[(c[d+288>>2]|0)+(f<<2)>>2]|0;kc[c[(c[A>>2]|0)+8>>2]&7](A,d,e);f=f+1|0}while((f|0)<(c[d+280>>2]|0))}f=c[2357]|0;A=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=A;do if(!A){if(c[f+4>>2]|0){tb(B+368|0,0)|0;A=c[6434]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[B+368+4>>2]|0)-(c[A+4>>2]|0)+(((c[B+368>>2]|0)-(c[A>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(c[f+16>>2]|0)break;f=c[2357]|0}c[2357]=c[f+20>>2]}while(0);zb[c[(c[d>>2]|0)+156>>2]&31](d,e);f=c[d+80>>2]|0;if(f|0)zb[f&31](d,e);f=c[2357]|0;d=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=d;if(d|0){i=B;return}do if(c[f+4>>2]|0){tb(B+368|0,0)|0;d=c[6434]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[B+368+4>>2]|0)-(c[d+4>>2]|0)+(((c[B+368>>2]|0)-(c[d>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[f+16>>2]|0)){f=c[2357]|0;break}else{i=B;return}}while(0);c[2357]=c[f+20>>2];i=B;return}function bd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0;x=i;i=i+784|0;c[x+168+8>>2]=0;c[x+168+12>>2]=1065353216;c[x+168+16>>2]=1065353216;c[x+168+20>>2]=1065353216;g[x+168+24>>2]=0.0;c[x+168>>2]=6672;c[x+168+4>>2]=8;g[x+168+28>>2]=0.0;g[x+168+44>>2]=0.0;v=c[e+4>>2]|0;w=c[e+12>>2]|0;h=c[v+4>>2]|0;if((h|0)<20){c[x+600>>2]=3708;c[x+600+168>>2]=0;g[x+600+172>>2]=0.0;c[x+600+164>>2]=c[f+4>>2];g[x+240+308>>2]=9.999999747378752e-05;a[x+240+332>>0]=0;c[x+224>>2]=4960;c[x+224+4>>2]=x+240;c[x+224+8>>2]=x+168;c[x+224+12>>2]=v;c[x+152>>2]=9140;c[x+152+4>>2]=x+240;c[x+152+8>>2]=x+168;c[x+152+12>>2]=v;v=(c[f+16>>2]&4|0)==0?x+152|0:x+224|0;if((Tb[c[(c[v>>2]|0)+8>>2]&3](v,b,d,w,w,x+600|0)|0?(j=x+600+132|0,k=+g[j>>2],l=+g[x+600+136>>2],m=+g[x+600+140>>2],k*k+l*l+m*m>9.999999747378752e-05):0)?(n=+g[x+600+164>>2],n<+g[f+4>>2]):0){u=1.0/+O(+(k*k+l*l+m*m));g[j>>2]=k*u;g[x+600+136>>2]=l*u;g[x+600+140>>2]=m*u;c[x+120>>2]=c[e+8>>2];c[x+120+4>>2]=0;c[x+120+8>>2]=c[j>>2];c[x+120+8+4>>2]=c[j+4>>2];c[x+120+8+8>>2]=c[j+8>>2];c[x+120+8+12>>2]=c[j+12>>2];g[x+120+24>>2]=n;+_b[c[(c[f>>2]|0)+12>>2]&15](f,x+120|0,1)}i=x;return}if((h+-21|0)>>>0>=9){if((h|0)!=31){i=x;return}h=c[v+64>>2]|0;e=c[e+8>>2]|0;c[x+600>>2]=5804;c[x+600+4>>2]=e;c[x+600+8>>2]=v;c[x+600+12>>2]=w;c[x+600+16>>2]=b;c[x+600+20>>2]=d;c[x+600+24>>2]=f;if(!h){h=c[v+16>>2]|0;if((h|0)>0){j=0;do{Vf(x+600|0,j);j=j+1|0}while((j|0)<(h|0))}}else{p=+g[w+48>>2];B=+g[b+48>>2]-p;r=+g[w+52>>2];A=+g[b+52>>2]-r;t=+g[w+56>>2];z=+g[b+56>>2]-t;y=+g[w>>2];k=+g[w+16>>2];l=+g[w+32>>2];m=+g[w+4>>2];n=+g[w+20>>2];o=+g[w+36>>2];q=+g[w+8>>2];s=+g[w+24>>2];u=+g[w+40>>2];g[x+240>>2]=B*y+A*k+z*l;g[x+240+4>>2]=B*m+A*n+z*o;g[x+240+8>>2]=B*q+A*s+z*u;g[x+240+12>>2]=0.0;p=+g[d+48>>2]-p;r=+g[d+52>>2]-r;t=+g[d+56>>2]-t;g[x+224>>2]=p*y+r*k+t*l;g[x+224+4>>2]=p*m+r*n+t*o;g[x+224+8>>2]=p*q+r*s+t*u;g[x+224+12>>2]=0.0;ff(c[h>>2]|0,x+240|0,x+224|0,x+600|0)}i=x;return}E=+g[w>>2];D=+g[w+16>>2];k=+g[w+32>>2];C=+g[w+4>>2];o=+g[w+20>>2];l=+g[w+36>>2];A=+g[w+8>>2];B=+g[w+24>>2];m=+g[w+40>>2];p=-+g[w+48>>2];y=-+g[w+52>>2];z=-+g[w+56>>2];q=+g[b+48>>2];r=+g[b+52>>2];n=+g[b+56>>2];g[x+152>>2]=E*p+D*y+k*z+(E*q+D*r+k*n);g[x+152+4>>2]=C*p+o*y+l*z+(C*q+o*r+l*n);g[x+152+8>>2]=A*p+B*y+m*z+(A*q+B*r+m*n);g[x+152+12>>2]=0.0;t=+g[d+48>>2];u=+g[d+52>>2];s=+g[d+56>>2];k=E*p+D*y+k*z+(E*t+D*u+k*s);l=C*p+o*y+l*z+(C*t+o*u+l*s);m=A*p+B*y+m*z+(A*t+B*u+m*s);g[x+120>>2]=k;g[x+120+4>>2]=l;g[x+120+8>>2]=m;g[x+120+12>>2]=0.0;switch(c[v+4>>2]|0){case 21:{h=c[e+8>>2]|0;e=c[f+16>>2]|0;c[x+4>>2]=c[x+152>>2];c[x+4+4>>2]=c[x+152+4>>2];c[x+4+8>>2]=c[x+152+8>>2];c[x+4+12>>2]=c[x+152+12>>2];c[x+20>>2]=c[x+120>>2];c[x+20+4>>2]=c[x+120+4>>2];c[x+20+8>>2]=c[x+120+8>>2];c[x+20+12>>2]=c[x+120+12>>2];c[x+36>>2]=e;g[x+40>>2]=1.0;c[x>>2]=5756;c[x+44>>2]=f;c[x+48>>2]=h;c[x+52>>2]=v;c[x+56>>2]=c[w>>2];c[x+56+4>>2]=c[w+4>>2];c[x+56+8>>2]=c[w+8>>2];c[x+56+12>>2]=c[w+12>>2];c[x+72>>2]=c[w+16>>2];c[x+72+4>>2]=c[w+16+4>>2];c[x+72+8>>2]=c[w+16+8>>2];c[x+72+12>>2]=c[w+16+12>>2];c[x+88>>2]=c[w+32>>2];c[x+88+4>>2]=c[w+32+4>>2];c[x+88+8>>2]=c[w+32+8>>2];c[x+88+12>>2]=c[w+32+12>>2];c[x+104>>2]=c[w+48>>2];c[x+104+4>>2]=c[w+48+4>>2];c[x+104+8>>2]=c[w+48+8>>2];c[x+104+12>>2]=c[w+48+12>>2];c[x+40>>2]=c[f+4>>2];h=c[v+48>>2]|0;c[x+224>>2]=6884;c[x+224+4>>2]=h;c[x+224+8>>2]=x;h=c[v+52>>2]|0;c[x+600>>2]=0;c[x+600+4>>2]=0;c[x+600+8>>2]=0;c[x+600+12>>2]=0;c[x+240>>2]=0;c[x+240+4>>2]=0;c[x+240+8>>2]=0;c[x+240+12>>2]=0;if(!(a[h+60>>0]|0))Re(h,x+224|0,x+152|0,k,l,m,x+600|0,x+240|0);else ze(h,x+224|0,x+152|0,k,l,m,x+600|0,x+240|0,c[h+56>>2]|0);break}case 25:{e=c[e+8>>2]|0;d=c[f+16>>2]|0;c[x+600+4>>2]=c[x+152>>2];c[x+600+4+4>>2]=c[x+152+4>>2];c[x+600+4+8>>2]=c[x+152+8>>2];c[x+600+4+12>>2]=c[x+152+12>>2];c[x+600+20>>2]=c[x+120>>2];c[x+600+20+4>>2]=c[x+120+4>>2];c[x+600+20+8>>2]=c[x+120+8>>2];c[x+600+20+12>>2]=c[x+120+12>>2];c[x+600+36>>2]=d;g[x+600+40>>2]=1.0;c[x+600>>2]=5756;c[x+600+44>>2]=f;c[x+600+48>>2]=e;c[x+600+52>>2]=v;c[x+600+56>>2]=c[w>>2];c[x+600+56+4>>2]=c[w+4>>2];c[x+600+56+8>>2]=c[w+8>>2];c[x+600+56+12>>2]=c[w+12>>2];c[x+600+72>>2]=c[w+16>>2];c[x+600+72+4>>2]=c[w+16+4>>2];c[x+600+72+8>>2]=c[w+16+8>>2];c[x+600+72+12>>2]=c[w+16+12>>2];c[x+600+88>>2]=c[w+32>>2];c[x+600+88+4>>2]=c[w+32+4>>2];c[x+600+88+8>>2]=c[w+32+8>>2];c[x+600+88+12>>2]=c[w+32+12>>2];c[x+600+104>>2]=c[w+48>>2];c[x+600+104+4>>2]=c[w+48+4>>2];c[x+600+104+8>>2]=c[w+48+8>>2];c[x+600+104+12>>2]=c[w+48+12>>2];c[x+600+40>>2]=c[f+4>>2];mc[c[(c[v>>2]|0)+144>>2]&127](v,x+600|0,x+152|0,x+120|0);break}default:{H=+g[w>>2];G=+g[w+16>>2];m=+g[w+32>>2];F=+g[w+4>>2];y=+g[w+20>>2];z=+g[w+36>>2];D=+g[w+8>>2];E=+g[w+24>>2];k=+g[w+40>>2];A=-+g[w+48>>2];B=-+g[w+52>>2];C=-+g[w+56>>2];o=H*A+G*B+m*C+(H*q+G*r+m*n);p=F*A+y*B+z*C+(F*q+y*r+z*n);l=D*A+E*B+k*C+(D*q+E*r+k*n);m=H*A+G*B+m*C+(H*t+G*u+m*s);n=F*A+y*B+z*C+(F*t+y*u+z*s);k=D*A+E*B+k*C+(D*t+E*u+k*s);e=c[e+8>>2]|0;d=c[f+16>>2]|0;g[x+600+4>>2]=o;g[x+600+8>>2]=p;g[x+600+12>>2]=l;g[x+600+16>>2]=0.0;g[x+600+20>>2]=m;g[x+600+24>>2]=n;g[x+600+28>>2]=k;g[x+600+32>>2]=0.0;c[x+600+36>>2]=d;g[x+600+40>>2]=1.0;c[x+600>>2]=5780;c[x+600+44>>2]=f;c[x+600+48>>2]=e;c[x+600+52>>2]=v;c[x+600+56>>2]=c[w>>2];c[x+600+56+4>>2]=c[w+4>>2];c[x+600+56+8>>2]=c[w+8>>2];c[x+600+56+12>>2]=c[w+12>>2];c[x+600+72>>2]=c[w+16>>2];c[x+600+72+4>>2]=c[w+16+4>>2];c[x+600+72+8>>2]=c[w+16+8>>2];c[x+600+72+12>>2]=c[w+16+12>>2];c[x+600+88>>2]=c[w+32>>2];c[x+600+88+4>>2]=c[w+32+4>>2];c[x+600+88+8>>2]=c[w+32+8>>2];c[x+600+88+12>>2]=c[w+32+12>>2];c[x+600+104>>2]=c[w+48>>2];c[x+600+104+4>>2]=c[w+48+4>>2];c[x+600+104+8>>2]=c[w+48+8>>2];c[x+600+104+12>>2]=c[w+48+12>>2];c[x+600+40>>2]=c[f+4>>2];g[x+240>>2]=o;g[x+240+4>>2]=p;g[x+240+8>>2]=l;g[x+240+12>>2]=0.0;if(m<o)g[x+240>>2]=m;if(n<p)g[x+240+4>>2]=n;if(k<l)g[x+240+8>>2]=k;g[x+224>>2]=o;g[x+224+4>>2]=p;g[x+224+8>>2]=l;g[x+224+12>>2]=0.0;if(o<m)g[x+224>>2]=m;if(p<n)g[x+224+4>>2]=n;if(l<k)g[x+224+8>>2]=k;mc[c[(c[v>>2]|0)+64>>2]&127](v,x+600|0,x+240|0,x+224|0)}}i=x;return}function cd(b,d,e,f,h,i,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0.0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0;o=c[b+48>>2]|0;q=c[b+28>>2]|0;r=c[b+68>>2]|0;if(c[l+64>>2]&1|0){if((o|0)>0){f=c[b+136>>2]|0;m=c[b+192>>2]|0;p=0;do{h=f+(p<<2)|0;i=c[h>>2]|0;p=p+1|0;m=(_(m,1664525)|0)+1013904223|0;if(p>>>0<65537){e=m>>>16^m;if(p>>>0<257)if(p>>>0<17){e=(e>>>8^e)>>>4^(e>>>8^e);if(p>>>0<5)if(p>>>0<3)e=(e>>>2^e)>>>1^(e>>>2^e);else e=e>>>2^e}else e=e>>>8^e}else e=m;e=f+(((e>>>0)%(p>>>0)|0)<<2)|0;c[h>>2]=c[e>>2];c[e>>2]=i}while((p|0)!=(o|0));c[b+192>>2]=m}if((c[l+20>>2]|0)>(d|0)){if((q|0)>0){f=c[b+116>>2]|0;m=c[b+192>>2]|0;o=0;do{h=f+(o<<2)|0;i=c[h>>2]|0;o=o+1|0;m=(_(m,1664525)|0)+1013904223|0;if(o>>>0<65537){e=m>>>16^m;if(o>>>0<257)if(o>>>0<17){e=(e>>>8^e)>>>4^(e>>>8^e);if(o>>>0<5)if(o>>>0<3)e=(e>>>2^e)>>>1^(e>>>2^e);else e=e>>>2^e}else e=e>>>8^e}else e=m;p=f+(((e>>>0)%(o>>>0)|0)<<2)|0;c[h>>2]=c[p>>2];c[p>>2]=i}while((o|0)!=(q|0));c[b+192>>2]=m}if((r|0)>0){f=c[b+156>>2]|0;m=c[b+192>>2]|0;o=0;do{h=f+(o<<2)|0;i=c[h>>2]|0;o=o+1|0;m=(_(m,1664525)|0)+1013904223|0;if(o>>>0<65537){e=m>>>16^m;if(o>>>0<257)if(o>>>0<17){e=(e>>>8^e)>>>4^(e>>>8^e);if(o>>>0<5)if(o>>>0<3)e=(e>>>2^e)>>>1^(e>>>2^e);else e=e>>>2^e}else e=e>>>8^e}else e=m;q=f+(((e>>>0)%(o>>>0)|0)<<2)|0;c[h>>2]=c[q>>2];c[q>>2]=i}while((o|0)!=(r|0));c[b+192>>2]=m}}}e=c[b+48>>2]|0;if(!(c[l+64>>2]&256)){if((e|0)>0){i=0;do{f=c[(c[b+136>>2]|0)+(i<<2)>>2]|0;h=c[b+56>>2]|0;if((c[h+(f*152|0)+136>>2]|0)>(d|0)){e=c[b+16>>2]|0;zg(e+((c[h+(f*152|0)+144>>2]|0)*244|0)|0,e+((c[h+(f*152|0)+148>>2]|0)*244|0)|0,h+(f*152|0)|0);e=c[b+48>>2]|0}i=i+1|0}while((i|0)<(e|0))}if((c[l+20>>2]|0)<=(d|0))return 0.0;if((k|0)>0){h=0;do{e=j+(h<<2)|0;f=c[e>>2]|0;if(a[f+20>>0]|0){d=bk(b,c[f+28>>2]|0,+g[l+12>>2])|0;t=bk(b,c[(c[e>>2]|0)+32>>2]|0,+g[l+12>>2])|0;s=c[b+16>>2]|0;r=c[e>>2]|0;hc[c[(c[r>>2]|0)+24>>2]&15](r,s+(d*244|0)|0,s+(t*244|0)|0,+g[l+12>>2])}h=h+1|0}while((h|0)!=(k|0))}e=c[b+28>>2]|0;if((e|0)>0){f=0;do{l=c[(c[b+116>>2]|0)+(f<<2)>>2]|0;k=c[b+36>>2]|0;j=c[b+16>>2]|0;Mg(j+((c[k+(l*152|0)+144>>2]|0)*244|0)|0,j+((c[k+(l*152|0)+148>>2]|0)*244|0)|0,k+(l*152|0)|0);f=f+1|0}while((f|0)!=(e|0))}e=c[b+68>>2]|0;if((e|0)>0){i=0;do{f=c[(c[b+156>>2]|0)+(i<<2)>>2]|0;h=c[b+76>>2]|0;n=+g[(c[b+36>>2]|0)+((c[h+(f*152|0)+140>>2]|0)*152|0)+100>>2];if(n>0.0){n=n*+g[h+(f*152|0)+104>>2];g[h+(f*152|0)+120>>2]=-n;g[h+(f*152|0)+124>>2]=n;l=c[b+16>>2]|0;zg(l+((c[h+(f*152|0)+144>>2]|0)*244|0)|0,l+((c[h+(f*152|0)+148>>2]|0)*244|0)|0,h+(f*152|0)|0)}i=i+1|0}while((i|0)!=(e|0))}e=c[b+88>>2]|0;if((e|0)<=0)return 0.0;h=0;do{f=c[b+96>>2]|0;n=+g[(c[b+36>>2]|0)+((c[f+(h*152|0)+140>>2]|0)*152|0)+100>>2];if(n>0.0){u=+g[f+(h*152|0)+104>>2];n=n*u>u?u:n*u;g[f+(h*152|0)+120>>2]=-n;g[f+(h*152|0)+124>>2]=n;l=c[b+16>>2]|0;zg(l+((c[f+(h*152|0)+144>>2]|0)*244|0)|0,l+((c[f+(h*152|0)+148>>2]|0)*244|0)|0,f+(h*152|0)|0)}h=h+1|0}while((h|0)!=(e|0));return 0.0}if((e|0)>0){i=0;do{f=c[(c[b+136>>2]|0)+(i<<2)>>2]|0;h=c[b+56>>2]|0;if((c[h+(f*152|0)+136>>2]|0)>(d|0)){e=c[b+16>>2]|0;zg(e+((c[h+(f*152|0)+144>>2]|0)*244|0)|0,e+((c[h+(f*152|0)+148>>2]|0)*244|0)|0,h+(f*152|0)|0);e=c[b+48>>2]|0}i=i+1|0}while((i|0)<(e|0))}if((c[l+20>>2]|0)<=(d|0))return 0.0;if((k|0)>0){h=0;do{e=j+(h<<2)|0;f=c[e>>2]|0;if(a[f+20>>0]|0){q=bk(b,c[f+28>>2]|0,+g[l+12>>2])|0;d=bk(b,c[(c[e>>2]|0)+32>>2]|0,+g[l+12>>2])|0;r=c[b+16>>2]|0;p=c[e>>2]|0;hc[c[(c[p>>2]|0)+24>>2]&15](p,r+(q*244|0)|0,r+(d*244|0)|0,+g[l+12>>2])}h=h+1|0}while((h|0)!=(k|0))}e=c[l+64>>2]|0;o=c[b+28>>2]|0;if(e&512|0){if((o|0)<=0)return 0.0;m=0;do{f=c[(c[b+116>>2]|0)+(m<<2)>>2]|0;h=c[b+36>>2]|0;i=c[b+16>>2]|0;Mg(i+((c[h+(f*152|0)+144>>2]|0)*244|0)|0,i+((c[h+(f*152|0)+148>>2]|0)*244|0)|0,h+(f*152|0)|0);n=+g[h+(f*152|0)+100>>2];f=_(m,(e>>>4&1)+1|0)|0;h=c[(c[b+156>>2]|0)+(f<<2)>>2]|0;i=c[b+76>>2]|0;if(n>0.0){u=n*+g[i+(h*152|0)+104>>2];g[i+(h*152|0)+120>>2]=-u;g[i+(h*152|0)+124>>2]=u;k=c[b+16>>2]|0;zg(k+((c[i+(h*152|0)+144>>2]|0)*244|0)|0,k+((c[i+(h*152|0)+148>>2]|0)*244|0)|0,i+(h*152|0)|0)}if(c[l+64>>2]&16|0?(s=c[(c[b+156>>2]|0)+(f+1<<2)>>2]|0,t=c[b+76>>2]|0,n>0.0):0){u=n*+g[t+(s*152|0)+104>>2];g[t+(s*152|0)+120>>2]=-u;g[t+(s*152|0)+124>>2]=u;k=c[b+16>>2]|0;zg(k+((c[t+(s*152|0)+144>>2]|0)*244|0)|0,k+((c[t+(s*152|0)+148>>2]|0)*244|0)|0,t+(s*152|0)|0)}m=m+1|0}while((m|0)!=(o|0));return 0.0}if((o|0)>0){e=0;do{l=c[(c[b+116>>2]|0)+(e<<2)>>2]|0;k=c[b+36>>2]|0;j=c[b+16>>2]|0;Mg(j+((c[k+(l*152|0)+144>>2]|0)*244|0)|0,j+((c[k+(l*152|0)+148>>2]|0)*244|0)|0,k+(l*152|0)|0);e=e+1|0}while((e|0)!=(o|0))}e=c[b+68>>2]|0;if((e|0)>0){i=0;do{f=c[(c[b+156>>2]|0)+(i<<2)>>2]|0;h=c[b+76>>2]|0;n=+g[(c[b+36>>2]|0)+((c[h+(f*152|0)+140>>2]|0)*152|0)+100>>2];if(n>0.0){u=n*+g[h+(f*152|0)+104>>2];g[h+(f*152|0)+120>>2]=-u;g[h+(f*152|0)+124>>2]=u;l=c[b+16>>2]|0;zg(l+((c[h+(f*152|0)+144>>2]|0)*244|0)|0,l+((c[h+(f*152|0)+148>>2]|0)*244|0)|0,h+(f*152|0)|0)}i=i+1|0}while((i|0)!=(e|0))}e=c[b+88>>2]|0;if((e|0)<=0)return 0.0;h=0;do{f=c[b+96>>2]|0;n=+g[(c[b+36>>2]|0)+((c[f+(h*152|0)+140>>2]|0)*152|0)+100>>2];if(n>0.0){u=+g[f+(h*152|0)+104>>2];u=n*u>u?u:n*u;g[f+(h*152|0)+120>>2]=-u;g[f+(h*152|0)+124>>2]=u;l=c[b+16>>2]|0;zg(l+((c[f+(h*152|0)+144>>2]|0)*244|0)|0,l+((c[f+(h*152|0)+148>>2]|0)*244|0)|0,f+(h*152|0)|0)}h=h+1|0}while((h|0)!=(e|0));return 0.0}function dd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0;r=i;i=i+80|0;j=c[b+28>>2]|0;d=c[f+64>>2]|0;a:do if((d&4|0)!=0&(j|0)>0){l=c[b+36>>2]|0;h=c[b+76>>2]|0;if(!(d&16)){d=0;while(1){m=c[l+(d*152|0)+132>>2]|0;c[m+120>>2]=c[l+(d*152|0)+100>>2];c[m+124>>2]=c[h+((c[l+(d*152|0)+140>>2]|0)*152|0)+100>>2];d=d+1|0;if((d|0)==(j|0))break a}}else{e=h;d=0}while(1){m=c[l+(d*152|0)+132>>2]|0;c[m+120>>2]=c[l+(d*152|0)+100>>2];s=c[l+(d*152|0)+140>>2]|0;c[m+124>>2]=c[h+(s*152|0)+100>>2];c[m+128>>2]=c[e+((s+1|0)*152|0)+100>>2];d=d+1|0;if((d|0)==(j|0))break a;e=c[b+76>>2]|0}}while(0);e=c[b+48>>2]|0;if((e|0)>0){m=0;do{h=c[b+56>>2]|0;j=c[h+(m*152|0)+132>>2]|0;l=c[j+44>>2]|0;d=h+(m*152|0)+100|0;if(l|0){q=+g[d>>2];s=c[j+28>>2]|0;p=1.0/+g[f+12>>2];o=q*+g[h+(m*152|0)+20>>2]*+g[s+352>>2]*p;n=q*+g[h+(m*152|0)+24>>2]*+g[s+356>>2]*p;g[l>>2]=+g[l>>2]+ +g[h+(m*152|0)+16>>2]*q*+g[s+348>>2]*p;g[l+4>>2]=o+ +g[l+4>>2];g[l+8>>2]=n+ +g[l+8>>2];n=+g[d>>2];s=c[j+32>>2]|0;o=1.0/+g[f+12>>2];p=n*+g[h+(m*152|0)+52>>2]*+g[s+352>>2]*o;q=n*+g[h+(m*152|0)+56>>2]*+g[s+356>>2]*o;g[l+32>>2]=+g[l+32>>2]+ +g[h+(m*152|0)+48>>2]*n*+g[s+348>>2]*o;g[l+36>>2]=p+ +g[l+36>>2];g[l+40>>2]=q+ +g[l+40>>2];s=c[j+28>>2]|0;q=+g[d>>2];p=1.0/+g[f+12>>2];o=+g[h+(m*152|0)+4>>2]*+g[s+548>>2]*q*p;n=q*+g[h+(m*152|0)+8>>2]*+g[s+552>>2]*p;g[l+16>>2]=+g[l+16>>2]+ +g[h+(m*152|0)>>2]*+g[s+544>>2]*q*p;g[l+20>>2]=o+ +g[l+20>>2];g[l+24>>2]=n+ +g[l+24>>2];s=c[j+32>>2]|0;n=+g[d>>2];o=1.0/+g[f+12>>2];p=+g[h+(m*152|0)+36>>2]*+g[s+548>>2]*n*o;q=n*+g[h+(m*152|0)+40>>2]*+g[s+552>>2]*o;g[l+48>>2]=+g[l+48>>2]+ +g[h+(m*152|0)+32>>2]*+g[s+544>>2]*n*o;g[l+52>>2]=p+ +g[l+52>>2];g[l+56>>2]=q+ +g[l+56>>2]}s=c[d>>2]|0;c[j+36>>2]=s;q=+N(+(c[k>>2]=s,+g[k>>2]));if(q>=+g[j+16>>2])a[j+20>>0]=0;m=m+1|0}while((m|0)!=(e|0))}d=c[b+8>>2]|0;if((d|0)>0){l=0;do{e=c[b+16>>2]|0;h=e+(l*244|0)|0;j=c[e+(l*244|0)+240>>2]|0;if(j){if(!(c[f+44>>2]|0)){h=e+(l*244|0)+176|0;o=+g[e+(l*244|0)+64>>2]+ +g[h>>2];g[h>>2]=o;h=e+(l*244|0)+180|0;p=+g[e+(l*244|0)+68>>2]+ +g[h>>2];g[h>>2]=p;h=e+(l*244|0)+184|0;n=+g[e+(l*244|0)+72>>2]+ +g[h>>2];g[h>>2]=n;h=e+(l*244|0)+192|0;g[h>>2]=+g[e+(l*244|0)+80>>2]+ +g[h>>2];h=e+(l*244|0)+196|0;g[h>>2]=+g[e+(l*244|0)+84>>2]+ +g[h>>2];h=e+(l*244|0)+200|0;g[h>>2]=+g[e+(l*244|0)+88>>2]+ +g[h>>2];h=e;d=j}else{o=+g[f+12>>2];p=+g[f+52>>2];s=e+(l*244|0)+176|0;g[s>>2]=+g[e+(l*244|0)+64>>2]+ +g[s>>2];s=e+(l*244|0)+180|0;g[s>>2]=+g[e+(l*244|0)+68>>2]+ +g[s>>2];s=e+(l*244|0)+184|0;g[s>>2]=+g[e+(l*244|0)+72>>2]+ +g[s>>2];s=e+(l*244|0)+192|0;g[s>>2]=+g[e+(l*244|0)+80>>2]+ +g[s>>2];s=e+(l*244|0)+196|0;g[s>>2]=+g[e+(l*244|0)+84>>2]+ +g[s>>2];s=e+(l*244|0)+200|0;g[s>>2]=+g[e+(l*244|0)+88>>2]+ +g[s>>2];q=+g[e+(l*244|0)+144>>2];n=+g[e+(l*244|0)+148>>2];if((((!(q!=0.0|n!=0.0)?!(+g[e+(l*244|0)+152>>2]!=0.0):0)?!(+g[e+(l*244|0)+160>>2]!=0.0):0)?!(+g[e+(l*244|0)+164>>2]!=0.0):0)?!(+g[e+(l*244|0)+168>>2]!=0.0):0)d=j;else{u=+g[e+(l*244|0)+164>>2]*p;t=+g[e+(l*244|0)+168>>2]*p;g[r>>2]=+g[e+(l*244|0)+160>>2]*p;g[r+4>>2]=u;g[r+8>>2]=t;g[r+12>>2]=0.0;Zg(h,q,n,+g[e+(l*244|0)+152>>2],r,o,r+16|0);c[h>>2]=c[r+16>>2];c[h+4>>2]=c[r+16+4>>2];c[h+8>>2]=c[r+16+8>>2];c[h+12>>2]=c[r+16+12>>2];d=e+(l*244|0)+16|0;c[d>>2]=c[r+16+16>>2];c[d+4>>2]=c[r+16+16+4>>2];c[d+8>>2]=c[r+16+16+8>>2];c[d+12>>2]=c[r+16+16+12>>2];d=e+(l*244|0)+32|0;c[d>>2]=c[r+16+32>>2];c[d+4>>2]=c[r+16+32+4>>2];c[d+8>>2]=c[r+16+32+8>>2];c[d+12>>2]=c[r+16+32+12>>2];d=e+(l*244|0)+48|0;c[d>>2]=c[r+16+48>>2];c[d+4>>2]=c[r+16+48+4>>2];c[d+8>>2]=c[r+16+48+8>>2];c[d+12>>2]=c[r+16+48+12>>2];d=c[b+16>>2]|0;e=d;d=c[d+(l*244|0)+240>>2]|0}h=e;o=+g[e+(l*244|0)+176>>2];p=+g[e+(l*244|0)+180>>2];n=+g[e+(l*244|0)+184>>2]}u=o+ +g[h+(l*244|0)+208>>2];t=p+ +g[h+(l*244|0)+212>>2];q=n+ +g[h+(l*244|0)+216>>2];m=d+260|0;c[m>>2]=(c[m>>2]|0)+1;g[d+312>>2]=u;g[d+316>>2]=t;g[d+320>>2]=q;g[d+324>>2]=0.0;m=c[b+16>>2]|0;s=c[m+(l*244|0)+240>>2]|0;q=+g[m+(l*244|0)+192>>2]+ +g[m+(l*244|0)+224>>2];t=+g[m+(l*244|0)+196>>2]+ +g[m+(l*244|0)+228>>2];u=+g[m+(l*244|0)+200>>2]+ +g[m+(l*244|0)+232>>2];c[s+260>>2]=(c[s+260>>2]|0)+1;g[s+328>>2]=q;g[s+332>>2]=t;g[s+336>>2]=u;g[s+340>>2]=0.0;if(c[f+44>>2]|0){m=c[b+16>>2]|0;s=c[m+(l*244|0)+240>>2]|0;j=m+(l*244|0)|0;c[s+260>>2]=(c[s+260>>2]|0)+1;c[s+4>>2]=c[j>>2];c[s+4+4>>2]=c[j+4>>2];c[s+4+8>>2]=c[j+8>>2];c[s+4+12>>2]=c[j+12>>2];j=m+(l*244|0)+16|0;c[s+20>>2]=c[j>>2];c[s+20+4>>2]=c[j+4>>2];c[s+20+8>>2]=c[j+8>>2];c[s+20+12>>2]=c[j+12>>2];j=m+(l*244|0)+32|0;c[s+36>>2]=c[j>>2];c[s+36+4>>2]=c[j+4>>2];c[s+36+8>>2]=c[j+8>>2];c[s+36+12>>2]=c[j+12>>2];m=m+(l*244|0)+48|0;c[s+52>>2]=c[m>>2];c[s+52+4>>2]=c[m+4>>2];c[s+52+8>>2]=c[m+8>>2];c[s+52+12>>2]=c[m+12>>2]}c[(c[(c[b+16>>2]|0)+(l*244|0)+240>>2]|0)+212>>2]=-1;d=c[b+8>>2]|0}l=l+1|0}while((l|0)<(d|0))}if((c[b+28>>2]|0)<0?(c[b+32>>2]|0)<0:0){d=c[b+36>>2]|0;if(d|0){if(a[b+40>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+36>>2]=0}a[b+40>>0]=1;c[b+36>>2]=0;c[b+32>>2]=0}c[b+28>>2]=0;if((c[b+48>>2]|0)<0?(c[b+52>>2]|0)<0:0){d=c[b+56>>2]|0;if(d|0){if(a[b+60>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=0;c[b+52>>2]=0}c[b+48>>2]=0;if((c[b+68>>2]|0)<0?(c[b+72>>2]|0)<0:0){d=c[b+76>>2]|0;if(d|0){if(a[b+80>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=0;c[b+72>>2]=0}c[b+68>>2]=0;if((c[b+88>>2]|0)<0?(c[b+92>>2]|0)<0:0){d=c[b+96>>2]|0;if(d|0){if(a[b+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+96>>2]=0}a[b+100>>0]=1;c[b+96>>2]=0;c[b+92>>2]=0}c[b+88>>2]=0;if((c[b+8>>2]|0)>=0){c[b+8>>2]=0;i=r;return 0.0}if((c[b+12>>2]|0)>=0){c[b+8>>2]=0;i=r;return 0.0}d=c[b+16>>2]|0;if(d|0){if(a[b+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+12>>2]=0;c[b+8>>2]=0;i=r;return 0.0}function ed(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,j=0.0,k=0.0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0;u=i;i=i+704|0;c[u+480+8>>2]=0;c[u+480+12>>2]=1065353216;c[u+480+16>>2]=1065353216;c[u+480+20>>2]=1065353216;g[u+480+24>>2]=0.0;c[u+480>>2]=6672;c[u+480+4>>2]=8;g[u+480+28>>2]=0.0;g[u+480+44>>2]=0.0;g[u+416>>2]=1.0;m=u+416+4|0;c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;g[u+416+20>>2]=1.0;n=u+416+24|0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;g[u+416+40>>2]=1.0;g[u+416+44>>2]=0.0;c[u+416+48>>2]=c[a>>2];c[u+416+48+4>>2]=c[a+4>>2];c[u+416+48+8>>2]=c[a+8>>2];c[u+416+48+12>>2]=c[a+12>>2];a=e;l=a+36|0;do{c[a>>2]=0;a=a+4|0}while((a|0)<(l|0));c[u+536>>2]=b;c[u+536+4>>2]=u+480;H=+g[d>>2];G=+g[d+16>>2];F=+g[d+32>>2];E=+g[d+4>>2];D=+g[d+20>>2];C=+g[d+36>>2];s=+g[d+8>>2];q=+g[d+24>>2];o=+g[d+40>>2];g[u+536+8>>2]=H+G*0.0+F*0.0;g[u+536+12>>2]=E+D*0.0+C*0.0;g[u+536+16>>2]=s+q*0.0+o*0.0;g[u+536+20>>2]=0.0;g[u+536+24>>2]=H*0.0+G+F*0.0;g[u+536+28>>2]=E*0.0+D+C*0.0;g[u+536+32>>2]=s*0.0+q+o*0.0;g[u+536+36>>2]=0.0;g[u+536+40>>2]=H*0.0+G*0.0+F;g[u+536+44>>2]=E*0.0+D*0.0+C;g[u+536+48>>2]=s*0.0+q*0.0+o;g[u+536+52>>2]=0.0;o=+g[u+416+48>>2]-+g[d+48>>2];q=+g[u+416+52>>2]-+g[d+52>>2];s=+g[u+416+56>>2]-+g[d+56>>2];B=+g[u+416>>2];A=+g[u+416+16>>2];z=+g[u+416+32>>2];y=+g[m>>2];x=+g[u+416+20>>2];w=+g[u+416+36>>2];v=+g[u+416+8>>2];f=+g[n>>2];h=+g[u+416+40>>2];p=+g[d+8>>2];r=+g[d+24>>2];t=+g[d+40>>2];j=o*+g[d>>2]+q*+g[d+16>>2]+s*+g[d+32>>2];k=o*+g[d+4>>2]+q*+g[d+20>>2]+s*+g[d+36>>2];g[u+536+56>>2]=H*B+G*A+F*z;g[u+536+60>>2]=H*y+G*x+F*w;g[u+536+64>>2]=H*v+G*f+F*h;g[u+536+68>>2]=0.0;g[u+536+72>>2]=B*E+A*D+z*C;g[u+536+76>>2]=y*E+x*D+w*C;g[u+536+80>>2]=v*E+f*D+h*C;g[u+536+84>>2]=0.0;g[u+536+88>>2]=B*p+A*r+z*t;g[u+536+92>>2]=y*p+x*r+w*t;g[u+536+96>>2]=v*p+f*r+h*t;g[u+536+100>>2]=0.0;g[u+536+104>>2]=j;g[u+536+108>>2]=k;g[u+536+112>>2]=o*p+q*r+s*t;g[u+536+116>>2]=0.0;c[u+536+120>>2]=80;c[u+536+124>>2]=0;a=u+32+128|0;c[u+32+364>>2]=0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[u+32+376>>2]=2;c[u+32+368>>2]=0;g[u+32+144>>2]=0.0;c[u+16>>2]=1065353216;c[u+16+4>>2]=1065353216;c[u+16+8>>2]=1065353216;g[u+16+12>>2]=0.0;switch(Uc(u+32|0,u+536|0,u+16|0)|0){case 0:{a=c[u+32+372>>2]|0;if(!(c[a+32>>2]|0)){k=0.0;j=0.0;f=0.0;r=0.0;q=0.0;h=0.0}else{n=0;k=0.0;j=0.0;f=0.0;r=0.0;q=0.0;h=0.0;do{t=+g[a+16+(n<<2)>>2];l=c[u+536+120>>2]|0;I=c[u+536+124>>2]|0;m=(c[u+536>>2]|0)+(I>>1)|0;if(I&1)l=c[(c[m>>2]|0)+l>>2]|0;ic[l&127](u,m,c[a+(n<<2)>>2]|0);k=k+t*+g[u>>2];f=f+t*+g[u+4>>2];j=j+t*+g[u+8>>2];a=c[(c[u+32+372>>2]|0)+(n<<2)>>2]|0;o=-+g[a>>2];p=-+g[a+4>>2];s=-+g[a+8>>2];a=c[u+536+120>>2]|0;I=c[u+536+124>>2]|0;l=(c[u+536+4>>2]|0)+(I>>1)|0;if(I&1)a=c[(c[l>>2]|0)+a>>2]|0;G=+g[u+536+24>>2]*o+ +g[u+536+28>>2]*p+ +g[u+536+32>>2]*s;F=+g[u+536+40>>2]*o+ +g[u+536+44>>2]*p+ +g[u+536+48>>2]*s;g[u+664>>2]=+g[u+536+8>>2]*o+ +g[u+536+12>>2]*p+ +g[u+536+16>>2]*s;g[u+664+4>>2]=G;g[u+664+8>>2]=F;g[u+664+12>>2]=0.0;ic[a&127](u+680|0,l,u+664|0);F=+g[u+680>>2];G=+g[u+680+4>>2];H=+g[u+680+8>>2];r=r+t*(F*+g[u+536+56>>2]+G*+g[u+536+60>>2]+H*+g[u+536+64>>2]+ +g[u+536+104>>2]);h=h+t*(F*+g[u+536+72>>2]+G*+g[u+536+76>>2]+H*+g[u+536+80>>2]+ +g[u+536+108>>2]);q=q+t*(F*+g[u+536+88>>2]+G*+g[u+536+92>>2]+H*+g[u+536+96>>2]+ +g[u+536+112>>2]);n=n+1|0;a=c[u+32+372>>2]|0}while(n>>>0<(c[a+32>>2]|0)>>>0)}s=k*+g[d>>2]+f*+g[d+4>>2]+j*+g[d+8>>2]+ +g[d+48>>2];t=k*+g[d+16>>2]+f*+g[d+20>>2]+j*+g[d+24>>2]+ +g[d+52>>2];k=k*+g[d+32>>2]+f*+g[d+36>>2]+j*+g[d+40>>2]+ +g[d+56>>2];g[e+4>>2]=s;g[e+8>>2]=t;g[e+12>>2]=k;g[e+16>>2]=0.0;o=r*+g[d>>2]+h*+g[d+4>>2]+q*+g[d+8>>2]+ +g[d+48>>2];p=r*+g[d+16>>2]+h*+g[d+20>>2]+q*+g[d+24>>2]+ +g[d+52>>2];j=r*+g[d+32>>2]+h*+g[d+36>>2]+q*+g[d+40>>2]+ +g[d+56>>2];g[e+20>>2]=o;g[e+24>>2]=p;g[e+28>>2]=j;g[e+32>>2]=0.0;switch(c[b+4>>2]|0){case 8:{f=+g[b+28>>2]*+g[b+12>>2];break}case 0:{f=+g[b+44>>2];break}case 1:{f=+g[b+44>>2];break}case 13:{f=+g[b+44>>2];break}case 11:{f=+g[b+44>>2];break}case 10:{f=+g[b+44>>2];break}case 4:case 5:{f=+g[b+44>>2];break}default:f=+Sb[c[(c[b>>2]|0)+48>>2]&15](b)}switch(c[u+480+4>>2]|0){case 8:{h=+g[u+480+28>>2]*+g[u+480+12>>2];break}case 0:{h=+g[u+480+44>>2];break}case 1:{h=+g[u+480+44>>2];break}case 13:{h=+g[u+480+44>>2];break}case 11:{h=+g[u+480+44>>2];break}case 10:{h=+g[u+480+44>>2];break}case 4:case 5:{h=+g[u+480+44>>2];break}default:h=+Sb[c[(c[u+480>>2]|0)+48>>2]&15](u+480|0)}H=f+h;G=+O(+((o-s)*(o-s)+(p-t)*(p-t)+(j-k)*(j-k)));g[e+36>>2]=(o-s)*(1.0/G);g[e+40>>2]=(p-t)*(1.0/G);g[e+44>>2]=(j-k)*(1.0/G);g[e+48>>2]=0.0;g[e+4>>2]=H*(o-s)*(1.0/G)+ +g[e+4>>2];g[e+8>>2]=H*(p-t)*(1.0/G)+ +g[e+8>>2];g[e+12>>2]=H*(j-k)*(1.0/G)+ +g[e+12>>2];H=G-H;i=u;return +H}case 1:{if(!(Pc(b,d,u+480|0,u+416|0,a,e,1)|0)){H=3402823466385288598117041.0e14;i=u;return +H}f=+g[e+4>>2]-+g[e+20>>2];h=+g[e+8>>2]-+g[e+24>>2];j=+g[e+12>>2]-+g[e+28>>2];k=+O(+(f*f+h*h+j*j));if(k>=1.1920928955078125e-07){g[e+36>>2]=f*(1.0/k);g[e+40>>2]=h*(1.0/k);g[e+44>>2]=j*(1.0/k);g[e+48>>2]=0.0}H=-k;i=u;return +H}default:{H=3402823466385288598117041.0e14;i=u;return +H}}return 0.0}function fd(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;o=i;i=i+48|0;d=c[a+24>>2]|0;if((d|0)<=0){i=o;return}n=0;do{m=c[(c[a+32>>2]|0)+(n<<2)>>2]|0;switch(c[m+216>>2]|0){case 2:case 5:break;default:{Wd(m,0);d=c[m+732>>2]|0;if((d|0)>0){e=0;do{l=c[m+740>>2]|0;j=c[l+(e*52|0)+12>>2]|0;k=c[l+(e*52|0)+8>>2]|0;y=+g[j+24>>2]-+g[k+24>>2];x=+g[j+28>>2]-+g[k+28>>2];b=+g[j+32>>2]-+g[k+32>>2];g[l+(e*52|0)+36>>2]=y;g[l+(e*52|0)+40>>2]=x;g[l+(e*52|0)+44>>2]=b;g[l+(e*52|0)+48>>2]=0.0;g[l+(e*52|0)+32>>2]=1.0/(+g[l+(e*52|0)+24>>2]*(y*y+x*x+b*b));e=e+1|0}while((e|0)!=(d|0))}e=c[m+792>>2]|0;if((e|0)>0){b=+g[m+452>>2];f=0;do{l=c[m+800>>2]|0;d=l+(f*96|0)+20|0;h=c[d>>2]|0;B=+g[l+(f*96|0)+4>>2];A=+g[l+(f*96|0)+8>>2];y=+g[l+(f*96|0)+12>>2];z=+g[h+4>>2]*B+ +g[h+8>>2]*A+ +g[h+12>>2]*y;x=B*+g[h+20>>2]+A*+g[h+24>>2]+y*+g[h+28>>2];y=B*+g[h+36>>2]+A*+g[h+40>>2]+y*+g[h+44>>2];j=l+(f*96|0)+28|0;k=l+(f*96|0)|0;Pf(o,b,+g[(c[k>>2]|0)+88>>2],+g[h+344>>2],h+264|0,z,x,y);c[j>>2]=c[o>>2];c[j+4>>2]=c[o+4>>2];c[j+8>>2]=c[o+8>>2];c[j+12>>2]=c[o+12>>2];j=l+(f*96|0)+44|0;c[j>>2]=c[o+16>>2];c[j+4>>2]=c[o+16+4>>2];c[j+8>>2]=c[o+16+8>>2];c[j+12>>2]=c[o+16+12>>2];j=l+(f*96|0)+60|0;c[j>>2]=c[o+32>>2];c[j+4>>2]=c[o+32+4>>2];c[j+8>>2]=c[o+32+8>>2];c[j+12>>2]=c[o+32+12>>2];g[l+(f*96|0)+76>>2]=z;g[l+(f*96|0)+80>>2]=x;g[l+(f*96|0)+84>>2]=y;g[l+(f*96|0)+88>>2]=0.0;b=+g[m+452>>2];g[l+(f*96|0)+92>>2]=b*+g[(c[k>>2]|0)+88>>2];d=c[d>>2]|0;if(!(c[d+204>>2]&3)){if((c[d+216>>2]&-2|0)!=4)c[d+216>>2]=1;g[d+220>>2]=0.0}f=f+1|0}while((f|0)!=(e|0))}d=c[m+372>>2]|0;if((d|0)>0){e=c[m+396>>2]|0;f=0;do{if((e|0)>0){d=0;do{zb[((c[(c[m+404>>2]|0)+(d<<2)>>2]|0)==0?23:0)&31](m,1.0);d=d+1|0;e=c[m+396>>2]|0}while((d|0)<(e|0));d=c[m+372>>2]|0}f=f+1|0}while((f|0)<(d|0));d=c[m+712>>2]|0;if((d|0)>0){e=0;do{l=c[m+720>>2]|0;z=+g[m+452>>2];A=z*+g[l+(e*104|0)+44>>2]+ +g[l+(e*104|0)+28>>2];B=z*+g[l+(e*104|0)+48>>2]+ +g[l+(e*104|0)+32>>2];g[l+(e*104|0)+8>>2]=+g[l+(e*104|0)+40>>2]*z+ +g[l+(e*104|0)+24>>2];g[l+(e*104|0)+12>>2]=A;g[l+(e*104|0)+16>>2]=B;g[l+(e*104|0)+20>>2]=0.0;e=e+1|0}while((e|0)!=(d|0))}}d=c[m+376>>2]|0;if((d|0)>0){e=c[m+416>>2]|0;h=0;do{b=+(h|0)/+(d|0);if((e|0)>0){f=0;do{switch(c[(c[m+424>>2]|0)+(f<<2)>>2]|0){case 1:{d=2;break}case 0:{d=3;break}case 2:{d=4;break}case 3:{d=5;break}default:d=0}Nb[d&7](m,1.0,b);f=f+1|0;e=c[m+416>>2]|0}while((f|0)<(e|0));d=c[m+376>>2]|0}h=h+1|0}while((h|0)<(d|0));b=+g[m+456>>2]*(1.0-+g[m+296>>2]);d=c[m+712>>2]|0;if((d|0)>0){e=0;do{l=c[m+720>>2]|0;A=b*(+g[l+(e*104|0)+12>>2]-+g[l+(e*104|0)+28>>2]);B=b*(+g[l+(e*104|0)+16>>2]-+g[l+(e*104|0)+32>>2]);g[l+(e*104|0)+40>>2]=b*(+g[l+(e*104|0)+8>>2]-+g[l+(e*104|0)+24>>2]);g[l+(e*104|0)+44>>2]=A;g[l+(e*104|0)+48>>2]=B;l=l+(e*104|0)+52|0;e=e+1|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0}while((e|0)!=(d|0))}}d=c[m+380>>2]|0;if((d|0)>0){b=+g[m+292>>2]*+g[m+456>>2];e=c[m+712>>2]|0;if((e|0)>0){d=0;do{k=c[m+720>>2]|0;l=k+(d*104|0)+24|0;k=k+(d*104|0)+8|0;c[l>>2]=c[k>>2];c[l+4>>2]=c[k+4>>2];c[l+8>>2]=c[k+8>>2];c[l+12>>2]=c[k+12>>2];d=d+1|0}while((d|0)!=(e|0));d=c[m+380>>2]|0;if((d|0)>0)w=42}else w=42;if((w|0)==42){w=0;e=c[m+436>>2]|0;h=0;do{if((e|0)>0){f=0;do{switch(c[(c[m+444>>2]|0)+(f<<2)>>2]|0){case 1:{d=2;break}case 0:{d=3;break}case 2:{d=4;break}case 3:{d=5;break}default:d=0}Nb[d&7](m,1.0,0.0);f=f+1|0;e=c[m+436>>2]|0}while((f|0)<(e|0));d=c[m+380>>2]|0}h=h+1|0}while((h|0)<(d|0))}d=c[m+712>>2]|0;if((d|0)>0){e=c[m+720>>2]|0;f=0;do{A=b*(+g[e+(f*104|0)+12>>2]-+g[e+(f*104|0)+28>>2]);B=b*(+g[e+(f*104|0)+16>>2]-+g[e+(f*104|0)+32>>2]);l=e+(f*104|0)+40|0;g[l>>2]=b*(+g[e+(f*104|0)+8>>2]-+g[e+(f*104|0)+24>>2])+ +g[l>>2];l=e+(f*104|0)+44|0;g[l>>2]=A+ +g[l>>2];l=e+(f*104|0)+48|0;g[l>>2]=B+ +g[l>>2];f=f+1|0}while((f|0)!=(d|0))}}d=c[m+1112>>2]|0;if((d|0)>0){e=c[m+1120>>2]|0;k=0;do{f=c[e+(k<<2)>>2]|0;if(+g[f+352>>2]>0.0?(p=c[f+24>>2]|0,(p|0)>0):0){h=c[f+32>>2]|0;l=0;do{j=c[h+(l<<2)>>2]|0;if(+g[j+88>>2]>0.0?(t=+g[j+24>>2]-+g[f+228>>2],v=+g[j+28>>2]-+g[f+232>>2],r=+g[j+32>>2]-+g[f+236>>2],s=+g[f+336>>2],B=+g[f+340>>2],u=+g[f+332>>2],q=+g[f+316>>2]+(s*r-v*B),r=+g[f+320>>2]+(t*B-r*u),s=v*u-t*s+ +g[f+324>>2],t=+g[j+40>>2],u=+g[j+44>>2],v=+g[j+48>>2],q*q+r*r+s*s<=t*t+u*u+v*v):0){B=+g[f+352>>2];g[j+40>>2]=t+(q-t)*B;g[j+44>>2]=(r-u)*B+u;g[j+48>>2]=(s-v)*B+v}l=l+1|0}while((l|0)!=(p|0))}k=k+1|0}while((k|0)!=(d|0))}Wd(m,1);d=c[a+24>>2]|0}}n=n+1|0}while((n|0)<(d|0));i=o;return}function gd(d,e){d=d|0;e=+e;var f=0,h=0.0,j=0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0,t=0.0,u=0;s=i;i=i+304|0;li(12028);a:do if((c[d+232>>2]|0)>0){n=s+136+48|0;o=0;while(1){m=c[(c[d+240>>2]|0)+(o<<2)>>2]|0;g[m+244>>2]=1.0;b:do switch(c[m+216>>2]|0){case 2:case 5:break;default:if(!(c[m+204>>2]&3)){Zg(m+4|0,+g[m+312>>2],+g[m+316>>2],+g[m+320>>2],m+328|0,e,s+136|0);h=+g[n>>2]-+g[m+52>>2];k=+g[s+136+52>>2]-+g[m+56>>2];l=+g[s+136+56>>2]-+g[m+60>>2];if(a[d+44>>0]|0?(t=+g[m+252>>2],t*t!=0.0?t*t<h*h+k*k+l*l:0):0){li(12048);if((c[(c[m+192>>2]|0)+4>>2]|0)<20){c[5816]=(c[5816]|0)+1;f=c[d+68>>2]|0;f=Eb[c[(c[f>>2]|0)+36>>2]&127](f)|0;j=c[d+24>>2]|0;g[s+200+4>>2]=1.0;b[s+200+8>>1]=1;b[s+200+10>>1]=-1;c[s+200>>2]=2872;c[s+200+12>>2]=c[m+52>>2];c[s+200+12+4>>2]=c[m+52+4>>2];c[s+200+12+8>>2]=c[m+52+8>>2];c[s+200+12+12>>2]=c[m+52+12>>2];c[s+200+28>>2]=c[n>>2];c[s+200+28+4>>2]=c[n+4>>2];c[s+200+28+8>>2]=c[n+8>>2];c[s+200+28+12>>2]=c[n+12>>2];c[s+200+76>>2]=0;c[s+200>>2]=4332;c[s+200+80>>2]=m;c[s+200+88>>2]=f;c[s+200+92>>2]=j;j=c[m+248>>2]|0;c[s+64+8>>2]=0;c[s+64+12>>2]=1065353216;c[s+64+16>>2]=1065353216;c[s+64+20>>2]=1065353216;g[s+64+24>>2]=0.0;c[s+64>>2]=6672;c[s+64+4>>2]=8;c[s+64+28>>2]=j;c[s+64+44>>2]=j;c[s+200+84>>2]=c[d+56>>2];j=c[(c[m+188>>2]|0)+4>>2]|0;b[s+200+8>>1]=j;b[s+200+10>>1]=j>>>16;c[s+48>>2]=c[n>>2];c[s+48+4>>2]=c[n+4>>2];c[s+48+8>>2]=c[n+8>>2];c[s+48+12>>2]=c[n+12>>2];c[s>>2]=c[m+4>>2];c[s+4>>2]=c[m+4+4>>2];c[s+8>>2]=c[m+4+8>>2];c[s+12>>2]=c[m+4+12>>2];c[s+16>>2]=c[m+20>>2];c[s+16+4>>2]=c[m+20+4>>2];c[s+16+8>>2]=c[m+20+8>>2];c[s+16+12>>2]=c[m+20+12>>2];c[s+32>>2]=c[m+36>>2];c[s+32+4>>2]=c[m+36+4>>2];c[s+32+8>>2]=c[m+36+8>>2];c[s+32+12>>2]=c[m+36+12>>2];Kd(d,s+64|0,m+4|0,s,s+200|0,0.0);h=+g[s+200+4>>2];if(h<1.0){g[m+244>>2]=h;Zg(m+4|0,+g[m+312>>2],+g[m+316>>2],+g[m+320>>2],m+328|0,h*e,s+136|0);g[m+244>>2]=0.0;Se(m,s+136|0);f=4}else f=0;if(!f)p=12}else p=12;if((p|0)==12){p=0;f=0}j=c[2357]|0;u=(c[j+16>>2]|0)+-1|0;c[j+16>>2]=u;do if(!u){if(c[j+4>>2]|0){tb(s+200|0,0)|0;u=c[6434]|0;g[j+8>>2]=+g[j+8>>2]+ +(((c[s+200+4>>2]|0)-(c[u+4>>2]|0)+(((c[s+200>>2]|0)-(c[u>>2]|0)|0)*1e6|0)-(c[j+12>>2]|0)|0)>>>0)/1.0e3;if(c[j+16>>2]|0)break;j=c[2357]|0}c[2357]=c[j+20>>2]}while(0);if(f|0)break b}Se(m,s+136|0)}}while(0);o=o+1|0;if((o|0)>=(c[d+232>>2]|0))break a}}while(0);do if(a[d+275>>0]|0){li(12105);if((c[d+308>>2]|0)>0){p=0;do{o=c[(c[d+316>>2]|0)+(p<<2)>>2]|0;m=c[o+740>>2]|0;m=(c[m+236>>2]&2|0)==0?0:m;n=c[o+744>>2]|0;n=(c[n+236>>2]&2|0)==0?0:n;f=c[o+748>>2]|0;if((f|0)>0)if(!m){j=0;do{h=+g[57]*+g[n+228>>2];if(h>0.0?(q=+g[o+4+(j*184|0)+120>>2],q!=0.0):0){l=h*+g[o+4+(j*184|0)+64>>2]*q;e=h*+g[o+4+(j*184|0)+68>>2]*q;t=h*+g[o+4+(j*184|0)+72>>2]*q;h=+g[o+4+(j*184|0)+36>>2]-+g[n+56>>2];k=+g[o+4+(j*184|0)+40>>2]-+g[n+60>>2];g[s>>2]=+g[o+4+(j*184|0)+32>>2]-+g[n+52>>2];g[s+4>>2]=h;g[s+8>>2]=k;g[s+12>>2]=0.0;g[s+120>>2]=l;g[s+120+4>>2]=e;g[s+120+8>>2]=t;g[s+120+12>>2]=0.0;gj(n,s+120|0,s);f=c[o+748>>2]|0}j=j+1|0}while((j|0)<(f|0))}else{j=0;do{h=+g[m+228>>2]*+g[n+228>>2];if(h>0.0?(r=+g[o+4+(j*184|0)+120>>2],r!=0.0):0){l=h*+g[o+4+(j*184|0)+64>>2]*r;e=h*+g[o+4+(j*184|0)+68>>2]*r;t=h*+g[o+4+(j*184|0)+72>>2]*r;g[s+200>>2]=-l;g[s+200+4>>2]=-e;g[s+200+8>>2]=-t;g[s+200+12>>2]=0.0;k=+g[o+4+(j*184|0)+52>>2]-+g[m+56>>2];h=+g[o+4+(j*184|0)+56>>2]-+g[m+60>>2];g[s+64>>2]=+g[o+4+(j*184|0)+48>>2]-+g[m+52>>2];g[s+64+4>>2]=k;g[s+64+8>>2]=h;g[s+64+12>>2]=0.0;h=+g[o+4+(j*184|0)+36>>2]-+g[n+56>>2];k=+g[o+4+(j*184|0)+40>>2]-+g[n+60>>2];g[s>>2]=+g[o+4+(j*184|0)+32>>2]-+g[n+52>>2];g[s+4>>2]=h;g[s+8>>2]=k;g[s+12>>2]=0.0;gj(m,s+200|0,s+64|0);g[s+120>>2]=l;g[s+120+4>>2]=e;g[s+120+8>>2]=t;g[s+120+12>>2]=0.0;gj(n,s+120|0,s);f=c[o+748>>2]|0}j=j+1|0}while((j|0)<(f|0))}p=p+1|0}while((p|0)<(c[d+308>>2]|0))}f=c[2357]|0;u=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=u;if(!u){if(c[f+4>>2]|0){tb(s+200|0,0)|0;u=c[6434]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[s+200+4>>2]|0)-(c[u+4>>2]|0)+(((c[s+200>>2]|0)-(c[u>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(c[f+16>>2]|0)break;f=c[2357]|0}c[2357]=c[f+20>>2]}}while(0);f=c[2357]|0;u=(c[f+16>>2]|0)+-1|0;c[f+16>>2]=u;if(u|0){i=s;return}do if(c[f+4>>2]|0){tb(s+200|0,0)|0;u=c[6434]|0;g[f+8>>2]=+g[f+8>>2]+ +(((c[s+200+4>>2]|0)-(c[u+4>>2]|0)+(((c[s+200>>2]|0)-(c[u>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[f+16>>2]|0)){f=c[2357]|0;break}else{i=s;return}}while(0);c[2357]=c[f+20>>2];i=s;return}function hd(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if(!a)return;h=c[6442]|0;if((a+-8|0)>>>0<h>>>0)Va();b=c[a+-4>>2]|0;if((b&3|0)==1)Va();n=a+-8+(b&-8)|0;do if(!(b&1)){e=c[a+-8>>2]|0;if(!(b&3))return;k=a+-8+(0-e)|0;j=e+(b&-8)|0;if(k>>>0<h>>>0)Va();if((k|0)==(c[6443]|0)){a=c[n+4>>2]|0;if((a&3|0)!=3){q=k;f=j;break}c[6440]=j;c[n+4>>2]=a&-2;c[k+4>>2]=j|1;c[k+j>>2]=j;return}if(e>>>0<256){a=c[k+8>>2]|0;b=c[k+12>>2]|0;if((a|0)!=(25792+(e>>>3<<1<<2)|0)){if(a>>>0<h>>>0)Va();if((c[a+12>>2]|0)!=(k|0))Va()}if((b|0)==(a|0)){c[6438]=c[6438]&~(1<<(e>>>3));q=k;f=j;break}if((b|0)!=(25792+(e>>>3<<1<<2)|0)){if(b>>>0<h>>>0)Va();if((c[b+8>>2]|0)!=(k|0))Va();else d=b+8|0}else d=b+8|0;c[a+12>>2]=b;c[d>>2]=a;q=k;f=j;break}g=c[k+24>>2]|0;a=c[k+12>>2]|0;do if((a|0)==(k|0)){a=c[k+16+4>>2]|0;if(!a){a=c[k+16>>2]|0;if(!a){i=0;break}else e=k+16|0}else e=k+16+4|0;while(1){b=a+20|0;d=c[b>>2]|0;if(d|0){a=d;e=b;continue}b=a+16|0;d=c[b>>2]|0;if(!d)break;else{a=d;e=b}}if(e>>>0<h>>>0)Va();else{c[e>>2]=0;i=a;break}}else{b=c[k+8>>2]|0;if(b>>>0<h>>>0)Va();if((c[b+12>>2]|0)!=(k|0))Va();if((c[a+8>>2]|0)==(k|0)){c[b+12>>2]=a;c[a+8>>2]=b;i=a;break}else Va()}while(0);if(g){a=c[k+28>>2]|0;if((k|0)==(c[26056+(a<<2)>>2]|0)){c[26056+(a<<2)>>2]=i;if(!i){c[6439]=c[6439]&~(1<<a);q=k;f=j;break}}else{if(g>>>0<(c[6442]|0)>>>0)Va();if((c[g+16>>2]|0)==(k|0))c[g+16>>2]=i;else c[g+20>>2]=i;if(!i){q=k;f=j;break}}b=c[6442]|0;if(i>>>0<b>>>0)Va();c[i+24>>2]=g;a=c[k+16>>2]|0;do if(a|0)if(a>>>0<b>>>0)Va();else{c[i+16>>2]=a;c[a+24>>2]=i;break}while(0);a=c[k+16+4>>2]|0;if(a)if(a>>>0<(c[6442]|0)>>>0)Va();else{c[i+20>>2]=a;c[a+24>>2]=i;q=k;f=j;break}else{q=k;f=j}}else{q=k;f=j}}else{q=a+-8|0;f=b&-8}while(0);if(q>>>0>=n>>>0)Va();d=c[n+4>>2]|0;if(!(d&1))Va();if(!(d&2)){if((n|0)==(c[6444]|0)){p=(c[6441]|0)+f|0;c[6441]=p;c[6444]=q;c[q+4>>2]=p|1;if((q|0)!=(c[6443]|0))return;c[6443]=0;c[6440]=0;return}if((n|0)==(c[6443]|0)){p=(c[6440]|0)+f|0;c[6440]=p;c[6443]=q;c[q+4>>2]=p|1;c[q+p>>2]=p;return}f=(d&-8)+f|0;do if(d>>>0>=256){g=c[n+24>>2]|0;a=c[n+12>>2]|0;do if((a|0)==(n|0)){a=c[n+16+4>>2]|0;if(!a){a=c[n+16>>2]|0;if(!a){m=0;break}else e=n+16|0}else e=n+16+4|0;while(1){b=a+20|0;d=c[b>>2]|0;if(d|0){a=d;e=b;continue}b=a+16|0;d=c[b>>2]|0;if(!d)break;else{a=d;e=b}}if(e>>>0<(c[6442]|0)>>>0)Va();else{c[e>>2]=0;m=a;break}}else{b=c[n+8>>2]|0;if(b>>>0<(c[6442]|0)>>>0)Va();if((c[b+12>>2]|0)!=(n|0))Va();if((c[a+8>>2]|0)==(n|0)){c[b+12>>2]=a;c[a+8>>2]=b;m=a;break}else Va()}while(0);if(g|0){a=c[n+28>>2]|0;if((n|0)==(c[26056+(a<<2)>>2]|0)){c[26056+(a<<2)>>2]=m;if(!m){c[6439]=c[6439]&~(1<<a);break}}else{if(g>>>0<(c[6442]|0)>>>0)Va();if((c[g+16>>2]|0)==(n|0))c[g+16>>2]=m;else c[g+20>>2]=m;if(!m)break}b=c[6442]|0;if(m>>>0<b>>>0)Va();c[m+24>>2]=g;a=c[n+16>>2]|0;do if(a|0)if(a>>>0<b>>>0)Va();else{c[m+16>>2]=a;c[a+24>>2]=m;break}while(0);a=c[n+16+4>>2]|0;if(a|0)if(a>>>0<(c[6442]|0)>>>0)Va();else{c[m+20>>2]=a;c[a+24>>2]=m;break}}}else{a=c[n+8>>2]|0;b=c[n+12>>2]|0;if((a|0)!=(25792+(d>>>3<<1<<2)|0)){if(a>>>0<(c[6442]|0)>>>0)Va();if((c[a+12>>2]|0)!=(n|0))Va()}if((b|0)==(a|0)){c[6438]=c[6438]&~(1<<(d>>>3));break}if((b|0)!=(25792+(d>>>3<<1<<2)|0)){if(b>>>0<(c[6442]|0)>>>0)Va();if((c[b+8>>2]|0)!=(n|0))Va();else l=b+8|0}else l=b+8|0;c[a+12>>2]=b;c[l>>2]=a}while(0);c[q+4>>2]=f|1;c[q+f>>2]=f;if((q|0)==(c[6443]|0)){c[6440]=f;return}}else{c[n+4>>2]=d&-2;c[q+4>>2]=f|1;c[q+f>>2]=f}b=f>>>3;if(f>>>0<256){a=c[6438]|0;if(a&1<<b){a=c[25792+(b<<1<<2)+8>>2]|0;if(a>>>0<(c[6442]|0)>>>0)Va();else{o=25792+(b<<1<<2)+8|0;p=a}}else{c[6438]=a|1<<b;o=25792+(b<<1<<2)+8|0;p=25792+(b<<1<<2)|0}c[o>>2]=q;c[p+12>>2]=q;c[q+8>>2]=p;c[q+12>>2]=25792+(b<<1<<2);return}a=f>>>8;if(a)if(f>>>0>16777215)d=31;else{d=a<<((a+1048320|0)>>>16&8)<<(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4);d=14-(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4|(a+1048320|0)>>>16&8|(d+245760|0)>>>16&2)+(d<<((d+245760|0)>>>16&2)>>>15)|0;d=f>>>(d+7|0)&1|d<<1}else d=0;e=26056+(d<<2)|0;c[q+28>>2]=d;c[q+20>>2]=0;c[q+16>>2]=0;a=c[6439]|0;b=1<<d;do if(a&b){d=f<<((d|0)==31?0:25-(d>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(f|0)){a=130;break}b=e+16+(d>>>31<<2)|0;a=c[b>>2]|0;if(!a){a=127;break}else{d=d<<1;e=a}}if((a|0)==127)if(b>>>0<(c[6442]|0)>>>0)Va();else{c[b>>2]=q;c[q+24>>2]=e;c[q+12>>2]=q;c[q+8>>2]=q;break}else if((a|0)==130){a=e+8|0;b=c[a>>2]|0;p=c[6442]|0;if(b>>>0>=p>>>0&e>>>0>=p>>>0){c[b+12>>2]=q;c[a>>2]=q;c[q+8>>2]=b;c[q+12>>2]=e;c[q+24>>2]=0;break}else Va()}}else{c[6439]=a|b;c[e>>2]=q;c[q+24>>2]=e;c[q+12>>2]=q;c[q+8>>2]=q}while(0);q=(c[6446]|0)+-1|0;c[6446]=q;if(!q)a=26208;else return;while(1){a=c[a>>2]|0;if(!a)break;else a=a+8|0}c[6446]=-1;return}function id(b,d,e){b=b|0;d=d|0;e=+e;var f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0,p=0.0,q=0,r=0,s=0;s=i;i=i+112|0;q=c[b+716>>2]|0;if((q|0)==(c[b+712>>2]|0)){a:do if(q){k=c[b+720>>2]|0;if((q|0)>0){h=k;j=0;while(1){f=c[h+(j*104|0)+96>>2]|0;if(f|0)c[f+36>>2]=j;f=j+1|0;if((f|0)==(q|0))break a;h=c[b+720>>2]|0;j=f}}}else k=0;while(0);f=c[b+732>>2]|0;if((f|0)>0){h=0;do{o=(c[b+740>>2]|0)+(h*52|0)+8|0;c[o>>2]=((c[o>>2]|0)-k|0)/104|0;o=(c[b+740>>2]|0)+(h*52|0)+12|0;c[o>>2]=((c[o>>2]|0)-k|0)/104|0;h=h+1|0}while((h|0)!=(f|0))}f=c[b+752>>2]|0;if((f|0)>0){j=0;do{h=(c[b+760>>2]|0)+(j*44|0)+8|0;c[h>>2]=((c[h>>2]|0)-k|0)/104|0;h=(c[b+760>>2]|0)+(j*44|0)+12|0;c[h>>2]=((c[h>>2]|0)-k|0)/104|0;h=(c[b+760>>2]|0)+(j*44|0)+16|0;c[h>>2]=((c[h>>2]|0)-k|0)/104|0;h=c[(c[b+760>>2]|0)+(j*44|0)+40>>2]|0;if(h|0)c[h+36>>2]=j;j=j+1|0}while((j|0)!=(f|0))}f=c[b+792>>2]|0;if((f|0)>0){h=c[b+800>>2]|0;j=0;do{o=h+(j*96|0)|0;c[o>>2]=((c[o>>2]|0)-k|0)/104|0;j=j+1|0}while((j|0)!=(f|0))}j=c[b+692>>2]|0;if((j|0)>0){f=c[b+700>>2]|0;l=0;do{if((c[f+(l*60|0)+24>>2]|0)>0){h=0;do{f=f+(l*60|0)+28+(h<<2)|0;c[f>>2]=((c[f>>2]|0)-k|0)/104|0;h=h+1|0;f=c[b+700>>2]|0}while((h|0)<(c[f+(l*60|0)+24>>2]|0))}l=l+1|0}while((l|0)!=(j|0))}if((q|0)<(q<<1|1|0)){c[6435]=(c[6435]|0)+1;f=yc(((q<<1|1)*104|3)+16|0)|0;if(!f)j=0;else{c[(f+4+15&-16)+-4>>2]=f;j=f+4+15&-16}f=c[b+712>>2]|0;if((f|0)>0){h=0;do{l=j+(h*104|0)|0;k=(c[b+720>>2]|0)+(h*104|0)|0;o=l+104|0;do{c[l>>2]=c[k>>2];l=l+4|0;k=k+4|0}while((l|0)<(o|0));h=h+1|0}while((h|0)!=(f|0))}f=c[b+720>>2]|0;if(f|0){if(a[b+724>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+720>>2]=0}a[b+724>>0]=1;c[b+720>>2]=j;c[b+716>>2]=q<<1|1;j=c[b+712>>2]|0}else j=q;b:do if(j){k=c[b+720>>2]|0;if((j|0)>0){l=k;f=0;while(1){h=c[l+(f*104|0)+96>>2]|0;if(h|0)c[h+36>>2]=l+(f*104|0);f=f+1|0;if((f|0)==(j|0)){l=k;break b}l=c[b+720>>2]|0}}else l=k}else l=0;while(0);f=c[b+732>>2]|0;if((f|0)>0){h=0;do{q=(c[b+740>>2]|0)+(h*52|0)+8|0;c[q>>2]=l+((c[q>>2]|0)*104|0);q=(c[b+740>>2]|0)+(h*52|0)+12|0;c[q>>2]=l+((c[q>>2]|0)*104|0);h=h+1|0}while((h|0)!=(f|0))}f=c[b+752>>2]|0;if((f|0)>0){k=0;do{h=(c[b+760>>2]|0)+(k*44|0)+8|0;c[h>>2]=l+((c[h>>2]|0)*104|0);h=(c[b+760>>2]|0)+(k*44|0)+12|0;c[h>>2]=l+((c[h>>2]|0)*104|0);h=(c[b+760>>2]|0)+(k*44|0)+16|0;c[h>>2]=l+((c[h>>2]|0)*104|0);h=c[b+760>>2]|0;j=c[h+(k*44|0)+40>>2]|0;if(j|0)c[j+36>>2]=h+(k*44|0);k=k+1|0}while((k|0)!=(f|0))}f=c[b+792>>2]|0;if((f|0)>0){h=c[b+800>>2]|0;j=0;do{c[h+(j*96|0)>>2]=l+((c[h+(j*96|0)>>2]|0)*104|0);j=j+1|0}while((j|0)!=(f|0))}j=c[b+692>>2]|0;if((j|0)>0){f=c[b+700>>2]|0;k=0;do{if((c[f+(k*60|0)+24>>2]|0)>0){h=0;do{f=f+(k*60|0)+28+(h<<2)|0;c[f>>2]=l+((c[f>>2]|0)*104|0);h=h+1|0;f=c[b+700>>2]|0}while((h|0)<(c[f+(k*60|0)+24>>2]|0))}k=k+1|0}while((k|0)!=(j|0))}}l=c[b+192>>2]|0;p=+Sb[c[(c[l>>2]|0)+48>>2]&15](l);l=s;o=l+100|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(o|0));f=c[b+712>>2]|0;if((f|0)==(c[b+716>>2]|0)?(r=f|0?f<<1:1,(f|0)<(r|0)):0){if(!r)j=0;else{c[6435]=(c[6435]|0)+1;f=yc((r*104|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}j=f;f=c[b+712>>2]|0}if((f|0)>0){h=0;do{l=j+(h*104|0)|0;k=(c[b+720>>2]|0)+(h*104|0)|0;o=l+104|0;do{c[l>>2]=c[k>>2];l=l+4|0;k=k+4|0}while((l|0)<(o|0));h=h+1|0}while((h|0)!=(f|0))}f=c[b+720>>2]|0;if(f|0){if(a[b+724>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+720>>2]=0}a[b+724>>0]=1;c[b+720>>2]=j;c[b+716>>2]=r;f=c[b+712>>2]|0}l=c[b+720>>2]|0;c[l+(f*104|0)>>2]=0;l=l+(f*104|0)+4|0;k=s;o=l+100|0;do{c[l>>2]=c[k>>2];l=l+4|0;k=k+4|0}while((l|0)<(o|0));h=c[b+712>>2]|0;c[b+712>>2]=h+1;j=c[b+720>>2]|0;l=j+(h*104|0)|0;o=l+104|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(o|0));c[j+(h*104|0)+8>>2]=c[d>>2];c[j+(h*104|0)+8+4>>2]=c[d+4>>2];c[j+(h*104|0)+8+8>>2]=c[d+8>>2];c[j+(h*104|0)+8+12>>2]=c[d+12>>2];Bp(j+(h*104|0)+24|0,d|0,16)|0;g[j+(h*104|0)+88>>2]=e>0.0?1.0/e:0.0;c[j+(h*104|0)+4>>2]=c[c[b+880>>2]>>2];e=+g[j+(h*104|0)+8>>2];m=+g[j+(h*104|0)+12>>2];n=+g[j+(h*104|0)+16>>2];f=c[b+932>>2]|0;if(f|0){c[b+932>>2]=0;d=f;r=d+32|0;c[r>>2]=0;r=d+36|0;c[r>>2]=j+(h*104|0);r=d+40|0;c[r>>2]=0;g[d>>2]=e-p;r=d+4|0;g[r>>2]=m-p;r=d+8|0;g[r>>2]=n-p;r=d+12|0;g[r>>2]=0.0;r=d+16|0;g[r>>2]=p+e;r=d+20|0;g[r>>2]=p+m;r=d+24|0;g[r>>2]=p+n;r=d+28|0;g[r>>2]=0.0;r=c[b+928>>2]|0;lf(b+928|0,r,d);b=b+940|0;r=c[b>>2]|0;r=r+1|0;c[b>>2]=r;b=j+(h*104|0)+96|0;c[b>>2]=d;i=s;return}c[6435]=(c[6435]|0)+1;f=yc(63)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}l=f;o=l+44|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(o|0));d=f;r=d+32|0;c[r>>2]=0;r=d+36|0;c[r>>2]=j+(h*104|0);r=d+40|0;c[r>>2]=0;g[d>>2]=e-p;r=d+4|0;g[r>>2]=m-p;r=d+8|0;g[r>>2]=n-p;r=d+12|0;g[r>>2]=0.0;r=d+16|0;g[r>>2]=p+e;r=d+20|0;g[r>>2]=p+m;r=d+24|0;g[r>>2]=p+n;r=d+28|0;g[r>>2]=0.0;r=c[b+928>>2]|0;lf(b+928|0,r,d);b=b+940|0;r=c[b>>2]|0;r=r+1|0;c[b>>2]=r;b=j+(h*104|0)+96|0;c[b>>2]=d;i=s;return}function jd(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0;G=i;i=i+32|0;c[G+16>>2]=j;c[G+16+4>>2]=k;c[G+16+8>>2]=l;c[G>>2]=e;c[G+4>>2]=f;c[G+8>>2]=h;if(!(+g[d+52>>2]<+g[b+12>>2])){m=0;i=G;return m|0}E=+g[d+36>>2];F=+g[d+40>>2];w=+g[d+44>>2];h=c[d+48>>2]|0;x=1.0/+O(+(E*E+F*F+w*w));l=ri(G)|0;y=+g[d+4>>2]-+g[l+48>>2];z=+g[d+8>>2]-+g[l+52>>2];A=+g[d+12>>2]-+g[l+56>>2];l=ri(G+16|0)|0;B=+g[d+20>>2]-+g[l+48>>2];C=+g[d+24>>2]-+g[l+52>>2];D=+g[d+28>>2]-+g[l+56>>2];if(!f)if(!e){n=0.0;o=0.0;r=0.0;s=0.0;p=0.0;q=0.0}else{q=+g[e+336>>2];r=+g[e+340>>2];v=+g[e+332>>2];n=A*q-z*r;o=+g[e+316>>2];r=y*r-A*v;s=+g[e+320>>2];p=+g[e+324>>2];q=z*v-y*q}else{q=+g[f+332>>2];r=+g[f+336>>2];v=+g[f+328>>2];n=A*q-z*r;o=+g[f+312>>2];r=y*r-A*v;s=+g[f+316>>2];p=+g[f+320>>2];q=z*v-y*q}v=o+n;u=s+r;t=p+q;if(!k)if(!j){p=0.0;q=0.0;r=0.0;s=0.0;n=0.0;o=0.0}else{o=+g[j+336>>2];r=+g[j+340>>2];H=+g[j+332>>2];p=D*o-C*r;q=+g[j+316>>2];r=B*r-D*H;s=+g[j+320>>2];n=+g[j+324>>2];o=C*H-B*o}else{o=+g[k+332>>2];r=+g[k+336>>2];H=+g[k+328>>2];p=D*o-C*r;q=+g[k+312>>2];r=B*r-D*H;s=+g[k+316>>2];n=+g[k+320>>2];o=C*H-B*o}q=v-(q+p);u=u-(s+r);t=t-(n+o);v=w*x*t+(F*x*u+E*x*q);H=+g[d+52>>2]-+g[b+12>>2];c[m+4>>2]=c[G>>2];c[m+4+4>>2]=c[G+4>>2];c[m+4+8>>2]=c[G+8>>2];c[m+16>>2]=c[G+16>>2];c[m+16+4>>2]=c[G+16+4>>2];c[m+16+8>>2]=c[G+16+8>>2];d=ri(G)|0;s=y*+g[d+4>>2]+z*+g[d+20>>2]+A*+g[d+36>>2];r=y*+g[d+8>>2]+z*+g[d+24>>2]+A*+g[d+40>>2];g[m+28>>2]=y*+g[d>>2]+z*+g[d+16>>2]+A*+g[d+32>>2];g[m+32>>2]=s;g[m+36>>2]=r;g[m+40>>2]=0.0;d=ri(G+16|0)|0;r=B*+g[d+4>>2]+C*+g[d+20>>2]+D*+g[d+36>>2];s=B*+g[d+8>>2]+C*+g[d+24>>2]+D*+g[d+40>>2];g[m+44>>2]=B*+g[d>>2]+C*+g[d+16>>2]+D*+g[d+32>>2];g[m+48>>2]=r;g[m+52>>2]=s;g[m+56>>2]=0.0;g[m+164>>2]=y;g[m+168>>2]=z;g[m+172>>2]=A;g[m+176>>2]=0.0;g[m+180>>2]=B;g[m+184>>2]=C;g[m+188>>2]=D;g[m+192>>2]=0.0;g[m+60>>2]=1.0;g[m+64>>2]=1.0;c[m+156>>2]=0;c[m+160>>2]=0;g[m+68>>2]=1.0;g[m+72>>2]=E*x*H;g[m+76>>2]=F*x*H;g[m+80>>2]=w*x*H;g[m+84>>2]=0.0;g[m+196>>2]=E*x;g[m+200>>2]=F*x;g[m+204>>2]=w*x;c[m+208>>2]=h;a[m+152>>0]=0;H=+g[b+16>>2];g[m+212>>2]=(t-w*x*v)*(t-w*x*v)+((q-E*x*v)*(q-E*x*v)+(u-F*x*v)*(u-F*x*v))<H*v*v*H?1.0:H;h=c[G+4>>2]|0;if(!h){h=c[G>>2]|0;if(!h)o=0.0;else o=+g[h+128>>2]}else o=+g[h+344>>2];if((a[22504]|0)==0?Wa(22504)|0:0){h=23084;l=h+48|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(l|0));_a(22504)}h=c[G+4>>2]|0;if(!h){e=c[G>>2]|0;e=(e|0)==0?23084:e+180|0}else e=h+264|0;h=c[G+16+4>>2]|0;if(!h){h=c[G+16>>2]|0;if(!h)n=0.0;else n=+g[h+128>>2]}else n=+g[h+344>>2];if((a[22504]|0)==0?Wa(22504)|0:0){h=23084;l=h+48|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(l|0));_a(22504)}h=c[G+16+4>>2]|0;if(!h){h=c[G+16>>2]|0;h=(h|0)==0?23084:h+180|0}else h=h+264|0;V=+g[m+172>>2];M=+g[m+168>>2];L=+g[m+164>>2];U=+g[e>>2];T=+g[e+16>>2];S=+g[e+32>>2];R=+g[e+4>>2];Q=+g[e+20>>2];P=+g[e+36>>2];N=+g[e+8>>2];K=+g[e+24>>2];J=+g[e+40>>2];B=+g[m+188>>2];v=+g[m+184>>2];w=+g[m+180>>2];I=+g[h>>2];p=+g[h+16>>2];q=+g[h+32>>2];r=+g[h+4>>2];s=+g[h+20>>2];t=+g[h+36>>2];u=+g[h+8>>2];H=+g[h+24>>2];x=+g[h+40>>2];D=o-((U*0.0+T*-V+M*S)*0.0+V*(R*0.0+Q*-V+M*P)+(N*0.0+K*-V+M*J)*-M)+(n-((I*0.0+p*-B+v*q)*0.0+B*(r*0.0+s*-B+v*t)+(u*0.0+H*-B+v*x)*-v));F=0.0-((U*0.0+T*-V+M*S)*-V+(R*0.0+Q*-V+M*P)*0.0+L*(N*0.0+K*-V+M*J))+(0.0-((I*0.0+p*-B+v*q)*-B+(r*0.0+s*-B+v*t)*0.0+w*(u*0.0+H*-B+v*x)));y=0.0-(M*(U*0.0+T*-V+M*S)+(R*0.0+Q*-V+M*P)*-L+(N*0.0+K*-V+M*J)*0.0)+(0.0-(v*(I*0.0+p*-B+v*q)+(r*0.0+s*-B+v*t)*-w+(u*0.0+H*-B+v*x)*0.0));E=0.0-((V*U+T*0.0+S*-L)*0.0+V*(V*R+Q*0.0+P*-L)+(V*N+K*0.0+J*-L)*-M)+(0.0-((B*I+p*0.0+q*-w)*0.0+B*(B*r+s*0.0+t*-w)+(B*u+H*0.0+x*-w)*-v));C=o-((V*U+T*0.0+S*-L)*-V+(V*R+Q*0.0+P*-L)*0.0+L*(V*N+K*0.0+J*-L))+(n-((B*I+p*0.0+q*-w)*-B+(B*r+s*0.0+t*-w)*0.0+w*(B*u+H*0.0+x*-w)));z=0.0-(M*(V*U+T*0.0+S*-L)+(V*R+Q*0.0+P*-L)*-L+(V*N+K*0.0+J*-L)*0.0)+(0.0-(v*(B*I+p*0.0+q*-w)+(B*r+s*0.0+t*-w)*-w+(B*u+H*0.0+x*-w)*0.0));A=0.0-((U*-M+L*T+S*0.0)*0.0+V*(R*-M+L*Q+P*0.0)+(N*-M+L*K+J*0.0)*-M)+(0.0-((I*-v+w*p+q*0.0)*0.0+B*(r*-v+w*s+t*0.0)+(u*-v+w*H+x*0.0)*-v));B=0.0-((U*-M+L*T+S*0.0)*-V+(R*-M+L*Q+P*0.0)*0.0+L*(N*-M+L*K+J*0.0))+(0.0-((I*-v+w*p+q*0.0)*-B+(r*-v+w*s+t*0.0)*0.0+w*(u*-v+w*H+x*0.0)));x=o-(M*(U*-M+L*T+S*0.0)+(R*-M+L*Q+P*0.0)*-L+(N*-M+L*K+J*0.0)*0.0)+(n-(v*(I*-v+w*p+q*0.0)+(r*-v+w*s+t*0.0)*-w+(u*-v+w*H+x*0.0)*0.0));H=1.0/(y*(B*E-C*A)+(D*(C*x-z*B)+F*(z*A-x*E)));g[m+104>>2]=(C*x-z*B)*H;g[m+108>>2]=(B*y-x*F)*H;g[m+112>>2]=(z*F-C*y)*H;g[m+116>>2]=0.0;g[m+120>>2]=(z*A-x*E)*H;g[m+124>>2]=(x*D-A*y)*H;g[m+128>>2]=(E*y-z*D)*H;g[m+132>>2]=0.0;g[m+136>>2]=(B*E-C*A)*H;g[m+140>>2]=(A*F-B*D)*H;g[m+144>>2]=(C*D-E*F)*H;g[m+148>>2]=0.0;m=1;i=G;return m|0}function kd(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0;if((a[b+180>>0]|0)==0?(a[b+48>>0]|0)!=0:0){w=+g[b+116>>2];i=+g[e>>2];x=+g[b+132>>2];C=+g[e+4>>2];y=+g[b+148>>2];D=+g[e+8>>2];l=+g[b+120>>2];n=+g[b+136>>2];p=+g[b+152>>2];q=+g[b+124>>2];s=+g[b+140>>2];t=+g[b+156>>2];j=+g[e+16>>2];m=+g[e+20>>2];o=+g[e+24>>2];r=+g[e+32>>2];z=+g[e+36>>2];A=+g[e+40>>2];h=+g[b+164>>2];f=+g[b+168>>2];v=+g[b+172>>2];u=+g[e+48>>2]+(i*h+C*f+D*v);B=j*h+m*f+o*v+ +g[e+52>>2];v=r*h+z*f+A*v+ +g[e+56>>2];g[b+824>>2]=w*i+x*C+y*D;g[b+828>>2]=i*l+C*n+D*p;g[b+832>>2]=i*q+C*s+D*t;g[b+836>>2]=0.0;g[b+840>>2]=w*j+x*m+y*o;g[b+844>>2]=l*j+n*m+p*o;g[b+848>>2]=q*j+s*m+t*o;g[b+852>>2]=0.0;g[b+856>>2]=w*r+x*z+y*A;g[b+860>>2]=l*r+n*z+p*A;g[b+864>>2]=q*r+s*z+t*A;g[b+868>>2]=0.0;g[b+872>>2]=u;g[b+876>>2]=B;g[b+880>>2]=v;g[b+884>>2]=0.0;v=+g[b+52>>2];B=+g[d>>2];u=+g[b+68>>2];A=+g[d+4>>2];t=+g[b+84>>2];z=+g[d+8>>2];s=+g[b+56>>2];r=+g[b+72>>2];q=+g[b+88>>2];p=+g[b+60>>2];n=+g[b+76>>2];l=+g[b+92>>2];y=+g[d+16>>2];x=+g[d+20>>2];w=+g[d+24>>2];o=+g[d+32>>2];m=+g[d+36>>2];j=+g[d+40>>2];D=+g[b+100>>2];C=+g[b+104>>2];i=+g[b+108>>2];f=+g[d+48>>2]+(B*D+A*C+z*i);h=y*D+x*C+w*i+ +g[d+52>>2];i=o*D+m*C+j*i+ +g[d+56>>2];g[b+888>>2]=v*B+u*A+t*z;g[b+892>>2]=B*s+A*r+z*q;g[b+896>>2]=B*p+A*n+z*l;g[b+900>>2]=0.0;g[b+904>>2]=v*y+u*x+t*w;g[b+908>>2]=s*y+r*x+q*w;g[b+912>>2]=p*y+n*x+l*w;g[b+916>>2]=0.0;g[b+920>>2]=v*o+u*m+t*j;g[b+924>>2]=s*o+r*m+q*j;g[b+928>>2]=p*o+n*m+l*j;g[b+932>>2]=0.0;g[b+936>>2]=f;g[b+940>>2]=h;g[b+944>>2]=i;g[b+948>>2]=0.0;d=b+856|0;e=b+840|0}else{o=+g[b+52>>2];D=+g[d>>2];n=+g[b+68>>2];h=+g[d+4>>2];m=+g[b+84>>2];f=+g[d+8>>2];z=+g[b+56>>2];x=+g[b+72>>2];v=+g[b+88>>2];u=+g[b+60>>2];s=+g[b+76>>2];r=+g[b+92>>2];A=+g[d+16>>2];y=+g[d+20>>2];w=+g[d+24>>2];t=+g[d+32>>2];l=+g[d+36>>2];j=+g[d+40>>2];C=+g[b+100>>2];B=+g[b+104>>2];p=+g[b+108>>2];q=+g[d+48>>2]+(D*C+h*B+f*p);i=A*C+y*B+w*p+ +g[d+52>>2];p=t*C+l*B+j*p+ +g[d+56>>2];g[b+824>>2]=o*D+n*h+m*f;g[b+828>>2]=D*z+h*x+f*v;g[b+832>>2]=D*u+h*s+f*r;g[b+836>>2]=0.0;g[b+840>>2]=o*A+n*y+m*w;g[b+844>>2]=z*A+x*y+v*w;g[b+848>>2]=u*A+s*y+r*w;g[b+852>>2]=0.0;g[b+856>>2]=o*t+n*l+m*j;g[b+860>>2]=z*t+x*l+v*j;g[b+864>>2]=u*t+s*l+r*j;g[b+868>>2]=0.0;g[b+872>>2]=q;g[b+876>>2]=i;g[b+880>>2]=p;g[b+884>>2]=0.0;p=+g[b+116>>2];i=+g[e>>2];q=+g[b+132>>2];j=+g[e+4>>2];r=+g[b+148>>2];l=+g[e+8>>2];s=+g[b+120>>2];t=+g[b+136>>2];u=+g[b+152>>2];v=+g[b+124>>2];x=+g[b+140>>2];z=+g[b+156>>2];m=+g[e+16>>2];n=+g[e+20>>2];o=+g[e+24>>2];w=+g[e+32>>2];y=+g[e+36>>2];A=+g[e+40>>2];f=+g[b+164>>2];h=+g[b+168>>2];D=+g[b+172>>2];B=+g[e+48>>2]+(i*f+j*h+l*D);C=m*f+n*h+o*D+ +g[e+52>>2];D=w*f+y*h+A*D+ +g[e+56>>2];g[b+888>>2]=p*i+q*j+r*l;g[b+892>>2]=i*s+j*t+l*u;g[b+896>>2]=i*v+j*x+l*z;g[b+900>>2]=0.0;g[b+904>>2]=p*m+q*n+r*o;g[b+908>>2]=s*m+t*n+u*o;g[b+912>>2]=v*m+x*n+z*o;g[b+916>>2]=0.0;g[b+920>>2]=p*w+q*y+r*A;g[b+924>>2]=s*w+t*y+u*A;g[b+928>>2]=v*w+x*y+z*A;g[b+932>>2]=0.0;g[b+936>>2]=B;g[b+940>>2]=C;g[b+944>>2]=D;g[b+948>>2]=0.0;d=b+856|0;e=b+840|0}c[b+968>>2]=c[b+872>>2];c[b+968+4>>2]=c[b+872+4>>2];c[b+968+8>>2]=c[b+872+8>>2];c[b+968+12>>2]=c[b+872+12>>2];c[b+984>>2]=c[b+936>>2];c[b+984+4>>2]=c[b+936+4>>2];c[b+984+8>>2]=c[b+936+8>>2];c[b+984+12>>2]=c[b+936+12>>2];F=c[b+824>>2]|0;E=c[e>>2]|0;e=c[d>>2]|0;c[b+952>>2]=F;c[b+956>>2]=E;c[b+960>>2]=e;g[b+964>>2]=0.0;f=(c[k>>2]=F,+g[k>>2]);h=(c[k>>2]=E,+g[k>>2]);i=(c[k>>2]=e,+g[k>>2]);if((a[b+180>>0]|0)==0?(a[b+48>>0]|0)==0:0){u=+g[b+968>>2];A=u-+g[b+984>>2];v=+g[b+972>>2];C=v-+g[b+988>>2];w=+g[b+976>>2];D=w-+g[b+992>>2];g[b+1016>>2]=A;g[b+1020>>2]=C;g[b+1024>>2]=D;g[b+1028>>2]=0.0;B=f*A;x=h*C;x=B+x;B=i*D;B=x+B;x=f*B;y=h*B;z=i*B;x=u+x;y=v+y;z=w+z;F=b+1e3|0;g[F>>2]=x;F=b+1004|0;g[F>>2]=y;F=b+1008|0;g[F>>2]=z;F=b+1012|0;g[F>>2]=0.0;F=b+1032|0;g[F>>2]=B;F=b+828|0;E=b+844|0;e=b+860|0;B=+g[F>>2];z=+g[E>>2];y=+g[e>>2];B=B*A;z=z*C;z=B+z;y=y*D;y=z+y;e=b+1036|0;g[e>>2]=y;e=b+832|0;E=b+848|0;F=b+864|0;y=+g[e>>2];z=+g[E>>2];B=+g[F>>2];A=y*A;C=z*C;C=A+C;D=B*D;D=C+D;F=b+1040|0;g[F>>2]=D;return}u=+g[b+968>>2];A=+g[b+984>>2]-u;v=+g[b+972>>2];C=+g[b+988>>2]-v;w=+g[b+976>>2];D=+g[b+992>>2]-w;g[b+1016>>2]=A;g[b+1020>>2]=C;g[b+1024>>2]=D;g[b+1028>>2]=0.0;B=f*A;x=h*C;x=B+x;B=i*D;B=x+B;x=f*B;y=h*B;z=i*B;x=u+x;y=v+y;z=w+z;F=b+1e3|0;g[F>>2]=x;F=b+1004|0;g[F>>2]=y;F=b+1008|0;g[F>>2]=z;F=b+1012|0;g[F>>2]=0.0;F=b+1032|0;g[F>>2]=B;F=b+828|0;E=b+844|0;e=b+860|0;B=+g[F>>2];z=+g[E>>2];y=+g[e>>2];B=B*A;z=z*C;z=B+z;y=y*D;y=z+y;e=b+1036|0;g[e>>2]=y;e=b+832|0;E=b+848|0;F=b+864|0;y=+g[e>>2];z=+g[E>>2];B=+g[F>>2];A=y*A;C=z*C;C=A+C;D=B*D;D=C+D;F=b+1040|0;g[F>>2]=D;return}function ld(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0;s=i;i=i+224|0;q=(a[b+28>>0]|0)!=0;p=q?e:d;q=q?d:e;r=c[p+4>>2]|0;if((c[r+68>>2]|0)!=(c[b+40>>2]|0)){j=c[b+12>>2]|0;if((j|0)>0){l=0;do{k=c[(c[b+20>>2]|0)+(l<<2)>>2]|0;if(k|0){Ab[c[c[k>>2]>>2]&255](k);n=c[b+4>>2]|0;Cb[c[(c[n>>2]|0)+60>>2]&127](n,c[(c[b+20>>2]|0)+(l<<2)>>2]|0)}l=l+1|0}while((l|0)!=(j|0))}lh(b,d,e)}n=c[r+64>>2]|0;j=c[b+4>>2]|0;k=c[b+20>>2]|0;m=c[b+32>>2]|0;c[s+192>>2]=6192;c[s+192+4>>2]=p;c[s+192+8>>2]=q;c[s+192+12>>2]=j;c[s+192+16>>2]=f;c[s+192+20>>2]=h;c[s+192+24>>2]=k;c[s+192+28>>2]=m;a[s+128+16>>0]=1;m=s+128+12|0;c[m>>2]=0;c[s+128+4>>2]=0;c[s+128+8>>2]=0;j=c[b+12>>2]|0;if((j|0)>0){d=k;f=0;while(1){k=c[d+(f<<2)>>2]|0;if(k){Cb[c[(c[k>>2]|0)+16>>2]&127](k,s+128|0);j=c[s+128+4>>2]|0;if((j|0)>0){l=0;do{e=c[(c[m>>2]|0)+(l<<2)>>2]|0;if(c[e+748>>2]|0){c[h+4>>2]=e;j=c[e+740>>2]|0;k=c[(c[h+8>>2]|0)+8>>2]|0;d=c[(c[h+12>>2]|0)+8>>2]|0;if((j|0)==(k|0))ef(e,j+4|0,d+4|0);else ef(e,d+4|0,k+4|0);c[h+4>>2]=0;j=c[s+128+4>>2]|0}l=l+1|0}while((l|0)<(j|0))}if((j|0)<0){if((c[s+128+8>>2]|0)<0){k=c[m>>2]|0;if(k|0){if(a[s+128+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[k+-4>>2]|0)}c[m>>2]=0}a[s+128+16>>0]=1;c[m>>2]=0;c[s+128+8>>2]=0}do{c[(c[m>>2]|0)+(j<<2)>>2]=0;j=j+1|0}while((j|0)!=0)}c[s+128+4>>2]=0;j=c[b+12>>2]|0}k=f+1|0;if((k|0)>=(j|0))break;d=c[b+20>>2]|0;f=k}j=c[m>>2]|0;if(j|0){if(a[s+128+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[m>>2]=0}}if(!n){k=c[b+12>>2]|0;if((k|0)>0){j=0;do{Te(s+192|0,c[(c[r+24>>2]|0)+(j*80|0)+64>>2]|0,j);j=j+1|0}while((j|0)<(k|0));o=38}}else{o=c[p+12>>2]|0;H=+g[o>>2];G=+g[o+16>>2];F=+g[o+32>>2];E=+g[o+4>>2];D=+g[o+20>>2];C=+g[o+36>>2];y=+g[o+8>>2];w=+g[o+24>>2];u=+g[o+40>>2];B=-+g[o+48>>2];A=-+g[o+52>>2];z=-+g[o+56>>2];o=c[q+12>>2]|0;Q=+g[o>>2];P=+g[o+16>>2];O=+g[o+32>>2];N=+g[o+4>>2];M=+g[o+20>>2];L=+g[o+36>>2];K=+g[o+8>>2];J=+g[o+24>>2];I=+g[o+40>>2];x=+g[o+48>>2];v=+g[o+52>>2];t=+g[o+56>>2];g[s+48>>2]=H*Q+G*P+F*O;g[s+48+4>>2]=H*N+G*M+F*L;g[s+48+8>>2]=H*K+G*J+F*I;g[s+48+12>>2]=0.0;g[s+48+16>>2]=E*Q+D*P+C*O;g[s+48+20>>2]=E*N+D*M+C*L;g[s+48+24>>2]=E*K+D*J+C*I;g[s+48+28>>2]=0.0;g[s+48+32>>2]=y*Q+w*P+u*O;g[s+48+36>>2]=y*N+w*M+u*L;g[s+48+40>>2]=y*K+w*J+u*I;g[s+48+44>>2]=0.0;g[s+48+48>>2]=H*B+G*A+F*z+(H*x+G*v+F*t);g[s+48+52>>2]=E*B+D*A+C*z+(E*x+D*v+C*t);g[s+48+56>>2]=y*B+w*A+u*z+(y*x+w*v+u*t);g[s+48+60>>2]=0.0;o=c[q+4>>2]|0;mc[c[(c[o>>2]|0)+8>>2]&127](o,s+48|0,s+128|0,s+112|0);c[s+16>>2]=c[s+128>>2];c[s+16+4>>2]=c[s+128+4>>2];c[s+16+8>>2]=c[s+128+8>>2];c[s+16+12>>2]=c[s+128+12>>2];c[s+16+16>>2]=c[s+112>>2];c[s+16+16+4>>2]=c[s+112+4>>2];c[s+16+16+8>>2]=c[s+112+8>>2];c[s+16+16+12>>2]=c[s+112+12>>2];bg(c[n>>2]|0,s+16|0,s+192|0);o=38}if((o|0)==38)k=c[b+12>>2]|0;if((k|0)<=0){i=s;return}d=0;do{do if(c[(c[b+20>>2]|0)+(d<<2)>>2]|0){n=c[r+24>>2]|0;o=c[n+(d*80|0)+64>>2]|0;h=c[p+12>>2]|0;w=+g[h>>2];x=+g[h+4>>2];y=+g[h+8>>2];z=+g[h+16>>2];A=+g[h+20>>2];B=+g[h+24>>2];I=+g[h+32>>2];K=+g[h+36>>2];M=+g[h+40>>2];C=+g[n+(d*80|0)>>2];D=+g[n+(d*80|0)+16>>2];E=+g[n+(d*80|0)+32>>2];F=+g[n+(d*80|0)+4>>2];G=+g[n+(d*80|0)+20>>2];H=+g[n+(d*80|0)+36>>2];J=+g[n+(d*80|0)+8>>2];L=+g[n+(d*80|0)+24>>2];N=+g[n+(d*80|0)+40>>2];u=+g[n+(d*80|0)+48>>2];v=+g[n+(d*80|0)+52>>2];Q=+g[n+(d*80|0)+56>>2];O=+g[h+48>>2]+(w*u+x*v+y*Q);P=+g[h+52>>2]+(z*u+A*v+B*Q);Q=+g[h+56>>2]+(I*u+K*v+M*Q);g[s+128>>2]=w*C+x*D+y*E;g[s+128+4>>2]=w*F+x*G+y*H;g[s+128+8>>2]=w*J+x*L+y*N;g[s+128+12>>2]=0.0;g[s+128+16>>2]=z*C+A*D+B*E;g[s+128+20>>2]=z*F+A*G+B*H;g[s+128+24>>2]=z*J+A*L+B*N;g[s+128+28>>2]=0.0;g[s+128+32>>2]=I*C+K*D+M*E;g[s+128+36>>2]=I*F+K*G+M*H;g[s+128+40>>2]=I*J+K*L+M*N;g[s+128+44>>2]=0.0;g[s+128+48>>2]=O;g[s+128+52>>2]=P;g[s+128+56>>2]=Q;g[s+128+60>>2]=0.0;mc[c[(c[o>>2]|0)+8>>2]&127](o,s+128|0,s+112|0,s+48|0);o=c[q+4>>2]|0;mc[c[(c[o>>2]|0)+8>>2]&127](o,c[q+12>>2]|0,s+16|0,s);if(!(+g[s+112>>2]>+g[s>>2])?!(+g[s+48>>2]<+g[s+16>>2]):0)j=1;else j=0;if(!(!(+g[s+112+8>>2]>+g[s+8>>2])?!(+g[s+48+8>>2]<+g[s+16+8>>2]):0))j=0;if(!(+g[s+112+4>>2]>+g[s+4>>2])?!(+g[s+48+4>>2]<+g[s+16+4>>2]|j^1):0)break;o=c[(c[b+20>>2]|0)+(d<<2)>>2]|0;Ab[c[c[o>>2]>>2]&255](o);o=c[b+4>>2]|0;Cb[c[(c[o>>2]|0)+60>>2]&127](o,c[(c[b+20>>2]|0)+(d<<2)>>2]|0);c[(c[b+20>>2]|0)+(d<<2)>>2]=0}while(0);d=d+1|0}while((d|0)<(k|0));i=s;return}function md(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,O=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0;c[b>>2]=c[a>>2];c[b+4>>2]=c[a+4>>2];c[b+8>>2]=c[a+8>>2];c[b+12>>2]=c[a+12>>2];c[b+16>>2]=c[a+16>>2];c[b+16+4>>2]=c[a+16+4>>2];c[b+16+8>>2]=c[a+16+8>>2];c[b+16+12>>2]=c[a+16+12>>2];c[b+32>>2]=c[a+32>>2];c[b+32+4>>2]=c[a+32+4>>2];c[b+32+8>>2]=c[a+32+8>>2];c[b+32+12>>2]=c[a+32+12>>2];o=+g[a+20>>2];v=+g[a+40>>2];m=+g[a+24>>2];p=+g[a+36>>2];r=+g[a+32>>2];n=+g[a+16>>2];s=+g[a>>2];q=+g[a+4>>2];t=+g[a+8>>2];u=1.0/((o*v-m*p)*s+q*(m*r-v*n)+(p*n-o*r)*t);g[d>>2]=(o*v-m*p)*u;g[d+4>>2]=(p*t-v*q)*u;g[d+8>>2]=(m*q-o*t)*u;g[d+12>>2]=0.0;g[d+16>>2]=(m*r-v*n)*u;g[d+20>>2]=(v*s-r*t)*u;g[d+24>>2]=(n*t-m*s)*u;g[d+28>>2]=0.0;g[d+32>>2]=(p*n-o*r)*u;g[d+36>>2]=(r*q-p*s)*u;g[d+40>>2]=(o*s-n*q)*u;g[d+44>>2]=0.0;a:do if(!(c[5788]|0)){e=b+20|0;f=b+36|0;h=b+8|0;i=b+24|0;j=b+40|0;k=b;l=b+4|0}else{C=(r*q-p*s)*u;D=(m*q-o*t)*u;E=(n*t-m*s)*u;F=(o*s-n*q)*u;G=(o*v-m*p)*u;B=(m*r-v*n)*u;A=(p*n-o*r)*u;z=(p*t-v*q)*u;y=(v*s-r*t)*u;e=0;while(1){n=+N(+G);m=+N(+B);L=+N(+A);W=+N(+z);M=+N(+y);K=+N(+C);Q=+N(+D);O=+N(+E);w=+N(+F);R=n+m+L>W+M+K?n+m+L:W+M+K;M=n+W+Q>m+M+O?n+W+Q:m+M+O;m=+g[b>>2];W=+N(+m);n=+g[b+16>>2];T=+N(+n);o=+g[b+32>>2];I=+N(+o);p=+g[b+4>>2];V=+N(+p);q=+g[b+20>>2];S=+N(+q);r=+g[b+36>>2];H=+N(+r);s=+g[b+8>>2];U=+N(+s);t=+g[b+24>>2];J=+N(+t);u=+g[b+40>>2];x=+N(+u);v=W+T+I>V+S+H?W+T+I:V+S+H;v=v>U+J+x?v:U+J+x;J=W+V+U>T+S+J?W+V+U:T+S+J;w=(R>Q+O+w?R:Q+O+w)*(M>L+K+w?M:L+K+w);x=v*(J>I+H+x?J:I+H+x);if(+N(+w)<1.1920928955078125e-07){e=b+20|0;f=b+36|0;h=b+8|0;i=b+24|0;j=b+40|0;k=b;l=b+4|0;break a}if(+N(+x)<1.1920928955078125e-07){e=b+20|0;f=b+36|0;h=b+8|0;i=b+24|0;j=b+40|0;k=b;l=b+4|0;break a}W=+P(+(w/x),.25);M=(m*(W+-2.0)+G*(1.0/W))*.5;Q=(p*(W+-2.0)+1.0/W*B)*.5;S=(s*(W+-2.0)+1.0/W*A)*.5;O=(n*(W+-2.0)+1.0/W*z)*.5;R=(q*(W+-2.0)+1.0/W*y)*.5;T=(t*(W+-2.0)+1.0/W*C)*.5;U=(o*(W+-2.0)+1.0/W*D)*.5;V=(r*(W+-2.0)+1.0/W*E)*.5;W=(u*(W+-2.0)+1.0/W*F)*.5;g[b>>2]=m+M;g[b+4>>2]=p+Q;g[b+8>>2]=s+S;g[b+12>>2]=0.0;g[b+16>>2]=n+O;g[b+20>>2]=q+R;g[b+24>>2]=t+T;g[b+28>>2]=0.0;g[b+32>>2]=o+U;g[b+36>>2]=r+V;g[b+40>>2]=u+W;g[b+44>>2]=0.0;L=1.0/(((u+W)*(q+R)-(t+T)*(r+V))*(m+M)+(p+Q)*((t+T)*(o+U)-(u+W)*(n+O))+((r+V)*(n+O)-(q+R)*(o+U))*(s+S));G=((u+W)*(q+R)-(t+T)*(r+V))*L;z=((r+V)*(s+S)-(u+W)*(p+Q))*L;D=((t+T)*(p+Q)-(q+R)*(s+S))*L;B=((t+T)*(o+U)-(u+W)*(n+O))*L;y=((u+W)*(m+M)-(o+U)*(s+S))*L;E=((n+O)*(s+S)-(t+T)*(m+M))*L;A=((r+V)*(n+O)-(q+R)*(o+U))*L;C=((o+U)*(p+Q)-(r+V)*(m+M))*L;F=((q+R)*(m+M)-(n+O)*(p+Q))*L;g[d>>2]=G;g[d+4>>2]=z;g[d+8>>2]=D;g[d+12>>2]=0.0;g[d+16>>2]=B;g[d+20>>2]=y;g[d+24>>2]=E;g[d+28>>2]=0.0;g[d+32>>2]=A;g[d+36>>2]=C;g[d+40>>2]=F;g[d+44>>2]=0.0;U=+N(+M)+ +N(+O)+ +N(+U);V=+N(+Q)+ +N(+R)+ +N(+V);W=+N(+S)+ +N(+T)+ +N(+W);V=U>V?U:V;if((V>W?V:W)<=v*+g[5787])break;e=e+1|0;if(e>>>0>=(c[5788]|0)>>>0){e=b+20|0;f=b+36|0;h=b+8|0;i=b+24|0;j=b+40|0;k=b;l=b+4|0;break a}}K=+g[b>>2];M=+g[b+16>>2];Q=+g[b+32>>2];F=+g[b+4>>2];H=+g[b+20>>2];J=+g[b+36>>2];A=+g[b+8>>2];C=+g[b+24>>2];E=+g[b+40>>2];L=+g[a>>2];O=+g[a+16>>2];R=+g[a+32>>2];G=+g[a+4>>2];I=+g[a+20>>2];T=+g[a+36>>2];B=+g[a+8>>2];D=+g[a+24>>2];W=+g[a+40>>2];V=A*G+C*I+E*T+(F*B+H*D+J*W);S=F*L+H*O+J*R+(K*G+M*I+Q*T);U=A*L+C*O+E*R+(K*B+M*D+Q*W);W=A*B+C*D+E*W+(A*B+C*D+E*W);T=F*G+H*I+J*T+(F*G+H*I+J*T);R=K*L+M*O+Q*R+(K*L+M*O+Q*R);S=S*.5;U=U*.5;V=V*.5;R=R*.5;g[d>>2]=R;g[d+4>>2]=S;g[d+8>>2]=U;g[d+12>>2]=0.0;g[d+16>>2]=S;T=T*.5;g[d+20>>2]=T;g[d+24>>2]=V;g[d+28>>2]=0.0;g[d+32>>2]=U;g[d+36>>2]=V;W=W*.5;g[d+40>>2]=W;g[d+44>>2]=0.0;return}while(0);K=+g[k>>2];M=+g[b+16>>2];Q=+g[b+32>>2];F=+g[l>>2];H=+g[e>>2];J=+g[f>>2];A=+g[h>>2];C=+g[i>>2];E=+g[j>>2];L=+g[a>>2];O=+g[a+16>>2];R=+g[a+32>>2];G=+g[a+4>>2];I=+g[a+20>>2];T=+g[a+36>>2];B=+g[a+8>>2];D=+g[a+24>>2];W=+g[a+40>>2];V=A*G+C*I+E*T+(F*B+H*D+J*W);S=F*L+H*O+J*R+(K*G+M*I+Q*T);U=A*L+C*O+E*R+(K*B+M*D+Q*W);W=A*B+C*D+E*W+(A*B+C*D+E*W);T=F*G+H*I+J*T+(F*G+H*I+J*T);R=K*L+M*O+Q*R+(K*L+M*O+Q*R);S=S*.5;U=U*.5;V=V*.5;R=R*.5;g[d>>2]=R;g[d+4>>2]=S;g[d+8>>2]=U;g[d+12>>2]=0.0;g[d+16>>2]=S;T=T*.5;g[d+20>>2]=T;g[d+24>>2]=V;g[d+28>>2]=0.0;g[d+32>>2]=U;g[d+36>>2]=V;W=W*.5;g[d+40>>2]=W;g[d+44>>2]=0.0;return}function nd(a,b,f,j){a=a|0;b=b|0;f=f|0;j=j|0;var k=0.0,l=0.0,m=0.0,n=0,o=0,p=0.0,q=0.0,r=0,s=0,t=0,u=0;o=i;i=i+80|0;f=Eb[c[(c[a>>2]|0)+28>>2]&127](a)|0;k=+g[a+4>>2];l=+g[a+8>>2];m=+g[a+12>>2];if((f|0)<=0){i=o;return}n=0;do{Yb[c[(c[a>>2]|0)+16>>2]&3](a,o+76|0,o+52|0,o+64|0,o+56|0,o+72|0,o+68|0,o+48|0,o+60|0,n);a:do switch(c[o+64>>2]|0){case 0:{switch(c[o+60>>2]|0){case 2:{if((c[o+48>>2]|0)>0)j=0;else break a;do{r=(c[o+72>>2]|0)+(_(c[o+68>>2]|0,j)|0)|0;t=c[o+76>>2]|0;s=c[o+56>>2]|0;u=t+(_(s,c[r>>2]|0)|0)|0;q=l*+g[u+4>>2];p=m*+g[u+8>>2];g[o>>2]=k*+g[u>>2];g[o+4>>2]=q;g[o+8>>2]=p;g[o+12>>2]=0.0;u=t+(_(s,c[r+4>>2]|0)|0)|0;p=l*+g[u+4>>2];q=m*+g[u+8>>2];g[o+16>>2]=k*+g[u>>2];g[o+20>>2]=p;g[o+24>>2]=q;g[o+28>>2]=0.0;r=t+(_(s,c[r+8>>2]|0)|0)|0;q=l*+g[r+4>>2];p=m*+g[r+8>>2];g[o+32>>2]=k*+g[r>>2];g[o+36>>2]=q;g[o+40>>2]=p;g[o+44>>2]=0.0;mc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,j);j=j+1|0}while((j|0)<(c[o+48>>2]|0));break}case 3:{if((c[o+48>>2]|0)>0)j=0;else break a;do{t=(c[o+72>>2]|0)+(_(c[o+68>>2]|0,j)|0)|0;s=c[o+76>>2]|0;u=c[o+56>>2]|0;r=s+(_(e[t>>1]|0,u)|0)|0;p=l*+g[r+4>>2];q=m*+g[r+8>>2];g[o>>2]=k*+g[r>>2];g[o+4>>2]=p;g[o+8>>2]=q;g[o+12>>2]=0.0;r=s+(_(e[t+2>>1]|0,u)|0)|0;q=l*+g[r+4>>2];p=m*+g[r+8>>2];g[o+16>>2]=k*+g[r>>2];g[o+20>>2]=q;g[o+24>>2]=p;g[o+28>>2]=0.0;u=s+(_(e[t+4>>1]|0,u)|0)|0;p=l*+g[u+4>>2];q=m*+g[u+8>>2];g[o+32>>2]=k*+g[u>>2];g[o+36>>2]=p;g[o+40>>2]=q;g[o+44>>2]=0.0;mc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,j);j=j+1|0}while((j|0)<(c[o+48>>2]|0));break}case 5:{if((c[o+48>>2]|0)>0)j=0;else break a;do{t=(c[o+72>>2]|0)+(_(c[o+68>>2]|0,j)|0)|0;s=c[o+76>>2]|0;u=c[o+56>>2]|0;r=s+(_(d[t>>0]|0,u)|0)|0;p=l*+g[r+4>>2];q=m*+g[r+8>>2];g[o>>2]=k*+g[r>>2];g[o+4>>2]=p;g[o+8>>2]=q;g[o+12>>2]=0.0;r=s+(_(d[t+1>>0]|0,u)|0)|0;q=l*+g[r+4>>2];p=m*+g[r+8>>2];g[o+16>>2]=k*+g[r>>2];g[o+20>>2]=q;g[o+24>>2]=p;g[o+28>>2]=0.0;u=s+(_(d[t+2>>0]|0,u)|0)|0;p=l*+g[u+4>>2];q=m*+g[u+8>>2];g[o+32>>2]=k*+g[u>>2];g[o+36>>2]=p;g[o+40>>2]=q;g[o+44>>2]=0.0;mc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,j);j=j+1|0}while((j|0)<(c[o+48>>2]|0));break}default:break a}break}case 1:{switch(c[o+60>>2]|0){case 2:{if((c[o+48>>2]|0)>0)j=0;else break a;do{u=(c[o+72>>2]|0)+(_(c[o+68>>2]|0,j)|0)|0;s=c[o+76>>2]|0;t=c[o+56>>2]|0;r=s+(_(t,c[u>>2]|0)|0)|0;p=l*+h[r+8>>3];q=m*+h[r+16>>3];g[o>>2]=k*+h[r>>3];g[o+4>>2]=p;g[o+8>>2]=q;g[o+12>>2]=0.0;r=s+(_(t,c[u+4>>2]|0)|0)|0;q=l*+h[r+8>>3];p=m*+h[r+16>>3];g[o+16>>2]=k*+h[r>>3];g[o+20>>2]=q;g[o+24>>2]=p;g[o+28>>2]=0.0;u=s+(_(t,c[u+8>>2]|0)|0)|0;p=l*+h[u+8>>3];q=m*+h[u+16>>3];g[o+32>>2]=k*+h[u>>3];g[o+36>>2]=p;g[o+40>>2]=q;g[o+44>>2]=0.0;mc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,j);j=j+1|0}while((j|0)<(c[o+48>>2]|0));break}case 3:{if((c[o+48>>2]|0)>0)j=0;else break a;do{t=(c[o+72>>2]|0)+(_(c[o+68>>2]|0,j)|0)|0;s=c[o+76>>2]|0;u=c[o+56>>2]|0;r=s+(_(e[t>>1]|0,u)|0)|0;p=l*+h[r+8>>3];q=m*+h[r+16>>3];g[o>>2]=k*+h[r>>3];g[o+4>>2]=p;g[o+8>>2]=q;g[o+12>>2]=0.0;r=s+(_(e[t+2>>1]|0,u)|0)|0;q=l*+h[r+8>>3];p=m*+h[r+16>>3];g[o+16>>2]=k*+h[r>>3];g[o+20>>2]=q;g[o+24>>2]=p;g[o+28>>2]=0.0;u=s+(_(e[t+4>>1]|0,u)|0)|0;p=l*+h[u+8>>3];q=m*+h[u+16>>3];g[o+32>>2]=k*+h[u>>3];g[o+36>>2]=p;g[o+40>>2]=q;g[o+44>>2]=0.0;mc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,j);j=j+1|0}while((j|0)<(c[o+48>>2]|0));break}case 5:{if((c[o+48>>2]|0)>0)j=0;else break a;do{t=(c[o+72>>2]|0)+(_(c[o+68>>2]|0,j)|0)|0;s=c[o+76>>2]|0;u=c[o+56>>2]|0;r=s+(_(d[t>>0]|0,u)|0)|0;p=l*+h[r+8>>3];q=m*+h[r+16>>3];g[o>>2]=k*+h[r>>3];g[o+4>>2]=p;g[o+8>>2]=q;g[o+12>>2]=0.0;r=s+(_(d[t+1>>0]|0,u)|0)|0;q=l*+h[r+8>>3];p=m*+h[r+16>>3];g[o+16>>2]=k*+h[r>>3];g[o+20>>2]=q;g[o+24>>2]=p;g[o+28>>2]=0.0;u=s+(_(d[t+2>>0]|0,u)|0)|0;p=l*+h[u+8>>3];q=m*+h[u+16>>3];g[o+32>>2]=k*+h[u>>3];g[o+36>>2]=p;g[o+40>>2]=q;g[o+44>>2]=0.0;mc[c[(c[b>>2]|0)+8>>2]&127](b,o,n,j);j=j+1|0}while((j|0)<(c[o+48>>2]|0));break}default:break a}break}default:{}}while(0);Cb[c[(c[a>>2]|0)+24>>2]&127](a,n);n=n+1|0}while((n|0)!=(f|0));i=o;return}function od(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0,ga=0.0;fa=i;i=i+128|0;K=c[b+4>>2]|0;a[K+312>>0]=0;c[K>>2]=0;a[K+356>>0]=1;c[K+292>>2]=1566444395;c[K+296>>2]=1566444395;c[K+300>>2]=1566444395;g[K+304>>2]=0.0;c[K+336>>2]=0;c[K+336+4>>2]=0;c[K+336+8>>2]=0;c[K+336+12>>2]=0;a[K+336+16>>0]=0;a[K+332>>0]=a[K+332>>0]&-16;m=+g[d+48>>2];n=+g[d+52>>2];o=+g[d+56>>2];p=+g[f+48>>2];u=+g[f+52>>2];v=+g[f+56>>2];L=+g[d>>2];M=+g[d+4>>2];N=+g[d+8>>2];P=+g[d+16>>2];Q=+g[d+20>>2];R=+g[d+24>>2];S=+g[d+32>>2];T=+g[d+36>>2];U=+g[d+40>>2];V=+g[f>>2];W=+g[f+4>>2];X=+g[f+8>>2];Y=+g[f+16>>2];Z=+g[f+20>>2];_=+g[f+24>>2];$=+g[f+32>>2];aa=+g[f+36>>2];ba=+g[f+40>>2];ca=+g[e+48>>2]-m-(+g[h+48>>2]-p);da=+g[e+52>>2]-n-(+g[h+52>>2]-u);ea=+g[e+56>>2]-o-(+g[h+56>>2]-v);K=c[b+8>>2]|0;B=c[(c[K>>2]|0)+64>>2]|0;g[fa+96>>2]=L*-ca+P*-da+S*-ea;g[fa+96+4>>2]=M*-ca+Q*-da+T*-ea;g[fa+96+8>>2]=N*-ca+R*-da+U*-ea;g[fa+96+12>>2]=0.0;ic[B&127](fa+112|0,K,fa+96|0);I=+g[fa+112>>2];J=+g[fa+112+4>>2];H=+g[fa+112+8>>2];w=I*+g[d>>2]+J*+g[d+4>>2]+H*+g[d+8>>2]+ +g[d+48>>2];z=I*+g[d+16>>2]+J*+g[d+20>>2]+H*+g[d+24>>2]+ +g[d+52>>2];H=I*+g[d+32>>2]+J*+g[d+36>>2]+H*+g[d+40>>2]+ +g[d+56>>2];K=c[b+12>>2]|0;B=c[(c[K>>2]|0)+64>>2]|0;J=ca*+g[f+4>>2]+da*+g[f+20>>2]+ea*+g[f+36>>2];I=ca*+g[f+8>>2]+da*+g[f+24>>2]+ea*+g[f+40>>2];g[fa+64>>2]=ca*+g[f>>2]+da*+g[f+16>>2]+ea*+g[f+32>>2];g[fa+64+4>>2]=J;g[fa+64+8>>2]=I;g[fa+64+12>>2]=0.0;ic[B&127](fa+80|0,K,fa+64|0);I=+g[fa+80>>2];J=+g[fa+80+4>>2];x=+g[fa+80+8>>2];w=w-(I*+g[f>>2]+J*+g[f+4>>2]+x*+g[f+8>>2]+ +g[f+48>>2]);z=z-(I*+g[f+16>>2]+J*+g[f+20>>2]+x*+g[f+24>>2]+ +g[f+52>>2]);x=H-(I*+g[f+32>>2]+J*+g[f+36>>2]+x*+g[f+40>>2]+ +g[f+56>>2]);a:do if(w*w+z*z+x*x>9.999999747378752e-05){D=m;m=0.0;K=32;s=0;t=0;r=0;l=0;A=0;while(1){if(!K)break a;K=K+-1|0;q=c[b+8>>2]|0;y=c[(c[q>>2]|0)+64>>2]|0;G=-w;ga=-z;C=-x;g[fa+32>>2]=L*G+P*ga+S*C;g[fa+32+4>>2]=M*G+Q*ga+T*C;g[fa+32+8>>2]=N*G+R*ga+U*C;g[fa+32+12>>2]=0.0;ic[y&127](fa+48|0,q,fa+32|0);C=+g[fa+48>>2];ga=+g[fa+48+4>>2];G=+g[fa+48+8>>2];E=D+(L*C+M*ga+N*G);F=n+(P*C+Q*ga+R*G);G=o+(S*C+T*ga+U*G);q=c[b+12>>2]|0;y=c[(c[q>>2]|0)+64>>2]|0;g[fa>>2]=V*w+Y*z+$*x;g[fa+4>>2]=W*w+Z*z+aa*x;g[fa+8>>2]=X*w+_*z+ba*x;g[fa+12>>2]=0.0;ic[y&127](fa+16|0,q,fa);ga=+g[fa+16>>2];C=+g[fa+16+4>>2];J=+g[fa+16+8>>2];H=p+(V*ga+W*C+X*J);I=u+(Y*ga+Z*C+_*J);J=v+($*ga+aa*C+ba*J);C=w*(E-H)+z*(F-I)+x*(G-J);q=(g[k>>2]=w,c[k>>2]|0);y=(g[k>>2]=z,c[k>>2]|0);B=(g[k>>2]=x,c[k>>2]|0);if(m>1.0){l=0;q=24;break}if(C>0.0){n=ca*w+da*z+ea*x;if(n>=-1.4210854715202004e-14){l=0;q=24;break}m=m-C/n;C=(1.0-m)*+g[d+48>>2]+m*+g[e+48>>2];n=(1.0-m)*+g[d+52>>2]+m*+g[e+52>>2];o=(1.0-m)*+g[d+56>>2]+m*+g[e+56>>2];p=(1.0-m)*+g[f+48>>2]+m*+g[h+48>>2];u=(1.0-m)*+g[f+52>>2]+m*+g[h+52>>2];v=(1.0-m)*+g[f+56>>2]+m*+g[h+56>>2];s=q;t=A;r=y;l=B}else C=D;A=c[b+4>>2]|0;B=c[A>>2]|0;if((B|0)>0){w=+g[A+308>>2];y=0;q=0;do{z=E-H-+g[A+4+(q<<4)>>2];D=F-I-+g[A+4+(q<<4)+4>>2];ga=G-J-+g[A+4+(q<<4)+8>>2];y=y|z*z+D*D+ga*ga<=w;q=q+1|0}while((q|0)!=(B|0))}else y=0;if((+g[A+304>>2]==0.0?G-J==+g[A+300>>2]:0)?F-I==+g[A+296>>2]:0)q=E-H==+g[A+292>>2];else q=0;if(!(y|q)){g[A+292>>2]=E-H;g[A+296>>2]=F-I;g[A+300>>2]=G-J;g[A+304>>2]=0.0;a[A+356>>0]=1;g[A+4+(B<<4)>>2]=E-H;g[A+4+(B<<4)+4>>2]=F-I;g[A+4+(B<<4)+8>>2]=G-J;g[A+4+(B<<4)+12>>2]=0.0;B=c[A>>2]|0;g[A+84+(B<<4)>>2]=E;g[A+84+(B<<4)+4>>2]=F;g[A+84+(B<<4)+8>>2]=G;g[A+84+(B<<4)+12>>2]=0.0;B=c[A>>2]|0;g[A+164+(B<<4)>>2]=H;g[A+164+(B<<4)+4>>2]=I;g[A+164+(B<<4)+8>>2]=J;g[A+164+(B<<4)+12>>2]=0.0;c[A>>2]=(c[A>>2]|0)+1;A=c[b+4>>2]|0}B=Ec(A)|0;w=+g[A+276>>2];z=+g[A+280>>2];x=+g[A+284>>2];if(!B)break a;if(!(w*w+z*z+x*x>9.999999747378752e-05))break a;else{D=C;A=c[A+288>>2]|0}}if((q|0)==24){i=fa;return l|0}}else{m=0.0;s=0;t=0;r=0;l=0}while(0);g[j+164>>2]=m;m=(c[k>>2]=s,+g[k>>2]);n=(c[k>>2]=r,+g[k>>2]);p=(c[k>>2]=l,+g[k>>2]);if(!(m*m+n*n+p*p>=1.4210854715202004e-14)){c[j+132>>2]=0;c[j+132+4>>2]=0;c[j+132+8>>2]=0;c[j+132+12>>2]=0;o=0.0;n=0.0;m=0.0}else{ga=1.0/+O(+(m*m+n*n+p*p));g[j+132>>2]=m*ga;g[j+136>>2]=n*ga;g[j+140>>2]=p*ga;c[j+144>>2]=t;o=m*ga;n=n*ga;m=p*ga}if(ca*o+da*n+ea*m>=-+g[j+172>>2]){b=0;i=fa;return b|0}b=c[b+4>>2]|0;Ec(b)|0;Bp(j+148|0,b+260|0,16)|0;b=1;i=fa;return b|0}function pd(d,e,f,h,j){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0.0,l=0.0,m=0,n=0,o=0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0;A=i;i=i+160|0;a[d+60>>0]=f&1;if(f){r=+g[h>>2]+-1.0;u=+g[h+4>>2]+-1.0;s=+g[h+8>>2]+-1.0;g[d+4>>2]=r;g[d+8>>2]=u;g[d+12>>2]=s;g[d+16>>2]=0.0;v=+g[j>>2]+1.0;x=+g[j+4>>2]+1.0;y=+g[j+8>>2]+1.0;g[d+20>>2]=v;g[d+24>>2]=x;g[d+28>>2]=y;g[d+32>>2]=0.0;g[d+36>>2]=65533.0/(v-r);g[d+40>>2]=65533.0/(x-u);g[d+44>>2]=65533.0/(y-s);g[d+48>>2]=0.0;a[d+60>>0]=1;k=r+ +(~~((r-r)*(65533.0/(v-r)))&65534)/(65533.0/(v-r))+-1.0;l=u+ +(~~((u-u)*(65533.0/(x-u)))&65534)/(65533.0/(x-u))+-1.0;p=s+ +(~~((s-s)*(65533.0/(y-s)))&65534)/(65533.0/(y-s))+-1.0;if(k<r){g[d+4>>2]=k;z=k}else z=r;if(l<u){g[d+8>>2]=l;w=l}else w=u;if(p<s){g[d+12>>2]=p;t=p}else t=s;p=z+ +((~~((v-z)*(65533.0/(v-r))+1.0)&65535|1)&65535)/(65533.0/(v-r))+1.0;l=w+ +((~~((x-w)*(65533.0/(x-u))+1.0)&65535|1)&65535)/(65533.0/(x-u))+1.0;k=t+ +((~~((y-t)*(65533.0/(y-s))+1.0)&65535|1)&65535)/(65533.0/(y-s))+1.0;if(v<p)g[d+20>>2]=p;else p=v;if(x<l)g[d+24>>2]=l;else l=x;if(y<k)g[d+28>>2]=k;else k=y;g[d+36>>2]=65533.0/(p-z);g[d+40>>2]=65533.0/(l-w);g[d+44>>2]=65533.0/(k-t);g[d+48>>2]=0.0;c[A+144>>2]=8020;c[A+144+4>>2]=d+104;c[A+144+8>>2]=d;mc[c[(c[e>>2]|0)+8>>2]&127](e,A+144|0,d+4|0,d+20|0);f=c[d+108>>2]|0;c[A+128>>2]=0;c[A+128+4>>2]=0;c[A+128+8>>2]=0;c[A+128+12>>2]=0;m=c[d+128>>2]|0;if((m|0)<(f<<1|0)){if((c[d+132>>2]|0)<(f<<1|0)){if(!f){h=0;j=m}else{c[6435]=(c[6435]|0)+1;h=yc(f<<5|19)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}j=c[d+128>>2]|0}if((j|0)>0){e=0;do{q=h+(e<<4)|0;o=(c[d+136>>2]|0)+(e<<4)|0;c[q>>2]=c[o>>2];c[q+4>>2]=c[o+4>>2];c[q+8>>2]=c[o+8>>2];c[q+12>>2]=c[o+12>>2];e=e+1|0}while((e|0)!=(j|0))}j=c[d+136>>2]|0;if(j|0){if(a[d+140>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=h;c[d+132>>2]=f<<1;j=d+136|0}else j=d+136|0;h=m;do{q=(c[j>>2]|0)+(h<<4)|0;c[q>>2]=c[A+128>>2];c[q+4>>2]=c[A+128+4>>2];c[q+8>>2]=c[A+128+8>>2];c[q+12>>2]=c[A+128+12>>2];h=h+1|0}while((h|0)!=(f<<1|0))}c[d+128>>2]=f<<1}else{c[A+144>>2]=8040;c[A+144+4>>2]=d+64;c[A+112>>2]=-581039253;c[A+112+4>>2]=-581039253;c[A+112+8>>2]=-581039253;g[A+112+12>>2]=0.0;c[A+96>>2]=1566444395;c[A+96+4>>2]=1566444395;c[A+96+8>>2]=1566444395;g[A+96+12>>2]=0.0;mc[c[(c[e>>2]|0)+8>>2]&127](e,A+144|0,A+112|0,A+96|0);f=c[d+68>>2]|0;m=A+32|0;o=m+64|0;do{c[m>>2]=0;m=m+4|0}while((m|0)<(o|0));q=c[d+88>>2]|0;if((q|0)<(f<<1|0)){if((c[d+92>>2]|0)<(f<<1|0)){if(!f){h=0;j=q}else{c[6435]=(c[6435]|0)+1;h=yc(f<<7|19)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}j=c[d+88>>2]|0}if((j|0)>0){e=0;do{m=h+(e<<6)|0;n=(c[d+96>>2]|0)+(e<<6)|0;o=m+64|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));e=e+1|0}while((e|0)!=(j|0))}j=c[d+96>>2]|0;if(j|0){if(a[d+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=h;c[d+92>>2]=f<<1;j=d+96|0}else j=d+96|0;h=q;do{m=(c[j>>2]|0)+(h<<6)|0;n=A+32|0;o=m+64|0;do{c[m>>2]=c[n>>2];m=m+4|0;n=n+4|0}while((m|0)<(o|0));h=h+1|0}while((h|0)!=(f<<1|0))}c[d+88>>2]=f<<1}c[d+56>>2]=0;Lc(d,0,f);if(a[d+60>>0]|0?(c[d+152>>2]|0)==0:0){if(!(c[d+156>>2]|0)){c[6435]=(c[6435]|0)+1;f=yc(51)|0;if(!f)e=0;else{c[(f+4+15&-16)+-4>>2]=f;e=f+4+15&-16}f=c[d+152>>2]|0;if((f|0)>0){h=0;do{q=e+(h<<5)|0;o=(c[d+160>>2]|0)+(h<<5)|0;c[q>>2]=c[o>>2];c[q+4>>2]=c[o+4>>2];c[q+8>>2]=c[o+8>>2];c[q+12>>2]=c[o+12>>2];c[q+16>>2]=c[o+16>>2];c[q+20>>2]=c[o+20>>2];c[q+24>>2]=c[o+24>>2];c[q+28>>2]=c[o+28>>2];h=h+1|0}while((h|0)!=(f|0))}f=c[d+160>>2]|0;if(f|0){if(a[d+164>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=e;c[d+156>>2]=1;h=d+160|0;j=(c[d+152>>2]|0)+1|0;f=e}else{h=d+160|0;j=1;f=c[d+160>>2]|0}c[d+152>>2]=j;c[f>>2]=c[A>>2];c[f+4>>2]=c[A+4>>2];c[f+8>>2]=c[A+8>>2];c[f+12>>2]=c[A+12>>2];c[f+16>>2]=c[A+16>>2];c[f+20>>2]=c[A+20>>2];c[f+24>>2]=c[A+24>>2];c[f+28>>2]=c[A+28>>2];q=c[h>>2]|0;o=c[d+136>>2]|0;b[q>>1]=b[o>>1]|0;b[q+2>>1]=b[o+2>>1]|0;b[q+4>>1]=b[o+4>>1]|0;b[q+6>>1]=b[o+6>>1]|0;b[q+8>>1]=b[o+8>>1]|0;b[q+10>>1]=b[o+10>>1]|0;c[q+12>>2]=0;o=c[o+12>>2]|0;c[q+16>>2]=(o|0)>-1?1:0-o|0}c[d+168>>2]=c[d+152>>2];f=c[d+116>>2]|0;if(f|0){if(a[d+120>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[d+116>>2]=0}a[d+120>>0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;f=c[d+76>>2]|0;if(!f){a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;d=d+72|0;c[d>>2]=0;i=A;return}if(a[d+80>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[d+76>>2]=0;a[d+80>>0]=1;c[d+76>>2]=0;c[d+68>>2]=0;d=d+72|0;c[d>>2]=0;i=A;return}function qd(b,d,e,f,h,i,j,l,m,n,o){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;l=l|0;m=+m;n=+n;o=+o;var p=0,q=0,r=0,s=0.0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0,N=0,O=0.0,P=0.0,Q=0.0,R=0.0;N=c[b+68>>2]|0;if((N|0)==(c[b+72>>2]|0)?(t=N|0?N<<1:1,(N|0)<(t|0)):0){if(!t){p=0;q=N}else{c[6435]=(c[6435]|0)+1;p=yc((t*152|3)+16|0)|0;if(!p)p=0;else{c[(p+4+15&-16)+-4>>2]=p;p=p+4+15&-16}q=c[b+68>>2]|0}if((q|0)>0){r=0;do{_m(p+(r*152|0)|0,(c[b+76>>2]|0)+(r*152|0)|0,152)|0;r=r+1|0}while((r|0)!=(q|0))}q=c[b+76>>2]|0;if(q|0){if(a[b+80>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[q+-4>>2]|0)}c[b+76>>2]=0}a[b+80>>0]=1;c[b+76>>2]=p;c[b+72>>2]=t;p=c[b+68>>2]|0}else p=N;c[b+68>>2]=p+1;M=c[b+76>>2]|0;c[M+(N*152|0)+140>>2]=h;r=c[b+16>>2]|0;p=c[r+(e*244|0)+240>>2]|0;t=c[r+(f*244|0)+240>>2]|0;c[M+(N*152|0)+144>>2]=e;c[M+(N*152|0)+148>>2]=f;q=c[i+84>>2]|0;c[M+(N*152|0)+104>>2]=q;c[M+(N*152|0)+132>>2]=0;g[M+(N*152|0)+100>>2]=0.0;g[M+(N*152|0)+96>>2]=0.0;L=(c[k>>2]=q,+g[k>>2]);if(p|0){c[M+(N*152|0)+16>>2]=c[d>>2];c[M+(N*152|0)+16+4>>2]=c[d+4>>2];c[M+(N*152|0)+16+8>>2]=c[d+8>>2];c[M+(N*152|0)+16+12>>2]=c[d+12>>2];K=+g[j+4>>2];D=+g[M+(N*152|0)+24>>2];H=+g[j+8>>2];I=+g[M+(N*152|0)+20>>2];E=+g[M+(N*152|0)+16>>2];J=+g[j>>2];g[M+(N*152|0)>>2]=K*D-H*I;g[M+(N*152|0)+4>>2]=H*E-D*J;g[M+(N*152|0)+8>>2]=I*J-K*E;g[M+(N*152|0)+12>>2]=0.0;v=((K*D-H*I)*+g[p+264>>2]+(H*E-D*J)*+g[p+268>>2]+(I*J-K*E)*+g[p+272>>2])*+g[p+544>>2];s=((K*D-H*I)*+g[p+280>>2]+(H*E-D*J)*+g[p+284>>2]+(I*J-K*E)*+g[p+288>>2])*+g[p+548>>2];u=((K*D-H*I)*+g[p+296>>2]+(H*E-D*J)*+g[p+300>>2]+(I*J-K*E)*+g[p+304>>2])*+g[p+552>>2];g[M+(N*152|0)+64>>2]=v;g[M+(N*152|0)+68>>2]=s;g[M+(N*152|0)+72>>2]=u;g[M+(N*152|0)+76>>2]=0.0;z=E;A=I;B=D;C=K*D-H*I;D=H*E-D*J;E=I*J-K*E}else{c[M+(N*152|0)+64>>2]=0;c[M+(N*152|0)+64+4>>2]=0;c[M+(N*152|0)+64+8>>2]=0;c[M+(N*152|0)+64+12>>2]=0;c[M+(N*152|0)>>2]=0;c[M+(N*152|0)+4>>2]=0;c[M+(N*152|0)+8>>2]=0;c[M+(N*152|0)+12>>2]=0;c[M+(N*152|0)+16>>2]=0;c[M+(N*152|0)+20>>2]=0;c[M+(N*152|0)+24>>2]=0;c[M+(N*152|0)+28>>2]=0;s=0.0;u=0.0;v=0.0;z=0.0;A=0.0;B=0.0;C=0.0;D=0.0;E=0.0}if(t|0){K=-+g[d>>2];P=-+g[d+4>>2];J=-+g[d+8>>2];g[M+(N*152|0)+48>>2]=K;g[M+(N*152|0)+52>>2]=P;g[M+(N*152|0)+56>>2]=J;g[M+(N*152|0)+60>>2]=0.0;O=+g[l+4>>2];R=+g[l+8>>2];Q=+g[l>>2];g[M+(N*152|0)+32>>2]=O*J-R*P;g[M+(N*152|0)+36>>2]=R*K-Q*J;g[M+(N*152|0)+40>>2]=Q*P-O*K;g[M+(N*152|0)+44>>2]=0.0;w=((O*J-R*P)*+g[t+264>>2]+(R*K-Q*J)*+g[t+268>>2]+(Q*P-O*K)*+g[t+272>>2])*+g[t+544>>2];x=((O*J-R*P)*+g[t+280>>2]+(R*K-Q*J)*+g[t+284>>2]+(Q*P-O*K)*+g[t+288>>2])*+g[t+548>>2];y=((O*J-R*P)*+g[t+296>>2]+(R*K-Q*J)*+g[t+300>>2]+(Q*P-O*K)*+g[t+304>>2])*+g[t+552>>2];g[M+(N*152|0)+80>>2]=w;g[M+(N*152|0)+84>>2]=x;g[M+(N*152|0)+88>>2]=y;g[M+(N*152|0)+92>>2]=0.0;F=K;G=P;H=J;I=O*J-R*P;J=R*K-Q*J;K=Q*P-O*K}else{c[M+(N*152|0)+80>>2]=0;c[M+(N*152|0)+80+4>>2]=0;c[M+(N*152|0)+80+8>>2]=0;c[M+(N*152|0)+80+12>>2]=0;c[M+(N*152|0)+32>>2]=0;c[M+(N*152|0)+32+4>>2]=0;c[M+(N*152|0)+32+8>>2]=0;c[M+(N*152|0)+32+12>>2]=0;c[M+(N*152|0)+32+16>>2]=0;c[M+(N*152|0)+32+20>>2]=0;c[M+(N*152|0)+32+24>>2]=0;c[M+(N*152|0)+32+28>>2]=0;w=0.0;x=0.0;y=0.0;F=0.0;G=0.0;H=0.0;I=0.0;J=0.0;K=0.0}if(p|0){P=+g[j+8>>2];Q=+g[j+4>>2];R=+g[j>>2];u=+g[p+344>>2]+((s*P-u*Q)*+g[d>>2]+(u*R-P*v)*+g[d+4>>2]+(Q*v-s*R)*+g[d+8>>2])}else u=0.0;if(t|0){Q=-w;s=-x;y=-y;O=+g[l+8>>2];P=+g[l+4>>2];R=+g[l>>2];s=+g[t+344>>2]+((O*s-P*y)*+g[d>>2]+(R*y-O*Q)*+g[d+4>>2]+(P*Q-R*s)*+g[d+8>>2])}else s=0.0;x=m/(u+s);g[M+(N*152|0)+108>>2]=x;if(p|0){u=+g[r+(e*244|0)+192>>2];v=+g[r+(e*244|0)+196>>2];w=+g[r+(e*244|0)+200>>2];s=(+g[r+(e*244|0)+176>>2]+ +g[r+(e*244|0)+208>>2])*z+(+g[r+(e*244|0)+180>>2]+ +g[r+(e*244|0)+212>>2])*A+(+g[r+(e*244|0)+184>>2]+ +g[r+(e*244|0)+216>>2])*B}else{u=0.0;v=0.0;w=0.0;s=z*0.0+A*0.0+B*0.0}s=s+(u*C+v*D+w*E);if(t|0){O=+g[r+(f*244|0)+192>>2];P=+g[r+(f*244|0)+196>>2];R=+g[r+(f*244|0)+200>>2];Q=(+g[r+(f*244|0)+176>>2]+ +g[r+(f*244|0)+208>>2])*F+(+g[r+(f*244|0)+180>>2]+ +g[r+(f*244|0)+212>>2])*G+(+g[r+(f*244|0)+184>>2]+ +g[r+(f*244|0)+216>>2])*H;O=O*I;P=P*J;P=O+P;R=R*K;R=P+R;R=Q+R;R=s+R;R=n-R;R=x*R;f=M+(N*152|0)+112|0;g[f>>2]=R;f=M+(N*152|0)+116|0;g[f>>2]=o;R=-L;f=M+(N*152|0)+120|0;g[f>>2]=R;f=M+(N*152|0)+124|0;c[f>>2]=q;return}else{O=0.0;P=0.0;R=0.0;Q=F*0.0+G*0.0+H*0.0;O=O*I;P=P*J;P=O+P;R=R*K;R=P+R;R=Q+R;R=s+R;R=n-R;R=x*R;f=M+(N*152|0)+112|0;g[f>>2]=R;f=M+(N*152|0)+116|0;g[f>>2]=o;R=-L;f=M+(N*152|0)+120|0;g[f>>2]=R;f=M+(N*152|0)+124|0;c[f>>2]=q;return}}function rd(b,d){b=b|0;d=+d;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0.0,F=0.0;C=i;i=i+64|0;e=c[b+136>>2]|0;if((e|0)>0){f=0;do{Ae(c[b+116>>2]|0,c[b+144>>2]|0,f,0);f=f+1|0;e=c[b+136>>2]|0}while((f|0)<(e|0))}f=c[b+116>>2]|0;t=+g[f+312>>2];u=+g[f+316>>2];h=+g[f+320>>2];h=+O(+(t*t+u*u+h*h))*3.5999999046325684;g[b+112>>2]=h;B=c[b+128>>2]|0;if(+g[f+4+(B<<2)>>2]*+g[f+312>>2]+ +g[f+20+(B<<2)>>2]*+g[f+316>>2]+ +g[f+36+(B<<2)>>2]*+g[f+320>>2]<0.0)g[b+112>>2]=-h;if((e|0)>0){B=0;do{A=c[b+144>>2]|0;p=A+(B*284|0)|0;Tg(f,p,0);o=A+(B*284|0)+204|0;e=A+(B*284|0)+212|0;h=+g[o>>2]+ +g[e>>2];q=A+(B*284|0)+52|0;v=A+(B*284|0)+56|0;w=A+(B*284|0)+60|0;D=A+(B*284|0)+36|0;x=A+(B*284|0)+16|0;t=h*+g[v>>2]+ +g[A+(B*284|0)+40>>2];u=h*+g[w>>2]+ +g[A+(B*284|0)+44>>2];g[A+(B*284|0)+16>>2]=+g[q>>2]*h+ +g[D>>2];y=A+(B*284|0)+20|0;g[y>>2]=t;z=A+(B*284|0)+24|0;g[z>>2]=u;g[A+(B*284|0)+28>>2]=0.0;g[C+32>>2]=-1.0;f=c[b+100>>2]|0;D=Ib[c[(c[f>>2]|0)+8>>2]&31](f,D,x,C)|0;f=A+(B*284|0)+88|0;c[f>>2]=0;do if(D){h=h*+g[C+32>>2];c[p>>2]=c[C+16>>2];c[p+4>>2]=c[C+16+4>>2];c[p+8>>2]=c[C+16+8>>2];c[p+12>>2]=c[C+16+12>>2];a[A+(B*284|0)+84>>0]=1;if((a[22552]|0)==0?Wa(22552)|0:0){c[C+40>>2]=0;c[C+40+4>>2]=0;c[C+40+8>>2]=0;c[C+40+12>>2]=0;og(23888,0.0,0,0,C+40|0);_a(22552)}c[6023]=c[6023]|1;g[6058]=0.0;j=+g[6068]*0.0;k=+g[6069]*0.0;g[6063]=+g[6067]*0.0;g[6064]=j;g[6065]=k;g[6066]=0.0;c[6071]=0;c[6072]=0;c[6073]=0;c[6074]=0;k=+g[6060]*0.0;j=+g[6061]*0.0;g[6112]=+g[6059]*0.0;g[6113]=k;g[6114]=j;g[6115]=0.0;c[f>>2]=23888;h=h-+g[e>>2];e=A+(B*284|0)+32|0;g[e>>2]=h;j=+g[o>>2];k=+g[A+(B*284|0)+208>>2]*.009999999776482582;if(h<j-k){g[e>>2]=j-k;h=j-k}if(h>j+k)g[e>>2]=j+k;c[x>>2]=c[C>>2];c[x+4>>2]=c[C+4>>2];c[x+8>>2]=c[C+8>>2];c[x+12>>2]=c[C+12>>2];s=+g[p>>2];t=+g[A+(B*284|0)+4>>2];u=+g[A+(B*284|0)+8>>2];r=s*+g[q>>2]+t*+g[v>>2]+u*+g[w>>2];e=c[b+116>>2]|0;n=+g[x>>2]-+g[e+52>>2];m=+g[y>>2]-+g[e+56>>2];h=+g[z>>2]-+g[e+60>>2];j=+g[e+332>>2];k=+g[e+336>>2];l=+g[e+328>>2];if(!(r>=-.10000000149011612)){g[A+(B*284|0)+272>>2]=-1.0/r*(s*(j*h-m*k+ +g[e+312>>2])+t*(n*k-h*l+ +g[e+316>>2])+u*(m*l-n*j+ +g[e+320>>2]));g[A+(B*284|0)+268>>2]=-1.0/r;break}else{g[A+(B*284|0)+272>>2]=0.0;g[A+(B*284|0)+268>>2]=10.0;break}}else{c[A+(B*284|0)+32>>2]=c[o>>2];g[A+(B*284|0)+272>>2]=0.0;t=-+g[v>>2];u=-+g[w>>2];g[p>>2]=-+g[q>>2];g[A+(B*284|0)+4>>2]=t;g[A+(B*284|0)+8>>2]=u;g[A+(B*284|0)+12>>2]=0.0;g[A+(B*284|0)+268>>2]=1.0}while(0);B=B+1|0;e=c[b+136>>2]|0;f=c[b+116>>2]|0}while((B|0)<(e|0));j=1.0/+g[f+344>>2];if((e|0)>0){f=0;do{e=c[b+144>>2]|0;if(!(a[e+(f*284|0)+84>>0]|0))h=0.0;else{h=+g[e+(f*284|0)+272>>2];h=j*(+g[e+(f*284|0)+216>>2]*(+g[e+(f*284|0)+204>>2]-+g[e+(f*284|0)+32>>2])*+g[e+(f*284|0)+268>>2]-h*+g[(h<0.0?e+(f*284|0)+220|0:e+(f*284|0)+224|0)>>2]);h=h<0.0?0.0:h}g[e+(f*284|0)+276>>2]=h;f=f+1|0;e=c[b+136>>2]|0}while((f|0)<(e|0));if((e|0)>0){e=0;do{B=c[b+144>>2]|0;s=+g[B+(e*284|0)+276>>2];u=+g[B+(e*284|0)+248>>2];s=s>u?u:s;u=s*+g[B+(e*284|0)+4>>2]*d;t=s*+g[B+(e*284|0)+8>>2]*d;g[C+40>>2]=+g[B+(e*284|0)>>2]*s*d;g[C+40+4>>2]=u;g[C+40+8>>2]=t;g[C+40+12>>2]=0.0;D=c[b+116>>2]|0;t=+g[B+(e*284|0)+20>>2]-+g[D+56>>2];u=+g[B+(e*284|0)+24>>2]-+g[D+60>>2];g[C>>2]=+g[B+(e*284|0)+16>>2]-+g[D+52>>2];g[C+4>>2]=t;g[C+8>>2]=u;g[C+12>>2]=0.0;gj(D,C+40|0,C);e=e+1|0}while((e|0)<(c[b+136>>2]|0))}}}zb[c[(c[b>>2]|0)+20>>2]&31](b,d);f=c[b+136>>2]|0;if((f|0)<=0){i=C;return}o=c[b+144>>2]|0;p=c[b+116>>2]|0;q=0;do{h=+g[o+(q*284|0)+36>>2]-+g[p+52>>2];j=+g[o+(q*284|0)+40>>2]-+g[p+56>>2];k=+g[o+(q*284|0)+44>>2]-+g[p+60>>2];l=+g[p+332>>2];m=+g[p+336>>2];n=+g[p+328>>2];if(!(a[o+(q*284|0)+84>>0]|0)){e=o+(q*284|0)+240|0;h=+g[e>>2];D=o+(q*284|0)+236|0;g[D>>2]=h+ +g[D>>2]}else{e=c[b+128>>2]|0;F=+g[p+4+(e<<2)>>2];r=+g[p+20+(e<<2)>>2];t=+g[p+36+(e<<2)>>2];E=+g[o+(q*284|0)>>2];s=+g[o+(q*284|0)+4>>2];u=+g[o+(q*284|0)+8>>2];h=((j*n-h*l+ +g[p+320>>2])*(t-u*(F*E+r*s+t*u))+((l*k-j*m+ +g[p+312>>2])*(F-E*(F*E+r*s+t*u))+(h*m-k*n+ +g[p+316>>2])*(r-s*(F*E+r*s+t*u))))*d/+g[o+(q*284|0)+212>>2];e=o+(q*284|0)+240|0;g[e>>2]=h;D=o+(q*284|0)+236|0;g[D>>2]=+g[D>>2]+h}g[e>>2]=h*.9900000095367432;q=q+1|0}while((q|0)!=(f|0));i=C;return}function sd(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;C=+g[b+48>>2];i=+g[d>>2];D=+g[b+64>>2];j=+g[d+4>>2];E=+g[b+80>>2];p=+g[d+8>>2];s=+g[b+52>>2];r=+g[b+68>>2];q=+g[b+84>>2];w=+g[b+56>>2];y=+g[b+72>>2];z=+g[b+88>>2];v=+g[d+16>>2];u=+g[d+20>>2];t=+g[d+24>>2];x=+g[d+32>>2];F=+g[d+36>>2];G=+g[d+40>>2];k=+g[b+96>>2];h=+g[b+100>>2];B=+g[b+104>>2];A=+g[d+48>>2]+(i*k+j*h+p*B);f=v*k+u*h+t*B+ +g[d+52>>2];B=x*k+F*h+G*B+ +g[d+56>>2];g[b+1064>>2]=C*i+D*j+E*p;g[b+1068>>2]=i*s+j*r+p*q;g[b+1072>>2]=i*w+j*y+p*z;g[b+1076>>2]=0.0;g[b+1080>>2]=C*v+D*u+E*t;g[b+1084>>2]=s*v+r*u+q*t;g[b+1088>>2]=w*v+y*u+z*t;g[b+1092>>2]=0.0;g[b+1096>>2]=C*x+D*F+E*G;g[b+1100>>2]=s*x+r*F+q*G;g[b+1104>>2]=w*x+y*F+z*G;g[b+1108>>2]=0.0;g[b+1112>>2]=A;g[b+1116>>2]=f;g[b+1120>>2]=B;g[b+1124>>2]=0.0;B=+g[b+112>>2];f=+g[e>>2];A=+g[b+128>>2];G=+g[e+4>>2];z=+g[b+144>>2];F=+g[e+8>>2];y=+g[b+116>>2];x=+g[b+132>>2];w=+g[b+148>>2];q=+g[b+120>>2];r=+g[b+136>>2];s=+g[b+152>>2];E=+g[e+16>>2];D=+g[e+20>>2];C=+g[e+24>>2];t=+g[e+32>>2];u=+g[e+36>>2];v=+g[e+40>>2];p=+g[b+160>>2];j=+g[b+164>>2];i=+g[b+168>>2];h=+g[e+48>>2]+(f*p+G*j+F*i);k=E*p+D*j+C*i+ +g[e+52>>2];i=t*p+u*j+v*i+ +g[e+56>>2];g[b+1128>>2]=B*f+A*G+z*F;g[b+1132>>2]=f*y+G*x+F*w;g[b+1136>>2]=f*q+G*r+F*s;g[b+1140>>2]=0.0;g[b+1144>>2]=B*E+A*D+z*C;g[b+1148>>2]=y*E+x*D+w*C;g[b+1152>>2]=q*E+r*D+s*C;g[b+1156>>2]=0.0;g[b+1160>>2]=B*t+A*u+z*v;g[b+1164>>2]=y*t+x*u+w*v;g[b+1168>>2]=q*t+r*u+s*v;g[b+1172>>2]=0.0;g[b+1176>>2]=h;g[b+1180>>2]=k;g[b+1184>>2]=i;g[b+1188>>2]=0.0;h=h-+g[b+1112>>2];k=k-+g[b+1116>>2];i=i-+g[b+1120>>2];w=+g[b+1084>>2];x=+g[b+1104>>2];y=+g[b+1088>>2];z=+g[b+1100>>2];A=+g[b+1096>>2];B=+g[b+1080>>2];C=+g[b+1064>>2];D=+g[b+1068>>2];E=+g[b+1072>>2];F=1.0/((w*x-y*z)*C+D*(y*A-x*B)+(z*B-w*A)*E);G=(z*B-w*A)*F;f=i*(y*D-w*E)*F+(h*(w*x-y*z)*F+k*(z*E-x*D)*F);j=i*(B*E-y*C)*F+(h*(y*A-x*B)*F+k*(x*C-A*E)*F);k=i*(w*C-B*D)*F+(h*G+k*(A*D-z*C)*F);g[b+1256>>2]=f;g[b+1260>>2]=j;g[b+1264>>2]=k;g[b+1268>>2]=0.0;g[b+840>>2]=f;h=+g[b+680>>2];i=+g[b+696>>2];do if(!(h>i)){if(h>f){c[b+856>>2]=2;g[b+824>>2]=f-h;break}if(i<f){c[b+856>>2]=1;g[b+824>>2]=f-i;break}else{c[b+856>>2]=0;g[b+824>>2]=0.0;break}}else{c[b+856>>2]=0;g[b+824>>2]=0.0}while(0);g[b+844>>2]=j;f=+g[b+684>>2];h=+g[b+700>>2];do if(!(f>h)){if(f>j){c[b+860>>2]=2;g[b+828>>2]=j-f;break}if(h<j){c[b+860>>2]=1;g[b+828>>2]=j-h;break}else{c[b+860>>2]=0;g[b+828>>2]=0.0;break}}else{c[b+860>>2]=0;g[b+828>>2]=0.0}while(0);g[b+848>>2]=k;f=+g[b+688>>2];h=+g[b+704>>2];do if(!(f>h)){if(f>k){c[b+864>>2]=2;g[b+832>>2]=k-f;break}if(h<k){c[b+864>>2]=1;g[b+832>>2]=k-h;break}else{c[b+864>>2]=0;g[b+832>>2]=0.0;break}}else{c[b+864>>2]=0;g[b+832>>2]=0.0}while(0);h=+g[b+1128>>2];i=+g[b+1144>>2];j=+g[b+1160>>2];k=+g[b+1132>>2];l=+g[b+1148>>2];m=+g[b+1164>>2];n=(w*x-y*z)*F*k+(z*E-x*D)*F*l+(y*D-w*E)*F*m;o=k*(y*A-x*B)*F+(x*C-A*E)*F*l+(B*E-y*C)*F*m;p=j*(w*C-B*D)*F+(h*G+i*(A*D-z*C)*F);f=G*+g[b+1136>>2]+(A*D-z*C)*F*+g[b+1152>>2]+(w*C-B*D)*F*(q*t+r*u+s*v);do if(p<1.0)if(p>-1.0){g[b+1192>>2]=+W(+-(k*G+(A*D-z*C)*F*l+(w*C-B*D)*F*m),+f);G=p<-1.0?-1.0:p;g[b+1196>>2]=+U(+(G>1.0?1.0:G));g[b+1200>>2]=+W(+-(j*(B*E-y*C)*F+(h*(y*A-x*B)*F+i*(x*C-A*E)*F)),+(j*(y*D-w*E)*F+(h*(w*x-y*z)*F+i*(z*E-x*D)*F)));break}else{g[b+1192>>2]=-+W(+n,+o);g[b+1196>>2]=-1.5707963705062866;g[b+1200>>2]=0.0;break}else{g[b+1192>>2]=+W(+n,+o);g[b+1196>>2]=1.5707963705062866;g[b+1200>>2]=0.0}while(0);g[b+1236>>2]=0.0;z=x*(h*x-j*E)-y*(i*E-h*y);A=E*(i*E-h*y)-x*(j*y-i*x);B=y*(j*y-i*x)-E*(h*x-j*E);g[b+1220>>2]=0.0;C=i*(i*E-h*y)-j*(h*x-j*E);D=j*(j*y-i*x)-h*(i*E-h*y);F=h*(h*x-j*E)-i*(j*y-i*x);g[b+1252>>2]=0.0;G=1.0/+O(+(z*z+A*A+B*B));g[b+1208>>2]=z*G;g[b+1212>>2]=A*G;g[b+1216>>2]=B*G;G=1.0/+O(+((j*y-i*x)*(j*y-i*x)+(h*x-j*E)*(h*x-j*E)+(i*E-h*y)*(i*E-h*y)));g[b+1224>>2]=(j*y-i*x)*G;g[b+1228>>2]=(h*x-j*E)*G;g[b+1232>>2]=(i*E-h*y)*G;G=1.0/+O(+(C*C+D*D+F*F));g[b+1240>>2]=C*G;g[b+1244>>2]=D*G;g[b+1248>>2]=F*G;if(!(a[b+1301>>0]|0))return;F=+g[(c[b+28>>2]|0)+344>>2];G=+g[(c[b+32>>2]|0)+344>>2];a[b+1280>>0]=(F<1.1920928955078125e-07|G<1.1920928955078125e-07)&1;G=F+G>0.0?G/(F+G):.5;g[b+1272>>2]=G;g[b+1276>>2]=1.0-G;return}function td(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+80|0;e=c[b+8>>2]|0;if((e|0)>0){g=0;do{f=c[(c[b+16>>2]|0)+(g<<2)>>2]|0;if((c[f+236>>2]|0)==1){Cb[c[(c[f>>2]|0)+24>>2]&127](f,d);e=c[b+8>>2]|0}g=g+1|0}while((g|0)<(e|0))}a[x+16>>0]=1;c[x+12>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;a[x+36>>0]=1;c[x+32>>2]=0;c[x+24>>2]=0;c[x+28>>2]=0;a[x+56>>0]=1;c[x+52>>2]=0;c[x+44>>2]=0;c[x+48>>2]=0;a[x+76>>0]=1;c[x+72>>2]=0;c[x+64>>2]=0;c[x+68>>2]=0;if((e|0)<=0){pj(x);i=x;return}j=0;k=0;g=0;f=0;r=0;while(1){q=c[(c[(c[b+16>>2]|0)+(r<<2)>>2]|0)+192>>2]|0;p=(q+~(q<<15)>>10^q+~(q<<15))*9|0;p=(p>>6^p)+~((p>>6^p)<<11)>>16^(p>>6^p)+~((p>>6^p)<<11);o=p&j+-1;l=o>>>0<k>>>0;a:do if(l){h=c[g+(o<<2)>>2]|0;if((h|0)!=-1){m=c[x+72>>2]|0;while(1){if((q|0)==(c[m+(h<<3)>>2]|0)){n=13;break}k=c[f+(h<<2)>>2]|0;if((k|0)==-1)break;else h=k}if((n|0)==13?(n=0,(c[x+52>>2]|0)+(h<<2)|0):0)break;if(!l){n=20;break}}e=c[g+(o<<2)>>2]|0;if((e|0)!=-1){h=c[x+72>>2]|0;while(1){if((q|0)==(c[h+(e<<3)>>2]|0))break;e=c[f+(e<<2)>>2]|0;if((e|0)==-1){n=20;break a}}c[(c[x+52>>2]|0)+(e<<2)>>2]=q;e=j;n=82}else n=20}else n=20;while(0);if((n|0)==20){l=c[x+44>>2]|0;if((l|0)==(j|0)){e=j|0?j<<1:1;if((j|0)<(e|0)){if((e|0)!=0?(c[6435]=(c[6435]|0)+1,w=yc((e<<2|3)+16|0)|0,(w|0)!=0):0){c[(w+4+15&-16)+-4>>2]=w;g=w+4+15&-16}else g=0;if((j|0)>0){f=0;do{c[g+(f<<2)>>2]=c[(c[x+52>>2]|0)+(f<<2)>>2];f=f+1|0}while((f|0)!=(j|0))}f=c[x+52>>2]|0;if(f|0){if(a[x+56>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[x+52>>2]=0}a[x+56>>0]=1;c[x+52>>2]=g;c[x+48>>2]=e;f=j}else{f=j;e=j}}else{f=l;e=j}c[(c[x+52>>2]|0)+(f<<2)>>2]=q;c[x+44>>2]=f+1;f=c[x+64>>2]|0;if((f|0)==(c[x+68>>2]|0)?(s=f|0?f<<1:1,(f|0)<(s|0)):0){if((s|0)!=0?(c[6435]=(c[6435]|0)+1,t=yc((s<<3|3)+16|0)|0,(t|0)!=0):0){c[(t+4+15&-16)+-4>>2]=t;g=t+4+15&-16}else g=0;if((f|0)>0){e=0;do{k=(c[x+72>>2]|0)+(e<<3)|0;m=c[k+4>>2]|0;n=g+(e<<3)|0;c[n>>2]=c[k>>2];c[n+4>>2]=m;e=e+1|0}while((e|0)!=(f|0))}e=c[x+72>>2]|0;if(e|0){if(a[x+76>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[x+72>>2]=0}a[x+76>>0]=1;c[x+72>>2]=g;c[x+68>>2]=s;f=c[x+64>>2]|0;e=c[x+48>>2]|0}n=(c[x+72>>2]|0)+(f<<3)|0;c[n>>2]=q;c[n+4>>2]=0;c[x+64>>2]=f+1;if((j|0)<(e|0)){k=c[x+4>>2]|0;do if((e|0)>(k|0)){if((e|0)>=(k|0)){do if((c[x+8>>2]|0)<(e|0)){if((e|0)!=0?(c[6435]=(c[6435]|0)+1,u=yc((e<<2|3)+16|0)|0,(u|0)!=0):0){c[(u+4+15&-16)+-4>>2]=u;f=u+4+15&-16}else f=0;g=c[x+12>>2]|0;if((k|0)<=0){if(!g){a[x+16>>0]=1;c[x+12>>2]=f;c[x+8>>2]=e;break}}else{h=0;do{c[f+(h<<2)>>2]=c[g+(h<<2)>>2];h=h+1|0}while((h|0)!=(k|0))}if(a[x+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0)}a[x+16>>0]=1;c[x+12>>2]=f;c[x+8>>2]=e}else f=c[x+12>>2]|0;while(0);Qn(f+(k<<2)|0,0,e-k<<2|0)|0}c[x+4>>2]=e;j=c[x+24>>2]|0;if((e|0)>(j|0)){do if((c[x+28>>2]|0)<(e|0)){if((e|0)!=0?(c[6435]=(c[6435]|0)+1,v=yc((e<<2|3)+16|0)|0,(v|0)!=0):0){c[(v+4+15&-16)+-4>>2]=v;f=v+4+15&-16}else f=0;g=c[x+32>>2]|0;if((j|0)<=0){if(!g){a[x+36>>0]=1;c[x+32>>2]=f;c[x+28>>2]=e;break}}else{h=0;do{c[f+(h<<2)>>2]=c[g+(h<<2)>>2];h=h+1|0}while((h|0)!=(j|0))}if(a[x+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0)}a[x+36>>0]=1;c[x+32>>2]=f;c[x+28>>2]=e}else f=c[x+32>>2]|0;while(0);Qn(f+(j<<2)|0,0,e-j<<2|0)|0}c[x+24>>2]=e;if((e|0)>0){o=e<<2;Qn(c[x+12>>2]|0,-1,o|0)|0;Qn(c[x+32>>2]|0,-1,o|0)|0}if((k|0)<=0){e=c[x+48>>2]|0;break}f=c[x+72>>2]|0;g=c[x+12>>2]|0;h=c[x+32>>2]|0;e=c[x+48>>2]|0;j=0;do{o=c[f+(j<<3)>>2]|0;o=(o+~(o<<15)>>10^o+~(o<<15))*9|0;o=g+((((o>>6^o)+~((o>>6^o)<<11)>>16^(o>>6^o)+~((o>>6^o)<<11))&e+-1)<<2)|0;c[h+(j<<2)>>2]=c[o>>2];c[o>>2]=j;j=j+1|0}while((j|0)!=(k|0))}while(0);f=e;e=p&e+-1}else{f=e;e=o}g=c[x+12>>2]|0;e=g+(e<<2)|0;n=c[x+32>>2]|0;c[n+(l<<2)>>2]=c[e>>2];c[e>>2]=l;e=f;f=n;n=82}if((n|0)==82){n=0;Cb[c[(c[q>>2]|0)+60>>2]&127](q,d);j=e;e=c[b+8>>2]|0}h=r+1|0;if((h|0)>=(e|0))break;k=c[x+4>>2]|0;r=h}pj(x);i=x;return}function ud(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=i;i=i+32|0;ig(b+4|0,((_(c[b+152>>2]|0,c[b+16>>2]|0)|0)/100|0)+1|0);if(c[b+164>>2]|0){p=((_(c[b+148>>2]|0,c[b+76>>2]|0)|0)/100|0)+1|0;ig(b+64|0,p);p=(c[b+164>>2]|0)-p|0;c[b+164>>2]=(p|0)<0?0:p}e=((c[b+144>>2]|0)+1|0)%2|0;c[b+144>>2]=e;e=c[b+124+(e<<2)>>2]|0;if(e|0){do{l=e+56|0;m=e;e=c[l>>2]|0;k=c[m+52>>2]|0;j=e;if(!k)c[b+124+(c[m+60>>2]<<2)>>2]=j;else c[k+56>>2]=j;j=c[l>>2]|0;if(j|0)c[j+52>>2]=c[m+52>>2];c[m+52>>2]=0;c[l>>2]=c[b+132>>2];j=c[b+132>>2]|0;if(j|0)c[j+52>>2]=m;c[b+132>>2]=m;j=c[m+48>>2]|0;hh(b+4|0,j)|0;k=c[b+8>>2]|0;if(k|0){c[6436]=(c[6436]|0)+1;hd(c[k+-4>>2]|0)}c[b+8>>2]=j;c[b+16>>2]=(c[b+16>>2]|0)+-1;c[r>>2]=c[m+16>>2];c[r+4>>2]=c[m+16+4>>2];c[r+8>>2]=c[m+16+8>>2];c[r+12>>2]=c[m+16+12>>2];c[r+16>>2]=c[m+32>>2];c[r+16+4>>2]=c[m+32+4>>2];c[r+16+8>>2]=c[m+32+8>>2];c[r+16+12>>2]=c[m+32+12>>2];j=c[b+68>>2]|0;if(!j){c[6435]=(c[6435]|0)+1;j=yc(63)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}k=j;l=k+44|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(l|0))}else c[b+68>>2]=0;c[j+32>>2]=0;c[j+36>>2]=m;c[j+40>>2]=0;c[j>>2]=c[r>>2];c[j+4>>2]=c[r+4>>2];c[j+8>>2]=c[r+8>>2];c[j+12>>2]=c[r+12>>2];c[j+16>>2]=c[r+16>>2];c[j+20>>2]=c[r+20>>2];c[j+24>>2]=c[r+24>>2];c[j+28>>2]=c[r+28>>2];lf(b+64|0,c[b+64>>2]|0,j);k=(c[b+76>>2]|0)+1|0;c[b+76>>2]=k;c[m+48>>2]=j;c[m+60>>2]=2}while((e|0)!=0);c[b+164>>2]=k;a[b+194>>0]=1}c[r>>2]=8904;c[r+4>>2]=b;if(a[b+193>>0]|0?(we(b+4|0,c[b+4>>2]|0,c[b+64>>2]|0,r),a[b+193>>0]|0):0){p=c[b+4>>2]|0;we(b+4|0,p,p,r)}if(a[b+194>>0]|0?(n=c[b+136>>2]|0,n=Eb[c[(c[n>>2]|0)+28>>2]&127](n)|0,f=c[n+4>>2]|0,(f|0)>0):0){e=(_(c[b+156>>2]|0,f)|0)/100|0;p=c[b+160>>2]|0;e=(p|0)>(e|0)?p:e;e=(f|0)<(e|0)?f:e;if((e|0)>0){j=0;do{l=((c[b+184>>2]|0)+j|0)%(f|0)|0;o=c[n+12>>2]|0;k=c[o+(l<<4)>>2]|0;l=c[o+(l<<4)+4>>2]|0;o=c[k+48>>2]|0;p=c[l+48>>2]|0;if(!(((((+g[o>>2]<=+g[p+16>>2]?+g[o+16>>2]>=+g[p>>2]:0)?+g[o+4>>2]<=+g[p+20>>2]:0)?+g[o+20>>2]>=+g[p+4>>2]:0)?+g[o+8>>2]<=+g[p+24>>2]:0)?+g[o+24>>2]>=+g[p+8>>2]:0)){f=c[b+136>>2]|0;Ib[c[(c[f>>2]|0)+12>>2]&31](f,k,l,d)|0;f=c[n+4>>2]|0;j=j+-1|0;e=e+-1|0}j=j+1|0}while((j|0)<(e|0));if((f|0)>0)q=37;else e=0}else q=37;if((q|0)==37)e=((c[b+184>>2]|0)+e|0)%(f|0)|0;c[b+184>>2]=e}c[b+180>>2]=(c[b+180>>2]|0)+1;c[b+160>>2]=1;a[b+194>>0]=0;f=c[b+168>>2]|0;e=c[b+172>>2]|0;if(!f)h=0.0;else h=+(e>>>0)/+(f>>>0);g[b+176>>2]=h;c[b+172>>2]=e>>>1;c[b+168>>2]=f>>>1;p=c[b+136>>2]|0;if(!(Eb[c[(c[p>>2]|0)+56>>2]&127](p)|0)){i=r;return}p=c[b+136>>2]|0;p=Eb[c[(c[p>>2]|0)+28>>2]&127](p)|0;e=c[p+4>>2]|0;if((e|0)>1){Vd(p,0,e+-1|0);j=0;k=0;l=0;f=0;q=44}else{j=0;o=0;n=0;f=0}while(1){if((q|0)==44){q=0;e=c[p+4>>2]|0;o=k;n=l}if((j|0)>=(e|0))break;m=c[p+12>>2]|0;k=m+(j<<4)|0;l=c[k>>2]|0;m=m+(j<<4)+4|0;e=c[m>>2]|0;if(!((l|0)==(n|0)&(e|0)==(f|0))){f=c[l+48>>2]|0;n=c[e+48>>2]|0;if(((((+g[f>>2]<=+g[n+16>>2]?+g[f+16>>2]>=+g[n>>2]:0)?+g[f+4>>2]<=+g[n+20>>2]:0)?+g[f+20>>2]>=+g[n+4>>2]:0)?+g[f+8>>2]<=+g[n+24>>2]:0)?+g[f+24>>2]>=+g[n+8>>2]:0){f=e;e=o}else q=53}else{e=f;q=53}if((q|0)==53){f=c[b+136>>2]|0;ic[c[(c[f>>2]|0)+32>>2]&127](f,k,d);c[k>>2]=0;c[m>>2]=0;f=e;e=o+1|0}j=j+1|0;k=e;q=44}if((e|0)>1){Vd(p,0,e+-1|0);k=c[p+4>>2]|0}else k=e;l=k-o|0;if((o|0)<0){if((c[p+8>>2]|0)<(l|0)){if((k|0)!=(o|0)){c[6435]=(c[6435]|0)+1;e=yc((l<<4|3)+16|0)|0;if(!e)e=0;else{c[(e+4+15&-16)+-4>>2]=e;e=e+4+15&-16}f=c[p+4>>2]|0;if((f|0)>0){j=0;do{q=c[p+12>>2]|0;c[e+(j<<4)>>2]=c[q+(j<<4)>>2];c[e+(j<<4)+4>>2]=c[q+(j<<4)+4>>2];c[e+(j<<4)+8>>2]=c[q+(j<<4)+8>>2];c[e+(j<<4)+12>>2]=c[q+(j<<4)+12>>2];j=j+1|0}while((j|0)!=(f|0));f=p+12|0}else f=p+12|0}else{e=0;f=p+12|0}j=c[f>>2]|0;if(j|0){if(a[p+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[f>>2]=0}a[p+16>>0]=1;c[f>>2]=e;c[p+8>>2]=l}else f=p+12|0;e=k;do{q=(c[f>>2]|0)+(e<<4)|0;e=e+1|0;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;c[q+12>>2]=0}while((e|0)!=(l|0))}c[p+4>>2]=l;i=r;return}function vd(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;o=c[b+28>>2]|0;h=c[b+32>>2]|0;Fc(b,o+4|0,h+4|0,o+264|0,h+264|0);q=c[d+8>>2]|0;g[q>>2]=1.0;p=c[d+24>>2]|0;g[q+(p+1<<2)>>2]=1.0;g[q+((p<<1)+2<<2)>>2]=1.0;l=+g[b+348>>2];u=+g[b+352>>2];n=+g[b+356>>2];s=+g[o+4>>2]*l+ +g[o+8>>2]*u+ +g[o+12>>2]*n;m=l*+g[o+20>>2]+u*+g[o+24>>2]+n*+g[o+28>>2];n=l*+g[o+36>>2]+u*+g[o+40>>2]+n*+g[o+44>>2];q=c[d+12>>2]|0;c[q>>2]=0;g[q+4>>2]=n;g[q+8>>2]=-m;g[q+12>>2]=0.0;g[q+(p<<2)>>2]=-n;c[q+(p<<2)+4>>2]=0;g[q+(p<<2)+8>>2]=s;g[q+(p<<2)+12>>2]=0.0;g[q+(p<<1<<2)>>2]=m;g[q+(p<<1<<2)+4>>2]=-s;c[q+(p<<1<<2)+8>>2]=0;g[q+(p<<1<<2)+12>>2]=0.0;q=c[d+16>>2]|0;g[q>>2]=-1.0;g[q+(p+1<<2)>>2]=-1.0;g[q+((p<<1)+2<<2)>>2]=-1.0;u=+g[b+412>>2];l=+g[b+416>>2];k=+g[b+420>>2];t=+g[h+4>>2]*u+ +g[h+8>>2]*l+ +g[h+12>>2]*k;j=u*+g[h+20>>2]+l*+g[h+24>>2]+k*+g[h+28>>2];k=u*+g[h+36>>2]+l*+g[h+40>>2]+k*+g[h+44>>2];p=c[d+20>>2]|0;q=c[d+24>>2]|0;c[p>>2]=0;g[p+4>>2]=-k;g[p+8>>2]=j;g[p+12>>2]=0.0;g[p+(q<<2)>>2]=k;c[p+(q<<2)+4>>2]=0;g[p+(q<<2)+8>>2]=-t;g[p+(q<<2)+12>>2]=0.0;g[p+(q<<1<<2)>>2]=-j;g[p+(q<<1<<2)+4>>2]=t;c[p+(q<<1<<2)+8>>2]=0;g[p+(q<<1<<2)+12>>2]=0.0;q=c[b+592>>2]|0;l=+g[((q&2|0)==0?d+4|0:b+600|0)>>2]*+g[d>>2];r=c[d+24>>2]|0;i=c[d+28>>2]|0;f=c[d+36>>2]|0;e=c[d+40>>2]|0;g[i>>2]=l*(t+ +g[h+52>>2]-s-+g[o+52>>2]);g[f>>2]=-3402823466385288598117041.0e14;g[e>>2]=3402823466385288598117041.0e14;if(!(q&1)){g[i+(r<<2)>>2]=l*(j+ +g[h+56>>2]-m-+g[o+56>>2]);g[f+(r<<2)>>2]=-3402823466385288598117041.0e14;g[e+(r<<2)>>2]=3402823466385288598117041.0e14;g[i+(r<<1<<2)>>2]=l*(k+ +g[h+60>>2]-n-+g[o+60>>2]);g[f+(r<<1<<2)>>2]=-3402823466385288598117041.0e14;g[e+(r<<1<<2)>>2]=3402823466385288598117041.0e14}else{v=c[d+32>>2]|0;c[v>>2]=c[b+596>>2];g[i+(r<<2)>>2]=l*(j+ +g[h+56>>2]-m-+g[o+56>>2]);g[f+(r<<2)>>2]=-3402823466385288598117041.0e14;g[e+(r<<2)>>2]=3402823466385288598117041.0e14;c[v+(r<<2)>>2]=c[b+596>>2];g[i+(r<<1<<2)>>2]=l*(k+ +g[h+60>>2]-n-+g[o+60>>2]);g[f+(r<<1<<2)>>2]=-3402823466385288598117041.0e14;g[e+(r<<1<<2)>>2]=3402823466385288598117041.0e14;c[v+(r<<1<<2)>>2]=c[b+596>>2]}do if(!(a[b+526>>0]|0))h=r*3|0;else{h=c[d+12>>2]|0;u=+g[b+456>>2];if(+g[b+444>>2]<u?+g[b+448>>2]<u:0){z=+g[o+4>>2];y=+g[o+8>>2];x=+g[o+12>>2];D=+g[b+304>>2];C=+g[b+320>>2];B=+g[b+336>>2];l=+g[b+308>>2];n=+g[b+324>>2];t=+g[b+340>>2];w=+g[o+20>>2];j=+g[o+24>>2];k=+g[o+28>>2];m=+g[o+36>>2];s=+g[o+40>>2];u=+g[o+44>>2];g[h+(r*3<<2)>>2]=z*D+y*C+x*B;g[h+((r*3|0)+1<<2)>>2]=D*w+C*j+B*k;g[h+((r*3|0)+2<<2)>>2]=D*m+C*s+B*u;g[h+(r<<2<<2)>>2]=z*l+y*n+x*t;g[h+((r<<2|1)<<2)>>2]=l*w+n*j+t*k;g[h+((r<<2|2)<<2)>>2]=l*m+n*s+t*u;g[p+(r*3<<2)>>2]=-(z*D+y*C+x*B);g[p+((r*3|0)+1<<2)>>2]=-(D*w+C*j+B*k);g[p+((r*3|0)+2<<2)>>2]=-(D*m+C*s+B*u);g[p+(r<<2<<2)>>2]=-(z*l+y*n+x*t);g[p+((r<<2|1)<<2)>>2]=-(l*w+n*j+t*k);g[p+((r<<2|2)<<2)>>2]=-(l*m+n*s+t*u);A=+g[d>>2]*+g[b+436>>2];i=c[d+28>>2]|0;g[i+(r*3<<2)>>2]=A*((z*D+y*C+x*B)*+g[b+460>>2]+(D*w+C*j+B*k)*+g[b+464>>2]+(D*m+C*s+B*u)*+g[b+468>>2]);g[i+(r<<2<<2)>>2]=A*((z*l+y*n+x*t)*+g[b+460>>2]+(l*w+n*j+t*k)*+g[b+464>>2]+(l*m+n*s+t*u)*+g[b+468>>2]);f=c[d+36>>2]|0;g[f+(r*3<<2)>>2]=-3402823466385288598117041.0e14;e=c[d+40>>2]|0;g[e+(r*3<<2)>>2]=3402823466385288598117041.0e14;g[f+(r<<2<<2)>>2]=-3402823466385288598117041.0e14;g[e+(r<<2<<2)>>2]=3402823466385288598117041.0e14;h=(c[d+24>>2]|0)+(r<<2)|0;break}D=+g[b+436>>2];B=D*+g[b+460>>2]*D;C=D*D*+g[b+464>>2];D=D*D*+g[b+468>>2];g[h+(r*3<<2)>>2]=B;g[h+((r*3|0)+1<<2)>>2]=C;g[h+((r*3|0)+2<<2)>>2]=D;g[p+(r*3<<2)>>2]=-B;g[p+((r*3|0)+1<<2)>>2]=-C;g[p+((r*3|0)+2<<2)>>2]=-D;g[i+(r*3<<2)>>2]=+g[d>>2]*+g[b+432>>2]*+g[b+504>>2];if(q&4|0)c[(c[d+32>>2]|0)+(r*3<<2)>>2]=c[b+604>>2];g[f+(r*3<<2)>>2]=0.0;g[e+(r*3<<2)>>2]=3402823466385288598117041.0e14;h=r<<2}while(0);if(!(a[b+525>>0]|0))return;D=+g[b+436>>2];B=D*+g[b+476>>2]*D;C=D*D*+g[b+480>>2];D=D*D*+g[b+484>>2];p=c[d+12>>2]|0;r=c[d+20>>2]|0;g[p+(h<<2)>>2]=B;q=h+1|0;g[p+(q<<2)>>2]=C;v=h+2|0;g[p+(v<<2)>>2]=D;g[r+(h<<2)>>2]=-B;g[r+(q<<2)>>2]=-C;g[r+(v<<2)>>2]=-D;g[i+(h<<2)>>2]=+g[d>>2]*+g[b+432>>2]*+g[b+508>>2];if(c[b+592>>2]&4|0)c[(c[d+32>>2]|0)+(h<<2)>>2]=c[b+604>>2];if(!(+g[b+452>>2]>0.0)){g[f+(h<<2)>>2]=-3402823466385288598117041.0e14;g[e+(h<<2)>>2]=3402823466385288598117041.0e14;return}f=f+(h<<2)|0;e=c[d+40>>2]|0;if(+g[b+508>>2]>0.0){g[f>>2]=0.0;g[e+(h<<2)>>2]=3402823466385288598117041.0e14;return}else{g[f>>2]=-3402823466385288598117041.0e14;g[e+(h<<2)>>2]=0.0;return}}function wd(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0.0,l=0,m=0.0,n=0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0.0,F=0.0,G=0.0,H=0,I=0,J=0,K=0,L=0.0,M=0.0,N=0.0,O=0.0;K=i;i=i+288|0;c[K+144>>2]=c[d>>2];c[K+144+4>>2]=c[d+4>>2];c[K+144+8>>2]=c[d+8>>2];c[K+144+12>>2]=c[d+12>>2];c[K+144+16>>2]=c[d+16>>2];c[K+144+16+4>>2]=c[d+16+4>>2];c[K+144+16+8>>2]=c[d+16+8>>2];c[K+144+16+12>>2]=c[d+16+12>>2];c[K+144+32>>2]=c[d+32>>2];c[K+144+32+4>>2]=c[d+32+4>>2];c[K+144+32+8>>2]=c[d+32+8>>2];c[K+144+32+12>>2]=c[d+32+12>>2];c[K+144+48>>2]=c[d+48>>2];c[K+144+48+4>>2]=c[d+48+4>>2];c[K+144+48+8>>2]=c[d+48+8>>2];c[K+144+48+12>>2]=c[d+48+12>>2];c[K+80>>2]=c[e>>2];c[K+80+4>>2]=c[e+4>>2];c[K+80+8>>2]=c[e+8>>2];c[K+80+12>>2]=c[e+12>>2];c[K+80+16>>2]=c[e+16>>2];c[K+80+16+4>>2]=c[e+16+4>>2];c[K+80+16+8>>2]=c[e+16+8>>2];c[K+80+16+12>>2]=c[e+16+12>>2];c[K+80+32>>2]=c[e+32>>2];c[K+80+32+4>>2]=c[e+32+4>>2];c[K+80+32+8>>2]=c[e+32+8>>2];c[K+80+32+12>>2]=c[e+32+12>>2];c[K+80+48>>2]=c[e+48>>2];c[K+80+48+4>>2]=c[e+48+4>>2];c[K+80+48+8>>2]=c[e+48+8>>2];c[K+80+48+12>>2]=c[e+48+12>>2];m=+g[K+80+52>>2]-+g[K+144+52>>2];O=+g[K+80+56>>2]-+g[K+144+56>>2];g[K+32>>2]=+g[K+80+48>>2]-+g[K+144+48>>2];g[K+32+4>>2]=m;g[K+32+8>>2]=O;g[K+32+12>>2]=0.0;Gf(K+144|0,K+80|0,K+224|0,K+208|0);O=+g[K+208>>2];m=O*+g[K+224+4>>2];L=O*+g[K+224+8>>2];g[K>>2]=+g[K+224>>2]*O;g[K+4>>2]=m;g[K+8>>2]=L;g[K+12>>2]=0.0;c[K+224+4>>2]=0;c[K+224+4+4>>2]=0;c[K+224+24>>2]=0;c[K+224+24+4>>2]=0;J=K+224+44|0;c[J>>2]=0;c[J+4>>2]=0;c[J+8>>2]=0;c[J+12>>2]=0;c[J+16>>2]=0;Wg(K+144|0,K+16|0);L=+g[K+16>>2];m=+g[K+16+4>>2];O=+g[K+16+8>>2];M=+g[K+16+12>>2];j=L*(2.0/(L*L+m*m+O*O+M*M));o=m*(2.0/(L*L+m*m+O*O+M*M));N=O*(2.0/(L*L+m*m+O*O+M*M));g[K+224>>2]=1.0-(m*o+O*N);g[K+224+4>>2]=L*o-M*N;g[K+224+8>>2]=L*N+M*o;g[K+224+12>>2]=0.0;g[K+224+16>>2]=L*o+M*N;g[K+224+20>>2]=1.0-(L*j+O*N);g[K+224+24>>2]=m*N-M*j;g[K+224+28>>2]=0.0;g[K+224+32>>2]=L*N-M*o;g[K+224+36>>2]=m*N+M*j;g[K+224+40>>2]=1.0-(L*j+m*o);g[J>>2]=0.0;rh(b,K+224|0,K+32|0,K,K+64|0,K+48|0);if((c[a+268>>2]|0)<=0){i=K;return}I=0;do{p=c[(c[a+276>>2]|0)+(I<<2)>>2]|0;if(Zb[c[(c[f>>2]|0)+8>>2]&31](f,c[p+188>>2]|0)|0?(C=c[p+192>>2]|0,mc[c[(c[C>>2]|0)+8>>2]&127](C,p+4|0,K+208|0,K+32|0),q=+g[K+208>>2]+ +g[K+64>>2],r=+g[K+208+4>>2]+ +g[K+64+4>>2],s=+g[K+208+8>>2]+ +g[K+64+8>>2],g[K+208>>2]=q,g[K+208+4>>2]=r,g[K+208+8>>2]=s,g[K+208+12>>2]=0.0,t=+g[K+32>>2]+ +g[K+48>>2],u=+g[K+32+4>>2]+ +g[K+48+4>>2],v=+g[K+32+8>>2]+ +g[K+48+8>>2],g[K+32>>2]=t,g[K+32+4>>2]=u,g[K+32+8>>2]=v,g[K+32+12>>2]=0.0,w=+g[d+48>>2]-(t+q)*.5,x=+g[d+52>>2]-(u+r)*.5,y=+g[d+56>>2]-(v+s)*.5,z=+g[e+48>>2]-(t+q)*.5,A=+g[e+52>>2]-(u+r)*.5,B=+g[e+56>>2]-(v+s)*.5,C=w<-((t-q)*.5)|(w>(t-q)*.5?8:0)|(x<-((u-r)*.5)?2:0)|(x>(u-r)*.5?16:0)|(y<-((v-s)*.5)?4:0)|(y>(v-s)*.5?32:0),D=z<-((t-q)*.5)|(z>(t-q)*.5?8:0)|(A<-((u-r)*.5)?2:0)|(A>(u-r)*.5?16:0)|(B<-((v-s)*.5)?4:0)|(B>(v-s)*.5?32:0),(C&D|0)==0):0){H=1;J=0;j=0.0;l=1065353216;o=1.0;while(1){if(!(H&C)){if((H&D|0)!=0?(E=(-w-o*(t-q)*.5)/(z-w),E<(c[k>>2]=l,+g[k>>2])):0)l=(g[k>>2]=E,c[k>>2]|0)}else{m=(-w-o*(t-q)*.5)/(z-w);if(j<=m)j=m}n=H<<1;if(!(n&C))if((n&D|0)!=0?(F=(-x-o*(u-r)*.5)/(A-x),F<(c[k>>2]=l,+g[k>>2])):0){m=j;l=(g[k>>2]=F,c[k>>2]|0)}else m=j;else{m=(-x-o*(u-r)*.5)/(A-x);if(!(j<=m))m=j}n=H<<2;if(!(n&C))if((n&D|0)!=0?(G=(-y-o*(v-s)*.5)/(B-y),G<(c[k>>2]=l,+g[k>>2])):0){j=m;l=(g[k>>2]=G,c[k>>2]|0)}else j=m;else{j=(-y-o*(v-s)*.5)/(B-y);if(!(m<=j))j=m}J=J+1|0;if((J|0)==2)break;else{H=H<<3;o=-1.0}}if(j<=(c[k>>2]=l,+g[k>>2])){J=c[p+192>>2]|0;c[K+224>>2]=0;c[K+224+4>>2]=J;c[K+224+8>>2]=p;c[K+224+12>>2]=p+4;c[K+224+16>>2]=-1;c[K+224+20>>2]=-1;Ic(b,K+144|0,K+80|0,K+224|0,f,h)}}I=I+1|0}while((I|0)<(c[a+268>>2]|0));i=K;return}function xd(d,e){d=d|0;e=e|0;var f=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=i;i=i+112|0;g[d+20>>2]=+h[e+32>>3];g[d+24>>2]=+h[e+40>>3];g[d+28>>2]=+h[e+48>>3];g[d+32>>2]=+h[e+56>>3];g[d+4>>2]=+h[e>>3];g[d+8>>2]=+h[e+8>>3];g[d+12>>2]=+h[e+16>>3];g[d+16>>2]=+h[e+24>>3];g[d+36>>2]=+h[e+64>>3];g[d+40>>2]=+h[e+72>>3];g[d+44>>2]=+h[e+80>>3];g[d+48>>2]=+h[e+88>>3];c[d+56>>2]=c[e+96>>2];a[d+60>>0]=(c[e+100>>2]|0)!=0&1;p=c[e+104>>2]|0;l=q+48|0;n=l+64|0;do{c[l>>2]=0;l=l+4|0}while((l|0)<(n|0));o=c[d+88>>2]|0;if((o|0)<(p|0)){if((c[d+92>>2]|0)<(p|0)){if(!p){f=0;j=o}else{c[6435]=(c[6435]|0)+1;f=yc(p<<6|19)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}j=c[d+88>>2]|0}if((j|0)>0){k=0;do{l=f+(k<<6)|0;m=(c[d+96>>2]|0)+(k<<6)|0;n=l+64|0;do{c[l>>2]=c[m>>2];l=l+4|0;m=m+4|0}while((l|0)<(n|0));k=k+1|0}while((k|0)!=(j|0))}j=c[d+96>>2]|0;if(j|0){if(a[d+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=f;c[d+92>>2]=p;j=d+96|0}else j=d+96|0;f=o;do{l=(c[j>>2]|0)+(f<<6)|0;m=q+48|0;n=l+64|0;do{c[l>>2]=c[m>>2];l=l+4|0;m=m+4|0}while((l|0)<(n|0));f=f+1|0}while((f|0)!=(p|0))}c[d+88>>2]=p;if((p|0)>0){f=c[d+96>>2]|0;j=0;k=c[e+112>>2]|0;while(1){g[f+(j<<6)+16>>2]=+h[k+32>>3];g[f+(j<<6)+20>>2]=+h[k+40>>3];g[f+(j<<6)+24>>2]=+h[k+48>>3];g[f+(j<<6)+28>>2]=+h[k+56>>3];g[f+(j<<6)>>2]=+h[k>>3];g[f+(j<<6)+4>>2]=+h[k+8>>3];g[f+(j<<6)+8>>2]=+h[k+16>>3];g[f+(j<<6)+12>>2]=+h[k+24>>3];c[f+(j<<6)+32>>2]=c[k+64>>2];c[f+(j<<6)+36>>2]=c[k+68>>2];c[f+(j<<6)+40>>2]=c[k+72>>2];j=j+1|0;if((j|0)==(p|0))break;else k=k+80|0}}m=c[e+108>>2]|0;c[q+32>>2]=0;c[q+32+4>>2]=0;c[q+32+8>>2]=0;c[q+32+12>>2]=0;l=c[d+128>>2]|0;if((l|0)<(m|0)){if((c[d+132>>2]|0)<(m|0)){if(!m){f=0;j=l}else{c[6435]=(c[6435]|0)+1;f=yc((m<<4|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}j=c[d+128>>2]|0}if((j|0)>0){k=0;do{p=f+(k<<4)|0;o=(c[d+136>>2]|0)+(k<<4)|0;c[p>>2]=c[o>>2];c[p+4>>2]=c[o+4>>2];c[p+8>>2]=c[o+8>>2];c[p+12>>2]=c[o+12>>2];k=k+1|0}while((k|0)!=(j|0))}j=c[d+136>>2]|0;if(j|0){if(a[d+140>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=f;c[d+132>>2]=m;j=d+136|0}else j=d+136|0;f=l;do{p=(c[j>>2]|0)+(f<<4)|0;c[p>>2]=c[q+32>>2];c[p+4>>2]=c[q+32+4>>2];c[p+8>>2]=c[q+32+8>>2];c[p+12>>2]=c[q+32+12>>2];f=f+1|0}while((f|0)!=(m|0))}c[d+128>>2]=m;if((m|0)>0){f=c[d+136>>2]|0;j=0;k=c[e+116>>2]|0;while(1){c[f+(j<<4)+12>>2]=c[k+12>>2];b[f+(j<<4)+6>>1]=b[k+6>>1]|0;b[f+(j<<4)+8>>1]=b[k+8>>1]|0;b[f+(j<<4)+10>>1]=b[k+10>>1]|0;b[f+(j<<4)>>1]=b[k>>1]|0;b[f+(j<<4)+2>>1]=b[k+2>>1]|0;b[f+(j<<4)+4>>1]=b[k+4>>1]|0;j=j+1|0;if((j|0)==(m|0))break;else k=k+16|0}}c[d+144>>2]=c[e+120>>2];m=c[e+124>>2]|0;l=c[d+152>>2]|0;if((l|0)<(m|0)){if((c[d+156>>2]|0)<(m|0)){if(!m){f=0;j=l}else{c[6435]=(c[6435]|0)+1;f=yc(m<<5|19)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}j=c[d+152>>2]|0}if((j|0)>0){k=0;do{p=f+(k<<5)|0;o=(c[d+160>>2]|0)+(k<<5)|0;c[p>>2]=c[o>>2];c[p+4>>2]=c[o+4>>2];c[p+8>>2]=c[o+8>>2];c[p+12>>2]=c[o+12>>2];c[p+16>>2]=c[o+16>>2];c[p+20>>2]=c[o+20>>2];c[p+24>>2]=c[o+24>>2];c[p+28>>2]=c[o+28>>2];k=k+1|0}while((k|0)!=(j|0))}j=c[d+160>>2]|0;if(j|0){if(a[d+164>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=f;c[d+156>>2]=m;j=d+160|0}else j=d+160|0;f=l;do{p=(c[j>>2]|0)+(f<<5)|0;c[p>>2]=c[q>>2];c[p+4>>2]=c[q+4>>2];c[p+8>>2]=c[q+8>>2];c[p+12>>2]=c[q+12>>2];c[p+16>>2]=c[q+16>>2];c[p+20>>2]=c[q+20>>2];c[p+24>>2]=c[q+24>>2];c[p+28>>2]=c[q+28>>2];f=f+1|0}while((f|0)!=(m|0))}c[d+152>>2]=m;if((m|0)<=0){i=q;return}j=c[d+160>>2]|0;k=0;f=c[e+128>>2]|0;while(1){b[j+(k<<5)+6>>1]=b[f+14>>1]|0;b[j+(k<<5)+8>>1]=b[f+16>>1]|0;b[j+(k<<5)+10>>1]=b[f+18>>1]|0;b[j+(k<<5)>>1]=b[f+8>>1]|0;b[j+(k<<5)+2>>1]=b[f+10>>1]|0;b[j+(k<<5)+4>>1]=b[f+12>>1]|0;c[j+(k<<5)+12>>2]=c[f>>2];c[j+(k<<5)+16>>2]=c[f+4>>2];k=k+1|0;if((k|0)==(m|0))break;else f=f+20|0}i=q;return}function yd(a){a=a|0;var b=0,d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0;n=i;i=i+16|0;m=c[a+372>>2]|0;a:do switch(c[m+32>>2]|0){case 1:{d=1;b=0;while(1){c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;g[n+(b<<2)>>2]=1.0;o=m+32|0;g[m+16+(d<<2)>>2]=0.0;d=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=d;c[m+(c[o>>2]<<2)>>2]=c[a+348+(d<<2)>>2];d=c[o>>2]|0;c[o>>2]=d+1;e=+g[n>>2];f=+g[n+4>>2];h=+g[n+8>>2];Nh(a,e,f,h,c[m+(d<<2)>>2]|0);if(yd(a)|0)break;m=c[a+372>>2]|0;o=(c[m+32>>2]|0)+-1|0;c[m+32>>2]=o;o=c[m+(o<<2)>>2]|0;m=c[a+364>>2]|0;c[a+364>>2]=m+1;c[a+348+(m<<2)>>2]=o;m=c[a+372>>2]|0;g[m+16+(c[m+32>>2]<<2)>>2]=0.0;o=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=o;c[m+(c[m+32>>2]<<2)>>2]=c[a+348+(o<<2)>>2];o=c[m+32>>2]|0;c[m+32>>2]=o+1;Nh(a,-e,-f,-h,c[m+(o<<2)>>2]|0);if(yd(a)|0)break;o=c[a+372>>2]|0;m=(c[o+32>>2]|0)+-1|0;c[o+32>>2]=m;m=c[o+(m<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+348+(o<<2)>>2]=m;b=b+1|0;if(b>>>0>=3)break a;m=c[a+372>>2]|0;d=c[m+32>>2]|0}o=1;i=n;return o|0}case 2:{o=c[m+4>>2]|0;b=c[m>>2]|0;e=+g[o+16>>2]-+g[b+16>>2];f=+g[o+20>>2]-+g[b+20>>2];h=+g[o+24>>2]-+g[b+24>>2];b=0;while(1){c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;g[n+(b<<2)>>2]=1.0;j=+g[n+8>>2];k=+g[n+4>>2];l=+g[n>>2];if((f*j-h*k)*(f*j-h*k)+(h*l-e*j)*(h*l-e*j)+(e*k-f*l)*(e*k-f*l)>0.0){m=c[a+372>>2]|0;g[m+16+(c[m+32>>2]<<2)>>2]=0.0;o=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=o;c[m+(c[m+32>>2]<<2)>>2]=c[a+348+(o<<2)>>2];o=c[m+32>>2]|0;c[m+32>>2]=o+1;Nh(a,f*j-h*k,h*l-e*j,e*k-f*l,c[m+(o<<2)>>2]|0);if(yd(a)|0)break;m=c[a+372>>2]|0;o=(c[m+32>>2]|0)+-1|0;c[m+32>>2]=o;o=c[m+(o<<2)>>2]|0;m=c[a+364>>2]|0;c[a+364>>2]=m+1;c[a+348+(m<<2)>>2]=o;m=c[a+372>>2]|0;g[m+16+(c[m+32>>2]<<2)>>2]=0.0;o=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=o;c[m+(c[m+32>>2]<<2)>>2]=c[a+348+(o<<2)>>2];o=c[m+32>>2]|0;c[m+32>>2]=o+1;Nh(a,-(f*j-h*k),-(h*l-e*j),-(e*k-f*l),c[m+(o<<2)>>2]|0);if(yd(a)|0)break;o=c[a+372>>2]|0;m=(c[o+32>>2]|0)+-1|0;c[o+32>>2]=m;m=c[o+(m<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+348+(o<<2)>>2]=m}b=b+1|0;if(b>>>0>=3)break a}o=1;i=n;return o|0}case 3:{o=c[m+4>>2]|0;d=c[m>>2]|0;j=+g[d+16>>2];e=+g[o+16>>2]-j;k=+g[d+20>>2];f=+g[o+20>>2]-k;l=+g[d+24>>2];h=+g[o+24>>2]-l;o=c[m+8>>2]|0;j=+g[o+16>>2]-j;k=+g[o+20>>2]-k;l=+g[o+24>>2]-l;if((f*l-h*k)*(f*l-h*k)+(h*j-e*l)*(h*j-e*l)+(e*k-f*j)*(e*k-f*j)>0.0){g[m+28>>2]=0.0;o=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=o;c[m+12>>2]=c[a+348+(o<<2)>>2];o=c[m+32>>2]|0;c[m+32>>2]=o+1;Nh(a,f*l-h*k,h*j-e*l,e*k-f*j,c[m+(o<<2)>>2]|0);if(yd(a)|0){o=1;i=n;return o|0}m=c[a+372>>2]|0;o=(c[m+32>>2]|0)+-1|0;c[m+32>>2]=o;o=c[m+(o<<2)>>2]|0;m=c[a+364>>2]|0;c[a+364>>2]=m+1;c[a+348+(m<<2)>>2]=o;m=c[a+372>>2]|0;g[m+16+(c[m+32>>2]<<2)>>2]=0.0;o=(c[a+364>>2]|0)+-1|0;c[a+364>>2]=o;c[m+(c[m+32>>2]<<2)>>2]=c[a+348+(o<<2)>>2];o=c[m+32>>2]|0;c[m+32>>2]=o+1;Nh(a,-(f*l-h*k),-(h*j-e*l),-(e*k-f*j),c[m+(o<<2)>>2]|0);if(yd(a)|0){o=1;i=n;return o|0}else{o=c[a+372>>2]|0;m=(c[o+32>>2]|0)+-1|0;c[o+32>>2]=m;m=c[o+(m<<2)>>2]|0;o=c[a+364>>2]|0;c[a+364>>2]=o+1;c[a+348+(o<<2)>>2]=m;break a}}break}case 4:{o=c[m>>2]|0;a=c[m+12>>2]|0;l=+g[a+16>>2];r=+g[o+16>>2]-l;p=+g[a+20>>2];e=+g[o+20>>2]-p;h=+g[a+24>>2];j=+g[o+24>>2]-h;o=c[m+4>>2]|0;f=+g[o+16>>2]-l;k=+g[o+20>>2]-p;q=+g[o+24>>2]-h;o=c[m+8>>2]|0;l=+g[o+16>>2]-l;p=+g[o+20>>2]-p;h=+g[o+24>>2]-h;if(!((0.0!=0.0?1:r*k*h+(e*q*l+j*f*p-r*q*p-e*f*h)-j*k*l!=r*k*h+(e*q*l+j*f*p-r*q*p-e*f*h)-j*k*l)|r*k*h+(e*q*l+j*f*p-r*q*p-e*f*h)-j*k*l==0.0)){o=1;i=n;return o|0}break}default:{}}while(0);o=0;i=n;return o|0}function zd(b,d,e){b=b|0;d=d|0;e=e|0;var f=0.0,h=0,i=0,j=0,k=0.0,l=0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0,Y=0,Z=0;Y=c[d+36>>2]|0;X=c[e+36>>2]|0;K=+g[Y+8>>2];L=+g[Y+12>>2];M=+g[Y+16>>2];d=c[X+8>>2]|0;R=+g[d+8>>2];S=+g[d+12>>2];T=+g[d+16>>2];e=c[X+12>>2]|0;N=+g[e+8>>2];P=+g[e+12>>2];Q=+g[e+16>>2];h=c[X+16>>2]|0;U=+g[h+8>>2];V=+g[h+12>>2];W=+g[h+16>>2];w=N-K-(R-K);D=P-L-(S-L);B=Q-M-(T-M);x=D*(W-M-(T-M))-B*(V-L-(S-L));E=B*(U-K-(R-K))-w*(W-M-(T-M));C=w*(V-L-(S-L))-D*(U-K-(R-K));do if(C*C+(x*x+E*E)>1.1920928955078125e-07?(G=1.0/+O(+(C*C+(x*x+E*E))),H=(T-M)*C*G+((R-K)*x*G+(S-L)*E*G),H*H<3402823466385288598117041.0e14):0){f=R-K-x*G*H;r=S-L-E*G*H;s=T-M-C*G*H;t=N-K-x*G*H;u=P-L-E*G*H;v=Q-M-C*G*H;if((C*(u*f-r*t)+(x*(r*v-s*u)+E*(s*t-v*f))>0.0?(y=U-K-x*G*H,z=V-L-E*G*H,A=W-M-C*G*H,C*(z*t-u*y)+(x*(u*A-v*z)+E*(v*y-A*t))>0.0):0)?C*(r*y-z*f)+(x*(z*s-A*r)+E*(A*f-s*y))>0.0:0){q=H*H;p=x*G*H;n=C*G*H;m=E*G*H;break}if(w*w+D*D+B*B>1.1920928955078125e-07?(F=-((R-K)*w+(S-L)*D+(T-M)*B)/(w*w+D*D+B*B),F=F<0.0?0.0:F>1.0?1.0:F,q=(T-M+B*F)*(T-M+B*F)+((R-K+w*F)*(R-K+w*F)+(S-L+D*F)*(S-L+D*F)),q<3402823466385288598117041.0e14):0){s=R-K+w*F;t=T-M+B*F;r=S-L+D*F}else{q=3402823466385288598117041.0e14;s=0.0;t=0.0;r=0.0}f=(U-K-(N-K))*(U-K-(N-K))+(V-L-(P-L))*(V-L-(P-L))+(W-M-(Q-M))*(W-M-(Q-M));if(f>1.1920928955078125e-07?(n=-((N-K)*(U-K-(N-K))+(P-L)*(V-L-(P-L))+(Q-M)*(W-M-(Q-M)))/f,n=n<0.0?0.0:n>1.0?1.0:n,p=N-K+(U-K-(N-K))*n,k=P-L+(V-L-(P-L))*n,n=Q-M+(W-M-(Q-M))*n,n*n+(p*p+k*k)<q):0)q=n*n+(p*p+k*k);else{p=s;n=t;k=r}f=(R-K-(U-K))*(R-K-(U-K))+(S-L-(V-L))*(S-L-(V-L))+(T-M-(W-M))*(T-M-(W-M));if(f>1.1920928955078125e-07?(J=-((U-K)*(R-K-(U-K))+(V-L)*(S-L-(V-L))+(W-M)*(T-M-(W-M)))/f,J=J<0.0?0.0:J>1.0?1.0:J,I=U-K+(R-K-(U-K))*J,m=V-L+(S-L-(V-L))*J,J=W-M+(T-M-(W-M))*J,J*J+(I*I+m*m)<q):0){q=J*J+(I*I+m*m);p=I;n=J}else m=k}else{q=3402823466385288598117041.0e14;p=0.0;n=0.0;m=0.0}while(0);I=K-+g[Y+24>>2];J=L-+g[Y+28>>2];u=M-+g[Y+32>>2];u=+g[b+12>>2]+ +O(+(I*I+J*J+u*u))*2.0;if(!(q<u*u))return;r=K+p;f=L+m;k=M+n;t=+O(+(((R-r)*(P-f)-(S-f)*(N-r))*((R-r)*(P-f)-(S-f)*(N-r))+(((S-f)*(Q-k)-(T-k)*(P-f))*((S-f)*(Q-k)-(T-k)*(P-f))+((T-k)*(N-r)-(R-r)*(Q-k))*((T-k)*(N-r)-(R-r)*(Q-k)))));s=+O(+(((N-r)*(V-f)-(P-f)*(U-r))*((N-r)*(V-f)-(P-f)*(U-r))+(((P-f)*(W-k)-(Q-k)*(V-f))*((P-f)*(W-k)-(Q-k)*(V-f))+((Q-k)*(U-r)-(N-r)*(W-k))*((Q-k)*(U-r)-(N-r)*(W-k)))));r=+O(+(((S-f)*(U-r)-(R-r)*(V-f))*((S-f)*(U-r)-(R-r)*(V-f))+(((T-k)*(V-f)-(S-f)*(W-k))*((T-k)*(V-f)-(S-f)*(W-k))+((R-r)*(W-k)-(T-k)*(U-r))*((R-r)*(W-k)-(T-k)*(U-r)))));k=+g[Y+88>>2];V=+g[d+88>>2];W=+g[e+88>>2];f=+g[h+88>>2];f=!(V<=0.0)&!(W<=0.0)&!(f<=0.0)?V*s*(1.0/(t+s+r))+W*r*(1.0/(t+s+r))+t*(1.0/(t+s+r))*f:0.0;if(!(k+f>0.0))return;W=1.0/-+O(+q);q=p*W;p=m*W;n=n*W;o=c[b+4>>2]|0;d=c[b+8>>2]|0;l=c[(+g[o+316>>2]>+g[d+316>>2]?o+316|0:d+316|0)>>2]|0;m=k/(k+f)*+g[o+332>>2];f=f/(k+f)*+g[d+332>>2];d=c[o+832>>2]|0;if((d|0)==(c[o+836>>2]|0)?(Z=d|0?d<<1:1,(d|0)<(Z|0)):0){if(!Z)j=0;else{c[6435]=(c[6435]|0)+1;d=yc((Z*56|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}j=d;d=c[o+832>>2]|0}if((d|0)>0){e=0;do{h=j+(e*56|0)|0;b=(c[o+840>>2]|0)+(e*56|0)|0;i=h+56|0;do{c[h>>2]=c[b>>2];h=h+4|0;b=b+4|0}while((h|0)<(i|0));e=e+1|0}while((e|0)!=(d|0))}d=c[o+840>>2]|0;if(d|0){if(a[o+844>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[o+840>>2]=0}a[o+844>>0]=1;c[o+840>>2]=j;c[o+836>>2]=Z;d=c[o+832>>2]|0}Z=c[o+840>>2]|0;c[Z+(d*56|0)>>2]=Y;c[Z+(d*56|0)+4>>2]=X;g[Z+(d*56|0)+8>>2]=s*(1.0/(t+s+r));g[Z+(d*56|0)+12>>2]=r*(1.0/(t+s+r));g[Z+(d*56|0)+16>>2]=t*(1.0/(t+s+r));g[Z+(d*56|0)+20>>2]=0.0;g[Z+(d*56|0)+24>>2]=q;g[Z+(d*56|0)+28>>2]=p;g[Z+(d*56|0)+32>>2]=n;g[Z+(d*56|0)+36>>2]=0.0;g[Z+(d*56|0)+40>>2]=u;c[Z+(d*56|0)+44>>2]=l;g[Z+(d*56|0)+48>>2]=m;g[Z+(d*56|0)+52>>2]=f;c[o+832>>2]=(c[o+832>>2]|0)+1;return}function Ad(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+112|0;c[d+20>>2]=c[e+16>>2];c[d+24>>2]=c[e+20>>2];c[d+28>>2]=c[e+24>>2];c[d+32>>2]=c[e+28>>2];c[d+4>>2]=c[e>>2];c[d+8>>2]=c[e+4>>2];c[d+12>>2]=c[e+8>>2];c[d+16>>2]=c[e+12>>2];c[d+36>>2]=c[e+32>>2];c[d+40>>2]=c[e+36>>2];c[d+44>>2]=c[e+40>>2];c[d+48>>2]=c[e+44>>2];c[d+56>>2]=c[e+48>>2];a[d+60>>0]=(c[e+52>>2]|0)!=0&1;n=c[e+56>>2]|0;j=o+48|0;l=j+64|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(l|0));m=c[d+88>>2]|0;if((m|0)<(n|0)){if((c[d+92>>2]|0)<(n|0)){if(!n){f=0;g=m}else{c[6435]=(c[6435]|0)+1;f=yc(n<<6|19)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}g=c[d+88>>2]|0}if((g|0)>0){h=0;do{j=f+(h<<6)|0;k=(c[d+96>>2]|0)+(h<<6)|0;l=j+64|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));h=h+1|0}while((h|0)!=(g|0))}g=c[d+96>>2]|0;if(g|0){if(a[d+100>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0)}c[d+96>>2]=0}a[d+100>>0]=1;c[d+96>>2]=f;c[d+92>>2]=n;g=d+96|0}else g=d+96|0;f=m;do{j=(c[g>>2]|0)+(f<<6)|0;k=o+48|0;l=j+64|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));f=f+1|0}while((f|0)!=(n|0))}c[d+88>>2]=n;if((n|0)>0){f=c[d+96>>2]|0;g=0;h=c[e+64>>2]|0;while(1){c[f+(g<<6)+16>>2]=c[h+16>>2];c[f+(g<<6)+20>>2]=c[h+20>>2];c[f+(g<<6)+24>>2]=c[h+24>>2];c[f+(g<<6)+28>>2]=c[h+28>>2];c[f+(g<<6)>>2]=c[h>>2];c[f+(g<<6)+4>>2]=c[h+4>>2];c[f+(g<<6)+8>>2]=c[h+8>>2];c[f+(g<<6)+12>>2]=c[h+12>>2];c[f+(g<<6)+32>>2]=c[h+32>>2];c[f+(g<<6)+36>>2]=c[h+36>>2];c[f+(g<<6)+40>>2]=c[h+40>>2];g=g+1|0;if((g|0)==(n|0))break;else h=h+48|0}}k=c[e+60>>2]|0;c[o+32>>2]=0;c[o+32+4>>2]=0;c[o+32+8>>2]=0;c[o+32+12>>2]=0;j=c[d+128>>2]|0;if((j|0)<(k|0)){if((c[d+132>>2]|0)<(k|0)){if(!k){f=0;g=j}else{c[6435]=(c[6435]|0)+1;f=yc((k<<4|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}g=c[d+128>>2]|0}if((g|0)>0){h=0;do{n=f+(h<<4)|0;m=(c[d+136>>2]|0)+(h<<4)|0;c[n>>2]=c[m>>2];c[n+4>>2]=c[m+4>>2];c[n+8>>2]=c[m+8>>2];c[n+12>>2]=c[m+12>>2];h=h+1|0}while((h|0)!=(g|0))}g=c[d+136>>2]|0;if(g|0){if(a[d+140>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0)}c[d+136>>2]=0}a[d+140>>0]=1;c[d+136>>2]=f;c[d+132>>2]=k;g=d+136|0}else g=d+136|0;f=j;do{n=(c[g>>2]|0)+(f<<4)|0;c[n>>2]=c[o+32>>2];c[n+4>>2]=c[o+32+4>>2];c[n+8>>2]=c[o+32+8>>2];c[n+12>>2]=c[o+32+12>>2];f=f+1|0}while((f|0)!=(k|0))}c[d+128>>2]=k;if((k|0)>0){f=c[d+136>>2]|0;g=0;h=c[e+68>>2]|0;while(1){c[f+(g<<4)+12>>2]=c[h+12>>2];b[f+(g<<4)+6>>1]=b[h+6>>1]|0;b[f+(g<<4)+8>>1]=b[h+8>>1]|0;b[f+(g<<4)+10>>1]=b[h+10>>1]|0;b[f+(g<<4)>>1]=b[h>>1]|0;b[f+(g<<4)+2>>1]=b[h+2>>1]|0;b[f+(g<<4)+4>>1]=b[h+4>>1]|0;g=g+1|0;if((g|0)==(k|0))break;else h=h+16|0}}c[d+144>>2]=c[e+76>>2];k=c[e+80>>2]|0;j=c[d+152>>2]|0;if((j|0)<(k|0)){if((c[d+156>>2]|0)<(k|0)){if(!k){f=0;g=j}else{c[6435]=(c[6435]|0)+1;f=yc(k<<5|19)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}g=c[d+152>>2]|0}if((g|0)>0){h=0;do{n=f+(h<<5)|0;m=(c[d+160>>2]|0)+(h<<5)|0;c[n>>2]=c[m>>2];c[n+4>>2]=c[m+4>>2];c[n+8>>2]=c[m+8>>2];c[n+12>>2]=c[m+12>>2];c[n+16>>2]=c[m+16>>2];c[n+20>>2]=c[m+20>>2];c[n+24>>2]=c[m+24>>2];c[n+28>>2]=c[m+28>>2];h=h+1|0}while((h|0)!=(g|0))}g=c[d+160>>2]|0;if(g|0){if(a[d+164>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[g+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=f;c[d+156>>2]=k;g=d+160|0}else g=d+160|0;f=j;do{n=(c[g>>2]|0)+(f<<5)|0;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];c[n+16>>2]=c[o+16>>2];c[n+20>>2]=c[o+20>>2];c[n+24>>2]=c[o+24>>2];c[n+28>>2]=c[o+28>>2];f=f+1|0}while((f|0)!=(k|0))}c[d+152>>2]=k;if((k|0)<=0){i=o;return}g=c[d+160>>2]|0;h=0;f=c[e+72>>2]|0;while(1){b[g+(h<<5)+6>>1]=b[f+14>>1]|0;b[g+(h<<5)+8>>1]=b[f+16>>1]|0;b[g+(h<<5)+10>>1]=b[f+18>>1]|0;b[g+(h<<5)>>1]=b[f+8>>1]|0;b[g+(h<<5)+2>>1]=b[f+10>>1]|0;b[g+(h<<5)+4>>1]=b[f+12>>1]|0;c[g+(h<<5)+12>>2]=c[f>>2];c[g+(h<<5)+16>>2]=c[f+4>>2];h=h+1|0;if((h|0)==(k|0))break;else f=f+20|0}i=o;return}function Bd(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;c[b>>2]=3180;d=c[b+192>>2]|0;if(d|0)Ab[c[(c[d>>2]|0)+4>>2]&255](d);a:do if((c[b+1112>>2]|0)>0)do{h=c[c[b+1120>>2]>>2]|0;d=c[h+348>>2]|0;if(d|0){hh(b+1048|0,d)|0;e=c[b+1052>>2]|0;if(e|0){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0)}c[b+1052>>2]=d;c[b+1060>>2]=(c[b+1060>>2]|0)+-1}Fk(h);if(h|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}d=c[b+1112>>2]|0;if((d|0)<=0)break a;g=c[b+1120>>2]|0;e=0;do{f=g+(e<<2)|0;if((c[f>>2]|0)==(h|0)){i=18;break}e=e+1|0}while((e|0)<(d|0));if((i|0)==18){i=0;if((e|0)<(d|0)){c[f>>2]=c[g+(d+-1<<2)>>2];c[(c[b+1120>>2]|0)+(d+-1<<2)>>2]=h;c[b+1112>>2]=d+-1;d=d+-1|0}}}while((d|0)>0);while(0);d=c[b+872>>2]|0;if((d|0)>0){f=0;do{e=c[(c[b+880>>2]|0)+(f<<2)>>2]|0;if(e){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);d=c[b+872>>2]|0}f=f+1|0}while((f|0)<(d|0))}d=c[b+852>>2]|0;if((d|0)>0){f=0;do{e=c[(c[b+860>>2]|0)+(f<<2)>>2]|0;if(e){c[6436]=(c[6436]|0)+1;hd(c[e+-4>>2]|0);d=c[b+852>>2]|0}f=f+1|0}while((f|0)<(d|0))}d=c[b+1244>>2]|0;if(d|0){if(a[b+1248>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+1244>>2]=0}a[b+1248>>0]=1;c[b+1244>>2]=0;c[b+1236>>2]=0;c[b+1240>>2]=0;d=c[b+1140>>2]|0;if(d|0){if(a[b+1144>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+1140>>2]=0}a[b+1144>>0]=1;c[b+1140>>2]=0;c[b+1132>>2]=0;c[b+1136>>2]=0;d=c[b+1120>>2]|0;if(d|0){if(a[b+1124>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+1120>>2]=0}a[b+1124>>0]=1;c[b+1120>>2]=0;c[b+1112>>2]=0;c[b+1116>>2]=0;pi(b+1048|0);pi(b+988|0);pi(b+928|0);d=c[b+880>>2]|0;if(d|0){if(a[b+884>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+880>>2]=0}a[b+884>>0]=1;c[b+880>>2]=0;c[b+872>>2]=0;c[b+876>>2]=0;d=c[b+860>>2]|0;if(d|0){if(a[b+864>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+860>>2]=0}a[b+864>>0]=1;c[b+860>>2]=0;c[b+852>>2]=0;c[b+856>>2]=0;d=c[b+840>>2]|0;if(d|0){if(a[b+844>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+840>>2]=0}a[b+844>>0]=1;c[b+840>>2]=0;c[b+832>>2]=0;c[b+836>>2]=0;d=c[b+820>>2]|0;if(d|0){if(a[b+824>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+820>>2]=0}a[b+824>>0]=1;c[b+820>>2]=0;c[b+812>>2]=0;c[b+816>>2]=0;d=c[b+800>>2]|0;if(d|0){if(a[b+804>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+800>>2]=0}a[b+804>>0]=1;c[b+800>>2]=0;c[b+792>>2]=0;c[b+796>>2]=0;d=c[b+780>>2]|0;if(d|0){if(a[b+784>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+780>>2]=0}a[b+784>>0]=1;c[b+780>>2]=0;c[b+772>>2]=0;c[b+776>>2]=0;d=c[b+760>>2]|0;if(d|0){if(a[b+764>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+760>>2]=0}a[b+764>>0]=1;c[b+760>>2]=0;c[b+752>>2]=0;c[b+756>>2]=0;d=c[b+740>>2]|0;if(d|0){if(a[b+744>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+740>>2]=0}a[b+744>>0]=1;c[b+740>>2]=0;c[b+732>>2]=0;c[b+736>>2]=0;d=c[b+720>>2]|0;if(d|0){if(a[b+724>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+720>>2]=0}a[b+724>>0]=1;c[b+720>>2]=0;c[b+712>>2]=0;c[b+716>>2]=0;d=c[b+700>>2]|0;if(d|0){if(a[b+704>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+700>>2]=0}a[b+704>>0]=1;c[b+700>>2]=0;c[b+692>>2]=0;c[b+696>>2]=0;d=c[b+512>>2]|0;if(d|0){if(a[b+516>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+512>>2]=0}a[b+516>>0]=1;c[b+512>>2]=0;c[b+504>>2]=0;c[b+508>>2]=0;d=c[b+492>>2]|0;if(d|0){if(a[b+496>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+492>>2]=0}a[b+496>>0]=1;c[b+492>>2]=0;c[b+484>>2]=0;c[b+488>>2]=0;d=c[b+444>>2]|0;if(d|0){if(!((a[b+448>>0]&1)==0|(d|0)==0)){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+444>>2]=0}a[b+448>>0]=1;c[b+444>>2]=0;c[b+436>>2]=0;c[b+440>>2]=0;d=c[b+424>>2]|0;if(d|0){if(!((a[b+428>>0]&1)==0|(d|0)==0)){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+424>>2]=0}a[b+428>>0]=1;c[b+424>>2]=0;c[b+416>>2]=0;c[b+420>>2]=0;d=c[b+404>>2]|0;if(d|0){if(!((a[b+408>>0]&1)==0|(d|0)==0)){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+404>>2]=0}a[b+408>>0]=1;c[b+404>>2]=0;c[b+396>>2]=0;c[b+400>>2]=0;d=c[b+276>>2]|0;if(!d){a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;i=b+272|0;c[i>>2]=0;c[b>>2]=5008;return}if(a[b+280>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+276>>2]=0;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;i=b+272|0;c[i>>2]=0;c[b>>2]=5008;return}function Cd(a,d,f,h,j,k,l,m,n){a=a|0;d=d|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;i=i+16|0;Bj(a,w+6|0,+g[d>>2],+g[d+4>>2],+g[d+8>>2],0);Bj(a,w,+g[f>>2],+g[f+4>>2],+g[f+8>>2],1);v=b[a+64>>1]|0;u=c[a+60>>2]|0;b[a+64>>1]=b[u+((v&65535)<<6)+48>>1]|0;o=(b[a+56>>1]|0)+1<<16>>16;b[a+56>>1]=o;c[u+((v&65535)<<6)+12>>2]=v&65535;c[u+((v&65535)<<6)>>2]=j;b[u+((v&65535)<<6)+4>>1]=k;b[u+((v&65535)<<6)+6>>1]=l;c[u+((v&65535)<<6)+8>>2]=n;q=(o&65535)<<1&65534;b[u+54>>1]=(e[u+54>>1]|0)+2;p=c[a+68>>2]|0;n=e[p+(q+-1<<2)>>1]|e[p+(q+-1<<2)+2>>1]<<16;b[p+((q|1)<<2)>>1]=n;b[p+((q|1)<<2)+2>>1]=n>>>16;p=c[a+68>>2]|0;b[p+(q+-1<<2)>>1]=b[w+6>>1]|0;b[p+(q+-1<<2)+2>>1]=v;b[p+(q<<2)>>1]=b[w>>1]|0;b[p+(q<<2)+2>>1]=v;b[u+((v&65535)<<6)+48>>1]=q+-1;b[u+((v&65535)<<6)+54>>1]=(o&65535)<<1;p=(c[a+60>>2]|0)+56|0;b[p>>1]=(e[p>>1]|0)+2;p=c[a+72>>2]|0;n=e[p+(q+-1<<2)>>1]|e[p+(q+-1<<2)+2>>1]<<16;b[p+((q|1)<<2)>>1]=n;b[p+((q|1)<<2)+2>>1]=n>>>16;p=c[a+72>>2]|0;b[p+(q+-1<<2)>>1]=b[w+6+2>>1]|0;b[p+(q+-1<<2)+2>>1]=v;b[p+(q<<2)>>1]=b[w+2>>1]|0;b[p+(q<<2)+2>>1]=v;b[u+((v&65535)<<6)+50>>1]=q+-1;b[u+((v&65535)<<6)+56>>1]=(o&65535)<<1;p=(c[a+60>>2]|0)+58|0;b[p>>1]=(e[p>>1]|0)+2;p=c[a+76>>2]|0;n=e[p+(q+-1<<2)>>1]|e[p+(q+-1<<2)+2>>1]<<16;b[p+((q|1)<<2)>>1]=n;b[p+((q|1)<<2)+2>>1]=n>>>16;p=c[a+76>>2]|0;b[p+(q+-1<<2)>>1]=b[w+6+4>>1]|0;b[p+(q+-1<<2)+2>>1]=v;b[p+(q<<2)>>1]=b[w+4>>1]|0;b[p+(q<<2)+2>>1]=v;b[u+((v&65535)<<6)+52>>1]=q+-1;b[u+((v&65535)<<6)+58>>1]=(o&65535)<<1;o=c[a+68>>2]|0;q=e[u+((v&65535)<<6)+48>>1]|0;p=c[a+60>>2]|0;n=b[o+(q<<2)+-4>>1]|0;if((e[o+(q<<2)>>1]|0)<(n&65535)){s=p+((e[o+(q<<2)+2>>1]|0)<<6)+48|0;r=o+(q<<2)|0;q=o+(q<<2)+-4|0;while(1){o=e[r+-2>>1]|0;if(!(n&1)){t=p+(o<<6)+48|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}else{t=p+(o<<6)+54|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}b[s>>1]=(b[s>>1]|0)+-1<<16>>16;o=e[r>>1]|e[r+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[r>>1]=n;b[r+2>>1]=n>>>16;b[q>>1]=o;b[q+2>>1]=o>>>16;o=r+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[o>>1]|0)>=(n&65535))break;p=c[a+60>>2]|0;r=o}o=c[a+68>>2]|0}n=e[u+((v&65535)<<6)+54>>1]|0;q=o+(n<<2)|0;p=b[q+-4>>1]|0;a:do if((e[q>>1]|0)<(p&65535)){s=c[a+60>>2]|0;t=s+((e[o+(n<<2)+2>>1]|0)<<6)+54|0;n=p;r=q;p=q+-4|0;while(1){o=e[r+-2>>1]|0;if(!(n&1)){s=s+(o<<6)+48|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}else{s=s+(o<<6)+54|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}b[t>>1]=(b[t>>1]|0)+-1<<16>>16;o=e[r>>1]|e[r+2>>1]<<16;n=e[p>>1]|e[p+2>>1]<<16;b[r>>1]=n;b[r+2>>1]=n>>>16;b[p>>1]=o;b[p+2>>1]=o>>>16;o=r+-4|0;p=p+-4|0;n=b[p>>1]|0;if((e[o>>1]|0)>=(n&65535))break a;s=c[a+60>>2]|0;r=o}}while(0);o=c[a+72>>2]|0;q=e[u+((v&65535)<<6)+50>>1]|0;p=c[a+60>>2]|0;n=b[o+(q<<2)+-4>>1]|0;if((e[o+(q<<2)>>1]|0)<(n&65535)){s=p+((e[o+(q<<2)+2>>1]|0)<<6)+50|0;r=o+(q<<2)|0;q=o+(q<<2)+-4|0;while(1){o=e[r+-2>>1]|0;if(!(n&1)){t=p+(o<<6)+50|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}else{t=p+(o<<6)+56|0;b[t>>1]=(b[t>>1]|0)+1<<16>>16}b[s>>1]=(b[s>>1]|0)+-1<<16>>16;o=e[r>>1]|e[r+2>>1]<<16;n=e[q>>1]|e[q+2>>1]<<16;b[r>>1]=n;b[r+2>>1]=n>>>16;b[q>>1]=o;b[q+2>>1]=o>>>16;o=r+-4|0;q=q+-4|0;n=b[q>>1]|0;if((e[o>>1]|0)>=(n&65535))break;p=c[a+60>>2]|0;r=o}o=c[a+72>>2]|0}n=e[u+((v&65535)<<6)+56>>1]|0;q=o+(n<<2)|0;p=b[q+-4>>1]|0;b:do if((e[q>>1]|0)<(p&65535)){s=c[a+60>>2]|0;t=s+((e[o+(n<<2)+2>>1]|0)<<6)+56|0;n=p;r=q;p=q+-4|0;while(1){o=e[r+-2>>1]|0;if(!(n&1)){s=s+(o<<6)+50|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}else{s=s+(o<<6)+56|0;b[s>>1]=(b[s>>1]|0)+1<<16>>16}b[t>>1]=(b[t>>1]|0)+-1<<16>>16;o=e[r>>1]|e[r+2>>1]<<16;n=e[p>>1]|e[p+2>>1]<<16;b[r>>1]=n;b[r+2>>1]=n>>>16;b[p>>1]=o;b[p+2>>1]=o>>>16;o=r+-4|0;p=p+-4|0;n=b[p>>1]|0;if((e[o>>1]|0)>=(n&65535))break b;s=c[a+60>>2]|0;r=o}}while(0);wh(a,2,b[u+((v&65535)<<6)+52>>1]|0);uh(a,2,b[u+((v&65535)<<6)+58>>1]|0,m);o=c[a+60>>2]|0;n=c[a+108>>2]|0;if(!n){j=o+((v&65535)<<6)|0;i=w;return j|0}c[o+((v&65535)<<6)+60>>2]=gc[c[(c[n>>2]|0)+8>>2]&3](n,d,f,h,j,k,l,m,0)|0;j=o+((v&65535)<<6)|0;i=w;return j|0}function Dd(b,d,e,f,h,i,j,k,l,m,n,o,p){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;A=_(c[l+24>>2]|0,m)|0;m=a[d+44>>0]|0;z=c[d+56>>2]|0;if(!(m<<24>>24!=0|(z|0)!=0)){A=0;return A|0}C=c[(o|0?l+12|0:l+8|0)>>2]|0;B=c[(o|0?l+20|0:l+16|0)>>2]|0;c[C+(A<<2)>>2]=c[n>>2];c[C+(A+1<<2)>>2]=c[n+4>>2];c[C+(A+2<<2)>>2]=c[n+8>>2];g[B+(A<<2)>>2]=-+g[n>>2];g[B+(A+1<<2)>>2]=-+g[n+4>>2];g[B+(A+2<<2)>>2]=-+g[n+8>>2];do if(!o){q=+g[b+1176>>2];if(!(a[b+1301>>0]|0)){t=q-+g[e+48>>2];w=+g[b+1180>>2]-+g[e+52>>2];x=+g[b+1184>>2]-+g[e+56>>2];v=+g[n+8>>2];s=+g[n+4>>2];u=+g[n>>2];C=c[l+12>>2]|0;g[C+(A<<2)>>2]=w*v-x*s;g[C+(A+1<<2)>>2]=x*u-t*v;g[C+(A+2<<2)>>2]=t*s-w*u;u=+g[b+1176>>2]-+g[f+48>>2];w=+g[b+1180>>2]-+g[f+52>>2];s=+g[b+1184>>2]-+g[f+56>>2];t=+g[n+8>>2];v=+g[n+4>>2];x=+g[n>>2];C=c[l+20>>2]|0;g[C+(A<<2)>>2]=-(w*t-s*v);g[C+(A+1<<2)>>2]=-(s*x-u*t);g[C+(A+2<<2)>>2]=-(u*v-w*x);break}I=q-+g[f+48>>2];H=+g[b+1180>>2]-+g[f+52>>2];F=+g[b+1184>>2]-+g[f+56>>2];u=+g[n>>2];G=+g[n+4>>2];E=+g[n+8>>2];K=+g[b+1112>>2]-+g[e+48>>2];t=+g[b+1116>>2]-+g[e+52>>2];q=+g[b+1120>>2]-+g[e+56>>2];v=+g[d+52>>2]-+g[d+48>>2];J=u*(u*K+G*t+E*q)+u*v-u*(I*u+H*G+F*E);D=G*(u*K+G*t+E*q)+G*v-G*(I*u+H*G+F*E);v=E*(u*K+G*t+E*q)+E*v-E*(I*u+H*G+F*E);x=+g[b+1272>>2];w=+g[b+1276>>2];s=E*(t-G*(u*K+G*t+E*q)+x*D)-G*(q-E*(u*K+G*t+E*q)+x*v);r=u*(q-E*(u*K+G*t+E*q)+x*v)-E*(K-u*(u*K+G*t+E*q)+x*J);q=G*(K-u*(u*K+G*t+E*q)+x*J)-u*(t-G*(u*K+G*t+E*q)+x*D);t=(H-G*(I*u+H*G+F*E)-w*D)*E-(F-E*(I*u+H*G+F*E)-w*v)*G;v=(F-E*(I*u+H*G+F*E)-w*v)*u-(I-u*(I*u+H*G+F*E)-w*J)*E;u=(I-u*(I*u+H*G+F*E)-w*J)*G-(H-G*(I*u+H*G+F*E)-w*D)*u;if(!((p|0)!=0|(a[b+1280>>0]|0)==0)){t=w*t;v=w*v;u=w*u;s=x*s;r=x*r;q=x*q}C=(c[l+12>>2]|0)+(A<<2)|0;g[C>>2]=s;g[C+4>>2]=r;g[C+8>>2]=q;C=c[l+20>>2]|0;g[C+(A<<2)>>2]=-t;g[C+(A+1<<2)>>2]=-v;g[C+(A+2<<2)>>2]=-u}while(0);if(z|0?+g[d>>2]==+g[d+4>>2]:0){m=c[l+28>>2]|0;g[m+(A<<2)>>2]=0.0;q=0.0;e=l+28|0}else y=11;do if((y|0)==11){e=c[l+28>>2]|0;g[e+(A<<2)>>2]=0.0;if(!(m<<24>>24)){if(z|0){m=e;q=0.0;e=l+28|0;break}else m=1;return m|0}c[(c[l+32>>2]|0)+(A<<2)>>2]=c[d+28>>2];if(z|0){m=e;q=+g[e+(A<<2)>>2];e=l+28|0;break}v=+g[d+8>>2];q=o|0?v:-v;r=+g[d+52>>2];s=+g[d>>2];t=+g[d+4>>2];u=+g[l>>2]*+g[d+32>>2];do if(!(s>t))if(!(s==t)){if(q/u<0.0)if(r>=s?s-q/u>r:0){q=(s-r)/(q/u);break}else{q=r<s?0.0:1.0;break}if(q/u>0.0)if(r<=t?t-q/u<r:0){q=(t-r)/(q/u);break}else{q=r>t?0.0:1.0;break}else q=0.0}else q=0.0;else q=1.0;while(0);g[e+(A<<2)>>2]=q*v+ +g[e+(A<<2)>>2];g[(c[l+36>>2]|0)+(A<<2)>>2]=-+g[d+12>>2];c[(c[l+40>>2]|0)+(A<<2)>>2]=c[d+12>>2];C=1;return C|0}while(0);K=+g[l>>2]*+g[d+32>>2]*+g[d+48>>2];g[m+(A<<2)>>2]=q+(o|0?-K:K);c[(c[l+32>>2]|0)+(A<<2)>>2]=c[d+36>>2];if(+g[d>>2]==+g[d+4>>2]){g[(c[l+36>>2]|0)+(A<<2)>>2]=-3402823466385288598117041.0e14;g[(c[l+40>>2]|0)+(A<<2)>>2]=3402823466385288598117041.0e14;C=1;return C|0}C=c[l+40>>2]|0;g[(c[l+36>>2]|0)+(A<<2)>>2]=(z|0)==1?0.0:-3402823466385288598117041.0e14;g[C+(A<<2)>>2]=(z|0)==1?3402823466385288598117041.0e14:0.0;r=+g[d+40>>2];if(!(r>0.0)){C=1;return C|0}if(o|0){J=+g[n>>2];K=+g[n+4>>2];q=+g[n+8>>2];q=+g[j>>2]*J+ +g[j+4>>2]*K+ +g[j+8>>2]*q-(J*+g[k>>2]+K*+g[k+4>>2]+q*+g[k+8>>2])}else{J=+g[n>>2];K=+g[n+4>>2];q=+g[n+8>>2];q=+g[h>>2]*J+ +g[h+4>>2]*K+ +g[h+8>>2]*q-(J*+g[i>>2]+K*+g[i+4>>2]+q*+g[i+8>>2])}if((z|0)==1){if(!(q<0.0)){C=1;return C|0}q=-(q*r);m=(c[e>>2]|0)+(A<<2)|0;if(!(+g[m>>2]<q)){C=1;return C|0}g[m>>2]=q;C=1;return C|0}else{if(!(q>0.0)){C=1;return C|0}q=-(q*r);m=(c[e>>2]|0)+(A<<2)|0;if(!(+g[m>>2]>q)){C=1;return C|0}g[m>>2]=q;C=1;return C|0}return 0}function Ed(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var l=0.0,m=0,n=0.0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0;u=i;i=i+288|0;q=c[b+4>>2]|0;a[q+312>>0]=0;c[q>>2]=0;a[q+356>>0]=1;c[q+292>>2]=1566444395;c[q+296>>2]=1566444395;c[q+300>>2]=1566444395;g[q+304>>2]=0.0;c[q+336>>2]=0;c[q+336+4>>2]=0;c[q+336+8>>2]=0;c[q+336+12>>2]=0;a[q+336+16>>0]=0;a[q+332>>0]=a[q+332>>0]&-16;r=+g[e+48>>2]-+g[d+48>>2]-(+g[h+48>>2]-+g[f+48>>2]);s=+g[e+52>>2]-+g[d+52>>2]-(+g[h+52>>2]-+g[f+52>>2]);t=+g[e+56>>2]-+g[d+56>>2]-(+g[h+56>>2]-+g[f+56>>2]);c[u+216>>2]=9160;g[u+216+36>>2]=999999984306749440.0;a[u+216+40>>0]=0;q=c[b+8>>2]|0;p=c[b+12>>2]|0;o=c[b+4>>2]|0;c[u+136>>2]=9208;c[u+136+4>>2]=0;c[u+136+8>>2]=1065353216;c[u+136+12>>2]=0;g[u+136+16>>2]=0.0;c[u+136+20>>2]=0;c[u+136+24>>2]=o;c[u+136+28>>2]=q;c[u+136+32>>2]=p;c[u+136+36>>2]=c[q+4>>2];c[u+136+40>>2]=c[p+4>>2];g[u+136+44>>2]=+Sb[c[(c[q>>2]|0)+48>>2]&15](q);g[u+136+48>>2]=+Sb[c[(c[p>>2]|0)+48>>2]&15](p);a[u+136+52>>0]=0;c[u+136+60>>2]=-1;c[u+136+72>>2]=1;c[u+136+76>>2]=1;g[u+128>>2]=999999984306749440.0;c[u>>2]=c[d>>2];c[u+4>>2]=c[d+4>>2];c[u+8>>2]=c[d+8>>2];c[u+12>>2]=c[d+12>>2];c[u+16>>2]=c[d+16>>2];c[u+16+4>>2]=c[d+16+4>>2];c[u+16+8>>2]=c[d+16+8>>2];c[u+16+12>>2]=c[d+16+12>>2];c[u+32>>2]=c[d+32>>2];c[u+32+4>>2]=c[d+32+4>>2];c[u+32+8>>2]=c[d+32+8>>2];c[u+32+12>>2]=c[d+32+12>>2];c[u+48>>2]=c[d+48>>2];c[u+48+4>>2]=c[d+48+4>>2];c[u+48+8>>2]=c[d+48+8>>2];c[u+48+12>>2]=c[d+48+12>>2];c[u+64>>2]=c[f>>2];c[u+64+4>>2]=c[f+4>>2];c[u+64+8>>2]=c[f+8>>2];c[u+64+12>>2]=c[f+12>>2];c[u+80>>2]=c[f+16>>2];c[u+80+4>>2]=c[f+16+4>>2];c[u+80+8>>2]=c[f+16+8>>2];c[u+80+12>>2]=c[f+16+12>>2];c[u+96>>2]=c[f+32>>2];c[u+96+4>>2]=c[f+32+4>>2];c[u+96+8>>2]=c[f+32+8>>2];c[u+96+12>>2]=c[f+32+12>>2];c[u+112>>2]=c[f+48>>2];c[u+112+4>>2]=c[f+48+4>>2];c[u+112+8>>2]=c[f+48+8>>2];c[u+112+12>>2]=c[f+48+12>>2];Vc(u+136|0,u,u+216|0,0,0);p=(a[u+216+40>>0]|0)==0;q=u+216+20|0;c[u+264>>2]=c[q>>2];c[u+264+4>>2]=c[q+4>>2];c[u+264+8>>2]=c[q+8>>2];c[u+264+12>>2]=c[q+12>>2];if(p){j=0;i=u;return j|0}n=+g[u+216+36>>2];l=+g[u+216+16>>2];b=c[u+216+12>>2]|0;m=c[u+216+8>>2]|0;o=c[u+216+4>>2]|0;do if(n>1.0000000474974513e-03){l=0.0;p=0;while(1){if((p|0)>31){b=0;p=13;break}w=r*(c[k>>2]=o,+g[k>>2]);w=s*(c[k>>2]=m,+g[k>>2])+w;v=l;l=l-n/(t*(c[k>>2]=b,+g[k>>2])+w);if(!(!(l<=v)&(!(l<0.0)&!(l>1.0)))){b=0;p=13;break}zb[c[c[j>>2]>>2]&31](j,l);w=1.0-l;g[u+48>>2]=w*+g[d+48>>2]+l*+g[e+48>>2];g[u+52>>2]=w*+g[d+52>>2]+l*+g[e+52>>2];g[u+56>>2]=w*+g[d+56>>2]+l*+g[e+56>>2];g[u+112>>2]=w*+g[f+48>>2]+l*+g[h+48>>2];g[u+116>>2]=w*+g[f+52>>2]+l*+g[h+52>>2];g[u+120>>2]=w*+g[f+56>>2]+l*+g[h+56>>2];Vc(u+136|0,u,u+216|0,0,0);if(!(a[u+216+40>>0]|0)){b=0;p=13;break}n=+g[u+216+36>>2];if(n<0.0){p=8;break}c[u+264>>2]=c[q>>2];c[u+264+4>>2]=c[q+4>>2];c[u+264+8>>2]=c[q+8>>2];c[u+264+12>>2]=c[q+12>>2];b=c[u+216+12>>2]|0;m=c[u+216+8>>2]|0;o=c[u+216+4>>2]|0;if(!(n>1.0000000474974513e-03)){p=10;break}else p=p+1|0}if((p|0)==8){g[j+164>>2]=l;f=c[u+216+8>>2]|0;e=c[u+216+12>>2]|0;h=c[u+216+16>>2]|0;c[j+132>>2]=c[u+216+4>>2];c[j+136>>2]=f;c[j+140>>2]=e;c[j+144>>2]=h;c[j+148>>2]=c[q>>2];c[j+148+4>>2]=c[q+4>>2];c[j+148+8>>2]=c[q+8>>2];c[j+148+12>>2]=c[q+12>>2];j=1;i=u;return j|0}else if((p|0)==10){n=l;l=+g[u+216+16>>2];break}else if((p|0)==13){i=u;return b|0}}else n=0.0;while(0);w=r*(c[k>>2]=o,+g[k>>2]);w=s*(c[k>>2]=m,+g[k>>2])+w;if(t*(c[k>>2]=b,+g[k>>2])+w>=-+g[j+172>>2]){j=0;i=u;return j|0}g[j+164>>2]=n;c[j+132>>2]=o;c[j+136>>2]=m;c[j+140>>2]=b;g[j+144>>2]=l;c[j+148>>2]=c[u+264>>2];c[j+148+4>>2]=c[u+264+4>>2];c[j+148+8>>2]=c[u+264+8>>2];c[j+148+12>>2]=c[u+264+12>>2];j=1;i=u;return j|0}function Fd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0;m=i;i=i+240|0;c[a+4>>2]=(c[a+4>>2]|0)+1;k=c[b+36>>2]|0;j=c[d+36>>2]|0;f=c[a+8>>2]|0;K=c[(c[f+4>>2]|0)+24>>2]|0;d=c[K+(k*80|0)+64>>2]|0;b=(c[(c[a+12>>2]|0)+4>>2]|0)+24|0;e=c[(c[b>>2]|0)+(j*80|0)+64>>2]|0;f=c[f+12>>2]|0;n=+g[f>>2];I=+g[f+4>>2];J=+g[f+8>>2];q=+g[f+16>>2];s=+g[f+20>>2];u=+g[f+24>>2];r=+g[f+32>>2];v=+g[f+36>>2];D=+g[f+40>>2];w=+g[K+(k*80|0)>>2];x=+g[K+(k*80|0)+16>>2];y=+g[K+(k*80|0)+32>>2];z=+g[K+(k*80|0)+4>>2];A=+g[K+(k*80|0)+20>>2];B=+g[K+(k*80|0)+36>>2];t=+g[K+(k*80|0)+8>>2];C=+g[K+(k*80|0)+24>>2];E=+g[K+(k*80|0)+40>>2];o=+g[K+(k*80|0)+48>>2];p=+g[K+(k*80|0)+52>>2];H=+g[K+(k*80|0)+56>>2];F=+g[f+48>>2]+(n*o+I*p+J*H);G=+g[f+52>>2]+(q*o+s*p+u*H);H=+g[f+56>>2]+(r*o+v*p+D*H);g[m+176>>2]=n*w+I*x+J*y;g[m+176+4>>2]=n*z+I*A+J*B;g[m+176+8>>2]=n*t+I*C+J*E;g[m+176+12>>2]=0.0;g[m+176+16>>2]=q*w+s*x+u*y;g[m+176+20>>2]=q*z+s*A+u*B;g[m+176+24>>2]=q*t+s*C+u*E;g[m+176+28>>2]=0.0;g[m+176+32>>2]=r*w+v*x+D*y;g[m+176+36>>2]=r*z+v*A+D*B;g[m+176+40>>2]=r*t+v*C+D*E;g[m+176+44>>2]=0.0;g[m+176+48>>2]=F;g[m+176+52>>2]=G;g[m+176+56>>2]=H;g[m+176+60>>2]=0.0;f=c[(c[a+12>>2]|0)+12>>2]|0;H=+g[f>>2];G=+g[f+4>>2];F=+g[f+8>>2];E=+g[f+16>>2];D=+g[f+20>>2];C=+g[f+24>>2];v=+g[f+32>>2];t=+g[f+36>>2];r=+g[f+40>>2];b=c[b>>2]|0;B=+g[b+(j*80|0)>>2];A=+g[b+(j*80|0)+16>>2];z=+g[b+(j*80|0)+32>>2];y=+g[b+(j*80|0)+4>>2];x=+g[b+(j*80|0)+20>>2];w=+g[b+(j*80|0)+36>>2];u=+g[b+(j*80|0)+8>>2];s=+g[b+(j*80|0)+24>>2];q=+g[b+(j*80|0)+40>>2];J=+g[b+(j*80|0)+48>>2];I=+g[b+(j*80|0)+52>>2];n=+g[b+(j*80|0)+56>>2];p=+g[f+48>>2]+(H*J+G*I+F*n);o=+g[f+52>>2]+(E*J+D*I+C*n);n=+g[f+56>>2]+(v*J+t*I+r*n);g[m+112>>2]=H*B+G*A+F*z;g[m+112+4>>2]=H*y+G*x+F*w;g[m+112+8>>2]=H*u+G*s+F*q;g[m+112+12>>2]=0.0;g[m+112+16>>2]=E*B+D*A+C*z;g[m+112+20>>2]=E*y+D*x+C*w;g[m+112+24>>2]=E*u+D*s+C*q;g[m+112+28>>2]=0.0;g[m+112+32>>2]=v*B+t*A+r*z;g[m+112+36>>2]=v*y+t*x+r*w;g[m+112+40>>2]=v*u+t*s+r*q;g[m+112+44>>2]=0.0;g[m+112+48>>2]=p;g[m+112+52>>2]=o;g[m+112+56>>2]=n;g[m+112+60>>2]=0.0;mc[c[(c[d>>2]|0)+8>>2]&127](d,m+176|0,m+96|0,m+80|0);mc[c[(c[e>>2]|0)+8>>2]&127](e,m+112|0,m+64|0,m+48|0);if(!(+g[m+96>>2]>+g[m+48>>2])?!(+g[m+80>>2]<+g[m+64>>2]):0)b=1;else b=0;if(!(!(+g[m+96+8>>2]>+g[m+48+8>>2])?!(+g[m+80+8>>2]<+g[m+64+8>>2]):0))b=0;if(+g[m+96+4>>2]>+g[m+48+4>>2]){i=m;return}if(+g[m+80+4>>2]<+g[m+64+4>>2]|b^1){i=m;return}f=c[a+8>>2]|0;b=c[f+8>>2]|0;c[m+24>>2]=f;c[m+24+4>>2]=d;c[m+24+8>>2]=b;c[m+24+12>>2]=m+176;c[m+24+16>>2]=-1;c[m+24+20>>2]=k;b=c[a+12>>2]|0;f=c[b+8>>2]|0;c[m>>2]=b;c[m+4>>2]=e;c[m+8>>2]=f;c[m+12>>2]=m+112;c[m+16>>2]=-1;c[m+20>>2]=j;f=c[a+28>>2]|0;c[6423]=(c[6423]|0)+1;b=((j<<16|k)+~((j<<16|k)<<15)>>10^(j<<16|k)+~((j<<16|k)<<15))*9|0;b=(c[f+12>>2]|0)+-1&((b>>6^b)+~((b>>6^b)<<11)>>16^(b>>6^b)+~((b>>6^b)<<11));a:do if((b|0)<(c[f+32>>2]|0)?(h=c[(c[f+40>>2]|0)+(b<<2)>>2]|0,(h|0)!=-1):0){e=c[f+16>>2]|0;b=h;while(1){d=e+(b*12|0)|0;if((c[d>>2]|0)==(k|0)?(c[e+(b*12|0)+4>>2]|0)==(j|0):0)break;b=c[(c[f+60>>2]|0)+(b<<2)>>2]|0;if((b|0)==-1){l=16;break a}}if(d)b=c[e+(b*12|0)+8>>2]|0;else l=16}else l=16;while(0);if((l|0)==16){b=c[a+16>>2]|0;b=Ib[c[(c[b>>2]|0)+8>>2]&31](b,m+24|0,m,c[a+32>>2]|0)|0;K=c[a+28>>2]|0;c[(Ob[c[(c[K>>2]|0)+12>>2]&63](K,k,j)|0)+8>>2]=b}K=c[a+24>>2]|0;h=c[K+8>>2]|0;l=c[K+12>>2]|0;c[K+8>>2]=m+24;c[K+12>>2]=m;ic[c[(c[K>>2]|0)+8>>2]&127](K,-1,k);K=c[a+24>>2]|0;ic[c[(c[K>>2]|0)+12>>2]&127](K,-1,j);yb[c[(c[b>>2]|0)+8>>2]&31](b,m+24|0,m,c[a+20>>2]|0,c[a+24>>2]|0);K=c[a+24>>2]|0;c[K+8>>2]=h;c[K+12>>2]=l;i=m;return}function Gd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,j=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0;z=i;i=i+48|0;switch(c[b+4>>2]|0){case 8:{c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;i=z;return}case 0:{w=+g[b+28>>2];x=+g[b+28+4>>2];x=+g[d+4>>2]>=0.0?x:-x;y=+g[b+28+8>>2];y=+g[d+8>>2]>=0.0?y:-y;g[a>>2]=+g[d>>2]>=0.0?w:-w;g[a+4>>2]=x;g[a+8>>2]=y;g[a+12>>2]=0.0;i=z;return}case 1:{u=+g[d>>2];v=+g[d+4>>2];y=+g[d+8>>2];x=u*+g[b+56>>2]+v*+g[b+56+4>>2]+y*+g[b+56+8>>2];w=u*+g[b+56+16>>2]+v*+g[b+56+20>>2]+y*+g[b+56+24>>2];y=u*+g[b+56+32>>2]+v*+g[b+56+36>>2]+y*+g[b+56+40>>2];d=x<w?(w<y?2:1):x<y?2:0;o=c[b+56+(d<<4)+4>>2]|0;r=c[b+56+(d<<4)+8>>2]|0;c[a>>2]=c[b+56+(d<<4)>>2];c[a+4>>2]=o;c[a+8>>2]=r;g[a+12>>2]=0.0;i=z;return}case 13:{c[z+32>>2]=c[b+28>>2];c[z+32+4>>2]=c[b+28+4>>2];c[z+32+8>>2]=c[b+28+8>>2];c[z+32+12>>2]=c[b+28+12>>2];c[z+16>>2]=c[d>>2];f=c[d+4>>2]|0;c[z+16+4>>2]=f;r=c[d+8>>2]|0;c[z+16+8>>2]=r;g[z+16+12>>2]=0.0;d=c[b+52>>2]|0;e=(c[k>>2]=r,+g[k>>2]);switch(d|0){case 2:{e=(c[k>>2]=f,+g[k>>2]);f=0;b=2;o=1;break}case 1:{f=0;b=1;o=2;break}default:{f=1;b=0;o=2}}n=+g[z+32+(f<<2)>>2];l=+g[z+32+(d<<2)>>2];m=+g[z+16+(f<<2)>>2];h=+O(+(m*m+e*e));j=+g[z+16+(b<<2)>>2];if(h!=0.0){g[z+(f<<2)>>2]=m*(n/h);g[z+(b<<2)>>2]=j<0.0?-l:l;g[z+(o<<2)>>2]=n/h*e;c[a>>2]=c[z>>2];c[a+4>>2]=c[z+4>>2];c[a+8>>2]=c[z+8>>2]}else{g[z+(f<<2)>>2]=n;g[z+(b<<2)>>2]=j<0.0?-l:l;g[z+(o<<2)>>2]=0.0;c[a>>2]=c[z>>2];c[a+4>>2]=c[z+4>>2];c[a+8>>2]=c[z+8>>2]}g[a+12>>2]=0.0;i=z;return}case 10:{e=+g[d>>2];h=+g[d+4>>2];j=+g[d+8>>2];o=c[b+52>>2]|0;v=+g[b+28+(o<<2)>>2];l=+g[b+28+(((o+2|0)%3|0)<<2)>>2];if(e*e+h*h+j*j<9.999999747378752e-05){y=1.0;x=0.0;w=0.0}else{w=1.0/+O(+(e*e+h*h+j*j));y=e*w;x=h*w;w=j*w}c[z+32>>2]=0;c[z+32+4>>2]=0;c[z+32+8>>2]=0;c[z+32+12>>2]=0;g[z+32+(o<<2)>>2]=v;q=l*y;t=l*x;u=l*w;s=+g[b+44>>2];m=y*s;p=x*s;s=w*s;e=q+ +g[z+32>>2]-m;h=t+ +g[z+32+4>>2]-p;l=u+ +g[z+32+8>>2]-s;j=w*l+(y*e+x*h);if(j>-999999984306749440.0){b=(g[k>>2]=e,c[k>>2]|0);f=(g[k>>2]=h,c[k>>2]|0);n=j;d=(g[k>>2]=l,c[k>>2]|0)}else{n=-999999984306749440.0;b=0;d=0;f=0}c[z+32>>2]=0;c[z+32+4>>2]=0;c[z+32+8>>2]=0;c[z+32+12>>2]=0;g[z+32+(o<<2)>>2]=-v;j=q+ +g[z+32>>2]-m;h=t+ +g[z+32+4>>2]-p;e=u+ +g[z+32+8>>2]-s;if(w*e+(y*j+x*h)>n){b=(g[k>>2]=j,c[k>>2]|0);f=(g[k>>2]=h,c[k>>2]|0);d=(g[k>>2]=e,c[k>>2]|0)}c[a>>2]=b;c[a+4>>2]=f;c[a+8>>2]=d;g[a+12>>2]=0.0;i=z;return}case 5:{r=c[b+92>>2]|0;o=c[b+96>>2]|0;p=+g[b+12>>2];q=+g[b+16>>2];n=+g[b+20>>2];l=+g[d>>2]*p;m=+g[d+4>>2]*q;e=+g[d+8>>2]*n;if((o|0)>0){b=0;j=-3402823466385288598117041.0e14;f=-1;while(1){h=l*+g[r+(b<<4)>>2]+m*+g[r+(b<<4)+4>>2]+e*+g[r+(b<<4)+8>>2];d=h>j;f=d?b:f;b=b+1|0;if((b|0)==(o|0))break;else j=d?h:j}}else f=-1;x=q*+g[r+(f<<4)+4>>2];y=n*+g[r+(f<<4)+8>>2];g[a>>2]=p*+g[r+(f<<4)>>2];g[a+4>>2]=x;g[a+8>>2]=y;g[a+12>>2]=0.0;i=z;return}case 4:{r=c[b+104>>2]|0;o=c[b+96>>2]|0;p=+g[b+12>>2];q=+g[b+16>>2];n=+g[b+20>>2];l=+g[d>>2]*p;m=+g[d+4>>2]*q;e=+g[d+8>>2]*n;if((o|0)>0){b=0;j=-3402823466385288598117041.0e14;f=-1;while(1){h=l*+g[r+(b<<4)>>2]+m*+g[r+(b<<4)+4>>2]+e*+g[r+(b<<4)+8>>2];d=h>j;f=d?b:f;b=b+1|0;if((b|0)==(o|0))break;else j=d?h:j}}else f=-1;x=q*+g[r+(f<<4)+4>>2];y=n*+g[r+(f<<4)+8>>2];g[a>>2]=p*+g[r+(f<<4)>>2];g[a+4>>2]=x;g[a+8>>2]=y;g[a+12>>2]=0.0;i=z;return}default:{ic[c[(c[b>>2]|0)+68>>2]&127](a,b,d);i=z;return}}}function Hd(d,e,f,h){d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0.0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0,y=0.0,z=0,A=0.0,B=0.0;j=+g[e>>2];m=(g[k>>2]=j,c[k>>2]|0);r=j<999999984306749440.0?m:1566444395;i=+g[e+4>>2];o=(g[k>>2]=i,c[k>>2]|0);t=i<999999984306749440.0?o:1566444395;y=+g[e+8>>2];q=(g[k>>2]=y,c[k>>2]|0);z=y<999999984306749440.0?q:1566444395;m=j>-999999984306749440.0?m:-581039253;o=i>-999999984306749440.0?o:-581039253;q=y>-999999984306749440.0?q:-581039253;y=+g[e+16>>2];x=y<(c[k>>2]=r,+g[k>>2]);l=(g[k>>2]=y,c[k>>2]|0);r=x?l:r;i=+g[e+20>>2];x=i<(c[k>>2]=t,+g[k>>2]);n=(g[k>>2]=i,c[k>>2]|0);t=x?n:t;j=+g[e+24>>2];x=j<(c[k>>2]=z,+g[k>>2]);p=(g[k>>2]=j,c[k>>2]|0);z=x?p:z;x=(c[k>>2]=m,+g[k>>2])<y?l:m;s=(c[k>>2]=o,+g[k>>2])<i?n:o;q=(c[k>>2]=q,+g[k>>2])<j?p:q;y=+g[e+32>>2];m=y<(c[k>>2]=r,+g[k>>2]);o=(g[k>>2]=y,c[k>>2]|0);r=m?o:r;j=+g[e+36>>2];m=j<(c[k>>2]=t,+g[k>>2]);p=(g[k>>2]=j,c[k>>2]|0);m=m?p:t;i=+g[e+40>>2];l=i<(c[k>>2]=z,+g[k>>2]);n=(g[k>>2]=i,c[k>>2]|0);l=l?n:z;o=(c[k>>2]=x,+g[k>>2])<y?o:x;p=(c[k>>2]=s,+g[k>>2])<j?p:s;q=(c[k>>2]=q,+g[k>>2])<i?n:q;i=(c[k>>2]=o,+g[k>>2]);j=(c[k>>2]=r,+g[k>>2]);if(i-j<2.0000000949949026e-03){o=(g[k>>2]=i+1.0000000474974513e-03,c[k>>2]|0);n=(g[k>>2]=j+-1.0000000474974513e-03,c[k>>2]|0)}else n=r;i=(c[k>>2]=p,+g[k>>2]);j=(c[k>>2]=m,+g[k>>2]);if(i-j<2.0000000949949026e-03){p=(g[k>>2]=i+1.0000000474974513e-03,c[k>>2]|0);m=(g[k>>2]=j+-1.0000000474974513e-03,c[k>>2]|0)}i=(c[k>>2]=q,+g[k>>2]);j=(c[k>>2]=l,+g[k>>2]);if(i-j<2.0000000949949026e-03){q=(g[k>>2]=i+1.0000000474974513e-03,c[k>>2]|0);l=(g[k>>2]=j+-1.0000000474974513e-03,c[k>>2]|0)}r=c[d+8>>2]|0;j=+g[r+4>>2];y=(c[k>>2]=n,+g[k>>2])-j;i=+g[r+8>>2];u=(c[k>>2]=m,+g[k>>2])-i;B=+g[r+12>>2];v=+g[r+36>>2];w=+g[r+40>>2];A=+g[r+44>>2];r=~~(((c[k>>2]=l,+g[k>>2])-B)*A)&65534;j=(c[k>>2]=o,+g[k>>2])-j;i=(c[k>>2]=p,+g[k>>2])-i;q=(~~(((c[k>>2]=q,+g[k>>2])-B)*A+1.0)&65535|1)&65535;o=c[d+4>>2]|0;m=c[o+4>>2]|0;if((m|0)!=(c[o+8>>2]|0)){d=m;z=o+12|0;z=c[z>>2]|0;x=z+(d<<4)|0;b[x>>1]=~~(y*v)&65534;x=z+(d<<4)+2|0;b[x>>1]=~~(u*w)&65534;x=z+(d<<4)+4|0;b[x>>1]=r;x=z+(d<<4)+6|0;b[x>>1]=~~(j*v+1.0)&65535|1;x=z+(d<<4)+8|0;b[x>>1]=~~(i*w+1.0)&65535|1;x=z+(d<<4)+10|0;b[x>>1]=q;d=z+(d<<4)+12|0;c[d>>2]=f<<21|h;h=c[o+4>>2]|0;h=h+1|0;c[o+4>>2]=h;return}p=m|0?m<<1:1;if((m|0)>=(p|0)){d=m;z=o+12|0;z=c[z>>2]|0;x=z+(d<<4)|0;b[x>>1]=~~(y*v)&65534;x=z+(d<<4)+2|0;b[x>>1]=~~(u*w)&65534;x=z+(d<<4)+4|0;b[x>>1]=r;x=z+(d<<4)+6|0;b[x>>1]=~~(j*v+1.0)&65535|1;x=z+(d<<4)+8|0;b[x>>1]=~~(i*w+1.0)&65535|1;x=z+(d<<4)+10|0;b[x>>1]=q;d=z+(d<<4)+12|0;c[d>>2]=f<<21|h;h=c[o+4>>2]|0;h=h+1|0;c[o+4>>2]=h;return}if(!p)l=0;else{c[6435]=(c[6435]|0)+1;l=yc((p<<4|3)+16|0)|0;if(!l)l=0;else{c[(l+4+15&-16)+-4>>2]=l;l=l+4+15&-16}m=c[o+4>>2]|0}if((m|0)>0){n=0;do{d=l+(n<<4)|0;z=(c[o+12>>2]|0)+(n<<4)|0;c[d>>2]=c[z>>2];c[d+4>>2]=c[z+4>>2];c[d+8>>2]=c[z+8>>2];c[d+12>>2]=c[z+12>>2];n=n+1|0}while((n|0)!=(m|0))}m=c[o+12>>2]|0;if(m|0){if(a[o+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[m+-4>>2]|0)}c[o+12>>2]=0}a[o+16>>0]=1;c[o+12>>2]=l;c[o+8>>2]=p;d=c[o+4>>2]|0;z=o+12|0;z=c[z>>2]|0;x=z+(d<<4)|0;b[x>>1]=~~(y*v)&65534;x=z+(d<<4)+2|0;b[x>>1]=~~(u*w)&65534;x=z+(d<<4)+4|0;b[x>>1]=r;x=z+(d<<4)+6|0;b[x>>1]=~~(j*v+1.0)&65535|1;x=z+(d<<4)+8|0;b[x>>1]=~~(i*w+1.0)&65535|1;x=z+(d<<4)+10|0;b[x>>1]=q;d=z+(d<<4)+12|0;c[d>>2]=f<<21|h;h=c[o+4>>2]|0;h=h+1|0;c[o+4>>2]=h;return}function Id(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0;i=c[d+8>>2]|0;if(!i){a=0;return a|0}j=i;D=i;i=0;do{if((c[D+20>>2]|0)>(c[a+100>>2]|0)){A=c[D+12>>2]|0;w=c[A+88>>2]|0;x=w-(c[d+88>>2]|0)|0;y=c[A+92>>2]|0;z=y-(c[d+92>>2]|0)|0;A=c[A+96>>2]|0;B=A-(c[d+96>>2]|0)|0;k=vr(c[g>>2]|0,c[g+4>>2]|0,x|0,((x|0)<0)<<31>>31|0)|0;l=C;j=vr(c[g+8>>2]|0,c[g+8+4>>2]|0,z|0,((z|0)<0)<<31>>31|0)|0;l=Kt(j|0,C|0,k|0,l|0)|0;k=C;j=vr(c[g+16>>2]|0,c[g+16+4>>2]|0,B|0,((B|0)<0)<<31>>31|0)|0;j=Kt(l|0,k|0,j|0,C|0)|0;k=C;l=vr(c[f>>2]|0,c[f+4>>2]|0,x|0,((x|0)<0)<<31>>31|0)|0;v=C;m=vr(c[f+8>>2]|0,c[f+8+4>>2]|0,z|0,((z|0)<0)<<31>>31|0)|0;v=Kt(m|0,C|0,l|0,v|0)|0;l=C;m=vr(c[f+16>>2]|0,c[f+16+4>>2]|0,B|0,((B|0)<0)<<31>>31|0)|0;m=Kt(v|0,l|0,m|0,C|0)|0;l=C;if((k|0)>0|(k|0)==0&j>>>0>0){v=k;k=1}else{t=Is(0,0,j|0,k|0)|0;v=C;u=Mr(j|0,k|0,63)|0;j=(k|0)<0?t:0;v=(k|0)<0?v:0;k=u}if(!((l|0)>0|(l|0)==0&m>>>0>0)){u=Is(0,0,m|0,l|0)|0;n=(l|0)<0?0-k|0:k;k=(l|0)<0?u:0;l=(l|0)<0?C:0;if(!((n|0)==0&((k|0)==0&(l|0)==0))){m=k;o=8}}else{n=k;o=8}a:do if((o|0)==8){o=0;if(!i){c[h>>2]=j;c[h+4>>2]=v;c[h+8>>2]=m;c[h+8+4>>2]=l;c[h+16>>2]=n;i=D;break}k=c[h+16>>2]|0;if((n|0)==(k|0)){if(n|0){p=c[h+8>>2]|0;s=c[h+8+4>>2]|0;o=vr(p|0,0,j|0,0)|0;k=C;t=vr(s|0,0,j|0,0)|0;r=C;p=vr(p|0,0,v|0,0)|0;q=C;s=vr(s|0,0,v|0,0)|0;G=C;p=Kt(t|0,0,p|0,0)|0;t=C;G=Kt(r|0,0,s|0,G|0)|0;q=Kt(G|0,C|0,q|0,0)|0;t=Kt(q|0,C|0,t|0,0)|0;q=C;k=Kt(0,p|0,o|0,k|0)|0;o=C;p=Kt(t|0,q|0,(o>>>0<p>>>0|(o|0)==(p|0)&k>>>0<0)&1|0,0)|0;q=C;t=c[h>>2]|0;G=c[h+4>>2]|0;s=vr(t|0,0,m|0,0)|0;r=C;E=vr(G|0,0,m|0,0)|0;H=C;t=vr(t|0,0,l|0,0)|0;u=C;G=vr(G|0,0,l|0,0)|0;F=C;t=Kt(E|0,0,t|0,0)|0;E=C;F=Kt(H|0,0,G|0,F|0)|0;u=Kt(F|0,C|0,u|0,0)|0;E=Kt(u|0,C|0,E|0,0)|0;u=C;r=Kt(0,t|0,s|0,r|0)|0;s=C;t=Kt(E|0,u|0,(s>>>0<t>>>0|(s|0)==(t|0)&r>>>0<0)&1|0,0)|0;u=C;if(!(q>>>0<u>>>0|(q|0)==(u|0)&p>>>0<t>>>0))if(!(q>>>0>u>>>0|(q|0)==(u|0)&p>>>0>t>>>0))if(o>>>0<s>>>0|(o|0)==(s|0)&k>>>0<r>>>0)k=-1;else k=(o>>>0>s>>>0|(o|0)==(s|0)&k>>>0>r>>>0)&1;else k=1;else k=-1;k=_(k,n)|0;o=18}}else{k=n-k|0;o=18}do if((o|0)==18){o=0;if((k|0)>=0)if(!k)break;else break a;else{c[h>>2]=j;c[h+4>>2]=v;c[h+8>>2]=m;c[h+8+4>>2]=l;c[h+16>>2]=n;i=D;break a}}while(0);j=(c[i+4>>2]|0)==(D|0);if((c[i>>2]|0)==(D|0))if(j){H=c[e+8>>2]|0;E=_(H,z)|0;u=c[e+4>>2]|0;E=E-(_(u,B)|0)|0;G=c[e>>2]|0;H=(_(G,B)|0)-(_(H,x)|0)|0;G=(_(u,x)|0)-(_(G,z)|0)|0;u=c[i+12>>2]|0;j=c[(c[D+8>>2]|0)+12>>2]|0;z=c[j+88>>2]|0;x=(c[u+88>>2]|0)-z|0;v=c[j+92>>2]|0;B=(c[u+92>>2]|0)-v|0;j=c[j+96>>2]|0;u=(c[u+96>>2]|0)-j|0;F=(_(A-j|0,B)|0)-(_(y-v|0,u)|0)|0;j=(_(w-z|0,u)|0)-(_(A-j|0,x)|0)|0;B=(_(y-v|0,x)|0)-(_(w-z|0,B)|0)|0;E=vr(F|0,((F|0)<0)<<31>>31|0,E|0,((E|0)<0)<<31>>31|0)|0;F=C;H=vr(j|0,((j|0)<0)<<31>>31|0,H|0,((H|0)<0)<<31>>31|0)|0;j=C;G=vr(B|0,((B|0)<0)<<31>>31|0,G|0,((G|0)<0)<<31>>31|0)|0;G=Kt(E|0,F|0,G|0,C|0)|0;j=Kt(G|0,C|0,H|0,j|0)|0;H=C;j=(H|0)>0|(H|0)==0&j>>>0>0?2:1}else j=2;else j=j&1;i=(j|0)==2^b?i:D}while(0);j=c[d+8>>2]|0}D=c[D>>2]|0}while((D|0)!=(j|0));return i|0}function Jd(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0;v=i;i=i+560|0;k=h;l=k+36|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(l|0));c[v+400>>2]=a;c[v+400+4>>2]=d;o=+g[e>>2];E=+g[b>>2];n=+g[e+16>>2];j=+g[b+16>>2];m=+g[e+32>>2];F=+g[b+32>>2];w=+g[b+4>>2];G=+g[b+20>>2];x=+g[b+36>>2];t=+g[b+8>>2];r=+g[b+24>>2];p=+g[b+40>>2];D=+g[e+4>>2];C=+g[e+20>>2];B=+g[e+36>>2];A=+g[e+8>>2];z=+g[e+24>>2];y=+g[e+40>>2];g[v+400+8>>2]=o*E+n*j+m*F;g[v+400+12>>2]=o*w+n*G+m*x;g[v+400+16>>2]=o*t+n*r+m*p;g[v+400+20>>2]=0.0;g[v+400+24>>2]=E*D+j*C+F*B;g[v+400+28>>2]=w*D+G*C+x*B;g[v+400+32>>2]=t*D+r*C+p*B;g[v+400+36>>2]=0.0;g[v+400+40>>2]=E*A+j*z+F*y;g[v+400+44>>2]=w*A+G*z+x*y;g[v+400+48>>2]=t*A+r*z+p*y;g[v+400+52>>2]=0.0;p=+g[e+48>>2]-+g[b+48>>2];r=+g[e+52>>2]-+g[b+52>>2];t=+g[e+56>>2]-+g[b+56>>2];x=+g[b>>2];G=+g[e>>2];w=+g[b+16>>2];F=+g[e+16>>2];j=+g[b+32>>2];E=+g[e+32>>2];m=+g[b+4>>2];n=+g[b+20>>2];o=+g[b+36>>2];q=+g[b+8>>2];s=+g[b+24>>2];u=+g[b+40>>2];g[v+400+56>>2]=x*G+w*F+j*E;g[v+400+60>>2]=x*D+w*C+j*B;g[v+400+64>>2]=x*A+w*z+j*y;g[v+400+68>>2]=0.0;g[v+400+72>>2]=G*m+F*n+E*o;g[v+400+76>>2]=D*m+C*n+B*o;g[v+400+80>>2]=A*m+z*n+y*o;g[v+400+84>>2]=0.0;g[v+400+88>>2]=G*q+F*s+E*u;g[v+400+92>>2]=D*q+C*s+B*u;g[v+400+96>>2]=A*q+z*s+y*u;g[v+400+100>>2]=0.0;g[v+400+104>>2]=p*x+r*w+t*j;g[v+400+108>>2]=p*m+r*n+t*o;g[v+400+112>>2]=p*q+r*s+t*u;g[v+400+116>>2]=0.0;c[v+400+120>>2]=80;c[v+400+124>>2]=0;c[v+16+364>>2]=0;c[v+16+128>>2]=0;c[v+16+128+4>>2]=0;c[v+16+128+8>>2]=0;c[v+16+128+12>>2]=0;c[v+16+376>>2]=2;c[v+16+368>>2]=0;g[v+16+144>>2]=0.0;f=Uc(v+16|0,v+400|0,f)|0;if(f|0){c[h>>2]=(f|0)==1?1:2;b=0;i=v;return b|0}f=c[v+16+372>>2]|0;if(!(c[f+32>>2]|0)){q=0.0;p=0.0;o=0.0;n=0.0;m=0.0;j=0.0}else{e=0;q=0.0;p=0.0;o=0.0;n=0.0;m=0.0;j=0.0;do{u=+g[f+16+(e<<2)>>2];a=c[v+400+120>>2]|0;l=c[v+400+124>>2]|0;d=(c[v+400>>2]|0)+(l>>1)|0;if(l&1)a=c[(c[d>>2]|0)+a>>2]|0;ic[a&127](v,d,c[f+(e<<2)>>2]|0);q=q+u*+g[v>>2];o=o+u*+g[v+4>>2];p=p+u*+g[v+8>>2];f=c[(c[v+16+372>>2]|0)+(e<<2)>>2]|0;r=-+g[f>>2];s=-+g[f+4>>2];t=-+g[f+8>>2];f=c[v+400+120>>2]|0;l=c[v+400+124>>2]|0;a=(c[v+400+4>>2]|0)+(l>>1)|0;if(l&1)f=c[(c[a>>2]|0)+f>>2]|0;F=+g[v+400+24>>2]*r+ +g[v+400+28>>2]*s+ +g[v+400+32>>2]*t;E=+g[v+400+40>>2]*r+ +g[v+400+44>>2]*s+ +g[v+400+48>>2]*t;g[v+528>>2]=+g[v+400+8>>2]*r+ +g[v+400+12>>2]*s+ +g[v+400+16>>2]*t;g[v+528+4>>2]=F;g[v+528+8>>2]=E;g[v+528+12>>2]=0.0;ic[f&127](v+544|0,a,v+528|0);E=+g[v+544>>2];F=+g[v+544+4>>2];G=+g[v+544+8>>2];n=n+u*(E*+g[v+400+56>>2]+F*+g[v+400+60>>2]+G*+g[v+400+64>>2]+ +g[v+400+104>>2]);j=j+u*(E*+g[v+400+72>>2]+F*+g[v+400+76>>2]+G*+g[v+400+80>>2]+ +g[v+400+108>>2]);m=m+u*(E*+g[v+400+88>>2]+F*+g[v+400+92>>2]+G*+g[v+400+96>>2]+ +g[v+400+112>>2]);e=e+1|0;f=c[v+16+372>>2]|0}while(e>>>0<(c[f+32>>2]|0)>>>0)}D=q*+g[b+16>>2]+o*+g[b+20>>2]+p*+g[b+24>>2]+ +g[b+52>>2];E=q*+g[b+32>>2]+o*+g[b+36>>2]+p*+g[b+40>>2]+ +g[b+56>>2];g[h+4>>2]=q*+g[b>>2]+o*+g[b+4>>2]+p*+g[b+8>>2]+ +g[b+48>>2];g[h+8>>2]=D;g[h+12>>2]=E;g[h+16>>2]=0.0;E=n*+g[b+16>>2]+j*+g[b+20>>2]+m*+g[b+24>>2]+ +g[b+52>>2];D=n*+g[b+32>>2]+j*+g[b+36>>2]+m*+g[b+40>>2]+ +g[b+56>>2];g[h+20>>2]=n*+g[b>>2]+j*+g[b+4>>2]+m*+g[b+8>>2]+ +g[b+48>>2];g[h+24>>2]=E;g[h+28>>2]=D;g[h+32>>2]=0.0;D=q-n;E=o-j;G=p-m;g[h+48>>2]=0.0;F=+O(+(D*D+E*E+G*G));g[h+52>>2]=F;F=F>9.999999747378752e-05?1.0/F:1.0;g[h+36>>2]=F*D;g[h+40>>2]=F*E;g[h+44>>2]=F*G;b=1;i=v;return b|0}function Kd(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0;j=i;i=i+464|0;li(15711);c[j+128>>2]=c[d>>2];c[j+128+4>>2]=c[d+4>>2];c[j+128+8>>2]=c[d+8>>2];c[j+128+12>>2]=c[d+12>>2];c[j+128+16>>2]=c[d+16>>2];c[j+128+16+4>>2]=c[d+16+4>>2];c[j+128+16+8>>2]=c[d+16+8>>2];c[j+128+16+12>>2]=c[d+16+12>>2];c[j+128+32>>2]=c[d+32>>2];c[j+128+32+4>>2]=c[d+32+4>>2];c[j+128+32+8>>2]=c[d+32+8>>2];c[j+128+32+12>>2]=c[d+32+12>>2];l=j+128+48|0;c[l>>2]=c[d+48>>2];c[l+4>>2]=c[d+48+4>>2];c[l+8>>2]=c[d+48+8>>2];c[l+12>>2]=c[d+48+12>>2];c[j+64>>2]=c[e>>2];c[j+64+4>>2]=c[e+4>>2];c[j+64+8>>2]=c[e+8>>2];c[j+64+12>>2]=c[e+12>>2];c[j+64+16>>2]=c[e+16>>2];c[j+64+16+4>>2]=c[e+16+4>>2];c[j+64+16+8>>2]=c[e+16+8>>2];c[j+64+16+12>>2]=c[e+16+12>>2];c[j+64+32>>2]=c[e+32>>2];c[j+64+32+4>>2]=c[e+32+4>>2];c[j+64+32+8>>2]=c[e+32+8>>2];c[j+64+32+12>>2]=c[e+32+12>>2];k=j+64+48|0;c[k>>2]=c[e+48>>2];c[k+4>>2]=c[e+48+4>>2];c[k+8>>2]=c[e+48+8>>2];c[k+12>>2]=c[e+48+12>>2];Gf(j+128|0,j+64|0,j+256|0,j+192|0);t=+g[j+192>>2];m=t*+g[j+256+4>>2];r=t*+g[j+256+8>>2];g[j>>2]=+g[j+256>>2]*t;g[j+4>>2]=m;g[j+8>>2]=r;g[j+12>>2]=0.0;c[j+256>>2]=0;c[j+256+4>>2]=0;c[j+256+8>>2]=0;c[j+256+12>>2]=0;c[j+192+4>>2]=0;c[j+192+4+4>>2]=0;c[j+192+24>>2]=0;c[j+192+24+4>>2]=0;s=j+192+44|0;c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;c[s+12>>2]=0;c[s+16>>2]=0;Wg(j+128|0,j+16|0);r=+g[j+16>>2];m=+g[j+16+4>>2];t=+g[j+16+8>>2];q=+g[j+16+12>>2];o=r*(2.0/(r*r+m*m+t*t+q*q));n=m*(2.0/(r*r+m*m+t*t+q*q));p=t*(2.0/(r*r+m*m+t*t+q*q));g[j+192>>2]=1.0-(m*n+t*p);g[j+192+4>>2]=r*n-q*p;g[j+192+8>>2]=r*p+q*n;g[j+192+12>>2]=0.0;g[j+192+16>>2]=r*n+q*p;g[j+192+20>>2]=1.0-(r*o+t*p);g[j+192+24>>2]=m*p-q*o;g[j+192+28>>2]=0.0;g[j+192+32>>2]=r*p-q*n;g[j+192+36>>2]=m*p+q*o;g[j+192+40>>2]=1.0-(r*o+m*n);g[s>>2]=0.0;rh(b,j+192|0,j+256|0,j,j+48|0,j+32|0);c[j+256>>2]=5936;c[j+256+36>>2]=c[d>>2];c[j+256+36+4>>2]=c[d+4>>2];c[j+256+36+8>>2]=c[d+8>>2];c[j+256+36+12>>2]=c[d+12>>2];c[j+256+52>>2]=c[d+16>>2];c[j+256+52+4>>2]=c[d+16+4>>2];c[j+256+52+8>>2]=c[d+16+8>>2];c[j+256+52+12>>2]=c[d+16+12>>2];c[j+256+68>>2]=c[d+32>>2];c[j+256+68+4>>2]=c[d+32+4>>2];c[j+256+68+8>>2]=c[d+32+8>>2];c[j+256+68+12>>2]=c[d+32+12>>2];s=j+256+84|0;c[s>>2]=c[d+48>>2];c[s+4>>2]=c[d+48+4>>2];c[s+8>>2]=c[d+48+8>>2];c[s+12>>2]=c[d+48+12>>2];c[j+256+100>>2]=c[e>>2];c[j+256+100+4>>2]=c[e+4>>2];c[j+256+100+8>>2]=c[e+8>>2];c[j+256+100+12>>2]=c[e+12>>2];c[j+256+116>>2]=c[e+16>>2];c[j+256+116+4>>2]=c[e+16+4>>2];c[j+256+116+8>>2]=c[e+16+8>>2];c[j+256+116+12>>2]=c[e+16+12>>2];c[j+256+132>>2]=c[e+32>>2];c[j+256+132+4>>2]=c[e+32+4>>2];c[j+256+132+8>>2]=c[e+32+8>>2];c[j+256+132+12>>2]=c[e+32+12>>2];d=j+256+148|0;c[d>>2]=c[e+48>>2];c[d+4>>2]=c[e+48+4>>2];c[d+8>>2]=c[e+48+8>>2];c[d+12>>2]=c[e+48+12>>2];c[j+256+180>>2]=a;c[j+256+184>>2]=f;g[j+256+188>>2]=h;c[j+256+192>>2]=b;n=+g[d>>2]-+g[s>>2];m=+g[j+256+152>>2]-+g[j+256+88>>2];o=+g[j+256+156>>2]-+g[j+256+92>>2];h=1.0/+O(+(n*n+m*m+o*o));r=n*h==0.0?999999984306749440.0:1.0/(n*h);g[j+256+4>>2]=r;q=m*h==0.0?999999984306749440.0:1.0/(m*h);g[j+256+8>>2]=q;p=o*h==0.0?999999984306749440.0:1.0/(o*h);g[j+256+12>>2]=p;c[j+256+20>>2]=r<0.0&1;c[j+256+24>>2]=q<0.0&1;c[j+256+28>>2]=p<0.0&1;g[j+256+32>>2]=o*o*h+(n*n*h+m*m*h);b=c[a+68>>2]|0;Qb[c[(c[b>>2]|0)+24>>2]&7](b,l,k,j+256|0,j+48|0,j+32|0);b=c[2357]|0;a=(c[b+16>>2]|0)+-1|0;c[b+16>>2]=a;if(a|0){i=j;return}do if(c[b+4>>2]|0){tb(j+256|0,0)|0;s=c[6434]|0;g[b+8>>2]=+g[b+8>>2]+ +(((c[j+256+4>>2]|0)-(c[s+4>>2]|0)+(((c[j+256>>2]|0)-(c[s>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[b+16>>2]|0)){b=c[2357]|0;break}else{i=j;return}}while(0);c[2357]=c[b+20>>2];i=j;return}
function xc(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0.0,j=0.0,l=0,m=0.0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0.0,P=0.0,Q=0,R=0.0,S=0.0,T=0.0,U=0.0,V=0,X=0.0,Y=0,Z=0.0,_=0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0,ea=0,fa=0.0,ga=0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0.0,qa=0.0,ra=0.0,sa=0.0,ta=0.0,ua=0.0,va=0.0,wa=0.0,xa=0.0,ya=0.0,za=0.0,Aa=0,Ba=0,Ca=0,Da=0.0,Ea=0.0,Fa=0;Fa=i;i=i+592|0;c[Fa+48>>2]=c[b>>2];c[Fa>>2]=c[b+64>>2];E=Fa+48+4|0;c[E>>2]=c[b+4>>2];c[Fa+4>>2]=c[b+68>>2];c[Fa+48+8>>2]=c[b+8>>2];c[Fa+8>>2]=c[b+72>>2];c[Fa+48+16>>2]=c[b+16>>2];c[Fa+16>>2]=c[b+80>>2];c[Fa+48+20>>2]=c[b+20>>2];c[Fa+20>>2]=c[b+84>>2];c[Fa+48+24>>2]=c[b+24>>2];c[Fa+24>>2]=c[b+88>>2];c[Fa+48+32>>2]=c[b+32>>2];c[Fa+32>>2]=c[b+96>>2];c[Fa+48+36>>2]=c[b+36>>2];c[Fa+36>>2]=c[b+100>>2];c[Fa+48+40>>2]=c[b+40>>2];c[Fa+40>>2]=c[b+104>>2];Ca=c[a+4>>2]|0;ia=+g[Ca+28>>2];ja=+g[Ca+32>>2];ma=+g[Ca+36>>2];ka=+Sb[c[(c[Ca>>2]|0)+48>>2]&15](Ca);la=+Sb[c[(c[Ca>>2]|0)+48>>2]&15](Ca);ma=(ma+ +Sb[c[(c[Ca>>2]|0)+48>>2]&15](Ca))*2.0;Ca=c[a+8>>2]|0;qa=+g[Ca+28>>2];ra=+g[Ca+32>>2];wa=+g[Ca+36>>2];sa=+Sb[c[(c[Ca>>2]|0)+48>>2]&15](Ca);pa=+Sb[c[(c[Ca>>2]|0)+48>>2]&15](Ca);wa=(wa+ +Sb[c[(c[Ca>>2]|0)+48>>2]&15](Ca))*2.0;D=+g[b+112>>2]-+g[b+48>>2];M=+g[b+116>>2]-+g[b+52>>2];P=+g[b+120>>2]-+g[b+56>>2];ca=+g[Fa+48>>2];aa=+g[Fa+48+16>>2];ba=+g[Fa+48+32>>2];$=+g[E>>2];X=+g[Fa+48+20>>2];Z=+g[Fa+48+36>>2];fa=+g[Fa+48+8>>2];ha=+g[Fa+48+24>>2];na=+g[Fa+48+40>>2];g[Fa+484>>2]=(ia+ka)*2.0*.5;g[Fa+484+4>>2]=(ja+la)*2.0*.5;g[Fa+484+8>>2]=ma*.5;g[Fa+472>>2]=(qa+sa)*2.0*.5;g[Fa+472+4>>2]=(ra+pa)*2.0*.5;g[Fa+472+8>>2]=wa*.5;za=+g[Fa>>2];ta=+g[Fa+16>>2];va=+g[Fa+32>>2];ya=+g[Fa+4>>2];oa=+g[Fa+20>>2];ua=+g[Fa+36>>2];xa=+g[Fa+8>>2];Da=+g[Fa+24>>2];Ea=+g[Fa+40>>2];y=+N(+(ca*za+aa*ta+ba*va));A=+N(+(ca*ya+aa*oa+ba*ua));R=+N(+(ca*xa+aa*Da+ba*Ea));z=+N(+(za*$+ta*X+va*Z));B=+N(+(ya*$+oa*X+ua*Z));S=+N(+(xa*$+Da*X+Ea*Z));T=+N(+(za*fa+ta*ha+va*na));U=+N(+(ya*fa+oa*ha+ua*na));C=+N(+(xa*fa+Da*ha+Ea*na));h=+N(+(D*ca+M*aa+P*ba))-(wa*.5*R+((ia+ka)*2.0*.5+y*(qa+sa)*2.0*.5+A*(ra+pa)*2.0*.5));if(h>0.0){i=Fa;return}if(h>-3402823466385288598117041.0e14){n=1;l=D*ca+M*aa+P*ba<0.0&1;e=Fa+48|0}else{n=0;l=0;e=0;h=-3402823466385288598117041.0e14}j=+N(+(D*$+M*X+P*Z))-((ja+la)*2.0*.5+z*(qa+sa)*2.0*.5+B*(ra+pa)*2.0*.5+S*wa*.5);if(j>0.0){i=Fa;return}if(j>h){n=2;l=D*$+M*X+P*Z<0.0&1;e=E;h=j}j=+N(+(D*fa+M*ha+P*na))-(ma*.5+T*(qa+sa)*2.0*.5+U*(ra+pa)*2.0*.5+C*wa*.5);if(j>0.0){i=Fa;return}if(j>h){n=3;l=D*fa+M*ha+P*na<0.0&1;e=Fa+48+8|0;h=j}j=+N(+(D*za+M*ta+P*va))-((qa+sa)*2.0*.5+(y*(ia+ka)*2.0*.5+z*(ja+la)*2.0*.5+T*ma*.5));if(j>0.0){i=Fa;return}if(j>h){n=4;l=D*za+M*ta+P*va<0.0&1;e=Fa;h=j}j=+N(+(D*ya+M*oa+P*ua))-((ra+pa)*2.0*.5+(A*(ia+ka)*2.0*.5+B*(ja+la)*2.0*.5+U*ma*.5));if(j>0.0){i=Fa;return}if(j>h){n=5;l=D*ya+M*oa+P*ua<0.0&1;e=Fa+4|0}else j=h;h=+N(+(D*xa+M*Da+P*Ea))-(wa*.5+(R*(ia+ka)*2.0*.5+S*(ja+la)*2.0*.5+C*ma*.5));if(h>0.0){i=Fa;return}if(h>j){n=6;l=D*xa+M*Da+P*Ea<0.0&1;u=Fa+8|0}else{u=e;h=j}j=(D*fa+M*ha+P*na)*(za*$+ta*X+va*Z)-(D*$+M*X+P*Z)*(za*fa+ta*ha+va*na);m=+N(+j)-((T+9.999999747378752e-06)*(ja+la)*2.0*.5+(z+9.999999747378752e-06)*ma*.5+(R+9.999999747378752e-06)*(ra+pa)*2.0*.5+(A+9.999999747378752e-06)*wa*.5);if(m>1.1920928955078125e-07){i=Fa;return}p=(za*fa+ta*ha+va*na)*(za*fa+ta*ha+va*na)+0.0;v=(za*$+ta*X+va*Z)*(za*$+ta*X+va*Z);o=+O(+(v+p));if(o>1.1920928955078125e-07?m/o*1.0499999523162842>h:0){a=(g[k>>2]=0.0/o,c[k>>2]|0);f=(g[k>>2]=-(za*fa+ta*ha+va*na)/o,c[k>>2]|0);n=7;l=j<0.0&1;e=(g[k>>2]=(za*$+ta*X+va*Z)/o,c[k>>2]|0);u=0;h=m/o}else{a=0;f=0;e=0}j=(D*fa+M*ha+P*na)*(ya*$+oa*X+ua*Z)-(D*$+M*X+P*Z)*(ya*fa+oa*ha+ua*na);m=+N(+j)-((U+9.999999747378752e-06)*(ja+la)*2.0*.5+(B+9.999999747378752e-06)*ma*.5+(R+9.999999747378752e-06)*(qa+sa)*2.0*.5+(y+9.999999747378752e-06)*wa*.5);if(m>1.1920928955078125e-07){i=Fa;return}q=(ya*fa+oa*ha+ua*na)*(ya*fa+oa*ha+ua*na)+0.0;w=(ya*$+oa*X+ua*Z)*(ya*$+oa*X+ua*Z);o=+O(+(w+q));if(o>1.1920928955078125e-07?m/o*1.0499999523162842>h:0){a=(g[k>>2]=0.0/o,c[k>>2]|0);f=(g[k>>2]=-(ya*fa+oa*ha+ua*na)/o,c[k>>2]|0);n=8;l=j<0.0&1;e=(g[k>>2]=(ya*$+oa*X+ua*Z)/o,c[k>>2]|0);u=0;h=m/o}j=(D*fa+M*ha+P*na)*(xa*$+Da*X+Ea*Z)-(D*$+M*X+P*Z)*(xa*fa+Da*ha+Ea*na);m=+N(+j)-((C+9.999999747378752e-06)*(ja+la)*2.0*.5+(S+9.999999747378752e-06)*ma*.5+(A+9.999999747378752e-06)*(qa+sa)*2.0*.5+(y+9.999999747378752e-06)*(ra+pa)*2.0*.5);if(m>1.1920928955078125e-07){i=Fa;return}s=(xa*fa+Da*ha+Ea*na)*(xa*fa+Da*ha+Ea*na)+0.0;x=(xa*$+Da*X+Ea*Z)*(xa*$+Da*X+Ea*Z);o=+O(+(x+s));if(o>1.1920928955078125e-07?m/o*1.0499999523162842>h:0){a=(g[k>>2]=0.0/o,c[k>>2]|0);f=(g[k>>2]=-(xa*fa+Da*ha+Ea*na)/o,c[k>>2]|0);n=9;l=j<0.0&1;e=(g[k>>2]=(xa*$+Da*X+Ea*Z)/o,c[k>>2]|0);u=0;h=m/o}j=(D*ca+M*aa+P*ba)*(za*fa+ta*ha+va*na)-(D*fa+M*ha+P*na)*(ca*za+aa*ta+ba*va);o=+N(+j)-((T+9.999999747378752e-06)*(ia+ka)*2.0*.5+(y+9.999999747378752e-06)*ma*.5+(S+9.999999747378752e-06)*(ra+pa)*2.0*.5+(B+9.999999747378752e-06)*wa*.5);if(o>1.1920928955078125e-07){i=Fa;return}t=(ca*za+aa*ta+ba*va)*(ca*za+aa*ta+ba*va);m=+O(+(t+p));do if(m>1.1920928955078125e-07){if(!(o/m*1.0499999523162842>h))break;a=(g[k>>2]=(za*fa+ta*ha+va*na)/m,c[k>>2]|0);f=(g[k>>2]=0.0/m,c[k>>2]|0);n=10;l=j<0.0&1;e=(g[k>>2]=-(ca*za+aa*ta+ba*va)/m,c[k>>2]|0);u=0;h=o/m}while(0);j=(D*ca+M*aa+P*ba)*(ya*fa+oa*ha+ua*na)-(D*fa+M*ha+P*na)*(ca*ya+aa*oa+ba*ua);o=+N(+j)-((U+9.999999747378752e-06)*(ia+ka)*2.0*.5+(A+9.999999747378752e-06)*ma*.5+(S+9.999999747378752e-06)*(qa+sa)*2.0*.5+(z+9.999999747378752e-06)*wa*.5);if(o>1.1920928955078125e-07){i=Fa;return}r=(ca*ya+aa*oa+ba*ua)*(ca*ya+aa*oa+ba*ua);m=+O(+(r+q));do if(m>1.1920928955078125e-07){if(!(o/m*1.0499999523162842>h))break;a=(g[k>>2]=(ya*fa+oa*ha+ua*na)/m,c[k>>2]|0);f=(g[k>>2]=0.0/m,c[k>>2]|0);n=11;l=j<0.0&1;e=(g[k>>2]=-(ca*ya+aa*oa+ba*ua)/m,c[k>>2]|0);u=0;h=o/m}while(0);j=(D*ca+M*aa+P*ba)*(xa*fa+Da*ha+Ea*na)-(D*fa+M*ha+P*na)*(ca*xa+aa*Da+ba*Ea);o=+N(+j)-((C+9.999999747378752e-06)*(ia+ka)*2.0*.5+(R+9.999999747378752e-06)*ma*.5+(B+9.999999747378752e-06)*(qa+sa)*2.0*.5+(z+9.999999747378752e-06)*(ra+pa)*2.0*.5);if(o>1.1920928955078125e-07){i=Fa;return}p=(ca*xa+aa*Da+ba*Ea)*(ca*xa+aa*Da+ba*Ea);m=+O(+(p+s));do if(m>1.1920928955078125e-07){if(!(o/m*1.0499999523162842>h))break;a=(g[k>>2]=(xa*fa+Da*ha+Ea*na)/m,c[k>>2]|0);f=(g[k>>2]=0.0/m,c[k>>2]|0);n=12;l=j<0.0&1;e=(g[k>>2]=-(ca*xa+aa*Da+ba*Ea)/m,c[k>>2]|0);u=0;h=o/m}while(0);j=(D*$+M*X+P*Z)*(ca*za+aa*ta+ba*va)-(D*ca+M*aa+P*ba)*(za*$+ta*X+va*Z);o=+N(+j)-((z+9.999999747378752e-06)*(ia+ka)*2.0*.5+(y+9.999999747378752e-06)*(ja+la)*2.0*.5+(C+9.999999747378752e-06)*(ra+pa)*2.0*.5+(U+9.999999747378752e-06)*wa*.5);if(o>1.1920928955078125e-07){i=Fa;return}m=+O(+(t+v+0.0));do if(m>1.1920928955078125e-07){if(!(o/m*1.0499999523162842>h))break;a=(g[k>>2]=-(za*$+ta*X+va*Z)/m,c[k>>2]|0);f=(g[k>>2]=(ca*za+aa*ta+ba*va)/m,c[k>>2]|0);n=13;l=j<0.0&1;e=(g[k>>2]=0.0/m,c[k>>2]|0);u=0;h=o/m}while(0);j=(D*$+M*X+P*Z)*(ca*ya+aa*oa+ba*ua)-(D*ca+M*aa+P*ba)*(ya*$+oa*X+ua*Z);o=+N(+j)-((B+9.999999747378752e-06)*(ia+ka)*2.0*.5+(A+9.999999747378752e-06)*(ja+la)*2.0*.5+(C+9.999999747378752e-06)*(qa+sa)*2.0*.5+(T+9.999999747378752e-06)*wa*.5);if(o>1.1920928955078125e-07){i=Fa;return}m=+O(+(r+w+0.0));do if(m>1.1920928955078125e-07){if(!(o/m*1.0499999523162842>h))break;a=(g[k>>2]=-(ya*$+oa*X+ua*Z)/m,c[k>>2]|0);f=(g[k>>2]=(ca*ya+aa*oa+ba*ua)/m,c[k>>2]|0);n=14;l=j<0.0&1;e=(g[k>>2]=0.0/m,c[k>>2]|0);u=0;h=o/m}while(0);m=(D*$+M*X+P*Z)*(ca*xa+aa*Da+ba*Ea)-(D*ca+M*aa+P*ba)*(xa*$+Da*X+Ea*Z);o=+N(+m)-((S+9.999999747378752e-06)*(ia+ka)*2.0*.5+(R+9.999999747378752e-06)*(ja+la)*2.0*.5+(U+9.999999747378752e-06)*(qa+sa)*2.0*.5+(T+9.999999747378752e-06)*(ra+pa)*2.0*.5);if(o>1.1920928955078125e-07){i=Fa;return}j=+O(+(p+x+0.0));do if(j>1.1920928955078125e-07){if(!(o/j*1.0499999523162842>h)){Aa=55;break}a=(g[k>>2]=-(xa*$+Da*X+Ea*Z)/j,c[k>>2]|0);f=(g[k>>2]=(ca*xa+aa*Da+ba*Ea)/j,c[k>>2]|0);n=15;l=m<0.0&1;e=(g[k>>2]=0.0/j,c[k>>2]|0);h=o/j;Aa=58}else Aa=55;while(0);do if((Aa|0)==55){if(!n){i=Fa;return}if(!u){Aa=58;break}e=c[u>>2]|0;a=c[u+16>>2]|0;Ca=c[u+32>>2]|0;j=(c[k>>2]=e,+g[k>>2]);m=(c[k>>2]=a,+g[k>>2]);o=(c[k>>2]=Ca,+g[k>>2]);f=l;l=Ca;D=h}while(0);if((Aa|0)==58){ca=(c[k>>2]=a,+g[k>>2]);o=(c[k>>2]=f,+g[k>>2]);D=(c[k>>2]=e,+g[k>>2]);j=ca*+g[Fa+48>>2]+o*+g[E>>2]+D*fa;e=(g[k>>2]=j,c[k>>2]|0);m=ca*+g[Fa+48+16>>2]+o*+g[Fa+48+20>>2]+D*ha;a=(g[k>>2]=m,c[k>>2]|0);D=ca*+g[Fa+48+32>>2]+o*+g[Fa+48+36>>2]+D*na;o=D;f=l;l=(g[k>>2]=D,c[k>>2]|0);D=h}if(!f){Ba=a;Ca=l}else{e=(g[k>>2]=-j,c[k>>2]|0);Ba=(g[k>>2]=-m,c[k>>2]|0);Ca=(g[k>>2]=-o,c[k>>2]|0)}if((n|0)>6){C=(c[k>>2]=e,+g[k>>2]);B=(c[k>>2]=Ba,+g[k>>2]);A=(c[k>>2]=Ca,+g[k>>2]);j=+g[Fa+48>>2];t=+g[Fa+48+16>>2];w=+g[Fa+48+32>>2];v=(C*j+B*t+A*w>0.0?1.0:-1.0)*(ia+ka)*2.0*.5;z=+g[E>>2];y=+g[Fa+48+20>>2];h=+g[Fa+48+36>>2];s=(C*z+B*y+A*h>0.0?1.0:-1.0)*(ja+la)*2.0*.5;x=(C*fa+B*ha+A*na>0.0?1.0:-1.0)*ma*.5;z=+g[b+48>>2]+v*j+s*z+x*fa;y=+g[b+52>>2]+v*t+s*y+x*ha;x=+g[b+56>>2]+v*w+s*h+x*na;c[Fa+528>>2]=c[b+112>>2];c[Fa+528+4>>2]=c[b+112+4>>2];c[Fa+528+8>>2]=c[b+112+8>>2];h=(C*za+B*ta+A*va>0.0?-1.0:1.0)*(qa+sa)*2.0*.5;s=(C*ya+B*oa+A*ua>0.0?-1.0:1.0)*(ra+pa)*2.0*.5;w=+g[Fa+528+4>>2]+h*ta+s*oa;v=+g[Fa+528+8>>2]+h*va+s*ua;t=(C*xa+B*Da+A*Ea>0.0?-1.0:1.0)*wa*.5;s=+g[Fa+528>>2]+h*za+s*ya+t*xa;g[Fa+528>>2]=s;g[Fa+528+4>>2]=w+t*Da;g[Fa+528+8>>2]=v+t*Ea;Ca=n+-7|0;h=+g[Fa+48+(((Ca|0)/3|0)<<2)>>2];j=+g[Fa+48+(((Ca|0)/3|0)+4<<2)>>2];m=+g[Fa+48+(((Ca|0)/3|0)+8<<2)>>2];p=+g[Fa+(((Ca|0)%3|0)<<2)>>2];q=+g[Fa+(((Ca|0)%3|0)+4<<2)>>2];r=+g[Fa+(((Ca|0)%3|0)+8<<2)>>2];o=1.0-(h*p+j*q+m*r)*(h*p+j*q+m*r);if(!(o<=9.999999747378752e-05))h=(((s-z)*h+(w+t*Da-y)*j+(v+t*Ea-x)*m)*(h*p+j*q+m*r)-((s-z)*p+(w+t*Da-y)*q+(v+t*Ea-x)*r))*(1.0/o);else h=0.0;g[Fa+528>>2]=s+h*p;g[Fa+528+4>>2]=w+t*Da+h*q;g[Fa+528+8>>2]=v+t*Ea+h*r;Ca=c[(c[d>>2]|0)+16>>2]|0;g[Fa+456>>2]=-C;g[Fa+456+4>>2]=-B;g[Fa+456+8>>2]=-A;g[Fa+456+12>>2]=0.0;hc[Ca&15](d,Fa+456|0,Fa+528|0,D);i=Fa;return}da=(n|0)<4;fa=(c[k>>2]=e,+g[k>>2]);if(da){l=Fa+48|0;_=Fa;Q=Fa+484|0;u=Fa+472|0;ca=fa;f=Ca;e=Ba;ga=b+48|0;a=b+112|0}else{e=(g[k>>2]=-(c[k>>2]=Ba,+g[k>>2]),c[k>>2]|0);l=Fa;_=Fa+48|0;Q=Fa+472|0;u=Fa+484|0;ca=-fa;f=(g[k>>2]=-(c[k>>2]=Ca,+g[k>>2]),c[k>>2]|0);ga=b+112|0;a=b+48|0}ba=(c[k>>2]=e,+g[k>>2]);aa=(c[k>>2]=f,+g[k>>2]);h=ca*+g[_>>2]+ba*+g[_+16>>2]+aa*+g[_+32>>2];g[Fa+440>>2]=h;j=ca*+g[_+4>>2]+ba*+g[_+20>>2]+aa*+g[_+36>>2];g[Fa+440+4>>2]=j;p=ca*+g[_+8>>2]+ba*+g[_+24>>2]+aa*+g[_+40>>2];g[Fa+440+8>>2]=p;h=+N(+h);j=+N(+j);p=+N(+p);e=j>h?(j>p?1:2):h>p?0:2;V=j>h?0:h>p&1;Y=(j>h?j>p:h>p)?2:1;p=+g[u+(e<<2)>>2];h=+g[a>>2]-+g[ga>>2];j=p*+g[_+(e<<2)>>2];m=+g[a+4>>2];ea=ga+4|0;o=+g[ea>>2];if(+g[Fa+440+(e<<2)>>2]<0.0){$=h+j;Z=m-o+p*+g[_+((e|4)<<2)>>2];X=+g[a+8>>2]-+g[ga+8>>2]+p*+g[_+((e|8)<<2)>>2]}else{$=h-j;Z=m-o-p*+g[_+((e|4)<<2)>>2];X=+g[a+8>>2]-+g[ga+8>>2]-p*+g[_+((e|8)<<2)>>2]}K=(da?-1:-4)+n|0;switch(K|0){case 0:{e=1;f=2;break}case 1:{e=0;f=2;break}default:{e=0;f=1}}J=l+(e<<2)|0;T=+g[J>>2];R=+g[J+16>>2];S=+g[J+32>>2];U=$*T+Z*R+X*S;J=l+(f<<2)|0;M=+g[J>>2];A=+g[J+16>>2];B=+g[J+32>>2];P=$*M+Z*A+X*B;J=_+(V<<2)|0;D=+g[J>>2];y=+g[J+16>>2];z=+g[J+32>>2];L=_+(Y<<2)|0;C=+g[L>>2];w=+g[L+16>>2];x=+g[L+32>>2];Da=+g[u+(V<<2)>>2];Ea=+g[u+(Y<<2)>>2];za=(T*C+R*w+S*x)*Ea;Ea=(M*C+A*w+B*x)*Ea;g[Fa+408>>2]=U-(T*D+R*y+S*z)*Da-za;g[Fa+408+4>>2]=P-(M*D+A*y+B*z)*Da-Ea;g[Fa+408+8>>2]=U-(T*D+R*y+S*z)*Da+za;g[Fa+408+12>>2]=P-(M*D+A*y+B*z)*Da+Ea;g[Fa+408+16>>2]=U+(T*D+R*y+S*z)*Da+za;g[Fa+408+20>>2]=P+(M*D+A*y+B*z)*Da+Ea;g[Fa+408+24>>2]=U+(T*D+R*y+S*z)*Da-za;g[Fa+408+28>>2]=P+(M*D+A*y+B*z)*Da-Ea;c[Fa+400>>2]=c[Q+(e<<2)>>2];c[Fa+400+4>>2]=c[Q+(f<<2)>>2];I=0;f=4;b=Fa+408|0;H=Fa+336|0;a:while(1){F=Fa+400+(I<<2)|0;G=1-I|0;do if((f|0)>0){a=0;E=b;e=H;while(1){l=E+(I<<2)|0;h=+g[l>>2];j=+g[F>>2];if(j>-h){c[e>>2]=c[E>>2];c[e+4>>2]=c[E+4>>2];a=a+1|0;if(a&8|0){f=a;e=H;break a}h=+g[l>>2];j=+g[F>>2];n=e+8|0}else n=e;u=(f|0)>1;l=E;E=E+8|0;e=u?E:b;m=+g[e+(I<<2)>>2];if(j>-h^j>-m){Ea=+g[l+(G<<2)>>2];g[n+(G<<2)>>2]=Ea+(-j-h)*((+g[e+(G<<2)>>2]-Ea)/(m-h));g[n+(I<<2)>>2]=-+g[F>>2];e=a+1|0;if(!(e&8)){a=e;e=n+8|0}else{f=e;e=H;break a}}else e=n;if(!u)break;else f=f+-1|0}e=(H|0)==(Fa+336|0)?Fa+528|0:Fa+336|0;if((a|0)<=0){f=0;break}E=a;f=0;b=H;a=e;while(1){l=b+(I<<2)|0;j=+g[l>>2];h=+g[F>>2];if(j<h){c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];f=f+1|0;if(f&8|0)break a;h=+g[F>>2];j=+g[l>>2];a=a+8|0}u=(E|0)>1;n=b;b=b+8|0;l=u?b:H;m=+g[l+(I<<2)>>2];if(j<h^m<h){Ea=+g[n+(G<<2)>>2];g[a+(G<<2)>>2]=Ea+(h-j)*((+g[l+(G<<2)>>2]-Ea)/(m-j));c[a+(I<<2)>>2]=c[F>>2];f=f+1|0;if(!(f&8))a=a+8|0;else break a}if(!u)break;else E=E+-1|0}}else{e=(H|0)==(Fa+336|0)?Fa+528|0:Fa+336|0;f=0}while(0);I=I+1|0;if((I|0)>=2)break;else{b=e;H=(e|0)==(Fa+336|0)?Fa+528|0:Fa+336|0}}if((e|0)!=(Fa+336|0))_m(Fa+336|0,e|0,f<<3|0)|0;if((f|0)>=1){v=1.0/((T*D+R*y+S*z)*(M*C+A*w+B*x)-(M*D+A*y+B*z)*(T*C+R*w+S*x));t=+g[Q+(K<<2)>>2];s=+g[J>>2];p=+g[L>>2];q=+g[_+((V|4)<<2)>>2];r=+g[_+((Y|4)<<2)>>2];o=+g[_+((V|8)<<2)>>2];m=+g[_+((Y|8)<<2)>>2];a=0;e=0;do{_=e<<1;h=+g[Fa+336+(_<<2)>>2];j=+g[Fa+336+((_|1)<<2)>>2];ya=(M*C+A*w+B*x)*v*(h-U)-(T*C+R*w+S*x)*v*(j-P);Ea=(T*D+R*y+S*z)*v*(j-P)-(M*D+A*y+B*z)*v*(h-U);_=a*3|0;za=$+ya*s+Ea*p;g[Fa+240+(_<<2)>>2]=za;Da=Z+ya*q+Ea*r;g[Fa+240+(_+1<<2)>>2]=Da;Ea=X+ya*o+Ea*m;g[Fa+240+(_+2<<2)>>2]=Ea;Ea=t-(ca*za+ba*Da+aa*Ea);g[Fa+208+(a<<2)>>2]=Ea;if(Ea>=0.0){_=a<<1;g[Fa+336+(_<<2)>>2]=h;g[Fa+336+((_|1)<<2)>>2]=j;a=a+1|0}e=e+1|0}while((e|0)!=(f|0));b:do if((a|0)>=1){E=(a|0)<4?a:4;E=(E|0)<1?1:E;if((a|0)<=(E|0))if(da){f=ga+8|0;j=-(c[k>>2]=Ba,+g[k>>2]);h=-(c[k>>2]=Ca,+g[k>>2]);e=0;while(1){Ca=e*3|0;g[Fa+528>>2]=+g[Fa+240+(Ca<<2)>>2]+ +g[ga>>2];g[Fa+528+4>>2]=+g[Fa+240+(Ca+1<<2)>>2]+ +g[ea>>2];g[Fa+528+8>>2]=+g[Fa+240+(Ca+2<<2)>>2]+ +g[f>>2];Ca=c[(c[d>>2]|0)+16>>2]|0;g[Fa+192>>2]=-fa;g[Fa+192+4>>2]=j;g[Fa+192+8>>2]=h;g[Fa+192+12>>2]=0.0;hc[Ca&15](d,Fa+192|0,Fa+528|0,-+g[Fa+208+(e<<2)>>2]);e=e+1|0;if((e|0)==(a|0))break b}}else{f=ga+8|0;j=(c[k>>2]=Ba,+g[k>>2]);h=(c[k>>2]=Ca,+g[k>>2]);e=0;while(1){Ca=e*3|0;Ea=+g[Fa+208+(e<<2)>>2];g[Fa+528>>2]=+g[Fa+240+(Ca<<2)>>2]+ +g[ga>>2]-fa*Ea;g[Fa+528+4>>2]=+g[Fa+240+(Ca+1<<2)>>2]+ +g[ea>>2]-j*Ea;g[Fa+528+8>>2]=+g[Fa+240+(Ca+2<<2)>>2]+ +g[f>>2]-h*Ea;Ca=c[(c[d>>2]|0)+16>>2]|0;g[Fa+176>>2]=-fa;g[Fa+176+4>>2]=-j;g[Fa+176+8>>2]=-h;g[Fa+176+12>>2]=0.0;hc[Ca&15](d,Fa+176|0,Fa+528|0,-Ea);e=e+1|0;if((e|0)==(a|0))break b}}c:do if((a|0)>1){f=1;l=0;j=+g[Fa+208>>2];while(1){h=+g[Fa+208+(f<<2)>>2];e=h>j;l=e?f:l;f=f+1|0;if((f|0)==(a|0))break;else j=e?h:j}switch(a|0){case 1:{e=Fa+144|0;f=Fa+144|0;a=1;Aa=111;break c}case 2:{e=Fa+144|0;f=Fa+144|0;a=2;j=(+g[Fa+336>>2]+ +g[Fa+336+8>>2])*.5;h=(+g[Fa+336+4>>2]+ +g[Fa+336+12>>2])*.5;Aa=116;break c}default:{}}e=a+-1|0;h=0.0;j=0.0;r=0.0;f=0;do{_=f<<1;ya=+g[Fa+336+(_<<2)>>2];za=+g[Fa+336+(_+3<<2)>>2];Da=+g[Fa+336+(_+2<<2)>>2];Ea=+g[Fa+336+((_|1)<<2)>>2];h=h+(ya*za-Da*Ea);j=j+(ya+Da)*(ya*za-Da*Ea);r=r+(za+Ea)*(ya*za-Da*Ea);f=f+1|0}while((f|0)!=(e|0));_=a<<1;m=+g[Fa+336+(_+-2<<2)>>2];o=+g[Fa+336+4>>2];p=+g[Fa+336>>2];q=+g[Fa+336+(_+-1<<2)>>2];h=h+(m*o-p*q);if(+N(+h)>1.1920928955078125e-07)h=1.0/(h*3.0);else h=999999984306749440.0;if((a|0)>0){u=Fa+144|0;f=Fa+144|0;n=Fa+528|0;j=h*(j+(m*o-p*q)*(m+p));h=h*(r+(m*o-p*q)*(q+o));Aa=119;break}e=Fa+144|0;f=0;u=a}else{e=Fa+144|0;f=Fa+144|0;l=0;Aa=111}while(0);if((Aa|0)==111){j=+g[Fa+336>>2];h=+g[Fa+336+4>>2];Aa=116}if((Aa|0)==116){u=e;n=Fa+528|0;Aa=119}if((Aa|0)==119){e=0;do{Aa=e<<1;g[Fa+528+(e<<2)>>2]=+W(+(+g[Fa+336+((Aa|1)<<2)>>2]-h),+(+g[Fa+336+(Aa<<2)>>2]-j));e=e+1|0}while((e|0)!=(a|0));e=0;do{c[Fa+496+(e<<2)>>2]=1;e=e+1|0}while((e|0)!=(a|0));e=u;f=1;u=a}a=Fa+496+(l<<2)|0;c[a>>2]=0;c[e>>2]=l;d:do if((E|0)>1){o=+g[Fa+528+(l<<2)>>2];if(f){f=Fa+144+4|0;n=1}else{e=Fa+144+4|0;f=1;while(1){c[e>>2]=l;c[a>>2]=0;f=f+1|0;if((f|0)==(E|0))break d;else e=e+4|0}}while(1){m=6.2831854820251465/+(E|0)*+(n|0)+o;m=m>3.1415927410125732?m+-6.2831854820251465:m;c[f>>2]=l;e=l;a=0;j=1.0e9;while(1){do if(!(c[Fa+496+(a<<2)>>2]|0))h=j;else{h=+N(+(+g[Fa+528+(a<<2)>>2]-m));h=h>3.1415927410125732?6.2831854820251465-h:h;if(!(h<j)){h=j;break}c[f>>2]=a;e=a}while(0);a=a+1|0;if((a|0)==(u|0))break;else j=h}c[Fa+496+(e<<2)>>2]=0;n=n+1|0;if((n|0)==(E|0))break;else f=f+4|0}}while(0);if((E|0)>0){f=ga+8|0;j=(c[k>>2]=Ba,+g[k>>2]);h=(c[k>>2]=Ca,+g[k>>2]);if(da){e=0;do{Ca=c[Fa+144+(e<<2)>>2]|0;g[Fa+528>>2]=+g[Fa+240+(Ca*3<<2)>>2]+ +g[ga>>2];g[Fa+528+4>>2]=+g[Fa+240+((Ca*3|0)+1<<2)>>2]+ +g[ea>>2];g[Fa+528+8>>2]=+g[Fa+240+((Ca*3|0)+2<<2)>>2]+ +g[f>>2];Ba=c[(c[d>>2]|0)+16>>2]|0;g[Fa+128>>2]=-fa;g[Fa+128+4>>2]=-j;g[Fa+128+8>>2]=-h;g[Fa+128+12>>2]=0.0;hc[Ba&15](d,Fa+128|0,Fa+528|0,-+g[Fa+208+(Ca<<2)>>2]);e=e+1|0}while((e|0)<(E|0))}else{e=0;do{Ba=c[Fa+144+(e<<2)>>2]|0;ya=+g[Fa+240+(Ba*3<<2)>>2]+ +g[ga>>2];g[Fa+528>>2]=ya;za=+g[Fa+240+((Ba*3|0)+1<<2)>>2]+ +g[ea>>2];g[Fa+528+4>>2]=za;Da=+g[Fa+240+((Ba*3|0)+2<<2)>>2]+ +g[f>>2];g[Fa+528+8>>2]=Da;Ca=c[(c[d>>2]|0)+16>>2]|0;g[Fa+112>>2]=-fa;g[Fa+112+4>>2]=-j;g[Fa+112+8>>2]=-h;g[Fa+112+12>>2]=0.0;Ea=+g[Fa+208+(Ba<<2)>>2];g[Fa+96>>2]=ya-fa*Ea;g[Fa+96+4>>2]=za-Ea*j;g[Fa+96+8>>2]=Da-Ea*h;g[Fa+96+12>>2]=0.0;hc[Ca&15](d,Fa+112|0,Fa+96|0,-Ea);e=e+1|0}while((e|0)<(E|0))}}}while(0)}i=Fa;return}function yc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;do if(a>>>0<245){n=a>>>0<11?16:a+11&-8;g=c[6438]|0;if(g>>>(n>>>3)&3|0){a=25792+((g>>>(n>>>3)&1^1)+(n>>>3)<<1<<2)|0;b=c[a+8>>2]|0;d=c[b+8>>2]|0;do if((a|0)!=(d|0)){if(d>>>0<(c[6442]|0)>>>0)Va();if((c[d+12>>2]|0)==(b|0)){c[d+12>>2]=a;c[a+8>>2]=d;break}else Va()}else c[6438]=g&~(1<<(g>>>(n>>>3)&1^1)+(n>>>3));while(0);D=(g>>>(n>>>3)&1^1)+(n>>>3)<<3;c[b+4>>2]=D|3;c[b+D+4>>2]=c[b+D+4>>2]|1;D=b+8|0;return D|0}b=c[6440]|0;if(n>>>0>b>>>0){if(g>>>(n>>>3)|0){a=g>>>(n>>>3)<<(n>>>3)&(2<<(n>>>3)|0-(2<<(n>>>3)));f=((a&0-a)+-1|0)>>>(((a&0-a)+-1|0)>>>12&16);e=f>>>(f>>>5&8)>>>(f>>>(f>>>5&8)>>>2&4);e=(f>>>5&8|((a&0-a)+-1|0)>>>12&16|f>>>(f>>>5&8)>>>2&4|e>>>1&2|e>>>(e>>>1&2)>>>1&1)+(e>>>(e>>>1&2)>>>(e>>>(e>>>1&2)>>>1&1))|0;f=c[25792+(e<<1<<2)+8>>2]|0;a=c[f+8>>2]|0;do if((25792+(e<<1<<2)|0)!=(a|0)){if(a>>>0<(c[6442]|0)>>>0)Va();if((c[a+12>>2]|0)==(f|0)){c[a+12>>2]=25792+(e<<1<<2);c[25792+(e<<1<<2)+8>>2]=a;h=c[6440]|0;break}else Va()}else{c[6438]=g&~(1<<e);h=b}while(0);c[f+4>>2]=n|3;c[f+n+4>>2]=(e<<3)-n|1;c[f+n+((e<<3)-n)>>2]=(e<<3)-n;if(h|0){d=c[6443]|0;b=h>>>3;a=c[6438]|0;if(a&1<<b){a=c[25792+(b<<1<<2)+8>>2]|0;if(a>>>0<(c[6442]|0)>>>0)Va();else{i=25792+(b<<1<<2)+8|0;j=a}}else{c[6438]=a|1<<b;i=25792+(b<<1<<2)+8|0;j=25792+(b<<1<<2)|0}c[i>>2]=d;c[j+12>>2]=d;c[d+8>>2]=j;c[d+12>>2]=25792+(b<<1<<2)}c[6440]=(e<<3)-n;c[6443]=f+n;D=f+8|0;return D|0}a=c[6439]|0;if(a){i=((a&0-a)+-1|0)>>>(((a&0-a)+-1|0)>>>12&16);j=i>>>(i>>>5&8)>>>(i>>>(i>>>5&8)>>>2&4);j=c[26056+((i>>>5&8|((a&0-a)+-1|0)>>>12&16|i>>>(i>>>5&8)>>>2&4|j>>>1&2|j>>>(j>>>1&2)>>>1&1)+(j>>>(j>>>1&2)>>>(j>>>(j>>>1&2)>>>1&1))<<2)>>2]|0;i=(c[j+4>>2]&-8)-n|0;b=j;while(1){a=c[b+16>>2]|0;if(!a){a=c[b+20>>2]|0;if(!a)break}b=(c[a+4>>2]&-8)-n|0;D=b>>>0<i>>>0;i=D?b:i;b=a;j=D?a:j}f=c[6442]|0;if(j>>>0<f>>>0)Va();h=j+n|0;if(j>>>0>=h>>>0)Va();g=c[j+24>>2]|0;a=c[j+12>>2]|0;do if((a|0)==(j|0)){b=j+20|0;a=c[b>>2]|0;if(!a){b=j+16|0;a=c[b>>2]|0;if(!a){k=0;break}}while(1){d=a+20|0;e=c[d>>2]|0;if(e|0){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}if(b>>>0<f>>>0)Va();else{c[b>>2]=0;k=a;break}}else{b=c[j+8>>2]|0;if(b>>>0<f>>>0)Va();if((c[b+12>>2]|0)!=(j|0))Va();if((c[a+8>>2]|0)==(j|0)){c[b+12>>2]=a;c[a+8>>2]=b;k=a;break}else Va()}while(0);do if(g|0){a=c[j+28>>2]|0;if((j|0)==(c[26056+(a<<2)>>2]|0)){c[26056+(a<<2)>>2]=k;if(!k){c[6439]=c[6439]&~(1<<a);break}}else{if(g>>>0<(c[6442]|0)>>>0)Va();if((c[g+16>>2]|0)==(j|0))c[g+16>>2]=k;else c[g+20>>2]=k;if(!k)break}b=c[6442]|0;if(k>>>0<b>>>0)Va();c[k+24>>2]=g;a=c[j+16>>2]|0;do if(a|0)if(a>>>0<b>>>0)Va();else{c[k+16>>2]=a;c[a+24>>2]=k;break}while(0);a=c[j+20>>2]|0;if(a|0)if(a>>>0<(c[6442]|0)>>>0)Va();else{c[k+20>>2]=a;c[a+24>>2]=k;break}}while(0);if(i>>>0<16){D=i+n|0;c[j+4>>2]=D|3;D=j+D+4|0;c[D>>2]=c[D>>2]|1}else{c[j+4>>2]=n|3;c[h+4>>2]=i|1;c[h+i>>2]=i;b=c[6440]|0;if(b|0){d=c[6443]|0;a=c[6438]|0;if(a&1<<(b>>>3)){a=c[25792+(b>>>3<<1<<2)+8>>2]|0;if(a>>>0<(c[6442]|0)>>>0)Va();else{l=25792+(b>>>3<<1<<2)+8|0;m=a}}else{c[6438]=a|1<<(b>>>3);l=25792+(b>>>3<<1<<2)+8|0;m=25792+(b>>>3<<1<<2)|0}c[l>>2]=d;c[m+12>>2]=d;c[d+8>>2]=m;c[d+12>>2]=25792+(b>>>3<<1<<2)}c[6440]=i;c[6443]=h}D=j+8|0;return D|0}}}else if(a>>>0<=4294967231){n=a+11&-8;i=c[6439]|0;if(i){if((a+11|0)>>>8)if(n>>>0>16777215)h=31;else{h=(a+11|0)>>>8<<((((a+11|0)>>>8)+1048320|0)>>>16&8);h=14-((h+520192|0)>>>16&4|(((a+11|0)>>>8)+1048320|0)>>>16&8|((h<<((h+520192|0)>>>16&4))+245760|0)>>>16&2)+(h<<((h+520192|0)>>>16&4)<<(((h<<((h+520192|0)>>>16&4))+245760|0)>>>16&2)>>>15)|0;h=n>>>(h+7|0)&1|h<<1}else h=0;b=c[26056+(h<<2)>>2]|0;a:do if(!b){d=0-n|0;a=0;b=0;w=86}else{d=0-n|0;a=0;f=n<<((h|0)==31?0:25-(h>>>1)|0);g=b;b=0;while(1){e=c[g+4>>2]&-8;if((e-n|0)>>>0<d>>>0)if((e|0)==(n|0)){d=e-n|0;a=g;b=g;w=90;break a}else{d=e-n|0;b=g}e=c[g+20>>2]|0;g=c[g+16+(f>>>31<<2)>>2]|0;a=(e|0)==0|(e|0)==(g|0)?a:e;e=(g|0)==0;if(e){w=86;break}else f=f<<(e&1^1)}}while(0);if((w|0)==86){if((a|0)==0&(b|0)==0){a=2<<h;if(!(i&(a|0-a)))break;l=(i&(a|0-a)&0-(i&(a|0-a)))+-1|0;m=l>>>(l>>>12&16)>>>(l>>>(l>>>12&16)>>>5&8);a=m>>>(m>>>2&4)>>>(m>>>(m>>>2&4)>>>1&2);a=c[26056+((l>>>(l>>>12&16)>>>5&8|l>>>12&16|m>>>2&4|m>>>(m>>>2&4)>>>1&2|a>>>1&1)+(a>>>(a>>>1&1))<<2)>>2]|0}if(!a){i=d;j=b}else w=90}if((w|0)==90)while(1){w=0;m=(c[a+4>>2]&-8)-n|0;e=m>>>0<d>>>0;d=e?m:d;b=e?a:b;e=c[a+16>>2]|0;if(e|0){a=e;w=90;continue}a=c[a+20>>2]|0;if(!a){i=d;j=b;break}else w=90}if((j|0)!=0?i>>>0<((c[6440]|0)-n|0)>>>0:0){f=c[6442]|0;if(j>>>0<f>>>0)Va();h=j+n|0;if(j>>>0>=h>>>0)Va();g=c[j+24>>2]|0;a=c[j+12>>2]|0;do if((a|0)==(j|0)){b=j+20|0;a=c[b>>2]|0;if(!a){b=j+16|0;a=c[b>>2]|0;if(!a){p=0;break}}while(1){d=a+20|0;e=c[d>>2]|0;if(e|0){a=e;b=d;continue}d=a+16|0;e=c[d>>2]|0;if(!e)break;else{a=e;b=d}}if(b>>>0<f>>>0)Va();else{c[b>>2]=0;p=a;break}}else{b=c[j+8>>2]|0;if(b>>>0<f>>>0)Va();if((c[b+12>>2]|0)!=(j|0))Va();if((c[a+8>>2]|0)==(j|0)){c[b+12>>2]=a;c[a+8>>2]=b;p=a;break}else Va()}while(0);do if(g|0){a=c[j+28>>2]|0;if((j|0)==(c[26056+(a<<2)>>2]|0)){c[26056+(a<<2)>>2]=p;if(!p){c[6439]=c[6439]&~(1<<a);break}}else{if(g>>>0<(c[6442]|0)>>>0)Va();if((c[g+16>>2]|0)==(j|0))c[g+16>>2]=p;else c[g+20>>2]=p;if(!p)break}b=c[6442]|0;if(p>>>0<b>>>0)Va();c[p+24>>2]=g;a=c[j+16>>2]|0;do if(a|0)if(a>>>0<b>>>0)Va();else{c[p+16>>2]=a;c[a+24>>2]=p;break}while(0);a=c[j+20>>2]|0;if(a|0)if(a>>>0<(c[6442]|0)>>>0)Va();else{c[p+20>>2]=a;c[a+24>>2]=p;break}}while(0);do if(i>>>0>=16){c[j+4>>2]=n|3;c[h+4>>2]=i|1;c[h+i>>2]=i;b=i>>>3;if(i>>>0<256){a=c[6438]|0;if(a&1<<b){a=c[25792+(b<<1<<2)+8>>2]|0;if(a>>>0<(c[6442]|0)>>>0)Va();else{q=25792+(b<<1<<2)+8|0;r=a}}else{c[6438]=a|1<<b;q=25792+(b<<1<<2)+8|0;r=25792+(b<<1<<2)|0}c[q>>2]=h;c[r+12>>2]=h;c[h+8>>2]=r;c[h+12>>2]=25792+(b<<1<<2);break}a=i>>>8;if(a)if(i>>>0>16777215)d=31;else{d=a<<((a+1048320|0)>>>16&8)<<(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4);d=14-(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4|(a+1048320|0)>>>16&8|(d+245760|0)>>>16&2)+(d<<((d+245760|0)>>>16&2)>>>15)|0;d=i>>>(d+7|0)&1|d<<1}else d=0;e=26056+(d<<2)|0;c[h+28>>2]=d;c[h+16+4>>2]=0;c[h+16>>2]=0;a=c[6439]|0;b=1<<d;if(!(a&b)){c[6439]=a|b;c[e>>2]=h;c[h+24>>2]=e;c[h+12>>2]=h;c[h+8>>2]=h;break}d=i<<((d|0)==31?0:25-(d>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(i|0)){w=148;break}b=e+16+(d>>>31<<2)|0;a=c[b>>2]|0;if(!a){w=145;break}else{d=d<<1;e=a}}if((w|0)==145)if(b>>>0<(c[6442]|0)>>>0)Va();else{c[b>>2]=h;c[h+24>>2]=e;c[h+12>>2]=h;c[h+8>>2]=h;break}else if((w|0)==148){a=e+8|0;b=c[a>>2]|0;D=c[6442]|0;if(b>>>0>=D>>>0&e>>>0>=D>>>0){c[b+12>>2]=h;c[a>>2]=h;c[h+8>>2]=b;c[h+12>>2]=e;c[h+24>>2]=0;break}else Va()}}else{D=i+n|0;c[j+4>>2]=D|3;D=j+D+4|0;c[D>>2]=c[D>>2]|1}while(0);D=j+8|0;return D|0}}}else n=-1;while(0);d=c[6440]|0;if(d>>>0>=n>>>0){a=d-n|0;b=c[6443]|0;if(a>>>0>15){D=b+n|0;c[6443]=D;c[6440]=a;c[D+4>>2]=a|1;c[D+a>>2]=a;c[b+4>>2]=n|3}else{c[6440]=0;c[6443]=0;c[b+4>>2]=d|3;c[b+d+4>>2]=c[b+d+4>>2]|1}D=b+8|0;return D|0}a=c[6441]|0;if(a>>>0>n>>>0){B=a-n|0;c[6441]=B;D=c[6444]|0;C=D+n|0;c[6444]=C;c[C+4>>2]=B|1;c[D+4>>2]=n|3;D=D+8|0;return D|0}do if(!(c[6556]|0)){a=gb(30)|0;if(!(a+-1&a)){c[6558]=a;c[6557]=a;c[6559]=-1;c[6560]=-1;c[6561]=0;c[6549]=0;c[6556]=(sb(0)|0)&-16^1431655768;break}else Va()}while(0);f=n+48|0;d=c[6558]|0;g=n+47|0;h=d+g&0-d;if(h>>>0<=n>>>0){D=0;return D|0}a=c[6548]|0;if(a|0?(r=c[6546]|0,(r+h|0)>>>0<=r>>>0|(r+h|0)>>>0>a>>>0):0){D=0;return D|0}b:do if(!(c[6549]&4)){b=c[6444]|0;c:do if(b){e=26200;while(1){a=c[e>>2]|0;if(a>>>0<=b>>>0?(o=e+4|0,(a+(c[o>>2]|0)|0)>>>0>b>>>0):0)break;a=c[e+8>>2]|0;if(!a){w=173;break c}else e=a}a=d+g-(c[6441]|0)&0-d;if(a>>>0<2147483647){b=ab(a|0)|0;if((b|0)==((c[e>>2]|0)+(c[o>>2]|0)|0)){if((b|0)!=(-1|0)){h=b;g=a;w=193;break b}}else w=183}}else w=173;while(0);do if((w|0)==173?(s=ab(0)|0,(s|0)!=(-1|0)):0){a=c[6557]|0;if(!(a+-1&s))a=h;else a=h-s+(a+-1+s&0-a)|0;b=c[6546]|0;d=b+a|0;if(a>>>0>n>>>0&a>>>0<2147483647){r=c[6548]|0;if(r|0?d>>>0<=b>>>0|d>>>0>r>>>0:0)break;b=ab(a|0)|0;if((b|0)==(s|0)){h=s;g=a;w=193;break b}else w=183}}while(0);d:do if((w|0)==183){d=0-a|0;do if(f>>>0>a>>>0&(a>>>0<2147483647&(b|0)!=(-1|0))?(t=c[6558]|0,t=g-a+t&0-t,t>>>0<2147483647):0)if((ab(t|0)|0)==(-1|0)){ab(d|0)|0;break d}else{a=t+a|0;break}while(0);if((b|0)!=(-1|0)){h=b;g=a;w=193;break b}}while(0);c[6549]=c[6549]|4;w=190}else w=190;while(0);if((((w|0)==190?h>>>0<2147483647:0)?(u=ab(h|0)|0,v=ab(0)|0,u>>>0<v>>>0&((u|0)!=(-1|0)&(v|0)!=(-1|0))):0)?(v-u|0)>>>0>(n+40|0)>>>0:0){h=u;g=v-u|0;w=193}if((w|0)==193){a=(c[6546]|0)+g|0;c[6546]=a;if(a>>>0>(c[6547]|0)>>>0)c[6547]=a;k=c[6444]|0;do if(k){f=26200;while(1){a=c[f>>2]|0;b=f+4|0;d=c[b>>2]|0;if((h|0)==(a+d|0)){w=203;break}e=c[f+8>>2]|0;if(!e)break;else f=e}if(((w|0)==203?(c[f+12>>2]&8|0)==0:0)?k>>>0<h>>>0&k>>>0>=a>>>0:0){c[b>>2]=d+g;C=(k+8&7|0)==0?0:0-(k+8)&7;D=g-C+(c[6441]|0)|0;c[6444]=k+C;c[6441]=D;c[k+C+4>>2]=D|1;c[k+C+D+4>>2]=40;c[6445]=c[6560];break}a=c[6442]|0;if(h>>>0<a>>>0){c[6442]=h;j=h}else j=a;b=h+g|0;a=26200;while(1){if((c[a>>2]|0)==(b|0)){w=211;break}a=c[a+8>>2]|0;if(!a){b=26200;break}}if((w|0)==211)if(!(c[a+12>>2]&8)){c[a>>2]=h;m=a+4|0;c[m>>2]=(c[m>>2]|0)+g;m=h+8|0;m=h+((m&7|0)==0?0:0-m&7)|0;a=b+((b+8&7|0)==0?0:0-(b+8)&7)|0;l=m+n|0;i=a-m-n|0;c[m+4>>2]=n|3;do if((a|0)!=(k|0)){if((a|0)==(c[6443]|0)){D=(c[6440]|0)+i|0;c[6440]=D;c[6443]=l;c[l+4>>2]=D|1;c[l+D>>2]=D;break}h=c[a+4>>2]|0;if((h&3|0)==1){e:do if(h>>>0>=256){g=c[a+24>>2]|0;b=c[a+12>>2]|0;do if((b|0)==(a|0)){b=c[a+16+4>>2]|0;if(!b){b=c[a+16>>2]|0;if(!b){B=0;break}else f=a+16|0}else f=a+16+4|0;while(1){d=b+20|0;e=c[d>>2]|0;if(e|0){b=e;f=d;continue}d=b+16|0;e=c[d>>2]|0;if(!e)break;else{b=e;f=d}}if(f>>>0<j>>>0)Va();else{c[f>>2]=0;B=b;break}}else{d=c[a+8>>2]|0;if(d>>>0<j>>>0)Va();if((c[d+12>>2]|0)!=(a|0))Va();if((c[b+8>>2]|0)==(a|0)){c[d+12>>2]=b;c[b+8>>2]=d;B=b;break}else Va()}while(0);if(!g)break;b=c[a+28>>2]|0;do if((a|0)!=(c[26056+(b<<2)>>2]|0)){if(g>>>0<(c[6442]|0)>>>0)Va();if((c[g+16>>2]|0)==(a|0))c[g+16>>2]=B;else c[g+20>>2]=B;if(!B)break e}else{c[26056+(b<<2)>>2]=B;if(B|0)break;c[6439]=c[6439]&~(1<<b);break e}while(0);d=c[6442]|0;if(B>>>0<d>>>0)Va();c[B+24>>2]=g;b=c[a+16>>2]|0;do if(b|0)if(b>>>0<d>>>0)Va();else{c[B+16>>2]=b;c[b+24>>2]=B;break}while(0);b=c[a+16+4>>2]|0;if(!b)break;if(b>>>0<(c[6442]|0)>>>0)Va();else{c[B+20>>2]=b;c[b+24>>2]=B;break}}else{b=c[a+8>>2]|0;d=c[a+12>>2]|0;do if((b|0)!=(25792+(h>>>3<<1<<2)|0)){if(b>>>0<j>>>0)Va();if((c[b+12>>2]|0)==(a|0))break;Va()}while(0);if((d|0)==(b|0)){c[6438]=c[6438]&~(1<<(h>>>3));break}do if((d|0)==(25792+(h>>>3<<1<<2)|0))z=d+8|0;else{if(d>>>0<j>>>0)Va();if((c[d+8>>2]|0)==(a|0)){z=d+8|0;break}Va()}while(0);c[b+12>>2]=d;c[z>>2]=b}while(0);a=a+(h&-8)|0;f=(h&-8)+i|0}else f=i;b=a+4|0;c[b>>2]=c[b>>2]&-2;c[l+4>>2]=f|1;c[l+f>>2]=f;b=f>>>3;if(f>>>0<256){a=c[6438]|0;do if(!(a&1<<b)){c[6438]=a|1<<b;C=25792+(b<<1<<2)+8|0;D=25792+(b<<1<<2)|0}else{a=c[25792+(b<<1<<2)+8>>2]|0;if(a>>>0>=(c[6442]|0)>>>0){C=25792+(b<<1<<2)+8|0;D=a;break}Va()}while(0);c[C>>2]=l;c[D+12>>2]=l;c[l+8>>2]=D;c[l+12>>2]=25792+(b<<1<<2);break}a=f>>>8;do if(!a)d=0;else{if(f>>>0>16777215){d=31;break}d=a<<((a+1048320|0)>>>16&8)<<(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4);d=14-(((a<<((a+1048320|0)>>>16&8))+520192|0)>>>16&4|(a+1048320|0)>>>16&8|(d+245760|0)>>>16&2)+(d<<((d+245760|0)>>>16&2)>>>15)|0;d=f>>>(d+7|0)&1|d<<1}while(0);e=26056+(d<<2)|0;c[l+28>>2]=d;c[l+16+4>>2]=0;c[l+16>>2]=0;a=c[6439]|0;b=1<<d;if(!(a&b)){c[6439]=a|b;c[e>>2]=l;c[l+24>>2]=e;c[l+12>>2]=l;c[l+8>>2]=l;break}d=f<<((d|0)==31?0:25-(d>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(f|0)){w=281;break}b=e+16+(d>>>31<<2)|0;a=c[b>>2]|0;if(!a){w=278;break}else{d=d<<1;e=a}}if((w|0)==278)if(b>>>0<(c[6442]|0)>>>0)Va();else{c[b>>2]=l;c[l+24>>2]=e;c[l+12>>2]=l;c[l+8>>2]=l;break}else if((w|0)==281){a=e+8|0;b=c[a>>2]|0;D=c[6442]|0;if(b>>>0>=D>>>0&e>>>0>=D>>>0){c[b+12>>2]=l;c[a>>2]=l;c[l+8>>2]=b;c[l+12>>2]=e;c[l+24>>2]=0;break}else Va()}}else{D=(c[6441]|0)+i|0;c[6441]=D;c[6444]=l;c[l+4>>2]=D|1}while(0);D=m+8|0;return D|0}else b=26200;while(1){a=c[b>>2]|0;if(a>>>0<=k>>>0?(x=a+(c[b+4>>2]|0)|0,x>>>0>k>>>0):0)break;b=c[b+8>>2]|0}f=x+-47+((x+-47+8&7|0)==0?0:0-(x+-47+8)&7)|0;f=f>>>0<(k+16|0)>>>0?k:f;a=h+8|0;a=(a&7|0)==0?0:0-a&7;D=h+a|0;a=g+-40-a|0;c[6444]=D;c[6441]=a;c[D+4>>2]=a|1;c[D+a+4>>2]=40;c[6445]=c[6560];c[f+4>>2]=27;c[f+8>>2]=c[6550];c[f+8+4>>2]=c[6551];c[f+8+8>>2]=c[6552];c[f+8+12>>2]=c[6553];c[6550]=h;c[6551]=g;c[6553]=0;c[6552]=f+8;a=f+24|0;do{a=a+4|0;c[a>>2]=7}while((a+4|0)>>>0<x>>>0);if((f|0)!=(k|0)){c[f+4>>2]=c[f+4>>2]&-2;c[k+4>>2]=f-k|1;c[f>>2]=f-k;if((f-k|0)>>>0<256){b=25792+((f-k|0)>>>3<<1<<2)|0;a=c[6438]|0;if(a&1<<((f-k|0)>>>3)){a=c[b+8>>2]|0;if(a>>>0<(c[6442]|0)>>>0)Va();else{y=b+8|0;A=a}}else{c[6438]=a|1<<((f-k|0)>>>3);y=b+8|0;A=b}c[y>>2]=k;c[A+12>>2]=k;c[k+8>>2]=A;c[k+12>>2]=b;break}if((f-k|0)>>>8)if((f-k|0)>>>0>16777215)d=31;else{d=(f-k|0)>>>8<<((((f-k|0)>>>8)+1048320|0)>>>16&8);d=14-((d+520192|0)>>>16&4|(((f-k|0)>>>8)+1048320|0)>>>16&8|((d<<((d+520192|0)>>>16&4))+245760|0)>>>16&2)+(d<<((d+520192|0)>>>16&4)<<(((d<<((d+520192|0)>>>16&4))+245760|0)>>>16&2)>>>15)|0;d=(f-k|0)>>>(d+7|0)&1|d<<1}else d=0;e=26056+(d<<2)|0;c[k+28>>2]=d;c[k+20>>2]=0;c[k+16>>2]=0;a=c[6439]|0;b=1<<d;if(!(a&b)){c[6439]=a|b;c[e>>2]=k;c[k+24>>2]=e;c[k+12>>2]=k;c[k+8>>2]=k;break}d=f-k<<((d|0)==31?0:25-(d>>>1)|0);e=c[e>>2]|0;while(1){if((c[e+4>>2]&-8|0)==(f-k|0)){w=307;break}b=e+16+(d>>>31<<2)|0;a=c[b>>2]|0;if(!a){w=304;break}else{d=d<<1;e=a}}if((w|0)==304)if(b>>>0<(c[6442]|0)>>>0)Va();else{c[b>>2]=k;c[k+24>>2]=e;c[k+12>>2]=k;c[k+8>>2]=k;break}else if((w|0)==307){a=e+8|0;b=c[a>>2]|0;D=c[6442]|0;if(b>>>0>=D>>>0&e>>>0>=D>>>0){c[b+12>>2]=k;c[a>>2]=k;c[k+8>>2]=b;c[k+12>>2]=e;c[k+24>>2]=0;break}else Va()}}}else{D=c[6442]|0;if((D|0)==0|h>>>0<D>>>0)c[6442]=h;c[6550]=h;c[6551]=g;c[6553]=0;c[6447]=c[6556];c[6446]=-1;a=0;do{D=25792+(a<<1<<2)|0;c[D+12>>2]=D;c[D+8>>2]=D;a=a+1|0}while((a|0)!=32);D=h+8|0;D=(D&7|0)==0?0:0-D&7;C=h+D|0;D=g+-40-D|0;c[6444]=C;c[6441]=D;c[C+4>>2]=D|1;c[C+D+4>>2]=40;c[6445]=c[6560]}while(0);a=c[6441]|0;if(a>>>0>n>>>0){B=a-n|0;c[6441]=B;D=c[6444]|0;C=D+n|0;c[6444]=C;c[C+4>>2]=B|1;c[D+4>>2]=n|3;D=D+8|0;return D|0}}if(!0)a=25748;else a=c[(ib()|0)+64>>2]|0;c[a>>2]=12;D=0;return D|0}function zc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0,s=0,t=0,u=0.0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0,L=0,M=0,N=0,P=0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0;P=i;i=i+448|0;if(!(a[b+527>>0]|0)){i=P;return}N=c[b+28>>2]|0;x=+g[b+348>>2];w=+g[b+352>>2];D=+g[b+356>>2];y=+g[N+52>>2];z=x*+g[N+4>>2]+w*+g[N+8>>2]+D*+g[N+12>>2]+y;A=+g[N+56>>2];B=x*+g[N+20>>2]+w*+g[N+24>>2]+D*+g[N+28>>2]+A;C=+g[N+60>>2];D=x*+g[N+36>>2]+w*+g[N+40>>2]+D*+g[N+44>>2]+C;N=c[b+32>>2]|0;w=+g[b+412>>2];x=+g[b+416>>2];l=+g[b+420>>2];E=+g[N+52>>2];F=w*+g[N+4>>2]+x*+g[N+8>>2]+l*+g[N+12>>2]+E;G=+g[N+56>>2];H=w*+g[N+20>>2]+x*+g[N+24>>2]+l*+g[N+28>>2]+G;k=+g[N+60>>2];l=w*+g[N+36>>2]+x*+g[N+40>>2]+l*+g[N+44>>2]+k;if(!(a[b+524>>0]|0)){u=+g[d+192>>2]+ +g[d+80>>2];w=+g[d+196>>2]+ +g[d+84>>2];q=+g[d+200>>2]+ +g[d+88>>2];x=+g[e+192>>2]+ +g[e+80>>2];p=+g[e+196>>2]+ +g[e+84>>2];n=+g[e+200>>2]+ +g[e+88>>2];m=+g[d+176>>2]+ +g[d+64>>2]+((D-C)*w-(B-A)*q)-(+g[e+176>>2]+ +g[e+64>>2]+((l-k)*p-(H-G)*n));n=+g[d+180>>2]+ +g[d+68>>2]+((z-y)*q-(D-C)*u)-(+g[e+180>>2]+ +g[e+68>>2]+((F-E)*n-(l-k)*x));p=+g[d+184>>2]+ +g[d+72>>2]+((B-A)*u-(z-y)*w)-(+g[e+184>>2]+ +g[e+72>>2]+((H-G)*x-(F-E)*p));o=(c[d+240>>2]|0)==0;v=0;do{x=1.0/+g[b+48+(v*84|0)+80>>2];r=b+48+(v*84|0)|0;w=+g[r>>2];s=b+48+(v*84|0)+4|0;u=+g[s>>2];t=b+48+(v*84|0)+8|0;q=+g[t>>2];q=x*(((z-F)*w+(B-H)*u+(D-l)*q)*-.30000001192092896/f)-x*(m*w+n*u+p*q);g[b+36>>2]=+g[b+36>>2]+q;u=+g[t>>2];w=+g[s>>2];x=+g[r>>2];h=c[b+28>>2]|0;j=+g[h+344>>2];if(!o){S=((B-A)*u-(D-C)*w)*+g[h+296>>2]+((D-C)*x-(z-y)*u)*+g[h+300>>2]+((z-y)*w-(B-A)*x)*+g[h+304>>2];Q=((B-A)*u-(D-C)*w)*+g[h+280>>2]+((D-C)*x-(z-y)*u)*+g[h+284>>2]+((z-y)*w-(B-A)*x)*+g[h+288>>2];R=((B-A)*u-(D-C)*w)*+g[h+264>>2]+((D-C)*x-(z-y)*u)*+g[h+268>>2]+((z-y)*w-(B-A)*x)*+g[h+272>>2];U=q*w*j*+g[d+116>>2];T=q*u*j*+g[d+120>>2];g[d+64>>2]=q*x*j*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=U+ +g[d+68>>2];g[d+72>>2]=T+ +g[d+72>>2];Q=Q*q*+g[d+100>>2];j=S*q*+g[d+104>>2];g[d+80>>2]=R*q*+g[d+96>>2]+ +g[d+80>>2];g[d+84>>2]=Q+ +g[d+84>>2];g[d+88>>2]=j+ +g[d+88>>2]}h=c[b+32>>2]|0;j=+g[h+344>>2];if(c[e+240>>2]|0){U=((H-G)*u-(l-k)*w)*+g[h+296>>2]+((l-k)*x-(F-E)*u)*+g[h+300>>2]+((F-E)*w-(H-G)*x)*+g[h+304>>2];T=((H-G)*u-(l-k)*w)*+g[h+280>>2]+((l-k)*x-(F-E)*u)*+g[h+284>>2]+((F-E)*w-(H-G)*x)*+g[h+288>>2];S=((H-G)*u-(l-k)*w)*+g[h+264>>2]+((l-k)*x-(F-E)*u)*+g[h+268>>2]+((F-E)*w-(H-G)*x)*+g[h+272>>2];Q=j*+g[s>>2]*-q*+g[e+116>>2];R=j*+g[t>>2]*-q*+g[e+120>>2];g[e+64>>2]=+g[e+112>>2]*j*+g[r>>2]*-q+ +g[e+64>>2];g[e+68>>2]=Q+ +g[e+68>>2];g[e+72>>2]=R+ +g[e+72>>2];T=T*+g[e+100>>2]*-q;U=U*+g[e+104>>2]*-q;g[e+80>>2]=S*+g[e+96>>2]*-q+ +g[e+80>>2];g[e+84>>2]=T+ +g[e+84>>2];g[e+88>>2]=U+ +g[e+88>>2]}v=v+1|0}while((v|0)!=3)}do if(!(a[b+552>>0]|0)){j=+g[b+440>>2];if(!(j>1.1920928955078125e-07)){I=d+80|0;o=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0;break}k=+g[e+192>>2]+ +g[e+80>>2]-(+g[d+192>>2]+ +g[d+80>>2]);l=+g[e+196>>2]+ +g[e+84>>2]-(+g[d+196>>2]+ +g[d+84>>2]);m=+g[e+200>>2]+ +g[e+88>>2]-(+g[d+200>>2]+ +g[d+88>>2]);if(k*k+l*l+m*m>1.1920928955078125e-07){C=1.0/+O(+(k*k+l*l+m*m));h=c[b+28>>2]|0;p=+g[h+264>>2];q=+g[h+280>>2];u=+g[h+296>>2];w=+g[h+268>>2];x=+g[h+284>>2];y=+g[h+300>>2];z=+g[h+272>>2];A=+g[h+288>>2];B=+g[h+304>>2];h=c[b+32>>2]|0;j=j*(1.0/(k*C*(p*k*C+l*C*q+m*C*u)+l*C*(k*C*w+l*C*x+m*C*y)+m*C*(k*C*z+l*C*A+m*C*B)+(k*C*(k*C*+g[h+264>>2]+l*C*+g[h+280>>2]+m*C*+g[h+296>>2])+l*C*(k*C*+g[h+268>>2]+l*C*+g[h+284>>2]+m*C*+g[h+300>>2])+m*C*(k*C*+g[h+272>>2]+l*C*+g[h+288>>2]+m*C*+g[h+304>>2]))));C=+O(+(m*j*m*j+(k*j*k*j+l*j*l*j)));n=1.0/C*k*j;k=1.0/C*l*j;j=1.0/C*m*j;if(c[d+240>>2]|0){U=C*0.0*+g[d+116>>2];T=C*0.0*+g[d+120>>2];g[d+64>>2]=C*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=U+ +g[d+68>>2];g[d+72>>2]=T+ +g[d+72>>2];T=(n*q+k*x+j*A)*C*+g[d+100>>2];U=(n*u+k*y+j*B)*C*+g[d+104>>2];g[d+80>>2]=(n*p+k*w+j*z)*C*+g[d+96>>2]+ +g[d+80>>2];g[d+84>>2]=T+ +g[d+84>>2];g[d+88>>2]=U+ +g[d+88>>2];h=c[b+32>>2]|0}if(c[e+240>>2]|0){U=n*+g[h+296>>2]+k*+g[h+300>>2]+j*+g[h+304>>2];T=n*+g[h+280>>2]+k*+g[h+284>>2]+j*+g[h+288>>2];S=n*+g[h+264>>2]+k*+g[h+268>>2]+j*+g[h+272>>2];Q=C*-0.0*+g[e+116>>2];R=C*-0.0*+g[e+120>>2];g[e+64>>2]=C*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=Q+ +g[e+68>>2];g[e+72>>2]=R+ +g[e+72>>2];T=T*+g[e+100>>2]*-C;U=U*+g[e+104>>2]*-C;g[e+80>>2]=S*+g[e+96>>2]*-C+ +g[e+80>>2];g[e+84>>2]=T+ +g[e+84>>2];g[e+88>>2]=U+ +g[e+88>>2];I=d+80|0;o=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}else{I=d+80|0;o=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}}else{I=d+80|0;o=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}}else{M=c[b+28>>2]|0;c[P+352>>2]=c[M+4>>2];c[P+352+4>>2]=c[M+4+4>>2];c[P+352+8>>2]=c[M+4+8>>2];c[P+352+12>>2]=c[M+4+12>>2];c[P+352+16>>2]=c[M+20>>2];c[P+352+16+4>>2]=c[M+20+4>>2];c[P+352+16+8>>2]=c[M+20+8>>2];c[P+352+16+12>>2]=c[M+20+12>>2];c[P+352+32>>2]=c[M+36>>2];c[P+352+32+4>>2]=c[M+36+4>>2];c[P+352+32+8>>2]=c[M+36+8>>2];c[P+352+32+12>>2]=c[M+36+12>>2];c[P+352+48>>2]=c[M+52>>2];c[P+352+48+4>>2]=c[M+52+4>>2];c[P+352+48+8>>2]=c[M+52+8>>2];c[P+352+48+12>>2]=c[M+52+12>>2];M=c[b+32>>2]|0;c[P+288>>2]=c[M+4>>2];c[P+288+4>>2]=c[M+4+4>>2];c[P+288+8>>2]=c[M+4+8>>2];c[P+288+12>>2]=c[M+4+12>>2];c[P+288+16>>2]=c[M+20>>2];c[P+288+16+4>>2]=c[M+20+4>>2];c[P+288+16+8>>2]=c[M+20+8>>2];c[P+288+16+12>>2]=c[M+20+12>>2];c[P+288+32>>2]=c[M+36>>2];c[P+288+32+4>>2]=c[M+36+4>>2];c[P+288+32+8>>2]=c[M+36+8>>2];c[P+288+32+12>>2]=c[M+36+12>>2];c[P+288+48>>2]=c[M+52>>2];c[P+288+48+4>>2]=c[M+52+4>>2];c[P+288+48+8>>2]=c[M+52+8>>2];c[P+288+48+12>>2]=c[M+52+12>>2];S=+g[d+196>>2]+ +g[d+84>>2];u=+g[d+200>>2]+ +g[d+88>>2];g[P+272>>2]=+g[d+192>>2]+ +g[d+80>>2];g[P+272+4>>2]=S;g[P+272+8>>2]=u;g[P+272+12>>2]=0.0;u=+g[e+196>>2]+ +g[e+84>>2];S=+g[e+200>>2]+ +g[e+88>>2];g[P+256>>2]=+g[e+192>>2]+ +g[e+80>>2];g[P+256+4>>2]=u;g[P+256+8>>2]=S;g[P+256+12>>2]=0.0;c[P+192>>2]=1065353216;M=P+192+4|0;c[M>>2]=0;c[M+4>>2]=0;c[M+8>>2]=0;c[M+12>>2]=0;c[P+192+20>>2]=1065353216;N=P+192+24|0;c[N>>2]=0;c[N+4>>2]=0;c[N+8>>2]=0;c[N+12>>2]=0;c[P+192+40>>2]=1065353216;K=P+192+44|0;c[K>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;c[K+16>>2]=0;Zg(P+352|0,0.0,0.0,0.0,P+272|0,f,P+192|0);c[P+128>>2]=1065353216;K=P+128+4|0;c[K>>2]=0;c[K+4>>2]=0;c[K+8>>2]=0;c[K+12>>2]=0;c[P+128+20>>2]=1065353216;L=P+128+24|0;c[L>>2]=0;c[L+4>>2]=0;c[L+8>>2]=0;c[L+12>>2]=0;c[P+128+40>>2]=1065353216;J=P+128+44|0;c[J>>2]=0;c[J+4>>2]=0;c[J+8>>2]=0;c[J+12>>2]=0;c[J+16>>2]=0;Zg(P+288|0,0.0,0.0,0.0,P+256|0,f,P+128|0);S=+g[b+556>>2];u=+g[b+560>>2];T=+g[b+564>>2];w=+g[b+568>>2];F=S*(2.0/(S*S+u*u+T*T+w*w));A=u*(2.0/(S*S+u*u+T*T+w*w));G=T*(2.0/(S*S+u*u+T*T+w*w));W=+g[b+364>>2];V=+g[b+368>>2];Z=+g[b+372>>2];k=Z*(S*G-w*A)+(V*(S*A+w*G)+W*(1.0-(u*A+T*G)));l=Z*(u*G+w*F)+(W*(S*A-w*G)+V*(1.0-(S*F+T*G)));m=W*(S*G+w*A)+V*(u*G-w*F)+Z*(1.0-(S*F+u*A));j=+g[b+380>>2];E=+g[b+384>>2];B=+g[b+388>>2];n=(S*G-w*A)*B+(E*(S*A+w*G)+j*(1.0-(u*A+T*G)));p=(u*G+w*F)*B+(j*(S*A-w*G)+E*(1.0-(S*F+T*G)));q=j*(S*G+w*A)+E*(u*G-w*F)+B*(1.0-(S*F+u*A));Q=+g[b+396>>2];C=+g[b+400>>2];z=+g[b+404>>2];R=(1.0-(u*A+T*G))*Q+(S*A+w*G)*C+(S*G-w*A)*z;T=(S*A-w*G)*Q+(1.0-(S*F+T*G))*C+(u*G+w*F)*z;A=(S*G+w*A)*Q+(u*G-w*F)*C+(1.0-(S*F+u*A))*z;u=+g[b+300>>2];F=+g[b+316>>2];S=+g[b+332>>2];w=+g[b+304>>2];G=+g[b+320>>2];U=+g[b+336>>2];D=+g[b+308>>2];H=+g[b+324>>2];y=+g[b+340>>2];x=-+g[b+348>>2];aa=-+g[b+352>>2];Y=-+g[b+356>>2];Z=W*0.0+V*0.0+Z*0.0+ +g[b+412>>2]+(m*(D*x+H*aa+y*Y)+(k*(u*x+F*aa+S*Y)+l*(w*x+G*aa+U*Y)));B=j*0.0+E*0.0+B*0.0+ +g[b+416>>2]+(q*(D*x+H*aa+y*Y)+(n*(u*x+F*aa+S*Y)+p*(w*x+G*aa+U*Y)));Y=Q*0.0+C*0.0+z*0.0+ +g[b+420>>2]+(A*(D*x+H*aa+y*Y)+(R*(u*x+F*aa+S*Y)+T*(w*x+G*aa+U*Y)));aa=+g[P+128>>2];x=+g[K>>2];z=+g[P+128+8>>2];C=+g[P+128+16>>2];Q=+g[P+128+20>>2];E=+g[L>>2];j=+g[P+128+32>>2];V=+g[P+128+36>>2];W=+g[P+128+40>>2];X=z*Y+(aa*Z+x*B)+ +g[P+128+48>>2];_=C*Z+B*Q+Y*E+ +g[P+128+52>>2];$=Z*j+B*V+Y*W+ +g[P+128+56>>2];g[P+64>>2]=(k*u+l*w+m*D)*aa+(n*u+p*w+q*D)*x+(R*u+T*w+A*D)*z;g[P+64+4>>2]=(k*F+l*G+m*H)*aa+(n*F+p*G+q*H)*x+(R*F+T*G+A*H)*z;g[P+64+8>>2]=(k*S+l*U+m*y)*aa+(n*S+p*U+q*y)*x+(R*S+T*U+A*y)*z;g[P+64+12>>2]=0.0;g[P+64+16>>2]=(k*u+l*w+m*D)*C+(n*u+p*w+q*D)*Q+(R*u+T*w+A*D)*E;g[P+64+20>>2]=(k*F+l*G+m*H)*C+(n*F+p*G+q*H)*Q+(R*F+T*G+A*H)*E;g[P+64+24>>2]=(k*S+l*U+m*y)*C+(n*S+p*U+q*y)*Q+(R*S+T*U+A*y)*E;g[P+64+28>>2]=0.0;g[P+64+32>>2]=(k*u+l*w+m*D)*j+(n*u+p*w+q*D)*V+(R*u+T*w+A*D)*W;g[P+64+36>>2]=(k*F+l*G+m*H)*j+(n*F+p*G+q*H)*V+(R*F+T*G+A*H)*W;g[P+64+40>>2]=(k*S+l*U+m*y)*j+(n*S+p*U+q*y)*V+(R*S+T*U+A*y)*W;g[P+64+44>>2]=0.0;g[P+64+48>>2]=X;g[P+64+52>>2]=_;g[P+64+56>>2]=$;g[P+64+60>>2]=0.0;$=(R*u+T*w+A*D)*-Y+((k*u+l*w+m*D)*-Z+(n*u+p*w+q*D)*-B);_=(R*F+T*G+A*H)*-Y+((k*F+l*G+m*H)*-Z+(n*F+p*G+q*H)*-B);B=(R*S+T*U+A*y)*-Y+((k*S+l*U+m*y)*-Z+(n*S+p*U+q*y)*-B);Z=+g[P+192>>2];Y=+g[M>>2];X=+g[P+192+8>>2];W=+g[P+192+16>>2];V=+g[P+192+20>>2];j=+g[N>>2];E=+g[P+192+32>>2];Q=+g[P+192+36>>2];C=+g[P+192+40>>2];z=$*Z+_*Y+B*X+ +g[P+192+48>>2];x=$*W+_*V+B*j+ +g[P+192+52>>2];B=$*E+_*Q+B*C+ +g[P+192+56>>2];g[P>>2]=(k*u+l*w+m*D)*Z+(k*F+l*G+m*H)*Y+(k*S+l*U+m*y)*X;g[P+4>>2]=(n*u+p*w+q*D)*Z+(n*F+p*G+q*H)*Y+(n*S+p*U+q*y)*X;g[P+8>>2]=(R*u+T*w+A*D)*Z+(R*F+T*G+A*H)*Y+(R*S+T*U+A*y)*X;g[P+12>>2]=0.0;g[P+16>>2]=(k*u+l*w+m*D)*W+(k*F+l*G+m*H)*V+(k*S+l*U+m*y)*j;g[P+20>>2]=(n*u+p*w+q*D)*W+(n*F+p*G+q*H)*V+(n*S+p*U+q*y)*j;g[P+24>>2]=(R*u+T*w+A*D)*W+(R*F+T*G+A*H)*V+(R*S+T*U+A*y)*j;g[P+28>>2]=0.0;g[P+32>>2]=(k*u+l*w+m*D)*E+(k*F+l*G+m*H)*Q+(k*S+l*U+m*y)*C;g[P+36>>2]=(n*u+p*w+q*D)*E+(n*F+p*G+q*H)*Q+(n*S+p*U+q*y)*C;g[P+40>>2]=(R*u+T*w+A*D)*E+(R*F+T*G+A*H)*Q+(R*S+T*U+A*y)*C;g[P+44>>2]=0.0;g[P+48>>2]=z;g[P+52>>2]=x;g[P+56>>2]=B;g[P+60>>2]=0.0;Gf(P+352|0,P+64|0,P+424|0,P+416|0);B=+g[P+416>>2];x=1.0/f*+g[P+424>>2]*B;z=1.0/f*B*+g[P+424+4>>2];B=1.0/f*B*+g[P+424+8>>2];Gf(P+288|0,P,P+424|0,P+416|0);C=+g[P+416>>2];x=x-+g[P+272>>2];z=z-+g[P+272+4>>2];B=B-+g[P+272+8>>2];y=1.0/f*+g[P+424>>2]*C-+g[P+256>>2];A=1.0/f*C*+g[P+424+4>>2]-+g[P+256+4>>2];C=1.0/f*C*+g[P+424+8>>2]-+g[P+256+8>>2];if(x*x+z*z+B*B>1.1920928955078125e-07){q=1.0/+O(+(x*x+z*z+B*B));N=c[b+28>>2]|0;j=x*q;l=z*q;n=B*q;q=x*q*(+g[N+264>>2]*x*q+z*q*+g[N+280>>2]+B*q*+g[N+296>>2])+z*q*(x*q*+g[N+268>>2]+z*q*+g[N+284>>2]+B*q*+g[N+300>>2])+B*q*(x*q*+g[N+272>>2]+z*q*+g[N+288>>2]+B*q*+g[N+304>>2])}else{j=0.0;l=0.0;n=0.0;q=0.0}if(y*y+A*A+C*C>1.1920928955078125e-07){u=1.0/+O(+(y*y+A*A+C*C));N=c[b+32>>2]|0;k=y*u;m=A*u;p=C*u;u=y*u*(+g[N+264>>2]*y*u+A*u*+g[N+280>>2]+C*u*+g[N+296>>2])+A*u*(y*u*+g[N+268>>2]+A*u*+g[N+284>>2]+C*u*+g[N+300>>2])+C*u*(y*u*+g[N+272>>2]+A*u*+g[N+288>>2]+C*u*+g[N+304>>2])}else{k=0.0;m=0.0;p=0.0;u=0.0}w=q*j+u*k;k=q*l+u*m;j=q*n+u*p;if(w*w+k*k+j*j>1.1920928955078125e-07){n=1.0/+O(+(w*w+k*k+j*j));o=c[b+28>>2]|0;l=w*n*(+g[o+264>>2]*w*n+k*n*+g[o+280>>2]+j*n*+g[o+296>>2])+k*n*(w*n*+g[o+268>>2]+k*n*+g[o+284>>2]+j*n*+g[o+300>>2])+j*n*(w*n*+g[o+272>>2]+k*n*+g[o+288>>2]+j*n*+g[o+304>>2]);h=c[b+32>>2]|0;n=w*n*(w*n*+g[h+264>>2]+k*n*+g[h+280>>2]+j*n*+g[h+296>>2])+k*n*(w*n*+g[h+268>>2]+k*n*+g[h+284>>2]+j*n*+g[h+300>>2])+j*n*(w*n*+g[h+272>>2]+k*n*+g[h+288>>2]+j*n*+g[h+304>>2]);k=(x*l-y*n)*(1.0/((l+n)*(l+n)));u=(z*l-A*n)*(1.0/((l+n)*(l+n)));n=(B*l-C*n)*(1.0/((l+n)*(l+n)));j=+g[b+572>>2];if(!(j>=0.0))j=u;else{l=(a[b+553>>0]|0)==0?j:j/l;m=+g[b+576>>2];p=+g[b+580>>2];q=+g[b+584>>2];j=+O(+((k+m)*(k+m)+(u+p)*(u+p)+(n+q)*(n+q)));if(j>l){k=l*(k+m)*(1.0/j)-m;n=l*(n+q)*(1.0/j)-q;j=l*(u+p)*(1.0/j)-p}else j=u;g[b+576>>2]=k+m;g[b+580>>2]=j+p;g[b+584>>2]=n+q}m=+O(+(k*k+j*j+n*n));l=k*(1.0/m);k=j*(1.0/m);j=n*(1.0/m);if(c[d+240>>2]|0){aa=l*+g[o+296>>2]+k*+g[o+300>>2]+j*+g[o+304>>2];$=l*+g[o+280>>2]+k*+g[o+284>>2]+j*+g[o+288>>2];_=l*+g[o+264>>2]+k*+g[o+268>>2]+j*+g[o+272>>2];Y=m*0.0*+g[d+116>>2];Z=m*0.0*+g[d+120>>2];g[d+64>>2]=m*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=Y+ +g[d+68>>2];g[d+72>>2]=Z+ +g[d+72>>2];$=$*m*+g[d+100>>2];aa=aa*m*+g[d+104>>2];g[d+80>>2]=_*m*+g[d+96>>2]+ +g[d+80>>2];g[d+84>>2]=$+ +g[d+84>>2];g[d+88>>2]=aa+ +g[d+88>>2];h=c[b+32>>2]|0}if(c[e+240>>2]|0){aa=l*+g[h+296>>2]+k*+g[h+300>>2]+j*+g[h+304>>2];$=l*+g[h+280>>2]+k*+g[h+284>>2]+j*+g[h+288>>2];_=l*+g[h+264>>2]+k*+g[h+268>>2]+j*+g[h+272>>2];Y=m*-0.0*+g[e+116>>2];Z=m*-0.0*+g[e+120>>2];g[e+64>>2]=m*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=Y+ +g[e+68>>2];g[e+72>>2]=Z+ +g[e+72>>2];$=$*+g[e+100>>2]*-m;aa=aa*+g[e+104>>2]*-m;g[e+80>>2]=_*+g[e+96>>2]*-m+ +g[e+80>>2];g[e+84>>2]=$+ +g[e+84>>2];g[e+88>>2]=aa+ +g[e+88>>2]}}I=d+80|0;o=d+196|0;J=d+84|0;r=d+200|0;K=d+88|0;s=e+192|0;L=e+80|0;t=e+196|0;M=e+84|0;v=e+200|0;N=e+88|0;h=d+192|0}while(0);z=+g[h>>2]+ +g[I>>2];y=+g[o>>2]+ +g[J>>2];x=+g[r>>2]+ +g[K>>2];w=+g[s>>2]+ +g[L>>2];u=+g[t>>2]+ +g[M>>2];q=+g[v>>2]+ +g[N>>2];if(a[b+526>>0]|0){k=+g[b+528>>2];j=k*+g[b+504>>2]*+g[b+432>>2]/f;l=+g[b+460>>2];m=+g[b+464>>2];n=+g[b+468>>2];if((w-z)*l+(u-y)*m+(q-x)*n>0.0)j=j+k*((w-z)*l+(u-y)*m+(q-x)*n)*+g[b+436>>2];$=+g[b+516>>2];_=$+j*+g[b+492>>2];_=_>0.0?_:0.0;g[b+516>>2]=_;Z=+g[b+536>>2];k=+g[b+540>>2];aa=+g[b+544>>2];j=l*(_-$)*Z+m*(_-$)*k+(_-$)*n*aa;p=+O(+(((_-$)*n-aa*j)*((_-$)*n-aa*j)+((l*(_-$)-Z*j)*(l*(_-$)-Z*j)+(m*(_-$)-k*j)*(m*(_-$)-k*j))));l=1.0/p*(l*(_-$)-Z*j);k=1.0/p*(m*(_-$)-k*j);j=1.0/p*((_-$)*n-aa*j);h=c[b+28>>2]|0;if(c[d+240>>2]|0){aa=l*+g[h+296>>2]+k*+g[h+300>>2]+j*+g[h+304>>2];$=l*+g[h+280>>2]+k*+g[h+284>>2]+j*+g[h+288>>2];_=l*+g[h+264>>2]+k*+g[h+268>>2]+j*+g[h+272>>2];Y=p*0.0*+g[d+116>>2];Z=p*0.0*+g[d+120>>2];g[d+64>>2]=p*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=Y+ +g[d+68>>2];g[d+72>>2]=Z+ +g[d+72>>2];$=$*p*+g[d+100>>2];aa=aa*p*+g[d+104>>2];g[I>>2]=_*p*+g[d+96>>2]+ +g[I>>2];g[J>>2]=$+ +g[J>>2];g[K>>2]=aa+ +g[K>>2]}h=c[b+32>>2]|0;if(c[e+240>>2]|0){aa=l*+g[h+296>>2]+k*+g[h+300>>2]+j*+g[h+304>>2];$=l*+g[h+280>>2]+k*+g[h+284>>2]+j*+g[h+288>>2];_=l*+g[h+264>>2]+k*+g[h+268>>2]+j*+g[h+272>>2];Y=p*-0.0*+g[e+116>>2];Z=p*-0.0*+g[e+120>>2];g[e+64>>2]=p*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=Y+ +g[e+68>>2];g[e+72>>2]=Z+ +g[e+72>>2];$=$*+g[e+100>>2]*-p;aa=aa*+g[e+104>>2]*-p;g[L>>2]=_*+g[e+96>>2]*-p+ +g[L>>2];g[M>>2]=$+ +g[M>>2];g[N>>2]=aa+ +g[N>>2]}}if(!(a[b+525>>0]|0)){i=P;return}n=+g[b+532>>2];m=n*+g[b+508>>2]*+g[b+432>>2]/f;l=+g[b+476>>2];k=+g[b+480>>2];j=+g[b+484>>2];if((w-z)*l+(u-y)*k+(q-x)*j>0.0)m=m+n*((w-z)*l+(u-y)*k+(q-x)*j)*+g[b+436>>2];n=+g[b+520>>2];m=n+m*+g[b+496>>2];m=m>0.0?m:0.0;g[b+520>>2]=m;h=c[b+28>>2]|0;if(c[d+240>>2]|0){aa=l*+g[h+296>>2]+k*+g[h+300>>2]+j*+g[h+304>>2];$=l*+g[h+280>>2]+k*+g[h+284>>2]+j*+g[h+288>>2];j=l*+g[h+264>>2]+k*+g[h+268>>2]+j*+g[h+272>>2];l=(m-n)*0.0*+g[d+116>>2];k=(m-n)*0.0*+g[d+120>>2];g[d+64>>2]=(m-n)*0.0*+g[d+112>>2]+ +g[d+64>>2];g[d+68>>2]=l+ +g[d+68>>2];g[d+72>>2]=k+ +g[d+72>>2];k=$*(m-n)*+g[d+100>>2];l=aa*(m-n)*+g[d+104>>2];g[I>>2]=j*(m-n)*+g[d+96>>2]+ +g[I>>2];g[J>>2]=k+ +g[J>>2];g[K>>2]=l+ +g[K>>2];l=+g[b+476>>2];k=+g[b+480>>2];j=+g[b+484>>2]}h=c[b+32>>2]|0;if(!(c[e+240>>2]|0)){i=P;return}aa=l*+g[h+296>>2]+k*+g[h+300>>2]+j*+g[h+304>>2];$=l*+g[h+280>>2]+k*+g[h+284>>2]+j*+g[h+288>>2];_=l*+g[h+264>>2]+k*+g[h+268>>2]+j*+g[h+272>>2];Y=(m-n)*-0.0*+g[e+116>>2];Z=(m-n)*-0.0*+g[e+120>>2];g[e+64>>2]=(m-n)*-0.0*+g[e+112>>2]+ +g[e+64>>2];g[e+68>>2]=Y+ +g[e+68>>2];g[e+72>>2]=Z+ +g[e+72>>2];$=$*+g[e+100>>2]*-(m-n);aa=aa*+g[e+104>>2]*-(m-n);g[L>>2]=_*+g[e+96>>2]*-(m-n)+ +g[L>>2];g[M>>2]=$+ +g[M>>2];g[N>>2]=aa+ +g[N>>2];i=P;return}function Ac(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0;U=c[e>>2]|0;fa=c[f>>2]|0;if(U|0)g=c[U+12>>2]|0;else g=b;i=c[g+88>>2]|0;j=c[g+92>>2]|0;h=c[g+96>>2]|0;if(!fa)g=d;else g=c[fa+12>>2]|0;s=c[g+88>>2]|0;n=c[g+92>>2]|0;p=c[g+96>>2]|0;$=c[b+88>>2]|0;da=(c[d+88>>2]|0)-$|0;u=c[b+92>>2]|0;ea=(c[d+92>>2]|0)-u|0;b=c[b+96>>2]|0;X=(c[d+96>>2]|0)-b|0;Z=c[(U|0?U:fa)+12>>2]|0;aa=(c[Z+88>>2]|0)-$|0;T=(c[Z+92>>2]|0)-u|0;Z=(c[Z+96>>2]|0)-b|0;Y=(_(T,X)|0)-(_(Z,ea)|0)|0;Z=(_(Z,da)|0)-(_(aa,X)|0)|0;T=(_(aa,ea)|0)-(_(T,da)|0)|0;$=vr(Y|0,((Y|0)<0)<<31>>31|0,$|0,(($|0)<0)<<31>>31|0)|0;aa=C;u=vr(Z|0,((Z|0)<0)<<31>>31|0,u|0,((u|0)<0)<<31>>31|0)|0;t=C;b=vr(T|0,((T|0)<0)<<31>>31|0,b|0,((b|0)<0)<<31>>31|0)|0;b=Kt($|0,aa|0,b|0,C|0)|0;t=Kt(b|0,C|0,u|0,t|0)|0;u=C;b=vr(T|0,((T|0)<0)<<31>>31|0,ea|0,((ea|0)<0)<<31>>31|0)|0;aa=C;$=vr(Z|0,((Z|0)<0)<<31>>31|0,X|0,((X|0)<0)<<31>>31|0)|0;$=Is(b|0,aa|0,$|0,C|0)|0;aa=C;b=vr(Y|0,((Y|0)<0)<<31>>31|0,X|0,((X|0)<0)<<31>>31|0)|0;ca=C;ba=vr(T|0,((T|0)<0)<<31>>31|0,da|0,((da|0)<0)<<31>>31|0)|0;ba=Is(b|0,ca|0,ba|0,C|0)|0;ca=C;b=vr(Z|0,((Z|0)<0)<<31>>31|0,da|0,((da|0)<0)<<31>>31|0)|0;W=C;V=vr(Y|0,((Y|0)<0)<<31>>31|0,ea|0,((ea|0)<0)<<31>>31|0)|0;V=Is(b|0,W|0,V|0,C|0)|0;W=C;b=vr($|0,aa|0,i|0,((i|0)<0)<<31>>31|0)|0;S=C;g=vr(ba|0,ca|0,j|0,((j|0)<0)<<31>>31|0)|0;S=Kt(g|0,C|0,b|0,S|0)|0;b=C;g=vr(V|0,W|0,h|0,((h|0)<0)<<31>>31|0)|0;g=Kt(S|0,b|0,g|0,C|0)|0;b=C;if((U|0)!=0?(c[U+12>>2]|0)!=0:0){r=U;q=i;o=j;m=h;while(1){r=c[(c[r+8>>2]|0)+4>>2]|0;j=r+12|0;i=c[j>>2]|0;d=c[i+88>>2]|0;R=vr(d|0,((d|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;Q=C;h=c[i+92>>2]|0;S=vr(h|0,((h|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;Q=Kt(S|0,C|0,R|0,Q|0)|0;R=C;i=c[i+96>>2]|0;S=vr(i|0,((i|0)<0)<<31>>31|0,T|0,((T|0)<0)<<31>>31|0)|0;S=Kt(Q|0,R|0,S|0,C|0)|0;R=C;if((R|0)<(u|0)|(R|0)==(u|0)&S>>>0<t>>>0){d=q;i=o;h=m;break}if((c[r+20>>2]|0)==(c[a+100>>2]|0)){d=q;i=o;h=m;break}l=vr(d|0,((d|0)<0)<<31>>31|0,$|0,aa|0)|0;S=C;k=vr(h|0,((h|0)<0)<<31>>31|0,ba|0,ca|0)|0;S=Kt(k|0,C|0,l|0,S|0)|0;l=C;k=vr(i|0,((i|0)<0)<<31>>31|0,V|0,W|0)|0;k=Kt(S|0,l|0,k|0,C|0)|0;l=C;if(!((l|0)>(b|0)|(l|0)==(b|0)&k>>>0>g>>>0)){d=q;i=o;h=m;break}c[e>>2]=r;S=c[j>>2]|0;d=c[S+88>>2]|0;i=c[S+92>>2]|0;h=c[S+96>>2]|0;if(!S){g=k;b=l;break}else{b=l;g=k;q=d;o=i;m=h}}o=c[f>>2]|0;S=i}else{o=fa;d=i;S=j}j=vr($|0,aa|0,s|0,((s|0)<0)<<31>>31|0)|0;R=C;i=vr(ba|0,ca|0,n|0,((n|0)<0)<<31>>31|0)|0;R=Kt(i|0,C|0,j|0,R|0)|0;j=C;i=vr(V|0,W|0,p|0,((p|0)<0)<<31>>31|0)|0;i=Kt(R|0,j|0,i|0,C|0)|0;j=C;a:do if(o)if(!(c[o+12>>2]|0))k=s;else{r=o;q=s;while(1){o=c[c[r+8>>2]>>2]|0;m=c[o+12>>2]|0;k=c[m+88>>2]|0;Q=vr(k|0,((k|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;P=C;l=c[m+92>>2]|0;R=vr(l|0,((l|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;P=Kt(R|0,C|0,Q|0,P|0)|0;Q=C;m=c[m+96>>2]|0;R=vr(m|0,((m|0)<0)<<31>>31|0,T|0,((T|0)<0)<<31>>31|0)|0;R=Kt(P|0,Q|0,R|0,C|0)|0;Q=C;if((Q|0)<(u|0)|(Q|0)==(u|0)&R>>>0<t>>>0){o=r;k=q;break a}if((c[o+20>>2]|0)==(c[a+100>>2]|0)){o=r;k=q;break a}R=vr(k|0,((k|0)<0)<<31>>31|0,$|0,aa|0)|0;Q=C;l=vr(l|0,((l|0)<0)<<31>>31|0,ba|0,ca|0)|0;Q=Kt(l|0,C|0,R|0,Q|0)|0;R=C;l=vr(m|0,((m|0)<0)<<31>>31|0,V|0,W|0)|0;l=Kt(Q|0,R|0,l|0,C|0)|0;m=C;if(!((m|0)>(j|0)|(m|0)==(j|0)&l>>>0>i>>>0)){o=r;k=q;break a}c[f>>2]=o;R=c[o+12>>2]|0;k=c[R+88>>2]|0;n=c[R+92>>2]|0;p=c[R+96>>2]|0;if(!R){i=l;j=m;break}else{r=o;j=m;i=l;q=k}}}else{o=0;k=s}while(0);i=Is(i|0,j|0,g|0,b|0)|0;b=C;if((b|0)>0|(b|0)==0&i>>>0>0){Q=Is(0,0,T|0,((T|0)<0)<<31>>31|0)|0;R=C;j=o;q=i;m=b;r=d;s=S;t=h;N=k;O=n;P=p;while(1){l=(_(O-s|0,ea)|0)+(_(N-r|0,da)|0)+(_(P-t|0,X)|0)|0;g=c[e>>2]|0;if(!g){E=l;D=l;B=((l|0)<0)<<31>>31;l=q;I=r;H=s;G=t}else{K=l;u=l;L=((l|0)<0)<<31>>31;l=q;H=r;I=s;J=t;b:while(1){if(!(c[g+12>>2]|0)){s=K;t=L;r=H;q=I;g=J;break}G=c[(c[g>>2]|0)+8>>2]|0;if((c[G+20>>2]|0)<=(c[a+100>>2]|0)){s=K;t=L;r=H;q=I;g=J;break}M=c[G+12>>2]|0;r=c[M+88>>2]|0;F=r-H|0;q=c[M+92>>2]|0;E=q-I|0;M=c[M+96>>2]|0;j=M-J|0;t=vr(F|0,((F|0)<0)<<31>>31|0,$|0,aa|0)|0;D=C;s=vr(E|0,((E|0)<0)<<31>>31|0,ba|0,ca|0)|0;D=Kt(s|0,C|0,t|0,D|0)|0;t=C;s=vr(j|0,((j|0)<0)<<31>>31|0,V|0,W|0)|0;s=Kt(D|0,t|0,s|0,C|0)|0;t=C;j=(_(E,ea)|0)+(_(F,da)|0)+(_(j,X)|0)|0;do if((s|0)==0&(t|0)==0){if((j|0)>=0){s=K;t=L;r=H;q=I;g=J;break b}}else{if((t|0)>=0){s=K;t=L;r=H;q=I;g=J;break b}if((j|0)>0){w=1;x=j;v=((j|0)<0)<<31>>31}else{x=Is(0,0,j|0,((j|0)<0)<<31>>31|0)|0;w=j>>31;x=(j|0)<0?x:0;v=(j|0)<0?C:0}F=0-w|0;A=Is(0,0,s|0,t|0)|0;B=C;if((K|0)>0){j=1;D=u;E=L}else{E=(K|0)<0;D=Is(0,0,u|0,L|0)|0;j=K>>31;D=E?D:0;E=E?C:0}if(!((m|0)>0|(m|0)==0&l>>>0>0))if((m|0)<0){s=Is(0,0,l|0,m|0)|0;j=0-j|0;t=C}else{s=0;t=0}else{s=l;t=m}if((j|0)==(F|0)){if(!w)break;j=vr(s|0,0,x|0,0)|0;w=C;ja=vr(t|0,0,x|0,0)|0;ia=C;y=vr(s|0,0,v|0,0)|0;z=C;ha=vr(t|0,0,v|0,0)|0;x=C;y=Kt(ja|0,0,y|0,0)|0;s=C;x=Kt(ia|0,0,ha|0,x|0)|0;z=Kt(x|0,C|0,z|0,0)|0;s=Kt(z|0,C|0,s|0,0)|0;z=C;w=Kt(0,y|0,j|0,w|0)|0;x=C;y=Kt(s|0,z|0,(x>>>0<y>>>0|(x|0)==(y|0)&w>>>0<0)&1|0,0)|0;z=C;s=vr(D|0,0,A|0,0)|0;j=C;ha=vr(E|0,0,A|0,0)|0;A=C;t=vr(D|0,0,B|0,0)|0;v=C;B=vr(E|0,0,B|0,0)|0;D=C;t=Kt(ha|0,0,t|0,0)|0;E=C;D=Kt(A|0,0,B|0,D|0)|0;v=Kt(D|0,C|0,v|0,0)|0;E=Kt(v|0,C|0,E|0,0)|0;v=C;j=Kt(0,t|0,s|0,j|0)|0;s=C;t=Kt(E|0,v|0,(s>>>0<t>>>0|(s|0)==(t|0)&j>>>0<0)&1|0,0)|0;v=C;do if(z>>>0<v>>>0|(z|0)==(v|0)&y>>>0<t>>>0)j=-1;else{if(z>>>0>v>>>0|(z|0)==(v|0)&y>>>0>t>>>0){j=1;break}if(x>>>0<s>>>0|(x|0)==(s|0)&w>>>0<j>>>0){j=-1;break}j=(x>>>0>s>>>0|(x|0)==(s|0)&w>>>0>j>>>0)&1}while(0);j=_(j,F)|0}else j=F-j|0;if((j|0)<=-1){s=K;t=L;r=H;q=I;g=J;break b}}while(0);ja=N-r|0;ia=O-q|0;j=P-M|0;m=vr(ja|0,((ja|0)<0)<<31>>31|0,$|0,aa|0)|0;ha=C;l=vr(ia|0,((ia|0)<0)<<31>>31|0,ba|0,ca|0)|0;ha=Kt(l|0,C|0,m|0,ha|0)|0;m=C;l=vr(j|0,((j|0)<0)<<31>>31|0,V|0,W|0)|0;l=Kt(ha|0,m|0,l|0,C|0)|0;m=C;g=(g|0)==(U|0)?0:G;c[e>>2]=g;j=(_(ia,ea)|0)+(_(ja,da)|0)+(_(j,X)|0)|0;if(!g){s=j;u=j;t=((j|0)<0)<<31>>31;g=M;break}else{K=j;u=j;L=((j|0)<0)<<31>>31;H=r;I=q;J=M}}E=s;j=c[f>>2]|0;D=u;B=t;I=r;H=q;G=g}if(!j){g=122;break}if(!(c[j+12>>2]|0)){g=122;break}F=c[c[j+8>>2]>>2]|0;if((c[F+20>>2]|0)<=(c[a+100>>2]|0)){g=122;break}r=c[F+12>>2]|0;t=c[r+88>>2]|0;q=t-N|0;s=c[r+92>>2]|0;j=s-O|0;r=c[r+96>>2]|0;g=r-P|0;ja=vr(q|0,((q|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;ha=C;ia=vr(j|0,((j|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;ha=Kt(ia|0,C|0,ja|0,ha|0)|0;ja=C;ia=vr(g|0,((g|0)<0)<<31>>31|0,Q|0,R|0)|0;if(!((ha|0)==(ia|0)&(ja|0)==(C|0))){g=122;break}v=vr(q|0,((q|0)<0)<<31>>31|0,$|0,aa|0)|0;A=C;u=vr(j|0,((j|0)<0)<<31>>31|0,ba|0,ca|0)|0;A=Kt(u|0,C|0,v|0,A|0)|0;v=C;u=vr(g|0,((g|0)<0)<<31>>31|0,V|0,W|0)|0;u=Kt(A|0,v|0,u|0,C|0)|0;v=C;g=(_(j,ea)|0)+(_(q,da)|0)+(_(g,X)|0)|0;A=t-I|0;ia=s-H|0;z=r-G|0;A=vr(A|0,((A|0)<0)<<31>>31|0,$|0,aa|0)|0;ja=C;ia=vr(ia|0,((ia|0)<0)<<31>>31|0,ba|0,ca|0)|0;ja=Kt(ia|0,C|0,A|0,ja|0)|0;A=C;z=vr(z|0,((z|0)<0)<<31>>31|0,V|0,W|0)|0;z=Kt(ja|0,A|0,z|0,C|0)|0;A=C;if(!((A|0)>0|(A|0)==0&z>>>0>0)){g=122;break}if((u|0)==0&(v|0)==0){if((g|0)>=0){g=122;break}}else{if((v|0)>=0){g=122;break}if((g|0)>0){r=1;s=g;q=((g|0)<0)<<31>>31}else{s=Is(0,0,g|0,((g|0)<0)<<31>>31|0)|0;r=g>>31;s=(g|0)<0?s:0;q=(g|0)<0?C:0}y=0-r|0;w=Is(0,0,u|0,v|0)|0;x=C;if((E|0)>0){g=1;v=D;u=B}else{u=(E|0)<0;v=Is(0,0,D|0,B|0)|0;g=E>>31;v=u?v:0;u=u?C:0}do if((m|0)>0|(m|0)==0&l>>>0>0){j=g;g=m}else{if((m|0)>=0){j=g;l=0;g=0;break}l=Is(0,0,l|0,m|0)|0;j=0-g|0;g=C}while(0);if((j|0)==(y|0)){if(!r){g=122;break}ja=vr(l|0,0,s|0,0)|0;r=C;j=vr(g|0,0,s|0,0)|0;P=C;s=vr(l|0,0,q|0,0)|0;t=C;g=vr(g|0,0,q|0,0)|0;q=C;s=Kt(j|0,0,s|0,0)|0;j=C;q=Kt(P|0,0,g|0,q|0)|0;t=Kt(q|0,C|0,t|0,0)|0;j=Kt(t|0,C|0,j|0,0)|0;t=C;q=Kt(0,s|0,ja|0,r|0)|0;r=C;s=Kt(j|0,t|0,(r>>>0<s>>>0|(r|0)==(s|0)&q>>>0<0)&1|0,0)|0;t=C;j=vr(v|0,0,w|0,0)|0;g=C;ja=vr(u|0,0,w|0,0)|0;P=C;l=vr(v|0,0,x|0,0)|0;m=C;ha=vr(u|0,0,x|0,0)|0;ia=C;l=Kt(ja|0,0,l|0,0)|0;ja=C;ia=Kt(P|0,0,ha|0,ia|0)|0;m=Kt(ia|0,C|0,m|0,0)|0;ja=Kt(m|0,C|0,ja|0,0)|0;m=C;g=Kt(0,l|0,j|0,g|0)|0;j=C;l=Kt(ja|0,m|0,(j>>>0<l>>>0|(j|0)==(l|0)&g>>>0<0)&1|0,0)|0;m=C;do if(t>>>0<m>>>0|(t|0)==(m|0)&s>>>0<l>>>0)g=-1;else{if(t>>>0>m>>>0|(t|0)==(m|0)&s>>>0>l>>>0){g=1;break}if(r>>>0<j>>>0|(r|0)==(j|0)&q>>>0<g>>>0){g=-1;break}g=(r>>>0>j>>>0|(r|0)==(j|0)&q>>>0>g>>>0)&1}while(0);g=_(g,y)|0}else g=y-j|0;if((g|0)<=0){g=122;break}}c[f>>2]=F;P=c[F+12>>2]|0;j=F;q=z;m=A;r=I;s=H;t=G;N=c[P+88>>2]|0;O=c[P+92>>2]|0;P=c[P+96>>2]|0}if((g|0)==122)return}if((b|0)>=0)return;F=Is(0,0,T|0,((T|0)<0)<<31>>31|0)|0;G=C;g=S;E=k;c:while(1){D=b;B=i;z=g;d:while(1){A=(_(n-z|0,ea)|0)+(_(E-d|0,da)|0)+(_(p-h|0,X)|0)|0;do if((o|0?c[o+12>>2]|0:0)?(ga=c[(c[o+4>>2]|0)+8>>2]|0,(c[ga+20>>2]|0)>(c[a+100>>2]|0)):0){y=c[ga+12>>2]|0;w=c[y+88>>2]|0;ja=w-E|0;x=c[y+92>>2]|0;ia=x-n|0;y=c[y+96>>2]|0;g=y-p|0;i=vr(ja|0,((ja|0)<0)<<31>>31|0,$|0,aa|0)|0;ha=C;b=vr(ia|0,((ia|0)<0)<<31>>31|0,ba|0,ca|0)|0;ha=Kt(b|0,C|0,i|0,ha|0)|0;i=C;b=vr(g|0,((g|0)<0)<<31>>31|0,V|0,W|0)|0;b=Kt(ha|0,i|0,b|0,C|0)|0;i=C;g=(_(ia,ea)|0)+(_(ja,da)|0)+(_(g,X)|0)|0;if((b|0)==0&(i|0)==0)if((g|0)>0)break d;else break;if((i|0)<0){if((g|0)>0){k=1;l=g;j=((g|0)<0)<<31>>31}else{l=Is(0,0,g|0,((g|0)<0)<<31>>31|0)|0;k=g>>31;l=(g|0)<0?l:0;j=(g|0)<0?C:0}v=0-k|0;r=Is(0,0,b|0,i|0)|0;s=C;if((A|0)>0){g=1;t=A;u=((A|0)<0)<<31>>31}else{t=Is(0,0,A|0,((A|0)<0)<<31>>31|0)|0;g=A>>31;t=(A|0)<0?t:0;u=(A|0)<0?C:0}if(!((D|0)>0|(D|0)==0&B>>>0>0))if((D|0)<0){b=Is(0,0,B|0,D|0)|0;g=0-g|0;i=C}else{b=0;i=0}else{b=B;i=D}if((g|0)==(v|0)){if(!k)break d;g=vr(b|0,0,l|0,0)|0;k=C;ha=vr(i|0,0,l|0,0)|0;U=C;m=vr(b|0,0,j|0,0)|0;q=C;ja=vr(i|0,0,j|0,0)|0;l=C;m=Kt(ha|0,0,m|0,0)|0;b=C;l=Kt(U|0,0,ja|0,l|0)|0;q=Kt(l|0,C|0,q|0,0)|0;b=Kt(q|0,C|0,b|0,0)|0;q=C;k=Kt(0,m|0,g|0,k|0)|0;l=C;m=Kt(b|0,q|0,(l>>>0<m>>>0|(l|0)==(m|0)&k>>>0<0)&1|0,0)|0;q=C;b=vr(t|0,0,r|0,0)|0;g=C;ja=vr(u|0,0,r|0,0)|0;U=C;i=vr(t|0,0,s|0,0)|0;j=C;ha=vr(u|0,0,s|0,0)|0;ia=C;i=Kt(ja|0,0,i|0,0)|0;ja=C;ia=Kt(U|0,0,ha|0,ia|0)|0;j=Kt(ia|0,C|0,j|0,0)|0;ja=Kt(j|0,C|0,ja|0,0)|0;j=C;g=Kt(0,i|0,b|0,g|0)|0;b=C;i=Kt(ja|0,j|0,(b>>>0<i>>>0|(b|0)==(i|0)&g>>>0<0)&1|0,0)|0;j=C;do if(q>>>0<j>>>0|(q|0)==(j|0)&m>>>0<i>>>0)g=-1;else{if(q>>>0>j>>>0|(q|0)==(j|0)&m>>>0>i>>>0){g=1;break}if(l>>>0<b>>>0|(l|0)==(b|0)&k>>>0<g>>>0){g=-1;break}g=(l>>>0>b>>>0|(l|0)==(b|0)&k>>>0>g>>>0)&1}while(0);g=_(g,v)|0}else g=v-g|0;if((g|0)<1)break d}}while(0);g=c[e>>2]|0;if(!g){g=122;break c}if(!(c[g+12>>2]|0)){g=122;break c}u=c[(c[g+8>>2]|0)+4>>2]|0;if((c[u+20>>2]|0)<=(c[a+100>>2]|0)){g=122;break c}i=c[u+12>>2]|0;k=c[i+88>>2]|0;d=k-d|0;j=c[i+92>>2]|0;b=j-z|0;i=c[i+96>>2]|0;g=i-h|0;ja=vr(d|0,((d|0)<0)<<31>>31|0,Y|0,((Y|0)<0)<<31>>31|0)|0;ha=C;ia=vr(b|0,((b|0)<0)<<31>>31|0,Z|0,((Z|0)<0)<<31>>31|0)|0;ha=Kt(ia|0,C|0,ja|0,ha|0)|0;ja=C;ia=vr(g|0,((g|0)<0)<<31>>31|0,F|0,G|0)|0;if(!((ha|0)==(ia|0)&(ja|0)==(C|0))){g=122;break c}l=vr(d|0,((d|0)<0)<<31>>31|0,$|0,aa|0)|0;t=C;h=vr(b|0,((b|0)<0)<<31>>31|0,ba|0,ca|0)|0;t=Kt(h|0,C|0,l|0,t|0)|0;l=C;h=vr(g|0,((g|0)<0)<<31>>31|0,V|0,W|0)|0;h=Kt(t|0,l|0,h|0,C|0)|0;l=C;g=(_(b,ea)|0)+(_(d,da)|0)+(_(g,X)|0)|0;t=E-k|0;ia=n-j|0;s=p-i|0;t=vr(t|0,((t|0)<0)<<31>>31|0,$|0,aa|0)|0;ja=C;ia=vr(ia|0,((ia|0)<0)<<31>>31|0,ba|0,ca|0)|0;ja=Kt(ia|0,C|0,t|0,ja|0)|0;t=C;s=vr(s|0,((s|0)<0)<<31>>31|0,V|0,W|0)|0;s=Kt(ja|0,t|0,s|0,C|0)|0;t=C;if((t|0)>=0){g=122;break c}if((h|0)==0&(l|0)==0){if((g|0)<=0){g=122;break c}}else{if((l|0)>=0){g=122;break c}if((g|0)>0){j=g;k=((g|0)<0)<<31>>31;i=1}else{j=Is(0,0,g|0,((g|0)<0)<<31>>31|0)|0;j=(g|0)<0?j:0;k=(g|0)<0?C:0;i=g>>31}r=0-i|0;o=Is(0,0,h|0,l|0)|0;q=C;if((A|0)>0){g=1;m=A;h=((A|0)<0)<<31>>31}else{m=Is(0,0,A|0,((A|0)<0)<<31>>31|0)|0;g=A>>31;m=(A|0)<0?m:0;h=(A|0)<0?C:0}do if((D|0)>0|(D|0)==0&B>>>0>0){d=g;b=B;g=D}else{if((D|0)>=0){d=g;b=0;g=0;break}b=Is(0,0,B|0,D|0)|0;d=0-g|0;g=C}while(0);if((d|0)==(r|0)){if(!i){g=122;break c}ja=vr(b|0,0,j|0,0)|0;i=C;d=vr(g|0,0,j|0,0)|0;U=C;b=vr(b|0,0,k|0,0)|0;l=C;g=vr(g|0,0,k|0,0)|0;j=C;k=Kt(d|0,0,b|0,0)|0;b=C;j=Kt(U|0,0,g|0,j|0)|0;l=Kt(j|0,C|0,l|0,0)|0;b=Kt(l|0,C|0,b|0,0)|0;l=C;i=Kt(0,k|0,ja|0,i|0)|0;j=C;k=Kt(b|0,l|0,(j>>>0<k>>>0|(j|0)==(k|0)&i>>>0<0)&1|0,0)|0;l=C;b=vr(m|0,0,o|0,0)|0;g=C;ja=vr(h|0,0,o|0,0)|0;U=C;d=vr(m|0,0,q|0,0)|0;ia=C;ha=vr(h|0,0,q|0,0)|0;h=C;d=Kt(ja|0,0,d|0,0)|0;ja=C;h=Kt(U|0,0,ha|0,h|0)|0;h=Kt(h|0,C|0,ia|0,0)|0;ja=Kt(h|0,C|0,ja|0,0)|0;h=C;g=Kt(0,d|0,b|0,g|0)|0;b=C;d=Kt(ja|0,h|0,(b>>>0<d>>>0|(b|0)==(d|0)&g>>>0<0)&1|0,0)|0;h=C;do if(l>>>0<h>>>0|(l|0)==(h|0)&k>>>0<d>>>0)g=-1;else{if(l>>>0>h>>>0|(l|0)==(h|0)&k>>>0>d>>>0){g=1;break}if(j>>>0<b>>>0|(j|0)==(b|0)&i>>>0<g>>>0){g=-1;break}g=(j>>>0>b>>>0|(j|0)==(b|0)&i>>>0>g>>>0)&1}while(0);g=_(g,r)|0}else g=r-d|0;if((g|0)>=0){g=122;break c}}c[e>>2]=u;h=c[u+12>>2]|0;o=c[f>>2]|0;D=t;B=s;d=c[h+88>>2]|0;z=c[h+92>>2]|0;h=c[h+96>>2]|0}b=w-d|0;E=x-z|0;i=y-h|0;b=vr(b|0,((b|0)<0)<<31>>31|0,$|0,aa|0)|0;g=C;E=vr(E|0,((E|0)<0)<<31>>31|0,ba|0,ca|0)|0;g=Kt(E|0,C|0,b|0,g|0)|0;b=C;i=vr(i|0,((i|0)<0)<<31>>31|0,V|0,W|0)|0;i=Kt(g|0,b|0,i|0,C|0)|0;o=(o|0)==(fa|0)?0:ga;c[f>>2]=o;b=C;g=z;E=w;n=x;p=y}if((g|0)==122)return}function Bc(e,f,g,j,l){e=e|0;f=f|0;g=g|0;j=j|0;l=l|0;var m=0,n=0,o=0,p=0.0,q=0,r=0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;O=i;i=i+624|0;K=O+536+40|0;M=O+588|0;N=O+576+12|0;L=O+588+9|0;m=0;n=0;r=0;w=f;a:while(1){do if((m|0)>-1){if((n|0)<=(2147483647-m|0)){m=n+m|0;break}if(!0)m=25748;else m=c[(ib()|0)+64>>2]|0;c[m>>2]=75;m=-1}while(0);f=a[w>>0]|0;if(!(f<<24>>24)){J=254;break}else n=w;b:while(1){switch(f<<24>>24){case 37:{f=n;J=11;break b}case 0:{f=n;break b}default:{}}I=n+1|0;f=a[I>>0]|0;n=I}c:do if((J|0)==11)while(1){J=0;if((a[f+1>>0]|0)!=37)break c;n=n+1|0;f=f+2|0;if((a[f>>0]|0)==37)J=11;else break}while(0);v=n-w|0;if(e|0?(c[e>>2]&32|0)==0:0)Ek(w,v,e);if((n|0)!=(w|0)){n=v;w=f;continue}o=f+1|0;n=a[o>>0]|0;if(((n<<24>>24)+-48|0)>>>0<10){I=(a[f+2>>0]|0)==36;o=I?f+3|0:o;q=a[o>>0]|0;u=I?(n<<24>>24)+-48|0:-1;r=I?1:r}else{q=n;u=-1}f=q<<24>>24;d:do if((f&-32|0)==32){n=q;q=0;do{if(!(1<<f+-32&75913))break d;q=1<<(n<<24>>24)+-32|q;o=o+1|0;n=a[o>>0]|0;f=n<<24>>24}while((f&-32|0)==32)}else{n=q;q=0}while(0);do if(n<<24>>24==42){n=o+1|0;f=(a[n>>0]|0)+-48|0;if(f>>>0<10?(a[o+2>>0]|0)==36:0){c[l+(f<<2)>>2]=10;f=1;o=o+3|0;n=c[j+((a[n>>0]|0)+-48<<3)>>2]|0}else{if(r|0){m=-1;break a}if(!e){t=q;I=0;o=n;H=0;break}f=(c[g>>2]|0)+(4-1)&~(4-1);I=c[f>>2]|0;c[g>>2]=f+4;f=0;o=n;n=I}if((n|0)<0){t=q|8192;I=f;H=0-n|0}else{t=q;I=f;H=n}}else{f=(n<<24>>24)+-48|0;if(f>>>0<10){n=0;do{n=(n*10|0)+f|0;o=o+1|0;f=(a[o>>0]|0)+-48|0}while(f>>>0<10);if((n|0)<0){m=-1;break a}else{t=q;I=r;H=n}}else{t=q;I=r;H=0}}while(0);e:do if((a[o>>0]|0)==46){f=o+1|0;q=a[f>>0]|0;if(q<<24>>24!=42){if(((q<<24>>24)+-48|0)>>>0<10){n=0;o=(q<<24>>24)+-48|0}else{r=0;break}while(1){n=(n*10|0)+o|0;f=f+1|0;o=(a[f>>0]|0)+-48|0;if(o>>>0>=10){r=n;break e}}}f=o+2|0;n=(a[f>>0]|0)+-48|0;if(n>>>0<10?(a[o+3>>0]|0)==36:0){c[l+(n<<2)>>2]=10;r=c[j+((a[f>>0]|0)+-48<<3)>>2]|0;f=o+4|0;break}if(I|0){m=-1;break a}if(e|0){G=(c[g>>2]|0)+(4-1)&~(4-1);r=c[G>>2]|0;c[g>>2]=G+4}else r=0}else{r=-1;f=o}while(0);q=0;while(1){n=(a[f>>0]|0)+-65|0;if(n>>>0>57){m=-1;break a}G=f+1|0;n=a[19395+(q*58|0)+n>>0]|0;if(((n&255)+-1|0)>>>0<8){f=G;q=n&255}else break}if(!(n<<24>>24)){m=-1;break}o=(u|0)>-1;do if(n<<24>>24==19)if(o){m=-1;break a}else J=54;else{if(o){c[l+(u<<2)>>2]=n&255;F=j+(u<<3)|0;J=c[F+4>>2]|0;c[O>>2]=c[F>>2];c[O+4>>2]=J;J=54;break}if(!e){m=0;break a}Ug(O,n&255,g)}while(0);if((J|0)==54?(J=0,(e|0)==0):0){n=v;r=I;w=G;continue}E=a[f>>0]|0;E=(q|0)!=0&(E&15|0)==3?E&-33:E;o=t&-65537;F=(t&8192|0)==0?t:o;f:do switch(E|0){case 110:switch(q|0){case 0:{c[c[O>>2]>>2]=m;n=v;r=I;w=G;continue a}case 1:{c[c[O>>2]>>2]=m;n=v;r=I;w=G;continue a}case 2:{n=c[O>>2]|0;c[n>>2]=m;c[n+4>>2]=((m|0)<0)<<31>>31;n=v;r=I;w=G;continue a}case 3:{b[c[O>>2]>>1]=m;n=v;r=I;w=G;continue a}case 4:{a[c[O>>2]>>0]=m;n=v;r=I;w=G;continue a}case 6:{c[c[O>>2]>>2]=m;n=v;r=I;w=G;continue a}case 7:{n=c[O>>2]|0;c[n>>2]=m;c[n+4>>2]=((m|0)<0)<<31>>31;n=v;r=I;w=G;continue a}default:{n=v;r=I;w=G;continue a}}case 112:{t=F|8;r=r>>>0>8?r:8;u=120;J=66;break}case 88:case 120:{t=F;u=E;J=66;break}case 111:{n=c[O>>2]|0;o=c[O+4>>2]|0;if((n|0)==0&(o|0)==0)f=K;else{f=K;do{f=f+-1|0;a[f>>0]=n&7|48;n=us(n|0,o|0,3)|0;o=C}while(!((n|0)==0&(o|0)==0))}if(!(F&8)){n=F;t=0;q=19875;J=79}else{t=K-f|0;n=F;r=(r|0)>(t|0)?r:t+1|0;t=0;q=19875;J=79}break}case 105:case 100:{f=c[O>>2]|0;n=c[O+4>>2]|0;if((n|0)<0){f=Is(0,0,f|0,n|0)|0;n=C;c[O>>2]=f;c[O+4>>2]=n;o=1;q=19875;J=78;break f}if(!(F&2048)){o=F&1;q=(F&1|0)==0?19875:19877;J=78}else{o=1;q=19876;J=78}break}case 117:{f=c[O>>2]|0;n=c[O+4>>2]|0;o=0;q=19875;J=78;break}case 99:{a[O+536+39>>0]=c[O>>2];f=O+536+39|0;u=1;w=0;v=19875;n=K;break}case 109:{if(!0)f=25748;else f=c[(ib()|0)+64>>2]|0;n=c[f>>2]|0;f=0;while(1){if((d[19885+f>>0]|0)==(n|0)){J=85;break}f=f+1|0;if((f|0)==87){n=87;f=19973;break}}if((J|0)==85)if(!f){n=19973;J=92;break f}else{n=f;f=19973}do{do{J=f;f=f+1|0}while((a[J>>0]|0)!=0);n=n+-1|0}while((n|0)!=0);n=f;J=92;break}case 115:{n=c[O>>2]|0;n=n|0?n:21777;J=92;break}case 67:{c[O+8>>2]=c[O>>2];c[O+8+4>>2]=0;c[O>>2]=O+8;f=O+8|0;r=-1;J=96;break}case 83:{f=c[O>>2]|0;if(!r){Gl(e,32,H,0,F);f=0;J=107}else J=96;break}case 65:case 71:case 70:case 69:case 97:case 103:case 102:case 101:{p=+h[O>>3];c[O+16>>2]=0;h[k>>3]=p;if((c[k+4>>2]|0)>=0)if(!(F&2048)){B=F&1;D=(F&1|0)==0?21785:21790}else{B=1;D=21787}else{p=-p;B=1;D=21784}h[k>>3]=p;A=c[k+4>>2]&2146435072;do if(A>>>0<2146435072|(A|0)==2146435072&0<0){p=+Gm(p,O+16|0)*2.0;if(p!=0.0)c[O+16>>2]=(c[O+16>>2]|0)+-1;if((E|32|0)==97){u=(E&32|0)==0?D:D+9|0;t=B|2;f=12-r|0;do if(!(r>>>0>11|(f|0)==0)){s=8.0;do{f=f+-1|0;s=s*16.0}while((f|0)!=0);if((a[u>>0]|0)==45){p=-(s+(-p-s));break}else{p=p+s-s;break}}while(0);n=c[O+16>>2]|0;f=(n|0)<0?0-n|0:n;f=Vm(f,((f|0)<0)<<31>>31,O+576+12|0)|0;if((f|0)==(O+576+12|0)){a[O+576+11>>0]=48;f=O+576+11|0}a[f+-1>>0]=(n>>31&2)+43;q=f+-2|0;a[q>>0]=E+15;o=(r|0)<1;f=O+588|0;while(1){D=~~p;n=f+1|0;a[f>>0]=d[19859+D>>0]|E&32;p=(p-+(D|0))*16.0;do if((n-M|0)==1){if((F&8|0)==0&(o&p==0.0))break;a[n>>0]=46;n=f+2|0}while(0);if(!(p!=0.0))break;else f=n}f=(r|0)!=0&(-2-M+n|0)<(r|0)?N+2+r-q|0:N-M-q+n|0;Gl(e,32,H,f+t|0,F);if(!(c[e>>2]&32))Ek(u,t,e);Gl(e,48,H,f+t|0,F^65536);if(!(c[e>>2]&32))Ek(O+588|0,n-M|0,e);Gl(e,48,f-(n-M+(N-q))|0,0,0);if(!(c[e>>2]&32))Ek(q,N-q|0,e);Gl(e,32,H,f+t|0,F^8192);f=(f+t|0)<(H|0)?H:f+t|0;break}f=(r|0)<0?6:r;if(p!=0.0){n=(c[O+16>>2]|0)+-28|0;c[O+16>>2]=n;p=p*268435456.0}else n=c[O+16>>2]|0;A=(n|0)<0?O+24|0:O+24+288|0;q=A;do{z=~~p>>>0;c[q>>2]=z;q=q+4|0;p=(p-+(z>>>0))*1.0e9}while(p!=0.0);n=c[O+16>>2]|0;if((n|0)>0){o=A;do{t=(n|0)>29?29:n;n=q+-4|0;do if(n>>>0>=o>>>0){r=0;do{y=is(c[n>>2]|0,0,t|0)|0;y=Kt(y|0,C|0,r|0,0)|0;z=C;x=lr(y|0,z|0,1e9,0)|0;c[n>>2]=x;r=Xv(y|0,z|0,1e9,0)|0;n=n+-4|0}while(n>>>0>=o>>>0);if(!r)break;o=o+-4|0;c[o>>2]=r}while(0);while(1){if(q>>>0<=o>>>0)break;n=q+-4|0;if(!(c[n>>2]|0))q=n;else break}n=(c[O+16>>2]|0)-t|0;c[O+16>>2]=n}while((n|0)>0)}else o=A;if((n|0)<0){do{t=0-n|0;t=(t|0)>9?9:t;do if(o>>>0<q>>>0){r=0;n=o;do{z=c[n>>2]|0;c[n>>2]=(z>>>t)+r;r=_(z&(1<<t)+-1,1e9>>>t)|0;n=n+4|0}while(n>>>0<q>>>0);n=(c[o>>2]|0)==0?o+4|0:o;if(!r){o=n;n=q;break}c[q>>2]=r;o=n;n=q+4|0}else{o=(c[o>>2]|0)==0?o+4|0:o;n=q}while(0);q=(E|32|0)==102?A:o;q=(n-q>>2|0)>(((f+25|0)/9|0)+1|0)?q+(((f+25|0)/9|0)+1<<2)|0:n;n=(c[O+16>>2]|0)+t|0;c[O+16>>2]=n}while((n|0)<0);n=o}else n=o;do if(n>>>0<q>>>0){o=(A-n>>2)*9|0;t=c[n>>2]|0;if(t>>>0<10)break;else r=10;do{r=r*10|0;o=o+1|0}while(t>>>0>=r>>>0)}else o=0;while(0);r=f-((E|32|0)!=102?o:0)+(((f|0)!=0&(E|32|0)==103)<<31>>31)|0;if((r|0)<(((q-A>>2)*9|0)+-9|0)){x=A+4+(((r+9216|0)/9|0)+-1024<<2)|0;if((((r+9216|0)%9|0)+1|0)<9){t=10;u=((r+9216|0)%9|0)+1|0;while(1){r=t*10|0;u=u+1|0;if((u|0)==9)break;else t=r}}else r=10;v=c[x>>2]|0;w=(v>>>0)%(r>>>0)|0;t=(x+4|0)==(q|0);do if(t&(w|0)==0)r=x;else{s=(((v>>>0)/(r>>>0)|0)&1|0)==0?9007199254740992.0:9007199254740994.0;u=(r|0)/2|0;if(w>>>0<u>>>0)p=.5;else p=t&(w|0)==(u|0)?1.0:1.5;do if(B){if((a[D>>0]|0)!=45)break;s=-s;p=-p}while(0);c[x>>2]=v-w;if(!(s+p!=s)){r=x;break}z=v-w+r|0;c[x>>2]=z;if(z>>>0>999999999){o=x;while(1){r=o+-4|0;c[o>>2]=0;if(r>>>0<n>>>0){n=n+-4|0;c[n>>2]=0}z=(c[r>>2]|0)+1|0;c[r>>2]=z;if(z>>>0>999999999)o=r;else break}}else r=x;o=(A-n>>2)*9|0;u=c[n>>2]|0;if(u>>>0<10)break;else t=10;do{t=t*10|0;o=o+1|0}while(u>>>0>=t>>>0)}while(0);y=r+4|0;z=n;n=q>>>0>y>>>0?y:q}else{z=n;n=q}u=0-o|0;y=n;while(1){if(y>>>0<=z>>>0){w=0;break}n=y+-4|0;if(!(c[n>>2]|0))y=n;else{w=1;break}}do if((E|32|0)==103){if((((f|0)!=0^1)+f|0)>(o|0)&(o|0)>-5){t=E+-1|0;f=((f|0)!=0^1)+f+-1-o|0}else{t=E+-2|0;f=((f|0)!=0^1)+f+-1|0}if(F&8|0){r=F&8;break}do if(w){n=c[y+-4>>2]|0;if(!n){q=9;break}if(!((n>>>0)%10|0)){r=10;q=0}else{q=0;break}do{r=r*10|0;q=q+1|0}while(!((n>>>0)%(r>>>0)|0|0))}else q=9;while(0);n=((y-A>>2)*9|0)+-9|0;if((t|32|0)==102){r=n-q|0;r=(r|0)<0?0:r;f=(f|0)<(r|0)?f:r;r=0;break}else{r=n+o-q|0;r=(r|0)<0?0:r;f=(f|0)<(r|0)?f:r;r=0;break}}else{t=E;r=F&8}while(0);v=f|r;q=(t|32|0)==102;if(q){n=(o|0)>0?o:0;u=0}else{n=(o|0)<0?u:o;n=Vm(n,((n|0)<0)<<31>>31,O+576+12|0)|0;if((N-n|0)<2)do{n=n+-1|0;a[n>>0]=48}while((N-n|0)<2);a[n+-1>>0]=(o>>31&2)+43;u=n+-2|0;a[u>>0]=t;n=N-u|0}x=B+1+f+((v|0)!=0&1)+n|0;Gl(e,32,H,x,F);if(!(c[e>>2]&32))Ek(D,B,e);Gl(e,48,H,x,F^65536);do if(q){q=z>>>0>A>>>0?A:z;o=q;do{n=Vm(c[o>>2]|0,0,L)|0;do if((o|0)==(q|0)){if((n|0)!=(L|0))break;a[O+588+8>>0]=48;n=O+588+8|0}else{if(n>>>0<=(O+588|0)>>>0)break;Qn(O+588|0,48,n-M|0)|0;do n=n+-1|0;while(n>>>0>(O+588|0)>>>0)}while(0);if(!(c[e>>2]&32))Ek(n,L-n|0,e);o=o+4|0}while(o>>>0<=A>>>0);do if(v|0){if(c[e>>2]&32|0)break;Ek(21819,1,e)}while(0);if((f|0)>0&o>>>0<y>>>0)while(1){n=Vm(c[o>>2]|0,0,L)|0;if(n>>>0>(O+588|0)>>>0){Qn(O+588|0,48,n-M|0)|0;do n=n+-1|0;while(n>>>0>(O+588|0)>>>0)}if(!(c[e>>2]&32))Ek(n,(f|0)>9?9:f,e);o=o+4|0;n=f+-9|0;if(!((f|0)>9&o>>>0<y>>>0)){f=n;break}else f=n}Gl(e,48,f+9|0,9,0)}else{t=w?y:z+4|0;if((f|0)>-1){r=(r|0)==0;q=z;do{n=Vm(c[q>>2]|0,0,L)|0;if((n|0)==(L|0)){a[O+588+8>>0]=48;n=O+588+8|0}do if((q|0)==(z|0)){o=n+1|0;if(!(c[e>>2]&32))Ek(n,1,e);if(r&(f|0)<1){n=o;break}if(c[e>>2]&32|0){n=o;break}Ek(21819,1,e);n=o}else{if(n>>>0<=(O+588|0)>>>0)break;Qn(O+588|0,48,n+(0-M)|0)|0;do n=n+-1|0;while(n>>>0>(O+588|0)>>>0)}while(0);o=L-n|0;if(!(c[e>>2]&32))Ek(n,(f|0)>(o|0)?o:f,e);f=f-o|0;q=q+4|0}while(q>>>0<t>>>0&(f|0)>-1)}Gl(e,48,f+18|0,18,0);if(c[e>>2]&32|0)break;Ek(u,N-u|0,e)}while(0);Gl(e,32,H,x,F^8192);f=(x|0)<(H|0)?H:x}else{q=p!=p|0.0!=0.0;n=q?0:B;Gl(e,32,H,n+3|0,o);f=c[e>>2]|0;if(!(f&32)){Ek(D,n,e);f=c[e>>2]|0}if(!(f&32))Ek(q?(E&32|0?21811:21815):E&32|0?21803:21807,3,e);Gl(e,32,H,n+3|0,F^8192);f=(n+3|0)<(H|0)?H:n+3|0}while(0);n=f;r=I;w=G;continue a}default:{f=w;o=F;u=r;w=0;v=19875;n=K}}while(0);g:do if((J|0)==66){n=c[O>>2]|0;o=c[O+4>>2]|0;q=u&32;if(!((n|0)==0&(o|0)==0)){f=K;do{f=f+-1|0;a[f>>0]=d[19859+(n&15)>>0]|q;n=us(n|0,o|0,4)|0;o=C}while(!((n|0)==0&(o|0)==0));if((t&8|0)==0|(c[O>>2]|0)==0&(c[O+4>>2]|0)==0){n=t;t=0;q=19875;J=79}else{n=t;t=2;q=19875+(u>>4)|0;J=79}}else{f=K;n=t;t=0;q=19875;J=79}}else if((J|0)==78){f=Vm(f,n,K)|0;n=F;t=o;J=79}else if((J|0)==92){J=0;F=lj(n,0,r)|0;f=n;u=(F|0)==0?r:F-n|0;w=0;v=19875;n=(F|0)==0?n+r|0:F}else if((J|0)==96){J=0;o=0;n=0;t=f;while(1){q=c[t>>2]|0;if(!q)break;n=wl(O+528|0,q)|0;if((n|0)<0|n>>>0>(r-o|0)>>>0)break;o=n+o|0;if(r>>>0>o>>>0)t=t+4|0;else break}if((n|0)<0){m=-1;break a}Gl(e,32,H,o,F);if(!o){f=0;J=107}else{q=0;while(1){n=c[f>>2]|0;if(!n){f=o;J=107;break g}n=wl(O+528|0,n)|0;q=n+q|0;if((q|0)>(o|0)){f=o;J=107;break g}if(!(c[e>>2]&32))Ek(O+528|0,n,e);if(q>>>0>=o>>>0){f=o;J=107;break}else f=f+4|0}}}while(0);if((J|0)==107){J=0;Gl(e,32,H,f,F^8192);n=(H|0)>(f|0)?H:f;r=I;w=G;continue}if((J|0)==79){J=0;o=(r|0)>-1?n&-65537:n;n=(c[O>>2]|0)!=0|(c[O+4>>2]|0)!=0;if((r|0)!=0|n){u=(n&1^1)+(K-f)|0;u=(r|0)>(u|0)?r:u;w=t;v=q;n=K}else{f=K;u=0;w=t;v=q;n=K}}t=n-f|0;q=(u|0)<(t|0)?t:u;r=w+q|0;n=(H|0)<(r|0)?r:H;Gl(e,32,n,r,o);if(!(c[e>>2]&32))Ek(v,w,e);Gl(e,48,n,r,o^65536);Gl(e,48,q,t,0);if(!(c[e>>2]&32))Ek(f,t,e);Gl(e,32,n,r,o^8192);r=I;w=G}h:do if((J|0)==254)if(!e)if(!r)m=0;else{m=1;while(1){f=c[l+(m<<2)>>2]|0;if(!f){f=0;break}Ug(j+(m<<3)|0,f,g);m=m+1|0;if((m|0)>=10){m=1;break h}}while(1){m=m+1|0;if(f|0){m=-1;break h}if((m|0)>=10){m=1;break h}f=c[l+(m<<2)>>2]|0}}while(0);i=O;return m|0}function Cc(b,d,e,f,h,j,l,m,n){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;l=l|0;m=m|0;n=n|0;var o=0,p=0,q=0,r=0.0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0;Y=i;i=i+304|0;c[b+188>>2]=-1;li(12870);c[b+184>>2]=0;if((e|0)>0){n=0;do{c[(c[d+(n<<2)>>2]|0)+212>>2]=-1;n=n+1|0}while((n|0)!=(e|0))}o=c[b+12>>2]|0;if((o|0)>(e|0))p=b+8|0;else{if((e+1|0)!=0?(c[6435]=(c[6435]|0)+1,p=yc(((e+1|0)*244|3)+16|0)|0,(p|0)!=0):0){c[(p+4+15&-16)+-4>>2]=p;p=p+4+15&-16}else p=0;n=c[b+8>>2]|0;if((n|0)>0){o=0;do{V=p+(o*244|0)|0;W=c[b+16>>2]|0;U=W+(o*244|0)|0;c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];V=p+(o*244|0)+16|0;U=W+(o*244|0)+16|0;c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];V=p+(o*244|0)+32|0;U=W+(o*244|0)+32|0;c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];V=p+(o*244|0)+48|0;U=W+(o*244|0)+48|0;c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];_m(p+(o*244|0)+64|0,W+(o*244|0)+64|0,180)|0;o=o+1|0}while((o|0)!=(n|0))}n=c[b+16>>2]|0;if(n|0){if(a[b+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[n+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=p;c[b+12>>2]=e+1;p=b+8|0;o=e+1|0}Qn(Y|0,0,244)|0;n=c[p>>2]|0;if((n|0)<0){if((o|0)<0){o=c[b+16>>2]|0;if(o|0){if(a[b+20>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[o+-4>>2]|0)}c[b+16>>2]=0}a[b+20>>0]=1;c[b+16>>2]=0;c[b+12>>2]=0}do{W=c[b+16>>2]|0;V=W+(n*244|0)|0;c[V>>2]=c[Y>>2];c[V+4>>2]=c[Y+4>>2];c[V+8>>2]=c[Y+8>>2];c[V+12>>2]=c[Y+12>>2];V=W+(n*244|0)+16|0;c[V>>2]=c[Y+16>>2];c[V+4>>2]=c[Y+16+4>>2];c[V+8>>2]=c[Y+16+8>>2];c[V+12>>2]=c[Y+16+12>>2];V=W+(n*244|0)+32|0;c[V>>2]=c[Y+32>>2];c[V+4>>2]=c[Y+32+4>>2];c[V+8>>2]=c[Y+32+8>>2];c[V+12>>2]=c[Y+32+12>>2];V=W+(n*244|0)+48|0;c[V>>2]=c[Y+48>>2];c[V+4>>2]=c[Y+48+4>>2];c[V+8>>2]=c[Y+48+8>>2];c[V+12>>2]=c[Y+48+12>>2];_m(W+(n*244|0)+64|0,Y+64|0,180)|0;n=n+1|0}while((n|0)!=0)}c[p>>2]=0;if((e|0)>0){p=0;do{o=d+(p<<2)|0;n=bk(b,c[o>>2]|0,+g[m+12>>2])|0;o=c[o>>2]|0;if((!((o|0)==0?1:(c[o+236>>2]&2|0)==0)?+g[o+344>>2]!=0.0:0)?(q=c[b+16>>2]|0,c[o+504>>2]&2|0):0){t=+g[m+76>>2];_=1.0/+g[o+396>>2];u=1.0/+g[o+400>>2];r=1.0/+g[o+404>>2];ea=+g[o+4>>2];da=+g[o+8>>2];ca=+g[o+12>>2];ba=+g[o+20>>2];aa=+g[o+24>>2];$=+g[o+28>>2];Z=+g[o+36>>2];B=+g[o+40>>2];w=+g[o+44>>2];x=+g[o+328>>2];y=+g[o+332>>2];v=+g[o+336>>2];z=(_*ea*ea+u*da*da+r*ca*ca)*x+(_*ea*ba+u*da*aa+r*ca*$)*y+(_*ea*Z+u*da*B+r*ca*w)*v;A=(_*ba*ea+u*aa*da+r*$*ca)*x+(_*ba*ba+u*aa*aa+r*$*$)*y+(_*ba*Z+u*aa*B+r*$*w)*v;w=(_*Z*ea+u*B*da+r*w*ca)*x+(_*Z*ba+u*B*aa+r*w*$)*y+(_*Z*Z+u*B*B+r*w*w)*v;r=(y*w-v*A)*(y*w-v*A)+(v*z-x*w)*(v*z-x*w)+(x*A-y*z)*(x*A-y*z);if(r>t*t){r=1.0/+O(+r)*t;u=(y*w-v*A)*r;t=r*(v*z-x*w);r=r*(x*A-y*z)}else{u=y*w-v*A;t=v*z-x*w;r=x*A-y*z}ca=+g[m+12>>2];da=(u*+g[o+268>>2]+t*+g[o+284>>2]+r*+g[o+300>>2])*ca;ea=ca*(u*+g[o+272>>2]+t*+g[o+288>>2]+r*+g[o+304>>2]);g[q+(n*244|0)+224>>2]=+g[q+(n*244|0)+224>>2]-(u*+g[o+264>>2]+t*+g[o+280>>2]+r*+g[o+296>>2])*ca;g[q+(n*244|0)+228>>2]=+g[q+(n*244|0)+228>>2]-da;g[q+(n*244|0)+232>>2]=+g[q+(n*244|0)+232>>2]-ea}p=p+1|0}while((p|0)!=(e|0))}if((l|0)>0){n=0;do{W=c[j+(n<<2)>>2]|0;Ab[c[(c[W>>2]|0)+8>>2]&255](W);g[W+36>>2]=0.0;n=n+1|0}while((n|0)<(l|0))}o=c[b+168>>2]|0;if((o|0)<(l|0)?(c[b+172>>2]|0)<(l|0):0){if(!l)n=0;else{c[6435]=(c[6435]|0)+1;n=yc((l<<3|3)+16|0)|0;if(!n)n=0;else{c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}o=c[b+168>>2]|0}if((o|0)>0){p=0;do{U=(c[b+176>>2]|0)+(p<<3)|0;V=c[U+4>>2]|0;W=n+(p<<3)|0;c[W>>2]=c[U>>2];c[W+4>>2]=V;p=p+1|0}while((p|0)!=(o|0))}o=c[b+176>>2]|0;if(o|0){if(a[b+180>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[o+-4>>2]|0)}c[b+176>>2]=0}a[b+180>>0]=1;c[b+176>>2]=n;c[b+172>>2]=l}c[b+168>>2]=l;if((l|0)>0){s=0;n=0;do{d=c[b+176>>2]|0;e=d+(s<<3)|0;q=j+(s<<2)|0;o=c[q>>2]|0;p=c[o+44>>2]|0;if(p){o=p+64|0;do{c[p>>2]=0;p=p+4|0}while((p|0)<(o|0));o=c[q>>2]|0}if(!(a[o+20>>0]|0)){c[e>>2]=0;c[d+(s<<3)+4>>2]=0;o=0}else{Cb[c[(c[o>>2]|0)+16>>2]&127](o,e);o=c[e>>2]|0}n=o+n|0;s=s+1|0}while((s|0)<(l|0))}else n=0;p=c[b+48>>2]|0;if((p|0)<(n|0)?(c[b+52>>2]|0)<(n|0):0){if(!n)o=0;else{c[6435]=(c[6435]|0)+1;o=yc((n*152|3)+16|0)|0;if(!o)o=0;else{c[(o+4+15&-16)+-4>>2]=o;o=o+4+15&-16}p=c[b+48>>2]|0}if((p|0)>0){q=0;do{_m(o+(q*152|0)|0,(c[b+56>>2]|0)+(q*152|0)|0,152)|0;q=q+1|0}while((q|0)!=(p|0))}p=c[b+56>>2]|0;if(p|0){if(a[b+60>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[p+-4>>2]|0)}c[b+56>>2]=0}a[b+60>>0]=1;c[b+56>>2]=o;c[b+52>>2]=n}c[b+48>>2]=n;if((l|0)>0){n=c[b+176>>2]|0;V=0;W=0;while(1){U=n+(W<<3)|0;if(!(c[U>>2]|0))o=0;else{n=c[b+56>>2]|0;K=n+(V*152|0)|0;L=j+(W<<2)|0;M=c[L>>2]|0;P=c[M+28>>2]|0;Q=c[M+32>>2]|0;R=bk(b,P,+g[m+12>>2])|0;S=bk(b,Q,+g[m+12>>2])|0;T=c[b+16>>2]|0;o=c[M+24>>2]|0;o=(o|0)>0?o:c[m+20>>2]|0;if((o|0)>(c[b+184>>2]|0))c[b+184>>2]=o;if((c[U>>2]|0)>0){p=0;do{Qn(K+(p*152|0)|0,0,152)|0;g[K+(p*152|0)+120>>2]=-3402823466385288598117041.0e14;g[K+(p*152|0)+124>>2]=3402823466385288598117041.0e14;g[K+(p*152|0)+100>>2]=0.0;g[K+(p*152|0)+96>>2]=0.0;c[K+(p*152|0)+144>>2]=R;c[K+(p*152|0)+148>>2]=S;c[K+(p*152|0)+136>>2]=o;p=p+1|0}while((p|0)<(c[U>>2]|0))}c[T+(R*244|0)+64>>2]=0;c[T+(R*244|0)+64+4>>2]=0;c[T+(R*244|0)+64+8>>2]=0;c[T+(R*244|0)+64+12>>2]=0;c[T+(R*244|0)+64+16>>2]=0;c[T+(R*244|0)+64+20>>2]=0;c[T+(R*244|0)+64+24>>2]=0;c[T+(R*244|0)+64+28>>2]=0;c[T+(R*244|0)+144>>2]=0;c[T+(R*244|0)+144+4>>2]=0;c[T+(R*244|0)+144+8>>2]=0;c[T+(R*244|0)+144+12>>2]=0;c[T+(R*244|0)+144+16>>2]=0;c[T+(R*244|0)+144+20>>2]=0;c[T+(R*244|0)+144+24>>2]=0;c[T+(R*244|0)+144+28>>2]=0;c[T+(S*244|0)+64>>2]=0;c[T+(S*244|0)+64+4>>2]=0;c[T+(S*244|0)+64+8>>2]=0;c[T+(S*244|0)+64+12>>2]=0;c[T+(S*244|0)+64+16>>2]=0;c[T+(S*244|0)+64+20>>2]=0;c[T+(S*244|0)+64+24>>2]=0;c[T+(S*244|0)+64+28>>2]=0;c[T+(S*244|0)+144>>2]=0;c[T+(S*244|0)+144+4>>2]=0;c[T+(S*244|0)+144+8>>2]=0;c[T+(S*244|0)+144+12>>2]=0;c[T+(S*244|0)+144+16>>2]=0;c[T+(S*244|0)+144+20>>2]=0;c[T+(S*244|0)+144+24>>2]=0;c[T+(S*244|0)+144+28>>2]=0;g[Y+248>>2]=1.0/+g[m+12>>2];c[Y+248+4>>2]=c[m+32>>2];c[Y+248+8>>2]=n+(V*152|0)+16;c[Y+248+12>>2]=K;c[Y+248+16>>2]=n+(V*152|0)+48;c[Y+248+20>>2]=n+(V*152|0)+32;c[Y+248+24>>2]=38;c[Y+248+28>>2]=n+(V*152|0)+112;J=n+(V*152|0)+116|0;c[J>>2]=c[m+40>>2];c[Y+248+52>>2]=c[m+4>>2];c[Y+248+32>>2]=J;c[Y+248+36>>2]=n+(V*152|0)+120;c[Y+248+40>>2]=n+(V*152|0)+124;c[Y+248+48>>2]=c[m+20>>2];J=c[L>>2]|0;Cb[c[(c[J>>2]|0)+20>>2]&127](J,Y+248|0);if((c[U>>2]|0)>0){J=0;do{n=K+(J*152|0)+124|0;r=+g[(c[L>>2]|0)+16>>2];if(+g[n>>2]>=r)g[n>>2]=r;n=K+(J*152|0)+120|0;if(+g[n>>2]<=-r)g[n>>2]=-r;c[K+(J*152|0)+132>>2]=M;I=K+(J*152|0)|0;n=K+(J*152|0)+64|0;o=c[M+28>>2]|0;da=+g[I>>2];ba=+g[I+4>>2];B=+g[I+8>>2];ca=(da*+g[o+280>>2]+ba*+g[o+284>>2]+B*+g[o+288>>2])*+g[o+548>>2];r=(da*+g[o+296>>2]+ba*+g[o+300>>2]+B*+g[o+304>>2])*+g[o+552>>2];g[n>>2]=(+g[o+264>>2]*da+ +g[o+268>>2]*ba+ +g[o+272>>2]*B)*+g[o+544>>2];g[n+4>>2]=ca;g[n+8>>2]=r;g[n+12>>2]=0.0;n=K+(J*152|0)+32|0;o=K+(J*152|0)+80|0;H=c[M+32>>2]|0;r=+g[n>>2];ca=+g[n+4>>2];B=+g[n+8>>2];ba=(r*+g[H+280>>2]+ca*+g[H+284>>2]+B*+g[H+288>>2])*+g[H+548>>2];da=(r*+g[H+296>>2]+ca*+g[H+300>>2]+B*+g[H+304>>2])*+g[H+552>>2];g[o>>2]=(+g[H+264>>2]*r+ +g[H+268>>2]*ca+ +g[H+272>>2]*B)*+g[H+544>>2];g[o+4>>2]=ba;g[o+8>>2]=da;g[o+12>>2]=0.0;o=K+(J*152|0)+16|0;da=+g[P+344>>2];ba=+g[o>>2];ca=+g[o+4>>2];r=+g[o+8>>2];t=+g[I>>2];u=+g[I+4>>2];v=+g[I+8>>2];I=K+(J*152|0)+48|0;ea=+g[Q+344>>2];w=+g[I>>2];x=+g[I+4>>2];y=+g[I+8>>2];z=+g[n>>2];A=+g[n+4>>2];B=ba*da*ba+ca*da*ca+r*da*r+(t*(+g[P+264>>2]*t+ +g[P+268>>2]*u+ +g[P+272>>2]*v)+u*(t*+g[P+280>>2]+u*+g[P+284>>2]+v*+g[P+288>>2])+v*(t*+g[P+296>>2]+u*+g[P+300>>2]+v*+g[P+304>>2]))+(w*ea*w+x*ea*x+y*ea*y)+(z*(+g[Q+264>>2]*z+ +g[Q+268>>2]*A+ +g[Q+272>>2]*B)+A*(z*+g[Q+280>>2]+A*+g[Q+284>>2]+B*+g[Q+288>>2])+B*(z*+g[Q+296>>2]+A*+g[Q+300>>2]+B*+g[Q+304>>2]));I=+N(+B)>1.1920928955078125e-07;B=I?1.0/B:0.0;g[K+(J*152|0)+108>>2]=B;if(!(c[T+(R*244|0)+240>>2]|0)){p=0;q=0;d=0;D=0;E=0;F=0}else{p=c[T+(R*244|0)+208>>2]|0;q=c[T+(R*244|0)+212>>2]|0;d=c[T+(R*244|0)+216>>2]|0;D=c[T+(R*244|0)+224>>2]|0;E=c[T+(R*244|0)+228>>2]|0;F=c[T+(R*244|0)+232>>2]|0}if(!(c[T+(S*244|0)+240>>2]|0)){e=0;s=0;C=0;G=0;H=0;I=0}else{e=c[T+(S*244|0)+208>>2]|0;s=c[T+(S*244|0)+212>>2]|0;C=c[T+(S*244|0)+216>>2]|0;G=c[T+(S*244|0)+224>>2]|0;H=c[T+(S*244|0)+228>>2]|0;I=c[T+(S*244|0)+232>>2]|0}da=(c[k>>2]=p,+g[k>>2])+ +g[P+312>>2];ca=(c[k>>2]=q,+g[k>>2])+ +g[P+316>>2];ca=da*+g[o>>2]+ca*+g[o+4>>2]+((c[k>>2]=d,+g[k>>2])+ +g[P+320>>2])*r;da=(c[k>>2]=D,+g[k>>2])+ +g[P+328>>2];ba=(c[k>>2]=E,+g[k>>2])+ +g[P+332>>2];ba=ca+(da*t+ba*u+((c[k>>2]=F,+g[k>>2])+ +g[P+336>>2])*v);da=(c[k>>2]=e,+g[k>>2])+ +g[Q+312>>2];ca=(c[k>>2]=s,+g[k>>2])+ +g[Q+316>>2];ca=da*w+ca*x+((c[k>>2]=C,+g[k>>2])+ +g[Q+320>>2])*y;da=(c[k>>2]=G,+g[k>>2])+ +g[Q+328>>2];ea=(c[k>>2]=H,+g[k>>2])+ +g[Q+332>>2];H=K+(J*152|0)+112|0;g[H>>2]=+g[H>>2]*B+B*(0.0-+g[Y+248+52>>2]*(ba+(ca+(da*z+ea*A+((c[k>>2]=I,+g[k>>2])+ +g[Q+336>>2])*+g[n+8>>2]))));g[K+(J*152|0)+100>>2]=0.0;J=J+1|0}while((J|0)<(c[U>>2]|0))}o=c[b+176>>2]|0;n=o;o=c[o+(W<<3)>>2]|0}W=W+1|0;if((W|0)>=(l|0))break;else V=o+V|0}}mc[c[(c[b>>2]|0)+28>>2]&127](b,f,h,m);d=c[b+48>>2]|0;e=c[b+28>>2]|0;s=c[b+68>>2]|0;o=c[b+128>>2]|0;if((o|0)<(d|0)?(c[b+132>>2]|0)<(d|0):0){if(!d)n=0;else{c[6435]=(c[6435]|0)+1;n=yc((d<<2|3)+16|0)|0;if(!n)n=0;else{c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}o=c[b+128>>2]|0}q=c[b+136>>2]|0;if((o|0)<=0)if(!q)o=b+140|0;else X=99;else{p=0;do{c[n+(p<<2)>>2]=c[q+(p<<2)>>2];p=p+1|0}while((p|0)!=(o|0));X=99}if((X|0)==99){if(a[b+140>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[q+-4>>2]|0)}c[b+136>>2]=0;o=b+140|0}a[o>>0]=1;c[b+136>>2]=n;c[b+132>>2]=d}c[b+128>>2]=d;if(!(c[m+64>>2]&16)){o=c[b+108>>2]|0;if((o|0)<(e|0)?(c[b+112>>2]|0)<(e|0):0){if(!e)n=0;else{c[6435]=(c[6435]|0)+1;n=yc((e<<2|3)+16|0)|0;if(!n)n=0;else{c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}o=c[b+108>>2]|0}q=c[b+116>>2]|0;if((o|0)<=0)if(!q)o=b+120|0;else X=129;else{p=0;do{c[n+(p<<2)>>2]=c[q+(p<<2)>>2];p=p+1|0}while((p|0)!=(o|0));X=129}if((X|0)==129){if(a[b+120>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[q+-4>>2]|0)}c[b+116>>2]=0;o=b+120|0}a[o>>0]=1;c[b+116>>2]=n;c[b+112>>2]=e}c[b+108>>2]=e}else{o=c[b+108>>2]|0;if((o|0)<(e<<1|0)?(c[b+112>>2]|0)<(e<<1|0):0){if(!e)n=0;else{c[6435]=(c[6435]|0)+1;n=yc((e<<3|3)+16|0)|0;if(!n)n=0;else{c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}o=c[b+108>>2]|0}q=c[b+116>>2]|0;if((o|0)<=0)if(!q)o=b+120|0;else X=114;else{p=0;do{c[n+(p<<2)>>2]=c[q+(p<<2)>>2];p=p+1|0}while((p|0)!=(o|0));X=114}if((X|0)==114){if(a[b+120>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[q+-4>>2]|0)}c[b+116>>2]=0;o=b+120|0}a[o>>0]=1;c[b+116>>2]=n;c[b+112>>2]=e<<1}c[b+108>>2]=e<<1}o=c[b+148>>2]|0;if((o|0)<(s|0)?(c[b+152>>2]|0)<(s|0):0){if(!s)n=0;else{c[6435]=(c[6435]|0)+1;n=yc((s<<2|3)+16|0)|0;if(!n)n=0;else{c[(n+4+15&-16)+-4>>2]=n;n=n+4+15&-16}o=c[b+148>>2]|0}q=c[b+156>>2]|0;if((o|0)<=0)if(!q)o=b+160|0;else X=144;else{p=0;do{c[n+(p<<2)>>2]=c[q+(p<<2)>>2];p=p+1|0}while((p|0)!=(o|0));X=144}if((X|0)==144){if(a[b+160>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[q+-4>>2]|0)}c[b+156>>2]=0;o=b+160|0}a[o>>0]=1;c[b+156>>2]=n;c[b+152>>2]=s}c[b+148>>2]=s;if((d|0)>0){n=c[b+136>>2]|0;o=0;do{c[n+(o<<2)>>2]=o;o=o+1|0}while((o|0)!=(d|0))}if((e|0)>0){n=c[b+116>>2]|0;o=0;do{c[n+(o<<2)>>2]=o;o=o+1|0}while((o|0)!=(e|0))}if((s|0)>0){n=c[b+156>>2]|0;o=0;do{c[n+(o<<2)>>2]=o;o=o+1|0}while((o|0)!=(s|0))}n=c[2357]|0;b=(c[n+16>>2]|0)+-1|0;c[n+16>>2]=b;if(b|0){i=Y;return 0.0}do if(c[n+4>>2]|0){tb(Y+248|0,0)|0;b=c[6434]|0;g[n+8>>2]=+g[n+8>>2]+ +(((c[Y+248+4>>2]|0)-(c[b+4>>2]|0)+(((c[Y+248>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[n+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[n+16>>2]|0)){n=c[2357]|0;break}else{i=Y;return 0.0}}while(0);c[2357]=c[n+20>>2];i=Y;return 0.0}function Dc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0.0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0;J=i;i=i+240|0;if((e|0)<1){f=c[b+12>>2]|0;if(f|0){if(a[b+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;f=c[b+32>>2]|0;if(f|0){if(a[b+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+24>>2]=0;c[b+28>>2]=0;f=c[b+52>>2]|0;if(f|0){if(a[b+56>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[b+52>>2]=0}a[b+56>>0]=1;c[b+52>>2]=0;c[b+44>>2]=0;c[b+48>>2]=0;i=J;return}c[J+24+32>>2]=0;c[J+24+36>>2]=0;c[J+24+40>>2]=0;c[J+24+44>>2]=256;c[J+24+48>>2]=0;c[J+24+52>>2]=0;c[J+24+56>>2]=0;c[J+24+60>>2]=256;c[J+24+64>>2]=0;c[J+24+68>>2]=0;c[J+24+72>>2]=0;c[J+24+76>>2]=256;a[J+24+96>>0]=1;F=J+24+92|0;c[F>>2]=0;c[J+24+84>>2]=0;c[J+24+88>>2]=0;m=0;n=-246811958;v=-246811958;s=-246811958;r=1900671690;z=1900671690;u=1900671690;o=d;while(1){E=+g[o>>2];j=+g[o+4>>2];p=+g[o+8>>2];G=E<(c[k>>2]=r,+g[k>>2]);f=(g[k>>2]=E,c[k>>2]|0);r=G?f:r;G=j<(c[k>>2]=u,+g[k>>2]);h=(g[k>>2]=j,c[k>>2]|0);u=G?h:u;G=p<(c[k>>2]=z,+g[k>>2]);l=(g[k>>2]=p,c[k>>2]|0);z=G?l:z;n=(c[k>>2]=n,+g[k>>2])<E?f:n;s=(c[k>>2]=s,+g[k>>2])<j?h:s;v=(c[k>>2]=v,+g[k>>2])<p?l:v;m=m+1|0;if((m|0)==(e|0))break;else o=o+16|0}B=(c[k>>2]=n,+g[k>>2]);A=(c[k>>2]=r,+g[k>>2]);y=(c[k>>2]=s,+g[k>>2]);x=(c[k>>2]=u,+g[k>>2]);w=(c[k>>2]=v,+g[k>>2]);t=(c[k>>2]=z,+g[k>>2]);h=B-A<y-x?(y-x<w-t?2:1):B-A<w-t?2:0;c[J+24+112>>2]=h;f=B-A<y-x?(B-A<w-t?0:2):y-x<w-t?1:2;if((f|0)==(h|0))f=((h+1|0)>>>0)%3|0;c[J+24+104>>2]=f;G=(h^3)-f|0;c[J+24+108>>2]=G;if(((G+1|0)%3|0|0)==(h|0)){j=(B-A)*9.788566967472434e-05;p=(y-x)*9.788566967472434e-05;q=(w-t)*9.788566967472434e-05}else{j=-((B-A)*9.788566967472434e-05);p=-((y-x)*9.788566967472434e-05);q=-((w-t)*9.788566967472434e-05)}g[J+24>>2]=j;g[J+24+4>>2]=p;g[J+24+8>>2]=q;g[J+24+12>>2]=0.0;E=j!=0.0?1.0/j:j;D=p!=0.0?1.0/p:p;C=q!=0.0?1.0/q:q;g[J+24+16>>2]=(B+A)*.5;g[J+24+20>>2]=(y+x)*.5;g[J+24+24>>2]=(w+t)*.5;g[J+24+28>>2]=0.0;r=J+216+16|0;a[r>>0]=1;s=J+216+12|0;c[s>>2]=0;c[J+216+4>>2]=0;c[J+216+8>>2]=0;c[6435]=(c[6435]|0)+1;f=yc((e<<4|3)+16|0)|0;if(!f)m=0;else{c[(f+4+15&-16)+-4>>2]=f;m=f+4+15&-16}h=c[J+216+4>>2]|0;l=c[s>>2]|0;if((h|0)<=0){if(l|0)I=26}else{f=0;do{I=m+(f<<4)|0;G=l+(f<<4)|0;c[I>>2]=c[G>>2];c[I+4>>2]=c[G+4>>2];c[I+8>>2]=c[G+8>>2];c[I+12>>2]=c[G+12>>2];f=f+1|0}while((f|0)!=(h|0));I=26}if((I|0)==26){if(a[r>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[l+-4>>2]|0)}c[s>>2]=0}a[r>>0]=1;c[s>>2]=m;c[J+216+8>>2]=e;c[m>>2]=c[J+200>>2];c[m+4>>2]=c[J+200+4>>2];c[m+8>>2]=c[J+200+8>>2];c[m+12>>2]=c[J+200+12>>2];if((e|0)!=1){f=1;do{G=(c[s>>2]|0)+(f<<4)|0;c[G>>2]=c[J+200>>2];c[G+4>>2]=c[J+200+4>>2];c[G+8>>2]=c[J+200+8>>2];c[G+12>>2]=c[J+200+12>>2];f=f+1|0}while((f|0)!=(e|0))}c[J+216+4>>2]=e;h=J+184+(c[J+24+108>>2]<<2)|0;l=c[s>>2]|0;m=J+184+(c[J+24+112>>2]<<2)|0;n=J+184+(c[J+24+104>>2]<<2)|0;j=+g[J+24+16>>2];p=+g[J+24+20>>2];q=+g[J+24+24>>2];o=0;f=d;while(1){d=c[f>>2]|0;c[J+184>>2]=d;G=c[f+4>>2]|0;c[J+184+4>>2]=G;y=(c[k>>2]=d,+g[k>>2])-j;A=D*((c[k>>2]=G,+g[k>>2])-p);B=C*(+g[f+8>>2]-q);g[J+184>>2]=E*y;g[J+184+4>>2]=A;g[J+184+8>>2]=B;g[J+184+12>>2]=0.0;c[l+(o<<4)>>2]=~~+g[h>>2];c[l+(o<<4)+4>>2]=~~+g[m>>2];c[l+(o<<4)+8>>2]=~~+g[n>>2];c[l+(o<<4)+12>>2]=o;o=o+1|0;if((o|0)==(e|0))break;else f=f+16|0}if((e|0)>1)ch(J+216|0,0,e+-1|0);c[J+24+36>>2]=c[J+24+32>>2];c[J+24+40>>2]=0;c[J+24+44>>2]=e;f=c[J+24+84>>2]|0;if((f|0)<(e|0)){if((c[J+24+88>>2]|0)<(e|0)){if(!e){h=0;l=f}else{c[6435]=(c[6435]|0)+1;h=yc((e<<2|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}l=c[J+24+84>>2]|0}if((l|0)>0){m=0;do{c[h+(m<<2)>>2]=c[(c[F>>2]|0)+(m<<2)>>2];m=m+1|0}while((m|0)!=(l|0))}l=c[F>>2]|0;if(l|0){if(a[J+24+96>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[l+-4>>2]|0)}c[F>>2]=0}a[J+24+96>>0]=1;c[F>>2]=h;c[J+24+88>>2]=e}do{c[(c[F>>2]|0)+(f<<2)>>2]=0;f=f+1|0}while((f|0)!=(e|0))}c[J+24+84>>2]=e;n=0;do{f=c[J+24+40>>2]|0;if(!f){f=c[J+24+36>>2]|0;if(!f){c[6435]=(c[6435]|0)+1;f=yc(31)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}h=c[J+24+44>>2]|0;c[f+4>>2]=h;l=f+8|0;c[l>>2]=0;c[6435]=(c[6435]|0)+1;h=yc((h*112|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}c[f>>2]=h;c[l>>2]=c[J+24+32>>2];c[J+24+32>>2]=f}else c[J+24+36>>2]=c[f+8>>2];m=c[f+4>>2]|0;f=c[f>>2]|0;if((m|0)>0){h=0;l=f;do{h=h+1|0;G=l;l=l+112|0;c[G>>2]=(h|0)<(m|0)?l:0}while((h|0)!=(m|0))}}c[J+24+40>>2]=c[f>>2];G=f+104|0;c[f>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[G>>2]=-1;c[f+8>>2]=0;d=f+88|0;z=(c[s>>2]|0)+(n<<4)|0;c[d>>2]=c[z>>2];c[d+4>>2]=c[z+4>>2];c[d+8>>2]=c[z+8>>2];c[d+12>>2]=c[z+12>>2];c[G>>2]=-1;c[(c[F>>2]|0)+(n<<2)>>2]=f;n=n+1|0}while((n|0)<(e|0));f=c[s>>2]|0;if(f|0){if(a[r>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[s>>2]=0}a[r>>0]=1;c[s>>2]=0;c[J+216+4>>2]=0;c[J+216+8>>2]=0;c[J+24+52>>2]=c[J+24+48>>2];c[J+24+56>>2]=0;c[J+24+60>>2]=e*6;c[J+24+116>>2]=0;c[J+24+120>>2]=0;c[J+24+100>>2]=-3;c[J+184>>2]=0;c[J+184+4>>2]=0;c[J+184+8>>2]=0;c[J+184+12>>2]=0;vc(J+24|0,0,e,J+184|0);c[J+24+124>>2]=c[J+184>>2];f=c[s>>2]|0;if(f|0){if(a[r>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}c[s>>2]=0}f=c[b+4>>2]|0;if((f|0)<0){if((c[b+8>>2]|0)<0){h=c[b+12>>2]|0;if(h|0){if(a[b+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=0;c[b+8>>2]=0}do{G=(c[b+12>>2]|0)+(f<<4)|0;c[G>>2]=c[J+168>>2];c[G+4>>2]=c[J+168+4>>2];c[G+8>>2]=c[J+168+8>>2];c[G+12>>2]=c[J+168+12>>2];f=f+1|0}while((f|0)!=0)}c[b+4>>2]=0;c[J+152>>2]=0;c[J+152+4>>2]=0;c[J+152+8>>2]=0;f=c[b+24>>2]|0;if((f|0)<0){if((c[b+28>>2]|0)<0){h=c[b+32>>2]|0;if(h|0){if(a[b+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=0;c[b+28>>2]=0}do{G=(c[b+32>>2]|0)+(f*12|0)|0;c[G>>2]=c[J+152>>2];c[G+4>>2]=c[J+152+4>>2];c[G+8>>2]=c[J+152+8>>2];f=f+1|0}while((f|0)!=0)}c[b+24>>2]=0;h=c[b+44>>2]|0;if((h|0)<0){f=c[b+52>>2]|0;do if((c[b+48>>2]|0)<0){if(!f){a[b+56>>0]=1;c[b+52>>2]=0;c[b+48>>2]=0;f=0;break}if(a[b+56>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[f+-4>>2]|0)}a[b+56>>0]=1;c[b+52>>2]=0;c[b+48>>2]=0;f=0}while(0);Qn(f+(h<<2)|0,0,_(h,-4)|0)|0}c[b+44>>2]=0;f=c[J+24+124>>2]|0;if((c[f+104>>2]|0)<0){c[f+104>>2]=0;c[6435]=(c[6435]|0)+1;r=yc(23)|0;c[(r+4+15&-16)+-4>>2]=r;c[(r+4+15&-16)>>2]=f;G=0;m=1;l=1;r=r+4+15&-16;while(1){if((c[f+100>>2]|0)>-1){g[J+216+(c[J+24+108>>2]<<2)>>2]=+(c[f+88>>2]|0);g[J+216+(c[J+24+112>>2]<<2)>>2]=+(c[f+92>>2]|0);j=+(c[f+96>>2]|0)}else{e=f+24|0;d=f+32|0;j=+ln(c[e>>2]|0,c[e+4>>2]|0,c[d>>2]|0,c[d+4>>2]|0);d=f+72|0;e=f+80|0;F=c[e>>2]|0;e=c[e+4>>2]|0;j=j/+ln(c[d>>2]|0,c[d+4>>2]|0,F,e);g[J+216+(c[J+24+108>>2]<<2)>>2]=j;z=f+40|0;v=f+48|0;j=+ln(c[z>>2]|0,c[z+4>>2]|0,c[v>>2]|0,c[v+4>>2]|0);j=j/+ln(c[d>>2]|0,c[d+4>>2]|0,F,e);g[J+216+(c[J+24+112>>2]<<2)>>2]=j;v=f+56|0;z=f+64|0;j=+ln(c[v>>2]|0,c[v+4>>2]|0,c[z>>2]|0,c[z+4>>2]|0);j=j/+ln(c[d>>2]|0,c[d+4>>2]|0,F,e)}g[J+216+(c[J+24+104>>2]<<2)>>2]=j;j=+g[J+216>>2]*+g[J+24>>2]+ +g[J+24+16>>2];p=+g[J+216+4>>2]*+g[J+24+4>>2]+ +g[J+24+20>>2];q=+g[J+216+8>>2]*+g[J+24+8>>2]+ +g[J+24+24>>2];h=c[b+4>>2]|0;if((h|0)==(c[b+8>>2]|0)?(H=h|0?h<<1:1,(h|0)<(H|0)):0){if(!H)o=0;else{c[6435]=(c[6435]|0)+1;h=yc((H<<4|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}o=h;h=c[b+4>>2]|0}if((h|0)>0){n=0;do{e=o+(n<<4)|0;F=(c[b+12>>2]|0)+(n<<4)|0;c[e>>2]=c[F>>2];c[e+4>>2]=c[F+4>>2];c[e+8>>2]=c[F+8>>2];c[e+12>>2]=c[F+12>>2];n=n+1|0}while((n|0)!=(h|0))}h=c[b+12>>2]|0;if(h|0){if(a[b+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[b+12>>2]=0}a[b+16>>0]=1;c[b+12>>2]=o;c[b+8>>2]=H;h=c[b+4>>2]|0}F=c[b+12>>2]|0;g[F+(h<<4)>>2]=j;g[F+(h<<4)+4>>2]=p;g[F+(h<<4)+8>>2]=q;g[F+(h<<4)+12>>2]=0.0;c[b+4>>2]=(c[b+4>>2]|0)+1;F=c[f+8>>2]|0;if(!F)n=r;else{e=F;f=-1;z=r;d=-1;while(1){v=e+20|0;h=c[v>>2]|0;if((h|0)<0){u=c[b+24>>2]|0;c[J+12>>2]=0;c[J+12+4>>2]=0;c[J+12+8>>2]=0;do if((u|0)==(c[b+28>>2]|0)){r=u|0?u<<1:1;if((u|0)>=(r|0)){h=u;break}if(!r){h=0;n=u}else{c[6435]=(c[6435]|0)+1;h=yc((r*12|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}n=c[b+24>>2]|0}if((n|0)>0){o=0;do{s=h+(o*12|0)|0;K=(c[b+32>>2]|0)+(o*12|0)|0;c[s>>2]=c[K>>2];c[s+4>>2]=c[K+4>>2];c[s+8>>2]=c[K+8>>2];o=o+1|0}while((o|0)!=(n|0))}n=c[b+32>>2]|0;if(n|0){if(a[b+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[n+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=h;c[b+28>>2]=r;h=c[b+24>>2]|0}else h=u;while(0);h=(c[b+32>>2]|0)+(h*12|0)|0;c[h>>2]=c[J+12>>2];c[h+4>>2]=c[J+12+4>>2];c[h+8>>2]=c[J+12+8>>2];h=(c[b+24>>2]|0)+1|0;c[b+24>>2]=h;c[J>>2]=0;c[J+4>>2]=0;c[J+8>>2]=0;do if((h|0)==(c[b+28>>2]|0)){r=h|0?h<<1:1;if((h|0)>=(r|0))break;if(!r)o=0;else{c[6435]=(c[6435]|0)+1;h=yc((r*12|3)+16|0)|0;if(!h)h=0;else{c[(h+4+15&-16)+-4>>2]=h;h=h+4+15&-16}o=h;h=c[b+24>>2]|0}if((h|0)>0){n=0;do{K=o+(n*12|0)|0;s=(c[b+32>>2]|0)+(n*12|0)|0;c[K>>2]=c[s>>2];c[K+4>>2]=c[s+4>>2];c[K+8>>2]=c[s+8>>2];n=n+1|0}while((n|0)!=(h|0))}h=c[b+32>>2]|0;if(h|0){if(a[b+36>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[h+-4>>2]|0)}c[b+32>>2]=0}a[b+36>>0]=1;c[b+32>>2]=o;c[b+28>>2]=r;h=c[b+24>>2]|0}while(0);s=(c[b+32>>2]|0)+(h*12|0)|0;c[s>>2]=c[J>>2];c[s+4>>2]=c[J+4>>2];c[s+8>>2]=c[J+8>>2];c[b+24>>2]=(c[b+24>>2]|0)+1;s=c[b+32>>2]|0;c[v>>2]=u;c[(c[e+8>>2]|0)+20>>2]=u+1;c[s+(u*12|0)+4>>2]=1;c[s+((u+1|0)*12|0)+4>>2]=-1;r=c[e+12>>2]|0;h=c[r+104>>2]|0;if((h|0)<0){c[r+104>>2]=l;do if((l|0)==(m|0)){o=m|0?m<<1:1;if((m|0)>=(o|0)){n=z;break}do if(!o)n=0;else{c[6435]=(c[6435]|0)+1;h=yc((o<<2|3)+16|0)|0;if(!h){n=0;break}c[(h+4+15&-16)+-4>>2]=h;n=h+4+15&-16}while(0);if((m|0)<=0){if(!z){m=o;break}}else{h=0;do{c[n+(h<<2)>>2]=c[z+(h<<2)>>2];h=h+1|0}while((h|0)!=(m|0))}c[6436]=(c[6436]|0)+1;hd(c[z+-4>>2]|0);m=o}else n=z;while(0);c[n+(l<<2)>>2]=r;h=l;l=l+1|0}else n=z;c[s+(u*12|0)+8>>2]=h;c[s+((u+1|0)*12|0)+8>>2]=G;h=c[v>>2]|0}else n=z;if((d|0)>-1)c[(c[b+32>>2]|0)+(h*12|0)>>2]=d-h;else f=h;e=c[e>>2]|0;if((e|0)==(F|0))break;else{z=n;d=h}}c[(c[b+32>>2]|0)+(f*12|0)>>2]=h-f}h=G+1|0;if((h|0)>=(l|0))break;f=c[n+(h<<2)>>2]|0;G=h;r=n}if((G|0)>-1){v=0;while(1){s=c[(c[n+(v<<2)>>2]|0)+8>>2]|0;if(s|0){u=s;do{r=u+20|0;f=c[r>>2]|0;if((f|0)>-1){h=c[b+44>>2]|0;do if((h|0)==(c[b+48>>2]|0)){o=h|0?h<<1:1;if((h|0)>=(o|0))break;if(!o)f=0;else{c[6435]=(c[6435]|0)+1;f=yc((o<<2|3)+16|0)|0;if(!f)f=0;else{c[(f+4+15&-16)+-4>>2]=f;f=f+4+15&-16}h=c[b+44>>2]|0}m=c[b+52>>2]|0;if((h|0)<=0){if(m)I=173}else{l=0;do{c[f+(l<<2)>>2]=c[m+(l<<2)>>2];l=l+1|0}while((l|0)!=(h|0));I=173}if((I|0)==173){I=0;if(a[b+56>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[m+-4>>2]|0)}c[b+52>>2]=0;h=c[b+44>>2]|0}a[b+56>>0]=1;c[b+52>>2]=f;c[b+48>>2]=o;f=c[r>>2]|0}while(0);c[(c[b+52>>2]|0)+(h<<2)>>2]=f;c[b+44>>2]=(c[b+44>>2]|0)+1;f=u;do{c[f+20>>2]=-1;f=c[(c[f+8>>2]|0)+4>>2]|0}while((f|0)!=(u|0))}u=c[u>>2]|0}while((u|0)!=(s|0))}if((v|0)==(G|0))break;else v=v+1|0}}if(n|0){c[6436]=(c[6436]|0)+1;hd(c[n+-4>>2]|0)}}Zi(J+24|0);i=J;return}function Ec(b){b=b|0;var d=0,e=0.0,f=0.0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0;I=i;i=i+64|0;if(!(a[b+356>>0]|0)){b=a[b+312>>0]|0;b=b<<24>>24!=0;i=I;return b|0}c[b+336>>2]=0;c[b+336+4>>2]=0;c[b+336+8>>2]=0;c[b+336+12>>2]=0;a[b+336+16>>0]=0;h=a[b+332>>0]|0;a[b+332>>0]=h&-16;a[b+356>>0]=0;switch(c[b>>2]|0){case 0:{a[b+312>>0]=0;b=0;b=b<<24>>24!=0;i=I;return b|0}case 1:{c[b+244>>2]=c[b+84>>2];c[b+244+4>>2]=c[b+84+4>>2];c[b+244+8>>2]=c[b+84+8>>2];c[b+244+12>>2]=c[b+84+12>>2];c[b+260>>2]=c[b+164>>2];c[b+260+4>>2]=c[b+164+4>>2];c[b+260+8>>2]=c[b+164+8>>2];c[b+260+12>>2]=c[b+164+12>>2];E=+g[b+248>>2]-+g[b+264>>2];F=+g[b+252>>2]-+g[b+268>>2];g[b+276>>2]=+g[b+244>>2]-+g[b+260>>2];g[b+280>>2]=E;g[b+284>>2]=F;g[b+288>>2]=0.0;c[b+336>>2]=0;c[b+336+4>>2]=0;c[b+336+8>>2]=0;c[b+336+12>>2]=0;a[b+336+16>>0]=0;a[b+332>>0]=h&-16;g[b+336>>2]=1.0;g[b+340>>2]=0.0;g[b+344>>2]=0.0;g[b+348>>2]=0.0;a[b+312>>0]=1;b=1;b=b<<24>>24!=0;i=I;return b|0}case 2:{e=+g[b+4>>2];f=+g[b+8>>2];j=+g[b+12>>2];k=+g[b+20>>2]-e;l=+g[b+24>>2]-f;m=+g[b+28>>2]-j;do if((0.0-e)*k+(0.0-f)*l+(0.0-j)*m>0.0)if((0.0-e)*k+(0.0-f)*l+(0.0-j)*m<k*k+l*l+m*m){a[b+332>>0]=h&-16|3;h=h&-16|3;f=((0.0-e)*k+(0.0-f)*l+(0.0-j)*m)/(k*k+l*l+m*m);break}else{a[b+332>>0]=h&-16|2;h=h&-16|2;f=1.0;break}else{a[b+332>>0]=h&-16|1;h=h&-16|1;f=0.0}while(0);e=1.0-f;g[b+336>>2]=e;g[b+340>>2]=f;g[b+344>>2]=0.0;g[b+348>>2]=0.0;A=+g[b+84>>2];C=+g[b+88>>2];E=+g[b+92>>2];A=A+f*(+g[b+100>>2]-A);C=C+f*(+g[b+104>>2]-C);E=E+f*(+g[b+108>>2]-E);g[b+244>>2]=A;g[b+248>>2]=C;g[b+252>>2]=E;g[b+256>>2]=0.0;B=+g[b+164>>2];D=+g[b+168>>2];F=+g[b+172>>2];B=B+f*(+g[b+180>>2]-B);D=D+f*(+g[b+184>>2]-D);F=F+f*(+g[b+188>>2]-F);g[b+260>>2]=B;g[b+264>>2]=D;g[b+268>>2]=F;g[b+272>>2]=0.0;g[b+276>>2]=A-B;g[b+280>>2]=C-D;g[b+284>>2]=E-F;g[b+288>>2]=0.0;if(!(h&2)){c[b>>2]=1;d=0}else d=1;if(!(h&1)){c[b>>2]=d;H=b+4+(d<<4)|0;c[b+4>>2]=c[H>>2];c[b+4+4>>2]=c[H+4>>2];c[b+4+8>>2]=c[H+8>>2];c[b+4+12>>2]=c[H+12>>2];H=b+84+(d<<4)|0;c[b+84>>2]=c[H>>2];c[b+84+4>>2]=c[H+4>>2];c[b+84+8>>2]=c[H+8>>2];c[b+84+12>>2]=c[H+12>>2];H=b+164+(d<<4)|0;c[b+164>>2]=c[H>>2];c[b+164+4>>2]=c[H+4>>2];c[b+164+8>>2]=c[H+8>>2];c[b+164+12>>2]=c[H+12>>2]}H=(!(e>=0.0)|!(f>=0.0))&1^1;a[b+312>>0]=H;b=H;b=b<<24>>24!=0;i=I;return b|0}case 3:{c[I+16>>2]=0;c[I+16+4>>2]=0;c[I+16+8>>2]=0;c[I+16+12>>2]=0;Ve(I+16|0,b+4|0,b+20|0,b+36|0,b+316|0);F=+g[b+336>>2];e=+g[b+340>>2];f=+g[b+344>>2];A=+g[b+84>>2]*F+ +g[b+100>>2]*e+ +g[b+116>>2]*f;C=F*+g[b+88>>2]+e*+g[b+104>>2]+f*+g[b+120>>2];E=F*+g[b+92>>2]+e*+g[b+108>>2]+f*+g[b+124>>2];g[b+244>>2]=A;g[b+248>>2]=C;g[b+252>>2]=E;g[b+256>>2]=0.0;B=+g[b+164>>2]*F+ +g[b+180>>2]*e+ +g[b+196>>2]*f;D=F*+g[b+168>>2]+e*+g[b+184>>2]+f*+g[b+200>>2];F=F*+g[b+172>>2]+e*+g[b+188>>2]+f*+g[b+204>>2];g[b+260>>2]=B;g[b+264>>2]=D;g[b+268>>2]=F;g[b+272>>2]=0.0;g[b+276>>2]=A-B;g[b+280>>2]=C-D;g[b+284>>2]=E-F;g[b+288>>2]=0.0;h=c[b>>2]|0;do if((h|0)>3){d=a[b+332>>0]|0;if(!(d&8)){c[b>>2]=h+-1;H=b+4+(h+-1<<4)|0;c[b+52>>2]=c[H>>2];c[b+52+4>>2]=c[H+4>>2];c[b+52+8>>2]=c[H+8>>2];c[b+52+12>>2]=c[H+12>>2];H=b+84+(h+-1<<4)|0;c[b+132>>2]=c[H>>2];c[b+132+4>>2]=c[H+4>>2];c[b+132+8>>2]=c[H+8>>2];c[b+132+12>>2]=c[H+12>>2];H=b+164+(h+-1<<4)|0;c[b+212>>2]=c[H>>2];c[b+212+4>>2]=c[H+4>>2];c[b+212+8>>2]=c[H+8>>2];c[b+212+12>>2]=c[H+12>>2];h=h+-1|0;H=21}else H=21}else{if((h|0)>2){d=a[b+332>>0]|0;h=3;H=21;break}if((h|0)>1){d=a[b+332>>0]|0;h=2;H=25;break}if((h|0)>0){o=a[b+332>>0]|0;n=1;H=29}}while(0);if((H|0)==21)if(!(d&4)){h=h+-1|0;c[b>>2]=h;c[b+36>>2]=c[b+4+(h<<4)>>2];c[b+36+4>>2]=c[b+4+(h<<4)+4>>2];c[b+36+8>>2]=c[b+4+(h<<4)+8>>2];c[b+36+12>>2]=c[b+4+(h<<4)+12>>2];c[b+116>>2]=c[b+84+(h<<4)>>2];c[b+116+4>>2]=c[b+84+(h<<4)+4>>2];c[b+116+8>>2]=c[b+84+(h<<4)+8>>2];c[b+116+12>>2]=c[b+84+(h<<4)+12>>2];c[b+196>>2]=c[b+164+(h<<4)>>2];c[b+196+4>>2]=c[b+164+(h<<4)+4>>2];c[b+196+8>>2]=c[b+164+(h<<4)+8>>2];c[b+196+12>>2]=c[b+164+(h<<4)+12>>2];H=25}else H=25;if((H|0)==25)if(!(d&2)){n=h+-1|0;c[b>>2]=n;c[b+20>>2]=c[b+4+(n<<4)>>2];c[b+20+4>>2]=c[b+4+(n<<4)+4>>2];c[b+20+8>>2]=c[b+4+(n<<4)+8>>2];c[b+20+12>>2]=c[b+4+(n<<4)+12>>2];c[b+100>>2]=c[b+84+(n<<4)>>2];c[b+100+4>>2]=c[b+84+(n<<4)+4>>2];c[b+100+8>>2]=c[b+84+(n<<4)+8>>2];c[b+100+12>>2]=c[b+84+(n<<4)+12>>2];c[b+180>>2]=c[b+164+(n<<4)>>2];c[b+180+4>>2]=c[b+164+(n<<4)+4>>2];c[b+180+8>>2]=c[b+164+(n<<4)+8>>2];c[b+180+12>>2]=c[b+164+(n<<4)+12>>2];o=d;H=29}else{o=d;n=h;H=29}if((H|0)==29?(o&1)==0:0){H=n+-1|0;c[b>>2]=H;c[b+4>>2]=c[b+4+(H<<4)>>2];c[b+4+4>>2]=c[b+4+(H<<4)+4>>2];c[b+4+8>>2]=c[b+4+(H<<4)+8>>2];c[b+4+12>>2]=c[b+4+(H<<4)+12>>2];c[b+84>>2]=c[b+84+(H<<4)>>2];c[b+84+4>>2]=c[b+84+(H<<4)+4>>2];c[b+84+8>>2]=c[b+84+(H<<4)+8>>2];c[b+84+12>>2]=c[b+84+(H<<4)+12>>2];c[b+164>>2]=c[b+164+(H<<4)>>2];c[b+164+4>>2]=c[b+164+(H<<4)+4>>2];c[b+164+8>>2]=c[b+164+(H<<4)+8>>2];c[b+164+12>>2]=c[b+164+(H<<4)+12>>2]}if((e>=0.0?!(+g[b+336>>2]>=0.0):1)|!(f>=0.0))d=0;else d=+g[b+348>>2]>=0.0&1;a[b+312>>0]=d;b=d;b=b<<24>>24!=0;i=I;return b|0}case 4:{c[I>>2]=0;c[I+4>>2]=0;c[I+8>>2]=0;c[I+12>>2]=0;q=I+16+16|0;a[q>>0]=0;c[b+316>>2]=0;c[b+316+4>>2]=0;c[b+316+8>>2]=0;c[b+316+12>>2]=0;a[b+332>>0]=h|15;K=+g[b+20>>2];T=+g[b+4>>2];Q=+g[b+24>>2];J=+g[b+8>>2];M=+g[b+28>>2];U=+g[b+12>>2];P=+g[b+36>>2];R=+g[b+40>>2];N=+g[b+44>>2];L=+g[b+52>>2];S=+g[b+56>>2];O=+g[b+60>>2];V=((Q-J)*(N-U)-(M-U)*(R-J))*(L-T)+((M-U)*(P-T)-(K-T)*(N-U))*(S-J)+((K-T)*(R-J)-(Q-J)*(P-T))*(O-U);h=V*V<9.99999905104687e-09?-1:((0.0-T)*((Q-J)*(N-U)-(M-U)*(R-J))+(0.0-J)*((M-U)*(P-T)-(K-T)*(N-U))+((K-T)*(R-J)-(Q-J)*(P-T))*(0.0-U))*V<0.0&1;V=(M-U)*((P-T)*(S-J)-(R-J)*(L-T))+((K-T)*((R-J)*(O-U)-(N-U)*(S-J))+(Q-J)*((N-U)*(L-T)-(P-T)*(O-U)));n=V*V<9.99999905104687e-09?-1:((0.0-U)*((P-T)*(S-J)-(R-J)*(L-T))+((0.0-T)*((R-J)*(O-U)-(N-U)*(S-J))+(0.0-J)*((N-U)*(L-T)-(P-T)*(O-U))))*V<0.0&1;V=(N-U)*((Q-J)*(L-T)-(K-T)*(S-J))+((P-T)*((M-U)*(S-J)-(Q-J)*(O-U))+(R-J)*((K-T)*(O-U)-(M-U)*(L-T)));o=V*V<9.99999905104687e-09?-1:((0.0-U)*((Q-J)*(L-T)-(K-T)*(S-J))+((0.0-T)*((M-U)*(S-J)-(Q-J)*(O-U))+(0.0-J)*((K-T)*(O-U)-(M-U)*(L-T))))*V<0.0&1;J=(U-M)*((R-Q)*(L-K)-(P-K)*(S-Q))+((T-K)*((N-M)*(S-Q)-(R-Q)*(O-M))+(J-Q)*((P-K)*(O-M)-(N-M)*(L-K)));p=J*J<9.99999905104687e-09?-1:((0.0-M)*((R-Q)*(L-K)-(P-K)*(S-Q))+((0.0-K)*((N-M)*(S-Q)-(R-Q)*(O-M))+(0.0-Q)*((P-K)*(O-M)-(N-M)*(L-K))))*J<0.0&1;do if((n|h|o|p|0)<0){a[b+352>>0]=1;d=b+312|0;H=70}else{if(!(n|h|o|p)){if(a[b+352>>0]|0){d=b+312|0;H=70;break}a[b+312>>0]=1;c[b+276>>2]=0;c[b+276+4>>2]=0;c[b+276+8>>2]=0;c[b+276+12>>2]=0;d=1;break}if((h|0)!=0?(Ve(I,b+4|0,b+20|0,b+36|0,I+16|0),e=+g[I+16>>2],f=+g[I+16+4>>2],j=+g[I+16+8>>2],k=e-+g[I>>2],l=f-+g[I+4>>2],m=j-+g[I+8>>2],k*k+l*l+m*m<3402823466385288598117041.0e14):0){W=c[I+16+12>>2]|0;g[b+316>>2]=e;g[b+320>>2]=f;g[b+324>>2]=j;c[b+328>>2]=W;W=a[q>>0]|0;a[b+332>>0]=W&1|a[b+332>>0]&-16|W&2|W&4;W=c[I+16+24>>2]|0;h=c[I+16+28>>2]|0;c[b+336>>2]=c[I+16+20>>2];c[b+340>>2]=W;c[b+344>>2]=h;g[b+348>>2]=0.0;e=k*k+l*l+m*m}else e=3402823466385288598117041.0e14;if((n|0)!=0?(Ve(I,b+4|0,b+36|0,b+52|0,I+16|0),r=+g[I+16>>2],s=+g[I+16+4>>2],t=+g[I+16+8>>2],u=r-+g[I>>2],v=s-+g[I+4>>2],w=t-+g[I+8>>2],u*u+v*v+w*w<e):0){n=c[I+16+12>>2]|0;g[b+316>>2]=r;g[b+320>>2]=s;g[b+324>>2]=t;c[b+328>>2]=n;n=a[q>>0]|0;a[b+332>>0]=n<<1&8|(n&1|a[b+332>>0]&-16|n<<1&4);n=c[I+16+24>>2]|0;W=c[I+16+28>>2]|0;c[b+336>>2]=c[I+16+20>>2];g[b+340>>2]=0.0;c[b+344>>2]=n;c[b+348>>2]=W;e=u*u+v*v+w*w}if((o|0)!=0?(Ve(I,b+4|0,b+52|0,b+20|0,I+16|0),x=+g[I+16>>2],y=+g[I+16+4>>2],z=+g[I+16+8>>2],A=x-+g[I>>2],B=y-+g[I+4>>2],C=z-+g[I+8>>2],A*A+B*B+C*C<e):0){o=c[I+16+12>>2]|0;g[b+316>>2]=x;g[b+320>>2]=y;g[b+324>>2]=z;c[b+328>>2]=o;o=a[q>>0]|0;a[b+332>>0]=o<<2&8|(o&1|a[b+332>>0]&-16|(o&255)>>>1&2);o=c[I+16+28>>2]|0;W=c[I+16+24>>2]|0;c[b+336>>2]=c[I+16+20>>2];c[b+340>>2]=o;g[b+344>>2]=0.0;c[b+348>>2]=W;e=A*A+B*B+C*C}if(p|0?(Ve(I,b+20|0,b+52|0,b+36|0,I+16|0),D=+g[I+16>>2],E=+g[I+16+4>>2],F=+g[I+16+8>>2],T=D-+g[I>>2],U=E-+g[I+4>>2],V=F-+g[I+8>>2],T*T+U*U+V*V<e):0){p=c[I+16+12>>2]|0;g[b+316>>2]=D;g[b+320>>2]=E;g[b+324>>2]=F;c[b+328>>2]=p;p=a[q>>0]|0;a[b+332>>0]=p&4|a[b+332>>0]&-16|p<<1&2|p<<2&8;p=c[I+16+20>>2]|0;q=c[I+16+28>>2]|0;W=c[I+16+24>>2]|0;g[b+336>>2]=0.0;c[b+340>>2]=p;c[b+344>>2]=q;c[b+348>>2]=W}O=+g[b+336>>2];P=+g[b+340>>2];V=+g[b+344>>2];e=+g[b+348>>2];Q=+g[b+84>>2]*O+ +g[b+100>>2]*P+ +g[b+116>>2]*V+ +g[b+132>>2]*e;S=O*+g[b+88>>2]+P*+g[b+104>>2]+V*+g[b+120>>2]+e*+g[b+136>>2];U=O*+g[b+92>>2]+P*+g[b+108>>2]+V*+g[b+124>>2]+e*+g[b+140>>2];g[b+244>>2]=Q;g[b+248>>2]=S;g[b+252>>2]=U;g[b+256>>2]=0.0;R=+g[b+164>>2]*O+ +g[b+180>>2]*P+ +g[b+196>>2]*V+ +g[b+212>>2]*e;T=O*+g[b+168>>2]+P*+g[b+184>>2]+V*+g[b+200>>2]+e*+g[b+216>>2];V=O*+g[b+172>>2]+P*+g[b+188>>2]+V*+g[b+204>>2]+e*+g[b+220>>2];g[b+260>>2]=R;g[b+264>>2]=T;g[b+268>>2]=V;g[b+272>>2]=0.0;g[b+276>>2]=Q-R;g[b+280>>2]=S-T;g[b+284>>2]=U-V;g[b+288>>2]=0.0;h=c[b>>2]|0;do if((h|0)>3){d=a[b+332>>0]|0;if(!(d&8)){c[b>>2]=h+-1;H=b+4+(h+-1<<4)|0;c[b+52>>2]=c[H>>2];c[b+52+4>>2]=c[H+4>>2];c[b+52+8>>2]=c[H+8>>2];c[b+52+12>>2]=c[H+12>>2];H=b+84+(h+-1<<4)|0;c[b+132>>2]=c[H>>2];c[b+132+4>>2]=c[H+4>>2];c[b+132+8>>2]=c[H+8>>2];c[b+132+12>>2]=c[H+12>>2];H=b+164+(h+-1<<4)|0;c[b+212>>2]=c[H>>2];c[b+212+4>>2]=c[H+4>>2];c[b+212+8>>2]=c[H+8>>2];c[b+212+12>>2]=c[H+12>>2];h=h+-1|0;H=54}else H=54}else{if((h|0)>2){d=a[b+332>>0]|0;h=3;H=54;break}if((h|0)>1){d=a[b+332>>0]|0;h=2;H=58;break}if((h|0)>0){d=a[b+332>>0]|0;G=1;H=62}}while(0);if((H|0)==54)if(!(d&4)){h=h+-1|0;c[b>>2]=h;c[b+36>>2]=c[b+4+(h<<4)>>2];c[b+36+4>>2]=c[b+4+(h<<4)+4>>2];c[b+36+8>>2]=c[b+4+(h<<4)+8>>2];c[b+36+12>>2]=c[b+4+(h<<4)+12>>2];c[b+116>>2]=c[b+84+(h<<4)>>2];c[b+116+4>>2]=c[b+84+(h<<4)+4>>2];c[b+116+8>>2]=c[b+84+(h<<4)+8>>2];c[b+116+12>>2]=c[b+84+(h<<4)+12>>2];c[b+196>>2]=c[b+164+(h<<4)>>2];c[b+196+4>>2]=c[b+164+(h<<4)+4>>2];c[b+196+8>>2]=c[b+164+(h<<4)+8>>2];c[b+196+12>>2]=c[b+164+(h<<4)+12>>2];H=58}else H=58;if((H|0)==58)if(!(d&2)){G=h+-1|0;c[b>>2]=G;c[b+20>>2]=c[b+4+(G<<4)>>2];c[b+20+4>>2]=c[b+4+(G<<4)+4>>2];c[b+20+8>>2]=c[b+4+(G<<4)+8>>2];c[b+20+12>>2]=c[b+4+(G<<4)+12>>2];c[b+100>>2]=c[b+84+(G<<4)>>2];c[b+100+4>>2]=c[b+84+(G<<4)+4>>2];c[b+100+8>>2]=c[b+84+(G<<4)+8>>2];c[b+100+12>>2]=c[b+84+(G<<4)+12>>2];c[b+180>>2]=c[b+164+(G<<4)>>2];c[b+180+4>>2]=c[b+164+(G<<4)+4>>2];c[b+180+8>>2]=c[b+164+(G<<4)+8>>2];c[b+180+12>>2]=c[b+164+(G<<4)+12>>2];H=62}else{G=h;H=62}if((H|0)==62?(d&1)==0:0){W=G+-1|0;c[b>>2]=W;c[b+4>>2]=c[b+4+(W<<4)>>2];c[b+4+4>>2]=c[b+4+(W<<4)+4>>2];c[b+4+8>>2]=c[b+4+(W<<4)+8>>2];c[b+4+12>>2]=c[b+4+(W<<4)+12>>2];c[b+84>>2]=c[b+84+(W<<4)>>2];c[b+84+4>>2]=c[b+84+(W<<4)+4>>2];c[b+84+8>>2]=c[b+84+(W<<4)+8>>2];c[b+84+12>>2]=c[b+84+(W<<4)+12>>2];c[b+164>>2]=c[b+164+(W<<4)>>2];c[b+164+4>>2]=c[b+164+(W<<4)+4>>2];c[b+164+8>>2]=c[b+164+(W<<4)+8>>2];c[b+164+12>>2]=c[b+164+(W<<4)+12>>2]}if((+g[b+336>>2]>=0.0?+g[b+340>>2]>=0.0:0)?+g[b+344>>2]>=0.0:0)d=e>=0.0&1;else d=0;a[b+312>>0]=d}while(0);if((H|0)==70){a[d>>0]=0;d=0}W=d;W=W<<24>>24!=0;i=I;return W|0}default:{a[b+312>>0]=0;W=0;W=W<<24>>24!=0;i=I;return W|0}}return 0}function Fc(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0.0,r=0.0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,P=0,S=0.0,U=0.0,V=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0.0,qa=0,ra=0.0,sa=0.0,ta=0.0,ua=0.0,va=0.0,wa=0.0;qa=i;i=i+144|0;g[b+504>>2]=0.0;g[b+500>>2]=0.0;a[b+525>>0]=0;a[b+526>>0]=0;if(a[b+552>>0]|0?(a[b+527>>0]|0)==0:0){wa=+g[b+556>>2];ua=+g[b+560>>2];pa=+g[b+564>>2];ta=+g[b+568>>2];ea=wa*(2.0/(wa*wa+ua*ua+pa*pa+ta*ta));va=ua*(2.0/(wa*wa+ua*ua+pa*pa+ta*ta));sa=pa*(2.0/(wa*wa+ua*ua+pa*pa+ta*ta));fa=+g[b+300>>2];X=+g[d>>2];ga=+g[b+316>>2];Y=+g[d+4>>2];ha=+g[b+332>>2];Z=+g[d+8>>2];ja=+g[b+304>>2];la=+g[b+320>>2];na=+g[b+336>>2];ba=+g[b+308>>2];ca=+g[b+324>>2];da=+g[b+340>>2];_=+g[d+16>>2];$=+g[d+20>>2];aa=+g[d+24>>2];ka=+g[d+32>>2];ma=+g[d+36>>2];oa=+g[d+40>>2];v=+g[b+348>>2];u=+g[b+352>>2];r=+g[b+356>>2];z=+g[b+364>>2];ra=+g[e>>2];A=+g[b+380>>2];n=+g[e+4>>2];B=+g[b+396>>2];m=+g[e+8>>2];C=+g[b+368>>2];D=+g[b+384>>2];E=+g[b+400>>2];w=+g[b+372>>2];x=+g[b+388>>2];y=+g[b+404>>2];o=+g[e+16>>2];q=+g[e+20>>2];l=+g[e+24>>2];F=+g[e+32>>2];H=+g[e+36>>2];J=+g[e+40>>2];G=+g[b+412>>2];I=+g[b+416>>2];j=+g[b+420>>2];L=(1.0-(ua*va+pa*sa))*(z*ra+A*n+B*m)+(wa*va+ta*sa)*(ra*C+n*D+m*E)+(wa*sa-ta*va)*(ra*w+n*x+m*y);M=(wa*va-ta*sa)*(z*ra+A*n+B*m)+(1.0-(wa*ea+pa*sa))*(ra*C+n*D+m*E)+(ua*sa+ta*ea)*(ra*w+n*x+m*y);K=(wa*sa+ta*va)*(z*ra+A*n+B*m)+(ua*sa-ta*ea)*(ra*C+n*D+m*E)+(1.0-(wa*ea+ua*va))*(ra*w+n*x+m*y);U=(wa*sa-ta*va)*(w*o+x*q+y*l)+((1.0-(ua*va+pa*sa))*(z*o+A*q+B*l)+(wa*va+ta*sa)*(C*o+D*q+E*l));V=(ua*sa+ta*ea)*(w*o+x*q+y*l)+((wa*va-ta*sa)*(z*o+A*q+B*l)+(1.0-(wa*ea+pa*sa))*(C*o+D*q+E*l));S=(1.0-(wa*ea+ua*va))*(w*o+x*q+y*l)+((wa*sa+ta*va)*(z*o+A*q+B*l)+(ua*sa-ta*ea)*(C*o+D*q+E*l));ia=(wa*sa-ta*va)*(w*F+x*H+y*J)+((1.0-(ua*va+pa*sa))*(z*F+A*H+B*J)+(wa*va+ta*sa)*(C*F+D*H+E*J));pa=(ua*sa+ta*ea)*(w*F+x*H+y*J)+((wa*va-ta*sa)*(z*F+A*H+B*J)+(1.0-(wa*ea+pa*sa))*(C*F+D*H+E*J));ea=(1.0-(wa*ea+ua*va))*(w*F+x*H+y*J)+((wa*sa+ta*va)*(z*F+A*H+B*J)+(ua*sa-ta*ea)*(C*F+D*H+E*J));ta=-(+g[d+48>>2]+(X*v+Y*u+Z*r));sa=-(_*v+$*u+aa*r+ +g[d+52>>2]);r=-(ka*v+ma*u+oa*r+ +g[d+56>>2]);u=(fa*X+ga*Y+ha*Z)*ta+(fa*_+ga*$+ha*aa)*sa+(fa*ka+ga*ma+ha*oa)*r;v=(X*ja+Y*la+Z*na)*ta+(ja*_+la*$+na*aa)*sa+(ja*ka+la*ma+na*oa)*r;r=(X*ba+Y*ca+Z*da)*ta+(ba*_+ca*$+da*aa)*sa+(ba*ka+ca*ma+da*oa)*r;m=r*K+(u*L+v*M)+((z*ra+A*n+B*m)*0.0+(ra*C+n*D+m*E)*0.0+(ra*w+n*x+m*y)*0.0+(+g[e+48>>2]+(ra*G+n*I+m*j)));l=r*S+(u*U+v*V)+((w*o+x*q+y*l)*0.0+((z*o+A*q+B*l)*0.0+(C*o+D*q+E*l)*0.0)+(o*G+q*I+l*j+ +g[e+52>>2]));j=r*ea+(u*ia+v*pa)+((w*F+x*H+y*J)*0.0+((z*F+A*H+B*J)*0.0+(C*F+D*H+E*J)*0.0)+(F*G+H*I+J*j+ +g[e+56>>2]));g[qa+80>>2]=(X*ba+Y*ca+Z*da)*K+((fa*X+ga*Y+ha*Z)*L+(X*ja+Y*la+Z*na)*M);g[qa+80+4>>2]=(ba*_+ca*$+da*aa)*K+((fa*_+ga*$+ha*aa)*L+(ja*_+la*$+na*aa)*M);g[qa+80+8>>2]=(ba*ka+ca*ma+da*oa)*K+((fa*ka+ga*ma+ha*oa)*L+(ja*ka+la*ma+na*oa)*M);g[qa+80+12>>2]=0.0;g[qa+80+16>>2]=(X*ba+Y*ca+Z*da)*S+((fa*X+ga*Y+ha*Z)*U+(X*ja+Y*la+Z*na)*V);g[qa+80+20>>2]=(ba*_+ca*$+da*aa)*S+((fa*_+ga*$+ha*aa)*U+(ja*_+la*$+na*aa)*V);g[qa+80+24>>2]=(ba*ka+ca*ma+da*oa)*S+((fa*ka+ga*ma+ha*oa)*U+(ja*ka+la*ma+na*oa)*V);g[qa+80+28>>2]=0.0;g[qa+80+32>>2]=(X*ba+Y*ca+Z*da)*ea+((fa*X+ga*Y+ha*Z)*ia+(X*ja+Y*la+Z*na)*pa);g[qa+80+36>>2]=(ba*_+ca*$+da*aa)*ea+((fa*_+ga*$+ha*aa)*ia+(ja*_+la*$+na*aa)*pa);g[qa+80+40>>2]=(ba*ka+ca*ma+da*oa)*ea+((fa*ka+ga*ma+ha*oa)*ia+(ja*ka+la*ma+na*oa)*pa);g[qa+80+44>>2]=0.0;g[qa+80+48>>2]=m;g[qa+80+52>>2]=l;g[qa+80+56>>2]=j;g[qa+80+60>>2]=0.0;Wg(qa+80|0,qa+64|0);j=+g[qa+64>>2];l=+g[qa+64+4>>2];m=+g[qa+64+8>>2];if(!(+N(+(j*j+l*l+m*m))<1.1920928955078125e-07)?(g[b+472>>2]=0.0,wa=1.0/+O(+(j*j+l*l+m*m)),g[b+460>>2]=j*wa,g[b+464>>2]=l*wa,g[b+468>>2]=m*wa,wa=+g[qa+64+12>>2],wa=wa<-1.0?-1.0:wa,wa=+T(+(wa>1.0?1.0:wa))*2.0,g[b+504>>2]=wa,!(+N(+wa)<1.1920928955078125e-07)):0)a[b+526>>0]=1;i=qa;return}Wg(d,qa+48|0);Wg(b+300|0,qa+32|0);Z=+g[qa+48+12>>2];_=+g[qa+32>>2];$=+g[qa+48>>2];aa=+g[qa+32+12>>2];ba=+g[qa+48+4>>2];ca=+g[qa+32+8>>2];da=+g[qa+48+8>>2];ea=+g[qa+32+4>>2];Wg(e,qa+16|0);Wg(b+364|0,qa);fa=+g[qa+16+12>>2];ga=+g[qa>>2];ha=+g[qa+16>>2];ia=+g[qa+12>>2];ja=+g[qa+16+4>>2];ka=+g[qa+8>>2];la=+g[qa+16+8>>2];ma=+g[qa+4>>2];na=-(fa*ga+ha*ia+ja*ka-la*ma);oa=-(ga*la+(ia*ja+fa*ma)-ha*ka);pa=-(fa*ka+ia*la+ha*ma-ga*ja);o=(Z*aa-_*$-ba*ea-ca*da)*na+(Z*_+$*aa+ba*ca-da*ea)*(fa*ia-ga*ha-ja*ma-ka*la)+(Z*ca+aa*da+$*ea-_*ba)*oa-(_*da+(aa*ba+Z*ea)-$*ca)*pa;q=(Z*_+$*aa+ba*ca-da*ea)*pa+((_*da+(aa*ba+Z*ea)-$*ca)*(fa*ia-ga*ha-ja*ma-ka*la)+(Z*aa-_*$-ba*ea-ca*da)*oa)-(Z*ca+aa*da+$*ea-_*ba)*na;r=(_*da+(aa*ba+Z*ea)-$*ca)*na+((Z*ca+aa*da+$*ea-_*ba)*(fa*ia-ga*ha-ja*ma-ka*la)+(Z*aa-_*$-ba*ea-ca*da)*pa)-(Z*_+$*aa+ba*ca-da*ea)*oa;u=(Z*aa-_*$-ba*ea-ca*da)*(fa*ia-ga*ha-ja*ma-ka*la)-(Z*_+$*aa+ba*ca-da*ea)*na-(_*da+(aa*ba+Z*ea)-$*ca)*oa-(Z*ca+aa*da+$*ea-_*ba)*pa;m=-o-q*0.0-r*0.0;l=(r+u*0.0-o*0.0)*-r+(u*(u+q*0.0-r*0.0)+m*-o)-(u*0.0+o*0.0-q)*-q;j=(u*0.0+o*0.0-q)*-o+(u*(r+u*0.0-o*0.0)+m*-q)-(u+q*0.0-r*0.0)*-r;m=(u+q*0.0-r*0.0)*-q+(u*(u*0.0+o*0.0-q)+m*-r)-(r+u*0.0-o*0.0)*-o;n=1.0/+O(+(m*m+(l*l+j*j)));if(n*m*0.0+(n*j*0.0+n*l)<-.9999998807907104){p=-2147483648;s=0;t=0;j=1.0}else{wa=+O(+((n*m*0.0+(n*j*0.0+n*l)+1.0)*2.0));p=(g[k>>2]=(n*m*0.0-n*j*0.0)*(1.0/wa),c[k>>2]|0);s=(g[k>>2]=(n*j-n*l*0.0)*(1.0/wa),c[k>>2]|0);t=(g[k>>2]=wa*.5,c[k>>2]|0);j=(n*l*0.0-n*m)*(1.0/wa)}m=(c[k>>2]=p,+g[k>>2]);w=(c[k>>2]=s,+g[k>>2]);l=(c[k>>2]=t,+g[k>>2]);n=1.0/+O(+(m*m+j*j+w*w+l*l));v=j*n;V=r*-v+(o*l*n+u*-(m*n))-q*-(w*n);X=o*-(w*n)+(u*-v+q*l*n)-r*-(m*n);Y=q*-(m*n)+(r*l*n+u*-(w*n))-o*-v;S=u*l*n-o*-(m*n)-q*-v-r*-(w*n);U=1.0/+O(+(S*S+(Y*Y+(V*V+X*X))));u=+g[b+444>>2];j=+g[b+456>>2];p=(g[k>>2]=u,c[k>>2]|0);if(u>=j?(x=+g[b+448>>2],x>=j):0){r=l*n<-1.0?-1.0:l*n;r=+T(+(r>1.0?1.0:r))*2.0;if(r>1.1920928955078125e-07){j=1.0/+O(+(w*n*w*n+(m*n*m*n+v*v)));if(+N(+(v*j))>1.1920928955078125e-07){wa=+O(+((w*n*j*w*n*j/(v*j*v*j)+1.0)/(1.0/(x*x)+w*n*j*w*n*j/(v*j*v*j)/(u*u))));m=m*n*j;l=w*n*j;j=v*j;p=(g[k>>2]=wa,c[k>>2]|0)}else{m=m*n*j;l=w*n*j;j=v*j}}else{m=0.0;l=0.0;j=0.0;p=0}n=(c[k>>2]=p,+g[k>>2]);o=+g[b+428>>2];if(r>n*o){a[b+526>>0]=1;if(r<n&o<.9999998807907104)q=(r-n*o)/(n-n*o);else q=1.0;g[b+528>>2]=q;g[b+504>>2]=r-n*o;if(+N(+j)>1.1920928955078125e-07){wa=+N(+(j*-l/j*(x/u)));l=l<-0.0?wa:-wa;wa=1.0/+O(+(m*m+j*j+l*l));m=m*wa;l=-(l*wa);j=j*wa}va=-m;ua=-j;sa=-l;ra=(fa*ia-ga*ha-ja*ma-ka*la)*va+(ga*la+(ia*ja+fa*ma)-ha*ka)*sa-(fa*ka+ia*la+ha*ma-ga*ja)*ua;wa=(fa*ka+ia*la+ha*ma-ga*ja)*va+(fa*ia-ga*ha-ja*ma-ka*la)*ua-(fa*ga+ha*ia+ja*ka-la*ma)*sa;ta=(fa*ga+ha*ia+ja*ka-la*ma)*ua+(fa*ia-ga*ha-ja*ma-ka*la)*sa-(ga*la+(ia*ja+fa*ma)-ha*ka)*va;sa=-((fa*ga+ha*ia+ja*ka-la*ma)*va)-(ga*la+(ia*ja+fa*ma)-ha*ka)*ua-(fa*ka+ia*la+ha*ma-ga*ja)*sa;ua=wa*pa+(sa*na+(fa*ia-ga*ha-ja*ma-ka*la)*ra)-ta*oa;va=ta*na+((fa*ia-ga*ha-ja*ma-ka*la)*wa+sa*oa)-ra*pa;wa=ra*oa+(sa*pa+(fa*ia-ga*ha-ja*ma-ka*la)*ta)-wa*na;g[b+460>>2]=ua;g[b+464>>2]=va;g[b+468>>2]=wa;g[b+472>>2]=0.0;c[b+536>>2]=0;c[b+536+4>>2]=0;c[b+536+8>>2]=0;c[b+536+12>>2]=0;g[b+492>>2]=1.0/(ua*(+g[f>>2]*ua+ +g[f+16>>2]*va+ +g[f+32>>2]*wa)+va*(ua*+g[f+4>>2]+va*+g[f+20>>2]+wa*+g[f+36>>2])+wa*(ua*+g[f+8>>2]+va*+g[f+24>>2]+wa*+g[f+40>>2])+(ua*(ua*+g[h>>2]+va*+g[h+16>>2]+wa*+g[h+32>>2])+va*(ua*+g[h+4>>2]+va*+g[h+20>>2]+wa*+g[h+36>>2])+wa*(ua*+g[h+8>>2]+va*+g[h+24>>2]+wa*+g[h+40>>2])))}}else P=20;a:do if((P|0)==20){C=+g[b+300>>2];D=+g[b+316>>2];E=+g[b+332>>2];F=+g[d>>2];G=+g[d+4>>2];H=+g[d+8>>2];I=+g[d+16>>2];J=+g[d+20>>2];K=+g[d+24>>2];L=+g[d+32>>2];M=+g[d+36>>2];u=+g[d+40>>2];v=+g[b+304>>2];w=+g[b+320>>2];x=+g[b+336>>2];y=+g[b+308>>2];z=+g[b+324>>2];A=+g[b+340>>2];l=+g[b+364>>2];o=+g[b+380>>2];q=+g[b+396>>2];B=l*+g[e>>2]+o*+g[e+4>>2]+q*+g[e+8>>2];r=l*+g[e+16>>2]+o*+g[e+20>>2]+q*+g[e+24>>2];q=l*+g[e+32>>2]+o*+g[e+36>>2]+q*+g[e+40>>2];o=(C*F+D*G+E*H)*B+(C*I+D*J+E*K)*r+(C*L+D*M+E*u)*q;l=(F*v+G*w+H*x)*B+(I*v+J*w+K*x)*r+(L*v+M*w+u*x)*q;j=(F*y+G*z+H*A)*B+(I*y+J*z+K*A)*r+(L*y+M*z+u*A)*q;n=+g[b+444>>2];m=+g[b+456>>2];do if(n<m){n=+g[b+448>>2];if(n<m){if(+N(+l)<1.1920928955078125e-07?+N(+j)<1.1920928955078125e-07:0)break a;a[b+526>>0]=1;g[b+460>>2]=-((C*L+D*M+E*u)*r-(C*I+D*J+E*K)*q);g[b+464>>2]=-((C*F+D*G+E*H)*q-(C*L+D*M+E*u)*B);g[b+468>>2]=-((C*I+D*J+E*K)*B-(C*F+D*G+E*H)*r);g[b+472>>2]=0.0;break a}if(+N(+o)<1.1920928955078125e-07?+N(+j)<1.1920928955078125e-07:0){m=o;break}a[b+526>>0]=1;if(n>=m){l=+W(+j,+o);if(l>n){m=+Q(+n);l=0.0;j=+R(+n);break}if(l<-n){m=+Q(+n);l=0.0;j=-+R(+n)}else{m=o;l=0.0}}else m=o}else{if(+N(+o)<1.1920928955078125e-07?+N(+l)<1.1920928955078125e-07:0){m=o;break}a[b+526>>0]=1;if(n>=m){j=+W(+l,+o);if(j>n){m=+Q(+n);l=+R(+n);j=0.0;break}if(j<-n){m=+Q(+n);l=-+R(+n);j=0.0}else{m=o;j=0.0}}else m=o}while(0);va=(F*y+G*z+H*A)*j+((F*v+G*w+H*x)*l+(C*F+D*G+E*H)*m);ta=(I*y+J*z+K*A)*j+((I*v+J*w+K*x)*l+(C*I+D*J+E*K)*m);sa=(L*y+M*z+u*A)*j+((L*v+M*w+u*x)*l+(C*L+D*M+E*u)*m);ua=1.0/+O(+(sa*sa+(va*va+ta*ta)));g[b+472>>2]=0.0;wa=+O(+((r*ua*sa-q*ua*ta)*(r*ua*sa-q*ua*ta)+(q*ua*va-B*ua*sa)*(q*ua*va-B*ua*sa)+(B*ua*ta-r*ua*va)*(B*ua*ta-r*ua*va)));g[b+504>>2]=wa;g[b+460>>2]=-((r*ua*sa-q*ua*ta)*(1.0/wa));g[b+464>>2]=-((q*ua*va-B*ua*sa)*(1.0/wa));g[b+468>>2]=-((B*ua*ta-r*ua*va)*(1.0/wa))}while(0);r=+g[b+452>>2];if(!(r>=0.0)){g[b+512>>2]=0.0;i=qa;return}j=U*S<-1.0?-1.0:U*S;j=+T(+(j>1.0?1.0:j))*2.0;if(j>3.1415927410125732){q=-(U*S)<-1.0?-1.0:-(U*S);q=+T(+(q>1.0?1.0:q))*2.0;l=-(U*V);m=-(U*X);j=-(U*Y)}else{q=j;l=U*V;m=U*X;j=U*Y}g[b+512>>2]=q;if(q>1.1920928955078125e-07){wa=1.0/+O(+(l*l+m*m+j*j));o=l*wa;n=j*wa;m=m*wa}else{o=l;n=j}j=+g[b+428>>2];if(q>r*j){a[b+525>>0]=1;l=q-r*j;if(q<r&j<.9999998807907104)j=l/(r-r*j);else j=1.0;g[b+532>>2]=j;g[b+508>>2]=l;va=-o;ua=-m;sa=-n;ra=(fa*ia-ga*ha-ja*ma-ka*la)*va+(ga*la+(ia*ja+fa*ma)-ha*ka)*sa-(fa*ka+ia*la+ha*ma-ga*ja)*ua;wa=(fa*ka+ia*la+ha*ma-ga*ja)*va+(fa*ia-ga*ha-ja*ma-ka*la)*ua-(fa*ga+ha*ia+ja*ka-la*ma)*sa;ta=(fa*ga+ha*ia+ja*ka-la*ma)*ua+(fa*ia-ga*ha-ja*ma-ka*la)*sa-(ga*la+(ia*ja+fa*ma)-ha*ka)*va;sa=-((fa*ga+ha*ia+ja*ka-la*ma)*va)-(ga*la+(ia*ja+fa*ma)-ha*ka)*ua-(fa*ka+ia*la+ha*ma-ga*ja)*sa;ua=wa*pa+(sa*na+(fa*ia-ga*ha-ja*ma-ka*la)*ra)-ta*oa;va=ta*na+((fa*ia-ga*ha-ja*ma-ka*la)*wa+sa*oa)-ra*pa;wa=ra*oa+(sa*pa+(fa*ia-ga*ha-ja*ma-ka*la)*ta)-wa*na;g[b+476>>2]=ua;g[b+480>>2]=va;g[b+484>>2]=wa;g[b+488>>2]=0.0;g[b+496>>2]=1.0/(ua*(+g[f>>2]*ua+ +g[f+16>>2]*va+ +g[f+32>>2]*wa)+va*(ua*+g[f+4>>2]+va*+g[f+20>>2]+wa*+g[f+36>>2])+wa*(ua*+g[f+8>>2]+va*+g[f+24>>2]+wa*+g[f+40>>2])+(ua*(ua*+g[h>>2]+va*+g[h+16>>2]+wa*+g[h+32>>2])+va*(ua*+g[h+4>>2]+va*+g[h+20>>2]+wa*+g[h+36>>2])+wa*(ua*+g[h+8>>2]+va*+g[h+24>>2]+wa*+g[h+40>>2])))}if(!(a[b+526>>0]|0)){i=qa;return}ra=-o;wa=-m;sa=-n;pa=(Z*aa-_*$-ba*ea-ca*da)*ra+(_*da+(aa*ba+Z*ea)-$*ca)*sa-(Z*ca+aa*da+$*ea-_*ba)*wa;va=(Z*ca+aa*da+$*ea-_*ba)*ra+(Z*aa-_*$-ba*ea-ca*da)*wa-(Z*_+$*aa+ba*ca-da*ea)*sa;ua=(Z*_+$*aa+ba*ca-da*ea)*wa+(Z*aa-_*$-ba*ea-ca*da)*sa-(_*da+(aa*ba+Z*ea)-$*ca)*ra;sa=-((Z*_+$*aa+ba*ca-da*ea)*ra)-(_*da+(aa*ba+Z*ea)-$*ca)*wa-(Z*ca+aa*da+$*ea-_*ba)*sa;wa=-(Z*_+$*aa+ba*ca-da*ea);ra=-(_*da+(aa*ba+Z*ea)-$*ca);ta=-(Z*ca+aa*da+$*ea-_*ba);g[b+536>>2]=va*ta+(sa*wa+(Z*aa-_*$-ba*ea-ca*da)*pa)-ua*ra;g[b+540>>2]=ua*wa+((Z*aa-_*$-ba*ea-ca*da)*va+sa*ra)-pa*ta;g[b+544>>2]=pa*ra+(sa*ta+(Z*aa-_*$-ba*ea-ca*da)*ua)-va*wa;g[b+548>>2]=0.0;i=qa;return}function Gc(d,e){d=d|0;e=e|0;var f=0.0,h=0,j=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0,A=0,B=0.0,C=0.0,D=0,E=0,F=0.0,G=0.0,H=0,I=0.0,J=0,K=0,L=0,M=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0.0,X=0.0,Y=0.0,Z=0,$=0.0,aa=0.0,ba=0.0,ca=0,da=0,ea=0.0,fa=0,ga=0,ha=0.0,ia=0.0;ga=i;i=i+16|0;da=c[d+28>>2]|0;fa=c[d+32>>2]|0;$=+g[da+344>>2];aa=+g[fa+344>>2];Z=c[e+24>>2]|0;ea=a[d+180>>0]|0?1.0:-1.0;W=+g[d+936>>2]-+g[d+872>>2];X=+g[d+940>>2]-+g[d+876>>2];Y=+g[d+944>>2]-+g[d+880>>2];ba=$+aa>0.0?aa/($+aa):.5;H=c[d+824>>2]|0;J=c[d+840>>2]|0;K=c[d+856>>2]|0;L=c[d+888>>2]|0;M=c[d+904>>2]|0;P=c[d+920>>2]|0;Q=(a[d+49>>0]|0)==0;if(Q){y=c[d+828>>2]|0;l=c[d+844>>2]|0;t=c[d+860>>2]|0;c[ga+4>>2]=l;x=c[d+832>>2]|0;D=c[d+848>>2]|0;ca=c[d+864>>2]|0;c[ga>>2]=x;w=(c[k>>2]=t,+g[k>>2]);v=(c[k>>2]=x,+g[k>>2]);q=(c[k>>2]=D,+g[k>>2]);E=ca;u=(c[k>>2]=ca,+g[k>>2]);ca=H;z=J;A=K}else{f=ba*(c[k>>2]=H,+g[k>>2]);n=ba*(c[k>>2]=J,+g[k>>2]);m=ba*(c[k>>2]=K,+g[k>>2]);j=(1.0-ba)*(c[k>>2]=L,+g[k>>2]);o=(1.0-ba)*(c[k>>2]=M,+g[k>>2]);m=m+(1.0-ba)*(c[k>>2]=P,+g[k>>2]);p=1.0/+O(+((f+j)*(f+j)+(n+o)*(n+o)+m*m));y=(g[k>>2]=(f+j)*p,c[k>>2]|0);z=(g[k>>2]=(n+o)*p,c[k>>2]|0);A=(g[k>>2]=m*p,c[k>>2]|0);if(+N(+(m*p))>.7071067690849304){I=1.0/+O(+(m*p*m*p+(n+o)*p*(n+o)*p));g[ga+4>>2]=-(m*p*I);q=-((f+j)*p*(n+o)*p*I);r=(f+j)*p*-(m*p*I);j=(m*p*m*p+(n+o)*p*(n+o)*p)*I;f=(n+o)*p*I;h=0}else{r=(f+j)*p*(f+j)*p+(n+o)*p*(n+o)*p;I=1.0/+O(+r);h=(g[k>>2]=-((n+o)*p*I),c[k>>2]|0);g[ga+4>>2]=(f+j)*p*I;q=m*p*-((n+o)*p*I);r=r*I;j=-(m*p*(f+j)*p*I);f=0.0}t=(g[k>>2]=f,c[k>>2]|0);x=(g[k>>2]=j,c[k>>2]|0);g[ga>>2]=j;D=(g[k>>2]=q,c[k>>2]|0);l=c[ga+4>>2]|0;E=(g[k>>2]=r,c[k>>2]|0);w=f;v=j;u=r;ca=y;y=h}h=c[e+12>>2]|0;c[h>>2]=y;c[h+4>>2]=l;c[h+8>>2]=t;c[h+(Z<<2)>>2]=x;c[h+(Z+1<<2)>>2]=D;c[h+(Z+2<<2)>>2]=E;r=(c[k>>2]=y,+g[k>>2]);h=c[e+20>>2]|0;g[h>>2]=-r;s=+g[ga+4>>2];g[h+4>>2]=-s;g[h+8>>2]=-w;g[h+(Z<<2)>>2]=-v;g[h+(Z+1<<2)>>2]=-q;g[h+(Z+2<<2)>>2]=-u;h=c[d+300>>2]|0;f=+g[d+280>>2];if(!(h&128))f=f*+g[e+4>>2];o=f*+g[e>>2];G=(c[k>>2]=J,+g[k>>2]);B=(c[k>>2]=P,+g[k>>2]);p=(c[k>>2]=K,+g[k>>2]);F=(c[k>>2]=M,+g[k>>2]);I=(c[k>>2]=L,+g[k>>2]);C=(c[k>>2]=H,+g[k>>2]);V=c[e+28>>2]|0;g[V>>2]=o*((G*B-p*F)*r+(p*I-C*B)*s+(C*F-G*I)*w);g[V+(Z<<2)>>2]=o*((G*B-p*F)*v+(p*I-C*B)*q+(C*F-G*I)*u);if(h&64|0){V=c[e+32>>2]|0;c[V>>2]=c[d+292>>2];c[V+(Z<<2)>>2]=c[d+292>>2]}n=+g[da+52>>2];o=+g[da+56>>2];p=+g[da+60>>2];f=+g[fa+52>>2];j=+g[fa+56>>2];m=+g[fa+60>>2];if(Q){S=(g[k>>2]=j-o,c[k>>2]|0);G=(j-o)*w-(m-p)*s;I=(m-p)*r-(f-n)*w;Q=c[e+12>>2]|0;g[Q+(Z<<1<<2)>>2]=ba*G;g[Q+((Z<<1|1)<<2)>>2]=ba*I;g[Q+((Z<<1)+2<<2)>>2]=ba*((f-n)*s-(j-o)*r);Q=(g[k>>2]=f-n,c[k>>2]|0);R=(g[k>>2]=m-p,c[k>>2]|0);T=c[e+20>>2]|0;g[T+(Z<<1<<2)>>2]=(1.0-ba)*G;g[T+((Z<<1|1)<<2)>>2]=(1.0-ba)*I;g[T+((Z<<1)+2<<2)>>2]=(1.0-ba)*((f-n)*s-(j-o)*r);I=(j-o)*u-(m-p)*q;m=(m-p)*v-(f-n)*u;p=(f-n)*q-(j-o)*v;T=c[e+12>>2]|0;g[T+(Z*3<<2)>>2]=ba*I;g[T+((Z*3|0)+1<<2)>>2]=ba*m;g[T+((Z*3|0)+2<<2)>>2]=ba*p;T=c[e+20>>2]|0;g[T+(Z*3<<2)>>2]=(1.0-ba)*I;g[T+((Z*3|0)+1<<2)>>2]=(1.0-ba)*m;g[T+((Z*3|0)+2<<2)>>2]=(1.0-ba)*p;J=c[e+8>>2]|0;c[J+(Z<<1<<2)>>2]=y;g[J+((Z<<1|1)<<2)>>2]=s;g[J+((Z<<1)+2<<2)>>2]=w;J=c[e+8>>2]|0;M=c[ga>>2]|0;c[J+(Z*3<<2)>>2]=M;c[J+((Z*3|0)+1<<2)>>2]=D;c[J+((Z*3|0)+2<<2)>>2]=E;P=c[e+16>>2]|0;g[P+(Z<<1<<2)>>2]=-r;p=+g[ga+4>>2];g[P+((Z<<1|1)<<2)>>2]=-p;g[P+((Z<<1)+2<<2)>>2]=-w;P=c[e+16>>2]|0;n=(c[k>>2]=M,+g[k>>2]);g[P+(Z*3<<2)>>2]=-n;m=(c[k>>2]=D,+g[k>>2]);g[P+((Z*3|0)+1<<2)>>2]=-m;j=(c[k>>2]=E,+g[k>>2]);g[P+((Z*3|0)+2<<2)>>2]=-j;o=w;M=0;L=0;K=0;t=0;l=0;h=0}else{ia=+g[d+936>>2]-f;ha=+g[d+940>>2]-j;F=+g[d+944>>2]-m;r=(c[k>>2]=ca,+g[k>>2]);s=(c[k>>2]=z,+g[k>>2]);q=(c[k>>2]=A,+g[k>>2]);G=+g[d+872>>2]-n;I=+g[d+876>>2]-o;m=+g[d+880>>2]-p;o=+g[d+1080>>2]-+g[d+1032>>2];u=r*(r*G+s*I+q*m)+r*o-r*(r*ia+s*ha+q*F);v=s*(r*G+s*I+q*m)+s*o-s*(r*ia+s*ha+q*F);o=q*(r*G+s*I+q*m)+q*o-q*(r*ia+s*ha+q*F);B=G-r*(r*G+s*I+q*m)+ba*u;w=I-s*(r*G+s*I+q*m)+ba*v;C=m-q*(r*G+s*I+q*m)+ba*o;M=(g[k>>2]=B,c[k>>2]|0);L=(g[k>>2]=w,c[k>>2]|0);K=(g[k>>2]=C,c[k>>2]|0);u=ia-r*(r*ia+s*ha+q*F)-(1.0-ba)*u;v=ha-s*(r*ia+s*ha+q*F)-(1.0-ba)*v;o=F-q*(r*ia+s*ha+q*F)-(1.0-ba)*o;t=(g[k>>2]=u,c[k>>2]|0);x=(g[k>>2]=v,c[k>>2]|0);y=(g[k>>2]=o,c[k>>2]|0);j=ba*(ia-r*(r*ia+s*ha+q*F))+(1.0-ba)*(G-r*(r*G+s*I+q*m));f=ba*(ha-s*(r*ia+s*ha+q*F))+(1.0-ba)*(I-s*(r*G+s*I+q*m));m=ba*(F-q*(r*ia+s*ha+q*F))+(1.0-ba)*(m-q*(r*G+s*I+q*m));g[ga+4>>2]=f;if(m*m+(j*j+f*f)>1.1920928955078125e-07){ia=1.0/+O(+(m*m+(j*j+f*f)));l=(g[k>>2]=j*ia,c[k>>2]|0);g[ga+4>>2]=ia*f;I=ia*m;n=ia*f;f=j*ia;h=(g[k>>2]=ia*m,c[k>>2]|0)}else{l=c[d+828>>2]|0;V=c[d+844>>2]|0;h=c[d+860>>2]|0;c[ga+4>>2]=V;I=(c[k>>2]=h,+g[k>>2]);n=(c[k>>2]=V,+g[k>>2]);f=(c[k>>2]=l,+g[k>>2])}F=s*I-q*n;G=q*f-r*I;q=r*n-s*f;g[ga>>2]=F;V=(c[e+12>>2]|0)+(Z<<1<<2)|0;g[V>>2]=w*I-C*n;g[V+4>>2]=C*f-B*I;g[V+8>>2]=B*n-w*f;V=c[e+20>>2]|0;g[V+(Z<<1<<2)>>2]=-(v*I-o*n);g[V+((Z<<1|1)<<2)>>2]=-(o*f-u*I);g[V+((Z<<1)+2<<2)>>2]=-(u*n-v*f);if($<1.1920928955078125e-07|aa<1.1920928955078125e-07?(a[d+297>>0]|0)!=0:0){p=(1.0-ba)*(v*q-o*G);o=(1.0-ba)*(o*F-u*q);m=(1.0-ba)*(u*G-v*F);n=ba*(w*q-C*G);j=ba*(B*G-w*F);f=ba*(C*F-B*q)}else{p=v*q-o*G;o=o*F-u*q;m=u*G-v*F;n=w*q-C*G;j=B*G-w*F;f=C*F-B*q}T=(c[e+12>>2]|0)+(Z*3<<2)|0;g[T>>2]=n;g[T+4>>2]=f;g[T+8>>2]=j;T=c[e+20>>2]|0;g[T+(Z*3<<2)>>2]=-p;g[T+((Z*3|0)+1<<2)>>2]=-o;g[T+((Z*3|0)+2<<2)>>2]=-m;J=c[e+8>>2]|0;c[J+(Z<<1<<2)>>2]=l;c[J+((Z<<1|1)<<2)>>2]=c[ga+4>>2];c[J+((Z<<1)+2<<2)>>2]=h;J=c[e+8>>2]|0;g[J+(Z*3<<2)>>2]=F;g[J+((Z*3|0)+1<<2)>>2]=G;g[J+((Z*3|0)+2<<2)>>2]=q;P=c[e+16>>2]|0;r=(c[k>>2]=l,+g[k>>2]);g[P+(Z<<1<<2)>>2]=-r;p=+g[ga+4>>2];g[P+((Z<<1|1)<<2)>>2]=-p;g[P+((Z<<1)+2<<2)>>2]=-I;P=c[e+16>>2]|0;g[P+(Z*3<<2)>>2]=-F;g[P+((Z*3|0)+1<<2)>>2]=-G;g[P+((Z*3|0)+2<<2)>>2]=-q;o=I;n=F;m=G;j=q;Q=0;R=0;S=0;l=x;h=y}U=c[d+300>>2]|0;f=+g[d+264>>2];if(!(U&32))f=f*+g[e+4>>2];ia=f*+g[e>>2];V=c[e+28>>2]|0;g[V+(Z<<1<<2)>>2]=ia*(W*r+X*p+Y*o);g[V+(Z*3<<2)>>2]=ia*(W*n+X*m+Y*j);if(U&16|0){H=c[e+32>>2]|0;c[H+(Z<<1<<2)>>2]=c[d+276>>2];c[H+(Z*3<<2)>>2]=c[d+276>>2]}H=b[d+296>>1]|0;if(!((H&255)<<24>>24)){E=0;u=0.0}else{u=ea*+g[d+1032>>2];E=u>0.0?2:1}x=a[d+1096>>0]|0;y=(E|0)!=0;if(x&255|E){D=c[e+24>>2]<<2;c[J+(D<<2)>>2]=ca;c[J+((D|1)<<2)>>2]=z;c[J+((D|2)<<2)>>2]=A;q=(c[k>>2]=ca,+g[k>>2]);g[P+(D<<2)>>2]=-q;r=(c[k>>2]=z,+g[k>>2]);g[P+((D|1)<<2)>>2]=-r;s=(c[k>>2]=A,+g[k>>2]);g[P+((D|2)<<2)>>2]=-s;if(a[d+49>>0]|0){if(!($<1.1920928955078125e-07|aa<1.1920928955078125e-07)){aa=(c[k>>2]=L,+g[k>>2]);Y=(c[k>>2]=K,+g[k>>2]);$=(c[k>>2]=M,+g[k>>2]);ia=(c[k>>2]=l,+g[k>>2]);ba=(c[k>>2]=h,+g[k>>2]);ha=(c[k>>2]=t,+g[k>>2]);Z=c[e+12>>2]|0;g[Z+(D<<2)>>2]=s*aa-r*Y;g[Z+((D|1)<<2)>>2]=q*Y-s*$;g[Z+((D|2)<<2)>>2]=r*$-q*aa;g[T+(D<<2)>>2]=-(s*ia-r*ba);g[T+((D|1)<<2)>>2]=-(q*ba-s*ha);g[T+((D|2)<<2)>>2]=-(r*ha-q*ia)}}else{ia=(c[k>>2]=S,+g[k>>2]);aa=(c[k>>2]=R,+g[k>>2]);ha=(c[k>>2]=Q,+g[k>>2]);Z=c[e+12>>2]|0;g[Z+(D<<2)>>2]=ba*(s*ia-r*aa);g[Z+((D|1)<<2)>>2]=ba*(q*aa-s*ha);g[Z+((D|2)<<2)>>2]=ba*(r*ha-q*ia);g[T+(D<<2)>>2]=(1.0-ba)*(s*ia-r*aa);g[T+((D|1)<<2)>>2]=(1.0-ba)*(q*aa-s*ha);g[T+((D|2)<<2)>>2]=(1.0-ba)*(r*ha-q*ia)}h=+g[d+184>>2]==+g[d+188>>2];g[V+(D<<2)>>2]=0.0;l=(c[e+36>>2]|0)+(D<<2)|0;g[l>>2]=0.0;t=(c[e+40>>2]|0)+(D<<2)|0;g[t>>2]=0.0;p=+g[((U&512|0)==0?e+4|0:d+232|0)>>2];if(!(x<<24>>24==0|y&h)){if(U&1|0)c[(c[e+32>>2]|0)+(D<<2)>>2]=c[d+212>>2];o=+g[d+1100>>2];f=+g[d+1080>>2];j=+g[d+184>>2];m=+g[d+188>>2];n=p*+g[e>>2];do if(!(j>m))if(!(j==m)){if(o/n<0.0)if(f>=j?j-o/n>f:0){f=(j-f)/(o/n);break}else{f=f<j?0.0:1.0;break}if(o/n>0.0)if(f<=m?m-o/n<f:0){f=(m-f)/(o/n);break}else{f=f>m?0.0:1.0;break}else f=0.0}else f=0.0;else f=1.0;while(0);g[V+(D<<2)>>2]=+g[V+(D<<2)>>2]-ea*f*o;g[l>>2]=+g[l>>2]-+g[d+1104>>2]*+g[e>>2];g[t>>2]=+g[d+1104>>2]*+g[e>>2]+ +g[t>>2]}if(y){g[V+(D<<2)>>2]=+g[V+(D<<2)>>2]+u*p*+g[e>>2];if(U&256|0)c[(c[e+32>>2]|0)+(D<<2)>>2]=c[d+244>>2];do if(!h)if((E|0)==1){g[l>>2]=-3402823466385288598117041.0e14;g[t>>2]=0.0;break}else{g[l>>2]=0.0;g[t>>2]=3402823466385288598117041.0e14;break}else{g[l>>2]=-3402823466385288598117041.0e14;g[t>>2]=3402823466385288598117041.0e14}while(0);ia=1.0-+g[d+240>>2];j=+N(+ia);do if(!(ia!=ia|0.0!=0.0|ia==0.0)){f=ea*(q*+g[da+312>>2]+r*+g[da+316>>2]+s*+g[da+320>>2]-(q*+g[fa+312>>2]+r*+g[fa+316>>2]+s*+g[fa+320>>2]));if((E|0)==1){if(!(f<0.0))break;if(!(+g[V+(D<<2)>>2]<-(j*f)))break;g[V+(D<<2)>>2]=-(j*f);break}else{if(!(f>0.0))break;if(!(+g[V+(D<<2)>>2]>-(j*f)))break;g[V+(D<<2)>>2]=-(j*f);break}}while(0);g[V+(D<<2)>>2]=+g[d+232>>2]*+g[V+(D<<2)>>2];h=5}else h=5}else h=4;if((H&65535)<256){y=0;v=0.0}else{v=+g[d+1088>>2];y=v>0.0?1:2}l=a[d+1112>>0]|0;t=(y|0)!=0;if(!(l&255|y)){i=ga;return}x=_(c[e+24>>2]|0,h)|0;fa=c[e+12>>2]|0;c[fa+(x<<2)>>2]=ca;c[fa+(x+1<<2)>>2]=z;c[fa+(x+2<<2)>>2]=A;w=(c[k>>2]=ca,+g[k>>2]);g[T+(x<<2)>>2]=-w;u=(c[k>>2]=z,+g[k>>2]);g[T+(x+1<<2)>>2]=-u;s=(c[k>>2]=A,+g[k>>2]);g[T+(x+2<<2)>>2]=-s;p=+g[d+192>>2];q=+g[d+196>>2];r=+g[((U&2048|0)==0?e+4|0:d+248|0)>>2];if(!(l<<24>>24==0|t&p==q)){if(!(U&4)){m=q;n=p}else{c[(c[e+32>>2]|0)+(x<<2)>>2]=c[d+228>>2];m=+g[d+196>>2];n=+g[d+192>>2]}f=+g[d+1084>>2];o=+g[d+1116>>2];j=r*+g[e>>2];do if(!(n>m))if(!(n==m)){if(o/j<0.0)if(f>=n?n-o/j>f:0){f=(n-f)/(o/j);break}else{f=f<n?0.0:1.0;break}if(o/j>0.0)if(f<=m?m-o/j<f:0){f=(m-f)/(o/j);break}else{f=f>m?0.0:1.0;break}else f=0.0}else f=0.0;else f=1.0;while(0);g[V+(x<<2)>>2]=f*o;g[(c[e+36>>2]|0)+(x<<2)>>2]=-(+g[d+1120>>2]*+g[e>>2]);g[(c[e+40>>2]|0)+(x<<2)>>2]=+g[d+1120>>2]*+g[e>>2]}if(!t){i=ga;return}g[V+(x<<2)>>2]=+g[V+(x<<2)>>2]+v*r*+g[e>>2];if(U&1024|0)c[(c[e+32>>2]|0)+(x<<2)>>2]=c[d+260>>2];do if(!(p==q)){l=(c[e+36>>2]|0)+(x<<2)|0;h=c[e+40>>2]|0;if((y|0)==1){g[l>>2]=0.0;g[h+(x<<2)>>2]=3402823466385288598117041.0e14;break}else{g[l>>2]=-3402823466385288598117041.0e14;g[h+(x<<2)>>2]=0.0;break}}else{g[(c[e+36>>2]|0)+(x<<2)>>2]=-3402823466385288598117041.0e14;g[(c[e+40>>2]|0)+(x<<2)>>2]=3402823466385288598117041.0e14}while(0);ia=1.0-+g[d+256>>2];j=+N(+ia);do if(!(ia!=ia|0.0!=0.0|ia==0.0)){fa=c[d+28>>2]|0;e=c[d+32>>2]|0;f=w*+g[fa+328>>2]+u*+g[fa+332>>2]+s*+g[fa+336>>2]-(w*+g[e+328>>2]+u*+g[e+332>>2]+s*+g[e+336>>2]);if((y|0)==1){if(!(f<0.0))break;if(!(+g[V+(x<<2)>>2]<-(j*f)))break;g[V+(x<<2)>>2]=-(j*f);break}else{if(!(f>0.0))break;if(!(+g[V+(x<<2)>>2]>-(j*f)))break;g[V+(x<<2)>>2]=-(j*f);break}}while(0);g[V+(x<<2)>>2]=+g[d+248>>2]*+g[V+(x<<2)>>2];i=ga;return}function Hc(d,e){d=d|0;e=e|0;var f=0.0,h=0.0,i=0,j=0,k=0.0,l=0.0,m=0.0,n=0,o=0.0,p=0,q=0,r=0.0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ba=0.0,ca=0.0,da=0.0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0,qa=0;pa=c[d+28>>2]|0;qa=c[d+32>>2]|0;q=c[e+24>>2]|0;if(!(a[d+739>>0]|0)){z=+g[d+552>>2];S=+g[pa+4>>2];A=+g[d+568>>2];T=+g[pa+8>>2];B=+g[d+584>>2];U=+g[pa+12>>2];C=+g[d+556>>2];D=+g[d+572>>2];E=+g[d+588>>2];V=+g[d+560>>2];W=+g[d+576>>2];X=+g[d+592>>2];Y=+g[pa+20>>2];Z=+g[pa+24>>2];_=+g[pa+28>>2];$=+g[pa+36>>2];aa=+g[pa+40>>2];ba=+g[pa+44>>2];l=+g[d+600>>2];m=+g[d+604>>2];o=+g[d+608>>2];r=+g[pa+52>>2];u=+g[pa+56>>2];v=+g[pa+60>>2];F=+g[qa+4>>2];G=+g[qa+8>>2];H=+g[qa+12>>2];I=+g[d+624>>2];J=+g[d+640>>2];K=+g[d+656>>2];L=+g[qa+20>>2];M=+g[qa+24>>2];N=+g[qa+28>>2];P=+g[qa+36>>2];Q=+g[qa+40>>2];R=+g[qa+44>>2];na=+g[d+664>>2];oa=+g[d+668>>2];y=+g[d+672>>2];w=+g[qa+52>>2]+(F*na+G*oa+H*y);x=L*na+M*oa+N*y+ +g[qa+56>>2];y=P*na+Q*oa+R*y+ +g[qa+60>>2];t=b[d+736>>1]|0;if(!((t&255)<<24>>24)){i=c[e+8>>2]|0;g[i>>2]=1.0;g[i+(q+1<<2)>>2]=1.0;g[i+((q<<1)+2<<2)>>2]=1.0;i=c[e+16>>2]|0;g[i>>2]=-1.0;g[i+(q+1<<2)>>2]=-1.0;g[i+((q<<1)+2<<2)>>2]=-1.0;i=q<<1;f=+g[pa+52>>2];h=+g[pa+56>>2];k=+g[pa+60>>2]}else{i=q<<1;f=r;h=u;k=v}f=r+(S*l+T*m+U*o)-f;oa=Y*l+Z*m+_*o+u-h;na=$*l+aa*m+ba*o+v-k;j=c[e+12>>2]|0;n=j+(i<<2)|0;c[j>>2]=0;g[j+4>>2]=na;g[j+8>>2]=-oa;g[j+12>>2]=0.0;g[j+(q<<2)>>2]=-na;c[j+(q<<2)+4>>2]=0;g[j+(q<<2)+8>>2]=f;g[j+(q<<2)+12>>2]=0.0;g[n>>2]=oa;g[n+4>>2]=-f;c[n+8>>2]=0;g[n+12>>2]=0.0;f=w-+g[qa+52>>2];oa=x-+g[qa+56>>2];na=y-+g[qa+60>>2];n=c[e+20>>2]|0;i=n+(i<<2)|0;c[n>>2]=0;g[n+4>>2]=-na;g[n+8>>2]=oa;g[n+12>>2]=0.0;g[n+(q<<2)>>2]=na;c[n+(q<<2)+4>>2]=0;g[n+(q<<2)+8>>2]=-f;g[n+(q<<2)+12>>2]=0.0;g[i>>2]=-oa;g[i+4>>2]=f;c[i+8>>2]=0;g[i+12>>2]=0.0;f=+g[e>>2]*+g[e+4>>2];i=c[e+28>>2]|0;if(!((t&255)<<24>>24)){g[i>>2]=f*(w-(r+(S*l+T*m+U*o)));g[i+(q<<2)>>2]=f*(x-(Y*l+Z*m+_*o+u));g[i+(q<<1<<2)>>2]=f*(y-($*l+aa*m+ba*o+v))}s=c[e+24>>2]|0;g[j+(s*3<<2)>>2]=z*S+A*T+B*U;g[j+((s*3|0)+1<<2)>>2]=z*Y+A*Z+B*_;g[j+((s*3|0)+2<<2)>>2]=z*$+A*aa+B*ba;g[j+(s<<2<<2)>>2]=S*C+T*D+U*E;g[j+((s<<2|1)<<2)>>2]=C*Y+D*Z+E*_;g[j+((s<<2|2)<<2)>>2]=C*$+D*aa+E*ba;g[n+(s*3<<2)>>2]=-(z*S+A*T+B*U);g[n+((s*3|0)+1<<2)>>2]=-(z*Y+A*Z+B*_);g[n+((s*3|0)+2<<2)>>2]=-(z*$+A*aa+B*ba);g[n+(s<<2<<2)>>2]=-(S*C+T*D+U*E);g[n+((s<<2|1)<<2)>>2]=-(C*Y+D*Z+E*_);g[n+((s<<2|2)<<2)>>2]=-(C*$+D*aa+E*ba);na=(V*Y+W*Z+X*_)*(I*P+J*Q+K*R)-(V*$+W*aa+X*ba)*(I*L+J*M+K*N);oa=(V*$+W*aa+X*ba)*(F*I+G*J+H*K)-(S*V+T*W+U*X)*(I*P+J*Q+K*R);ma=(S*V+T*W+U*X)*(I*L+J*M+K*N)-(V*Y+W*Z+X*_)*(F*I+G*J+H*K);g[i+(s*3<<2)>>2]=((z*$+A*aa+B*ba)*ma+((z*S+A*T+B*U)*na+(z*Y+A*Z+B*_)*oa))*f;g[i+(s<<2<<2)>>2]=((C*$+D*aa+E*ba)*ma+((S*C+T*D+U*E)*na+(C*Y+D*Z+E*_)*oa))*f;if(!(a[d+716>>0]|0)){q=0;r=0.0}else{r=+g[d+708>>2]*+g[d+732>>2];q=r>0.0?1:2}p=(q|0)!=0;if(!((t&65535)>>>8&65535|q))return;g[j+(s*5<<2)>>2]=S*V+T*W+U*X;g[j+((s*5|0)+1<<2)>>2]=V*Y+W*Z+X*_;g[j+((s*5|0)+2<<2)>>2]=V*$+W*aa+X*ba;g[n+(s*5<<2)>>2]=-(S*V+T*W+U*X);g[n+((s*5|0)+1<<2)>>2]=-(V*Y+W*Z+X*_);g[n+((s*5|0)+2<<2)>>2]=-(V*$+W*aa+X*ba);h=+g[d+688>>2];k=+g[d+692>>2];f=+eh(h-k,6.2831854820251465);if(!(f<-3.1415927410125732))if(f>3.1415927410125732)o=f+-6.2831854820251465;else o=f;else o=f+6.2831854820251465;f=+eh(h+k,6.2831854820251465);if(!(f<-3.1415927410125732)){if(f>3.1415927410125732)f=f+-6.2831854820251465}else f=f+6.2831854820251465;j=o==f;n=i+(s*5<<2)|0;g[n>>2]=0.0;i=c[d+748>>2]|0;m=+g[((i&2|0)==0?e+4|0:d+760|0)>>2];if(!((t&65535)>>>8<<16>>16==0|p&j)){if(i&4|0)c[(c[e+32>>2]|0)+(s*5<<2)>>2]=c[d+752>>2];k=+g[d+728>>2];l=+g[d+680>>2];h=o>f?1.0:0.0;do if(!(o>=f)){h=l/(m*+g[e>>2]);if(h<0.0)if(k>=o&o-h>k){f=(o-k)/h;break}else{f=k<o?0.0:1.0;break}if(h>0.0)if(k<=f&f-h<k){f=(f-k)/h;break}else{f=k>f?0.0:1.0;break}else f=0.0}else f=h;while(0);g[n>>2]=f*l*+g[d+732>>2]+ +g[n>>2];g[(c[e+36>>2]|0)+(s*5<<2)>>2]=-+g[d+684>>2];c[(c[e+40>>2]|0)+(s*5<<2)>>2]=c[d+684>>2]}if(!p)return;g[n>>2]=+g[n>>2]+r*m*+g[e>>2];if(i&1|0)c[(c[e+32>>2]|0)+(s*5<<2)>>2]=c[d+756>>2];do if(!j){j=(c[e+36>>2]|0)+(s*5<<2)|0;i=c[e+40>>2]|0;if((q|0)==1){g[j>>2]=0.0;g[i+(s*5<<2)>>2]=3402823466385288598117041.0e14;break}else{g[j>>2]=-3402823466385288598117041.0e14;g[i+(s*5<<2)>>2]=0.0;break}}else{g[(c[e+36>>2]|0)+(s*5<<2)>>2]=-3402823466385288598117041.0e14;g[(c[e+40>>2]|0)+(s*5<<2)>>2]=3402823466385288598117041.0e14}while(0);h=+g[d+704>>2];do if(h>0.0){f=(S*V+T*W+U*X)*+g[pa+328>>2]+(V*Y+W*Z+X*_)*+g[pa+332>>2]+(V*$+W*aa+X*ba)*+g[pa+336>>2]-((S*V+T*W+U*X)*+g[qa+328>>2]+(V*Y+W*Z+X*_)*+g[qa+332>>2]+(V*$+W*aa+X*ba)*+g[qa+336>>2]);if((q|0)==1){if(!(f<0.0))break;if(!(+g[n>>2]<-(h*f)))break;g[n>>2]=-(h*f);break}else{if(!(f>0.0))break;if(!(+g[n>>2]>-(h*f)))break;g[n>>2]=-(h*f);break}}while(0);g[n>>2]=+g[d+700>>2]*+g[n>>2];return}W=+g[pa+4>>2];X=+g[pa+8>>2];Y=+g[pa+12>>2];u=+g[d+556>>2];x=+g[d+572>>2];z=+g[d+588>>2];Z=+g[d+560>>2];_=+g[d+576>>2];$=+g[d+592>>2];aa=+g[pa+20>>2];ba=+g[pa+24>>2];ca=+g[pa+28>>2];da=+g[pa+36>>2];ea=+g[pa+40>>2];fa=+g[pa+44>>2];ha=+g[d+600>>2];ga=+g[d+604>>2];o=+g[d+608>>2];h=+g[pa+52>>2]+(W*ha+X*ga+Y*o);w=aa*ha+ba*ga+ca*o+ +g[pa+56>>2];o=da*ha+ea*ga+fa*o+ +g[pa+60>>2];ga=+g[qa+4>>2];ha=+g[qa+8>>2];ia=+g[qa+12>>2];ja=+g[d+624>>2];ka=+g[d+640>>2];P=+g[d+656>>2];Q=+g[qa+20>>2];R=+g[qa+24>>2];S=+g[qa+28>>2];T=+g[qa+36>>2];U=+g[qa+40>>2];V=+g[qa+44>>2];r=+g[d+664>>2];y=+g[d+668>>2];k=+g[d+672>>2];f=+g[qa+52>>2];v=+g[qa+56>>2];m=+g[qa+60>>2];J=f+(ga*r+ha*y+ia*k)-h;K=Q*r+R*y+S*k+v-w;L=T*r+U*y+V*k+m-o;A=+g[(c[d+28>>2]|0)+344>>2];B=+g[(c[d+32>>2]|0)+344>>2];I=A+B>0.0?B/(A+B):.5;la=(W*Z+X*_+Y*$)*I+(ga*ja+ha*ka+ia*P)*(1.0-I);ma=(Z*aa+_*ba+$*ca)*I+(ja*Q+ka*R+P*S)*(1.0-I);na=(Z*da+_*ea+$*fa)*I+(ja*T+ka*U+P*V)*(1.0-I);oa=1.0/+O(+(la*la+ma*ma+na*na));C=(f+(ga*r+ha*y+ia*k)-f)*la*oa+(Q*r+R*y+S*k+v-v)*ma*oa+(T*r+U*y+V*k+m-m)*na*oa;f=f+(ga*r+ha*y+ia*k)-f-la*oa*C;v=Q*r+R*y+S*k+v-v-ma*oa*C;m=T*r+U*y+V*k+m-m-na*oa*C;h=h-+g[pa+52>>2];w=w-+g[pa+56>>2];o=o-+g[pa+60>>2];k=la*oa*(h*la*oa+w*ma*oa+o*na*oa);y=ma*oa*(h*la*oa+w*ma*oa+o*na*oa);r=na*oa*(h*la*oa+w*ma*oa+o*na*oa);G=h-k+I*(k-la*oa*C);H=w-y+I*(y-ma*oa*C);F=o-r+I*(r-na*oa*C);D=f-(1.0-I)*(k-la*oa*C);E=v-(1.0-I)*(y-ma*oa*C);C=m-(1.0-I)*(r-na*oa*C);l=(I*f+(1.0-I)*(h-k))*(I*f+(1.0-I)*(h-k))+(I*v+(1.0-I)*(w-y))*(I*v+(1.0-I)*(w-y))+(I*m+(1.0-I)*(o-r))*(I*m+(1.0-I)*(o-r));if(l>1.1920928955078125e-07){z=1.0/+O(+l);N=(I*f+(1.0-I)*(h-k))*z;M=z*(I*m+(1.0-I)*(o-r));w=z*(I*v+(1.0-I)*(w-y))}else{N=W*u+X*x+Y*z;M=u*da+x*ea+z*fa;w=u*aa+x*ba+z*ca}r=ma*oa*M-na*oa*w;u=na*oa*N-M*la*oa;v=w*la*oa-ma*oa*N;t=c[e+12>>2]|0;g[t>>2]=H*M-F*w;g[t+4>>2]=F*N-G*M;g[t+8>>2]=G*w-H*N;t=c[e+20>>2]|0;g[t>>2]=-(E*M-C*w);g[t+4>>2]=-(C*N-D*M);g[t+8>>2]=-(D*w-E*N);if(A<1.1920928955078125e-07|B<1.1920928955078125e-07?(a[d+716>>0]|0)!=0:0){f=(1.0-I)*(E*v-C*u);h=(1.0-I)*(C*r-D*v);k=(1.0-I)*(D*u-E*r);l=I*(H*v-F*u);m=I*(F*r-G*v);o=I*(G*u-H*r)}else{f=E*v-C*u;h=C*r-D*v;k=D*u-E*r;l=H*v-F*u;m=F*r-G*v;o=G*u-H*r}t=(c[e+12>>2]|0)+(q<<2)|0;g[t>>2]=l;g[t+4>>2]=m;g[t+8>>2]=o;t=c[e+20>>2]|0;g[t+(q<<2)>>2]=-f;g[t+(q+1<<2)>>2]=-h;g[t+(q+2<<2)>>2]=-k;if(A<1.1920928955078125e-07|B<1.1920928955078125e-07){o=(1.0-I)*(E*na*oa-C*ma*oa);m=(1.0-I)*(C*la*oa-D*na*oa);l=(1.0-I)*(D*ma*oa-E*la*oa);k=I*(H*na*oa-F*ma*oa);h=I*(F*la*oa-G*na*oa);f=I*(G*ma*oa-H*la*oa)}else{o=E*na*oa-C*ma*oa;m=C*la*oa-D*na*oa;l=D*ma*oa-E*la*oa;k=H*na*oa-F*ma*oa;h=F*la*oa-G*na*oa;f=G*ma*oa-H*la*oa}i=(c[e+12>>2]|0)+(q<<1<<2)|0;g[i>>2]=k;g[i+4>>2]=h;g[i+8>>2]=f;i=c[e+20>>2]|0;g[i+(q<<1<<2)>>2]=-o;g[i+((q<<1|1)<<2)>>2]=-m;g[i+((q<<1)+2<<2)>>2]=-l;f=+g[e>>2]*+g[e+4>>2];if(!(a[d+736>>0]|0)){p=c[e+8>>2]|0;g[p>>2]=N;g[p+4>>2]=w;g[p+8>>2]=M;p=(c[e+8>>2]|0)+(q<<2)|0;g[p>>2]=r;g[p+4>>2]=u;g[p+8>>2]=v;p=(c[e+8>>2]|0)+(q<<1<<2)|0;g[p>>2]=la*oa;g[p+4>>2]=ma*oa;g[p+8>>2]=na*oa;p=c[e+16>>2]|0;h=-N;g[p>>2]=h;g[p+4>>2]=-w;g[p+8>>2]=-M;p=c[e+16>>2]|0;g[p+(q<<2)>>2]=-r;g[p+(q+1<<2)>>2]=-u;g[p+(q+2<<2)>>2]=-v;p=c[e+16>>2]|0;g[p+(q<<1<<2)>>2]=-(la*oa);g[p+((q<<1|1)<<2)>>2]=-(ma*oa);g[p+((q<<1)+2<<2)>>2]=-(na*oa);p=c[e+28>>2]|0;g[p>>2]=f*(J*N+K*w+L*M);g[p+(q<<2)>>2]=f*(J*r+K*u+L*v);g[p+(q<<1<<2)>>2]=f*(J*la*oa+K*ma*oa+L*na*oa);f=h;h=-r;k=-u;l=-v;i=c[e+20>>2]|0}else{f=-N;h=-r;k=-u;l=-v;p=c[e+28>>2]|0}j=c[e+12>>2]|0;g[j+(q*3<<2)>>2]=N;g[j+((q*3|0)+1<<2)>>2]=w;g[j+((q*3|0)+2<<2)>>2]=M;g[j+(q<<2<<2)>>2]=r;g[j+((q<<2|1)<<2)>>2]=u;g[j+((q<<2|2)<<2)>>2]=v;g[i+(q*3<<2)>>2]=f;g[i+((q*3|0)+1<<2)>>2]=-w;g[i+((q*3|0)+2<<2)>>2]=-M;g[i+(q<<2<<2)>>2]=h;g[i+((q<<2|1)<<2)>>2]=k;g[i+((q<<2|2)<<2)>>2]=l;K=+g[e>>2]*+g[e+4>>2];L=(Z*aa+_*ba+$*ca)*(ja*T+ka*U+P*V)-(Z*da+_*ea+$*fa)*(ja*Q+ka*R+P*S);fa=(Z*da+_*ea+$*fa)*(ga*ja+ha*ka+ia*P)-(W*Z+X*_+Y*$)*(ja*T+ka*U+P*V);ka=(W*Z+X*_+Y*$)*(ja*Q+ka*R+P*S)-(Z*aa+_*ba+$*ca)*(ga*ja+ha*ka+ia*P);g[p+(q*3<<2)>>2]=K*(L*N+fa*w+ka*M);g[p+(q<<2<<2)>>2]=K*(L*r+fa*u+ka*v);if(!(a[d+716>>0]|0)){t=0;r=0.0}else{r=+g[d+708>>2]*+g[d+732>>2];t=r>0.0?1:2}n=a[d+737>>0]|0;q=(t|0)!=0;if(!(n&255|t))return;s=(c[e+24>>2]|0)*5|0;g[j+(s<<2)>>2]=la*oa;g[j+(s+1<<2)>>2]=ma*oa;g[j+(s+2<<2)>>2]=na*oa;g[i+(s<<2)>>2]=-(la*oa);g[i+(s+1<<2)>>2]=-(ma*oa);g[i+(s+2<<2)>>2]=-(na*oa);h=+g[d+688>>2];k=+g[d+692>>2];f=+eh(h-k,6.2831854820251465);if(!(f<-3.1415927410125732))if(f>3.1415927410125732)o=f+-6.2831854820251465;else o=f;else o=f+6.2831854820251465;f=+eh(h+k,6.2831854820251465);if(!(f<-3.1415927410125732)){if(f>3.1415927410125732)f=f+-6.2831854820251465}else f=f+6.2831854820251465;j=o==f;p=p+(s<<2)|0;g[p>>2]=0.0;i=c[d+748>>2]|0;m=+g[((i&2|0)==0?e+4|0:d+760|0)>>2];if(!(n<<24>>24==0|q&j)){if(i&4|0)c[(c[e+32>>2]|0)+(s<<2)>>2]=c[d+752>>2];k=+g[d+728>>2];l=+g[d+680>>2];h=o>f?1.0:0.0;do if(!(o>=f)){h=l/(m*+g[e>>2]);if(h<0.0)if(k>=o&o-h>k){f=(o-k)/h;break}else{f=k<o?0.0:1.0;break}if(h>0.0)if(k<=f&f-h<k){f=(f-k)/h;break}else{f=k>f?0.0:1.0;break}else f=0.0}else f=h;while(0);g[p>>2]=f*l*+g[d+732>>2]+ +g[p>>2];g[(c[e+36>>2]|0)+(s<<2)>>2]=-+g[d+684>>2];c[(c[e+40>>2]|0)+(s<<2)>>2]=c[d+684>>2]}if(!q)return;g[p>>2]=+g[p>>2]+r*m*+g[e>>2];if(i&1|0)c[(c[e+32>>2]|0)+(s<<2)>>2]=c[d+756>>2];do if(!j){j=(c[e+36>>2]|0)+(s<<2)|0;i=c[e+40>>2]|0;if((t|0)==1){g[j>>2]=0.0;g[i+(s<<2)>>2]=3402823466385288598117041.0e14;break}else{g[j>>2]=-3402823466385288598117041.0e14;g[i+(s<<2)>>2]=0.0;break}}else{g[(c[e+36>>2]|0)+(s<<2)>>2]=-3402823466385288598117041.0e14;g[(c[e+40>>2]|0)+(s<<2)>>2]=3402823466385288598117041.0e14}while(0);h=+g[d+704>>2];do if(h>0.0){f=+g[pa+328>>2]*la*oa+ +g[pa+332>>2]*ma*oa+ +g[pa+336>>2]*na*oa-(la*oa*+g[qa+328>>2]+ma*oa*+g[qa+332>>2]+na*oa*+g[qa+336>>2]);if((t|0)==1){if(!(f<0.0))break;if(!(+g[p>>2]<-(h*f)))break;g[p>>2]=-(h*f);break}else{if(!(f>0.0))break;if(!(+g[p>>2]>-(h*f)))break;g[p>>2]=-(h*f);break}}while(0);g[p>>2]=+g[d+700>>2]*+g[p>>2];return}function Ic(d,e,f,h,j,k){d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=+k;var l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0.0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0;F=i;i=i+896|0;E=c[h+4>>2]|0;D=c[h+12>>2]|0;w=c[E+4>>2]|0;if((w|0)<20){c[F+712>>2]=3708;c[F+712+168>>2]=0;g[F+712+172>>2]=k;c[F+712+164>>2]=c[j+4>>2];g[F+352+308>>2]=9.999999747378752e-05;a[F+352+332>>0]=0;c[F+288>>2]=9120;c[F+64>>2]=9188;c[F+64+4>>2]=F+352;c[F+64+8>>2]=F+288;c[F+64+12>>2]=d;c[F+64+16>>2]=E;c[F+64+20>>2]=0;if((Xd(F+64|0,e,f,D,D,F+712|0)|0?(l=F+712+132|0,m=+g[l>>2],n=+g[F+712+136>>2],p=+g[F+712+140>>2],m*m+n*n+p*p>9.999999747378752e-05):0)?(t=+g[F+712+164>>2],t<+g[j+4>>2]):0){k=1.0/+O(+(m*m+n*n+p*p));g[l>>2]=m*k;g[F+712+136>>2]=n*k;g[F+712+140>>2]=p*k;c[F+16>>2]=c[h+8>>2];c[F+16+4>>2]=0;c[F+16+8>>2]=c[l>>2];c[F+16+8+4>>2]=c[l+4>>2];c[F+16+8+8>>2]=c[l+8>>2];c[F+16+8+12>>2]=c[l+12>>2];c[F+16+24>>2]=c[F+712+148>>2];c[F+16+24+4>>2]=c[F+712+148+4>>2];c[F+16+24+8>>2]=c[F+712+148+8>>2];c[F+16+24+12>>2]=c[F+712+148+12>>2];g[F+16+40>>2]=t;+_b[c[(c[j>>2]|0)+12>>2]&15](j,F+16|0,1)}i=F;return}if((w+-21|0)>>>0>=9){if((w|0)!=31){i=F;return}li(15534);if((c[E+16>>2]|0)>0){l=0;do{u=c[E+24>>2]|0;m=+g[u+(l*80|0)>>2];p=+g[u+(l*80|0)+4>>2];s=+g[u+(l*80|0)+8>>2];n=+g[u+(l*80|0)+16>>2];q=+g[u+(l*80|0)+20>>2];v=+g[u+(l*80|0)+24>>2];o=+g[u+(l*80|0)+32>>2];r=+g[u+(l*80|0)+36>>2];y=+g[u+(l*80|0)+40>>2];N=+g[u+(l*80|0)+48>>2];M=+g[u+(l*80|0)+52>>2];C=+g[u+(l*80|0)+56>>2];u=c[u+(l*80|0)+64>>2]|0;L=+g[D>>2];K=+g[D+4>>2];J=+g[D+8>>2];I=+g[D+16>>2];H=+g[D+20>>2];G=+g[D+24>>2];t=+g[D+32>>2];x=+g[D+36>>2];z=+g[D+40>>2];A=N*L+M*K+C*J+ +g[D+48>>2];B=N*I+M*H+C*G+ +g[D+52>>2];C=N*t+M*x+C*z+ +g[D+56>>2];g[F+712>>2]=m*L+n*K+o*J;g[F+712+4>>2]=p*L+q*K+r*J;g[F+712+8>>2]=s*L+v*K+y*J;g[F+712+12>>2]=0.0;g[F+712+16>>2]=m*I+n*H+o*G;g[F+712+20>>2]=p*I+q*H+r*G;g[F+712+24>>2]=s*I+v*H+y*G;g[F+712+28>>2]=0.0;g[F+712+32>>2]=m*t+n*x+o*z;g[F+712+36>>2]=p*t+q*x+r*z;g[F+712+40>>2]=s*t+v*x+y*z;g[F+712+44>>2]=0.0;g[F+712+48>>2]=A;g[F+712+52>>2]=B;g[F+712+56>>2]=C;g[F+712+60>>2]=0.0;b[F+352+8>>1]=1;b[F+352+10>>1]=-1;c[F+352>>2]=5912;c[F+352+12>>2]=j;c[F+352+16>>2]=l;c[F+352+4>>2]=c[j+4>>2];w=c[h+8>>2]|0;c[F+288>>2]=h;c[F+288+4>>2]=u;c[F+288+8>>2]=w;c[F+288+12>>2]=F+712;c[F+288+16>>2]=-1;c[F+288+20>>2]=l;Ic(d,e,f,F+288|0,F+352|0,k);l=l+1|0}while((l|0)<(c[E+16>>2]|0))}l=c[2357]|0;E=(c[l+16>>2]|0)+-1|0;c[l+16>>2]=E;if(E|0){i=F;return}do if(c[l+4>>2]|0){tb(F+712|0,0)|0;E=c[6434]|0;g[l+8>>2]=+g[l+8>>2]+ +(((c[F+712+4>>2]|0)-(c[E+4>>2]|0)+(((c[F+712>>2]|0)-(c[E>>2]|0)|0)*1e6|0)-(c[l+12>>2]|0)|0)>>>0)/1.0e3;if(!(c[l+16>>2]|0)){l=c[2357]|0;break}else{i=F;return}}while(0);c[2357]=c[l+20>>2];i=F;return}switch(w|0){case 21:{p=+g[D>>2];q=+g[D+16>>2];r=+g[D+32>>2];s=+g[D+4>>2];t=+g[D+20>>2];v=+g[D+36>>2];x=+g[D+8>>2];y=+g[D+24>>2];z=+g[D+40>>2];A=-+g[D+48>>2];B=-+g[D+52>>2];C=-+g[D+56>>2];o=+g[e+48>>2];n=+g[e+52>>2];m=+g[e+56>>2];g[F+352>>2]=p*A+q*B+r*C+(p*o+q*n+r*m);g[F+352+4>>2]=s*A+t*B+v*C+(s*o+t*n+v*m);g[F+352+8>>2]=x*A+y*B+z*C+(x*o+y*n+z*m);g[F+352+12>>2]=0.0;m=+g[f+48>>2];n=+g[f+52>>2];o=+g[f+56>>2];P=+g[f>>2];G=+g[f+16>>2];H=+g[f+32>>2];I=+g[f+4>>2];J=+g[f+20>>2];K=+g[f+36>>2];L=+g[f+8>>2];M=+g[f+24>>2];N=+g[f+40>>2];g[F+288>>2]=p*P+q*G+r*H;g[F+288+4>>2]=p*I+q*J+r*K;g[F+288+8>>2]=p*L+q*M+r*N;g[F+288+12>>2]=0.0;g[F+288+16>>2]=s*P+t*G+v*H;g[F+288+20>>2]=s*I+t*J+v*K;g[F+288+24>>2]=s*L+t*M+v*N;g[F+288+28>>2]=0.0;g[F+288+32>>2]=x*P+y*G+z*H;g[F+288+36>>2]=x*I+y*J+z*K;g[F+288+40>>2]=x*L+y*M+z*N;l=F+288+44|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;l=c[h+8>>2]|0;N=+Sb[c[(c[E>>2]|0)+48>>2]&15](E);c[F+64>>2]=9048;c[F+64+4>>2]=d;c[F+64+8>>2]=c[e>>2];c[F+64+8+4>>2]=c[e+4>>2];c[F+64+8+8>>2]=c[e+8>>2];c[F+64+8+12>>2]=c[e+12>>2];c[F+64+24>>2]=c[e+16>>2];c[F+64+24+4>>2]=c[e+16+4>>2];c[F+64+24+8>>2]=c[e+16+8>>2];c[F+64+24+12>>2]=c[e+16+12>>2];c[F+64+40>>2]=c[e+32>>2];c[F+64+40+4>>2]=c[e+32+4>>2];c[F+64+40+8>>2]=c[e+32+8>>2];c[F+64+40+12>>2]=c[e+32+12>>2];c[F+64+56>>2]=c[e+48>>2];c[F+64+56+4>>2]=c[e+48+4>>2];c[F+64+56+8>>2]=c[e+48+8>>2];c[F+64+56+12>>2]=c[e+48+12>>2];c[F+64+72>>2]=c[f>>2];c[F+64+72+4>>2]=c[f+4>>2];c[F+64+72+8>>2]=c[f+8>>2];c[F+64+72+12>>2]=c[f+12>>2];c[F+64+88>>2]=c[f+16>>2];c[F+64+88+4>>2]=c[f+16+4>>2];c[F+64+88+8>>2]=c[f+16+8>>2];c[F+64+88+12>>2]=c[f+16+12>>2];c[F+64+104>>2]=c[f+32>>2];c[F+64+104+4>>2]=c[f+32+4>>2];c[F+64+104+8>>2]=c[f+32+8>>2];c[F+64+104+12>>2]=c[f+32+12>>2];c[F+64+120>>2]=c[f+48>>2];c[F+64+120+4>>2]=c[f+48+4>>2];c[F+64+120+8>>2]=c[f+48+8>>2];c[F+64+120+12>>2]=c[f+48+12>>2];c[F+64+136>>2]=c[D>>2];c[F+64+136+4>>2]=c[D+4>>2];c[F+64+136+8>>2]=c[D+8>>2];c[F+64+136+12>>2]=c[D+12>>2];c[F+64+152>>2]=c[D+16>>2];c[F+64+152+4>>2]=c[D+16+4>>2];c[F+64+152+8>>2]=c[D+16+8>>2];c[F+64+152+12>>2]=c[D+16+12>>2];c[F+64+168>>2]=c[D+32>>2];c[F+64+168+4>>2]=c[D+32+4>>2];c[F+64+168+8>>2]=c[D+32+8>>2];c[F+64+168+12>>2]=c[D+32+12>>2];c[F+64+184>>2]=c[D+48>>2];c[F+64+184+4>>2]=c[D+48+4>>2];c[F+64+184+8>>2]=c[D+48+8>>2];c[F+64+184+12>>2]=c[D+48+12>>2];g[F+64+204>>2]=N;c[F+64>>2]=5864;c[F+64+212>>2]=j;c[F+64+216>>2]=l;c[F+64+220>>2]=E;c[F+64+200>>2]=c[j+4>>2];g[F+64+208>>2]=k;mc[c[(c[d>>2]|0)+8>>2]&127](d,F+288|0,F+16|0,F);l=c[E+48>>2]|0;c[F+712>>2]=6904;c[F+712+4>>2]=l;c[F+712+8>>2]=F+64;l=c[E+52>>2]|0;if(!(a[l+60>>0]|0))Re(l,F+712|0,F+352|0,p*A+q*B+r*C+(p*m+q*n+r*o),s*A+t*B+v*C+(s*m+t*n+v*o),x*A+y*B+z*C+(x*m+y*n+z*o),F+16|0,F);else ze(l,F+712|0,F+352|0,p*A+q*B+r*C+(p*m+q*n+r*o),s*A+t*B+v*C+(s*m+t*n+v*o),x*A+y*B+z*C+(x*m+y*n+z*o),F+16|0,F,c[l+56>>2]|0);i=F;return}case 28:{c[F+712>>2]=3708;c[F+712+168>>2]=0;g[F+712+172>>2]=k;c[F+712+164>>2]=c[j+4>>2];c[F+352>>2]=9188;c[F+352+4>>2]=0;c[F+352+8>>2]=0;c[F+352+12>>2]=d;c[F+352+16>>2]=0;c[F+352+20>>2]=E;if((Xd(F+352|0,e,f,D,D,F+712|0)|0?(u=F+712+132|0,o=+g[u>>2],q=+g[F+712+136>>2],r=+g[F+712+140>>2],o*o+q*q+r*r>9.999999747378752e-05):0)?(s=+g[F+712+164>>2],s<+g[j+4>>2]):0){P=1.0/+O(+(o*o+q*q+r*r));g[u>>2]=o*P;g[F+712+136>>2]=q*P;g[F+712+140>>2]=r*P;c[F+288>>2]=c[h+8>>2];c[F+288+4>>2]=0;c[F+288+8>>2]=c[u>>2];c[F+288+8+4>>2]=c[u+4>>2];c[F+288+8+8>>2]=c[u+8>>2];c[F+288+8+12>>2]=c[u+12>>2];c[F+288+24>>2]=c[F+712+148>>2];c[F+288+24+4>>2]=c[F+712+148+4>>2];c[F+288+24+8>>2]=c[F+712+148+8>>2];c[F+288+24+12>>2]=c[F+712+148+12>>2];g[F+288+40>>2]=s;+_b[c[(c[j>>2]|0)+12>>2]&15](j,F+288|0,1)}i=F;return}default:{p=+g[D>>2];q=+g[D+16>>2];r=+g[D+32>>2];x=+g[D+4>>2];y=+g[D+20>>2];z=+g[D+36>>2];J=+g[D+8>>2];L=+g[D+24>>2];N=+g[D+40>>2];H=-+g[D+48>>2];G=-+g[D+52>>2];C=-+g[D+56>>2];A=+g[e+48>>2];B=+g[e+52>>2];m=+g[e+56>>2];o=p*H+q*G+r*C+(p*A+q*B+r*m);n=x*H+y*G+z*C+(x*A+y*B+z*m);m=J*H+L*G+N*C+(J*A+L*B+N*m);B=+g[f+48>>2];A=+g[f+52>>2];v=+g[f+56>>2];s=p*H+q*G+r*C+(p*B+q*A+r*v);t=x*H+y*G+z*C+(x*B+y*A+z*v);v=J*H+L*G+N*C+(J*B+L*A+N*v);A=+g[f>>2];B=+g[f+16>>2];C=+g[f+32>>2];G=+g[f+4>>2];H=+g[f+20>>2];I=+g[f+36>>2];K=+g[f+8>>2];M=+g[f+24>>2];P=+g[f+40>>2];g[F+712>>2]=p*A+q*B+r*C;g[F+712+4>>2]=p*G+q*H+r*I;g[F+712+8>>2]=p*K+q*M+r*P;g[F+712+12>>2]=0.0;g[F+712+16>>2]=x*A+y*B+z*C;g[F+712+20>>2]=x*G+y*H+z*I;g[F+712+24>>2]=x*K+y*M+z*P;g[F+712+28>>2]=0.0;g[F+712+32>>2]=J*A+L*B+N*C;g[F+712+36>>2]=J*G+L*H+N*I;g[F+712+40>>2]=J*K+L*M+N*P;w=F+712+44|0;c[w>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;c[w+12>>2]=0;c[w+16>>2]=0;h=c[h+8>>2]|0;P=+Sb[c[(c[E>>2]|0)+48>>2]&15](E);c[F+352>>2]=9048;c[F+352+4>>2]=d;c[F+352+8>>2]=c[e>>2];c[F+352+8+4>>2]=c[e+4>>2];c[F+352+8+8>>2]=c[e+8>>2];c[F+352+8+12>>2]=c[e+12>>2];c[F+352+24>>2]=c[e+16>>2];c[F+352+24+4>>2]=c[e+16+4>>2];c[F+352+24+8>>2]=c[e+16+8>>2];c[F+352+24+12>>2]=c[e+16+12>>2];c[F+352+40>>2]=c[e+32>>2];c[F+352+40+4>>2]=c[e+32+4>>2];c[F+352+40+8>>2]=c[e+32+8>>2];c[F+352+40+12>>2]=c[e+32+12>>2];c[F+352+56>>2]=c[e+48>>2];c[F+352+56+4>>2]=c[e+48+4>>2];c[F+352+56+8>>2]=c[e+48+8>>2];c[F+352+56+12>>2]=c[e+48+12>>2];c[F+352+72>>2]=c[f>>2];c[F+352+72+4>>2]=c[f+4>>2];c[F+352+72+8>>2]=c[f+8>>2];c[F+352+72+12>>2]=c[f+12>>2];c[F+352+88>>2]=c[f+16>>2];c[F+352+88+4>>2]=c[f+16+4>>2];c[F+352+88+8>>2]=c[f+16+8>>2];c[F+352+88+12>>2]=c[f+16+12>>2];c[F+352+104>>2]=c[f+32>>2];c[F+352+104+4>>2]=c[f+32+4>>2];c[F+352+104+8>>2]=c[f+32+8>>2];c[F+352+104+12>>2]=c[f+32+12>>2];c[F+352+120>>2]=c[f+48>>2];c[F+352+120+4>>2]=c[f+48+4>>2];c[F+352+120+8>>2]=c[f+48+8>>2];c[F+352+120+12>>2]=c[f+48+12>>2];c[F+352+136>>2]=c[D>>2];c[F+352+136+4>>2]=c[D+4>>2];c[F+352+136+8>>2]=c[D+8>>2];c[F+352+136+12>>2]=c[D+12>>2];c[F+352+152>>2]=c[D+16>>2];c[F+352+152+4>>2]=c[D+16+4>>2];c[F+352+152+8>>2]=c[D+16+8>>2];c[F+352+152+12>>2]=c[D+16+12>>2];c[F+352+168>>2]=c[D+32>>2];c[F+352+168+4>>2]=c[D+32+4>>2];c[F+352+168+8>>2]=c[D+32+8>>2];c[F+352+168+12>>2]=c[D+32+12>>2];c[F+352+184>>2]=c[D+48>>2];c[F+352+184+4>>2]=c[D+48+4>>2];c[F+352+184+8>>2]=c[D+48+8>>2];c[F+352+184+12>>2]=c[D+48+12>>2];g[F+352+204>>2]=P;c[F+352>>2]=5888;c[F+352+212>>2]=j;c[F+352+216>>2]=h;c[F+352+220>>2]=E;c[F+352+200>>2]=c[j+4>>2];g[F+352+208>>2]=k;mc[c[(c[d>>2]|0)+8>>2]&127](d,F+712|0,F+288|0,F+64|0);g[F+16>>2]=o;g[F+16+4>>2]=n;g[F+16+8>>2]=m;g[F+16+12>>2]=0.0;if(s<o){g[F+16>>2]=s;p=s}else p=o;if(t<n){g[F+16+4>>2]=t;q=t}else q=n;if(v<m){g[F+16+8>>2]=v;r=v}else r=m;g[F>>2]=o;g[F+4>>2]=n;g[F+8>>2]=m;g[F+12>>2]=0.0;if(o<s){g[F>>2]=s;o=s}if(n<t){g[F+4>>2]=t;n=t}if(m<v){g[F+8>>2]=v;m=v}g[F+16>>2]=+g[F+288>>2]+p;g[F+16+4>>2]=+g[F+288+4>>2]+q;g[F+16+8>>2]=+g[F+288+8>>2]+r;g[F>>2]=+g[F+64>>2]+o;g[F+4>>2]=+g[F+64+4>>2]+n;g[F+8>>2]=+g[F+64+8>>2]+m;mc[c[(c[E>>2]|0)+64>>2]&127](E,F+352|0,F+16|0,F);i=F;return}}}function Jc(d,e,f){d=d|0;e=e|0;f=+f;var h=0,j=0.0,k=0.0,l=0,m=0.0,n=0,o=0.0,p=0,q=0.0,r=0.0,s=0.0,t=0,u=0;t=i;i=i+528|0;if((a[d+171>>0]|0)==0?+g[d+172>>2]<=0.0:0){i=t;return}a[d+168>>0]=(Eb[c[(c[d>>2]|0)+48>>2]&127](d)|0)&1;j=+g[d+16>>2]-+g[d+44>>2]*f;g[d+16>>2]=j;if(j>0.0?(k=+g[d+28>>2],j>k):0){g[d+16>>2]=k;j=k}if(j<0.0?(r=+N(+j),m=+N(+(+g[d+24>>2])),r>m):0){g[d+16>>2]=-m;j=-m}g[d+20>>2]=j*f;h=c[d+8>>2]|0;c[t>>2]=c[h+4>>2];c[t+4>>2]=c[h+4+4>>2];c[t+8>>2]=c[h+4+8>>2];c[t+12>>2]=c[h+4+12>>2];c[t+16>>2]=c[h+20>>2];c[t+16+4>>2]=c[h+20+4>>2];c[t+16+8>>2]=c[h+20+8>>2];c[t+16+12>>2]=c[h+20+12>>2];c[t+32>>2]=c[h+36>>2];c[t+32+4>>2]=c[h+36+4>>2];c[t+32+8>>2]=c[h+36+8>>2];c[t+32+12>>2]=c[h+36+12>>2];c[t+48>>2]=c[h+52>>2];c[t+48+4>>2]=c[h+52+4>>2];c[t+48+8>>2]=c[h+52+8>>2];c[t+48+12>>2]=c[h+52+12>>2];h=c[d+176>>2]|0;if((a[22560]|0)==0?Wa(22560)|0:0){c[6126]=1065353216;c[6127]=0;c[6128]=0;c[6129]=0;c[6130]=0;c[6131]=1065353216;c[6132]=0;c[6133]=0;c[6134]=0;c[6135]=0;c[6136]=1065353216;g[6137]=0.0;_a(22560)}m=+g[d+20>>2];m=+g[d+52>>2]+(m>0.0?m:0.0);q=+g[24504+(h<<4)+4>>2]*m+ +g[d+96>>2];r=m*+g[24504+(h<<4)+8>>2]+ +g[d+100>>2];g[d+112>>2]=+g[d+92>>2]+ +g[24504+(h<<4)>>2]*m;g[d+116>>2]=q;g[d+120>>2]=r;g[d+124>>2]=0.0;c[t+456>>2]=1065353216;c[t+456+4>>2]=0;c[t+456+4+4>>2]=0;c[t+456+4+8>>2]=0;c[t+456+4+12>>2]=0;c[t+456+20>>2]=1065353216;c[t+456+24>>2]=0;c[t+456+24+4>>2]=0;c[t+456+24+8>>2]=0;c[t+456+24+12>>2]=0;c[t+456+40>>2]=1065353216;h=t+456+44|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;c[t+392>>2]=1065353216;c[t+392+4>>2]=0;c[t+392+4+4>>2]=0;c[t+392+4+8>>2]=0;c[t+392+4+12>>2]=0;c[t+392+20>>2]=1065353216;c[t+392+24>>2]=0;c[t+392+24+4>>2]=0;c[t+392+24+8>>2]=0;c[t+392+24+12>>2]=0;c[t+392+40>>2]=1065353216;h=t+392+44|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[h+16>>2]=0;h=c[d+176>>2]|0;if((a[22560]|0)==0?Wa(22560)|0:0){c[6126]=1065353216;c[6127]=0;c[6128]=0;c[6129]=0;c[6130]=0;c[6131]=1065353216;c[6132]=0;c[6133]=0;c[6134]=0;c[6135]=0;c[6136]=1065353216;g[6137]=0.0;_a(22560)}l=c[d+12>>2]|0;m=+Sb[c[(c[l>>2]|0)+48>>2]&15](l);m=m+ +g[d+56>>2];q=m*+g[24504+(h<<4)+4>>2]+ +g[d+96>>2];r=m*+g[24504+(h<<4)+8>>2]+ +g[d+100>>2];g[t+456+48>>2]=+g[24504+(h<<4)>>2]*m+ +g[d+92>>2];g[t+456+52>>2]=q;g[t+456+56>>2]=r;g[t+456+60>>2]=0.0;c[t+392+48>>2]=c[d+112>>2];c[t+392+48+4>>2]=c[d+112+4>>2];c[t+392+48+8>>2]=c[d+112+8>>2];c[t+392+48+12>>2]=c[d+112+12>>2];h=c[d+8>>2]|0;l=c[d+176>>2]|0;if((a[22560]|0)==0?Wa(22560)|0:0){c[6126]=1065353216;c[6127]=0;c[6128]=0;c[6129]=0;c[6130]=0;c[6131]=1065353216;c[6132]=0;c[6133]=0;c[6134]=0;c[6135]=0;c[6136]=1065353216;g[6137]=0.0;_a(22560)}m=-+g[24504+(l<<4)>>2];q=-+g[24504+(l<<4)+4>>2];r=-+g[24504+(l<<4)+8>>2];g[t+288+4>>2]=1.0;b[t+288+8>>1]=1;b[t+288+10>>1]=-1;p=t+288+12|0;c[t+288+76>>2]=0;c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;c[p+12>>2]=0;c[p+16>>2]=0;c[p+20>>2]=0;c[p+24>>2]=0;c[p+28>>2]=0;c[t+288>>2]=4936;c[t+288+80>>2]=h;g[t+288+84>>2]=m;g[t+288+88>>2]=q;g[t+288+92>>2]=r;g[t+288+96>>2]=0.0;g[t+288+100>>2]=.707099974155426;h=c[d+8>>2]|0;p=c[(c[h+188>>2]|0)+4>>2]|0;b[t+288+8>>1]=p;b[t+288+10>>1]=p>>>16;if(!(a[d+170>>0]|0))Kd(e,c[d+12>>2]|0,t+456|0,t+392|0,t+288|0,0.0);else wd(h,c[d+12>>2]|0,t+456|0,t+392|0,t+288|0,+g[e+56>>2]);if(+g[t+288+4>>2]<1.0){h=c[d+176>>2]|0;if((a[22560]|0)==0?Wa(22560)|0:0){c[6126]=1065353216;c[6127]=0;c[6128]=0;c[6129]=0;c[6130]=0;c[6131]=1065353216;c[6132]=0;c[6133]=0;c[6134]=0;c[6135]=0;c[6136]=1065353216;g[6137]=0.0;_a(22560)}do if(+g[t+288+44>>2]*+g[24504+(h<<4)>>2]+ +g[t+288+48>>2]*+g[24504+(h<<4)+4>>2]+ +g[t+288+52>>2]*+g[24504+(h<<4)+8>>2]>0.0){j=+g[t+288+4>>2];g[d+108>>2]=+g[d+52>>2]*j;if(!(a[d+180>>0]|0)){c[d+92>>2]=c[d+112>>2];c[d+92+4>>2]=c[d+112+4>>2];c[d+92+8>>2]=c[d+112+8>>2];c[d+92+12>>2]=c[d+112+12>>2];break}else{g[d+92>>2]=(1.0-j)*+g[d+92>>2]+j*+g[d+112>>2];g[d+96>>2]=(1.0-j)*+g[d+96>>2]+j*+g[d+116>>2];g[d+100>>2]=(1.0-j)*+g[d+100>>2]+j*+g[d+120>>2];break}}while(0);g[d+16>>2]=0.0;g[d+20>>2]=0.0}else{c[d+108>>2]=c[d+52>>2];c[d+92>>2]=c[d+112>>2];c[d+92+4>>2]=c[d+112+4>>2];c[d+92+8>>2]=c[d+112+8>>2];c[d+92+12>>2]=c[d+112+12>>2]}if(!(a[d+171>>0]|0)){q=+g[d+172>>2];r=q>f?f:q;g[d+172>>2]=q-f;he(d,e,r*+g[d+60>>2],r*+g[d+64>>2],r*+g[d+68>>2])}else he(d,e,+g[d+60>>2],+g[d+64>>2],+g[d+68>>2]);c[t+272>>2]=c[d+112>>2];c[t+272+4>>2]=c[d+112+4>>2];c[t+272+8>>2]=c[d+112+8>>2];c[t+272+12>>2]=c[d+112+12>>2];j=+g[d+16>>2];j=(j<0.0?-j:0.0)*f;if(j>0.0?(o=+g[d+24>>2],j>o):0){p=b[d+168>>1]|0;j=(p&255)<<24>>24!=0|(p&65535)<256?o:j}h=c[d+176>>2]|0;if((a[22560]|0)==0?Wa(22560)|0:0){c[6126]=1065353216;c[6127]=0;c[6128]=0;c[6129]=0;c[6130]=0;c[6131]=1065353216;c[6132]=0;c[6133]=0;c[6134]=0;c[6135]=0;c[6136]=1065353216;g[6137]=0.0;_a(22560)}o=j+ +g[d+108>>2];q=+g[24504+(h<<4)>>2]*o;r=o*+g[24504+(h<<4)+4>>2];o=o*+g[24504+(h<<4)+8>>2];g[d+112>>2]=+g[d+112>>2]-q;g[d+116>>2]=+g[d+116>>2]-r;g[d+120>>2]=+g[d+120>>2]-o;h=c[d+8>>2]|0;l=c[d+176>>2]|0;if((a[22560]|0)==0?Wa(22560)|0:0){c[6126]=1065353216;c[6127]=0;c[6128]=0;c[6129]=0;c[6130]=0;c[6131]=1065353216;c[6132]=0;c[6133]=0;c[6134]=0;c[6135]=0;c[6136]=1065353216;g[6137]=0.0;_a(22560)}n=c[d+40>>2]|0;p=t+168+4|0;g[p>>2]=1.0;b[t+168+8>>1]=1;b[t+168+10>>1]=-1;u=t+168+12|0;c[t+168+76>>2]=0;c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;c[u+12>>2]=0;c[u+16>>2]=0;c[u+20>>2]=0;c[u+24>>2]=0;c[u+28>>2]=0;c[t+168>>2]=4936;c[t+168+80>>2]=h;c[t+168+84>>2]=c[24504+(l<<4)>>2];c[t+168+84+4>>2]=c[24504+(l<<4)+4>>2];c[t+168+84+8>>2]=c[24504+(l<<4)+8>>2];c[t+168+84+12>>2]=c[24504+(l<<4)+12>>2];c[t+168+100>>2]=n;h=c[d+8>>2]|0;l=c[(c[h+188>>2]|0)+4>>2]|0;b[t+168+8>>1]=l;b[t+168+10>>1]=l>>>16;l=c[d+176>>2]|0;if((a[22560]|0)==0?Wa(22560)|0:0){c[6126]=1065353216;c[6127]=0;c[6128]=0;c[6129]=0;c[6130]=0;c[6131]=1065353216;c[6132]=0;c[6133]=0;c[6134]=0;c[6135]=0;c[6136]=1065353216;g[6137]=0.0;_a(22560)}u=c[d+40>>2]|0;g[t+64+4>>2]=1.0;b[t+64+8>>1]=1;b[t+64+10>>1]=-1;n=t+64+12|0;c[t+64+76>>2]=0;c[n>>2]=0;c[n+4>>2]=0;c[n+8>>2]=0;c[n+12>>2]=0;c[n+16>>2]=0;c[n+20>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;c[t+64>>2]=4936;c[t+64+80>>2]=h;c[t+64+84>>2]=c[24504+(l<<4)>>2];c[t+64+84+4>>2]=c[24504+(l<<4)+4>>2];c[t+64+84+8>>2]=c[24504+(l<<4)+8>>2];c[t+64+84+12>>2]=c[24504+(l<<4)+12>>2];c[t+64+100>>2]=u;h=c[(c[(c[d+8>>2]|0)+188>>2]|0)+4>>2]|0;b[t+64+8>>1]=h;b[t+64+10>>1]=h>>>16;j=+g[d+112>>2];k=+g[d+116>>2];m=+g[d+120>>2];h=0;while(1){c[t+456>>2]=1065353216;c[t+456+4>>2]=0;c[t+456+4+4>>2]=0;c[t+456+4+8>>2]=0;c[t+456+4+12>>2]=0;c[t+456+20>>2]=1065353216;c[t+456+24>>2]=0;c[t+456+24+4>>2]=0;c[t+456+24+8>>2]=0;c[t+456+24+12>>2]=0;c[t+456+40>>2]=1065353216;c[t+456+44>>2]=0;c[t+392>>2]=1065353216;c[t+392+4>>2]=0;c[t+392+4+4>>2]=0;c[t+392+4+8>>2]=0;c[t+392+4+12>>2]=0;c[t+392+20>>2]=1065353216;c[t+392+24>>2]=0;c[t+392+24+4>>2]=0;c[t+392+24+8>>2]=0;c[t+392+24+12>>2]=0;c[t+392+40>>2]=1065353216;c[t+392+44>>2]=0;c[t+288>>2]=1065353216;c[t+288+4>>2]=0;c[t+288+4+4>>2]=0;c[t+288+4+8>>2]=0;c[t+288+4+12>>2]=0;c[t+288+20>>2]=1065353216;c[t+288+24>>2]=0;c[t+288+24+4>>2]=0;c[t+288+24+8>>2]=0;c[t+288+24+12>>2]=0;c[t+288+40>>2]=1065353216;c[t+288+44>>2]=0;c[t+288+44+4>>2]=0;c[t+288+44+8>>2]=0;c[t+456+48>>2]=c[d+92>>2];c[t+456+48+4>>2]=c[d+92+4>>2];c[t+456+48+8>>2]=c[d+92+8>>2];c[t+456+48+12>>2]=c[d+92+12>>2];c[t+392+48>>2]=c[d+112>>2];c[t+392+48+4>>2]=c[d+112+4>>2];c[t+392+48+8>>2]=c[d+112+8>>2];c[t+392+48+12>>2]=c[d+112+12>>2];g[t+288+48>>2]=j-q;g[t+288+52>>2]=k-r;g[t+288+56>>2]=m-o;g[t+288+60>>2]=0.0;if(!(a[d+170>>0]|0)){Kd(e,c[d+12>>2]|0,t+456|0,t+392|0,t+168|0,+g[e+56>>2]);if(!(+g[p>>2]<1.0))Kd(e,c[d+12>>2]|0,t+456|0,t+288|0,t+64|0,+g[e+56>>2])}else{wd(c[d+8>>2]|0,c[d+12>>2]|0,t+456|0,t+392|0,t+168|0,+g[e+56>>2]);if(!(+g[p>>2]<1.0))wd(c[d+8>>2]|0,c[d+12>>2]|0,t+456|0,t+288|0,t+64|0,+g[e+56>>2])}k=+g[d+16>>2];k=(k<0.0?-k:0.0)*f;n=(a[d+182>>0]|0)==0;if(!n?+g[p>>2]<1.0:0)l=1;else l=+g[t+64+4>>2]<1.0;if(!(k>0.0))break;j=+g[d+52>>2];if(h|(!(k<j)|l^1))break;u=b[d+168>>1]|0;if(!((u&255)<<24>>24!=0|(u&65535)<256)){h=0;break}c[d+112>>2]=c[t+272>>2];c[d+112+4>>2]=c[t+272+4>>2];c[d+112+8>>2]=c[t+272+8>>2];c[d+112+12>>2]=c[t+272+12>>2];h=c[d+176>>2]|0;do if(!(a[22560]|0)){if(!(Wa(22560)|0))break;c[6126]=1065353216;c[6127]=0;c[6128]=0;c[6129]=0;c[6130]=0;c[6131]=1065353216;c[6132]=0;c[6133]=0;c[6134]=0;c[6135]=0;c[6136]=1065353216;g[6137]=0.0;_a(22560)}while(0);j=j+ +g[d+108>>2];k=j*+g[24504+(h<<4)+4>>2];m=j*+g[24504+(h<<4)+8>>2];j=+g[d+112>>2]-+g[24504+(h<<4)>>2]*j;g[d+112>>2]=j;k=+g[d+116>>2]-k;g[d+116>>2]=k;m=+g[d+120>>2]-m;g[d+120>>2]=m;h=1}m=+g[p>>2];if(h|m<1.0){j=+g[d+96>>2];k=(j-+g[t+168+64>>2])*.5;do if(!n)if(!(a[d+181>>0]|0)){g[d+92>>2]=(1.0-k)*+g[d+92>>2]+k*+g[d+112>>2];g[d+96>>2]=(1.0-k)*j+k*+g[d+116>>2];g[d+100>>2]=(1.0-k)*+g[d+100>>2]+k*+g[d+120>>2];h=d+181|0;break}else{g[d+92>>2]=(1.0-m)*+g[d+92>>2]+m*+g[d+112>>2];g[d+96>>2]=(1.0-m)*j+m*+g[d+116>>2];g[d+100>>2]=(1.0-m)*+g[d+100>>2]+m*+g[d+120>>2];h=d+181|0;break}else{g[d+92>>2]=(1.0-m)*+g[d+92>>2]+m*+g[d+112>>2];g[d+96>>2]=(1.0-m)*j+m*+g[d+116>>2];g[d+100>>2]=(1.0-m)*+g[d+100>>2]+m*+g[d+120>>2];h=d+181|0}while(0);a[h>>0]=0;g[d+16>>2]=0.0;g[d+20>>2]=0.0;a[d+169>>0]=0}else{a[d+181>>0]=1;if((!n?(s=+g[d+24>>2],k>s):0)?(u=b[d+168>>1]|0,(u&255)<<24>>24!=0|(u&65535)<256):0){g[d+112>>2]=q+ +g[d+112>>2];g[d+116>>2]=r+ +g[d+116>>2];g[d+120>>2]=o+ +g[d+120>>2];h=c[d+176>>2]|0;do if(!(a[22560]|0)){if(!(Wa(22560)|0))break;c[6126]=1065353216;c[6127]=0;c[6128]=0;c[6129]=0;c[6130]=0;c[6131]=1065353216;c[6132]=0;c[6133]=0;c[6134]=0;c[6135]=0;c[6136]=1065353216;g[6137]=0.0;_a(22560)}while(0);r=s+ +g[d+108>>2];f=r*+g[24504+(h<<4)+4>>2];s=r*+g[24504+(h<<4)+8>>2];g[d+112>>2]=+g[d+112>>2]-+g[24504+(h<<4)>>2]*r;g[d+116>>2]=+g[d+116>>2]-f;g[d+120>>2]=+g[d+120>>2]-s}c[d+92>>2]=c[d+112>>2];c[d+92+4>>2]=c[d+112+4>>2];c[d+92+8>>2]=c[d+112+8>>2];c[d+92+12>>2]=c[d+112+12>>2]}c[t+48>>2]=c[d+92>>2];c[t+48+4>>2]=c[d+92+4>>2];c[t+48+8>>2]=c[d+92+8>>2];c[t+48+12>>2]=c[d+92+12>>2];u=c[d+8>>2]|0;c[u+260>>2]=(c[u+260>>2]|0)+1;c[u+4>>2]=c[t>>2];c[u+4+4>>2]=c[t+4>>2];c[u+4+8>>2]=c[t+8>>2];c[u+4+12>>2]=c[t+12>>2];c[u+20>>2]=c[t+16>>2];c[u+20+4>>2]=c[t+16+4>>2];c[u+20+8>>2]=c[t+16+8>>2];c[u+20+12>>2]=c[t+16+12>>2];c[u+36>>2]=c[t+32>>2];c[u+36+4>>2]=c[t+32+4>>2];c[u+36+8>>2]=c[t+32+8>>2];c[u+36+12>>2]=c[t+32+12>>2];c[u+52>>2]=c[t+48>>2];c[u+52+4>>2]=c[t+48+4>>2];c[u+52+8>>2]=c[t+48+8>>2];c[u+52+12>>2]=c[t+48+12>>2];i=t;return}function Kc(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,l=0,m=0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0;z=i;i=i+112|0;c[b+164>>2]=1065353216;c[b+168>>2]=1065353216;c[b+172>>2]=1065353216;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749440.0;c[b+188>>2]=0;c[b+188+4>>2]=0;c[b+188+8>>2]=0;c[b+188+12>>2]=0;c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;g[b+232>>2]=0.0;c[b+236>>2]=1;c[b+240>>2]=0;g[b+244>>2]=1.0;c[b+248>>2]=0;c[b+248+4>>2]=0;c[b+248+8>>2]=0;c[b+248+12>>2]=0;c[b+4>>2]=1065353216;c[b+8>>2]=0;c[b+8+4>>2]=0;c[b+8+8>>2]=0;c[b+8+12>>2]=0;c[b+24>>2]=1065353216;c[b+28>>2]=0;c[b+28+4>>2]=0;c[b+28+8>>2]=0;c[b+28+12>>2]=0;c[b+44>>2]=1065353216;c[b+48>>2]=0;c[b+48+4>>2]=0;c[b+48+8>>2]=0;c[b+48+12>>2]=0;c[b+48+16>>2]=0;c[b>>2]=3180;a[b+280>>0]=1;c[b+276>>2]=0;c[b+268>>2]=0;c[b+272>>2]=0;c[b+284>>2]=0;a[b+408>>0]=1;c[b+404>>2]=0;c[b+396>>2]=0;c[b+400>>2]=0;a[b+428>>0]=1;c[b+424>>2]=0;c[b+416>>2]=0;c[b+420>>2]=0;a[b+448>>0]=1;c[b+444>>2]=0;c[b+436>>2]=0;c[b+440>>2]=0;a[b+496>>0]=1;c[b+492>>2]=0;c[b+484>>2]=0;c[b+488>>2]=0;a[b+516>>0]=1;c[b+512>>2]=0;c[b+504>>2]=0;c[b+508>>2]=0;c[b+684>>2]=d;a[b+704>>0]=1;c[b+700>>2]=0;c[b+692>>2]=0;c[b+696>>2]=0;a[b+724>>0]=1;c[b+720>>2]=0;c[b+712>>2]=0;c[b+716>>2]=0;a[b+744>>0]=1;c[b+740>>2]=0;c[b+732>>2]=0;c[b+736>>2]=0;a[b+764>>0]=1;c[b+760>>2]=0;c[b+752>>2]=0;c[b+756>>2]=0;a[b+784>>0]=1;c[b+780>>2]=0;c[b+772>>2]=0;c[b+776>>2]=0;a[b+804>>0]=1;c[b+800>>2]=0;c[b+792>>2]=0;c[b+796>>2]=0;a[b+824>>0]=1;c[b+820>>2]=0;c[b+812>>2]=0;c[b+816>>2]=0;a[b+844>>0]=1;c[b+840>>2]=0;c[b+832>>2]=0;c[b+836>>2]=0;a[b+864>>0]=1;c[b+860>>2]=0;c[b+852>>2]=0;c[b+856>>2]=0;a[b+884>>0]=1;c[b+880>>2]=0;c[b+872>>2]=0;c[b+876>>2]=0;a[b+964>>0]=1;c[b+960>>2]=0;c[b+952>>2]=0;c[b+956>>2]=0;a[b+984>>0]=1;c[b+980>>2]=0;c[b+972>>2]=0;c[b+976>>2]=0;c[b+928>>2]=0;c[b+932>>2]=0;c[b+936>>2]=-1;c[b+940>>2]=0;c[b+944>>2]=0;a[b+1024>>0]=1;c[b+1020>>2]=0;c[b+1012>>2]=0;c[b+1016>>2]=0;a[b+1044>>0]=1;c[b+1040>>2]=0;c[b+1032>>2]=0;c[b+1036>>2]=0;c[b+988>>2]=0;c[b+992>>2]=0;c[b+996>>2]=-1;c[b+1e3>>2]=0;c[b+1004>>2]=0;a[b+1084>>0]=1;c[b+1080>>2]=0;c[b+1072>>2]=0;c[b+1076>>2]=0;a[b+1104>>0]=1;c[b+1100>>2]=0;c[b+1092>>2]=0;c[b+1096>>2]=0;c[b+1048>>2]=0;c[b+1052>>2]=0;c[b+1056>>2]=-1;c[b+1060>>2]=0;c[b+1064>>2]=0;a[b+1124>>0]=1;c[b+1120>>2]=0;c[b+1112>>2]=0;c[b+1116>>2]=0;a[b+1144>>0]=1;c[b+1140>>2]=0;c[b+1132>>2]=0;c[b+1136>>2]=0;a[b+1248>>0]=1;c[b+1244>>2]=0;c[b+1236>>2]=0;c[b+1240>>2]=0;c[b+236>>2]=8;c[b+288>>2]=0;g[b+292>>2]=1.0;c[b+296>>2]=0;c[b+296+4>>2]=0;c[b+296+8>>2]=0;c[b+296+12>>2]=0;c[b+296+16>>2]=0;g[b+316>>2]=.20000000298023224;g[b+320>>2]=0.0;g[b+324>>2]=1.0;g[b+328>>2]=.10000000149011612;g[b+332>>2]=1.0;g[b+336>>2]=.699999988079071;g[b+340>>2]=.10000000149011612;g[b+344>>2]=1.0;g[b+348>>2]=.5;g[b+352>>2]=.5;g[b+356>>2]=.5;g[b+360>>2]=.5;g[b+364>>2]=1.0;g[b+368>>2]=1.0;c[b+372>>2]=0;c[b+376>>2]=1;c[b+380>>2]=0;c[b+384>>2]=4;c[b+388>>2]=1;a[b+472>>0]=0;a[b+473>>0]=0;g[b+476>>2]=0.0;c[b+520>>2]=0;c[b+520+4>>2]=0;c[b+520+8>>2]=0;c[b+520+12>>2]=0;c[b+536>>2]=1065353216;c[b+540>>2]=0;c[b+540+4>>2]=0;c[b+540+8>>2]=0;c[b+540+12>>2]=0;c[b+556>>2]=1065353216;c[b+560>>2]=0;c[b+560+4>>2]=0;c[b+560+8>>2]=0;c[b+560+12>>2]=0;c[b+576>>2]=1065353216;g[b+580>>2]=0.0;c[b+584>>2]=1065353216;c[b+588>>2]=0;c[b+588+4>>2]=0;c[b+588+8>>2]=0;c[b+588+12>>2]=0;c[b+604>>2]=1065353216;c[b+608>>2]=0;c[b+608+4>>2]=0;c[b+608+8>>2]=0;c[b+608+12>>2]=0;c[b+624>>2]=1065353216;g[b+628>>2]=0.0;c[b+680>>2]=0;g[b+888>>2]=0.0;a[b+924>>0]=1;c[b+892>>2]=0;c[b+892+4>>2]=0;c[b+892+8>>2]=0;c[b+892+12>>2]=0;c[b+892+16>>2]=0;c[b+892+20>>2]=0;c[b+892+24>>2]=0;c[b+892+28>>2]=0;c[b+4>>2]=1065353216;c[b+8>>2]=0;c[b+8+4>>2]=0;c[b+8+8>>2]=0;c[b+8+12>>2]=0;c[b+24>>2]=1065353216;c[b+28>>2]=0;c[b+28+4>>2]=0;c[b+28+8>>2]=0;c[b+28+12>>2]=0;c[b+44>>2]=1065353216;c[b+48>>2]=0;c[b+48+4>>2]=0;c[b+48+8>>2]=0;c[b+48+12>>2]=0;c[b+48+16>>2]=0;d=c[b+404>>2]|0;if(d|0){if(a[b+408>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+404>>2]=0}a[b+408>>0]=1;c[b+404>>2]=0;c[b+396>>2]=0;c[b+400>>2]=0;d=c[b+424>>2]|0;if(d|0){if(a[b+428>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0)}c[b+424>>2]=0}a[b+428>>0]=1;c[b+424>>2]=0;c[b+416>>2]=0;c[b+420>>2]=0;d=c[b+444>>2]|0;do if(d)if(a[b+448>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[d+-4>>2]|0);j=c[b+416>>2]|0;d=c[b+420>>2]|0;c[b+444>>2]=0;a[b+448>>0]=1;c[b+444>>2]=0;c[b+436>>2]=0;c[b+440>>2]=0;if((j|0)==(d|0)){s=14;break}else break}else{c[b+444>>2]=0;a[b+448>>0]=1;c[b+444>>2]=0;c[b+436>>2]=0;c[b+440>>2]=0;d=0;s=14;break}else{a[b+448>>0]=1;c[b+444>>2]=0;c[b+436>>2]=0;c[b+440>>2]=0;d=0;s=14}while(0);if((s|0)==14){o=d|0?d<<1:1;if((d|0)<(o|0)){if(!o)m=0;else{c[6435]=(c[6435]|0)+1;d=yc((o<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}m=d;d=c[b+416>>2]|0}l=c[b+424>>2]|0;if((d|0)<=0){if(l)s=22}else{j=0;do{c[m+(j<<2)>>2]=c[l+(j<<2)>>2];j=j+1|0}while((j|0)!=(d|0));s=22}if((s|0)==22){if(a[b+428>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[l+-4>>2]|0);d=c[b+416>>2]|0}c[b+424>>2]=0}a[b+428>>0]=1;c[b+424>>2]=m;c[b+420>>2]=o;j=d;d=o}else j=d}c[(c[b+424>>2]|0)+(j<<2)>>2]=1;j=j+1|0;c[b+416>>2]=j;if((j|0)==(d|0)){o=d|0?d<<1:1;if((d|0)<(o|0)){if(!o)m=0;else{c[6435]=(c[6435]|0)+1;d=yc((o<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}m=d;d=c[b+416>>2]|0}l=c[b+424>>2]|0;if((d|0)<=0){if(l)s=35}else{j=0;do{c[m+(j<<2)>>2]=c[l+(j<<2)>>2];j=j+1|0}while((j|0)!=(d|0));s=35}if((s|0)==35){if(a[b+428>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[l+-4>>2]|0);d=c[b+416>>2]|0}c[b+424>>2]=0}a[b+428>>0]=1;c[b+424>>2]=m;c[b+420>>2]=o;j=d;d=o}else j=d}c[(c[b+424>>2]|0)+(j<<2)>>2]=2;j=j+1|0;c[b+416>>2]=j;if((j|0)==(d|0)){o=d|0?d<<1:1;if((d|0)<(o|0)){if(!o)m=0;else{c[6435]=(c[6435]|0)+1;d=yc((o<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}m=d;d=c[b+416>>2]|0}l=c[b+424>>2]|0;if((d|0)<=0){if(l)s=48}else{j=0;do{c[m+(j<<2)>>2]=c[l+(j<<2)>>2];j=j+1|0}while((j|0)!=(d|0));s=48}if((s|0)==48){if(a[b+428>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[l+-4>>2]|0);d=c[b+416>>2]|0}c[b+424>>2]=0}a[b+428>>0]=1;c[b+424>>2]=m;c[b+420>>2]=o;j=d;d=o}else j=d}c[(c[b+424>>2]|0)+(j<<2)>>2]=3;j=j+1|0;c[b+416>>2]=j;if((j|0)==(d|0)){o=d|0?d<<1:1;if((d|0)<(o|0)){if(!o)m=0;else{c[6435]=(c[6435]|0)+1;d=yc((o<<2|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}m=d;d=c[b+416>>2]|0}l=c[b+424>>2]|0;if((d|0)<=0){if(l)s=61}else{j=0;do{c[m+(j<<2)>>2]=c[l+(j<<2)>>2];j=j+1|0}while((j|0)!=(d|0));s=61}if((s|0)==61){if(a[b+428>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[l+-4>>2]|0);d=c[b+416>>2]|0}c[b+424>>2]=0}a[b+428>>0]=1;c[b+424>>2]=m;c[b+420>>2]=o}}else d=j;c[(c[b+424>>2]|0)+(d<<2)>>2]=0;c[b+416>>2]=d+1;c[6435]=(c[6435]|0)+1;d=yc(39)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}c[d+8>>2]=0;c[d>>2]=3288;c[d+4>>2]=32;c[d+16>>2]=b;c[b+192>>2]=d;g[d+12>>2]=.25;c[b+1148>>2]=1065353216;c[b+1152>>2]=0;c[b+1152+4>>2]=0;c[b+1152+8>>2]=0;c[b+1152+12>>2]=0;c[b+1168>>2]=1065353216;c[b+1172>>2]=0;c[b+1172+4>>2]=0;c[b+1172+8>>2]=0;c[b+1172+12>>2]=0;c[b+1188>>2]=1065353216;s=b+1192|0;t=s+36|0;do{c[s>>2]=0;s=s+4|0}while((s|0)<(t|0));g[b+1228>>2]=1.0;x=ph(b)|0;g[x+4>>2]=1.0;g[x+8>>2]=1.0;g[x+12>>2]=1.0;c[x+16>>2]=1;s=c[b+192>>2]|0;y=+Sb[c[(c[s>>2]|0)+48>>2]&15](s);s=z;t=s+100|0;do{c[s>>2]=0;s=s+4|0}while((s|0)<(t|0));o=c[b+712>>2]|0;if((o|0)<(e|0)){if((c[b+716>>2]|0)<(e|0)){if(!e){d=0;j=o}else{c[6435]=(c[6435]|0)+1;d=yc((e*104|3)+16|0)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}j=c[b+712>>2]|0}if((j|0)>0){l=0;do{s=d+(l*104|0)|0;m=(c[b+720>>2]|0)+(l*104|0)|0;t=s+104|0;do{c[s>>2]=c[m>>2];s=s+4|0;m=m+4|0}while((s|0)<(t|0));l=l+1|0}while((l|0)!=(j|0))}j=c[b+720>>2]|0;if(j|0){if(a[b+724>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[b+720>>2]=0}a[b+724>>0]=1;c[b+720>>2]=d;c[b+716>>2]=e;d=o}else d=o;do{s=c[b+720>>2]|0;c[s+(d*104|0)>>2]=0;s=s+(d*104|0)+4|0;m=z;t=s+100|0;do{c[s>>2]=c[m>>2];s=s+4|0;m=m+4|0}while((s|0)<(t|0));d=d+1|0}while((d|0)!=(e|0))}c[b+712>>2]=e;if((e|0)>0){l=f;w=0;while(1){u=c[b+720>>2]|0;v=u+(w*104|0)|0;s=v;t=s+104|0;do{c[s>>2]=0;s=s+4|0}while((s|0)<(t|0));j=u+(w*104|0)+8|0;if(!l){f=0;d=0;m=0;o=0;n=0.0}else{f=l+16|0;d=c[l>>2]|0;m=c[l+4>>2]|0;o=c[l+8>>2]|0;n=+g[l+12>>2]}c[j>>2]=d;c[u+(w*104|0)+12>>2]=m;c[u+(w*104|0)+16>>2]=o;g[u+(w*104|0)+20>>2]=n;t=u+(w*104|0)+24|0;c[t>>2]=c[j>>2];c[t+4>>2]=c[j+4>>2];c[t+8>>2]=c[j+8>>2];c[t+12>>2]=c[j+12>>2];r=(c[k>>2]=d,+g[k>>2]);q=(c[k>>2]=m,+g[k>>2]);p=(c[k>>2]=o,+g[k>>2]);if(!h){j=0;n=1.0}else{j=h+4|0;n=+g[h>>2]}g[u+(w*104|0)+88>>2]=n>0.0?1.0/n:0.0;d=c[b+932>>2]|0;if(!d){c[6435]=(c[6435]|0)+1;d=yc(63)|0;if(!d)d=0;else{c[(d+4+15&-16)+-4>>2]=d;d=d+4+15&-16}s=d;t=s+44|0;do{c[s>>2]=0;s=s+4|0}while((s|0)<(t|0))}else c[b+932>>2]=0;c[d+32>>2]=0;c[d+36>>2]=v;c[d+40>>2]=0;g[d>>2]=r-y;g[d+4>>2]=q-y;g[d+8>>2]=p-y;g[d+12>>2]=0.0;g[d+16>>2]=y+r;g[d+20>>2]=y+q;g[d+24>>2]=y+p;g[d+28>>2]=0.0;lf(b+928|0,c[b+928>>2]|0,d);c[b+940>>2]=(c[b+940>>2]|0)+1;c[u+(w*104|0)+96>>2]=d;c[u+(w*104|0)+4>>2]=x;w=w+1|0;if((w|0)==(e|0))break;else{h=j;l=f}}}d=c[b+928>>2]|0;if(!d){c[b+892>>2]=0;c[b+892+4>>2]=0;c[b+892+8>>2]=0;c[b+892+12>>2]=0;c[b+892+16>>2]=0;c[b+892+20>>2]=0;c[b+892+24>>2]=0;c[b+892+28>>2]=0;i=z;return}e=c[b+192>>2]|0;q=+Sb[c[(c[e>>2]|0)+48>>2]&15](e);y=+g[d+4>>2]-q;r=+g[d+8>>2]-q;g[b+892>>2]=+g[d>>2]-q;g[b+896>>2]=y;g[b+900>>2]=r;g[b+904>>2]=0.0;r=q+ +g[d+20>>2];y=q+ +g[d+24>>2];g[b+908>>2]=q+ +g[d+16>>2];g[b+912>>2]=r;g[b+916>>2]=y;g[b+920>>2]=0.0;d=c[b+188>>2]|0;if(!d){i=z;return}e=c[b+684>>2]|0;x=c[e+32>>2]|0;yb[c[(c[x>>2]|0)+16>>2]&31](x,d,b+892|0,b+908|0,c[e+36>>2]|0);i=z;return}function Lc(d,f,h){d=d|0;f=f|0;h=h|0;var j=0,k=0,l=0.0,m=0,n=0.0,o=0.0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0,L=0.0,M=0.0,N=0.0;K=i;i=i+112|0;H=c[d+56>>2]|0;if((h-f|0)==1){if(!(a[d+60>>0]|0)){p=(c[d+96>>2]|0)+(H<<6)|0;q=(c[d+76>>2]|0)+(f<<6)|0;r=p+64|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0))}else{J=(c[d+136>>2]|0)+(H<<4)|0;I=(c[d+116>>2]|0)+(f<<4)|0;c[J>>2]=c[I>>2];c[J+4>>2]=c[I+4>>2];c[J+8>>2]=c[I+8>>2];c[J+12>>2]=c[I+12>>2]}c[d+56>>2]=(c[d+56>>2]|0)+1;i=K;return}if((h|0)>(f|0)){m=(a[d+60>>0]|0)==0;if(m){j=c[d+76>>2]|0;k=f;n=0.0;o=0.0;l=0.0;do{n=n+(+g[j+(k<<6)+16>>2]+ +g[j+(k<<6)>>2])*.5;l=l+(+g[j+(k<<6)+20>>2]+ +g[j+(k<<6)+4>>2])*.5;o=o+(+g[j+(k<<6)+24>>2]+ +g[j+(k<<6)+8>>2])*.5;k=k+1|0}while((k|0)!=(h|0))}else{j=c[d+116>>2]|0;s=+g[d+36>>2];t=+g[d+40>>2];u=+g[d+44>>2];x=+g[d+4>>2];y=+g[d+8>>2];z=+g[d+12>>2];k=f;n=0.0;o=0.0;l=0.0;do{n=n+(+(e[j+(k<<4)+6>>1]|0)/s+x+(+(e[j+(k<<4)>>1]|0)/s+x))*.5;l=l+(+(e[j+(k<<4)+8>>1]|0)/t+y+(+(e[j+(k<<4)+2>>1]|0)/t+y))*.5;o=o+(+(e[j+(k<<4)+10>>1]|0)/u+z+(+(e[j+(k<<4)+4>>1]|0)/u+z))*.5;k=k+1|0}while((k|0)!=(h|0))}C=1.0/+(h-f|0);E=C*n;D=C*l;C=C*o;if(m){j=c[d+76>>2]|0;k=f;o=0.0;n=0.0;l=0.0;do{x=(+g[j+(k<<6)+16>>2]+ +g[j+(k<<6)>>2])*.5-E;y=(+g[j+(k<<6)+20>>2]+ +g[j+(k<<6)+4>>2])*.5-D;z=(+g[j+(k<<6)+24>>2]+ +g[j+(k<<6)+8>>2])*.5-C;o=o+x*x;l=l+y*y;n=n+z*z;k=k+1|0}while((k|0)!=(h|0));s=+(h-f|0)}else{j=c[d+116>>2]|0;s=+g[d+36>>2];t=+g[d+40>>2];u=+g[d+44>>2];x=+g[d+4>>2];y=+g[d+8>>2];z=+g[d+12>>2];k=f;o=0.0;n=0.0;l=0.0;do{N=(+(e[j+(k<<4)+6>>1]|0)/s+x+(+(e[j+(k<<4)>>1]|0)/s+x))*.5-E;M=(+(e[j+(k<<4)+8>>1]|0)/t+y+(+(e[j+(k<<4)+2>>1]|0)/t+y))*.5-D;L=(+(e[j+(k<<4)+10>>1]|0)/u+z+(+(e[j+(k<<4)+4>>1]|0)/u+z))*.5-C;o=o+N*N;l=l+M*M;n=n+L*L;k=k+1|0}while((k|0)!=(h|0));s=+(h-f|0)}}else{s=+(h-f|0);o=0.0;n=0.0;l=0.0}N=1.0/(s+-1.0);M=N*o;L=N*l;N=N*n;w=M<L?(L<N?2:1):M<N?2:0;c[K+16>>2]=0;c[K+16+4>>2]=0;c[K+16+8>>2]=0;c[K+16+12>>2]=0;if((h|0)>(f|0)){if(!(a[d+60>>0]|0)){j=c[d+76>>2]|0;o=0.0;n=0.0;l=0.0;k=f;do{o=(+g[j+(k<<6)+16>>2]+ +g[j+(k<<6)>>2])*.5+o;n=(+g[j+(k<<6)+20>>2]+ +g[j+(k<<6)+4>>2])*.5+n;l=(+g[j+(k<<6)+24>>2]+ +g[j+(k<<6)+8>>2])*.5+l;k=k+1|0}while((k|0)!=(h|0))}else{j=c[d+116>>2]|0;s=+g[d+36>>2];t=+g[d+40>>2];u=+g[d+44>>2];x=+g[d+4>>2];y=+g[d+8>>2];z=+g[d+12>>2];o=0.0;n=0.0;l=0.0;k=f;do{o=(+(e[j+(k<<4)+6>>1]|0)/s+x+(+(e[j+(k<<4)>>1]|0)/s+x))*.5+o;n=(+(e[j+(k<<4)+8>>1]|0)/t+y+(+(e[j+(k<<4)+2>>1]|0)/t+y))*.5+n;l=(+(e[j+(k<<4)+10>>1]|0)/u+z+(+(e[j+(k<<4)+4>>1]|0)/u+z))*.5+l;k=k+1|0}while((k|0)!=(h|0))}g[K+16>>2]=o;g[K+16+4>>2]=n;g[K+16+8>>2]=l;j=K+16|0}else{j=K+16|0;o=0.0;n=0.0;l=0.0}g[j>>2]=1.0/+(h-f|0)*o;g[K+16+4>>2]=1.0/+(h-f|0)*n;g[K+16+8>>2]=1.0/+(h-f|0)*l;x=+g[K+16+(w<<2)>>2];if((h|0)>(f|0)){v=f;j=f;do{k=(a[d+60>>0]|0)==0;if(k){G=c[d+76>>2]|0;l=+g[G+(v<<6)>>2];n=+g[G+(v<<6)+16>>2];o=+g[G+(v<<6)+4>>2];s=+g[G+(v<<6)+20>>2];t=+g[G+(v<<6)+8>>2];u=+g[G+(v<<6)+24>>2]}else{G=c[d+116>>2]|0;o=+g[d+36>>2];t=+g[d+40>>2];N=+g[d+44>>2];n=+g[d+4>>2];s=+g[d+8>>2];u=+g[d+12>>2];l=+(e[G+(v<<4)>>1]|0)/o+n;n=+(e[G+(v<<4)+6>>1]|0)/o+n;o=+(e[G+(v<<4)+2>>1]|0)/t+s;s=+(e[G+(v<<4)+8>>1]|0)/t+s;t=+(e[G+(v<<4)+4>>1]|0)/N+u;u=+(e[G+(v<<4)+10>>1]|0)/N+u}g[K>>2]=(n+l)*.5;g[K+4>>2]=(s+o)*.5;g[K+8>>2]=(u+t)*.5;g[K+12>>2]=0.0;if(+g[K+(w<<2)>>2]>x){if(k){k=c[d+76>>2]|0;m=k+(v<<6)|0;p=K+48|0;q=m;r=p+64|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0));p=m;q=k+(j<<6)|0;r=p+64|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0));p=(c[d+76>>2]|0)+(j<<6)|0;q=K+48|0;r=p+64|0;do{c[p>>2]=c[q>>2];p=p+4|0;q=q+4|0}while((p|0)<(r|0))}else{F=c[d+116>>2]|0;G=F+(v<<4)|0;c[K+48>>2]=c[G>>2];c[K+48+4>>2]=c[G+4>>2];c[K+48+8>>2]=c[G+8>>2];c[K+48+12>>2]=c[G+12>>2];F=F+(j<<4)|0;c[G>>2]=c[F>>2];c[G+4>>2]=c[F+4>>2];c[G+8>>2]=c[F+8>>2];c[G+12>>2]=c[F+12>>2];G=(c[d+116>>2]|0)+(j<<4)|0;c[G>>2]=c[K+48>>2];c[G+4>>2]=c[K+48+4>>2];c[G+8>>2]=c[K+48+8>>2];c[G+12>>2]=c[K+48+12>>2]}j=j+1|0}v=v+1|0}while((v|0)!=(h|0))}else j=f;if(!((j|0)>(((h-f|0)/3|0)+f|0)?(j|0)<(h+-1-((h-f|0)/3|0)|0):0))j=(h-f>>1)+f|0;G=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){F=(c[d+96>>2]|0)+(G<<6)|0;c[F>>2]=c[d+20>>2];c[F+4>>2]=c[d+20+4>>2];c[F+8>>2]=c[d+20+8>>2];c[F+12>>2]=c[d+20+12>>2]}else{F=c[d+136>>2]|0;M=(+g[d+24>>2]-+g[d+8>>2])*+g[d+40>>2];N=(+g[d+28>>2]-+g[d+12>>2])*+g[d+44>>2];b[F+(G<<4)>>1]=~~((+g[d+20>>2]-+g[d+4>>2])*+g[d+36>>2])&65534;b[F+(G<<4)+2>>1]=~~M&65534;b[F+(G<<4)+4>>1]=~~N&65534}k=c[d+56>>2]|0;if(!(a[d+60>>0]|0)){F=(c[d+96>>2]|0)+(k<<6)+16|0;c[F>>2]=c[d+4>>2];c[F+4>>2]=c[d+4+4>>2];c[F+8>>2]=c[d+4+8>>2];c[F+12>>2]=c[d+4+12>>2]}else{F=c[d+136>>2]|0;L=+g[d+4>>2];M=+g[d+8>>2];N=+g[d+12>>2];M=(M-M)*+g[d+40>>2];N=(N-N)*+g[d+44>>2];b[F+(k<<4)+6>>1]=~~((L-L)*+g[d+36>>2]+1.0)&65535|1;b[F+(k<<4)+8>>1]=~~(M+1.0)&65535|1;b[F+(k<<4)+10>>1]=~~(N+1.0)&65535|1}F=c[d+56>>2]|0;if((h|0)>(f|0)){A=a[d+60>>0]|0;B=f;do{if(!(A<<24>>24)){k=c[d+76>>2]|0;l=+g[k+(B<<6)>>2];n=+g[k+(B<<6)+4>>2];o=+g[k+(B<<6)+8>>2];s=+g[k+(B<<6)+12>>2];t=+g[k+(B<<6)+16>>2];u=+g[k+(B<<6)+20>>2];x=+g[k+(B<<6)+24>>2];y=+g[k+(B<<6)+28>>2];k=c[d+96>>2]|0;if(l<+g[k+(F<<6)>>2])g[k+(F<<6)>>2]=l;if(n<+g[k+(F<<6)+4>>2])g[k+(F<<6)+4>>2]=n;if(o<+g[k+(F<<6)+8>>2])g[k+(F<<6)+8>>2]=o;if(s<+g[k+(F<<6)+12>>2])g[k+(F<<6)+12>>2]=s;if(+g[k+(F<<6)+16>>2]<t)g[k+(F<<6)+16>>2]=t;if(+g[k+(F<<6)+20>>2]<u)g[k+(F<<6)+20>>2]=u;if(+g[k+(F<<6)+24>>2]<x)g[k+(F<<6)+24>>2]=x;if(+g[k+(F<<6)+28>>2]<y)g[k+(F<<6)+28>>2]=y}else{q=c[d+116>>2]|0;s=+g[d+36>>2];E=+g[d+40>>2];y=+g[d+44>>2];t=+g[d+4>>2];L=+g[d+8>>2];z=+g[d+12>>2];u=+g[d+4>>2];M=+g[d+8>>2];C=+g[d+12>>2];x=+g[d+36>>2];N=+g[d+40>>2];D=+g[d+44>>2];r=~~((+(e[q+(B<<4)>>1]|0)/s+t-u)*x)&65534;k=~~((+(e[q+(B<<4)+4>>1]|0)/y+z-C)*D)&65534;p=~~((+(e[q+(B<<4)+2>>1]|0)/E+L-M)*N)&65534;v=(~~((+(e[q+(B<<4)+6>>1]|0)/s+t-u)*x+1.0)&65535|1)&65535;m=(~~((+(e[q+(B<<4)+10>>1]|0)/y+z-C)*D+1.0)&65535|1)&65535;q=(~~((+(e[q+(B<<4)+8>>1]|0)/E+L-M)*N+1.0)&65535|1)&65535;w=c[d+136>>2]|0;if((e[w+(F<<4)>>1]|0)>(r&65535))b[w+(F<<4)>>1]=r;if((e[w+(F<<4)+6>>1]|0)<(v&65535))b[w+(F<<4)+6>>1]=v;if((e[w+(F<<4)+2>>1]|0)>(p&65535))b[w+(F<<4)+2>>1]=p;if((e[w+(F<<4)+8>>1]|0)<(q&65535))b[w+(F<<4)+8>>1]=q;if((e[w+(F<<4)+4>>1]|0)>(k&65535))b[w+(F<<4)+4>>1]=k;if((e[w+(F<<4)+10>>1]|0)<(m&65535))b[w+(F<<4)+10>>1]=m}B=B+1|0}while((B|0)!=(h|0))}c[d+56>>2]=F+1;Lc(d,f,j);A=c[d+56>>2]|0;Lc(d,j,h);w=(c[d+56>>2]|0)-H|0;j=a[d+60>>0]|0;if(j<<24>>24!=0&(w<<4|0)>2048){r=c[d+136>>2]|0;p=c[r+(F+1<<4)+12>>2]|0;p=(p|0)>-1?1:0-p|0;v=c[r+(A<<4)+12>>2]|0;v=(v|0)>-1?1:0-v|0;if((p<<4|0)<2049){q=c[d+152>>2]|0;if((q|0)==(c[d+156>>2]|0)?(I=q|0?q<<1:1,(q|0)<(I|0)):0){if(!I){j=0;k=q}else{c[6435]=(c[6435]|0)+1;j=yc(I<<5|19)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}k=c[d+152>>2]|0}if((k|0)>0){m=0;do{h=j+(m<<5)|0;H=(c[d+160>>2]|0)+(m<<5)|0;c[h>>2]=c[H>>2];c[h+4>>2]=c[H+4>>2];c[h+8>>2]=c[H+8>>2];c[h+12>>2]=c[H+12>>2];c[h+16>>2]=c[H+16>>2];c[h+20>>2]=c[H+20>>2];c[h+24>>2]=c[H+24>>2];c[h+28>>2]=c[H+28>>2];m=m+1|0}while((m|0)!=(k|0))}k=c[d+160>>2]|0;if(k|0){if(a[d+164>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[k+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=j;c[d+156>>2]=I;j=c[d+152>>2]|0}else j=q;c[d+152>>2]=j+1;I=(c[d+160>>2]|0)+(q<<5)|0;c[I>>2]=c[K+48>>2];c[I+4>>2]=c[K+48+4>>2];c[I+8>>2]=c[K+48+8>>2];c[I+12>>2]=c[K+48+12>>2];c[I+16>>2]=c[K+48+16>>2];c[I+20>>2]=c[K+48+20>>2];c[I+24>>2]=c[K+48+24>>2];c[I+28>>2]=c[K+48+28>>2];I=c[d+160>>2]|0;b[I+(q<<5)>>1]=b[r+(F+1<<4)>>1]|0;b[I+(q<<5)+2>>1]=b[r+(F+1<<4)+2>>1]|0;b[I+(q<<5)+4>>1]=b[r+(F+1<<4)+4>>1]|0;b[I+(q<<5)+6>>1]=b[r+(F+1<<4)+6>>1]|0;b[I+(q<<5)+8>>1]=b[r+(F+1<<4)+8>>1]|0;b[I+(q<<5)+10>>1]=b[r+(F+1<<4)+10>>1]|0;c[I+(q<<5)+12>>2]=F+1;c[I+(q<<5)+16>>2]=p}if((v<<4|0)<2049){p=c[d+152>>2]|0;if((p|0)==(c[d+156>>2]|0)?(J=p|0?p<<1:1,(p|0)<(J|0)):0){if(!J){j=0;k=p}else{c[6435]=(c[6435]|0)+1;j=yc(J<<5|19)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}k=c[d+152>>2]|0}if((k|0)>0){m=0;do{I=j+(m<<5)|0;h=(c[d+160>>2]|0)+(m<<5)|0;c[I>>2]=c[h>>2];c[I+4>>2]=c[h+4>>2];c[I+8>>2]=c[h+8>>2];c[I+12>>2]=c[h+12>>2];c[I+16>>2]=c[h+16>>2];c[I+20>>2]=c[h+20>>2];c[I+24>>2]=c[h+24>>2];c[I+28>>2]=c[h+28>>2];m=m+1|0}while((m|0)!=(k|0))}k=c[d+160>>2]|0;if(k|0){if(a[d+164>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[k+-4>>2]|0)}c[d+160>>2]=0}a[d+164>>0]=1;c[d+160>>2]=j;c[d+156>>2]=J;j=c[d+152>>2]|0}else j=p;c[d+152>>2]=j+1;J=(c[d+160>>2]|0)+(p<<5)|0;c[J>>2]=c[K+16>>2];c[J+4>>2]=c[K+16+4>>2];c[J+8>>2]=c[K+16+8>>2];c[J+12>>2]=c[K+16+12>>2];c[J+16>>2]=c[K+16+16>>2];c[J+20>>2]=c[K+16+20>>2];c[J+24>>2]=c[K+16+24>>2];c[J+28>>2]=c[K+16+28>>2];J=c[d+160>>2]|0;b[J+(p<<5)>>1]=b[r+(A<<4)>>1]|0;b[J+(p<<5)+2>>1]=b[r+(A<<4)+2>>1]|0;b[J+(p<<5)+4>>1]=b[r+(A<<4)+4>>1]|0;b[J+(p<<5)+6>>1]=b[r+(A<<4)+6>>1]|0;b[J+(p<<5)+8>>1]=b[r+(A<<4)+8>>1]|0;b[J+(p<<5)+10>>1]=b[r+(A<<4)+10>>1]|0;c[J+(p<<5)+12>>2]=A;c[J+(p<<5)+16>>2]=v}c[d+168>>2]=c[d+152>>2];j=a[d+60>>0]|0}if(!(j<<24>>24)){c[(c[d+96>>2]|0)+(G<<6)+32>>2]=w;i=K;return}else{c[(c[d+136>>2]|0)+(G<<4)+12>>2]=0-w;i=K;return}}function Mc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0;u=i;i=i+368|0;f=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;kc[c[(c[f>>2]|0)+56>>2]&7](f,b,1.0);f=c[d+4>>2]|0;switch(f|0){case 31:{f=c[d+16>>2]|0;if((f|0)<=0){i=u;return}do{t=f;f=f+-1|0;s=c[d+24>>2]|0;J=+g[s+(f*80|0)>>2];G=+g[s+(f*80|0)+4>>2];D=+g[s+(f*80|0)+8>>2];I=+g[s+(f*80|0)+16>>2];F=+g[s+(f*80|0)+20>>2];B=+g[s+(f*80|0)+24>>2];H=+g[s+(f*80|0)+32>>2];E=+g[s+(f*80|0)+36>>2];z=+g[s+(f*80|0)+40>>2];R=+g[s+(f*80|0)+48>>2];Q=+g[s+(f*80|0)+52>>2];v=+g[s+(f*80|0)+56>>2];s=c[s+(f*80|0)+64>>2]|0;r=c[(c[a>>2]|0)+28>>2]|0;P=+g[b>>2];O=+g[b+4>>2];N=+g[b+8>>2];M=+g[b+16>>2];L=+g[b+20>>2];K=+g[b+24>>2];C=+g[b+32>>2];A=+g[b+36>>2];y=+g[b+40>>2];x=R*P+Q*O+v*N+ +g[b+48>>2];w=R*M+Q*L+v*K+ +g[b+52>>2];v=R*C+Q*A+v*y+ +g[b+56>>2];g[u+288>>2]=J*P+I*O+H*N;g[u+288+4>>2]=G*P+F*O+E*N;g[u+288+8>>2]=D*P+B*O+z*N;g[u+288+12>>2]=0.0;g[u+288+16>>2]=J*M+I*L+H*K;g[u+288+20>>2]=G*M+F*L+E*K;g[u+288+24>>2]=D*M+B*L+z*K;g[u+288+28>>2]=0.0;g[u+288+32>>2]=J*C+I*A+H*y;g[u+288+36>>2]=G*C+F*A+E*y;g[u+288+40>>2]=D*C+B*A+z*y;g[u+288+44>>2]=0.0;g[u+288+48>>2]=x;g[u+288+52>>2]=w;g[u+288+56>>2]=v;g[u+288+60>>2]=0.0;mc[r&127](a,u+288|0,s,e)}while((t|0)>1);i=u;return}case 0:{c[u+352>>2]=c[d+28>>2];c[u+352+4>>2]=c[d+28+4>>2];c[u+352+8>>2]=c[d+28+8>>2];c[u+352+12>>2]=c[d+28+12>>2];P=+Sb[c[(c[d>>2]|0)+48>>2]&15](d);Q=+Sb[c[(c[d>>2]|0)+48>>2]&15](d);R=+Sb[c[(c[d>>2]|0)+48>>2]&15](d);P=P+ +g[u+352>>2];g[u+352>>2]=P;Q=Q+ +g[u+352+4>>2];g[u+352+4>>2]=Q;R=R+ +g[u+352+8>>2];g[u+352+8>>2]=R;a=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;d=c[(c[a>>2]|0)+72>>2]|0;g[u+272>>2]=-P;g[u+272+4>>2]=-Q;g[u+272+8>>2]=-R;g[u+272+12>>2]=0.0;yb[d&31](a,u+272|0,u+352|0,b,e);i=u;return}case 8:{R=+Sb[c[(c[d>>2]|0)+48>>2]&15](d);a=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Hb[c[(c[a>>2]|0)+16>>2]&0](a,R,b,e);i=u;return}case 9:{f=c[d+92>>2]|0;if((f|0)<=0){i=u;return}do{t=f;f=f+-1|0;s=c[d+100>>2]|0;D=+g[s+(f<<4)>>2];E=+g[s+(f<<4)+4>>2];Q=+g[s+(f<<4)+8>>2];s=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;r=c[(c[s>>2]|0)+16>>2]|0;R=+g[(c[d+120>>2]|0)+(f<<2)>>2];G=+g[b>>2];H=+g[b+4>>2];F=+g[b+8>>2];J=+g[b+16>>2];K=+g[b+20>>2];I=+g[b+24>>2];M=+g[b+32>>2];N=+g[b+36>>2];L=+g[b+40>>2];O=D*G+E*H+Q*F+ +g[b+48>>2];P=D*J+E*K+Q*I+ +g[b+52>>2];Q=D*M+E*N+Q*L+ +g[b+56>>2];g[u+192>>2]=G+H*0.0+F*0.0;g[u+192+4>>2]=G*0.0+H+F*0.0;g[u+192+8>>2]=F+(G*0.0+H*0.0);g[u+192+12>>2]=0.0;g[u+192+16>>2]=J+K*0.0+I*0.0;g[u+192+20>>2]=J*0.0+K+I*0.0;g[u+192+24>>2]=I+(J*0.0+K*0.0);g[u+192+28>>2]=0.0;g[u+192+32>>2]=M+N*0.0+L*0.0;g[u+192+36>>2]=M*0.0+N+L*0.0;g[u+192+40>>2]=L+(M*0.0+N*0.0);g[u+192+44>>2]=0.0;g[u+192+48>>2]=O;g[u+192+52>>2]=P;g[u+192+56>>2]=Q;g[u+192+60>>2]=0.0;Hb[r&0](s,R,u+192|0,e)}while((t|0)>1);i=u;return}case 10:{t=c[d+52>>2]|0;Q=+g[d+28+(((t+2|0)%3|0)<<2)>>2];R=+g[d+28+(t<<2)>>2];a=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Gb[c[(c[a>>2]|0)+76>>2]&0](a,Q,R,t,b,e);i=u;return}case 11:{Q=+g[d+56>>2];R=+g[d+60>>2];d=c[d+68>>2]|0;a=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Gb[c[(c[a>>2]|0)+84>>2]&0](a,Q,R,d,b,e);i=u;return}case 13:{t=c[d+52>>2]|0;Q=+Sb[c[(c[d>>2]|0)+92>>2]&15](d);c[u+80>>2]=c[d+28>>2];c[u+80+4>>2]=c[d+28+4>>2];c[u+80+8>>2]=c[d+28+8>>2];c[u+80+12>>2]=c[d+28+12>>2];O=+Sb[c[(c[d>>2]|0)+48>>2]&15](d);P=+Sb[c[(c[d>>2]|0)+48>>2]&15](d);R=+Sb[c[(c[d>>2]|0)+48>>2]&15](d);g[u+80>>2]=O+ +g[u+80>>2];g[u+80+4>>2]=P+ +g[u+80+4>>2];g[u+80+8>>2]=R+ +g[u+80+8>>2];R=+g[u+80+(t<<2)>>2];a=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Gb[c[(c[a>>2]|0)+80>>2]&0](a,Q,R,t,b,e);i=u;return}case 28:{R=+g[d+64>>2];a=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;Vb[c[(c[a>>2]|0)+88>>2]&0](a,d+48|0,R,b,e);i=u;return}default:{a:do if((f|0)<7){q=c[d+52>>2]|0;if(!q){if((Eb[c[(c[d>>2]|0)+100>>2]&127](d)|0)<=0)break;f=0;while(1){mc[c[(c[d>>2]|0)+104>>2]&127](d,f,u+352|0,u+256|0);P=+g[u+352>>2];D=+g[b>>2];N=+g[u+352+4>>2];E=+g[b+4>>2];L=+g[u+352+8>>2];F=+g[b+8>>2];H=+g[b+16>>2];I=+g[b+20>>2];J=+g[b+24>>2];M=+g[b+32>>2];O=+g[b+36>>2];Q=+g[b+40>>2];G=+g[b+48>>2];K=+g[b+52>>2];R=+g[b+56>>2];g[u+96>>2]=P*D+N*E+L*F+G;g[u+96+4>>2]=P*H+N*I+L*J+K;g[u+96+8>>2]=P*M+N*O+L*Q+R;g[u+96+12>>2]=0.0;L=+g[u+256>>2];N=+g[u+256+4>>2];P=+g[u+256+8>>2];g[u+64>>2]=L*D+N*E+P*F+G;g[u+64+4>>2]=L*H+N*I+P*J+K;g[u+64+8>>2]=L*M+N*O+P*Q+R;g[u+64+12>>2]=0.0;t=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;mc[c[(c[t>>2]|0)+8>>2]&127](t,u+96|0,u+64|0,e);f=f+1|0;if((f|0)>=(Eb[c[(c[d>>2]|0)+100>>2]&127](d)|0))break a}}if((c[q+28>>2]|0)>0){s=0;do{f=c[q+36>>2]|0;r=c[f+(s*36|0)+4>>2]|0;b:do if((r|0)!=0?(t=c[f+(s*36|0)+12>>2]|0,(r|0)>0):0){m=t;j=0;h=0;f=0;o=c[t+(r+-1<<2)>>2]|0;l=0;while(1){p=c[m+(l<<2)>>2]|0;n=c[q+16>>2]|0;j=(g[k>>2]=(c[k>>2]=j,+g[k>>2])+ +g[n+(p<<4)>>2],c[k>>2]|0);f=(g[k>>2]=(c[k>>2]=f,+g[k>>2])+ +g[n+(p<<4)+4>>2],c[k>>2]|0);h=(g[k>>2]=(c[k>>2]=h,+g[k>>2])+ +g[n+(p<<4)+8>>2],c[k>>2]|0);n=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;m=c[(c[n>>2]|0)+8>>2]|0;S=c[q+16>>2]|0;P=+g[S+(o<<4)>>2];D=+g[b>>2];N=+g[S+(o<<4)+4>>2];E=+g[b+4>>2];L=+g[S+(o<<4)+8>>2];F=+g[b+8>>2];H=+g[b+16>>2];I=+g[b+20>>2];J=+g[b+24>>2];M=+g[b+32>>2];O=+g[b+36>>2];Q=+g[b+40>>2];G=+g[b+48>>2];K=+g[b+52>>2];R=+g[b+56>>2];g[u+48>>2]=P*D+N*E+L*F+G;g[u+48+4>>2]=P*H+N*I+L*J+K;g[u+48+8>>2]=P*M+N*O+L*Q+R;g[u+48+12>>2]=0.0;L=+g[S+(p<<4)>>2];N=+g[S+(p<<4)+4>>2];P=+g[S+(p<<4)+8>>2];g[u+32>>2]=L*D+N*E+P*F+G;g[u+32+4>>2]=L*H+N*I+P*J+K;g[u+32+8>>2]=L*M+N*O+P*Q+R;g[u+32+12>>2]=0.0;mc[m&127](n,u+48|0,u+32|0,e);n=l+1|0;l=c[q+36>>2]|0;if((n|0)>=(c[l+(s*36|0)+4>>2]|0))break b;m=c[l+(s*36|0)+12>>2]|0;o=p;l=n}}else{j=0;h=0;f=0}while(0);S=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;if((Eb[c[(c[S>>2]|0)+48>>2]&127](S)|0)&16384|0){O=1.0/+(r|0)*(c[k>>2]=h,+g[k>>2]);L=1.0/+(r|0)*(c[k>>2]=f,+g[k>>2]);I=1.0/+(r|0)*(c[k>>2]=j,+g[k>>2]);c[u+352>>2]=1065353216;c[u+352+4>>2]=1065353216;c[u+352+8>>2]=0;g[u+352+12>>2]=0.0;S=c[q+36>>2]|0;J=+g[S+(s*36|0)+20>>2];M=+g[S+(s*36|0)+24>>2];P=+g[S+(s*36|0)+28>>2];S=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;r=c[(c[S>>2]|0)+8>>2]|0;A=+g[b>>2];B=+g[b+4>>2];C=+g[b+8>>2];E=+g[b+16>>2];F=+g[b+20>>2];G=+g[b+24>>2];K=+g[b+32>>2];N=+g[b+36>>2];Q=+g[b+40>>2];D=+g[b+48>>2];H=+g[b+52>>2];R=+g[b+56>>2];g[u+16>>2]=I*A+L*B+O*C+D;g[u+16+4>>2]=I*E+L*F+O*G+H;g[u+16+8>>2]=I*K+L*N+O*Q+R;g[u+16+12>>2]=0.0;g[u>>2]=(I+J)*A+(L+M)*B+(O+P)*C+D;g[u+4>>2]=(I+J)*E+(L+M)*F+(O+P)*G+H;g[u+8>>2]=(I+J)*K+(L+M)*N+(O+P)*Q+R;g[u+12>>2]=0.0;mc[r&127](S,u+16|0,u,u+352|0)}s=s+1|0}while((s|0)<(c[q+28>>2]|0))}}while(0);f=c[d+4>>2]|0;if((f+-21|0)>>>0<9){c[u+352>>2]=1566444395;c[u+352+4>>2]=1566444395;c[u+352+8>>2]=1566444395;g[u+352+12>>2]=0.0;c[u+256>>2]=-581039253;c[u+256+4>>2]=-581039253;c[u+256+8>>2]=-581039253;g[u+256+12>>2]=0.0;f=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;c[u+96>>2]=5692;c[u+96+4>>2]=5716;c[u+96+8>>2]=f;c[u+96+12>>2]=c[e>>2];c[u+96+12+4>>2]=c[e+4>>2];c[u+96+12+8>>2]=c[e+8>>2];c[u+96+12+12>>2]=c[e+12>>2];c[u+96+28>>2]=c[b>>2];c[u+96+28+4>>2]=c[b+4>>2];c[u+96+28+8>>2]=c[b+8>>2];c[u+96+28+12>>2]=c[b+12>>2];c[u+96+44>>2]=c[b+16>>2];c[u+96+44+4>>2]=c[b+16+4>>2];c[u+96+44+8>>2]=c[b+16+8>>2];c[u+96+44+12>>2]=c[b+16+12>>2];c[u+96+60>>2]=c[b+32>>2];c[u+96+60+4>>2]=c[b+32+4>>2];c[u+96+60+8>>2]=c[b+32+8>>2];c[u+96+60+12>>2]=c[b+32+12>>2];c[u+96+76>>2]=c[b+48>>2];c[u+96+76+4>>2]=c[b+48+4>>2];c[u+96+76+8>>2]=c[b+48+8>>2];c[u+96+76+12>>2]=c[b+48+12>>2];mc[c[(c[d>>2]|0)+64>>2]&127](d,u+96|0,u+256|0,u+352|0);f=c[d+4>>2]|0}if((f|0)!=3){i=u;return}c[u+352>>2]=1566444395;c[u+352+4>>2]=1566444395;c[u+352+8>>2]=1566444395;g[u+352+12>>2]=0.0;c[u+256>>2]=-581039253;c[u+256+4>>2]=-581039253;c[u+256+8>>2]=-581039253;g[u+256+12>>2]=0.0;S=Eb[c[(c[a>>2]|0)+20>>2]&127](a)|0;c[u+96>>2]=5692;c[u+96+4>>2]=5716;c[u+96+8>>2]=S;c[u+96+12>>2]=c[e>>2];c[u+96+12+4>>2]=c[e+4>>2];c[u+96+12+8>>2]=c[e+8>>2];c[u+96+12+12>>2]=c[e+12>>2];c[u+96+28>>2]=c[b>>2];c[u+96+28+4>>2]=c[b+4>>2];c[u+96+28+8>>2]=c[b+8>>2];c[u+96+28+12>>2]=c[b+12>>2];c[u+96+44>>2]=c[b+16>>2];c[u+96+44+4>>2]=c[b+16+4>>2];c[u+96+44+8>>2]=c[b+16+8>>2];c[u+96+44+12>>2]=c[b+16+12>>2];c[u+96+60>>2]=c[b+32>>2];c[u+96+60+4>>2]=c[b+32+4>>2];c[u+96+60+8>>2]=c[b+32+8>>2];c[u+96+60+12>>2]=c[b+32+12>>2];c[u+96+76>>2]=c[b+48>>2];c[u+96+76+4>>2]=c[b+48+4>>2];c[u+96+76+8>>2]=c[b+48+8>>2];c[u+96+76+12>>2]=c[b+48+12>>2];S=c[d+92>>2]|0;mc[c[(c[S>>2]|0)+8>>2]&127](S,u+96+4|0,u+256|0,u+352|0);i=u;return}}}function Nc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0.0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;t=i;i=i+48|0;z=1.0/+g[a+108>>2];A=1.0/+g[a+112>>2];B=1.0/+g[a+116>>2];u=+g[a+48>>2];v=z*+g[d>>2]+u;o=+g[a+52>>2];k=A*+g[d+4>>2]+o;q=+g[a+56>>2];p=B*+g[d+8>>2]+q;u=z*+g[e>>2]+u;o=A*+g[e+4>>2]+o;q=B*+g[e+8>>2]+q;B=+g[a+16>>2];v=v<B?B:v;A=+g[a+20>>2];k=k<A?A:k;z=+g[a+24>>2];p=p<z?z:p;y=+g[a+32>>2];v=y<v?y:v;x=+g[a+36>>2];k=x<k?x:k;w=+g[a+40>>2];p=w<p?w:p;u=u<B?B:u;o=o<A?A:o;q=q<z?z:q;u=y<u?y:u;o=x<o?x:o;q=w<q?w:q;m=~~(v+(v<0.0?-.5:.5))+-1|0;f=~~(u+(u<0.0?-.5:.5))+1|0;n=~~(k+(k<0.0?-.5:.5))+-1|0;h=~~(o+(o<0.0?-.5:.5))+1|0;l=~~(p+(p<0.0?-.5:.5))+-1|0;e=~~(q+(q<0.0?-.5:.5))+1|0;j=(c[a+64>>2]|0)+-1|0;d=(c[a+68>>2]|0)+-1|0;switch(c[a+104>>2]|0){case 0:{d=(e|0)<(d|0)?e:d;j=(h|0)<(j|0)?h:j;e=(l|0)>0?l:0;r=(n|0)>0?n:0;break}case 1:{d=(e|0)<(d|0)?e:d;j=(f|0)<(j|0)?f:j;e=(l|0)>0?l:0;r=(m|0)>0?m:0;break}case 2:{d=(h|0)<(d|0)?h:d;j=(f|0)<(j|0)?f:j;e=(n|0)>0?n:0;r=(m|0)>0?m:0;break}default:{e=0;r=0}}if((e|0)>=(d|0)){i=t;return}n=(r|0)<(j|0);m=e;while(1){if(n){l=(m&1|0)==0;e=m+1|0;q=+(m|0);h=r;while(1){f=c[a+100>>2]|0;do if(!((f&255)<<24>>24)){if(f&65280|0?(h+m&1|0)==0:0){s=16;break}if(!(l&(f&16711680|0)!=0)){k=+_b[c[(c[a>>2]|0)+68>>2]&15](a,h,m);switch(c[a+104>>2]|0){case 0:{k=k-+g[a+48>>2];o=+(h|0)-+g[a+80>>2]*.5;p=q-+g[a+84>>2]*.5;g[t>>2]=k;g[t+4>>2]=o;g[t+8>>2]=p;g[t+12>>2]=0.0;break}case 1:{B=+(h|0)-+g[a+80>>2]*.5;o=k-+g[a+52>>2];p=q-+g[a+84>>2]*.5;g[t>>2]=B;g[t+4>>2]=o;g[t+8>>2]=p;g[t+12>>2]=0.0;k=B;break}case 2:{B=+(h|0)-+g[a+80>>2]*.5;o=q-+g[a+84>>2]*.5;p=k-+g[a+56>>2];g[t>>2]=B;g[t+4>>2]=o;g[t+8>>2]=p;g[t+12>>2]=0.0;k=B;break}default:{k=+g[t>>2];o=+g[t+4>>2];p=+g[t+8>>2]}}g[t>>2]=k*+g[a+108>>2];g[t+4>>2]=o*+g[a+112>>2];g[t+8>>2]=p*+g[a+116>>2];k=+_b[c[(c[a>>2]|0)+68>>2]&15](a,h,e);switch(c[a+104>>2]|0){case 0:{k=k-+g[a+48>>2];o=+(h|0)-+g[a+80>>2]*.5;p=+(e|0)-+g[a+84>>2]*.5;g[t+16>>2]=k;g[t+20>>2]=o;g[t+24>>2]=p;g[t+28>>2]=0.0;break}case 1:{B=+(h|0)-+g[a+80>>2]*.5;o=k-+g[a+52>>2];p=+(e|0)-+g[a+84>>2]*.5;g[t+16>>2]=B;g[t+20>>2]=o;g[t+24>>2]=p;g[t+28>>2]=0.0;k=B;break}case 2:{B=+(h|0)-+g[a+80>>2]*.5;o=+(e|0)-+g[a+84>>2]*.5;p=k-+g[a+56>>2];g[t+16>>2]=B;g[t+20>>2]=o;g[t+24>>2]=p;g[t+28>>2]=0.0;k=B;break}default:{k=+g[t+16>>2];o=+g[t+20>>2];p=+g[t+24>>2]}}g[t+16>>2]=k*+g[a+108>>2];g[t+20>>2]=o*+g[a+112>>2];g[t+24>>2]=p*+g[a+116>>2];f=h+1|0;k=+_b[c[(c[a>>2]|0)+68>>2]&15](a,f,m);switch(c[a+104>>2]|0){case 0:{k=k-+g[a+48>>2];o=+(f|0)-+g[a+80>>2]*.5;p=q-+g[a+84>>2]*.5;g[t+32>>2]=k;g[t+36>>2]=o;g[t+40>>2]=p;g[t+44>>2]=0.0;break}case 1:{B=+(f|0)-+g[a+80>>2]*.5;o=k-+g[a+52>>2];p=q-+g[a+84>>2]*.5;g[t+32>>2]=B;g[t+36>>2]=o;g[t+40>>2]=p;g[t+44>>2]=0.0;k=B;break}case 2:{B=+(f|0)-+g[a+80>>2]*.5;o=q-+g[a+84>>2]*.5;p=k-+g[a+56>>2];g[t+32>>2]=B;g[t+36>>2]=o;g[t+40>>2]=p;g[t+44>>2]=0.0;k=B;break}default:{k=+g[t+32>>2];o=+g[t+36>>2];p=+g[t+40>>2]}}g[t+32>>2]=k*+g[a+108>>2];g[t+36>>2]=o*+g[a+112>>2];g[t+40>>2]=p*+g[a+116>>2];mc[c[(c[b>>2]|0)+8>>2]&127](b,t,h,m);k=+_b[c[(c[a>>2]|0)+68>>2]&15](a,f,m);switch(c[a+104>>2]|0){case 0:{k=k-+g[a+48>>2];o=+(f|0)-+g[a+80>>2]*.5;p=q-+g[a+84>>2]*.5;g[t>>2]=k;g[t+4>>2]=o;g[t+8>>2]=p;g[t+12>>2]=0.0;break}case 1:{B=+(f|0)-+g[a+80>>2]*.5;o=k-+g[a+52>>2];p=q-+g[a+84>>2]*.5;g[t>>2]=B;g[t+4>>2]=o;g[t+8>>2]=p;g[t+12>>2]=0.0;k=B;break}case 2:{B=+(f|0)-+g[a+80>>2]*.5;o=q-+g[a+84>>2]*.5;p=k-+g[a+56>>2];g[t>>2]=B;g[t+4>>2]=o;g[t+8>>2]=p;g[t+12>>2]=0.0;k=B;break}default:{k=+g[t>>2];o=+g[t+4>>2];p=+g[t+8>>2]}}g[t>>2]=k*+g[a+108>>2];g[t+4>>2]=o*+g[a+112>>2];g[t+8>>2]=p*+g[a+116>>2];k=+_b[c[(c[a>>2]|0)+68>>2]&15](a,f,e);switch(c[a+104>>2]|0){case 0:{k=k-+g[a+48>>2];o=+(f|0)-+g[a+80>>2]*.5;p=+(e|0)-+g[a+84>>2]*.5;g[t+32>>2]=k;g[t+36>>2]=o;g[t+40>>2]=p;g[t+44>>2]=0.0;break}case 1:{B=+(f|0)-+g[a+80>>2]*.5;o=k-+g[a+52>>2];p=+(e|0)-+g[a+84>>2]*.5;g[t+32>>2]=B;g[t+36>>2]=o;g[t+40>>2]=p;g[t+44>>2]=0.0;k=B;break}case 2:{B=+(f|0)-+g[a+80>>2]*.5;o=+(e|0)-+g[a+84>>2]*.5;p=k-+g[a+56>>2];g[t+32>>2]=B;g[t+36>>2]=o;g[t+40>>2]=p;g[t+44>>2]=0.0;k=B;break}default:{k=+g[t+32>>2];o=+g[t+36>>2];p=+g[t+40>>2]}}g[t+32>>2]=k*+g[a+108>>2];g[t+36>>2]=o*+g[a+112>>2];g[t+40>>2]=p*+g[a+116>>2];mc[c[(c[b>>2]|0)+8>>2]&127](b,t,h,m)}else s=16}else s=16;while(0);if((s|0)==16){s=0;k=+_b[c[(c[a>>2]|0)+68>>2]&15](a,h,m);switch(c[a+104>>2]|0){case 0:{k=k-+g[a+48>>2];o=+(h|0)-+g[a+80>>2]*.5;p=q-+g[a+84>>2]*.5;g[t>>2]=k;g[t+4>>2]=o;g[t+8>>2]=p;g[t+12>>2]=0.0;break}case 1:{B=+(h|0)-+g[a+80>>2]*.5;o=k-+g[a+52>>2];p=q-+g[a+84>>2]*.5;g[t>>2]=B;g[t+4>>2]=o;g[t+8>>2]=p;g[t+12>>2]=0.0;k=B;break}case 2:{B=+(h|0)-+g[a+80>>2]*.5;o=q-+g[a+84>>2]*.5;p=k-+g[a+56>>2];g[t>>2]=B;g[t+4>>2]=o;g[t+8>>2]=p;g[t+12>>2]=0.0;k=B;break}default:{k=+g[t>>2];o=+g[t+4>>2];p=+g[t+8>>2]}}g[t>>2]=k*+g[a+108>>2];g[t+4>>2]=o*+g[a+112>>2];g[t+8>>2]=p*+g[a+116>>2];f=h+1|0;k=+_b[c[(c[a>>2]|0)+68>>2]&15](a,f,m);switch(c[a+104>>2]|0){case 0:{k=k-+g[a+48>>2];o=+(f|0)-+g[a+80>>2]*.5;p=q-+g[a+84>>2]*.5;g[t+16>>2]=k;g[t+20>>2]=o;g[t+24>>2]=p;g[t+28>>2]=0.0;break}case 1:{B=+(f|0)-+g[a+80>>2]*.5;o=k-+g[a+52>>2];p=q-+g[a+84>>2]*.5;g[t+16>>2]=B;g[t+20>>2]=o;g[t+24>>2]=p;g[t+28>>2]=0.0;k=B;break}case 2:{B=+(f|0)-+g[a+80>>2]*.5;o=q-+g[a+84>>2]*.5;p=k-+g[a+56>>2];g[t+16>>2]=B;g[t+20>>2]=o;g[t+24>>2]=p;g[t+28>>2]=0.0;k=B;break}default:{k=+g[t+16>>2];o=+g[t+20>>2];p=+g[t+24>>2]}}g[t+16>>2]=k*+g[a+108>>2];g[t+20>>2]=o*+g[a+112>>2];g[t+24>>2]=p*+g[a+116>>2];k=+_b[c[(c[a>>2]|0)+68>>2]&15](a,f,e);switch(c[a+104>>2]|0){case 0:{k=k-+g[a+48>>2];o=+(f|0)-+g[a+80>>2]*.5;p=+(e|0)-+g[a+84>>2]*.5;g[t+32>>2]=k;g[t+36>>2]=o;g[t+40>>2]=p;g[t+44>>2]=0.0;break}case 1:{B=+(f|0)-+g[a+80>>2]*.5;o=k-+g[a+52>>2];p=+(e|0)-+g[a+84>>2]*.5;g[t+32>>2]=B;g[t+36>>2]=o;g[t+40>>2]=p;g[t+44>>2]=0.0;k=B;break}case 2:{B=+(f|0)-+g[a+80>>2]*.5;o=+(e|0)-+g[a+84>>2]*.5;p=k-+g[a+56>>2];g[t+32>>2]=B;g[t+36>>2]=o;g[t+40>>2]=p;g[t+44>>2]=0.0;k=B;break}default:{k=+g[t+32>>2];o=+g[t+36>>2];p=+g[t+40>>2]}}g[t+32>>2]=k*+g[a+108>>2];g[t+36>>2]=o*+g[a+112>>2];g[t+40>>2]=p*+g[a+116>>2];mc[c[(c[b>>2]|0)+8>>2]&127](b,t,h,m);k=+_b[c[(c[a>>2]|0)+68>>2]&15](a,f,e);switch(c[a+104>>2]|0){case 0:{k=k-+g[a+48>>2];o=+(f|0)-+g[a+80>>2]*.5;p=+(e|0)-+g[a+84>>2]*.5;g[t+16>>2]=k;g[t+20>>2]=o;g[t+24>>2]=p;g[t+28>>2]=0.0;break}case 1:{B=+(f|0)-+g[a+80>>2]*.5;o=k-+g[a+52>>2];p=+(e|0)-+g[a+84>>2]*.5;g[t+16>>2]=B;g[t+20>>2]=o;g[t+24>>2]=p;g[t+28>>2]=0.0;k=B;break}case 2:{B=+(f|0)-+g[a+80>>2]*.5;o=+(e|0)-+g[a+84>>2]*.5;p=k-+g[a+56>>2];g[t+16>>2]=B;g[t+20>>2]=o;g[t+24>>2]=p;g[t+28>>2]=0.0;k=B;break}default:{k=+g[t+16>>2];o=+g[t+20>>2];p=+g[t+24>>2]}}g[t+16>>2]=k*+g[a+108>>2];g[t+20>>2]=o*+g[a+112>>2];g[t+24>>2]=p*+g[a+116>>2];k=+_b[c[(c[a>>2]|0)+68>>2]&15](a,h,e);switch(c[a+104>>2]|0){case 0:{k=k-+g[a+48>>2];o=+(h|0)-+g[a+80>>2]*.5;p=+(e|0)-+g[a+84>>2]*.5;g[t+32>>2]=k;g[t+36>>2]=o;g[t+40>>2]=p;g[t+44>>2]=0.0;break}case 1:{B=+(h|0)-+g[a+80>>2]*.5;o=k-+g[a+52>>2];p=+(e|0)-+g[a+84>>2]*.5;g[t+32>>2]=B;g[t+36>>2]=o;g[t+40>>2]=p;g[t+44>>2]=0.0;k=B;break}case 2:{B=+(h|0)-+g[a+80>>2]*.5;o=+(e|0)-+g[a+84>>2]*.5;p=k-+g[a+56>>2];g[t+32>>2]=B;g[t+36>>2]=o;g[t+40>>2]=p;g[t+44>>2]=0.0;k=B;break}default:{k=+g[t+32>>2];o=+g[t+36>>2];p=+g[t+40>>2]}}g[t+32>>2]=k*+g[a+108>>2];g[t+36>>2]=o*+g[a+112>>2];g[t+40>>2]=p*+g[a+116>>2];mc[c[(c[b>>2]|0)+8>>2]&127](b,t,h,m)}if((f|0)==(j|0))break;else h=f}}else e=m+1|0;if((e|0)==(d|0))break;else m=e}i=t;return}function Oc(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0.0,fa=0.0,ga=0.0,ha=0.0,ia=0.0,ja=0.0,ka=0.0,la=0.0,ma=0.0,na=0.0,oa=0.0,pa=0;da=i;i=i+176|0;aa=c[d+4>>2]|0;ba=c[e+4>>2]|0;if((c[aa+68>>2]|0)==(c[b+40>>2]|0)?(c[ba+68>>2]|0)==(c[b+44>>2]|0):0)$=b+8|0;else{j=c[b+8>>2]|0;k=c[j+8>>2]|0;if((k|0)>0){m=0;do{l=c[(c[j+16>>2]|0)+(m*12|0)+8>>2]|0;if(l|0){Ab[c[c[l>>2]>>2]&255](l);$=c[b+4>>2]|0;Cb[c[(c[$>>2]|0)+60>>2]&127]($,l)}m=m+1|0}while((m|0)!=(k|0));j=c[b+8>>2]|0}$h(j);$=b+8|0}a[da+128+16>>0]=1;q=da+128+12|0;c[q>>2]=0;c[da+128+4>>2]=0;c[da+128+8>>2]=0;p=c[$>>2]|0;j=c[p+8>>2]|0;if((j|0)>0){o=0;do{k=c[(c[p+16>>2]|0)+(o*12|0)+8>>2]|0;if(k){Cb[c[(c[k>>2]|0)+16>>2]&127](k,da+128|0);j=c[da+128+4>>2]|0;if((j|0)>0){n=0;do{m=c[(c[q>>2]|0)+(n<<2)>>2]|0;if(c[m+748>>2]|0){c[h+4>>2]=m;j=c[m+740>>2]|0;k=c[(c[h+8>>2]|0)+8>>2]|0;l=c[(c[h+12>>2]|0)+8>>2]|0;if((j|0)==(k|0))ef(m,j+4|0,l+4|0);else ef(m,l+4|0,k+4|0);c[h+4>>2]=0;j=c[da+128+4>>2]|0}n=n+1|0}while((n|0)<(j|0))}if((j|0)<0){if((c[da+128+8>>2]|0)<0){k=c[q>>2]|0;if(k|0){if(a[da+128+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[k+-4>>2]|0)}c[q>>2]=0}a[da+128+16>>0]=1;c[q>>2]=0;c[da+128+8>>2]=0}do{c[(c[q>>2]|0)+(j<<2)>>2]=0;j=j+1|0}while((j|0)!=0)}c[da+128+4>>2]=0;j=c[p+8>>2]|0}o=o+1|0}while((o|0)<(j|0));j=c[q>>2]|0;if(j|0){if(a[da+128+16>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[q>>2]=0}}k=c[aa+64>>2]|0;l=c[ba+64>>2]|0;p=c[b+4>>2]|0;q=c[$>>2]|0;r=c[b+32>>2]|0;c[da+128>>2]=6256;c[da+128+4>>2]=0;c[da+128+8>>2]=d;c[da+128+12>>2]=e;c[da+128+16>>2]=p;c[da+128+20>>2]=f;c[da+128+24>>2]=h;c[da+128+28>>2]=q;c[da+128+32>>2]=r;r=c[d+12>>2]|0;B=+g[r>>2];C=+g[r+16>>2];D=+g[r+32>>2];E=+g[r+4>>2];F=+g[r+20>>2];G=+g[r+36>>2];H=+g[r+8>>2];I=+g[r+24>>2];J=+g[r+40>>2];K=-+g[r+48>>2];L=-+g[r+52>>2];M=-+g[r+56>>2];r=c[e+12>>2]|0;O=+g[r>>2];P=+g[r+16>>2];Q=+g[r+32>>2];R=+g[r+4>>2];S=+g[r+20>>2];T=+g[r+36>>2];U=+g[r+8>>2];V=+g[r+24>>2];W=+g[r+40>>2];X=+g[r+48>>2];Y=+g[r+52>>2];Z=+g[r+56>>2];k=c[k>>2]|0;l=c[l>>2]|0;if((k|0)!=0&(l|0)!=0){c[6435]=(c[6435]|0)+1;j=yc(1043)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}c[j>>2]=k;c[j+4>>2]=l;s=+N(+(B*O+C*P+D*Q));t=+N(+(B*R+C*S+D*T));u=+N(+(B*U+C*V+D*W));v=+N(+(E*O+F*P+G*Q));w=+N(+(E*R+F*S+G*T));x=+N(+(E*U+F*V+G*W));y=+N(+(H*O+I*P+J*Q));z=+N(+(H*R+I*S+J*T));A=+N(+(H*U+I*V+J*W));r=1;l=128;m=128;k=124;while(1){q=r+-1|0;f=c[j+(q<<3)>>2]|0;h=c[j+(q<<3)+4>>2]|0;oa=+g[h+16>>2];na=+g[h>>2];ma=+g[h+20>>2];la=+g[h+4>>2];ka=+g[h+24>>2];ea=+g[h+8>>2];ja=B*K+C*L+D*M+(B*X+C*Y+D*Z)+((B*O+C*P+D*Q)*(oa+na)*.5+(B*R+C*S+D*T)*(ma+la)*.5+(B*U+C*V+D*W)*(ka+ea)*.5);ha=E*K+F*L+G*M+(E*X+F*Y+G*Z)+((E*O+F*P+G*Q)*(oa+na)*.5+(E*R+F*S+G*T)*(ma+la)*.5+(E*U+F*V+G*W)*(ka+ea)*.5);fa=H*K+I*L+J*M+(H*X+I*Y+J*Z)+((H*O+I*P+J*Q)*(oa+na)*.5+(H*R+I*S+J*T)*(ma+la)*.5+(H*U+I*V+J*W)*(ka+ea)*.5);ia=((oa-na)*.5+0.0)*s+((ma-la)*.5+0.0)*t+((ka-ea)*.5+0.0)*u;ga=((oa-na)*.5+0.0)*v+((ma-la)*.5+0.0)*w+((ka-ea)*.5+0.0)*x;ea=((oa-na)*.5+0.0)*y+((ma-la)*.5+0.0)*z+((ka-ea)*.5+0.0)*A;do if(((((+g[f>>2]<=ia+ja?+g[f+16>>2]>=ja-ia:0)?+g[f+4>>2]<=ha+ga:0)?+g[f+20>>2]>=ha-ga:0)?+g[f+8>>2]<=fa+ea:0)?+g[f+24>>2]>=fa-ea:0){if((q|0)>(k|0)){n=m<<1;do if((m|0)<(n|0)&(l|0)<(n|0)){do if(!m){k=0;_=52}else{c[6435]=(c[6435]|0)+1;k=yc((m<<4|3)+16|0)|0;if(!k)k=0;else{c[(k+4+15&-16)+-4>>2]=k;k=k+4+15&-16}if((m|0)>0)l=0;else{_=52;break}do{pa=j+(l<<3)|0;o=c[pa+4>>2]|0;p=k+(l<<3)|0;c[p>>2]=c[pa>>2];c[p+4>>2]=o;l=l+1|0}while((l|0)!=(m|0))}while(0);if((_|0)==52){_=0;if(!j){l=n;j=k;break}}c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0);l=n;j=k}while(0);p=n;k=n+-4|0}else p=m;m=(c[h+40>>2]|0)!=0;if(!(c[f+40>>2]|0))if(m){n=c[h+36>>2]|0;c[j+(q<<3)>>2]=f;c[j+(q<<3)+4>>2]=n;n=c[h+40>>2]|0;c[j+(r<<3)>>2]=f;c[j+(r<<3)+4>>2]=n;n=r+1|0;m=p;break}else{ic[c[(c[da+128>>2]|0)+8>>2]&127](da+128|0,f,h);n=q;m=p;break}else{n=j+(q<<3)|0;o=c[f+36>>2]|0;if(m){m=c[h+36>>2]|0;c[n>>2]=o;c[j+(q<<3)+4>>2]=m;m=r+1|0;n=c[h+36>>2]|0;c[j+(r<<3)>>2]=c[f+40>>2];c[j+(r<<3)+4>>2]=n;n=r+2|0;pa=c[h+40>>2]|0;c[j+(m<<3)>>2]=c[f+36>>2];c[j+(m<<3)+4>>2]=pa;m=c[h+40>>2]|0;c[j+(n<<3)>>2]=c[f+40>>2];c[j+(n<<3)+4>>2]=m;n=r+3|0;m=p;break}else{c[n>>2]=o;c[j+(q<<3)+4>>2]=h;c[j+(r<<3)>>2]=c[f+40>>2];c[j+(r<<3)+4>>2]=h;n=r+1|0;m=p;break}}}else n=q;while(0);if(!n)break;else r=n}if(j|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}}o=c[$>>2]|0;if((c[o+8>>2]|0)>0){p=0;do{j=c[o+16>>2]|0;k=c[j+(p*12|0)+8>>2]|0;do if(k|0){pa=c[j+(p*12|0)>>2]|0;_=c[aa+24>>2]|0;r=c[_+(pa*80|0)+64>>2]|0;h=c[d+12>>2]|0;oa=+g[h>>2];P=+g[h+4>>2];O=+g[h+8>>2];la=+g[h+16>>2];ja=+g[h+20>>2];ha=+g[h+24>>2];ka=+g[h+32>>2];ga=+g[h+36>>2];U=+g[h+40>>2];fa=+g[_+(pa*80|0)>>2];ea=+g[_+(pa*80|0)+16>>2];Z=+g[_+(pa*80|0)+32>>2];Y=+g[_+(pa*80|0)+4>>2];X=+g[_+(pa*80|0)+20>>2];W=+g[_+(pa*80|0)+36>>2];ia=+g[_+(pa*80|0)+8>>2];V=+g[_+(pa*80|0)+24>>2];T=+g[_+(pa*80|0)+40>>2];na=+g[_+(pa*80|0)+48>>2];ma=+g[_+(pa*80|0)+52>>2];Q=+g[_+(pa*80|0)+56>>2];S=+g[h+48>>2]+(oa*na+P*ma+O*Q);R=+g[h+52>>2]+(la*na+ja*ma+ha*Q);Q=+g[h+56>>2]+(ka*na+ga*ma+U*Q);g[da>>2]=oa*fa+P*ea+O*Z;g[da+4>>2]=oa*Y+P*X+O*W;g[da+8>>2]=oa*ia+P*V+O*T;g[da+12>>2]=0.0;g[da+16>>2]=la*fa+ja*ea+ha*Z;g[da+20>>2]=la*Y+ja*X+ha*W;g[da+24>>2]=la*ia+ja*V+ha*T;g[da+28>>2]=0.0;g[da+32>>2]=ka*fa+ga*ea+U*Z;g[da+36>>2]=ka*Y+ga*X+U*W;g[da+40>>2]=ka*ia+ga*V+U*T;g[da+44>>2]=0.0;g[da+48>>2]=S;g[da+52>>2]=R;g[da+56>>2]=Q;g[da+60>>2]=0.0;mc[c[(c[r>>2]|0)+8>>2]&127](r,da,da+112|0,da+96|0);r=c[(c[o+16>>2]|0)+(p*12|0)+4>>2]|0;h=c[ba+24>>2]|0;pa=c[h+(r*80|0)+64>>2]|0;_=c[e+12>>2]|0;Q=+g[_>>2];R=+g[_+4>>2];S=+g[_+8>>2];T=+g[_+16>>2];U=+g[_+20>>2];V=+g[_+24>>2];ga=+g[_+32>>2];ia=+g[_+36>>2];ka=+g[_+40>>2];W=+g[h+(r*80|0)>>2];X=+g[h+(r*80|0)+16>>2];Y=+g[h+(r*80|0)+32>>2];Z=+g[h+(r*80|0)+4>>2];ea=+g[h+(r*80|0)+20>>2];fa=+g[h+(r*80|0)+36>>2];ha=+g[h+(r*80|0)+8>>2];ja=+g[h+(r*80|0)+24>>2];la=+g[h+(r*80|0)+40>>2];O=+g[h+(r*80|0)+48>>2];P=+g[h+(r*80|0)+52>>2];oa=+g[h+(r*80|0)+56>>2];ma=+g[_+48>>2]+(Q*O+R*P+S*oa);na=+g[_+52>>2]+(T*O+U*P+V*oa);oa=+g[_+56>>2]+(ga*O+ia*P+ka*oa);g[da>>2]=Q*W+R*X+S*Y;g[da+4>>2]=Q*Z+R*ea+S*fa;g[da+8>>2]=Q*ha+R*ja+S*la;g[da+12>>2]=0.0;g[da+16>>2]=T*W+U*X+V*Y;g[da+20>>2]=T*Z+U*ea+V*fa;g[da+24>>2]=T*ha+U*ja+V*la;g[da+28>>2]=0.0;g[da+32>>2]=ga*W+ia*X+ka*Y;g[da+36>>2]=ga*Z+ia*ea+ka*fa;g[da+40>>2]=ga*ha+ia*ja+ka*la;g[da+44>>2]=0.0;g[da+48>>2]=ma;g[da+52>>2]=na;g[da+56>>2]=oa;g[da+60>>2]=0.0;mc[c[(c[pa>>2]|0)+8>>2]&127](pa,da,da+80|0,da+64|0);if(!(+g[da+112>>2]>+g[da+64>>2])?!(+g[da+96>>2]<+g[da+80>>2]):0)j=1;else j=0;if(!(!(+g[da+112+8>>2]>+g[da+64+8>>2])?!(+g[da+96+8>>2]<+g[da+80+8>>2]):0))j=0;if(!(+g[da+112+4>>2]>+g[da+64+4>>2])?!(+g[da+96+4>>2]<+g[da+80+4>>2]|j^1):0)break;Ab[c[c[k>>2]>>2]&255](k);n=c[b+4>>2]|0;Cb[c[(c[n>>2]|0)+60>>2]&127](n,k);n=c[o+16>>2]|0;m=c[n+(p*12|0)>>2]|0;n=c[n+(p*12|0)+4>>2]|0;j=c[b+16>>2]|0;if((j|0)==(c[b+20>>2]|0)?(ca=j|0?j<<1:1,(j|0)<(ca|0)):0){if(!ca)l=0;else{c[6435]=(c[6435]|0)+1;j=yc((ca*12|3)+16|0)|0;if(!j)j=0;else{c[(j+4+15&-16)+-4>>2]=j;j=j+4+15&-16}l=j;j=c[b+16>>2]|0}if((j|0)>0){k=0;do{pa=l+(k*12|0)|0;_=(c[b+24>>2]|0)+(k*12|0)|0;c[pa>>2]=c[_>>2];c[pa+4>>2]=c[_+4>>2];c[pa+8>>2]=c[_+8>>2];k=k+1|0}while((k|0)!=(j|0))}j=c[b+24>>2]|0;if(j|0){if(a[b+28>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[b+24>>2]=0}a[b+28>>0]=1;c[b+24>>2]=l;c[b+20>>2]=ca;j=c[b+16>>2]|0}pa=c[b+24>>2]|0;c[pa+(j*12|0)>>2]=m;c[pa+(j*12|0)+4>>2]=n;c[pa+(j*12|0)+8>>2]=0;c[b+16>>2]=(c[b+16>>2]|0)+1}while(0);p=p+1|0}while((p|0)<(c[o+8>>2]|0));k=b+24|0;l=b+16|0}else{k=b+24|0;l=b+16|0}if((c[l>>2]|0)>0){j=0;do{e=c[$>>2]|0;pa=c[k>>2]|0;Ob[c[(c[e>>2]|0)+8>>2]&63](e,c[pa+(j*12|0)>>2]|0,c[pa+(j*12|0)+4>>2]|0)|0;j=j+1|0}while((j|0)<(c[l>>2]|0))}j=c[k>>2]|0;if(!j){a[b+28>>0]=1;c[k>>2]=0;c[l>>2]=0;pa=b+20|0;c[pa>>2]=0;i=da;return}if(a[b+28>>0]|0){c[6436]=(c[6436]|0)+1;hd(c[j+-4>>2]|0)}c[k>>2]=0;a[b+28>>0]=1;c[k>>2]=0;c[l>>2]=0;pa=b+20|0;c[pa>>2]=0;i=da;return}function Pc(b,e,f,h,j,l,m){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;l=l|0;m=m|0;var n=0.0,o=0.0,p=0.0,q=0,r=0,s=0.0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0;B=i;i=i+9856|0;q=l;r=q+36|0;do{c[q>>2]=0;q=q+4|0}while((q|0)<(r|0));c[B+9712>>2]=b;c[B+9712+4>>2]=f;E=+g[h>>2];R=+g[e>>2];F=+g[h+16>>2];H=+g[e+16>>2];G=+g[h+32>>2];S=+g[e+32>>2];I=+g[e+4>>2];T=+g[e+20>>2];J=+g[e+36>>2];s=+g[e+8>>2];n=+g[e+24>>2];D=+g[e+40>>2];Q=+g[h+4>>2];P=+g[h+20>>2];N=+g[h+36>>2];M=+g[h+8>>2];L=+g[h+24>>2];K=+g[h+40>>2];g[B+9712+8>>2]=E*R+F*H+G*S;g[B+9712+12>>2]=E*I+F*T+G*J;g[B+9712+16>>2]=E*s+F*n+G*D;g[B+9712+20>>2]=0.0;g[B+9712+24>>2]=R*Q+H*P+S*N;g[B+9712+28>>2]=I*Q+T*P+J*N;g[B+9712+32>>2]=s*Q+n*P+D*N;g[B+9712+36>>2]=0.0;g[B+9712+40>>2]=R*M+H*L+S*K;g[B+9712+44>>2]=I*M+T*L+J*K;g[B+9712+48>>2]=s*M+n*L+D*K;g[B+9712+52>>2]=0.0;D=+g[h+48>>2]-+g[e+48>>2];n=+g[h+52>>2]-+g[e+52>>2];s=+g[h+56>>2]-+g[e+56>>2];J=+g[e>>2];T=+g[h>>2];I=+g[e+16>>2];S=+g[h+16>>2];H=+g[e+32>>2];R=+g[h+32>>2];G=+g[e+4>>2];F=+g[e+20>>2];E=+g[e+36>>2];C=+g[e+8>>2];o=+g[e+24>>2];p=+g[e+40>>2];g[B+9712+56>>2]=J*T+I*S+H*R;g[B+9712+60>>2]=J*Q+I*P+H*N;g[B+9712+64>>2]=J*M+I*L+H*K;g[B+9712+68>>2]=0.0;g[B+9712+72>>2]=T*G+S*F+R*E;g[B+9712+76>>2]=Q*G+P*F+N*E;g[B+9712+80>>2]=M*G+L*F+K*E;g[B+9712+84>>2]=0.0;g[B+9712+88>>2]=T*C+S*o+R*p;g[B+9712+92>>2]=Q*C+P*o+N*p;g[B+9712+96>>2]=M*C+L*o+K*p;g[B+9712+100>>2]=0.0;g[B+9712+104>>2]=D*J+n*I+s*H;g[B+9712+108>>2]=D*G+n*F+s*E;g[B+9712+112>>2]=D*C+n*o+s*p;g[B+9712+116>>2]=0.0;c[B+9712+120>>2]=m?81:80;c[B+9712+124>>2]=0;c[B+9328+364>>2]=0;c[B+9328+128>>2]=0;c