/**
 * Configuration object for the template engine.
 *
 * @typedef {object} Configuration
 * @property {Array<Dialect>} dialects
 *   A list of dialects to include with this instance of the template engine.
 * @property {object} [isomorphic]
 *   An object which configures the isomorphic capabilities of the template
 *   engine.
 * @property {Function} messageResolver
 *   A function for building a message string from some external source, given a
 *   message key and optional parameters for that particular message.
 * @property {Function} templateResolver
 *   A function for returning the text of templates named by fragment
 *   expressions in templates.  Is given only 1 argument, the template name from
 *   a fragment expression, and should return a Promise of the template text.
 */
/**
 * Default configuration for the template engine, configures the standard
 * dialect with no options (uses `thjs` as the prefix).
 *
 * @type {Configuration}
 */
export const DEFAULT_CONFIGURATION: Configuration;
/**
 * Standard configuration, configures the standard dialect with the `th` prefix
 * and enables isomorphic mode which enables the ability to use much of the same
 * processors across original Thymeleaf and ThymeleafJS.
 *
 * @type {Configuration}
 */
export const STANDARD_CONFIGURATION: Configuration;
/**
 * Configuration object for the template engine.
 */
export type Configuration = {
    /**
     *   A list of dialects to include with this instance of the template engine.
     */
    dialects: Array<Dialect>;
    /**
     * An object which configures the isomorphic capabilities of the template
     * engine.
     */
    isomorphic?: object;
    /**
     *   A function for building a message string from some external source, given a
     *   message key and optional parameters for that particular message.
     */
    messageResolver: Function;
    /**
     *   A function for returning the text of templates named by fragment
     *   expressions in templates.  Is given only 1 argument, the template name from
     *   a fragment expression, and should return a Promise of the template text.
     */
    templateResolver: Function;
};
