/**
 * A highly-configurable class responsible for processing the Thymeleaf
 * directives found in HTML documents and fragments.
 *
 * @author Emanuel Rabina
 */
export default class TemplateEngine {
    /**
     * Constructor, set up a new template engine instance.
     *
     * @param {object} [config]
     * @param config.dialects
     * @param config.messageResolver
     * @param config.templateResolver
     */
    constructor({ dialects, messageResolver, templateResolver }?: {
        dialects: any;
        messageResolver: any;
        templateResolver: any;
    });
    messageResolver: any;
    templateResolver: any;
    expressionProcessor: ExpressionProcessor;
    fragmentSignatureProcessor: ExpressionProcessor;
    processors: any;
    expressionObjects: any;
    /**
     * Process the Thymeleaf template data, returning the processed template.
     *
     * @param {string} template
     * @param {object} [context]
     * @return {Promise<string>}
     *   A promise resolved with the processed template, or rejected with an error
     *   message.
     */
    process(template: string, context?: object): Promise<string>;
    /**
     * Process the Thymeleaf template at the given path, returning a promise of
     * the processed template.
     *
     * @param {string} filePath
     * @param {object} [context]
     * @return {Promise<string>}
     *   A promise of the processed template.  The promise is immediately rejected
     *   if this method is called in a browser environment.
     */
    processFile(filePath: string, context?: object): Promise<string>;
    /**
     * Process a DOM element.
     *
     * @private
     * @param {Element} element
     * @param {object} [context]
     * @return {Promise<boolean>} Whether or not the parent node needs
     *   reprocessing.
     */
    private processNode;
}
import ExpressionProcessor from './standard/expressions/ExpressionProcessor.js';
