/**
 * Common class for dialects.
 *
 * @author Emanuel Rabina
 */
export default class Dialect {
    /**
     * Constructor, sets this dialect's name and optional prefix.
     *
     * @param {string} name
     * @param {string} [prefix]
     */
    constructor(name: string, prefix?: string);
    name: string;
    prefix: string;
    /**
     * Return an object whose keys are the expression object names, the values the
     * expression object available properties and methods.
     *
     * @return {object}
     */
    get expressionObjects(): any;
    /**
     * Return an array of processors.
     *
     * @return {Array}
     */
    get processors(): any[];
}
