/**
 * A collection of Rules that describes a language.
 *
 * @author Emanuel Rabina
 */
export default class Grammar {
    /**
     * @param {string} name
     * @param {Rule} startingRule
     * @param {...Rule} additionalRules
     */
    constructor(name: string, startingRule: Rule, ...additionalRules: Rule[]);
    name: string;
    rules: any[];
    /**
     * Given an input string and a parser, return whether or not the input is
     * accepted by this grammar.
     *
     * @param {InputBuffer} input
     * @param {Parser} parser
     * @return {object} If the input is accepted, this will be the non-null result
     *   of matching against the rules of this grammar.
     */
    accept(input: InputBuffer, parser: Parser): object;
    /**
     * Return the rule that has the given name.
     *
     * @param {string} name
     * @return {Rule}
     */
    findRuleByName(name: string): Rule;
    /**
     * Returns the grammar's starting rule.
     *
     * @return {Rule}
     */
    get startingRule(): Rule;
}
