/**
 * Wrapper around the string being parsed, with a position that keeps track of
 * what part of the imput is currently being read/tested.
 *
 * @author Emanuel Rabina
 */
export default class InputBuffer {
    /**
     * @param {string} input
     */
    constructor(input: string);
    /**
     * @private
     * @type {number}
     */
    private position;
    /**
     * @private
     * @type {Array<number>}
     */
    private positionStack;
    input: string;
    /**
     * Clear the previously {@link #mark}ed position.
     */
    clear(): void;
    /**
     * Returns whether or not the current position is at the end of the input,
     * meaning we've exhausted the entire input string.
     *
     * @return {boolean}
     */
    exhausted(): boolean;
    /**
     * Sets a mark at the current position so that it can be returned to by a
     * matching {@link #reset} call.
     */
    mark(): void;
    /**
     * Convenience method for surrounding a function with a call to {@link #mark},
     * then {@link #clear} if the result of the function is non-null, or
     * {@link #reset} if `null`.
     *
     * @template T
     * @param {Function<T>} func
     * @return {T}
     */
    markAndClearOrReset<T>(func: Function): T;
    /**
     * Reads as many characters from the current position as satisfies the given
     * pattern, returning the read characters and advancing the mark by as many
     * characters.
     *
     * @param {RegExp} pattern
     * @return {Array} The array of matched strings, or `null` if the pattern
     *   didn't match.
     */
    read(pattern: RegExp): any[];
    /**
     * Revert to the last @{link #mark}ed position.
     */
    reset(): void;
}
