/**
 * Any one of the objects that can be matched:
 *  - an expression function
 *  - a string that references another rule
 *  - a regular expression
 *
 * @typedef {string | RegExp | Function} Matchable
 */
/**
 * A recursive descent parser for any parsing expression grammar defined by the
 * constructs in this module.
 *
 * TODO: Own module?
 *
 * @author Emanuel Rabina
 */
export default class Parser {
    /**
     * @param {Grammar} grammar
     */
    constructor(grammar: Grammar);
    expressionStack: any[];
    grammar: Grammar;
    /**
     * Parse a string, attempting to build the parse tree defined by the rules in
     * the configured grammar.  Parsing is considered successful when there are no
     * more non-terminating symbols in the grammar and all of the input has been
     * read.
     *
     * @param {string} input
     * @return {object} The parse tree if the input could be parsed, `null`
     *   otherwise.
     */
    parse(input: string): object;
    /**
     * Parse the input against the given expression.  An expression can either be
     * a reference to another rule in the current grammar, or a regular expression
     * that consumes input.
     *
     * @param {InputBuffer} input
     * @param {Matchable} expression
     * @return {object}
     */
    parseWithExpression(input: InputBuffer, expression: Matchable): object;
    /**
     * Surrounds a function that evaluates an expression with tracking it against
     * the current stack.  Useful for knowing how the current expression was
     * arrived at through the grammar's rules.
     *
     * @template T
     * @param {InputBuffer} input
     * @param {Matchable} expression
     * @param {string} name
     * @param {Function<T>} func
     * @return {T}
     */
    trackExpression<T>(input: InputBuffer, expression: Matchable, name: string, func: Function): T;
}
/**
 * Any one of the objects that can be matched:
 *  - an expression function
 *  - a string that references another rule
 *  - a regular expression
 */
export type Matchable = string | RegExp | Function;
import InputBuffer from './InputBuffer';
