/**
 * A rule describes a string in the language.
 *
 * @author Emanuel Rabina
 */
export default class Rule {
    /**
     * @param {string} name
     * @param {object} expression
     * @param {Function} [matchProcessor]
     */
    constructor(name: string, expression: object, matchProcessor?: Function);
    name: string;
    expression: any;
    matchProcessor: Function;
    /**
     * Given an input string and a parser, return whether or not the input is
     * accepted by this rule.
     *
     * @param {InputBuffer} input
     * @param {Parser} parser
     * @return {object} If the input is accepted, this will be the non-null result
     *   of matching against the rule.
     */
    accept(input: InputBuffer, parser: Parser): object;
}
