/**
 * Common class for attribute processors.
 *
 * @author Emanuel Rabina
 */
export default class AttributeProcessor {
    /**
     * Constructor, sets this processor's prefix and name.
     *
     * @param {string} prefix
     * @param {string} name
     * @param {object} [isomorphic]
     */
    constructor(prefix: string, name: string, isomorphic?: object);
    prefix: string;
    name: string;
    isomorphic: any;
    /**
     * Process the given attribute on the element it appears.
     *
     * @param {Element} element
     *   Element being processed.
     * @param {string} attribute
     *   The attribute that was encountered to invoke this processor.
     * @param {string} attributeValue
     *   The value given by the attribute.
     * @param {object} context
     * @return {boolean} Whether or not the parent tree needs reprocessing because
     *   of modifications made by the processor.
     */
    process(element: Element, attribute: string, attributeValue: string, context: object): boolean;
}
