/**
 * Parent class for element processors.
 *
 * @author Emanuel Rabina
 */
export default class ElementProcessor {
    /**
     * Constructor, sets this processor's prefix and name.
     *
     * @param {string} prefix
     * @param {string} name
     */
    constructor(prefix: string, name: string);
    prefix: string;
    name: string;
    /**
     * Processes the given element.
     *
     * @param {Element} element
     *   Element being processed.
     * @param {object} context
     * @return {boolean} Whether or not the parent tree needs reprocessing because
     *   of modifications made by the processor.
     */
    process(element: Element, context: object): boolean;
}
