/**
 * Class for determining if an element contains a processor on it.
 *
 * @author Emanuel Rabina
 */
export default class Matcher {
    /**
     * Return the matching attribute or element that a processor can work over.
     *
     * @param {Element} element
     * @param {AttributeProcessor} processor
     * @return {string}
     *   A match result containing what was matched (either an attribute or an
     *   element, relevant to the processor being tested), or `null` if nothing
     *   was matched.
     */
    matches(element: Element, processor: AttributeProcessor): string;
}
import AttributeProcessor from './AttributeProcessor.js';
