/**
 * Parses and executes Thymeleaf expressions.
 *
 * TODO: Create a shared instance of this for a processing context so that it
 *       doesn't need to be recreated over and over.
 *
 * @author Emanuel Rabina
 */
export default class ExpressionProcessor {
    /**
     * Constructor, create a new processor that can parse/execute a string in the
     * given grammar.
     *
     * @param {Grammar} grammar
     */
    constructor(grammar: Grammar);
    parser: Parser;
    /**
     * Parse and execute the given input as a Thymeleaf expression.
     *
     * @param {string} input
     * @param {object} [context]
     * @return {*}
     */
    process(input: string, context?: object): any;
}
import Parser from '../../parser/Parser.js';
