export const NAME: "checked";
/**
 * Thymeleaf's `th:checked` attribute processor, sets or removes the `checked`
 * attribute from an element based on the result of the expression within it.
 *
 * TODO: This is one of HTML5s "boolean attributes", attributes whose values are
 *       true simply by being present in the element, regardless of the value
 *       inside it.  To act as false, the attribute has to be removed.  Find a
 *       way to generate these from some list of boolean attributes so that I
 *       don't need to write a class for each one!
 *
 * @author Emanuel Rabina
 */
export default class CheckedAttributeProcessor extends AttributeProcessor {
    /**
     * Constructor, set this processor to use the `checked` name and supplied
     * prefix.
     *
     * @param {string} prefix
     * @param {object} [isomorphic]
     */
    constructor(prefix: string, isomorphic?: object);
}
import AttributeProcessor from '../../processors/AttributeProcessor.js';
