export const NAME: "each";
/**
 * JS equivalent of Thymeleaf's `th:each` attribute processor, iterates over an
 * [iterable object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols),
 * executing a piece of template for every iteration.
 *
 * @author Emanuel Rabina
 */
export default class EachAttributeProcessor extends AttributeProcessor {
    /**
     * Constructor, set this processor to use the `each` name and supplied prefix.
     *
     * @param {string} prefix
     * @param {object} [isomorphic]
     */
    constructor(prefix: string, isomorphic?: object);
}
import AttributeProcessor from '../../processors/AttributeProcessor.js';
