/**
 * Create and return a new HTML fragment using JSDOM from the given string.
 * Used for tests.
 *
 * @param {string} htmlString
 * @return {Element}
 */
export function createHtml(htmlString: string): Element;
/**
 * Returns the value of a Thymeleaf attribute processor.
 *
 * @param {Element} element
 * @param {string} prefix
 * @param {string} processorName
 * @return {string} The value of the Thymeleaf attribute processor, or `null`
 *   if the attribute processor wasn't present.
 */
export function getThymeleafAttributeValue(element: Element, prefix: string, processorName: string): string;
/**
 * Use either JSDOM or the browser's native DOM parsing to deserialize the HTML
 * string into a document fragment.
 *
 * @param {string} htmlString
 * @return {DocumentFragment}
 */
export function deserialize(htmlString: string): DocumentFragment;
/**
 * Use either JSDOM or the browser's native DOM serialization to serialize a
 * document fragment into an HTML string.
 *
 * @param {DocumentFragment} documentFragment
 * @return {string}
 */
export function serialize(documentFragment: DocumentFragment): string;
export const NODE_TYPE_DOCUMENT_TYPE: 10;
export const NODE_TYPE_ELEMENT: 1;
