/* eslint-disable import/no-extraneous-dependencies */

const chalk = require('chalk');
const semver = require('semver');
const packageConfig = require('../package.json');

function exec(cmd) {
	return require('child_process').execSync(cmd).toString().trim();
}

const versionRequirements = [
	{
		name: 'node',
		currentVersion: semver.clean(process.version),
		versionRequirement: packageConfig.engines.node,
	},
	{
		name: 'npm',
		currentVersion: exec('npm --version'),
		versionRequirement: packageConfig.engines.npm,
	},
];

module.exports = () => {
	const warnings = [];
	for (let i = 0; i < versionRequirements.length; i += 1) {
		const mod = versionRequirements[i];
		if (!semver.satisfies(mod.currentVersion, mod.versionRequirement)) {
			warnings.push(
				`${mod.name}: ${chalk.red(mod.currentVersion)} should be`
				+ ` ${chalk.green(mod.versionRequirement)}` // eslint-disable-line comma-dangle
			);
		}
	}

	if (warnings.length) {
		/* eslint-disable no-console */
		console.log('');
		console.log(chalk.yellow('To use this template, you must update following to modules:'));
		console.log();
		for (let i = 0; i < warnings.length; i += 1) {
			const warning = warnings[i];
			console.log(`\t${warning}`);
		}
		console.log();
		process.exit(1);
	}
};

