# TIFY User Guide

## Introduction

TIFY is a slim and mobile-friendly IIIF document viewer, created with performance and usability in mind.

IIIF, which stands for “International Image Interoperability Framework”, defines a set of standardized <acronym title="application programming interface">API</acronym>s for describing and delivering images along with presentational and structural metadata over the web. This allows digitized artworks, books, newspapers, manuscripts, maps, scrolls, and archival materials to be shared between institutions and repositories. Any IIIF-compliant application can consume and display those images and metadata. [Get more information about IIIF.](http://iiif.io/about/)

## Viewing Multiple Pages

Any number of pages can be viewed next to each other.

Open the pages view and select multiple pages by clicking on them while pressing <kbd>Ctrl</kbd> &ndash; or long-press if you are using a touch screen.

## Key Bindings

TIFY can be fully controlled via keyboard.

### View

| Action | Key |
| --- | :---: |
| Fulltext (if available) | <kbd>1</kbd> |
| Pages | <kbd>2</kbd> |
| Contents (if available) | <kbd>3</kbd> |
| Info | <kbd>4</kbd> |
| Export | <kbd>5</kbd> |
| Collection (if available) | <kbd>6</kbd> |
| Help | <kbd>7</kbd> |
| Scan | <kbd>Backspace</kbd> |
| Toggle fullscreen | <kbd>F</kbd> |

### Turning Pages

| Action | Key |
| --- | :---: |
| Previous page | <kbd>Q</kbd> or <kbd>,</kbd> |
| Next page | <kbd>E</kbd> or <kbd>.</kbd> |
| First page | <kbd>&#8679;Q</kbd> |
| Last page | <kbd>&#8679;E</kbd> |
| Jump to page | <kbd>X</kbd> |
| Toggle double-page | <kbd>B</kbd> |

### Scan

| Action | Key |
| --- | :---: |
| Pan | <kbd>W</kbd> <kbd>S</kbd> <kbd>A</kbd> <kbd>D</kbd> |
| Zoom in | <kbd>&#8679;W</kbd> or <kbd>+</kbd> |
| Zoom out | <kbd>&#8679;S</kbd> or <kbd>-</kbd> |
| Rotate (90 degrees clockwise) | <kbd>R</kbd> |
| Toggle filters | <kbd>I</kbd> |
| Reset pan and zoom | <kbd>0</kbd> |
| Reset rotation | <kbd>&#8679;</kbd> + <kbd>R</kbd> |
| Reset filters | <kbd>&#8679;</kbd> + </kbd>I</kbd> |
| Reset all | <kbd>&#8679;</kbd> + <kbd>0</kbd> |
