describe('Pagination', () => {
	const currentPage = '.tify-page-select-button';

	it('changes the page via buttons', () => {
		cy.visit('/?manifest=http://localhost:8081/manifest/gdz-HANS_DE_7_w042081&tify={"pages":[15]}');

		cy.contains(currentPage, '15 : 7r');

		cy.get('[title="First page"]').first().click();
		cy.contains(currentPage, '1 :  -');

		cy.get('[title="Next page"]').first().click().click();
		cy.contains(currentPage, '3 : 1r');

		cy.get('[title="Next section"]').first().click().click();
		cy.contains(currentPage, '7 : 3r');

		cy.get('[title="Last page"]').first().click();
		cy.contains(currentPage, '69 :  -');

		cy.get('[title="Previous section"]').first()
			.click()
			.click()
			.click()
			.click();
		cy.contains('16 : 7v');

		cy.get('[title="Toggle double-page"]').first().click();
		cy.get('[title="Toggle double-page"].-active');
	});

	it('changes the page via keyboard', () => {
		cy.visit('/?manifest=http://localhost:8081/manifest/gdz-HANS_DE_7_w042081&tify={"pages":[15]}');

		cy.contains(currentPage, '15 : 7r');

		cy.get('.tify').type('q');
		cy.contains(currentPage, '14 : 6v');
		cy.get('.tify').type('e');
		cy.contains(currentPage, '15 : 7r');

		cy.get('.tify').type('b');
		cy.contains(currentPage, '14 : 6v');
		cy.get('[title="Toggle double-page"].-active');

		cy.get('.tify').type('q');
		cy.contains(currentPage, '12 : 5v');
		cy.get('.tify').type(',');
		cy.contains(currentPage, '10 : 4v');

		cy.get('.tify').type('e');
		cy.contains(currentPage, '12 : 5v');
		cy.get('.tify').type('.');
		cy.contains(currentPage, '14 : 6v');

		cy.get('.tify').type('Q');
		cy.contains(currentPage, '1 :  -');

		cy.get('.tify').type('E');
		cy.contains(currentPage, '68 :  -');

		cy.get('.tify').type('b');
		cy.contains(currentPage, '68 :  -');
		cy.get('[title="Toggle double-page"]:not(.-active)');

		cy.get('.tify').type('Q');
		cy.contains(currentPage, '1 :  -');

		cy.get('.tify').type('E');
		cy.contains(currentPage, '69 :  -');
	});

	it('highlights the current page after a page change', () => {
		cy.visit('/?manifest=http://localhost:8081/manifest/gdz-HANS_DE_7_w042081');
		cy.get('[title="Last page"]').first().click();
		cy.get('[aria-label="Current page"]').first().click();
		cy.contains('.-current.-highlighted', '69 :  -');
	});
});
