import Component from "./component";
import { AreaPointsModel, CircleModel, CircleResponderModel, LinePointsModel, AreaSeriesModels, RectResponderModel, MouseEventType } from "../../types/components/series";
import { AreaChartOptions, AreaSeriesDataType, AreaSeriesType, LineTypeEventDetectType, LineAreaChartOptions, LineAreaChartSeriesOptions, LineTypeSeriesOptions, Point, BezierPoint } from "../../types/options";
import { ClipRectAreaModel } from "../../types/components/series";
import { ChartState, StackSeriesData, ValueEdge } from "../../types/store/store";
import { TooltipData } from "../../types/components/tooltip";
import { PointDataLabel } from "../../types/components/dataLabels";
import { AreaChartSeriesTheme } from "../../types/theme";
import { SelectSeriesInfo } from "../../types/charts";
interface RenderOptions {
    pointOnColumn: boolean;
    options: LineTypeSeriesOptions;
    tickDistance: number;
    tickCount: number;
    areaStackSeries?: StackSeriesData<'area'>;
    pairModel?: boolean;
}
export default class AreaSeries extends Component {
    models: AreaSeriesModels;
    drawModels: AreaSeriesModels;
    theme: Required<AreaChartSeriesTheme>;
    responders: CircleResponderModel[] | RectResponderModel[];
    activatedResponders: CircleResponderModel[] | RectResponderModel[];
    eventDetectType: LineTypeEventDetectType;
    tooltipCircleMap: Record<string, CircleResponderModel[]>;
    linePointsModel: LinePointsModel[];
    baseYPosition: number;
    isStackChart: boolean;
    isRangeChart: boolean;
    isSplineChart: boolean;
    startIndex: number;
    initialize(): void;
    initUpdate(delta: number): void;
    getBaseYPosition(limit: ValueEdge): number;
    getStackValue(areaStackSeries: StackSeriesData<'area'>, seriesIndex: number, index: number): number;
    private setEventDetectType;
    getAreaOptions(options: AreaChartOptions | LineAreaChartOptions): {
        series?: import("../../types/options").AreaSeriesOptions | undefined;
        xAxis?: import("../../types/options").LineTypeXAxisOptions | undefined;
        yAxis?: import("../../types/options").YAxisOptions | import("../../types/options").YAxisOptions[] | undefined;
        plot?: import("../../types/options").LineTypePlotOptions | undefined;
        legend?: import("../../types/options").NormalLegendOptions | undefined;
        theme?: import("../../types/theme").AreaChartThemeOptions | undefined;
        chart?: import("../../types/options").BaseChartOptions | undefined;
        lang?: import("../../types/options").LangOptions | undefined;
        exportMenu?: import("../../types/options").ExportMenuOptions | undefined;
        tooltip?: import("../../types/options").BaseTooltipOptions | undefined;
        responsive?: import("../../types/options").ResponsiveOptions | undefined;
        usageStatistics?: boolean | undefined;
    } | {
        series?: LineAreaChartSeriesOptions | undefined;
        plot?: import("../../types/options").LineTypePlotOptions | undefined;
        yAxis?: import("../../types/options").YAxisOptions | import("../../types/options").YAxisOptions[] | undefined;
        legend?: import("../../types/options").NormalLegendOptions | undefined;
        theme?: import("../../types/theme").LineAreaChartThemeOptions | undefined;
        chart?: import("../../types/options").BaseChartOptions | undefined;
        lang?: import("../../types/options").LangOptions | undefined;
        xAxis?: import("../../types/options").BaseXAxisOptions | undefined;
        exportMenu?: import("../../types/options").ExportMenuOptions | undefined;
        tooltip?: import("../../types/options").BaseTooltipOptions | undefined;
        responsive?: import("../../types/options").ResponsiveOptions | undefined;
        usageStatistics?: boolean | undefined;
    };
    render(chartState: ChartState<AreaChartOptions | LineAreaChartOptions>, computed: any): void;
    private getResponders;
    makeNearTypeResponderModel(seriesCircleModel: CircleModel[], tooltipDataArr: TooltipData[], categories: string[], detectionSize?: number): CircleResponderModel[];
    renderClipRectAreaModel(isDrawModel?: boolean): ClipRectAreaModel;
    makeTooltipData(areaData: AreaSeriesType[], categories: string[]): TooltipData[];
    getLinePointModelValue(datum: Omit<AreaSeriesDataType, 'null'>, pairModel?: boolean): any;
    getLinePointModel(series: AreaSeriesType, seriesIndex: number, limit: ValueEdge, renderOptions: RenderOptions): LinePointsModel;
    renderLinePointsModel(seriesRawData: AreaSeriesType[], limit: ValueEdge, renderOptions: RenderOptions): LinePointsModel[];
    getCombinedPoints(start: number, end: number): (BezierPoint | null)[];
    renderRangeAreaSeries(linePointsModel: LinePointsModel[]): AreaPointsModel[];
    renderAreaSeries(linePointsModel: LinePointsModel[]): AreaPointsModel[];
    getCombinedLinePointsModel(): LinePointsModel[];
    private getAreaOpacity;
    renderAreaPointsModel(): AreaPointsModel[];
    renderCircleModel(showDot: boolean): {
        dotSeriesModel: CircleModel[];
        responderModel: CircleModel[];
    };
    getPairCircleModel(circleModels: CircleResponderModel[]): CircleResponderModel[];
    getCircleModelsFromRectResponders(responders: RectResponderModel[], mousePositions?: Point): CircleResponderModel[];
    onMousemoveGroupedType(responders: RectResponderModel[]): void;
    onMousemoveNearestType(responders: RectResponderModel[], mousePositions: Point): void;
    onMousemoveNearType(responders: CircleResponderModel[]): void;
    onMousemove({ responders, mousePosition }: MouseEventType): void;
    onMouseoutComponent: () => void;
    getDataLabels(seriesModels: AreaPointsModel[]): PointDataLabel[];
    private getResponderSeriesWithTheme;
    onClick({ responders, mousePosition }: MouseEventType): void;
    private getResponderCategoryByIndex;
    selectSeries: (info: SelectSeriesInfo) => void;
    showTooltip: (info: SelectSeriesInfo) => void;
}
export {};
