"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const ReactDOM = __importStar(require("react-dom"));
const React = __importStar(require("react"));
const ToastManager_1 = __importDefault(require("./ToastManager"));
const isBrowser = typeof window !== "undefined" && typeof window.document !== "undefined";
const PORTAL_ID = "react-toast";
class Toaster {
    constructor() {
        this.bindNotify = (fn) => {
            this.createNotification = fn;
        };
        this.notify = (message, options = {}) => {
            if (this.createNotification) {
                this.createNotification(message, options);
            }
        };
        if (!isBrowser) {
            return;
        }
        let portalElement;
        const existingPortalElement = document.getElementById(PORTAL_ID);
        if (existingPortalElement) {
            portalElement = existingPortalElement;
        }
        else {
            const el = document.createElement("div");
            el.id = PORTAL_ID;
            el.className = "Toaster";
            if (document.body != null) {
                document.body.appendChild(el);
            }
            portalElement = el;
        }
        ReactDOM.render(React.createElement(ToastManager_1.default, { notify: this.bindNotify }), portalElement);
    }
}
exports.default = Toaster;
