import * as ReactDOM from "react-dom";
import * as React from "react";
import ToastManager from "./ToastManager";
const isBrowser = typeof window !== "undefined" && typeof window.document !== "undefined";
const PORTAL_ID = "react-toast";
class Toaster {
    constructor() {
        this.bindNotify = (fn) => {
            this.createNotification = fn;
        };
        this.notify = (message, options = {}) => {
            if (this.createNotification) {
                this.createNotification(message, options);
            }
        };
        if (!isBrowser) {
            return;
        }
        let portalElement;
        const existingPortalElement = document.getElementById(PORTAL_ID);
        if (existingPortalElement) {
            portalElement = existingPortalElement;
        }
        else {
            const el = document.createElement("div");
            el.id = PORTAL_ID;
            el.className = "Toaster";
            if (document.body != null) {
                document.body.appendChild(el);
            }
            portalElement = el;
        }
        ReactDOM.render(React.createElement(ToastManager, { notify: this.bindNotify }), portalElement);
    }
}
export default Toaster;
