/*!
 * Copyright (c) 2015, Salesforce.com, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. Neither the name of Salesforce.com nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
// disabling this lint on this whole file because Store should be abstract
// but we have implementations in the wild that may not implement all features
/* eslint-disable @typescript-eslint/no-unused-vars */
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.Store = void 0;
class Store {
    constructor() {
        this.synchronous = false;
    }
    findCookie(_domain, _path, _key, _callback) {
        throw new Error('findCookie is not implemented');
    }
    findCookies(_domain, _path, _allowSpecialUseDomain = false, _callback) {
        throw new Error('findCookies is not implemented');
    }
    putCookie(_cookie, _callback) {
        throw new Error('putCookie is not implemented');
    }
    updateCookie(_oldCookie, _newCookie, _callback) {
        // recommended default implementation:
        // return this.putCookie(newCookie, cb);
        throw new Error('updateCookie is not implemented');
    }
    removeCookie(_domain, _path, _key, _callback) {
        throw new Error('removeCookie is not implemented');
    }
    removeCookies(_domain, _path, _callback) {
        throw new Error('removeCookies is not implemented');
    }
    removeAllCookies(_callback) {
        throw new Error('removeAllCookies is not implemented');
    }
    getAllCookies(_callback) {
        throw new Error('getAllCookies is not implemented (therefore jar cannot be serialized)');
    }
}
exports.Store = Store;
