"use strict";
/**
 * It would nice to drop this entirely but, for whatever reason, we expose an
 * `inspect` method on `Cookie` and `MemoryCookieStore` that just delegates to
 * Node's `util.inspect` functionality. Since that functionality isn't supported
 * in non-Node environments (e.g.; React Native) this fallback is here to provide
 * equivalent behavior when it is not present.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCustomInspectSymbol = exports.getUtilInspect = void 0;
function requireUtil() {
    try {
        // eslint-disable-next-line @typescript-eslint/no-var-requires
        return require('util');
    }
    catch (e) {
        return undefined;
    }
}
// for v10.12.0+
function lookupCustomInspectSymbol() {
    return Symbol.for('nodejs.util.inspect.custom');
}
// for older node environments
function tryReadingCustomSymbolFromUtilInspect(options) {
    const _requireUtil = options.requireUtil || requireUtil;
    const nodeUtil = _requireUtil();
    return nodeUtil ? nodeUtil.inspect.custom : undefined;
}
function getUtilInspect(fallback, options = {}) {
    const _requireUtil = options.requireUtil || requireUtil;
    const nodeUtil = _requireUtil();
    return function inspect(object, showHidden, depth, color) {
        return nodeUtil
            ? nodeUtil.inspect(object, showHidden, depth, color)
            : fallback(object);
    };
}
exports.getUtilInspect = getUtilInspect;
function getCustomInspectSymbol(options = {}) {
    // get custom inspect symbol for node environments
    return (tryReadingCustomSymbolFromUtilInspect(options) ||
        lookupCustomInspectSymbol());
}
exports.getCustomInspectSymbol = getCustomInspectSymbol;
