import { NamedNode } from "@rdfjs/types";
export interface Grddl {
    '': NamedNode<'http://www.w3.org/2003/g/data-view#'>;
    "danc": NamedNode<'http://www.w3.org/2003/g/data-view#danc'>;
    "grddl-wg": NamedNode<'http://www.w3.org/2003/g/data-view#grddl-wg'>;
    "grddlProject": NamedNode<'http://www.w3.org/2003/g/data-view#grddlProject'>;
    /** A resource which has the property that all of its essential characteristics can be conveyed in a message */
    "InformationResource": NamedNode<'http://www.w3.org/2003/g/data-view#InformationResource'>;
    /**
     * relates a namespace to a transformation for
     *     all documents in that namespace
     */
    "namespaceTransformation": NamedNode<'http://www.w3.org/2003/g/data-view#namespaceTransformation'>;
    /**
     * relates a profile document to a
     *     transformation for all documents bearing that profile
     */
    "profileTransformation": NamedNode<'http://www.w3.org/2003/g/data-view#profileTransformation'>;
    /**
     * a
     *     set of RDF triples
     */
    "RDFGraph": NamedNode<'http://www.w3.org/2003/g/data-view#RDFGraph'>;
    /**
     * an
     *     RDF graph obtained from an information resource by directly
     *     parsing a representation in the standard RDF/XML syntax or
     *     indirectly by parsing some other dialect using a transformation
     *     nominated by the document
     */
    "result": NamedNode<'http://www.w3.org/2003/g/data-view#result'>;
    /**
     * the root of the tree in the XPath data
     *     model
     */
    "RootNode": NamedNode<'http://www.w3.org/2003/g/data-view#RootNode'>;
    /**
     * relates a source document to a
     *     transformation, usually represented in XSLT, that relates the source document syntax
     *     to the RDF graph syntax
     */
    "transformation": NamedNode<'http://www.w3.org/2003/g/data-view#transformation'>;
    /**
     * an InformationResource that specifies
     *     a transformation from a set of XML documents to RDF graphs
     */
    "Transformation": NamedNode<'http://www.w3.org/2003/g/data-view#Transformation'>;
    /**
     * relates a transformation to the algorithm
     *     specified by the property that computes an RDF graph from an XML
     *     document node
     */
    "transformationProperty": NamedNode<'http://www.w3.org/2003/g/data-view#transformationProperty'>;
    /**
     * a FunctionalProperty that relates
     *     XML document root nodes to
     *     RDF graphs
     */
    "TransformationProperty": NamedNode<'http://www.w3.org/2003/g/data-view#TransformationProperty'>;
}
export declare const strict: Record<keyof Grddl, NamedNode<string>> & ((property?: TemplateStringsArray | keyof Grddl | undefined) => NamedNode<string>) & Grddl;
export declare const loose: Record<any, NamedNode<string>> & ((property?: any) => NamedNode<string>) & Grddl;
//# sourceMappingURL=grddl.d.ts.map