import { NamedNode } from "@rdfjs/types";
export interface Quantitykind {
    '': NamedNode<'http://qudt.org/vocab/quantitykind/'>;
    "AbsoluteActivity": NamedNode<'http://qudt.org/vocab/quantitykind/AbsoluteActivity'>;
    "AbsoluteHumidity": NamedNode<'http://qudt.org/vocab/quantitykind/AbsoluteHumidity'>;
    /** Note that the absorbed dose is not a good indicator of the likely biological effect. 1 Gy of alpha radiation would be much more biologically damaging than 1 Gy of photon radiation for example. Appropriate weighting factors can be applied reflecting the different relative biological effects to find the equivalent dose. The risk of stoctic effects due to radiation exposure can be quantified using the effective dose, which is a weighted average of the equivalent dose to each organ depending upon its radiosensitivity. When ionising radiation is used to treat cancer, the doctor will usually prescribe the radiotherapy treatment in Gy. When risk from ionising radiation is being discussed, a related unit, the Sievert is used. */
    "AbsorbedDose": NamedNode<'http://qudt.org/vocab/quantitykind/AbsorbedDose'>;
    "AbsorbedDoseRate": NamedNode<'http://qudt.org/vocab/quantitykind/AbsorbedDoseRate'>;
    "Absorptance": NamedNode<'http://qudt.org/vocab/quantitykind/Absorptance'>;
    "Acceleration": NamedNode<'http://qudt.org/vocab/quantitykind/Acceleration'>;
    "AccelerationOfGravity": NamedNode<'http://qudt.org/vocab/quantitykind/AccelerationOfGravity'>;
    "AcceptorDensity": NamedNode<'http://qudt.org/vocab/quantitykind/AcceptorDensity'>;
    "AcceptorIonizationEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/AcceptorIonizationEnergy'>;
    "Acidity": NamedNode<'http://qudt.org/vocab/quantitykind/Acidity'>;
    "AcousticImpedance": NamedNode<'http://qudt.org/vocab/quantitykind/AcousticImpedance'>;
    "Action": NamedNode<'http://qudt.org/vocab/quantitykind/Action'>;
    /** Action Time (sec) */
    "ActionTime": NamedNode<'http://qudt.org/vocab/quantitykind/ActionTime'>;
    "ActiveEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/ActiveEnergy'>;
    "ActivePower": NamedNode<'http://qudt.org/vocab/quantitykind/ActivePower'>;
    "Activity": NamedNode<'http://qudt.org/vocab/quantitykind/Activity'>;
    "ActivityCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/ActivityCoefficient'>;
    "ActivityConcentration": NamedNode<'http://qudt.org/vocab/quantitykind/ActivityConcentration'>;
    "ActivityThresholds": NamedNode<'http://qudt.org/vocab/quantitykind/ActivityThresholds'>;
    "Adaptation": NamedNode<'http://qudt.org/vocab/quantitykind/Adaptation'>;
    "Admittance": NamedNode<'http://qudt.org/vocab/quantitykind/Admittance'>;
    "AlphaDisintegrationEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/AlphaDisintegrationEnergy'>;
    "Altitude": NamedNode<'http://qudt.org/vocab/quantitykind/Altitude'>;
    "AmbientPressure": NamedNode<'http://qudt.org/vocab/quantitykind/AmbientPressure'>;
    "AmountOfSubstance": NamedNode<'http://qudt.org/vocab/quantitykind/AmountOfSubstance'>;
    "AmountOfSubstanceConcentrationOfB": NamedNode<'http://qudt.org/vocab/quantitykind/AmountOfSubstanceConcentrationOfB'>;
    "AmountOfSubstanceFractionOfB": NamedNode<'http://qudt.org/vocab/quantitykind/AmountOfSubstanceFractionOfB'>;
    "AmountOfSubstancePerUnitMass": NamedNode<'http://qudt.org/vocab/quantitykind/AmountOfSubstancePerUnitMass'>;
    "AmountOfSubstancePerUnitMassPressure": NamedNode<'http://qudt.org/vocab/quantitykind/AmountOfSubstancePerUnitMassPressure'>;
    "AmountOfSubstancePerUnitVolume": NamedNode<'http://qudt.org/vocab/quantitykind/AmountOfSubstancePerUnitVolume'>;
    "Angle": NamedNode<'http://qudt.org/vocab/quantitykind/Angle'>;
    "AngleOfAttack": NamedNode<'http://qudt.org/vocab/quantitykind/AngleOfAttack'>;
    "AngleOfOpticalRotation": NamedNode<'http://qudt.org/vocab/quantitykind/AngleOfOpticalRotation'>;
    "AngularAcceleration": NamedNode<'http://qudt.org/vocab/quantitykind/AngularAcceleration'>;
    "AngularCrossSection": NamedNode<'http://qudt.org/vocab/quantitykind/AngularCrossSection'>;
    "AngularDistance": NamedNode<'http://qudt.org/vocab/quantitykind/AngularDistance'>;
    "AngularFrequency": NamedNode<'http://qudt.org/vocab/quantitykind/AngularFrequency'>;
    "AngularImpulse": NamedNode<'http://qudt.org/vocab/quantitykind/AngularImpulse'>;
    "AngularMomentum": NamedNode<'http://qudt.org/vocab/quantitykind/AngularMomentum'>;
    "AngularMomentumPerAngle": NamedNode<'http://qudt.org/vocab/quantitykind/AngularMomentumPerAngle'>;
    "AngularReciprocalLatticeVector": NamedNode<'http://qudt.org/vocab/quantitykind/AngularReciprocalLatticeVector'>;
    "AngularVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/AngularVelocity'>;
    "AngularWavenumber": NamedNode<'http://qudt.org/vocab/quantitykind/AngularWavenumber'>;
    "ApogeeRadius": NamedNode<'http://qudt.org/vocab/quantitykind/ApogeeRadius'>;
    "ApparentPower": NamedNode<'http://qudt.org/vocab/quantitykind/ApparentPower'>;
    "Area": NamedNode<'http://qudt.org/vocab/quantitykind/Area'>;
    "AreaAngle": NamedNode<'http://qudt.org/vocab/quantitykind/AreaAngle'>;
    "AreaPerTime": NamedNode<'http://qudt.org/vocab/quantitykind/AreaPerTime'>;
    "AreaRatio": NamedNode<'http://qudt.org/vocab/quantitykind/AreaRatio'>;
    "AreaTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/AreaTemperature'>;
    "AreaThermalExpansion": NamedNode<'http://qudt.org/vocab/quantitykind/AreaThermalExpansion'>;
    "AreaTime": NamedNode<'http://qudt.org/vocab/quantitykind/AreaTime'>;
    "AreaTimeTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/AreaTimeTemperature'>;
    "AreicHeatFlowRate": NamedNode<'http://qudt.org/vocab/quantitykind/AreicHeatFlowRate'>;
    "Asset": NamedNode<'http://qudt.org/vocab/quantitykind/Asset'>;
    "AtmosphericHydroxylationRate": NamedNode<'http://qudt.org/vocab/quantitykind/AtmosphericHydroxylationRate'>;
    "AtmosphericPressure": NamedNode<'http://qudt.org/vocab/quantitykind/AtmosphericPressure'>;
    "AtomicAttenuationCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/AtomicAttenuationCoefficient'>;
    "AtomicCharge": NamedNode<'http://qudt.org/vocab/quantitykind/AtomicCharge'>;
    "AtomicMass": NamedNode<'http://qudt.org/vocab/quantitykind/AtomicMass'>;
    "AtomicNumber": NamedNode<'http://qudt.org/vocab/quantitykind/AtomicNumber'>;
    "AtomScatteringFactor": NamedNode<'http://qudt.org/vocab/quantitykind/AtomScatteringFactor'>;
    "AttenuationCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/AttenuationCoefficient'>;
    "AuditoryThresholds": NamedNode<'http://qudt.org/vocab/quantitykind/AuditoryThresholds'>;
    "AuxillaryMagneticField": NamedNode<'http://qudt.org/vocab/quantitykind/AuxillaryMagneticField'>;
    "AverageEnergyLossPerElementaryChargeProduced": NamedNode<'http://qudt.org/vocab/quantitykind/AverageEnergyLossPerElementaryChargeProduced'>;
    "AverageHeadEndPressure": NamedNode<'http://qudt.org/vocab/quantitykind/AverageHeadEndPressure'>;
    "AverageLogarithmicEnergyDecrement": NamedNode<'http://qudt.org/vocab/quantitykind/AverageLogarithmicEnergyDecrement'>;
    /** Avg Specific Impulse (lbf-sec/lbm) */
    "AverageSpecificImpulse": NamedNode<'http://qudt.org/vocab/quantitykind/AverageSpecificImpulse'>;
    "AverageVacuumThrust": NamedNode<'http://qudt.org/vocab/quantitykind/AverageVacuumThrust'>;
    "Basicity": NamedNode<'http://qudt.org/vocab/quantitykind/Basicity'>;
    "BendingMomentOfForce": NamedNode<'http://qudt.org/vocab/quantitykind/BendingMomentOfForce'>;
    "BetaDisintegrationEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/BetaDisintegrationEnergy'>;
    "BevelGearPitchAngle": NamedNode<'http://qudt.org/vocab/quantitykind/BevelGearPitchAngle'>;
    "BindingFraction": NamedNode<'http://qudt.org/vocab/quantitykind/BindingFraction'>;
    "BioconcentrationFactor": NamedNode<'http://qudt.org/vocab/quantitykind/BioconcentrationFactor'>;
    "BiodegredationHalfLife": NamedNode<'http://qudt.org/vocab/quantitykind/BiodegredationHalfLife'>;
    /** citation: https://en.wikipedia.org/wiki/Blood_sugar_level */
    "BloodGlucoseLevel_Mass": NamedNode<'http://qudt.org/vocab/quantitykind/BloodGlucoseLevel_Mass'>;
    /** citation: https://en.wikipedia.org/wiki/Blood_sugar_level */
    "BloodGlucoseLevel": NamedNode<'http://qudt.org/vocab/quantitykind/BloodGlucoseLevel'>;
    "BodyMassIndex": NamedNode<'http://qudt.org/vocab/quantitykind/BodyMassIndex'>;
    "BoilingPoint": NamedNode<'http://qudt.org/vocab/quantitykind/BoilingPoint'>;
    "BraggAngle": NamedNode<'http://qudt.org/vocab/quantitykind/BraggAngle'>;
    "Breadth": NamedNode<'http://qudt.org/vocab/quantitykind/Breadth'>;
    "BucklingFactor": NamedNode<'http://qudt.org/vocab/quantitykind/BucklingFactor'>;
    "BulkModulus": NamedNode<'http://qudt.org/vocab/quantitykind/BulkModulus'>;
    "BurgersVector": NamedNode<'http://qudt.org/vocab/quantitykind/BurgersVector'>;
    "BurnRate": NamedNode<'http://qudt.org/vocab/quantitykind/BurnRate'>;
    "BurnTime": NamedNode<'http://qudt.org/vocab/quantitykind/BurnTime'>;
    "CanonicalPartitionFunction": NamedNode<'http://qudt.org/vocab/quantitykind/CanonicalPartitionFunction'>;
    "Capacitance": NamedNode<'http://qudt.org/vocab/quantitykind/Capacitance'>;
    "Capacity": NamedNode<'http://qudt.org/vocab/quantitykind/Capacity'>;
    "CarrierLifetime": NamedNode<'http://qudt.org/vocab/quantitykind/CarrierLifetime'>;
    "CartesianArea": NamedNode<'http://qudt.org/vocab/quantitykind/CartesianArea'>;
    "CartesianCoordinates": NamedNode<'http://qudt.org/vocab/quantitykind/CartesianCoordinates'>;
    "CartesianVolume": NamedNode<'http://qudt.org/vocab/quantitykind/CartesianVolume'>;
    "CatalyticActivity": NamedNode<'http://qudt.org/vocab/quantitykind/CatalyticActivity'>;
    "CelsiusTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/CelsiusTemperature'>;
    "CENTER-OF-GRAVITY_X": NamedNode<'http://qudt.org/vocab/quantitykind/CENTER-OF-GRAVITY_X'>;
    "CENTER-OF-GRAVITY_Y": NamedNode<'http://qudt.org/vocab/quantitykind/CENTER-OF-GRAVITY_Y'>;
    "CENTER-OF-GRAVITY_Z": NamedNode<'http://qudt.org/vocab/quantitykind/CENTER-OF-GRAVITY_Z'>;
    "CENTER-OF-MASS": NamedNode<'http://qudt.org/vocab/quantitykind/CENTER-OF-MASS'>;
    "CenterOfGravity_X": NamedNode<'http://qudt.org/vocab/quantitykind/CenterOfGravity_X'>;
    "CenterOfGravity_Y": NamedNode<'http://qudt.org/vocab/quantitykind/CenterOfGravity_Y'>;
    "CenterOfGravity_Z": NamedNode<'http://qudt.org/vocab/quantitykind/CenterOfGravity_Z'>;
    "CharacteristicAcousticImpedance": NamedNode<'http://qudt.org/vocab/quantitykind/CharacteristicAcousticImpedance'>;
    "CharacteristicVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/CharacteristicVelocity'>;
    "ChargeNumber": NamedNode<'http://qudt.org/vocab/quantitykind/ChargeNumber'>;
    "ChemicalAffinity": NamedNode<'http://qudt.org/vocab/quantitykind/ChemicalAffinity'>;
    "ChemicalPotential": NamedNode<'http://qudt.org/vocab/quantitykind/ChemicalPotential'>;
    "Chromaticity": NamedNode<'http://qudt.org/vocab/quantitykind/Chromaticity'>;
    "Circulation": NamedNode<'http://qudt.org/vocab/quantitykind/Circulation'>;
    "ClosestApproachRadius": NamedNode<'http://qudt.org/vocab/quantitykind/ClosestApproachRadius'>;
    "CoefficientOfHeatTransfer": NamedNode<'http://qudt.org/vocab/quantitykind/CoefficientOfHeatTransfer'>;
    "Coercivity": NamedNode<'http://qudt.org/vocab/quantitykind/Coercivity'>;
    "CoherenceLength": NamedNode<'http://qudt.org/vocab/quantitykind/CoherenceLength'>;
    "ColdReceptorThreshold": NamedNode<'http://qudt.org/vocab/quantitykind/ColdReceptorThreshold'>;
    "CombinedNonEvaporativeHeatTransferCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/CombinedNonEvaporativeHeatTransferCoefficient'>;
    "CombustionChamberTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/CombustionChamberTemperature'>;
    "ComplexPower": NamedNode<'http://qudt.org/vocab/quantitykind/ComplexPower'>;
    "Compressibility": NamedNode<'http://qudt.org/vocab/quantitykind/Compressibility'>;
    "CompressibilityFactor": NamedNode<'http://qudt.org/vocab/quantitykind/CompressibilityFactor'>;
    "Concentration": NamedNode<'http://qudt.org/vocab/quantitykind/Concentration'>;
    "Conductance": NamedNode<'http://qudt.org/vocab/quantitykind/Conductance'>;
    "ConductionSpeed": NamedNode<'http://qudt.org/vocab/quantitykind/ConductionSpeed'>;
    "ConductiveHeatTransferRate": NamedNode<'http://qudt.org/vocab/quantitykind/ConductiveHeatTransferRate'>;
    "Conductivity": NamedNode<'http://qudt.org/vocab/quantitykind/Conductivity'>;
    "CONTRACT-END-ITEM-SPECIFICATION-MASS": NamedNode<'http://qudt.org/vocab/quantitykind/CONTRACT-END-ITEM-SPECIFICATION-MASS'>;
    "CONTROL-MASS": NamedNode<'http://qudt.org/vocab/quantitykind/CONTROL-MASS'>;
    "ConvectiveHeatTransfer": NamedNode<'http://qudt.org/vocab/quantitykind/ConvectiveHeatTransfer'>;
    "CorrelatedColorTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/CorrelatedColorTemperature'>;
    "Count": NamedNode<'http://qudt.org/vocab/quantitykind/Count'>;
    "CouplingFactor": NamedNode<'http://qudt.org/vocab/quantitykind/CouplingFactor'>;
    "CrossSection": NamedNode<'http://qudt.org/vocab/quantitykind/CrossSection'>;
    "CrossSectionalArea": NamedNode<'http://qudt.org/vocab/quantitykind/CrossSectionalArea'>;
    "CubicElectricDipoleMomentPerSquareEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/CubicElectricDipoleMomentPerSquareEnergy'>;
    "CubicExpansionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/CubicExpansionCoefficient'>;
    "CurieTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/CurieTemperature'>;
    "Currency": NamedNode<'http://qudt.org/vocab/quantitykind/Currency'>;
    "CurrencyPerFlight": NamedNode<'http://qudt.org/vocab/quantitykind/CurrencyPerFlight'>;
    "CurrentLinkage": NamedNode<'http://qudt.org/vocab/quantitykind/CurrentLinkage'>;
    "Curvature": NamedNode<'http://qudt.org/vocab/quantitykind/Curvature'>;
    "CurvatureFromRadius": NamedNode<'http://qudt.org/vocab/quantitykind/CurvatureFromRadius'>;
    "CyclotronAngularFrequency": NamedNode<'http://qudt.org/vocab/quantitykind/CyclotronAngularFrequency'>;
    "DataRate": NamedNode<'http://qudt.org/vocab/quantitykind/DataRate'>;
    "Debye-WallerFactor": NamedNode<'http://qudt.org/vocab/quantitykind/Debye-WallerFactor'>;
    "DebyeAngularFrequency": NamedNode<'http://qudt.org/vocab/quantitykind/DebyeAngularFrequency'>;
    "DebyeAngularWavenumber": NamedNode<'http://qudt.org/vocab/quantitykind/DebyeAngularWavenumber'>;
    "DebyeTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/DebyeTemperature'>;
    "DecayConstant": NamedNode<'http://qudt.org/vocab/quantitykind/DecayConstant'>;
    "DegreeOfDissociation": NamedNode<'http://qudt.org/vocab/quantitykind/DegreeOfDissociation'>;
    "DELTA-V": NamedNode<'http://qudt.org/vocab/quantitykind/DELTA-V'>;
    "Density": NamedNode<'http://qudt.org/vocab/quantitykind/Density'>;
    "DensityInCombustionChamber": NamedNode<'http://qudt.org/vocab/quantitykind/DensityInCombustionChamber'>;
    "DensityOfStates": NamedNode<'http://qudt.org/vocab/quantitykind/DensityOfStates'>;
    "DensityOfTheExhaustGases": NamedNode<'http://qudt.org/vocab/quantitykind/DensityOfTheExhaustGases'>;
    "Depth": NamedNode<'http://qudt.org/vocab/quantitykind/Depth'>;
    "DewPointTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/DewPointTemperature'>;
    "Diameter": NamedNode<'http://qudt.org/vocab/quantitykind/Diameter'>;
    "DiastolicBloodPressure": NamedNode<'http://qudt.org/vocab/quantitykind/DiastolicBloodPressure'>;
    "DiffusionArea": NamedNode<'http://qudt.org/vocab/quantitykind/DiffusionArea'>;
    "DiffusionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/DiffusionCoefficient'>;
    "DiffusionCoefficientForFluenceRate": NamedNode<'http://qudt.org/vocab/quantitykind/DiffusionCoefficientForFluenceRate'>;
    "DiffusionLength": NamedNode<'http://qudt.org/vocab/quantitykind/DiffusionLength'>;
    "Dimensionless": NamedNode<'http://qudt.org/vocab/quantitykind/Dimensionless'>;
    "DimensionlessRatio": NamedNode<'http://qudt.org/vocab/quantitykind/DimensionlessRatio'>;
    "Displacement": NamedNode<'http://qudt.org/vocab/quantitykind/Displacement'>;
    "DisplacementCurrent": NamedNode<'http://qudt.org/vocab/quantitykind/DisplacementCurrent'>;
    "DisplacementCurrentDensity": NamedNode<'http://qudt.org/vocab/quantitykind/DisplacementCurrentDensity'>;
    "DisplacementVectorOfIon": NamedNode<'http://qudt.org/vocab/quantitykind/DisplacementVectorOfIon'>;
    "Dissipance": NamedNode<'http://qudt.org/vocab/quantitykind/Dissipance'>;
    "Distance": NamedNode<'http://qudt.org/vocab/quantitykind/Distance'>;
    "DistanceTraveledDuringBurn": NamedNode<'http://qudt.org/vocab/quantitykind/DistanceTraveledDuringBurn'>;
    "DonorDensity": NamedNode<'http://qudt.org/vocab/quantitykind/DonorDensity'>;
    "DonorIonizationEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/DonorIonizationEnergy'>;
    "DoseEquivalent": NamedNode<'http://qudt.org/vocab/quantitykind/DoseEquivalent'>;
    "DoseEquivalentQualityFactor": NamedNode<'http://qudt.org/vocab/quantitykind/DoseEquivalentQualityFactor'>;
    "DragCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/DragCoefficient'>;
    "DragForce": NamedNode<'http://qudt.org/vocab/quantitykind/DragForce'>;
    "DRY-MASS": NamedNode<'http://qudt.org/vocab/quantitykind/DRY-MASS'>;
    "DryVolume": NamedNode<'http://qudt.org/vocab/quantitykind/DryVolume'>;
    "Duv": NamedNode<'http://qudt.org/vocab/quantitykind/Duv'>;
    "DynamicFriction": NamedNode<'http://qudt.org/vocab/quantitykind/DynamicFriction'>;
    "DynamicFrictionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/DynamicFrictionCoefficient'>;
    "DynamicPressure": NamedNode<'http://qudt.org/vocab/quantitykind/DynamicPressure'>;
    "DynamicViscosity": NamedNode<'http://qudt.org/vocab/quantitykind/DynamicViscosity'>;
    "EarthClosestApproachVehicleVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/EarthClosestApproachVehicleVelocity'>;
    "EccentricityOfOrbit": NamedNode<'http://qudt.org/vocab/quantitykind/EccentricityOfOrbit'>;
    "EffectiveExhaustVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/EffectiveExhaustVelocity'>;
    "EffectiveMass": NamedNode<'http://qudt.org/vocab/quantitykind/EffectiveMass'>;
    "EffectiveMultiplicationFactor": NamedNode<'http://qudt.org/vocab/quantitykind/EffectiveMultiplicationFactor'>;
    "Efficiency": NamedNode<'http://qudt.org/vocab/quantitykind/Efficiency'>;
    "EinsteinTransitionProbability": NamedNode<'http://qudt.org/vocab/quantitykind/EinsteinTransitionProbability'>;
    "ElectricalPowerToMassRatio": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricalPowerToMassRatio'>;
    "ElectricCharge": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricCharge'>;
    "ElectricChargeDensity": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricChargeDensity'>;
    "ElectricChargeLinearDensity": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricChargeLinearDensity'>;
    "ElectricChargeLineDensity": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricChargeLineDensity'>;
    "ElectricChargePerAmountOfSubstance": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricChargePerAmountOfSubstance'>;
    "ElectricChargePerArea": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricChargePerArea'>;
    "ElectricChargePerMass": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricChargePerMass'>;
    "ElectricChargeSurfaceDensity": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricChargeSurfaceDensity'>;
    "ElectricChargeVolumeDensity": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricChargeVolumeDensity'>;
    "ElectricConductivity": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricConductivity'>;
    "ElectricCurrent": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricCurrent'>;
    "ElectricCurrentDensity": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricCurrentDensity'>;
    "ElectricCurrentPerAngle": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricCurrentPerAngle'>;
    "ElectricCurrentPerUnitEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricCurrentPerUnitEnergy'>;
    "ElectricCurrentPerUnitLength": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricCurrentPerUnitLength'>;
    "ElectricCurrentPerUnitTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricCurrentPerUnitTemperature'>;
    "ElectricCurrentPhasor": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricCurrentPhasor'>;
    "ElectricDipoleMoment_CubicPerEnergy_Squared": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricDipoleMoment_CubicPerEnergy_Squared'>;
    "ElectricDipoleMoment_QuarticPerEnergy_Cubic": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricDipoleMoment_QuarticPerEnergy_Cubic'>;
    "ElectricDipoleMoment": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricDipoleMoment'>;
    "ElectricDisplacement": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricDisplacement'>;
    "ElectricDisplacementField": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricDisplacementField'>;
    "ElectricField": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricField'>;
    "ElectricFieldStrength": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricFieldStrength'>;
    "ElectricFlux": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricFlux'>;
    "ElectricFluxDensity": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricFluxDensity'>;
    "ElectricPolarizability": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricPolarizability'>;
    "ElectricPolarization": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricPolarization'>;
    "ElectricPotential": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricPotential'>;
    "ElectricPotentialDifference": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricPotentialDifference'>;
    "ElectricPower": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricPower'>;
    "ElectricPropulsionPropellantMass": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricPropulsionPropellantMass'>;
    "ElectricQuadrupoleMoment": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricQuadrupoleMoment'>;
    "ElectricSusceptibility": NamedNode<'http://qudt.org/vocab/quantitykind/ElectricSusceptibility'>;
    "ElectrolyticConductivity": NamedNode<'http://qudt.org/vocab/quantitykind/ElectrolyticConductivity'>;
    "ElectromagneticEnergyDensity": NamedNode<'http://qudt.org/vocab/quantitykind/ElectromagneticEnergyDensity'>;
    "ElectromagneticPermeability": NamedNode<'http://qudt.org/vocab/quantitykind/ElectromagneticPermeability'>;
    "ElectromagneticPermeabilityRatio": NamedNode<'http://qudt.org/vocab/quantitykind/ElectromagneticPermeabilityRatio'>;
    "ElectromagneticWavePhaseSpeed": NamedNode<'http://qudt.org/vocab/quantitykind/ElectromagneticWavePhaseSpeed'>;
    "ElectromotiveForce": NamedNode<'http://qudt.org/vocab/quantitykind/ElectromotiveForce'>;
    "ElectronAffinity": NamedNode<'http://qudt.org/vocab/quantitykind/ElectronAffinity'>;
    "ElectronDensity": NamedNode<'http://qudt.org/vocab/quantitykind/ElectronDensity'>;
    "ElectronMeanFreePath": NamedNode<'http://qudt.org/vocab/quantitykind/ElectronMeanFreePath'>;
    "ElectronRadius": NamedNode<'http://qudt.org/vocab/quantitykind/ElectronRadius'>;
    "EllipticalOrbitApogeeVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/EllipticalOrbitApogeeVelocity'>;
    "EllipticalOrbitPerigeeVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/EllipticalOrbitPerigeeVelocity'>;
    "Emissivity": NamedNode<'http://qudt.org/vocab/quantitykind/Emissivity'>;
    "Energy_Squared": NamedNode<'http://qudt.org/vocab/quantitykind/Energy_Squared'>;
    "Energy": NamedNode<'http://qudt.org/vocab/quantitykind/Energy'>;
    "EnergyDensity": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyDensity'>;
    "EnergyDensityOfStates": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyDensityOfStates'>;
    "EnergyExpenditure": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyExpenditure'>;
    "EnergyFluence": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyFluence'>;
    "EnergyFluenceRate": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyFluenceRate'>;
    "EnergyImparted": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyImparted'>;
    "EnergyInternal": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyInternal'>;
    "EnergyKinetic": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyKinetic'>;
    "EnergyLevel": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyLevel'>;
    "EnergyPerArea": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyPerArea'>;
    "EnergyPerAreaElectricCharge": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyPerAreaElectricCharge'>;
    "EnergyPerElectricCharge": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyPerElectricCharge'>;
    "EnergyPerMagneticFluxDensity_Squared": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyPerMagneticFluxDensity_Squared'>;
    "EnergyPerMassAmountOfSubstance": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyPerMassAmountOfSubstance'>;
    "EnergyPerSquareMagneticFluxDensity": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyPerSquareMagneticFluxDensity'>;
    "EnergyPerTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/EnergyPerTemperature'>;
    "Enthalpy": NamedNode<'http://qudt.org/vocab/quantitykind/Enthalpy'>;
    "Entropy": NamedNode<'http://qudt.org/vocab/quantitykind/Entropy'>;
    "EquilibriumConstant": NamedNode<'http://qudt.org/vocab/quantitykind/EquilibriumConstant'>;
    /** The unit is unit:MOL-PER-M3 raised to the N where N is the summation of stoichiometric numbers. I don't know what to do with this. */
    "EquilibriumConstantOnConcentrationBasis": NamedNode<'http://qudt.org/vocab/quantitykind/EquilibriumConstantOnConcentrationBasis'>;
    "EquilibriumConstantOnPressureBasis": NamedNode<'http://qudt.org/vocab/quantitykind/EquilibriumConstantOnPressureBasis'>;
    "EquilibriumPositionVectorOfIon": NamedNode<'http://qudt.org/vocab/quantitykind/EquilibriumPositionVectorOfIon'>;
    "EquivalentAbsorptionArea": NamedNode<'http://qudt.org/vocab/quantitykind/EquivalentAbsorptionArea'>;
    "EvaporativeHeatTransfer": NamedNode<'http://qudt.org/vocab/quantitykind/EvaporativeHeatTransfer'>;
    "EvaporativeHeatTransferCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/EvaporativeHeatTransferCoefficient'>;
    "ExchangeIntegral": NamedNode<'http://qudt.org/vocab/quantitykind/ExchangeIntegral'>;
    "ExhaustGasesSpecificHeat": NamedNode<'http://qudt.org/vocab/quantitykind/ExhaustGasesSpecificHeat'>;
    "ExhaustGasMeanMolecularWeight": NamedNode<'http://qudt.org/vocab/quantitykind/ExhaustGasMeanMolecularWeight'>;
    "ExhaustStreamPower": NamedNode<'http://qudt.org/vocab/quantitykind/ExhaustStreamPower'>;
    "ExitPlaneCrossSectionalArea": NamedNode<'http://qudt.org/vocab/quantitykind/ExitPlaneCrossSectionalArea'>;
    "ExitPlanePressure": NamedNode<'http://qudt.org/vocab/quantitykind/ExitPlanePressure'>;
    "ExitPlaneTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/ExitPlaneTemperature'>;
    "ExpansionRatio": NamedNode<'http://qudt.org/vocab/quantitykind/ExpansionRatio'>;
    "Exposure": NamedNode<'http://qudt.org/vocab/quantitykind/Exposure'>;
    "ExposureRate": NamedNode<'http://qudt.org/vocab/quantitykind/ExposureRate'>;
    "ExtentOfReaction": NamedNode<'http://qudt.org/vocab/quantitykind/ExtentOfReaction'>;
    "FastFissionFactor": NamedNode<'http://qudt.org/vocab/quantitykind/FastFissionFactor'>;
    "FermiAngularWavenumber": NamedNode<'http://qudt.org/vocab/quantitykind/FermiAngularWavenumber'>;
    "FermiEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/FermiEnergy'>;
    "FermiTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/FermiTemperature'>;
    "FinalOrCurrentVehicleMass": NamedNode<'http://qudt.org/vocab/quantitykind/FinalOrCurrentVehicleMass'>;
    "FirstMomentOfArea": NamedNode<'http://qudt.org/vocab/quantitykind/FirstMomentOfArea'>;
    "FirstStageMassRatio": NamedNode<'http://qudt.org/vocab/quantitykind/FirstStageMassRatio'>;
    "FishBiotransformationHalfLife": NamedNode<'http://qudt.org/vocab/quantitykind/FishBiotransformationHalfLife'>;
    "FissionCoreRadiusToHeightRatio": NamedNode<'http://qudt.org/vocab/quantitykind/FissionCoreRadiusToHeightRatio'>;
    "FissionFuelUtilizationFactor": NamedNode<'http://qudt.org/vocab/quantitykind/FissionFuelUtilizationFactor'>;
    "FissionMultiplicationFactor": NamedNode<'http://qudt.org/vocab/quantitykind/FissionMultiplicationFactor'>;
    "FlashPoint": NamedNode<'http://qudt.org/vocab/quantitykind/FlashPoint'>;
    "FLIGHT-PERFORMANCE-RESERVE-PROPELLANT-MASS": NamedNode<'http://qudt.org/vocab/quantitykind/FLIGHT-PERFORMANCE-RESERVE-PROPELLANT-MASS'>;
    "FlightPathAngle": NamedNode<'http://qudt.org/vocab/quantitykind/FlightPathAngle'>;
    "Flux": NamedNode<'http://qudt.org/vocab/quantitykind/Flux'>;
    "Force": NamedNode<'http://qudt.org/vocab/quantitykind/Force'>;
    "ForceMagnitude": NamedNode<'http://qudt.org/vocab/quantitykind/ForceMagnitude'>;
    "ForcePerAngle": NamedNode<'http://qudt.org/vocab/quantitykind/ForcePerAngle'>;
    "ForcePerArea": NamedNode<'http://qudt.org/vocab/quantitykind/ForcePerArea'>;
    "ForcePerAreaTime": NamedNode<'http://qudt.org/vocab/quantitykind/ForcePerAreaTime'>;
    "ForcePerElectricCharge": NamedNode<'http://qudt.org/vocab/quantitykind/ForcePerElectricCharge'>;
    "ForcePerLength": NamedNode<'http://qudt.org/vocab/quantitykind/ForcePerLength'>;
    "Frequency": NamedNode<'http://qudt.org/vocab/quantitykind/Frequency'>;
    "Friction": NamedNode<'http://qudt.org/vocab/quantitykind/Friction'>;
    "FrictionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/FrictionCoefficient'>;
    "FUEL-BIAS": NamedNode<'http://qudt.org/vocab/quantitykind/FUEL-BIAS'>;
    "Fugacity": NamedNode<'http://qudt.org/vocab/quantitykind/Fugacity'>;
    "FundamentalLatticeVector": NamedNode<'http://qudt.org/vocab/quantitykind/FundamentalLatticeVector'>;
    "FundamentalReciprocalLatticeVector": NamedNode<'http://qudt.org/vocab/quantitykind/FundamentalReciprocalLatticeVector'>;
    "Gain": NamedNode<'http://qudt.org/vocab/quantitykind/Gain'>;
    "GapEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/GapEnergy'>;
    "GeneFamilyAbundance": NamedNode<'http://qudt.org/vocab/quantitykind/GeneFamilyAbundance'>;
    "GeneralizedCoordinate": NamedNode<'http://qudt.org/vocab/quantitykind/GeneralizedCoordinate'>;
    "GeneralizedForce": NamedNode<'http://qudt.org/vocab/quantitykind/GeneralizedForce'>;
    "GeneralizedMomentum": NamedNode<'http://qudt.org/vocab/quantitykind/GeneralizedMomentum'>;
    "GeneralizedVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/GeneralizedVelocity'>;
    "GFactorOfNucleus": NamedNode<'http://qudt.org/vocab/quantitykind/GFactorOfNucleus'>;
    "GibbsEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/GibbsEnergy'>;
    "GrandCanonicalPartitionFunction": NamedNode<'http://qudt.org/vocab/quantitykind/GrandCanonicalPartitionFunction'>;
    "GravitationalAttraction": NamedNode<'http://qudt.org/vocab/quantitykind/GravitationalAttraction'>;
    "Gravity_API": NamedNode<'http://qudt.org/vocab/quantitykind/Gravity_API'>;
    "GROSS-LIFT-OFF-WEIGHT": NamedNode<'http://qudt.org/vocab/quantitykind/GROSS-LIFT-OFF-WEIGHT'>;
    "GroupSpeedOfSound": NamedNode<'http://qudt.org/vocab/quantitykind/GroupSpeedOfSound'>;
    "GrowingDegreeDay_Cereal": NamedNode<'http://qudt.org/vocab/quantitykind/GrowingDegreeDay_Cereal'>;
    "GruneisenParameter": NamedNode<'http://qudt.org/vocab/quantitykind/GruneisenParameter'>;
    "GustatoryThreshold": NamedNode<'http://qudt.org/vocab/quantitykind/GustatoryThreshold'>;
    "GyromagneticRatio": NamedNode<'http://qudt.org/vocab/quantitykind/GyromagneticRatio'>;
    "Half-Life": NamedNode<'http://qudt.org/vocab/quantitykind/Half-Life'>;
    "Half-ValueThickness": NamedNode<'http://qudt.org/vocab/quantitykind/Half-ValueThickness'>;
    "HallCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/HallCoefficient'>;
    "HamiltonFunction": NamedNode<'http://qudt.org/vocab/quantitykind/HamiltonFunction'>;
    "HeadEndPressure": NamedNode<'http://qudt.org/vocab/quantitykind/HeadEndPressure'>;
    "HeartRate": NamedNode<'http://qudt.org/vocab/quantitykind/HeartRate'>;
    "Heat": NamedNode<'http://qudt.org/vocab/quantitykind/Heat'>;
    "HeatCapacity": NamedNode<'http://qudt.org/vocab/quantitykind/HeatCapacity'>;
    "HeatCapacityRatio": NamedNode<'http://qudt.org/vocab/quantitykind/HeatCapacityRatio'>;
    "HeatFlowRate": NamedNode<'http://qudt.org/vocab/quantitykind/HeatFlowRate'>;
    "HeatFlowRatePerUnitArea": NamedNode<'http://qudt.org/vocab/quantitykind/HeatFlowRatePerUnitArea'>;
    "HeatFluxDensity": NamedNode<'http://qudt.org/vocab/quantitykind/HeatFluxDensity'>;
    "HeatingValue": NamedNode<'http://qudt.org/vocab/quantitykind/HeatingValue'>;
    "Height": NamedNode<'http://qudt.org/vocab/quantitykind/Height'>;
    "HelmholtzEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/HelmholtzEnergy'>;
    "HenrysLawVolatilityConstant": NamedNode<'http://qudt.org/vocab/quantitykind/HenrysLawVolatilityConstant'>;
    "HoleDensity": NamedNode<'http://qudt.org/vocab/quantitykind/HoleDensity'>;
    "HorizontalVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/HorizontalVelocity'>;
    "HyperfineStructureQuantumNumber": NamedNode<'http://qudt.org/vocab/quantitykind/HyperfineStructureQuantumNumber'>;
    "IgnitionIntervalTime": NamedNode<'http://qudt.org/vocab/quantitykind/IgnitionIntervalTime'>;
    "Illuminance": NamedNode<'http://qudt.org/vocab/quantitykind/Illuminance'>;
    "Impedance": NamedNode<'http://qudt.org/vocab/quantitykind/Impedance'>;
    "Incidence": NamedNode<'http://qudt.org/vocab/quantitykind/Incidence'>;
    "IncidenceProportion": NamedNode<'http://qudt.org/vocab/quantitykind/IncidenceProportion'>;
    "IncidenceRate": NamedNode<'http://qudt.org/vocab/quantitykind/IncidenceRate'>;
    "Inductance": NamedNode<'http://qudt.org/vocab/quantitykind/Inductance'>;
    "INERT-MASS": NamedNode<'http://qudt.org/vocab/quantitykind/INERT-MASS'>;
    "InfiniteMultiplicationFactor": NamedNode<'http://qudt.org/vocab/quantitykind/InfiniteMultiplicationFactor'>;
    "InformationEntropy": NamedNode<'http://qudt.org/vocab/quantitykind/InformationEntropy'>;
    "InformationFlowRate": NamedNode<'http://qudt.org/vocab/quantitykind/InformationFlowRate'>;
    "InitialExpansionRatio": NamedNode<'http://qudt.org/vocab/quantitykind/InitialExpansionRatio'>;
    "InitialNozzleThroatDiameter": NamedNode<'http://qudt.org/vocab/quantitykind/InitialNozzleThroatDiameter'>;
    "InitialVehicleMass": NamedNode<'http://qudt.org/vocab/quantitykind/InitialVehicleMass'>;
    "InitialVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/InitialVelocity'>;
    "InstantaneousPower": NamedNode<'http://qudt.org/vocab/quantitykind/InstantaneousPower'>;
    "InternalConversionFactor": NamedNode<'http://qudt.org/vocab/quantitykind/InternalConversionFactor'>;
    "InternalEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/InternalEnergy'>;
    "IntinsicCarrierDensity": NamedNode<'http://qudt.org/vocab/quantitykind/IntinsicCarrierDensity'>;
    "InverseAmountOfSubstance": NamedNode<'http://qudt.org/vocab/quantitykind/InverseAmountOfSubstance'>;
    "InverseEnergy_Squared": NamedNode<'http://qudt.org/vocab/quantitykind/InverseEnergy_Squared'>;
    "InverseEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/InverseEnergy'>;
    "InverseLength": NamedNode<'http://qudt.org/vocab/quantitykind/InverseLength'>;
    "InverseLengthTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/InverseLengthTemperature'>;
    "InverseMagneticFlux": NamedNode<'http://qudt.org/vocab/quantitykind/InverseMagneticFlux'>;
    "InverseMass_Squared": NamedNode<'http://qudt.org/vocab/quantitykind/InverseMass_Squared'>;
    "InversePermittivity": NamedNode<'http://qudt.org/vocab/quantitykind/InversePermittivity'>;
    "InversePressure": NamedNode<'http://qudt.org/vocab/quantitykind/InversePressure'>;
    "InverseSquareEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/InverseSquareEnergy'>;
    "InverseSquareMass": NamedNode<'http://qudt.org/vocab/quantitykind/InverseSquareMass'>;
    "InverseSquareTime": NamedNode<'http://qudt.org/vocab/quantitykind/InverseSquareTime'>;
    "InverseTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/InverseTemperature'>;
    "InverseTime_Squared": NamedNode<'http://qudt.org/vocab/quantitykind/InverseTime_Squared'>;
    "InverseTime": NamedNode<'http://qudt.org/vocab/quantitykind/InverseTime'>;
    "InverseTimeTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/InverseTimeTemperature'>;
    "InverseVolume": NamedNode<'http://qudt.org/vocab/quantitykind/InverseVolume'>;
    "IonConcentration": NamedNode<'http://qudt.org/vocab/quantitykind/IonConcentration'>;
    "IonCurrent": NamedNode<'http://qudt.org/vocab/quantitykind/IonCurrent'>;
    "IonDensity": NamedNode<'http://qudt.org/vocab/quantitykind/IonDensity'>;
    "IonicCharge": NamedNode<'http://qudt.org/vocab/quantitykind/IonicCharge'>;
    "IonicStrength": NamedNode<'http://qudt.org/vocab/quantitykind/IonicStrength'>;
    "IonizationEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/IonizationEnergy'>;
    "IonTransportNumber": NamedNode<'http://qudt.org/vocab/quantitykind/IonTransportNumber'>;
    "Irradiance": NamedNode<'http://qudt.org/vocab/quantitykind/Irradiance'>;
    "IsentropicCompressibility": NamedNode<'http://qudt.org/vocab/quantitykind/IsentropicCompressibility'>;
    "IsentropicExponent": NamedNode<'http://qudt.org/vocab/quantitykind/IsentropicExponent'>;
    "IsothermalCompressibility": NamedNode<'http://qudt.org/vocab/quantitykind/IsothermalCompressibility'>;
    "IsothermalMoistureCapacity": NamedNode<'http://qudt.org/vocab/quantitykind/IsothermalMoistureCapacity'>;
    "Kerma": NamedNode<'http://qudt.org/vocab/quantitykind/Kerma'>;
    "KermaRate": NamedNode<'http://qudt.org/vocab/quantitykind/KermaRate'>;
    "KinematicViscosity": NamedNode<'http://qudt.org/vocab/quantitykind/KinematicViscosity'>;
    "KineticEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/KineticEnergy'>;
    "LagrangeFunction": NamedNode<'http://qudt.org/vocab/quantitykind/LagrangeFunction'>;
    "Landau-GinzburgNumber": NamedNode<'http://qudt.org/vocab/quantitykind/Landau-GinzburgNumber'>;
    "LandeGFactor": NamedNode<'http://qudt.org/vocab/quantitykind/LandeGFactor'>;
    "LarmorAngularFrequency": NamedNode<'http://qudt.org/vocab/quantitykind/LarmorAngularFrequency'>;
    "LatticePlaneSpacing": NamedNode<'http://qudt.org/vocab/quantitykind/LatticePlaneSpacing'>;
    "LatticeVector": NamedNode<'http://qudt.org/vocab/quantitykind/LatticeVector'>;
    "LeakageFactor": NamedNode<'http://qudt.org/vocab/quantitykind/LeakageFactor'>;
    "Length": NamedNode<'http://qudt.org/vocab/quantitykind/Length'>;
    "LengthByForce": NamedNode<'http://qudt.org/vocab/quantitykind/LengthByForce'>;
    "LengthEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/LengthEnergy'>;
    "LengthMass": NamedNode<'http://qudt.org/vocab/quantitykind/LengthMass'>;
    "LengthMolarEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/LengthMolarEnergy'>;
    "LengthPercentage": NamedNode<'http://qudt.org/vocab/quantitykind/LengthPercentage'>;
    "LengthPerUnitElectricCurrent": NamedNode<'http://qudt.org/vocab/quantitykind/LengthPerUnitElectricCurrent'>;
    "LengthRatio": NamedNode<'http://qudt.org/vocab/quantitykind/LengthRatio'>;
    "LengthTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/LengthTemperature'>;
    "LengthTemperatureTime": NamedNode<'http://qudt.org/vocab/quantitykind/LengthTemperatureTime'>;
    "Lethargy": NamedNode<'http://qudt.org/vocab/quantitykind/Lethargy'>;
    "LevelWidth": NamedNode<'http://qudt.org/vocab/quantitykind/LevelWidth'>;
    "LiftCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/LiftCoefficient'>;
    "LiftForce": NamedNode<'http://qudt.org/vocab/quantitykind/LiftForce'>;
    "LinearAbsorptionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/LinearAbsorptionCoefficient'>;
    "LinearAcceleration": NamedNode<'http://qudt.org/vocab/quantitykind/LinearAcceleration'>;
    "LinearAttenuationCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/LinearAttenuationCoefficient'>;
    "LinearCompressibility": NamedNode<'http://qudt.org/vocab/quantitykind/LinearCompressibility'>;
    "LinearDensity": NamedNode<'http://qudt.org/vocab/quantitykind/LinearDensity'>;
    "LinearElectricCurrent": NamedNode<'http://qudt.org/vocab/quantitykind/LinearElectricCurrent'>;
    "LinearElectricCurrentDensity": NamedNode<'http://qudt.org/vocab/quantitykind/LinearElectricCurrentDensity'>;
    "LinearEnergyTransfer": NamedNode<'http://qudt.org/vocab/quantitykind/LinearEnergyTransfer'>;
    "LinearExpansionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/LinearExpansionCoefficient'>;
    "LinearForce": NamedNode<'http://qudt.org/vocab/quantitykind/LinearForce'>;
    "LinearIonization": NamedNode<'http://qudt.org/vocab/quantitykind/LinearIonization'>;
    "LinearMomentum": NamedNode<'http://qudt.org/vocab/quantitykind/LinearMomentum'>;
    "LinearStiffness": NamedNode<'http://qudt.org/vocab/quantitykind/LinearStiffness'>;
    "LinearStrain": NamedNode<'http://qudt.org/vocab/quantitykind/LinearStrain'>;
    "LinearThermalExpansion": NamedNode<'http://qudt.org/vocab/quantitykind/LinearThermalExpansion'>;
    "LinearVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/LinearVelocity'>;
    "LinkedFlux": NamedNode<'http://qudt.org/vocab/quantitykind/LinkedFlux'>;
    "LiquidVolume": NamedNode<'http://qudt.org/vocab/quantitykind/LiquidVolume'>;
    "LogarithmicFrequencyInterval": NamedNode<'http://qudt.org/vocab/quantitykind/LogarithmicFrequencyInterval'>;
    "LogOctanolAirPartitionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/LogOctanolAirPartitionCoefficient'>;
    "LogOctanolWaterPartitionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/LogOctanolWaterPartitionCoefficient'>;
    "LondonPenetrationDepth": NamedNode<'http://qudt.org/vocab/quantitykind/LondonPenetrationDepth'>;
    "Long-RangeOrderParameter": NamedNode<'http://qudt.org/vocab/quantitykind/Long-RangeOrderParameter'>;
    "LorenzCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/LorenzCoefficient'>;
    "LossAngle": NamedNode<'http://qudt.org/vocab/quantitykind/LossAngle'>;
    "LossFactor": NamedNode<'http://qudt.org/vocab/quantitykind/LossFactor'>;
    "LowerCriticalMagneticFluxDensity": NamedNode<'http://qudt.org/vocab/quantitykind/LowerCriticalMagneticFluxDensity'>;
    "Luminance": NamedNode<'http://qudt.org/vocab/quantitykind/Luminance'>;
    "LuminousEfficacy": NamedNode<'http://qudt.org/vocab/quantitykind/LuminousEfficacy'>;
    "LuminousEmittance": NamedNode<'http://qudt.org/vocab/quantitykind/LuminousEmittance'>;
    "LuminousEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/LuminousEnergy'>;
    "LuminousExposure": NamedNode<'http://qudt.org/vocab/quantitykind/LuminousExposure'>;
    "LuminousFlux": NamedNode<'http://qudt.org/vocab/quantitykind/LuminousFlux'>;
    "LuminousFluxPerArea": NamedNode<'http://qudt.org/vocab/quantitykind/LuminousFluxPerArea'>;
    "LuminousFluxRatio": NamedNode<'http://qudt.org/vocab/quantitykind/LuminousFluxRatio'>;
    "LuminousIntensity": NamedNode<'http://qudt.org/vocab/quantitykind/LuminousIntensity'>;
    "LuminousIntensityDistribution": NamedNode<'http://qudt.org/vocab/quantitykind/LuminousIntensityDistribution'>;
    "MachNumber": NamedNode<'http://qudt.org/vocab/quantitykind/MachNumber'>;
    "MacroscopicCrossSection": NamedNode<'http://qudt.org/vocab/quantitykind/MacroscopicCrossSection'>;
    "MacroscopicTotalCrossSection": NamedNode<'http://qudt.org/vocab/quantitykind/MacroscopicTotalCrossSection'>;
    "MadelungConstant": NamedNode<'http://qudt.org/vocab/quantitykind/MadelungConstant'>;
    "MagneticAreaMoment": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticAreaMoment'>;
    "MagneticDipoleMoment": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticDipoleMoment'>;
    "MagneticField": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticField'>;
    "MagneticFieldStrength_H": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticFieldStrength_H'>;
    "MagneticFlux": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticFlux'>;
    "MagneticFluxDensity": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticFluxDensity'>;
    "MagneticFluxPerUnitLength": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticFluxPerUnitLength'>;
    "MagneticMoment": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticMoment'>;
    "MagneticPolarization": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticPolarization'>;
    "MagneticQuantumNumber": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticQuantumNumber'>;
    "MagneticReluctivity": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticReluctivity'>;
    "MagneticSusceptability": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticSusceptability'>;
    "MagneticTension": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticTension'>;
    "MagneticVectorPotential": NamedNode<'http://qudt.org/vocab/quantitykind/MagneticVectorPotential'>;
    "Magnetization": NamedNode<'http://qudt.org/vocab/quantitykind/Magnetization'>;
    "MagnetizationField": NamedNode<'http://qudt.org/vocab/quantitykind/MagnetizationField'>;
    "MagnetomotiveForce": NamedNode<'http://qudt.org/vocab/quantitykind/MagnetomotiveForce'>;
    "MASS-DELIVERED": NamedNode<'http://qudt.org/vocab/quantitykind/MASS-DELIVERED'>;
    "MASS-GROWTH-ALLOWANCE": NamedNode<'http://qudt.org/vocab/quantitykind/MASS-GROWTH-ALLOWANCE'>;
    "MASS-MARGIN": NamedNode<'http://qudt.org/vocab/quantitykind/MASS-MARGIN'>;
    "MASS-PROPERTY-UNCERTAINTY": NamedNode<'http://qudt.org/vocab/quantitykind/MASS-PROPERTY-UNCERTAINTY'>;
    "Mass": NamedNode<'http://qudt.org/vocab/quantitykind/Mass'>;
    "MassAbsorptionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/MassAbsorptionCoefficient'>;
    "MassAmountOfSubstance": NamedNode<'http://qudt.org/vocab/quantitykind/MassAmountOfSubstance'>;
    "MassAmountOfSubstanceTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/MassAmountOfSubstanceTemperature'>;
    "MassAttenuationCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/MassAttenuationCoefficient'>;
    "MassConcentration": NamedNode<'http://qudt.org/vocab/quantitykind/MassConcentration'>;
    "MassConcentrationOfWater": NamedNode<'http://qudt.org/vocab/quantitykind/MassConcentrationOfWater'>;
    "MassConcentrationOfWaterVapour": NamedNode<'http://qudt.org/vocab/quantitykind/MassConcentrationOfWaterVapour'>;
    "MassDefect": NamedNode<'http://qudt.org/vocab/quantitykind/MassDefect'>;
    "MassDensity": NamedNode<'http://qudt.org/vocab/quantitykind/MassDensity'>;
    "MassEnergyTransferCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/MassEnergyTransferCoefficient'>;
    "MassExcess": NamedNode<'http://qudt.org/vocab/quantitykind/MassExcess'>;
    "MassFlowRate": NamedNode<'http://qudt.org/vocab/quantitykind/MassFlowRate'>;
    "MassFraction": NamedNode<'http://qudt.org/vocab/quantitykind/MassFraction'>;
    "MassFractionOfDryMatter": NamedNode<'http://qudt.org/vocab/quantitykind/MassFractionOfDryMatter'>;
    "MassFractionOfWater": NamedNode<'http://qudt.org/vocab/quantitykind/MassFractionOfWater'>;
    "MassicActivity": NamedNode<'http://qudt.org/vocab/quantitykind/MassicActivity'>;
    "MassieuFunction": NamedNode<'http://qudt.org/vocab/quantitykind/MassieuFunction'>;
    "MassNumber": NamedNode<'http://qudt.org/vocab/quantitykind/MassNumber'>;
    "MassOfElectricalPowerSupply": NamedNode<'http://qudt.org/vocab/quantitykind/MassOfElectricalPowerSupply'>;
    "MassOfSolidBooster": NamedNode<'http://qudt.org/vocab/quantitykind/MassOfSolidBooster'>;
    "MassOfTheEarth": NamedNode<'http://qudt.org/vocab/quantitykind/MassOfTheEarth'>;
    "MassPerArea": NamedNode<'http://qudt.org/vocab/quantitykind/MassPerArea'>;
    "MassPerAreaTime": NamedNode<'http://qudt.org/vocab/quantitykind/MassPerAreaTime'>;
    "MassPerElectricCharge": NamedNode<'http://qudt.org/vocab/quantitykind/MassPerElectricCharge'>;
    "MassPerLength": NamedNode<'http://qudt.org/vocab/quantitykind/MassPerLength'>;
    "MassPerTime": NamedNode<'http://qudt.org/vocab/quantitykind/MassPerTime'>;
    "MassRatio": NamedNode<'http://qudt.org/vocab/quantitykind/MassRatio'>;
    "MassRatioOfWaterToDryMatter": NamedNode<'http://qudt.org/vocab/quantitykind/MassRatioOfWaterToDryMatter'>;
    "MassRatioOfWaterVapourToDryGas": NamedNode<'http://qudt.org/vocab/quantitykind/MassRatioOfWaterVapourToDryGas'>;
    "MassTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/MassTemperature'>;
    "MaxExpectedOperatingThrust": NamedNode<'http://qudt.org/vocab/quantitykind/MaxExpectedOperatingThrust'>;
    "MaximumBeta-ParticleEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/MaximumBeta-ParticleEnergy'>;
    "MaximumExpectedOperatingPressure": NamedNode<'http://qudt.org/vocab/quantitykind/MaximumExpectedOperatingPressure'>;
    "MaximumOperatingPressure": NamedNode<'http://qudt.org/vocab/quantitykind/MaximumOperatingPressure'>;
    "MaxOperatingThrust": NamedNode<'http://qudt.org/vocab/quantitykind/MaxOperatingThrust'>;
    /** Max Sea Level thrust (Mlbf) */
    "MaxSeaLevelThrust": NamedNode<'http://qudt.org/vocab/quantitykind/MaxSeaLevelThrust'>;
    "MeanEnergyImparted": NamedNode<'http://qudt.org/vocab/quantitykind/MeanEnergyImparted'>;
    "MeanFreePath": NamedNode<'http://qudt.org/vocab/quantitykind/MeanFreePath'>;
    "MeanLifetime": NamedNode<'http://qudt.org/vocab/quantitykind/MeanLifetime'>;
    "MeanLinearRange": NamedNode<'http://qudt.org/vocab/quantitykind/MeanLinearRange'>;
    "MeanMassRange": NamedNode<'http://qudt.org/vocab/quantitykind/MeanMassRange'>;
    "MechanicalEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/MechanicalEnergy'>;
    "MechanicalImpedance": NamedNode<'http://qudt.org/vocab/quantitykind/MechanicalImpedance'>;
    "MechanicalMobility": NamedNode<'http://qudt.org/vocab/quantitykind/MechanicalMobility'>;
    /** There are various interpretations of MechanicalSurfaceImpedance: Pressure/Velocity - https://apps.dtic.mil/sti/pdfs/ADA315595.pdf, Force / Speed - https://www.wikidata.org/wiki/Q6421317, and (Pressure / Velocity)**0.5 - https://www.sciencedirect.com/topics/engineering/mechanical-impedance. We are seeking a resolution to these differences. */
    "MechanicalSurfaceImpedance": NamedNode<'http://qudt.org/vocab/quantitykind/MechanicalSurfaceImpedance'>;
    "MeltingPoint": NamedNode<'http://qudt.org/vocab/quantitykind/MeltingPoint'>;
    "MicrobialFormation": NamedNode<'http://qudt.org/vocab/quantitykind/MicrobialFormation'>;
    "MicroCanonicalPartitionFunction": NamedNode<'http://qudt.org/vocab/quantitykind/MicroCanonicalPartitionFunction'>;
    "MigrationArea": NamedNode<'http://qudt.org/vocab/quantitykind/MigrationArea'>;
    "MigrationLength": NamedNode<'http://qudt.org/vocab/quantitykind/MigrationLength'>;
    "Mobility": NamedNode<'http://qudt.org/vocab/quantitykind/Mobility'>;
    "MobilityRatio": NamedNode<'http://qudt.org/vocab/quantitykind/MobilityRatio'>;
    "ModulusOfAdmittance": NamedNode<'http://qudt.org/vocab/quantitykind/ModulusOfAdmittance'>;
    "ModulusOfElasticity": NamedNode<'http://qudt.org/vocab/quantitykind/ModulusOfElasticity'>;
    "ModulusOfImpedance": NamedNode<'http://qudt.org/vocab/quantitykind/ModulusOfImpedance'>;
    "ModulusOfLinearSubgradeReaction": NamedNode<'http://qudt.org/vocab/quantitykind/ModulusOfLinearSubgradeReaction'>;
    "ModulusOfRotationalSubgradeReaction": NamedNode<'http://qudt.org/vocab/quantitykind/ModulusOfRotationalSubgradeReaction'>;
    "ModulusOfSubgradeReaction": NamedNode<'http://qudt.org/vocab/quantitykind/ModulusOfSubgradeReaction'>;
    "MoistureDiffusivity": NamedNode<'http://qudt.org/vocab/quantitykind/MoistureDiffusivity'>;
    "MolalityOfSolute": NamedNode<'http://qudt.org/vocab/quantitykind/MolalityOfSolute'>;
    "MolarAbsorptionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/MolarAbsorptionCoefficient'>;
    "MolarAngularMomentum": NamedNode<'http://qudt.org/vocab/quantitykind/MolarAngularMomentum'>;
    "MolarAttenuationCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/MolarAttenuationCoefficient'>;
    "MolarConductivity": NamedNode<'http://qudt.org/vocab/quantitykind/MolarConductivity'>;
    "MolarEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/MolarEnergy'>;
    "MolarEntropy": NamedNode<'http://qudt.org/vocab/quantitykind/MolarEntropy'>;
    "MolarFlowRate": NamedNode<'http://qudt.org/vocab/quantitykind/MolarFlowRate'>;
    "MolarHeatCapacity": NamedNode<'http://qudt.org/vocab/quantitykind/MolarHeatCapacity'>;
    "MolarMass": NamedNode<'http://qudt.org/vocab/quantitykind/MolarMass'>;
    "MolarOpticalRotatoryPower": NamedNode<'http://qudt.org/vocab/quantitykind/MolarOpticalRotatoryPower'>;
    "MolarRefractivity": NamedNode<'http://qudt.org/vocab/quantitykind/MolarRefractivity'>;
    "MolarVolume": NamedNode<'http://qudt.org/vocab/quantitykind/MolarVolume'>;
    "MolecularConcentration": NamedNode<'http://qudt.org/vocab/quantitykind/MolecularConcentration'>;
    "MolecularMass": NamedNode<'http://qudt.org/vocab/quantitykind/MolecularMass'>;
    "MolecularViscosity": NamedNode<'http://qudt.org/vocab/quantitykind/MolecularViscosity'>;
    "MoleFraction": NamedNode<'http://qudt.org/vocab/quantitykind/MoleFraction'>;
    "MOMENT-OF-INERTIA_Y": NamedNode<'http://qudt.org/vocab/quantitykind/MOMENT-OF-INERTIA_Y'>;
    "MOMENT-OF-INERTIA_Z": NamedNode<'http://qudt.org/vocab/quantitykind/MOMENT-OF-INERTIA_Z'>;
    "MomentOfForce": NamedNode<'http://qudt.org/vocab/quantitykind/MomentOfForce'>;
    "MomentOfInertia": NamedNode<'http://qudt.org/vocab/quantitykind/MomentOfInertia'>;
    "Momentum": NamedNode<'http://qudt.org/vocab/quantitykind/Momentum'>;
    "MomentumPerAngle": NamedNode<'http://qudt.org/vocab/quantitykind/MomentumPerAngle'>;
    "MorbidityRate": NamedNode<'http://qudt.org/vocab/quantitykind/MorbidityRate'>;
    "MortalityRate": NamedNode<'http://qudt.org/vocab/quantitykind/MortalityRate'>;
    "MultiplicationFactor": NamedNode<'http://qudt.org/vocab/quantitykind/MultiplicationFactor'>;
    "MutualInductance": NamedNode<'http://qudt.org/vocab/quantitykind/MutualInductance'>;
    "NapierianAbsorbance": NamedNode<'http://qudt.org/vocab/quantitykind/NapierianAbsorbance'>;
    "NeelTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/NeelTemperature'>;
    "NeutronDiffusionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/NeutronDiffusionCoefficient'>;
    "NeutronDiffusionLength": NamedNode<'http://qudt.org/vocab/quantitykind/NeutronDiffusionLength'>;
    "NeutronNumber": NamedNode<'http://qudt.org/vocab/quantitykind/NeutronNumber'>;
    "NeutronYieldPerAbsorption": NamedNode<'http://qudt.org/vocab/quantitykind/NeutronYieldPerAbsorption'>;
    "NeutronYieldPerFission": NamedNode<'http://qudt.org/vocab/quantitykind/NeutronYieldPerFission'>;
    "NOMINAL-ASCENT-PROPELLANT-MASS": NamedNode<'http://qudt.org/vocab/quantitykind/NOMINAL-ASCENT-PROPELLANT-MASS'>;
    "Non-LeakageProbability": NamedNode<'http://qudt.org/vocab/quantitykind/Non-LeakageProbability'>;
    "NonActivePower": NamedNode<'http://qudt.org/vocab/quantitykind/NonActivePower'>;
    "NonNegativeLength": NamedNode<'http://qudt.org/vocab/quantitykind/NonNegativeLength'>;
    "NormalizedDimensionlessRatio": NamedNode<'http://qudt.org/vocab/quantitykind/NormalizedDimensionlessRatio'>;
    "NormalStress": NamedNode<'http://qudt.org/vocab/quantitykind/NormalStress'>;
    "NozzleThroatCrossSectionalArea": NamedNode<'http://qudt.org/vocab/quantitykind/NozzleThroatCrossSectionalArea'>;
    "NozzleThroatDiameter": NamedNode<'http://qudt.org/vocab/quantitykind/NozzleThroatDiameter'>;
    "NozzleThroatPressure": NamedNode<'http://qudt.org/vocab/quantitykind/NozzleThroatPressure'>;
    "NozzleWallsThrustReaction": NamedNode<'http://qudt.org/vocab/quantitykind/NozzleWallsThrustReaction'>;
    "NuclearQuadrupoleMoment": NamedNode<'http://qudt.org/vocab/quantitykind/NuclearQuadrupoleMoment'>;
    "NuclearRadius": NamedNode<'http://qudt.org/vocab/quantitykind/NuclearRadius'>;
    "NuclearSpinQuantumNumber": NamedNode<'http://qudt.org/vocab/quantitykind/NuclearSpinQuantumNumber'>;
    "NucleonNumber": NamedNode<'http://qudt.org/vocab/quantitykind/NucleonNumber'>;
    "NumberDensity": NamedNode<'http://qudt.org/vocab/quantitykind/NumberDensity'>;
    "NumberOfParticles": NamedNode<'http://qudt.org/vocab/quantitykind/NumberOfParticles'>;
    "OlfactoryThreshold": NamedNode<'http://qudt.org/vocab/quantitykind/OlfactoryThreshold'>;
    "OrbitalAngularMomentumPerUnitMass": NamedNode<'http://qudt.org/vocab/quantitykind/OrbitalAngularMomentumPerUnitMass'>;
    "OrbitalAngularMomentumQuantumNumber": NamedNode<'http://qudt.org/vocab/quantitykind/OrbitalAngularMomentumQuantumNumber'>;
    "OrbitalRadialDistance": NamedNode<'http://qudt.org/vocab/quantitykind/OrbitalRadialDistance'>;
    "OrderOfReflection": NamedNode<'http://qudt.org/vocab/quantitykind/OrderOfReflection'>;
    "OsmoticCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/OsmoticCoefficient'>;
    "OsmoticPressure": NamedNode<'http://qudt.org/vocab/quantitykind/OsmoticPressure'>;
    "OverRangeDistance": NamedNode<'http://qudt.org/vocab/quantitykind/OverRangeDistance'>;
    "PackingFraction": NamedNode<'http://qudt.org/vocab/quantitykind/PackingFraction'>;
    "PartialPressure": NamedNode<'http://qudt.org/vocab/quantitykind/PartialPressure'>;
    "ParticleCurrent": NamedNode<'http://qudt.org/vocab/quantitykind/ParticleCurrent'>;
    "ParticleFluence": NamedNode<'http://qudt.org/vocab/quantitykind/ParticleFluence'>;
    "ParticleFluenceRate": NamedNode<'http://qudt.org/vocab/quantitykind/ParticleFluenceRate'>;
    "ParticleNumberDensity": NamedNode<'http://qudt.org/vocab/quantitykind/ParticleNumberDensity'>;
    "ParticlePositionVector": NamedNode<'http://qudt.org/vocab/quantitykind/ParticlePositionVector'>;
    "ParticleSourceDensity": NamedNode<'http://qudt.org/vocab/quantitykind/ParticleSourceDensity'>;
    "PathLength": NamedNode<'http://qudt.org/vocab/quantitykind/PathLength'>;
    "PayloadMass": NamedNode<'http://qudt.org/vocab/quantitykind/PayloadMass'>;
    "PayloadRatio": NamedNode<'http://qudt.org/vocab/quantitykind/PayloadRatio'>;
    "PeltierCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/PeltierCoefficient'>;
    "Period": NamedNode<'http://qudt.org/vocab/quantitykind/Period'>;
    "Permeability": NamedNode<'http://qudt.org/vocab/quantitykind/Permeability'>;
    "PermeabilityRatio": NamedNode<'http://qudt.org/vocab/quantitykind/PermeabilityRatio'>;
    "Permeance": NamedNode<'http://qudt.org/vocab/quantitykind/Permeance'>;
    "Permittivity": NamedNode<'http://qudt.org/vocab/quantitykind/Permittivity'>;
    "PermittivityRatio": NamedNode<'http://qudt.org/vocab/quantitykind/PermittivityRatio'>;
    "PH": NamedNode<'http://qudt.org/vocab/quantitykind/PH'>;
    "PhaseCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/PhaseCoefficient'>;
    "PhaseDifference": NamedNode<'http://qudt.org/vocab/quantitykind/PhaseDifference'>;
    "PhaseSpeedOfSound": NamedNode<'http://qudt.org/vocab/quantitykind/PhaseSpeedOfSound'>;
    "PhononMeanFreePath": NamedNode<'http://qudt.org/vocab/quantitykind/PhononMeanFreePath'>;
    "PhotonIntensity": NamedNode<'http://qudt.org/vocab/quantitykind/PhotonIntensity'>;
    "PhotonRadiance": NamedNode<'http://qudt.org/vocab/quantitykind/PhotonRadiance'>;
    "PhotosyntheticPhotonFlux": NamedNode<'http://qudt.org/vocab/quantitykind/PhotosyntheticPhotonFlux'>;
    "PhotosyntheticPhotonFluxDensity": NamedNode<'http://qudt.org/vocab/quantitykind/PhotosyntheticPhotonFluxDensity'>;
    "PhotoThresholdOfAwarenessFunction": NamedNode<'http://qudt.org/vocab/quantitykind/PhotoThresholdOfAwarenessFunction'>;
    "PlanarForce": NamedNode<'http://qudt.org/vocab/quantitykind/PlanarForce'>;
    "PlanckFunction": NamedNode<'http://qudt.org/vocab/quantitykind/PlanckFunction'>;
    "PlaneAngle": NamedNode<'http://qudt.org/vocab/quantitykind/PlaneAngle'>;
    "PoissonRatio": NamedNode<'http://qudt.org/vocab/quantitykind/PoissonRatio'>;
    "Polarizability": NamedNode<'http://qudt.org/vocab/quantitykind/Polarizability'>;
    "PolarizationField": NamedNode<'http://qudt.org/vocab/quantitykind/PolarizationField'>;
    "PolarMomentOfInertia": NamedNode<'http://qudt.org/vocab/quantitykind/PolarMomentOfInertia'>;
    "Population": NamedNode<'http://qudt.org/vocab/quantitykind/Population'>;
    "PositionVector": NamedNode<'http://qudt.org/vocab/quantitykind/PositionVector'>;
    "PositiveDimensionlessRatio": NamedNode<'http://qudt.org/vocab/quantitykind/PositiveDimensionlessRatio'>;
    "PositiveLength": NamedNode<'http://qudt.org/vocab/quantitykind/PositiveLength'>;
    "PositivePlaneAngle": NamedNode<'http://qudt.org/vocab/quantitykind/PositivePlaneAngle'>;
    "PotentialEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/PotentialEnergy'>;
    "Power": NamedNode<'http://qudt.org/vocab/quantitykind/Power'>;
    "PowerArea": NamedNode<'http://qudt.org/vocab/quantitykind/PowerArea'>;
    "PowerAreaPerSolidAngle": NamedNode<'http://qudt.org/vocab/quantitykind/PowerAreaPerSolidAngle'>;
    "PowerFactor": NamedNode<'http://qudt.org/vocab/quantitykind/PowerFactor'>;
    "PowerPerArea": NamedNode<'http://qudt.org/vocab/quantitykind/PowerPerArea'>;
    "PowerPerAreaAngle": NamedNode<'http://qudt.org/vocab/quantitykind/PowerPerAreaAngle'>;
    "PowerPerAreaQuarticTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/PowerPerAreaQuarticTemperature'>;
    "PowerPerElectricCharge": NamedNode<'http://qudt.org/vocab/quantitykind/PowerPerElectricCharge'>;
    "PoyntingVector": NamedNode<'http://qudt.org/vocab/quantitykind/PoyntingVector'>;
    "PREDICTED-MASS": NamedNode<'http://qudt.org/vocab/quantitykind/PREDICTED-MASS'>;
    "Pressure": NamedNode<'http://qudt.org/vocab/quantitykind/Pressure'>;
    "PressureBurningRateConstant": NamedNode<'http://qudt.org/vocab/quantitykind/PressureBurningRateConstant'>;
    "PressureBurningRateIndex": NamedNode<'http://qudt.org/vocab/quantitykind/PressureBurningRateIndex'>;
    "PressureCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/PressureCoefficient'>;
    "PressureLossPerLength": NamedNode<'http://qudt.org/vocab/quantitykind/PressureLossPerLength'>;
    "PressurePercentage": NamedNode<'http://qudt.org/vocab/quantitykind/PressurePercentage'>;
    "PressureRatio": NamedNode<'http://qudt.org/vocab/quantitykind/PressureRatio'>;
    "Prevalence": NamedNode<'http://qudt.org/vocab/quantitykind/Prevalence'>;
    "PrincipalQuantumNumber": NamedNode<'http://qudt.org/vocab/quantitykind/PrincipalQuantumNumber'>;
    "PRODUCT-OF-INERTIA_X": NamedNode<'http://qudt.org/vocab/quantitykind/PRODUCT-OF-INERTIA_X'>;
    "PRODUCT-OF-INERTIA_Y": NamedNode<'http://qudt.org/vocab/quantitykind/PRODUCT-OF-INERTIA_Y'>;
    "PRODUCT-OF-INERTIA_Z": NamedNode<'http://qudt.org/vocab/quantitykind/PRODUCT-OF-INERTIA_Z'>;
    "PRODUCT-OF-INERTIA": NamedNode<'http://qudt.org/vocab/quantitykind/PRODUCT-OF-INERTIA'>;
    "PropagationCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/PropagationCoefficient'>;
    "PropellantBurnRate": NamedNode<'http://qudt.org/vocab/quantitykind/PropellantBurnRate'>;
    "PropellantMass": NamedNode<'http://qudt.org/vocab/quantitykind/PropellantMass'>;
    "PropellantMeanBulkTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/PropellantMeanBulkTemperature'>;
    "PropellantTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/PropellantTemperature'>;
    "QualityFactor": NamedNode<'http://qudt.org/vocab/quantitykind/QualityFactor'>;
    "QuantumNumber": NamedNode<'http://qudt.org/vocab/quantitykind/QuantumNumber'>;
    "QuarticElectricDipoleMomentPerCubicEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/QuarticElectricDipoleMomentPerCubicEnergy'>;
    "RadialDistance": NamedNode<'http://qudt.org/vocab/quantitykind/RadialDistance'>;
    "Radiance": NamedNode<'http://qudt.org/vocab/quantitykind/Radiance'>;
    "RadianceFactor": NamedNode<'http://qudt.org/vocab/quantitykind/RadianceFactor'>;
    "RadiantEmmitance": NamedNode<'http://qudt.org/vocab/quantitykind/RadiantEmmitance'>;
    "RadiantEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/RadiantEnergy'>;
    "RadiantEnergyDensity": NamedNode<'http://qudt.org/vocab/quantitykind/RadiantEnergyDensity'>;
    "RadiantExposure": NamedNode<'http://qudt.org/vocab/quantitykind/RadiantExposure'>;
    "RadiantFluence": NamedNode<'http://qudt.org/vocab/quantitykind/RadiantFluence'>;
    "RadiantFluenceRate": NamedNode<'http://qudt.org/vocab/quantitykind/RadiantFluenceRate'>;
    "RadiantFlux": NamedNode<'http://qudt.org/vocab/quantitykind/RadiantFlux'>;
    "RadiantIntensity": NamedNode<'http://qudt.org/vocab/quantitykind/RadiantIntensity'>;
    "RadiativeHeatTransfer": NamedNode<'http://qudt.org/vocab/quantitykind/RadiativeHeatTransfer'>;
    "Radiosity": NamedNode<'http://qudt.org/vocab/quantitykind/Radiosity'>;
    "Radius": NamedNode<'http://qudt.org/vocab/quantitykind/Radius'>;
    "RadiusOfCurvature": NamedNode<'http://qudt.org/vocab/quantitykind/RadiusOfCurvature'>;
    "RatioOfSpecificHeatCapacities": NamedNode<'http://qudt.org/vocab/quantitykind/RatioOfSpecificHeatCapacities'>;
    "Reactance": NamedNode<'http://qudt.org/vocab/quantitykind/Reactance'>;
    "ReactionEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/ReactionEnergy'>;
    "ReactivePower": NamedNode<'http://qudt.org/vocab/quantitykind/ReactivePower'>;
    "Reactivity": NamedNode<'http://qudt.org/vocab/quantitykind/Reactivity'>;
    "ReactorTimeConstant": NamedNode<'http://qudt.org/vocab/quantitykind/ReactorTimeConstant'>;
    "RecombinationCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/RecombinationCoefficient'>;
    "Refectance": NamedNode<'http://qudt.org/vocab/quantitykind/Refectance'>;
    "Reflectance": NamedNode<'http://qudt.org/vocab/quantitykind/Reflectance'>;
    "ReflectanceFactor": NamedNode<'http://qudt.org/vocab/quantitykind/ReflectanceFactor'>;
    "RefractiveIndex": NamedNode<'http://qudt.org/vocab/quantitykind/RefractiveIndex'>;
    "RelativeAtomicMass": NamedNode<'http://qudt.org/vocab/quantitykind/RelativeAtomicMass'>;
    "RelativeHumidity": NamedNode<'http://qudt.org/vocab/quantitykind/RelativeHumidity'>;
    "RelativeLuminousFlux": NamedNode<'http://qudt.org/vocab/quantitykind/RelativeLuminousFlux'>;
    "RelativeMassConcentrationOfVapour": NamedNode<'http://qudt.org/vocab/quantitykind/RelativeMassConcentrationOfVapour'>;
    "RelativeMassDefect": NamedNode<'http://qudt.org/vocab/quantitykind/RelativeMassDefect'>;
    "RelativeMassDensity": NamedNode<'http://qudt.org/vocab/quantitykind/RelativeMassDensity'>;
    "RelativeMassExcess": NamedNode<'http://qudt.org/vocab/quantitykind/RelativeMassExcess'>;
    "RelativeMassRatioOfVapour": NamedNode<'http://qudt.org/vocab/quantitykind/RelativeMassRatioOfVapour'>;
    "RelativeMolecularMass": NamedNode<'http://qudt.org/vocab/quantitykind/RelativeMolecularMass'>;
    "RelativePartialPressure": NamedNode<'http://qudt.org/vocab/quantitykind/RelativePartialPressure'>;
    "RelativePressureCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/RelativePressureCoefficient'>;
    "RelaxationTIme": NamedNode<'http://qudt.org/vocab/quantitykind/RelaxationTIme'>;
    "Reluctance": NamedNode<'http://qudt.org/vocab/quantitykind/Reluctance'>;
    "RESERVE-MASS": NamedNode<'http://qudt.org/vocab/quantitykind/RESERVE-MASS'>;
    "ResidualResistivity": NamedNode<'http://qudt.org/vocab/quantitykind/ResidualResistivity'>;
    "Resistance": NamedNode<'http://qudt.org/vocab/quantitykind/Resistance'>;
    "ResistancePercentage": NamedNode<'http://qudt.org/vocab/quantitykind/ResistancePercentage'>;
    "ResistanceRatio": NamedNode<'http://qudt.org/vocab/quantitykind/ResistanceRatio'>;
    "Resistivity": NamedNode<'http://qudt.org/vocab/quantitykind/Resistivity'>;
    "ResonanceEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/ResonanceEnergy'>;
    "ResonanceEscapeProbability": NamedNode<'http://qudt.org/vocab/quantitykind/ResonanceEscapeProbability'>;
    "ResonanceEscapeProbabilityForFission": NamedNode<'http://qudt.org/vocab/quantitykind/ResonanceEscapeProbabilityForFission'>;
    "RespiratoryRate": NamedNode<'http://qudt.org/vocab/quantitykind/RespiratoryRate'>;
    "RestEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/RestEnergy'>;
    "RestMass": NamedNode<'http://qudt.org/vocab/quantitykind/RestMass'>;
    "ReverberationTime": NamedNode<'http://qudt.org/vocab/quantitykind/ReverberationTime'>;
    "ReynoldsNumber": NamedNode<'http://qudt.org/vocab/quantitykind/ReynoldsNumber'>;
    "RF-Power": NamedNode<'http://qudt.org/vocab/quantitykind/RF-Power'>;
    "RichardsonConstant": NamedNode<'http://qudt.org/vocab/quantitykind/RichardsonConstant'>;
    "RocketAtmosphericTransverseForce": NamedNode<'http://qudt.org/vocab/quantitykind/RocketAtmosphericTransverseForce'>;
    "RotationalMass": NamedNode<'http://qudt.org/vocab/quantitykind/RotationalMass'>;
    "RotationalStiffness": NamedNode<'http://qudt.org/vocab/quantitykind/RotationalStiffness'>;
    "ScalarMagneticPotential": NamedNode<'http://qudt.org/vocab/quantitykind/ScalarMagneticPotential'>;
    "SecondAxialMomentOfArea": NamedNode<'http://qudt.org/vocab/quantitykind/SecondAxialMomentOfArea'>;
    "SecondMomentOfArea": NamedNode<'http://qudt.org/vocab/quantitykind/SecondMomentOfArea'>;
    "SecondOrderReactionRateConstant": NamedNode<'http://qudt.org/vocab/quantitykind/SecondOrderReactionRateConstant'>;
    "SecondPolarMomentOfArea": NamedNode<'http://qudt.org/vocab/quantitykind/SecondPolarMomentOfArea'>;
    "SecondStageMassRatio": NamedNode<'http://qudt.org/vocab/quantitykind/SecondStageMassRatio'>;
    "SectionAreaIntegral": NamedNode<'http://qudt.org/vocab/quantitykind/SectionAreaIntegral'>;
    "SectionModulus": NamedNode<'http://qudt.org/vocab/quantitykind/SectionModulus'>;
    "SeebeckCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/SeebeckCoefficient'>;
    "SerumOrPlasmaLevel": NamedNode<'http://qudt.org/vocab/quantitykind/SerumOrPlasmaLevel'>;
    "ShannonDiversityIndex": NamedNode<'http://qudt.org/vocab/quantitykind/ShannonDiversityIndex'>;
    "ShearModulus": NamedNode<'http://qudt.org/vocab/quantitykind/ShearModulus'>;
    "ShearStrain": NamedNode<'http://qudt.org/vocab/quantitykind/ShearStrain'>;
    "ShearStress": NamedNode<'http://qudt.org/vocab/quantitykind/ShearStress'>;
    "Short-RangeOrderParameter": NamedNode<'http://qudt.org/vocab/quantitykind/Short-RangeOrderParameter'>;
    "SignalDetectionThreshold": NamedNode<'http://qudt.org/vocab/quantitykind/SignalDetectionThreshold'>;
    "SignalStrength": NamedNode<'http://qudt.org/vocab/quantitykind/SignalStrength'>;
    "SingleStageLauncherMassRatio": NamedNode<'http://qudt.org/vocab/quantitykind/SingleStageLauncherMassRatio'>;
    "Slowing-DownArea": NamedNode<'http://qudt.org/vocab/quantitykind/Slowing-DownArea'>;
    "Slowing-DownDensity": NamedNode<'http://qudt.org/vocab/quantitykind/Slowing-DownDensity'>;
    "Slowing-DownLength": NamedNode<'http://qudt.org/vocab/quantitykind/Slowing-DownLength'>;
    "SoilAdsorptionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/SoilAdsorptionCoefficient'>;
    "SolidAngle": NamedNode<'http://qudt.org/vocab/quantitykind/SolidAngle'>;
    "SolidStateDiffusionLength": NamedNode<'http://qudt.org/vocab/quantitykind/SolidStateDiffusionLength'>;
    "Solubility_Water": NamedNode<'http://qudt.org/vocab/quantitykind/Solubility_Water'>;
    "SoundEnergyDensity": NamedNode<'http://qudt.org/vocab/quantitykind/SoundEnergyDensity'>;
    "SoundExposure": NamedNode<'http://qudt.org/vocab/quantitykind/SoundExposure'>;
    "SoundExposureLevel": NamedNode<'http://qudt.org/vocab/quantitykind/SoundExposureLevel'>;
    "SoundIntensity": NamedNode<'http://qudt.org/vocab/quantitykind/SoundIntensity'>;
    "SoundParticleAcceleration": NamedNode<'http://qudt.org/vocab/quantitykind/SoundParticleAcceleration'>;
    "SoundParticleDisplacement": NamedNode<'http://qudt.org/vocab/quantitykind/SoundParticleDisplacement'>;
    "SoundParticleVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/SoundParticleVelocity'>;
    "SoundPower": NamedNode<'http://qudt.org/vocab/quantitykind/SoundPower'>;
    "SoundPowerLevel": NamedNode<'http://qudt.org/vocab/quantitykind/SoundPowerLevel'>;
    "SoundPressure": NamedNode<'http://qudt.org/vocab/quantitykind/SoundPressure'>;
    "SoundPressureLevel": NamedNode<'http://qudt.org/vocab/quantitykind/SoundPressureLevel'>;
    "SoundReductionIndex": NamedNode<'http://qudt.org/vocab/quantitykind/SoundReductionIndex'>;
    "SoundVolumeVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/SoundVolumeVelocity'>;
    "SourceVoltage": NamedNode<'http://qudt.org/vocab/quantitykind/SourceVoltage'>;
    "SourceVoltageBetweenSubstances": NamedNode<'http://qudt.org/vocab/quantitykind/SourceVoltageBetweenSubstances'>;
    "SpatialSummationFunction": NamedNode<'http://qudt.org/vocab/quantitykind/SpatialSummationFunction'>;
    "SpecificAcousticImpedance": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificAcousticImpedance'>;
    "SpecificActivity": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificActivity'>;
    "SpecificEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificEnergy'>;
    "SpecificEnergyImparted": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificEnergyImparted'>;
    "SpecificEnthalpy": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificEnthalpy'>;
    "SpecificEntropy": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificEntropy'>;
    "SpecificGibbsEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificGibbsEnergy'>;
    "SpecificHeatCapacity": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificHeatCapacity'>;
    "SpecificHeatCapacityAtConstantPressure": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificHeatCapacityAtConstantPressure'>;
    "SpecificHeatCapacityAtConstantVolume": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificHeatCapacityAtConstantVolume'>;
    "SpecificHeatCapacityAtSaturation": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificHeatCapacityAtSaturation'>;
    "SpecificHeatPressure": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificHeatPressure'>;
    "SpecificHeatsRatio": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificHeatsRatio'>;
    "SpecificHeatVolume": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificHeatVolume'>;
    "SpecificHelmholtzEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificHelmholtzEnergy'>;
    "SpecificImpulse": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificImpulse'>;
    "SpecificImpulseByMass": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificImpulseByMass'>;
    "SpecificImpulseByWeight": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificImpulseByWeight'>;
    "SpecificInternalEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificInternalEnergy'>;
    "SpecificOpticalRotatoryPower": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificOpticalRotatoryPower'>;
    "SpecificThrust": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificThrust'>;
    "SpecificVolume": NamedNode<'http://qudt.org/vocab/quantitykind/SpecificVolume'>;
    "SpectralAngularCrossSection": NamedNode<'http://qudt.org/vocab/quantitykind/SpectralAngularCrossSection'>;
    "SpectralCrossSection": NamedNode<'http://qudt.org/vocab/quantitykind/SpectralCrossSection'>;
    "SpectralLuminousEfficiency": NamedNode<'http://qudt.org/vocab/quantitykind/SpectralLuminousEfficiency'>;
    "SpectralRadiantEnergyDensity": NamedNode<'http://qudt.org/vocab/quantitykind/SpectralRadiantEnergyDensity'>;
    "Speed": NamedNode<'http://qudt.org/vocab/quantitykind/Speed'>;
    "SpeedOfLight": NamedNode<'http://qudt.org/vocab/quantitykind/SpeedOfLight'>;
    "SpeedOfSound": NamedNode<'http://qudt.org/vocab/quantitykind/SpeedOfSound'>;
    "SphericalIlluminance": NamedNode<'http://qudt.org/vocab/quantitykind/SphericalIlluminance'>;
    "Spin": NamedNode<'http://qudt.org/vocab/quantitykind/Spin'>;
    "SpinQuantumNumber": NamedNode<'http://qudt.org/vocab/quantitykind/SpinQuantumNumber'>;
    "SquareEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/SquareEnergy'>;
    "StagePropellantMass": NamedNode<'http://qudt.org/vocab/quantitykind/StagePropellantMass'>;
    "StageStructuralMass": NamedNode<'http://qudt.org/vocab/quantitykind/StageStructuralMass'>;
    "StandardAbsoluteActivity": NamedNode<'http://qudt.org/vocab/quantitykind/StandardAbsoluteActivity'>;
    "StandardChemicalPotential": NamedNode<'http://qudt.org/vocab/quantitykind/StandardChemicalPotential'>;
    "StandardGravitationalParameter": NamedNode<'http://qudt.org/vocab/quantitykind/StandardGravitationalParameter'>;
    "StaticFriction": NamedNode<'http://qudt.org/vocab/quantitykind/StaticFriction'>;
    "StaticFrictionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/StaticFrictionCoefficient'>;
    "StaticPressure": NamedNode<'http://qudt.org/vocab/quantitykind/StaticPressure'>;
    "StatisticalWeight": NamedNode<'http://qudt.org/vocab/quantitykind/StatisticalWeight'>;
    "StochasticProcess": NamedNode<'http://qudt.org/vocab/quantitykind/StochasticProcess'>;
    "StoichiometricNumber": NamedNode<'http://qudt.org/vocab/quantitykind/StoichiometricNumber'>;
    "Strain": NamedNode<'http://qudt.org/vocab/quantitykind/Strain'>;
    "StrainEnergyDensity": NamedNode<'http://qudt.org/vocab/quantitykind/StrainEnergyDensity'>;
    "Stress": NamedNode<'http://qudt.org/vocab/quantitykind/Stress'>;
    "StressOpticCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/StressOpticCoefficient'>;
    "StructuralEfficiency": NamedNode<'http://qudt.org/vocab/quantitykind/StructuralEfficiency'>;
    "StructureFactor": NamedNode<'http://qudt.org/vocab/quantitykind/StructureFactor'>;
    "SuperconductionTransitionTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/SuperconductionTransitionTemperature'>;
    "SuperconductorEnergyGap": NamedNode<'http://qudt.org/vocab/quantitykind/SuperconductorEnergyGap'>;
    "SurfaceActivityDensity": NamedNode<'http://qudt.org/vocab/quantitykind/SurfaceActivityDensity'>;
    "SurfaceCoefficientOfHeatTransfer": NamedNode<'http://qudt.org/vocab/quantitykind/SurfaceCoefficientOfHeatTransfer'>;
    "SurfaceDensity": NamedNode<'http://qudt.org/vocab/quantitykind/SurfaceDensity'>;
    "SurfaceTension": NamedNode<'http://qudt.org/vocab/quantitykind/SurfaceTension'>;
    "Susceptance": NamedNode<'http://qudt.org/vocab/quantitykind/Susceptance'>;
    "SystolicBloodPressure": NamedNode<'http://qudt.org/vocab/quantitykind/SystolicBloodPressure'>;
    "TARGET-BOGIE-MASS": NamedNode<'http://qudt.org/vocab/quantitykind/TARGET-BOGIE-MASS'>;
    "Temperature": NamedNode<'http://qudt.org/vocab/quantitykind/Temperature'>;
    "TemperatureAmountOfSubstance": NamedNode<'http://qudt.org/vocab/quantitykind/TemperatureAmountOfSubstance'>;
    "TemperatureGradient": NamedNode<'http://qudt.org/vocab/quantitykind/TemperatureGradient'>;
    "TemperaturePerMagneticFluxDensity": NamedNode<'http://qudt.org/vocab/quantitykind/TemperaturePerMagneticFluxDensity'>;
    "TemperaturePerTime_Squared": NamedNode<'http://qudt.org/vocab/quantitykind/TemperaturePerTime_Squared'>;
    "TemperaturePerTime": NamedNode<'http://qudt.org/vocab/quantitykind/TemperaturePerTime'>;
    "TemperatureRateOfChange": NamedNode<'http://qudt.org/vocab/quantitykind/TemperatureRateOfChange'>;
    "TemperatureRatio": NamedNode<'http://qudt.org/vocab/quantitykind/TemperatureRatio'>;
    "TemporalSummationFunction": NamedNode<'http://qudt.org/vocab/quantitykind/TemporalSummationFunction'>;
    "Tension": NamedNode<'http://qudt.org/vocab/quantitykind/Tension'>;
    "ThermalAdmittance": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalAdmittance'>;
    "ThermalConductance": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalConductance'>;
    "ThermalConductivity": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalConductivity'>;
    "ThermalDiffusionFactor": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalDiffusionFactor'>;
    "ThermalDiffusionRatio": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalDiffusionRatio'>;
    "ThermalDiffusionRatioCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalDiffusionRatioCoefficient'>;
    "ThermalDiffusivity": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalDiffusivity'>;
    "ThermalEfficiency": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalEfficiency'>;
    "ThermalEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalEnergy'>;
    "ThermalEnergyLength": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalEnergyLength'>;
    "ThermalExpansionCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalExpansionCoefficient'>;
    "ThermalInsulance": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalInsulance'>;
    "ThermalResistance": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalResistance'>;
    "ThermalResistivity": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalResistivity'>;
    "ThermalTransmittance": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalTransmittance'>;
    "ThermalUtilizationFactor": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalUtilizationFactor'>;
    "ThermalUtilizationFactorForFission": NamedNode<'http://qudt.org/vocab/quantitykind/ThermalUtilizationFactorForFission'>;
    "ThermodynamicCriticalMagneticFluxDensity": NamedNode<'http://qudt.org/vocab/quantitykind/ThermodynamicCriticalMagneticFluxDensity'>;
    "ThermodynamicEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/ThermodynamicEnergy'>;
    "ThermodynamicEntropy": NamedNode<'http://qudt.org/vocab/quantitykind/ThermodynamicEntropy'>;
    "ThermodynamicTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/ThermodynamicTemperature'>;
    "Thickness": NamedNode<'http://qudt.org/vocab/quantitykind/Thickness'>;
    "ThomsonCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/ThomsonCoefficient'>;
    "Thrust": NamedNode<'http://qudt.org/vocab/quantitykind/Thrust'>;
    "ThrustCoefficient": NamedNode<'http://qudt.org/vocab/quantitykind/ThrustCoefficient'>;
    "ThrusterPowerToThrustEfficiency": NamedNode<'http://qudt.org/vocab/quantitykind/ThrusterPowerToThrustEfficiency'>;
    "ThrustToMassRatio": NamedNode<'http://qudt.org/vocab/quantitykind/ThrustToMassRatio'>;
    "ThrustToWeightRatio": NamedNode<'http://qudt.org/vocab/quantitykind/ThrustToWeightRatio'>;
    "Time_Squared": NamedNode<'http://qudt.org/vocab/quantitykind/Time_Squared'>;
    "Time": NamedNode<'http://qudt.org/vocab/quantitykind/Time'>;
    "TimeAveragedSoundIntensity": NamedNode<'http://qudt.org/vocab/quantitykind/TimeAveragedSoundIntensity'>;
    "TimePercentage": NamedNode<'http://qudt.org/vocab/quantitykind/TimePercentage'>;
    "TimeRatio": NamedNode<'http://qudt.org/vocab/quantitykind/TimeRatio'>;
    "TimeSquared": NamedNode<'http://qudt.org/vocab/quantitykind/TimeSquared'>;
    "TimeTemperature": NamedNode<'http://qudt.org/vocab/quantitykind/TimeTemperature'>;
    "Torque": NamedNode<'http://qudt.org/vocab/quantitykind/Torque'>;
    "TorquePerAngle": NamedNode<'http://qudt.org/vocab/quantitykind/TorquePerAngle'>;
    "TorquePerLength": NamedNode<'http://qudt.org/vocab/quantitykind/TorquePerLength'>;
    "TotalAngularMomentum": NamedNode<'http://qudt.org/vocab/quantitykind/TotalAngularMomentum'>;
    "TotalAngularMomentumQuantumNumber": NamedNode<'http://qudt.org/vocab/quantitykind/TotalAngularMomentumQuantumNumber'>;
    "TotalAtomicStoppingPower": NamedNode<'http://qudt.org/vocab/quantitykind/TotalAtomicStoppingPower'>;
    "TotalCrossSection": NamedNode<'http://qudt.org/vocab/quantitykind/TotalCrossSection'>;
    "TotalCurrent": NamedNode<'http://qudt.org/vocab/quantitykind/TotalCurrent'>;
    "TotalCurrentDensity": NamedNode<'http://qudt.org/vocab/quantitykind/TotalCurrentDensity'>;
    "TotalIonization": NamedNode<'http://qudt.org/vocab/quantitykind/TotalIonization'>;
    "TotalLinearStoppingPower": NamedNode<'http://qudt.org/vocab/quantitykind/TotalLinearStoppingPower'>;
    "TotalMassStoppingPower": NamedNode<'http://qudt.org/vocab/quantitykind/TotalMassStoppingPower'>;
    "TotalPressure": NamedNode<'http://qudt.org/vocab/quantitykind/TotalPressure'>;
    "TouchThresholds": NamedNode<'http://qudt.org/vocab/quantitykind/TouchThresholds'>;
    "Transmittance": NamedNode<'http://qudt.org/vocab/quantitykind/Transmittance'>;
    "TransmittanceDensity": NamedNode<'http://qudt.org/vocab/quantitykind/TransmittanceDensity'>;
    "TrueExhaustVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/TrueExhaustVelocity'>;
    "Turbidity": NamedNode<'http://qudt.org/vocab/quantitykind/Turbidity'>;
    "Turns": NamedNode<'http://qudt.org/vocab/quantitykind/Turns'>;
    "UpperCriticalMagneticFluxDensity": NamedNode<'http://qudt.org/vocab/quantitykind/UpperCriticalMagneticFluxDensity'>;
    "VacuumThrust": NamedNode<'http://qudt.org/vocab/quantitykind/VacuumThrust'>;
    "VaporPermeability": NamedNode<'http://qudt.org/vocab/quantitykind/VaporPermeability'>;
    "VaporPressure": NamedNode<'http://qudt.org/vocab/quantitykind/VaporPressure'>;
    "VehicleVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/VehicleVelocity'>;
    "Velocity": NamedNode<'http://qudt.org/vocab/quantitykind/Velocity'>;
    "VentilationRatePerFloorArea": NamedNode<'http://qudt.org/vocab/quantitykind/VentilationRatePerFloorArea'>;
    "VerticalVelocity": NamedNode<'http://qudt.org/vocab/quantitykind/VerticalVelocity'>;
    "VideoFrameRate": NamedNode<'http://qudt.org/vocab/quantitykind/VideoFrameRate'>;
    "Viscosity": NamedNode<'http://qudt.org/vocab/quantitykind/Viscosity'>;
    "VisibleRadiantEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/VisibleRadiantEnergy'>;
    "VisionThresholds": NamedNode<'http://qudt.org/vocab/quantitykind/VisionThresholds'>;
    "Voltage": NamedNode<'http://qudt.org/vocab/quantitykind/Voltage'>;
    "VoltagePercentage": NamedNode<'http://qudt.org/vocab/quantitykind/VoltagePercentage'>;
    "VoltagePhasor": NamedNode<'http://qudt.org/vocab/quantitykind/VoltagePhasor'>;
    "VoltageRatio": NamedNode<'http://qudt.org/vocab/quantitykind/VoltageRatio'>;
    "Volume": NamedNode<'http://qudt.org/vocab/quantitykind/Volume'>;
    "VolumeFlowRate": NamedNode<'http://qudt.org/vocab/quantitykind/VolumeFlowRate'>;
    "VolumeFraction": NamedNode<'http://qudt.org/vocab/quantitykind/VolumeFraction'>;
    "VolumePerArea": NamedNode<'http://qudt.org/vocab/quantitykind/VolumePerArea'>;
    "VolumePerUnitTime": NamedNode<'http://qudt.org/vocab/quantitykind/VolumePerUnitTime'>;
    "VolumeStrain": NamedNode<'http://qudt.org/vocab/quantitykind/VolumeStrain'>;
    "VolumeThermalExpansion": NamedNode<'http://qudt.org/vocab/quantitykind/VolumeThermalExpansion'>;
    "VolumetricFlux": NamedNode<'http://qudt.org/vocab/quantitykind/VolumetricFlux'>;
    "VolumetricHeatCapacity": NamedNode<'http://qudt.org/vocab/quantitykind/VolumetricHeatCapacity'>;
    "VolumicElectromagneticEnergy": NamedNode<'http://qudt.org/vocab/quantitykind/VolumicElectromagneticEnergy'>;
    "Vorticity": NamedNode<'http://qudt.org/vocab/quantitykind/Vorticity'>;
    "WarmReceptorThreshold": NamedNode<'http://qudt.org/vocab/quantitykind/WarmReceptorThreshold'>;
    "WarpingConstant": NamedNode<'http://qudt.org/vocab/quantitykind/WarpingConstant'>;
    "WarpingMoment": NamedNode<'http://qudt.org/vocab/quantitykind/WarpingMoment'>;
    "WaterHorsepower": NamedNode<'http://qudt.org/vocab/quantitykind/WaterHorsepower'>;
    "Wavelength": NamedNode<'http://qudt.org/vocab/quantitykind/Wavelength'>;
    "Wavenumber": NamedNode<'http://qudt.org/vocab/quantitykind/Wavenumber'>;
    /** Web Time */
    "WebTime": NamedNode<'http://qudt.org/vocab/quantitykind/WebTime'>;
    "WebTimeAveragePressure": NamedNode<'http://qudt.org/vocab/quantitykind/WebTimeAveragePressure'>;
    /** Web Time Avg Thrust (Mlbf) */
    "WebTimeAverageThrust": NamedNode<'http://qudt.org/vocab/quantitykind/WebTimeAverageThrust'>;
    "Weight": NamedNode<'http://qudt.org/vocab/quantitykind/Weight'>;
    "Width": NamedNode<'http://qudt.org/vocab/quantitykind/Width'>;
    "Work": NamedNode<'http://qudt.org/vocab/quantitykind/Work'>;
    "WorkFunction": NamedNode<'http://qudt.org/vocab/quantitykind/WorkFunction'>;
}
export declare const strict: Record<keyof Quantitykind, NamedNode<string>> & ((property?: TemplateStringsArray | keyof Quantitykind | undefined) => NamedNode<string>) & Quantitykind;
export declare const loose: Record<any, NamedNode<string>> & ((property?: any) => NamedNode<string>) & Quantitykind;
//# sourceMappingURL=quantitykind.d.ts.map