(function(global) {
  'use strict';
  if (global.$traceurRuntime) {
    return;
  }
  function setupGlobals(global) {
    global.Reflect = global.Reflect || {};
    global.Reflect.global = global.Reflect.global || global;
  }
  setupGlobals(global);
  var typeOf = function(x) {
    return typeof x;
  };
  global.$traceurRuntime = {
    options: {},
    setupGlobals: setupGlobals,
    typeof: typeOf
  };
})(typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : this);
(function() {
  function buildFromEncodedParts(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_queryData, opt_fragment) {
    var out = [];
    if (opt_scheme) {
      out.push(opt_scheme, ':');
    }
    if (opt_domain) {
      out.push('//');
      if (opt_userInfo) {
        out.push(opt_userInfo, '@');
      }
      out.push(opt_domain);
      if (opt_port) {
        out.push(':', opt_port);
      }
    }
    if (opt_path) {
      out.push(opt_path);
    }
    if (opt_queryData) {
      out.push('?', opt_queryData);
    }
    if (opt_fragment) {
      out.push('#', opt_fragment);
    }
    return out.join('');
  }
  var splitRe = new RegExp('^' + '(?:' + '([^:/?#.]+)' + ':)?' + '(?://' + '(?:([^/?#]*)@)?' + '([\\w\\d\\-\\u0100-\\uffff.%]*)' + '(?::([0-9]+))?' + ')?' + '([^?#]+)?' + '(?:\\?([^#]*))?' + '(?:#(.*))?' + '$');
  var ComponentIndex = {
    SCHEME: 1,
    USER_INFO: 2,
    DOMAIN: 3,
    PORT: 4,
    PATH: 5,
    QUERY_DATA: 6,
    FRAGMENT: 7
  };
  function split(uri) {
    return (uri.match(splitRe));
  }
  function removeDotSegments(path) {
    if (path === '/')
      return '/';
    var leadingSlash = path[0] === '/' ? '/' : '';
    var trailingSlash = path.slice(-1) === '/' ? '/' : '';
    var segments = path.split('/');
    var out = [];
    var up = 0;
    for (var pos = 0; pos < segments.length; pos++) {
      var segment = segments[pos];
      switch (segment) {
        case '':
        case '.':
          break;
        case '..':
          if (out.length)
            out.pop();
          else
            up++;
          break;
        default:
          out.push(segment);
      }
    }
    if (!leadingSlash) {
      while (up-- > 0) {
        out.unshift('..');
      }
      if (out.length === 0)
        out.push('.');
    }
    return leadingSlash + out.join('/') + trailingSlash;
  }
  function joinAndCanonicalizePath(parts) {
    var path = parts[ComponentIndex.PATH] || '';
    path = removeDotSegments(path);
    parts[ComponentIndex.PATH] = path;
    return buildFromEncodedParts(parts[ComponentIndex.SCHEME], parts[ComponentIndex.USER_INFO], parts[ComponentIndex.DOMAIN], parts[ComponentIndex.PORT], parts[ComponentIndex.PATH], parts[ComponentIndex.QUERY_DATA], parts[ComponentIndex.FRAGMENT]);
  }
  function canonicalizeUrl(url) {
    var parts = split(url);
    return joinAndCanonicalizePath(parts);
  }
  function resolveUrl(base, url) {
    var parts = split(url);
    var baseParts = split(base);
    if (parts[ComponentIndex.SCHEME]) {
      return joinAndCanonicalizePath(parts);
    } else {
      parts[ComponentIndex.SCHEME] = baseParts[ComponentIndex.SCHEME];
    }
    for (var i = ComponentIndex.SCHEME; i <= ComponentIndex.PORT; i++) {
      if (!parts[i]) {
        parts[i] = baseParts[i];
      }
    }
    if (parts[ComponentIndex.PATH][0] == '/') {
      return joinAndCanonicalizePath(parts);
    }
    var path = baseParts[ComponentIndex.PATH];
    var index = path.lastIndexOf('/');
    path = path.slice(0, index + 1) + parts[ComponentIndex.PATH];
    parts[ComponentIndex.PATH] = path;
    return joinAndCanonicalizePath(parts);
  }
  function isAbsolute(name) {
    if (!name)
      return false;
    if (name[0] === '/')
      return true;
    var parts = split(name);
    if (parts[ComponentIndex.SCHEME])
      return true;
    return false;
  }
  $traceurRuntime.canonicalizeUrl = canonicalizeUrl;
  $traceurRuntime.isAbsolute = isAbsolute;
  $traceurRuntime.removeDotSegments = removeDotSegments;
  $traceurRuntime.resolveUrl = resolveUrl;
})();
(function(global) {
  'use strict';
  var $__3 = $traceurRuntime,
      canonicalizeUrl = $__3.canonicalizeUrl,
      resolveUrl = $__3.resolveUrl,
      isAbsolute = $__3.isAbsolute;
  var moduleInstantiators = Object.create(null);
  var baseURL;
  if (global.location && global.location.href)
    baseURL = resolveUrl(global.location.href, './');
  else
    baseURL = '';
  function UncoatedModuleEntry(url, uncoatedModule) {
    this.url = url;
    this.value_ = uncoatedModule;
  }
  function ModuleEvaluationError(erroneousModuleName, cause) {
    this.message = this.constructor.name + ': ' + this.stripCause(cause) + ' in ' + erroneousModuleName;
    if (!(cause instanceof ModuleEvaluationError) && cause.stack)
      this.stack = this.stripStack(cause.stack);
    else
      this.stack = '';
  }
  ModuleEvaluationError.prototype = Object.create(Error.prototype);
  ModuleEvaluationError.prototype.constructor = ModuleEvaluationError;
  ModuleEvaluationError.prototype.stripError = function(message) {
    return message.replace(/.*Error:/, this.constructor.name + ':');
  };
  ModuleEvaluationError.prototype.stripCause = function(cause) {
    if (!cause)
      return '';
    if (!cause.message)
      return cause + '';
    return this.stripError(cause.message);
  };
  ModuleEvaluationError.prototype.loadedBy = function(moduleName) {
    this.stack += '\n loaded by ' + moduleName;
  };
  ModuleEvaluationError.prototype.stripStack = function(causeStack) {
    var stack = [];
    causeStack.split('\n').some(function(frame) {
      if (/UncoatedModuleInstantiator/.test(frame))
        return true;
      stack.push(frame);
    });
    stack[0] = this.stripError(stack[0]);
    return stack.join('\n');
  };
  function beforeLines(lines, number) {
    var result = [];
    var first = number - 3;
    if (first < 0)
      first = 0;
    for (var i = first; i < number; i++) {
      result.push(lines[i]);
    }
    return result;
  }
  function afterLines(lines, number) {
    var last = number + 1;
    if (last > lines.length - 1)
      last = lines.length - 1;
    var result = [];
    for (var i = number; i <= last; i++) {
      result.push(lines[i]);
    }
    return result;
  }
  function columnSpacing(columns) {
    var result = '';
    for (var i = 0; i < columns - 1; i++) {
      result += '-';
    }
    return result;
  }
  function UncoatedModuleInstantiator(url, func) {
    UncoatedModuleEntry.call(this, url, null);
    this.func = func;
  }
  UncoatedModuleInstantiator.prototype = Object.create(UncoatedModuleEntry.prototype);
  UncoatedModuleInstantiator.prototype.getUncoatedModule = function() {
    var $__2 = this;
    if (this.value_)
      return this.value_;
    try {
      var relativeRequire;
      if (typeof $traceurRuntime !== undefined && $traceurRuntime.require) {
        relativeRequire = $traceurRuntime.require.bind(null, this.url);
      }
      return this.value_ = this.func.call(global, relativeRequire);
    } catch (ex) {
      if (ex instanceof ModuleEvaluationError) {
        ex.loadedBy(this.url);
        throw ex;
      }
      if (ex.stack) {
        var lines = this.func.toString().split('\n');
        var evaled = [];
        ex.stack.split('\n').some(function(frame, index) {
          if (frame.indexOf('UncoatedModuleInstantiator.getUncoatedModule') > 0)
            return true;
          var m = /(at\s[^\s]*\s).*>:(\d*):(\d*)\)/.exec(frame);
          if (m) {
            var line = parseInt(m[2], 10);
            evaled = evaled.concat(beforeLines(lines, line));
            if (index === 1) {
              evaled.push(columnSpacing(m[3]) + '^ ' + $__2.url);
            } else {
              evaled.push(columnSpacing(m[3]) + '^');
            }
            evaled = evaled.concat(afterLines(lines, line));
            evaled.push('= = = = = = = = =');
          } else {
            evaled.push(frame);
          }
        });
        ex.stack = evaled.join('\n');
      }
      throw new ModuleEvaluationError(this.url, ex);
    }
  };
  function getUncoatedModuleInstantiator(name) {
    if (!name)
      return;
    var url = ModuleStore.normalize(name);
    return moduleInstantiators[url];
  }
  ;
  var moduleInstances = Object.create(null);
  var liveModuleSentinel = {};
  function Module(uncoatedModule) {
    var isLive = arguments[1];
    var coatedModule = Object.create(null);
    Object.getOwnPropertyNames(uncoatedModule).forEach(function(name) {
      var getter,
          value;
      if (isLive === liveModuleSentinel) {
        var descr = Object.getOwnPropertyDescriptor(uncoatedModule, name);
        if (descr.get)
          getter = descr.get;
      }
      if (!getter) {
        value = uncoatedModule[name];
        getter = function() {
          return value;
        };
      }
      Object.defineProperty(coatedModule, name, {
        get: getter,
        enumerable: true
      });
    });
    Object.preventExtensions(coatedModule);
    return coatedModule;
  }
  var ModuleStore = {
    normalize: function(name, refererName, refererAddress) {
      if (typeof name !== 'string')
        throw new TypeError('module name must be a string, not ' + typeof name);
      if (isAbsolute(name))
        return canonicalizeUrl(name);
      if (/[^\.]\/\.\.\//.test(name)) {
        throw new Error('module name embeds /../: ' + name);
      }
      if (name[0] === '.' && refererName)
        return resolveUrl(refererName, name);
      return canonicalizeUrl(name);
    },
    get: function(normalizedName) {
      var m = getUncoatedModuleInstantiator(normalizedName);
      if (!m)
        return undefined;
      var moduleInstance = moduleInstances[m.url];
      if (moduleInstance)
        return moduleInstance;
      moduleInstance = Module(m.getUncoatedModule(), liveModuleSentinel);
      return moduleInstances[m.url] = moduleInstance;
    },
    set: function(normalizedName, module) {
      normalizedName = String(normalizedName);
      moduleInstantiators[normalizedName] = new UncoatedModuleInstantiator(normalizedName, function() {
        return module;
      });
      moduleInstances[normalizedName] = module;
    },
    get baseURL() {
      return baseURL;
    },
    set baseURL(v) {
      baseURL = String(v);
    },
    registerModule: function(name, deps, func) {
      var normalizedName = ModuleStore.normalize(name);
      if (moduleInstantiators[normalizedName])
        throw new Error('duplicate module named ' + normalizedName);
      moduleInstantiators[normalizedName] = new UncoatedModuleInstantiator(normalizedName, func);
    },
    bundleStore: Object.create(null),
    register: function(name, deps, func) {
      if (!deps || !deps.length && !func.length) {
        this.registerModule(name, deps, func);
      } else {
        this.bundleStore[name] = {
          deps: deps,
          execute: function() {
            var $__2 = arguments;
            var depMap = {};
            deps.forEach(function(dep, index) {
              return depMap[dep] = $__2[index];
            });
            var registryEntry = func.call(this, depMap);
            registryEntry.execute.call(this);
            return registryEntry.exports;
          }
        };
      }
    },
    getAnonymousModule: function(func) {
      return new Module(func.call(global), liveModuleSentinel);
    }
  };
  var moduleStoreModule = new Module({ModuleStore: ModuleStore});
  ModuleStore.set('@traceur/src/runtime/ModuleStore.js', moduleStoreModule);
  var setupGlobals = $traceurRuntime.setupGlobals;
  $traceurRuntime.setupGlobals = function(global) {
    setupGlobals(global);
  };
  $traceurRuntime.ModuleStore = ModuleStore;
  $traceurRuntime.registerModule = ModuleStore.registerModule.bind(ModuleStore);
  $traceurRuntime.getModule = ModuleStore.get;
  $traceurRuntime.setModule = ModuleStore.set;
  $traceurRuntime.normalizeModuleName = ModuleStore.normalize;
})(typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : this);
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/new-unique-string.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/new-unique-string.js";
  var random = Math.random;
  var counter = Date.now() % 1e9;
  function newUniqueString() {
    return '__$' + (random() * 1e9 >>> 1) + '$' + ++counter + '$__';
  }
  var $__default = newUniqueString;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/has-native-symbols.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/has-native-symbols.js";
  var v = !!Object.getOwnPropertySymbols && typeof Symbol === 'function';
  function hasNativeSymbol() {
    return v;
  }
  var $__default = hasNativeSymbol;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/symbols.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/symbols.js";
  var newUniqueString = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../new-unique-string.js", "traceur@0.0.108/src/runtime/modules/symbols.js")).default;
  var hasNativeSymbol = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../has-native-symbols.js", "traceur@0.0.108/src/runtime/modules/symbols.js")).default;
  var $create = Object.create;
  var $defineProperty = Object.defineProperty;
  var $freeze = Object.freeze;
  var $getOwnPropertyNames = Object.getOwnPropertyNames;
  var $keys = Object.keys;
  var $TypeError = TypeError;
  function nonEnum(value) {
    return {
      configurable: true,
      enumerable: false,
      value: value,
      writable: true
    };
  }
  var symbolInternalProperty = newUniqueString();
  var symbolDescriptionProperty = newUniqueString();
  var symbolDataProperty = newUniqueString();
  var symbolValues = $create(null);
  var SymbolImpl = function Symbol(description) {
    var value = new SymbolValue(description);
    if (!(this instanceof SymbolImpl))
      return value;
    throw new $TypeError('Symbol cannot be new\'ed');
  };
  $defineProperty(SymbolImpl.prototype, 'constructor', nonEnum(SymbolImpl));
  $defineProperty(SymbolImpl.prototype, 'toString', nonEnum(function() {
    var symbolValue = this[symbolDataProperty];
    return symbolValue[symbolInternalProperty];
  }));
  $defineProperty(SymbolImpl.prototype, 'valueOf', nonEnum(function() {
    var symbolValue = this[symbolDataProperty];
    if (!symbolValue)
      throw $TypeError('Conversion from symbol to string');
    return symbolValue[symbolInternalProperty];
  }));
  function SymbolValue(description) {
    var key = newUniqueString();
    $defineProperty(this, symbolDataProperty, {value: this});
    $defineProperty(this, symbolInternalProperty, {value: key});
    $defineProperty(this, symbolDescriptionProperty, {value: description});
    $freeze(this);
    symbolValues[key] = this;
  }
  $defineProperty(SymbolValue.prototype, 'constructor', nonEnum(SymbolImpl));
  $defineProperty(SymbolValue.prototype, 'toString', {
    value: SymbolImpl.prototype.toString,
    enumerable: false
  });
  $defineProperty(SymbolValue.prototype, 'valueOf', {
    value: SymbolImpl.prototype.valueOf,
    enumerable: false
  });
  $freeze(SymbolValue.prototype);
  function isSymbolString(s) {
    return symbolValues[s];
  }
  function removeSymbolKeys(array) {
    var rv = [];
    for (var i = 0; i < array.length; i++) {
      if (!isSymbolString(array[i])) {
        rv.push(array[i]);
      }
    }
    return rv;
  }
  function getOwnPropertyNames(object) {
    return removeSymbolKeys($getOwnPropertyNames(object));
  }
  function keys(object) {
    return removeSymbolKeys($keys(object));
  }
  function getOwnPropertySymbols(object) {
    var rv = [];
    var names = $getOwnPropertyNames(object);
    for (var i = 0; i < names.length; i++) {
      var symbol = symbolValues[names[i]];
      if (symbol) {
        rv.push(symbol);
      }
    }
    return rv;
  }
  function polyfillSymbol(global) {
    var Object = global.Object;
    if (!hasNativeSymbol()) {
      global.Symbol = SymbolImpl;
      Object.getOwnPropertyNames = getOwnPropertyNames;
      Object.keys = keys;
      $defineProperty(Object, 'getOwnPropertySymbols', nonEnum(getOwnPropertySymbols));
    }
    if (!global.Symbol.iterator) {
      global.Symbol.iterator = global.Symbol('Symbol.iterator');
    }
    if (!global.Symbol.observer) {
      global.Symbol.observer = global.Symbol('Symbol.observer');
    }
  }
  var g = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : this;
  polyfillSymbol(g);
  var typeOf = hasNativeSymbol() ? function(x) {
    return typeof x;
  } : function(x) {
    return x instanceof SymbolValue ? 'symbol' : typeof x;
  };
  return {get typeof() {
      return typeOf;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/typeof.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/typeof.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_symbols_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./symbols.js", "traceur@0.0.108/src/runtime/modules/typeof.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_symbols_46_js__.typeof;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/symbols.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/symbols.js";
  var t = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/typeof.js", "traceur@0.0.108/src/runtime/symbols.js")).default;
  $traceurRuntime.typeof = t;
  return {};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/createClass.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/createClass.js";
  var $Object = Object;
  var $TypeError = TypeError;
  var $__1 = Object,
      create = $__1.create,
      defineProperties = $__1.defineProperties,
      defineProperty = $__1.defineProperty,
      getOwnPropertyDescriptor = $__1.getOwnPropertyDescriptor,
      getOwnPropertyNames = $__1.getOwnPropertyNames,
      getOwnPropertySymbols = $__1.getOwnPropertySymbols;
  function forEachPropertyKey(object, f) {
    getOwnPropertyNames(object).forEach(f);
    if (getOwnPropertySymbols) {
      getOwnPropertySymbols(object).forEach(f);
    }
  }
  function getDescriptors(object) {
    var descriptors = {};
    forEachPropertyKey(object, function(key) {
      descriptors[key] = getOwnPropertyDescriptor(object, key);
      descriptors[key].enumerable = false;
    });
    return descriptors;
  }
  var nonEnum = {enumerable: false};
  function makePropertiesNonEnumerable(object) {
    forEachPropertyKey(object, function(key) {
      defineProperty(object, key, nonEnum);
    });
  }
  function createClass(ctor, object, staticObject, superClass) {
    defineProperty(object, 'constructor', {
      value: ctor,
      configurable: true,
      enumerable: false,
      writable: true
    });
    if (arguments.length > 3) {
      if (typeof superClass === 'function')
        ctor.__proto__ = superClass;
      ctor.prototype = create(getProtoParent(superClass), getDescriptors(object));
    } else {
      makePropertiesNonEnumerable(object);
      ctor.prototype = object;
    }
    defineProperty(ctor, 'prototype', {
      configurable: false,
      writable: false
    });
    return defineProperties(ctor, getDescriptors(staticObject));
  }
  var $__default = createClass;
  function getProtoParent(superClass) {
    if (typeof superClass === 'function') {
      var prototype = superClass.prototype;
      if ($Object(prototype) === prototype || prototype === null)
        return superClass.prototype;
      throw new $TypeError('super prototype must be an Object or null');
    }
    if (superClass === null)
      return null;
    throw new $TypeError(("Super expression must either be null or a function, not " + typeof superClass + "."));
  }
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/superConstructor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/superConstructor.js";
  function superConstructor(ctor) {
    return ctor.__proto__;
  }
  var $__default = superConstructor;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/superDescriptor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/superDescriptor.js";
  var $__0 = Object,
      getOwnPropertyDescriptor = $__0.getOwnPropertyDescriptor,
      getPrototypeOf = $__0.getPrototypeOf;
  function superDescriptor(homeObject, name) {
    var proto = getPrototypeOf(homeObject);
    do {
      var result = getOwnPropertyDescriptor(proto, name);
      if (result)
        return result;
      proto = getPrototypeOf(proto);
    } while (proto);
    return undefined;
  }
  var $__default = superDescriptor;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/superGet.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/superGet.js";
  var superDescriptor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./superDescriptor.js", "traceur@0.0.108/src/runtime/modules/superGet.js")).default;
  function superGet(self, homeObject, name) {
    var descriptor = superDescriptor(homeObject, name);
    if (descriptor) {
      var value = descriptor.value;
      if (value)
        return value;
      if (!descriptor.get)
        return value;
      return descriptor.get.call(self);
    }
    return undefined;
  }
  var $__default = superGet;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/superSet.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/superSet.js";
  var superDescriptor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./superDescriptor.js", "traceur@0.0.108/src/runtime/modules/superSet.js")).default;
  var $TypeError = TypeError;
  function superSet(self, homeObject, name, value) {
    var descriptor = superDescriptor(homeObject, name);
    if (descriptor && descriptor.set) {
      descriptor.set.call(self, value);
      return value;
    }
    throw $TypeError(("super has no setter '" + name + "'."));
  }
  var $__default = superSet;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/classes.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/classes.js";
  var createClass = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/createClass.js", "traceur@0.0.108/src/runtime/classes.js")).default;
  var superConstructor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/superConstructor.js", "traceur@0.0.108/src/runtime/classes.js")).default;
  var superGet = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/superGet.js", "traceur@0.0.108/src/runtime/classes.js")).default;
  var superSet = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/superSet.js", "traceur@0.0.108/src/runtime/classes.js")).default;
  $traceurRuntime.createClass = createClass;
  $traceurRuntime.superConstructor = superConstructor;
  $traceurRuntime.superGet = superGet;
  $traceurRuntime.superSet = superSet;
  return {};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/exportStar.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/exportStar.js";
  var $__1 = Object,
      defineProperty = $__1.defineProperty,
      getOwnPropertyNames = $__1.getOwnPropertyNames;
  function exportStar(object) {
    var $__2 = arguments,
        $__3 = function(i) {
          var mod = $__2[i];
          var names = getOwnPropertyNames(mod);
          var $__5 = function(j) {
            var name = names[j];
            if (name === '__esModule' || name === 'default') {
              return 0;
            }
            defineProperty(object, name, {
              get: function() {
                return mod[name];
              },
              enumerable: true
            });
          },
              $__6;
          $__4: for (var j = 0; j < names.length; j++) {
            $__6 = $__5(j);
            switch ($__6) {
              case 0:
                continue $__4;
            }
          }
        };
    for (var i = 1; i < arguments.length; i++) {
      $__3(i);
    }
    return object;
  }
  var $__default = exportStar;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/exportStar.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/exportStar.js";
  var exportStar = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/exportStar.js", "traceur@0.0.108/src/runtime/exportStar.js")).default;
  $traceurRuntime.exportStar = exportStar;
  return {};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/private-symbol.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/private-symbol.js";
  var newUniqueString = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./new-unique-string.js", "traceur@0.0.108/src/runtime/private-symbol.js")).default;
  var $Symbol = typeof Symbol === 'function' ? Symbol : undefined;
  var $getOwnPropertySymbols = Object.getOwnPropertySymbols;
  var $create = Object.create;
  var privateNames = $create(null);
  function isPrivateSymbol(s) {
    return privateNames[s];
  }
  ;
  function createPrivateSymbol() {
    var s = ($Symbol || newUniqueString)();
    privateNames[s] = true;
    return s;
  }
  ;
  function hasPrivate(obj, sym) {
    return hasOwnProperty.call(obj, sym);
  }
  ;
  function deletePrivate(obj, sym) {
    if (!hasPrivate(obj, sym)) {
      return false;
    }
    delete obj[sym];
    return true;
  }
  ;
  function setPrivate(obj, sym, val) {
    obj[sym] = val;
  }
  ;
  function getPrivate(obj, sym) {
    var val = obj[sym];
    if (val === undefined)
      return undefined;
    return hasOwnProperty.call(obj, sym) ? val : undefined;
  }
  ;
  function init() {
    if ($getOwnPropertySymbols) {
      Object.getOwnPropertySymbols = function getOwnPropertySymbols(object) {
        var rv = [];
        var symbols = $getOwnPropertySymbols(object);
        for (var i = 0; i < symbols.length; i++) {
          var symbol = symbols[i];
          if (!isPrivateSymbol(symbol)) {
            rv.push(symbol);
          }
        }
        return rv;
      };
    }
  }
  return {
    get isPrivateSymbol() {
      return isPrivateSymbol;
    },
    get createPrivateSymbol() {
      return createPrivateSymbol;
    },
    get hasPrivate() {
      return hasPrivate;
    },
    get deletePrivate() {
      return deletePrivate;
    },
    get setPrivate() {
      return setPrivate;
    },
    get getPrivate() {
      return getPrivate;
    },
    get init() {
      return init;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/private-weak-map.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/private-weak-map.js";
  var $WeakMap = typeof WeakMap === 'function' ? WeakMap : undefined;
  function isPrivateSymbol(s) {
    return false;
  }
  function createPrivateSymbol() {
    return new $WeakMap();
  }
  function hasPrivate(obj, sym) {
    return sym.has(obj);
  }
  function deletePrivate(obj, sym) {
    return sym.delete(obj);
  }
  function setPrivate(obj, sym, val) {
    sym.set(obj, val);
  }
  function getPrivate(obj, sym) {
    return sym.get(obj);
  }
  function init() {}
  return {
    get isPrivateSymbol() {
      return isPrivateSymbol;
    },
    get createPrivateSymbol() {
      return createPrivateSymbol;
    },
    get hasPrivate() {
      return hasPrivate;
    },
    get deletePrivate() {
      return deletePrivate;
    },
    get setPrivate() {
      return setPrivate;
    },
    get getPrivate() {
      return getPrivate;
    },
    get init() {
      return init;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/private.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/private.js";
  var sym = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./private-symbol.js", "traceur@0.0.108/src/runtime/private.js"));
  var weak = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./private-weak-map.js", "traceur@0.0.108/src/runtime/private.js"));
  var hasWeakMap = typeof WeakMap === 'function';
  var m = hasWeakMap ? weak : sym;
  var isPrivateSymbol = m.isPrivateSymbol;
  var createPrivateSymbol = m.createPrivateSymbol;
  var hasPrivate = m.hasPrivate;
  var deletePrivate = m.deletePrivate;
  var setPrivate = m.setPrivate;
  var getPrivate = m.getPrivate;
  m.init();
  return {
    get isPrivateSymbol() {
      return isPrivateSymbol;
    },
    get createPrivateSymbol() {
      return createPrivateSymbol;
    },
    get hasPrivate() {
      return hasPrivate;
    },
    get deletePrivate() {
      return deletePrivate;
    },
    get setPrivate() {
      return setPrivate;
    },
    get getPrivate() {
      return getPrivate;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/properTailCalls.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/properTailCalls.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../private.js", "traceur@0.0.108/src/runtime/modules/properTailCalls.js")),
      getPrivate = $__0.getPrivate,
      setPrivate = $__0.setPrivate,
      createPrivateSymbol = $__0.createPrivateSymbol;
  var $apply = Function.prototype.call.bind(Function.prototype.apply);
  var CONTINUATION_TYPE = Object.create(null);
  var isTailRecursiveName = null;
  function createContinuation(operand, thisArg, argsArray) {
    return [CONTINUATION_TYPE, operand, thisArg, argsArray];
  }
  function isContinuation(object) {
    return object && object[0] === CONTINUATION_TYPE;
  }
  function $bind(operand, thisArg, args) {
    var argArray = [thisArg];
    for (var i = 0; i < args.length; i++) {
      argArray[i + 1] = args[i];
    }
    var func = $apply(Function.prototype.bind, operand, argArray);
    return func;
  }
  function $construct(func, argArray) {
    var object = new ($bind(func, null, argArray));
    return object;
  }
  function isTailRecursive(func) {
    return !!getPrivate(func, isTailRecursiveName);
  }
  function tailCall(func, thisArg, argArray) {
    var continuation = argArray[0];
    if (isContinuation(continuation)) {
      continuation = $apply(func, thisArg, continuation[3]);
      return continuation;
    }
    continuation = createContinuation(func, thisArg, argArray);
    while (true) {
      if (isTailRecursive(func)) {
        continuation = $apply(func, continuation[2], [continuation]);
      } else {
        continuation = $apply(func, continuation[2], continuation[3]);
      }
      if (!isContinuation(continuation)) {
        return continuation;
      }
      func = continuation[1];
    }
  }
  function construct() {
    var object;
    if (isTailRecursive(this)) {
      object = $construct(this, [createContinuation(null, null, arguments)]);
    } else {
      object = $construct(this, arguments);
    }
    return object;
  }
  function setupProperTailCalls() {
    isTailRecursiveName = createPrivateSymbol();
    Function.prototype.call = initTailRecursiveFunction(function call(thisArg) {
      var result = tailCall(function(thisArg) {
        var argArray = [];
        for (var i = 1; i < arguments.length; ++i) {
          argArray[i - 1] = arguments[i];
        }
        var continuation = createContinuation(this, thisArg, argArray);
        return continuation;
      }, this, arguments);
      return result;
    });
    Function.prototype.apply = initTailRecursiveFunction(function apply(thisArg, argArray) {
      var result = tailCall(function(thisArg, argArray) {
        var continuation = createContinuation(this, thisArg, argArray);
        return continuation;
      }, this, arguments);
      return result;
    });
  }
  function initTailRecursiveFunction(func) {
    if (isTailRecursiveName === null) {
      setupProperTailCalls();
    }
    setPrivate(func, isTailRecursiveName, true);
    return func;
  }
  return {
    get createContinuation() {
      return createContinuation;
    },
    get tailCall() {
      return tailCall;
    },
    get construct() {
      return construct;
    },
    get initTailRecursiveFunction() {
      return initTailRecursiveFunction;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/initTailRecursiveFunction.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/initTailRecursiveFunction.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_properTailCalls_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./properTailCalls.js", "traceur@0.0.108/src/runtime/modules/initTailRecursiveFunction.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_properTailCalls_46_js__.initTailRecursiveFunction;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/call.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/call.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_properTailCalls_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./properTailCalls.js", "traceur@0.0.108/src/runtime/modules/call.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_properTailCalls_46_js__.tailCall;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/continuation.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/continuation.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_properTailCalls_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./properTailCalls.js", "traceur@0.0.108/src/runtime/modules/continuation.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_properTailCalls_46_js__.createContinuation;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/construct.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/construct.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_properTailCalls_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./properTailCalls.js", "traceur@0.0.108/src/runtime/modules/construct.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_properTailCalls_46_js__.construct;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/properTailCalls.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/properTailCalls.js";
  var initTailRecursiveFunction = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/initTailRecursiveFunction.js", "traceur@0.0.108/src/runtime/properTailCalls.js")).default;
  var call = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/call.js", "traceur@0.0.108/src/runtime/properTailCalls.js")).default;
  var continuation = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/continuation.js", "traceur@0.0.108/src/runtime/properTailCalls.js")).default;
  var construct = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/construct.js", "traceur@0.0.108/src/runtime/properTailCalls.js")).default;
  $traceurRuntime.initTailRecursiveFunction = initTailRecursiveFunction;
  $traceurRuntime.call = call;
  $traceurRuntime.continuation = continuation;
  $traceurRuntime.construct = construct;
  return {};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/relativeRequire.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/relativeRequire.js";
  var path;
  function relativeRequire(callerPath, requiredPath) {
    path = path || typeof require !== 'undefined' && require('path');
    function isDirectory(path) {
      return path.slice(-1) === '/';
    }
    function isAbsolute(path) {
      return path[0] === '/';
    }
    function isRelative(path) {
      return path[0] === '.';
    }
    if (isDirectory(requiredPath) || isAbsolute(requiredPath))
      return;
    return isRelative(requiredPath) ? require(path.resolve(path.dirname(callerPath), requiredPath)) : require(requiredPath);
  }
  $traceurRuntime.require = relativeRequire;
  return {};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/checkObjectCoercible.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/checkObjectCoercible.js";
  var $TypeError = TypeError;
  function checkObjectCoercible(v) {
    if (v === null || v === undefined) {
      throw new $TypeError('Value cannot be converted to an Object');
    }
    return v;
  }
  var $__default = checkObjectCoercible;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/spread.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/spread.js";
  var checkObjectCoercible = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../checkObjectCoercible.js", "traceur@0.0.108/src/runtime/modules/spread.js")).default;
  function spread() {
    var rv = [],
        j = 0,
        iterResult;
    for (var i = 0; i < arguments.length; i++) {
      var valueToSpread = checkObjectCoercible(arguments[i]);
      if (typeof valueToSpread[Symbol.iterator] !== 'function') {
        throw new TypeError('Cannot spread non-iterable object.');
      }
      var iter = valueToSpread[Symbol.iterator]();
      while (!(iterResult = iter.next()).done) {
        rv[j++] = iterResult.value;
      }
    }
    return rv;
  }
  var $__default = spread;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/spread.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/spread.js";
  var spread = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/spread.js", "traceur@0.0.108/src/runtime/spread.js")).default;
  $traceurRuntime.spread = spread;
  return {};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/iteratorToArray.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/iteratorToArray.js";
  function iteratorToArray(iter) {
    var rv = [];
    var i = 0;
    var tmp;
    while (!(tmp = iter.next()).done) {
      rv[i++] = tmp.value;
    }
    return rv;
  }
  var $__default = iteratorToArray;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/destructuring.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/destructuring.js";
  var iteratorToArray = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/iteratorToArray.js", "traceur@0.0.108/src/runtime/destructuring.js")).default;
  $traceurRuntime.iteratorToArray = iteratorToArray;
  return {};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/async.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/async.js";
  var $__12 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../private.js", "traceur@0.0.108/src/runtime/modules/async.js")),
      createPrivateSymbol = $__12.createPrivateSymbol,
      getPrivate = $__12.getPrivate,
      setPrivate = $__12.setPrivate;
  var $__11 = Object,
      create = $__11.create,
      defineProperty = $__11.defineProperty;
  var observeName = createPrivateSymbol();
  function AsyncGeneratorFunction() {}
  function AsyncGeneratorFunctionPrototype() {}
  AsyncGeneratorFunction.prototype = AsyncGeneratorFunctionPrototype;
  AsyncGeneratorFunctionPrototype.constructor = AsyncGeneratorFunction;
  defineProperty(AsyncGeneratorFunctionPrototype, 'constructor', {enumerable: false});
  var AsyncGeneratorContext = function() {
    function AsyncGeneratorContext(observer) {
      var $__2 = this;
      this.decoratedObserver = createDecoratedGenerator(observer, function() {
        $__2.done = true;
      });
      this.done = false;
      this.inReturn = false;
    }
    return ($traceurRuntime.createClass)(AsyncGeneratorContext, {
      throw: function(error) {
        if (!this.inReturn) {
          throw error;
        }
      },
      yield: function(value) {
        if (this.done) {
          this.inReturn = true;
          throw undefined;
        }
        var result;
        try {
          result = this.decoratedObserver.next(value);
        } catch (e) {
          this.done = true;
          throw e;
        }
        if (result === undefined) {
          return;
        }
        if (result.done) {
          this.done = true;
          this.inReturn = true;
          throw undefined;
        }
        return result.value;
      },
      yieldFor: function(observable) {
        var ctx = this;
        return observeForEach(observable[Symbol.observer].bind(observable), function(value) {
          if (ctx.done) {
            this.return();
            return;
          }
          var result;
          try {
            result = ctx.decoratedObserver.next(value);
          } catch (e) {
            ctx.done = true;
            throw e;
          }
          if (result === undefined) {
            return;
          }
          if (result.done) {
            ctx.done = true;
          }
          return result;
        });
      }
    }, {});
  }();
  AsyncGeneratorFunctionPrototype.prototype[Symbol.observer] = function(observer) {
    var observe = getPrivate(this, observeName);
    var ctx = new AsyncGeneratorContext(observer);
    schedule(function() {
      return observe(ctx);
    }).then(function(value) {
      if (!ctx.done) {
        ctx.decoratedObserver.return(value);
      }
    }).catch(function(error) {
      if (!ctx.done) {
        ctx.decoratedObserver.throw(error);
      }
    });
    return ctx.decoratedObserver;
  };
  defineProperty(AsyncGeneratorFunctionPrototype.prototype, Symbol.observer, {enumerable: false});
  function initAsyncGeneratorFunction(functionObject) {
    functionObject.prototype = create(AsyncGeneratorFunctionPrototype.prototype);
    functionObject.__proto__ = AsyncGeneratorFunctionPrototype;
    return functionObject;
  }
  function createAsyncGeneratorInstance(observe, functionObject) {
    for (var args = [],
        $__10 = 2; $__10 < arguments.length; $__10++)
      args[$__10 - 2] = arguments[$__10];
    var object = create(functionObject.prototype);
    setPrivate(object, observeName, observe);
    return object;
  }
  function observeForEach(observe, next) {
    return new Promise(function(resolve, reject) {
      var generator = observe({
        next: function(value) {
          return next.call(generator, value);
        },
        throw: function(error) {
          reject(error);
        },
        return: function(value) {
          resolve(value);
        }
      });
    });
  }
  function schedule(asyncF) {
    return Promise.resolve().then(asyncF);
  }
  var generator = Symbol();
  var onDone = Symbol();
  var DecoratedGenerator = function() {
    function DecoratedGenerator(_generator, _onDone) {
      this[generator] = _generator;
      this[onDone] = _onDone;
    }
    return ($traceurRuntime.createClass)(DecoratedGenerator, {
      next: function(value) {
        var result = this[generator].next(value);
        if (result !== undefined && result.done) {
          this[onDone].call(this);
        }
        return result;
      },
      throw: function(error) {
        this[onDone].call(this);
        return this[generator].throw(error);
      },
      return: function(value) {
        this[onDone].call(this);
        return this[generator].return(value);
      }
    }, {});
  }();
  function createDecoratedGenerator(generator, onDone) {
    return new DecoratedGenerator(generator, onDone);
  }
  Array.prototype[Symbol.observer] = function(observer) {
    var done = false;
    var decoratedObserver = createDecoratedGenerator(observer, function() {
      return done = true;
    });
    var $__6 = true;
    var $__7 = false;
    var $__8 = undefined;
    try {
      for (var $__4 = void 0,
          $__3 = (this)[Symbol.iterator](); !($__6 = ($__4 = $__3.next()).done); $__6 = true) {
        var value = $__4.value;
        {
          decoratedObserver.next(value);
          if (done) {
            return;
          }
        }
      }
    } catch ($__9) {
      $__7 = true;
      $__8 = $__9;
    } finally {
      try {
        if (!$__6 && $__3.return != null) {
          $__3.return();
        }
      } finally {
        if ($__7) {
          throw $__8;
        }
      }
    }
    decoratedObserver.return();
    return decoratedObserver;
  };
  defineProperty(Array.prototype, Symbol.observer, {enumerable: false});
  return {
    get initAsyncGeneratorFunction() {
      return initAsyncGeneratorFunction;
    },
    get createAsyncGeneratorInstance() {
      return createAsyncGeneratorInstance;
    },
    get observeForEach() {
      return observeForEach;
    },
    get schedule() {
      return schedule;
    },
    get createDecoratedGenerator() {
      return createDecoratedGenerator;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/initAsyncGeneratorFunction.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/initAsyncGeneratorFunction.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_async_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./async.js", "traceur@0.0.108/src/runtime/modules/initAsyncGeneratorFunction.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_async_46_js__.initAsyncGeneratorFunction;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/createAsyncGeneratorInstance.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/createAsyncGeneratorInstance.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_async_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./async.js", "traceur@0.0.108/src/runtime/modules/createAsyncGeneratorInstance.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_async_46_js__.createAsyncGeneratorInstance;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/observeForEach.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/observeForEach.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_async_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./async.js", "traceur@0.0.108/src/runtime/modules/observeForEach.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_async_46_js__.observeForEach;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/schedule.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/schedule.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_async_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./async.js", "traceur@0.0.108/src/runtime/modules/schedule.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_async_46_js__.schedule;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/createDecoratedGenerator.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/createDecoratedGenerator.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_async_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./async.js", "traceur@0.0.108/src/runtime/modules/createDecoratedGenerator.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_async_46_js__.createDecoratedGenerator;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/async.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/async.js";
  var initAsyncGeneratorFunction = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/initAsyncGeneratorFunction.js", "traceur@0.0.108/src/runtime/async.js")).default;
  var createAsyncGeneratorInstance = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/createAsyncGeneratorInstance.js", "traceur@0.0.108/src/runtime/async.js")).default;
  var observeForEach = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/observeForEach.js", "traceur@0.0.108/src/runtime/async.js")).default;
  var schedule = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/schedule.js", "traceur@0.0.108/src/runtime/async.js")).default;
  var createDecoratedGenerator = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/createDecoratedGenerator.js", "traceur@0.0.108/src/runtime/async.js")).default;
  $traceurRuntime.initAsyncGeneratorFunction = initAsyncGeneratorFunction;
  $traceurRuntime.createAsyncGeneratorInstance = createAsyncGeneratorInstance;
  $traceurRuntime.observeForEach = observeForEach;
  $traceurRuntime.schedule = schedule;
  $traceurRuntime.createDecoratedGenerator = createDecoratedGenerator;
  return {};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/generators.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/generators.js";
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../private.js", "traceur@0.0.108/src/runtime/modules/generators.js")),
      createPrivateSymbol = $__2.createPrivateSymbol,
      getPrivate = $__2.getPrivate,
      setPrivate = $__2.setPrivate;
  var $TypeError = TypeError;
  var $__1 = Object,
      create = $__1.create,
      defineProperties = $__1.defineProperties,
      defineProperty = $__1.defineProperty;
  function nonEnum(value) {
    return {
      configurable: true,
      enumerable: false,
      value: value,
      writable: true
    };
  }
  var ST_NEWBORN = 0;
  var ST_EXECUTING = 1;
  var ST_SUSPENDED = 2;
  var ST_CLOSED = 3;
  var END_STATE = -2;
  var RETHROW_STATE = -3;
  function getInternalError(state) {
    return new Error('Traceur compiler bug: invalid state in state machine: ' + state);
  }
  var RETURN_SENTINEL = {};
  function GeneratorContext() {
    this.state = 0;
    this.GState = ST_NEWBORN;
    this.storedException = undefined;
    this.finallyFallThrough = undefined;
    this.sent_ = undefined;
    this.returnValue = undefined;
    this.oldReturnValue = undefined;
    this.tryStack_ = [];
  }
  GeneratorContext.prototype = {
    pushTry: function(catchState, finallyState) {
      if (finallyState !== null) {
        var finallyFallThrough = null;
        for (var i = this.tryStack_.length - 1; i >= 0; i--) {
          if (this.tryStack_[i].catch !== undefined) {
            finallyFallThrough = this.tryStack_[i].catch;
            break;
          }
        }
        if (finallyFallThrough === null)
          finallyFallThrough = RETHROW_STATE;
        this.tryStack_.push({
          finally: finallyState,
          finallyFallThrough: finallyFallThrough
        });
      }
      if (catchState !== null) {
        this.tryStack_.push({catch: catchState});
      }
    },
    popTry: function() {
      this.tryStack_.pop();
    },
    maybeUncatchable: function() {
      if (this.storedException === RETURN_SENTINEL) {
        throw RETURN_SENTINEL;
      }
    },
    get sent() {
      this.maybeThrow();
      return this.sent_;
    },
    set sent(v) {
      this.sent_ = v;
    },
    get sentIgnoreThrow() {
      return this.sent_;
    },
    maybeThrow: function() {
      if (this.action === 'throw') {
        this.action = 'next';
        throw this.sent_;
      }
    },
    end: function() {
      switch (this.state) {
        case END_STATE:
          return this;
        case RETHROW_STATE:
          throw this.storedException;
        default:
          throw getInternalError(this.state);
      }
    },
    handleException: function(ex) {
      this.GState = ST_CLOSED;
      this.state = END_STATE;
      throw ex;
    },
    wrapYieldStar: function(iterator) {
      var ctx = this;
      return {
        next: function(v) {
          return iterator.next(v);
        },
        throw: function(e) {
          var result;
          if (e === RETURN_SENTINEL) {
            if (iterator.return) {
              result = iterator.return(ctx.returnValue);
              if (!result.done) {
                ctx.returnValue = ctx.oldReturnValue;
                return result;
              }
              ctx.returnValue = result.value;
            }
            throw e;
          }
          if (iterator.throw) {
            return iterator.throw(e);
          }
          iterator.return && iterator.return();
          throw $TypeError('Inner iterator does not have a throw method');
        }
      };
    }
  };
  function nextOrThrow(ctx, moveNext, action, x) {
    switch (ctx.GState) {
      case ST_EXECUTING:
        throw new Error(("\"" + action + "\" on executing generator"));
      case ST_CLOSED:
        if (action == 'next') {
          return {
            value: undefined,
            done: true
          };
        }
        if (x === RETURN_SENTINEL) {
          return {
            value: ctx.returnValue,
            done: true
          };
        }
        throw x;
      case ST_NEWBORN:
        if (action === 'throw') {
          ctx.GState = ST_CLOSED;
          if (x === RETURN_SENTINEL) {
            return {
              value: ctx.returnValue,
              done: true
            };
          }
          throw x;
        }
        if (x !== undefined)
          throw $TypeError('Sent value to newborn generator');
      case ST_SUSPENDED:
        ctx.GState = ST_EXECUTING;
        ctx.action = action;
        ctx.sent = x;
        var value;
        try {
          value = moveNext(ctx);
        } catch (ex) {
          if (ex === RETURN_SENTINEL) {
            value = ctx;
          } else {
            throw ex;
          }
        }
        var done = value === ctx;
        if (done)
          value = ctx.returnValue;
        ctx.GState = done ? ST_CLOSED : ST_SUSPENDED;
        return {
          value: value,
          done: done
        };
    }
  }
  var ctxName = createPrivateSymbol();
  var moveNextName = createPrivateSymbol();
  function GeneratorFunction() {}
  function GeneratorFunctionPrototype() {}
  GeneratorFunction.prototype = GeneratorFunctionPrototype;
  defineProperty(GeneratorFunctionPrototype, 'constructor', nonEnum(GeneratorFunction));
  GeneratorFunctionPrototype.prototype = {
    constructor: GeneratorFunctionPrototype,
    next: function(v) {
      return nextOrThrow(getPrivate(this, ctxName), getPrivate(this, moveNextName), 'next', v);
    },
    throw: function(v) {
      return nextOrThrow(getPrivate(this, ctxName), getPrivate(this, moveNextName), 'throw', v);
    },
    return: function(v) {
      var ctx = getPrivate(this, ctxName);
      ctx.oldReturnValue = ctx.returnValue;
      ctx.returnValue = v;
      return nextOrThrow(ctx, getPrivate(this, moveNextName), 'throw', RETURN_SENTINEL);
    }
  };
  defineProperties(GeneratorFunctionPrototype.prototype, {
    constructor: {enumerable: false},
    next: {enumerable: false},
    throw: {enumerable: false},
    return: {enumerable: false}
  });
  Object.defineProperty(GeneratorFunctionPrototype.prototype, Symbol.iterator, nonEnum(function() {
    return this;
  }));
  function createGeneratorInstance(innerFunction, functionObject, self) {
    var moveNext = getMoveNext(innerFunction, self);
    var ctx = new GeneratorContext();
    var object = create(functionObject.prototype);
    setPrivate(object, ctxName, ctx);
    setPrivate(object, moveNextName, moveNext);
    return object;
  }
  function initGeneratorFunction(functionObject) {
    functionObject.prototype = create(GeneratorFunctionPrototype.prototype);
    functionObject.__proto__ = GeneratorFunctionPrototype;
    return functionObject;
  }
  function AsyncFunctionContext() {
    GeneratorContext.call(this);
    this.err = undefined;
    var ctx = this;
    ctx.result = new Promise(function(resolve, reject) {
      ctx.resolve = resolve;
      ctx.reject = reject;
    });
  }
  AsyncFunctionContext.prototype = create(GeneratorContext.prototype);
  AsyncFunctionContext.prototype.end = function() {
    switch (this.state) {
      case END_STATE:
        this.resolve(this.returnValue);
        break;
      case RETHROW_STATE:
        this.reject(this.storedException);
        break;
      default:
        this.reject(getInternalError(this.state));
    }
  };
  AsyncFunctionContext.prototype.handleException = function() {
    this.state = RETHROW_STATE;
  };
  function asyncWrap(innerFunction, self) {
    var moveNext = getMoveNext(innerFunction, self);
    var ctx = new AsyncFunctionContext();
    ctx.createCallback = function(newState) {
      return function(value) {
        ctx.state = newState;
        ctx.value = value;
        moveNext(ctx);
      };
    };
    ctx.errback = function(err) {
      handleCatch(ctx, err);
      moveNext(ctx);
    };
    moveNext(ctx);
    return ctx.result;
  }
  function getMoveNext(innerFunction, self) {
    return function(ctx) {
      while (true) {
        try {
          return innerFunction.call(self, ctx);
        } catch (ex) {
          handleCatch(ctx, ex);
        }
      }
    };
  }
  function handleCatch(ctx, ex) {
    ctx.storedException = ex;
    var last = ctx.tryStack_[ctx.tryStack_.length - 1];
    if (!last) {
      ctx.handleException(ex);
      return;
    }
    ctx.state = last.catch !== undefined ? last.catch : last.finally;
    if (last.finallyFallThrough !== undefined)
      ctx.finallyFallThrough = last.finallyFallThrough;
  }
  return {
    get createGeneratorInstance() {
      return createGeneratorInstance;
    },
    get initGeneratorFunction() {
      return initGeneratorFunction;
    },
    get asyncWrap() {
      return asyncWrap;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/asyncWrap.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/asyncWrap.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_generators_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./generators.js", "traceur@0.0.108/src/runtime/modules/asyncWrap.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_generators_46_js__.asyncWrap;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/initGeneratorFunction.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/initGeneratorFunction.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_generators_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./generators.js", "traceur@0.0.108/src/runtime/modules/initGeneratorFunction.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_generators_46_js__.initGeneratorFunction;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/createGeneratorInstance.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/createGeneratorInstance.js";
  var $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_generators_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./generators.js", "traceur@0.0.108/src/runtime/modules/createGeneratorInstance.js"));
  return {get default() {
      return $__traceur_64_0_46_0_46_108_47_src_47_runtime_47_modules_47_generators_46_js__.createGeneratorInstance;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/generators.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/generators.js";
  var asyncWrap = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/asyncWrap.js", "traceur@0.0.108/src/runtime/generators.js")).default;
  var initGeneratorFunction = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/initGeneratorFunction.js", "traceur@0.0.108/src/runtime/generators.js")).default;
  var createGeneratorInstance = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/createGeneratorInstance.js", "traceur@0.0.108/src/runtime/generators.js")).default;
  $traceurRuntime.asyncWrap = asyncWrap;
  $traceurRuntime.initGeneratorFunction = initGeneratorFunction;
  $traceurRuntime.createGeneratorInstance = createGeneratorInstance;
  return {};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/spawn.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/spawn.js";
  function spawn(self, args, gen) {
    return new Promise(function(resolve, reject) {
      function fulfill(v) {
        try {
          step(gen.next(v));
        } catch (e) {
          reject(e);
        }
      }
      function rejected(v) {
        try {
          step(gen.throw(v));
        } catch (e) {
          reject(e);
        }
      }
      function step(res) {
        if (res.done) {
          resolve(res.value);
        } else {
          Promise.resolve(res.value).then(fulfill, rejected);
        }
      }
      step((gen = gen.apply(self, args)).next());
    });
  }
  var $__default = spawn;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/spawn.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/spawn.js";
  var spawn = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/spawn.js", "traceur@0.0.108/src/runtime/spawn.js")).default;
  $traceurRuntime.spawn = spawn;
  return {};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/getTemplateObject.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/getTemplateObject.js";
  var $__1 = Object,
      defineProperty = $__1.defineProperty,
      freeze = $__1.freeze;
  var slice = Array.prototype.slice;
  var map = Object.create(null);
  function getTemplateObject(raw) {
    var cooked = arguments[1];
    var key = raw.join('${}');
    var templateObject = map[key];
    if (templateObject)
      return templateObject;
    if (!cooked) {
      cooked = slice.call(raw);
    }
    return map[key] = freeze(defineProperty(cooked, 'raw', {value: freeze(raw)}));
  }
  var $__default = getTemplateObject;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/template.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/template.js";
  var getTemplateObject = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/getTemplateObject.js", "traceur@0.0.108/src/runtime/template.js")).default;
  $traceurRuntime.getTemplateObject = getTemplateObject;
  return {};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/modules/spreadProperties.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/modules/spreadProperties.js";
  var $__1 = Object,
      defineProperty = $__1.defineProperty,
      getOwnPropertyNames = $__1.getOwnPropertyNames,
      getOwnPropertySymbols = $__1.getOwnPropertySymbols,
      propertyIsEnumerable = $__1.propertyIsEnumerable;
  function createDataProperty(o, p, v) {
    defineProperty(o, p, {
      configurable: true,
      enumerable: true,
      value: v,
      writable: true
    });
  }
  function copyDataProperties(target, source) {
    if (source == null) {
      return;
    }
    var copy = function(keys) {
      for (var i = 0; i < keys.length; i++) {
        var nextKey = keys[i];
        if (propertyIsEnumerable.call(source, nextKey)) {
          var propValue = source[nextKey];
          createDataProperty(target, nextKey, propValue);
        }
      }
    };
    copy(getOwnPropertyNames(source));
    copy(getOwnPropertySymbols(source));
  }
  var $__default = function() {
    var target = arguments[0];
    for (var i = 1; i < arguments.length; i++) {
      copyDataProperties(target, arguments[i]);
    }
    return target;
  };
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/jsx.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/jsx.js";
  var spreadProperties = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./modules/spreadProperties.js", "traceur@0.0.108/src/runtime/jsx.js")).default;
  $traceurRuntime.spreadProperties = spreadProperties;
  return {};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/runtime-modules.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/runtime-modules.js";
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./symbols.js", "traceur@0.0.108/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./classes.js", "traceur@0.0.108/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./exportStar.js", "traceur@0.0.108/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./properTailCalls.js", "traceur@0.0.108/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./relativeRequire.js", "traceur@0.0.108/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./spread.js", "traceur@0.0.108/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./destructuring.js", "traceur@0.0.108/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./async.js", "traceur@0.0.108/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./generators.js", "traceur@0.0.108/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./spawn.js", "traceur@0.0.108/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./template.js", "traceur@0.0.108/src/runtime/runtime-modules.js"));
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./jsx.js", "traceur@0.0.108/src/runtime/runtime-modules.js"));
  return {};
});
$traceurRuntime.getModule("traceur@0.0.108/src/runtime/runtime-modules.js" + '');
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/frozen-data.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/frozen-data.js";
  function findIndex(arr, key) {
    for (var i = 0; i < arr.length; i += 2) {
      if (arr[i] === key) {
        return i;
      }
    }
    return -1;
  }
  function setFrozen(arr, key, val) {
    var i = findIndex(arr, key);
    if (i === -1) {
      arr.push(key, val);
    }
  }
  function getFrozen(arr, key) {
    var i = findIndex(arr, key);
    if (i !== -1) {
      return arr[i + 1];
    }
    return undefined;
  }
  function hasFrozen(arr, key) {
    return findIndex(arr, key) !== -1;
  }
  function deleteFrozen(arr, key) {
    var i = findIndex(arr, key);
    if (i !== -1) {
      arr.splice(i, 2);
      return true;
    }
    return false;
  }
  return {
    get setFrozen() {
      return setFrozen;
    },
    get getFrozen() {
      return getFrozen;
    },
    get hasFrozen() {
      return hasFrozen;
    },
    get deleteFrozen() {
      return deleteFrozen;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/utils.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/utils.js";
  var $ceil = Math.ceil;
  var $floor = Math.floor;
  var $isFinite = isFinite;
  var $isNaN = isNaN;
  var $pow = Math.pow;
  var $min = Math.min;
  var $TypeError = TypeError;
  var $Object = Object;
  function toObject(x) {
    if (x == null) {
      throw $TypeError();
    }
    return $Object(x);
  }
  function toUint32(x) {
    return x >>> 0;
  }
  function isObject(x) {
    return x && (typeof x === 'object' || typeof x === 'function');
  }
  function isCallable(x) {
    return typeof x === 'function';
  }
  function isNumber(x) {
    return typeof x === 'number';
  }
  function toInteger(x) {
    x = +x;
    if ($isNaN(x))
      return 0;
    if (x === 0 || !$isFinite(x))
      return x;
    return x > 0 ? $floor(x) : $ceil(x);
  }
  var MAX_SAFE_LENGTH = $pow(2, 53) - 1;
  function toLength(x) {
    var len = toInteger(x);
    return len < 0 ? 0 : $min(len, MAX_SAFE_LENGTH);
  }
  function checkIterable(x) {
    return !isObject(x) ? undefined : x[Symbol.iterator];
  }
  function isConstructor(x) {
    return isCallable(x);
  }
  function createIteratorResultObject(value, done) {
    return {
      value: value,
      done: done
    };
  }
  function maybeDefine(object, name, descr) {
    if (!(name in object)) {
      Object.defineProperty(object, name, descr);
    }
  }
  function maybeDefineMethod(object, name, value) {
    maybeDefine(object, name, {
      value: value,
      configurable: true,
      enumerable: false,
      writable: true
    });
  }
  function maybeDefineConst(object, name, value) {
    maybeDefine(object, name, {
      value: value,
      configurable: false,
      enumerable: false,
      writable: false
    });
  }
  function maybeAddFunctions(object, functions) {
    for (var i = 0; i < functions.length; i += 2) {
      var name = functions[i];
      var value = functions[i + 1];
      maybeDefineMethod(object, name, value);
    }
  }
  function maybeAddConsts(object, consts) {
    for (var i = 0; i < consts.length; i += 2) {
      var name = consts[i];
      var value = consts[i + 1];
      maybeDefineConst(object, name, value);
    }
  }
  function maybeAddIterator(object, func, Symbol) {
    if (!Symbol || !Symbol.iterator || object[Symbol.iterator])
      return;
    if (object['@@iterator'])
      func = object['@@iterator'];
    Object.defineProperty(object, Symbol.iterator, {
      value: func,
      configurable: true,
      enumerable: false,
      writable: true
    });
  }
  var polyfills = [];
  function registerPolyfill(func) {
    polyfills.push(func);
  }
  function polyfillAll(global) {
    polyfills.forEach(function(f) {
      return f(global);
    });
  }
  return {
    get toObject() {
      return toObject;
    },
    get toUint32() {
      return toUint32;
    },
    get isObject() {
      return isObject;
    },
    get isCallable() {
      return isCallable;
    },
    get isNumber() {
      return isNumber;
    },
    get toInteger() {
      return toInteger;
    },
    get toLength() {
      return toLength;
    },
    get checkIterable() {
      return checkIterable;
    },
    get isConstructor() {
      return isConstructor;
    },
    get createIteratorResultObject() {
      return createIteratorResultObject;
    },
    get maybeDefine() {
      return maybeDefine;
    },
    get maybeDefineMethod() {
      return maybeDefineMethod;
    },
    get maybeDefineConst() {
      return maybeDefineConst;
    },
    get maybeAddFunctions() {
      return maybeAddFunctions;
    },
    get maybeAddConsts() {
      return maybeAddConsts;
    },
    get maybeAddIterator() {
      return maybeAddIterator;
    },
    get registerPolyfill() {
      return registerPolyfill;
    },
    get polyfillAll() {
      return polyfillAll;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/Map.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/Map.js";
  var $__16 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../private.js", "traceur@0.0.108/src/runtime/polyfills/Map.js")),
      createPrivateSymbol = $__16.createPrivateSymbol,
      getPrivate = $__16.getPrivate,
      setPrivate = $__16.setPrivate;
  var $__17 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../frozen-data.js", "traceur@0.0.108/src/runtime/polyfills/Map.js")),
      deleteFrozen = $__17.deleteFrozen,
      getFrozen = $__17.getFrozen,
      setFrozen = $__17.setFrozen;
  var $__18 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/Map.js")),
      isObject = $__18.isObject,
      registerPolyfill = $__18.registerPolyfill;
  var hasNativeSymbol = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../has-native-symbols.js", "traceur@0.0.108/src/runtime/polyfills/Map.js")).default;
  var $__9 = Object,
      defineProperty = $__9.defineProperty,
      getOwnPropertyDescriptor = $__9.getOwnPropertyDescriptor,
      hasOwnProperty = $__9.hasOwnProperty,
      isExtensible = $__9.isExtensible;
  var deletedSentinel = {};
  var counter = 1;
  var hashCodeName = createPrivateSymbol();
  function getHashCodeForObject(obj) {
    return getPrivate(obj, hashCodeName);
  }
  function getOrSetHashCodeForObject(obj) {
    var hash = getHashCodeForObject(obj);
    if (!hash) {
      hash = counter++;
      setPrivate(obj, hashCodeName, hash);
    }
    return hash;
  }
  function lookupIndex(map, key) {
    if (typeof key === 'string') {
      return map.stringIndex_[key];
    }
    if (isObject(key)) {
      if (!isExtensible(key)) {
        return getFrozen(map.frozenData_, key);
      }
      var hc = getHashCodeForObject(key);
      if (hc === undefined) {
        return undefined;
      }
      return map.objectIndex_[hc];
    }
    return map.primitiveIndex_[key];
  }
  function initMap(map) {
    map.entries_ = [];
    map.objectIndex_ = Object.create(null);
    map.stringIndex_ = Object.create(null);
    map.primitiveIndex_ = Object.create(null);
    map.frozenData_ = [];
    map.deletedCount_ = 0;
  }
  var Map = function() {
    function Map() {
      var $__11,
          $__12;
      var iterable = arguments[0];
      if (!isObject(this))
        throw new TypeError('Map called on incompatible type');
      if (hasOwnProperty.call(this, 'entries_')) {
        throw new TypeError('Map can not be reentrantly initialised');
      }
      initMap(this);
      if (iterable !== null && iterable !== undefined) {
        var $__5 = true;
        var $__6 = false;
        var $__7 = undefined;
        try {
          for (var $__3 = void 0,
              $__2 = (iterable)[Symbol.iterator](); !($__5 = ($__3 = $__2.next()).done); $__5 = true) {
            var $__10 = $__3.value,
                key = ($__11 = $__10[Symbol.iterator](), ($__12 = $__11.next()).done ? void 0 : $__12.value),
                value = ($__12 = $__11.next()).done ? void 0 : $__12.value;
            {
              this.set(key, value);
            }
          }
        } catch ($__8) {
          $__6 = true;
          $__7 = $__8;
        } finally {
          try {
            if (!$__5 && $__2.return != null) {
              $__2.return();
            }
          } finally {
            if ($__6) {
              throw $__7;
            }
          }
        }
      }
    }
    return ($traceurRuntime.createClass)(Map, {
      get size() {
        return this.entries_.length / 2 - this.deletedCount_;
      },
      get: function(key) {
        var index = lookupIndex(this, key);
        if (index !== undefined) {
          return this.entries_[index + 1];
        }
      },
      set: function(key, value) {
        var index = lookupIndex(this, key);
        if (index !== undefined) {
          this.entries_[index + 1] = value;
        } else {
          index = this.entries_.length;
          this.entries_[index] = key;
          this.entries_[index + 1] = value;
          if (isObject(key)) {
            if (!isExtensible(key)) {
              setFrozen(this.frozenData_, key, index);
            } else {
              var hash = getOrSetHashCodeForObject(key);
              this.objectIndex_[hash] = index;
            }
          } else if (typeof key === 'string') {
            this.stringIndex_[key] = index;
          } else {
            this.primitiveIndex_[key] = index;
          }
        }
        return this;
      },
      has: function(key) {
        return lookupIndex(this, key) !== undefined;
      },
      delete: function(key) {
        var index = lookupIndex(this, key);
        if (index === undefined) {
          return false;
        }
        this.entries_[index] = deletedSentinel;
        this.entries_[index + 1] = undefined;
        this.deletedCount_++;
        if (isObject(key)) {
          if (!isExtensible(key)) {
            deleteFrozen(this.frozenData_, key);
          } else {
            var hash = getHashCodeForObject(key);
            delete this.objectIndex_[hash];
          }
        } else if (typeof key === 'string') {
          delete this.stringIndex_[key];
        } else {
          delete this.primitiveIndex_[key];
        }
        return true;
      },
      clear: function() {
        initMap(this);
      },
      forEach: function(callbackFn) {
        var thisArg = arguments[1];
        for (var i = 0; i < this.entries_.length; i += 2) {
          var key = this.entries_[i];
          var value = this.entries_[i + 1];
          if (key === deletedSentinel)
            continue;
          callbackFn.call(thisArg, value, key, this);
        }
      },
      entries: $traceurRuntime.initGeneratorFunction(function $__13() {
        var i,
            key,
            value;
        return $traceurRuntime.createGeneratorInstance(function($ctx) {
          while (true)
            switch ($ctx.state) {
              case 0:
                i = 0;
                $ctx.state = 12;
                break;
              case 12:
                $ctx.state = (i < this.entries_.length) ? 8 : -2;
                break;
              case 4:
                i += 2;
                $ctx.state = 12;
                break;
              case 8:
                key = this.entries_[i];
                value = this.entries_[i + 1];
                $ctx.state = 9;
                break;
              case 9:
                $ctx.state = (key === deletedSentinel) ? 4 : 6;
                break;
              case 6:
                $ctx.state = 2;
                return [key, value];
              case 2:
                $ctx.maybeThrow();
                $ctx.state = 4;
                break;
              default:
                return $ctx.end();
            }
        }, $__13, this);
      }),
      keys: $traceurRuntime.initGeneratorFunction(function $__14() {
        var i,
            key,
            value;
        return $traceurRuntime.createGeneratorInstance(function($ctx) {
          while (true)
            switch ($ctx.state) {
              case 0:
                i = 0;
                $ctx.state = 12;
                break;
              case 12:
                $ctx.state = (i < this.entries_.length) ? 8 : -2;
                break;
              case 4:
                i += 2;
                $ctx.state = 12;
                break;
              case 8:
                key = this.entries_[i];
                value = this.entries_[i + 1];
                $ctx.state = 9;
                break;
              case 9:
                $ctx.state = (key === deletedSentinel) ? 4 : 6;
                break;
              case 6:
                $ctx.state = 2;
                return key;
              case 2:
                $ctx.maybeThrow();
                $ctx.state = 4;
                break;
              default:
                return $ctx.end();
            }
        }, $__14, this);
      }),
      values: $traceurRuntime.initGeneratorFunction(function $__15() {
        var i,
            key,
            value;
        return $traceurRuntime.createGeneratorInstance(function($ctx) {
          while (true)
            switch ($ctx.state) {
              case 0:
                i = 0;
                $ctx.state = 12;
                break;
              case 12:
                $ctx.state = (i < this.entries_.length) ? 8 : -2;
                break;
              case 4:
                i += 2;
                $ctx.state = 12;
                break;
              case 8:
                key = this.entries_[i];
                value = this.entries_[i + 1];
                $ctx.state = 9;
                break;
              case 9:
                $ctx.state = (key === deletedSentinel) ? 4 : 6;
                break;
              case 6:
                $ctx.state = 2;
                return value;
              case 2:
                $ctx.maybeThrow();
                $ctx.state = 4;
                break;
              default:
                return $ctx.end();
            }
        }, $__15, this);
      })
    }, {});
  }();
  defineProperty(Map.prototype, Symbol.iterator, {
    configurable: true,
    writable: true,
    value: Map.prototype.entries
  });
  function needsPolyfill(global) {
    var $__10 = global,
        Map = $__10.Map,
        Symbol = $__10.Symbol;
    if (!Map || !hasNativeSymbol() || !Map.prototype[Symbol.iterator] || !Map.prototype.entries) {
      return true;
    }
    try {
      return new Map([[]]).size !== 1;
    } catch (e) {
      return false;
    }
  }
  function polyfillMap(global) {
    if (needsPolyfill(global)) {
      global.Map = Map;
    }
  }
  registerPolyfill(polyfillMap);
  return {
    get Map() {
      return Map;
    },
    get polyfillMap() {
      return polyfillMap;
    }
  };
});
$traceurRuntime.getModule("traceur@0.0.108/src/runtime/polyfills/Map.js" + '');
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/Set.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/Set.js";
  var $__18 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/Set.js")),
      isObject = $__18.isObject,
      registerPolyfill = $__18.registerPolyfill;
  var Map = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Map.js", "traceur@0.0.108/src/runtime/polyfills/Set.js")).Map;
  var hasNativeSymbol = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../has-native-symbols.js", "traceur@0.0.108/src/runtime/polyfills/Set.js")).default;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var Set = function() {
    function Set() {
      var iterable = arguments[0];
      if (!isObject(this))
        throw new TypeError('Set called on incompatible type');
      if (hasOwnProperty.call(this, 'map_')) {
        throw new TypeError('Set can not be reentrantly initialised');
      }
      this.map_ = new Map();
      if (iterable !== null && iterable !== undefined) {
        var $__6 = true;
        var $__7 = false;
        var $__8 = undefined;
        try {
          for (var $__4 = void 0,
              $__3 = (iterable)[Symbol.iterator](); !($__6 = ($__4 = $__3.next()).done); $__6 = true) {
            var item = $__4.value;
            {
              this.add(item);
            }
          }
        } catch ($__9) {
          $__7 = true;
          $__8 = $__9;
        } finally {
          try {
            if (!$__6 && $__3.return != null) {
              $__3.return();
            }
          } finally {
            if ($__7) {
              throw $__8;
            }
          }
        }
      }
    }
    return ($traceurRuntime.createClass)(Set, {
      get size() {
        return this.map_.size;
      },
      has: function(key) {
        return this.map_.has(key);
      },
      add: function(key) {
        this.map_.set(key, key);
        return this;
      },
      delete: function(key) {
        return this.map_.delete(key);
      },
      clear: function() {
        return this.map_.clear();
      },
      forEach: function(callbackFn) {
        var thisArg = arguments[1];
        var $__2 = this;
        return this.map_.forEach(function(value, key) {
          callbackFn.call(thisArg, key, key, $__2);
        });
      },
      values: $traceurRuntime.initGeneratorFunction(function $__12() {
        var $__13,
            $__14;
        return $traceurRuntime.createGeneratorInstance(function($ctx) {
          while (true)
            switch ($ctx.state) {
              case 0:
                $__13 = $ctx.wrapYieldStar(this.map_.keys()[Symbol.iterator]());
                $ctx.sent = void 0;
                $ctx.action = 'next';
                $ctx.state = 12;
                break;
              case 12:
                $__14 = $__13[$ctx.action]($ctx.sentIgnoreThrow);
                $ctx.state = 9;
                break;
              case 9:
                $ctx.state = ($__14.done) ? 3 : 2;
                break;
              case 3:
                $ctx.sent = $__14.value;
                $ctx.state = -2;
                break;
              case 2:
                $ctx.state = 12;
                return $__14.value;
              default:
                return $ctx.end();
            }
        }, $__12, this);
      }),
      entries: $traceurRuntime.initGeneratorFunction(function $__15() {
        var $__16,
            $__17;
        return $traceurRuntime.createGeneratorInstance(function($ctx) {
          while (true)
            switch ($ctx.state) {
              case 0:
                $__16 = $ctx.wrapYieldStar(this.map_.entries()[Symbol.iterator]());
                $ctx.sent = void 0;
                $ctx.action = 'next';
                $ctx.state = 12;
                break;
              case 12:
                $__17 = $__16[$ctx.action]($ctx.sentIgnoreThrow);
                $ctx.state = 9;
                break;
              case 9:
                $ctx.state = ($__17.done) ? 3 : 2;
                break;
              case 3:
                $ctx.sent = $__17.value;
                $ctx.state = -2;
                break;
              case 2:
                $ctx.state = 12;
                return $__17.value;
              default:
                return $ctx.end();
            }
        }, $__15, this);
      })
    }, {});
  }();
  Object.defineProperty(Set.prototype, Symbol.iterator, {
    configurable: true,
    writable: true,
    value: Set.prototype.values
  });
  Object.defineProperty(Set.prototype, 'keys', {
    configurable: true,
    writable: true,
    value: Set.prototype.values
  });
  function needsPolyfill(global) {
    var $__11 = global,
        Set = $__11.Set,
        Symbol = $__11.Symbol;
    if (!Set || !hasNativeSymbol() || !Set.prototype[Symbol.iterator] || !Set.prototype.values) {
      return true;
    }
    try {
      return new Set([1]).size !== 1;
    } catch (e) {
      return false;
    }
  }
  function polyfillSet(global) {
    if (needsPolyfill(global)) {
      global.Set = Set;
    }
  }
  registerPolyfill(polyfillSet);
  return {
    get Set() {
      return Set;
    },
    get polyfillSet() {
      return polyfillSet;
    }
  };
});
$traceurRuntime.getModule("traceur@0.0.108/src/runtime/polyfills/Set.js" + '');
$traceurRuntime.registerModule("traceur@0.0.108/node_modules/rsvp/lib/rsvp/asap.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/node_modules/rsvp/lib/rsvp/asap.js";
  var len = 0;
  var toString = {}.toString;
  var vertxNext;
  function asap(callback, arg) {
    queue[len] = callback;
    queue[len + 1] = arg;
    len += 2;
    if (len === 2) {
      scheduleFlush();
    }
  }
  var $__default = asap;
  var browserWindow = (typeof window !== 'undefined') ? window : undefined;
  var browserGlobal = browserWindow || {};
  var BrowserMutationObserver = browserGlobal.MutationObserver || browserGlobal.WebKitMutationObserver;
  var isNode = typeof self === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';
  var isWorker = typeof Uint8ClampedArray !== 'undefined' && typeof importScripts !== 'undefined' && typeof MessageChannel !== 'undefined';
  function useNextTick() {
    var nextTick = process.nextTick;
    var version = process.versions.node.match(/^(?:(\d+)\.)?(?:(\d+)\.)?(\*|\d+)$/);
    if (Array.isArray(version) && version[1] === '0' && version[2] === '10') {
      nextTick = setImmediate;
    }
    return function() {
      nextTick(flush);
    };
  }
  function useVertxTimer() {
    return function() {
      vertxNext(flush);
    };
  }
  function useMutationObserver() {
    var iterations = 0;
    var observer = new BrowserMutationObserver(flush);
    var node = document.createTextNode('');
    observer.observe(node, {characterData: true});
    return function() {
      node.data = (iterations = ++iterations % 2);
    };
  }
  function useMessageChannel() {
    var channel = new MessageChannel();
    channel.port1.onmessage = flush;
    return function() {
      channel.port2.postMessage(0);
    };
  }
  function useSetTimeout() {
    return function() {
      setTimeout(flush, 1);
    };
  }
  var queue = new Array(1000);
  function flush() {
    for (var i = 0; i < len; i += 2) {
      var callback = queue[i];
      var arg = queue[i + 1];
      callback(arg);
      queue[i] = undefined;
      queue[i + 1] = undefined;
    }
    len = 0;
  }
  function attemptVertex() {
    try {
      var r = require;
      var vertx = r('vertx');
      vertxNext = vertx.runOnLoop || vertx.runOnContext;
      return useVertxTimer();
    } catch (e) {
      return useSetTimeout();
    }
  }
  var scheduleFlush;
  if (isNode) {
    scheduleFlush = useNextTick();
  } else if (BrowserMutationObserver) {
    scheduleFlush = useMutationObserver();
  } else if (isWorker) {
    scheduleFlush = useMessageChannel();
  } else if (browserWindow === undefined && typeof require === 'function') {
    scheduleFlush = attemptVertex();
  } else {
    scheduleFlush = useSetTimeout();
  }
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/Promise.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/Promise.js";
  var async = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../../node_modules/rsvp/lib/rsvp/asap.js", "traceur@0.0.108/src/runtime/polyfills/Promise.js")).default;
  var $__9 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/Promise.js")),
      isObject = $__9.isObject,
      registerPolyfill = $__9.registerPolyfill;
  var $__10 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../private.js", "traceur@0.0.108/src/runtime/polyfills/Promise.js")),
      createPrivateSymbol = $__10.createPrivateSymbol,
      getPrivate = $__10.getPrivate,
      setPrivate = $__10.setPrivate;
  var promiseRaw = {};
  function isPromise(x) {
    return x && typeof x === 'object' && x.status_ !== undefined;
  }
  function idResolveHandler(x) {
    return x;
  }
  function idRejectHandler(x) {
    throw x;
  }
  function chain(promise) {
    var onResolve = arguments[1] !== (void 0) ? arguments[1] : idResolveHandler;
    var onReject = arguments[2] !== (void 0) ? arguments[2] : idRejectHandler;
    var deferred = getDeferred(promise.constructor);
    switch (promise.status_) {
      case undefined:
        throw TypeError;
      case 0:
        promise.onResolve_.push(onResolve, deferred);
        promise.onReject_.push(onReject, deferred);
        break;
      case +1:
        promiseEnqueue(promise.value_, [onResolve, deferred]);
        break;
      case -1:
        promiseEnqueue(promise.value_, [onReject, deferred]);
        break;
    }
    return deferred.promise;
  }
  function getDeferred(C) {
    if (this === $Promise) {
      var promise = promiseInit(new $Promise(promiseRaw));
      return {
        promise: promise,
        resolve: function(x) {
          promiseResolve(promise, x);
        },
        reject: function(r) {
          promiseReject(promise, r);
        }
      };
    } else {
      var result = {};
      result.promise = new C(function(resolve, reject) {
        result.resolve = resolve;
        result.reject = reject;
      });
      return result;
    }
  }
  function promiseSet(promise, status, value, onResolve, onReject) {
    promise.status_ = status;
    promise.value_ = value;
    promise.onResolve_ = onResolve;
    promise.onReject_ = onReject;
    return promise;
  }
  function promiseInit(promise) {
    return promiseSet(promise, 0, undefined, [], []);
  }
  var Promise = function() {
    function Promise(resolver) {
      if (resolver === promiseRaw)
        return;
      if (typeof resolver !== 'function')
        throw new TypeError;
      var promise = promiseInit(this);
      try {
        resolver(function(x) {
          promiseResolve(promise, x);
        }, function(r) {
          promiseReject(promise, r);
        });
      } catch (e) {
        promiseReject(promise, e);
      }
    }
    return ($traceurRuntime.createClass)(Promise, {
      catch: function(onReject) {
        return this.then(undefined, onReject);
      },
      then: function(onResolve, onReject) {
        if (typeof onResolve !== 'function')
          onResolve = idResolveHandler;
        if (typeof onReject !== 'function')
          onReject = idRejectHandler;
        var that = this;
        var constructor = this.constructor;
        return chain(this, function(x) {
          x = promiseCoerce(constructor, x);
          return x === that ? onReject(new TypeError) : isPromise(x) ? x.then(onResolve, onReject) : onResolve(x);
        }, onReject);
      }
    }, {
      resolve: function(x) {
        if (this === $Promise) {
          if (isPromise(x)) {
            return x;
          }
          return promiseSet(new $Promise(promiseRaw), +1, x);
        } else {
          return new this(function(resolve, reject) {
            resolve(x);
          });
        }
      },
      reject: function(r) {
        if (this === $Promise) {
          return promiseSet(new $Promise(promiseRaw), -1, r);
        } else {
          return new this(function(resolve, reject) {
            reject(r);
          });
        }
      },
      all: function(values) {
        var deferred = getDeferred(this);
        var resolutions = [];
        try {
          var makeCountdownFunction = function(i) {
            return function(x) {
              resolutions[i] = x;
              if (--count === 0)
                deferred.resolve(resolutions);
            };
          };
          var count = 0;
          var i = 0;
          var $__4 = true;
          var $__5 = false;
          var $__6 = undefined;
          try {
            for (var $__2 = void 0,
                $__1 = (values)[Symbol.iterator](); !($__4 = ($__2 = $__1.next()).done); $__4 = true) {
              var value = $__2.value;
              {
                var countdownFunction = makeCountdownFunction(i);
                this.resolve(value).then(countdownFunction, function(r) {
                  deferred.reject(r);
                });
                ++i;
                ++count;
              }
            }
          } catch ($__7) {
            $__5 = true;
            $__6 = $__7;
          } finally {
            try {
              if (!$__4 && $__1.return != null) {
                $__1.return();
              }
            } finally {
              if ($__5) {
                throw $__6;
              }
            }
          }
          if (count === 0) {
            deferred.resolve(resolutions);
          }
        } catch (e) {
          deferred.reject(e);
        }
        return deferred.promise;
      },
      race: function(values) {
        var deferred = getDeferred(this);
        try {
          for (var i = 0; i < values.length; i++) {
            this.resolve(values[i]).then(function(x) {
              deferred.resolve(x);
            }, function(r) {
              deferred.reject(r);
            });
          }
        } catch (e) {
          deferred.reject(e);
        }
        return deferred.promise;
      }
    });
  }();
  var $Promise = Promise;
  var $PromiseReject = $Promise.reject;
  function promiseResolve(promise, x) {
    promiseDone(promise, +1, x, promise.onResolve_);
  }
  function promiseReject(promise, r) {
    promiseDone(promise, -1, r, promise.onReject_);
  }
  function promiseDone(promise, status, value, reactions) {
    if (promise.status_ !== 0)
      return;
    promiseEnqueue(value, reactions);
    promiseSet(promise, status, value);
  }
  function promiseEnqueue(value, tasks) {
    async(function() {
      for (var i = 0; i < tasks.length; i += 2) {
        promiseHandle(value, tasks[i], tasks[i + 1]);
      }
    });
  }
  function promiseHandle(value, handler, deferred) {
    try {
      var result = handler(value);
      if (result === deferred.promise)
        throw new TypeError;
      else if (isPromise(result))
        chain(result, deferred.resolve, deferred.reject);
      else
        deferred.resolve(result);
    } catch (e) {
      try {
        deferred.reject(e);
      } catch (e) {}
    }
  }
  var thenableSymbol = createPrivateSymbol();
  function promiseCoerce(constructor, x) {
    if (!isPromise(x) && isObject(x)) {
      var then;
      try {
        then = x.then;
      } catch (r) {
        var promise = $PromiseReject.call(constructor, r);
        setPrivate(x, thenableSymbol, promise);
        return promise;
      }
      if (typeof then === 'function') {
        var p = getPrivate(x, thenableSymbol);
        if (p) {
          return p;
        } else {
          var deferred = getDeferred(constructor);
          setPrivate(x, thenableSymbol, deferred.promise);
          try {
            then.call(x, deferred.resolve, deferred.reject);
          } catch (r) {
            deferred.reject(r);
          }
          return deferred.promise;
        }
      }
    }
    return x;
  }
  function polyfillPromise(global) {
    if (!global.Promise)
      global.Promise = Promise;
  }
  registerPolyfill(polyfillPromise);
  return {
    get Promise() {
      return Promise;
    },
    get polyfillPromise() {
      return polyfillPromise;
    }
  };
});
$traceurRuntime.getModule("traceur@0.0.108/src/runtime/polyfills/Promise.js" + '');
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/StringIterator.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/StringIterator.js";
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/StringIterator.js")),
      createIteratorResultObject = $__3.createIteratorResultObject,
      isObject = $__3.isObject;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var iteratedString = Symbol('iteratedString');
  var stringIteratorNextIndex = Symbol('stringIteratorNextIndex');
  var StringIterator = function() {
    var $__1;
    function StringIterator() {}
    return ($traceurRuntime.createClass)(StringIterator, ($__1 = {}, Object.defineProperty($__1, "next", {
      value: function() {
        var o = this;
        if (!isObject(o) || !hasOwnProperty.call(o, iteratedString)) {
          throw new TypeError('this must be a StringIterator object');
        }
        var s = o[iteratedString];
        if (s === undefined) {
          return createIteratorResultObject(undefined, true);
        }
        var position = o[stringIteratorNextIndex];
        var len = s.length;
        if (position >= len) {
          o[iteratedString] = undefined;
          return createIteratorResultObject(undefined, true);
        }
        var first = s.charCodeAt(position);
        var resultString;
        if (first < 0xD800 || first > 0xDBFF || position + 1 === len) {
          resultString = String.fromCharCode(first);
        } else {
          var second = s.charCodeAt(position + 1);
          if (second < 0xDC00 || second > 0xDFFF) {
            resultString = String.fromCharCode(first);
          } else {
            resultString = String.fromCharCode(first) + String.fromCharCode(second);
          }
        }
        o[stringIteratorNextIndex] = position + resultString.length;
        return createIteratorResultObject(resultString, false);
      },
      configurable: true,
      enumerable: true,
      writable: true
    }), Object.defineProperty($__1, Symbol.iterator, {
      value: function() {
        return this;
      },
      configurable: true,
      enumerable: true,
      writable: true
    }), $__1), {});
  }();
  function createStringIterator(string) {
    var s = String(string);
    var iterator = Object.create(StringIterator.prototype);
    iterator[iteratedString] = s;
    iterator[stringIteratorNextIndex] = 0;
    return iterator;
  }
  return {get createStringIterator() {
      return createStringIterator;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/String.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/String.js";
  var checkObjectCoercible = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../checkObjectCoercible.js", "traceur@0.0.108/src/runtime/polyfills/String.js")).default;
  var createStringIterator = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./StringIterator.js", "traceur@0.0.108/src/runtime/polyfills/String.js")).createStringIterator;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/String.js")),
      maybeAddFunctions = $__3.maybeAddFunctions,
      maybeAddIterator = $__3.maybeAddIterator,
      registerPolyfill = $__3.registerPolyfill;
  var $toString = Object.prototype.toString;
  var $indexOf = String.prototype.indexOf;
  var $lastIndexOf = String.prototype.lastIndexOf;
  function startsWith(search) {
    var string = String(this);
    if (this == null || $toString.call(search) == '[object RegExp]') {
      throw TypeError();
    }
    var stringLength = string.length;
    var searchString = String(search);
    var searchLength = searchString.length;
    var position = arguments.length > 1 ? arguments[1] : undefined;
    var pos = position ? Number(position) : 0;
    if (isNaN(pos)) {
      pos = 0;
    }
    var start = Math.min(Math.max(pos, 0), stringLength);
    return $indexOf.call(string, searchString, pos) == start;
  }
  function endsWith(search) {
    var string = String(this);
    if (this == null || $toString.call(search) == '[object RegExp]') {
      throw TypeError();
    }
    var stringLength = string.length;
    var searchString = String(search);
    var searchLength = searchString.length;
    var pos = stringLength;
    if (arguments.length > 1) {
      var position = arguments[1];
      if (position !== undefined) {
        pos = position ? Number(position) : 0;
        if (isNaN(pos)) {
          pos = 0;
        }
      }
    }
    var end = Math.min(Math.max(pos, 0), stringLength);
    var start = end - searchLength;
    if (start < 0) {
      return false;
    }
    return $lastIndexOf.call(string, searchString, start) == start;
  }
  function includes(search) {
    if (this == null) {
      throw TypeError();
    }
    var string = String(this);
    if (search && $toString.call(search) == '[object RegExp]') {
      throw TypeError();
    }
    var stringLength = string.length;
    var searchString = String(search);
    var searchLength = searchString.length;
    var position = arguments.length > 1 ? arguments[1] : undefined;
    var pos = position ? Number(position) : 0;
    if (pos != pos) {
      pos = 0;
    }
    var start = Math.min(Math.max(pos, 0), stringLength);
    if (searchLength + start > stringLength) {
      return false;
    }
    return $indexOf.call(string, searchString, pos) != -1;
  }
  function repeat(count) {
    if (this == null) {
      throw TypeError();
    }
    var string = String(this);
    var n = count ? Number(count) : 0;
    if (isNaN(n)) {
      n = 0;
    }
    if (n < 0 || n == Infinity) {
      throw RangeError();
    }
    if (n == 0) {
      return '';
    }
    var result = '';
    while (n--) {
      result += string;
    }
    return result;
  }
  function codePointAt(position) {
    if (this == null) {
      throw TypeError();
    }
    var string = String(this);
    var size = string.length;
    var index = position ? Number(position) : 0;
    if (isNaN(index)) {
      index = 0;
    }
    if (index < 0 || index >= size) {
      return undefined;
    }
    var first = string.charCodeAt(index);
    var second;
    if (first >= 0xD800 && first <= 0xDBFF && size > index + 1) {
      second = string.charCodeAt(index + 1);
      if (second >= 0xDC00 && second <= 0xDFFF) {
        return (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000;
      }
    }
    return first;
  }
  function raw(callsite) {
    var raw = callsite.raw;
    var len = raw.length >>> 0;
    if (len === 0)
      return '';
    var s = '';
    var i = 0;
    while (true) {
      s += raw[i];
      if (i + 1 === len)
        return s;
      s += arguments[++i];
    }
  }
  function fromCodePoint(_) {
    var codeUnits = [];
    var floor = Math.floor;
    var highSurrogate;
    var lowSurrogate;
    var index = -1;
    var length = arguments.length;
    if (!length) {
      return '';
    }
    while (++index < length) {
      var codePoint = Number(arguments[index]);
      if (!isFinite(codePoint) || codePoint < 0 || codePoint > 0x10FFFF || floor(codePoint) != codePoint) {
        throw RangeError('Invalid code point: ' + codePoint);
      }
      if (codePoint <= 0xFFFF) {
        codeUnits.push(codePoint);
      } else {
        codePoint -= 0x10000;
        highSurrogate = (codePoint >> 10) + 0xD800;
        lowSurrogate = (codePoint % 0x400) + 0xDC00;
        codeUnits.push(highSurrogate, lowSurrogate);
      }
    }
    return String.fromCharCode.apply(null, codeUnits);
  }
  function stringPrototypeIterator() {
    var o = checkObjectCoercible(this);
    var s = String(o);
    return createStringIterator(s);
  }
  function polyfillString(global) {
    var String = global.String;
    maybeAddFunctions(String.prototype, ['codePointAt', codePointAt, 'endsWith', endsWith, 'includes', includes, 'repeat', repeat, 'startsWith', startsWith]);
    maybeAddFunctions(String, ['fromCodePoint', fromCodePoint, 'raw', raw]);
    maybeAddIterator(String.prototype, stringPrototypeIterator, Symbol);
  }
  registerPolyfill(polyfillString);
  return {
    get startsWith() {
      return startsWith;
    },
    get endsWith() {
      return endsWith;
    },
    get includes() {
      return includes;
    },
    get repeat() {
      return repeat;
    },
    get codePointAt() {
      return codePointAt;
    },
    get raw() {
      return raw;
    },
    get fromCodePoint() {
      return fromCodePoint;
    },
    get stringPrototypeIterator() {
      return stringPrototypeIterator;
    },
    get polyfillString() {
      return polyfillString;
    }
  };
});
$traceurRuntime.getModule("traceur@0.0.108/src/runtime/polyfills/String.js" + '');
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/ArrayIterator.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/ArrayIterator.js";
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/ArrayIterator.js")),
      toObject = $__2.toObject,
      toUint32 = $__2.toUint32,
      createIteratorResultObject = $__2.createIteratorResultObject;
  var ARRAY_ITERATOR_KIND_KEYS = 1;
  var ARRAY_ITERATOR_KIND_VALUES = 2;
  var ARRAY_ITERATOR_KIND_ENTRIES = 3;
  var ArrayIterator = function() {
    var $__1;
    function ArrayIterator() {}
    return ($traceurRuntime.createClass)(ArrayIterator, ($__1 = {}, Object.defineProperty($__1, "next", {
      value: function() {
        var iterator = toObject(this);
        var array = iterator.iteratorObject_;
        if (!array) {
          throw new TypeError('Object is not an ArrayIterator');
        }
        var index = iterator.arrayIteratorNextIndex_;
        var itemKind = iterator.arrayIterationKind_;
        var length = toUint32(array.length);
        if (index >= length) {
          iterator.arrayIteratorNextIndex_ = Infinity;
          return createIteratorResultObject(undefined, true);
        }
        iterator.arrayIteratorNextIndex_ = index + 1;
        if (itemKind == ARRAY_ITERATOR_KIND_VALUES)
          return createIteratorResultObject(array[index], false);
        if (itemKind == ARRAY_ITERATOR_KIND_ENTRIES)
          return createIteratorResultObject([index, array[index]], false);
        return createIteratorResultObject(index, false);
      },
      configurable: true,
      enumerable: true,
      writable: true
    }), Object.defineProperty($__1, Symbol.iterator, {
      value: function() {
        return this;
      },
      configurable: true,
      enumerable: true,
      writable: true
    }), $__1), {});
  }();
  function createArrayIterator(array, kind) {
    var object = toObject(array);
    var iterator = new ArrayIterator;
    iterator.iteratorObject_ = object;
    iterator.arrayIteratorNextIndex_ = 0;
    iterator.arrayIterationKind_ = kind;
    return iterator;
  }
  function entries() {
    return createArrayIterator(this, ARRAY_ITERATOR_KIND_ENTRIES);
  }
  function keys() {
    return createArrayIterator(this, ARRAY_ITERATOR_KIND_KEYS);
  }
  function values() {
    return createArrayIterator(this, ARRAY_ITERATOR_KIND_VALUES);
  }
  return {
    get entries() {
      return entries;
    },
    get keys() {
      return keys;
    },
    get values() {
      return values;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/Array.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/Array.js";
  var $__9 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ArrayIterator.js", "traceur@0.0.108/src/runtime/polyfills/Array.js")),
      entries = $__9.entries,
      keys = $__9.keys,
      jsValues = $__9.values;
  var $__10 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/Array.js")),
      checkIterable = $__10.checkIterable,
      isCallable = $__10.isCallable,
      isConstructor = $__10.isConstructor,
      maybeAddFunctions = $__10.maybeAddFunctions,
      maybeAddIterator = $__10.maybeAddIterator,
      registerPolyfill = $__10.registerPolyfill,
      toInteger = $__10.toInteger,
      toLength = $__10.toLength,
      toObject = $__10.toObject;
  function from(arrLike) {
    var mapFn = arguments[1];
    var thisArg = arguments[2];
    var C = this;
    var items = toObject(arrLike);
    var mapping = mapFn !== undefined;
    var k = 0;
    var arr,
        len;
    if (mapping && !isCallable(mapFn)) {
      throw TypeError();
    }
    if (checkIterable(items)) {
      arr = isConstructor(C) ? new C() : [];
      var $__3 = true;
      var $__4 = false;
      var $__5 = undefined;
      try {
        for (var $__1 = void 0,
            $__0 = (items)[Symbol.iterator](); !($__3 = ($__1 = $__0.next()).done); $__3 = true) {
          var item = $__1.value;
          {
            if (mapping) {
              arr[k] = mapFn.call(thisArg, item, k);
            } else {
              arr[k] = item;
            }
            k++;
          }
        }
      } catch ($__6) {
        $__4 = true;
        $__5 = $__6;
      } finally {
        try {
          if (!$__3 && $__0.return != null) {
            $__0.return();
          }
        } finally {
          if ($__4) {
            throw $__5;
          }
        }
      }
      arr.length = k;
      return arr;
    }
    len = toLength(items.length);
    arr = isConstructor(C) ? new C(len) : new Array(len);
    for (; k < len; k++) {
      if (mapping) {
        arr[k] = typeof thisArg === 'undefined' ? mapFn(items[k], k) : mapFn.call(thisArg, items[k], k);
      } else {
        arr[k] = items[k];
      }
    }
    arr.length = len;
    return arr;
  }
  function of() {
    for (var items = [],
        $__7 = 0; $__7 < arguments.length; $__7++)
      items[$__7] = arguments[$__7];
    var C = this;
    var len = items.length;
    var arr = isConstructor(C) ? new C(len) : new Array(len);
    for (var k = 0; k < len; k++) {
      arr[k] = items[k];
    }
    arr.length = len;
    return arr;
  }
  function fill(value) {
    var start = arguments[1] !== (void 0) ? arguments[1] : 0;
    var end = arguments[2];
    var object = toObject(this);
    var len = toLength(object.length);
    var fillStart = toInteger(start);
    var fillEnd = end !== undefined ? toInteger(end) : len;
    fillStart = fillStart < 0 ? Math.max(len + fillStart, 0) : Math.min(fillStart, len);
    fillEnd = fillEnd < 0 ? Math.max(len + fillEnd, 0) : Math.min(fillEnd, len);
    while (fillStart < fillEnd) {
      object[fillStart] = value;
      fillStart++;
    }
    return object;
  }
  function find(predicate) {
    var thisArg = arguments[1];
    return findHelper(this, predicate, thisArg);
  }
  function findIndex(predicate) {
    var thisArg = arguments[1];
    return findHelper(this, predicate, thisArg, true);
  }
  function findHelper(self, predicate) {
    var thisArg = arguments[2];
    var returnIndex = arguments[3] !== (void 0) ? arguments[3] : false;
    var object = toObject(self);
    var len = toLength(object.length);
    if (!isCallable(predicate)) {
      throw TypeError();
    }
    for (var i = 0; i < len; i++) {
      var value = object[i];
      if (predicate.call(thisArg, value, i, object)) {
        return returnIndex ? i : value;
      }
    }
    return returnIndex ? -1 : undefined;
  }
  function polyfillArray(global) {
    var $__8 = global,
        Array = $__8.Array,
        Object = $__8.Object,
        Symbol = $__8.Symbol;
    var values = jsValues;
    if (Symbol && Symbol.iterator && Array.prototype[Symbol.iterator]) {
      values = Array.prototype[Symbol.iterator];
    }
    maybeAddFunctions(Array.prototype, ['entries', entries, 'keys', keys, 'values', values, 'fill', fill, 'find', find, 'findIndex', findIndex]);
    maybeAddFunctions(Array, ['from', from, 'of', of]);
    maybeAddIterator(Array.prototype, values, Symbol);
    maybeAddIterator(Object.getPrototypeOf([].values()), function() {
      return this;
    }, Symbol);
  }
  registerPolyfill(polyfillArray);
  return {
    get from() {
      return from;
    },
    get of() {
      return of;
    },
    get fill() {
      return fill;
    },
    get find() {
      return find;
    },
    get findIndex() {
      return findIndex;
    },
    get polyfillArray() {
      return polyfillArray;
    }
  };
});
$traceurRuntime.getModule("traceur@0.0.108/src/runtime/polyfills/Array.js" + '');
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/assign.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/assign.js";
  var keys = Object.keys;
  function assign(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      var props = source == null ? [] : keys(source);
      var p = void 0,
          length = props.length;
      for (p = 0; p < length; p++) {
        var name = props[p];
        target[name] = source[name];
      }
    }
    return target;
  }
  var $__default = assign;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/Object.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/Object.js";
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/Object.js")),
      maybeAddFunctions = $__2.maybeAddFunctions,
      registerPolyfill = $__2.registerPolyfill;
  var assign = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./assign.js", "traceur@0.0.108/src/runtime/polyfills/Object.js")).default;
  var $__0 = Object,
      defineProperty = $__0.defineProperty,
      getOwnPropertyDescriptor = $__0.getOwnPropertyDescriptor,
      getOwnPropertyNames = $__0.getOwnPropertyNames;
  function is(left, right) {
    if (left === right)
      return left !== 0 || 1 / left === 1 / right;
    return left !== left && right !== right;
  }
  function mixin(target, source) {
    var props = getOwnPropertyNames(source);
    var p,
        descriptor,
        length = props.length;
    for (p = 0; p < length; p++) {
      var name = props[p];
      descriptor = getOwnPropertyDescriptor(source, props[p]);
      defineProperty(target, props[p], descriptor);
    }
    return target;
  }
  function polyfillObject(global) {
    var Object = global.Object;
    maybeAddFunctions(Object, ['assign', assign, 'is', is, 'mixin', mixin]);
  }
  registerPolyfill(polyfillObject);
  return {
    get assign() {
      return assign;
    },
    get is() {
      return is;
    },
    get mixin() {
      return mixin;
    },
    get polyfillObject() {
      return polyfillObject;
    }
  };
});
$traceurRuntime.getModule("traceur@0.0.108/src/runtime/polyfills/Object.js" + '');
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/Number.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/Number.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/Number.js")),
      isNumber = $__1.isNumber,
      maybeAddConsts = $__1.maybeAddConsts,
      maybeAddFunctions = $__1.maybeAddFunctions,
      registerPolyfill = $__1.registerPolyfill,
      toInteger = $__1.toInteger;
  var $abs = Math.abs;
  var $isFinite = isFinite;
  var $isNaN = isNaN;
  var MAX_SAFE_INTEGER = Math.pow(2, 53) - 1;
  var MIN_SAFE_INTEGER = -Math.pow(2, 53) + 1;
  var EPSILON = Math.pow(2, -52);
  function NumberIsFinite(number) {
    return isNumber(number) && $isFinite(number);
  }
  function isInteger(number) {
    return NumberIsFinite(number) && toInteger(number) === number;
  }
  function NumberIsNaN(number) {
    return isNumber(number) && $isNaN(number);
  }
  function isSafeInteger(number) {
    if (NumberIsFinite(number)) {
      var integral = toInteger(number);
      if (integral === number)
        return $abs(integral) <= MAX_SAFE_INTEGER;
    }
    return false;
  }
  function polyfillNumber(global) {
    var Number = global.Number;
    maybeAddConsts(Number, ['MAX_SAFE_INTEGER', MAX_SAFE_INTEGER, 'MIN_SAFE_INTEGER', MIN_SAFE_INTEGER, 'EPSILON', EPSILON]);
    maybeAddFunctions(Number, ['isFinite', NumberIsFinite, 'isInteger', isInteger, 'isNaN', NumberIsNaN, 'isSafeInteger', isSafeInteger]);
  }
  registerPolyfill(polyfillNumber);
  return {
    get MAX_SAFE_INTEGER() {
      return MAX_SAFE_INTEGER;
    },
    get MIN_SAFE_INTEGER() {
      return MIN_SAFE_INTEGER;
    },
    get EPSILON() {
      return EPSILON;
    },
    get isFinite() {
      return NumberIsFinite;
    },
    get isInteger() {
      return isInteger;
    },
    get isNaN() {
      return NumberIsNaN;
    },
    get isSafeInteger() {
      return isSafeInteger;
    },
    get polyfillNumber() {
      return polyfillNumber;
    }
  };
});
$traceurRuntime.getModule("traceur@0.0.108/src/runtime/polyfills/Number.js" + '');
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/fround.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/fround.js";
  var $isFinite = isFinite;
  var $isNaN = isNaN;
  var $__0 = Math,
      LN2 = $__0.LN2,
      abs = $__0.abs,
      floor = $__0.floor,
      log = $__0.log,
      min = $__0.min,
      pow = $__0.pow;
  function packIEEE754(v, ebits, fbits) {
    var bias = (1 << (ebits - 1)) - 1,
        s,
        e,
        f,
        ln,
        i,
        bits,
        str,
        bytes;
    function roundToEven(n) {
      var w = floor(n),
          f = n - w;
      if (f < 0.5)
        return w;
      if (f > 0.5)
        return w + 1;
      return w % 2 ? w + 1 : w;
    }
    if (v !== v) {
      e = (1 << ebits) - 1;
      f = pow(2, fbits - 1);
      s = 0;
    } else if (v === Infinity || v === -Infinity) {
      e = (1 << ebits) - 1;
      f = 0;
      s = (v < 0) ? 1 : 0;
    } else if (v === 0) {
      e = 0;
      f = 0;
      s = (1 / v === -Infinity) ? 1 : 0;
    } else {
      s = v < 0;
      v = abs(v);
      if (v >= pow(2, 1 - bias)) {
        e = min(floor(log(v) / LN2), 1023);
        f = roundToEven(v / pow(2, e) * pow(2, fbits));
        if (f / pow(2, fbits) >= 2) {
          e = e + 1;
          f = 1;
        }
        if (e > bias) {
          e = (1 << ebits) - 1;
          f = 0;
        } else {
          e = e + bias;
          f = f - pow(2, fbits);
        }
      } else {
        e = 0;
        f = roundToEven(v / pow(2, 1 - bias - fbits));
      }
    }
    bits = [];
    for (i = fbits; i; i -= 1) {
      bits.push(f % 2 ? 1 : 0);
      f = floor(f / 2);
    }
    for (i = ebits; i; i -= 1) {
      bits.push(e % 2 ? 1 : 0);
      e = floor(e / 2);
    }
    bits.push(s ? 1 : 0);
    bits.reverse();
    str = bits.join('');
    bytes = [];
    while (str.length) {
      bytes.push(parseInt(str.substring(0, 8), 2));
      str = str.substring(8);
    }
    return bytes;
  }
  function unpackIEEE754(bytes, ebits, fbits) {
    var bits = [],
        i,
        j,
        b,
        str,
        bias,
        s,
        e,
        f;
    for (i = bytes.length; i; i -= 1) {
      b = bytes[i - 1];
      for (j = 8; j; j -= 1) {
        bits.push(b % 2 ? 1 : 0);
        b = b >> 1;
      }
    }
    bits.reverse();
    str = bits.join('');
    bias = (1 << (ebits - 1)) - 1;
    s = parseInt(str.substring(0, 1), 2) ? -1 : 1;
    e = parseInt(str.substring(1, 1 + ebits), 2);
    f = parseInt(str.substring(1 + ebits), 2);
    if (e === (1 << ebits) - 1) {
      return f !== 0 ? NaN : s * Infinity;
    } else if (e > 0) {
      return s * pow(2, e - bias) * (1 + f / pow(2, fbits));
    } else if (f !== 0) {
      return s * pow(2, -(bias - 1)) * (f / pow(2, fbits));
    } else {
      return s < 0 ? -0 : 0;
    }
  }
  function unpackF32(b) {
    return unpackIEEE754(b, 8, 23);
  }
  function packF32(v) {
    return packIEEE754(v, 8, 23);
  }
  function fround(x) {
    if (x === 0 || !$isFinite(x) || $isNaN(x)) {
      return x;
    }
    return unpackF32(packF32(Number(x)));
  }
  return {get fround() {
      return fround;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/Math.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/Math.js";
  var jsFround = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./fround.js", "traceur@0.0.108/src/runtime/polyfills/Math.js")).fround;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/Math.js")),
      maybeAddFunctions = $__3.maybeAddFunctions,
      registerPolyfill = $__3.registerPolyfill,
      toUint32 = $__3.toUint32;
  var $isFinite = isFinite;
  var $isNaN = isNaN;
  var $__0 = Math,
      abs = $__0.abs,
      ceil = $__0.ceil,
      exp = $__0.exp,
      floor = $__0.floor,
      log = $__0.log,
      pow = $__0.pow,
      sqrt = $__0.sqrt;
  function clz32(x) {
    x = toUint32(+x);
    if (x == 0)
      return 32;
    var result = 0;
    if ((x & 0xFFFF0000) === 0) {
      x <<= 16;
      result += 16;
    }
    ;
    if ((x & 0xFF000000) === 0) {
      x <<= 8;
      result += 8;
    }
    ;
    if ((x & 0xF0000000) === 0) {
      x <<= 4;
      result += 4;
    }
    ;
    if ((x & 0xC0000000) === 0) {
      x <<= 2;
      result += 2;
    }
    ;
    if ((x & 0x80000000) === 0) {
      x <<= 1;
      result += 1;
    }
    ;
    return result;
  }
  function imul(x, y) {
    x = toUint32(+x);
    y = toUint32(+y);
    var xh = (x >>> 16) & 0xffff;
    var xl = x & 0xffff;
    var yh = (y >>> 16) & 0xffff;
    var yl = y & 0xffff;
    return xl * yl + (((xh * yl + xl * yh) << 16) >>> 0) | 0;
  }
  function sign(x) {
    x = +x;
    if (x > 0)
      return 1;
    if (x < 0)
      return -1;
    return x;
  }
  function log10(x) {
    return log(x) * 0.434294481903251828;
  }
  function log2(x) {
    return log(x) * 1.442695040888963407;
  }
  function log1p(x) {
    x = +x;
    if (x < -1 || $isNaN(x)) {
      return NaN;
    }
    if (x === 0 || x === Infinity) {
      return x;
    }
    if (x === -1) {
      return -Infinity;
    }
    var result = 0;
    var n = 50;
    if (x < 0 || x > 1) {
      return log(1 + x);
    }
    for (var i = 1; i < n; i++) {
      if ((i % 2) === 0) {
        result -= pow(x, i) / i;
      } else {
        result += pow(x, i) / i;
      }
    }
    return result;
  }
  function expm1(x) {
    x = +x;
    if (x === -Infinity) {
      return -1;
    }
    if (!$isFinite(x) || x === 0) {
      return x;
    }
    return exp(x) - 1;
  }
  function cosh(x) {
    x = +x;
    if (x === 0) {
      return 1;
    }
    if ($isNaN(x)) {
      return NaN;
    }
    if (!$isFinite(x)) {
      return Infinity;
    }
    if (x < 0) {
      x = -x;
    }
    if (x > 21) {
      return exp(x) / 2;
    }
    return (exp(x) + exp(-x)) / 2;
  }
  function sinh(x) {
    x = +x;
    if (!$isFinite(x) || x === 0) {
      return x;
    }
    return (exp(x) - exp(-x)) / 2;
  }
  function tanh(x) {
    x = +x;
    if (x === 0)
      return x;
    if (!$isFinite(x))
      return sign(x);
    var exp1 = exp(x);
    var exp2 = exp(-x);
    return (exp1 - exp2) / (exp1 + exp2);
  }
  function acosh(x) {
    x = +x;
    if (x < 1)
      return NaN;
    if (!$isFinite(x))
      return x;
    return log(x + sqrt(x + 1) * sqrt(x - 1));
  }
  function asinh(x) {
    x = +x;
    if (x === 0 || !$isFinite(x))
      return x;
    if (x > 0)
      return log(x + sqrt(x * x + 1));
    return -log(-x + sqrt(x * x + 1));
  }
  function atanh(x) {
    x = +x;
    if (x === -1) {
      return -Infinity;
    }
    if (x === 1) {
      return Infinity;
    }
    if (x === 0) {
      return x;
    }
    if ($isNaN(x) || x < -1 || x > 1) {
      return NaN;
    }
    return 0.5 * log((1 + x) / (1 - x));
  }
  function hypot(x, y) {
    var length = arguments.length;
    var args = new Array(length);
    var max = 0;
    for (var i = 0; i < length; i++) {
      var n = arguments[i];
      n = +n;
      if (n === Infinity || n === -Infinity)
        return Infinity;
      n = abs(n);
      if (n > max)
        max = n;
      args[i] = n;
    }
    if (max === 0)
      max = 1;
    var sum = 0;
    var compensation = 0;
    for (var i = 0; i < length; i++) {
      var n = args[i] / max;
      var summand = n * n - compensation;
      var preliminary = sum + summand;
      compensation = (preliminary - sum) - summand;
      sum = preliminary;
    }
    return sqrt(sum) * max;
  }
  function trunc(x) {
    x = +x;
    if (x > 0)
      return floor(x);
    if (x < 0)
      return ceil(x);
    return x;
  }
  var fround,
      f32;
  if (typeof Float32Array === 'function') {
    f32 = new Float32Array(1);
    fround = function(x) {
      f32[0] = Number(x);
      return f32[0];
    };
  } else {
    fround = jsFround;
  }
  function cbrt(x) {
    x = +x;
    if (x === 0)
      return x;
    var negate = x < 0;
    if (negate)
      x = -x;
    var result = pow(x, 1 / 3);
    return negate ? -result : result;
  }
  function polyfillMath(global) {
    var Math = global.Math;
    maybeAddFunctions(Math, ['acosh', acosh, 'asinh', asinh, 'atanh', atanh, 'cbrt', cbrt, 'clz32', clz32, 'cosh', cosh, 'expm1', expm1, 'fround', fround, 'hypot', hypot, 'imul', imul, 'log10', log10, 'log1p', log1p, 'log2', log2, 'sign', sign, 'sinh', sinh, 'tanh', tanh, 'trunc', trunc]);
  }
  registerPolyfill(polyfillMath);
  return {
    get clz32() {
      return clz32;
    },
    get imul() {
      return imul;
    },
    get sign() {
      return sign;
    },
    get log10() {
      return log10;
    },
    get log2() {
      return log2;
    },
    get log1p() {
      return log1p;
    },
    get expm1() {
      return expm1;
    },
    get cosh() {
      return cosh;
    },
    get sinh() {
      return sinh;
    },
    get tanh() {
      return tanh;
    },
    get acosh() {
      return acosh;
    },
    get asinh() {
      return asinh;
    },
    get atanh() {
      return atanh;
    },
    get hypot() {
      return hypot;
    },
    get trunc() {
      return trunc;
    },
    get fround() {
      return fround;
    },
    get cbrt() {
      return cbrt;
    },
    get polyfillMath() {
      return polyfillMath;
    }
  };
});
$traceurRuntime.getModule("traceur@0.0.108/src/runtime/polyfills/Math.js" + '');
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/WeakMap.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/WeakMap.js";
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../private.js", "traceur@0.0.108/src/runtime/polyfills/WeakMap.js")),
      createPrivateSymbol = $__5.createPrivateSymbol,
      deletePrivate = $__5.deletePrivate,
      getPrivate = $__5.getPrivate,
      hasPrivate = $__5.hasPrivate,
      setPrivate = $__5.setPrivate;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../frozen-data.js", "traceur@0.0.108/src/runtime/polyfills/WeakMap.js")),
      deleteFrozen = $__6.deleteFrozen,
      getFrozen = $__6.getFrozen,
      hasFrozen = $__6.hasFrozen,
      setFrozen = $__6.setFrozen;
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/WeakMap.js")),
      isObject = $__7.isObject,
      registerPolyfill = $__7.registerPolyfill;
  var hasNativeSymbol = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../has-native-symbols.js", "traceur@0.0.108/src/runtime/polyfills/WeakMap.js")).default;
  var $__2 = Object,
      defineProperty = $__2.defineProperty,
      getOwnPropertyDescriptor = $__2.getOwnPropertyDescriptor,
      isExtensible = $__2.isExtensible;
  var $TypeError = TypeError;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var sentinel = {};
  var WeakMap = function() {
    function WeakMap() {
      this.name_ = createPrivateSymbol();
      this.frozenData_ = [];
    }
    return ($traceurRuntime.createClass)(WeakMap, {
      set: function(key, value) {
        if (!isObject(key))
          throw new $TypeError('key must be an object');
        if (!isExtensible(key)) {
          setFrozen(this.frozenData_, key, value);
        } else {
          setPrivate(key, this.name_, value);
        }
        return this;
      },
      get: function(key) {
        if (!isObject(key))
          return undefined;
        if (!isExtensible(key)) {
          return getFrozen(this.frozenData_, key);
        }
        return getPrivate(key, this.name_);
      },
      delete: function(key) {
        if (!isObject(key))
          return false;
        if (!isExtensible(key)) {
          return deleteFrozen(this.frozenData_, key);
        }
        return deletePrivate(key, this.name_);
      },
      has: function(key) {
        if (!isObject(key))
          return false;
        if (!isExtensible(key)) {
          return hasFrozen(this.frozenData_, key);
        }
        return hasPrivate(key, this.name_);
      }
    }, {});
  }();
  function needsPolyfill(global) {
    var $__4 = global,
        WeakMap = $__4.WeakMap,
        Symbol = $__4.Symbol;
    if (!WeakMap || !hasNativeSymbol()) {
      return true;
    }
    try {
      var o = {};
      var wm = new WeakMap([[o, false]]);
      return wm.get(o);
    } catch (e) {
      return false;
    }
  }
  function polyfillWeakMap(global) {
    if (needsPolyfill(global)) {
      global.WeakMap = WeakMap;
    }
  }
  registerPolyfill(polyfillWeakMap);
  return {
    get WeakMap() {
      return WeakMap;
    },
    get polyfillWeakMap() {
      return polyfillWeakMap;
    }
  };
});
$traceurRuntime.getModule("traceur@0.0.108/src/runtime/polyfills/WeakMap.js" + '');
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/WeakSet.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/WeakSet.js";
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../private.js", "traceur@0.0.108/src/runtime/polyfills/WeakSet.js")),
      createPrivateSymbol = $__5.createPrivateSymbol,
      deletePrivate = $__5.deletePrivate,
      getPrivate = $__5.getPrivate,
      hasPrivate = $__5.hasPrivate,
      setPrivate = $__5.setPrivate;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../frozen-data.js", "traceur@0.0.108/src/runtime/polyfills/WeakSet.js")),
      deleteFrozen = $__6.deleteFrozen,
      getFrozen = $__6.getFrozen,
      setFrozen = $__6.setFrozen;
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/WeakSet.js")),
      isObject = $__7.isObject,
      registerPolyfill = $__7.registerPolyfill;
  var hasNativeSymbol = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../has-native-symbols.js", "traceur@0.0.108/src/runtime/polyfills/WeakSet.js")).default;
  var $__2 = Object,
      defineProperty = $__2.defineProperty,
      isExtensible = $__2.isExtensible;
  var $TypeError = TypeError;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var WeakSet = function() {
    function WeakSet() {
      this.name_ = createPrivateSymbol();
      this.frozenData_ = [];
    }
    return ($traceurRuntime.createClass)(WeakSet, {
      add: function(value) {
        if (!isObject(value))
          throw new $TypeError('value must be an object');
        if (!isExtensible(value)) {
          setFrozen(this.frozenData_, value, value);
        } else {
          setPrivate(value, this.name_, true);
        }
        return this;
      },
      delete: function(value) {
        if (!isObject(value))
          return false;
        if (!isExtensible(value)) {
          return deleteFrozen(this.frozenData_, value);
        }
        return deletePrivate(value, this.name_);
      },
      has: function(value) {
        if (!isObject(value))
          return false;
        if (!isExtensible(value)) {
          return getFrozen(this.frozenData_, value) === value;
        }
        return hasPrivate(value, this.name_);
      }
    }, {});
  }();
  function needsPolyfill(global) {
    var $__4 = global,
        WeakSet = $__4.WeakSet,
        Symbol = $__4.Symbol;
    if (!WeakSet || !hasNativeSymbol()) {
      return true;
    }
    try {
      var o = {};
      var wm = new WeakSet([[o]]);
      return !wm.has(o);
    } catch (e) {
      return false;
    }
  }
  function polyfillWeakSet(global) {
    if (needsPolyfill(global)) {
      global.WeakSet = WeakSet;
    }
  }
  registerPolyfill(polyfillWeakSet);
  return {
    get WeakSet() {
      return WeakSet;
    },
    get polyfillWeakSet() {
      return polyfillWeakSet;
    }
  };
});
$traceurRuntime.getModule("traceur@0.0.108/src/runtime/polyfills/WeakSet.js" + '');
$traceurRuntime.registerModule("traceur@0.0.108/src/runtime/polyfills/polyfills.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/runtime/polyfills/polyfills.js";
  var polyfillAll = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./utils.js", "traceur@0.0.108/src/runtime/polyfills/polyfills.js")).polyfillAll;
  polyfillAll(Reflect.global);
  var setupGlobals = $traceurRuntime.setupGlobals;
  $traceurRuntime.setupGlobals = function(global) {
    setupGlobals(global);
    polyfillAll(global);
  };
  return {};
});
$traceurRuntime.getModule("traceur@0.0.108/src/runtime/polyfills/polyfills.js" + '');
$traceurRuntime.registerModule("traceur@0.0.108/src/util/SourceRange.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/util/SourceRange.js";
  var SourceRange = function() {
    function SourceRange(start, end) {
      this.start = start;
      this.end = end;
    }
    return ($traceurRuntime.createClass)(SourceRange, {toString: function() {
        var str = this.start.source.contents;
        return str.slice(this.start.offset, this.end.offset);
      }}, {});
  }();
  return {get SourceRange() {
      return SourceRange;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/util/ErrorReporter.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/util/ErrorReporter.js";
  var SourceRange = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./SourceRange.js", "traceur@0.0.108/src/util/ErrorReporter.js")).SourceRange;
  var ErrorReporter = function() {
    function ErrorReporter() {
      this.hadError_ = false;
    }
    return ($traceurRuntime.createClass)(ErrorReporter, {
      reportError: function(location, message) {
        this.hadError_ = true;
        this.reportMessageInternal(location, message);
      },
      reportMessageInternal: function(location, message) {
        if (location)
          message = (location.start + ": " + message);
        console.error(message);
      },
      hadError: function() {
        return this.hadError_;
      },
      clearError: function() {
        this.hadError_ = false;
      }
    }, {});
  }();
  function format(location, text) {
    var args = arguments[2];
    var i = 0;
    text = text.replace(/%./g, function(s) {
      switch (s) {
        case '%s':
          return args && args[i++];
        case '%%':
          return '%';
      }
      return s;
    });
    if (location)
      text = (location + ": " + text);
    return text;
  }
  ;
  ErrorReporter.format = format;
  return {
    get ErrorReporter() {
      return ErrorReporter;
    },
    get format() {
      return format;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/util/MutedErrorReporter.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/util/MutedErrorReporter.js";
  var ErrorReporter = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ErrorReporter.js", "traceur@0.0.108/src/util/MutedErrorReporter.js")).ErrorReporter;
  var MutedErrorReporter = function($__super) {
    function MutedErrorReporter() {
      $traceurRuntime.superConstructor(MutedErrorReporter).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(MutedErrorReporter, {reportMessageInternal: function(location, format, args) {}}, {}, $__super);
  }(ErrorReporter);
  return {get MutedErrorReporter() {
      return MutedErrorReporter;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/Options.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/Options.js";
  function enumerableOnlyObject(obj) {
    var result = Object.create(null);
    Object.keys(obj).forEach(function(key) {
      Object.defineProperty(result, key, {
        enumerable: true,
        value: obj[key]
      });
    });
    return result;
  }
  var optionsV01 = enumerableOnlyObject({
    annotations: false,
    arrayComprehension: false,
    arrowFunctions: true,
    asyncFunctions: false,
    asyncGenerators: false,
    blockBinding: true,
    classes: true,
    commentCallback: false,
    computedPropertyNames: true,
    debug: false,
    debugNames: false,
    defaultParameters: true,
    destructuring: true,
    exponentiation: false,
    exportFromExtended: false,
    forOf: true,
    forOn: false,
    freeVariableChecker: false,
    generatorComprehension: false,
    generators: true,
    inputSourceMap: false,
    jsx: false,
    lowResolutionSourceMap: false,
    memberVariables: false,
    moduleName: 'default',
    modules: 'bootstrap',
    numericLiterals: true,
    outputLanguage: 'es5',
    properTailCalls: false,
    propertyMethods: true,
    propertyNameShorthand: true,
    referrer: '',
    require: false,
    restParameters: true,
    script: false,
    sourceMaps: false,
    sourceRoot: false,
    spread: true,
    spreadProperties: false,
    symbols: true,
    templateLiterals: true,
    types: false,
    unicodeEscapeSequences: true,
    unicodeExpressions: true,
    validate: false
  });
  var versionLockedOptions = optionsV01;
  var defaultValues = Object.create(null);
  var featureOptions = Object.create(null);
  var experimentalOptions = Object.create(null);
  var moduleOptions = ['amd', 'commonjs', 'closure', 'instantiate', 'inline', 'bootstrap', 'parse'];
  var EXPERIMENTAL = 0;
  var ON_BY_DEFAULT = 1;
  function addFeatureOption(name, kind) {
    featureOptions[name] = true;
    if (kind === EXPERIMENTAL)
      experimentalOptions[name] = true;
    var defaultValue = kind === ON_BY_DEFAULT;
    defaultValues[name] = defaultValue;
  }
  function addBoolOption(name) {
    defaultValues[name] = false;
  }
  addFeatureOption('arrowFunctions', ON_BY_DEFAULT);
  addFeatureOption('blockBinding', ON_BY_DEFAULT);
  addFeatureOption('classes', ON_BY_DEFAULT);
  addFeatureOption('computedPropertyNames', ON_BY_DEFAULT);
  addFeatureOption('defaultParameters', ON_BY_DEFAULT);
  addFeatureOption('destructuring', ON_BY_DEFAULT);
  addFeatureOption('forOf', ON_BY_DEFAULT);
  addFeatureOption('generators', ON_BY_DEFAULT);
  addFeatureOption('modules', 'SPECIAL');
  addFeatureOption('numericLiterals', ON_BY_DEFAULT);
  addFeatureOption('propertyMethods', ON_BY_DEFAULT);
  addFeatureOption('propertyNameShorthand', ON_BY_DEFAULT);
  addFeatureOption('restParameters', ON_BY_DEFAULT);
  addFeatureOption('sourceMaps', 'SPECIAL');
  addFeatureOption('spread', ON_BY_DEFAULT);
  addFeatureOption('symbols', ON_BY_DEFAULT);
  addFeatureOption('templateLiterals', ON_BY_DEFAULT);
  addFeatureOption('unicodeEscapeSequences', ON_BY_DEFAULT);
  addFeatureOption('unicodeExpressions', ON_BY_DEFAULT);
  addFeatureOption('properTailCalls', EXPERIMENTAL);
  addFeatureOption('annotations', EXPERIMENTAL);
  addFeatureOption('arrayComprehension', EXPERIMENTAL);
  addFeatureOption('asyncFunctions', EXPERIMENTAL);
  addFeatureOption('asyncGenerators', EXPERIMENTAL);
  addFeatureOption('exponentiation', EXPERIMENTAL);
  addFeatureOption('exportFromExtended', EXPERIMENTAL);
  addFeatureOption('forOn', EXPERIMENTAL);
  addFeatureOption('generatorComprehension', EXPERIMENTAL);
  addFeatureOption('jsx', EXPERIMENTAL);
  addFeatureOption('memberVariables', EXPERIMENTAL);
  addFeatureOption('require', EXPERIMENTAL);
  addFeatureOption('spreadProperties', EXPERIMENTAL);
  addFeatureOption('types', EXPERIMENTAL);
  var transformOptionsPrototype = {};
  Object.keys(featureOptions).forEach(function(name) {
    Object.defineProperty(transformOptionsPrototype, name, {
      get: function() {
        var v = this.proxiedOptions_[name];
        if (v === 'parse')
          return false;
        return v;
      },
      enumerable: true
    });
  });
  var parseOptionsPrototype = {};
  Object.keys(featureOptions).forEach(function(name) {
    Object.defineProperty(parseOptionsPrototype, name, {
      get: function() {
        return !!this.proxiedOptions_[name];
      },
      enumerable: true
    });
  });
  addBoolOption('commentCallback');
  addBoolOption('debug');
  addBoolOption('debugNames');
  addBoolOption('freeVariableChecker');
  addBoolOption('script');
  addBoolOption('validate');
  var Options = function() {
    function Options() {
      var options = arguments[0] !== (void 0) ? arguments[0] : Object.create(null);
      this.reset();
      Object.defineProperties(this, {
        modules_: {
          value: versionLockedOptions.modules,
          writable: true,
          enumerable: false
        },
        sourceMaps_: {
          value: versionLockedOptions.sourceMaps,
          writable: true,
          enumerable: false
        },
        sourceRoot_: {
          value: versionLockedOptions.sourceRoot,
          writable: true,
          enumerable: false
        },
        transformOptions: {
          value: Object.create(transformOptionsPrototype, {proxiedOptions_: {
              value: this,
              enumerable: false
            }}),
          enumerable: false
        },
        parseOptions: {
          value: Object.create(parseOptionsPrototype, {proxiedOptions_: {
              value: this,
              enumerable: false
            }}),
          enumerable: false
        }
      });
      this.setFromObject(options);
    }
    return ($traceurRuntime.createClass)(Options, {
      set experimental(v) {
        var $__2 = this;
        v = coerceOptionValue(v);
        Object.keys(experimentalOptions).forEach(function(name) {
          $__2[name] = v;
        });
      },
      get experimental() {
        var $__2 = this;
        var value;
        Object.keys(experimentalOptions).every(function(name) {
          var currentValue = $__2[name];
          if (value === undefined) {
            value = currentValue;
            return true;
          }
          if (currentValue !== value) {
            value = null;
            return false;
          }
          return true;
        });
        return value;
      },
      get atscript() {
        return this.types && this.annotations && this.memberVariables;
      },
      set atscript(value) {
        this.types = value;
        this.annotations = value;
        this.memberVariables = value;
      },
      get modules() {
        return this.modules_;
      },
      set modules(value) {
        if (typeof value === 'boolean' && !value)
          value = 'bootstrap';
        if (moduleOptions.indexOf(value) === -1) {
          throw new Error('Invalid \'modules\' option \'' + value + '\', not in ' + moduleOptions.join(', '));
        }
        this.modules_ = value;
      },
      get sourceMaps() {
        return this.sourceMaps_;
      },
      set sourceMaps(value) {
        if (value === null || typeof value === 'boolean') {
          this.sourceMaps_ = value ? 'file' : false;
          return;
        }
        if (value === 'file' || value === 'inline' || value === 'memory') {
          this.sourceMaps_ = value;
        } else {
          throw new Error('Option sourceMaps should be ' + '[false|inline|file|memory], not ' + value);
        }
      },
      reset: function() {
        var allOff = arguments[0];
        var $__2 = this;
        var useDefault = allOff === undefined;
        Object.keys(defaultValues).forEach(function(name) {
          $__2[name] = useDefault && defaultValues[name];
        });
        this.setDefaults();
      },
      setDefaults: function() {
        this.modules = 'bootstrap';
        this.moduleName = 'default';
        this.outputLanguage = 'es5';
        this.referrer = '';
        this.sourceMaps = false;
        this.sourceRoot = false;
        this.lowResolutionSourceMap = false;
        this.inputSourceMap = false;
      },
      setFromObject: function(object) {
        var $__2 = this;
        Object.keys(this).forEach(function(name) {
          if (name in object)
            $__2.setOption(name, object[name]);
        });
        this.modules = object.modules || this.modules;
        if (typeof object.sourceMaps === 'boolean' || typeof object.sourceMaps === 'string') {
          this.sourceMaps = object.sourceMaps;
        }
        if (object.sourceRoot !== undefined)
          this.sourceRoot = object.sourceRoot;
        return this;
      },
      setOption: function(name, value) {
        name = toCamelCase(name);
        if (name in this) {
          this[name] = value;
        } else {
          throw Error('Unknown option: ' + name);
        }
      },
      diff: function(ref) {
        var $__2 = this;
        var mismatches = [];
        Object.keys(this).forEach(function(key) {
          if ($__2[key] !== ref[key]) {
            mismatches.push({
              key: key,
              now: $traceurRuntime.options[key],
              v01: ref[key]
            });
          }
        });
        return mismatches;
      }
    }, {
      experimental: function() {
        return new Options(experimentalOptions);
      },
      atscript: function() {
        return new Options({
          types: true,
          annotations: true,
          memberVariables: true
        });
      },
      listUnknownOptions: function(obj) {
        var unknowns = [];
        Object.keys(obj).forEach(function(propName) {
          if (!(propName in optionsV01)) {
            unknowns.push(propName);
          }
        });
        return unknowns;
      }
    });
  }();
  ;
  var descriptions = {
    experimental: 'Turns on all experimental features',
    require: 'Generate require function argument for node when modules=register',
    sourceMaps: 'Generate source map and (\'file\') write to .map' + ' or (\'inline\') append data URL'
  };
  var CommandOptions = function($__super) {
    function CommandOptions() {
      $traceurRuntime.superConstructor(CommandOptions).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(CommandOptions, {
      parseCommand: function(s) {
        var re = /--([^=]+)(?:=(.+))?/;
        var m = re.exec(s);
        if (m)
          this.setOptionCoerced(m[1], m[2]);
      },
      setOptionCoerced: function(name, value) {
        if (typeof value !== 'undefined' && value !== null)
          value = coerceOptionValue(value);
        else
          value = true;
        this.setOption(name, value);
      }
    }, {
      fromString: function(s) {
        return CommandOptions.fromArgv(s.split(/\s+/));
      },
      fromArgv: function(args) {
        var options = new CommandOptions();
        args.forEach(function(arg) {
          return options.parseCommand(arg);
        });
        return options;
      }
    }, $__super);
  }(Options);
  function coerceOptionValue(v) {
    switch (v) {
      case 'false':
        return false;
      case 'true':
      case true:
        return true;
      default:
        return !!v && String(v);
    }
  }
  function toCamelCase(s) {
    return s.replace(/-\w/g, function(ch) {
      return ch[1].toUpperCase();
    });
  }
  function toDashCase(s) {
    return s.replace(/[A-Z]/g, function(ch) {
      return '-' + ch.toLowerCase();
    });
  }
  function addOptions(flags, commandOptions) {
    flags.option('--referrer <name>', 'Bracket output code with System.referrerName=<name>', function(name) {
      commandOptions.setOption('referrer', name);
      System.map = System.semverMap(name);
      return name;
    });
    flags.option('--modules <' + moduleOptions.join(', ') + '>', 'select the output format for modules', function(moduleFormat) {
      commandOptions.modules = moduleFormat;
    });
    flags.option('--moduleName [true|false|default]', 'true for named, false for anonymous modules; default depends on --modules', function(moduleName) {
      if (moduleName === 'true')
        moduleName = true;
      else if (moduleName === 'false')
        moduleName = false;
      else
        moduleName = 'default';
      commandOptions.moduleName = moduleName;
    });
    flags.option('--outputLanguage <es6|es5>', 'compilation target language', function(outputLanguage) {
      if (outputLanguage === 'es6' || outputLanguage === 'es5')
        commandOptions.outputLanguage = outputLanguage;
      else
        throw new Error('outputLanguage must be one of es5, es6');
    });
    flags.option('--source-maps [file|inline|memory]', 'sourceMaps generated to file or inline with data: URL', function(to) {
      return commandOptions.sourceMaps = to;
    });
    flags.option('--source-root <true|false|string>', 'sourcemap sourceRoot value. false to omit, ' + 'true for directory of output file.', function(to) {
      if (to === 'false')
        to = false;
      else if (to === 'true')
        to = true;
      return commandOptions.sourceRoot = to;
    });
    flags.option('--low-resolution-source-maps', 'Lower sourceMaps granularity to one mapping per output line', function() {
      return commandOptions.lowResolutionSourceMap = true;
    });
    flags.option('--experimental', 'Turns on all experimental features', function() {
      commandOptions.experimental = true;
    });
    flags.option('--atscript', 'Turns on all AtScript features', function() {
      commandOptions.atscript = true;
    });
    Object.keys(commandOptions).forEach(function(name) {
      var dashedName = toDashCase(name);
      if (flags.optionFor('--' + name) || flags.optionFor('--' + dashedName)) {
        return;
      } else if (name in featureOptions) {
        flags.option('--' + dashedName + ' [true|false|parse]', descriptions[name]);
        flags.on(dashedName, function(value) {
          return commandOptions.setOptionCoerced(dashedName, value);
        });
      } else if (commandOptions[name] !== null) {
        flags.option('--' + dashedName, descriptions[name]);
        flags.on(dashedName, function() {
          return commandOptions.setOption(dashedName, true);
        });
      } else {
        throw new Error('Unexpected null commandOption ' + name);
      }
    });
    commandOptions.setDefaults();
  }
  return {
    get optionsV01() {
      return optionsV01;
    },
    get versionLockedOptions() {
      return versionLockedOptions;
    },
    get Options() {
      return Options;
    },
    get CommandOptions() {
      return CommandOptions;
    },
    get toDashCase() {
      return toDashCase;
    },
    get addOptions() {
      return addOptions;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/loader/webLoader.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/loader/webLoader.js";
  var webLoader = {load: function(url, callback, errback) {
      var xhr = new XMLHttpRequest();
      xhr.onload = function() {
        if (xhr.status == 200 || xhr.status == 0) {
          callback(xhr.responseText);
        } else {
          var err;
          if (xhr.status === 404)
            err = 'File not found \'' + url + '\'';
          else
            err = xhr.status + xhr.statusText;
          errback(err);
        }
        xhr = null;
      };
      xhr.onerror = function(err) {
        errback(err);
      };
      xhr.open('GET', url, true);
      xhr.send();
      return function() {
        xhr && xhr.abort();
      };
    }};
  return {get webLoader() {
      return webLoader;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/WebPageTranscoder.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/WebPageTranscoder.js";
  var ErrorReporter = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./util/ErrorReporter.js", "traceur@0.0.108/src/WebPageTranscoder.js")).ErrorReporter;
  var CommandOptions = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Options.js", "traceur@0.0.108/src/WebPageTranscoder.js")).CommandOptions;
  var webLoader = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./loader/webLoader.js", "traceur@0.0.108/src/WebPageTranscoder.js")).webLoader;
  var scriptSelector = 'script[type="module"],script[type="text/traceur"]';
  var WebPageTranscoder = function() {
    function WebPageTranscoder() {
      var url = arguments[0] !== (void 0) ? arguments[0] : document.location.href;
      var traceurOptions = arguments[1] !== (void 0) ? arguments[1] : new Options();
      this.url = url;
      this.numPending_ = 0;
      this.numberInlined_ = 0;
      this.traceurOptions_ = traceurOptions;
    }
    return ($traceurRuntime.createClass)(WebPageTranscoder, {
      asyncLoad_: function(url, fncOfContent, onScriptsReady) {
        var $__3 = this;
        this.numPending_++;
        webLoader.load(url, function(content) {
          if (content)
            fncOfContent(content);
          else
            console.warn('Failed to load', url);
          if (--$__3.numPending_ <= 0)
            onScriptsReady();
        }, function(error) {
          console.error('WebPageTranscoder FAILED to load ' + url, error.stack || error);
        });
      },
      addFileFromScriptElement: function(scriptElement, name, content) {
        var options = this.traceurOptions_;
        var elementOptionString = scriptElement.getAttribute('traceurOptions');
        if (elementOptionString) {
          options = CommandOptions.fromString(elementOptionString);
        }
        var nameInfo = {
          address: name,
          referrerName: window.location.href,
          name: name,
          metadata: {traceurOptions: options}
        };
        var loadingResult;
        if (scriptElement.type === 'module')
          loadingResult = System.module(content, nameInfo);
        else
          loadingResult = System.script(content, nameInfo);
        loadingResult.catch(function(error) {
          console.error(error.stack || error);
        });
      },
      nextInlineScriptName_: function() {
        this.numberInlined_ += 1;
        if (!this.inlineScriptNameBase_) {
          var segments = this.url.split('.');
          segments.pop();
          this.inlineScriptNameBase_ = segments.join('.');
        }
        return this.inlineScriptNameBase_ + '_inline_script_' + this.numberInlined_ + '.js';
      },
      addFilesFromScriptElements: function(scriptElements, onScriptsReady) {
        for (var i = 0,
            length = scriptElements.length; i < length; i++) {
          var scriptElement = scriptElements[i];
          if (!scriptElement.src) {
            var name = this.nextInlineScriptName_();
            var content = scriptElement.textContent;
            this.addFileFromScriptElement(scriptElement, name, content);
          } else {
            var name$__4 = scriptElement.src;
            this.asyncLoad_(name$__4, this.addFileFromScriptElement.bind(this, scriptElement, name$__4), onScriptsReady);
          }
        }
        if (this.numPending_ <= 0)
          onScriptsReady();
      },
      get reporter() {
        if (!this.reporter_) {
          this.reporter_ = new ErrorReporter();
        }
        return this.reporter_;
      },
      putFile: function(file) {
        var scriptElement = document.createElement('script');
        scriptElement.setAttribute('data-traceur-src-url', file.name);
        scriptElement.textContent = file.generatedSource;
        var parent = file.scriptElement.parentNode;
        parent.insertBefore(scriptElement, file.scriptElement || null);
      },
      selectAndProcessScripts: function(done) {
        var selector = scriptSelector;
        var scripts = document.querySelectorAll(selector);
        if (!scripts.length) {
          done();
          return;
        }
        this.addFilesFromScriptElements(scripts, function() {
          done();
        });
      },
      run: function() {
        var done = arguments[0] !== (void 0) ? arguments[0] : function() {};
        var $__3 = this;
        var ready = document.readyState;
        if (ready === 'complete' || ready === 'loaded') {
          this.selectAndProcessScripts(done);
        } else {
          document.addEventListener('DOMContentLoaded', function() {
            return $__3.selectAndProcessScripts(done);
          }, false);
        }
      }
    }, {});
  }();
  return {
    get scriptSelector() {
      return scriptSelector;
    },
    get WebPageTranscoder() {
      return WebPageTranscoder;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/util/StringSet.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/util/StringSet.js";
  function assertString(value) {
    if (typeof value !== 'string')
      throw new TypeError();
  }
  var StringSet = function() {
    function StringSet() {
      this.storage_ = Object.create(null);
    }
    return ($traceurRuntime.createClass)(StringSet, {
      add: function(value) {
        assertString(value);
        this.storage_[value] = true;
      },
      has: function(value) {
        assertString(value);
        return this.storage_[value] !== undefined;
      },
      delete: function(value) {
        assertString(value);
        delete this.storage_[value];
      },
      isEmpty: function() {
        for (var _ in this.storage_) {
          return false;
        }
        return true;
      },
      valuesAsArray: function() {
        return Object.keys(this.storage_);
      },
      forEach: function(func) {
        for (var value in this.storage_) {
          func(value);
        }
      }
    }, {});
  }();
  return {get StringSet() {
      return StringSet;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/util/StringMap.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/util/StringMap.js";
  var StringSet = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./StringSet.js", "traceur@0.0.108/src/util/StringMap.js")).StringSet;
  function assertString(value) {
    if (typeof value !== 'string')
      throw new TypeError();
  }
  var StringMap = function() {
    function StringMap() {
      this.storage_ = Object.create(null);
    }
    return ($traceurRuntime.createClass)(StringMap, {
      set: function(key, value) {
        assertString(key);
        this.storage_[key] = value;
      },
      get: function(key) {
        assertString(key);
        return this.storage_[key];
      },
      delete: function(key) {
        assertString(key);
        delete this.storage_[key];
      },
      has: function(key) {
        assertString(key);
        return this.storage_[key] !== undefined;
      },
      keysAsArray: function() {
        return Object.keys(this.storage_);
      },
      keysAsSet: function() {
        var set = new StringSet();
        this.forEach(function(key) {
          return set.add(key);
        });
        return set;
      },
      forEach: function(func) {
        for (var key in this.storage_) {
          func(key, this.storage_[key]);
        }
      }
    }, {});
  }();
  return {get StringMap() {
      return StringMap;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/HTMLImportTranscoder.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/HTMLImportTranscoder.js";
  var StringMap = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./util/StringMap.js", "traceur@0.0.108/src/HTMLImportTranscoder.js")).StringMap;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./WebPageTranscoder.js", "traceur@0.0.108/src/HTMLImportTranscoder.js")),
      WebPageTranscoder = $__4.WebPageTranscoder,
      scriptSelector = $__4.scriptSelector;
  var importSelector = 'link[rel=import][href]';
  var HTMLImportTranscoder = function() {
    function HTMLImportTranscoder() {
      this.importsToProcess_ = [];
    }
    return ($traceurRuntime.createClass)(HTMLImportTranscoder, {
      findAllChildrenHTMLImports_: function(parentImportNodes) {
        var foundImportNodes = [];
        for (var parentIndex = 0; parentIndex < parentImportNodes.length; parentIndex++) {
          var parentLink = parentImportNodes[parentIndex];
          var childImportNodes = parentLink.import.querySelectorAll(importSelector);
          if (childImportNodes.length > 0)
            this.findAllChildrenHTMLImports_(childImportNodes);
          this.importsToProcess_.push(parentLink);
        }
      },
      filterHTMLImports_: function(importNodes) {
        this.findAllChildrenHTMLImports_(importNodes);
        var importsToParse = [];
        var dupFilterMap = new StringMap();
        for (var index = 0; index < this.importsToProcess_.length; index++) {
          var processLink = this.importsToProcess_[index];
          if (!dupFilterMap.has(processLink.href)) {
            dupFilterMap.set(processLink.href, 0);
            var scripts = processLink.import.querySelectorAll(scriptSelector);
            if (scripts.length > 0)
              importsToParse.push({
                href: processLink.href,
                scripts: scripts
              });
          }
        }
        this.importsToProcess_ = [];
        return importsToParse;
      },
      selectAndProcessHTMLImports: function(importNodes, done) {
        var importInfoList = this.filterHTMLImports_(importNodes);
        if (importInfoList.length === 0)
          done();
        var processCount = importInfoList.length;
        importInfoList.forEach(function(importInfo) {
          var transcoder = new WebPageTranscoder(importInfo.href);
          transcoder.addFilesFromScriptElements(importInfo.scripts, function() {
            processCount--;
            if (processCount === 0 && done)
              done();
          });
        });
      },
      run: function() {
        var done = arguments[0] !== (void 0) ? arguments[0] : function() {};
        var $__2 = this;
        var ready = document.readyState;
        if (ready === 'complete' || ready === 'loaded') {
          var importNodes = document.querySelectorAll(importSelector);
          if (importNodes.length > 0)
            this.selectAndProcessHTMLImports(importNodes, done);
        } else {
          document.addEventListener('HTMLImportsLoaded', function(event) {
            var importNodes = event.detail && event.detail.allImports ? event.detail.allImports : document.querySelectorAll(importSelector);
            if (importNodes.length > 0)
              $__2.selectAndProcessHTMLImports(importNodes, done);
          });
        }
      }
    }, {});
  }();
  return {get HTMLImportTranscoder() {
      return HTMLImportTranscoder;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/util/CollectingErrorReporter.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/util/CollectingErrorReporter.js";
  var ErrorReporter = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/ErrorReporter.js", "traceur@0.0.108/src/util/CollectingErrorReporter.js")).ErrorReporter;
  var MultipleErrors = function($__super) {
    function MultipleErrors(errors) {
      $traceurRuntime.superConstructor(MultipleErrors).call(this);
      this.message = errors ? errors.join('\n') : '';
      this.name = 'MultipleErrors';
      this.errors = errors;
    }
    return ($traceurRuntime.createClass)(MultipleErrors, {}, {}, $__super);
  }(Error);
  var CollectingErrorReporter = function($__super) {
    function CollectingErrorReporter() {
      $traceurRuntime.superConstructor(CollectingErrorReporter).call(this);
      this.errors = [];
    }
    return ($traceurRuntime.createClass)(CollectingErrorReporter, {
      reportMessageInternal: function(location, message) {
        this.errors.push((location.start + ": " + message));
      },
      errorsAsString: function() {
        return this.toError().message;
      },
      toError: function() {
        return new MultipleErrors(this.errors);
      }
    }, {}, $__super);
  }(ErrorReporter);
  return {
    get MultipleErrors() {
      return MultipleErrors;
    },
    get CollectingErrorReporter() {
      return CollectingErrorReporter;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/util-imports.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/util-imports.js";
  $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./util/MutedErrorReporter.js", "traceur@0.0.108/src/util-imports.js"));
  var $__traceur_64_0_46_0_46_108_47_src_47_WebPageTranscoder_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./WebPageTranscoder.js", "traceur@0.0.108/src/util-imports.js"));
  var $__traceur_64_0_46_0_46_108_47_src_47_HTMLImportTranscoder_46_js__ = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./HTMLImportTranscoder.js", "traceur@0.0.108/src/util-imports.js"));
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Options.js", "traceur@0.0.108/src/util-imports.js")),
      addOptions = $__1.addOptions,
      CommandOptions = $__1.CommandOptions,
      Options = $__1.Options;
  var ErrorReporter = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./util/ErrorReporter.js", "traceur@0.0.108/src/util-imports.js")).ErrorReporter;
  var CollectingErrorReporter = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./util/CollectingErrorReporter.js", "traceur@0.0.108/src/util-imports.js")).CollectingErrorReporter;
  var util = {
    addOptions: addOptions,
    CommandOptions: CommandOptions,
    CollectingErrorReporter: CollectingErrorReporter,
    ErrorReporter: ErrorReporter,
    Options: Options
  };
  return {
    get WebPageTranscoder() {
      return $__traceur_64_0_46_0_46_108_47_src_47_WebPageTranscoder_46_js__.WebPageTranscoder;
    },
    get HTMLImportTranscoder() {
      return $__traceur_64_0_46_0_46_108_47_src_47_HTMLImportTranscoder_46_js__.HTMLImportTranscoder;
    },
    get util() {
      return util;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/trees/ParseTreeType.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/trees/ParseTreeType.js";
  var ANNOTATION = 'ANNOTATION';
  var ANON_BLOCK = 'ANON_BLOCK';
  var ARGUMENT_LIST = 'ARGUMENT_LIST';
  var ARRAY_COMPREHENSION = 'ARRAY_COMPREHENSION';
  var ARRAY_LITERAL = 'ARRAY_LITERAL';
  var ARRAY_PATTERN = 'ARRAY_PATTERN';
  var ARRAY_TYPE = 'ARRAY_TYPE';
  var ARROW_FUNCTION = 'ARROW_FUNCTION';
  var ASSIGNMENT_ELEMENT = 'ASSIGNMENT_ELEMENT';
  var AWAIT_EXPRESSION = 'AWAIT_EXPRESSION';
  var BINARY_EXPRESSION = 'BINARY_EXPRESSION';
  var BINDING_ELEMENT = 'BINDING_ELEMENT';
  var BINDING_IDENTIFIER = 'BINDING_IDENTIFIER';
  var BLOCK = 'BLOCK';
  var BREAK_STATEMENT = 'BREAK_STATEMENT';
  var CALL_EXPRESSION = 'CALL_EXPRESSION';
  var CALL_SIGNATURE = 'CALL_SIGNATURE';
  var CASE_CLAUSE = 'CASE_CLAUSE';
  var CATCH = 'CATCH';
  var CLASS_DECLARATION = 'CLASS_DECLARATION';
  var CLASS_EXPRESSION = 'CLASS_EXPRESSION';
  var COMMA_EXPRESSION = 'COMMA_EXPRESSION';
  var COMPREHENSION_FOR = 'COMPREHENSION_FOR';
  var COMPREHENSION_IF = 'COMPREHENSION_IF';
  var COMPUTED_PROPERTY_NAME = 'COMPUTED_PROPERTY_NAME';
  var CONDITIONAL_EXPRESSION = 'CONDITIONAL_EXPRESSION';
  var CONSTRUCT_SIGNATURE = 'CONSTRUCT_SIGNATURE';
  var CONSTRUCTOR_TYPE = 'CONSTRUCTOR_TYPE';
  var CONTINUE_STATEMENT = 'CONTINUE_STATEMENT';
  var COVER_FORMALS = 'COVER_FORMALS';
  var COVER_INITIALIZED_NAME = 'COVER_INITIALIZED_NAME';
  var DEBUGGER_STATEMENT = 'DEBUGGER_STATEMENT';
  var DEFAULT_CLAUSE = 'DEFAULT_CLAUSE';
  var DO_WHILE_STATEMENT = 'DO_WHILE_STATEMENT';
  var EMPTY_STATEMENT = 'EMPTY_STATEMENT';
  var EXPORT_DECLARATION = 'EXPORT_DECLARATION';
  var EXPORT_DEFAULT = 'EXPORT_DEFAULT';
  var EXPORT_SPECIFIER = 'EXPORT_SPECIFIER';
  var EXPORT_SPECIFIER_SET = 'EXPORT_SPECIFIER_SET';
  var EXPORT_STAR = 'EXPORT_STAR';
  var EXPRESSION_STATEMENT = 'EXPRESSION_STATEMENT';
  var FINALLY = 'FINALLY';
  var FOR_IN_STATEMENT = 'FOR_IN_STATEMENT';
  var FOR_OF_STATEMENT = 'FOR_OF_STATEMENT';
  var FOR_ON_STATEMENT = 'FOR_ON_STATEMENT';
  var FOR_STATEMENT = 'FOR_STATEMENT';
  var FORMAL_PARAMETER = 'FORMAL_PARAMETER';
  var FORMAL_PARAMETER_LIST = 'FORMAL_PARAMETER_LIST';
  var FORWARD_DEFAULT_EXPORT = 'FORWARD_DEFAULT_EXPORT';
  var FUNCTION_BODY = 'FUNCTION_BODY';
  var FUNCTION_DECLARATION = 'FUNCTION_DECLARATION';
  var FUNCTION_EXPRESSION = 'FUNCTION_EXPRESSION';
  var FUNCTION_TYPE = 'FUNCTION_TYPE';
  var GENERATOR_COMPREHENSION = 'GENERATOR_COMPREHENSION';
  var GET_ACCESSOR = 'GET_ACCESSOR';
  var IDENTIFIER_EXPRESSION = 'IDENTIFIER_EXPRESSION';
  var IF_STATEMENT = 'IF_STATEMENT';
  var IMPORT_CLAUSE_PAIR = 'IMPORT_CLAUSE_PAIR';
  var IMPORT_DECLARATION = 'IMPORT_DECLARATION';
  var IMPORT_SPECIFIER = 'IMPORT_SPECIFIER';
  var IMPORT_SPECIFIER_SET = 'IMPORT_SPECIFIER_SET';
  var IMPORT_TYPE_CLAUSE = 'IMPORT_TYPE_CLAUSE';
  var IMPORTED_BINDING = 'IMPORTED_BINDING';
  var INDEX_SIGNATURE = 'INDEX_SIGNATURE';
  var INTERFACE_DECLARATION = 'INTERFACE_DECLARATION';
  var JSX_ATTRIBUTE = 'JSX_ATTRIBUTE';
  var JSX_ELEMENT = 'JSX_ELEMENT';
  var JSX_ELEMENT_NAME = 'JSX_ELEMENT_NAME';
  var JSX_PLACEHOLDER = 'JSX_PLACEHOLDER';
  var JSX_SPREAD_ATTRIBUTE = 'JSX_SPREAD_ATTRIBUTE';
  var JSX_TEXT = 'JSX_TEXT';
  var LABELLED_STATEMENT = 'LABELLED_STATEMENT';
  var LITERAL_EXPRESSION = 'LITERAL_EXPRESSION';
  var LITERAL_PROPERTY_NAME = 'LITERAL_PROPERTY_NAME';
  var MEMBER_EXPRESSION = 'MEMBER_EXPRESSION';
  var MEMBER_LOOKUP_EXPRESSION = 'MEMBER_LOOKUP_EXPRESSION';
  var METHOD = 'METHOD';
  var METHOD_SIGNATURE = 'METHOD_SIGNATURE';
  var MODULE = 'MODULE';
  var MODULE_SPECIFIER = 'MODULE_SPECIFIER';
  var NAME_SPACE_EXPORT = 'NAME_SPACE_EXPORT';
  var NAME_SPACE_IMPORT = 'NAME_SPACE_IMPORT';
  var NAMED_EXPORT = 'NAMED_EXPORT';
  var NEW_EXPRESSION = 'NEW_EXPRESSION';
  var OBJECT_LITERAL = 'OBJECT_LITERAL';
  var OBJECT_PATTERN = 'OBJECT_PATTERN';
  var OBJECT_PATTERN_FIELD = 'OBJECT_PATTERN_FIELD';
  var OBJECT_TYPE = 'OBJECT_TYPE';
  var PAREN_EXPRESSION = 'PAREN_EXPRESSION';
  var POSTFIX_EXPRESSION = 'POSTFIX_EXPRESSION';
  var PREDEFINED_TYPE = 'PREDEFINED_TYPE';
  var PROPERTY_NAME_ASSIGNMENT = 'PROPERTY_NAME_ASSIGNMENT';
  var PROPERTY_NAME_SHORTHAND = 'PROPERTY_NAME_SHORTHAND';
  var PROPERTY_SIGNATURE = 'PROPERTY_SIGNATURE';
  var PROPERTY_VARIABLE_DECLARATION = 'PROPERTY_VARIABLE_DECLARATION';
  var REST_PARAMETER = 'REST_PARAMETER';
  var RETURN_STATEMENT = 'RETURN_STATEMENT';
  var SCRIPT = 'SCRIPT';
  var SET_ACCESSOR = 'SET_ACCESSOR';
  var SPREAD_EXPRESSION = 'SPREAD_EXPRESSION';
  var SPREAD_PATTERN_ELEMENT = 'SPREAD_PATTERN_ELEMENT';
  var STATE_MACHINE = 'STATE_MACHINE';
  var SUPER_EXPRESSION = 'SUPER_EXPRESSION';
  var SWITCH_STATEMENT = 'SWITCH_STATEMENT';
  var SYNTAX_ERROR_TREE = 'SYNTAX_ERROR_TREE';
  var TEMPLATE_LITERAL_EXPRESSION = 'TEMPLATE_LITERAL_EXPRESSION';
  var TEMPLATE_LITERAL_PORTION = 'TEMPLATE_LITERAL_PORTION';
  var TEMPLATE_SUBSTITUTION = 'TEMPLATE_SUBSTITUTION';
  var THIS_EXPRESSION = 'THIS_EXPRESSION';
  var THROW_STATEMENT = 'THROW_STATEMENT';
  var TRY_STATEMENT = 'TRY_STATEMENT';
  var TYPE_ALIAS_DECLARATION = 'TYPE_ALIAS_DECLARATION';
  var TYPE_ARGUMENTS = 'TYPE_ARGUMENTS';
  var TYPE_NAME = 'TYPE_NAME';
  var TYPE_PARAMETER = 'TYPE_PARAMETER';
  var TYPE_PARAMETERS = 'TYPE_PARAMETERS';
  var TYPE_REFERENCE = 'TYPE_REFERENCE';
  var UNARY_EXPRESSION = 'UNARY_EXPRESSION';
  var UNION_TYPE = 'UNION_TYPE';
  var VARIABLE_DECLARATION = 'VARIABLE_DECLARATION';
  var VARIABLE_DECLARATION_LIST = 'VARIABLE_DECLARATION_LIST';
  var VARIABLE_STATEMENT = 'VARIABLE_STATEMENT';
  var WHILE_STATEMENT = 'WHILE_STATEMENT';
  var WITH_STATEMENT = 'WITH_STATEMENT';
  var YIELD_EXPRESSION = 'YIELD_EXPRESSION';
  return {
    get ANNOTATION() {
      return ANNOTATION;
    },
    get ANON_BLOCK() {
      return ANON_BLOCK;
    },
    get ARGUMENT_LIST() {
      return ARGUMENT_LIST;
    },
    get ARRAY_COMPREHENSION() {
      return ARRAY_COMPREHENSION;
    },
    get ARRAY_LITERAL() {
      return ARRAY_LITERAL;
    },
    get ARRAY_PATTERN() {
      return ARRAY_PATTERN;
    },
    get ARRAY_TYPE() {
      return ARRAY_TYPE;
    },
    get ARROW_FUNCTION() {
      return ARROW_FUNCTION;
    },
    get ASSIGNMENT_ELEMENT() {
      return ASSIGNMENT_ELEMENT;
    },
    get AWAIT_EXPRESSION() {
      return AWAIT_EXPRESSION;
    },
    get BINARY_EXPRESSION() {
      return BINARY_EXPRESSION;
    },
    get BINDING_ELEMENT() {
      return BINDING_ELEMENT;
    },
    get BINDING_IDENTIFIER() {
      return BINDING_IDENTIFIER;
    },
    get BLOCK() {
      return BLOCK;
    },
    get BREAK_STATEMENT() {
      return BREAK_STATEMENT;
    },
    get CALL_EXPRESSION() {
      return CALL_EXPRESSION;
    },
    get CALL_SIGNATURE() {
      return CALL_SIGNATURE;
    },
    get CASE_CLAUSE() {
      return CASE_CLAUSE;
    },
    get CATCH() {
      return CATCH;
    },
    get CLASS_DECLARATION() {
      return CLASS_DECLARATION;
    },
    get CLASS_EXPRESSION() {
      return CLASS_EXPRESSION;
    },
    get COMMA_EXPRESSION() {
      return COMMA_EXPRESSION;
    },
    get COMPREHENSION_FOR() {
      return COMPREHENSION_FOR;
    },
    get COMPREHENSION_IF() {
      return COMPREHENSION_IF;
    },
    get COMPUTED_PROPERTY_NAME() {
      return COMPUTED_PROPERTY_NAME;
    },
    get CONDITIONAL_EXPRESSION() {
      return CONDITIONAL_EXPRESSION;
    },
    get CONSTRUCT_SIGNATURE() {
      return CONSTRUCT_SIGNATURE;
    },
    get CONSTRUCTOR_TYPE() {
      return CONSTRUCTOR_TYPE;
    },
    get CONTINUE_STATEMENT() {
      return CONTINUE_STATEMENT;
    },
    get COVER_FORMALS() {
      return COVER_FORMALS;
    },
    get COVER_INITIALIZED_NAME() {
      return COVER_INITIALIZED_NAME;
    },
    get DEBUGGER_STATEMENT() {
      return DEBUGGER_STATEMENT;
    },
    get DEFAULT_CLAUSE() {
      return DEFAULT_CLAUSE;
    },
    get DO_WHILE_STATEMENT() {
      return DO_WHILE_STATEMENT;
    },
    get EMPTY_STATEMENT() {
      return EMPTY_STATEMENT;
    },
    get EXPORT_DECLARATION() {
      return EXPORT_DECLARATION;
    },
    get EXPORT_DEFAULT() {
      return EXPORT_DEFAULT;
    },
    get EXPORT_SPECIFIER() {
      return EXPORT_SPECIFIER;
    },
    get EXPORT_SPECIFIER_SET() {
      return EXPORT_SPECIFIER_SET;
    },
    get EXPORT_STAR() {
      return EXPORT_STAR;
    },
    get EXPRESSION_STATEMENT() {
      return EXPRESSION_STATEMENT;
    },
    get FINALLY() {
      return FINALLY;
    },
    get FOR_IN_STATEMENT() {
      return FOR_IN_STATEMENT;
    },
    get FOR_OF_STATEMENT() {
      return FOR_OF_STATEMENT;
    },
    get FOR_ON_STATEMENT() {
      return FOR_ON_STATEMENT;
    },
    get FOR_STATEMENT() {
      return FOR_STATEMENT;
    },
    get FORMAL_PARAMETER() {
      return FORMAL_PARAMETER;
    },
    get FORMAL_PARAMETER_LIST() {
      return FORMAL_PARAMETER_LIST;
    },
    get FORWARD_DEFAULT_EXPORT() {
      return FORWARD_DEFAULT_EXPORT;
    },
    get FUNCTION_BODY() {
      return FUNCTION_BODY;
    },
    get FUNCTION_DECLARATION() {
      return FUNCTION_DECLARATION;
    },
    get FUNCTION_EXPRESSION() {
      return FUNCTION_EXPRESSION;
    },
    get FUNCTION_TYPE() {
      return FUNCTION_TYPE;
    },
    get GENERATOR_COMPREHENSION() {
      return GENERATOR_COMPREHENSION;
    },
    get GET_ACCESSOR() {
      return GET_ACCESSOR;
    },
    get IDENTIFIER_EXPRESSION() {
      return IDENTIFIER_EXPRESSION;
    },
    get IF_STATEMENT() {
      return IF_STATEMENT;
    },
    get IMPORT_CLAUSE_PAIR() {
      return IMPORT_CLAUSE_PAIR;
    },
    get IMPORT_DECLARATION() {
      return IMPORT_DECLARATION;
    },
    get IMPORT_SPECIFIER() {
      return IMPORT_SPECIFIER;
    },
    get IMPORT_SPECIFIER_SET() {
      return IMPORT_SPECIFIER_SET;
    },
    get IMPORT_TYPE_CLAUSE() {
      return IMPORT_TYPE_CLAUSE;
    },
    get IMPORTED_BINDING() {
      return IMPORTED_BINDING;
    },
    get INDEX_SIGNATURE() {
      return INDEX_SIGNATURE;
    },
    get INTERFACE_DECLARATION() {
      return INTERFACE_DECLARATION;
    },
    get JSX_ATTRIBUTE() {
      return JSX_ATTRIBUTE;
    },
    get JSX_ELEMENT() {
      return JSX_ELEMENT;
    },
    get JSX_ELEMENT_NAME() {
      return JSX_ELEMENT_NAME;
    },
    get JSX_PLACEHOLDER() {
      return JSX_PLACEHOLDER;
    },
    get JSX_SPREAD_ATTRIBUTE() {
      return JSX_SPREAD_ATTRIBUTE;
    },
    get JSX_TEXT() {
      return JSX_TEXT;
    },
    get LABELLED_STATEMENT() {
      return LABELLED_STATEMENT;
    },
    get LITERAL_EXPRESSION() {
      return LITERAL_EXPRESSION;
    },
    get LITERAL_PROPERTY_NAME() {
      return LITERAL_PROPERTY_NAME;
    },
    get MEMBER_EXPRESSION() {
      return MEMBER_EXPRESSION;
    },
    get MEMBER_LOOKUP_EXPRESSION() {
      return MEMBER_LOOKUP_EXPRESSION;
    },
    get METHOD() {
      return METHOD;
    },
    get METHOD_SIGNATURE() {
      return METHOD_SIGNATURE;
    },
    get MODULE() {
      return MODULE;
    },
    get MODULE_SPECIFIER() {
      return MODULE_SPECIFIER;
    },
    get NAME_SPACE_EXPORT() {
      return NAME_SPACE_EXPORT;
    },
    get NAME_SPACE_IMPORT() {
      return NAME_SPACE_IMPORT;
    },
    get NAMED_EXPORT() {
      return NAMED_EXPORT;
    },
    get NEW_EXPRESSION() {
      return NEW_EXPRESSION;
    },
    get OBJECT_LITERAL() {
      return OBJECT_LITERAL;
    },
    get OBJECT_PATTERN() {
      return OBJECT_PATTERN;
    },
    get OBJECT_PATTERN_FIELD() {
      return OBJECT_PATTERN_FIELD;
    },
    get OBJECT_TYPE() {
      return OBJECT_TYPE;
    },
    get PAREN_EXPRESSION() {
      return PAREN_EXPRESSION;
    },
    get POSTFIX_EXPRESSION() {
      return POSTFIX_EXPRESSION;
    },
    get PREDEFINED_TYPE() {
      return PREDEFINED_TYPE;
    },
    get PROPERTY_NAME_ASSIGNMENT() {
      return PROPERTY_NAME_ASSIGNMENT;
    },
    get PROPERTY_NAME_SHORTHAND() {
      return PROPERTY_NAME_SHORTHAND;
    },
    get PROPERTY_SIGNATURE() {
      return PROPERTY_SIGNATURE;
    },
    get PROPERTY_VARIABLE_DECLARATION() {
      return PROPERTY_VARIABLE_DECLARATION;
    },
    get REST_PARAMETER() {
      return REST_PARAMETER;
    },
    get RETURN_STATEMENT() {
      return RETURN_STATEMENT;
    },
    get SCRIPT() {
      return SCRIPT;
    },
    get SET_ACCESSOR() {
      return SET_ACCESSOR;
    },
    get SPREAD_EXPRESSION() {
      return SPREAD_EXPRESSION;
    },
    get SPREAD_PATTERN_ELEMENT() {
      return SPREAD_PATTERN_ELEMENT;
    },
    get STATE_MACHINE() {
      return STATE_MACHINE;
    },
    get SUPER_EXPRESSION() {
      return SUPER_EXPRESSION;
    },
    get SWITCH_STATEMENT() {
      return SWITCH_STATEMENT;
    },
    get SYNTAX_ERROR_TREE() {
      return SYNTAX_ERROR_TREE;
    },
    get TEMPLATE_LITERAL_EXPRESSION() {
      return TEMPLATE_LITERAL_EXPRESSION;
    },
    get TEMPLATE_LITERAL_PORTION() {
      return TEMPLATE_LITERAL_PORTION;
    },
    get TEMPLATE_SUBSTITUTION() {
      return TEMPLATE_SUBSTITUTION;
    },
    get THIS_EXPRESSION() {
      return THIS_EXPRESSION;
    },
    get THROW_STATEMENT() {
      return THROW_STATEMENT;
    },
    get TRY_STATEMENT() {
      return TRY_STATEMENT;
    },
    get TYPE_ALIAS_DECLARATION() {
      return TYPE_ALIAS_DECLARATION;
    },
    get TYPE_ARGUMENTS() {
      return TYPE_ARGUMENTS;
    },
    get TYPE_NAME() {
      return TYPE_NAME;
    },
    get TYPE_PARAMETER() {
      return TYPE_PARAMETER;
    },
    get TYPE_PARAMETERS() {
      return TYPE_PARAMETERS;
    },
    get TYPE_REFERENCE() {
      return TYPE_REFERENCE;
    },
    get UNARY_EXPRESSION() {
      return UNARY_EXPRESSION;
    },
    get UNION_TYPE() {
      return UNION_TYPE;
    },
    get VARIABLE_DECLARATION() {
      return VARIABLE_DECLARATION;
    },
    get VARIABLE_DECLARATION_LIST() {
      return VARIABLE_DECLARATION_LIST;
    },
    get VARIABLE_STATEMENT() {
      return VARIABLE_STATEMENT;
    },
    get WHILE_STATEMENT() {
      return WHILE_STATEMENT;
    },
    get WITH_STATEMENT() {
      return WITH_STATEMENT;
    },
    get YIELD_EXPRESSION() {
      return YIELD_EXPRESSION;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/TokenType.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/TokenType.js";
  var AMPERSAND = '&';
  var AMPERSAND_EQUAL = '&=';
  var AND = '&&';
  var ARROW = '=>';
  var AT = '@';
  var BACK_QUOTE = '`';
  var BANG = '!';
  var BAR = '|';
  var BAR_EQUAL = '|=';
  var BREAK = 'break';
  var CARET = '^';
  var CARET_EQUAL = '^=';
  var CASE = 'case';
  var CATCH = 'catch';
  var CLASS = 'class';
  var CLOSE_ANGLE = '>';
  var CLOSE_CURLY = '}';
  var CLOSE_PAREN = ')';
  var CLOSE_SQUARE = ']';
  var COLON = ':';
  var COMMA = ',';
  var CONST = 'const';
  var CONTINUE = 'continue';
  var DEBUGGER = 'debugger';
  var DEFAULT = 'default';
  var DELETE = 'delete';
  var DO = 'do';
  var DOT_DOT_DOT = '...';
  var ELSE = 'else';
  var END_OF_FILE = 'End of File';
  var ENUM = 'enum';
  var EQUAL = '=';
  var EQUAL_EQUAL = '==';
  var EQUAL_EQUAL_EQUAL = '===';
  var ERROR = 'error';
  var EXPORT = 'export';
  var EXTENDS = 'extends';
  var FALSE = 'false';
  var FINALLY = 'finally';
  var FOR = 'for';
  var FUNCTION = 'function';
  var GREATER_EQUAL = '>=';
  var IDENTIFIER = 'identifier';
  var IF = 'if';
  var IMPLEMENTS = 'implements';
  var IMPORT = 'import';
  var IN = 'in';
  var INSTANCEOF = 'instanceof';
  var INTERFACE = 'interface';
  var JSX_IDENTIFIER = 'jsx identifier';
  var LEFT_SHIFT = '<<';
  var LEFT_SHIFT_EQUAL = '<<=';
  var LESS_EQUAL = '<=';
  var LET = 'let';
  var MINUS = '-';
  var MINUS_EQUAL = '-=';
  var MINUS_MINUS = '--';
  var NEW = 'new';
  var NO_SUBSTITUTION_TEMPLATE = 'no substitution template';
  var NOT_EQUAL = '!=';
  var NOT_EQUAL_EQUAL = '!==';
  var NULL = 'null';
  var NUMBER = 'number literal';
  var OPEN_ANGLE = '<';
  var OPEN_CURLY = '{';
  var OPEN_PAREN = '(';
  var OPEN_SQUARE = '[';
  var OR = '||';
  var PACKAGE = 'package';
  var PERCENT = '%';
  var PERCENT_EQUAL = '%=';
  var PERIOD = '.';
  var PLUS = '+';
  var PLUS_EQUAL = '+=';
  var PLUS_PLUS = '++';
  var PRIVATE = 'private';
  var PROTECTED = 'protected';
  var PUBLIC = 'public';
  var QUESTION = '?';
  var REGULAR_EXPRESSION = 'regular expression literal';
  var RETURN = 'return';
  var RIGHT_SHIFT = '>>';
  var RIGHT_SHIFT_EQUAL = '>>=';
  var SEMI_COLON = ';';
  var SLASH = '/';
  var SLASH_EQUAL = '/=';
  var STAR = '*';
  var STAR_EQUAL = '*=';
  var STAR_STAR = '**';
  var STAR_STAR_EQUAL = '**=';
  var STATIC = 'static';
  var STRING = 'string literal';
  var SUPER = 'super';
  var SWITCH = 'switch';
  var TEMPLATE_HEAD = 'template head';
  var TEMPLATE_MIDDLE = 'template middle';
  var TEMPLATE_TAIL = 'template tail';
  var THIS = 'this';
  var THROW = 'throw';
  var TILDE = '~';
  var TRUE = 'true';
  var TRY = 'try';
  var TYPEOF = 'typeof';
  var UNSIGNED_RIGHT_SHIFT = '>>>';
  var UNSIGNED_RIGHT_SHIFT_EQUAL = '>>>=';
  var VAR = 'var';
  var VOID = 'void';
  var WHILE = 'while';
  var WITH = 'with';
  var YIELD = 'yield';
  return {
    get AMPERSAND() {
      return AMPERSAND;
    },
    get AMPERSAND_EQUAL() {
      return AMPERSAND_EQUAL;
    },
    get AND() {
      return AND;
    },
    get ARROW() {
      return ARROW;
    },
    get AT() {
      return AT;
    },
    get BACK_QUOTE() {
      return BACK_QUOTE;
    },
    get BANG() {
      return BANG;
    },
    get BAR() {
      return BAR;
    },
    get BAR_EQUAL() {
      return BAR_EQUAL;
    },
    get BREAK() {
      return BREAK;
    },
    get CARET() {
      return CARET;
    },
    get CARET_EQUAL() {
      return CARET_EQUAL;
    },
    get CASE() {
      return CASE;
    },
    get CATCH() {
      return CATCH;
    },
    get CLASS() {
      return CLASS;
    },
    get CLOSE_ANGLE() {
      return CLOSE_ANGLE;
    },
    get CLOSE_CURLY() {
      return CLOSE_CURLY;
    },
    get CLOSE_PAREN() {
      return CLOSE_PAREN;
    },
    get CLOSE_SQUARE() {
      return CLOSE_SQUARE;
    },
    get COLON() {
      return COLON;
    },
    get COMMA() {
      return COMMA;
    },
    get CONST() {
      return CONST;
    },
    get CONTINUE() {
      return CONTINUE;
    },
    get DEBUGGER() {
      return DEBUGGER;
    },
    get DEFAULT() {
      return DEFAULT;
    },
    get DELETE() {
      return DELETE;
    },
    get DO() {
      return DO;
    },
    get DOT_DOT_DOT() {
      return DOT_DOT_DOT;
    },
    get ELSE() {
      return ELSE;
    },
    get END_OF_FILE() {
      return END_OF_FILE;
    },
    get ENUM() {
      return ENUM;
    },
    get EQUAL() {
      return EQUAL;
    },
    get EQUAL_EQUAL() {
      return EQUAL_EQUAL;
    },
    get EQUAL_EQUAL_EQUAL() {
      return EQUAL_EQUAL_EQUAL;
    },
    get ERROR() {
      return ERROR;
    },
    get EXPORT() {
      return EXPORT;
    },
    get EXTENDS() {
      return EXTENDS;
    },
    get FALSE() {
      return FALSE;
    },
    get FINALLY() {
      return FINALLY;
    },
    get FOR() {
      return FOR;
    },
    get FUNCTION() {
      return FUNCTION;
    },
    get GREATER_EQUAL() {
      return GREATER_EQUAL;
    },
    get IDENTIFIER() {
      return IDENTIFIER;
    },
    get IF() {
      return IF;
    },
    get IMPLEMENTS() {
      return IMPLEMENTS;
    },
    get IMPORT() {
      return IMPORT;
    },
    get IN() {
      return IN;
    },
    get INSTANCEOF() {
      return INSTANCEOF;
    },
    get INTERFACE() {
      return INTERFACE;
    },
    get JSX_IDENTIFIER() {
      return JSX_IDENTIFIER;
    },
    get LEFT_SHIFT() {
      return LEFT_SHIFT;
    },
    get LEFT_SHIFT_EQUAL() {
      return LEFT_SHIFT_EQUAL;
    },
    get LESS_EQUAL() {
      return LESS_EQUAL;
    },
    get LET() {
      return LET;
    },
    get MINUS() {
      return MINUS;
    },
    get MINUS_EQUAL() {
      return MINUS_EQUAL;
    },
    get MINUS_MINUS() {
      return MINUS_MINUS;
    },
    get NEW() {
      return NEW;
    },
    get NO_SUBSTITUTION_TEMPLATE() {
      return NO_SUBSTITUTION_TEMPLATE;
    },
    get NOT_EQUAL() {
      return NOT_EQUAL;
    },
    get NOT_EQUAL_EQUAL() {
      return NOT_EQUAL_EQUAL;
    },
    get NULL() {
      return NULL;
    },
    get NUMBER() {
      return NUMBER;
    },
    get OPEN_ANGLE() {
      return OPEN_ANGLE;
    },
    get OPEN_CURLY() {
      return OPEN_CURLY;
    },
    get OPEN_PAREN() {
      return OPEN_PAREN;
    },
    get OPEN_SQUARE() {
      return OPEN_SQUARE;
    },
    get OR() {
      return OR;
    },
    get PACKAGE() {
      return PACKAGE;
    },
    get PERCENT() {
      return PERCENT;
    },
    get PERCENT_EQUAL() {
      return PERCENT_EQUAL;
    },
    get PERIOD() {
      return PERIOD;
    },
    get PLUS() {
      return PLUS;
    },
    get PLUS_EQUAL() {
      return PLUS_EQUAL;
    },
    get PLUS_PLUS() {
      return PLUS_PLUS;
    },
    get PRIVATE() {
      return PRIVATE;
    },
    get PROTECTED() {
      return PROTECTED;
    },
    get PUBLIC() {
      return PUBLIC;
    },
    get QUESTION() {
      return QUESTION;
    },
    get REGULAR_EXPRESSION() {
      return REGULAR_EXPRESSION;
    },
    get RETURN() {
      return RETURN;
    },
    get RIGHT_SHIFT() {
      return RIGHT_SHIFT;
    },
    get RIGHT_SHIFT_EQUAL() {
      return RIGHT_SHIFT_EQUAL;
    },
    get SEMI_COLON() {
      return SEMI_COLON;
    },
    get SLASH() {
      return SLASH;
    },
    get SLASH_EQUAL() {
      return SLASH_EQUAL;
    },
    get STAR() {
      return STAR;
    },
    get STAR_EQUAL() {
      return STAR_EQUAL;
    },
    get STAR_STAR() {
      return STAR_STAR;
    },
    get STAR_STAR_EQUAL() {
      return STAR_STAR_EQUAL;
    },
    get STATIC() {
      return STATIC;
    },
    get STRING() {
      return STRING;
    },
    get SUPER() {
      return SUPER;
    },
    get SWITCH() {
      return SWITCH;
    },
    get TEMPLATE_HEAD() {
      return TEMPLATE_HEAD;
    },
    get TEMPLATE_MIDDLE() {
      return TEMPLATE_MIDDLE;
    },
    get TEMPLATE_TAIL() {
      return TEMPLATE_TAIL;
    },
    get THIS() {
      return THIS;
    },
    get THROW() {
      return THROW;
    },
    get TILDE() {
      return TILDE;
    },
    get TRUE() {
      return TRUE;
    },
    get TRY() {
      return TRY;
    },
    get TYPEOF() {
      return TYPEOF;
    },
    get UNSIGNED_RIGHT_SHIFT() {
      return UNSIGNED_RIGHT_SHIFT;
    },
    get UNSIGNED_RIGHT_SHIFT_EQUAL() {
      return UNSIGNED_RIGHT_SHIFT_EQUAL;
    },
    get VAR() {
      return VAR;
    },
    get VOID() {
      return VOID;
    },
    get WHILE() {
      return WHILE;
    },
    get WITH() {
      return WITH;
    },
    get YIELD() {
      return YIELD;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/Token.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/Token.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TokenType.js", "traceur@0.0.108/src/syntax/Token.js")),
      AMPERSAND_EQUAL = $__1.AMPERSAND_EQUAL,
      BAR_EQUAL = $__1.BAR_EQUAL,
      CARET_EQUAL = $__1.CARET_EQUAL,
      EQUAL = $__1.EQUAL,
      LEFT_SHIFT_EQUAL = $__1.LEFT_SHIFT_EQUAL,
      MINUS_EQUAL = $__1.MINUS_EQUAL,
      PERCENT_EQUAL = $__1.PERCENT_EQUAL,
      PLUS_EQUAL = $__1.PLUS_EQUAL,
      RIGHT_SHIFT_EQUAL = $__1.RIGHT_SHIFT_EQUAL,
      SLASH_EQUAL = $__1.SLASH_EQUAL,
      STAR_EQUAL = $__1.STAR_EQUAL,
      STAR_STAR_EQUAL = $__1.STAR_STAR_EQUAL,
      UNSIGNED_RIGHT_SHIFT_EQUAL = $__1.UNSIGNED_RIGHT_SHIFT_EQUAL;
  var Token = function() {
    function Token(type, location) {
      this.type = type;
      this.location = location;
    }
    return ($traceurRuntime.createClass)(Token, {
      toString: function() {
        return this.type;
      },
      isAssignmentOperator: function() {
        return isAssignmentOperator(this.type);
      },
      isKeyword: function() {
        return false;
      },
      isStrictKeyword: function() {
        return false;
      }
    }, {});
  }();
  function isAssignmentOperator(type) {
    switch (type) {
      case AMPERSAND_EQUAL:
      case BAR_EQUAL:
      case CARET_EQUAL:
      case EQUAL:
      case LEFT_SHIFT_EQUAL:
      case MINUS_EQUAL:
      case PERCENT_EQUAL:
      case PLUS_EQUAL:
      case RIGHT_SHIFT_EQUAL:
      case SLASH_EQUAL:
      case STAR_EQUAL:
      case STAR_STAR_EQUAL:
      case UNSIGNED_RIGHT_SHIFT_EQUAL:
        return true;
    }
    return false;
  }
  return {
    get Token() {
      return Token;
    },
    get isAssignmentOperator() {
      return isAssignmentOperator;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/util/JSON.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/util/JSON.js";
  function transform(v) {
    var replacer = arguments[1] !== (void 0) ? arguments[1] : function(k, v) {
      return v;
    };
    return transform_(replacer('', v), replacer);
  }
  function transform_(v, replacer) {
    var rv,
        tv;
    if (Array.isArray(v)) {
      var len = v.length;
      rv = Array(len);
      for (var i = 0; i < len; i++) {
        tv = transform_(replacer(String(i), v[i]), replacer);
        rv[i] = tv === undefined ? null : tv;
      }
      return rv;
    }
    if (v instanceof Object) {
      rv = {};
      Object.keys(v).forEach(function(k) {
        tv = transform_(replacer(k, v[k]), replacer);
        if (tv !== undefined) {
          rv[k] = tv;
        }
      });
      return rv;
    }
    return v;
  }
  return {get transform() {
      return transform;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/PredefinedName.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/PredefinedName.js";
  var $ARGUMENTS = '$arguments';
  var ANY = 'any';
  var APPLY = 'apply';
  var ARGUMENTS = 'arguments';
  var ARRAY = 'Array';
  var AS = 'as';
  var ASYNC = 'async';
  var ASYNC_STAR = 'async star';
  var AWAIT = 'await';
  var BIND = 'bind';
  var CALL = 'call';
  var CONFIGURABLE = 'configurable';
  var CONSTRUCTOR = 'constructor';
  var CREATE = 'create';
  var CURRENT = 'current';
  var DEFINE_PROPERTY = 'defineProperty';
  var ENUMERABLE = 'enumerable';
  var FREEZE = 'freeze';
  var FROM = 'from';
  var FUNCTION = 'Function';
  var GET = 'get';
  var HAS = 'has';
  var LENGTH = 'length';
  var MODULE = 'module';
  var NEW = 'new';
  var OBJECT = 'Object';
  var OBJECT_NAME = 'Object';
  var OF = 'of';
  var ON = 'on';
  var PREVENT_EXTENSIONS = 'preventExtensions';
  var PROTOTYPE = 'prototype';
  var PUSH = 'push';
  var SET = 'set';
  var SLICE = 'slice';
  var THIS = 'this';
  var TRACEUR_RUNTIME = '$traceurRuntime';
  var TYPE = 'type';
  var UNDEFINED = 'undefined';
  var WRITABLE = 'writable';
  return {
    get $ARGUMENTS() {
      return $ARGUMENTS;
    },
    get ANY() {
      return ANY;
    },
    get APPLY() {
      return APPLY;
    },
    get ARGUMENTS() {
      return ARGUMENTS;
    },
    get ARRAY() {
      return ARRAY;
    },
    get AS() {
      return AS;
    },
    get ASYNC() {
      return ASYNC;
    },
    get ASYNC_STAR() {
      return ASYNC_STAR;
    },
    get AWAIT() {
      return AWAIT;
    },
    get BIND() {
      return BIND;
    },
    get CALL() {
      return CALL;
    },
    get CONFIGURABLE() {
      return CONFIGURABLE;
    },
    get CONSTRUCTOR() {
      return CONSTRUCTOR;
    },
    get CREATE() {
      return CREATE;
    },
    get CURRENT() {
      return CURRENT;
    },
    get DEFINE_PROPERTY() {
      return DEFINE_PROPERTY;
    },
    get ENUMERABLE() {
      return ENUMERABLE;
    },
    get FREEZE() {
      return FREEZE;
    },
    get FROM() {
      return FROM;
    },
    get FUNCTION() {
      return FUNCTION;
    },
    get GET() {
      return GET;
    },
    get HAS() {
      return HAS;
    },
    get LENGTH() {
      return LENGTH;
    },
    get MODULE() {
      return MODULE;
    },
    get NEW() {
      return NEW;
    },
    get OBJECT() {
      return OBJECT;
    },
    get OBJECT_NAME() {
      return OBJECT_NAME;
    },
    get OF() {
      return OF;
    },
    get ON() {
      return ON;
    },
    get PREVENT_EXTENSIONS() {
      return PREVENT_EXTENSIONS;
    },
    get PROTOTYPE() {
      return PROTOTYPE;
    },
    get PUSH() {
      return PUSH;
    },
    get SET() {
      return SET;
    },
    get SLICE() {
      return SLICE;
    },
    get THIS() {
      return THIS;
    },
    get TRACEUR_RUNTIME() {
      return TRACEUR_RUNTIME;
    },
    get TYPE() {
      return TYPE;
    },
    get UNDEFINED() {
      return UNDEFINED;
    },
    get WRITABLE() {
      return WRITABLE;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/trees/ParseTree.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/trees/ParseTree.js";
  var ParseTreeType = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeType.js", "traceur@0.0.108/src/syntax/trees/ParseTree.js"));
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../TokenType.js", "traceur@0.0.108/src/syntax/trees/ParseTree.js")),
      IDENTIFIER = $__2.IDENTIFIER,
      STAR = $__2.STAR,
      STRING = $__2.STRING,
      VAR = $__2.VAR;
  var Token = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../Token.js", "traceur@0.0.108/src/syntax/trees/ParseTree.js")).Token;
  var utilJSON = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../util/JSON.js", "traceur@0.0.108/src/syntax/trees/ParseTree.js"));
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../PredefinedName.js", "traceur@0.0.108/src/syntax/trees/ParseTree.js")),
      ASYNC = $__4.ASYNC,
      ASYNC_STAR = $__4.ASYNC_STAR;
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeType.js", "traceur@0.0.108/src/syntax/trees/ParseTree.js")),
      ARRAY_COMPREHENSION = $__5.ARRAY_COMPREHENSION,
      ARRAY_LITERAL = $__5.ARRAY_LITERAL,
      ARRAY_PATTERN = $__5.ARRAY_PATTERN,
      ARROW_FUNCTION = $__5.ARROW_FUNCTION,
      AWAIT_EXPRESSION = $__5.AWAIT_EXPRESSION,
      BINARY_EXPRESSION = $__5.BINARY_EXPRESSION,
      BINDING_IDENTIFIER = $__5.BINDING_IDENTIFIER,
      BLOCK = $__5.BLOCK,
      BREAK_STATEMENT = $__5.BREAK_STATEMENT,
      CALL_EXPRESSION = $__5.CALL_EXPRESSION,
      CLASS_DECLARATION = $__5.CLASS_DECLARATION,
      CLASS_EXPRESSION = $__5.CLASS_EXPRESSION,
      COMMA_EXPRESSION = $__5.COMMA_EXPRESSION,
      CONDITIONAL_EXPRESSION = $__5.CONDITIONAL_EXPRESSION,
      CONSTRUCTOR_TYPE = $__5.CONSTRUCTOR_TYPE,
      CONTINUE_STATEMENT = $__5.CONTINUE_STATEMENT,
      DEBUGGER_STATEMENT = $__5.DEBUGGER_STATEMENT,
      DO_WHILE_STATEMENT = $__5.DO_WHILE_STATEMENT,
      EMPTY_STATEMENT = $__5.EMPTY_STATEMENT,
      EXPORT_DECLARATION = $__5.EXPORT_DECLARATION,
      EXPRESSION_STATEMENT = $__5.EXPRESSION_STATEMENT,
      FOR_IN_STATEMENT = $__5.FOR_IN_STATEMENT,
      FOR_OF_STATEMENT = $__5.FOR_OF_STATEMENT,
      FOR_ON_STATEMENT = $__5.FOR_ON_STATEMENT,
      FOR_STATEMENT = $__5.FOR_STATEMENT,
      FORMAL_PARAMETER = $__5.FORMAL_PARAMETER,
      FUNCTION_DECLARATION = $__5.FUNCTION_DECLARATION,
      FUNCTION_EXPRESSION = $__5.FUNCTION_EXPRESSION,
      FUNCTION_TYPE = $__5.FUNCTION_TYPE,
      GENERATOR_COMPREHENSION = $__5.GENERATOR_COMPREHENSION,
      IDENTIFIER_EXPRESSION = $__5.IDENTIFIER_EXPRESSION,
      IF_STATEMENT = $__5.IF_STATEMENT,
      IMPORT_DECLARATION = $__5.IMPORT_DECLARATION,
      IMPORTED_BINDING = $__5.IMPORTED_BINDING,
      INTERFACE_DECLARATION = $__5.INTERFACE_DECLARATION,
      JSX_ELEMENT = $__5.JSX_ELEMENT,
      LABELLED_STATEMENT = $__5.LABELLED_STATEMENT,
      LITERAL_EXPRESSION = $__5.LITERAL_EXPRESSION,
      LITERAL_PROPERTY_NAME = $__5.LITERAL_PROPERTY_NAME,
      MEMBER_EXPRESSION = $__5.MEMBER_EXPRESSION,
      MEMBER_LOOKUP_EXPRESSION = $__5.MEMBER_LOOKUP_EXPRESSION,
      NEW_EXPRESSION = $__5.NEW_EXPRESSION,
      OBJECT_LITERAL = $__5.OBJECT_LITERAL,
      OBJECT_PATTERN = $__5.OBJECT_PATTERN,
      OBJECT_TYPE = $__5.OBJECT_TYPE,
      PAREN_EXPRESSION = $__5.PAREN_EXPRESSION,
      POSTFIX_EXPRESSION = $__5.POSTFIX_EXPRESSION,
      PREDEFINED_TYPE = $__5.PREDEFINED_TYPE,
      PROPERTY_NAME_SHORTHAND = $__5.PROPERTY_NAME_SHORTHAND,
      REST_PARAMETER = $__5.REST_PARAMETER,
      RETURN_STATEMENT = $__5.RETURN_STATEMENT,
      SPREAD_EXPRESSION = $__5.SPREAD_EXPRESSION,
      SPREAD_PATTERN_ELEMENT = $__5.SPREAD_PATTERN_ELEMENT,
      SUPER_EXPRESSION = $__5.SUPER_EXPRESSION,
      SWITCH_STATEMENT = $__5.SWITCH_STATEMENT,
      TEMPLATE_LITERAL_EXPRESSION = $__5.TEMPLATE_LITERAL_EXPRESSION,
      THIS_EXPRESSION = $__5.THIS_EXPRESSION,
      THROW_STATEMENT = $__5.THROW_STATEMENT,
      TRY_STATEMENT = $__5.TRY_STATEMENT,
      TYPE_ALIAS_DECLARATION = $__5.TYPE_ALIAS_DECLARATION,
      TYPE_NAME = $__5.TYPE_NAME,
      TYPE_REFERENCE = $__5.TYPE_REFERENCE,
      UNARY_EXPRESSION = $__5.UNARY_EXPRESSION,
      VARIABLE_DECLARATION = $__5.VARIABLE_DECLARATION,
      VARIABLE_STATEMENT = $__5.VARIABLE_STATEMENT,
      WHILE_STATEMENT = $__5.WHILE_STATEMENT,
      WITH_STATEMENT = $__5.WITH_STATEMENT,
      YIELD_EXPRESSION = $__5.YIELD_EXPRESSION;
  var ParseTree = function() {
    function ParseTree(location) {
      this.location = location;
    }
    return ($traceurRuntime.createClass)(ParseTree, {
      isPattern: function() {
        switch (this.type) {
          case ARRAY_PATTERN:
          case OBJECT_PATTERN:
            return true;
          default:
            return false;
        }
      },
      isLeftHandSideExpression: function() {
        switch (this.type) {
          case ARRAY_PATTERN:
          case IDENTIFIER_EXPRESSION:
          case MEMBER_EXPRESSION:
          case MEMBER_LOOKUP_EXPRESSION:
          case OBJECT_PATTERN:
            return true;
          case PAREN_EXPRESSION:
            return this.expression.isLeftHandSideExpression();
          default:
            return false;
        }
      },
      isAssignmentExpression: function() {
        switch (this.type) {
          case ARRAY_COMPREHENSION:
          case ARRAY_LITERAL:
          case ARROW_FUNCTION:
          case AWAIT_EXPRESSION:
          case BINARY_EXPRESSION:
          case CALL_EXPRESSION:
          case CLASS_EXPRESSION:
          case CONDITIONAL_EXPRESSION:
          case FUNCTION_EXPRESSION:
          case GENERATOR_COMPREHENSION:
          case IDENTIFIER_EXPRESSION:
          case JSX_ELEMENT:
          case LITERAL_EXPRESSION:
          case MEMBER_EXPRESSION:
          case MEMBER_LOOKUP_EXPRESSION:
          case NEW_EXPRESSION:
          case OBJECT_LITERAL:
          case PAREN_EXPRESSION:
          case POSTFIX_EXPRESSION:
          case TEMPLATE_LITERAL_EXPRESSION:
          case SUPER_EXPRESSION:
          case THIS_EXPRESSION:
          case UNARY_EXPRESSION:
          case YIELD_EXPRESSION:
            return true;
          default:
            return false;
        }
      },
      isMemberExpression: function() {
        switch (this.type) {
          case THIS_EXPRESSION:
          case CLASS_EXPRESSION:
          case SUPER_EXPRESSION:
          case IDENTIFIER_EXPRESSION:
          case JSX_ELEMENT:
          case LITERAL_EXPRESSION:
          case ARRAY_LITERAL:
          case OBJECT_LITERAL:
          case PAREN_EXPRESSION:
          case TEMPLATE_LITERAL_EXPRESSION:
          case FUNCTION_EXPRESSION:
          case MEMBER_LOOKUP_EXPRESSION:
          case MEMBER_EXPRESSION:
          case CALL_EXPRESSION:
            return true;
          case NEW_EXPRESSION:
            return this.args !== null;
        }
        return false;
      },
      isExpression: function() {
        return this.isAssignmentExpression() || this.type === COMMA_EXPRESSION;
      },
      isAssignmentOrSpread: function() {
        return this.isAssignmentExpression() || this.type === SPREAD_EXPRESSION;
      },
      isRestParameter: function() {
        return this.type === REST_PARAMETER || (this.type === FORMAL_PARAMETER && this.parameter.isRestParameter());
      },
      isSpreadPatternElement: function() {
        return this.type === SPREAD_PATTERN_ELEMENT;
      },
      isStatementListItem: function() {
        return this.isStatement() || this.isDeclaration() || this.type === TYPE_ALIAS_DECLARATION;
      },
      isStatement: function() {
        switch (this.type) {
          case BLOCK:
          case VARIABLE_STATEMENT:
          case EMPTY_STATEMENT:
          case EXPRESSION_STATEMENT:
          case IF_STATEMENT:
          case CONTINUE_STATEMENT:
          case BREAK_STATEMENT:
          case RETURN_STATEMENT:
          case WITH_STATEMENT:
          case LABELLED_STATEMENT:
          case THROW_STATEMENT:
          case TRY_STATEMENT:
          case DEBUGGER_STATEMENT:
            return true;
        }
        return this.isBreakableStatement();
      },
      isDeclaration: function() {
        switch (this.type) {
          case FUNCTION_DECLARATION:
          case CLASS_DECLARATION:
            return true;
        }
        return this.isLexicalDeclaration();
      },
      isLexicalDeclaration: function() {
        switch (this.type) {
          case VARIABLE_STATEMENT:
            return this.declarations.declarationType !== VAR;
        }
        return false;
      },
      isBreakableStatement: function() {
        switch (this.type) {
          case SWITCH_STATEMENT:
            return true;
        }
        return this.isIterationStatement();
      },
      isIterationStatement: function() {
        switch (this.type) {
          case DO_WHILE_STATEMENT:
          case FOR_IN_STATEMENT:
          case FOR_OF_STATEMENT:
          case FOR_ON_STATEMENT:
          case FOR_STATEMENT:
          case WHILE_STATEMENT:
            return true;
        }
        return false;
      },
      isScriptElement: function() {
        switch (this.type) {
          case CLASS_DECLARATION:
          case EXPORT_DECLARATION:
          case FUNCTION_DECLARATION:
          case IMPORT_DECLARATION:
          case INTERFACE_DECLARATION:
          case VARIABLE_DECLARATION:
          case TYPE_ALIAS_DECLARATION:
            return true;
        }
        return this.isStatement();
      },
      isGenerator: function() {
        return this.functionKind !== null && this.functionKind.type === STAR;
      },
      isAsyncFunction: function() {
        return this.functionKind !== null && this.functionKind.type === IDENTIFIER && this.functionKind.value === ASYNC;
      },
      isAsyncGenerator: function() {
        return this.functionKind !== null && this.functionKind.type === IDENTIFIER && this.functionKind.value === ASYNC_STAR;
      },
      isType: function() {
        switch (this.type) {
          case CONSTRUCTOR_TYPE:
          case FUNCTION_TYPE:
          case OBJECT_TYPE:
          case PREDEFINED_TYPE:
          case TYPE_NAME:
          case TYPE_REFERENCE:
            return true;
        }
        return false;
      },
      getDirectivePrologueStringToken_: function() {
        var tree = this;
        if (tree.type !== EXPRESSION_STATEMENT || !(tree = tree.expression))
          return null;
        if (tree.type !== LITERAL_EXPRESSION || !(tree = tree.literalToken))
          return null;
        if (tree.type !== STRING)
          return null;
        return tree;
      },
      isDirectivePrologue: function() {
        return this.getDirectivePrologueStringToken_() !== null;
      },
      isUseStrictDirective: function() {
        var token = this.getDirectivePrologueStringToken_();
        if (!token)
          return false;
        var v = token.value;
        return v === '"use strict"' || v === "'use strict'";
      },
      toJSON: function() {
        return utilJSON.transform(this, ParseTree.replacer);
      },
      stringify: function() {
        var indent = arguments[0] !== (void 0) ? arguments[0] : 2;
        return JSON.stringify(this, ParseTree.replacer, indent);
      },
      getStringValue: function() {
        switch (this.type) {
          case IDENTIFIER_EXPRESSION:
          case BINDING_IDENTIFIER:
            return this.identifierToken.toString();
          case IMPORTED_BINDING:
            return this.binding.getStringValue();
          case PROPERTY_NAME_SHORTHAND:
            return this.name.toString();
          case LITERAL_PROPERTY_NAME:
            return this.literalToken.toString();
        }
        throw new Error('Not yet implemented');
      }
    }, {
      stripLocation: function(key, value) {
        if (key === 'location') {
          return undefined;
        }
        return value;
      },
      replacer: function(k, v) {
        if (v instanceof ParseTree || v instanceof Token) {
          var rv = {type: v.type};
          Object.keys(v).forEach(function(name) {
            if (name !== 'location')
              rv[name] = v[name];
          });
          return rv;
        }
        return v;
      }
    });
  }();
  return {
    get ParseTreeType() {
      return ParseTreeType;
    },
    get ParseTree() {
      return ParseTree;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/trees/ParseTrees.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/trees/ParseTrees.js";
  var ParseTree = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTree.js", "traceur@0.0.108/src/syntax/trees/ParseTrees.js")).ParseTree;
  var ParseTreeType = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeType.js", "traceur@0.0.108/src/syntax/trees/ParseTrees.js"));
  var ANNOTATION = ParseTreeType.ANNOTATION;
  var Annotation = function($__super) {
    function Annotation(location, name, args) {
      $traceurRuntime.superConstructor(Annotation).call(this, location);
      this.name = name;
      this.args = args;
    }
    return ($traceurRuntime.createClass)(Annotation, {
      transform: function(transformer) {
        return transformer.transformAnnotation(this);
      },
      visit: function(visitor) {
        visitor.visitAnnotation(this);
      },
      get type() {
        return ANNOTATION;
      }
    }, {}, $__super);
  }(ParseTree);
  var ANON_BLOCK = ParseTreeType.ANON_BLOCK;
  var AnonBlock = function($__super) {
    function AnonBlock(location, statements) {
      $traceurRuntime.superConstructor(AnonBlock).call(this, location);
      this.statements = statements;
    }
    return ($traceurRuntime.createClass)(AnonBlock, {
      transform: function(transformer) {
        return transformer.transformAnonBlock(this);
      },
      visit: function(visitor) {
        visitor.visitAnonBlock(this);
      },
      get type() {
        return ANON_BLOCK;
      }
    }, {}, $__super);
  }(ParseTree);
  var ARGUMENT_LIST = ParseTreeType.ARGUMENT_LIST;
  var ArgumentList = function($__super) {
    function ArgumentList(location, args) {
      $traceurRuntime.superConstructor(ArgumentList).call(this, location);
      this.args = args;
    }
    return ($traceurRuntime.createClass)(ArgumentList, {
      transform: function(transformer) {
        return transformer.transformArgumentList(this);
      },
      visit: function(visitor) {
        visitor.visitArgumentList(this);
      },
      get type() {
        return ARGUMENT_LIST;
      }
    }, {}, $__super);
  }(ParseTree);
  var ARRAY_COMPREHENSION = ParseTreeType.ARRAY_COMPREHENSION;
  var ArrayComprehension = function($__super) {
    function ArrayComprehension(location, comprehensionList, expression) {
      $traceurRuntime.superConstructor(ArrayComprehension).call(this, location);
      this.comprehensionList = comprehensionList;
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(ArrayComprehension, {
      transform: function(transformer) {
        return transformer.transformArrayComprehension(this);
      },
      visit: function(visitor) {
        visitor.visitArrayComprehension(this);
      },
      get type() {
        return ARRAY_COMPREHENSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var ARRAY_LITERAL = ParseTreeType.ARRAY_LITERAL;
  var ArrayLiteral = function($__super) {
    function ArrayLiteral(location, elements) {
      $traceurRuntime.superConstructor(ArrayLiteral).call(this, location);
      this.elements = elements;
    }
    return ($traceurRuntime.createClass)(ArrayLiteral, {
      transform: function(transformer) {
        return transformer.transformArrayLiteral(this);
      },
      visit: function(visitor) {
        visitor.visitArrayLiteral(this);
      },
      get type() {
        return ARRAY_LITERAL;
      }
    }, {}, $__super);
  }(ParseTree);
  var ARRAY_PATTERN = ParseTreeType.ARRAY_PATTERN;
  var ArrayPattern = function($__super) {
    function ArrayPattern(location, elements) {
      $traceurRuntime.superConstructor(ArrayPattern).call(this, location);
      this.elements = elements;
    }
    return ($traceurRuntime.createClass)(ArrayPattern, {
      transform: function(transformer) {
        return transformer.transformArrayPattern(this);
      },
      visit: function(visitor) {
        visitor.visitArrayPattern(this);
      },
      get type() {
        return ARRAY_PATTERN;
      }
    }, {}, $__super);
  }(ParseTree);
  var ARRAY_TYPE = ParseTreeType.ARRAY_TYPE;
  var ArrayType = function($__super) {
    function ArrayType(location, elementType) {
      $traceurRuntime.superConstructor(ArrayType).call(this, location);
      this.elementType = elementType;
    }
    return ($traceurRuntime.createClass)(ArrayType, {
      transform: function(transformer) {
        return transformer.transformArrayType(this);
      },
      visit: function(visitor) {
        visitor.visitArrayType(this);
      },
      get type() {
        return ARRAY_TYPE;
      }
    }, {}, $__super);
  }(ParseTree);
  var ARROW_FUNCTION = ParseTreeType.ARROW_FUNCTION;
  var ArrowFunction = function($__super) {
    function ArrowFunction(location, functionKind, parameterList, body) {
      $traceurRuntime.superConstructor(ArrowFunction).call(this, location);
      this.functionKind = functionKind;
      this.parameterList = parameterList;
      this.body = body;
    }
    return ($traceurRuntime.createClass)(ArrowFunction, {
      transform: function(transformer) {
        return transformer.transformArrowFunction(this);
      },
      visit: function(visitor) {
        visitor.visitArrowFunction(this);
      },
      get type() {
        return ARROW_FUNCTION;
      }
    }, {}, $__super);
  }(ParseTree);
  var ASSIGNMENT_ELEMENT = ParseTreeType.ASSIGNMENT_ELEMENT;
  var AssignmentElement = function($__super) {
    function AssignmentElement(location, assignment, initializer) {
      $traceurRuntime.superConstructor(AssignmentElement).call(this, location);
      this.assignment = assignment;
      this.initializer = initializer;
    }
    return ($traceurRuntime.createClass)(AssignmentElement, {
      transform: function(transformer) {
        return transformer.transformAssignmentElement(this);
      },
      visit: function(visitor) {
        visitor.visitAssignmentElement(this);
      },
      get type() {
        return ASSIGNMENT_ELEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var AWAIT_EXPRESSION = ParseTreeType.AWAIT_EXPRESSION;
  var AwaitExpression = function($__super) {
    function AwaitExpression(location, expression) {
      $traceurRuntime.superConstructor(AwaitExpression).call(this, location);
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(AwaitExpression, {
      transform: function(transformer) {
        return transformer.transformAwaitExpression(this);
      },
      visit: function(visitor) {
        visitor.visitAwaitExpression(this);
      },
      get type() {
        return AWAIT_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var BINARY_EXPRESSION = ParseTreeType.BINARY_EXPRESSION;
  var BinaryExpression = function($__super) {
    function BinaryExpression(location, left, operator, right) {
      $traceurRuntime.superConstructor(BinaryExpression).call(this, location);
      this.left = left;
      this.operator = operator;
      this.right = right;
    }
    return ($traceurRuntime.createClass)(BinaryExpression, {
      transform: function(transformer) {
        return transformer.transformBinaryExpression(this);
      },
      visit: function(visitor) {
        visitor.visitBinaryExpression(this);
      },
      get type() {
        return BINARY_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var BINDING_ELEMENT = ParseTreeType.BINDING_ELEMENT;
  var BindingElement = function($__super) {
    function BindingElement(location, binding, initializer) {
      $traceurRuntime.superConstructor(BindingElement).call(this, location);
      this.binding = binding;
      this.initializer = initializer;
    }
    return ($traceurRuntime.createClass)(BindingElement, {
      transform: function(transformer) {
        return transformer.transformBindingElement(this);
      },
      visit: function(visitor) {
        visitor.visitBindingElement(this);
      },
      get type() {
        return BINDING_ELEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var BINDING_IDENTIFIER = ParseTreeType.BINDING_IDENTIFIER;
  var BindingIdentifier = function($__super) {
    function BindingIdentifier(location, identifierToken) {
      $traceurRuntime.superConstructor(BindingIdentifier).call(this, location);
      this.identifierToken = identifierToken;
    }
    return ($traceurRuntime.createClass)(BindingIdentifier, {
      transform: function(transformer) {
        return transformer.transformBindingIdentifier(this);
      },
      visit: function(visitor) {
        visitor.visitBindingIdentifier(this);
      },
      get type() {
        return BINDING_IDENTIFIER;
      }
    }, {}, $__super);
  }(ParseTree);
  var BLOCK = ParseTreeType.BLOCK;
  var Block = function($__super) {
    function Block(location, statements) {
      $traceurRuntime.superConstructor(Block).call(this, location);
      this.statements = statements;
    }
    return ($traceurRuntime.createClass)(Block, {
      transform: function(transformer) {
        return transformer.transformBlock(this);
      },
      visit: function(visitor) {
        visitor.visitBlock(this);
      },
      get type() {
        return BLOCK;
      }
    }, {}, $__super);
  }(ParseTree);
  var BREAK_STATEMENT = ParseTreeType.BREAK_STATEMENT;
  var BreakStatement = function($__super) {
    function BreakStatement(location, name) {
      $traceurRuntime.superConstructor(BreakStatement).call(this, location);
      this.name = name;
    }
    return ($traceurRuntime.createClass)(BreakStatement, {
      transform: function(transformer) {
        return transformer.transformBreakStatement(this);
      },
      visit: function(visitor) {
        visitor.visitBreakStatement(this);
      },
      get type() {
        return BREAK_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var CALL_EXPRESSION = ParseTreeType.CALL_EXPRESSION;
  var CallExpression = function($__super) {
    function CallExpression(location, operand, args) {
      $traceurRuntime.superConstructor(CallExpression).call(this, location);
      this.operand = operand;
      this.args = args;
    }
    return ($traceurRuntime.createClass)(CallExpression, {
      transform: function(transformer) {
        return transformer.transformCallExpression(this);
      },
      visit: function(visitor) {
        visitor.visitCallExpression(this);
      },
      get type() {
        return CALL_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var CALL_SIGNATURE = ParseTreeType.CALL_SIGNATURE;
  var CallSignature = function($__super) {
    function CallSignature(location, typeParameters, parameterList, returnType) {
      $traceurRuntime.superConstructor(CallSignature).call(this, location);
      this.typeParameters = typeParameters;
      this.parameterList = parameterList;
      this.returnType = returnType;
    }
    return ($traceurRuntime.createClass)(CallSignature, {
      transform: function(transformer) {
        return transformer.transformCallSignature(this);
      },
      visit: function(visitor) {
        visitor.visitCallSignature(this);
      },
      get type() {
        return CALL_SIGNATURE;
      }
    }, {}, $__super);
  }(ParseTree);
  var CASE_CLAUSE = ParseTreeType.CASE_CLAUSE;
  var CaseClause = function($__super) {
    function CaseClause(location, expression, statements) {
      $traceurRuntime.superConstructor(CaseClause).call(this, location);
      this.expression = expression;
      this.statements = statements;
    }
    return ($traceurRuntime.createClass)(CaseClause, {
      transform: function(transformer) {
        return transformer.transformCaseClause(this);
      },
      visit: function(visitor) {
        visitor.visitCaseClause(this);
      },
      get type() {
        return CASE_CLAUSE;
      }
    }, {}, $__super);
  }(ParseTree);
  var CATCH = ParseTreeType.CATCH;
  var Catch = function($__super) {
    function Catch(location, binding, catchBody) {
      $traceurRuntime.superConstructor(Catch).call(this, location);
      this.binding = binding;
      this.catchBody = catchBody;
    }
    return ($traceurRuntime.createClass)(Catch, {
      transform: function(transformer) {
        return transformer.transformCatch(this);
      },
      visit: function(visitor) {
        visitor.visitCatch(this);
      },
      get type() {
        return CATCH;
      }
    }, {}, $__super);
  }(ParseTree);
  var CLASS_DECLARATION = ParseTreeType.CLASS_DECLARATION;
  var ClassDeclaration = function($__super) {
    function ClassDeclaration(location, name, superClass, elements, annotations, typeParameters) {
      $traceurRuntime.superConstructor(ClassDeclaration).call(this, location);
      this.name = name;
      this.superClass = superClass;
      this.elements = elements;
      this.annotations = annotations;
      this.typeParameters = typeParameters;
    }
    return ($traceurRuntime.createClass)(ClassDeclaration, {
      transform: function(transformer) {
        return transformer.transformClassDeclaration(this);
      },
      visit: function(visitor) {
        visitor.visitClassDeclaration(this);
      },
      get type() {
        return CLASS_DECLARATION;
      }
    }, {}, $__super);
  }(ParseTree);
  var CLASS_EXPRESSION = ParseTreeType.CLASS_EXPRESSION;
  var ClassExpression = function($__super) {
    function ClassExpression(location, name, superClass, elements, annotations, typeParameters) {
      $traceurRuntime.superConstructor(ClassExpression).call(this, location);
      this.name = name;
      this.superClass = superClass;
      this.elements = elements;
      this.annotations = annotations;
      this.typeParameters = typeParameters;
    }
    return ($traceurRuntime.createClass)(ClassExpression, {
      transform: function(transformer) {
        return transformer.transformClassExpression(this);
      },
      visit: function(visitor) {
        visitor.visitClassExpression(this);
      },
      get type() {
        return CLASS_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var COMMA_EXPRESSION = ParseTreeType.COMMA_EXPRESSION;
  var CommaExpression = function($__super) {
    function CommaExpression(location, expressions) {
      $traceurRuntime.superConstructor(CommaExpression).call(this, location);
      this.expressions = expressions;
    }
    return ($traceurRuntime.createClass)(CommaExpression, {
      transform: function(transformer) {
        return transformer.transformCommaExpression(this);
      },
      visit: function(visitor) {
        visitor.visitCommaExpression(this);
      },
      get type() {
        return COMMA_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var COMPREHENSION_FOR = ParseTreeType.COMPREHENSION_FOR;
  var ComprehensionFor = function($__super) {
    function ComprehensionFor(location, left, iterator) {
      $traceurRuntime.superConstructor(ComprehensionFor).call(this, location);
      this.left = left;
      this.iterator = iterator;
    }
    return ($traceurRuntime.createClass)(ComprehensionFor, {
      transform: function(transformer) {
        return transformer.transformComprehensionFor(this);
      },
      visit: function(visitor) {
        visitor.visitComprehensionFor(this);
      },
      get type() {
        return COMPREHENSION_FOR;
      }
    }, {}, $__super);
  }(ParseTree);
  var COMPREHENSION_IF = ParseTreeType.COMPREHENSION_IF;
  var ComprehensionIf = function($__super) {
    function ComprehensionIf(location, expression) {
      $traceurRuntime.superConstructor(ComprehensionIf).call(this, location);
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(ComprehensionIf, {
      transform: function(transformer) {
        return transformer.transformComprehensionIf(this);
      },
      visit: function(visitor) {
        visitor.visitComprehensionIf(this);
      },
      get type() {
        return COMPREHENSION_IF;
      }
    }, {}, $__super);
  }(ParseTree);
  var COMPUTED_PROPERTY_NAME = ParseTreeType.COMPUTED_PROPERTY_NAME;
  var ComputedPropertyName = function($__super) {
    function ComputedPropertyName(location, expression) {
      $traceurRuntime.superConstructor(ComputedPropertyName).call(this, location);
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(ComputedPropertyName, {
      transform: function(transformer) {
        return transformer.transformComputedPropertyName(this);
      },
      visit: function(visitor) {
        visitor.visitComputedPropertyName(this);
      },
      get type() {
        return COMPUTED_PROPERTY_NAME;
      }
    }, {}, $__super);
  }(ParseTree);
  var CONDITIONAL_EXPRESSION = ParseTreeType.CONDITIONAL_EXPRESSION;
  var ConditionalExpression = function($__super) {
    function ConditionalExpression(location, condition, left, right) {
      $traceurRuntime.superConstructor(ConditionalExpression).call(this, location);
      this.condition = condition;
      this.left = left;
      this.right = right;
    }
    return ($traceurRuntime.createClass)(ConditionalExpression, {
      transform: function(transformer) {
        return transformer.transformConditionalExpression(this);
      },
      visit: function(visitor) {
        visitor.visitConditionalExpression(this);
      },
      get type() {
        return CONDITIONAL_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var CONSTRUCT_SIGNATURE = ParseTreeType.CONSTRUCT_SIGNATURE;
  var ConstructSignature = function($__super) {
    function ConstructSignature(location, typeParameters, parameterList, returnType) {
      $traceurRuntime.superConstructor(ConstructSignature).call(this, location);
      this.typeParameters = typeParameters;
      this.parameterList = parameterList;
      this.returnType = returnType;
    }
    return ($traceurRuntime.createClass)(ConstructSignature, {
      transform: function(transformer) {
        return transformer.transformConstructSignature(this);
      },
      visit: function(visitor) {
        visitor.visitConstructSignature(this);
      },
      get type() {
        return CONSTRUCT_SIGNATURE;
      }
    }, {}, $__super);
  }(ParseTree);
  var CONSTRUCTOR_TYPE = ParseTreeType.CONSTRUCTOR_TYPE;
  var ConstructorType = function($__super) {
    function ConstructorType(location, typeParameters, parameterList, returnType) {
      $traceurRuntime.superConstructor(ConstructorType).call(this, location);
      this.typeParameters = typeParameters;
      this.parameterList = parameterList;
      this.returnType = returnType;
    }
    return ($traceurRuntime.createClass)(ConstructorType, {
      transform: function(transformer) {
        return transformer.transformConstructorType(this);
      },
      visit: function(visitor) {
        visitor.visitConstructorType(this);
      },
      get type() {
        return CONSTRUCTOR_TYPE;
      }
    }, {}, $__super);
  }(ParseTree);
  var CONTINUE_STATEMENT = ParseTreeType.CONTINUE_STATEMENT;
  var ContinueStatement = function($__super) {
    function ContinueStatement(location, name) {
      $traceurRuntime.superConstructor(ContinueStatement).call(this, location);
      this.name = name;
    }
    return ($traceurRuntime.createClass)(ContinueStatement, {
      transform: function(transformer) {
        return transformer.transformContinueStatement(this);
      },
      visit: function(visitor) {
        visitor.visitContinueStatement(this);
      },
      get type() {
        return CONTINUE_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var COVER_FORMALS = ParseTreeType.COVER_FORMALS;
  var CoverFormals = function($__super) {
    function CoverFormals(location, expressions) {
      $traceurRuntime.superConstructor(CoverFormals).call(this, location);
      this.expressions = expressions;
    }
    return ($traceurRuntime.createClass)(CoverFormals, {
      transform: function(transformer) {
        return transformer.transformCoverFormals(this);
      },
      visit: function(visitor) {
        visitor.visitCoverFormals(this);
      },
      get type() {
        return COVER_FORMALS;
      }
    }, {}, $__super);
  }(ParseTree);
  var COVER_INITIALIZED_NAME = ParseTreeType.COVER_INITIALIZED_NAME;
  var CoverInitializedName = function($__super) {
    function CoverInitializedName(location, name, equalToken, initializer) {
      $traceurRuntime.superConstructor(CoverInitializedName).call(this, location);
      this.name = name;
      this.equalToken = equalToken;
      this.initializer = initializer;
    }
    return ($traceurRuntime.createClass)(CoverInitializedName, {
      transform: function(transformer) {
        return transformer.transformCoverInitializedName(this);
      },
      visit: function(visitor) {
        visitor.visitCoverInitializedName(this);
      },
      get type() {
        return COVER_INITIALIZED_NAME;
      }
    }, {}, $__super);
  }(ParseTree);
  var DEBUGGER_STATEMENT = ParseTreeType.DEBUGGER_STATEMENT;
  var DebuggerStatement = function($__super) {
    function DebuggerStatement(location) {
      $traceurRuntime.superConstructor(DebuggerStatement).call(this, location);
    }
    return ($traceurRuntime.createClass)(DebuggerStatement, {
      transform: function(transformer) {
        return transformer.transformDebuggerStatement(this);
      },
      visit: function(visitor) {
        visitor.visitDebuggerStatement(this);
      },
      get type() {
        return DEBUGGER_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var DEFAULT_CLAUSE = ParseTreeType.DEFAULT_CLAUSE;
  var DefaultClause = function($__super) {
    function DefaultClause(location, statements) {
      $traceurRuntime.superConstructor(DefaultClause).call(this, location);
      this.statements = statements;
    }
    return ($traceurRuntime.createClass)(DefaultClause, {
      transform: function(transformer) {
        return transformer.transformDefaultClause(this);
      },
      visit: function(visitor) {
        visitor.visitDefaultClause(this);
      },
      get type() {
        return DEFAULT_CLAUSE;
      }
    }, {}, $__super);
  }(ParseTree);
  var DO_WHILE_STATEMENT = ParseTreeType.DO_WHILE_STATEMENT;
  var DoWhileStatement = function($__super) {
    function DoWhileStatement(location, body, condition) {
      $traceurRuntime.superConstructor(DoWhileStatement).call(this, location);
      this.body = body;
      this.condition = condition;
    }
    return ($traceurRuntime.createClass)(DoWhileStatement, {
      transform: function(transformer) {
        return transformer.transformDoWhileStatement(this);
      },
      visit: function(visitor) {
        visitor.visitDoWhileStatement(this);
      },
      get type() {
        return DO_WHILE_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var EMPTY_STATEMENT = ParseTreeType.EMPTY_STATEMENT;
  var EmptyStatement = function($__super) {
    function EmptyStatement(location) {
      $traceurRuntime.superConstructor(EmptyStatement).call(this, location);
    }
    return ($traceurRuntime.createClass)(EmptyStatement, {
      transform: function(transformer) {
        return transformer.transformEmptyStatement(this);
      },
      visit: function(visitor) {
        visitor.visitEmptyStatement(this);
      },
      get type() {
        return EMPTY_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var EXPORT_DECLARATION = ParseTreeType.EXPORT_DECLARATION;
  var ExportDeclaration = function($__super) {
    function ExportDeclaration(location, declaration, annotations) {
      $traceurRuntime.superConstructor(ExportDeclaration).call(this, location);
      this.declaration = declaration;
      this.annotations = annotations;
    }
    return ($traceurRuntime.createClass)(ExportDeclaration, {
      transform: function(transformer) {
        return transformer.transformExportDeclaration(this);
      },
      visit: function(visitor) {
        visitor.visitExportDeclaration(this);
      },
      get type() {
        return EXPORT_DECLARATION;
      }
    }, {}, $__super);
  }(ParseTree);
  var EXPORT_DEFAULT = ParseTreeType.EXPORT_DEFAULT;
  var ExportDefault = function($__super) {
    function ExportDefault(location, expression) {
      $traceurRuntime.superConstructor(ExportDefault).call(this, location);
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(ExportDefault, {
      transform: function(transformer) {
        return transformer.transformExportDefault(this);
      },
      visit: function(visitor) {
        visitor.visitExportDefault(this);
      },
      get type() {
        return EXPORT_DEFAULT;
      }
    }, {}, $__super);
  }(ParseTree);
  var EXPORT_SPECIFIER = ParseTreeType.EXPORT_SPECIFIER;
  var ExportSpecifier = function($__super) {
    function ExportSpecifier(location, lhs, rhs) {
      $traceurRuntime.superConstructor(ExportSpecifier).call(this, location);
      this.lhs = lhs;
      this.rhs = rhs;
    }
    return ($traceurRuntime.createClass)(ExportSpecifier, {
      transform: function(transformer) {
        return transformer.transformExportSpecifier(this);
      },
      visit: function(visitor) {
        visitor.visitExportSpecifier(this);
      },
      get type() {
        return EXPORT_SPECIFIER;
      }
    }, {}, $__super);
  }(ParseTree);
  var EXPORT_SPECIFIER_SET = ParseTreeType.EXPORT_SPECIFIER_SET;
  var ExportSpecifierSet = function($__super) {
    function ExportSpecifierSet(location, specifiers) {
      $traceurRuntime.superConstructor(ExportSpecifierSet).call(this, location);
      this.specifiers = specifiers;
    }
    return ($traceurRuntime.createClass)(ExportSpecifierSet, {
      transform: function(transformer) {
        return transformer.transformExportSpecifierSet(this);
      },
      visit: function(visitor) {
        visitor.visitExportSpecifierSet(this);
      },
      get type() {
        return EXPORT_SPECIFIER_SET;
      }
    }, {}, $__super);
  }(ParseTree);
  var EXPORT_STAR = ParseTreeType.EXPORT_STAR;
  var ExportStar = function($__super) {
    function ExportStar(location) {
      $traceurRuntime.superConstructor(ExportStar).call(this, location);
    }
    return ($traceurRuntime.createClass)(ExportStar, {
      transform: function(transformer) {
        return transformer.transformExportStar(this);
      },
      visit: function(visitor) {
        visitor.visitExportStar(this);
      },
      get type() {
        return EXPORT_STAR;
      }
    }, {}, $__super);
  }(ParseTree);
  var EXPRESSION_STATEMENT = ParseTreeType.EXPRESSION_STATEMENT;
  var ExpressionStatement = function($__super) {
    function ExpressionStatement(location, expression) {
      $traceurRuntime.superConstructor(ExpressionStatement).call(this, location);
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(ExpressionStatement, {
      transform: function(transformer) {
        return transformer.transformExpressionStatement(this);
      },
      visit: function(visitor) {
        visitor.visitExpressionStatement(this);
      },
      get type() {
        return EXPRESSION_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var FINALLY = ParseTreeType.FINALLY;
  var Finally = function($__super) {
    function Finally(location, block) {
      $traceurRuntime.superConstructor(Finally).call(this, location);
      this.block = block;
    }
    return ($traceurRuntime.createClass)(Finally, {
      transform: function(transformer) {
        return transformer.transformFinally(this);
      },
      visit: function(visitor) {
        visitor.visitFinally(this);
      },
      get type() {
        return FINALLY;
      }
    }, {}, $__super);
  }(ParseTree);
  var FOR_IN_STATEMENT = ParseTreeType.FOR_IN_STATEMENT;
  var ForInStatement = function($__super) {
    function ForInStatement(location, initializer, collection, body) {
      $traceurRuntime.superConstructor(ForInStatement).call(this, location);
      this.initializer = initializer;
      this.collection = collection;
      this.body = body;
    }
    return ($traceurRuntime.createClass)(ForInStatement, {
      transform: function(transformer) {
        return transformer.transformForInStatement(this);
      },
      visit: function(visitor) {
        visitor.visitForInStatement(this);
      },
      get type() {
        return FOR_IN_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var FOR_OF_STATEMENT = ParseTreeType.FOR_OF_STATEMENT;
  var ForOfStatement = function($__super) {
    function ForOfStatement(location, initializer, collection, body) {
      $traceurRuntime.superConstructor(ForOfStatement).call(this, location);
      this.initializer = initializer;
      this.collection = collection;
      this.body = body;
    }
    return ($traceurRuntime.createClass)(ForOfStatement, {
      transform: function(transformer) {
        return transformer.transformForOfStatement(this);
      },
      visit: function(visitor) {
        visitor.visitForOfStatement(this);
      },
      get type() {
        return FOR_OF_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var FOR_ON_STATEMENT = ParseTreeType.FOR_ON_STATEMENT;
  var ForOnStatement = function($__super) {
    function ForOnStatement(location, initializer, observable, body) {
      $traceurRuntime.superConstructor(ForOnStatement).call(this, location);
      this.initializer = initializer;
      this.observable = observable;
      this.body = body;
    }
    return ($traceurRuntime.createClass)(ForOnStatement, {
      transform: function(transformer) {
        return transformer.transformForOnStatement(this);
      },
      visit: function(visitor) {
        visitor.visitForOnStatement(this);
      },
      get type() {
        return FOR_ON_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var FOR_STATEMENT = ParseTreeType.FOR_STATEMENT;
  var ForStatement = function($__super) {
    function ForStatement(location, initializer, condition, increment, body) {
      $traceurRuntime.superConstructor(ForStatement).call(this, location);
      this.initializer = initializer;
      this.condition = condition;
      this.increment = increment;
      this.body = body;
    }
    return ($traceurRuntime.createClass)(ForStatement, {
      transform: function(transformer) {
        return transformer.transformForStatement(this);
      },
      visit: function(visitor) {
        visitor.visitForStatement(this);
      },
      get type() {
        return FOR_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var FORMAL_PARAMETER = ParseTreeType.FORMAL_PARAMETER;
  var FormalParameter = function($__super) {
    function FormalParameter(location, parameter, typeAnnotation, annotations) {
      $traceurRuntime.superConstructor(FormalParameter).call(this, location);
      this.parameter = parameter;
      this.typeAnnotation = typeAnnotation;
      this.annotations = annotations;
    }
    return ($traceurRuntime.createClass)(FormalParameter, {
      transform: function(transformer) {
        return transformer.transformFormalParameter(this);
      },
      visit: function(visitor) {
        visitor.visitFormalParameter(this);
      },
      get type() {
        return FORMAL_PARAMETER;
      }
    }, {}, $__super);
  }(ParseTree);
  var FORMAL_PARAMETER_LIST = ParseTreeType.FORMAL_PARAMETER_LIST;
  var FormalParameterList = function($__super) {
    function FormalParameterList(location, parameters) {
      $traceurRuntime.superConstructor(FormalParameterList).call(this, location);
      this.parameters = parameters;
    }
    return ($traceurRuntime.createClass)(FormalParameterList, {
      transform: function(transformer) {
        return transformer.transformFormalParameterList(this);
      },
      visit: function(visitor) {
        visitor.visitFormalParameterList(this);
      },
      get type() {
        return FORMAL_PARAMETER_LIST;
      }
    }, {}, $__super);
  }(ParseTree);
  var FORWARD_DEFAULT_EXPORT = ParseTreeType.FORWARD_DEFAULT_EXPORT;
  var ForwardDefaultExport = function($__super) {
    function ForwardDefaultExport(location, name) {
      $traceurRuntime.superConstructor(ForwardDefaultExport).call(this, location);
      this.name = name;
    }
    return ($traceurRuntime.createClass)(ForwardDefaultExport, {
      transform: function(transformer) {
        return transformer.transformForwardDefaultExport(this);
      },
      visit: function(visitor) {
        visitor.visitForwardDefaultExport(this);
      },
      get type() {
        return FORWARD_DEFAULT_EXPORT;
      }
    }, {}, $__super);
  }(ParseTree);
  var FUNCTION_BODY = ParseTreeType.FUNCTION_BODY;
  var FunctionBody = function($__super) {
    function FunctionBody(location, statements) {
      $traceurRuntime.superConstructor(FunctionBody).call(this, location);
      this.statements = statements;
    }
    return ($traceurRuntime.createClass)(FunctionBody, {
      transform: function(transformer) {
        return transformer.transformFunctionBody(this);
      },
      visit: function(visitor) {
        visitor.visitFunctionBody(this);
      },
      get type() {
        return FUNCTION_BODY;
      }
    }, {}, $__super);
  }(ParseTree);
  var FUNCTION_DECLARATION = ParseTreeType.FUNCTION_DECLARATION;
  var FunctionDeclaration = function($__super) {
    function FunctionDeclaration(location, name, functionKind, parameterList, typeAnnotation, annotations, body) {
      $traceurRuntime.superConstructor(FunctionDeclaration).call(this, location);
      this.name = name;
      this.functionKind = functionKind;
      this.parameterList = parameterList;
      this.typeAnnotation = typeAnnotation;
      this.annotations = annotations;
      this.body = body;
    }
    return ($traceurRuntime.createClass)(FunctionDeclaration, {
      transform: function(transformer) {
        return transformer.transformFunctionDeclaration(this);
      },
      visit: function(visitor) {
        visitor.visitFunctionDeclaration(this);
      },
      get type() {
        return FUNCTION_DECLARATION;
      }
    }, {}, $__super);
  }(ParseTree);
  var FUNCTION_EXPRESSION = ParseTreeType.FUNCTION_EXPRESSION;
  var FunctionExpression = function($__super) {
    function FunctionExpression(location, name, functionKind, parameterList, typeAnnotation, annotations, body) {
      $traceurRuntime.superConstructor(FunctionExpression).call(this, location);
      this.name = name;
      this.functionKind = functionKind;
      this.parameterList = parameterList;
      this.typeAnnotation = typeAnnotation;
      this.annotations = annotations;
      this.body = body;
    }
    return ($traceurRuntime.createClass)(FunctionExpression, {
      transform: function(transformer) {
        return transformer.transformFunctionExpression(this);
      },
      visit: function(visitor) {
        visitor.visitFunctionExpression(this);
      },
      get type() {
        return FUNCTION_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var FUNCTION_TYPE = ParseTreeType.FUNCTION_TYPE;
  var FunctionType = function($__super) {
    function FunctionType(location, typeParameters, parameterList, returnType) {
      $traceurRuntime.superConstructor(FunctionType).call(this, location);
      this.typeParameters = typeParameters;
      this.parameterList = parameterList;
      this.returnType = returnType;
    }
    return ($traceurRuntime.createClass)(FunctionType, {
      transform: function(transformer) {
        return transformer.transformFunctionType(this);
      },
      visit: function(visitor) {
        visitor.visitFunctionType(this);
      },
      get type() {
        return FUNCTION_TYPE;
      }
    }, {}, $__super);
  }(ParseTree);
  var GENERATOR_COMPREHENSION = ParseTreeType.GENERATOR_COMPREHENSION;
  var GeneratorComprehension = function($__super) {
    function GeneratorComprehension(location, comprehensionList, expression) {
      $traceurRuntime.superConstructor(GeneratorComprehension).call(this, location);
      this.comprehensionList = comprehensionList;
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(GeneratorComprehension, {
      transform: function(transformer) {
        return transformer.transformGeneratorComprehension(this);
      },
      visit: function(visitor) {
        visitor.visitGeneratorComprehension(this);
      },
      get type() {
        return GENERATOR_COMPREHENSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var GET_ACCESSOR = ParseTreeType.GET_ACCESSOR;
  var GetAccessor = function($__super) {
    function GetAccessor(location, isStatic, name, typeAnnotation, annotations, body) {
      $traceurRuntime.superConstructor(GetAccessor).call(this, location);
      this.isStatic = isStatic;
      this.name = name;
      this.typeAnnotation = typeAnnotation;
      this.annotations = annotations;
      this.body = body;
    }
    return ($traceurRuntime.createClass)(GetAccessor, {
      transform: function(transformer) {
        return transformer.transformGetAccessor(this);
      },
      visit: function(visitor) {
        visitor.visitGetAccessor(this);
      },
      get type() {
        return GET_ACCESSOR;
      }
    }, {}, $__super);
  }(ParseTree);
  var IDENTIFIER_EXPRESSION = ParseTreeType.IDENTIFIER_EXPRESSION;
  var IdentifierExpression = function($__super) {
    function IdentifierExpression(location, identifierToken) {
      $traceurRuntime.superConstructor(IdentifierExpression).call(this, location);
      this.identifierToken = identifierToken;
    }
    return ($traceurRuntime.createClass)(IdentifierExpression, {
      transform: function(transformer) {
        return transformer.transformIdentifierExpression(this);
      },
      visit: function(visitor) {
        visitor.visitIdentifierExpression(this);
      },
      get type() {
        return IDENTIFIER_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var IF_STATEMENT = ParseTreeType.IF_STATEMENT;
  var IfStatement = function($__super) {
    function IfStatement(location, condition, ifClause, elseClause) {
      $traceurRuntime.superConstructor(IfStatement).call(this, location);
      this.condition = condition;
      this.ifClause = ifClause;
      this.elseClause = elseClause;
    }
    return ($traceurRuntime.createClass)(IfStatement, {
      transform: function(transformer) {
        return transformer.transformIfStatement(this);
      },
      visit: function(visitor) {
        visitor.visitIfStatement(this);
      },
      get type() {
        return IF_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var IMPORTED_BINDING = ParseTreeType.IMPORTED_BINDING;
  var ImportedBinding = function($__super) {
    function ImportedBinding(location, binding) {
      $traceurRuntime.superConstructor(ImportedBinding).call(this, location);
      this.binding = binding;
    }
    return ($traceurRuntime.createClass)(ImportedBinding, {
      transform: function(transformer) {
        return transformer.transformImportedBinding(this);
      },
      visit: function(visitor) {
        visitor.visitImportedBinding(this);
      },
      get type() {
        return IMPORTED_BINDING;
      }
    }, {}, $__super);
  }(ParseTree);
  var IMPORT_CLAUSE_PAIR = ParseTreeType.IMPORT_CLAUSE_PAIR;
  var ImportClausePair = function($__super) {
    function ImportClausePair(location, first, second) {
      $traceurRuntime.superConstructor(ImportClausePair).call(this, location);
      this.first = first;
      this.second = second;
    }
    return ($traceurRuntime.createClass)(ImportClausePair, {
      transform: function(transformer) {
        return transformer.transformImportClausePair(this);
      },
      visit: function(visitor) {
        visitor.visitImportClausePair(this);
      },
      get type() {
        return IMPORT_CLAUSE_PAIR;
      }
    }, {}, $__super);
  }(ParseTree);
  var IMPORT_DECLARATION = ParseTreeType.IMPORT_DECLARATION;
  var ImportDeclaration = function($__super) {
    function ImportDeclaration(location, importClause, moduleSpecifier) {
      $traceurRuntime.superConstructor(ImportDeclaration).call(this, location);
      this.importClause = importClause;
      this.moduleSpecifier = moduleSpecifier;
    }
    return ($traceurRuntime.createClass)(ImportDeclaration, {
      transform: function(transformer) {
        return transformer.transformImportDeclaration(this);
      },
      visit: function(visitor) {
        visitor.visitImportDeclaration(this);
      },
      get type() {
        return IMPORT_DECLARATION;
      }
    }, {}, $__super);
  }(ParseTree);
  var IMPORT_SPECIFIER = ParseTreeType.IMPORT_SPECIFIER;
  var ImportSpecifier = function($__super) {
    function ImportSpecifier(location, binding, name) {
      $traceurRuntime.superConstructor(ImportSpecifier).call(this, location);
      this.binding = binding;
      this.name = name;
    }
    return ($traceurRuntime.createClass)(ImportSpecifier, {
      transform: function(transformer) {
        return transformer.transformImportSpecifier(this);
      },
      visit: function(visitor) {
        visitor.visitImportSpecifier(this);
      },
      get type() {
        return IMPORT_SPECIFIER;
      }
    }, {}, $__super);
  }(ParseTree);
  var IMPORT_SPECIFIER_SET = ParseTreeType.IMPORT_SPECIFIER_SET;
  var ImportSpecifierSet = function($__super) {
    function ImportSpecifierSet(location, specifiers) {
      $traceurRuntime.superConstructor(ImportSpecifierSet).call(this, location);
      this.specifiers = specifiers;
    }
    return ($traceurRuntime.createClass)(ImportSpecifierSet, {
      transform: function(transformer) {
        return transformer.transformImportSpecifierSet(this);
      },
      visit: function(visitor) {
        visitor.visitImportSpecifierSet(this);
      },
      get type() {
        return IMPORT_SPECIFIER_SET;
      }
    }, {}, $__super);
  }(ParseTree);
  var IMPORT_TYPE_CLAUSE = ParseTreeType.IMPORT_TYPE_CLAUSE;
  var ImportTypeClause = function($__super) {
    function ImportTypeClause(location, clause) {
      $traceurRuntime.superConstructor(ImportTypeClause).call(this, location);
      this.clause = clause;
    }
    return ($traceurRuntime.createClass)(ImportTypeClause, {
      transform: function(transformer) {
        return transformer.transformImportTypeClause(this);
      },
      visit: function(visitor) {
        visitor.visitImportTypeClause(this);
      },
      get type() {
        return IMPORT_TYPE_CLAUSE;
      }
    }, {}, $__super);
  }(ParseTree);
  var INDEX_SIGNATURE = ParseTreeType.INDEX_SIGNATURE;
  var IndexSignature = function($__super) {
    function IndexSignature(location, name, indexType, typeAnnotation) {
      $traceurRuntime.superConstructor(IndexSignature).call(this, location);
      this.name = name;
      this.indexType = indexType;
      this.typeAnnotation = typeAnnotation;
    }
    return ($traceurRuntime.createClass)(IndexSignature, {
      transform: function(transformer) {
        return transformer.transformIndexSignature(this);
      },
      visit: function(visitor) {
        visitor.visitIndexSignature(this);
      },
      get type() {
        return INDEX_SIGNATURE;
      }
    }, {}, $__super);
  }(ParseTree);
  var INTERFACE_DECLARATION = ParseTreeType.INTERFACE_DECLARATION;
  var InterfaceDeclaration = function($__super) {
    function InterfaceDeclaration(location, name, typeParameters, extendsClause, objectType) {
      $traceurRuntime.superConstructor(InterfaceDeclaration).call(this, location);
      this.name = name;
      this.typeParameters = typeParameters;
      this.extendsClause = extendsClause;
      this.objectType = objectType;
    }
    return ($traceurRuntime.createClass)(InterfaceDeclaration, {
      transform: function(transformer) {
        return transformer.transformInterfaceDeclaration(this);
      },
      visit: function(visitor) {
        visitor.visitInterfaceDeclaration(this);
      },
      get type() {
        return INTERFACE_DECLARATION;
      }
    }, {}, $__super);
  }(ParseTree);
  var JSX_ATTRIBUTE = ParseTreeType.JSX_ATTRIBUTE;
  var JsxAttribute = function($__super) {
    function JsxAttribute(location, name, value) {
      $traceurRuntime.superConstructor(JsxAttribute).call(this, location);
      this.name = name;
      this.value = value;
    }
    return ($traceurRuntime.createClass)(JsxAttribute, {
      transform: function(transformer) {
        return transformer.transformJsxAttribute(this);
      },
      visit: function(visitor) {
        visitor.visitJsxAttribute(this);
      },
      get type() {
        return JSX_ATTRIBUTE;
      }
    }, {}, $__super);
  }(ParseTree);
  var JSX_ELEMENT = ParseTreeType.JSX_ELEMENT;
  var JsxElement = function($__super) {
    function JsxElement(location, name, attributes, children) {
      $traceurRuntime.superConstructor(JsxElement).call(this, location);
      this.name = name;
      this.attributes = attributes;
      this.children = children;
    }
    return ($traceurRuntime.createClass)(JsxElement, {
      transform: function(transformer) {
        return transformer.transformJsxElement(this);
      },
      visit: function(visitor) {
        visitor.visitJsxElement(this);
      },
      get type() {
        return JSX_ELEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var JSX_ELEMENT_NAME = ParseTreeType.JSX_ELEMENT_NAME;
  var JsxElementName = function($__super) {
    function JsxElementName(location, names) {
      $traceurRuntime.superConstructor(JsxElementName).call(this, location);
      this.names = names;
    }
    return ($traceurRuntime.createClass)(JsxElementName, {
      transform: function(transformer) {
        return transformer.transformJsxElementName(this);
      },
      visit: function(visitor) {
        visitor.visitJsxElementName(this);
      },
      get type() {
        return JSX_ELEMENT_NAME;
      }
    }, {}, $__super);
  }(ParseTree);
  var JSX_PLACEHOLDER = ParseTreeType.JSX_PLACEHOLDER;
  var JsxPlaceholder = function($__super) {
    function JsxPlaceholder(location, expression) {
      $traceurRuntime.superConstructor(JsxPlaceholder).call(this, location);
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(JsxPlaceholder, {
      transform: function(transformer) {
        return transformer.transformJsxPlaceholder(this);
      },
      visit: function(visitor) {
        visitor.visitJsxPlaceholder(this);
      },
      get type() {
        return JSX_PLACEHOLDER;
      }
    }, {}, $__super);
  }(ParseTree);
  var JSX_SPREAD_ATTRIBUTE = ParseTreeType.JSX_SPREAD_ATTRIBUTE;
  var JsxSpreadAttribute = function($__super) {
    function JsxSpreadAttribute(location, expression) {
      $traceurRuntime.superConstructor(JsxSpreadAttribute).call(this, location);
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(JsxSpreadAttribute, {
      transform: function(transformer) {
        return transformer.transformJsxSpreadAttribute(this);
      },
      visit: function(visitor) {
        visitor.visitJsxSpreadAttribute(this);
      },
      get type() {
        return JSX_SPREAD_ATTRIBUTE;
      }
    }, {}, $__super);
  }(ParseTree);
  var JSX_TEXT = ParseTreeType.JSX_TEXT;
  var JsxText = function($__super) {
    function JsxText(location, value) {
      $traceurRuntime.superConstructor(JsxText).call(this, location);
      this.value = value;
    }
    return ($traceurRuntime.createClass)(JsxText, {
      transform: function(transformer) {
        return transformer.transformJsxText(this);
      },
      visit: function(visitor) {
        visitor.visitJsxText(this);
      },
      get type() {
        return JSX_TEXT;
      }
    }, {}, $__super);
  }(ParseTree);
  var LABELLED_STATEMENT = ParseTreeType.LABELLED_STATEMENT;
  var LabelledStatement = function($__super) {
    function LabelledStatement(location, name, statement) {
      $traceurRuntime.superConstructor(LabelledStatement).call(this, location);
      this.name = name;
      this.statement = statement;
    }
    return ($traceurRuntime.createClass)(LabelledStatement, {
      transform: function(transformer) {
        return transformer.transformLabelledStatement(this);
      },
      visit: function(visitor) {
        visitor.visitLabelledStatement(this);
      },
      get type() {
        return LABELLED_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var LITERAL_EXPRESSION = ParseTreeType.LITERAL_EXPRESSION;
  var LiteralExpression = function($__super) {
    function LiteralExpression(location, literalToken) {
      $traceurRuntime.superConstructor(LiteralExpression).call(this, location);
      this.literalToken = literalToken;
    }
    return ($traceurRuntime.createClass)(LiteralExpression, {
      transform: function(transformer) {
        return transformer.transformLiteralExpression(this);
      },
      visit: function(visitor) {
        visitor.visitLiteralExpression(this);
      },
      get type() {
        return LITERAL_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var LITERAL_PROPERTY_NAME = ParseTreeType.LITERAL_PROPERTY_NAME;
  var LiteralPropertyName = function($__super) {
    function LiteralPropertyName(location, literalToken) {
      $traceurRuntime.superConstructor(LiteralPropertyName).call(this, location);
      this.literalToken = literalToken;
    }
    return ($traceurRuntime.createClass)(LiteralPropertyName, {
      transform: function(transformer) {
        return transformer.transformLiteralPropertyName(this);
      },
      visit: function(visitor) {
        visitor.visitLiteralPropertyName(this);
      },
      get type() {
        return LITERAL_PROPERTY_NAME;
      }
    }, {}, $__super);
  }(ParseTree);
  var MEMBER_EXPRESSION = ParseTreeType.MEMBER_EXPRESSION;
  var MemberExpression = function($__super) {
    function MemberExpression(location, operand, memberName) {
      $traceurRuntime.superConstructor(MemberExpression).call(this, location);
      this.operand = operand;
      this.memberName = memberName;
    }
    return ($traceurRuntime.createClass)(MemberExpression, {
      transform: function(transformer) {
        return transformer.transformMemberExpression(this);
      },
      visit: function(visitor) {
        visitor.visitMemberExpression(this);
      },
      get type() {
        return MEMBER_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var MEMBER_LOOKUP_EXPRESSION = ParseTreeType.MEMBER_LOOKUP_EXPRESSION;
  var MemberLookupExpression = function($__super) {
    function MemberLookupExpression(location, operand, memberExpression) {
      $traceurRuntime.superConstructor(MemberLookupExpression).call(this, location);
      this.operand = operand;
      this.memberExpression = memberExpression;
    }
    return ($traceurRuntime.createClass)(MemberLookupExpression, {
      transform: function(transformer) {
        return transformer.transformMemberLookupExpression(this);
      },
      visit: function(visitor) {
        visitor.visitMemberLookupExpression(this);
      },
      get type() {
        return MEMBER_LOOKUP_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var METHOD = ParseTreeType.METHOD;
  var Method = function($__super) {
    function Method(location, isStatic, functionKind, name, parameterList, typeAnnotation, annotations, body, debugName) {
      $traceurRuntime.superConstructor(Method).call(this, location);
      this.isStatic = isStatic;
      this.functionKind = functionKind;
      this.name = name;
      this.parameterList = parameterList;
      this.typeAnnotation = typeAnnotation;
      this.annotations = annotations;
      this.body = body;
      this.debugName = debugName;
    }
    return ($traceurRuntime.createClass)(Method, {
      transform: function(transformer) {
        return transformer.transformMethod(this);
      },
      visit: function(visitor) {
        visitor.visitMethod(this);
      },
      get type() {
        return METHOD;
      }
    }, {}, $__super);
  }(ParseTree);
  var METHOD_SIGNATURE = ParseTreeType.METHOD_SIGNATURE;
  var MethodSignature = function($__super) {
    function MethodSignature(location, name, optional, callSignature) {
      $traceurRuntime.superConstructor(MethodSignature).call(this, location);
      this.name = name;
      this.optional = optional;
      this.callSignature = callSignature;
    }
    return ($traceurRuntime.createClass)(MethodSignature, {
      transform: function(transformer) {
        return transformer.transformMethodSignature(this);
      },
      visit: function(visitor) {
        visitor.visitMethodSignature(this);
      },
      get type() {
        return METHOD_SIGNATURE;
      }
    }, {}, $__super);
  }(ParseTree);
  var MODULE = ParseTreeType.MODULE;
  var Module = function($__super) {
    function Module(location, scriptItemList, moduleName) {
      $traceurRuntime.superConstructor(Module).call(this, location);
      this.scriptItemList = scriptItemList;
      this.moduleName = moduleName;
    }
    return ($traceurRuntime.createClass)(Module, {
      transform: function(transformer) {
        return transformer.transformModule(this);
      },
      visit: function(visitor) {
        visitor.visitModule(this);
      },
      get type() {
        return MODULE;
      }
    }, {}, $__super);
  }(ParseTree);
  var MODULE_SPECIFIER = ParseTreeType.MODULE_SPECIFIER;
  var ModuleSpecifier = function($__super) {
    function ModuleSpecifier(location, token) {
      $traceurRuntime.superConstructor(ModuleSpecifier).call(this, location);
      this.token = token;
    }
    return ($traceurRuntime.createClass)(ModuleSpecifier, {
      transform: function(transformer) {
        return transformer.transformModuleSpecifier(this);
      },
      visit: function(visitor) {
        visitor.visitModuleSpecifier(this);
      },
      get type() {
        return MODULE_SPECIFIER;
      }
    }, {}, $__super);
  }(ParseTree);
  var NAME_SPACE_EXPORT = ParseTreeType.NAME_SPACE_EXPORT;
  var NameSpaceExport = function($__super) {
    function NameSpaceExport(location, name) {
      $traceurRuntime.superConstructor(NameSpaceExport).call(this, location);
      this.name = name;
    }
    return ($traceurRuntime.createClass)(NameSpaceExport, {
      transform: function(transformer) {
        return transformer.transformNameSpaceExport(this);
      },
      visit: function(visitor) {
        visitor.visitNameSpaceExport(this);
      },
      get type() {
        return NAME_SPACE_EXPORT;
      }
    }, {}, $__super);
  }(ParseTree);
  var NAME_SPACE_IMPORT = ParseTreeType.NAME_SPACE_IMPORT;
  var NameSpaceImport = function($__super) {
    function NameSpaceImport(location, binding) {
      $traceurRuntime.superConstructor(NameSpaceImport).call(this, location);
      this.binding = binding;
    }
    return ($traceurRuntime.createClass)(NameSpaceImport, {
      transform: function(transformer) {
        return transformer.transformNameSpaceImport(this);
      },
      visit: function(visitor) {
        visitor.visitNameSpaceImport(this);
      },
      get type() {
        return NAME_SPACE_IMPORT;
      }
    }, {}, $__super);
  }(ParseTree);
  var NAMED_EXPORT = ParseTreeType.NAMED_EXPORT;
  var NamedExport = function($__super) {
    function NamedExport(location, exportClause, moduleSpecifier) {
      $traceurRuntime.superConstructor(NamedExport).call(this, location);
      this.exportClause = exportClause;
      this.moduleSpecifier = moduleSpecifier;
    }
    return ($traceurRuntime.createClass)(NamedExport, {
      transform: function(transformer) {
        return transformer.transformNamedExport(this);
      },
      visit: function(visitor) {
        visitor.visitNamedExport(this);
      },
      get type() {
        return NAMED_EXPORT;
      }
    }, {}, $__super);
  }(ParseTree);
  var NEW_EXPRESSION = ParseTreeType.NEW_EXPRESSION;
  var NewExpression = function($__super) {
    function NewExpression(location, operand, args) {
      $traceurRuntime.superConstructor(NewExpression).call(this, location);
      this.operand = operand;
      this.args = args;
    }
    return ($traceurRuntime.createClass)(NewExpression, {
      transform: function(transformer) {
        return transformer.transformNewExpression(this);
      },
      visit: function(visitor) {
        visitor.visitNewExpression(this);
      },
      get type() {
        return NEW_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var OBJECT_LITERAL = ParseTreeType.OBJECT_LITERAL;
  var ObjectLiteral = function($__super) {
    function ObjectLiteral(location, propertyNameAndValues) {
      $traceurRuntime.superConstructor(ObjectLiteral).call(this, location);
      this.propertyNameAndValues = propertyNameAndValues;
    }
    return ($traceurRuntime.createClass)(ObjectLiteral, {
      transform: function(transformer) {
        return transformer.transformObjectLiteral(this);
      },
      visit: function(visitor) {
        visitor.visitObjectLiteral(this);
      },
      get type() {
        return OBJECT_LITERAL;
      }
    }, {}, $__super);
  }(ParseTree);
  var OBJECT_PATTERN = ParseTreeType.OBJECT_PATTERN;
  var ObjectPattern = function($__super) {
    function ObjectPattern(location, fields) {
      $traceurRuntime.superConstructor(ObjectPattern).call(this, location);
      this.fields = fields;
    }
    return ($traceurRuntime.createClass)(ObjectPattern, {
      transform: function(transformer) {
        return transformer.transformObjectPattern(this);
      },
      visit: function(visitor) {
        visitor.visitObjectPattern(this);
      },
      get type() {
        return OBJECT_PATTERN;
      }
    }, {}, $__super);
  }(ParseTree);
  var OBJECT_PATTERN_FIELD = ParseTreeType.OBJECT_PATTERN_FIELD;
  var ObjectPatternField = function($__super) {
    function ObjectPatternField(location, name, element) {
      $traceurRuntime.superConstructor(ObjectPatternField).call(this, location);
      this.name = name;
      this.element = element;
    }
    return ($traceurRuntime.createClass)(ObjectPatternField, {
      transform: function(transformer) {
        return transformer.transformObjectPatternField(this);
      },
      visit: function(visitor) {
        visitor.visitObjectPatternField(this);
      },
      get type() {
        return OBJECT_PATTERN_FIELD;
      }
    }, {}, $__super);
  }(ParseTree);
  var OBJECT_TYPE = ParseTreeType.OBJECT_TYPE;
  var ObjectType = function($__super) {
    function ObjectType(location, typeMembers) {
      $traceurRuntime.superConstructor(ObjectType).call(this, location);
      this.typeMembers = typeMembers;
    }
    return ($traceurRuntime.createClass)(ObjectType, {
      transform: function(transformer) {
        return transformer.transformObjectType(this);
      },
      visit: function(visitor) {
        visitor.visitObjectType(this);
      },
      get type() {
        return OBJECT_TYPE;
      }
    }, {}, $__super);
  }(ParseTree);
  var PAREN_EXPRESSION = ParseTreeType.PAREN_EXPRESSION;
  var ParenExpression = function($__super) {
    function ParenExpression(location, expression) {
      $traceurRuntime.superConstructor(ParenExpression).call(this, location);
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(ParenExpression, {
      transform: function(transformer) {
        return transformer.transformParenExpression(this);
      },
      visit: function(visitor) {
        visitor.visitParenExpression(this);
      },
      get type() {
        return PAREN_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var POSTFIX_EXPRESSION = ParseTreeType.POSTFIX_EXPRESSION;
  var PostfixExpression = function($__super) {
    function PostfixExpression(location, operand, operator) {
      $traceurRuntime.superConstructor(PostfixExpression).call(this, location);
      this.operand = operand;
      this.operator = operator;
    }
    return ($traceurRuntime.createClass)(PostfixExpression, {
      transform: function(transformer) {
        return transformer.transformPostfixExpression(this);
      },
      visit: function(visitor) {
        visitor.visitPostfixExpression(this);
      },
      get type() {
        return POSTFIX_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var PREDEFINED_TYPE = ParseTreeType.PREDEFINED_TYPE;
  var PredefinedType = function($__super) {
    function PredefinedType(location, typeToken) {
      $traceurRuntime.superConstructor(PredefinedType).call(this, location);
      this.typeToken = typeToken;
    }
    return ($traceurRuntime.createClass)(PredefinedType, {
      transform: function(transformer) {
        return transformer.transformPredefinedType(this);
      },
      visit: function(visitor) {
        visitor.visitPredefinedType(this);
      },
      get type() {
        return PREDEFINED_TYPE;
      }
    }, {}, $__super);
  }(ParseTree);
  var SCRIPT = ParseTreeType.SCRIPT;
  var Script = function($__super) {
    function Script(location, scriptItemList, moduleName) {
      $traceurRuntime.superConstructor(Script).call(this, location);
      this.scriptItemList = scriptItemList;
      this.moduleName = moduleName;
    }
    return ($traceurRuntime.createClass)(Script, {
      transform: function(transformer) {
        return transformer.transformScript(this);
      },
      visit: function(visitor) {
        visitor.visitScript(this);
      },
      get type() {
        return SCRIPT;
      }
    }, {}, $__super);
  }(ParseTree);
  var PROPERTY_NAME_ASSIGNMENT = ParseTreeType.PROPERTY_NAME_ASSIGNMENT;
  var PropertyNameAssignment = function($__super) {
    function PropertyNameAssignment(location, name, value) {
      $traceurRuntime.superConstructor(PropertyNameAssignment).call(this, location);
      this.name = name;
      this.value = value;
    }
    return ($traceurRuntime.createClass)(PropertyNameAssignment, {
      transform: function(transformer) {
        return transformer.transformPropertyNameAssignment(this);
      },
      visit: function(visitor) {
        visitor.visitPropertyNameAssignment(this);
      },
      get type() {
        return PROPERTY_NAME_ASSIGNMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var PROPERTY_NAME_SHORTHAND = ParseTreeType.PROPERTY_NAME_SHORTHAND;
  var PropertyNameShorthand = function($__super) {
    function PropertyNameShorthand(location, name) {
      $traceurRuntime.superConstructor(PropertyNameShorthand).call(this, location);
      this.name = name;
    }
    return ($traceurRuntime.createClass)(PropertyNameShorthand, {
      transform: function(transformer) {
        return transformer.transformPropertyNameShorthand(this);
      },
      visit: function(visitor) {
        visitor.visitPropertyNameShorthand(this);
      },
      get type() {
        return PROPERTY_NAME_SHORTHAND;
      }
    }, {}, $__super);
  }(ParseTree);
  var PROPERTY_VARIABLE_DECLARATION = ParseTreeType.PROPERTY_VARIABLE_DECLARATION;
  var PropertyVariableDeclaration = function($__super) {
    function PropertyVariableDeclaration(location, isStatic, name, typeAnnotation, annotations, initializer) {
      $traceurRuntime.superConstructor(PropertyVariableDeclaration).call(this, location);
      this.isStatic = isStatic;
      this.name = name;
      this.typeAnnotation = typeAnnotation;
      this.annotations = annotations;
      this.initializer = initializer;
    }
    return ($traceurRuntime.createClass)(PropertyVariableDeclaration, {
      transform: function(transformer) {
        return transformer.transformPropertyVariableDeclaration(this);
      },
      visit: function(visitor) {
        visitor.visitPropertyVariableDeclaration(this);
      },
      get type() {
        return PROPERTY_VARIABLE_DECLARATION;
      }
    }, {}, $__super);
  }(ParseTree);
  var PROPERTY_SIGNATURE = ParseTreeType.PROPERTY_SIGNATURE;
  var PropertySignature = function($__super) {
    function PropertySignature(location, name, optional, typeAnnotation) {
      $traceurRuntime.superConstructor(PropertySignature).call(this, location);
      this.name = name;
      this.optional = optional;
      this.typeAnnotation = typeAnnotation;
    }
    return ($traceurRuntime.createClass)(PropertySignature, {
      transform: function(transformer) {
        return transformer.transformPropertySignature(this);
      },
      visit: function(visitor) {
        visitor.visitPropertySignature(this);
      },
      get type() {
        return PROPERTY_SIGNATURE;
      }
    }, {}, $__super);
  }(ParseTree);
  var REST_PARAMETER = ParseTreeType.REST_PARAMETER;
  var RestParameter = function($__super) {
    function RestParameter(location, identifier) {
      $traceurRuntime.superConstructor(RestParameter).call(this, location);
      this.identifier = identifier;
    }
    return ($traceurRuntime.createClass)(RestParameter, {
      transform: function(transformer) {
        return transformer.transformRestParameter(this);
      },
      visit: function(visitor) {
        visitor.visitRestParameter(this);
      },
      get type() {
        return REST_PARAMETER;
      }
    }, {}, $__super);
  }(ParseTree);
  var RETURN_STATEMENT = ParseTreeType.RETURN_STATEMENT;
  var ReturnStatement = function($__super) {
    function ReturnStatement(location, expression) {
      $traceurRuntime.superConstructor(ReturnStatement).call(this, location);
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(ReturnStatement, {
      transform: function(transformer) {
        return transformer.transformReturnStatement(this);
      },
      visit: function(visitor) {
        visitor.visitReturnStatement(this);
      },
      get type() {
        return RETURN_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var SET_ACCESSOR = ParseTreeType.SET_ACCESSOR;
  var SetAccessor = function($__super) {
    function SetAccessor(location, isStatic, name, parameterList, annotations, body) {
      $traceurRuntime.superConstructor(SetAccessor).call(this, location);
      this.isStatic = isStatic;
      this.name = name;
      this.parameterList = parameterList;
      this.annotations = annotations;
      this.body = body;
    }
    return ($traceurRuntime.createClass)(SetAccessor, {
      transform: function(transformer) {
        return transformer.transformSetAccessor(this);
      },
      visit: function(visitor) {
        visitor.visitSetAccessor(this);
      },
      get type() {
        return SET_ACCESSOR;
      }
    }, {}, $__super);
  }(ParseTree);
  var SPREAD_EXPRESSION = ParseTreeType.SPREAD_EXPRESSION;
  var SpreadExpression = function($__super) {
    function SpreadExpression(location, expression) {
      $traceurRuntime.superConstructor(SpreadExpression).call(this, location);
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(SpreadExpression, {
      transform: function(transformer) {
        return transformer.transformSpreadExpression(this);
      },
      visit: function(visitor) {
        visitor.visitSpreadExpression(this);
      },
      get type() {
        return SPREAD_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var SPREAD_PATTERN_ELEMENT = ParseTreeType.SPREAD_PATTERN_ELEMENT;
  var SpreadPatternElement = function($__super) {
    function SpreadPatternElement(location, lvalue) {
      $traceurRuntime.superConstructor(SpreadPatternElement).call(this, location);
      this.lvalue = lvalue;
    }
    return ($traceurRuntime.createClass)(SpreadPatternElement, {
      transform: function(transformer) {
        return transformer.transformSpreadPatternElement(this);
      },
      visit: function(visitor) {
        visitor.visitSpreadPatternElement(this);
      },
      get type() {
        return SPREAD_PATTERN_ELEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var SUPER_EXPRESSION = ParseTreeType.SUPER_EXPRESSION;
  var SuperExpression = function($__super) {
    function SuperExpression(location) {
      $traceurRuntime.superConstructor(SuperExpression).call(this, location);
    }
    return ($traceurRuntime.createClass)(SuperExpression, {
      transform: function(transformer) {
        return transformer.transformSuperExpression(this);
      },
      visit: function(visitor) {
        visitor.visitSuperExpression(this);
      },
      get type() {
        return SUPER_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var SWITCH_STATEMENT = ParseTreeType.SWITCH_STATEMENT;
  var SwitchStatement = function($__super) {
    function SwitchStatement(location, expression, caseClauses) {
      $traceurRuntime.superConstructor(SwitchStatement).call(this, location);
      this.expression = expression;
      this.caseClauses = caseClauses;
    }
    return ($traceurRuntime.createClass)(SwitchStatement, {
      transform: function(transformer) {
        return transformer.transformSwitchStatement(this);
      },
      visit: function(visitor) {
        visitor.visitSwitchStatement(this);
      },
      get type() {
        return SWITCH_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var SYNTAX_ERROR_TREE = ParseTreeType.SYNTAX_ERROR_TREE;
  var SyntaxErrorTree = function($__super) {
    function SyntaxErrorTree(location, nextToken, message) {
      $traceurRuntime.superConstructor(SyntaxErrorTree).call(this, location);
      this.nextToken = nextToken;
      this.message = message;
    }
    return ($traceurRuntime.createClass)(SyntaxErrorTree, {
      transform: function(transformer) {
        return transformer.transformSyntaxErrorTree(this);
      },
      visit: function(visitor) {
        visitor.visitSyntaxErrorTree(this);
      },
      get type() {
        return SYNTAX_ERROR_TREE;
      }
    }, {}, $__super);
  }(ParseTree);
  var TEMPLATE_LITERAL_EXPRESSION = ParseTreeType.TEMPLATE_LITERAL_EXPRESSION;
  var TemplateLiteralExpression = function($__super) {
    function TemplateLiteralExpression(location, operand, elements) {
      $traceurRuntime.superConstructor(TemplateLiteralExpression).call(this, location);
      this.operand = operand;
      this.elements = elements;
    }
    return ($traceurRuntime.createClass)(TemplateLiteralExpression, {
      transform: function(transformer) {
        return transformer.transformTemplateLiteralExpression(this);
      },
      visit: function(visitor) {
        visitor.visitTemplateLiteralExpression(this);
      },
      get type() {
        return TEMPLATE_LITERAL_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var TEMPLATE_LITERAL_PORTION = ParseTreeType.TEMPLATE_LITERAL_PORTION;
  var TemplateLiteralPortion = function($__super) {
    function TemplateLiteralPortion(location, value) {
      $traceurRuntime.superConstructor(TemplateLiteralPortion).call(this, location);
      this.value = value;
    }
    return ($traceurRuntime.createClass)(TemplateLiteralPortion, {
      transform: function(transformer) {
        return transformer.transformTemplateLiteralPortion(this);
      },
      visit: function(visitor) {
        visitor.visitTemplateLiteralPortion(this);
      },
      get type() {
        return TEMPLATE_LITERAL_PORTION;
      }
    }, {}, $__super);
  }(ParseTree);
  var TEMPLATE_SUBSTITUTION = ParseTreeType.TEMPLATE_SUBSTITUTION;
  var TemplateSubstitution = function($__super) {
    function TemplateSubstitution(location, expression) {
      $traceurRuntime.superConstructor(TemplateSubstitution).call(this, location);
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(TemplateSubstitution, {
      transform: function(transformer) {
        return transformer.transformTemplateSubstitution(this);
      },
      visit: function(visitor) {
        visitor.visitTemplateSubstitution(this);
      },
      get type() {
        return TEMPLATE_SUBSTITUTION;
      }
    }, {}, $__super);
  }(ParseTree);
  var THIS_EXPRESSION = ParseTreeType.THIS_EXPRESSION;
  var ThisExpression = function($__super) {
    function ThisExpression(location) {
      $traceurRuntime.superConstructor(ThisExpression).call(this, location);
    }
    return ($traceurRuntime.createClass)(ThisExpression, {
      transform: function(transformer) {
        return transformer.transformThisExpression(this);
      },
      visit: function(visitor) {
        visitor.visitThisExpression(this);
      },
      get type() {
        return THIS_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var THROW_STATEMENT = ParseTreeType.THROW_STATEMENT;
  var ThrowStatement = function($__super) {
    function ThrowStatement(location, value) {
      $traceurRuntime.superConstructor(ThrowStatement).call(this, location);
      this.value = value;
    }
    return ($traceurRuntime.createClass)(ThrowStatement, {
      transform: function(transformer) {
        return transformer.transformThrowStatement(this);
      },
      visit: function(visitor) {
        visitor.visitThrowStatement(this);
      },
      get type() {
        return THROW_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var TRY_STATEMENT = ParseTreeType.TRY_STATEMENT;
  var TryStatement = function($__super) {
    function TryStatement(location, body, catchBlock, finallyBlock) {
      $traceurRuntime.superConstructor(TryStatement).call(this, location);
      this.body = body;
      this.catchBlock = catchBlock;
      this.finallyBlock = finallyBlock;
    }
    return ($traceurRuntime.createClass)(TryStatement, {
      transform: function(transformer) {
        return transformer.transformTryStatement(this);
      },
      visit: function(visitor) {
        visitor.visitTryStatement(this);
      },
      get type() {
        return TRY_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var TYPE_ALIAS_DECLARATION = ParseTreeType.TYPE_ALIAS_DECLARATION;
  var TypeAliasDeclaration = function($__super) {
    function TypeAliasDeclaration(location, name, value) {
      $traceurRuntime.superConstructor(TypeAliasDeclaration).call(this, location);
      this.name = name;
      this.value = value;
    }
    return ($traceurRuntime.createClass)(TypeAliasDeclaration, {
      transform: function(transformer) {
        return transformer.transformTypeAliasDeclaration(this);
      },
      visit: function(visitor) {
        visitor.visitTypeAliasDeclaration(this);
      },
      get type() {
        return TYPE_ALIAS_DECLARATION;
      }
    }, {}, $__super);
  }(ParseTree);
  var TYPE_ARGUMENTS = ParseTreeType.TYPE_ARGUMENTS;
  var TypeArguments = function($__super) {
    function TypeArguments(location, args) {
      $traceurRuntime.superConstructor(TypeArguments).call(this, location);
      this.args = args;
    }
    return ($traceurRuntime.createClass)(TypeArguments, {
      transform: function(transformer) {
        return transformer.transformTypeArguments(this);
      },
      visit: function(visitor) {
        visitor.visitTypeArguments(this);
      },
      get type() {
        return TYPE_ARGUMENTS;
      }
    }, {}, $__super);
  }(ParseTree);
  var TYPE_NAME = ParseTreeType.TYPE_NAME;
  var TypeName = function($__super) {
    function TypeName(location, moduleName, name) {
      $traceurRuntime.superConstructor(TypeName).call(this, location);
      this.moduleName = moduleName;
      this.name = name;
    }
    return ($traceurRuntime.createClass)(TypeName, {
      transform: function(transformer) {
        return transformer.transformTypeName(this);
      },
      visit: function(visitor) {
        visitor.visitTypeName(this);
      },
      get type() {
        return TYPE_NAME;
      }
    }, {}, $__super);
  }(ParseTree);
  var TYPE_PARAMETER = ParseTreeType.TYPE_PARAMETER;
  var TypeParameter = function($__super) {
    function TypeParameter(location, identifierToken, extendsType) {
      $traceurRuntime.superConstructor(TypeParameter).call(this, location);
      this.identifierToken = identifierToken;
      this.extendsType = extendsType;
    }
    return ($traceurRuntime.createClass)(TypeParameter, {
      transform: function(transformer) {
        return transformer.transformTypeParameter(this);
      },
      visit: function(visitor) {
        visitor.visitTypeParameter(this);
      },
      get type() {
        return TYPE_PARAMETER;
      }
    }, {}, $__super);
  }(ParseTree);
  var TYPE_PARAMETERS = ParseTreeType.TYPE_PARAMETERS;
  var TypeParameters = function($__super) {
    function TypeParameters(location, parameters) {
      $traceurRuntime.superConstructor(TypeParameters).call(this, location);
      this.parameters = parameters;
    }
    return ($traceurRuntime.createClass)(TypeParameters, {
      transform: function(transformer) {
        return transformer.transformTypeParameters(this);
      },
      visit: function(visitor) {
        visitor.visitTypeParameters(this);
      },
      get type() {
        return TYPE_PARAMETERS;
      }
    }, {}, $__super);
  }(ParseTree);
  var TYPE_REFERENCE = ParseTreeType.TYPE_REFERENCE;
  var TypeReference = function($__super) {
    function TypeReference(location, typeName, args) {
      $traceurRuntime.superConstructor(TypeReference).call(this, location);
      this.typeName = typeName;
      this.args = args;
    }
    return ($traceurRuntime.createClass)(TypeReference, {
      transform: function(transformer) {
        return transformer.transformTypeReference(this);
      },
      visit: function(visitor) {
        visitor.visitTypeReference(this);
      },
      get type() {
        return TYPE_REFERENCE;
      }
    }, {}, $__super);
  }(ParseTree);
  var UNARY_EXPRESSION = ParseTreeType.UNARY_EXPRESSION;
  var UnaryExpression = function($__super) {
    function UnaryExpression(location, operator, operand) {
      $traceurRuntime.superConstructor(UnaryExpression).call(this, location);
      this.operator = operator;
      this.operand = operand;
    }
    return ($traceurRuntime.createClass)(UnaryExpression, {
      transform: function(transformer) {
        return transformer.transformUnaryExpression(this);
      },
      visit: function(visitor) {
        visitor.visitUnaryExpression(this);
      },
      get type() {
        return UNARY_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  var UNION_TYPE = ParseTreeType.UNION_TYPE;
  var UnionType = function($__super) {
    function UnionType(location, types) {
      $traceurRuntime.superConstructor(UnionType).call(this, location);
      this.types = types;
    }
    return ($traceurRuntime.createClass)(UnionType, {
      transform: function(transformer) {
        return transformer.transformUnionType(this);
      },
      visit: function(visitor) {
        visitor.visitUnionType(this);
      },
      get type() {
        return UNION_TYPE;
      }
    }, {}, $__super);
  }(ParseTree);
  var VARIABLE_DECLARATION = ParseTreeType.VARIABLE_DECLARATION;
  var VariableDeclaration = function($__super) {
    function VariableDeclaration(location, lvalue, typeAnnotation, initializer) {
      $traceurRuntime.superConstructor(VariableDeclaration).call(this, location);
      this.lvalue = lvalue;
      this.typeAnnotation = typeAnnotation;
      this.initializer = initializer;
    }
    return ($traceurRuntime.createClass)(VariableDeclaration, {
      transform: function(transformer) {
        return transformer.transformVariableDeclaration(this);
      },
      visit: function(visitor) {
        visitor.visitVariableDeclaration(this);
      },
      get type() {
        return VARIABLE_DECLARATION;
      }
    }, {}, $__super);
  }(ParseTree);
  var VARIABLE_DECLARATION_LIST = ParseTreeType.VARIABLE_DECLARATION_LIST;
  var VariableDeclarationList = function($__super) {
    function VariableDeclarationList(location, declarationType, declarations) {
      $traceurRuntime.superConstructor(VariableDeclarationList).call(this, location);
      this.declarationType = declarationType;
      this.declarations = declarations;
    }
    return ($traceurRuntime.createClass)(VariableDeclarationList, {
      transform: function(transformer) {
        return transformer.transformVariableDeclarationList(this);
      },
      visit: function(visitor) {
        visitor.visitVariableDeclarationList(this);
      },
      get type() {
        return VARIABLE_DECLARATION_LIST;
      }
    }, {}, $__super);
  }(ParseTree);
  var VARIABLE_STATEMENT = ParseTreeType.VARIABLE_STATEMENT;
  var VariableStatement = function($__super) {
    function VariableStatement(location, declarations) {
      $traceurRuntime.superConstructor(VariableStatement).call(this, location);
      this.declarations = declarations;
    }
    return ($traceurRuntime.createClass)(VariableStatement, {
      transform: function(transformer) {
        return transformer.transformVariableStatement(this);
      },
      visit: function(visitor) {
        visitor.visitVariableStatement(this);
      },
      get type() {
        return VARIABLE_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var WHILE_STATEMENT = ParseTreeType.WHILE_STATEMENT;
  var WhileStatement = function($__super) {
    function WhileStatement(location, condition, body) {
      $traceurRuntime.superConstructor(WhileStatement).call(this, location);
      this.condition = condition;
      this.body = body;
    }
    return ($traceurRuntime.createClass)(WhileStatement, {
      transform: function(transformer) {
        return transformer.transformWhileStatement(this);
      },
      visit: function(visitor) {
        visitor.visitWhileStatement(this);
      },
      get type() {
        return WHILE_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var WITH_STATEMENT = ParseTreeType.WITH_STATEMENT;
  var WithStatement = function($__super) {
    function WithStatement(location, expression, body) {
      $traceurRuntime.superConstructor(WithStatement).call(this, location);
      this.expression = expression;
      this.body = body;
    }
    return ($traceurRuntime.createClass)(WithStatement, {
      transform: function(transformer) {
        return transformer.transformWithStatement(this);
      },
      visit: function(visitor) {
        visitor.visitWithStatement(this);
      },
      get type() {
        return WITH_STATEMENT;
      }
    }, {}, $__super);
  }(ParseTree);
  var YIELD_EXPRESSION = ParseTreeType.YIELD_EXPRESSION;
  var YieldExpression = function($__super) {
    function YieldExpression(location, expression, isYieldFor) {
      $traceurRuntime.superConstructor(YieldExpression).call(this, location);
      this.expression = expression;
      this.isYieldFor = isYieldFor;
    }
    return ($traceurRuntime.createClass)(YieldExpression, {
      transform: function(transformer) {
        return transformer.transformYieldExpression(this);
      },
      visit: function(visitor) {
        visitor.visitYieldExpression(this);
      },
      get type() {
        return YIELD_EXPRESSION;
      }
    }, {}, $__super);
  }(ParseTree);
  return {
    get Annotation() {
      return Annotation;
    },
    get AnonBlock() {
      return AnonBlock;
    },
    get ArgumentList() {
      return ArgumentList;
    },
    get ArrayComprehension() {
      return ArrayComprehension;
    },
    get ArrayLiteral() {
      return ArrayLiteral;
    },
    get ArrayPattern() {
      return ArrayPattern;
    },
    get ArrayType() {
      return ArrayType;
    },
    get ArrowFunction() {
      return ArrowFunction;
    },
    get AssignmentElement() {
      return AssignmentElement;
    },
    get AwaitExpression() {
      return AwaitExpression;
    },
    get BinaryExpression() {
      return BinaryExpression;
    },
    get BindingElement() {
      return BindingElement;
    },
    get BindingIdentifier() {
      return BindingIdentifier;
    },
    get Block() {
      return Block;
    },
    get BreakStatement() {
      return BreakStatement;
    },
    get CallExpression() {
      return CallExpression;
    },
    get CallSignature() {
      return CallSignature;
    },
    get CaseClause() {
      return CaseClause;
    },
    get Catch() {
      return Catch;
    },
    get ClassDeclaration() {
      return ClassDeclaration;
    },
    get ClassExpression() {
      return ClassExpression;
    },
    get CommaExpression() {
      return CommaExpression;
    },
    get ComprehensionFor() {
      return ComprehensionFor;
    },
    get ComprehensionIf() {
      return ComprehensionIf;
    },
    get ComputedPropertyName() {
      return ComputedPropertyName;
    },
    get ConditionalExpression() {
      return ConditionalExpression;
    },
    get ConstructSignature() {
      return ConstructSignature;
    },
    get ConstructorType() {
      return ConstructorType;
    },
    get ContinueStatement() {
      return ContinueStatement;
    },
    get CoverFormals() {
      return CoverFormals;
    },
    get CoverInitializedName() {
      return CoverInitializedName;
    },
    get DebuggerStatement() {
      return DebuggerStatement;
    },
    get DefaultClause() {
      return DefaultClause;
    },
    get DoWhileStatement() {
      return DoWhileStatement;
    },
    get EmptyStatement() {
      return EmptyStatement;
    },
    get ExportDeclaration() {
      return ExportDeclaration;
    },
    get ExportDefault() {
      return ExportDefault;
    },
    get ExportSpecifier() {
      return ExportSpecifier;
    },
    get ExportSpecifierSet() {
      return ExportSpecifierSet;
    },
    get ExportStar() {
      return ExportStar;
    },
    get ExpressionStatement() {
      return ExpressionStatement;
    },
    get Finally() {
      return Finally;
    },
    get ForInStatement() {
      return ForInStatement;
    },
    get ForOfStatement() {
      return ForOfStatement;
    },
    get ForOnStatement() {
      return ForOnStatement;
    },
    get ForStatement() {
      return ForStatement;
    },
    get FormalParameter() {
      return FormalParameter;
    },
    get FormalParameterList() {
      return FormalParameterList;
    },
    get ForwardDefaultExport() {
      return ForwardDefaultExport;
    },
    get FunctionBody() {
      return FunctionBody;
    },
    get FunctionDeclaration() {
      return FunctionDeclaration;
    },
    get FunctionExpression() {
      return FunctionExpression;
    },
    get FunctionType() {
      return FunctionType;
    },
    get GeneratorComprehension() {
      return GeneratorComprehension;
    },
    get GetAccessor() {
      return GetAccessor;
    },
    get IdentifierExpression() {
      return IdentifierExpression;
    },
    get IfStatement() {
      return IfStatement;
    },
    get ImportedBinding() {
      return ImportedBinding;
    },
    get ImportClausePair() {
      return ImportClausePair;
    },
    get ImportDeclaration() {
      return ImportDeclaration;
    },
    get ImportSpecifier() {
      return ImportSpecifier;
    },
    get ImportSpecifierSet() {
      return ImportSpecifierSet;
    },
    get ImportTypeClause() {
      return ImportTypeClause;
    },
    get IndexSignature() {
      return IndexSignature;
    },
    get InterfaceDeclaration() {
      return InterfaceDeclaration;
    },
    get JsxAttribute() {
      return JsxAttribute;
    },
    get JsxElement() {
      return JsxElement;
    },
    get JsxElementName() {
      return JsxElementName;
    },
    get JsxPlaceholder() {
      return JsxPlaceholder;
    },
    get JsxSpreadAttribute() {
      return JsxSpreadAttribute;
    },
    get JsxText() {
      return JsxText;
    },
    get LabelledStatement() {
      return LabelledStatement;
    },
    get LiteralExpression() {
      return LiteralExpression;
    },
    get LiteralPropertyName() {
      return LiteralPropertyName;
    },
    get MemberExpression() {
      return MemberExpression;
    },
    get MemberLookupExpression() {
      return MemberLookupExpression;
    },
    get Method() {
      return Method;
    },
    get MethodSignature() {
      return MethodSignature;
    },
    get Module() {
      return Module;
    },
    get ModuleSpecifier() {
      return ModuleSpecifier;
    },
    get NameSpaceExport() {
      return NameSpaceExport;
    },
    get NameSpaceImport() {
      return NameSpaceImport;
    },
    get NamedExport() {
      return NamedExport;
    },
    get NewExpression() {
      return NewExpression;
    },
    get ObjectLiteral() {
      return ObjectLiteral;
    },
    get ObjectPattern() {
      return ObjectPattern;
    },
    get ObjectPatternField() {
      return ObjectPatternField;
    },
    get ObjectType() {
      return ObjectType;
    },
    get ParenExpression() {
      return ParenExpression;
    },
    get PostfixExpression() {
      return PostfixExpression;
    },
    get PredefinedType() {
      return PredefinedType;
    },
    get Script() {
      return Script;
    },
    get PropertyNameAssignment() {
      return PropertyNameAssignment;
    },
    get PropertyNameShorthand() {
      return PropertyNameShorthand;
    },
    get PropertyVariableDeclaration() {
      return PropertyVariableDeclaration;
    },
    get PropertySignature() {
      return PropertySignature;
    },
    get RestParameter() {
      return RestParameter;
    },
    get ReturnStatement() {
      return ReturnStatement;
    },
    get SetAccessor() {
      return SetAccessor;
    },
    get SpreadExpression() {
      return SpreadExpression;
    },
    get SpreadPatternElement() {
      return SpreadPatternElement;
    },
    get SuperExpression() {
      return SuperExpression;
    },
    get SwitchStatement() {
      return SwitchStatement;
    },
    get SyntaxErrorTree() {
      return SyntaxErrorTree;
    },
    get TemplateLiteralExpression() {
      return TemplateLiteralExpression;
    },
    get TemplateLiteralPortion() {
      return TemplateLiteralPortion;
    },
    get TemplateSubstitution() {
      return TemplateSubstitution;
    },
    get ThisExpression() {
      return ThisExpression;
    },
    get ThrowStatement() {
      return ThrowStatement;
    },
    get TryStatement() {
      return TryStatement;
    },
    get TypeAliasDeclaration() {
      return TypeAliasDeclaration;
    },
    get TypeArguments() {
      return TypeArguments;
    },
    get TypeName() {
      return TypeName;
    },
    get TypeParameter() {
      return TypeParameter;
    },
    get TypeParameters() {
      return TypeParameters;
    },
    get TypeReference() {
      return TypeReference;
    },
    get UnaryExpression() {
      return UnaryExpression;
    },
    get UnionType() {
      return UnionType;
    },
    get VariableDeclaration() {
      return VariableDeclaration;
    },
    get VariableDeclarationList() {
      return VariableDeclarationList;
    },
    get VariableStatement() {
      return VariableStatement;
    },
    get WhileStatement() {
      return WhileStatement;
    },
    get WithStatement() {
      return WithStatement;
    },
    get YieldExpression() {
      return YieldExpression;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ParseTreeTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ParseTreeTransformer.js";
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/ParseTreeTransformer.js")),
      Annotation = $__2.Annotation,
      AnonBlock = $__2.AnonBlock,
      ArgumentList = $__2.ArgumentList,
      ArrayComprehension = $__2.ArrayComprehension,
      ArrayLiteral = $__2.ArrayLiteral,
      ArrayPattern = $__2.ArrayPattern,
      ArrayType = $__2.ArrayType,
      ArrowFunction = $__2.ArrowFunction,
      AssignmentElement = $__2.AssignmentElement,
      AwaitExpression = $__2.AwaitExpression,
      BinaryExpression = $__2.BinaryExpression,
      BindingElement = $__2.BindingElement,
      BindingIdentifier = $__2.BindingIdentifier,
      Block = $__2.Block,
      BreakStatement = $__2.BreakStatement,
      CallExpression = $__2.CallExpression,
      CallSignature = $__2.CallSignature,
      CaseClause = $__2.CaseClause,
      Catch = $__2.Catch,
      ClassDeclaration = $__2.ClassDeclaration,
      ClassExpression = $__2.ClassExpression,
      CommaExpression = $__2.CommaExpression,
      ComprehensionFor = $__2.ComprehensionFor,
      ComprehensionIf = $__2.ComprehensionIf,
      ComputedPropertyName = $__2.ComputedPropertyName,
      ConditionalExpression = $__2.ConditionalExpression,
      ConstructSignature = $__2.ConstructSignature,
      ConstructorType = $__2.ConstructorType,
      ContinueStatement = $__2.ContinueStatement,
      CoverFormals = $__2.CoverFormals,
      CoverInitializedName = $__2.CoverInitializedName,
      DebuggerStatement = $__2.DebuggerStatement,
      DefaultClause = $__2.DefaultClause,
      DoWhileStatement = $__2.DoWhileStatement,
      EmptyStatement = $__2.EmptyStatement,
      ExportDeclaration = $__2.ExportDeclaration,
      ExportDefault = $__2.ExportDefault,
      ExportSpecifier = $__2.ExportSpecifier,
      ExportSpecifierSet = $__2.ExportSpecifierSet,
      ExportStar = $__2.ExportStar,
      ExpressionStatement = $__2.ExpressionStatement,
      Finally = $__2.Finally,
      ForInStatement = $__2.ForInStatement,
      ForOfStatement = $__2.ForOfStatement,
      ForOnStatement = $__2.ForOnStatement,
      ForStatement = $__2.ForStatement,
      FormalParameter = $__2.FormalParameter,
      FormalParameterList = $__2.FormalParameterList,
      ForwardDefaultExport = $__2.ForwardDefaultExport,
      FunctionBody = $__2.FunctionBody,
      FunctionDeclaration = $__2.FunctionDeclaration,
      FunctionExpression = $__2.FunctionExpression,
      FunctionType = $__2.FunctionType,
      GeneratorComprehension = $__2.GeneratorComprehension,
      GetAccessor = $__2.GetAccessor,
      IdentifierExpression = $__2.IdentifierExpression,
      IfStatement = $__2.IfStatement,
      ImportedBinding = $__2.ImportedBinding,
      ImportClausePair = $__2.ImportClausePair,
      ImportDeclaration = $__2.ImportDeclaration,
      ImportSpecifier = $__2.ImportSpecifier,
      ImportSpecifierSet = $__2.ImportSpecifierSet,
      ImportTypeClause = $__2.ImportTypeClause,
      IndexSignature = $__2.IndexSignature,
      InterfaceDeclaration = $__2.InterfaceDeclaration,
      JsxAttribute = $__2.JsxAttribute,
      JsxElement = $__2.JsxElement,
      JsxElementName = $__2.JsxElementName,
      JsxPlaceholder = $__2.JsxPlaceholder,
      JsxSpreadAttribute = $__2.JsxSpreadAttribute,
      JsxText = $__2.JsxText,
      LabelledStatement = $__2.LabelledStatement,
      LiteralExpression = $__2.LiteralExpression,
      LiteralPropertyName = $__2.LiteralPropertyName,
      MemberExpression = $__2.MemberExpression,
      MemberLookupExpression = $__2.MemberLookupExpression,
      Method = $__2.Method,
      MethodSignature = $__2.MethodSignature,
      Module = $__2.Module,
      ModuleSpecifier = $__2.ModuleSpecifier,
      NameSpaceExport = $__2.NameSpaceExport,
      NameSpaceImport = $__2.NameSpaceImport,
      NamedExport = $__2.NamedExport,
      NewExpression = $__2.NewExpression,
      ObjectLiteral = $__2.ObjectLiteral,
      ObjectPattern = $__2.ObjectPattern,
      ObjectPatternField = $__2.ObjectPatternField,
      ObjectType = $__2.ObjectType,
      ParenExpression = $__2.ParenExpression,
      PostfixExpression = $__2.PostfixExpression,
      PredefinedType = $__2.PredefinedType,
      Script = $__2.Script,
      PropertyNameAssignment = $__2.PropertyNameAssignment,
      PropertyNameShorthand = $__2.PropertyNameShorthand,
      PropertyVariableDeclaration = $__2.PropertyVariableDeclaration,
      PropertySignature = $__2.PropertySignature,
      RestParameter = $__2.RestParameter,
      ReturnStatement = $__2.ReturnStatement,
      SetAccessor = $__2.SetAccessor,
      SpreadExpression = $__2.SpreadExpression,
      SpreadPatternElement = $__2.SpreadPatternElement,
      SuperExpression = $__2.SuperExpression,
      SwitchStatement = $__2.SwitchStatement,
      SyntaxErrorTree = $__2.SyntaxErrorTree,
      TemplateLiteralExpression = $__2.TemplateLiteralExpression,
      TemplateLiteralPortion = $__2.TemplateLiteralPortion,
      TemplateSubstitution = $__2.TemplateSubstitution,
      ThisExpression = $__2.ThisExpression,
      ThrowStatement = $__2.ThrowStatement,
      TryStatement = $__2.TryStatement,
      TypeAliasDeclaration = $__2.TypeAliasDeclaration,
      TypeArguments = $__2.TypeArguments,
      TypeName = $__2.TypeName,
      TypeParameter = $__2.TypeParameter,
      TypeParameters = $__2.TypeParameters,
      TypeReference = $__2.TypeReference,
      UnaryExpression = $__2.UnaryExpression,
      UnionType = $__2.UnionType,
      VariableDeclaration = $__2.VariableDeclaration,
      VariableDeclarationList = $__2.VariableDeclarationList,
      VariableStatement = $__2.VariableStatement,
      WhileStatement = $__2.WhileStatement,
      WithStatement = $__2.WithStatement,
      YieldExpression = $__2.YieldExpression;
  var ParseTreeTransformer = function() {
    function ParseTreeTransformer() {}
    return ($traceurRuntime.createClass)(ParseTreeTransformer, {
      transformAny: function(tree) {
        return tree === null ? null : tree.transform(this);
      },
      transformList: function(list) {
        var $__1;
        var builder = null;
        for (var index = 0; index < list.length; index++) {
          var element = list[index];
          var transformed = this.transformAny(element);
          if (builder != null || element != transformed) {
            if (builder === null) {
              builder = list.slice(0, index);
            }
            if (transformed instanceof AnonBlock)
              ($__1 = builder).push.apply($__1, $traceurRuntime.spread(transformed.statements));
            else
              builder.push(transformed);
          }
        }
        return builder || list;
      },
      transformStateMachine: function(tree) {
        throw Error('State machines should not live outside of the GeneratorTransformer.');
      },
      transformToBlockOrStatement: function(tree) {
        var transformed = this.transformAny(tree);
        if (transformed instanceof AnonBlock) {
          return new Block(transformed.location, transformed.statements);
        }
        return transformed;
      },
      transformAnnotation: function(tree) {
        var name = this.transformAny(tree.name);
        var args = this.transformAny(tree.args);
        if (name === tree.name && args === tree.args) {
          return tree;
        }
        return new Annotation(tree.location, name, args);
      },
      transformAnonBlock: function(tree) {
        var statements = this.transformList(tree.statements);
        if (statements === tree.statements) {
          return tree;
        }
        return new AnonBlock(tree.location, statements);
      },
      transformArgumentList: function(tree) {
        var args = this.transformList(tree.args);
        if (args === tree.args) {
          return tree;
        }
        return new ArgumentList(tree.location, args);
      },
      transformArrayComprehension: function(tree) {
        var comprehensionList = this.transformList(tree.comprehensionList);
        var expression = this.transformAny(tree.expression);
        if (comprehensionList === tree.comprehensionList && expression === tree.expression) {
          return tree;
        }
        return new ArrayComprehension(tree.location, comprehensionList, expression);
      },
      transformArrayLiteral: function(tree) {
        var elements = this.transformList(tree.elements);
        if (elements === tree.elements) {
          return tree;
        }
        return new ArrayLiteral(tree.location, elements);
      },
      transformArrayPattern: function(tree) {
        var elements = this.transformList(tree.elements);
        if (elements === tree.elements) {
          return tree;
        }
        return new ArrayPattern(tree.location, elements);
      },
      transformArrayType: function(tree) {
        var elementType = this.transformAny(tree.elementType);
        if (elementType === tree.elementType) {
          return tree;
        }
        return new ArrayType(tree.location, elementType);
      },
      transformArrowFunction: function(tree) {
        var parameterList = this.transformAny(tree.parameterList);
        var body = this.transformAny(tree.body);
        if (parameterList === tree.parameterList && body === tree.body) {
          return tree;
        }
        return new ArrowFunction(tree.location, tree.functionKind, parameterList, body);
      },
      transformAssignmentElement: function(tree) {
        var assignment = this.transformAny(tree.assignment);
        var initializer = this.transformAny(tree.initializer);
        if (assignment === tree.assignment && initializer === tree.initializer) {
          return tree;
        }
        return new AssignmentElement(tree.location, assignment, initializer);
      },
      transformAwaitExpression: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression) {
          return tree;
        }
        return new AwaitExpression(tree.location, expression);
      },
      transformBinaryExpression: function(tree) {
        var left = this.transformAny(tree.left);
        var right = this.transformAny(tree.right);
        if (left === tree.left && right === tree.right) {
          return tree;
        }
        return new BinaryExpression(tree.location, left, tree.operator, right);
      },
      transformBindingElement: function(tree) {
        var binding = this.transformAny(tree.binding);
        var initializer = this.transformAny(tree.initializer);
        if (binding === tree.binding && initializer === tree.initializer) {
          return tree;
        }
        return new BindingElement(tree.location, binding, initializer);
      },
      transformBindingIdentifier: function(tree) {
        return tree;
      },
      transformBlock: function(tree) {
        var statements = this.transformList(tree.statements);
        if (statements === tree.statements) {
          return tree;
        }
        return new Block(tree.location, statements);
      },
      transformBreakStatement: function(tree) {
        return tree;
      },
      transformCallExpression: function(tree) {
        var operand = this.transformAny(tree.operand);
        var args = this.transformAny(tree.args);
        if (operand === tree.operand && args === tree.args) {
          return tree;
        }
        return new CallExpression(tree.location, operand, args);
      },
      transformCallSignature: function(tree) {
        var typeParameters = this.transformAny(tree.typeParameters);
        var parameterList = this.transformAny(tree.parameterList);
        var returnType = this.transformAny(tree.returnType);
        if (typeParameters === tree.typeParameters && parameterList === tree.parameterList && returnType === tree.returnType) {
          return tree;
        }
        return new CallSignature(tree.location, typeParameters, parameterList, returnType);
      },
      transformCaseClause: function(tree) {
        var expression = this.transformAny(tree.expression);
        var statements = this.transformList(tree.statements);
        if (expression === tree.expression && statements === tree.statements) {
          return tree;
        }
        return new CaseClause(tree.location, expression, statements);
      },
      transformCatch: function(tree) {
        var binding = this.transformAny(tree.binding);
        var catchBody = this.transformAny(tree.catchBody);
        if (binding === tree.binding && catchBody === tree.catchBody) {
          return tree;
        }
        return new Catch(tree.location, binding, catchBody);
      },
      transformClassDeclaration: function(tree) {
        var name = this.transformAny(tree.name);
        var superClass = this.transformAny(tree.superClass);
        var elements = this.transformList(tree.elements);
        var annotations = this.transformList(tree.annotations);
        var typeParameters = this.transformAny(tree.typeParameters);
        if (name === tree.name && superClass === tree.superClass && elements === tree.elements && annotations === tree.annotations && typeParameters === tree.typeParameters) {
          return tree;
        }
        return new ClassDeclaration(tree.location, name, superClass, elements, annotations, typeParameters);
      },
      transformClassExpression: function(tree) {
        var name = this.transformAny(tree.name);
        var superClass = this.transformAny(tree.superClass);
        var elements = this.transformList(tree.elements);
        var annotations = this.transformList(tree.annotations);
        var typeParameters = this.transformAny(tree.typeParameters);
        if (name === tree.name && superClass === tree.superClass && elements === tree.elements && annotations === tree.annotations && typeParameters === tree.typeParameters) {
          return tree;
        }
        return new ClassExpression(tree.location, name, superClass, elements, annotations, typeParameters);
      },
      transformCommaExpression: function(tree) {
        var expressions = this.transformList(tree.expressions);
        if (expressions === tree.expressions) {
          return tree;
        }
        return new CommaExpression(tree.location, expressions);
      },
      transformComprehensionFor: function(tree) {
        var left = this.transformAny(tree.left);
        var iterator = this.transformAny(tree.iterator);
        if (left === tree.left && iterator === tree.iterator) {
          return tree;
        }
        return new ComprehensionFor(tree.location, left, iterator);
      },
      transformComprehensionIf: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression) {
          return tree;
        }
        return new ComprehensionIf(tree.location, expression);
      },
      transformComputedPropertyName: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression) {
          return tree;
        }
        return new ComputedPropertyName(tree.location, expression);
      },
      transformConditionalExpression: function(tree) {
        var condition = this.transformAny(tree.condition);
        var left = this.transformAny(tree.left);
        var right = this.transformAny(tree.right);
        if (condition === tree.condition && left === tree.left && right === tree.right) {
          return tree;
        }
        return new ConditionalExpression(tree.location, condition, left, right);
      },
      transformConstructSignature: function(tree) {
        var typeParameters = this.transformAny(tree.typeParameters);
        var parameterList = this.transformAny(tree.parameterList);
        var returnType = this.transformAny(tree.returnType);
        if (typeParameters === tree.typeParameters && parameterList === tree.parameterList && returnType === tree.returnType) {
          return tree;
        }
        return new ConstructSignature(tree.location, typeParameters, parameterList, returnType);
      },
      transformConstructorType: function(tree) {
        var typeParameters = this.transformAny(tree.typeParameters);
        var parameterList = this.transformAny(tree.parameterList);
        var returnType = this.transformAny(tree.returnType);
        if (typeParameters === tree.typeParameters && parameterList === tree.parameterList && returnType === tree.returnType) {
          return tree;
        }
        return new ConstructorType(tree.location, typeParameters, parameterList, returnType);
      },
      transformContinueStatement: function(tree) {
        return tree;
      },
      transformCoverFormals: function(tree) {
        var expressions = this.transformList(tree.expressions);
        if (expressions === tree.expressions) {
          return tree;
        }
        return new CoverFormals(tree.location, expressions);
      },
      transformCoverInitializedName: function(tree) {
        var initializer = this.transformAny(tree.initializer);
        if (initializer === tree.initializer) {
          return tree;
        }
        return new CoverInitializedName(tree.location, tree.name, tree.equalToken, initializer);
      },
      transformDebuggerStatement: function(tree) {
        return tree;
      },
      transformDefaultClause: function(tree) {
        var statements = this.transformList(tree.statements);
        if (statements === tree.statements) {
          return tree;
        }
        return new DefaultClause(tree.location, statements);
      },
      transformDoWhileStatement: function(tree) {
        var body = this.transformToBlockOrStatement(tree.body);
        var condition = this.transformAny(tree.condition);
        if (body === tree.body && condition === tree.condition) {
          return tree;
        }
        return new DoWhileStatement(tree.location, body, condition);
      },
      transformEmptyStatement: function(tree) {
        return tree;
      },
      transformExportDeclaration: function(tree) {
        var declaration = this.transformAny(tree.declaration);
        var annotations = this.transformList(tree.annotations);
        if (declaration === tree.declaration && annotations === tree.annotations) {
          return tree;
        }
        return new ExportDeclaration(tree.location, declaration, annotations);
      },
      transformExportDefault: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression) {
          return tree;
        }
        return new ExportDefault(tree.location, expression);
      },
      transformExportSpecifier: function(tree) {
        return tree;
      },
      transformExportSpecifierSet: function(tree) {
        var specifiers = this.transformList(tree.specifiers);
        if (specifiers === tree.specifiers) {
          return tree;
        }
        return new ExportSpecifierSet(tree.location, specifiers);
      },
      transformExportStar: function(tree) {
        return tree;
      },
      transformExpressionStatement: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression) {
          return tree;
        }
        return new ExpressionStatement(tree.location, expression);
      },
      transformFinally: function(tree) {
        var block = this.transformAny(tree.block);
        if (block === tree.block) {
          return tree;
        }
        return new Finally(tree.location, block);
      },
      transformForInStatement: function(tree) {
        var initializer = this.transformAny(tree.initializer);
        var collection = this.transformAny(tree.collection);
        var body = this.transformToBlockOrStatement(tree.body);
        if (initializer === tree.initializer && collection === tree.collection && body === tree.body) {
          return tree;
        }
        return new ForInStatement(tree.location, initializer, collection, body);
      },
      transformForOfStatement: function(tree) {
        var initializer = this.transformAny(tree.initializer);
        var collection = this.transformAny(tree.collection);
        var body = this.transformToBlockOrStatement(tree.body);
        if (initializer === tree.initializer && collection === tree.collection && body === tree.body) {
          return tree;
        }
        return new ForOfStatement(tree.location, initializer, collection, body);
      },
      transformForOnStatement: function(tree) {
        var initializer = this.transformAny(tree.initializer);
        var observable = this.transformAny(tree.observable);
        var body = this.transformToBlockOrStatement(tree.body);
        if (initializer === tree.initializer && observable === tree.observable && body === tree.body) {
          return tree;
        }
        return new ForOnStatement(tree.location, initializer, observable, body);
      },
      transformForStatement: function(tree) {
        var initializer = this.transformAny(tree.initializer);
        var condition = this.transformAny(tree.condition);
        var increment = this.transformAny(tree.increment);
        var body = this.transformToBlockOrStatement(tree.body);
        if (initializer === tree.initializer && condition === tree.condition && increment === tree.increment && body === tree.body) {
          return tree;
        }
        return new ForStatement(tree.location, initializer, condition, increment, body);
      },
      transformFormalParameter: function(tree) {
        var parameter = this.transformAny(tree.parameter);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        var annotations = this.transformList(tree.annotations);
        if (parameter === tree.parameter && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations) {
          return tree;
        }
        return new FormalParameter(tree.location, parameter, typeAnnotation, annotations);
      },
      transformFormalParameterList: function(tree) {
        var parameters = this.transformList(tree.parameters);
        if (parameters === tree.parameters) {
          return tree;
        }
        return new FormalParameterList(tree.location, parameters);
      },
      transformForwardDefaultExport: function(tree) {
        return tree;
      },
      transformFunctionBody: function(tree) {
        var statements = this.transformList(tree.statements);
        if (statements === tree.statements) {
          return tree;
        }
        return new FunctionBody(tree.location, statements);
      },
      transformFunctionDeclaration: function(tree) {
        var name = this.transformAny(tree.name);
        var parameterList = this.transformAny(tree.parameterList);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        var annotations = this.transformList(tree.annotations);
        var body = this.transformAny(tree.body);
        if (name === tree.name && parameterList === tree.parameterList && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && body === tree.body) {
          return tree;
        }
        return new FunctionDeclaration(tree.location, name, tree.functionKind, parameterList, typeAnnotation, annotations, body);
      },
      transformFunctionExpression: function(tree) {
        var name = this.transformAny(tree.name);
        var parameterList = this.transformAny(tree.parameterList);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        var annotations = this.transformList(tree.annotations);
        var body = this.transformAny(tree.body);
        if (name === tree.name && parameterList === tree.parameterList && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && body === tree.body) {
          return tree;
        }
        return new FunctionExpression(tree.location, name, tree.functionKind, parameterList, typeAnnotation, annotations, body);
      },
      transformFunctionType: function(tree) {
        var typeParameters = this.transformAny(tree.typeParameters);
        var parameterList = this.transformAny(tree.parameterList);
        var returnType = this.transformAny(tree.returnType);
        if (typeParameters === tree.typeParameters && parameterList === tree.parameterList && returnType === tree.returnType) {
          return tree;
        }
        return new FunctionType(tree.location, typeParameters, parameterList, returnType);
      },
      transformGeneratorComprehension: function(tree) {
        var comprehensionList = this.transformList(tree.comprehensionList);
        var expression = this.transformAny(tree.expression);
        if (comprehensionList === tree.comprehensionList && expression === tree.expression) {
          return tree;
        }
        return new GeneratorComprehension(tree.location, comprehensionList, expression);
      },
      transformGetAccessor: function(tree) {
        var name = this.transformAny(tree.name);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        var annotations = this.transformList(tree.annotations);
        var body = this.transformAny(tree.body);
        if (name === tree.name && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && body === tree.body) {
          return tree;
        }
        return new GetAccessor(tree.location, tree.isStatic, name, typeAnnotation, annotations, body);
      },
      transformIdentifierExpression: function(tree) {
        return tree;
      },
      transformIfStatement: function(tree) {
        var condition = this.transformAny(tree.condition);
        var ifClause = this.transformToBlockOrStatement(tree.ifClause);
        var elseClause = this.transformToBlockOrStatement(tree.elseClause);
        if (condition === tree.condition && ifClause === tree.ifClause && elseClause === tree.elseClause) {
          return tree;
        }
        return new IfStatement(tree.location, condition, ifClause, elseClause);
      },
      transformImportedBinding: function(tree) {
        var binding = this.transformAny(tree.binding);
        if (binding === tree.binding) {
          return tree;
        }
        return new ImportedBinding(tree.location, binding);
      },
      transformImportClausePair: function(tree) {
        var first = this.transformAny(tree.first);
        var second = this.transformAny(tree.second);
        if (first === tree.first && second === tree.second) {
          return tree;
        }
        return new ImportClausePair(tree.location, first, second);
      },
      transformImportDeclaration: function(tree) {
        var importClause = this.transformAny(tree.importClause);
        var moduleSpecifier = this.transformAny(tree.moduleSpecifier);
        if (importClause === tree.importClause && moduleSpecifier === tree.moduleSpecifier) {
          return tree;
        }
        return new ImportDeclaration(tree.location, importClause, moduleSpecifier);
      },
      transformImportSpecifier: function(tree) {
        var binding = this.transformAny(tree.binding);
        if (binding === tree.binding) {
          return tree;
        }
        return new ImportSpecifier(tree.location, binding, tree.name);
      },
      transformImportSpecifierSet: function(tree) {
        var specifiers = this.transformList(tree.specifiers);
        if (specifiers === tree.specifiers) {
          return tree;
        }
        return new ImportSpecifierSet(tree.location, specifiers);
      },
      transformImportTypeClause: function(tree) {
        var clause = this.transformAny(tree.clause);
        if (clause === tree.clause) {
          return tree;
        }
        return new ImportTypeClause(tree.location, clause);
      },
      transformIndexSignature: function(tree) {
        var indexType = this.transformAny(tree.indexType);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        if (indexType === tree.indexType && typeAnnotation === tree.typeAnnotation) {
          return tree;
        }
        return new IndexSignature(tree.location, tree.name, indexType, typeAnnotation);
      },
      transformInterfaceDeclaration: function(tree) {
        var typeParameters = this.transformAny(tree.typeParameters);
        var objectType = this.transformAny(tree.objectType);
        if (typeParameters === tree.typeParameters && objectType === tree.objectType) {
          return tree;
        }
        return new InterfaceDeclaration(tree.location, tree.name, typeParameters, tree.extendsClause, objectType);
      },
      transformJsxAttribute: function(tree) {
        var value = this.transformAny(tree.value);
        if (value === tree.value) {
          return tree;
        }
        return new JsxAttribute(tree.location, tree.name, value);
      },
      transformJsxElement: function(tree) {
        var name = this.transformAny(tree.name);
        var attributes = this.transformList(tree.attributes);
        var children = this.transformList(tree.children);
        if (name === tree.name && attributes === tree.attributes && children === tree.children) {
          return tree;
        }
        return new JsxElement(tree.location, name, attributes, children);
      },
      transformJsxElementName: function(tree) {
        return tree;
      },
      transformJsxPlaceholder: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression) {
          return tree;
        }
        return new JsxPlaceholder(tree.location, expression);
      },
      transformJsxSpreadAttribute: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression) {
          return tree;
        }
        return new JsxSpreadAttribute(tree.location, expression);
      },
      transformJsxText: function(tree) {
        return tree;
      },
      transformLabelledStatement: function(tree) {
        var statement = this.transformAny(tree.statement);
        if (statement === tree.statement) {
          return tree;
        }
        return new LabelledStatement(tree.location, tree.name, statement);
      },
      transformLiteralExpression: function(tree) {
        return tree;
      },
      transformLiteralPropertyName: function(tree) {
        return tree;
      },
      transformMemberExpression: function(tree) {
        var operand = this.transformAny(tree.operand);
        if (operand === tree.operand) {
          return tree;
        }
        return new MemberExpression(tree.location, operand, tree.memberName);
      },
      transformMemberLookupExpression: function(tree) {
        var operand = this.transformAny(tree.operand);
        var memberExpression = this.transformAny(tree.memberExpression);
        if (operand === tree.operand && memberExpression === tree.memberExpression) {
          return tree;
        }
        return new MemberLookupExpression(tree.location, operand, memberExpression);
      },
      transformMethod: function(tree) {
        var name = this.transformAny(tree.name);
        var parameterList = this.transformAny(tree.parameterList);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        var annotations = this.transformList(tree.annotations);
        var body = this.transformAny(tree.body);
        var debugName = this.transformAny(tree.debugName);
        if (name === tree.name && parameterList === tree.parameterList && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && body === tree.body && debugName === tree.debugName) {
          return tree;
        }
        return new Method(tree.location, tree.isStatic, tree.functionKind, name, parameterList, typeAnnotation, annotations, body, debugName);
      },
      transformMethodSignature: function(tree) {
        var name = this.transformAny(tree.name);
        var callSignature = this.transformAny(tree.callSignature);
        if (name === tree.name && callSignature === tree.callSignature) {
          return tree;
        }
        return new MethodSignature(tree.location, name, tree.optional, callSignature);
      },
      transformModule: function(tree) {
        var scriptItemList = this.transformList(tree.scriptItemList);
        if (scriptItemList === tree.scriptItemList) {
          return tree;
        }
        return new Module(tree.location, scriptItemList, tree.moduleName);
      },
      transformModuleSpecifier: function(tree) {
        return tree;
      },
      transformNameSpaceExport: function(tree) {
        return tree;
      },
      transformNameSpaceImport: function(tree) {
        var binding = this.transformAny(tree.binding);
        if (binding === tree.binding) {
          return tree;
        }
        return new NameSpaceImport(tree.location, binding);
      },
      transformNamedExport: function(tree) {
        var exportClause = this.transformAny(tree.exportClause);
        var moduleSpecifier = this.transformAny(tree.moduleSpecifier);
        if (exportClause === tree.exportClause && moduleSpecifier === tree.moduleSpecifier) {
          return tree;
        }
        return new NamedExport(tree.location, exportClause, moduleSpecifier);
      },
      transformNewExpression: function(tree) {
        var operand = this.transformAny(tree.operand);
        var args = this.transformAny(tree.args);
        if (operand === tree.operand && args === tree.args) {
          return tree;
        }
        return new NewExpression(tree.location, operand, args);
      },
      transformObjectLiteral: function(tree) {
        var propertyNameAndValues = this.transformList(tree.propertyNameAndValues);
        if (propertyNameAndValues === tree.propertyNameAndValues) {
          return tree;
        }
        return new ObjectLiteral(tree.location, propertyNameAndValues);
      },
      transformObjectPattern: function(tree) {
        var fields = this.transformList(tree.fields);
        if (fields === tree.fields) {
          return tree;
        }
        return new ObjectPattern(tree.location, fields);
      },
      transformObjectPatternField: function(tree) {
        var name = this.transformAny(tree.name);
        var element = this.transformAny(tree.element);
        if (name === tree.name && element === tree.element) {
          return tree;
        }
        return new ObjectPatternField(tree.location, name, element);
      },
      transformObjectType: function(tree) {
        var typeMembers = this.transformList(tree.typeMembers);
        if (typeMembers === tree.typeMembers) {
          return tree;
        }
        return new ObjectType(tree.location, typeMembers);
      },
      transformParenExpression: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression) {
          return tree;
        }
        return new ParenExpression(tree.location, expression);
      },
      transformPostfixExpression: function(tree) {
        var operand = this.transformAny(tree.operand);
        if (operand === tree.operand) {
          return tree;
        }
        return new PostfixExpression(tree.location, operand, tree.operator);
      },
      transformPredefinedType: function(tree) {
        return tree;
      },
      transformScript: function(tree) {
        var scriptItemList = this.transformList(tree.scriptItemList);
        if (scriptItemList === tree.scriptItemList) {
          return tree;
        }
        return new Script(tree.location, scriptItemList, tree.moduleName);
      },
      transformPropertyNameAssignment: function(tree) {
        var name = this.transformAny(tree.name);
        var value = this.transformAny(tree.value);
        if (name === tree.name && value === tree.value) {
          return tree;
        }
        return new PropertyNameAssignment(tree.location, name, value);
      },
      transformPropertyNameShorthand: function(tree) {
        return tree;
      },
      transformPropertyVariableDeclaration: function(tree) {
        var name = this.transformAny(tree.name);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        var annotations = this.transformList(tree.annotations);
        var initializer = this.transformAny(tree.initializer);
        if (name === tree.name && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && initializer === tree.initializer) {
          return tree;
        }
        return new PropertyVariableDeclaration(tree.location, tree.isStatic, name, typeAnnotation, annotations, initializer);
      },
      transformPropertySignature: function(tree) {
        var name = this.transformAny(tree.name);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        if (name === tree.name && typeAnnotation === tree.typeAnnotation) {
          return tree;
        }
        return new PropertySignature(tree.location, name, tree.optional, typeAnnotation);
      },
      transformRestParameter: function(tree) {
        var identifier = this.transformAny(tree.identifier);
        if (identifier === tree.identifier) {
          return tree;
        }
        return new RestParameter(tree.location, identifier);
      },
      transformReturnStatement: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression) {
          return tree;
        }
        return new ReturnStatement(tree.location, expression);
      },
      transformSetAccessor: function(tree) {
        var name = this.transformAny(tree.name);
        var parameterList = this.transformAny(tree.parameterList);
        var annotations = this.transformList(tree.annotations);
        var body = this.transformAny(tree.body);
        if (name === tree.name && parameterList === tree.parameterList && annotations === tree.annotations && body === tree.body) {
          return tree;
        }
        return new SetAccessor(tree.location, tree.isStatic, name, parameterList, annotations, body);
      },
      transformSpreadExpression: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression) {
          return tree;
        }
        return new SpreadExpression(tree.location, expression);
      },
      transformSpreadPatternElement: function(tree) {
        var lvalue = this.transformAny(tree.lvalue);
        if (lvalue === tree.lvalue) {
          return tree;
        }
        return new SpreadPatternElement(tree.location, lvalue);
      },
      transformSuperExpression: function(tree) {
        return tree;
      },
      transformSwitchStatement: function(tree) {
        var expression = this.transformAny(tree.expression);
        var caseClauses = this.transformList(tree.caseClauses);
        if (expression === tree.expression && caseClauses === tree.caseClauses) {
          return tree;
        }
        return new SwitchStatement(tree.location, expression, caseClauses);
      },
      transformSyntaxErrorTree: function(tree) {
        return tree;
      },
      transformTemplateLiteralExpression: function(tree) {
        var operand = this.transformAny(tree.operand);
        var elements = this.transformList(tree.elements);
        if (operand === tree.operand && elements === tree.elements) {
          return tree;
        }
        return new TemplateLiteralExpression(tree.location, operand, elements);
      },
      transformTemplateLiteralPortion: function(tree) {
        return tree;
      },
      transformTemplateSubstitution: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression) {
          return tree;
        }
        return new TemplateSubstitution(tree.location, expression);
      },
      transformThisExpression: function(tree) {
        return tree;
      },
      transformThrowStatement: function(tree) {
        var value = this.transformAny(tree.value);
        if (value === tree.value) {
          return tree;
        }
        return new ThrowStatement(tree.location, value);
      },
      transformTryStatement: function(tree) {
        var body = this.transformAny(tree.body);
        var catchBlock = this.transformAny(tree.catchBlock);
        var finallyBlock = this.transformAny(tree.finallyBlock);
        if (body === tree.body && catchBlock === tree.catchBlock && finallyBlock === tree.finallyBlock) {
          return tree;
        }
        return new TryStatement(tree.location, body, catchBlock, finallyBlock);
      },
      transformTypeAliasDeclaration: function(tree) {
        var value = this.transformAny(tree.value);
        if (value === tree.value) {
          return tree;
        }
        return new TypeAliasDeclaration(tree.location, tree.name, value);
      },
      transformTypeArguments: function(tree) {
        var args = this.transformList(tree.args);
        if (args === tree.args) {
          return tree;
        }
        return new TypeArguments(tree.location, args);
      },
      transformTypeName: function(tree) {
        var moduleName = this.transformAny(tree.moduleName);
        if (moduleName === tree.moduleName) {
          return tree;
        }
        return new TypeName(tree.location, moduleName, tree.name);
      },
      transformTypeParameter: function(tree) {
        var extendsType = this.transformAny(tree.extendsType);
        if (extendsType === tree.extendsType) {
          return tree;
        }
        return new TypeParameter(tree.location, tree.identifierToken, extendsType);
      },
      transformTypeParameters: function(tree) {
        var parameters = this.transformList(tree.parameters);
        if (parameters === tree.parameters) {
          return tree;
        }
        return new TypeParameters(tree.location, parameters);
      },
      transformTypeReference: function(tree) {
        var typeName = this.transformAny(tree.typeName);
        var args = this.transformAny(tree.args);
        if (typeName === tree.typeName && args === tree.args) {
          return tree;
        }
        return new TypeReference(tree.location, typeName, args);
      },
      transformUnaryExpression: function(tree) {
        var operand = this.transformAny(tree.operand);
        if (operand === tree.operand) {
          return tree;
        }
        return new UnaryExpression(tree.location, tree.operator, operand);
      },
      transformUnionType: function(tree) {
        var types = this.transformList(tree.types);
        if (types === tree.types) {
          return tree;
        }
        return new UnionType(tree.location, types);
      },
      transformVariableDeclaration: function(tree) {
        var lvalue = this.transformAny(tree.lvalue);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        var initializer = this.transformAny(tree.initializer);
        if (lvalue === tree.lvalue && typeAnnotation === tree.typeAnnotation && initializer === tree.initializer) {
          return tree;
        }
        return new VariableDeclaration(tree.location, lvalue, typeAnnotation, initializer);
      },
      transformVariableDeclarationList: function(tree) {
        var declarations = this.transformList(tree.declarations);
        if (declarations === tree.declarations) {
          return tree;
        }
        return new VariableDeclarationList(tree.location, tree.declarationType, declarations);
      },
      transformVariableStatement: function(tree) {
        var declarations = this.transformAny(tree.declarations);
        if (declarations === tree.declarations) {
          return tree;
        }
        return new VariableStatement(tree.location, declarations);
      },
      transformWhileStatement: function(tree) {
        var condition = this.transformAny(tree.condition);
        var body = this.transformToBlockOrStatement(tree.body);
        if (condition === tree.condition && body === tree.body) {
          return tree;
        }
        return new WhileStatement(tree.location, condition, body);
      },
      transformWithStatement: function(tree) {
        var expression = this.transformAny(tree.expression);
        var body = this.transformToBlockOrStatement(tree.body);
        if (expression === tree.expression && body === tree.body) {
          return tree;
        }
        return new WithStatement(tree.location, expression, body);
      },
      transformYieldExpression: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression) {
          return tree;
        }
        return new YieldExpression(tree.location, expression, tree.isYieldFor);
      }
    }, {});
  }();
  return {get ParseTreeTransformer() {
      return ParseTreeTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/module/AttachModuleNameTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/module/AttachModuleNameTransformer.js";
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/module/AttachModuleNameTransformer.js")).ParseTreeTransformer;
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/module/AttachModuleNameTransformer.js")),
      Module = $__2.Module,
      Script = $__2.Script;
  var AttachModuleNameTransformer = function($__super) {
    function AttachModuleNameTransformer(moduleName) {
      $traceurRuntime.superConstructor(AttachModuleNameTransformer).call(this);
      this.moduleName_ = moduleName;
    }
    return ($traceurRuntime.createClass)(AttachModuleNameTransformer, {
      transformModule: function(tree) {
        return new Module(tree.location, tree.scriptItemList, this.moduleName_);
      },
      transformScript: function(tree) {
        return new Script(tree.location, tree.scriptItemList, this.moduleName_);
      }
    }, {}, $__super);
  }(ParseTreeTransformer);
  return {get AttachModuleNameTransformer() {
      return AttachModuleNameTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/IdentifierToken.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/IdentifierToken.js";
  var Token = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Token.js", "traceur@0.0.108/src/syntax/IdentifierToken.js")).Token;
  var IDENTIFIER = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TokenType.js", "traceur@0.0.108/src/syntax/IdentifierToken.js")).IDENTIFIER;
  var IdentifierToken = function($__super) {
    function IdentifierToken(location, value) {
      $traceurRuntime.superConstructor(IdentifierToken).call(this, IDENTIFIER, location);
      this.value = value;
    }
    return ($traceurRuntime.createClass)(IdentifierToken, {toString: function() {
        return this.value;
      }}, {}, $__super);
  }(Token);
  return {get IdentifierToken() {
      return IdentifierToken;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/LiteralToken.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/LiteralToken.js";
  var Token = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Token.js", "traceur@0.0.108/src/syntax/LiteralToken.js")).Token;
  var $__11 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TokenType.js", "traceur@0.0.108/src/syntax/LiteralToken.js")),
      NULL = $__11.NULL,
      NUMBER = $__11.NUMBER,
      STRING = $__11.STRING;
  var StringParser = function() {
    var $__2;
    function StringParser(value) {
      this.value = value;
      this.index = 0;
    }
    return ($traceurRuntime.createClass)(StringParser, ($__2 = {}, Object.defineProperty($__2, Symbol.iterator, {
      value: function() {
        return this;
      },
      configurable: true,
      enumerable: true,
      writable: true
    }), Object.defineProperty($__2, "next", {
      value: function() {
        if (++this.index >= this.value.length - 1)
          return {
            value: undefined,
            done: true
          };
        return {
          value: this.value[this.index],
          done: false
        };
      },
      configurable: true,
      enumerable: true,
      writable: true
    }), Object.defineProperty($__2, "parse", {
      value: function() {
        if (this.value.indexOf('\\') === -1)
          return this.value.slice(1, -1);
        var result = '';
        var $__6 = true;
        var $__7 = false;
        var $__8 = undefined;
        try {
          for (var $__4 = void 0,
              $__3 = (this)[Symbol.iterator](); !($__6 = ($__4 = $__3.next()).done); $__6 = true) {
            var ch = $__4.value;
            {
              result += ch === '\\' ? this.parseEscapeSequence() : ch;
            }
          }
        } catch ($__9) {
          $__7 = true;
          $__8 = $__9;
        } finally {
          try {
            if (!$__6 && $__3.return != null) {
              $__3.return();
            }
          } finally {
            if ($__7) {
              throw $__8;
            }
          }
        }
        return result;
      },
      configurable: true,
      enumerable: true,
      writable: true
    }), Object.defineProperty($__2, "parseEscapeSequence", {
      value: function() {
        var ch = this.next().value;
        switch (ch) {
          case '\n':
          case '\r':
          case '\u2028':
          case '\u2029':
            return '';
          case '0':
            return '\0';
          case 'b':
            return '\b';
          case 'f':
            return '\f';
          case 'n':
            return '\n';
          case 'r':
            return '\r';
          case 't':
            return '\t';
          case 'v':
            return '\v';
          case 'x':
            return String.fromCharCode(parseInt(this.next().value + this.next().value, 16));
          case 'u':
            {
              var nextValue = this.next().value;
              if (nextValue === '{') {
                var hexDigits = '';
                while ((nextValue = this.next().value) !== '}') {
                  hexDigits += nextValue;
                }
                var codePoint = parseInt(hexDigits, 16);
                if (codePoint <= 0xFFFF) {
                  return String.fromCharCode(codePoint);
                }
                var high = Math.floor((codePoint - 0x10000) / 0x400) + 0xD800;
                var low = (codePoint - 0x10000) % 0x400 + 0xDC00;
                return String.fromCharCode(high, low);
              }
              return String.fromCharCode(parseInt(nextValue + this.next().value + this.next().value + this.next().value, 16));
            }
          default:
            if (Number(ch) < 8)
              throw new Error('Octal literals are not supported');
            return ch;
        }
      },
      configurable: true,
      enumerable: true,
      writable: true
    }), $__2), {});
  }();
  var LiteralToken = function($__super) {
    function LiteralToken(type, value, location) {
      $traceurRuntime.superConstructor(LiteralToken).call(this, type, location);
      this.value = value;
    }
    return ($traceurRuntime.createClass)(LiteralToken, {
      toString: function() {
        return this.value;
      },
      get processedValue() {
        switch (this.type) {
          case NULL:
            return null;
          case NUMBER:
            {
              var value = this.value;
              if (value.charCodeAt(0) === 48) {
                switch (value.charCodeAt(1)) {
                  case 66:
                  case 98:
                    return parseInt(this.value.slice(2), 2);
                  case 79:
                  case 111:
                    return parseInt(this.value.slice(2), 8);
                }
              }
              return Number(this.value);
            }
          case STRING:
            {
              var parser = new StringParser(this.value);
              return parser.parse();
            }
          default:
            throw new Error('Not implemented');
        }
      }
    }, {}, $__super);
  }(Token);
  return {get LiteralToken() {
      return LiteralToken;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/util/assert.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/util/assert.js";
  function assert(b) {
    if (!b && $traceurRuntime.options.debug)
      throw Error('Assertion failed');
  }
  return {get assert() {
      return assert;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ParseTreeFactory.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ParseTreeFactory.js";
  var IdentifierToken = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/IdentifierToken.js", "traceur@0.0.108/src/codegeneration/ParseTreeFactory.js")).IdentifierToken;
  var LiteralToken = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/LiteralToken.js", "traceur@0.0.108/src/codegeneration/ParseTreeFactory.js")).LiteralToken;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTree.js", "traceur@0.0.108/src/codegeneration/ParseTreeFactory.js")),
      ParseTree = $__3.ParseTree,
      ParseTreeType = $__3.ParseTreeType;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/ParseTreeFactory.js")),
      CALL = $__4.CALL,
      CREATE = $__4.CREATE,
      DEFINE_PROPERTY = $__4.DEFINE_PROPERTY,
      FREEZE = $__4.FREEZE,
      OBJECT = $__4.OBJECT,
      UNDEFINED = $__4.UNDEFINED;
  var Token = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/Token.js", "traceur@0.0.108/src/codegeneration/ParseTreeFactory.js")).Token;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/ParseTreeFactory.js")),
      EQUAL = $__6.EQUAL,
      FALSE = $__6.FALSE,
      NULL = $__6.NULL,
      NUMBER = $__6.NUMBER,
      STRING = $__6.STRING,
      TRUE = $__6.TRUE,
      VOID = $__6.VOID;
  var assert = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/assert.js", "traceur@0.0.108/src/codegeneration/ParseTreeFactory.js")).assert;
  var $__8 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/ParseTreeFactory.js")),
      ArgumentList = $__8.ArgumentList,
      ArrayLiteral = $__8.ArrayLiteral,
      BindingElement = $__8.BindingElement,
      BinaryExpression = $__8.BinaryExpression,
      BindingIdentifier = $__8.BindingIdentifier,
      Block = $__8.Block,
      BreakStatement = $__8.BreakStatement,
      CallExpression = $__8.CallExpression,
      CaseClause = $__8.CaseClause,
      Catch = $__8.Catch,
      ClassDeclaration = $__8.ClassDeclaration,
      CommaExpression = $__8.CommaExpression,
      ConditionalExpression = $__8.ConditionalExpression,
      ContinueStatement = $__8.ContinueStatement,
      DefaultClause = $__8.DefaultClause,
      DoWhileStatement = $__8.DoWhileStatement,
      EmptyStatement = $__8.EmptyStatement,
      ExpressionStatement = $__8.ExpressionStatement,
      Finally = $__8.Finally,
      ForInStatement = $__8.ForInStatement,
      ForOfStatement = $__8.ForOfStatement,
      ForStatement = $__8.ForStatement,
      FormalParameter = $__8.FormalParameter,
      FormalParameterList = $__8.FormalParameterList,
      FunctionBody = $__8.FunctionBody,
      FunctionExpression = $__8.FunctionExpression,
      IdentifierExpression = $__8.IdentifierExpression,
      IfStatement = $__8.IfStatement,
      ImportedBinding = $__8.ImportedBinding,
      LiteralExpression = $__8.LiteralExpression,
      LiteralPropertyName = $__8.LiteralPropertyName,
      MemberExpression = $__8.MemberExpression,
      MemberLookupExpression = $__8.MemberLookupExpression,
      NewExpression = $__8.NewExpression,
      ObjectLiteral = $__8.ObjectLiteral,
      ParenExpression = $__8.ParenExpression,
      PostfixExpression = $__8.PostfixExpression,
      Script = $__8.Script,
      PropertyNameAssignment = $__8.PropertyNameAssignment,
      RestParameter = $__8.RestParameter,
      ReturnStatement = $__8.ReturnStatement,
      SpreadExpression = $__8.SpreadExpression,
      SwitchStatement = $__8.SwitchStatement,
      ThisExpression = $__8.ThisExpression,
      ThrowStatement = $__8.ThrowStatement,
      TryStatement = $__8.TryStatement,
      UnaryExpression = $__8.UnaryExpression,
      VariableDeclaration = $__8.VariableDeclaration,
      VariableDeclarationList = $__8.VariableDeclarationList,
      VariableStatement = $__8.VariableStatement,
      WhileStatement = $__8.WhileStatement,
      WithStatement = $__8.WithStatement;
  var slice = Array.prototype.slice.call.bind(Array.prototype.slice);
  var map = Array.prototype.map.call.bind(Array.prototype.map);
  function createOperatorToken(operator) {
    return new Token(operator, null);
  }
  function createIdentifierToken(identifier) {
    return new IdentifierToken(null, identifier);
  }
  function createStringLiteralToken(value) {
    return new LiteralToken(STRING, JSON.stringify(value), null);
  }
  function createBooleanLiteralToken(value) {
    return new Token(value ? TRUE : FALSE, null);
  }
  function createNullLiteralToken() {
    return new LiteralToken(NULL, 'null', null);
  }
  function createNumberLiteralToken(value) {
    return new LiteralToken(NUMBER, String(value), null);
  }
  function createEmptyParameterList() {
    return new FormalParameterList(null, []);
  }
  function createFormalParameter(name) {
    var bindingIdentifier = createBindingIdentifier(name);
    return new FormalParameter(null, new BindingElement(null, bindingIdentifier, null), null, []);
  }
  function createArgumentList(list) {
    return new ArgumentList(null, list);
  }
  function createEmptyArgumentList() {
    return createArgumentList([]);
  }
  function createArrayLiteral(list) {
    return new ArrayLiteral(null, list);
  }
  function createEmptyArrayLiteral() {
    return createArrayLiteral([]);
  }
  function createAssignmentExpression(lhs, rhs) {
    return new BinaryExpression(null, lhs, createOperatorToken(EQUAL), rhs);
  }
  function createBinaryExpression(left, operator, right) {
    return new BinaryExpression(null, left, operator, right);
  }
  function createBindingIdentifier(identifier) {
    if (typeof identifier === 'string')
      identifier = createIdentifierToken(identifier);
    else if (identifier.type === ParseTreeType.BINDING_IDENTIFIER)
      return identifier;
    else if (identifier.type === ParseTreeType.IDENTIFIER_EXPRESSION)
      return new BindingIdentifier(identifier.location, identifier.identifierToken);
    return new BindingIdentifier(null, identifier);
  }
  function createImportedBinding(name) {
    var bindingIdentifier = createBindingIdentifier(name);
    return new ImportedBinding(bindingIdentifier.location, bindingIdentifier);
  }
  function createEmptyStatement() {
    return new EmptyStatement(null);
  }
  function createEmptyBlock() {
    return createBlock([]);
  }
  function createBlock(statements) {
    return new Block(null, statements);
  }
  function createFunctionBody(statements) {
    return new FunctionBody(null, statements);
  }
  function createScopedExpression(body, scope) {
    assert(body.type === 'FUNCTION_BODY');
    return createCallCall(createParenExpression(createFunctionExpression(createEmptyParameterList(), body)), scope);
  }
  function createImmediatelyInvokedFunctionExpression(body) {
    assert(body.type === 'FUNCTION_BODY');
    return createCallExpression(createParenExpression(createFunctionExpression(createEmptyParameterList(), body)));
  }
  function createCallExpression(operand) {
    var args = arguments[1] !== (void 0) ? arguments[1] : createEmptyArgumentList();
    return new CallExpression(null, operand, args);
  }
  function createBreakStatement() {
    var name = arguments[0] !== (void 0) ? arguments[0] : null;
    return new BreakStatement(null, name);
  }
  function createCallCall(func, thisExpression) {
    return createCallExpression(createMemberExpression(func, CALL), createArgumentList([thisExpression]));
  }
  function createCaseClause(expression, statements) {
    return new CaseClause(null, expression, statements);
  }
  function createCatch(identifier, catchBody) {
    identifier = createBindingIdentifier(identifier);
    return new Catch(null, identifier, catchBody);
  }
  function createClassDeclaration(name, superClass, elements) {
    return new ClassDeclaration(null, name, superClass, elements, []);
  }
  function createCommaExpression(expressions) {
    return new CommaExpression(null, expressions);
  }
  function createConditionalExpression(condition, left, right) {
    return new ConditionalExpression(null, condition, left, right);
  }
  function createContinueStatement() {
    var name = arguments[0] !== (void 0) ? arguments[0] : null;
    return new ContinueStatement(null, name);
  }
  function createDefaultClause(statements) {
    return new DefaultClause(null, statements);
  }
  function createDoWhileStatement(body, condition) {
    return new DoWhileStatement(null, body, condition);
  }
  function createAssignmentStatement(lhs, rhs) {
    return createExpressionStatement(createAssignmentExpression(lhs, rhs));
  }
  function createCallStatement(operand) {
    var args = arguments[1];
    return createExpressionStatement(createCallExpression(operand, args));
  }
  function createExpressionStatement(expression) {
    return new ExpressionStatement(null, expression);
  }
  function createFinally(block) {
    return new Finally(null, block);
  }
  function createForOfStatement(initializer, collection, body) {
    return new ForOfStatement(null, initializer, collection, body);
  }
  function createForInStatement(initializer, collection, body) {
    return new ForInStatement(null, initializer, collection, body);
  }
  function createForStatement(variables, condition, increment, body) {
    return new ForStatement(null, variables, condition, increment, body);
  }
  function createFunctionExpression(parameterList, body) {
    assert(body.type === 'FUNCTION_BODY');
    return new FunctionExpression(null, null, false, parameterList, null, [], body);
  }
  function createIdentifierExpression(identifier) {
    if (typeof identifier === 'string')
      identifier = createIdentifierToken(identifier);
    else if (identifier instanceof BindingIdentifier)
      identifier = identifier.identifierToken;
    return new IdentifierExpression(null, identifier);
  }
  function createUndefinedExpression() {
    return createIdentifierExpression(UNDEFINED);
  }
  function createIfStatement(condition, ifClause) {
    var elseClause = arguments[2] !== (void 0) ? arguments[2] : null;
    return new IfStatement(null, condition, ifClause, elseClause);
  }
  function createStringLiteral(value) {
    return new LiteralExpression(null, createStringLiteralToken(value));
  }
  function createBooleanLiteral(value) {
    return new LiteralExpression(null, createBooleanLiteralToken(value));
  }
  function createTrueLiteral() {
    return createBooleanLiteral(true);
  }
  function createFalseLiteral() {
    return createBooleanLiteral(false);
  }
  function createNullLiteral() {
    return new LiteralExpression(null, createNullLiteralToken());
  }
  function createNumberLiteral(value) {
    return new LiteralExpression(null, createNumberLiteralToken(value));
  }
  function createMemberExpression(operand, memberName) {
    for (var memberNames = [],
        $__0 = 2; $__0 < arguments.length; $__0++)
      memberNames[$__0 - 2] = arguments[$__0];
    if (typeof operand === 'string' || operand instanceof IdentifierToken)
      operand = createIdentifierExpression(operand);
    if (typeof memberName === 'string')
      memberName = createIdentifierToken(memberName);
    if (memberName instanceof LiteralToken)
      memberName = new LiteralExpression(null, memberName);
    var tree = memberName instanceof LiteralExpression ? new MemberLookupExpression(null, operand, memberName) : new MemberExpression(null, operand, memberName);
    for (var i = 0; i < memberNames.length; i++) {
      tree = createMemberExpression(tree, memberNames[i]);
    }
    return tree;
  }
  function createMemberLookupExpression(operand, memberExpression) {
    return new MemberLookupExpression(null, operand, memberExpression);
  }
  function createThisExpression() {
    return new ThisExpression(null);
  }
  function createNewExpression(operand, args) {
    return new NewExpression(null, operand, args);
  }
  function createObjectFreeze(value) {
    return createCallExpression(createMemberExpression(OBJECT, FREEZE), createArgumentList([value]));
  }
  function createObjectCreate(protoExpression) {
    var descriptors = arguments[1];
    var argumentList = [protoExpression];
    if (descriptors)
      argumentList.push(descriptors);
    return createCallExpression(createMemberExpression(OBJECT, CREATE), createArgumentList(argumentList));
  }
  function createObjectLiteralForDescriptor(descr) {
    var propertyNameAndValues = Object.keys(descr).map(function(name) {
      var value = descr[name];
      if (!(value instanceof ParseTree))
        value = createBooleanLiteral(!!value);
      return createPropertyNameAssignment(name, value);
    });
    return createObjectLiteral(propertyNameAndValues);
  }
  function createDefineProperty(tree, name, descr) {
    if (typeof name === 'string')
      name = createStringLiteral(name);
    return createCallExpression(createMemberExpression(OBJECT, DEFINE_PROPERTY), createArgumentList([tree, name, createObjectLiteralForDescriptor(descr)]));
  }
  function createObjectLiteral(propertyNameAndValues) {
    return new ObjectLiteral(null, propertyNameAndValues);
  }
  function createParenExpression(expression) {
    return new ParenExpression(null, expression);
  }
  function createPostfixExpression(operand, operator) {
    return new PostfixExpression(null, operand, operator);
  }
  function createScript(scriptItemList) {
    return new Script(null, scriptItemList, null);
  }
  function createPropertyNameAssignment(identifier, value) {
    if (typeof identifier === 'string')
      identifier = createLiteralPropertyName(identifier);
    return new PropertyNameAssignment(null, identifier, value);
  }
  function createLiteralPropertyName(name) {
    return new LiteralPropertyName(null, createIdentifierToken(name));
  }
  function createRestParameter(identifier) {
    var rest = new RestParameter(null, createBindingIdentifier(identifier));
    return new FormalParameter(null, rest, null, []);
  }
  function createReturnStatement(expression) {
    return new ReturnStatement(null, expression);
  }
  function createSpreadExpression(expression) {
    return new SpreadExpression(null, expression);
  }
  function createSwitchStatement(expression, caseClauses) {
    return new SwitchStatement(null, expression, caseClauses);
  }
  function createThrowStatement(value) {
    return new ThrowStatement(null, value);
  }
  function createTryStatement(body, catchBlock) {
    var finallyBlock = arguments[2] !== (void 0) ? arguments[2] : null;
    return new TryStatement(null, body, catchBlock, finallyBlock);
  }
  function createUnaryExpression(operator, operand) {
    return new UnaryExpression(null, operator, operand);
  }
  function createUseStrictDirective() {
    return createExpressionStatement(createStringLiteral('use strict'));
  }
  function createVariableDeclarationList(binding, identifierOrDeclarations) {
    var initializer = arguments[2];
    if (identifierOrDeclarations instanceof Array) {
      var declarations = identifierOrDeclarations;
      return new VariableDeclarationList(null, binding, declarations);
    }
    var identifier = identifierOrDeclarations;
    return createVariableDeclarationList(binding, [createVariableDeclaration(identifier, initializer)]);
  }
  function createVariableDeclaration(identifier, initializer) {
    if (!(identifier instanceof ParseTree) || identifier.type !== ParseTreeType.BINDING_IDENTIFIER && identifier.type !== ParseTreeType.OBJECT_PATTERN && identifier.type !== ParseTreeType.ARRAY_PATTERN) {
      identifier = createBindingIdentifier(identifier);
    }
    return new VariableDeclaration(null, identifier, null, initializer);
  }
  function createVariableStatement(listOrBinding) {
    var identifier = arguments[1];
    var initializer = arguments[2];
    if (listOrBinding instanceof VariableDeclarationList)
      return new VariableStatement(null, listOrBinding);
    var binding = listOrBinding;
    var list = createVariableDeclarationList(binding, identifier, initializer);
    return createVariableStatement(list);
  }
  function createVoid0() {
    return createParenExpression(createUnaryExpression(createOperatorToken(VOID), createNumberLiteral(0)));
  }
  function createWhileStatement(condition, body) {
    return new WhileStatement(null, condition, body);
  }
  function createWithStatement(expression, body) {
    return new WithStatement(null, expression, body);
  }
  function createAssignStateStatement(state) {
    return createAssignmentStatement(createMemberExpression('$ctx', 'state'), createNumberLiteral(state));
  }
  return {
    get createOperatorToken() {
      return createOperatorToken;
    },
    get createIdentifierToken() {
      return createIdentifierToken;
    },
    get createStringLiteralToken() {
      return createStringLiteralToken;
    },
    get createBooleanLiteralToken() {
      return createBooleanLiteralToken;
    },
    get createNullLiteralToken() {
      return createNullLiteralToken;
    },
    get createNumberLiteralToken() {
      return createNumberLiteralToken;
    },
    get createEmptyParameterList() {
      return createEmptyParameterList;
    },
    get createFormalParameter() {
      return createFormalParameter;
    },
    get createArgumentList() {
      return createArgumentList;
    },
    get createEmptyArgumentList() {
      return createEmptyArgumentList;
    },
    get createArrayLiteral() {
      return createArrayLiteral;
    },
    get createEmptyArrayLiteral() {
      return createEmptyArrayLiteral;
    },
    get createAssignmentExpression() {
      return createAssignmentExpression;
    },
    get createBinaryExpression() {
      return createBinaryExpression;
    },
    get createBindingIdentifier() {
      return createBindingIdentifier;
    },
    get createImportedBinding() {
      return createImportedBinding;
    },
    get createEmptyStatement() {
      return createEmptyStatement;
    },
    get createEmptyBlock() {
      return createEmptyBlock;
    },
    get createBlock() {
      return createBlock;
    },
    get createFunctionBody() {
      return createFunctionBody;
    },
    get createScopedExpression() {
      return createScopedExpression;
    },
    get createImmediatelyInvokedFunctionExpression() {
      return createImmediatelyInvokedFunctionExpression;
    },
    get createCallExpression() {
      return createCallExpression;
    },
    get createBreakStatement() {
      return createBreakStatement;
    },
    get createCaseClause() {
      return createCaseClause;
    },
    get createCatch() {
      return createCatch;
    },
    get createClassDeclaration() {
      return createClassDeclaration;
    },
    get createCommaExpression() {
      return createCommaExpression;
    },
    get createConditionalExpression() {
      return createConditionalExpression;
    },
    get createContinueStatement() {
      return createContinueStatement;
    },
    get createDefaultClause() {
      return createDefaultClause;
    },
    get createDoWhileStatement() {
      return createDoWhileStatement;
    },
    get createAssignmentStatement() {
      return createAssignmentStatement;
    },
    get createCallStatement() {
      return createCallStatement;
    },
    get createExpressionStatement() {
      return createExpressionStatement;
    },
    get createFinally() {
      return createFinally;
    },
    get createForOfStatement() {
      return createForOfStatement;
    },
    get createForInStatement() {
      return createForInStatement;
    },
    get createForStatement() {
      return createForStatement;
    },
    get createFunctionExpression() {
      return createFunctionExpression;
    },
    get createIdentifierExpression() {
      return createIdentifierExpression;
    },
    get createUndefinedExpression() {
      return createUndefinedExpression;
    },
    get createIfStatement() {
      return createIfStatement;
    },
    get createStringLiteral() {
      return createStringLiteral;
    },
    get createBooleanLiteral() {
      return createBooleanLiteral;
    },
    get createTrueLiteral() {
      return createTrueLiteral;
    },
    get createFalseLiteral() {
      return createFalseLiteral;
    },
    get createNullLiteral() {
      return createNullLiteral;
    },
    get createNumberLiteral() {
      return createNumberLiteral;
    },
    get createMemberExpression() {
      return createMemberExpression;
    },
    get createMemberLookupExpression() {
      return createMemberLookupExpression;
    },
    get createThisExpression() {
      return createThisExpression;
    },
    get createNewExpression() {
      return createNewExpression;
    },
    get createObjectFreeze() {
      return createObjectFreeze;
    },
    get createObjectCreate() {
      return createObjectCreate;
    },
    get createObjectLiteralForDescriptor() {
      return createObjectLiteralForDescriptor;
    },
    get createDefineProperty() {
      return createDefineProperty;
    },
    get createObjectLiteral() {
      return createObjectLiteral;
    },
    get createParenExpression() {
      return createParenExpression;
    },
    get createPostfixExpression() {
      return createPostfixExpression;
    },
    get createScript() {
      return createScript;
    },
    get createPropertyNameAssignment() {
      return createPropertyNameAssignment;
    },
    get createLiteralPropertyName() {
      return createLiteralPropertyName;
    },
    get createRestParameter() {
      return createRestParameter;
    },
    get createReturnStatement() {
      return createReturnStatement;
    },
    get createSwitchStatement() {
      return createSwitchStatement;
    },
    get createThrowStatement() {
      return createThrowStatement;
    },
    get createTryStatement() {
      return createTryStatement;
    },
    get createUnaryExpression() {
      return createUnaryExpression;
    },
    get createUseStrictDirective() {
      return createUseStrictDirective;
    },
    get createVariableDeclarationList() {
      return createVariableDeclarationList;
    },
    get createVariableDeclaration() {
      return createVariableDeclaration;
    },
    get createVariableStatement() {
      return createVariableStatement;
    },
    get createVoid0() {
      return createVoid0;
    },
    get createWhileStatement() {
      return createWhileStatement;
    },
    get createWithStatement() {
      return createWithStatement;
    },
    get createAssignStateStatement() {
      return createAssignStateStatement;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/PrependStatements.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/PrependStatements.js";
  function prependStatements(statements) {
    var $__1;
    for (var statementsToPrepend = [],
        $__0 = 1; $__0 < arguments.length; $__0++)
      statementsToPrepend[$__0 - 1] = arguments[$__0];
    if (!statements.length)
      return statementsToPrepend;
    if (!statementsToPrepend.length)
      return statements;
    var transformed = [];
    var inProlog = true;
    statements.forEach(function(statement) {
      var $__1;
      if (inProlog && !statement.isDirectivePrologue()) {
        ($__1 = transformed).push.apply($__1, $traceurRuntime.spread(statementsToPrepend));
        inProlog = false;
      }
      transformed.push(statement);
    });
    if (inProlog) {
      ($__1 = transformed).push.apply($__1, $traceurRuntime.spread(statementsToPrepend));
    }
    return transformed;
  }
  return {get prependStatements() {
      return prependStatements;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/TempVarTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/TempVarTransformer.js";
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/TempVarTransformer.js")).ParseTreeTransformer;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/TempVarTransformer.js")),
      Module = $__6.Module,
      Script = $__6.Script;
  var ARGUMENTS = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/TempVarTransformer.js")).ARGUMENTS;
  var StringSet = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/StringSet.js", "traceur@0.0.108/src/codegeneration/TempVarTransformer.js")).StringSet;
  var $__9 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/TempVarTransformer.js")),
      LET = $__9.LET,
      VAR = $__9.VAR;
  var $__10 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/TempVarTransformer.js")),
      createFunctionBody = $__10.createFunctionBody,
      createThisExpression = $__10.createThisExpression,
      createIdentifierExpression = $__10.createIdentifierExpression,
      createVariableDeclaration = $__10.createVariableDeclaration,
      createVariableDeclarationList = $__10.createVariableDeclarationList,
      createVariableStatement = $__10.createVariableStatement;
  var prependStatements = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PrependStatements.js", "traceur@0.0.108/src/codegeneration/TempVarTransformer.js")).prependStatements;
  var TempVarStatement = function() {
    function TempVarStatement(name, initializer) {
      this.name = name;
      this.initializer = initializer;
    }
    return ($traceurRuntime.createClass)(TempVarStatement, {}, {});
  }();
  var TempScope = function() {
    function TempScope() {
      this.identifiers = [];
    }
    return ($traceurRuntime.createClass)(TempScope, {
      push: function(identifier) {
        this.identifiers.push(identifier);
      },
      pop: function() {
        return this.identifiers.pop();
      },
      release: function(obj) {
        for (var i = this.identifiers.length - 1; i >= 0; i--) {
          obj.releaseTempName(this.identifiers[i]);
        }
      }
    }, {});
  }();
  var VarScope = function() {
    function VarScope(options) {
      this.thisName = null;
      this.argumentName = null;
      this.tempVarStatements = [];
      this.declarationType_ = options.blockBinding && !options.transformOptions.blockBinding ? LET : VAR;
    }
    return ($traceurRuntime.createClass)(VarScope, {
      push: function(tempVarStatement) {
        this.tempVarStatements.push(tempVarStatement);
      },
      pop: function() {
        return this.tempVarStatements.pop();
      },
      release: function(obj) {
        for (var i = this.tempVarStatements.length - 1; i >= 0; i--) {
          obj.releaseTempName(this.tempVarStatements[i].name);
        }
      },
      isEmpty: function() {
        return !this.tempVarStatements.length;
      },
      createVariableStatement: function() {
        var declarations = [];
        var seenNames = new StringSet();
        for (var i = 0; i < this.tempVarStatements.length; i++) {
          var $__4 = this.tempVarStatements[i],
              name = $__4.name,
              initializer = $__4.initializer;
          if (seenNames.has(name)) {
            if (initializer)
              throw new Error('Invalid use of TempVarTransformer');
            continue;
          }
          seenNames.add(name);
          declarations.push(createVariableDeclaration(name, initializer));
        }
        return createVariableStatement(createVariableDeclarationList(this.declarationType_, declarations));
      }
    }, {});
  }();
  var TempVarTransformer = function($__super) {
    function TempVarTransformer(identifierGenerator, reporter, options) {
      $traceurRuntime.superConstructor(TempVarTransformer).call(this);
      this.identifierGenerator = identifierGenerator;
      this.reporter = reporter;
      this.options = options;
      this.tempVarStack_ = [new VarScope(this.options)];
      this.tempScopeStack_ = [new TempScope()];
      this.namePool_ = [];
    }
    return ($traceurRuntime.createClass)(TempVarTransformer, {
      transformStatements_: function(statements) {
        this.tempVarStack_.push(new VarScope(this.options));
        var transformedStatements = this.transformList(statements);
        var vars = this.tempVarStack_.pop();
        if (vars.isEmpty())
          return transformedStatements;
        var variableStatement = vars.createVariableStatement();
        vars.release(this);
        return prependStatements(transformedStatements, variableStatement);
      },
      transformScript: function(tree) {
        var scriptItemList = this.transformStatements_(tree.scriptItemList);
        if (scriptItemList === tree.scriptItemList) {
          return tree;
        }
        return new Script(tree.location, scriptItemList, tree.moduleName);
      },
      transformModule: function(tree) {
        var scriptItemList = this.transformStatements_(tree.scriptItemList);
        if (scriptItemList === tree.scriptItemList) {
          return tree;
        }
        return new Module(tree.location, scriptItemList, tree.moduleName);
      },
      transformFunctionBody: function(tree) {
        this.pushTempScope();
        var statements = this.transformStatements_(tree.statements);
        this.popTempScope();
        if (statements === tree.statements)
          return tree;
        return createFunctionBody(statements);
      },
      getTempIdentifier: function() {
        var name = this.getName_();
        this.tempScopeStack_[this.tempScopeStack_.length - 1].push(name);
        return name;
      },
      getName_: function() {
        return this.namePool_.length ? this.namePool_.pop() : this.identifierGenerator.generateUniqueIdentifier();
      },
      addTempVar: function() {
        var initializer = arguments[0] !== (void 0) ? arguments[0] : null;
        var vars = this.tempVarStack_[this.tempVarStack_.length - 1];
        var name = this.getName_();
        vars.push(new TempVarStatement(name, initializer));
        return name;
      },
      registerTempVarName: function(name) {
        var vars = this.tempVarStack_[this.tempVarStack_.length - 1];
        vars.push(new TempVarStatement(name, null));
      },
      addTempVarForThis: function() {
        var varScope = this.tempVarStack_[this.tempVarStack_.length - 1];
        return varScope.thisName || (varScope.thisName = this.addTempVar(createThisExpression()));
      },
      addTempVarForArguments: function() {
        var varScope = this.tempVarStack_[this.tempVarStack_.length - 1];
        return varScope.argumentName || (varScope.argumentName = this.addTempVar(createIdentifierExpression(ARGUMENTS)));
      },
      pushTempScope: function() {
        this.tempScopeStack_.push(new TempScope());
      },
      popTempScope: function() {
        this.tempScopeStack_.pop().release(this);
      },
      releaseTempName: function(name) {
        this.namePool_.push(name);
      }
    }, {}, $__super);
  }(ParseTreeTransformer);
  return {get TempVarTransformer() {
      return TempVarTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/ParseTreeVisitor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/ParseTreeVisitor.js";
  var ParseTreeVisitor = function() {
    function ParseTreeVisitor() {}
    return ($traceurRuntime.createClass)(ParseTreeVisitor, {
      visitAny: function(tree) {
        tree !== null && tree.visit(this);
      },
      visit: function(tree) {
        this.visitAny(tree);
      },
      visitList: function(list) {
        if (list) {
          for (var i = 0; i < list.length; i++) {
            this.visitAny(list[i]);
          }
        }
      },
      visitStateMachine: function(tree) {
        throw Error('State machines should not live outside of the GeneratorTransformer.');
      },
      visitAnnotation: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.args);
      },
      visitAnonBlock: function(tree) {
        this.visitList(tree.statements);
      },
      visitArgumentList: function(tree) {
        this.visitList(tree.args);
      },
      visitArrayComprehension: function(tree) {
        this.visitList(tree.comprehensionList);
        this.visitAny(tree.expression);
      },
      visitArrayLiteral: function(tree) {
        this.visitList(tree.elements);
      },
      visitArrayPattern: function(tree) {
        this.visitList(tree.elements);
      },
      visitArrayType: function(tree) {
        this.visitAny(tree.elementType);
      },
      visitArrowFunction: function(tree) {
        this.visitAny(tree.parameterList);
        this.visitAny(tree.body);
      },
      visitAssignmentElement: function(tree) {
        this.visitAny(tree.assignment);
        this.visitAny(tree.initializer);
      },
      visitAwaitExpression: function(tree) {
        this.visitAny(tree.expression);
      },
      visitBinaryExpression: function(tree) {
        this.visitAny(tree.left);
        this.visitAny(tree.right);
      },
      visitBindingElement: function(tree) {
        this.visitAny(tree.binding);
        this.visitAny(tree.initializer);
      },
      visitBindingIdentifier: function(tree) {},
      visitBlock: function(tree) {
        this.visitList(tree.statements);
      },
      visitBreakStatement: function(tree) {},
      visitCallExpression: function(tree) {
        this.visitAny(tree.operand);
        this.visitAny(tree.args);
      },
      visitCallSignature: function(tree) {
        this.visitAny(tree.typeParameters);
        this.visitAny(tree.parameterList);
        this.visitAny(tree.returnType);
      },
      visitCaseClause: function(tree) {
        this.visitAny(tree.expression);
        this.visitList(tree.statements);
      },
      visitCatch: function(tree) {
        this.visitAny(tree.binding);
        this.visitAny(tree.catchBody);
      },
      visitClassDeclaration: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.superClass);
        this.visitList(tree.elements);
        this.visitList(tree.annotations);
        this.visitAny(tree.typeParameters);
      },
      visitClassExpression: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.superClass);
        this.visitList(tree.elements);
        this.visitList(tree.annotations);
        this.visitAny(tree.typeParameters);
      },
      visitCommaExpression: function(tree) {
        this.visitList(tree.expressions);
      },
      visitComprehensionFor: function(tree) {
        this.visitAny(tree.left);
        this.visitAny(tree.iterator);
      },
      visitComprehensionIf: function(tree) {
        this.visitAny(tree.expression);
      },
      visitComputedPropertyName: function(tree) {
        this.visitAny(tree.expression);
      },
      visitConditionalExpression: function(tree) {
        this.visitAny(tree.condition);
        this.visitAny(tree.left);
        this.visitAny(tree.right);
      },
      visitConstructSignature: function(tree) {
        this.visitAny(tree.typeParameters);
        this.visitAny(tree.parameterList);
        this.visitAny(tree.returnType);
      },
      visitConstructorType: function(tree) {
        this.visitAny(tree.typeParameters);
        this.visitAny(tree.parameterList);
        this.visitAny(tree.returnType);
      },
      visitContinueStatement: function(tree) {},
      visitCoverFormals: function(tree) {
        this.visitList(tree.expressions);
      },
      visitCoverInitializedName: function(tree) {
        this.visitAny(tree.initializer);
      },
      visitDebuggerStatement: function(tree) {},
      visitDefaultClause: function(tree) {
        this.visitList(tree.statements);
      },
      visitDoWhileStatement: function(tree) {
        this.visitAny(tree.body);
        this.visitAny(tree.condition);
      },
      visitEmptyStatement: function(tree) {},
      visitExportDeclaration: function(tree) {
        this.visitAny(tree.declaration);
        this.visitList(tree.annotations);
      },
      visitExportDefault: function(tree) {
        this.visitAny(tree.expression);
      },
      visitExportSpecifier: function(tree) {},
      visitExportSpecifierSet: function(tree) {
        this.visitList(tree.specifiers);
      },
      visitExportStar: function(tree) {},
      visitExpressionStatement: function(tree) {
        this.visitAny(tree.expression);
      },
      visitFinally: function(tree) {
        this.visitAny(tree.block);
      },
      visitForInStatement: function(tree) {
        this.visitAny(tree.initializer);
        this.visitAny(tree.collection);
        this.visitAny(tree.body);
      },
      visitForOfStatement: function(tree) {
        this.visitAny(tree.initializer);
        this.visitAny(tree.collection);
        this.visitAny(tree.body);
      },
      visitForOnStatement: function(tree) {
        this.visitAny(tree.initializer);
        this.visitAny(tree.observable);
        this.visitAny(tree.body);
      },
      visitForStatement: function(tree) {
        this.visitAny(tree.initializer);
        this.visitAny(tree.condition);
        this.visitAny(tree.increment);
        this.visitAny(tree.body);
      },
      visitFormalParameter: function(tree) {
        this.visitAny(tree.parameter);
        this.visitAny(tree.typeAnnotation);
        this.visitList(tree.annotations);
      },
      visitFormalParameterList: function(tree) {
        this.visitList(tree.parameters);
      },
      visitForwardDefaultExport: function(tree) {},
      visitFunctionBody: function(tree) {
        this.visitList(tree.statements);
      },
      visitFunctionDeclaration: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.parameterList);
        this.visitAny(tree.typeAnnotation);
        this.visitList(tree.annotations);
        this.visitAny(tree.body);
      },
      visitFunctionExpression: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.parameterList);
        this.visitAny(tree.typeAnnotation);
        this.visitList(tree.annotations);
        this.visitAny(tree.body);
      },
      visitFunctionType: function(tree) {
        this.visitAny(tree.typeParameters);
        this.visitAny(tree.parameterList);
        this.visitAny(tree.returnType);
      },
      visitGeneratorComprehension: function(tree) {
        this.visitList(tree.comprehensionList);
        this.visitAny(tree.expression);
      },
      visitGetAccessor: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.typeAnnotation);
        this.visitList(tree.annotations);
        this.visitAny(tree.body);
      },
      visitIdentifierExpression: function(tree) {},
      visitIfStatement: function(tree) {
        this.visitAny(tree.condition);
        this.visitAny(tree.ifClause);
        this.visitAny(tree.elseClause);
      },
      visitImportedBinding: function(tree) {
        this.visitAny(tree.binding);
      },
      visitImportClausePair: function(tree) {
        this.visitAny(tree.first);
        this.visitAny(tree.second);
      },
      visitImportDeclaration: function(tree) {
        this.visitAny(tree.importClause);
        this.visitAny(tree.moduleSpecifier);
      },
      visitImportSpecifier: function(tree) {
        this.visitAny(tree.binding);
      },
      visitImportSpecifierSet: function(tree) {
        this.visitList(tree.specifiers);
      },
      visitImportTypeClause: function(tree) {
        this.visitAny(tree.clause);
      },
      visitIndexSignature: function(tree) {
        this.visitAny(tree.indexType);
        this.visitAny(tree.typeAnnotation);
      },
      visitInterfaceDeclaration: function(tree) {
        this.visitAny(tree.typeParameters);
        this.visitAny(tree.objectType);
      },
      visitJsxAttribute: function(tree) {
        this.visitAny(tree.value);
      },
      visitJsxElement: function(tree) {
        this.visitAny(tree.name);
        this.visitList(tree.attributes);
        this.visitList(tree.children);
      },
      visitJsxElementName: function(tree) {},
      visitJsxPlaceholder: function(tree) {
        this.visitAny(tree.expression);
      },
      visitJsxSpreadAttribute: function(tree) {
        this.visitAny(tree.expression);
      },
      visitJsxText: function(tree) {},
      visitLabelledStatement: function(tree) {
        this.visitAny(tree.statement);
      },
      visitLiteralExpression: function(tree) {},
      visitLiteralPropertyName: function(tree) {},
      visitMemberExpression: function(tree) {
        this.visitAny(tree.operand);
      },
      visitMemberLookupExpression: function(tree) {
        this.visitAny(tree.operand);
        this.visitAny(tree.memberExpression);
      },
      visitMethod: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.parameterList);
        this.visitAny(tree.typeAnnotation);
        this.visitList(tree.annotations);
        this.visitAny(tree.body);
        this.visitAny(tree.debugName);
      },
      visitMethodSignature: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.callSignature);
      },
      visitModule: function(tree) {
        this.visitList(tree.scriptItemList);
      },
      visitModuleSpecifier: function(tree) {},
      visitNameSpaceExport: function(tree) {},
      visitNameSpaceImport: function(tree) {
        this.visitAny(tree.binding);
      },
      visitNamedExport: function(tree) {
        this.visitAny(tree.exportClause);
        this.visitAny(tree.moduleSpecifier);
      },
      visitNewExpression: function(tree) {
        this.visitAny(tree.operand);
        this.visitAny(tree.args);
      },
      visitObjectLiteral: function(tree) {
        this.visitList(tree.propertyNameAndValues);
      },
      visitObjectPattern: function(tree) {
        this.visitList(tree.fields);
      },
      visitObjectPatternField: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.element);
      },
      visitObjectType: function(tree) {
        this.visitList(tree.typeMembers);
      },
      visitParenExpression: function(tree) {
        this.visitAny(tree.expression);
      },
      visitPostfixExpression: function(tree) {
        this.visitAny(tree.operand);
      },
      visitPredefinedType: function(tree) {},
      visitScript: function(tree) {
        this.visitList(tree.scriptItemList);
      },
      visitPropertyNameAssignment: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.value);
      },
      visitPropertyNameShorthand: function(tree) {},
      visitPropertyVariableDeclaration: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.typeAnnotation);
        this.visitList(tree.annotations);
        this.visitAny(tree.initializer);
      },
      visitPropertySignature: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.typeAnnotation);
      },
      visitRestParameter: function(tree) {
        this.visitAny(tree.identifier);
      },
      visitReturnStatement: function(tree) {
        this.visitAny(tree.expression);
      },
      visitSetAccessor: function(tree) {
        this.visitAny(tree.name);
        this.visitAny(tree.parameterList);
        this.visitList(tree.annotations);
        this.visitAny(tree.body);
      },
      visitSpreadExpression: function(tree) {
        this.visitAny(tree.expression);
      },
      visitSpreadPatternElement: function(tree) {
        this.visitAny(tree.lvalue);
      },
      visitSuperExpression: function(tree) {},
      visitSwitchStatement: function(tree) {
        this.visitAny(tree.expression);
        this.visitList(tree.caseClauses);
      },
      visitSyntaxErrorTree: function(tree) {},
      visitTemplateLiteralExpression: function(tree) {
        this.visitAny(tree.operand);
        this.visitList(tree.elements);
      },
      visitTemplateLiteralPortion: function(tree) {},
      visitTemplateSubstitution: function(tree) {
        this.visitAny(tree.expression);
      },
      visitThisExpression: function(tree) {},
      visitThrowStatement: function(tree) {
        this.visitAny(tree.value);
      },
      visitTryStatement: function(tree) {
        this.visitAny(tree.body);
        this.visitAny(tree.catchBlock);
        this.visitAny(tree.finallyBlock);
      },
      visitTypeAliasDeclaration: function(tree) {
        this.visitAny(tree.value);
      },
      visitTypeArguments: function(tree) {
        this.visitList(tree.args);
      },
      visitTypeName: function(tree) {
        this.visitAny(tree.moduleName);
      },
      visitTypeParameter: function(tree) {
        this.visitAny(tree.extendsType);
      },
      visitTypeParameters: function(tree) {
        this.visitList(tree.parameters);
      },
      visitTypeReference: function(tree) {
        this.visitAny(tree.typeName);
        this.visitAny(tree.args);
      },
      visitUnaryExpression: function(tree) {
        this.visitAny(tree.operand);
      },
      visitUnionType: function(tree) {
        this.visitList(tree.types);
      },
      visitVariableDeclaration: function(tree) {
        this.visitAny(tree.lvalue);
        this.visitAny(tree.typeAnnotation);
        this.visitAny(tree.initializer);
      },
      visitVariableDeclarationList: function(tree) {
        this.visitList(tree.declarations);
      },
      visitVariableStatement: function(tree) {
        this.visitAny(tree.declarations);
      },
      visitWhileStatement: function(tree) {
        this.visitAny(tree.condition);
        this.visitAny(tree.body);
      },
      visitWithStatement: function(tree) {
        this.visitAny(tree.expression);
        this.visitAny(tree.body);
      },
      visitYieldExpression: function(tree) {
        this.visitAny(tree.expression);
      }
    }, {});
  }();
  return {get ParseTreeVisitor() {
      return ParseTreeVisitor;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/semantics/bindingsInDestructuringPattern.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/semantics/bindingsInDestructuringPattern.js";
  var ParseTreeVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/ParseTreeVisitor.js", "traceur@0.0.108/src/semantics/bindingsInDestructuringPattern.js")).ParseTreeVisitor;
  var StringSet = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/StringSet.js", "traceur@0.0.108/src/semantics/bindingsInDestructuringPattern.js")).StringSet;
  var BindingsInDestructuringPatternVisitor = function($__super) {
    function BindingsInDestructuringPatternVisitor() {
      $traceurRuntime.superConstructor(BindingsInDestructuringPatternVisitor).call(this);
      this.bindings = new StringSet();
    }
    return ($traceurRuntime.createClass)(BindingsInDestructuringPatternVisitor, {
      visitBindingIdentifier: function(tree) {
        this.bindings.add(tree.getStringValue());
      },
      visitBindingElement: function(tree) {
        this.visitAny(tree.binding);
      },
      visitVariableDeclaration: function(tree) {
        this.visitAny(tree.lvalue);
      }
    }, {}, $__super);
  }(ParseTreeVisitor);
  function bindingsInDestructuringPattern(tree) {
    var v = new BindingsInDestructuringPatternVisitor();
    v.visitAny(tree);
    return v.bindings;
  }
  var $__default = bindingsInDestructuringPattern;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/FindVisitor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/FindVisitor.js";
  var ParseTreeVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/ParseTreeVisitor.js", "traceur@0.0.108/src/codegeneration/FindVisitor.js")).ParseTreeVisitor;
  var FindVisitor = function($__super) {
    function FindVisitor() {
      var keepOnGoing = arguments[0];
      $traceurRuntime.superConstructor(FindVisitor).call(this);
      this.found_ = false;
      this.shouldContinue_ = true;
      this.keepOnGoing_ = keepOnGoing;
    }
    return ($traceurRuntime.createClass)(FindVisitor, {
      get found() {
        return this.found_;
      },
      set found(v) {
        if (v) {
          this.found_ = true;
          if (!this.keepOnGoing_)
            this.shouldContinue_ = false;
        }
      },
      visitAny: function(tree) {
        this.shouldContinue_ && tree && tree.visit(this);
      },
      visitList: function(list) {
        if (list) {
          for (var i = 0; this.shouldContinue_ && i < list.length; i++) {
            this.visitAny(list[i]);
          }
        }
      }
    }, {}, $__super);
  }(ParseTreeVisitor);
  return {get FindVisitor() {
      return FindVisitor;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/util/SyntaxErrorReporter.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/util/SyntaxErrorReporter.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ErrorReporter.js", "traceur@0.0.108/src/util/SyntaxErrorReporter.js")),
      ErrorReporter = $__1.ErrorReporter,
      format = $__1.format;
  var SyntaxErrorReporter = function($__super) {
    function SyntaxErrorReporter() {
      $traceurRuntime.superConstructor(SyntaxErrorReporter).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(SyntaxErrorReporter, {reportMessageInternal: function(location, message) {
        var s = format(location, message);
        throw new SyntaxError(s);
      }}, {}, $__super);
  }(ErrorReporter);
  return {get SyntaxErrorReporter() {
      return SyntaxErrorReporter;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/JsxIdentifierToken.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/JsxIdentifierToken.js";
  var Token = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Token.js", "traceur@0.0.108/src/syntax/JsxIdentifierToken.js")).Token;
  var JSX_IDENTIFIER = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TokenType.js", "traceur@0.0.108/src/syntax/JsxIdentifierToken.js")).JSX_IDENTIFIER;
  var JsxIdentifierToken = function($__super) {
    function JsxIdentifierToken(location, value) {
      $traceurRuntime.superConstructor(JsxIdentifierToken).call(this, JSX_IDENTIFIER, location);
      this.value = value;
    }
    return ($traceurRuntime.createClass)(JsxIdentifierToken, {toString: function() {
        return this.value;
      }}, {}, $__super);
  }(Token);
  return {get JsxIdentifierToken() {
      return JsxIdentifierToken;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/Keywords.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/Keywords.js";
  var keywords = ['break', 'case', 'catch', 'class', 'const', 'continue', 'debugger', 'default', 'delete', 'do', 'else', 'export', 'finally', 'for', 'function', 'if', 'import', 'in', 'instanceof', 'let', 'new', 'return', 'super', 'switch', 'this', 'throw', 'try', 'typeof', 'var', 'void', 'while', 'with', 'enum', 'extends', 'null', 'true', 'false'];
  var strictKeywords = ['implements', 'interface', 'package', 'private', 'protected', 'public', 'static', 'yield'];
  var keywordsByName = Object.create(null);
  var NORMAL_KEYWORD = 1;
  var STRICT_KEYWORD = 2;
  keywords.forEach(function(value) {
    keywordsByName[value] = NORMAL_KEYWORD;
  });
  strictKeywords.forEach(function(value) {
    keywordsByName[value] = STRICT_KEYWORD;
  });
  function getKeywordType(value) {
    return keywordsByName[value];
  }
  function isStrictKeyword(value) {
    return getKeywordType(value) === STRICT_KEYWORD;
  }
  return {
    get NORMAL_KEYWORD() {
      return NORMAL_KEYWORD;
    },
    get STRICT_KEYWORD() {
      return STRICT_KEYWORD;
    },
    get getKeywordType() {
      return getKeywordType;
    },
    get isStrictKeyword() {
      return isStrictKeyword;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/KeywordToken.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/KeywordToken.js";
  var STRICT_KEYWORD = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Keywords.js", "traceur@0.0.108/src/syntax/KeywordToken.js")).STRICT_KEYWORD;
  var Token = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Token.js", "traceur@0.0.108/src/syntax/KeywordToken.js")).Token;
  var KeywordToken = function($__super) {
    function KeywordToken(type, keywordType, location) {
      $traceurRuntime.superConstructor(KeywordToken).call(this, type, location);
      this.isStrictKeyword_ = keywordType === STRICT_KEYWORD;
    }
    return ($traceurRuntime.createClass)(KeywordToken, {
      isKeyword: function() {
        return true;
      },
      isStrictKeyword: function() {
        return this.isStrictKeyword_;
      }
    }, {}, $__super);
  }(Token);
  return {get KeywordToken() {
      return KeywordToken;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/unicode-tables.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/unicode-tables.js";
  var idStartTable = [170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 442, 443, 443, 444, 447, 448, 451, 452, 659, 660, 660, 661, 687, 688, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 883, 884, 884, 886, 887, 890, 890, 891, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1377, 1415, 1488, 1514, 1520, 1522, 1568, 1599, 1600, 1600, 1601, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2048, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2208, 2226, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2417, 2418, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2545, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3161, 3168, 3169, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3294, 3294, 3296, 3297, 3313, 3314, 3333, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3424, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3648, 3653, 3654, 3654, 3713, 3714, 3716, 3716, 3719, 3720, 3722, 3722, 3725, 3725, 3732, 3735, 3737, 3743, 3745, 3747, 3749, 3749, 3751, 3751, 3754, 3755, 3757, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4348, 4349, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5108, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5872, 5873, 5880, 5888, 5900, 5902, 5905, 5920, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6108, 6108, 6176, 6210, 6211, 6211, 6212, 6263, 6272, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6593, 6599, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6987, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7287, 7288, 7293, 7401, 7404, 7406, 7409, 7413, 7414, 7424, 7467, 7468, 7530, 7531, 7543, 7544, 7544, 7545, 7578, 7579, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8305, 8305, 8319, 8319, 8336, 8348, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8472, 8472, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8494, 8494, 8495, 8500, 8501, 8504, 8505, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8578, 8579, 8580, 8581, 8584, 11264, 11310, 11312, 11358, 11360, 11387, 11388, 11389, 11390, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 12293, 12293, 12294, 12294, 12295, 12295, 12321, 12329, 12337, 12341, 12344, 12346, 12347, 12347, 12348, 12348, 12353, 12438, 12443, 12444, 12445, 12446, 12447, 12447, 12449, 12538, 12540, 12542, 12543, 12543, 12549, 12589, 12593, 12686, 12704, 12730, 12784, 12799, 13312, 19893, 19968, 40908, 40960, 40980, 40981, 40981, 40982, 42124, 42192, 42231, 42232, 42237, 42240, 42507, 42508, 42508, 42512, 42527, 42538, 42539, 42560, 42605, 42606, 42606, 42623, 42623, 42624, 42651, 42652, 42653, 42656, 42725, 42726, 42735, 42775, 42783, 42786, 42863, 42864, 42864, 42865, 42887, 42888, 42888, 42891, 42894, 42896, 42925, 42928, 42929, 42999, 42999, 43000, 43001, 43002, 43002, 43003, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43494, 43495, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43631, 43632, 43632, 43633, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43740, 43741, 43741, 43744, 43754, 43762, 43762, 43763, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43871, 43876, 43877, 43968, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65136, 65140, 65142, 65276, 65313, 65338, 65345, 65370, 65382, 65391, 65392, 65392, 65393, 65437, 65438, 65439, 65440, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66352, 66368, 66369, 66369, 66370, 66377, 66378, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66639, 66640, 66717, 66816, 66855, 66864, 66915, 67072, 67382, 67392, 67413, 67424, 67431, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68147, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 69635, 69687, 69763, 69807, 69840, 69864, 69891, 69926, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70144, 70161, 70163, 70187, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70493, 70497, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71168, 71215, 71236, 71236, 71296, 71338, 71840, 71903, 71935, 71935, 72384, 72440, 73728, 74648, 74752, 74862, 77824, 78894, 92160, 92728, 92736, 92766, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93952, 94020, 94032, 94032, 94099, 94111, 110592, 110593, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 124928, 125124, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173782, 173824, 177972, 177984, 178205, 194560, 195101];
  var idContinueTable = [183, 183, 768, 879, 903, 903, 1155, 1159, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1552, 1562, 1611, 1631, 1632, 1641, 1648, 1648, 1750, 1756, 1759, 1764, 1767, 1768, 1770, 1773, 1776, 1785, 1809, 1809, 1840, 1866, 1958, 1968, 1984, 1993, 2027, 2035, 2070, 2073, 2075, 2083, 2085, 2087, 2089, 2093, 2137, 2139, 2276, 2306, 2307, 2307, 2362, 2362, 2363, 2363, 2364, 2364, 2366, 2368, 2369, 2376, 2377, 2380, 2381, 2381, 2382, 2383, 2385, 2391, 2402, 2403, 2406, 2415, 2433, 2433, 2434, 2435, 2492, 2492, 2494, 2496, 2497, 2500, 2503, 2504, 2507, 2508, 2509, 2509, 2519, 2519, 2530, 2531, 2534, 2543, 2561, 2562, 2563, 2563, 2620, 2620, 2622, 2624, 2625, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2662, 2671, 2672, 2673, 2677, 2677, 2689, 2690, 2691, 2691, 2748, 2748, 2750, 2752, 2753, 2757, 2759, 2760, 2761, 2761, 2763, 2764, 2765, 2765, 2786, 2787, 2790, 2799, 2817, 2817, 2818, 2819, 2876, 2876, 2878, 2878, 2879, 2879, 2880, 2880, 2881, 2884, 2887, 2888, 2891, 2892, 2893, 2893, 2902, 2902, 2903, 2903, 2914, 2915, 2918, 2927, 2946, 2946, 3006, 3007, 3008, 3008, 3009, 3010, 3014, 3016, 3018, 3020, 3021, 3021, 3031, 3031, 3046, 3055, 3072, 3072, 3073, 3075, 3134, 3136, 3137, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3170, 3171, 3174, 3183, 3201, 3201, 3202, 3203, 3260, 3260, 3262, 3262, 3263, 3263, 3264, 3268, 3270, 3270, 3271, 3272, 3274, 3275, 3276, 3277, 3285, 3286, 3298, 3299, 3302, 3311, 3329, 3329, 3330, 3331, 3390, 3392, 3393, 3396, 3398, 3400, 3402, 3404, 3405, 3405, 3415, 3415, 3426, 3427, 3430, 3439, 3458, 3459, 3530, 3530, 3535, 3537, 3538, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3633, 3633, 3636, 3642, 3655, 3662, 3664, 3673, 3761, 3761, 3764, 3769, 3771, 3772, 3784, 3789, 3792, 3801, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3903, 3953, 3966, 3967, 3967, 3968, 3972, 3974, 3975, 3981, 3991, 3993, 4028, 4038, 4038, 4139, 4140, 4141, 4144, 4145, 4145, 4146, 4151, 4152, 4152, 4153, 4154, 4155, 4156, 4157, 4158, 4160, 4169, 4182, 4183, 4184, 4185, 4190, 4192, 4194, 4196, 4199, 4205, 4209, 4212, 4226, 4226, 4227, 4228, 4229, 4230, 4231, 4236, 4237, 4237, 4239, 4239, 4240, 4249, 4250, 4252, 4253, 4253, 4957, 4959, 4969, 4977, 5906, 5908, 5938, 5940, 5970, 5971, 6002, 6003, 6068, 6069, 6070, 6070, 6071, 6077, 6078, 6085, 6086, 6086, 6087, 6088, 6089, 6099, 6109, 6109, 6112, 6121, 6155, 6157, 6160, 6169, 6313, 6313, 6432, 6434, 6435, 6438, 6439, 6440, 6441, 6443, 6448, 6449, 6450, 6450, 6451, 6456, 6457, 6459, 6470, 6479, 6576, 6592, 6600, 6601, 6608, 6617, 6618, 6618, 6679, 6680, 6681, 6682, 6683, 6683, 6741, 6741, 6742, 6742, 6743, 6743, 6744, 6750, 6752, 6752, 6753, 6753, 6754, 6754, 6755, 6756, 6757, 6764, 6765, 6770, 6771, 6780, 6783, 6783, 6784, 6793, 6800, 6809, 6832, 6845, 6912, 6915, 6916, 6916, 6964, 6964, 6965, 6965, 6966, 6970, 6971, 6971, 6972, 6972, 6973, 6977, 6978, 6978, 6979, 6980, 6992, 7001, 7019, 7027, 7040, 7041, 7042, 7042, 7073, 7073, 7074, 7077, 7078, 7079, 7080, 7081, 7082, 7082, 7083, 7085, 7088, 7097, 7142, 7142, 7143, 7143, 7144, 7145, 7146, 7148, 7149, 7149, 7150, 7150, 7151, 7153, 7154, 7155, 7204, 7211, 7212, 7219, 7220, 7221, 7222, 7223, 7232, 7241, 7248, 7257, 7376, 7378, 7380, 7392, 7393, 7393, 7394, 7400, 7405, 7405, 7410, 7411, 7412, 7412, 7416, 7417, 7616, 7669, 7676, 7679, 8255, 8256, 8276, 8276, 8400, 8412, 8417, 8417, 8421, 8432, 11503, 11505, 11647, 11647, 11744, 11775, 12330, 12333, 12334, 12335, 12441, 12442, 42528, 42537, 42607, 42607, 42612, 42621, 42655, 42655, 42736, 42737, 43010, 43010, 43014, 43014, 43019, 43019, 43043, 43044, 43045, 43046, 43047, 43047, 43136, 43137, 43188, 43203, 43204, 43204, 43216, 43225, 43232, 43249, 43264, 43273, 43302, 43309, 43335, 43345, 43346, 43347, 43392, 43394, 43395, 43395, 43443, 43443, 43444, 43445, 43446, 43449, 43450, 43451, 43452, 43452, 43453, 43456, 43472, 43481, 43493, 43493, 43504, 43513, 43561, 43566, 43567, 43568, 43569, 43570, 43571, 43572, 43573, 43574, 43587, 43587, 43596, 43596, 43597, 43597, 43600, 43609, 43643, 43643, 43644, 43644, 43645, 43645, 43696, 43696, 43698, 43700, 43703, 43704, 43710, 43711, 43713, 43713, 43755, 43755, 43756, 43757, 43758, 43759, 43765, 43765, 43766, 43766, 44003, 44004, 44005, 44005, 44006, 44007, 44008, 44008, 44009, 44010, 44012, 44012, 44013, 44013, 44016, 44025, 64286, 64286, 65024, 65039, 65056, 65069, 65075, 65076, 65101, 65103, 65296, 65305, 65343, 65343, 66045, 66045, 66272, 66272, 66422, 66426, 66720, 66729, 68097, 68099, 68101, 68102, 68108, 68111, 68152, 68154, 68159, 68159, 68325, 68326, 69632, 69632, 69633, 69633, 69634, 69634, 69688, 69702, 69734, 69743, 69759, 69761, 69762, 69762, 69808, 69810, 69811, 69814, 69815, 69816, 69817, 69818, 69872, 69881, 69888, 69890, 69927, 69931, 69932, 69932, 69933, 69940, 69942, 69951, 70003, 70003, 70016, 70017, 70018, 70018, 70067, 70069, 70070, 70078, 70079, 70080, 70096, 70105, 70188, 70190, 70191, 70193, 70194, 70195, 70196, 70196, 70197, 70197, 70198, 70199, 70367, 70367, 70368, 70370, 70371, 70378, 70384, 70393, 70401, 70401, 70402, 70403, 70460, 70460, 70462, 70463, 70464, 70464, 70465, 70468, 70471, 70472, 70475, 70477, 70487, 70487, 70498, 70499, 70502, 70508, 70512, 70516, 70832, 70834, 70835, 70840, 70841, 70841, 70842, 70842, 70843, 70846, 70847, 70848, 70849, 70849, 70850, 70851, 70864, 70873, 71087, 71089, 71090, 71093, 71096, 71099, 71100, 71101, 71102, 71102, 71103, 71104, 71216, 71218, 71219, 71226, 71227, 71228, 71229, 71229, 71230, 71230, 71231, 71232, 71248, 71257, 71339, 71339, 71340, 71340, 71341, 71341, 71342, 71343, 71344, 71349, 71350, 71350, 71351, 71351, 71360, 71369, 71904, 71913, 92768, 92777, 92912, 92916, 92976, 92982, 93008, 93017, 94033, 94078, 94095, 94098, 113821, 113822, 119141, 119142, 119143, 119145, 119149, 119154, 119163, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 120782, 120831, 125136, 125142, 917760, 917999];
  return {
    get idStartTable() {
      return idStartTable;
    },
    get idContinueTable() {
      return idContinueTable;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/Scanner.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/Scanner.js";
  var IdentifierToken = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./IdentifierToken.js", "traceur@0.0.108/src/syntax/Scanner.js")).IdentifierToken;
  var JsxIdentifierToken = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./JsxIdentifierToken.js", "traceur@0.0.108/src/syntax/Scanner.js")).JsxIdentifierToken;
  var KeywordToken = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./KeywordToken.js", "traceur@0.0.108/src/syntax/Scanner.js")).KeywordToken;
  var LiteralToken = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./LiteralToken.js", "traceur@0.0.108/src/syntax/Scanner.js")).LiteralToken;
  var SourceRange = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/SourceRange.js", "traceur@0.0.108/src/syntax/Scanner.js")).SourceRange;
  var Token = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Token.js", "traceur@0.0.108/src/syntax/Scanner.js")).Token;
  var getKeywordType = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Keywords.js", "traceur@0.0.108/src/syntax/Scanner.js")).getKeywordType;
  var $__10 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./unicode-tables.js", "traceur@0.0.108/src/syntax/Scanner.js")),
      idContinueTable = $__10.idContinueTable,
      idStartTable = $__10.idStartTable;
  var $__11 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TokenType.js", "traceur@0.0.108/src/syntax/Scanner.js")),
      AMPERSAND = $__11.AMPERSAND,
      AMPERSAND_EQUAL = $__11.AMPERSAND_EQUAL,
      AND = $__11.AND,
      ARROW = $__11.ARROW,
      AT = $__11.AT,
      BANG = $__11.BANG,
      BAR = $__11.BAR,
      BAR_EQUAL = $__11.BAR_EQUAL,
      CARET = $__11.CARET,
      CARET_EQUAL = $__11.CARET_EQUAL,
      CLOSE_ANGLE = $__11.CLOSE_ANGLE,
      CLOSE_CURLY = $__11.CLOSE_CURLY,
      CLOSE_PAREN = $__11.CLOSE_PAREN,
      CLOSE_SQUARE = $__11.CLOSE_SQUARE,
      COLON = $__11.COLON,
      COMMA = $__11.COMMA,
      DOT_DOT_DOT = $__11.DOT_DOT_DOT,
      END_OF_FILE = $__11.END_OF_FILE,
      EQUAL = $__11.EQUAL,
      EQUAL_EQUAL = $__11.EQUAL_EQUAL,
      EQUAL_EQUAL_EQUAL = $__11.EQUAL_EQUAL_EQUAL,
      ERROR = $__11.ERROR,
      GREATER_EQUAL = $__11.GREATER_EQUAL,
      LEFT_SHIFT = $__11.LEFT_SHIFT,
      LEFT_SHIFT_EQUAL = $__11.LEFT_SHIFT_EQUAL,
      LESS_EQUAL = $__11.LESS_EQUAL,
      MINUS = $__11.MINUS,
      MINUS_EQUAL = $__11.MINUS_EQUAL,
      MINUS_MINUS = $__11.MINUS_MINUS,
      NO_SUBSTITUTION_TEMPLATE = $__11.NO_SUBSTITUTION_TEMPLATE,
      NOT_EQUAL = $__11.NOT_EQUAL,
      NOT_EQUAL_EQUAL = $__11.NOT_EQUAL_EQUAL,
      NUMBER = $__11.NUMBER,
      OPEN_ANGLE = $__11.OPEN_ANGLE,
      OPEN_CURLY = $__11.OPEN_CURLY,
      OPEN_PAREN = $__11.OPEN_PAREN,
      OPEN_SQUARE = $__11.OPEN_SQUARE,
      OR = $__11.OR,
      PERCENT = $__11.PERCENT,
      PERCENT_EQUAL = $__11.PERCENT_EQUAL,
      PERIOD = $__11.PERIOD,
      PLUS = $__11.PLUS,
      PLUS_EQUAL = $__11.PLUS_EQUAL,
      PLUS_PLUS = $__11.PLUS_PLUS,
      QUESTION = $__11.QUESTION,
      REGULAR_EXPRESSION = $__11.REGULAR_EXPRESSION,
      RIGHT_SHIFT = $__11.RIGHT_SHIFT,
      RIGHT_SHIFT_EQUAL = $__11.RIGHT_SHIFT_EQUAL,
      SEMI_COLON = $__11.SEMI_COLON,
      SLASH = $__11.SLASH,
      SLASH_EQUAL = $__11.SLASH_EQUAL,
      STAR = $__11.STAR,
      STAR_EQUAL = $__11.STAR_EQUAL,
      STAR_STAR = $__11.STAR_STAR,
      STAR_STAR_EQUAL = $__11.STAR_STAR_EQUAL,
      STRING = $__11.STRING,
      TEMPLATE_HEAD = $__11.TEMPLATE_HEAD,
      TEMPLATE_MIDDLE = $__11.TEMPLATE_MIDDLE,
      TEMPLATE_TAIL = $__11.TEMPLATE_TAIL,
      TILDE = $__11.TILDE,
      UNSIGNED_RIGHT_SHIFT = $__11.UNSIGNED_RIGHT_SHIFT,
      UNSIGNED_RIGHT_SHIFT_EQUAL = $__11.UNSIGNED_RIGHT_SHIFT_EQUAL;
  var isWhitespaceArray = [];
  for (var i = 0; i < 128; i++) {
    isWhitespaceArray[i] = i >= 9 && i <= 13 || i === 0x20;
  }
  function isWhitespace(code) {
    if (code < 128)
      return isWhitespaceArray[code];
    switch (code) {
      case 0xA0:
      case 0xFEFF:
      case 0x2028:
      case 0x2029:
        return true;
    }
    return false;
  }
  function isLineTerminator(code) {
    switch (code) {
      case 10:
      case 13:
      case 0x2028:
      case 0x2029:
        return true;
    }
    return false;
  }
  function isDecimalDigit(code) {
    return code >= 48 && code <= 57;
  }
  var isHexDigitArray = [];
  for (var i$__0 = 0; i$__0 < 128; i$__0++) {
    isHexDigitArray[i$__0] = i$__0 >= 48 && i$__0 <= 57 || i$__0 >= 65 && i$__0 <= 70 || i$__0 >= 97 && i$__0 <= 102;
  }
  function isHexDigit(code) {
    return code < 128 && isHexDigitArray[code];
  }
  function isBinaryDigit(code) {
    return code === 48 || code === 49;
  }
  function isOctalDigit(code) {
    return code >= 48 && code <= 55;
  }
  var isIdentifierStartArray = [];
  for (var i$__1 = 0; i$__1 < 128; i$__1++) {
    isIdentifierStartArray[i$__1] = i$__1 === 36 || i$__1 >= 65 && i$__1 <= 90 || i$__1 === 95 || i$__1 >= 97 && i$__1 <= 122;
  }
  function isIdentifierStart(code) {
    return code < 128 ? isIdentifierStartArray[code] : inTable(idStartTable, code);
  }
  var isIdentifierPartArray = [];
  for (var i$__2 = 0; i$__2 < 128; i$__2++) {
    isIdentifierPartArray[i$__2] = isIdentifierStart(i$__2) || isDecimalDigit(i$__2);
  }
  function isIdentifierPart(code) {
    return code < 128 ? isIdentifierPartArray[code] : inTable(idStartTable, code) || inTable(idContinueTable, code) || code === 8204 || code === 8205;
  }
  function inTable(table, code) {
    for (var i = 0; i < table.length; ) {
      if (code < table[i++])
        return false;
      if (code <= table[i++])
        return true;
    }
    return false;
  }
  function isRegularExpressionChar(code) {
    switch (code) {
      case 47:
        return false;
      case 91:
      case 92:
        return true;
    }
    return !isLineTerminator(code);
  }
  function isRegularExpressionFirstChar(code) {
    return isRegularExpressionChar(code) && code !== 42;
  }
  var index,
      input,
      length,
      token,
      lastToken,
      lookaheadToken,
      currentCharCode,
      lineNumberTable,
      errorReporter,
      currentParser,
      options;
  function init(reporter, file, parser, traceurOptions) {
    errorReporter = reporter;
    lineNumberTable = file.lineNumberTable;
    input = file.contents;
    length = file.contents.length;
    setIndex(0);
    currentParser = parser;
    options = traceurOptions;
  }
  function getLastToken() {
    return lastToken;
  }
  function nextRegularExpressionLiteralToken() {
    lastToken = nextRegularExpressionLiteralToken2();
    token = scanToken();
    return lastToken;
  }
  function nextTemplateLiteralToken() {
    var t = nextTemplateLiteralToken2();
    token = scanToken();
    return t;
  }
  function setIndex(i) {
    index = i;
    lastToken = null;
    token = null;
    lookaheadToken = null;
    updateCurrentCharCode();
  }
  function getPosition() {
    return getPositionByOffset(getOffset());
  }
  function getPositionByOffset(offset) {
    return lineNumberTable.getSourcePosition(offset);
  }
  function nextCloseAngle() {
    switch (token.type) {
      case GREATER_EQUAL:
      case RIGHT_SHIFT:
      case RIGHT_SHIFT_EQUAL:
      case UNSIGNED_RIGHT_SHIFT:
      case UNSIGNED_RIGHT_SHIFT_EQUAL:
        setIndex(index - token.type.length + 1);
        lastToken = createToken(CLOSE_ANGLE, index);
        token = scanToken();
        return lastToken;
    }
    return nextToken();
  }
  function getTokenRange(startOffset) {
    return lineNumberTable.getSourceRange(startOffset, index);
  }
  function getOffset() {
    return token ? token.location.start.offset : index;
  }
  function nextRegularExpressionLiteralToken2() {
    var beginIndex = index - token.toString().length;
    if (token.type === SLASH_EQUAL) {
      skipRegularExpressionBodyContinuation();
    } else {
      skipRegularExpressionBody(beginIndex);
    }
    if (currentCharCode !== 47) {
      reportError('Expected \'/\' in regular expression literal', beginIndex);
      return new LiteralToken(REGULAR_EXPRESSION, getTokenString(beginIndex), getTokenRange(beginIndex));
    }
    next();
    while (isIdentifierPart(currentCharCode)) {
      next();
    }
    return new LiteralToken(REGULAR_EXPRESSION, getTokenString(beginIndex), getTokenRange(beginIndex));
  }
  function skipRegularExpressionBody(beginIndex) {
    if (!isRegularExpressionFirstChar(currentCharCode)) {
      reportError('Expected regular expression first char', beginIndex);
      return;
    }
    skipRegularExpressionBodyContinuation();
  }
  function skipRegularExpressionBodyContinuation() {
    while (!isAtEnd() && isRegularExpressionChar(currentCharCode)) {
      if (!skipRegularExpressionChar()) {
        return;
      }
    }
  }
  function skipRegularExpressionChar() {
    switch (currentCharCode) {
      case 92:
        return skipRegularExpressionBackslashSequence();
      case 91:
        return skipRegularExpressionClass();
      default:
        next();
        return true;
    }
  }
  function skipRegularExpressionBackslashSequence() {
    var beginIndex = index;
    next();
    if (isLineTerminator(currentCharCode) || isAtEnd()) {
      reportError('New line not allowed in regular expression literal', beginIndex, index);
      return false;
    }
    next();
    return true;
  }
  function skipRegularExpressionClass() {
    var beginIndex = index;
    next();
    while (!isAtEnd() && peekRegularExpressionClassChar()) {
      if (!skipRegularExpressionClassChar()) {
        return false;
      }
    }
    if (currentCharCode !== 93) {
      reportError('\']\' expected', beginIndex, index);
      return false;
    }
    next();
    return true;
  }
  function peekRegularExpressionClassChar() {
    return currentCharCode !== 93 && !isLineTerminator(currentCharCode);
  }
  function skipRegularExpressionClassChar() {
    if (currentCharCode === 92) {
      return skipRegularExpressionBackslashSequence();
    }
    next();
    return true;
  }
  function skipTemplateCharacter() {
    while (!isAtEnd()) {
      switch (currentCharCode) {
        case 96:
          return;
        case 92:
          skipStringLiteralEscapeSequence();
          break;
        case 36:
          {
            var code = input.charCodeAt(index + 1);
            if (code === 123)
              return;
            next();
            break;
          }
        default:
          next();
      }
    }
  }
  function scanTemplateStart(beginIndex) {
    if (isAtEnd()) {
      reportError('Unterminated template literal', beginIndex, index);
      return lastToken = createToken(END_OF_FILE, beginIndex);
    }
    return nextTemplateLiteralTokenShared(NO_SUBSTITUTION_TEMPLATE, TEMPLATE_HEAD);
  }
  function nextTemplateLiteralToken2() {
    if (isAtEnd()) {
      reportError('Expected \'}\' after expression in template literal', index, index);
      return createToken(END_OF_FILE, index);
    }
    if (token.type !== CLOSE_CURLY) {
      reportError('Expected \'}\' after expression in template literal', index, index);
      return createToken(ERROR, index);
    }
    return nextTemplateLiteralTokenShared(TEMPLATE_TAIL, TEMPLATE_MIDDLE);
  }
  function nextTemplateLiteralTokenShared(endType, middleType) {
    var beginIndex = index;
    skipTemplateCharacter();
    if (isAtEnd()) {
      reportError('Unterminated template literal');
      return createToken(ERROR, beginIndex);
    }
    var value = getTokenString(beginIndex);
    switch (currentCharCode) {
      case 96:
        next();
        return lastToken = new LiteralToken(endType, value, getTokenRange(beginIndex - 1));
      case 36:
        next();
        next();
        return lastToken = new LiteralToken(middleType, value, getTokenRange(beginIndex - 1));
    }
  }
  function peekJsxToken() {
    return token || (token = scanJsxToken());
  }
  function nextJsxToken() {
    lastToken = peekJsxToken();
    token = null;
    return lastToken;
  }
  function scanJsxToken() {
    skipComments();
    var beginIndex = index;
    switch (currentCharCode) {
      case 34:
      case 39:
        return scanJsxStringLiteral(beginIndex, currentCharCode);
      case 62:
        next();
        return createToken(CLOSE_ANGLE, beginIndex);
    }
    if (!isIdentifierStart(currentCharCode)) {
      return scanToken();
    }
    next();
    while (isIdentifierPart(currentCharCode) || currentCharCode === 45) {
      next();
    }
    var value = input.slice(beginIndex, index);
    return new JsxIdentifierToken(getTokenRange(beginIndex), value);
  }
  function scanJsxStringLiteral(beginIndex, terminator) {
    next();
    while (!isAtEnd() && currentCharCode !== terminator) {
      next();
    }
    if (currentCharCode !== terminator) {
      reportError('Unterminated String Literal', beginIndex);
    } else {
      next();
    }
    return new LiteralToken(STRING, getTokenString(beginIndex), getTokenRange(beginIndex));
  }
  function nextJsxTextToken() {
    lastToken = token || scanJsxTextToken();
    token = null;
    return lastToken;
  }
  function skipJsxText() {
    while (!isAtEnd() && peekJsxText()) {
      next();
    }
  }
  function isJsxTextChar(code) {
    switch (code) {
      case 60:
      case 123:
        return false;
    }
    return true;
  }
  function skipJsxText() {
    while (!isAtEnd() && isJsxTextChar(currentCharCode)) {
      next();
    }
  }
  function scanJsxTextToken() {
    var beginIndex = index;
    if (isAtEnd()) {
      return createToken(END_OF_FILE, beginIndex);
    }
    skipJsxText();
    if (beginIndex === index) {
      switch (currentCharCode) {
        case 60:
          next();
          return createToken(OPEN_ANGLE, beginIndex);
        case 123:
          next();
          return createToken(OPEN_CURLY, beginIndex);
      }
    }
    return new LiteralToken(STRING, getTokenString(beginIndex), getTokenRange(beginIndex));
  }
  function nextToken() {
    var t = peekToken();
    token = lookaheadToken || scanToken();
    lookaheadToken = null;
    lastToken = t;
    return t;
  }
  function peekTokenNoLineTerminator() {
    var t = peekToken();
    var start = lastToken.location.end.offset;
    var end = t.location.start.offset;
    for (var i = start; i < end; i++) {
      if (isLineTerminator(input.charCodeAt(i))) {
        return null;
      }
    }
    return t;
  }
  function peek(expectedType) {
    return peekToken().type === expectedType;
  }
  function peekLookahead(expectedType) {
    return peekTokenLookahead().type === expectedType;
  }
  function peekToken() {
    return token || (token = scanToken());
  }
  function peekType() {
    return peekToken().type;
  }
  function peekLocation() {
    return peekToken().location;
  }
  function peekTokenLookahead() {
    if (!token)
      token = scanToken();
    if (!lookaheadToken)
      lookaheadToken = scanToken();
    return lookaheadToken;
  }
  function skipWhitespace() {
    while (!isAtEnd() && peekWhitespace()) {
      next();
    }
  }
  function peekWhitespace() {
    return isWhitespace(currentCharCode);
  }
  function skipComments() {
    while (skipComment()) {}
  }
  function skipComment() {
    skipWhitespace();
    var code = currentCharCode;
    if (code === 47) {
      code = input.charCodeAt(index + 1);
      switch (code) {
        case 47:
          skipSingleLineComment();
          return true;
        case 42:
          skipMultiLineComment();
          return true;
      }
    }
    return false;
  }
  function commentCallback(start, index) {
    if (options.commentCallback)
      currentParser.handleComment(lineNumberTable.getSourceRange(start, index));
  }
  function skipSingleLineComment() {
    var start = index;
    index += 2;
    while (!isAtEnd() && !isLineTerminator(input.charCodeAt(index++))) {}
    updateCurrentCharCode();
    commentCallback(start, index);
  }
  function skipMultiLineComment() {
    var start = index;
    var i = input.indexOf('*/', index + 2);
    if (i !== -1)
      index = i + 2;
    else
      index = length;
    updateCurrentCharCode();
    commentCallback(start, index);
  }
  function scanToken() {
    skipComments();
    var beginIndex = index;
    if (isAtEnd())
      return createToken(END_OF_FILE, beginIndex);
    var code = currentCharCode;
    next();
    switch (code) {
      case 123:
        return createToken(OPEN_CURLY, beginIndex);
      case 125:
        return createToken(CLOSE_CURLY, beginIndex);
      case 40:
        return createToken(OPEN_PAREN, beginIndex);
      case 41:
        return createToken(CLOSE_PAREN, beginIndex);
      case 91:
        return createToken(OPEN_SQUARE, beginIndex);
      case 93:
        return createToken(CLOSE_SQUARE, beginIndex);
      case 46:
        switch (currentCharCode) {
          case 46:
            if (input.charCodeAt(index + 1) === 46) {
              next();
              next();
              return createToken(DOT_DOT_DOT, beginIndex);
            }
            break;
          default:
            if (isDecimalDigit(currentCharCode))
              return scanNumberPostPeriod(beginIndex);
        }
        return createToken(PERIOD, beginIndex);
      case 59:
        return createToken(SEMI_COLON, beginIndex);
      case 44:
        return createToken(COMMA, beginIndex);
      case 126:
        return createToken(TILDE, beginIndex);
      case 63:
        return createToken(QUESTION, beginIndex);
      case 58:
        return createToken(COLON, beginIndex);
      case 60:
        switch (currentCharCode) {
          case 60:
            next();
            if (currentCharCode === 61) {
              next();
              return createToken(LEFT_SHIFT_EQUAL, beginIndex);
            }
            return createToken(LEFT_SHIFT, beginIndex);
          case 61:
            next();
            return createToken(LESS_EQUAL, beginIndex);
          default:
            return createToken(OPEN_ANGLE, beginIndex);
        }
      case 62:
        switch (currentCharCode) {
          case 62:
            next();
            switch (currentCharCode) {
              case 61:
                next();
                return createToken(RIGHT_SHIFT_EQUAL, beginIndex);
              case 62:
                next();
                if (currentCharCode === 61) {
                  next();
                  return createToken(UNSIGNED_RIGHT_SHIFT_EQUAL, beginIndex);
                }
                return createToken(UNSIGNED_RIGHT_SHIFT, beginIndex);
              default:
                return createToken(RIGHT_SHIFT, beginIndex);
            }
          case 61:
            next();
            return createToken(GREATER_EQUAL, beginIndex);
          default:
            return createToken(CLOSE_ANGLE, beginIndex);
        }
      case 61:
        if (currentCharCode === 61) {
          next();
          if (currentCharCode === 61) {
            next();
            return createToken(EQUAL_EQUAL_EQUAL, beginIndex);
          }
          return createToken(EQUAL_EQUAL, beginIndex);
        }
        if (currentCharCode === 62 && options.arrowFunctions) {
          next();
          return createToken(ARROW, beginIndex);
        }
        return createToken(EQUAL, beginIndex);
      case 33:
        if (currentCharCode === 61) {
          next();
          if (currentCharCode === 61) {
            next();
            return createToken(NOT_EQUAL_EQUAL, beginIndex);
          }
          return createToken(NOT_EQUAL, beginIndex);
        }
        return createToken(BANG, beginIndex);
      case 42:
        if (currentCharCode === 61) {
          next();
          return createToken(STAR_EQUAL, beginIndex);
        }
        if (currentCharCode === 42 && options.exponentiation) {
          next();
          if (currentCharCode === 61) {
            next();
            return createToken(STAR_STAR_EQUAL, beginIndex);
          }
          return createToken(STAR_STAR, beginIndex);
        }
        return createToken(STAR, beginIndex);
      case 37:
        if (currentCharCode === 61) {
          next();
          return createToken(PERCENT_EQUAL, beginIndex);
        }
        return createToken(PERCENT, beginIndex);
      case 94:
        if (currentCharCode === 61) {
          next();
          return createToken(CARET_EQUAL, beginIndex);
        }
        return createToken(CARET, beginIndex);
      case 47:
        if (currentCharCode === 61) {
          next();
          return createToken(SLASH_EQUAL, beginIndex);
        }
        return createToken(SLASH, beginIndex);
      case 43:
        switch (currentCharCode) {
          case 43:
            next();
            return createToken(PLUS_PLUS, beginIndex);
          case 61:
            next();
            return createToken(PLUS_EQUAL, beginIndex);
          default:
            return createToken(PLUS, beginIndex);
        }
      case 45:
        switch (currentCharCode) {
          case 45:
            next();
            return createToken(MINUS_MINUS, beginIndex);
          case 61:
            next();
            return createToken(MINUS_EQUAL, beginIndex);
          default:
            return createToken(MINUS, beginIndex);
        }
      case 38:
        switch (currentCharCode) {
          case 38:
            next();
            return createToken(AND, beginIndex);
          case 61:
            next();
            return createToken(AMPERSAND_EQUAL, beginIndex);
          default:
            return createToken(AMPERSAND, beginIndex);
        }
      case 124:
        switch (currentCharCode) {
          case 124:
            next();
            return createToken(OR, beginIndex);
          case 61:
            next();
            return createToken(BAR_EQUAL, beginIndex);
          default:
            return createToken(BAR, beginIndex);
        }
      case 96:
        return scanTemplateStart(beginIndex);
      case 64:
        return createToken(AT, beginIndex);
      case 48:
        return scanPostZero(beginIndex);
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
        return scanPostDigit(beginIndex);
      case 34:
      case 39:
        return scanStringLiteral(beginIndex, code);
      default:
        return scanIdentifierOrKeyword(beginIndex, code);
    }
  }
  function scanNumberPostPeriod(beginIndex) {
    skipDecimalDigits();
    return scanExponentOfNumericLiteral(beginIndex);
  }
  function scanPostDigit(beginIndex) {
    skipDecimalDigits();
    return scanFractionalNumericLiteral(beginIndex);
  }
  function scanPostZero(beginIndex) {
    switch (currentCharCode) {
      case 46:
        return scanFractionalNumericLiteral(beginIndex);
      case 88:
      case 120:
        next();
        if (!isHexDigit(currentCharCode)) {
          reportError('Hex Integer Literal must contain at least one digit', beginIndex);
        }
        skipHexDigits();
        return new LiteralToken(NUMBER, getTokenString(beginIndex), getTokenRange(beginIndex));
      case 66:
      case 98:
        if (!options.numericLiterals)
          break;
        next();
        if (!isBinaryDigit(currentCharCode)) {
          reportError('Binary Integer Literal must contain at least one digit', beginIndex);
        }
        skipBinaryDigits();
        return new LiteralToken(NUMBER, getTokenString(beginIndex), getTokenRange(beginIndex));
      case 79:
      case 111:
        if (!options.numericLiterals)
          break;
        next();
        if (!isOctalDigit(currentCharCode)) {
          reportError('Octal Integer Literal must contain at least one digit', beginIndex);
        }
        skipOctalDigits();
        return new LiteralToken(NUMBER, getTokenString(beginIndex), getTokenRange(beginIndex));
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
        return scanPostDigit(beginIndex);
    }
    return new LiteralToken(NUMBER, getTokenString(beginIndex), getTokenRange(beginIndex));
  }
  function createToken(type, beginIndex) {
    return new Token(type, getTokenRange(beginIndex));
  }
  function readUnicodeEscapeSequence() {
    var beginIndex = index;
    if (currentCharCode === 117) {
      next();
      if (skipHexDigit() && skipHexDigit() && skipHexDigit() && skipHexDigit()) {
        return parseInt(getTokenString(beginIndex + 1), 16);
      }
    }
    reportError('Invalid unicode escape sequence in identifier', beginIndex - 1);
    return 0;
  }
  function scanIdentifierOrKeyword(beginIndex, code) {
    var escapedCharCodes;
    if (code === 92) {
      code = readUnicodeEscapeSequence();
      escapedCharCodes = [code];
    }
    if (!isIdentifierStart(code)) {
      reportError(("Character code '" + code + "' is not a valid identifier start char"), beginIndex);
      return createToken(ERROR, beginIndex);
    }
    for (; ; ) {
      code = currentCharCode;
      if (isIdentifierPart(code)) {
        next();
      } else if (code === 92) {
        next();
        code = readUnicodeEscapeSequence();
        if (!escapedCharCodes)
          escapedCharCodes = [];
        escapedCharCodes.push(code);
        if (!isIdentifierPart(code))
          return createToken(ERROR, beginIndex);
      } else {
        break;
      }
    }
    var value = input.slice(beginIndex, index);
    var keywordType = getKeywordType(value);
    if (keywordType)
      return new KeywordToken(value, keywordType, getTokenRange(beginIndex));
    if (escapedCharCodes) {
      var i = 0;
      value = value.replace(/\\u..../g, function(s) {
        return String.fromCharCode(escapedCharCodes[i++]);
      });
    }
    return new IdentifierToken(getTokenRange(beginIndex), value);
  }
  function scanStringLiteral(beginIndex, terminator) {
    while (peekStringLiteralChar(terminator)) {
      if (!skipStringLiteralChar()) {
        return new LiteralToken(STRING, getTokenString(beginIndex), getTokenRange(beginIndex));
      }
    }
    if (currentCharCode !== terminator) {
      reportError('Unterminated String Literal', beginIndex);
    } else {
      next();
    }
    return new LiteralToken(STRING, getTokenString(beginIndex), getTokenRange(beginIndex));
  }
  function getTokenString(beginIndex) {
    return input.substring(beginIndex, index);
  }
  function peekStringLiteralChar(terminator) {
    return !isAtEnd() && currentCharCode !== terminator && !isLineTerminator(currentCharCode);
  }
  function skipStringLiteralChar() {
    if (currentCharCode === 92) {
      return skipStringLiteralEscapeSequence();
    }
    next();
    return true;
  }
  function skipStringLiteralEscapeSequence() {
    next();
    if (isAtEnd()) {
      reportError('Unterminated string literal escape sequence');
      return false;
    }
    if (isLineTerminator(currentCharCode)) {
      skipLineTerminator();
      return true;
    }
    var code = currentCharCode;
    next();
    switch (code) {
      case 39:
      case 34:
      case 92:
      case 98:
      case 102:
      case 110:
      case 114:
      case 116:
      case 118:
      case 48:
        return true;
      case 120:
        return skipHexDigit() && skipHexDigit();
      case 117:
        return skipUnicodeEscapeSequence();
      default:
        return true;
    }
  }
  function skipUnicodeEscapeSequence() {
    if (currentCharCode === 123 && options.unicodeEscapeSequences) {
      next();
      var beginIndex = index;
      if (!isHexDigit(currentCharCode)) {
        reportError('Hex digit expected', beginIndex);
        return false;
      }
      skipHexDigits();
      if (currentCharCode !== 125) {
        reportError('Hex digit expected', beginIndex);
        return false;
      }
      var codePoint = getTokenString(beginIndex, index);
      if (parseInt(codePoint, 16) > 0x10FFFF) {
        reportError('The code point in a Unicode escape sequence cannot exceed 10FFFF', beginIndex);
        return false;
      }
      next();
      return true;
    }
    return skipHexDigit() && skipHexDigit() && skipHexDigit() && skipHexDigit();
  }
  function skipHexDigit() {
    if (!isHexDigit(currentCharCode)) {
      reportError('Hex digit expected');
      return false;
    }
    next();
    return true;
  }
  function skipLineTerminator() {
    var first = currentCharCode;
    next();
    if (first === 13 && currentCharCode === 10) {
      next();
    }
  }
  function scanFractionalNumericLiteral(beginIndex) {
    if (currentCharCode === 46) {
      next();
      skipDecimalDigits();
    }
    return scanExponentOfNumericLiteral(beginIndex);
  }
  function scanExponentOfNumericLiteral(beginIndex) {
    switch (currentCharCode) {
      case 101:
      case 69:
        next();
        switch (currentCharCode) {
          case 43:
          case 45:
            next();
            break;
        }
        if (!isDecimalDigit(currentCharCode)) {
          reportError('Exponent part must contain at least one digit', beginIndex);
        }
        skipDecimalDigits();
        break;
      default:
        break;
    }
    return new LiteralToken(NUMBER, getTokenString(beginIndex), getTokenRange(beginIndex));
  }
  function skipDecimalDigits() {
    while (isDecimalDigit(currentCharCode)) {
      next();
    }
  }
  function skipHexDigits() {
    while (isHexDigit(currentCharCode)) {
      next();
    }
  }
  function skipBinaryDigits() {
    while (isBinaryDigit(currentCharCode)) {
      next();
    }
  }
  function skipOctalDigits() {
    while (isOctalDigit(currentCharCode)) {
      next();
    }
  }
  function isAtEnd() {
    return index === length;
  }
  function next() {
    index++;
    updateCurrentCharCode();
  }
  function updateCurrentCharCode() {
    currentCharCode = input.charCodeAt(index);
  }
  function reportError(message) {
    var startIndex = arguments[1] !== (void 0) ? arguments[1] : index;
    var endIndex = arguments[2] !== (void 0) ? arguments[2] : index;
    var start = getPositionByOffset(startIndex);
    var end = getPositionByOffset(endIndex);
    var location = new SourceRange(start, end);
    errorReporter.reportError(location, message);
  }
  return {
    get isWhitespace() {
      return isWhitespace;
    },
    get isLineTerminator() {
      return isLineTerminator;
    },
    get isIdentifierPart() {
      return isIdentifierPart;
    },
    get init() {
      return init;
    },
    get getLastToken() {
      return getLastToken;
    },
    get nextRegularExpressionLiteralToken() {
      return nextRegularExpressionLiteralToken;
    },
    get nextTemplateLiteralToken() {
      return nextTemplateLiteralToken;
    },
    get setIndex() {
      return setIndex;
    },
    get getPosition() {
      return getPosition;
    },
    get nextCloseAngle() {
      return nextCloseAngle;
    },
    get peekJsxToken() {
      return peekJsxToken;
    },
    get nextJsxToken() {
      return nextJsxToken;
    },
    get nextJsxTextToken() {
      return nextJsxTextToken;
    },
    get nextToken() {
      return nextToken;
    },
    get peekTokenNoLineTerminator() {
      return peekTokenNoLineTerminator;
    },
    get peek() {
      return peek;
    },
    get peekLookahead() {
      return peekLookahead;
    },
    get peekToken() {
      return peekToken;
    },
    get peekType() {
      return peekType;
    },
    get peekLocation() {
      return peekLocation;
    },
    get peekTokenLookahead() {
      return peekTokenLookahead;
    },
    get isAtEnd() {
      return isAtEnd;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/semantics/ConstructorValidator.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/semantics/ConstructorValidator.js";
  var SUPER_EXPRESSION = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/semantics/ConstructorValidator.js")).SUPER_EXPRESSION;
  var FindVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../codegeneration/FindVisitor.js", "traceur@0.0.108/src/semantics/ConstructorValidator.js")).FindVisitor;
  var ConstructorValidator = function($__super) {
    function ConstructorValidator(reporter) {
      $traceurRuntime.superConstructor(ConstructorValidator).call(this);
      this.reporter_ = reporter;
      this.hasError = false;
    }
    return ($traceurRuntime.createClass)(ConstructorValidator, {
      visitClassExpression: function(tree) {
        this.visitAny(tree.superClass);
      },
      visitClassDeclaration: function(tree) {
        this.visitAny(tree.superClass);
      },
      visitThisExpression: function(tree) {
        this.reportError_(tree.location, 'this');
      },
      visitCallExpression: function(tree) {
        if (tree.operand.type === SUPER_EXPRESSION) {
          this.visitAny(tree.args);
          this.found = true;
          return;
        }
        $traceurRuntime.superGet(this, ConstructorValidator.prototype, "visitCallExpression").call(this, tree);
      },
      visitSuperExpression: function(tree) {
        this.reportError_(tree.location, 'super property');
      },
      reportError_: function(location, kind) {
        this.reporter_.reportError(location, ("'" + kind + "' is not allowed before super()"));
        this.hasError = true;
        this.found = true;
      }
    }, {}, $__super);
  }(FindVisitor);
  function validateConstructor(tree, reporter) {
    var visitor = new ConstructorValidator(reporter);
    visitor.visitAny(tree);
    if (visitor.hasError)
      return false;
    if (visitor.found)
      return true;
    reporter.reportError(tree.location, 'Derived constructor must call super()');
    return false;
  }
  return {get validateConstructor() {
      return validateConstructor;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/staticsemantics/validateParameters.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/staticsemantics/validateParameters.js";
  var ParseTreeVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/ParseTreeVisitor.js", "traceur@0.0.108/src/staticsemantics/validateParameters.js")).ParseTreeVisitor;
  var StringSet = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/StringSet.js", "traceur@0.0.108/src/staticsemantics/validateParameters.js")).StringSet;
  var isStrictKeyword = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/Keywords.js", "traceur@0.0.108/src/staticsemantics/validateParameters.js")).isStrictKeyword;
  var ParameterValidationVisitor = function($__super) {
    function ParameterValidationVisitor(isStrict, reporter) {
      $traceurRuntime.superConstructor(ParameterValidationVisitor).call(this);
      this.reporter_ = reporter;
      this.names_ = new StringSet();
      this.errors_ = [];
      this.reportStrictKeywords_ = isStrict;
      this.reportDuplicates_ = isStrict;
    }
    return ($traceurRuntime.createClass)(ParameterValidationVisitor, {
      visitBindingIdentifier: function(tree) {
        var name = tree.identifierToken.toString();
        if (this.reportStrictKeywords_ && (isStrictKeyword(name) || name === 'eval' || name === 'arguments')) {
          this.reporter_.reportError(tree.location, (name + " is a reserved identifier"));
        }
        if (this.names_.has(name)) {
          this.maybeReportDuplicateError_(name, tree.location);
        }
        this.names_.add(name);
      },
      visitBindingElement: function(tree) {
        if (tree.initializer !== null) {
          this.reportEarlierErrors_();
        }
        this.visitAny(tree.binding);
      },
      visitRestParameter: function(tree) {
        this.reportEarlierErrors_();
        this.visitAny(tree.identifier);
      },
      visitFormalParameter: function(tree) {
        this.visitAny(tree.parameter);
      },
      visitArrayPattern: function(tree) {
        this.reportEarlierErrors_();
        $traceurRuntime.superGet(this, ParameterValidationVisitor.prototype, "visitArrayPattern").call(this, tree);
      },
      visitObjectPattern: function(tree) {
        this.reportEarlierErrors_();
        $traceurRuntime.superGet(this, ParameterValidationVisitor.prototype, "visitObjectPattern").call(this, tree);
      },
      reportDuplicateError_: function(name, location) {
        this.reporter_.reportError(location, ("Duplicate parameter name " + name));
      },
      maybeReportDuplicateError_: function(name, location) {
        if (this.reportDuplicates_) {
          this.reportDuplicateError_(name, location);
        } else {
          this.errors_.push(name, location);
        }
      },
      reportEarlierErrors_: function() {
        if (!this.reportDuplicates_) {
          this.reportDuplicates_ = true;
          for (var i = 0; i < this.errors_.length; i += 2) {
            var name = this.errors_[i];
            var location = this.errors_[i + 1];
            this.reportDuplicateError_(name, location);
          }
        }
      }
    }, {}, $__super);
  }(ParseTreeVisitor);
  var $__default = function(tree, isStrict, reporter) {
    new ParameterValidationVisitor(isStrict, reporter).visitAny(tree);
  };
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/staticsemantics/isValidSimpleAssignmentTarget.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/staticsemantics/isValidSimpleAssignmentTarget.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/staticsemantics/isValidSimpleAssignmentTarget.js")),
      IDENTIFIER_EXPRESSION = $__1.IDENTIFIER_EXPRESSION,
      MEMBER_EXPRESSION = $__1.MEMBER_EXPRESSION,
      MEMBER_LOOKUP_EXPRESSION = $__1.MEMBER_LOOKUP_EXPRESSION,
      PAREN_EXPRESSION = $__1.PAREN_EXPRESSION;
  function isValidSimpleAssignmentTarget(tree, isStrict) {
    switch (tree.type) {
      case IDENTIFIER_EXPRESSION:
        {
          if (!isStrict)
            return true;
          var value = tree.identifierToken.value;
          return value !== 'arguments' && value !== 'eval';
        }
      case PAREN_EXPRESSION:
        return isValidSimpleAssignmentTarget(tree.expression, isStrict);
      case MEMBER_EXPRESSION:
      case MEMBER_LOOKUP_EXPRESSION:
        return true;
      default:
        return false;
    }
  }
  var $__default = isValidSimpleAssignmentTarget;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/Parser.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/Parser.js";
  var FindVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../codegeneration/FindVisitor.js", "traceur@0.0.108/src/syntax/Parser.js")).FindVisitor;
  var IdentifierToken = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./IdentifierToken.js", "traceur@0.0.108/src/syntax/Parser.js")).IdentifierToken;
  var $__25 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./trees/ParseTreeType.js", "traceur@0.0.108/src/syntax/Parser.js")),
      ARRAY_LITERAL = $__25.ARRAY_LITERAL,
      BINDING_IDENTIFIER = $__25.BINDING_IDENTIFIER,
      CALL_EXPRESSION = $__25.CALL_EXPRESSION,
      COMPUTED_PROPERTY_NAME = $__25.COMPUTED_PROPERTY_NAME,
      COVER_FORMALS = $__25.COVER_FORMALS,
      FORMAL_PARAMETER_LIST = $__25.FORMAL_PARAMETER_LIST,
      IDENTIFIER_EXPRESSION = $__25.IDENTIFIER_EXPRESSION,
      LITERAL_PROPERTY_NAME = $__25.LITERAL_PROPERTY_NAME,
      OBJECT_LITERAL = $__25.OBJECT_LITERAL,
      REST_PARAMETER = $__25.REST_PARAMETER,
      SYNTAX_ERROR_TREE = $__25.SYNTAX_ERROR_TREE;
  var Options = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../Options.js", "traceur@0.0.108/src/syntax/Parser.js")).Options;
  var $__27 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PredefinedName.js", "traceur@0.0.108/src/syntax/Parser.js")),
      AS = $__27.AS,
      ASYNC = $__27.ASYNC,
      ASYNC_STAR = $__27.ASYNC_STAR,
      AWAIT = $__27.AWAIT,
      CONSTRUCTOR = $__27.CONSTRUCTOR,
      FROM = $__27.FROM,
      GET = $__27.GET,
      OF = $__27.OF,
      ON = $__27.ON,
      SET = $__27.SET,
      TYPE = $__27.TYPE;
  var SyntaxErrorReporter = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/SyntaxErrorReporter.js", "traceur@0.0.108/src/syntax/Parser.js")).SyntaxErrorReporter;
  var $__29 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Scanner.js", "traceur@0.0.108/src/syntax/Parser.js")),
      getLastToken = $__29.getLastToken,
      getPosition = $__29.getPosition,
      initScanner = $__29.init,
      isAtEnd = $__29.isAtEnd,
      nextCloseAngle = $__29.nextCloseAngle,
      nextJsxTextToken = $__29.nextJsxTextToken,
      nextJsxToken = $__29.nextJsxToken,
      nextRegularExpressionLiteralToken = $__29.nextRegularExpressionLiteralToken,
      nextTemplateLiteralToken = $__29.nextTemplateLiteralToken,
      nextToken = $__29.nextToken,
      peek = $__29.peek,
      peekJsxToken = $__29.peekJsxToken,
      peekLocation = $__29.peekLocation,
      peekLookahead = $__29.peekLookahead,
      peekToken = $__29.peekToken,
      peekTokenLookahead = $__29.peekTokenLookahead,
      peekTokenNoLineTerminator = $__29.peekTokenNoLineTerminator,
      peekType = $__29.peekType,
      resetScanner = $__29.setIndex;
  var SourceRange = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/SourceRange.js", "traceur@0.0.108/src/syntax/Parser.js")).SourceRange;
  var $__31 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Token.js", "traceur@0.0.108/src/syntax/Parser.js")),
      Token = $__31.Token,
      isAssignmentOperator = $__31.isAssignmentOperator;
  var getKeywordType = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Keywords.js", "traceur@0.0.108/src/syntax/Parser.js")).getKeywordType;
  var validateConstructor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../semantics/ConstructorValidator.js", "traceur@0.0.108/src/syntax/Parser.js")).validateConstructor;
  var validateParameters = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../staticsemantics/validateParameters.js", "traceur@0.0.108/src/syntax/Parser.js")).default;
  var isValidSimpleAssignmentTarget = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../staticsemantics/isValidSimpleAssignmentTarget.js", "traceur@0.0.108/src/syntax/Parser.js")).default;
  var $__36 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TokenType.js", "traceur@0.0.108/src/syntax/Parser.js")),
      AMPERSAND = $__36.AMPERSAND,
      AND = $__36.AND,
      ARROW = $__36.ARROW,
      AT = $__36.AT,
      BANG = $__36.BANG,
      BAR = $__36.BAR,
      BREAK = $__36.BREAK,
      CARET = $__36.CARET,
      CASE = $__36.CASE,
      CATCH = $__36.CATCH,
      CLASS = $__36.CLASS,
      CLOSE_ANGLE = $__36.CLOSE_ANGLE,
      CLOSE_CURLY = $__36.CLOSE_CURLY,
      CLOSE_PAREN = $__36.CLOSE_PAREN,
      CLOSE_SQUARE = $__36.CLOSE_SQUARE,
      COLON = $__36.COLON,
      COMMA = $__36.COMMA,
      CONST = $__36.CONST,
      CONTINUE = $__36.CONTINUE,
      DEBUGGER = $__36.DEBUGGER,
      DEFAULT = $__36.DEFAULT,
      DELETE = $__36.DELETE,
      DO = $__36.DO,
      DOT_DOT_DOT = $__36.DOT_DOT_DOT,
      ELSE = $__36.ELSE,
      END_OF_FILE = $__36.END_OF_FILE,
      EQUAL = $__36.EQUAL,
      EQUAL_EQUAL = $__36.EQUAL_EQUAL,
      EQUAL_EQUAL_EQUAL = $__36.EQUAL_EQUAL_EQUAL,
      ERROR = $__36.ERROR,
      EXPORT = $__36.EXPORT,
      EXTENDS = $__36.EXTENDS,
      FALSE = $__36.FALSE,
      FINALLY = $__36.FINALLY,
      FOR = $__36.FOR,
      FUNCTION = $__36.FUNCTION,
      GREATER_EQUAL = $__36.GREATER_EQUAL,
      IDENTIFIER = $__36.IDENTIFIER,
      IF = $__36.IF,
      IMPLEMENTS = $__36.IMPLEMENTS,
      IMPORT = $__36.IMPORT,
      IN = $__36.IN,
      INSTANCEOF = $__36.INSTANCEOF,
      INTERFACE = $__36.INTERFACE,
      JSX_IDENTIFIER = $__36.JSX_IDENTIFIER,
      LEFT_SHIFT = $__36.LEFT_SHIFT,
      LESS_EQUAL = $__36.LESS_EQUAL,
      LET = $__36.LET,
      MINUS = $__36.MINUS,
      MINUS_MINUS = $__36.MINUS_MINUS,
      NEW = $__36.NEW,
      NO_SUBSTITUTION_TEMPLATE = $__36.NO_SUBSTITUTION_TEMPLATE,
      NOT_EQUAL = $__36.NOT_EQUAL,
      NOT_EQUAL_EQUAL = $__36.NOT_EQUAL_EQUAL,
      NULL = $__36.NULL,
      NUMBER = $__36.NUMBER,
      OPEN_ANGLE = $__36.OPEN_ANGLE,
      OPEN_CURLY = $__36.OPEN_CURLY,
      OPEN_PAREN = $__36.OPEN_PAREN,
      OPEN_SQUARE = $__36.OPEN_SQUARE,
      OR = $__36.OR,
      PACKAGE = $__36.PACKAGE,
      PERCENT = $__36.PERCENT,
      PERIOD = $__36.PERIOD,
      PLUS = $__36.PLUS,
      PLUS_PLUS = $__36.PLUS_PLUS,
      PRIVATE = $__36.PRIVATE,
      PROTECTED = $__36.PROTECTED,
      PUBLIC = $__36.PUBLIC,
      QUESTION = $__36.QUESTION,
      RETURN = $__36.RETURN,
      RIGHT_SHIFT = $__36.RIGHT_SHIFT,
      SEMI_COLON = $__36.SEMI_COLON,
      SLASH = $__36.SLASH,
      SLASH_EQUAL = $__36.SLASH_EQUAL,
      STAR = $__36.STAR,
      STAR_STAR = $__36.STAR_STAR,
      STATIC = $__36.STATIC,
      STRING = $__36.STRING,
      SUPER = $__36.SUPER,
      SWITCH = $__36.SWITCH,
      TEMPLATE_HEAD = $__36.TEMPLATE_HEAD,
      TEMPLATE_TAIL = $__36.TEMPLATE_TAIL,
      THIS = $__36.THIS,
      THROW = $__36.THROW,
      TILDE = $__36.TILDE,
      TRUE = $__36.TRUE,
      TRY = $__36.TRY,
      TYPEOF = $__36.TYPEOF,
      UNSIGNED_RIGHT_SHIFT = $__36.UNSIGNED_RIGHT_SHIFT,
      VAR = $__36.VAR,
      VOID = $__36.VOID,
      WHILE = $__36.WHILE,
      WITH = $__36.WITH,
      YIELD = $__36.YIELD;
  var $__37 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./trees/ParseTrees.js", "traceur@0.0.108/src/syntax/Parser.js")),
      ArgumentList = $__37.ArgumentList,
      ArrayComprehension = $__37.ArrayComprehension,
      ArrayLiteral = $__37.ArrayLiteral,
      ArrayPattern = $__37.ArrayPattern,
      ArrayType = $__37.ArrayType,
      ArrowFunction = $__37.ArrowFunction,
      AssignmentElement = $__37.AssignmentElement,
      AwaitExpression = $__37.AwaitExpression,
      BinaryExpression = $__37.BinaryExpression,
      BindingElement = $__37.BindingElement,
      BindingIdentifier = $__37.BindingIdentifier,
      Block = $__37.Block,
      BreakStatement = $__37.BreakStatement,
      CallExpression = $__37.CallExpression,
      CallSignature = $__37.CallSignature,
      CaseClause = $__37.CaseClause,
      Catch = $__37.Catch,
      ClassDeclaration = $__37.ClassDeclaration,
      ClassExpression = $__37.ClassExpression,
      CommaExpression = $__37.CommaExpression,
      ComprehensionFor = $__37.ComprehensionFor,
      ComprehensionIf = $__37.ComprehensionIf,
      ComputedPropertyName = $__37.ComputedPropertyName,
      ConditionalExpression = $__37.ConditionalExpression,
      ConstructSignature = $__37.ConstructSignature,
      ConstructorType = $__37.ConstructorType,
      ContinueStatement = $__37.ContinueStatement,
      CoverFormals = $__37.CoverFormals,
      CoverInitializedName = $__37.CoverInitializedName,
      DebuggerStatement = $__37.DebuggerStatement,
      Annotation = $__37.Annotation,
      DefaultClause = $__37.DefaultClause,
      DoWhileStatement = $__37.DoWhileStatement,
      EmptyStatement = $__37.EmptyStatement,
      ExportDeclaration = $__37.ExportDeclaration,
      ExportDefault = $__37.ExportDefault,
      ExportSpecifier = $__37.ExportSpecifier,
      ExportSpecifierSet = $__37.ExportSpecifierSet,
      ExportStar = $__37.ExportStar,
      ExpressionStatement = $__37.ExpressionStatement,
      Finally = $__37.Finally,
      ForInStatement = $__37.ForInStatement,
      ForOfStatement = $__37.ForOfStatement,
      ForOnStatement = $__37.ForOnStatement,
      ForStatement = $__37.ForStatement,
      FormalParameter = $__37.FormalParameter,
      FormalParameterList = $__37.FormalParameterList,
      ForwardDefaultExport = $__37.ForwardDefaultExport,
      FunctionBody = $__37.FunctionBody,
      FunctionDeclaration = $__37.FunctionDeclaration,
      FunctionExpression = $__37.FunctionExpression,
      FunctionType = $__37.FunctionType,
      GeneratorComprehension = $__37.GeneratorComprehension,
      GetAccessor = $__37.GetAccessor,
      IdentifierExpression = $__37.IdentifierExpression,
      IfStatement = $__37.IfStatement,
      ImportClausePair = $__37.ImportClausePair,
      ImportDeclaration = $__37.ImportDeclaration,
      ImportSpecifier = $__37.ImportSpecifier,
      ImportSpecifierSet = $__37.ImportSpecifierSet,
      ImportedBinding = $__37.ImportedBinding,
      ImportTypeClause = $__37.ImportTypeClause,
      IndexSignature = $__37.IndexSignature,
      InterfaceDeclaration = $__37.InterfaceDeclaration,
      JsxAttribute = $__37.JsxAttribute,
      JsxElement = $__37.JsxElement,
      JsxElementName = $__37.JsxElementName,
      JsxPlaceholder = $__37.JsxPlaceholder,
      JsxSpreadAttribute = $__37.JsxSpreadAttribute,
      JsxText = $__37.JsxText,
      LabelledStatement = $__37.LabelledStatement,
      LiteralExpression = $__37.LiteralExpression,
      LiteralPropertyName = $__37.LiteralPropertyName,
      MemberExpression = $__37.MemberExpression,
      MemberLookupExpression = $__37.MemberLookupExpression,
      Method = $__37.Method,
      MethodSignature = $__37.MethodSignature,
      Module = $__37.Module,
      ModuleSpecifier = $__37.ModuleSpecifier,
      NameSpaceExport = $__37.NameSpaceExport,
      NameSpaceImport = $__37.NameSpaceImport,
      NamedExport = $__37.NamedExport,
      NewExpression = $__37.NewExpression,
      ObjectLiteral = $__37.ObjectLiteral,
      ObjectPattern = $__37.ObjectPattern,
      ObjectPatternField = $__37.ObjectPatternField,
      ObjectType = $__37.ObjectType,
      ParenExpression = $__37.ParenExpression,
      PostfixExpression = $__37.PostfixExpression,
      PredefinedType = $__37.PredefinedType,
      PropertyNameAssignment = $__37.PropertyNameAssignment,
      PropertyNameShorthand = $__37.PropertyNameShorthand,
      PropertySignature = $__37.PropertySignature,
      PropertyVariableDeclaration = $__37.PropertyVariableDeclaration,
      RestParameter = $__37.RestParameter,
      ReturnStatement = $__37.ReturnStatement,
      Script = $__37.Script,
      SetAccessor = $__37.SetAccessor,
      SpreadExpression = $__37.SpreadExpression,
      SpreadPatternElement = $__37.SpreadPatternElement,
      SuperExpression = $__37.SuperExpression,
      SwitchStatement = $__37.SwitchStatement,
      SyntaxErrorTree = $__37.SyntaxErrorTree,
      TemplateLiteralExpression = $__37.TemplateLiteralExpression,
      TemplateLiteralPortion = $__37.TemplateLiteralPortion,
      TemplateSubstitution = $__37.TemplateSubstitution,
      ThisExpression = $__37.ThisExpression,
      ThrowStatement = $__37.ThrowStatement,
      TryStatement = $__37.TryStatement,
      TypeAliasDeclaration = $__37.TypeAliasDeclaration,
      TypeArguments = $__37.TypeArguments,
      TypeName = $__37.TypeName,
      TypeParameter = $__37.TypeParameter,
      TypeParameters = $__37.TypeParameters,
      TypeReference = $__37.TypeReference,
      UnaryExpression = $__37.UnaryExpression,
      UnionType = $__37.UnionType,
      VariableDeclaration = $__37.VariableDeclaration,
      VariableDeclarationList = $__37.VariableDeclarationList,
      VariableStatement = $__37.VariableStatement,
      WhileStatement = $__37.WhileStatement,
      WithStatement = $__37.WithStatement,
      YieldExpression = $__37.YieldExpression;
  var ALLOW_IN = true;
  var NO_IN = false;
  var INITIALIZER_REQUIRED = true;
  var INITIALIZER_OPTIONAL = false;
  var ValidateObjectLiteral = function($__super) {
    function ValidateObjectLiteral() {
      $traceurRuntime.superConstructor(ValidateObjectLiteral).call(this);
      this.errorToken = null;
    }
    return ($traceurRuntime.createClass)(ValidateObjectLiteral, {visitCoverInitializedName: function(tree) {
        this.errorToken = tree.equalToken;
        this.found = true;
      }}, {}, $__super);
  }(FindVisitor);
  function containsInitializer(declarations) {
    return declarations.some(function(v) {
      return v.initializer;
    });
  }
  var FUNCTION_STATE_SCRIPT = 1;
  var FUNCTION_STATE_MODULE = 1 << 1;
  var FUNCTION_STATE_FUNCTION = 1 << 2;
  var FUNCTION_STATE_ARROW = 1 << 3;
  var FUNCTION_STATE_METHOD = 1 << 4;
  var FUNCTION_STATE_DERIVED_CONSTRUCTOR = 1 << 5;
  var FUNCTION_STATE_GENERATOR = 1 << 6;
  var FUNCTION_STATE_ASYNC = 1 << 7;
  var FUNCTION_STATE_LENIENT = FUNCTION_STATE_METHOD | FUNCTION_STATE_GENERATOR | FUNCTION_STATE_ASYNC | FUNCTION_STATE_DERIVED_CONSTRUCTOR;
  var FunctionState = function() {
    function FunctionState(outer, kind) {
      this.outer = outer;
      this.kind = kind;
    }
    return ($traceurRuntime.createClass)(FunctionState, {
      isTopMost: function() {
        return this.kind & (FUNCTION_STATE_SCRIPT | FUNCTION_STATE_MODULE);
      },
      isMethod: function() {
        return this.kind & FUNCTION_STATE_METHOD;
      },
      isDerivedConstructor: function() {
        return this.kind & FUNCTION_STATE_DERIVED_CONSTRUCTOR;
      },
      isArrowFunction: function() {
        return this.kind & FUNCTION_STATE_ARROW;
      },
      isGenerator: function() {
        return this.kind & FUNCTION_STATE_GENERATOR;
      },
      isAsyncFunction: function() {
        return this.kind & FUNCTION_STATE_ASYNC;
      },
      isAsyncGenerator: function() {
        return this.isGenerator() && this.isAsyncFunction();
      }
    }, {});
  }();
  var Parser = function() {
    function Parser(file) {
      var errorReporter = arguments[1] !== (void 0) ? arguments[1] : new SyntaxErrorReporter();
      var options = arguments[2] !== (void 0) ? arguments[2] : new Options();
      this.errorReporter_ = errorReporter;
      initScanner(errorReporter, file, this, options);
      this.options_ = options;
      this.coverInitializedNameCount_ = 0;
      this.strictMode_ = false;
      this.annotations_ = [];
      this.functionState_ = null;
    }
    return ($traceurRuntime.createClass)(Parser, {
      get allowYield_() {
        return this.functionState_.isGenerator();
      },
      get allowAwait_() {
        return this.functionState_.isAsyncFunction();
      },
      get allowForOn_() {
        return this.functionState_.isAsyncFunction();
      },
      parseScript: function() {
        this.strictMode_ = false;
        var start = this.getTreeStartLocation_();
        var fs = this.pushFunctionState_(FUNCTION_STATE_SCRIPT);
        var scriptItemList = this.parseStatementList_(true);
        this.eat_(END_OF_FILE);
        this.popFunctionState_(fs);
        return new Script(this.getTreeLocation_(start), scriptItemList, null);
      },
      pushFunctionState_: function(kind) {
        return this.functionState_ = new FunctionState(this.functionState_, kind);
      },
      popFunctionState_: function(fs) {
        if (fs != this.functionState_) {
          throw new Error('Internal error');
        }
        this.functionState_ = this.functionState_.outer;
      },
      parseStatementList_: function(checkUseStrictDirective) {
        var result = [];
        var type;
        while ((type = peekType()) !== CLOSE_CURLY && type !== END_OF_FILE) {
          var statement = this.parseStatementListItem_(type);
          if (checkUseStrictDirective) {
            if (!statement.isDirectivePrologue()) {
              checkUseStrictDirective = false;
            } else if (statement.isUseStrictDirective()) {
              this.strictMode_ = true;
              checkUseStrictDirective = false;
            }
          }
          result.push(statement);
        }
        return result;
      },
      parseStatementListItem_: function(type) {
        switch (type) {
          case LET:
          case CONST:
            if (this.options_.blockBinding) {
              return this.parseVariableStatement_();
            }
            break;
          case CLASS:
            if (this.options_.classes) {
              return this.parseClassDeclaration_();
            }
            break;
          case FUNCTION:
            return this.parseFunctionDeclaration_();
          case IDENTIFIER:
            if (this.options_.types && this.peekPredefinedString_(TYPE) && peekLookahead(IDENTIFIER)) {
              return this.parseTypeAliasDeclaration_();
            }
            break;
        }
        return this.parseStatementWithType_(type);
      },
      parseModule: function() {
        var start = this.getTreeStartLocation_();
        var fs = this.pushFunctionState_(FUNCTION_STATE_MODULE);
        var scriptItemList = this.parseModuleItemList_();
        this.eat_(END_OF_FILE);
        this.popFunctionState_(fs);
        return new Module(this.getTreeLocation_(start), scriptItemList, null);
      },
      parseModuleItemList_: function() {
        this.strictMode_ = true;
        var result = [];
        var type;
        while ((type = peekType()) !== END_OF_FILE) {
          var statement = this.parseModuleItem_(type);
          result.push(statement);
        }
        return result;
      },
      parseModuleItem_: function(type) {
        switch (type) {
          case IMPORT:
            return this.parseImportDeclaration_();
          case EXPORT:
            return this.parseExportDeclaration_();
          case AT:
            if (this.options_.annotations)
              return this.parseAnnotatedDeclarations_(true);
            break;
        }
        return this.parseStatementListItem_(type);
      },
      parseModuleSpecifier_: function() {
        var start = this.getTreeStartLocation_();
        var token = this.eat_(STRING);
        return new ModuleSpecifier(this.getTreeLocation_(start), token);
      },
      parseNameSpaceImport_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(STAR);
        this.eatId_(AS);
        var binding = this.parseImportedBinding_();
        return new NameSpaceImport(this.getTreeLocation_(start), binding);
      },
      parseImportDeclaration_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(IMPORT);
        var importClause = null;
        if (!peek(STRING)) {
          importClause = this.parseImportClause_(true, this.options_.types);
          this.eatId_(FROM);
        }
        var moduleSpecifier = this.parseModuleSpecifier_();
        this.eatPossibleImplicitSemiColon_();
        return new ImportDeclaration(this.getTreeLocation_(start), importClause, moduleSpecifier);
      },
      parseImportClause_: function(allowImportedDefaultBinding, allowType) {
        switch (peekType()) {
          case STAR:
            return this.parseNameSpaceImport_();
          case OPEN_CURLY:
            return this.parseImportSpecifierSet_();
          case IDENTIFIER:
            if (allowType && this.peekPredefinedString_(TYPE)) {
              var start = this.getTreeStartLocation_();
              var t = peekTokenLookahead();
              if (t.type === OPEN_CURLY || t.type === IDENTIFIER && t.value !== FROM) {
                this.eatId_(TYPE);
                var clause = this.parseImportClause_(allowImportedDefaultBinding, false);
                return new ImportTypeClause(this.getTreeLocation_(start), clause);
              }
            }
            if (allowImportedDefaultBinding) {
              var start$__4 = this.getTreeStartLocation_();
              var importedBinding = this.parseImportedBinding_();
              if (this.eatIf_(COMMA)) {
                var second = this.parseImportClause_(false, false);
                return new ImportClausePair(this.getTreeLocation_(start$__4), importedBinding, second);
              }
              return importedBinding;
            }
            break;
        }
        return this.parseUnexpectedToken_();
      },
      parseImportSpecifierSet_: function() {
        var start = this.getTreeStartLocation_();
        var specifiers = [];
        this.eat_(OPEN_CURLY);
        while (!peek(CLOSE_CURLY) && !isAtEnd()) {
          specifiers.push(this.parseImportSpecifier_());
          if (!this.eatIf_(COMMA))
            break;
        }
        this.eat_(CLOSE_CURLY);
        return new ImportSpecifierSet(this.getTreeLocation_(start), specifiers);
      },
      parseImportedBinding_: function() {
        var start = this.getTreeStartLocation_();
        var binding = this.parseBindingIdentifier_();
        return new ImportedBinding(this.getTreeLocation_(start), binding);
      },
      parseImportSpecifier_: function() {
        var start = this.getTreeStartLocation_();
        var token = peekToken();
        var isKeyword = token.isKeyword();
        var binding;
        var name = this.eatIdName_();
        if (isKeyword || this.peekPredefinedString_(AS)) {
          this.eatId_(AS);
          binding = this.parseImportedBinding_();
        } else {
          binding = new ImportedBinding(name.location, new BindingIdentifier(name.location, name));
          name = null;
        }
        return new ImportSpecifier(this.getTreeLocation_(start), binding, name);
      },
      parseExportDeclaration_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(EXPORT);
        var exportTree;
        var annotations = this.popAnnotations_();
        var type = peekType();
        switch (type) {
          case CONST:
          case LET:
            if (this.options_.blockBinding) {
              exportTree = this.parseVariableStatement_();
              break;
            }
            return this.parseUnexpectedToken_();
          case VAR:
            exportTree = this.parseVariableStatement_();
            break;
          case FUNCTION:
            exportTree = this.parseFunctionDeclaration_();
            break;
          case CLASS:
            exportTree = this.parseClassDeclaration_();
            break;
          case DEFAULT:
            exportTree = this.parseExportDefault_();
            break;
          case OPEN_CURLY:
          case STAR:
            exportTree = this.parseNamedExport_();
            break;
          case IDENTIFIER:
            if (this.options_.asyncFunctions && this.peekPredefinedString_(ASYNC)) {
              var asyncToken = this.eatId_();
              exportTree = this.parseAsyncFunctionDeclaration_(asyncToken);
            } else if (this.options_.types && this.peekPredefinedString_(TYPE) && peekLookahead(IDENTIFIER)) {
              exportTree = this.parseTypeAliasDeclaration_();
            } else if (this.options_.exportFromExtended) {
              exportTree = this.parseNamedExport_();
            } else {
              return this.parseUnexpectedToken_();
            }
            break;
          default:
            {
              var token = peekToken();
              if (!token.isKeyword()) {
                return this.parseUnexpectedToken_();
              }
              exportTree = this.parseNamedExport_();
            }
        }
        return new ExportDeclaration(this.getTreeLocation_(start), exportTree, annotations);
      },
      parseExportDefault_: function() {
        var start = this.getTreeStartLocation_();
        var defaultToken = this.eat_(DEFAULT);
        if (this.options_.exportFromExtended && this.peekPredefinedString_(FROM)) {
          var idName = new IdentifierToken(defaultToken.location, DEFAULT);
          var namedExport = new ForwardDefaultExport(this.getTreeLocation_(start), idName);
          this.eatId_(FROM);
          var moduleSpecifier = this.parseModuleSpecifier_();
          return new NamedExport(this.getTreeLocation_(start), namedExport, moduleSpecifier);
        }
        var exportValue;
        switch (peekType()) {
          case FUNCTION:
            {
              var tree = this.parseFunctionExpression_();
              if (tree.name) {
                tree = new FunctionDeclaration(tree.location, tree.name, tree.functionKind, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body);
              }
              exportValue = tree;
              break;
            }
          case CLASS:
            {
              if (!this.options_.classes) {
                return this.parseSyntaxError_('Unexpected reserved word');
              }
              var tree$__5 = this.parseClassExpression_();
              if (tree$__5.name) {
                tree$__5 = new ClassDeclaration(tree$__5.location, tree$__5.name, tree$__5.superClass, tree$__5.elements, tree$__5.annotations, tree$__5.typeParameters);
              }
              exportValue = tree$__5;
              break;
            }
          default:
            exportValue = this.parseAssignmentExpression_(ALLOW_IN);
            this.eatPossibleImplicitSemiColon_();
        }
        return new ExportDefault(this.getTreeLocation_(start), exportValue);
      },
      parseNamedExport_: function() {
        var start = this.getTreeStartLocation_();
        var exportClause,
            moduleSpecifier = null;
        switch (peekType()) {
          case OPEN_CURLY:
            exportClause = this.parseExportSpecifierSet_();
            if (this.peekPredefinedString_(FROM)) {
              this.eatId_(FROM);
              moduleSpecifier = this.parseModuleSpecifier_();
            } else {
              this.validateExportSpecifierSet_(exportClause);
            }
            break;
          case STAR:
            exportClause = this.parseExportStar_();
            this.eatId_(FROM);
            moduleSpecifier = this.parseModuleSpecifier_();
            break;
          default:
            exportClause = this.parseForwardDefaultExport_();
            this.eatId_(FROM);
            moduleSpecifier = this.parseModuleSpecifier_();
            break;
        }
        this.eatPossibleImplicitSemiColon_();
        return new NamedExport(this.getTreeLocation_(start), exportClause, moduleSpecifier);
      },
      parseExportStar_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(STAR);
        if (this.peekPredefinedString_(AS)) {
          this.eatId_(AS);
          var name = this.eatIdName_();
          return new NameSpaceExport(this.getTreeLocation_(start), name);
        }
        return new ExportStar(this.getTreeLocation_(start));
      },
      parseExportSpecifierSet_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(OPEN_CURLY);
        var specifiers = [this.parseExportSpecifier_()];
        while (this.eatIf_(COMMA)) {
          if (peek(CLOSE_CURLY))
            break;
          specifiers.push(this.parseExportSpecifier_());
        }
        this.eat_(CLOSE_CURLY);
        return new ExportSpecifierSet(this.getTreeLocation_(start), specifiers);
      },
      parseExportSpecifier_: function() {
        var start = this.getTreeStartLocation_();
        var lhs = this.eatIdName_();
        var rhs = null;
        if (this.peekPredefinedString_(AS)) {
          this.eatId_();
          rhs = this.eatIdName_();
        }
        return new ExportSpecifier(this.getTreeLocation_(start), lhs, rhs);
      },
      parseForwardDefaultExport_: function() {
        var start = this.getTreeStartLocation_();
        var idName = this.eatIdName_();
        return new ForwardDefaultExport(this.getTreeLocation_(start), idName);
      },
      validateExportSpecifierSet_: function(tree) {
        for (var i = 0; i < tree.specifiers.length; i++) {
          var specifier = tree.specifiers[i];
          if (getKeywordType(specifier.lhs.value)) {
            this.reportError_(specifier.lhs.location, ("Unexpected token " + specifier.lhs.value));
          }
        }
      },
      peekId_: function(type) {
        if (type === IDENTIFIER)
          return true;
        if (this.strictMode_)
          return false;
        return peekToken().isStrictKeyword();
      },
      peekIdName_: function(token) {
        return token.type === IDENTIFIER || token.isKeyword();
      },
      parseClassShared_: function(constr) {
        var start = this.getTreeStartLocation_();
        var strictMode = this.strictMode_;
        this.strictMode_ = true;
        this.eat_(CLASS);
        var name = null;
        var typeParameters = null;
        var annotations = [];
        if (constr === ClassDeclaration || !peek(EXTENDS) && !peek(OPEN_CURLY)) {
          name = this.parseBindingIdentifier_();
          if (this.options_.types) {
            typeParameters = this.parseTypeParametersOpt_();
          }
          annotations = this.popAnnotations_();
        }
        var superClass = null;
        if (this.eatIf_(EXTENDS)) {
          superClass = this.parseLeftHandSideExpression_();
          superClass = this.coverFormalsToParenExpression_(superClass);
        }
        this.eat_(OPEN_CURLY);
        var elements = this.parseClassElements_(superClass);
        this.eat_(CLOSE_CURLY);
        this.strictMode_ = strictMode;
        return new constr(this.getTreeLocation_(start), name, superClass, elements, annotations, typeParameters);
      },
      parseClassDeclaration_: function() {
        return this.parseClassShared_(ClassDeclaration);
      },
      parseClassExpression_: function() {
        return this.parseClassShared_(ClassExpression);
      },
      parseClassElements_: function(derivedClass) {
        var result = [];
        while (true) {
          var type = peekType();
          if (type === SEMI_COLON) {
            nextToken();
          } else if (this.peekClassElement_(peekType())) {
            result.push(this.parseClassElement_(derivedClass));
          } else {
            break;
          }
        }
        return result;
      },
      peekClassElement_: function(type) {
        return this.peekPropertyName_(type) || type === STAR && this.options_.generators || type === AT && this.options_.annotations;
      },
      parsePropertyName_: function() {
        if (peek(OPEN_SQUARE))
          return this.parseComputedPropertyName_();
        return this.parseLiteralPropertyName_();
      },
      parseLiteralPropertyName_: function() {
        var start = this.getTreeStartLocation_();
        var token = nextToken();
        return new LiteralPropertyName(this.getTreeLocation_(start), token);
      },
      parseComputedPropertyName_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(OPEN_SQUARE);
        var expression = this.parseAssignmentExpression_(ALLOW_IN);
        this.eat_(CLOSE_SQUARE);
        return new ComputedPropertyName(this.getTreeLocation_(start), expression);
      },
      parseStatement: function() {
        var fs = this.pushFunctionState_(FUNCTION_STATE_LENIENT);
        var result = this.parseModuleItem_(peekType());
        this.popFunctionState_(fs);
        return result;
      },
      parseStatements: function() {
        var fs = this.pushFunctionState_(FUNCTION_STATE_LENIENT);
        var result = this.parseModuleItemList_();
        this.popFunctionState_(fs);
        return result;
      },
      parseStatement_: function() {
        return this.parseStatementWithType_(peekType());
      },
      parseStatementWithType_: function(type) {
        switch (type) {
          case RETURN:
            return this.parseReturnStatement_();
          case VAR:
            return this.parseVariableStatement_();
          case IF:
            return this.parseIfStatement_();
          case FOR:
            return this.parseForStatement_();
          case BREAK:
            return this.parseBreakStatement_();
          case SWITCH:
            return this.parseSwitchStatement_();
          case THROW:
            return this.parseThrowStatement_();
          case WHILE:
            return this.parseWhileStatement_();
          case AT:
            if (this.options_.annotations)
              return this.parseAnnotatedDeclarations_(false);
            break;
          case CONTINUE:
            return this.parseContinueStatement_();
          case DEBUGGER:
            return this.parseDebuggerStatement_();
          case DO:
            return this.parseDoWhileStatement_();
          case OPEN_CURLY:
            return this.parseBlock_();
          case SEMI_COLON:
            return this.parseEmptyStatement_();
          case TRY:
            return this.parseTryStatement_();
          case WITH:
            return this.parseWithStatement_();
          case INTERFACE:
            if (this.options_.types) {
              return this.parseInterfaceDeclaration_();
            }
        }
        return this.parseFallThroughStatement_();
      },
      parseFunctionDeclaration_: function() {
        return this.parseFunction_(FunctionDeclaration);
      },
      parseFunctionExpression_: function() {
        return this.parseFunction_(FunctionExpression);
      },
      parseAsyncFunctionDeclaration_: function(asyncToken) {
        return this.parseAsyncFunction_(asyncToken, FunctionDeclaration);
      },
      parseAsyncFunctionExpression_: function(asyncToken) {
        return this.parseAsyncFunction_(asyncToken, FunctionExpression);
      },
      peekAsyncStar_: function() {
        return this.options_.asyncGenerators && peek(STAR);
      },
      parseAsyncFunction_: function(asyncToken, ctor) {
        var start = asyncToken.location.start;
        this.eat_(FUNCTION);
        var kind = FUNCTION_STATE_FUNCTION | FUNCTION_STATE_ASYNC;
        if (this.peekAsyncStar_()) {
          kind |= FUNCTION_STATE_GENERATOR;
          this.eat_(STAR);
          asyncToken = new IdentifierToken(asyncToken.location, ASYNC_STAR);
        }
        var fs = this.pushFunctionState_(kind);
        var f = this.parseFunction2_(start, asyncToken, ctor);
        this.popFunctionState_(fs);
        return f;
      },
      parseFunction_: function(ctor) {
        var start = this.getTreeStartLocation_();
        this.eat_(FUNCTION);
        var functionKind = null;
        var kind = FUNCTION_STATE_FUNCTION;
        if (this.options_.generators && peek(STAR)) {
          functionKind = this.eat_(STAR);
          kind |= FUNCTION_STATE_GENERATOR;
        }
        var fs = this.pushFunctionState_(kind);
        var f = this.parseFunction2_(start, functionKind, ctor);
        this.popFunctionState_(fs);
        return f;
      },
      parseFunction2_: function(start, functionKind, ctor) {
        var name = null;
        var annotations = [];
        if (ctor === FunctionDeclaration || this.peekBindingIdentifier_(peekType())) {
          name = this.parseBindingIdentifier_();
          annotations = this.popAnnotations_();
        }
        this.eat_(OPEN_PAREN);
        var parameters = this.parseFormalParameters_();
        this.eat_(CLOSE_PAREN);
        var typeAnnotation = this.parseTypeAnnotationOpt_();
        var body = this.parseFunctionBody_(parameters);
        return new ctor(this.getTreeLocation_(start), name, functionKind, parameters, typeAnnotation, annotations, body);
      },
      peekRest_: function(type) {
        return type === DOT_DOT_DOT && this.options_.restParameters;
      },
      parseFormalParameters_: function() {
        var start = this.getTreeStartLocation_();
        var formals = [];
        this.pushAnnotations_();
        var type = peekType();
        if (this.peekRest_(type)) {
          formals.push(this.parseFormalRestParameter_());
        } else {
          if (this.peekFormalParameter_(peekType()))
            formals.push(this.parseFormalParameter_(INITIALIZER_OPTIONAL));
          while (this.eatIf_(COMMA)) {
            this.pushAnnotations_();
            if (this.peekRest_(peekType())) {
              formals.push(this.parseFormalRestParameter_());
              break;
            }
            formals.push(this.parseFormalParameter_(INITIALIZER_OPTIONAL));
          }
        }
        return new FormalParameterList(this.getTreeLocation_(start), formals);
      },
      peekFormalParameter_: function(type) {
        return this.peekBindingElement_(type);
      },
      parseFormalParameter_: function(initializerAllowed) {
        var start = this.getTreeStartLocation_();
        var binding = this.parseBindingElementBinding_();
        var typeAnnotation = this.parseTypeAnnotationOpt_();
        var initializer = this.parseBindingElementInitializer_(initializerAllowed);
        return new FormalParameter(this.getTreeLocation_(start), new BindingElement(this.getTreeLocation_(start), binding, initializer), typeAnnotation, this.popAnnotations_());
      },
      parseFormalRestParameter_: function() {
        var start = this.getTreeStartLocation_();
        var restParameter = this.parseRestParameter_();
        var typeAnnotation = this.parseTypeAnnotationOpt_();
        return new FormalParameter(this.getTreeLocation_(start), restParameter, typeAnnotation, this.popAnnotations_());
      },
      parseRestParameter_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(DOT_DOT_DOT);
        var id = this.parseBindingIdentifier_();
        var typeAnnotation = this.parseTypeAnnotationOpt_();
        return new RestParameter(this.getTreeLocation_(start), id, typeAnnotation);
      },
      parseFunctionBody_: function(params) {
        var start = this.getTreeStartLocation_();
        this.eat_(OPEN_CURLY);
        var strictMode = this.strictMode_;
        var result = this.parseStatementList_(!strictMode);
        validateParameters(params, this.strictMode_, this.errorReporter_);
        this.strictMode_ = strictMode;
        this.eat_(CLOSE_CURLY);
        return new FunctionBody(this.getTreeLocation_(start), result);
      },
      parseSpreadExpression_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(DOT_DOT_DOT);
        var operand = this.parseAssignmentExpression_(ALLOW_IN);
        return new SpreadExpression(this.getTreeLocation_(start), operand);
      },
      parseBlock_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(OPEN_CURLY);
        var result = this.parseStatementList_(false);
        this.eat_(CLOSE_CURLY);
        return new Block(this.getTreeLocation_(start), result);
      },
      parseVariableStatement_: function() {
        var start = this.getTreeStartLocation_();
        var declarations = this.parseVariableDeclarationList_(ALLOW_IN, INITIALIZER_REQUIRED);
        this.checkInitializers_(declarations);
        this.eatPossibleImplicitSemiColon_();
        return new VariableStatement(this.getTreeLocation_(start), declarations);
      },
      parseVariableDeclarationList_: function(allowIn, initializerRequired) {
        var type = peekType();
        switch (type) {
          case CONST:
          case LET:
          case VAR:
            nextToken();
            break;
          default:
            throw Error('unreachable');
        }
        var start = this.getTreeStartLocation_();
        var declarations = [];
        declarations.push(this.parseVariableDeclaration_(type, allowIn, initializerRequired));
        while (this.eatIf_(COMMA)) {
          declarations.push(this.parseVariableDeclaration_(type, allowIn, initializerRequired));
        }
        return new VariableDeclarationList(this.getTreeLocation_(start), type, declarations);
      },
      parseVariableDeclaration_: function(binding, noIn, initializerRequired) {
        var initRequired = initializerRequired !== INITIALIZER_OPTIONAL;
        var start = this.getTreeStartLocation_();
        var lvalue;
        var typeAnnotation;
        if (this.peekPattern_(peekType())) {
          lvalue = this.parseBindingPattern_();
          typeAnnotation = null;
        } else {
          lvalue = this.parseBindingIdentifier_();
          typeAnnotation = this.parseTypeAnnotationOpt_();
        }
        var init = null;
        if (peek(EQUAL)) {
          init = this.parseInitializer_(noIn);
        } else if (lvalue.isPattern() && initRequired) {
          this.reportError_(lvalue.location, 'destructuring must have an initializer');
        }
        return new VariableDeclaration(this.getTreeLocation_(start), lvalue, typeAnnotation, init);
      },
      parseInitializer_: function(allowIn) {
        this.eat_(EQUAL);
        return this.parseAssignmentExpression_(allowIn);
      },
      parseInitializerOpt_: function(allowIn) {
        if (this.eatIf_(EQUAL))
          return this.parseAssignmentExpression_(allowIn);
        return null;
      },
      parseEmptyStatement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(SEMI_COLON);
        return new EmptyStatement(this.getTreeLocation_(start));
      },
      parseFallThroughStatement_: function() {
        var start = this.getTreeStartLocation_();
        var expression;
        switch (peekType()) {
          case OPEN_CURLY:
            return this.parseUnexpectedToken_();
          case FUNCTION:
          case CLASS:
            return this.parseUnexpectedReservedWord_(peekToken());
          case LET:
            {
              var token = peekLookahead(OPEN_SQUARE);
              if (token) {
                return this.parseSyntaxError_("A statement cannot start with 'let ['");
              }
            }
        }
        if (this.options_.asyncFunctions && this.peekPredefinedString_(ASYNC) && peekLookahead(FUNCTION)) {
          var asyncToken = this.eatId_();
          var functionToken = peekTokenNoLineTerminator();
          if (functionToken !== null)
            return this.parseAsyncFunctionDeclaration_(asyncToken);
          expression = new IdentifierExpression(this.getTreeLocation_(start), asyncToken);
        } else {
          expression = this.parseExpression_(ALLOW_IN);
        }
        if (expression.type === IDENTIFIER_EXPRESSION) {
          if (this.eatIf_(COLON)) {
            var nameToken = expression.identifierToken;
            var statement = this.parseStatement_();
            return new LabelledStatement(this.getTreeLocation_(start), nameToken, statement);
          }
        }
        this.eatPossibleImplicitSemiColon_();
        return new ExpressionStatement(this.getTreeLocation_(start), expression);
      },
      parseIfStatement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(IF);
        this.eat_(OPEN_PAREN);
        var condition = this.parseExpression_(ALLOW_IN);
        this.eat_(CLOSE_PAREN);
        var ifClause = this.parseStatement_();
        var elseClause = null;
        if (this.eatIf_(ELSE)) {
          elseClause = this.parseStatement_();
        }
        return new IfStatement(this.getTreeLocation_(start), condition, ifClause, elseClause);
      },
      parseDoWhileStatement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(DO);
        var body = this.parseStatement_();
        this.eat_(WHILE);
        this.eat_(OPEN_PAREN);
        var condition = this.parseExpression_(ALLOW_IN);
        this.eat_(CLOSE_PAREN);
        this.eatPossibleImplicitSemiColon_();
        return new DoWhileStatement(this.getTreeLocation_(start), body, condition);
      },
      parseWhileStatement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(WHILE);
        this.eat_(OPEN_PAREN);
        var condition = this.parseExpression_(ALLOW_IN);
        this.eat_(CLOSE_PAREN);
        var body = this.parseStatement_();
        return new WhileStatement(this.getTreeLocation_(start), condition, body);
      },
      parseForStatement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(FOR);
        this.eat_(OPEN_PAREN);
        var type = peekType();
        if (this.peekVariableDeclarationList_(type)) {
          var variables = this.parseVariableDeclarationList_(NO_IN, INITIALIZER_OPTIONAL);
          var declarations = variables.declarations;
          if (declarations.length > 1 || containsInitializer(declarations)) {
            return this.parseForStatement2_(start, variables);
          }
          type = peekType();
          if (type === IN) {
            return this.parseForInStatement_(start, variables);
          } else if (this.peekOf_()) {
            return this.parseForOfStatement_(start, variables);
          } else if (this.allowForOn_ && this.peekOn_()) {
            return this.parseForOnStatement_(start, variables);
          } else {
            this.checkInitializers_(variables);
            return this.parseForStatement2_(start, variables);
          }
        }
        if (type === SEMI_COLON) {
          return this.parseForStatement2_(start, null);
        }
        var coverInitializedNameCount = this.coverInitializedNameCount_;
        var initializer = this.parseExpressionAllowPattern_(NO_IN);
        type = peekType();
        if ((type === IN || this.peekOf_() || this.allowForOn_ && this.peekOn_())) {
          initializer = this.transformLeftHandSideExpression_(initializer);
          this.validateAssignmentTarget_(initializer, 'assignment');
          if (this.peekOf_()) {
            return this.parseForOfStatement_(start, initializer);
          } else if (this.allowForOn_ && this.peekOn_()) {
            return this.parseForOnStatement_(start, initializer);
          }
          return this.parseForInStatement_(start, initializer);
        }
        this.ensureNoCoverInitializedNames_(initializer, coverInitializedNameCount);
        return this.parseForStatement2_(start, initializer);
      },
      peekOf_: function() {
        return this.options_.forOf && this.peekPredefinedString_(OF);
      },
      peekOn_: function() {
        return this.options_.forOn && this.peekPredefinedString_(ON);
      },
      parseForOfStatement_: function(start, initializer) {
        this.eatId_();
        var collection = this.parseExpression_(ALLOW_IN);
        this.eat_(CLOSE_PAREN);
        var body = this.parseStatement_();
        return new ForOfStatement(this.getTreeLocation_(start), initializer, collection, body);
      },
      parseForOnStatement_: function(start, initializer) {
        this.eatId_();
        var observable = this.parseExpression_(ALLOW_IN);
        this.eat_(CLOSE_PAREN);
        var body = this.parseStatement_();
        return new ForOnStatement(this.getTreeLocation_(start), initializer, observable, body);
      },
      checkInitializers_: function(variables) {
        if (this.options_.blockBinding && variables.declarationType === CONST) {
          var type = variables.declarationType;
          for (var i = 0; i < variables.declarations.length; i++) {
            if (!this.checkInitializer_(type, variables.declarations[i])) {
              break;
            }
          }
        }
      },
      checkInitializer_: function(type, declaration) {
        if (this.options_.blockBinding && type === CONST && declaration.initializer === null) {
          this.reportError_(declaration.location, 'const variables must have an initializer');
          return false;
        }
        return true;
      },
      peekVariableDeclarationList_: function(type) {
        switch (type) {
          case VAR:
            return true;
          case CONST:
          case LET:
            return this.options_.blockBinding;
          default:
            return false;
        }
      },
      parseForStatement2_: function(start, initializer) {
        this.eat_(SEMI_COLON);
        var condition = null;
        if (!peek(SEMI_COLON)) {
          condition = this.parseExpression_(ALLOW_IN);
        }
        this.eat_(SEMI_COLON);
        var increment = null;
        if (!peek(CLOSE_PAREN)) {
          increment = this.parseExpression_(ALLOW_IN);
        }
        this.eat_(CLOSE_PAREN);
        var body = this.parseStatement_();
        return new ForStatement(this.getTreeLocation_(start), initializer, condition, increment, body);
      },
      parseForInStatement_: function(start, initializer) {
        this.eat_(IN);
        var collection = this.parseExpression_(ALLOW_IN);
        this.eat_(CLOSE_PAREN);
        var body = this.parseStatement_();
        return new ForInStatement(this.getTreeLocation_(start), initializer, collection, body);
      },
      parseContinueStatement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(CONTINUE);
        var name = null;
        if (!this.peekImplicitSemiColon_()) {
          name = this.eatIdOpt_();
        }
        this.eatPossibleImplicitSemiColon_();
        return new ContinueStatement(this.getTreeLocation_(start), name);
      },
      parseBreakStatement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(BREAK);
        var name = null;
        if (!this.peekImplicitSemiColon_()) {
          name = this.eatIdOpt_();
        }
        this.eatPossibleImplicitSemiColon_();
        return new BreakStatement(this.getTreeLocation_(start), name);
      },
      parseReturnStatement_: function() {
        var start = this.getTreeStartLocation_();
        var returnToken = this.eat_(RETURN);
        if (this.functionState_.isTopMost()) {
          this.reportError_(returnToken.location, 'Illegal return statement');
        }
        var expression = null;
        if (!this.peekImplicitSemiColon_()) {
          expression = this.parseExpression_(ALLOW_IN);
        }
        this.eatPossibleImplicitSemiColon_();
        return new ReturnStatement(this.getTreeLocation_(start), expression);
      },
      parseYieldExpression_: function(allowIn) {
        var start = this.getTreeStartLocation_();
        this.eat_(YIELD);
        var expression = null;
        var isYieldFor = false;
        var token = peekTokenNoLineTerminator();
        if (token !== null) {
          switch (token.type) {
            case CLOSE_CURLY:
            case CLOSE_PAREN:
            case CLOSE_SQUARE:
            case COLON:
            case COMMA:
            case END_OF_FILE:
            case SEMI_COLON:
              break;
            default:
              isYieldFor = this.eatIf_(STAR);
              expression = this.parseAssignmentExpression_(allowIn);
          }
        }
        return new YieldExpression(this.getTreeLocation_(start), expression, isYieldFor);
      },
      parseWithStatement_: function() {
        var start = this.getTreeStartLocation_();
        var withToken = this.eat_(WITH);
        if (this.strictMode_) {
          this.reportError_(withToken.location, 'Strict mode code may not include a with statement');
        }
        this.eat_(OPEN_PAREN);
        var expression = this.parseExpression_(ALLOW_IN);
        this.eat_(CLOSE_PAREN);
        var body = this.parseStatement_();
        return new WithStatement(this.getTreeLocation_(start), expression, body);
      },
      parseSwitchStatement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(SWITCH);
        this.eat_(OPEN_PAREN);
        var expression = this.parseExpression_(ALLOW_IN);
        this.eat_(CLOSE_PAREN);
        this.eat_(OPEN_CURLY);
        var caseClauses = this.parseCaseClauses_();
        this.eat_(CLOSE_CURLY);
        return new SwitchStatement(this.getTreeLocation_(start), expression, caseClauses);
      },
      parseCaseClauses_: function() {
        var foundDefaultClause = false;
        var result = [];
        while (true) {
          var start = this.getTreeStartLocation_();
          switch (peekType()) {
            case CASE:
              {
                nextToken();
                var expression = this.parseExpression_(ALLOW_IN);
                this.eat_(COLON);
                var statements = this.parseCaseStatementsOpt_();
                result.push(new CaseClause(this.getTreeLocation_(start), expression, statements));
                break;
              }
            case DEFAULT:
              {
                var defaultToken = nextToken();
                if (foundDefaultClause) {
                  this.reportError_(defaultToken.location, 'Switch statements may have at most one \'default\' clause');
                } else {
                  foundDefaultClause = true;
                }
                this.eat_(COLON);
                result.push(new DefaultClause(this.getTreeLocation_(start), this.parseCaseStatementsOpt_()));
                break;
              }
            default:
              return result;
          }
        }
      },
      parseCaseStatementsOpt_: function() {
        var result = [];
        var type;
        while (true) {
          switch (type = peekType()) {
            case CASE:
            case DEFAULT:
            case CLOSE_CURLY:
            case END_OF_FILE:
              return result;
          }
          result.push(this.parseStatementListItem_(type));
        }
      },
      parseThrowStatement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(THROW);
        var value = null;
        if (!this.peekImplicitSemiColon_()) {
          value = this.parseExpression_(ALLOW_IN);
        }
        this.eatPossibleImplicitSemiColon_();
        return new ThrowStatement(this.getTreeLocation_(start), value);
      },
      parseTryStatement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(TRY);
        var body = this.parseBlock_();
        var catchBlock = null;
        if (peek(CATCH)) {
          catchBlock = this.parseCatch_();
        }
        var finallyBlock = null;
        if (peek(FINALLY)) {
          finallyBlock = this.parseFinallyBlock_();
        }
        if (catchBlock === null && finallyBlock === null) {
          var token = peekToken();
          this.reportError_(token.location, "'catch' or 'finally' expected.");
        }
        return new TryStatement(this.getTreeLocation_(start), body, catchBlock, finallyBlock);
      },
      parseCatch_: function() {
        var start = this.getTreeStartLocation_();
        var catchBlock;
        this.eat_(CATCH);
        this.eat_(OPEN_PAREN);
        var binding;
        if (this.peekPattern_(peekType()))
          binding = this.parseBindingPattern_();
        else
          binding = this.parseBindingIdentifier_();
        this.eat_(CLOSE_PAREN);
        var catchBody = this.parseBlock_();
        catchBlock = new Catch(this.getTreeLocation_(start), binding, catchBody);
        return catchBlock;
      },
      parseFinallyBlock_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(FINALLY);
        var finallyBlock = this.parseBlock_();
        return new Finally(this.getTreeLocation_(start), finallyBlock);
      },
      parseDebuggerStatement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(DEBUGGER);
        this.eatPossibleImplicitSemiColon_();
        return new DebuggerStatement(this.getTreeLocation_(start));
      },
      parsePrimaryExpression_: function() {
        switch (peekType()) {
          case CLASS:
            return this.options_.classes ? this.parseClassExpression_() : this.parseUnexpectedReservedWord_(peekToken());
          case THIS:
            return this.parseThisExpression_();
          case IDENTIFIER:
            {
              var identifier = this.parseIdentifierExpression_();
              if (this.options_.asyncFunctions && identifier.identifierToken.value === ASYNC) {
                var token$__6 = peekTokenNoLineTerminator();
                if (token$__6 && token$__6.type === FUNCTION) {
                  var asyncToken = identifier.identifierToken;
                  return this.parseAsyncFunctionExpression_(asyncToken);
                }
              }
              return identifier;
            }
          case NUMBER:
          case STRING:
          case TRUE:
          case FALSE:
          case NULL:
            return this.parseLiteralExpression_();
          case OPEN_SQUARE:
            return this.parseArrayLiteral_();
          case OPEN_CURLY:
            return this.parseObjectLiteral_();
          case OPEN_PAREN:
            return this.parsePrimaryExpressionStartingWithParen_();
          case SLASH:
          case SLASH_EQUAL:
            return this.parseRegularExpressionLiteral_();
          case NO_SUBSTITUTION_TEMPLATE:
          case TEMPLATE_HEAD:
            if (this.options_.templateLiterals) {
              return this.parseTemplateLiteral_(null);
            }
            break;
          case IMPLEMENTS:
          case INTERFACE:
          case PACKAGE:
          case PRIVATE:
          case PROTECTED:
          case PUBLIC:
          case STATIC:
          case YIELD:
            if (this.strictMode_) {
              this.reportReservedIdentifier_(nextToken());
            }
            return this.parseIdentifierExpression_();
          case OPEN_ANGLE:
            if (this.options_.jsx) {
              return this.parseJsxElement_();
            }
            break;
          case END_OF_FILE:
            return this.parseSyntaxError_('Unexpected end of input');
        }
        var token = peekToken();
        if (token.isKeyword()) {
          return this.parseUnexpectedReservedWord_(token);
        }
        return this.parseUnexpectedToken_(token);
      },
      parseSuperExpression_: function(isNew) {
        var start = this.getTreeStartLocation_();
        var fs = this.functionState_;
        while (fs && fs.isArrowFunction()) {
          fs = fs.outer;
        }
        var superToken = this.eat_(SUPER);
        if (!fs || !fs.isMethod()) {
          this.reportError_(superToken.location, 'super is only allowed in methods');
        }
        var operand = new SuperExpression(this.getTreeLocation_(start));
        var type = peekType();
        if (isNew) {
          if (type === OPEN_SQUARE) {
            return this.parseMemberLookupExpression_(start, operand);
          }
          return this.parseMemberExpression_(start, operand);
        }
        switch (type) {
          case OPEN_SQUARE:
            return this.parseMemberLookupExpression_(start, operand);
          case PERIOD:
            return this.parseMemberExpression_(start, operand);
          case OPEN_PAREN:
            {
              var superCall = this.parseCallExpression_(start, operand);
              if (!fs.isDerivedConstructor()) {
                this.reportError_(superToken.location, 'super call is only allowed in derived constructor');
              }
              return superCall;
            }
        }
        return this.parseUnexpectedToken_();
      },
      parseThisExpression_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(THIS);
        return new ThisExpression(this.getTreeLocation_(start));
      },
      peekBindingIdentifier_: function(type) {
        return this.peekId_(type);
      },
      parseBindingIdentifier_: function() {
        var start = this.getTreeStartLocation_();
        var identifier = this.eatId_();
        return new BindingIdentifier(this.getTreeLocation_(start), identifier);
      },
      parseIdentifierExpression_: function() {
        var start = this.getTreeStartLocation_();
        var identifier = this.eatId_();
        return new IdentifierExpression(this.getTreeLocation_(start), identifier);
      },
      parseIdentifierNameExpression_: function() {
        var start = this.getTreeStartLocation_();
        var identifier = this.eatIdName_();
        return new IdentifierExpression(this.getTreeLocation_(start), identifier);
      },
      parseLiteralExpression_: function() {
        var start = this.getTreeStartLocation_();
        var literal = this.nextLiteralToken_();
        return new LiteralExpression(this.getTreeLocation_(start), literal);
      },
      nextLiteralToken_: function() {
        return nextToken();
      },
      parseRegularExpressionLiteral_: function() {
        var start = this.getTreeStartLocation_();
        var literal = nextRegularExpressionLiteralToken();
        return new LiteralExpression(this.getTreeLocation_(start), literal);
      },
      peekSpread_: function(type) {
        return type === DOT_DOT_DOT && this.options_.spread;
      },
      parseArrayLiteral_: function() {
        var start = this.getTreeStartLocation_();
        var expression;
        var elements = [];
        this.eat_(OPEN_SQUARE);
        var type = peekType();
        if (type === FOR && this.options_.arrayComprehension)
          return this.parseArrayComprehension_(start);
        while (true) {
          type = peekType();
          if (type === COMMA) {
            expression = null;
          } else if (this.peekSpread_(type)) {
            expression = this.parseSpreadExpression_();
          } else if (type === CLOSE_SQUARE || type === END_OF_FILE) {
            break;
          } else {
            expression = this.parseAssignmentExpression_(ALLOW_IN);
          }
          elements.push(expression);
          type = peekType();
          if (type !== CLOSE_SQUARE)
            this.eat_(COMMA);
        }
        this.eat_(CLOSE_SQUARE);
        return new ArrayLiteral(this.getTreeLocation_(start), elements);
      },
      parseArrayComprehension_: function(start) {
        var list = this.parseComprehensionList_();
        var expression = this.parseAssignmentExpression_(ALLOW_IN);
        this.eat_(CLOSE_SQUARE);
        return new ArrayComprehension(this.getTreeLocation_(start), list, expression);
      },
      parseComprehensionList_: function() {
        var list = [this.parseComprehensionFor_()];
        while (true) {
          var type = peekType();
          switch (type) {
            case FOR:
              list.push(this.parseComprehensionFor_());
              break;
            case IF:
              list.push(this.parseComprehensionIf_());
              break;
            default:
              return list;
          }
        }
      },
      parseComprehensionFor_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(FOR);
        this.eat_(OPEN_PAREN);
        var left = this.parseForBinding_();
        this.eatId_(OF);
        var iterator = this.parseExpression_(ALLOW_IN);
        this.eat_(CLOSE_PAREN);
        return new ComprehensionFor(this.getTreeLocation_(start), left, iterator);
      },
      parseComprehensionIf_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(IF);
        this.eat_(OPEN_PAREN);
        var expression = this.parseExpression_(ALLOW_IN);
        this.eat_(CLOSE_PAREN);
        return new ComprehensionIf(this.getTreeLocation_(start), expression);
      },
      parseObjectLiteral_: function() {
        var start = this.getTreeStartLocation_();
        var result = [];
        this.eat_(OPEN_CURLY);
        while (this.peekPropertyDefinition_(peekType())) {
          var propertyDefinition = this.parsePropertyDefinition_();
          result.push(propertyDefinition);
          if (!this.eatIf_(COMMA))
            break;
        }
        this.eat_(CLOSE_CURLY);
        return new ObjectLiteral(this.getTreeLocation_(start), result);
      },
      parsePropertyDefinition: function() {
        var fs = this.pushFunctionState_(FUNCTION_STATE_SCRIPT);
        var result = this.parsePropertyDefinition_();
        this.popFunctionState_(fs);
        return result;
      },
      parsePropertyDefinition_: function() {
        var start = this.getTreeStartLocation_();
        var functionKind = null;
        var isStatic = false;
        if (this.options_.generators && this.options_.propertyMethods && peek(STAR)) {
          var fs = this.pushFunctionState_(FUNCTION_STATE_METHOD | FUNCTION_STATE_GENERATOR);
          var m = this.parseGeneratorMethod_(start, isStatic, []);
          this.popFunctionState_(fs);
          return m;
        }
        if (this.options_.spreadProperties && peek(DOT_DOT_DOT)) {
          return this.parseSpreadExpression_();
        }
        var token = peekToken();
        var name = this.parsePropertyName_();
        if (this.options_.propertyMethods && peek(OPEN_PAREN)) {
          var fs$__7 = this.pushFunctionState_(FUNCTION_STATE_METHOD);
          var m$__8 = this.parseMethod_(start, isStatic, functionKind, name, []);
          this.popFunctionState_(fs$__7);
          return m$__8;
        }
        if (this.eatIf_(COLON)) {
          var value = this.parseAssignmentExpression_(ALLOW_IN);
          return new PropertyNameAssignment(this.getTreeLocation_(start), name, value);
        }
        var type = peekType();
        if (name.type === LITERAL_PROPERTY_NAME) {
          var nameLiteral = name.literalToken;
          if (nameLiteral.value === GET && this.peekPropertyName_(type)) {
            return this.parseGetAccessor_(start, isStatic, []);
          }
          if (nameLiteral.value === SET && this.peekPropertyName_(type)) {
            return this.parseSetAccessor_(start, isStatic, []);
          }
          if (this.options_.asyncFunctions && nameLiteral.value === ASYNC && (this.peekPropertyName_(type) || this.peekAsyncStar_())) {
            var async = nameLiteral;
            var kind = FUNCTION_STATE_METHOD | FUNCTION_STATE_ASYNC;
            if (this.peekAsyncStar_()) {
              kind |= FUNCTION_STATE_GENERATOR;
              this.eat_(STAR);
              async = new IdentifierToken(async.location, ASYNC_STAR);
            }
            var name$__9 = this.parsePropertyName_();
            var fs$__10 = this.pushFunctionState_(kind);
            var m$__11 = this.parseMethod_(start, isStatic, async, name$__9, []);
            this.popFunctionState_(fs$__10);
            return m$__11;
          }
          if (this.options_.propertyNameShorthand && (nameLiteral.type === IDENTIFIER || nameLiteral.isStrictKeyword() && !this.strictMode_ || nameLiteral.type === YIELD && this.allowYield_)) {
            if (peek(EQUAL)) {
              token = nextToken();
              var coverInitializedNameCount = this.coverInitializedNameCount_;
              var expr = this.parseAssignmentExpression_(ALLOW_IN);
              this.ensureNoCoverInitializedNames_(expr, coverInitializedNameCount);
              this.coverInitializedNameCount_++;
              return new CoverInitializedName(this.getTreeLocation_(start), nameLiteral, token, expr);
            }
            return new PropertyNameShorthand(this.getTreeLocation_(start), nameLiteral);
          }
          if (this.strictMode_ && nameLiteral.isStrictKeyword())
            this.reportReservedIdentifier_(nameLiteral);
        }
        if (name.type === COMPUTED_PROPERTY_NAME)
          token = peekToken();
        return this.parseUnexpectedToken_(token);
      },
      parseClassElement_: function(derivedClass) {
        var start = this.getTreeStartLocation_();
        var annotations = this.parseAnnotations_();
        var type = peekType();
        var isStatic = false,
            functionKind = null;
        switch (type) {
          case STATIC:
            {
              var staticToken = nextToken();
              type = peekType();
              switch (type) {
                case OPEN_PAREN:
                  {
                    var location = this.getTreeLocation_(start);
                    var name = new LiteralPropertyName(location, staticToken);
                    var fs = this.pushFunctionState_(FUNCTION_STATE_METHOD);
                    var m = this.parseMethod_(start, isStatic, functionKind, name, annotations);
                    this.popFunctionState_(fs);
                    return m;
                  }
                default:
                  isStatic = true;
                  if (type === STAR && this.options_.generators)
                    return this.parseGeneratorMethod_(start, true, annotations);
                  return this.parseClassElement2_(start, isStatic, annotations, derivedClass);
              }
              break;
            }
          case STAR:
            return this.parseGeneratorMethod_(start, isStatic, annotations);
          default:
            return this.parseClassElement2_(start, isStatic, annotations, derivedClass);
        }
      },
      parseGeneratorMethod_: function(start, isStatic, annotations) {
        var functionKind = this.eat_(STAR);
        var name = this.parsePropertyName_();
        var fs = this.pushFunctionState_(FUNCTION_STATE_METHOD | FUNCTION_STATE_GENERATOR);
        var m = this.parseMethod_(start, isStatic, functionKind, name, annotations);
        this.popFunctionState_(fs);
        return m;
      },
      parseMethod_: function(start, isStatic, functionKind, name, annotations) {
        this.eat_(OPEN_PAREN);
        var parameterList = this.parseFormalParameters_();
        this.eat_(CLOSE_PAREN);
        var typeAnnotation = this.parseTypeAnnotationOpt_();
        var body = this.parseFunctionBody_(parameterList);
        return new Method(this.getTreeLocation_(start), isStatic, functionKind, name, parameterList, typeAnnotation, annotations, body, null);
      },
      parsePropertyVariableDeclaration_: function(start, isStatic, name, annotations) {
        var typeAnnotation = this.parseTypeAnnotationOpt_();
        var initializer = this.parseInitializerOpt_(ALLOW_IN);
        this.eat_(SEMI_COLON);
        return new PropertyVariableDeclaration(this.getTreeLocation_(start), isStatic, name, typeAnnotation, annotations, initializer);
      },
      parseClassElement2_: function(start, isStatic, annotations, derivedClass) {
        var functionKind = null;
        var name = this.parsePropertyName_();
        var type = peekType();
        if (name.type === LITERAL_PROPERTY_NAME && name.literalToken.value === GET && this.peekPropertyName_(type)) {
          return this.parseGetAccessor_(start, isStatic, annotations);
        }
        if (name.type === LITERAL_PROPERTY_NAME && name.literalToken.value === SET && this.peekPropertyName_(type)) {
          return this.parseSetAccessor_(start, isStatic, annotations);
        }
        if (this.options_.asyncFunctions && name.type === LITERAL_PROPERTY_NAME && name.literalToken.value === ASYNC && (this.peekPropertyName_(type) || this.peekAsyncStar_())) {
          var async = name.literalToken;
          var kind = FUNCTION_STATE_METHOD | FUNCTION_STATE_ASYNC;
          if (this.peekAsyncStar_()) {
            kind |= FUNCTION_STATE_GENERATOR;
            this.eat_(STAR);
            async = new IdentifierToken(async.location, ASYNC_STAR);
          }
          name = this.parsePropertyName_();
          var fs = this.pushFunctionState_(kind);
          var m = this.parseMethod_(start, isStatic, async, name, annotations);
          this.popFunctionState_(fs);
          return m;
        }
        if (!this.options_.memberVariables || type === OPEN_PAREN) {
          var kind$__12 = FUNCTION_STATE_METHOD;
          var isDerivedConstructor = derivedClass && !isStatic && functionKind === null && name.type === LITERAL_PROPERTY_NAME && name.literalToken.value === CONSTRUCTOR;
          if (isDerivedConstructor) {
            kind$__12 |= FUNCTION_STATE_DERIVED_CONSTRUCTOR;
          }
          var fs$__13 = this.pushFunctionState_(kind$__12);
          var m$__14 = this.parseMethod_(start, isStatic, functionKind, name, annotations);
          this.popFunctionState_(fs$__13);
          if (isDerivedConstructor) {
            validateConstructor(m$__14, this.errorReporter_);
          }
          return m$__14;
        }
        return this.parsePropertyVariableDeclaration_(start, isStatic, name, annotations);
      },
      parseGetAccessor_: function(start, isStatic, annotations) {
        var name = this.parsePropertyName_();
        var fs = this.pushFunctionState_(FUNCTION_STATE_METHOD);
        this.eat_(OPEN_PAREN);
        this.eat_(CLOSE_PAREN);
        var typeAnnotation = this.parseTypeAnnotationOpt_();
        var body = this.parseFunctionBody_(null);
        this.popFunctionState_(fs);
        return new GetAccessor(this.getTreeLocation_(start), isStatic, name, typeAnnotation, annotations, body);
      },
      parseSetAccessor_: function(start, isStatic, annotations) {
        var name = this.parsePropertyName_();
        var fs = this.pushFunctionState_(FUNCTION_STATE_METHOD);
        this.eat_(OPEN_PAREN);
        var parameterList = this.parsePropertySetParameterList_();
        this.eat_(CLOSE_PAREN);
        var body = this.parseFunctionBody_(parameterList);
        this.popFunctionState_(fs);
        return new SetAccessor(this.getTreeLocation_(start), isStatic, name, parameterList, annotations, body);
      },
      peekPropertyDefinition_: function(type) {
        return this.peekPropertyName_(type) || type === STAR && this.options_.propertyMethods && this.options_.generators || type === DOT_DOT_DOT && this.options_.spreadProperties;
      },
      peekPropertyName_: function(type) {
        switch (type) {
          case IDENTIFIER:
          case STRING:
          case NUMBER:
            return true;
          case OPEN_SQUARE:
            return this.options_.computedPropertyNames;
          default:
            return peekToken().isKeyword();
        }
      },
      peekPredefinedString_: function(string) {
        var token = peekToken();
        return token.type === IDENTIFIER && token.value === string;
      },
      parsePropertySetParameterList_: function() {
        var start = this.getTreeStartLocation_();
        var binding;
        this.pushAnnotations_();
        if (this.peekPattern_(peekType()))
          binding = this.parseBindingPattern_();
        else
          binding = this.parseBindingIdentifier_();
        var typeAnnotation = this.parseTypeAnnotationOpt_();
        var parameter = new FormalParameter(this.getTreeLocation_(start), new BindingElement(this.getTreeLocation_(start), binding, null), typeAnnotation, this.popAnnotations_());
        return new FormalParameterList(parameter.location, [parameter]);
      },
      parsePrimaryExpressionStartingWithParen_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(OPEN_PAREN);
        if (peek(FOR) && this.options_.generatorComprehension)
          return this.parseGeneratorComprehension_(start);
        return this.parseCoverFormals_(start);
      },
      parseSyntaxError_: function(message) {
        var token = nextToken();
        this.reportError_(token.location, message);
        return new SyntaxErrorTree(token.location, token, message);
      },
      parseUnexpectedToken_: function() {
        var token = arguments[0] !== (void 0) ? arguments[0] : peekToken();
        if (token.type === NO_SUBSTITUTION_TEMPLATE) {
          return this.parseSyntaxError_('Unexpected token `');
        }
        return this.parseSyntaxError_(("Unexpected token " + token));
      },
      parseUnexpectedReservedWord_: function(token) {
        return this.parseSyntaxError_(("Unexpected reserved word " + token));
      },
      parseExpression_: function(allowIn) {
        var coverInitializedNameCount = this.coverInitializedNameCount_;
        var expression = this.parseExpressionAllowPattern_(allowIn);
        this.ensureNoCoverInitializedNames_(expression, coverInitializedNameCount);
        return expression;
      },
      parseExpression: function() {
        var fs = this.pushFunctionState_(FUNCTION_STATE_LENIENT);
        var expression = this.parseExpression_(ALLOW_IN);
        this.popFunctionState_(fs);
        return expression;
      },
      parseExpressionAllowPattern_: function(allowIn) {
        var start = this.getTreeStartLocation_();
        var expression = this.parseAssignmentExpression_(allowIn);
        if (peek(COMMA)) {
          var expressions = [expression];
          while (this.eatIf_(COMMA)) {
            expressions.push(this.parseAssignmentExpression_(allowIn));
          }
          return new CommaExpression(this.getTreeLocation_(start), expressions);
        }
        return expression;
      },
      parseAssignmentExpression_: function(allowIn) {
        if (this.allowYield_ && peek(YIELD))
          return this.parseYieldExpression_(allowIn);
        var start = this.getTreeStartLocation_();
        var validAsyncParen = false;
        if (this.options_.asyncFunctions && this.peekPredefinedString_(ASYNC)) {
          var asyncToken = peekToken();
          var maybeOpenParenToken = peekTokenLookahead();
          validAsyncParen = maybeOpenParenToken.type === OPEN_PAREN && asyncToken.location.end.line === maybeOpenParenToken.location.start.line;
        }
        var left = this.parseConditional_(allowIn);
        var type = peekType();
        if (this.options_.asyncFunctions && left.type === IDENTIFIER_EXPRESSION && left.identifierToken.value === ASYNC && type === IDENTIFIER) {
          if (peekTokenNoLineTerminator() !== null) {
            var bindingIdentifier = this.parseBindingIdentifier_();
            var asyncToken$__15 = left.identifierToken;
            return this.parseArrowFunction_(start, bindingIdentifier, asyncToken$__15);
          }
        }
        if (type === ARROW && peekTokenNoLineTerminator() !== null) {
          if (left.type === COVER_FORMALS || left.type === IDENTIFIER_EXPRESSION)
            return this.parseArrowFunction_(start, left, null);
          if (validAsyncParen && left.type === CALL_EXPRESSION) {
            var asyncToken$__16 = left.operand.identifierToken;
            return this.parseArrowFunction_(start, left.args, asyncToken$__16);
          }
        }
        left = this.coverFormalsToParenExpression_(left);
        if (this.peekAssignmentOperator_(type)) {
          if (type === EQUAL)
            left = this.transformLeftHandSideExpression_(left);
          this.validateAssignmentTarget_(left, 'assignment');
          var operator = nextToken();
          var right = this.parseAssignmentExpression_(allowIn);
          return new BinaryExpression(this.getTreeLocation_(start), left, operator, right);
        }
        return left;
      },
      transformLeftHandSideExpression_: function(tree) {
        switch (tree.type) {
          case ARRAY_LITERAL:
          case OBJECT_LITERAL:
            resetScanner(tree.location.start.offset);
            return this.parseAssignmentPattern_();
        }
        return tree;
      },
      peekAssignmentOperator_: function(type) {
        return isAssignmentOperator(type);
      },
      parseConditional_: function(allowIn) {
        var start = this.getTreeStartLocation_();
        var condition = this.parseBinaryExpression_(allowIn);
        if (this.eatIf_(QUESTION)) {
          condition = this.toPrimaryExpression_(condition);
          var left = this.parseAssignmentExpression_(ALLOW_IN);
          this.eat_(COLON);
          var right = this.parseAssignmentExpression_(allowIn);
          return new ConditionalExpression(this.getTreeLocation_(start), condition, left, right);
        }
        return condition;
      },
      getPrecedence_: function(type, allowIn) {
        switch (type) {
          case OR:
            return 1;
          case AND:
            return 2;
          case BAR:
            return 3;
          case CARET:
            return 4;
          case AMPERSAND:
            return 5;
          case EQUAL_EQUAL:
          case EQUAL_EQUAL_EQUAL:
          case NOT_EQUAL:
          case NOT_EQUAL_EQUAL:
            return 6;
          case CLOSE_ANGLE:
          case GREATER_EQUAL:
          case INSTANCEOF:
          case LESS_EQUAL:
          case OPEN_ANGLE:
            return 7;
          case IN:
            return allowIn ? 7 : 0;
          case LEFT_SHIFT:
          case RIGHT_SHIFT:
          case UNSIGNED_RIGHT_SHIFT:
            return 8;
          case MINUS:
          case PLUS:
            return 9;
          case SLASH:
          case STAR:
          case PERCENT:
            return 10;
          case STAR_STAR:
            return this.options_.exponentiation ? 11 : 0;
          default:
            return 0;
        }
      },
      parseBinaryExpression_: function(allowIn) {
        var start = this.getTreeStartLocation_();
        var left = this.parseUnaryExpression_();
        return this.parseBinaryExpressionHelper_(start, left, -1, allowIn);
      },
      parseBinaryExpressionHelper_: function(start, left, minPrec, allowIn) {
        var type = peekType();
        var prec = this.getPrecedence_(type, allowIn);
        if (prec === 0) {
          return left;
        }
        var leftToRight = type !== STAR_STAR;
        if (leftToRight ? prec > minPrec : prec >= minPrec) {
          var token = nextToken();
          var rightStart = this.getTreeStartLocation_();
          var rightUnary = this.parseUnaryExpression_();
          var right = this.parseBinaryExpressionHelper_(rightStart, rightUnary, prec, allowIn);
          left = this.toPrimaryExpression_(left);
          right = this.toPrimaryExpression_(right);
          var node = new BinaryExpression(this.getTreeLocation_(start), left, token, right);
          return this.parseBinaryExpressionHelper_(start, node, minPrec, allowIn);
        }
        return left;
      },
      parseUnaryExpression_: function() {
        var start = this.getTreeStartLocation_();
        if (this.allowAwait_ && this.peekPredefinedString_(AWAIT)) {
          this.eatId_();
          var operand;
          if (this.allowYield_ && peek(YIELD)) {
            operand = this.parseYieldExpression_(ALLOW_IN);
          } else {
            operand = this.parseUnaryExpression_();
            operand = this.toPrimaryExpression_(operand);
          }
          return new AwaitExpression(this.getTreeLocation_(start), operand);
        }
        if (this.peekUnaryOperator_(peekType())) {
          var operator = nextToken();
          var operand$__17 = this.parseUnaryExpression_();
          operand$__17 = this.toPrimaryExpression_(operand$__17);
          if (operand$__17.type !== SYNTAX_ERROR_TREE) {
            switch (operator.type) {
              case PLUS_PLUS:
              case MINUS_MINUS:
                this.validateAssignmentTarget_(operand$__17, 'prefix operation');
            }
          }
          return new UnaryExpression(this.getTreeLocation_(start), operator, operand$__17);
        }
        return this.parsePostfixExpression_();
      },
      peekUnaryOperator_: function(type) {
        switch (type) {
          case DELETE:
          case VOID:
          case TYPEOF:
          case PLUS_PLUS:
          case MINUS_MINUS:
          case PLUS:
          case MINUS:
          case TILDE:
          case BANG:
            return true;
          default:
            return false;
        }
      },
      parsePostfixExpression_: function() {
        var start = this.getTreeStartLocation_();
        var operand = this.parseLeftHandSideExpression_();
        while (this.peekPostfixOperator_(peekType())) {
          operand = this.toPrimaryExpression_(operand);
          var operator = nextToken();
          this.validateAssignmentTarget_(operand, 'postfix operation');
          operand = new PostfixExpression(this.getTreeLocation_(start), operand, operator);
        }
        return operand;
      },
      peekPostfixOperator_: function(type) {
        switch (type) {
          case PLUS_PLUS:
          case MINUS_MINUS:
            {
              var token = peekTokenNoLineTerminator();
              return token !== null;
            }
        }
        return false;
      },
      parseLeftHandSideExpression_: function() {
        var start = this.getTreeStartLocation_();
        var operand = this.parseNewExpression_();
        if (!(operand instanceof NewExpression) || operand.args !== null) {
          loop: while (true) {
            switch (peekType()) {
              case OPEN_PAREN:
                operand = this.toPrimaryExpression_(operand);
                operand = this.parseCallExpression_(start, operand);
                break;
              case OPEN_SQUARE:
                operand = this.toPrimaryExpression_(operand);
                operand = this.parseMemberLookupExpression_(start, operand);
                break;
              case PERIOD:
                operand = this.toPrimaryExpression_(operand);
                operand = this.parseMemberExpression_(start, operand);
                break;
              case NO_SUBSTITUTION_TEMPLATE:
              case TEMPLATE_HEAD:
                if (!this.options_.templateLiterals)
                  break loop;
                operand = this.toPrimaryExpression_(operand);
                if (this.options_.templateLiterals) {
                  operand = this.parseTemplateLiteral_(operand);
                }
                break;
              default:
                break loop;
            }
          }
        }
        return operand;
      },
      parseMemberExpressionNoNew_: function() {
        var start = this.getTreeStartLocation_();
        var operand;
        if (peekType() === FUNCTION) {
          operand = this.parseFunctionExpression_();
        } else {
          operand = this.parsePrimaryExpression_();
        }
        loop: while (true) {
          switch (peekType()) {
            case OPEN_SQUARE:
              operand = this.toPrimaryExpression_(operand);
              operand = this.parseMemberLookupExpression_(start, operand);
              break;
            case PERIOD:
              operand = this.toPrimaryExpression_(operand);
              operand = this.parseMemberExpression_(start, operand);
              break;
            case NO_SUBSTITUTION_TEMPLATE:
            case TEMPLATE_HEAD:
              if (!this.options_.templateLiterals)
                break loop;
              operand = this.toPrimaryExpression_(operand);
              operand = this.parseTemplateLiteral_(operand);
              break;
            default:
              break loop;
          }
        }
        return operand;
      },
      parseMemberExpression_: function(start, operand) {
        this.eat_(PERIOD);
        var name = this.eatIdName_();
        return new MemberExpression(this.getTreeLocation_(start), operand, name);
      },
      parseMemberLookupExpression_: function(start, operand) {
        this.eat_(OPEN_SQUARE);
        var member = this.parseExpression_(ALLOW_IN);
        this.eat_(CLOSE_SQUARE);
        return new MemberLookupExpression(this.getTreeLocation_(start), operand, member);
      },
      parseCallExpression_: function(start, operand) {
        var args = this.parseArguments_();
        return new CallExpression(this.getTreeLocation_(start), operand, args);
      },
      parseNewExpression_: function() {
        var operand,
            start;
        switch (peekType()) {
          case NEW:
            {
              start = this.getTreeStartLocation_();
              this.eat_(NEW);
              if (peek(SUPER)) {
                operand = this.parseSuperExpression_(true);
              } else {
                operand = this.toPrimaryExpression_(this.parseNewExpression_());
              }
              var args = null;
              if (peek(OPEN_PAREN)) {
                args = this.parseArguments_();
              }
              return new NewExpression(this.getTreeLocation_(start), operand, args);
            }
          case SUPER:
            return this.parseSuperExpression_(false);
          default:
            return this.parseMemberExpressionNoNew_();
        }
      },
      parseArguments_: function() {
        var start = this.getTreeStartLocation_();
        var args = [];
        this.eat_(OPEN_PAREN);
        if (!peek(CLOSE_PAREN)) {
          args.push(this.parseArgument_());
          while (this.eatIf_(COMMA)) {
            args.push(this.parseArgument_());
          }
        }
        this.eat_(CLOSE_PAREN);
        return new ArgumentList(this.getTreeLocation_(start), args);
      },
      parseArgument_: function() {
        if (this.peekSpread_(peekType()))
          return this.parseSpreadExpression_();
        return this.parseAssignmentExpression_(ALLOW_IN);
      },
      parseArrowFunction_: function(start, tree, asyncToken) {
        var $__3 = this;
        var formals;
        var kind = FUNCTION_STATE_ARROW;
        if (asyncToken && asyncToken.value === ASYNC) {
          kind |= FUNCTION_STATE_ASYNC;
        }
        var fs = this.pushFunctionState_(kind);
        var makeFormals = function(tree) {
          return new FormalParameterList($__3.getTreeLocation_(start), [new FormalParameter(tree.location, new BindingElement(tree.location, tree, null), null, [])]);
        };
        switch (tree.type) {
          case IDENTIFIER_EXPRESSION:
            formals = makeFormals(new BindingIdentifier(tree.location, tree.identifierToken));
            break;
          case BINDING_IDENTIFIER:
            formals = makeFormals(tree);
            break;
          case FORMAL_PARAMETER_LIST:
            formals = tree;
            break;
          default:
            formals = this.toFormalParameters_(start, tree, asyncToken);
        }
        this.eat_(ARROW);
        var body = this.parseConciseBody_(formals);
        this.popFunctionState_(fs);
        return new ArrowFunction(this.getTreeLocation_(start), asyncToken, formals, body);
      },
      parseCoverFormals_: function(start) {
        var expressions = [];
        if (!peek(CLOSE_PAREN)) {
          do {
            var type = peekType();
            if (this.peekRest_(type)) {
              expressions.push(this.parseRestParameter_());
              break;
            } else {
              expressions.push(this.parseAssignmentExpression_(ALLOW_IN));
            }
            if (this.eatIf_(COMMA))
              continue;
          } while (!peek(CLOSE_PAREN) && !isAtEnd());
        }
        this.eat_(CLOSE_PAREN);
        return new CoverFormals(this.getTreeLocation_(start), expressions);
      },
      ensureNoCoverInitializedNames_: function(tree, coverInitializedNameCount) {
        if (coverInitializedNameCount === this.coverInitializedNameCount_)
          return;
        var finder = new ValidateObjectLiteral();
        finder.visitAny(tree);
        if (finder.found) {
          var token = finder.errorToken;
          this.reportError_(token.location, ("Unexpected token " + token));
        }
      },
      toPrimaryExpression_: function(tree) {
        if (tree.type === COVER_FORMALS)
          return this.coverFormalsToParenExpression_(tree);
        return tree;
      },
      validateCoverFormalsAsParenExpression_: function(tree) {
        for (var i = 0; i < tree.expressions.length; i++) {
          if (tree.expressions[i].type === REST_PARAMETER) {
            var token = new Token(DOT_DOT_DOT, tree.expressions[i].location);
            this.reportError_(token.location, ("Unexpected token " + token));
            return;
          }
        }
      },
      coverFormalsToParenExpression_: function(tree) {
        if (tree.type === COVER_FORMALS) {
          var expressions = tree.expressions;
          if (expressions.length === 0) {
            var message = 'Unexpected token )';
            this.reportError_(tree.location, message);
          } else {
            this.validateCoverFormalsAsParenExpression_(tree);
            var expression;
            if (expressions.length > 1)
              expression = new CommaExpression(expressions[0].location, expressions);
            else
              expression = expressions[0];
            return new ParenExpression(tree.location, expression);
          }
        }
        return tree;
      },
      toFormalParameters_: function(start, tree, asyncToken) {
        resetScanner(start.offset);
        return this.parseArrowFormalParameters_(asyncToken);
      },
      parseArrowFormalParameters_: function(asyncToken) {
        if (asyncToken)
          this.eat_(IDENTIFIER);
        this.eat_(OPEN_PAREN);
        var parameters = this.parseFormalParameters_();
        this.eat_(CLOSE_PAREN);
        return parameters;
      },
      peekArrow_: function(type) {
        return type === ARROW && this.options_.arrowFunctions;
      },
      parseConciseBody_: function(params) {
        if (peek(OPEN_CURLY))
          return this.parseFunctionBody_(params);
        validateParameters(params, this.strictMode_, this.errorReporter_);
        return this.parseAssignmentExpression_(ALLOW_IN);
      },
      parseGeneratorComprehension_: function(start) {
        var comprehensionList = this.parseComprehensionList_();
        var expression = this.parseAssignmentExpression_(ALLOW_IN);
        this.eat_(CLOSE_PAREN);
        return new GeneratorComprehension(this.getTreeLocation_(start), comprehensionList, expression);
      },
      parseForBinding_: function() {
        if (this.peekPattern_(peekType()))
          return this.parseBindingPattern_();
        return this.parseBindingIdentifier_();
      },
      peekPattern_: function(type) {
        return this.options_.destructuring && (this.peekObjectPattern_(type) || this.peekArrayPattern_(type));
      },
      peekArrayPattern_: function(type) {
        return type === OPEN_SQUARE;
      },
      peekObjectPattern_: function(type) {
        return type === OPEN_CURLY;
      },
      parseBindingPattern_: function() {
        return this.parsePattern_(true);
      },
      parsePattern_: function(useBinding) {
        if (this.peekArrayPattern_(peekType()))
          return this.parseArrayPattern_(useBinding);
        return this.parseObjectPattern_(useBinding);
      },
      parseArrayBindingPattern_: function() {
        return this.parseArrayPattern_(true);
      },
      parsePatternElement_: function(useBinding) {
        return useBinding ? this.parseBindingElement_() : this.parseAssignmentElement_();
      },
      parsePatternRestElement_: function(useBinding) {
        return useBinding ? this.parseBindingRestElement_() : this.parseAssignmentRestElement_();
      },
      parseArrayPattern_: function(useBinding) {
        var start = this.getTreeStartLocation_();
        var elements = [];
        this.eat_(OPEN_SQUARE);
        while (true) {
          var type = peekType();
          if (type === COMMA) {
            elements.push(null);
          } else if (this.peekSpread_(type)) {
            elements.push(this.parsePatternRestElement_(useBinding));
            break;
          } else if (type === CLOSE_SQUARE || type === END_OF_FILE) {
            break;
          } else {
            elements.push(this.parsePatternElement_(useBinding));
          }
          type = peekType();
          if (type !== CLOSE_SQUARE) {
            this.eat_(COMMA);
          }
        }
        this.eat_(CLOSE_SQUARE);
        return new ArrayPattern(this.getTreeLocation_(start), elements);
      },
      parseBindingElementList_: function(elements) {
        this.parseElisionOpt_(elements);
        elements.push(this.parseBindingElement_());
        while (this.eatIf_(COMMA)) {
          this.parseElisionOpt_(elements);
          elements.push(this.parseBindingElement_());
        }
      },
      parseElisionOpt_: function(elements) {
        while (this.eatIf_(COMMA)) {
          elements.push(null);
        }
      },
      peekBindingElement_: function(type) {
        return this.peekBindingIdentifier_(type) || this.peekPattern_(type);
      },
      parseBindingElement_: function() {
        var start = this.getTreeStartLocation_();
        var binding = this.parseBindingElementBinding_();
        var initializer = this.parseBindingElementInitializer_(INITIALIZER_OPTIONAL);
        return new BindingElement(this.getTreeLocation_(start), binding, initializer);
      },
      parseBindingElementBinding_: function() {
        if (this.peekPattern_(peekType()))
          return this.parseBindingPattern_();
        return this.parseBindingIdentifier_();
      },
      parseBindingElementInitializer_: function(initializerRequired) {
        if (peek(EQUAL) || initializerRequired) {
          return this.parseInitializer_(ALLOW_IN);
        }
        return null;
      },
      parseBindingRestElement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(DOT_DOT_DOT);
        var identifier = this.parseBindingIdentifier_();
        return new SpreadPatternElement(this.getTreeLocation_(start), identifier);
      },
      parseObjectPattern_: function(useBinding) {
        var start = this.getTreeStartLocation_();
        var elements = [];
        this.eat_(OPEN_CURLY);
        var type;
        while ((type = peekType()) !== CLOSE_CURLY && type !== END_OF_FILE) {
          elements.push(this.parsePatternProperty_(useBinding));
          if (!this.eatIf_(COMMA))
            break;
        }
        this.eat_(CLOSE_CURLY);
        return new ObjectPattern(this.getTreeLocation_(start), elements);
      },
      parsePatternProperty_: function(useBinding) {
        var start = this.getTreeStartLocation_();
        var name = this.parsePropertyName_();
        var requireColon = name.type !== LITERAL_PROPERTY_NAME || !name.literalToken.isStrictKeyword() && name.literalToken.type !== IDENTIFIER;
        if (requireColon || peek(COLON)) {
          this.eat_(COLON);
          var element = this.parsePatternElement_(useBinding);
          return new ObjectPatternField(this.getTreeLocation_(start), name, element);
        }
        var token = name.literalToken;
        if (this.strictMode_ && token.isStrictKeyword())
          this.reportReservedIdentifier_(token);
        if (useBinding) {
          var binding = new BindingIdentifier(name.location, token);
          var initializer$__18 = this.parseInitializerOpt_(ALLOW_IN);
          return new BindingElement(this.getTreeLocation_(start), binding, initializer$__18);
        }
        var assignment = new IdentifierExpression(name.location, token);
        var initializer = this.parseInitializerOpt_(ALLOW_IN);
        return new AssignmentElement(this.getTreeLocation_(start), assignment, initializer);
      },
      parseAssignmentPattern_: function() {
        return this.parsePattern_(false);
      },
      parseArrayAssignmentPattern_: function() {
        return this.parseArrayPattern_(false);
      },
      parseAssignmentElement_: function() {
        var start = this.getTreeStartLocation_();
        var assignment = this.parseDestructuringAssignmentTarget_();
        var initializer = this.parseInitializerOpt_(ALLOW_IN);
        return new AssignmentElement(this.getTreeLocation_(start), assignment, initializer);
      },
      parseDestructuringAssignmentTarget_: function() {
        switch (peekType()) {
          case OPEN_SQUARE:
            return this.parseArrayAssignmentPattern_();
          case OPEN_CURLY:
            return this.parseObjectAssignmentPattern_();
        }
        var expression = this.parseLeftHandSideExpression_();
        expression = this.coverFormalsToParenExpression_(expression);
        this.validateAssignmentTarget_(expression, 'assignment');
        return expression;
      },
      parseAssignmentRestElement_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(DOT_DOT_DOT);
        var id = this.parseDestructuringAssignmentTarget_();
        return new SpreadPatternElement(this.getTreeLocation_(start), id);
      },
      parseObjectAssignmentPattern_: function() {
        return this.parseObjectPattern_(false);
      },
      parseAssignmentProperty_: function() {
        return this.parsePatternProperty_(false);
      },
      parseTemplateLiteral_: function(operand) {
        var start = operand ? operand.location.start : this.getTreeStartLocation_();
        var token = nextToken();
        var elements = [new TemplateLiteralPortion(token.location, token)];
        if (token.type === NO_SUBSTITUTION_TEMPLATE) {
          return new TemplateLiteralExpression(this.getTreeLocation_(start), operand, elements);
        }
        var expression = this.parseExpression_(ALLOW_IN);
        elements.push(new TemplateSubstitution(expression.location, expression));
        while (expression.type !== SYNTAX_ERROR_TREE) {
          token = nextTemplateLiteralToken();
          if (token.type === ERROR || token.type === END_OF_FILE)
            break;
          elements.push(new TemplateLiteralPortion(token.location, token));
          if (token.type === TEMPLATE_TAIL)
            break;
          expression = this.parseExpression_(ALLOW_IN);
          elements.push(new TemplateSubstitution(expression.location, expression));
        }
        return new TemplateLiteralExpression(this.getTreeLocation_(start), operand, elements);
      },
      parseTypeAnnotationOpt_: function() {
        if (this.options_.types && this.eatOpt_(COLON)) {
          return this.parseType_();
        }
        return null;
      },
      parseType_: function() {
        switch (peekType()) {
          case NEW:
            return this.parseConstructorType_();
          case OPEN_PAREN:
          case OPEN_ANGLE:
            return this.parseFunctionType_();
        }
        var start = this.getTreeStartLocation_();
        var elementType = this.parsePrimaryType_();
        return this.parseUnionTypeSuffix_(start, elementType);
      },
      parsePrimaryType_: function() {
        var start = this.getTreeStartLocation_();
        var elementType,
            token;
        switch (peekType()) {
          case VOID:
            token = nextToken();
            elementType = new PredefinedType(this.getTreeLocation_(start), token);
            break;
          case IDENTIFIER:
            switch (peekToken().value) {
              case 'any':
              case 'boolean':
              case 'number':
              case 'string':
              case 'symbol':
                token = nextToken();
                elementType = new PredefinedType(this.getTreeLocation_(start), token);
                break;
              default:
                elementType = this.parseTypeReference_();
            }
            break;
          case TYPEOF:
            elementType = this.parseTypeQuery_(start);
            break;
          case OPEN_CURLY:
            elementType = this.parseObjectType_();
            break;
          default:
            return this.parseUnexpectedToken_();
        }
        return this.parseArrayTypeSuffix_(start, elementType);
      },
      parseTypeReference_: function() {
        var start = this.getTreeStartLocation_();
        var typeName = this.parseTypeName_();
        var args = null;
        if (peek(OPEN_ANGLE)) {
          var args$__19 = this.parseTypeArguments_();
          return new TypeReference(this.getTreeLocation_(start), typeName, args$__19);
        }
        return typeName;
      },
      parseUnionTypeSuffix_: function(start, elementType) {
        if (peek(BAR)) {
          var types = [elementType];
          this.eat_(BAR);
          while (true) {
            types.push(this.parsePrimaryType_());
            if (!this.eatIf_(BAR)) {
              break;
            }
          }
          return new UnionType(this.getTreeLocation_(start), types);
        }
        return elementType;
      },
      parseArrayTypeSuffix_: function(start, elementType) {
        var token = peekTokenNoLineTerminator();
        if (token && token.type === OPEN_SQUARE) {
          this.eat_(OPEN_SQUARE);
          this.eat_(CLOSE_SQUARE);
          elementType = new ArrayType(this.getTreeLocation_(start), elementType);
          return this.parseArrayTypeSuffix_(start, elementType);
        }
        return elementType;
      },
      parseTypeArguments_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(OPEN_ANGLE);
        var args = [this.parseType_()];
        while (peek(COMMA)) {
          this.eat_(COMMA);
          args.push(this.parseType_());
        }
        var token = nextCloseAngle();
        if (token.type !== CLOSE_ANGLE) {
          return this.parseUnexpectedToken_(token);
        }
        return new TypeArguments(this.getTreeLocation_(start), args);
      },
      parseConstructorType_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(NEW);
        var typeParameters = this.parseTypeParametersOpt_();
        this.eat_(OPEN_PAREN);
        var parameterList = this.parseFormalParameters_();
        this.eat_(CLOSE_PAREN);
        this.eat_(ARROW);
        var returnType = this.parseType_();
        return new ConstructorType(this.getTreeLocation_(start), typeParameters, parameterList, returnType);
      },
      parseObjectType_: function() {
        var start = this.getTreeStartLocation_();
        var typeMembers = [];
        this.eat_(OPEN_CURLY);
        var type;
        while (this.peekTypeMember_(type = peekType())) {
          typeMembers.push(this.parseTypeMember_(type));
          if (!this.eatIf_(SEMI_COLON)) {
            break;
          }
        }
        this.eat_(CLOSE_CURLY);
        return new ObjectType(this.getTreeLocation_(start), typeMembers);
      },
      peekTypeMember_: function(type) {
        switch (type) {
          case NEW:
          case OPEN_PAREN:
          case OPEN_ANGLE:
          case OPEN_SQUARE:
          case IDENTIFIER:
          case STRING:
          case NUMBER:
            return true;
          default:
            return peekToken().isKeyword();
        }
      },
      parseTypeMember_: function(type) {
        switch (type) {
          case NEW:
            return this.parseConstructSignature_();
          case OPEN_PAREN:
          case OPEN_ANGLE:
            return this.parseCallSignature_();
          case OPEN_SQUARE:
            return this.parseIndexSignature_();
        }
        var start = this.getTreeStartLocation_();
        var propertyName = this.parseLiteralPropertyName_();
        var isOpt = this.eatIf_(QUESTION);
        type = peekType();
        if (type === OPEN_ANGLE || type === OPEN_PAREN) {
          var callSignature = this.parseCallSignature_();
          return new MethodSignature(this.getTreeLocation_(start), propertyName, isOpt, callSignature);
        }
        var typeAnnotation = this.parseTypeAnnotationOpt_();
        return new PropertySignature(this.getTreeLocation_(start), propertyName, isOpt, typeAnnotation);
      },
      parseCallSignature_: function() {
        var start = this.getTreeStartLocation_();
        var typeParameters = this.parseTypeParametersOpt_();
        this.eat_(OPEN_PAREN);
        var parameterList = this.parseFormalParameters_();
        this.eat_(CLOSE_PAREN);
        var returnType = this.parseTypeAnnotationOpt_();
        return new CallSignature(this.getTreeLocation_(start), typeParameters, parameterList, returnType);
      },
      parseConstructSignature_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(NEW);
        var typeParameters = this.parseTypeParametersOpt_();
        this.eat_(OPEN_PAREN);
        var parameterList = this.parseFormalParameters_();
        this.eat_(CLOSE_PAREN);
        var returnType = this.parseTypeAnnotationOpt_();
        return new ConstructSignature(this.getTreeLocation_(start), typeParameters, parameterList, returnType);
      },
      parseIndexSignature_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(OPEN_SQUARE);
        var id = this.eatId_();
        this.eat_(COLON);
        var typeName;
        var typeStart = this.getTreeStartLocation_();
        if (this.peekPredefinedString_('string')) {
          typeName = this.eatId_('string');
        } else {
          typeName = this.eatId_('number');
        }
        var indexType = new PredefinedType(this.getTreeLocation_(typeStart), typeName);
        this.eat_(CLOSE_SQUARE);
        this.eat_(COLON);
        var typeAnnotation = this.parseType_();
        return new IndexSignature(this.getTreeLocation_(start), id, indexType, typeAnnotation);
      },
      parseFunctionType_: function() {
        var start = this.getTreeStartLocation_();
        var typeParameters = this.parseTypeParametersOpt_();
        this.eat_(OPEN_PAREN);
        var parameterList = this.parseFormalParameters_();
        this.eat_(CLOSE_PAREN);
        this.eat_(ARROW);
        var returnType = this.parseType_();
        return new FunctionType(this.getTreeLocation_(start), typeParameters, parameterList, returnType);
      },
      parseTypeQuery_: function(start) {
        throw 'NYI';
      },
      peekTypeParameters_: function() {
        return peek(OPEN_ANGLE);
      },
      parseTypeParametersOpt_: function() {
        if (peek(OPEN_ANGLE)) {
          return this.parseTypeParameters_();
        }
        return null;
      },
      parseTypeParameters_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(OPEN_ANGLE);
        var parameters = [this.parseTypeParameter_()];
        while (peek(COMMA)) {
          this.eat_(COMMA);
          parameters.push(this.parseTypeParameter_());
        }
        this.eat_(CLOSE_ANGLE);
        return new TypeParameters(this.getTreeLocation_(start), parameters);
      },
      parseTypeParameter_: function() {
        var start = this.getTreeStartLocation_();
        var id = this.eatId_();
        var extendsType = null;
        if (this.eatIf_(EXTENDS)) {
          extendsType = this.parseType_();
        }
        return new TypeParameter(this.getTreeLocation_(start), id, extendsType);
      },
      parseNamedOrPredefinedType_: function() {
        var start = this.getTreeStartLocation_();
        switch (peekToken().value) {
          case 'any':
          case 'number':
          case 'boolean':
          case 'string':
            {
              var token = nextToken();
              return new PredefinedType(this.getTreeLocation_(start), token);
            }
          default:
            return this.parseTypeName_();
        }
      },
      parseTypeName_: function() {
        var start = this.getTreeStartLocation_();
        var id = this.eatId_();
        var typeName = new TypeName(this.getTreeLocation_(start), null, id);
        while (this.eatIf_(PERIOD)) {
          var memberName = this.eatIdName_();
          typeName = new TypeName(this.getTreeLocation_(start), typeName, memberName);
        }
        return typeName;
      },
      parseInterfaceDeclaration_: function() {
        var start = this.getTreeStartLocation_();
        this.eat_(INTERFACE);
        var name = this.eatId_();
        var typeParameters = this.parseTypeParametersOpt_();
        var extendsClause;
        if (this.eatIf_(EXTENDS)) {
          extendsClause = this.parseInterfaceExtendsClause_();
        } else {
          extendsClause = [];
        }
        var objectType = this.parseObjectType_();
        return new InterfaceDeclaration(this.getTreeLocation_(start), name, typeParameters, extendsClause, objectType);
      },
      parseInterfaceExtendsClause_: function() {
        var result = [this.parseTypeReference_()];
        while (this.eatIf_(COMMA)) {
          result.push(this.parseTypeReference_());
        }
        return result;
      },
      parseAnnotatedDeclarations_: function(parsingModuleItem) {
        this.pushAnnotations_();
        var declaration;
        var type = peekType();
        if (parsingModuleItem) {
          declaration = this.parseModuleItem_(type);
        } else {
          declaration = this.parseStatementListItem_(type);
        }
        if (this.annotations_.length > 0) {
          this.reportError_(this.annotations_[0].location, 'Unsupported annotated expression');
        }
        return declaration;
      },
      parseAnnotations_: function() {
        var annotations = [];
        while (this.eatIf_(AT)) {
          annotations.push(this.parseAnnotation_());
        }
        return annotations;
      },
      pushAnnotations_: function() {
        this.annotations_ = this.parseAnnotations_();
      },
      popAnnotations_: function() {
        var annotations = this.annotations_;
        this.annotations_ = [];
        return annotations;
      },
      parseAnnotation_: function() {
        var start = this.getTreeStartLocation_();
        var expression = this.parseMemberExpressionNoNew_();
        var args = null;
        if (peek(OPEN_PAREN))
          args = this.parseArguments_();
        return new Annotation(this.getTreeLocation_(start), expression, args);
      },
      parseTypeAliasDeclaration_: function() {
        var start = this.getTreeStartLocation_();
        this.eatId_(TYPE);
        var name = this.eatId_();
        this.eat_(EQUAL);
        var type = this.parseType_();
        this.eatPossibleImplicitSemiColon_();
        return new TypeAliasDeclaration(this.getTreeLocation_(start), name, type);
      },
      parseJsxElement_: function() {
        var token = this.eatJsx_(OPEN_ANGLE);
        return this.parseJsxElementContinuation_(token.location.start);
      },
      parseJsxElementContinuation_: function(start) {
        var name = this.parseJsxElementName_();
        var attrs = this.parseJsxAttributes_();
        var children = [];
        switch (peekJsxToken().type) {
          case SLASH:
            nextJsxToken();
            this.eat_(CLOSE_ANGLE);
            break;
          case CLOSE_ANGLE:
            {
              nextJsxTextToken();
              loop: while (true) {
                var token = nextJsxTextToken();
                switch (token.type) {
                  case STRING:
                    {
                      children.push(new JsxText(token.location, token));
                      continue;
                    }
                  case OPEN_CURLY:
                    {
                      var start$__20 = token.location.start;
                      var expression = null;
                      if (!peek(CLOSE_CURLY)) {
                        expression = this.parseAssignmentExpression_(ALLOW_IN);
                      }
                      this.eatJsx_(CLOSE_CURLY);
                      var placeHolder = new JsxPlaceholder(this.getTreeLocation_(start$__20), expression);
                      children.push(placeHolder);
                      continue;
                    }
                  case OPEN_ANGLE:
                    {
                      var start$__21 = token.location.start;
                      if (peekJsxToken().type === SLASH) {
                        nextJsxToken();
                        break loop;
                      }
                      var subElement = this.parseJsxElementContinuation_(start$__21);
                      children.push(subElement);
                      resetScanner(subElement.location.end.offset);
                      continue;
                    }
                  default:
                    return this.parseSyntaxError_('Unexpected token');
                }
              }
              var closeName = this.parseJsxElementName_();
              if (!jsxNamesEqual(name, closeName)) {
                this.reportError_(closeName.location, ("Non matching JSX closing tag. Expected " + jsxNameToString(name) + ", found " + jsxNameToString(closeName)));
              }
              this.eat_(CLOSE_ANGLE);
              break;
            }
          default:
            return this.parseSyntaxError_('Unexpected token');
        }
        var element = new JsxElement(this.getTreeLocation_(start), name, attrs, children);
        return element;
      },
      parseJsxElementName_: function() {
        var tokens = [];
        var id = this.eatJsx_(JSX_IDENTIFIER);
        var start = id.location.start;
        tokens.push(id);
        while (peekJsxToken().type === PERIOD) {
          nextJsxToken();
          var id$__22 = this.eatJsx_(JSX_IDENTIFIER);
          tokens.push(id$__22);
        }
        return new JsxElementName(this.getTreeLocation_(start), tokens);
      },
      parseJsxAttributes_: function() {
        var attributes = [];
        loop: while (true) {
          switch (peekJsxToken().type) {
            case JSX_IDENTIFIER:
              attributes.push(this.parseJsxAttribute_());
              break;
            case OPEN_CURLY:
              attributes.push(this.parseJsxSpreadAttribute_());
              break;
            default:
              break loop;
          }
        }
        return attributes;
      },
      parseJsxAttribute_: function() {
        var name = this.eatJsx_(JSX_IDENTIFIER);
        var start = name.location.start;
        var value = null;
        if (peekJsxToken().type === EQUAL) {
          this.eatJsx_(EQUAL);
          value = this.parseJsxAttributeValue_();
        }
        return new JsxAttribute(this.getTreeLocation_(start), name, value);
      },
      parseJsxAttributeValue_: function() {
        var token = peekJsxToken();
        var start = token.location.start;
        switch (token.type) {
          case STRING:
            nextJsxToken();
            return new LiteralExpression(this.getTreeLocation_(start), token);
          case OPEN_CURLY:
            {
              nextJsxToken();
              var expr = this.parseAssignmentExpression_(ALLOW_IN);
              this.eatJsx_(CLOSE_CURLY);
              return new JsxPlaceholder(this.getTreeLocation_(start), expr);
            }
          case OPEN_ANGLE:
            return this.parseJsxElement_();
        }
        return this.parseSyntaxError_('Unexpected token');
      },
      parseJsxSpreadAttribute_: function() {
        var token = peekJsxToken();
        var start = token.location.start;
        nextJsxToken();
        this.eatJsx_(DOT_DOT_DOT);
        var expr = this.parseAssignmentExpression_(ALLOW_IN);
        this.eatJsx_(CLOSE_CURLY);
        return new JsxSpreadAttribute(this.getTreeLocation_(start), expr);
      },
      eatPossibleImplicitSemiColon_: function() {
        var token = peekTokenNoLineTerminator();
        if (!token)
          return;
        switch (token.type) {
          case SEMI_COLON:
            nextToken();
            return;
          case END_OF_FILE:
          case CLOSE_CURLY:
            return;
        }
        this.reportError_(token.location, 'Semi-colon expected');
      },
      peekImplicitSemiColon_: function() {
        switch (peekType()) {
          case SEMI_COLON:
          case CLOSE_CURLY:
          case END_OF_FILE:
            return true;
        }
        var token = peekTokenNoLineTerminator();
        return token === null;
      },
      eatOpt_: function(expectedTokenType) {
        if (peek(expectedTokenType))
          return nextToken();
        return null;
      },
      eatIdOpt_: function() {
        return peek(IDENTIFIER) ? this.eatId_() : null;
      },
      eatId_: function() {
        var expected = arguments[0];
        var token = nextToken();
        if (token.type === IDENTIFIER) {
          if (expected && token.value !== expected)
            this.reportExpectedError_(token, expected);
          return token;
        }
        if (token.isStrictKeyword()) {
          if (this.strictMode_) {
            this.reportReservedIdentifier_(token);
          } else {
            return new IdentifierToken(token.location, token.type);
          }
        } else {
          this.reportExpectedError_(token, expected || 'identifier');
        }
        return token;
      },
      eatIdName_: function() {
        var t = nextToken();
        if (t.type !== IDENTIFIER) {
          if (!t.isKeyword()) {
            this.reportExpectedError_(t, 'identifier');
            return null;
          }
          return new IdentifierToken(t.location, t.type);
        }
        return t;
      },
      eat_: function(expectedTokenType) {
        return this.isExpectedToken_(nextToken(), expectedTokenType);
      },
      eatIf_: function(expectedTokenType) {
        if (peek(expectedTokenType)) {
          nextToken();
          return true;
        }
        return false;
      },
      eatJsx_: function(expectedTokenType) {
        return this.isExpectedToken_(nextJsxToken(), expectedTokenType);
      },
      isExpectedToken_: function(token, expectedTokenType) {
        if (token.type !== expectedTokenType) {
          this.reportExpectedError_(token, expectedTokenType);
        }
        return token;
      },
      reportExpectedError_: function(token, expected) {
        this.reportError_(token.location, ("Unexpected token " + token));
      },
      getTreeStartLocation_: function() {
        return peekLocation().start;
      },
      getTreeEndLocation_: function() {
        return getLastToken().location.end;
      },
      getTreeLocation_: function(start) {
        return new SourceRange(start, this.getTreeEndLocation_());
      },
      handleComment: function(range) {},
      isAtEnd: function() {
        return isAtEnd();
      },
      reportError_: function(location, message) {
        this.errorReporter_.reportError(location, message);
      },
      reportReservedIdentifier_: function(token) {
        this.reportError_(token.location, (token.type + " is a reserved identifier"));
      },
      validateAssignmentTarget_: function(tree, operation) {
        if (!tree.isPattern() && !isValidSimpleAssignmentTarget(tree, this.strictMode_)) {
          this.reportError_(tree.location, ("Invalid left-hand side expression in " + operation));
        }
      }
    }, {});
  }();
  function jsxNamesEqual(name, other) {
    if (name.names.length !== other.names.length) {
      return false;
    }
    for (var i = 0; i < name.names.length; i++) {
      if (name.names[i].value !== other.names[i].value) {
        return false;
      }
    }
    return true;
  }
  function jsxNameToString(name) {
    return name.names.join('.');
  }
  return {get Parser() {
      return Parser;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/util/SourcePosition.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/util/SourcePosition.js";
  var SourcePosition = function() {
    function SourcePosition(source, offset) {
      this.source = source;
      this.offset = offset;
      this.line_ = -1;
      this.column_ = -1;
    }
    return ($traceurRuntime.createClass)(SourcePosition, {
      get line() {
        if (this.line_ === -1)
          this.line_ = this.source.lineNumberTable.getLine(this.offset);
        return this.line_;
      },
      get column() {
        if (this.column_ === -1)
          this.column_ = this.source.lineNumberTable.getColumn(this.offset);
        return this.column_;
      },
      toString: function() {
        var name = this.source ? this.source.name : '';
        return (name + ":" + (this.line + 1) + ":" + (this.column + 1));
      }
    }, {});
  }();
  return {get SourcePosition() {
      return SourcePosition;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/LineNumberTable.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/LineNumberTable.js";
  var SourcePosition = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/SourcePosition.js", "traceur@0.0.108/src/syntax/LineNumberTable.js")).SourcePosition;
  var SourceRange = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/SourceRange.js", "traceur@0.0.108/src/syntax/LineNumberTable.js")).SourceRange;
  var isLineTerminator = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Scanner.js", "traceur@0.0.108/src/syntax/LineNumberTable.js")).isLineTerminator;
  var MAX_INT_REPRESENTATION = 9007199254740992;
  function computeLineStartOffsets(source) {
    var lineStartOffsets = [0];
    var k = 1;
    for (var index = 0; index < source.length; index++) {
      var code = source.charCodeAt(index);
      if (isLineTerminator(code)) {
        if (code === 13 && source.charCodeAt(index + 1) === 10) {
          index++;
        }
        lineStartOffsets[k++] = index + 1;
      }
    }
    lineStartOffsets[k++] = MAX_INT_REPRESENTATION;
    return lineStartOffsets;
  }
  var LineNumberTable = function() {
    function LineNumberTable(sourceFile) {
      this.sourceFile_ = sourceFile;
      this.lineStartOffsets_ = null;
      this.lastLine_ = 0;
      this.lastOffset_ = -1;
    }
    return ($traceurRuntime.createClass)(LineNumberTable, {
      ensureLineStartOffsets_: function() {
        if (!this.lineStartOffsets_) {
          this.lineStartOffsets_ = computeLineStartOffsets(this.sourceFile_.contents);
        }
      },
      getSourcePosition: function(offset) {
        return new SourcePosition(this.sourceFile_, offset);
      },
      getLine: function(offset) {
        if (offset === this.lastOffset_)
          return this.lastLine_;
        this.ensureLineStartOffsets_();
        if (offset < 0)
          return 0;
        var line;
        if (offset < this.lastOffset_) {
          for (var i = this.lastLine_; i >= 0; i--) {
            if (this.lineStartOffsets_[i] <= offset) {
              line = i;
              break;
            }
          }
        } else {
          for (var i$__1 = this.lastLine_; true; i$__1++) {
            if (this.lineStartOffsets_[i$__1] > offset) {
              line = i$__1 - 1;
              break;
            }
          }
        }
        this.lastLine_ = line;
        this.lastOffset_ = offset;
        return line;
      },
      offsetOfLine: function(line) {
        this.ensureLineStartOffsets_();
        return this.lineStartOffsets_[line];
      },
      getColumn: function(offset) {
        var line = this.getLine(offset);
        return offset - this.lineStartOffsets_[line];
      },
      getSourceRange: function(startOffset, endOffset) {
        return new SourceRange(this.getSourcePosition(startOffset), this.getSourcePosition(endOffset));
      }
    }, {});
  }();
  return {get LineNumberTable() {
      return LineNumberTable;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/SourceFile.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/SourceFile.js";
  var LineNumberTable = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./LineNumberTable.js", "traceur@0.0.108/src/syntax/SourceFile.js")).LineNumberTable;
  var SourceFile = function() {
    function SourceFile(name, contents) {
      this.name = name;
      this.contents = contents;
      this.lineNumberTable = new LineNumberTable(this);
    }
    return ($traceurRuntime.createClass)(SourceFile, {}, {});
  }();
  return {get SourceFile() {
      return SourceFile;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/PlaceholderParser.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/PlaceholderParser.js";
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/PlaceholderParser.js")),
      ARGUMENT_LIST = $__2.ARGUMENT_LIST,
      BLOCK = $__2.BLOCK,
      EXPRESSION_STATEMENT = $__2.EXPRESSION_STATEMENT,
      FUNCTION_BODY = $__2.FUNCTION_BODY,
      IDENTIFIER_EXPRESSION = $__2.IDENTIFIER_EXPRESSION;
  var IdentifierToken = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/IdentifierToken.js", "traceur@0.0.108/src/codegeneration/PlaceholderParser.js")).IdentifierToken;
  var LiteralToken = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/LiteralToken.js", "traceur@0.0.108/src/codegeneration/PlaceholderParser.js")).LiteralToken;
  var CollectingErrorReporter = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/CollectingErrorReporter.js", "traceur@0.0.108/src/codegeneration/PlaceholderParser.js")).CollectingErrorReporter;
  var Options = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../Options.js", "traceur@0.0.108/src/codegeneration/PlaceholderParser.js")).Options;
  var ParseTree = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTree.js", "traceur@0.0.108/src/codegeneration/PlaceholderParser.js")).ParseTree;
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/PlaceholderParser.js")).ParseTreeTransformer;
  var Parser = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/Parser.js", "traceur@0.0.108/src/codegeneration/PlaceholderParser.js")).Parser;
  var $__10 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/PlaceholderParser.js")),
      LiteralExpression = $__10.LiteralExpression,
      LiteralPropertyName = $__10.LiteralPropertyName,
      TypeName = $__10.TypeName;
  var SourceFile = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/SourceFile.js", "traceur@0.0.108/src/codegeneration/PlaceholderParser.js")).SourceFile;
  var IDENTIFIER = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/PlaceholderParser.js")).IDENTIFIER;
  var $__13 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/PlaceholderParser.js")),
      createArrayLiteral = $__13.createArrayLiteral,
      createBindingIdentifier = $__13.createBindingIdentifier,
      createBlock = $__13.createBlock,
      createBooleanLiteral = $__13.createBooleanLiteral,
      createCommaExpression = $__13.createCommaExpression,
      createExpressionStatement = $__13.createExpressionStatement,
      createFunctionBody = $__13.createFunctionBody,
      createIdentifierExpression = $__13.createIdentifierExpression,
      createIdentifierToken = $__13.createIdentifierToken,
      createMemberExpression = $__13.createMemberExpression,
      createNullLiteral = $__13.createNullLiteral,
      createNumberLiteral = $__13.createNumberLiteral,
      createParenExpression = $__13.createParenExpression,
      createStringLiteral = $__13.createStringLiteral,
      createVoid0 = $__13.createVoid0;
  var NOT_FOUND = {};
  function makeParseFunction(doParse) {
    var cache = new Map();
    return function(sourceLiterals) {
      for (var values = [],
          $__1 = 1; $__1 < arguments.length; $__1++)
        values[$__1 - 1] = arguments[$__1];
      return parse(sourceLiterals, values, doParse, cache);
    };
  }
  var parseExpression = makeParseFunction(function(p) {
    return p.parseExpression();
  });
  var parseStatement = makeParseFunction(function(p) {
    return p.parseStatement();
  });
  var parseModule = makeParseFunction(function(p) {
    return p.parseModule();
  });
  var parseScript = makeParseFunction(function(p) {
    return p.parseScript();
  });
  var parseStatements = makeParseFunction(function(p) {
    return p.parseStatements();
  });
  var parsePropertyDefinition = makeParseFunction(function(p) {
    return p.parsePropertyDefinition();
  });
  function parse(sourceLiterals, values, doParse, cache) {
    var tree = cache.get(sourceLiterals);
    if (!tree) {
      var source = insertPlaceholderIdentifiers(sourceLiterals);
      var errorReporter = new CollectingErrorReporter();
      var parser = getParser(source, errorReporter);
      tree = doParse(parser);
      if (errorReporter.hadError() || !tree || !parser.isAtEnd()) {
        throw new Error(("Internal error trying to parse:\n\n" + source + "\n\n" + errorReporter.errorsAsString()));
      }
      cache.set(sourceLiterals, tree);
    }
    if (!values.length)
      return tree;
    if (tree instanceof ParseTree)
      return new PlaceholderTransformer(values).transformAny(tree);
    return new PlaceholderTransformer(values).transformList(tree);
  }
  var PREFIX = '$__placeholder__';
  function insertPlaceholderIdentifiers(sourceLiterals) {
    var source = sourceLiterals[0];
    for (var i = 1; i < sourceLiterals.length; i++) {
      source += PREFIX + String(i - 1) + sourceLiterals[i];
    }
    return source;
  }
  var counter = 0;
  function getParser(source, errorReporter) {
    var file = new SourceFile(null, source);
    var options = new Options();
    options.experimental = true;
    return new Parser(file, errorReporter, options);
  }
  function convertValueToExpression(value) {
    if (value instanceof ParseTree)
      return value;
    if (value instanceof IdentifierToken)
      return createIdentifierExpression(value);
    if (value instanceof LiteralToken)
      return new LiteralExpression(value.location, value);
    if (Array.isArray(value)) {
      if (value[0] instanceof ParseTree) {
        if (value.length === 1)
          return value[0];
        if (value[0].isStatement())
          return createBlock(value);
        else
          return createParenExpression(createCommaExpression(value));
      }
      return createArrayLiteral(value.map(convertValueToExpression));
    }
    if (value === null)
      return createNullLiteral();
    if (value === undefined)
      return createVoid0();
    switch (typeof value) {
      case 'string':
        return createStringLiteral(value);
      case 'boolean':
        return createBooleanLiteral(value);
      case 'number':
        return createNumberLiteral(value);
    }
    throw new Error('Not implemented');
  }
  function convertValueToIdentifierToken(value) {
    if (value instanceof IdentifierToken)
      return value;
    return createIdentifierToken(value);
  }
  function convertValueToType(value) {
    if (value === null)
      return null;
    if (value instanceof ParseTree)
      return value;
    if (typeof value === 'string') {
      return new TypeName(null, null, convertValueToIdentifierToken(value));
    }
    if (value instanceof IdentifierToken) {
      return new TypeName(null, null, value);
    }
    throw new Error('Not implemented');
  }
  var PlaceholderTransformer = function($__super) {
    function PlaceholderTransformer(values) {
      $traceurRuntime.superConstructor(PlaceholderTransformer).call(this);
      this.values = values;
    }
    return ($traceurRuntime.createClass)(PlaceholderTransformer, {
      getValueAt: function(index) {
        return this.values[index];
      },
      getValue_: function(str) {
        if (str.indexOf(PREFIX) !== 0)
          return NOT_FOUND;
        return this.getValueAt(Number(str.slice(PREFIX.length)));
      },
      transformIdentifierExpression: function(tree) {
        var value = this.getValue_(tree.identifierToken.value);
        if (value === NOT_FOUND)
          return tree;
        return convertValueToExpression(value);
      },
      transformBindingIdentifier: function(tree) {
        var value = this.getValue_(tree.identifierToken.value);
        if (value === NOT_FOUND)
          return tree;
        return createBindingIdentifier(value);
      },
      transformExpressionStatement: function(tree) {
        if (tree.expression.type === IDENTIFIER_EXPRESSION) {
          var transformedExpression = this.transformIdentifierExpression(tree.expression);
          if (transformedExpression === tree.expression)
            return tree;
          if (transformedExpression.isStatementListItem() || transformedExpression.type === FUNCTION_BODY) {
            return transformedExpression;
          }
          return createExpressionStatement(transformedExpression);
        }
        return $traceurRuntime.superGet(this, PlaceholderTransformer.prototype, "transformExpressionStatement").call(this, tree);
      },
      transformBlock: function(tree) {
        if (tree.statements.length === 1 && tree.statements[0].type === EXPRESSION_STATEMENT) {
          var transformedStatement = this.transformExpressionStatement(tree.statements[0]);
          if (transformedStatement === tree.statements[0])
            return tree;
          if (transformedStatement.type === BLOCK)
            return transformedStatement;
        }
        return $traceurRuntime.superGet(this, PlaceholderTransformer.prototype, "transformBlock").call(this, tree);
      },
      transformFunctionBody: function(tree) {
        if (tree.statements.length === 1 && tree.statements[0].type === EXPRESSION_STATEMENT) {
          var transformedStatement = this.transformExpressionStatement(tree.statements[0]);
          if (transformedStatement.type === FUNCTION_BODY)
            return transformedStatement;
          if (transformedStatement === tree.statements[0])
            return tree;
          if (transformedStatement.type === BLOCK)
            return createFunctionBody(transformedStatement.statements);
        }
        return $traceurRuntime.superGet(this, PlaceholderTransformer.prototype, "transformFunctionBody").call(this, tree);
      },
      transformMemberExpression: function(tree) {
        var value = this.getValue_(tree.memberName.value);
        if (value === NOT_FOUND)
          return $traceurRuntime.superGet(this, PlaceholderTransformer.prototype, "transformMemberExpression").call(this, tree);
        var operand = this.transformAny(tree.operand);
        return createMemberExpression(operand, value);
      },
      transformLiteralPropertyName: function(tree) {
        if (tree.literalToken.type === IDENTIFIER) {
          var value = this.getValue_(tree.literalToken.value);
          if (value !== NOT_FOUND) {
            return new LiteralPropertyName(null, convertValueToIdentifierToken(value));
          }
        }
        return $traceurRuntime.superGet(this, PlaceholderTransformer.prototype, "transformLiteralPropertyName").call(this, tree);
      },
      transformArgumentList: function(tree) {
        if (tree.args.length === 1 && tree.args[0].type === IDENTIFIER_EXPRESSION) {
          var arg0 = this.transformAny(tree.args[0]);
          if (arg0 === tree.args[0])
            return tree;
          if (arg0.type === ARGUMENT_LIST)
            return arg0;
        }
        return $traceurRuntime.superGet(this, PlaceholderTransformer.prototype, "transformArgumentList").call(this, tree);
      },
      transformTypeName: function(tree) {
        var value = this.getValue_(tree.name.value);
        if (value === NOT_FOUND)
          return $traceurRuntime.superGet(this, PlaceholderTransformer.prototype, "transformTypeName").call(this, tree);
        var moduleName = this.transformAny(tree.moduleName);
        if (moduleName !== null) {
          return new TypeName(null, moduleName, convertValueToIdentifierToken(value));
        }
        return convertValueToType(value);
      }
    }, {}, $__super);
  }(ParseTreeTransformer);
  return {
    get parseExpression() {
      return parseExpression;
    },
    get parseStatement() {
      return parseStatement;
    },
    get parseModule() {
      return parseModule;
    },
    get parseScript() {
      return parseScript;
    },
    get parseStatements() {
      return parseStatements;
    },
    get parsePropertyDefinition() {
      return parsePropertyDefinition;
    },
    get PlaceholderTransformer() {
      return PlaceholderTransformer;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/DestructuringTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/DestructuringTransformer.js";
  var $__8 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/DestructuringTransformer.js")),
      ARRAY_LITERAL = $__8.ARRAY_LITERAL,
      ARRAY_PATTERN = $__8.ARRAY_PATTERN,
      ASSIGNMENT_ELEMENT = $__8.ASSIGNMENT_ELEMENT,
      BINDING_ELEMENT = $__8.BINDING_ELEMENT,
      BINDING_IDENTIFIER = $__8.BINDING_IDENTIFIER,
      BLOCK = $__8.BLOCK,
      CALL_EXPRESSION = $__8.CALL_EXPRESSION,
      COMPUTED_PROPERTY_NAME = $__8.COMPUTED_PROPERTY_NAME,
      IDENTIFIER_EXPRESSION = $__8.IDENTIFIER_EXPRESSION,
      LITERAL_EXPRESSION = $__8.LITERAL_EXPRESSION,
      MEMBER_EXPRESSION = $__8.MEMBER_EXPRESSION,
      MEMBER_LOOKUP_EXPRESSION = $__8.MEMBER_LOOKUP_EXPRESSION,
      OBJECT_LITERAL = $__8.OBJECT_LITERAL,
      OBJECT_PATTERN_FIELD = $__8.OBJECT_PATTERN_FIELD,
      OBJECT_PATTERN = $__8.OBJECT_PATTERN,
      PAREN_EXPRESSION = $__8.PAREN_EXPRESSION,
      VARIABLE_DECLARATION_LIST = $__8.VARIABLE_DECLARATION_LIST,
      VARIABLE_STATEMENT = $__8.VARIABLE_STATEMENT;
  var $__9 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/DestructuringTransformer.js")),
      AnonBlock = $__9.AnonBlock,
      AssignmentElement = $__9.AssignmentElement,
      BindingElement = $__9.BindingElement,
      Catch = $__9.Catch,
      ExportDeclaration = $__9.ExportDeclaration,
      ForInStatement = $__9.ForInStatement,
      ForOfStatement = $__9.ForOfStatement,
      ForOnStatement = $__9.ForOnStatement,
      VariableDeclarationList = $__9.VariableDeclarationList,
      VariableStatement = $__9.VariableStatement;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/DestructuringTransformer.js")).TempVarTransformer;
  var $__11 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/DestructuringTransformer.js")),
      EQUAL = $__11.EQUAL,
      LET = $__11.LET,
      VAR = $__11.VAR;
  var bindingsInDestructuringPattern = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../semantics/bindingsInDestructuringPattern.js", "traceur@0.0.108/src/codegeneration/DestructuringTransformer.js")).default;
  var $__13 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/DestructuringTransformer.js")),
      createAssignmentExpression = $__13.createAssignmentExpression,
      createBindingIdentifier = $__13.createBindingIdentifier,
      createBlock = $__13.createBlock,
      createCommaExpression = $__13.createCommaExpression,
      createExpressionStatement = $__13.createExpressionStatement,
      createFunctionBody = $__13.createFunctionBody,
      createIdentifierExpression = $__13.createIdentifierExpression,
      createMemberExpression = $__13.createMemberExpression,
      createMemberLookupExpression = $__13.createMemberLookupExpression,
      createParenExpression = $__13.createParenExpression,
      createVariableDeclaration = $__13.createVariableDeclaration,
      createVariableDeclarationList = $__13.createVariableDeclarationList,
      createVariableStatement = $__13.createVariableStatement;
  var parseExpression = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/DestructuringTransformer.js")).parseExpression;
  var prependStatements = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PrependStatements.js", "traceur@0.0.108/src/codegeneration/DestructuringTransformer.js")).prependStatements;
  var Desugaring = function() {
    function Desugaring(rvalue) {
      this.rvalue = rvalue;
      this.expressions = [];
      this.pendingExpressions = [];
    }
    return ($traceurRuntime.createClass)(Desugaring, {
      createIterator: function(iterId) {
        this.pendingExpressions.push(parseExpression($traceurRuntime.getTemplateObject(["", " = ", "[Symbol.iterator]()"]), iterId, this.rvalue));
      },
      createInitializer: function(expression) {
        if (this.pendingExpressions.length === 0)
          return expression;
        var expressions = this.pendingExpressions;
        this.pendingExpressions = [];
        expressions.push(expression);
        return createParenExpression(createCommaExpression(expressions));
      },
      skipHole: function(iterId) {
        this.pendingExpressions.push(parseExpression($traceurRuntime.getTemplateObject(["", ".next()"]), iterId));
      }
    }, {});
  }();
  var AssignmentExpressionDesugaring = function($__super) {
    function AssignmentExpressionDesugaring(rvalue) {
      $traceurRuntime.superConstructor(AssignmentExpressionDesugaring).call(this, rvalue);
    }
    return ($traceurRuntime.createClass)(AssignmentExpressionDesugaring, {
      assign: function(lvalue, rvalue) {
        lvalue = lvalue instanceof AssignmentElement ? lvalue.assignment : lvalue;
        rvalue = this.createInitializer(rvalue);
        this.expressions.push(createAssignmentExpression(lvalue, rvalue));
      },
      createAssignmentExpression: function(tempId, rvalue) {
        var $__6;
        var expressions = this.expressions;
        expressions.unshift(createAssignmentExpression(tempId, rvalue));
        ($__6 = expressions).push.apply($__6, $traceurRuntime.spread(this.pendingExpressions, [tempId]));
        return createParenExpression(createCommaExpression(expressions));
      }
    }, {}, $__super);
  }(Desugaring);
  var VariableDeclarationDesugaring = function($__super) {
    function VariableDeclarationDesugaring(rvalue) {
      $traceurRuntime.superConstructor(VariableDeclarationDesugaring).call(this, rvalue);
    }
    return ($traceurRuntime.createClass)(VariableDeclarationDesugaring, {
      assign: function(lvalue, rvalue) {
        var binding = lvalue instanceof BindingElement ? lvalue.binding : createBindingIdentifier(lvalue);
        rvalue = this.createInitializer(rvalue);
        this.expressions.push(createVariableDeclaration(binding, rvalue));
      },
      get declarations() {
        return this.expressions;
      }
    }, {}, $__super);
  }(Desugaring);
  var DestructuringTransformer = function($__super) {
    function DestructuringTransformer(identifierGenerator, reporter, options) {
      $traceurRuntime.superConstructor(DestructuringTransformer).call(this, identifierGenerator, reporter, options);
      this.parameterDeclarations = null;
    }
    return ($traceurRuntime.createClass)(DestructuringTransformer, {
      transformArrayPattern: function(tree) {
        throw new Error('unreachable');
      },
      transformObjectPattern: function(tree) {
        throw new Error('unreachable');
      },
      transformBinaryExpression: function(tree) {
        this.pushTempScope();
        var rv;
        if (tree.operator.type === EQUAL && tree.left.isPattern()) {
          rv = this.transformAny(this.desugarAssignment_(tree.left, tree.right));
        } else {
          rv = $traceurRuntime.superGet(this, DestructuringTransformer.prototype, "transformBinaryExpression").call(this, tree);
        }
        this.popTempScope();
        return rv;
      },
      desugarAssignment_: function(lvalue, rvalue) {
        var tempId = createIdentifierExpression(this.addTempVar());
        var desugaring = new AssignmentExpressionDesugaring(tempId);
        this.desugarPattern_(desugaring, lvalue);
        return desugaring.createAssignmentExpression(tempId, rvalue);
      },
      transformVariableDeclarationList: function(tree) {
        var $__4 = this;
        if (!hasDestructuring(tree)) {
          return $traceurRuntime.superGet(this, DestructuringTransformer.prototype, "transformVariableDeclarationList").call(this, tree);
        }
        var desugaredDeclarations = [];
        tree.declarations.forEach(function(declaration) {
          var $__6;
          if (declaration.lvalue.isPattern()) {
            ($__6 = desugaredDeclarations).push.apply($__6, $traceurRuntime.spread($__4.desugarVariableDeclaration_(declaration)));
          } else {
            desugaredDeclarations.push(declaration);
          }
        });
        var transformedTree = this.transformVariableDeclarationList(createVariableDeclarationList(tree.declarationType, desugaredDeclarations));
        return transformedTree;
      },
      transformForInStatement: function(tree) {
        return this.transformForInOrOfOrOn_(tree, $traceurRuntime.superGet(this, DestructuringTransformer.prototype, "transformForInStatement"), ForInStatement);
      },
      transformForOfStatement: function(tree) {
        return this.transformForInOrOfOrOn_(tree, $traceurRuntime.superGet(this, DestructuringTransformer.prototype, "transformForOfStatement"), ForOfStatement);
      },
      transformForOnStatement: function(tree) {
        return this.transformForInOrOfOrOn_(tree, $traceurRuntime.superGet(this, DestructuringTransformer.prototype, "transformForOnStatement"), ForOnStatement);
      },
      transformForInOrOfOrOn_: function(tree, superMethod, constr) {
        var $__6;
        if (!tree.initializer.isPattern() && (tree.initializer.type !== VARIABLE_DECLARATION_LIST || !hasDestructuring(tree.initializer))) {
          return superMethod.call(this, tree);
        }
        this.pushTempScope();
        var declarationType,
            lvalue;
        if (tree.initializer.isPattern()) {
          declarationType = null;
          lvalue = tree.initializer;
        } else {
          declarationType = tree.initializer.declarationType;
          lvalue = tree.initializer.declarations[0].lvalue;
        }
        var statements = [];
        var binding = this.desugarBinding_(lvalue, statements, declarationType);
        var initializer = createVariableDeclarationList(VAR, binding, null);
        var collection = this.transformAny(tree.collection);
        var body = this.transformAny(tree.body);
        if (body.type === BLOCK)
          ($__6 = statements).push.apply($__6, $traceurRuntime.spread(body.statements));
        else
          statements.push(body);
        body = createBlock(statements);
        this.popTempScope();
        return new constr(tree.location, initializer, collection, body);
      },
      transformAssignmentElement: function(tree) {
        throw new Error('unreachable');
      },
      transformBindingElement: function(tree) {
        if (!tree.binding.isPattern() || tree.initializer)
          return tree;
        if (this.parameterDeclarations === null) {
          this.parameterDeclarations = [];
          this.pushTempScope();
        }
        var varName = this.getTempIdentifier();
        var binding = createBindingIdentifier(varName);
        var initializer = createIdentifierExpression(varName);
        var decl = createVariableDeclaration(tree.binding, initializer);
        this.parameterDeclarations.push(decl);
        return new BindingElement(null, binding, null);
      },
      transformFunctionBody: function(tree) {
        if (this.parameterDeclarations === null)
          return $traceurRuntime.superGet(this, DestructuringTransformer.prototype, "transformFunctionBody").call(this, tree);
        var list = createVariableDeclarationList(VAR, this.parameterDeclarations);
        var statement = createVariableStatement(list);
        var statements = prependStatements(tree.statements, statement);
        var newBody = createFunctionBody(statements);
        this.parameterDeclarations = null;
        var result = $traceurRuntime.superGet(this, DestructuringTransformer.prototype, "transformFunctionBody").call(this, newBody);
        this.popTempScope();
        return result;
      },
      transformCatch: function(tree) {
        var $__6;
        if (!tree.binding.isPattern())
          return $traceurRuntime.superGet(this, DestructuringTransformer.prototype, "transformCatch").call(this, tree);
        var body = this.transformAny(tree.catchBody);
        var statements = [];
        var kind = this.options.blockBinding ? LET : VAR;
        var binding = this.desugarBinding_(tree.binding, statements, kind);
        ($__6 = statements).push.apply($__6, $traceurRuntime.spread(body.statements));
        return new Catch(tree.location, binding, createBlock(statements));
      },
      transformExportDeclaration: function(tree) {
        if (tree.declaration.type === VARIABLE_STATEMENT && hasDestructuring(tree.declaration.declarations)) {
          var names = bindingsInDestructuringPattern(tree.declaration.declarations);
          var declaration = this.transformAny(tree.declaration);
          var statements = [];
          var $__5 = declaration.declarations,
              declarations = $__5.declarations,
              declarationType = $__5.declarationType;
          for (var i = 0; i < declarations.length; i++) {
            var declaration$__7 = declarations[i];
            var statement = new VariableStatement(declaration$__7.location, new VariableDeclarationList(declaration$__7.location, declarationType, [declaration$__7]));
            if (names.has(declarations[i].lvalue.getStringValue())) {
              statement = new ExportDeclaration(statement.location, statement, []);
            }
            statements.push(statement);
          }
          return new AnonBlock(null, statements);
        }
        return $traceurRuntime.superGet(this, DestructuringTransformer.prototype, "transformExportDeclaration").call(this, tree);
      },
      desugarBinding_: function(bindingTree, statements, declarationType) {
        var varName = this.getTempIdentifier();
        var binding = createBindingIdentifier(varName);
        var idExpr = createIdentifierExpression(varName);
        var desugaring;
        if (declarationType === null)
          desugaring = new AssignmentExpressionDesugaring(idExpr);
        else
          desugaring = new VariableDeclarationDesugaring(idExpr);
        this.desugarPattern_(desugaring, bindingTree);
        if (declarationType === null) {
          statements.push(createExpressionStatement(createCommaExpression(desugaring.expressions)));
        } else {
          statements.push(createVariableStatement(this.transformVariableDeclarationList(createVariableDeclarationList(declarationType, desugaring.declarations))));
        }
        return binding;
      },
      desugarVariableDeclaration_: function(tree) {
        var tempRValueName = this.getTempIdentifier();
        var tempRValueIdent = createIdentifierExpression(tempRValueName);
        var desugaring;
        var initializer;
        switch (tree.initializer.type) {
          case ARRAY_LITERAL:
          case CALL_EXPRESSION:
          case IDENTIFIER_EXPRESSION:
          case LITERAL_EXPRESSION:
          case MEMBER_EXPRESSION:
          case MEMBER_LOOKUP_EXPRESSION:
          case OBJECT_LITERAL:
          case PAREN_EXPRESSION:
            initializer = tree.initializer;
        }
        desugaring = new VariableDeclarationDesugaring(tempRValueIdent);
        desugaring.assign(desugaring.rvalue, tree.initializer);
        var initializerFound = this.desugarPattern_(desugaring, tree.lvalue);
        if (initializerFound || desugaring.declarations.length > 2) {
          return desugaring.declarations;
        }
        if (!initializer) {
          initializer = createParenExpression(tree.initializer);
        }
        desugaring = new VariableDeclarationDesugaring(initializer);
        this.desugarPattern_(desugaring, tree.lvalue);
        return desugaring.declarations;
      },
      desugarPattern_: function(desugaring, tree) {
        var $__4 = this;
        var initializerFound = false;
        var pattern;
        switch (tree.type) {
          case ARRAY_PATTERN:
            {
              pattern = tree;
              this.pushTempScope();
              var iterId = createIdentifierExpression(this.addTempVar());
              var iterObjectId = createIdentifierExpression(this.addTempVar());
              desugaring.createIterator(iterId);
              for (var i = 0; i < pattern.elements.length; i++) {
                var lvalue = pattern.elements[i];
                if (lvalue === null) {
                  desugaring.skipHole(iterId);
                  continue;
                } else if (lvalue.isSpreadPatternElement()) {
                  desugaring.assign(lvalue.lvalue, parseExpression($traceurRuntime.getTemplateObject(["$traceurRuntime.iteratorToArray(", ")"]), iterId));
                } else {
                  if (lvalue.initializer) {
                    initializerFound = true;
                  }
                  desugaring.assign(lvalue, this.createConditionalIterExpression(iterObjectId, iterId, lvalue.initializer));
                }
              }
              this.popTempScope();
              break;
            }
          case OBJECT_PATTERN:
            {
              pattern = tree;
              var elementHelper = function(lvalue, initializer) {
                if (initializer)
                  initializerFound = true;
                var lookup = $__4.createConditionalMemberExpression(desugaring.rvalue, lvalue, initializer);
                desugaring.assign(lvalue, lookup);
              };
              pattern.fields.forEach(function(field) {
                var lookup;
                switch (field.type) {
                  case ASSIGNMENT_ELEMENT:
                    elementHelper(field.assignment, field.initializer);
                    break;
                  case BINDING_ELEMENT:
                    elementHelper(field.binding, field.initializer);
                    break;
                  case OBJECT_PATTERN_FIELD:
                    {
                      if (field.element.initializer)
                        initializerFound = true;
                      var name = field.name;
                      lookup = $__4.createConditionalMemberExpression(desugaring.rvalue, name, field.element.initializer);
                      desugaring.assign(field.element, lookup);
                      break;
                    }
                  default:
                    throw Error('unreachable');
                }
              });
              break;
            }
          case PAREN_EXPRESSION:
            return this.desugarPattern_(desugaring, tree.expression);
          default:
            throw new Error('unreachable');
        }
        if (desugaring instanceof VariableDeclarationDesugaring && desugaring.declarations.length === 0) {
          desugaring.assign(createBindingIdentifier(this.getTempIdentifier()), desugaring.rvalue);
        }
        return initializerFound;
      },
      createConditionalMemberExpression: function(rvalue, name, initializer) {
        if (name.type === COMPUTED_PROPERTY_NAME) {
          return this.createConditionalMemberLookupExpression(rvalue, name.expression, initializer);
        }
        var token;
        switch (name.type) {
          case BINDING_IDENTIFIER:
          case IDENTIFIER_EXPRESSION:
            token = name.identifierToken;
            break;
          default:
            token = name.literalToken;
        }
        if (!initializer)
          return createMemberExpression(rvalue, token);
        var tempIdent = createIdentifierExpression(this.addTempVar());
        return parseExpression($traceurRuntime.getTemplateObject(["(", " = ", ".", ") === void 0 ?\n        ", " : ", ""]), tempIdent, rvalue, token, initializer, tempIdent);
      },
      createConditionalMemberLookupExpression: function(rvalue, index, initializer) {
        if (!initializer)
          return createMemberLookupExpression(rvalue, index);
        var tempIdent = createIdentifierExpression(this.addTempVar());
        return parseExpression($traceurRuntime.getTemplateObject(["(", " = ", "[", "]) === void 0 ?\n        ", " : ", ""]), tempIdent, rvalue, index, initializer, tempIdent);
      },
      createConditionalIterExpression: function(iterObjectId, iterId, initializer) {
        var expr = parseExpression($traceurRuntime.getTemplateObject(["(", " =\n        ", ".next()).done ? void 0 : ", ".value"]), iterObjectId, iterId, iterObjectId);
        if (!initializer) {
          return expr;
        }
        var tempIdent = createIdentifierExpression(this.addTempVar());
        return parseExpression($traceurRuntime.getTemplateObject(["(", " = ", ") === void 0 ?\n        ", " : ", ""]), tempIdent, expr, initializer, tempIdent);
      }
    }, {}, $__super);
  }(TempVarTransformer);
  function hasDestructuring(tree) {
    return tree.declarations.some(function(declaration) {
      return declaration.lvalue.isPattern();
    });
  }
  return {get DestructuringTransformer() {
      return DestructuringTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/module/ModuleSymbol.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/module/ModuleSymbol.js";
  var StringMap = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../util/StringMap.js", "traceur@0.0.108/src/codegeneration/module/ModuleSymbol.js")).StringMap;
  var assert = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../util/assert.js", "traceur@0.0.108/src/codegeneration/module/ModuleSymbol.js")).assert;
  var ExportsList = function() {
    function ExportsList(normalizedName) {
      this.exports_ = new StringMap();
      if (normalizedName !== null)
        this.normalizedName = normalizedName.replace(/\\/g, '/');
      else
        this.normalizedName = null;
    }
    return ($traceurRuntime.createClass)(ExportsList, {
      addExport: function(name, tree) {
        assert(!this.exports_.has(name));
        this.exports_.set(name, tree);
      },
      getExport: function(name) {
        return this.exports_.get(name);
      },
      getExports: function() {
        return this.exports_.keysAsArray();
      },
      addExportsFromModule: function(module) {
        var $__2 = this;
        Object.getOwnPropertyNames(module).forEach(function(name) {
          $__2.addExport(name, true);
        });
      }
    }, {});
  }();
  var ModuleSymbol = function($__super) {
    function ModuleSymbol(tree, normalizedName) {
      $traceurRuntime.superConstructor(ModuleSymbol).call(this, normalizedName);
      this.tree = tree;
      this.imports_ = new StringMap();
    }
    return ($traceurRuntime.createClass)(ModuleSymbol, {
      addImport: function(name, tree) {
        assert(!this.imports_.has(name));
        this.imports_.set(name, tree);
      },
      getImport: function(name) {
        return this.imports_.get(name);
      }
    }, {}, $__super);
  }(ExportsList);
  return {
    get ExportsList() {
      return ExportsList;
    },
    get ModuleSymbol() {
      return ModuleSymbol;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/module/ModuleVisitor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/module/ModuleVisitor.js";
  var ExportsList = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ModuleSymbol.js", "traceur@0.0.108/src/codegeneration/module/ModuleVisitor.js")).ExportsList;
  var ParseTreeVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/ParseTreeVisitor.js", "traceur@0.0.108/src/codegeneration/module/ModuleVisitor.js")).ParseTreeVisitor;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/module/ModuleVisitor.js")),
      EXPORT_DECLARATION = $__3.EXPORT_DECLARATION,
      IMPORT_DECLARATION = $__3.IMPORT_DECLARATION;
  var ModuleVisitor = function($__super) {
    function ModuleVisitor(reporter, loader, moduleSymbol) {
      $traceurRuntime.superConstructor(ModuleVisitor).call(this);
      this.reporter = reporter;
      this.loader_ = loader;
      this.moduleSymbol = moduleSymbol;
    }
    return ($traceurRuntime.createClass)(ModuleVisitor, {
      getExportsListForModuleSpecifier: function(name) {
        var referrer = this.moduleSymbol.normalizedName;
        return this.loader_.getExportsListForModuleSpecifier(name, referrer);
      },
      visitFunctionDeclaration: function(tree) {},
      visitFunctionExpression: function(tree) {},
      visitFunctionBody: function(tree) {},
      visitBlock: function(tree) {},
      visitClassDeclaration: function(tree) {},
      visitClassExpression: function(tree) {},
      visitModuleElement_: function(element) {
        switch (element.type) {
          case EXPORT_DECLARATION:
          case IMPORT_DECLARATION:
            this.visitAny(element);
        }
      },
      visitScript: function(tree) {
        tree.scriptItemList.forEach(this.visitModuleElement_, this);
      },
      visitModule: function(tree) {
        tree.scriptItemList.forEach(this.visitModuleElement_, this);
      },
      reportError: function(tree, message) {
        this.reporter.reportError(tree.location, message);
      }
    }, {}, $__super);
  }(ParseTreeVisitor);
  return {get ModuleVisitor() {
      return ModuleVisitor;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/module/ExportVisitor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/module/ExportVisitor.js";
  var ModuleVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ModuleVisitor.js", "traceur@0.0.108/src/codegeneration/module/ExportVisitor.js")).ModuleVisitor;
  var assert = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../util/assert.js", "traceur@0.0.108/src/codegeneration/module/ExportVisitor.js")).assert;
  var ExportVisitor = function($__super) {
    function ExportVisitor(reporter, loader, moduleSymbol) {
      $traceurRuntime.superConstructor(ExportVisitor).call(this, reporter, loader, moduleSymbol);
      this.inExport_ = false;
      this.moduleSpecifier = null;
    }
    return ($traceurRuntime.createClass)(ExportVisitor, {
      addExport_: function(name, tree) {
        assert(typeof name === 'string');
        if (this.inExport_)
          this.addExport(name, tree);
      },
      addExport: function(name, tree) {
        var moduleSymbol = this.moduleSymbol;
        var existingExport = moduleSymbol.getExport(name);
        if (existingExport) {
          this.reportError(tree, ("Duplicate export. '" + name + "' was previously ") + ("exported at " + existingExport.location.start));
        } else {
          moduleSymbol.addExport(name, tree);
        }
      },
      visitClassDeclaration: function(tree) {
        this.addExport_(tree.name.identifierToken.value, tree);
      },
      visitExportDeclaration: function(tree) {
        this.inExport_ = true;
        this.visitAny(tree.declaration);
        this.inExport_ = false;
      },
      visitNamedExport: function(tree) {
        this.moduleSpecifier = tree.moduleSpecifier;
        this.visitAny(tree.exportClause);
        this.moduleSpecifier = null;
      },
      visitExportDefault: function(tree) {
        this.addExport_('default', tree);
      },
      visitExportSpecifier: function(tree) {
        this.addExport_((tree.rhs || tree.lhs).value, tree);
      },
      visitExportStar: function(tree) {
        var $__1 = this;
        var name = this.moduleSpecifier.token.processedValue;
        var exportList = this.getExportsListForModuleSpecifier(name);
        if (exportList) {
          exportList.getExports().forEach(function(name) {
            return $__1.addExport(name, tree);
          });
        }
      },
      visitNameSpaceExport: function(tree) {
        this.addExport_(tree.name.value, tree);
      },
      visitForwardDefaultExport: function(tree) {
        this.addExport_(tree.name.value, tree);
      },
      visitFunctionDeclaration: function(tree) {
        this.addExport_(tree.name.getStringValue(), tree);
      },
      visitVariableDeclaration: function(tree) {
        this.visitAny(tree.lvalue);
      },
      visitBindingIdentifier: function(tree) {
        this.addExport_(tree.getStringValue(), tree);
      },
      visitBindingElement: function(tree) {
        this.visitAny(tree.binding);
      },
      visitTypeAliasDeclaration: function(tree) {
        this.addExport(tree.name.value, tree);
      }
    }, {}, $__super);
  }(ModuleVisitor);
  return {get ExportVisitor() {
      return ExportVisitor;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/module/DirectExportVisitor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/module/DirectExportVisitor.js";
  var ExportVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ExportVisitor.js", "traceur@0.0.108/src/codegeneration/module/DirectExportVisitor.js")).ExportVisitor;
  var DirectExportVisitor = function($__super) {
    function DirectExportVisitor() {
      $traceurRuntime.superConstructor(DirectExportVisitor).call(this, null, null, null);
      this.namedExports = [];
      this.starExports = [];
    }
    return ($traceurRuntime.createClass)(DirectExportVisitor, {
      addExport: function(name, tree) {
        this.namedExports.push({
          name: name,
          tree: tree,
          moduleSpecifier: this.moduleSpecifier
        });
      },
      visitExportStar: function(tree) {
        this.starExports.push(this.moduleSpecifier);
      },
      hasExports: function() {
        return this.namedExports.length !== 0 || this.starExports.length !== 0;
      }
    }, {}, $__super);
  }(ExportVisitor);
  return {get DirectExportVisitor() {
      return DirectExportVisitor;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ImportSimplifyingTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ImportSimplifyingTransformer.js";
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/ImportSimplifyingTransformer.js")),
      AnonBlock = $__5.AnonBlock,
      ImportDeclaration = $__5.ImportDeclaration,
      ImportSpecifier = $__5.ImportSpecifier,
      ImportSpecifierSet = $__5.ImportSpecifierSet,
      Module = $__5.Module;
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/ImportSimplifyingTransformer.js")).ParseTreeTransformer;
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/ImportSimplifyingTransformer.js")),
      ANON_BLOCK = $__7.ANON_BLOCK,
      IMPORT_CLAUSE_PAIR = $__7.IMPORT_CLAUSE_PAIR,
      IMPORT_DECLARATION = $__7.IMPORT_DECLARATION,
      IMPORT_SPECIFIER_SET = $__7.IMPORT_SPECIFIER_SET,
      IMPORTED_BINDING = $__7.IMPORTED_BINDING,
      NAME_SPACE_IMPORT = $__7.NAME_SPACE_IMPORT;
  var createIdentifierToken = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/ImportSimplifyingTransformer.js")).createIdentifierToken;
  var ImportSimplifyingTransformer = function($__super) {
    function ImportSimplifyingTransformer() {
      $traceurRuntime.superConstructor(ImportSimplifyingTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(ImportSimplifyingTransformer, {
      transformModule: function(tree) {
        var $__2;
        var statements = [];
        for (var i = 0; i < tree.scriptItemList.length; i++) {
          var item = tree.scriptItemList[i];
          switch (item.type) {
            case IMPORT_DECLARATION:
              {
                var transformed = this.transformAny(item);
                if (transformed.type === ANON_BLOCK) {
                  ($__2 = statements).push.apply($__2, $traceurRuntime.spread(transformed.statements));
                } else {
                  statements.push(transformed);
                }
                break;
              }
            default:
              statements.push(item);
          }
        }
        return new Module(tree.location, statements, tree.moduleName);
      },
      transformImportDeclaration: function(tree) {
        var importClause = tree.importClause;
        if (importClause === null) {
          var set = new ImportSpecifierSet(null, []);
          return new ImportDeclaration(tree.location, set, tree.moduleSpecifier);
        }
        if (importClause.type === NAME_SPACE_IMPORT) {
          return tree;
        }
        if (importClause.type === IMPORTED_BINDING) {
          var specifier = this.transformAny(importClause);
          var set$__3 = new ImportSpecifierSet(null, [specifier]);
          return new ImportDeclaration(tree.location, set$__3, tree.moduleSpecifier);
        }
        if (importClause.type === IMPORT_CLAUSE_PAIR) {
          var $__1 = importClause,
              first = $__1.first,
              second = $__1.second;
          if (second.type === IMPORT_SPECIFIER_SET) {
            var defaultSpecifier = this.transformAny(first);
            var specifiers = $traceurRuntime.spread([defaultSpecifier], second.specifiers);
            var set$__4 = new ImportSpecifierSet(first.location, specifiers);
            return new ImportDeclaration(tree.location, set$__4, tree.moduleSpecifier);
          }
          var firstImport = new ImportDeclaration(tree.location, first, tree.moduleSpecifier);
          firstImport = this.transformAny(firstImport);
          var secondImport = new ImportDeclaration(tree.location, second, tree.moduleSpecifier);
          return new AnonBlock(null, [firstImport, secondImport]);
        }
        return $traceurRuntime.superGet(this, ImportSimplifyingTransformer.prototype, "transformImportDeclaration").call(this, tree);
      },
      transformImportSpecifier: function(tree) {
        return tree;
      },
      transformImportedBinding: function(tree) {
        var name = createIdentifierToken('default');
        return new ImportSpecifier(tree.location, tree, name);
      }
    }, {}, $__super);
  }(ParseTreeTransformer);
  return {get ImportSimplifyingTransformer() {
      return ImportSimplifyingTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/util/url.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/util/url.js";
  var canonicalizeUrl = $traceurRuntime.canonicalizeUrl;
  var isAbsolute = $traceurRuntime.isAbsolute;
  var removeDotSegments = $traceurRuntime.removeDotSegments;
  var resolveUrl = $traceurRuntime.resolveUrl;
  return {
    get canonicalizeUrl() {
      return canonicalizeUrl;
    },
    get isAbsolute() {
      return isAbsolute;
    },
    get removeDotSegments() {
      return removeDotSegments;
    },
    get resolveUrl() {
      return resolveUrl;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ModuleTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ModuleTransformer.js";
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/ModuleTransformer.js")),
      AnonBlock = $__7.AnonBlock,
      BindingElement = $__7.BindingElement,
      EmptyStatement = $__7.EmptyStatement,
      LiteralPropertyName = $__7.LiteralPropertyName,
      Module = $__7.Module,
      ObjectPattern = $__7.ObjectPattern,
      ObjectPatternField = $__7.ObjectPatternField,
      Script = $__7.Script;
  var DestructuringTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./DestructuringTransformer.js", "traceur@0.0.108/src/codegeneration/ModuleTransformer.js")).DestructuringTransformer;
  var DirectExportVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./module/DirectExportVisitor.js", "traceur@0.0.108/src/codegeneration/ModuleTransformer.js")).DirectExportVisitor;
  var ImportSimplifyingTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ImportSimplifyingTransformer.js", "traceur@0.0.108/src/codegeneration/ModuleTransformer.js")).ImportSimplifyingTransformer;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/ModuleTransformer.js")).TempVarTransformer;
  var $__12 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/ModuleTransformer.js")),
      CLASS_DECLARATION = $__12.CLASS_DECLARATION,
      EXPORT_DEFAULT = $__12.EXPORT_DEFAULT,
      EXPORT_SPECIFIER = $__12.EXPORT_SPECIFIER,
      FORWARD_DEFAULT_EXPORT = $__12.FORWARD_DEFAULT_EXPORT,
      FUNCTION_DECLARATION = $__12.FUNCTION_DECLARATION,
      IMPORT_SPECIFIER_SET = $__12.IMPORT_SPECIFIER_SET,
      IMPORT_TYPE_CLAUSE = $__12.IMPORT_TYPE_CLAUSE,
      NAME_SPACE_EXPORT = $__12.NAME_SPACE_EXPORT,
      TYPE_ALIAS_DECLARATION = $__12.TYPE_ALIAS_DECLARATION;
  var VAR = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/ModuleTransformer.js")).VAR;
  var assert = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/assert.js", "traceur@0.0.108/src/codegeneration/ModuleTransformer.js")).assert;
  var $__15 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/url.js", "traceur@0.0.108/src/codegeneration/ModuleTransformer.js")),
      resolveUrl = $__15.resolveUrl,
      canonicalizeUrl = $__15.canonicalizeUrl;
  var $__16 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/ModuleTransformer.js")),
      createArgumentList = $__16.createArgumentList,
      createExpressionStatement = $__16.createExpressionStatement,
      createIdentifierExpression = $__16.createIdentifierExpression,
      createIdentifierToken = $__16.createIdentifierToken,
      createMemberExpression = $__16.createMemberExpression,
      createObjectLiteral = $__16.createObjectLiteral,
      createUseStrictDirective = $__16.createUseStrictDirective,
      createVariableStatement = $__16.createVariableStatement;
  var $__17 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/ModuleTransformer.js")),
      parseExpression = $__17.parseExpression,
      parsePropertyDefinition = $__17.parsePropertyDefinition,
      parseStatement = $__17.parseStatement,
      parseStatements = $__17.parseStatements;
  function removeUseStrictDirectives(tree) {
    var result = tree.scriptItemList.filter(function(tree) {
      return !tree.isUseStrictDirective();
    });
    return new Module(tree.location, result, tree.moduleName);
  }
  var DestructImportVarStatement = function($__super) {
    function DestructImportVarStatement() {
      $traceurRuntime.superConstructor(DestructImportVarStatement).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(DestructImportVarStatement, {createGuardedExpression: function(tree) {
        return tree;
      }}, {}, $__super);
  }(DestructuringTransformer);
  var ModuleTransformer = function($__super) {
    function ModuleTransformer(identifierGenerator, reporter, options) {
      $traceurRuntime.superConstructor(ModuleTransformer).call(this, identifierGenerator, reporter, options);
      this.exportVisitor_ = new DirectExportVisitor();
      this.importSimplifier_ = new ImportSimplifyingTransformer();
      this.moduleName = null;
    }
    return ($traceurRuntime.createClass)(ModuleTransformer, {
      getTempVarNameForModuleName: function(moduleName) {
        return '$__' + moduleName.replace(/[^a-zA-Z0-9$]/g, function(c) {
          return '_' + String(c.charCodeAt(0)) + '_';
        }) + '__';
      },
      getModuleName: function(tree) {
        return tree.moduleName;
      },
      getTempVarNameForModuleSpecifier: function(moduleSpecifier) {
        var name = moduleSpecifier.token.processedValue;
        if (name[0] === '.' && this.moduleName) {
          name = resolveUrl(this.moduleName, name);
        } else {
          name = canonicalizeUrl(name);
        }
        return this.getTempVarNameForModuleName(name);
      },
      transformScript: function(tree) {
        this.moduleName = tree.moduleName;
        return $traceurRuntime.superGet(this, ModuleTransformer.prototype, "transformScript").call(this, tree);
      },
      transformModule: function(tree) {
        tree = removeUseStrictDirectives(tree);
        tree = this.importSimplifier_.transformModule(tree);
        this.moduleName = this.getModuleName(tree);
        this.pushTempScope();
        var statements = this.transformList(tree.scriptItemList);
        statements = this.appendExportStatement(statements);
        this.popTempScope();
        statements = this.wrapModule(this.moduleProlog().concat(statements));
        return new Script(tree.location, statements, null);
      },
      moduleProlog: function() {
        var statements = [createUseStrictDirective()];
        if (this.moduleName) {
          statements.push(parseStatement($traceurRuntime.getTemplateObject(["var __moduleName = ", ";"]), this.moduleName));
        }
        return statements;
      },
      wrapModule: function(statements) {
        var functionExpression;
        if (this.options.transformOptions.require) {
          functionExpression = parseExpression($traceurRuntime.getTemplateObject(["function(require) {\n        ", "\n      }"]), statements);
        } else {
          functionExpression = parseExpression($traceurRuntime.getTemplateObject(["function() {\n        ", "\n      }"]), statements);
        }
        if (this.moduleName === null) {
          return parseStatements($traceurRuntime.getTemplateObject(["$traceurRuntime.ModuleStore.getAnonymousModule(\n              ", ");"]), functionExpression);
        }
        return parseStatements($traceurRuntime.getTemplateObject(["$traceurRuntime.registerModule(", ", [], ", ");"]), this.moduleName, functionExpression);
      },
      getGetterExport: function($__3) {
        var $__4 = $__3,
            name = $__4.name,
            tree = $__4.tree,
            moduleSpecifier = $__4.moduleSpecifier;
        var returnExpression;
        switch (tree.type) {
          case EXPORT_DEFAULT:
            returnExpression = createIdentifierExpression('$__default');
            break;
          case EXPORT_SPECIFIER:
            if (moduleSpecifier) {
              var idName = this.getTempVarNameForModuleSpecifier(moduleSpecifier);
              returnExpression = createMemberExpression(idName, tree.lhs);
            } else {
              returnExpression = createIdentifierExpression(tree.lhs);
            }
            break;
          case NAME_SPACE_EXPORT:
            {
              var idName$__5 = this.getTempVarNameForModuleSpecifier(moduleSpecifier);
              returnExpression = createIdentifierExpression(idName$__5);
              break;
            }
          case FORWARD_DEFAULT_EXPORT:
            {
              var idName$__6 = this.getTempVarNameForModuleSpecifier(moduleSpecifier);
              returnExpression = createMemberExpression(idName$__6, 'default');
              break;
            }
          default:
            returnExpression = createIdentifierExpression(name);
            break;
        }
        return parsePropertyDefinition($traceurRuntime.getTemplateObject(["get ", "() { return ", "; }"]), name, returnExpression);
      },
      getExportProperties: function() {
        var $__2 = this;
        return this.exportVisitor_.namedExports.filter(function(exp) {
          return exp.tree.type !== TYPE_ALIAS_DECLARATION;
        }).map(function(exp) {
          return $__2.getGetterExport(exp);
        }).concat(this.exportVisitor_.namedExports.map(function(exp) {
          return $__2.getSetterExport(exp);
        })).filter(function(e) {
          return e;
        });
      },
      getSetterExport: function($__3) {
        var $__4 = $__3,
            name = $__4.name,
            tree = $__4.tree,
            moduleSpecifier = $__4.moduleSpecifier;
        return null;
      },
      getExportObject: function() {
        var $__2 = this;
        var exportObject = createObjectLiteral(this.getExportProperties());
        if (this.exportVisitor_.starExports.length) {
          var starExports = this.exportVisitor_.starExports;
          var starIdents = starExports.map(function(moduleSpecifier) {
            return createIdentifierExpression($__2.getTempVarNameForModuleSpecifier(moduleSpecifier));
          });
          var args = createArgumentList($traceurRuntime.spread([exportObject], starIdents));
          return parseExpression($traceurRuntime.getTemplateObject(["$traceurRuntime.exportStar(", ")"]), args);
        }
        return exportObject;
      },
      appendExportStatement: function(statements) {
        var exportObject = this.getExportObject();
        statements.push(parseStatement($traceurRuntime.getTemplateObject(["return ", ""]), exportObject));
        return statements;
      },
      hasExports: function() {
        return this.exportVisitor_.hasExports();
      },
      hasStarExports: function() {
        return this.exportVisitor_.starExports.length > 0;
      },
      transformExportDeclaration: function(tree) {
        this.exportVisitor_.visitAny(tree);
        return this.transformAny(tree.declaration);
      },
      transformExportDefault: function(tree) {
        switch (tree.expression.type) {
          case CLASS_DECLARATION:
          case FUNCTION_DECLARATION:
            {
              var nameBinding = tree.expression.name;
              var name = createIdentifierExpression(nameBinding.identifierToken);
              return new AnonBlock(null, [tree.expression, parseStatement($traceurRuntime.getTemplateObject(["var $__default = ", ""]), name)]);
            }
        }
        return parseStatement($traceurRuntime.getTemplateObject(["var $__default = ", ""]), tree.expression);
      },
      transformNamedExport: function(tree) {
        var moduleSpecifier = tree.moduleSpecifier;
        if (moduleSpecifier) {
          var expression = this.transformAny(moduleSpecifier);
          var idName = this.getTempVarNameForModuleSpecifier(moduleSpecifier);
          return createVariableStatement(VAR, idName, expression);
        }
        return new AnonBlock(null, []);
      },
      transformModuleSpecifier: function(tree) {
        assert(this.moduleName);
        var name = tree.token.processedValue;
        return parseExpression($traceurRuntime.getTemplateObject(["$traceurRuntime.getModule(\n      $traceurRuntime.normalizeModuleName(", ", ", "));"]), name, this.moduleName);
      },
      transformImportDeclaration: function(tree) {
        if (tree.importClause.type === IMPORT_TYPE_CLAUSE) {
          return new AnonBlock(null, []);
        }
        if (tree.importClause.type === IMPORT_SPECIFIER_SET && tree.importClause.specifiers.length === 0) {
          return createExpressionStatement(this.transformAny(tree.moduleSpecifier));
        }
        var binding = this.transformAny(tree.importClause);
        var initializer = this.transformAny(tree.moduleSpecifier);
        var varStatement = createVariableStatement(VAR, binding, initializer);
        if (this.options.transformOptions.destructuring || !this.options.parseOptions.destructuring) {
          var destructuringTransformer = new DestructImportVarStatement(this.identifierGenerator, this.reporter, this.options);
          varStatement = varStatement.transform(destructuringTransformer);
        }
        return varStatement;
      },
      transformImportSpecifierSet: function(tree) {
        var fields = this.transformList(tree.specifiers);
        return new ObjectPattern(null, fields);
      },
      transformNameSpaceImport: function(tree) {
        return tree.binding.binding;
      },
      transformImportSpecifier: function(tree) {
        var binding = tree.binding.binding;
        var bindingElement = new BindingElement(binding.location, binding, null);
        if (tree.name) {
          var name = new LiteralPropertyName(tree.name.location, tree.name);
          return new ObjectPatternField(tree.location, name, bindingElement);
        }
        return bindingElement;
      }
    }, {}, $__super);
  }(TempVarTransformer);
  return {get ModuleTransformer() {
      return ModuleTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/globalThis.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/globalThis.js";
  var parseExpression = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/globalThis.js")).parseExpression;
  var expr;
  function globalThis() {
    if (!expr)
      expr = parseExpression($traceurRuntime.getTemplateObject(["Reflect.global"]));
    return expr;
  }
  var $__default = globalThis;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/FindInFunctionScope.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/FindInFunctionScope.js";
  var FindVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FindVisitor.js", "traceur@0.0.108/src/codegeneration/FindInFunctionScope.js")).FindVisitor;
  var FindInFunctionScope = function($__super) {
    function FindInFunctionScope() {
      $traceurRuntime.superConstructor(FindInFunctionScope).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(FindInFunctionScope, {
      visitFunctionDeclaration: function(tree) {
        this.visitList(tree.annotations);
      },
      visitFunctionExpression: function(tree) {
        this.visitList(tree.annotations);
      },
      visitSetAccessor: function(tree) {
        this.visitAny(tree.name);
        this.visitList(tree.annotations);
      },
      visitGetAccessor: function(tree) {
        this.visitAny(tree.name);
        this.visitList(tree.annotations);
      },
      visitMethod: function(tree) {
        this.visitAny(tree.name);
        this.visitList(tree.annotations);
      }
    }, {}, $__super);
  }(FindVisitor);
  return {get FindInFunctionScope() {
      return FindInFunctionScope;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/scopeContainsThis.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/scopeContainsThis.js";
  var FindInFunctionScope = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FindInFunctionScope.js", "traceur@0.0.108/src/codegeneration/scopeContainsThis.js")).FindInFunctionScope;
  var FindThis = function($__super) {
    function FindThis() {
      $traceurRuntime.superConstructor(FindThis).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(FindThis, {visitThisExpression: function(tree) {
        this.found = true;
      }}, {}, $__super);
  }(FindInFunctionScope);
  function scopeContainsThis(tree) {
    var visitor = new FindThis();
    visitor.visitAny(tree);
    return visitor.found;
  }
  var $__default = scopeContainsThis;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/AmdTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/AmdTransformer.js";
  var ModuleTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ModuleTransformer.js", "traceur@0.0.108/src/codegeneration/AmdTransformer.js")).ModuleTransformer;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/AmdTransformer.js")),
      createIdentifierExpression = $__3.createIdentifierExpression,
      createFormalParameter = $__3.createFormalParameter,
      createStringLiteralToken = $__3.createStringLiteralToken;
  var globalThis = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./globalThis.js", "traceur@0.0.108/src/codegeneration/AmdTransformer.js")).default;
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/AmdTransformer.js")),
      parseExpression = $__5.parseExpression,
      parseStatement = $__5.parseStatement,
      parseStatements = $__5.parseStatements,
      parsePropertyDefinition = $__5.parsePropertyDefinition;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/AmdTransformer.js")),
      FormalParameterList = $__6.FormalParameterList,
      FunctionBody = $__6.FunctionBody,
      FunctionExpression = $__6.FunctionExpression;
  var scopeContainsThis = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./scopeContainsThis.js", "traceur@0.0.108/src/codegeneration/AmdTransformer.js")).default;
  var AmdTransformer = function($__super) {
    function AmdTransformer(identifierGenerator, reporter) {
      var options = arguments[2];
      $traceurRuntime.superConstructor(AmdTransformer).call(this, identifierGenerator, reporter, options);
      this.dependencies = [];
      this.anonymousModule = options && !options.bundle && options.moduleName !== true;
    }
    return ($traceurRuntime.createClass)(AmdTransformer, {
      getModuleName: function(tree) {
        if (this.anonymousModule)
          return null;
        return tree.moduleName;
      },
      getExportProperties: function() {
        var properties = $traceurRuntime.superGet(this, AmdTransformer.prototype, "getExportProperties").call(this);
        if (this.exportVisitor_.hasExports())
          properties.push(parsePropertyDefinition($traceurRuntime.getTemplateObject(["__esModule: true"])));
        return properties;
      },
      moduleProlog: function() {
        var locals = this.dependencies.map(function(dep) {
          var local = createIdentifierExpression(dep.local);
          return parseStatement($traceurRuntime.getTemplateObject(["if (!", " || !", ".__esModule)\n            ", " = {default: ", "}"]), local, local, local, local);
        });
        return $traceurRuntime.superGet(this, AmdTransformer.prototype, "moduleProlog").call(this).concat(locals);
      },
      wrapModule: function(statements) {
        var depPaths = this.dependencies.map(function(dep) {
          return dep.path;
        });
        var formals = this.dependencies.map(function(dep) {
          return createFormalParameter(dep.local);
        });
        var hasTopLevelThis = statements.some(scopeContainsThis);
        var parameterList = new FormalParameterList(null, formals);
        var body = new FunctionBody(null, statements);
        var func = new FunctionExpression(null, null, null, parameterList, null, [], body);
        if (hasTopLevelThis)
          func = parseExpression($traceurRuntime.getTemplateObject(["", ".bind(", ")"]), func, globalThis());
        if (this.moduleName) {
          return parseStatements($traceurRuntime.getTemplateObject(["define(", ", ", ", ", ");"]), this.moduleName, depPaths, func);
        } else {
          return parseStatements($traceurRuntime.getTemplateObject(["define(", ", ", ");"]), depPaths, func);
        }
      },
      transformModuleSpecifier: function(tree) {
        var localName = this.getTempIdentifier();
        var value = tree.token.processedValue;
        var stringLiteral = createStringLiteralToken(value.replace(/\.js$/, ''));
        this.dependencies.push({
          path: stringLiteral,
          local: localName
        });
        return createIdentifierExpression(localName);
      }
    }, {}, $__super);
  }(ModuleTransformer);
  return {get AmdTransformer() {
      return AmdTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/staticsemantics/PropName.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/staticsemantics/PropName.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/staticsemantics/PropName.js")),
      COMPUTED_PROPERTY_NAME = $__0.COMPUTED_PROPERTY_NAME,
      GET_ACCESSOR = $__0.GET_ACCESSOR,
      LITERAL_PROPERTY_NAME = $__0.LITERAL_PROPERTY_NAME,
      METHOD = $__0.METHOD,
      PROPERTY_NAME_ASSIGNMENT = $__0.PROPERTY_NAME_ASSIGNMENT,
      PROPERTY_NAME_SHORTHAND = $__0.PROPERTY_NAME_SHORTHAND,
      SET_ACCESSOR = $__0.SET_ACCESSOR;
  var IDENTIFIER = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/staticsemantics/PropName.js")).IDENTIFIER;
  function propName(tree) {
    switch (tree.type) {
      case LITERAL_PROPERTY_NAME:
        {
          var token = tree.literalToken;
          if (token.isKeyword() || token.type === IDENTIFIER)
            return token.toString();
          return String(tree.literalToken.processedValue);
        }
      case COMPUTED_PROPERTY_NAME:
        return '';
      case PROPERTY_NAME_SHORTHAND:
        return tree.name.toString();
      case METHOD:
      case PROPERTY_NAME_ASSIGNMENT:
      case GET_ACCESSOR:
      case SET_ACCESSOR:
        return propName(tree.name);
    }
  }
  return {get propName() {
      return propName;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/AnnotationsTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/AnnotationsTransformer.js";
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/AnnotationsTransformer.js")).ParseTreeTransformer;
  var CONSTRUCTOR = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/AnnotationsTransformer.js")).CONSTRUCTOR;
  var STRING = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/AnnotationsTransformer.js")).STRING;
  var $__8 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/AnnotationsTransformer.js")),
      AnonBlock = $__8.AnonBlock,
      ClassDeclaration = $__8.ClassDeclaration,
      ExportDeclaration = $__8.ExportDeclaration,
      FormalParameter = $__8.FormalParameter,
      FunctionDeclaration = $__8.FunctionDeclaration,
      GetAccessor = $__8.GetAccessor,
      LiteralExpression = $__8.LiteralExpression,
      Method = $__8.Method,
      SetAccessor = $__8.SetAccessor;
  var propName = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../staticsemantics/PropName.js", "traceur@0.0.108/src/codegeneration/AnnotationsTransformer.js")).propName;
  var $__10 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/AnnotationsTransformer.js")),
      createArgumentList = $__10.createArgumentList,
      createArrayLiteral = $__10.createArrayLiteral,
      createAssignmentStatement = $__10.createAssignmentStatement,
      createIdentifierExpression = $__10.createIdentifierExpression,
      createMemberExpression = $__10.createMemberExpression,
      createNewExpression = $__10.createNewExpression,
      createStringLiteralToken = $__10.createStringLiteralToken;
  var $__11 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/AnnotationsTransformer.js")),
      parseExpression = $__11.parseExpression,
      parseStatement = $__11.parseStatement;
  var AnnotationsScope = function() {
    function AnnotationsScope() {
      this.className = null;
      this.isExport = false;
      this.constructorParameters = [];
      this.annotations = [];
      this.metadata = [];
    }
    return ($traceurRuntime.createClass)(AnnotationsScope, {get inClassScope() {
        return this.className !== null;
      }}, {});
  }();
  var AnnotationsTransformer = function($__super) {
    function AnnotationsTransformer() {
      $traceurRuntime.superConstructor(AnnotationsTransformer).call(this);
      this.stack_ = [new AnnotationsScope()];
    }
    return ($traceurRuntime.createClass)(AnnotationsTransformer, {
      transformExportDeclaration: function(tree) {
        var $__3;
        var scope = this.pushAnnotationScope_();
        scope.isExport = true;
        ($__3 = scope.annotations).push.apply($__3, $traceurRuntime.spread(tree.annotations));
        var declaration = this.transformAny(tree.declaration);
        if (declaration !== tree.declaration || tree.annotations.length > 0)
          tree = new ExportDeclaration(tree.location, declaration, []);
        return this.appendMetadata_(tree);
      },
      transformClassDeclaration: function(tree) {
        var $__3,
            $__4;
        var elementsChanged = false;
        var exportAnnotations = this.scope.isExport ? this.scope.annotations : [];
        var scope = this.pushAnnotationScope_();
        scope.className = tree.name;
        ($__3 = scope.annotations).push.apply($__3, $traceurRuntime.spread(exportAnnotations, tree.annotations));
        tree = $traceurRuntime.superGet(this, AnnotationsTransformer.prototype, "transformClassDeclaration").call(this, tree);
        ($__4 = scope.metadata).unshift.apply($__4, $traceurRuntime.spread(this.transformMetadata_(createIdentifierExpression(tree.name), scope.annotations, scope.constructorParameters)));
        if (tree.annotations.length > 0) {
          tree = new ClassDeclaration(tree.location, tree.name, tree.superClass, tree.elements, [], null);
        }
        return this.appendMetadata_(tree);
      },
      transformFunctionDeclaration: function(tree) {
        var $__3,
            $__4;
        var exportAnnotations = this.scope.isExport ? this.scope.annotations : [];
        var scope = this.pushAnnotationScope_();
        ($__3 = scope.annotations).push.apply($__3, $traceurRuntime.spread(exportAnnotations, tree.annotations));
        ($__4 = scope.metadata).push.apply($__4, $traceurRuntime.spread(this.transformMetadata_(createIdentifierExpression(tree.name), scope.annotations, tree.parameterList.parameters)));
        tree = $traceurRuntime.superGet(this, AnnotationsTransformer.prototype, "transformFunctionDeclaration").call(this, tree);
        if (tree.annotations.length > 0) {
          tree = new FunctionDeclaration(tree.location, tree.name, tree.functionKind, tree.parameterList, tree.typeAnnotation, [], tree.body);
        }
        return this.appendMetadata_(tree);
      },
      transformFormalParameter: function(tree) {
        if (tree.annotations.length > 0) {
          tree = new FormalParameter(tree.location, tree.parameter, tree.typeAnnotation, []);
        }
        return $traceurRuntime.superGet(this, AnnotationsTransformer.prototype, "transformFormalParameter").call(this, tree);
      },
      transformGetAccessor: function(tree) {
        var $__3;
        if (!this.scope.inClassScope)
          return $traceurRuntime.superGet(this, AnnotationsTransformer.prototype, "transformGetAccessor").call(this, tree);
        ($__3 = this.scope.metadata).push.apply($__3, $traceurRuntime.spread(this.transformMetadata_(this.transformAccessor_(tree, this.scope.className, 'get'), tree.annotations, [])));
        if (tree.annotations.length > 0) {
          tree = new GetAccessor(tree.location, tree.isStatic, tree.name, tree.typeAnnotation, [], tree.body);
        }
        return $traceurRuntime.superGet(this, AnnotationsTransformer.prototype, "transformGetAccessor").call(this, tree);
      },
      transformSetAccessor: function(tree) {
        var $__3;
        if (!this.scope.inClassScope)
          return $traceurRuntime.superGet(this, AnnotationsTransformer.prototype, "transformSetAccessor").call(this, tree);
        ($__3 = this.scope.metadata).push.apply($__3, $traceurRuntime.spread(this.transformMetadata_(this.transformAccessor_(tree, this.scope.className, 'set'), tree.annotations, tree.parameterList.parameters)));
        var parameterList = this.transformAny(tree.parameterList);
        if (parameterList !== tree.parameterList || tree.annotations.length > 0) {
          tree = new SetAccessor(tree.location, tree.isStatic, tree.name, parameterList, [], tree.body);
        }
        return $traceurRuntime.superGet(this, AnnotationsTransformer.prototype, "transformSetAccessor").call(this, tree);
      },
      transformMethod: function(tree) {
        var $__3,
            $__4;
        if (!this.scope.inClassScope)
          return $traceurRuntime.superGet(this, AnnotationsTransformer.prototype, "transformMethod").call(this, tree);
        if (!tree.isStatic && propName(tree) === CONSTRUCTOR) {
          ($__3 = this.scope.annotations).push.apply($__3, $traceurRuntime.spread(tree.annotations));
          this.scope.constructorParameters = tree.parameterList.parameters;
        } else {
          ($__4 = this.scope.metadata).push.apply($__4, $traceurRuntime.spread(this.transformMetadata_(this.transformPropertyMethod_(tree, this.scope.className), tree.annotations, tree.parameterList.parameters)));
        }
        var parameterList = this.transformAny(tree.parameterList);
        if (parameterList !== tree.parameterList || tree.annotations.length > 0) {
          tree = new Method(tree.location, tree.isStatic, tree.functionKind, tree.name, parameterList, tree.typeAnnotation, [], tree.body, tree.debugName);
        }
        return $traceurRuntime.superGet(this, AnnotationsTransformer.prototype, "transformMethod").call(this, tree);
      },
      appendMetadata_: function(tree) {
        var $__3;
        var metadata = this.stack_.pop().metadata;
        if (metadata.length > 0) {
          if (this.scope.isExport) {
            ($__3 = this.scope.metadata).push.apply($__3, $traceurRuntime.spread(metadata));
          } else {
            tree = new AnonBlock(null, $traceurRuntime.spread([tree], metadata));
          }
        }
        return tree;
      },
      transformClassReference_: function(tree, className) {
        var parent = createIdentifierExpression(className);
        if (!tree.isStatic)
          parent = createMemberExpression(parent, 'prototype');
        return parent;
      },
      transformPropertyMethod_: function(tree, className) {
        return createMemberExpression(this.transformClassReference_(tree, className), tree.name.literalToken);
      },
      transformAccessor_: function(tree, className, accessor) {
        var args = createArgumentList([this.transformClassReference_(tree, className), this.createLiteralStringExpression_(tree.name)]);
        var descriptor = parseExpression($traceurRuntime.getTemplateObject(["Object.getOwnPropertyDescriptor(", ")"]), args);
        return createMemberExpression(descriptor, accessor);
      },
      transformParameters_: function(parameters) {
        var $__2 = this;
        var hasParameterMetadata = false;
        parameters = parameters.map(function(param) {
          var $__3;
          var metadata = [];
          if (param.typeAnnotation)
            metadata.push($__2.transformAny(param.typeAnnotation));
          if (param.annotations && param.annotations.length > 0)
            ($__3 = metadata).push.apply($__3, $traceurRuntime.spread($__2.transformAnnotations_(param.annotations)));
          if (metadata.length > 0) {
            hasParameterMetadata = true;
            return createArrayLiteral(metadata);
          }
          return createArrayLiteral([]);
        });
        return hasParameterMetadata ? parameters : [];
      },
      transformAnnotations_: function(annotations) {
        return annotations.map(function(annotation) {
          return createNewExpression(annotation.name, annotation.args);
        });
      },
      transformMetadata_: function(target, annotations, parameters) {
        var metadataStatements = [];
        if (annotations !== null) {
          annotations = this.transformAnnotations_(annotations);
          if (annotations.length > 0) {
            metadataStatements.push(this.createDefinePropertyStatement_(target, 'annotations', createArrayLiteral(annotations)));
          }
        }
        if (parameters !== null) {
          parameters = this.transformParameters_(parameters);
          if (parameters.length > 0) {
            metadataStatements.push(this.createDefinePropertyStatement_(target, 'parameters', createArrayLiteral(parameters)));
          }
        }
        return metadataStatements;
      },
      createDefinePropertyStatement_: function(target, property, value) {
        return parseStatement($traceurRuntime.getTemplateObject(["Object.defineProperty(", ", ", ",\n        {get: function() {return ", "}});"]), target, property, value);
      },
      createLiteralStringExpression_: function(tree) {
        var token = tree.literalToken;
        if (tree.literalToken.type !== STRING)
          token = createStringLiteralToken(tree.literalToken.value);
        return new LiteralExpression(null, token);
      },
      get scope() {
        return this.stack_[this.stack_.length - 1];
      },
      pushAnnotationScope_: function() {
        var scope = new AnnotationsScope();
        this.stack_.push(scope);
        return scope;
      }
    }, {}, $__super);
  }(ParseTreeTransformer);
  return {get AnnotationsTransformer() {
      return AnnotationsTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/semantics/util.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/semantics/util.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/semantics/util.js")),
      IDENTIFIER_EXPRESSION = $__0.IDENTIFIER_EXPRESSION,
      LITERAL_EXPRESSION = $__0.LITERAL_EXPRESSION,
      PAREN_EXPRESSION = $__0.PAREN_EXPRESSION,
      UNARY_EXPRESSION = $__0.UNARY_EXPRESSION;
  var UNDEFINED = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/semantics/util.js")).UNDEFINED;
  var VOID = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/semantics/util.js")).VOID;
  function hasUseStrict(list) {
    for (var i = 0; i < list.length; i++) {
      if (!list[i].isDirectivePrologue())
        return false;
      if (list[i].isUseStrictDirective())
        return true;
    }
    return false;
  }
  function isUndefined(tree) {
    if (tree.type === PAREN_EXPRESSION)
      return isUndefined(tree.expression);
    return tree.type === IDENTIFIER_EXPRESSION && tree.identifierToken.value === UNDEFINED;
  }
  function isVoidExpression(tree) {
    if (tree.type === PAREN_EXPRESSION)
      return isVoidExpression(tree.expression);
    return tree.type === UNARY_EXPRESSION && tree.operator.type === VOID && isLiteralExpression(tree.operand);
  }
  function isLiteralExpression(tree) {
    if (tree.type === PAREN_EXPRESSION)
      return isLiteralExpression(tree.expression);
    return tree.type === LITERAL_EXPRESSION;
  }
  return {
    get hasUseStrict() {
      return hasUseStrict;
    },
    get isUndefined() {
      return isUndefined;
    },
    get isVoidExpression() {
      return isVoidExpression;
    },
    get isLiteralExpression() {
      return isLiteralExpression;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/semantics/isTreeStrict.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/semantics/isTreeStrict.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/semantics/isTreeStrict.js")),
      ARROW_FUNCTION = $__0.ARROW_FUNCTION,
      CLASS_DECLARATION = $__0.CLASS_DECLARATION,
      CLASS_EXPRESSION = $__0.CLASS_EXPRESSION,
      FUNCTION_BODY = $__0.FUNCTION_BODY,
      FUNCTION_DECLARATION = $__0.FUNCTION_DECLARATION,
      FUNCTION_EXPRESSION = $__0.FUNCTION_EXPRESSION,
      GET_ACCESSOR = $__0.GET_ACCESSOR,
      METHOD = $__0.METHOD,
      MODULE = $__0.MODULE,
      SCRIPT = $__0.SCRIPT,
      SET_ACCESSOR = $__0.SET_ACCESSOR;
  var hasUseStrict = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./util.js", "traceur@0.0.108/src/semantics/isTreeStrict.js")).hasUseStrict;
  function isTreeStrict(tree) {
    switch (tree.type) {
      case CLASS_DECLARATION:
      case CLASS_EXPRESSION:
      case MODULE:
        return true;
      case FUNCTION_BODY:
        return hasUseStrict(tree.statements);
      case FUNCTION_EXPRESSION:
      case FUNCTION_DECLARATION:
      case METHOD:
        return isTreeStrict(tree.body);
      case ARROW_FUNCTION:
        if (tree.body.type === FUNCTION_BODY) {
          return isTreeStrict(tree.body);
        }
        return false;
      case GET_ACCESSOR:
      case SET_ACCESSOR:
        return isTreeStrict(tree.body);
      case SCRIPT:
        return hasUseStrict(tree.scriptItemList);
      default:
        return false;
    }
  }
  return {get isTreeStrict() {
      return isTreeStrict;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/semantics/Scope.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/semantics/Scope.js";
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/semantics/Scope.js")),
      BLOCK = $__2.BLOCK,
      CATCH = $__2.CATCH,
      FUNCTION_EXPRESSION = $__2.FUNCTION_EXPRESSION;
  var StringMap = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/StringMap.js", "traceur@0.0.108/src/semantics/Scope.js")).StringMap;
  var VAR = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/semantics/Scope.js")).VAR;
  var isTreeStrict = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./isTreeStrict.js", "traceur@0.0.108/src/semantics/Scope.js")).isTreeStrict;
  function reportDuplicateVar(reporter, tree, name) {
    reporter.reportError(tree.location, ("Duplicate declaration, " + name));
  }
  var Scope = function() {
    function Scope(parent, tree) {
      this.parent = parent;
      this.tree = tree;
      this.variableDeclarations_ = new StringMap();
      this.lexicalDeclarations_ = new StringMap();
      this.strictMode = parent && parent.strictMode || isTreeStrict(tree);
      this.inGenerator = parent ? parent.inGenerator || false : false;
    }
    return ($traceurRuntime.createClass)(Scope, {
      addBinding: function(tree, type, reporter) {
        if (type === VAR) {
          this.addVar(tree, reporter);
        } else {
          this.addDeclaration(tree, type, reporter);
        }
      },
      addVar: function(tree, reporter) {
        var name = tree.getStringValue();
        if (this.lexicalDeclarations_.has(name) && !this.isFunctionExpressionName(name)) {
          reportDuplicateVar(reporter, tree, name);
          return;
        }
        this.variableDeclarations_.set(name, {
          type: VAR,
          tree: tree,
          scope: this
        });
        if (!this.isVarScope && this.parent) {
          this.parent.addVar(tree, reporter);
        }
      },
      addDeclaration: function(tree, type, reporter) {
        var name = tree.getStringValue();
        if ((this.lexicalDeclarations_.has(name) || this.variableDeclarations_.has(name)) && !this.isFunctionExpressionName(name)) {
          reportDuplicateVar(reporter, tree, name);
          return;
        }
        this.lexicalDeclarations_.set(name, {
          type: type,
          tree: tree,
          scope: this
        });
      },
      renameBinding: function(oldName, newTree, newType, reporter) {
        var name = newTree.getStringValue();
        if (newType === VAR) {
          if (this.lexicalDeclarations_.has(oldName)) {
            this.lexicalDeclarations_.delete(oldName);
            this.addVar(newTree, reporter);
          }
        } else if (this.variableDeclarations_.has(oldName)) {
          this.variableDeclarations_.delete(oldName);
          this.addDeclaration(newTree, newType, reporter);
          if (!this.isVarScope && this.parent) {
            this.parent.renameBinding(oldName, newTree, newType);
          }
        }
      },
      get isVarScope() {
        switch (this.tree.type) {
          case BLOCK:
          case CATCH:
            return false;
        }
        return true;
      },
      getVarScope: function() {
        if (this.isVarScope) {
          return this;
        }
        if (this.parent) {
          return this.parent.getVarScope();
        }
        return null;
      },
      isFunctionExpressionName: function(name) {
        var b = this.getBindingByName(name);
        return b && b.scope.tree.type === FUNCTION_EXPRESSION && b.scope.tree.name === b.tree;
      },
      getBinding: function(tree) {
        var name = tree.getStringValue();
        return this.getBindingByName(name);
      },
      getBindingByName: function(name) {
        var b = this.variableDeclarations_.get(name);
        if (b && this.isVarScope) {
          return b;
        }
        b = this.lexicalDeclarations_.get(name);
        if (b) {
          return b;
        }
        if (this.parent) {
          return this.parent.getBindingByName(name);
        }
        return null;
      },
      getAllBindingNames: function() {
        var names = this.variableDeclarations_.keysAsSet();
        this.lexicalDeclarations_.forEach(function(name) {
          return names.add(name);
        });
        return names;
      },
      getVariableBindingNames: function() {
        return this.variableDeclarations_.keysAsSet();
      },
      getLexicalBindingNames: function() {
        return this.lexicalDeclarations_.keysAsSet();
      },
      hasBindingName: function(name) {
        return this.lexicalDeclarations_.has(name) || this.variableDeclarations_.has(name);
      },
      hasLexicalBindingName: function(name) {
        return this.lexicalDeclarations_.has(name);
      },
      hasVariableBindingName: function(name) {
        return this.variableDeclarations_.has(name);
      }
    }, {});
  }();
  return {get Scope() {
      return Scope;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/semantics/ScopeVisitor.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/semantics/ScopeVisitor.js";
  var ParseTreeVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/ParseTreeVisitor.js", "traceur@0.0.108/src/semantics/ScopeVisitor.js")).ParseTreeVisitor;
  var VAR = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/semantics/ScopeVisitor.js")).VAR;
  var Scope = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Scope.js", "traceur@0.0.108/src/semantics/ScopeVisitor.js")).Scope;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/semantics/ScopeVisitor.js")),
      COMPREHENSION_FOR = $__6.COMPREHENSION_FOR,
      VARIABLE_DECLARATION_LIST = $__6.VARIABLE_DECLARATION_LIST;
  var ScopeVisitor = function($__super) {
    function ScopeVisitor() {
      $traceurRuntime.superConstructor(ScopeVisitor).call(this);
      this.map_ = new Map();
      this.scope = null;
      this.withBlockCounter_ = 0;
    }
    return ($traceurRuntime.createClass)(ScopeVisitor, {
      getScopeForTree: function(tree) {
        return this.map_.get(tree);
      },
      createScope: function(tree) {
        return new Scope(this.scope, tree);
      },
      pushScope: function(tree) {
        var scope = this.createScope(tree);
        this.map_.set(tree, scope);
        return this.scope = scope;
      },
      popScope: function(scope) {
        if (this.scope !== scope) {
          throw new Error('ScopeVisitor scope mismatch');
        }
        this.scope = scope.parent;
      },
      visitScript: function(tree) {
        var scope = this.pushScope(tree);
        $traceurRuntime.superGet(this, ScopeVisitor.prototype, "visitScript").call(this, tree);
        this.popScope(scope);
      },
      visitModule: function(tree) {
        var scope = this.pushScope(tree);
        $traceurRuntime.superGet(this, ScopeVisitor.prototype, "visitModule").call(this, tree);
        this.popScope(scope);
      },
      visitBlock: function(tree) {
        var scope = this.pushScope(tree);
        $traceurRuntime.superGet(this, ScopeVisitor.prototype, "visitBlock").call(this, tree);
        this.popScope(scope);
      },
      visitCatch: function(tree) {
        var scope = this.pushScope(tree);
        this.visitAny(tree.binding);
        this.visitList(tree.catchBody.statements);
        this.popScope(scope);
      },
      visitFunctionBodyForScope: function(tree) {
        var parameterList = arguments[1] !== (void 0) ? arguments[1] : tree.parameterList;
        var scope = this.pushScope(tree);
        this.visitAny(parameterList);
        scope.inGenerator = tree.functionKind && tree.isGenerator();
        this.visitAny(tree.body);
        this.popScope(scope);
      },
      visitFunctionExpression: function(tree) {
        this.visitFunctionBodyForScope(tree);
      },
      visitFunctionDeclaration: function(tree) {
        this.visitAny(tree.name);
        this.visitFunctionBodyForScope(tree);
      },
      visitArrowFunction: function(tree) {
        this.visitFunctionBodyForScope(tree);
      },
      visitGetAccessor: function(tree) {
        this.visitFunctionBodyForScope(tree, null);
      },
      visitSetAccessor: function(tree) {
        this.visitFunctionBodyForScope(tree);
      },
      visitMethod: function(tree) {
        this.visitFunctionBodyForScope(tree);
      },
      visitClassDeclaration: function(tree) {
        this.visitAny(tree.superClass);
        var scope = this.pushScope(tree);
        this.visitAny(tree.name);
        this.visitList(tree.elements);
        this.popScope(scope);
      },
      visitClassExpression: function(tree) {
        this.visitAny(tree.superClass);
        var scope;
        if (tree.name) {
          scope = this.pushScope(tree);
          this.visitAny(tree.name);
        }
        this.visitList(tree.elements);
        if (tree.name) {
          this.popScope(scope);
        }
      },
      visitWithStatement: function(tree) {
        this.visitAny(tree.expression);
        this.withBlockCounter_++;
        this.visitAny(tree.body);
        this.withBlockCounter_--;
      },
      get inWithBlock() {
        return this.withBlockCounter_ > 0;
      },
      visitLoop_: function(tree, func) {
        if (tree.initializer.type !== VARIABLE_DECLARATION_LIST || tree.initializer.declarationType === VAR) {
          func();
          return;
        }
        var scope = this.pushScope(tree);
        func();
        this.popScope(scope);
      },
      visitForInStatement: function(tree) {
        var $__1 = this;
        this.visitLoop_(tree, function() {
          return $traceurRuntime.superGet($__1, ScopeVisitor.prototype, "visitForInStatement").call($__1, tree);
        });
      },
      visitForOfStatement: function(tree) {
        var $__1 = this;
        this.visitLoop_(tree, function() {
          return $traceurRuntime.superGet($__1, ScopeVisitor.prototype, "visitForOfStatement").call($__1, tree);
        });
      },
      visitForStatement: function(tree) {
        var $__1 = this;
        if (!tree.initializer) {
          $traceurRuntime.superGet(this, ScopeVisitor.prototype, "visitForStatement").call(this, tree);
        } else {
          this.visitLoop_(tree, function() {
            return $traceurRuntime.superGet($__1, ScopeVisitor.prototype, "visitForStatement").call($__1, tree);
          });
        }
      },
      visitComprehension_: function(tree) {
        var scopes = [];
        for (var i = 0; i < tree.comprehensionList.length; i++) {
          var scope = null;
          if (tree.comprehensionList[i].type === COMPREHENSION_FOR) {
            scope = this.pushScope(tree.comprehensionList[i]);
          }
          scopes.push(scope);
          this.visitAny(tree.comprehensionList[i]);
        }
        this.visitAny(tree.expression);
        for (var i$__2 = scopes.length - 1; i$__2 >= 0; i$__2--) {
          if (scopes[i$__2]) {
            this.popScope(scopes[i$__2]);
          }
        }
      },
      visitArrayComprehension: function(tree) {
        this.visitComprehension_(tree);
      },
      visitGeneratorComprehension: function(tree) {
        this.visitComprehension_(tree);
      },
      visitPredefinedType: function(tree) {},
      visitTypeArguments: function(tree) {},
      visitFunctionType: function(tree) {}
    }, {}, $__super);
  }(ParseTreeVisitor);
  return {get ScopeVisitor() {
      return ScopeVisitor;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/semantics/ScopeChainBuilder.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/semantics/ScopeChainBuilder.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/semantics/ScopeChainBuilder.js")),
      CONST = $__1.CONST,
      LET = $__1.LET,
      VAR = $__1.VAR;
  var ScopeVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ScopeVisitor.js", "traceur@0.0.108/src/semantics/ScopeChainBuilder.js")).ScopeVisitor;
  var ScopeChainBuilder = function($__super) {
    function ScopeChainBuilder(reporter) {
      $traceurRuntime.superConstructor(ScopeChainBuilder).call(this);
      this.reporter = reporter;
      this.declarationType_ = null;
    }
    return ($traceurRuntime.createClass)(ScopeChainBuilder, {
      visitCatch: function(tree) {
        var scope = this.pushScope(tree);
        this.declarationType_ = LET;
        this.visitAny(tree.binding);
        this.visitList(tree.catchBody.statements);
        this.popScope(scope);
      },
      visitImportedBinding: function(tree) {
        this.declarationType_ = CONST;
        $traceurRuntime.superGet(this, ScopeChainBuilder.prototype, "visitImportedBinding").call(this, tree);
      },
      visitVariableDeclarationList: function(tree) {
        this.declarationType_ = tree.declarationType;
        $traceurRuntime.superGet(this, ScopeChainBuilder.prototype, "visitVariableDeclarationList").call(this, tree);
      },
      visitBindingIdentifier: function(tree) {
        this.declareVariable(tree);
      },
      visitFunctionExpression: function(tree) {
        var scope = this.pushScope(tree);
        if (tree.name) {
          this.declarationType_ = CONST;
          this.visitAny(tree.name);
        }
        this.visitAny(tree.parameterList);
        scope.inGenerator = tree.isGenerator();
        this.visitAny(tree.body);
        this.popScope(scope);
      },
      visitFormalParameter: function(tree) {
        this.declarationType_ = VAR;
        $traceurRuntime.superGet(this, ScopeChainBuilder.prototype, "visitFormalParameter").call(this, tree);
      },
      visitFunctionDeclaration: function(tree) {
        if (this.scope) {
          if (this.scope.isVarScope) {
            this.declarationType_ = VAR;
            this.visitAny(tree.name);
          } else {
            if (!this.scope.strictMode) {
              var varScope = this.scope.getVarScope();
              if (varScope) {
                varScope.addVar(tree.name, this.reporter);
              }
            }
            this.declarationType_ = LET;
            this.visitAny(tree.name);
          }
        }
        this.visitFunctionBodyForScope(tree, tree.parameterList, tree.body);
      },
      visitClassDeclaration: function(tree) {
        this.visitAny(tree.superClass);
        this.declarationType_ = LET;
        this.visitAny(tree.name);
        var scope = this.pushScope(tree);
        this.declarationType_ = CONST;
        this.visitAny(tree.name);
        this.visitList(tree.elements);
        this.popScope(scope);
      },
      visitClassExpression: function(tree) {
        this.visitAny(tree.superClass);
        var scope;
        if (tree.name) {
          scope = this.pushScope(tree);
          this.declarationType_ = CONST;
          this.visitAny(tree.name);
        }
        this.visitList(tree.elements);
        if (tree.name) {
          this.popScope(scope);
        }
      },
      visitComprehensionFor: function(tree) {
        this.declarationType_ = LET;
        $traceurRuntime.superGet(this, ScopeChainBuilder.prototype, "visitComprehensionFor").call(this, tree);
      },
      declareVariable: function(tree) {
        this.scope.addBinding(tree, this.declarationType_, this.reporter);
      }
    }, {}, $__super);
  }(ScopeVisitor);
  return {get ScopeChainBuilder() {
      return ScopeChainBuilder;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/semantics/VariableBinder.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/semantics/VariableBinder.js";
  var ScopeChainBuilder = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ScopeChainBuilder.js", "traceur@0.0.108/src/semantics/VariableBinder.js")).ScopeChainBuilder;
  function variablesInBlock(tree) {
    var includeFunctionScope = arguments[1];
    var builder = new ScopeChainBuilder(null);
    builder.visitAny(tree);
    var scope = builder.getScopeForTree(tree);
    var names = scope.getLexicalBindingNames();
    if (!includeFunctionScope) {
      return names;
    }
    var variableBindingNames = scope.getVariableBindingNames();
    variableBindingNames.forEach(function(name) {
      return names.add(name);
    });
    return names;
  }
  function variablesInFunction(tree) {
    var builder = new ScopeChainBuilder(null);
    builder.visitAny(tree);
    var scope = builder.getScopeForTree(tree);
    return scope.getAllBindingNames();
  }
  return {
    get variablesInBlock() {
      return variablesInBlock;
    },
    get variablesInFunction() {
      return variablesInFunction;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ScopeTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ScopeTransformer.js";
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/ScopeTransformer.js")),
      ARGUMENTS = $__4.ARGUMENTS,
      THIS = $__4.THIS;
  var FindInFunctionScope = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FindInFunctionScope.js", "traceur@0.0.108/src/codegeneration/ScopeTransformer.js")).FindInFunctionScope;
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/ScopeTransformer.js")).ParseTreeTransformer;
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/ScopeTransformer.js")),
      FunctionDeclaration = $__7.FunctionDeclaration,
      FunctionExpression = $__7.FunctionExpression,
      GetAccessor = $__7.GetAccessor,
      Method = $__7.Method,
      SetAccessor = $__7.SetAccessor;
  var StringSet = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/StringSet.js", "traceur@0.0.108/src/codegeneration/ScopeTransformer.js")).StringSet;
  var VARIABLE_DECLARATION_LIST = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/ScopeTransformer.js")).VARIABLE_DECLARATION_LIST;
  var VAR = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/ScopeTransformer.js")).VAR;
  var $__11 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../semantics/VariableBinder.js", "traceur@0.0.108/src/codegeneration/ScopeTransformer.js")),
      variablesInBlock = $__11.variablesInBlock,
      variablesInFunction = $__11.variablesInFunction;
  var FindNames = function($__super) {
    function FindNames(names) {
      $traceurRuntime.superConstructor(FindNames).call(this);
      this.names = names;
    }
    return ($traceurRuntime.createClass)(FindNames, {visitBindingIdentifier: function(tree) {
        this.names.add(tree.getStringValue());
      }}, {}, $__super);
  }(FindInFunctionScope);
  function getLexicalBindingNames(tree) {
    var names = new StringSet();
    if (tree !== null && tree.type === VARIABLE_DECLARATION_LIST && tree.declarationType !== VAR) {
      var visitor = new FindNames(names);
      for (var i = 0; i < tree.declarations.length; i++) {
        visitor.visitAny(tree.declarations[i].lvalue);
      }
    }
    return names;
  }
  var ScopeTransformer = function($__super) {
    function ScopeTransformer(varName) {
      $traceurRuntime.superConstructor(ScopeTransformer).call(this);
      this.varName_ = varName;
    }
    return ($traceurRuntime.createClass)(ScopeTransformer, {
      transformBlock: function(tree) {
        if (variablesInBlock(tree).has(this.varName_)) {
          return tree;
        }
        return $traceurRuntime.superGet(this, ScopeTransformer.prototype, "transformBlock").call(this, tree);
      },
      sameTreeIfNameInLoopInitializer_: function(tree) {
        var names = getLexicalBindingNames(tree.initializer);
        if (names.has(this.varName_)) {
          return tree;
        }
        return null;
      },
      transformForStatement: function(tree) {
        return this.sameTreeIfNameInLoopInitializer_(tree) || $traceurRuntime.superGet(this, ScopeTransformer.prototype, "transformForStatement").call(this, tree);
      },
      transformForInStatement: function(tree) {
        return this.sameTreeIfNameInLoopInitializer_(tree) || $traceurRuntime.superGet(this, ScopeTransformer.prototype, "transformForInStatement").call(this, tree);
      },
      transformForOfStatement: function(tree) {
        return this.sameTreeIfNameInLoopInitializer_(tree) || $traceurRuntime.superGet(this, ScopeTransformer.prototype, "transformForOfStatement").call(this, tree);
      },
      transformForOnStatement: function(tree) {
        return this.sameTreeIfNameInLoopInitializer_(tree) || $traceurRuntime.superGet(this, ScopeTransformer.prototype, "transformForOnStatement").call(this, tree);
      },
      transformThisExpression: function(tree) {
        if (this.varName_ !== THIS)
          return tree;
        return $traceurRuntime.superGet(this, ScopeTransformer.prototype, "transformThisExpression").call(this, tree);
      },
      transformParameterListAndBody_: function(tree) {
        if (this.getDoNotRecurse(tree))
          return tree;
        return {
          parameterList: this.transformAny(tree.parameterList),
          body: this.transformAny(tree.body)
        };
      },
      transformFunctionDeclaration: function(tree) {
        var name = this.transformAny(tree.name);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        var annotations = this.transformList(tree.annotations);
        var $__3 = this.transformParameterListAndBody_(tree),
            parameterList = $__3.parameterList,
            body = $__3.body;
        if (name === tree.name && parameterList === tree.parameterList && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && body === tree.body) {
          return tree;
        }
        return new FunctionDeclaration(tree.location, name, tree.functionKind, parameterList, typeAnnotation, annotations, body);
      },
      transformFunctionExpression: function(tree) {
        var name = this.transformAny(tree.name);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        var annotations = this.transformList(tree.annotations);
        var $__3 = this.transformParameterListAndBody_(tree),
            parameterList = $__3.parameterList,
            body = $__3.body;
        if (name === tree.name && parameterList === tree.parameterList && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && body === tree.body) {
          return tree;
        }
        return new FunctionExpression(tree.location, name, tree.functionKind, parameterList, typeAnnotation, annotations, body);
      },
      transformMethod: function(tree) {
        var name = this.transformAny(tree.name);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        var annotations = this.transformList(tree.annotations);
        var $__3 = this.transformParameterListAndBody_(tree),
            parameterList = $__3.parameterList,
            body = $__3.body;
        if (name === tree.name && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && parameterList === tree.parameterList && body === tree.body) {
          return tree;
        }
        return new Method(tree.location, tree.isStatic, tree.functionKind, name, parameterList, typeAnnotation, annotations, body, tree.debugName);
      },
      transformGetAccessor: function(tree) {
        var name = this.transformAny(tree.name);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        var annotations = this.transformList(tree.annotations);
        var body = this.getDoNotRecurse(tree) ? tree.body : this.transformAny(tree.body);
        if (name === tree.name && typeAnnotation === tree.typeAnnotation && annotations === tree.annotations && body === tree.body) {
          return tree;
        }
        return new GetAccessor(tree.location, tree.isStatic, name, typeAnnotation, annotations, body);
      },
      transformSetAccessor: function(tree) {
        var name = this.transformAny(tree.name);
        var annotations = this.transformList(tree.annotations);
        var $__3 = this.transformParameterListAndBody_(tree),
            parameterList = $__3.parameterList,
            body = $__3.body;
        if (name === tree.name && annotations === tree.annotations && parameterList === tree.parameterList && body === tree.body) {
          return tree;
        }
        return new SetAccessor(tree.location, tree.isStatic, name, parameterList, annotations, body);
      },
      getDoNotRecurse: function(tree) {
        return this.varName_ === ARGUMENTS || this.varName_ === THIS || variablesInFunction(tree).has(this.varName_);
      },
      transformCatch: function(tree) {
        if (!tree.binding.isPattern() && this.varName_ === tree.binding.identifierToken.value) {
          return tree;
        }
        return $traceurRuntime.superGet(this, ScopeTransformer.prototype, "transformCatch").call(this, tree);
      }
    }, {}, $__super);
  }(ParseTreeTransformer);
  return {get ScopeTransformer() {
      return ScopeTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/AlphaRenamer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/AlphaRenamer.js";
  var ScopeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ScopeTransformer.js", "traceur@0.0.108/src/codegeneration/AlphaRenamer.js")).ScopeTransformer;
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/AlphaRenamer.js")),
      FunctionDeclaration = $__2.FunctionDeclaration,
      FunctionExpression = $__2.FunctionExpression;
  var THIS = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/AlphaRenamer.js")).THIS;
  var createIdentifierExpression = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/AlphaRenamer.js")).createIdentifierExpression;
  var AlphaRenamer = function($__super) {
    function AlphaRenamer(varName, newName) {
      $traceurRuntime.superConstructor(AlphaRenamer).call(this, varName);
      this.newName_ = newName;
    }
    return ($traceurRuntime.createClass)(AlphaRenamer, {
      transformIdentifierExpression: function(tree) {
        if (this.varName_ === tree.identifierToken.value) {
          return createIdentifierExpression(this.newName_);
        } else {
          return tree;
        }
      },
      transformThisExpression: function(tree) {
        if (this.varName_ !== THIS)
          return tree;
        return createIdentifierExpression(this.newName_);
      },
      transformFunctionDeclaration: function(tree) {
        if (this.varName_ === tree.name) {
          tree = new FunctionDeclaration(tree.location, this.newName_, tree.functionKind, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body);
        }
        return $traceurRuntime.superGet(this, AlphaRenamer.prototype, "transformFunctionDeclaration").call(this, tree);
      },
      transformFunctionExpression: function(tree) {
        if (this.varName_ === tree.name) {
          tree = new FunctionExpression(tree.location, this.newName_, tree.functionKind, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body);
        }
        return $traceurRuntime.superGet(this, AlphaRenamer.prototype, "transformFunctionExpression").call(this, tree);
      }
    }, {rename: function(tree, varName, newName) {
        return new AlphaRenamer(varName, newName).transformAny(tree);
      }}, $__super);
  }(ScopeTransformer);
  return {get AlphaRenamer() {
      return AlphaRenamer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/FindThisOrArguments.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/FindThisOrArguments.js";
  var ARGUMENTS = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/FindThisOrArguments.js")).ARGUMENTS;
  var FindInFunctionScope = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FindInFunctionScope.js", "traceur@0.0.108/src/codegeneration/FindThisOrArguments.js")).FindInFunctionScope;
  var FindThisOrArguments = function($__super) {
    function FindThisOrArguments() {
      $traceurRuntime.superConstructor(FindThisOrArguments).call(this);
      this.foundThis = false;
      this.foundArguments = false;
    }
    return ($traceurRuntime.createClass)(FindThisOrArguments, {
      visitThisExpression: function(tree) {
        this.foundThis = true;
        this.found = this.foundArguments;
      },
      visitIdentifierExpression: function(tree) {
        if (tree.identifierToken.value === ARGUMENTS) {
          this.foundArguments = true;
          this.found = this.foundThis;
        }
      }
    }, {}, $__super);
  }(FindInFunctionScope);
  return {get FindThisOrArguments() {
      return FindThisOrArguments;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/alphaRenameThisAndArguments.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/alphaRenameThisAndArguments.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/alphaRenameThisAndArguments.js")),
      ARGUMENTS = $__0.ARGUMENTS,
      THIS = $__0.THIS;
  var AlphaRenamer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./AlphaRenamer.js", "traceur@0.0.108/src/codegeneration/alphaRenameThisAndArguments.js")).AlphaRenamer;
  var FindThisOrArguments = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FindThisOrArguments.js", "traceur@0.0.108/src/codegeneration/alphaRenameThisAndArguments.js")).FindThisOrArguments;
  function alphaRenameThisAndArguments(tempVarTransformer, tree) {
    var finder = new FindThisOrArguments();
    finder.visitAny(tree);
    if (finder.foundArguments) {
      var argumentsTempName = tempVarTransformer.addTempVarForArguments();
      tree = AlphaRenamer.rename(tree, ARGUMENTS, argumentsTempName);
    }
    if (finder.foundThis) {
      var thisTempName = tempVarTransformer.addTempVarForThis();
      tree = AlphaRenamer.rename(tree, THIS, thisTempName);
    }
    return tree;
  }
  var $__default = alphaRenameThisAndArguments;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ComprehensionTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ComprehensionTransformer.js";
  var alphaRenameThisAndArguments = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./alphaRenameThisAndArguments.js", "traceur@0.0.108/src/codegeneration/ComprehensionTransformer.js")).default;
  var FunctionExpression = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/ComprehensionTransformer.js")).FunctionExpression;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/ComprehensionTransformer.js")).TempVarTransformer;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/ComprehensionTransformer.js")),
      LET = $__4.LET,
      STAR = $__4.STAR,
      VAR = $__4.VAR;
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/ComprehensionTransformer.js")),
      COMPREHENSION_FOR = $__5.COMPREHENSION_FOR,
      COMPREHENSION_IF = $__5.COMPREHENSION_IF;
  var Token = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/Token.js", "traceur@0.0.108/src/codegeneration/ComprehensionTransformer.js")).Token;
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/ComprehensionTransformer.js")),
      createCallExpression = $__7.createCallExpression,
      createEmptyParameterList = $__7.createEmptyParameterList,
      createForOfStatement = $__7.createForOfStatement,
      createFunctionBody = $__7.createFunctionBody,
      createIfStatement = $__7.createIfStatement,
      createParenExpression = $__7.createParenExpression,
      createVariableDeclarationList = $__7.createVariableDeclarationList;
  var ComprehensionTransformer = function($__super) {
    function ComprehensionTransformer() {
      $traceurRuntime.superConstructor(ComprehensionTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(ComprehensionTransformer, {transformComprehension: function(tree, statement, isGenerator) {
        var prefix = arguments[3];
        var suffix = arguments[4];
        var bindingKind = isGenerator || !this.options.blockBinding ? VAR : LET;
        var statements = prefix ? [prefix] : [];
        for (var i = tree.comprehensionList.length - 1; i >= 0; i--) {
          var item = tree.comprehensionList[i];
          switch (item.type) {
            case COMPREHENSION_IF:
              {
                var expression = this.transformAny(item.expression);
                statement = createIfStatement(expression, statement);
                break;
              }
            case COMPREHENSION_FOR:
              {
                var left = this.transformAny(item.left);
                var iterator = this.transformAny(item.iterator);
                var initializer = createVariableDeclarationList(bindingKind, left, null);
                statement = createForOfStatement(initializer, iterator, statement);
                break;
              }
            default:
              throw new Error('Unreachable.');
          }
        }
        statement = alphaRenameThisAndArguments(this, statement);
        statements.push(statement);
        if (suffix)
          statements.push(suffix);
        var functionKind = isGenerator ? new Token(STAR, null) : null;
        var func = new FunctionExpression(null, null, functionKind, createEmptyParameterList(), null, [], createFunctionBody(statements));
        return createParenExpression(createCallExpression(func));
      }}, {}, $__super);
  }(TempVarTransformer);
  return {get ComprehensionTransformer() {
      return ComprehensionTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ArrayComprehensionTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ArrayComprehensionTransformer.js";
  var ComprehensionTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ComprehensionTransformer.js", "traceur@0.0.108/src/codegeneration/ArrayComprehensionTransformer.js")).ComprehensionTransformer;
  var createIdentifierExpression = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/ArrayComprehensionTransformer.js")).createIdentifierExpression;
  var parseStatement = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/ArrayComprehensionTransformer.js")).parseStatement;
  var ArrayComprehensionTransformer = function($__super) {
    function ArrayComprehensionTransformer() {
      $traceurRuntime.superConstructor(ArrayComprehensionTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(ArrayComprehensionTransformer, {transformArrayComprehension: function(tree) {
        this.pushTempScope();
        var expression = this.transformAny(tree.expression);
        var index = createIdentifierExpression(this.getTempIdentifier());
        var result = createIdentifierExpression(this.getTempIdentifier());
        var tempVarsStatatement = parseStatement($traceurRuntime.getTemplateObject(["var ", " = 0, ", " = [];"]), index, result);
        var statement = parseStatement($traceurRuntime.getTemplateObject(["", "[", "++] = ", ";"]), result, index, expression);
        var returnStatement = parseStatement($traceurRuntime.getTemplateObject(["return ", ";"]), result);
        var functionKind = null;
        result = this.transformComprehension(tree, statement, functionKind, tempVarsStatatement, returnStatement);
        this.popTempScope();
        return result;
      }}, {}, $__super);
  }(ComprehensionTransformer);
  return {get ArrayComprehensionTransformer() {
      return ArrayComprehensionTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ParenTrait.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ParenTrait.js";
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/ParenTrait.js")),
      ArgumentList = $__2.ArgumentList,
      ArrayLiteral = $__2.ArrayLiteral,
      BinaryExpression = $__2.BinaryExpression,
      ConditionalExpression = $__2.ConditionalExpression,
      ExpressionStatement = $__2.ExpressionStatement,
      NewExpression = $__2.NewExpression,
      ParenExpression = $__2.ParenExpression,
      PropertyNameAssignment = $__2.PropertyNameAssignment,
      VariableDeclaration = $__2.VariableDeclaration;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/ParenTrait.js")),
      CALL_EXPRESSION = $__3.CALL_EXPRESSION,
      COMMA_EXPRESSION = $__3.COMMA_EXPRESSION,
      FUNCTION_EXPRESSION = $__3.FUNCTION_EXPRESSION,
      OBJECT_LITERAL = $__3.OBJECT_LITERAL,
      OBJECT_PATTERN = $__3.OBJECT_PATTERN,
      TEMPLATE_LITERAL_EXPRESSION = $__3.TEMPLATE_LITERAL_EXPRESSION,
      YIELD_EXPRESSION = $__3.YIELD_EXPRESSION;
  function wrap(tree) {
    return new ParenExpression(tree.location, tree);
  }
  function ParenTrait(ParseTreeTransformerClass) {
    return function($__super) {
      function $__0() {
        $traceurRuntime.superConstructor($__0).apply(this, arguments);
      }
      return ($traceurRuntime.createClass)($__0, {
        transformVariableDeclaration: function(tree) {
          var lvalue = this.transformAny(tree.lvalue);
          var typeAnnotation = this.transformAny(tree.typeAnnotation);
          var initializer = this.transformAny(tree.initializer);
          if (initializer !== null && initializer.type === COMMA_EXPRESSION) {
            initializer = wrap(initializer);
          } else if (tree.lvalue === lvalue && tree.typeAnnotation === typeAnnotation && tree.initializer === initializer) {
            return tree;
          }
          return new VariableDeclaration(tree.location, lvalue, typeAnnotation, initializer);
        },
        transformExpressionStatement: function(tree) {
          var expression = this.transformAny(tree.expression);
          switch (expression.type) {
            case OBJECT_LITERAL:
            case OBJECT_PATTERN:
            case FUNCTION_EXPRESSION:
              expression = wrap(expression);
              break;
          }
          if (tree.expression === expression) {
            return tree;
          }
          return new ExpressionStatement(tree.location, expression);
        },
        transformNewExpression: function(tree) {
          var operand = this.transformAny(tree.operand);
          var args = this.transformAny(tree.args);
          switch (operand.type) {
            case CALL_EXPRESSION:
            case TEMPLATE_LITERAL_EXPRESSION:
              operand = wrap(operand);
          }
          if (operand === tree.operand && args === tree.args) {
            return tree;
          }
          return new NewExpression(tree.location, operand, args);
        },
        transformExpressionList_: function(list) {
          var expressions = this.transformList(list);
          var newList = null;
          for (var i = 0; i < list.length; i++) {
            var expression = expressions[i];
            if (expression !== null && expression.type === COMMA_EXPRESSION) {
              expression = wrap(expression);
              if (newList === null) {
                newList = expressions.slice(0, i);
              }
              newList.push(expression);
            } else if (newList !== null) {
              newList.push(expression);
            }
          }
          if (newList !== null) {
            return newList;
          }
          return expressions;
        },
        transformArgumentList: function(tree) {
          var args = this.transformExpressionList_(tree.args);
          if (tree.args === args) {
            return tree;
          }
          return new ArgumentList(tree.location, args);
        },
        transformArrayLiteral: function(tree) {
          var elements = this.transformExpressionList_(tree.elements);
          if (tree.elements === elements) {
            return tree;
          }
          return new ArrayLiteral(tree.location, elements);
        },
        transformPropertyNameAssignment: function(tree) {
          var name = this.transformAny(tree.name);
          var value = this.transformAny(tree.value);
          if (value.type === COMMA_EXPRESSION) {
            value = wrap(value);
          } else if (name === tree.name && value === tree.value) {
            return tree;
          }
          return new PropertyNameAssignment(tree.location, name, value);
        },
        transformBinaryExpression: function(tree) {
          var left = this.transformAny(tree.left);
          var right = this.transformAny(tree.right);
          if (commaOrYield(left.type)) {
            left = wrap(left);
          }
          if (commaOrYield(right.type)) {
            right = wrap(right);
          }
          if (left === tree.left && right === tree.right) {
            return tree;
          }
          return new BinaryExpression(tree.location, left, tree.operator, right);
        },
        transformConditionalExpression: function(tree) {
          var condition = this.transformAny(tree.condition);
          var left = this.transformAny(tree.left);
          var right = this.transformAny(tree.right);
          if (commaOrYield(condition.type)) {
            condition = wrap(condition);
          }
          if (left.type == COMMA_EXPRESSION) {
            left = wrap(left);
          }
          if (right.type == COMMA_EXPRESSION) {
            right = wrap(right);
          }
          if (condition === tree.condition && left === tree.left && right === tree.right) {
            return tree;
          }
          return new ConditionalExpression(tree.location, condition, left, right);
        }
      }, {}, $__super);
    }(ParseTreeTransformerClass);
  }
  function commaOrYield(type) {
    return type === COMMA_EXPRESSION || type == YIELD_EXPRESSION;
  }
  return {get ParenTrait() {
      return ParenTrait;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ArrowFunctionTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ArrowFunctionTransformer.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/ArrowFunctionTransformer.js")),
      ARGUMENTS = $__1.ARGUMENTS,
      CONSTRUCTOR = $__1.CONSTRUCTOR,
      THIS = $__1.THIS;
  var AlphaRenamer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./AlphaRenamer.js", "traceur@0.0.108/src/codegeneration/ArrowFunctionTransformer.js")).AlphaRenamer;
  var FunctionExpression = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/ArrowFunctionTransformer.js")).FunctionExpression;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/ArrowFunctionTransformer.js")).TempVarTransformer;
  var ParenTrait = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParenTrait.js", "traceur@0.0.108/src/codegeneration/ArrowFunctionTransformer.js")).ParenTrait;
  var alphaRenameThisAndArguments = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./alphaRenameThisAndArguments.js", "traceur@0.0.108/src/codegeneration/ArrowFunctionTransformer.js")).default;
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/ArrowFunctionTransformer.js")),
      FUNCTION_BODY = $__7.FUNCTION_BODY,
      LITERAL_PROPERTY_NAME = $__7.LITERAL_PROPERTY_NAME;
  var FindThisOrArguments = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FindThisOrArguments.js", "traceur@0.0.108/src/codegeneration/ArrowFunctionTransformer.js")).FindThisOrArguments;
  var $__9 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/ArrowFunctionTransformer.js")),
      createAssignmentExpression = $__9.createAssignmentExpression,
      createCommaExpression = $__9.createCommaExpression,
      createFunctionBody = $__9.createFunctionBody,
      createIdentifierExpression = $__9.createIdentifierExpression,
      createReturnStatement = $__9.createReturnStatement,
      createThisExpression = $__9.createThisExpression;
  function convertConciseBody(tree) {
    if (tree.type !== FUNCTION_BODY)
      return createFunctionBody([createReturnStatement(tree)]);
    return tree;
  }
  var ArrowFunctionTransformer = function($__super) {
    function ArrowFunctionTransformer(identifierGenerator, reporter, options) {
      $traceurRuntime.superConstructor(ArrowFunctionTransformer).call(this, identifierGenerator, reporter, options);
      this.inDerivedClass_ = false;
      this.inConstructor_ = false;
    }
    return ($traceurRuntime.createClass)(ArrowFunctionTransformer, {
      transformArrowFunction: function(tree) {
        if (this.inDerivedClass_ && this.inConstructor_) {
          return this.transformUsingCommaExpression_(tree);
        }
        return this.transformUsingTempVar_(tree);
      },
      transformUsingCommaExpression_: function(tree) {
        var finder = new FindThisOrArguments();
        var argumentsTempName,
            thisTempName;
        finder.visitAny(tree);
        if (finder.foundArguments) {
          argumentsTempName = this.addTempVar();
          tree = AlphaRenamer.rename(tree, ARGUMENTS, argumentsTempName);
        }
        if (finder.foundThis) {
          thisTempName = this.addTempVar();
          tree = AlphaRenamer.rename(tree, THIS, thisTempName);
        }
        var parameterList = this.transformAny(tree.parameterList);
        var body = this.transformAny(tree.body);
        body = convertConciseBody(body);
        var functionExpression = new FunctionExpression(tree.location, null, tree.functionKind, parameterList, null, [], body);
        var expressions = [];
        if (argumentsTempName) {
          expressions.push(createAssignmentExpression(createIdentifierExpression(argumentsTempName), createIdentifierExpression(ARGUMENTS)));
        }
        if (thisTempName) {
          expressions.push(createAssignmentExpression(createIdentifierExpression(thisTempName), createThisExpression()));
        }
        if (expressions.length === 0) {
          return functionExpression;
        }
        expressions.push(functionExpression);
        return createCommaExpression(expressions);
      },
      transformUsingTempVar_: function(tree) {
        var alphaRenamed = alphaRenameThisAndArguments(this, tree);
        var parameterList = this.transformAny(alphaRenamed.parameterList);
        var body = this.transformAny(alphaRenamed.body);
        body = convertConciseBody(body);
        var functionExpression = new FunctionExpression(tree.location, null, tree.functionKind, parameterList, null, [], body);
        return functionExpression;
      },
      transformClassExpression: function(tree) {
        var inDerivedClass = this.inDerivedClass_;
        this.inDerivedClass_ = tree.superClass !== null;
        var result = $traceurRuntime.superGet(this, ArrowFunctionTransformer.prototype, "transformClassExpression").call(this, tree);
        this.inDerivedClass_ = inDerivedClass;
        return result;
      },
      transformClassDeclaration: function(tree) {
        var inDerivedClass = this.inDerivedClass_;
        this.inDerivedClass_ = tree.superClass !== null;
        var result = $traceurRuntime.superGet(this, ArrowFunctionTransformer.prototype, "transformClassDeclaration").call(this, tree);
        this.inDerivedClass_ = inDerivedClass;
        return result;
      },
      transformMethod: function(tree) {
        var inConstructor = this.inConstructor_;
        this.inConstructor_ = !tree.isStatic && tree.functionKind === null && tree.name.type === LITERAL_PROPERTY_NAME && tree.name.literalToken.value === CONSTRUCTOR;
        var result = $traceurRuntime.superGet(this, ArrowFunctionTransformer.prototype, "transformMethod").call(this, tree);
        this.inConstructor_ = inConstructor;
        return result;
      }
    }, {transform: function(tempVarTransformer, tree) {
        tree = alphaRenameThisAndArguments(tempVarTransformer, tree);
        var body = convertConciseBody(tree.body);
        return new FunctionExpression(tree.location, null, tree.functionKind, tree.parameterList, null, [], body);
      }}, $__super);
  }(ParenTrait(TempVarTransformer));
  return {get ArrowFunctionTransformer() {
      return ArrowFunctionTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/SkipFunctionsTransformerTrait.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/SkipFunctionsTransformerTrait.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/SkipFunctionsTransformerTrait.js")),
      ArrowFunction = $__1.ArrowFunction,
      FunctionDeclaration = $__1.FunctionDeclaration,
      FunctionExpression = $__1.FunctionExpression,
      GetAccessor = $__1.GetAccessor,
      Method = $__1.Method,
      SetAccessor = $__1.SetAccessor;
  function SkipFunctionsTransformerTrait(ParseTreeTransformer) {
    return function($__super) {
      function SkipFunctionsTransformer() {
        $traceurRuntime.superConstructor(SkipFunctionsTransformer).apply(this, arguments);
      }
      return ($traceurRuntime.createClass)(SkipFunctionsTransformer, {
        transformFunctionDeclaration: function(tree) {
          var annotations = this.transformList(tree.annotations);
          if (annotations === tree.annotations) {
            return tree;
          }
          return new FunctionDeclaration(tree.location, tree.name, tree.functionKind, tree.parameterList, tree.typeAnnotation, annotations, tree.body);
        },
        transformFunctionExpression: function(tree) {
          var annotations = this.transformList(tree.annotations);
          if (annotations === tree.annotations) {
            return tree;
          }
          return new FunctionDeclaration(tree.location, tree.name, tree.functionKind, tree.parameterList, tree.typeAnnotation, annotations, tree.body);
        },
        transformSetAccessor: function(tree) {
          var name = this.transformAny(tree.name);
          var annotations = this.transformList(tree.annotations);
          if (name === tree.name && annotations === tree.annotations) {
            return tree;
          }
          return new SetAccessor(tree.location, tree.isStatic, name, tree.parameterList, annotations, tree.body);
        },
        transformGetAccessor: function(tree) {
          var name = this.transformAny(tree.name);
          var annotations = this.transformList(tree.annotations);
          if (name === tree.name && annotations === tree.annotations) {
            return tree;
          }
          return new GetAccessor(tree.location, tree.isStatic, name, annotations, tree.body);
        },
        transformMethod: function(tree) {
          var name = this.transformAny(tree.name);
          var annotations = this.transformList(tree.annotations);
          if (name === tree.name && annotations === tree.annotations) {
            return tree;
          }
          return new Method(tree.location, tree.isStatic, tree.functionKind, name, tree.parameterList, tree.typeAnnotation, annotations, tree.body, tree.debugName);
        },
        transformArrowFunction: function(tree) {
          return tree;
        }
      }, {}, $__super);
    }(ParseTreeTransformer);
  }
  var $__default = SkipFunctionsTransformerTrait;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformer.js";
  var alphaRenameThisAndArguments = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./alphaRenameThisAndArguments.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformer.js")).default;
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformer.js")),
      createArgumentList = $__2.createArgumentList,
      createBlock = $__2.createBlock,
      createFunctionBody = $__2.createFunctionBody,
      id = $__2.createIdentifierExpression,
      createMemberExpression = $__2.createMemberExpression,
      createThisExpression = $__2.createThisExpression,
      createVariableDeclaration = $__2.createVariableDeclaration,
      createVariableDeclarationList = $__2.createVariableDeclarationList,
      createVariableStatement = $__2.createVariableStatement;
  var parseStatement = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformer.js")).parseStatement;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformer.js")).TempVarTransformer;
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformer.js")),
      AwaitExpression = $__5.AwaitExpression,
      Block = $__5.Block,
      CallExpression = $__5.CallExpression,
      Catch = $__5.Catch;
  var SkipFunctionsTransformerTrait = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./SkipFunctionsTransformerTrait.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformer.js")).default;
  var ARGUMENTS = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformer.js")).ARGUMENTS;
  var VAR = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformer.js")).VAR;
  var AsyncGeneratorTransformer = function($__super) {
    function AsyncGeneratorTransformer(identifierGenerator, reporter, options) {
      $traceurRuntime.superConstructor(AsyncGeneratorTransformer).call(this, identifierGenerator, reporter, options);
      this.variableDeclarations_ = [];
      this.ctx_ = id(this.getTempIdentifier());
    }
    return ($traceurRuntime.createClass)(AsyncGeneratorTransformer, {
      transformYieldExpression: function(tree) {
        var argList = createArgumentList([tree.expression]);
        if (tree.isYieldFor) {
          return new AwaitExpression(tree.location, new CallExpression(null, createMemberExpression(this.ctx_, 'yieldFor'), argList));
        }
        return new CallExpression(tree.location, createMemberExpression(this.ctx_, 'yield'), argList);
      },
      transformCatch: function(tree) {
        var body = tree.catchBody;
        body = new Block(body.location, $traceurRuntime.spread([parseStatement($traceurRuntime.getTemplateObject(["\n        if (", ".inReturn) {\n          throw undefined;\n        }"]), this.ctx_)], body.statements));
        return new Catch(tree.location, tree.binding, body);
      },
      transformAsyncGeneratorBody_: function(tree, name) {
        tree = this.transformAny(tree);
        tree = alphaRenameThisAndArguments(this, tree);
        var statements = [];
        if (this.variableDeclarations_.length > 0) {
          statements.push(createVariableStatement(createVariableDeclarationList(VAR, this.variableDeclarations_)));
        }
        var body = createBlock(tree.statements);
        statements.push(parseStatement($traceurRuntime.getTemplateObject(["\n        return $traceurRuntime.createAsyncGeneratorInstance(\n            async function (", ") {\n                ", "\n            }, ", ");"]), this.ctx_, body, name));
        return createFunctionBody(statements);
      },
      addTempVarForArguments: function() {
        var tmpVarName = this.getTempIdentifier();
        this.variableDeclarations_.push(createVariableDeclaration(tmpVarName, id(ARGUMENTS)));
        return tmpVarName;
      },
      addTempVarForThis: function() {
        var tmpVarName = this.getTempIdentifier();
        this.variableDeclarations_.push(createVariableDeclaration(tmpVarName, createThisExpression()));
        return tmpVarName;
      }
    }, {transformAsyncGeneratorBody: function(identifierGenerator, reporter, options, body, name) {
        return new AsyncGeneratorTransformer(identifierGenerator, reporter, options).transformAsyncGeneratorBody_(body, name);
      }}, $__super);
  }(SkipFunctionsTransformerTrait(TempVarTransformer));
  return {get AsyncGeneratorTransformer() {
      return AsyncGeneratorTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformPass.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformPass.js";
  var AsyncGeneratorTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./AsyncGeneratorTransformer.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformPass.js")).AsyncGeneratorTransformer;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformPass.js")).TempVarTransformer;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformPass.js")),
      AnonBlock = $__3.AnonBlock,
      FunctionDeclaration = $__3.FunctionDeclaration,
      FunctionExpression = $__3.FunctionExpression;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformPass.js")),
      createBindingIdentifier = $__4.createBindingIdentifier,
      id = $__4.createIdentifierExpression,
      createIdentifierToken = $__4.createIdentifierToken;
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/AsyncGeneratorTransformPass.js")),
      parseExpression = $__5.parseExpression,
      parseStatement = $__5.parseStatement;
  var AsyncGeneratorTransformPass = function($__super) {
    function AsyncGeneratorTransformPass(identifierGenerator, reporter, options) {
      $traceurRuntime.superConstructor(AsyncGeneratorTransformPass).call(this, identifierGenerator, reporter, options);
      this.transformOptions_ = options.transformOptions;
      this.inBlock_ = false;
    }
    return ($traceurRuntime.createClass)(AsyncGeneratorTransformPass, {
      needsTransform_: function(tree) {
        return this.transformOptions_.asyncGenerators && tree.isAsyncGenerator();
      },
      transformFunctionDeclaration: function(tree) {
        if (!this.needsTransform_(tree))
          return $traceurRuntime.superGet(this, AsyncGeneratorTransformPass.prototype, "transformFunctionDeclaration").call(this, tree);
        var nameIdExpression = id(tree.name.identifierToken);
        var setupPrototypeExpression = parseExpression($traceurRuntime.getTemplateObject(["$traceurRuntime.initAsyncGeneratorFunction(", ")"]), nameIdExpression);
        var tmpVar = id(this.inBlock_ ? this.getTempIdentifier() : this.addTempVar(setupPrototypeExpression));
        var funcDecl = this.transformFunction_(tree, FunctionDeclaration, tmpVar);
        if (!this.inBlock_)
          return funcDecl;
        return new AnonBlock(null, [funcDecl, parseStatement($traceurRuntime.getTemplateObject(["var ", " = ", ""]), tmpVar, setupPrototypeExpression)]);
      },
      transformFunctionExpression: function(tree) {
        if (!this.needsTransform_(tree)) {
          return $traceurRuntime.superGet(this, AsyncGeneratorTransformPass.prototype, "transformFunctionExpression").call(this, tree);
        }
        var name;
        if (!tree.name) {
          name = createIdentifierToken(this.getTempIdentifier());
          tree = new FunctionExpression(tree.location, createBindingIdentifier(name), tree.functionKind, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body);
        } else {
          name = tree.name.identifierToken;
        }
        var functionExpression = this.transformFunction_(tree, FunctionExpression, id(name));
        return parseExpression($traceurRuntime.getTemplateObject(["$traceurRuntime.initAsyncGeneratorFunction(", ")"]), functionExpression);
      },
      transformFunction_: function(tree, constructor, nameExpression) {
        var body = $traceurRuntime.superGet(this, AsyncGeneratorTransformPass.prototype, "transformAny").call(this, tree.body);
        body = AsyncGeneratorTransformer.transformAsyncGeneratorBody(this.identifierGenerator, this.reporter, this.options, body, nameExpression);
        var functionKind = null;
        return new constructor(tree.location, tree.name, functionKind, tree.parameterList, tree.typeAnnotation || null, tree.annotations || null, body);
      },
      transformBlock: function(tree) {
        var inBlock = this.inBlock_;
        this.inBlock_ = true;
        var rv = $traceurRuntime.superGet(this, AsyncGeneratorTransformPass.prototype, "transformBlock").call(this, tree);
        this.inBlock_ = inBlock;
        return rv;
      }
    }, {}, $__super);
  }(TempVarTransformer);
  return {get AsyncGeneratorTransformPass() {
      return AsyncGeneratorTransformPass;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/FindArguments.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/FindArguments.js";
  var ARGUMENTS = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/FindArguments.js")).ARGUMENTS;
  var FindInFunctionScope = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FindInFunctionScope.js", "traceur@0.0.108/src/codegeneration/FindArguments.js")).FindInFunctionScope;
  var FindArguments = function($__super) {
    function FindArguments() {
      $traceurRuntime.superConstructor(FindArguments).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(FindArguments, {visitIdentifierExpression: function(tree) {
        if (tree.identifierToken.value === ARGUMENTS) {
          this.found = true;
        }
      }}, {}, $__super);
  }(FindInFunctionScope);
  return {get default() {
      return FindArguments;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/AsyncToGeneratorTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/AsyncToGeneratorTransformer.js";
  var ARGUMENTS = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/AsyncToGeneratorTransformer.js")).ARGUMENTS;
  var FindArguments = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FindArguments.js", "traceur@0.0.108/src/codegeneration/AsyncToGeneratorTransformer.js")).default;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/AsyncToGeneratorTransformer.js")),
      FunctionBody = $__3.FunctionBody,
      FunctionDeclaration = $__3.FunctionDeclaration,
      FunctionExpression = $__3.FunctionExpression,
      Method = $__3.Method,
      YieldExpression = $__3.YieldExpression;
  var ParenTrait = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParenTrait.js", "traceur@0.0.108/src/codegeneration/AsyncToGeneratorTransformer.js")).ParenTrait;
  var parseStatement = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/AsyncToGeneratorTransformer.js")).parseStatement;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/AsyncToGeneratorTransformer.js")).TempVarTransformer;
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/AsyncToGeneratorTransformer.js")),
      createIdentifierExpression = $__7.createIdentifierExpression,
      createNullLiteral = $__7.createNullLiteral;
  var AsyncToGeneratorTransformer = function($__super) {
    function AsyncToGeneratorTransformer(identifierGenerator, reporter, options) {
      $traceurRuntime.superConstructor(AsyncToGeneratorTransformer).call(this, identifierGenerator, reporter, options);
      this.inAsyncFunction_ = false;
    }
    return ($traceurRuntime.createClass)(AsyncToGeneratorTransformer, {
      transformFunctionDeclaration: function(tree) {
        if (tree.isAsyncFunction()) {
          return this.transformFunctionShared_(tree, FunctionDeclaration);
        }
        return $traceurRuntime.superGet(this, AsyncToGeneratorTransformer.prototype, "transformFunctionDeclaration").call(this, tree);
      },
      transformFunctionExpression: function(tree) {
        if (tree.isAsyncFunction()) {
          return this.transformFunctionShared_(tree, FunctionExpression);
        }
        return $traceurRuntime.superGet(this, AsyncToGeneratorTransformer.prototype, "transformFunctionExpression").call(this, tree);
      },
      transformFunctionShared_: function(tree, ctor) {
        var parameterList = this.transformAny(tree.parameterList);
        var typeAnnotation = this.transformAny(tree.typeAnnotation);
        var annotations = this.transformList(tree.annotations);
        var body = this.transformAsyncBody_(tree.body);
        return new ctor(tree.location, tree.name, null, parameterList, typeAnnotation, annotations, body);
      },
      transformAsyncBody_: function(body) {
        var inAsyncFunction = this.inAsyncFunction_;
        this.inAsyncFunction_ = true;
        body = this.transformFunctionBody(body);
        body = wrapBodyInSpawn(body);
        this.inAsyncFunction_ = inAsyncFunction;
        return body;
      },
      transformMethod: function(tree) {
        if (tree.isAsyncFunction()) {
          var name = this.transformAny(tree.name);
          var parameterList = this.transformAny(tree.parameterList);
          var typeAnnotation = this.transformAny(tree.typeAnnotation);
          var annotations = this.transformList(tree.annotations);
          var body = this.transformAsyncBody_(tree.body);
          return new Method(tree.location, tree.isStatic, null, name, parameterList, typeAnnotation, annotations, body, tree.debugName);
        }
        return $traceurRuntime.superGet(this, AsyncToGeneratorTransformer.prototype, "transformMethod").call(this, tree);
      },
      transformAwaitExpression: function(tree) {
        if (this.inAsyncFunction_) {
          var expression = this.transformAny(tree.expression);
          return new YieldExpression(tree.location, expression, false);
        }
        return $traceurRuntime.superGet(this, AsyncToGeneratorTransformer.prototype, "transformAwaitExpression").call(this, tree);
      }
    }, {}, $__super);
  }(ParenTrait(TempVarTransformer));
  function wrapBodyInSpawn(body) {
    var visitor = new FindArguments();
    visitor.visitAny(body);
    var argExpr = visitor.found ? createIdentifierExpression(ARGUMENTS) : createNullLiteral();
    var statement = parseStatement($traceurRuntime.getTemplateObject(["return $traceurRuntime.spawn(this, ", ", function*() { ", " });"]), argExpr, body);
    return new FunctionBody(body.location, [statement]);
  }
  return {get AsyncToGeneratorTransformer() {
      return AsyncToGeneratorTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/FindIdentifiers.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/FindIdentifiers.js";
  var ScopeVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../semantics/ScopeVisitor.js", "traceur@0.0.108/src/codegeneration/FindIdentifiers.js")).ScopeVisitor;
  var FindIdentifiers = function($__super) {
    function FindIdentifiers(tree, filterFunction) {
      $traceurRuntime.superConstructor(FindIdentifiers).call(this);
      this.filterFunction_ = filterFunction;
      this.found_ = false;
      this.visitAny(tree);
    }
    return ($traceurRuntime.createClass)(FindIdentifiers, {
      visitIdentifierExpression: function(tree) {
        if (this.filterFunction_(tree.identifierToken.value, this.scope.tree)) {
          this.found = true;
        }
      },
      get found() {
        return this.found_;
      },
      set found(v) {
        if (v) {
          this.found_ = true;
        }
      },
      visitAny: function(tree) {
        !this.found_ && tree && tree.visit(this);
      },
      visitList: function(list) {
        if (list) {
          for (var i = 0; !this.found_ && i < list.length; i++) {
            this.visitAny(list[i]);
          }
        }
      }
    }, {}, $__super);
  }(ScopeVisitor);
  return {get FindIdentifiers() {
      return FindIdentifiers;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/FnExtractAbruptCompletions.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/FnExtractAbruptCompletions.js";
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/FnExtractAbruptCompletions.js")).ParseTreeTransformer;
  var alphaRenameThisAndArguments = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./alphaRenameThisAndArguments.js", "traceur@0.0.108/src/codegeneration/FnExtractAbruptCompletions.js")).default;
  var parseStatement = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/FnExtractAbruptCompletions.js")).parseStatement;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/FnExtractAbruptCompletions.js")),
      AnonBlock = $__6.AnonBlock,
      BreakStatement = $__6.BreakStatement,
      ContinueStatement = $__6.ContinueStatement,
      FormalParameterList = $__6.FormalParameterList,
      FunctionExpression = $__6.FunctionExpression,
      ReturnStatement = $__6.ReturnStatement,
      YieldExpression = $__6.YieldExpression;
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/FnExtractAbruptCompletions.js")),
      createArgumentList = $__7.createArgumentList,
      createAssignmentStatement = $__7.createAssignmentStatement,
      createAssignmentExpression = $__7.createAssignmentExpression,
      createBlock = $__7.createBlock,
      createCallExpression = $__7.createCallExpression,
      createCaseClause = $__7.createCaseClause,
      createDefaultClause = $__7.createDefaultClause,
      createExpressionStatement = $__7.createExpressionStatement,
      createFunctionBody = $__7.createFunctionBody,
      createFunctionExpression = $__7.createFunctionExpression,
      createIdentifierExpression = $__7.createIdentifierExpression,
      createNumberLiteral = $__7.createNumberLiteral,
      createObjectLiteralForDescriptor = $__7.createObjectLiteralForDescriptor,
      createSwitchStatement = $__7.createSwitchStatement,
      createThisExpression = $__7.createThisExpression,
      createVariableDeclaration = $__7.createVariableDeclaration,
      createVariableDeclarationList = $__7.createVariableDeclarationList,
      createVariableStatement = $__7.createVariableStatement,
      createVoid0 = $__7.createVoid0;
  var ARGUMENTS = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/FnExtractAbruptCompletions.js")).ARGUMENTS;
  var SkipFunctionsTransformerTrait = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./SkipFunctionsTransformerTrait.js", "traceur@0.0.108/src/codegeneration/FnExtractAbruptCompletions.js")).default;
  var StringSet = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/StringSet.js", "traceur@0.0.108/src/codegeneration/FnExtractAbruptCompletions.js")).StringSet;
  var Token = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/Token.js", "traceur@0.0.108/src/codegeneration/FnExtractAbruptCompletions.js")).Token;
  var $__12 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/FnExtractAbruptCompletions.js")),
      STAR = $__12.STAR,
      VAR = $__12.VAR;
  var FnExtractAbruptCompletions = function($__super) {
    function FnExtractAbruptCompletions(idGenerator, requestParentLabel) {
      $traceurRuntime.superConstructor(FnExtractAbruptCompletions).call(this);
      this.idGenerator_ = idGenerator;
      this.inLoop_ = 0;
      this.inBreakble_ = 0;
      this.variableDeclarations_ = [];
      this.extractedStatements_ = [];
      this.requestParentLabel_ = requestParentLabel;
      this.labelledStatements_ = new StringSet();
    }
    return ($traceurRuntime.createClass)(FnExtractAbruptCompletions, {
      createIIFE: function(body, paramList, argsList, inGenerator) {
        body = this.transformAny(body);
        body = alphaRenameThisAndArguments(this, body);
        var tmpFnName = this.idGenerator_.generateUniqueIdentifier();
        var functionKind = inGenerator ? new Token(STAR, null) : null;
        var functionExpression = new FunctionExpression(null, null, functionKind, new FormalParameterList(null, paramList), null, [], createFunctionBody(body.statements || [body]));
        this.variableDeclarations_.push(createVariableDeclaration(tmpFnName, functionExpression));
        var functionCall = createCallExpression(createIdentifierExpression(tmpFnName), createArgumentList(argsList));
        if (inGenerator) {
          functionCall = new YieldExpression(null, functionCall, true);
        }
        var loopBody = null;
        if (this.extractedStatements_.length || this.hasReturns) {
          var tmpVarName = createIdentifierExpression(this.idGenerator_.generateUniqueIdentifier());
          this.variableDeclarations_.push(createVariableDeclaration(tmpVarName, null));
          var maybeReturn;
          if (this.hasReturns) {
            maybeReturn = parseStatement($traceurRuntime.getTemplateObject(["if (typeof ", " === \"object\")\n            return ", ".v;"]), tmpVarName, tmpVarName);
          }
          if (this.extractedStatements_.length) {
            var caseClauses = this.extractedStatements_.map(function(statement, index) {
              return createCaseClause(createNumberLiteral(index), [statement]);
            });
            if (maybeReturn) {
              caseClauses.push(createDefaultClause([maybeReturn]));
            }
            loopBody = createBlock([createExpressionStatement(createAssignmentExpression(tmpVarName, functionCall)), createSwitchStatement(tmpVarName, caseClauses)]);
          } else {
            loopBody = createBlock([createExpressionStatement(createAssignmentExpression(tmpVarName, functionCall)), maybeReturn]);
          }
        } else {
          loopBody = createBlock([createExpressionStatement(functionCall)]);
        }
        return {
          variableStatements: createVariableStatement(createVariableDeclarationList(VAR, this.variableDeclarations_)),
          loopBody: loopBody
        };
      },
      addTempVarForArguments: function() {
        var tmpVarName = this.idGenerator_.generateUniqueIdentifier();
        this.variableDeclarations_.push(createVariableDeclaration(tmpVarName, createIdentifierExpression(ARGUMENTS)));
        return tmpVarName;
      },
      addTempVarForThis: function() {
        var tmpVarName = this.idGenerator_.generateUniqueIdentifier();
        this.variableDeclarations_.push(createVariableDeclaration(tmpVarName, createThisExpression()));
        return tmpVarName;
      },
      transformAny: function(tree) {
        if (tree) {
          if (tree.isBreakableStatement())
            this.inBreakble_++;
          if (tree.isIterationStatement())
            this.inLoop_++;
          tree = $traceurRuntime.superGet(this, FnExtractAbruptCompletions.prototype, "transformAny").call(this, tree);
          if (tree.isBreakableStatement())
            this.inBreakble_--;
          if (tree.isIterationStatement())
            this.inLoop_--;
        }
        return tree;
      },
      transformReturnStatement: function(tree) {
        this.hasReturns = true;
        return new ReturnStatement(tree.location, createObjectLiteralForDescriptor({v: tree.expression || createVoid0()}));
      },
      transformAbruptCompletion_: function(tree) {
        this.extractedStatements_.push(tree);
        var index = this.extractedStatements_.length - 1;
        return parseStatement($traceurRuntime.getTemplateObject(["return ", ";"]), index);
      },
      transformBreakStatement: function(tree) {
        if (!tree.name) {
          if (this.inBreakble_) {
            return $traceurRuntime.superGet(this, FnExtractAbruptCompletions.prototype, "transformBreakStatement").call(this, tree);
          } else {
            tree = new BreakStatement(tree.location, this.requestParentLabel_());
          }
        } else if (this.labelledStatements_.has(tree.name.value)) {
          return $traceurRuntime.superGet(this, FnExtractAbruptCompletions.prototype, "transformBreakStatement").call(this, tree);
        }
        return this.transformAbruptCompletion_(tree);
      },
      transformContinueStatement: function(tree) {
        if (!tree.name) {
          if (this.inLoop_) {
            return $traceurRuntime.superGet(this, FnExtractAbruptCompletions.prototype, "transformContinueStatement").call(this, tree);
          } else {
            tree = new ContinueStatement(tree.location, this.requestParentLabel_());
          }
        } else if (this.labelledStatements_.has(tree.name.value)) {
          return $traceurRuntime.superGet(this, FnExtractAbruptCompletions.prototype, "transformContinueStatement").call(this, tree);
        }
        return this.transformAbruptCompletion_(tree);
      },
      transformLabelledStatement: function(tree) {
        this.labelledStatements_.add(tree.name.value);
        return $traceurRuntime.superGet(this, FnExtractAbruptCompletions.prototype, "transformLabelledStatement").call(this, tree);
      },
      transformVariableStatement: function(tree) {
        var $__2 = this;
        if (tree.declarations.declarationType === VAR) {
          var assignments = [];
          tree.declarations.declarations.forEach(function(variableDeclaration) {
            var variableName = variableDeclaration.lvalue.getStringValue();
            var initializer = $traceurRuntime.superGet($__2, FnExtractAbruptCompletions.prototype, "transformAny").call($__2, variableDeclaration.initializer);
            $__2.variableDeclarations_.push(createVariableDeclaration(variableName, null));
            assignments.push(createAssignmentStatement(createIdentifierExpression(variableName), initializer));
          });
          return new AnonBlock(null, assignments);
        }
        return $traceurRuntime.superGet(this, FnExtractAbruptCompletions.prototype, "transformVariableStatement").call(this, tree);
      }
    }, {createIIFE: function(idGenerator, body, paramList, argsList, requestParentLabel, inGenerator) {
        return new FnExtractAbruptCompletions(idGenerator, requestParentLabel).createIIFE(body, paramList, argsList, inGenerator);
      }}, $__super);
  }(SkipFunctionsTransformerTrait(ParseTreeTransformer));
  return {get FnExtractAbruptCompletions() {
      return FnExtractAbruptCompletions;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/semantics/ScopeReferences.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/semantics/ScopeReferences.js";
  var Scope = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./Scope.js", "traceur@0.0.108/src/semantics/ScopeReferences.js")).Scope;
  var StringSet = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/StringSet.js", "traceur@0.0.108/src/semantics/ScopeReferences.js")).StringSet;
  var ScopeReferences = function($__super) {
    function ScopeReferences(parent, tree) {
      $traceurRuntime.superConstructor(ScopeReferences).call(this, parent, tree);
      this.freeVars_ = new StringSet();
    }
    return ($traceurRuntime.createClass)(ScopeReferences, {
      addReference: function(name) {
        this.freeVars_.add(name);
      },
      hasFreeVariable: function(name) {
        return this.freeVars_.has(name);
      }
    }, {}, $__super);
  }(Scope);
  return {get ScopeReferences() {
      return ScopeReferences;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/semantics/ScopeChainBuilderWithReferences.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/semantics/ScopeChainBuilderWithReferences.js";
  var ScopeChainBuilder = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ScopeChainBuilder.js", "traceur@0.0.108/src/semantics/ScopeChainBuilderWithReferences.js")).ScopeChainBuilder;
  var ScopeReferences = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ScopeReferences.js", "traceur@0.0.108/src/semantics/ScopeChainBuilderWithReferences.js")).ScopeReferences;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/semantics/ScopeChainBuilderWithReferences.js")),
      FUNCTION_DECLARATION = $__3.FUNCTION_DECLARATION,
      FUNCTION_EXPRESSION = $__3.FUNCTION_EXPRESSION,
      GET_ACCESSOR = $__3.GET_ACCESSOR,
      IDENTIFIER_EXPRESSION = $__3.IDENTIFIER_EXPRESSION,
      METHOD = $__3.METHOD,
      MODULE = $__3.MODULE,
      SET_ACCESSOR = $__3.SET_ACCESSOR;
  var TYPEOF = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/semantics/ScopeChainBuilderWithReferences.js")).TYPEOF;
  function hasArgumentsInScope(scope) {
    for (; scope; scope = scope.parent) {
      switch (scope.tree.type) {
        case FUNCTION_DECLARATION:
        case FUNCTION_EXPRESSION:
        case GET_ACCESSOR:
        case METHOD:
        case SET_ACCESSOR:
          return true;
      }
    }
    return false;
  }
  function inModuleScope(scope) {
    for (; scope; scope = scope.parent) {
      if (scope.tree.type === MODULE) {
        return true;
      }
    }
    return false;
  }
  var ScopeChainBuilderWithReferences = function($__super) {
    function ScopeChainBuilderWithReferences() {
      $traceurRuntime.superConstructor(ScopeChainBuilderWithReferences).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(ScopeChainBuilderWithReferences, {
      createScope: function(tree) {
        return new ScopeReferences(this.scope, tree);
      },
      visitIdentifierExpression: function(tree) {
        if (this.inWithBlock) {
          return;
        }
        var scope = this.scope;
        var name = tree.getStringValue();
        if (name === 'arguments' && hasArgumentsInScope(scope)) {
          return;
        }
        if (name === '__moduleName' && inModuleScope(scope)) {
          return;
        }
        this.referenceFound(tree, name);
      },
      visitUnaryExpression: function(tree) {
        if (tree.operator.type === TYPEOF && tree.operand.type === IDENTIFIER_EXPRESSION) {
          var scope = this.scope;
          var binding = scope.getBinding(tree.operand);
          if (!binding) {
            scope.addVar(tree.operand, this.reporter);
          }
        } else {
          $traceurRuntime.superGet(this, ScopeChainBuilderWithReferences.prototype, "visitUnaryExpression").call(this, tree);
        }
      },
      referenceFound: function(tree, name) {
        this.scope.addReference(name);
      }
    }, {}, $__super);
  }(ScopeChainBuilder);
  return {get ScopeChainBuilderWithReferences() {
      return ScopeChainBuilderWithReferences;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js";
  var AlphaRenamer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./AlphaRenamer.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")).AlphaRenamer;
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")),
      ANON_BLOCK = $__7.ANON_BLOCK,
      BINDING_IDENTIFIER = $__7.BINDING_IDENTIFIER,
      FOR_IN_STATEMENT = $__7.FOR_IN_STATEMENT,
      FOR_OF_STATEMENT = $__7.FOR_OF_STATEMENT,
      VARIABLE_DECLARATION_LIST = $__7.VARIABLE_DECLARATION_LIST;
  var $__8 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")),
      AnonBlock = $__8.AnonBlock,
      BindingElement = $__8.BindingElement,
      BindingIdentifier = $__8.BindingIdentifier,
      Block = $__8.Block,
      Catch = $__8.Catch,
      DoWhileStatement = $__8.DoWhileStatement,
      ForInStatement = $__8.ForInStatement,
      ForStatement = $__8.ForStatement,
      FormalParameter = $__8.FormalParameter,
      FunctionBody = $__8.FunctionBody,
      FunctionExpression = $__8.FunctionExpression,
      LabelledStatement = $__8.LabelledStatement,
      LiteralPropertyName = $__8.LiteralPropertyName,
      Module = $__8.Module,
      ObjectPatternField = $__8.ObjectPatternField,
      Script = $__8.Script,
      VariableDeclaration = $__8.VariableDeclaration,
      VariableDeclarationList = $__8.VariableDeclarationList,
      VariableStatement = $__8.VariableStatement,
      WhileStatement = $__8.WhileStatement;
  var IdentifierToken = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/IdentifierToken.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")).IdentifierToken;
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")).ParseTreeTransformer;
  var VAR = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")).VAR;
  var $__12 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")),
      createBindingIdentifier = $__12.createBindingIdentifier,
      createIdentifierExpression = $__12.createIdentifierExpression,
      createIdentifierToken = $__12.createIdentifierToken;
  var FindIdentifiers = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FindIdentifiers.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")).FindIdentifiers;
  var FindVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FindVisitor.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")).FindVisitor;
  var FnExtractAbruptCompletions = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FnExtractAbruptCompletions.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")).FnExtractAbruptCompletions;
  var ScopeChainBuilderWithReferences = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../semantics/ScopeChainBuilderWithReferences.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")).ScopeChainBuilderWithReferences;
  var parseExpression = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")).parseExpression;
  var prependStatements = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PrependStatements.js", "traceur@0.0.108/src/codegeneration/BlockBindingTransformer.js")).prependStatements;
  function varNeedsInitializer(tree, loopTree) {
    if (loopTree === null)
      return false;
    var type = loopTree.type;
    if (type !== FOR_IN_STATEMENT && type !== FOR_OF_STATEMENT)
      return true;
    return loopTree.initializer.declarations[0] !== tree;
  }
  var BlockBindingTransformer = function($__super) {
    function BlockBindingTransformer(idGenerator, reporter, tree) {
      var scopeBuilder = arguments[3];
      var latestScope = arguments[4];
      $traceurRuntime.superConstructor(BlockBindingTransformer).call(this);
      this.idGenerator_ = idGenerator;
      this.reporter_ = reporter;
      if (!scopeBuilder) {
        scopeBuilder = new ScopeChainBuilderWithReferences(reporter);
        scopeBuilder.visitAny(tree);
      }
      this.scopeBuilder_ = scopeBuilder;
      this.labelledLoops_ = new Map();
      this.prependStatement_ = [];
      this.prependBlockStatement_ = [];
      this.blockRenames_ = [];
      this.rootTree_ = tree;
      if (latestScope) {
        this.scope_ = latestScope;
      } else {
        this.pushScope(tree);
      }
      this.usedVars_ = this.scope_.getAllBindingNames();
      this.maybeRename_ = false;
      this.inObjectPattern_ = false;
      this.currentLoopTree_ = null;
    }
    return ($traceurRuntime.createClass)(BlockBindingTransformer, {
      getVariableName_: function(variable) {
        var lvalue = variable.lvalue;
        if (lvalue.type === BINDING_IDENTIFIER) {
          return lvalue.getStringValue();
        }
        throw new Error('Unexpected destructuring declaration found.');
      },
      flushRenames: function(tree) {
        tree = renameAll(this.blockRenames_, tree);
        this.blockRenames_.length = 0;
        return tree;
      },
      pushScope: function(tree) {
        var scope = this.scopeBuilder_.getScopeForTree(tree);
        if (!scope)
          throw new Error('BlockBindingTransformer tree with no scope');
        if (this.scope_)
          this.scope_.blockBindingRenames = this.blockRenames_;
        this.scope_ = scope;
        this.blockRenames_ = [];
        return scope;
      },
      popScope: function(scope) {
        if (this.scope_ !== scope) {
          throw new Error('BlockBindingTransformer scope mismatch');
        }
        this.scope_ = scope.parent;
        this.blockRenames_ = this.scope_ && this.scope_.blockBindingRenames || [];
      },
      revisitTreeForScopes: function(tree) {
        this.scopeBuilder_.scope = this.scope_;
        this.scopeBuilder_.visitAny(tree);
        this.scopeBuilder_.scope = null;
      },
      needsRename_: function(name) {
        if (this.usedVars_.has(name))
          return true;
        var scope = this.scope_;
        var parent = scope.parent;
        if (!parent || scope.isVarScope)
          return false;
        var varScope = scope.getVarScope();
        if (varScope && varScope.hasFreeVariable(name)) {
          return true;
        }
        var parentBinding = parent.getBindingByName(name);
        if (!parentBinding)
          return false;
        var currentBinding = scope.getBindingByName(name);
        if (currentBinding.tree === parentBinding.tree)
          return false;
        return true;
      },
      newNameFromOrig: function(origName, renames) {
        var newName;
        if (this.needsRename_(origName)) {
          newName = origName + this.idGenerator_.generateUniqueIdentifier();
          renames.push(new Rename(origName, newName));
        } else {
          this.usedVars_.add(origName);
          newName = origName;
        }
        return newName;
      },
      transformFunctionBody: function(tree) {
        if (tree === this.rootTree_ || !this.rootTree_) {
          tree = $traceurRuntime.superGet(this, BlockBindingTransformer.prototype, "transformFunctionBody").call(this, tree);
          if (this.prependStatement_.length || this.blockRenames_.length) {
            var statements = prependStatements.apply((void 0), $traceurRuntime.spread([tree.statements], this.prependStatement_));
            tree = new FunctionBody(tree.location, statements);
            tree = this.flushRenames(tree);
          }
        } else {
          var functionTransform = new BlockBindingTransformer(this.idGenerator_, this.reporter_, tree, this.scopeBuilder_, this.scope_);
          var functionBodyTree = functionTransform.transformAny(tree);
          if (functionBodyTree === tree) {
            return tree;
          }
          tree = new FunctionBody(tree.location, functionBodyTree.statements);
        }
        return tree;
      },
      transformScript: function(tree) {
        if (tree === this.rootTree_ || !this.rootTree_) {
          tree = $traceurRuntime.superGet(this, BlockBindingTransformer.prototype, "transformScript").call(this, tree);
          if (this.prependStatement_.length || this.blockRenames_.length) {
            var scriptItemList = prependStatements.apply((void 0), $traceurRuntime.spread([tree.scriptItemList], this.prependStatement_));
            tree = new Script(tree.location, scriptItemList, tree.moduleName);
            tree = this.flushRenames(tree);
          }
        } else {
          var functionTransform = new BlockBindingTransformer(this.idGenerator_, this.reporter_, tree, this.scopeBuilder_);
          var newTree = functionTransform.transformAny(tree);
          if (newTree === tree) {
            return tree;
          }
          tree = new Script(tree.location, newTree.scriptItemList, tree.moduleName);
        }
        return tree;
      },
      transformModule: function(tree) {
        if (tree === this.rootTree_ || !this.rootTree_) {
          tree = $traceurRuntime.superGet(this, BlockBindingTransformer.prototype, "transformModule").call(this, tree);
          if (this.prependStatement_.length || this.blockRenames_.length) {
            var scriptItemList = prependStatements.apply((void 0), $traceurRuntime.spread([tree.scriptItemList], this.prependStatement_));
            tree = new Module(tree.location, scriptItemList, tree.moduleName);
            tree = this.flushRenames(tree);
          }
        } else {
          var functionTransform = new BlockBindingTransformer(this.idGenerator_, this.reporter_, tree, this.scopeBuilder_);
          var newTree = functionTransform.transformAny(tree);
          if (newTree === tree) {
            return tree;
          }
          tree = new Module(tree.location, newTree.scriptItemList, tree.moduleName);
        }
        return tree;
      },
      transformVariableStatement: function(tree) {
        var declarations = this.transformAny(tree.declarations);
        if (declarations.type === ANON_BLOCK) {
          return declarations;
        }
        if (declarations === tree.declarations) {
          return tree;
        }
        return new VariableStatement(tree.location, declarations);
      },
      transformVariableDeclarationList: function(tree) {
        if (tree.declarationType === VAR) {
          return $traceurRuntime.superGet(this, BlockBindingTransformer.prototype, "transformVariableDeclarationList").call(this, tree);
        }
        this.maybeRename_ = !this.scope_.isVarScope;
        var declarations = this.transformList(tree.declarations);
        this.maybeRename_ = false;
        return new VariableDeclarationList(tree.location, VAR, declarations);
      },
      transformVariableDeclaration: function(tree) {
        var maybeRename = this.maybeRename_;
        var lvalue = this.transformAny(tree.lvalue);
        this.maybeRename_ = false;
        var initializer = null;
        if (tree.initializer) {
          initializer = this.transformAny(tree.initializer);
        } else if (varNeedsInitializer(tree, this.currentLoopTree_)) {
          initializer = parseExpression($traceurRuntime.getTemplateObject(["void 0"]));
        }
        this.maybeRename_ = maybeRename;
        if (tree.lvalue === lvalue && tree.initializer === initializer) {
          return tree;
        }
        return new VariableDeclaration(tree.location, lvalue, tree.typeAnnotation, initializer);
      },
      transformBindingIdentifier: function(tree) {
        if (this.maybeRename_) {
          var origName = tree.getStringValue();
          var newName = this.newNameFromOrig(origName, this.blockRenames_);
          if (origName === newName) {
            return tree;
          }
          var newToken = new IdentifierToken(tree.location, newName);
          var bindingIdentifier = new BindingIdentifier(tree.location, newToken);
          this.scope_.renameBinding(origName, bindingIdentifier, VAR, this.reporter_);
          return bindingIdentifier;
        }
        return $traceurRuntime.superGet(this, BlockBindingTransformer.prototype, "transformBindingIdentifier").call(this, tree);
      },
      transformBindingElement: function(tree) {
        var maybeRename = this.maybeRename_;
        var inObjectPattern = this.inObjectPattern_;
        var binding = this.transformAny(tree.binding);
        this.maybeRename_ = false;
        this.inObjectPattern_ = false;
        var initializer = this.transformAny(tree.initializer);
        this.maybeRename_ = maybeRename;
        this.inObjectPattern_ = inObjectPattern;
        if (tree.binding === binding && tree.initializer === initializer) {
          return tree;
        }
        var bindingElement = new BindingElement(tree.location, binding, initializer);
        if (this.inObjectPattern_ && tree.binding !== binding && tree.binding.type === BINDING_IDENTIFIER) {
          return new ObjectPatternField(tree.location, new LiteralPropertyName(tree.location, tree.binding.identifierToken), bindingElement);
        }
        return bindingElement;
      },
      transformObjectPattern: function(tree) {
        var inObjectPattern = this.inObjectPattern_;
        this.inObjectPattern_ = true;
        var transformed = $traceurRuntime.superGet(this, BlockBindingTransformer.prototype, "transformObjectPattern").call(this, tree);
        this.inObjectPattern_ = inObjectPattern;
        return transformed;
      },
      transformObjectPatternField: function(tree) {
        var name = this.transformAny(tree.name);
        this.inObjectPattern_ = false;
        var element = this.transformAny(tree.element);
        this.inObjectPattern_ = true;
        if (tree.name === name && tree.element === element) {
          return tree;
        }
        return new ObjectPatternField(tree.location, name, element);
      },
      transformBlock: function(tree) {
        var scope = this.pushScope(tree);
        var outerPrepends = this.prependBlockStatement_;
        this.prependBlockStatement_ = [];
        tree = $traceurRuntime.superGet(this, BlockBindingTransformer.prototype, "transformBlock").call(this, tree);
        if (this.prependBlockStatement_.length) {
          tree = new Block(tree.location, prependStatements.apply((void 0), $traceurRuntime.spread([tree.statements], this.prependBlockStatement_)));
        }
        this.prependBlockStatement_ = outerPrepends;
        tree = this.flushRenames(tree);
        this.popScope(scope);
        return tree;
      },
      transformCatch: function(tree) {
        var scope = this.pushScope(tree);
        var binding = this.transformAny(tree.binding);
        var statements = this.transformList(tree.catchBody.statements);
        if (binding !== tree.binding || statements !== tree.catchBody.statements) {
          tree = new Catch(tree.location, binding, new Block(tree.catchBody.location, statements));
        }
        tree = this.flushRenames(tree);
        this.popScope(scope);
        return tree;
      },
      transformFunctionForScope_: function(func, tree) {
        var scope = this.pushScope(tree);
        tree = func();
        tree = this.flushRenames(tree);
        this.popScope(scope);
        return tree;
      },
      transformGetAccessor: function(tree) {
        var $__3 = this;
        return this.transformFunctionForScope_(function() {
          return $traceurRuntime.superGet($__3, BlockBindingTransformer.prototype, "transformGetAccessor").call($__3, tree);
        }, tree);
      },
      transformSetAccessor: function(tree) {
        var $__3 = this;
        return this.transformFunctionForScope_(function() {
          return $traceurRuntime.superGet($__3, BlockBindingTransformer.prototype, "transformSetAccessor").call($__3, tree);
        }, tree);
      },
      transformFunctionExpression: function(tree) {
        var $__3 = this;
        return this.transformFunctionForScope_(function() {
          return $traceurRuntime.superGet($__3, BlockBindingTransformer.prototype, "transformFunctionExpression").call($__3, tree);
        }, tree);
      },
      transformFunctionDeclaration: function(tree) {
        var $__3 = this;
        if (!this.scope_.isVarScope) {
          var origName = tree.name.getStringValue();
          var newName = this.newNameFromOrig(origName, this.blockRenames_);
          var functionExpression = new FunctionExpression(tree.location, null, tree.functionKind, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body);
          this.revisitTreeForScopes(functionExpression);
          functionExpression = this.transformAny(functionExpression);
          var bindingIdentifier = createBindingIdentifier(newName);
          var statement = new VariableStatement(tree.location, new VariableDeclarationList(tree.location, VAR, [new VariableDeclaration(tree.location, bindingIdentifier, null, functionExpression)]));
          this.scope_.renameBinding(origName, bindingIdentifier, VAR, this.reporter_);
          this.prependBlockStatement_.push(statement);
          return new AnonBlock(null, []);
        }
        return this.transformFunctionForScope_(function() {
          return $traceurRuntime.superGet($__3, BlockBindingTransformer.prototype, "transformFunctionDeclaration").call($__3, tree);
        }, tree);
      },
      transformLoop_: function(func, tree, loopFactory) {
        var $__3 = this;
        var scope,
            initializerIsBlockBinding;
        if (tree.initializer && tree.initializer.type === VARIABLE_DECLARATION_LIST && tree.initializer.declarationType !== VAR) {
          initializerIsBlockBinding = true;
        }
        if (initializerIsBlockBinding) {
          scope = this.pushScope(tree);
        }
        var finder = new FindBlockBindingInLoop(tree, this.scopeBuilder_);
        finder.visitAny(tree);
        if (!finder.found) {
          var callFunc = function() {
            var currentLoopTree = $__3.currentLoopTree_;
            $__3.currentLoopTree_ = tree;
            var rv = func(tree);
            $__3.currentLoopTree_ = currentLoopTree;
            return rv;
          };
          if (!initializerIsBlockBinding) {
            return callFunc();
          }
          var renames = [];
          var initializer = new VariableDeclarationList(null, VAR, tree.initializer.declarations.map(function(declaration) {
            var origName = $__3.getVariableName_(declaration);
            var newName = $__3.newNameFromOrig(origName, renames);
            var bindingIdentifier = createBindingIdentifier(newName);
            $__3.scope_.renameBinding(origName, bindingIdentifier, VAR, $__3.reporter_);
            return new VariableDeclaration(null, bindingIdentifier, null, declaration.initializer);
          }));
          initializer = renameAll(renames, initializer);
          tree = loopFactory(initializer, renames, renameAll(renames, tree.body));
          this.revisitTreeForScopes(tree);
          tree = callFunc();
        } else {
          var iifeParameterList = [];
          var iifeArgumentList = [];
          var renames$__4 = [];
          var initializer$__5 = null;
          if (tree.initializer) {
            if (tree.initializer.type === VARIABLE_DECLARATION_LIST && tree.initializer.declarationType !== VAR) {
              initializer$__5 = new VariableDeclarationList(null, VAR, tree.initializer.declarations.map(function(declaration) {
                var origName = $__3.getVariableName_(declaration);
                var newName = $__3.newNameFromOrig(origName, renames$__4);
                iifeArgumentList.push(createIdentifierExpression(newName));
                iifeParameterList.push(new FormalParameter(null, new BindingElement(null, createBindingIdentifier(origName), null), null, []));
                var bindingIdentifier = createBindingIdentifier(newName);
                $__3.scope_.renameBinding(origName, bindingIdentifier, VAR, $__3.reporter_);
                return new VariableDeclaration(null, bindingIdentifier, null, declaration.initializer);
              }));
              initializer$__5 = renameAll(renames$__4, initializer$__5);
            } else {
              initializer$__5 = this.transformAny(tree.initializer);
            }
          }
          var loopLabel = this.labelledLoops_.get(tree);
          var iifeInfo = FnExtractAbruptCompletions.createIIFE(this.idGenerator_, tree.body, iifeParameterList, iifeArgumentList, function() {
            return loopLabel = loopLabel || createIdentifierToken($__3.idGenerator_.generateUniqueIdentifier());
          }, this.scope_.inGenerator);
          tree = loopFactory(initializer$__5, renames$__4, iifeInfo.loopBody);
          if (loopLabel) {
            tree = new LabelledStatement(tree.location, loopLabel, tree);
          }
          tree = new AnonBlock(tree.location, [iifeInfo.variableStatements, tree]);
          this.revisitTreeForScopes(tree);
          tree = this.transformAny(tree);
        }
        if (initializerIsBlockBinding) {
          tree = this.flushRenames(tree);
          this.popScope(scope);
        }
        return tree;
      },
      transformForInStatement: function(tree) {
        var $__3 = this;
        return this.transformLoop_(function(t) {
          return $traceurRuntime.superGet($__3, BlockBindingTransformer.prototype, "transformForInStatement").call($__3, t);
        }, tree, function(initializer, renames, body) {
          return new ForInStatement(tree.location, initializer, renameAll(renames, tree.collection), body);
        });
      },
      transformForStatement: function(tree) {
        var $__3 = this;
        return this.transformLoop_(function(t) {
          return $traceurRuntime.superGet($__3, BlockBindingTransformer.prototype, "transformForStatement").call($__3, t);
        }, tree, function(initializer, renames, body) {
          return new ForStatement(tree.location, initializer, renameAll(renames, tree.condition), renameAll(renames, tree.increment), body);
        });
      },
      transformWhileStatement: function(tree) {
        var $__3 = this;
        return this.transformLoop_(function(t) {
          return $traceurRuntime.superGet($__3, BlockBindingTransformer.prototype, "transformWhileStatement").call($__3, t);
        }, tree, function(initializer, renames, body) {
          return new WhileStatement(tree.location, renameAll(renames, tree.condition), body);
        });
      },
      transformDoWhileStatement: function(tree) {
        var $__3 = this;
        return this.transformLoop_(function(t) {
          return $traceurRuntime.superGet($__3, BlockBindingTransformer.prototype, "transformDoWhileStatement").call($__3, t);
        }, tree, function(initializer, renames, body) {
          return new DoWhileStatement(tree.location, body, renameAll(renames, tree.condition));
        });
      },
      transformLabelledStatement: function(tree) {
        if (tree.statement.isIterationStatement()) {
          this.labelledLoops_.set(tree.statement, tree.name.value);
          var statement = this.transformAny(tree.statement);
          if (!statement.isStatement()) {
            return statement;
          }
          if (statement === tree.statement) {
            return tree;
          }
          return new LabelledStatement(tree.location, tree.name, statement);
        }
        return $traceurRuntime.superGet(this, BlockBindingTransformer.prototype, "transformLabelledStatement").call(this, tree);
      }
    }, {}, $__super);
  }(ParseTreeTransformer);
  var Rename = function() {
    function Rename(oldName, newName) {
      this.oldName = oldName;
      this.newName = newName;
    }
    return ($traceurRuntime.createClass)(Rename, {}, {});
  }();
  function renameAll(renames, tree) {
    renames.forEach(function(rename) {
      tree = AlphaRenamer.rename(tree, rename.oldName, rename.newName);
    });
    return tree;
  }
  var FindBlockBindingInLoop = function($__super) {
    function FindBlockBindingInLoop(tree, scopeBuilder) {
      $traceurRuntime.superConstructor(FindBlockBindingInLoop).call(this);
      this.scopeBuilder_ = scopeBuilder;
      this.topScope_ = scopeBuilder.getScopeForTree(tree) || scopeBuilder.getScopeForTree(tree.body);
      this.outOfScope_ = null;
      this.acceptLoop_ = tree.isIterationStatement();
    }
    return ($traceurRuntime.createClass)(FindBlockBindingInLoop, {
      visitForInStatement: function(tree) {
        var $__3 = this;
        this.visitLoop_(tree, function() {
          return $traceurRuntime.superGet($__3, FindBlockBindingInLoop.prototype, "visitForInStatement").call($__3, tree);
        });
      },
      visitForStatement: function(tree) {
        var $__3 = this;
        this.visitLoop_(tree, function() {
          return $traceurRuntime.superGet($__3, FindBlockBindingInLoop.prototype, "visitForStatement").call($__3, tree);
        });
      },
      visitWhileStatement: function(tree) {
        var $__3 = this;
        this.visitLoop_(tree, function() {
          return $traceurRuntime.superGet($__3, FindBlockBindingInLoop.prototype, "visitWhileStatement").call($__3, tree);
        });
      },
      visitDoWhileStatement: function(tree) {
        var $__3 = this;
        this.visitLoop_(tree, function() {
          return $traceurRuntime.superGet($__3, FindBlockBindingInLoop.prototype, "visitDoWhileStatement").call($__3, tree);
        });
      },
      visitLoop_: function(tree, func) {
        if (this.acceptLoop_) {
          this.acceptLoop_ = false;
        } else if (!this.outOfScope_) {
          this.outOfScope_ = this.scopeBuilder_.getScopeForTree(tree) || this.scopeBuilder_.getScopeForTree(tree.body);
        }
        func();
      },
      visitArrowFunction: function(tree) {
        this.visitFunction_(tree);
      },
      visitFunctionDeclaration: function(tree) {
        this.visitFunction_(tree);
      },
      visitFunctionExpression: function(tree) {
        this.visitFunction_(tree);
      },
      visitGetAccessor: function(tree) {
        this.visitFunction_(tree);
      },
      visitMethod: function(tree) {
        this.visitFunction_(tree);
      },
      visitSetAccessor: function(tree) {
        this.visitFunction_(tree);
      },
      visitFunction_: function(tree) {
        var $__3 = this;
        this.found = new FindIdentifiers(tree, function(identifierToken, identScope) {
          identScope = $__3.scopeBuilder_.getScopeForTree(identScope);
          var fnScope = $__3.outOfScope_ || $__3.scopeBuilder_.getScopeForTree(tree);
          if (identScope.hasLexicalBindingName(identifierToken)) {
            return false;
          }
          while (identScope !== fnScope && (identScope = identScope.parent)) {
            if (identScope.hasLexicalBindingName(identifierToken)) {
              return false;
            }
          }
          while (fnScope = fnScope.parent) {
            if (fnScope.hasLexicalBindingName(identifierToken)) {
              return true;
            }
            if (fnScope.hasVariableBindingName(identifierToken)) {
              return false;
            }
            if (fnScope === $__3.topScope_)
              break;
          }
          return false;
        }).found;
      }
    }, {}, $__super);
  }(FindVisitor);
  return {get BlockBindingTransformer() {
      return BlockBindingTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/MakeStrictTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/MakeStrictTransformer.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/MakeStrictTransformer.js")),
      FunctionBody = $__1.FunctionBody,
      Script = $__1.Script;
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/MakeStrictTransformer.js")).ParseTreeTransformer;
  var createUseStrictDirective = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/MakeStrictTransformer.js")).createUseStrictDirective;
  var hasUseStrict = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../semantics/util.js", "traceur@0.0.108/src/codegeneration/MakeStrictTransformer.js")).hasUseStrict;
  function prepend(statements) {
    return $traceurRuntime.spread([createUseStrictDirective()], statements);
  }
  var MakeStrictTransformer = function($__super) {
    function MakeStrictTransformer() {
      $traceurRuntime.superConstructor(MakeStrictTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(MakeStrictTransformer, {
      transformScript: function(tree) {
        if (hasUseStrict(tree.scriptItemList))
          return tree;
        return new Script(tree.location, prepend(tree.scriptItemList), tree.moduleName);
      },
      transformFunctionBody: function(tree) {
        if (hasUseStrict(tree.statements))
          return tree;
        return new FunctionBody(tree.location, prepend(tree.statements));
      }
    }, {transformTree: function(tree) {
        return new MakeStrictTransformer().transformAny(tree);
      }}, $__super);
  }(ParseTreeTransformer);
  return {get MakeStrictTransformer() {
      return MakeStrictTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ClassTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ClassTransformer.js";
  var CONSTRUCTOR = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/ClassTransformer.js")).CONSTRUCTOR;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/ClassTransformer.js")),
      AnonBlock = $__3.AnonBlock,
      ClassExpression = $__3.ClassExpression,
      ExportDeclaration = $__3.ExportDeclaration,
      ExportSpecifier = $__3.ExportSpecifier,
      ExportSpecifierSet = $__3.ExportSpecifierSet,
      FunctionDeclaration = $__3.FunctionDeclaration,
      FunctionExpression = $__3.FunctionExpression,
      GetAccessor = $__3.GetAccessor,
      Method = $__3.Method,
      NamedExport = $__3.NamedExport,
      SetAccessor = $__3.SetAccessor;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/ClassTransformer.js")),
      CLASS_DECLARATION = $__4.CLASS_DECLARATION,
      COMPUTED_PROPERTY_NAME = $__4.COMPUTED_PROPERTY_NAME,
      EXPORT_DEFAULT = $__4.EXPORT_DEFAULT,
      GET_ACCESSOR = $__4.GET_ACCESSOR,
      LITERAL_PROPERTY_NAME = $__4.LITERAL_PROPERTY_NAME,
      METHOD = $__4.METHOD,
      SET_ACCESSOR = $__4.SET_ACCESSOR;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/ClassTransformer.js")).TempVarTransformer;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/ClassTransformer.js")),
      CONST = $__6.CONST,
      LET = $__6.LET,
      VAR = $__6.VAR,
      STRING = $__6.STRING;
  var MakeStrictTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./MakeStrictTransformer.js", "traceur@0.0.108/src/codegeneration/ClassTransformer.js")).MakeStrictTransformer;
  var ParenTrait = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParenTrait.js", "traceur@0.0.108/src/codegeneration/ClassTransformer.js")).ParenTrait;
  var $__9 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/ClassTransformer.js")),
      createBindingIdentifier = $__9.createBindingIdentifier,
      id = $__9.createIdentifierExpression,
      createIdentifierToken = $__9.createIdentifierToken,
      createObjectLiteral = $__9.createObjectLiteral,
      createVariableStatement = $__9.createVariableStatement;
  var hasUseStrict = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../semantics/util.js", "traceur@0.0.108/src/codegeneration/ClassTransformer.js")).hasUseStrict;
  var $__11 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/ClassTransformer.js")),
      parseExpression = $__11.parseExpression,
      parsePropertyDefinition = $__11.parsePropertyDefinition,
      parseStatement = $__11.parseStatement;
  function classCall(func, object, staticObject, superClass) {
    if (superClass) {
      return parseExpression($traceurRuntime.getTemplateObject(["($traceurRuntime.createClass)(", ", ", ", ", ",\n                                       ", ")"]), func, object, staticObject, superClass);
    }
    return parseExpression($traceurRuntime.getTemplateObject(["($traceurRuntime.createClass)(", ", ", ", ", ")"]), func, object, staticObject);
  }
  function methodNameFromTree(tree) {
    if (tree.type === COMPUTED_PROPERTY_NAME) {
      return '';
    }
    if (tree.literalToken && tree.literalToken.type === STRING) {
      return tree.getStringValue().substr(1, -1);
    }
    return tree.getStringValue();
  }
  function classMethodDebugName(className, methodName, isStatic) {
    if (isStatic) {
      return createBindingIdentifier('$__' + className + '_' + methodName);
    }
    return createBindingIdentifier('$__' + className + '_prototype_' + methodName);
  }
  function functionExpressionToDeclaration(tree, name) {
    if (tree.name === null) {
      name = createBindingIdentifier(name);
    } else {
      name = tree.name;
    }
    return new FunctionDeclaration(tree.location, name, tree.functionKind, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body);
  }
  function removeStaticModifier(tree) {
    switch (tree.type) {
      case GET_ACCESSOR:
        return new GetAccessor(tree.location, false, tree.name, tree.typeAnnotation, tree.annotations, tree.body);
      case SET_ACCESSOR:
        return new SetAccessor(tree.location, false, tree.name, tree.parameterList, tree.annotations, tree.body);
      case METHOD:
        return new Method(tree.location, false, tree.functionKind, tree.name, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body, tree.debugName);
      default:
        throw new Error('unreachable');
    }
  }
  function isConstructor(tree) {
    if (tree.type !== METHOD || tree.isStatic || tree.functionKind !== null) {
      return false;
    }
    var name = tree.name;
    return name.type === LITERAL_PROPERTY_NAME && name.literalToken.value === CONSTRUCTOR;
  }
  var $__default = isConstructor;
  var ClassTransformer = function($__super) {
    function ClassTransformer(identifierGenerator, reporter, options) {
      $traceurRuntime.superConstructor(ClassTransformer).call(this, identifierGenerator, reporter, options);
      this.strictCount_ = 0;
      this.state_ = null;
    }
    return ($traceurRuntime.createClass)(ClassTransformer, {
      transformModule: function(tree) {
        this.strictCount_ = 1;
        return $traceurRuntime.superGet(this, ClassTransformer.prototype, "transformModule").call(this, tree);
      },
      transformScript: function(tree) {
        this.strictCount_ = hasUseStrict(tree.scriptItemList) ? 1 : 0;
        return $traceurRuntime.superGet(this, ClassTransformer.prototype, "transformScript").call(this, tree);
      },
      transformFunctionBody: function(tree) {
        var useStrict = hasUseStrict(tree.statements) ? 1 : 0;
        this.strictCount_ += useStrict;
        var result = $traceurRuntime.superGet(this, ClassTransformer.prototype, "transformFunctionBody").call(this, tree);
        this.strictCount_ -= useStrict;
        return result;
      },
      makeStrict_: function(tree) {
        if (this.strictCount_)
          return tree;
        return MakeStrictTransformer.transformTree(tree);
      },
      transformClassDeclaration: function(tree) {
        var classExpression = new ClassExpression(tree.location, tree.name, tree.superClass, tree.elements, tree.annotations, tree.typeParameters);
        var transformed = this.transformClassExpression(classExpression);
        var useLet = !this.options.transformOptions.blockBinding && this.options.parseOptions.blockBinding;
        return createVariableStatement(useLet ? LET : VAR, tree.name, transformed);
      },
      transformClassExpression: function(tree) {
        var superClass = this.transformAny(tree.superClass);
        var elements = this.transformList(tree.elements);
        var annotations = this.transformList(tree.annotations);
        var constructor = null;
        var protoElements = elements.filter(function(tree) {
          if (tree.isStatic)
            return false;
          if (isConstructor(tree)) {
            constructor = tree;
            return false;
          }
          return true;
        });
        var staticElements = elements.filter(function(tree) {
          return tree.isStatic;
        }).map(removeStaticModifier);
        var protoObject = createObjectLiteral(protoElements);
        var staticObject = createObjectLiteral(staticElements);
        if (!constructor) {
          constructor = this.getDefaultConstructor_(tree);
        }
        var func = new FunctionExpression(tree.location, tree.name, null, constructor.parameterList, null, annotations, constructor.body);
        var expression;
        if (tree.name) {
          var functionStatement;
          var name = tree.name.identifierToken;
          var nameId = id(("" + name));
          if (!this.options.transformOptions.blockBinding && this.options.parseOptions.blockBinding) {
            functionStatement = createVariableStatement(CONST, tree.name, func);
          } else {
            functionStatement = functionExpressionToDeclaration(func, name);
          }
          if (superClass) {
            expression = parseExpression($traceurRuntime.getTemplateObject(["function($__super) {\n          ", ";\n          return ($traceurRuntime.createClass)(", ", ", ",\n                                               ", ", $__super);\n        }(", ")"]), functionStatement, nameId, protoObject, staticObject, superClass);
          } else {
            expression = parseExpression($traceurRuntime.getTemplateObject(["function() {\n          ", ";\n          return ($traceurRuntime.createClass)(", ", ", ",\n                                               ", ");\n        }()"]), functionStatement, nameId, protoObject, staticObject);
          }
        } else {
          expression = classCall(func, protoObject, staticObject, superClass);
        }
        return this.makeStrict_(expression);
      },
      transformExportDeclaration: function(tree) {
        if (tree.declaration.type === EXPORT_DEFAULT && tree.declaration.expression.type === CLASS_DECLARATION) {
          return this.transformExportDefaultClass_(tree.declaration);
        }
        return $traceurRuntime.superGet(this, ClassTransformer.prototype, "transformExportDeclaration").call(this, tree);
      },
      transformExportDefaultClass_: function(tree) {
        var name = tree.expression.name.identifierToken;
        var specifier = new ExportSpecifier(name.location, name, createIdentifierToken('default'));
        var exportTree = new ExportSpecifierSet(name.location, [specifier]);
        var named = new NamedExport(name.location, exportTree, null);
        var exp = new ExportDeclaration(name.location, named, []);
        var classTree = this.transformAny(tree.expression);
        return new AnonBlock(null, [classTree, exp]);
      },
      getDefaultConstructor_: function(tree) {
        if (tree.superClass) {
          var name = id(tree.name.identifierToken);
          return parsePropertyDefinition($traceurRuntime.getTemplateObject(["constructor() {\n        $traceurRuntime.superConstructor(", ").apply(this, arguments)\n      }"]), name);
        }
        return parsePropertyDefinition($traceurRuntime.getTemplateObject(["constructor() {}"]));
      }
    }, {}, $__super);
  }(ParenTrait(TempVarTransformer));
  return {
    get default() {
      return $__default;
    },
    get ClassTransformer() {
      return ClassTransformer;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ClosureModuleTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ClosureModuleTransformer.js";
  var ModuleTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ModuleTransformer.js", "traceur@0.0.108/src/codegeneration/ClosureModuleTransformer.js")).ModuleTransformer;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/ClosureModuleTransformer.js")),
      createIdentifierExpression = $__4.createIdentifierExpression,
      createMemberExpression = $__4.createMemberExpression,
      createPropertyNameAssignment = $__4.createPropertyNameAssignment;
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/ClosureModuleTransformer.js")),
      EXPORT_DEFAULT = $__5.EXPORT_DEFAULT,
      EXPORT_SPECIFIER = $__5.EXPORT_SPECIFIER;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/ClosureModuleTransformer.js")),
      parseExpression = $__6.parseExpression,
      parseStatement = $__6.parseStatement,
      parseStatements = $__6.parseStatements;
  var prependStatements = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PrependStatements.js", "traceur@0.0.108/src/codegeneration/ClosureModuleTransformer.js")).prependStatements;
  var ClosureModuleTransformer = function($__super) {
    function ClosureModuleTransformer() {
      $traceurRuntime.superConstructor(ClosureModuleTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(ClosureModuleTransformer, {
      moduleProlog: function() {
        if (!this.moduleName) {
          throw new Error('Closure modules (goog.module) require a moduleName');
        }
        return parseStatements($traceurRuntime.getTemplateObject(["goog.module(", ");"]), this.moduleName);
      },
      wrapModule: function(statements) {
        if (this.hasStarExports()) {
          throw new Error('Closure modules (goog.module) do not support "export *"');
        }
        return statements;
      },
      appendExportStatement: function(statements) {
        if (!this.hasExports())
          return statements;
        var exportObject = this.getExportObject();
        statements.push(parseStatement($traceurRuntime.getTemplateObject(["exports = ", ""]), exportObject));
        return statements;
      },
      getGetterExport: function($__1) {
        var $__2 = $__1,
            name = $__2.name,
            tree = $__2.tree,
            moduleSpecifier = $__2.moduleSpecifier;
        var expression;
        switch (tree.type) {
          case EXPORT_DEFAULT:
            expression = createIdentifierExpression('$__default');
            break;
          case EXPORT_SPECIFIER:
            if (moduleSpecifier) {
              var idName = this.getTempVarNameForModuleSpecifier(moduleSpecifier);
              expression = createMemberExpression(idName, tree.lhs);
            } else {
              expression = createPropertyNameAssignment(name, tree.lhs);
            }
            break;
          default:
            expression = createIdentifierExpression(name);
            break;
        }
        return createPropertyNameAssignment(name, expression);
      },
      transformModuleSpecifier: function(tree) {
        var moduleName = tree.token.processedValue;
        return parseExpression($traceurRuntime.getTemplateObject(["goog.require(", ")"]), moduleName);
      }
    }, {}, $__super);
  }(ModuleTransformer);
  return {get ClosureModuleTransformer() {
      return ClosureModuleTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/CommonJsModuleTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/CommonJsModuleTransformer.js";
  var ModuleTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ModuleTransformer.js", "traceur@0.0.108/src/codegeneration/CommonJsModuleTransformer.js")).ModuleTransformer;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/CommonJsModuleTransformer.js")),
      CALL_EXPRESSION = $__3.CALL_EXPRESSION,
      GET_ACCESSOR = $__3.GET_ACCESSOR,
      OBJECT_LITERAL = $__3.OBJECT_LITERAL,
      PROPERTY_NAME_ASSIGNMENT = $__3.PROPERTY_NAME_ASSIGNMENT,
      RETURN_STATEMENT = $__3.RETURN_STATEMENT;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/CommonJsModuleTransformer.js")),
      ArgumentList = $__4.ArgumentList,
      CallExpression = $__4.CallExpression,
      ExpressionStatement = $__4.ExpressionStatement;
  var assert = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/assert.js", "traceur@0.0.108/src/codegeneration/CommonJsModuleTransformer.js")).assert;
  var globalThis = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./globalThis.js", "traceur@0.0.108/src/codegeneration/CommonJsModuleTransformer.js")).default;
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/CommonJsModuleTransformer.js")),
      parseExpression = $__7.parseExpression,
      parsePropertyDefinition = $__7.parsePropertyDefinition,
      parseStatements = $__7.parseStatements;
  var scopeContainsThis = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./scopeContainsThis.js", "traceur@0.0.108/src/codegeneration/CommonJsModuleTransformer.js")).default;
  var $__9 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/CommonJsModuleTransformer.js")),
      createEmptyParameterList = $__9.createEmptyParameterList,
      createFunctionExpression = $__9.createFunctionExpression,
      createIdentifierExpression = $__9.createIdentifierExpression,
      createObjectLiteral = $__9.createObjectLiteral,
      createPropertyNameAssignment = $__9.createPropertyNameAssignment,
      createVariableStatement = $__9.createVariableStatement,
      createVariableDeclaration = $__9.createVariableDeclaration,
      createVariableDeclarationList = $__9.createVariableDeclarationList;
  var VAR = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/CommonJsModuleTransformer.js")).VAR;
  var CommonJsModuleTransformer = function($__super) {
    function CommonJsModuleTransformer(identifierGenerator, reporter) {
      var options = arguments[2];
      $traceurRuntime.superConstructor(CommonJsModuleTransformer).call(this, identifierGenerator, reporter, options);
      this.moduleVars_ = [];
      this.anonymousModule = options && !options.bundle && options.moduleName !== true;
    }
    return ($traceurRuntime.createClass)(CommonJsModuleTransformer, {
      getModuleName: function(tree) {
        if (this.anonymousModule)
          return null;
        return tree.moduleName;
      },
      moduleProlog: function() {
        var statements = $traceurRuntime.superGet(this, CommonJsModuleTransformer.prototype, "moduleProlog").call(this);
        if (this.moduleVars_.length) {
          var tmpVarDeclarations = createVariableStatement(createVariableDeclarationList(VAR, this.moduleVars_.map(function(varName) {
            return createVariableDeclaration(varName, null);
          })));
          statements.push(tmpVarDeclarations);
        }
        return statements;
      },
      wrapModule: function(statements) {
        var needsIife = statements.some(scopeContainsThis);
        if (needsIife) {
          return parseStatements($traceurRuntime.getTemplateObject(["module.exports = function() {\n            ", "\n          }.call(", ");"]), statements, globalThis());
        }
        var last = statements[statements.length - 1];
        statements = statements.slice(0, -1);
        assert(last.type === RETURN_STATEMENT);
        var exportExpression = last.expression;
        if (this.hasExports()) {
          var exportStatement = this.transformExportExpressionToModuleExport(exportExpression);
          statements = statements.concat(exportStatement);
        }
        return statements;
      },
      transformExportExpressionToModuleExport: function(tree) {
        var expression;
        if (tree.type === CALL_EXPRESSION) {
          var descriptors = this.transformObjectLiteralToDescriptors(tree.args.args[0]);
          var object = parseExpression($traceurRuntime.getTemplateObject(["Object.defineProperties(module.exports, ", ")"]), descriptors);
          var newArgs = new ArgumentList(tree.args.location, $traceurRuntime.spread([object], tree.args.args.slice(1)));
          expression = new CallExpression(tree.location, tree.operand, newArgs);
        } else {
          var descriptors$__1 = this.transformObjectLiteralToDescriptors(tree);
          expression = parseExpression($traceurRuntime.getTemplateObject(["Object.defineProperties(module.exports, ", ")"]), descriptors$__1);
        }
        return new ExpressionStatement(expression.location, expression);
      },
      transformObjectLiteralToDescriptors: function(literalTree) {
        assert(literalTree.type === OBJECT_LITERAL);
        var props = literalTree.propertyNameAndValues.map(function(exp) {
          var descriptor;
          switch (exp.type) {
            case GET_ACCESSOR:
              {
                var getterFunction = createFunctionExpression(createEmptyParameterList(), exp.body);
                descriptor = parseExpression($traceurRuntime.getTemplateObject(["{get: ", "}"]), getterFunction);
                break;
              }
            case PROPERTY_NAME_ASSIGNMENT:
              descriptor = parseExpression($traceurRuntime.getTemplateObject(["{value: ", "}"]), exp.value);
              break;
            default:
              throw new Error(("Unexpected property type " + exp.type));
          }
          return createPropertyNameAssignment(exp.name, descriptor);
        });
        return createObjectLiteral(props);
      },
      transformModuleSpecifier: function(tree) {
        var moduleName = tree.token.processedValue;
        var tmpVar = this.getTempVarNameForModuleSpecifier(tree);
        this.moduleVars_.push(tmpVar);
        var tvId = createIdentifierExpression(tmpVar);
        return parseExpression($traceurRuntime.getTemplateObject(["(", " = require(", "),\n        ", " && ", ".__esModule && ", " || {default: ", "})"]), tvId, moduleName, tvId, tvId, tvId, tvId);
      },
      getExportProperties: function() {
        var properties = $traceurRuntime.superGet(this, CommonJsModuleTransformer.prototype, "getExportProperties").call(this);
        if (this.exportVisitor_.hasExports())
          properties.push(parsePropertyDefinition($traceurRuntime.getTemplateObject(["__esModule: true"])));
        return properties;
      }
    }, {}, $__super);
  }(ModuleTransformer);
  return {get CommonJsModuleTransformer() {
      return CommonJsModuleTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ParameterTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ParameterTransformer.js";
  var FunctionBody = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/ParameterTransformer.js")).FunctionBody;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/ParameterTransformer.js")).TempVarTransformer;
  var prependStatements = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PrependStatements.js", "traceur@0.0.108/src/codegeneration/ParameterTransformer.js")).prependStatements;
  var stack = [];
  var ParameterTransformer = function($__super) {
    function ParameterTransformer() {
      $traceurRuntime.superConstructor(ParameterTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(ParameterTransformer, {
      transformArrowFunction: function(tree) {
        stack.push([]);
        return $traceurRuntime.superGet(this, ParameterTransformer.prototype, "transformArrowFunction").call(this, tree);
      },
      transformFunctionDeclaration: function(tree) {
        stack.push([]);
        return $traceurRuntime.superGet(this, ParameterTransformer.prototype, "transformFunctionDeclaration").call(this, tree);
      },
      transformFunctionExpression: function(tree) {
        stack.push([]);
        return $traceurRuntime.superGet(this, ParameterTransformer.prototype, "transformFunctionExpression").call(this, tree);
      },
      transformGetAccessor: function(tree) {
        stack.push([]);
        return $traceurRuntime.superGet(this, ParameterTransformer.prototype, "transformGetAccessor").call(this, tree);
      },
      transformSetAccessor: function(tree) {
        stack.push([]);
        return $traceurRuntime.superGet(this, ParameterTransformer.prototype, "transformSetAccessor").call(this, tree);
      },
      transformMethod: function(tree) {
        stack.push([]);
        return $traceurRuntime.superGet(this, ParameterTransformer.prototype, "transformMethod").call(this, tree);
      },
      transformFunctionBody: function(tree) {
        var transformedTree = $traceurRuntime.superGet(this, ParameterTransformer.prototype, "transformFunctionBody").call(this, tree);
        var statements = stack.pop();
        if (!statements.length)
          return transformedTree;
        statements = prependStatements.apply((void 0), $traceurRuntime.spread([transformedTree.statements], statements));
        return new FunctionBody(transformedTree.location, statements);
      },
      get parameterStatements() {
        return stack[stack.length - 1];
      },
      transformConstructorType: function(tree) {
        return tree;
      },
      transformFunctionType: function(tree) {
        return tree;
      }
    }, {}, $__super);
  }(TempVarTransformer);
  return {get ParameterTransformer() {
      return ParameterTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/DefaultParametersTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/DefaultParametersTransformer.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../semantics/util.js", "traceur@0.0.108/src/codegeneration/DefaultParametersTransformer.js")),
      isUndefined = $__1.isUndefined,
      isVoidExpression = $__1.isVoidExpression;
  var FormalParameterList = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/DefaultParametersTransformer.js")).FormalParameterList;
  var ParameterTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParameterTransformer.js", "traceur@0.0.108/src/codegeneration/DefaultParametersTransformer.js")).ParameterTransformer;
  var ARGUMENTS = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/DefaultParametersTransformer.js")).ARGUMENTS;
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/DefaultParametersTransformer.js")),
      NOT_EQUAL_EQUAL = $__5.NOT_EQUAL_EQUAL,
      VAR = $__5.VAR;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/DefaultParametersTransformer.js")),
      createBinaryExpression = $__6.createBinaryExpression,
      createConditionalExpression = $__6.createConditionalExpression,
      createIdentifierExpression = $__6.createIdentifierExpression,
      createMemberLookupExpression = $__6.createMemberLookupExpression,
      createNumberLiteral = $__6.createNumberLiteral,
      createOperatorToken = $__6.createOperatorToken,
      createVariableStatement = $__6.createVariableStatement,
      createVoid0 = $__6.createVoid0;
  function createDefaultAssignment(index, binding, initializer) {
    var argumentsExpression = createMemberLookupExpression(createIdentifierExpression(ARGUMENTS), createNumberLiteral(index));
    var assignmentExpression;
    if (initializer === null || isUndefined(initializer) || isVoidExpression(initializer)) {
      assignmentExpression = argumentsExpression;
    } else {
      assignmentExpression = createConditionalExpression(createBinaryExpression(argumentsExpression, createOperatorToken(NOT_EQUAL_EQUAL), createVoid0()), argumentsExpression, initializer);
    }
    return createVariableStatement(VAR, binding, assignmentExpression);
  }
  var DefaultParametersTransformer = function($__super) {
    function DefaultParametersTransformer() {
      $traceurRuntime.superConstructor(DefaultParametersTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(DefaultParametersTransformer, {transformFormalParameterList: function(tree) {
        var parameters = [];
        var changed = false;
        var defaultToUndefined = false;
        for (var i = 0; i < tree.parameters.length; i++) {
          var param = this.transformAny(tree.parameters[i]);
          if (param !== tree.parameters[i])
            changed = true;
          if (param.isRestParameter() || !param.parameter.initializer && !defaultToUndefined) {
            parameters.push(param);
          } else {
            defaultToUndefined = true;
            changed = true;
            this.parameterStatements.push(createDefaultAssignment(i, param.parameter.binding, param.parameter.initializer));
          }
        }
        if (!changed)
          return tree;
        return new FormalParameterList(tree.location, parameters);
      }}, {}, $__super);
  }(ParameterTransformer);
  return {get DefaultParametersTransformer() {
      return DefaultParametersTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/assignmentOperatorToBinaryOperator.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/assignmentOperatorToBinaryOperator.js";
  var $__0 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/assignmentOperatorToBinaryOperator.js")),
      AMPERSAND = $__0.AMPERSAND,
      AMPERSAND_EQUAL = $__0.AMPERSAND_EQUAL,
      BAR = $__0.BAR,
      BAR_EQUAL = $__0.BAR_EQUAL,
      CARET = $__0.CARET,
      CARET_EQUAL = $__0.CARET_EQUAL,
      LEFT_SHIFT = $__0.LEFT_SHIFT,
      LEFT_SHIFT_EQUAL = $__0.LEFT_SHIFT_EQUAL,
      MINUS = $__0.MINUS,
      MINUS_EQUAL = $__0.MINUS_EQUAL,
      PERCENT = $__0.PERCENT,
      PERCENT_EQUAL = $__0.PERCENT_EQUAL,
      PLUS = $__0.PLUS,
      PLUS_EQUAL = $__0.PLUS_EQUAL,
      RIGHT_SHIFT = $__0.RIGHT_SHIFT,
      RIGHT_SHIFT_EQUAL = $__0.RIGHT_SHIFT_EQUAL,
      SLASH = $__0.SLASH,
      SLASH_EQUAL = $__0.SLASH_EQUAL,
      STAR = $__0.STAR,
      STAR_EQUAL = $__0.STAR_EQUAL,
      STAR_STAR = $__0.STAR_STAR,
      STAR_STAR_EQUAL = $__0.STAR_STAR_EQUAL,
      UNSIGNED_RIGHT_SHIFT = $__0.UNSIGNED_RIGHT_SHIFT,
      UNSIGNED_RIGHT_SHIFT_EQUAL = $__0.UNSIGNED_RIGHT_SHIFT_EQUAL;
  function assignmentOperatorToBinaryOperator(type) {
    switch (type) {
      case STAR_EQUAL:
        return STAR;
      case STAR_STAR_EQUAL:
        return STAR_STAR;
      case SLASH_EQUAL:
        return SLASH;
      case PERCENT_EQUAL:
        return PERCENT;
      case PLUS_EQUAL:
        return PLUS;
      case MINUS_EQUAL:
        return MINUS;
      case LEFT_SHIFT_EQUAL:
        return LEFT_SHIFT;
      case RIGHT_SHIFT_EQUAL:
        return RIGHT_SHIFT;
      case UNSIGNED_RIGHT_SHIFT_EQUAL:
        return UNSIGNED_RIGHT_SHIFT;
      case AMPERSAND_EQUAL:
        return AMPERSAND;
      case CARET_EQUAL:
        return CARET;
      case BAR_EQUAL:
        return BAR;
      default:
        throw Error('unreachable');
    }
  }
  var $__default = assignmentOperatorToBinaryOperator;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ExplodeExpressionTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ExplodeExpressionTransformer.js";
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/ExplodeExpressionTransformer.js")).ParseTreeTransformer;
  var $__13 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/ExplodeExpressionTransformer.js")),
      createAssignmentExpression = $__13.createAssignmentExpression,
      createCommaExpression = $__13.createCommaExpression,
      id = $__13.createIdentifierExpression,
      createMemberExpression = $__13.createMemberExpression,
      createNumberLiteral = $__13.createNumberLiteral,
      createOperatorToken = $__13.createOperatorToken,
      createParenExpression = $__13.createParenExpression;
  var $__14 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/ExplodeExpressionTransformer.js")),
      AND = $__14.AND,
      EQUAL = $__14.EQUAL,
      MINUS = $__14.MINUS,
      MINUS_EQUAL = $__14.MINUS_EQUAL,
      MINUS_MINUS = $__14.MINUS_MINUS,
      OR = $__14.OR,
      PLUS = $__14.PLUS,
      PLUS_EQUAL = $__14.PLUS_EQUAL,
      PLUS_PLUS = $__14.PLUS_PLUS;
  var $__15 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/ExplodeExpressionTransformer.js")),
      COMMA_EXPRESSION = $__15.COMMA_EXPRESSION,
      IDENTIFIER_EXPRESSION = $__15.IDENTIFIER_EXPRESSION,
      MEMBER_EXPRESSION = $__15.MEMBER_EXPRESSION,
      MEMBER_LOOKUP_EXPRESSION = $__15.MEMBER_LOOKUP_EXPRESSION,
      PROPERTY_NAME_ASSIGNMENT = $__15.PROPERTY_NAME_ASSIGNMENT,
      SPREAD_EXPRESSION = $__15.SPREAD_EXPRESSION,
      TEMPLATE_LITERAL_PORTION = $__15.TEMPLATE_LITERAL_PORTION;
  var $__16 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/ExplodeExpressionTransformer.js")),
      ArgumentList = $__16.ArgumentList,
      ArrayLiteral = $__16.ArrayLiteral,
      AwaitExpression = $__16.AwaitExpression,
      BinaryExpression = $__16.BinaryExpression,
      CallExpression = $__16.CallExpression,
      ClassExpression = $__16.ClassExpression,
      ConditionalExpression = $__16.ConditionalExpression,
      MemberExpression = $__16.MemberExpression,
      MemberLookupExpression = $__16.MemberLookupExpression,
      NewExpression = $__16.NewExpression,
      ObjectLiteral = $__16.ObjectLiteral,
      PropertyNameAssignment = $__16.PropertyNameAssignment,
      SpreadExpression = $__16.SpreadExpression,
      TemplateLiteralExpression = $__16.TemplateLiteralExpression,
      TemplateSubstitution = $__16.TemplateSubstitution,
      UnaryExpression = $__16.UnaryExpression,
      YieldExpression = $__16.YieldExpression;
  var assert = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/assert.js", "traceur@0.0.108/src/codegeneration/ExplodeExpressionTransformer.js")).assert;
  var assignmentOperatorToBinaryOperator = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./assignmentOperatorToBinaryOperator.js", "traceur@0.0.108/src/codegeneration/ExplodeExpressionTransformer.js")).default;
  var CommaExpressionBuilder = function() {
    function CommaExpressionBuilder(tempVar) {
      this.tempVar = tempVar;
      this.expressions = [];
    }
    return ($traceurRuntime.createClass)(CommaExpressionBuilder, {
      add: function(tree) {
        var $__2;
        if (tree.type === COMMA_EXPRESSION)
          ($__2 = this.expressions).push.apply($__2, $traceurRuntime.spread(getExpressions(tree)));
        return this;
      },
      build: function(tree) {
        var tempVar = this.tempVar;
        this.expressions.push(createAssignmentExpression(tempVar, tree), tempVar);
        return createCommaExpression(this.expressions);
      }
    }, {});
  }();
  function getResult(tree) {
    if (tree.type === COMMA_EXPRESSION)
      return tree.expressions[tree.expressions.length - 1];
    return tree;
  }
  function getExpressions(tree) {
    if (tree.type === COMMA_EXPRESSION)
      return tree.expressions.slice(0, -1);
    return [];
  }
  var ExplodeExpressionTransformer = function($__super) {
    function ExplodeExpressionTransformer(tempVarTransformer) {
      $traceurRuntime.superConstructor(ExplodeExpressionTransformer).call(this);
      this.tempVarTransformer_ = tempVarTransformer;
    }
    return ($traceurRuntime.createClass)(ExplodeExpressionTransformer, {
      addTempVar: function() {
        var tmpId = this.tempVarTransformer_.addTempVar();
        return id(tmpId);
      },
      transformUnaryExpression: function(tree) {
        if (tree.operator.type === PLUS_PLUS)
          return this.transformUnaryNumeric_(tree, PLUS_EQUAL);
        if (tree.operator.type === MINUS_MINUS)
          return this.transformUnaryNumeric_(tree, MINUS_EQUAL);
        var operand = this.transformAny(tree.operand);
        if (operand === tree.operand)
          return tree;
        var expressions = $traceurRuntime.spread(getExpressions(operand), [new UnaryExpression(tree.location, tree.operator, getResult(operand))]);
        return createCommaExpression(expressions);
      },
      transformUnaryNumeric_: function(tree, operator) {
        return this.transformAny(new BinaryExpression(tree.location, tree.operand, createOperatorToken(operator), createNumberLiteral(1)));
      },
      transformPostfixExpression: function(tree) {
        if (tree.operand.type === MEMBER_EXPRESSION)
          return this.transformPostfixMemberExpression_(tree);
        if (tree.operand.type === MEMBER_LOOKUP_EXPRESSION)
          return this.transformPostfixMemberLookupExpression_(tree);
        assert(tree.operand.type === IDENTIFIER_EXPRESSION);
        var operand = tree.operand;
        var tmp = this.addTempVar();
        var operator = tree.operator.type === PLUS_PLUS ? PLUS : MINUS;
        var expressions = [createAssignmentExpression(tmp, operand), createAssignmentExpression(operand, new BinaryExpression(tree.location, tmp, createOperatorToken(operator), createNumberLiteral(1))), tmp];
        return createCommaExpression(expressions);
      },
      transformPostfixMemberExpression_: function(tree) {
        var memberName = tree.operand.memberName;
        var operand = this.transformAny(tree.operand.operand);
        var tmp = this.addTempVar();
        var memberExpression = new MemberExpression(tree.operand.location, getResult(operand), memberName);
        var operator = tree.operator.type === PLUS_PLUS ? PLUS : MINUS;
        var expressions = $traceurRuntime.spread(getExpressions(operand), [createAssignmentExpression(tmp, memberExpression), createAssignmentExpression(memberExpression, new BinaryExpression(tree.location, tmp, createOperatorToken(operator), createNumberLiteral(1))), tmp]);
        return createCommaExpression(expressions);
      },
      transformPostfixMemberLookupExpression_: function(tree) {
        var memberExpression = this.transformAny(tree.operand.memberExpression);
        var operand = this.transformAny(tree.operand.operand);
        var tmp = this.addTempVar();
        var memberLookupExpression = new MemberLookupExpression(null, getResult(operand), getResult(memberExpression));
        var operator = tree.operator.type === PLUS_PLUS ? PLUS : MINUS;
        var expressions = $traceurRuntime.spread(getExpressions(operand), getExpressions(memberExpression), [createAssignmentExpression(tmp, memberLookupExpression), createAssignmentExpression(memberLookupExpression, new BinaryExpression(tree.location, tmp, createOperatorToken(operator), createNumberLiteral(1))), tmp]);
        return createCommaExpression(expressions);
      },
      transformYieldExpression: function(tree) {
        if (tree.expression === null) {
          return this.createCommaExpressionBuilder_().build(new YieldExpression(tree.location, null, false));
        }
        var expression = this.transformAny(tree.expression);
        return this.createCommaExpressionBuilder_().add(expression).build(new YieldExpression(tree.location, getResult(expression), tree.isYieldFor));
      },
      transformAwaitExpression: function(tree) {
        var expression = this.transformAny(tree.expression);
        return this.createCommaExpressionBuilder_().add(expression).build(new AwaitExpression(tree.location, getResult(expression)));
      },
      transformParenExpression: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression)
          return tree;
        var result = getResult(expression);
        if (result.type === IDENTIFIER_EXPRESSION)
          return expression;
        return this.createCommaExpressionBuilder_().add(expression).build(result);
      },
      transformCommaExpression: function(tree) {
        var expressions = this.transformList(tree.expressions);
        if (expressions === tree.expressions)
          return tree;
        var builder = new CommaExpressionBuilder(null);
        for (var i = 0; i < expressions.length; i++) {
          builder.add(expressions[i]);
        }
        return createCommaExpression($traceurRuntime.spread(builder.expressions, [getResult(expressions[expressions.length - 1])]));
      },
      transformMemberExpression: function(tree) {
        var operand = this.transformAny(tree.operand);
        return this.createCommaExpressionBuilder_().add(operand).build(new MemberExpression(tree.location, getResult(operand), tree.memberName));
      },
      transformMemberLookupExpression: function(tree) {
        var operand = this.transformAny(tree.operand);
        var memberExpression = this.transformAny(tree.memberExpression);
        return this.createCommaExpressionBuilder_().add(operand).add(memberExpression).build(new MemberLookupExpression(tree.location, getResult(operand), getResult(memberExpression)));
      },
      transformBinaryExpression: function(tree) {
        if (tree.operator.isAssignmentOperator())
          return this.transformAssignmentExpression_(tree);
        var left = this.transformAny(tree.left);
        var right = this.transformAny(tree.right);
        if (left === tree.left && right === tree.right)
          return tree;
        if (tree.operator.type === OR)
          return this.transformOr_(left, right);
        if (tree.operator.type === AND)
          return this.transformAnd_(left, right);
        var expressions = $traceurRuntime.spread(getExpressions(left), getExpressions(right), [new BinaryExpression(tree.location, getResult(left), tree.operator, getResult(right))]);
        return createCommaExpression(expressions);
      },
      transformAssignmentExpression_: function(tree) {
        var left = tree.left;
        if (left.type === MEMBER_EXPRESSION)
          return this.transformAssignMemberExpression_(tree);
        if (left.type === MEMBER_LOOKUP_EXPRESSION)
          return this.transformAssignMemberLookupExpression_(tree);
        assert(tree.left.type === IDENTIFIER_EXPRESSION);
        if (tree.operator.type === EQUAL) {
          left = this.transformAny(left);
          var right$__3 = this.transformAny(tree.right);
          var expressions$__4 = $traceurRuntime.spread(getExpressions(right$__3), [createAssignmentExpression(left, getResult(right$__3)), getResult(right$__3)]);
          return createCommaExpression(expressions$__4);
        }
        var right = this.transformAny(tree.right);
        var tmp = this.addTempVar();
        var binop = createOperatorToken(assignmentOperatorToBinaryOperator(tree.operator.type));
        var expressions = $traceurRuntime.spread(getExpressions(right), [createAssignmentExpression(tmp, new BinaryExpression(tree.location, left, binop, getResult(right))), createAssignmentExpression(left, tmp), tmp]);
        return createCommaExpression(expressions);
      },
      transformAssignMemberExpression_: function(tree) {
        var left = tree.left;
        if (tree.operator.type === EQUAL) {
          var operand$__5 = this.transformAny(left.operand);
          var right$__6 = this.transformAny(tree.right);
          var expressions$__7 = $traceurRuntime.spread(getExpressions(operand$__5), getExpressions(right$__6), [new BinaryExpression(tree.location, new MemberExpression(left.location, getResult(operand$__5), left.memberName), tree.operator, getResult(right$__6)), getResult(right$__6)]);
          return createCommaExpression(expressions$__7);
        }
        var operand = this.transformAny(left.operand);
        var right = this.transformAny(tree.right);
        var tmp = this.addTempVar();
        var memberExpression = new MemberExpression(left.location, getResult(operand), left.memberName);
        var tmp2 = this.addTempVar();
        var binop = createOperatorToken(assignmentOperatorToBinaryOperator(tree.operator.type));
        var expressions = $traceurRuntime.spread(getExpressions(operand), getExpressions(right), [createAssignmentExpression(tmp, memberExpression), createAssignmentExpression(tmp2, new BinaryExpression(tree.location, tmp, binop, getResult(right))), createAssignmentExpression(memberExpression, tmp2), tmp2]);
        return createCommaExpression(expressions);
      },
      transformAssignMemberLookupExpression_: function(tree) {
        var left = tree.left;
        if (tree.operator.type === EQUAL) {
          var operand$__8 = this.transformAny(left.operand);
          var memberExpression$__9 = this.transformAny(left.memberExpression);
          var right$__10 = this.transformAny(tree.right);
          var expressions$__11 = $traceurRuntime.spread(getExpressions(operand$__8), getExpressions(memberExpression$__9), getExpressions(right$__10), [new BinaryExpression(tree.location, new MemberLookupExpression(left.location, getResult(operand$__8), getResult(memberExpression$__9)), tree.operator, getResult(right$__10)), getResult(right$__10)]);
          return createCommaExpression(expressions$__11);
        }
        var operand = this.transformAny(left.operand);
        var memberExpression = this.transformAny(left.memberExpression);
        var right = this.transformAny(tree.right);
        var tmp = this.addTempVar();
        var memberLookupExpression = new MemberLookupExpression(left.location, getResult(operand), getResult(memberExpression));
        var tmp2 = this.addTempVar();
        var binop = createOperatorToken(assignmentOperatorToBinaryOperator(tree.operator.type));
        var expressions = $traceurRuntime.spread(getExpressions(operand), getExpressions(memberExpression), getExpressions(right), [createAssignmentExpression(tmp, memberLookupExpression), createAssignmentExpression(tmp2, new BinaryExpression(tree.location, tmp, binop, getResult(right))), createAssignmentExpression(memberLookupExpression, tmp2), tmp2]);
        return createCommaExpression(expressions);
      },
      transformArrayLiteral: function(tree) {
        var elements = this.transformList(tree.elements);
        if (elements === tree.elements)
          return tree;
        var builder = this.createCommaExpressionBuilder_();
        var results = [];
        for (var i = 0; i < elements.length; i++) {
          builder.add(elements[i]);
          results.push(getResult(elements[i]));
        }
        return builder.build(new ArrayLiteral(tree.location, results));
      },
      transformObjectLiteral: function(tree) {
        var propertyNameAndValues = this.transformList(tree.propertyNameAndValues);
        if (propertyNameAndValues === tree.propertyNameAndValues)
          return tree;
        var builder = this.createCommaExpressionBuilder_();
        var results = [];
        for (var i = 0; i < propertyNameAndValues.length; i++) {
          if (propertyNameAndValues[i].type === PROPERTY_NAME_ASSIGNMENT) {
            builder.add(propertyNameAndValues[i].value);
            results.push(new PropertyNameAssignment(propertyNameAndValues[i].location, propertyNameAndValues[i].name, getResult(propertyNameAndValues[i].value)));
          } else {
            results.push(propertyNameAndValues[i]);
          }
        }
        return builder.build(new ObjectLiteral(tree.location, results));
      },
      transformTemplateLiteralExpression: function(tree) {
        var operand = this.transformAny(tree.operand);
        var elements = this.transformList(tree.elements);
        if (!operand && operand === tree.operand && elements === tree.elements)
          return tree;
        var builder = this.createCommaExpressionBuilder_();
        if (operand)
          builder.add(operand);
        var results = [];
        for (var i = 0; i < elements.length; i++) {
          if (elements[i].type === TEMPLATE_LITERAL_PORTION) {
            results.push(elements[i]);
          } else {
            var expression = elements[i].expression;
            builder.add(expression);
            var result = getResult(expression);
            results.push(new TemplateSubstitution(expression.location, result));
          }
        }
        return builder.build(new TemplateLiteralExpression(tree.location, operand && getResult(operand), results));
      },
      transformCallExpression: function(tree) {
        if (tree.operand.type === MEMBER_EXPRESSION)
          return this.transformCallMemberExpression_(tree);
        if (tree.operand.type === MEMBER_LOOKUP_EXPRESSION)
          return this.transformCallMemberLookupExpression_(tree);
        return this.transformCallAndNew_(tree, CallExpression);
      },
      transformNewExpression: function(tree) {
        return this.transformCallAndNew_(tree, NewExpression);
      },
      transformCallAndNew_: function(tree, ctor) {
        var operand = this.transformAny(tree.operand);
        var args = this.transformAny(tree.args);
        var builder = this.createCommaExpressionBuilder_().add(operand);
        var argResults = [];
        args.args.forEach(function(arg) {
          builder.add(arg);
          argResults.push(getResult(arg));
        });
        return builder.build(new ctor(tree.location, getResult(operand), new ArgumentList(args.location, argResults)));
      },
      transformCallMemberExpression_: function(tree) {
        var memberName = tree.operand.memberName;
        var operand = this.transformAny(tree.operand.operand);
        var tmp = this.addTempVar();
        var memberExpresssion = new MemberExpression(tree.operand.location, getResult(operand), memberName);
        var args = this.transformAny(tree.args);
        var expressions = $traceurRuntime.spread(getExpressions(operand), [createAssignmentExpression(tmp, memberExpresssion)]);
        var argResults = [getResult(operand)];
        args.args.forEach(function(arg) {
          var $__2;
          ($__2 = expressions).push.apply($__2, $traceurRuntime.spread(getExpressions(arg)));
          argResults.push(getResult(arg));
        });
        var callExpression = new CallExpression(tree.location, createMemberExpression(tmp, 'call'), new ArgumentList(args.location, argResults));
        var tmp2 = this.addTempVar();
        expressions.push(createAssignmentExpression(tmp2, callExpression), tmp2);
        return createCommaExpression(expressions);
      },
      transformCallMemberLookupExpression_: function(tree) {
        var operand = this.transformAny(tree.operand.operand);
        var memberExpression = this.transformAny(tree.operand.memberExpression);
        var tmp = this.addTempVar();
        var lookupExpresssion = new MemberLookupExpression(tree.operand.location, getResult(operand), getResult(memberExpression));
        var args = this.transformAny(tree.args);
        var expressions = $traceurRuntime.spread(getExpressions(operand), getExpressions(memberExpression), [createAssignmentExpression(tmp, lookupExpresssion)]);
        var argResults = [getResult(operand)];
        args.args.forEach(function(arg, i) {
          var $__2;
          ($__2 = expressions).push.apply($__2, $traceurRuntime.spread(getExpressions(arg)));
          var result = getResult(arg);
          if (tree.args.args[i].type === SPREAD_EXPRESSION)
            result = new SpreadExpression(arg.location, result);
          argResults.push(result);
        });
        var callExpression = new CallExpression(tree.location, createMemberExpression(tmp, 'call'), new ArgumentList(args.location, argResults));
        var tmp2 = this.addTempVar();
        expressions.push(createAssignmentExpression(tmp2, callExpression), tmp2);
        return createCommaExpression(expressions);
      },
      transformConditionalExpression: function(tree) {
        var condition = this.transformAny(tree.condition);
        var left = this.transformAny(tree.left);
        var right = this.transformAny(tree.right);
        if (condition === tree.condition && left === tree.left && right === tree.right)
          return tree;
        var res = this.addTempVar();
        var leftTree = createCommaExpression($traceurRuntime.spread(getExpressions(left), [createAssignmentExpression(res, getResult(left))]));
        var rightTree = createCommaExpression($traceurRuntime.spread(getExpressions(right), [createAssignmentExpression(res, getResult(right))]));
        var expressions = $traceurRuntime.spread(getExpressions(condition), [new ConditionalExpression(tree.location, getResult(condition), createParenExpression(leftTree), createParenExpression(rightTree)), res]);
        return createCommaExpression(expressions);
      },
      transformOr_: function(left, right) {
        var res = this.addTempVar();
        var leftTree = createCommaExpression([createAssignmentExpression(res, getResult(left))]);
        var rightTree = createCommaExpression($traceurRuntime.spread(getExpressions(right), [createAssignmentExpression(res, getResult(right))]));
        var expressions = $traceurRuntime.spread(getExpressions(left), [new ConditionalExpression(left.location, getResult(left), createParenExpression(leftTree), createParenExpression(rightTree)), res]);
        return createCommaExpression(expressions);
      },
      transformAnd_: function(left, right) {
        var res = this.addTempVar();
        var leftTree = createCommaExpression($traceurRuntime.spread(getExpressions(right), [createAssignmentExpression(res, getResult(right))]));
        var rightTree = createCommaExpression([createAssignmentExpression(res, getResult(left))]);
        var expressions = $traceurRuntime.spread(getExpressions(left), [new ConditionalExpression(left.location, getResult(left), createParenExpression(leftTree), createParenExpression(rightTree)), res]);
        return createCommaExpression(expressions);
      },
      transformSpreadExpression: function(tree) {
        var expression = this.transformAny(tree.expression);
        if (expression === tree.expression)
          return tree;
        var result = getResult(expression);
        if (result.type !== SPREAD_EXPRESSION)
          result = new SpreadExpression(result.location, result);
        var expressions = $traceurRuntime.spread(getExpressions(expression), [result]);
        return createCommaExpression(expressions);
      },
      transformFunctionExpression: function(tree) {
        return this.createCommaExpressionBuilder_().build(tree);
      },
      transformArrowFunction: function(tree) {
        return this.createCommaExpressionBuilder_().build(tree);
      },
      transformClassExpression: function(tree) {
        var superClass = this.transformAny(tree.superClass);
        if (superClass === tree.superClass) {
          return this.createCommaExpressionBuilder_().build(tree);
        }
        var builder = this.createCommaExpressionBuilder_();
        builder.add(superClass);
        return builder.build(new ClassExpression(tree.location, tree.name, getResult(superClass), tree.elements, tree.annotations, tree.typeParameters));
      },
      transformFunctionBody: function(tree) {
        return tree;
      },
      createCommaExpressionBuilder_: function() {
        return new CommaExpressionBuilder(this.addTempVar());
      }
    }, {}, $__super);
  }(ParseTreeTransformer);
  return {get ExplodeExpressionTransformer() {
      return ExplodeExpressionTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ExponentiationTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ExponentiationTransformer.js";
  var ExplodeExpressionTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ExplodeExpressionTransformer.js", "traceur@0.0.108/src/codegeneration/ExponentiationTransformer.js")).ExplodeExpressionTransformer;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/ExponentiationTransformer.js")).TempVarTransformer;
  var ParenTrait = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParenTrait.js", "traceur@0.0.108/src/codegeneration/ExponentiationTransformer.js")).ParenTrait;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/ExponentiationTransformer.js")),
      STAR_STAR = $__4.STAR_STAR,
      STAR_STAR_EQUAL = $__4.STAR_STAR_EQUAL;
  var parseExpression = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/ExponentiationTransformer.js")).parseExpression;
  var ExponentiationTransformer = function($__super) {
    function ExponentiationTransformer() {
      $traceurRuntime.superConstructor(ExponentiationTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(ExponentiationTransformer, {transformBinaryExpression: function(tree) {
        switch (tree.operator.type) {
          case STAR_STAR:
            {
              var left = this.transformAny(tree.left);
              var right = this.transformAny(tree.right);
              return parseExpression($traceurRuntime.getTemplateObject(["Math.pow(", ", ", ")"]), left, right);
            }
          case STAR_STAR_EQUAL:
            {
              var exploded = new ExplodeExpressionTransformer(this).transformAny(tree);
              return this.transformAny(exploded);
            }
        }
        return $traceurRuntime.superGet(this, ExponentiationTransformer.prototype, "transformBinaryExpression").call(this, tree);
      }}, {}, $__super);
  }(ParenTrait(TempVarTransformer));
  return {get ExponentiationTransformer() {
      return ExponentiationTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ForOfTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ForOfTransformer.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/ForOfTransformer.js")),
      FOR_OF_STATEMENT = $__1.FOR_OF_STATEMENT,
      VARIABLE_DECLARATION_LIST = $__1.VARIABLE_DECLARATION_LIST,
      LABELLED_STATEMENT = $__1.LABELLED_STATEMENT;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/ForOfTransformer.js")).TempVarTransformer;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/ForOfTransformer.js")),
      id = $__3.createIdentifierExpression,
      createMemberExpression = $__3.createMemberExpression,
      createVariableStatement = $__3.createVariableStatement;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/ForOfTransformer.js")),
      parseStatement = $__4.parseStatement,
      parseStatements = $__4.parseStatements;
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/ForOfTransformer.js")),
      AnonBlock = $__5.AnonBlock,
      LabelledStatement = $__5.LabelledStatement;
  var ForOfTransformer = function($__super) {
    function ForOfTransformer() {
      $traceurRuntime.superConstructor(ForOfTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(ForOfTransformer, {
      transformForOfStatement: function(original) {
        return this.transformForOfStatement_(original, []);
      },
      transformForOfStatement_: function(original, labelSet) {
        var tree = $traceurRuntime.superGet(this, ForOfTransformer.prototype, "transformForOfStatement").call(this, original);
        var iter = id(this.getTempIdentifier());
        var result = id(this.getTempIdentifier());
        var label = id(this.getTempIdentifier());
        var normalCompletion = id(this.getTempIdentifier());
        var throwCompletion = id(this.getTempIdentifier());
        var exception = id(this.getTempIdentifier());
        var ex = id(this.getTempIdentifier());
        var labelledStatement;
        var innerStatement;
        var assignment;
        if (tree.initializer.type === VARIABLE_DECLARATION_LIST) {
          assignment = createVariableStatement(tree.initializer.declarationType, tree.initializer.declarations[0].lvalue, createMemberExpression(result, 'value'));
        } else {
          assignment = parseStatement($traceurRuntime.getTemplateObject(["", " = ", ".value;"]), tree.initializer, result);
        }
        innerStatement = parseStatement($traceurRuntime.getTemplateObject(["\n        for (var ", ",\n                 ", " = (", ")[Symbol.iterator]();\n             !(", " = (", " = ", ".next()).done);\n             ", " = true) {\n          ", "\n          ", "\n        }"]), result, iter, tree.collection, normalCompletion, result, iter, normalCompletion, assignment, tree.body);
        while (labelledStatement = labelSet.pop()) {
          innerStatement = new LabelledStatement(labelledStatement.location, labelledStatement.name, innerStatement);
        }
        return new AnonBlock(null, parseStatements($traceurRuntime.getTemplateObject(["\n        var ", " = true;\n        var ", " = false;\n        var ", " = undefined;\n        try {\n          ", "\n        } catch (", ") {\n          ", " = true;\n          ", " = ", ";\n        } finally {\n          try {\n            if (!", " && ", ".return != null) {\n              ", ".return();\n            }\n          } finally {\n            if (", ") {\n              throw ", ";\n            }\n          }\n        }"]), normalCompletion, throwCompletion, exception, innerStatement, ex, throwCompletion, exception, ex, normalCompletion, iter, iter, throwCompletion, exception));
      },
      transformLabelledStatement: function(tree) {
        var labelSet = [tree];
        var statement = tree.statement;
        while (statement.type === LABELLED_STATEMENT) {
          labelSet.push(statement);
          statement = statement.statement;
        }
        if (statement.type !== FOR_OF_STATEMENT) {
          return $traceurRuntime.superGet(this, ForOfTransformer.prototype, "transformLabelledStatement").call(this, tree);
        }
        return this.transformForOfStatement_(statement, labelSet);
      }
    }, {}, $__super);
  }(TempVarTransformer);
  return {get ForOfTransformer() {
      return ForOfTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/InnerForOnTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/InnerForOnTransformer.js";
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/InnerForOnTransformer.js")).ParseTreeTransformer;
  var alphaRenameThisAndArguments = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./alphaRenameThisAndArguments.js", "traceur@0.0.108/src/codegeneration/InnerForOnTransformer.js")).default;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/InnerForOnTransformer.js")),
      parseStatement = $__4.parseStatement,
      parseStatements = $__4.parseStatements;
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/InnerForOnTransformer.js")),
      AnonBlock = $__5.AnonBlock,
      Block = $__5.Block,
      ContinueStatement = $__5.ContinueStatement,
      LabelledStatement = $__5.LabelledStatement,
      ReturnStatement = $__5.ReturnStatement;
  var StringSet = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/StringSet.js", "traceur@0.0.108/src/codegeneration/InnerForOnTransformer.js")).StringSet;
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/InnerForOnTransformer.js")),
      createAssignmentStatement = $__7.createAssignmentStatement,
      createCaseClause = $__7.createCaseClause,
      createDefaultClause = $__7.createDefaultClause,
      id = $__7.createIdentifierExpression,
      createNumberLiteral = $__7.createNumberLiteral,
      createSwitchStatement = $__7.createSwitchStatement,
      createThisExpression = $__7.createThisExpression,
      createVariableStatement = $__7.createVariableStatement,
      createVariableDeclaration = $__7.createVariableDeclaration,
      createVariableDeclarationList = $__7.createVariableDeclarationList,
      createVoid0 = $__7.createVoid0;
  var SkipFunctionsTransformerTrait = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./SkipFunctionsTransformerTrait.js", "traceur@0.0.108/src/codegeneration/InnerForOnTransformer.js")).default;
  var ARGUMENTS = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/InnerForOnTransformer.js")).ARGUMENTS;
  var VAR = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/InnerForOnTransformer.js")).VAR;
  var $__11 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/InnerForOnTransformer.js")),
      VARIABLE_DECLARATION_LIST = $__11.VARIABLE_DECLARATION_LIST,
      BLOCK = $__11.BLOCK;
  var InnerForOnTransformer = function($__super) {
    function InnerForOnTransformer(tempIdGenerator, labelSet) {
      var $__1;
      $traceurRuntime.superConstructor(InnerForOnTransformer).call(this);
      this.idGenerator_ = tempIdGenerator;
      this.inLoop_ = 0;
      this.inBreakble_ = 0;
      this.variableDeclarations_ = [];
      this.extractedStatements_ = [];
      this.labelSet_ = labelSet;
      this.labelledStatements_ = new StringSet();
      this.observer_ = id(this.idGenerator_.getTempIdentifier());
      this.result_ = id(this.idGenerator_.getTempIdentifier());
      this.parentLabels_ = new StringSet();
      this.labelSet_.forEach(($__1 = this, function(tree) {
        $__1.parentLabels_.add(tree.name.value);
      }));
    }
    return ($traceurRuntime.createClass)(InnerForOnTransformer, {
      transform: function(tree) {
        var value = id(this.idGenerator_.getTempIdentifier());
        var assignment;
        if (tree.initializer.type === VARIABLE_DECLARATION_LIST) {
          assignment = createVariableStatement(tree.initializer.declarationType, tree.initializer.declarations[0].lvalue, value);
        } else {
          assignment = parseStatement($traceurRuntime.getTemplateObject(["\n          ", " = ", ";"]), tree.initializer, value);
        }
        var body;
        if (tree.body.type === BLOCK) {
          body = new Block(tree.body.location, $traceurRuntime.spread([assignment], tree.body.statements));
        } else {
          body = new Block(null, [assignment, tree.body]);
        }
        body = this.transformAny(body);
        body = alphaRenameThisAndArguments(this, body);
        this.variableDeclarations_.push(createVariableDeclaration(this.result_, createVoid0()));
        var caseClauses = this.extractedStatements_.map(function(statement, index) {
          return createCaseClause(createNumberLiteral(index), [statement]);
        });
        caseClauses.push(createCaseClause(createVoid0(), [new ContinueStatement(null, null)]));
        caseClauses.push(createDefaultClause(parseStatements($traceurRuntime.getTemplateObject(["\n        return ", ".v;"]), this.result_)));
        var switchStatement = createSwitchStatement(this.result_, caseClauses);
        var statement = parseStatement($traceurRuntime.getTemplateObject(["\n        do {\n          ", "\n            await $traceurRuntime.observeForEach(\n              ", "[Symbol.observer].bind(", "),\n              async function (", ") {\n                var ", " = this;\n                try {\n                  ", "\n                } catch (e) {\n                  ", ".throw(e);\n                }\n              });\n          ", "\n        } while (false);"]), createVariableStatement(createVariableDeclarationList(VAR, this.variableDeclarations_)), tree.observable, tree.observable, value, this.observer_, body, this.observer_, switchStatement);
        var labelledStatement;
        while (labelledStatement = this.labelSet_.pop()) {
          statement = new LabelledStatement(labelledStatement.location, labelledStatement.name, statement);
        }
        return statement;
      },
      addTempVarForArguments: function() {
        var tmpVarName = this.idGenerator_.generateUniqueIdentifier();
        this.variableDeclarations_.push(createVariableDeclaration(tmpVarName, id(ARGUMENTS)));
        return tmpVarName;
      },
      addTempVarForThis: function() {
        var tmpVarName = this.idGenerator_.generateUniqueIdentifier();
        this.variableDeclarations_.push(createVariableDeclaration(tmpVarName, createThisExpression()));
        return tmpVarName;
      },
      transformAny: function(tree) {
        if (tree) {
          if (tree.isBreakableStatement())
            this.inBreakble_++;
          if (tree.isIterationStatement())
            this.inLoop_++;
          tree = $traceurRuntime.superGet(this, InnerForOnTransformer.prototype, "transformAny").call(this, tree);
          if (tree.isBreakableStatement())
            this.inBreakble_--;
          if (tree.isIterationStatement())
            this.inLoop_--;
        }
        return tree;
      },
      transformReturnStatement: function(tree) {
        return new AnonBlock(tree.location, parseStatements($traceurRuntime.getTemplateObject(["\n        ", ".return();\n        ", " = {v: ", "};\n        return;"]), this.observer_, this.result_, (tree.expression || createVoid0())));
      },
      transformAbruptCompletion_: function(tree) {
        this.extractedStatements_.push(tree);
        var index = this.extractedStatements_.length - 1;
        return new AnonBlock(null, parseStatements($traceurRuntime.getTemplateObject(["\n        ", ".return();\n        ", " = ", ";\n        return;"]), this.observer_, this.result_, index));
      },
      transformBreakStatement: function(tree) {
        if (!tree.name) {
          if (this.inBreakble_) {
            return $traceurRuntime.superGet(this, InnerForOnTransformer.prototype, "transformBreakStatement").call(this, tree);
          }
          return this.transformAbruptCompletion_(new ContinueStatement(tree.location, null));
        }
        if (this.labelledStatements_.has(tree.name.value)) {
          return $traceurRuntime.superGet(this, InnerForOnTransformer.prototype, "transformBreakStatement").call(this, tree);
        }
        return this.transformAbruptCompletion_(tree);
      },
      transformContinueStatement: function(tree) {
        if (!tree.name) {
          if (this.inLoop_) {
            return $traceurRuntime.superGet(this, InnerForOnTransformer.prototype, "transformContinueStatement").call(this, tree);
          }
          return new ReturnStatement(tree.location, null);
        }
        if (this.labelledStatements_.has(tree.name.value)) {
          return $traceurRuntime.superGet(this, InnerForOnTransformer.prototype, "transformContinueStatement").call(this, tree);
        }
        if (this.parentLabels_.has(tree.name.value)) {
          return new ReturnStatement(tree.location, null);
        }
        return this.transformAbruptCompletion_(tree);
      },
      transformLabelledStatement: function(tree) {
        this.labelledStatements_.add(tree.name.value);
        return $traceurRuntime.superGet(this, InnerForOnTransformer.prototype, "transformLabelledStatement").call(this, tree);
      },
      transformVariableStatement: function(tree) {
        var $__1 = this;
        if (tree.declarations.declarationType === VAR) {
          var assignments = [];
          tree.declarations.declarations.forEach(function(variableDeclaration) {
            var variableName = variableDeclaration.lvalue.getStringValue();
            var initializer = $traceurRuntime.superGet($__1, InnerForOnTransformer.prototype, "transformAny").call($__1, variableDeclaration.initializer);
            $__1.variableDeclarations_.push(createVariableDeclaration(variableName, null));
            assignments.push(createAssignmentStatement(id(variableName), initializer));
          });
          return new AnonBlock(null, assignments);
        }
        return $traceurRuntime.superGet(this, InnerForOnTransformer.prototype, "transformVariableStatement").call(this, tree);
      }
    }, {transform: function(tempIdGenerator, tree, labelSet) {
        return new InnerForOnTransformer(tempIdGenerator, labelSet).transform(tree);
      }}, $__super);
  }(SkipFunctionsTransformerTrait(ParseTreeTransformer));
  return {get InnerForOnTransformer() {
      return InnerForOnTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/ForOnTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/ForOnTransformer.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/ForOnTransformer.js")),
      FOR_ON_STATEMENT = $__1.FOR_ON_STATEMENT,
      LABELLED_STATEMENT = $__1.LABELLED_STATEMENT;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/ForOnTransformer.js")).TempVarTransformer;
  var InnerForOnTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./InnerForOnTransformer.js", "traceur@0.0.108/src/codegeneration/ForOnTransformer.js")).InnerForOnTransformer;
  var ForOnTransformer = function($__super) {
    function ForOnTransformer() {
      $traceurRuntime.superConstructor(ForOnTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(ForOnTransformer, {
      transformForOnStatement: function(original) {
        return this.transformForOnStatement_(original, []);
      },
      transformForOnStatement_: function(original, labelSet) {
        return InnerForOnTransformer.transform(this, $traceurRuntime.superGet(this, ForOnTransformer.prototype, "transformForOnStatement").call(this, original), labelSet);
      },
      transformLabelledStatement: function(tree) {
        var labelSet = [tree];
        var statement;
        for (statement = tree.statement; statement.type === LABELLED_STATEMENT; statement = statement.statement) {
          labelSet.push(statement);
        }
        if (statement.type !== FOR_ON_STATEMENT) {
          return $traceurRuntime.superGet(this, ForOnTransformer.prototype, "transformLabelledStatement").call(this, tree);
        }
        return this.transformForOnStatement_(statement, labelSet);
      }
    }, {}, $__super);
  }(TempVarTransformer);
  return {get ForOnTransformer() {
      return ForOnTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/GeneratorComprehensionTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/GeneratorComprehensionTransformer.js";
  var ComprehensionTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ComprehensionTransformer.js", "traceur@0.0.108/src/codegeneration/GeneratorComprehensionTransformer.js")).ComprehensionTransformer;
  var parseStatement = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/GeneratorComprehensionTransformer.js")).parseStatement;
  var GeneratorComprehensionTransformer = function($__super) {
    function GeneratorComprehensionTransformer() {
      $traceurRuntime.superConstructor(GeneratorComprehensionTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(GeneratorComprehensionTransformer, {transformGeneratorComprehension: function(tree) {
        var expression = this.transformAny(tree.expression);
        var statement = parseStatement($traceurRuntime.getTemplateObject(["yield ", ""]), expression);
        var isGenerator = true;
        return this.transformComprehension(tree, statement, isGenerator);
      }}, {}, $__super);
  }(ComprehensionTransformer);
  return {get GeneratorComprehensionTransformer() {
      return GeneratorComprehensionTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/State.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/State.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/generator/State.js")),
      createAssignStateStatement = $__1.createAssignStateStatement,
      createBreakStatement = $__1.createBreakStatement,
      createCaseClause = $__1.createCaseClause,
      createNumberLiteral = $__1.createNumberLiteral;
  var parseStatement = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/generator/State.js")).parseStatement;
  var State = function() {
    function State(id) {
      this.id = id;
    }
    return ($traceurRuntime.createClass)(State, {
      transformMachineState: function(enclosingFinally, machineEndState, reporter) {
        return createCaseClause(createNumberLiteral(this.id), this.transform(enclosingFinally, machineEndState, reporter));
      },
      transformBreak: function(labelSet, breakState) {
        return this;
      },
      transformBreakOrContinue: function(labelSet) {
        var breakState = arguments[1];
        var continueState = arguments[2];
        return this;
      }
    }, {});
  }();
  State.START_STATE = 0;
  State.INVALID_STATE = -1;
  State.END_STATE = -2;
  State.RETHROW_STATE = -3;
  State.generateJump = function(enclosingFinally, fallThroughState) {
    return $traceurRuntime.spread(State.generateAssignState(enclosingFinally, fallThroughState), [createBreakStatement()]);
  };
  State.generateAssignState = function(enclosingFinally, fallThroughState) {
    var assignState;
    if (State.isFinallyExit(enclosingFinally, fallThroughState)) {
      assignState = generateAssignStateOutOfFinally(enclosingFinally, fallThroughState);
    } else {
      assignState = [createAssignStateStatement(fallThroughState)];
    }
    return assignState;
  };
  State.isFinallyExit = function(enclosingFinally, destination) {
    return !!enclosingFinally && enclosingFinally.tryStates.indexOf(destination) < 0;
  };
  function generateAssignStateOutOfFinally(enclosingFinally, destination) {
    var finallyState = enclosingFinally.finallyState;
    return [createAssignStateStatement(finallyState), parseStatement($traceurRuntime.getTemplateObject(["$ctx.finallyFallThrough = ", ""]), destination)];
  }
  State.replaceStateList = function(oldStates, oldState, newState) {
    var states = [];
    for (var i = 0; i < oldStates.length; i++) {
      states.push(State.replaceStateId(oldStates[i], oldState, newState));
    }
    return states;
  };
  State.replaceStateId = function(current, oldState, newState) {
    return current === oldState ? newState : current;
  };
  State.replaceAllStates = function(exceptionBlocks, oldState, newState) {
    var result = [];
    for (var i = 0; i < exceptionBlocks.length; i++) {
      result.push(exceptionBlocks[i].replaceState(oldState, newState));
    }
    return result;
  };
  return {get State() {
      return State;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/AwaitState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/AwaitState.js";
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/AwaitState.js")).State;
  var parseStatements = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/generator/AwaitState.js")).parseStatements;
  var AwaitState = function($__super) {
    function AwaitState(id, callbackState, expression) {
      $traceurRuntime.superConstructor(AwaitState).call(this, id), this.callbackState = callbackState;
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(AwaitState, {
      replaceState: function(oldState, newState) {
        return new AwaitState(State.replaceStateId(this.id, oldState, newState), State.replaceStateId(this.callbackState, oldState, newState), this.expression);
      },
      transform: function(enclosingFinally, machineEndState, reporter) {
        var $__1;
        var stateId,
            statements;
        if (State.isFinallyExit(enclosingFinally, this.callbackState)) {
          stateId = enclosingFinally.finallyState;
          statements = parseStatements($traceurRuntime.getTemplateObject(["$ctx.finallyFallThrough = ", ""]), this.callbackState);
        } else {
          stateId = this.callbackState;
          statements = [];
        }
        ($__1 = statements).push.apply($__1, $traceurRuntime.spread(parseStatements($traceurRuntime.getTemplateObject(["Promise.resolve(", ").then(\n          $ctx.createCallback(", "), $ctx.errback);\n          return;"]), this.expression, stateId)));
        return statements;
      }
    }, {}, $__super);
  }(State);
  return {get AwaitState() {
      return AwaitState;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/FallThroughState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/FallThroughState.js";
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/FallThroughState.js")).State;
  var FallThroughState = function($__super) {
    function FallThroughState(id, fallThroughState, statements) {
      $traceurRuntime.superConstructor(FallThroughState).call(this, id);
      this.fallThroughState = fallThroughState;
      this.statements = statements;
    }
    return ($traceurRuntime.createClass)(FallThroughState, {
      replaceState: function(oldState, newState) {
        return new FallThroughState(State.replaceStateId(this.id, oldState, newState), State.replaceStateId(this.fallThroughState, oldState, newState), this.statements);
      },
      transform: function(enclosingFinally, machineEndState, reporter) {
        return $traceurRuntime.spread(this.statements, State.generateJump(enclosingFinally, this.fallThroughState));
      }
    }, {}, $__super);
  }(State);
  return {get FallThroughState() {
      return FallThroughState;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/BreakState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/BreakState.js";
  var FallThroughState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FallThroughState.js", "traceur@0.0.108/src/codegeneration/generator/BreakState.js")).FallThroughState;
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/BreakState.js")).State;
  var BreakState = function($__super) {
    function BreakState(id, label) {
      $traceurRuntime.superConstructor(BreakState).call(this, id);
      this.label = label;
    }
    return ($traceurRuntime.createClass)(BreakState, {
      replaceState: function(oldState, newState) {
        return new BreakState(State.replaceStateId(this.id, oldState, newState), this.label);
      },
      transform: function(enclosingFinally, machineEndState, reporter) {
        throw new Error('These should be removed before the transform step');
      },
      transformBreak: function(labelSet) {
        var breakState = arguments[1];
        if (this.label === null)
          return new FallThroughState(this.id, breakState, []);
        if (labelSet.has(this.label)) {
          return new FallThroughState(this.id, labelSet.get(this.label).fallThroughState, []);
        }
        return this;
      },
      transformBreakOrContinue: function(labelSet) {
        var breakState = arguments[1];
        var continueState = arguments[2];
        return this.transformBreak(labelSet, breakState);
      }
    }, {}, $__super);
  }(State);
  return {get BreakState() {
      return BreakState;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/ContinueState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/ContinueState.js";
  var FallThroughState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FallThroughState.js", "traceur@0.0.108/src/codegeneration/generator/ContinueState.js")).FallThroughState;
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/ContinueState.js")).State;
  var ContinueState = function($__super) {
    function ContinueState(id, label) {
      $traceurRuntime.superConstructor(ContinueState).call(this, id);
      this.label = label;
    }
    return ($traceurRuntime.createClass)(ContinueState, {
      replaceState: function(oldState, newState) {
        return new ContinueState(State.replaceStateId(this.id, oldState, newState), this.label);
      },
      transform: function(enclosingFinally, machineEndState, reporter) {
        throw new Error('These should be removed before the transform step');
      },
      transformBreakOrContinue: function(labelSet) {
        var breakState = arguments[1];
        var continueState = arguments[2];
        if (this.label === null)
          return new FallThroughState(this.id, continueState, []);
        if (labelSet.has(this.label)) {
          return new FallThroughState(this.id, labelSet.get(this.label).continueState, []);
        }
        return this;
      }
    }, {}, $__super);
  }(State);
  return {get ContinueState() {
      return ContinueState;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/TryState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/TryState.js";
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/TryState.js")).State;
  var Kind = {
    CATCH: 'catch',
    FINALLY: 'finally'
  };
  var TryState = function() {
    function TryState(kind, tryStates, nestedTrys) {
      this.kind = kind;
      this.tryStates = tryStates;
      this.nestedTrys = nestedTrys;
    }
    return ($traceurRuntime.createClass)(TryState, {
      replaceAllStates: function(oldState, newState) {
        return State.replaceStateList(this.tryStates, oldState, newState);
      },
      replaceNestedTrys: function(oldState, newState) {
        var states = [];
        for (var i = 0; i < this.nestedTrys.length; i++) {
          states.push(this.nestedTrys[i].replaceState(oldState, newState));
        }
        return states;
      }
    }, {});
  }();
  TryState.Kind = Kind;
  return {get TryState() {
      return TryState;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/syntax/trees/StateMachine.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/syntax/trees/StateMachine.js";
  var ParseTree = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTree.js", "traceur@0.0.108/src/syntax/trees/StateMachine.js")).ParseTree;
  var STATE_MACHINE = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeType.js", "traceur@0.0.108/src/syntax/trees/StateMachine.js")).STATE_MACHINE;
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../codegeneration/generator/State.js", "traceur@0.0.108/src/syntax/trees/StateMachine.js")).State;
  var TryState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../codegeneration/generator/TryState.js", "traceur@0.0.108/src/syntax/trees/StateMachine.js")).TryState;
  function addCatchOrFinallyStates(kind, enclosingMap, tryStates) {
    for (var i = 0; i < tryStates.length; i++) {
      var tryState = tryStates[i];
      if (tryState.kind === kind) {
        for (var j = 0; j < tryState.tryStates.length; j++) {
          var id = tryState.tryStates[j];
          enclosingMap[id] = tryState;
        }
      }
      addCatchOrFinallyStates(kind, enclosingMap, tryState.nestedTrys);
    }
  }
  function addAllCatchStates(tryStates, catches) {
    for (var i = 0; i < tryStates.length; i++) {
      var tryState = tryStates[i];
      if (tryState.kind === TryState.Kind.CATCH) {
        catches.push(tryState);
      }
      addAllCatchStates(tryState.nestedTrys, catches);
    }
  }
  var StateMachine = function($__super) {
    function StateMachine(startState, fallThroughState, states, exceptionBlocks) {
      $traceurRuntime.superConstructor(StateMachine).call(this, null);
      this.startState = startState;
      this.fallThroughState = fallThroughState;
      this.states = states;
      this.exceptionBlocks = exceptionBlocks;
    }
    return ($traceurRuntime.createClass)(StateMachine, {
      get type() {
        return STATE_MACHINE;
      },
      transform: function(transformer) {
        return transformer.transformStateMachine(this);
      },
      visit: function(visitor) {
        visitor.visitStateMachine(this);
      },
      getAllStateIDs: function() {
        var result = [];
        for (var i = 0; i < this.states.length; i++) {
          result.push(this.states[i].id);
        }
        return result;
      },
      getEnclosingFinallyMap: function() {
        var enclosingMap = Object.create(null);
        addCatchOrFinallyStates(TryState.Kind.FINALLY, enclosingMap, this.exceptionBlocks);
        return enclosingMap;
      },
      allCatchStates: function() {
        var catches = [];
        addAllCatchStates(this.exceptionBlocks, catches);
        return catches;
      },
      replaceStateId: function(oldState, newState) {
        return new StateMachine(State.replaceStateId(this.startState, oldState, newState), State.replaceStateId(this.fallThroughState, oldState, newState), State.replaceAllStates(this.states, oldState, newState), State.replaceAllStates(this.exceptionBlocks, oldState, newState));
      },
      replaceStartState: function(newState) {
        return this.replaceStateId(this.startState, newState);
      },
      replaceFallThroughState: function(newState) {
        return this.replaceStateId(this.fallThroughState, newState);
      },
      append: function(nextMachine) {
        var states = $traceurRuntime.spread(this.states);
        for (var i = 0; i < nextMachine.states.length; i++) {
          var otherState = nextMachine.states[i];
          states.push(otherState.replaceState(nextMachine.startState, this.fallThroughState));
        }
        var exceptionBlocks = $traceurRuntime.spread(this.exceptionBlocks);
        for (var i$__1 = 0; i$__1 < nextMachine.exceptionBlocks.length; i$__1++) {
          var tryState = nextMachine.exceptionBlocks[i$__1];
          exceptionBlocks.push(tryState.replaceState(nextMachine.startState, this.fallThroughState));
        }
        return new StateMachine(this.startState, nextMachine.fallThroughState, states, exceptionBlocks);
      }
    }, {}, $__super);
  }(ParseTree);
  return {get StateMachine() {
      return StateMachine;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/BreakContinueTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/BreakContinueTransformer.js";
  var BreakState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./BreakState.js", "traceur@0.0.108/src/codegeneration/generator/BreakContinueTransformer.js")).BreakState;
  var ContinueState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ContinueState.js", "traceur@0.0.108/src/codegeneration/generator/BreakContinueTransformer.js")).ContinueState;
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/generator/BreakContinueTransformer.js")).ParseTreeTransformer;
  var StateMachine = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/StateMachine.js", "traceur@0.0.108/src/codegeneration/generator/BreakContinueTransformer.js")).StateMachine;
  function safeGetLabel(tree) {
    return tree.name ? tree.name.value : null;
  }
  var BreakContinueTransformer = function($__super) {
    function BreakContinueTransformer(stateAllocator) {
      $traceurRuntime.superConstructor(BreakContinueTransformer).call(this);
      this.transformBreaks_ = true;
      this.stateAllocator_ = stateAllocator;
    }
    return ($traceurRuntime.createClass)(BreakContinueTransformer, {
      allocateState_: function() {
        return this.stateAllocator_.allocateState();
      },
      stateToStateMachine_: function(newState) {
        var fallThroughState = this.allocateState_();
        return new StateMachine(newState.id, fallThroughState, [newState], []);
      },
      transformBreakStatement: function(tree) {
        return this.transformBreaks_ || tree.name ? this.stateToStateMachine_(new BreakState(this.allocateState_(), safeGetLabel(tree))) : tree;
      },
      transformContinueStatement: function(tree) {
        return this.stateToStateMachine_(new ContinueState(this.allocateState_(), safeGetLabel(tree)));
      },
      transformDoWhileStatement: function(tree) {
        return tree;
      },
      transformForOfStatement: function(tree) {
        return tree;
      },
      transformForOnStatement: function(tree) {
        return tree;
      },
      transformForStatement: function(tree) {
        return tree;
      },
      transformFunctionDeclaration: function(tree) {
        return tree;
      },
      transformFunctionExpression: function(tree) {
        return tree;
      },
      transformStateMachine: function(tree) {
        return tree;
      },
      transformSwitchStatement: function(tree) {
        var oldState = this.transformBreaks_;
        this.transformBreaks_ = false;
        var result = $traceurRuntime.superGet(this, BreakContinueTransformer.prototype, "transformSwitchStatement").call(this, tree);
        this.transformBreaks_ = oldState;
        return result;
      },
      transformWhileStatement: function(tree) {
        return tree;
      }
    }, {}, $__super);
  }(ParseTreeTransformer);
  return {get BreakContinueTransformer() {
      return BreakContinueTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/CatchState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/CatchState.js";
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/CatchState.js")).State;
  var TryState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TryState.js", "traceur@0.0.108/src/codegeneration/generator/CatchState.js")).TryState;
  var CatchState = function($__super) {
    function CatchState(identifier, catchState, fallThroughState, allStates, nestedTrys) {
      $traceurRuntime.superConstructor(CatchState).call(this, TryState.Kind.CATCH, allStates, nestedTrys);
      this.identifier = identifier;
      this.catchState = catchState;
      this.fallThroughState = fallThroughState;
    }
    return ($traceurRuntime.createClass)(CatchState, {replaceState: function(oldState, newState) {
        return new CatchState(this.identifier, State.replaceStateId(this.catchState, oldState, newState), State.replaceStateId(this.fallThroughState, oldState, newState), this.replaceAllStates(oldState, newState), this.replaceNestedTrys(oldState, newState));
      }}, {}, $__super);
  }(TryState);
  return {get CatchState() {
      return CatchState;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/ConditionalState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/ConditionalState.js";
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/ConditionalState.js")).State;
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/generator/ConditionalState.js")),
      createBlock = $__2.createBlock,
      createIfStatement = $__2.createIfStatement;
  var parseStatements = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/generator/ConditionalState.js")).parseStatements;
  var ConditionalState = function($__super) {
    function ConditionalState(id, ifState, elseState, condition) {
      $traceurRuntime.superConstructor(ConditionalState).call(this, id);
      this.ifState = ifState;
      this.elseState = elseState;
      this.condition = condition;
    }
    return ($traceurRuntime.createClass)(ConditionalState, {
      replaceState: function(oldState, newState) {
        return new ConditionalState(State.replaceStateId(this.id, oldState, newState), State.replaceStateId(this.ifState, oldState, newState), State.replaceStateId(this.elseState, oldState, newState), this.condition);
      },
      transform: function(enclosingFinally, machineEndState, reporter) {
        if (State.isFinallyExit(enclosingFinally, this.ifState) || State.isFinallyExit(enclosingFinally, this.elseState)) {
          return [createIfStatement(this.condition, createBlock(State.generateJump(enclosingFinally, this.ifState)), createBlock(State.generateJump(enclosingFinally, this.elseState)))];
        }
        return parseStatements($traceurRuntime.getTemplateObject(["$ctx.state = (", ") ? ", " : ", ";\n        break"]), this.condition, this.ifState, this.elseState);
      }
    }, {}, $__super);
  }(State);
  return {get ConditionalState() {
      return ConditionalState;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/FinallyFallThroughState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/FinallyFallThroughState.js";
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/FinallyFallThroughState.js")).State;
  var FinallyFallThroughState = function($__super) {
    function FinallyFallThroughState() {
      $traceurRuntime.superConstructor(FinallyFallThroughState).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(FinallyFallThroughState, {
      replaceState: function(oldState, newState) {
        return new FinallyFallThroughState(State.replaceStateId(this.id, oldState, newState));
      },
      transformMachineState: function(enclosingFinally, machineEndState, reporter) {
        return null;
      },
      transform: function(enclosingFinally, machineEndState, reporter) {
        throw new Error('these are generated in addFinallyFallThroughDispatches');
      }
    }, {}, $__super);
  }(State);
  return {get FinallyFallThroughState() {
      return FinallyFallThroughState;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/FinallyState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/FinallyState.js";
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/FinallyState.js")).State;
  var TryState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TryState.js", "traceur@0.0.108/src/codegeneration/generator/FinallyState.js")).TryState;
  var FinallyState = function($__super) {
    function FinallyState(finallyState, fallThroughState, allStates, nestedTrys) {
      $traceurRuntime.superConstructor(FinallyState).call(this, TryState.Kind.FINALLY, allStates, nestedTrys);
      this.finallyState = finallyState;
      this.fallThroughState = fallThroughState;
    }
    return ($traceurRuntime.createClass)(FinallyState, {replaceState: function(oldState, newState) {
        return new FinallyState(State.replaceStateId(this.finallyState, oldState, newState), State.replaceStateId(this.fallThroughState, oldState, newState), this.replaceAllStates(oldState, newState), this.replaceNestedTrys(oldState, newState));
      }}, {}, $__super);
  }(TryState);
  return {get FinallyState() {
      return FinallyState;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/StateAllocator.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/StateAllocator.js";
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/StateAllocator.js")).State;
  var StateAllocator = function() {
    function StateAllocator() {
      this.nextState_ = State.START_STATE + 1;
    }
    return ($traceurRuntime.createClass)(StateAllocator, {allocateState: function() {
        return this.nextState_++;
      }}, {});
  }();
  return {get StateAllocator() {
      return StateAllocator;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/SwitchState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/SwitchState.js";
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/generator/SwitchState.js")),
      CaseClause = $__2.CaseClause,
      DefaultClause = $__2.DefaultClause,
      SwitchStatement = $__2.SwitchStatement;
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/SwitchState.js")).State;
  var createBreakStatement = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/generator/SwitchState.js")).createBreakStatement;
  var SwitchClause = function() {
    function SwitchClause(first, second) {
      this.first = first;
      this.second = second;
    }
    return ($traceurRuntime.createClass)(SwitchClause, {}, {});
  }();
  var SwitchState = function($__super) {
    function SwitchState(id, expression, clauses) {
      $traceurRuntime.superConstructor(SwitchState).call(this, id);
      this.expression = expression;
      this.clauses = clauses;
    }
    return ($traceurRuntime.createClass)(SwitchState, {
      replaceState: function(oldState, newState) {
        var clauses = this.clauses.map(function(clause) {
          return new SwitchClause(clause.first, State.replaceStateId(clause.second, oldState, newState));
        });
        return new SwitchState(State.replaceStateId(this.id, oldState, newState), this.expression, clauses);
      },
      transform: function(enclosingFinally, machineEndState, reporter) {
        var clauses = [];
        for (var i = 0; i < this.clauses.length; i++) {
          var clause = this.clauses[i];
          if (clause.first === null) {
            clauses.push(new DefaultClause(null, State.generateJump(enclosingFinally, clause.second)));
          } else {
            clauses.push(new CaseClause(null, clause.first, State.generateJump(enclosingFinally, clause.second)));
          }
        }
        return [new SwitchStatement(null, this.expression, clauses), createBreakStatement()];
      }
    }, {}, $__super);
  }(State);
  return {
    get SwitchClause() {
      return SwitchClause;
    },
    get SwitchState() {
      return SwitchState;
    }
  };
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/HoistVariablesTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/HoistVariablesTransformer.js";
  var $__1 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/HoistVariablesTransformer.js")),
      AnonBlock = $__1.AnonBlock,
      Catch = $__1.Catch,
      FunctionBody = $__1.FunctionBody,
      ForInStatement = $__1.ForInStatement,
      ForOfStatement = $__1.ForOfStatement,
      ForStatement = $__1.ForStatement,
      VariableDeclarationList = $__1.VariableDeclarationList,
      VariableStatement = $__1.VariableStatement;
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/HoistVariablesTransformer.js")),
      OBJECT_PATTERN = $__2.OBJECT_PATTERN,
      VARIABLE_DECLARATION_LIST = $__2.VARIABLE_DECLARATION_LIST;
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/HoistVariablesTransformer.js")).ParseTreeTransformer;
  var StringSet = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../util/StringSet.js", "traceur@0.0.108/src/codegeneration/HoistVariablesTransformer.js")).StringSet;
  var VAR = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/HoistVariablesTransformer.js")).VAR;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/HoistVariablesTransformer.js")),
      createAssignmentExpression = $__6.createAssignmentExpression,
      createCommaExpression = $__6.createCommaExpression,
      createExpressionStatement = $__6.createExpressionStatement,
      id = $__6.createIdentifierExpression,
      createParenExpression = $__6.createParenExpression,
      createVariableDeclaration = $__6.createVariableDeclaration;
  var prependStatements = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PrependStatements.js", "traceur@0.0.108/src/codegeneration/HoistVariablesTransformer.js")).prependStatements;
  var HoistVariablesTransformer = function($__super) {
    function HoistVariablesTransformer() {
      var shouldHoistFunctions = arguments[0] !== (void 0) ? arguments[0] : false;
      $traceurRuntime.superConstructor(HoistVariablesTransformer).call(this);
      this.hoistedFunctions_ = [];
      this.hoistedVariables_ = new StringSet();
      this.keepBindingIdentifiers_ = false;
      this.inBlockOrFor_ = false;
      this.shouldHoistFunctions_ = shouldHoistFunctions;
    }
    return ($traceurRuntime.createClass)(HoistVariablesTransformer, {
      transformFunctionBody: function(tree) {
        var statements = this.transformList(tree.statements);
        if (statements === tree.statements)
          return tree;
        statements = this.prependVariables(statements);
        statements = this.prependFunctions(statements);
        return new FunctionBody(tree.location, statements);
      },
      addVariable: function(name) {
        this.hoistedVariables_.add(name);
      },
      addFunctionDeclaration: function(tree) {
        this.hoistedFunctions_.push(tree);
      },
      hasVariables: function() {
        return !this.hoistedVariables_.isEmpty();
      },
      hasFunctions: function() {
        return this.hoistedFunctions_.length > 0;
      },
      getVariableNames: function() {
        return this.hoistedVariables_.valuesAsArray();
      },
      getVariableStatement: function() {
        if (!this.hasVariables())
          return new AnonBlock(null, []);
        var declarations = this.getVariableNames().map(function(name) {
          return createVariableDeclaration(name, null);
        });
        return new VariableStatement(null, new VariableDeclarationList(null, VAR, declarations));
      },
      getFunctions: function() {
        return this.hoistedFunctions_;
      },
      prependVariables: function(statements) {
        if (!this.hasVariables())
          return statements;
        return prependStatements(statements, this.getVariableStatement());
      },
      prependFunctions: function(statements) {
        if (!this.hasFunctions())
          return statements;
        return prependStatements(statements, this.getFunctionDeclarations());
      },
      transformVariableStatement: function(tree) {
        var declarations = this.transformAny(tree.declarations);
        if (declarations === tree.declarations)
          return tree;
        if (declarations === null)
          return new AnonBlock(null, []);
        if (declarations.type === VARIABLE_DECLARATION_LIST)
          return new VariableStatement(tree.location, declarations);
        return createExpressionStatement(declarations);
      },
      transformVariableDeclaration: function(tree) {
        var lvalue = this.transformAny(tree.lvalue);
        var initializer = this.transformAny(tree.initializer);
        if (initializer) {
          var expression = createAssignmentExpression(lvalue, initializer);
          if (lvalue.type === OBJECT_PATTERN)
            expression = createParenExpression(expression);
          return expression;
        }
        return null;
      },
      transformObjectPattern: function(tree) {
        var keepBindingIdentifiers = this.keepBindingIdentifiers_;
        this.keepBindingIdentifiers_ = true;
        var transformed = $traceurRuntime.superGet(this, HoistVariablesTransformer.prototype, "transformObjectPattern").call(this, tree);
        this.keepBindingIdentifiers_ = keepBindingIdentifiers;
        return transformed;
      },
      transformArrayPattern: function(tree) {
        var keepBindingIdentifiers = this.keepBindingIdentifiers_;
        this.keepBindingIdentifiers_ = true;
        var transformed = $traceurRuntime.superGet(this, HoistVariablesTransformer.prototype, "transformArrayPattern").call(this, tree);
        this.keepBindingIdentifiers_ = keepBindingIdentifiers;
        return transformed;
      },
      transformBindingIdentifier: function(tree) {
        var idToken = tree.identifierToken;
        this.addVariable(idToken.value);
        if (this.keepBindingIdentifiers_)
          return tree;
        return id(idToken);
      },
      transformVariableDeclarationList: function(tree) {
        if (tree.declarationType === VAR || !this.inBlockOrFor_) {
          var expressions = this.transformList(tree.declarations);
          expressions = expressions.filter(function(tree) {
            return tree;
          });
          if (expressions.length === 0)
            return null;
          if (expressions.length === 1)
            return expressions[0];
          return createCommaExpression(expressions);
        }
        return tree;
      },
      transformCatch: function(tree) {
        var catchBody = this.transformAny(tree.catchBody);
        if (catchBody === tree.catchBody)
          return tree;
        return new Catch(tree.location, tree.binding, catchBody);
      },
      transformForInStatement: function(tree) {
        return this.transformLoop_(tree, ForInStatement);
      },
      transformForOfStatement: function(tree) {
        return this.transformLoop_(tree, ForOfStatement);
      },
      transformForOnStatement: function(tree) {
        return this.transformLoop_(tree, ForOfStatement);
      },
      transformLoop_: function(tree, ctor) {
        var initializer = this.transformLoopIninitaliser_(tree.initializer);
        var collection = this.transformAny(tree.collection);
        var body = this.transformAny(tree.body);
        if (initializer === tree.initializer && collection === tree.collection && body === tree.body) {
          return tree;
        }
        return new ctor(tree.location, initializer, collection, body);
      },
      transformLoopIninitaliser_: function(tree) {
        if (tree.type !== VARIABLE_DECLARATION_LIST || tree.declarationType !== VAR)
          return tree;
        return this.transformAny(tree.declarations[0].lvalue);
      },
      transformForStatement: function(tree) {
        var inBlockOrFor = this.inBlockOrFor_;
        this.inBlockOrFor_ = true;
        var initializer = this.transformAny(tree.initializer);
        this.inBlockOrFor_ = inBlockOrFor;
        var condition = this.transformAny(tree.condition);
        var increment = this.transformAny(tree.increment);
        var body = this.transformAny(tree.body);
        if (initializer === tree.initializer && condition === tree.condition && increment === tree.increment && body === tree.body) {
          return tree;
        }
        return new ForStatement(tree.location, initializer, condition, increment, body);
      },
      transformBlock: function(tree) {
        var inBlockOrFor = this.inBlockOrFor_;
        this.inBlockOrFor_ = true;
        tree = $traceurRuntime.superGet(this, HoistVariablesTransformer.prototype, "transformBlock").call(this, tree);
        this.inBlockOrFor_ = inBlockOrFor;
        return tree;
      },
      addMachineVariable: function(name) {
        this.machineVariables_[name] = true;
      },
      transformClassDeclaration: function(tree) {
        return tree;
      },
      transformClassExpression: function(tree) {
        return tree;
      },
      transformFunctionDeclaration: function(tree) {
        if (this.shouldHoistFunctions_) {
          this.addFunctionDeclaration(tree);
          return new AnonBlock(null, []);
        }
        return tree;
      },
      transformFunctionExpression: function(tree) {
        return tree;
      },
      transformGetAccessor: function(tree) {
        return tree;
      },
      transformSetAccessor: function(tree) {
        return tree;
      },
      transformMethod: function(tree) {
        return tree;
      },
      transformArrowFunction: function(tree) {
        return tree;
      },
      transformComprehensionFor: function(tree) {
        return tree;
      }
    }, {}, $__super);
  }(ParseTreeTransformer);
  var $__default = HoistVariablesTransformer;
  return {get default() {
      return $__default;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js";
  var AlphaRenamer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../AlphaRenamer.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).AlphaRenamer;
  var BreakContinueTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./BreakContinueTransformer.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).BreakContinueTransformer;
  var $__19 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")),
      BLOCK = $__19.BLOCK,
      CASE_CLAUSE = $__19.CASE_CLAUSE,
      CONDITIONAL_EXPRESSION = $__19.CONDITIONAL_EXPRESSION,
      EXPRESSION_STATEMENT = $__19.EXPRESSION_STATEMENT,
      PAREN_EXPRESSION = $__19.PAREN_EXPRESSION,
      STATE_MACHINE = $__19.STATE_MACHINE;
  var $__20 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")),
      AnonBlock = $__20.AnonBlock,
      Block = $__20.Block,
      CaseClause = $__20.CaseClause,
      IfStatement = $__20.IfStatement,
      SwitchStatement = $__20.SwitchStatement;
  var CatchState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./CatchState.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).CatchState;
  var ConditionalState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ConditionalState.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).ConditionalState;
  var ExplodeExpressionTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../ExplodeExpressionTransformer.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).ExplodeExpressionTransformer;
  var FallThroughState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FallThroughState.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).FallThroughState;
  var FinallyFallThroughState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FinallyFallThroughState.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).FinallyFallThroughState;
  var FinallyState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FinallyState.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).FinallyState;
  var FindInFunctionScope = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../FindInFunctionScope.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).FindInFunctionScope;
  var ParseTreeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../ParseTreeTransformer.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).ParseTreeTransformer;
  var StringMap = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../util/StringMap.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).StringMap;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).TempVarTransformer;
  var assert = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../util/assert.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).assert;
  var $__32 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")),
      parseExpression = $__32.parseExpression,
      parseStatement = $__32.parseStatement,
      parseStatements = $__32.parseStatements;
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).State;
  var StateAllocator = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./StateAllocator.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).StateAllocator;
  var StateMachine = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/StateMachine.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).StateMachine;
  var $__36 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./SwitchState.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")),
      SwitchClause = $__36.SwitchClause,
      SwitchState = $__36.SwitchState;
  var TryState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TryState.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).TryState;
  var $__38 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")),
      createAssignStateStatement = $__38.createAssignStateStatement,
      createBreakStatement = $__38.createBreakStatement,
      createCaseClause = $__38.createCaseClause,
      createDefaultClause = $__38.createDefaultClause,
      createExpressionStatement = $__38.createExpressionStatement,
      createFunctionBody = $__38.createFunctionBody,
      id = $__38.createIdentifierExpression,
      createMemberExpression = $__38.createMemberExpression,
      createNumberLiteral = $__38.createNumberLiteral,
      createSwitchStatement = $__38.createSwitchStatement;
  var HoistVariablesTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../HoistVariablesTransformer.js", "traceur@0.0.108/src/codegeneration/generator/CPSTransformer.js")).default;
  var LabelState = function() {
    function LabelState(name, continueState, fallThroughState) {
      this.name = name;
      this.continueState = continueState;
      this.fallThroughState = fallThroughState;
    }
    return ($traceurRuntime.createClass)(LabelState, {}, {});
  }();
  var NeedsStateMachine = function($__super) {
    function NeedsStateMachine() {
      $traceurRuntime.superConstructor(NeedsStateMachine).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(NeedsStateMachine, {
      visitBreakStatement: function(tree) {
        this.found = true;
      },
      visitContinueStatement: function(tree) {
        this.found = true;
      },
      visitStateMachine: function(tree) {
        this.found = true;
      },
      visitYieldExpression: function(tee) {
        this.found = true;
      }
    }, {}, $__super);
  }(FindInFunctionScope);
  function needsStateMachine(tree) {
    var visitor = new NeedsStateMachine();
    visitor.visitAny(tree);
    return visitor.found;
  }
  var HoistVariables = function($__super) {
    function HoistVariables() {
      $traceurRuntime.superConstructor(HoistVariables).call(this, true);
    }
    return ($traceurRuntime.createClass)(HoistVariables, {
      prependVariables: function(statements) {
        return statements;
      },
      prependFunctions: function(statements) {
        return statements;
      }
    }, {}, $__super);
  }(HoistVariablesTransformer);
  var CPSTransformer = function($__super) {
    function CPSTransformer(identifierGenerator, reporter, options) {
      $traceurRuntime.superConstructor(CPSTransformer).call(this, identifierGenerator, reporter, options);
      this.stateAllocator_ = new StateAllocator();
      this.labelSet_ = new StringMap();
      this.currentLabel_ = null;
      this.hoistVariablesTransformer_ = new HoistVariables();
    }
    return ($traceurRuntime.createClass)(CPSTransformer, {
      expressionNeedsStateMachine: function(tree) {
        return false;
      },
      allocateState: function() {
        return this.stateAllocator_.allocateState();
      },
      transformBlock: function(tree) {
        var labels = this.getLabels_();
        var label = this.clearCurrentLabel_();
        var transformedTree = $traceurRuntime.superGet(this, CPSTransformer.prototype, "transformBlock").call(this, tree);
        var machine = this.transformStatementList_(transformedTree.statements);
        if (machine === null)
          return transformedTree;
        if (label) {
          var states = [];
          for (var i = 0; i < machine.states.length; i++) {
            var state = machine.states[i];
            states.push(state.transformBreakOrContinue(labels));
          }
          machine = new StateMachine(machine.startState, machine.fallThroughState, states, machine.exceptionBlocks);
        }
        return machine;
      },
      transformFunctionBody: function(tree) {
        this.pushTempScope();
        var oldLabels = this.clearLabels_();
        var transformedTree = $traceurRuntime.superGet(this, CPSTransformer.prototype, "transformFunctionBody").call(this, tree);
        var machine = this.transformStatementList_(transformedTree.statements);
        this.restoreLabels_(oldLabels);
        this.popTempScope();
        return machine === null ? transformedTree : machine;
      },
      transformStatementList_: function(trees) {
        var groups = [];
        var newMachine;
        for (var i = 0; i < trees.length; i++) {
          if (trees[i].type === STATE_MACHINE) {
            groups.push(trees[i]);
          } else if (needsStateMachine(trees[i])) {
            newMachine = this.ensureTransformed_(trees[i]);
            groups.push(newMachine);
          } else {
            var last = groups[groups.length - 1];
            if (!(last instanceof Array))
              groups.push(last = []);
            last.push(trees[i]);
          }
        }
        if (groups.length === 1 && groups[0] instanceof Array)
          return null;
        var machine = null;
        for (var i$__11 = 0; i$__11 < groups.length; i$__11++) {
          if (groups[i$__11] instanceof Array) {
            newMachine = this.statementsToStateMachine_(groups[i$__11]);
          } else {
            newMachine = groups[i$__11];
          }
          if (i$__11 === 0)
            machine = newMachine;
          else
            machine = machine.append(newMachine);
        }
        return machine;
      },
      needsStateMachine_: function(statements) {
        if (statements instanceof Array) {
          for (var i = 0; i < statements.length; i++) {
            if (needsStateMachine(statements[i]))
              return true;
          }
          return false;
        }
        assert(statements instanceof SwitchStatement);
        return needsStateMachine(statements);
      },
      transformCaseClause: function(tree) {
        var result = $traceurRuntime.superGet(this, CPSTransformer.prototype, "transformCaseClause").call(this, tree);
        var machine = this.transformStatementList_(result.statements);
        return machine === null ? result : new CaseClause(null, result.expression, [machine]);
      },
      transformDoWhileStatement: function(tree) {
        var $__8;
        var $__6,
            $__7;
        var labels = this.getLabels_();
        var label = this.clearCurrentLabel_();
        var machine,
            condition,
            body;
        if (this.expressionNeedsStateMachine(tree.condition)) {
          (($__6 = this.expressionToStateMachine(tree.condition), machine = $__6.machine, condition = $__6.expression, $__6));
          body = this.transformAny(tree.body);
        } else {
          var result = $traceurRuntime.superGet(this, CPSTransformer.prototype, "transformDoWhileStatement").call(this, tree);
          (($__7 = result, condition = $__7.condition, body = $__7.body, $__7));
          if (body.type !== STATE_MACHINE)
            return result;
        }
        var loopBodyMachine = this.ensureTransformed_(body);
        var startState = loopBodyMachine.startState;
        var conditionState = loopBodyMachine.fallThroughState;
        var fallThroughState = this.allocateState();
        var states = [];
        this.addLoopBodyStates_(loopBodyMachine, conditionState, fallThroughState, labels, states);
        if (machine) {
          machine = machine.replaceStartState(conditionState);
          conditionState = machine.fallThroughState;
          ($__8 = states).push.apply($__8, $traceurRuntime.spread(machine.states));
        }
        states.push(new ConditionalState(conditionState, startState, fallThroughState, condition));
        machine = new StateMachine(startState, fallThroughState, states, loopBodyMachine.exceptionBlocks);
        if (label)
          machine = machine.replaceStateId(conditionState, label.continueState);
        return machine;
      },
      addLoopBodyStates_: function(loopBodyMachine, continueState, breakState, labels, states) {
        for (var i = 0; i < loopBodyMachine.states.length; i++) {
          var state = loopBodyMachine.states[i];
          states.push(state.transformBreakOrContinue(labels, breakState, continueState));
        }
      },
      transformForStatement: function(tree) {
        var $__8,
            $__9,
            $__10;
        var labels = this.getLabels_();
        var label = this.clearCurrentLabel_();
        var tmp;
        var initializer = null,
            initializerMachine;
        if (tree.initializer) {
          if (this.expressionNeedsStateMachine(tree.initializer)) {
            tmp = this.expressionToStateMachine(tree.initializer);
            initializer = tmp.expression;
            initializerMachine = tmp.machine;
          } else {
            initializer = this.transformAny(tree.initializer);
          }
        }
        var condition = null,
            conditionMachine;
        if (tree.condition) {
          if (this.expressionNeedsStateMachine(tree.condition)) {
            tmp = this.expressionToStateMachine(tree.condition);
            condition = tmp.expression;
            conditionMachine = tmp.machine;
          } else {
            condition = this.transformAny(tree.condition);
          }
        }
        var increment = null,
            incrementMachine;
        if (tree.increment) {
          if (this.expressionNeedsStateMachine(tree.increment)) {
            tmp = this.expressionToStateMachine(tree.increment);
            increment = tmp.expression;
            incrementMachine = tmp.machine;
          } else {
            increment = this.transformAny(tree.increment);
          }
        }
        var body = this.transformAny(tree.body);
        if (initializer === tree.initializer && condition === tree.condition && increment === tree.increment && body === tree.body) {
          return tree;
        }
        if (!initializerMachine && !conditionMachine && !incrementMachine && body.type !== STATE_MACHINE) {
          return new ForStatement(tree.location, initializer, condition, increment, body);
        }
        var loopBodyMachine = this.ensureTransformed_(body);
        var bodyFallThroughId = loopBodyMachine.fallThroughState;
        var fallThroughId = this.allocateState();
        var startId;
        var initializerStartId = initializer ? this.allocateState() : State.INVALID_STATE;
        var conditionStartId = increment ? this.allocateState() : bodyFallThroughId;
        var loopStartId = loopBodyMachine.startState;
        var incrementStartId = bodyFallThroughId;
        var states = [];
        if (initializer) {
          startId = initializerStartId;
          var initialiserFallThroughId;
          if (condition)
            initialiserFallThroughId = conditionStartId;
          else
            initialiserFallThroughId = loopStartId;
          var tmpId = initializerStartId;
          if (initializerMachine) {
            initializerMachine = initializerMachine.replaceStartState(initializerStartId);
            tmpId = initializerMachine.fallThroughState;
            ($__8 = states).push.apply($__8, $traceurRuntime.spread(initializerMachine.states));
          }
          states.push(new FallThroughState(tmpId, initialiserFallThroughId, [createExpressionStatement(initializer)]));
        }
        if (condition) {
          if (!initializer)
            startId = conditionStartId;
          var tmpId$__12 = conditionStartId;
          if (conditionMachine) {
            conditionMachine = conditionMachine.replaceStartState(conditionStartId);
            tmpId$__12 = conditionMachine.fallThroughState;
            ($__9 = states).push.apply($__9, $traceurRuntime.spread(conditionMachine.states));
          }
          states.push(new ConditionalState(tmpId$__12, loopStartId, fallThroughId, condition));
        }
        if (increment) {
          var incrementFallThroughId;
          if (condition)
            incrementFallThroughId = conditionStartId;
          else
            incrementFallThroughId = loopStartId;
          var tmpId$__13 = incrementStartId;
          if (incrementMachine) {
            incrementMachine = incrementMachine.replaceStartState(incrementStartId);
            tmpId$__13 = incrementMachine.fallThroughState;
            ($__10 = states).push.apply($__10, $traceurRuntime.spread(incrementMachine.states));
          }
          states.push(new FallThroughState(tmpId$__13, incrementFallThroughId, [createExpressionStatement(increment)]));
        }
        if (!initializer && !condition)
          startId = loopStartId;
        var continueId;
        if (increment)
          continueId = incrementStartId;
        else if (condition)
          continueId = conditionStartId;
        else
          continueId = loopStartId;
        if (!increment && !condition) {
          loopBodyMachine = loopBodyMachine.replaceFallThroughState(loopBodyMachine.startState);
        }
        this.addLoopBodyStates_(loopBodyMachine, continueId, fallThroughId, labels, states);
        var machine = new StateMachine(startId, fallThroughId, states, loopBodyMachine.exceptionBlocks);
        if (label)
          machine = machine.replaceStateId(continueId, label.continueState);
        return machine;
      },
      transformForInStatement: function(tree) {
        return tree;
      },
      transformForOfStatement: function(tree) {
        throw new Error('for of statements should be transformed before this pass');
      },
      transformIfStatement: function(tree) {
        var $__8,
            $__9,
            $__10;
        var $__6,
            $__7;
        var machine,
            condition,
            ifClause,
            elseClause;
        if (this.expressionNeedsStateMachine(tree.condition)) {
          (($__6 = this.expressionToStateMachine(tree.condition), machine = $__6.machine, condition = $__6.expression, $__6));
          ifClause = this.transformAny(tree.ifClause);
          elseClause = this.transformAny(tree.elseClause);
        } else {
          var result = $traceurRuntime.superGet(this, CPSTransformer.prototype, "transformIfStatement").call(this, tree);
          (($__7 = result, condition = $__7.condition, ifClause = $__7.ifClause, elseClause = $__7.elseClause, $__7));
          if (ifClause.type !== STATE_MACHINE && (elseClause === null || elseClause.type !== STATE_MACHINE)) {
            return result;
          }
        }
        ifClause = this.ensureTransformed_(ifClause);
        elseClause = this.ensureTransformed_(elseClause);
        var startState = this.allocateState();
        var fallThroughState = ifClause.fallThroughState;
        var ifState = ifClause.startState;
        var elseState = elseClause === null ? fallThroughState : elseClause.startState;
        var states = [];
        var exceptionBlocks = [];
        states.push(new ConditionalState(startState, ifState, elseState, condition));
        ($__8 = states).push.apply($__8, $traceurRuntime.spread(ifClause.states));
        ($__9 = exceptionBlocks).push.apply($__9, $traceurRuntime.spread(ifClause.exceptionBlocks));
        if (elseClause !== null) {
          this.replaceAndAddStates_(elseClause.states, elseClause.fallThroughState, fallThroughState, states);
          ($__10 = exceptionBlocks).push.apply($__10, $traceurRuntime.spread(State.replaceAllStates(elseClause.exceptionBlocks, elseClause.fallThroughState, fallThroughState)));
        }
        var ifMachine = new StateMachine(startState, fallThroughState, states, exceptionBlocks);
        if (machine)
          ifMachine = machine.append(ifMachine);
        return ifMachine;
      },
      removeEmptyStates: function(oldStates) {
        var emptyStates = [],
            newStates = [];
        for (var i = 0; i < oldStates.length; i++) {
          if (oldStates[i] instanceof FallThroughState && oldStates[i].statements.length === 0) {
            emptyStates.push(oldStates[i]);
          } else {
            newStates.push(oldStates[i]);
          }
        }
        for (var i$__14 = 0; i$__14 < newStates.length; i$__14++) {
          newStates[i$__14] = emptyStates.reduce(function(state, $__6) {
            var $__7 = $__6,
                id = $__7.id,
                fallThroughState = $__7.fallThroughState;
            return state.replaceState(id, fallThroughState);
          }, newStates[i$__14]);
        }
        return newStates;
      },
      replaceAndAddStates_: function(oldStates, oldState, newState, newStates) {
        for (var i = 0; i < oldStates.length; i++) {
          newStates.push(oldStates[i].replaceState(oldState, newState));
        }
      },
      transformLabelledStatement: function(tree) {
        var startState = this.allocateState();
        var continueState = this.allocateState();
        var fallThroughState = this.allocateState();
        var label = new LabelState(tree.name.value, continueState, fallThroughState);
        var oldLabels = this.addLabel_(label);
        this.currentLabel_ = label;
        var result = this.transformAny(tree.statement);
        if (result === tree.statement) {
          result = tree;
        } else if (result.type === STATE_MACHINE) {
          result = result.replaceStartState(startState);
          result = result.replaceFallThroughState(fallThroughState);
        }
        this.restoreLabels_(oldLabels);
        return result;
      },
      getLabels_: function() {
        return this.labelSet_;
      },
      restoreLabels_: function(oldLabels) {
        this.labelSet_ = oldLabels;
      },
      addLabel_: function(label) {
        var $__5 = this;
        var oldLabels = this.labelSet_;
        var labelSet = new StringMap();
        this.labelSet_.forEach(function(k) {
          return labelSet[k] = $__5.labelSet_[k];
        });
        labelSet.set(label.name, label);
        this.labelSet_ = labelSet;
        return oldLabels;
      },
      clearLabels_: function() {
        var result = this.labelSet_;
        this.labelSet_ = new StringMap();
        return result;
      },
      clearCurrentLabel_: function() {
        var result = this.currentLabel_;
        this.currentLabel_ = null;
        return result;
      },
      transformSwitchStatement: function(tree) {
        var $__6,
            $__7;
        var labels = this.getLabels_();
        var expression,
            machine,
            caseClauses;
        if (this.expressionNeedsStateMachine(tree.expression)) {
          (($__6 = this.expressionToStateMachine(tree.expression), expression = $__6.expression, machine = $__6.machine, $__6));
          caseClauses = this.transformList(tree.caseClauses);
        } else {
          var result = $traceurRuntime.superGet(this, CPSTransformer.prototype, "transformSwitchStatement").call(this, tree);
          if (!needsStateMachine(result))
            return result;
          (($__7 = result, expression = $__7.expression, caseClauses = $__7.caseClauses, $__7));
        }
        var startState = this.allocateState();
        var fallThroughState = this.allocateState();
        var nextState = fallThroughState;
        var states = [];
        var clauses = [];
        var tryStates = [];
        var hasDefault = false;
        for (var index = caseClauses.length - 1; index >= 0; index--) {
          var clause = caseClauses[index];
          if (clause.type === CASE_CLAUSE) {
            var caseClause = clause;
            nextState = this.addSwitchClauseStates_(nextState, fallThroughState, labels, caseClause.statements, states, tryStates);
            clauses.push(new SwitchClause(caseClause.expression, nextState));
          } else {
            hasDefault = true;
            var defaultClause = clause;
            nextState = this.addSwitchClauseStates_(nextState, fallThroughState, labels, defaultClause.statements, states, tryStates);
            clauses.push(new SwitchClause(null, nextState));
          }
        }
        if (!hasDefault) {
          clauses.push(new SwitchClause(null, fallThroughState));
        }
        states.push(new SwitchState(startState, expression, clauses.reverse()));
        var switchMachine = new StateMachine(startState, fallThroughState, states.reverse(), tryStates);
        if (machine)
          switchMachine = machine.append(switchMachine);
        return switchMachine;
      },
      addSwitchClauseStates_: function(nextState, fallThroughState, labels, statements, states, tryStates) {
        var $__8;
        var machine = this.ensureTransformedList_(statements);
        for (var i = 0; i < machine.states.length; i++) {
          var state = machine.states[i];
          var transformedState = state.transformBreak(labels, fallThroughState);
          states.push(transformedState.replaceState(machine.fallThroughState, nextState));
        }
        ($__8 = tryStates).push.apply($__8, $traceurRuntime.spread(machine.exceptionBlocks));
        return machine.startState;
      },
      transformTryStatement: function(tree) {
        var result = $traceurRuntime.superGet(this, CPSTransformer.prototype, "transformTryStatement").call(this, tree);
        var $__6 = result,
            body = $__6.body,
            catchBlock = $__6.catchBlock,
            finallyBlock = $__6.finallyBlock;
        if (body.type !== STATE_MACHINE && (catchBlock === null || catchBlock.catchBody.type !== STATE_MACHINE) && (finallyBlock === null || finallyBlock.block.type !== STATE_MACHINE)) {
          return result;
        }
        var outerCatchState = this.allocateState();
        var outerFinallyState = this.allocateState();
        var pushTryState = this.statementToStateMachine_(parseStatement($traceurRuntime.getTemplateObject(["$ctx.pushTry(\n            ", ",\n            ", ");"]), (catchBlock && outerCatchState), (finallyBlock && outerFinallyState)));
        var tryMachine = this.ensureTransformed_(body);
        tryMachine = pushTryState.append(tryMachine);
        if (catchBlock !== null) {
          var popTry = this.statementToStateMachine_(parseStatement($traceurRuntime.getTemplateObject(["$ctx.popTry();"])));
          tryMachine = tryMachine.append(popTry);
          var exceptionName = catchBlock.binding.identifierToken.value;
          var catchMachine = this.ensureTransformed_(catchBlock.catchBody);
          var catchStart = this.allocateState();
          this.addMachineVariable(exceptionName);
          var states = $traceurRuntime.spread(tryMachine.states, [new FallThroughState(catchStart, catchMachine.startState, parseStatements($traceurRuntime.getTemplateObject(["\n              $ctx.popTry();\n              $ctx.maybeUncatchable(); // see RETURN_SENTINEL in runtime\n              ", " = $ctx.storedException;"]), id(exceptionName)))]);
          this.replaceAndAddStates_(catchMachine.states, catchMachine.fallThroughState, tryMachine.fallThroughState, states);
          tryMachine = new StateMachine(tryMachine.startState, tryMachine.fallThroughState, states, [new CatchState(exceptionName, catchStart, tryMachine.fallThroughState, tryMachine.getAllStateIDs(), tryMachine.exceptionBlocks)]);
          tryMachine = tryMachine.replaceStateId(catchStart, outerCatchState);
        }
        if (finallyBlock !== null) {
          var finallyMachine = this.ensureTransformed_(finallyBlock.block);
          var popTry$__15 = this.statementToStateMachine_(parseStatement($traceurRuntime.getTemplateObject(["$ctx.popTry();"])));
          finallyMachine = popTry$__15.append(finallyMachine);
          var states$__16 = $traceurRuntime.spread(tryMachine.states, finallyMachine.states, [new FinallyFallThroughState(finallyMachine.fallThroughState)]);
          tryMachine = new StateMachine(tryMachine.startState, tryMachine.fallThroughState, states$__16, [new FinallyState(finallyMachine.startState, finallyMachine.fallThroughState, tryMachine.getAllStateIDs(), tryMachine.exceptionBlocks)]);
          tryMachine = tryMachine.replaceStateId(finallyMachine.startState, outerFinallyState);
        }
        return tryMachine;
      },
      transformWhileStatement: function(tree) {
        var $__8;
        var $__6,
            $__7;
        var labels = this.getLabels_();
        var label = this.clearCurrentLabel_();
        var condition,
            machine,
            body;
        if (this.expressionNeedsStateMachine(tree.condition)) {
          (($__6 = this.expressionToStateMachine(tree.condition), machine = $__6.machine, condition = $__6.expression, $__6));
          body = this.transformAny(tree.body);
        } else {
          var result = $traceurRuntime.superGet(this, CPSTransformer.prototype, "transformWhileStatement").call(this, tree);
          (($__7 = result, condition = $__7.condition, body = $__7.body, $__7));
          if (body.type !== STATE_MACHINE)
            return result;
        }
        var loopBodyMachine = this.ensureTransformed_(body);
        var startState = loopBodyMachine.fallThroughState;
        var fallThroughState = this.allocateState();
        var states = [];
        var conditionStart = startState;
        if (machine) {
          machine = machine.replaceStartState(startState);
          conditionStart = machine.fallThroughState;
          ($__8 = states).push.apply($__8, $traceurRuntime.spread(machine.states));
        }
        states.push(new ConditionalState(conditionStart, loopBodyMachine.startState, fallThroughState, condition));
        this.addLoopBodyStates_(loopBodyMachine, startState, fallThroughState, labels, states);
        machine = new StateMachine(startState, fallThroughState, states, loopBodyMachine.exceptionBlocks);
        if (label)
          machine = machine.replaceStateId(startState, label.continueState);
        return machine;
      },
      transformWithStatement: function(tree) {
        var result = $traceurRuntime.superGet(this, CPSTransformer.prototype, "transformWithStatement").call(this, tree);
        if (result.body.type !== STATE_MACHINE) {
          return result;
        }
        throw new Error('Unreachable - with statement not allowed in strict mode/harmony');
      },
      generateMachineInnerFunction: function(machine) {
        var enclosingFinallyState = machine.getEnclosingFinallyMap();
        var SwitchStatement = createSwitchStatement(createMemberExpression('$ctx', 'state'), this.transformMachineStates(machine, State.END_STATE, State.RETHROW_STATE, enclosingFinallyState));
        return parseExpression($traceurRuntime.getTemplateObject(["function($ctx) {\n      while (true) ", "\n    }"]), SwitchStatement);
      },
      addTempVar: function() {
        var name = this.getTempIdentifier();
        this.addMachineVariable(name);
        return name;
      },
      addMachineVariable: function(name) {
        this.hoistVariablesTransformer_.addVariable(name);
      },
      transformCpsFunctionBody: function(tree, runtimeMethod) {
        var $__8;
        var functionRef = arguments[2];
        var alphaRenamedTree = AlphaRenamer.rename(tree, 'arguments', '$arguments');
        var hasArguments = alphaRenamedTree !== tree;
        var hoistedTree = this.hoistVariablesTransformer_.transformAny(alphaRenamedTree);
        var maybeMachine = this.transformAny(hoistedTree);
        if (this.reporter.hadError())
          return tree;
        var machine;
        if (maybeMachine.type !== STATE_MACHINE) {
          machine = this.statementsToStateMachine_(maybeMachine.statements);
        } else {
          machine = new StateMachine(maybeMachine.startState, maybeMachine.fallThroughState, this.removeEmptyStates(maybeMachine.states), maybeMachine.exceptionBlocks);
        }
        machine = machine.replaceFallThroughState(State.END_STATE).replaceStartState(State.START_STATE);
        var statements = [];
        if (this.hoistVariablesTransformer_.hasFunctions())
          ($__8 = statements).push.apply($__8, $traceurRuntime.spread(this.hoistVariablesTransformer_.getFunctions()));
        if (this.hoistVariablesTransformer_.hasVariables())
          statements.push(this.hoistVariablesTransformer_.getVariableStatement());
        if (hasArguments)
          statements.push(parseStatement($traceurRuntime.getTemplateObject(["var $arguments = arguments;"])));
        if (functionRef) {
          statements.push(parseStatement($traceurRuntime.getTemplateObject(["return ", "(\n              ", ",\n              ", ", this);"]), runtimeMethod, this.generateMachineInnerFunction(machine), functionRef));
        } else {
          statements.push(parseStatement($traceurRuntime.getTemplateObject(["return ", "(\n              ", ", this);"]), runtimeMethod, this.generateMachineInnerFunction(machine)));
        }
        return createFunctionBody(statements);
      },
      transformFunctionDeclaration: function(tree) {
        return tree;
      },
      transformFunctionExpression: function(tree) {
        return tree;
      },
      transformGetAccessor: function(tree) {
        return tree;
      },
      transformSetAccessor: function(tree) {
        return tree;
      },
      transformArrowFunction: function(tree) {
        return tree;
      },
      transformStateMachine: function(tree) {
        return tree;
      },
      statementToStateMachine_: function(statement) {
        var statements;
        if (statement.type === BLOCK)
          statements = statement.statements;
        else
          statements = [statement];
        return this.statementsToStateMachine_(statements);
      },
      statementsToStateMachine_: function(statements) {
        var startState = this.allocateState();
        var fallThroughState = this.allocateState();
        return this.stateToStateMachine_(new FallThroughState(startState, fallThroughState, statements), fallThroughState);
      },
      stateToStateMachine_: function(newState, fallThroughState) {
        return new StateMachine(newState.id, fallThroughState, [newState], []);
      },
      transformMachineStates: function(machine, machineEndState, rethrowState, enclosingFinallyState) {
        var cases = [];
        for (var i = 0; i < machine.states.length; i++) {
          var state = machine.states[i];
          var stateCase = state.transformMachineState(enclosingFinallyState[state.id], machineEndState, this.reporter);
          if (stateCase !== null) {
            cases.push(stateCase);
          }
        }
        this.addFinallyFallThroughDispatches(null, machine.exceptionBlocks, cases);
        cases.push(createDefaultClause(parseStatements($traceurRuntime.getTemplateObject(["return $ctx.end()"]))));
        return cases;
      },
      addFinallyFallThroughDispatches: function(enclosingFinallyState, tryStates, cases) {
        for (var i = 0; i < tryStates.length; i++) {
          var tryState = tryStates[i];
          if (tryState.kind === TryState.Kind.FINALLY) {
            var finallyState = tryState;
            if (enclosingFinallyState !== null) {
              var caseClauses = [];
              var index = 0;
              for (var j = 0; j < enclosingFinallyState.tryStates.length; j++) {
                var destination = enclosingFinallyState.tryStates[j];
                index++;
                var statements = void 0;
                if (index < enclosingFinallyState.tryStates.length) {
                  statements = [];
                } else {
                  statements = parseStatements($traceurRuntime.getTemplateObject(["\n                  $ctx.state = $ctx.finallyFallThrough;\n                  $ctx.finallyFallThrough = ", ";\n                  break;"]), State.INVALID_STATE);
                }
                caseClauses.push(createCaseClause(createNumberLiteral(destination), statements));
              }
              caseClauses.push(createDefaultClause([createAssignStateStatement(enclosingFinallyState.finallyState), createBreakStatement()]));
              cases.push(createCaseClause(createNumberLiteral(finallyState.fallThroughState), [createSwitchStatement(createMemberExpression('$ctx', 'finallyFallThrough'), caseClauses), createBreakStatement()]));
            } else {
              cases.push(createCaseClause(createNumberLiteral(finallyState.fallThroughState), parseStatements($traceurRuntime.getTemplateObject(["\n                      $ctx.state = $ctx.finallyFallThrough;\n                      break;"]))));
            }
            this.addFinallyFallThroughDispatches(finallyState, finallyState.nestedTrys, cases);
          } else {
            this.addFinallyFallThroughDispatches(enclosingFinallyState, tryState.nestedTrys, cases);
          }
        }
      },
      transformVariableDeclarationList: function(tree) {
        this.reporter.reportError(tree.location, 'Traceur: const/let declarations in a block containing a yield are ' + 'not yet implemented');
        return tree;
      },
      maybeTransformStatement_: function(maybeTransformedStatement) {
        var breakContinueTransformed = new BreakContinueTransformer(this.stateAllocator_).transformAny(maybeTransformedStatement);
        if (breakContinueTransformed !== maybeTransformedStatement) {
          breakContinueTransformed = this.transformAny(breakContinueTransformed);
        }
        return breakContinueTransformed;
      },
      ensureTransformed_: function(statement) {
        if (statement === null) {
          return null;
        }
        var maybeTransformed = this.maybeTransformStatement_(statement);
        return maybeTransformed.type === STATE_MACHINE ? maybeTransformed : this.statementToStateMachine_(maybeTransformed);
      },
      ensureTransformedList_: function(statements) {
        var maybeTransformedStatements = [];
        var foundMachine = false;
        for (var i = 0; i < statements.length; i++) {
          var statement = statements[i];
          var maybeTransformedStatement = this.maybeTransformStatement_(statement);
          maybeTransformedStatements.push(maybeTransformedStatement);
          if (maybeTransformedStatement.type === STATE_MACHINE) {
            foundMachine = true;
          }
        }
        if (!foundMachine) {
          return this.statementsToStateMachine_(statements);
        }
        return this.transformStatementList_(maybeTransformedStatements);
      },
      expressionToStateMachine: function(tree) {
        var commaExpression = new ExplodeExpressionTransformer(this).transformAny(tree);
        var statements = new NormalizeCommaExpressionToStatementTransformer().transformAny(commaExpression).statements;
        var lastStatement = statements.pop();
        assert(lastStatement.type === EXPRESSION_STATEMENT);
        var expression = lastStatement.expression;
        statements = $traceurRuntime.superGet(this, CPSTransformer.prototype, "transformList").call(this, statements);
        var machine = this.transformStatementList_(statements);
        return {
          expression: expression,
          machine: machine
        };
      }
    }, {}, $__super);
  }(TempVarTransformer);
  var NormalizeCommaExpressionToStatementTransformer = function($__super) {
    function NormalizeCommaExpressionToStatementTransformer() {
      $traceurRuntime.superConstructor(NormalizeCommaExpressionToStatementTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(NormalizeCommaExpressionToStatementTransformer, {
      transformCommaExpression: function(tree) {
        var $__5 = this;
        var statements = tree.expressions.map(function(expr) {
          if (expr.type === CONDITIONAL_EXPRESSION)
            return $__5.transformAny(expr);
          return createExpressionStatement(expr);
        });
        return new AnonBlock(tree.location, statements);
      },
      transformConditionalExpression: function(tree) {
        var ifBlock = this.transformAny(tree.left);
        var elseBlock = this.transformAny(tree.right);
        return new IfStatement(tree.location, tree.condition, anonBlockToBlock(ifBlock), anonBlockToBlock(elseBlock));
      }
    }, {}, $__super);
  }(ParseTreeTransformer);
  function anonBlockToBlock(tree) {
    if (tree.type === PAREN_EXPRESSION)
      return anonBlockToBlock(tree.expression);
    return new Block(tree.location, tree.statements);
  }
  return {get CPSTransformer() {
      return CPSTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/EndState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/EndState.js";
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/EndState.js")).State;
  var EndState = function($__super) {
    function EndState() {
      $traceurRuntime.superConstructor(EndState).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(EndState, {
      replaceState: function(oldState, newState) {
        return new EndState(State.replaceStateId(this.id, oldState, newState));
      },
      transform: function(enclosingFinally, machineEndState, reporter) {
        return State.generateJump(enclosingFinally, machineEndState);
      }
    }, {}, $__super);
  }(State);
  return {get EndState() {
      return EndState;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/AsyncTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/AsyncTransformer.js";
  var AwaitState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./AwaitState.js", "traceur@0.0.108/src/codegeneration/generator/AsyncTransformer.js")).AwaitState;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/generator/AsyncTransformer.js")),
      BinaryExpression = $__4.BinaryExpression,
      ExpressionStatement = $__4.ExpressionStatement;
  var CPSTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./CPSTransformer.js", "traceur@0.0.108/src/codegeneration/generator/AsyncTransformer.js")).CPSTransformer;
  var EndState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./EndState.js", "traceur@0.0.108/src/codegeneration/generator/AsyncTransformer.js")).EndState;
  var FallThroughState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FallThroughState.js", "traceur@0.0.108/src/codegeneration/generator/AsyncTransformer.js")).FallThroughState;
  var $__8 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/generator/AsyncTransformer.js")),
      AWAIT_EXPRESSION = $__8.AWAIT_EXPRESSION,
      BINARY_EXPRESSION = $__8.BINARY_EXPRESSION,
      STATE_MACHINE = $__8.STATE_MACHINE;
  var $__9 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/generator/AsyncTransformer.js")),
      parseExpression = $__9.parseExpression,
      parseStatement = $__9.parseStatement,
      parseStatements = $__9.parseStatements;
  var StateMachine = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/StateMachine.js", "traceur@0.0.108/src/codegeneration/generator/AsyncTransformer.js")).StateMachine;
  var FindInFunctionScope = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../FindInFunctionScope.js", "traceur@0.0.108/src/codegeneration/generator/AsyncTransformer.js")).FindInFunctionScope;
  var createUndefinedExpression = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/generator/AsyncTransformer.js")).createUndefinedExpression;
  function isAwaitAssign(tree) {
    return tree.type === BINARY_EXPRESSION && tree.operator.isAssignmentOperator() && tree.right.type === AWAIT_EXPRESSION && tree.left.isLeftHandSideExpression();
  }
  var AwaitFinder = function($__super) {
    function AwaitFinder() {
      $traceurRuntime.superConstructor(AwaitFinder).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(AwaitFinder, {visitAwaitExpression: function(tree) {
        this.found = true;
      }}, {}, $__super);
  }(FindInFunctionScope);
  function scopeContainsAwait(tree) {
    var visitor = new AwaitFinder();
    visitor.visitAny(tree);
    return visitor.found;
  }
  var AsyncTransformer = function($__super) {
    function AsyncTransformer() {
      $traceurRuntime.superConstructor(AsyncTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(AsyncTransformer, {
      expressionNeedsStateMachine: function(tree) {
        if (tree === null)
          return false;
        return scopeContainsAwait(tree);
      },
      transformExpressionStatement: function(tree) {
        var expression = tree.expression;
        if (expression.type === AWAIT_EXPRESSION)
          return this.transformAwaitExpression_(expression);
        if (isAwaitAssign(expression))
          return this.transformAwaitAssign_(expression);
        if (this.expressionNeedsStateMachine(expression)) {
          return this.expressionToStateMachine(expression).machine;
        }
        return $traceurRuntime.superGet(this, AsyncTransformer.prototype, "transformExpressionStatement").call(this, tree);
      },
      transformAwaitExpression: function(tree) {
        throw new Error('Internal error');
      },
      transformAwaitExpression_: function(tree) {
        return this.transformAwait_(tree, tree.expression, null, null);
      },
      transformAwaitAssign_: function(tree) {
        return this.transformAwait_(tree, tree.right.expression, tree.left, tree.operator);
      },
      transformAwait_: function(tree, inExpression, left, operator) {
        var $__2;
        var expression,
            machine;
        if (this.expressionNeedsStateMachine(inExpression)) {
          (($__2 = this.expressionToStateMachine(inExpression), expression = $__2.expression, machine = $__2.machine, $__2));
        } else {
          expression = this.transformAny(inExpression);
        }
        var createTaskState = this.allocateState();
        var fallThroughState = this.allocateState();
        var callbackState = left ? this.allocateState() : fallThroughState;
        var states = [];
        states.push(new AwaitState(createTaskState, callbackState, expression));
        if (left) {
          var statement = new ExpressionStatement(tree.location, new BinaryExpression(tree.location, left, operator, parseExpression($traceurRuntime.getTemplateObject(["$ctx.value"]))));
          states.push(new FallThroughState(callbackState, fallThroughState, [statement]));
        }
        var awaitMachine = new StateMachine(createTaskState, fallThroughState, states, []);
        if (machine) {
          awaitMachine = machine.append(awaitMachine);
        }
        return awaitMachine;
      },
      transformFinally: function(tree) {
        var result = $traceurRuntime.superGet(this, AsyncTransformer.prototype, "transformFinally").call(this, tree);
        if (result.block.type !== STATE_MACHINE) {
          return result;
        }
        this.reporter.reportError(tree.location, 'await not permitted within a finally block.');
        return result;
      },
      transformReturnStatement: function(tree) {
        var $__2;
        var expression,
            machine;
        if (this.expressionNeedsStateMachine(tree.expression)) {
          (($__2 = this.expressionToStateMachine(tree.expression), expression = $__2.expression, machine = $__2.machine, $__2));
        } else {
          expression = tree.expression || createUndefinedExpression();
        }
        var startState = this.allocateState();
        var endState = this.allocateState();
        var completeState = new FallThroughState(startState, endState, parseStatements($traceurRuntime.getTemplateObject(["$ctx.returnValue = ", ""]), expression));
        var end = new EndState(endState);
        var returnMachine = new StateMachine(startState, this.allocateState(), [completeState, end], []);
        if (machine)
          returnMachine = machine.append(returnMachine);
        return returnMachine;
      },
      createCompleteTask_: function(result) {
        return parseStatement($traceurRuntime.getTemplateObject(["$ctx.resolve(", ")"]), result);
      },
      transformAsyncBody: function(tree) {
        var runtimeFunction = parseExpression($traceurRuntime.getTemplateObject(["$traceurRuntime.asyncWrap"]));
        return this.transformCpsFunctionBody(tree, runtimeFunction);
      }
    }, {transformAsyncBody: function(identifierGenerator, reporter, options, body) {
        return new AsyncTransformer(identifierGenerator, reporter, options).transformAsyncBody(body);
      }}, $__super);
  }(CPSTransformer);
  ;
  return {get AsyncTransformer() {
      return AsyncTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/ForInTransformPass.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/ForInTransformPass.js";
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/generator/ForInTransformPass.js")),
      BLOCK = $__3.BLOCK,
      VARIABLE_DECLARATION_LIST = $__3.VARIABLE_DECLARATION_LIST,
      IDENTIFIER_EXPRESSION = $__3.IDENTIFIER_EXPRESSION;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/PredefinedName.js", "traceur@0.0.108/src/codegeneration/generator/ForInTransformPass.js")),
      LENGTH = $__4.LENGTH,
      PUSH = $__4.PUSH;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/generator/ForInTransformPass.js")).TempVarTransformer;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/generator/ForInTransformPass.js")),
      BANG = $__6.BANG,
      IN = $__6.IN,
      OPEN_ANGLE = $__6.OPEN_ANGLE,
      PLUS_PLUS = $__6.PLUS_PLUS,
      VAR = $__6.VAR;
  var $__7 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/generator/ForInTransformPass.js")),
      createArgumentList = $__7.createArgumentList,
      createAssignmentStatement = $__7.createAssignmentStatement,
      createBinaryExpression = $__7.createBinaryExpression,
      createBlock = $__7.createBlock,
      createCallStatement = $__7.createCallStatement,
      createContinueStatement = $__7.createContinueStatement,
      createEmptyArrayLiteral = $__7.createEmptyArrayLiteral,
      createForInStatement = $__7.createForInStatement,
      createForStatement = $__7.createForStatement,
      createIdentifierExpression = $__7.createIdentifierExpression,
      createIfStatement = $__7.createIfStatement,
      createMemberExpression = $__7.createMemberExpression,
      createMemberLookupExpression = $__7.createMemberLookupExpression,
      createNumberLiteral = $__7.createNumberLiteral,
      createOperatorToken = $__7.createOperatorToken,
      createParenExpression = $__7.createParenExpression,
      createPostfixExpression = $__7.createPostfixExpression,
      createUnaryExpression = $__7.createUnaryExpression,
      createVariableDeclarationList = $__7.createVariableDeclarationList,
      createVariableStatement = $__7.createVariableStatement;
  var ForInTransformPass = function($__super) {
    function ForInTransformPass() {
      $traceurRuntime.superConstructor(ForInTransformPass).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(ForInTransformPass, {transformForInStatement: function(tree) {
        var $__1,
            $__2;
        var bodyStatements = [];
        var body = this.transformAny(tree.body);
        if (body.type === BLOCK) {
          ($__1 = bodyStatements).push.apply($__1, $traceurRuntime.spread(body.statements));
        } else {
          bodyStatements.push(body);
        }
        var elements = [];
        var keys = this.getTempIdentifier();
        elements.push(createVariableStatement(VAR, keys, createEmptyArrayLiteral()));
        var collection = this.getTempIdentifier();
        elements.push(createVariableStatement(VAR, collection, tree.collection));
        var p = this.getTempIdentifier();
        elements.push(createForInStatement(createVariableDeclarationList(VAR, p, null), createIdentifierExpression(collection), createCallStatement(createMemberExpression(keys, PUSH), createArgumentList([createIdentifierExpression(p)]))));
        var i = this.getTempIdentifier();
        var lookup = createMemberLookupExpression(createIdentifierExpression(keys), createIdentifierExpression(i));
        var originalKey,
            assignOriginalKey;
        if (tree.initializer.type === VARIABLE_DECLARATION_LIST) {
          var decList = tree.initializer;
          originalKey = createIdentifierExpression(decList.declarations[0].lvalue);
          assignOriginalKey = createVariableStatement(decList.declarationType, originalKey.identifierToken, lookup);
        } else if (tree.initializer.type === IDENTIFIER_EXPRESSION) {
          originalKey = tree.initializer;
          assignOriginalKey = createAssignmentStatement(tree.initializer, lookup);
        } else {
          throw new Error('Invalid left hand side of for in loop');
        }
        var innerBlock = [];
        innerBlock.push(assignOriginalKey);
        innerBlock.push(createIfStatement(createUnaryExpression(createOperatorToken(BANG), createParenExpression(createBinaryExpression(originalKey, createOperatorToken(IN), createIdentifierExpression(collection)))), createContinueStatement(), null));
        ($__2 = innerBlock).push.apply($__2, $traceurRuntime.spread(bodyStatements));
        elements.push(createForStatement(createVariableDeclarationList(VAR, i, createNumberLiteral(0)), createBinaryExpression(createIdentifierExpression(i), createOperatorToken(OPEN_ANGLE), createMemberExpression(keys, LENGTH)), createPostfixExpression(createIdentifierExpression(i), createOperatorToken(PLUS_PLUS)), createBlock(innerBlock)));
        return createBlock(elements);
      }}, {}, $__super);
  }(TempVarTransformer);
  return {get ForInTransformPass() {
      return ForInTransformPass;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/YieldState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/YieldState.js";
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/YieldState.js")).State;
  var createReturnStatement = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/generator/YieldState.js")).createReturnStatement;
  var YieldState = function($__super) {
    function YieldState(id, fallThroughState, expression) {
      $traceurRuntime.superConstructor(YieldState).call(this, id);
      this.fallThroughState = fallThroughState;
      this.expression = expression;
    }
    return ($traceurRuntime.createClass)(YieldState, {
      replaceState: function(oldState, newState) {
        return new this.constructor(State.replaceStateId(this.id, oldState, newState), State.replaceStateId(this.fallThroughState, oldState, newState), this.expression);
      },
      transform: function(enclosingFinally, machineEndState, reporter) {
        return $traceurRuntime.spread(State.generateAssignState(enclosingFinally, this.fallThroughState), [createReturnStatement(this.expression)]);
      }
    }, {}, $__super);
  }(State);
  return {get YieldState() {
      return YieldState;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/ReturnState.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/ReturnState.js";
  var $__2 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../semantics/util.js", "traceur@0.0.108/src/codegeneration/generator/ReturnState.js")),
      isUndefined = $__2.isUndefined,
      isVoidExpression = $__2.isVoidExpression;
  var YieldState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./YieldState.js", "traceur@0.0.108/src/codegeneration/generator/ReturnState.js")).YieldState;
  var State = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./State.js", "traceur@0.0.108/src/codegeneration/generator/ReturnState.js")).State;
  var parseStatement = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/generator/ReturnState.js")).parseStatement;
  var ReturnState = function($__super) {
    function ReturnState() {
      $traceurRuntime.superConstructor(ReturnState).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(ReturnState, {transform: function(enclosingFinally, machineEndState, reporter) {
        var $__1;
        var e = this.expression;
        var statements = [];
        if (e && !isUndefined(e) && !isVoidExpression(e))
          statements.push(parseStatement($traceurRuntime.getTemplateObject(["$ctx.returnValue = ", ""]), this.expression));
        ($__1 = statements).push.apply($__1, $traceurRuntime.spread(State.generateJump(enclosingFinally, machineEndState)));
        return statements;
      }}, {}, $__super);
  }(YieldState);
  return {get ReturnState() {
      return ReturnState;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/generator/GeneratorTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/generator/GeneratorTransformer.js";
  var CPSTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./CPSTransformer.js", "traceur@0.0.108/src/codegeneration/generator/GeneratorTransformer.js")).CPSTransformer;
  var $__4 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/generator/GeneratorTransformer.js")),
      BINARY_EXPRESSION = $__4.BINARY_EXPRESSION,
      YIELD_EXPRESSION = $__4.YIELD_EXPRESSION;
  var $__5 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/generator/GeneratorTransformer.js")),
      BinaryExpression = $__5.BinaryExpression,
      ExpressionStatement = $__5.ExpressionStatement;
  var FindInFunctionScope = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../FindInFunctionScope.js", "traceur@0.0.108/src/codegeneration/generator/GeneratorTransformer.js")).FindInFunctionScope;
  var ReturnState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ReturnState.js", "traceur@0.0.108/src/codegeneration/generator/GeneratorTransformer.js")).ReturnState;
  var YieldState = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./YieldState.js", "traceur@0.0.108/src/codegeneration/generator/GeneratorTransformer.js")).YieldState;
  var $__9 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/generator/GeneratorTransformer.js")),
      id = $__9.createIdentifierExpression,
      createMemberExpression = $__9.createMemberExpression,
      createUndefinedExpression = $__9.createUndefinedExpression;
  var $__10 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/generator/GeneratorTransformer.js")),
      parseExpression = $__10.parseExpression,
      parseStatement = $__10.parseStatement,
      parseStatements = $__10.parseStatements;
  function isYieldAssign(tree) {
    return tree.type === BINARY_EXPRESSION && tree.operator.isAssignmentOperator() && tree.right.type === YIELD_EXPRESSION && tree.left.isLeftHandSideExpression();
  }
  var YieldFinder = function($__super) {
    function YieldFinder() {
      $traceurRuntime.superConstructor(YieldFinder).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(YieldFinder, {visitYieldExpression: function(tree) {
        this.found = true;
      }}, {}, $__super);
  }(FindInFunctionScope);
  function scopeContainsYield(tree) {
    var finder = new YieldFinder();
    finder.visitAny(tree);
    return finder.found;
  }
  var GeneratorTransformer = function($__super) {
    function GeneratorTransformer(identifierGenerator, reporter, options) {
      $traceurRuntime.superConstructor(GeneratorTransformer).call(this, identifierGenerator, reporter, options);
      this.shouldAppendThrowCloseState_ = true;
    }
    return ($traceurRuntime.createClass)(GeneratorTransformer, {
      expressionNeedsStateMachine: function(tree) {
        if (tree === null)
          return false;
        return scopeContainsYield(tree);
      },
      transformYieldExpression_: function(tree) {
        var $__2;
        var expression,
            machine;
        if (this.expressionNeedsStateMachine(tree.expression)) {
          (($__2 = this.expressionToStateMachine(tree.expression), expression = $__2.expression, machine = $__2.machine, $__2));
        } else {
          expression = this.transformAny(tree.expression);
        }
        if (tree.isYieldFor)
          return this.transformYieldForExpression_(expression, machine);
        var startState = this.allocateState();
        var fallThroughState = this.allocateState();
        var yieldMachine = this.stateToStateMachine_(new YieldState(startState, fallThroughState, expression), fallThroughState);
        if (machine)
          yieldMachine = machine.append(yieldMachine);
        if (this.shouldAppendThrowCloseState_)
          yieldMachine = yieldMachine.append(this.createThrowCloseState_());
        return yieldMachine;
      },
      transformYieldForExpression_: function(expression) {
        var machine = arguments[1];
        var gName = this.getTempIdentifier();
        this.addMachineVariable(gName);
        var g = id(gName);
        var nextName = this.getTempIdentifier();
        this.addMachineVariable(nextName);
        var next = id(nextName);
        var statements = parseStatements($traceurRuntime.getTemplateObject(["\n        ", " = $ctx.wrapYieldStar(", "[Symbol.iterator]());\n        // received = void 0;\n        $ctx.sent = void 0;\n        // send = true; // roughly equivalent\n        $ctx.action = 'next';\n\n        for (;;) {\n          ", " = ", "[$ctx.action]($ctx.sentIgnoreThrow);\n          if (", ".done) {\n            $ctx.sent = ", ".value;\n            break;\n          }\n          yield ", ".value;\n        }"]), g, expression, next, g, next, next, next);
        var shouldAppendThrowCloseState = this.shouldAppendThrowCloseState_;
        this.shouldAppendThrowCloseState_ = false;
        statements = this.transformList(statements);
        var yieldMachine = this.transformStatementList_(statements);
        this.shouldAppendThrowCloseState_ = shouldAppendThrowCloseState;
        if (machine)
          yieldMachine = machine.append(yieldMachine);
        return yieldMachine;
      },
      transformYieldExpression: function(tree) {
        this.reporter.reportError(tree.location, 'Only \'a = yield b\' and \'var a = yield b\' currently supported.');
        return tree;
      },
      transformYieldAssign_: function(tree) {
        var shouldAppendThrowCloseState = this.shouldAppendThrowCloseState_;
        this.shouldAppendThrowCloseState_ = false;
        var machine = this.transformYieldExpression_(tree.right);
        var left = this.transformAny(tree.left);
        var sentExpression = tree.right.isYieldFor ? parseExpression($traceurRuntime.getTemplateObject(["$ctx.sentIgnoreThrow"])) : parseExpression($traceurRuntime.getTemplateObject(["$ctx.sent"]));
        var statement = new ExpressionStatement(tree.location, new BinaryExpression(tree.location, left, tree.operator, sentExpression));
        var assignMachine = this.statementToStateMachine_(statement);
        this.shouldAppendThrowCloseState_ = shouldAppendThrowCloseState;
        return machine.append(assignMachine);
      },
      createThrowCloseState_: function() {
        return this.statementToStateMachine_(parseStatement($traceurRuntime.getTemplateObject(["$ctx.maybeThrow()"])));
      },
      transformExpressionStatement: function(tree) {
        var expression = tree.expression;
        if (expression.type === YIELD_EXPRESSION)
          return this.transformYieldExpression_(expression);
        if (isYieldAssign(expression))
          return this.transformYieldAssign_(expression);
        if (this.expressionNeedsStateMachine(expression)) {
          return this.expressionToStateMachine(expression).machine;
        }
        return $traceurRuntime.superGet(this, GeneratorTransformer.prototype, "transformExpressionStatement").call(this, tree);
      },
      transformAwaitStatement: function(tree) {
        this.reporter.reportError(tree.location, 'Generator function may not have an await statement.');
        return tree;
      },
      transformReturnStatement: function(tree) {
        var $__2;
        var expression,
            machine;
        if (this.expressionNeedsStateMachine(tree.expression))
          (($__2 = this.expressionToStateMachine(tree.expression), expression = $__2.expression, machine = $__2.machine, $__2));
        else
          expression = tree.expression;
        var startState = this.allocateState();
        var fallThroughState = this.allocateState();
        var returnMachine = this.stateToStateMachine_(new ReturnState(startState, fallThroughState, this.transformAny(expression)), fallThroughState);
        if (machine)
          return machine.append(returnMachine);
        return returnMachine;
      },
      transformGeneratorBody: function(tree, name) {
        var runtimeFunction = parseExpression($traceurRuntime.getTemplateObject(["$traceurRuntime.createGeneratorInstance"]));
        return this.transformCpsFunctionBody(tree, runtimeFunction, name);
      }
    }, {transformGeneratorBody: function(identifierGenerator, reporter, options, body, name) {
        return new GeneratorTransformer(identifierGenerator, reporter, options).transformGeneratorBody(body, name);
      }}, $__super);
  }(CPSTransformer);
  ;
  return {get GeneratorTransformer() {
      return GeneratorTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/GeneratorTransformPass.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/GeneratorTransformPass.js";
  var ArrowFunctionTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ArrowFunctionTransformer.js", "traceur@0.0.108/src/codegeneration/GeneratorTransformPass.js")).ArrowFunctionTransformer;
  var AsyncTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./generator/AsyncTransformer.js", "traceur@0.0.108/src/codegeneration/GeneratorTransformPass.js")).AsyncTransformer;
  var ForInTransformPass = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./generator/ForInTransformPass.js", "traceur@0.0.108/src/codegeneration/GeneratorTransformPass.js")).ForInTransformPass;
  var GeneratorTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./generator/GeneratorTransformer.js", "traceur@0.0.108/src/codegeneration/GeneratorTransformPass.js")).GeneratorTransformer;
  var $__6 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/GeneratorTransformPass.js")),
      parseExpression = $__6.parseExpression,
      parseStatement = $__6.parseStatement;
  var TempVarTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./TempVarTransformer.js", "traceur@0.0.108/src/codegeneration/GeneratorTransformPass.js")).TempVarTransformer;
  var FindInFunctionScope = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./FindInFunctionScope.js", "traceur@0.0.108/src/codegeneration/GeneratorTransformPass.js")).FindInFunctionScope;
  var $__9 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/GeneratorTransformPass.js")),
      AnonBlock = $__9.AnonBlock,
      FunctionDeclaration = $__9.FunctionDeclaration,
      FunctionExpression = $__9.FunctionExpression;
  var $__10 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/GeneratorTransformPass.js")),
      createBindingIdentifier = $__10.createBindingIdentifier,
      id = $__10.createIdentifierExpression,
      createIdentifierToken = $__10.createIdentifierToken;
  var ForInFinder = function($__super) {
    function ForInFinder() {
      $traceurRuntime.superConstructor(ForInFinder).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(ForInFinder, {visitForInStatement: function(tree) {
        this.found = true;
      }}, {}, $__super);
  }(FindInFunctionScope);
  function needsTransform(tree, transformOptions) {
    return transformOptions.generators && tree.isGenerator() || transformOptions.asyncFunctions && tree.isAsyncFunction();
  }
  var GeneratorTransformPass = function($__super) {
    function GeneratorTransformPass(identifierGenerator, reporter, options) {
      $traceurRuntime.superConstructor(GeneratorTransformPass).call(this, identifierGenerator, reporter, options);
      this.tranformOptions_ = options.transformOptions;
      this.inBlock_ = false;
    }
    return ($traceurRuntime.createClass)(GeneratorTransformPass, {
      transformFunctionDeclaration: function(tree) {
        if (!needsTransform(tree, this.tranformOptions_))
          return $traceurRuntime.superGet(this, GeneratorTransformPass.prototype, "transformFunctionDeclaration").call(this, tree);
        if (tree.isGenerator())
          return this.transformGeneratorDeclaration_(tree);
        return this.transformFunction_(tree, FunctionDeclaration, null);
      },
      transformGeneratorDeclaration_: function(tree) {
        var nameIdExpression = id(tree.name.identifierToken);
        var setupPrototypeExpression = parseExpression($traceurRuntime.getTemplateObject(["$traceurRuntime.initGeneratorFunction(", ")"]), nameIdExpression);
        var tmpVar = id(this.inBlock_ ? this.getTempIdentifier() : this.addTempVar(setupPrototypeExpression));
        var funcDecl = this.transformFunction_(tree, FunctionDeclaration, tmpVar);
        if (!this.inBlock_)
          return funcDecl;
        return new AnonBlock(null, [funcDecl, parseStatement($traceurRuntime.getTemplateObject(["var ", " = ", ""]), tmpVar, setupPrototypeExpression)]);
      },
      transformFunctionExpression: function(tree) {
        if (!needsTransform(tree, this.tranformOptions_))
          return $traceurRuntime.superGet(this, GeneratorTransformPass.prototype, "transformFunctionExpression").call(this, tree);
        if (tree.isGenerator())
          return this.transformGeneratorExpression_(tree);
        return this.transformFunction_(tree, FunctionExpression, null);
      },
      transformGeneratorExpression_: function(tree) {
        var name;
        if (!tree.name) {
          name = createIdentifierToken(this.getTempIdentifier());
          tree = new FunctionExpression(tree.location, createBindingIdentifier(name), tree.functionKind, tree.parameterList, tree.typeAnnotation, tree.annotations, tree.body);
        } else {
          name = tree.name.identifierToken;
        }
        var functionExpression = this.transformFunction_(tree, FunctionExpression, id(name));
        return parseExpression($traceurRuntime.getTemplateObject(["$traceurRuntime.initGeneratorFunction(", ")"]), functionExpression);
      },
      transformFunction_: function(tree, constructor, nameExpression) {
        var body = $traceurRuntime.superGet(this, GeneratorTransformPass.prototype, "transformAny").call(this, tree.body);
        var finder = new ForInFinder();
        finder.visitAny(body);
        if (finder.found) {
          body = new ForInTransformPass(this.identifierGenerator, this.reporter, this.options).transformAny(body);
        }
        if (this.tranformOptions_.generators && tree.isGenerator()) {
          body = GeneratorTransformer.transformGeneratorBody(this.identifierGenerator, this.reporter, this.options, body, nameExpression);
        } else if (this.tranformOptions_.asyncFunctions && tree.isAsyncFunction()) {
          body = AsyncTransformer.transformAsyncBody(this.identifierGenerator, this.reporter, this.options, body);
        }
        var functionKind = null;
        return new constructor(tree.location, tree.name, functionKind, tree.parameterList, tree.typeAnnotation || null, tree.annotations || null, body);
      },
      transformArrowFunction: function(tree) {
        if (!tree.isAsyncFunction())
          return $traceurRuntime.superGet(this, GeneratorTransformPass.prototype, "transformArrowFunction").call(this, tree);
        return this.transformAny(ArrowFunctionTransformer.transform(this, tree));
      },
      transformBlock: function(tree) {
        var inBlock = this.inBlock_;
        this.inBlock_ = true;
        var rv = $traceurRuntime.superGet(this, GeneratorTransformPass.prototype, "transformBlock").call(this, tree);
        this.inBlock_ = inBlock;
        return rv;
      }
    }, {}, $__super);
  }(TempVarTransformer);
  return {get GeneratorTransformPass() {
      return GeneratorTransformPass;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/InlineModuleTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/InlineModuleTransformer.js";
  var VAR = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/InlineModuleTransformer.js")).VAR;
  var ModuleTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ModuleTransformer.js", "traceur@0.0.108/src/codegeneration/InlineModuleTransformer.js")).ModuleTransformer;
  var $__3 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/InlineModuleTransformer.js")),
      createBindingIdentifier = $__3.createBindingIdentifier,
      createEmptyStatement = $__3.createEmptyStatement,
      createFunctionBody = $__3.createFunctionBody,
      createImmediatelyInvokedFunctionExpression = $__3.createImmediatelyInvokedFunctionExpression,
      createScopedExpression = $__3.createScopedExpression,
      createVariableStatement = $__3.createVariableStatement;
  var globalThis = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./globalThis.js", "traceur@0.0.108/src/codegeneration/InlineModuleTransformer.js")).default;
  var scopeContainsThis = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./scopeContainsThis.js", "traceur@0.0.108/src/codegeneration/InlineModuleTransformer.js")).default;
  var anonInlineModules = 0;
  var InlineModuleTransformer = function($__super) {
    function InlineModuleTransformer() {
      $traceurRuntime.superConstructor(InlineModuleTransformer).apply(this, arguments);
    }
    return ($traceurRuntime.createClass)(InlineModuleTransformer, {
      wrapModule: function(statements) {
        var seed = this.moduleName || 'anon_' + ++anonInlineModules;
        var idName = this.getTempVarNameForModuleName(seed);
        var body = createFunctionBody(statements);
        var moduleExpression;
        if (statements.some(scopeContainsThis)) {
          moduleExpression = createScopedExpression(body, globalThis());
        } else {
          moduleExpression = createImmediatelyInvokedFunctionExpression(body);
        }
        return [createVariableStatement(VAR, idName, moduleExpression)];
      },
      transformNamedExport: function(tree) {
        return createEmptyStatement();
      },
      transformModuleSpecifier: function(tree) {
        return createBindingIdentifier(this.getTempVarNameForModuleSpecifier(tree));
      }
    }, {}, $__super);
  }(ModuleTransformer);
  return {get InlineModuleTransformer() {
      return InlineModuleTransformer;
    }};
});
$traceurRuntime.registerModule("traceur@0.0.108/src/codegeneration/InstantiateModuleTransformer.js", [], function() {
  "use strict";
  var __moduleName = "traceur@0.0.108/src/codegeneration/InstantiateModuleTransformer.js";
  var $__10 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTrees.js", "traceur@0.0.108/src/codegeneration/InstantiateModuleTransformer.js")),
      AnonBlock = $__10.AnonBlock,
      ArrayLiteral = $__10.ArrayLiteral,
      ClassExpression = $__10.ClassExpression,
      CommaExpression = $__10.CommaExpression,
      ExpressionStatement = $__10.ExpressionStatement,
      VariableDeclaration = $__10.VariableDeclaration;
  var $__11 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/trees/ParseTreeType.js", "traceur@0.0.108/src/codegeneration/InstantiateModuleTransformer.js")),
      ANON_BLOCK = $__11.ANON_BLOCK,
      CLASS_DECLARATION = $__11.CLASS_DECLARATION,
      FUNCTION_DECLARATION = $__11.FUNCTION_DECLARATION,
      IDENTIFIER_EXPRESSION = $__11.IDENTIFIER_EXPRESSION,
      IMPORT_SPECIFIER_SET = $__11.IMPORT_SPECIFIER_SET,
      NAME_SPACE_IMPORT = $__11.NAME_SPACE_IMPORT;
  var ParseTreeVisitor = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/ParseTreeVisitor.js", "traceur@0.0.108/src/codegeneration/InstantiateModuleTransformer.js")).ParseTreeVisitor;
  var ScopeTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ScopeTransformer.js", "traceur@0.0.108/src/codegeneration/InstantiateModuleTransformer.js")).ScopeTransformer;
  var $__14 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ParseTreeFactory.js", "traceur@0.0.108/src/codegeneration/InstantiateModuleTransformer.js")),
      createEmptyParameterList = $__14.createEmptyParameterList,
      createFunctionBody = $__14.createFunctionBody,
      createFunctionExpression = $__14.createFunctionExpression,
      id = $__14.createIdentifierExpression,
      createObjectLiteralForDescriptor = $__14.createObjectLiteralForDescriptor,
      createUseStrictDirective = $__14.createUseStrictDirective,
      createVariableDeclarationList = $__14.createVariableDeclarationList,
      createVariableStatement = $__14.createVariableStatement;
  var ModuleTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./ModuleTransformer.js", "traceur@0.0.108/src/codegeneration/InstantiateModuleTransformer.js")).ModuleTransformer;
  var $__16 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("../syntax/TokenType.js", "traceur@0.0.108/src/codegeneration/InstantiateModuleTransformer.js")),
      MINUS_MINUS = $__16.MINUS_MINUS,
      PLUS_PLUS = $__16.PLUS_PLUS,
      VAR = $__16.VAR;
  var $__17 = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./PlaceholderParser.js", "traceur@0.0.108/src/codegeneration/InstantiateModuleTransformer.js")),
      parseExpression = $__17.parseExpression,
      parseStatement = $__17.parseStatement,
      parseStatements = $__17.parseStatements;
  var HoistVariablesTransformer = $traceurRuntime.getModule($traceurRuntime.normalizeModuleName("./HoistVariablesTransformer.js", "traceur@0.0.108/src/codegeneration/InstantiateModuleTransformer.js")).default;
  function flattenAnonBlocks(statements) {
    var $__9;
    var result = [];
    for (var i = 0; i < statements.length; i++) {
      var statement = statements[i];
      if (statement.type === ANON_BLOCK) {
        ($__9 = result).push.apply($__9, $traceurRuntime.spread(statement.statements));
      } else {
        result.push(statement);
      }
    }
    return result;
  }
  var ExportBindingsVisitor = function($__super) {
    function ExportBindingsVisitor() {
      $traceurRuntime.superConstructor(ExportBindingsVisitor).call(this);
      this.bindings = [];
    }
    return ($traceurRuntime.createClass)(ExportBindingsVisitor, {
      visitVariableDeclaration: function(tree) {
        this.visitAny(tree.lvalue);
      },
      visitBindingIdentifier: function(tree) {
        this.bindings.push(tree);
      },
      visitBindingElement: function(tree) {
        this.visitAny(tree.binding);
      }
    }, {}, $__super);
  }(ParseTreeVisitor);
  var DeclarationExtractionTransformer = function($__super) {
    function DeclarationExtractionTransformer() {
      $traceurRuntime.superConstructor(DeclarationExtractionTransformer).call(this);
      this.declarations_ = [];
    }
    return ($traceurRuntime.createClass)(DeclarationExtractionTransformer, {
      getDeclarationStatements: function() {
        return flattenAnonBlocks($traceurRuntime.spread([this.getVariableStatement()], this.declarations_));
      },
      addDeclaration: function(tree) {
        this.declarations_.push(tree);
      },
      transformFunctionDeclaration: function(tree) {
        this.addDeclaration(tree);
        return new AnonBlock(null, []);
      },
      transformClassDeclaration: function(tree) {
        this.addVariable(tree.name.identifierToken.value);
        tree = new ClassExpression(tree.location, tree.name, tree.superClass, tree.elements, tree.annotations, tree.typeParameters);
        return parseStatement($traceurRuntime.getTemplateObject(["", " = ", ""]), tree.name.identifierToken, tree);
      }
    }, {}, $__super);
  }(HoistVariablesTransformer);
  var ModuleNameIdentifierTransformer = function($__super) {
    function ModuleNameIdentifierTransformer() {
      $traceurRuntime.superConstructor(ModuleNameIdentifierTransformer).call(this, '__moduleName');
      this.usesModuleName = false;
    }
    return ($traceurRuntime.createClass)(ModuleNameIdentifierTransformer, {transformIdentifierExpression: function(tree) {
        if (tree.identifierToken.value === '__moduleName') {
          this.usesModuleName = true;
          return parseExpression($traceurRuntime.getTemplateObject(["$__moduleContext.id"]));
        }
        return $traceurRuntime.superGet(this, ModuleNameIdentifierTransformer.prototype, "transformIdentifierExpression").call(this, tree);
      }}, {}, $__super);
  }(ScopeTransformer);
  var InsertBindingAssignmentTransformer = function($__super) {
    function InsertBindingAssignmentTransformer(exportName, bindingName) {
      $traceurRuntime.superConstructor(InsertBindingAssignmentTransformer).call(this, bindingName);
      this.bindingName_ = bindingName;
      this.exportName_ = exportName;
    }
    return ($traceurRuntime.createClass)(InsertBindingAssignmentTransformer, {
      matchesBindingName_: function(binding) {
        return binding.type === IDENTIFIER_EXPRESSION && binding.identifierToken.value === this.bindingName_;
      },
      transformUnaryExpression: function(tree) {
        if (!this.matchesBindingName_(tree.operand))
          return $traceurRuntime.superGet(this, InsertBindingAssignmentTransformer.prototype, "transformUnaryExpression").call(this, tree);
        var operatorType = tree.operator.type;
        if (operatorType !== PLUS_PLUS && operatorType !== MINUS_MINUS)
          return $traceurRuntime.superGet(this, InsertBindingAssignmentTransformer.prototype, "transformUnaryExpression").call(this, tree);
        var operand = this.transformAny(tree.operand);
        if (operand !== tree.operand)
          tree = new UnaryExpression(tree.location, tree.operator, operand);
        return parseExpression($traceurRuntime.getTemplateObject(["$__export(", ", ", ")"]), this.exportName_, tree);
      },
      transformPostfixExpression: function(tree) {
        tree = $traceurRuntime.superGet(this, InsertBindingAssignmentTransformer.prototype, "transformPostfixExpression").call(this, tree);
        if (!this.matchesBindingName_(tree.operand))
          return tree;
        switch (tree.operator.type) {
          case PLUS_PLUS:
            return parseExpression($traceurRuntime.getTemplateObject(["($__export(", ", ", " + 1), ", ")"]), this.exportName_, tree.operand, tree);
          case MINUS_MINUS:
            return parseExpression($traceurRuntime.getTemplateObject(["($__export(", ", ", " - 1), ", ")"]), this.exportName_, tree.operand, tree);
        }
        return tree;
      },
      transformBinaryExpression: function(tree) {
        tree = $traceurRuntime.superGet(this, InsertBindingAssignmentTransformer.prototype, "transformBinaryExpression").call(this, tree);
        if (!tree.operator.isAssignmentOperator())
          return tree;
        if (!this.matchesBindingName_(tree.left))
          return tree;
        return parseExpression($traceurRuntime.getTemplateObject(["$__export(", ", ", ")}"]), this.exportName_, tree);
      }
    }, {}, $__super);
  }(ScopeTransformer);
  var InstantiateModuleTransformer = function($__super) {
    function InstantiateModuleTransformer(identifierGenerator, reporter) {
      var options = arguments[2];
      $traceurRuntime.superConstructor(InstantiateModuleTransformer).call(this, identifierGenerator, reporter, options);
      this.anonymousModule = options && !options.bundle && options.moduleName !== true;
      this.usesModuleName = false;
      this.inExport_ = false;
      this.curDepIndex_ = null;
      this.dependencies = [];
      this.externalExportBindings = [];
      this.importBindings = [];
      this.localExportBindings = [];
      this.functionDeclarations = [];
      this.moduleBindings = [];
      this.exportStarBindings = [];
    }
    return ($traceurRuntime.createClass)(InstantiateModuleTransformer, {
      getModuleName: function(tree) {
        if (this.anonymousModule)
          return null;
        return tree.moduleName;
      },
      moduleProlog: function() {
        return [];
      },
      wrapModule: function(statements) {
        var prolog = [createUseStrictDirective()];
        statements = prolog.concat(statements);
        if (this.usesModuleName) {
          if (this.moduleName) {
            return parseStatements($traceurRuntime.getTemplateObject(["System.register(", ",\n            ", ", function($__export, $__moduleContext) {\n              ", "\n            });"]), this.moduleName, this.dependencies, statements);
          }
          return parseStatements($traceurRuntime.getTemplateObject(["System.register(", ", function($__export, $__moduleContext) {\n            ", "\n          });"]), this.dependencies, statements);
        }
        if (this.moduleName) {
          return parseStatements($traceurRuntime.getTemplateObject(["System.register(", ",\n          ", ", function($__export) {\n            ", "\n          });"]), this.moduleName, this.dependencies, statements);
        }
        return parseStatements