"use strict";
/**
 *
 */
var Disposable_1 = require('./Disposable');
var CompositeDisposable = (function () {
    function CompositeDisposable() {
        var _this = this;
        var disposables = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            disposables[_i - 0] = arguments[_i];
        }
        this._disposables = new Set();
        this._isDisposed = false;
        disposables.forEach(function (item) { return _this._disposables.add(item); });
    }
    Object.defineProperty(CompositeDisposable.prototype, "isDisposed", {
        get: function () {
            return this._isDisposed;
        },
        enumerable: true,
        configurable: true
    });
    CompositeDisposable.prototype.dispose = function () {
        this._isDisposed = true;
        if (this._disposables.size) {
            this._disposables.forEach(function (disposable) { return Disposable_1.Disposable.of(disposable).dispose(); });
            this._disposables.clear();
        }
    };
    CompositeDisposable.prototype.add = function () {
        var _this = this;
        var disposables = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            disposables[_i - 0] = arguments[_i];
        }
        if (this.isDisposed) {
            disposables.forEach(function (item) { return Disposable_1.Disposable.of(item).dispose(); });
        }
        else {
            disposables.forEach(function (item) { return _this._disposables.add(item); });
        }
        return this;
    };
    CompositeDisposable.prototype.remove = function (disposable) {
        this._disposables.delete(disposable);
        return this;
    };
    return CompositeDisposable;
}());
exports.CompositeDisposable = CompositeDisposable;
//# sourceMappingURL=CompositeDisposable.js.map