/**
 *
 */
export interface IDisposable {
    dispose(): void;
}
export interface ISubscription {
    unsubscribe(): void;
}
export declare function isDisposable(value: any): value is IDisposable;
export declare function isSubscription(value: any): value is ISubscription;
export declare function canBeDisposed(value: any): value is IDisposableOrSubscription;
export declare type IDisposableOrSubscription = IDisposable | ISubscription | (() => void);
export declare class Disposable implements IDisposable {
    static readonly empty: Disposable;
    static of(value: any): IDisposable;
    static create(action: () => void): Disposable;
    private _action;
    private _isDisposed;
    constructor(value: IDisposableOrSubscription);
    readonly isDisposed: boolean;
    dispose(): void;
}
