"use strict";
function isDisposable(value) {
    return !!value.dispose;
}
exports.isDisposable = isDisposable;
function isSubscription(value) {
    return !!value.unsubscribe;
}
exports.isSubscription = isSubscription;
function canBeDisposed(value) {
    return !!(value.dispose || value.unsubscribe) || typeof value === 'function';
}
exports.canBeDisposed = canBeDisposed;
var empty;
var Disposable = (function () {
    /* tslint:disable-next-line:no-any */
    function Disposable(value) {
        this._isDisposed = false;
        if (!value) {
            return empty;
        }
        if (typeof value === 'function') {
            this._action = value;
        }
        else if (value.unsubscribe) {
            this._action = function () { return value.unsubscribe(); };
        }
        else if (value.dispose) {
            this._action = function () { return value.dispose(); };
        }
    }
    Object.defineProperty(Disposable, "empty", {
        get: function () { return empty; },
        enumerable: true,
        configurable: true
    });
    /* tslint:disable-next-line:no-reserved-keywords no-any */
    Disposable.of = function (value) {
        if (!value) {
            return empty;
        }
        if (value.dispose) {
            return value;
        }
        return new Disposable(value);
    };
    Disposable.create = function (action) {
        return new Disposable(action);
    };
    Object.defineProperty(Disposable.prototype, "isDisposed", {
        get: function () { return this._isDisposed; },
        enumerable: true,
        configurable: true
    });
    Disposable.prototype.dispose = function () {
        if (!this.isDisposed) {
            this._isDisposed = true;
            this._action();
        }
    };
    return Disposable;
}());
exports.Disposable = Disposable;
empty = new Disposable(function () { });
//# sourceMappingURL=Disposable.js.map