"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
/**
 *
 */
var Disposable_1 = require('./Disposable');
var RefCountDisposable = (function () {
    function RefCountDisposable(underlyingDisposable) {
        this._isDisposed = false;
        this._isPrimaryDisposed = false;
        this._count = 0;
        this._underlyingDisposable = Disposable_1.Disposable.of(underlyingDisposable);
    }
    Object.defineProperty(RefCountDisposable.prototype, "isDisposed", {
        get: function () { return this._isDisposed; },
        enumerable: true,
        configurable: true
    });
    RefCountDisposable.prototype.dispose = function () {
        if (!this.isDisposed && !this._isPrimaryDisposed) {
            this._isPrimaryDisposed = true;
            if (this._count === 0) {
                this._isDisposed = true;
                this._underlyingDisposable.dispose();
            }
        }
    };
    RefCountDisposable.prototype.getDisposable = function () {
        var _this = this;
        if (this.isDisposed) {
            return Disposable_1.Disposable.empty;
        }
        this._count += 1;
        return new InnerDisposable(this, function () {
            _this._count -= 1;
            if (_this._count === 0 && _this._isPrimaryDisposed) {
                _this._isDisposed = true;
                _this._underlyingDisposable.dispose();
            }
        });
    };
    return RefCountDisposable;
}());
exports.RefCountDisposable = RefCountDisposable;
var InnerDisposable = (function (_super) {
    __extends(InnerDisposable, _super);
    function InnerDisposable(_reference, action) {
        _super.call(this, action);
        this._reference = _reference;
    }
    InnerDisposable.prototype.dispose = function () {
        if (!this._reference.isDisposed && !this.isDisposed) {
            _super.prototype.dispose.call(this);
        }
    };
    return InnerDisposable;
}(Disposable_1.Disposable));
//# sourceMappingURL=RefCountDisposable.js.map