"use strict";
var SerialDisposable = (function () {
    function SerialDisposable() {
        this._isDisposed = false;
    }
    Object.defineProperty(SerialDisposable.prototype, "isDisposed", {
        get: function () { return this._isDisposed; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SerialDisposable.prototype, "disposable", {
        get: function () { return this._currentDisposable; },
        set: function (value) {
            var shouldDispose = this.isDisposed;
            if (!shouldDispose) {
                this._currentDisposable = value;
            }
            if (!this.isDisposed) {
                this._currentDisposable = value;
            }
            if (this.isDisposed && value) {
                value.dispose();
            }
        },
        enumerable: true,
        configurable: true
    });
    SerialDisposable.prototype.dispose = function () {
        if (!this.isDisposed) {
            this._isDisposed = true;
            var old = this._currentDisposable;
            this._currentDisposable = null;
            if (old) {
                old.dispose();
            }
        }
    };
    return SerialDisposable;
}());
exports.SerialDisposable = SerialDisposable;
//# sourceMappingURL=SerialDisposable.js.map