"use strict";
var SingleAssignmentDisposable = (function () {
    function SingleAssignmentDisposable() {
        this._isDisposed = false;
    }
    Object.defineProperty(SingleAssignmentDisposable.prototype, "isDisposed", {
        get: function () { return this._isDisposed; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SingleAssignmentDisposable.prototype, "disposable", {
        get: function () { return this._currentDisposable; },
        set: function (value) {
            if (this._currentDisposable) {
                throw new Error('Disposable has already been assigned');
            }
            if (!this.isDisposed) {
                this._currentDisposable = value;
            }
            if (this.isDisposed && value) {
                value.dispose();
            }
        },
        enumerable: true,
        configurable: true
    });
    SingleAssignmentDisposable.prototype.dispose = function () {
        if (!this.isDisposed) {
            this._isDisposed = true;
            var old = this._currentDisposable;
            this._currentDisposable = null;
            if (old) {
                old.dispose();
            }
        }
    };
    return SingleAssignmentDisposable;
}());
exports.SingleAssignmentDisposable = SingleAssignmentDisposable;
//# sourceMappingURL=SingleAssignmentDisposable.js.map