Feature: Type Saftey

As a Node.js + TypeScript + node-java developer
I want to understand how Typescript offers type saftey.

Node-java by default supports sync and async variants of all
java methods, with async given preference over sync due to
the choice that unadorned method names denote the async method.
Sync methods are available by attaching the suffix Sync to
the method name.

But node-java provides the ability to modify this behavior by
setting the java.asyncOptions property. Modules generated by
ts-java use this feature to specify different conventions
for methods variants. Sync methods are denoted with no suffix,


  Background:
    Given this boilerplate to intialize node-java:
    """
    import java = require('../tsJavaModule');
    import Java = java.Java;

    Java.ensureJvm().then(() => {
      var SomeClass = Java.import('com.redseal.featureset.SomeClass');
      var something: Java.SomeInterface = new SomeClass();
      {{{ scenario_snippet }}}
    });

    """

  Scenario: ts-java generated modules do not use the Sync suffix
    Given the above boilerplate with following scenario snippet:
    """
    // If you're used to node-java conventions, you might mistakenly use the Sync suffix:
    var str: string = something.getStringSync();
    """
    When compiled it produces this error containing this snippet:
    """
    TS2339: Property 'getStringSync' does not exist on type 'SomeInterface'
    """

  Scenario: Omitting the A suffix for async calls
    Given the above boilerplate with following scenario snippet:
    """
    // The the error here is forgetting the supply the callback function
    something.getStringA();
    """
    When compiled it produces this error containing this snippet:
    """
    error TS2346: Supplied parameters do not match any signature of call target
    """

  Scenario: Expecting a function result with async calls
    Given the above boilerplate with following scenario snippet:
    """
    // The error here is expecting a function result
    var str: string = something.getStringA((err: Error, str: string) => console.log(str));
    """
    When compiled it produces this error containing this snippet:
    """
    error TS2322: Type 'void' is not assignable to type 'string'.
    """

  Scenario: Omitting the P suffix for a method returning a promise
    Given the above boilerplate with following scenario snippet:
    """
    // Another mistake is to want a promise but forgetting the P suffix:
    something.getString().then((str: string) => console.log(str));
    """
    When compiled it produces this error containing this snippet:
    """
    error TS2339: Property 'then' does not exist on type 'string'
    """

  Scenario: Just plain old wrong type
    Given the above boilerplate with following scenario snippet:
    """
    // Here we simply declare the wrong return type for the given function call.
    var str: string = something.getInt();
    """
    When compiled it produces this error containing this snippet:
    """
    error TS2322: Type 'number' is not assignable to type 'string'.
    """

