var assert = require('assert');
var java = require('../tsJavaModule');
var util = require('util');
var Java = java.Java;
Java.ensureJvm().then(function () {
    var SomeClass = Java.importClass('com.redseal.featureset.SomeClass');
    var something = new SomeClass();
    var num = something.getLong();
    assert.strictEqual(typeof num, 'object');
    assert.strictEqual(num.longValue, '9223372036854775807');
    assert.equal(num, 9223372036854776000);
    var formatted = util.inspect(num);
    assert.strictEqual(formatted, '{ [Number: 9223372036854776000] longValue: \'9223372036854775807\' }');
});
//# sourceMappingURL=Java_functions_returning_long_values_return_javascript_objects_containing_both_a_number_and_a_string.js.map