
import assert = require('assert');
import java = require('../tsJavaModule');
import util = require('util');

import Java = java.Java;

Java.ensureJvm().then(() => {
  var SomeClass = Java.importClass('com.redseal.featureset.SomeClass');
  var something: Java.SomeInterface = new SomeClass();
  var num: Java.longValue_t = something.getLong();
assert.strictEqual(typeof num, 'object');
assert.strictEqual(num.longValue, '9223372036854775807');
assert.equal(num, 9223372036854776000);

var formatted: string = util.inspect(num);
assert.strictEqual(formatted, '{ [Number: 9223372036854776000] longValue: \'9223372036854775807\' }');
});
