var assert = require('assert');
var java = require('../tsJavaModule');
var Java = java.Java;
Java.ensureJvm().then(function () {
    var SomeClass = Java.importClass('com.redseal.featureset.SomeClass');
    var something = new SomeClass();
    // Node-java always converts wrapper class instances for primitive types to
    // the corresponding primitive types, even via newInstance().
    var str = Java.newInstance('java.lang.String', 'hello');
    assert.strictEqual(typeof str, 'string');
    assert.strictEqual(str, 'hello');
    var num = Java.newInstance('java.lang.Integer', 42);
    assert.strictEqual(typeof num, 'number');
    assert.strictEqual(num, 42);
    Java.newInstanceA('java.lang.Double', 2.71828, function (err, num) {
        assert.strictEqual(typeof num, 'number');
        assert.strictEqual(num, 2.71828);
    });
});
//# sourceMappingURL=Node_java_always_converts_wrapped_primitives_to_javascript_primitives.js.map