
import assert = require('assert');
import java = require('../tsJavaModule');
import util = require('util');

import Java = java.Java;

Java.ensureJvm().then(() => {
  var SomeClass = Java.importClass('com.redseal.featureset.SomeClass');
  var something: Java.SomeInterface = new SomeClass();
  // Node-java always converts wrapper class instances for primitive types to
// the corresponding primitive types, even via newInstance().
var str: string = Java.newInstance('java.lang.String', 'hello');
assert.strictEqual(typeof str, 'string');
assert.strictEqual(str, 'hello');

var num: number = Java.newInstance('java.lang.Integer', 42);
assert.strictEqual(typeof num, 'number');
assert.strictEqual(num, 42);

Java.newInstanceA('java.lang.Double', 2.71828, (err: Error, num: number) => {
  assert.strictEqual(typeof num, 'number');
  assert.strictEqual(num, 2.71828);
});
});
