var assert = require('assert');
var java = require('../tsJavaModule');
var util = require('util');
var Java = java.Java;
Java.ensureJvm().then(function () {
    var SomeClass = Java.importClass('com.redseal.featureset.SomeClass');
    var something = new SomeClass();
    var result;
    // Each of the getFooObject() methods below is declared to return a java.lang.Object,
    // but actually returns a specific type that can be coerced to a javascript type.
    // The special type Java.object_t makes it easy to work with such results.
    // Note that Java.object_t is declared as:
    // type object_t = java.lang.Object | string | number | longValue_t;
    result = something.getStringObject();
    assert.strictEqual(typeof result, 'string');
    assert.strictEqual(result, 'A String');
    result = something.getShortObject();
    assert.strictEqual(typeof result, 'number');
    assert.strictEqual(result, 42);
    result = something.getDoubleObject();
    assert.strictEqual(typeof result, 'number');
    assert.strictEqual(result, 3.141592653589793);
    result = something.getLongObject();
    assert.strictEqual(typeof result, 'object');
    assert.strictEqual(result.longValue, '9223372036854775807');
    assert.equal(result, 9223372036854776000);
    var formatted = util.inspect(result);
    assert.strictEqual(formatted, '{ [Number: 9223372036854776000] longValue: \'9223372036854775807\' }');
});
//# sourceMappingURL=Object_function_results_will_be_converted_to_primitive_types_when_appropriate.js.map