/// <reference path='../../typings/node/node.d.ts' />

import assert = require('assert');
import BluePromise = require('bluebird');
import java = require('../tsJavaModule');

import Java = java.Java;
import Thing1 = Java.com.redseal.featureset.Thing;
import Thing2 = Java.com.redseal.featureset.ambiguous.Thing;

Java.ensureJvm().then(() => {
  var thing1: Thing1 = Java.newInstance('com.redseal.featureset.Thing', 42);
assert.equal(thing1.toString(), 'Thing42');
assert(Java.instanceOf(thing1, 'com.redseal.featureset.Thing'));

var thing2: Thing2 = Java.newInstance('com.redseal.featureset.ambiguous.Thing', 'foo');
assert.equal(thing2.toString(), 'Ambiguous Thing foo');
assert(Java.instanceOf(thing2, 'com.redseal.featureset.ambiguous.Thing'));
});
