/// <reference path='../../typings/lodash/lodash.d.ts' />
var _ = require('lodash');
var assert = require('assert');
var java = require('../tsJavaModule');
var Java = java.Java;
Java.ensureJvm().then(function () {
    var Arrays = Java.importClass('java.util.Arrays');
    var SomeClass = Java.importClass('com.redseal.featureset.SomeClass');
    var something = new SomeClass();
    var clazz = something.getClass();
    var methods = clazz.getDeclaredMethods();
    assert.ok(_.isArray(methods));
    assert.ok(methods.length > 0);
    _.forEach(methods, function (method) { return assert.ok(Java.instanceOf(method, 'java.lang.reflect.Method')); });
});
//# sourceMappingURL=Getting_1d_array_of_non_primitive_type.js.map